﻿USE sofia;
DROP TABLE IF EXISTS sofia.ury_vpl;
CREATE TABLE ury_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ury_vpl WRITE;
INSERT INTO ury_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kristus Yesus, Zen teipsïn zini Daud Bak mo Auyan-tane. Zëno auyan-aza mo ausuna, zen Abraham Bak onakon de aïtbinkim kon gwesibir hanankam: ");
INSERT INTO ury_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Isaksa wë taka. Isak hwëna Yakobsa wë taka. Zen hwëna beyana dua-blas enkam wei-wik gulku. Ahana bosena Yehuda, ");
INSERT INTO ury_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","zen hwëna Peres ne Zera neka wë soka– wenya bosena Tamar hon. Hwëna Peres zep Hezronsa wë taka. Zen hwëna Ramsa wë taka. ");
INSERT INTO ury_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram hwëna Aminadabsa wë taka. Zen hwëna Nahasonsa wë taka. Zen hwëna Salmonsa wë taka. ");
INSERT INTO ury_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon hwëna Boassa wë taka– Rahab hon. Boas hwëna Obedsa wë taka– Rut hon. Zen hwëna Isaesa wë taka. ");
INSERT INTO ury_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai hwëna teipsïn zini Daud Baksa wë taka. Teipsïn zini Daud Bak onakon hëndep in kim Israel mo auyan-azasa Babel san dep asaskam kap nulhak– zao de lowehe gwen hap, zëno mae mo bosem-sesa de aïtbinni an zen: Daud Salomosa wë taka– Uria mo we nala Batsyeba hon. ");
INSERT INTO ury_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo hwëna Rehabeyamsa wë taka. Zen hwëna Abiasa wë taka. Abia hwëna Asa Baksa wë taka. ");
INSERT INTO ury_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Zen hwëna Yosafatsa wë taka. Hwëna Yosafat Yoramsa wë taka. Zen hwëna Uzia Baksa wë taka. ");
INSERT INTO ury_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia hwëna Yotamsa wë taka. Zen hwëna Ahas Baksa wë taka. Ahas hwëna Hiskiasa wë taka. ");
INSERT INTO ury_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Zen hwëna Manasyesa wë taka. Manasye hwëna Amon Baksa wë taka. Zen hwëna Yosia Baksa wë taka. ");
INSERT INTO ury_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia hwëna nonol Yekonyasa wë taka. Zao zep hen etan oso wal zemka wei-wik gulku. Israelk de zini kim holokam Alapsa hli dak, dekam zep Babelk de jana nabare zini teipsïn zini Yekonyasa zëre mae mo lang san dep nërhak, hen Israelk de zini beya tangankam asaskam zao kang nuk. ");
INSERT INTO ury_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Yekonya hwëna Babelk zep Sealtielsa wë taka. Zao kim 70 tahun enkam lowehek, ki zep etan tapbla nuk. Sealtiel hwëna Zerubabelsa zep wë taka. ");
INSERT INTO ury_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel hwëna Abihudsu zep wë taka. Zen hwëna Elyakimsi zep wë taka. Elyakim hwëna Azor Baksa zep wë taka. ");
INSERT INTO ury_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Zen hwëna Zadoksa zep wë taka. Zadok hwëna Akimsi zep wë taka. Zen hwëna Eliudsu zep wë taka. ");
INSERT INTO ury_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud hwëna Eleazarsa zep wë taka. Zen hwëna Matansa zep wë taka. Matan hwëna aha zini Yakobsa zep wë taka. ");
INSERT INTO ury_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakob hwëna Maria mo zini Yusupsu zep wë taka. Maria zep Yesussu wë tak– Insa “Kristus”kum en gweblananke. ");
INSERT INTO ury_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Zep Abraham onakon de auyan-azasa aïtbir hankam Daud osan dep beyana kïtak empat-blas enkam. Hen Daud onakon de aïtbir hankam Israelsa de asaskam Babelk kang gun sun dep, beyana hen empat-blas enkam. Hen dekon de etan lwan dahal zannak Kristus Yesussu de jaha gwen san dep aïtbir hankam, beyana hen empat-blas enkam. ");
INSERT INTO ury_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kristus Yesussu de jaha gwenna in, zen ausuna a kirekam mo lwakye: An zem in Maria, zen Yusup hup de golgu gweblanna. Hwëna nama de gon srëmnak zep u gwek. Hwëna Yusup hom anakan tame guꞌunka, “Zen Alap mo Enho mo sosonkam u gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusup man tangan Musa mo tïtï tabin ola blikip gwesïk gwibirki, zep Mariasa zë-en enlala gwibiꞌinka, “Ëe molyë gok, sap zen malinkim u gweꞌan.” Zen dekam zep enlala gweꞌanka, “Damnak de kira gwenkam, ki Maria mo bosena sa karek gwer. Zep sowëkam asa gubir, ‘Ëe ama emsa baes gwibiꞌin.’” ");
INSERT INTO ury_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Zen kim dam gulsuku, “Asa ki Mariasa baes gwibir,” hwëna dekam zep ni tannak eisirkim Alap mo dam taha nakore zini gublu zaka, “Yusup, Daud Bak mo auyan-tane, bahem Mariasa de gon hap baes gwen. Sap Walasna insa u gweꞌan, Zen Alap mo Enho mo sosonkam dena. ");
INSERT INTO ury_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Zen zi walassa sa jaha gwer. Em Yesuskum bose ta, sap Zen in Zen sa zëre mo hlï irin zini ngaya tabiri– zëno mae mo karek-kareksa de ngan gulsuzimdinkim.” ");
INSERT INTO ury_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","An kïtak Alap Zën ki syal gwibirki– zëre mo ol ayang gul gwen zini Yesaya mo alenak dikim zaun hup, mensa Zëna anakan gu-gublukake, ");
INSERT INTO ury_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Zi niban de gaïng ën srëm wenam seiwiri sa u gwer, hëndep zi walassa sa jaha gwer. Walasna in ‘Imanuel’kam sa bose dal.” Yesaya insa “Imanuel”kam gubluka, zen Ibrani olkam. Zëno enlalana, “Alap Zën nësa golëlowehe gweꞌara.” ");
INSERT INTO ury_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","25","Ni tan nakon kim luweka, hëndep in kirekam Alap mo dam taha nakore zini in tonblaka, desan zep ki hëndep ang gweka. Hwëna Maria kim jaha gwe srëm gweꞌak, zen hom dekam nini apdekam laꞌak. Walasna insa kim jaha gwek, Yusup dekam zep “Yesus”kum bose taka. ");
INSERT INTO ury_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesussu kim Yerusalem mo langnak de ëna Betlehemk jaha gwek, dekam teipsïnkïm Herodes ïrïk gïlkï. Hwëna dekam zep keis nikon de dam gulsuk gwen zini Yerusalemk yaïng gwezak. Zini in Israel kore naka hom. Zëno mae mo langna yakla hata sezan san dekam. ");
INSERT INTO ury_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Zen zao zep ëtakensïzïk, “Yahudisa de teipsïnkïm ïrïk gïn hïp de walasna in, endawe nër hom jaha gwek? Ëe keissië yakla hata sezan san hla la gweꞌan– dekon de dam tasïn hïpye. Zen in zebë yaïng gwezal– walasna insa de bokle kom tablan naban isrip-sri gweblan hap.” ");
INSERT INTO ury_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Teipsïn zini Herodes kim kirekam salka, ausa zep hloka. Hen tïngare Yerusalemk de zini kim kirekam ësaladak ausa zep ëhlondak. ");
INSERT INTO ury_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodes dekam zep Alap mo golak de syal tan zi mo mam-mamna hen Musa mo olsa de tawa ta gwibin wenya zëbon de tagal gwen hap gubiridaka. Zao zep takensibiridaka, “Alap mo hamal hap de ola kon, nësa de ngaya tabin hip de Teipsïn Zini, Zen endawe sa an zem jaha gwer?” ");
INSERT INTO ury_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ki zep ding nulblik, “Sap diki Yerusalem mo langna Betlehemk de jaha gwen hap, sap Alap mo ol ayang gul gwen zi mo alenak man lwak, ");
INSERT INTO ury_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Yehuda mo auyan-aza mo ëna in, Betlehem, zen ëna sap betekna– tïngare Yehuda mo langnak de ë-ë nakonye. Hwëna lamkam zëno bosena sa tangan yawal gwera, sap ano hlïl irin wenya Israelsa de zaho ta gwibin hip de Zini, Zen zëwe sa zëre mae mo ngïrïn klesnak jaha gwer.’” ");
INSERT INTO ury_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herodes kim kirekam zëbon mae salka, dekam zep yakla hata sezan nakore keis nikon de dam gulsuk gwen zini insa sowëkam gu sonebiridaka– zëbon de yaïng gwezan hap. Zao zep takensibiridaka, “Keisni in bawalkame nonol hla lak?” ");
INSERT INTO ury_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kim takensibiridasïkï, ki zep gubiridaka, “Emki Betlehem san sek gwen. Zao walas tola insa dawem enkam lëblak. Zao de hla tankam, asa etan en gublu kïnzïk– ëe akakim hen song gwek, bokle kom soblan naban de hen isrip-sri gweblan hap.” ");
INSERT INTO ury_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ki zep hëndep sek gwek, ki zep hen keisni mensa yakla hata sezan san nonol hla dak, etan hla dak. Dekam tangan zep ëisrip-sri gweꞌak, sap keisni in man ngeirbiridaꞌanka. Hëndep walas tola in zao gola taꞌanka, zao en zep keisni in mo ngatanna zïlsïꞌïnka. ");
INSERT INTO ury_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Gola iwe kim bïtï gwek, zao zep walas tola insa an zem Maria han nakeꞌak. Zao zep hëndep ëutuk gwe hezan naban boklena kom dablazak. Dekam zep zëre mae mo honnak de kire-kire bïtï tahal zanna zëbe hap deisweblak, hëndep dekam zep zëbe hap kap dablak– emasna, ir ase dawem nabare te kïlï, hen ahana obat hap de te kïl dawemsa. ");
INSERT INTO ury_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Hwëna hla tan srëmnak Alap mes eisirkim anakan enlala sobiridaka, “Herodes osan bahem etan lwan dahan.” Zep hëndep aha ora san zëre mae mo lang san dep lwan dahak. ");
INSERT INTO ury_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Keis nikon de dam gulsuk gwen wenya in kim lwan dahak, Alap mo dam taha nakore zini ki zep eisirkim Yusup hon hata zaka. Zao zep gubluka, “Em luwen. Herodes man angkam eno nik mo walasna ansa tan hap de tëblan hap kalang gweꞌara. Walas tola insa em Mesir sin dep ërheya gwen. Zao holokam ërgwë. Etan aen asa ebon hatazal– dekam de emsa anakan guzimdin hip, ‘Angkam sap esa etan ërlwa hala.’” ");
INSERT INTO ury_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yusup kim luwe zaka, dekam zep hëndep kam ërheya gwek. ");
INSERT INTO ury_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Zao zep ërgwë gwek, hëndep Herodes tïlkï. Zen kïtak Alap mo dwam gwibin sin ki lwak– Alap mo ol ayang gul gwen zini men kirekam Yesus hup dena hamal hap anakan ayang gulkuke, “Ëe asa etan ëre mo Walasna Mesir kon kwang ta halzal.” ");
INSERT INTO ury_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodes kim sap keis nikon de dam gulsuk gwen wenya insa kara gwibiridaka, hen anakan kim tame gulku, “Zen hom asa nen gublu kïnzïꞌan. Man asa ahap da guk kïnzïk.” Dekam tangan zep jal gweka. Dekam zep zëre mo jana nabare zisi gubiridaka– Betlehemk hen zëno golek denak de ë-ë san de zi walassa tamerandan hap, dare tahun nakon olk san dep. Sap in kirekam keis nikon de dam gulsuk gwen zini in benna hen tahunna anakan nen gublu kïnzïkke, “Nonol tanganna dekam hata seka.” ");
INSERT INTO ury_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Zen dekam zep zauk– Alap mo ol ayang gul gwen zini Yermia Bak men desa ola anakan ayang gulkuye, ");
INSERT INTO ury_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Langna Rama kon gona sa wet so gwer, hen kamana sa nawa gwibir. Ëe ama eisirkim Rahel Swesa hlauk. Ngein sin zen sa auyan-tane wal zemka hala-hla gwibiridal. Zen molya sëwehek, sap auyan-tane wal zemka kïtak tangan sa damerasïl.” ");
INSERT INTO ury_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes kim tïlkï, Yusup ne dekam nama Mesirk ërgwëꞌak. Dekam zep etan Alap mo dam taha nakore zini zëbon eisirkim hata zaka. ");
INSERT INTO ury_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Zao zep gubluka, “Em luwen. Angkam sap esa walas om in han etan Israel san dep ërlwa hala. Sap teipsïn zini men zen eno nik mo walasna insa de tan hap golëalp gweꞌanka, zen mes angkam tïlkï.” ");
INSERT INTO ury_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ki zep hëndep luweka, dekam zep hëndep etan Israel san dep ërlwahak. ");
INSERT INTO ury_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Hwëna kim etan salka, “Angkam Yerusalem mo langnak Herodes mo tanena Arkelaus Bak bi zik mo weinak teipsïnkïm ïrïk gïꞌïra,” dekam zep hwëna desan de etan ërsong gwen hap aïrïꞌanka. Hwëna Bian zep etan eisirkim gubluka, “Galilea san ërsong gwe.” Dekam zep desan ërsong gwek. ");
INSERT INTO ury_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Zao zep ë bosena Nazaret ërgwë gwek. Zen kïtak Alap mo dwam gwibin sin ki lwak– men kirekam Alap mo ol ayang gul gwen zini orep zëbe hap dena ayang nul gwekke, “Zen Nazaret walkam sa nen gweblal.” ");
INSERT INTO ury_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Zao kim lwa seꞌak, dekam zep baptis ta gwibin zini Yohanis Alap mo olsa de ayang gul gwenkam kon gwesïk hanaꞌanka. Zen zi srëm nakon syal gweꞌanka– Yerusalem mo aha ënak de eik nikon. Sane tan hap kim zë zini yaïng gwe-gwek, dekam zep ola ayang gul gwizimki, ");
INSERT INTO ury_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Ere mae mo karek-karek nakon em ëhalen. Sap angkam Alap Zëna man kon gwesïk hanaꞌara– teipsïnkïm de nësa ïrïk gïnkïmye.” ");
INSERT INTO ury_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohanis zen orasa de sal tablan hap de zini men zëbe hap Yesaya Bak Alap mo olak hamal hap anakan ale gulblukake, “Zini sa zi srëm lang nakon taken gwera, ‘Haen, nëre mae mo Teipsïn Zi hip nen orasa hamal ta gublun! Hen nen dam-dam ta gublun!’” ");
INSERT INTO ury_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanis in Alap mo ol ayang gul gwen zini Elia Bak mo kim hen gwë gweka, zep unta ala nakore bajuna zëno kim hen ala so gweka. Takna hen Elia mo kim tweran sopkam denaka daul gweka. Tembanena hen zëno kim tembane gwe-gweka, zep ëkasna twenblanda gweka, hen sobwal hona otde gweka. ");
INSERT INTO ury_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","6","Dekam zini zëbon dep beya tangan nik weyana Yordan san dep sek gwe-gwek– tïngare Yerusalem mo lang nakon, hen weyana Yordan mo alp san de ë-ë nakonye. Zëwe zen nonol zëre mae mo kirekam karek-kareksa damnak ëkira-kla gwe-gwek. Ki zep hwëna Yohanis baptis ta gwibirki. ");
INSERT INTO ury_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Farisikam de gubirida gwen wenya hen Sadukikam de wenya zen hen zëwe beyakam sane tan hap yaïng gwe-gwek. Hwëna Yohanis kim desa hlauluda guku, dekam zep gu-gubiridaka, “Em an gwe makare enlalana! Em ema ëenlala gweꞌan, ‘Asa de baptis tabinkim Alap molya asa karek tabirki.’ Hwëna em home ëhaleꞌan. Alap mo jala kon molye ëheya-hya gwek. ");
INSERT INTO ury_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Zen in zep, em de Alap mo jala insa goltowen srëm hap, em ere mae mo lowehen karekna insa wet gulsun– dekam de emsa anakan tame tabin hipye, ‘Zen eiwa mes ëhaler.’ ");
INSERT INTO ury_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Em bahem anakan ëkïl gïl gwen, ‘Ëe an Abraham mo auyan-aza nakore nakake, zep asa molya Alap karek tabirki.’ Sap Alap maka eno mae mo weinak dep kaso-kasona ansa Abraham mo auyan-aza hap yang tabiꞌira. ");
INSERT INTO ury_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sap Alap mo zer sonen Zini in Zen ano lure nakon hataꞌan zala, Zen mes hlala hohle gulu– dekam de tesya lu ta gwen hapye. Tenya men zen de eini ëtë srëm gweꞌak, desa sa ausu ennak lu tala, hëndep ki sa tïnsïk gwen srëm syauk hï-hïtïnnïk yal ta sera. ");
INSERT INTO ury_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ëe weyakamë emsa baptis ta gwibiꞌin– dekam de em enaka anakan golëtrë gwen hap, ‘Ëe mesë ëre mae mo karek-karek nakon ëhaler.’ Hwëna ano lun kon Zen hataꞌan zaka, Zen Alap mo Enhokam sa emsa baptis ta gwibiri, hen syaukkum. Zen abon onakon teipsïn tanganna, zep zëno sepatu maesa de einblihan mae hap, ëe hen toton bëjënë. ");
INSERT INTO ury_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Zen joksa zirensïꞌïra– dekam de lënsa lën hap. Dangnak dena, desa yunak sa bïtï tala. Hwëna syaena men zen dang alp san altïꞌïk, desa tïnsïn srëm syauk bla san dep sa yal ta sera.” ");
INSERT INTO ury_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Dekam zep hen Yesus Galilea kon weyana Yordan san dep song gwe zaka, zao zep Yohanissi abe ta zaka, “Asa hen emki baptis tan.” ");
INSERT INTO ury_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Hwëna Yohanis man baes gweꞌanka– Yesussu de baptis tan hap. Man zë gubluka, “Bian, diki dawemna Em de asa baptis tankam bap. Hwëna Em ba habe abon hatanan zala?– ëe de Emsa baptis tan hapye!” ");
INSERT INTO ury_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesus ki zep hwëna ding gulbluka, “Em sap esa angkam Asa baptis tala. Sap zen dekam esa Alap mo dwam gwibinni kïtak su kul sonera.” Ki zep hëndep baptis taka. ");
INSERT INTO ury_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesus kim dekon zïl heꞌan zaka, mumuk ennak zep nglïna hlang në hanak. Yesus ki zep Alap mo Enhona hlaul guku– kim mawana ohola mo kim Zëbon dep ati gwe ineꞌan zaka. ");
INSERT INTO ury_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Dekam zep hen Alap mo ola ësalsek, “An ëre mo Tane– ëre mo dang tïnïnak de tanganna. Ëe ama tangan sam gwesïk gweblanan.” ");
INSERT INTO ury_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Alap mo Enhona ki zep Yesussu zi srëm lang san dep zersong gweka– zëwe dikim dowal mo kïgï akasïblïn hap. ");
INSERT INTO ury_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yaklana empat-pulu enkam Yesus tembane gwen srëmkam zëwe gwë gweka. Dekam usakna mes tangan sabak gweka. ");
INSERT INTO ury_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Hwëna dowal mo kïgïna dekam zep zë gublu zaka, “Em san Alap mo Tanesa hom?– zebe usak naban gwëꞌaraye. Kasona ansa emki gublundan– roti hap de ëjowen hap.” ");
INSERT INTO ury_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesus ki zep hwëna ding gulbluka, “Alap mo olak man lwak, ‘Zini tembane en nakon hom lowehe gwenan. Hwëna tïngare Alap mo ola mensa ësane gwe-gwenan, zen dekon hen ki lowehe gwenan.’” ");
INSERT INTO ury_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Dekam zep hwëna dowal mo kïgïna in Yesussu owaskam Yerusalem san dep zersong gweka– ëna mensa Alap orep Israelk de zi hip dam tasizimki, zëre hap de gol yawalsa de zë taun hup. Zao zep dowal mo kïgïna in Alap mo gol bolak drëne seka. ");
INSERT INTO ury_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Dekon zep etan gubluka, “Em san Alap mo Tanesa hom?– ki emki heya gwe inen. Sap Alap mo olak ebe hap dena anakan lwak, ‘Alap zëre mo dam taha nakore zisi sa emsa de dawem enkam kara ta gwen hap gubiridala. Zëno mae mo taha tere san esa tënda gwera, zep em molye ba karek maena goltoweka.’ Zep em san ema Alap mo ola insa taïblïbiꞌira? Ki emki heya gwe inen.” ");
INSERT INTO ury_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesus ki zep hwëna ding gulbluka, “Alap mo olak man hen lwak, ‘Bian Alapsa totoresa bahem anakare hap akasïblïn, “Wëhë asa mas gweblaꞌanka?”’” ");
INSERT INTO ury_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Hwëna etan dekon ki zep Yesussu owaskam kwatap yawal san dep zersong gweka. Dekon zep tïngare auhu-kamanak de ïrïk gïnnï ansa goltrëblaka– hëndep zëwe de kire-kire dawem naban. ");
INSERT INTO ury_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Zao zep etan gubluka, “Insa ki hlauluda, ëe asa ebe hap kïtak tapbla gulblul– em de hwëna bi gwibin hip. Hwëna nonol bokle kom soblan naban em asa boltere tan.” ");
INSERT INTO ury_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesus ki zep jala ban ding gulbluka, “Zi Golliwe Bak, em song gwen! Sap Alap mo olak man lwak, ‘Bian Alap ensa em boklena kom so gweblan, hen Desa en em blikip gwesïk gweblan.’” ");
INSERT INTO ury_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Hëndep ki zep dowal mo kïgïna in Yesussu hli ta guk halka. Hwëna Alap mo dam taha nakore zini dekam zep tembanekam mas nëblazak. ");
INSERT INTO ury_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesus kim salka, “Yohanissi mes bwinak se dyaink,” dekam zep Galilea san ahulsuk halka. ");
INSERT INTO ury_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Dekam Zen hom zëre mo ëna Nazaret gwëka. Zen hwëna Kapernaumk gwë gweka– Ho Gutuna Galilea mo alpnak, Zebulon ne Naftali nik mo zi ausu mo langnak. ");
INSERT INTO ury_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yesus insa zao gwëka, zen Alap mo dwam gwibin sin ki lwak– dekam de Yesaya Bak mo hamal hap de ol ayang gunnuk zaun hup, mensa anakan ayang gulkuke, ");
INSERT INTO ury_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Em in zene Zebulon ne Naftali nik mo ausu nakore zini lowe heꞌan, hen Ho Gutuna Galilea mo ora alp san de wenya, sap weyana Yordan mo men eihyanak de wenya, hëndep Yahudi srëm zi ausu nakore zini men zen langna Galileak hen lowehe gwenan: ");
INSERT INTO ury_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Em in zene angkam kawesïnnïk lowehe gweꞌan, hwëna em esa sërkam de ngatan yawalsa hla kul. Em in zene juwen zi mo lang kawesïnnïk lowehe gwenan, hwëna ebon mae onak sa ngatanna yakla nwe de hata sezan makan emsa zïlsïbirida zala.” ");
INSERT INTO ury_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Zep Yesus in kim Kapernaumk gwë gweka, dekam zep zë hëndep tawa tabinkim kon gwesibir hanaꞌanka. Man zë gubirida gweka, “Ere mae mo karek-karek nakon em ëhalen, sap Alap Zëna angkam man kon gwesïk hanaꞌara– teipsïnkïm de nësa ïrïk gïnkïmye.” ");
INSERT INTO ury_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesus kim Ho Gutuna Galilea mo alp san gwë haꞌanka, dekam zep zë hogwe tahyo gwen zi darena akeꞌanka. Ahana Simon– men desa hen “Petrus”kum nen gweblanan, oso zem Andreas han. Ho gutunak iwe hogwesa jalakam zertahyoꞌanka. ");
INSERT INTO ury_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesus ki zep zë guzim zika, “Asa em ang ëblan. Ëe asa emsa zisi de hwëna lahyo gwen hap tawa sol.” ");
INSERT INTO ury_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dekam zep hëndep jalana insa hli koso guk halka– Yesussu dikim hwëna ang ëblan hap. ");
INSERT INTO ury_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Dekon kim deban zisong gweka, dekam zep etan aha zi darena akeꞌanka. Zen hen oso zeban zergwëꞌanka. Zen Yakobus ne Yohanis ne– Zebedeus Bak mo walas dare. Zen bi zik zëre mo bul tahannak zinikinꞌinka, jalasa zë zioto tasibiꞌinka. Zao zep hen desa kirekam guzim zika. ");
INSERT INTO ury_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Zen hen zao zep hëndep bulu insa hli kulki, hen bi zemka zëwe hli laka. Zëna dekam zep hen Yesussu ang ëblaka. ");
INSERT INTO ury_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesus dekam zep tïngare Galilea mo langnak de ë-ëna zëre hon de ang ta gwen wenya in han ziamjanbir song gweka, hen zëwe Yahudi mo but srëm gol-gol san tawa tabir song gweka. Zen Alap Zën de ïrïk gïn hïp de ol dawemkam tawa tabir song gweka, hen kirekam-kirekam zi sang-sangsa dawem tabir song gweka. ");
INSERT INTO ury_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Galilea kon kim Yesus hup de ola insa tïngare Siria mo lang san nol haladak, dekam zep zi beyam-byana kirekam-kirekam sang-sang karek nabare wenya nolëyaïng gwe-gwezak. Sap dowal mo tïlbiridanna, hen ëtïlsïn-tïlsïn wenya, hen taha-tana teisya inen srëm wenya, desa kïtak nolëyaïng gwe-gwezak. Hen Yesus dekam zep kïtak dawem ta gwibirki. ");
INSERT INTO ury_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Dekam zini beya tangan nik zep Yesussu ang në gweblak. Ahakon Galilea korena, ahakon lang bosena Ëna Dare Taha-tap korena, hen ahakon tïngare Yerusalem mo lang nakorena, hëndep ahakon weyana Yordan mo men eihya nakorena. ");
INSERT INTO ury_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesus kim zi beyam-byana insa hlauludaka, dekam zep kwatap tek san hata seka. Zao zep zëre hon de ang ta gwen wenya ban zi trana insa zigolëteinikinki, ");
INSERT INTO ury_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","zao zep tawa tabiꞌinka, ");
INSERT INTO ury_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Men zen zëre mae mo tahalhana Alap en hon ëblol gwe-gwenan, zen isrip-sri gwibinnik lowehe gweꞌan, sap zen zen Alap mo ïrïk gïnnï bi neibiꞌin. ");
INSERT INTO ury_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Hen men zen angkam enlalana ëdowe hana gweꞌan, zen isrip-sri gwibinnik lowehe gweꞌan, sap Alap sa zëno mae mo enlala dowe hananna insa isrip-sri hap li ta sonezimdi. ");
INSERT INTO ury_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Enlala sae-sae wenya, zen hen isrip-sri gwibinnik lowehe gweꞌan, sap Alap sa gubiridala– zen de hen okamana ansa bi gwibin hipye. ");
INSERT INTO ury_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Men zen tïngare zi dikim enlala dam-dam enkam lowehe gwen hap ëdwam gwe tine gwenan, zen hen isrip-sri gwibinnik lowehe gweꞌan, sap lamkam men zëwe enlala dam-dam wenya lowehe gweꞌak, desa hen sa Alap gubiridala– zëwe de hen bïtï gwen hapye. ");
INSERT INTO ury_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Hen men zen wal bose wal zemka kwasang neibirida gwenan, zen hen isrip-sri gwibinnik lowehe gweꞌan, sap kire zi hip Alap kwasang-kwasang zemka sa gol gwizimdi. ");
INSERT INTO ury_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Enho lalak wenya, zen hen isrip-sri gwibinnik lowehe gweꞌan, sap zen zen sa Alapsa nërtower. ");
INSERT INTO ury_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Hen zini men zen umlae enlalana nol halada gwenan, zen hen isrip-sri gwibinnik lowehe gweꞌan. Kire zini Alap sa gubiridala, ‘An ëre mo walas tanganna zen.’ ");
INSERT INTO ury_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Dawemsa de syal gwibinnik men desa karek da gwibirin, zen hen isrip-sri gwibinnik lowehe gweꞌan, sap zen zen Alap mo ïrïk gïnnï bi neibiꞌin. ");
INSERT INTO ury_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Hen emsa kim abe hap de jal hap lamang da gwibiꞌik, hen karek da gwibiꞌik, hen boton olkam blo-blo da gwibiꞌik, em hen dekam isrip-sri gwibinnik esa lowehe gwer. ");
INSERT INTO ury_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Orep men zen Alap mo ola abare srëmnak ayang nul gwek, desa hen kirekam karek da gwibik. Zep em de hen kire kareksa goltowe gwenkam, em dawemkam ëisrip-sri gwe-gwen, sap ngein sin dawemna Alap mam tangan naka ebe mae hap ngatan zi mo langnak hamal gulzimꞌira.” ");
INSERT INTO ury_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Em an zene Abon ang ta gweꞌan, em okamanak san de hina kiye. Hwëna hina blëble gwenkam, dekam tembanesa dikim dërek gun hup dena man hom gwe-gwenan. Dërekna in de hom gwenkam, dekam zini bëjen ba mae hap dwam gwibin. Zen dekam zalta dep de hiri gun en hap dena. ");
INSERT INTO ury_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Hen em an okamanak san de tïngare zi hip de ngatanna kiye. Em hen dekam san de kwatap bolak de ëna kiye. Ëna in kore kam de ngatanna okama kawesïnnïk awe man zïl ine gwenan. ");
INSERT INTO ury_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Zen zep ere mae mo ngatanna bahem aning gul gwen. Sap zini bëjen pelita ngatannak yuna utuk gul sonen. Zen diki mejanak de lonenkam– dekam de golak de lowehen wenya in ngatannak lowehen hap. ");
INSERT INTO ury_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Zen in zep, eno mae mo lowe henna diki tïngare zi mo nwenak kirekam zen ngatan gwe-gwen– dekam deka eno mae mo lowehen dawemna insa hla nul gwek. Ki zen hen dekam sa ngatan zi mo langnak de Bian mo bosena teip nulsuk gweblal.” ");
INSERT INTO ury_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Asa bahem anakan kïl tïn, ‘Zen an Musa mo tïtï tabin olsa de wet gulsublun hap hata zaka,’ ahaksa, ‘Alap mo ol ayang gul gwen zi mo olsa de wet gulsun hup.’ Ëe wet gulsun hup homë hatazak. Ëe hwëna dawemkam de zëno ei nika ebe mae hap sul sonezimdin hibë hatazak. ");
INSERT INTO ury_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Zen in zebë eiwa denaka emsa gubiridaꞌan: Nglï naban kama naban de aumwa hap de yaklanak jek-jak nën srëmnak, dekam tïngare hamal hap de Alap mo ola sul sonen tangan nik sa lwal. Aha-ere ol-gun betek maena molya mae lwa kïnïk. ");
INSERT INTO ury_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Zen in zep, men nara tïtï tabin ola insa aha-ere ol-gun maesa ngip gunnu, hen men zen de anakan tïtï da gwibiꞌik, ‘Ansa sap esa ngip ul gwer,’ zen Alap mo ïrïk gïnnïk otde tangannak sa teinikin. Hwëna men zen de tïtï tabin ola in san ang ta gweꞌak, hen aha zisi desan de ang tan hap tïtï da gwibiꞌik, zen Alap mo ïrïk gïnnïk teipsïn-teipsïnkïm sa lowehe gwer. ");
INSERT INTO ury_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Zini sap man Farisikam de gubirida gwen zisi hen Musa mo tïtï tabin olsa de tawa ta gwibin zisi anakan kïl dï gwibirin, ‘Zen dawemkam Musa mo tïtï tabin ol san ang ta gwenan.’ Hwëna zëna desan zi mo nwe ennak ang ta gwenan. In zebë emsa gubiridaꞌan: Em de zëno mae mo kim ëk enkam Alap mo dwam gwibin sin ang ta gwenkam, ki em molye Alap mo ïrïk gïnnïk bïtï gwek.” ");
INSERT INTO ury_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ena dwan mes-eme ëtawa gwek: Musa Bak dwan mes-am anakare ol jalse gwenna nëno mae mo auyan-aza hap ayang gulzimki, ‘Zisi bahem tan. Nara zisi tanna, desa hwëna em tok hap karek tan.’ ");
INSERT INTO ury_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Hwëna angkam Ëe ama emsa gubiridaꞌan: Men nara wal bose zemka jal gweblanna, kire zini Alap sa lamkam karek tala. Hen men nara aha zisi wakwak tanna, kire zini hen karek tan hap dena. Hen men nara wal bose zemka gublunna, ‘Em in enlala joblo-topna,’ kire zini zen tïnsïn srëm syauk bla san dep dena. ");
INSERT INTO ury_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Zen in zep, em de Alap hap kire-kiresa de golblan hap enlala gwenna, hëndep em de Alap mo golak golhatankam, hwëna dekone etan enlala gweꞌanam, ‘O hare ano wal bosyanna man-am ëre mo karek nakon asa gïl-gïl gweblaꞌara,’ ");
INSERT INTO ury_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ki kire-kirena insa emki Alap hap de golblan srëmnak teksonnak iwe hli yun. Nonol emki wal bose om in han eno karekna insa tap ulsun. Tap ulsunnuk, dekam etan lwa halza– dekam de kire-kirena insa enlala dawem naban Alap hap golblan hapye. ");
INSERT INTO ury_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Zen in zep, ere mo karek nakon de wal bose uk emsa gïl-gïl gweblanna, emki nabakam tap un. Tap un srëmkam, ki eno wal bosyanna in maka emsa teipsïn zinik klak taꞌara. Teipsïn zini in hwëna dekam maka zëre mo dam taha nakore jana zisi gubiridaꞌara– emsa de bwinak se tya irin hip. ");
INSERT INTO ury_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Eiwa denakaë emsa gubiridaꞌan: Em bëjen em dekon wet son– te-alana men ki en teipsïn zini in emsa gubluka, kire enkam de golblan srëmkamye.” ");
INSERT INTO ury_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Em dwan mes-eme Musa mo ol jalse gwenna ansa ësane gwe-gwek, ‘Bahem ëkahalo gwen.’ ");
INSERT INTO ury_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Hwëna angkam Ëe ama emsa gubiridaꞌan: Men nara wesya swi enlala naban ërtabinni, ki zen mes enlala nakon kahalo gwibirida. ");
INSERT INTO ury_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Emsa de ere mo aha nwe tïtï da gweꞌanam, ‘Haen, nen karekna wakinsa karatda un,’ ki em nwena insa alsïn nïka hiri son. Sap eme dare nwe naban zigwëꞌanka, ki esa hëndep Asa hli tala. Ki hwëna tïnsïn srëm syauknuk dep sa emsa hiri daser. ");
INSERT INTO ury_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Hen kirekam, emsa de ere mo dam taha kareksa dikim gon hap tïtï da gweꞌanam, diki dawemna em blansïn. Sap eme dare taha naban zigwëꞌanka, ki esa Asa hli tala. Ki hwëna tïnsïn srëm syauknuk esa hëndep denaban gwë gwera.” ");
INSERT INTO ury_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yesus ki zep etan gubiridaka, “Em dwan mes-eme Musa mo ol jalse gwenna ansa ësane gwe-gwek, ‘Zini we zemka sap de baes gwibinkim, hwëna nonol baes gwibin hip de suratsa de anakan ale gunkum, “Ëe mesë kire hap baes gwibik.”’ ");
INSERT INTO ury_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Hwëna angkam Ëe ama emsa gubiridaꞌan: Men nara we zemka baes gwibinni, wenya in de kahalo gwen srëmnak, ki hwëna dekam zen mes aha zi de kahalo gun hup golgunda. Hen we baes gwibinni insa de ahanik gonkam, zen hen Alap mo nwenak kahalonak gwë gweꞌara.” ");
INSERT INTO ury_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Em dwan tawa nakake, orep Musa Bak nëno mae mo auyan-azasa ki hen anakan jalse gwibirida gweka, ‘Bahem boton hap anakan ëgu gwen, “Alap, mese ki asa hla tanda.”’ Hen zen man tïtï ta gwibirki, ‘Em de banakare mae hap Bian mo bose gubin niban gu-gunnu, hëndep kire enkam emki syal gwe-gwibin. Kirekam de syal gwibin srëmkam, ki Alap mo nwenak mese karek gwera.’ ");
INSERT INTO ury_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Hwëna angkam Ëe ama emsa gubiridaꞌan: Bahem tangan Alap mo bose gubin niban ere mae mo ola soson gul gwen. Hen Alap zëre mo bosesa de gollëwen hap bahem hen anakan ëgu gwen, ‘Nglï, mese ki asa salblanda.’ Sap nglïna zen Alap zëre mo nikin gwenna zen– men dekon nësa tïngan ïrïk gïꞌïraye. ");
INSERT INTO ury_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Anakan hen bahem Bian mo bosesa de gollëwen hap ëgu gwen, ‘Kama, mese ki asa salblanda.’ Sap zen apdenak– anakan de gun nubanye, ‘Alap, mese ki asa salblanda.’ Sap okamana an, zen Alap zëre mo tana ïk so sone gwenna zen. Anakan hen bahem ëgu gwen, ‘Ëna Yerusalem, mese ki asa hla tanda.’ Sap Yerusalem, zen Teipsïn Zini Alap zëre mo ë yawala zen. ");
INSERT INTO ury_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Hen Alap zëre mo bosesa de gollëwen hap bahem hen anakan mae ëgu gwen, ‘Ëre mo nol ala, mese ki asa hla tanda.’ Sap eno sosonna hom– dekam de ere mo nol alana insa aha-ere sïhï mae naka anakan wet gulsun hupye, ‘Ano nol alana an zen ngap-ngap gwen,’ ahaksa, ‘Zen kakak gwen.’ ");
INSERT INTO ury_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Diki Alap mo bosesa de gubin srëmkam em ëgu gwen, ‘Ëe eiwa denakaë tonꞌan.’ Sap em de anakan ere mo olsa soson gul gwenkam, ‘Zen ki asa salblanda,’ dekam hwëna em dowal mo kïgï mo dwam gwibin sine ang gweꞌara.” ");
INSERT INTO ury_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Em dwan mes-eme Musa mo ol jalse gwenna ansa ësane gwe-gwek, ‘Zi de wal bose zik mo nwesa tobe ënkam haï soblankam, ki zini in mo nwena emki hen haï soblan. Ahaksa ëk naka de tobe ënkam kam tablankam, ki hwëna zini in mo ëk naka emki hen kam tablan.’ ");
INSERT INTO ury_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Hwëna angkam Ëe ama emsa gubiridaꞌan: Zi jal-jal de emsa karek tanna, bahem ere mo timsi goljalse gweblan. Emki hwëna sosok gulblun. Emsa de zi i tranak lek tyankam, em etan eihya i trasa zitrëblan– zëwe deka hen emsa lek tyaka. ");
INSERT INTO ury_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Emsa de ahanik teipsïn zinik botonkam anakare ola ban klak tanna, ‘Zen mes ano kire-kirena totoresa kap taka,’ zen men desa em de hwëna kap tablan hap dwam gweꞌara, emki hëndep kap tablan, hen dekon em etan mas-mas tablan. ");
INSERT INTO ury_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Emsa de jana zi zëno nihin dohon-honsa de aha-ere kilometer enkam wë tablan hap tik-tik tanna, em hwëna dare kilometerkam em wë tabla song gwen. ");
INSERT INTO ury_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Zi de emsa banakare mae hap abe tanna, em hëndep golblan. Hen zi de emsa ba maesa de bohë gulblun hap abe tanna, emki hëndep bohë gulblun. Bahem salsïblïn.” ");
INSERT INTO ury_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Musa mes dwan-am nësa anakan tïtï ta gwibiriki, ‘Wal bose wal en omka em kwasang gwibirida gwen.’ Hwëna zëno olsa de tawa ta gwibin wenya zen anakan mas nul gwenan, ‘Nëre mae hap de jal zisi sap esa husus eibirida gwer.’ ");
INSERT INTO ury_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Hwëna angkam Ëe ama emsa gubiridaꞌan: Ere mae hap de jal zini em kwasang gwibirida gwen. Hen men zen emsa karek da gwibirin, zëbe mae hap Alapsa em abe ta gwen– Zen dikim dawemsa zëbe mae hap gol gwizimdin hipye. ");
INSERT INTO ury_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Sap tïngare zisi de kwasang gwibirida gwenkam, zen dekam esa ngatan zi mo langnak de Bian zëre mo bi gwibiridan walaskam loweher. Sap Alap insa yaklana yang tasïkï, zen zi dawem-dawem ensa hom zïlbirida ine gwenda. Zen hwëna karek-karek gol gwen wenyaka hen zïlbirida ine gwenda. Hen ona insa ïl tï gwenda, zen dawemsa de syal gwe-gwibin wenya kip, hen kareksa de syal gwe-gwibin wenya kip. ");
INSERT INTO ury_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Zep em de enaka de kwasang gwe-gweblan zi ensa etan kwasang gwibirida gwenkam, ki hwëna anakan bahem ëkïl gïl gwen, ‘Alap sa kire hap asa sam gwesibiridala.’ Roma mo ïrïk gïnnïk dep de te-ala alal ta gwen zini sap ki kire enkam ëgwë gwenan. Zen hen karek gol gwen bose zemka hwë-hwëkam zënaka kwasang neibirida gwenan. ");
INSERT INTO ury_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hen em de zisi golëtowenkam, em de ere mo wal bose wal ensa dawem ta guk gwibinkim, hwëna aha zisi hom, dekam bahem anakan ëkïl gïl gwen, ‘Ano bosena dekam sa Alap mo nwenak dawem gwer.’ Alapsa de tame tan srëm zini hen ki kire enkam hwë-hwëkam wal bose wal en zemka dawem da guk gwibirin. ");
INSERT INTO ury_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Sap nëno mae mo ngatan zi mo langnak de Bianna, zen sowehen tangankam kïtak de zisi kwasang gwibirida gwenda– sap hen karek gol gwen zi. Zep em hen kirekam em nëre mae mo Bian mo kim ëgwë gwen.” ");
INSERT INTO ury_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesus dekam zep etan tawa tabinni ayang gulzimki, “Em de Alap mo bose hap tahalha zisi mas gwibirida gwenkam, ahaksa Alap hap de aha syal maekam, zi mo nwenak bahem golada gwen– dekam de emsa gublun hap, ‘Zen dawemna.’ Kirekam de syal gwenkam, ki hwëna ngatan zi mo langnak de Bian molya syala in hap de dawemna ebe hap golblaka. ");
INSERT INTO ury_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Zep em de tahalha zisi Bian mo bose hap mas gwibiridankam, bahem aha zisi hamal hap gu-gubiridan– tagal gwennak de emsa hla tan hap. Bahem but srëm golak ahaksa ëtagal gwen maenak anakan gubiridan, ‘Ëe kimë mas gwibiridan hap hataꞌak, em dekam tërya ban asa hut lu ane guk– dekakim zi beya asa hla dak, “Zen man angkam mas gwibiridan hap hataꞌara.”’ Men zen ëk enkam Alap mo nwenak dikim ësam gwesïn hïp de syala nol gwenan, zen kirekam ëgwë gwenan. Hwëna eiwa denakaë emsa gubiridaꞌan: Sap desa mes zëre mae mo tahalha zisi de mas gwibirida gwen nakon boltere da gwibik, zep zëbe mae hap Bian Alap molya lamkam zëre mae mo syala in hap de dawemna golzimki. ");
INSERT INTO ury_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Hwëna em de tahalha zisi mas gwibirida gwenkam, sowëkam emki mas gwibiridan– aha zi de emsa tawa gweblan srëmkam. ");
INSERT INTO ury_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Aningkim em aha zi hip dawemna gol gwizimdin. Sap nëno mae mo ngatan zi mo langnak de Bianna, Zen zi mo aning gun syala man hlaul gwizimnira, hen Zen sa hwëna ebe mae hap dawemna gol gwizimdi.” ");
INSERT INTO ury_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Em de Alapsa gu sone gweblankam, zi mo nwenak bahem– zi de emsa hla tan hapye. Men zen kire enlala naban nen sone gweblanan, zen zi beya mo ngïrïn nïkon nen sone gweblanan– sap but srëm golak, hen sap ëtagal gwen maenak. Men zen ëk enkam Alap mo nwenak dikim ësam gwesïn hïp de syala nol gwenan, zen kirekam ësam gwesïk gwenan. Hwëna eiwa denakaë emsa gubiridaꞌan: Sap desa mes zëre mae mo Biansa de gu sone gweblan nakon boltere da gwibik, zep Bian Alap molya lamkam kire syal hap de dawemna golzimki. ");
INSERT INTO ury_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Hwëna em de Alapsa gu soneblankam, gol mwanak em tïn, hen lïlïkïnnï em solhlasïn. Dekon em aningkim gu soneblan. Sap nëno mae mo Bian, hla ta gwen srëm Zini Alap, Zen zi mo aning gun syala man hlaul gwizimnira, hen Zen dekam sa hwëna ebe mae hap dawemna gol gwizimdi.” ");
INSERT INTO ury_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Em de Alapsa gu soneblankam, bahem aha-ere abena etan gollwa halasen gwen– men kirekam Alapsa de tame tan srëm wenya ëgwë gwenanye. Sap zen man ëkïl gïl gwenan, ‘Abesa de mam blalkam gollwa hala serankam, ki sa ano abena dokwak gulu.’ ");
INSERT INTO ury_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Hwëna kirekam waba hap. Zep em zëno mae mo kim bahem. Sap Bian Zen mes eno dwam gwibinni tame gulku– em de nama abe tan srëmnak. ");
INSERT INTO ury_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Zep em a kirekam em gu sone gweblan: Bian, ngatan zi mo langnak de Zini, dikire eno bosena teip nulsuk gwek. ");
INSERT INTO ury_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Diki okamanak awe Em hen ïrïk gïn– in kirekam hen ngatan zi mo langnak ïrïk gïꞌïrake. ");
INSERT INTO ury_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Namen dep de tembanena ap golzim. ");
INSERT INTO ury_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ano mae mo karek-karekna ap tap gulsuk gwizim– ëe men kirekamë hen aha zi mo karekna eititi ei gwibirin, men desa ap nol gwizimninke. ");
INSERT INTO ury_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Asa de akasibirida gwennak bahem nwe enkam asa kara ta gwibin. Hwëna dowal mo kïgï mo taha nakon asa alal gul gwe.” ");
INSERT INTO ury_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Etan ki zep gubiridaka, “Men nara wal bose zik mo zëbe hap de karek golblansa eititi gwibir-blinkam, ki ngatan zi mo langnak de Bian sa hen zëno karekna eititi gwibir-blira. ");
INSERT INTO ury_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Hwëna em de wal bose uk mo ebe hap de karek golblansa eititi gwibin srëmkam, ki Bian hen molya eno karek-karekna ep tap gulsubluka.” ");
INSERT INTO ury_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Em de Biansa dikim enlala zon tasïblïn naban abe ta gwen hap tembanesa ëlwa gwenkam, nwe-masena bahem ëdowe hana gwen. Sap men zen ëk enkam Alap mo nwenak dikim ësam gwesïn hïp de syala nol gwenan, zen kirekam ëgwë gwenan. Zen son maesa nawa gwibirin– dekam de zi anakan tawa gwibiridan hap, ‘Zen an Alap hap tembanesa ëlwaꞌan.’ Eiwa denakaë emsa gubiridaꞌan: Sap desa mes zëre mae mo tembane lwan nakon boltere da gwibik, zep Bian Alap molya lamkam kire syal hap de dawemna golzimki. ");
INSERT INTO ury_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Hwëna em de Biansa dikim abe tan hap tembanesa lwankam, nwe-masena em ngan tasïk gwibin hen nol alana em sisir ta gwibin. ");
INSERT INTO ury_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Bap zen aha zi emsa anakan tame tabin, ‘Zen Biansa dikim dawemkam abe tan hap tembanesa ëlwaꞌan.’ Sap nëno mae mo Bian, hla ta gwen srëm Zini Alap, Zen zi mo aning gun syala man hlaul gwizimnira, hen Zen dekam sa hwëna ebe mae hap dawemna gol gwizimdi.” ");
INSERT INTO ury_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Auhu-kama ennak awe bahem kire-kirena ëbeya gwen. Awe hwëna sa ëkalse gwer hen winim sa blom da gwibir, hen sowë zi sa dekam de kap tan hap eno gola insa dre dal. ");
INSERT INTO ury_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Diki dawem tanganna ngatan zi mo langnak em kang ta gwen. Zëwe molya ëkalse gwek, hen winimni molya zë blom dabik, hen sowë zini banakan molya kap dak. ");
INSERT INTO ury_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sap men zëwe eno kire-kirena ërlwa gwenna, eno enlalana hen zëwe sa lwa gwera.” ");
INSERT INTO ury_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nwena zen tim hip de lïlïkïn– enho dikim ngatan gwen hap. Nwe nik de lalak nënna, dekam enhona hen ngatanna. Eno gwë hanna dekam, san de ngatan san de song gwenna. ");
INSERT INTO ury_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Hwëna em de nwekam men-san an-sankam hir-hir gwe naserankam, dekam bute hala seran makan esa gwë gwera. Hen eno nwe nik de haï nënkam, dekam kawesïn tangannak esa gwë gwera.” ");
INSERT INTO ury_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Zini bëjen dare teipsïn zisi dawemkam babu gwizimdin. Zen hwëna aha-en naka sa dawemkam kwasang gwe-gweblala hen blikip gwesïk gweblala. Aha zini insa molya. Zep em hen kirekam: Em bëjen em syala dan son– Alap mo syala ban, te-ala beya gwen hap de syala banye. ");
INSERT INTO ury_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Zen in zep, em bahem anakan ëngalap gwe-gwen, ‘Ëe banakan asa gwër? Ëe basa asa twin gwibir hen otde gwibir? Hen ëe basa asa ala so gwer?’ Emki ëenlala gwen: Eno gwënna zen tembane en nakon hom lwa gwenan, hen timni ala so gwen hap de en nakon hom lwa gwenan. ");
INSERT INTO ury_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Em ba hap de kirekam ëngalap gwe-gwen hap? Emki mawasa enlala gwibiridan. Zen hom ba maena eiyas nïl gwenan, hen hom dan gwenan, hen zëno mae mo gudangna hom– zëwe de tarankam ba maesa kang ta gwen hapye. Hwëna zen mes ki tame nuk, ‘Ngatan zi mo langnak de Bianna ki tembanena ap gol gwizimnira.’ Zep emki hen dam gulsuk gwen, ‘Ëe Bian mo nwenak mawa betek mo kim hom.’ ");
INSERT INTO ury_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Em de ere mo gwën hap ngalap gwenkam, san ha em emaka ere mo gwënna insa engka en mae langa gulsuꞌura? Bëjen. ");
INSERT INTO ury_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Zep em ba hap de anakare hap enlalana ëbeyam-bya gwen hap, ‘Ëe basa asa ala so gwer?’ Emki sap sona ok eiꞌi enlala gwibiridan. Zen hom syal ta gwenan, hen pakeanna hom dayal gwibirin. ");
INSERT INTO ury_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Hwëna Ëe ama emsa gubiridaꞌan: Sap teipsïn zini Salomo Bak, zen hwëna hom ok eis nwe-awes makare pakeanna akeka– desa de zëre mo te-ala beyakam teisyan hapye. ");
INSERT INTO ury_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Em in Biansa de taïblïblanna tawa naka hom! Ok eis mo ëhultunnu tïhïs tanganna, sap zen namen de ënwe-awes gwenkam, hwëna kaꞌan de ëjek-jak gwen. Zen sap eiwa kirekam, hwëna Alap ki desa kara ta gwibirida. Zep emki Biansa anakan taïblï gweblan, ‘Zen molya asa ala so gwen hap denakim da tasïkï.’ ");
INSERT INTO ury_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Zep em bahem anakare hap ëngalap gwe-gwen, ‘Ëe basa asa twin gwibir hen otde gwibir? Hen ëe basa asa ala so gwer?’ ");
INSERT INTO ury_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sap Alapsa de tame tan srëm zini zen kirekam ëngalap gwe-gwenan. Hwëna nëno mae mo ngatan zi mo langnak de Bianna, Zen anakan tawana, ‘Ano walasna an kiresa tahalha gwibiꞌira.’ ");
INSERT INTO ury_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hwëna kïtak ere mo tahalha gwibinni insa esa hla kul gwer– anakare enlala de eno mae mo enhonak bol-zaun gwenkamye, ‘Diki Bian Zen nabakam nësa ïrïk gïlzïn, hen ëe anik zëno dwam gwibin en san ang tak.’ ");
INSERT INTO ury_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bahem kaꞌan dep dena kip anakan ëngalap gwe-gwen, ‘Ëe kaꞌan basa asa jogwaher gul?’ Sap namen de tahalha hap dena, zen srën. Kaꞌan de tahalha hap dena, zen hen srën. Bahem kaꞌan de tahalha hap dena namen enlala gwibin. Dikire eno enlalana namen en dep dena kip lwak. Ngein sin dep de tahalha hap bahem ëngalap gwe-gwen.” ");
INSERT INTO ury_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesus dekam zep etan tawa tabinni ayang gulzimki, “Wal bose wal omka bahem gubirida gwen, ‘Zen karek tan hap man dakastïꞌïra.’ Ki hwëna Alap sa hen emsa gublula, ‘Zëna hen karek tan hap man dakastïꞌïra.’ ");
INSERT INTO ury_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sap em men kire enkame wal bose omka karek tan hap gubluꞌanka, ki hwëna Alap hen kire enkam de emsa karek tan hap maka gubluꞌara. Sap eme aha zisi gubluꞌanam, ‘Zen kirekam ngip gulku,’ Alap dekam sa hen emsa karatda tala– eno gwënsa de anakan hlaulblun hap, ‘San ha zëna hen kirekam ngip gul gwenda?’ ");
INSERT INTO ury_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hen em ba habe wal bose uk mo ngip gun betek tolsa hla kul gwizimnin? Hwëna ere mo ngip gun yawala em desa de oto gulsun hup ema baes ta gwenan. ");
INSERT INTO ury_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kirekam insa ëgwë gwenan, zen men kiye: Zi de wal bose zemka gublunna, ‘Anik eno nwenak de te klana insa gulsuk,’ hwëna zëre mo nwenak hen balok tek yawala ki lwaꞌan. Desa maka nonol gulsuꞌura– dekam de dawemkam wal bose zik moka hlaun hupye. ");
INSERT INTO ury_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Em in Alapsa ëk enkame ang ë gweblanan. Diki nonol enaka emaka oto lasïk gwibiꞌin. Ki esa dawemkam kara gwera– dekam de wal bose omka halen ora san zerwet son hapye.” ");
INSERT INTO ury_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Alap onakore ol dawemna bahem lwa makare enlala zi hip waba hap tonbirida gwen. Zen sa hwëna jala ban ja-ja nul gwer hen emsa sa naptabirida gwer. Hen Alap onakore ol dawemna bahem gwe makare enlala zi hip gol gwizimdin. Ki hwëna zen sa zalta dep tanakam nyaubir.” ");
INSERT INTO ury_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Men kiresa ena dwam gwibinni, Alapsa em abe ta tine gwen. Ki Zen sa hëndep kiresa ep gol gwizimdi. Em teibir tine gwen, dekam esa hëndep Zëbon onakon hla kul gwer. Hen orasa em tëbla tine gwen. Zen dekam sa ep zertrëblala. ");
INSERT INTO ury_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sap zini men zen abe ta gwenna, zen gul irinkim. Men zen tei gwibinni, zen hlaunkum. Hen men zen orana të gweblanna, zëbe hap zertrëblankam. ");
INSERT INTO ury_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ebon mae onakon san ha ki bi zem walas zikhip kasona golblaka?– zen de roti hap abe tankamye. ");
INSERT INTO ury_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ahaksa wanyana san ha ki golblaka?– zen de hogwe hap abe tankamye. ");
INSERT INTO ury_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Em sap jal-jala, hwëna eno anakare kwasang enlalana hen ki, ‘Ëe anik dawem naka ëre mo walas hap golblak.’ Nëno mae mo Bian, ngatan zi mo langnak de Zini, Zen hwëna dawem tangankam nësa kwasang gwibirida gwenda. Zep Zen hen Desa de abe ta gwenkam dawem kire-kiresa nëp gol gwizimnira.” ");
INSERT INTO ury_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Men kirekam ena dwam gweꞌara, zi de kirekam emsa gwë gweblan hap, em hen ahasa kirekam em gweibirida gwen. Sap kirekam de enaka golëlowehe gwen hap dena, zen zen ausuna– Musa mo tïtï tabin olak hen Alap mo ol ayang gul gwen zi mo olakye.” ");
INSERT INTO ury_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Hëndep de ëngaya gwen hap de ëdwam gwenna, lïlïkïn klakat san em bïtï gwen. Sap lïlïkïn yakna hen ora dak-dakna, zen syauk bla san dep dena. Zen in zep zini desan beyakam ëgwahal gwenan. ");
INSERT INTO ury_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Hwëna eiwa klakat tanganna– hëndep de ëngaya gwen hap de lïlïkïnnï hen oranaye. Zep zini beyakam hom orana insa dam dasïk gwenan.” ");
INSERT INTO ury_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Bira! Botonkam de tawa ta gwibin zini sa ebon mae yaïng gwe-gwezal. Ol toran nakon esa kïl lï gwibir, ‘An hen nëban mae apdenak– Alap mo hanan tabin walas.’ Hwëna zen in gwe tïhï jal-jal makarena. Zen sa emsa hit di gwibir. ");
INSERT INTO ury_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Em zëre mae mo lowehen nakon hen syala kon esa ki dam lasïk gwibir. Kwiwe dansa bëjen lemo timnik taran. Hen dokot të ngï-ngïna bëjen rambutan dankam tën. ");
INSERT INTO ury_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Men kiye hen tenya: Zen zëre mo dan enkam ëtë gwenan. Tenya men zen twin gwibin srëm tetan dankam ëtë gwenan, zen bëjen twin gwibin tetan dankam tën. Hen tenya men zen twin gwibin tetan dankam ëtë gwenan, zen bëjen twinbin srëm tetan dankam tën. ");
INSERT INTO ury_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tïngare tenya men zen twinbin tetan dankam ëtë srëm gwe-gwenan, zen lu tan en hap dena– desa de syauk blanak tru tasen hap. ");
INSERT INTO ury_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Zen kirekam hen– botonkam de tawa ta gwibin zini inye. Em zëre mae mo syala kon hen lowehen nakon esa ki tame la gwibir.” ");
INSERT INTO ury_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Tïngan men zen Asa anakan daken gweblanan, ‘Bian, Bian,’ hwëna zen molya kïtak Alap mo ïrïk gïnnïk bïtï gwek. Diki men zen zëre mo dwam gwibin sin syal ta gwenan, zen zen en sa zëre mo ïrïk gïnnïk bïtï gwer. ");
INSERT INTO ury_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Aumwa hap de zisi klis gunnuk, zini beya tangan nik sa Asa daken gweblal, ‘Bian, Bian, ëe ere mo bosekamë hamal hap de ola ayang ul gwizimk. Hen ëe eno bosekamë dowal-dowala olëalsa sone gwibik. Hen owas-owasna eno bosekamë syal ei gwibik.’ ");
INSERT INTO ury_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hwëna Ëe asa ding gulzim, ‘Em Abon dep denaka hom. An kon em hëndep sek gwen, sap em an zene karekna ol gwek.’” ");
INSERT INTO ury_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Zen in zep, zini men zen ano ola ësane gwe-gwenan hen desan ang ta gwenan, zen men kiye– enlala blala bare zini men zen gola moko dawem naban taukuke. ");
INSERT INTO ury_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kim o dïl gwek, ho namwa yawala dekam zep sap desan tïlzïk, hen asese yala dekam zep sap akabla zaka, sap zëno mokona olk san de hul-hul tanna. ");
INSERT INTO ury_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Hwëna zini men zen ano ola sap ësane gwe-gwenan hwëna desan de ang tan srëmkam, zen men kiye– enlala joblo-top zini men zen moko srëmkam gola taukuke. ");
INSERT INTO ury_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Hwëna kim o dïl gwek, hen ho namwa yala kim desan tïlzïk, hen asese yala kim taïlkï, dekam zep hëndep gola in mal heka, hëndep karek tangankam dreweka.” ");
INSERT INTO ury_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus kim kirekam tawa tasibirki, zi beyam-byana in zen zë sane daꞌak man tangan denggwanblak. ");
INSERT INTO ury_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Sap zëno tawa tabinni soson tanganna– san de teipsïn zi mo tawa tabinni kiye. Musa mo olsa de tawa ta gwibin hip de zi mo tawa tabin niban apdenak hom. ");
INSERT INTO ury_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesus kim kwatap tek nakon ati gwe zaka, zini beya tangan nik zep ang nëblazak. ");
INSERT INTO ury_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Zao zep hen sop sang-sang karek nabare zini Yesus onak dep hata zaka, boklesa zep Yesus mo nwenak kom so zaka. Dekon zep abe ta seka, “Bian, Eme dwam gweꞌanam, Em emaka asa dawem taꞌara.” ");
INSERT INTO ury_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesus ki zep towanblan naban ding gulbluka, “Ëe ama dwam gweꞌan. Em dawem gwen.” Dekam zep hëndep sop sang-sangna in kon dawem gweka. ");
INSERT INTO ury_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Zao zep etan gubluka, “Insa emsa dawem tanan, bahem mae ahasa tonbiridan. Diki nonol Alap mo golak de syal tan zi hip ahana kip enaka zertrëbla. Zao gublu, ‘Emki asa hla tan. Ëe san ha mesë dawem gwer?’ Musa Bak mo tïtï tabin olak men kirekam sop sang-sang karek zi de dawem gwennak dep dena lwakke, zen kirekam em syal gwibin. Zen dekam sa tïngan emsa anakan tame dal, ‘Zen eiwa mes tangan dawem gweka.’” ");
INSERT INTO ury_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesus kim Kapernaumk hata onka, ki zep zë Roma mo jana zi mo mamna Zëbon onak dep hata zaka, zao zep Yesussu mas gweblan hap abe ta gweꞌanka. ");
INSERT INTO ury_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Man zë gubluka, “Bian, abon de babu gwe-gwen zini golak sang-sang sabak nik gwëꞌara. Zen ni ensa ta gweꞌara. Luwen maena banakan dep.” ");
INSERT INTO ury_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus ki zep ding gulbluka, “Ëe asa desan dawem tan hap song gwer.” ");
INSERT INTO ury_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Hwëna jana zi mo mamna in ki zep ding gulbluka, “Bahem, Bian. Ëe dawem naka hom, zep ëe ama saher gweꞌan– em de ano golak hatan hapye. Hwëna anakan-en Em gun, ‘Zi sang-sangna in zen dawem gwen,’ dekam sa dawem gwera. ");
INSERT INTO ury_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Sap ëe mesë Emsa taïblïblak, ‘Eno ol-gunnu bëjen kirekam lwa srëm gwen.’ Sap abon onakon de teipsïn zini ki. Ano otdenak dena hen ki. Ëyë ëre mo otdenak denaka gubluꞌanam, ‘Em song gwen,’ zen dekam maka song gweꞌara. Hen ahanakaë gubluꞌanam, ‘Haen,’ zen hen dekam maka song gweꞌan zala. Ëyë ëre hon de babu gwen zisi gubluꞌanam, ‘A desa syal gwibir,’ zen dekam maka hëndep syal gwibiꞌira. Ëe sap teipsïn tola, zep ano ol san kirekam ang ta gwenan. Hwëna Em in teipsïn tanganna, zep eno ol san sa ki kirekam lwal.” ");
INSERT INTO ury_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesus man tangan tenggwanblaka– zëbon onakore olsa de kirekam sane gwenkam. Dekam zep zi trana in zen ang nëblan daꞌak desa lero gwibiridaka hen gubiridaka, “Eiwa, zini in man Asa taïblïblaꞌara. Ëe homë mae Israelk kirekam de sërkam Asa taïblïblan zini zertowek. ");
INSERT INTO ury_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","In zebë emsa gubiridaꞌan: Yakla hata sezan nakon hen nikin anen nakon, Yahudi srëm zini beya tangan nik sa tagal gwer– Alap mo ïrïk gïn kon gwisibir hanan tembane yawalak de apdekam ëisrip-sri gwen hapye, Abraham, Isak, hen Yakob mae han. ");
INSERT INTO ury_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Hwëna Yahudi zini, zen diki zen tangan– Alap mo ïrïk gïnnïk de sap bïtï gwen hap de wenyaye. Desa hwëna beyakam sa kawesïn sïn dep yal nulin– men dekon zi mo angna yusyustïn nïban gona ta gwenanke, hen sang-sang hap ëkna ngalk-ngalk da gwibirinke.” ");
INSERT INTO ury_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Hwëna Yesus ki zep etan jana zi mo mamna insa gubluka, “Angkam sap esa song gwera. In kirekam ena Asa taïblïblala, in zep sa ki kirekam lwal.” Zëre hon de babu gwe-gwen zini in hëndep dekam zep ki dawem gweka. ");
INSERT INTO ury_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesus ki zep Petrus mo gol san song gweka. Zëwe zep Petrus mo we marena hlauꞌun zaka. Ewen naban nisi taꞌak. ");
INSERT INTO ury_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Zao zep wenya insa tahanak towanbir ineka. Ewenna in kon dekam zep hëndep sër gwek. Dekam zep hëndep luwek, hen dekam zep tembanekam mas gweblak. ");
INSERT INTO ury_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yaklana kim dum gwe heka, dekam zep zini dowal de tïlbiridan zi sang-sang beyam-bya naban Yesus onak dep nolëyaïng gwezak. Yesus ol-gun enkam zep dowal-dowala insa golëalsa sone gweꞌanka, hen tïngare zi sang-sang beyana insa dawem ta gwibiꞌinka. ");
INSERT INTO ury_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","In kim kirekam syal gwibirki, dekam zep zauk– zëre hap dena mensa Alap mo ol ayang gul gwen zini Yesaya Bak orep ayang gulzimkiye, “Zen sa nëno mae mo karek-karekna hen sang-sangna mensa nihin makan wei kulsuk gwenan tonzim iri.” ");
INSERT INTO ury_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesus kim zi beyam-byana insa anakan hlauludaka, “Zen mes Asa dot dasïnïn,” dekam zep zëre hon de ang ta gwen wenyaka gubiridaka, “Nen ho gutuna an mo men eihya san tablan gwe kïnïn.” ");
INSERT INTO ury_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hwëna ki zep zë Musa mo olsa de tawa ta gwibin zini Yesus hon dep hata zaka. Zao zep gublu zaka, “Bian Guru, men desane ki të gweꞌanka, ëe asa Emsa ang gweblanda gwer.” ");
INSERT INTO ury_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ki zep hwëna ding gulbluka, “Gwenya witir zem ki. Hen mawana zol zem ki. Hwëna ngatan zi mo lang nakore Zi Tanganna ano ni ta gwen gola hom.” ");
INSERT INTO ury_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Zi beyana in zen dekam ang nëblanda gweꞌak, etan ahanik zep hwëna gubluka, “Bian, ëe asa lamkam Emsa ang gweblanda gwer, hwëna nonol ë san anik lwahak. Ëre mo bian de tïn hyanak asa Ebon dep hatazal.” ");
INSERT INTO ury_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Hwëna Yesus ki zep ding gulbluka, “Em angkam emki hëndep Asa ang gweblan. Eno bian de tïnkïm, dikire tok bose zik lo dasïk.” ");
INSERT INTO ury_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Dekam zep hëndep Yesus zëre hon de ang ta gwen wenya ban bulkum men eihya san dep golësek gweka. ");
INSERT INTO ury_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mumuk ennak zep hwëna ho gutuna in mam enkam ngëp-ngep gweka, hëndep bulu in dekam sek gweꞌak sop gun hup zep alp gwesïꞌïk. Hwëna Yesus Zëna dekam nama nisi mumukkum taꞌanka. ");
INSERT INTO ury_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Hwëna dekam zep anakare ola ban lï dak, “Bian, nënaka Em ngaya tabin! Nen an em-am angkam juweꞌan!” ");
INSERT INTO ury_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ki zep ding gulzimki, “Em ba habe ëaïrïꞌan? Em an eiwa home Asa laïblïblaꞌan.” Ki zep hëndep luweka, dekam zep asese naban ho ngëp naban jalse gwizimki. Dekam zep tangan hëndep së nëhek. ");
INSERT INTO ury_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Zëre hon de ang ta gwen wenya in dekam zep tenggwaran naban ëguk, “Eiwa, zini an wehasa hom! Ba hap tangan asese naban ho ngëp naban betek nëblanan!” ");
INSERT INTO ury_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ho gutu men eihyanak kim golëyaïng gwe naka, Gadara mo langnak, zao zep dowal beyam-bya mo bi gwizimdin zi darena Yesus onak dep apta zaka. Zi darena in zi tok lo tasïk gwibin kaso-hul kaso-hulak ënda gweka. Zen sërkam de jal-jal darena, zep zini desan ëgwahal srëm gwe-gwek. ");
INSERT INTO ury_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Zen dowal beyam-byana in mo hërhen ola ban wet oso zaka, “Alap mo Tane, Em aban mae toton banakan de syal tan hap? Em san ere mo yakla yawalak de zaun srëmnak de asa karek tabin hibe hataꞌara?” ");
INSERT INTO ury_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Zëno mae mo nwe kara gwen san zaho beyam-byana tembane hap kwatap tïnï san ëhakaꞌak. ");
INSERT INTO ury_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Dowal-dowala in ki zep Yesussu aberbe da gweꞌak, “Em de zi darena an kon wet so gwen hap asa gubiridankam, Em wëhë asa zaho trana wakuwe de bïtï gwen hap gubiridaꞌanka?” ");
INSERT INTO ury_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesus ki zep gubiridaka, “Em sek gwen.” Dowal-dowala in dekam zep hëndep zi darena in kon wet so gwek, dekam zep hwëna zaho trana iwe bïtï gwek. Zahona in dekam zep hëndep heya-hya gwenkam li san syalk ta tinek, hëndep ho gutunak zep ëkei-king gwek. ");
INSERT INTO ury_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Zahona in zen kara da gwibik, dekam zep ë san dep heya-hya gwek, hen ëaïsïl gwenak– tïngan in zen ki zë owasna lwakke, zahonak hen dowal mo tïlzimdin zi darenak. ");
INSERT INTO ury_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Dekam zep ëna iwe de zini kïtak sek gwek– Yesussu de zertowen hap. Kim zë hla dak, zao zep blikip gwesïblïn naban abe dak– Zen de nabakam zëno mae mo langna in kon song gwen hap. ");
INSERT INTO ury_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ki zep Yesus bulkum lwahal zaka– zëre mo gwë gwen ëna Kapernaum sun dep. Zao zep etan zi beyam-byana tagam nëblazak. ");
INSERT INTO ury_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Dekam zep hen zi sang-sangna taha-tana teisya ine gwen srëm naka beryak de ziredan naka nërhatazak. Yesus kim anakan tame tabirki, “Eiwa, zen man tangan Asa daïblïblaꞌan,” dekam zep zi sang-sangna insa gubluka, “Tane tol, bahem ngalap gwen. Eno karek-karekna mesë ep tap gulsublunan.” ");
INSERT INTO ury_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Musa mo tïtï tabin olsa de tawa ta gwibin zini kim zë Yesussu kirekam sane daꞌak, dekam zep enlala ennak donsubluꞌak, “Zi bose zik mo karekna insa tap gulsublun hap gunda, zen man kïl gïꞌïra, ‘Ëe an Alap han apdenak.’ Kirekam insa gunda, zen Alapsa lamang tanda.” ");
INSERT INTO ury_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesus hwëna mes zëno mae mo enlalana tame tazimki, ki zep gubiridaka, “Em in kirekame enlala ennak Asa lonsubluꞌan, zen ere mae mo enhosae kim karek laꞌan! ");
INSERT INTO ury_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Em ema ano ola husus eibir– anakan insa gublulye, ‘Eno karek-karekna mesë ep tap gulsublunan.’ Hwëna anakan de gublunkam, ‘Em luwen, hëndep song gwe,’ san esa hen etan husus eibir? Sap ol-gun darena in apdenak– Alap mo sosonkam de gublun ol. ");
INSERT INTO ury_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Hwëna angkam Ëe ama ebe mae hap goltreizimꞌin– em dikim Asa anakan tame tan hap, ‘Alap mes ki ngatan zi mo lang nakore Zi Tanganna abe hap sosonna golblaka– okamanak awe dikim zi mo karek-kareksa tap gulsuk gwizimdin hip denaye.’” Ki zep hwëna etan zi sang-sangna insa gubluka, “Em luwen. Ere mo berya insa teisya, ki gol san song gwe.” ");
INSERT INTO ury_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Zi lekna in dekam zep hëndep luweka, ki zep hëndep zëre mo gol san dep song gweka. ");
INSERT INTO ury_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Zi beyam-byana in kim owasna insa hla nuk, dekam zep aïrïn nïban Alap mo bosena teip nulsuk gweblaꞌak, sap Zen dekam zëre mo soson yawalsa Yesus osan okamanak de zi hip golzimꞌinka. ");
INSERT INTO ury_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesus kim dekon song gweꞌanka, dekam zep Roma mo ïrïk gïnnïk dep de pajak te-ala alal ta gwizimdin zini asa hla taꞌanka. Ano bosena Matius. Ëe ëre mo syal gwe-gwen teksonnakë nikinꞌik. Zao zep asa gublu zaka, “Haen. Asa em ang gweblan.” Ëe ki zebë luwek, ki zebë hëndep ang gweblak. ");
INSERT INTO ury_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesus kim ano golak golëtembane taꞌanka, dekam zep hen ahakore pajak te-ala alal tanda gwen wenya beya enkam yaïng gwezak. Hen ahakore karek-karek gulin halasen gwen wenya man zë hen beyakam yaïng gwezak. Ki zep hëndep apdekam Yesus mae han tembane taꞌak– hen zëre hon de ang ta gwen wenya ban. ");
INSERT INTO ury_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisikam de gubirida gwen zini kim zë hla nulidazak, dekam zep Yesus hon de ang ta gwen wenya insa nenbiridazak, “Eno mae mo guruna in ba hap tangan pajak te-ala alal tanda gwen zi niban apdekam golëtembane taꞌara?– hen ahakore karek-kareksa de gulin halasen gwen wenya banye! Zen in kwae nabanke!” ");
INSERT INTO ury_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesus kim kirekam salbiridaka, ki zep ding gulzimki, “Zini, sang-sang srëm wenya, zen hom doktersa dwam në gweblanan. Zen diki zi sang-sang en dwam në gweblanan. ");
INSERT INTO ury_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ano syalsa de dam gulsun hup, diki dawemna Alap mo ola ansa emaka klis uꞌin, Zen kim anakan Israelsa gubiridakake, ‘Ëe a kirekam de lowehe gwen habë mo emsa dwam gwibiridaꞌanye: Bol-zaun tanganna, aha zi mo karek-kareksa kwasang naban em eititi gwe-gwibin. Ere mae mo karek-karek hap de kire-kiresa abe hap tru tasïk gweblansa, zen abe hap bol-zaun tangan naka hom.’ Zep Ëe ansa okamanak hatazak, Ëe karek-karek gulin halasen gwen wenyaka de kwang guludan habë hatazak. Men zen zënaka tim di gwibirin, ‘Ëe an dawem-dawemna,’ Ëe desa de kwang guludan hap homë hatazak.” ");
INSERT INTO ury_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Zao kim lwa seꞌak, ki zep baptis ta gwibin zini Yohanis hon de ang ta gwen wenya Yesus hon yaïng gwezak, ki zep zë dakensïblïk, “Ëe ama Alapsa dikim enlala zon tasïblïn naban abe ta gwen hap etan-etankam tembanena ëlwa gwenan. Farisikam de zini hen kirekam ëgwë gwenan. Hwëna ebon de ang ta gwen wenya ba hap kirekam syal neibir srëm gwe-gwenan?” ");
INSERT INTO ury_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesus ki zep ding gulzimki, “Abon de ang ta gwen wenya kip man dakastïlzimꞌin– an kirekam tembanesa de ëlwan srëmkam lowehe gweꞌanye. Sap zen angkam teipsïn zisi de zergwën makan Asa nërgwë gweꞌan. Hwëna jal zini kim de Asa jek-jak daꞌak, Abon de ang ta gwen wenya dekam molya tembane tak. Embwan hap sa baes tal.” ");
INSERT INTO ury_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Etan ki zep kire hap gulk sun de ol blaonzimdinni dan mas sozimki, “Zi mo baju kwang de hul nënkam, zen bëjen deyol sop ësekam makan tazimdin. Kirekam bëjen dakastïn. Sap ngan sosunkum deyol ësena in de yok gweꞌak, dekam sa baju ëpba hula in mam enkam etan kalk nër. ");
INSERT INTO ury_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Hen kirekam, anggur ho ësesa bëjen kambing sopkam de botol ëpbanak yuren. Kirekam hom dakastïꞌïn. Sap anggur ho ësesa de kambing sop botol ëpbanak yurenkam, anggur hona in kim de nopna taïl gïꞌïk, kambing sopkam de botola in dekam sa kalk nër, hen anggur hona in dekam sa zalta dep hlëweher. Anggur ho ësena zen diki kambing sop botol ësenak de yurenkam dakastïꞌïn– apdenak dikim dawemkam nolan hapye. Zep hen kirekam, Abon de ang ta gwen wenyik de etan ëpba lowehen san abarenak ang tan hap hom dakastïꞌïn.” ");
INSERT INTO ury_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus kim nama baptis ta gwibin zini Yohanis hon de ang ta gwen wenya ban ola golëtonꞌanka, ki zep zë Yahudi mo but srëm golak de aha mamna hata zaka. Zao zep Yesus mo nwenak boklena kom so zaka, dekon zep gu seblaka, “Ano wenam tola nër hom tangan tïlïn. Hwëna nen ki song ën. Em de tahasa tehabir anenkam, zen sa etan ngaya gwer.” ");
INSERT INTO ury_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesus ki zep hëndep luweka, dekam zep zëre hon de ang ta gwen wenya aban mae zini insa ziang gweblaka. ");
INSERT INTO ury_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","In kimë sek gweꞌak, wenya ki zep Yesussu tahan nakon golek de tazak. Wenya in man aura gwe-gwek. Tahunna mes dua-blas enkam altïlsibik– sang-sangna in han de gollwa gwennakye. Zen man enlala gweꞌak, “Baju mae ennakë towanblaꞌak, ëe dekam asa dawem gwer.” Ki zep hëndep baju sïhï top nakon olk ta sonek. ");
INSERT INTO ury_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus ki zep hëndep tahan san lero gweka, dekam zep wenya insa hlaulku, zao zep gubirki, “Anyan, bahem ngalap gwen. Em ema Asa taïblïblala, zebe dawem gwenda.” Wenya in hëndep dekam zep ki aurana in tewesibik. ");
INSERT INTO ury_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","But srëm golak de mam zini in mo golak kim asa golëyaïng gweꞌanka, anakan zebë hla kulidaꞌak, “Zini beya nik ol mamkam gosa dabiꞌin, hen ahakon sulingkim sei go tërya daꞌan.” ");
INSERT INTO ury_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesus ki zep zë gubirida kïnzïka, “Em kïtak wet so gwen. Wenam tola an hom tïl. Zen nisi am taꞌan.” Zen hwëna man swrë da gweꞌak. ");
INSERT INTO ury_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ëe kimë kïtak olëalsa sonek, Zen ki zep hwëna teksonna in zao wenam tol tokna lwaꞌak desan dep tïlkï. Taha nakon kim gul ineka, dekam zep hëndep wenam tol tokna in etan ngaya gwek, hëndep zauk. ");
INSERT INTO ury_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","In desa zë owasna kirekam syal gwibirki, dekam zep ki hëndep tïngare langna iwe de ë-ë san nol haladak. ");
INSERT INTO ury_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesus kim dekon etan asa golësek gweka, ora nakon zep zi nwe dïmïn darena ërtro kïnzïka. Ki zep kon laken soneblaka, “Daud Bak mo Auyan-tane, asa Em kwasang gwizimdin.” ");
INSERT INTO ury_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ëna iwe de golak kim asa golëbïtï gwe zaka, zi nwe dïmïn darena in ki zep zë hen lïl zïka. Yesus ki zep zë takensizimki, “Em san ema Asa anakan laïblïblaꞌara?– ‘Zëbon sosonna ki– asa dikim dawem son hap denaye.’” Ki zep ding ulblika, “In kirekam, Bian.” ");
INSERT INTO ury_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ki zep nwenak anakare ola ban towanzimki, “In kirekam ena Asa laïblïblala, in zep sa kirekam ebe nikip lwazim.” ");
INSERT INTO ury_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Dekam zep ki hëndep nwena kara ëka. Zao zep guzimki, “Owasna an zen ki ebon nebon lwanan, bahem aha maesa lonbiridan.” ");
INSERT INTO ury_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Hwëna zen kim kon song ëka, dekam zep ki hëndep tïngare langna in san ol haladaka– Yesus insa owasna kirekam syal gwibir-zimkiye. ");
INSERT INTO ury_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yesus kim asa etan dekon golësek gweka, dekam zep hen dowal mo bi gweblan zi ol srëmna Yesus onak dep nërhatazak. ");
INSERT INTO ury_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesus kim dowala insa zëbon onakon zeralsa soneka, dekam zep hëndep ola tonka. Zi beyam-byana in man tangan denggwanblak, hen man ëgu gweꞌak, “Nen homë mae Israelk awe kirekam de owasna aha-en mae hla kuk.” ");
INSERT INTO ury_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Hwëna Farisikam de gubirida gwen wenya man ëguk, “Zen dowal mo kïgï sosonna golblaka– dekam de aha dowal-dowalsa golëalsa sone gwen hap denaye.” ");
INSERT INTO ury_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesus ki zep langna iwe de tïngare ë-ë san zëre hon de ang ta gwen wenya aban mae ziamjanbir song gweka, hen desan de but srëm gol-gol san tawa tabir song gweka. Zen Alap Zën de ïrïk gïn hïp de ol dawemkam tawa tabir song gweka, hen men zen kirekam-kirekam sang-sang karek naban nollwa gwek, desa man kïtak dawem tabir song gweka. ");
INSERT INTO ury_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesus kim zi trana insa hlauluda song gweka, Zen man tangan kwasang gwibirida gweka. Sap zen hom eiwa de orana tame daꞌak, hen mes tangan ësin-sin gwek– men kiye, bi srëm zahona. ");
INSERT INTO ury_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Dekam zep abe mae en hap ola gulk sun blaonzimki, “Nga yala awe de obwagana mes mamkam bïl gwera, hwëna men zen de taran hap dena dan en tangan. ");
INSERT INTO ury_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Zen in zep Nga Bi naka em abe ta gwen– Zen deka zisi nga yala awe de syal ta gwen hap lup gul sone gweka.” ");
INSERT INTO ury_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Zao kim lwa seꞌak, Yesus dekam zep dua-blaskam de zëre hon ang ta gwen wenya asa tagal gulsuku, zao zep sosonna abe mae hap golzimki– ëe dikim dowal-dowalsa golëalsa sone gwen hap, hen kirekam-kirekam sang-sang karek gollwa gwen zisi dikim dawem ta gwibin hip. ");
INSERT INTO ury_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Dua-blaskam de dam tasibin zini, ano mae mo bosem-sena, nonol Simon– mensa hen “Petrus” kum nen gweblanan, oso zem Andreas han. Hen Zebedeus mo walas darena, Yakobus oso zem Yohanis hin. ");
INSERT INTO ury_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Hen Pilipus ne Bartolomeus ne, Tomas, hen aena, Matius. Ëe menkam Roma mo ïrïk gïnnïk debë pajak te-alasa alal ta gwek. Hen ahana Alpeus Bak mo tanena Yakobus, hen ahana Tadeus. ");
INSERT INTO ury_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Hen ahana Simon– in zen nonol Israel dikim Roma mo ïrïk gïn nïkon ëzë-en gwen hap de ëasas gwennak ang gwekake. Hen ahana Kariot walya Yudas. In zen sa Yesussu zergulu. ");
INSERT INTO ury_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Dua-blaskam de wenya asa dekam zep anakare ol zïm-zïm nïban lup gul soneka, “Yahudi srëm zi mo ë-ë san bahem sek gwen. Samaria mo ë-ë san hen bahem. ");
INSERT INTO ury_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Diki Israelk de zi ensa em amjanbin– sap zen san de bi srëm zahona kiye. ");
INSERT INTO ury_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","A kirekam lonbirida song gwek: ‘Alap man angkam Zën de nësa teipsïnkïm ïrïk gïnkïm kon gwesibir hanaꞌara.’ ");
INSERT INTO ury_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Zi sang-sangna dawem la gwibik. Hen tïnnï ngaya la gwibik. Hen sop sang-sang karek nabare zini dawem la gwibik. Hen dowal-dowala olëalsa sone gwek. Ëe asa kire hap de sosonsa ebe mae hap totoresa golzim, zep em hen kirekam totoresa mas eibirida gwek. ");
INSERT INTO ury_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Te-alana bahem mae lop tan– sap yawala, sap hen betek maena. ");
INSERT INTO ury_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ora san dep de tembane taïblïn honna bahem hen wëwek tan, hen pakeanna timnik de enna kim sek gwek. Hen sepatuna ala son enna kim emki sek gwen. Dutena hen bahem mae kap tan. Em in Alap mo syalsae oꞌan, zep em men desae tawa la gwibiꞌik, zen zen sa ebe mae hap tembane maena nol gwizim– zao dikim lowehen hap denaye. ");
INSERT INTO ury_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Em de ënak yaïng gwe-gwennak, nonol mae hap em ëhakalsïk gwen, ‘Nara zi wëhë asa ëna an kon zer inꞌinka?’ Men zen emsa zer irinni, zëbon en emki gwën, hëndep dekon en emki etan song gwen. ");
INSERT INTO ury_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Golak de tïn nïkon, nonol anakan em ëgu kïnï gwen, ‘Dawem. Em Alap mo taha terenake lowe heꞌan.’ ");
INSERT INTO ury_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Zao de Alap osan dep de hohle gwen nik gwëꞌanka, ki eiwa zao esa Alap mo taha terenak dawemkam lowehe gwer. Kire nik de gwë srëm gweꞌanka, ki emki enbirida gukhan, ‘Ëe mensa nonol emsa enbiridal, Alap mo taha terenak de sap lowehen hap dena, awe molya ki lwak.’ ");
INSERT INTO ury_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Hwëna men dekore ë nakon emsa anakare ola ban zer irin srëmna, ‘Em ba habe awe hataꞌan zala? Ëe ama emsa de salblanna baes taꞌan,’ dekam em kon song gwen. Hen ere mo tana sonsa em zë taïk-tïk so gukhan– zen dekakim anakan tame nuk, ‘Zen sap Alap onakore ol dawem naban nëbe mae hap golhatazim zira, hwëna nen insa ër-in srëm gwenan nëre mae hap de kareksae kim mam ulin.’ ");
INSERT INTO ury_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Eiwa denakaë emsa gubiridaꞌan: Aumwa hap de zisi klis gunnuk, Alap ëna insa anakan sa enlala gweblala, ‘Zen orep de ëna Sodomk de zisi ëkarek gwenkam man kwei-kwik nuk.’ Zep men kirekam Alap orep Sodomk de zisi zëre mae mo karek-karek hap heip gulku, hwëna ano lup gul sonen zini emsa de lup gul irin srëm zini, desa aumwa hap de klis gunnuk sërkam tangan sa karek tabiri.” ");
INSERT INTO ury_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Emki ëenlala gwen: Ëe domba makare soson srëm nakaë emsa lup gul soneꞌan– gwe tïhï jal-jal ngïrïn sïn dep. Zen in zep terya-tyakam sek gwek– men kiye, wanya de song gwenna. Hwëna sae-sae enlalakam em sek gwen– men kiye, mawana ohola mo enlalana. ");
INSERT INTO ury_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Zep terya-tyakam lowehe gwek, sap emsa sa Yahudi mo but srëm gol-gol san dep dahyohal gwer. Hen zëwe de teipsïn-teipsïnnï sa emsa de tangole gwibin hip nenbirida gwer. ");
INSERT INTO ury_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Em an Asa de ang gwe-gweblanna, zep emsa sa pemerinta mo teipsïn-teipsïn zi sin dep kap nulhal gwer. Zen kirekam Alap mo dwam gwibin sin sa ki ebe mae hap lwa gwizim– em dikim zë Yahudi mo teipsïn-teipsïn nïka hen Yahudi srëm zi mo teipsïn-teipsïn nïka abe hap denaka tonbirida gwen hap. ");
INSERT INTO ury_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Zep emsa de kap gulhal gwennak, em bahem anakare hap enlalana ëbeya gwe-gwen, ‘Ëe banakarekam asa zë ding ul gwizim?’ Sap men kirekam de ding gul gwizimdin hip dena, zen emsa de taken-taken gweblan ennak sa ki Alap ebe mae hap gol gwizimdi. ");
INSERT INTO ury_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Sap dekam em en molye ola lon gwibik. Hwëna ngatan zi mo langnak de Bian mo Enho sa eno mae mo ëk tïhï san ding gul gwizimdi. ");
INSERT INTO ury_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","22","“Emsa sa tïngare zini husus neibirida gwer, sap em an Asa de ang gwe-gweblan wenya. Zep a kirekam sa ebe mae hap lwa gwizim: Emsa ere mae mo aya-wal oso-wal tanganna sa tameran hap nolëgu gwer. Hen emsa ere mae mo bi walya sa tameran hap nolëgu gwer. Hen ere mae mo walasna sa emsa abe hap de jal hap nolëtobe gwe-gwer, hëndep tameran hap sa hen emsa nolëgu gwer. Hwëna em in zene Asa de taïblïblannak tatem ëzauk gweꞌak, hëndep aumwa hap denak de hataꞌak, em esa ëngaya gwer. ");
INSERT INTO ury_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Zep emsa de aha ë maenak karek tabinkim, dekon aha ë san em heya-hya gwen. Sap eiwa denakaë emsa gubiridaꞌan: Em de tïngare Israel mo ë-ësa amjanbiridankam sul sonen srëmnak, ngatan zi mo lang nakore Zi Tanganna Ëe dekam asa lwa halzal. ");
INSERT INTO ury_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","“Zep gulk sun de ol blaoranna ansa emki enlala gwe-gwibin: Sekola walasna, zen mam naka hom– guru zem onakonye. Zep guru zemka de aha zi lamang ta gwenkam, sekola walas zem insa hen sa kirekam lamang da gwibir. Sekola walasna in sa sam gwesïlï– zen de guru zemka tana wei san zertronkamye. Hen kirekam, zi mo tana ïltïkïnnïk de babu gwe-gwen zini, zen hen mam naka hom– zëre mo zi bina in onakonye. Ëe an sap gol bi nikë awe gwëꞌan, hwëna Asa man lamang da gwenan, ‘In dowal mo kïgï mo sosonkam syal gwe-gweꞌara.’ Zep em Abon de ang ta gwen wenya, Asa de tana wei san zertronkam, emsa hen kirekam sa lamang da gwibir.” ");
INSERT INTO ury_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Zen in zep, zi bose omka bahem aïrïbirida gwen. Sap karekna mensa aningkim ebe mae hap nol gwizimnin, desa sa Alap lamkam golwet sola. Hen kalangna mensa Alap aning gul gweka, desa sa hëndep tïngare zini hla nul. ");
INSERT INTO ury_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ëe mensa kam golak emsa tonbirida gweꞌan, em hwëna desa yaklam neik tagal gwennak lonbirida gwek. Men desaë në-erenak emsa tonbirida gweꞌan, em hwëna desa ol mam-mamkam neik tagal gwennak lonbirida gwek. ");
INSERT INTO ury_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Zi bose omka bahem aïrïbirida gwen, sap zen auhu-kama tim en naka damera gwenan. Hwëna zëno mae mo sosonna hom tangan– ang naka de karek tan hap denaye. Diki Alap ensa em aïrï gweblan, sap Zen Zëbon en sosonna– tim niban ang naban de syauk blanak karek son hap denaye. ");
INSERT INTO ury_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Emki mawana taïnïm bes-beꞌa enlala gwibiridan. Desa zini hom te-alakam de kap gun hup dwam neibirida gwenan. Sap eiwa kirekam, hwëna zen hen aha-en mae molya kama san zanka– nëno mae mo Bian de kirekam dwam gweblan srëmkamye. ");
INSERT INTO ury_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hen kirekam, eno mae mo nol alana, Bian mes desa anakan tawa gwibirki, ‘Beyana ki en.’ ");
INSERT INTO ury_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","In zep ere mae mo tim hip dena bahem ëngalap gwe-gwen, sap em Alap mo nwenak mawana taïnïm bes-bes naban apdenak hom.” ");
INSERT INTO ury_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Zen in zep, zini men zen aha zi hon zënaka anakan kira ta gwenna, ‘Ëe an Yesussu de ang gwe-gweblanna,’ kire zini Ëe asa hen ngatan zi mo langnak de ëre mo Bian hon anakan kira tal, ‘Zen an hen eiwa Asa de ang gwe-gweblanna.’ ");
INSERT INTO ury_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Hwëna men zen de Asa aha zi hon anakan nazabeblaꞌak, ‘Ëe Yesussu de ang gwe-gweblan zisi hom,’ ki Ëe hen anakan asa desa kira tal, ‘Zini an Asa de ang gwe-gweblan naka hom.’ ");
INSERT INTO ury_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Bahem anakan Asa kïl tï gwen, ‘Zen an umlaesa de okamanak awe golhatazan hap hata zaka.’ Ëe kire hap homë. Hwëna abe hap de jal hap Asa de tame tan srëm wenya sa emsa tameran hap gïl-gïl neibirida gwer. ");
INSERT INTO ury_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ëe ansa hatazak, zen dekam sa ebon mae onak anakarekam lwa gwer: ‘Zi walasna zen bi wal zeban sa zënaka gïl-gïl neibirida gwer. Wenam tol-tolkam dena, zen an wal zeban sa zënaka gïl-gïl neibirida gwer. Hen we walya, zen aebo wal zeban sa zënaka gïl-gïl neibirida gwer. ");
INSERT INTO ury_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Dekam ere mae mo iyena, zen zen sa ebe mae hap de jal zi hip ëjower.’ ");
INSERT INTO ury_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Men zen bi zemka dawemkam enna nolabirida gwenan, hwëna zëno mae mo Asa de en lwablanna man lwala heꞌan, kirekam de zini zen hom ësam gwesïꞌïn– Abon de ang ta gwen hapye. Hen kirekam, men zen an zemka, ahaksa walas zemka dawemkam enna nolabirida gwenan, hwëna zëno mae mo Asa de en lwablanna man lwala heꞌan, zen hen hom ëdakastïꞌïn– Abon de ang ta gwen hapye. ");
INSERT INTO ury_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Hen zi de zënaka anakan sosok tan srëmna, ‘Asa sap sa Yesus mo kim te-lidak sonnak makan dain,’ zen hen hom Abon de ang ta gwen hap ësam gwesïꞌïn. ");
INSERT INTO ury_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sap men zen zëre mo auhu-kamanak de gwënsa anakan golaïrïꞌanka, ‘Ëe babë Yesussu de ang gwe-gweblannak karekna goltowe gwen,’ ki zëno gwënna in sa jek-jak gweblal. Diki men zen Asa de ang gwe-gweblan hap zëre mo gwënna sosok guꞌunka, hëndep zao mae de tïn hïp, zen zen sa hëndep denaban ngaya gwera. ");
INSERT INTO ury_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Men nara ano zer sonen zini emsa zer irinni, zen ki hen Ënaka zer inꞌira. Hen men zen Ënaka zer irinni, zen hen Bian, men Zen Asa zer sone zaka, Desa hen zer inꞌira. ");
INSERT INTO ury_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Men nara Alap mo ol ayang gul gwen zisi zer irinni, anakare hap, ‘Zen an Alap mo olsa ayang gul gweꞌara,’ ki Alap sa hen enlala gweblala, ‘Zen hen syal bose zem.’ Zep Alap mo olsa de ayang gul gwen hap de dawemna, desa sa hen Alap zëbe hap lamkam golblala, sap zen kire zisi mas gweblaka. Hen kirekam, men zen enlala dam-dam enkam de gwë gwen zisi zer irinni, anakare hap, ‘Zen Alapsa betek gwe-gweblanda,’ ki Alap sa hen zëbe hap dam-damkam de gwë gwen zi hip de dawemna golblala. ");
INSERT INTO ury_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Eiwa denakaë emsa gubiridaꞌan: Men nara aha-ere ho mok mae tolsa bose srëm zi hip golblanna, anakare enlala naban, ‘Zini an hen Yesussu ang gwe-gweblanda,’ ki Alap sa zëbe hap hen dawemna lamkam golblala. Zen molya gulin srëm gweka.” ");
INSERT INTO ury_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesus kim dua-blaskam de ang ta gwen wenya asa en tawa tasibirki, ki zep asa lup gul soneka– Zënaka de ngeirbli song gwen hap. Zëna lun zep asa golëtro song gweka, hen ol dawemkam ë-ë san tawa tabir song gweka. ");
INSERT INTO ury_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Baptis ta gwibin zini Yohanis kim bwi nakon anakan salka, “Nësa de ngaya tabin hip de Zini men, Zen angkam man ë-ë san tawa tabirida gweꞌara,” dekam zep zëre hon de ang ta gwen zini lup gul soneka– Yesussu de anakan takensïblïn hap, ");
INSERT INTO ury_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Bian, Em an san ha Zen tangan?– men Desa anakan nen guk gweblakye, ‘Israelsa de oto gulsun hup de Zini sa hata zala.’ San ha ëe asa etan ahanaka kara ëblal?” ");
INSERT INTO ury_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesus ki zep ding gulzimki, “Sap esa etan Yohanis osan dep lwan dahal. Mensa ki ena hla kul hen ësane gwer, desa anakan lonblak, ");
INSERT INTO ury_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘Zi nwe dïmïnnï man ëkara gwe-gweꞌak. Lek-lek wenya hen man sek gwe-gweꞌak. Sop sang-sang karek nabare wenya man hen ëdawem gwe-gweꞌak. I mat wenya hen man ësane gwe-gweꞌak. Tok-tokna hen man ëngaya gwe-gweꞌak. Hen Alap onakore ol dawemkam man tahalha wenyaka tawa ta gwibiꞌira.’ ");
INSERT INTO ury_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Hen anakan enblak, ‘Abon onakon men zen ësyalhe srëm gwe-gweꞌan, hëꞌho gwibinni zen zëbon mae lwaꞌan.’” ");
INSERT INTO ury_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Baptis ta gwibin zini Yohanis mo zi lup gul sonenna in kim nama ëgwa haꞌak, Yesus dekam zep hwëna Yohanis hip dena zi beyam-byana in hap srip gulsuzimꞌinka. Man zë gubiridaka, “Yohanis kim zi ol srëm langnak tawa ta gwibirki, em ba habe desan sek gwe-gwek? Basa de zë hlaun hup? San ha ema ëtim gul gwek?– ‘Ëe desan asyas habë sek gweꞌan.’ ");
INSERT INTO ury_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Em ba habe desan sek gwe-gwek? San ha ema ëtim gul gwek?– ‘Ëe pakean dawem ala son nabare zisi de zë hla tan habë sek gweꞌan.’ Kire hap desan bëjen. Sap kirekam de zini, zen diki teipsïn zi mo ë yawalak lowehe gwenan. Zi srëm langnak bëjen. ");
INSERT INTO ury_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Zep em ba habe zi srëm lang san dep sek gwe-gwek? Em sap diki Alap mo olsa de ayang gul gwizimdin hip de zisi de zë sane tan habe sek gwe-gwek. Hwëna baptis ta gwibin zini Yohanis Bak, zen Alap mo olsa de ayang gul gwen zi nikon man tangan taman kïnïka. ");
INSERT INTO ury_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sap Yohanis in zen– mensa Alap mo olak hamal hap nen guk gweblakye, Alap kim Tane zemka hamal hap anakan gu-gublukaye, ‘Ëe asa Emsa de ngeir gublun hap zisi zer soner– zen de nonol ëre mo olsa ayang gul gwizimdin hip, ebe hap dikim orasa sal ta gublun hap.’ ");
INSERT INTO ury_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Eiwa denakaë emsa gubiridaꞌan: Okamanak de zini, sap nonol lonesen nakon hëndep angkam em an zene lowe heꞌan, Alap mo nwenak de ëdakastïnnï, hom tangan ahana– Yohanissi de kwë ta sone kïnïn naye. Hwëna sap kirekam, men zen angkam Alap mo ïrïk gïnnïk Asa de taïblïblan nakon bïtï gwe-gweꞌan, sap bose srëm wenya, zen diki zen– Yohanissi de kwë ta sone kïnïn wenyaye. ");
INSERT INTO ury_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“In kim Yohanis syala kon gwesibir hanaka hëndep angkam, Alap zëre mo ïrïk gïn hïp de sosonna mamkam Abon onakon goltrei gwizimꞌira. Hwëna nol drak-drak wenya zen man Alap mo ïrïk gïnnï insa baes nei gwibiꞌin, zep hom gun hup ëasas gwe-gweꞌan. ");
INSERT INTO ury_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Sap Yohanis de hatan srëmnak, tïngare Alap mo ëpba ola mensa zini ano syal hap dena ayang nulzimnira gwek hen ale nul gwek, zen an dekam sa zëwe zaul. ");
INSERT INTO ury_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Men kirekam Alap mo olak lwak, ‘Elia Bak sa Israelsa de ngaya tabin hip de Zini insa ngeirbli zala,’ hwëna baptis ta gwibin zini Yohanis, in zen– Elia mo weinak dep de zi niye. Hwëna zini hom kirekam dam dasïk. ");
INSERT INTO ury_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Em dwan i nibanke. Em ësal gwen! ");
INSERT INTO ury_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Zep angkam de zini, em in men kiye– walasna. Walas tane-ne de pasarak teinikirinni, dekon de asyas bose zemka gubiridanna, ");
INSERT INTO ury_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nen isrip-sri hap de tërya ban asyas tan.’ Hwëna zen maka ding nulzimꞌin, ‘Ëe ama baes taꞌan.’ Dekam de sap etan gubiridanna, ‘Ki zi toksa de gwëblan makan nen asyas tan.’ Hwëna dekam hen maka ding nulzimꞌin, ‘Ëe ama kirekam hen baes taꞌan.’ Angkam de zini em hen kirekam. Em ema kïtak Alap mo syala baes ei gwibirin. ");
INSERT INTO ury_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sap Alap kim baptis ta gwibin zini Yohanissi ebe mae hap zer sonezimki, zen Alap dikim sosonsa golblan hap man tembanena lwa gweka, hen angguru hom otde gweka. Hwëna em ema baes ë gweblak, hen anakane lonsuk gweblak, ‘Zen dowal bi gweblaka.’ ");
INSERT INTO ury_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ki zep hen ngatan zi mo lang nakore Zi Tanganna Asa zer sone zaka. Ëe hwëna homë tembane naban angguru ban lwa gwenan. Hwëna Asa hen ema baes ë gweblaꞌan, hen anakane Asa lonsuk gweblanan, ‘Zini insa emki hla tan! Tembane ngalap-ngalapna, hen anggur otden sosonna. Zëno wal bose walya Roma mo ïrïk gïnnïk dep te-alasa alal danda gwenan, hen ahakon enlala kwae naban!’ Hwëna Alap kirekam zëre mo enlala blalkam srën-srënkam de syal ta gwen hap lup gul sone gwenda. Zep men zen de Alap mo enlala blal san kirekam ang taꞌak, zen zen sa eiwa de ora san ëwet so kïnï gwer.” ");
INSERT INTO ury_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesus ki zep jala ban tonbiridaka– ë-ëna men zao sap Zëna owas-owasna beyakam syal gwe-gwibir-zimki. Sap zëwe de zini zëre mae mo karek-karek nakon de ëhalen hap man baes ta gwek. Zen in zep gubiridaka, ");
INSERT INTO ury_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ëna Korazim hen Betsaidak de zi, em ëngalap gwen, sap Alap sa emsa sërkam karek tabiri. Ë darena Tirus hen Sidonk de zini insa Bian orep heip gulku, zen maka ëhalek– owas-owassa de hlaul gwenkamye, an kire owassaë eno mae mo ngïrïnnïk syal gwe-gwibiꞌinye. Tirus hen Sidonk de zini maka bunsu de awabin niban kaen karonsa darak dak– dekam de zënaka anakan golëtrën hap, ‘Ëe ama ëhaleꞌan.’ ");
INSERT INTO ury_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Hwëna angkam de ë darena, Korazim hen Betsaidak de zini, em an bëjen em ëhalen! Zen in zep, Alap de aumwa hap zisi klis gunkum, eno mae mo angna sa tangan sërkam karek tabiri. Hwëna ëna Sidon hen Tirusk de zi mo angna, desa de etan karek tabin hip dena sa jahalha gwer, sap zëbe mae hap hom Alap golzimki– dekam de ano owas-owas syal gwibinsi hlaul gwen hap denaye. ");
INSERT INTO ury_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapernaumk de zini, em hen kirekam. Em ema ëkïl gïꞌïn, ‘Yesus owas-owasna beyakam nëno mae mo ënak syal gwe-gwibirida, zep nësa sa Alap ngatan zi mo lang san dep dawemkam kang gul sera.’ Bëjen. Emsa hen syauk blanak sa yal gul sera. Ëna Sodomk de zini insa Alap orep timbwas tabirki, zen maka ëhalek hen zëno mae mo auyan-tane walya nama maka zë lowe heꞌan– zen de dekam owas-owassa hla nulinamye, men kirekamë Kapernaumk eno mae mo ngïrïnnïk syal gwe-gwibiꞌinye. Hwëna em home mae halen hap ëdwam gwe-gweꞌan. ");
INSERT INTO ury_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Zep aumwa hap de zisi klis gunnuk, Kapernaumk de zini, eno mae mo angna Alap sa sërkam karek tabiri. Sap Alap hom ëna Sodomk de zi hip ano owas-owassa de hlaul gwen hap dena golzimki. Zep desa de etan karek tabin hip dena sa ebon mae onakon lwalaher. Emsa sërkam tangan sa karek tabiri.” ");
INSERT INTO ury_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yesus dekam zep Alap osan dep ola gu soneka, “Bian, Em in Zen nglï naban okama naban ïrïk soꞌarake. Ëe ama ep dawemsa golblaꞌan, sap Em ema ere mo ïrïk gïnsï de tame gun hup dena enlala blal wenya kip hen sekola sul sonen wenya kip aning gul gwizimꞌira. Hwëna sekola srëm wenya kip hen enlala betek wenya kip ema goltrei gwizimꞌira. ");
INSERT INTO ury_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","In eiwa, Bian, zen kire tangankam ere mo dwam gwibin sin ki lwaꞌan.” ");
INSERT INTO ury_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ki zep hwëna in zenë zë lowe heꞌak asa gubiridaka, “Tïngare okamasa de bi gwibin hip de sosonna mes kïtak Bian abe hap golblaka. Zini toton bëjen Tane zem Asa tame tan. Zen diki ëre mo Bian en Asa tame ta gweꞌara. Hen ano Biansa nara dep?– tame tan naye. Zen diki A-enë tame ta gweꞌan. Hen zini men zëbe mae habë dekam de ano Biansa tame tan hap dena gol gwizimꞌin, zen zen en angkam tame da gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ki zep etan asa gubiridaka, “Men nara sang-sangsa ahaksa tahalhasa nihin dohon-hon yawal makan eisbinni, emki Abon onak golhatazan. Aban esa nihinni insa eirera. Em dekam esa jahalhana eisbiri. ");
INSERT INTO ury_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Abon onak ang gwe-gwe– ekakim ano gwënsa tame gul. Sap Ëe an sae-saena hen kwasang-kwasangna, hen Ëe molyë nihin dohon-honnak emsa kara tak. Aban de ënkam, zen dekam esa nihin jahalhakam gwë gwera. ");
INSERT INTO ury_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sap aban de ënkam, Ëe asa nihin dohon-honnak emsa mas gwe-gweblal. Hëndep em molye tangan sabak gwe-gweka, hwëna em dekam esa jahalhana eisbiri.” ");
INSERT INTO ury_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Hom holo gweꞌak aha Hari Sabatkam Yesus dekam zep zëre hon de ang ta gwen wenya aban mae gamdum tra san golëtaman gweꞌanka. Ëe hwëna ama usak hap gandum danna insa kïlk lï-in kïnï gweꞌak– desa de twenblandan hap. ");
INSERT INTO ury_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Hwëna Farisikam de gubirida gwen wenya kim asa hla nulidak, dekam zep Yesussu nenblak, “Em san home ere hon de ang ta gwen wenya insa hlauludaꞌara? Zen in nëre mae mo tïtï tabin olsa ngip nuꞌin– kirekam de Hari Sabatnak syal gwibinkimye.” ");
INSERT INTO ury_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesus ki zep hwëna ding gulzimki, “Em bawalkam esa Alap mo ola an mo eini dam ulsul?– men kim Daud Bak zëre hon de ang ta gwen wenya ban golëusak gweꞌankaye. ");
INSERT INTO ury_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Zen kim Alap mo golak tïl zïka, zen dekam Alap hap de roti loneblansa gol kïnïka. Desa zep zëre hon de ang ta gwen wenya ban zitwinbir song gweka. Hwëna sap nëno mae mo tïtï tabin olak man lwak: Sap Daud zëna hen zëbon de ang ta gwen wenya, zen bëjen Alap hap de rotina insa twinbin. Zen diki Alap mo golak de syal ta gwen zi en dwin gwibirin. Sap eiwa kirekam, hwëna Daud hom Alap mo nwenak karek gweka– zen kim usak hap zitwinbirkiye. Zep hen kirekam, Abon de ang ta gwen wenya an kim usak hap kïlk dï-in kïnzïl, zen hom ëkarek gwer. ");
INSERT INTO ury_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Hen em bawalkam esa Musa mo tïtï tabin ola an mo eini dam ulsul? Tïngare Hari Sabat jamkam Alap mo golak de syal tan zini Bian mo golak sap de syal ta gwen. Zen dekam man Hari Sabat hap de ol jalse gwenna insa syal gwenkam nulmun gwenan, hwëna dekam Alap bëjen desa husus gwibiridan, sap zen dekam zëre mo golak de syalsa kim su nul sone gwenan. ");
INSERT INTO ury_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Zen in zebë emsa gubiridaꞌan: Sap sa Abon de ang ta gwen wenya an hen kirekam Hari Sabat hap dena nulmun gwer, sap Ëe an Zen, bol zaun tangan Zini. Sap Alap mo gola in Abon onakon man lwala heꞌan. ");
INSERT INTO ury_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Sap Alap mo olak man lwak, ‘Ëe a kirekam de lowehe gwen habë mo emsa dwam gwibiridaꞌanye: Bol-zaun tanganna, aha zi mo karek-kareksa em kwasang tola ban eititi gwe-gwibin. Ere mae mo karek-karek hap de otweransa abe hap tru tasïk gweblanna, zen bol-zaun tangan naka hom.’ Eme kirekam de Alap mo ola insa dawemkam lik ei gwibiꞌinam, ki molye Abon de ang ta gwen wenya ansa karek gon srëmnak jal eibiridananam. ");
INSERT INTO ury_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sap ngatan zi mo lang nakore Zi Tanganna, Ëe an Zen tangan– Hari Sabat mo Nolaye. Zep anakarekam de klis gul gwizimdin hip dena, ‘Desa sap esa Hari Sabatnak syal eibir,’ ahaksa, ‘Kirekam bahem,’ zen ano dena.” ");
INSERT INTO ury_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesus kim dekon song gweka, dekam zep hwëna Yahudi mo aha but srëm golak tïlkï. ");
INSERT INTO ury_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Hwëna zini zao gweꞌanka, eihya tahana mes sak gweblaka. Farisikam de zini men zen Yesus mo kareksa de hlaulblun hap ëalp gweꞌak, ki zep nenblak, “Em banakane Musa mo tïtï tabin ola dam gulsuꞌura? Hari Sabatkam san ha zi sang-sangsa sap de dawem tabinkim? San ha bëjen?” ");
INSERT INTO ury_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesus ki zep ding gulzimki, “Eno mae mo domba zaho de ahanik Hari Sabatkam kama dwraknak dum gwe heꞌanam, san ha em molye dekam ër aneꞌanam? ");
INSERT INTO ury_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Hwëna zini nen Alap mo nwenak domba naban apdenak hom. Zep nen sap esa zi sang-sangna Hari Sabatkam dawem la gwibir.” ");
INSERT INTO ury_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ki zep hwëna Yesus zi taha sakna insa gubluka, “Tahana insa emki ïnïn gïlsïn.” Ki zep hëndep ïnïn gïlsïkï, dekam zep hëndep dawem gweblak– men kiye, eihya tahana. ");
INSERT INTO ury_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farisikam de zini in dekam zep but srëm gola in kon wet so gwek, hwëna dekam zep Yesussu de tan hap ola aha-en nuꞌik. ");
INSERT INTO ury_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesus kim Farisikam de zini insa anakan tame tabirki, “Zen Asa de tan hap olsa aha-en nuꞌin,” dekam zep kon song gweka. Hwëna zini beya tangan nik ang nëblak. Zi sang-sangna hen man ang nëblak, dekam zep zë kïtak dawem tabirki. ");
INSERT INTO ury_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Hwëna man zë jalse gwibiridaka, “Bahem aha maesa anakan gubiridan, ‘Asa Yesus dawem taka.’” ");
INSERT INTO ury_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Zen dekam zep zauk– Alap mo ola mensa Yesaya Bak orep Yesus hup dena anakan ayang gulkuye, ");
INSERT INTO ury_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“An Zen tangan– ëre mo dam tasïn Zini hen zer sonen Zi niye, ëre mo dang tïnïnak de tanganna. Ëe ama tangan sam gwesïk gweblanan. Ëre mo Enhona zëbe hap asa kïtak hlë ta soneblal. Zen Zen sa tïngare zi ausu hap anakan ayang gul gwizimdi, ‘Alap dam-dam enkam sa tïngan klis gulu.’ ");
INSERT INTO ury_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Zen molya darak ola gu gweka, hen ol al hap ola molya zëno ëk tïhï nakon te so gwek. Hen ora bol san molya ol mam-mamkam ton nasen gweka. ");
INSERT INTO ury_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Zen enlala sae-sae enna, zep Zen molya aptyo sin-sin makare wenya zalta dep gweibirida kïnïka. Hen men zëno mae mo sosonna tap gwen hap golek de gweꞌan, desa molya da tasïk gwibirki. Zen kirekam sa kara ta gwibiri, hëndep Zen sa ano ïrïk gïnnï okamanak golhatala. ");
INSERT INTO ury_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tïngare ïrïk gïn langnak de zi ausuna ëngaya gwen hap dena Zëbon en onak sa ëblol gwe-gwer.” ");
INSERT INTO ury_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Zao kim lwa seꞌak, ki zep zini Yesus onak dep dowal mo bi gweblan zi ol srëmna nërhatazak. Nwena hen man dïmïn nëblak. Yesus kim dawem taka, dekam zep ola tonka hen nwena kara gweka. ");
INSERT INTO ury_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tïngare zini man tangan denggwanblak. Zep ëgu gweꞌak, “An san ha Zen?– Daud Bak mo Auyan-tane naye, mensa anakan nen guk gweblakye, ‘Sa hatala.’” ");
INSERT INTO ury_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Hwëna Farisikam de zini kim kirekam nasalbiridak, ki zep ding nulzimk, “Kirekam hom. Zëbe hap mes dowal mo kïgï sosonna golblaka– dekam de aha dowal-dowalsa golëalsa sone gwen hap denaye.” ");
INSERT INTO ury_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Hwëna Yesus man zëno mae mo enlalana insa tame tazimki, zep gubiridaka, “Aha-ere ïrïk gïn nik de hlïk-hlïk gweꞌanam, zën de ëeijaꞌanam, zen molya ëtatete gweꞌanam. Nabakam maka zënaka timbwas nuꞌin. Hen zënaka de gïl-gïl gwibiridan nakon de aha-ere golak dinik hlïweꞌanam, zen maka hëndep sekwak gweꞌan. ");
INSERT INTO ury_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Zep hen kirekam– dowal mo kïgï mo ïrïk gïn nïye: Aha hlïkna bëjen aha hlïk naka golëalsa sonen. Zep man dam gwesïnïn: Dowal mo kïgï bëjen abe hap sosonna golblan– dekam de zëre mo ïrïk gïnnïk de wenyaka karek tabin hipye. Ki hwëna zëno ïrïk gïnnï in de hlïk-hlïk gwenkam, bëjen tatete gwen, hwëna nabakam sa timbwas gwer. ");
INSERT INTO ury_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Zep em insa Asa anakan enblal, ‘Zen dowal mo kïgï sosonna golblaka, dekam zep dowal-dowala golëalsa sone gweꞌara,’ ki hwëna em ema dekam ere mae mo aha hlïkna enbiridaꞌan, ‘Zen hen dowal mo sosonkam syal taꞌan.’ Sap zen hen man nakasïk gwibirin– dekam de dowal-dowalsa golëalsa sone gwibin hipye. Zep ere mae mo ahakorena in maka emsa anakan nenbiridaꞌan, ‘Em ema ëkarek gwer– kirekam de Yesussu tonblankamye.’ ");
INSERT INTO ury_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Hwëna Ëe Alap mo Enho mo sosonkamë dowal-dowala golëalsa sone gwenan. Zen dekon zep anakan dam gwesïꞌïn, ‘Alap Zën de ïrïk gïlzïn hap angkam man sap kon gwisibir hanaꞌara, hwëna em ema desan de ang tan hap baes taꞌan!’ ");
INSERT INTO ury_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Sap Ëe dowal mo kïgï mo bi gwibin kire-kire dawemsaë jal zi mo kim alal ta gweblaꞌan. Zi jal-jal de zëre mo golsa kara taꞌanam, zëbe hap de jal zini na-en molya tïꞌïn zanam. Diki zini insa de nonol balk tankam hen tahalenkam, dekam zëno kire-kirena maka alal tablaꞌara. ");
INSERT INTO ury_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Zini men zen Abon onakon srën gwë hanna, zen ki Asa husus gweblaꞌara. Hen zini men zen Asa mas gweblan srëmna, zen ki ano syalsa dri yuꞌura. ");
INSERT INTO ury_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Zen in zebë emsa gubiridaꞌan: Tïngare nwe-masekam de karek-karekna mensa zini em ulin halasen gwenan– hen sap Alapsa de lamang tanna, desa maka Zëna tap gulsuk gwizimꞌira. Hwëna zëre mo Enhosa de lamang tankam, desa molya tangan tap gulsuzimki. ");
INSERT INTO ury_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Hen ngatan zi mo lang nakore Zi Tanganna Asa de ol lamangkam gublunkam, desa maka Alap tap gulsuk gwizimꞌira. Hwëna Alap mo Enhosa de lamang tankam, desa Alap molya tangan tap gulsuzimki– sap angkam de okamanak awe, hen sap lamkam de okama ësenak. ");
INSERT INTO ury_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nen tenya tën nakone tame ul gwenan. Tenya men zëno dan naka zini dwinbir srëm gwe-gwenan, zen bëjen twin gwibin tetan dankam tën. Tenya zen zëre mo dan enkam ëtë gwenan. ");
INSERT INTO ury_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Zep Farisikam de zini, em hen kirekam. Em in jal-jal tanganna– wanyana kiye! Zep eno mae mo ol toranna banakan dep?– dawem gwen naye. Men zen eno mae mo ëk tïhï nakon wet so gwenan, zen zen eno mae mo enhonak suwek. ");
INSERT INTO ury_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Enho dawem-dawem wenya, zëno mae mo ëk tïhï nakon dawem en nik wet so gwizimnin, sap zëno mae mo enhona mes dawem enlala enkam suweka. Hwëna enlala jal-jal wenya, zëno mae mo ëk tïhï nakon karek en nik zep wet so gwizimnin, sap zëno mae mo enhona mes jal-jal enlala enkam suweka. ");
INSERT INTO ury_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Zep emki ëenlala gwen: Aumwa hap de yakla yawalak de Alap zisi klis gunnuk, tïngare zini zen zëre mae mo ol toran nakon sa Alap klis gulu– sap zëno mae mo aha zisi de tonsubirida gwen ol maena hëndep kïtak. ");
INSERT INTO ury_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Sap dekam ere mae mo ol toran nakon sa Alap anakan klis gul gwera, ‘Zini an karekna,’ ahaksa, ‘An aïrïs.’” ");
INSERT INTO ury_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Zao kim lwa seꞌak, dekam zep Musa mo olsa de tawa ta gwibin hip de zi niban Farisikam de zi niban Yesussu abe dak, “Bian guru, emki abe mae hap owassa syal gwibir-zimdin– ëe akakim emsa anakan dam lasïk, ‘An eiwa Alap zer soneka.’” ");
INSERT INTO ury_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Hwëna Yesus ki zep ding gulzimki, “Em angkam de zini eiwa jal-jal tanganna, hen Alapsa mese hli lak, hwëna Asae aberbe la gweꞌan– owassa de ebe mae hap syal gwibir-zimdin hipye! Ëe angkam aha-en mae molyë owasna ep syal gwibir-zimk. Hwëna ngein sin de yaklanak Ëe asa owasna aha-en tangan ep syal gwibir-zim– men kirekam Alap mo ol ayang gul gwen zini Yunus Bak hon lwakke. ");
INSERT INTO ury_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Men kirekam Yunus Bak hogwe yawal ungala mwanak yaklana dan-ahan gwëka, zen kirekam sa ngatan zi mo lang nakore Zi Tanganna Abon lwal. Ëe hwëna kama mwanak asa yaklana dan-ahan gwëon. ");
INSERT INTO ury_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Alap de angkam de zini emsa klis gunnuk, dekam Niniwek de zi mo angna sa olsa de mas gun hup ëzaul. Zen dekam sa emsa anakan swrë dabir, ‘Yunus Bak kim ëhalen hap de ola ban golhata zaka, ëe dekam ama ëhalek. Hwëna ebon mae onak kim ngatan zi mo lang nakore Zi Tanganna ëhalen hap de ola ban golhata zaka, em hwëna ema ëhalen hap baes ta gwek.’ ");
INSERT INTO ury_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Hen kirekam, Alap de emsa klis gunnuk, selatan kore teipsïnkïm de wenya in, zen sa hen olsa de mas gun hup zaul– men zen orep teipsïn zini Salomo Baksa duwebla zakke. Zen dekam sa anakan emsa swrë tabir, ‘Ëe ama langa en nakon Salomo mo enlala blala kore olsa de sane gwen hap hatak. Hwëna ebon mae onak kim ngatan zi mo lang nakore Zi Tanganna hataka, em hwëna ema asalsïk gweblak.’” ");
INSERT INTO ury_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Dowal de totoresa zi nikon wet sonna, dekam gwana-gwana san sa hakalada gwera– zao de aha zi maenak tïn hïp. Hwëna aha maenak de tïn srëmkam, ");
INSERT INTO ury_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","dekam sa dowala in enlala gwera, ‘Ëe asa etan ëre mo gol hli tan san dep lwahal.’ Kim de lwa haꞌan zaka, gola insa anakan sa hla ta zala, ‘Dan en tangan nik zauꞌura. Gol bina in mes tangan oto tasïkï hen ngan tasïkï.’ ");
INSERT INTO ury_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Dekam sa dowala in song gwera– aha dowalsa de zëre onakon de jal-jal taman kïnïn tangan naka tuju enkam kwang guluda halzan hap. Deban kim de zini iwe golëbïtï gweꞌan zaka, zini in mo gwënna dekam sa tangan karek gweblal– nonol gwën nakonye. Zen hen kirekam zep angkam de zini eno mae mo jal-jala lwa gweꞌan!” ");
INSERT INTO ury_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesus kim nama zi trana in han golëtonꞌanka, an zem dekam zep oso wal zeban golëyaïng gwezak. Zen ë nakon ëzauꞌuk. Man kon olsa de zertoran hap nësblaꞌak. ");
INSERT INTO ury_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","In deban mae golëtonꞌanka ahanik zep gubluka, “Bian, emsa man eno anena oso wal oban ë nakon ziësblaꞌanon– olsa de emsa zertoran hap.” ");
INSERT INTO ury_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesus ki zep ding gulbluka, “Hwëna nonol Ëe anik emsa gubiridak– ano anena hen oso-walya, zen diki a kirekam de zisi moye:” ");
INSERT INTO ury_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Hwëna ki zep tahakam zëre hon de ang ta gwen wenya asa zi beyana in han golëtrëka, deban guku, “Diki an zen lowe heꞌan, zen zen– ano anena hen oso walyaye! ");
INSERT INTO ury_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sap tïngan men zen ano ngatan zi mo langnak de Bian mo dwam gwibin sin ang ta gwenan, zen diki zen tangan– ano anena, oso walya hen somol walyaye.” ");
INSERT INTO ury_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yaklana inkam Yesus ki zep gola kon asa golëwet so gweka, ho gutu alpnak zep nikin aneka. ");
INSERT INTO ury_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Zao zep hwëna zi beyam-byana tagal nëblazak, hëndep man zë dot dasïzïk. Dekam zep buluk sewe seka– dekon de nikirinkim tawa tabin hip. Zi trana in hwëna ho alp san ki ëzaundak. ");
INSERT INTO ury_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Zao zep Yesus gulk sun de ol blaon gwizimdinkim tawa ta gwibiꞌinka. Nonol man zë gubiridaka, “Zini man orep gandum dansa de hlïng gïlsïn hïp song gweka. ");
INSERT INTO ury_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kim hlïng gïlsïkï, hwëna ahakon oranak altïnk. Mawana ki zep zë yaïng gwezak, zen zep hwëna gandum danna insa dwensïblïndak. ");
INSERT INTO ury_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ahakon kaso-kasonak altïnk– kama bëbeknak. Gandum danna in nabakam zep sap ësïp gwek, sap kamana in bëbek tanganna. ");
INSERT INTO ury_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Hwëna yaklana kim sal-sal gweka, sïpnï in dekam zep ëboneng gwek, hëndep ësasan gwek, ki zep tol hëndep juwek. Sap sana ba san dep?– olk san de ëhas gwesïn nïye. ");
INSERT INTO ury_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Hen ahakon dokot të ngï-ngï ausunak altïnk. Kim sap tol ësaltïk, hwëna dokot të ngï-ngïna in zep nabakam ëblal-blal gwek. Zen zep dahalebik, hëndep eini hom tëka. ");
INSERT INTO ury_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Hwëna ahakon kama dawemnak altïnk. Zen en dawemkam zep ësïp gwek, hëndep dawemkam zep hataka, hëndep dawemkam tëka. Aha-ere timni zëno dan beyana ahakon 30 enkam, 60 enkam, hen ahakon 100 enkam.” ");
INSERT INTO ury_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ola insa kim tonsuku, ki zep gubiridaka, “Em dwan i nibanke. Em ësal gwen!” ");
INSERT INTO ury_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ëe zëre hon de ang ta gwen wenya ki zebë ë-erenak lakensïblïk, “Bian, em ba habe kirekam zi beya hap gulk sun ola blaon gwizimnira?” ");
INSERT INTO ury_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ki zep ap ding gulzimki, “Abon de ang ta gwen wenya ebe mae hap Alap mes golzimki– em dikim zëre mo ïrïk gïn hïp denaka tame gul gwen hap denaye. Hwëna aha zi hip hom kirekam golzimꞌira. ");
INSERT INTO ury_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sap men zen Alap mo ïrïk gïn nïka de tame gun hup ëhohle gweꞌan, zëbe mae en hap sa etan Alap dekam de tame gun hup de enlala blala sowe henkam ing ta sone gwizimdi. Hwëna men zen ëhohle gwe srëm gweꞌan, zëbon mae men zen sap tame gun hup de enlalana betek enkam lwazimꞌira, desa sa hwëna Alap al tazimdi. ");
INSERT INTO ury_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Zen in zebë zi beyam-bya naban de golëtorankam ola gulk sun blaon gwizimnin, sap ‘zen nwekam ki sap hla nul gwenan, hwëna man ëgwë gwenan– san de hlaun srëmna. Hen zen sap man ësane gwe-gwenan, hwëna san de ësane gwen srëmna hen tame gun srëmna.’ ");
INSERT INTO ury_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Zen in zep Alap mo olsa de ayang gul gwen zini Yesaya Bak orep ola anakan ayang gulzimki, ‘Alap man guku, “Zen sap sa ësane gwe tine gwer, hwëna molya tame nul gwek. Hen sap sa karatda nul tine gwer, hwëna anakan molya dam nulsuk gwek, ‘Kirekam sa lwal.’ ");
INSERT INTO ury_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Sap zëno mae mo enlalana mes tangan joblo-top gweka. Zëre mae mo ini mes tangan mat dasibik. Nwena hen mes dïmïn dabik. Zen mae hap ki ëgwëk: Dekam de nwekam hlaul gwen srëm hap, ikim de ësal gwen srëm hap, hen enlalakam de tame gul gwen srëm hap, Abon osan dikim etan lwanda halzan srëm hap. Diki zen de etan Abon osan dep lwanda haꞌan zanam, ki Ëe amaka ngaya tabiꞌin.”’” ");
INSERT INTO ury_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yesus ki zep etan abe mae en hap ayang gulzimki, “Em an isrip-sri gwibinnike lowe heꞌan. Sap emsa ama golëtë gwenan, zebe nwekam dawemkam hla kul gwenan hen ikim ësane gwe-gwenan. ");
INSERT INTO ury_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Emki sap ëenlala gwen: Abare srëmnak Alap mo olsa de ayang gul gwizimdin hip de zini hen Alapsa de betek gwe-gweblan zini beya nik sap hlaun hup sërkam ëdwam gwe-gwek– ano owas syal gwe-gwibinni ansa em angkam hlakul gweꞌanye. Hwëna orep de zi dawem-dawemna in zen hom tangan hla nuk. Ësane gwen hap hen sërkam sap ëdwam gwe-gwek– em ansa angkam ësane gwe-gweꞌanye. Hwëna zen hom mae ësane gwek.” ");
INSERT INTO ury_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesus ki zep etan asa gubiridaka, “Emki ësane gwen: Angkam ama ebe mae hap gandum dan hlïng gïlsïnkïm de ol blaonzimdinni insa srip gulsuzimꞌin. ");
INSERT INTO ury_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Oranak de gandum dan altïrïnnï, zen zini men zen sap Alap Zën de ïrïk gïn hïp de ola ësane gwe-gwenan, hwëna ola in mo eini hom tame nul gwenan. Dowal mo kïgïna dekam zep hata gwenan zala, insa ësane gwenna, desa de zëno mae mo enhonak al gul gwizimdin hip. ");
INSERT INTO ury_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Men zen kaso-kasonak altïrïnnï, zen ahakon men zen Alap mo ola insa ësane gwe-gwenan. Zen nabakam zep sap enlala isrip-sri naban nulin gwenan. ");
INSERT INTO ury_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Hwëna ola in bëjen zëno mae mo enhonak sa gwen, zep bëjen zë holokam lwan. Zen kim de karek maena hla nuꞌik, ahaksa ol dawemna in hap de jal hap karek dabiꞌik, zen hëndep dekam sa Alapsa hli dal. ");
INSERT INTO ury_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Men zen dokot të ngï-ngï ausunak altïrïnnï, zen zini men zen sap Alap mo ola insa ësane gwe-gwenan, hwëna angkam de okamanak awe de anakare enlala naban siri nul gwenan, ‘Ëe babë tahalhakam gwë gwen,’ hen anakan de hole-hle gwe-gwen naban, ‘Diki te-ala beya naban amaka gwë gweꞌan.’ Kirekam de enlalana in zep Alap onakare ol dawemna insa zëno mae mo enhonak hule gwenan. Zep hëndep dawemkam eini ëtë srëm gwe-gwenan. ");
INSERT INTO ury_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Hen men zen kama dawemnak altïrïnnï, zen zini men zen Alap mo ola insa ësane gwe-gwenkam dawemkam lik nei gwibirin. Zen zen zep eini dawemkam ëtë gwenan. Zëno ei beyana, ahakon 30 enkam, 60 enkam, hen ahakon 100 enkam.” ");
INSERT INTO ury_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus in kim nama bulu kon tawa tabiꞌinka, zao zep etan zi beyam-byana in hap ola gulk sun blaonzimki, “Alap mo ïrïk gïn hïp dena, zen san de zi de nganak gandum dan dawem-dawemsa hlïng gïlsïnnï kiye. ");
INSERT INTO ury_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Hwëna zëno kam, tïngare zi mo truwe guk hannak, dekam zep hwëna nganak iwe jal zi sowëkam endang dansa etan hlïng nïlsïk. ");
INSERT INTO ury_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Gandum danna in kim ësïp gweꞌak, hëndep ëeis gweꞌak, endang sïpnï in dekam zep hen ëblal-blal gweka. ");
INSERT INTO ury_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Zao zep hwëna nga bina in hon de syal ta gwen zini dakensïblïzak, ‘Bian, em dwan gandum dan dawem-dawem ensa em-am ap kap tazimki– nganak iwe de hlïng gïlsïn hïpye. An hwëna ba hap zë endangna hataka?’ ");
INSERT INTO ury_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Nga bina in ki zep ding gulzimki, ‘In jal zi zë sowëkam hlïng gïlsïk gïk halka.’ “Hwëna ki zep etan dakensïblïk, ‘Bian, ëe wëhë endangna insa lamalsïꞌik?’ ");
INSERT INTO ury_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Hwëna man ding gulzimki, ‘Bëjen em tamalsïn, ki hwëna gandumnu in han esa apdenak lamalsïl. ");
INSERT INTO ury_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Sap sa endangna in han apdenak ësaltïl– hëndep gamdumnu insa de taran hap denak de zauꞌuk. Ëe asa taran hap de zini insa gubiridal, “Nonol endangna insa blom lasïk, desa tagal tan naka tatak-tatak labik, desa de syauknuk tru tasïn hïp. Ki hwëna gandum danna insa gamdum dan kang ta gwen golak tagal lasibik.”’” ");
INSERT INTO ury_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesus ki zep etan zi beyam-byana in hap ola gulk sun blaonzimki, “Alap mo ïrïk gïnnï an kirekamë ola ebe mae hap blaonzimꞌin: Zini man rica dansa nganak eiyas taka. ");
INSERT INTO ury_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Rica danna in tïngare tetan dan nakon, zen zen– betek tangan wenyaye. Hwëna kim ësaltïl gwenan, dekam zep tïngare obwaga nakon ëblal-blal gwe-gwenan, hëndep te makan ëmam-mam gwe-gwenan. Mawana zao zep yaïng gwe-gwenanzal– zëno hli-hlinak de golsa tauk gweblan hapye.” ");
INSERT INTO ury_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ki zep hen etan ahana mas gulzimki, “Alap mo ïrïk gïnnï, zen a kirekam moye: Zen ragi makan. Wenya man tepungna aha-ere sak naka mang-mang guk. Zao zep ragisa betekkam mas guk. Ragina in sap betek tanganna, hwëna dekam zep rotina in dawemkam hop gwek.” ");
INSERT INTO ury_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus kirekam-kirekam gulk sun de ol blaonzimdinkim tawa tabirida gweka. Zëno tawa tabinni hom– gulk sun de blaon gwizimdin srëmkamye. ");
INSERT INTO ury_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kirekam kim tawa ta gwibirki, zen dekam zep zauk– men kirekam Alap mo ol ayang gul gwen zini Yesus hup de ola hamal hap anakan ale gulkuye, “Ëe gulk sun de ol blaon gwizimdinkim asa aïsïl gwibirida gwer. Hen mensa auhu-kamana ansa de yang gulsun nukon tawa neibir srëm gwek, zen dekam asa tawa ta gwibir.” ");
INSERT INTO ury_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesus kim zi beyam-byana insa hli yuludaka, ki zep gol san song gweka. Hwëna ëe zëre hon de ang ta gwen wenya ki zebë zë du këblazak, zao zebë lakensïblïzak, “Bian, abe mae hap emki srip gulsuzimdin– insa gandum nuban de endang naban aha-erenak nasaltïn hïp dena ap gulk sun blaonzimdike.” ");
INSERT INTO ury_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesus ki zep ding gulzimki, “Gandum dan dawemna men Zen hlïng gïlsïkï, Zen Ëe an Zen– ngatan zi mo lang nakore Zi Tangan naye. ");
INSERT INTO ury_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Hwëna ngana, zen auhu-kama yawala an zenke. Gandum dan dawem-dawemna, zen zini men zen Alap mo ïrïk gïnnïk bïtï gweꞌanke. Hwëna endangna, zen zini men zen dowal mo kïgï hon bïtï gweꞌanke. ");
INSERT INTO ury_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jal zini men zen endangna insa sowëkam eiyas ta gwenda, zen dowal mo kïgï. Taran hap de zaunnu, zen Bian mo klis gun hup de yaklanak de zaun hup dena. Taran hap de zini, zen Alap mo dam taha nakore zi. ");
INSERT INTO ury_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Zep in kirekam endangsa de tagal tan naka syauknuk tru ta senkam lwak, zen kirekam sa hen lwal– Bian mo klis gun hup de yaklanak de zaunkumye. ");
INSERT INTO ury_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Dekam ngatan zi mo lang nakore Zi Tanganna Ëe asa ëre mo dam taha nakore zisi desa de tïngan tagal gulsun hup gubiridal– men zen aha zisi karek san dep tïtï da gwibirin, hen men zen karekna syal nei gwibirinke. ");
INSERT INTO ury_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Desa sa syauk bla hï-hïtïnnïk yal nulser– men dekon zi mo angna yusyustïn nïban gona ta gwenanke, hen sang-sang hap ëkna ngalk-ngalk da gwibirinke. ");
INSERT INTO ury_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Hwëna zini men zen enlala dam-dam enkam lowehe gwenan, zen Alap mo ïrïk gïn kama ësenak sa zëre mae mo Bian hon lowehe gwer, hen zen zao sa yakla mo kim ëzïl ane gwer. Em dwan i nibanke. Em ësal gwen!” ");
INSERT INTO ury_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Alap mo ïrïk gïnnïk de tïn hïp dena, zen a kirekam moye: Zini man song gweka, zao zep aha zi mo kamanak emas yawalsa hlaulku. Kama hulak lwaꞌak, hen yawal tanganna. Zen zep hwëna kama hula insa ber-ber gulku. Zëna dekam zep isrip-sri naban zëre mo golak de kire-kirena kïtak tangan te-ala hap lirak tabirki. Te-alana dekam zep kamana insa golka– hëndep emas aning gunnu in han. ");
INSERT INTO ury_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Alap mo ïrïk gïnnïk de tïn hïp dena, zen hen a kirekam moye: Kire-kire beya zini man gwë gweka. Zen te-alakam kire-kirena lirak ta gwibirki. Hwëna mensa tangan dwam-dwam gwe-gwibirki, zen kaso lïlïngtïn yawalsa. ");
INSERT INTO ury_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Zen kim sërkam de dawem tangan wenyaka hlaulku, zen dekam zep zëre mo golak de bi gwibin kire-kirena kïtak te-ala hap lirak tabirki, dekam zep hwëna kaso lïlïngtïn yala insa golka.” ");
INSERT INTO ury_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Alap Zën de ïrïk gïn hïp dena, zen hen a kirekam moye: Zini man hinak jaringkim kirekam-kirekam nwe-mase hogwesa dahyok. ");
INSERT INTO ury_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hëndep kim jaringni in suwek, dekam zep zini in ho alp san dep ïl nïlhak. Zao zep hwëna teinikirinkim hogwena insa hlï nïk– dan nabare hogwena srën, ei hogwena srën. Dawem-dawemna, zen honnak bïtï dak. Karek-karekna, desa man yal dak. ");
INSERT INTO ury_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Zen kirekam sa hen lwal– Alap mo yakla yawalak de zaunkumye. Zëre mo dam taha nakore zini dekam sa hen yaïng gwezal– dekam de dawem gol gwen zi nikon karek-karek gol gwen zisi hlïl irin hipye. ");
INSERT INTO ury_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Zen dekam sa karek-karek gol gwen wenya insa kals yalak de syauk blanak yal nulser– men dekon zi mo angna yusyustïn nïban gona ta gwenanke, hen sang-sang hap ëkna ngalk-ngalk da gwibirinke.” ");
INSERT INTO ury_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ki zep hwëna asa takensibiridaka, “Em san mese kïtak dam ulsul?– ola insa gulk sun blaon gwizim sinye.” Ëe dekam zebë ding ulblik, “Ëe mesë, Bian.” ");
INSERT INTO ury_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ki zep hwëna etan asa gubiridaka, “Zep Alap mo olsa de tawa tabin hip de zi dawemna, zen diki zen Alap mo ïrïk gïn hïp de ëpba ola ban hen ano ol ësena an han tame son. Zëno tawa tabinni dekam sa lwa gwer– san de gol bi nik de gola kon zëre mo kire-kiresa aha zi hip golëtrei gwizimdinni kiye, ëpba ërlwa gwen wenya ban, ëse kap tan wenya ban.” ");
INSERT INTO ury_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesus kim kirekam de gulk sun ol blaon gwizimdinkim hya gwesibiridaka, dekam zep kon dua-blaskam de zini asa en golëlwanda halka– ");
INSERT INTO ury_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","zëre mo ëna Nazaret san dep. Zëwe but srëm golak zep tawa tabiꞌinka. Zini men zen zë sane daꞌak, man tangan denggwanblaꞌak. Zep zë hwëna donsubluꞌak, “Zini an endawe sekola gweka?– zep kïl gïꞌïra, ‘Ëe asa tawa tabir.’ Hen owas-owassa de syal gwe-gwibin hip de sosonna endawe sa gul iri? ");
INSERT INTO ury_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Zen dwan gol syal gwe-gweblan zini Yusup Swe mo tane sake! An zem Maria. Oso wal zem, zen Yakobus, Yusup, Simon, hen Yudas. Zen kïtak awe de zi sike! ");
INSERT INTO ury_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Somol wal zem awe am hen tïngan lowehe gweꞌan. Zep zini an ba hap kïl gïꞌïra?– ‘Ëe asa Nazaretsa tawa ta gwibir.’” ");
INSERT INTO ury_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sap zen mes kirekam tame dak, zep baes nëblak. Ki zep hwëna gubiridaka, “Zini kirekam ëgwë gwenan: Men-kore men-kore ë nakon, Alap mo ol ayang gul gwen hap de zini man blikip neisibirida gwenan. Hwëna zëre mo iye, ahaksa zëre mo ë nakore nik de kirekam ayang gul gwizimdinkim, desa hom tangan blikip neisibirida gwenan.” ");
INSERT INTO ury_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Zen in zep Yesus zëwe owas-owasna beyakam syal gwibir-zim srëm gweka, sap zen hom daïblïblak. ");
INSERT INTO ury_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Dekam Galilea mo langnak Herodes Bak teipsïnkïm ïrïk gïlkï. ");
INSERT INTO ury_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","4","Herodes Bak kim zëre mo osona Pilipus mo wenya Herodiana Baksa al gulbluka, dekam zep baptis ta gwibin zini Yohanis damnak anakan jalse gweblaka, “Musa mo tïtï tabin ola kon, em sap diki bëjen em oso uk mo wenya gon.” Herodes dekam zep hwëna Yohanissi de balk tan hap gubiridaka– tahalen naka de bwinak se tya irin hip. ");
INSERT INTO ury_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Zen sap dekam de zë hëndep tan hap dwam gweblaꞌanka, hwëna zi beyam-byasa zë mae hap aïrïbiridaꞌanka, “Zen sa hwëna asa jal nëblal.” Sap dekam zi beyam-byana in man Yohanissi enlala në gweblaꞌak, “Zen eiwa Alap mo olsa de ayang gul gwizimdin hip de zi.” ");
INSERT INTO ury_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hwëna Herodes kim zënaka de jaha gweblan yaklanak tembane yawala zisyal gwibirki, Herodiana mo wenam seiwiri dekam zep zë Herodes mo nwenak zisyak– hen tïngare zini men zen zë tagal gwek, zëno mae mo nwenak. Herodes zëna man tangan sam gwesibirki, ");
INSERT INTO ury_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","zep wenam seiwiri insa anakan gu-guk gwibiꞌinka, “Men desae ki ena abe gwibiꞌinka, zen desa asa ki hëndep ebe hap golbir. Nglï naban kama naban mes asa nasalblanan.” ");
INSERT INTO ury_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Hwëna an zem Herodiana mes hen wenam zem insa hamal hap anakan gu-gubik, “Kire hap abe gwe.” Zen in zep anakan ding gulbluk, “Ëe baptis ta gwibin zini Yohanis mo nolakaë abe gwibiꞌin– angkam de hëndep ap piring niban lonebir anezan hap, dekam de ëe anakan taïblïn hap, ‘Eiwa mes tangan tïlï.’” ");
INSERT INTO ury_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herodes kim kirekam zëno abena salka, enlalana man tangan dowebla hanaka. Hwëna zen mes ki kirekam zi beyam-bya mo inik etan-etankam gu-guk gwibiꞌinka, zep ki hëndep ein gubiridaka– Yohanis mo nolsa de golbin hip, zëre mo gu-gubinni insa dikim sul sonen hap. ");
INSERT INTO ury_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Dekam zep hëndep zëre mo jana nabare zini bwinak Yohanis mo nola nablonblin hanak. ");
INSERT INTO ury_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Desa zep hëndep piring niban wenam seiwiri in hap nolbirzik. Wenam seiwiri in zep hwëna an zikhip golbirhak. ");
INSERT INTO ury_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yohanis zëre hon de ang ta gwen wenya ki zep hwëna tokna lo tasïn hïp nërhak. Lo tasïn hyanak zep Yesus osan dep sek gwek– in zen ki zë lwak, desa de gublun hapye. 1b Hwëna Herodes Bak kim otan Yesus mo owas syal gwe-gwibinni salka, 2 dekam zep zëre mo taha trï so gweblan zini gubiridaka, “An baptis ta gwibin zini Yohanis Swe mes yap etan ngaya gweka. Zen hwëna bosena Yesuskum li yul soneka. In zep zëbon owas-owassa dikim syal gwe-gwibin hip de sosonna lwaꞌan.” ");
INSERT INTO ury_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesus kim Yohanissi de tan ola insa asa golësalka, dekam zep asa bulkum zi srëm lang san dep golësesek gweka– zao de zë-en asa golëlowehen hap. Hwëna zi trana in kim kirekam nasalblak, dekam zep zëre mae mo ë-ëna hli dandak– Yesussu dikim eik ora san hles tyablan hap. ");
INSERT INTO ury_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Bulu kon kim asa golëatiti gweꞌanka, dekam zebë zi beyam-byana insa hla kulida kïnïk. Yesus hwëna man tangan zë kwasang gwibiridaka. Sang-sang nabare wenya men zen zë lowe heꞌak, dekam zep zë dawem tabirki. ");
INSERT INTO ury_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kim kam-en gweꞌak, dekam zebë enblak, “Bian, angkam man kam-en gweꞌan, hen langna an tahalha tanganna. Diki dawemna zini an Emaka enbiridaꞌan– zën de golek de ë-ëna an san te-alakam tembane hap ëhakan hap.” ");
INSERT INTO ury_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Hwëna man ap ding gulzimki, “Zen ba hap de tembane hap sek gwen hap? Amki em tembanena zëbe mae hap hen olzimk.” ");
INSERT INTO ury_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ëe hwëna ama ding ulblik, “Kina ki zini an da-en! Nëno mae mo rotina aha-ere taha-tapkamke. Hen hogwena dan-dan en tolke. Molya sowehek.” ");
INSERT INTO ury_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ki zep asa gubiridaka, “An san emki teisya halzan.” ");
INSERT INTO ury_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ki zep hwëna zi beyam-byana insa gubiridaka– so trana iwe de teinikin niran hap. Zëna ki zep aha-ere taha-tapkam de rotina insa hogwe darena in han teisyaka, dekam zep nglï san de kara gwesen naban Alap hap dawemna golblaka. Ki zep hwëna rotina insa ahap tabirki, desa zep abe mae hap kap tazimki– ëe de hwëna zi beyam-byana in hap kae gwebla-zimdin hipye. ");
INSERT INTO ury_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kim dwenblandak, zen man tangan ëïtrï gwek. Ki zebë hwëna dua-blaskam de wenya ëe tembane mosrona tagal lasïk. Yuna dua-blas enkam zep ësuwek. ");
INSERT INTO ury_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","In zen dekam tembane tak, zëno beyana, zi ensa de aïtbinkim, san ha lima ribu enkam mes yap– we wal walassa de aïtbin srëmkamye. ");
INSERT INTO ury_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kimë tembane tasïk, Yesus hëndep dekam zep dua-blaskam de wenya asa bulkum de Zënaka Galilea mo men eihya san dep ngeir gublun hap gubiridaka. Ëe kimë sek gwek, ki zep hwëna zi beyam-byana insa gubiridaka– zen de hen sekwak gwen hapye. ");
INSERT INTO ury_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Zi beyam-byana in kim hen sekwak gweꞌak, Yesus Zëna dekam zep zë-en kwatap tek san hata seka– dekon de Alapsa gu soneblan hap. Hëndep zao zep zë-erenak kawesïblïk. ");
INSERT INTO ury_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Dekam ëe in zenë bulkum teingir gwe guk, mesë bulu ban ho gutu ngïrïnnïk olzauꞌuk. Hwëna ho ngëpna man bulu insa karekkam golwale gwe song gweꞌak, sap asesena bulu in mo ngein nikon taïꞌïnka. ");
INSERT INTO ury_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Oho-bung gun nuban zep hwëna Yesus Zëna abon mae onak hataꞌan zaka– ho gutu tatek tahanna in san de song gwe zankam. ");
INSERT INTO ury_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hwëna ëe kimë hla la guk, ausa zebë ohlo gubluk– anakan de ëhërhen naban, “Hobwem dowala i!” ");
INSERT INTO ury_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Hwëna nabakam zep asa gubirida kïnzïka, “Em ësëwehen! Bahem ëaïrïn. Ëe an Ëe.” ");
INSERT INTO ury_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petrus zep hwëna ding gulbluka, “Bian, sap Em eiwa Yesus, ki asa em gublu irin– ëe de emsa duweblazan hap, ho tatek tahan san de hen song gwe zankam.” ");
INSERT INTO ury_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesus ki zep ding gulbluka, “Haen. Emki song gwezan.” Petrus dekam zep bulu kon ati gweka, ki zep hëndep Yesus osan dep ho gutu tahan san song gweꞌanka. ");
INSERT INTO ury_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Hwëna ho gutu yawala insa kim asesena mamkam ngëp-ngep taꞌanka, desa kim hlaulku, dekam zep zë aïrïn hïp keing gweꞌanka. Dekon zep Yesussu hërheblaka, “Bian, asa Em ngaya tan!” ");
INSERT INTO ury_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesus hëndep dekam zep tahakam zer aneka, ki zep zë gubluka, “Eno eini mam naka hom. Em ba habe Asa taïblïbla srëm gwera?” ");
INSERT INTO ury_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Buluk kim zersewe seka, dekam zep hëndep asesena in sëwe heka. ");
INSERT INTO ury_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ëe dekam zebë zë boklena kom lablak, hen anakanë enblak, “Bian, Em an eiwa tangan Alap mo Tane.” ");
INSERT INTO ury_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ho gutu men eihyanak kimë yaïng gwek, ëna Genesaret zep bulu insa lei kuk. ");
INSERT INTO ury_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Zëwe de zini kim anakan hla dak, “An Yesus am hatanda,” dekam zep Yesus mo hatan ola insa nol haladak– tïngare ëna in mo golek de ë-ë san dep. Dekam zep tïngare zi sang-sangna Yesus onak dep nolëyaïng gwe-gweꞌanzak. ");
INSERT INTO ury_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Zao zep abe da gweꞌak, “Bian, zi sang-sangna an wëhë baju top en mae nakon Emsa olk taꞌanka?– dekakim tol dawem gweka.” Tïngan men zen olk da gweꞌak, zen dekam zep hëndep ëdawem gwe-gweꞌak. ");
INSERT INTO ury_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Aha yaklakam Farisikam de gubirida gwen wenya Musa mo olsa de tawa ta gwibin wenya ban Yerusalem kon Yesus onak dep yaïng gwezak. Zao zep dakensïblïzak, ");
INSERT INTO ury_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ebon de ang ta gwen wenya ba hap nëno mae mo auyan-aza mo ëpba ola nulmun gweꞌan?– tembane dëre ta gunnuk de nonol tahasa hokam hlë tazimdin srëmkam de tembane ta gwenkamye.” ");
INSERT INTO ury_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ki zep ding gulzimki, “Ki em hen ba habe Alap mo ol tanganna ulmun gweꞌan?– hwëna auyan-aza mo ëpba ol en sane ang ta gweꞌan. ");
INSERT INTO ury_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Sap Alap man guku, ‘Ane-biasa em blikip gwesïk gwizimdin.’ Hen anakan mas gulku, ‘Men nara an-bi zemka lamang sonna, zen hëndep tok hap em karek tan.’ ");
INSERT INTO ury_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Hwëna em an ema anakan tawa la gwibirin, ‘Ane-bia mo ol san sap esa ang ta srëm gwe-gwer– anakan mae de lwankamye: Ane-bia de tahalha ënnak, em sap esa anakan enbirida gwer, “Angkam ëe molyë emsa mas gwizimk, sap ano te-alana an lamkam de Alap hap kap tablan habë lam taꞌan.”’ ");
INSERT INTO ury_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ebon mae onakon, kirekam de an-bi zemka blikip gwizimdin srëm zini man sam gwesïꞌïra. Zep ere mae mo auyan-aza mo ëpba tawa tabinni in, zen hwëna ebe mae hap lwazimꞌin– san de Alap mo ol. Hwëna dekam ema Alap mo ol tanganna insa hli kuꞌin. ");
INSERT INTO ury_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Em an eiwa ëk enkame ëgu gwenan, ‘Ëe an Alapsa de betek gweblanna.’ Eiwa, Yesaya Bak mo ola man ebe mae hap dakastïlzimꞌin– zen insa Alap mo ola anakan ayang gulkuye, ");
INSERT INTO ury_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Zini in ëk enkam Asa betek në gweblanan, hwëna zëno mae mo enhona Abon onakon langa tangannak. ");
INSERT INTO ury_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Zen waba hap Asa boklena kom da gweblanan, sap zen zi zëre mae mo tïtï tabin olkam tawa da gwibirin– san de ano olkam de tawa tabinni kiye.’” ");
INSERT INTO ury_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hwëna ki zep Yesus zi trana tagal gwen hap gubiridaka. Kim tagal gwek, zao zep gubiridaka, “Emki ësane gwen ekakim tame uk. ");
INSERT INTO ury_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mensa ëk tïhï san zini ing nul gwenan, dekon hom Alap mo nwenak ëkun gwe-gwenan. Diki men zen zi mo ëk tïhï nakon wet so gwenan, zen diki dekon Alap mo nwenak ëkun gwe-gwenan.” ");
INSERT INTO ury_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ëe zëre hon de ang ta gwen wenya ki zebë hwëna hyanak lakensïblïk, “Bian, em san home Farisikam de zini insa tame tabiri? Zen man eno ola insa husus neibirsin– em kim kirekam srip gulsuzim siraye.” ");
INSERT INTO ury_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Hwëna man ap ding gulzimki, “Tïngare nganak de otanena, ngatan zi mo langnak de Bian de eiyas gïn srëm wenya, zen kïtak tamalsïn en hap dena. ");
INSERT INTO ury_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Farisikam de gubirida gwen wenya insa nwe enkam emki kara ta gwibin. Zen in nwe dïmïn nik tawa da gwibiꞌin– nwe dïmïn nik de nwe dïmïn bose zemka ïrïk ta han makan. Zi nwe dïmïn de nwe dïmïn bose zemka ïrïk ta hanna, zen apdekam sa ho dwrak san laman anera.” ");
INSERT INTO ury_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petrus ki zep gubluka, “Bian, kun gwen hap de ola insa gulk sun blaonnara, emki abe mae hap srip gulsuzimdin.” ");
INSERT INTO ury_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ki zep hwëna kïtak asa gubiridaka, “Ki san em hen nama home tangan tame uꞌin? ");
INSERT INTO ury_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Em san home tame ul gwenan? Men desa ëk san olgwen gwibirin, zen hëndep ulpnuk hata gwenan. Hwëna ki zebe etan ukum ana gwibirin. ");
INSERT INTO ury_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Hwëna men zen ëk tïhï nakon wet so gwenan, zen enho nakon hatase gwenan. Zen diki dekon zini Alap mo nwenak ëkun gwe-gwenan. ");
INSERT INTO ury_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sap zen enho nakon anakare enlala karekna hatase gwenda: Zisi de tan hap dena, zi nibare nik de kahalo gwen hap dena, hen seiwirik de kahalo gwen hap dena, sowë hap dena, boton olsa de gol hala seran hap dena, hen ol lamang hap denaye. ");
INSERT INTO ury_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kirekam-kirekam enlala karekna in, zen diki dekon zini ëkun gwe-gwenan. Taha hlë tazimdin srëmkam de tembane gwen nakon hom.” ");
INSERT INTO ury_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesus kim langna in kon asa golësek gweka, dekam zep ë darena Tirus hen Sidon mo langnak asa golëyaïng gweka. ");
INSERT INTO ury_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Dekam zep hwëna langna iwe de Yahudi srëm wenya Yesus onak dep hatazak. Lure nakon zep anakan taken sone gweblaꞌak, “Bian, Daud Bak mo Auyan-tane, asa Em kwasang gwibin. Ano wenam tola dowal bi gwibirki. Man tangan karek gul gweꞌara.” ");
INSERT INTO ury_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Hwëna Yesus hom mae zëno ola ding gul gwibiꞌinka. Ëe zëre hon de ang ta gwen wenya ki zebë enblak, “Bian, wenya insa em jalse gwibin– dekakim song gwek. Nëno mae mo lure nakon hwëna ena gwen daꞌan.” ");
INSERT INTO ury_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesus ki zep wenya insa hëndep aban mae ding gulzimki, “Asa Alap Israel zi en hap zer soneka, sap zen san de bi srëm domba zahona kiye.” ");
INSERT INTO ury_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Hwëna wenya in dekam tangan zep Yesus mo nwenak utuk gwehen naban boklena kom soblazak, dekon zep etan abe tak, “Bian, asa mas gwibir.” ");
INSERT INTO ury_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Hwëna man ding gulbirki, “Hom sam gwesïꞌïn– walas zikhip de tembanesa de lwa hap yal tazimdin niye.” ");
INSERT INTO ury_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Wenya in ki zep hwëna ding gulbluk, “Bian, sap eiwa kirekam. Hwëna lwa bi nik mo meja nakon de tembane lau altïrïnnï, desa hen ki am lwana dwenblanda gwenan.” ");
INSERT INTO ury_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesus dekam zep ding gulbirki, “Anyan, eiwa em ema tangan Asa taïblïblaꞌara. In kire habe dwam gweꞌara, sap sa kirekam hëndep angkam lwal.” Dekam zep ki hëndep wenya in mo wenamna in dawem gwek. ");
INSERT INTO ury_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesus dekon kim asa golësek gweka, Ho Gutuna Galilea mo alp en san zep asa golëtine gweka. Dekon zebë hwëna kwatap tek tolak yaïng gwesek, zao zebë teinikinꞌik. ");
INSERT INTO ury_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Hwëna ki zep zi beyam-byana zi sang-sangna Zëbon dep nolëyaïng gwe-gweꞌanzak– lek-lekna, nwe dïmïnnï, taha-tana ësak gwenna, hen ol srëm mae naka. Aha sang-sang nabarena hen beya tanganna. Zen zi sang-sangna insa Yesus mo dang gwën nakon kang nul gweꞌanzak. Zao zep Yesus dawem ta gwibiꞌinka. ");
INSERT INTO ury_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Zi trana in man tangan ëtenggwan gweꞌak– anakan kim zë hla nulida gweꞌakye, “Ol srëm wenya zen mes ola donbirin. Taha-tana ësak gwen wenya, zen mes ëdawem gwenan. Lek-lek wenya zen man ëtë nasenꞌan. Hen nwe dïmïn wenya, zen mes ëkara gwenan.” Dekam zep Israelsa de bi gwibin Zini Alapsa boltere daꞌak. ");
INSERT INTO ury_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesus ki zep zëre hon de ang ta gwen wenya asa tagal gulsuku, zao zep asa gubiridaka, “Ëe ama zi trana ansa dawemkam kwasang gwibiridaꞌan, sap zen mes dan-ahare yaklakam awe Asa nërgwëk, hëndep angkam zëno mae mo tembanena mes tangan tap gwizimdi. Ëe homë ki dwam gweꞌan– zen de usak naban sek gwen hapye. Ki zen sa hwëna usak hap ora san ëtïlsïk song gwer.” ");
INSERT INTO ury_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dekam hwëna ama lakensïblïk, “Nen endawe esa tembanena kap lal?– kirekam de zi beyam-byana an hapye. Langna an dwan tahalha tangan nakake.” ");
INSERT INTO ury_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ki zep hwëna asa takensibiridaka, “Eno mae mo rotina banakaꞌen?” Ki zebë ding ulblik, “Tuju enkam. Hogwe tane-nena hen ki tol.” ");
INSERT INTO ury_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesus ki zep zi beyam-byana insa teinikin niran hap gubiridaka. ");
INSERT INTO ury_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ki zep tujukam de rotina insa kap taka– hogwe tane-nena in han, ki zep Alap hap dawemna golblaka. Dekam zep rotina insa ahap tabirki, hen hogwena insa kwa-kwak tabirki. Desa zep dua-blaskam de zini abe mae hap etan-etankam kap ta gwizimꞌinka. Ëe dekam zebë zi beyam-byana in hap kae ëblazimk. ");
INSERT INTO ury_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Zi trana in kim dwenblandak, kïtak man tangan ëïtrï gwek. Ëe dua-blaskam de wenya ama dekam tembane mosrona insa tagam lak. Yu yawal-yawala tuju enkam zep ësuwek. ");
INSERT INTO ury_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","In zen tembane tak, zi ensa de aïtbinni, zëno beyana empat ribu enkam– we wal walassa de aïtbin srëmkamye. ");
INSERT INTO ury_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Hyanak Yesus ki zep hwëna zi beyam-byana insa sekwak gwen hap gubiridaka. Zëna ki zep bulkum asa ho gutu men eihya san dep ngeirbiridaka– langna Magadan san dep. ");
INSERT INTO ury_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Dekam zep Farisikam de zi niban Sadukikam de zi niban Yesus onak dep yaïng gwezak– zao de akasïblïn hap. Ki zep zë nenblak, “Emki abe mae hap nglï nakore owassa syal gwibir-zimdin– ëe akakim emsa anakan dam lasïk, ‘An eiwa Alap onakon hata zaka.’” ");
INSERT INTO ury_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ki zep ding gulzimki, “Yaklana nikin anennak de kal-kal gwenkam, dekam anakane ëgu gwenan, ‘Langna sa sasa gwer.’ ");
INSERT INTO ury_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Hen kirekam, kaknak de okawen kakaksa hla tankam, dekam ema dam ulsuk gwenan, ‘Namen sa ona ïl tïla.’ O de ïl tï gwen hap dena hen sasa gwen hap dena, em desa en ema dam ulsuk gwenan, hwëna owas-owasna men kirekam angkam jowe gweꞌan, desa home dam ulsuk gweꞌan. ");
INSERT INTO ury_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Em an eiwa angkam de zini jal-jal tanganna, hen Alapsa mese hli lak, in zebe Asa abe lal– ebe mae hap de owassa syal gwibir-zimdin hipye. Hwëna Ëe molyë owasna ebe mae hap syal gwibir-zimk. Diki ngein sin de yaklanak asa aha-en syal gwibir-zim: Men kirekam Alap mo ol ayang gul gwen zini Yunus Bak hon lwakke, kirekam sa etan lwal.” Kirekam kim gubiridaka, zao zep hli yuludaka. ");
INSERT INTO ury_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ëe zëre hon de ang ta gwen wenya kimë hen men eihyanak yaïng gwenak, ëe ama hwëna rotisa de lop tanna ëeititi gwek. ");
INSERT INTO ury_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Hwëna dekam zep asa gubiridaꞌanka, “Dawem. Terya-tyakam lowehek. Farisi hen Sadukikam de zi mo ragisa ema ing ulink.” ");
INSERT INTO ury_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Hwëna ëe kimë kirekam asalblak, dekam zebë ënaka lonbiridaꞌak, “Ragi hap in mae hap ki nësa gubiridala: Rotina insa bïtï laza srëm gwerke!” ");
INSERT INTO ury_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Hwëna Yesus mes asa tawa gwibiridaka– ëe insa ëtonꞌakye, ki zep asa gubiridaka, “Em ba habe roti bïtï tazan srëm hap enaka lonbiridaꞌan? Em an home eiwakam Asa laïblï gweblaꞌan! ");
INSERT INTO ury_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Em ba hap tangane dam ulsuk srëm gwer? Em san home enlala eibiꞌin?– limakam de rotina mensaë lima ribukam de zi hip ahap tabir-zimkye. Dekam mosrona mensa ena tagal lak, yuna banakaꞌen ësuwek? ");
INSERT INTO ury_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Hen kirekam, men dekamë tujukam de rotina empat ribukam de zi hip ahap tabir-zimk, zëwe hen tembane mosrona yu yawal-yawala banakaꞌen ësuwek? ");
INSERT INTO ury_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Diki em emaka dam ulsul, ‘Zen roti bïtï tazan srëm hap hom ki nësa gubiridala.’ Hwëna Ëe mae habë ki emsa gubiridal, ‘Dawem. Farisi hen Sadukikam de zi mo ragisa ema ing ulink.’” ");
INSERT INTO ury_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Dekam zebë anakan dam ulsuk, “Hare Zen ragi tangan hap hom am ki nësa gubiridala– mensa rotisa de syal gwibinnik mas ul gwenanke. Zen diki Farisi hen Sadukikam de zi mo tawa tabin karek san de ang ta gwen srëm hap am ki nësa gubiridala.” ");
INSERT INTO ury_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesus kim ë bosena Kaesarea-Pilipi golek denak asa golëyaïng gweka, zao zep asa takensibiridaka, “Zi mo dam tasïnkïm, ngatan zi mo lang nakore Zi Tanganna Ëe an nara mo weinak debë hatazak?” ");
INSERT INTO ury_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ëe ki zebë ding ulblik, “Ahakon man emsa nen gweblanan, ‘In baptis ta gwibin zini Yohanis Swe tïn nïkon etan ngaya gweka. In zen hwëna Yesuskum bosena li yul soneka.’ Hen ahakon man emsa nen gweblanan, ‘In Elia Bak mo weinak Alap mo olsa ayang gul gwizimꞌira.’ Hen ahakon man emsa nen gweblanan, ‘In Yermia Bak mo weinak dep dena.’ Hen ahakon man emsa enlala në gweblanan, ‘Zen diki ahanik mo weinak dep jowe zaka– orep men zen Alap mo ola ayang nul gwekke.’” ");
INSERT INTO ury_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ki zep etan asa takensibiridaka, “Hwëna ere mae mo Asa de dam tasïnkïm, Ëe an diki nara mo weinak dep dena?” ");
INSERT INTO ury_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Bak, aha bosena Petrus, ki zep ding gulbluka, “Bian, Em in Zen– Israelsa de ngaya tabin hip de Teipsïn nïye, Ngaya Zini Alap mo Tane.” ");
INSERT INTO ury_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Dekam zep ding gulbluka, “Simon, Yohanis Bak mo tane, em isrip-sri gwibinnike gwë gweꞌara. Sap em in zi mo dam gulsun nukore naka home kirekam kira gwenda. Hwëna ngatan zi mo langnak de Bian Zën ki emsa enlala soblala– kirekam de dam gulsun hupye. ");
INSERT INTO ury_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Zep Ëe ama emsa gubluꞌan: Em in Petrus– kaso drak-drak makare zini. Ebon onak sa ano jematna tatem ëzauk gwer– kaso yawalak de golsa tauk anen makan. Ano jematna in sap sa Juwen Zi Bak dri yulsun hup akabiri. ");
INSERT INTO ury_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ëe asa ebe hap Alap mo ïrïk gïnnïk dep de kuncina zerblal. Em esa Bian Alap mo enlala san ngatan zi mo lang san dep de lïlïkïnnï okamanak de zi hip gulhlusuk gwizimdi hen talusuk gwizimdi.” ");
INSERT INTO ury_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ki zep hwëna asa jalse gwibiridaka, “Asa insa kirekam dam lasïnïn, aha maesa hwëna bahem anakan gubiridan, ‘In Zen tangan– Israelsa de ngaya tabin hip de Teipsïn nïye.’” ");
INSERT INTO ury_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Yaklana in dekam zep Yesus kon gwisibir hanaka– zëre hon de ang ta gwen wenya asa de damnak anakan gubirida gwen naye, “Alap mo dwam gwibin sin de syal gwibin hip, Ëe asa Yerusalem san song gwer. Zao Yahudi mo nol-nola, Alap mo golak de mam-mamna, hen Musa mo olsa de tawa ta gwibin zini sa Asa sërkam karek da gwer. Zen sa hëndep Asa dal. Hwëna yaklana dan-ahan, ki sa Bian tïn nïkon etan Asa ngaya tala.” ");
INSERT INTO ury_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petrus ki zep hwëna Yesussu gubluka ora nakon de asyal hehan hap, zao zep anakan jalse gweblaꞌanka, “Em bap kirekam gulu! Diki Alap Zen langa gulsun– kirekam de Emsa gwëblan hap dena in saye. Bian, diki Ebon bap zen kirekam lwan.” ");
INSERT INTO ury_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesus hwëna ki zep Petrussu lero gweblaka, zao zep gubluka, “Em in dowal mo kïgï! Ki lun em gwën! Em ba habe Asa tru-tru gulbluꞌara? Eno kirekam de enlalana in, Alap mo dwam gwibin sin denaka hom. Zen auhu-kama zi mo dena.” ");
INSERT INTO ury_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ki zep hwëna tïngare zëre hon de ang ta gwen wenya asa gubiridaka, “Men nara Abon de ang gwe-gwen hap dwam gwenna, zen diki zëre mo gwënna zen eititi gwibin– dekam de zëre hap de te-lidak son wë son naban Asa zertronda gwen hapye, anakare enlala naban, ‘Ëe sap asa Yesus hun apdenak lïl.’ ");
INSERT INTO ury_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sap men zen de zëre mae mo auhu-kamanak de gwënna anakan nolaïrï gweꞌak, ‘Ëe babë Yesussu de ang gwe-gweblannak karekna goltowe gwen,’ ki zëno mae mo gwënna in sa jek-jak gwer. Diki men zen de zëre mae mo gwënna Asa de ang gwe-gweblan hap sosok nul gweꞌak, hëndep zao mae de tïn hïp, zen zen sa hëndep denaban ëngaya gwer. ");
INSERT INTO ury_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","San ha dawemna?– em de sërkam te-ala beya gwenkam hëndep kïtak de okamana ansa bi gwibinkim, hwëna dekam de ere mo gwënsa tïhïs gïn hïp. Kirekam dawem naka hom! Tïnkïm san ha emaka Alap hap ba maesa golblaꞌara?– dekam de etan ngaya gwen hapye. Kina ki bëjen. ");
INSERT INTO ury_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sap molya holo gwek, ngatan zi mo lang nakore Zi Tanganna Ëe dekam asa apdekam ëre mo dam taha nakore zi niban Bian mo sosonna zigolhatazal. Zen diki dekam asa hwëna tïngare zi hip aha-en aha-enkam klis gul gwizim– dekam de zëre mae mo syal eisi golzimdin hip. ");
INSERT INTO ury_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ëe eiwa denakaë emsa gubiridaꞌan: Em an zene awe lowe heꞌan, em molye ahakon na-en juwek, ki esa ngatan zi mo lang nakore Zi Tanganna Asa hla lase gul– Ëe kimë teipsïnkïm de ïrïk gïnkïm kon gwesïk hanaꞌakye.” ");
INSERT INTO ury_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yaklana kim enam enkam damank, Yesus dekam zep zëre hon de ang ta gwen wenya Petrus, Yakobus, hen zëno osona Yohanis mae en han zë-en kwatap yawal san dep golësek gweka. ");
INSERT INTO ury_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Hwëna dan-ahare zini in mo nwenak zep timni liwe heblak. Zëno nwe-masena yakla ngatan mo kim ngatan gweblaka. Pakeanna man tangan sërkam ngap-ngap nëblak hen man nalïlïngtïlblïꞌak. ");
INSERT INTO ury_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mumuk ennak zep zë Musa Bak ne Elia Bak ne jo kë zaka, hen Yesus hon de ang tan dan-ahare zini in ki zep nakek– zen kim Yesus hun ëraïsïl gweꞌanka. ");
INSERT INTO ury_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petrus ki zep hwëna Yesussu gubluka, “Bian, man tangan sam gwesïꞌïn– nen de awe lowehe gwen hapye. Zep Bian, Em de dwam gwenkam, ki ëe asa gol kluksa dan-ahan syal gweblandal– ahana Bian ere hap, ahana Musa Bak hap, hen ahana Elia Bak hap.” ");
INSERT INTO ury_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petrus in kim nama kirekam tonblaꞌanka, hwëna ngatan nabare butna ki zep ati gwezak, hëndep zao zep wale tabirzik. Hwëna butna iwe zep ola anakan ësak, “An ano Tane– ëre mo dang tïnïnak de tanganna. Ama tangan sam gwesïk gweblanan. Desa em sal gweblan.” ");
INSERT INTO ury_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Dan-ahare zini in kim ola insa kirekam ësalsek, dekam zep aïrïn hïp ëïk gwehek. ");
INSERT INTO ury_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Hwëna Yesus kim zë hata zaka, anakare ola ban zep towanbirida ine zaka, “Em ëluk tan. Bahem ëaïrïn.” ");
INSERT INTO ury_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Zen kim nola kap da inek, dekam hwëna Yesus Zëna en naka zep zë hla dak. Aha maena hom zao gwëꞌanka. ");
INSERT INTO ury_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kwatapna in kon kim etan golëtinja gweꞌanka, zao zep gubiridaka, “In desa ki ena hla kul, etan aha maesa bahem gubiridan– ngatan zi mo lang nakore Zi Tanganna Ëe de nama tïn nïkon ngaya gwen srëmnakye.” ");
INSERT INTO ury_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Dekam zep hwëna dan-ahare zini in dakensïblïk, “Elia Bak mes-am lwa hala. Ëe hwëna ama tim ul, ‘Zen sa Emsa ngeirbli zala.’ Sap Musa mo olsa de tawa ta gwibin hip de zini kirekam am ëgu gwenan, ‘Zen diki nonol Elia Bak sa etan lwahal zankam ngeirbli zala, ki sa hwëna nësa de ngaya tabin hip de Zini hata zala.’” ");
INSERT INTO ury_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus ki zep hwëna ding gulzimki, “In sap eiwa kirekamke. Elia zen sap kirekam-kirekamsa de nonol sul sone gun hup de zini– Israelsa de ngaya tabin hip de Zini Ëe de hwëna kirenak hatazan hap. ");
INSERT INTO ury_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Hwëna Ëe ama emsa gubiridaꞌan: Elia zen sap mes eiwa Asa ngeirbli zaka, hwëna zini hom desa tame dak. Zep hwëna zëre mae mo dwam gwibin sin kirekam-kirekam karek-karek ensa nol gweblak. Hen molya holo gwek, ki sa ngatan zi mo lang nakore Zi Tanganna Asa kirekam hen nëblal.” ");
INSERT INTO ury_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Dan-ahare zini in dekam zep anakan dam nulsuk, “O hare Yohanis Swe am Elia mo weinak syal gweka.” ");
INSERT INTO ury_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesus kim etan zëre hon de ang ta gwen zi dan-aharena in han zi tranak hëndep abon mae onak golëyaïng gweꞌan zaka, zini hen ki zep zë hata zaka, zao zep Yesussu boklena kom sobla zaka. ");
INSERT INTO ury_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Dekon zep abe ta seka, “Bian, ano walasna kwasang gwebla. Zen karekkam tïlsïk-tïlsïk gwe-gwenda, hen sang-sangna sabak tanganna. Zen etan-etankam syauk bla mae san zannara gwenda, hen ho maenak keing gwenda-gwenda. ");
INSERT INTO ury_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ëe mesë sap ere hon de ang ta gwen zi sin dep zersong gwezal. Hwëna man sap nakablal.” ");
INSERT INTO ury_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesus ki zep gubiridaka, “Eiwa, angkam de zini em ei nibarena hom tangan! Em in nol drak-drak enna. Ëe san ëse nakaë sap emsa golëlowehe gwek! Ëe ama bae– eban mae de holokam golëlowehe gwen naye. An san emki walasna insa zerhalzan.” ");
INSERT INTO ury_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesus dekam zep dowala insa jala ban zëbon onakon de wet son hap gubluka. Hëndep dowala in dekam zep kon wet soka. Walas tola in dekam zep hëndep dawem gweka. ");
INSERT INTO ury_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ëe zëre hon de ang ta gwen wenya ki zebë hwëna zë-erenak du këblazak, zao zebë lakensïblïk, “Bian, ëe ba hap tanganë dowala insa ëralsa sone srëm gwer?” ");
INSERT INTO ury_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ki zep asa ding gulzimki, “Sap em home dawemkam Asa laïblïblaꞌan. Eiwa denakaë emsa gubiridaꞌan: Eno mae mo Asa de taïblïblan de betek mae nik lwaꞌanam– sap rica dan betek makare nik, dekam eme kwatapsa anakan enblaꞌanam, ‘Wakin san dep em al gwen,’ zen dekam maka ki hëndep al gweꞌara. Dekam banakare maena hom– em de desa syal gwibin srëm hap denaye.” ");
INSERT INTO ury_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesus kim zëre hon de ang ta gwen wenya asa Galileak golëlowe heꞌanka, zao zep etan asa gubiridaka, “Molya holo gwek ki sa ngatan zi mo lang nakore Zi Tanganna Asa jal zi mo tahanak dep tapbla dazim. ");
INSERT INTO ury_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Zen sa Asa dal, hwëna yaklana dan-ahan, ki sa Bian Alap etan Asa ngaya tala.” Ëe kimë kirekam asalblak, ano mae mo enlalana man tangan ëdowe hanak. ");
INSERT INTO ury_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesus kim aban Kapernaumk golëyaïng gweka, hwëna Alap mo golak dep de te-ala alal ta gwen zini ki zep Petrus hon yaïng gwezak, zao zep dakensïblïzak, “Eno mae mo guruna in wëhë Alap mo golak dep de te-alana tahun jamkam gol gwizimnira? San ha hom?” ");
INSERT INTO ury_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petrus ki zep ding gulzimki, “In kike.” Zen kim etan lwahal zaka– Yesus men zao gola gwëꞌanka, zen de nama ol toran srëmnak Yesus zep nonol takensïblïka, “Simon, eno tame gun nukon banakan? Auhu-kamanak awe de teipsïn-teipsïn wenya, zen san ha iye zem onakon pajak te-alana alal danda gwenan? San ha aha zi en nakon alal danda gwenan?” ");
INSERT INTO ury_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus ki zep ding gulbluka, “Zen dwan aha zi en nakon am alal danda gwenan.” Yesus ki zep ding gulbluka, “Zep Bian Alap mo walasna, nen sap esa Alap hap dena insa ing ul srëm gwe-gwer. ");
INSERT INTO ury_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Hwëna nene te-alasa olzim srëm gweꞌanka, zen sa nësa husus neizim. Zep emki ho gutu san yal ta nubin hip song gwen. Hogwena mensa nonol gul ineꞌanka, zëno ëk mwannak esa te-ala kasona sowe henkam hlaulu– nen de desa olzimdin hip denaye. Desa emki zëbe mae hap nëre nik mo bose hap golzimdin.” ");
INSERT INTO ury_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Zao kim Yesus asa golëlowe heꞌanka, ëe dua-blaskam de wenya dekam zebë zë lakensïblïzak, “Alap mo ïrïk gïnnïk, abon mae onakon nara sa teipsïlï?” ");
INSERT INTO ury_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesus dekam zep walas tola haen gweblaka, ki zep ano mae mo nwenak de zaun hup gubluka, ");
INSERT INTO ury_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ki zep hwëna asa gubiridaka, “Eiwa denakaë emsa gubiridaꞌan: Em de ere mae mo gwënsa wet gulsun srëmkam dekam de walas bete-tek mo kim lowehen hap, em molye Alap mo ïrïk gïnnïk bïtï gwek. ");
INSERT INTO ury_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Zini men zen zëre mo enlalana walas betekna an mo kim betek taꞌanka, zen zen sa Alap mo ïrïk gïnnïk teipsïlï. ");
INSERT INTO ury_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hen zini men zen de ano bose hap aha zisi mas gweblaꞌanka– sap anakare walas tol maesa, Ëe asa desa enlala gweblal, ‘Zen Asa mas gweblaꞌara.’ ");
INSERT INTO ury_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Men nara Asa de taïblïblan zisi, sap hen anakare walas betek maesa, karek san dep zertoranna, zen dikim hwëna Asa hli tan hap, kire zini Alap sërkam tangan sa karek tala. Diki dawemna, zen maka zertoran srëmnak karekkam de tïnsï hlaulku. Kaso dohon-honsa de holenak hule soneblan naban de hi tateknak keing gwen maekam, ki Alap molya karek taꞌanam. ");
INSERT INTO ury_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kareksa de gon hap de enlalana eiwa ki okamanak awe hata gwizimnira, hen zini zep Asa de taïblïblan nakon ëaltïl gwenan. Zen zep sa lamkam tïngare zi mo karek-karek hap okamana ansa Alap olo gulu. Hwëna zini men zen zi bose zemka Asa dikim hli tan hap nolëton gwenan, zen zen sa sërkam de karekna noltower. ");
INSERT INTO ury_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Emsa de ere mo aha taha ahaksa tana anakan tïtï da gweꞌanam, ‘Haen, karekna ansa nen on,’ diki dawemna em blansïn nïka hiri son. Sap eme dare taha naban ahaksa tana naban zigwëꞌanka, ki esa hëndep Asa hli tala. Ki hwëna tïnsïn srëm syauknuk dep sa emsa hiri daser. Blansïnkïm ki emaka sam gwesïꞌïra– aha-ere taha naban ahaksa tana naban de Alap onak gwë gwen hapye. ");
INSERT INTO ury_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Hen kirekam, emsa de ere mo aha nwe tïtï ta gwenna, ‘Haen, nen karekna wakinsa karatda un,’ ki em nwena insa alsïn nïka hiri son. Sap eme dare nwe naban zigwëꞌanka, ki esa hëndep Asa hli tala. Ki hwëna tïnsïn srëm syauknuk esa hëndep denaban gwë gwera. Alsïnkïm emaka sam gwesïꞌïra– aha-ere nwe naban de Alap onak gwë gwen hapye. ");
INSERT INTO ury_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Bahem Asa de taïblïblan anakare walas bete-tekna anakan enlala gwibirida gwen, ‘Zen aban apdenak hom.’ Emki sap ëenlala gwen: Alap mo dam taha nakore zini man kire walasna aha-en aha-enkam kara da gwibirin, hen walas zem in de kareksa goltowenkam, dekam man Alapsa dang nïtïl gweblanan. ");
INSERT INTO ury_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Zep ansa emki ësane gwen. Em wëhë dam ulsuꞌuk? Ebon mae onakon, ahanik mo domba zaho de 100 enkam lowe heꞌanam, hwëna aha tolik de jek-jak gweblaꞌanam, zen banakan maka gwëꞌara? Zen 99kam dena insa kwatapnak maka sonak hli yuludaꞌara– dekam de jek-jak gwen zini insa tëblan hap. ");
INSERT INTO ury_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Eiwa denakaë emsa gubiridaꞌan: Zen kim de dombana insa hla taꞌanka, zëno zëbe hap de isrip-srina sa tangan taman kïnïl. 99kam de wenya in hap de isrip-srina sa lwalaher. ");
INSERT INTO ury_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Zen hen kirekam– ere mae mo ngatan zi mo langnak de Bian naye. Zen hom dwam gweꞌara– aha mae nik de hëndep de ëgwë gwen san dep de ora nakon syalhen hapye, sap anakare walas betek.” ");
INSERT INTO ury_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Asa de taïblïblan zi bose uk de ebe hap kareksa golblanna, emki zëbon osan song gwen– dekam de zë-erenak anakan gublun hap, ‘Em ema anakan asa karek taka.’ Sowëkam em e-en tap ulsun– aha de emsa tawa gwizimdin srëmkam. Zen de emsa salblankam, anakan de emsa gublun naban, ‘Bahem ano karekna insa enlala gwibin,’ ki mese etan umlae ënda– san de ere mo iyena kiye. ");
INSERT INTO ury_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Hwëna zen de kirekam emsa salblan srëmna, emki ahanaka kwang tan, ahaksa dan kwang son– deban mae de tap gulsun hup. Sap Alap mo olak man lwak: ‘Bahem zini na-en karek tan– aha-ere zi de anakan gublunkamye, “Zen man karek gweka.” Diki zini dan, ahaksa dan-ahare zi de kirekam gublunkam, “Zen man eiwa karek gweka,” dekam karek gwen zini insa em karek tan.’ Zep aha zisi em kwang son– zen de tap gunnuk ang ën hap hen eno olsa soson un hip. ");
INSERT INTO ury_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Hwëna emsa de karek tan zini in de nama eno mae mo olsa san srëmkam, dekam jematnak de tagal gwennak em zëno karekna insa kira gulblun. Hen zini in de etan jemat mo dwam gwibin sin ang gwen srëmkam, dekam tangan tïngare jematna em zini insa langa tasïn– men kirekam Israel zini Alapsa de tame tan srëm zini neibirida gwenanke. Dekam sap esa zini insa langa lasïl– men kirekam Israel zini pajak te-ala alal ta gwen zisi neibirida gwenanke. ");
INSERT INTO ury_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ëe eiwa denakaë emsa gubiridaꞌan: Em Abon de bïtï gwen wenya, em esa ngatan zi mo langnak de Bian mo dwam gwibin sin okamanak de zi hip anakarekam klis ul gwizim, ‘Kirekam de ëgwënna zen Alap mo nwenak karek,’ hen ‘Kirekam de ëgwënna zen Alap mo nwenak kareksa hom.’ ");
INSERT INTO ury_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Hen Ëe ama etan emsa gubiridaꞌan: Ebon mae onakon de aha dare nik okamanak awe olsa anakan aha-en uꞌinam, ‘Nen kirekam esa Alapsa abe la gwera,’ ano Bian sa kirekam de abena dokwak gul gwera, hen sa kirekam syal gwe-gwibir-zimdi. ");
INSERT INTO ury_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sap em men zëwe ano bose hap dan-dan, ahaksa dan-ahare zi mae tagal gwenna, Ëe dekam hen asa eno mae mo ngïrïn klesnak dum gwehe gwezal.” ");
INSERT INTO ury_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Petrus ki zep Yesussu takensïblï zaka, “Bian, ano wal bose de abe hap etan-etankam kareksa gol gweblaꞌanam, beyana banakare ennak de zaunnuk amaka eititi gwibir-bli zaheꞌan? San ha tuju ennak amaka golzausuꞌun? Dekorena molyë eititi gwibir-blik.” ");
INSERT INTO ury_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesus ki zep ding gulbluka, “Tuju ennak bahem. Diki 700 ennak zen hëndep zaun– emsa de karek ta tine gwen naye. ");
INSERT INTO ury_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Sap Alap zëre mo ïrïk gïnnï zen gulk sun de ol blaoranna an kiye: Teipsïn zini man zëre mo te-alana aïtblïka. Dekam te-alana mensa zëre mo taha trï so gweblan zi hip bohë tazimnira gweka, desa man etan dwam gweblaka. Ki zep gubiridaka, ‘Ap etan kap lablak.’ ");
INSERT INTO ury_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Dekam zep jana zi zem ahanaka nër halzak– men zëno bonna miliar-miliarkam lwablakake. ");
INSERT INTO ury_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Hwëna zen man teipsïn zini insa gubluka, ‘Ano te-alana hom sowe heꞌara– desa de etan sowe henkam ebe hap zerblan hapye.’ Dekam zep hwëna teipsïn zini in jana zi zemka gubiridaka, ‘Dekam balk lak. We wal walas zemka hen lahyok. Te-ala hap zëno mae mo timsi lirak labik. Zen dikire aha zi mo tana ïltïkïnnïk ëbabu gwe-gwek. Hen zëno gola hen zëwe de kire-kirena kïtak te-ala hap lirak labik. Te-alana desa abe hap kap lablak– zëno bon yala insa dikim ber-ber gun hupye.’ ");
INSERT INTO ury_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Zini in kim kirekam salblaka, dekam zep teipsïn zini in mo nwenak ïk gwehe zaka, dekon zep anakan abe ta seka, ‘Bian, sap ki asa eissïblï. Ëe asa kïtak hëndep ep golblal.’ ");
INSERT INTO ury_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Teipsïn zini in dekam zep dawemkam kwasang gweblaka. Dekam zep jana zi zemka gubiridaka, ‘Bahem banakan mae gwëblan.’ Hen anakan gubluka, ‘Ëe mesë kïtak eno bon yala insa ep eititi gwibir-blinan.’ ");
INSERT INTO ury_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Hwëna teipsïn zini in mo gola kon kim te soka, zen hwëna dekam zep wal bose zemka zertoweꞌanka. Zini in hen teipsïn zini in hon de syal gwe-gwenna. Zen hwëna mes zëbon 900 ribu enkam bohë taka. Zen hwëna man tol wal bose zem insa balk taka, hen holenak jak tasïkï, deban zep gubluka, ‘Mensa abon te-alana bohë taka, angkam em hëndep ap zerblan.’ ");
INSERT INTO ury_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Wal bose zem in sap ki zëno nwenak anakare ola ban ïk gwe heka, ‘Sap ki asa eissïblï. Ëe asa kïtak hëndep ep golblal.’ ");
INSERT INTO ury_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Hwëna wal bose zem in man eissïnkïm dep baes gweka. Zen zep hwëna jana zinik klak taka. Zen zep bwinak tak daink, hen anakan zëno ola ayang nulblik, ‘Kim de te-alana etan zëbe hap golblaꞌanka, yaklana dekam esa wet sola.’ ");
INSERT INTO ury_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Teipsïn tangan zini in hon de syal ta gwen bose wal zem kim kirekam ësak, zen man tangan enlalana ëdowe hanak. Dekam zep zen teipsïn tangan zini insa anakan nenblak, ‘Wal bose zik desa kirekam karek taꞌara.’ ");
INSERT INTO ury_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Teipsïn zini in dekam zep gubiridaka– zëre mo taha trï son zi jal-jala insa de etan kwang ta halzan hap, wal bose zem insa klak takake. Kim nër halzak, zao zep gubluka, ‘Em an jal-jal tanganna! Em kime eissïn hïp asa abe taka, ëe ama hwëna eno bon yawal tanganna insa kïtak ep ngan gulsubluk. ");
INSERT INTO ury_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ki em san ha bëjen em wal bose omka kirekam kwasang gweblan?– men kirekamë ëe emsa kwasang gweblakye.’ ");
INSERT INTO ury_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Teipsïn zini in man tangan jal gweblaka, zep jana zi zemka bwinak de tak ta irin hip anakare ola ban gubiridaka, ‘Emki mwin-mwankam lek-lek ta gwen– hëndep de ano te-alana mensa bohë taka ap kïtak zerblak.’” ");
INSERT INTO ury_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesus dekam zep aïsïlï insa anakan ap waulsuzimki: “Ngatan zi mo langnak de ano Bianna hen kirekam sa emsa karek tabiri– em de wal bose wal uk mo kareksa enho nakon eititi gwe-gwibir-zimdin srëmkamye.” ");
INSERT INTO ury_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus kim tawa tabinni insa hya gwesibiridaka, dekam zep asa langna Galilea kon Yerusalem mo aha lang tek san dep golëgwë halka– weyana Yordan mo men eihya san dep. ");
INSERT INTO ury_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Zini hen beya tangan nik ang nëblak, hen zao zep sang-sang nabare wenyaka dawem ta gwibirki. ");
INSERT INTO ury_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Hwëna Farisikam de zini ki zep zë hen Yesussu de akasïblïn hap yaïng gwezak. Zen man zë dakensïblïzak, “Em banakane Musa mo tïtï tabin ola dam gulsuꞌura? San ha zini sap de we zemka baes gwibinkim?– banakare mae nakonye. San ha bëjen?” ");
INSERT INTO ury_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesus ki zep ding gulzimki, “Em bawalkam esa Alap mo ola an mo eini dam ulsul?– men zen anakarekam lwakye, ‘Alap nonol tanganna zi niban wenya ban yang sosuku.’ ");
INSERT INTO ury_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Hen Zen dekam anakan guku, ‘Zini an-bi zemka hli sonkam– dekam de we zeban aha-en ën hapye. We-zi darena in dekam Alap mo nwenak san de aha-ere timni kiye.’ ");
INSERT INTO ury_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","In zebë emsa gubiridaꞌan: Alap mo nwenak we-zi darena zen dan hom. Zen hwëna aha-en. Zen in zep, Alap mensa aha-en sonna, zi bap zen etan kles son.” ");
INSERT INTO ury_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisikam de zini in ki zep etan dakensïblïk, “Ki Musa Bak ba hap anakan tïtï tabirki?– ‘Zini we zemka sap de baes gwibinkim, hwëna nonol baes gwibin hip de suratsa de anakan ale gunkum, “Ëe mesë kire hap baes gwibik.”’” ");
INSERT INTO ury_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ki zep hwëna ding gulzimki, “Musa Bak in mae hap kirekam ein emsa gubiridaka: Sap em in kïtak kwasang enlalana tawa naka hom. Hwëna nonol lonesen nakon, Alap sap hom kirekam dwam gweka. ");
INSERT INTO ury_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Hwëna Ëe ama emsa gubiridaꞌan: Men nara we zemka zen de kahalo gwen srëmnak baes gwibinni, hwëna ahanaka de etan gonkam, ki zini in Alap mo nwenak kahalonak gwë gweꞌara. Kahalo gwennak de baes gwibinni, desa Ëe homë jalse gwibiridaꞌan.” ");
INSERT INTO ury_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Hwëna ëe zëre hon de ang ta gwen wenya dekam zebë hen Yesussu enblak, “Hare orana aha-enke– Alap mo dwam gwibin sin de we zemka baes gwibin hip denaye. Kirekam de lwankam, ki zini bap zen wenya kap ta gwen.” ");
INSERT INTO ury_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesus ki zep asa ding gulzimki, “Hwëna kirekam de we gon srëmkam lowehe gwen hap dena, kïtak de zini molya desa dwam neibik. Diki men zëbe mae en hap Alap golzimꞌinka, zen en sa desan ang ta gwer. ");
INSERT INTO ury_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Sap zini ahakon mae hap we walya kap da srëm gwe-gwenan: Timni mes ki jaha gwen nakon karek gweblak. Ahakon hwëna aha zi zëno mae mo timni eirim karek nul gwizimnin, kire nakon kap da srëm gwe-gwenan. Ahakon hwëna Alap mo dwam gwibin sin de syal gwen hap sa we gon srëmkam lowehe gwer. Zen in zep, men nara anakan eisbinni, ‘Alap mes ki kirekam asa gubluka,’ zen dikire we gon srëmkam lowehe gwek.” ");
INSERT INTO ury_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Zini ki zep walas tane-nena Yesus onak dep kap nulhal gweꞌanzak– Zen de taha tehabirida inen naban Alapsa anakan gu soneblan hap, “Emki walasna an hap dawemsa gol gwizimdin.” Hwëna zëre hon de ang tan wenya ëyë anakan jalse eibirida gweꞌak, “Bahem Gurusa blos tablan.” ");
INSERT INTO ury_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Hwëna Zën zep asa gubiridaka, “Dikire Abon nolëyaïng gwe-gwezak. Bahem jalse gwibiridan. Sap walasna an makare wenya, zen zen Alap mo ïrïk gïnnï bi neibiꞌin.” ");
INSERT INTO ury_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Dekam zep hëndep Alapsa de gu sone gweblan naban tahana tehabirida ine gweꞌanka. Kim hya gwesibiridaka, ki zep kon etan asa golësek gweka. ");
INSERT INTO ury_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Aha yaklakam ki zep zini– zise gwen srëm nik, Yesussu takensïblï zaka, “Bian Guru, ëe banakare syal dawemsa asa gol?– dekam de Alap mo nwenak sërkam sam gwesïn hïp, Zen dekakim hëndep de gwën hap denaka abe hap golblaka.” ");
INSERT INTO ury_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesus ki zep ding gulbluka, “Em dwan ene maka dam gulsuꞌura– Alap mo nwenak dikim ‘sam gwesïn hïp’ denaye. Hëndep de ngaya gwen hap de sam gwesïn Zini, Zen diki aha-en– Alap Zë-en. Hwëna em de hëndep de ngaya gwen hap dwam gwenna, Musa mo tïtï tabin ol san em ang gwe-gwen.” ");
INSERT INTO ury_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Zini in ki zep etan takensïblïka, “Ki banakare wenyak asa ang gwe-gwer?” Yesus ki zep ding gulbluka, “Zen dwan anakanke, ‘Zini bahem tan. Bahem kahalo gwen. Bahem sowë gwen. Zisi bahem boton hap klak tan hen boton olsa bahem gol hala seran. ");
INSERT INTO ury_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ane-biasa em blikip gwesïk gwizimdin.’ Hen, ‘Zi bose omka em kwasang gwibirida gwen– san de enaka de kwasang gweblanna kiye.’” ");
INSERT INTO ury_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hwëna zini in ki zep ding gulbluka, “Ëe mesë kïtak desan ang gwek. Hwëna aha syala san ha ki?– desa de syal gwibinkim de ëe ngaya gwen hap denaye?” ");
INSERT INTO ury_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus ki zep gubluka, “Em de dwam gwenna dawemkam tangan de Alap mo nwenak sam gwesïn hïp, em song gwen, ere mo kire-kirena kïtak tangan te-ala hap lirak tabir. Te-alana desa tahalha zi hip kae gwebla-zim. Kirekame syal gwibiꞌinka, ki ngatan zi mo langnake hëndep de te-alasa beyakam lam taꞌara. Ena dekam etan hataza– Asa dikim ang gweblan hapye.” ");
INSERT INTO ury_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kirekam kim salblaka, dekam zep kon enlala dowe hanan naban song gweka– mae hap: Sap zëno kire-kirena beya tanganna. ");
INSERT INTO ury_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ki zep hwëna asa gubiridaka, “Eiwa denakaë emsa gubiridaꞌan: Eiwa, dam-dam naka hom– te-ala beya zi de Alap mo ïrïk gïnnïk hatan hapye. ");
INSERT INTO ury_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ama etan emsa gubiridaꞌan: Te-ala beya zi de Alap mo ïrïk gïnnïk tïn hïp dena, zen men kiye– unta yawal de jaron hul betek san tïnnï. Kire otweran yawala toton bëjen tïn.” ");
INSERT INTO ury_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ëe kimë kirekam asalblak, ëe ama tangan ëtenggwank. Ki zebë ëguk, “Hare eiwa kire tangankamke! Ki hwëna endan nik sa ëngaya gwer? Toton nara molya.” ");
INSERT INTO ury_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Hwëna Yesus ki zep nwekam de amjanbin niban asa gubiridaka, “Eiwa, auhu-kama zini zëre mae mo sosonkam bëjen zënaka ngaya tabin. Hwëna Alap de zi hip syal gwibir-zimdin srëm hap dena, aha-en mae hom tanganke.” ");
INSERT INTO ury_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petrus ki zep gubluka, “Ki hwëna abe mae hap dena bankarekam sa lwal? Sap ëe mesë ëre mae mo tïngare bi gwibinni Emsa de ang gweblanda gwen hap hli kulidak. Zep ëe basa asa lamkam ulin?” ");
INSERT INTO ury_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ki zep hwëna ding gulbluka, “Eiwa denakaë emsa gubiridaꞌan: Ngatan zi mo lang nakore Zi Tanganna Ëe kimë okama ësenak Alap onakore ngatan nabare komal tumnak teipsïnkïm nikinꞌik, em Abon de ang ta gwen wenya dekam esa hen ere mae hap de dua-blaskam de komal tumnak teinikin– dekon de dua-blaskam de Israel Bak onakore zi aususa ïrïk gïn hïpye. ");
INSERT INTO ury_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hen zini men zen Asa de ang gwe-gweblan hap hli nulida gweꞌak– gol zem, aya-wal oso-wal zem, somol wal zem, an-bi zem, walas zem, ahaksa nga zem– zëbe mae hap hwëna Alap sabak tangankam sa etan kiresa kap gul gwizimdi– sap iyekam de gubirida gwen wenya, gol, hen nga maena. Hen zen hëndep de ëngaya gwen hap denaka sa nulin. ");
INSERT INTO ury_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Hwëna beyana men zen sap angkam bose naban lowehe gweꞌan, zen zen sa hwëna lamkam lure san ëgwër. Hen men zen angkam bose srëm wenya lowehe gweꞌan, zen zen sa hwëna lamkam ngein sin ëgwër.” ");
INSERT INTO ury_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Sap lamkam dep dena insa emsa gubiridanan, Alap kim de kïtak ïrïk gïꞌïnka, zen mae makan: Nga yawal mo bi nik de kak tangannak zi hip hakanna kiye– zëre mo anggur ngasa de syal gweblan hap. ");
INSERT INTO ury_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kim ola anakan ziaha-en gulku, ‘Aha-ere yakla blalkam de syal hap, ëe asa te-alana aha-ere-ala aha-ere-ala enkam ebe mae hap lop tazim,’ dekam zep syal tan hap sek gwek. ");
INSERT INTO ury_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Jam sembilankam zep nga bina in etan song gweka, dekam zep ahakore zini syal srëm naka etan hlauludaꞌanka. Pasarak ëwal-wale gweꞌak. ");
INSERT INTO ury_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Zao zep gubiridaka, ‘Em ano anggur nganak de syal tan hap sek gwen. Ëe asa ebe mae hap te-alasa ere mo syal jam enkam golzim.’ ");
INSERT INTO ury_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Zen hen dekam zep hëndep sek gwek. Yakla bolak denaban hen jam tigakam nga bina in kire enkam ahakore naka hen kwang guluda gweꞌanka. ");
INSERT INTO ury_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Jam limakam kim etan song gweka, etan dekam zep zini syal srëm naka hlauludaꞌanka, nama ësa nyaubluꞌak. Zao zep takensibiridaka, ‘Em ba habe yakla blala an yaublu tiner– ba maesa de syal gwibin srëmkamye?’ ");
INSERT INTO ury_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Zini in ki zep ding nulblik, ‘Abe mae hap hom am mae zini syal maena nolzim– zao de syal tan hapye.’ “Nga bina in ki zep gubiridaka, ‘Ki ano anggur nganak de syal tan hap em sek gwen.’ ");
INSERT INTO ury_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nga bina in dapse gwesïn nïban zep zëre mo irgwa tahana kore zini gubluka, ‘Dekam syal zini insa tagam gul. Zao te-alana kae gwebla-zim. Nonol aumwa hap de syal tan wenya kon kon gwesibir hana, hëndep aumwa hap nonol syal tan wenya kip golzim.’ ");
INSERT INTO ury_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dekam zep jam limakam de syal tan wenyik nonol yaïng gwezak. Zëbe mae hap te-alana aha-ere ala enkam zep kae gwebla-zimki. ");
INSERT INTO ury_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aumwa hap zep hwëna kak tangannak de syal tan wenya yaïng gwezak. Zen man ëkïl gïꞌïk, ‘Abe mae hap mam tolkam sa kae gwebla-zimdi,’ hwëna zëbe mae hap hen kire enkam kae gwebla-zimki. ");
INSERT INTO ury_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kim ki te-alana insa kap daink, dekam zep nga bina insa jala ban donblaꞌak, ");
INSERT INTO ury_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Aumwanak in zen syal tal, zen aha-ere jam enkam syal tal. Ëe hwëna yakla langasaë syal ta tiner. Em hwëna apde enkam te-alana abe mae hap golzimdi, hwëna ëe yakla sal-sal yawalakë waba hap syal ta tiner!’ ");
INSERT INTO ury_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Nga bina in ki zep ahanaka ding gulbluka, ‘Ano wal bose, ëe homë emsa karek tabir. Ki san ha nen home ola aha-en ul?– te-alana ebe mae hap aha-ere ala enkam de golzimdin hipye, aha-ere yaklakam de syal hapye. ");
INSERT INTO ury_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Zep ebe mae hap dena in desa emki kap ta irin, deban sek gwek. Sap emsa ëe kirekamë dwam gwibiridaꞌan– aumwanak in zen hen mas tal zëbe mae hap hen kire enkam de kap tazimdin hip. ");
INSERT INTO ury_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","San ha ebon mae onakon ëe kirekam babë ëre mo enlalakam syal gwen– ëre mo te-alakamye? San ha ëe de aha zi hip kirekam kae-kae gwen hap em ema asa husus ëblaꞌan?’” ");
INSERT INTO ury_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesus ki zep etan asa gubiridaka, “Zen lamkam kirekam sa hen lwal: Men zen angkam bose srëm wenya ëgwëꞌan, zen zen sa hwëna lamkam ngein sin loweher. Hwëna men zen angkam bose naban lowehe gweꞌan, zen hwëna lamkam zen sa lure san ëgwër.” ");
INSERT INTO ury_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesus kim zi beyam-bya naban Yerusalem san asa golësek gweꞌanka, oranak zep dua-blaskam de zini asa en srën tagal gulsuku, zao zep asa gubiridaka, ");
INSERT INTO ury_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ola ansa emki ësan: Nen an angkam Yerusalemk debe yaïng gwe seꞌan. Zëwe ngatan zi mo lang nakore Zi Tanganna Asa sa tapbla dazim– Alap mo golak de syal tan zi mo mam-mam wenya kip, hen Musa mo olsa de tawa ta gwibin wenya kip. Zen sa hwëna Asa de tan hap ola aha-en nul, ");
INSERT INTO ury_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","hëndep Asa sa Yahudi srëm zi mo tahanak dep tapbla dazim. Zen sa hwëna Asa lamang da gwer, hen dangole gwer. Hëndep te-lidak sonnak sa Asa makan dain. Hwëna yaklana dan-ahan, ki sa etan Alap tïn nïkon Asa ngaya tala.” ");
INSERT INTO ury_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeus Bak mo wenya ki zep walas dare zem Yakobus ne Yohanis neban Yesus onak zihatazak. Yesus mo nwenak zep boklena kom sozak– dekam de abe tan srëmnak blikip gwesïblïn hap. ");
INSERT INTO ury_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesus ki zep zë takensibirki, “Em basae dwam gwibiꞌira?– desa de ebe hap golbin hipye.” Wenya in ki zep ding gulbluk, “Ëe mae habë dwam gweꞌan: Em kime teipsïnkïm ïrïk gïꞌïnka, ano walas darena an dikire hen teipsïnkïm eno alp nakon inikink– ahana eno dam taha nakon, ahana irgwa taha nakon.” ");
INSERT INTO ury_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesus ki zep gubiridaka, “Hwëna ena home tame uꞌin– in zebe ëabe gwenanye.” Ki zep hwëna walas dare zem insa guzimki, “Karek yawala men desaë goltoweꞌak, em wëhë desa de oltowen hap hen hohle ëꞌara?” Ki zep ding ulblika, “Ëe ama hen hohle ëꞌan.” ");
INSERT INTO ury_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Zao zep etan guzimki, “Eiwa, em hen esa tol oltowera– Ëe men kiresaë goltoweꞌakye. Hwëna men zen de ano irgwa taha nakon hen dam taha nakon inikinꞌinka, desa Ëe bëjënë dam sosun. Zëwe de inikirin hip dena, zen diki ano Bian Zëna mensa dam sosuku, zen diki zen sa zë inikiri.” ");
INSERT INTO ury_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Hwëna ëe dare taha-tapkam de ahakore ang ta gwen wenya kimë zëno nik mo abe lan ola insa ësak, ëe dekam zebë mae hap sïsngïn eizimꞌik, “Zen bap zen de mam ën hap abe lala!” ");
INSERT INTO ury_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Dekam zep Yesus asa kïtak tagal gulsuku, zao zep asa gubiridaka, “Ena dwan tawa nakake: Alapsa de tame tan srëm lang-langnak men zen teipsïn-teipsïnkïm teinikin gwenan, zen man zëre kore naka jap nul sonenda gwenan hen nyaubirida gwenan. ");
INSERT INTO ury_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Hwëna em zëno mae mo kim bahem. Ebon mae onakon men zen mam gwen hap dwam gweꞌara, zen diki tïngare zi mo babu gwen zi makan zen gwën. ");
INSERT INTO ury_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Hen ebon mae onakon men zen teipsïn hïp dwam gweꞌara, zen diki tïngare zi mo tana ïltïkïnnïk zen nikirin. ");
INSERT INTO ury_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sap ngatan zi mo lang nakore Zi Tanganna, Ëe an zi de Asa babu gweblan hap homë hatazak. Zep em hen ano tana wei san emki Asa zertro gwen. Sap Ëe tïngare zi mo tana ïltïkïnnïk de nikirin hibë hatazak– hëndep ëre mo angsa de tïngare zisi dikim hïl tï sonebin hip sosok tazimdin hip.” ");
INSERT INTO ury_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesus kim ë yala Yerikosa asa zihli taꞌanka, zini beyam-bya tangan nik zep ang nëblak. ");
INSERT INTO ury_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Hwëna zi nwe dïmïn darena ora alpnak inikinꞌinka. Kim anakan asalka, “In Yesus man-am tamanꞌan zala,” ki zep ahërhe hana gweꞌanka, “Daud Bak mo Auyan-tane, ano nik mo Teipsïnnï, asa Em kwasang gwizimdin.” ");
INSERT INTO ury_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Zi beyam-byana in zep jalse neizimk, “Balkkam!” Hwëna zen dekam tangan zep mam tangankam ahërhe hana gweꞌanka, “Daud Bak mo Auyan-tane, ano nik mo Teipsïnnï, asa tol Emki kwasang gwizimdin!” ");
INSERT INTO ury_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesus ki zep zausuku, ki zep takenzimki, “Em basae dwam eibiꞌira– Ëe de desa ebe nikip syal gwibir-zimdin hipye?” ");
INSERT INTO ury_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ki zep ding ulblika, “Bian, ëe nwesa de kara ën habë dwam ëꞌan.” ");
INSERT INTO ury_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesus zao zep dawemkam kwasang gwizimki, ki zep zëno nik mo nwena insa olk sozimki. Hëndep dekam zep ki nwena kara ëka. Dekon hëndep Yesussu zep ang ëblaka. ");
INSERT INTO ury_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesus kim asa Yerusalemk golëgolek de gweꞌanka, dekam zebë ëna Betfagek yaïng gwek– zaitun tra nabare kwatap teknak. Dekon zep dua-blaskam de zini abon mae onakon dan-dan guzimki– zen de angir gun hup. ");
INSERT INTO ury_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Zao zep aïsïl soka, “Em ëna wakin san song ën. Ë topnak kime lïꞌïnka, zao esa keledai wenya da tabin nika tane zeban akera. Desa abe hap leisyabla halza. ");
INSERT INTO ury_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Zi de emsa takensizimdinkim, ‘Em ba habe leisya haꞌara?’– a kirekam ding ulzim, ‘Bian dwam gwizimꞌira. Zen sa etan nabakam teisya sone zala.’” ");
INSERT INTO ury_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Zen mae hap ki kirekam lwak: Zakaria Bak mensa Alap mo ola orep ayang gulkuke– zëwe dikim zaun hup. Zen man ale gulku, ");
INSERT INTO ury_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ëna Yerusalemk de zini enbiridak, ‘Eno mae mo teipsïnnï man angkam ebon mae onak dep hataꞌara. Zen enlala sae-sae enna. Zen in zep keledai tane tahannak nikin anehaꞌan zala.’” ");
INSERT INTO ury_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Zëre hon de ang ta gwen zi darena in ki zep hëndep song ëka. Hëndep Yesus men kirekam aïsïl soka, kirekam zep ki hëndep syal ëka. ");
INSERT INTO ury_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Hëndep keledaina insa tane zem in han zep isong gwe zaka. Kim abon mae ihata zaka, keledai tanena in mo tahan dannak ëre mae mo tahan bajusa zebë kang lasek. Yesus zao zep hwëna sewe seka. ");
INSERT INTO ury_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Zi trana men zen nangirblin daꞌak, zëre mae mo tahan bajusa zep ora san dëre dahal gweꞌak– desan de keledaina in zersong gwen hap. Hen ahakon yera ala makare naka nublun gweꞌak, desa zep hen ora san dëre dahal gweꞌak. ");
INSERT INTO ury_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Zini beya tangan nik lure nakon ang nëblan daꞌak, hen beya tangan nik nangirblin daꞌak. Zen zep ëtaken gweꞌak, “Hëꞌho, hëꞌho! Are Daud Bak mo Auyan-tane! An Bian mo bosekam nësa dikim oto gulsun hup hata seꞌara. Hëꞌho! Diki Alap Zen zëbe hap dawemsa golblan! Hëꞌho! Nen kïtak teipsïn tangan Zini Alapsa boltere tan!” ");
INSERT INTO ury_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yerusalemk kim hëndep Yesus hata haka, zi beyam-byana men zen ang nëblazak mam enkam zep ëisrip-sri gwek, hëndep tïngare ë yala iwe de zini dekam zep ësaladak. Ki zep ëtakensïk gweꞌanzak, “Zen nara hataꞌara?” ");
INSERT INTO ury_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","In zen ang nëblan daꞌak zen zep ding nul gwizimꞌik, “An Alap mo ol ayang gul gwen zini Yesus suke– langna Galilea mo ëna Nazaret wal.” Kirekam de ëton gwen ol aukuna in zep mam gwek. ");
INSERT INTO ury_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesus kim Alap mo golak tïl zïka, dekam zep kon golëalsa soneka– men zen te-ala hap Alap hap de golblan kire-kirena lirak da gwibik. Meja-mejana men zao te-alana lirak da gwibik, hen komal-tum komal-tum maena men dekon mawa oholana lirak da gwibik, desa man yal tazimki. ");
INSERT INTO ury_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ki zep hwëna gubiridaka, “Alap mo olak man lwak, ‘Ano gola sa nen gwibir, “An Biansa dekon gu sone gweblan hap de gol.”’ Em an hwëna ‘sowë zi mo aning gol habe li kul sone gweꞌan.’” ");
INSERT INTO ury_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Hwëna ki zep zë hen zi nwe dïmïnnï hen lekna Alap mo gola iwe Yesus onak dep yaïng gwezak. Zao zep dawem tabirki. ");
INSERT INTO ury_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Hwëna Alap mo golak de mam-mam wenya hen Musa mo olsa de tawa ta gwibin hip de wenya, zen dekam zep ëjal tak– mae hap: Zen kim Yesus mo owas syal gwibinni insa hla nuk, hen walas tane-nena insa anakan Alap mo gola kon ëtaken gweꞌakke, “Hëꞌho, hëꞌho! Daud Bak mo Auyan-tane!” ");
INSERT INTO ury_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mam-mam wenya in dekam zep hwëna Yesussu dakensïblïk, “Em wëhë walasna insa salbirida gweꞌara? Em balk tasïn hïp gubiridan.” Ki zep hwëna ding gulzimki, “Ëe kië salbirida gweꞌan. Hwëna em bawalkam esa Alap mo ola an mo eini dam ulsul?– Daud Bak kim anakan Alapsa gublukake: ‘Walas tane-ne hap hen wal baïzïl hïp Em mese Enaka de boltere tan hap de tërya zëbe mae hap hamal tazimki.’” ");
INSERT INTO ury_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesus ki zep zë hli yuludaka. Ë yala in kon ki zep hëndep dua-blaskam de zini asa golësek gweka. Ëna Betaniak zep asa golëtruweka. ");
INSERT INTO ury_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kaꞌan kim kak tangannak zëre hon de ang tan wenya asa etan Yerusalem san dep golëlwanda haꞌan zaka, oranak zep usak gweꞌanka. ");
INSERT INTO ury_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ki zep hwëna tenya arana hlaulku. Ora alpnak zauꞌuk. Ki zep zëno ei nika de oran hap syal hebirki. Hwëna eini aha-en mae hom hlaulku. Ala enna. Dekam zep arana insa gubirki, “Em molye eini angkam hëndep tëka.” Arana in dekam zep ki hëndep boneng gwek. ");
INSERT INTO ury_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ëe kimë owasna insa hla kuk, ëe ama tangan ëtenggwank, hëndep ëe ki zebë ëguk, “Hare, tenya ara yala an mes-am kïtak tangan boneng gwenan!” ");
INSERT INTO ury_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","22","Yesus ki zep asa ding gulzimki, “Ëe eiwa denakaë emsa gubiridaꞌan: Eme Alap ensa tïngare enho naban anakan laïblï gweblaꞌak, ‘Zen sa kirekam abe hap syal gwibir-blira,’ ki em hen esa sërkam de owasna syal ei gwibir– an kirekamë tenya arana ansa gweibirinye. Kire enkam denaka molye syal ei gwibik, hwëna em esa ano syala insa kwei kul gwer. Eme dekam Alapsa abe la gweꞌak, ‘Kwatap tekna an zen hinak zënaka ter sonen,’ zen hëndep kirekam maka Alap ebe mae hap syal gwibir-bliꞌara– em de taïblïblankamye. Dekam em de ba mae hap abe tankam, em esa ulin gwer.” ");
INSERT INTO ury_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesus kim etan Alap mo gol san dep lwahal zaka, kim zë tawa tabiꞌinka, Alap mo golak de syal ta gwen zi mo mam-mamna Yahudi mo nol-nola ban ki zep hen yaïng gwezak. Zao zep dakensïblïk, “Emsa an nara gubluka, hen nara emsa trï tase gweꞌara?– dekam de kirekam-kirekamna insa syal gwe-gwibin hipye.” ");
INSERT INTO ury_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Ki zep ding gulzimki, “Ki Ëe asa hen nonol emsa takensibiridal. Baptis ta gwibin zini Yohanis Swesa san ha Alap trï ta seka? San ha zen zëre en mo sosonkam ki syal gwe-gweka? Eme nonol ap ding ulbliꞌak, ki Ëe asa hen emsa gubiridal, ‘Asa Zen trï ta seꞌara, zebë kirekam syal gwe-gweꞌan.’” Dekam zep zë-en anakan donbiꞌik, “Bëjen nen anakan ding gulblun, ‘Alap trï ta seka,’ ki hwëna zen sa nësa gubiridala, ‘Ki em ba habe desa laïblïbla srëm gwek?’ ");
INSERT INTO ury_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Hwëna anakane ding ulbliꞌak, ‘Yohanis zen zëre en mo sosonkam syal gweka,’ ki hwëna zi trana an sa nësa karek dabir, sap zen Yohanissi mes-am anakan daïblïblak, ‘Zen eiwa Alap mo olsa ayang gul gwizimki.’” ");
INSERT INTO ury_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Anakan zep hëndep ding nulblik, “Ëe homë dam ulsuꞌun, ‘Yohanissi zen trï tase gweka.’” Ki zep hwëna ding gulzimki, “Ki Ëe hen molyë emsa gubiridak, ‘Ëe an zëno syalsaë gol gweꞌan, hen Zen Asa trï tase gweꞌara.’” ");
INSERT INTO ury_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesus ki zep etan Yahudi mo mam-mamna in hap ayang gulzimki, “Hwëna ena banakan wëhë ola ansa dam ulsuꞌuk? Zini ki, zëno zi walasna dan-dan. Bi zem in ki zep oso zemka gublu zaka, ‘Ano walas, em namen anggur nga syal gweblan hap em song gwen.’ ");
INSERT INTO ury_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Hwëna tane zem in man ding gulbluka, ‘Ëe ama baes gweꞌan.’ Hwëna hyanak zep enlalana wet tyasïkï, ki zep hëndep anggur ngana iwe de syal gwen hap song gweka. ");
INSERT INTO ury_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Hwëna bi zem in dekam zep hen aya zebon dep song gweka. Desa hen zëwe de syal hap gubluka. Zen hwëna man sap ding gulbluka, ‘Ëe asa.’ Hwëna zen hom song gweka. ");
INSERT INTO ury_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Zep eno mae mo dam gulsunkum, walas dare zem in, nara bi zik mo ol san ang gweka?” Mam-mam wenya in ki zep ding nulblik, “oso zik.” Yesus ki zep hwëna gubiridaka, “Zep eiwa denakaë emsa gubiridaꞌan: Anakare karek gol gwen wenya– sap pajak te-ala alal tanda gwen wenya, hen swi golak de lowehe gwen we walya, zen en hwëna man Alap mo ïrïk gïnnïk angkam bïtï gwe-gweꞌan. Em hwëna home. Lïlïkïn en nakone aha ensa bïtï gwennak kara la sone gwibiꞌin. ");
INSERT INTO ury_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sap baptis ta gwibin zini Yohanis in zen nonol hata zaka, zen sap Bian mo dwam gwibin sin de lowehen hap denaka ebe mae hap goltrei gwizimki. Hwëna em home zëno ol san ang tak. Hwëna karek gol gwen wenya in, zen en man owas hap Yohanis mo ol san ang tak, hëndep ëhalek. Hwëna em kime kirekam hla kulidak, em dekam home mae enlalana wet yasïk– dekam mae de hen Yohanis osan ang tan hapye.” ");
INSERT INTO ury_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Gulk sun de ol blaoranna ansa emki ahana etan ësane gwen: Zini kama bina, zen anggur ngasa eiyas tablaka. Alp san kolkam wale tablaka. Zao zep hen kasona hul gulku– anggur danna insa de zë tanakam it ta sone gwen hap. Hen gut de gola zao zep hen tauku– dekon de ngana insa kara ta ine gwen hap. Ki zep hwëna ngana insa te-alakam nga syal gwe-gweblan zi hip bohë ta guzim halka. Zëna dekam zep aha lang san holokam de zë gwën hap song gweka. ");
INSERT INTO ury_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Anggur dan bïl gwen tamlenak kim zauk, dekam zep nga bina in zëre hon de babu gwen zini dan-ahan lup gul soneka– in zen nga zem insa te-alakam bohë dak, zëbon mae osan dep, ngana in kore te-ala hlïksa de zëre hap zer soneblan hap. ");
INSERT INTO ury_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Hwëna zini in zen ngana insa bohë dak, zen hwëna man nga bi nik mo zi lup gul sonenna insa dahyok. Ahana man dangolek, ahana man tol dak, hen ahana kasokam tok hap nïrïblak. ");
INSERT INTO ury_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nga bina in ki zep ahakore babu gwen zini beyakam etan kap gul soneka. Nonol lup gul sonen nakon man taman kïnïk. Hwëna desa kirekam tol hen neibiridak. ");
INSERT INTO ury_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nga bina in dekam zep enlala gweka, ‘Ëre mo walas tangansa anik ki zer sonek. Desa sa blikip neisïblïl.’ ");
INSERT INTO ury_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Hwëna nga bohë tan zini in kim hla da guk, dekam zep anakan ëguk, ‘Wakin angkam zëre mo walas tangan hataꞌara. Bi zik de tïnkïm, an zen sa hwëna ngana ansa bi gweblala. Nen tan, ekakim nën bi ëblak!’ ");
INSERT INTO ury_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dekam zep hen tane zem insa balk dak. Ngana in kon ë san zep hiri dak, zao zep tol hëndep dak.” ");
INSERT INTO ury_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesus ki zep takensibiridaka, “Zep anggur nga bina in de lwahal zankam, zen banakan sa gweibirida zala– nga bohë tan zini in saye?” ");
INSERT INTO ury_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Zi trana in ki zep Yahudi mo mam-mamna in han ding nulblik, “Zen sa zi jal-jala insa timbwas tabir zira. Ki sa hwëna zëre mo taïblïbiridan wenya kip anggur ngana insa bohë tazimdi– zen de bïl gwen tamlenak ngana in kore te-ala hlïksa zëre hap zer gweblan hap.” ");
INSERT INTO ury_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","43","Yesus ki zep hwëna ding gulzimki, “In sap eiwa. Zen in zebë hwëna emsa gubiridaꞌan: Hëꞌho gwibin langna men zëwe dep sap Alap nonol emsa kalang gwibiridaka, hwëna zëre mo taïblïbiridan zi hip sa li yul sonezimdi– men zen diki zëre mo syal eini nol gweblananke. Hwëna em bawalkam esa Alap mo ola an mo eini dam ulsul?– ‘Gol tauk gweblan wenya mensa gol tenya baes neibik, hwëna Bian Alap zep desa bolak ïk gïlkï. Zen diki Bian zëre mo syal, hen nëno mae mo nwenak zen owas tangan.  ");
INSERT INTO ury_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Zep zini men zen de gol tenya iwe ëtïsïk gweꞌanzak, zao sa hëndep ëtimbwas gwe-gwer. Hen gol tenya in men zëbon mae de zan ineꞌak, zen sa hëndep ëïls gwer.’” ");
INSERT INTO ury_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Alap mo golak de syal ta gwen zi mo mam-mamna hen Farisikam de wenya in kim kirekam Yesus mo gulk sun de ol blaoranna insa ësane gweꞌak, dekam zep anakan dam nulsuk, “O zëno ola an nëbon mae am tïꞌïn.” ");
INSERT INTO ury_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Dekam zep sap balk tan hap dwam nëblaꞌak, hwëna zi beyam-byana insa naïrïbiridak. Sap zi beyam-byana in Yesussu man enlala në gweblaꞌak, “An Alap mo ol ayang gul gwen zi sike.” ");
INSERT INTO ury_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesus ki zep etan Yahudi mo mam-mam zini insa gulk sun de ol blaonzimdinkim aïsïl gwibiridaka, ");
INSERT INTO ury_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Alap zëre mo ïrïk gïnnï, zen gulk sun de ol blaonzimdinni an kiye: Zen san de teipsïn zi de tane zikhip de we oto gulblunnak tembane yawalsa syal gwibinni. ");
INSERT INTO ury_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Teipsïn zini in hamal hap mes nonol gubirida guku– men desa zëna dwam gwibiridakaye, tembane yawala iwe de ang tan hap. Tembanena kim sowe heka, ki zep zëre hon de ëbabu gwe-gwen zini lup gul sonen daka– zen de zini insa kwang guluda naseran hap. Hwëna hamal hap de gubiridan wenya in man yaïng gwen hap baes tak. ");
INSERT INTO ury_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Teipsïn zini in ki zep ahakore naka etan lup gul soneka. Zen man gubiridaka, ‘Zini insa anakan enbiridak, “Tembanena mes dë danan. Sapi zirya hen tane-nena hanapna tangan naka mes beyakam taïblïn dabir. Kïtak mes hohle danan. Angkam dekam de tembane yala awe dep yaïng gwezak.”’ ");
INSERT INTO ury_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Hwëna men desa sap kwang nulidak, zen man nasalsibiridak. Zen hwëna zëre mae mo syal san dep sekwak gwendak– ahakon nga san, ahakon hen zëre mae mo syal bete-tek san. ");
INSERT INTO ury_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Hen ahakorena teipsïn zini in hon de ëbabu gwe-gwen zini insa dahyok, zao zep ol lamang naban dangolebik, hëndep damerak. ");
INSERT INTO ury_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Teipsïn zini in kim kirekam salka, zen man tangan jal gweka. Dekam zep zëre mo jana nabare zini lup gul soneka– zen de hwëna desa tameran hap, in zen damerakke, hen zëno mae mo ësa de ang tan hap. ");
INSERT INTO ury_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Dekam zep etan ëbabu gwe-gwen zini insa tagal gulsuku, zao zep gubiridaka, ‘We oto gublun tembane yawala an mes hohle danan. Hwëna mensa sap gu sonebiridak, zen hom ang tan hap ëdakastïk. ");
INSERT INTO ury_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Zep emki angkam sek gwen– ora bol yawal-yawal san. Mensa ki olëtowe gwek, zen desa kïtak tembane yawala awe dep kwang ulidahal gwezak.’ ");
INSERT INTO ury_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Babu zem in ki zep hëndep sek gwek– ora-bol ora-bol san. Zini men desa ki nolëtowe gweꞌak, desa zep tïngan kwang nulida halzak. Ahakon dawem-dawem naka, ahakon karek-karek naka. Hëndep tembane yawal hap de teksonna in dekam zep zikim sowehek. ");
INSERT INTO ury_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Hwëna teipsïn zini in ki zep tïl zïka– in zen yaïng gwek, desa de hlauludan hap. Hwëna dekam zep ahana hla taka. Zen hom tembane yawala iwe dikim ang gwen hap de bajuna ala soꞌanka, hwëna totore bajusa ala soka. ");
INSERT INTO ury_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Zao zep takensïblïka, ‘Wal bosyan, em banakan tangane awe tïl zïla?– tembane yawala awe dikim ang tan hap de baju ala son srëmkamye.’ Zini in hwëna hom mae banakan mae ding gulbluka. ");
INSERT INTO ury_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Teipsïn zini in dekam zep zëre mo irgwa taha nakore zini gubiridaka, ‘Dekam taha-tana tahalebir-blin naka kawesïn sïn dep hiri lak– men dekon zi mo angna yusyustïn nïban gona ta gwenanke, hen sang-sang hap ëkna ngalk-ngalk da gwibirinke.’” ");
INSERT INTO ury_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Zao zep Yesus gulk sun de ol blaonzimdinni insa anakare ola ban golzausuku, “Sap eiwa, kïtak de kwang gulu dankam, hwëna eiwakam de hlïl irin wenya kïtak hom.” ");
INSERT INTO ury_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Dekam zep Farisikam de gubirida gwen zini zë-en nonol ola anakan aha-en nuk, “Nen banakare u siwen olkam esa taken-taken ëblal?– dekam de zëno karekkam de ding gun nukon karek tan hapye.” ");
INSERT INTO ury_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ki zep zëre mae hon de ang ta gwen zisi hen teipsïn zini Herodes mo hlïknak de bïtï gwen zi niban Yesus osan dep lup nul sonek. Zen zep Yesussu nenblak, “Bian Guru, ëe mesë emsa tawa ëblak: Em in dam-dam enkame gwë gwenda. Alap mo dwam gwibinni dam-dam enkame tawa ta gwibirida, sap zi mo husus gwibin maena damnake gollëwen srëmkam tonbirida gwenda. Sap em zi mo bosesa home kara gul gwizimnira. ");
INSERT INTO ury_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Zen in zebë emsa lakensïblïꞌan: Em banakane Musa mo tïtï tabin ola dam gulsuꞌura? San ha nen sap esa Roma mo ïrïk gïnnïk dep pajak te-alana ol gwizim? San ha bap nen?” ");
INSERT INTO ury_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Hwëna Yesus mes zëno mae mo enlala jal-jal aning tanna insa tame tazimki. Zep gubiridaka, “Em in eiwa de ora nakon mese tangan syan nahlak, zebe u siweblan hap de enlala naban kirekam Asa lakensïblïnanzal. ");
INSERT INTO ury_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Abe hap emki pajak hap de te-ala kasona insa ahanaka goltrëblan.” Dekam zep ahanaka nolblak. ");
INSERT INTO ury_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ki zep zë takensibiridaka, “Te-ala kasonak, an nara mo nwe-masesa zë yang dasïk? Hen nara mo bosesa zë ale nuk?” ");
INSERT INTO ury_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ki zep ding nulblik, “Roma mo teipsïn zi mo denakake.” Ki zep hwëna ding gulzimki, “Ki Roma mo teipsïn zini in mo bi gwibin kire-kirena amki zëbe hap etan lop la gweblak. Hen kirekam, Alap mo bi gwibin kire-kirena, amki Alap hap lop la gweblak.” ");
INSERT INTO ury_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kirekam de srip gulsizimdinnik kim sane daꞌak, zen man tangan denggwanblak, ki zep hëndep hli dak. ");
INSERT INTO ury_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Yaklana dekam zep Sadukikam de gubirida gwen zini u siwen ola ban hen Yesus onak dep yaïng gwezak. Zen Yahudi mo aha hlïkna– men zen anakan tawa da gwibirinke, “Zini bëjen tïn nïkon etan ngaya gwen.” ");
INSERT INTO ury_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Zen ki zep hen dakensïblïk, “Bian Guru, Musa Bak mo tïtï tabin olak a kirekam mo lwakye, ‘Zi de we zemka walas wë lan srëmnak tïnkïm hli yunnu, zen oso zik de etan gonkam– zen de zë walassa aya zik mo weinak dep wë tan hap. Hen kirekam, oso zik de tïnkïm, aya zik de hwëna we semna insa gonkam.’ ");
INSERT INTO ury_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Orep awe zini ki, beyana tuju enkam, aha-ere ane-bianna. Zëna zi nik zep nonol wenya golka, hwëna walas wë lan srëmnak zep tïlkï. We nal zem insa hwëna oso zik zep etan golka. ");
INSERT INTO ury_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Zen hen walas wë lan srëmnak zep tïlkï. Zao hen etan dan-ahan nik etan golka. Zen hen walas wë lan srëmnak tïlkï. Hëndep tujukam de aya-wal oso-walya in kire enkam zep sap nol gwek, hwëna walas ën srëm ennak zep juwe gwek. ");
INSERT INTO ury_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Wenya in hwëna aumwa hap zep tïk. ");
INSERT INTO ury_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Zep zen de etan ëngaya gweꞌanam, men kirekam ahakon tawa da gwibirin, wenya insa nara mo wekam maka nenbiꞌin? Sap tujukam de zini in mes desa kïtak nol gwek.” ");
INSERT INTO ury_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesus ki zep ding gulzimki, “Em in ema ëbute gweꞌan, sap em home Alap mo ola ban zëno soson naban tame osoꞌan. ");
INSERT INTO ury_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sap tïn nïkon de etan ëngaya gwenkam, dekam molya etan zënaka kap da gwek– men kirekam hen Alap mo dam taha nakore zini zënaka de kap tan srëmkam lowehe gwenanke. ");
INSERT INTO ury_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Hwëna em bawalkam esa Alap mo ola an mo eini dam ulsul?– tïn nïkon de ngaya gwen hap dena mensa gukuye. Zen man-am Yahudi zini emsa gubiridaka, ");
INSERT INTO ury_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ëe an eno auyan wal mo Alap– Abraham, Isak, hen Yakob Bak mo.’ Zep Zen tïn zi mo Alapsa hom. Zen ngaya wenyik mo Alap.” ");
INSERT INTO ury_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Zi trana in kim Yesussu kirekam de srip gulsuzimdinnik sane daꞌak, zen man tangan denggwanblak. ");
INSERT INTO ury_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farisikam de gubirida gwen zini kim anakan ësak, “Sadukikam de gubirida gwen zini etan banakarekam dep?– Yesus mo olsa de ding gulblun naye,” dekam zep hen yaïng gwezak. ");
INSERT INTO ury_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Zëno mae mo ahana, zen Musa mo tïtï tabin olsa de tawa ta gwibinni. Zen zep Yesussu de akasïblïn hap takensïblïka, ");
INSERT INTO ury_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Bian Guru, nëno mae mo tïtï tabin ola kon, bol-zaun tanganna enda zen moye?– desan de nen dawemkam ang ta gwen hapye.” ");
INSERT INTO ury_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ki zep ding gulbluka, “Zen a zen moye: ‘Bian Alapsa em ensa lwa gweblan– tïngare enho naban, enlala naban, hen tim niban.’ ");
INSERT INTO ury_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Zen zen– nonol wenya hen bol-zaun tangan wenyaye. ");
INSERT INTO ury_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ahana hen ki– deban de apde nën makare naye. Zen a kirekam moye: ‘Zi bose omka em kwasang gwibirida gwen– san de enaka de kwasang gweblanna kiye.’ ");
INSERT INTO ury_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tïngare tïtï tabin ola mensa Musa Bak ayang gul gwizimki, hen Alap mo ola mensa aha zi ayang nul gwizimk, zen ausuna kïtak dare tïtï tabin ola in zëwe.” ");
INSERT INTO ury_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisikam de zini in kim zë nama lowe heꞌak, Yesus ki zep takensibiridaka, ");
INSERT INTO ury_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Eno mae mo tame gun nukon, Israelsa de ngaya tabin hip de Zi hip dena banakan? Zen nara mo auyan-tanekam sa hata zala?” Ki zep ding nulblik, “Zen Daud Bak mo auyan-tanekam sa hata zala.” ");
INSERT INTO ury_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ki zep hwëna ding gulzimki, “Ki hwëna Daud Bak zëna ba hap Israelsa de ngaya tabin hip de Zini insa ‘Teipsïn Zi’kim gubluka?– Alap mo Enhona kim bi gweblakaye. Sap zen dekam anakan am guku, ");
INSERT INTO ury_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bian Alap man ano Teipsïnnï gubluka, “Ëre mo dam taha nakon emki nikirin– dekon de hen teipsïnkïm ïrïk gïn hïp. Ki asa hwëna ebe hap de jal zini ere mo tana ïltïkïnnïk sisik gulin.”’ ");
INSERT INTO ury_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Zep Daud insa Israelsa de ngaya tabin hip de Zini insa ‘Teipsïn Zi’kim gubluka, ki Zen banakan sa zëno auyan-tanekam hata zala?” ");
INSERT INTO ury_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hwëna Yesussu de ding gulblun hap man topse nëblak. Dekam etan hom mae Yesus hon takensïblïn mae hap yaïng gwek. Saher hap baes tak. ");
INSERT INTO ury_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesus ki zep zi beyam-byana in han zëre hon de ang ta gwen wenya aban mae gubiridaka, ");
INSERT INTO ury_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Musa mo olsa de tawa ta gwibin hip de zi niban Farisikam de gubirida gwen zi niban, zen sap Musa mo weinak zëno ol san de lowehen hap emsa tïtï da gwibirin. ");
INSERT INTO ury_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Zen in zep zëno mae mo ola in san emki ang ta gwen. Hwëna zëno mae mo lowehen san bahem ang ta gwen. Sap zen in dekam tawa da gwibirin, deban hom apde në gwenan. ");
INSERT INTO ury_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Zep zëno mae mo emsa de tïtï ta gwibinni man nwe-mase gwe-gwenan– san de zi de aha zi hon nihin dohon-honsa mam enkam wëwek ta sone gwizimdinni kiye. Sap zen in dekam tawa da gwibirin, zen hwëna Musa mo tïtï tabin olak etan zën aha tïtï tabinsi mas-mas nul gwenan, zep tangan hëndep dohon-hon gwe-gwenan. Hwëna zëna hom desan ang ta gwenan. ");
INSERT INTO ury_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Zëno mae mo Alap hap de syala, zen hwëna kïtak zi dikim hlauludan en hap syal ta gwenan. Zen in zep hen Alap mo ola bare kertas dak-dakna zëre mae mo mirenak hen tahanak bubuk dasïk gwenan, hen bajuna zep blal-blalkam sïhïlhï da gwibirin– desa de alala ta gwen hapye. ");
INSERT INTO ury_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Zen zep tembane yawal-yawalak hen but srëm gol-golak ngeinnik de komal tum dawemnak de teinikirin hip ëdwam gwe-gwenan. ");
INSERT INTO ury_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Zen hen zi de tagal gwen maenak anakan de gubiridan hap ëdwam gwe-gwenan, ‘Dawem, bian guru.’ ");
INSERT INTO ury_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Hwëna emsa bap zen gubirida gwen ‘bian guru’kam. Sap eno mae mo Guru tanganna, Zen sap diki aha-en. Hen em diki aya-wal oso-wal makane lowehe gwenan. ");
INSERT INTO ury_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Bahem auhu-kamanak awe zini ‘bian’kam gubirida gwen. Sap eno mae mo Bianna aha-en– in Zen ngatan zi mo langnak gwë gwendaye. ");
INSERT INTO ury_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Hen bap zen emsa ‘teipsïn zi’kim gubirida gwen. Sap eno mae mo Teipsïnnï Zen aha-en. Israelsa de ngaya tabin hip de Zini Ëe an Zen. ");
INSERT INTO ury_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Hen zini men zen ebon mae onakon mam gwenna, zen diki zen gwë gwen– san de eno mae mo tana ïltïkïnnïk de babu gwe-gwen zi. ");
INSERT INTO ury_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sap tïngare zini men zen mam gwen hap ëdwam gwe-gwenan, Alap sa hwëna otde tangannak kang gulu. Hwëna men zen otde tangannak lowehe gwenan, desa hwëna gut de tangannak sa kang gul sera. ");
INSERT INTO ury_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Kwasang tol, Musa mo olsa de tawa ta gwibin hip de wenya hen Farisikam de gubirida gwen wenya, em ëngalap gwen! Em karekna mam naka esa hla kul. Em in ëk enkame Bian Alapsa ang ë gweblanan. Men zen sap Alap mo nwenak dikim ësam gwesïn hïp ëalp gwe-gwenan, hwëna eme zëbe mae hap orana layalsïk gwizimnin– ere mae mo aha tïtï tabin olsa de mas-mas gul gwizimdinkim. Ena mese sap orana dam lasïk, hwëna desan home ang ta gwenan. Hen men zen sap ang tan hap ëhohle gwe-gweꞌan, eme hwëna zëbe mae hap layalsïk gwizimnin. ");
INSERT INTO ury_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kwasang tol, Musa mo olsa de tawa ta gwibin hip de wenya hen Farisikam de wenya, em ëngalap gwen! Em in ëk enkame Alapsa ang ë gweblanan. Em ema anakan ëgwë gwenan: Ere mae mo hlïknak dep de zisi kwang guludan hap em ema men-san an-sankam ëhakalada gwenan– sap hi san, hen eik sin. Sap ebon mae osan de ang tan hap man sap baes ta gwenan. Hwëna zao de langanak aha-en aha-enkam hlauluda gwenkam, desa zebe hwëna dowal mo kïgï mo walas hap li la sone gwibirin. Zen zep hëndep zëno mae mo jal-jala ere mae onakon sërkam tangan taman kïnï gwenan. ");
INSERT INTO ury_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","22","“Kwasang tol, em in zene Musa mo ola tawa la gwibirinke, em ëngalap gwen! Em karekna mam naka esa hla kul. Em in nwe dïmïnnï, hwëna ema tim ul gwenan, ‘Ëe asa aha zisi dawem san dep olësek gwe-gwer.’ Em in zebe zisi anakan tïtï la gwibirin, ‘Nen sap esa nëre mae mo ol gu-gunsu anakan soson ul gwer, “Nglï, mese ki asa salblanda.”’ Hwëna Ëe ama emsa gubiridaꞌan: Bahem nglïsa, ahaksa ngatan zi mo langsa de gublun naban ere mae mo ola soson gul gwen. Sap Alap Zen dekon nësa kïtak ïrïk gïꞌïra. Hen kirekam de gunkum, zen apdenak– anakan de gun nubanye, ‘Alap, mese ki asa salblanda.’ Zep em de Alap mo bosesa de gollëwen hap nglï maesa kirekam gublunna, Alap dekon sa lamkam emsa anakare hap karek tala, ‘Em dekam ba habe Asa blikip gwesïblï srëm gweka.’ 21 Hen anakan bahem ëgu gwen, ‘Alap mo gol, mese ki asa salblanda,’ sap zen apdenak– anakan de gun nubanye, ‘Alap, mese ki asa salblanda.’ Sap zëre mo gola, Zen zao Zëna gwë gwenda. 16b Em zebe hen karekkam tawa la gwibirin, ‘Nëre mae mo olsa de soson gul gwen hap, bap nen anakan ëgu gwen, “Alap mo golak de emas, mese ki asa salblanda,” hwëna sap esa Alap mo gol ensa kirekam en gwibir.’ 17 Em in enlala joblo-topna hen nwe dïmïnnï! Em emaka dam ulsuk: Alap zëre mo nwenak bol-zaun tangan wenya diki zëre mo gol. Sap zini kim emassa Alap mo golak nonne gwenan, dekam man nwe-mase gwe-gwenan, ‘An Alap zëre en hap dena.’ 18 Anakan hen ema tawa la gwibirin, ‘Bap nen anakan ëgu gwen, “Alap hap de tweran nin ang gulsublun, mese ki asa salblanda,” hwëna sap esa Bian mo golak de kals ensa kirekam en gwibir.’ 19 Em in eiwa nwe dïmïn tanganna! Em emaka dam ulsuk: Bian zëre mo nwenak bol-zaun tangan wenya diki zëbe hap de kals. Sap tweran ninni insa de kalsnak iwe tru tasïn hïp kang ta senkam, zen dekam zep nwe-mase gwe-gwenan, ‘An Alap zëre en hap dena.’ 20 Zen in zep, zi de anakan zëre mo olsa soson gunnu, ‘Alap mo golak de kals, mese ki asa salblanda,’ zen apdenak– anakan de gun nubanye, ‘Alap mo kalsnak de tweran nin, mese ki asa salblanda.’ Hen zen apdenak– anakan de gun nubanye, ‘Alap, mese ki asa salblanda.’ Alap dekon sa lamkam emsa anakare hap karek tala, ‘Em dekam ba habe Asa blikip gwesïblï srëm gweka.’ ");
INSERT INTO ury_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kwasang tol, Musa mo olsa de tawa ta gwibin hip de wenya hen Farisikam de wenya, em ëngalap gwen! Em karekna mam naka esa hla kul. Em in ëk enkame Bian Alapsa ang ë gweblanan. Alap mo olak men zen tangan bol-zaun gwek, desa de syal gwibin hip em ema baes ta gwenan. Hwëna banakare Alap hap de syal bete-tek enna, desa en ema syal ei gwibirin. Zep em anakane ëgwë gwenan: Banakare nganak de obwaga betek maesa de gola danna– sap kumli ala maesa, em desa sap ema Bian Alap hap de hlïkna ol gweblanan. Hwëna Alap mo olak men zen tangan bol-zaun gwek, desa home syal ei gwibirin– anakare saye: Zisi bahem totoresa karek tan. Wal bosyansa em kwasang gwibirida gwen. Hen mensa anakan zi bosyansa gu-gublunna, ‘Ëe asa kirekam syal gwibir,’ desa em hëndep sul sonen. Zen diki bol-zaun tangan wenya zen– desa de nonol syal gwe-gwibin hip denaye. Hwëna syal bete-tekna insa lun em mas gul gwen. ");
INSERT INTO ury_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Em an nwe haïna, hwëna ema tim ul gwenan, ‘Ëe asa aha zisi dawem san dep olësek gwe-gwer.’ Eno mae mo syala in man nwe-mase gwe-gwenan– san de mok honak de aïlsïkan tok ing gwe henna kiye. Desa em ema eirsïk gwenan. Hwëna wanya yawal de zë ing gwe henkam, deban hwëna ema otde gwibirin. ");
INSERT INTO ury_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kwasang tol, Musa mo olsa de tawa ta gwibin hip de wenya hen Farisikam de wenya, em ëngalap gwen! Em in ëk enkame Alapsa ang ë gweblanan. Eno mae mo lowe henna a kirekam mo nwe-mase gweꞌanye: San de zi de piring-moksa ë-en nakon ngan tasïk gwibinni, hwëna olk san bëjen. Ere mae mo timni hen kirekam: Em sap ema tahan sopna ngan lasïk gwibirin, hwëna olk kon eno mae mo enhona mes beya gweka– kire-kire beya gwen hap de enlalakam, hen ere mae en mo timsi de ngalap gwe-gwibin hip de enlalakam. Em ema desa de hen ngan tasïn hïp baes taꞌan! ");
INSERT INTO ury_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisi zi nwe haï! Em nonol ere mae mo enhosa em olk san ngan tasibin. Dekam esa tangan tim niban enho naban ëngan gweher. ");
INSERT INTO ury_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kwasang tol, Musa mo olsa de tawa ta gwibin hip de wenya hen Farisikam de wenya, em ëngalap gwen! Em in ëk enkame Bian Alapsa ang ë gweblanan. Em in san de zi tok drë nwanun golsa de nwe awes tangankam taunnu kiye. Hwëna olk kon zi tok hanan ase nabarena zëwe. ");
INSERT INTO ury_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Zep em in hen kirena. Zi de emsa hlauludankam, em dawem-dawem tanganna. Hwëna enhonak kirekam-kirekam karek enlalasae ënne gwenan, zen in zebe zi tok ase karek makan ëju gweꞌan. ");
INSERT INTO ury_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","31","“Kwasang tol, Musa mo olsa de tawa ta gwibin hip de wenya hen Farisikam de wenya, em ëngalap gwen! Em in ëk enkame Alapsa ang ë gweblanan. Em in zi tamera gwen zi mo wei-wik gun walas! Eno auyan-azana Alap mo olsa de ayang gul gwizimdin hip de zini man damera gwek. Em hwëna angkam desa de lo tasïk gwibin golsae sam-sam la gwibir-zimꞌin, hen ëk enkame anakan ëgu gweꞌan, ‘Kwasang tol! Ëyë dekam hen lowe henanam, ëe molyë ëre mae mo auyan-azana insa mas eibiridananam– zen kim zi dawem-dawemna insa damera gwekye.’ Hwëna kirekam de ëgunkum, ema kim anakan ëkira gwe-gweꞌan, ‘Ëe an zen– zi tamera gwen zini in mo walas naye.’ ");
INSERT INTO ury_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kirekam de lwankam, ki amki ere mae mo auyan-aza mo zi tamera gwen syala insa ayang uk! ");
INSERT INTO ury_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Em jal-jal tanganna, zi tamera gwen zi mo wei-wik gun walas! Zep em toton banakan molye Alap mo jal hïl gïn nïkon ëasendak. ");
INSERT INTO ury_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Zep emki ësane gwen: Sap em kirekame ëre mo olsa de ayang gul gwen zisi lamera gwenan, Ëe in zep asa ebon mae osan dep etan ahakorena lup gul sone gwer. Enlala blal wenya hen ëre mo olsa de tawa ta gwibin hip de wenya, desa asa hen ebon mae osan dep lup gul sone gwer. Hwëna em esa hen desa lamera gwer, hen ahakorena esa te-lidak sonnak makan labirin gwer, hen ahakorena esa but srëm gol-golak langole gwibir, hen ahakorena ë-ë san esa olëgwa halada gwer. ");
INSERT INTO ury_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Zen in zep sa Alap angkam de zini ebe mae hap karekna sërkam golzimdi– kïtak de zëno ol ayang gul gwen zisi de tamera gwen hap de karekna, nonol lonesen nakon hëndep angkam dena. Nonol lonesen nakon kim Kaen Bak Habelsa karek gon srëmnak taka, dekon hëndep eno auyan-azana Alap mo ol ayang gul gwen hap de zini damera gwek, hëndep aumwa hap kim Berekia Bak mo tanena Zakaria Baksa dak. Zen Alapsa de aïrïblan srëmkam Alap hap de tweran nin ang gulsuk gweblan kals alpnak dak. ");
INSERT INTO ury_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Eiwa denakaë emsa gubiridaꞌan: Kïtak de zi tamera gwen karekna insa Alap mes lam gulku– dekam de otan ere mae hap ngëro gulzimdin hip! ");
INSERT INTO ury_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yerusalemk de zi, em mese Alap mo ol ayang gul gwen zini beyakam lamera gwek, hen Alap mo lup gul sonen zini kasokame tok hap ï lïbirida gwek. Ëe ama sap emsa kwasang gwibirida gwek, zebë sap emsa Ëre osan dep de tagal gulsun hup akabirida gwek– san de we ayang de tane-ne zemka sï alakam obon gun makan de gweibiridan hap. Hwëna em ema baes ta gwek. ");
INSERT INTO ury_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yerusalemk de zi, zen in zep Alap angkam emsa da tasibiꞌira. ");
INSERT INTO ury_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Zep angkam em molye etan Asa hla la gwek. Hwëna em kime lamkam Asa hut lu ane guꞌuk, zen dekam en esa Asa hla lal. Dekam hwëna anakare ola ban esa Asa hut lu ane gul, ‘Hëꞌho! An Bian mo bosekam nësa dikim oto gulsun hup hata seꞌara. Diki Alap Zen zëbe hap dawemsa golblan!’” ");
INSERT INTO ury_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesus kim Alap mo gola kon wet soka, ëe zëre hon de ang ta gwen wenya ki zebë ërtro kïnïk. Zao zebë enblaonk, “Alap mo gol yala an wehasa hom dawem tangankam dauk! Man tangan kwa nuk.” ");
INSERT INTO ury_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ki zep asa ding gulzimki, “Eiwa, emki gol yala ansa kara gun. Eiwa denakaë emsa gubiridaꞌan: Zëno kaso kong ta zahenna aha-en mae molya lwak. Zen tïngan tangan sa dri nulsul.” ");
INSERT INTO ury_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yerusalem kon kim wet soka, zaitun tra nabare kwatap teknak zep nikinꞌinka. Ëe zëre hon de ang ta gwen wenya ki zebë zë du këblahak– zao de ë-erenak anakan takensïblïn hap, “Asa en emki gubiridan: Alap mo gola insa dri yulsun hup gubiri, zen bawalkam sa ki lwal? Hen banakare owassa asa hla kul gwer?– dekam de anakan dam gulsun hupye, ‘Aumwa hap de yaklana, Em de lwa halzan hap dena, angkam man tangan golek de gweꞌan.’” ");
INSERT INTO ury_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesus ki zep asa ding gulzimki, “Salok-salokkam lowehe gwek. Emsa mana yasik da gwibirink. ");
INSERT INTO ury_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sap zini beya nik sa ebon mae onak anakan ëboton gwe-gwezal, ‘Ëe an Zen– Yesusye, emsa de ngaya tabin hip de Zi niye.’ Hëndep zen sa zini beya tangankam yasik da gwibir. ");
INSERT INTO ury_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Em anakare olsa esa ësane gwe-gwer, ‘Zëwe man ëeijaꞌan,’ hen anakan, ‘Awe hen sa ëeijazal,’ hwëna em dekam bahem ëaïrï gwen. Sap zen nonol kirekam sa Alap mo dwam gwibin sin lwa gwer. Hwëna dekam bahem ëkïl gïl gwen, ‘An aumwa hap denak mes zaul, zep ki lwaꞌan.’ ");
INSERT INTO ury_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Aha zi ausu nakorena aha zi ausu naban sa ëeija gwer, hen aha ïrïk gïnnï aha ïrïk gïn nïban sa ëeija gwer. Lang yala an san usak yala sa hatanda gwer, hen jïngïlï mam enkam sa taïlïda gwera. ");
INSERT INTO ury_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Zen kirekam sa karekna nonol lone sennak lwa gwer. Zen men kiye: We de jaha gwen hap eisbir anensa sëwehe kïnïnna. Zen dekon sa ki hëndep sang-sangna dohonse gwe song gwer. ");
INSERT INTO ury_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Emsa sa ahakon dahyo gwer, hëndep emsa sa karek da gwibir, hëndep emsa hen sa damera gwer. Tïngare langnak de zini sa emsa husus neibirida gwer, sap em an Asa de ang gwe-gweblan wenya. ");
INSERT INTO ury_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Dekam Asa de taïblïblan nakon beya nik sa etan lwan dahal gwer, hen zen sa hwëna nama de taïblïblan wenyaka husus neibirida gwer, hëndep tameran hap sa nolëgu gwer. ");
INSERT INTO ury_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Dekam yasik ta gwibin hip zini beya nik sa anakare ola ban yaïng gwe-gwezal, ‘Ëe an Alap mo olsaë ebe mae hap ayang gulzimꞌin.’ Hen zen zen sa boton san dep zini beyakam sïl dïbirhal gwer. ");
INSERT INTO ury_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dekam jal-jal enkam sa lowehe gwer, hëndep beya nik sa kwasang enlalana eititi neibir. ");
INSERT INTO ury_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Hwëna men zen de Asa de taïblïblannak tatem ëzauk gweꞌak, hëndep aumwa hap de yaklanak de zauꞌuk, zen zen sa ëngaya gwer. ");
INSERT INTO ury_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hwëna Alap Zën de ïrïk gïn hïp de ol dawemna insa kim de tïngare lang san nolhala daꞌak, tïngare zi ausu dikim ësane gwen hap, zen dekam tangan sa aumwa hap denak zaul. ");
INSERT INTO ury_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ëe ol tan-tanna ansaë ebe mae hap golzimꞌin: Em esa teipsïn zisi hla lal– Alapsa de lamang tan hap de karek yawalsa de Alap mo golak goltïl zïnnak, men kirekam orep Alap mo ol ayang gul gwen zini Daniel Bak gubiridakake. Zen dekam esa anakan tame ul, ‘Angkam aumwa hap de yaklanak man zauꞌun.’” Hwëna ëe, Matius, ama Yesus mo ola in hap emsa gubiridaꞌan: Em in zen bukuna ansa aha zi hip baca ul gwizimk, dawem enkam srip ulsuk gwizimk. Yesus dekon anakan ayang gulku, ");
INSERT INTO ury_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Dekam Yerusalem mo langnak de zini em kwatap san dep ëheya-hya gwek. ");
INSERT INTO ury_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Dekam zini men zen de gol homan nakon lowe heꞌak, zen bap zen etan gol mwa san ba maesa de gon hap bïtï gwehan. ");
INSERT INTO ury_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Hen nganak de syal tandan wenya, zen bap zen etan gol san dep lwan dahan– baju sal-sal maesa de teisyan hapye. ");
INSERT INTO ury_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kwasang tol, we walya u nubare wenya, hen nama de walassa momkam taïzï gwibin wenya. Zen tol banakan molya ëasendak. ");
INSERT INTO ury_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Zep Alapsa emki anakan abe ta gwen, ‘Karek yala in bap zen o dïl gwennak ahaksa Hari Sabatnak jowen.’ ");
INSERT INTO ury_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kirekam abe la gwek, sap Alap kim lang yawala ansa syal gwibirki, hëndep sërkam de karek yala an de jowenkam, kirekam de lang dohon-hon gwenna hom mae jowek. Hen zëno hyanak etan molya kirekam okamanak jowek. ");
INSERT INTO ury_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Hwëna sap Alap man zëre mo hlïl irin zisi kwasang gwibiridaka, Zen zep anakan hamal hap guku, ‘Karek yawala in bap zen tangan holo gwen. Ki hwëna zini kïtak tangan sa juwer.’ ");
INSERT INTO ury_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Dekam zi de anakan emsa gubiridanna, ‘Nësa de ngaya tabin hip de Zini men angkam awe gwëꞌara,’ ahaksa, ‘Zëwe gwëꞌara,’ em bahem taïblïbirida gwen. ");
INSERT INTO ury_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sap dekam yasik ta gwibin hip de zini beyakam sa yaïng gwe-gwer, hen zen owas-owasna sërkam de tenggwanbin tangan naka sa syal nei gwibir– anakan dikim emsa boton ta gwibin hip, ‘Ëe an Zen– emsa de ngaya tabin hip de Zi niye.’ Ahaksa anakan de emsa boton ta gwibin hip, ‘Ëe an Alap mo olsaë ep ayang gulzimꞌin.’ Zep hëndep Alap mo hlïl irin zini hen desa de taïblïbiridan hap sa hen ëalp gwesïl. ");
INSERT INTO ury_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Zen in zebë kirekam de lwan srëmnak hamal hap emsa tawa ta gubirin– em de desa enlala gwe-gwibin hip. ");
INSERT INTO ury_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Zep emsa de zi anakan gubirida gwenkam, ‘Nen ki hla tan. Zen zi ol srëm langna zëwe gwëꞌara,’ em bahem dekam desan sek gwe-gwen. Ahaksa anakan de emsa gubiridankam, ‘Zen awe aning gweꞌara,’ em bahem taïblïbirida gwen. ");
INSERT INTO ury_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sap ngatan zi mo lang nakore Zi Tanganna, ano hata zanna, kïtak ngatansa sa hla nulser– men kirekam nglï ang yala hla nulse gwenanke. ");
INSERT INTO ury_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Zep ano hatan hap dena, kïtak de zini sa dam nulsul– men kirekam hen hi agohe de ëwale gwezan hap dena dam nulsuk gwenanke.” ");
INSERT INTO ury_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Lang dohon-honna in kim de hya gwesïꞌïk, zen hëndep dekam sa ‘yakla nwena kawesïlï. Benna hen molya ngatan gwek. Hen keisni sa nglï nakon ëlan nahlala. Hen nglïnak de teipsïn-teipsïn dowla-dowala sërkam sa ëïlman gwe nasen gwer.’ ");
INSERT INTO ury_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Hëndep dekam zep sa tïngare langnak de zini nglïnak de owasna hla nulser– ngatan zi mo lang nakore Zi Tanganna Ënaka de enlala gweblan hap de tan-tanna. Dekam tïngare zi ausuna ngalap gosa sa tal– zen kim butnak Asa hla dase guꞌukye, Ëre mo soson naban ngatan yawala ban de ziati gwe zannak. ");
INSERT INTO ury_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Zen dekam sa sramin auku yawalsa nasalbir– Ëe kimë ëre mo dam taha nakore zini lup gul soneꞌak, zen de ëre mo hlïl irin zisi tïngan en tangan de tagal gulsun hupye, sap yakla hata sezan nakorena, hëndep nikin anen nakorena, hëndep eihya-lip eihya-lip nakorena.” ");
INSERT INTO ury_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Zep aumwa hap de yaklasa de dam gulsunnu, zen tenya dëren nakon de langsa dam gulsun makan. Em kime tenya dërenna anakan hla kul gwenan, ‘Man alsïk, hen angkam man etan ala gweꞌan,’ zen dekame anakan tame ul gwenan, ‘Angkam sasa gwen hap ki lwaꞌan.’ ");
INSERT INTO ury_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Zen hen kirekam: Tïngare kirekam-kirekam karek yala insa kime hla kul gweꞌak, zen dekam esa anakan dam ulsuk gwer, ‘Angkam Alap Zën de kïtak ïrïk gïlzïn hap denak man zauꞌun!’ ");
INSERT INTO ury_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Eiwa denakaë emsa gubiridaꞌan: Em an zene angkam okamanak lowe heꞌan, molye kïtak juwek, zen dekam sa ki tïngan lwal. ");
INSERT INTO ury_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nglï naban kama naban sa jek-jak nër. Hwëna ano ola, zen hëndep denaban sa lwa gwer.” ");
INSERT INTO ury_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","37","“Hwëna zini molya ngatan zi mo lang nakore Zi Tanganna ano lwa halzan hap dena anakan tame nuk, ‘Yaklana’ ahaksa ‘Jamna dekam sa hata zala.’ Alap mo dam taha nakore zini hen molya. Tane zem Aena hen homë tame guꞌun. Zen diki tawana Bian Zë-en. Sap ano lwa halzan hap dena, zen men kirekam orep lwak, Nuh Bak kim golëlowehe gwekake, zen kirekam sa etan lwal. ");
INSERT INTO ury_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sap dekam ho namwa yawala in kim hata srëm gweꞌak, zini dekam tembanekam ëmen-man gwenda gwek, hen we wal zi zënaka kap da gwek. Zen kire enkam ki mumukkum lowe henda gwek, hëndep yaklana in dekam Nuh Bak bul yawala iwe we wal walas zeban golësesek gwe seka. ");
INSERT INTO ury_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Hwëna ho namwa yala in kim mumuk ennak lup gulsuk kïnzïꞌak, dekam zep auna ëhlok, ‘Eiyë, an kirekam am lwaꞌan!’ Ëe de etan lwahal zannak zen kirekam sa hen auna ëhlol. ");
INSERT INTO ury_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dekam zi dare de nganak syal ëꞌanka, aha-en naka sa ëre mo dam taha nakore zini neir inehal. Hwëna aha tola zëwe sa hli dal. ");
INSERT INTO ury_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Hen we dare de lënsa aleꞌak, aha-en naka sa nul inehal, hwëna aha tola zëwe sa hli nul. ");
INSERT INTO ury_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Zep salok-salokkam Asa kara ë gweblak. Sap em molye anakan Asa tawa ëblak, ‘Ano mae mo Teipsïnnï dekam sa etan lwahal zala.’ ");
INSERT INTO ury_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Emki sap ëenlala gwen: Gol bi nik de anakan tawa gweꞌanam, ‘Ano golak sowë zini namen mo kam sa tïl zïla,’ zen dekam molya nini taꞌanam. Sowë zini in de tïlzïn srëm hap maka saleꞌara. ");
INSERT INTO ury_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Zen in zep, em hen kirekam salok-salokkam lowehe gwek, sap em home tame uꞌin– ngatan zi mo lang nakore Zi Tanganna Ëe de lwa halzan hap denaye. ");
INSERT INTO ury_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ano lwa halzan hap dena, zen mae makan: Teipsïn nik de holokam langa san song gweꞌanam. Zëre hon de babu gwe-gwen zini men zen de enlala blalkam gwëꞌanam hen taïblïblan nik, zen zëbe hap maka syala anakan wei yul sone gublu haꞌara, ‘Ano tim bwanak babu gwe-gwen bose omka em ïrïk gïl gwe. Zëbe mae hap tembanena hen sowe henkam gol gwizim.’ ");
INSERT INTO ury_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Teipsïn zini in de mumuk ennak lwahal zankam– zen de anakan hla taꞌan zanam, ‘Zen dawemkam ano tim bwanak ïrïk gïl gweka,’ ki zen sa zëbe hap isrip-sri gwibin nika golblala. ");
INSERT INTO ury_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Eiwa denakaë emsa gubiridaꞌan: Teipsïn zini in dekam sa zëno bosena esek gul seblala, hen zëre mo kire-kiresa de kïtak kara ta gwibin hip sa gublula. ");
INSERT INTO ury_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Hwëna zini in de enlala nik karek gweꞌanam, zen maka enlala gweꞌara, ‘Ano teipsïnnï in na-en molya lwahal zaka.’ ");
INSERT INTO ury_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Zen sa hwëna ahakore babu gwen bose zemka tangole gwibiri, hen teipsïn zini in mo te-alakam sa ho mamaksa otde gwibin soson zi bose zeban ziotdeblanda gwera hen golëtembane ta gwera. ");
INSERT INTO ury_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ki sa hwëna mumuk ennak babu gwe-gwen zi karekna in mo tame gun srëmnak teipsïn zini in hata zala. ");
INSERT INTO ury_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Dekam sa tok hap zïp so zala. Hen zëno angna dekam sa syauk blanak tak ta sera– men dekon ëk enkam de Biansa ang gwe-gweblan zi mo angna yusyustïn nïban gona ta gwenanke, hen sang-sang hap ëkna ngalk-ngalk da gwibirinke.” ");
INSERT INTO ury_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Zep Ëe kimë Alap Zën de ïrïk gïn hïp denaban golhataꞌanzak, zen gulk sun de ol blaoranna an kirekam sa lwal: San de sepulukam de kwalbasa de we oto gulblun hap de zisi pelita ngatan naban hut tu ane gun hup de ëhohle gwenna. Zen pelitana srën-srënkam deirensïk. ");
INSERT INTO ury_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Hwëna sepulukam de kwalbasana in, aha-ere taha-tapkam enlala joblo-topna, hen aha-ere taha-tapkam enlala blala. ");
INSERT INTO ury_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Sap enlala joblo-top wenya in, zen pelita dang ennak dena kim sek gwek. Tap gwennak de etan yuren hap dena hom kap dak. ");
INSERT INTO ury_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Enlala blal wenya in zen en man minyakna hen kap dak– pelita dangnak dinik de tap gwennak de etan yuren hap denaye. ");
INSERT INTO ury_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hwëna we oto gulblun hap de zini in na-en hom hata zaka. Kwalbasana in zen nësblak zep hëndep nwe-alk hap truwek. ");
INSERT INTO ury_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Hwëna ngïrïn tatem zep takeranna te sok, ‘Angkam man hataꞌara– we oto gulblun hap de zi niye! Haen, nen angkam hut tu ane gun.’ ");
INSERT INTO ury_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Sepulukam de kwalbasana in ki zep luk tak, hëndep pelita-pelita zemka ki zep ototo dabiꞌik, hen ki zep tom-tom dak. ");
INSERT INTO ury_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hwëna enlala joblo-top wenya in ki zep enlala blal wenya insa nenbiridak, ‘Abe mae hap em tol minyaksa betek enkam hlë-hle tazimdin, sap ano mae mo pelita-pelitana tïnsïn hïp ëalp gwesïꞌïn.’ ");
INSERT INTO ury_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Zen hwëna man ding nulzimk, ‘Bëjënë, ki hwëna ëre mae mo hen molya ësowehek. Amki toko san sek gwek– te-alakam de zë teyïsïn hïp.’ ");
INSERT INTO ury_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Hwëna enlala joblo-top wenya in kim toko san minyak teyïsïn hïp sek gweꞌak, we oto gulblun hap de zini in ki zep hata zaka. Enlala blal wenya in zen ëhohle gwek, desa en dekam zep we oto gulblun hap de zini in tembane yawala iwe dep golëbïtï gweka. Lïlïkïnnï hen dekam zep nayalsïkink. ");
INSERT INTO ury_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Enlala joblo-top wenya in kim etan yaïng gwezak, dekam zep sap ëtaken gweꞌak, ‘Bian, bian, abe mae hap em lïlïkïnsï talusuzimdin.’ ");
INSERT INTO ury_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Hwëna zen man ding gulzimki, ‘Eiwa denakaë emsa gubiridaꞌan: Ëe homë emsa tame tabiꞌin.’ ");
INSERT INTO ury_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Ëe in zebë hwëna emsa gubiridaꞌan: Salok-salokkam em lowehe gwen. Sap ngatan zi mo lang nakore Zi Tanganna ano etan de lwa halzan hap de yaklana em molye tawa ëblak.” ");
INSERT INTO ury_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Zep ano lwa halzan hap dena, zen hen gulk sun de ol blaoranna an kirekam sa lwal: Te-ala beya zini man aha lang san dep holokam de zë gwën hap song gweka. Nonol zëre hon de babu gwen zisi zep gu sonebiridaka– zëbe mae hap de zëre mo kire-kiresa hli tanda guzimhan hap, zen de dekam zëre mo timbwanak te-alasa mam tablan hap syal tan hap. ");
INSERT INTO ury_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Te-ala beya zini in hon men zen ëbabu gwek, zëbon mae onakon dan-ahan en anakan dam tasibirki, ‘An syal-syal tanganna zen,’ ahaksa, ‘An hen kire tola.’ Zen zep srën-srënkam zëbe mae hap kap ta guzim halka. Ahana kip emaskam de te-ala yuna aha-ere taha-tap enkam kap tablaka. Ahana kip yuna dan-dan teisyablaka. Hen ahana kip aha-ere yukam zerblaka. Zëna ki zep song gweka. ");
INSERT INTO ury_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“In zëbe hap emaskam de te-alana aha-ere taha-tapkam de yukam kap tablaka, zen hëndep dekam zep te-alana inkam kire-kiresa lirak ta gwibirki, hëndep dekam aha-ere taha-tap yukam zep etan mas soka. ");
INSERT INTO ury_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","In zëbe hap dare yukam hen teisyablaka, zen hen kirekam kim syal gweka, dekam etan dare yukam zep mas soka. ");
INSERT INTO ury_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Hwëna in zëbe hap aha-ere yukam zerblaka, zen kamasa hul gulku, zao zep te-alana insa aning taka. ");
INSERT INTO ury_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Lamkam kim zi yala in etan lwahal zaka, dekam zep etan te-alana insa de apdenak ziaïtblïn hap gu sonebiridaka. ");
INSERT INTO ury_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Aha-ere taha-tapkam de yukam men zëbe hap hli tablaka, zen ki zep sepulukam de yukam kap tabla zaka. Zao zep gubluka, ‘Bian, em sap aha-ere taha-tap yukame abe hap hli tablaka. Hwëna emki hla tan. Ëe kimë dekam syal gwe-gwek, etan yuna aha-ere taha-tapkamë mas sok.’ ");
INSERT INTO ury_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Zi yala in ki zep ding gulbluka, ‘In aïrïs tangan! Em an abon de babu gwen zini dawem tanganna hen taïblïblanna. Em mese betekkam de zerblanna insa dawemkam ïrïk taka, zep ëe asa etan ebe hap mam tangankam zerblal. Zep ano ïrïk gïlzïn hap de tembane yawalak awe emki tïlzïn– ano alp nakon de hen isrip-sri gwe-gwen hap.’ ");
INSERT INTO ury_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ki zep hen in zëbe hap dare yukam teisyablaka hen hata zaka. Ki zep gubluka, ‘Bian, em sap abe hap dare yukame hli soblaka. Hwëna emki sap aken. Ëe hwëna dekam dare yukamë etan mas sok.’ ");
INSERT INTO ury_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Zi yala in dekam zep ding gulbluka, ‘In aïrïs tangan! Em an abon de babu gwen zini dawem tanganna hen taïblïblanna. Em mese betekkam de zerblanna insa dawemkam ïrïk taka, zep ëe asa etan ebe hap mam tangankam zerblal. Zep ano ïrïk gïlzïn hap de tembane yawalak awe emki tïlzïn– ano alp nakon de hen isrip-sri gwe-gwen hap.’ ");
INSERT INTO ury_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ki zep hen men zëbe hap aha-ere yukam hli tablaka hen hata zaka. Ki zep gubluka, ‘Bian, ëe mesë emsa tame tak. Em in jal-jal enkame ïrïk gïl gwenda. Sap em in ere en mo eiyas gïn nïkore ei nika home tan gwenda, hwëna hen ebon de syal ta gwen wenyik mo irse gwen nakore nakae mamkam ere hap gulin gwenda. ");
INSERT INTO ury_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ëe zebë emsa aïrï gweblak, zebë eno te-alana kamanak lo tasïk. Te-alana in an dë.’ ");
INSERT INTO ury_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ki zep ding gulbluka, ‘Em in abon de babu gwen zini jal-jal tanganna hen asang tamna! Ema eiwakam asa anakan tame taka: Ëe homë ëre en mo eiyas gïn nukore ei nika tan gwenan, hwëna aha mo irse gwen nakore ei nikaë gulin gwenan. ");
INSERT INTO ury_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Em de kirekam asa tame tankam, ki emaka ano te-alana insa te-ala lam ta gwen golak drë neka– aen de etan lwahal zankam de dekon ap engka en mas gulblun hapye.’ ");
INSERT INTO ury_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Dekam zep ahakore babu zemka gubiridaka, ‘Emki zëbon onak de te-alana insa al tablan. Hwëna men zëno yuna dare taha-tapkam lwaꞌara, zëbe hap hwëna ërblak. ");
INSERT INTO ury_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sap zini men zen ano kap tablanna kim syal-syal gwenna, zëbe hap etan beya en tangankam asa kap ta gweblal– dekam de hëndep taha-taha gweblan hap. Hwëna men zen ano kap tablan naka asang gweblanna, men zen betek en maekam nama lwablaꞌanka, desa asa etan al tablal. ");
INSERT INTO ury_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Babu gwen zi karekna insa em lang kawesïn sïn dep hiri tan– zini men dekon yusyustïn nïban gona ta gwenanke, hen sang-sang hap ëkna ngalk-ngalk da gwibirinke.’” ");
INSERT INTO ury_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ngatan zi mo lang nakore Zi Tanganna Ëe de teipsïnkïm hata zankam, ëre mo dam taha nakore zini sa tïngan Asa ngïrïn da halzal, hëndep dekam Alap onakore ngatan nabare komal tumnak asa nikinzir. ");
INSERT INTO ury_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ëre mo dam taha nakore zini dekam sa tïngare langnak de zini ëre onak dep tagal nulsul. Ëe dekam asa hlïl– san de otweran zaho ta gwibin zi de zaho zemka hlïnnï kiye, kambingni srën de kang gun, dombana hen srën. ");
INSERT INTO ury_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Dekam dombakam de wenya asa ëre mo dam taha san de ëzaun hup gubiridal. Kambingkim de wenya, desa irgwa taha san de ëzaun hup asa gubiridal. ");
INSERT INTO ury_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ki asa hwëna dam taha san dekam de ëzaun wenya insa gubiridal, ‘Haen, nëre mae mo Bian dekakim zë dawemsa ebe mae hap golzimki. Dekam bïtï gwezak– ere mae hap de ëhamal tazimdinni awe dep, mensa orep okamana ansa de yang gulsun srëm nakon Bian ebe mae hap hamal tazimkike. ");
INSERT INTO ury_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sap Ëe kimë usak naban gwë gwek, eme tembanena ap ol gweblak. Kimë ho-hole gwe-gwek, eme ap hona ol gweblak. Ëe kimë aha lang nakon hata gwezak, eme Asa gola kon eirin gwek. ");
INSERT INTO ury_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ëe kimë irkan gwë gwek, eme abe hap pakeanna kap la gweblak. Hen Ëe kimë sang-sang gwe-gwek, eme Asa sam lasïk gwek. Hen bwinak kim Asa se dyain gwek, eme zë Asa du kë gweblak.’ ");
INSERT INTO ury_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Hwëna enlala dam-damkam de lowehe gwen zini in sa anakan Asa ding nulblir, ‘Bian, ëe bawalkamë usak naban Emsa hla lak?– in dekamë tembanena ebe hap olblakye. Hen bawalkamë ho-hole gwennak Emsa hla lak?– in dekamë hona ebe hap olblakye. ");
INSERT INTO ury_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Hen ëe bawalkamë Emsa aha langna kore zi mo kim hla lak?– in dekamë gola kon Emsa eirinkye. Hen Bian, ëe bawalkamë irkan Emsa hla lak?– in dekamë pakeanna ebe hap kap lablakye. ");
INSERT INTO ury_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Hen ëe bawalkamë Emsa sang-sang naban hla lak?– hen bwinak de se tya irinnikye, in dekamë Emsa du këblakye.’ ");
INSERT INTO ury_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ëe dekam asa hwëna ding gulzim, ‘Eiwa denakaë emsa gubiridaꞌan: Em kime kirekam syal ei gwibik, sap Asa de taïblïblan walas kwasap mae hap, zen dekam Asae mas ë gweblak.’ ");
INSERT INTO ury_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ëe dekam hwëna irgwa taha san dekam de ëzaun wenyaka asa gubiridal, ‘An kon em sek gwen. Em an zen– Alap onakore jalsa de hlaun hup de wenya. Tïnsïn srëm syauk bla yala wakuwe em bïtï gwen– mensa Alap dowal mo kïgï hap zëre mo taha trï so gweblan wenya ban dep hamal tazimkike. ");
INSERT INTO ury_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sap Ëe kimë usak naban gwë gwek, em home abe hap tembanena olblak. Hen Ëe kimë ho-hole naban gwë gwek, em home hona abe hap olblak. ");
INSERT INTO ury_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ëe kimë aha lang nakon hata gwezak, em home gola kon Asa eirink. Ëe kimë irkan gwë gwek, em home abe hap pakeanna kap lablak. Hen Ëe kimë sang-sang gwe-gwek, hen bwinak kim Asa se dyain gwek, em home dekam Asa mas ëblak.’ ");
INSERT INTO ury_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Zen sa hwëna Asa ding nulblir, ‘Bian, ëe bawalkamë usak naban emsa hla lak?– hen ho-hole gwennakye, hen aha lang nakon de hata zannak, hen irkan de gwënnak, hen sang-sang gwennak, ahaksa bwinak de gwënnakye, in dekamë Emsa mas ëbla srëm gwekye.’ ");
INSERT INTO ury_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Hwëna Ëe dekam asa ding gulzim, ‘Eiwa denakaë emsa gubiridaꞌan: Asa de taïblïblan walas kwasap maena men desae mas eibirida srëm gwe-gwek, zen dekam Asae mas ëbla srëm gwek.’ ");
INSERT INTO ury_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Zini in dekam sa syauk bla hï-hïtïnnïk bïtï gwer– hëndep denaban de zë lowehe gwen hapye. Hwëna enlala dam-dam enkam men zen lowehe gwek, zen zen sa hëndep de ëngaya gwen hap dena hla nul.” ");
INSERT INTO ury_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesus kim kirekam tawa tasibirki, ki zep zëre hon de ang ta gwen wenya insa gubiridaka, ");
INSERT INTO ury_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Em tawana: Angkam yaklana dan– yakla yala Paskanak depye. Ngatan zi mo lang nakore Zi Tanganna Asa dekam sa nërgul– te-lidak sonnak dikim Asa makan ta irin hipye.” ");
INSERT INTO ury_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hwëna Yesus in kim kirekam gubiridaka, dekam Alap mo golak de syal tan zi mo mam-mamna hen Yahudi mo nol-nola Alap mo golak de teipsïn tangan zini Kayafas Bak mo golak tagal gweꞌak. ");
INSERT INTO ury_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Zen Yesussu de sowëkam balk tan hap de olsa zë aha-en nuꞌik– dekam de tan hap. ");
INSERT INTO ury_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Hwëna zen man ëgu gweꞌak, “Yakla yalak awe bap nen balk tan, sap zini beya tangan nik dwam nëblaꞌan. Ki deban mae esa zë hwëna mamkam ëïlman gwer.” ");
INSERT INTO ury_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Yesus dekam zep Betaniak tembane tan hap Simon Bak mo golak asa golëbïtï gweka. Simon Bak in, men zen orep kusta gwekake. Hwëna wenya dekam Yesus hup de kwasangsa goltrëblan hap hatazak. Zep te-ala mamkam de gon minyak, sërkam de irase dawem nabarena, golhatazak. Yesus kim zë asa golëtembane taꞌanka, wenya in dekam zep minyakna inkam Yesussu nola kon hlë tablazak. ");
INSERT INTO ury_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ëe zëre hon de ang ta gwen wenya kimë kirekam wenya insa hla kuk, ëe dekam zebë jakal eibik, hen anakanë zë lonsubiꞌik, “Asya, zen ba hap kirekam tïngan tangan hlei yul soneblanan?! ");
INSERT INTO ury_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Dawemna diki minyakna in te-ala hap de lirak gulunam, te-alana mam tangan naka maka nëp zerzimnin. Desa emaka tahalha zi hip kae ë gwebla-zimꞌin.” ");
INSERT INTO ury_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesus hwëna mes ano mae mo ola insa salka, dekam zep asa gubiridaka, “Em ba habe wenya ansa lonsubiꞌin? Zen man tangan sam gwesïl– kirekam de Asa gwëblankamye. ");
INSERT INTO ury_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sap tahalha wenya em desa nama esa olëlowehe tine gwer. Hwëna Asa em molye dakal hap ërgwë gwek. ");
INSERT INTO ury_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Insa minyak irase dawemkam Asa hlë tablanan, zen hamal hap ki Asa gwëblanan– deban de kaso hulak Asa drë nwanun hap. ");
INSERT INTO ury_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Eiwa denakaë emsa gubiridaꞌan: Tïngare lang san kim Alap onakore ol dawemna nol halada gweꞌak, wenya ansa kirekam abe hap syal gwibir-blinan, desa hen sa aïsïl nei gwibir. Hëndep wenya ansa zep sa eititi neibir srëm gwer.” ");
INSERT INTO ury_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Dua-blaskam de wenya ano mae mo ahana, ëna Kariot walya Yudas Bak dekam zep Alap mo golak de syal tan zi mo mam-mam san dep song gweka, ");
INSERT INTO ury_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","zao zep gubiridaka, “Ëe de ebe mae hap zerguzimdinkim, em te-alana banakaꞌen esa abe hap ërblal?” Dekam zep te-ala kasona tiga-pulu enkam nërblak. ");
INSERT INTO ury_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Dekam zep hëndep Yudas Bak in orana tëblaꞌanka– Yesussu dikim sowëkam balk tan hap denaye. ");
INSERT INTO ury_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Dekam yakla yala Paskanak dep man golek de gweꞌak– Alap men dekam Mesir kon Israelsa gwis gwe sonekake. Paska yaklanak kim zauk, zen dekam zep hen ëkon gwesïk hanak– aha-ere minggukam de ragi srëmkam rotisa tru ta gwen naye. Dekam Yesus hon de ang ta gwen wenya ëe ki zebë anakan lakensïblïzak, “Bian, endawe esa Paskanak dep de tembanena aban mae zitwenblala?– ëe akakim zao hamal uk.” ");
INSERT INTO ury_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ki zep asa ding gulzimki, “Yerusalem walya, zëbon osan dep em sek gwen. Zao anakan enblak, ‘Bian Guru man emsa gublula, “Ano tïn hïp de yaklanak mes zaul. Ëe zebë dwam gweꞌan– eno golak de ëre hon de ang ta gwen wenya ban Paskanak dep de tembanesa zitwenblan hap.”’” ");
INSERT INTO ury_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ëe dekam zebë hëndep zëwe hamal ul guk. ");
INSERT INTO ury_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","21","Kim kawesïk, dekam kim Yesus asa golëtembane taꞌanka, zao zep asa gubiridaka, “Eiwa denakaë emsa gubiridaꞌan: Ebon mae onakon ahanik sa Asa zertrëra– zao de Asa balk tan hapye.” ");
INSERT INTO ury_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kirekam kimë asalblak, dekam zebë tangan enlalana ëdowe hanak. Ëe dekam zebë aha-en aha-enkam lakensïk gweblaꞌak, “Bian, san ha asa tol home yap ki gublunda?” ");
INSERT INTO ury_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ki zep ap ding gulzimki, “Nen an zene apdenak roti apna kolho honak os-os la ine gweꞌan, ahana sa Asa zertrëra– zao de Asa balk tan hapye. ");
INSERT INTO ury_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Men kirekam Alap mo olak ngatan zi mo lang nakore Zi Tanganna abe hap dena lwak, zen hëndep kirekam asa tïl. Hwëna kwasang tol, zini men zen Asa dikim zë balk tan hap zertrëꞌara, zen karekna mam tangan wenyaka sa Alap onakon hlaulu. Zen an zik de jaha gweblan srëmkam maka sam gwesïkï, sap dekam zen molya karekna mam tangan wenya insa goltoweꞌanam.” ");
INSERT INTO ury_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kariot walya Yudas in zen zertreizimdin hip ola ziaha-en gulku ki zep gubluka, “Guru, san ha asa tol home yap ki gublula?” Ki zep ding gulbluka, “Eno ola sap eiwa kirekam.” ");
INSERT INTO ury_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kimë tembane taꞌak, Yesus ki zep rotina ahanaka gul ineka, dekam zep dawemsa Alap hap rotina in hap golblaka, ki zep ahap gul guku. Desa zep abe mae hap anakare ola ban kap tazimki, “Em twenblandan. An ano timni.” ");
INSERT INTO ury_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ki zep hwëna anggur ho nabare mokna zer ineka, dekam zep etan Alap hap dawemna golblaka, ki zep hwëna abe mae hap anakare ola ban zerzimki, “Emki kïtak otdebin. ");
INSERT INTO ury_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Sap an ano kala zen. Zen sa ano tim nikon wet sol– Alap mo zi niban de ol ziaha-en gun ësesa dikim sul sonen hapye. Zep zini beya tangankam sa ano kala kon Alap mo nwenak ëdakastïl gwer. ");
INSERT INTO ury_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Eiwa denakaë emsa gubiridaꞌan: Ëe molyë na-en etan anakare anggur hona otdek. Hwëna ano Bian mo ïrïk gïnnïk kim de hataꞌak, zen diki dekam asa etan eban mae apdenak ziotdebir.” ");
INSERT INTO ury_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ki zebë hwëna Alap hap de tërya apdekam lak. Kimë lasïk, ki zep asa zaitun tra nabare kwatap tek san dep golësek gweka. ");
INSERT INTO ury_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Zao zep zëre hon de ang ta gwen wenya asa gubiridaka, “Em namen Asa de karek tannak hla tankam kïtak esa aïrïn hïp Asa hli la gukhal. Sap Alap mo olak man lwak, ‘Ëe asa zaho ta gwibin zini insa karek tal. Zaho zem dekam sa men-san an-sankam heya-hya gwer.’ ");
INSERT INTO ury_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Hwëna Bian kim de etan Asa ngaya taꞌanka, Ëe asa dekam emsa Galilea san dep ngeirbiridal.” ");
INSERT INTO ury_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Hwëna Petrus ki zep ding gulbluka, “Bian, ahakore wenya an sap sa Emsa hli dasïl. Aena tangan molyë Emsa hli tak!” ");
INSERT INTO ury_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesus ki zep ding gulbluka, “Eiwa denakaë emsa gubluꞌan: Namen nonol ayang de gun srëmnak, em dekam esa anakan de Asa zabeblanna dan-ahan soblala, ‘Zini in ëe homë tame taꞌan.’” ");
INSERT INTO ury_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petrus ki zep etan ding gulbluka, “Bian, ëe apdenak asa Eban lïl. Ëe molyë tangan Emsa zabeblak.” Ëe kïtak kirekam zebë sap ëgu anek. ");
INSERT INTO ury_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesus kim asa Getsemanik golëyaïng gweka, zao zep asa gubiridaka, “An zao teinikin guk. Ëe Alapsa ë-ere nakon gu soneblaꞌan.” ");
INSERT INTO ury_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Hwëna Petrus hen Zebedeus mo walas darena, desa en zep gubiridaka– zen de ang gweblan hap. Hwëna zao zep enlalana dowebla hanaka, hëndep hlik gwebla hanan hap alp gwesïblïka. ");
INSERT INTO ury_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Dekam zep zëre hon de dan-ahare ang ta gwen wenya insa gubiridaka, “Ano enlalana sërkam tangan dowe hananda, hëndep tïn hïbë alp gwesïꞌïn. Em awe Asa ërgwëk, hen enlala naban esa loweher– Alapsa de abe ta tinen naban.” ");
INSERT INTO ury_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Zëbon mae onakon kim engka en langa gwe halka, zao zep kamanak ïk gwe heka, dekon zep Alapsa gu soneblaka, “Bian, karek yawala ansa Ëe goltoweꞌan, diki Em Abon onakon langa gulsun. Hwëna ano dwam gwibin sin bap zen lwan. Diki ere mo dwam gwibin sin zen lwan.” ");
INSERT INTO ury_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kim Alapsa de abe ta gwenna hya gwesïkï, dekam zep etan dan-ahare zini in osan dep lwahal zaka. Hwëna ni truwennak zep hlauludaꞌan zaka. Petrussu zep zë gublu zaka, “Em san bëjen-em engka en mae Asa zersalen! ");
INSERT INTO ury_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Enlalakam lowehek. Alapsa e-en e-enkam abe la tinek. Kareknak ema altïlïnk. Sap eno mae mo enho enna dawemsa de sap syal gwibin hip dwam gwe-gwenda, hwëna eno mae mo timni in tatete naka hom.” ");
INSERT INTO ury_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Etan ki zep song gweka– dekon de etan Alapsa abe tan hap. Ki zep kon gu soneblaka, “Bian, Em san ha home ki dwam gweꞌara– karek yala ansa de Abon onakon langa gulsun hupye? Ki sap asa goltower. Hwëna diki ere mo dwam gwibin en san zen lwan.” ");
INSERT INTO ury_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kim hya gwesïkï, dekam etan ni truwennak zep hlauludaꞌan zaka. Sap zëno mae mo nwena man tangan nwe-alk hap ëdohon-hon gwek. ");
INSERT INTO ury_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Dekam hen ki zep etan dan-ahan naka hli yuludaka. Etan ki zep kire enkam Alapsa gu soneblaka. ");
INSERT INTO ury_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Etan kim lwahal zaka, dekam zep gubirida zaka, “Em san namae ni truwen hap ëdwam gwe tineꞌan? Emki sap ëkara gwen. Ngatan zi mo lang nakore Zi Tanganna Asa angkam man karek-karek gol gwen zi mo tahanak dep tapbla dazimꞌin. ");
INSERT INTO ury_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Dekam luk tak. Nen sek gwen. Emki hla tan. Asa de zergun hup de zini angkam man hataꞌara.” ");
INSERT INTO ury_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesus in kim nama tonꞌanka, dua-blaskam de zëre hon ang ta gwen wenya ano mae mo ahana Yudas Bak dekam zep zi beyam-bya naban golëyaïng gweꞌanka– nëbok te tek teiredan naban, mensa Alap mo golak de mam-mamna hen Yahudi mo nol-nola nenbiridakke, Yesussu de balk tan hap. ");
INSERT INTO ury_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zen mes anakan ola ziaha-en gulku, “Ëe kirekam asa ebe mae hap zertreizim: Men desaë babang taꞌak, zen zen– zini inye. Zen dekam zë hëndep balk lak.” ");
INSERT INTO ury_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yudas kim golëyaïng gweꞌan zaka, ki zep hëndep Yesussu babang tan naban gublu zaka, “Dawem, bian guru.” ");
INSERT INTO ury_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesus ki zep ding gulbluka, “Wal bosyan, men kire hap hatanan zala, angkam dekam syal gwibir.” Zi beyam-byana in hëndep dekam zep balk dazak. ");
INSERT INTO ury_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Hwëna ano mae mo wal bosena, men zenë ang ë gweblak, dekam zep nëbokna mol ineka. Dekam zep Alap mo golak de teipsïn tangan zi nik de babu gwe-gwen zini sap zïp soka. Hwëna ing ala en naka zep blansïblï kïnïka. ");
INSERT INTO ury_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Hwëna Yesus ki zep zëre hon de ang gwe-gwen zini insa jalse gweblaka, “Nëbokna insa em etan lïl sonen. Sap men nara nëboksa darak hap gwire danna, desa nëbokkam sa damera gwer. ");
INSERT INTO ury_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Emki ëenlala gwen: Ëe ëre mo Biansa abe taꞌanam, Zen maka zëre mo dam taha nakore jana zisi dua-blas batalyonkam lup gul soneꞌara. ");
INSERT INTO ury_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Hwëna kirekam de lwaꞌanam, ki hwëna mensa Alap mo olsa de ayang gul gwen zini abe hap dena ale nul gwek molya kirekam lwaꞌanam.” ");
INSERT INTO ury_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ki zep hwëna Yesus zi beyam-byana insa gubiridaka, “Em san Asa jal zisie hla lal?– zebe Asa de balk tan hap nëbok te tek teiredan naban yaïng gwenan zalye! Ëe men yakla jamkam Alap mo golak emsa tawa ta gwibik! Dekam ba habe zë Asa balk la srëm gwek? ");
INSERT INTO ury_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Hwëna an desae angkam syal eibiꞌin, zen men desa orep Alap mo ol ayang gul gwen zini abe hap dena ale nukke. Zao dikim zaun hube kirekam syal eibiꞌin. Ena hwëna home tame uꞌin.” Ëe zëre hon de ang ta gwen wenya dekam zebë kïtak heya-hya gwenkam hli lak. ");
INSERT INTO ury_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yesussu in zen balk dak, ki zep nërhak– Alap mo golak de teipsïn tangan zini Kayafas Bak mo golak dep. Zëwe Musa mo olsa de tawa ta gwibin wenya hen Yahudi mo nol-nola mes tagal gwesïk gïk. ");
INSERT INTO ury_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petrus zen lun sap-sap gwen dankam Yesussu ang gwebla song gweka, hëndep zen hen hata zaka– teipsïn tangan zini in mo gol tëmnak. Kol sonna iwe kim tïl zïka, zao zep teipsïn zini insa de kara ta gwen hap de jana nabare zini hlauludaꞌanka. Zao zep hen nikinꞌin zaka. Zen man anakan de tawa gweblan hap dwam gweꞌanka, “Banakan wëhë nëblaꞌak?” ");
INSERT INTO ury_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Alap mo golak de mam-mam wenya hen tïngare teipsïn sinodenak de wenya zen orasa dëblaꞌak– dekam de Yesus hup boton ol blo-blosa mam gulblun hap, dekam de tan hap. ");
INSERT INTO ury_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Beya nik blo-blo tan ola ban sap nolluwe gweꞌak, hwëna zëno mae mo ola in hom mae apde nëk, zep bëjen dekon karek tan. Aumwa hap zep etan zi darena anakan olluweka, ");
INSERT INTO ury_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Zini an man guku, ‘Ëe asa Alap mo gol yawala ansa dri yulsul, hwëna yaklana dan-ahan ki asa hwëna owas hap etan syal gwibinkim sul soner.’” ");
INSERT INTO ury_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Alap mo golak de teipsïn tangan zini in ki zep luweka, ki zep Yesussu gubluka, “Em san ha molye mae ding gulzimki?– insa eno karekna kira nul gweꞌan zalye.” ");
INSERT INTO ury_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesus hwëna balk enkam salsïblïka. Ki zep etan gubluka, “Ngaya Zini Alap mo bose gubin niban emki asa gubiridan: Em san ha eiwa Zen tangan?– Alap mo Tanena, Israelsa de ngaya tabin hip de Zi niye.” ");
INSERT INTO ury_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesus ki zep ding gulbluka, “In kirekame gunda, zen kirekamke. Hwëna Ëe hen ama emsa gubiridaꞌan: Em esa nabakam ngatan zi mo lang nakore Zi Tanganna Asa hla laser– Teipsïn Zini Alap mo dam taha nakon de nikirinnik. Hen dekon kimë etan lwa haꞌanzak butnak esa Asa hla laser.” ");
INSERT INTO ury_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Alap mo golak de teipsïn tangan zini in, kirekam de gunnuk kim salblaka, dekam zep baju ala son zemka Yesus hup de u sïsngïn hïp kalk-kalk soka, deban zep guku, “Zen Alapsa lamang tanda. Nen ba hap de etan zëno kareksa de kira gulblun hap zini teibiridan hap? Nën mes em-am kïtak Alapsa de lamang tannak asalblanan! ");
INSERT INTO ury_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Zep angkam ebon mae onakon banakan?” Ki zep ding nulblik, “An tok hap de karek tan hap man sam gwesïꞌïra!” ");
INSERT INTO ury_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dekam zep oltepkam nwe-masenak hol-hol da gweꞌak, hen deban zep dangole gweꞌak. Ahakon taha dak-dakkam itranak lek dya gweꞌak, ");
INSERT INTO ury_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","deban dakensïk gweblaꞌak, “Em wëhë tame tanda? Nara emsa lek tyanda? Eme eiwa Alap mo zer sonen zi gwëꞌanam– Israelsa de ngaya tabin hip, ki emaka asa gubirida gweꞌara, ‘Zi bosena zen asa lek tyanda.’” ");
INSERT INTO ury_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","In kim kirekam lwa seꞌak, Petrus dekam gol tëmnak nikinꞌinka. Zëwe de babu gwe-gwen wenya ki zep zë hataꞌanzak, zao zep Petrussu gubluzak, “Em an hen zenke– men zen Galilea walya Yesus mae han apdenak ëtë gwekye.” ");
INSERT INTO ury_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Petrus hwëna man zabeka– in zen zë lowe heꞌak, zëno mae mo inik. Zep wenya insa anakan ding gulbirki, “Ëe homë tame guꞌun– insa em gundaye.” ");
INSERT INTO ury_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Dekon hwëna kol son lïlïkïn alpnak zep zauꞌun naka. Zëwe zep etan ahanik zëwe de babu gwe-gwen wenya hla tazak. Dekam zep zëwe in zen lowe heꞌak desa gubiridak, “Zini an hen menkam Nazaret walya Yesus hun apdekam ë gweka.” ");
INSERT INTO ury_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petrus ki zep etan ding gulbirki, “Ëe eiwa hom tanganë zini insa tame taꞌan. Nglïnak de Zini, mese asa salblanda.” ");
INSERT INTO ury_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Zëwe hom holo gweꞌak, dekam zep zini men zen zë ëzauꞌuk etan Petrussu nenblazak, “Em an hen zëno mae mo ahanakake, sap eno ola in Galilea wal mo ol hanu.” ");
INSERT INTO ury_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petrus dekam zep ol drakkam gu ane gweꞌanka, “Ëe hom tangan am zini insa tame tak. Nglïnak de Zini Alap, mese ki asa salblanda!” Kirekam kim gu gweꞌanka, ayangna ahana hen dekam zep gu aneka. ");
INSERT INTO ury_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Hwëna Petrus dekam zep enlala gwibirki– Yesus mo ola mensa anakan gu-gublukaye, “Ayang de gun srëmnak, em dan-ahan sonkam esa Asa zabeblala.” Dekam zep hëndep wet soka. Gosa zep kon yusyustïn nïban gwë song gweka. ");
INSERT INTO ury_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kak tangannak zep tïngare Alap mo golak de syal tan zi mo mam-mamna hen Yahudi mo nol-nola ban etan tagal gwesïk, hen dekam zep ola Yesussu de tan hap dena zïm-zïm nïk. ");
INSERT INTO ury_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Dekam zep tahalen naka Roma mo bosekam de gubernor gwen zini Pilatus Bak osan dep nërhak. ");
INSERT INTO ury_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudas in zen zerguku, kim anakan sane gweka, “Hare ano zergun nukon sa dal,” dekam zep tangan enlalana dowebla hanaka. Dekam zep 30kam de te-ala kasona men dekam zerguzimki, desa Alap mo golak de mam-mam wenya kip hen Yahudi mo nol-nola kip etan zerzim halka. ");
INSERT INTO ury_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Zao zep gubiridaka, “Ëe mesë karek gwek– karek gon srëm zini insa zergukye. Zep hëndep daꞌan.” Hwëna zen man ding nulblik, “Asa ba habe desa etan gubiridala? Zen ere en mo syal sake.” ");
INSERT INTO ury_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudas dekam zep te-alana insa Alap mo gol mwa san dep hiri ta inki. Zëna ki zep song gweka, dekam zep zënaka tenya kon holenak buk tusuk soneka. ");
INSERT INTO ury_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Alap mo golak de syal tan zi mo mam-mamna in ki zep te-alana insa tagal dasïk, ki zep ëguk, “Te-alana an, zisi de tan hap zergun te-ala, zep bëjen Alap hap ing tablan. Sap Musa mo tïtï tabin olak man anakan lwak, ‘Kire te-alasa bëjen Alap hap zerblan.’” ");
INSERT INTO ury_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Zen kim te-alana in hap ola aha-en nuk, dekam zep te-alana inkam kama ngatdarak syal gwe-gwibin zi mo ngana nëk– aha lang nakon de yaïng gwe-gwezan zi tok-toksa de zë kang gulne gwen hap. ");
INSERT INTO ury_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","In zep hëndep angkam kamana insa nen gwibirin, “Zi Kal Kama.” ");
INSERT INTO ury_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Zen dekam zep zauk– mensa orep Yermia Bak hamal hap Alap mo ola anakan ayang gulkuye, “Zen sa 30kam de te-ala kasosa nulin– Israel zi zëre mae mo ol aha-en gun sun de zergun te-alana in saye. ");
INSERT INTO ury_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Dekam sa hwëna kama ngatdarak syal gwe-gwibin zi mo ngasa nër– men kirekam Alap hamal hap asa gublukake.” ");
INSERT INTO ury_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Roma mo bosekam de gubernor gwen zini Pilatus Bak onak kim nërhatazak, zao zep takensïblïka, “Em an san ha eiwa zen– Yahudi mo teipsïn nïye?” Ki zep ding gulbluka, “In kirekame gunda, zen kirekamke.” ");
INSERT INTO ury_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Hwëna Alap mo golak de syal tan zi mo mam-mamna hen Yahudi mo nol-nola in dekam zep Yesus mo karekna Pilatus hup kira nul gweblaꞌak, hwëna Yesus hom mae ding gul gwizimꞌinka. ");
INSERT INTO ury_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Dekam zep Pilatus takensïblïka, “Em san ini hom?– zebe ding gul gwizim srëm gweꞌaraye. Zëno mae mo eno kareksa de kira gul gweblanna mes-am beya gwenan.” ");
INSERT INTO ury_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Hwëna Yesus man tangan ding gulzimdin hip baes gweka. Hëndep Pilatus man tangan tenggwanblaka. ");
INSERT INTO ury_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Yakla yala Paska jamkam kim Israelk de zini ëtagal gwe-gwek, dekam man zëno mae mo gubernora bwinak de zini aha-en aha-enkam nëser sone gwizimk– tïngare zi tra mo anakan de gun sun, “Desa ap zeser sonezim.” ");
INSERT INTO ury_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Dekam zëwe bwinak zini ki, bose teipsïblïnna, Roma mo ïrïk gïn nïkon dikim wet so gwen hap de asas gwe-gwen zi, bosena Barabas Bak. Zëno aha bosena hen ki Yesus mo bose naban apdenak. ");
INSERT INTO ury_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Zep zi beyam-byana in kim Pilatus mo gol homannak tagal gwesïzïk, dekam zep Pilatus takensibiridaka, “Em narasae namen dwam ëblaꞌan?– desa de ëe ebe mae hap tapbla tazimdin hipye. San ha Barabas Baksa? San ha Yesussu?– mensa hen nen gweblananke, Israelsa de ngaya tabin hip de Zini.” ");
INSERT INTO ury_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Zen mae hap ki kirekam takensibiridaka: Sap zen mes anakan tame gulku, “Zi beyam-byana man Yesussu menkam ang në gweblak, zep Yahudi mo mam-mamna husus në gweblak, hëndep zep angkam tan hap asas nëblaꞌan.” ");
INSERT INTO ury_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatus dekam teipsïn zi hip de komal tum yalak nikinꞌinka– zisi dekon klis gul gwen hap de komal tumnak. Zi beyana insa kim kirekam takensibiridaka, hwëna dekam zep we zik mo ola nolhatablazak. We zem man anakan gu soneblak, “Em bahem mas gwen– karek gon srëm zini insa de karek tannakye, sap ëe eisiri namen husus gwibin tangan nakaë tal– zëbe hap denaye.” ");
INSERT INTO ury_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Hwëna Pilatus kim we zik mo ola insa sane gweꞌanka, hwëna dekam Alap mo golak de mam-mam wenya hen Yahudi mo nol-nola in zi beyam-byana insa nolëton gweꞌak– zen de anakan abe ta gwen hap, “Barabassa ap hïl tï sonezim. Yesussu lak.” ");
INSERT INTO ury_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Zep kim Pilatus etan takensibiridaka, “Zi darena an kon, em narasae dwam ëblaꞌan?– desa de ebe mae hap zeser sonezimdin hipye.” Dekam zep ding nulblik, “Barabassa.” ");
INSERT INTO ury_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Hwëna dekam zep etan takensibiridaka, “Ki hwëna ëe banakan asa Yesussu gwëblal?– insa ahakon ena en gweblananye, ‘Israelsa de ngaya tabin hip de Zi’kim.” Ki zep ding nulblik, “Desa te-lidak sonnak makan laink.” ");
INSERT INTO ury_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Dekam zep hwëna takensibiridaka, “Hwëna zen banakan karek gweka?” Hwëna dekam tangan zep mam en tangankam ëgu ane gweꞌak, “Desa te-lidak sonnak makan laink!” ");
INSERT INTO ury_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatus dekam zep enlalana anakan topse gwibiridaꞌanka, “Ëe an etan banakan asa zi trana ansa gweibiridal?” Hen anakan tame tabirki, “Zen ëïlman gwen hap ëalp gwesïꞌïn.” Dekam zep zëre hon de ëbabu gwe-gwen zisi gubiridaka– hosa de golbla halzan hap. Zao zep zi beyam-byana in mo nwenak tahana ngan sosuꞌunka. Dekon zep gubiridaka, “Ëe homë zini ansa de tan hap de ola mas guꞌun. Alap molya zëno kala abe hap ngëro gulbluka. Sap an e-ene laꞌan.” ");
INSERT INTO ury_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Dekam zep tïngare zi beyam-byana in ding nulblik, “Zëno kala zen sap sa abon mae onak ngëro gwer– hen ano mae mo auyan-aza onakye.” ");
INSERT INTO ury_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dekam zep Pilatus Barabassa zeser sonezimki. Hwëna Yesussu zep jana nabare zi hip tapbla tazimki– zen de hwëna tangolen naka te-lidak sonnak makan ta irin hip. ");
INSERT INTO ury_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Dekam zep Pilatus mo jana nabare zini Yesussu nërtïlzïk– zëre mae mo batalyonnak de gol yalak. Zen zëre mae mo ahakorena kïtak de tagal gulsun hup nenbiridak, hëndep Yesussu man dot dasïzïk. ");
INSERT INTO ury_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ki zep hëndep irkare dak, hwëna teipsïn zi hip de baju kwang kal-kalsa zep ala nosoblak– teipsïn zi makan zau de swrë tan hap. ");
INSERT INTO ury_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Hen nolak de ala gulblun hap, dokot të ngï-ngïsa mlin-mlin nuk– teipsïn zi hip de emaskam weir gulsublun makan. Ki zep hen dutena dam tahanak nolblak. Zëna dekam zep botonkam zëno nwenak boklena kom da gweblaꞌanzak– anakan dikim zë lamang tan hap, “Dawem, bian. Em in zen– Yahudi mo teipsïn nïye.” ");
INSERT INTO ury_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Zao zep oltepkam hol-hol da gweꞌak, hen dutena insa zëno tahanak etan nulink, dekam zep nolak lek dya gweꞌak. ");
INSERT INTO ury_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Lamang tanna kim hya neisïblïk, dekam zep etan baju kal-kala insa nalsïblïk, dekam zep etan zëre mo bajuna ala nosoblak. Ki zep hwëna nërwet sok– dekam de te-lidak sonnak makan ta irin hip. ");
INSERT INTO ury_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","In kim Yesussu te-lidak sonnak de makan ta irin hip nërsong gweꞌak, oranak Kirene walya Simonsa zep nërtoweꞌak. Zao zep Yesus hup de te-lidak soblanna insa de wë soblahan hap tik-tik dak. ");
INSERT INTO ury_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ki zep hëndep kwatap tek bosena Golgotak yaïng gwesek. Bosena in mo enlalana, “zi nol swra.” ");
INSERT INTO ury_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Zëwe zep Yesus hup anggur ho enenna nolblak– desa de otden hap. Hwëna kim sap akasibirki, dekam zep baes gwibirki. ");
INSERT INTO ury_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Te-lidak sonnak kim makan daink, dekam zep zëno pakeanna zëre mae hap dobe abu mo kim de zënaka dam tasïk gwibinkim kae nëblandak. ");
INSERT INTO ury_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Zëna zao zep teinikinꞌik– dekon de kara tan hap. ");
INSERT INTO ury_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nol bol tahan nakon ol alesa zë makan nulink– dekam de tïngare zi anakan tame gun hup, “Zen kire jal hap daꞌan.” Zep anakan ale nuk, “An Yesus– Yahudi mo teipsïnnï.” ");
INSERT INTO ury_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Zen sowë zi dare naban Yesus mae han apdekam te-lidak sonnak makan dabirink– ahana Yesus mo dam taha san dekam, ahana irgwa taha san dekam. ");
INSERT INTO ury_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Zini men zen desan taman gwe-gweꞌanzak, zen nol ëwak gun nuban ol mamkam anakan lamang da kïnï nasen gweꞌak, ");
INSERT INTO ury_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Em an zen eme guku, ‘Alap mo gola asa dri yulsul, hwëna dan-ahare yaklakam asa etan syal gwibin kim sul soner.’ Ki em san Alap mo Tanesa hom?! Te-lidak sonna in kon em enaka de ngaya tan hap ati gwezan.” ");
INSERT INTO ury_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hen Alap mo golak de syal ta gwen zi mo mam-mam wenya hen Musa mo olsa de tawa ta gwibin hip de wenya hen Yahudi mo nol-nolkam de wenya, zen hen man Yesussu anakan lamang da gweꞌak, ");
INSERT INTO ury_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Zen aha zi ensa man ngaya ta gwibirki, hwëna zënaka hom tol ngaya taꞌara! Zen de eiwa Israel mo teipsïnkïm gwëꞌanam, dikire te-lidak sonna in kon ati gwezak. Ki amaka laïblïblaꞌan. ");
INSERT INTO ury_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Zen Alapsa taïblïblaka hen man zënaka gu gweblaka, ‘Ëe an Alap mo Tane.’ Ki Alap de eiwa dwam gweblankam, dikire ngaya tak.” ");
INSERT INTO ury_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sowë zi darena insa Yesus mae han makan dabirink, zen hen kirekam lamang laka. ");
INSERT INTO ury_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yaklana kim bolak zauku, dekam zep tïngare langna owas hap kawesïk. Hëndep yakla nwena kim dan-ahannak zauku, dekam zep etan hleng gwek. ");
INSERT INTO ury_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yesus dekam zep Ibrani olkam ol mamkam hërheka, “Eli, Eli, lama sabakhtani?” Nëre mae mo olkam Zen anakan hërheka, “Are ano Alap, ano Alap, Em ba habe Asa da tasïꞌïra?” ");
INSERT INTO ury_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hwëna in zen zë kara daꞌak, ahakon hom dawemkam nasalblak, zep zënaka nenbiridak, “In Elia Baksa hërheblanda.” ");
INSERT INTO ury_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Dekam zep ahanik nabalba enkam hluweka, yera jaubum makare naka zep gol hanaka, desa zep anggur ho enennak os gul ineka. Desa zep te tek gwënnak de kyaon sonen naka mipnak goltrë seblaka– desa de kwlem gun hup. ");
INSERT INTO ury_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Hwëna ahakon man nenblak, “Dikire gwëk. Elia Bak wëhë yap ngaya taꞌan zaka?” ");
INSERT INTO ury_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesus ki zep etan ol mamkam hërhe hanaka. Dekam zep hëndep tïlsïkï. ");
INSERT INTO ury_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Alap mo gol mwanak de kaen lïlïkïn glaïng-glïng yawala dekam zep owas hap kalk neisïk sonek. Jïngïl yawala hen dekam zep gwëka. Hen zëwe de kaso nabare kwatap-tek kwatap-tekna ahakon hëndep man ëhlang-hlang gwek. ");
INSERT INTO ury_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Zi tok-tok kang gulne gwen kaso lïlïkïnnï man ëtalusundak, hen Alap mo hlïl irin wenya men zen orep juwe gwek man beyakam ëngaya gwendak. ");
INSERT INTO ury_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesus kim tïn nïkon ngaya gweka, dekam zep zen hen zi lo tasibin kamana in kon sek gwek, hëndep dekam zep Yerusalemk bïtï gwezak. Zëwe zini beya nik nolëtowe gweꞌak. ");
INSERT INTO ury_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jana nabare zi mo mamna in zen apdenak zëre mo ahakore naban zikara taꞌanka, dekam tangan zep sërkam golëaïrïꞌanka– jïngïl yala in kim gwëka, hen tïngare owas-owasna insa kim hla nukke. Dekam zep ëguk, “Zini an eiwa Alap mo Tane!” ");
INSERT INTO ury_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","We walya hen beya nik langa nakon kara daꞌak. Zen men zen hëndep Galilea kon mas gwe-gweblan hap ang nëbla song gwe zakke. ");
INSERT INTO ury_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ahana Yakobus ne Yusup nik mo anena Maria– men zen hen zëno nik mo ayana Yesussu wë takke, ahana bose apde zem Magdala kore wenya Maria, hen ahana Zebedeus Bak mo we. ");
INSERT INTO ury_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kim kam-en gweꞌak, dekam zep te-ala beya zini Arimatea walya Yusup hata zaka. Zen hen Yesussu de ang gwe-gweblanna. ");
INSERT INTO ury_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Zen dekam zep Pilatus Bak osan dep song gweka– Yesus mo tok naka dikim lo tasïn hïp de abe tan hap. Pilatus dekam zep jana nabare zisi gubiridaka– Yesus mo tok naka de Yusup hup zergublun hap. ");
INSERT INTO ury_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusup dekam zep hëndep Yesus mo tokna insa zizeryahe halka. Kaen ëse ngap-ngapkam zep zitahaleka. ");
INSERT INTO ury_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Dekam zep Yusup zëre hap de hamal gulblun kaso hulak Yesus mo tokna insa zidrë neka. Lïlïkïnnï kaso yawalkam zep nulhlusukink. Zëna ki zep sek gwek. ");
INSERT INTO ury_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","In kim Yusup golësyal taꞌanka, Magdala kore wenya Maria apde bose zem Maria han dekam zao hen inikinꞌik. Dangna kim kaso hula in san ëk. ");
INSERT INTO ury_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Zao de yaklana dekam Hari Sabat yawal– Paska hap de yakla tangannak. Dekam zep Alap mo golak de syal ta gwen zi mo mam-mamna hen Farisikam de zi niban apdekam Pilatus osan dep sek gwek. ");
INSERT INTO ury_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Zao zep nenblak, “Bian, ëe ama ëenlala gwer, zisi de yasik ta gwibin zini Yesus in kim nama gwëꞌanka, zen man anakan gu gweka, ‘Yaklana kim de dan-ahannak zauꞌuk, dekam asa etan tïn nïkon ngaya gwer.’ ");
INSERT INTO ury_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Zen in zebë emsa abe laꞌan: Emki ere mo jana nabare zisi gubiridan– zen deka dawem enkam kara nuk, in zao ir lo dasïkke. Zëre hon de ang ta gwen wenyik mana zëno tok naka sowëkam nër halank. Hwëna zen dekam sa zisi ahap da gwibir, ‘Zen mes etan ngaya gweka.’ Hwëna kirekam de ëboton gwenkam, zen dekam tangan sa botonna mam nulsuk song gwer.” ");
INSERT INTO ury_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatus ki zep ding gulzimki, “Jana nabare zini ansa ama ebe mae hap lup gulzimꞌin. Emki desan dep zon guludan– dawem en tangankam deka kara nuk.” ");
INSERT INTO ury_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Desan kim sek gwek, dawemkam zep Yesussu de drënen kaso lïlïkïnnï insa sip dabik. Jana zini in zëwe zep kara nul gweꞌak– zi de zëwe mae ëgolek de gwezan srëm hap. ");
INSERT INTO ury_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Hari Sabat hyanak, kak tangannak zep we darena song ëk– Magdala kore wenya Maria bose apde zem Maria han, Yesussu de drënen kaso hula insa de etan hla kun hip. ");
INSERT INTO ury_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Hwëna Alap mo dam taha nakore zini kim ngatan zi mo lang nakon ati gwe zaka, jïngïl yala dekam zep hëndep gwëka. Hwëna dam taha nakore zini in zep drënen kaso lïlïkïnnï insa irhi gul zuka. Zëna hwëna zao zep nikin aneꞌanka. ");
INSERT INTO ury_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Zëno nwe-masena san de nglï angna kiye, hen zëno bajuna ngap-ngap tanganna– but ngap-ngapna kiye. ");
INSERT INTO ury_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jana nabare zini in zen kaso hula insa kara nuꞌik, karekkam aïrïn hïp ëyal-yal gwek, hëndep tok-tok makan zep zë altïnk. ");
INSERT INTO ury_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hwëna Alap mo dam taha nakore zini in ki zep wenya insa guzimki, “Bahem aïrïn. Em an Yesussue lëblaꞌan zala– te-lidak sonnak insa makan da inkke. ");
INSERT INTO ury_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Zen awe hom. Bian Alap mes tïn nïkon ngaya tala– men kirekam Yesus Zëna hamal hap emsa gubirida guk gwekake. Haen, emki sap hla kulzin– men zao sap nën nekke. ");
INSERT INTO ury_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nabakam emki olahan. Zëbon de ang ta gwen wenya anakan enbirida, ‘Zen mes ngaya gwera. Angkam Zen mes emsa Galilea san dep ngeirbiridala. Em zao esa ërtower.’ In sya. Asa Alap zer sone zala– ebe mae hap de kirekam ayang gulzimdin hip.” ");
INSERT INTO ury_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dekam zep we darena in nabalba enkam olahak. Zen man sap aïrïꞌak, hwëna dawemkam hen isrip-sri ëꞌak. Hlu kënkam zep song ëꞌak– dekam de nabakam Yesus zëre hon de ang ta gwen wenya insa enbiridan hap. ");
INSERT INTO ury_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Hwëna kim song ëꞌak, zao zep mumuk ennak Yesus Zënaka zertreizimki. Zen kim anakan guzimki, “Dawem,” dekam zep hëndep golek de lazak. Zao zep hëndep bokle kom osoblan naban tanana babang osoblazak, deban isrip-sri ëblaꞌak. ");
INSERT INTO ury_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Hwëna man guzimki, “Bahem aïrïn. Hwëna ano oso walkam de gubirida gwen wenyaka em anakan enbiridan– zen deka Galilea san sek gwek. Zen zao sa Asa nërtower.” ");
INSERT INTO ury_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","We darena in kim song ëꞌak, hwëna jana nabare zini in zen drënen kaso hula insa kara nuꞌik, zëbon mae onakon ahakore nik zep lwan dahak– zen de Alap mo golak de syal tan zi mo mam-mamna insa gubiridan hap, kïtak in zen ki zë jowekke. ");
INSERT INTO ury_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Alap mo golak de mam-mam wenya in dekam zep Yahudi mo nol-nola ban ola aha-en nuk– dekam de jana nabare zini in hap te-alasa mam enkam zerzimdin hip. ");
INSERT INTO ury_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Zao zep nenbiridak, “Em anakan ëgu gwek: ‘Zen zëre hon de ang ta gwen wenyik Yesus mo tokna sowëkam nërhak– ëe kimë truwe guk hakke.’ ");
INSERT INTO ury_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hwëna gubernor de emsa ni truwenkam salbirdankam, zen ëe asa deban dawem enkam ëraïsïl gwer– emsa de kire hap karek tabin srëm hapye.” ");
INSERT INTO ury_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Hëndep jana nabare zini in zep Yesus mo ngaya gwen ola insa dikim ber-ber gun hup de te-alana insa neirink. Hëndep Yahudi zini anakare olsa zep nol halasenk, “Zen eiwa zëre hon de ang ta gwen wenyik kam sowëkam nërhak.” Hëndep angkam mae kirekam zep ëgu gwenan. ");
INSERT INTO ury_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Seblaskam de zëre hon de ang ta gwen wenya ëe dekam zebë Galileak de kwatapna in san dep sek gwek– men kirekam Yesus Zëna asa gubirida gwekake. ");
INSERT INTO ury_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Zao kimë Yesussu hla laꞌak, zao zebë bokle kom tablan naban isrip-sri ëblak. Hwëna abon mae onakon aha korenak anakare enlala hatazimki, “An san ha auna?” ");
INSERT INTO ury_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Hwëna Yesus dekam zep asa golek de tabir zika, zao zep asa gubiridaka, “Tïngare sosonna ngatan zi mo langnak dena hen auhu-kamanak dena, Bian mes abe hap kïtak tapbla gulbluka. ");
INSERT INTO ury_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Zen in zep tïngare lang san em sek gwen, zëwe kïtak de zi ausuna Asa de ang gweblan hap tïtï labir song gwek, deban baptis la gwibik– ëre mo Bian mo bosekam, Tane zem ano bosekam, hen Alap mo Enho mo bosekam. ");
INSERT INTO ury_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Men desaë emsa desan de ang tan hap tïtï ta gwibik, em hen desan de kïtak ang tan hap tawa la gwibik. Hen emki ansa enlala gwe-gwibin: Aena asa emsa yakla jamkam kara tabirida gwer– hëndep aumwa hap de yaklanak de zauꞌuk.”");
INSERT INTO ury_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ol Dawemna an Alap mo Tanena Kristus Yesus hup dena. ");
INSERT INTO ury_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Zëno ausuna, men kirekam Alap mo ol ayang gul gwen zini Yesaya Bak Alap mo ola orep ale gulkuke. Zen mae hap denaka ale gulku: Alap kim Tane zemka hamal hap anakan gu-gublukake, “Ëe asa Emsa de ngeir gublun hap zisi zer soner– zen de nonol ëre mo olsa ayang gul gwizimdin hip, ebe hap dikim orasa sal ta gublun hap. ");
INSERT INTO ury_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Zi zer sonenna in, zen zi srëm lang nakon sa anakan taken gwera, ‘Haen, nëre mae mo Teipsïn Zi hip nen orasa hamal ta gublun! Hen nen dam-dam ta gublun!’” ");
INSERT INTO ury_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yesaya in kirekam ale gulku, kirekam zep ki hëndep holo gwesïk hannak Alap mo zer sonen zini in zi srëm langnak hata zaka. Zëno bosena Yohanis. Zen zëwe zini baptis ta gwibirki, hen anakan tïtï ta gwibirki, “Ere mae mo karek-karek nakon em ëhalen. Alap dekam sa eno mae mo karek-karekna tap gulsuzimdi. Em dikim enaka anakan golëtrë gwen hap, ‘Ëe ama angkam Alapsa ang gweblaꞌan,’ ëe ki asa hwëna emsa baptis tabir.” ");
INSERT INTO ury_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Dekam zini beya tangaran nik Yohanis onak dep tïngare Yerusalem mo lang nakon weyana Yordan san dep sek gwe-gwek. Zëwe zep zëre mae mo kirekam karek-karekna damnak ëkira-kla gwe-gwek. Ki zep hwëna baptis ta gwibirki. ");
INSERT INTO ury_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanis in Alap mo ol ayang gul gwen zini Elia Bak mo kim hen gwë gweka, zep unta ala nakore bajuna zëno kim hen ala so gweka. Takna hen Elia mo kim tweran sopkam denaka daul gweka. Tembanena hen zëno kim tembane gwe-gweka, zep ëkasna twenblanda gweka, hen sobwal hona otde gweka. ");
INSERT INTO ury_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Zen hen man zë anakan tonbirida gweka, “Ano lure nakon sa ahana hata zala– abon onakon de Teipsïn Tangan Zi niye. Ëe dawem naka hom– Zëbon onak de babu gwen hap, hen sap zëno tana maesa de ngan sosublun hapye. ");
INSERT INTO ury_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ëe weyakamë emsa baptis ta gwibiꞌin. Zen hwëna Alap mo Enhokam sa emsa baptis ta gwibiri.” ");
INSERT INTO ury_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Zao kim lwa seꞌak, Yesus hen dekam zep Galilea mo langna Nazaret kon hata zaka. Desa hen dekam zep Yohanis weyana Yordankam baptis taka. ");
INSERT INTO ury_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ho nakon kim etan zïl heꞌan zaka, ki zep gulk sun ake seka. Nglïna dekam zep hëndep hlang në hanak. Alap mo Enhona dekam zep hen mawana ohola mo kim Yesus onak dep ati gwe ine zaka. ");
INSERT INTO ury_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ki zep hwëna Alap mo ola ësalsek, “Em in ëre mo Tane– ëre mo dang tïnïnak de tanganna. Ëe ama tangan Emsa sam gwesïk gweblanan.” ");
INSERT INTO ury_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Alap mo Enhona dekam zep hëndep Yesussu zi srëm lang san dep zersong gweka. ");
INSERT INTO ury_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Orapna empat-pulu enkam zë zë-en gwë gweka, hwëna dowal mo kïgïna zao zep akasïk gwebla zaka. Langna iwe hen kirekam-kirekam otweran jal-jala beya tanganna. Hwëna Alap mo dam taha nakore zi zë mas në gweblak. ");
INSERT INTO ury_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohanissi kim bwinak tak daink, Yesus dekam zep langna Galilea san song gweka. Desan zep Alap onakore ol dawemkam tonbirida song gweka. ");
INSERT INTO ury_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Zen man gubirida gweka, “Alap Zën de ïrïk gïn hïp dena mensa kara ei gwibik angkam mes hatal! Zen angkam man kon gwesïk hanaꞌara– teipsïnkïm de nësa ïrïk gïnkïmye! Zep ere mae mo karek-karek nakon em ëhalen, hen Alap onakore ol dawemna ansa em taïblïbin.” ");
INSERT INTO ury_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesus kim Ho Gutuna Galilea mo alp san song gweka, zao zep hogwe tahyo gwen zi darena akeꞌanka– Simon Baksa oso zem Andreas han. Jalakam hogwesa lahyoꞌanka. ");
INSERT INTO ury_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus ki zep zë guzim zika, “Asa em ang ëblan. Ëe asa emsa zisi de hwëna lahyo gwen hap tawa sol.” ");
INSERT INTO ury_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Dekam zep hëndep jalana insa hli koso guk halka– Yesussu dikim hwëna ang ëblan hap. ");
INSERT INTO ury_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Dekon kim deban engka en zisong gweꞌanka, zao zep etan zi darena akeꞌanka– Zebedeus mo walas darena, Yakobus ne Yohanis neka. Bul mwanak zëre nik mo jalasa sam ososuꞌunka. ");
INSERT INTO ury_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesus zao zep hen desa kirekam guzim zika. Zen hen dekam zep Yesussu de ang ëblan hap bi zem Zebedeussu bul mwanak hli laka– hëndep zëbon de te-ala hap syal ta gwen zi niban. ");
INSERT INTO ury_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesus ki zep zëre hon de ang ta gwen wenya ban Kapernaumk golëyaïng gweka. Hari Sabatnak kim hatak, dekam zëwe de but srëm golak zep golëbïtï gweka. Dekam Zen zep kïtak tawa tabirki. ");
INSERT INTO ury_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","In desa tawa tabiꞌinka, man tangan denggwanblaꞌak. Sap zëno ola soson tanganna– san de teipsïn zi mo tawa tabinni kiye. Musa mo olsa de tawa ta gwibin hip de zi mo tawa tabin niban apdenak hom. ");
INSERT INTO ury_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hwëna dowal mo bi gweblan zini ki zep hen zë tïl zïka, zao zep hërhe zaka, ");
INSERT INTO ury_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Wëo, Nazaret walya Yesus! Em aban mae ba olsa de ëtoran hap? Em san asa de tameran habe hata zala? Ëe mesë emsa tame tal! Em in Alap mo zer sonen Zi Lalakna.” ");
INSERT INTO ury_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesus ki zep zëbon de dowala insa jala ban gubluka, “Balkkam! Zini in kon em wet son!” ");
INSERT INTO ury_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Hwëna dowala in ki zep zini insa nonol mam en tangankam tïtïkïn taka, ki zep hwëna mam enkam de hërhen naban zini in kon wet soka. ");
INSERT INTO ury_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tïngare zini sërkam tangan denggwanblak, zep zënaka anakan donbirida nasenꞌak, “Ha! Zëno ola wehasa hom! Orep hom– kirekam de tawa tabin niye. Zëno ola soson tanganna– san de teipsïn zi mo ola kiye. Zëno dowal-dowalsa de golëalsa sonenna, hëndep dekam de wet so gwenkam!” ");
INSERT INTO ury_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hëndep dekam zep nabakam Yesus hup de ola tïngare Galilea mo lang san nol haladak. ");
INSERT INTO ury_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesus kim zëre hon de nonol ang ta gwen wenya in han but srëm gola in kon golëwet so gweꞌanka, ki zep hëndep Simon ne Andreas nik mo golak golëbïtï gweka. Yakobus ne Yohanis ne hen man ang ëka. ");
INSERT INTO ury_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Yesus in kim golëbïtï gwe zaka, ki zep zë nenblak, “Simon mo we marena ewen naban tumnak nisi taꞌan.” ");
INSERT INTO ury_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ki zep hëndep desan dep song gwe zaka, ki zep Simon mo marena insa taha nakon gul ineka. Ewenna in kon dekam zep hëndep sër gwek. Wenya in dekam zep hen tembanekam mas gwibiridak. ");
INSERT INTO ury_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Yaklana kim dum gwe heꞌanka, dekam zep Yesus onak dep tïngare kirekam-kirekam zi sang-sangna nolëyaïng gwezak, hen dowal mo tïlbiridan mae naka. ");
INSERT INTO ury_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ëna iwe de zini tïngan tangan zep Simon mo gol sïnak tagal gwesïk. ");
INSERT INTO ury_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Zao zep kirekam-kirekam sang-sang nabare zi beyam-byana insa dawem tabirki, hen dowal-dowala beya naka zeralsa sonebirki. Zen man dowal-dowala insa zen de olsa ëtoran hap jalse gwibiridaka, sap dowal-dowala in mes tame dak. ");
INSERT INTO ury_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kaꞌankam hom tangan lïtïꞌïk, Yesus dekam zep luweka, hëndep ki zep gola kon zi srëm san dep song gweka. Dekon zep Biansa gu soneblaka. ");
INSERT INTO ury_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Hwëna kim nohwensïblïk, Simon Bak dekam zep wal bose wal zeban lun zitëbla song gweka. ");
INSERT INTO ury_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kim zihla taka, zao zep nenblak, “Haen. Tïngare zini man emsa dëblaꞌan.” ");
INSERT INTO ury_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Hwëna man ding gulzimki, “Bëjen. Nen hëndep langna an mo aha ë-ë san dep sek gwe song gwen. Sap Ëe an kire habë hatazak– desan de hen Alap mo olsa tawa tabir song gwen hap.” ");
INSERT INTO ury_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Zen in zep Yesus tïngare Galilea mo lang san ziamjanbir song gweka– desan de hen zëwe de Yahudi mo but srëm gol-gol san tawa tabir song gwen hap. Zen dekam hen dowal-dowalsa zeralsa sone gwibirki. ");
INSERT INTO ury_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Dekam zep hen sop sang-sang karek mo hla tan zini Yesus onak dep hata zaka, zao zep zëno nwenak boklena kom so zaka. Dekon zep abe ta seka, “Eme dwam gweꞌanam, Em emaka asa dawem taꞌara.” ");
INSERT INTO ury_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus hwëna man tangan zini insa dawemkam embwan gweblaka. Dekam zep towanblan naban ding gulbluka, “Ëe ama dwam gweꞌan. Em dawem gwen.” ");
INSERT INTO ury_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Dekam zep hëndep sop sang-sang karekna in hli tak. ");
INSERT INTO ury_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesus ki zep ol drakkam anakan gubluka, “Dekam song gwe. ");
INSERT INTO ury_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Insa emsa dawem tanan, bahem mae ahasa tonbiridan. Diki nonol Alap mo golak de syal tan zi hip ahana kip enaka zertrëbla. Zao gublu, ‘Emki asa hla tan. Ëe san ha mesë dawem gwer?’ Musa Bak mo tïtï tabin olak men kirekam sop sang-sang karek zi de dawem gwennak dep dena lwakke, zen kirekam em syal gwibin. Zen dekam sa tïngan emsa anakan tame dal, ‘Zen eiwa mes tangan dawem gweka.’” ");
INSERT INTO ury_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Hwëna zini in man men-san an-sankam tonbirida song gweka. Yesus zep hëndep langna iwe de ë-ënak damkam hata srëm gweka. Eiknik zep zi srëm langnak zëre hon de ang tan wenya ban golëgwë gweka. Hwëna zini man zë tïngare ë-ë nakon Zëbon onak dep yaïng gwe-gwezak. ");
INSERT INTO ury_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Zao hom tangan holo gweꞌak, Yesus ki zep Kapernaum sun dep lwa halka. Dekam zep hëndep ola anakan nol haladak, “Yesus mes etan hatanda.” ");
INSERT INTO ury_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Zi beyam-byana dekam zep Zëbon onak dep tagal gwesïzïk, hëndep man kyang gwesïk. Lïlïkïn mae san ëzaundak. Yesus zao zep Alap mo olkam tawa tabirki. ");
INSERT INTO ury_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","In kim tonbiridaꞌanka, dan-nër dan-nërkam de zini dekam zep taha-tana teisya ine gwen srëm zi sang-sangna Yesus onak dep neiren halzak. ");
INSERT INTO ury_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Hwëna zëwe zini beya tangan nik zë lowe heꞌak, zep Yesussu ba nakon dep?– golek de tan naye. Zep hëndep gola insa gulk kon dre dasïk anehak– men dekon en Yesus gwëꞌankake. Desan zep berya ban nër dwanuk. ");
INSERT INTO ury_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesus kim anakan tame tabirki, “Eiwa, zen man tangan Asa daïblïblaꞌan,” dekam zep zi sang-sangna insa gubluka, “Tane tol, eno karek-karekna mesë ep tap gulsublunan.” ");
INSERT INTO ury_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Musa mo tïtï tabin olsa de tawa ta gwibin wenya men zen zë teinikinꞌik, dekam zep enlala ennak donsubluꞌak, ");
INSERT INTO ury_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Zini an zëno ola bolte-bolte tanganna! Zen bap kirekam Alapsa lamang tanda! Zi bëjen zi bose zik mo karek-karekna tap gulsublun. Diki Bian Alap bap.” ");
INSERT INTO ury_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesus hwëna dekam zep hëndep zëno mae mo enlalana insa tame tazimki, dekam zep jalse gwibiridaka, “Em bap kirekam enlala ennak Asa lonsubluꞌan! ");
INSERT INTO ury_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Em ema ano ola husus eibir– anakan insa gublulye, ‘Eno karek-karekna mesë ep tap gulsublunan.’ Hwëna anakan de gublunkam, ‘Em luwen. Ere mo berya insa teisyahal,’ san esa hen etan husus eibir? Sap ol-gun darena in apdenak– Alap mo sosonkam de gublun ol. ");
INSERT INTO ury_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Hwëna angkam Ëe ama ebe mae hap goltreizimꞌin– em dikim Asa anakan tame tan hap, ‘Alap mes ki ngatan zi mo lang nakore Zi Tanganna abe hap sosonna golblaka– okamanak awe dikim zi mo karek-kareksa tap gulsuk gwizimdin hip denaye.’” Ki zep hwëna etan zi sang-sangna insa gubluka, ");
INSERT INTO ury_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ëe ama emsa gubluꞌan: Em luwen. Ere mo berya insa teisya, ki gol san song gwe.” ");
INSERT INTO ury_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dekam zep hëndep luweka, ki zep hëndep ber zem insa teisyaka, ki zep hëndep tïngare zi mo nwenak song gweka. Zi trana in man tangan ëtenggwank. Dekam zep Alap mo bosena teip nulsuk gweblaꞌak, hen man ëgu gweꞌak, “Hom tangane kirekam de owasna hla kuk– an kirekam lwananye!” ");
INSERT INTO ury_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesus kim etan Ho Gutuna Galilea mo alp san dep lwa haꞌan zaka, zi beyam-byana zao zep Zëbon onak dep yaïng gwezak. Zao zep tawa tabirki. ");
INSERT INTO ury_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Dekon kim song gweꞌanka, dekam zep Roma mo ïrïk gïnnïk dep de pajak te-ala alal ta gwizimdin hip de zini Alpeus mo tanena Lewi Baksa hla taꞌanka. Zen zëre mo syal gwe-gwen teksonnak nikinꞌinka. Zao zep gublu zaka, “Haen. Asa em ang gweblan.” Lewi dekam zep luweka, dekam zep hëndep ang gweblaka. ");
INSERT INTO ury_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesus kim Lewi mo golak golëtembane taꞌanka, dekam zep hen ahakore pajak te-ala alal tanda gwen wenya beyakam yaïng gwezak. Hen ahakore karek-karek gulin halasen gwen wenya, zen hen beyakam yaïng gwezak. Dekam kirekam de enlala karek-karek nabare zini Yesussu beya nik sap ang në gweblaꞌak. Deban mae zep apdekam golëtembane taꞌanka, hen zëre hon de ang ta gwen wenya ban. ");
INSERT INTO ury_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Hwëna Musa mo tïtï tabin olsa de tawa ta gwibin wenya men zen hen Farisi hon bïtï gwek, zen kim anakan hla nulidak, “Yesus Roma hap de pajak te-ala alal ta gwizimdin zi niban apdenak golëtembane taꞌara, hen ahakore karek-karek gulin halasen gwen wenya ban,” zen dekam zep husus nëblaꞌak. Dekam zep zëre hon de ang ta gwen wenyaka nenbiridak, “Yesus in ba hap tangan pajak te-ala alal tanda gwen wenya ban apdenak golëtembane taꞌara, hen karek-karek gulin halasen gwen zi nibanye! Zen in kwae nabanke!” ");
INSERT INTO ury_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus kim kirekam salbiridaka ki zep ding gulzimki, “Zini, sang-sang srëm wenya, zen hom doktersa dwam në gweblanan. Zen diki zi sang-sang en dwam në gweblanan. Ëe an dokter makanë hatazak– zi enlala karek-kareksa de dawem san dep kwang guludan hap. Hwëna men zen zënaka tim di gwibirin, ‘Ëe an dawem-dawemna,’ Ëe desa de kwang guludan hap homë hatazak.” ");
INSERT INTO ury_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Aha yaklanak kim zauk, baptis ta gwibin zini Yohanis hon de ang ta gwen wenya man tembanesa ëlwak– men kirekam Yahudi zi mo auyan-azana ëgwë gwekke, Alapsa dikim enlala zon tasïblïnkam abe ta gwen hap. Hen Farisikam de gubirida gwen wenya dekam zep hen kire hap ëlwak. Ki zep hwëna zini Yesussu dakensïblïzak, “Yohanis hon de ang ta gwen wenya hen Farisikam de gubirida gwen wenya, zen man tembanena ëlwa gwenan, hwëna ebon de ang ta gwen wenya ba hap ëlwa srëm gwe-gwenan?” ");
INSERT INTO ury_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesus ki zep ding gulzimki, “Abon de ang ta gwen wenya kip man dakastïlzimꞌin– an kirekam tembanesa de ëlwan srëmkam lowehe gweꞌanye. Sap zen angkam teipsïn zisi de zergwën makan Asa nërgwë gweꞌan. Zep Ëe kimë nama golëlowehe gweꞌan, zen bëjen tembanesa ëlwan. ");
INSERT INTO ury_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Hwëna jal zini kim de Asa jek-jak daꞌak, Abon de ang ta gwen wenya yaklana dekam molya tembane tak. Embwan hap sa baes tal.” ");
INSERT INTO ury_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Etan ki zep kire hap gulk sun de ol blaonzimdinni dan mas sozimki, “Zep hen kirekam, zi mo baju kwang de hul nënkam, zen bëjen deyol sop ësekam makan tazimdin. Kirekam bëjen dakastïn. Sap ngan sosunkum deyol ësena in de yok gweꞌak, dekam sa baju ëpba hula in mam enkam etan kalk nër. ");
INSERT INTO ury_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hen kirekam, anggur ho ësesa bëjen kambing sopkam de botol ëpbanak yuren. Kirekam hom dakastïꞌïn. Sap anggur ho ësesa de kambing sop botol ëpbanak yurenkam, anggur hona in kim de nopna taïl gïꞌïk, kambing sopkam de botola in dekam sa kalk nër. Hëndep anggur ho naban kambing sop botola ban sa karek nër. Anggur ho ësena zen diki kambing sop botol ësenak de yurenkam dakastïꞌïn. Zep hen kirekam, Abon de ang ta gwen wenyik de etan ëpba lowehen san abarenak ang tan hap hom dakastïꞌïn.” ");
INSERT INTO ury_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Aha Hari Sabatnak kim zauk– Israelk de zi mo syal tan srëm yaklanak, Yesus ki zep zëre hon de ang ta gwen wenya ban gandum tra san golëtaman gweꞌanka. Hwëna zëre hon de ang ta gwen wenya dekam zep usak hap gandum danna insa kïlk dï-in kïnï gweꞌak. ");
INSERT INTO ury_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Hwëna Farisikam de gubirida gwen wenya kim hla nulidak, dekam zep Yesussu nenblak, “Em san home ere hon de ang ta gwen wenya insa hlauludaꞌara? Zen in nëre mae mo tïtï tabin olsa ngip nuꞌin– kirekam de Hari Sabatnak syal gwibinkimye.” ");
INSERT INTO ury_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesus ki zep hwëna ding gulzimki, “Em bawalkam esa Alap mo ola an mo eini dam ulsul?– men kim Daud Bak zëre hon de ang ta gwen wenya ban golëusak gweꞌankaye. ");
INSERT INTO ury_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abayatar Bak men dekam Alap mo golak teipsïnkïm ïrïk gïlkïke, Daud Bak dekam Alap mo golak tïlkï, zao zep Abayatar Baksa abe taka– Alap hap de roti loneblanna insa de golblan hap. Kim golblaka, desa zep zëre hon de ang ta gwen wenya ban zitwinbir song gweka. Hwëna sap nëno mae mo tïtï tabin olak man lwak: Sap Daud zëna hen zëbon de ang ta gwen wenya, zen bëjen Alap hap de rotina insa twinbin. Zen diki Alap mo golak de syal ta gwen zi en dwin gwibirin. Sap eiwa kirekam, hwëna Daud hom Alap mo nwenak karek gweka– zen kim usak hap zitwinbirkiye. Zep hen kirekam, Abon de ang ta gwen wenya an, zen kim usak hap kïlk dï-in kïnzïl, zen hom ëkarek gwer.” ");
INSERT INTO ury_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesus ki zep Hari Sabat hap dena insa waulsuzimki, “Alap zini Hari Sabatsa de blikip gwibin hip hom yang tabirki. Alap mo nwenak bol-zaun tanganna, zen diki zi. Hari Sabatna in hwëna zini emsa dikim oto tasïk gwibin hip mas gulzimki. ");
INSERT INTO ury_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Zep ngatan zi mo lang nakore Zi Tanganna, Ëe an Zen tangan– Hari Sabat mo Nolaye. Zep anakarekam de klis gul gwizimdin hip dena, ‘Desa sap esa Hari Sabatnak syal eibir,’ ahaksa, ‘Kirekam bahem,’ zen ano dena.” ");
INSERT INTO ury_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesus kim zëre hon de ang ta gwen wenya ban etan but srëm golak golëbïtï gwe zaka, hwëna zini hen zao gwëꞌanka. Aha tahana mes sak gweblaka. ");
INSERT INTO ury_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Hwëna Yesus mo kareksa de hlaulblun hap de zini hen zëwe lowe heꞌak. Zep kara daꞌak, “Zen wëhë nëno mae mo syal tan srëm yaklana an hap dena ngip guꞌunka– zisi de dawem tankamye?” ");
INSERT INTO ury_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesus ki zep taha sak zini insa gubluka, “Haen, ano mae mo dang gwënna a dekon emki zauzun.” ");
INSERT INTO ury_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ki zep hwëna takensibiridaka, “Musa mo tïtï tabin olak, nen basa de Hari Sabatkam gol gwen? Hari Sabatkam san ha nen kareksa zi hip gol gwizimdin? San ha dawemsa nen gol gwizimdin? Hari Sabatkam san ha nen zisi ngaya ta gwibin? San ha nen tamera gwen?” Hwëna zen man nasalsïblïk. ");
INSERT INTO ury_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesus ki zep jala ban nwekam amjanbirki, hwëna man hen kwasang gwibiridaka, sap zen nol drak-drak enna. Ki zep hwëna zi taha sakna insa gubluka, “Tahana insa emki ïnïn gïlsïn.” Ki zep hëndep ïnïn gïlsïkï, dekam zep hëndep tahana in etan dawem gweblak. ");
INSERT INTO ury_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farisikam de gubirida gwen zini in ki zep hëndep but srëm gola in kon te so gwek, hëndep dekam zep Raja Herodes hon de bïtï gwen zi niban tagal gwesïk. Man zë olsa ahaꞌen nuꞌik– Yesussu de tan hap denaka. ");
INSERT INTO ury_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesus kim zëre hon de ang ta gwen wenya ban Ho Gutuna Galilea san golësek gweka, zi trana lun kon zep nërtrozak– langna Galilea kore zini hen tïngare Yerusalem mo lang nakore zini. Ahakon Idumea mo lang nakon, hen weyana Yordan mo yakla hatase gwezan nakon, hen ë darena Tirus hen Sidon mo lang nakon. Zen kïtak Yesus onak dep yaïng gwezak, sap zen mes zëbe hap dena ësane gwe-gwek– Zen mensa syal gwe-gwekaye. ");
INSERT INTO ury_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Zini in beya tanganna. Yesus zep zëre hon de ang ta gwen wenyaka gubiridaka, “Ap bulu hamal ulblik– zëwe aka sewesek, dekon aka tawa tabik. Kama nakon Asa sa klasam dasïl.” ");
INSERT INTO ury_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sap yaklana inkam Zen mes zi sang-sangna beyakam dawem tabirki, zen in zep hwëna ahakore zi sang-sangna atata da gwibiꞌinzak– dekam de Yesussu golek de tan hap hen olk tan hap. ");
INSERT INTO ury_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Hen dowal-dowal mo tïlbiridan wenya Yesussu de hla tankam zep ëïk gwehe gweꞌanzak, dekon zep anakan ëhërhese gweꞌak, “Em in Alap mo Tane.” ");
INSERT INTO ury_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Hwëna Yesus ki zep jala ban dowal-dowala insa gubiridaka, “Asa bahem kira tan. Balkkam em sek gwen.” ");
INSERT INTO ury_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","14","Yesus ki zep kwatap teknak hata seka, dekon zep hwëna zini mensa dua-blas enkam Zëna dwam gwibiridaka, desa en gu sonebiridaka. Kim yaïng gwezak, zao zep zëre hon de ang ta gwen hap anakare ola ban gubiridaka, “Ëe ansa emsa gu sonebiridal, em eka Asa ang ë gweblak, hen emsa aka gubirida gwek– ano olsa de gol halada gwen hap. ");
INSERT INTO ury_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Hen Ëe asa ebe mae hap ëre mo sosonsa golzim– em ekakim dowal-dowalsa olëalsa sone gwibik.” ");
INSERT INTO ury_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Dua-blas enkam de zini in mo bosem-sena an zen: Simon– mensa hen Yesus “Petrus”kum bose taka. ");
INSERT INTO ury_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Hen Zebedeus mo walas darena Yakobus ne Yohanis ne. Desa hen Yesus zëre mae mo olkam “Boanerges”kam bose soka. Zëno enlalana, zëno nik mo ola jal ënkam yawala– nglï glung makan. ");
INSERT INTO ury_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ahana Andreas, Pilipus, Bartolomeus, Matius, Tomas, Yakobus– zen Alpeus mo tane, Tadeus, hen ahana Simon Bak– men zen nonol Israel dikim Roma mo ïrïk gïn nïkon ëzë-en gwen hap de ëasas gwennak ang gwekake, ");
INSERT INTO ury_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","hen Kariot walya Yudas Bak– men zen hëndep Yesussu zergukuke. ");
INSERT INTO ury_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesus ki zep zëre mo gwë gwen san dep lwa halka, hwëna zi trana ki zep etan yaïng gwezak, zep Yesus hëndep zëre hon de ang ta gwen wenya ban bawalkam dep?– golëtembane tan naye. ");
INSERT INTO ury_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hen ahakon dekam man Yesussu nen gweblaꞌak, “Zen mes mamak gwera.” Iye zem kim kirekam ësak, dekam zep yaïng gwezak– kwang tahan hap. ");
INSERT INTO ury_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Hwëna Musa mo tïtï tabin olsa de tawa ta gwibin zini mes hen Yerusalem kon yaïng gwezak, hen zen man anakan nen gweblaꞌak, “In dowal mo kïgïna Beelzebul Bak bi gweblaka. In zep zëno sosonkam syal gwe-gweꞌara– dekam de aha dowal-dowalsa zeralsa sone gwibin hipye.” ");
INSERT INTO ury_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","In zep Yesus zi beyam-byana insa kwang guludan hap gubiridaka, dekam zep anakan ola gulk sun blaonzimki, “San ha dowal mo kïgï mo aha hlïkna maka dowal bose zemka nolëalsa sone gwibiꞌin? Kina ki bëjen. ");
INSERT INTO ury_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Hen kirekam, aha ïrïk gïn nik de hlïweꞌanam, etan zën de eijan hap, dekam ïrïk gïnnï in molya etan ëtatete gweꞌanam. Maka hëndep ësekwak gweꞌan. ");
INSERT INTO ury_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Hen kirekam, zënaka de gïl-gïl gwibiridan nakon de aha-ere golak dinik hlïweꞌanam, zen maka hëndep sekwak gweꞌan. ");
INSERT INTO ury_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Zep hen kirekam, dowal mo kïgï mo ïrïk gïn nik de hlïweꞌanam, etan zënaka de golëeijan hap, zen molya ëholo gweꞌanam. Nabakam maka hëndep denaban altïꞌïn. Zep dowal mo kïgï mo aha hlïkna, zen molya zënaka nolëalsa sone gwibiꞌinam. ");
INSERT INTO ury_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Sap Ëe dowal mo kïgï mo bi gwibin kire-kire dawemsaë jal zi mo kim alal ta gweblaꞌan. Zi jal-jal de zëre mo golsa kara taꞌanam, zëbe hap de jal zini na-en molya tïꞌïn zanam. Diki zini insa de nonol balk tankam hen tahalenkam, dekam zëno kire-kirena maka alal tablaꞌara. ");
INSERT INTO ury_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Eiwa denakaë emsa gubiridaꞌan: Alap maka zi mo kirekam-kirekam karekna tïngan tap gulsuk gwizimꞌira, hen sap Zënaka de lamang tanna, desa hen maka tap gulsuk gwizimꞌira. Diki aha-en: ");
INSERT INTO ury_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Zi de Alap mo Enhosa lamang tankam, desa Alap bëjen tangan tap gulsublun. Kirekam de karekna zen mes hëndep denaban makan gweblanan.” ");
INSERT INTO ury_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus mae hap ki kirekam gubiridaka: Insa Zënaka nenblakke, “In dowal tïlblïka.” ");
INSERT INTO ury_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yesus mo anena ki zep oso wal zeban Yesussu de zertoran hap golëyaïng gwezak. Zisi zep nenbiridak– zen de Yesussu gublun hap. Zëna ë nakon nësblaꞌak. ");
INSERT INTO ury_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Hwëna Zen zi ngïrïnnïk nikinꞌinka. Zao zep nenblak, “Bian, eno anena oso wal oban ë nakon emsa ziësblaꞌanon. Zen man ëdwam gweꞌan– emsa de zertowen hap.” ");
INSERT INTO ury_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesus ki zep ding gulzimki, “Hwëna nonol Ëe anik emsa gubiridak, ano anena hen oso-walya, zen diki a kirekam de zisi moye:” ");
INSERT INTO ury_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ki zep hwëna zini men zen zëre mo alp nakon teinikinꞌik, desa nwekam amjanbirki, ki zep hwëna gubiridaka, “Diki an zen lowe heꞌan, zen zen– ano anena hen oso walyaye! ");
INSERT INTO ury_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sap Alap mo ol san men zen ang ta gwenan, zen diki zen tangan– ano anena, oso walya hen somol walyaye.” ");
INSERT INTO ury_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesus kim etan Ho Gutuna Galileak tawa tabirki, zini beya tangankam tagal nëblak, hëndep man tangan dot dasïk. Yesus hëndep buluk zep sewe seka, zao zep nikinki– dekon de tawa tabin hip. Bulu in engka en weya ngïrïn sïn dep esek nul kïnïk, hwëna zi beyam-byana in ho gutu alp san teinikin sonek. ");
INSERT INTO ury_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Zao zep Yesus gulk sun de ol blaon gwizimdinkim tawa ta gwibiꞌinka. Nonol man zë gubiridaka, ");
INSERT INTO ury_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ansa emki ësane gwen! Zini man orep gandum dansa de hlïng gïlsïn hïp song gweka. ");
INSERT INTO ury_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kim hlïng gïlsïkï, hwëna ahakon oranak altïnk. Mawana ki zep zë yaïng gwezak, zen zep hwëna gandum danna insa dwensïblïndak. ");
INSERT INTO ury_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ahakon kaso-kasonak altïnk– kama bëbeknak. Gandum danna in nabakam zep sap ësïp gwek, sap kamana in bëbek tanganna. ");
INSERT INTO ury_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hwëna yaklana kim sal-sal gweka, sïpnï in dekam zep ëboneng gwek, hëndep ësasan gwek, ki zep tol hëndep juwek. Sap sana ba san dep?– olk san de ëhas gwesïn nïye. ");
INSERT INTO ury_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Hen ahakon dokot të ngï-ngï ausunak altïnk. Kim sap tol ësaltïk, hwëna dokot të ngï-ngïna in zep nabakam ëblal-blal gwek. Zen zep dahalebik, hëndep eini hom tëka. ");
INSERT INTO ury_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Hwëna ahakon kama dawemnak altïnk. Zen en dawemkam zep ësïp gwek, hëndep dawemkam zep hataka, hëndep dawemkam tëka. Aha-ere timni zëno dan beyana ahakon 30 enkam, 60 enkam, hen ahakon 100 enkam.” ");
INSERT INTO ury_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ola insa kim tonsuku, ki zep gubiridaka, “Em dwan i nibanke. Em ësal gwen!” ");
INSERT INTO ury_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesus kim zë-en gwëꞌanka, dekam zep ahakon in zen zëno tawa tabinni insa ësane gwek, dua-blaskam de ang ta gwen wenya ban dakensïblïzak, “Bian, em insa gulk sun ola blaon gwizim sira, ëe homë dam ulsul.” ");
INSERT INTO ury_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ki zep ding gulzimki, “Abon de ang ta gwen wenya ebe mae hap Alap mes golzimki– em dikim zëre mo ïrïk gïn hïp denaka tame gul gwen hap denaye. Hwëna aha zi hip hom kirekam golzimꞌira. Ëe in zebë zëbe mae hap gulk en san ola blaon gwizimnin. ");
INSERT INTO ury_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Sap Alap man desa dwam gwibiridaꞌara– men kirekam zëre mo olak lwakke, kirekam de hëndep zëbe mae hap anakan lwa gwizimdin hip, ‘Zen sap sa hla nul gwer, hwëna san de hlaun srëmna. Hen sap sa ësane gwe-gwer, hwëna zen molya tol dam nulsuk gwek. Diki zen de etan Abon osan dep lwanda haꞌan zanam, ki Ëe amaka zëno mae mo karek-karekna tap gulsuzimꞌin.’” ");
INSERT INTO ury_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesus ki zep gubiridaka, “Em ba hap tangane tame ul srëm gwer? Ki hen ahanakaë gulk sun blaonzimꞌik, desa hen molye tame uk. ");
INSERT INTO ury_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Zini men zen gandum danna hlïng gïlsïkï, zen san de men kiye– men zen Alap mo ola tawa da gwibirinke. ");
INSERT INTO ury_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Gandum dan de oranak altïrïnnï, zen zini men zen Alap mo ola ësane gwe-gwenan. Hwëna dowal mo kïgïna dekam zep desa de al gul gwizimdin hip zëno mae mo enhonak hata gwenan zala. ");
INSERT INTO ury_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hen men zen kaso-kasonak altïrïnnï, zen ahakon men zen Alap mo ola insa ësane gwe-gwenan. Zen nabakam zep sap enlala isrip-sri naban nulin gwenan. ");
INSERT INTO ury_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Hwëna ola in bëjen zëno mae mo enhonak sa gwen, zep bëjen zë holokam lwan. Sap zen kim de karek maena hla nuꞌik, ahaksa ol dawemna in hap de jal hap karek dabiꞌik, zen hëndep dekam sa Alapsa hli dal. ");
INSERT INTO ury_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Hen kirekam, men zen dokot të ngï-ngï ausunak altïrïnnï, zen zini men zen Alap mo ola insa sap ësane gwe-gwenan. ");
INSERT INTO ury_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Hwëna angkam de okamanak awe de kirekam-kirekam enlala ngalap naban zë zëre mae mo enhonak siri nul gwenan– anakarekamye, ‘Ëe babë tahalha gwen,’ hen anakan de hole-hle gwe-gwen naban, ‘Diki te-ala beya naban amaka gwë gweꞌan.’ Kirekam de enlalana in zep Alap onakare ol dawemna insa zëno mae mo enhonak hule gwenan. Zep hëndep dawemkam eini ëtë srëm gwe-gwenan. ");
INSERT INTO ury_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Hwëna men zen kama dawemnak altïrïnni, zen zini men zen Alap mo ola insa ësane gwe-gwenkam dawem enkam enhonak ing nul gwenan. Zen zep dawemkam eini ëtë gwenan. Zëno mae mo ei beyana, ahakon 30 enkam, 60 enkam, hen ahakon 100 enkam.” ");
INSERT INTO ury_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Etan ki zep Yesus gubiridaka, “Ano ola zen pelita makan. Zini hom pelita ngatannak yuna utuk nul sone gwenan– dekam de ngatanna insa aning gun hupye. Hen pelitana hom tum ïltïkïnnïk si nulin gwenan. Zen diki meja maenak de lonesen. ");
INSERT INTO ury_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Hen kirekam, ola mensaë gulk sun de blaonzimdinkim zi beya hap aning gul gwizimꞌin, zen sa lamkam hataser. Hen ano enlala aning tanna, zen dekam sa ngatan gwera. Zen diki dekam sa zini dam nulsuk gwer. ");
INSERT INTO ury_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ëe in zebë emsa anakan gubiridal, ‘Em dwan i nibanke. Em ësal gwen!’” ");
INSERT INTO ury_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Etan ki zep Yesus gubiridaka, “Zen in zep ano ola mensa ena ësane gwe-gweꞌan, dawem enkam emki enhonak lone gwen. Sap ena men kire enkame tame gun hup ëhohle gweꞌan, zen kire enkam sa hen Alap ebe mae hap dekam de tame gun hup de enlala blala ing ta sone gwizimdi, hen zao sa etan mam ta gwizimdi. ");
INSERT INTO ury_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sap men zen Alap mo ïrïk gïn nïka de tame gun hup ëhohle gweꞌan, zëbe mae en hap sa etan Alap dekam de tame gun hup de enlala blala sowe henkam ing ta sone gwizimdi. Hwëna men zen ëhohle gwe srëm gweꞌan, zëbon mae men zen sap tame gun hup de enlalana betek enkam lwazimꞌira, desa sa hwëna Alap al tazimdi.” ");
INSERT INTO ury_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesus in kim nama bulu kon tawa tabiꞌinka, zao zep etan zi beyam-byana in hap ola gulk sun blaonzimki, “Alap mo ïrïk gïn hïp dena, zen san de zi de nganak gandum dansa hlïng gïlsïnnï kiye. ");
INSERT INTO ury_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Zëna dekam totoresa de gwë gwen, hwëna gandum danna in dekam sa totoresa sïp gwera, hëndep saltïlï. Zini in sap de anakan tame gun, ‘Mes saltïlï,’ hwëna anakan bëjen dam gulsun, ‘Ba hap kirekam saltïl gwenda?’ ");
INSERT INTO ury_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Sap kama mwanak de gandum dan lwanna, zen totoresa dekam ësïp gwe-gwenda, hëndep ëtim gwe-gwenda, dekam zep hëndep ëwenam gwe-gwenda, hëndep danna dekam zep ëbeya gwe-gwenda. ");
INSERT INTO ury_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Hwëna kim de bïl gweꞌanka, hëndep dekam sa hwëna zini in nëbokkam blom tasïlï. Sap dekam taran hap denak mes zaunun.” ");
INSERT INTO ury_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesus ki zep etan gubiridaka, “Ba naban esa apde osol?– dekam de Alap mo ïrïk gïn hïp denaka gulk sun blaonzimdin hipye. Alap mo ïrïk gïn nïban ba naban esa enlala eizim?– dekam de srip gulsuzimdin hipye. ");
INSERT INTO ury_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Alap mo ïrïk gïnnï zen rica dan makan. Sap tïngare tetan dan nakon, rica danna, zen zen– betek tangan wenyaye. ");
INSERT INTO ury_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Hwëna kim ësaltïl gwenan, dekam zep tïngare obwaga nakon ëblal-blal gwe-gwenan– hëndep hli-hli naban. Mawana zao zep yaïng gwe-gwenanzal– zëno hli-hlinak de golsa tauk gweblan hapye.” ");
INSERT INTO ury_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus kirekam-kirekam gulk sun de blaonzimdin olkam tawa tabirida gweka. Men zao en zëno mae mo ësane gwen hap de sosonna zausuk gwizimk, dekon hom etan ayang gul gwizimki. ");
INSERT INTO ury_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Zi beyana kim tawa ta gwibirki, Zen gulk sun de blaonzimdin enkam tawa ta gwibirki. Hwëna zëre hon de ang ta gwen wenyaka de zë-erenak tawa tabinkim, Zen man tïngan srip gulsuk gwizimki. ");
INSERT INTO ury_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kam-en tangan zep Yesus zëre hon de ang ta gwen wenyaka gubiridaka, “Haen, nen ho gutu men eihya san gweyo gwen.” ");
INSERT INTO ury_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Dekam zep hëndep zëre hon de ang ta gwen wenya in, bulu men dekon tawa tabiꞌinka, zëwe sesek gwe sezak. Zi beyana insa ho gutu alpna iwe zep hli nulidak. Ahakore bulu hen lun ang ta kïnïk. ");
INSERT INTO ury_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Hwëna asese yala ki zep mumuk ennak hataka. Ho gutuna in dekam zep mam enkam ngëp-ngep gweka, hëndep buluk iwe suwehe kïnï gweꞌanzak, hëndep beya gwesen hap alp gwesïꞌïk. ");
INSERT INTO ury_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesus Zëna bul ohwa nakon nisi taꞌanka. Nola nol trï-trïnak dreini neka. Zëre hon de ang ta gwen wenya ki zep lï dak, zao zep nenblak, “Guru, em san nen de kïtak juwen hap ema dwam gweꞌara?” ");
INSERT INTO ury_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesus ki zep luweka, ki zep asesena insa gubluka, “Em zausun!” Hen ho gutuna insa gubluka, “Em hen em sëwehen!” Asesena dekam zep tap gweka. Ho gutuna in hen dekam zep tangan sëwe heka. ");
INSERT INTO ury_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ki zep hwëna gubiridaka, “Em bap ëaïrïl! Em san ki nama home Asa laïblïblaꞌan?” ");
INSERT INTO ury_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Zen dekam zep sërkam ëaïrïꞌak, ki zep zënaka nenbiridak, “Eiwa, zini an wehasa hom! Ba hap tangan asese naban ho ngëp naban betek nëblanan!” ");
INSERT INTO ury_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Hëndep kim Ho Gutuna Galilea mo men eihyanak golëyaïng gwe naka, Gerasa mo langnak, ");
INSERT INTO ury_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Yesus kim bulu kon ati gweꞌanka, dekam zep hen dowal-dowal mo bi gweblan zini Zëbon osan dep song gweꞌan zaka. Zen zi tok lo tasïk gwibin kaso-hul kaso-hulak gwënda gweka. Dekon te soꞌan zaka. Tahale gwenna mes topse nëblak. Besi dokot maekam sap naka gweblak. ");
INSERT INTO ury_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Zen kim sap besikam de dokotkam taha-tanana tatak noso gweblak, zen hwëna nonol tahanak denaka blom ta sone gweka. Hen tananak dena, tanana kim ziheir gweka, dekam zep ësom gwe hana gwek. Sosonna sërkam tangan dowal-dowala in zëbe hap nol gweblak, zep hëndep toton nara dep?– balk tan naye. ");
INSERT INTO ury_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yaklam denaban kam denaban zen zi lo tasïk gwibin kaso-hul kaso-hul san gwënda gweka, hen kwatap bete-teksa hërhendan naban wale tanda gweka. Zëre mo timni kaso ben-benkam kalk-kalk guluda gweka. ");
INSERT INTO ury_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Zen kim langa nakon Yesussu hla takïn zïka, ki zep hluwe zaka, zëno nwenak zep boklena kom so zaka. ");
INSERT INTO ury_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesus ki zep zëbon de dowal-dowala insa gubiridaka, “Dowal-dowal, em zëbon onakon wet so gwen!” Zini in dekam zep mam enkam hërheka, “Yesus, Teipsïn Zini Alap mo Tane, Em aban toton banakan de syal ën hap? Alap mo nwenak Emki anakan asa gublun, ‘Ëe molyë emsa karek tak.’” ");
INSERT INTO ury_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesus ki zep takensïblïka, “Eno bosena nara?” Dowal-dowala in ki zep ding nulblik, “Zëno bosena Jal Zi Tra Bak, sap ëe an tra tangan nikë zëbon lowe heꞌan.” ");
INSERT INTO ury_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Zen man Yesussu aberbe da gweꞌak, “Asa bahem langna an kon golëalsa sonendan.” ");
INSERT INTO ury_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Zëno mae mo nwe kara gwen san zahona beyam-bya tangan nik kwatap tïnï san tembane hap ëhakaꞌak. ");
INSERT INTO ury_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Dowal-dowala in ki zep Yesussu aberbe daꞌak, “Em wëhë tol asa zaho trana wakuwe de bïtï gwen hap gubiridaꞌanka?” ");
INSERT INTO ury_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesus ki zep gubiridaka, “Dekam bïtï gwek.” Dekam zep dowal-dowala in zini in kon wet so gwek, dekam zep hwëna zahona iwe bïtï gwek. Zaho trana in dekam zep heya-hya gwek, li san zep syalk ta tinek, hëndep ho gutunak zep ëkei-king gwek. Zahona in zëno beyana tïngan dua ribu enkam. ");
INSERT INTO ury_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Zahona insa men zen kara da gwibik dekam zep zaho bi naka de gubiridan hap ë san dep hen ëna in mo golek denak de gol-gol san dep ëhlu-hluk gwek. Zëwe de zini in kim ësak, dekam zep hëndep nolësal kïnïk. ");
INSERT INTO ury_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesus onak kim yaïng gwezak, zao zep hen dowala in desa bi nëblak desa hen hla dazak. Pakean naban zë nikinꞌinka. Enlalana hen mes sëwe heblaka. Dekam zep zë ëaïrïꞌak. ");
INSERT INTO ury_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Owasna insa men zen hla nuk, zen zep hwëna ahakore wenya insa donbiridak. ");
INSERT INTO ury_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kirekam kim ësak dekam zep Yesussu Zen de nabakam zëno mae mo langna in kon song gwen hap aberbe da gweꞌak. ");
INSERT INTO ury_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesus kim buluk sewe seka, zini in desa dowal-dowala bi nëblak ki zep aberbe taꞌanka, “Ëe wëhë tol Emsa ang gweblaꞌak?” ");
INSERT INTO ury_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesus hwëna man gubluka, “Bahem. Em gol san song gwen. Ere mo iyesa tonbirida– mensa Bian Alap dawemna ebe hap mamkam golblalake. Anakan gubirida, ‘Zen man tangan asa kwasang gweblaka.’” ");
INSERT INTO ury_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Zini in dekam zep song gweka, hëndep Yesus insa zëre hap syal gwibir-blika desa tonbirida song gweka– langna mensa anakan bose nukke, “Ëna Dare Taha-tap”kam. Kim sane da gwek, tïngare zini man tangan ëtenggwan gwek. ");
INSERT INTO ury_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesus kim etan bulkum ho gutu an eihya san dep lwahal zaka, zao zep zi beyam-byana ho gutu alpnak tagal nëblak. ");
INSERT INTO ury_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Zao zep hen zi bosena Yairus hata zaka. Zen Yahudi mo zëwe de but srëm golak de aha mamna. Zen kim Yesussu hla ta zaka, ki zep zëno nwenak ïk gwehe zaka, ");
INSERT INTO ury_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","dekon zep dawem enkam aberbe ta seka, “Bian, ano wenam tola tïn hïp alp gwesïꞌïn. Em wëhë zë hataꞌanka?– tahasa eka zë tehabir ane, zen dekakim tol dawem gwek. Mana tol ap tïlblïnank.” ");
INSERT INTO ury_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Dekam zep zëno gol san dep song ëka. Zini beya tangan nik ngïrïnnïk nëblahak, hëndep man tangan ngïltïtïk gwenkam kyang dasïk. ");
INSERT INTO ury_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Dua-blas tahunkam de karekkam aura gwe-gwe wenya dekam zep hen ang gwese haꞌak. ");
INSERT INTO ury_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Zëno te-alana mes tol tap gweka– dokter-dokter hap de sap kap ta gwizimdinkim. Hwëna hom tol kim dawem gwe-gwek, hwëna sang-sangna man kim tangan sabak gwe-gwek. ");
INSERT INTO ury_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Wenya in mes beyakam Yesus hup dena sane gwe-gwek, zep zi tra ngïrïnnïk tahan nakon golek de tazak, zao zep hëndep baju ennak olk ta sonek. ");
INSERT INTO ury_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Sap wenya in mes anakan taïblïblak, “Baju mae ennakë towanblaꞌak, ëe dekam asa dawem gwer.” ");
INSERT INTO ury_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Zen kim olk tak, hëndep dekam zep zëno kala in tewesibik. Dekam zep zëre mo timni anakan eisbik, “Ëe mesë dawem gwenan.” ");
INSERT INTO ury_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesus dekam zep hëndep anakan eisbirki, “Zi sang-sangna mes Asa de olk tankam dawem gwenda.” Dekam zep zi tra mo ngïrïn nïkon lure san lero gweka, hen takensibirida gweꞌanka, “Asa nara bajunak olk ta sonera?” ");
INSERT INTO ury_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Zëre hon de ang ta gwen wenya dekam zep nenblak, “Bian, zini an beya tangan nakake– an zen emsa dot dasïlye! Ba hap de waba hap takensibirida gwen hap, ‘Nara asa olk tala’?” ");
INSERT INTO ury_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Hwëna Yesus nama ki nwekam tëblaka– men zen olk takake, desa de tawa gweblan hap. ");
INSERT INTO ury_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Hwëna wenya in mes zënaka anakan eisbik, “Ëe mesë dawem gwenan.” Dekam zep aïrïn hïp yal-yala ban Yesus mo nwenak ïk gwe hezak, dekon zep zëre mo sang-sang hap dena kïtak ton seblak. ");
INSERT INTO ury_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesus ki zep kwasang tola ban gubirki, “Anyan, em ema Asa taïblïblala, in zebe dawem gwenda. Aha-ere enlalakam song gwe. In eiwa, mese tangan dawem gwera.” ");
INSERT INTO ury_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus in kim nama ola tonꞌanka, zini dekam zep Yairus mo gola kon yaïng gwezak, ki zep zë nenblazak, “Eno wenamna mes tol tïlsïnïn. Bian Gurusa ba hap de waba hap blos tablan hap?” ");
INSERT INTO ury_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesus man salsibiridaka in zen Yairus Baksa nenblazak, ki zep hwëna Yairuꞌu gubluka, “Bahem aïrïn. Asa em taïblïblan.” ");
INSERT INTO ury_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesus dekam hom aha zi de ang gweblan hap gubiridaka– diki Petrus, Yakobus, oso zem Yohanis hin. ");
INSERT INTO ury_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yairus mo golak kim yaïng gwek, anakan zep hla nulidaꞌak, “Karekkam ena taꞌan hen gona dabiꞌin.” ");
INSERT INTO ury_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesus kim golak tïl zïka, ki zep gubirida zaka, “Em ba hap ena tal hen gona tal? Wenam tola in hom tïl. Zen nisi am taꞌan.” ");
INSERT INTO ury_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Zen hwëna man Yesussu swrë daꞌak. Yesus ki zep wet so gwen hap gubiridaka. Kim wet so gwek, dekam zep zëre hon de ang ta gwen zi dan-aharena in han hen wenam tola in mo ane-bia mae en naban golëbïtï gweka– teksonna men zao wenam tol tokna in lwaꞌakke. ");
INSERT INTO ury_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ki zep wenam tol tokna insa taha nakon gul ineka, ki zep zë zëre mae mo olkam anakan gubirki, “Talita kum.” Nëre mae mo olkam zëno enlalana anakan, “Timë, em luwen.” ");
INSERT INTO ury_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Wenam tola in dekam zep hëndep luwek, hëndep të nasenꞌak. Zëno tahunna dua-blas enkam. Dekam zep sërkam tangan ëtenggwank. ");
INSERT INTO ury_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Hwëna Yesus man tangan jalse gwibiridaka, “Owasna an zen ki lwanan, bahem ahasa tonbiridan.” An-bi zemka ki zep hen guzimki, “Tembanesa em olbin.” ");
INSERT INTO ury_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesus dekam zep dekon zëre hon de ang ta gwen wenya ban zëre mo ëna Nazaret san dep golëlwanda halka. ");
INSERT INTO ury_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Hari Sabatnak kim zauk, Yesus zep zëwe de but srëm golak tawa tabirki. Zi beyam-byana men zen sane daꞌak man tangan denggwanblaꞌak. Zep zë hwëna donsubluꞌak, “Zini an endawe sekola gweka?– zep kïl gïꞌïra, ‘Ëe asa tawa tabir.’ Hen owas-owassa de syal gwe-gwibin hip de sosonna endawe sa gul iri? ");
INSERT INTO ury_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","An dwan zenke– gol syal gwe-gweblan zi niye, Maria mo tane sake. Zëno oso walya Yakobus, Yoses, Yudas, hen Simon. Hen zëno somol walya awe am hen lowe heꞌan.” Sap zen mes kirekam tame dak, zep baes nëblak. ");
INSERT INTO ury_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Hwëna man ding gulzimki, “Zini kirekam ëgwë gwenan: Men-kore men-kore ë nakon, Alap mo ol ayang gul gwen hap de zini man blikip neisibirida gwenan. Hwëna zëre mo iye, ahaksa zëre mo ë nakore nik de kirekam ayang gul gwizimdinkim, desa hom tangan blikip neisibirida gwenan.” ");
INSERT INTO ury_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Zen in zep Yesus zëwe owas-owasna beyakam syal gwibir-zim srëm gweka, sap zen hom daïblïblak. Hwëna zi sang-sang ensa zë dan en dawem tabirki– tahasa de tehabirida ine gwenkam. ");
INSERT INTO ury_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Sap zëre mo ënak de zini kirekam daïblïbla srëm gwek, zep tangan tenggwanbiridaka. Ki zep hwëna ë-ë san amjanbir song gweka hen desan tawa tabirida gweka. ");
INSERT INTO ury_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ki zep hwëna dua-blaskam in zen ang në gweblak, desa kwang guludaka, zao zep gubiridaka, “Em dan-dan dan-dankam ë-ë san sek gwen. Ëe asa ëre mo sosonsa ebe mae hap golzim– dowal-dowalsa ekakim olëalsa sone gwibik. ");
INSERT INTO ury_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Bahem ba maena ora san dep lop tan. Dute ensa leirenk. Tembanena hen bahem lop tan. Honna bahem wëwek tan, hen te-ala maena bahem kap tan. ");
INSERT INTO ury_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sepatu enna amki alala lak, hen bajuna tim ennak dena kim sek gwek. ");
INSERT INTO ury_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Gol karek mae nakon de emsa teisya irinni, ‘Haen, awe se këza,’ zen zëwe en emki ën. Bahem dekon etan gol dawem san dep al ëhan. ");
INSERT INTO ury_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Hwëna men dekore ë nakon emsa anakare ola ban teisya irin srëmna, ‘Em ba habe awe aptanan zala? Ëe ama emsa de salzimdinni baes taꞌan,’ zen dekam em hëndep dekon song ën. Ë topnak em tana sonsa taïk-tïk oso guk kïnïn– dekakim anakan tame nuk, ‘Zen sap Alap onakore ol dawem naban nëbe mae hap olhatazim zira, hwëna nen insa lesya-in srëm gwenan nëre mae hap de kareksae kim mam ulin.’” ");
INSERT INTO ury_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Zen dekam zep dan-dan dan-dankam sek gwek, hen anakan tawa dabir-song gwek, “Ere mae mo karek-karek nakon em ëhalen.” ");
INSERT INTO ury_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Hen dowal-dowala beya tangan naka nolëalsa sone gwibik, hen zi sang-sangna Yesus mo bosekam de minyak zaitunkum dra tabinkim beyakam dawem da gwibik. ");
INSERT INTO ury_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","18","Galileak de teipsïn zini Herodes Bak kim zëre mo osona Pilipus mo wenya Herodiana Baksa al gulbluka, hwëna baptis ta gwibin zini Yohanis zep damnak anakan jalse gweblaka, “Musa mo tïtï tabin ola kon, em sap diki bëjen em oso uk mo wenya gon.” Hwëna Herodes dekam zep zëre mo jana nabare zisi Yohanissi de bwinak tahalen naka tak ta irin hip gubiridaka. ");
INSERT INTO ury_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","We zem in, Herodiana Bak, zen hen man enlala ennak Yohanissi taïl gïk gweblak. Zen man sap Yohanissi de tan hap enlala gwe-gwek, hwëna Herodes de gubiridan srëmkam bëjen tan. ");
INSERT INTO ury_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Sap Herodes hen man Yohanissi aïrï gweblaka, sap zen man enlala gwe-gweblaka, “Yohanis zen zini dawemna. Alap zer soneka.” In zep tan hap jalse gwibirida gweka. Herodes hen man zëno olsa de sane gwen hap dwam gwe-gweka, hwëna hyanak zep etan zëno enlalana anakan dowebla hana gweka, “Ëe banakan asa gwëblal? Zini an Alap mo zer sonen nakake.” ");
INSERT INTO ury_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hwëna Herodes zënaka de jaha gweblan yaklanak kim hatak, tembane yawalsa zep syal neibik. Tïngare ïrïk gïnnïk de mam-mamna hen jana nabare zi mo mam-mamna, hen Galilea kore nol-nola, zen man zë yaïng gwezak, zao zep apdekam tembane tak. Zen dekam zep zauk– Herodiana mo baptis ta gwibin zini Yohanissi de taïl gïk gweblanna in dikim jowen hap denakye. ");
INSERT INTO ury_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tembane tanna iwe, Herodiana mo wenam seiwiri man hen tïlzïk, zao zep tïngare zi mo nwenak zisya gweꞌak. Herodes man tangan sam gwesibirki, hen tïngare zi trana in man tangan sam neisibik. Herodes ki zep wenam seiwiri insa gu-gubirki, “Men desae ki ena abe gwibiꞌinka, zen desa asa ki hëndep ebe hap golbir.” ");
INSERT INTO ury_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Zen kirekam wenam seiwiri insa tïngare zi mo inik gu-guk gwibiꞌinka, “Nglï naban kama naban mes asa nasalblanan: Ëe asa eno abe gwibinni insa ebe hap sul sonebir, hëndep ëre mo ïrïk gïn maena asa ep hlïlbir!” ");
INSERT INTO ury_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wenam seiwiri in dekam zep an zem Herodianasa de anakan takensibin hip te sok, “Ëe basa asa dawem kire-kirena abe gwibir?” Dekam zep ding gulbik, “Baptis ta gwibin zini Yohanis mo nolsa de blaonin halzan hap em abe gwen– ëe akakim anakan tawa gwek, ‘Zen eiwa mes tangan tïlï.’” ");
INSERT INTO ury_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wenam seiwiri in ki zep nabakam Herodes osan dep lwa halzak, ki zep gubluzak, “Ëe baptis ta gwibin zini Yohanis mo nolakaë abe gwibiꞌin– angkam de hëndep ap piring niban awe lonebir anezan hap.” ");
INSERT INTO ury_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes kim zëno abena insa salka dekam enlalana man tangan dowebla hanaka. Hwëna etan bëjen zëno abena insa wet gulsubin, sap zen mes ki zën zi tra mo inik kirekam etan-etankam gu-guk gwibiꞌinka. ");
INSERT INTO ury_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Dekam zep hëndep zëre mo jana nabare zini gubluka, “Em bwinak Yohanis mo nolsa ap blaonblin halzan.” Jana nabare zini in dekam zep hëndep blaonblinhal zaka. ");
INSERT INTO ury_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Piring niban zep golhal zaka, ki zep hëndep wenam seiwiri in hap golbir zika. Zen zep hwëna an zikhip golbirhak. ");
INSERT INTO ury_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yohanis hon de ang ta gwen wenya kim ësak, dekam zep tok naka de zerhan hap yaïng gwezak. Ki zep hëndep kaso hulak nënnek. 14 Hwëna zao kim lwa seꞌak, dekam zep hen etan Yesus hup de ola Herodes hon hatak, sap dekam mes Yesus mo syal hap dena ë-ë san ëtawa gwendak. Zep ahakon man ëgu gwek, “In eiwa, Yohanis Su Tabin Swe mes yap etan ngaya gweka. In zen hwëna bosena Yesuskum li yul soneka. In zep zëbon owas-owaꞌa dikim syal gwe-gwibin hip de sosonna lwaꞌan.” 15 Hwëna ahakon man ëgu gwek, “In orep de Alap mo ol ayang gul gwen zini Elia Bak mes yap– men zen Alap osan dep sewe sekake. Zen hom tïlkï, in zep Yesuskum hwëna jowe zaka.” Ahakon hwëna man ëgu gwek, “Ki hom. Zen Alap ëse naka zer soneka– orep men kirekam hen lup gul sone gwekake.” 16 Hwëna Herodes kim salka, dekam zep guku, “Aha hom. An Yohanis Su Tabin Swe. Ëe mes-am sap zëno nolsa de blaonsublun hap gubiridak. Hwëna in zen mes yap etan ngaya gweka!” ");
INSERT INTO ury_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Dua-blaskam de zëre hon ang ta gwen wenya– mensa zëna lup gul soneka, ki zep etan Yesus onak dep lwanda halzak. Zao zep donblazak– mensa zëna syal tandak hen tawa dabiridakye. ");
INSERT INTO ury_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Hwëna zini hen beya tangan nik yaïng gwe-gweꞌanzak, hëndep Yesus zep zëre hon de ang ta gwen wenya ban golëhir-hir gweꞌanka– hëndep golëtembane tan maena ba kon dep? Yesus dekam zep zëre hon de ang ta gwen wenya insa gubiridaka, “Haen, awe bëjen nen teinikirin. Nen në-en zi srëmnak de teinikirin hip sek gwen.” ");
INSERT INTO ury_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ki zep hëndep bulkum ëgwahak– zao de zë-en lowehen hap. ");
INSERT INTO ury_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Hwëna zi beyam-byana in mes ëgwa hannak hla nulida sonek, hen zen mes anakan tame dabik, “O an Yesus maeke!” Zep ë-ë nakon beya enkam eik ora san ëhlu-hluk gwek, hëndep zen zep nonol yaïng gwek. ");
INSERT INTO ury_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesus kim bulu kon ati gweꞌanka, ki zep zi beyam-byana insa hlauluda kïnïka. Zen sërkam zë kwasang gwibiridaka, sap zen bi srëm zaho makan zë lowe heꞌak. Zep zë mamkam tawa tabirki. ");
INSERT INTO ury_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","In kim tawa tabiꞌinka, zao zep hëndep kaweꞌak. Dekam zep zëre hon de ang ta gwen wenya Yesussu nenblazak, “Angkam man kaweꞌan, hen langna an tahalha tanganna. ");
INSERT INTO ury_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Diki dawemna zini an emaka zen de langna awe de golek de ë-ë san te-alakam tembane hap ëhakan hap enbiridaꞌan.” ");
INSERT INTO ury_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Hwëna Yesus ki zep ding gulzimki, “Amki em tembanena zëbe mae hap hen olzimk.” Dekam zep ding nulblik, “Asya! Nen an san te-ala beya zi! Ëe banakan de tembanena zëbe mae hap golzimdin hip?!” ");
INSERT INTO ury_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesus ki zep etan takensibiridaka, “Eno mae mo rotina banakaꞌen? Emki hla tandan.” Kim hla dandak, ki zep nenblak, “Rotina aha-ere taha-tap enkam. Hogwena dan-dan.” ");
INSERT INTO ury_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ki zep hwëna zi beyam-byana insa so trana iwe de hlïk-hlïkkam teinikirin hip gubiridaka. ");
INSERT INTO ury_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Dekam zep kirekam ëteinikin nirak. Ahakore hlïk-hlïkna 100-100kum. Ahakorena 50-50kam. ");
INSERT INTO ury_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesus ki zep aha-ere taha-tapkam de rotina insa hogwe darena in han teisyaka, dekam zep nglï san de kara gwesen naban Alap hap dawemna golblaka. Ki zep hwëna rotina insa ahap tabirki, hen hogwe darena insa kwa-kwak soka. Desa zep dua-blaskam de zini in hap etan-etankam kap ta gwizimꞌinka– zen de hwëna zi trana in hap kae gwebla-zimdin hip. ");
INSERT INTO ury_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Zi trana in kim dwenblandak, man tangan ëïtrï gwek. ");
INSERT INTO ury_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ki zep hwëna dua-blaskam de wenya in tembane mosrona insa tagam dak. Hëndep yuna dua-blas enkam zep ësuwek. ");
INSERT INTO ury_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","In zen rotina insa dwenblandak, zi ensa de aïtbinkim, beyana lima ribu enkam– we wal walassa de aïtbin srëmkamye. ");
INSERT INTO ury_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kim tembane tasïk, dekam zep hëndep dua-blaskam de ang ta gwen wenya insa bulkum de ho gutu men eihya san sek gwen hap gubiridaka– Zënaka de ëna Betsaida san dep ngeir gublun hap. Ki zep hen zi beyam-byana insa sekwak gwen hap gubiridaka. ");
INSERT INTO ury_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yesus kim zi beyam-byana insa hli yuludaka, ki zep zë-en kwatap tek san hata seka– dekon de Alapsa gu soneblan hap. ");
INSERT INTO ury_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kim kawesïk, zëre hon de ang ta gwen wenya bare bulu mes ho gutu ngïrïnnïk zauk, hwëna Yesus Zëna nama kwatapnak gwëꞌanka. ");
INSERT INTO ury_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Dekon zep anakan kara tabir aneꞌanka, “Asesena ngein nikon mamkam taïlbiridaꞌara, zep karekkam ho ngëpna insa bulu inkam sap nakabiꞌin.” Zëna hwëna oho-bung gun nuban zep ho gutu tahan san de song gwe zankam gulmun nuran makan gweibiridaka. ");
INSERT INTO ury_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Zen kim hla da sonek weya tahan san de song gwennak, ki zep au hloblankam ëhërhek, sap zen man kïl dïk, “Hobwem dowal!” Hwëna ki zep gubirida kïnzïka, “Em ësëwehen! Bahem ëaïrïn. Ëe an Ëe.” ");
INSERT INTO ury_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ki zep hëndep zëno mae mo buluk iwe sewese zaka. Asesena in dekam zep hëndep sëwe heka. Zëre hon de ang ta gwen wenya in man tangan sërkam denggwanblak. ");
INSERT INTO ury_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Sap zen aha-ere taha-tapkam de rotina mensa ahap tabir-zimki lima ribu enkam de zi hip, zen hom owasna desa tame nuk. Zëno mae mo nola dekam nama drak-drakna, zep zëbe mae hap man tangan gwa-gwa gwizimk– desa de tame gun hupye. ");
INSERT INTO ury_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Genesaret kim bulkum yaïng gwek, ho gutu men eihyanak, ");
INSERT INTO ury_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","kim atiti gwek, zëwe de zini hëndep dekam zep Yesussu tame dazak, “O an zenke.” ");
INSERT INTO ury_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Zen dekam zep tïngare langna iwe de ë-ë san gubiridan hap ëhlu-hluk gwe gu nusenk. Zen kim anakan nasal gweblaꞌak, “Angkam Yesus zao gwëꞌara,” dekam zep zi sang-sangna zato naban desan dep kap nulhal gweꞌanzak. ");
INSERT INTO ury_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesus men desan ki tënda gweka zi sang-sangna hen zëwe nolëyaïng gwenda gwek– sap ë yalak, sap ë bete-teknak, hen sap ora san de gol-gol mae san. Hen pasar maenak kang nul gwek, dekon zep Yesussu abe da gwek, “Bian, zi sang-sangna an wëhë baju top en mae nakon Emsa olk taꞌanka?– dekakim tol dawem gweka.” Tïngan men zen olk da gwek, zen dekam zep hëndep ëdawem gwe-gwek. ");
INSERT INTO ury_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Aha yaklakam Farisikam de gubirida gwen wenya Musa mo olsa de tawa ta gwibin wenya ban Yerusalem kon Yesus onak dep yaïng gwezak. ");
INSERT INTO ury_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Hwëna zen man Yesus hon de ang ta gwen wenyaka hla nulidak– auyan-aza zik mo ëpba ol san de taha hlë tazimdin srëmkam tembane tannak. Zen man dekam enlala neibiridak, “Zen an mes Alap mo nwenak ëkun gwenan.” ");
INSERT INTO ury_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yahudi zini zen kirekam zëre mae mo orep de auyan-aza mo ëpba ol san ang ta gwenan, hwëna Farisikam de gubirida gwen wenya, zen zen tangan sërkam desa kyang-kyang nulsuk gwenan. Zen bëjen mae tembane tan– zëre mae mo auyan-aza mo ëpba ol san de kire enkam tahasa hlë tazimdin srëmkamye. ");
INSERT INTO ury_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ba maesa de pasarak gonna, zen bëjen hokam de su tabin srëmkam twinbin. Hen beya tanganna zëre mae mo ëpba ola– zen men desa tangan kyang-kyang nulsuk gwenan, mok, blang, cerek, hen tum maesa de su tablanda gwen naye. ");
INSERT INTO ury_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Musa mo olsa de tawa ta gwibin zini in Farisikam de gubirida gwen wenya ban dekam zep Yesussu dakensïblïk, “Ebon de ang ta gwen wenya ba hap nëno mae mo auyan-aza mo ëpba ola nulmun gweꞌan?– tembane dëre ta gunnuk de tahasa nonol hokam hlë tazimdin srëmkam de tembane ta gwenkamye. Zen mes Alap mo nwenak ëkun gwenan.” ");
INSERT INTO ury_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ki zep ding gulzimki, “Em an eiwa ëk enkame ëgu gwenan, ‘Ëe an Alapsa de betek gweblanna.’ Eiwa, Yesaya Bak mo ola man ebe mae hap dakastïlzimꞌin– zen insa Alap mo ola anakan ayang gulkuye, ‘Zini in ëk enkam Asa betek në gweblanan, hwëna zëno mae mo enhona Abon onakon langa tangannak. ");
INSERT INTO ury_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Zen waba hap Asa boklena kom da gweblanan, sap zen zi zëre mae mo tïtï tabin olkam tawa da gwibirin– san de ano olkam de tawa tabinni kiye.’” ");
INSERT INTO ury_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Anakan zep waulsuzimki, “Em Alap mo ola ema eibir kïnï gwenan, hwëna zi mo olsae kyang-kyang ulsuk gwenan.” ");
INSERT INTO ury_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Etan ki zep gubiridaka, “Em an eiwa tewesïn tanganna, zebe Alap mo ola eibir kïnï gwenan, hwëna auyan-aza mo ëpba olsae kyang-kyang ulsuk gwenan. ");
INSERT INTO ury_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sap Alap mes Musa Bak hap ola ansa golblaka: ‘Ane-biasa em blikip gwesïk gwizimdin.’ Hen anakan mas gulku, ‘Men nara an-bi zemka lamang sonna, zen hëndep tok hap em karek tan.’ ");
INSERT INTO ury_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Hwëna em an ema anakan tawa la gwibirin, ‘Ane-bia mo ol san sap esa ang ta srëm gwe-gwer– anakan mae de lwankamye: Ane-bia de tahalha ënnak, em sap esa anakan enbirida gwer, “Angkam ëe molyë emsa mas gwizimk, sap ano te-alana an lamkam de Alap hap kap tablan habë lam taꞌan.”’ ");
INSERT INTO ury_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Eno mae mo tawa tabinkim, kirekam de an bi zemka blikip gwizimdin srëm zini man sam gwesïꞌïra. Zep eno mae mo tawa tabinni ema kim enbirida gwenan, ‘Bahem ane-biasa mas gwe-gwizimdin.’ ");
INSERT INTO ury_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Zep ere mae mo auyan-aza mo ëpba tawa tabinni insa de kyang-kyang gulsunkum, zen hwëna dekam Alap mo ol tanganna insae kim hli kuꞌin. Hen beya tanganna– em mensa kirekam ulin halasen gwenanye.” ");
INSERT INTO ury_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesus ki zep etan zi beyana insa tagal gwen hap gubiridaka. Kim tagal gwek zao zep gubiridaka, “Kïtak Asa sane lak– ekakim tame uk. ");
INSERT INTO ury_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Mensa ëk tïhï san zini ing nul gwenan, dekon hom Alap mo nwenak ëkun gwe-gwenan. Diki men zen zi mo ëk tïhï nakon wet so gwenan, zen diki dekon Alap mo nwenak ëkun gwe-gwenan.” ");
INSERT INTO ury_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesus ki zep zi beyana insa hli yuludaka, ki zep golak tïlkï. Zëre hon de ang ta gwen wenya ki zep du nëblazak, zao zep dakensïblïk, “Bian, kun gwen hap de ola insa gulk sun blaonnara, emki abe mae hap srip gulsuzimdin.” ");
INSERT INTO ury_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ki zep ding gulzimki, “Em san hen home tame ul? Ki em san hen zi trana in han apdenak?– enlala joblo-topna. Men desa ëk san olgwen gwibirin, zini dekon bëjen Alap mo nwenak kun gwen. ");
INSERT INTO ury_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Sap zen hom enhonak tïl gwenan. Zen ulpnuk hata gwenan, hëndep ukum zebe ana gwibirin.” Ëe an Markus. Ëe ama ola ansa ebe mae hap srip gulsuzimꞌin: Kirekam kim Yesus tawa tabirki, zëno dam gulsunnu a kirekam mo: Tïngare tembanena zen Alap mo nwenak dawemna. Tembane nakon bëjen Alap mo nwenak kun gwen. Dekam zep etan ayang gulzimki, ");
INSERT INTO ury_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","“Diki men zen zi mo enho nakon hatase gwenan, zen diki zini dekon Alap mo nwenak ëkun gwe-gwenan. ");
INSERT INTO ury_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sap zen zi mo enho nakon anakare kareksa de gon hap de enlala jal-jala hatase gwenda: kahalo gwen hap dena, sowë hap dena, zisi de tan hap dena, ");
INSERT INTO ury_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","hen wesya de lirak oson hap dena, te-alasa de hole-hle gwibin hip dena, aha zisi de taïl gïblïn hap dena, hen ahak-ahak tan hap dena, zi bosyansa de tonsublun hap dena, bola-bola gwen hap dena, nol drak-drak gwen hap dena, saher srëmkam de gwë gwen hap dena, hen zi bose zemka de anakare hap husus gweblan hap dena, ‘Zen en dawemsa gul iri.’ ");
INSERT INTO ury_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tïngare kirekam-kirekam karek enlalana in, zen enho nakon wet so gwenan. Zini zen diki dekon Alap mo nwenak ëkun gwe-gwenan.” ");
INSERT INTO ury_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesus dekam zep langna in kon zëre hon de ang tan wenya ban golësek gweka– ë darena Tirus hen Sidon mo lang san dep. Zëwe zi mo golak zep sowë enkam golëbïtï gweka– zi beya de anakan tawa gweblan srëm hap, “Zen mes awe hata zala.” Hwëna Zen toton banakan dep?– tawa gweblan srëmkam de hatan naye. ");
INSERT INTO ury_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Zep Yesus hom zëwe holo gweꞌanka, dekam zep hëndep wenya Zëbon hatazak. Wenya in Yahudi wesya hom. Zen Tirus mo lang nakorena, hen Yunani olsa de ton gwibinni. Zëno wenam tola mes dowal bi gwibirki, zep zen kim Yesussu anakan salblak, “Zen mes hatanda,” dekam zep hëndep zëno nwenak ïk gwe hezak. Dekon zep abe tasek, “Ano wenam tolsa emki dawem gun. Dowal mes tol bi gwibirki.” ");
INSERT INTO ury_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ki zep ding gulbirki, “Em Yahudi wesya hom! Ëe de emsa mas gwibinkim dekam sa hwëna nwe-mase gwer– san de Yahudi zi mo walas hap de tembanesa de lwa hap yal tazimdinni kiye.” ");
INSERT INTO ury_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ki zep hwëna ding gulbluk, “In eiwa, Bian. Dikire Yahudi walas tembane tak. Lwana hwëna meja ïltïkïnnïk sa teinikinser. Men zen walas ëk nakon altïꞌïk, zen desa sa hwëna dwenblandal. Zep em de asa mas gwibinkim, ki Yahudi walasna molya ëusak gwek.” ");
INSERT INTO ury_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesus ki zep ding gulbirki, “Sap kirekame dawemkam asa ding gulblunda, dowala in mes eno wenam tola kon wet sonda. Sap esa song gwera.” ");
INSERT INTO ury_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wenya in dekam zep gol san dep song gwek. Golak wenam zem insa anakan zep hlauꞌunzak, “Deyol dërenak sëwehen nik glang-glang gweꞌan, hen eiwa dowala in mes tangan zëbon onakon wet sola.” ");
INSERT INTO ury_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesus kim etan Tirus mo langna in kon zëre hon de ang ta gwen wenya ban golësek gweka, dekam Sidon mo lang san zep tamanka, hëndep Ho Gutuna Galilea san tineka, hëndep lang bosena Ëna Dare Taha-tap hataka. ");
INSERT INTO ury_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Zao zep zi i srëmna hen dawemkam de ol ton gwen srëmna Yesus onak dep nërhatazak, zao zep Yesussu abe dazak, “Bian, emki tahasa de tehabla inenkam dawem tan.” ");
INSERT INTO ury_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesus dekam zep zini insa zi beyana in kon zë-ere san dep zer halka, zao zep zëre mo taha bolsa zini in mo inik se soblan daka. Hen zëre mo tahanak ol tepsa tïpsïkï. Ol tepna inkam zep zini in mo mahala dra tablaka. ");
INSERT INTO ury_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ki zep hwëna nglï san kara gwe seka, deban ensasana langa tasïkï, ki zep zini insa Ibrani zëre mae mo olkam gubluka, “Efata.” Efata mo enlalana, “Em yak nën.” ");
INSERT INTO ury_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Zini in mo ini hëndep dekam zep yak nëblak. Mahala hen dekam zep jahalha gweblaka. Ola dekam zep hëndep dawemkam tonka. ");
INSERT INTO ury_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Etan kim zi beyana in osan dep zon ta zaka, zao zep jalse gwibiridaka, “Ëe ansa zini dawem tanan, etan bahem mae ëton naseran.” Hwëna kirekam sap jalse gwibirida gweka, zen hwëna man kim tangan sërkam ëton nasen gwek. ");
INSERT INTO ury_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tïngan men zen ësane gwek, man tangan sërkam denggwanblak. Zen man ëgu gweꞌak, “Eiwa, zini an wehasa hom, in zep ki kirekam dawem tabirida gwenda. Sap i matna, zen hëndep dekam sa ki ësane gwer. Sap ol srëmna, zen hëndep dekam sa ola ëton!” ");
INSERT INTO ury_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Zao hom tangan holo gweꞌak, ki zep zi beyam-byana Yesus onak dep tagal gwezak. Tembanena kim tap gwizimki, Yesus ki zep zëre hon de ang ta gwen wenyaka haen gwibiridaka, zao zep gubiridaka, ");
INSERT INTO ury_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ëe ama zi trana ansa dawemkam kwasang gwibiridaꞌan, sap zen mes dan-ahare yaklakam awe Asa nërgwëk, hëndep angkam zëno mae mo tembanena mes tangan tap gwizimdi. ");
INSERT INTO ury_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ëe de usak naban de sek gwen hap gubiridankam, zen sa hwëna ora san ëtïlsïk song gwer, sap ahakon an langa nakon yaïng gwezak.” ");
INSERT INTO ury_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Zëre hon de ang ta gwen wenya in ki zep ding nulblik, “Zi srëm langna awe, tembanena endawe esa ol?– dekam de zi beyam-byana ansa sul sonen hapye.” ");
INSERT INTO ury_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ki zep hwëna takensibiridaka, “Eno mae mo rotina banakaꞌen?” Ki zep ding nulblik, “Tuju enkam.” ");
INSERT INTO ury_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesus ki zep zi beyam-byana insa teinikin niran hap gubiridaka. Ki zep tujukam de rotina insa kap taka, dekam zep Alap hap dawemna golblaka, ki zep hwëna ahap tabirki. Desa zep zëre hon de ang ta gwen wenya kip etan-etankam kap ta gwizimꞌinka– zen dikim kae gwibin hip. ");
INSERT INTO ury_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Hogwe bete-tekna hen da-en zë nolaꞌak. Yesus etan hogwena in hap dawemsa Alap hap golblaka, ki zep hen gubiridaka– dekam de hen kae gwibiridan hap. ");
INSERT INTO ury_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kim dwenblandak, zen man tangan ëïtrï gwek. Mosrona kim tagam dak, yu yawal-yawala tuju enkam zep ësuwek. ");
INSERT INTO ury_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","In zen tembane tak beyana san ha empat ribu enkam mes yap. Yesus ki zep sekwak gwen hap gubiridaka. ");
INSERT INTO ury_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Zëna zëre hon de ang ta gwen wenya ban dekam zep hëndep Dalmanuta mo lang san dep bulkum golësek gweka. ");
INSERT INTO ury_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisikam de gubirida gwen zini ki zep Yesus hun de ol zerkeisa-keisa gwen hap yaïng gwezak. Zen dekam de akasïblïn hap anakan abe dak, “Emki nglï nakore owassa ap syal gwibir-zimdin. Zen dekam asa emsa anakan laïblïblal, ‘Zen eiwa Alap onakon hata zaka.’” ");
INSERT INTO ury_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus nonol enlala dowe hanan naban zep ensasana langa tasïkï, ki zep gubiridaka, “Em bap auhu-kama enlala zini nglï nakore owassa de ebe mae hap syal gwibir-zimdin hip Asa abe lal. Eiwa denakaë emsa gubiridaꞌan: Em makare zi hip Ëe bëjënë owassa syal gwibir-zimdin.” ");
INSERT INTO ury_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kirekam kim gubiridaka, ki zep zë hëndep hli yuluda guk halka. Bulkum zep zëre hon de ang ta gwen wenya ban men eihya san dep golëtablan gwe kïnïka. ");
INSERT INTO ury_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","In kim bulkum sek gwek, Yesus hon de ang ta gwen wenya hwëna hom tembanena sowe henkam kap dak. Rotina hwëna aha-en tol ing nuk. ");
INSERT INTO ury_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus ki zep ola gulk sun blaonzimki, “Dawem. Terya-tyakam lowehek. Farisi zi mo ragisa ema ing ulink. Hen Herodes moka ema hen ing ulink.” ");
INSERT INTO ury_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Zëre hon de ang ta gwen zini in hom anakan dam nulsuk, “Kire hap ki asa gubiridala,” zep hwëna zënaka donbiridaꞌak, “Nen home rotina bïtï lazal. In zep ki nësa gubiridala.” ");
INSERT INTO ury_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesus hwëna mes tawa gwibiridaka– insa zënaka donbiridaꞌak, ki zep gubiridaka, “Em ba habe roti bïtï tazan srëm hap enaka lonbiridaꞌan? Em ba hap tangane tame ul srëm gwe-gweꞌan?! Em in eiwa enlala joblo-topna. ");
INSERT INTO ury_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Em dwan nwena kike. Em ba habe hla kul srëm gwe-gweꞌan? Em dwan ini kike. Ba habe ëgwë gweꞌan?– san de ësan srëmna. Em san home enlala eibiꞌin? ");
INSERT INTO ury_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mensa aha-ere taha-tapkam de rotina lima ribukam de zi hip ahap tabir-zimk, dekam tembane mosrona kime tagam lasïk, yuna banakaꞌen ësuwek?” Ki zep ding nulblik, “Dua-blas enkam.” ");
INSERT INTO ury_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Hen mensa empat ribukam de zi hip tuju enkam de rotina ahap tabir-zimk, dekam tembane mosrona kime tagam lasïk, yu yawal-yawala banakaꞌen ësuwek?” Etan ki zep ding nulblik, “Tuju enkamke.” ");
INSERT INTO ury_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Dekam zep gubiridaka, “Ki em ba habe tame ul srëm gwer? Ëe san rotisa de bïtï tazan srëm habë emsa gubiridal.” ");
INSERT INTO ury_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Betsaidak kim yaïng gwek, zi nwe dïmïnnï ki zep Yesus onak dep nër halzak, zao zep abe dazak, “Bian, emki zi nwe dïmïnnï ansa tahasa tehabla inen– dekakim tol etan nwesa kara gweka.” ");
INSERT INTO ury_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesus ki zep ëna in kon tahakam ïrïk ta halka, zao zep oltepkam nwena insa dra soblaka, ki zep tahana nwenak tehabla ineka. Tahana insa kim teisyasïkï, ki zep hwëna takensïblïka, “Em wëhë dawemkam hlauludaꞌara?” ");
INSERT INTO ury_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Zini in dekam zep kara gweka, ki zep ding gulbluka, “Kië. Ëe kië zini kara tabiꞌin, hwëna san de te de ëtë naseranna kiye.” ");
INSERT INTO ury_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesus ki zep etan nwenak tahana tehabla ineka. Dekam tangan zep dawemkam kara gwen hap alp gweka. Dekam zep hëndep nwena in etan sërkam tangan dawem nëblak, hëndep lalak tangankam kïtak kara gweka– men kiye, dïmïn nëblan srëmnak kim gwëkake. ");
INSERT INTO ury_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesus dekam zep gubluka, “Dekam gol san song gwe. Hwëna ë san bahem tamaran, ki sa anakan ëtawa gwer, ‘Zen mes dawem tala.’” ");
INSERT INTO ury_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesus ki zep zëre hon de ang tan wenya ban ë bosena Kaesarea-Pilipi mo golek de san de ë-ë san golësek gweka. Oranak zep takensibiridaka, “Zi mo Asa de dam tasïnkïm, Ëe an nara mo weinak debë hatazak?” ");
INSERT INTO ury_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ki zep ding nulblik, “Ahakon man emsa nen gweblanan, ‘In baptis ta gwibin zini Yohanis Swe tïn nïkon etan ngaya gweka. In zen hwëna Yesuskum bosena li yul soneka.’ Hen ahakon man emsa nen gweblanan, ‘In Elia Bak mo weinak Alap mo olsa ayang gul gwizimꞌira.’ Hen ahakon man emsa enlala në gweblanan, ‘Zen diki ahanik mo weinak dep jowe zaka– men zen orep Alap mo ola ayang nul gwekke.’” ");
INSERT INTO ury_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ki zep etan takensibiridaka, “Hwëna ere mae mo Asa de dam tasïnkïm, Ëe an diki nara mo weinak dep dena?” Petrus zep ding gulbluka, “Bian, Em in Zen– Israelsa de ngaya tabin hip de Teipsïn nïye.” ");
INSERT INTO ury_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ki zep hwëna jalse gwibiridaka, “Asa insa kirekam dam lasïnïn, aha maesa hwëna bahem gubiridan.” ");
INSERT INTO ury_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesus ki zep kon gwisibir hanaꞌanka– zëre hon de ang ta gwen wenyaka de anakan tawa tabinkim, “Alap mo dwam gwibinni abe hap dena a kirekam sa lwal: Ngatan zi mo lang nakore Zi Tanganna Ëe karekna mam tangan naka asa goltower. Yahudi mo nol-nola ban, Alap mo golak de syal tan zi mo mam-mamna, hen Musa mo olsa de tawa ta gwibin zi niban sa Asa baes nëblal. Ki sa hëndep Asa dal. Hwëna yaklana dan-ahan, ki asa etan tïn nïkon ngaya gwer.” ");
INSERT INTO ury_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Zen dam-dam enkam kirekam gubiridaka– zen de karekkam dam gulsun srëm hap. Petrus ki zep hwëna Yesussu ora nakon de asyal hehan hap gubluka, zao zep anakan jalse gweblaꞌanka, “Em bap kirekam gulu! Kina ki bëjen kirekam lwan.” ");
INSERT INTO ury_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Hwëna Yesus ki zep lure san ahakore zëre hon de ang ta gwen wenyaka lero gwibiridaka, ki zep zëno mae mo inik Petrussu anakan jalse gweblaka, “Em in dowal mo kïgï! Ki lun em gwën. Eno kirekam de enlalana in Alap mo dwam gwibin sin denaka hom. Zen auhu-kama zi mo dena.” ");
INSERT INTO ury_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dekam zep Yesus zi trana insa hëndep zëre hon de ang ta gwen wenya ban haen gwibiridaka, ki zep zë gubiridaka, “Men nara Abon de ang gwe-gwen hap dwam gwenna, zen diki zëre mo gwënna zen eititi gwibin– dekam de zëre hap de te-lidak son wë son naban Asa zertronda gwen hapye, anakare enlala naban, ‘Ëe sap asa Yesus hun apdenak lïl.’ ");
INSERT INTO ury_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sap men zen de zëre mae mo auhu-kamanak de gwënna anakan nolaïrï gweꞌak, ‘Ëe babë Yesussu de ang gwe-gweblannak karekna goltowe gwen,’ ki zëno mae gwënna in sa jek-jak gwer. Diki men zen Asa de ang gwe-gweblan hap hen abe hap de ol dawemsa de gol halada gwen hap zëre mae mo gwënna sosok nul gweꞌak, hëndep zao mae de tïn hïp, zen zen sa hëndep denaban ëngaya gwer. ");
INSERT INTO ury_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","San ha dawemna?– em de sërkam te-ala beya gwenkam kïtak de okamana ansa bi gwibinni, dekam de hwëna ere mo gwënsa tïhïs gïn hïp. Kirekam dawem naka hom! ");
INSERT INTO ury_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tïnkïm san ha emaka te-ala beyana inkam ba maesa Alap hap golblaꞌara?– dekam de etan ngaya gwen hapye. Kina ki bëjen. ");
INSERT INTO ury_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Auhu-kamanak de zini man Alapsa hli da gwenan– dekam de dowal-dowalsa ang gwibirida nasen gwen hap, hen kirekam-kirekam kareksa dikim gulin halasen gwen hap. Hwëna Abon de ang gwe-gwen zini em de zëno mae mo ngïrïn nïkon anakan de gunsu saher gwenna, ‘Ëe Yesussu de ang gwe-gweblan zi,’ ki ngatan zi mo lang nakore Zi Tanganna Ëe kimë Bian mo ngatan naban hen soson naban zëno dam taha nakore zi niban golëyaïng gweꞌanzak, Ëe molyë hen emsa anakan kira tak, ‘Zini an eiwa Asa de ang gwe-gweblanna.’” ");
INSERT INTO ury_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ki zep etan gubiridaka, “Eiwa denakaë emsa gubiridaꞌan: Em an zene awe lowe heꞌan, em molye ahakon na-en juwek– Alap mo yakla yalak de zaun srëmnakye. Em esa Asa hla lal– Ëe kimë zëre mo soson yawala ban zëre mo bosekam de ïrïk gïn hïp hataꞌan zakye.” ");
INSERT INTO ury_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yaklana kim enam enkam damank, Yesus dekam zep zëre hon de ang ta gwen wenya Petrus, Yakobus, hen Yohanis mae en han zë-en kwatap yawal san dep golësek gweka. Hwëna dan-ahare zini in mo nwenak zep Yesus mo timni liwe heblak. ");
INSERT INTO ury_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Zëno pakeanna man tangan sërkam ngap-ngap nëblak hen man nalïlïngtïlblïꞌak. Okamanak de ngap-ngap kire-kirena, men ki ogom ngap-ngapna, zen man kïtak lwala heꞌan– zëno ngap-ngap nakonye. ");
INSERT INTO ury_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ki zep hwëna Musa Bak ne Elia Bak ne mumuk ennak jo kë zaka, hen Yesus hon de ang tan dan-ahare zini in ki zep zë nakek– zen kim Yesus hun ëraïsïl gweꞌanka. ");
INSERT INTO ury_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petrus ki zep hwëna Yesussu totoresa gubluka, “Bian, dawem tanganna– nen de awe lowehe gwen hapye. Zep ëe asa gol kluksa dan-ahan syal ëblandal– ahana Bian ere hap, ahana Musa Bak hap, hen ahana Elia Bak hap.” ");
INSERT INTO ury_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Hwëna Petrus insa kirekam gubluka, hyanak zëna man saher gwibiꞌinka, “O ëe an ba habë kirekam gublul!” Sap zen wal bose dare zem in han man sërkam ziaïrïꞌanka. ");
INSERT INTO ury_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hwëna butna ki zep zë wale tabirzik, hen butna iwe zep ola ësak, “An ano Tane– ëre mo dang tïnïnak de tanganna. Desa em sal gweblan.” ");
INSERT INTO ury_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Zen nabal-bakam zep sap men-san an-sankam ëkaratda gwendak, hwëna zi maena hom zë hla dak. Hwëna Yesus Zëna en naka zë hla dak. ");
INSERT INTO ury_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kwatapna in kon kim etan golëtine gweꞌanka, zao zep gubiridaka, “In desa ki ena hla kul, etan aha maesa bahem gubiridan– ngatan zi mo lang nakore Zi Tanganna Ëe de nama tïn nïkon ngaya gwen srëmnakye.” ");
INSERT INTO ury_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Zen man Yesus mo ol jalse gwibiridanna in san ang tak, hwëna zë-erenak zep zë-en anakan don gwibik, “‘Tïn nïkon de etan ngaya gwenna,’ zen banakarekam sa lwal? Nen home dam ulsuꞌun.” ");
INSERT INTO ury_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Dan-ahare zini in dekam zep hwëna dakensïblïk, “Elia Bak mes-am lwa hala. Ëe hwëna ama tim ul, ‘Zen sa Emsa ngeirbli zala.’ Sap Musa mo olsa de tawa ta gwibin hip de zini kirekam am ëgu gwenan, ‘Zen diki nonol Elia Bak sa etan lwahal zankam ngeirbli zala, ki sa hwëna nësa de ngaya tabin hip de Zini hata zala.’” ");
INSERT INTO ury_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus ki zep hwëna ding gulzimki, “In sap eiwa kirekamke. Elia zen sap kirekam-kirekamsa de nonol sul sone gun hup de zini zen– Israelsa de ngaya tabin hip de Zini Ëe de hwëna kirenak hatazan hap. Hwëna Alap mo ola ahana hen ki, kirekam de hen Abon jowen hap dena– men zen anakan lwakye, ‘Ngatan zi mo lang nakore Zi Tanganna sa baes nëblal, hen karekna mam tangan naka sa goltowe gwera.’ ");
INSERT INTO ury_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Hwëna ëe ama emsa gubiridaꞌan, Elia zen sap mes eiwa Asa ngeirbli zaka, hwëna zini zëre mae mo dwam gwibin sin kirekam-kirekam karek-karek ensa nol gweblak– men kirekam hen zëbe hap dena Alap mo olak hamal hap lwakke.” ");
INSERT INTO ury_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesus kim etan zëre hon de ang ta gwen zi dan aharena in han golëlwandahal zaka– ahakore zëre hon de ang ta gwen wesyan dep, hwëna zi beyam-bya naban zep zë hla nulidaꞌak. Musa mo ol tawa ta gwibin wenyik zë Yesus hon de ang ta gwen wenya in han nolëol tetek gweꞌak. ");
INSERT INTO ury_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hwëna Yesus Zënaka kim hla da guk, ausa zep anakare hap nohlo gubluk, “Zëna man hataꞌara.” Dekam zep hut tu ane gun hup ëhlu-hluk gwezak. ");
INSERT INTO ury_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesus ki zep takensibiridaka, “Em ba habe ëol tetek gwesan?” ");
INSERT INTO ury_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Hwëna zini ki zep zi trana in kon ding gulbluka, “Bian, ëe ëre mo walassaë ebon dep zer halzal. Dowal tïl gweblanda, zep tol ol srëm gweka. ");
INSERT INTO ury_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Dowala in kim tïl gweblanda, dekam zep ëk tutum nuban kamanak zënaka zerheir isen gwenda. Ëkna dekam zep hen ngalk-ngalk so gwenda, hëndep dekam zep tïngare timni kyang-kyang gwe-gwenda. Ëe mesë sap ere hon de ang ta gwen wenya zeralsa sonen hap gubiridal. Hwëna man sap nakablal.” ");
INSERT INTO ury_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesus ki zep gubiridaka, “Eiwa, angkam de zini em ei nibarena hom tangan! Ëe san ëse nakaë sap emsa golëlowehe gwek?! Ëe ama bae– eban mae de holokam golëlowehe gwen naye. An san emki walasna insa zerhalzan.” ");
INSERT INTO ury_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ki zep nër halzak. Dowala in kim Yesussu hla taka, dekam zep walasna insa yal-yal taka, ki zep hëndep kamanak zerheirki, zao zep ëk tutum nuban ololo gweꞌanka. ");
INSERT INTO ury_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesus ki zep bi zemka takensïblïka, “Dowala in bawalkam kon gwesïblï hanaka– kirekam de gwë gweblan naye?” Ki zep ding gulbluka, “In beteknak ki hëndep tïl gweblaka. ");
INSERT INTO ury_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Dowala in syauknuk de zerheir gwenna mes beya taka– hen honak de keing ta gwen naye. Zen kire tangankam tan hap am ki gwëblaꞌara. Hwëna eno soson de kirekam lwablankam, emki tol asa kwasang gwizimdin hen mas gwizimdin.” ");
INSERT INTO ury_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus ki zep hwëna jalse gweblaka, “Ha! Em bap kirekam Asa gublula, ‘eno soson de kirekam lwablan’kamye? Ki em home Asa taïblïblaꞌara. Em de Asa taïblïblankam kina ki banakare maena man?– Ëe de ebe hap syal gwibir-blin srëm hap denaye!” ");
INSERT INTO ury_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bi zem in dekam zep hëndep ol mamkam gu aneka, “Ëe sap ama Emsa taïblïblaꞌan, hwëna sowehen tangankam homë. Emki ano Emsa de taïblïblansa ap esek gul seblan!” ");
INSERT INTO ury_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesus kim hlauludaka, “Zini angkam man hlu-hluk gwe-gwe zankam Asa dot dasïꞌïn,” ki zep dowala insa gubluka, “I srëm hen ol srëm dowal, walasna an kon em wet son. Bahem etan tïlblïn.” ");
INSERT INTO ury_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dowala in ki zep hërheka, etan ki zep walasna insa karek tangankam yal-yal taka, ki zep hëndep zëbon onakon wet soka. Walasna in tok makan zep zë lwaꞌanka. Zi beyam-byana in dekam zep nenblak, “In mes tïlïda.” ");
INSERT INTO ury_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Hwëna Yesus ki zep taha nakon de zer inenkam lï taka. Dekam zep hëndep dawem gweka. ");
INSERT INTO ury_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesus kim zë-en golak gwëꞌanka, zëre hon de ang ta gwen wenya dekam zep zë-en du nëblazak. Zao zep dakensïblïk, “Bian, ëe ba hap tanganë dowala insa ëralsa sone srëm gwer?” ");
INSERT INTO ury_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ki zep ding gulzimki, “Kirekam de dowala, toton banakare aha maekam bëjen zeralsa sonen. Zen aha-en diki Alapsa de abe ta gwen enkam de zeralsa sonen.” ");
INSERT INTO ury_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesus dekam zep zëre hon de ang ta gwen wenya langna in kon golësek gweka, Galilea san zep golëtaman gweka. Zen hom dwam gweka zi de anakan tawa gweblan hap, “Yesus zëwe gweꞌara.” ");
INSERT INTO ury_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Sap Zen dekam dua-blaskam de wenya in ensa tawa ta gwibiꞌinka. Zen anakan tawa ta gwibiꞌinka, “Ngatan zi mo lang nakore Zi Tanganna Asa sa jal zi mo tahanak dep tapbla dazim. Zen sa hëndep Asa dal, hwëna yaklana dan-ahan ki asa etan tïn nïkon ngaya gwer.” ");
INSERT INTO ury_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Hwëna zëre hon de ang ta gwen wenya hom tame nul gweꞌak– insa kirekam tawa ta gwibiꞌinkaye. Hwëna takensïblïn hap man naïrïblak. ");
INSERT INTO ury_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kapernaumk kim dua-blaskam de zini insa golëyaïng gweka, golak kim golëbïtï gweka, zao zep takensibiridaka, “Em oranak basae ol eibir sinzal?” ");
INSERT INTO ury_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Zen hwëna man nasalsïblïk, sap oranak zen eiwa man mae hap ëol gwezak, “Diki ëe amaka nëre mae onakon mam gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesus ki zep tagal gwesïn hïp gubiridaka. Zëna dekam zep nikin aneka– dekon de tawa tabin hip. Ki zep gubiridaka, “Kïtak ësane gwek. Zi de Alap mo ïrïk gïnnïk mam gwen hap dwam gwenna, zen diki tïngare zi mo babu gwen zi makan zen gwën. Zen dekam sa Alap mo nwenak mam gwera.” ");
INSERT INTO ury_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ki zep hwëna walas tola haen gweblaka, dekam zep zëno mae mo nwenak de zaun hup gubluka, zao zep babang tan naban gubiridaka, ");
INSERT INTO ury_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Zini men zen de ano bose hap aha zisi mas gweblaꞌanka– sap anakare walas tol maesa, Ëe asa desa enlala gweblal, ‘Zen Asa mas gweblaꞌara.’ Hen zi de Asa mas gweblanna, Alap men Zen Asa zer soneka, Zen sa desa hen enlala gweblala, ‘Zen hen Asa dekam mas gweblaꞌara.’” ");
INSERT INTO ury_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ki zep hwëna Yohanis gubluka, “Bian Guru, ëe zisië hla lak– eno bosekam de dowalsa golëalsa sone gwennak. Ëe zebë jalse ëblak, sap zen nëbon mae de ang gwe-gwen naka hom.” ");
INSERT INTO ury_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ki zep hwëna gubiridaka, “Em bap jalse ëblak, sap zi de ano bosekam owassa syal gwibinni, kirekam de zini bëjen nabakam Asa lamang tan. ");
INSERT INTO ury_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sap zini men zen nësa baes neibirida srëm gweꞌan, zen zen– nëbon mae onak dep denaye. ");
INSERT INTO ury_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Eiwa denakaë emsa gubiridaꞌan: Zi de ano bose hap emsa mas gwibiridanna– aha-ere ho mok mae tolsa de anakare enlala naban golblankam, ‘Zen Kristussu de ang gwe-gweblanna,’ ki Alap sa zëbe hap hen dawemna lamkam golblala. Zen molya golbla srëm gweka. ");
INSERT INTO ury_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Men nara Asa de taïblïblan zisi, sap hen anakare walas betek maesa, karek san dep zertoranna, zen dikim hwëna Asa hli tan hap, kire zini Alap sërkam tangan sa karek tala. Diki dawemna, zen maka zertoran srëmnak karekkam de tïnsï hlaulku. Kaso dohon-honsa de holenak hule soneblan naban de hi tateknak hiri tan maekam, ki zen molya karek san dep zertonnanam, hen Alap molya karek taꞌanam. ");
INSERT INTO ury_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Emsa de ere mo aha taha anakan tïtï da gweꞌanam, ‘Haen, karekna ansa nen on,’ diki dawemna em blansïn. Sap eme dare taha naban zigwëꞌanka, ki esa hëndep Asa hli tala. Ki hwëna tïnsïn srëm syauknuk esa hëndep denaban gwë gwera. Blansïnkïm ki emaka sam gwesïꞌïra– aha-ere taha naban de Alap onak gwë gwen hapye. ");
INSERT INTO ury_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Hen kirekam, emsa de ere mo aha tana anakan tïtï da gweꞌanam, ‘Kareksa de gon hap nen song ën,’ diki dawemna em blansïn. Sap eme dare tana naban zigwëꞌanka, ki esa hëndep Asa hli tala. Ki hwëna tïnsïn srëm syauknuk dep sa emsa hiri daser. Blansïnkïm ki emaka sam gwesïꞌïra– aha-ere tana naban de Alap onak gwë gwen hapye. ");
INSERT INTO ury_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Hen kirekam, emsa de ere mo aha nwe tïtï da gweꞌanam, ‘Haen, nen karekna wakinsa karatda un,’ ki nwena insa em alsïn. Sap eme dare nwe naban zigwëꞌanka, ki esa hëndep Asa hli tala. Ki hwëna tïnsïn srëm syauknuk dep sa emsa hiri daser. Men zëwe kirekam de zini yal nulse gwenan, ‘zao blëna hëndep denaban zëno mae mo timni hlok dasïk gwibirin, hen zen man hëndep denaban syauk sal-sal ngïrïn nïkon sang-sangna neis gwibirin.’ Alsïnkïm emaka sam gwesïꞌïra– aha-ere nwe naban de Alap onak gwë gwen hap, Zen kim de kïtak ïrïk gïꞌïnkaye.” ");
INSERT INTO ury_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yesus ki zep gulk sun de ol blaonzimdinni dan mas sozimki: “Zep zini tïngan syauk sal-sala sa neis gwibir. Ahakon okama ennak sa neis gwibir. Hwëna ahakon, zen hëndep de tangan naban sa neis gwibir. ");
INSERT INTO ury_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Em an zene Abon onak ang ta gweꞌan, em okamanak san de hina kiye. Hina zen sap tembanesa de dërek gun hup dawemna. Hwëna blëble gwenkam, dekam tembanesa dikim dërek gun hup dena man hom gwe-gwenan. Hwëna em bahem hi mo kim dërekna ëhom gwen. Ki hwëna em molye aha-ere enlalakam lowehe gwek.” ");
INSERT INTO ury_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesus dekon Yerusalem mo lang san zep zëre hon de ang ta gwen wenya ban golësek gweka, hen weyana Yordan mo men eihya san de lang san dep golëtablan kïnïka. Zi beyam-byana zao zep etan Zëbon dep yaïng gwe-gwezak, zao zep etan tawa ta gwibirki– men kirekam gwë gwekake. ");
INSERT INTO ury_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farisikam de gubirida gwen zini hen man Yesussu de akasïblïn hap yaïng gwezak. Ki zep dakensïblïk, “Em banakane Musa mo tïtï tabin ola dam gulsuꞌura? San ha zini we zemka sap de baes gwibinkim? San ha bëjen?” ");
INSERT INTO ury_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ki zep ding gulzimki, “Musa ki banakan kire hap nësa tïtï tabirki?” ");
INSERT INTO ury_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ki zep ding nulblik, “Zen anakan tïtï tabirki, ‘Zini we zemka sap de baes gwibinkim, hwëna nonol baes gwibin hip de suratsa de anakan ale gunkum, “Ëe mesë kire hap baes gwibik.”’” ");
INSERT INTO ury_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ki zep hwëna gubiridaka, “Em in kïtak kwasang enlalana tawa naka hom, in zep Musa kirekam ein ebe mae hap ale gulzimki. ");
INSERT INTO ury_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Hwëna diki Alap mo dwam gwibin tanganna, zen diki men kirekam okamana ansa de yang gulsun nukon lwakke, ‘Alap nonol tanganna zi niban wenya ban yang sosuku.’ Hen Zen dekam anakan guku, ");
INSERT INTO ury_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Zini an-bi zemka hli sonkam– dekam de we zeban aha-en ën hapye. ");
INSERT INTO ury_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","We-zi darena in dekam Alap mo nwenak san de aha-ere timni kiye.’ In zebë emsa gubiridaꞌan: Alap mo nwenak we-zi darena zen dan hom. Zen hwëna aha-en. ");
INSERT INTO ury_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Zen in zep, Alap mensa aha-en sonna, zi bap zen etan kles son.” ");
INSERT INTO ury_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Golak kim golëbïtï gweka, zëre hon de ang ta gwen wenya zao zep etan we baes gwibin hip dena insa dakensïblïk. ");
INSERT INTO ury_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesus ki zep ding gulzimki, “Zi de we zemka baes gwibinni, hwëna ahanaka de etan gonkam, dekam Alap mo nwenak zen mes nonol we zemka yane-ne gulku, hen zëna kahalonak gwë gweꞌara. ");
INSERT INTO ury_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Hen kirekam, we de zi zemka baes gweblanna, hwëna ahanaka de etan zenkam, zen hen dekam Alap mo nwenak mes zi zemka yane-ne tak. Zëna kahalonak gwë gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Zini dekam man walas zemka Yesus onak dep kap nulhal gweꞌanzak– Zen de tahasa tehabirida ine gwen hap. Hwëna zëre hon de ang ta gwen wenyik anakan jalse neibirida gweꞌak, “Walasna bahem an san kap gulhal gwezan. Bahem Gurusa blostablan.” ");
INSERT INTO ury_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Hwëna Zëna kim hlauludaka, ki zep anakare ola ban jal gwibiridaꞌanka, “Em bap jalse eibiridal. Dikire walasna Abon nolëyaïng gwe-gwezak. Bahem jalse gwibiridan. Sap walasna an makare wenya, zen zen Alap mo ïrïk gïnnï bi neibiꞌin. ");
INSERT INTO ury_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Eiwa denakaë emsa gubiridaꞌan: Men zen de walas bete-tekna an mo kim Alapsa anakan daïblïblaꞌak, ‘Zen eiwa ano teipsïnnï,’ zen zen Alap mo ïrïk gïnnïk bïtï gweꞌan. Men zen de kirekam daïblïbla srëm gweꞌak, zen molya Alap mo ïrïk gïnnïk bïtï gwek.” ");
INSERT INTO ury_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ki zep hwëna walas tane-nena insa babang tabin niban tahana tehabirida ine gweꞌanka– anakan de Biansa abe ta gwen naban, “Bian, walasna an hap dawemna gol gwizim.” ");
INSERT INTO ury_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesus kim etan dekon song gweꞌanka, zini ki zep hwëna Zëbon osan dep hluwe zaka, zao zep zëno nwenak boklena kom so zaka, ki zep kon gu seblaka, “Bian Guru, em aïrïs. Ëe basa asa syal gwibir?– ëe dikim hëndep de gwën hap denaka gul irin hipye.” ");
INSERT INTO ury_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ki zep ding gulbluka, “Diki aïrïs aha-en tangan Alap Zë-en. Zep em Asa banakane enlala gweblaꞌara? ");
INSERT INTO ury_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Em dwan mes-eme sap Musa mo tïtï tabin ola tawa gwibirki– men zen anakan lwakye: ‘Zini bahem tan. Bahem kahalo gwen. Bahem sowë gwen. Zisi bahem boton hap klak tan hen boton olsa bahem gol hala seran. Zisi bahem lwa tasïn.’ Hen, ‘Ane-biasa em blikip gwesïk gwizimdin.’” ");
INSERT INTO ury_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Zini in ki zep ding gulbluka, “Guru, ëe beteknakë ki hëndep desan ang gwe-gwek, hëndep angkam namaë desan ang gwe-gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus hwëna embwan naban zep hla taka, deban zep gubluka, “Hwëna aha-en tangan lwa kïnïꞌan– em de desan ang gwen hap denaye: Em song gwen, ere mo kire-kirena kïtak tangan te-ala hap lirak tabir. Te-alana desa tahalha zi hip kae gwebla-zim. Kirekame syal gwibiꞌinka, ki ngatan zi mo langnake hëndep de te-alasa beyakam lam taꞌara. Ena dekam etan hataza– Asa dikim ang gweblan hapye.” ");
INSERT INTO ury_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kirekam kim salblaka, dekam zep kon enlala dowe hanan naban song gweka– mae hap: Sap zëno kire-kirena beya tanganna. ");
INSERT INTO ury_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesus ki zep hwëna zëre hon de ang ta gwen wenya insa nwekam amjanbirki, ki zep zë gubiridaka, “Eiwa, gwa-gwa tanganna– te-ala beya zi de Alap mo ïrïk gïnnïk hatan hapye!” ");
INSERT INTO ury_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Zëre hon de ang ta gwen wenya in man tangan Yesus mo ola insa denggwanbiꞌik. Dekam zep hwëna etan gubiridaka, “Ano walas, eiwa dam-dam naka hom– Alap mo ïrïk gïnnïk de hatan hapye. ");
INSERT INTO ury_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Te-ala beya zi de Alap mo ïrïk gïnnïk tïn hïp dena, zen men kiye– unta yawal de jaron hul betek san tïnnï. Kire otweran yawala toton bëjen tïn.” ");
INSERT INTO ury_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kirekam de ësane gwenkam, zen man etan sërkam ëtenggwank, dekam zep zënaka dakensibiridak, “Hare eiwa kire tangankamke! Ki hwëna endan nik sa ëngaya gwer? Toton nara molya.” ");
INSERT INTO ury_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus ki zep hwëna nwekam de amjanbin niban ding gulzimki, “Eiwa, auhu-kama zini zëre mae mo sosonkam bëjen zënaka ngaya tabin. Hwëna Alap de zi hip syal gwibir-zimdin srëm hap dena, aha-en mae hom tanganke.” ");
INSERT INTO ury_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petrus zep hwëna takensïblïka, “Ki hwëna abe mae hap dena bankarekam sa lwal? Sap ëe mesë ëre mae mo tïngare bi gwibinni Emsa de ang gweblanda gwen hap hli kulidak. Zep ëe basa asa lamkam ulin?” ");
INSERT INTO ury_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ki zep ding gulbluka, “Eiwa de tangan nakaë emsa gubiridaꞌan: Zini men zen Asa de ang gwe-gweblan hap hen Alap mo ol dawemsa de gol halada gwen hap zëre mae mo bi gwibin kire-kirena hli nulida gweꞌak, zëbe mae hap sa Alap mam en tangankam kap ta gwizimdi. Zen mensa hli tandan naye– sap gol zem, aya-wal oso-wal zem, an-bi zem, walas zem, hen sap nga maena, ");
INSERT INTO ury_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","zëbe mae hap sa Alap nama de okamanak lowehe gwennak sërkam de beya tangankam hen hëꞌho gwibin tangan wenyaka etan lup gul gwizimdi– sap aya-wal oso-walkam de gubiridan wenya, ane-biakam dena, walaskam dena, sap gola, hen nga maena. Hwëna kire zisi, zini hen sa abe hap de jal hap karek da gwibir. Hwëna Alap kim de kïtak ïrïk gïnkïm kon gwesibir hanaꞌanka, Zen dekam sa hen zëbe mae hap hëndep de ëngaya gwen hap dena golzimdi. ");
INSERT INTO ury_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Hwëna beyana men zen sap angkam bose naban lowehe gweꞌan, zen zen sa hwëna lamkam lure san ëgwër. Hen men zen angkam bose srëm wenya lowehe gweꞌan, zen zen sa hwëna lamkam ngein sin ëgwër.” ");
INSERT INTO ury_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesus kim zëre hon de ang ta gwen wenya ban Yerusalem san dep golëyaïng gwe seꞌanka, Zëna man ngeirki. Dua-blaskam de zëre hon ang ta gwen wenya aïrïn hïp enlala nik ëbeya gwen daꞌak– mae hap, “An banakan wëhë Yesus hup de jal hap Yerusalemk lwaꞌak?” Lun kon men zen hen ang tan daꞌak, zen hen aïrïn nïban ang tan daꞌak. Yesus ki zep dua-blaskam de wenya in ensa engka en golësyalhe halka, zao zep zëre hap dena hamal hap anakan tonbiridaꞌanka, ");
INSERT INTO ury_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ola ansa emki ësan: Nen angkam Yerusalem san debe yaïng gwe seꞌan. Zëwe sa ngatan zi mo lang nakore Zi Tanganna Asa tapbla dazim– Alap mo golak de syal tan zi mo mam-mam wenya kip, hen Musa mo olsa de tawa ta gwibin wenya kip. Zen sa hwëna Asa de tan hap ola aha-en nul, hëndep Asa sa Yahudi srëm zi mo tahanak dep tapbla dazim. ");
INSERT INTO ury_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Zen sa hwëna Asa lamang da gwer, hen oltepkam hol-hol da gwer, hen sa Asa dangole gwer. Ki sa hëndep Asa dal. Hwëna yaklana dan-ahan, ki asa tïn nïkon etan ngaya gwer.” ");
INSERT INTO ury_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ki zep Zebedeus mo walas darena Yakobus ne Yohanis ne Yesus hon apta zaka, ki zep zë enblaka, “Bian Guru, ano nik mo enlalana man lwaꞌara– em de kirekam abe nikip syal gwibir-zimdin hip.” ");
INSERT INTO ury_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ki zep takensizimki, “Em basae dwam eibiꞌira?– Ëe de desa ep syal gwibir-zimdin hipye?” ");
INSERT INTO ury_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ki zep ding ulblika, “Em kime teipsïnkïm ïrïk gïꞌïnka, ëe ama dwam ëꞌan– eno dam-taha irgwa-taha nakon de hen teipsïnkïm inikirin hip.” ");
INSERT INTO ury_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesus ki zep ding gulzimki, “Hwëna ena home tame uꞌira– in zebe abe ëndaye. Karek yawala men desa Ëe goltoweꞌak, em wëhë desa de hen oltowen hap hohle ëꞌara? Ëe men kire dohon-hon nakaë wei yuꞌuk, em wëhë hen desa de hen wei kun hip hohle ëꞌara?” ");
INSERT INTO ury_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ki zep ding ulblika, “Ëe ama hen hohle ëꞌan.” Zao zep etan guzimki, “Eiwa, em hen esa tol oltowera– Ëe men kiresaë goltoweꞌakye. Hen Ëe men kire dohon-hon nakaë wei yuꞌuk, em hen kire naka esa lamkam wei kuli. ");
INSERT INTO ury_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Hwëna men zen de ano irgwa taha nakon hen dam taha nakon inikinꞌinka, desa Ëe bëjënë dam sosun. Zëwe de inikirin hip dena, zen diki ano Bian Zëna mensa dam sosuku, zen diki zen sa zë inikiri.” ");
INSERT INTO ury_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hwëna dare taha-tapkam de ahakore ang ta gwen wenya in kim zëno nik mo abe lan ola insa ësak, zen man tangan sïsngïn neizimꞌik– mae hap, “Zen bap zen de mam ën hap abe lala!” ");
INSERT INTO ury_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesus ki zep tïngan tagal gulsuku, zao zep gubiridaka, “Ena dwan tawa nakake, Alapsa de tame tan srëm lang-langnak men zen anakan zënaka tim di gwibirin, ‘Ëe an teipsïnnï,’ zen man zëre kore naka jap nul sonenda gwenan hen nyaubirida gwenan. ");
INSERT INTO ury_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Hwëna em zëno mae mo kim bahem. Ebon mae onakon men zen mam gwen hap dwam gweꞌara, zen diki tïngare zi mo babu gwen zi makan zen gwën. ");
INSERT INTO ury_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Hen ebon mae onakon men zen teipsïn hïp dwam gweꞌara, zen diki tïngare zi mo tana ïltïkïnnïk zen nikirin. ");
INSERT INTO ury_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sap ngatan zi mo lang nakore Zi Tanganna, Ëe an zi de Asa babu gweblan hap homë hatazak. Zep em hen ano tana wei san emki Asa zertro gwen. Sap Ëe tïngare zi mo tana ïltïkïnnïk de nikirin hibë hatazak– hëndep ëre mo angsa de tïngare zisi dikim hïl tï sonebin hip sosok tazimdin hip.” ");
INSERT INTO ury_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus kim zëre hon de ang ta gwen wenya ban Yerikok golëyaïng gweka, hen ahakore zi tra naban, dekon kim etan ëgwa haꞌak, hwëna zi nwe dïmïnnï ora alpnak nikinꞌinka. Zëno bosena Bartimeus, Timeus Bak mo tane. Zen te-ala hap kon aberbe ta sone gwibirki. ");
INSERT INTO ury_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Zen kim salka, “In Nazaret walya men Yesus tamanꞌara,” dekam zep taken soneblaka, “Yesus, Daud Bak mo Auyan-tane, asa tol kwasang gwebla.” ");
INSERT INTO ury_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Hwëna zi beyana in jalse nëblak, “Balkkam.” Hwëna zen mam tangankam kim taken sone gweꞌanka, “Daud Bak mo Auyan-tane, asa kwasang gwebla!” ");
INSERT INTO ury_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesus dekam zep zausuku, ki zep gubiridaka, “Em kwang tan.” Kim kwang daꞌak, zao zep nenblak, “Em luwen, hen emki sëwehen! Yesus man emsa gublunda– zëbon osan de song gwen hap.” ");
INSERT INTO ury_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Zi nwe dïmïnnï in dekam zep nabal-bakam de luwesïk ane kïnïnkam deyol utuknu hiri gulin guk halka– Yesus osan dikim song gwen hap. ");
INSERT INTO ury_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus ki zep takensïblïka, “Em basae dwam gwibiꞌira?– Ëe de desa ebe hap syal gwibir-blin hapye.” Ki zep ding gulbluka, “Bian guru, ëe ama tangan nwesa de kara gwen hap dwam gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ki zep ding gulbluka, “Angkam sap esa song gwera. Em mese Asa taïblïblala, in zebe dawem gwenda.” Dekam zep ki hëndep nwena kara gweka, dekam zep ora san Yesussu ang gwe sebla halka. ");
INSERT INTO ury_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesus kim Yerusalemsa zigolek de taꞌanka, nonol zaitun tra nabare kwatap teknak de ë darena Betania hen Betfagek zep golëyaïng gweꞌanka. Dekon zep zëre hon de ang ta gwen wenyaka dan-dan guzimki, ");
INSERT INTO ury_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Em ëna wakin san song ën. Kime aptaꞌan haka, zao esa hëndep keledai tanena da tablan naka hla lala– zi mo zersong gwen srëm naka. Desa hïl lï-in halza. ");
INSERT INTO ury_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Zi de emsa takensizimdinkim, ‘Em ba habe hïl lïꞌara?’– a kirekam ding ulzim, ‘Bian dwam gweblaꞌara. Zen sa etan nabakam zer sone zala.’” ");
INSERT INTO ury_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kim song ëka, ki zep hëndep keledai tanena insa hla laka– ora alpnak da dablak, lïlïkïn golek denak. Zao zep hëndep hïl lï inki. ");
INSERT INTO ury_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Zini men zen zao ëzauꞌuk ki zep dakensizimk, “Em ba habe hïl lïꞌara?” ");
INSERT INTO ury_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yesus men kirekam guzimki, kire enkam zep ding ulzimki. Dekam zep nenzimk, “Amki.” ");
INSERT INTO ury_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ki zep hëndep ërlwa halka. Kim ërhataka, keledai mo tahan dannak zëre mae mo tahan bajusa zep kang dasek. Ki zep zë hwëna Yesus sewe seka. ");
INSERT INTO ury_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Hen zi beyam-byana in baju zemka ora san dëre dahak– desan de keledai tanena in Yesussu zersong gwen hap. Hen ahakon yera ala makare naka ora alp san nublun gweꞌak, desa zep hen ora san dëre dahal gweꞌak. ");
INSERT INTO ury_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Zini men zen nangeirblin daꞌak hen lun ang nëblan daꞌak dekam zep ëtaken gweꞌak, “Hëꞌho, hëꞌho! An Bian mo bosekam nësa dikim oto gulsun hup hata seꞌara. Hëꞌho! Diki Alap Zen zëbe hap dawemsa golblan. ");
INSERT INTO ury_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Diki Alap Zen teipsïn zini Daud Bak mo Auyan-tanena ansa mas gweblan– Zen dekakim tatetekam ïrïk gïlkï. Hëꞌho! Nen kïtak teipsïn tangan Zini Alapsa boltere tan!” ");
INSERT INTO ury_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesus kim hëndep Yerusalemk hata seka, Alap mo golak zep hëndep tïlkï. Zao kim amjanbiri senꞌanka, hwëna man zë nabakam kaweꞌak. Dekam zep kon etan dua-blaskam de ang ta gwen wenya ban Betania san dep golësek gweka. ");
INSERT INTO ury_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Zao de yaklanak kim Betania kon etan Yerusalem san dep golëlwanda haꞌan zaka, Yesus dekam zep usak gweꞌanka. ");
INSERT INTO ury_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Langa nakon zep tenya arana hlaul inki. Alana bu-bung tangan nik zauꞌuk. Dekam zep mae hap syal hebirki, “Eini wëhë.” Hwëna eini aha-en mae hom hlaulku. Ala enna, sap tenya ara mo tën tamlenak hom dekam zauꞌuk. ");
INSERT INTO ury_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ki zep arana insa anakan gubirki, “Eno eini angkam hëndep molya dwinbik.” Zëre hon de ang ta gwen wenya dekam zep nasalblak. ");
INSERT INTO ury_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yerusalemk kim etan yaïng gwek, Yesus Zëna dekam zep etan Alap mo golak tïl zïka. Dekam zep kon men zen Alap mo gol tëmnak Alap hap de golblan kire-kirena te-ala hap lirak da gwibik, desa golëalsa soneka. Meja-mejana men zao te-alana lirak da gwibik, hen komal-tum komal-tum maena men dekon mawa oholana lirak da gwibik, desa man kïtak yal tazimki. ");
INSERT INTO ury_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tïngare zini dekam zep jalse gwibiridaka, “An orasa hom! Alap mo gola an san bahem ba maesa de teiredan naban taman gwe-gwezan!” ");
INSERT INTO ury_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ki zep zë hwëna tawa tabirki, “Alap mo olak man lwak: ‘Ano gola sa nen gwibir, “An tïngare zi ausu dekon Biansa gu sone gweblan hap de gol.”’ Em an hwëna ‘sowë zi mo aning gol habe li kul sone gweꞌan.’” ");
INSERT INTO ury_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Alap mo golak de syal ta gwen zi mo mam-mamna hen Musa mo olsa de tawa ta gwibin wenya kim Yesus mo kirekam de gweibiridanna insa ësak, dekam zep tan hap orana dëblaꞌak. Hwëna mae hap zë bung neisïblïk, “Zi trana an sa hwëna zerzaunkum nësa karek dabir.” Sap zi trana in man tangan Yesus mo tawa tabinni insa sam neisibir-blik, hen man tangan denggwanbik. ");
INSERT INTO ury_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kim kaweꞌak, Yesus dekam zep zëre hon de ang ta gwen wenya ban Yerusalem kon etan golësek gweka. ");
INSERT INTO ury_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kaꞌankam kim etan kak tangannak ara ausuna in san golëtaman gweꞌanka, dekam zep hla nuk, “Zen mes tangan hëndep sa nakon sasan gwesïkser.” ");
INSERT INTO ury_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petrus dekam zep enlala gwibirki– in zen ki ir jowek, dekam zep Yesussu gubluka, “Bian, emki hlaun! Em mensa arana ir heip gulku, zen mes tangan hëndep sasan gwer.” ");
INSERT INTO ury_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ki zep ding gulzimki, “Alapsa em taïblïblan. ");
INSERT INTO ury_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Eiwa denakaë emsa gubiridaꞌan: Eme Alap ensa tïngare enho naban anakan laïblï gweblaꞌak, ‘Zen sa kirekam abe hap syal gwibir-blira,’ ki em hen esa sërkam de owasna syal ei gwibir. Eme dekam Alapsa abe la gweꞌak, ‘Kwatap tekna an zen hinak zënaka ter sonen,’ zen hëndep kirekam maka Alap ebe mae hap syal gwibir-zimꞌira– em de taïblïblankamye. ");
INSERT INTO ury_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Zen in zebë emsa gubiridaꞌan: Em de ba mae hap Biansa abe ta gwenkam, anakan em taïblï gweblan, ‘Zen mes ap golblanda.’ Zen dekam sa hëndep ep golblala. ");
INSERT INTO ury_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Hen em de Alapsa abe tan hap enlala gwenkam, zi bose omka de taïl gïblïn naban bahem. Nonol em zi bose uk mo ep de karek golblanna insa eititi gwibir-blin. Ki ere mo ngatan zi mo langnak de Bian dekam sa hen eno karek-karekna ep tap gulsublula.” ");
INSERT INTO ury_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesus ki zep etan Yerusalem san dep golëlwanda halka. Alap mo gol tëmnak kim të nasenꞌanka, dekam zep hen Alap mo golak de syal ta gwen zi mo mam-mamna, Musa mo olsa de tawa ta gwibin wenya, hen Yahudi mo nol-nola ban Zëbon onak dep yaïng gwezak. ");
INSERT INTO ury_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Zao zep dakensïblïk, “Emsa an nara gubluka, hen nara emsa trï tase gweꞌara?– dekam de kirekam-kirekamna insa syal gwe-gwibin hipye.” ");
INSERT INTO ury_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Ki zep ding gulzimki, “Ki Ëe asa hen nonol emsa takensibiridal: baptis ta gwibin zini Yohanis Swesa san ha Alap trï ta seka? San ha zen zëre en mo sosonkam ki syal gwe-gweka? Eme nonol ap ding ulbliꞌak, ki Ëe asa hen emsa gubiridal, ‘Asa Zen trï ta seꞌara, zebë kirekam syal gwe-gweꞌan.’” ");
INSERT INTO ury_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dekam zep zë-en anakan donbiꞌik, “Bëjen nen anakan ding gulblun, ‘Alap trï ta seka,’ ki hwëna zen sa nësa gubiridala, ‘Ki em ba habe desa laïblïbla srëm gwek?’ ");
INSERT INTO ury_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Hwëna anakane ding ulbliꞌak, ‘Yohanis zen zëre en mo sosonkam syal gweka,’ ki hwëna zi trana an sa nësa karek dabir, sap zen Yohanissi mes-am anakan daïblïblak, ‘Zen eiwa Alap mo olsa ayang gul gwizimki.’” ");
INSERT INTO ury_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Anakan zep hëndep ding nulblik, “Ëe homë dam ulsuꞌun, ‘Yohanissi zen trï tase gweka.’” Ki zep hwëna ding gulzimki, “Ki Ëe hen molyë emsa gubiridak, ‘Ëe an zëno syalsaë gol gweꞌan, hen Zen Asa trï tase gweꞌara.’” ");
INSERT INTO ury_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesus ki zep gulk sun de blaonzimdinkim Yahudi mo mam-mamna insa tonbiridaka, “Zini man anggur ngasa eiyas tablaka. Alp san kolkam wale tablaka. Zao zep hen kasona hul gulku– anggur danna insa de zë tanakam it ta sone gwen hap. Hen gut de gola zao zep hen tauku– dekon de ngana insa kara ta ine gwen hap. Ki zep hwëna ngana insa te-alakam nga syal gwe-gweblan zi hip bohë ta guzim halka. Zëna dekam zep aha lang san holokam de zë gwën hap song gweka. ");
INSERT INTO ury_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Angguru in kim tëka, dekam zep zëre hon de babu gwen zisi zer soneka– zen de anggur dan te-ala hlïksa zëre hap zerbla halzan hap. ");
INSERT INTO ury_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Hwëna zini in zen ngana insa bohë dak, ki zep karekkam dangolek, hëndep ki zep nenblak, ‘Wake, ki en lwahal!’ ");
INSERT INTO ury_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Anggur nga bina in ki zep etan ahanaka zer soneka. Desa hwëna man dësek, kire naka zep ol lamang naban nëralsa sonek. ");
INSERT INTO ury_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nga bina in dekam zep etan ahanaka zer soneka. Desa hwëna man nga bohë tan wenya in dak. Dekam zep hwëna ahakore babu gwen zini beyakam etan lup gul sone gweka, hwëna zini in kire enkam neibirida gwek. Ahakorena man dangole gwibik. Ahakorena man damera gwek. ");
INSERT INTO ury_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Dekam etan nga bina in ba zisi dep?– zer sonen naye. Dekam zep guku, ‘An angkam ëre en mo dang tïnïnak de tane en am gwëꞌara.’ Hwëna man enlala gweka, ‘Ëe sap asa ëre mo tane tanganna ansa zer soner. Desa sa blikip neisïblïl.’ Desa zep aumwa hap ein tangan zer soneka. ");
INSERT INTO ury_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Hwëna desa kim hla da guk, ki zep nga bohë tan zini in zënaka nenbiridak, ‘Wakin angkam zëre mo walas tangan hataꞌara. Bi zik de tïnkïm, an zen sa hwëna ngana ansa bi gweblala. Nen tan, ekakim nën bi ëblak!’ ");
INSERT INTO ury_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dekam zep hëndep balk dak, zao zep tol hëndep dak. Tokna dekam zep ngana in kon ësan dep hiri dak. ");
INSERT INTO ury_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Zep nga bi nik mo zi lup gul sonenna insa kirekam neibirida gwek, zep zen banakan sa gweibirida zala? Zen sa zini insa tamera zala. Ngana insa dekam sa hwëna aha zi hip bohë tazimdi– dekam de zen anggur dan te-ala hlïksa zëre hap zer gweblan hap. ");
INSERT INTO ury_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Ëe in zebë emsa gubiridaꞌan: Em bawalkam esa Alap mo ola an mo eini dam ulsul?— ‘Gol tauk gweblan wenya mensa gol tenya baes neibik, hwëna Bian Alap zep desa bolak ïk gïlkï. ");
INSERT INTO ury_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Zen diki Bian zëre mo syal, hen nëno mae mo nwenak zen owas tangan.’” ");
INSERT INTO ury_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yahudi mo mam-mamna in kim kirekam Yesus mo gulk sun de ol blaoranna insa ësane gweꞌak, dekam zep anakan tame nuk, “O zëno ola an nëbon mae am tïꞌïn.” Dekam zep sap Yesussu de balk tan hap dwam nëblaꞌak, hwëna zi beyam-byana insa naïrïbiridak, zep zë hli dak. ");
INSERT INTO ury_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yahudi mo mam-mamna in dekam zep Farisi zini teipsïn zini Herodes hon de bïtï gwen zi niban Yesus osan dep lup nul sonek– zen de Yesussu u nuka siweblan hap. Zen mes anakan ola aha-en nuk, “Yesus de anakan jalse gwenkam, ‘Bahem Roma mo ïrïk gïnnïk dep pajak te-alana kap ta gwizimdin,’ zen dekam esa Roma mo mam-mamnak klak lal.” ");
INSERT INTO ury_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Zini in dekam zep Yesus onak yaïng gwezak, ki zep nenblak, “Bian Guru, ëe mesë emsa tawa ëblak: Em in dam-dam enkame gwë gwenda. Em Alap mo dwam gwibinni dam-dam enkame tawa ta gwibirida, sap ema hen zi mo husus gwibin maena damnake gollëwen srëmkam tonbirida gwenda. Sap em zi mo bosesa home kara gul gwizimnira. Zen in zebë emsa lakensïblïꞌan: Em banakane Musa mo tïtï tabin ola dam gulsuꞌura? San ha nen sap esa Roma mo ïrïk gïnnïk dep pajak te-alana ol gwizim? San ha bap nen?” ");
INSERT INTO ury_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Hwëna Yesus mes tame tabirki, “An u siwen olkam ki Asa dakensïblïnan.” Ki zep ding gulzimki, “Em ba habe Asa balk laꞌan? Abe hap emki pajak hap de te-ala kasona insa ahanaka goltrëblan– Ëe aka ki hlauk.” ");
INSERT INTO ury_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dekam zep ahanaka nolblak. Ki zep hwëna gubiridaka, “Te-ala kasonak awe, an nara mo nwe-masesa zë yang dasïk? Hen nara mo bosesa zë ale nuk?” Dekam zep ding nulblik, “Roma mo teipsïn zi mo denakake.” ");
INSERT INTO ury_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Dekam zep hwëna ding gulzimki, “Ki Roma mo teipsïn zini in mo bi gwibin kire-kirena amki zëbe hap etan lop la gweblak. Hen kirekam, Alap mo bi gwibin kire-kirena, amki Alap hap lop la gweblak.” Zao zep denggwanblaꞌak. ");
INSERT INTO ury_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ki zep hen Sadukikam de gubirida gwen zini Yesus onak u siweblan ola ban yaïng gwezak. Zen Yahudi mo aha hlïkna– men zen anakan tawa da gwibirinke, “Zini bëjen tïn nïkon etan ngaya gwen.” ");
INSERT INTO ury_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Zen ki zep hen dakensïblïk, “Bian Guru, Musa Bak mo tïtï tabin olak a kirekam mo lwakye, ‘Zi de we zemka walas wë lan srëmnak tïnkïm hli yunnu, zen oso zik de etan gonkam– zen de zë walassa aya zik mo weinak dep wë tan hap. Hen kirekam, oso zik de tïnkïm, aya zik de hwëna we semna insa gonkam.’ ");
INSERT INTO ury_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Orep awe zini ki, beyana tuju enkam, aha-ere ane-bianna. Zëna zi nik zep nonol wenya golka, hwëna walas wë lan srëmnak zep tïlkï. ");
INSERT INTO ury_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","We nal zem insa hwëna oso zik zep etan golka. Zen hen walas wë lan srëmnak zep tïlkï. Zao hen etan dan-ahan nik etan golka. Zen hen walas wë lan srëmnak tïlkï. ");
INSERT INTO ury_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Hëndep tujukam de aya-wal oso-walya in kire enkam zep sap nol gwek, hwëna walas ën srëm ennak zep juwe gwek. Wenya in hwëna aumwa hap zep tïk. ");
INSERT INTO ury_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Zep zen de etan ëngaya gweꞌanam, men kirekam ahakon tawa da gwibirin, wenya insa nara mo wekam maka nenbiꞌin? Sap tujukam de zini in mes desa kïtak nol gwek.” ");
INSERT INTO ury_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesus ki zep ding gulzimki, “Em in ema ëbute gweꞌan, sap em home Alap mo ola ban zëno soson naban tame osoꞌan. ");
INSERT INTO ury_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sap tïn nïkon de etan ëngaya gwenkam, dekam molya etan zënaka kap da gwek– men kirekam hen Alap mo dam taha nakore zini zënaka de kap tan srëmkam lowehe gwenanke. ");
INSERT INTO ury_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Hwëna angkam tïn nïkon de ngaya gwen hap dena insaë emsa gubiridaꞌan: Em bawalkam esa Alap mo ola an mo eini dam ulsul?– Musa kim syauk nubare te tyum-tyumnu insa hlaulkuke. Zao Alap man-am Musasa gubluka, ‘Ëe an eno auyan wal mo Alap– Abraham, Isak, hen Yakob Bak mo.’ ");
INSERT INTO ury_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Zep Zen tïn zi mo Alapsa hom. Zen ngaya wenyik mo Alap! Em in eiwa ema tangan ëbute gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yesus kim Sadukikam de gubirida gwen zi niban kirekam golëkeisa-keisa gweꞌanka, hwëna Musa mo olsa de tawa ta gwibin zini ahana dekam zep hen salbla zaka. Zen kim anakan dam gulsuku, “Yesus dawem tangankam zëno mae mo ola ding gulzimnira,” zen dekam zep hen anakan takensïblïka, “Tïngare Musa mo tïtï tabin ola kon, bol-zaun tangan wenya enda zen moye?– desan de nen dawemkam ang ta gwen hapye.” ");
INSERT INTO ury_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus ki zep ding gulbluka, “Musa mo tïtï tabin ola kon, a zen tangan mo bol-zaun gweꞌanye: ‘Israel Bak mo ausu nakore zi, em ësane gwen: Nëno mae mo Teipsïnnï Bian Alap Zë-en. Ahana hom. ");
INSERT INTO ury_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bian Alapsa em ensa lwa gweblan– tïngare enho naban, enlala naban, soson naban, hen tim niban.’ ");
INSERT INTO ury_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ahana zen a kirekam moye: ‘Zi bose omka em kwasang gwibirida gwen– san de enaka de kwasang gweblanna kiye.’ Ahana etan hom tangan– tïtï tabin ol darena insa de kwë son naye.” ");
INSERT INTO ury_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Musa mo olsa de tawa ta gwibin zini in dekam zep ding gulbluka, “In eiwa tangan, bian guru!– in kirekame anakan gundaye, ‘Bian Alap Zen Zen en. Ahana hom.’ ");
INSERT INTO ury_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Hen anakan insa gunda, ‘Alapsa de ensa lwa gweblanna, zen diki tïngare enho naban, enlala naban, hen tïngare soson naban. Hen zi bosyansa nen kwasang gwibirida gwen– san de nënaka de kwasang gweblanna kiye.’ Eiwa, Alap mo tïtï tabin ol darena in, zen tïngare nëno mae mo aha tïtï tabin ola man tangan kwei-kwik guꞌun. Sap anakarekam dena, dombasa de Alap hap tru tase gweblanna, hen aha kire-kire maesa de lop ta gweblanna, zen kïtak lwala henna.” ");
INSERT INTO ury_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus kim anakan salblaka, “Zen dawem tangankam enlala blala ban Asa ding gulblunda,” dekam zep hwëna ding gulbluka, “Em an angkam ema tangan Alap mo ïrïk gïnnïk de tïn hïp golek de gweꞌara.” Dekam etan hom mae Yesus hon takensïblïn mae hap yaïng gwek. Saher hap baes tak. ");
INSERT INTO ury_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesus in kim nama Alap mo gol tëmnak tawa tabiꞌinka, zao zep hen takensibiridaka, “Musa mo olsa de tawa ta gwibin zini ba hap anakan tawa da gwibirin, ‘Israelsa de ngaya tabin hip de Zini, Zen teipsïn zini Daud mo auyan-tanekam sa hata zala?’ ");
INSERT INTO ury_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Hwëna Alap mo Enhona kim Daud Baksa bi gweblaka, zen dekam man-am guku, ‘Bian Alap man ano Teipsïnnï gubluka, “Ëre mo dam taha nakon emki nikirin– dekon de hen teipsïnkïm ïrïk gïn hïp. Ki asa hwëna ebe hap de jal zini ere mo tana ïltïkïnnïk sisik gulin.”’ ");
INSERT INTO ury_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Zep Daud insa Israelsa de ngaya tabin hip de Zini insa ‘Teipsïn Zi’kim gubluka, ki Zen banakan sa zëno auyan-tanekam hata zala?” Zi trana in zen Yesussu sane dak man tangan zëno ola isrip-sri neibik. ");
INSERT INTO ury_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesus in kim zë nama tawa tabiꞌinka, ki zep gubiridaka, “Bera, Musa mo ol tawa ta gwibin zini in enlala kwae naban! Zëno mae mo kwaena in mana ebon mae hliminnink. Zen baju dawem-dawem alala tan naban zi nwe san zënaka nolëtrënda gwenan– zi dikim blikip gwesibirida gwen hap. Zen hen man ëdwam gwe-gwenan– dekam de aha zi tagal gwen maenak anakan gubirida gwen hap, ‘Dawem, bian guru.’ ");
INSERT INTO ury_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Zen hen but srëm golak ngeinnik de komal tumnak de teinikirin hip ëdwam gwe-gwenan– hen tembane yawal maenakye. ");
INSERT INTO ury_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","We wal sem-semna zen hen man anakan ahap da gwibirin, ‘Ëe asa tol eno zi swe mo kire-kire hli tandanna ebe hap tagal tasibir.’ Hwëna zen sowë enlala naban mas neibirida gwenan– dekam de zëre hap mamkam hlï tï irin hip. Hwëna zëre mae mo karekna insa dikim aha zi hlaulzimdin srëm hap, zep but srëm gola kon zi nwenak Alapsa mam blalkam nen sone gweblanan– dekam de zi kïl tïbin hip, ‘Zini an aïrïs.’ Hwëna dekam zënaka de karek tabin hip denaka kim mam nulsuk gwenan.” ");
INSERT INTO ury_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus kim nama Alap mo gol tëmnak nikinꞌinka, dangna kim Alap hap de te-ala kang ta gweblan peti san gwëka. Zen man kon kara tabiꞌinka– zi beyana men zen te-alana petina iwe Alap hap bïtï da sone gweblaꞌan zakke. Te-ala beya wenya dekam beyakam Alap hap bïtï da gweblaꞌak. ");
INSERT INTO ury_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ki zep hwëna we sem tahalhana hen hatak. Zen dekam zep hen te-ala kaso dare tolsa ing so sonezak– sepulu rupia makare naka. ");
INSERT INTO ury_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesus ki zep zëre hon de ang ta gwen wenyaka haen gwibiridaka, zao zep gubiridaka, “Eiwa denakaë emsa gubiridaꞌan: We sem tahalhana an mes tïngare ahakore zini kwei-kwik gulun– men zen sap te-ala mam-mamna bïtï da sone gwesan zalye. ");
INSERT INTO ury_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sap ahakon in zen bïtï da gwe sanzal, zëre mae hap de hlïkna nama beya nik ërlwazimꞌin. Hwëna we sem tahalhana an mes tïngan ing gulun– zën dikim tol sap gwën hap denaka. Angkam zëre hap dena hom tangan.” ");
INSERT INTO ury_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesus kim Alap mo gola kon te soka, zëre hon de ang ta gwen wenyik zep ahanik gubluka, “Bian Guru, emki sap hlaun. Alap mo gol yala an wehasa hom. Man tangan kwa nuk. Hen zëno kaso kong ta zahenna nwe awes tanganna!” ");
INSERT INTO ury_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ki zep ding gulbluka, “Eiwa, emki gol yala ansa kara gun. Zëno kaso kong ta zahenna aha-en mae molya lwak. Zen tïngan tangan sa dri nulsul.” ");
INSERT INTO ury_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesus ki zep kon zëre hon de ang ta gwen wenya ban zaitun tra nabare kwatap tek san dep golëyaïng gwe seka. Zëna nikirinkim Alap mo gola in san zep dangna gwë ine haka. Hwëna dekam zep Petrus, Yakobus, Yohanis, hen Andreas mae golek de dazak– olsa de zë zë-en takensïblïn hap. ");
INSERT INTO ury_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Zao zep dakensïblïk, “Asa en emki gubiridan: Alap mo gola insa dri yulsun hup gubiri, zen bawalkam sa ki lwal? Hen banakare owassa asa hla kul gwer?– dekam de anakan dam gulsun hupye, ‘Aumwa hap de yaklanak dep angkam man golek de gwe song gweꞌan.’” ");
INSERT INTO ury_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesus ki zep ding gulzimki, “Salok-salokkam lowehe gwek. Emsa mana yasik da gwibirink. ");
INSERT INTO ury_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sap zini beya nik sa ebon mae onak anakan ëboton gwe-gwezal, ‘Ëe an Zen– Yesusye.’ Hëndep zen sa zini beya tangankam yasik da gwibir. ");
INSERT INTO ury_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Em de anakan ësane gwe-gwenkam, ‘Zëwe man ëeijaꞌan,’ hen anakan, ‘Awe hen sa ëeijazal,’ hwëna em dekam bahem ëaïrï gwen. Sap zen nonol kirekam sa Alap mo dwam gwibin sin lwa gwer. Hwëna dekam bahem ëkïl gïl gwen, ‘An aumwa hap denak mes zaul, zep ki lwaꞌan.’ ");
INSERT INTO ury_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Aha zi ausu nakorena aha zi ausu naban sa ëeija gwer, hen aha ïrïk gïnnï aha ïrïk gïn nïban sa ëeija gwer. Lang yala an san jïngïlï mam enkam sa taïlïda gwera, hen usak yala sa hatanda gwer. Zen kirekam sa karekna nonol lone sennak lwa gwer. Zen men kiye: We de jaha gwen hap eisbir anensa sëwehe kïnïnna. Zen dekon sa ki hëndep sang-sangna dohonse gwe song gwer. ");
INSERT INTO ury_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Em terya-tyakam lowehe gwek. Sap emsa sa dahyo gwer, hen but srëm gol-gol san sa emsa lup nulhal gwer. Zao sa emsa dangole gwibir. Hen emsa sa pemerinta mo teipsïn-teipsïn wenya kip anakan nolëtrei gwizim, ‘An hen ahana Yesus hon de ang gwe-gwenna.’ Hwëna zen kirekam Alap mo dwam gwibin sin sa ki ebe mae hap lwa gwizim– em dikim zë abe hap denaka ëton gwen hap. ");
INSERT INTO ury_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","An na-en molya tap gwek. Diki nonol tïngare zi ausu hap sa ëngaya gwen hap de ol dawemsa nolzim halada gwer. Zen diki dekam sa aumwa hap denak zaul. ");
INSERT INTO ury_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Men dekam de emsa dahyo gweꞌak hen lup nulhal gweꞌak, em bahem anakare hap enlalana ëbeya gwe-gwen, ‘Ëe banakarekam asa zë ding gulzim?’ Sap men kirekam de ding gul gwizimdin hip dena, zen emsa de taken-taken gweblan ennak sa ki Alap mo Enho ebe mae hap gol gwizimdi. Zen dekam em ding gul gwizimdin. Sap dekam Zen Alap mo Enho sa eno ëk tïhï san ding gul gwizimdi. ");
INSERT INTO ury_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","13","Emsa sa tïngare zini husus neibirida gwer, sap em an Asa de ang gwe-gweblan wenya. Zep a kirekam sa ebe mae hap lwa gwizim: Emsa ere mae mo aya-wal oso-wal tanganna sa tameran hap nolëgu gwer. Hen emsa ere mae mo bi walya sa tameran hap nolëgu gwer. Hen ere mae mo walasna sa emsa abe hap de jal hap nolëtobe gwe-gwer, hëndep tameran hap sa hen emsa nolëgu gwer. Hwëna em in zene Asa de taïblïblannak tatem ëzauk gweꞌak, hëndep aumwa hap denak de hataꞌak, em esa ëngaya gwer. ");
INSERT INTO ury_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ëe ol tan-tanna ansaë ebe mae hap golzimꞌin: Em esa teipsïn zisi hla lal– Alapsa de lamang tan hap de karek yawalsa de Alap mo golak goltïl zïnnak, men kirekam orep Alap mo ol ayang gul gwen zini Daniel Bak gubiridakake. Zen dekam esa anakan tame ul, ‘Angkam aumwa hap de yaklanak man zauꞌun.’ Dekam Yerusalem mo langnak de zini em kwatap san dep ëheya-hya gwek.” Hwëna ëe, Markus, ama Yesus mo ola in hap emsa gubiridaꞌan: Em in zen bukuna ansa aha zi hip baca ul gwizimk, dawem enkam srip ulsuk gwizimk. Yesus dekon anakan ayang gulku, ");
INSERT INTO ury_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","“Dekam zini men zen de gol homan nakon lowe heꞌak, zen bap zen etan gol mwa san ba maesa de gon hap bïtï gwehan. ");
INSERT INTO ury_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Hen nganak de syal tandan wenya, zen bap zen etan gol sandep lwan dahan– baju sal-sal maesa de teisyan hapye. ");
INSERT INTO ury_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kwasang tol, we walya u nubare wenya, hen nama de walassa momkam taïzï gwibin wenya. Zen tol banakan molya ëasendak. ");
INSERT INTO ury_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Zep Alapsa anakan abe la gwek, ‘Karek yala in bap zen o dïl gwennak jowen.’ ");
INSERT INTO ury_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kirekam abe la gwek, sap Alap kim nglï naban okama naban yang sosuku, hëndep sërkam de karek yala an de jowenkam, kirekam de lang dohon-hon gwenna hom mae jowek. Hen zëno hyanak etan molya kirekam okamanak jowek. ");
INSERT INTO ury_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Hwëna Alap man zëre mo hlïl irin zisi kwasang gwibiridaka, Zen zep anakan hamal hap guku, ‘Karek yawala in bap zen tangan holo gwen. Ki hwëna zini kïtak tangan sa juwer.’ ");
INSERT INTO ury_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Dekam zi de anakan emsa gubiridanna, ‘Nësa de ngaya tabin hip de Zini men angkam awe gwëꞌara,’ ahaksa, ‘Zëwe gwëꞌara,’ em bahem taïblïbirida gwen. ");
INSERT INTO ury_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sap dekam yasik ta gwibin hip de zini beyakam sa yaïng gwe-gwer, hen zen sërkam de owas-owasna sa syal nei gwibir– anakan dikim emsa boton ta gwibin hip, ‘Ëe an Zen, emsa de ngaya tabin hip de Zi niye.’ Ahaksa anakan de emsa boton ta gwibin hip, ‘Ëe an Alap mo olsaë ep ayang gulzimꞌin.’ Zep hëndep Alap mo hlïl irin zini hen desa de taïblïbiridan hap sa hen ëalp gwesïl. ");
INSERT INTO ury_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Zep em terya-tyakam lowehe gwek. Zen in zebë kirekam de lwan srëmnak hamal hap emsa tawa ta gubirin.” ");
INSERT INTO ury_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Lang dohon-honna in kim de hya gwesïꞌïk, zen hëndep dekam sa ‘yakla nwena kawesïlï. Benna hen molya ngatan gwek. ");
INSERT INTO ury_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Hen keisni sa nglï nakon ëlan nahla gwera, hen nglïnak de teipsïn-teipsïn dowla-dowala sërkam sa ëïlman gwe nasen gwer.’ ");
INSERT INTO ury_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Zen diki dekam sa ngatan zi mo lang nakore Zi Tanganna Asa but de zerati gwe zannak hla dase gul. Zen dekam asa ëre mo soson naban ngatan yawala ban ziati gwezal. ");
INSERT INTO ury_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ki asa hwëna ëre mo dam taha nakore zini lup gul soner– zen de ëre mo hlïl irin zisi tïngan en tangan tagal gulsun hup, sap yakla hata sezan nakorena, hëndep nikin anen nakorena, hëndep eihya-lip eihya-lip nakorena. ");
INSERT INTO ury_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Zep aumwa hap de yaklasa de dam gulsunnu, zen tenya dëren nakon de langsa dam gulsun makan. Em kime tenya dërenna anakan hla kul gwenan, ‘Man alsïk, hen angkam man etan ala gweꞌan,’ zen dekame anakan tame ul gwenan, ‘Angkam sasa gwen hap ki lwaꞌan.’ ");
INSERT INTO ury_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Zen hen kirekam, kirekam-kirekam karek yala insa kime hla kul gweꞌak, zen dekam esa anakan dam ulsuk gwer, ‘Angkam Alap Zën de kïtak ïrïk gïlzïn hap denak man zauꞌun!’ ");
INSERT INTO ury_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Eiwa denakaë emsa gubiridaꞌan: Em an zen okamanak lowe heꞌan, molye kïtak juwek, zen dekam sa ki tïngan lwal. ");
INSERT INTO ury_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nglï naban kama naban sa jek-jak nër. Hwëna ano ola, zen hëndep denaban sa lwa gwer. ");
INSERT INTO ury_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Hwëna zini molya ngatan zi mo lang nakore Zi Tanganna ano lwa halzan hap dena anakan tame nuk, ‘Yaklana’ ahaksa ‘Jamna dekam sa hata zala.’ Alap mo dam taha nakore zini hen molya. Tane zem Aena homë hen tame guꞌun. Zen diki tawana Bian Zë-en. ");
INSERT INTO ury_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Zen in zep salok-salokkam terya-tya naban Asa kara ë gweblak. Sap ngatan zi mo lang nakore Zi Tanganna ano etan de lwa halzan hap de yaklana em molye tawa ëblak. ");
INSERT INTO ury_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Zep zen mae mo kim lwaꞌan: San de kama bi nik de aha lang san holokam song gwenna. Zëre hon de ëbabu gwe-gwen zi hip maka syalsa anakan wei yul sone guzim haꞌara, ‘Em ano tim bwanak ansa syal gwe-gwibir.’ ‘Em wakinsa syal gwe-gwibir.’ Ora top san de kara gwe-gwen hap de zini, desa sa anakan gublula, ‘Em dawem enkam salok-salokkam asa kara gwe-gwebla.’ ");
INSERT INTO ury_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Zep em hen kirekam salok-salokkam Asa kara ë gweblak. Sap em molye anakan Asa tawa ëblak, ‘Ano mae mo Teipsïnnï dekam sa etan hata zala. San ha kam-en? San ha ngïrïn tatem? San ha oho-bunggun nuban sa, ahaksa kak tangannak?’ ");
INSERT INTO ury_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Anakan em ëalp gwe-gwen, ‘Bap Zen asa ni truwennak hlauludazan!’ ");
INSERT INTO ury_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Zep angkam en de Asa salblan wenya, em ensa homë ki gubiridaꞌan. An hwëna tïngare zisië hamal hap gubiridaꞌan: Salok-salokkam em terya-tya naban Asa kara gwe-gweblan!” ");
INSERT INTO ury_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yaklana dekam dan nola kïnïꞌak– Paskanak dikim zaun hupye. Paska yaklanak kim zauk, zen dekam zep hen ëkon gwesïk hanak– aha-ere minggukam de ragi srëmkam rotisa tru ta gwen naye. Alap mo golak de syal tan zi mo mam-mamna hen Musa mo olsa de tawa ta gwibin wenya, zen hen dekam zep anakan orana dëblaꞌak, “An banakarekam esa aningkim Yesussu tan hap dokwak lal?” ");
INSERT INTO ury_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Hwëna man hen ëguk, “Yakla yalak awe bap nen balk tan, sap zini beya tangan nik dwam nëblaꞌan. Ki deban mae esa mamkam ëïlman gwer.” ");
INSERT INTO ury_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesus ki zep Betania san dep zëre hon de ang tan wenya ban golësek gweka. Zëwe Simon mo golak zep golëbïtï gweka. Simon in, men zen orep kusta gwekake. Yesus kim golëtembane taꞌanka, hwëna wenya dekam zep zëbe hap de kwasangsa goltrëblan hap hatazak. Zep te-ala mamkam de gon minyak, sërkam de irase dawem nabarena, golhatazak. Kirekam de kaso botola bëjen mat-matna ulsun. Zep kim golek de taꞌanzak, dekam zep botola insa ëk tïhï nakon kam sok, dekam zep minyakna inkam Yesussu nola kon hlë tablak. ");
INSERT INTO ury_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Hwëna ahakon men zen zë lowe heꞌak, dekam zep husus neibiꞌik, hen dekam zep donsubiꞌik, “Zen ba hap minyakna insa kïtak tangan zalta dep hlei yul soneblanan? ");
INSERT INTO ury_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Dawemna diki minyakna in te-ala hap de lirak gulunam, te-alana mam tangan naka maka nëp zerzimnin. Desa emaka tahalha zi hip kae ë gwebla-zimꞌin.” Kirekam zep wenya insa jakal neibiꞌik. ");
INSERT INTO ury_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Hwëna Yesus dekam zep gubiridaka, “Dikire gwëk. Em ba habe wenya ansa lonsubiꞌin? Zen man tangan sam gwesïl– kirekam de Asa gwëblankamye. ");
INSERT INTO ury_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sap tahalha wenya em desa nama esa olëlowehe tine gwer. Em de mas gwibirida gwen hap ëdwam gwe-gwenkam, em sap esa dekam mas eibirida gwer. Hwëna Asa em molye dakal hap ërgwë gwek. ");
INSERT INTO ury_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Insa irase dawem nabare minyakkam Asa hlë tablanan, zen hamal hap ki Asa gwëblanan– deban de Asa drë nwanun hap. Zen dekon etan banakan dep?– aha syal maesa de abe hap syal gwibir-blin hapye. ");
INSERT INTO ury_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Eiwa denakaë emsa gubiridaꞌan: Tïngare lang san kim Alap onakore ol dawemna nol halada gweꞌak, wenya ansa kirekam abe hap syal gwibir-blinan, desa hen sa aïsïl nei gwibir. Hëndep wenya ansa zep sa eititi neibir srëm gwer.” ");
INSERT INTO ury_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Dua-blaskam de zëre hon ang ta gwen wenyik mo ahana, ëna Kariot walya Yudas Bak dekam zep Alap mo golak de syal tan wenyik mo nol-nol san dep song gweka– Yesussu de zëbe mae hap zerguzimdin hip. ");
INSERT INTO ury_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Salblankam man tangan sam neisïblïk. Dekam zep nenblak, “Te-alasa asa ebe hap ërblal.” Dekam zep hëndep Yudas Bak in orana tëblaꞌanka– Yesussu dikim sowëkam balk tan hap denaye. ");
INSERT INTO ury_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Rotisa de ragi mas gun srëmkam tru tan hap de minggu mo nonol yaklanak kim zauk– yaklana men dekam Paskanak dep de tembane yawalak dep domba zahona Alap hap blom da gwibir-blikke, zëre hon de ang ta gwen wenya in dekam zep Yesussu dakensïblïk, “Bian, endawe esa Paskanak dep de tembanena aban mae zitwenblala?– ëe akakim zao hamal uk.” ");
INSERT INTO ury_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dekam zep dan-dan guzimki, “Em Yerusalem san song ën. Zëwe esa zini ërtowera– kama ngatdarakkam de weya blome gwiren halzan naban. Zen desa ang ëbla. ");
INSERT INTO ury_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Gola men zao de tïk, em hen zao lïl. Zao gol bi naka enbla, ‘Bian Yesus man emsa takensïblïla, “Ëe teksonna enda zao asa ëre hon de ang ta gwen wenya ban Paskanak de tembanena zitwenblal?”’ ");
INSERT INTO ury_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Zen sa ebe nikip gulk de tekson yawalsa zertreizimdi. Zëwe kire-kirena mes ototo da guk, hen komal tum maena sowe henna. Zao hamal ul guk.” ");
INSERT INTO ury_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Zi darena in dekam zep hëndep song ëka, zao zep hëndep oltoweka– men kirekam Yesus guzimkiye. Zëwe zep hëndep tembanena hamal ul guku. ");
INSERT INTO ury_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kim kawesïk, Yesus Zëna dekam zep sepulukam de ahakore zëre hon ang ta gwen wenya ban golëyaïng gwe zaka. ");
INSERT INTO ury_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kim golëtembane taꞌanka, zao zep gubiridaka, “Eiwa denakaë emsa gubiridaꞌan: Em an zene aban ërtembane gweꞌan, ahanik sa Asa zertrëra– zao de Asa balk tan hapye.” ");
INSERT INTO ury_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kirekam de gubiridannak kim nasalblak, dekam zep enlalana ëdowe hanak. Dekam zep aha-en aha-enkam dakensïk gweblaꞌak, “San ha asa tol home yap ki gublunda?” ");
INSERT INTO ury_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ki zep ding gulzimki, “Nen an zene apdenak roti apna kolho honak os-os la ine gweꞌan, ahana sa Asa zertrëra– zao de Asa balk tan hapye. ");
INSERT INTO ury_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Men kirekam Alap mo olak ngatan zi mo lang nakore Zi Tanganna abe hap dena lwak, zen hëndep kirekam asa tïl. Hwëna kwasang tol, zini men zen Asa dikim zë balk tan hap zertrëꞌara, zen sa karekna mam tangan naka Alap onakon hlaulu. Zen an zik de jaha gweblan srëmkam maka sam gwesïkï, sap dekam zen molya karekna mam tangan wenya insa goltoweꞌanam.” ");
INSERT INTO ury_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kim tembane taꞌak Yesus ki zep rotina gul ineka, ki zep Alap hap rotina in hap dawemna golblaka, ki zep ahap gul guku. Dekam zep zëre hon de ang ta gwen wenya in hap anakare ola ban kap tazimki, “Em twenblandan. An ano timni.” ");
INSERT INTO ury_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","24","Ki zep hwëna anggur ho nabare mokna zer ineka, dekam zep etan Alap hap dawemna golblaka, ki zep hwëna zëbe mae hap anakare ola ban zerzimki, “An ano kala zen. Zen sa ano tim nikon wet sol– Alap mo zi niban de ol ziaha-en gun ësesa dikim sul sonen hapye. Zep zini beya tangankam sa ano kala kon Alap mo nwenak ëdakastïl gwer.” Dekam zep tïngan notdebik. ");
INSERT INTO ury_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ki zep gubiridaka, “Eiwa denakaë emsa gubiridaꞌan: Ëe angkam na-en molyë anakare anggur hona etan otdek. Hwëna ano Bian mo ïrïk gïnnïk kim de hataꞌak, zen diki dekam asa anggur ësesa ziotdebir.” ");
INSERT INTO ury_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ki zep hwëna Alap hap de tërya dak. Kim dasïk, dekam zep hwëna zaitun tra nabare kwatap tek san dep golësek gweka. ");
INSERT INTO ury_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ki zep zëre hon de ang ta gwen wenya insa gubiridaka, “Em namen kïtak esa aïrïn hïp Asa hli la gukhal. Sap Alap mo olak man lwak, ‘Ëe asa zaho ta gwibin zini insa karek tal. Zaho zem dekam sa men-san an-sankam heya-hya gwer.’ ");
INSERT INTO ury_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Hwëna Bian kim de etan Asa ngaya taꞌanka, Ëe asa dekam emsa Galilea san dep ngeirbiridal.” ");
INSERT INTO ury_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petrus dekam zep ding gulbluka, “Ahakorena an sap sa heya-hya gwenkam Emsa hli dasïl. Aena tangan molyë Emsa hli tak!” ");
INSERT INTO ury_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus ki zep hwëna ding gulbluka, “Eiwa denakaë emsa gubluꞌan: Namen ayang de gunsu dan son srëmnak, em dekam esa anakan de Asa zabeblanna dan-ahan soblala, ‘Zini in ëe homë tame taꞌan.’” ");
INSERT INTO ury_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petrus dekam zep udobe naban ding gulbluka, “Bian, ëe apdenak asa Eban lïl. Ëe molyë tangan Emsa zabeblak.” Ahakore wenya kirekam zep sap hen ëgu anek. ");
INSERT INTO ury_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Getsemanik kim golëyaïng gwe naka, zao zep gubiridaka, “Awe teinikin guk. Ëe ama ë-en Biansa gu soneblaꞌan.” ");
INSERT INTO ury_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Hwëna Petrus, Yakobus, hen Yohanis mae ensa zep gubiridaka– zen en de ang gweblan hap. Hwëna zao zep enlalana sërkam tangan dowebla hanaka, hëndep hlik gwebla hanan hap alp gwesïblïka. ");
INSERT INTO ury_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Dekam zep gubiridaka, “Ano enlalana sërkam tangan dowe hananda, hëndep tïn hïbë alp gwesïꞌïn. Em awe Asa ërgwëk, hen enlala naban esa loweher– Alapsa de abe ta tinen naban.” ");
INSERT INTO ury_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Zëbon mae onakon kim engka en langa gwe halka, zao zep kamanak ïk gwe heka. Dekon zep sap karek yala insa de wei yun srëm hap Alapsa anakan abe taka, ");
INSERT INTO ury_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Bian, toton banakare maena hom– eno syal gwibin srëm hap denaye. Karek yawala ansa Ëe goltoweꞌan, diki Em Abon onakon langa gulsun. Hwëna ano dwam gwibin sin bap zen lwan. Diki ere mo dwam gwibin sin zen lwan.” ");
INSERT INTO ury_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Alapsa de abe ta gwenna kim hya gwesïkï, dekam zep etan zi dan-aharena in osan dep lwa halka. Hwëna ni truwennak zep hlauluda zaka. Petrussu zep zë gublu zaka, “Simon, em san ema taꞌara? Em san bëjen em engka en mae Asa zersalen!” ");
INSERT INTO ury_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ki zep etan gubiridaka, “Enlalakam lowehek. Alapsa e-en e-enkam abe la tinek. Kareknak ema altïlïnk. Sap eno mae mo enho enna dawemsa de sap syal gwibin hip dwam gwe-gwenda, hwëna eno mae mo timni in tatete naka hom.” ");
INSERT INTO ury_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Zëna dekam zep etan gweyoka– men dekon Alapsa gu soneblaka, desan dep. Dekon zep men kirekam nonol abe taka, kirekam etan abe taka. ");
INSERT INTO ury_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kim hya gwesïkï, dekam etan ni truwennak zep hlauludaꞌan zaka. Sap zëno mae mo nwena man tangan nwe-alk hap ëdohon-hon gwek. Kim zë jalse gwibirida zaka, balk enkam zep nasalsïblïk. Banakan dep?– ding gulblun naye. ");
INSERT INTO ury_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Dan-ahanna kim etan zëbon mae osan dep lwahal zaka, dekam zep gubirida zaka, “Em san namae ni truwen hap ëdwam gwe tineꞌan? In syake! Ngatan zi mo lang nakore Zi Tanganna Asa angkam man karek-karek gol gwen zi mo tahanak dep tapbla dazimꞌin. ");
INSERT INTO ury_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Dekam luk tak! Nen sek gwen. Emki hla tan. Asa de zergun hup de zini angkam man hataꞌara!” ");
INSERT INTO ury_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus in kim nama tonꞌanka, Yudas, dua-blaskam de zëre hon ang ta gwen wenyik mo ahana in, dekam zep zi beyam-bya naban Yesussu de balk tan hap golëyaïng gweꞌanka– nëbok te tek teiredan naban, mensa Alap mo golak de mam-mamna hen Yahudi mo nol-nola nenbiridakke. ");
INSERT INTO ury_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zen mes hamal hap anakan gubiridaka, “Men desaë babang taꞌak, zen zen– zini inye. Zen desa balk lahak, hen dawemkam kara lak.” ");
INSERT INTO ury_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yudas kim golëyaïng gweꞌan zaka, ki zep hëndep Yesussu babang tan naban gublu zaka, “Guru.” ");
INSERT INTO ury_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dekam zep hëndep balk dazak. ");
INSERT INTO ury_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Hwëna ahana men zen zëwe zauꞌunka, dekam zep nëbokna mol ineka, dekam zep Alap mo golak de teipsïn tangan zi nik de babu gwe-gwen zini sap zïp soka. Hwëna ing ala en naka zep blansïblï kïnïka. ");
INSERT INTO ury_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Dekam zep Yesus gubiridaka, “Em san Asa jal zisie hla lal?– zebe Asa de balk tan hap nëbok te tek teiredan naban yaïng gwenan zalye! ");
INSERT INTO ury_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ëe men yakla jamkam Alap mo golak emsa tawa ta gwibik! Dekam ba habe zë Asa balk la srëm gwek? Hwëna an desae angkam syal eibiꞌin, zen men desa orep Alap mo ol ayang gul gwen zini abe hap dena ale nukke. Zao dikim zaun hube kirekam syal eibiꞌin. Ena hwëna home tame uꞌin.” ");
INSERT INTO ury_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Zëre hon de ang ta gwen wenya in dekam zep kïtak heya-hya gwenkam hli dak. ");
INSERT INTO ury_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ëe an Markus dekam walyak. Ëe kaen ala gun en nabanë sap ang gwebla song gweꞌak. Hwëna asa hen maka balk dak. ");
INSERT INTO ury_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Hwëna kaen enna in kon zep sap asa ïrïk dasïk. Zao zebë hëndep hli yuk. Dekon irkan zebë heya gwek. ");
INSERT INTO ury_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yesussu ki zep nërsong gwek– Alap mo golak de teipsïn tangan nik mo gol san dep. Zëwe mes Yahudi zi mo teipsïn sinodenak dena kïtak ëtagal gwesïk gïk. Zen ahakon Alap mo golak de syal tan zi mo mam-mamna, hen ahakon Yahudi mo nol-nola, hen ahakon Musa mo olsa de tawa ta gwibin hip de wenya. ");
INSERT INTO ury_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petrus zen lun sap-sap gwen dankam Yesussu ang gwebla song gweka, hëndep zen hen teipsïn tangan zini in mo gol tëmnak hata zaka. Kol sonna iwe kim tïl zïka, zao zep teipsïn zini insa de kara ta gwen hap de jana nabare zini syauk tuwirinnik hlauludaꞌanka. Zen zao zep hen nikinꞌin zaka. ");
INSERT INTO ury_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Alap mo golak de mam-mam wenya hen tïngare teipsïn sinodenak de wenya zen orasa dëblaꞌak– dekam de Yesus hup boton ol blo-blosa mam gulblun hap, dekam de tan hap. Hwëna sap beya nik blo-blo tan ola ban nolluwe gweꞌak, hwëna zëno mae mo ola in hom mae apde nëk, zep dekon de karek tan hap dena hom dam nulsuk. ");
INSERT INTO ury_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Dekam zep etan ahakore nik kire ola ban nolluwek, ");
INSERT INTO ury_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Zini an ëe kië asalblak. Zen man guku, ‘Alap mo gola an mensa zini dauk, ëe asa dri yulsul. Hwëna yaklana dan-ahan ki asa hwëna owas hap syal gwibinkim etan sul soner– zi mo syal gwibin srëm naka.’” ");
INSERT INTO ury_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hwëna dekam hen nama bëjen karek tan, sap zëno mae mo ëkira-kla gwenna in hom ahanik mo ban apde në gweꞌak. Kïtak man ësrën-srën gwe-gwizimꞌik. ");
INSERT INTO ury_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Alap mo golak de teipsïn tangan zini in ki zep zëno mae mo ngïrïnnïk luweka, ki zep Yesussu gubluka, “Em san ha molye mae ding gulzimki?– insa eno karekna kira nul gweꞌan zalye.” ");
INSERT INTO ury_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesus hwëna balk enkam salsïblïka. Ki zep etan takensïblïka, “Em san ha eiwa Zen tangan?– Teipsïn Zini Alap mo Tane naye, Israelsa de ngaya tabin hip de Zini.” ");
INSERT INTO ury_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Dekam zep ding gulbluka, “Ëe an Zenke. Hwëna Ëe hen ama emsa gubiridaꞌan: Em esa ngatan zi mo lang nakore Zi Tanganna Asa hla laser– Teipsïn Zini Alap mo dam taha nakon de nikirinnik. Hen dekon kimë etan lwa haꞌanzak, butnak esa Asa hla laser.” ");
INSERT INTO ury_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Dekam zep teipsïn tangan zini in Yesus hup de u sïsngïn hïp zëre mo timnik de bajuna kalk-kalk soꞌanka, dekon zep gubiridaka, “Nen ba hap de etan zëno kareksa de kira gulblun hap zini teibiridan hap? ");
INSERT INTO ury_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nën mes em-am kïtak Alapsa de lamang tannak asalblanan! Zep angkam ebon mae onakon banakan?” Dekam zep kïtak ding nulblik, “An tok hap de karek tan hap man sam gwesïꞌïra!” ");
INSERT INTO ury_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dekam zep oltepkam nwe-masenak hol-hol da gweꞌak, hen nwena dekam zep nahaleblak. Kire naka zep lek-lek da gweꞌak, deban nen gweblaꞌak, “Eme eiwa Alap mo zer sonen zi gwëꞌanam, emaka anakan asa gubirida gweꞌara, ‘Zi bosena zen asa lek tyanda.’” Teipsïn zini insa de kara ta gwen wenya in dekam zep itra lwa soblan naka ë san dep ïrïk dahak. ");
INSERT INTO ury_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petrus in kim nama teipsïn tangan zini in mo gol tëmnak syauknu zituwinꞌinka, hwëna ki zep zë teipsïn zini in mo golak de babu gwe-gwen wenya hataꞌanzak. ");
INSERT INTO ury_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Syauk ngatannak kim Petrussu dawemkam nwe-masenak hla tak, ki zep zë gubluk, “Em an hen zenke– men zen Nazaret walya Yesus mae han apdenak ëtë gwekye.” ");
INSERT INTO ury_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Hwëna Petrus ki zep ding gulbirki, “Ëe homë mae tame guꞌun– insa em gundaye.” Dekam hwëna kol son lïlïkïn alpnak zep zauꞌun naka. Dekam hom hleng gweꞌak, hwëna ayangna ki zep hëndep nonola gu aneka. ");
INSERT INTO ury_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wenya in zao zep etan Petrussu hla taꞌanzak, ki zep zë etan ahakore naka gubiridak, “Zini an hen zen– men zen Yesussu ang nëblanda gwekye.” ");
INSERT INTO ury_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Hwëna Petrus man etan ding gulbirki, “Ëe hom.” Zao hom holo gweꞌak, ki zep etan men deban mae apdekam golëzauꞌunka nenblak, “Em an hen zëno mae mo ahanakake, sap em an hen Galilea wal.” ");
INSERT INTO ury_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dekam zep Alap mo bose gubin niban anakan guku, “Ëe hom tangan am zini insa tame tak– insa en gweblaꞌanye.” ");
INSERT INTO ury_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kirekam kim guku dekam zep ayangna dan sonna gu aneka. Petrus dekam zep ola mensa Yesus anakan hamal hap gubluka enlala gwibirki, “Ayang de gunsu dan son srëmnak, em dekam dan-ahan sonkam esa Asa zabeblala!” Dekam zep gona yusyustïnkïm mam enkam gwëka. ");
INSERT INTO ury_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kak tangannak zep nabal-bakam kïtak de teipsïn sinodenak dena tagal gwesïk, ki zep ola aha-en nuk. Dekam zep tahalen naka teipsïn zini Pilatus osan dep nërhak– zen de hwëna karek tan hap. ");
INSERT INTO ury_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus ki zep takensïblïka, “Em an san ha eiwa zen– Yahudi mo teipsïn nïye?” Ki zep ding gulbluka, “In kirekame gunda, zen kirekamke.” ");
INSERT INTO ury_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Alap mo golak de syal ta gwen zi mo mam-mamna dekam zep Pilatus hup Yesus mo karek-karekna deiri nul guk gweblaꞌak. ");
INSERT INTO ury_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Dekam zep Pilatus gubluka, “Em san bëjen em ding gulzimdin? Zëno mae en mo eno kareksa de deiri gul gu zunna mes-am beya gwenan.” ");
INSERT INTO ury_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Hwëna Yesus man tangan ding gulzimdin hip baes gweka. Hëndep Pilatus man tangan tenggwanblaka. ");
INSERT INTO ury_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Dekam tahun jamkam Paska yaklanak de zaunnuk, Israel mo gubernora man bwinak de zini aha-en aha-enkam tïngare zi mo ol-gun sun nëser sone gwizimk– dekam de sam gwesïk gweblan hap. ");
INSERT INTO ury_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Dekam bwinak zini ki ëgwëꞌak– men zen Israel de Roma mo ïrïk gïn nïkon dikim wet so gwen hap ëïlman gwenkam zini dakke. Men zen golëïlman gweka, ahana bosena Barabas Bak. ");
INSERT INTO ury_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Yesussu mes Pilatus mo golak nërhatazak, ki zep hwëna zi beyana ahakore hlïkna yaïng gwezak. Zen hom anakan tame nuk, “Yesussu mes hen nërhatazal.” Zen hwëna Pilatussu de anakan abe tan hap yaïng gwezak, “Em wëhë etan yakla yala awe zini zeser soneꞌanka– men kirekam ena aha-en aha-enkam gwiswe sone gwendaye?” ");
INSERT INTO ury_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Dekam zep ding gulzimki, “San ha zini an zen zënaka tim tiꞌara, ‘Ëe an Yahudi mo teipsïnnï,’ san ha desa asa ebe mae hap zeser sonezim?” ");
INSERT INTO ury_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Zen mae hap ki kirekam takensibiridaka: Sap zen mes anakan tame gulku, “Zi beyam-byana man Yesussu menkam ang në gweblak, zep Alap mo golak de syal ta gwen zi mo mam-mamna husus në gweblak– hëndep angkam zep tan hap asas nëblaꞌan.” ");
INSERT INTO ury_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Hwëna Alap mo golak de syal tan zi mo mam-mamna in dekam zep zi trana insa anakan nolëtonk, “Nen kïtak Barabassa de zeser sonezimdin hip nen abe tan! Yesus hup bahem.” ");
INSERT INTO ury_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Dekam zep Pilatus gubiridaka, “Ki hwëna ansa ahakon ena ‘Yahudi mo teipsïn zi’kim en gweblanan, ëe banakan asa desa gwëblal?” ");
INSERT INTO ury_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Zen hwëna dekam zep ëtaken gweꞌak, “Desa te-lidak sonnak makan laink!” ");
INSERT INTO ury_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatus dekam zep etan gubiridaka, “Hwëna zen banakan karek gweka?” Hwëna dekam tangan zep mam en tangankam ëgu ane gweꞌak, “Desa te-lidak sonnak makan laink! Te-lidak sonnak makan laink!” ");
INSERT INTO ury_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatus man zi trana in de zënaka sam gwesïblïn hap dwam gweꞌanka, in zep hëndep zëre mae mo ol-gun sun Barabassa zeser sonezimki. Hwëna Yesussu zep jana nabare zi hip tapbla tazimki– zen de hwëna tangolen naka te-lidak sonnak makan ta irin hip. ");
INSERT INTO ury_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Dekam zep Pilatus mo jana nabare zini Yesussu zëre mae mo batalyonnak de gol yalak dep nërtïlzïk. Hen dekam zep zëre mae mo ahakorena kïtak tagal nulsuk– apdekam de zë swrë tan hap. ");
INSERT INTO ury_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ki zep hwëna teipsïn zi hip de baju kwangna ala nosoblak– sam dan kïl makare naka. Hen nolak de ala gul soneblan hap dokot të ngï-ngïsa mlin-mlin nuk– teipsïn zi hip de emaskam de weir sosublun makare naka. ");
INSERT INTO ury_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","19","Deban zep hwëna lamang tan hap bokle kom tablan naban botonkam blikip neisïk gweblaꞌak anakare ola ban, “Dawem, bian. Em in zen– Yahudi mo teipsïn nïye.” Dekam zep ahakon dutekam nolak lek dya gweꞌak, hen ahakon ol tepkam hol-hol da gweꞌak. ");
INSERT INTO ury_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kim lamang tanna hya neisïblïk, bajuna insa ki zep etan nalsïblïk, dekam zep zëre mo bajuna etan ala nosoblak. Ki zep hwëna nërwet sok– te-lidak sonnak dikim makan ta irin hipye. ");
INSERT INTO ury_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yesussu in kim te-lidak sonnak de makan ta irin hip nërsong gweꞌak, hwëna oranak zep Kirene walya Simonsa nërtoweꞌak. Zen Aleksander ne Rufus nik mo bian. Yerusalem san dep etan lwa haꞌan zaka. Jana nabare zini in zao zep desa tik-tik dak– Yesus hup de te-lidak soblanna insa de wë soblahan hap. ");
INSERT INTO ury_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yesussu in desan dep nërsong gweꞌak, bosena Golgota. Bosena in mo enlalana, “zi nol swra.” ");
INSERT INTO ury_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Zao zep te bosena mur kïlï ban de blulsun anggur ho enenna nolblak. Hwëna man baes gwibirki. ");
INSERT INTO ury_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ki zep hwëna te-lidak sonnak makan daink, hen dekam zep “zëno pakeanna zëre mae hap dobe abu mo kim de zënaka dam tasïk gwibinkim kae nëblandak”– men kirekam Alap mo olak hamal hap Yesus hup dena lwakke. ");
INSERT INTO ury_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Zen kaknak yakla nwena sembilannak te-lidak sonnak makan daink. ");
INSERT INTO ury_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Te-lidak sonna iwe nol bol tahan nakon man ol alena makan nulink– tïngare zi dekon anakan tame gun hup, “Zen kire jal hap daꞌan.” Ola in a kirekam mo ale nukye, “An zen– Yahudi mo teipsïn nïye.” ");
INSERT INTO ury_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Zen sowë zi dare naban Yesus mae han apdekam te-lidak sonnak makan dabirink– ahana Yesus mo dam taha san dekam, ahana irgwa taha san dekam.  ");
INSERT INTO ury_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Zen dekam zep zauk– Alap mo olak men kirekam Yesus hup dena hamal hap ale nukye, “Zen sa kïl dïl, ‘An hen jal zi ahana.’” ");
INSERT INTO ury_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Zini men zen desan taman gwe-gweꞌanzak, zen nol ëwak gun nuban ol mamkam anakan lamang da kïnï nasen gweꞌak, “Wëo, em an zen eme guku, ‘Alap mo gola asa dri yulsul, hwëna dan-ahare yaklakam asa etan syal gwibinkim sul soner.’ ");
INSERT INTO ury_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ki emki enaka de ngaya tan hap te-lidak sonna in kon ati gwezan!” ");
INSERT INTO ury_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Zen kirekam hen Alap mo golak de syal tan zi mo mam-mamna Musa mo ol tawa ta gwibin zi niban hen lamang da gweꞌak. Zen anakan zënaka ol wehakam nenbirida gweꞌak, “Aha zi ensa man ngaya ta gwibirki, hwëna zënaka hom tol ngaya taꞌara! ");
INSERT INTO ury_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Zen de tangan eiwa Israel mo teipsïnkïm gwëꞌanam, zen maka te-lidak sonna in kon ati gweꞌan zala. Kirekam de hla tankam, ki emaka anakan laïblïblaꞌan, ‘An eiwa Zen tangan– nësa de ngaya tabin hip de Zi niye.’” Zi darena in desa hen Yesus mae han makan dabirink, zen hen man lamang laka. ");
INSERT INTO ury_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","34","Yaklana kim bolak zauku, dekam zep tïngare langna owas hap kawesïk. Hëndep yakla nwena kim dan-ahannak zauku, dekam zep etan hleng gwek. Yesus dekam zep Ibrani olkam mamkam hërheka, “Eloi, Eloi, lama sabakhtani?” Nëre mae mo olkam Zen anakan hërheka, “Are ano Alap, ano Alap, Em ba habe Asa da tasïꞌïra?” ");
INSERT INTO ury_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hwëna in zen zë kara daꞌak, ahakon hom dawemkam nasalblak, zep zënaka nenbiridak, “Emki sane tan. Zen Elia Baksa hërheblanda!” ");
INSERT INTO ury_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dekam zep ahanik nabalba enkam hluweka, yera jaubum makare naka zep nabal-bakam gol hanaka. Desa zep anggur ho enennak de os gul inen naka te tek gwënnak kyaon soneka, desa zep Yesus hup mipnak goltrë seblaka– desa de kwlem gun hup. Ki zep hwëna gubiridaka, “Nen ki kara tan. Elia Bak wëhë yap ati gweꞌan zaka?– zen de te-lidak sonna an kon terahen hap.” ");
INSERT INTO ury_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesus ki zep etan ol mamkam hërhe hanaka, ki zep hëndep tïlsïkï. ");
INSERT INTO ury_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Alap mo gol mwanak de kaen lïlïkïn glaïng-glïng yawala dekam zep owas hap kalk neisïk sonek. ");
INSERT INTO ury_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jana nabare zi mo mamna in zen apdenak zëre mo ahakore naban zikara taꞌanka, dekam dangkam talsunublaꞌanka. Zen kim anakan Yesussu hla taka, “Zen kirekam mo tïlïdaye,” dekam zep gubiridaka, “Zini an eiwa Alap mo Tane.” ");
INSERT INTO ury_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","We walya hen beya nik langa nakon kara daꞌak. Zëno mae mo bosem-sena Salome, Magdala kore wenya Maria, hen bose apde zem Yakobus Betek ne Yoses nik mo anena Maria– men zen hen zëno nik mo ayana Yesussu wë takke. ");
INSERT INTO ury_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Zen men zen Yesussu Galileak de gwënnak mas në gweblakke. Hen ahakore we walya beyanik zë ëgwëꞌak– men deban mae Yesus mae han apdenak Yerusalemk yaïng gwe zakke. ");
INSERT INTO ury_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Kim kam-en gweꞌak, Arimatea walya Yusup ki zep hata zaka. Zen hen Yahudi mo teipsïn sinodenak de aha mamna, hen zen man tangan Alap de kïtak nabakam ïrïk gïlzïn hap hohle gweꞌanka. Yesus in kim tïlkï, dekam Hari Jumat, yaklana men dekam Yahudi zini kaꞌan dep de Sabat hap ëtamal gwe-gwekke. Hwëna Sabat hap de orapna dekam man tangan golek de gweꞌak. Zen in zep Yusup enlala tatete naban nabakam Pilatus osan dep song gweka– Yesus mo tok naka dikim lo tasïn hïp abe tan hapye. ");
INSERT INTO ury_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatus kim anakan salka, “Yesus mes tïlï,” man tangan tenggwanka. Sap zen mes-am tawa gweka, “Te-lidak sonnak de makan ta irin zini na-en hom juwe gwenan.” Dekam zep gubiridaka, “Jana nabare zi mo mamna men zen zikara ta sara emki desa kwang tan.” Kim hata zaka, dekam zep takensïblïka, “San ha eiwa mes tangan tïlï?” ");
INSERT INTO ury_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Zëbon kim salka, “In eiwa mes tïlï,” dekam zep Yusupsu gubluka, “Amki zerhal.” ");
INSERT INTO ury_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusup dekam zep kaen ngap-ngap blala te-alakam golka. Ki zep hwëna Yesus mo tokna te-lidak sonna iwe zizeryahe halka. Kaen ngap-ngapna inkam zep zitahaleka. Ki zep hwëna kaso hul gun hamalak zidrë neka. Lïlïkïnnï kaso yawalkam zep zigulhlu inki. ");
INSERT INTO ury_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","In kim ki zë golësyal taꞌanka, Magdala kore wenya Maria, apde bose zem Yoses mo anena Maria han man zë kara labiꞌik– in kim zidrëneꞌankaye. ");
INSERT INTO ury_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","2","Hari Sabatna kim tamank, we walya Yesussu de drënen kaso hula in san dep sek gwek– Magdala kore wenya Maria, apde bose zem Yakobus mo anena Maria, hen Salome. Zen mes irase dawem nabare minyakna te-alakam lop dak. In zep Minggukam orap tola ban Yesus mo tok naka de minyakna inkam hlë tablandan hap sek gwek. ");
INSERT INTO ury_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Hwëna ora san zep zënaka dakensibirida song gweꞌak, “Nara sa lïlïkïn gulhlu irin kaso yawala insa nëp irhi gulzimdi?” ");
INSERT INTO ury_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Hwëna kim zë yaïng gweꞌak, dekam zep hla nul kïnïk, “Lïlïkïn kaso yala in mes irhi nul kïnïl.” ");
INSERT INTO ury_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ki zep hëndep kaso hula iwe bïtï gwek. Hwëna wal seiwirsi zep zë hla daꞌak. Baju ngap-ngap ala son naban dam taha san dekam nikinꞌinka. Ausa zep zë nohloblak. ");
INSERT INTO ury_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Hwëna wal sewiri in zep gubiridaka, “Bahem ëaïrïn! Em an Nazaret walya Yesussue lëblaꞌan– te-lidak sonnak insa makan da inkke. Bian Alap mes tïn nïkon ngaya tala! Zen awe hom. Emki sap hlaun– an zao sap nën nekye. ");
INSERT INTO ury_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Dekam sek gwek. Ola ansa zëre hon de ang ta gwen wenya kip olzimhak– hen nonol tanganna Petrus hup, ‘Yesus mes emsa Galilea san dep ngeirbiridala. Em zao esa ërtower– men kirekam Zëna emsa hamal hap gu-gubirida gwekake.’” ");
INSERT INTO ury_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","We walya in dekam zep au hlon hap hen aïrïn hïp yal-yala ban heya-hya gwek. Zep hëndep oranak men desa zini nolëtoweꞌak, desa donbirida srëm gwek. MARKUS MO OLA ZAO-EN ZAUSUNUN  ");
INSERT INTO ury_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesus in kim tïlkï, hwëna zëno kaꞌankam, Minggukam, zep etan ngaya gweka. Dekam zep kak tangannak nonol tanganna Magdala kore wenya Maria onak Zënaka zertrëka. Maria in, zen men zëbon onakon Yesus orep tujukam de dowala golëalsa sonekake. ");
INSERT INTO ury_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yesus kim hli yulku, Maria dekam zep song gwek– men zen Yesus hun nërgwë gwekke, desa de tonbiridan hap. Zen hwëna kwasang hap nama sei gosa dablaꞌak. ");
INSERT INTO ury_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Zen kim anakan ësak, “Yesus mes ngaya gwera. Ëe kië hla tal,” hwëna zen hom daïblïbik. ");
INSERT INTO ury_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Zao hom holo gweꞌak, dekam zep etan aha nwe-masekam hwëna zi dare hap Zënaka zertreizimki. Zi darena in Yerusalem kon Yesus zëre hon de seblaskam ang ta gwen wenya ban de lowehen nakon aha ësan dep song ëꞌanka. Hwëna oranak zep Yesussu ërtoweꞌanka. ");
INSERT INTO ury_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Zi darena in dekon zep etan ola halka– anakan de lonbiridan hap, “Ëe mese hen ërtowenan!” Hwëna Yesus hon de ang ta gwen wenya in desa hen hom daïblïzimk. ");
INSERT INTO ury_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Zao hom holo gweꞌak, ki zep etan seblaskam de zëre hon ang ta gwen wenyak tembane tannak Zënaka zertreizimki. Dekam zep nol drak-drak hap jal gwibiridaka, sap men zen tïn hyanak hla da gweꞌak, desa de salbiridankam hom mae daïblïbirida gweꞌak. ");
INSERT INTO ury_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ki zep hwëna gubiridaka, “Dekam sek gwek. Abe hap de ol dawemna tïngare lang san kïtak de zi ausu hap olzim halada gwek. ");
INSERT INTO ury_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tïngare zini men zen de Asa daïblï gweblaꞌak, hen zëre mae mo Asa de taïblïblanna insa de baptis gwenkam noltrë gweꞌak, zen zen sa ëngaya gwer. Hwëna Asa de taïblïblan srëm wenya, desa Alap sa karek tabiri. ");
INSERT INTO ury_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Men zen de Asa daïblï gweblaꞌak, zen zen sa hwëna owas-owasna aha zi dikim Asa taïblï gweblan hap dena syal neibir-zimnira gwer. Zen zep sa dowal-dowala ano bosekam nolëalsa sone gwibir. Hen zëre mae mo tame gun srëm olkam sa owas hap ëton gwer. ");
INSERT INTO ury_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Zen hen sap sa wanya jal-jala tahakam deirensïk gwibir. Hen zen sap sa hasom nabare hona notde gwibir. Zen molya kim juwe gwek. Zen de zi sang-sang hap tahasa tehabirida ine gwenkam, zen dekam sa ëdawem gwe-gwer.” ");
INSERT INTO ury_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bian Yesus in kim kirekam tonbiridasïkï, ki zep hwëna Alap ngatan zi mo lang san dep zer ine halka– zao de zëre mo dam taha nakon teipsïnkïm nikirin hip. ");
INSERT INTO ury_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Zëre hon de ang ta gwen wenya in dekam zep hwëna ol dawemna insa tïngare lang san dep nol halada gwek. In desan ki nol halada gwek, Bian Zëna man zë mas gwibirida gweka, hen sosonna owas-owassa dikim syal gwe-gwibir-zimdin hip dena man mam gul gwizimki– zëno mae mo olsa dikim taïblï gwibin hip.");
INSERT INTO ury_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Dawem Bian Teopilus Bak, Lukas onakon: Alap mensa orep nësa gu-gubirida gweka– zëre mo Walassa de nëp zer sonezimdin hip dena, Zen mes ki hëndep nër hom nëno mae mo ngïrïnnïk kirekam syal gwibirki. Zëno awe de gwën hap dena angkam aïsïlï an desaë kon gwisibir hanaꞌan. Zini men zen nonol kon gwisibir hanan nakon zëre mae mo nwekam hla nul gwek, zen zep aïsïlï ansa zi-ë zi-ë san dep nol halada gwek. Dekam zini beya nik sap dawem enkam de aïsïlï ansa ale gun hup ëakasïk gwek. ");
INSERT INTO ury_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ëe hwëna men zen nonola kon hla nul gwek, ëe ama desa dawem enkam takensibirida gwek. Hen zen men desa ale nul gwek, ëe ama desa baca gul gwek. Zen zebë hëndep anakan enlala gwibik, “Aïsïlï an ëe asa Bian Teopilus hup dam-dam enkam ale gulblul– aha-en mae de hli yul guk kïnïn srëmkam.” ");
INSERT INTO ury_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ëe mae habë ansa ebe hap ale gulbluk: Em ekakim anakan tawa gwe, “Nonol men desa emsa tawa da gwek, zen eiwa de tanganna.” ");
INSERT INTO ury_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes in kim teipsïnkïm Yerusalem mo langnak ïrïk gïlkï, Alap mo golak de syal gwe-gwen zini bosena Zakaria, zen hen dekam zëwe. Zakaria, orep de Alap mo golak de syal gwe-gwen zini Abia Swe mo hlïknak hen syal gwe-gweka. We zem bosena Elisabet. We zik mo auyan-azana hen Alap mo golak de syal ta gwen zi. ");
INSERT INTO ury_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","We-zi darena in man tangan Alap mo nwenak oto eisïk. Hen zen aha-ere enlalakam tïngare Alap mo ol san hen tïtï tabin sin ang ë gwek. ");
INSERT INTO ury_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Zen hwëna hom walasna wë lak. Zen Alap ki kirekam Elisabetsa enlala gwibirki. Zep hëndep walas srëmkam bogol ëk. ");
INSERT INTO ury_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Abia mo hlïknak dinik dikim Alap mo golak syal tan hap denak kim zauk, zao de yaklanak dekam zep Zakariasa zen de syal gwen hap dam dasïk. ");
INSERT INTO ury_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Men kirekam Alap mo golak de syal ta gwen zini zisi dam dasïk gwibirin, zen kirekam Zakariasa dam dasïk. Zen mae hap dam dasïk: Zen de zë-en Alap zëre en hap de teksonnak tïn hïp– irase dawem nabare te kïlsï de zë Alap hap ang gulsublun hap. ");
INSERT INTO ury_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","In kim ki kiresa de syal gwibin hip denak zauꞌuk, zi beyana dekam zep eihya lip nakore tekson nakon Biansa nen soneblaꞌak. ");
INSERT INTO ury_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kim zëwe irase dawem nabare te kïlï insa ang gulsuꞌunka, ki zep hwëna Alap mo dam taha nakore zini ang gul gwen hap de meja alpnak zauꞌun zaka– Zakaria mo dam taha san dekam. ");
INSERT INTO ury_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakaria kim hla taka, ki zep auna hloblaka, hëndep man zë aïrïblaka. ");
INSERT INTO ury_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Hwëna Alap mo dam taha nakore zini in ki zep gubluka, “Zakaria, bahem asa aïrïblan. Alap mes eno ol gu sonenna salka. We om Elisabet zi walassa sa ebe hap wë tablal. Yohaniskim bose ta. ");
INSERT INTO ury_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kim de jaha gweꞌak, em dekam esa tangan sam gwesïk gweblala, hëndep esa isrip-sri gwe-gweblala. Aha zi hen beya nik sa isrip-sri në gweblal. ");
INSERT INTO ury_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Zen Bian mo nwenak zi yawal hap sa jowera. Alap mo Enhona jaha gwen nakon sa ki hëndep bi gweblala. Zep angguru ban ho jal-jala ban bap zen otde gwen. ");
INSERT INTO ury_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Zen Zen sa Israelk de zini beyakam Bian osan dep kwang guludahal zala– zëre mae mo Alap hon depye. ");
INSERT INTO ury_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Hen Zen Zen sa Biansa ngeirbli zala. Zëno tahana Alap mo ol ayang gul gwen zini Elia Bak mo kim sa soson nëblal, hen zëno enhona zëno kim sa lwablala. Hen Israelk de zini men zen iye zeban zënaka gïl-gïl neibirida gwenan, zen zen sa desa siri gulsulu. Hen srë de ora san de ëgwahan wenya, zen zen sa desa eiwa de ora san dep kwang guludahal zala. Zen kirekam sa zi beyana Bian de hata zannak dep hamal gulu.” ");
INSERT INTO ury_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaria ki zep takensïblïka, “Banakarekam asa tawa gwer?– eiwa diki lwankam. Sap ëe mesë bogol gwek, hen ano wenya mes-am tangan bogol gwek.” ");
INSERT INTO ury_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ki zep ding gulbluka, “Ëe an Gabriel. Bian mo dang nakonë zauk gwenan. Zen zep asa emsa de ol dawemna ansa tawa tan hap zer sonera. ");
INSERT INTO ury_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Insa ki emsa gublunan, Alap sa ki hëndep kirekam ebe hap syal gwibir-blira. Hwëna em home asa taïblïblanda. Zep hëndep angkam em molye ola tonka. Em esa ol srëm gwera, hëndep mes ki lwanan.” ");
INSERT INTO ury_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kim nësbla tinek, ki zep hëndep denggwanblaꞌak, “Zen ba hap kire tangankam holo gweꞌan ora?” ");
INSERT INTO ury_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kim kon wet so zaka, zen banakan dep?– ol tonbiridanna. Taha enkam zep akan-akan gwibiridaꞌanka, sap zen mes ol srëm gweka. Zi beyana in dekam zep anakan tame dak, “O an nwe nik zë lirisin nëblaon.” ");
INSERT INTO ury_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakaria Bak mo Alap mo golak de syala kim tap gweblak, dekam zep zëre mo gol san dep song gweka. ");
INSERT INTO ury_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hom holo gweꞌak, dekam zep hëndep we zem Elisabet u gweꞌak. Dekam zep saher hap gol ennak gwë gwek– holona benna aha-ere taha-tap enkam. ");
INSERT INTO ury_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Zen man enlala gwe-gwek, “Na-en babë tawa tabin. Dikire tïngan anakan asa tame nuk, ‘In Bian kwasang gwibirki.’ Ëe an sap bogola, hwëna ano walas wë tan srëm hap de sahera zi nwenak Bian Zën ap ngan gulsubiꞌira.” ");
INSERT INTO ury_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet kim benna enam enkam u nuban gwëꞌak, Alap ki zep zëre mo dam taha nakore zini Gabrielsa etan Galilea mo langnak de ëna Nazaret san dep zer soneka. ");
INSERT INTO ury_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Gabriel ki zep kwalbasa lam gunnu Maria osan dep song gweka. Zen Yusup hup de golgu gweblanna. Yusup mo auyan-azana teipsïn zini Daud onakon. ");
INSERT INTO ury_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Alap mo dam taha nakore zini in ki zep Maria hon hataka, zao zep gubir zika, “Dawem! Em Alap mo kwasang-kwasangnake gwëꞌara! Bian man emsa dawem tangankam kara gul gwenda!” ");
INSERT INTO ury_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Zëno ola insa de sankam, Maria ki zep auna hlok, dekam zep zënaka enlala ennak mae hap takensibik, “An ba hap ki kirekam asa gubirida?” ");
INSERT INTO ury_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Hwëna ki zep etan gubirki, “Bahem aïrïn, Maria, sap em ema Alap mo nwenak sam gwesïꞌïra. ");
INSERT INTO ury_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Em esa u gwera. Zi walassa esa jaha gwera. Yesuskum bose ta. ");
INSERT INTO ury_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Zen sa teipsïlï, hëndep dekam sa nen gweblal, ‘Alap Teipsïn Zi nik mo Tane.’ Bian Alap sa Desa gublula– Zen de Israelsa bi gwibin hip, zëre mo auyanna Daud Bak mo kim. ");
INSERT INTO ury_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Zen Zen sa hëndep denaban kïtak Yakob mo auyan-azana ïrïk gïlï. Zëno ïrïk gïnnï in molya tap gwek.” ");
INSERT INTO ury_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria ki zep gubluk, “Hwëna ëe an homë zi mae naban gaïng ëꞌan. Ëe banakan asa walas gwer?” ");
INSERT INTO ury_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ki zep ding gulbirki, “Alap mo Enho sa ebon ing gwehe zala, hen Alap mo soson sa emsa bi gwibiri. Zen zep sa walas tola insa nen gweblal, ‘Zen Alap mo Tane– enho lalak enna.’ ");
INSERT INTO ury_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","An kirekamë emsa gubirin, zen mes ki iye om Elisabet hon kirekam lwak. Zen mes u gwek– benna angkam enam enkam. Zen sap bogola, hen zini mes anakan nenbik, ‘An Alap ki walas srëm gulku.’ ");
INSERT INTO ury_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Hwëna zen angkam u nuban gwëꞌan. Sap Alap hap hom– banakare maena, Zen de syal gwibin srëm hap denaye.” ");
INSERT INTO ury_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria ki zep ding gulbluk, “Ëe an Bian mo tana ïltïkïnnïk de gwë gwen wesyake. Sap sa ki kirekam abon onak lwal– in kirekam em asa gubiridaye.” Alap mo dam taha nakore zini in ki zep hli yulku. ");
INSERT INTO ury_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Alap mo dam taha nakore zini in kim hli yulku, holo gwehan srëmnak Maria dekam zep hen soson tola ban Yerusalem mo kwatap lang san dep song gwek– Zakaria ne Elisabet nik mo ë san dep. ");
INSERT INTO ury_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zakaria mo golak kim hatak, ki zep Elisabetsa dawem gul kïnïk. ");
INSERT INTO ury_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet kim Maria mo dawemna insa salbik, ungala mwanak de walasna in dekam zep soson gweka. Alap mo Enhona dekam zep Elisabetsa ing gwe hebirki, ");
INSERT INTO ury_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ki zep Mariasa ol mamkam gubik, “Em ene tïngare we walya kon dawemna hlauꞌura! Hen Alap eno walasna in hap dawemsa sa golblala. ");
INSERT INTO ury_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ëe an betekna, hwëna em in Teipsïn Zini Bian mo anee ano golak hatanda! ");
INSERT INTO ury_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ëe kimë eno dawemna sal, ano ungala mwanak de walasna dekam zep isrip-sri naban soson gwera. ");
INSERT INTO ury_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ebe hap Bian hëꞌho gwibin tangan naka golbiꞌira, sap men zen ebon onak Bian mo ola hatak, em ema taïblïbirki, hen zen kirekam sa ki lwal!” ");
INSERT INTO ury_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria ki zep guk, “Ëe ama Bian Alapsa boltere taꞌan, ");
INSERT INTO ury_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","hen ano enhona man isrip-sri gweblaꞌara, sap Zen Zen sa asa ngaya gulu. ");
INSERT INTO ury_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Zen man asa enlala gwibirki, hwëna ëe an Zëbon de babu gwe-gwen we– bose srëm tola. Hwëna angkam tïngare zi ausuna hëndep denaban sa asa nen gwibir, ‘Hëꞌho gwibin tanganna zen zen hlauk.’ ");
INSERT INTO ury_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Sap soson Zini Alap, Zen eiwa lalak tanganna, hwëna Zen man kirekam-kirekam yawala abe hap syal gwe-gwibir-biꞌira. ");
INSERT INTO ury_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Auyan-aza nakon hëndep auyan-azana, Zënaka de aïrïblan zi hip Zen man zëre mo kwasangna gol gwizimnira. ");
INSERT INTO ury_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Bian men kirekam orep zëre mo sosonna goltrei gwizimki, Zen kirekam etan angkam goltreizimꞌira: Zen orep zi zëna-zënana man sekwak gulsuk gweka, hen zëno mae mo kalang karekna man blaonsuk gwizimki. ");
INSERT INTO ury_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Zen hen orep teipsïn-teipsïn wenyaka zëre mae mo teinikin gwen nakon man yal gul sone gweka, hwëna bose srëm wenyaka zep kang gulse gweka. ");
INSERT INTO ury_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Usak nabare wenya desa man dërek-dërekna kim ïtrï ta gwibirki. Hwëna men zen nonol tahalha srëmkam lowehe gwek, desa man gubirida gweka, ‘Usak naban sekwak gwek.’ Hwëna angkam Alap etan kirekam nëbe mae hap syal gwibir-zimꞌira. ");
INSERT INTO ury_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Nëno mae mo auyanna Abrahamsa hen zëno auyan-tane walya men kirekam gu-gubirida gweka, Zen angkam kirekam Israelsa mas gwibiridaꞌara. Zen man anakan gu-gubirida gweka, ‘Ano ebe mae hap de kwasang-kwasangna hëndep denaban sa lwa gwer. Ëe molyë golzausuk gwek.’ Zen desa angkam enlala gwibiꞌira.” ");
INSERT INTO ury_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria Elisabet han san ha dan-ahare benkam ëk, ki zep etan zëre mo ë san dep lwahak. ");
INSERT INTO ury_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet de jaha gwen hap denak kim zauk, zi walassa zep jaha gwek. ");
INSERT INTO ury_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Gol golek dena hen iye zem kim anakan ësak, “Bian mes Elisabet hap kwasangna mamkam golbiri,” dekam zep tagal neisibirzik, hen dekam zep zë apdekam ëisrip-sri gwek. ");
INSERT INTO ury_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Walasna in kim mingguna aha-en gweblak, ki zep etan tagal nëblak– to mip naka dikim blaonsublun hap. Zen man ëkïl gïꞌïk, “An zëre mo Bian mo bosekam esa bose lal– ‘Zakaria’kam.” ");
INSERT INTO ury_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Hwëna an zik zep gubiridak, “Kirekam bëjen nen bose tan! An ‘Yohanis’kim esa bose lal.” ");
INSERT INTO ury_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Dekam zep denggwanbiꞌik, “Iye wal om hom tanganke– kire bose naye!” ");
INSERT INTO ury_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ki zep tahakam Zakariasa akan-akan nëblak– anakan de takensïblïn hap, “Ena banakan de bose tan habe dwam gweblaꞌara?” ");
INSERT INTO ury_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakaria hom nama dekam ola tonꞌanka. Ki zep te hlang hap abe gweka, dekam zep zë ale gulku, “An bosena Yohanis.” Dekam zep tïngan denggwanblak. ");
INSERT INTO ury_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Dekam zep hëndep ola etan tonka. Alap mo bose ensa zep ïlman gul tineka. ");
INSERT INTO ury_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Zëno gol golek denak dena dekam zep sërkam denggwanblaꞌak, hen tïngare Yerusalem mo kwatap lang san de lowe hendan wenya desa man donbirida gwek. ");
INSERT INTO ury_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tïngare zini men zen ësak, ki zep enlala ennak ëenlala gwe-gweꞌak, “Walasna in banakare zi hip wëhë yap joweꞌanka?” Zen mae hap ki kirekam ëgu gwek: Sap Bian mo sosonna man Zëbon lwa gweꞌak. ");
INSERT INTO ury_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Walas zemka in kim “Yohanis”kim bose dak, dekam zep Alap mo Enhona Zakariasa bi gweblaka, dekam zep Alap onakore hamal hap de ola tonbiridaka, ");
INSERT INTO ury_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Bian en hap nen dawemsa golbla tine gwen– Israel mo Alap hap. Zen mes hatala– zëre kore naka de kwasang gwibiridan hap, hen dekam de dowal mo kïgï mo ïrïk gïn nïkon gwiswe sonen hap. ");
INSERT INTO ury_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Zen mes nëbe mae hap Zi sosonna zer sonezimki– nësa de ngaya tabin hip de Zi niye, teipsïn zini Daud Bak, men zen Alap mo dwam gwibin sin ang gwe-gwekake, zëno auyan-aza nakore naka. ");
INSERT INTO ury_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Alap mo ol ayang gul gwen zini orep tangan mes anakan ëgu-guk gwek, ");
INSERT INTO ury_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Nësa de ngaya tabin hip de Zini sa hatala– Zen de nësa jal zi mo taha nakon alal gul gwen hap.’ ");
INSERT INTO ury_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Hen anakan mes gu-gubirida gweka, ‘Ëe asa Ëre mo ebe mae hap de ol gu-gubiridanna enlala gwibir, zep asa hëndep emsa kwasang gwibiridal.’ ");
INSERT INTO ury_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Alap mes nëno mae mo auyanna Abrahamsa anakan gu-gubluka, ");
INSERT INTO ury_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‘Emsa de tamera gwen zi mo taha nakon Ëe asa emsa al gul halzal. Zen dekam esa aïrïn srëmkam Asa betek ë gweblal.’ ");
INSERT INTO ury_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Zep nen enho lalakkam esa Alap en hon ëtal gwesïl, hen zëno nwe kara gwennak esa hëndep denaban lowehe gwer.” ");
INSERT INTO ury_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zakaria ki zep hwëna tane zikhip dena aïsïl gwenkam ayang gulku, “Em, ano walas, emsa sa nen gweblal, ‘Alap Teipsïn Zi nik mo olsa de ayang gul gwizimdin hip de zini.’ Em esa Biansa ngeirblira– zëbe hap de orasa sal tablan hap, ");
INSERT INTO ury_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","hen Bian mo hlïl irin wenyaka esa anakan tawa ta gwibiri, ‘Alap sa emsa eno mae mo karek-kareksa de tap gulsuzimdinkim ngaya tabiri.’ ");
INSERT INTO ury_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sap nëno mae mo Alapna Zen kae-kaena hen kwasang-kwasang enna. Zen zep sa nësa de ngatan tabin hip de Zini insa zer sonera. Zen ngatan zi mo lang nakon kaknak de yakla hata sezan mo kim sa zïlsï zïla. ");
INSERT INTO ury_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Zen dekam sa tïngare zi ausuna ngatan tabir zira hen ngaya tabiri, sap zen tïngan kawesïnnïk lowe heꞌan, hen tïn hïp ëaïrï gwenan. Zen Zëbon onakon esa Alap han ërumlae gwer, hen zi bosyan naban ëumlae gwer.” ");
INSERT INTO ury_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Zakaria mo tanena Yohanis in kim mam gweꞌanka, Alap osan dep de enlalana hen dekam zep mam gweblaꞌanka. Zen zi srëm langnak gwë gweka– hëndep yaklana mensa Bian Alap dam tasïblïka. Zao kim hatak, zen dekam zep tïngare Israelk de zi hip zënaka zertreizimki. ");
INSERT INTO ury_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Dekam teipsïn tangan zini ki, zen langna beya en tangan naka Roma kon ïrïk gïlkï. Zen dekam zep tïngare zisi de zëre mo ïrïk gïn nïka aïtbin hip gubiridaka. ");
INSERT INTO ury_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","An nonol aïtbinni– Kirenius men kim Siria mo langnak gubernor gwekake. ");
INSERT INTO ury_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tïngare zini dekam zep zëre mae mo auyan-aza mo ë-ë san dep sek gwendak– zëno mae mo bosem-sesa dikim zë ale tabir-zimdin hip. ");
INSERT INTO ury_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Yusup ne Maria ne dekam zep hen kire hap Galilea mo langnak de ëna Nazaret kon Yerusalem mo langnak de aha ëna Betlehem san dep song ëk– teipsïn zini Daudsa men zao orep jaha gwekke. Sap Yusup mo auyan-azana Daud onakon. Zëbe hap de golgu gweblan wenya Maria in dekam u nuban gwëꞌak. ");
INSERT INTO ury_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Betlehemk hom tangan holo ëꞌak, Maria ki zep zi walassa jaha gwek– nonol walassa. Kaen hak-haknak zep tahalek, desa zep domba-sapi mo tembane ta gwen kolho makarenak drënek. Sap kïtak de gol-gola mes zi enkam ëbeya gwek. ");
INSERT INTO ury_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Langna iwe dekam domba zaho ta gwibin wenya man kam domba zaho zemka sonak kara dabiꞌik. ");
INSERT INTO ury_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Hwëna Alap mo dam taha nakore zini ki zep zëbon mae onak jowe ane zaka, hen Bian mo ngatanna man zë zïlbirida anezak. Karekkam zep zë ëaïrïꞌak. ");
INSERT INTO ury_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Hwëna Alap mo dam taha nakore zini in ki zep gubiridaka, “Bahem ëaïrïn, sap ëe an ol dawemsaë ebe mae hap golhatazimninzal. Ola ansa de ësankam, tïngare zini sërkam tangan sa ëisrip-sri gwer. ");
INSERT INTO ury_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Namen, Daud mo ënak, wenya man jaha gwer– emsa de ngaya tabin hip de Teipsïn nïka, Alap mensa dam tasïkïke. ");
INSERT INTO ury_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ol tan-tansaë ebe mae hap golzimꞌin: Em esa walas tolsa deyol hak-hakkam de tahalen naka hla lal. Domba mo tembane ta gwennak taꞌara. Zen dekam esa anakan dam lasïl, ‘An Zen.’” ");
INSERT INTO ury_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ki zep hwëna mumuk ennak ahakore Alap mo dam taha nakore zini beya en tangankam ëjowezak, ki zep zë Alapsa isrip-sri nëblaꞌak, ");
INSERT INTO ury_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Alap Em eiwa teipsïn tanganna! Eno bosena dikire kïtak teip nulsuk gweblak. Sap angkam ema okamanak de zi niban golësësek gweꞌara– ere mo nwenak men zen oto gwesïꞌïnye.” ");
INSERT INTO ury_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Alap mo dam taha nakore zini in kim etan ngatan zi mo lang san dep sesek gwesek, zini in dekam zep ëguk, “Nen ki nabakam Betlehem san dep gweyo gwen– eka ki zë hla kuk, in desa Bian nësa gubiridandake.” ");
INSERT INTO ury_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ki zep hëndep sek gwek. Dekam zep hëndep Yusup ne Maria neka nakek, hen walas tola insa dekam zep hla dak– domba mo tembane ta gwen kolho makarenak de tannak. ");
INSERT INTO ury_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","In kim hla dak, dekam zep kïtak donbiridak– walas tola in hap dena, men desa Alap mo dam tahana kore zini in tonbiridakaye. ");
INSERT INTO ury_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ola insa de ësane gwenkam, tïngare zini man tangan ëtenggwank. ");
INSERT INTO ury_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Hwëna Maria zëna, in zen ki zë lwa gweꞌak, desa kïtak enlala ennak lam gul gweꞌak hen enlala gwe-gwibiꞌik. ");
INSERT INTO ury_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Zini in ki zep etan Alapsa de tërya ban boltere tan naban lwan dahak. Sap tïngan mensa ësane gwek hen hla nuk, zen hëndep men kirekam Alap mo dam tahana kore zini in gubiridakake. ");
INSERT INTO ury_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Walas tola insa kim mingguna aha-en tap gweblak, dekam zep to mipna nablonsubluk, hen dekam zep “Yesus”kum bose dak– men kirekam Alap mo dam taha nakore zini Mariasa u gwen srëmnak gubirkike. ");
INSERT INTO ury_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Musa Bak men desa nonol zi walas wë tan hap dena zëre mo tïtï tabin olak ale gulku, Maria ne Yusup ne man desan ang ëk. Zen nonol Maria de sasa gwesïnnïk dep orapna empat-pulu enkam eissïk, dekam zep walas tola insa Yerusalem san ërzahek– Alap hap dikim ërtrëblan hap. ");
INSERT INTO ury_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Mae hap ërtrëblak: Sap Musa mes ki zëre mo tïtï tabin olak anakan ale gulku, “Tïngare nonol zi walas wë tanna, zen Alap zëre hap dena. Zep emki zëre hap zertrë gweblan.” ");
INSERT INTO ury_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Zen hen man ang ëk– mawasa de dan-dan Alap hap teisyablanna, desa de Alap mo golak de syal tan zi ang sosublun hap. Sap Musa mo tïtï tabin olak nonol walas wë tansa de Alap hap zertrëblan hap dena kirekam hen lwak. ");
INSERT INTO ury_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Dekam Yerusalemk, zini bosena Simeon. Zini in enho dam-damkam gwë gweka hen Alap hon mes tangan tal gwesïkï. Zen man Alapsa Israelsa de dawem gun hup kara ta gweka, hen Alap mo Enho zergwë gweka. ");
INSERT INTO ury_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Alap mo Enhona mes hamal hap gu-gubluka, “Em molye na-en tïlkï– Teipsïn Zini insa de hla tan srëmnakye, Ëe Mensa Israelsa de ngaya tabin hip dam tasïkye.” ");
INSERT INTO ury_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Dekam zep hen Simeonsa Alap mo Enhona anakan gubluka, “Emki Alap mo golak de teksonna iwe tïn.” Hwëna Maria ne Yusup ne dekam zep hen Yesussu Alap hap de zertrëblan hap ërtïꞌïnzak– Musa mo ola in san de ang ën hap. ");
INSERT INTO ury_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon dekam zep hëndep walas tola insa zer inki, ki zep dawemna Alap hap golblaka, ");
INSERT INTO ury_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Teipsïn Zini Bian, angkam Eno asa de gu-guk gweblanna mese eiwa de guluda. Ema asa sam tanda. Zep ere hon de babu gwen zini ëe angkam mesë auhu-kamana ansa de hli yun hup hohle gwenan. ");
INSERT INTO ury_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Sap angkam ëe mesë ëre mo nwekam hla tanan– ere mo zisi de ngaya tabin hip de Zi zer sonen naye, ");
INSERT INTO ury_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","men Desa Ena tïngare zi dikim tame tan hap hamal takaye. ");
INSERT INTO ury_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Zen Zen sa ngatanna golzimdi– tïngare zi ausu mo enlalasa dikim ngatan tazimdin hipye. Hen zen Zëbon onakon sa Israel mo bosena dawem gwer.” ");
INSERT INTO ury_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","An-bi zem man tangan lenggwanꞌak– Simeon mo ola insa kim zëre nik mo walasna in hap dena sane ëꞌakye. ");
INSERT INTO ury_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon ki zep guzimki, “Bian sa ep dawemna golzimdi.” Hen Mariasa ki zep gubirki, “Walas tola an mes Alap dam tasïkï– Zen de Israelk de zisi klis gun hup. Dawem gol gwen wenya, desa Alap zëre hap sa kang gul seblala. Hwëna karek gol gwen wenya, desa hëndep kareknak sa kang gulu. Sap An Alap mo dam tasïn Zi, zep sa hen zini beya nik lamang da gwer. ");
INSERT INTO ury_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Alap insa kirekam syal gwibiꞌira, zini zen dekam sa zëre mae mo enlala aning tanna nërtrë gwer. Hwëna Maria, eno enhonak enlwan yawal sa hen nëbok ben-ben makan tïsïl.” ");
INSERT INTO ury_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","We sem bogola Hana Bak dekam zao hen gwëꞌak. Zen Alap mo hamal hap de olsa de ayang gul gwen hap de we. Zëno biana Panuel– Asyer Bak mo auyan-aza nakorena. Wenya in zi zeban tuju tahun enkam ëk, ");
INSERT INTO ury_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","dekam hwëna sem nik zep zë-en holokam gwë gwek. Hëndep in kim Yesussu ërtïlzïk, zëno tahuna dekam 84 enkam. Zen hom tangan Alap mo gola langa gulsuk gwek. Yaklam denaban kam denaban zen dekon Alapsa isrip-sri gwebla tine gwek hen gu sonebla tine gwek– tembane lwa gwen naban. ");
INSERT INTO ury_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Zen dekam zep hen hatazak, dekam zep Alap hap dawemsa golblak. Hen men zen zë lowe heꞌak, dekam zep desa anakan tonbiridaꞌak, “Walasna an Zen Zen sa jal zi mo ïrïk gïn nïkon nësa gwiswe sonera.” ");
INSERT INTO ury_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yusup ne Maria ne in kim zë Musa mo tïtï tabin ola insa syal eisibik– nonol walas wë tan hap dena, dekam zep etan zëre nik mo ëna Nazaret san dep ërlwahak– Galilea mo langnak dep. ");
INSERT INTO ury_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Walas tola in ki zep hëndep mam gweꞌanka, hen sosonna mam gweblaꞌak, hen enlala blala dekam zep tangan mam gweblaꞌanka. Hen Alap mo kwasang-kwasangna Zëbon lwa gweꞌak. ");
INSERT INTO ury_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tahunna men kiye, Yesus mo ane-biana man yakla yala Paskanak dep Yerusalem san dep yahe gwek. ");
INSERT INTO ury_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesus mo tahunna kim dua-blas gwek, ki zep etan kire san dep sek gwek– men kirekam Israelk de zini ëgwë gwekke. ");
INSERT INTO ury_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kim ëhya gwesïk, ki zep etan lwan dahak, hwëna Yesus man Yerusalemk gwëka. Hwëna an-bi zem hom anakan tawa ëblak, “Zen man gwëra.” ");
INSERT INTO ury_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Zen zi beya hap tim uk, “Zen hen mes ang gwe zala.” Hwëna hom. In kim song ëk, truwe guk gwennak kim kam-en yaïng gwek, dekam zep ohwensïblïk. Dekam zep iye zem osan hen wal bose wal zem osan lëblak. ");
INSERT INTO ury_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Hwëna hom hla lak. Kaꞌan zep kaknak etan Yerusalem san dep olahak– zëwe de lëblan hap. ");
INSERT INTO ury_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yaklana dan-ahanna kim zep hla lak. Zen Alap mo golak nikinꞌinka, Alap mo olsa de tawa ta gwibin wenyaka sane tabiꞌinka, hen man takensibirida gweꞌanka. ");
INSERT INTO ury_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tïngare zini men zen sane da gweꞌak, zëno enlala blala man anakan denggwan gweblaꞌak, “Owas, zen en ba hap dam gulsuk gweꞌara?” ");
INSERT INTO ury_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","An-bi zem hen man tangan zao de hla lankam lenggwanblak. An zem ki zep gubluk, “Temlan, em ba habe kirekam asa gweizimki? Ëe bia han ngalap nabanë emsa ahakalblal!” ");
INSERT INTO ury_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ki zep ding gulbirki, “Em ba habe srën san Asa ahakalblaka? Zen emaka enlala ëka, ‘Zen Bi zik mo golak gwëꞌara.’” ");
INSERT INTO ury_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Hwëna zen hom zëno ding gulzimdinni insa tame ulblik. ");
INSERT INTO ury_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Dekam zep etan Nazaret san dep ang gwizimki, hen dekam man zë betek gwe-gwizimki. Maria kirekam-kirekamna insa tane zikhip dena hlaul gwek, desa enlala ennak lam gul gwek. ");
INSERT INTO ury_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus kim mam gweꞌanka, enlala blala dekam zep hen mam gweblaꞌanka. Zen man tangan Alap mo nwenak hen tïngare zi mo nwenak oto gwesïkï. ");
INSERT INTO ury_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Roma mo teipsïn tangan zini Tiberius Bak, zëno ïrïk gïn tahunna kim lima-blas gwek, Alap dekam zep syala Yohanis hip wei yul soneblaka. Dekam men zen Roma mo teipsïn tangan zini in mo alp nakon ïrïk nïk, Pontius Pilatus Bak dekam Yerusalem mo langnak ïrïk gïlkï, Herodes dekam Galileak ïrïk gïlkï. Herodes mo ayana Pilipus Bak dekam Itureak hen Trakonitisk ïrïk gïlkï, hen Lisanias Bak dekam Abilenek ïrïk gïlkï. ");
INSERT INTO ury_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Alap mo golak de syal tan zi mo teipsïnnï dekam Hanas han Kayafas han. Hwëna dekam zep zi srëm langnak Alap mo ola Zakaria mo tanena Yohanis hon hatak. ");
INSERT INTO ury_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohanis dekam zep Alap onakore olkam Yordan mo lang san kïtak tïtï tabir song gweka, “Ere mae mo karek-karek nakon em ëhalen. Alap dekam sa eno mae mo karek-karekna tap gulsuzimdi. Em dikim enaka anakan golëtrën hap, ‘Ëe ama angkam Alapsa ang gweblaꞌan,’ ëe ki asa hwëna emsa baptis tabir.” ");
INSERT INTO ury_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yohanis zen orasa de sal tablan hap de zini men zëbe hap Yesaya Bak Alap mo olak hamal hap anakan ale gulblukake, “Zini sa zi srëm lang nakon taken gwera, ‘Haen, nëre mae mo Teipsïn Zi hip nen orasa hamal ta gublun! Hen nen dam-dam ta gublun! ");
INSERT INTO ury_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tïngare dwrak-dwraknak kamasa nen bwang gun, hen tïngare kwatapna betekna hen yawala nen talen– dekam de sësek gwen hap. Ora gwa-gwana nen dam-dam tasïn. Tung-tungna hen nen sësek tandan. ");
INSERT INTO ury_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tïngare auhu-kamanak de zini esa hla lal– Alap onakore emsa de ngaya tabin hip de Zi niye.’” ");
INSERT INTO ury_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Zini beya tangan nik zep Yohanis hon baptis tabin hip yaïng gwe-gwek. Hwëna Yohanis zao zep gubirida gweka, “Em an gwe makare enlalana! Em ema ëenlala gweꞌan, ‘Asa de baptis tankam Alap molya asa karek tabirki.’ Hwëna em home ëhaleꞌan. Alap mo jala kon molye ëheya-hya gwek. ");
INSERT INTO ury_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Zen in zep, em de Alap mo jala insa goltowen srëm hap, emsa de baptis tan srëmnak em nonol ere mae mo lowehen karekna insa wet gulsun– dekam de emsa anakan tame tabin hip, ‘Zen mes ëhaler.’ Em bahem anakan ëkïl gïl gwen, ‘Ëe an Abraham mo auyan-aza nakore nakake. Zep asa molya Alap karek tabirki.’ Sap Alap maka eno mae mo weinak dep kaso-kasona ansa Abraham mo auyan-aza hap yang tabiꞌira. ");
INSERT INTO ury_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sap Alap mo zer sonen Zini in Zen ano lure nakon hataꞌan zala, Zen mes hlala hohle gulu– dekam de tesya lu ta gwen hapye. Tenya men zen de eini ëtë srëm gweꞌak, desa sa ausu ennak lu tala, hëndep ki sa tïnsïk gwen srëm syauk hï-hïtïnnïk yal ta sera.” ");
INSERT INTO ury_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Zen hwëna man dakensïk gweblak, “Ki ëe basa asa syal eibir– ëe dikim Alap mo jala insa goltowen srëm hapye?” ");
INSERT INTO ury_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Anakan zep ding gul gwizimki, “Eno baju de dan nënna, ahana kip em teisyablan– baju srëmna kip. Eno tembane de lwanna, em tahalha wenya kip kae gwebla-zimdin.” ");
INSERT INTO ury_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Roma mo ïrïk gïnnïk dep de pajak te-ala alal ta gwizimdin hip de zini hen man baptis tabin hip yaïng gwe-gwezak. Zen man dakensïk gweblak, “Bian, ëe basa asa syal eibir?” ");
INSERT INTO ury_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Desa man ding gul gwizimki, “Te-alana bahem mamkam alal ta gwizimdin– aha hlïk naka dikim ere mae hap kap ta-in gwen hapye. Diki Roma mo teipsïn zini men kire enkam de alal ta gwen hap emsa gubiridaka, zen kire enkam em alal ta gwizimdin.” ");
INSERT INTO ury_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Jana nabare wenya man hen dakensïk gweblak, “Zep abe mae hap hen banakan? Ëe hen banakan asa syal eibir?” Yohanis man ding gul gwizimki, “Em bahem jala ban tik-tik ta gwibin– te-alasa dikim alal tazimdin hipye. Hen anakan bahem gubirida gwen, ‘Ëe asa emsa klak tal’– ep dikim te-alasa zerzimdin hipye. Ere en mo te-alakam em lowehe gwen.” ");
INSERT INTO ury_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Yohanis hon de ësane gwenkam, zep zënaka nenbirida gweꞌak, “Eiwa, nësa de ngaya tabin hip Dinik bae ki hataꞌan zala! San ha diki an Zen mes yap?” ");
INSERT INTO ury_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hwëna ki zep gubiridaka, “Ëe weyakamë emsa baptis ta gwibi'in. Hwëna abon onakon de Teipsïn Zini sa hata zala. Ëe dawem naka hom– dekam de Zëbon onak babu gwen mae hapye. Sap zëno tana maesa de ngan sosublun hap, ëe bëjënë. Zen diki Zen sa Alap mo Enhokam emsa baptis ta gwibiri, hen syaukkum. ");
INSERT INTO ury_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Zen joksa zirensïꞌïra– dekam de lënsa lën hap. Dangnak dena, desa yunak sa bïtï tala. Hwëna syaena men zen dang alp san altïꞌïk, desa tïnsïn srëm syauk bla san dep sa yal ta sera.” ");
INSERT INTO ury_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Zen kirekam-kirekam ol zïm-zïmsï zë mas gul gwizimki– dekam de Alap onakore ol dawem san dep tïtï tabin hip. ");
INSERT INTO ury_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Hwëna zen hen Galilea mo teipsïnnï, Herodeꞌa, damnak anakan jalse gweblaka, “Em bap ere mo oso mo wenya Herodianasa al gulbluka! Hen eno aha karek-karek gulin hala seranna hen beyana!” ");
INSERT INTO ury_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hwëna Herodes dekam zep jal gweblaka. Zen dekam zep Alap mo nwenak zëre hap de karekna etan mam gulsuku– Yohanissi kim bwinak tak ta inkiye. ");
INSERT INTO ury_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Hwëna bwinak kim nama dayalsïk srëm gweꞌak, zi beyana insa kim baptis tabirida'anka, Yesussu hen dekam zep baptis taka. Yesus kim kon ola gu soneꞌanka, nglïna dekam zep hlang në hanak. ");
INSERT INTO ury_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Alap mo Enhona dekam zep mawana ohola mo nwe-masekam Zëbon onak dep ati gwe ine zaka. Ngatan zi mo lang nakon dekam zep hen ola anakan wet sohak, “Em in ëre mo Tane– ëre mo dang tïnïnak de tanganna. Ëe ama tangan Emsa sam gwesïk gweblanan.” ");
INSERT INTO ury_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesus kim syala kon gwisibir hanaꞌanka, zëno gwën tahunna san ha tiga-pulukam mes yap. Zini dekam man tim di gwek, “Zëno biana Yusup,” zep zëno auyan-aza mo bosem-sena, diki an zen: Yesus mo auyanna Eli, ");
INSERT INTO ury_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli mo biana Matat, Matat mo biana Lewi, Lewi mo biana Malki, Malki mo biana Yanai, Yanai mo biana Yusup, ");
INSERT INTO ury_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusup mo biana Matica, Matica mo biana Amos, Amos mo biana Nahum, Nahum mo biana Hesli, Hesli mo biana Nagai, ");
INSERT INTO ury_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai mo biana Maat, Maat mo biana Matica, Matica mo biana Simei, Simei mo biana Yosek, Yosek mo biana Yoda, ");
INSERT INTO ury_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda mo biana Yohanan, Yohanan mo biana Resa, Resa mo biana Zerubabel, Zerubabel mo biana Sealtiel, Sealtiel mo biana Neri, ");
INSERT INTO ury_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri mo biana Malki, Malki mo biana Adi, Adi mo biana Kosam, Kosam mo biana Elmadam, Elmadam mo biana Er, ");
INSERT INTO ury_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er mo biana Yesua, Yesua mo biana Eliezer, Eliezer mo biana Yorim, Yorim mo biana Matat, Matat mo biana Lewi, ");
INSERT INTO ury_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi mo biana Simeon, Simeon mo biana Yehuda, Yehuda mo biana Yusup, Yusup mo biana Yonam, Yonam mo biana Elyakim, ");
INSERT INTO ury_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim mo biana Melea, Melea mo biana Mina, Mina mo biana Matata, Matata mo biana Natan, Natan mo biana Daud, ");
INSERT INTO ury_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud mo biana Isai, Isai mo biana Obed, Obed mo biana Boas, Boas mo biana Salmon, Salmon mo biana Nahason, ");
INSERT INTO ury_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason mo biana Aminadab, Aminadab mo biana Admin, Admin mo biana Arni, Arni mo biana Hezron, Hezron mo biana Peres, Peres mo biana Yehuda, ");
INSERT INTO ury_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yehuda mo biana Yakob, Yakob mo biana Isak, Isak mo biana Abraham, Abraham mo biana Tera, Tera mo biana Nahor, ");
INSERT INTO ury_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor mo biana Serug, Serug mo biana Rehu, Rehu mo biana Peleg, Peleg mo biana Eber, Eber mo biana Salmon, ");
INSERT INTO ury_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salmon mo biana Kenan, Kenan mo biana Arpaksad, Arpaksad mo biana Sem, Sem mo biana Nuh, Nuh mo biana Lamek, ");
INSERT INTO ury_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek mo biana Metusalah, Metusalah mo biana Hanok, Hanok mo biana Yared, Yared mo biana Mahalalel, Mahalalel mo biana Kenan, ");
INSERT INTO ury_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan mo biana Enos, Enos mo biana Set, Set mo biana Adam, hen Adam mo biana Alap. ");
INSERT INTO ury_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesus in kim Yordan kon lwahal zaka, Alap mo Enhona dekam mes bi gweblaka. Dekam zep zi srëm lang san dep zersong gweka. ");
INSERT INTO ury_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Zëwe zep dowal mo kïgïna akasïk gwebla zaka– hëndep orapna man empat-pulu gwek. In kim zë gwë gweka, Zen tembanesa lwa gweka. Hëndep aumwa hap denak usakna mes sabak gweka. ");
INSERT INTO ury_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Zao zep dowal mo kïgïna in gublu zaka, “Em san Alap mo Tanesa hom?– zebe usak naban gwëꞌaraye. Kasona ansa emki gubin– roti hap de jowen hap.” ");
INSERT INTO ury_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesus ki zep hwëna ding gulbluka, “Alap mo olak man lwak, ‘Zini tembane en nakon hom lowehe gwenan.’” ");
INSERT INTO ury_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Dowal mo kïgïna in ki zep kon kwatap yawal san dep zersong gweka, ki zep tïngare auhu-kamanak de ïrïk gïnnï ansa hluwesïk kïnzïnnak goltrëblaka. ");
INSERT INTO ury_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Ki zep gubluka, “Alap mes tïngare ïrïk gïnnï insa abe hap golblaka, hen zëwe de kire-kire dawemna hëndep kïtak– ëe de hwëna ahana kip golblan hap, mensa Aena enlala gweblaꞌakye. Hwëna eme bokle kom soblan naban asa boltere taꞌanka, ki ebe hap asa kïtak golblal.” ");
INSERT INTO ury_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesus ki zep ding gulbluka, “Alap mo olak man lwak, ‘Bian Alap ensa em boklena kom so gweblan, hen Desa en em blikip gwesïk gweblan.’” ");
INSERT INTO ury_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Hwëna ki zep kon etan owaskam Yerusalem san zersong gweka, Alap mo gol bolak zep drëne seka. Ki zep zë gubluka, “Em san Alap mo Tanesa hom?– ki emki heya gwe inen. ");
INSERT INTO ury_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sap Alap mo olak ebe hap dena anakan lwak, ‘Alap zëre mo dam taha nakore wenyaka sa emsa de dawem enkam kara ta gwen hap gubiridala. ");
INSERT INTO ury_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Zëno mae mo taha tere san esa tënda gwera, zep em molye ba karek maena goltoweka.’ Zep em san ema Alap mo ola insa taïblïbiꞌira? Ki emki heya gwe inen.” ");
INSERT INTO ury_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesus ki zep ding gulbluka, “Alap mo olak man hen ale nuk, ‘Bian Alapsa totoresa bahem anakare hap akasïblïn, “Wëhë asa mas gweblaꞌanka?”’” ");
INSERT INTO ury_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Dowal mo kïgïna in kim akasïk gweblanna hya gwesïblïka, ki zep zë hli taka, hwëna dekam zep etan de akasïblïn hap eissïblïka. ");
INSERT INTO ury_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesus ki zep langna Galilea san dep lwa halka, hen Alap mo Enho nakore sosonna Zëbon lwa gwek, hëndep ki zep zëbe hap de ola tïngare ë-ë san ëtawa gwendak. ");
INSERT INTO ury_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Zen dekam zep but srëm gol-gol san tawa tabirida gweka. Tïngare zini man nen gweblak, “Zini in dawem tanganna.” ");
INSERT INTO ury_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesus ki zep etan Nazaret san dep lwa halka– men zëwe Zëna mam gwekake. Hari Sabatkam ki zep but srëm gol san dep song gweka– men kirekam Zëna gwë gwekake. Ki zep zë Desa dam dasïk– Zen de ngein nikon Alap mo olsa baca gulzimdin hip. ");
INSERT INTO ury_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Alap mo ol ayang gul gwen zini Yesaya Bak mo ol tataksa zep nolblak, ki zep er gulsuku, hëndep hlaulku– men desa baca gulzimdin hip dwam gwibirkike. Ki zep hëndep anakan baca gulzimki, ");
INSERT INTO ury_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Bian mo Enhona man asa bi gweblaka, sap Zen mes asa dam tasïkï– ol dawemsa de tahalha wenya kip gol gwizimdin hip, hen bwinak de wenyaka dikim anakan tonbirida gwen hap, ‘Bian sa emsa gwis gwe sonera,’ hen zi nwe dïmïn dikim nwe nik ëkara gwen hap, jap gul sonen wenyik dikim luk tan hap, ");
INSERT INTO ury_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","hen ol dawemna ansa dikim anakan tonbirida gwen hap, ‘Angkam mes hatanan– Bian de nësa dawem gun hup denaye.’” ");
INSERT INTO ury_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesus ki zep etan bukuna insa obon gul kïnïka, ki zep etan, men zen zëwe syal gwe-gweka, zëbe hap golblaka. Zëna ki zep nikin aneka. Dekam tïngare zini nwena Zëbon en lwazimꞌinka– dekam de dawem enkam zëno tawa tabinni insa ësane gwen hap. ");
INSERT INTO ury_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Zen dekam zep gubiridaka, “Alap mo ola insa ësane gwenan mes ki abe hap dakastïlblïnan.” ");
INSERT INTO ury_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Zen man zënaka don sonebirida gweꞌak, “O zëno ola dawem tanganna, hen zini in dawem tanganna.” Dekam zep tenggwanblan hap ëguk, “O san ha man zënaka kïl tïꞌara, ‘Ëe an Alap mo dam tasïn zi?’ An Yusup mo tane sake!” ");
INSERT INTO ury_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Hwëna Yesus mes zëno mae mo enlalana tame tazimki, ki zep gubiridaka, “Ëe tawana: Ëpba gulk sun de ol blaoranna em anakan esa Asa enblal, ‘Eme eiwa dokter gweꞌanam, ere mo timni emaka dawem guꞌura.’ Zep esa Asa anakan jakal ëblal, ‘Ëe an ere mo tim makan am lowe heꞌan. Bahem asa da tasibin.’ Zep anakan esa Asa en gweblal, ‘Ëe ama ësak– em Kapernaumk owas-owassae syal gwe-gwibir-zimki. Aha zi mo lang ennak bahem kirekam syal gwe-gwibin. Diki ere mo ëna awe em hen ap syal gwe-gwibir-zimdin.’ ");
INSERT INTO ury_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Hwëna Ëe eiwa denakaë emsa gubiridaꞌan: Zini hom zëre kore wal de Alap mo olsa ayang gul gwizimdin hip de zini nasal gweblanan. Zep em molye Asa asal gweblak. ");
INSERT INTO ury_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Emki ësan: Alap mo ol ayang gul gwen zini Elia Bak hen kirekam gwëka. Zen kim gwë gweka, ona hom ïl tï gweka– holona tahunna dan-ahan, ahana ngïrïn ngam sonnak zauk. Tïngare Israel mo langna dekam sasan gwek, dekam zep mamkam ëusak gwek. Dekam we wal sem-semna beya tangan nik Israelk awe ëtahalha gwek. ");
INSERT INTO ury_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hwëna Alap hom Eliasa zer soneka– awe de aha we sem maesa de mas gwibin hip. Hwëna aha zi mo langnak Sarfat de we sem san dep zer soneka– Sidon mo langnak. ");
INSERT INTO ury_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Hen kirekam– Alap mo ol ayang gul gwen zini Elisa Bak kim gwëkaye. Dekam Israelk awe de zini beya nik sop sang-sang karek naban nollwa gwek, hwëna hom aha-en mae dawem taka. Hwëna aha zi ausu nakore wal ensa dawem taka– Siria walya Naaman Bak ensa.” ");
INSERT INTO ury_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kim anakan zëno ola kon dam nulsuk, “Zen molya nëbe mae hap owasna syal gwibir-zimki,” dekam zep but srëm golak de zini in sërkam jal nëblak. ");
INSERT INTO ury_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dekam zep luk tak, ki zep hëndep Yesussu ëna in kon ïrïk ta hankam nërwet sok. Ëna in kwatapnak, in zep li san de ak tasïk irin hip ïrïk da haꞌak. ");
INSERT INTO ury_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Hwëna Yesus ki zep zëno mae mo ngïrïn kles san song gweka. ");
INSERT INTO ury_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ki zep Yesus tineka Galilea mo langnak de ëna Kapernaum sun dep. Hari Sabatkam zao zep tawa tabirki. ");
INSERT INTO ury_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","In desa tawa tabiꞌinka, man tangan denggwanblaꞌak. Sap zëno ola soson tanganna– san de teipsïn zi mo tawa tabinni kiye. ");
INSERT INTO ury_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","But srëm golak iwe zini hen ki gwëꞌanka– dowal mo bi gweblanna. Zen ki zep mam enkam hërhe hanaka, ");
INSERT INTO ury_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Wëo, Nazaret walya Yesus! Em aban mae ba olsa de ëtoran hap? Em san asa de tameran habe hata zala? Ëe mesë emsa tame tal! Em in Alap mo zer sonen Zi Lalakna.” ");
INSERT INTO ury_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesus ki zep zëbon de dowala insa jala ban gubluka, “Balkkam! Zini in kon em wet son!” Dowala in dekam zep zini insa zëno mae mo ngïrïnnïk zerheir guk halka. Hëndep sang-sang maena hom hli yulbluka. ");
INSERT INTO ury_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tïngare zini sërkam tangan denggwanblak, dekam zep zënaka donbirida nasenꞌak, “Ha! Zëno ola wehasa hom– soson tanganna, san de teipsïn zi mo ola kiye! Zëno dowal-dowalsa de golëalsa sonenna, hëndep dekam de wet so gwenkam!” ");
INSERT INTO ury_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Hëndep dekam zep nabakam Yesus hup de ola tïngare zëwe de langna in san nol haladak. ");
INSERT INTO ury_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus kim but srëm gola in kon wet soka, ki zep Simon mo golak golëbïtï gweka. Simon mo we marena man sërkam ewek, zep Yesussu dawem gun hup abe dak. ");
INSERT INTO ury_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tum alp nakon zep zauꞌun zaka, dekon zep ewenna insa gubirki, “Wenya ansa em hli yun.” Ewenna in dekam zep tapbla guk– Simon mo marena insa. Dekam zep hëndep luwek, hen tembanekam mas gwibiridak. ");
INSERT INTO ury_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hwëna yaklana kim dum gwe heka, dekam zep Yesus hon dep kïtak men zen kirekam-kirekam sang-sang naban nolgwëk desa nolëyaïng gwezak. Yesus ki zep tahasa de tehabirida ane gwenkam kïtak dawem tabirki. ");
INSERT INTO ury_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Hen dowal-dowala dekam zep zini in kon anakare hërhen naban wet so gwe-gweꞌak, “Em in Alap mo Tane!” Hwëna Yesus ki zep jala ban jalse gwibiridaka, ki zep zë hëndep ol srëm tabirki. Sap zen mes tame dak, “An Zen– Alap mo dam tasïn Zi niye, zisi de ngaya tabin hip Denaye.” ");
INSERT INTO ury_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Yaklana kim hata seꞌan zaka, Yesus ki zep ëna insa hli taka, dekam zep zi srëm san dep song gweka. Kim nohwensïblïk, dekam zep hëndep dëblak, hëndep ki zep hla dak. Zao zep desa de hli yuludan srëm hap nërtonk. ");
INSERT INTO ury_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ki zep hwëna ding gulzimki, “Alap Zën de tïngan ïrïk gïlzïn hap de ol dawemna an, zen tïngare ë-ë san de tawa tabirida gwen hap dena. Asa Zen kire hap zer soneka.” ");
INSERT INTO ury_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yesus dekam zep hwëna tïngare Yahudi mo langnak de but srëm gol-gol san tawa tabir song gweka. ");
INSERT INTO ury_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Aha yaklanak kim zauk, Yesus Ho Gutuna Galilea mo alpnak zauꞌunka. Zi beyana ki zep zë dot dasïk– Alap mo olsa dikim ësane gwen hap. ");
INSERT INTO ury_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesus ki zep zëwe hisglimnik bul darena akeka, hwëna buluk iwe de syal ta gwen wenya in mes atiti gwek. Zëre mae mo jaringnik men zen desyana ëtëhekke, desa kap dasïꞌïk. ");
INSERT INTO ury_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesus ki zep aha buluk sewe seka– Simon mo buluk. Ki zep gubluka, “Simon, bulu ansa em ata gun– engka en deka esek gwehak. Man asa dot dasïꞌïn.” Bul mwanak zep Yesus nikinki, dekon zep zi beyana insa tawa tabirki– men zen ho alp san teinikin sonekye. ");
INSERT INTO ury_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kim tawa tasibirki, Zën hom bulu in kon ati gweka, hwëna ki zep Simonsa gubluka, “Emki tatek san dep golsong gwen. Em jaringsi ahakore naban zitol sonen– hogwesa ekakim lahyok.” ");
INSERT INTO ury_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon ki zep ding gulbluka, “Bian, kam blal ëe ama syal ta tiner, hwëna hogwe maena homë balk ul. Hwëna mese ki asa gublunda, ëe asa ki etan otol soner.” ");
INSERT INTO ury_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kim notol sonek, beya en tangankam zep ëtëhek, hëndep jaringni in kalk-kalk gwen hap alp gwesïk. ");
INSERT INTO ury_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dekam zep aha buluk de wenya kip tahana walap nulsubirida gweꞌak– zen de mas gwibiridazan hap. Kim yaïng gwezak, dekam zep apdekam nul inek. Bul darena insa kim hogwena inkam bïtï dazimk, hëndep man su nëk, hëndep keing nën hap alp neisïꞌïk. ");
INSERT INTO ury_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Petrus kim kirekam hlaulku, ki zep Yesus mo nwenak utuk gwehe zaka, ki zep kon gu seblaka, “Asa hli ta, Bian, sap ëe an kirekam-kirekam karek naban.” ");
INSERT INTO ury_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon in mae hap ki gubluka, sap zen hen tïngare wal bose wal zeban man sërkam denggwanblak– insa kirekam beya tangankam dahyokke. ");
INSERT INTO ury_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hen kirekam– Simon mo syal bosena, Zebedeus mo walas darena Yakobus ne Yohanis ne. Yesus ki zep Simon maesa gubiridaka, “Bahem ëaïrïn. Angkam hwëna zisi esa lahyo gwer.” ");
INSERT INTO ury_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ki zep bulu insa hisglim sin dep ata nosok, zao zep hëndep tïngan hli dandak. Hwëna Yesussu zep kon ang nëblak. ");
INSERT INTO ury_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Aha yaklanak Yesus man aha ënak gwëꞌanka. Zao zini ki– sop sang-sang karek de tïngare tim sin hla tanna. Zini in kim Yesussu hla taka, ki zep zëno nwenak ïk gwehe zaka, dekon zep abe ta seka, “Bian, Eme dwam gweꞌanam, Em emaka asa dawem taꞌara.” ");
INSERT INTO ury_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesus ki zep towanblan naban ding gulbluka, “Ëe ama dwam gweꞌan. Em dawem gwen!” Dekam zep hëndep sop sang-sang karekna in hli tak. ");
INSERT INTO ury_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Zao zep gubluka, “Insa emsa dawem tanan, bahem mae ahasa tonbiridan. Diki nonol Alap mo golak de syal tan zi hip ahana kip enaka zertrëbla. Zao gublu, ‘Emki asa hla tan. Ëe san ha mesë dawem gwer?’ Musa Bak mo tïtï tabin olak men kirekam sop sang-sang karek zi de dawem gwennak dep dena lwakke, zen kirekam em syal gwibin. Zen dekam sa tïngan emsa anakan tame dal, ‘Zen eiwa mes tangan dawem gweka.’” ");
INSERT INTO ury_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Sap man Yesus tonbiridan hap jalse gwibirida gweka, hwëna zëre hap de ola man etan langa gwesïk haladak. Ki zep zini etan beya tangan nik yaïng gwe-gwezak– sane tan hap, hen sang-sang nakon de dawem ta gwibin hip. ");
INSERT INTO ury_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yesus dekam otan-otankam zi srëm san dep song gwe-gweka– dekon de zë-ere nakon Biansa gu sone gweblan hap. ");
INSERT INTO ury_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Aha yaklakam, Yesus man zi beyasa tawa tabiꞌinka. Hwëna Farisikam de gubirida gwen zi niban, Musa mo tïtï tabin olsa de tawa ta gwibin hip de zi niban zao hen lowe heꞌak. Zen tïngare ë-ë nakon mes ëtagal gwek– Galilea mo lang nakon, hen tïngare Yerusalem mo lang nakon. Dekam Bian onakore sosonna, zi sang-sangsa dikim dawem ta gwibin hip dena, Yesus hon lwaꞌak. ");
INSERT INTO ury_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dekam zep hen taha-tana teisya ine gwen srëm zi sang-sangna berya ban neiren halzak. Zen sap Yesus osan dep nër halzak, ");
INSERT INTO ury_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","hwëna ba san dep?– Zëbon osan dep de zertïlzïn naye. Sap zini mes tangan kyang gwesïk. Gol bol san zep nërsewek, dekon zep dre dasïk anehak, desan zep berya ban Yesus osan dep nër dwanuk. ");
INSERT INTO ury_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesus kim anakan tame tabirki, “Eiwa, zen man tangan Asa daïblïblaꞌan,” ki zep zi sang-sangna insa gubluka, “Tane tol, eno karek-karekna mesë ep tap gulsublunan.” ");
INSERT INTO ury_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Musa mo olsa de tawa ta gwibin zi niban Farisikam de gubirida gwen zi niban enlala ennak zep anakan donsubluꞌak, “Zini an zëno ola bolte-bolte tanganna! Zen bap kirekam Alapsa lamang tanda! Zi bëjen zi bose zik mo karek-karekna tap gulsublun. Diki Bian Alap bap.” ");
INSERT INTO ury_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Hwëna Yesus mes zëno mae mo enlalana insa tame tazimki, dekam zep gubiridaka, “Em bap kirekam enlala ennak Asa lonsubluꞌan! ");
INSERT INTO ury_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Em ema ano ola husus eibir– anakan insa gublulye, ‘Eno karek-karekna mesë ep tap gulsublunan.’ Hwëna anakan de gublunkam, ‘Em luwen, hëndep song gwe,’ san esa hen etan husus eibir? Sap ol-gun darena in apdenak– Alap mo sosonkam de gublun ol. ");
INSERT INTO ury_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Hwëna angkam Ëe ama ebe mae hap goltreizimꞌin– em dikim Asa anakan tame tan hap, ‘Alap mes ki ngatan zi mo lang nakore Zi Tanganna abe hap sosonna golblaka– okamanak awe dikim zi mo karek-kareksa tap gulsuk gwizimdin hip denaye.’” Ki zep hwëna etan zi sang-sangna insa gubluka, “Ëe ama emsa gubluꞌan: Em luwen. Ere mo berya insa teisya, ki gol san song gwe.” ");
INSERT INTO ury_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hëndep ki zep zëno mae mo nwenak luweka, berya insa man einki, ki zep song gweka. Dekam Alapsa man isrip-sri gwebla song gweka. ");
INSERT INTO ury_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tïngare zini sërkam ëtenggwank, dekam zep Alap mo bosena teip nulsuk gweblaꞌak, hen aïrïn nïban ëgu gweꞌak, “Namen eiwa owas hap ki kirekam lwanan!” ");
INSERT INTO ury_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesus kim hyanak gola in kon wet so zaka, dekam zep Roma mo ïrïk gïnnïk dep de pajak te-ala alal ta gwizimdin hip de zini hla taꞌanka, bosena Lewi. Zen zëre mo syal gwe-gwen teksonnak nikinꞌinka. Yesus ki zep zë gublu zaka, “Haen. Asa em ang gweblan.” ");
INSERT INTO ury_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi ki zep hëndep luweka, zao zep zëre mo teksonnak de kire-kirena tïngan hli tan daka, ki zep Yesussu ang gweblaka. ");
INSERT INTO ury_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Dekam zep Lewi zëre mo golak tembane yawalsa golzimki– zao de Yesussu zertreizimdin hip. Zini beya tangan nik yaïng gwezak. Ahakore pajak te-ala alal tanda gwen zini man hen yaïng gwezak. ");
INSERT INTO ury_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisikam de gubirida gwen zini man zë hen hla nulidazak. Zen ë-en nakon ëzauꞌuk. Hom bïtï gwek. Ahakore Farisikam de zini in, Musa mo tïtï tabin olsa de tawa tabin hip dena. Zen Yesus hon de ang ta gwen wenyaka anakan jal neibiridaꞌak, “Em ba hap tangan tembane tal– pajak te-ala alal tanda gwen zi nibanye, hen aha zi enlala karek-karek naban! Zen in kwae nabanke!” ");
INSERT INTO ury_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesus ki zep ding gulzimki, “Zini, sang-sang srëm wenya, zen hom doktersa dwam në gweblanan. Zen diki zi sang-sang en dwam në gweblanan. ");
INSERT INTO ury_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ëe an dokter makanë hatazak– zi enlala karek-kareksa de dawem san dep kwang guludan hap, zen dekakim ëhalek. Hwëna men zen zënaka tim di gwibirin, ‘Ëe an dawem-dawemna,’ Ëe desa de kwang guludan hap homë hatazak.” ");
INSERT INTO ury_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Zini ki zep Yesussu dakensïblïk, “Yohanis hon de ang ta gwen wenya zen etan-etankam tembanesa ëlwa gwenan– Biansa dikim enlala zon tasïblïn naban abe ta gwen hapye. Farisikam de gubirida gwen wenya hen kirekam. Hwëna ebon de ang ta gwen wenya, zen hwëna tembanena sërkam dwenblanda gwenan, hen hona notdeblanda gwenan.” ");
INSERT INTO ury_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesus ki zep ding gulzimki, “Abon de ang ta gwen wenya kip man dakastïlzimꞌin– an kirekam tembanesa de ëlwan srëmkam lowehe gweꞌanye. Sap zen angkam teipsïn zisi de zergwën makan Asa nërgwë gweꞌan. ");
INSERT INTO ury_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Hwëna jal zini kim de Asa jek-jak daꞌak, Abon de ang ta gwen wenya dekam molya tembane tak. Embwan hap sa baes tal.” ");
INSERT INTO ury_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Etan ki zep kire hap gulk sun de ol blaonzimdinni dan mas sozimki, “Baju ësena bëjen kalk so irin– baju ëpba kalknak de yal irin hipye. Zini hom kirekam nei gwizimnin, sap zen dekam de hwëna baju ësena insa kalk son, hen ëpba wenya in han ëse kalk naban bëjen nadakastïn. ");
INSERT INTO ury_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hen kirekam, anggur ho ësesa bëjen kambing sopkam de botol ëpbanak yuren. Kirekam hom dakastïꞌïn. Sap anggur ho ësesa de kambing sop botol ëpbanak yurenkam, anggur hona in kim de nopna taïl gïꞌïk, kambing sopkam de botola in dekam sa kalk nër. Anggur hona in dekam sa hen hlëweher. ");
INSERT INTO ury_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Anggur ho ësena zen diki kambing sop botol ësenak de yurenkam dakastïꞌïn. Zep hen kirekam, Abon de ang ta gwen wenyik de etan ëpba lowehen san abarenak ang tan hap hom dakastïꞌïn.” ");
INSERT INTO ury_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aumwa hap ki zep etan gulk sun ola blaonzimki: “Zi de anggur ëpbasa otdenna, zen bëjen ësena dwam gwibin. Zen sa gulu, ‘Ëpba wenya, zen zen– dawem tangan wenyaye. Zen zen tangan abe hap sam gwesïblïꞌan.’” ");
INSERT INTO ury_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Aha Hari Sabatnak kim zauk– Israelk de zi mo syal tan srëm yaklanak, Yesus ki zep gandum tra san golëtaman gweꞌanka. Hwëna zëre hon de ang ta gwen wenya zen gandum dansa kïlk dï-in kïnï gweꞌak, ki zep tahakam legek da gwibiꞌik– dekam de sop nik ëbatralhen hap, ki zep dwenblandak. ");
INSERT INTO ury_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farisikam de zini kim hla nulidak, ki zep jalse neibiridak, “Em ba habe Musa mo tïtï tabin ola ngip uꞌin? Kirekam em ema hwëna Hari Sabatnak syal taꞌan!” ");
INSERT INTO ury_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesus ki zep hwëna ding gulzimki, “Em bawalkam esa Alap mo ola an mo eini dam ulsul?– men kim Daud Bak zëre hon de ang ta gwen wenya ban golëusak gweꞌankaye. ");
INSERT INTO ury_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Zen kim Alap mo golak tïl zïka, zen dekam Alap hap de roti loneblansa gol kïnïka. Desa zep zëre hon de ang ta gwen wenya ban zitwinbir song gweka. Hwëna sap nëno mae mo tïtï tabin olak man lwak: Sap Daud zëna hen zëbon de ang ta gwen wenya, zen bëjen Alap hap de rotina insa twinbin. Zen diki Alap mo golak de syal ta gwen zi en dwin gwibirin. Sap eiwa kirekam, hwëna Daud hom Alap mo nwenak karek gweka– zen kim usak hap zitwinbirkiye. Zep hen kirekam, Abon de ang ta gwen wenya an kim usak hap kïlk dï-in kïnzïl, zen hom ëkarek gwer.” ");
INSERT INTO ury_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ki zep Yesus waulsuzimki, “Ngatan zi mo lang nakore Zi Tanganna, Ëe an Zen tangan– Hari Sabat mo Nolaye. Zep anakarekam de klis gul gwizimdin hip dena, ‘Desa sap esa Hari Sabatnak syal eibir,’ ahaksa, ‘Kirekam bahem,’ zen ano dena.” ");
INSERT INTO ury_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Aha Hari Sabatnak kim hatak, Yesus dekam etan but srëm golak tawa tabirki. Hwëna zao zini ki. Dam taha nik sak gweblaka. ");
INSERT INTO ury_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Hwëna Musa mo tïtï tabin olsa de tawa ta gwibin hip de zi niban Farisikam de gubirida gwen zi niban man Yesus mo kareksa de hlaulblun hap ëalp gweꞌak. Zep kara daꞌak, “Zen wëhë nëno mae mo syal tan srëm yaklana an hap dena ngip guꞌunka– zisi de dawem tankamye?” ");
INSERT INTO ury_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Hwëna Yesus mes zëno mae mo enlalana tame tazimki, ki zep hëndep zini in zen tahana sak gweblaka desa gubluka, “Haen, ano mae mo dang gwënna a dekon emki zauzun.” Zini in dekam zep zë zau zuka. ");
INSERT INTO ury_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ki zep Yesus takensibiridaka, “Musa mo tïtï tabin olak, nen basa de Hari Sabatkam gol gwen? Hari Sabatkam san ha nen kareksa zi hip gol gwizimdin? San ha dawemsa nen gol gwizimdin? Hari Sabatkam san ha nen zisi ngaya ta gwibin? San ha nen tamera gwen?” ");
INSERT INTO ury_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesus ki zep tïngan nwekam amjanbirki, ki zep hwëna zi taha sakna insa gubluka, “Tahana insa emki ïnïn gïlsïn.” Ki zep hëndep ïnïn gïlsïkï, dekam zep hëndep tahana in etan dawem gweblak. ");
INSERT INTO ury_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Hwëna Musa mo tïtï tabin olsa de tawa ta gwibin zini Farisikam de zi niban man tangan Yesussu daïl gïblïꞌak. Dekam zep enlalasa dëblaꞌak, “An banakan esa ëblal?” ");
INSERT INTO ury_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Zao kim lwa seꞌak, Yesus ki zep kwatap teknak hata seka, dekon zep kam blal Alapsa gu sone gweblaꞌanka. ");
INSERT INTO ury_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kim lïtïk, ki zep zëre hon men zen beyakam ang ta gwek, desa gu sonebiridaka, zao zep hwëna dua-blas enkam dam tasibirki– zen de zëre mo olsa gol halada gwen hap. ");
INSERT INTO ury_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ahana Simon– men desa hen Yesus “Petrus”kum bose takake, hen oso zem, Andreas. Ahana Yakobus, Yohanis, Pilipus, Bartolomeus, ");
INSERT INTO ury_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius, Tomas, hen Alpeus mo tanena Yakobus, hen Simon– men zen nonol Israel dikim Roma mo ïrïk gïn nïkon ëzë-en gwen hap de ëasas gwennak ang gwekake. ");
INSERT INTO ury_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ahana Yakobus mo tanena Yudas, hen aha zini Yudas– ëna Kariot wal. Zen men zen hëndep Yesussu zergukuke. ");
INSERT INTO ury_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesus ki zep dua-blaskam de zini in han etan golëhut gwehe tinjaka, ki zep hëndep sëseknak golëzau zuka. Zëre hon de ang ta gwen wenya aha hlïkna zëwe beya nik ëtagal gweꞌak, hen ahakore zini beya tangan nik mes yaïng gwezak– sap Yerusalem kon, hen tïngare Yahudi mo lang nakon, hëndep hi alpnak de ë darena Tirus hen Sidon kon. ");
INSERT INTO ury_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Zen Yesussu de sane tan hap hen zëre mae mo sang-sang nakon dikim ëdawem gwen hap yaïng gwezak. Dowal mo tïlbiridan wenya dekam zep ëdawem gwek. ");
INSERT INTO ury_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Dekam tïngare zini man sap Yesussu de olk tan hap ëakasïk gweꞌak. Sap zëno tim nikon man sosonna wet so gweꞌak, zep zi sang-sangna dekam kïtak ëdawem gwe-gweꞌak. ");
INSERT INTO ury_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesus ki zep zi beyana in zen zëre hon ang ta gwek karatda tabiꞌinka, ki zep zë gubiridaka, “Tahalha wenya, hëꞌho gwrbinni ebon mae onak lwaꞌan, sap em makare zini, zen zen Alap mo ïrïk gïnnï bi neibiꞌin. ");
INSERT INTO ury_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Angkam em in zene usak naban lowe heꞌan, hëꞌho gwibinni ebon mae onak lwaꞌan, sap em esa lamkam ëïtrï gwer. Angkam em in zene go naban lowe heꞌan, hëꞌho gwibinni ebon mae onak lwaꞌan, sap em esa lamkam ënga-ngol gwer. ");
INSERT INTO ury_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Hen emsa kim ngatan zi mo lang nakore Zi Tanganna abe hap de jal hap daïl gïbirida gweꞌak, hen baes neibirida gweꞌak, hen lamang da gwibiꞌik, ahaksa bosena gwa-tek gwa-tek da gwibiꞌik, dekam hëꞌho gwibinni ebon mae onak mamkam lwaꞌan. ");
INSERT INTO ury_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kirekam de emsa gweibirida gwenna, em dekam isrip-sri naban ëtasya gwek, sap ebe mae hap de dawemna ngatan zi mo langnak yawal tangan nik lwazimꞌin. Sap zini men zen angkam emsa kirekam neibirida gweꞌan, auyan-aza zem hen kirekam orep Alap mo olsa de ayang gul gwen hap de zini neibirida gwek. ");
INSERT INTO ury_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Hwëna kwasang tol, em in zene angkam te-ala naban lowehe gweꞌan, em ëngalap gwen, sap eno hëꞌho gwibinni mes lwak. ");
INSERT INTO ury_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kwasang tol, em in zene angkam ïtrï naban lowehe gweꞌan, em ëngalap gwen, sap em in zen esa lamkam ëusak gwer. Kwasang tol, em in zene angkam nga-ngola ban lowehe gweꞌan, em ëngalap gwen, sap em in zen esa lamkam gona ta tine gwer. ");
INSERT INTO ury_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kwasang tol, em in zene angkam bose dawem naban lowehe gweꞌan, em ëngalap gwen. Zini men zen angkam eno bosena nurensïꞌïn, auyan-aza zem kirekam hen orep yasik tabin hip de zi mo bosem-sena nurensïk gwizimk, men zen dekam anakan ëboton gwe-gwek, ‘Ëe an Alap mo olsa de ebe mae hap ayang gul gwizimdin hip de zi.’” ");
INSERT INTO ury_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Hwëna angkam em an zene asa sane laꞌan, an desaë ep golzimꞌin: Ere mae hap de jal zini em kwasang gwibirida gwen. Zen de emsa taïl gïk gweblanna, zëbe mae hap hwëna dawemsa em goltrei gwizimdin. ");
INSERT INTO ury_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Zen de emsa lamang tanna, ahaksa karek tanna, em hwëna Biansa em zëbe mae hap gu sone gweblan– Zen deka dawemsa golzimki. ");
INSERT INTO ury_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Zi de emsa itranak tahakam lek tyanna, eihya itrasa em zitrëblan– zao de hen emsa lek tyan hap. Zi de eno tahan bajusa al sonna, etan de eno olk de bajusa al soblan hap bahem jalse gweblan. Em zëbe hap alblan. ");
INSERT INTO ury_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ebon de ahanik ba maesa abe gwibinni, em hëndep golblan. Ahanik de eno ba maesa al gunnu, etan bahem ebe hap de golblan hap abe tan. ");
INSERT INTO ury_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","“Men kirekam ena dwam gweꞌara, zi de kirekam emsa gwë gweblan hap, em hen ahasa kirekam em gweibirida gwen. ");
INSERT INTO ury_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Em de enaka de kwasang gwe-gweblan zi ensa etan kwasang gwibirida gwenkam, ki hwëna anakan bahem ëkïl gïl gwen, ‘Alap sa dekam asa sam gwesibiridala.’ Sap kareksa de gol gwen zini hen ki kire enkam kwasang neibirida gwenan– zini men zen zënaka kwasang neibirida gwenanye. ");
INSERT INTO ury_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Hen em de dawemsa goltrei gwizimdinni men zen en ebe hap hen dawemna noltrë gweblanan, hwëna aha zi hip hom, dekam toton bahem ëkïl gïl gwen, ‘Ano bosena dekam sa Alap mo nwenak dawem gwer.’ Sap kareksa de gol gwen zini hen ki kire enkam ëgwë gwenan. ");
INSERT INTO ury_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Hen em de te-alasa bohë gul gwizimdinni men zen en ebe hap etan lop da gweblanan, hwëna aha zi hip hom, dekam toton bahem ëkïl gïl gwen, ‘Ano bosena dekam sa Alap mo nwenak dawem gwer.’ Sap kareksa de gol gwen zini hen ki bohë nulzimnira gwenan– karek gol gwen bose zikhipye, men zen hen kire enkam etan lop dazimnira gwenanye. ");
INSERT INTO ury_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Hwëna em jal zi omka em kwasang gwibirida gwen, hen dawemsa em goltrei gwizimdin. Em totoresa bohë gul gwizimdin, hwëna bahem lun kon etan anakan ëenlala gwe-gwen, ‘Etan sa ap golblala.’ Dekam sa eno bosena ngatan zi mo langnak dawem gwer, hen Teipsïn Zini Alap sa emsa gublula, ‘An ano bi gweblan walas ahana.’ Sap Alap mo kwasangna zen zi dawem en hap hom. Hwëna Zen man hen kwasang gwibirida gwenda– kareksa de gol gwen zini, hen zini men zen dawemna zëbe hap nolbla srëm gwe-gwenanye. ");
INSERT INTO ury_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","In zep, men kirekam Bian om zi karek-karekna enlwan gwibirida gwenda, em hen kirekam em zi bose omka enna lwabirida gwen.” ");
INSERT INTO ury_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Bahem zi bose omka enlala gwibirida gwen, ‘Zini in karekna.’ Ki hwëna Alap hen sa kirekam emsa enlala gweblala, ‘Zëna hen karekna.’ Bahem gubirida gwen, ‘Zini in karek tan hap man dakastïꞌïra,’ ki hwëna Alap sa kirekam hen emsa gublula. Karekna mensa aha zi ebe hap nol gwizimnin, desa em eititi gwibir-zimdin. Ki sa Alap hen eno karek-karekna ep tap gulsublula. ");
INSERT INTO ury_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Em aha zi hip dawemsa gol gwizimdin, dekam sa Alap ebe hap hen dawemna gol gweblala. Dekam taha dohon naban sa ebe hap lop ta gweblala. Lau-lau kire-kirena, Zen sa etan ebe hap inik gul sone gweblala, sa ebe hap taïk-tïk gïlsïk sone gweblala. Ho nabare kire-kirena zen sa hëndep ësuwehe kïnï gwer. Aha kire-kirena zen esa taha-taha gweblala, hëndep esa dangnak yaïng tahal gwera. Em de yunak aha zi hip bïtï tablanna, ki Alap sa etan yunak ebe hap beya enkam bïtï tablala.” ");
INSERT INTO ury_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Zëwe zep Yesus ola gulk sun de blaonzimdinni dan-dan mas sozimki: “Zi nwe haïna bëjen nwe haï bose zemka ïrïk tahan. Ki hwëna apdenak sa ho dwrak san laman anera. ");
INSERT INTO ury_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Zi mo nwenak mam-mamna nara? San ha guru? San ha sekola walas? Zen diki guruke. Hwëna walasna in, sekola zemka kim sul sonenna, zen diki dekam sa guru zeban apde ëra. ");
INSERT INTO ury_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Hen em ba habe wal bose uk mo ngip gun betek tolsa hla kul gwizimnin? Hwëna ere mo ngip gun yawala em desa de oto gulsun hup ema baes ta gwenan. ");
INSERT INTO ury_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kirekam de lwankam, em kïtak men kiye: Zi de wal bose zemka gublunna, ‘Anik eno nwenak de te klana insa gulsuk,’ hwëna zëre mo nwenak balok tek yawala hen ki lwaꞌan. Zen maka desa nonol mulsuꞌura– dekam de wal bose zik moka hlaun hupye. Em in Alapsa ëk enkame ang ë gweblanan. Diki nonol emaka aha-en-aha-enkam ere mae mo karek yala insa ngan ulsu’un. Ki esa dawemkam nwekam ëkara gwer– dekam de betekkam de ngip gun wal bose wal omka halen ora san golëwet so gwen hapye.” ");
INSERT INTO ury_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Men kiye hen tenya: Zen zëre mo dan enkam ëtë gwenan. Tenya men zen twin gwibin srëm tetan dankam ëtë gwenan, zen bëjen twin gwibin tetan dankam tën. Hen tenya men zen twin gwibin tetan dankam ëtë gwenan, zen bëjen twinbin srëm tetan dankam tën. ");
INSERT INTO ury_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tïngare tenya zen tën nakon tame nul gwenan. Kwiwe dansa bëjen lemo timnik taran. Hen dokot të ngï-ngïna bëjen rambutan dankam tën. ");
INSERT INTO ury_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Hen kirekam, zi enlala dawemna, zen enhonak dawemsa ing nul gwenan. Zen desa zep aha zi hip noltrei gwizimnin. Zi enlala karekna, zen enhonak kareksa ing nul gwenan. Zen hen desa zep noltrei gwizimnin. Zep men zen zi mo enhonak beya gwe-gwenan, zen zep nopna sewe gwenan– ëk tïhï san de wet son hapye.” ");
INSERT INTO ury_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Em ba habe waba hap Asa laken gweblanan?– ‘Bian, Bian’, hwëna em home ano ol san ang ta gwenan. ");
INSERT INTO ury_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Hwëna men zen eiwakam Abon yaïng gwe-gwenanzal, hen ano ola ësal gwenan hen desan ang ta gwenan, zen men kiye– ");
INSERT INTO ury_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","zi de golsa moko dawem naban taunnu. Zen nonola kamasa de olk en san hul-hul gun, kire drak-drak tenya eiyas tan. Ho namwa gwenkam, gola in san de ho namwa tïl zïnna, gola in bëjen ëwak gwen, sap zen dawemkam de moko tanna. ");
INSERT INTO ury_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Hwëna men zen ano ola sap ësane gwe-gwenan, hwëna desan hom ang ta gwenan, zen men kiye– zi de golsa moko srëmkam taunnu. Ho namwa de desan tïl zïnna, zen sa nabakam mirsïk kïnïla, hëndep karekkam sa drewera.” ");
INSERT INTO ury_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesus kim tawa tasibirki, ki zep Kapernaum sun dep song gweka. ");
INSERT INTO ury_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Zao Roma mo jana nabare zi mo mamna ki. Zëbon de babu gwen zini man sërkam sang-sang gweka, hëndep tïn hïp alp gwesïꞌïnka. Jana nabare zini in man tangan anakarekam ngalap gweblaꞌanka, “Bap zen tol tïn.” ");
INSERT INTO ury_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Zen kim salblaka, “Yesus awe gwëꞌara,” zen dekam zep Yahudi zi mo mam-mam naka gubiridaka– zen de Yesussu abe tan hap, Yesus de zi sang-sangna insa dawem tazan hap. ");
INSERT INTO ury_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Zini in kim zëno abe naban Yesus hon yaïng gwezak, dawem enkam zep anakan abe dak, “Jana nabare zi mo mamna in dawemna. Emki mas gweblan. ");
INSERT INTO ury_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Zen sap aha zi wal, hwëna zen man nëre korena ansa kwasang gwibirida gwenda, hen zen mes te-alana zerzimki– nëno mae mo but srëm golsa dikim taun hupye.” ");
INSERT INTO ury_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesus ki zep zëbon mae onak ang gweka. Golak dep kim golëgolek de gweꞌanka, jana nabare zi mo mamna in ki zep ahakore naka gubiridaka– Yesus hup dikim zëno olsa anakan ayang gulblun hap, “Zen man emsa gublula, ‘Bian, Em bahem Enaka karek tan– ano golak de hatankamye. Ëe ama Em de ano golak sewen hap saher gweꞌan. ");
INSERT INTO ury_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","In zebë baes gwer– aen de Ebon hatazan naye. Hwëna anakan-en Em gun, “Zi sang-sangna in zen dawem gwen,” dekam sa dawem gwera. ");
INSERT INTO ury_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Sap ëe mesë Emsa taïblïblak, “Eno ol-gunnu bëjen kirekam lwa srëm gwen.” Sap abon onakon de teipsïn zini ki. Ano otdenak dena hen ki. Ëyë ëre mo otdenak denaka gubluꞌanam, “Em song gwen,” zen dekam maka song gweꞌara. Hen ahanakaë gubluꞌanam, “Haen,” zen hen dekam maka song gweꞌan zala. Ëyë ëre hon de babu gwen zisi gubluꞌanam, “A desa syal gwibir,” zen dekam maka hëndep syal gwibiꞌira. Ëe sap teipsïn tola, zep ano ol san kirekam ang ta gwenan. Hwëna Em in teipsïn tanganna, zep eno ol san sa ki kirekam lwal.’” ");
INSERT INTO ury_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesus man tangan tenggwanblaka– zëbon onakore olsa de kirekam sane gwenkam. Dekam zep zi trana in zen ang nëblan daꞌak, desa lero gwibiridaka hen gubiridaka, “Eiwa, zini in man Asa taïblïblaꞌara. Ëe homë mae Israelk kirekam de sërkam Asa taïblïblan zini zertowek.” ");
INSERT INTO ury_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Zen kim etan jana nabare zini in mo golak dep lwanda halzak, dekam zep babu gwen zini insa hla dak, “Eiwa, zen mes tangan dawem gwenda.” ");
INSERT INTO ury_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Zao hom holo gweꞌak, Yesus ki zep ëna Naen san dep song gweka. Zëre hon de ang ta gwen wenya hen aha zini beya nik ang nëblak. ");
INSERT INTO ury_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yesus kim ë top wet so kïnïnnak golek de gweꞌanka, zao zep golëtoweꞌanka– zi beyana kim wal seiwir tokna berya ban drë nwanun hap nërte soꞌanzak. Wal seiwiri in zen tïlkï, zëno anena semna, hen zëno walasna ahana hom. ");
INSERT INTO ury_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bian Yesus kim we semna insa hlaulku, Zen man tangan kwasang gwibirki, ki zep gubirki, “Anyan, bahem gona gwëblan!” ");
INSERT INTO ury_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ki zep berya insa golek de so zaka, ki zep olk soka. Men zen neiren haꞌanzak dekam zep nërzausuk. Yesus dekam zep walas tokna insa gubluka, “Tane tol, Ëe ama emsa gubluꞌan, em luwen!” ");
INSERT INTO ury_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Wal seiwir tokna in ki zep luweka, hëndep nikinꞌinka, dekam zep hëndep ola tonꞌanka. Yesus ki zep an zemka gubirki, “An dë– eno walas naye.” ");
INSERT INTO ury_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dekam zep tïngare zinik aïrïnnï hatazimzik, hen dekam zep anakan Alapsa boltere daꞌak, “Alap mo olsa de ayang gul gwizimdin hip de zi yawala an mes nëno mae mo ngïrïnnïk hata zala! Alap angkam man kon gwisibir hanaꞌara– zëre mo hlïl irin zisi de oto gulsunkumye!” ");
INSERT INTO ury_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesus hup de ola dekam zep etan langa gwesïk haladak– tïngare Yahudi mo lang san hen zëno alpnak de lang san. ");
INSERT INTO ury_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Tïngan in desa ki Yesus syal gwe-gwibirki Yohanis hon de ang ta gwen wenya dekam zep Yohanissi bwinak nen gublu hana gwek. Dekam zep hëndep etan dan-dan de aptazan hap gu soneka. ");
INSERT INTO ury_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Desa zep guzimki– Yesussu de anakan lakensïblïn hap, “Bian, Em an san ha Zen tangan?– men Desa anakan nen guk gweblakye, ‘Israelsa de oto gulsun hup de Zini sa hata zala.’ San ha ëe asa etan ahanaka kara ëblal?” ");
INSERT INTO ury_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Yesus hon kim apta zaka, ki zep enblaka, “Asa baptis ta gwibin zini Yohanis emsa de anakan lakensïblïn hap guzimki, ‘Em an san ha Zen tangane ki hata zaka? San ha ëe asa ahanaka kara ëblal?’” ");
INSERT INTO ury_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Dekam Yesus zi sang-sangna beya naka dawem ta gwibiꞌinka. Sap dowal de tïlblïnna, hen nwe dïmïnnï, Zen tïngan dawem ta gwibiꞌinka. ");
INSERT INTO ury_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesus ki zep ding gulzimki, “Sap esa etan Yohanis osan dep olahala. Mensa ki ena sane ëra hen hla kuli, desa anakan enbla, ‘Zi nwe dïmïnnï man ëkara gwe-gweꞌak. Lek-lek wenya hen man sek gwe-gweꞌak. Sop sang-sang karek nabare wenya man hen ëdawem gwe-gweꞌak. I mat wenya hen man ësane gwe-gweꞌak. Tok-tokna hen man ëngaya gwe-gweꞌak. Hen Alap onakore ol dawemkam man tahalha wenyaka tawa ta gwibiꞌira.’ ");
INSERT INTO ury_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Hen anakan enbla, ‘Abon onakon men zen ësyalhe srëm gwe-gweꞌan, zen hëꞌho gwibinni zëbon mae lwaꞌan.’” ");
INSERT INTO ury_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Baptis ta gwibin zini Yohanis hon de ang ë gwen zi darena in kim nama ëhaꞌanka, Yesus dekam zep hwëna Yohanis hip dena zi beyam-byana in hap srip gulsuzimꞌinka. Man zë gubiridaka, “Yohanis kim zi ol srëm langnak tawa ta gwibirki, em ba habe desan sek gwe-gwek? Basa de zë hlaun hup? San ha ema ëtim gul gwek?– ‘Ëe desan asyas habë sek gweꞌan.’ ");
INSERT INTO ury_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Em ba habe desan sek gwe-gwek? San ha ema ëtim gul gwek?– ‘Ëe pakean dawem ala son nabare zisi de zë hla tan habë sek gweꞌan.’ Kire hap desan bëjen. Sap kirekam de zini– men zen tahalha srëmkam lowehe gwenan, zen zi srëm langnak hom. Zen diki teipsïn zi mo ë yawalak lowehe gwenan. Zi srëm langnak bëjen. ");
INSERT INTO ury_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Zep em ba habe zi srëm lang san dep sek gwe-gwek? Em sap diki Alap mo olsa de ayang gul gwizimdin hip de zisi de zë sane tan habe sek gwe-gwek. Hwëna baptis ta gwibin zini Yohanis in, zen Alap mo olsa de ayang gul gwen zi nikon man tangan taman kïnïka. ");
INSERT INTO ury_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Sap Yohanis in zen– Israelsa de ngaya tabin hip de Zisi de ngeirblizan zi niye. Sap Alap man ngaya tabin hip de Zini insa hamal hap anakan gu-gubluka, ‘Ëe asa Emsa de ngeir gublun hap zisi zer soner– zen de nonol ëre mo olsa ayang gul gwizimdin hip, ebe hap dikim orasa sal ta gublun hap.’” ");
INSERT INTO ury_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Etan ki zep gubiridaka, “Eiwa, okamanak de zini, sap nonol lonesen nakon hëndep angkam em an zene lowe heꞌan, Alap mo nwenak de ëdakastïnnï, hom tangan ahana– Yohanissi de kwë ta sone kïnïn naye. Hwëna sap kirekam, men zen angkam Alap mo ïrïk gïnnïk Asa de taïblïblan nakon bïtï gwe-gweꞌan, sap bose srëm wenya, zen diki zen– Yohanissi de kwë ta sone kïnïn wenyaye.” ");
INSERT INTO ury_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yesus mo ola insa de ësankam, tïngare zini, hen sap Roma mo ïrïk gïnnïk dep de pajak te-ala alal tanda gwen wenya, man ëisrip-sri gwek, “O hare Alap eiwa zëre mo dwam gwibin sin am kirekam Yohanis hon syal gweka.” Sap zen man Alap mo zëbe mae hap de dwam gwibin sin ang tak– zen kim Yohanis mo baptis tabinnik ang takye. ");
INSERT INTO ury_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Hwëna Farisikam de zini hen Musa mo tïtï tabin olsa de tawa ta gwibin hip de zini, zen man Alap mo zëbe mae hap de dwam gwibinni baes neibik, sap zen man Yohanis mo baptis tabinni ja nuk. ");
INSERT INTO ury_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Etan ki zep Yesus ola gulk sun blaonzimki, “Angkam de zini, em in men kiye– walasna. ");
INSERT INTO ury_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Walas tane-ne de pasarak teinikirinni, dekon de asyas bose zemka gubiridanna, ‘Nen isrip-sri hap de tërya ban asyas tan.’ Hwëna zen maka ding nulzimꞌin, ‘Ëe ama baes taꞌan.’ Dekam de sap etan gubiridanna, ‘Ki zi toksa de gwëblan makan nen asyas tan.’ Hwëna dekam hen maka ding nulzimꞌin, ‘Ëe ama kirekam hen baes taꞌan.’ Angkam de zini em hen kirekam. Em ema kïtak Alap mo syala baes ei gwibirin. ");
INSERT INTO ury_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Sap Alap kim baptis ta gwibin zini Yohanissi ebe mae hap zer sonezimki, zen Alap dikim sosonsa golblan hap man tembanena lwa gweka, hen angguru hom otde gweka. Hwëna em ema baes ë gweblak, hen anakane lonsuk gweblak, ‘Zen dowal bi gweblaka.’ ");
INSERT INTO ury_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ki zep hen ngatan zi mo lang nakore Zi Tanganna Asa zer sone zaka. Ëe hwëna homë tembane naban angguru ban lwa gwenan. Hwëna Asa hen ema baes ë gweblaꞌan, hen anakane Asa lonsuk gweblanan, ‘Zini insa emki hla tan! Tembane ngalap-ngalapna hen anggur otdebin sosonna. Zëno wal bose walya Roma mo ïrïk gïnnïk dep te-alasa alal danda gwenan, hen ahakon enlala kwae naban!’ ");
INSERT INTO ury_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hwëna Alap kirekam zëre mo enlala blalkam srën-srënkam de syal ta gwen hap lup gul sone gwenda. Zep men zen de Alap mo enlala blal san kirekam ang taꞌak, zen zen sa eiwa de ora san ëwet so kïnï gwer.” ");
INSERT INTO ury_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi walya bosena Simon, zen man Yesussu zëno golak de golëtembane tan hap gubluka. Yesus ki zep zë golëteinikinꞌinka. ");
INSERT INTO ury_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Hwëna ëna iwe, kahalo soson wenya hen ki. Zen kim sak, “Yesus zëno golak tembane gweꞌara,” zen dekam zep sërkam de irase dawem nabare minyak botol aban golhatazak– Yesussu dikim hlë tablan hap. ");
INSERT INTO ury_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Zen sërkam tangan Yesus hup kwasangna goltrëblak. Nonol zen zëno tana gwë sonen nakon zauꞌunzak. Dekon gosa gwëꞌak. Hëndep nwe go-hokam Yesus mo tanasa blëble soꞌak. Zëre mo nol ala blal-blalkam zep etan sasa soblak, deban bolk-bolk soblak, dekam zep zë hwëna minyakna inkam hlë tazim-blik. ");
INSERT INTO ury_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Simon kim hlaulku, zen ki zep enlala ennak Yesussu tonsubluꞌanka, “Zini an eiwa de Alap zer sonenanam, zen maka anakan tawa gwibiꞌira, ‘Wenya an zen asa olk taꞌan, zen kahalo sosonna.’ Maka anakan jalse gwibiꞌira, ‘Bahem asa olk tan.’” ");
INSERT INTO ury_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesus ki zep Simonsa gubluka, “Simon, ola sap ki– Ëe de desa emsa gublun hap denaye.” Simon ki zep ding gulbluka, “In aïrïs, bian, sap esa asa gublula.” ");
INSERT INTO ury_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesus ki zep gubluka, “Zini dan te-ala beya nabare zi nik man te-alasa bohë laka, ahana lima-pulu jutakam, ahana lima jutakam. ");
INSERT INTO ury_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hwëna zi darena in etan bëjen mae olblan. Te-ala beya zini in ki zep guzimki, ‘Ëe homë eno nik mo te-ala bohë unni insa enlala gwibiꞌin.’ Hwëna zi darena in kon, nara wëhë te-ala beya zini insa mamkam kwasang gweblaꞌanka? San ha betekkam de bohë tan zini? San ha mamkam de bohë tan zini?” ");
INSERT INTO ury_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon ki zep ding gulbluka, “Ëe ama enlala gweꞌan, men zëbe hap te-alana mamkam tap tasïblïka, zen zen sa sërkam kwasang gweblala.” Dekam zep Yesus gubluka, “In eiwa.” ");
INSERT INTO ury_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ki zep hwëna wenya insa lero gwibirki, ki zep hen Simonsa gubluka, “Wenya ansa wëhë hlaulu? Ëe sap eno golakë hatal, hwëna em home hona hamal gulu– ano tanasa dikim ngan sosun hupye. Hwëna wenya an mes zëre mo nwe go hokam ano tanana ngan sosul, deban mes zëre mo nol alakam sasa sol. ");
INSERT INTO ury_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Em home asa babang tala– ëe kimë awe tïl zïlye. Hwëna wenya an, Ëe kimë awe hatazal, zen man ano tanana bolk-bolk so tiner. ");
INSERT INTO ury_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Em home ano nola minyak zaitunkam draulu– Asa de dokwak ta gun hupye. Hwëna wenya an mes irase nabare minyakkam ano tanana hlë tazim. ");
INSERT INTO ury_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Zebë emsa gubluꞌan: Wenya an mae hap kwasangna mamkam abe hap goltrëblal: Sap zen mes anakan tame gul, ‘Ano karek-karek beyana mes namen ap tap gulsubirida.’ Hwëna zini men zëno mae mo betekkam de ngip gul gwensa tap gulsuzimdinni, zen betek enkam sa ap kwasangna noltrë gweblal.” ");
INSERT INTO ury_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesus dekam zep wenya insa gubirki, “Eno karek-karekna mesë ep tap gulsubirin.” ");
INSERT INTO ury_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ahakon men zen zëwe teinikinꞌik dekam zep enlala ennak Yesussu donsubluꞌak, “Zëno karekna insa tap gulsubin hip gunda, zen man kïl gïꞌïra, ‘Ëe an Alap han apdenak.’ Kirekam insa gunda, zen Alapsa lamang tanda.” ");
INSERT INTO ury_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Hwëna Yesus ki zep wenya insa gubirki, “Em mese Asa taïblïblanda, em zebe ngaya gwenda. Wake, amki aha-ere enlalakam song gwe.” ");
INSERT INTO ury_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Zao hom holo gweꞌak, Yesus ki zep ë-ë san amjanbir song gweka. Desan Alap Zën de ïrïk gïn hïp de ol dawemna goltën daka. Dua-blas enkam de zëre hon ang ta gwen wenya man ang nëblanda gwek. ");
INSERT INTO ury_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Hen we walya mensa dowal de tïlbiridan nakon hen sang-sang nakon dawem tabirki man hen ang tanda gwek. Ahana Maria– mensa nen gwibik Magdala kore we. Zëbon onakon dowala tuju enkam mes golëalsa soneka. ");
INSERT INTO ury_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ahana Kuza Bak mo wenya Yohana. Kuza zen teipsïn zini Herodes mo golak de aha mamna. Ahana Sosana, hen ahakore we walya beya nik ang ta gwek. We walya in hen man Yesus maesa zëre hon de ang ta gwen wenya ban zëre mae mo te-alakam mas neibirida gwek. ");
INSERT INTO ury_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Zi beyana ki zep etan Yesus hon dep zi-ë zi-ë nakon yaïng gwe-gweꞌanzak. Yesus ki zep zë ola gulk sun blaonzimki, ");
INSERT INTO ury_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Zini man orep gandum dansa de hlïng gïlsïn hïp song gweka. Kim hlïng gïlsïkï, hwëna ahakon oranak altïnk. Zi zep zë nyaublunda gwek, hen ahakon mawa zë dwensïblïndak. ");
INSERT INTO ury_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Hen ahakon kaso-kasonak altïnk. Kim sap ësïp gwek, hwëna ki zep tol ëboneng gwek, sap kasona in sal-sala. ");
INSERT INTO ury_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Hen ahakon dokot të ngï-ngï ausunak altïnk. Kim sap tol ësaltïk, hwëna dokot të ngï-ngïna in zep nabakam ëblal-blal gwek. Zen zep dahalebik, hëndep eini hom tëka. ");
INSERT INTO ury_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Hwëna ahakon hen kama dawemnak altïnk. Zen dawemkam zep ësïp gwek, hëndep dawemkam zep hataka, hëndep dawemkam tëka. Aha-ere timni, zëno dan beyana seratus maenak zep hata gweꞌak.” Ola insa kim tonsuku, ki zep hwëna ol mamkam gubiridaka, “Em dwan i nibanke. Em ësal gwen!” ");
INSERT INTO ury_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Dua-blaskam de zëre hon ang ta gwen wenya in ki zep nenblak, “Bian, gulk sun de ol blaoranna insa emki ap srip gulsuzimdin.” ");
INSERT INTO ury_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesus ki zep ding gulzimki, “Abon de ang ta gwen wenya ebe mae hap Alap mes golzimki– em dikim zëre mo ïrïk gïn hïp denaka tame gul gwen hap denaye. Hwëna aha zi hip hom kirekam golzimꞌira. Ëe in zebë zëbe mae hap gulk en san ola blaon gwizimnin. Sap Alap man desa dwam gwibiridaꞌara– men kirekam zëre mo olak lwakke, kirekam de hëndep zëbe mae hap anakan lwa gwizimdin hip, ‘Zen sap sa hla nul gwer, hwëna san de hlaun srëmna. Hen sap sa ësane gwe-gwer, hwëna zen molya tol dam nulsuk gwek.’” ");
INSERT INTO ury_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ola insa gulk sun blaonzim, dam gulsunnu a kirekam moye: Gandum danna, zen Alap mo ol. ");
INSERT INTO ury_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Gandum dan de oranak altïrïnnï, zen men kiye: Zini men zen Alap mo ola insa ësane gwe-gwenan, hwëna dowal mo kïgïna dekam zep hata gwenan zala– ola insa de zëno mae mo enhonak alal gul gwizimdin hip. Mae hap ki kirekam gweibirida gwenda: Zen dikim ëei gwen srëm hap, hen ëngaya gwen srëm hap. ");
INSERT INTO ury_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Gandum danna men zen kaso-kasonak altïrïnnï, zen men kiye– zini men zen sap ësane gwenkam isrip-sri naban dokwak nul gwenanke. Hwëna ola in bëjen zëno mae mo enhonak sa gwen. Zen dekam en de sap ëei gwen, hwëna kim karekna noltowe gwenan, zen dekam zep Alapsa hli da gwenan. ");
INSERT INTO ury_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Gandum danna men zen dokot të ngï-ngï ausunak altïrïnnï, zen men kiye– zini men zen sap ola insa ësane gwe-gwenan, hwëna enlala ngalapna man zëno mae mo enhonak ëbeya gwe-gwenan– te-ala beya gwen hap dena, hen syan-syan en hap dena. Kirekam de enlalana in zep Alap onakare ol dawemna insa zëno mae mo enhonak hule gwenan, hëndep eini bëjen dawemkam bïl gwen. ");
INSERT INTO ury_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Gandum danna men zen kama dawemnak altïrïnnï, zen san de men kiye– zi enlala dam-damna hen enho dawemna. Zen kim ola insa ësane gwe-gwenan, zen dawemkam ing nul gwenan, hen tatem zëwe ëzauk gwenan, hëndep dawemkam eini ëtë gwenan.” ");
INSERT INTO ury_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Zini hom pelita ngatannak yuna utuk nul sone gwenan– dekam de ngatanna insa aning gun hupye. Hen pelitana hom tum ïltïkïnnïk si nulin gwenan. Zen diki meja maenak nonne gwenan– dekam de ngatannak zïnï zi niban golëteinikirin hipye. ");
INSERT INTO ury_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Hen kirekam, ola mensaë gulk sun de blaonzimdinkim zi beya hap aning gul gwizimꞌin, zen sa lamkam wet sol. Hen ano enlala aning tanna dekam sa tawa nëblal. Zen diki dekam sa zini dam nulsuk gwer. ");
INSERT INTO ury_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Zen in zep ano ola mensa ena ësane gwe-gweꞌan, dawem enkam emki enhonak lone gwen. Sap men zen Alap mo ïrïk gïn nïka de tame gun hup ëhohle gweꞌan, zëbe mae en hap sa etan Alap dekam de tame gun hup de enlala blala sowe henkam ing ta sone gwizimdi. Hwëna men zen ëhohle gwe srëm gweꞌan, tame gun hup de enlalana men zen betek enkam nama lwazimꞌira, mensa zëna enlala në gweblanan, ‘Abon ki lwaꞌara,’ desa sa hwëna Alap al tazimdi.” ");
INSERT INTO ury_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesus mo anena ki zep oso wal zeban Yesussu de zertoran hap golëyaïng gwezak. Hwëna golek de tanna ba kon dep? Sap zi trana dekam mes ëkyang gwesïk. ");
INSERT INTO ury_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Dekam zep ahanik Yesussu gubluka, “Bian, eno anena oso wal oban ë nakon emsa ziësblaꞌanon. Man eban de zertowen hap ëdwam gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesus ki zep ding gulzimki, “Tïngan men zen Alap mo ola ësane gwe-gwenan hen desan ang ta gwenan, zen diki zen– ano anena hen oso walyaye.” ");
INSERT INTO ury_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Aha yaklakam, ki zep Yesus zëre hon de ang ta gwen wenyaka gubiridaka, “Nen ho gutu men eihya san gweyo gwen.” Dekam zep hëndep bulkum sek gwek. ");
INSERT INTO ury_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yesus hwëna nisi zë taka. Mumuk ennak zep asese yawala hataka. Hona dekam zep buluk hlëwehe kïnzï gweꞌak, hëndep bulu in keing gwen hap alp gwesïꞌïk. ");
INSERT INTO ury_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Dekam zep lï dak, ki zep nenblak, “Bian, Bian, nen an em-am angkam juweꞌan!” Yesus kim luweka, ki zep asesena insa sërkam de ho ngëpna in han jalse gwizimki. Dekam zep tangan hëndep së nëhek. ");
INSERT INTO ury_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesus ki zep gubiridaka, “Ki san em home Asa laïblïblaꞌan?” Dekam zep aïrïn nïban denggwanblaꞌak. Ki zep zënaka nenbiridak, “Eiwa, zini an wehasa hom! Ba hap tangan zëno jalse gwizimdin enkam asese naban ho ngëp naban nyausunun?!” ");
INSERT INTO ury_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Dekon zep hëndep bulkum sek gwek– hëndep Gerasa mo langnak, Ho Gutuna Galilea mo men eihya san. ");
INSERT INTO ury_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesus kim ho alpnak ati gwe ineka, zao zep dowal mo bi gweblan zi niban zertoweꞌanka. Zen sap orep ënak gwë gweka, hwëna dowal-dowala kim bi nëblak, dekam zep irkan gwë gweka. Hen golak de gwë gwen hap man baes gwe-gweka. Hwëna zi lo tasïk gwibin kaso-hul kaso-hul en san gwënda gweka. Zini in mes tangan holo gweka– kirekam de gwënda gwenna. ");
INSERT INTO ury_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Bwi maenak sap taha-tana naka besi dokotkam de tatak soblan naka tak da-in gwek. Hwëna dowala in hen-henkam napta gweblak, zep soson gwenkam besi dokotna insa blom tabir inhal gweka. Dekam zep dowala in zi srëm lang san dep nërhal gwek. Zen kim Yesussu hla taka, ki zep hërheka, deban Yesus mo nwenak ïk gwehe zaka. Yesus ki zep dowala insa gubluka, “Dowal, em zëbon onakon wet son!” Ki zep etan mamkam hërheka, “Yesus, Teipsïn Zini Alap mo Tane! Em aban toton banakan de syal ën hap? Ëe ama Emsa abe taꞌan: Bahem asa karek tan!” ");
INSERT INTO ury_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesus ki zep takensïblïka, “Eno bosena nara?” Ki zep ding gulbluka, “Ano bosena Jal Zi Tra Bak.” Zen mae hap ki kirekam ding gulbluka: Sap zëbon dowal-dowala tra tangan nik lowehe gwek. ");
INSERT INTO ury_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Dowal-dowala in ki zep Yesussu etan-etankam aberbe daꞌak, “Asa bahem gubiridan– juwen zi mo bwi kawesïnnïk dep de atiti gwe inen hapye.” ");
INSERT INTO ury_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Zëno mae mo nwe kara gwen san zahona beya tangan nik tembane hap kwatap tïnï san ëhakaꞌak. Dowal-dowala in man aberbe daꞌak, “Em wëhë tol asa gubiridaꞌanka?– zaho trana wakuwe de bïtï gwen hapye.” Yesus ki zep gubiridaka, “Dekam bïtï gwek.” ");
INSERT INTO ury_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Dowal-dowala in kim zini in kon wet so gwek, dekam zep hwëna zahona iwe bïtï gwek. Zaho trana in dekam zep heya-hya gwek, li san zep hëndep ësyalk tak, hëndep ho gutunak zep ëkei-king gwek. ");
INSERT INTO ury_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Zahona insa men zen dekam kara dabiꞌik, kirekam kim hla nulidak, dekam zep zaho bi naka de gubiridan hap ë san dep hen ëna in mo golek denak de gol-gol san dep ëhlu-hluk gwek. ");
INSERT INTO ury_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Zëwe de zini kim ësak, dekam zep hëndep nolësal kïnïk. Yesus hon kim yaïng gwezak, zao zep hla dazak– zini insa dowal-dowala tapbla dakye. Zen Yesus mo tana alp nakon pakean naban nikinꞌinka, hen enlalana mes sëwe heblaka. Dekam zep zë ëaïrïꞌak. ");
INSERT INTO ury_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","In zen hla nuk, zen zep ë nakon in zen yaïng gwezak desa donbiridaꞌak, “Zini ansa kirekam dawem tala.” ");
INSERT INTO ury_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Dekam zep tangan sërkam ëaïrïk, dekam zep tïngan Yesussu abe dak– Zen de nabakam dekon song gwen hap. ");
INSERT INTO ury_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Zini in desa dowal-dowala tapbla dak ki zep Yesussu aberbe taꞌanka, “Ëe wëhë tol Emsa ang gweblaꞌak?” Hwëna man gubluka, ");
INSERT INTO ury_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Em gol san song gwe hen tawa tabir– mensa Alap dawemna ebe hap mamkam golblalake.” Dekam zep Yesus hli yuludaka. Zini in ki zep song gweka, ë yala iwe de zini kïtak tangan tonbirida gweka– Yesus mensa zëbe hap dawemna mamkam golblakake. ");
INSERT INTO ury_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesus kim etan lwahal zaka– Ho Gutuna Galilea mo an eihya san dep, dekam zep zi trana dawem enkam dokwak dak, sap zen man nësblaꞌak. ");
INSERT INTO ury_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Zao zep hen zi bosena Yairus hata zaka. Zen Yahudi mo zëwe de but srëm golak de aha mamna. Zen ki zep Yesus mo nwenak ïk gwehe zaka, dekon zep aberbe ta seka– zëno golak de hatan hap. ");
INSERT INTO ury_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Sap zëno wenam tol aha-erena man tïn hïp alp gwesïꞌïk– dua-blas tahun nik. Yairus mo gol san kim song gweꞌanka, zi trana in man ngïrïnnïk nëblahak, hëndep man ëngïltïtïk gwe-gweꞌak. ");
INSERT INTO ury_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Wenya hen dekam man ang gwese haꞌak. Zen dua-blas tahunkam karekkam aura gwe-gwek. Zini man sap dawem gun hup naka gwibik, hwëna hom kim mae dawem gwe-gwek. ");
INSERT INTO ury_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wenya in ki zep Yesussu tahan nakon golek de tazak, zao zep baju sïhï top nakon olk ta sonek. Dekam zep hëndep kala in tewesibik. ");
INSERT INTO ury_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesus ki zep takensibiridaka, “Asa an nara olk tanda?” Tïngan man ëguk, “Ëe homë.” Petrus ki zep ding gulbluka, “Bian, zini an beya tangan nakake! Man-am emsa dot dasïl.” ");
INSERT INTO ury_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Hwëna Yesus ki zep gubiridaka, “Hwëna ahana man asa olk tala, sap Ëe ama anakan eisbirin, ‘Zini man Asa de olk tankam dawem gwenda.’” ");
INSERT INTO ury_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wenya in dekam zep enlala gwek, “O hare mes-am asa dam gulsunda!” Zen dekam zep yal-yala ban Yesus mo nwenak ïk gwe hezak, dekon zep tïngare zi mo ngïrïnnïk iwe ton seblak, “Ëe dawem gwen habë dwam gwer, zebë Emsa olk tal. Ano kala dekam zep hëndep tewesïnïn.” ");
INSERT INTO ury_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesus ki zep kwasang tola ban gubirki, “Anyan, em ema Asa taïblïblala, in zebe dawem gwenda. Aha-ere enlalakam song gwe.” ");
INSERT INTO ury_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus in kim nama ola tonꞌanka, Yairus mo gola kon ki zep zini hata zaka, ki zep Yairuꞌu gublu zaka, “Eno wenamna mes tol tïlsïnïn. Bahem etan Bian Gurusa blostablan.” ");
INSERT INTO ury_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Hwëna Yesus kim kirekam salka, dekam zep Yairuꞌu gubluka, “Bahem aïrïn. Asa em taïblïblan, zen dekam sa eno wenamna ngaya gwer.” ");
INSERT INTO ury_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Golak kim golëyaïng gweka, Yesus dekam hom aha zi niban de golëbïtï gwen hap gubiridaka, diki Petrus, Yohanis, Yakobus, hen wenam tola in mo ane-bia ensa. ");
INSERT INTO ury_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Zëwe tïngare zini wenam tola insa gosa dabiꞌik, hwëna Yesus zep gubiridaka, “Gona olzausuk. Wenam tola in hom tïl. Zen nisi am taꞌan.” ");
INSERT INTO ury_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Hwëna man swrë daꞌak, sap zen mes wenam tola insa tame nuk, “An mes-am tangan tïlke.” ");
INSERT INTO ury_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Hwëna Yesus wenam tola in mo aha taha naka zep teisyabir ineka, deban zep gubirki, “Timë, em luwen!” ");
INSERT INTO ury_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Wenam tola in mo maumnu dekam zep etan hata zaka, hëndep dekam zep luwek. An-bi zemka dekam zep tembanesa de olbin hip guzimki. ");
INSERT INTO ury_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Zëno ane-biana man tangan lenggwanblak. Hwëna Yesus man jalse gwizimki, “Owasna an zen ki lwanan, bahem ahasa lonbiridan.” ");
INSERT INTO ury_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesus ki zep dua-blas enkam in zen zëre hon ang ta gwek tagal gulsuku, ki zep zë gubiridaka, “Ëe asa ëre mo sosonsa ebe mae hap golzim– em ekakim kïtak de dowal-dowalsa olëalsa sone gwibik, hen zi sang-sangsa ekakim dawem labir song gwek.” ");
INSERT INTO ury_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ki zep zë etan gubiridaka, “Dekam sek gwek. Zi sang-sangsa dawem labir song gwek, hen deban anakare ola ol haladak, ‘Alap Zën de nësa ïrïk gïn hïp denak angkam man golek de gweꞌan.’ ");
INSERT INTO ury_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Bahem ba maena ora san dep lop tan– sap dutena hen hon maena bahem. Tembanena bahem hen lop tan, hen te-ala maena. Timnik de baju ala son enkam emki sek gwen. ");
INSERT INTO ury_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Gol karek mae nakon de emsa zer irinni, zen zëwe en emki gwën. Bahem dekon gol dawem san dep al gwehan. ");
INSERT INTO ury_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Hwëna men dekore ë nakon emsa zer irin srëmna, ki zao em tana sonna taïk-tïk so gukhan– zen dekakim anakan tame nuk, ‘Zen sap Alap onakore ol dawem naban nëbe mae hap golhatazim zira, hwëna nen insa ër-in srëm gwenan nëre mae hap de kareksae kim mam ulin.’” ");
INSERT INTO ury_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Dua-blaskam de zini in ki zep ë-ë san zë-en zë-enkam sek gwendak. Zen Alap onakore ol dawemsa nolhaladak, hen zi sang-sangsa dawem dabir song gwek. ");
INSERT INTO ury_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Dekam teipsïn zini Herodes Galilea mo langnak ïrïk gïꞌïnka. Zen kim tïngare owas-owasna in hap dena salka, dekam zep tangan enlalana topse gweblaꞌanka. Sap ahakon anakan ëgu gweꞌak, “Baptis ta gwibin zini Yohanis Swe mes etan ngaya gweka. In zen hwëna bosena Yesuskum li yul soneka.” ");
INSERT INTO ury_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Hen ahakon man ëgu gweꞌak, “Elia Bak Swe mes yap etan ngatan zi mo lang nakon jowe zaka.” Hen ahakon ëgu gweꞌak, “In orep men zen Alap mo ola ayang nul gwekke, zen mes yap ahanik etan tïn nïkon de ngaya gwenkam bosena Yesuskum li yul sone zaka.” ");
INSERT INTO ury_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes dekam zep hwëna guku, “Ëe mes-am gubiridak– Yohanis mo nolsa de blaonsublun hapye. Zep an hwëna nara zi zë etan joweꞌan zala? Ëe mesë zini in hap de ola beyakam sane gwe-gwek.” Zen dekam zep sap dwam gwe-gweꞌanka– Yesussu de hen hla tan hapye. ");
INSERT INTO ury_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Dua-blaskam de zini in kim etan lwanda halzak, ki zep Yesussu donblazak– tïngan mensa ki zëna syal tan dakke. Dekam zep kon hwëna Zën etan golësek gweka– ëna Betsaida mo lang san dep, zao de zë-en golëgwë inendan hap. ");
INSERT INTO ury_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Hwëna zini kim ësak, “Yesus desan song gwenda,” lun kon zep nërtrok. Yesus kim hlauludaka, ki zep haen gwibiridaka. Zao zep Alap Zën de ïrïk gïn hïp denaka tawa tabirki, hen zi sang-sangsa zë dawem ta gwibiꞌinka. ");
INSERT INTO ury_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Zao zep hëndep dapse gwesïꞌïk. Dua-blaskam de zëre hon ang ta gwen wenya in ki zep nenblazak, “Bian, langna an dwan tahalha tangan nakake. Dawemna zi beyam-byana ansa Em gubiridan– dekakim tembane hap hen ni tan gol-gol hap ëhakalsïndak.” ");
INSERT INTO ury_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yesus hwëna man ding gulzimki, “Amki em tembanena zëbe mae hap hen olzimk.” Ki zep ding nulblik, “Nëno mae mo rotina aha-ere taha-tap enkamke, hen hogwena dan-dan en. Kina ki nëno mae mo te-alana man– dekam de tokonak tembanesa zi trana an hap lop tazimdin hipye!” ");
INSERT INTO ury_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Sap dekam in zen zë lowe heꞌak, zi enna san ha lima ribu enkam mes yap– we wal walassa de aïtbin srëmkamye. Yesus ki zep gubiridaka, “Em gubiridan– hlïk-hlïkkam de teinikirin hip. Aha-ere hlïkna 50-50kam de teinikink.” ");
INSERT INTO ury_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kirekam de teinikirin hip zep nenbiridak. ");
INSERT INTO ury_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ki zep roti aha-ere taha-tapna insa hogwe darena in han teisyaka, dekam zep nglï san de kara gwesen naban Alap hap dawemna golblaka. Ki zep hwëna rotina insa ahap tabirki, hen hogwe darena insa kwa-kwak soka. Dekam zep dua-blaskam de zini in hap etan-etankam kap ta gwizimꞌinka– zen dikim hwëna zi beyam-byana in hap kae gwebla-zimdin hip. ");
INSERT INTO ury_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kim dwenblandak, hëndep kïtak man ëïtrï gwek. Dua-blaskam de zini in dekam zep etan tembane mosrona insa tagam dasïk. Yuna dua-blas enkam zep ësuwek. ");
INSERT INTO ury_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Aha yaklanak, Yesus zë-en de gwën nakon Biansa abe taꞌanka, hen zëre hon de ang ta gwen wenya zëwe lowe heꞌak. Zao zep takensibiridaka, “Zi mo Asa de dam tasïnkïm, Ëe an nara mo weinak debë hatazak?” ");
INSERT INTO ury_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ki zep ding nulblik, “Ahakon man emsa nen gweblanan, ‘In baptis ta gwibin zini Yohanis Swe etan tïn nïkon ngaya gweka. In zen hwëna Yesuskum bosena li yul soneka.’ Hen ahakon man emsa nen gweblanan, ‘In Elia Bak mo weinak Alap mo olsa ayang gul gwizimꞌira.’ Hen ahakon man emsa enlala në gweblanan, ‘Zen diki ahakon men zen orep Alap mo ola ayang nul gwek, zen mes yap ahanik etan ngaya gweka. Zen hwëna bosena Yesuskum li yul soneka.’” ");
INSERT INTO ury_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ki zep etan takensibiridaka, “Hwëna ere mae mo Asa de dam tasïnkïm, Ëe an diki nara mo weinak dep dena?” Petrus zep ding gulbluka, “Bian, Em an Zen– Israelsa de ngaya tabin hip de Zi niye, Alap men Desa dam tasïkïye.” ");
INSERT INTO ury_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ki zep hwëna gubiridaka, “Insa kirekam Asa dam lasïnïn, aha maesa hwëna bahem gubiridan.” ");
INSERT INTO ury_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Etan ki zep gubiridaka, “Alap mo dwam gwibinni abe hap dena a kirekam sa lwal: Ngatan zi mo lang nakore Zi Tanganna Ëe karekna mam tangan naka asa goltowe gwer. Hen Yahudi mo nol-nola, Alap mo golak de mam-mam wenya, hen Musa mo olsa de tawa ta gwibin wenya sa Asa baes nëblal, hëndep sa Asa dal. Hwëna yaklana dan-ahan, ki sa Bian tïn nïkon etan Asa ngaya tala.” ");
INSERT INTO ury_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesus hen man zi beyasa gubirida gweka, “Men nara Abon de ang gwe-gwen hap dwam gwenna, zen diki zëre mo gwënna zen eititi gwibin– dekam de zëre hap de te-lidak son wë son naban Asa zertronda gwen hapye, anakare enlala naban, ‘Ëe sap asa Yesus hun apdenak lïl.’ ");
INSERT INTO ury_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sap men zen de zëre mae mo auhu-kamanak de gwënna anakan nolaïrï gweꞌak, ‘Ëe babë Yesussu de ang gwe-gweblannak karekna goltowe gwen,’ ki zëno mae gwënna in sa jek-jak gwer. Diki men zen Asa de ang gwe-gweblan hap zëre mae mo gwënna sosok nul gweꞌak, hëndep zao mae de tïn hïp, zen zen sa hëndep denaban ëngaya gwer. ");
INSERT INTO ury_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","San ha dawemna?– em de sërkam te-ala beya gwenkam hëndep kïtak de okamana ansa bi gwibinkim, hwëna dekam de ere mo gwënsa tïhïs gïnkïm. Kirekam dawem naka hom! ");
INSERT INTO ury_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Zi de anakan de gunsu saher gwenna, ‘Ëe Yesussu de ang gwe-gweblan zi,’ ki ngatan zi mo lang nakore Zi Tanganna Ëe kimë Bian mo ngatan naban hen soson naban zëno dam taha nakore zi niban golëyaïng gweꞌanzak, Ëe molyë hen desa anakan kira tak, ‘Zini an eiwa Asa de ang gwe-gweblanna.’ ");
INSERT INTO ury_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Eiwa denakaë emsa gubiridaꞌan: Em an zene awe lowe heꞌan, em molye ahakon na-en juwek– Alap mo yakla yalak de zaun srëmnakye. Em esa Asa hla lal– Ëe kimë zëre mo bose hap de ïrïk gïn hïp hataꞌan zakye.” ");
INSERT INTO ury_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Zënaka de karek tan hap dena in kim tawa tabirki, zao san ha mingguna aha-en tamank, ki zep kwatap san dep golësek gweka– Petrus, Yohanis, hen Yakobus mae en han, Alapsa de dekon gu soneblan hap. ");
INSERT INTO ury_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kim kon ola gu soneꞌanka, nwe-masena dekam zep hwëna liwe heblaka, hen pakean zem man tangan sërkam ngap-ngap nëblak hen nglï ang makan nalïlïngtïlblïꞌak. ");
INSERT INTO ury_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Mumuk ennak zep Musa ne Elia ne ngatan zi mo lang nakore ngatan naban oljowe zaka. Ki zep zë Yesus hun ërtonꞌanka– Zën de Yerusalemk tïn hïp denaka, men kirekam Alap gu-gublukake. ");
INSERT INTO ury_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petrus dekam wal bose wal zeban totokkam nisi golëtruweꞌanka. Mumuk ennak zep luk taꞌanzak, dekam zep Yesussu hla dak– ngatan zi mo lang nakore ngatannak kim zi darena in ërzauꞌunka. ");
INSERT INTO ury_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Zi darena in kim Yesussu hli laꞌanka, Petrus ki zep totoresa gubluka, “Bian, dawem tanganna– nen de awe lowehe gwen naye. Zep ëe asa gol kluksa dan-ahan syal ëblandal– ahana Bian ere hap, ahana Musa Bak hap, hen ahana Elia Bak hap.” Hwëna Petrus insa kirekam gubluka, hyanak zëna man saher gwibiꞌinka, “O ëe an ba habë kirekam gublul!” ");
INSERT INTO ury_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petrus kim nama kirekam ola tonblaꞌanka, butna ki zep ati gwezak, hëndep man zë wale tabirzik. Dekam zep ëaïrïꞌak. ");
INSERT INTO ury_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ki zep hwëna butna iwe ola ësak, “An ano Tane, ëre mo Dam Tasïnnï. Desa em sal gweblan.” ");
INSERT INTO ury_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ola in kim zausuk, dekam hwëna Yesus ensa zë hla dak. Owasna insa ki zë hla nuk, zen hom mae aha maesa donbiridak– Yesus kim nama golëlowe heꞌankaye. ");
INSERT INTO ury_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kaknak zep Yesus zëre hon de ang ta gwen zi dan-aharena in han kwatapna in kon golëtine gweka. Hwëna ki zep zë zi beyam-byana hla nulidaꞌanonk. Man kon nësblaꞌak. ");
INSERT INTO ury_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ki zep kon ahanik ol mamkam gu hanaka, “Bian, ëe ama emsa abe taꞌan: Ano walassa emki mas gweblan, sap ano walasna ahana hom. ");
INSERT INTO ury_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dowala kim tïl gweblanda, hëndep dekam zep hërhen naban zënaka zerheirisen gwenda– ëk tutum nuban. Kire enkam ki karek tanda gwenda. Hom holokam hli ta sehal gwenda. ");
INSERT INTO ury_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mesë sap ere hon de ang ta gwen wenyaka zen de dowala insa zeralsa sonen hap gubiridal. Hwëna man sap nakablal.” ");
INSERT INTO ury_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesus ki zep gubiridaka, “Eiwa, angkam de zini em ei nibarena hom tangan! Em in nol drak-drak enna. Ëe san ëse nakaë sap emsa golëlowehe gwek! Ëe ama bae– eban mae de holokam golëlowehe gwen naye. An san emki walasna insa zer halzan.” ");
INSERT INTO ury_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Walas tola in kim song gweꞌan zaka, zao zep dowala in karekkam zerheirki, dekon zep yal-yal gwe seꞌanka. Yesus ki zep jala ban zëbon onakon de wet son hap gubluka, dekam zep hëndep dawem gweka. Ki zep hwëna bi zem insa gubluka, “An dë– eno walas naye. Mes dawem gwenda.” ");
INSERT INTO ury_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Zi trana in man tangan ëtenggwank, hen man ëguk, “Eiwa, Alap mo sosonna mam tanganna!” In kim zini nama Yesus mo owas syal gwe-gwibin hip ëtenggwan tineꞌak, ki zep hwëna dua-blaskam de zini insa gubiridaka, ");
INSERT INTO ury_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ola an ing uk. Bahem awe hli yun: Ngatan zi mo lang nakore Zi Tanganna Asa sa jal zi mo tahanak dep tapbla dazim.” ");
INSERT INTO ury_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Hwëna zëre hon de ang ta gwen wenya in hom tame nuk. Banakan mes yap zë gweibiridaka, zep tame nul srëm gwek. Man sap tame gun hup dei gwibik, hwëna takensïblïn hap man naïrïblak. ");
INSERT INTO ury_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Dua-blaskam de wenya ki zep zën mae hap ëol tetek gweꞌak, “Diki ëe amaka nëre mae onakon mam gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Hwëna Yesus mes zëno mae mo ëol gwenna insa tame gulku, zep walas tola zerhal zaka. Ki zep zëre mo alp nakon zaun hup gubluka. ");
INSERT INTO ury_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ki zep hwëna gubiridaka, “Zini men zen de ano bose hap aha zisi mas gweblaꞌanka– sap anakare walas tol maesa, Ëe asa desa enlala gweblal, ‘Zen Asa mas gweblaꞌara.’ Hen zi de Asa mas gweblanna, Alap men Zen Asa zer soneka, Zen sa zini insa enlala gweblala, ‘Zen hen Asa mas gweblaꞌara.’ Zep zini men zen ebon mae onakon babu gwen zi mo kim lowehe gwenan, ki zen zen Alap mo nwenak ëmam gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ki zep hwëna Yohanis gubluka, “Bian, ëe ama zisi hla lak– eno bosekam de dowalsa golëalsa sone gwennak. Ëe zebë jalse ëblak, sap zen nëbon mae de ang gwe-gwen naka hom.” ");
INSERT INTO ury_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesus ki zep ding gulbluka, “Em bap jalse ëblak, sap zini men zen emsa baes gwibiridan srëmna, zen zen– ebon mae onak dep denaye.” ");
INSERT INTO ury_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mes golek de gweꞌak– Yesus dikim okamana ansa hli yun hup, dekam zep Yerusalem san dep golësek gweꞌanka. Zini sap zë tru-tru nul gweblaꞌak, “Yerusalem san bahem song gwen.” Hwëna hom salbiridaka. ");
INSERT INTO ury_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Dekam zep zini lup gul soneka– Zënaka de langna Samaria mo ë san dep ngeirblin hap, zao de zisi de takensibiridan hap, “Nara wëhë gola kon Yesussu zer inꞌinka?” ");
INSERT INTO ury_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Hwëna ëna iwe de zini Yesussu de zer irin hip man baes tak, sap zen mes anakan tawa nëblak, “An Yerusalem san dep song gweꞌara.” ");
INSERT INTO ury_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kirekam kim ësak, Yakobus ne Yohanis ne ki zep enblaka, “Bian, em wëhë dwam gweꞌara?– nen syauksu nglï nakon de ati gwezan hap abe gwibin– zao deka zini in ëhwasdek.” ");
INSERT INTO ury_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Hwëna Yesus dekam zep lero gwizimki, ki zep jal gwizimki. ");
INSERT INTO ury_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Dekam zep kon aha ë san dep sek gwek. ");
INSERT INTO ury_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","In kim nama golëtën daꞌanka, zini ki zep Yesussu gublu zaka, “Bian, men desane ki të gweꞌanka, ëe asa Emsa ang gweblanda gwer.” ");
INSERT INTO ury_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ki zep ding gulbluka, “Gwenya witir zem ki. Hen mawana zol zem ki. Hwëna ngatan zi mo lang nakore Zi Tanganna ano ni ta gwen gola hom.” ");
INSERT INTO ury_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Hwëna ahanaka zep sap gubluka, “Em Asa ang gwebla.” Hwëna zini in man ding gulbluka, “Bian, ëe asa hëndep. Ki ano bian de tïnkïm, nara molya drë nwanuka.” ");
INSERT INTO ury_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesus ki zep ding gulbluka, “Zen zi tokna dikire zi tok bose zik kang nulne gwek. Em hwëna dekam ola ansa anakan gol halada, ‘Angkam Alap man nësa de ïrïk gïnkïm kon gwisibir hanaꞌara.’” ");
INSERT INTO ury_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ahana hen zini ki zep Yesussu gublu zaka, “Bian, ëe ama Emsa de ang gwe-gweblan hap dwam gweꞌan. Hwëna nonol ëre mo iye osan dep anik song gwek– aumwa olsa de hli yulzimdin hip.” ");
INSERT INTO ury_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ki zep ding gulbluka, “Zi de Alap mo nganak syalsa kon gwesibir hananna, hwëna zen de lure san denaka lero gwesibir kïnï gwenna, zen hom dakastïꞌïra– Alap mo ïrïk gïnnïk de syalak de mas gwen hapye.” ");
INSERT INTO ury_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bian Yesus ki zep etan ahakore zisi dam tasibirki– tuju-pulu enkam, ki zep gubiridaka– dan-dan dan-dankam de ë-ë san Zënaka ngeirblindan hap, Zëna men desan amjanbiridan hap kalang gwekake. ");
INSERT INTO ury_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ki zep ola gulk sun blaonzimki, “Nga yala awe de obwagana mes mamkam bïl gwera, hwëna men zen de taran hap dena dan en tangan. In zep Nga Bi naka em abe ta gwen– Zen deka zisi ngana awe de syal ta gwen hap lup gul sone gweka. ");
INSERT INTO ury_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Dekam sek gwek. Emki ëenlala gwen: Ëe domba makare soson srëm nakaë emsa lup gul soneꞌan– gwe tïhï jal-jal ngïrïn sïn dep. ");
INSERT INTO ury_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Dompetna bahem bïtï tan. Honna hen bahem wëwek tan. Sepatuna ala son enna kim em sek gwen. Aha maena bahem kap tan. Men zao debë emsa teisya soneꞌan, bahem oranak yausuk song gwen– aha zi maesa de zertowenkamye. ");
INSERT INTO ury_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Men zao gola lïꞌïnka, nonol em en kïnïn, ‘Dawem. Em Alap mo taha terenake lowe heꞌan.’ ");
INSERT INTO ury_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Zao de Alap osan dep de hohle gwen nik gwëꞌanka, ki eiwa zao esa Alap mo taha terenak dawemkam lowehe gwer. Kire nik de gwën srëmkam, ki emki enbirida gukhan, ‘Ëe mensa nonol emsa enbiridanan, Alap mo taha terenak de sap lowehen hap dena, ki awe molya ki lwak.’ ");
INSERT INTO ury_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Men zao gola lïnnï, zao en em ën. Tembanena mensa ep golzimdinni, desa en emki olgwenblandan. Sap tembanena in, zen eno nik mo tawa tabin hip de tembane. Ëna iwe de nama ënnak, dekon bahem etan aha zi mo gol dawem san dep al ëhan. ");
INSERT INTO ury_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Em de ënak aptankam, dekon de emsa dawemkam teisya irinni, mensa ep tembanena taïblïn gïlzimdinni, emki olgwenblandan. ");
INSERT INTO ury_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Hen zëwe de zi sang-sang ëgwënna, emki dawem labin. Deban hen emki anakan aïsïl eibiridan, ‘Alap angkam man kon gwesïk hanaꞌara– teipsïnkïm de nësa ïrïk gïnkïmye.’ ");
INSERT INTO ury_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Hwëna aha ënak de aptanna, zao de zi de emsa baes gwizimdinni, ora bol san em wet oson, dekon em enbirida gukhan, ");
INSERT INTO ury_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Eno mae mo ëna awe de sonna men zen ano nik mo tana ulpnuk makan gwer, ëe ama desa etan taïk-tïk oso guk halan– em dikim anakan tame gun hup, “Alap angkam man sap kon gwesïk hanaꞌara– teipsïnkïm de nësa ïrïk gïnkïmye. Hwëna em ema desan de ang tan hap baes taꞌan!”’” ");
INSERT INTO ury_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yesus ki zep waulsuzimki, “Ëe ama emsa gubiridaꞌan: Aumwa hap de zisi klis gunnuk, Alap ëna insa anakan sa enlala gweblala, ‘Zen orep de ëna Sodomk de zisi ëkarek gwenkam man kwei-kwik nuk.’ Zep men kirekam Alap orep Sodomk de zisi zëre mae mo karek-karek hap heip gulku, hwëna ano lup gul sonen zini emsa de lup gul irin srëm zini, desa aumwa hap de klis gunnuk sërkam tangan sa karek tabiri.” ");
INSERT INTO ury_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ëna Korazim hen Betsaidak de zi, em ëngalap gwen, sap Alap sa emsa sërkam karek tabiri. Ë darena Tirus hen Sidonk de zini insa Bian orep heip gulku, zen maka ëhalek– owas-owassa de hlaul gwenkamye, an kire owaꞌaë eno mae mo ngïrïnnïk syal gwe-gwibiꞌinye. Tirus hen Sidonk de zini maka bunsu de awabin niban kaen karonsa darak dak– dekam de zënaka anakan golëtrën hap, ‘Ëe ama ëhaleꞌan.’ ");
INSERT INTO ury_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hwëna angkam de ë darena, Korazim hen Betsaidak de zini, em an bëjen em ëhalen! Zen in zep, Alap de aumwa hap zisi klis gunkum, eno mae mo angna sa tangan sërkam karek tabiri. Hwëna ëna Sidon hen Tirusk de zi mo angna, desa de etan karek tabin hip dena sa jahalha gwer, sap zëbe mae hap hom Alap golzimki– dekam de ano owas-owas syal gwibinsi hlaul gwen hap denaye. ");
INSERT INTO ury_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kapernaumk de zini, em hen kirekam. Em ema ëkïl gïꞌïn, ‘Sap Yesus owas-owasna beyakam nëno mae mo ënak syal gwe-gwibirida, zep nësa sa Alap ngatan zi mo lang san dep dawemkam kang gul sera.’ Bëjen. Emsa hen syauk blanak sa yal gul sera, sap em home Asa laïblïblaꞌan.” ");
INSERT INTO ury_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ki zep zëre hon de ang ta gwen wenyaka gubiridaka, “Zini men zen emsa salbiridanna, zen hen dekam Asa nasalblaꞌan. Zini men zen emsa baes gwibiridanna, zen hen dekam Asa baes nëblaꞌan. Hen zini men zen Asa baes gweblanna, zen hen Bian Alap, men Zen Asa zer sone zaka, Desa hen baes nëblaꞌan.” ");
INSERT INTO ury_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tuju-pulukam insa zini lup gul soneka isrip-sri tangan naban lwanda halzak, ki zep Yesussu nenblazak, “Bian, sap dowal-dowal maena, eno bosekamë olëalsa sone gwibik!” ");
INSERT INTO ury_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ki zep ding gulzimki, “Em kime kirekam syal taꞌak, Ëe ama dowal mo kïgïsa hla tak. Alap desa man kama san dep hiri ta ineka, dekam zep nglï ang tasïk kïnïn makan zan zaka. ");
INSERT INTO ury_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Emki ësane gwen! Ëe mesë ebe mae hap sosonna golzimk– em dikim wanyasa zaubin hip hen dare-ëksa. Ëe hen mesë ebe mae hap sosonna golzimk– em dikim nëno mae mo jal zini dowal mo kïgïsa zauk gublu kïnïn hap. Zep angkam bana hom– emsa de zen karek tabin hip denaye. ");
INSERT INTO ury_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hwëna bahem anakan ëisrip-sri gwen, ‘Dowal-dowala man asa betek neibiridaꞌan.’ Diki mae hap em ëisrip-sri gwen: Eno mae mo bosem-sena mes ngatan zi mo langnak ale nuk.” ");
INSERT INTO ury_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Dekam zep Alap mo Enhona Yesussu isrip-srikam ing gwe heblaka, ki zep Alapsa gu soneblaka, “Bian, Em in Zen nglï naban okama naban ïrïk soꞌarake. Ëe ama ep dawemsa golblaꞌan, sap Em ema ere mo ïrïk gïnsï de tame gun hup dena enlala blal wenya kip hen sekola sul sonen wenya kip aning gul gwizimꞌira. Hwëna sekola srëm wenya kip hen enlala betek wenya kip ema goltrei gwizimꞌira. In eiwa, Bian, zen kire tangankam ere mo dwam gwibin sin ki lwaꞌan.” ");
INSERT INTO ury_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Bian Yesus Zen hen dekam dua-blaskam de zini anakan tawa tabirki, “Tïngare okamasa de bi gwibin hip de sosonna mes kïtak Bian abe hap golblaka. Zini toton bëjen Tane zem Asa tame tan. Zen diki ëre mo Bian en Asa tame ta gweꞌara. Hen ano Biansa nara dep?– tame tan naye. Zen diki A enë tame ta gweꞌan. Hen zini men zëbe mae habë dekam de ano Biansa tame tan hap dena gol gwizimꞌin, zen zen en angkam tame da gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Aha yaklakam kim zi beya naban golëlowe heꞌanka, dekam zep dua-blas enkam de zini lero gwibiridaka, ki zep desa en gubiridaka, “Em hëꞌho gwibinnike lowehe gweꞌan, sap em ema ano syala ansa hla kul gwenan. ");
INSERT INTO ury_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ëe ama emsa gubiridaꞌan: Abare srëmnak Alap mo olsa de ayang gul gwizimdin hip de zini hen orep de teipsïn-teipsïn wenya beya nik sap hlaun hup ëdwam gwe-gwek– em an desae hla kul gweꞌanye. Hwëna zen hom tol hla nul gwek. Zen man sap ësane gwen hap ëdwam gwe-gwek– em an desae ësane gwe-gweꞌanye. Hwëna zen hom tol ësane gwe-gwek. Zep em hëꞌho gwibinnike lowehe gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Musa mo tïtï tabin olsa de tawa ta gwibin zini ki zep Yesussu de akasïblïn hap hata zaka, ki zep takensïblïka, “Bian, ëe basa asa syal gwibir?– ëe dikim hëndep de gwën hap denaka gul irin hipye.” ");
INSERT INTO ury_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus ki zep hwëna takensïblïka, “Mensa Musa zëre mo tïtï tabin olak ale gulku, em banakarekame desa dam gulsuꞌura?” ");
INSERT INTO ury_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Zini in ki zep ding gulbluka, “‘Bian Alapsa em ensa lwa gweblan– tïngare enho naban, enlala naban, soson naban, hen tim niban.’ Ahana hen, ‘Zi bose omka em kwasang gwibirida gwen– san de enaka de kwasang gweblanna kiye.’” ");
INSERT INTO ury_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus ki zep ding gulbluka, “In eiwakame ding guluda. Zen kire enkam syal gwe-gwe, dekam esa hëndep denaban gwë gwera.” ");
INSERT INTO ury_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Hwëna zini in man dwam gweꞌanka– dekam de aha zi gublun hap, “Zini in eiwa aïrïs.” In zep etan Yesussu takensïblïka, “Ki ano wal bose walya endanna– ëe de desa en ensa lwabirida gwen hapye?” ");
INSERT INTO ury_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesus dekam zep desa de goltrëblan hap ola gulk sun blaonblaka, “Yahudi walya man Yerusalem kon Yeriko san dep tineꞌanka, hwëna oranak zep te-ala hap de ëasas-asas gwe-gwen zi karek dak. Kire-kirena man kïtak alal dablak– hëndep pakean mae naban, zao zep dangolek, hëndep sap-sap naka zep zë hli dak. ");
INSERT INTO ury_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hwëna ki zep hen Alap mo golak de syal gwe-gwen zini orana in san tamanꞌan zaka. Zao zep zini insa hla ta zaka, hwëna alp san lë tabla ine kïnïka. ");
INSERT INTO ury_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Etan ahana zini orana in desan song gweꞌan zaka– Lewi Bak mo ausu nakorena. Zi ausuna in sap hen Alap mo golak de syalak mas ta gwenan, hwëna kim zini insa hla ta zaka, ki zep hen alp san lë tabla ine kïnïka. ");
INSERT INTO ury_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Hwëna Samaria walya ki zep hen desan tamanꞌan zaka. Zen sap Yahudi walsya hom, hwëna kim zë zini insa hla taꞌan zaka, mam tangankam kwasang gweblaka. ");
INSERT INTO ury_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ki zep golek de ta zaka, wei-weina anggur hokam ngan tasibir-blin daka, hen minyakkam dra tan daka. Ki zep tahalebir-blika. Dekam zep zëre mo keledainak drëne seka, ki zep te-alakam de bohë ta gwen ni tan gol san dep zersong gweka– zëwe de etan mas gweblan hap. ");
INSERT INTO ury_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kaꞌankam zep gol bina in hap te-alana seratus ribu enkam golblaka, hen deban gubluka, ‘An dekam mas gwebla. Hen an de sowehen srëmkam, ëe asa lwahal zankam ep mas gulblul.’” ");
INSERT INTO ury_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesus ki zep Musa mo olsa de tawa ta gwibin zini insa takensïblïka, “Eno dam gulsunkum, zi dan-aharena in kon, nara wal bose zem makan enna lwablaka– zini in zen oranak karekna goltowekaye?” ");
INSERT INTO ury_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ki zep ding gulbluka, “Zini in zen kwasang tola ban mas gweblaka, zen zen.” Yesus ki zep ding gulbluka, “In eiwa. Zep em hen kirekam syal gwe-gwe.” ");
INSERT INTO ury_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","39","Yesus dekon kim zëre hon de ang ta gwen wenya ban golësek gweka, ënak zep yaïng gwek. Zao wenya bosena Marta oso zem Maria han Yesussu zëre nik mo gola kon eirink. Maria zen Yesus mo alp nakon nikinꞌik– dekon de zëno tawa tabinsi sane gwen hap. ");
INSERT INTO ury_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Hwëna aya zem Marta man tangan syala taha-taha gwibiꞌik– tembane maesa de syal gwibir-zimdinkim. Ki zep Yesussu gubluzak, “Bian, em ba habe zë Mariasa kara guꞌura? Ëe an zebë a-en hwëna syala taha-taha gwibiꞌin. Em gubin– asa deka mas gwibirzik.” ");
INSERT INTO ury_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bian ki zep ding gulbirki, “Marta, Marta, em ema enlalana men-san an-sankam beya gweꞌara. ");
INSERT INTO ury_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Hwëna sap dwam gwibin tanganna aha-en. Maria mes zën dawem wenyaka ïtï-tï gïlsïl, zep Ëe molyë gubik– desa de hli yun hupye.” ");
INSERT INTO ury_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Aha yaklakam Yesus Biansa gu soneblaka. Kim hya gwesïkï, ki zep hwëna zëre hon de ang ta gwen wenya in ahanik gubluka, “Bian, asa Emki hen ol gu sonensa tawa tabin– men kirekam baptis ta gwibin zini Yohanis Swe zëre hon de ang ta gwen wenya tawa ta gwibirkike.” ");
INSERT INTO ury_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesus ki zep ding gulzimki, “A kirekam em ëgu sone gwen: Bian, dikire eno bosena teip nulsuk gwek. Diki okamana awe Em hen ïrïk gïlzïn. ");
INSERT INTO ury_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Abe mae hap tembanena mwin-mwankam gol gwizim. ");
INSERT INTO ury_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ano mae mo karek-karekna ap tap gulsuzim, sap karek-karekna mensa aha zi abe mae hap nol gwizimnin, ëe ama desa eititi ei gwibirin. Hen asa de akasibiridannak bahem nwe enkam asa kara ta gwibin.” ");
INSERT INTO ury_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ki zep etan Yesus ayang gulzimki, “Hwëna emki ëenlala gwen: Eme ki ahanik wal bose uk mo gol san ngïrïn tatem song gweꞌanam– zao de abe tan hap, ‘Wal bose, abe hap tol tembanena golbla. ");
INSERT INTO ury_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ano aha ë nakore wal bosena nër hom ano golak tïlïn zala, hwëna ano tembanena hom– zëbe hap de desa golblan hapye.’ ");
INSERT INTO ury_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Hwëna wal bose om in maka ep ding gulbluꞌara, ‘Bahem asa blostablan. Lïlïkïnnï mesë solhlasïndal, hen ëe ama walas naban nisi golëtruweꞌan. Ëe molyë luwek– ebe hap de tembanesa golblan hapye.’ ");
INSERT INTO ury_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Ëe ama emsa gubiridaꞌan: Zini in sap hom anakan dwam gweꞌara, ‘Zen ano dokot. Ëe anik mas gweblak,’ hwëna eme saher ing gul sonen srëmkam aberbe ta tineꞌanam, zen hëndep dekam maka luweꞌara. Em men desae zëbon dwam gwibiꞌinam, hëndep dekam maka ebe hap golblaꞌara. ");
INSERT INTO ury_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Zen in zebë emsa gubiridaꞌan: Em Alapsa aberbe ta tine gwen, dekam sa ep golzimdi. Em teibir tine gwen, dekam esa hëndep hla kul. Lïlïkïnsï em gaꞌga so tine gwen, dekam sa ebe hap lïlïkinnï talusuk gwizimdi. ");
INSERT INTO ury_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sap zini men zen abe gwe-gwenna, zen gul irinkim. Men zen tei gwibinni, zen hlaunkum. Hen men zen lïlïkïnnï gaꞌga so gwenna, zëbe hap talusublunkam. ");
INSERT INTO ury_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ere mo tane de emsa hogwe hap abe taꞌanam, san ha emaka wanyana golblaꞌara? ");
INSERT INTO ury_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ayang sik hip de emsa abe taꞌanam, san ha emaka dare ëksa golblaꞌara? ");
INSERT INTO ury_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Em sap jal-jala, hwëna eno anakare kwasang enlalana hen ki, ‘Ëe anik dawem naka ëre mo walas hap golblak.’ Hen kirekam– nëre mae mo Bianna ngatan zi mo langnak de Zini: Desa de abe tankam Zen dawem naka gol gwizimnira, hëndep zëre mo Enhosa hen hlë ta sone gwizimnira.” ");
INSERT INTO ury_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Aha yaklakam, Yesus ol ton gwen srëm zi nikon dowalsa zeralsa soneka. Dowala in kim wet soka, zini in dekam zep ola tonka. Zi trana in zen zao lowe heꞌak man tangan denggwanblaꞌak. ");
INSERT INTO ury_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Hwëna Farisikam de zini ki zep zi trana in mo inik ëtonꞌanzak, “Zëbe hap mes dowal mo kïgïna Beelzebul Bak sosonna golblaka, in zep zëno sosonkam aha dowal-dowala zeralsa sone gwibiꞌira.” ");
INSERT INTO ury_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hen ahakon, men zen Yesussu saher tan hap dwam nëblaꞌak, zao hen lowe heꞌak. Zen zep abe dak, “Emki nglï nakore owassa ap syal gwibir-zimdin– ëe akakim emsa dam lasïk, ‘An eiwa Alap zer soneka.’” ");
INSERT INTO ury_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Hwëna Yesus mes zëno mae mo enlalana tame tazimki, ki zep ola gulk sun blaonzimki, “Aha-ere ïrïk gïn nik de hlïk-hlïk gweꞌanam, zën de ëeijaꞌanam, zen molya ëtatete gweꞌanam. Nabakam maka zënaka timbwas nuꞌin. Hen zënaka de gïl-gïl gwibiridan nakon de aha-ere golak dinik hlïweꞌanam, zen maka hëndep sekwak gweꞌan. ");
INSERT INTO ury_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Zep hen kirekam, dowal mo kïgï mo ïrïk gïn nik de hlïweꞌanam, etan zënaka de golëeijan hap, zen molya ëholo gweꞌanam. Zep Ëe dowal mo sosonkam homë dowal-dowala zeralsa sone gwibiꞌin– in kirekame asa lonsublu sanye. ");
INSERT INTO ury_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ki ahakore Farisikam de zini zen hwëna nara mo sosonkam nakasïk gwibirin?– dekam de dowal-dowalsa golëalsa sonebin hipye. Zep ere mae mo ahakorena in maka emsa anakan nenbiridaꞌan, ‘Em ema ëkarek gwer– kirekam de Yesussu tonsublunkamye.’ ");
INSERT INTO ury_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Hwëna Ëe dowala Alap mo sosonkamë zeralsa sone gwibiꞌin. Zen dekon zep anakan dam gwesïꞌïn, ‘Alap Zën de ïrïk gïlzïn hap angkam man sap kon gwisibir hanaꞌara, hwëna em ema desan de ang tan hap baes taꞌan!’ ");
INSERT INTO ury_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Sap Ëe dowal mo kïgï mo bi gwibin kire-kire dawemsaë jal zi mo kim alal ta gweblaꞌan. Zi jal-jal de zëre mo golsa kara taꞌanam– gwetap tangal inen naban, zëbe hap de jal zini na-en molya tïꞌïn zanam. ");
INSERT INTO ury_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Zini in dekam maka zënaka anakan enlala gweblaꞌara, ‘Jana ngï ben-ben hap sa asa aïrïblala.’ Hwëna zëno jal zi mo soson de taman kïnïꞌanam, zen maka golak tïlblïꞌan zala, hen maka zëno jana tanena insa alal tablaꞌara. Dekam sa jal zini in zëno kire-kirena alal tablala, hen dekam sa zëre korena kip kae gwebla-zimdi. Ëe hen kirekamë jal zi mo kim awe gwëꞌan, zebë dowal mo kïgï mo ïrïk gïn nïkon zisi alal gul gweꞌan. ");
INSERT INTO ury_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Hwëna em de Asa zerzaun srëmkam, em ema aban ërdarak gweꞌan. Hen em de Asa mas gweblan srëmkam, em ema ano syala tru-tru uꞌin.” ");
INSERT INTO ury_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesus ki zep tawa tabirki, “Dowal de totoresa zi nikon wet sonna, dekam gwana-gwana san sa hakalada gwera– zao de aha zi maenak tïn hïp. Hwëna aha maenak de tïn srëmkam, dekam sa dowala in enlala gwera, ‘Ëe asa etan ëre mo gol hli tan san dep lwahal.’ ");
INSERT INTO ury_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kim de lwa haꞌan zaka, gola insa anakan sa hla ta zala, ‘O ano ëpba gol gwë gwenna mes tangan gol bina oto tasïkï hen ngan tasïkï.’ ");
INSERT INTO ury_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Dekam sa dowala in song gwera– aha dowalsa de zëre onakon de jal-jal taman kïnïn tangan naka tuju enkam kwang guluda halzan hap. Deban kim de zini iwe golëbïtï gweꞌan zaka, zini in mo gwënna dekam tangan sa karek gweblal– nonol gwën nakonye.” ");
INSERT INTO ury_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesus kim kirekam gubiridaka, wenya ki zep mamkam gu anek, “Wenya men zen emsa jaha gwek hen momkam taïzï gwek, zen eiwa hëꞌho gwibin nika hlauk.” ");
INSERT INTO ury_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ki zep ding gulbirki, “Sap eiwa, hwëna diki zini men zen Alap mo ola ësane gwe-gwenan hen syal nei gwibirin, zen zen hëꞌho gwibinnik lowehe gwenan!” ");
INSERT INTO ury_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Zi trana kim etan ëmas-mas gwe-gweꞌanzak, ki zep etan ayang gulzimki, “Angkam de zini em eiwa jal-jal tanganna. Em hwëna owassa de ebe mae hap syal gwibir-zimdin hibe Asa aberbe la gwenan. Hwëna angkam bëjënë syal gwibir-zimdin. Diki ngein sin de yaklanak asa aha-en syal gwibir-zim: Men kirekam Yunus hon lwakke. ");
INSERT INTO ury_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","In kirekam owasna ë yala Niniwek de zi hip Yunus Bak hon lwakke, orapna dan-ahan de hogwe ungala mwanak gwënkam, ngatan zi mo lang nakore Zi Tanganna Abon hen kirekam sa owasna lwal– angkam de zini em de hen hlaun hupye. ");
INSERT INTO ury_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Alap de aumwa hap angkam de zini emsa klis gunnuk, selatan kore teipsïnkïm de wenya in, zen sa hen olsa de mas gun hup zaul– men zen orep teipsïn zini Salomo Baksa duwebla zakke. Zen dekam sa anakan emsa swrë tabir, ‘Ëe ama langa en nakon Salomo mo enlala blala kore olsa de sane gwen hap hatak. Hwëna ebon mae onak kim ngatan zi mo lang nakore Zi Tanganna hataka, em hwëna ema asalsïk gweblak.’ ");
INSERT INTO ury_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Hen kirekam, Alap de aumwa hap angkam de zini emsa klis gunnuk, dekam Niniwek de zi mo angna sa olsa de mas gun hup ëzaul. Zen dekam sa emsa anakan swë dabir, ‘Yunus Bak kim ëhalen hap de ola ban abon mae golhataka, ëe dekam ama ëhalek. Hwëna ebon mae onak kim ngatan zi mo lang nakore Zi Tanganna ëhalen hap de ola ban golhata zaka, em hwëna ema ëhalen hap baes tak.’” ");
INSERT INTO ury_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesus Zen kirekam ola gulk sun blaon gwizimki, “Zini hom pelita ngatannak yuna utuk nul sone gwenan– dekam de ngatanna insa aning gun hupye. Zen diki meja maenak nonne gwenan– dekam de ngatannak zïnï zi niban golëteinikirin hipye. ");
INSERT INTO ury_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nwena zen tim hip de lïlïkïn– enho dikim ngatan gwen hap. Nwe nik de lalak nënna, dekam enhona hen ngatanna. Hwëna nwe nik de haï nënna, enhona hen kawesïn tanganna. ");
INSERT INTO ury_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","In zep nwekam dawem enkam em ëkara gwe-gwen. Eno mae mo ngatanna in mana kawesïn hïp jowenank. ");
INSERT INTO ury_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Enlala kawesïn srëmkam de enho ngatan gwenna, eno gwëhan san dekam ngatan en sa lwa gwer– lampu de zïl inen makan.” ");
INSERT INTO ury_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus kim aïsïl tonbiridanna golzausuku, Farisi walya ki zep zëno golak de golëtembane tan hap abe taka. Yesus ki zep golëbïtï gweka– zao de tembane tan hap. ");
INSERT INTO ury_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisi walya in man zë Yesussu tenggwanblaꞌanka, sap Zen hom tembane gwen hap de nonol tahasa su tazimdin sin ang gweꞌanka– men kirekam Yahudi mo auyan-aza mo ëpba olak lwakye. ");
INSERT INTO ury_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Hwëna Bian Yesus zep ding gulbluka, “Eiwa, em an Farisikam de zini eno mae mo lowe henna mae makan: San de zi de piring-moksa ë-en nakon ngan tasïk gwibinni, hwëna olk san bëjen. Ere mae mo timni hen kirekam. Em sap ema tahan sopna ngan lasïk gwibirin, hwëna olk kon eno mae mo enhona mes beya gweka– kire-kire beya gwen hap de hole-hle enlalakam hen jal-jal enlalakam. Em ema desa de hen ngan tasïn hïp baes taꞌan! ");
INSERT INTO ury_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Em an eiwa enlala joblo-top tanganna! Alap mes ki syal gwibirki– tahan nakon dep dena insaye. Hen olk kon dep dena mes syal gwibirki. Desa hen man kara gulzimꞌira. ");
INSERT INTO ury_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","In zen eno mae mo enhonak kire-kire beya gwen hap dena lwaꞌan, desa eititi eibik. Dekam ere mae mo kire-kirena tahalha wenyaka kim kae eibiridak. Zen dekam sa eno mae mo timni hëndep enho naban Alap mo nwenak ëngan gweher. ");
INSERT INTO ury_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Farisi zi, kwasang tol! Em ëngalap gwen, sap em karekna mam wenyaka esa oltower. Em sap ema nganak de kire-kire betekna Alap hap de hlïkna ol gweblanan, hwëna Alapsa de ensa lwablanna hen zi bose omka de dawemkam golëlowe henna, desa ema eititi ei gwibirin. Zen diki zen– bol-zaun tangan wenyaye. Zen diki nonol desa emaka syal ei gwibirin. Zao etan nganak de kire-kirena insa lun em hen mas gul gweblan. ");
INSERT INTO ury_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Farisi zi, kwasang tol! Em ëngalap gwen, sap em karekna mam naka esa hla kul. Em but srëm gol-golak ngeinnik de komal tum dawemnak de teinikirin hibe ëdwam gwe-gwenan. Hen em ema ëdwam gwe-gwenan– zi de tagal gwen maenak anakan emsa gubirida gwen hap, ‘Dawem, bian guru.’ ");
INSERT INTO ury_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Em karekna mam naka esa hla kul. Em in men kiye– gol taublun srëmkam de zi tok drë nwanunna. Desan de zi song gwenna, dekam bëjen tame gun, ‘Ëe zi tok tahan sanë zauk ane kïnïl.’ Zep em hen kirekam. Zini man emsa tim di gwibirin, ‘Zini an dawemna,’ hwëna enhona ase naban.” ");
INSERT INTO ury_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Dekam zep hwëna Musa mo tïtï tabin olsa de tawa ta gwibin zini gubluka, “Bian, insa kirekam Farisikam de wenya jalse gwibiridala, in asae hen lamang tabirida!” ");
INSERT INTO ury_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesus ki zep hwëna ding gulbluka, “Kwasang tol, em hen Musa mo tïtï tabin ol tawa ta gwibin zini! Em ëngalap gwen, sap em hen karekna mam naka esa oltower. Eno mae mo tawa tabinni man nwe-mase gwe-gwenan– san de zi de aha zi hip nihin dohon-honsa mam enkam wëwek ta sone gwizimdinni kiye. Sap em ema Musa mo tïtï tabin olak etan ere mae mo aha tïtï tabinsi mas-mas ul zahe gwenan, zep tangane hëndep dohon-hon la gwibirin. Ena hwëna home desan ang ta gwenan. ");
INSERT INTO ury_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Em ëngalap gwen, sap em karekna mam naka esa hla kul. Sap em in zi tamera gwen zi mo wei-wik gun walas! Eno auyan-azana Alap mo olsa de ayang gul gwizimdin hip de zini man damera gwek. Em hwëna angkam desa de lo tasïk gwibin golsae sam-sam la gwibir-zimꞌin. ");
INSERT INTO ury_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hwëna em insa kirekam syal ta gweꞌan, zen man nwe-mase gwe-gweꞌan– san de auyan-aza oban de anakan enlalasa siri tanna kiye, ‘Em sap esa lamera gwer. Ëe asa hwëna lo lasïk gwibir.’ ");
INSERT INTO ury_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Zen in zep Alap zëre mo enlala blalkam guku, ‘Ëe asa ëre mo olsa de ayang gul gwen hap de zisi lup gul sone gwizim. Ahakon sa karek da gwibir, hen ahakorena sa damera gwer.’ ");
INSERT INTO ury_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Zen in zep sa Alap angkam de zini ebe mae hap karekna sërkam golzimdi– kïtak de zëno ol ayang gul gwen zisi de tamera gwen hap de karekna, nonol lonesen nakon hëndep angkam dena. Nonol lonesen nakon kim Kaen Bak Habelsa taka, dekon hëndep eno auyan-azana Alap mo ol ayang gul gwen hap de zini man damera gwek, hëndep aumwa hap Zakaria Baksa Alap mo gol mwanak dak. Zen Alapsa de aïrïblan srëmkam Alap hap de tweran nin ang gulsuk gweblan kals alpnak dak. Ëe ama emsa gubiridaꞌan: Kïtak de zi tamera gwen karekna insa Alap mes lam gulku– dekam de otan ere mae hap ngëro gulzimdin hip! ");
INSERT INTO ury_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Musa mo olsa de tawa ta gwibin zini, em ëngalap gwen, sap em karekna mam naka esa hla kul! Em sap Alap mo nwenak dikim ësam gwesïn hïp de orana tawana, hwëna em home desan ang ta gwenan. Hen zini men zen sap desan de ang tan hap ëdwam gwe-gwenan, hwëna eme zëbe mae hap orana layalsïk gwizimnin.” ");
INSERT INTO ury_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Hëndep dekon, in kim lwasek, dekam zep Musa mo tïtï tabin olsa de tawa ta gwibin hip de zi niban Farisikam de gubirida gwen zi niban zi tra mo inik Yesussu sërkam donsuk gweblaꞌak. Hen dekam zep u siweblan hap dakensïblï tine gwek– ");
INSERT INTO ury_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","anakare enlala naban, “Zëno ol-gun mae de karek gweꞌak, dekam esa klak lal.” ");
INSERT INTO ury_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Dekam zini mes ribu-ribukam Yesussu tagal nëblazak hen ngïrïn daꞌak, hëndep man zë zënaka nyaubirida gweꞌak. Dekam zep nonol zëre hon de ang ta gwen zi ensa gubiridaka, “Dawem. Ema Farisi zi mo ëk enkam de tawa tabin sin ang tanank. Zëno mae mo karekna in, zen ragi makan mam gwe-gwenan. ");
INSERT INTO ury_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mensa zini ber-ber nul gwenan, zen sa lamkam wet sol. Mensa enlalana aning da gwenan, zen sa lamkam tame dal. ");
INSERT INTO ury_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Em mensa angkam kawesïnnïk lon gwibiꞌin, zen hwëna lamkam yaklam sa ësane gwe-gwer. Hen mensa gol mwanak i mwa ennak lon sonebirida gweꞌan, zen hwëna lamkam ënak sa ol mam-mamkam donbirisen gwer.” ");
INSERT INTO ury_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Wal bose wal, zi bose omka bahem aïrïbirida gwen, sap zen auhu-kama tim en naka damera gwenan. Hwëna tan hyanak bëjen emsa etan karek tan. ");
INSERT INTO ury_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Hwëna Ëe ama emsa gubiridaꞌan: Diki Alap ensa em aïrï gweblan. Sap zen zëno dena– tan hyanak de syauk blanak emsa tak ta irin hip denaye. Zep eiwa, zen diki Desa en em aïrï gweblan. ");
INSERT INTO ury_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Emki mawana taïnïm bes-bessa enlala gwibiridan. Desa zini hom te-alakam de kap tan hap dwam neibirida gwenan. Sap eiwa kirekam, hwëna Alap bëjen aha-en mae desa hen eititi gwibiridan. ");
INSERT INTO ury_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hen kirekam, eno mae mo nol alana, Bian Alap mes desa anakan tawa gwibirki, ‘Beyana ki en.’ In zep ere mae mo tim hip dena bahem ëngalap gwe-gwen, sap em Alap mo nwenak mawana taïnïm bes-bes naban apdenak hom.” ");
INSERT INTO ury_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ëe ama emsa gubiridaꞌan: Zini men zen aha zi hon zënaka anakan kira ta gwenna, ‘Ëe an Yesussu de ang gwe-gweblanna,’ kire zini Ëe asa hen Alap mo dam taha nakore zinik anakan kira tal, ‘Zen an hen eiwa Asa de ang gwe-gweblanna.’ ");
INSERT INTO ury_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Hwëna zi de aha zi hon Asa anakan nazabeblaꞌak, ‘Ëe Yesussu de ang gwe-gweblan zisi hom,’ ki Ëe asa desa hen aumwa hap de zisi klis gunnuk Alap mo dam taha nakore zinik anakan kira tal, ‘Zini an Asa de ang gwe-gweblan zisi hom.’ ");
INSERT INTO ury_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ngatan zi mo lang nakore Zi Tanganna Asa de zi lamang taꞌanka, karekna insa Alap maka zëbe hap tap gulsubluꞌara. Hwëna zi de Alap mo Enhosa lamang tankam, desa Alap bëjen tangan tap gulsublun. ");
INSERT INTO ury_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Emsa sa dahyo gwer– Yahudi mo but srëm golak de mam-mam wenya kip de golëtrei gwizimdin hip, hen auhu-kamanak de teipsïn-teipsïn wenya kip. Anakan sa emsa nolëtrei gwizim, ‘An Yesus hon de ang ta gwen zi.’ Kirekam de ebon mae lwankam, dekam bahem anakare hap enlalana ëbeya gwe-gwen, ‘Ëe banakarekam asa zë ton hen ding gulzim?’ ");
INSERT INTO ury_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sap emsa de taken-taken gweblan ennak sa ki Alap mo Enho ebe mae hap gol gwizimdi– em de kirekam ëton gwen hap denaye.” ");
INSERT INTO ury_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ki zep zi beyana in kon ahanik Yesussu gubluka, “Bian, emki ano ayasa gublun– zen de bian swe mo kire-kire hli tan dansa abe hap hlï tablan hap.” ");
INSERT INTO ury_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesus ki zep ding gulbluka, “Asa hom ki nenblak– mam zi mo kim de bian swe uk mo kire-kiresa ep klis gulzimdin hipye.” ");
INSERT INTO ury_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ki zep etan tïngare zi hip ayang gulzimki, “Dawem. Banakare kire-kiresa de hole gwibinni, zen zen sa emsa karek tabir. Sap eno mae mo lowe henna, zen kire-kire beya ennak hom lwa gwenan.” ");
INSERT INTO ury_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesus ki zep ola gulk sun blaonzimki, “Orep ki zini gwë gweka. Zëno kire-kirena beya tanganna. Zëno kamanak mulkwan maena dawemkam hata gweka. ");
INSERT INTO ury_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ki zep zëre en hap enlala gweka, ‘Ano nga nakore kire-kire kang ta gwen gol-gola an yak-yak naka hom– dekam de ëre mo mulkwan maesa zë kang ta gwen hapye. Ëe banakan asa syal gwibir?’ ");
INSERT INTO ury_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ki zep etan enlala gweka, ‘O angkam mesë dam gulsunun. Ëe asa ëre hon de syal ta gwen wenyaka gubiridal– kire-kire kang ta gwen gol-gola ansa de wet tyasibin hip. Dekam ahasa sa mam-mamkam daublul– zëwe de kang ta gwen hap.’ ");
INSERT INTO ury_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Zen dekam asa enlala gwer, ‘Ëe an hëꞌho gwibin nika de goltowe gwen zi. Ëe dekam na-en molyë tahalha gwek. Angkam sap asa sëwe henkam gwë gwer. Tembane dërek-dëreksa asa twin gwibir, hen ho dëreksa asa otde gwer, hen ëre mo gwënna asa nga-ngol gwibir.’ ");
INSERT INTO ury_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Hwëna Alap dekam zep gubluka, ‘Em enlala joblo-topna! Namen mo kam dekam Ëe asa hwëna eno angna zersïl. Hwëna dekam eno kire-kirena mensa ere en hap lam taka, aha zi sa bi nëblandal.’” ");
INSERT INTO ury_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ki zep etan Yesus aumwa hap gubiridaka, “In kirekam sa lwa gwer– zini men zen auhu-kamanak zëre en hap kire-kirena kang da gwenanye, hwëna zen hom hëndep de gwën hap de kire-kire dikim Alap mo nwenak ëbeya gwen hap syal ta gwenan.” ");
INSERT INTO ury_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesus ki zep hwëna dua-blaskam de zëre hon ang ta gwen wenya in en hap ayang gulzimki, “Zen in zebë emsa gubiridaꞌan: Bahem anakan ëngalap gwe-gwen, ‘Ëe banakan asa gwër? Ëe basa asa twin gwibir? Hen ëe basa asa ala so gwer?’ ");
INSERT INTO ury_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sap eno gwënna zen tembane en nakon hom lwa gwenan, hen timni ala so gwen hap de en nakon hom lwa gwenan. ");
INSERT INTO ury_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Emki mawana blensa enlala gwibiridan. Zen hom ba maena eiyas nïl gwenan, hen hom dan gwenan. Hen zëno mae mo tembane kang gul gwen gola hom. Hwëna Alap ki zëbe mae hap tembanena gol gwizimnira! Zep em bahem ëngalap gwe-gwen, sap em Alap mo nwenak mawa mo kim hom. ");
INSERT INTO ury_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Em de ere mo gwën hap ngalap gwenkam, san ha em emaka ere mo gwënna insa engka en mae langa gulsuꞌura? Bëjen. ");
INSERT INTO ury_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Em de enlala nik ëbeya gwe-gwenkam molye ere mo gwënna betek en maekam ayang ul ine gwek. Ki ba hap de enlalana beyam-bya gwen hap?– ala son hap de kire-kire hap, hen tembane mae hapye. ");
INSERT INTO ury_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Emki sap sona ok eissi enlala gwibiridan. Zen hom syal ta gwenan, hen pakeanna hom dayal gwibirin. Hwëna Ëe ama emsa gubiridaꞌan: Sap teipsïn zini Salomo Bak, zen hwëna hom ok eis nwe-awes makare pakeanna akeka– desa de zëre mo te-ala beyakam teisyan hapye. ");
INSERT INTO ury_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Em in Biansa de taïblïblanna tawa naka hom! Ok eis mo ëhultunnu tïhïs tanganna, sap zen namen de ënwe-awes gwenkam, hwëna kaꞌan de ëjek-jak gwen. Zen sap eiwa kirekam, hwëna Alap ki desa kara ta gwibirida. Zep emki Biansa anakan taïblï gweblan, ‘Zen molya asa ala so gwen hap denakim da tasïkï.’ ");
INSERT INTO ury_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Zep bahem anakan enlalana ëbeya gwe-gwen, ‘Ëe basa asa twin gwibir hen otde gwibir?’ Bahem banakare mae hap ëngalap gwe-gwen. ");
INSERT INTO ury_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sap Alapsa de tame tan srëm zini zen kirekam ëngalap gwe-gwenan. Hwëna nëno mae mo Bianna Zen anakan tawana, ‘Ano walasna kire hap ëtahalha gweꞌan.’ ");
INSERT INTO ury_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Hwëna em Alap de nabakam ïrïk gïlzïn hap denaka em syal gwe-gwibin, ki Zen sa hen ebe mae hap eno tahalha gwibinni gol gwizimdi. ");
INSERT INTO ury_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Em in zen dan en Abon ang ta gweꞌan, bahem ëaïrïn, sap eno mae mo Bianna man emsa sam gwesibiridaꞌara– em de zëno ïrïk gïnnïk bïtï gwen hapye. ");
INSERT INTO ury_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ere mo bi gwibin kire-kirena te-ala hap em lirak tabin. Te-alana desa tahalha zi hip em kae gwebla-zimdin. Dekam em dakal hap de kire-kiresae lam taꞌara, hen kire-kirena in molya ep ëjek-jak gweblak. Ngatan zi mo langnak em lam tan, sap zëwe sowë zi molya kap dak, hen winimni molya dwenblandak. ");
INSERT INTO ury_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sap men zëwe eno kire-kirena ërlwa gwenna, eno enlalana hen zëwe sa lwa gwera.” ");
INSERT INTO ury_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Em salok-salokkam em lowehe gwen– Asa de hut tu ane gun hupye. Em zep em pakean alala tan naban hen syauk ngatan naban Asa kara gwe-gweblan. ");
INSERT INTO ury_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Men kirekam babu gwen zini mam zemka kara në gweblananke, zen de we-zi daresa de oto son nakon lwahal zannak, em hen kirekam em lowehe gwen. Mam zini in kim de hataꞌan zaka, lïlïkïnsï sa gaꞌ-ga so zala. Dekam sa hëndep dalusublul. ");
INSERT INTO ury_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Zen de babu zem insa nama de salok-salokkam de ës gweblannak hlauluda zankam, dekam sa tangan sam gwesibiridala. Ëe eiwa denakaë emsa gubiridaꞌan: Mam zini in dekam sa babu gwen zi makan zënaka gwëblala. Dekam sa zën zëbe mae hap tembane dëreksa syal gwibir-zimdi. Ki sa teinikirin hip gubiridala– zao de golzimdin hip. ");
INSERT INTO ury_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Zen de ngïrïn anen mae hatankam, nama de salok-salokkam de ësblannak hlauluda zankam, ki zëre hon de babu gwen zini in hëꞌho gwibin tangan naka sa hla nul. ");
INSERT INTO ury_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Emki sap ëenlala gwen: Gol bi nik de anakan tawa gweꞌanam, ‘Ano golak sowë zini namen mo kam sa tïl zïla,’ zen dekam molya nini taꞌanam. Sowë zini in de tïlzïn srëm hap maka saleꞌara. ");
INSERT INTO ury_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Zen in zep, em hen kirekam salok-salokkam lowehe gwek, sap em home tame uꞌin– ngatan zi mo lang nakore Zi Tanganna Ëe de lwa halzan hap denaye.” ");
INSERT INTO ury_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petrus ki zep takensïblïka, “Bian, ola insa gulk sun blaonzimdi, san ha abe mae en hap? San ha hen tïngare zi hip?” ");
INSERT INTO ury_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ki zep ding gulbluka, “Ebe mae hap dena, zen aïsïlï a kirekam sa lwal: Teipsïn zi nik de holokam langa san song gweꞌanam, zëre hon de babu gwe-gwen zini men zen de enlala blalkam gwëꞌanam hen taïblïblan nik, zen zëbe hap maka syala anakan wei yul sone gublu haꞌara, ‘Ano tim bwanak babu gwe-gwen bose omka em ïrïk gïl gwe. Zëbe mae hap tembanena hen sowe henkam gol gwizim.’ ");
INSERT INTO ury_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Teipsïn zini in de mumuk ennak lwahal zankam, zen de anakan hla taꞌan zanam, ‘Zen dawemkam ano tim bwanak ïrïk gïl gweka,’ ki zen sa zëbe hap isrip-sri gwibin nika golblala. ");
INSERT INTO ury_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Eiwa denakaë emsa gubiridaꞌan: Teipsïn zini in dekam sa zëno bosena esek gul seblala, hen zëre mo kire-kiresa de kïtak kara ta gwibin hip sa gublula. ");
INSERT INTO ury_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Hwëna babu gwen zini in de anakan enlala gweꞌanam, ‘Ano teipsïnnï in na-en molya lwahal zaka,’ zen sa hwëna ahakore babu gwen bose zemka tangole gwibiri– sap zi, sap we. Hen zi bina in mo te-alakam zë-en sa tembane gwe-gwera, hen ho mamaksa sa kim otdeblanda gwera, dekam sa hëndep mamak gwera. ");
INSERT INTO ury_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ki sa hwëna mumuk ennak babu gwe-gwen zi karekna in mo tame gun srëmnak teipsïn zini in hata zala. Dekam sa tok hap zïp so zala. Hen zëno angna dekam sa tak ta iri– men zëwe Biansa de taïblïblan srëm wenyik mo angna lowehe gweꞌanke. ");
INSERT INTO ury_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Babu gwe-gwen zini men zen mam zik mo dwam gwibin sin anakan tame gunnu, ‘An ano syala zen,’ hwëna zen de zënaka hohle tan srëmkam hen syal gwibin srëmkam, ki mam zini in de hatankam desa sa mamkam de lek-lek tan hap gubiridala. ");
INSERT INTO ury_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Hwëna babu gwe-gwen zini men zen mam zik mo dwam gwibinsi tame gun srëmna, desa betekkam de lek-lek tan hap sa gubiridala. Ebe hap de mamkam hli tablankam, zen hen aumwa hap mamkam de goltrëblan hap sa emsa gublula. Ep de beyakam hli tablan dankam, ki hen beyakam de goltrëblan hap sa emsa gublula.” ");
INSERT INTO ury_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ëe an okamanak de zisi de klis gun hubë hatazak. Ano klis gunnu zen syauk makan sa tïngare zini neisbir. Hen Ëe ama dwam gweꞌan, nabakam bae ki syauknu in hïtïꞌïnam! ");
INSERT INTO ury_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Hwëna nonol Aen asa karek yawala goltower. Ëe dohon tangan nakaë eis gwibiꞌin– desa de goltowen hapye. ");
INSERT INTO ury_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Bahem anakan Asa kïl tï gwen, ‘Zen an umlaesa de okamanak awe golhatazan hap hata zaka.’ Ëe kire hap homë. Hwëna abe hap de jal hap Asa de tame tan srëm wenya sa emsa gïl-gïl neibirida gwer. ");
INSERT INTO ury_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Zep angkam ebon mae a kirekam sa lwa song gwer: Aha-ere golak de zi aha-ere taha-tapkam lowe heꞌanam, hwëna Abon onakon esa enaka gïl-gïl eibirida gwer. Anakarekam sa lwa song gwer: Dan-ahan men zen Abon ang ta srëm gwe-gweꞌan, zen hwëna dan-dan dena emsa sa gïl-gïl nei gwizim. ");
INSERT INTO ury_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ebon mae onakon, abe hap de jal hap walas oban esa enaka gïl-gïl eibirida gwer– sap zikim dena hen wekam dena, hen sap aebo wal maekam dena.” ");
INSERT INTO ury_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesus ki zep gubiridaka, “Yakla de kaknak sal-sal gwe zanna, dekam ema dam ulsuk gwenan, ‘Sa o dïl gwer.’ Hëndep kirekam sa ki lwal. ");
INSERT INTO ury_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yakla de but-som but-som gwe zanna, dekam ema dam ulsuk gwenan, ‘Sa sasa gwer.’ Hëndep kirekam sa ki lwal. ");
INSERT INTO ury_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","O de ïl tï gwen hap dena hen sasa gwen hap dena, em desa en ema dam ulsuk gwenan. Zep em ba habe ano owas-owas syal gwe-gwibinni dam ulsuk srëm gwe-gweꞌan? Em in eiwa enlala joblo-top tanganna. ");
INSERT INTO ury_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Em ba habe anakan dam ulsuk srëm gweꞌan?– ‘Diki angkam ëe amaka kirekam syal eibiꞌin.’ ");
INSERT INTO ury_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Eme mamkam te-ala beya zi nik bon gweꞌanam, hwëna otan de desa ber-ber gun srëmkam, zen hwëna emsa de balk tahan hap maka jana nabare wenyak zerguꞌura– zen de teipsïn zi sin dep emsa zerhan hap. Diki dawemna, zen de nama emsa teipsïn zinik zerhatan srëmnak, emki anakan de zersësek gwen hap akasïblïn, ‘Bahem na-en asa zertrëblan. Ëe basa asa ep golblal?– dekam de eban sësek ën hapye.’ Kire srëmkam, ki zen sa hëndep teipsïn zini in hap emsa zertrëblala. Hen teipsïn zini in sa zëre mo jana nabare zi hip emsa zerzimdi– zen de hwëna bwinak emsa tayalsïn hïp. ");
INSERT INTO ury_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ëe ama emsa gubiridaꞌan: Em bëjen em dekon wet son– bonna insa de tïngan ber-ber gun srëmkamye.” ");
INSERT INTO ury_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Zao kim nama lowe heꞌak, ki zep Yesussu donblaꞌak, “Teipsïn zini Pilatus man zëre mo jana nabare zisi gubiridaka– Galilea kore zisi de tameran hap. Hëndep Alap mo golak zep damerak. Maenak damerak: Zen kim dombana Alap hap blom dabir-bliꞌakke. Hëndep zëno mae mo kala domba kala in han zep siri nëk.” ");
INSERT INTO ury_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesus ki zep ding gulzimki, “Sap Galilea kore zini in kirekam karek yawala noltowek, em san ema kïl lïbiꞌin?– ‘Zëno mae mo karekna man tangan taman kïnïk– ahakore Galilea kore zi nikonye. In zep Alap kirekam de karek tabin hip gubiridaka.’ ");
INSERT INTO ury_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Hwëna kirekam hom. Ëe ama emsa gubiridaꞌan: Em de ëhalen srëmkam, em hen zëno mae mo kim de juwensa esa hla kul. ");
INSERT INTO ury_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Hen kirekam, in kim delapan-blaskam de zini klibu nabare gola Siloamk kei-king gulku, em san ema desa hen kïl lïbik?– ‘Zëno mae mo karekna man tangan taman kïnïk– tïngare ahakore Yerusalemk de lowehe gwen wenya konye. In zep Alap kirekam de karek tabin hip gubiridaka.’ ");
INSERT INTO ury_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Hwëna kirekam hom. Em de ëhalen srëmkam, em hen zëno mae mo kim de juwensa esa hla kul.” ");
INSERT INTO ury_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesus ki zep ola gulk sun blaonzimki, “Zini zëno anggur ngana ki. Zao hen kwiwena man saltïk. Ki zep song gweka– kwiwe dansa de taran hap. Hwëna eini aha-en mae hom hlaulku. ");
INSERT INTO ury_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ki zep nga syal gwe-gweblan zini insa gubluka, ‘Ëe mesë tahunna dan-ahan gwek– sap de duwe gwibir zinna. Hwëna homë mae ei niban hlaulzuk. Em lwin. Waba hap bap zen zë zaun. Ahasa neik zë etan ïk ïk.’ ");
INSERT INTO ury_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Hwëna ki zep nga syal gwe-gweblan zini in ding gulbluka, ‘Dikire tahunna an ensa zauk. Ëe asa zëno alp nakon kamasa tri yul, zao asa te bitriskim yaïng tabir. ");
INSERT INTO ury_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Dekam wëhë ngein sin de tahunkam tëꞌak. Tën srëmkam dekam neik ulek.’” ");
INSERT INTO ury_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Aha Hari Sabatnak kim zauk, dekam zep Yesus Yahudi mo aha but srëm golak tawa tabirki. ");
INSERT INTO ury_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Zao wenya ki, dowal mes sang-sangna golbirki– tahunna delapan-blas enkam. Dam-damkam bëjen zaun. Tahanna mes tïwehek. ");
INSERT INTO ury_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesus kim hlaulku ki zep takenbirki, “Anyan, haen. Ëe ama emsa sang-sangna in kon hïl gïl soneꞌan.” ");
INSERT INTO ury_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ki zep tahana tehabir aneka, hëndep dekam zep dam-dam gwesek, dekam zep Alap hap dawemna golbla tineꞌak. ");
INSERT INTO ury_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Zëwe de but srëm golak de mamna ki zep jal gweblaka, sap Zen Hari Sabatkam dawem gulku. Ki zep gubiridaka, “Yaklana enam enkam– syal tan hap denaye. Zen dekam yaïng gwe-gwezak– zi sang-sangsa dikim dawem ta gwibin hipye. Hari Sabatkam bahem.” ");
INSERT INTO ury_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bian Yesus ki zep hwëna ding gulbluka, “Em Alap mo bosena ëk enkame zigwiren gweꞌara! Em kïtak Hari Sabatkam sapi zahona kie hïl lï sone gwibirin– weyasa dikim otdebin hipye. Keledai zahona hen kirekame eibirida gwenan. ");
INSERT INTO ury_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","An hwëna zahosa hom. An hwëna Abraham mo auyan-tane sake. Desa mes delapan-blas tahunkam dowal mo kïgïna huleka. Ëe sap asa Hari Sabatkam hïl gïl soner!” ");
INSERT INTO ury_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesus insa kirekam ding gulbluka, men zen Zënaka jal nëblaꞌak dekam zep tangan ësaher gwek. Hwëna tïngare ahakore zini man tangan ëisrip-sri gwek– insa kirekam owas-owasna syal gwe-gwibirkike. ");
INSERT INTO ury_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesus a kirekam mo ola gulk sun blaon gwizimki, “Ba naban esa apde osol?– dekam de Alap mo ïrïk gïn hïp denaka gulk sun blaonzimdin hipye. Alap mo ïrïk gïn nïban ba naban esa enlala eizim?– dekam de srip gulsuzimdin hipye. ");
INSERT INTO ury_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Alap mo ïrïk gïn nïka de srip gulsuzimdin hip, zen a kirekam moye: Zen rica dan makan. Zen sap betek tanganna, hwëna zini kim desa nganak ïk nïl gwenan, dekon zep ësaltïl gwenan, hëndep te makan zep ëmam-mam gwe-gwenan. Mawana zao zep zëno hli-hlinak gola dauk gweblanan.” ");
INSERT INTO ury_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Aha gulk sun de ol blaonzimdinni hen anakan, “Alap mo ïrïk gïnnï, zen ragi makan. Wenya man tepungna aha-ere sak naka mang-mang guk. Zao zep ragisa betekkam mas guk. Ragina in sap betek tanganna, hwëna dekam zep rotina in dawemkam hop gwek.” ");
INSERT INTO ury_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesus kim Yerusalem san song gweꞌanka, Zen man ë-ë san tawa tabir song gweka. ");
INSERT INTO ury_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kim zë tawa tabiꞌinka, ahanik zep takensïblïka, “Bian, san ha zini dan en sa ëngaya gwer?” Yesus ki zep ding gulbluka, ");
INSERT INTO ury_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Emki lïlïkïn klakat san de bïtï gwen hap ëalp gwen, sap zen zen– ëngaya gwen hap de ora naye. Yak zini zen desan dep denaka hom. Ëe ama emsa gubiridaꞌan: Zini beya nik sa sap Alap mo ïrïk gïn kon gwisibir hanan tembane yala iwe dep ora yakna in san ëalp gwe-gwer. Hwëna desan molya zëwe dep bïtï gwek. ");
INSERT INTO ury_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ang tan wenya kim de sowe heꞌak, Gol Bina in dekam sa lïlïkïnnï sohlasïk iri. Ë en nakon esa tol ëzaul. Sap esa gaꞌga oso gwer– anakare ola ban, ‘Gol Bina, abe mae hap tol Emki lïlïkïnnï ansa talusuzimdin.’ Hwëna Zen sa emsa gubiridala, ‘Ëe homë emsa tame tabiꞌin. Em in enda kore zisi mes yap?’ ");
INSERT INTO ury_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Hwëna em esa ding ulblir, ‘Hwëna ëe mesë eban ërtembane gwe-gwek hen em mes em-am ano mae mo ënak tawa ta gwibirki.’ ");
INSERT INTO ury_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Hwëna Gol Bina in sa etan ding gulzimdi, ‘Ëe homë emsa tawa gwibiridaꞌan– em enda kone yaïng gwezal. Em sek gwen. Em in zene karekna ol gwenan.’ ");
INSERT INTO ury_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Em kime anakan hla kulidaꞌak– Abraham, Isak, Yakob, hen tïngare Alap mo olsa de ayang gul gwen zini, ‘Zen Alap mo ïrïk gïnnïk lowe heꞌan, hwëna asa mes ë san yal nulin,’– em dekam esa yusyustïn nïban gona tal, hen ëkna dekam esa ngalap hap ngalk-ngalk la gwibir. ");
INSERT INTO ury_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Sap dekam zini yakla hata sezan nakon sa yaïng gwer– hen nikin anen nakon, hen eihya-lip eihya-lip nakon, Alap mo ïrïk gïn kon gwisibir hanan tembane yawalak de apdekam ëisrip-sri gwen hap. ");
INSERT INTO ury_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Hwëna emki ëenlala gwe-gwen: Men zen angkam bose srëm wenya ëgwëꞌan, zen zen sa hwëna lamkam ngein sin loweher. Hwëna men zen angkam bose naban lowehe gweꞌan, zen hwëna lamkam zen sa lure san ëgwër.” ");
INSERT INTO ury_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","In kim lwa seꞌak, ki zep Farisikam de zini Yesussu nenblazak, “An kon song gwe. Herodes man emsa tan hap dwam gweblaꞌara.” ");
INSERT INTO ury_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesus ki zep ding gulzimki, “Em sek gwen. Anakan wanya jal-jala insa enblak, ‘Zen man guku, “Ëe nama dowalsa golëalsa sone gweꞌan, hen zi sang-sangsa dawem ta gwibiꞌin. Hwëna molya holo gwek, ki asa ëre mo syala ansa tap gul soner.”’ ");
INSERT INTO ury_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sap Ëe molyë awe holo gwek. Sap hom dakastïꞌïn Asa de aha ënak tankamye, sap Alap mo olsa de ayang gul gwen hap de zini zen Yerusalemk en damera gwenan.” ");
INSERT INTO ury_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yesus hen anakan guku, “Yerusalemk de zi, em mese Alap mo ol ayang gul gwen zini beyakam lamera gwek, hen Alap mo lup gul sonen zini kasokame ï lïbirida gwek– hëndep tok hap. Ëe ama sap emsa kwasang gwibirida gwek, zebë sap emsa Ëre osan dep de tagal gulsun hup akabirida gwek– san de we ayang de tane-ne zemka sï alakam obon gun makan de gweibiridan hap. Hwëna em ema baes ta gwek. ");
INSERT INTO ury_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yerusalemk de zi, zen in zep Alap angkam emsa da tasibiꞌira. Ëe ama emsa gubiridaꞌan: Em molye na-en Asa tame lak. Hwëna kime Asa hut lu ane guꞌuk, zen dekam en esa sap Asa tame lal. Dekam sap anakare ola ban esa Asa hut lu ane gul, ‘Hëꞌho! An Bian mo bosekam nësa dikim oto gulsun hup hata seꞌara. Diki Alap Zen zëbe hap dawemsa golblan.’” ");
INSERT INTO ury_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Aha Hari Sabatnak kim zauk, ki zep Farisi walya teipsïn tolik Yesussu gubluka– zëno golak de golëtembane tan hap. Hwëna zen mes ahakore Farisi zi niban hen Musa mo ol tawa ta gwibin zi niban ola ziaha-en gulku– zao de dawemkam Yesussu anakan karatda tan hap, “Zen wëhë nëno mae mo Hari Sabat hap denaka gulmunꞌunka?” ");
INSERT INTO ury_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Zen in zep sërkam de tese-tese nabare zini hen nenblak– zen de hen ang gwen hap. Hëndep zen Yesus mo dang gwën nakon zep nikinꞌinka. ");
INSERT INTO ury_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesus ki zep hwëna kïtak takensibiridaka, “Em banakane Musa mo tïtï tabin ola dam ulsuꞌun? Hari Sabatkam san ha zi sang-sangsa sap de dawem tabinkim? San ha bëjen?” ");
INSERT INTO ury_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hwëna man nasalsïblïk. Ki zep hwëna tese-tese nabare zini insa ïrïk tasïkï, hëndep ki zep zë dawem taka. Zao zep gubluka, “Sap esa angkam song gwera.” ");
INSERT INTO ury_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ki zep hwëna gubiridaka, “Eno walas ahaksa sapi zaho de Hari Sabatkam aïlï honak dum gwe heꞌanam, em san ha molye dekam ër aneꞌanam?” ");
INSERT INTO ury_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Zini in sap man Yesus mo ola insa husus neibiꞌik, hwëna hom dam nulsuk– kirekam de ding gulblun hapye. ");
INSERT INTO ury_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nama kim tembane yala iwe lowe heꞌak, Yesus ki zep hlauludaka, ahakon bose bete-tek nik ngein nikore komal tum dawemsa teinikirinkim alt dasibik. Ki zep zëbe mae hap ola gulk sun blaonzimki, ");
INSERT INTO ury_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Zi de we-zi daresa de oto sonnak de tembane yawala kon emsa ang gwen hap gublunkam, em bahem na-en ngeinnik de komal tum dawemna al sosun. San ha zen mes yap hen aha zisi, ebon onakon de bose nik teipsïblïn naka, ang gwen hap gublula? ");
INSERT INTO ury_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ki hwëna zen de hatankam, gol bina in sa emsa gublula, ‘Em aes gwesïblïn.’ Hwëna em dekam saher tola ban esa lun tangan nikiri. ");
INSERT INTO ury_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Diki em de hatankam, nonol lure tangannak em nikirin. Zen diki gol bi nik sa emsa gublula, ‘Haen, ano wal bose, ngeinni an kon em hen nikirin.’ Dekam eno bosena sa dawem gwer– tïngare zi mo nwenakye. ");
INSERT INTO ury_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sap tïngare zini men zen mam gwen hap ëdwam gwe-gwenan, Alap sa hwëna otde tangannak kang gulu. Hwëna men zen otde tangannak lowehe gwenan, desa hwëna gut de tangannak sa kang gul sera.” ");
INSERT INTO ury_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ki zep gol bina insa gubluka, “Em de tembane yawalsa syal gwe-gwibinni, bahem dekon zi dawem ensa gubirida gwen– men kiye, wal bose wal om, iye om, oso wal om, hen sowe tane wal om, ahaksa gol golek denak de te-ala beya zisi. Ki zen sa emsa nërhwë-hwë gwer. Dekam mensae golzimꞌinka, kiresa sa hwëna ebe hap nol gweblal. ");
INSERT INTO ury_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Diki em de tembane yawalsa syal gwe-gwibinni, zen tahalha zisi em kon gubirida gwen– sap zi tim karek, sap zi lek, hen zi nwe dïmïn maesa. ");
INSERT INTO ury_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kirekam Alap sa ebe hap hëꞌho gwibin nika golblala. Sap kirekam de zini bëjen emsa zerhwë-hwë gwen. Alap hwëna sa ebe hap dawemsa golblala– yaklana in dekam zi dawem-dawemna tïn nïkon luk taꞌakye.” ");
INSERT INTO ury_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesus kim tonsuku, dekam zep ahanik gu aneka, “Alap mo ïrïk gïn kon gwisibir hanan tembane yawalak men zen ang taꞌak, zen hëꞌho gwibin tangan naka sa hla nul!” ");
INSERT INTO ury_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesus ki zep zëno ola insa de ding gulblun hap gulk sun ola blaonzimki, “Zini ki tembanesa yawal tangankam syal gwibirki, hen zini beya tangankam hamal hap gubirida guku– tembane tanna iwe de ang tan hapye. ");
INSERT INTO ury_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tembanena insa kim taïblïn nïlsïk, ki zep babu zemka ahanaka gubluka, ‘Em anakan taken naseran, “Haen. Tembanena angkam mes dë danan!”’ ");
INSERT INTO ury_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Hwëna men desa sap hamal hap gubiridaka, zen kïtak man hwëna babu zem insa anakan nen gweblaꞌak, ‘Ëe molyë hatak.’ Ahana man gubluka, ‘Ëe mesë ngasa zer. Ëe zebë karatda tan hap song gweꞌan. Anakan gublu, “Bap zen asa jakal gweblan.”’ ");
INSERT INTO ury_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ahana hen man gubluka, ‘Ëe nër homë sapisa dare taha-tap enkam kap guk. Ëe zebë song gweꞌan– anakan de akasibiridan hap, “Wëhë apdekam syal taꞌak?” Anakan gublu, “Zen molya hataka. Man gulu, Bap zen asa jakal gweblan.”’ ");
INSERT INTO ury_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ahana hen man gubluka, ‘Ëe nër homë wenya gok, zep ëe molyë hatak.’ ");
INSERT INTO ury_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Babu zem in ki zep zë-en lwa halka, ki zep tonbla zaka– men kirekam ding nul gweblaꞌakye. Gol bina in dekam man tangan jal gwibiridaka. Ki zep gubluka, ‘Em hëndep nabakam etan song gwen– ë yala awe de ora-ora san. Dekam kwang guluda halza– sap te-ala srëm zi, sap zi karek, zi lek, hen nwe dïmïn mae naka.’ Ki zep kwang guludahal zaka. ");
INSERT INTO ury_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Kim lwa halka, ki zep gublu zaka, ‘Mesë kire naka kwang guluda halanzal, hwëna komal tum jam en hom.’ ");
INSERT INTO ury_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ki zep etan gubluka, ‘Em etan song gwen– sap eik sin de ora bete-tek mae san. Desan ang tan hap wan-wan tabir song gwe– hëndep ano golak awe de ëbeya gwezak. ");
INSERT INTO ury_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ëe ama emsa gubluꞌan: Mensa sap nongka hamal hap gubiridak, zen molya lun etan yaïng gwezak– tembanena ansa de akasïblïndan mae hapye.’” ");
INSERT INTO ury_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","In kim sap zini beya tangan nik Yesus hon ang taꞌak, ki zep lero gwibiridan naban gubiridaka, ");
INSERT INTO ury_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Zini men zen an-bi zemka dawemkam enna nolabirida gwenan, hwëna zëno mae mo Asa de en lwablanna lwala henna, kirekam de zini zen bap zen Asa ang gweblan. Hen kirekam, men zen we zemka, walas zemka, ahaksa aya-wal oso-wal zemka dawemkam enna nolabirida gwenan, hwëna zëno mae mo Asa de en lwablanna lwala henna, zen hen bap zen Asa ang gweblan. Hen kirekam, zi de Abon onakon zëre mo gwënsa dawemkam ensa lwabinni, zen hen bap zen Asa ang gweblan. ");
INSERT INTO ury_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Hen zi de zënaka anakan sosok tan srëmna, ‘Asa sap sa Yesus mo kim te-lidak sonnak makan dain,’ zen bap zen hen Asa ang gweblan. ");
INSERT INTO ury_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ebon mae onakon ahanik de klibu nabare gol syal gweblan hap enlala gweꞌanam, zen nongka maka nikinꞌira– zëre mo te-alasa de aïtblïn hap, mae hap, ‘Wëhë sowe heꞌanka?– gola ansa dikim so ta sonen hapye.’ ");
INSERT INTO ury_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Sap sowehen srëmkam, ki hwëna ei-te en naka de eiyas tannak sa te-alana topse gwera. Dekam tïngan men zen gol ïk sosunnu insa hla daꞌak anakan sa swrë dal, ");
INSERT INTO ury_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Zen man tim gulku, “Ëe asa tap ta soner,” hwëna hom tol!’ ");
INSERT INTO ury_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Hen kirekam, teipsïn zi de zëno jana nabare zi sepulu ribu enkam lowe heblanna, hwëna zen de sane gweꞌanka, ‘Aha teipsïnnï zëno jana nabare zini dua-pulu ribu enkam man emsa de hatabin hip sek gweꞌanzal,’ zen maka enlala gweꞌara, ‘Ano an wëhë sowe heꞌak?– deban mae de eijan hapye.’ ");
INSERT INTO ury_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Anakan de enlala gweꞌanka, ‘Ano molya sowehek,’ dekam ahanaka maka zer soneꞌara– zen de nama ëgolek de gwezan srëmnak, anakare ola ban, ‘Ëe basa asa ebe hap golblal– dekam de nen ëeijan srëm hapye?’ ");
INSERT INTO ury_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Zen in zep, em hen kirekam. Em de ere mo gwënsa kïtak tapbla gun srëmkam, em molye Abon osan ang gweka. ");
INSERT INTO ury_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","“Em an zene Abon onak ang ta gweꞌan, em okamanak san de hina kiye. Hina zen sap tembanesa de dërek gun hup dawemna. Hwëna blëble gwenkam, dekam tembanesa dikim dërek gun hup dena man hom gwe-gwenan. Dërekna in de hom gwenkam, dekam zini bëjen ba mae hap dwam gwibin. Dekam zalta dep de kama san hiri gun en hap dena. Zen in zep, em dwan i nibanke! Emki ësal gwen.” ");
INSERT INTO ury_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Dekam karek gol gwen zini hen-henkam yaïng gwe-gwezak– Yesussu de hen sane ta gwen hap. Zen ahakon Roma mo ïrïk gïnnïk dep de te-ala alal tanda gwen zi. ");
INSERT INTO ury_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Hwëna Farisikam de zi niban Musa mo ol tawa ta gwibin zi niban man anakan ëtonsuk gweꞌak, “Wëo, zini an ba hap enlala karek-karek zi niban golësiri gwe-gweꞌara? Hëndep man golëtembane ta gweꞌara!” ");
INSERT INTO ury_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dekam zep Yesus ola gulk sun blaonzimki, ");
INSERT INTO ury_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Zi de ebon mae onakon zëno domba zaho 100 enkam lowe heꞌanam, hwëna ahanik de jek-jak gweblaꞌanam, zen banakan maka gwëꞌara? Zen maka 99kam dena insa so tranak hli yuludaꞌara, ki maka jek-jak gwen zini insa tëblaꞌara. Hla tan srëmkam molya tëblanna baes gweꞌanam. ");
INSERT INTO ury_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kim de hla taꞌanam, dekam isrip-sri naban maka ngaïrïnak ziren haꞌan zala. ");
INSERT INTO ury_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Golak, wal bose wal zemka maka tagal guꞌura, hen gol golek de bose zemka– anakare ola ban, ‘Nen ëisrip-sri gwen! Ano domba zahona men zen jek-jak gwera, mesë etan hla tanan!’ ");
INSERT INTO ury_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Hen kirekam, ngatan zi mo langnak isrip-srina mam tanganna– aha-ere zi de zëre mo karek gol gwen nakon halenkamye. Hwëna men zen 99kam de zini ëenlala gwenna, ‘Ëe homë halen hap dwam gweꞌan. Abon hom– karek naye,’ kirekam de zi hip ngatan zi mo langnak isrip-srina betek tanganna.” ");
INSERT INTO ury_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Hen kirekam– we de zëno te-ala dare taha-tap enkam lwabiꞌinam. Hwëna aha ala nik de jek-jak gweꞌanam, zen dekam banakan maka gwëꞌan? Zen maka pelitasa tum guꞌun, ki maka gola insa teibiri seran hap jïlk gïlsïꞌïn– hëndep de hlauꞌunam. ");
INSERT INTO ury_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","In kim hlaunnu, dekam maka we wal bose zemka tagal gulu senꞌan– hen gol golek de bose zemka, anakare ola ban, ‘Nen apdekam ëisrip-sri gwen. Ëe mesë ëre mo te-ala jek-jak gwenna hlaulun.’ ");
INSERT INTO ury_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Zen kirekam hen Alap zëre mo dam taha nakore zi niban golëisrip-sri gwe-gwenda– aha-ere zi de zëre mo karek gol gwen nakon halen naye.” ");
INSERT INTO ury_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesus ki zep etan ayang gulzimki, “Zini ki, zëno zi walasna dan-dan. ");
INSERT INTO ury_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Oso zik zep bi zemka gubluka, ‘Bian, eno kire-kirena mensa em de tïnkïm ëe de hlï lan hap dena, abe hap de hlïkna angkam ap kap tabla– em de tïn srëmnak.’ Dekam zep walas dare zem in hap hlï tazimki. ");
INSERT INTO ury_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Hom holo gweꞌak, oso zem in ki zep zëre hap de hlïkna insa te-ala hap lirak tabirki. Te-alana deban zep aha zi mo lang san zerhas gwesïkï. Zao zep twensïblïka– totore kirekam karek-kareknak. ");
INSERT INTO ury_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kim te-alana insa tap tasïkï, ki zep hwëna usak yala langna iwe hatak. Dekam zep tangan tahalha gweꞌanka. ");
INSERT INTO ury_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ki zep syal hap hakal gweka, hëndep ahanik zep zëwe de zi gubluka, ‘Ano gwe zahosa neik nganak taïzï gwibir.’ ");
INSERT INTO ury_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Hwëna man tangan usakna sabak gweꞌanka, sap tembane maena hom nol gweblak. Ki zep zë hole gwibiꞌinka– zaho hap de tembanena insa de twinbin hip. ");
INSERT INTO ury_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ki zep enlala dawemna hatablaka, ‘O ano bian hon de babu gwen zini, zëno tembanena dawemkam. Ëe hwëna aweë usak hap tïꞌïn! ");
INSERT INTO ury_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ëe anik bian osan dep lwahak. Hatankam asa gublul, “Bian, ëe mesë karek gwek– Alap mo nwenak hen eno nwenakye. ");
INSERT INTO ury_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ëe angkam dawem naka hom– eno tanekam de gublun hapye. Asa em gwëblan– men kiye, ebon de babu gwen zini.”’ ");
INSERT INTO ury_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Dekam zep bi zem osan dep lwa halka. Golak hom golek de gweꞌanka, bi zem ki zep langa ennak hla ta guku. Zao zep dawemkam kwasang gweblaka, ki zep hluweblaka. Zao zep babang taka. ");
INSERT INTO ury_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Tane zem in ki zep gubluka, ‘Bian, ëe mesë karek gwek– Alap mo nwenak hen eno nwenakye. Ëe angkam dawem naka hom– eno tanekam de gublun hapye.’ ");
INSERT INTO ury_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Hwëna bi zem in ki zep zëre hon de babu gwen zini takenbiridaka, ‘Emki nabakam ëre mo pakean sam-samsa ala soblan, hen tahanak cincinsi ala lablak, hen sepatusa ala osoblak. ");
INSERT INTO ury_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sapi lam tanna insa em tan. Namen tembane yawalsa esa syal eibir, hen esa isrip-sri ëblal! ");
INSERT INTO ury_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sap walasna an mes tïn makan gwëka, hwëna angkam mes ngaya gwera. Zen mes jek-jak gweka, hwëna namene hla lanan.’ Ki zep hëndep tembane yawala syal neibik. ");
INSERT INTO ury_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“In kim zë kirekam lwaꞌak, aya zem dekam nganak gwëꞌanka. Kim golak golek de gweꞌan zaka, dekon zep tërya sane gweꞌan zaka. Dekam zep enlala gweka, ‘Ba hap syaꞌan?’ ");
INSERT INTO ury_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ki zep bi zebon de babu gwen zisi ahanaka takensïblïka, ‘In ba hap ki lwaꞌan?’ ");
INSERT INTO ury_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Ki zep ding gulbluka, ‘Oso om mes hatala. Bia om man asa gubiridala– sapi lam tansa de tan hap. Sap zen mes etan tane zemka dawemkam zertowera.’ ");
INSERT INTO ury_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Aya zem in dekam sërkam jal gweꞌanka, hëndep golak de tïlzïn hap man baes gweka. Dekam zep bi zem te sobla zaka, ki zep tïlzïn hap wan-wan taka. ");
INSERT INTO ury_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Hwëna zen jala ban ding gulbluka, ‘Ëe mesë tahunna beya gwek– ebon de syal gwe tine gwenna, hen homë mae ebon onakon drak gwe inehak. Hwëna em home ba maena abe hap golblaka. Sap kambing maena home tol abe hap zerblaka– ëre mo wal bose walya ban dikim tembane yawalsa zisyal gwibin mae hapye. ");
INSERT INTO ury_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Hwëna eno walas karekna in zen eno kire-kirena swi golak tap tasïkï, zen kim hata zala, em hwëna sapi lam tansae tablanda!’ ");
INSERT INTO ury_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Bi zem in ki zep ding gulbluka, ‘Emsa awe dwan-am apdenak zergwë gwenan, hen ano kire-kirena kïtak ebe hap denakake. ");
INSERT INTO ury_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Hwëna diki namen de yaklana an, zen tembane yawalsa de syal gwibin hip dena. Sap eno osona tïn makan gwëka, hwëna zen mes ngaya gwera. Zen mes jek-jak gweka, hwëna namen tole ërtowera.’” ");
INSERT INTO ury_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesus ki zep zëre hon de ang ta gwen wenyaka gubiridaka, “Zini ki, zëno te-alana beya tanganna. Zëno irgwa taha nakore zini hen ki. Zen zen zëno kire-kirena kara ta gwibir-blika. Hwëna te-ala beya zini insa man aha zi anakan nenblak, ‘Eno irgwa taha nakore zini in man eno te-alana twen gweblaꞌara.’ ");
INSERT INTO ury_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Dekam zep kwang taka, zao zep gubluka, ‘Zini man eno karekna asa don gweblanan. Em mensa ano kire-kirena kara ta gweꞌara, bukuna men zao aïtbinkim ale gul gwenda, desa em ap golblan. Em molye etan kara ta gweka. Em esa syala in kon wet sola.’ ");
INSERT INTO ury_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Kim nama bon aït gwibin bukuna insa golbla srëm gweꞌanka, ki zep enlala gweka, ‘Ëe an banakan asa gwër? Ëe asa ëre mo syal dawemna an kon wet sol. Hwëna ëe soson naka hom– dekam de kamasa lwi gwen hapye. Hen wagam hap de hakalasen gwenna, zen saherak asa kim ënaka drëne gwer. ");
INSERT INTO ury_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","O ëe mesë dam gulsunun! Ëe asa aha te-ala beya zi niban golëdokot gwer. Ëe de wet sonkam, zen sa asa zëre mae mo gola kon kwang da gwer.’ ");
INSERT INTO ury_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Dekam zep irgwa taha nakore zi ahak-ahakna in sowëkam kwang guluda gweka– zini men zen te-ala beya zini in hon ëbon gwekke. Nonol zen hata zaka, ki zep desa takensïblïka, ‘Em banakaꞌene bon gweka– ano mam mo kire-kirena kim kap takaye?’ ");
INSERT INTO ury_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ki zep ding gulbluka, ‘Tembane taïblïn gïn hïp de minyak dremna dua-pulu enkam.’ “Dekam zep irgwa taha nakore zini in gubluka, ‘Dokot, emki nabakam ere mo bon alena ansa wet gulsun. Anakan hwëna ale gul, “Sepulu enkamë lop tak.”’ ");
INSERT INTO ury_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ki zep etan aha zini hata zaka, desa ki zep takensïblïka, ‘Em banakaꞌene bon gweka– ano mam mo gandumnu kim lop takaye?’ “Ki zep ding gulbluka, ‘Gandum sakna 1.000 enkam.’ “Ki zep hwëna ding gulbluka, ‘An dë– kire hap de suratna, men zao ere mo bosena ale gulkuye. Dokot, 800 enkam wet gulsuk.’ Hwëna mam zem in hom anakan tame gulku, ‘Zen abon de bonna totoresa wet gulsuk gweꞌara.’ ");
INSERT INTO ury_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Aumwa hap kim te-ala beya zini in tame gulku, ‘O zen man etan asa sërkam ahak-ahak taka,’ dekam zep guku, ‘Eiwa, zen nwe hleng gwen tanganna.’” Ki zep Yesus ayang gulzimki, “Men zen auhu-kama ennak dep de enlala naban lowehe gwenan, zen hwëna dawemkam ngein sin dep anakan ëkalang gwe-gweꞌan, ‘Ëe kirekam asa golëdokot gwer– te-ala beya zi nibanye.’ Men zen ngatan zi mo lang nakore ngatan naban lowehe gwenan, zen hom kirekam ëtewesïk gwenan. ");
INSERT INTO ury_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Zep Ëe ama emsa gubiridaꞌan: Auhu-kamanak de te-alakam diki Alap han em zerdokot gwen. Eno auhu-kamanak de te-alana insa kime tïnkïm hli taꞌanka, Alap Zen Zen sa emsa kwang tala– hëndep de gwën hap de gola kon. ");
INSERT INTO ury_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Teipsïn zi de babu zikhip banakare beteksa bohë gulblunna– zen de jek-jak gun srëmkam, ki hen yawal kire-kirena maka zëbe hap bohë gulbluꞌara. Dekam mes taïblïblaka, ‘Zen aïrïs.’ Hwëna zen de banakare betek maesa jek-jak guꞌunam, ki yawal kire-kirena maka hen jek-jak guꞌura. ");
INSERT INTO ury_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Zep emsa de auhu-kamanak de kire-kire hap taïblïblan srëmkam, ki hen molya Alap wakuwe emsa taïblïblaka– dakal hap de ëlwa gwen kire-kire hapye. ");
INSERT INTO ury_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Hen bohë gulblun kire-kire hap de emsa taïblïblan srëmkam, ki hen Alap molya wakuwe ebe hap lop tablaka– dakal hap de ëlwa gwen kire-kire naye, mensa sap menkam ebe hap hamal gulblukaye.” ");
INSERT INTO ury_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ki zep ola gulk sun blaonzimki, “Zini bëjen dare teipsïn zisi dawemkam babu gwizimdin. Zen hwëna aha-en naka sa dawemkam kwasang gwe-gweblala hen blikip gwesïk gweblala. Aha zini insa molya. Zep em hen kirekam: Em bëjen em syala dan son– Alap mo syala ban, te-ala beya gwen hap de syala banye.” ");
INSERT INTO ury_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisikam de zini in kim Yesussu kirekam sane daꞌak, dekam zep swrë daꞌak, sap zen te-alasa ensa nola gweblak. ");
INSERT INTO ury_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesus ki zep gubiridaka, “Em in zene ere mae mo bosena teip ulsuk gwenan– aha zi dikim emsa kïl tïbin hip, ‘An eiwa Alap mo nwenak dawem-dawemna.’ Hwëna Alap tawana eno mae mo enhona. Men desa auhu-kama zini teip nulsuk gwenan, zen Alap mo nwenak san de blë nabare kire-kirena kiye.” ");
INSERT INTO ury_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yesus hen dekam anakan tawa tabirki, “Musa mo tïtï tabin ola, hen hamal hap de ola mensa Alap mo ol ayang gul gwen zini ale nul gwek, desan en de ang ta gwen hap dena, zen mes Yohanis hon zausuk. Hwëna angkam Ëe an desaë Ëre hon de ang ta gwen wenya ban zigol halada gweꞌan, zen Alap Zën de ïrïk gïn hïp de ol dawem saye. Zep Ëe ama emsa gubiridaꞌan: Zen desan em kïtak ang tan. ");
INSERT INTO ury_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nglï naban kama naban zen maka jek-jak nëꞌan, hwëna Musa mo tïtï tabin ola, sap aha-ere huruf mae, molya jek-jak gwek. ");
INSERT INTO ury_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Zi de wesya baes gwibinni, hwëna ahanaka de etan gonkam, zen kahalo. Hen kirekam, zi de gonna zi mo we baes gwibinsi, zen hen kahalo.” ");
INSERT INTO ury_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesus anakarekam ola gulk sun blaonzimki, “Orep ki zini, zëno kire-kirena beya tanganna. Zëno pakeanna sërkam de dawem-dawem tanganna, hen mwin-mwankam tembane dërek-dëreksa twin gwibirki. ");
INSERT INTO ury_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Zëwe hen ki zini, bosena Lazarus. Zen tahalha tanganna, hen kwatyal-kwatyala man timni sul soneblak. Desa man te-ala beya zini in mo te so kïnï gwennak dëra guk gwezak– ");
INSERT INTO ury_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","tembane lausa de dekon twenblanda gwen hap, in zen te-ala beya zini in mo meja nakon altïl gwekke. Hen lwana man yaïng gwe-gwezak– dekam de zëno kwatyal sussu kwlem gul gweblan hap. ");
INSERT INTO ury_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tahalha zini in ki zep tol tïlkï, dekam zep Alap mo dam taha nakore zini neir inehak– Abraham Bak mo dang gwën nakon de hëꞌho gwibinnik drënen hap. “Hwëna dekam zep te-ala beya zini in hen tïlkï, ki zep nër dwanuk. ");
INSERT INTO ury_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Zen hwëna syauk bla sal-salak karekkam de sang-sangsa golgwë onka. Dekon zep Abrahamsa langa ennak kara ta seꞌanka. Lazarus zëno alp nakon nikinꞌinka. ");
INSERT INTO ury_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ki zep hërhe seblaka, ‘Auyan Abraham, asa kwasang gwebla. Lazarussu gublu– zen deka honak taha bolsa os taka, dekam de ano mahalsa blëble tazan hap. Sap ëe an syauk bla sal-sal kareknakë gwëꞌan.’ ");
INSERT INTO ury_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Hwëna Abraham man ding gulbluka, ‘Ano walas, emki enlala gwen: Em kime auhu-kamanak gwëka, em dawem ensae goltowe gweka. Hwëna Lazarus an karek ensa goltowe gweka. Zep zen mes angkam awe sam gwesïlï, hwëna em sang-sang nabane kareknak gwë gweꞌara. ");
INSERT INTO ury_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Zen toton molya hata zaka, sap ngïrïnnïk dwrakna mam tanganna. An kon bëjen in san dep ati gwe inezan, hen in kon bëjen an san dep ta gwe sezan.’ ");
INSERT INTO ury_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Te-ala beya zini in ki zep gubluka, ‘Auyan Abraham, ki emki Lazarussu ano bian mo gol san dep zer sonen. ");
INSERT INTO ury_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ano oso walya zao aha-ere taha-tapkam lowe heꞌan– zen deka zëbe mae hap ol zïm-zïmsï golzimki. Zen mana hen sang-sang kareksa awe ëre mo kim hla nul inzak.’ ");
INSERT INTO ury_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Hwëna Abraham ki zep ding gulbluka, ‘Zëbon mae onak ki– Musa mo ol ale gunnu, hen Alap mo ol ayang gul gwen zi mo alena. Zen dikire desan ang tak.’ ");
INSERT INTO ury_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Hwëna ki zep ding gulbluka, ‘Auyan Abraham, kirekam hom sowe heꞌan. Diki zi zen tïn nïkon ngaya gwen– zen de zëbon mae hatan hap. Dekam maka ëhaleꞌan– zëre mae mo karek-karek nakonye.’ ");
INSERT INTO ury_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Hwëna ki zep ding gulbluka, ‘Zen de Musa mo olsa hen Alap mo ol ayang gul gwen hap de zi mo olsa i-san i-san gwe-gwibin srëmkam, zen hen molya ëtaïblïk– zi de tïn nïkon ngaya gwen maekamye.’” ");
INSERT INTO ury_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus ki zep zëre hon de ang ta gwen wenyaka gubiridaka, “Okamanak awe de lowe henkam, banakare jal-jal hen hole-hle enlalana sa hata gwera. Hwëna zi de Asa de taïblïblan walassa karek san dep zertoranna, zen dikim Asa hli tan hap, kire zini zen ngalap gwe-gwen. Sap Alap sa desa sërkam karek tala. ");
INSERT INTO ury_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Zen maka sam gwesïkï– wal bose zemka de zertoran srëmnak de tïnnï, karekkam de tïnsï de goltowen maekam. Kaso dohon-honsa de holenak hule soneblan naban de hi tateknak hiri tan maekam, ki molya wal bose zemka zertonnanam, hen Alap molya kire hap karek taꞌanam. Eiwa, bap zen Asa de taïblïblan walassa karek san dep zertoran– sap walas betek! ");
INSERT INTO ury_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Zen in zep, bahem kirekam ëgwë gwen.” “Zi bose uk de ep kareksa golblanna, emki jalse gweblan. Zen de halenkam, zëno karekna insa emki eititi gwibir-blin. ");
INSERT INTO ury_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Zen de emsa aha-ere yaklanak beyana tuju enkam karek ta gwenna, hwëna zen de etan emsa tuju enkam gu gwebla zanna, ‘Bahem enlala gwibin. Angkam mesë halenan,’ em hen dekam em hëndep eititi gwibir-blin. Bahem etan enlalanak lam gun.” ");
INSERT INTO ury_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ki zep zëre hon de ang ta gwen wenya abe dak, “Asa Em mas gwibiridan– ëe akakim sërkam Alapsa laïblïblak.” ");
INSERT INTO ury_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ki zep ding gulzimki, “Eno mae mo Biansa de taïblïblan de betek mae nik lwaꞌanam, sap rica dan betek makare nik, dekam eme tenya jowenna ansa gubiꞌinam, ‘Hinak em zaunun,’ dekam hëndep maka zë zauꞌunnal.” ");
INSERT INTO ury_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","An ahana Yesus mo tawa tabin: “Ebon de babu gwen zi gwëꞌanam, zen ebe hap maka ngasa deng tya gweblaꞌara, hen domba zahosa maka kara ta gwibir-bliꞌara. Zen de syala kon lwahal zankam, em molye gubluꞌanam, ‘Haen, em nongka tembane gwe.’ ");
INSERT INTO ury_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Zen emaka gubluꞌara, ‘Abe hap tembanesa nongka hamal gulblu, ki pakean dawemna ala so– dekam de tembanesa ap dëre ta gubluzan hapye. Ena lun kon neik tembane gwe.’ ");
INSERT INTO ury_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Sap esa gublu srëm gwera, ‘Em asa sam tanda,’ sap zen ere hon de babu gwe-gwen zi. ");
INSERT INTO ury_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Em hen kirekam. Em de Alap mo ere hap de syalsa sul sonenkam, dekam emki enaka enlala betekkam gublun, ‘Ba hap de ano syala kon abe hap dawemsa golblan hap? Sap ëe an Zëbon de babu gwen zi sike.’” ");
INSERT INTO ury_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus kim Yerusalem san dep golësek gweꞌanka, kim langna Galilea hen Samaria mo lang hlik sonnak yaïng gwek, ");
INSERT INTO ury_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ki zep ë beteknak golëyaïng gweꞌanka. Zao zep zini dare taha-tap enkam golëtoweꞌanka– sop sang-sang karek de hlauludan naka. Zen langa nakon ëtaken gweꞌak, ");
INSERT INTO ury_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“Bian Yesus, asa kwasang gwibirida.” ");
INSERT INTO ury_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kim hlauludaka, ki zep gubiridaka, “Em Alap mo golak de syal ta gwen zi sin dep sek gwen– zëbe mae hap de enaka golëtreizimdin hip.” Kim kire hap sek gweꞌak, dekam zep kïtak ëdawem gwek. ");
INSERT INTO ury_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aha-enna kim zënaka tame taka, “O hare ëe mes-am dawem gwenan,” zen dekam zep etan Yesus osan dep lwahal zaka. Ol mamkam zep Alap hap dawemna golbla song gweꞌan zaka. ");
INSERT INTO ury_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yesus onak kim hata zaka, zëno nwenak zep ïk gwehe zaka, dekon zep dawemna golblaka. Zini in sap Yahudi walsya hom. Zen Samaria wal. ");
INSERT INTO ury_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesus dekam zep guku, “San ha dare taha-tapkam homë dawem tabir? An hwëna aha-ere tolik lwa halan zala. ");
INSERT INTO ury_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Aha lang nakore zi en lwahal zala– Alap hap de dawemsa golblan hapye.” ");
INSERT INTO ury_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesus ki zep zini insa gubluka, “Em luwen. Sap esa song gwera. Em ema Asa taïblïblala, zebe dawem gwenda.” ");
INSERT INTO ury_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Aha yaklakam, ki zep Farisikam de gubirida gwen zini Yesussu dakensïblïk, “Alap bawalkam sa Israel nësa ïrïk gïnkïm kon gwesibir hanala?” Ki zep ding gulzimki, “Zëno emsa de ïrïk gïnnï, em molye nwekam hla kuk. ");
INSERT INTO ury_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Em molye anakan ësane gwe-gwek, ‘Zen zëwe ïrïk gïꞌïra,’ ahaksa, ‘Zen awe ïrïk gïꞌïra.’ Sap zëno ïrïk gïnnï, zen angkam ki eno mae mo ngïrïnnïk lwaꞌan.” ");
INSERT INTO ury_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ki zep hwëna zëre hon de ang ta gwen wenyaka gubiridaka, “Em esa ngein sin anakan dwam ei gwibir, ‘Diki namen de ngatan zi mo lang nakore Zi Tangan lwa haꞌan zanam bap.’ Hwëna em molye na-en Asa hla lak. ");
INSERT INTO ury_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Zini sa emsa boton da gwibir, ‘Zen hale san gwëꞌara,’ ahaksa, ‘Zen ana san gwëꞌara.’ Hwëna bahem zëbon mae osan ang ta gwen– Asa de waba hap hakalblan hapye. ");
INSERT INTO ury_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sap ngatan zi mo lang nakore Zi Tanganna Ëe kimë hataꞌak, dekam ano tim nikon sa ngatanna wet so gwer– men kiye, nglï de mamkam ang tasïk kïnï gwenna. Desa kïtak man hla nulse gwenan. Zen kirekam sa hen lwal– Ëe de hatankamye. Molye Asa hla la srëm gwek. ");
INSERT INTO ury_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Hwëna nongka angkam de zini sa Asa baes nëblal, hëndep ki asa sërkam de karek yawala goltower. ");
INSERT INTO ury_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Yaklana men dekam ngatan zi mo lang nakore Zi Tanganna Ëe hataꞌak, zen orep men kirekam lwak, Nuh Bak kim golëlowehe gwekake, zen kirekam sa etan lwal. ");
INSERT INTO ury_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sap zen dekam tembanekam man ëmen-man gwenda gwek, hen we-zi daresa zënaka oto da gwibik. Zen kire enkam ki totoresa mumukkum lowe henda gwek, hëndep ki zep yaklana in dekam Nuh Bak bul yawala iwe we wal walas zeban golësesek gwe seka. Zen ki zep hwëna ho namwa yala insa auna nohlo gubik. Zen zep kïtak timbwas tabik. ");
INSERT INTO ury_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Lot kim gwëka hen kirekam ëgwë gwek: Zen dekam tembanekam hen ëmen-man gwe-gwek, banakare maesa lirak da gwibik, ngasa deng dya gwek, hen golsa daublunda gwek. ");
INSERT INTO ury_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Hwëna ki zep yaklanak hatak, Lot dekam Sodom kon heya gweka, dekam zep auna ëhlok– Alap kim sërkam de syauk sal-sala insa hiri gulzim ineka. Hëndep tïngan tangan zep ëtimbwas gwek. ");
INSERT INTO ury_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Zen kirekam sa hen auna ëhlol– yaklana men dekamë Ënaka zertrëꞌakye. ");
INSERT INTO ury_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Dekam zini men zen de gol homan nakon lowe heꞌak, zen bap zen etan gol mwa san ba maesa de gon hap bïtï gwehan. Hen nganak de syal tandan wenya, zen bap zen etan gol san dep lwan dahan. ");
INSERT INTO ury_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Emki enlala gwibin: Lot mo wenya zen banakan gwëk?! ");
INSERT INTO ury_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Sap zini men zen zëre mo auhu-kamanak de gwënsa anakan golaïrïꞌanka, ‘Ëe babë Yesussu de ang gwe-gweblannak karekna goltowe gwen,’ ki zëno gwënna in sa jek-jak gweblal. Diki men zen Asa de ang gwe-gweblan hap zëre mo gwënna sosok guꞌunka, hëndep zao mae de tïn hïp, zen zen sa hëndep denaban ngaya gwera. ");
INSERT INTO ury_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Emki ëenlala gwen: Ano hata zannak, dekam a kirekam sa lwal: Zi de dan-dan aha-ere tumnak laꞌanka, aha-en naka sa ëre mo dam taha nakore zini neir inehal. Hwëna aha tola sa hli dal. ");
INSERT INTO ury_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Hen we dare de lënsa aleꞌak, desa hen aha-en naka sa nul inehal. Aha tola sa hli nul.” ");
INSERT INTO ury_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ki zep hwëna zëre hon de ang ta gwen wenya in dakensïblïk, “Bian, kirekam de zisi de klis gun hup dena in, endawe sa ki lwal?” Ki zep ding gulzimki, “Men kirekam zini nen gwibirin, ‘Men zao tweran tokna lwanna, mawana hi agohena zao sa ëwale gwe-gwezal.’ Zep hen kirekam, em de owas-owasna insa hlaunnu, dekam esa dam ulsuk gwer, ‘Aumwa hap de yaklanak angkam man tangan golek de gweꞌan.’” ");
INSERT INTO ury_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesus ki zep ola gulk sun blaonzimki– nen de enlala nik ëtopse gwen srëmkam Alapsa abe ta gwen hap: ");
INSERT INTO ury_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Orep ë yalak zini ki, teipsïnnï. Zen hom Alapsa aïrï gweblaka, hen aha zisi hom blikip gwesibirida gweka. ");
INSERT INTO ury_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Zao hen we nala ki. Zen mwin-mwan enkam teipsïn zini insa anakan abe ta gwezak, ‘Asa tol mas gwibir. Zini man asa karek gul gweꞌara.’ ");
INSERT INTO ury_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Teipsïn zini in sap hom mas gwibin hip dwam gweka. Hwëna etan-etankam hata gwek. Ki zep hëndep enlala gweka, ‘Ëe sap homë Alapsa aïrï gweblanan, hen aha zisi homë blikip gwesibirida gwenan, ");
INSERT INTO ury_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","hwëna wenya an man tangan asa blostabla tine gweꞌan, hëndep asa tangan blalen gwer. Diki anik mas gwibik– zini insa de gublunkam, “Bahem kirekam karek gul gwen”, abon de hata gwensa dekakim zausuk.’” ");
INSERT INTO ury_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ki zep Bian srip gulsuzimki, “Mese ki ësane gwenan– insa ki teipsïn zi karekna in enlala gwekaye. ");
INSERT INTO ury_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","San ha Alap maka teipsïn zi karek mo kim salsibiridaꞌara?– zëre mo hlïl irin walasna men zen kam denaban yaklam denaban nen sonebla tine gwenanye. San ha Zen maka esek gul gweꞌara?– dekam de mas gwibiridan hapye. Zen kirekam bëjen. ");
INSERT INTO ury_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ëe ama emsa gubiridaꞌan: Zen dekam nabakam mas gwibirida gwenda. Hwëna sap kirekam, Ëe ngatan zi mo lang nakore Zi Tangan de etan lwahal zankam, Ëe anakare enlala naban asa hatazal, ‘Asa de taïblïblan wenya san ha nama tol? San ha hom tangan?’” ");
INSERT INTO ury_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Aha yaklakam Yesus ki zep gulk sun de ol blaorankam tonbiridaka– zi de anakan zënaka boltere ta gwibin srëm hap denaka, “Ëe ama sërkam Alap mo nwenak dakastïꞌïn.” Sap zen kire nakon zënaka anakan husus neibirida gwenan, “Zen aban apdenak hom.” Zen in zep gulk sun ola anakan blaonzimki, ");
INSERT INTO ury_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Farisi walya man Alap mo gol san song gweka– dekon de Alapsa gu soneblan hap. Hwëna zao kim gwëꞌanka, Roma mo ïrïk gïnnïk dep de pajak te-ala alal tanda gwen zini dekam zep hen kire hap hata zaka. ");
INSERT INTO ury_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisi walya in dekam zep zëbon onakon langa gwesïk hankam zauꞌunka, hen zëre en mo bosesa de mam gun hup denaka Alapsa anakan gu soneblaꞌanka, ‘Alap, ëe ep dawemsa golblaꞌan, sap ëe aha zi niban apdenak hom, hen zi karekna wakin mo kim hom. Ëe te-ala hole gwibinni tawa naka hom, ahak-ahakna tawa naka hom, hen kahalo gwenna– men kirekam ahakore zini kïtak ëgwë gwenanye. ");
INSERT INTO ury_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ëe minggu-jamkam dare yaklakamë tembanena lwa gweblanan– Emsa dikim gu sonebla tine gwen hap. Hen ëe de dare taha-tapkam ba maesa gul irinni, ëe homë Emsa te tya sone gwenan. Ahana ama ebe hap gol gweblanan.’ ");
INSERT INTO ury_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Hwëna Roma mo ïrïk gïnnïk dep de te-ala alal tanda gwen hap de zini in langa nakon zauꞌunka. Dekon zep nglï san de kara gwesen srëmkam huwe henkam nwe go-ho naban gu soneblaꞌanka, ‘Are Alap, asa tol kwasang gwebla. Sap ëe an karek gulin hana gwen zi.’” ");
INSERT INTO ury_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesus ki zep etan gubiridaka, “Ëe ama emsa gubiridaꞌan: Kim ola halka, te-ala alal tanda gwen zini in, zen zen en Alap mo nwenak sam gwesïkï. Farisi walya in hom. Sap tïngare zini men zen mam gwen hap ëalp gwe-gwenan, Alap sa hwëna otde tangannak kang gulu. Hwëna men zen otde tangannak lowehe gwenan, desa hwëna gut denak sa kang gul sera.” ");
INSERT INTO ury_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Aha yaklakam ki zep zini walas tane-nena hen wal baïzïlï Yesus onak dep kap nulhal gweꞌanzak– Zen de tahasa tehabirida ine gwen hap. Hwëna dua-blaskam de zëre hon ang ta gwen wenya in kim hla nulidak, zen zep hwëna anakan jalse neibirida gweꞌak, “Bahem walasna an san kap gulhal gwezan. Bahem Gurusa blostablan.” ");
INSERT INTO ury_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yesus hwëna ki zep walas tane-nena insa haen gwibiridaka, ki zep zë gubiridaka, “Dikire walasna Abon nolëyaïng gwe-gwezak. Bahem jalse gwibiridan. Sap walasna an makare wenya, zen zen Alap mo ïrïk gïnnï bi neibiꞌin. ");
INSERT INTO ury_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Eiwa denakaë emsa gubiridaꞌan: Men nara walas betek mo kim Alapsa anakan daïblïblaꞌak, ‘Zen eiwa ano teipsïnnï,’ zen zen Alap mo ïrïk gïnnïk bïtï gweꞌan. Men zen de kirekam daïblïbla srëm gweꞌak, zen molya Alap mo ïrïk gïnnïk bïtï gwek.” ");
INSERT INTO ury_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Aha yaklakam, ki zep Yahudi kore teipsïn tola Yesus hon hata zaka, zao zep gublu zaka, “Bian Guru, em aïrïs. Ëe basa asa syal gwibir?– ëe dikim hëndep de gwën hap denaka gul irin hipye.” ");
INSERT INTO ury_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ki zep ding gulbluka, “Diki aïrïs aha-en tangan, Alap Zë-en. Zep em Asa banakane enlala gweblaꞌara? ");
INSERT INTO ury_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Em dwan mes-eme sap Musa mo tïtï tabin ola tawa gwibirki– men zen anakan lwakye: ‘Bahem kahalo gwen. Zisi bahem tan. Bahem sowë gwen. Zisi bahem boton hap klak tan.’ Hen, ‘Ane-biasa em blikip gwesïk gwizimdin.’” ");
INSERT INTO ury_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ki zep ding gulbluka, “Kïtak insae aïtbirida, ëe betek nakonë ki hëndep desan ang gwek, hëndep angkam nama.” ");
INSERT INTO ury_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kirekam kim salblaka ki zep ding gulbluka, “Hwëna aha-en tangan lwa kïnïꞌan– em de desan ang gwen hap denaye: Em song gwen, ere mo kire-kirena kïtak tangan te-ala hap lirak tabir. Te-alana desa tahalha zi hip kae gwebla-zim. Kirekame syal gwibiꞌinka, ki ngatan zi mo langnake hëndep de te-alasa beyakam lam taꞌara. Ena dekam etan hataza– Asa dikim ang gweblan hapye.” ");
INSERT INTO ury_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Zini in kim kirekam Yesussu salblaka, dekam zep tangan enlalana dowebla hanaka, sap zëno kire-kirena beya tanganna. ");
INSERT INTO ury_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus hwëna man zë karatda taka, deban guku, “Eiwa, dam-dam naka hom– te-ala beya zi de Alap mo ïrïk gïnnïk hatan hapye. ");
INSERT INTO ury_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Te-ala beya zi de Alap mo ïrïk gïnnïk hatan hap dena, zen men kiye– unta yawal de jaron hul betek san tïnnï. Kire otweran yawala toton bëjen tïn.” ");
INSERT INTO ury_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Men zen Yesussu kirekam sane daꞌak, man denggwanblak, dekam zep dakensïblïk, “Hare eiwa kire tangankamke! Ki hwëna endan nik sa ëngaya gwer? Toton nara molya.” ");
INSERT INTO ury_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ki zep hwëna ding gulzimki, “Eiwa, auhu-kama zini zëre mae mo sosonkam bëjen zënaka ngaya tabin. Hwëna Alap de zi hip syal gwibir-zimdin srëm hap dena, aha-en mae hom tanganke.” ");
INSERT INTO ury_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Hwëna Petrus ki zep ding gubluka, “Ki hwëna abe mae hap dena bankarekam sa lwal? Sap ëe mesë ëre mae mo tïngare bi gwibinni Emsa de ang gweblanda gwen hap hli kulidak. Zep ëe basa asa lamkam ulin?” ");
INSERT INTO ury_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesus ki zep gubiridaka, “Eiwa denakaë emsa gubiridaꞌan: Men zen de Alap mo ïrïk gïn hïp de syal hap hli nulida gweꞌak– we wal walas zem, aya-wal oso-wal zem, an-bi zem, hen gol zem– ");
INSERT INTO ury_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","zëbe mae hap Alap sa mamkam kap gul gwizimdi. Men kiresa hli yuludanna, desa sa angkam okamanak sabakkam kap ta gwizimdi. Hwëna Zën kim de kïtak ïrïk gïnkïm kon gwesibir hanaꞌanka, Zen dekam sa hen zëbe mae hap hëndep de ëngaya gwen hap dena golzimdi.” ");
INSERT INTO ury_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus ki zep dua-blaskam de ang ta gwen wenya insa tagal gulsuku, ki zep zë gubiridaka, “Emki ësane gwen. Nen an angkam Yerusalem san debe yaïng gwe seꞌan. Zëwe kïtak men kirekam Alap mo ol ayang gul gwen zini ale nul gwek, ngatan zi mo lang nakore Zi Tanganna abe hap dena, zen kire enkam sa ki hëndep lwal. ");
INSERT INTO ury_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Asa sa Yahudi srëm zi mo tahanak dep tapbla dazim. Zen sa hwëna Asa lamang tan naban swrë da gwer, hen oltepkam sa Asa hol-hol da gwer, ");
INSERT INTO ury_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","hen zen sa Asa dangole gwer. Ki sa hëndep Asa dal. Hwëna yaklana dan-ahan, ki asa etan tïn nïkon ngaya gwer.” ");
INSERT INTO ury_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Hwëna dua-blaskam de zini in, hom mae engka en mae tame nuk. Banakan mes yap zë gweibiridaka, zep anakan hom dam nulsuk, “An kire hap ki gulu.” ");
INSERT INTO ury_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesus kim Yerikok golëyaïng gwe seꞌan zaka, zi nwe dïmïnnï ora alpnak nikinꞌinka. Zen te-ala hap kon aberbe ta sone gwibirki. ");
INSERT INTO ury_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Zen kim Yesus maesa sasak-sasakna sane ta gubiꞌinka, ki zep tame gulku, “O an zi beyam-bya am taman gweꞌan.” Dekam zep takensïk soneka, “Em ba hap?” ");
INSERT INTO ury_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ki zep nenblak, “In Yesus tamanꞌara– Nazaret walya men.” ");
INSERT INTO ury_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Dekam zep taken sone gweblaꞌanka, “Yesus, Daud Bak mo Auyan-tane, asa tol kwasang gwebla!” ");
INSERT INTO ury_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Men zen teingiri daꞌak ki zep jalse nëblak, “Balkkam!” Hwëna zen dekam mam enkam etan taken sone gweblaꞌanka, “Daud Bak mo Auyan-tane, asa tol kwasang gwebla!” ");
INSERT INTO ury_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesus dekam zep zausuku, ki zep waulblu halzan hap gubiridaka. Kim nërhatazak, zao zep takensïblïka, ");
INSERT INTO ury_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Em basae dwam gwibiꞌira?– Ëe de desa ebe hap syal gwibir-blin hapye.” Ki zep ding gulbluka, “Bian, ëe ama nwesa de kara gwen hap dwam gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesus ki zep gubluka, “Ki em kara gwen. Em mese asa taïblïblala, zebe dawem gwenda.” ");
INSERT INTO ury_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Dekam zep ki hëndep kara gweka, dekam zep Yesussu ang gwe sebla halka– Alap hap de dawemsa gol gweblan naban. Zi trana in kim owasna insa hla nuk, dekam zep kïtak Alap mo bosena teip nulsubluꞌak. ");
INSERT INTO ury_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesus kim nama Yerusalem san dep golësek gweꞌanka, ki zep Yerikosa golëtaman gweꞌanka. ");
INSERT INTO ury_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Hwëna Roma mo ïrïk gïnnïk dep te-ala alal tanda gwen nik mo nola zëwe gwë gweka, bosena Zakeus. Zëno kire-kirena beya tanganna. ");
INSERT INTO ury_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zen man tangan Yesussu de hla tan hap dwam gweꞌanka, hwëna zini beya tanganna. Zep zen ba kon dep?– hla tan naye. Sap zini in tïhïs tanganna. ");
INSERT INTO ury_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ngein sin zep tenya aranak de sewen hap hles tyaka– dekon de tamarannak hla ta sonen hap. ");
INSERT INTO ury_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesus kim te ausuna iwe hata zaka, ki zep gulk sun kara gwe seka, zao zep gu seblaka, “Zakeus Bak, em nabakam ati gwezan, sap Alap mo abe hap de dwam gwibir-blinna, Ëe namen aha golak molya tak. Ëe eno golak asa tal.” ");
INSERT INTO ury_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakeus ki zep nabal-bakam ati gwe zaka, ki zep hëndep Yesussu zëre mo gol san dep isrip-sri naban ngeirbline halka. ");
INSERT INTO ury_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tïngare zini kim kirekam Yesussu hla dak, dekam zep jakal nëblaꞌak. Man ëguk, “Wëo, zen ba hap zi karek mo golak de tan hap gunda?!” ");
INSERT INTO ury_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Golak kim lowe heꞌak, Zakeus ki zep luweka, ki zep Yesussu gubluka, “Bian, ëe ama angkam haleꞌan. Ano kire-kirena 50 persenkam ëe asa tahalha zi hip kae gwebla-zim. Hen men zëno mae mo pajaksaë aen dikim aha hlïk naka twenblan hap mamkam de ing gun hup gubirida gwek, ëe asa hwëna angkam etan mamkam kap tazim: 100 ribukam de ahap tan zi hip, ëe asa hwëna 400 ribukam golblal. 10 ribukam de ahap tan zi hip, 40 ribukam asa golblal.” ");
INSERT INTO ury_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ki zep hwëna zëno ola insa ding gulku, “Namen de yaklana awe, zini an hëndep we wal walas zeban, Alap mes ngaya tabin hip denaka golhatazimnira, sap zen hen Abraham Bak mo auyan-tane wal. ");
INSERT INTO ury_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Sap ngatan zi mo lang nakore Zi Tanganna Ëe kire zisi de hakalbiridan habë hatazak– men zen ora dawem nakon ësyal hekke, desa dikim ngaya tabin hip.” ");
INSERT INTO ury_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesus kim nama kirekam tonbiridaꞌanka, Zen gulk sun de ol blaonzimdinkim ayang gulzimꞌinka. Sap dekam Zen mes Yerusalemk golëgolek de gweꞌanka, hen dekam zini man kïl dï gweꞌak, “Yerusalemk kim golëyaïng gweꞌanka, Zen dekam sa nësa Alap mo bosekam ïrïk gïlï, hen nen dekam esa Roma mo ïrïk gïn nïkon wet so gwer.” ");
INSERT INTO ury_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ki zep gubiridaka, “Orep zini ki, bose teipsïblïnna. Ki zep hwëna teipsïn tangan zi nik aha lang nakon gu soneblaka– zao de bose naka etan esek gul seblan hap, lwahal zankam de zen langna iwe ïrïk gïlzïn hap. ");
INSERT INTO ury_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Hwëna kim teipsïn tol zini in song gwe srëm gweꞌanka, zen zëre hon de babu gwen zisi dare taha-tapkam kwang guludaka. Zao zep te-alana kae gwebla-zimki– seratus-juta seratus-jutakam. Zao zep gubiridaka, ‘Te-alana an ano tim bwanak em dekam kire-kirena lirak la gwibik.’ ");
INSERT INTO ury_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Hwëna zao de zini ahakon man tangan husus nëblak– zen de teipsïn hïpye. Zep zëna kim song gweka, dekam zep zisi kap nul sonek– zen de teipsïn tangan zini insa anakan gublun hap, ‘Zini in ëe homë ki dwam ëblaꞌan– zen de asa teipsibiridan hapye.’ ");
INSERT INTO ury_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Hwëna zen hom zëno mae mo ol san ang gweka. Zen hwëna desa teipsïn taka. Ki zep hëndep zëre mo lang san dep lwahal zaka. Hëndep dekam zep zëre hon de ëbabu gwe-gwen zini insa tagal gulsuku– dekam de zë anakan tawa gwibiridan hap, ‘Zëno mae mo te-alakam de eini angkam banakaꞌen?’ ");
INSERT INTO ury_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Nonol zen hata zaka, ki zep gubluka, ‘Bian, seratus jutakam mensa ap zerblaka, angkam mes satu meliarak hataka. An zen– te-alana inye.’ ");
INSERT INTO ury_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ki zep gubluka, ‘Aïrïs! Em abon de babu gwen zini dawem tanganna! Em mese betekkam de zerblan naka dawemkam ïrïk taka, zebë angkam mam naka ep we yul soneblaꞌan. Zep angkam em sepulukam de ësa esa ïrïk gïlï.’ ");
INSERT INTO ury_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Zao zen hata zaka ki zep gubluka, ‘Bian, seratus jutakam mensa ap zerblaka, angkam mes lima-ratus jutanak zaulu.’ ");
INSERT INTO ury_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Desa hen ki zep gubluka, ‘Em ëna lima enkam esa ïrïk gïlï.’ ");
INSERT INTO ury_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ahana zen hata zaka, zen hen ki zep gublu zaka, ‘Bian, eno te-alana men, a. Ëe ama kaen haknak de tahalen naka ep aning tablak. ");
INSERT INTO ury_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ëe ama emsa aïrï gweblak, sap em in jal-jal enkame ïrïk gïl gwenda. Sap em ere en mo eiyas gïn nïkore ei nika home tan gwenda, hwëna hen ebon de syal ta gwen wenyik mo irse gwen nakore nakae mamkam ere hap gulin gwenda.’ ");
INSERT INTO ury_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ki zep ding gulbluka, ‘Em abon de babu gwen zini karek tanganna! Em eiwakam asa anakan tame taka: Ëe jal-jalkamë ïrïk gïl gwenan, hen ëre en mo eiyas gïn nïkore ei nika homë tan gwenan, hwëna aha mo irse gwen nakore ei nikaë gulin gwenan. In zep ere mo ol toranna in kon asa emsa karek tal. ");
INSERT INTO ury_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Zep em ba habe ano te-alana insa te-ala lam ta gwen golak drëne srëm gweka? Ki zao maka etan lwahal zannak betek maekam ap mas nulblik.’ ");
INSERT INTO ury_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Zini men zen zë lowe heꞌak desa zep gubiridaka, ‘Te-alana insa em al tablan. Satu meliarkam men zen ap zertrëblala, zëbe hap hwëna mas lablak.’ ");
INSERT INTO ury_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Hwëna zini man zë denggwanblaꞌak, ki zep nenblak, ‘Asya, Bian, zëno mes-am satu meliar gweka!’ ");
INSERT INTO ury_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ki zep ding gulzimki, ‘Zini men zen ano kap tablanna kim syal-syal gwenna, zëbe hap etan asa kap ta gweblal. Hwëna men zen ano kap tablan naka asang gweblanna, men zen betek en maekam nama lwablaꞌanka, desa asa etan al tablal. ");
INSERT INTO ury_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Hwëna men zen ëe de teipsïn hïp baes tak, desa lahyo halzak– ëre mo nwenak de tameran hap.’” ");
INSERT INTO ury_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","In kim kirekam tonsuku, dekon kim Yerusalemk golëyaïng gwe seꞌanka, Yesus Zëna ngeinnik gwëka. ");
INSERT INTO ury_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Zaitun tra nabare kwatap teknak de ë darena Betania hen Betfagek kim golëyaïng gweꞌanka, dekon zep zëre hon de ang ta gwen wenyaka dan-dan guzimki, ");
INSERT INTO ury_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Em ëna wakin san song ën. Kime aptaꞌan haka, zao esa hëndep keledai tanena da tablan naka hla lala– zi mo zersong gwen srëm naka. Desa hïl lï-in halza. ");
INSERT INTO ury_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Zi de emsa takensizimdinkim, ‘Em ba habe hïl lïꞌara?’– a kirekam ding ulzim, ‘Bian dwam gweblaꞌara.’” ");
INSERT INTO ury_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Zi darena in ki zep song ëka. Men kire enkam tan-tan soka, kire enkam zep ki hëndep lwak. ");
INSERT INTO ury_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kim hïl lï inꞌinka, keledai bina ki zep dakensizimk, “Em ba habe hïl lïꞌara?” ");
INSERT INTO ury_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ki zep ding ulzimki, “Bian dwam gweblaꞌara.” ");
INSERT INTO ury_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Hëndep ki zep ërlwa halka. Kim ërhataka, ki zep keledai tahan dannak zëre mae mo tahan bajuna kang dasek, zao zep hwëna Yesussu zëwe de sewesen hap mas nëblak. ");
INSERT INTO ury_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kim zersong gweꞌanka, zi trana in dekam zep ngein sin zëre mae mo tahan bajuna ora san dëre dahak– desan de keledaina in zersong gwen hap. ");
INSERT INTO ury_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yerusalemk kim ëgolek de gweꞌak– orana men dekon zaitun tra nabare kwatap tek nakon hut gwehe zaka, zi trana men zen ang nëblan daꞌak dekon zep ol mamkam Alapsa isrip-sri nëbla song gweꞌak– mae hap, mensa owas-owasna zëre mae mo nwekam hla nul gwekke. ");
INSERT INTO ury_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Man ëtaken song gweꞌak, “Hëꞌho! An Bian mo bosekam nësa dikim tatetekam ïrïk gïn hïp hata seꞌara. Diki Alap Zen zëbe hap dawemsa golblan. An Zëbon onakon esa Alap han ërumlae gwer! Hëꞌho! Nen kïtak teipsïn tangan Zini Alapsa boltere tan!” ");
INSERT INTO ury_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hwëna Farisikam de zini zi trana iwe man zë hen ëdurum gwehek. Zen ki zep Yesussu nenblak, “Bian, emki sap ere hon de ang ta gwen wenya insa gubiridan– dekakim balk tasïk!” ");
INSERT INTO ury_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ki zep ding gulzimki, “Ëe ama emsa gubiridaꞌan: Zen de ëbalk tasïꞌïk, dekam hwëna kaso beyam-byana an zen sa hwëna kirekam ëtaken gwer.” ");
INSERT INTO ury_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesus kim Yerusalemsa golek kon hla takïn zïka, dekam zep anakare ola ban nwe go-ho gweblaꞌanka, ");
INSERT INTO ury_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Kwasang tol, Yerusalem. Namen bae ki anakan tame uꞌin, ‘Alap han de zersësek gwen hap de orana an desan.’ Hwëna Alap mes ebe mae hap orana insa aning tazimki. ");
INSERT INTO ury_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Zen in zep, sap em Yerusalemk de zini home Asa dam lasïꞌïn, yaklanak sa hatal– men dekam de ebe mae hap de jal zini emsa dot nulsuꞌukye. Em dekam toton ba san molye heya-hya gwek. Zen sa kamasa bwang nul– eno ënak de kol sonna ansa dikim tatak gwesïk kïnïn hapye. Desan sa emsa bïtï neibiridazal. ");
INSERT INTO ury_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Zen sa hëndep emsa kïtak damerasïl, hen eno mae mo gola sa lu da gwer. We wal walasna zen sa kei-king nul, hëndep gol te ïk gïn maena molya ëlwak. Sap em home tame uk– Alap in kim sap emsa de ngaya tabin hip hata zakaye.” ");
INSERT INTO ury_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesus ki zep Alap mo golak tïl zïka. Dekon zep, men zen zë Alap hap de golblan kire-kirena lirak da gwibik, desa golëalsa soneka. ");
INSERT INTO ury_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Zao zep gubiridaka, “Alap mo olak man lwak, ‘Ano gola zen Ënaka dekon gu sone gweblan hap dena.’ Em an hwëna ‘sowë zi mo aning gol habe li kul sone gweꞌan.’” ");
INSERT INTO ury_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Hwëna Zën zep zë yakla jamkam tawa ta gwibiꞌinka. Hwëna Alap mo golak de syal tan wenyik mo mam-mamna, Musa mo olsa de tawa ta gwibin wenya, hen Yahudi mo nol-nola, zen dekam man Yesussu dikim tan hap orasa dëblaꞌak. ");
INSERT INTO ury_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Hwëna hom dam dasïꞌïk, sap tïngare ahakore zini man Yesus mo tawa tabinni sërkam dwam neibiꞌik. ");
INSERT INTO ury_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Aha yaklakam kim Yesus Alap mo golak tawa tabiꞌinka, dekam zep hen Alap mo golak de syal ta gwen zi mo mam-mamna, Musa mo olsa de tawa ta gwibin wenya, hen Yahudi mo nol-nola ban yaïng gwezak. ");
INSERT INTO ury_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Zao zep dakensïblïk, “Emsa an nara gubluka, hen nara emsa trï tase gweꞌara?– dekam de kirekam-kirekamna insa syal gwe-gwibin hipye.” ");
INSERT INTO ury_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Ki zep ding gulzimki, “Ki Ëe asa hen nonol emsa takensibiridal: Baptis ta gwibin zini Yohanis Swesa san ha Alap trï ta seka? San ha zen zëre en mo sosonkam ki syal gwe-gweka? Eme nonol ap ding ulbliꞌak, ki Ëe asa hen emsa gubiridal, ‘Asa Zen trï ta seꞌara, zebë kirekam syal gwe-gweꞌan.’” ");
INSERT INTO ury_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dekam zep zë-en anakan donbiꞌik, “Bëjen nen anakan ding gulblun, ‘Alap trï ta seka,’ ki hwëna zen sa nësa gubiridala, ‘Ki em ba habe desa laïblïbla srëm gwek?’ ");
INSERT INTO ury_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Hwëna anakane ding ulbliꞌak, ‘Yohanis zen zëre en mo sosonkam syal gweka,’ ki hwëna zi trana an sa kasokam nësa nïrïbiridal, sap zen Yohanissi mes-am anakan daïblïblak, ‘Zen eiwa Alap mo olsa ayang gul gwizimki.’” ");
INSERT INTO ury_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Anakan zep hëndep ding nulblik, “Ëe homë dam ulsuꞌun, ‘Yohanissi zen trï tase gweka.’” ");
INSERT INTO ury_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ki zep hwëna ding gulzimki, “Zep Ëe hen molyë emsa gubiridak, ‘Ëe an zëno syalsaë gol gweꞌan, hen Zen Asa trï tase gweꞌara.’” ");
INSERT INTO ury_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesus ki zep ola gulk sun blaonzimki, “Zini ki, zëno anggur ngana yawala. Zen hwëna ngana insa te-alakam bohë ta guzim halka. Zëna dekam zep aha lang san holokam de zë gwën hap song gweka. ");
INSERT INTO ury_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Angguru in kim tëka, dekam zep zëre hon de babu gwen zisi zer soneka– zen de anggur dan te-ala hlïksa zëre hap zerbla halzan hap. Hwëna zini in zen ngana insa bohë dak, zen hwëna man karekkam dangolek, deban zep nenblak, ‘Wake, ki en lwahal!’ ");
INSERT INTO ury_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Etan ki zep ahanaka zer soneka. Hwëna desa man nonol lamang dak, zao zep dangolek, ki zep etan ba maesa de golblan srëmkam nër sonek. ");
INSERT INTO ury_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Dekam etan ahanaka zep zer soneka. Desa hen man dangolek, hëndep man dësek, ki zep hëndep ngana in kon hiri dak. ");
INSERT INTO ury_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Dekam zep nga bina in enlala gweka, ‘Ëe banakan asa etan syal gwibir? Anik ki ëre mo dang tïnïnak de walasna ansa zer sonek. Desa wëhë yap blikip neisïblïꞌak.’ ");
INSERT INTO ury_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Hwëna kim nga bohë tan zini in hla da guk, ki zep zënaka nenbiridak, ‘Wakin angkam zëre mo walas tangan hataꞌara. Bi zik de tïnkïm, an zen sa hwëna ngana ansa bi gweblala. Nen tan, ekakim nën bi ëblak!’ ");
INSERT INTO ury_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ki zep hëndep ngana in kon hiri dak, zao zep tol hëndep dak. “Zep nga bi nik mo zi lup gul sonenna insa kirekam neibirida gwek, zep zen banakan sa gweibirida zala? ");
INSERT INTO ury_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Zen sa tamera zala. Ngana insa dekam sa hwëna aha zi hip bohë tazimdi– dekam de zen anggur dan te-ala hlïksa zëre hap zer gweblan hap.” Ola insa kim ësane gwek, dekam zep ëguk, “Asya, kirekam bap zen lwan!” ");
INSERT INTO ury_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Hwëna Yesus man kara tabiꞌinka hen sane tabiꞌinka. Ki zep hwëna gubiridaka, “Ki hwëna em banakane Alap mo ola ansa enlala eibiꞌin?– men zen anakan lwak, ‘Gol tauk gweblan wenya mensa gol tenya baes neibik, hwëna Bian Alap mes desa bolak ïk gïlkï.’ ");
INSERT INTO ury_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Zep zini men zen de gol tenya iwe ëtïsïk gweꞌanzak, zao sa hëndep ëtimbwas gwe-gwer. Hen gol tenya in men zëbon mae de zan ineꞌak, zen sa hëndep ëïls gwer.” ");
INSERT INTO ury_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yahudi mo mam-mamna in kim Yesus mo gulk sun de ol blaoranna insa sane daꞌak, dekam zep dam nulsuk, “O zëno ola an nëbon mae am tïꞌïn.” Ki zep sap dekam de zë hëndep balk tan hap ëakasïk. Hwëna zen zi beyam-byana insa hen naïrïbiridak, zep balk da srëm gwek. ");
INSERT INTO ury_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Dekam zep hwëna balk tan hap orana dëblaꞌak. Zen in zep ahakorena lup nul sonek– zen de u siwen olkam takensïk gweblan hap. Sap zen mes ola anakan niaha-en guk, “Roma mo ïrïk gïn nïka de ol lamangkam gubiꞌinka, dekam asa enbiridazak. Zen dekam esa hwëna gubernor hon klak lal.” ");
INSERT INTO ury_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","In zep Yesussu nenblazak, “Bian, ëe mesë emsa tame lak. Em Alap mo dwam gwibinni dam-dam enkame tawa ta gwibirida, sap eno tawa tabinni home wet gulsuk gwenda– dekam de zi emsa husus gweblan srëm hapye, sap mamna, sap betekna. ");
INSERT INTO ury_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Zen in zebë emsa lakensïblïꞌan: Em banakane Musa mo tïtï tabin ola dam gulsuꞌura? San ha nen sap esa Roma mo ïrïk gïnnïk dep pajak te-alana ol gwizim? San ha bap nen?” ");
INSERT INTO ury_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Hwëna Yesus mes anakan tame tabirki, “An u siwen olkam ki Asa dakensïblïꞌan.” Ki zep gubiridaka, ");
INSERT INTO ury_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Abe hap emki pajak hap de te-ala kasona insa ahanaka goltrëblan.” Kim nolblak, ki zep gubiridaka, “Te-ala kasonak awe, an nara mo nwe-masesa zë yang dasïk? Hen nara mo bosesa zë ale nuk?” Ki zep ding nulblik, “Roma mo teipsïn zi mo denakake.” ");
INSERT INTO ury_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ki zep hwëna ding gulzimki, “Ki Roma mo teipsïn zini in mo bi gwibin kire-kirena amki zëbe hap etan lop la gweblak. Hen kirekam, Alap mo bi gwibin kire-kirena, amki Alap hap lop la gweblak.” ");
INSERT INTO ury_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Zi beya mo inik hëndep hom zëno karekkam de ol-gunnu nasalblak. Ki zep hëndep balk tasïk, sap zen man zëno ding gulzimdinni insa denggwanbik. ");
INSERT INTO ury_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadukikam de gubirida gwen zini, zëno mae mo tawa tabinkim, “Zini bëjen tïn nïkon etan ngaya gwen.” Zen ki zep hen Yesus hon yaïng gwezak. ");
INSERT INTO ury_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Dekam zep u siwen enlala naban anakan dakensïblïꞌak, “Bian Guru, Musa Bak mo tïtï tabin olak a kirekam mo lwakye: ‘Zi de we zemka walas wë lan srëmnak tïnkïm hli yunnu, zen oso zik de etan gonkam– zen de zë walassa aya zik mo weinak dep wë tan hap. Hen kirekam, oso zik de tïnkïm, aya zik de hwëna we semna insa gonkam.’ ");
INSERT INTO ury_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Orep awe zini ki, beyana tuju enkam, aha-ere ane-bianna. Zëna zi nik zep nonol wenya golka, hwëna walas wë lan srëmnak zep tïlkï. ");
INSERT INTO ury_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Zao de zi nik zep etan golka– sowe nal zem in saye. Zen hen walas ën srëmnak zep tïlkï. ");
INSERT INTO ury_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Zao hen etan dan-ahan nik golka. Zen hen walas wë lan srëmnak tïlkï. Hëndep tujukam de aya-wal oso-walya in kire enkam zep sap nol gwek, hwëna walas ën srëm ennak zep juwe gwek. ");
INSERT INTO ury_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Wenya in hwëna aumwa hap zep tïk. ");
INSERT INTO ury_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Zep zen de etan ëngaya gweꞌanam, men kirekam ahakon tawa da gwibirin, wenya insa nara mo wekam maka nenbiꞌin? Sap tujukam de zini in mes desa kïtak nol gwek.” ");
INSERT INTO ury_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesus ki zep ding gulzimki, “Zini okamanak de lowehe gwenkam, zen man we-zi darena zënaka kap da gwenan. ");
INSERT INTO ury_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Hwëna zini men zen etan de ëngaya gwen hap ëdakastïꞌïk, zen molya etan zënaka kap da gwek. ");
INSERT INTO ury_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Zen dekam Alap mo dam taha nakore zi mo kim sa lowehe gwer, hen dekam molya etan juwe gwek. Zen Alap mo hanan tabin walaskam sa lowehe gwer, sap Zen mes desa tïn nïkon ngaya tabirki. ");
INSERT INTO ury_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Hwëna Musa hen mes damnak anakan goltreizimki, ‘Zini tïn nïkon ngaya gwenkam.’ Sap zen kim syauk nubare te tyum-tyumnuk hata zaka, dekam Alap anakan am gubluka, ‘Ëe an eno auyan wal mo Alap– Abraham, Isak, hen Yakob Bak mo.’ ");
INSERT INTO ury_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Zep Alap Zen tïn zi mo Alapsa hom. Zen ngaya wenyik mo Alap. Sap tïngan men zen juwek Zëbon onakon nama ngayana.” ");
INSERT INTO ury_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ki zep Musa mo ol tawa ta gwibin zini ahakore nik nenblak, “Bian, em dawemkame ding guluda.” ");
INSERT INTO ury_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Dekam zep Yesussu de takensïk gweblanna baes tak, sap zen mes ësaher gwek. ");
INSERT INTO ury_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesus ki zep takensibiridaka, “Zen ba hap ki zini anakan tawa da gwibirin?– ‘Israelsa de ngaya tabin hip de Zini, Zen teipsïn zini Daud mo auyan-tanekam sa hata zala.’ ");
INSERT INTO ury_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Hwëna Daud zëna man-am ‘Teipsïn Zi’kim gubluka– in kim buku Mazmuruk anakarekam ale gulkuye: ‘Bian Alap man ano Teipsïnnï gubluka, “Ëre mo dam taha nakon emki nikirin– dekon de hen teipsïnkïm ïrïk gïn hïp. ");
INSERT INTO ury_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ki asa hwëna ebe hap de jal zini ere mo tana ïltïkïnnïk sisik gulin.”’ ");
INSERT INTO ury_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Zep Daud insa Israelsa de ngaya tabin hip de Zini insa ‘Teipsïn Zi’kim gubluka, ki Zen banakan sa zëno auyan-tanekam hata zala?” ");
INSERT INTO ury_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Zi beyam-byana in kim nama sane daꞌak, ki zep dua-blaskam de wenya insa gubiridaka, ");
INSERT INTO ury_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Bera, Musa mo ol tawa ta gwibin zini in enlala kwae naban! Zëno mae mo kwaena in mana ebon mae hliminnink. Zen baju dawem-dawem alala tan naban zi nwe san zënaka nolëtrënda gwenan– zi dikim blikip gwesibirida gwen hap. Zen hen man ëdwam gwe-gwenan– dekam de aha zi tagal gwen maenak anakan blikip gwesibirida gwen hap, ‘Dawem, bian guru.’ Zen hen but srëm golak ngeinnik de komal tumnak de teinikirin hip ëdwam gwe-gwenan– hen tembane yawal maenakye. ");
INSERT INTO ury_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","We wal sem-semna hen anakan ahap da gwibirin, ‘Ëe asa tol eno zi swe mo kire-kire hli tandanna ebe hap tagal tasibir.’ Hwëna zen sowë enlala naban mas neibirida gwenan– dekam de zëre hap mamkam hlï tï irin hip. Hwëna zëre mae mo karekna insa dikim aha zi hlaulzimdin srëm hap, zep but srëm gola kon zi nwenak Alapsa mam blalkam nen sone gweblanan– dekam de zi kïl tïbin hip, ‘Zini an aïrïs.’ Hwëna zen zënaka de karek tabin hip denaka kim mam nulsuk gwenan.” ");
INSERT INTO ury_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesus kim nama Alap mo golak gwëꞌanka, ki zep kara tabiꞌinka– te-ala beya zini kim Alap hap te-alana bïtï da sone gweblaꞌanzak. ");
INSERT INTO ury_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Dekam zep hen we sem tahalhana hlaulku– zen kim hen te-alana dan tolaka Alap hap ing so soneblaꞌanzak. ");
INSERT INTO ury_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesus dekam zep gubiridaka, “Eiwa denakaë emsa gubiridaꞌan: We sem tahalhana an mes tïngare ahakore zini kwei-kwik gulun. ");
INSERT INTO ury_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sap ahakon in zen bïtï da gwe sanzal, zëre mae hap de hlïkna nama beya nik ërlwazimꞌin. Hwëna we sem tahalhana an mes tïngan ing gulun– zën dikim tol sap gwën hap denaka.” ");
INSERT INTO ury_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesus hon de ang ta gwen wenya ki zep Alap mo gola insa anakan donbiꞌik, “Alap mo gola an man tangan weir gulsunkum kwa nuk, hen zëno kaso kong ta zahenna sërkam de nwe-awes tanganna. Hen mensa Alap hap kire-kirena nol gweblak, sërkam de dawem-dawem tanganna.” Yesus ki zep gubiridaka, ");
INSERT INTO ury_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Yaklanak sa hatal, an desa namen kara uꞌin, sa dre nulsul. Hëndep zëno kaso kong ta zahenna aha-en mae molya lwak. Zen tïngan tangan sa dri nulsul.” ");
INSERT INTO ury_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ki zep Yesussu dakensïblïk, “Bian, zen bawalkam sa ki lwal? Hen banakare owassa asa hla kul gwer?– dekam de anakan dam gulsun hup, ‘Angkam man ki lwaꞌan– men kirekam hamal hap asa gu-gubiridakaye.’” ");
INSERT INTO ury_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ki zep ding gulzimki, “Salok-salokkam lowehe gwek. Emsa mana yasik da gwibirink. Sap zini beya nik sa ebon mae onak anakan ëboton gwe-gwezal, ‘Ëe an Zen– Yesusye. Angkam mes zë zaunun!’ Hwëna bahem salbirida gwen. ");
INSERT INTO ury_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Em de anakan ësane gwe-gwenkam, ‘Zëwe man ëeijaꞌan,’ hen anakan, ‘Dekon pemerinta nakon de wet so gwen hap man ësoson gweꞌan,’ hwëna em dekam bahem ëaïrï gwen. Sap zen nonol kirekam sa Alap mo dwam gwibin sin lwa gwer. Hwëna dekam bahem ëkïl gïl gwen, ‘An aumwa hap denak mes zaul, zep ki lwaꞌan.’ ");
INSERT INTO ury_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Aha zi ausu nakorena aha zi ausu naban sa ëeija gwer, hen aha ïrïk gïnnï aha ïrïk gïn nïban sa ëeija gwer. ");
INSERT INTO ury_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Lang yala an san jïngïlï mam enkam sa taïlïda gwera. Usak yawala sa hatanda gwer. Hen sang-sang yawal sa hlauluda song gwer. Nglïnak esa owasna hla kulse gwer, dekam esa ëaïrï gwer. ");
INSERT INTO ury_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Hwëna kirekam de lwan srëmnak, emsa sa dahyo gwer hen karek da gwibir. But srëm golak de mam-mam wenya kip sa emsa kap nulzimhal gwer, ki sa hwëna pemerinta mo bwinak emsa yal nulne gwer. Hen emsa sa pemerinta mo teipsïn-teipsïn wenya kip anakan nolëtrei gwizim, ‘An hen ahana– Yesus hon de ang gwe-gwenna.’ ");
INSERT INTO ury_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Hwëna zen kirekam Alap mo dwam gwibin sin sa ki ebe mae hap lwa gwizim– em dikim zë abe hap denaka ëton gwen hap. ");
INSERT INTO ury_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Aen asa ebe mae hap enlala blala ing ta sone gwizim, dekam hëndep eno mae mo jal zini molya eno mae mo ola insa nulsuk halasen gwek. Zep emki hamal hap enlalasa anakan hohle ta gwen, ‘Ëe ba hap de enlalana beya gwen hap? Zen sa zëwe de zaunkum enlala blala abe hap zerblala– ëe de kirekam ding gul gwizimdin hip denaye.’ ");
INSERT INTO ury_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ere mae mo ane-bianna, aya-wal oso-wal om, iye wal om, hen wal bose wal om, zen sa emsa abe hap de jal hap karek tabin hip nolëgu gwer. Hëndep emsa sa ahakon damera gwer. ");
INSERT INTO ury_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Emsa tïngare zini sa husus neibirida gwer, sap em an Asa de ang gwe-gweblan wenya. ");
INSERT INTO ury_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Em sap esa okamanak awe juwer, hwëna lamkam etan tim ëse naban esa luk tal. ");
INSERT INTO ury_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Zep em Asa de taïblïblannak em tatetekam ëzauk gwen. Zen dekam esa enaka ngaya labir!” ");
INSERT INTO ury_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Em kime jana nabare zini Yerusalemsa de dot tasïnnïk hla kulidaꞌak, zen dekam ëenlala gwek, ‘Yerusalemsa de dre tan hap de yaklanak mes zaunun.’ ");
INSERT INTO ury_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Em dekam, Yerusalem mo langnak de lowehen wenya, kwatap san dep em heya-hya gwen. Yerusalemk de lowehen wenya, emki hli tasïn. Hen ë alp san de lowe hendan wenya, bahem etan ë san dep lwanda halzan. ");
INSERT INTO ury_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Dekam men kirekam hamal hap ale nul gwekke, kire enkam sa Alap mo jala hatazim. ");
INSERT INTO ury_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kwasang tol, we walya u nubare wenya, hen nama de walassa momkam taïzï gwibin wenya. Zen tol banakan molya ëasendak. Dekam langna sa tangan dohon-hon gwer– Alap mo jal de awe de zi hip hatazimdinkimye. ");
INSERT INTO ury_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ahakon nëbokkam sa blom da gwibir. Ahakon tïngare lang san dep sa dahalebirhal gwer– zao de zi mo tana ïltïkïnnïk ëbabu gwe-gwen hap. Dekam Yerusalemsa Yahudi srëm zi en sa nyauk gweblal– hëndep yaklana de tap gweꞌanka, Bian mensa ki-en zëbe mae hap aïtbir-zimkike.” ");
INSERT INTO ury_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Alap dekam sa tan-tanna bennak, yaklanak, hen keisnik gol gwizimdi. Dekam hina sa mam en tangankam ngëp-ngep gwe-gwer– auku mam naban. Okamanak de tïngare langnak de zini zep sa anakare hap ëaïrï gwer, ‘Nen an molye lowehek.’ ");
INSERT INTO ury_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Zini hëndep kim de lang olo gwen hap dena insa neisbiꞌik, aïrïn hïp sa ëtïlsïk gwer. Sap dekam nglïnak de teipsïn-teipsïn dowal-dowala sërkam sa ëïlman gwe nasen gwer. ");
INSERT INTO ury_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Zen diki dekam sa ngatan zi mo lang nakore Zi Tanganna Asa but de zerati gwe zannak hla dase gul. Zen dekam asa ëre mo soson naban ngatan yawala ban ziati gwezal. ");
INSERT INTO ury_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kirekam kim de lwaꞌak, zen dekam em luk tan, ki gulk sun isrip-sri naban ëkara gwesek, sap zen dekam emsa de ngaya tabin hip ki lwaꞌan.” ");
INSERT INTO ury_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesus ki zep gulk sun de ol blaonzimdinkim aïsïl gwibiridaꞌanka, “Emki ëenlala gwen– dëren, ahaksa aha te. ");
INSERT INTO ury_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Zen de alsïn hyanak etan ala gwenkam, zen dekame tame ul gwenan, ‘Angkam sasa gwen hap ki lwaꞌan.’ ");
INSERT INTO ury_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Hen kirekam, owas-owasna insa kime hla kul gweꞌak, zen dekam esa anakan ëtawa gwer, ‘Angkam Alap Zën de kïtak ïrïk gïlzïn hap denak man zauꞌun!’ ");
INSERT INTO ury_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Eiwa denakaë emsa gubiridaꞌan: Em an zene angkam lowe heꞌan, molye kïtak juwek, zen dekam sa ki tïngan lwal. ");
INSERT INTO ury_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nglï naban kama naban sa jek-jak nër. Hwëna ano ola, zen hëndep denaban sa lwa gwer.” ");
INSERT INTO ury_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ere mo gwënsa em kara gul gwen– mae hap, mana eno enhona in beya gwenanka, syan-syan en hap de enlalakam, hen ho mamak otde gwen en hap de enlalakam, hen ere mo gwënsa de ngalap gwibin hip de enlalakam. Ki hwëna aumwa hap de yaklanak zol makarenak esa ëkyan nahlal. ");
INSERT INTO ury_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sap yaklana dekam kirekam sa hatazim– tïngan men zen okamanak lowehe gwenan, zëbe mae hapye. ");
INSERT INTO ury_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Zen in zep salok-salokkam lowehe gwek– Alapsa de gu sonebla tine gwen naban, tatetekam ekakim ëzauk. Karek yala in zen hataꞌan, kire hap em abe ta sone gwen– desa ekakim dawemkam yaubik, hen dawemkam ekakim ngatan zi mo lang nakore Zi Tanganna Asa etan de hata zannak ërtowek.” ");
INSERT INTO ury_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Zao kim lwa seꞌak, Yesus dekam yaklam Alap mo golak tawa ta gwibirki. Kam-en zep hwëna zëre hon de ang ta gwen wenya ban zaitun tra nabare kwatap tek san dep golësek gwe-gweka– zao de golëtruwe gwen hap. ");
INSERT INTO ury_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Zi beyam-byana kak tangannak zep Alap mo golak yaïng gwe-gwezak– Yesus mo tawa tabinni insa de ësane gwen hap. ");
INSERT INTO ury_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Dekam yakla yala Paskanak dep man golek de gweꞌak– Alap men dekam Mesir kon Israelsa gwis gwe sonekake. Paska yaklanak kim zauk, zen dekam zep hen ëkon gwesïk hanak– aha-ere minggukam de ragi srëmkam rotisa tru ta gwen naye. ");
INSERT INTO ury_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Dekam Alap mo golak de syal tan zi mo mam-mamna Musa mo ol tawa ta gwibin zi niban, zen hwëna aningkim Yesussu dikim tan hap orasa dëblaꞌak. Hwëna zi beyasa naïrïbiridak, zep dekam balk da srëm gwek. ");
INSERT INTO ury_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Dekam zep ëna Kariot walya Yudas Baksa dowal mo kïgïna ing gwe heblaka. Zen sap zëre hon de dua-blaskam ang ta gwen wenyik mo ahana. ");
INSERT INTO ury_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Zen ki zep song gweka– Alap mo golak de syal tan wenyik mo nol-nola ban, hen zëwe de jana nabare zi mo mam-mam naban de olsa anakare hap ziaha-en gun hup, “Ëe banakan asa ebe mae hap zao de balk tan hap zertreizim?” ");
INSERT INTO ury_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Zen man tangan sam neisïblïk, dekam zep nenblak, “Te-alasa asa ep ërblal.” ");
INSERT INTO ury_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Dekam zep ding gulzimki, “Ëe asa orana tëblal– dekam de sowëkam ebe mae hap zertreizimdin hip.” ");
INSERT INTO ury_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Rotisa de ragi mas gun srëmkam tru tan hap de mingguna iwe kim lwa seꞌak– yaklana men dekam Paskanak dep de tembane yawalak dep domba zahona Alap hap blom da gwibir-blikke, ");
INSERT INTO ury_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesus dekam zep hen Petrus ne Yohanis neka guzimki, “Em song ë– Paskanak dep de tembane yawalsa eka hen nëp hamal ul.” ");
INSERT INTO ury_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ki zep lakensïblïka, “Endawe asa hamal ul?” ");
INSERT INTO ury_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ki zep ding gulzimki, “Em kime ëna iwe lïꞌïnka, dekam esa zini hla la sonera– kama ngatdarakkam de weya blome gwirenhan naban. Zen desa em ërtro kïnïn– hëndep gola men zao de tïk, em hen zao lïl. ");
INSERT INTO ury_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Zao gol bi naka enbla, ‘Bian Yesus man emsa takensïblïla, “Ëe teksonna enda zao asa ëre hon de ang ta gwen wenya ban Paskanak de tembanena zitwenblal?”’ ");
INSERT INTO ury_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Zen sa ebe nikip gulk de tekson yawalsa zertreizimdi. Komal tum maena sowe henna. Zen zao hamal ul guk.” ");
INSERT INTO ury_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ki zep hëndep song ëka, zao zep hëndep oltoweka– men kirekam Yesus guzimkiye. Zëwe zep hëndep tembanena hamal ul guku. ");
INSERT INTO ury_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kim kam-en gwek, Yesus dekam zep dua-blaskam de wenya ban Paskanak dep de tembanena insa zitwenblaꞌanka. ");
INSERT INTO ury_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ki zep zë gubiridaka, “Ëe ama tangan dwam gwe-gwek– Paska tembanena ansa de eban mae zitwenblan hapye, Ëe de nama karek yawala insa goltowen srëmnak. ");
INSERT INTO ury_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sap Ëe ama emsa gubiridaꞌan: Ëe na-en molyë etan auhu-kamanak Paska tembanena twinbik. Hwëna Alap kim de ïrïk gïnkïm kon gwesibir hanaꞌanka, zen diki dekam asa eiwa tangankam de Paska tembanena twinbir.” ");
INSERT INTO ury_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yesus ki zep anggur ho nabare mokna zerka, deban Alap hap dawemsa golblaka. Zao zep gubiridaka, “An desa apdekam otdebik. ");
INSERT INTO ury_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ëe ama emsa gubiridaꞌan: Ëe angkam na-en molyë anakare anggur hona etan otdek. Hwëna Alap mo ïrïk gïnnïk kim de hataꞌak, zen diki dekam asa etan ziotdebir.” ");
INSERT INTO ury_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Rotina ki zep hen gul ineka. Ki zep hen rotina in hap Alap hap dawemna golblaka, ki zep ahap gul guku. Desa zep anakare ola ban kap tazimki, “An ano timni– mensaë ebe mae hap sosok gulzimꞌinke. An kirekam em ano timbwanak syal gwe-gwibin– Asa dikim enlala gwe-gweblan hapye.” ");
INSERT INTO ury_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kim tembane tasïk, ki zep anggur ho mokna etan anakare ola ban zerzimki, “An ano kala zen. Zen sa ano tim nikon wet sol– Alap mo zi niban de ol ziaha-en gun ësesa dikim sul sonen hapye. ");
INSERT INTO ury_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Hwëna Ëe ama emsa gubiridaꞌan: Zini men zen Asa dikim zë balk tan hap zertreizimꞌira, zen hen awe nikinꞌira. ");
INSERT INTO ury_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ngatan zi mo lang nakore Zi Tanganna Ëe asa tïl– men kirekam ki Alap Asa gublukake. Hwëna kwasang tol, zini men zen Asa dikim zë balk tan hap zertreizimꞌira, zen karekna mam tangan wenyaka sa goltowera!” ");
INSERT INTO ury_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ki zep zë zënaka anakan dakensibirida nasenꞌak, “Nëbon mae onakon in nara sa ki kirekam gwëblala?” ");
INSERT INTO ury_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Hwëna dekam zep dua-blaskam de wenya in ëol gweꞌak– mae hap, “Yesus de ïrïk gïꞌïnka, diki ëe amaka nëbon mae onakon teipsïꞌïn.” ");
INSERT INTO ury_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ki zep zë gubiridaka, “Alapsa de tame tan srëm lang-langnak men zen teipsïn-teipsïnkïm teinikin gwenan, zen man zëre kore naka jap nul sonenda gwenan. Hen zen man anakan de blikip gwesibirida gwen hap ëdwam gwe-gwenan, ‘Bian, em in asa de sam gulsun hup de zi.’ ");
INSERT INTO ury_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Hwëna em zëno mae mo kim bahem. Ebon mae onakon men zen teipsïn hïp dwam gweꞌara, zen diki walas betek mo kim zen gwën. Hen men zen mam gwen hap dwam gweꞌara, zen diki tïngare zi mo babu gwen zi makan zen gwën. ");
INSERT INTO ury_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ema tim ul gwenan, ‘Mejanak de tembane gwen zini, zen mamna. Hwëna men zen zëbe hap tembanena hamal nul gweblanan, zen betekna.’ Auhu-kamanak, eiwa, mejanak de nikirin zini zen mamna. Hwëna Ëe kirekam de mam gwen hap homë hatazak. Ëe hwëna babu gwen zi mo kim de mas gwibiridan habë hatazak. Zep em hen ano kim em lowehe gwen. ");
INSERT INTO ury_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Em mese Asa ërgwënda gwek hen kara landa gwek– banakare karek maesa de goltowe gwennak. ");
INSERT INTO ury_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Zep men kirekam Bian abe hap golblaka, zëno alp nakon de ïrïk gïn hïp, Ëe hen kirekam asa ebe mae hap golzim– em de hen ano alp nakon ïrïk gïn hïp denaye. ");
INSERT INTO ury_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Em dekam ano alp nakon esa teinikin– ano ïrïk gïn kon gwisibir hanan tembane yawalakye. Hen em dekam esa ere mae hap de dua-blaskam de komal tumnak teinikin– dekon de dua-blaskam de Israel Bak onakore zi aususa ïrïk gïn hïpye.” ");
INSERT INTO ury_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesus ki zep Simonsa gubluka, “Simon, Simon, dawem! Emki Asa sane tan. Dowal mo kïgïna mes emsa de sërkam akasibiridan hap Alapsa abe taka. ");
INSERT INTO ury_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Hwëna Simon, Ëe mesë ebe en hap Alapsa abe tal– eno Asa de taïblïblan dikim topse gwe srëm gwen hapye. Em kime Abon osan dep etan lwa haꞌan zaka, ere mo wal bose walya dekam tatete tabir.” ");
INSERT INTO ury_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petrus ki zep ding gulbluka, “Bian, ëe mesë tangan hohle gwenan– Eban de bwi san song ën hap, hëndep Emsa de zerzaunnuk de hwëna tïn hïpye.” ");
INSERT INTO ury_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ki zep ding gulbluka, “Petrus, Ëe ama emsa gubluꞌan: Namen ayang de gun srëmnak, em esa anakan de Asa zabeblanna dan-ahan soblala, ‘Zini in ëe homë tame taꞌan.’” ");
INSERT INTO ury_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ki zep takensibiridaka, “Ëe kimë orep emsa lup gul sonek, hon hen te-ala srëmkam de sek gwen hap, timnik de alala tan en naban, dekam san ha ema ëtahalha gwek?” Ki zep ding nulblik, “Ëe homë ëtahalha gwek.” ");
INSERT INTO ury_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Dekam zep etan gubiridaka, “Hwëna angkam, eno mae mo hon hen te-ala de lwanna, emki kap tan. Eno nëbok de lwan srëmna, emki tahan bajusa te-ala hap lirak tabin– te-alana dekam de nëboksa lop tan hap. Sap em Abone ang ta gwek, emsa hen zep sa jal neibiridal. ");
INSERT INTO ury_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sap Ëe ama emsa gubiridaꞌan: Men zen Alap mo olak abe hap dena lwak, ‘Zi jal-jal makan sa nëblal’– zen kïtak nabakam sa ki jower.” ");
INSERT INTO ury_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ki zep ding nulblik, “Bian, emki aken. Awe nëbokna dan.” Ki zep ding gulzimki, “Sya. Otan bahem ëgun.” ");
INSERT INTO ury_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesus ki zep Yerusalem kon zaitun tra nabare kwatap tek san dep golësek gweka– men kirekam Zëna golëgwë gwekake. ");
INSERT INTO ury_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kim golëyaïng gwe seka, zao zep gubiridaka, “Alapsa e-en e-enkam abe la tinek. Kareknak ema altïlïnk.” ");
INSERT INTO ury_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Zëna kim engka en zëbon mae onakon langa gwe halka, zao zep boklena kom soka, dekon zep Alapsa gu sone gweblaꞌanka, ");
INSERT INTO ury_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Bian, Em de dwam gwenkam, Abon onakon langa gulsuk– karek yala in zen Abon onak dep golek de gweꞌan zalye. Hwëna ano dwam gwibin sin bap zen lwan. Diki ere mo dwam gwibin sin zen lwan.”  ");
INSERT INTO ury_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Alap mo dam taha nakore zini ki zep zë hata zaka, zao zep sosonna golblaka. ");
INSERT INTO ury_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Hwëna enlalana man sërkam tangan dowebla hanaka, dekam zep etan enlala zon tasïblïn naban ola gu soneblaꞌanka, hëndep irse gwenna kal makare nik wet soblak. ");
INSERT INTO ury_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Alapsa de abe ta gwenna kim hya gwesïkï, ki zep dan-ahare zini in osan dep lwahal zaka. Hwëna ni truwennak zep hlauludaꞌan zaka. Embwan zë mamkam hlauludak, zep truweꞌak. ");
INSERT INTO ury_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Zao zep gubirida zaka, “Em bap nini truwer. Em luk tan. Kareknak dikim altïrïn srëm hap em Alapsa abe tan.” ");
INSERT INTO ury_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus kim nama ola tonꞌanka, dua-blaskam de zini in mo ahana, Yudas, ki zep zi beyam-bya naban golëyaïng gweꞌan zaka. 52bAhakon Alap mo golak de syal tan zi mo mam-mamna, hen zao de jana nabare zini, hen Yahudi mo nol-nola ban. 47bYudas ki zep zë Yesussu babang taꞌan zaka. ");
INSERT INTO ury_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesus ki zep hwëna gubluka, “Yudas, em san babang tankame ngatan zi mo lang nakore Zi Tanganna Asa zerguꞌura?” ");
INSERT INTO ury_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hwëna seblaskam de zëre hon ang ta gwen wenya in, kim zë kirekam hla nuꞌik, dekam zep dakensïblïk, “Bian, san angkam nëbokkam nen tobe gwen?” ");
INSERT INTO ury_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hwëna ahana dekam zep nëbokna mol ineka, dekam zep Alap mo golak de teipsïn tangan zi nik de babu gwe-gwen zini sap zïp soka. Hwëna dam san de ing ala en naka zep blansïblï kïnïka. ");
INSERT INTO ury_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Hwëna Yesus ki zep jalse gweblaka, “Bahem! In sya!” Zëna ki zep ing alana insa dawem soblan hap towanzim-blika, dekam zep hëndep dawem nëblak. ");
INSERT INTO ury_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ki zep hwëna in zen Zënaka de balk tan hap yaïng gwezak gubiridaka, “Em san Asa jal zisie hla lal, zebe nëbok te tek teiredan naban yaïng gwenan zalye? ");
INSERT INTO ury_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ëe men yakla jamkam Alap mo golak emsa tawa ta gwibik! Dekam ba habe zë Asa balk la srëm gwek? Hwëna angkam lang kawesïnnïk awe ebe mae hap man dakastïlzimꞌin, sap dowal mo kïgï mo enlala kawesïn emsa trï tasibiꞌira.” ");
INSERT INTO ury_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ki zep hëndep balk dahak– Alap mo golak de syal tan zi mo teipsïn zi mo gol san dep. Petrus lun sap-sap gwen daꞌanka. ");
INSERT INTO ury_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Dekam zëwe de syal ta gwen wenya gol tëmnak syauknu bla dasïꞌïk– desa de tuwirin hip. Petrus zao zep hen nikinꞌin zaka. ");
INSERT INTO ury_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Hwëna zëwe de babu gwe-gwen we zep syauk ngatannak de nikirinnik tame tazak. Zao zep lalak tasïn hïp karatda taꞌak, ki zep zë hëndep gubluk, “Zini an deban apdenak ë gweka!” ");
INSERT INTO ury_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Hwëna Petrus ki zep kon ding gulbirki, “Zini in ëe homë mae tame taꞌan.” ");
INSERT INTO ury_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hom holo gweꞌak, ki zep etan ahanik tame ta zaka, zao zep gublu zaka, “Em an zen ahana!– desa de ang gwe-gweblan zi niye.” Petrus ki zep ding gulbluka, “Ëe an zen hom.” ");
INSERT INTO ury_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yakla nwena san ha aha-en tamanka, dekam zep ahanik ol drakkam gu ane gweꞌanka, “Eiwa, zini an desa de ang gwe-gweblanna, sap zen an hen Galilea wal!” ");
INSERT INTO ury_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petrus ki zep ding gulbluka, “Ëe homë tame guꞌun– in zebe ki gu gweꞌaraye!” Hëndep in kim nama tonꞌanka, ayangna ki zep gu aneka. ");
INSERT INTO ury_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yesus ki zep Petrussu de hla tan hap lero gweblaka. Petrus dekam zep hwëna etan enlala gweka– mensa anakan gu-gublukaye, “Namen ayang de gun srëmnak, em dan-ahan sonkam esa Asa zabeblala.” ");
INSERT INTO ury_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Dekam zep hëndep wet soka. Gosa zep kon yusyustïn nïban gwë song gweka. ");
INSERT INTO ury_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Zini in zen Yesussu kara daꞌak, man swrë da gweꞌak hen dangole gweꞌak. ");
INSERT INTO ury_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nwe hëreblan naka zep dakensïk gweblaꞌak, “Eme eiwa Alap mo zer sonen zi gwëꞌanam, emaka anakan asa gubirida gweꞌara, ‘Zi bosena zen asa lek tyanda.’” ");
INSERT INTO ury_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Etan kirekam-kirekam ol lamang naban swrë da gweꞌak. ");
INSERT INTO ury_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kim lïtïꞌïk, Yahudi mo nol-nola, Alap mo golak de syal tan zi mo mam-mamna, hen Musa mo ol tawa ta gwibin zini dekam zep tagal gwesïk, ki zep hwëna Yesussu zëbon mae onak dep nër halzak. ");
INSERT INTO ury_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ki zep zë nenblak, “Dekam asa gubirida: Em an san ha eiwa Alap mo Dam Tasïnnï?– Israelsa de ngaya tabin hip Dena.” Ki zep ding gulzimki, “Ëe emsa gubiridaꞌak, em molye ëtaïblïk. ");
INSERT INTO ury_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Hen Ëe emsa takensibiridaꞌak, em molye ap ding ulblik. ");
INSERT INTO ury_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Hwëna molya holo gwek, ngatan zi mo lang nakore Zi Tanganna Ëe dekam asa Soson Zini Alap mo dam taha nakon nikin.” ");
INSERT INTO ury_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ki zep dakensïblïk, “Ki, em san Alap mo Tane?” Ki zep ding gulzimki, “In eiwa denakae ëgunun.” ");
INSERT INTO ury_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Dekam zep ëguk, “Nen ba hap de ahasa takensibiridan hap? Nën mes em-am kïtak Alapsa de lamang tannak asalblanan!” ");
INSERT INTO ury_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ki zep Yahudi mo sinodenak de teipsïn-teipsïn wenya ëzauk, dekam zep Yesussu teipsïn zini Pilatus osan dep nërhak. ");
INSERT INTO ury_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ki zep nenblak, “Zini an ëe mesë dam lasïk: Karek san dep zen zini lup gulhal gweꞌara. Zen man tawa ta gwibirida, ‘Romak de teipsïn tangan zi mo dwam gwibin sin bahem ang ta gwen– pajak te-alasa de kap ta gwizimdinkimye.’ Zen man hen zënaka gu gweblanda, ‘Ëe an Emsa de ngaya tabin hip de Zini Zen– mensa ëgu-guk gwekye. Ëe an Zen– eno mae mo Teipsïn nïye.’” ");
INSERT INTO ury_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatus ki zep takensïblïka, “Em an san ha eiwa zen– Yahudi mo teipsïn nïye?” Ki zep ding gulbluka, “In kirekame gunda, zen kirekamke.” ");
INSERT INTO ury_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ki zep Pilatus Alap mo golak de mam-mam wenya hen tïngare zi trana insa gubiridaka, “Ëe homë zini an mo karekna hlaulblunan.” ");
INSERT INTO ury_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Hwëna zen dekam anakan ëasas gwesïkhal gweꞌak, “Zëno tawa tabinni in dekon ëïlman gwe song gwe-gwenan. Galilea kon ki kon gweka, hëndep Yerusalem mo langna mes sul soneka, hëndep angkam mes awe hata zala.” ");
INSERT INTO ury_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatus kim kirekam salbiridaka, ki zep takensibiridaka, “An san Galilea wal?” ");
INSERT INTO ury_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ki zep ding nulblik, “In eiwa, Galilea wal.” Dekam zep Herodes osan dep zer soneka, sap Galilea, zen Herodes mo ïrïk gïnnï. Herodes zëna dekam Yerusalemk gwëꞌanka. ");
INSERT INTO ury_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes man tangan Yesussu de hla tankam sam gwesïkï, sap zen orep mes zëbe hap dena sane gwe-gweka. Zep man sap hla tan hap dwam gwe-gweka– hen zëno owas syal gwibinsi de hlaun hup. ");
INSERT INTO ury_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","In zep sap Herodes beyakam taken-taken gwe-gweblaꞌanka, hwëna Yesus hom tangan ding gul gweblaꞌanka. ");
INSERT INTO ury_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Hwëna Alap mo golak de syal tan zi mo mam-mamna hen Musa mo olsa de tawa ta gwibin zini men zen Yesussu nërtïlzïk dekam Yesus mo karek-karekna beya tangankam Herodes Bak hap ol drakkam deiri nul guk gweblaꞌak. ");
INSERT INTO ury_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Dekam zep Herodes zëre mo jana nabare zi niban Yesussu ziswrë ta gweꞌanka hen zilamang ta gweꞌanka. Ki zep hwëna teipsïn zi hip de baju dawemna ala nosoblak– deban de anakan swrë ta gwen hap, “Dawem, bian. Em in zen– Yahudi mo teipsïn nïye.” Deban zep etan Pilatus osan dep nër sonek. ");
INSERT INTO ury_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Yaklana dekam zep Herodes ne Pilatus ne, orep men zen zënaka gïl-gïl ei gwizimki, etan dokot ëka. ");
INSERT INTO ury_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatus ki zep tagal gulsuku– Alap mo golak de mam-mamna hen Yahudi mo nol-nola, hen zi trana insa, ");
INSERT INTO ury_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ki zep zë gubiridaka, “Em ansa zini abon onak dep anakare ola ban ërhalzal, ‘Zen man zisi karek san dep lup gulhal gweꞌara,’ eno mae mo nwenak ëe mesë sap takensïk gweblasan, hwëna ëe homë mae zëno karekna hlaulblunan– men kirekam em enblalye. ");
INSERT INTO ury_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hen kirekam Herodes. Zen hen hom karekna hlaulblula, sap zen totoresa etan nëbon mae osan zer sonera. Eiwa, zen hom mae karekna golka– dekam de tan hapye. ");
INSERT INTO ury_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Zep ëe asa lek-lek tan en hap gubiridal, ki asa zeser soner.” ");
INSERT INTO ury_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kïtak de zi beyam-byana in ki zep ëgu anek, “In lak! Barabassa ap hïl tï sonezim!” ");
INSERT INTO ury_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas in Roma mo ïrïk gïn nïkon zisi hlïl inꞌinka, dekam zep golëïlman gwenkam zisi zitaka. In zep bwinak tak daink. ");
INSERT INTO ury_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatus Yesussu de zeser sonen hap sap dwam gweka, in zep sap etan kirekam ol mamkam gubiridaka. ");
INSERT INTO ury_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Hwëna dekam tangan zep ol nop-nopkam ëgu ane gweꞌak, “Desa te-lidak sonnak makan laink! Te-lidak sonnak makan laink!” ");
INSERT INTO ury_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ki zep etan dan-ahanna gubiridaka, “Hwëna zëno karekna homke!– dekam de tan hap denaye. Ëe hom am aha-en mae hlaulblunan! Ëe asa sapꞌnen lek-lek tan hap gubiridal, ki asa hïl tï soner.” ");
INSERT INTO ury_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Hwëna zen ki zep ol nop-nopkam te-lidak sonnak de makan ta irin hip ëgu ane gweꞌak, hëndep dekon Pilatus hom etan zëno mae mo ola esek gulzimki. ");
INSERT INTO ury_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ki zep hëndep zëno mae mo gun sun tapbla tazimki. ");
INSERT INTO ury_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Dekam zep hwëna zini mensa zëna abe nëblak, desa zeser sonezimki– mensa golëïlman gwenkam de zi tan hap bwinak tak da inkke. Hwëna Yesussu zep zëno mae mo dwam gwibin sin dikim syal gwibin hip tapbla tazimki. ");
INSERT INTO ury_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yesussu ki zep nërhak. Oranak zep Kirene walya Simonsa nërtoweꞌak. Zen man Yerusalem san dep lwa haꞌan zaka. Zao zep balk dak, ki zep tik-tik dak– Yesus hup de te-lidak sonna insa de hwëna Yesus zëre hon zikong gwe hendan hap. ");
INSERT INTO ury_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Zini beya nik hen ang tan daꞌak. Ahakon we walya gosa dablan daꞌak hen aïtïn-aïtïn nëblaꞌak. ");
INSERT INTO ury_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesus ki zep we walya insa lero gwibiridaka, zao zep gubiridaka, “Yerusalem we wal, bahem Asa gona gwëblan. Diki ere mae mo timsi em gweibin, hen walas omka em gweibiridan. ");
INSERT INTO ury_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sap yaklanak sa hatal– zi de anakan gun hup, ‘Dawem tanganna, we wal de u gwensa akasïn srëmna, hen ëwalas gwen srëmna, hen momkam de walassa taïzïn srëmna. Sap Alap mo jala nabakam sa hatazal.’ ");
INSERT INTO ury_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Dekam zini sa aïrïn hïp kwatap-kwatapna nahërhebirida gwer, ‘Asa em kei-king gun! Asa em ani-ning gun– ëe de Alap mo jala ansa hlaun srëm hap.’ ");
INSERT INTO ury_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Angkam de zini em an walas mo kime angkam jala tame uꞌin, hwëna kire nikeki Asa ëblaꞌan. Hwëna zi mo jal-jala sa ta gwese zaher, hëndep sa tangan taman kïnïl. Hwëna zao sa Alap mo jala hatazimzir.” ");
INSERT INTO ury_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Hen karek gol gwen zi darena man deisyak– apdekam de Yesus mae han tameran hap. ");
INSERT INTO ury_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Lang tek bosena Zi Nol Swrak kim yaïng gwesek, zao zep jana nabare zini Yesussu te-lidak sonnak makan daink. Karek gol gwen zi darena insa hen man makan nosoink– ahana Yesus mo dam taha san dekam, ahana irgwa taha san dekam.  ");
INSERT INTO ury_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesus ki zep ola gu soneka, “Bian, zini an zen Asa karek danan, zëno mae mo karekna ansa tap gulsuzim, sap zen hom tame nuꞌin– an desa zëna syal neibiꞌinye.” Jana nabare zini in ki zep hwëna zëno pakeanna dobe abu mo kim de zënaka dam tasïk gwibinkim kae nëblandak. ");
INSERT INTO ury_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","In kim ki zë kirekam lwaꞌak, zini beya nik zë hen kara dabiꞌik. Yahudi mo mam-mamna hen man zë durum gwehek. Zen hen Yesussu anakan swrë da gweꞌak, “Zen aha zi ensa ngaya ta gwibirki. Zen de eiwa Alap mo Dam Tasïnnï, Israelsa de Zen ngaya tabin hip, ki Zen ki angkam Zënaka ngaya tan!” ");
INSERT INTO ury_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ki zep hen jana nabare zini swrë daꞌak. Zen anggur ho eteksa noltrë seblazak, ");
INSERT INTO ury_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","deban zep zë nen seblak, “Eme eiwa Yahudi mo teipsïn zisi, emki enaka ngaya tan!” ");
INSERT INTO ury_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Te-lidak sonna iwe nol bol tahan nakon man anakarekam de alena makan nulink, “An zen– Yahudi zi mo teipsïn nïye.” ");
INSERT INTO ury_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aha karek gol gwen zini mensa Yesus mae han makan dabirink, zen Yesussu anakan hen lamang taꞌanka, “Em san zisi de ngaya ta gwibin hip de Alap mo dam tasïn Zisi hom?! Emki nënaka ngaya tabin!” ");
INSERT INTO ury_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Aha zi nik zep jalse gweblaka, “Em san home Alapsa aïrïblaꞌara? Nëbe mae hap mes ki lwazimnin– tameran hap denaye. ");
INSERT INTO ury_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Hwëna nëbe nikip dena, nëre nik mo karek-karek nakon ki lwazimnin. An hwëna hom tangan karekna golka.” ");
INSERT INTO ury_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ki zep Yesussu gubluka, “Asa enlala gwebla– Em de ïrïk gïn hïp lwahal zankamye!” ");
INSERT INTO ury_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ki zep ding gulbluka, “Ëe ama emsa gubluꞌan: Namen hëꞌho gwibin langnak eban esa apdekam ëra.” ");
INSERT INTO ury_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Yaklana kim bolak zauku, dekam zep tïngare langna owas hap kawesïk. Hëndep yakla nwena kim dan-ahannak zauku, dekam zep etan hleng gwek. ");
INSERT INTO ury_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Alap mo gol mwanak de kaen lïlïkïn glaïng-glïng yawala dekam zep owas hap kalk neisïk sonek. ");
INSERT INTO ury_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesus ki zep hwëna ol mamkam hërhe hanaka, “Bian, Ëe ëre mo angna eno tahanakë drë neꞌan!” Kirekam kim gu aneka, ki zep hëndep tïlsïkï. ");
INSERT INTO ury_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jana nabare zi mo mamna in zen zë kara taꞌanka, dekam zep Alap mo bosena anakare ola ban teip gulsubluꞌanka, “Zini an eiwa kareksa de gol gwen srëmna.” ");
INSERT INTO ury_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Zi beyam-byana men zen kara tan hap yaïng gwezak, kim zë kirekam hla nuk, dekam zep go naban anakare enlala naban lwan dahak, “O ëe ba habë ola mas gul– zi dawemna insa de tan hapye!” ");
INSERT INTO ury_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ahakon men zen Yesussu nërgwë gwek, hen we walya men zen Galilea kon ang nëblazak, zen langa nakon ëzauꞌuk. Dekon zep hen kara nuꞌik– in zen ki zë lwaꞌakye. ");
INSERT INTO ury_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Yahudi mo aha ëna Arimatea walya Yusup, zen zini dawem tanganna, hen zini man desa blikip neisïk gweblak. Zen man tangan Alap de kïtak nabakam ïrïk gïlzïn hap hohle gweꞌanka. Zen sap Yahudi mo teipsïn sinodenak de aha mamna, hwëna zen hom Yesussu de tan hap de ol aha-en gunnuk ola mas gulku. ");
INSERT INTO ury_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yusup ki zep Pilatus onak dep song gweka– Yesus mo tok naka dikim lo tasïn hïp de abe tan hap. Dekam zep gubluka, “Amki.” ");
INSERT INTO ury_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Dekam zep zizeryahe halka. Kaen ngap-ngap blalkam zep zitahaleka, ki zep hwëna kaso hul hamal gun ësenak zidrë neka– aha zisi de zë drënen srëmnak. ");
INSERT INTO ury_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yaklana in Jumatkam, hen man kam-en gweꞌak, zep Hari Sabatnak dikim hatan hap aha-ere jam maekam hom lwaꞌak. ");
INSERT INTO ury_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","We walya men zen Yesussu Galilea kon ang nëblazak, zen man Yusupsu nërtrok. Kaso hula insa man hla nuk, hen zidrë nennak man kara dabiꞌik. ");
INSERT INTO ury_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ki zep lwan dahak, hwëna dekam zep irase dawem nabare kire-kirena hamal nuk– Yesus mo tok naka dikim dra tandan hap, hen ahakorena kaen mwa san de kang tanun hap. Hari Sabatnak, syala dekam man nolzausuk– men kirekam Musa tïtï ta gwibirkike. ");
INSERT INTO ury_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Hari Minggukam kak tangannak, ki zep we walya in sek gwek– Yesussu men zao nën nekke, desan dep. Irase dawemna bare kire-kirena insa hamal nuk, desa man kap dak. ");
INSERT INTO ury_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kim yaïng gwek, ki zep hla nul kïnïk, “Lïlïkïn hïp de kaso yala insa mes irhi nul kïnïl.” ");
INSERT INTO ury_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kim zë bïtï gwek, hwëna Bian Yesus mo tokna hom zë hla daonk. ");
INSERT INTO ury_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","In kim zë ëzauꞌuk, dekam hom anakan dam nulsuꞌuk, “An banakarekam zë lwal?” Ki zep zë hwëna mumuk ennak zi darena zëno mae mo alpnak jo kë zaka. Zëno nik mo pakeanna angtan-angtanna– san de nglï angna kiye. ");
INSERT INTO ury_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ki zep zë mamkam ëaïrïꞌak, dekam zep kamanak ëutuk gwehek. Zi darena in zao zep enbiridaka, “Em ba habe ngaya Zini insa tïn zi kang gul gwennak lëblaꞌan? ");
INSERT INTO ury_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Zen awe hom. Bian Alap mes tïn nïkon ngaya tala. Emki ëenlala gwen– mensa Galileak anakan emsa tawa ta gwibirkike, ");
INSERT INTO ury_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Ngatan zi mo lang nakore Zi Tanganna Asa sa karek gol gwen zi mo tahanak dep tapbla dazim. Zen sa Asa te-lidak sonnak makan dain. Hwëna yaklana dan-ahan, dekam asa etan tïn nïkon ngaya gwer.’” ");
INSERT INTO ury_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","We walya in dekam zep enlala neibik– Yesus mo tawa tabinni insa. ");
INSERT INTO ury_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kim lwan dahak, dekam zep in zen seblaskam zëre hon ang ta gwek, hen zëno mae mo ahakorena, desa kïtak donbiridak. ");
INSERT INTO ury_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","In zen donbiridaꞌak, zëno mae mo bosem-sena, Magdala kore wenya Maria, Yohana, hen Yakobus mo anena Maria. Ahakore we walya hen ki– in zen sek gwekye. ");
INSERT INTO ury_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Hwëna zëre hon de ang ta gwen wenya in hom daïblïbiridak. Man enlala neibiridak, “An man ëmamak gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Hwëna Petrus ki zep luweka, hëndep ki zep hluweka– men zao nënnek, desan dep. Kim zë hata naka, ki zep huwe hanankam ake inki, hwëna kaen ngap-ngap enna insa zep zë hlaul inki. Ki zep enlala topse gwen naban etan lwa halka. ");
INSERT INTO ury_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yaklana inkam, aha zi darena men zen hen seblaskam de Yesus hon ang ta gwen wenya ban apdekam lowe heꞌak ki zep song ëꞌanka– ëna Emaus sun dep. Zen Yerusalem kon langana seblas kilometer enkam. ");
INSERT INTO ury_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","15","Zen man lonnaraꞌanka– tïngan in zen ki zë jowekke. Hwëna Yesus Zëna dekam zep teisyalahe zaka, dekon zep apdekam zisong gweka. ");
INSERT INTO ury_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Man sap hla laka, hwëna banakan mes yap zë gweizimki, zep tame la srëm gweka. ");
INSERT INTO ury_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ki zep Yesus takensizimki, “Em ba olsae lonnara sara?” Dekam zep nwe-mase dowe hanan naban yausuku. ");
INSERT INTO ury_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Zi darena in ahana bosena Kleopas. Zen zep takensïblïka, “Em san an aha-en zen mes yap?– ola ansa de san srëm naye. Kïtak Yerusalemk de lowehen wenya mes ëtawa gwek– in zen ki nër hom jowekye.” ");
INSERT INTO ury_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Dekam zep ding gulbluka, “Ba zë jowek?” Ki zep hwëna ding ulblika, “In zen Nazaret walya Yesus hon jowekke. Zen Alap mo olsa de ayang gul gwen zi. Zëno syala man tangan soson gwe-gwek, hen zëno ola man sam gwesïk gwek– Alap mo nwenak hen tïngare zi mo nwenakye. ");
INSERT INTO ury_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Hwëna nëno mae mo sinodenak de teipsïn-teipsïnnï, hen Alap mo golak de syal tan zi mo mam-mamna dekam zep tan hap nenblak, in zep hëndep Roma mo jana nabare zini te-lidak sonnak makan daink. ");
INSERT INTO ury_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Hwëna ëe mesë enlala ë gweblak, ‘An zen sa Israelsa hïl gïl sonera!’ Tan hyanak, namen yaklana mes dan-ahan nër. ");
INSERT INTO ury_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Hen namen kaknak ëe we walsaë auna ohlobiridal– aban mae de Yesus hon ang ta gwen we walsya. Zen yakla hata sezan naban sek gwer– men zao nër dwanukke, desan dep. ");
INSERT INTO ury_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Hwëna zen hom zë Yesus mo tokna hla dal. Zen zep asa nenbiridazal, ‘Ëe Alap mo dam taha nakore zisië nwe nik de ëlirisin gwenkam aker. Zen man asa enbiridala, “Yesus mes ngaya gwera.”’ ");
INSERT INTO ury_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Abon mae onakon ki zep zi hwëna nolësal kïnïl– zën de hen hlaun hup. Ki zep zë hla nul– men kirekam we walya asa nenbirida zalye. Hwëna zen hen hom zë Yesussu hla dal.” ");
INSERT INTO ury_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesus ki zep ding gulzimki, “Em in enlala joblo-topna! Em bëjen em nabakam laïblïbin– mensa Alap mo ol ayang gul gwen zini tawa da gwibikye. ");
INSERT INTO ury_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Zen man tawa da gwibik, ‘Alap mo dam tasïn Zini, zisi de ngaya tabin hip Dena, zen nonol kareksa de goltowen. Ki sa hwëna hyanak teipsïnkïm nikiri.’” ");
INSERT INTO ury_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ki zep tïngan srip gulsuzimki– ola mensa zëre hap dena ale nul gwekye. Nonol Musa mo ol ale gun nukon kon gwisibir hanaka, hëndep Alap mo ol ayang gul gwen zi mo alesa srip gulsuzimki. ");
INSERT INTO ury_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ëna men zao dep zi darena in song ëꞌanka, zëwe kim ëgolek de gweꞌak, hwëna Yesus dekam zep ëna insa de tamaran makan sap gweizimki. ");
INSERT INTO ury_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Hwëna man tïtï laka, “Bahem tamaran. Aban mae neik truwek. Angkam man kawen hap golek de gweꞌan.” Zao zep ki hëndep seweka. ");
INSERT INTO ury_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kim tembane hap teinikin anek, Yesus ki zep rotina gul ineka, ki zep Alap hap rotina in hap dawemna golblaka. Ki zep ahap gul guku, dekam zep zëbe nikip dena teisyazimki. ");
INSERT INTO ury_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hëndep dekam zep zëno nik mo nwena hleng neizimk, “O an Yesus suke!” Hwëna Zen dekam zep zëno nik mo nwe nakon aya gweka. ");
INSERT INTO ury_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Zao zep zënaka enzimki, “Ëe ëre mo ennak ben-ben nakaë eisbirzir– in kim Zen Alap mo ola nëp oranak srip gulsuzim song gwesan zalaye.” ");
INSERT INTO ury_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ki zep hëndep lu këka dekam zep kam etan Yerusalem san dep ola halka. Zao zep etan hla kulidaꞌanka– seblas enkam de wenya insa hen ahakore naban, men deban mae zë apdenak lowe heꞌakke. ");
INSERT INTO ury_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ki zep zi darena insa nen guzimk, “In eiwa, Bian Alap mes tïn nïkon ngaya tala! Zen mes Simon hon Zënaka zertrëra!” ");
INSERT INTO ury_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Zi darena in ki zep hen aïsïl eibiridaꞌanka– men kirekam oranak zëbon nebon joweka, hen roti kwa-kwak gunnuk kim anakan tame laka, “An Yesus suke!” ");
INSERT INTO ury_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Zen kim nama kirekam lonbiridaꞌanka, dekam zep Yesus Zëna zëno mae mo ngïrïnnïk etan jowe zaka. Zao zep gubiridaka, “Dawem. Em Alap mo taha terenake lowe heꞌan.” ");
INSERT INTO ury_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ki zep auna ëhlok hen ëaïrïꞌak. Man tim dik, “An zi au!” ");
INSERT INTO ury_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Hwëna ki zep gubiridaka, “Em ba habe ëaïrïꞌan? Bahem ëtaïblï srëm gwen. ");
INSERT INTO ury_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Emki taha-tananak Asa hla tan– dekam de Asa tame tan hap, ‘An Zen tangan.’ Asa emki olk tan– dekam eka Asa tame lak. Zi auna hom eini hen danna– an kirekam Asa hla lanan.” ");
INSERT INTO ury_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","In kim kirekam gubiridaka, ki zep zëre mo taha naban tana naban zitreizimki. ");
INSERT INTO ury_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","In kim isrip-sri hap ëtaïblï srëm gweꞌak hen denggwanblaꞌak, ki zep takensibiridaka, “Eno mae mo tembanena awe wëe?” ");
INSERT INTO ury_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ki zep hogwe ang gun kwakna nolblak. ");
INSERT INTO ury_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ki zep gul inki, ki zep hëndep zëno mae mo nwenak twinbiꞌinka. ");
INSERT INTO ury_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ki zep gubiridaka, “Ëe men kimë nama emsa golëlowehe gwek, Ëe sap mesë dekam hamal hap emsa anakan gubirida gwek, ‘Abe hap dena mensa kïtak ale nuk, Musa mo olak, hen Alap mo ol ayang gul gwen zi mo olak, hen Mazmuruk, zen kirekam sa ki hëndep lwal.’” ");
INSERT INTO ury_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kirekam kim gubiridaka, dekam zep zëno mae mo enlalana Alap mo olsa dikim tame gul gwen hap ngatan tazimki. ");
INSERT INTO ury_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Zao zep gubiridaka, “Alap mo olak man ale nuk, ‘Tïngare zisi de ngaya tabin hip de Zini, Zen nonol kareksa sa goltowera, hwëna yaklana dan-ahan ki sa etan tïn nïkon ngaya gwera.’ ");
INSERT INTO ury_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Hen man ale nuk, ‘Zëno bosekam sa tïngare zi ausu hap ol dawemna nolzim halada gwer– zen dikim zëre mae mo karek-karek nakon ëhalen hap, hen zëno mae mo karek-kareksa dikim tap gulsuk gwizimdin hipye. Nonol tangan Yerusalem kon sa kon neisibir hanal.’ ");
INSERT INTO ury_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Em an zen– nonol gol halada gwen hap de wenyaye. ");
INSERT INTO ury_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ëe asa ep zer sonezim– mensa ano Bianna emsa gu-gubirida gwekake. Ëna an en kon ësblak– hëndep Alap onakore sosonna in de ebon mae onak ing gwe heꞌan zaka.” ");
INSERT INTO ury_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Aha yaklakam ki zep Yesus golësek gweka– hëndep Betania. Zao zep tahana teisya ineka, ki zep zë anakan dawemna golzimki, “Amki Alap onakore dawemna hla kul gwek.” ");
INSERT INTO ury_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","In kim ki zë kirekam gweibiridaꞌanka, ki zep zë hëndep Alap zer ine halka. ");
INSERT INTO ury_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Dekam zep bokle kom soblan naban bosena teip nulsubluꞌak. Dekon sërkam de isrip-sri naban zep Yerusalem san dep lwan dahak. ");
INSERT INTO ury_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Zao zep Alapsa de isrip-sri gwe-gweblan hap Alap mo golak hen-henkam lowehe gwek.");
INSERT INTO ury_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ol aïsïlï an Kristus Yesus hup dena. Nonol lone sennak, okamana ansa de yang gulsun srëmnak, Zini in mes gwëka. Zen Alap han ë gweka, hen Alap han man apde ëka. Zëno bosena “Alap onakore ëngaya gwen hap de Ol.” ");
INSERT INTO ury_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Zen nonol lonesen nakon Alap han ë gweka. ");
INSERT INTO ury_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Zen Zen kïtak Alap mo gun sun yang tasibirki, hen hom tangan– aha mo yang gulsun nuye. ");
INSERT INTO ury_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ëngaya gwen hap de ausuna zen Zëbon onak. Zep zini ëngaya gwen hap dena Zëbon en nulin gwenan, dekam zep enho nakon ëngatan gwe-gwenan. ");
INSERT INTO ury_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Zëno ngatanna in okama kawesïnnïk awe zïl ine gwenan. Kawesïnnï man sap ngatanna insa husus gwe-gwibirin, hwëna ber-ber gunnu banakan dep? ");
INSERT INTO ury_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ki zep hwëna Alap zini zer soneka, bosena Yohanis. ");
INSERT INTO ury_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Zen ngatan nabare Zini in hap de olsa tïngare zi hip golngeir guzim zika– dekam de zëno ol toran nakon taïblïblan hap. ");
INSERT INTO ury_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohanis zen ngatansa de golzimdin hip de Zisi hom. Zen hwëna zëbe hap de olsa de zi hip ayang gul gwizimdin hip de zi. ");
INSERT INTO ury_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Dekam tïngare zi hip de ngatansa golzimdin hip de Zini man hatan hap golek de gweꞌanka. ");
INSERT INTO ury_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Zep ëngaya gwen hap de ola bare Zini in okamanak awe orep mes gwëka. Zen sap Zen okamanak de zisi yang tasibirki, hwëna hom tame dak. ");
INSERT INTO ury_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Zen zëre mo hlïl irin zini Israel hon hata zaka, hwëna beya nik hom neirink. ");
INSERT INTO ury_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Hwëna men zen en daïblïblak, zen en zep neirink. Zëbe mae en hap zep dekam de Alap mo walas hap ëjowen hap dena golzimki. ");
INSERT INTO ury_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Zen auhu-kama zi mo wë tan en nakon hom Alap mo walas hap ëjowek, ahaksa zi zëre mae mo dwam gwibin nikon, ahaksa zi mo syal gwibin nikon. Hwëna Alap Zën zëre mo walaskam dikim ëliwehen hap kwang guludaka. ");
INSERT INTO ury_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Zep ëngaya gwen hap de ola bare Zini in zi tangan hap jowe zaka, hëndep nëban mae golëgwë gweka. Ëe ama Desa anakan kara la gwek, “Eiwa, zëno sosonna ngatan zi mo lang nakorena. Sosonna in Bi zem onakorena, sap Zen an Zen– zëre mo Tane aha-ere naye. Zen taïblïblan tanganna hen kwasang-kwasang enna.” ");
INSERT INTO ury_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanis kim hla taka, dekam zep zëbe hap dena ol mamkam anakan gubiridaka, “An Zen– asa de zertrozan Zi niye, mensaë anakan gubirida gwekke, ‘Men Zen de asa zertroꞌan zaka, Zen mamna. Ëe an betekna. Sap asa de jaha gwen srëmnak, Zen orep mes gwëka.’” Kirekam Yohanis ol mamkam gubiridaka. ");
INSERT INTO ury_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Alap mo Tanena in, Zen kwasang-kwasang enna, zep Zen etan-etankam nëbe mae hap dawemna gol gwizimnira. ");
INSERT INTO ury_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Sap Alap onakore tïtï tabin ola, zen Musa Bak nëp ayang gulzimki. Hwëna Alap de nësa totoresa kwasang gwibirida gwen hap de ol dawemna, zen Kristus Yesus nëp golhatazim zika. Ol dawemna in, zen eiwa de tangan naye. ");
INSERT INTO ury_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Zini hom tangan Alapsa hla dak. Hwëna zëre mo dang tïnïnak de Tanena, men Zen aha-en zëre mo alpnak gwë gwenda hen apde ëka, Zen mes Bi zikhip dena nëbe mae hap ayang gulzimki. Zen hen ki Alap. ");
INSERT INTO ury_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yohanis kim hamal hap tonbirida gweka, dekam zep Yahudi mo mam-mamna Yerusalem kon zini lup nul sonek– zen de Yohaniꞌi takensïblïn hap. Zen Alap mo golak de syal tan zisi hen Lewi Bak mo ausu nakore zisi lup nul sonek. Kim yaïng gwezak, ki zep dakensïblïk, “Em san ha an Zen?– mensaë kara ë gweblananye.” ");
INSERT INTO ury_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohanis dam-dam enkam zep zënaka kira taka, “Ëe an nënaka de ngaya tabin hip de Zisi hom.” ");
INSERT INTO ury_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ki zep etan dakensïblïk, “Ki em nara mo weinak dep de zi? Em san ha diki Alap mo olsa de ayang gul gwizimdin hip de zini Elia Bak Swe? Hwëna angkam Yohanis mo bosekame etan hataꞌan zala.” Ki zep ding gulzimki, “Ëe an zëno weinak dep hom.” Ki zep etan dakensïblïk, “Ki san ha em Musa mo weinak dep de Alap mo olsa ayang gul gwizimdin hip de zi?” Ki zep ding gulzimki, “Kirekam hom.” ");
INSERT INTO ury_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ki zep dakensïblïk, “Ki em an nara mo weinak dep dena? Em de enaka kira tan srëmkam, ki hwëna men zen asa lup nul sonek, ëe banakan asa enbiridal?” ");
INSERT INTO ury_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohanis dekam zep Alap mo olsa de ayang gul gwizimdin hip de zini Yesaya Bak Swe mo ngein sin dep de ol hli yulzimdin nikon ding gulzimki, “Ëe an ‘zi srëm lang nakon de anakan taken gwen hap de zi, “Haen, nëre mae mo Teipsïnnï kip nen orasa dam-dam tablan– desan deka hata zaka.”’ Ano syala kirekam.” ");
INSERT INTO ury_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","In zen takensïblïn hap yaïng gwezak, ahakon hen Farisikam de gubirida gwen zi hon de bïtï gwenna. ");
INSERT INTO ury_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Zen dekam zep dakensïblïk, “Ki hwëna em ba habe baptis ta gwibi'ira?– sap em ngaya tabin hip de Zisi hom, hen Elia Bak Swe ne Musa Swe nik mo weinak dep de zisi hom.” ");
INSERT INTO ury_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ki zep ding gulzimki, “Ëe an weyakamë baptis ta gwibi'in, hwëna eno mae mo ngïrïnnïk ki gwëꞌara– Mensa ena tame la srëm gweꞌan. ");
INSERT INTO ury_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Zen asa zertroꞌan zala. Hwëna ëe an dawem naka hom– Zëbon onak de babu gwen hapye. Sap zëno tana maesa de ngan sosublunna, ëe toton bëjënë.” ");
INSERT INTO ury_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","In kïtak Betaniak ki lwak, weyana Yordan mo yakla hata sezan san de ënak. Yohanis zen zëwe baptis ta gwibirki. ");
INSERT INTO ury_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kaꞌankam, ki zep Yohanis Yesussu hla ta guku, ki zep gubiridaka, “Ëre wakë emki hla tan. Zen in Zen– Alap mo Domba Tane naye. Zen Zen sa Zënaka sosok tala– tïngare okamanak de zi mo karek-kareksa dikim ngan gulsuzimdin hipye. ");
INSERT INTO ury_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Zen in Mensaë anakan emsa gubirida gwek, ‘Asa de zertrozan Zini, Zen mamna. Ëe an betekna. Sap asa de jaha gwen srëmnak, Zen orep mes gwë gweka.’ ");
INSERT INTO ury_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ëe homë menkam anakan tame taꞌak, ‘An Zen– nësa de ngaya tabin hip de Zini inye.’ Hwëna Alap asa baptis ta gwibin hip dam tasïkï– dekam de Desa Israelk de zi hip zertreizimdin hip.” ");
INSERT INTO ury_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Hen Yohanis insa hlaulku zen dam-dam enkam anakan tonbiridaka, “Ëe ama Alap mo Enhosa hla taser. Mawana ohola mo kim ati gwesan zala, ki zep hëndep ing gwe heblan hap Zëbon zau zula. ");
INSERT INTO ury_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Hwëna Alap mes asa hamal hap anakan gu-gubluka, ‘A dekon esa tame tala: Men Desae hla taꞌanka ëre mo Enho de Zëbon dep ati gwennak hen ing gwe heblannak, Zen Zen sa hwëna ëre mo Enhona inkam baptis ta gwibiri.’ ");
INSERT INTO ury_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ëe hwëna namen mesë ëre mo nwekam hla tal, zen in zebë damnak anakan kira gweꞌan, ‘In eiwa, Zen Zen– Alap mo Tane naye.’” ");
INSERT INTO ury_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kaꞌankam etan baptis ta gwibin zini Yohanis zao gwëꞌanka. Ëe hen zëre hon de ang ë gwen zi darena zaoë ëꞌak. ");
INSERT INTO ury_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Dekon zep Yesussu tamarannak kara ta soneꞌanka, dekam zep etan gubiridaka, “In Zen– Alap mo Domba Tane naye.” ");
INSERT INTO ury_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ëe kimë kirekam asalblak, dekam zebë Yesussu ang ëblak. ");
INSERT INTO ury_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Asa kim ake guku, ki zep lero gwizimdin niban asa takensizimki, “Em basae leibiꞌira?” Ki zebë ding ulblik, “Rabi Bak, eno gwë gwenna endawe?” “Rabi”kam de ol-gunnu, zen Ibrani olkam. Zëno enlalana “guru.” ");
INSERT INTO ury_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Dekam zep asa ding gulzimki, “Haen. En esa ki zë hla kuli.” Dekam zebë ang ëblak, hen ama zëno gwë gwenna hla kuk. Yakla nwena dekam san ha empat enkam, kam-en. Yaklana dekam zep asa zigwëka. ");
INSERT INTO ury_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ëe in zen Yohanissi asalblak hëndep Yesussu ang ëblak, aha zini in mo bosena Andreas Bak. Andreas in, Simon, aha bosena Petrus mo oso. ");
INSERT INTO ury_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Zen ki zep nabal-bakam aya zemka duweblaka, ki zep gubluka, “Ëe mesë Mesiaꞌa ërtowenan!” “Mesias”kam de ol-gunnu, zen hen Ibrani olkam. Yunani olkam enlalana “Kristus,” hen zëno enlalana, “Alap mo zer sonenna– Israelsa de Zen ngaya tabin hip.” ");
INSERT INTO ury_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andreas ki zep Yesus osan dep kwang tahal zaka. Kim zerhata zaka, Yesus ki zep zë nwekam srap tasïkï, zao zep gubluka, “Em in Simon Bak, Yohanis mo tane. Hwëna Ëe ama emsa bose taꞌan ‘Kefas’kam.” “Kefas”kam de bosena in, Ibrani olkam enlalana apdenak– zëre mo Yunani olkam de bosena Petrus hunye. Zëno enlalana “kaso yawal.” ");
INSERT INTO ury_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kaꞌankam ki zep Yesus Galilea mo lang san dep de song gwen hap dwam gweꞌanka, ki zep hëndep song gweka. Zao zep Pilipus Baksa zertoweka, ki zep zë gubluka, “Em Asa ang gwebla.” ");
INSERT INTO ury_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipus in Betsaida wal, hen Andreas ne Petrus ne zao hen ë gweka. ");
INSERT INTO ury_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipus dekam zep hwëna Natanaelsa duweblaka, ki zep zë gubluka, “Ëe mesë ërtowenan– Zini mensa Musa zëre mo tïtï tabin olak hamal hap zëbe hap dena ale gulblukaye, hen mensa Alap mo olsa de ayang gul gwen zini nen guk gweblakye. Zen Nazaret wal, bosena Yesus, Yusup Bak mo tane.” ");
INSERT INTO ury_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ki zep Natanael weha ol makan ding gulbluka, “Nazaret walya san ha ki?– dawem naye.” Ki zep ding gulbluka, “Haen, en neik ki zë hla ta.” ");
INSERT INTO ury_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesus onak kim zerhataꞌan zaka, ki zep gu-gubluka, “An Israel wal tangan. Hwëna zëbon onak hom– zisi de yane-ne tan hap de enlala naye.” ");
INSERT INTO ury_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ki zep Natanael takensïblïka, “Em banakane asa tame tala?” Ki zep ding gulbluka, “Ëe mesë emsa hla tal– Pilipus de emsa kwang tan srëmnak. Tenya ara mo ausunake nikin sira.” ");
INSERT INTO ury_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ki zep ding gulbluka, “Guru, Em in Alap mo Tane! Em in Israel mo teipsïnnï!” ");
INSERT INTO ury_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesus ki zep ding gulbluka, “Na-en tangan ba habe asa taïblïblaꞌara?– owas betek tola an en hapye. Sap Ëe anakare enkamë emsa gublul, ‘Ëe ama emsa tenya ara ausunak hla tal.’ Hwëna em etan mamkam de owassa esa kara guluda gwera– dekam tangan de dawemkam Asa taïblïblan hapye.” ");
INSERT INTO ury_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ki zep hwëna gulk sun de ol blaorankam kïtak asa gubiridaka, “Eiwa tangan nakaë emsa gubiridaꞌan: Em esa nglïsa talusun nuka hla laser, hen Alap mo dam taha nakore zini ngatan zi mo lang nakore Zi Tanganna Abon osan sa tatak gwese gwer, hen Abon osan sa atiti gwe-gwezal.” ");
INSERT INTO ury_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yaklana dan-ahan, dekam zep langna Galilea mo aha ëna Kanak we-zi daresa oto nosoꞌak. Yesus mo anena man zë ang gwek. ");
INSERT INTO ury_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Dekam zep Yesussu hen nenblak– Zen de hen zëre hon de ang ta gwen wenya asa golëang tan hap. ");
INSERT INTO ury_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Anggur hona kim tap gwizimki, Yesussu ki zep an zem gubluk, “Anggur hona mes tap gwizimnira.” ");
INSERT INTO ury_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ki zep ding gulbirki, “Anyan, em bap kirekam Asa gublula. Sap Ëe dikim ëre mo sosonsa goltreizimdin hip denak hom am zauꞌun.” ");
INSERT INTO ury_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","An zem ki zep gola iwe de babu gwen zisi gubiridak, “Ano tanena an de emsa ba mae hap gubiridanna, zen hëndep kire enkam syal eibik.” ");
INSERT INTO ury_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Gola iwe kasokam de drem yawal-yawala ki ërlwaꞌak– enam enkam, seratus liter mo dena. Zen weyasa zë hamal da gwibik– tembane tankam dikim Yahudi mo auyan-aza mo ëpba ol san tahasa su tablanda gwen hap, hen piring-moksa de zë os-os ta ine gwen hap. ");
INSERT INTO ury_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesus ki zep gubiridaka, “Drem-dremna ansa hokam beya labik.” Dekam zep hona tutu dak, hëndep dremna in man ësuwehe kïnïk. ");
INSERT INTO ury_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ki zep etan gubiridaka, “Men zen tagal gwenna awe nol gweꞌarake, emki zëbe hap zeisirbli hanan.” Ki zep hëndep nyeisirblihak. ");
INSERT INTO ury_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Hwëna dremnak de weyana in mes anggur ho hap ëjowek. Tagal gwen hap de nol gwen zini in kim akasibirki, zen hom anakan tawa gwibiꞌinka, “An owas hap ki lwanan,” hwëna babu gwen zini in, zen en mes sap tame nuk. Ki zep we gon hap de zini insa kwang taka, ");
INSERT INTO ury_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ki zep gubluka, “Tembane yawalsa de syal gwibinnik, diki anakan syal nei gwibirin: Nonol te-ala mamkam de anggur ho dëreksa de golzimdin. Hwëna kim dërek wenya insa sowe henkam otdebinni, dekam sap de lun kon totore anggur hona golzimdin. Hwëna em an dërek wenya ema lam gulu– lun kon de hwëna kae gwibir-zimdin hip!” ");
INSERT INTO ury_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Zen zen Yesus mo nonol owas syal gwibin niye– kim langna Galilea mo ëna Kanak nonola zëre hap dena goltreizimki. Zen zëwe zëre mo ngatan zi mo lang nakore sosonna nonola goltreizimki. Zen dekam zep zëre hon de ang ta gwen wenya nonol sap daïblïblak. ");
INSERT INTO ury_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kim hya gwesïk, Yesus ki zep Kapernaum sun dep golëtine gweka– an zem, oso wal zem, hen ëe zëre hon de ang ta gwen wenya ban. Zao mingguna san ha aha-en mes yap asa golëlowe heka. ");
INSERT INTO ury_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","In kim Yahudi mo yakla yala Paskanak golek de gweꞌak, dekam zep Yesus Yerusalem san dep asa golëzahe gweka. ");
INSERT INTO ury_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Alap mo gol mwanak de teksonnak ki zep zini hlauludaꞌan haka– men zen sapi-dombana, hen mawana te-ala hap lirak da gwibikke– dekam de aha zi desa Alap hap tru tasïk gweblan hap. Hen men zen Roma mo te-ala hap Yahudi mo te-alasa lirak da gwibik, zen hen zao teinikinꞌik. Meja-mejanak te-alasa naïtblïn daꞌak. ");
INSERT INTO ury_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ki zep dokot hak-haksa siri tasïkï– dekam de sapi-dombana insa lek-lek tabin hip, dekam zep tïngan golëalsa sonebirki. Te-ala lirak ta gwibin meja-mejana man yal tazimki, hëndep te-ala kasona man sekwak tabir-zimki. ");
INSERT INTO ury_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","In zen mawana lirak dabiꞌik, desa ki zep gubiridaka, “Mawa om ansa dekam kap ul inehak. Ano Bian mo gola ansa bahem pasar hap li yul sone gwen.” ");
INSERT INTO ury_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ëe zëre hon de ang ta gwen wenya, ëe dekam zebë enlala eibik– mensa Alap mo olak anakarekam ale nukye, “Ëe Alap mo golsaë dawemkam anakan enna lwa gwibirin, ‘Bap zen zini kun gun.’ Zen in zep de jal hap sa Asa karek dal.” ");
INSERT INTO ury_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yahudi mo nol-nolik zep hwëna nenblak, “Nara ebe hap golblaka?– dekam de Alap mo gola ansa wet gulsun hupye. Ki abe mae hap emki owassa syal gwibir-zimdin– ëe akakim anakan emsa tawa ëblak, ‘Alap eiwa mes kirekam de syal gwe-gwibin hip dena ebe hap golblaka.’” ");
INSERT INTO ury_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ki zep ding gulzimki, “Em gola ansa dri kulsuk, hwëna Ëe asa dan-ahare yaklakam etan taul.” ");
INSERT INTO ury_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ki zep ding nulblik, “Alap mo gola ansa kim dauk, tahunna 46 enkam man-am altïlsïk, hwëna em ema gulu, ‘Dan-ahare yaklakam asa etan taul’!” ");
INSERT INTO ury_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Hwëna Yesus Alap mo gol tangansa de dri yulsun hup hom ki gubiridaka. Zen hwëna zëre mo tim hip denaka gulk sun ola blaonzimki. ");
INSERT INTO ury_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Zep Yesus kim tïn nïkon ngaya gweka, ëe dekam zebë zëre mo ola insa enlala eibik. Dekam zebë hen Alap mo hamal hap de ol ale gun nuban Yesus mo ola ban laïblïzimk. ");
INSERT INTO ury_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yerusalemk kim yakla yawala Paskanak gwë gweꞌanka, zini beya nik daïblïblak, sap zen man zëno owas syal gwibinsi hla nul gweꞌak. ");
INSERT INTO ury_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Hwëna Yesus hom desa anakan taïblïbiridaka, “Zen eiwa Asa daïblïblaꞌan.” Sap Zen mes kïtak tame tabirki. ");
INSERT INTO ury_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Zen zi mo enlalasa Zën hla ta gwizimki, zep Desa ba hap de anakan gublun hap, “Zini in karekna,” ahaksa, “Zen dawemna.” ");
INSERT INTO ury_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Aha yaklakam ki zep Farisi walya Yesussu zïnï ta zaka, bosena Nikodemus. Zen Yahudi zi mo aha mamna. ");
INSERT INTO ury_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Zen kam zïnï taka, ki zep zë gubluka, “Guru, ëe mesë emsa anakan tame lak, ‘Emsa Alap zer soneka– asa de tawa ta gwibin hip.’ Sap Alap de zisi zergwën srëmkam, zen bëjen owas-owassa syal gwe-gwibin– in kirekam em syal gwe-gwibiꞌiraye.” ");
INSERT INTO ury_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesus ki zep ding gulbluka, “Eiwa denakaë emsa gubluꞌan: Emsa de etan jaha gweblan srëmkam, em bëjen em Alap mo ïrïk gïnnïk hatan.” ");
INSERT INTO ury_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ki zep ding gulbluka, “Zi mamna banakan de etan jaha gweblan hap? San ha maka ki bongna etan an zik mo sopnak ing gwe heꞌara?!” ");
INSERT INTO ury_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesus ki zep ding gulbluka, “Eiwa denakaë emsa gubluꞌan: Zini etan de jaha gwibiridan srëmkam, hokam de jaha gwibiridanna, hen Alap mo Enhokam dena, zen molya Alap mo ïrïk gïnnïk yaïng gwek. ");
INSERT INTO ury_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Zi mo jaha gweblanna, zen tim en naka, hwëna Alap mo Enho nakore jaha gweblanna, zen ang hap dena. ");
INSERT INTO ury_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Em ba hap de tenggwaran hap?– sap Ëe ama emsa gublul, ‘Etan de emsa jaha gwibiridan srëmkam, em kïtak bëjen Alap mo ïrïk gïnnïk yaïng gwen.’” ");
INSERT INTO ury_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yesus ki zep ola gulk sun blaonblaka, “Asesena ki totoresa taïlïsen gwenda. Auku enna kie asal gweblanan, hwëna anakare tame gunnu hom, ‘Asesena in dekon jowe gwenda,’ ahaksa, ‘Desan dep song gwera.’ Zen hen ki kirekam, Alap mo Enho nakore jaha gweblan naye.” ");
INSERT INTO ury_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus ki zep takensïblïka, “Ëe homë tame guꞌun. Zen kirekam banakan sa jower?” ");
INSERT INTO ury_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesus ki zep ding gulbluka, “Em dwan Israelk de zi mo aha guru yawal sake, zep em ba habe insa tame gul srëm gwera? ");
INSERT INTO ury_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Eiwa denakaë emsa gubluꞌan: Ëe ëre hon de ang ta gwen wenya ban ëre mae mo tame gun nuka hen nwekam de hlaun nukaë tawa la gwibirin. Hwëna em ere mae hon de ang ta gwen wenya ban em molye ulink. ");
INSERT INTO ury_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ëe kimë auhu-kamanak denaka emsa tawa ta gwibirin, em hwëna dekam home ano ola laïblï gwibirin. Zep Ëe de ngatan zi mo langnak denaka emsa tawa tabinkim, em banakan dep?– taïblïbin niye. Ebe mae hap gwa-gwa tangaranna. ");
INSERT INTO ury_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Sap zini hom ngatan zi mo lang san dep sesek gwesek, hen dekon hom atiti gwezak– zen de emsa tawa tabin hipye. Hwëna Ëe ngatan zi mo lang nakore Zi Tanganna, Ëe dekonë ati gwezak. ");
INSERT INTO ury_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Men kirekam Musa Bak tembagakam de yang gulsun wanyana tenyak gulk makan gul inkike, sasa langnak in kim golëlowehe gwekake, zen kirekam sa hen ngatan zi mo lang nakore Zi Tanganna Asa gulk makan dain– ");
INSERT INTO ury_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","dekakim tïngan men zen Asa daïblï gweblaꞌak, hëndep de gwën hap denaka hla nuk.” ");
INSERT INTO ury_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Alap man okamanak de zisi sërkam kwasang gwibirida gweka, hëndep zep zëre mo Tane aha-erena zer sonezimki– dekakim tïngan men zen Desa daïblï gweblaꞌak hëndep denaban juwe srëm gwek, hwëna hëndep de ëngaya gwen hap denaka sa hla nul. ");
INSERT INTO ury_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Alap zëre mo Tanena in nësa de karek tabin hip hom zer soneka, hwëna dekam de Zëbon onakon nësa ngaya tabin hip. ");
INSERT INTO ury_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Zini men zen zëre mo Tanena daïblïblaꞌan, desa Alap hom karek tabin hip kalang gwibiridaꞌara. Hwëna men zen daïblïbla srëm gweꞌan, desa mes kareknak de kang gun hup kalang gwibiridaka, sap zen hom zëre mo Tane aha-erena daïblïblak. ");
INSERT INTO ury_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Zep a kire nakon sa Alap klis gulu: Zëre mo ngatansa de golzimdin hip de Zini mes sap okamanak hata zaka, hwëna okamanak de zini kawesïnsï dwam nei gwibirin. Zen ngatan san dep de wet so gwe kïnïn hap man baes ta gwenan, sap zen karek-kareksa nol gwenan. ");
INSERT INTO ury_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sap kareksa de gol gwen zini ngatansa man husus nei gwibirin. Zen bëjen ngatannak ëwet so gwe kïnïn– zëno mae mo syal karekna insa de tame gulzimdin srëm hap. ");
INSERT INTO ury_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Hwëna men zen Alap mo dwam gwibin sin ang ta gwenan, zen Alap mo ngatannak ëwet so kïnzï gwenan, dekam zep anakan noltrë gwenan, “Ano gwënna eiwa Alap mo dwam gwibin sin lwaꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Dekon aha yaklakam, Yesus zëre hon de ang ta gwen wenya aban mae Yerusalem mo zi srëm lang san dep golësek gweka. Zao holo tolkam asa golëlowehe gweka, hen zini dekam baptis ta gwibin hip yaïng gwe-gwezak. ");
INSERT INTO ury_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Dekam baptis ta gwibin zini Yohanis Swesa nama hom bwinak tak da inꞌik. Zen dekam Aenonk hen baptis ta gwibi'inka– ë yala Salim golek denak, sap zëwe hona beyana. Zep zini nama zëbon dep yaïng gwe-gwezak– zen de zë baptis ta gwibin hipye. ");
INSERT INTO ury_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ki zep Yohanis hon de ang ta gwen wenya Yahudi wal bose zeban auyan-aza zik mo ëpba ola kon nërkeisa-keisa gweꞌak– mae hap: Diki a kire enkam nen taha maena su tablanda gwen– dekam de Alap mo nwenak ëkun gwen srëm hapye. ");
INSERT INTO ury_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ki zep etan Yohanis osan dep lwan dahak, zao zep nenblak, “Guru, zini men zen weyana Yordan mo yakla hatase zannak eban ëꞌanka, mensa em asa gubirida gwekake, ‘Zen Zen tangan,’ zen hwëna angkam zisi beyakam baptis ta gwibi'ira. Angkam zini zëbon en dep tïngan gweꞌan. Nëbon mae hwëna man dan-en gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohanis ki zep ding gulzimki, “Zini bëjen banakare syal maena gul irin– Alap de golblan srëmkamye. ");
INSERT INTO ury_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ena kie asa sane la gwek– kimë anakan gu gwekye, ‘Ëe an Israelsa de ngaya tabin hip de Zisi hom, hwëna ëe an Desa de ngeir gubluzan hap de zi.’ ");
INSERT INTO ury_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yesus Zen we gon hap de zini men kiye. Hwëna wenya mensa Zen goꞌara, zini men zen angkam Zëbon dep bïtï gwe-gweꞌan, zen zen. Ëe hwëna men kiye– we gon hap de zini in mo wal bosena. Zep ëe ama sam gwesïnïn– anakan de akenkam, ‘We-zi darena in dawemkam ë gweꞌan,’ hen ëe ama isrip-sri gwe-gwenan– ano wal bosena in mo olsa de sane gwe-gwenkamye. ");
INSERT INTO ury_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Zen diki Zen sa abon onakon teipsïk zahera, hwëna ëe asa dowehe tiner.” ");
INSERT INTO ury_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Zini in zen gulk kon ati gwe zaka, Zen teipsïnnï. Hwëna okamanak de ësaltïn zini, zëno mae mo enlalana hen ol toranna okama en hap dena. Ngatan zi mo lang nakore Zini in man tïngan kwei-kwik guꞌura. ");
INSERT INTO ury_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Zen mensa Zëna zëwe hlaul gweka hen sane gwe-gweka, desa zep nësa tonbirida gweꞌara. Hwëna okamanak de zini zëno ola man hwa nulsuk gweꞌan. ");
INSERT INTO ury_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Hwëna men zen en zëno ola nulin gwenan, zen en zep anakan eiwa nul gwenan, “Yesus Zen Alap mo Zer Sonenna.” ");
INSERT INTO ury_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Alap mo zer sonen Zini, Zen eiwakam Alap mo olsa ayang gul gwenda, sap Alap zëbe hap zëre mo Enhosa kïtak zerblaka. ");
INSERT INTO ury_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bian man Tane zemka dang tïnï ta gwenda, in zep Zen de tïngan bi gwibin hip gubluka. ");
INSERT INTO ury_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Men nara Tane zem insa taïblïblanna, zen mes hëndep de ëngaya gwen hap dena nulin. Hwëna Tane zemka men zen de betek nëbla srëm gweꞌak, zen molya ëngaya gwek. Zen hwëna Alap mo jalak sa hëndep denaban lowehe gwer. ");
INSERT INTO ury_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisikam de gubirida gwen wenya ki zep anakan ësak, “Yesus hon angkam beyakam bïtï gwe-gweꞌan, hen zëbon beyakam baptis ta gwibin hip sek gwe-gweꞌan. Yohanis hon angkam man dan-en gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Hwëna Yesus Zëna hom baptis ta gwibirki. Diki zëre hon de ang ta gwen wenya ëyë baptis la gwibik. ");
INSERT INTO ury_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Anakan kim salka, “Farisikam de zini mes kirekam emsa tawa nëblak,” Zen dekam zep Yerusalem mo lang nakon asa etan Galilea mo lang san dep golësek gweka. ");
INSERT INTO ury_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Orana in desanë sek gwek langna Samaria mo ngïrïn kles san. ");
INSERT INTO ury_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ki zep Samaria mo ëna Sikark asa golëyaïng gweka. Dekon golek– ngana mensa Auyan Yakob Bak orep tangan tane zem Yusup hup zerblakaye. ");
INSERT INTO ury_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ëna Sikark iwe hen ki, Yakob Bak Swe mo aïlï hona. Yesus man oranak sin gwe zaka, zep kim hata zaka, hëndep dekam zep aïlï ho alpnak nikin ane zaka. Yaklana dekam bolak mes zauku. ");
INSERT INTO ury_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ëe zëre hon de ang ta gwen wenya mesë ëna iwe yaïng gwesek– tembanesa de zë lop tan hap. Ki zep hwëna Sikar wenya blome naban hataꞌanzak– hona insa dikim zausul han hap. Yesus ki zep gubirki, “Abe hap nonol zausulblu ine.” ");
INSERT INTO ury_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Wenya in ki zep ding gulbluk, “Em in Yahudi wal syake, hen ëe an langna Samaria kore we. Zep em ba habe asa kirekam abe gulu?” Zen mae hap ki ding gulbluk: Sap Yahudi zini bëjen Samaria zi niban tahana golësëran-sëran gwen. ");
INSERT INTO ury_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ki zep ding gulbirki, “Alap mensa angkam golzimꞌira, em home tame guꞌura. Hen em home Asa tame tala. Ki emaka Asa abe tala– hëndep de ngaya gwen hap de hosa de ebe hap golbin hip. Hen Ëe amaka ebe hap golbiꞌin.” ");
INSERT INTO ury_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ki zep ding gulbluk, “Bian, eno blomena hom, hen aïlï hona an logok gwe henna. Em banakan molye zausulku– ngaya gwen hap de hona in saye. ");
INSERT INTO ury_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Auyan Yakob Bak tïnkïm aïlï hona ansa nëbe mae hap hli tazimki, hen zëna, walas zem hen zaho zem, zen dekore hosa notde gwibik. Em san ema enaka kïl tïꞌara?– ‘Ëe an Yakob Bak onakon ama teipsïꞌïn.’” ");
INSERT INTO ury_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ki zep ding gulbirki, “Zi de aïlï hona ansa otde gwibinkim, zen sa etan ëho-hole gwe-gwer. ");
INSERT INTO ury_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Hwëna mensaë gol gwizimꞌin, zi de desa gul irinkim, dekam bëjen etan ëho-hole gwen. Hwëna hona in zëno mae mo enho nakon sa ana gwese gwer, hëndep zep sa hëndep denaban ëngaya gwer.” ");
INSERT INTO ury_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Wenya in ki zep ding gulbluk, “Bian, abe hap hona insa golbir– ëe akakim etan ho-hole gwe srëm gwek. Hen dekam ëe molyë awe hata gwezak– hona ansa de zausul gwen hapye.” ");
INSERT INTO ury_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ki zep etan ding gulbirki, “Ki zi omka em kwang ta lahan.” ");
INSERT INTO ury_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Hwëna ki zep ding gulbluk, “Ano zini hom.” Etan ki zep ding gulbirki, “Em eiwakame ding guluda, ");
INSERT INTO ury_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","sap em mese aha-ere taha-tapkam zini zersïk gweka. Hen mensa angkam zergwëꞌara, home eiwakam zeꞌara. Eno ding gunnu in eiwana.” ");
INSERT INTO ury_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ki zep ding gulbluk, “Bian, angkam mesë emsa tame tanan: Em Alap mo olsa de ayang gul gwen hap de zi. ");
INSERT INTO ury_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ano mae mo auyan-azana awe de kwatapnak yakla yawalak ëtagal gwe-gwek– dekon de Alap hap boklesa kom ta gweblan hap. Hwëna Yahudi zini, em ema anakan tawa la gwibirin, ‘Yerusalemk de Alap mo gol ennak em yakla yawalkam ëtagal gwe-gwen– dekon de Alap hap boklesa kom ta gweblan hapye.’” ");
INSERT INTO ury_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ki zep hwëna ding gulbirki, “Ano ola an desa em taïblïbin: Yaklanak sa hatal, dekam kwatapna an en kon hen Yerusalemk en kon molya Alap hap boklena kom da gweblak. ");
INSERT INTO ury_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Em Samariak de wenya, men zëbe hap boklena kom la gweblanan, home tame la gweꞌan. Hwëna ëe, Yahudi zini, mesë tame lak– men zëbe habë boklena kom la gweblananye. Sap dekam de zisi ngaya tabin hip dena, zen Yahudi hon sa ki lwal. ");
INSERT INTO ury_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sap zëno yaklanak sa hatal hen angkam man lwaꞌan, dekam zini sa tïngare enho naban hen Alap mo Enho de bi gwibiridankam Bian hap boklena kom da gweblal. Sap Bian Alap kirekam de zisi hakalbirida gwenda– Zënaka de boklesa kom ta gweblan hapye, sap men-kore men-kore zi ausu. ");
INSERT INTO ury_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Alap Zen enho enna, zep zi de eiwakam boklesa kom ta gweblanna, zen diki tïngare zëre mo enho naban hen Alap mo Enho de sosonsa golblan naban.” ");
INSERT INTO ury_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wenya in ki zep ding gulbluk, “Ëe tawana: Nësa de ngaya tabin hip de Zini sa hata zala, hen kim de hataꞌan zaka, Zen sa kïtak srip gulsuk gwizimdi.” ");
INSERT INTO ury_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ki zep ding gulbirki, “Ëe an Zen– an debane lonꞌaraye.” ");
INSERT INTO ury_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","In kim zë lonꞌak, ëe zëre hon de ang ta gwen wenya dekam zebë lwanda halzak. Zao zebë Yesussu anakan lenggwanblaꞌanzak, “Zen wenya ban am olsa lonꞌan.” Hwëna wenya insa homë anakan lakensibik, “Em basae Zëbon dwam gwibiꞌira?” Hen Yesussu homë lakensïblïk, “Em ba habe wenya in han ola lon sara?” ");
INSERT INTO ury_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hwëna wenya in kim Yesussu kirekam salblak, blomena insa zao zep eititi gwe gubirhak, ki zep ënak gubiridahak, ");
INSERT INTO ury_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Haen! Zini wakinsa emki hla tan. Zen ano gwënsa kïtak tawa gwibiri. San ha Zen tangan mes yap– nësa de ngaya tabin hip de Zi niye?” ");
INSERT INTO ury_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Dekam zep ëna iwe de zini du nëblazak. ");
INSERT INTO ury_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","In kim ki zë kirekam lwak, ëe zëre hon de ang ta gwen wenya, ëe ama sap zë tïtï la gweꞌak, “Guru Bak, emki tembane gwen.” ");
INSERT INTO ury_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Hwëna Zen man ap ding gulzimki, “Ano tembanena ki– mensa em tawa eibir srëm gweꞌanye.” ");
INSERT INTO ury_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ki zebë ënaka enbiridak, “San ha man yap aha zi tembanena nolblazal yap?” ");
INSERT INTO ury_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ki zep ap ding gulzimki, “Ano tembanena a zen moye: Bian mo dwam gwibinsi dikim syal gwibin hip, hen syala men zep Asa zer sonekake, desa dikim sul sonen hap. Zen ano tembanena zen. ");
INSERT INTO ury_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Zini kirekam nen gwibirin, ‘Eiyas tan nakon, etan benna dan-nër dan-nër, dekam sa taran hap denak zaul.’ Hwëna Ëe ama emsa gubiridaꞌan: Nga yala ansa emki ër tabla naseran. Gandumnu mes ngap-ngap gwera, zep taran hap denak mes zaul. Nen taran. ");
INSERT INTO ury_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Eiyas tan hap de zini, zen mes ëteingir gwe guk. Hwëna zini men zen angkam taran hap syal taꞌan, zen hëndep de ëlwa gwen hap de gudangnak gandumnu insa kang da gwenan, hen zëbe mae hap Alap hëndep de ëlwa gwen hap de te-alasa gaji hap aïtbir gwizimnira. Zep zini men zen eiyas tanna hen men zen de taranna apdekam sa lamkam ëisrip-sri gwer. ");
INSERT INTO ury_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Zep man dakastïlïn– men kirekam anakan nen gwibirinye, ‘Ahakorena eiyas tan hap de wenya. Ahakorena zen taran hap de wenya.’ ");
INSERT INTO ury_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Hwëna Ëe mesë emsa dam tasibik– em de hwëna aha zi mo eiyas tanna insa tan gwen hap. Zep em zëno mae mo irse gwen nakone dawemsa hla kul gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","40","In zen du nëblazak, zao zep abe da gweꞌak– deban mae de zëwe golëgweisïn hïp. Hëndep zëwe yaklana dan zep gweisïkï. Langna Samaria mo ëna Sikark de zini dekam beya nik zep Yesussu daïblïblak, sap wenya in anakan gubirida gweꞌak, “Zen ano gwënsa kïtak tawa gwibiri.” ");
INSERT INTO ury_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Hwëna Zënaka de sane tan tangankam, zep etan beya tangan nik daïblïblak. ");
INSERT INTO ury_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Hyanak zep wenya insa nen gwibik, “Menkam eno ol en nakonë laïblïblaꞌak, hwëna angkam aena hen mesë sane lak, zep mesë dam lasïl, ‘Eiwa, Zen okamanak de zisi de ngaya tabin hip de Zi.’” ");
INSERT INTO ury_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Samaria mo ëna iwe kim yaklana dan asa golëgweisïkï, ki zep kon etan zëre mo langna Galilea san dep asa golësek gweka. ");
INSERT INTO ury_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesus dekam hamal hap mes asa gubiridaka, “Zini hom zëre kore wal de Alap mo olsa ayang gul gwizimdin hip de zini nasal gweblanan, zep Asa hen Galileak molya daïblïblak.” ");
INSERT INTO ury_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hwëna kim asa golëyaïng gweka, Galileak de zini man ki sap neirink. Zen hen mes Yerusalemk yakla yala Paskanak ang tak, hen dekam zëno owas syal gwibinni kïtak kara nul gwek, zep ki neirink. ");
INSERT INTO ury_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesus ki zep asa golëlwanda halka– Galilea mo ëna Kana san dep, men zëwe Zëna nonol ho tanganna anggur ho hap li yul sonekake. Langna Galileak de aha ëna Kapernaumk zao hen ki zini gwëꞌanka– teipsïn zini Herodes mo taha trï so gweblan nik. Hwëna zëno tanena sang-sang nik gwëꞌanka. ");
INSERT INTO ury_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Zen kim salka, “Yesus Yerusalem mo lang nakon mes hata zala,” dekam zep song gwebla zaka, zao zep abe ta zaka, “Em wëhë asa mas gweblaꞌanka? Kapernaum sun nen ingnen– ano tane tolsa eka dawem ta. Zen tïn hïp tol alp gwesïꞌïra.” ");
INSERT INTO ury_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ki zep hwëna ding gulbluka, “Em awe de zini, karek tanganna. Em owas-owassa de syal gwibir-zimdin srëmkam bëjen em ëtaïblïn.” ");
INSERT INTO ury_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Hwëna man gubluka, “Haen, Bian! Em de hla tan srëmkam ano tanena sa tol tïlï!” ");
INSERT INTO ury_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ki zep hwëna ding gulbluka, “Emki song gwen. Eno tanena sa ngaya gwera.” Zini in man Yesus mo ola insa taïblïbirki, ki zep hëndep gwë halka. ");
INSERT INTO ury_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ora san kim nama tineꞌanka, dekam zep zëre hon de babu gwen zi niban golëtoweka. Zao zep nenblazak, “Eno tanena mes dawem gweka!” ");
INSERT INTO ury_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ki zep takensibiridaka, “Bawalkam dawem gweka?” Ki zep ding nulblik, “Ir, yakla nwena aha-en, dekam ewenna tap gweblak.” ");
INSERT INTO ury_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Bi zem dekam zep enlala gweka, “O hare yakla nwena dekam am Yesus asa gubluka, ‘Eno tanena sa ngaya gwera.’” Zëna hëndep zëre mo golak dena kïtak dekam zep Yesussu daïblïblak. ");
INSERT INTO ury_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Zep in kim kirekam tane tola insa dawem taka, Zen dekam zep Yerusalem mo lang nakon de Galileak hata gwe zankam de owas syal gwibir-zimdinni dan nëblak. ");
INSERT INTO ury_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Aha yaklakam, ki zep Yesus Yerusalem san dep asa golësek gweka– Yahudi zi mo aha yakla yalak dep. ");
INSERT INTO ury_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ë yala Yerusalemsa in kasokam de kolkam orep mes ki wale dak, hen zëno aha lïlïkïnnï man bose nosok “Domba zaho hap de Lïlïkïn.” Tïl hannak zao ki aïlï ho yawala, zëno gol kluk-klukna aha-ere taha-tap enkam. Ibrani olkam aïlï hona insa man bose dak “Betesda”kam. ");
INSERT INTO ury_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Zëwe zi sang-sangna tra nik ëglang-glang gwe-gwek– sap nwe haïna, lekna, hen taha-tana teisya ine gwen srëm wenya. Zen man zë ëkara gwe-gwek– aïlï hona insa dekon ngëp-ngep gwennak hla tan hap. ");
INSERT INTO ury_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Sap menkam-en menkam-enkam Alap mo dam taha nakore zini man jowe ine gwe zaka, dekam zep hona insa ngëp-ngep ta gweka. Ngëp-ngep gwenkam, dekam men nara honak de talhenkam nonol gwenna, zen dekam de sang-sang nakon dawem gwen– sap banakare sang-sang mae nakon. ");
INSERT INTO ury_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Zao hen ki zini, zen 38 tahun enkam sang-sang naban gwë gweka. ");
INSERT INTO ury_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesus kim tumnak zini insa hla ta zaka, zen man tame taka, “An mes holo tangankam sang-sang gweka,” ki zep takensïblïka, “Em wëhë dawem gwen hap dwam gweꞌara?” ");
INSERT INTO ury_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ki zep ding gulbluka, “Bian, ëe banakan de dawem gwen hap? Asa de mas gweblan hap de zini san ki? Zep hona an de ngëp-ngep gwenkam, ëe kimë nama song gwen hap sap akasïk gwenan, dekam zep hwëna aha zi talhenkam ënonol gwe-gwenan.” ");
INSERT INTO ury_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesus ki zep gubluka, “Dekam luwe, hëndep ki ere mo ni ta gwen srë-srena insa gol san dep gul ine kïnï.” ");
INSERT INTO ury_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hëndep dekam zep zini in dawem gweka, ki zep srë-srena insa gul ine kïnïka. Yaklana in dekam Yesus zini insa dawem taka, dekam Hari Sabat– Yahudi zi mo syal tan srëm yaklakam. ");
INSERT INTO ury_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Hwëna Yahudi zi mo mam-mamna kim zini insa hla da sonek, ki zep zë nen soneblak, “Nëno mae mo ol jalse gwennak, Hari Sabatkam srë-srena bëjen gwirenhan.” ");
INSERT INTO ury_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Hwëna man ding gulzimki, “Zini men zen asa dawem tala, zen man asa gublula, ‘Ere mo srë-srena insa em gol san dep gwirenhan.’” ");
INSERT INTO ury_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dekam zep dakensïblïk, “Zen nara zi ki emsa kirekam gublula?” ");
INSERT INTO ury_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Hwëna zini in hom anakan tame taka, “Zini bosena Yesus asa dawem tala,” sap Yesus zi beyanak iwe aya gwe ine halka. ");
INSERT INTO ury_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yesus ki zep zini insa etan Alap mo gol teksonnak zertoweꞌanka, zao zep gubluka, “Emki sane gwen: Emsa mesë dawem tak, hwëna kareksa de gol gwenna emki baes gwen. E-baes gwe srëm gweꞌanka, ki hwëna sërkam de karek tangan wenyaka esa goltowera.” ");
INSERT INTO ury_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kirekam kim salblaka, zini in dekam zep Yahudi zi mo mam-mam wenyaka gubiridaka, “Zini in zen asa dawem taka, zen bosena Yesus.” ");
INSERT INTO ury_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Zen dekam zep Yahudi zi mo mam-mamna Yesussu de sïl-sïl tanna kon neisïblï hanaꞌak, sap Zen Hari Sabatkam zisi dawem ta gwibiꞌinka. ");
INSERT INTO ury_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Hwëna Yesus ki zep gubiridaka, “Ano Bianna hom syala golzausuk gwenda. Ëe hen zebë kirekam syal gwe tine gwenan.” ");
INSERT INTO ury_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yahudi zi mo mam-mamna dekam tangan zep Yesussu de tan hap ola aha-en nuk– mae hap: Sap zëno mae mo dam gulsunkum, Zen Hari Sabat en hap denaka hom gulmun gweka. Zen hwëna Alapsa hen “Ano Bian”kam gu gweblaka. Dekam hwëna zëno ola man nwe-mase gwe-gwek, “Ëe Alap han ki en.” ");
INSERT INTO ury_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesus ki zep Yahudi mo mam-mam wenya insa gubiridaka, “Ëe eiwa denakaë emsa gubiridaꞌan: Ëe bëjënë ëre en mo enlalakam ba maesa syal gwibin. Hwëna mensaë ëre mo Biansa anakan kara ta gwenan, ‘Bian kirekam syal gwe-gwenda,’ Ëe hen zebë kire enkam syal gwe-gwenan. Men kirekam Bian syal gwe-gwenda, Ëe hen desan zebë ang gwe-gwenan. ");
INSERT INTO ury_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Sap ano Bianna man sërkam Asa kwasang gwe-gweblanda, zep mensa Zëna syal gwe-gwibirida, tïngan zep abe hap goltrë gweblanda. Hen Zen sa etan sërkam de owassa dikim ebe mae hap syal gwe-gwibir-zimdin hip denaka abe hap gol gweblala, hëndep owasna in esa lenggwanbirida gwer. ");
INSERT INTO ury_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Men kirekam ano Bian juwen zisi ngaya ta gwibirida, abe hap hen mes kire hap de sosonna golblaka– Ëe de hen kirekam ngaya ta gwibin hip, men desa Aena dwam gwibiridaꞌanke. ");
INSERT INTO ury_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Hen ano Bian Zëna angkam bëjen zisi klis gun. Sap Zen mes klis gun hup dena kïtak abe hap golblaka. ");
INSERT INTO ury_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Zen mae hap kirekam abe hap golblaka: Dekam de tïngare zi Asa blikip gwesïk gweblan hap– san de men kiye, ëre mo Bian Zënaka de blikip gwesïblïnna. Zep zini men zen Asa blikip gwesïblïn srëmna, zen hen hom ano Bianna blikip neisïk gweblanan– men zen Asa zer sonekaye. ");
INSERT INTO ury_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ëe eiwa denakaë emsa gubiridaꞌan: Zini men zen ano ol san ang ta gweꞌak, hen ano Bian, men Zen Asa zer soneka, Desa daïblïblaꞌak, zen ki mes hëndep de gwën hap dena nulin. Kire zisi bëjen aumwa hap de klis gunnuk karek tabin. Sap zen mes tïn hïp de orana hli dak– dekam de ëngaya gwen hap de ora san ang tan hapye. ");
INSERT INTO ury_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ëe eiwa denakaë emsa gubiridaꞌan: Yaklanak sa hatal hen angkam man kirekam lwaꞌan, dekam men zen juwen zi mo kim lowehe gwenan, zen sa Alap mo Tanena ano kwang guludan ola ësal gwer, hen men zen de Asa ang nëblaꞌak, zen zen sa ëngaya gwer. ");
INSERT INTO ury_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sap ngaya gwen hap de ausuna Bian onak, hwëna Zen mes Tane zem abe hap golblaka– dekam de Abon onakon ëngaya gwe-gwen hap denaye. ");
INSERT INTO ury_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Hen Zen mes zisi dikim klis gul gwen hap de sosonna abe hap golblaka, sap Ëe an Zen– ngatan zi mo lang nakore Zi Tanganna. ");
INSERT INTO ury_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ano tawa tabinni ansa bahem tenggwanbin. Sap yaklanak sa hatal, dekam tïngan men zen juwek ngatan zi mo lang nakore Zi Tanganna ano kwang guludahan hap de olsa sa ësane gweser. ");
INSERT INTO ury_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Zen dekam sa zënaka de kang gulne gwen nakon luk tal. Men zen dawemna nol gwek, desa asa ëngaya gwen hap tagal gulsul. Men zen karekna nol gwek, desa karek tabin hip asa tagal gulsul. ");
INSERT INTO ury_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ëe bëjënë A-en ba maesa syal gwibin. Ëe de zisi klis gunkum, dekam Ëe ama Bian mo Asa de gublun en san ang gwe-gwenan. Ano zisi de klis gunnu bëjen li tabin, sap Ëe homë ëre mo dwam gwibin sin ang gwe-gwenan, hwëna men Zen Asa zer sonekake, zëre mo dwam gwibin en sanë ang gwe-gwenan. ");
INSERT INTO ury_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ëe de anakan gubiridankam, ‘Ëe an Zen– mensa em kara ë gweblananye,’ hwëna aha zi de ano olsa trïlsen srëmkam, dekam molye Asa laïblïblak. ");
INSERT INTO ury_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Hwëna ano olsa de trïlsen hap de Zini ki. Zen ëre mo Bian. Hen ëe tawana: Zëno Asa de trï tasen hap de ola eiwa tanganna. ");
INSERT INTO ury_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Em ema zini baptis ta gwibin zini Yohanis osan dep lup ul sonek, hen zen dekam zep eiwakam abe hap dena damnak kira gweka. ");
INSERT INTO ury_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Auhu-kama zi de Asa trï tasen srëmkam hen sap. Hwëna en dikim lamkam ëngaya gwen habë ki emsa enlala sobiridal. ");
INSERT INTO ury_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohanis mo gwënna lampu makan lwa gwek– san de lampu de okama kawesïnnïk awe zïl inenna kiye. Nonol lone sennak em ema sap zëno ngatanna insa isrip-sri eibik. ");
INSERT INTO ury_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Zep Yohanis hen man Asa trï ta seka, hwëna diki dawem tanganna, emki ano owas syal gwe-gwibinsi taïblï gwibin. Bian Zen zep abe hap owas-owassa dikim syal gwe-gwibin hip de sosonna golblaka– em ekakim Asa anakan laïblïblak, ‘An eiwa Bian Alap zer soneka.’ ");
INSERT INTO ury_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ëre mo Bianna men Zen Asa zer soneka, Zen man hen Asa trï ta seꞌara. Hwëna em hom tangane zëno ol toranna ësane gwek, hen home zëno nwe-masena hla lablak. ");
INSERT INTO ury_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Alap mo ola man eno mae mo enhonak jawe guk hana gwenan, sap em home zëre mo zer sonen Zini Asa laïblïblaꞌan. ");
INSERT INTO ury_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Em sap Alap mo ol ale gunnu kie karatda ul gwenan, dekam zebe sap anakan ëenlala gwe-gwenan, ‘Ëe asa dekon hëndep de gwën hap de orana dam lasïl.’ Hwëna ol ale gunnu in, zen sap abe hap dena– Asa dikim tame tan hap! ");
INSERT INTO ury_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Hwëna em ema baes ta gwenan– Asa de ëngaya gwen hap dena kip abe tan hapye. Ëe ki amaka ebe mae hap golzimꞌin. ");
INSERT INTO ury_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ëe zi dikim ano bosesa mam gulblun hap homë awe hatazak. ");
INSERT INTO ury_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Sap Ëe mesë emsa tame tabik. Eno mae mo enhonak hom– Alapsa de ensa lwablan hap denaye. ");
INSERT INTO ury_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ëe ëre mo Bian mo bosekamë hatazak, hwëna em home asa dokwak laꞌan. Hwëna auhu-kama zi de zëre en mo bosekam hata zankam, desa en ema dokwak la gwibirin. ");
INSERT INTO ury_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Em ema ësam gwesïk gwenan– hwë-hwëkam de enaka bose naka anakan teip gulsuk gwizimdinni, ‘Em zini dawemna.’ Hwëna em home ëalp gwe-gwenan– Aha-ere Zini Alap dikim emsa sam gwesibiridan hapye. Kirekam de zini em an banakan dep?– Asa de taïblïblan naye. ");
INSERT INTO ury_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Bahem Asa kïl tïn, ‘Zen sa Bi zikhip ano mae mo karekna goltrëblala.’ Hwëna eno mae mo kareksa de Bian hap goltrëblan hap de zini, zen Musa Bak– mensa ena kïl lïꞌan, ‘Alap de klis gunnuk zen zen sa asa golëzauk sonera.’ ");
INSERT INTO ury_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Em de eiwakam Musa mo olsa taïblïbinkim, ki emaka hen Asa laïblïblaꞌan, sap zen hen abe hap denaka ale gulku. ");
INSERT INTO ury_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Hwëna em ema baes ta gwenan– Musa mo ola insa de taïblïbin hipye. Zep kire zini banakan dep?– ano olsa de hen taïblïbin niye!” ");
INSERT INTO ury_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Aha yaklakam, Yesus ki zep Ho Gutuna Galilea san asa bulkum golëblan kïnïka. Ho gutuna in mo aha bosena Tiberias. ");
INSERT INTO ury_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Hwëna zi beyana dekam zep tanakam bul lë ta gwen san dep hles dyablak, sap zen mes zëno owas-owas syal gwibinni hla nul gwek– zi sang-sangna kim dawem ta gwibirkike. ");
INSERT INTO ury_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Zao zep Yesus kwatap teknak asa golësesek gwe seka, ki zep zë asa golëteinikinꞌinka. ");
INSERT INTO ury_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Dekam Yahudi zi mo yakla yala Paskanak dep man golek de gweꞌak. ");
INSERT INTO ury_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesus kim men-san an-sankam zi beyam-byana insa kara tabirida ine guk gweꞌanka, dekam zep Pilipussu takensïblïka, “Endawe esa tembanena lop lal?– dekam de zi beyam-byana ansa sul sonen hapye.” ");
INSERT INTO ury_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Zen mae hap kirekam Pilipussu takensïblïka– dekam de anakan akasïblïn hap, “Zen banakan wëhë Asa ding gulbluꞌanka?” Hwëna Yesus Zëna mes sap hamal hap anakan enlala gweka, “Ëe kirekam de owassa asa syal gwibir-zim.” ");
INSERT INTO ury_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipus dekam zep ding gulbluka, “Nëno mae mo te-ala de mam tangankam lwaꞌanam, dekam de tembanesa kap tankam, dekam molya hen su kul soneꞌanam– sap betek maekam de golëtembane tan hapye.” ");
INSERT INTO ury_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Hwëna ki zep ëre mae mo wal bosena, Petrus mo osona Andreas Bak Yesussu gubluka, ");
INSERT INTO ury_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Awe ki walas tola. Zëno rotina sap ki– aha-ere taha-tap enkam, hen hogwena dan. Hwëna zen tol waba hap. An zini tra tangan nakake.” ");
INSERT INTO ury_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ki zep Yesus asa gubiridaka, “Teinikirin hip enbiridak.” Langna in so naban. Zao zep ki teinikink. Zi enna kim naïtbik, beyana san ha lima ribu enkam mes yap– we wal walassa de aïtbin srëmkam. ");
INSERT INTO ury_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesus ki zep rotina insa lop ta ineka, deban zep dawemsa Alap hap golblaka, ki zep hwëna zi beyana in hap dikim kae gwebla-zimdin hip asa gubiridaka. Hogwe darena insa hen kirekam. Kim dwenblanda gweꞌak, hëndep man tangan ëïtrï gwek. ");
INSERT INTO ury_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kim tïngan ëïtrï gwek, ki zep asa gubiridaka, “Dekam mosrona tagam lasïk. Betek en maekam bap zen zalta dep ërlwa kïnïn.” ");
INSERT INTO ury_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Sap rotina dan en hen zini tra tanganna, hwëna mosrona kimë tagam lasïk, yuna dua-blas enkam zep ësuwek. ");
INSERT INTO ury_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Zi beyana in kim owasna insa hla nuk, ki zep ëguk, “An Zenke– Alap mo olsa de ayang gul gwen hap de zer sonen zini, mensa nen kara ë gweblananye.” ");
INSERT INTO ury_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesus kim tame gulku, “Zen angkam man Asa de tik-tik tan hap ëalp gweꞌan– dekam de zëbon mae onak teipsïn hïp,” dekam zep kon kwatap-tek kwatap-tek san dep zë-en ahulsuk halka. ");
INSERT INTO ury_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kim kam-en gweꞌak, ki zep ëe zëre hon de ang ta gwen wenya bul syap san tine gwek, ");
INSERT INTO ury_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ki zebë kon hëndep Kapernaum sun dep etan lwan dahak. Zao zep hëndep Yesus mo hatazan srëmnak asa kawesibiridak. ");
INSERT INTO ury_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Hwëna dekam zep asesena mamkam taïꞌïnka. Ho gutuna in dekam zep mamkam ngëp-ngep gweka. ");
INSERT INTO ury_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ëe mesë dekam hoskam bulu insa ata ul song gweꞌak– langana san ha lima ahaksa enam kilometer enkam, hwëna ki zebë Yesussu hla la guk. Ho gutu tahan san song gweꞌan zaka, hëndep asa golek de tabiꞌin zaka. Ki zebë sërkam ëaïrïꞌak. ");
INSERT INTO ury_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Hwëna ki zep asa gubirida kïnzïka, “Bahem ëaïrïn! Ëe an Ëe.” ");
INSERT INTO ury_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Dekam zebë bulu in kon aha-ere enlala naban eirink. Hwëna hëndep dekam zep bulu in owas hap Kapernaumk hatak. ");
INSERT INTO ury_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kaꞌankam, zi beyana in zen ho gutu men eihyanak lowehek dekam zep dam nulsuk, “Bulu ir aha-enke, hen Yesus hom am zëwe ang gwera– zëre hon de ang ta gwen wenya kim bulu inkam sek gwerye. Yesussu man-am hli dal.” ");
INSERT INTO ury_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Hwëna ahakore bulu, ëna Tiberias korena, dekam zep yaïng gwezak– langna men zëwe ir Yesus golëtembane tan nakon dawemsa Alap hap rotina in hap golblakake. ");
INSERT INTO ury_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kim dam nulsuk, “Yesus hen zëre hon de ang ta gwen wenya hom awe lowe heꞌan,” dekam zep bulu inkam Kapernaum sun dep sek gwek– zao de Yesussu tëblan hap. ");
INSERT INTO ury_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Zi beyana in kim Yesussu hla danak, zao zep dakensïblïk, “Guru, em bawalkame awe hatala?” ");
INSERT INTO ury_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ki zep ding gulzimki, “Eiwa denakaë emsa gubiridaꞌan: Em tembane en habe asa lëblaꞌan, sap ir rotikame ëïtrï gwek. Eno mae mo anakare enlalana hom, ‘Zëre mo owas-owas syal gwibin nikonë anakan dam lasïꞌïn, “Zen an Zen– mensaë kara ë gweblananye.”’ ");
INSERT INTO ury_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bahem angkam en dep de tembane hap syal ta gwen, sap zen ëbatrenkam. Diki hëndep de ëlwa gwen hap de tembane hap emki syal ta gwen. Ëe, ngatan zi mo lang nakore Zi Tanganna, Ëe amaka kirekam de tembanena insa ebe mae hap golzimꞌin. Sap abe hap dena mes tangan dam gwesïk: Alap kire hap Asa zer soneka.” ");
INSERT INTO ury_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dekam zep dakensïblïk, “Ki hwëna ëe banakan asa syal tal?– Alap dikim asa sam gwesibiridan hap, hen dekam de hëndep de tembanena insa gul irin hipye.” ");
INSERT INTO ury_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesus ki zep ding gulzimki, “Syala in, a desa mo Alap ebe mae hap dwam gwibir-zimꞌira: Asa em anakan taïblïblan, ‘An Zen– nësa de ngaya tabin hip de Zini, mensa Bian zer sone zakaye.’” ");
INSERT INTO ury_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Dekam zep ding nulblik, “Ki banakare owassa esa abe mae hap goltreizimdi? Desa de hlaunkum amaka emsa laïblïblaꞌan. Banakarekam esa ap syal gwibir-zimdi? ");
INSERT INTO ury_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Musa kim sasa langnak golëgwë gweka, zen owaskam nëno mae mo auyan-aza hap tembanena bosena ‘manna’sa gol gwizimki. Men kirekam Alap mo olak lwak, ‘Zen ngatan zi mo lang nakore tembanesa gol gwizimki.’” ");
INSERT INTO ury_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ki zep ding gulzimki, “Eiwa denakaë emsa gubiridaꞌan: Musa Bak ngatan zi mo lang nakore tembane tangansa hom gol gwizimki. Diki ano Bian, Zen angkam ngatan zi mo lang nakore tembane tangansa ebe mae hap golzimꞌira. ");
INSERT INTO ury_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sap Alap onakore tembane tanganna, zen diki Ëe an Zen tangan. Sap Ëe ngatan zi mo lang nakonë ati gwezak– dekam de ëngaya gwen hap denaka okamanak de zini ebe mae hap golzimdin hip.” ");
INSERT INTO ury_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ki zep nenblak, “Bian, tembanena in desa ap golzim tine gwe.” ");
INSERT INTO ury_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ki zep ding gulzimki, “Ëe an Zen– ëngaya gwen hap de tembane naye. Zini men zen Abon yaïng gwe-gweꞌanzak molya etan ëusak gwe-gwek, hen men zen de Asa daïblï gweblaꞌak zen molya etan ëho-hole gwe-gwek. ");
INSERT INTO ury_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Hwëna men kirekamë emsa gubirida gwek, em sap ema Asa hla la gwenan, hwëna home Asa laïblïblaꞌan. ");
INSERT INTO ury_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tïngare zini mensa Bian abe hap lup gulbluꞌara, zen sa Abon yaïng gwe-gwezal. Men zen Abon yaïng gwe-gweꞌanzak, Ëe molyë desa lup gulin srëm gwe-gwek. ");
INSERT INTO ury_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sap Ëe ëre mo dwam gwibin sin de syal gwen hap homë ngatan zi mo lang nakon hatazak. Hwëna diki Bian mo dwam gwibin en san dikim syal gwen habë hatazak. ");
INSERT INTO ury_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Bian men Zen asa zer soneka, zëno abe hap de dwam gwibir-blinna an zen: Men desa Zëna abe hap lup gulbluka, Ëe babë desa aha-en mae syauk sun dep de ora san de gwë hannak kara ta sonen. Hwëna diki aumwa hap de yaklanak asa kïtak tïn nïkon ngaya tabir. ");
INSERT INTO ury_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Zen zep tïngan men zen de Tane zem Asa hla da gweꞌak hen daïblï gweblaꞌak, zen zen– hëndep de lowehen hap de wenyaye. Zen desa asa aumwa hap de yaklanak ngaya tabir. Ano Bian mo dwam gwibinni zen kirekam.” ");
INSERT INTO ury_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yahudi zi mo mam-mamna men zen hen zi beyana iwe ang ta zak, zen dekam zep donsuk gweblaꞌak– insa anakan gubiridakake, “Ëe an Zen– ngatan zi mo lang nakore tembane naye.” ");
INSERT INTO ury_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Man ëgu gweꞌak, “Yesus an dwan Yusup Bak Swe mo tane sake. An-bi zemka ëe kië tawa eizimk. Zen ba hap anakan gu gweꞌara?– ‘Ëe ngatan zi mo lang nakonë ati gwezak.’” ");
INSERT INTO ury_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Dekam zep gubiridaka, “Asa de tonsublunna in olzausuk. ");
INSERT INTO ury_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Sap zini bëjen Abon totoresa hatazan– ëre mo Bian de zon tazan srëmkamye. Aumwa hap de yaklanak Ëe asa desa en ngaya tabir. ");
INSERT INTO ury_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sap Alap mo ol ayang gul gwen zini man ale nuk, ‘Alap sa tïngare zini tawa tabiri.’ Zen zep tïngan men zen Zëbon onak ësane gwe-gwenan hen dekon ëtawa gwe-gweꞌak, zen zen sa Abon yaïng gwe-gwezal. ");
INSERT INTO ury_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Hwëna ano ola in bahem tim gun, ‘Zini Biansa nwekam hla tankam.’ Diki Ëe an Zen aha-en– nwekam de hla ta gwen hap de Zini, Zëna men Desa zer sonekaye. ");
INSERT INTO ury_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Eiwa denakaë emsa gubiridaꞌan: Men zen de Asa daïblïblaꞌak, zen mes hëndep de ëngaya gwen hap dena nulin. ");
INSERT INTO ury_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Ëe an Zen– ëngaya gwen hap de tembane naye. ");
INSERT INTO ury_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Eno mae mo auyan-azana ki tembane bosena mannana sasa langnak dwenblanda gwek. Zen sap man desa dwenblanda gwek, hwëna dekam nama juwe gwek. ");
INSERT INTO ury_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Hwëna awe ki gwëꞌara– eiwakam de ngatan zi mo lang nakore tembane tangan naye. Desae olgwenbiꞌik, dekam molye juwe gwek. ");
INSERT INTO ury_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ëe an Zen– ëngaya gwen hap de tembanena in, ngatan zi mo lang nakon de ati gwezan Zi niye. Men zen de tembanena ansa dwenblaꞌak, zen zen sa hëndep denaban ëngaya gwer. Tembanena in, an zen: Ano timni– men desaë okamanak de zisi dikim ngaya tabin hip sosok guꞌukye.” ");
INSERT INTO ury_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yesussu kim kirekam nasalblak, dekam zep zën ëol tetek gweꞌak– mae hap, “Zini in banakan sa zëre mo timni nëp golzimdi?– nen de twinbin hipye.” ");
INSERT INTO ury_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Etan ki zep gubiridaka, “Eiwa denakaë emsa gubiridaꞌan: Eme ngatan zi mo lang nakore Zi Tanganna ano kalaka otdebir srëm gweꞌak, hen ano tim nika olgwenbir srëm gweꞌak, ki ngaya gwen hap dena hom ebon mae onakye. ");
INSERT INTO ury_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Zi de ano tim nika twinbinni hen ano kalsa otdebinni, ki zëbon onak ki lwaꞌan– ëngaya gwen hap denaye. Hen desa asa ngaya gwen hap luwen tabirzir– aumwa hap de yaklanakye. ");
INSERT INTO ury_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Sap ano timni zen eiwakam de tembane tangan. Hen ano kala zen eiwakam de hona zen– dekam de ëngaya gwen hap denaye. ");
INSERT INTO ury_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Men nara ano tim nika twinbinni hen ano kalaka otdebinni, zen aban zeraha-en gweꞌara, hen Ëe dekam ama deban zeraha-en gwëꞌan. ");
INSERT INTO ury_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Ano Bian, Zen ngaya gwen hap de ausuna Zen. Zen Asa zer soneka, hen Ëe Zëbon onakonë ngaya gweꞌan. Zen in zep hen kirekam, zini men zen de ano tim nika dwinbiꞌik, zen sa Abon onakon ëngaya gwer. ");
INSERT INTO ury_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Zen in zep, ngatan zi mo lang nakore tembanena, zen auyan-aza mo twenblanda gwen tembane makan hom. Desa kim sap dwenblanda gwek, zen hwëna nama juwe gwek. Hwëna ngatan zi mo lang nakore tembane tangansa de twenblanna, dekam hëndep denaban esa lowehe gwer.” ");
INSERT INTO ury_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Zen Kapernaumk de but srëm golak kirekam tawa tabirki. ");
INSERT INTO ury_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Zi beyana in zen nërtro nasen gweꞌak kim kirekam de tawa tabinnik sane dak, beya nik zep ëguk, “Ola an gwa-gwa tanganna. Bëjen dam gulsun.” ");
INSERT INTO ury_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesus hwëna man kïtak ano mae mo enlalana insa hla tazimki, ki zep asa kïtak gubiridaka, “Em ema yap ano ola insa husus eibir. ");
INSERT INTO ury_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ki banakan esa ëenlala gwer?– em de Asa gulk sun de sewe sennak anakan kara ta sonenkam, ‘Ngatan zi mo lang nakore Zi Tanganna hare man-am angkam sewe seꞌara– men zao nonol gwë gwekake, desan dep.’ Ki dekam banakan esa Asa enlala ëblal? ");
INSERT INTO ury_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Alap mo Enhona, Zen Zen zi hip ëngaya gwen hap dena gol gwizimnira. Zi mo sosonna, zen waba hap. Ola insa emsa gubiridal, zen Alap mo Enho nakorena hen emsa dikim ngaya tabin hip dena. ");
INSERT INTO ury_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Hwëna Ëe tawana: Em ahakon home Asa laïblïblaꞌan.” Yesus kirekam gubiridaka, sap Zen nonol lonesen nakon mes ki tawa gwibiridaka, “Zini an zen sa Asa daïblïblal. An zen sa Asa daïblïbla srëm gwer.” Hen Zen mes aha zini insa tawa gwe gubluka, “An zen sa Asa zergulu.” ");
INSERT INTO ury_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yesus dekam zep etan mas gulzimki, “Zen in zebë hen emsa gubiridak, ‘Zini bëjen Abon hatazan– Bian de gublun srëmkamye.’” ");
INSERT INTO ury_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Dekam zi beyana in zen nërtro nasen gweꞌak, beya nik zep hli dak. Hom etan ang nëblak. ");
INSERT INTO ury_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesus dekam zep dua-blaskam de ang ta gwen wenya asa takensibiridaka, “Em san ha hen ema Asa de hli tan hap ëdwam gweꞌan?” ");
INSERT INTO ury_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon insa hen nen gweblak “Petrus”kum ki zep ding gulbluka, “Ëe etan nara hon dep de sek gwen hap? Sap hëndep de ëngaya gwen hap de ola, zen Ebon en am lwaꞌan. ");
INSERT INTO ury_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Hen ëe mesë Emsa anakan laïblïblak, ‘An Zen tangan– Alap mo zer sonen Zi Lalak naye.’” ");
INSERT INTO ury_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesus ki zep kïtak ap ding gulzimki, “Aenë sap emsa dua-blaskam dam tasibik, hwëna ebon mae onakon ahana zen dowal mo bi gweblanna.” ");
INSERT INTO ury_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesus mensa enlala gweblaka, zen ëna Kariot walya Simon Bak mo tanena Yudassa. Zen sap dua-blaskam de zini ano mae mo ahana, hwëna zen ki hëndep Yesussu zerguku. ");
INSERT INTO ury_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Zao kim hya gwesïk, Yesus ki zep asa Galilea mo langnak de ë-ë san ziamjanbir song gweka. Zen hom Yerusalem mo langnak de ë-ë san dekam asa ziamjanbirki, sap Yahudi mo mam-mamna dekam man tan hap orasa dëblaꞌak. ");
INSERT INTO ury_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Dekam Yahudi mo yakla yalak dep man golek de gweꞌak– men dekam kluk-kluk golak lowehe gwenanke. ");
INSERT INTO ury_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Zep oso wal zem yasik tan ola anakan nenblak, “Em ba habe awe gwëꞌara? Yerusalem mo lang san em song gwen– zao deka ere hon de ang ta gwen wenya in eno owas syal gwibinni insa kara nul gwek. ");
INSERT INTO ury_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Eme anakan enaka enlala gweblaꞌanam, ‘Dikire kïtak asa tawa nëblak,’ ki bahem awe en aningkim syal gwe-gwen. Em in dekam de teipsïn hïbe syal gweꞌara, ki emki enaka tïngare zi hip zertrei gwizimdin.” ");
INSERT INTO ury_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Zen sap oso wal zem, hwëna zen hom anakan daïblïblak, “An Zen– nësa de ngaya tabin hip de Zi niye.” In zep kirekam yasik dak. ");
INSERT INTO ury_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Hwëna man ding gulzimki, “Angkam abe hap de yaklanak hom zauꞌun– mensa Bian abe hap dam tasïblïkaye, Ëe dikim desan song gwen hapye. Hwëna em totoresa sap esa sek gwe-gwer. ");
INSERT INTO ury_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Auhu-kama enlala zini zen molya emsa husus neibiridak. Hwëna Asa en man husus në gweblanan, sap Ëe ama gubirida gwenan, ‘Em in kareksae ol gwenan.’ ");
INSERT INTO ury_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Amki e-en Yerusalem san yakla yala iwe dep zahe gwek. Ëe homë zaheꞌan, sap ano kire hap de yaklanak angkam hom zauꞌun.” ");
INSERT INTO ury_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Zep Zëna hom ang gweka. Zen man Galileak gwëka. ");
INSERT INTO ury_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Oso wal zem in kim yakla yawala in san dep ëgwahak, hwëna Yesus Zëna lun kon zep sowëkam golëtroka– zi de tawa gweblan srëm hap. ");
INSERT INTO ury_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yakla yawala iwe Yahudi mo mam-mamna man zë dë gweblaꞌak, hen dakensïblï nasen gweꞌak, “Zini in endawe gwëꞌara?” ");
INSERT INTO ury_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Zi beyam-byana in dekam man zënaka aningkim nulsuk halasen gweꞌak. Sap ahakon man anakan sam neisïk gweblaꞌak, “Zini in dawem nakake.” Hwëna ahakon man ëgu gweꞌak, “Dawem naka hom. Zen nësa yasik ta gwibirida.” ");
INSERT INTO ury_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Hwëna men zen kirekam sam neisïblïk zen hom damnak kirekam ëgu gweꞌak, sap zen Yahudi mo mam-mam naka naïrïbirida gwek. ");
INSERT INTO ury_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Yakla yawala in holona aha-ere minggu. Ngïrïn ngam sonnak kim zauꞌuk, Yesus ki zep Alap mo golak tïl zïka, ki zep zë zi beyam-byana insa tawa tabiꞌinka. ");
INSERT INTO ury_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yahudi mo mam-mamna dekam zep anakan denggwanblaꞌak, “Zini an hom sekola gweka. Zen ba nakon kire tangankam tawa gweka?” ");
INSERT INTO ury_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesus ki zep ding gulzimki, “Ola mensaë tawa ta gwibirin, zen ëre onakore naka hom. Zen Alap, men Zen Asa zer soneka, Zëbon onakore naka. ");
INSERT INTO ury_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Zini men zen Alap mo dwam gwibin sin de ang tan hap ëhohle gwe-gwenan, zen sa anakan dam nulsuk gwer, ‘Tawa tabinni an eiwa Alap mo dwam gwibin sin,’ ahaksa, ‘Desan hom.’ ");
INSERT INTO ury_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Zini men zen zëre mo enlala gwibinsi tawa da gwibirin, zen anakan ëdwam gwe-gwenan, ‘Ano bosesa dekakim teip nulsuk gwek.’ Hwëna men zen anakan tawa da gwibirin, ‘Asa bahem boltere tan. Diki men zen asa zer sonekake, desa en em boltere tan,’ kire zini zen enlalana dam-damna hen zen bëjen yasik tabin. Zep Ëe an hen kirena. ");
INSERT INTO ury_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Eiwa, Musa Bak waba tangan hap tïtï tabin ola insa ebe mae hap golzimki, hwëna em ema kïtak ngip ul gwenan. Em ba habe Asa tan hap kalang ëblaꞌan?” ");
INSERT INTO ury_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Zi beyana in dekam zep ding nulblik, “Emsa in dowal tïlblïla! Nara emsa tan hap kalang gweblaꞌara?” ");
INSERT INTO ury_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesus ki zep ding gulzimki, “Ëe aha-ere owassaë Hari Sabatnak syal gwibik, hen em dekam ema lenggwan gwibik. ");
INSERT INTO ury_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Hari Sabatna, zen sap nëno mae mo syal srëm hap de yakla, hwëna em dekam kie zi walas mo to mipna blom lasïk gwibirin– men kirekam Musa Bak tïtï tabirkike. Hwëna sap to mip blom tasibin hip dena, diki ausuna Musa hon hom. Zen diki orep de auyan-aza kirekam tïtï da gwibik. ");
INSERT INTO ury_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Em zebe Hari Sabatnak zi walas mo to mipna blom lasïk gwibirin– dekam de Musa mo tïtï tabin ola insa ngip gun srëm hap. Zen in zep bahem Asa jal gweblan, sap ëe ama zi mo tïngare timsi owaskam Hari Sabatkam oto gulsubluk. ");
INSERT INTO ury_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Asa de langa nakon kara tan enkam, bahem na-en Asa anakan ti yulsuk gweblan, ‘Zen man Musa mo tïtï tabin olsa gulmun gwenda.’ Diki enlala dam-dam enkam em abe hap dena anakan klis gul gweblan, ‘Zëno syala in dawemna,’ ahaksa, ‘Karekna.’” ");
INSERT INTO ury_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ahakon Yerusalemk de zini dekam zep zënaka donbirida nasen gweꞌak, “Zini in zen– mensa nëno mae mo mam-mamna tan hap dëblaꞌanye. ");
INSERT INTO ury_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hwëna emki kara tan! Zen damnak zi beyanak tonbiridaꞌara, hen mam-mam wenya hom jalse nëblaꞌan. San ha zen mes anakan dam dasïl?– ‘Zen eiwa nësa de ngaya tabin hip de Zini Zen.’ ");
INSERT INTO ury_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Hwëna san ha diki Zen hom yap? Sap ngaya tabin hip de Zini in de ngatan zi mo lang nakon ati gwenan zanam, nen ki molye zëno ëna tawa ëblaꞌanam. Hwëna Yesus zen Nazaret wal syake.” ");
INSERT INTO ury_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Zen in zep Yesus kim Alap mo gol teksonnak tawa tabiꞌinka ol mam-mamkam tonbiridaka, “Em ema tim ul gwenan, ‘Ëe zini insa ama tame laꞌan, hen zëno ëna kië tawa ëblaꞌan.’ Hwëna Ëe totoresa homë ëre mo enlalakam hatazak. Men Zen Asa zer soneka, Zen eiwa taïblïblan tanganna. Hwëna em home Desa tame la gweꞌan. ");
INSERT INTO ury_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Hwëna Aena kië Desa tame tak, sap Ëe Zëbon onakonë hatazak, hen Asa Zen zer soneka.” ");
INSERT INTO ury_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Dekam ahakon balk tan hap sap ëakasïk, hwëna hom mae banakan mae nëblak. Sap dekam kirekam de gwëblan hap de yaklana mensa Bian dam tasïblïka, zëwe hom zauꞌuk. Zen in zep dekam balk da srëm gwek. ");
INSERT INTO ury_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hwëna zi beyana in kon hen beya nik daïblïblak. Zen man ëgu gweꞌak, “Nësa de ngaya tabin hip de Zi de ahanik hataꞌanka, Zen banakan sa Yesus mo owas syal gwibinni ansa gulmunblula?” ");
INSERT INTO ury_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisikam de gubirida gwen zini kim kirekam nasalbiridak, dekam zep apdekam Alap mo golak de syal tan zi mo mam-mam naban Alap mo golsa de kara gul gwen hap de jana nabare zini lup nul sonek– zen de Yesussu balk tan hap. ");
INSERT INTO ury_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Hwëna zen hen hom dekam balk dak. Yesus dekam zep zi beyana insa gubiridaka, “Ëe molyë holokam eban mae golëlowehe gwek. Nabakam asa etan lwahal– Zini men Zen Asa zer sonekake, Zëbon osan dep. ");
INSERT INTO ury_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Em dekam esa Asa lë gweblal, hwëna molye Asa hla la gwek. Sap men zaoë dekam gwë gweꞌak, em molye desan Asa ërtrok.” ");
INSERT INTO ury_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yahudi mo mam-mamna dekam zep zënaka dakensibirida gweꞌak, “Zini an endan lang san de song gwen hap ki gulu?– nen de zëwe hla tan srëm hapye. San ha Yunani mo lang san de song gwen hap?– men desan ahakore Yahudi zini sekwak gwenkam lowehen daꞌanke, zao de Yahudi srëm zisi tawa ta gwibin hip. ");
INSERT INTO ury_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ba hap ki gulu?– ‘Em dekam esa asa lë gweblal, hwëna molye asa hla lak. Sap men zaoë dekam gwë gweꞌak, em bëjen zao yaïng gwen.’” ");
INSERT INTO ury_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Yahudi mo aha-ere minggukam de yakla yala iwe, aumwa hap de yaklana, zen zen– mam tanganna. Yesus dekam zep Alap mo golak zauku, dekam zep ol mamkam tonbiridaka, “Zi de ho-hole gwenna, dikire Abon otden hap yaïng gwe-gwezak. ");
INSERT INTO ury_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Men kirekam Alap mo olak lwak, zini men zen de Asa daïblï gweblaꞌak, ‘zëno mae mo enho nakon sa ngaya gwen hap de hona ana gwese gwer.’” ");
INSERT INTO ury_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Hona insa enlala gwibirki, Zen Alap mo Enhosa. Zi de Yesussu taïblïblankam, dekam de zëbon ing gwe heblan. Hwëna in kim gubiridaka, dekam hom ing gwe hezimꞌinka, sap dekam Yesus hom tïꞌïnka– Alap dikim teipsïnkïm drënen hapye. ");
INSERT INTO ury_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Zi beyana in kim kirekam nasalblak, ahakon dekam zep ëguk, “An diki Zen– Alap mo olsa de ayang gun hup de Zini, mensa Musa hamal hap gu-guk gweblakaye.” ");
INSERT INTO ury_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ahakon hen man ëguk, “Zen an Zen– Israelsa de ngaya tabin hip de Zi niye.” Hwëna ahakon man ding nulzimk, “Bëjen. Hom anakan nen guk gweblak, ‘Zen Galilea wal hap sa jowe zala.’ ");
INSERT INTO ury_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Sap Alap mo olak man-am lwak, ‘Nësa de ngaya tabin hip de Zini, Zen Daud Bak mo ausu nakon sa saltïlï, hen Daudsa de jaha gweblan ëna Betlehemk sa hen Desa jaha gwer.’” ");
INSERT INTO ury_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Zen kire nakon zep ëhlïwek. ");
INSERT INTO ury_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ahakon sap dekam balk tan hap dwam nëblaꞌak. Hwëna zen hom mae banakan mae nëblak. ");
INSERT INTO ury_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Alap mo golak de jana nabare zini in dekam zep etan lwanda halzak. Men zen lup nul sonek dekam zep dakensibiridak, “Em ba habe balk la halza srëm gwer?” ");
INSERT INTO ury_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Hwëna man ding nulzimk, “Kire zini san ki balk da gwenan? Zëno ola dawem tanganna. Aha zi mo ol toranna hom– kire naye.” ");
INSERT INTO ury_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Dekam zep jala ban ding nulzimk, “Asya! Emsa in hen mes yasik tabiri! ");
INSERT INTO ury_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","San ëe kië Yahudi mo mam-mamna hen Farisikam de gubirida gwen wenya aha-en mae laïblïblaꞌan?! ");
INSERT INTO ury_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Hwëna zi beyana an Musa mo tïtï tabin ola hom tame nul gwenan, zep zen kïtak syauk sun dep sa sek gwer!” ");
INSERT INTO ury_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Hwëna Farisi walya Nikodemus Bak zao hen gwëꞌanka– men zen Yesussu nonol zïnï takake. Zen dekam zep wal bose wal zemka gubiridaka, ");
INSERT INTO ury_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nëno mae mo tïtï tabin olak Musa man nëp ale gulzimki: Nen bap nen totoresa zisi gublun, ‘Zen karekna.’ Diki nonol taken-taken gweblankam. Karekna kim hlaulblunna, zen dekam de karek tan.” ");
INSERT INTO ury_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Hwëna man ding nulblik, “Ki san em hen Galilea wal?! Emki Alap mo olak teibin. Zao hom anakan ale nuk, ‘Alap mo olsa de ayang gun hup de zini Galilea mo lang nakon sa jowe zala.’”  ");
INSERT INTO ury_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Dekon kim ëhya gwesïk, ki zep gol san dep sekwak gwek. ");
INSERT INTO ury_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Hwëna Yesus Zëna dekon zaitun tra nabare kwatap tek san zep asa golëzahe gweka. ");
INSERT INTO ury_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kaꞌankam orap tola ban zep etan Alap mo gol san dep asa golësek gweka. Zi trana kim etan tagal nëblazak, Yesus Zëna dekam zep nikin aneka– dekon de tawa tabin hip. ");
INSERT INTO ury_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Farisikam de zini Musa mo olsa de tawa ta gwibin hip de zi niban ki zep hen wenya nolhatazak, ki zep tïngare zi mo nwenak de zaun hup tik-tik nuk. Zen kahalo gwennak balk nuk. ");
INSERT INTO ury_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ki zep Yesussu nenblak, “Bian, wenya an kahalo gwennakë balk ul halanzal. ");
INSERT INTO ury_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nëno mae mo tïtï tabin olak Musa Bak man nësa gubiridaka, ‘Kire wenya em kasokam tok hap ï tï gïbin.’ Hwëna eno tawa tabin nikon, kirenak de balk gun wenya nen banakan esa eibir?” ");
INSERT INTO ury_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Zen kirekam mae hap ki dakensïblïk, sap zen mes aningkim ola aha-en nuk– Yesussu dikim anakan akasïblïn hap, “Zëno tawa tabin nik de Musa mo tïtï tabin ola ban apde nën srëmkam, ki esa karek lal.” Hwëna Yesus man huwe heka, ki zep kamanak de sonnak taha bolkam ale gul gweꞌanka. ");
INSERT INTO ury_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hwëna zen dekam nama hen-henkam dakensïk gweblaꞌak, ki zep hëndep dam-dam gwe seka, dekam zep gubiridaka, “Men zen de zënaka enlala gweblak, ‘Ëe homë aha-en mae karekna gok,’ zen zen de nonol kasokam gwik.” ");
INSERT INTO ury_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kim kirekam gubiridaka, ki zep etan sonnak de ale gun hup huwe heka. ");
INSERT INTO ury_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kirekam kim Yesussu nasalblak, ki zep aha-en aha-enkam teso gwe-gweꞌak– hëndep kïtak sekwak gwek. Bong-bongkam de wenya, nonol zen teso gwek. Hëndep Yesus ensa zep zë hli dak. We enna in nama zë zauꞌuk. ");
INSERT INTO ury_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ki zep etan dam-dam gwe seka, dekam zep gubirki, “Zini men endawe? San ha emsa de karek gun hup de wenya in mes kïtak sekwak gwer?” ");
INSERT INTO ury_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ki zep ding gulbluk, “Mes, bian.” Ki zep hwëna gubirki, “Ëe hen homë emsa karek guꞌun. Sap esa song gwera, hwëna bahem etan karekna gon.” ");
INSERT INTO ury_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Etan kim zi beyanak asa golëgwëꞌanka, ki zep zë gubiridaka, “Ëe an okamana an hap de ngatanna Zen. Zini men zen de Asa ang në gweblaꞌak, zëbon mae onak sa ëngaya gwen hap de ngatanna zïl ine gwer. Zen molya kawesïnnïk lowehe gwek.” ");
INSERT INTO ury_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisikam de zini in zen zë hen lowe heꞌak, ki zep nenblak, “Em e-en tangane ki kirekam asa gubiridanda. Diki aha zi de eno olsa trïl senkam bap, ki amaka emsa laïblïblaꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ki zep ding gulzimki, “Ëe, zi de Asa trï tasen srëmkam de kirekam gubiridanna, ano ola in nama eiwa dena. Sap Ëe tawana– men dekonë hatazak hen men zao debë lwa haꞌak. Hwëna em desa tawa naka hom. ");
INSERT INTO ury_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Em in kirekame ëgwë gwenan: Zisi nabakame enbirida gwenan, ‘Em mese karek gwera.’ Hwëna em in auhu-kama zi mo enlala en sane klis ul gwenan. Hwëna Ëe angkam zisi homë klis guꞌun. ");
INSERT INTO ury_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Hwëna Ëyë klis guꞌunam, zen eiwakam sa ki lwal, sap Ëe A-en homë kirekam syal gwe-gweꞌan. Bian men Zen Asa zer soneka, Zen aban zersyal gweꞌara. ");
INSERT INTO ury_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nëno mae mo tïtï tabin olak man lwak, ‘Zi dare mo kira ën ol de apde nënna, amki laïblïzimk.’ ");
INSERT INTO ury_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ëe an ëre hap denaka emsa gubiridaꞌan. Ano Bianna men Zen Asa zer soneka, Zen hen man ano ola an trïlse gweꞌara. Zep Ëe Debanë dan ë gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ki zep dakensïblïk, “Eno bianna in endawe?” Ki zep ding gulzimki, “Em home Asa tame laꞌan hen home ano Biansa tame laꞌan. Asae tame laꞌanam, ki emaka hen ano Bianna tame laꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Zen kirekam gubiridaka– Alap hap de te-ala ing gul gweblan teksonnak kim tawa tabiꞌinkaye. Dekam hen hom balk dak, sap kire hap de yaklanak hom dekam zauꞌuk. ");
INSERT INTO ury_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Etan ki zep Yesus gubiridaka, “Ëe asa song gwer. Em esa Asa lë gweblal, hëndep zao esa ere mae mo karek-karek naban oltïl. Sap men zao debë song gweꞌak, em molye desan Asa ërtrok.” ");
INSERT INTO ury_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yahudi mo mam-mam wenya men zen ësane gweꞌak dekam zep zënaka dakensibiridaꞌak, “San ha zen man zënaka de tan hap enlala gweꞌara?– in zep ki gunda, ‘Men zao debë song gweꞌak, em molye desan asa ërtrok.’” ");
INSERT INTO ury_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesus ki zep ayang gulzimki, “Em an auhu-kamana an kore zi. Ëe an gulk korena. Em in okamanak de ësaltïn zi. Ëe dekore naka hom. ");
INSERT INTO ury_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Zen in zebë emsa gubiridanan, em esa ere mae mo karek-karek naban oltïl. Zen kirekam sa ebe mae hap lwazim– eme Asa laïblïbla srëm gweꞌakye. Sap Ëe an Zen– mensa ena kara ë gweblakye.” ");
INSERT INTO ury_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Dekam zep jala ban dakensïblïk, “Zep ki em an nara mo weinak dep de zi?– zebe kirekam enaka gu gweblaꞌaraye.” Ki zep ding gulzimki, “Men kirekamë nonol lonesen nakon emsa gubirida gwek, zen kirekamke. ");
INSERT INTO ury_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ano ola ebe mae hap dena nama beya tanganna– dekam de eno mae mo karek-kareksa goltrei gwizimdin hip denaye. Ano Bianna Zen taïblïblan tanganna, hen men desaë Zëbon onakon sane gwe-gweꞌan, zen desaë okamanak de zini ebe mae hap ayang gul gwizimꞌin.” ");
INSERT INTO ury_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Zen hwëna hom zëno ol-gunnu insa anakan dam nulsubluk, “Zen ngatan zi mo langnak de Bian hap denaka ki gunda.” ");
INSERT INTO ury_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Zen in zep ki Yesus anakan gubiridaka, “Em kime ngatan zi mo lang nakore Zi Tanganna Asa gulk makan la inꞌik, zen dekam esa anakan Asa dam lasïl, ‘An eiwa Zen– mensae kara ë gweblakye.’ Em dekam esa Asa anakan tame lal, ‘Zen hom zëre en mo bose hap ba maena syal gwibirki. Zëno tawa tabinni zen eiwa kïtak Bian onakorena.’ ");
INSERT INTO ury_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Bian men zen Asa zer soneka, Zen aban zersyal gwe-gweꞌara. Bian hom Asa da tasïk gwenda, sap ano syala man sam gwesïk gwibirida.” ");
INSERT INTO ury_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kirekam de torannak kim sane daꞌak, dekam zini beya nik zep daïblïblak. ");
INSERT INTO ury_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Men zen Yesussu daïblïblaꞌak, ki zep desa en gubiridaka, “Eme ano ol san enlala tatete naban ang ta gweꞌak, em ki eiwa Abon de ang ta gwen zi tangan. ");
INSERT INTO ury_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ki esa eiwa dena tame ul gwer, hen dekam esa aha mo emsa de jap gul sonendan nakon ëhïl gwe hanal.” ");
INSERT INTO ury_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ki zep hwëna ahakore nik ding nulblik, “Nen an Abraham Bak mo ausu nakore zi sike. Nen home mae aha zi mo tana ïltïkïnnïk ëbabu gwek. San ki man nësa dahale gwibik. Zep em ba habe kirekam gulu?– ‘Em esa jap gul sonendan nakon ëhïl gwe hanal.’” ");
INSERT INTO ury_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ki zep ding gulzimki, “Eiwa denakaë emsa gubiridaꞌan: Men zen karekna nol gwenan, ki zen karekna in zëbon ëbabu gweꞌan. ");
INSERT INTO ury_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Zi mo tana ïltïkïnnïk de babu gwen zini, zen zi bina in mo iyesa hom. Zep zen molya hëndep zëwe gwë gweka. Hwëna tane zem, zen zëwe en sa gwë gwera, sap zen tane tangan zem. ");
INSERT INTO ury_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Zen in zep, ngatan zi mo langnak de Bian mo Tane Tangan de emsa hïl ti sonebinkim, dekam esa tangan ëhïl gwe hanal. ");
INSERT INTO ury_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ëe tawana: Em hen sap Abraham Bak mo auyan-tane wal. Hwëna em tan habe Asa dwam ëblaꞌan, sap ano ola ebon mae man jawe guk hana gwenan. ");
INSERT INTO ury_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mensaë ëre mo Bian hon hlaul gwek, Ëe desaë ebe mae hap ayang gul gwizimnin. Hwëna em ere mae mo bian mo ol sane syal ta gwenan.” ");
INSERT INTO ury_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ki zep ding nulblik, “Ëe an Abraham Bak mo walas sake.” Ki zep ding gulzimki, “Hwëna Eme eiwa Abraham mo walas lowe heꞌanam, ki Abraham mo kim emaka lowehe gweꞌan. ");
INSERT INTO ury_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mensaë Alap hon sane gwe-gwek, Ëe desaë ebe mae hap ayang gul gwizimꞌin, hwëna em tan habe Asa dwam ëblaꞌan. Abraham hom kirekam gwë gweka! ");
INSERT INTO ury_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Em ere mae mo bian mo kime lowehe gwenan.” Ki zep hwëna ding nulblik, “Ëe an malin walassa hom! Ëe an tïngan Alap mo wei-wik gun walas sake.” ");
INSERT INTO ury_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Hwëna dekam zep Yesus ding gulzimki, “Eme eiwa Alap mo wei-wik gun walas lowe heꞌanam, ki emaka Asa enna ola gweblaꞌan. Sap Ëe an Alap onakonë hatazak, hëndep zebë angkam awe gwëꞌan. Ëe ëre mo enlalakam homë hatazak, hwëna Zen ki Asa zer soneka. ");
INSERT INTO ury_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Em an mae habe ano ola tame ul srëm gwe-gwenan: Sap em makare zini bëjen ano ola dokwak gun. ");
INSERT INTO ury_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Em an ere mae mo bianna dowal mo kïgï mo wei-wik gun walas. Zen in zebe zëno dwam gwibin sin ang ta gwenan. Zen nonol lonesen nakon kirekam gwë gweka– zi tan zi. Eiwa de ola hom tangan zëbon onak, sap eiwa de ola zëbon man jawe guk hana gwenan. Zen de boton gwenna, zëbe hap man dakastïlïn, sap zëno enhonak boton en. Zen in zep ki gwëka, boton tam zi, hen zen tïngare boton tam zi mo bian. ");
INSERT INTO ury_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","“Hwëna Ëe eiwa de en nakaë ayang gul gwizimnin, in zebe Asa laïblïbla srëm gwe-gwenan. ");
INSERT INTO ury_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ebon mae onakon, nara molya ano karek-kareksa anakan dam gulsubluka, ‘Em kire kareksae golka.’ Zen in zep, Ëe de eiwa de en naka tawa tabinni, em ba habe Asa laïblïbla srëm gwe-gwenan? ");
INSERT INTO ury_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Alap mo wei-wik gun walasna, zen man Alap mo ola i-san i-san nei gwibirin. Em hwëna bëjen, sap em in zëno walassa hom!” ");
INSERT INTO ury_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yahudi mo mam-mamna men zen zëwe lowe heꞌak dekam zep zë lamang daꞌak, “Em in eiwa Samaria wal karek hen dowal de bi gweblanna!” ");
INSERT INTO ury_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesus ki zep ding gulzimki, “Ëe dowala ban hom. Ëe ama ëre mo Bian mo bosesa de mam gulblun hap syal gwe-gwenan. Em hwëna ema Asa lamang la gwenan. ");
INSERT INTO ury_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ëe ëre mo bosesa de mam gun hup homë syal gwe-gweꞌan. Hwëna ano bosesa de mam gun hup de Zini ki– Zen ngatan zi mo langnak gwëꞌara. Zen man Asa zerzauk sone gwenda. ");
INSERT INTO ury_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","An eiwa denakaë emsa gubiridaꞌan: Men zen ano ol san enlala tatetekam ang ta gweꞌak, zen molya hëndep denaban juwe gwek.” ");
INSERT INTO ury_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ki zep nenblak, “Angkam eiwa mesë emsa dam lasïnïn: Em in dowal mo bi gweblan zi! Abraham Bak orep man tïlkï, hen Alap mo olsa de ayang gun hup de zini hen man juwe gwek. Hwëna em ema gunda, ‘Men zen ano ol san ang ta gweꞌak, zen molya juwe gwek.’ ");
INSERT INTO ury_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Auyan Abraham ki tïlkï. Em san ema enaka kïl tïꞌara?– ‘Ëe an Abraham onakon de teipsïnnï.’ Alap mo olsa de ayang gun hup de zini san ki juwe srëm gwe-gwek! Zep em banakane enaka kïl tïꞌara?” ");
INSERT INTO ury_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ki zep ding gulzimki, “Aen de ëre mo bosesa mam gunkum, dekam eiwa, bëjen Asa taïblïblan. Hwëna men Zen ano bosena mam gul gweꞌara, Zen ëre mo Bian– men Desa em en gweblananke, ‘Ano mae mo Alap’kam. ");
INSERT INTO ury_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Hwëna ena home tame laꞌan. Ëe en kië tame taꞌan. Ëe de anakan gunkum, ‘Ëe homë Alapsa tame taꞌan,’ dekam ki hwëna Ëe boton tam zi, men ki hen em! Hwëna Ëe kië tame taꞌan, deban zëno ol en sanë enlala tatetekam ang gwe-gwenan. ");
INSERT INTO ury_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Eno mae mo auyanna Abraham, zen man hëꞌho gweka– hamal hap kim anakan salka, ‘Ëe asa ngatan zi mo lang nakore Zi Tangansa okama san dep de ati gwennak hla ta soner.’ Kirekam kim Asa hla ta soneka, man tangan sam gwesïkï.” ");
INSERT INTO ury_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ki zep ding nulblik, “Eno tahunna hom lima-pulunak hataꞌan. Em banakan de Abraham Baksa hla tan hap?” ");
INSERT INTO ury_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Dekam zep hwëna ding gulzimki, “Eiwa denakaë emsa gubiridaꞌan: Abrahamsa de jaha gwen srëmnak, Ëe an Zen Tangan– Alap han de bose apde naye.” ");
INSERT INTO ury_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kirekam kim nasalblak, dekam zep zi beyam-byana in kasona lop da inek– dekam de ï tïblan hap. Hwëna Zen dekam zep zëno mae mo nwe nakon aning gwe ine halka, ki zep kon hëndep song gweka. ");
INSERT INTO ury_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Aha yaklakam kim Yesus asa golësek gweka, ki zebë zi nwe dïmïnnï hla laꞌak. Zëno nwena jaha gwennak ki hëndep dïmïn nëblak. ");
INSERT INTO ury_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ëe zëre hon de ang ta gwen wenya dekam zebë Yesussu lakensïblïk, “Guru, nara karek gweka?– an zep ki zini an jaha gwennak hëndep nwe dïmïn gwekaye. San ha zën jaha gweblan srëmnak karek gweka? San ha an-bi zik mo karek nakon ki gwëka?” ");
INSERT INTO ury_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ki zep ap ding gulzimki, “Zen zi mo karek nakon hom ki gwëka. Zen an mae hap ki nwe dïmïn gweka– dekam de zi Alap mo sosonsa zëbon hlaun hup. ");
INSERT INTO ury_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nen nama ngatannake lowe heꞌan, zep angkam nama lwaꞌan– dekam de nen Alap mo syalsa gol gwen hapye, Asa men kirekam de syal gwen hap zer sonekaye. Hwëna kawesïn hïp de yaklanak sa hen hatal. Dekam zini toton bëjen syal gwen. ");
INSERT INTO ury_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ëe de nama okamanak gwënkam, Ëe an Zen– okamana an hap de ngatan naye.” ");
INSERT INTO ury_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kirekam kim gubiridaka, ki zep ol tepna kamanak tïpsïkï, desa zep son naban siri gulku. Dekam zep zini in mo nwena dra soblaka. ");
INSERT INTO ury_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ki zep hwëna gubluka, “Wake, aïlï hona Siloamk ngan sosuk.” Aïlï hona in mo bosena “Siloam” zen enlala naban. Nëno mae mo olkam, “Zer Sonen.” Kim zë ngan sosuku, dekam zep hëndep kara gweka, ki zep gol san dep song gweka. ");
INSERT INTO ury_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Zëre mo gol golek denak de wenya hen men zen mwin-mwankam hla da gwek dekam zep denggwan gweblaꞌak, “An san ha zen hom?– men zen ora alpnak de nikirin nikon te-ala hap nësa aberbe ta gwibirkiye.” ");
INSERT INTO ury_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ahakon man ëgu gweꞌak, “An zen.” Hwëna ahakon man ëgu gweꞌak, “Zen hom. An deban nwe-masena apdenak.” Hwëna Zën zep zënaka kira ta gweꞌanka, “Ëe an dwan zenke.” ");
INSERT INTO ury_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ki zep dakensïk gweblaꞌak, “Em banakane kara gwera? Nara emsa dawem tala?” ");
INSERT INTO ury_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ki zep ding gul gwizimꞌinka, “Zini bosena Yesus kama blëblesa syal gwibiri, dekam zep ano nwena ap dra soblala. Ki zep hwëna asa gublula, ‘Aïlï hona Siloamk ngan sosuk.’ Kimë zë ngan sosul, dekam zebë kara gwer.” ");
INSERT INTO ury_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Dekam zep dakensïblïk, “Zini in angkam endawe gwëꞌara?” Ki zep ding gulzimki, “Ëe homë tawa gweblaꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Dekam zep in zen nwe dïmïn nïkon dawem gweka desa Farisikam de zi hip dikim zerteizimdin hip nërhak. ");
INSERT INTO ury_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yaklana in dekam Yesus kama blëblena syal gwibirki hen dawem taka, zen Hari Sabatkam. ");
INSERT INTO ury_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Farisikam de zini zen hen man dakensïk gweblaꞌak, “Em banakane kara gweka?” Desa hen man ding gulzimki, “Zen ano nwena kama blëblekam dra soka. Kimë ngan sosuk, dekam zebë kara gwek.” ");
INSERT INTO ury_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisikam de zini in ahakon dekam zep ëgu gweꞌak, “Zini in Alap mo zer sonen naka hom, sap zen Hari Sabat hap denaka ngip gul gwenda.” Hwëna ahakon man ëgu gweꞌak, “Hwëna kareksa de gol gwen zini, zen bëjen owas-owasna syal gwibin– zen in kirekam syal gwe-gwibiridaye.” Zen in zep ëhlïwek. ");
INSERT INTO ury_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ki zep etan zini insa dakensïblïk, “Zep ena banakane enlala gweblaꞌara?– sap zen eno nwesa dawem soka.” Ki zep ding gulzimki, “Zen Alap mo olsa de ayang gul gwizimdin hip de zi sike.” ");
INSERT INTO ury_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Hwëna Yahudi mo mam-mamna in hom anakan daïblïblaꞌak, “Zen menkam eiwa nwe dïmïnnï,” dekam zep an-bi zemka kwang nosok– desa de hen takensizimdin hip. ");
INSERT INTO ury_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ki zep dakensizimk, “Zen san eiwa eno nik mo tane? San eiwa nwe dïmïn nïkae ki hëndep jaha gweka? Zen ki angkam banakan kara gweka?” ");
INSERT INTO ury_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ki zep ding ulzimk, “In eiwa, ano nik mo tane sake. Eiwa, zen nwe dïmïn nïka ki jaha gwek. ");
INSERT INTO ury_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Hwëna ëe tawa naka hom– zen banakarekam mes yap angkam kara gweka? Men zen dawem taka ëe hen homë tame laꞌan. Zen mes dwan-am zise gweka. Amki zëna en naka lakensïk gweblak.” ");
INSERT INTO ury_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","An-bi zem kirekam ding ulzimk, sap zen man Yahudi mo mam-mamna insa anakare hap aïrïbiridaꞌak, “Zen sa nësa karek nosol.” Sap Yahudi mo mam-mamna anakan mes ola aha-en nuk, “Zi de anakan gunnu, ‘Yesus zen eiwa Alap mo Zer Sonenna– nësa de ngaya tabin hip,’ desa esa but srëm gola kon olëalsa sone gwibir.” ");
INSERT INTO ury_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","In zep an-bi zem in anakan ding ulzimk, “Zen mes dwan-am zise gweka. Amki zëna en naka lakensïk gweblak.” ");
INSERT INTO ury_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ki zep etan zini insa tïlzïn hap nenblak, zao zep nenblak, “Emki nglïnak de Zi mo nwe kara gwennak asa eiwakam gubiridan! Sap zini in zen emsa dawem taka, ëe mesë tawa ëblak: Zen kareksa de gol gwen zi.” ");
INSERT INTO ury_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ki zep ding gulzimki, “San ha eiwa kareksa de gol gwenna? San ha hom? Ëe homë desa tawa gweblaꞌan. Hwëna aha-enë tawa gwibiꞌin: Ëe menkam nwe dïmïnnï. Hwëna angkam ëe mesë kara gwek.” ");
INSERT INTO ury_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ki zep etan dakensïblïk, “Zen banakarekam emsa gwëblaka? Banakan eno nwena dawem soka?” ");
INSERT INTO ury_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ki zep ding gulzimki, “Ëe mesë desa emsa tonbiridal, hwëna em ema asa asalsïblïl. Em ba habe desa de etan ësane gwen hap ëdwam gweꞌan? Ki san ema hen ëdwam gweꞌan– zëbon de ang ta gwen hapye?” ");
INSERT INTO ury_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Dekam zep lamang tan naban nenblak, “Em in zi karekna in hon de ang gwe-gwenna! Ëe an Musa Baksa de ang gwe-gweblanna. ");
INSERT INTO ury_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nen mese ëtawa gwek: Alap ki Musa Bak hap ola ton sone gweblaka. Hwëna Yesussu home anakan tawa ëblaꞌan, ‘Zen trï ta seꞌara.’” ");
INSERT INTO ury_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ki zep ding gulzimki, “Hwëna an wehasa hom! Em home anakan tawa ëblaꞌan, ‘Zen trï ta seꞌara,’ hwëna zen ano nwesa dïmïn nën naka dawem soka. ");
INSERT INTO ury_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nen mese ëtawa gwek: Alap karek gol gwen zisi bëjen salblan. Hwëna zi de Alapsa betek gweblanna, hen zëno dwam gwibin sin ang gwe-gwenna, desa man salbirida gwenda. ");
INSERT INTO ury_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Okamana ansa de yang gulsun nukon hom tangane anakan ësak, ‘Zini man nwe dïmïn nïka de jaha gwen zi bose zemka dawem taka.’ ");
INSERT INTO ury_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Zini in de Alap onakon hatazan srëmkam, zen molya banakare owas maena syal gwibirinam.” ");
INSERT INTO ury_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ki zep hwëna ding nulblik, “Em in karek gol gwen naka de jaha gwenna, hwëna angkam ema tim guꞌura, ‘Ëe asa Yahudi mo mam-mamna ansa tawa tabir!’” Ki zep hëndep but srëm gola in kon nëralsa sonek. ");
INSERT INTO ury_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesus kim salblaka, “Zini mensa mes nëralsa soner,” ki zep tëblaka. Kim hla taka, zao zep takensïblïka, “Em san ema ngatan zi mo lang nakore Zi Tanganna anakan taïblïblaꞌara?– ‘Zen Alap mo Zer Sonenna.’” ");
INSERT INTO ury_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ki zep ding gulbluka, “Aya Bak, Zen nara Zi? Tame tankam ëe amaka taïblïblaꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ki zep zë gubluka, “Em mese Desa hla tanda. Zen an Debane ola lonꞌnara.” ");
INSERT INTO ury_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ki zep ding gulbluka, “Bian, ëe ama Emsa taïblïblaꞌan!” Dekam zep zë boklena kom soblaka. ");
INSERT INTO ury_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesus ki zep kïtak asa gubiridaka, “Ëe kire habë okamanak hatazak– okamana awe de zisi de anakan klis gun hup: Nwe dïmïn wenya zen sa ëkara gwer. Hwëna ëkara gwen wenya, zen sa ënwe dïmïn gwer.” ");
INSERT INTO ury_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ahakon Farisikam de zini men zen zë dekam lowe heꞌak hen sane daꞌak, ki zep dakensïblïk, “Eno ol gulk sun de blaoranna in, san ha ema asa hen gubiridala?– ‘Em in nwe dïmïnnï.’” ");
INSERT INTO ury_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ki zep ding gulzimki, “Em de eiwakam ënwe dïmïn gwenkam, dekam molyë emsa gubiridaꞌanam, ‘Em ema ëkarek gwenan.’ Hwëna em ema ëk enkam ëgunun, ‘Ëe nwe dïmïn nïka hom,’ zen dekon zebe ëkarek gwenan.” ");
INSERT INTO ury_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesus ki zep ola gulk sun ap blaonzimki, “Eiwa denakaë emsa gubiridaꞌan: Zini men zen domba zaho hap de kandangnak lïlïkïn srëm san tïl zïnna– zen sowë zi, ahaksa zëre mo asaskam de alal gun hup de zi. ");
INSERT INTO ury_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Hwëna lïlïkïn sïn de tïlzïn zini, zen zaho ta gwibin hip de zini zen. ");
INSERT INTO ury_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Lïlïkïnsï de kara son hap de zini sa zaho ta gwibin zini in hap talusublula. Zëre mo domba zahona hen zëno ola man tame nul gwenan. Zëno mae mo bosem-sena kim gubirida gwenda, dekam zep wet noso gweblanan. ");
INSERT INTO ury_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Zëre en mo dena kim golëwet so gwenda, zëna dekam zep ngeirbirida gwenda. Zëre mo domba zahona man ang në gweblanan, sap zëno ola anakan de tame gulblunkam, ‘An zen ano mae mo bi naye.’ ");
INSERT INTO ury_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Aha zisi molya ang nëblak. Zen sa hwëna heya nëblal, sap zëno ola hom tame nulbliꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesus kim kirekam ola gulk sun blaonzimki, ëe hen homë dam ulsuk. ");
INSERT INTO ury_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ki zep etan ap srip gulsuzimki, “Eiwa denakaë emsa gubiridaꞌan: Ëe an domba zaho hap de lïlïkïnnï Zen. ");
INSERT INTO ury_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nonol men zen anakare ola ban yaïng gwe-gwezak, ‘Ëe an emsa de zaho ta gwibin hip de zi,’ zen hwëna sowë zi hen zëre mo asaskam de alal gun hup de zi. Hwëna domba zahona hom kire zisi nasalbirida gwek. ");
INSERT INTO ury_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Diki Ëe an Zen tangan aha-en– lïlïkïn nïye. Men nara Abon osan tïl zïnna, zen zen sa ëngaya gwer. Ëe asa zëbe mae hap golzim– zen dikim aha-ere enlalakam tembane hap ëhakal gwen hap denaye, banakare tësen lwa jal-jal srëm san. ");
INSERT INTO ury_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Sowë zini zen mae hap yaïng gwe-gwenanzal: Ësowë gwe-gwen hap, tamera gwen hap, hen timbwas gul gwen en hap. Hwëna Ëe ngaya tabin hibë hatazak. Ano domba zahona zen dekam tangan sa tahalha srëmkam lowehe gwer.” ");
INSERT INTO ury_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ëe an domba zaho ta gwibin hip de Zi tangan. Ëe zep asa ëre mo angna ëre mo dombasa dikim ngaya tabin hip sosok tazim. ");
INSERT INTO ury_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Hwëna men zen te-ala en hap zaho da gwibirin, zen zaho ta gwibin hip de zi tangansa hom, hen hom tangan bi neibiridaꞌan. Tësen lwa jal-jalsa de hla ta gunkum, zen sa heya-hya gwenkam dombana insa hli nulida gwer. Tësen lwana in ahanaka sa hit tisïlï, hen ahakon dekam sa men-san an-sankam ëheya-hya gwer. ");
INSERT INTO ury_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Te-ala en hap de zaho ta gwibin zini, zen kirekam neibirida gwenan, sap zen hom kwasang neibirida gwenan. ");
INSERT INTO ury_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Ëe an domba zaho ta gwibin hip de Zi tangan. Ëe zep asa ëre mo angna sosok tazim– ëre mo domba zahosa dikim ngaya tabin hipye. Men kirekam ëre mo Bian Asa tame taka, Ëe hen kirekamë ëre mo domba zahona tame ta gwibirin. Hen men kirekamë Biansa tame tak, ëre mo domba zahona hen kirekam Asa tame da gwenan. ");
INSERT INTO ury_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ano aha domba zahona hen ki– men zen Israel mo langnak awe lowehe srëm gwe-gwenanye. Ëe asa desa hen kwang guludal. Zen sa hen Asa nasalbla halzal. Hëndep aumwa hap denak aha-erenak asa ëre mo zaho naban golëlowehe gwer. ");
INSERT INTO ury_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ëre mo Bianna mae hap Asa kwasang gwe-gweblanda: Sap Ëe mesë ëre mo angsa de sosok tazimdin hip hohle gwek, hwëna hyanak asa etan ngaya gwer. ");
INSERT INTO ury_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ëe de Aen gun srëmkam, ‘Diki Ëe tïn,’ dekam bëjen Asa tan. Abe hap mes ëre mo Bian sosonna golblaka– dekam de ëre mo angsa gublun hap, ‘Angkam dekam timni hli yul. Angkam dekam etan gul ine.’ Ëe zebë ëre mo angna ëre mo dwam gwibin sin sosok tazimꞌin.” ");
INSERT INTO ury_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesus insa kirekam gubiridaka, Yahudi zini in dekam zep ëol tetek gwek. ");
INSERT INTO ury_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Zen ahakon man ëguk, “Zini in dowal mes bi gweblaka hen mamakna. Ba hap de desa salblan hap?” ");
INSERT INTO ury_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Hwëna ahakon man ëguk, “Dowala bare zini hom am kirekam de ola don gwibirin! San ha dowala bare zini ki zi nwe dïmïnnï dawem da gwibirin?” ");
INSERT INTO ury_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","Aha yaklakam Yesus Alap mo gol teksonnak të nasen gweꞌanka. Teksonna in man bose nuk, “Salomo Bak mo Dena.” Dekam bot-bot tamlenak, hen ëe Yahudi zini dekam mesë Yerusalemk delapan-enkam de yakla yalak dep tagal gwek. Yakla yawal-yawala in mae hap: Alap mo gola kim orep sam nulsukke– desa dikim enlala gwibin hip. ");
INSERT INTO ury_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Zao zep Yahudi mo mam-mamna tagal nëblazak, ki zep zë dakensïblïk, “Em bawalkam esa asa dam-dam enkam ding gulzimdi? Emki eiwa de tangan naka asa gubiridan: Em an san ha Zen tangan?– Alap mo zer sonen Zini, Israelsa de ngaya tabin hip Denaye. San ha em hom?” ");
INSERT INTO ury_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ki zep ding gulzimki, “Ëe mesë sap emsa gubirida gwek, hwëna em home Asa laïblï gweblak. Owas-owasna mensaë ëre mo Bian mo bosekam syal gwe-gwibirin, zen dekon emaka anakan Asa tame laꞌan, ‘An Zen tangan.’ ");
INSERT INTO ury_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Em hwëna molye Asa laïblïblak, sap em ano domba zahosa hom. ");
INSERT INTO ury_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ëre mo domba zahona zen man Asa nasal gweblanan. Ëe hen ama kïtak tame ta gwibirin. Zen ki Asa ang në gweblanan. ");
INSERT INTO ury_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ëe ama zëbe mae hap hëndep denaban dikim lowehe gwen hap denaka gol gwizimꞌin– zen dikim hëndep denaban juwe srëm gwen hap. Toton nara molya ano taha nakon alal gulku. ");
INSERT INTO ury_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ano Bian mo sosonna man taman kïnïꞌan– in zen domba zahona insa Tane zem abe hap kap gulblukaye. Desa toton nara dep?– ano nik mo taha nakon de alal gun nuye. ");
INSERT INTO ury_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ëe an Zen– Bian han de zeraha-en gwen Zi niye.” ");
INSERT INTO ury_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ki zep mam-mam wenya in kasona lop da ineꞌak– dekam de ï tïblan hap. ");
INSERT INTO ury_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ki zep hwëna Yesus gubiridaka, “Ëe mesë eno mae mo nwenak owas-owasna beya gulzimk– men kirekam de syal gwe-gwibin hip Bian abe hap golblakaye. San ha ano aha owas nakone Asa husus ëblaꞌan?– in zebe Asa kasokam de ï tïblan hap dwam ëblaꞌanye.” ");
INSERT INTO ury_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ki zep ding nulblik, “Ëe eno owas-owas nakon homë kasokam emsa ï lïblaꞌan. Hwëna ere mo Alapsa de lamang tan nakonë emsa ï lïblaꞌan. Em in totore zi tangan, hwëna ere mo gunkum em ema enaka gublula, ‘Ëe an Alap.’” ");
INSERT INTO ury_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ki zep ding gulzimki, “Alap mo ëpba olak, zao man-am emsa gubiridaka, ‘Em in kïtak ëre mo wei-wik gun walas.’ ");
INSERT INTO ury_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Men kirekam Alap mo olak lwak, zen hëndep kirekam sa eiwa lwal. Dekam men zëbe mae hap Alap mo ola in hatazimzik, desa Alap man gubiridaka ‘are mo wei-wik gun walas’kam. ");
INSERT INTO ury_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Zep ba hap de Asa waba hap jal gweblan hap?– sap Ëe ama sapꞌnen ënaka gublunan, ‘Ëe an Alap mo Tane.’ Sap Asa eiwa Bian Zën ki dam tasïkï hen zer soneka. ");
INSERT INTO ury_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ano syal de ëre mo Bian mo syala ban apde nën srëmkam, ki bahem Asa taïblïblan. ");
INSERT INTO ury_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Hwëna Ëe de ëre mo Bian mo kim syal gwe-gwenkam, ki ano syala insa emki anakan taïblïbin, ‘Owas-owasna an eiwa Alap onakorena.’ Asa de taïblïblan srëmkam, hwëna owas-owas in ensa emki kirekam taïblïbin. Dekam esa hëndep anakan ëtawa gwer, ‘Bian eiwa Desa zergwë gwenda, hen Zen eiwa Bian han de zeraha-en gwen Zi.’” ");
INSERT INTO ury_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Dekam zep sap balk tan hap alp dasïk, hwëna Yesus man zëbon mae onakon aya gwe ine halka. ");
INSERT INTO ury_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesus ki zep weyana Yordan mo men eihya san dep asa golëlwanda halka– men zëwe Yohanis Bak menkam baptis ta gwibi'inkake. Zao zep asa golëlowehe gweka. ");
INSERT INTO ury_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Dekam zini beya nik zep Zëbon onak dep yaïng gwe-gwezak. Zen dekam zep ëgu gweꞌak, “Yohanis Bak sap hom owas-owasna syal gwe-gwibirki, hwëna kïtak mensa hamal hap zini an hap dena ayang gul gwizimki, angkam an zep ki eiwa kirekam lwaꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Zen zao zep beya tangankam Yesussu anakan daïblïblak, “An eiwa Zen tangan– nësa de ngaya tabin hip de Zi niye.” ");
INSERT INTO ury_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Zini dekam ki, bosena Lazarus. Zen Yerusalem golek denak ëna Betaniak somor dare zeban zigwë gweka– Maria ne Marta ne ban. ");
INSERT INTO ury_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria in zen Yesus mo tanana irase dawem nabare minyakkam ngan sosubluk, hen zëre mo nol ala blal-blalkam sasa soblak. Hwëna nama de ngan sosublun srëmnak, aya zem in dekam zep sang-sang gweka. ");
INSERT INTO ury_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Dekam zep Yesussu anakan en soneblak, “Bian, eno dang tïnïnak de wal bosena man sang-sangna sabak gweꞌara.” ");
INSERT INTO ury_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesus kim salka, ki zep asa zëre hon de ang ta gwen wenya gubiridaka, “Zëno sang-sangna in tïn hïp denaka hom. Zen hwëna mae hap hla tak: Dekam de zë Alap mo Tanena ano ngatan zi mo lang nakore sosonsa goltreizimdin hip, hen Alap mo bosesa dekon teip gulsublun hap.” ");
INSERT INTO ury_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesus sap man Marta, Maria, hen eis zem Lazarus maesa dang tïnï tabirki, ");
INSERT INTO ury_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","hwëna kim Lazarussu kirekam salblaka, Zen hwëna man zë etan dare yaklakam asa golëgweisïkï. ");
INSERT INTO ury_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ki zep hwëna asa gubiridaka, “Angkam nen etan Yerusalem mo lang san dep lwan dahan.” ");
INSERT INTO ury_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Hwëna ëe ama ding ulblik, “Bian guru, nër hom dekon am Emsa kasokam de ï tïblan hap alp dasïk, hwëna angkam ema hohol gweꞌara– nabakam de etan desan lwahan hap!” ");
INSERT INTO ury_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Hwëna dekam zep ap gulk sun de ol blaorankam ding gulzimki, “Aha-ere yaklakam yakla nwena dua-blas jam enkam am zïl gwenda. Zi de yaklam të naseranna, zen bëjen zaran, sap okamana ansa de ngatan gun hup dena dekam man zïl ane gwenda. ");
INSERT INTO ury_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Hwëna kawesïnnïk de të naserankam, dekam ki altïl gwenan, sap dekam ngatanna hom.” ");
INSERT INTO ury_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kirekam kim asa gubiridaka, ki zep etan ola ap mas gulzimki, “Nëno mae mo wal bosena mes ta guk halka. Ëe ama lï tan hap song gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ëe hwëna dekam ama ding ulblik, “Bian, zen ba hap de duweblan hap? Sap zen de sang-sang hap nisi tankam, zen zën sa totoresa luwera.” ");
INSERT INTO ury_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Hwëna Yesus insa ki ola gulk sun “ta guk han”kam blaonka, zëno enlalana, “Lazarus mes tïlkï.” Hwëna ëe ama zëno ola tim uk, “Eiwa, nisi taꞌara.” ");
INSERT INTO ury_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Zën zep etan damnak asa gubiridaka, “Lazarus mes tïlkï. ");
INSERT INTO ury_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ëe menkam mae habë tol ngaya tan hap duwebla srëm gwek: Sap zen dekam sa eno mae mo Asa de taïblïblanna bïl gwer. Zep haen, nen duweblan.” ");
INSERT INTO ury_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ëe, Yesus hon de ang ta gwen wenya, ano mae mo ahana Tomas, men desaë asyas olkam en gweblak “dan de wë son walas”kam, zen zep asa gubiridaka, “Haen, nen ang gweblan– zao eka Bian han apdekam ërtïk.” ");
INSERT INTO ury_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesus kim ëna iwe asa golëyaïng gweꞌan zaka, zao zep nenblak, “Lazarus Bak mes tïlkï. Mes tol kaso hulak nënnek. Angkam zëwe yaklana mes dan-nër dan-nër nër.” ");
INSERT INTO ury_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ëna Betania zen Yerusalem kon golek. Zëno langana dan-ahare kilometer enkam. ");
INSERT INTO ury_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Zen in zep zë Yahudi zini beyakam Marta ne Maria neka du neizimzik– dekam de zëno nik mo enlwansa së ta sonezimdin hipye. ");
INSERT INTO ury_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta kim anakan sak, “Yesus angkam man golek de gweꞌan zala,” dekam zep ala tablan hap song gwek. Maria hwëna hom ang gwibik. Zen man golak gwëk. ");
INSERT INTO ury_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta kim hla ta guk, ki zep gu gubluk, “Bian, Eme awe gwënanam, ano eisni molya tïlïnam. ");
INSERT INTO ury_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Hwëna ëe tawana: Sap angkam mae de Em ba mae hap Alapsa abe taꞌanam, Zen sa kirekam ebe hap golblala.” ");
INSERT INTO ury_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ki zep ding gulbirki, “Eno osona in sa etan ngaya gwera.” ");
INSERT INTO ury_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ki zep hwëna ding gulbluk, “Ëe tawana: Zen aumwa hap de yaklanak sa ngaya gwera– tïngare ahakore wenya ban.” ");
INSERT INTO ury_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesus ki zep etan gubirki, “Ëe an Zen– juwen nakon de ngaya tabin hip de Zini. Hen hëndep de ngaya tabin hip de Zini, Ëe an Zen. Zini men zen Asa taïblïblanna, zen sap sa juwe gwer, hwëna sa etan ëngaya gwe-gwer. ");
INSERT INTO ury_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Hen zini men zen nama de gwënnak Asa taïblïblanna, zen molya hëndep denaban juwek. Em san ema Asa kirekam taïblïblaꞌara?” ");
INSERT INTO ury_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ki zep ding gulbluk, “Eiwa, Bian, ëe mesë anakan Emsa taïblïblak, ‘Em in Alap mo zer sonen Zi tangan– okamanak de zisi de ngaya tabin hip Dena. Em an Alap mo Tane.’” ");
INSERT INTO ury_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta kim kirekam gubluk, zëna ki zep gol san dep lwahak, ki zep oso zem Mariasa i mwa ennak gubik, “Bian Guru mes golek de gwenan zala. Zen man emsa de goltowen hap dwam gweꞌara.” ");
INSERT INTO ury_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kirekam kim salbik, nabakam zep luwek, hëndep dekam zep ala tablak. ");
INSERT INTO ury_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesus hom dekam ënak hataꞌan naka. Zen nama dekon eiszimꞌinka– men zëwe Martasa goltowekake. ");
INSERT INTO ury_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yahudi zi beyana in zen Maria mo enlwansa dikim së ta sonebin hip golak lowe heꞌak, zen kim nabakam de luwe ine kïnïnnak hla nuk, dekam zep enlala neibik, “Zen aya zemka de drënen kaso hulak de gosa gwën hap song gweꞌan.” Zep noltro kïnïk. ");
INSERT INTO ury_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Hwëna Maria kim abon mae onak hatazak, Yesussu kim zë hla tak, ki zep zë zëno nwenak anakare ola ban ïk gwe hezak, “Bian, Eme awe gwënanam, ano ayana molya tïlïnam.” ");
INSERT INTO ury_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mariasa kim go gwënnak kara guꞌunka, hen men zen ang neibirzik, desa de hen aïtïn-aïtïn go tannak kara tabinkim, enhona man tangan dowebla hanaka. ");
INSERT INTO ury_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Dekam zep takensibiridaka, “Em endawe ënnek?” Ki zep ding nulblik, “Haen. En esa ki zë kaso hula insa hlaulu.” ");
INSERT INTO ury_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesus ki zep hen gona gwëꞌanka. ");
INSERT INTO ury_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yahudi zi beyana in dekam zep ëgu gweꞌak, “Emki hla tan. Zen man sap sërkam dang tïnï taka.” ");
INSERT INTO ury_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Hwëna ahakon man ëguk, “Zen ki am zi nwe dïmïnnï dawem taka. Ba hap Lazarus Swesa nabakam dawem taza srëm gweka?” ");
INSERT INTO ury_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ki zep hëndep Yesus kaso hulak iwe go gwëndan naban golëyaïng gweka. Hula insa mes kaso yawalkam mat nulsuk. ");
INSERT INTO ury_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ki zep gubiridaka, “Kasona insa em irhi gun.” Marta ki zep ding gulbluk, “Hwëna angkam asena karek tangan nakake! Sap angkam yaklana mes-am dan-nër dan-nër nër– drënen hyanakye.” ");
INSERT INTO ury_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ki zep ding gulbirki, “Men kirekamë emsa gubir, em de Asa taïblïblankam, em esa ki hlaulu– Alap kim de soson zemka goltreizimꞌinkaye.” ");
INSERT INTO ury_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kasona insa kim irhi nuk, ki zep nglï san kara gwe seka, ki zep Alapsa gu soneblaka, “Bian, Em Asa sam taꞌara, sap ano abena ema sal gwenda. ");
INSERT INTO ury_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ëe sap tawana: Em home Asa salsïk gweblanda. Hwëna Ëe mae habë kirekam dawemna ebe hap golblanan– zi beyana an dikim ësane gwen hap, hen zen dikim Asa anakan taïblïblan hap, ‘An eiwa Alap zer soneka.’” ");
INSERT INTO ury_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kim kirekam gu sonesïkï, ki zep ol mamkam takenblaka, “Lazarus, em wet sozan.” ");
INSERT INTO ury_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Dekam zep hëndep wet so zaka. Taha-tanana nama deyol ngap-ngapkam de tahalenna, hen aha deyola nwe-masenak. Ki zep Yesus gubiridaka, “Dekam hïl-hïl la soneblak.” ");
INSERT INTO ury_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Zini men zen Maria mo enlwansa de së ta sonebin hip zao lowe heꞌak, kim owasna insa hla nuk, dekam zep beyakam Yesussu daïblïblak. ");
INSERT INTO ury_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Hwëna ahakon kim lwan dahak, dekam zep Farisikam de gubirida gwen wenyaka nenbiridak– Yesus mo owas syal gwibinni insa. ");
INSERT INTO ury_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Zen zep Farisikam de zini hen Alap mo golak de syal tan zi mo mam-mamna Yahudi zi mo teipsïn sinodenak dena kwang nulidak– dekam de ëgolek de gwen hap. Zao zep ëgu gweꞌak, “Nen banakan esa ëblal? Zini in owas-owasna man beya gul gweꞌara! ");
INSERT INTO ury_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nen de nwe enkam kara tankam, ki hwëna tïngan desa sa daïblïblal. Dekam hwëna desa sa langna ansa de teipsïnkïm ïrïk gïn hïp dam dasïl. Dekam hwëna Roma mo mam-mamna sa nësa jal neibiridal. Ki hwëna Alap mo gol yala ansa dekam sa dri nulzir hen nëno kore naka sa damerazal.” ");
INSERT INTO ury_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Dekam zep zini bosena Kayafas Bak, men zen tahunna inkam Alap mo golak de syal tan zi nikon teipsïkï, zen zep gubiridaka, “Em in enlala joblo-topna! ");
INSERT INTO ury_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Diki dawemna nëbe mae hap aha-ere zi de tïnnï aïrïs– dekakim tïngare Yahudi zi juwe srëm gwek.” ");
INSERT INTO ury_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayafas kim kirekam gubiridaka, zen zëre en mo enlala nakon hom ki gubiridaka. Tahunna dekam Alap mo golak de syal tan zi nikon zen teipsïꞌïnka. Zen in zep, kim kirekam Yesussu de zersïn hïp sap gubiridaka, hwëna man nwe-mase gwek– san de Alap mo olsa de anakan hamal hap ayang gulzimdinni kiye, “Yesus sa tïngare Yahudi zisi dikim ngaya tabin hip tïlï.” ");
INSERT INTO ury_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Hwëna Yesus Zen Yahudi zi en hap hom tïlkï. Zen diki tïngare Alap mo hlïl irin zi hip, sap Yahudi srëm zi, men zen tïngare lang san sekwak gwenkam lowe henda gwenanke, desa dikim aha-en gun hup tïlkï. Hwëna Kayafas Bak in kim kirekam guku, zëna gulk sun de enlalana hom dam gulsuku. ");
INSERT INTO ury_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yaklana inkam zep Yesussu de tan hap ola zïm-zïm nïk. ");
INSERT INTO ury_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Zen in zep dekam Yesus Yahudi zi mo nwe nakon langa gwesïkï. Hwëna dua-blaskam de wenya asa en zep golësek gweka– ë bosena Efrayim san dep, zi srëm lang golek denak. Zao zep asa golëlowehe gweka. ");
INSERT INTO ury_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tahunna men kiye, kim Yahudi mo yakla yala Paskanak golek de gwe-gwek, dekam ë-ë san de wenya beyakam Yerusalemk tagal gwe-gwezak. Dekam yaklana iwe de hatan srëmnak nabakam ëtagal gwe-gwezak– dekam de Alap mo golak otweran maesa de tru ta seblankam zëre mae mo karek-kareksa Alap mo nwenak ber-ber gun hup, hen hokam de nola kon zënaka hlë tabirida gwen maekam. ");
INSERT INTO ury_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Zen zep zëno mae mo tagal gwen hap de yakla yala inkam Yesussu Yerusalemk dë gweblaꞌak. Hen kim Alap mo golak ëtagal gwe-gweꞌak, dekam man zënaka anakan dakensibirida gweꞌak, “San ha sa yakla yala an hap hata zala? San ha molya? Em banakane enlala ëblaꞌan?” ");
INSERT INTO ury_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Hwëna Farisikam de zi niban Alap mo golak de syal tan zi mo mam-mam naban mes tïngan anakan tawa dabiridak, “Yesussu de hla tankam, nabakam asa enbiridazak, akakim balk lak.” ");
INSERT INTO ury_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yakla yala Paskanak dikim zaun hup yaklana enam enkam lwa kïnïꞌak, Yesus ki zep dua-blaskam de wenya asa Betania san dep golësek gweka. Lazarus mensa nër hom tïn nïkon ngaya taka, zëno gwë gwenna hen zëwe. ");
INSERT INTO ury_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Zëwe de zini dekam zep tembane yawala syal neibik– Yesus hun de zë zertembane gwen hap. Marta hen man mas gwek– tembanesa de dëre ta guk gwizimdinnik. Lazarus Yesus hun apdenak inikinꞌinka. ");
INSERT INTO ury_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria ki zep minyak narwastu botola ban golhatazak. Minyakna in stenga litera. Zëno irasena sërkam de dawem tanganna– aha minyak naban de siri gun srëmna. Zep desa de gonna te-alana mam tangaranna. Maria ki zep minyakna inkam Yesus mo tanana hlë tazim-blik, zëre mo nol ala blal-blalkam zep hwëna sasa soblak. Gola iwe minyakna in mo irase en zep ëre guk. ");
INSERT INTO ury_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Hwëna ëna Kariot walya Yudas Bak man husus gwibiꞌinka. Zen dua-blaskam de wenya ano mae mo ahana– men zen Yesussu zergukuke. Zen ki zep guku, ");
INSERT INTO ury_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Zen ba hap wabakam hlë tazim? Minyakna in te-ala hap de lirak gulunam te-alana mam tangan naka maka nëp zerzimnin. Desa emaka tahalha zi hip kae ë gwebla-zimꞌin.” ");
INSERT INTO ury_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudas in hwëna tahalha zisi de kwasang gwibiridan hap hom ki guku. Zen in sowë tamna, zep ki kirekam guku. Te-alana mensa zini Yesus hup hen dua-blaskam de wenya abe mae hap kap da gwizimk, zen Yudas zirensïk gweka. Hwëna zen man aha hlïkna twen gweblaka. ");
INSERT INTO ury_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Hwëna Yesus man ding gulbluka, “Dikire gwëk. Zen man Asa sam tanan, sap Asa de drë nwanun hap de yaklanak mes golek de gwer. ");
INSERT INTO ury_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Sap tahalha wenya em desa nama esa olëlowehe tine gwer. Hwëna Asa em molye dakal hap ërgwë gwek.” ");
INSERT INTO ury_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kim ësak, “Yesus Betaniak gwëꞌara,” ki zep Yahudi zini beyakam Yesussu de hla tan hap yaïng gwezak. Hen zen man Lazarussu de hla tan hap ëdwam gwek– mensa tïn nïkon ngaya takake. ");
INSERT INTO ury_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Alap mo golak de syal tan zi mo mam-mamna dekam zep Lazarussu de hen tan hap kalang nëblaꞌak, ");
INSERT INTO ury_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","sap zini beyakam Lazarussu de ngaya gwennak hla tankam zëbon mae onakon wet so gweꞌak– Yesussu dikim hwëna taïblïblan hapye. ");
INSERT INTO ury_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kaꞌankam, ki zep zi beyana men zen yakla yala Paska hap Yerusalemk lowe heꞌak, ki zep ësak, “Yesus angkam man hataꞌara.” ");
INSERT INTO ury_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Dekam zep yera ala makare naka nublunk– men kirekam teipsïn zisi de zerhatannak ëgwë gwekke. Zen kirekam zep ë nakon hut tu ane gun hup wet so gwek, hen te alana inkam wam da guk gweblaꞌak– ol mamkam de anakan ëtaken song gwen naban, “Hëꞌho, hëꞌho! An Bian mo bosekam nësa dikim tatetekam ïrïk gïn hïp hata seꞌara. Diki Alap Zen zëbe hap dawemsa golblan.” ");
INSERT INTO ury_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesus ki zep keledai tane tahannak sewe seka, zao zep nikin ine halka. An kïtak man apde nëk– men kirekam Alap mo ëpba olak lwakke, ");
INSERT INTO ury_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ëna Yerusalemk de zi, bahem ëaïrïn. Bira, eno mae mo teipsïnnï keledai tanenak de nikinhal zankam hataꞌara.” ");
INSERT INTO ury_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","In zen ki zë lwak, ëe zëre hon de ang ta gwen wenya homë dekam dam ulsuk. Hwëna in kim Yesus zëre mo ngatan zi mo lang nakore sosonna goltreizimki– tïn nïkon de ngaya gwenkam, zen dekam zebë dam ulsuk, “Eiyë, hare Alap mo olak kirekam am zëbe hap dena hamal hap ale nulblik. Hare ëe zep am kirekam syal eibir-blik.” ");
INSERT INTO ury_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Mae hap beyakam Yesussu de hut tu ane gun hup wet so gwek: Zini men zen Lazarussu de kaso hulak takenbla irinkim ngaya tannak hla dak, zen beyakam owasna in hap de ola donbirida gwek. Zen in zep beyakam ala da gubluk. ");
INSERT INTO ury_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Farisikam de gubirida gwen zini dekam zep zënaka nenbiridak, “Nen waba habe anakan jalse eibirida gwenan, ‘Zëbon osan bahem ang tan.’ Hwëna emki sap hlauludan. Okamanak de zini angkam zëbon en ëtïngan gweꞌan!” ");
INSERT INTO ury_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Men zen Yerusalemk dekam lowe heꞌak, yakla yala Paskanak de ang tan hap, ahakon hen Yahudi srëm zi. ");
INSERT INTO ury_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Zen dekam zep ano mae mo ahana Pilipus onak yaïng gwezak, ki zep nenblak, “Bian, ëe Yesussu de zertowen habë ëdwam gweꞌan.” Pilipus in, zen Betsaida wal, Galilea mo lang nakon. ");
INSERT INTO ury_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Zen dekam zep Andreaꞌa gubluka, deban zep apdekam Yesussu enblaka. ");
INSERT INTO ury_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesus ki zep asa Yahudi srëm zini in han gubiridaka, “Angkam yaklanak mes tangan golek de gwer– ngatan zi mo lang nakore Zi Tanganna ano bosesa dikim Alap mam gun hup denakye. ");
INSERT INTO ury_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Eiwa denakaë emsa gubiridaꞌan: Ëe an gandum dan makan. Gandum danna kama hulak de drë nwanun srëmkam, zen bëjen eini tën. Tën srëmkam sa lwala. Ëe hen kirekam: Kama hulak de drë nwanunkam, dekam asa eini mamkam tër. ");
INSERT INTO ury_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Hen kirekam, zini men zen zëre mo okamanak de timsi anakan golinik gwenna, ‘Ëe babë tïn,’ zen sa hëndep tim niban jek-jak gwera. Hwëna men zen zëre mo okamanak de timsi Asa de ang gwe-gweblan hap nolaïrï srëm gwe-gweꞌak, zen hëndep denaban sa lowehe gwer. ");
INSERT INTO ury_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Hen men zen abe hap de syala nol gweꞌak, zen diki tana wei san zen Asa zertro gwen. Hëndep lamkam Ëe men zaoë gwëꞌak, zen hen zëwe sa yaïng gwer. Men zen kirekam abe hap de syala nol gweꞌak, ano Bian sa zëbe mae hap bose dawemna golzimdi.” ");
INSERT INTO ury_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ki zep ayang gulzimki, “Ano enhona man tangan dowe hanaꞌara. Zep Ëe banakan asa Biansa gu soneblal? San ha anakanë gu soneblan?– ‘Bian, Abon onakon karek yala ansa langa gulsuk– in zen Abon onak dep golek de gweꞌanye.’ Hwëna kirekam bëjënë, sap Ëe an kire habë hatazak– karek yala insa de goltowen hap. ");
INSERT INTO ury_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Zep Ëe a kire enkam asa gu soneblal: ‘Bian, diki tïngare zi mo nwenak ere en mo bosesa Emki mam gun.’” Ki zebë hwëna kïtak ngatan zi mo lang nakore ola anakan ësalsek, “Ëe mesë Ebon onakon ëre mo bosena mam guk, hen etan asa kirekam mam gul.” ");
INSERT INTO ury_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Hwëna zi beyam-byana men zen zë ëzauꞌuk ahakon man ëguk, “In nglï tadrenda.” Hwëna ahakon man ëguk, “Ki hom. In Alap mo dam taha nakore zi ki gublunda.” ");
INSERT INTO ury_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesus ki zep gubiridaka, “Ola in zen wet sonanhal, zen Ëe de sane gwen hap hom. Zen hwëna em de ësane gwen hap. ");
INSERT INTO ury_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ano syala an dekam sa Alap okamanak de zi mo enlala aning tanna zerwet sozimdi– dekam de karek tabin hip. Hen angkam de ïrïk gïn zini dowal mo kïgïsa dekam sa tanakam holenak zaublu inera. ");
INSERT INTO ury_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Hwëna Asa kim de okamana an kon neir ine haꞌak, zen dekam asa tïngare zi ausu dikim Abon onak yaïng gwezan hap de orana kles tyasizim.” ");
INSERT INTO ury_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kim kirekam gubiridaka, Zen man kim anakan goltreizimꞌinka, “Ëe an kirekam de tïnsï asa hlaul.” ");
INSERT INTO ury_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Zi beyana in kon dekam zep ding nulblik, “Alap mo olak man lwak, ‘Alap mo Zi zer sonenna, Israelsa de ngaya tabin hip Dena, Zen hëndep denaban sa gwë gwera.’ Zep em ba habe anakan gulu?– ‘Ngatan zi mo lang nakore Zi Tanganna Asa sa okamana an kon neir inehal.’ Em insa ‘ngatan zi mo lang nakore Zi Tangan’kam enaka zerlëwe gwenda, hwëna ëe homë dam ulsuk gwenan, ‘Em ba habe ki kirekam gu gwenda?’” ");
INSERT INTO ury_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ki zep ding gulzimki, “Okamana an hap de ngatan nabare Zini, Ëe an Zenë angkam kolengkam emsa golëlowe heꞌan. Hwëna kawesïnnï sa nabakam emsa jap guludal, hen dekam kawesïnnïk esa ëbute halasen gwer. ");
INSERT INTO ury_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Zep ngatansa de golzimdin hip de Zini Asa em taïblïblan. Zen dekam esa enho nakon ëngatan gwer– dekam de ëbute halasen gwen srëm hapye.” Kirekam kim gubiridaka, ki zep dua-blaskam de wenya asa golësek gweka, hen dekam zep zi beya mo ëtawa gwen srëmnak asa golëlowehe gweka. ");
INSERT INTO ury_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Zen sap man owas-owasna beya gulzimki, hwëna zi beyana in hom daïblïblak. ");
INSERT INTO ury_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","An kïtak Alap mo ol ayang gul gwen zini Yesaya Bak mo olsa dikim sul sonen hap ki kirekam lwak. Sap Yesaya mo ola Yesus hup man dakastïlblïꞌan– zen insa anakan Alapsa gu soneblakaye: “Bian Alap, nëno nik mo ol ayang gulzimdinni hom am daïblïbiꞌin! Hen owas-owasna mensa Ena ere mo taha sosonkam syal gwe-gwibirida, desa hen hom tame nuꞌin.” ");
INSERT INTO ury_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Zen mae hap daïblïbla srëm gwek: Sap Yesaya Bak hen man Alap mo ola anakan hamal hap ayang gulzimki: ");
INSERT INTO ury_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ëe mesë zëno mae mo nwena dïmïn tabir-zimk, hen zëno mae mo enhona mesë kawesïn tazimk. Dekam molya nwekam lalak dasïk, hen enhona molya ëhleng gwizimk. Dekam molya Abon osan dep etan lwanda halzak. Lwan dahal zankam ki Ëe amaka ngaya tabiꞌin.” ");
INSERT INTO ury_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaya mae hap kirekam Alap mo ola insa ale gulku, sap zen ngein sin Yesus mo ngatan zi mo lang nakore sosonsa hlaulku. ");
INSERT INTO ury_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hwëna ahakon man sap daïblïblak– sap Yahudi mo ahakore mam-mamna. Hwëna Farisikam de zini man Yesussu de ang gweblan hap jalse neibirida gwek, zen in zep dekam damnak ëkira gwe srëm gwek. Mae hap kirekam ëgwë gwek, sap man anakan ëaïrï gwek, “Asa sa hwëna but srëm gola kon nëralsa soner.” ");
INSERT INTO ury_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Zen dawemkam zi bose zik de sam gwesibiridan hap denaka dwam nei gwibik. Zen hom dekam anakan ëenlala gwe-gwek, “Diki Alap Zën de asa sam gwesïblïnna aïrïs.” ");
INSERT INTO ury_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesus anakan sap ki gubirida gweka, “Zini men zen Asa taïblïblanna, zen Asa en hom taïblïblaꞌara, hwëna zen hen dekam ano Biansa taïblïblaꞌara– men Zen Asa zer sonekake. ");
INSERT INTO ury_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Men zen Asa hla da gweꞌan, zen ki hen, men Zen Asa zer soneka, Desa hen man hla da gweꞌan. ");
INSERT INTO ury_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ëe sap okamanak awe ngatansa de golzimdin hibë hatazak. Zep zini men zen Asa taïblïblanna, zen sa kawesïn nïkon wet so gwer. ");
INSERT INTO ury_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","48","“Ëe okamanak awe karek tabin hip homë hatazak. Ëe hwëna ngaya tabin hibë hatazak. Zep men zen de Asa baes në gweblaꞌak hen ano ol san de ang tan hap baes ta gweꞌak, Ëe Aen molyë desa aumwa hap de yaklanak karek tabik. Hwëna ano ola men desa zëna baes nei gwibik, zen zep sa Alap anakare ola ban karek tabiri, ‘Em ba habe desan ang ta srëm gwek?’ ");
INSERT INTO ury_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Sap Ëe ëre mo enlala san denaka homë tonbirida gwenan. Hwëna Bian men Zen Asa zer soneka, Zen mensa ayang gul gwizimdin hip abe hap golblaka, Ëe desa enë ayang gul gwizimnin. ");
INSERT INTO ury_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Hen Ëe tawana: Tïngan men zen Bian mo ol san ang ta gweꞌak, zen zen sa hëndep de lowehe gwen hap de oranak ëwet so kïnï gwer. Zen in zep, Bian men kire enkam ayang gul gwizimdin hip Asa gu gweblanda, Ëe desa enë tawa ta gwibirin.” ");
INSERT INTO ury_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yaklana dekam aha-en lwa kïnïꞌanka– yakla yawala Paskanak dikim hatan hap. Yesus dekam mes anakan tame guꞌunka, “Angkam mes hatal– Ëe dikim okamana ansa hli yun hup, hen Bian osan dep dikim lwahan hap denakye.” Tïngan men zenë ang ë gweblak, asa man tangan kwasang gwibirida gweka. Hëndep kim Bian osan dep etan lwa haꞌanka, kire enkam ki hëndep asa kwasang gwibirida gweꞌanka. ");
INSERT INTO ury_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yaklana inkam, kim Yesus asa golëtembane taꞌanka, hwëna dekam dowal mo kïgïna mes Yudas hap Yesussu de zergun hup de enlalana ing ta soneblaka. Yudas in Kariot walya Simon mo tane. ");
INSERT INTO ury_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesus dekam mes anakan tame gulku, “Bian mes tïngare sosonna abe hap golblaka. Ëe sap zëre onakonë hatazak, hen angkam zëre osan debë etan lwa haꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Sap kirekam mes tame gulku, zep tembane tan nakon luweka, ki zep tahan bajuna alsïkï, hen dekam zep handuknu obun tïhïnak da taka. ");
INSERT INTO ury_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Hen ki zep hona blomenak sul soneka, dekam zep ano mae mo tanana ngan tasibir-zimꞌinka. Handuknu inkam zep sasa ta gwibir-zimꞌinka. ");
INSERT INTO ury_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kim Simon aha bosena Petrus hon hataꞌan zaka, ki zep zë takensïblïka, “Bian, Em ba hap de ano tanana ap ngan sosublun hap?” ");
INSERT INTO ury_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ki zep ding gulbluka, “An desaë angkam syal gwibiꞌin, em molye angkam tame gulku. Hwëna lamkam esa tame gulu.” ");
INSERT INTO ury_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petrus ki zep gubluka, “Bëjen! Em toton bëjen Em ano tanana ap ngan sosublun!” Dekam zep ding gulbluka, “Ëe de eno tanasa ngan sosun srëmkam, ki em ema Abon onakon wet soꞌara.” ");
INSERT INTO ury_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ki zep ding gulbluka, “Bian, kirekam de lwankam, ki tana enna bahem ap ngan sosublun. Ki hëndep taha naban nola ban ap ngan sosublu!” ");
INSERT INTO ury_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesus ki zep gubluka, “Ho awan zini hom ëdwam gwe-gwenan– etan de tim niban awan hapye. Diki tanana, zen të naserankam de son nënkam. Desa man ngan sosun hup dwam nei gwizimnin. Dekam kïtak de timni mes ngan gwe henan. Em kïtak mese ëngan gwehek. Hwëna ebon mae onakon aha-en, zen hom ngan gwe heꞌara.” ");
INSERT INTO ury_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesus mes anakan tame gulku, “An zen sa Asa dikim zë balk tan hap zertreizimdi,” zen in zep anakan asa gubiridaka, “Ebon mae onakon aha-en, zen hom ngan gwe heꞌara.” ");
INSERT INTO ury_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ano mae mo tanana kim ngan tasibinkim so ta sonebirki, ki zep tahan baju zem etan ala soka, dekam zep zëre mo nikin gwennak dep lwa halka. Dekon zep nonol asa takensibiridaka, “Mensaë ebe mae hap syal gwibir-zimnin, em wëhë tame uꞌin? ");
INSERT INTO ury_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Em Asa ‘guru’kam hen ‘bian’kame en gweblanan. Zen aïrïs, sap Ëe an eiwa eno mae mo kire. ");
INSERT INTO ury_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ëe sap eiwa eno mae mo bian hen guru, hwëna Ëe mesë eno mae mo tanana ngan tasibir-zim. Zep em hen diki kirekam de enaka gweibirida gwen– ere mae mo tanasa de hwë-hwëkam babu gwen zi mo kim ngan tasïk gwibir-zimdinkimye. ");
INSERT INTO ury_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ëe mesë Ënaka ërak makan drë nenan– em dikim hen kirekam enaka gweibirida gwen hap. ");
INSERT INTO ury_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Eiwa denakaë emsa gubiridaꞌan: Zi mo tana ïltïkïnnïk de babu gwen zini bëjen zëre mo zi bina insa kwë tan. Hen zini men zen aha zi mo olsa golsong gwe-gwenna, zen betekna. Men zen zer sone gwenna, zen mamna. ");
INSERT INTO ury_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Angkam em ema anakan tame uꞌin, ‘Ëe an betekna,’ zep em de kirekam enaka enlala betekkam mas gwibirida gwenkam, ki esa hëꞌho gwibinni hla kul gwer. ");
INSERT INTO ury_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ola in desa emsa gubiridanan, zen man ebe mae hap dakastïlzimꞌin, diki ahaꞌen. Ëe mesë kïtak emsa tame tabik, hëndep zebë emsa dam tasibik. Hwëna sap kirekam, mensa orep abe hap dena Alap mo olak hamal hap ale nukke, zen kirekam sa ki hëndep lwal– anakan men zen lwak, ‘Zini men debanë zertembane gwe-gwek, zen hwëna ano jal zi hip sa jowera.’ ");
INSERT INTO ury_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","An zebë desa hamal hap emsa gubiridanan: Sap in kim joweꞌak, zen dekam esa Asa anakan laïblïblal, ‘An Zen Tangan– Alap mo zer sonen Zi niye.’ ");
INSERT INTO ury_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Hen Ëe eiwa denakaë emsa gubiridaꞌan: Zi de ano zer sonen zisi zer irinni, zen ki hen Ënaka zer inꞌira. Hen zini men zen Ënaka zer irinni, zen hen Bian, men Zen Asa zer sone zaka, Desa hen zer innira.” ");
INSERT INTO ury_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesus kim kirekam gubiridaka, dekam zep tangan enlalana dowebla hanaka, ki zep damnak asa gubiridaka, “Eiwa denakaë emsa gubiridaꞌan: Ebon mae onakon ahanik sa Asa dikim zë balk tan hap zertreizimdi.” ");
INSERT INTO ury_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ëe dua-blaskam de dam tasibin wenya dekam zebë ënaka ngalap naban karatda labiꞌik– mae hap: “An narasa ki gublunda?” ");
INSERT INTO ury_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Abon mae onakon, ahana men desa Yesus kwasang gwe-gweblaka, zen dekam zëre mo dam taha nakon nikinꞌinka. ");
INSERT INTO ury_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Petrus dekam zep zëbe hap tahana wap gulsubluka, ki zep gubluka, “Emki takensïblïn: Zen narasa ki kirekam gublunda?” ");
INSERT INTO ury_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Zini in ki zep golek de ta zaka, zao zep takensïblïka, “Bian, narasae ki enlala gweblala?” ");
INSERT INTO ury_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ki zep ding gulbluka, “Ëe kimë rotina ansa kolho honak os gul aneꞌak, men zëbe habë golblaꞌak, zen zen.” Ki zep roti apna insa os gul ineka, desa zep Yudas Bak hap golblaka. ");
INSERT INTO ury_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudas kim roti apna insa twinbirki, dowal mo kïgïna dekam zep hwëna ing gwe heblaka. Yesus ki zep gubluka, “Mensa ena kalang gweꞌara, nabakam syal gwibir.” ");
INSERT INTO ury_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Hwëna Yesus insa kirekam gubluka, ëe in zenë zë teinikinꞌik ëe homë dam ulsuk. ");
INSERT INTO ury_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudas zen zen Yesus mae han ano mae mo te-alana zirensïk gweka, zep ano wal bose walya ahakon man tim nuk, “Yesus man yap gublula– tembane maesa de yakla yala awe dep lop tan hap.” Hwëna ahakon man tim nuk, “Zen te-alasa de tahalha zi hip kae gwebla-zimdin hip mes yap gulblula.” ");
INSERT INTO ury_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudas in kim roti apna insa twinbirki, ki zep hëndep gola in kon te soka. Dekam mes kawesïk. ");
INSERT INTO ury_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas kim song gweka, Yesus ki zep asa gubiridaka, “Angkam mes zaul– ngatan zi mo lang nakore Zi Tanganna ano bosesa dikim Alap mam gun hup denakye. Hen Abon onakon sa kïtak Alap mo bosena teip nulsublunda gwer. ");
INSERT INTO ury_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Abon onakon kim de zini Alap mo bosena teip nulsubluꞌak, Zen dekam sa hwëna Alap ano bosena etan dawemkam mam gulsublula– zëre onak kimë hataꞌakye. An nabakam sa ki lwal. ");
INSERT INTO ury_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Em ano dang tïnïnak de walas, Ëe molyë holokam eban mae golëlowehe gwek. Em esa Asa lë gweblal. Hwëna men kirekamë Yahudi zisi gubirida gwek, angkam Ëe hwëna emsa hen kirekamë gubiridaꞌan: Men zao debë song gweꞌan, em molye desan Asa ërtrok. ");
INSERT INTO ury_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Zep angkam Ëe tïtï tabin ol ësena ansa ebe mae hap hli yulzimꞌin: Em enaka kwasang gwibirida gwen. Ëe men kirekamë emsa kwasang gwibirida gwekke, em hen kire enkam enaka kwasang eibirida gwek. ");
INSERT INTO ury_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kirekame kwasang naban lowehe gweꞌak, dekam sa tïngare zini anakan emsa tame da gwibir, ‘Zen eiwa Bian zëre hon de ang ta gwen wenya.’” ");
INSERT INTO ury_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon mensa hen nen gweblak “Petrus”kum, zen dekam zep takensïblïka, “Bian, Em endan san esa song gwera?” Ki zep ding gulbluka, “Men zao debë song gweꞌan, em molye angkam Asa desan zertroka. Hwëna lamkam esa ki Asa zertrola.” ");
INSERT INTO ury_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ki zep hwëna etan takensïblïka, “Bian, hwëna ëe ba hap de angkam Emsa ang gwebla srëm gwen hap? Ëe mesë tangan hohle gwenan– Emsa de zerzaunnuk de hwëna tïn hïpye.” ");
INSERT INTO ury_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ki zep hwëna ding gulbluka, “Em san eiwa tangane kirekam hohle gweꞌara?– Asa de zerzaunnuk de hwëna tïn hïpye. Eiwa denakaë emsa gubluꞌan: Ayang de gun srëmnak, em dan-ahan sonkam esa anakan Asa zabeblala, ‘Zini in ëe homë tame taꞌan.’” ");
INSERT INTO ury_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesus ki zep zëre hon de ang ta gwen wenya asa gubiridaka, “Bahem enlala nakon ëngalap gwen. Alapsa em taïblïblan, hen Asa emki taïblïblan. ");
INSERT INTO ury_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ano Bian mo gol yala, teksonna beyana. Hen Ëe desanë song gweꞌan– em de zë lowehe gwen hap denaka dikim hamal gulzimdin hip. Kirekam de lwan srëmkam, Ëe molyë kirekam emsa gubiridananam. ");
INSERT INTO ury_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kimë kïtak hohle gulzimꞌik, dekam asa etan lwa halzal– emsa dikim zëwe dep kwang guludahan hapye, apdekam dikim emsa zëwe golëlowehe gwen hap. ");
INSERT INTO ury_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Hen men zao debë song gweꞌan, em orana tawana.” ");
INSERT INTO ury_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas ki zep takensïblïka, “Bian, ëe homë anakan dam ulsuꞌun, ‘Em desan debe song gweꞌara.’ Ëe banakan de orana insa tawa gweblan hap?” ");
INSERT INTO ury_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesus ki zep ding gulbluka, “Ëe an Zen tangan– eiwa de oranaye, em dikim hëndep de gwën hap denaka hlaun hup denaye. Em de Abon osan ang gwen srëmkam, em bëjen em Bian onak hatan. ");
INSERT INTO ury_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Asa de tame tankam, ki ano Biansa hen ema tame laꞌan. Angkam tangan esa Asa dawemkam tame lal, zebe hen Biansa tame laꞌan, hen mese Desa hla la gwek.” ");
INSERT INTO ury_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilipus ki zep gubluka, “Bian, ere mo Biansa abe mae hap zertreizim. Dekam asa ësam gwesïl.” ");
INSERT INTO ury_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ki zep ding gulbluka, “Ëe mesë sap holokam emsa golëlowehe gwek, zep Pilipus, em ba habe Asa tame ta srëm gweꞌara? Zini men zen Asa hla tanna, zen hen ano Biansa hla tanda. Zep em de Asa tame tankam, em ba hap de Asa gublun hap?– Ëre mo Biansa de zertreizimdin hipye. ");
INSERT INTO ury_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Em san home Asa taïblïblaꞌara?– Ëe an Zen, Bian han de zeraha-en gwen Zi niye, hen Zen aban aha-en. Ola mensaë ebe mae hap ayang gul gwizimnin, zen ëre en mo enlala nakore olsa hom. Hwëna Bian men Zen ano enhonak gwë gwenda, Zen Zen Asa zersyal gwe-gwenda. ");
INSERT INTO ury_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ansa emsa gubiridaꞌan, desa em taïblïbin: Ëe mesë Bian han zeraha-en gwek, hen Zen mes aban zeraha-en gweka. Ano olsa de taïblïbin srëmkam, ki ano owas-owas syal gwe-gwibin ensa em taïblï gwibin. Zen dekam esa hëndep Asa laïblïblal. ");
INSERT INTO ury_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Eiwa denakaë emsa gubiridaꞌan: Zini men zen Asa taïblïblanna, zen sa ano kim syal ta gwer– Ëe men kirekamë syal gwe-gwenanye. Asa de taïblïblan zini, zen sa hen ano syala kwei nul gwer– banakare owassa de mamkam syal gwe-gwibinkimye. Zen mae hap sa ki lwa gwer: Sap Ëe Soson Zini Bian osan debë song gweꞌan– dekon de emsa mas gwibirida gwen hap. ");
INSERT INTO ury_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Em de Alapsa banakare mae hap ano bosekam abe tanna, Ëe asa desa ep syal gwe-gwibir-zim. Dekam sa zini Bian mo sosonna hla nul gwer, hen zep sa Biansa boltere da gwer. ");
INSERT INTO ury_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Asa de banakare mae hap ëre mo bosekam abe tanna, Ëe asa ki desa ebe mae hap syal gwe-gwibir-zim.” ");
INSERT INTO ury_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Em de Asa ensa lwa gweblankam, ki esa ano ol san ang ta gwer. ");
INSERT INTO ury_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Hen Ëe asa Biansa abe tal– Zen deka ebe mae hap Zisi Ahanaka zer sonezimki, Zen de emsa mas gwibirida gwen hap. Zen Zen sa hëndep denaban emsa golëlowehe gwera. ");
INSERT INTO ury_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Zen Alap mo Enho. Zen Zen– eiwa de enlalasa de ing ta sone gwizimdin hip de Zi niye. Auhu-kama enlala zini, zen molya Desa neirin gwek, sap desa nwekam bëjen hla tan, hen zen bëjen Desa tame tan. Hwëna em en mese Desa tame lak, sap Zen emsa golëlowehe gweꞌara, hen Zen sa eno mae mo enhonak gwë gwera. ");
INSERT INTO ury_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ëe molyë emsa kwasap walas mo kim da tasibik. Ëe asa etan emsa hlauluda gwezal. ");
INSERT INTO ury_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Molya holo gwek, okamanak de zini dekam etan molya Asa hla da gwek, hwëna em en esa Asa hla la gwer. Ëe asa etan tïn nïkon ngaya gwer. Zep em hen esa ëngaya gwer. ");
INSERT INTO ury_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yaklana zëwe de hatankam, zen dekam esa abe hap dena anakan tame ul, ‘Zen eiwa mes Bi zeban zeraha-en gweka. Hen eiwa nëban mae mes golëaha-en gweka.’ ");
INSERT INTO ury_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Men zen ano ol san enlala tatete naban ang ta gwenan, zen zen Asa enna nola gweblanan. Zen kire zisi sa ano Bian kwasang gwibirida gwera– men zen kirekam Asa enna nola gweblananye. Aena hen asa kwasang gwibirida gwer, hëndep zep asa Ënaka zëbe mae hap zertrei gwizim.” ");
INSERT INTO ury_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Hwëna ëna Kariot walya Yudas Bak mo apde bosena Yudas, zen dekam zep takensïblïka, “Em banakan esa abe mae en hap Enaka zertreizimdi– okamanak de zi de Emsa hla tan srëmkamye?” ");
INSERT INTO ury_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ki zep ding gulbluka, “Zini men zen de Asa enna nola gweblaꞌak, zen sa ano ol san enlala tatete naban ang ta gwer. Hen Bian sa desa kwasang gwibirida gwera, hen Ëe asa Bian han zëno mae mo enho nakon olëlowehe gwer. ");
INSERT INTO ury_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Hwëna zini men zen Asa enna nolabla srëm gwe-gwenan, zen molya ano ol san ang ta gwek. Hwëna emki ëenlala gwe-gwen: Ano ola, zen ëre onakore naka hom. Zen Bian onakorena– men Zen Asa zer sonekake. ");
INSERT INTO ury_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ëe mesë nama de emsa golëlowe hennak kirekam gubiridanan. ");
INSERT INTO ury_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Hwëna ano tim bwanak Bian sa emsa de mas gwibirida gwen hap de Zini insa ebe mae hap zer sonezimdi. Zen zëre mo Enho. Zen Zen sa hwëna emsa enlala sobirida gwera– Ëe men desaë emsa tawa ta gwibikye. Hen Zen Zen sa eiwa de en naka ano weinak tawa tabir song gwera. ");
INSERT INTO ury_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Angkam Ëe ama ebe mae hap em dikim Alap mo taha terenak ëngalap gwen srëmkam lowehe gwen hap denaka hli yulzimꞌin– Aena men kirekamë ngalap gwen srëmkam gwë gwenanke. Auhu-kamanak awe aha zi molya kiresa ebe mae hap nolzimk. Zep bahem enlala nakon ëngalap gwen hen bahem ëaïrïn. ");
INSERT INTO ury_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Em kie Asa asalblal kimë emsa gubiridal, ‘Ëe ama emsa hli yuludaꞌan, hwëna asa etan emsa hlauluda gwezal.’ Em de dawemkam Asa kwasang gweblankam, ki emaka ësam gwesïl– anakan de Asa salblankamye, ‘Ëe Bian osan debë song gweꞌan.’ Sap ano Bianna Zen Abon onakon teipsïnnï. In zebë duweblaꞌan. ");
INSERT INTO ury_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","An zebë hamal hap emsa gubiridanan. Sap in kim kirekam joweꞌak, dekam esa Asa laïblïblal. ");
INSERT INTO ury_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Angkam Ëe molyë holokam eban mae kire hap de ola ziton gwibik, sap okamana ansa de ïrïk gïn zini dowal mo kïgï angkam man hataꞌara. Zen Asa bëjen ïrïk tan. ");
INSERT INTO ury_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ëe in zep asa Bian mo abe hap kïtak de dwam gwibir-blin san ang gwer. Zen dekam sa okamanak de zini Asa anakan tame dal, ‘Zen eiwa man zëre mo Biansa ensa lwa gweblanda.’” In kim kirekam asa tawa tabiꞌinka, ki zep etan asa gubiridaka, “Haen. Nen gola an kon sek gwen.” ");
INSERT INTO ury_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesus ki zep etan asa tawa tabirki, “Ëe an Zen anggur te tangan naye. Em in hwëna ano hli-hlina. Ano Bianna, Zen hli-hli naka de tasyalsïk gwibin hip de Zi. ");
INSERT INTO ury_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ano hli-hli nik de ëtën srëmna, desa man blum gulsuk gwenda. Men zen ëtë gwenan, desa man ala naka hen mas-mas naka blum gulsuk gwenda– dekam de mamkam ëtë gwen hap. ");
INSERT INTO ury_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Emsa mes ëre mo olkam tasyalsïk gwibirki– dekam de dawemkam ëtë gwen hap. ");
INSERT INTO ury_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Abon onak em ëmas gwirin, dekam Ëe asa eban mae golëaha-en gwer. Hlina zë-en bëjen eini tën. Diki apdenak timnik de ësaltïl irinkim. Em hen kirekam. E-en molye eini ëtëk– aban de zeraha-en gwen srëmkamye. ");
INSERT INTO ury_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ëe an anggur te. Em in hli-hlina. Zi de Abon mas gwirinni, hen Ëe de deban zeraha-en gwenna, dekam zëno danna beyana. Sap Ëe srëmkam, em bëjen ba maesa syal gwibin. ");
INSERT INTO ury_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Zi de Abon mas gwirin srëmna, zen men kiye– anggur hlisa de tasyalsibinni. Zen ësasan gwenkam kire syauknuk yal tasen– zëwe de ëhwasden hap. ");
INSERT INTO ury_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Em de aban zeraha-en gwenkam hen ano ol de ebon mae lwa gwenkam, dekam em basa de dwam gwibinkim, emki kire hap Alapsa abe ta gwen. Zen sa dekam ebe mae hap gol gwizimdi. ");
INSERT INTO ury_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Em de dawemkam dan nik ëtë gwenkam, dekam sa aha zi ano Bian mo sosonna ebon mae onak hla nul gwer. Dekam sa hen emsa tame da gwibir, ‘Zen Abon de ang ta gwen wenya.’ ");
INSERT INTO ury_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Men kirekam ano Bian Asa kwasang gwe-gweblanda, Ëe hen kirekamë emsa kwasang gwibirida gwenan. Ano kwasang-kwasangnak emki lowehe gwen. ");
INSERT INTO ury_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Em de ano ol san enlala tatete naban ang ta gwenkam, dekam ano kwasang-kwasangnak esa lowehe gwer– Aena men kirekamë hen ëre mo Bian mo ol san enlala tatete naban ang gwe-gwenanke. Zep Ëe zëno kwasang-kwasangnakë gwë gwenan. ");
INSERT INTO ury_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ëe mae habë kïtak insa gubiridanan– Abon onakore isrip-sri dekakim eno mae mo enhonak lwa gwek. Dekam eno mae mo isrip-srina sa tangan taman kïnï gwer. ");
INSERT INTO ury_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","An zebë hen ola ansa hli yulzimꞌin: Enaka em kwasang gwibirida gwen– men kirekam Ëe hen emsa kwasang gwibirida gwenanke, em hen kirekam enaka kwasang eibirida gwek. ");
INSERT INTO ury_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kwasangna taman kïnïn tangan wenya an zen: Zi de wal bosyansa de ngaya tan hap zëre mo timsi sosok gunnu, hëndep zep de tïnnï. Zen zen– sërkam de mam tangan wenyaye. ");
INSERT INTO ury_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Em de ano ol san enlala tatete naban ang ta gwenkam, em ki eiwa ano wal bose wal tangan. ");
INSERT INTO ury_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Angkam Ëe homë etan Abon de babu gwen zikim emsa gubiridaꞌan. Sap kirekam ebe mae hap hom dakastïlzimꞌin, sap babu gwen zini hom zëre mo zi bina in mo syala tame nul gwenan. In zebë hwëna angkam wal bose walkam emsa gubirida gweꞌan. Sap mensaë Bian onak sane gwe-gwek, Ëe desaë ebe mae hap ayang gul gwizimk. ");
INSERT INTO ury_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Em home Asa dam lasïk– Ëe dikim emsa bi gwibiridan hapye. Diki Ëyë emsa dam tasibik– dekam de ano olsa gol halada gwen hap, hen em dikim dan nik ëtë gwen hapye. Em insa danna ëtë gweꞌan, zen hëndep de ëlwa gwen hap dena. Zen zep sa Bian eno mae mo abena dokwak gul gwera– em de ano bosekam abe ta gwenkamye. ");
INSERT INTO ury_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Zen in zebë ebe mae hap ola ansa hli yulzimꞌin: Enaka kwasang eibirida gwek.” ");
INSERT INTO ury_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Auhu-kama enlala zini sa emsa husus neibirida gwer. Kirekam kim de ebon mae jowe gweꞌak, zen dekam ëenlala gwe-gwek, ‘Ano teipsïnnï hen kirekam në gweblak.’ ");
INSERT INTO ury_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Eme nama auhu-kama enlala zi niban enlala siri tankam lowehe gweꞌanam, dekam zen maka emsa kwasang neibirida gweꞌan. Hwëna Ëe mesë emsa zëbon mae onakon hlïl inhak. Em mese zëbon mae onakon wet so gwek, zen zep emsa husus neibirida gweꞌan. ");
INSERT INTO ury_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Anakan mensa emsa gubirida gwek, desa emki enlala gwe-gwibin: ‘Zi bina, zen mamna. Zëbon de babu gwen zini, zen betekna.’ Zep men kirekam ere mae mo mamna Asa në gweblak, zen kirekam sa hen emsa neibirida gwer. Zen man Asa karek da gwek. Zep emsa hen kirekam sa karek da gwibir. Ano tawa tabin sin da-en ang ta gwek. Zep ebon mae osan kire enkam sa hen ang ta gwer. ");
INSERT INTO ury_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Zen mae hap sa emsa karek da gwibir: Sap em Abon onak de wenya, hen zen hom Bian, men zen Asa zer soneka, Desa tame daꞌan. ");
INSERT INTO ury_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ëe de hatazan srëmkam hen tawa ta gwibin srëmkam, ki karekna molya zëbon mae onak mamkam lwaꞌanam. Hwëna angkam Ëe mesë tawa ta gwibik. Zep aumwa hap de zisi klis gunnuk zen banakan molya anakan ëguk, ‘Ëe homë anakan ëtawa gwek, “Ëe ama ëkarek gweꞌan.”’ ");
INSERT INTO ury_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Men nara Asa husus gweblanna, zen ki hen ano Biansa husus gweblaꞌara. ");
INSERT INTO ury_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Owas-owasna men desa Ëe zëno mae mo nwenak syal gwe-gwibir-zimk, aha zi hom tangan orep kirekam de owasna syal neibik. Ëe de kirekam syal gwibir-zimdin srëmkam, ki karekna zëbon mae onak molya mamkam lwaꞌanam. Hwëna angkam zen mes hla nul gwek, hwëna zen man Asa ëre mo Bian naban husus nei gwizimk. ");
INSERT INTO ury_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Zen hwëna kirekam de jowen hap mes ki lwak, sap men kirekam Alap mo olak anakan ale nukke, ‘Zen man totoresa asa husus në gweblak,’ zen bëjen ki lwa srëm gwen. ");
INSERT INTO ury_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ano tim bwanak, dekam Ëe asa emsa de mas gwibirida gwen hap de Zini insa zer sonezim. Zen Alap mo Enho– eiwa de enlalasa de ing ta sone gwizimdin hip de Zini. Zen Zen sa hen abe hap de ola ebe mae hap ing gul sone gwizimdi. ");
INSERT INTO ury_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Em hen dekam esa abe hap dena ol halada gwer. Sap Ëe kimë Alap mo ola nonol tawa tabinkim kon gwesibir hanak, eme Asa ang ë gweblak.” ");
INSERT INTO ury_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ëe mae habë hamal hap kirekam emsa gubiridanan– em ekakim Asa de taïblïblan nakon ëbutehal gwe srëm gwek. ");
INSERT INTO ury_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Abe hap de jal hap emsa sa but srëm gol-gola kon nolëalsa sone gwer, hen eno mae mo ahakorena sa damera gwer. Dekam in zen ki emsa neibirida gweꞌak anakan sa kïl nïl gwer, ‘Alap man ano mae mo syala ansa sam gwesïk gwibiꞌira.’ ");
INSERT INTO ury_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Zen kirekam sa emsa neibirida gwer, sap zen Asa Bian han hom tame nosoꞌan. ");
INSERT INTO ury_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Hwëna an zebë ki hamal hap dena insa emsa gubiridanan. Sap men dekam ki emsa kirekam neibirida gweꞌak, dekam esa ëenlala gwe-gwer, ‘Zen men desa hamal hap asa gubiridaka, angkam man ki lwaꞌan.’” “Ëe homë menkam kirekam emsa tawa ta gwibik, sap Ëe dekam namaë emsa golëlowehe gweꞌak. ");
INSERT INTO ury_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Sap angkam Ëe ama etan lwa haꞌan– men Zen Asa zer sonekake, Zëbon osan dep. Hwëna em home Asa lakensïblïꞌan, ‘Em enda san debe song gweꞌara?’ ");
INSERT INTO ury_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Hwëna Ëe ama emsa tame tabiꞌin: Asa de kirekam sane tankam, eno mae mo enlalana man tangan dowe hanaꞌara. ");
INSERT INTO ury_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Hwëna eiwa denakaë emsa gubiridaꞌan: Ëe de emsa hli yuludanna, zen ebe mae hap man tangan sam gwesizimꞌin. Sap Ëe de emsa hli yuludan srëmkam, ki emsa de mas gwibirida gwen hap de Zini in molya ebon mae hata zaka. Ëe de emsa hli yuludankam, Ëe asa zer sonezim. ");
INSERT INTO ury_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Zen kim de hataꞌan zaka, Zen dekam sa tïngare okamanak de zi hip eiwa dena goltrei gwizimdi– kareksa de gol gwen srëm hap dena, dam-damkam de lowehen hap dena, hen Alap de klis gun hup dena. ");
INSERT INTO ury_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Sap okamanak de zini Asa de taïblïblan hap man baes ta gwenan, zep Alap mo Enhona sa zëbe mae hap anakan goltrei gwizimdi, ‘Em ema dekam ëkarek gwe-gwenan.’ ");
INSERT INTO ury_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ëe Bian osan debë song gweꞌan, zep ano tim bwanak Zen sa dam-damkam de lowehen hap denaka tawa ta gwibiri. ");
INSERT INTO ury_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Alap mes dowal mo kïgïna karek tan hap gu-gubluka. Zep Alap mo Enho de hata zankam, Zen sa hen Alap de tïngan klis gun hup denaka tawa ta gwibiri. ");
INSERT INTO ury_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ano emsa de tawa tabin hip dena sap nama blala. Hwëna angkam em molye dokwak uk. ");
INSERT INTO ury_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Hwëna Alap mo Enho, Zen Zen– eiwa denaka de ayang gul gwizimdin hip de Zi niye. Zen Zen sa eiwa de oranak dep emsa golëwet so gwera. Zen molya zëre en mo enlala san tawa ta gwibirki, hwëna men desa de Abon sane gwe-gweꞌanka, Zen desa sa ebe mae hap ayang gul gwizimdi. Zen zep sa hen ngein sin dep dena hamal hap goltrei gwizimdi. ");
INSERT INTO ury_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","15","Tïngan mensa Bian bi gwibiꞌira, Ëe desa apdenakë bi eibiꞌin. Zen in zebë emsa gubiridal, ‘Alap mo Enhona men desa de Abon sane gwe-gweꞌanka, Zen desa sa ebe mae hap ayang gul gwizimdi.’ Zep zëno syala kon, zini sa ano bosena teip nulsunda gwer.” ");
INSERT INTO ury_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Molya holo gwek, em dekam molye etan Asa hla lak. Hwëna etan holo gwehan srëmnak esa Asa hla lal.” ");
INSERT INTO ury_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Zëre hon de ang ta gwen wenya, ëe ahakon dekam zebë ënaka anakan lakensibirida gweꞌak, “Zëno enlalana banakan lwablaꞌara? Nen home tame ul– in kim anakan gulu, ‘Molya holo gwek, em dekam molye etan Asa hla lak. Hwëna etan holo gwehan srëmnak esa Asa hla lal.’ Hen nen home tame ul– in kim anakan gulu, ‘Sap Ëe Bian osan debë song gweꞌan.’” ");
INSERT INTO ury_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ama hen anakan ënaka lakensibirida gweꞌak, “In kim anakan gulu, ‘Molya holo gwek,’ dam gulsunnu banakan? Nen home dam ulsuꞌun.” ");
INSERT INTO ury_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Hwëna Yesus mes anakan asa tame tabirki, “Zen man Asa de takensïblïn hap ëdwam gweꞌan,” ki zep asa takensibiridaka, “Em san teibin hibe enaka lonbiridaꞌan?– insa anakan emsa gubiridalye, ‘Molya holo gwek, em dekam molye etan Asa hla lak. Hwëna etan holo gwehan srëmnak esa Asa hla lal.’ ");
INSERT INTO ury_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Eiwa denakaë emsa gubiridaꞌan: Em esa aïtïn-aïtïn nïban Asa gosa la gweblal, hwëna auhu-kama enlala zini sa dekam ëisrip-sri gwe-gwer. Em hwëna dekam enlalana esa ëdowe hanal, hwëna enlala dowe hananna in isrip-sri hap sa etan liwe hera– ");
INSERT INTO ury_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","men kirekam hen, we de eisbir anenna. Zen dekam enlalana man ëdowe hana gwenan. Sap dekam mes zaunun– zëno hlësgwan-hlësgwan gwen hap denakye. Hwëna kim de jaha gweꞌak, zen dekam sa sang-sangna insa eititi gwibir. Sap dekam walasna insa sa isrip-sri gweblal. ");
INSERT INTO ury_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Em hen kirekam esa ëgwër: Angkam em enlala dowe hanan nabane lowe heꞌan. Hwëna em kime etan Asa hla laꞌak, em dekam tangan esa Asa isrip-sri ëblal. Isrip-srina in, zen hëndep dena. Zini bëjen kire isrip-srina ebon mae onakon gulsuzimdin. ");
INSERT INTO ury_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Dekam em etan molye ëdwam gwek– Asa de srip gulsuzimdin hip takensïblïn hapye. “Eiwa denakaë emsa gubiridaꞌan: Ano bosekam de ba mae hap Biansa abe tanna, Zen sa ebe mae hap gol gwizimdi. ");
INSERT INTO ury_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Em home menkam ano bosekam ba mae hap Biansa abe la gwek. Hwëna angkam emki abe ta gwen. Dekam esa ulin gwer. Zen dekam tangan sa eno mae mo isrip-srina taman kïnï gwer. ");
INSERT INTO ury_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ano ola ebe mae hap gulk sun de blaonzimdin makan mes yap lwal. Hwëna yaklanak sa hatal, dekam molyë etan gulk sun de blaonzimdinkim emsa tawa ta gwibik. Hwëna dam-dam enkam asa ëre mo Bian hap dena ebe mae hap srip gulsuk gwizim. ");
INSERT INTO ury_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Yaklana iwe de hatankam, em dekam molye etan Asa en gweblak– eno mae mo abesa de Bian hap ayang gul gweblan hapye. Hwëna en esa Biansa ano bosekam abe la gwer. ");
INSERT INTO ury_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Sap Bian Zëna man emsa kwasang gwibirida gweꞌara, sap em ema Asa ensa ola gweblak, hen em ema Asa anakan laïblïblak, ‘Zen eiwa Alap onakon hataka.’ ");
INSERT INTO ury_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ëe eiwa okamana awe dep Zëbon onakonë hatazak. In zebë etan Zëbon osan dep lwa haꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ëe zëre hon de ang ta gwen wenya dekam zebë enblak, “Angkame dam-dam enkam asa gubiridanda– gulk sun de blaonzimdin srëmkamye. ");
INSERT INTO ury_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Angkamë Emsa tame lanan: Em kïtak tawana. Em zi mo enlalana ema tame ta gwizimnira, zep Emsa de takensïblïn srëmnake ap ding gul gwizimnira. Zen in zebë tangan Emsa laïblïblaꞌan, ‘Em eiwa Alap onakone hata zaka.’” ");
INSERT INTO ury_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Dekam zep hwëna ap ding gulzimki, “San ha eiwa tangane Asa laïblïblaꞌan? ");
INSERT INTO ury_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Emki ësan: Angkam mes tangan golek de gwer, em dekam esa ere mae mo gol-gol san dep ësyawer. Em dekam esa Asa hli la gukhal. Hwëna ëre mo Bianna molya zë Asa da tasïkï, sap Zen nama Asa zergwë gweꞌara. ");
INSERT INTO ury_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","An kïtak mesë emsa gubiridanan– aban de zeraha-en gwenkam ekakim ëngalap gwen srëmkam lowehe gwek. Auhu-kamanak awe karekna mam naka esa oltowe gwer. Zep enlala tatete naban lowehe gwek– men kirekam hen Aena enlala tatetekam de zaunkum auhu-kama mo sosonna holenak zaubir anekke.” ");
INSERT INTO ury_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesus kim kirekam gubiridaka, Zëna ki zep nglï san kara gwe seka, ki zep Biansa gu soneblaka, “Bian, angkam yaklana mewe mes zaunun. Angkam dekam ere mo Tanena ano bosena tïngare zi mo nwenak ap teip gulsublu– Ëe akakim hen ere mo bosesa zëno mae mo ngïrïnnïk teip gulsuk gwek. ");
INSERT INTO ury_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Sap Em mese tïngare zi aususa de bi gwibiridan hap dena abe hap golblaka. Hen zen de ëngaya gwen hap dena mensa Ena abe hap lup gulbluka, Ëe asa zëbe mae en hap hëndep de lowehen hap denaka gol gwizim.” ");
INSERT INTO ury_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ëe, Yohanis, in zebë hen Alapsa anakan gu soneblaꞌan, “Bian, an diki zen– hëndep de lowehe gwen hap denaye: Eiwa de Zini Alap Emsa de tame tanna, hen ere mo zer sonen Zini Kristus Yesussu de tame tanna. Zen ëe dekonë ëngaya gweꞌan.” Yesus dekon anakan ayang gulku, ");
INSERT INTO ury_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Bian, Ëe mesë eno bosena okamanak de zi mo nwenak teip gulsublunda gwek, sap Ëe zëno mae mo nwenak mesë syala sul sonek– mensa Ena abe hap wei yul soneblakaye. ");
INSERT INTO ury_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Zep Bian, angkam Emki etan abe hap golblan– Ëe dikim eno alp nakon teipsïnkïm nikirin hip, nonol men kirekame okamana ansa de yang gulsun srëmnak teipsïnkïm inikin gwekake. ");
INSERT INTO ury_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Em mese okamana an kon abe hap zini hlïlblinki, hwëna zen bina ere tangan mo dena. Bian, Ëe mesë ebe hap dena zëbe mae hap goltrei gwizimk, hen zen angkam mes ere mo ol san ang tal. ");
INSERT INTO ury_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Zen mes angkam anakan tame nul: Ano syala hen ola, zen kïtak Ebon onakorena– mensa Ena abe hap golblakake. ");
INSERT INTO ury_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Sap ola mensa Ena abe hap golblaka, Ëe mesë desa ayang gulzimk, hen zen mes desa dokwak nuk, hen mes tame nuk. Zen mes Asa anakan daïblïblak, ‘Zen eiwa Alap onakon hata zaka, hen Zen zer soneka.’ ");
INSERT INTO ury_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ëe tïngare okamanak de zi hip homë Emsa abe taꞌan. Hwëna men desa en Ena abe hap lup gulblukake, zëbe mae en habë Emsa abe taꞌan, sap zen zen– ere mo denaye. ");
INSERT INTO ury_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ano bi gwibiridan wenya, zen hen kïtak ere mo dena. Hen ere mo bi gwibiridan wenya, desa hen kïtak apdekame bi eibiridaꞌara. Zen zep sa hen ano sosonna aha zi hip noltrei gwizim, hëndep zen hen sa ano bosena teip nulsublunda gwer. ");
INSERT INTO ury_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Angkam Ëe ama Ebon osan dep lwa haꞌanzal. Ëe homë etan okamanak awe deban mae golëlowe heꞌan, hwëna nëno nik mo bi eibiridan wenya nama sa zao lowehe gwer. Zep Lalak Zini, Bian, nëno nik mo hlïl irin zini insa emki tatetekam de Ebon en ëzauk gwen hap denaka gol gwizimdin. Zen dekam sa ëaha-en gwe-gwer– Nëna men kirekame hen aha-en ëkake. ");
INSERT INTO ury_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ëe kimë nama golëlowehe gwek, Ëe ama Ebon dikim tatem ëzauk gwen hap dena kim tatete ta gwibik. Hen Ëe ama dawemkam golëzauk sone gwek, zep aha-en mae homë syauk sun dep de ora san de gwë hannak kara ta sonek. Hwëna aha-en tangan syal heka. Hwëna zen insa kirekam gwëka, zen ere mo olsa dikim sul sonen hap ki lwak. ");
INSERT INTO ury_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Bian, Ëe angkam ama Ebon osan dep lwa haꞌanzal, an zebë nama de okamanak gwën nakon zëno mae mo inik emsa gu soneblaꞌan– ano isrip-srisa dekakim zëre mae mo enhonak sowe henkam neis gwibik. ");
INSERT INTO ury_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ola mensa Ena abe hap golblaka mesë ayang gulzimk. Hwëna auhu-kama enlala zini man Abon de ang ta gwen wenya ansa husus neibirida gwenan, sap zen okamana awe dep denaka hom. Zen ngatan zi mo lang san dep dena. Ënaka hen kirekam husus në gweblanan, sap Ëe hen awe dep denaka hom. ");
INSERT INTO ury_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Bian, Ëe Abon de ang ta gwen zini ansa, okamana an kon de lup gul inehan hap homë Emsa abe taꞌan. Hwëna diki mae habë Emsa abe taꞌan: Dowal mo kïgï onakon Emki langa tasïk gwibin. ");
INSERT INTO ury_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Men kirekam Aena okamana awe dep denaka hom, zen hen kirekam. Zen zep auhu-kama enlala zi niban enlala siri tankam lowehe srëm gwe-gwenan. ");
INSERT INTO ury_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bian, eno ola zen eiwa de enna. Ere mo eiwa de ola inkam emki Abon de ang ta gwen wenya ansa lalak tasibin– lalak nik dekakim ere en hon lowehe gwek. ");
INSERT INTO ury_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Men kirekame Asa okamana an san dep zer soneka, Ëe hen kirekamë desa tïngare lang san dep lup gul soneꞌan. ");
INSERT INTO ury_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Zen in zebë ëre mo timni ebe hap sosok gulbluꞌan– desa dikim mas gwibiridan hap, zen dekakim tangan ere en hon ëtal gwesïk. ");
INSERT INTO ury_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Angkam an zen lowe heꞌan, zëbe mae en hap homë Emsa abe taꞌan. Hwëna men zen de zëno mae mo ola kon Asa daïblïblaꞌak, zëbe mae habë hen Emsa abe taꞌan. ");
INSERT INTO ury_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Dikire zen kïtak ëaha-en gwek. Dikire zen Nësa niaha-en gwek– Nëna men kirekame enho aha-erekam ë gwendake. Zen de kirekam ëaha-en gwenkam, zen dekam tangan sa okamanak de zini Asa anakan daïblïblal, ‘Zen eiwa Eme Asa zer soneka.’ ");
INSERT INTO ury_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ëe mesë ëre mo ngatan zi mo lang nakore sosonna zëbe mae hap golzimk– men desa Ena abe hap golblakaye. Zen zep sa hen ëaha-en gwer– Nëna men kirekame hen aha-en ëkaye. ");
INSERT INTO ury_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Asa Eme enho nakon zergwë gwenda, hwëna Ëe asa desa enho nakon golëlowehe gwer. Zen zep sa tangan ëaha-en gwer. Zen dekon zep sa hen okamanak de zini anakan tame nul gwer, ‘Zen eiwa, Eme Asa zer soneka.’ Zen zep sa hen anakan tame nul gwer, ‘Em eiwa ema Abon de ang ta gwen wenya ansa kwasang gwibirida gwenda– men kirekame hen Ena Asa kwasang gwe-gweblandake.’ ");
INSERT INTO ury_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Bian, zini men desa Ena abe hap lup gubluka, Ëe ama zen de Abon onak lowehe gwen hap dwam gweꞌan– men zaoë Aena gwë gweꞌakke. Zen dekam sa ano ngatan zi mo langnak de sosonna hla nul gwer– men desa Ena abe hap de kwasang hap okamana ansa de yang gulsun srëmnak golblakaye. ");
INSERT INTO ury_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bian, Em dam-dam enkam de klis gul gwen hap de Zini. Okamanak de zini hom Emsa tame daꞌan, hwëna Ëe mesë Emsa tame tak. Hen Abon de ang ta gwen wenya an mes hen anakan tame nuk, ‘Eme Asa zer soneka.’ ");
INSERT INTO ury_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ëe mesë ebe hap dena zëbe mae hap goltreizimk, hen nama asa kirekam goltrei gwizim. Zen zep sa Asa enna nola gweblal– men kirekam Ena hen Asa enna lwa gweblandaye. Ëe dekam asa deban mae apdekam golëaha-en gwer.” ");
INSERT INTO ury_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesus in kim kirekam Alapsa gu soneblasïkï, ki zep zëre hon de ang ta gwen wenya asa golësek gweka– weya tanena Kidron mo men eihya san dep. Zao zaitun trana ki. Zao zep asa golëbïtï gweka. ");
INSERT INTO ury_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Hwëna Yudas Bak in zen zerguku, zen mes zaitun trana insa tawa gweblaka, sap Yesus etan-etankam zao asa golëtagal gwe-gweka. ");
INSERT INTO ury_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ki zep zë Yudas jana nabare zini golëyaïng gwe zaka. Ahakon Roma mo jana nabare zi, hen ahakon Alap mo golsa de kara gul gwen jana nabare zi– mensa Farisikam de zi niban Alap mo golak de syal tan zi mo mam-mam naban lup nul sonekke. Zen jana, nëbok, hen te tek maesa deirenk, hen ahakon seipsi deirenk hen lampusa. ");
INSERT INTO ury_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Hwëna Yesus mes kïtak anakan tame gulku, “Asa kirekam sa nëblal,” zep ala ta gubiridaka, ki zep zë takensibiridaka, “Em narasae lëblaꞌan?” ");
INSERT INTO ury_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ki zep ding nulblik, “Nazaret walya Yesussu.” Ki zep ding gulzimki, “Ëe an Zen.” Yudas in zen zer guku, zen zë golëzauꞌunka. ");
INSERT INTO ury_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesus kim kirekam ding gulzimki, “Ëe an Zen,” dekam zep jana nabare zini in tïngan lure san ëesek gwehak, ki zep mumuk ennak owas hap boklena kom dablak. Hwëna zëna hom tame nuk– Alap insa kim kirekam gweibiridakaye. ");
INSERT INTO ury_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Dekam zep etan takensibiridaka, “Em narasae lëblaꞌan?” Ki zep etan ding nulblik, “Nazaret walya Yesussu.” ");
INSERT INTO ury_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Dekam zep ding gulzimki, “Ëe mes-am emsa anakan gubiridanan, ‘Ëe an Zenke.’ Asa en de tëblanna, dikire ahakore wenya an sek gwek.” ");
INSERT INTO ury_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Zen mae hap kirekam gubiridaka: Zëre mo nër hom de Biansa de gu soneblanna insa dikim sul sonen hap. Sap Zen anakan gu soneblaka, “Ëe ama dawemkam golëzauk sone gwek, zep aha-en mae homë syauk sun dep de ora san de gwë hannak kara ta sonek.” ");
INSERT INTO ury_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon, aha bosena Petrus, ki zep nëbok zemka mol ineka, dekam zep Alap mo golak de teipsïn zi nik de babu gwe-gwen zini Malkussu sap zïp soka. Hwëna dam san de ing ala en naka zep blansïblï kïnïka. ");
INSERT INTO ury_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Hwëna Yesus zë gubluka, “Nëbokna insa em etan lïl sonen. Em san ema anakan Asa jalse gweblaꞌara?– ‘Mensa Bian syal dohon-honna ebe hap wei yul soneblaka, dikire lwak.’” ");
INSERT INTO ury_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ki zep Roma mo jana nabare zi mo mamna walas zeban hen Yahudi kore jana nabare zi niban zibalk taka, hen tahana zitatak soblaka. ");
INSERT INTO ury_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Zen nonol Hanas Bak osan dep nërhak, men zen nonola Alap mo golak de syal tan zi nikon teipsïkïke– Kayafas Bak men zëno wenamsa golkake. Hwëna Kayafas in, zen tahunna inkam Alap mo golak de syal tan zi nikon teipsïkï. ");
INSERT INTO ury_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafas, zen in zen menkam Yahudi zi mo mam-mamna tame gun srëmkam anakan gubiridaka, “Diki dawemna nëbe mae hap aha-ere zi de tïnnï aïrïs– dekakim tïngare Yahudi zi juwe srëm gwek.” ");
INSERT INTO ury_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon, aha bosena Petrus, hen aha zini men zen Yesussu ang gwe-gweblaka lun kon zep ërtro kïnïka. Hwëna aha zini in zen ang gwe-gweblaka, zen Hanas Bak mo dokot ahana. Zep kim Yesussu Hanas Bak mo gol homannak de kol sonna iwe nërtïꞌïnzak, zen en zep dekam hen tïl zïka. ");
INSERT INTO ury_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Hwëna Petrus ënakon zep zauꞌun onka– lïlïkïn golek denakon. Aha ang gwe-gweblan zini in dekam zep etan wet soka, ki zep lïlïkïnsï de kara so gwen hap de babu gwen wenya ban goltonꞌanka, ki zep hwëna Petrus hun lïl zïka. ");
INSERT INTO ury_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Lïlïkïn kara so gwen hap de wenya in dekam zep Petrussu takensïblïk, “Em san hen ahana?– zini in hon de ang gwe-gwenna.” Ki zep ding gulbirki, “Ëe an zen hom.” ");
INSERT INTO ury_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Langna dekam man bot-bot gweꞌak, zep zëwe de babu gwen zi niban jana nabare zi niban mes syauknu bla dasïk, hen zëwe tuwirin hip ëzauꞌuk. Petrus dekam zep hen golek de tabir zika, zao zep hen tuwirin hip zauꞌun zaka. ");
INSERT INTO ury_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Alap mo golak de ëpba teipsïn zini in dekam zep Yesussu mae hap denaka taken-taken gweblaka– Zëbon de ang ta gwen zi hip dena hen zëno tawa tabin hip denaka. ");
INSERT INTO ury_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Dekam zep ding gulbluka, “Ëe ama damkam tïngare zi nwenak tawa ta gwibik. Ano tawa tabinni kïtak Alap mo golak hen but srëm gol-golak– men zëwe en Yahudi zini ëtagal gwe-gwenanke. Ëe homë aningkim ba ol maena tawa tabik. ");
INSERT INTO ury_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Zep ba hap de kire hap Asa takensïblïn hap? Diki men zen Asa sane da gwekke, desa emaka takensibiridaꞌara, sap zen tawana– mensaë tawa ta gwibikye.” ");
INSERT INTO ury_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kirekam kim ding gulbluka, jana nabare zini ahanik zep tahakam mipna lwa soblaka, deban gubluka, “Alap mo golak de teipsïn zini san ki kirekam ding nul gweblanan?” ");
INSERT INTO ury_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Hwëna Yesus ki zep ding gulbluka, “Ëyë botonkam ding gulunam, dekam hwëna emaka gubiridala, ‘Zen kirekam man boton gweꞌara.’ Hwëna eiwakam insa ding gul, em ba habe Asa lek tyanda?” ");
INSERT INTO ury_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hanas dekam zep gubiridaka– Alap mo golak de teipsïn zini Kayafas Bak osan dep de zersong gwen hap. Yesus mo tahana dekam nama tatak soblanna. ");
INSERT INTO ury_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Petrus nama syauk alpna iwe zauꞌunka. Ki zep zë ahakore nik etan dakensïblïk, “Em san ha zëbon de ang gwe-gwen naka hom?” Ki zep ding gulzimki, “Ëe zëbon de ang gwe-gwen naka hom.” ");
INSERT INTO ury_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Hanas Bak hon de babu gwen zini ahana man hen zao gwëꞌanka. Zen Petrus insa ing alana blansïblï kïnïka, zëno iye. Zen zep etan gubluka, “Ëe Yesus hun apdenakë emsa zaitun tranak aker.” ");
INSERT INTO ury_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Desa hen man ding gulbluka, “Asya, aban home.” Hëndep dekam zep ayangna guku. ");
INSERT INTO ury_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kak tangannak, zep Kayafas mo gola kon Yesussu nërsong gwek– gubernor Pilatus mo gol san dep. Zen zen dekam Roma mo bosekam gubernor gweka. Yahudi mo mam-mamna in hom dekam gola iwe bïtï gwek, sap Yahudi mo auyan-azana mes anakan jalse neibiridak, “Yahudi srëm zi mo golak bahem tïn. Ki esa ëkun gwer.” Zep hom Pilatus mo golak bïtï gwek, sap zen man yaklana inkam Paskanak de tembane yawalak dep ëhohle gweꞌak. ");
INSERT INTO ury_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ki zep Pilatus Bak wet sobiridaka, ki zep zë takensibiridaka, “Zini an banakan karek gweka?” ");
INSERT INTO ury_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ki zep ding nulblik, “Zen de karek gwe srëm gwenanam, ëe molyë ërhalan zanam.” ");
INSERT INTO ury_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ki zep Pilatus ding gulzimki, “Ki amki ere mae mo tïtï tabin ola kon klis uk hen karek lak.” Hwëna ki zep ding nulblik, “Ëe amaka, hwëna Roma mo ïrïk gïnnï em mese asa anakan jalse eibirida gwek, ‘Yahudi zini em e-en bëjen em zisi tok hap karek tan. Hwëna diki nonol Roma mo mam-mamna kip em zerguzimdin– zen de zëno kareksa hlaulblunkam dekakim dak.’” ");
INSERT INTO ury_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","An mae hap ki jowek: Sap Yesus mes hamal hap anakan tawa ta gwibirki, “Ëe kirekam de tïnsï asa hlaul.” Zep zëre mo ola insa de sul sonen hap, kirekam zep ki hëndep lwak. ");
INSERT INTO ury_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatus ki zep etan gol mwa san dep tïl halka, ki zep jana nabare wenyaka gubiridaka– Yesussu de zertïlzïn hap. Zao zep takensïblïka, “Em san ha eiwa Yahudi zi mo teipsïnnï?” ");
INSERT INTO ury_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ki zep ding gulbluka, “San ha ere en mo enlalakame ki kirekam Asa takensïblïꞌara? San ha aha zi man emsa nenblal– kirekam de Asa takensïblïn hapye?” ");
INSERT INTO ury_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ki zep ding gulbluka, “Ëe san Yahudi wal! In dwan Yahudi bose uk am Alap mo golak de mam-mam wenya ban abe hap emsa nërgublunanzal. Em banakane karek gweka?” ");
INSERT INTO ury_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ki zep ding gulbluka, “Ano ïrïk gïnnï zen auhu-kamanak awe dep hom. Ëe de okamanak ïrïk gïnkïm, dekam ano ïrïk gïn wenya maka ëeijaꞌan– Asa de Yahudi mo mam-mam mo tahanak zerguzimdin srëm hap. Hwëna ano ïrïk gïnnï okamanak awe dep hom.” ");
INSERT INTO ury_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Dekam zep Pilatus etan takensïblïka, “Zep ki san ha em teipsïnnï?” Ki zep ding gulbluka, “In kirekame gunda, zen kirekamke. Ëe mae habë okamanak hatazak: Eiwa denaka de tawa ta gwibin hip. Eiwa de enlala nabare zini, zen man Asa i-san i-san në gweblanan.” ");
INSERT INTO ury_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Dekam zep hwëna ding gulbluka, “Eiwa dena bëjen em tawa tabin, sap eiwa dena toton nara dep?– klis gunnu.” Kim kirekam guku, ki zep etan Yahudi mo mam-mam osan dep wet soka, ki zep zë kïtak zi trana in han gubiridaka, “Ëe homë zini an mo karekna hlaulblunan. ");
INSERT INTO ury_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Hwëna eno mae mo gubernor-gubernora, ëe dwan yakla yala Paskanak am-am ëgwë gwenan– bwinak de zini men desa tan hap kalang neibirida gwenan, ahanaka de tïngare zi mo gublun san wet son hap zeser sonezimdin. Zep ëe ama emsa takensibiridaꞌan: Ëe narasa asa namen ebe mae hap hïl tï sonezim? San ha zini an zen zënaka tim tiꞌara, ‘Ëe an Yahudi mo teipsïnnï,’ san ha desa asa ebe mae hap zeser sonezim?” ");
INSERT INTO ury_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ki zep ol mamkam ëgu ane gweꞌak, “Zini insa bëjen! Barabassa ap hïl tï sonezim.” Barabas in, zen asaskam de te-alasa alal ta gwizimdin hip de zi. ");
INSERT INTO ury_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilatus ki zep jana zisi gubiridaka– Yesussu de zerhan hap, zao de mam enkam tangolen hap. ");
INSERT INTO ury_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jana zini in dekam zep dokot të ngï-ngïsa mlin-mlin nuk, desa zep nolak ala nul soneblak– teipsïn zi hip de emaskam de weir sosublun makare naka. Zen hen teipsïn zi hip de bajusa, sam dan kïl makare naka, ala nosoblak. ");
INSERT INTO ury_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Zëna zao zep botonkam blikip neisïk gweblaꞌanzak– anakare swrë tan ola ban, “Dawem, bian. Em in zen– Yahudi mo teipsïn nïye.” Kire ola ban zep nwe-mase san lek-lek da gweꞌak. ");
INSERT INTO ury_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Etan kim nër halzak, Pilatus ki zep etan wet sobirida zaka, ki zep zë gubiridaka, “Emki hla tan. Ëe ama etan ep zertreizimꞌin– em dikim anakan ëtawa gwen hap, ‘Ëe homë zëno karekna hlaulblunan.’” ");
INSERT INTO ury_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesussu kim nërwet soꞌanzak, dekam nama ngï nabare dokot të weir sosun nuban hen teipsïn zi hip de baju naban. Pilatus dekam zep gubiridaka, “An zen– zini inye.” ");
INSERT INTO ury_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Hwëna Alap mo golak de mam-mam wenya hen Alap mo golak de jana nabare zi mo mam-mamna kim hla dak, dekam zep ol mamkam ëgu ane gweꞌak, “Desa te-lidak sonnak makan laink. Te-lidak sonnak makan laink.” Pilatus ki zep hwëna ding gulzimki, “Ki amki e-en te-lidak sonnak makan laink, sap ëe homë mae karekna hlaulblul.” ");
INSERT INTO ury_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Hwëna Yahudi zini in dekam zep ding nulblik, “Are mae mo tïtï tabin olak zen eiwa tan hap dena, sap zen man zënaka gubluka, ‘Ëe an Alap mo Tane.’” ");
INSERT INTO ury_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatus kim kirekam sane gweꞌanka, dekam zep dawemkam aïrïꞌanka. ");
INSERT INTO ury_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Dekam zep etan gol zebon tïl halka, hen dekon zep etan Yesussu de zertïlzïn hap gubiridaka. Kim nërtïlzïk, zao zep takensïblïka, “Em in enda kone hata zaka?” Hwëna hom ding gulbluka. ");
INSERT INTO ury_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Dekam zep gubluka, “Em san ema asa de ding gulblun hap baes gweꞌara? Ki san abon onak hom?– emsa de zeser sonen hap denaye, ahaksa emsa de te-lidak sonnak makan ta irin hip denaye.” ");
INSERT INTO ury_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Dekam zep ding gulbluka, “Alap de ebe hap golblan srëmkam, dekam eno sosonna hom– dekam de Asa banakan mae gwëblan hap denaye. Zen zep, zini men zen Asa ebe hap nërgublul, zëno mae mo karekna man ebon onakon taman kïnïꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilatus kim kirekam salblaka, dekam zep wet soka, zao zep sap zi beyana insa etan gubiridaka– dekam de Yesussu zeser sonen hap. Hwëna Yahudi zi mo mam-mamna in man ol mamkam anakan ëgu ane gweꞌak, “Ki san em hen Romak de teipsïn tangan zi nik mo jal zi?! Yesus in man zënaka gu gweblaka, ‘Ëe an eno mae mo teipsïnnï.’ Kirekam de gunnu, zen nëno mae mo Romak de teipsïn tangan zi nik mo jal zi. Eme zeser soneꞌanka, dekam man nwe-mase gweꞌan: Em hen nëno mae mo Romak de teipsïn tangan zi nik mo jal zi.” ");
INSERT INTO ury_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kirekam kim salbiridaka, dekam zep Yesussu de zerwet son hap gubiridaka. Zëna dekam zep klis gun hup de komal tum yawalak nikin aneka. Homanna men zëwe nikinki, orep mes bose nuk “Kaso Homan”kam. Desa Ibrani olkam man nen gwibirin “Gabata”kam. ");
INSERT INTO ury_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yakla nwena dekam bolak mes zauku, hen yaklana in, Paska hap de yaklana enamna, kim Paskanak dep de kambingni damerak– dekam de kaꞌan aumwa hap tembane yawalsa hohle gun hup. Pilatus dekam zep gubiridaka, “An zen, eno mae mo teipsïn nïye.” ");
INSERT INTO ury_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Hwëna zi beyana in man etan mamkam ëgu ane gweꞌak, “Jek-jak lak! Jek-jak lak. Te-lidak sonnak makan laink.” Pilatus dekam zep takensibiridaka, “San ki ëe asa ere mae mo teipsïn zini ansa te-lidak sonnak makan tain?” Alap mo golak de mam-mam wenya dekam zep ding nulblik, “Ano mae mo teipsïn zini aha-en– Romak de teipsïn tangan zi niye. Ahana hom.” ");
INSERT INTO ury_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hëndep ki zep Pilatus te-lidak sonnak de makan ta irin hip zerguzimki. Jana nabare zini dekam zep hëndep ïrïk dahak. ");
INSERT INTO ury_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesus hup dekam zep zëre hap de te-lidak soblanna wë noso soneblak. Ki zep hëndep wë so halka, hëndep kwatap tek bosena Zi Nol Swrak zihataka. Ibrani olkam man desa nen gweblanan “Golgota”kam. ");
INSERT INTO ury_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Zao zep te-lidak sonna iwe makan daink. Zao aha darena hen man makan nosoink– Yesus mo eihya-lip eihya-lipkam. Zënaka ngïrïnnïk. ");
INSERT INTO ury_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatus man gubiridaka– dekam de Yesus mo te-lidak sonnak anakarekam de ol ale gunsu makan gul irin hip, “An Nazaret walya Yesus– Yahudi zi mo teipsïnnï.” ");
INSERT INTO ury_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yahudi zini beyakam ol ale gunnu insa baca nul gweꞌak, sap men zëwe makan daink, zen Yerusalem kon langanak hom. Hen zen dan-ahare olkam ale nuk: Ibrani olkam, Roma mo olkam, hen Yunani olkam. ");
INSERT INTO ury_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Alap mo golak de mam-mamna dekam zep Pilatussu nenblak, “Emki alena insa de wet gulsun hup gubiridan. Bap zen anakan lwan, ‘Yahudi zi mo teipsïnnï.’ Diki anakan de ale gun hup emaka gubiridala, ‘Zini an man zënaka gu gweblaka, “Ëe an Yahudi zi mo teipsïnnï.”’” ");
INSERT INTO ury_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Hwëna Pilatus man ding gulzimki, “Men kirekamë ale gun hup gubiridal, mes ki kire enkam ale nul. Wet gulsun hup ama baes gweꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Dan-nër dan-nërkam de jana nabare zini kim Yesussu te-lidak sonnak makan da inꞌik, dekam zep zëno pakeanna zëre mae hap hlï-hlï dak. Hwëna olk de baju blal zemka man neizim kïnïk. Zen dawem tanganna, yan wei maena hom, zep kalk son hap baes neizimk. ");
INSERT INTO ury_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Dekam zep zënaka nenbiridak, “Bap nen kalk son. Nen esa dobe abukam dam lasïl– zen de teisyan hapye.” Zen dekam zep tame gun srëmkam syal neibik– mensa Alap mo olak orep hamal hap anakan ale nukye, “Zen sa ano pakeanna hlï-hlï dal. Hen ano bajusa de teisyan hap de zini, dobe abukam sa dam dasïl.” Kirekam mes ki hamal hap dena Alap mo olak lwak, zen zep ki kirekam hëndep tame gun srëmkam syal neibik. ");
INSERT INTO ury_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesus mo te-lidak son golek denak we walya hen man zë ëzauꞌuk: An zem Maria, an zik mo osona, hen Klopas Bak mo wenya– zen hen bosena Maria, hen ëna Magdala kore wenya Maria. ");
INSERT INTO ury_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesus hon de ang ta gwen zini ahana zao hen golek zauꞌunka– mensa Zëna kwasang gwe-gweblakake. Yesus kim an zemka hlaulku, hen zëre hon de ang gwe-gwen zini insa hla taka, dekam zep an zemka gubirki, “Anyan, in zen, eno tanena. Zen zen sa hwëna ano tim bwanak emsa golgwë gwera.” ");
INSERT INTO ury_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Zëre hon de ang gwe-gwen zini insa ki zep hen gubluka, “Eno anena in zen.” Yaklana inkam zep hëndep nonola zëre mo golak golgwëka. ");
INSERT INTO ury_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesus kim tame gulku, “Ëre mo syala kïtak mesë sul sonenan,” dekam zep gu aneka– mensa hamal hap ale nukke Alap mo olak, Zën de anakan gun hup dena, “Ëe ama ho-hole gweꞌan.” Zen Alap mo ola insa dikim hen sul sonen hap ki kirekam gu aneka. ");
INSERT INTO ury_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Zao hen ki– kama ngatdarakkam de blome betekna, anggur ho enen naban. Jana nabare zini in dekam zep yera jaubum makare naka anggur hona iwe os nul inek, desa zep te bosena hisop tek gwënkam Yesus mo mipnak dep noltrë seblak. ");
INSERT INTO ury_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kim akasibirki dekam zep gu aneka, “Ano syala angkam mes sowe henan.” Dekam zep nola hondang gwebla hanaka, hëndep tïlsïkï. ");
INSERT INTO ury_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","In kim Yesussu te-lidak sonnak makan daink, yaklana Jumatkam. Yahudi mo mam-mamna man anakan ëdwam gwek, “Te-lidak sonnak de zi dan-aharena in, bap zen Hari Sabatnak nama ëtëhe sonen.” Mae hap kirekam ëdwam gwek: Sap kaꞌan Hari Sabat yawal– Paska hap dena. Zep Yahudi zi mo mam-mamna Pilatussu abe dak, “Emki gubiridan– dekam de te-lidak sonnak de zi mo balaka tadrebir-zimdin hip, dekam de nabakam juwen hap, hen nabakam dikim lup guluhen hap.” ");
INSERT INTO ury_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Jana nabare zini dekam zep sek gwezak, dekam zep balaka kam nosozimk– zi darena mensa Yesus mo irgwa taha nakon hen dam taha nakon makan noso inkye. ");
INSERT INTO ury_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Hwëna Yesus onak kim yaïng gwezak, dekam zep hla dak, “Zen mes tïlï.” Zëno bala zep kam nosobla srëm gwek. ");
INSERT INTO ury_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Hwëna ahanik zep zabanak toman nokwa tiyerkam dang gulblula heka. Desan zep kala ban ho naban nabakam su në hezak. ");
INSERT INTO ury_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ëe an zenë bukuna ansa syal gwibiꞌin, ëe ama ëre mo nwekam kara tabiꞌik, in zebë ebe mae hap eiwa gulzimꞌin: Ëe tawana, in eiwa kire tangankam lwak. Ëe mae habë ebe mae hap kirekam eiwa gulzimꞌin: Em dikim hen Yesussu taïblïblan hap. ");
INSERT INTO ury_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","An kïtak mae hap ki kirekam lwak: Sap zep dena man Alap mo olak hamal hap ale nuk, “Zëre mo danna molya kam nosoblak.” ");
INSERT INTO ury_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Alap mo hamal hap de olak anakan ki hen lwak, “Zini in desa dang nulbliꞌak, zen sa kara dal.” ");
INSERT INTO ury_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Hyanak ki zep Arimatea walya Yusup Pilatus osan dep song gweka, ki zep Yesus mo tok naka dikim lo tasïn hïp abe taka. Yusup in sap Yesus hon de ang gwe-gwenna, hwëna zen aningkim ang gwe-gweka, sap zen Yahudi mo mam-mam naka aïrïbirida gweka. Pilatus kim gubluka, “Amki,” dekam zep Yesus mo tokna zizeryahe halka. ");
INSERT INTO ury_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus Bak man Yusupsu mas gweblaka. Nikodemus in, men zen orep Yesussu kam zïnï takake. Zen deban de drënen hap de irase dawem nabare kire-kiresa golhal zaka– muru ban gaharu naban de siri gun nuka. Kire-kirena in, zëno dohonna tiga-pulu empat kilogram enkam. ");
INSERT INTO ury_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Drënen hap de kaso hulak kim nërhatahak, zao zep kaen ngap-ngapkam itatak taka. Kim itatak taꞌanka, irase dawem nabare kire-kirena insa man kaenna iwe nutul sone gweꞌak– deban de tahalen hap, Yahudi zini men kirekam zi tokna neibirida gwenanke. ");
INSERT INTO ury_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Men zëwe Yesussu te-lidak sonnak makan daink, zëwe golek denak te tra nwe-awesna ki. Te trana iwe hwëna kaso hul gun ësena ki– mensa te-ala beya zi hip hamal nul gublukke. Hwëna men zëbe hap hamal nulblik, dekam nama hom tïꞌïnka. ");
INSERT INTO ury_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kaso hul gunnu in golek, hen Hari Sabatnak dikim hatan hap aha-ere jam maekam hom lwaꞌak. Zep Hari Sabatnak de syal tan srëm hap nabal-bakam aha hap de kaso hul hamal gulblunnak bohëkam idrë neka. ");
INSERT INTO ury_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Minggukam kak tangannak zep Magdala kore wenya Maria Yesussu de drënen kaso hul san dep song gwek. Kim hlaul kïnïk, “Lïlïkïn kaso yala in mes irhi nul kïnïl,” ");
INSERT INTO ury_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","dekam zep Petrus osan dep hluwezak. Aha zini, Yesus hon de ang gwe-gwenna hen zao gwëꞌanka– men desa Yesus Zëna kwasang gwe-gweblakake. Maria dekam zep guzimk, “Bian mo tokna mes nërhak, hen ëe homë tame guꞌun, ‘Endawe nënnek?’” ");
INSERT INTO ury_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Dekam zep Petrus aha zini in han kaso hula in san dep hlu këka. ");
INSERT INTO ury_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Hwëna aha zini in nabakam hluweka, zep zen nonol hataka. ");
INSERT INTO ury_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Zen ki zep ake irin hip huwe heka, hwëna kaen ngap-ngap enna insa zep zë hlaul inki. Hwëna zen hom tïl halka. ");
INSERT INTO ury_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Hwëna Petrus kim lun kon hata zaka, zen hëndep ki zep tïl halka. Zen hen kaen ngap-ngap blala in ensa zep zë hlaul onka. ");
INSERT INTO ury_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Hen kaenna men dekam nola tatak dablak, desa hen zë hlaulku. Zen lak gun nik srën lwaꞌak. ");
INSERT INTO ury_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ki zep hen aha zini men zen nonol hata zaka kaso hula iwe tïlkï. Zen dekam zep hen hlaulku, hëndep kim hyanak tame gulku, dekam zep Yesussu taïblïblaka. ");
INSERT INTO ury_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Sap menkam zi darena in hom tame ulki, hwëna kim iwe lïlkï, zen dekam zep dam ulsuku– mensa Alap mo hamal hap de olak zëbe hap dena anakan lwakye, “Zen tïn nïkon sa ngaya gwera.” ");
INSERT INTO ury_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Zen dekam zep gol san dep ola halka. ");
INSERT INTO ury_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Hwëna Magdala wenya Maria nama kaso hulak iwe ë nakon gwëꞌak, hen gosa kon gwëꞌak. Zen ki zep go gwën naban huwehek– kaso mwa san dikim ake irin hip. ");
INSERT INTO ury_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Hwëna dekam zep Alap mo dam taha nakore zi darena zë akeink. Zëno nik mo pakeanna ngap-ngapna. Men zëwe Yesus mo tokna nënnek, zao inikinꞌinka– ahana men desan nola kim nën nekke, ahana tana san dekam. ");
INSERT INTO ury_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Zen dekam zep lakensibirki, “Em ba habe gona gwëꞌara?” Dekam zep ding gulzimk, “Ano Bian mo tok naka nërhak, hen ëe homë tame guꞌun, ‘Endawe mes yap nënnek?’” ");
INSERT INTO ury_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kirekam kim guzimk, zëna ki zep tahan san lero gwek. Dekam zep hwëna Yesussu hla tak. Zen hwëna hom anakan tame tak, “An Yesus.” ");
INSERT INTO ury_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Hwëna Yesus ki zep takensibirki, “Em ba habe gona gwëꞌara? Em narasae tëblaꞌara?” Zen hwëna man kïl tïꞌak, “An te tra nwe awesna ansa de dam-en ta gweblan zi,” zep ding gulbluk, “San eme zer halka? Ki emki asa gubin, ‘Zaoë drënek,’ ëe aka etan zerhak.” ");
INSERT INTO ury_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesus dekam zep bosena kim gubirki, “Maria.” Maria ki zep etan lero gweblan naban Ibrani olkam takenblak, “Raboni.” Zëno enlalana nëno mae mo olkam, “Bian guru.” ");
INSERT INTO ury_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ki zep gubirki, “Bahem Asa babang tan, sap Ëe nama homë ëre mo Bian osan dep song gweꞌan. Hwëna ano oso walkam de gubirida gwen wenyaka em gubiridan, ‘Zen man gulu, “Ëe ëre mo Bian osan debë song gweꞌan. Zen ano Bian, hen eno mae mo Bian. Zen ano Alap, hen eno mae mo Alap.”’ Kirekam em gubiridan.” ");
INSERT INTO ury_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Zen dekam zep asa gubiridazak, “Ëe mesë Biansa ngaya naka hla tanan!” Hen dekam zep asa tonbiridaꞌak– ola mensa abe mae hap de ayang gulzimdin hip gubirkiye. ");
INSERT INTO ury_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mingguna in mo kam-en, ëe zëre hon de ang ta gwen wenya aha-ere golakë lowe heꞌak. Tïngare lïlïkïnnï tayalsibin nik ërlwaꞌak, sap ëe ama Yahudi zi mo mam-mam naka aïrïbiridak. Hwëna Yesus ki zep ano mae mo ngïrïnnïk jowe zaka, ki zep zë asa gubirida zaka, “Dawem. Em Alap mo taha terenake lowe heꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Zen dekam zep abe mae hap taha zemka zitreizimki, hen zabanak de weina goltreizimki. Hla tankam ëe ama tangan ëisrip-sri gwek. ");
INSERT INTO ury_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Etan ki zep asa gubiridaka, “Em eiwa Alap mo taha terenake lowe heꞌan. Men kirekam Bian Asa zer soneka, Ëe hen kirekamë emsa lup gul soneꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kirekam kim asa gubiridaka, ki zep asa aha-en aha-enkam zëre mo ensasakam hop ta sonebirida gweꞌanka– anakare ola ban, “Alap mo Enho Zen emsa ing gwe heblan.” ");
INSERT INTO ury_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Zen hen Alap mo Enhona in hap man asa gubiridaka, “Em dekam esa Alap mo dwam gwibin sin tïngare zi hip anakan klis ul gwizim, ‘Kirekam de karek-karek nakon de halenkam, Alap sa karekna insa tap gulsuk gwizimdi. Hwëna aha karek-karekna ansa, desa bëjen tap gulsuzimdin.’” ");
INSERT INTO ury_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesus kim abon mae jowe zaka, Tomas Bak, mensa nen gweblanan “dan de wë son walas”kam, zen dekam zao hom gwëꞌanka. ");
INSERT INTO ury_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Hwëna kim hata zaka, ki zebë enblak, “Ëe Biansa ngaya nakaë hla lal!” Hwëna Tomas man ap ding gulzimki, “Ëe aen de tahanak de paku weisa hlaulblun srëmkam hen towanzim-blin srëmkam, hen zabanak de weinak de towanblan srëmkam, ëe molyë na-en taïblïk.” ");
INSERT INTO ury_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Aha mingguna kim tamank, ëe etan gola iwe lowe heꞌak. Dekam Tomas hen zëwe gwëꞌanka. Tïngare lïlïkïnnï tayalsibin nik ërlwaꞌak, hwëna Yesus ki zep ano mae mo ngïrïnnïk jowe zaka. Dekon zep asa gubiridaka, “Dawem. Em Alap mo taha terenake lowe heꞌan.” ");
INSERT INTO ury_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ki zep zë Tomaꞌa gubluka, “Emki taha bolkam ano tahanak de paku weisa towanzimdin, hen emki Asa zaba weinak towanblan. Bahem taïblï srëm gwen! Emki taïblïn!” ");
INSERT INTO ury_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas ki zep ding gulbluka, “Are ano Teipsïnnï, hen ano Alap!” ");
INSERT INTO ury_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ki zep Yesus ding gulbluka, “Em in Ënaka de hla tankame taïblïnda. Hwëna men zen Asa de hla tan srëmkam ëtaïblïꞌan, zen hëꞌho gwibinnik lowe heꞌan!” ");
INSERT INTO ury_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesus owas-owasna beya naka syal gwe-gwibirki– zëre hon de ang ta gwen wenya ano mae mo nwenak. Hwëna ëe homë tïngan bukuna awe ale guk. ");
INSERT INTO ury_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ëe mae habë bukuna ansa ale gulzimk– em dikim anakan ëtaïblïn hap, “Yesus Zen eiwa nësa de ngaya tabin hip de Teipsïnnï, hen Zen Alap mo Tane.” Sap kirekam de Yesussu taïblïblankam, zen dekam esa hëndep denaban ëngaya gwer. ");
INSERT INTO ury_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Zao kim lwa seꞌak, Yesus ki zep etan abon mae Ho Gutuna Galileak jowe zaka. Ho gutuna in mo aha bosena Tiberias. A kirekam mo zë lwakye: ");
INSERT INTO ury_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Zao kim lwa seꞌak, ëe Yesus hon de ang ta gwen wenya tuju enkamë lowe heꞌak– anaka-en: Petrus, Tomas– mensa nen gweblanan “dan de wë son walas”kam, hen Galilea mo ëna Kana walya Natanael, hen Zebedeus Bak mo walas darena, hen ahana dan-dan– Yesus hon de ang ë gwen wenyaye. ");
INSERT INTO ury_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Petrus ki zep asa gubiridaka, “Ëe hogwe tahyon habë song gweꞌan.” Ki zebë ding ulblik, “Ëe asa ang tal.” Ki zebë bulkum sek gwek. Hwëna kam blalë sap jalana ho gutuna iwe os ul tinek. Hwëna hogwena hom mae tëhek. ");
INSERT INTO ury_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kim hleng gwek, Yesus dekam zep ho gutu alpnak zauꞌunka, hwëna ëe homë anakan tame lak, “Wakin Yesus.” ");
INSERT INTO ury_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Zën zep asa gubiridaka, “Wal sei-siwir, em wëhë hogwena lahyol?” Ki zebë ding ulblik, “Ëe homë.” ");
INSERT INTO ury_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ki zep asa gubiridaka, “Dam taha san de bul alp san emki os gun. Dekam esa lahyol.” Ki zebë desan os uk, hwëna dekon zep hogwena beya enkam bïtï gwek. Etan gul inenna ama sap akabik. ");
INSERT INTO ury_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mensa Yesus kwasang gwe-gweblaka, zen zep Petrussu gubluka, “Wakin Bian!” Kirekam kim salblaka, ki zep tahan baju zemka ala soka. Ki zep honak heya gwe ineka. ");
INSERT INTO ury_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ëe ahakore wenya sangankam zebë bulkum alp san dep ërtro kïnïk– hogwe beyam-bya nabare jalana insa de baïl song gwen naban, sap ëe homë dekam alp nakon ëlanga gwe haꞌak. San ha 100 meter enkam mes yap. ");
INSERT INTO ury_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kimë atiti gweꞌak, ki zebë zë hogwe auhlu gun berya akek. Syauk debala man zë auk gweꞌanka. Hogwe naban roti naban zëwe nola ineꞌak. ");
INSERT INTO ury_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesus ki zep asa gubiridaka, “Hogwena insa lahyol emki da-en teisya halzan.” ");
INSERT INTO ury_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Petrus dekam zep buluk sewe seka, ki zep jalana insa alp san dep ïl gïlhal zaka. Hogwena yawal-yawal en nik zë bïtï gwek, beyana 153 enkam. Sap man ki zë beyakam bïtï gwek, hwëna owas hap jalana in kalk në srëm gwek. ");
INSERT INTO ury_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesus ki zep asa gubiridaka, “Haen, nen tembane tan.” Ëe hwëna ama anakan de takensïblïn hap baes tak, “Bian, em nara?” Sap ëe mesë tame lak, “An Bian sake.” ");
INSERT INTO ury_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ki zep Yesus asa golek de tabir zika, hen rotina insa ap kae gwibir-zimki– hogwe taïblïnnï in han. ");
INSERT INTO ury_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Zep ho gutu alpnak iwe, zen dan-ahanna kim zëre hon de ang ta gwen wenya abe mae hap Zënaka zertreizimkike– tïn nïkon de ngaya gwen hyanak. ");
INSERT INTO ury_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kim tembane tasïk, Yesus ki zep Simon, aha bosena Petrussu, takensïblïka, “Yohanis Bak mo tanena Simon, em san eiwa dawemkam Asa enna lwa gweblaꞌara?– wal bose wal om onakonye.” Ki zep ding gulbluka, “In kirekam, Bian, Ena tawana: Ëe ama Emsa enna lwa gweblanan.” Yesus ki zep hwëna ding gulbluka, “Ki amki ano domba zahosa kara ta gwibir.” ");
INSERT INTO ury_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Hom holo gweꞌak, etan ki zep takensïblïka, “Yohanis Bak mo tanena Simon, em san eiwa Asa enna lwa gweblaꞌara?” Ki zep etan ding gulbluka, “In kirekam, Bian, Ena tawana: Ëe ama Emsa enna lwa gweblanan.” Ki zep hwëna ding gulbluka, “Ki amki ano domba zahosa kara ta gwibir.” ");
INSERT INTO ury_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Etan ki zep dan-ahanna takensïblïka, “Yohanis Bak mo tanena Simon, em san ema Asa enna lwa gweblaꞌara?” Dan-ahanna in kim kirekam takensïblïka, enlalana dekam zep dowebla hanaka. Dekam zep ding gulbluka, “Bian, Ena kïtak tawana. Ena tawana: Ëe ama Emsa enna lwa gweblaꞌan.” Ki zep hwëna ding gulbluka, “Ki amki ano domba zahosa kara ta gwibir. ");
INSERT INTO ury_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Eiwa tangan nakaë emsa gubluꞌan: Em kime nama seiwirik gwëka, em ene pakeanna ala so gweka, hen men desan dep ena enlala gwe-gweka, em ene desan song gwe-gweka. Hwëna bogolak, em ere mo tahana esa ïn sosulu, hen eno tahana sa nahaler, hëndep ere mo dwam gwibin srëm san dep sa emsa nërhal.” ");
INSERT INTO ury_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesus mo kirekam de gublunna in, Zen anakan kim goltrëblaka, “Em kirekam esa Alap mo bosesa dikim teip gulsublun hap tïlï.” Yesus ki zep etan gubluka, “Asa em zertron.” ");
INSERT INTO ury_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petrus kim lero gweka, ki zep wal bose zemka hwëna hla taka– mensa Yesus Zëna kwasang gwe-gweblakake. Zini in men zen aumwa hap de tembane tannak Yesus zëre mo golek denakon nikinꞌinkake, hen in zen anakan takensïblïka, “Bian, nara sa emsa kirekam zergulu?” ");
INSERT INTO ury_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petrus ki zep Yesussu takensïblïka, “Bian, zini an zen nëno nik mo alp nakon nikinꞌira, zëbe hap dena banakan sa lwal?” ");
INSERT INTO ury_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ki zep ding gulbluka, “Em ba hap de zëbe hap dena tawa gwen hap? Ëyë desa dwam gweblaꞌanam, ngaya naka de etan jap tazan hap, zen san eno syal?– kire hap denaye. Em diki Asa em zertron.” ");
INSERT INTO ury_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Dekam zep Kristen zinik ola anakan nol halasenk, “Zini zen na-en molya tïlkï– Yesus de lwa halzan srëmnakye.” Hwëna Yesus anakan hom guku, “Ëe ama desa kirekam dwam gweblaꞌan.” Zen diki man gubluka, “Ëyë desa dwam gweblaꞌanam, ngaya naka de etan jap tazan hap, zen san eno syal?– kire hap denaye.” ");
INSERT INTO ury_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ëe an zen– mensa Yesus kirekam gubluka. Zen in zebë ebe mae hap bukuna ansa ale gulzimk. Ano ola an eiwa tangaranna, hen men zen aban mae lowehe gwenan, zen hen man ano ola ansa eiwa nul gwenan. ");
INSERT INTO ury_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesus mo syala nama beya tangankam lwa kïnïꞌan– ano ale gun srëmkam. Zëno syalsa de aha-en aha-enkam ale gunkum, dekam bukuna maka sërkam ëbeya gweꞌan. Okamana an molya sowehek– bukuna insa de zë kang ta gwen hapye.");
INSERT INTO ury_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Dawem, Bian Teopilus Bak, Lukas ona kon: Nonol mensaë ebe hap ale gulbluk, zao mesë kïtak emsa aïsïl gweblak– Yesus mensa syal gwe-gwibirki hen tawa ta gwibirkiye, men dekon nonol syala kon gwesibir hanaka, ");
INSERT INTO ury_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hëndep Alap ngatan zi mo lang san dep zer ine halka. Hwëna zer inehan srëmnak aumwa hap de ola kim zëre mo dam tasibin zini tonbirida gweꞌanka, Alap mo Enhona dekam zep dekam de tame gun hup de sosonna golzimki. ");
INSERT INTO ury_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Karek yala insa de goltowennak kim tïlkï, dekon kim etan ngaya gweka, Zen empat-pulu yaklakam etan-etankam zëre hon de ang ta gwen wenya kip Zënaka zertrei gwizimꞌinka. Zen hen dekam owas-owasna man syal gwe-gwibir-zimꞌinka– dekam de anakan taïblïblan hap, “Zen eiwa mes tangan ki etan ngaya gweka.” Dekam hen Alap Zën de ïrïk gïn hïp denaka tawa ta gwibiꞌinka. ");
INSERT INTO ury_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Aha yaklakam kim golëtembane gweꞌanka, dekam zep gubiridaka, “Yerusalem an kon na-en bahem sek gwen. Men desaë emsa gubirida gwek, Bian de kiresa ebe mae hap zer sonezimdin hip dena, desa em kon kara gweblan. ");
INSERT INTO ury_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Sap Yohanis zen hokam baptis ta gwibirki, hwëna molya holo gwek, emsa hwëna Alap zëre mo Enhokam sa baptis ta gwibiri.” ");
INSERT INTO ury_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Zëre hon de ang ta gwen wenya in kim zë nama tagam nëblaꞌak, ki zep zë dakensïk gweblaꞌak, “Bian, Em san ha angkam tangan esa Israelsa teipsibiridala– Roma mo ïrïk gïn nïkon dikim asa gwiswe sonen hapye?” ");
INSERT INTO ury_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ki zep ding gulzimki, “Ebe mae hap hom nëre mae mo Bianna golzimꞌira– em dikim hamal hap anakan ëtawa gwen hapye, ‘Israel dekam sa ëzë-en gwer.’ ");
INSERT INTO ury_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Hwëna Alap sa ebe mae hap sosonna golzimdi– zëre mo Enhona kim de ebon mae ing gweꞌankaye. Em dekam esa abe hap dena ol halada gwer– nonol tanganna Yerusalemk awe, hen awe de langna an san, hëndep Samaria, hëndep okama topse gwenna.” ");
INSERT INTO ury_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","In kim ki zë kirekam tonbiridaꞌanka, Alap ki zep zëno mae mo nwenak zer ine halka. Hëndep butna ki zep zëno mae mo nwe nakon aning ta inehak. ");
INSERT INTO ury_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yesus in kim sewe seꞌanka, zen nama nglï san ëkara gwe seꞌak. Hwëna mumuk ennak zep zi darena baju ngap-ngap ala oson naban jo kë ine zaka. Zëno mae mo alp nakon yauꞌunka, ");
INSERT INTO ury_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ki zep zë enbiridaka, “Galileak de zi, em ba habe gulk sun ëkara gwe seꞌan? Yesussu in Desa zer ine hannak kara la soner, Zen in kirekam kara la sonenan, kirekam sa etan lwahal zala.” ");
INSERT INTO ury_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Zaitun tra nabare kwatap tekna in zao lowe heꞌak, Yerusalem kon langana aha-ere kilometer enkam. Zen kim kon etan Yerusalem san dep lwanda halzak, ");
INSERT INTO ury_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","golak kim yaïng gwezak, ki zep gulk de tekson san dep sesek gwek– men zëwe zëna lowehe gwekke. Zëno mae mo bosem-sena: Petrus, Yohanis, Yakobus, Andreas, Pilipus, Tomas, Bartolomeus, Matius, hen aha zini Yakobus– zen Alpeus mo tane, hen Simon. Zen men zen nonol Israel dikim Roma mo ïrïk gïn nïkon ëzë-en gwen hap de ëasas gwennak ang gwekake. Hen ahana, Yakobus mo tanena Yudas. ");
INSERT INTO ury_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","In zen zë lowehe gweꞌak, we walya hen ki. Ahana Yesus mo anena Maria. Yesus mo oso walya hen zao lowe heꞌak. Zen kïtak aha-ere enlala naban Alapsa nen sonebla tine gweꞌak. ");
INSERT INTO ury_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","19","18Yudas in zen Yesussu zerguku, te-alana mensa zëre mo syal karekna inkam nërblak, dekam zep ngana zerka. Hwëna ngana iwe zep karekkam zanka. Usis ahlena hëndep kïtak tangan teiswen nahlablak. 19Yerusalemk de wenya kim tïngan nasalblandak, zen dekam zep hwëna ngana insa zëre mae mo olkam bose dak, “Akeldama”kam. Zëno enlalana “Zi Kal Kama.” 15In zen Yesussu de taïblïblan wenya gulk de teksonnak ëtagal gwek, beyana 120 enkam. Petrus dekam zep zëno mae mo ngïrïn nïkon luweka, 16-17ki zep gubiridaka, “Aya-wal oso-wal, eiwa Alap mo hamal hap de ola, zen aha-en mae bëjen jowe srëm gwen. Zep Yudas Bak hap dena mensa Alap mo Enhona hamal hap Daud Bak hap golblaka, zen mes ki kirekam lwak. Sap zen nëno mae mo apde syal bose– mensa Bian hen dam tasïkï, hwëna zen ki zep Yesussu de balk tan hap zon guluda zaka. ");
INSERT INTO ury_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Daud Bak mensa buku Mazmuruk ahana Yudas hap dena hamal hap ale gulku, zen a kirekam moye: ‘Zëno gola dikire dan-en gwek, hen bap zen zë aha zi gwën.’ Hen etan anakan mas gulku, ‘Zëno syala dikire ahanik gulink.’ ");
INSERT INTO ury_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Zep nen esa ahanaka zisi zëno weinak dep dam lasïl, dekam eka etan ëdua-blas gwek– Yesus hup denaka ekakim anakan ol halada gwek, ‘Zen mes tïn nïkon etan ngaya gweka.’ Hwëna anakare zisi nen dam tasïn: Men zen nonol lonesen nakon ang ta gwekke, in kim Yohanis Yesussu baptis taka, dekon Yesus mae han nëbon mae ang ta gwek, hëndep yakla in dekam nëno mae mo ngïrïn klesnak zer ine halka. Zen kire naka esa dam lasïl– men kiye hen nëna.” ");
INSERT INTO ury_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Dekam zep men zen zë tagal gwek zi darena dam nososuk. Ahana Matias. Aha zini Yusup. Zëno bosena dan-ahan. Zen zep hen “Barsabas”kam ahaksa “Yustus”kum nen gweblak. ");
INSERT INTO ury_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Dekam zep kïtak Biansa nen soneblak, “Bian, Em tïngare zi mo enhona tawana. Yudas mes zëre mo syala hli yulku– dekam de song gwen hap, men kirekam Ena hamal hap dam tasïkïke. Zep abe mae hap Em zi darena an kon anakan dam tasizimdin, ‘An zen sa zëno weinak syal gwera.’” ");
INSERT INTO ury_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kim ëgu sonesïk, ki zep dobe abu mo kim syal neibik. Matiaꞌa zep dam dasïk. ");
INSERT INTO ury_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yahudi mo yakla yala Pentakostanak kim zauk, dekam tïngare Yesussu de taïblïblan wenya aha-erenak lowe heꞌak. ");
INSERT INTO ury_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mumuk ennak zep nglï nakore asese yala nasal gubluk. Gola men zëwe lowe heꞌak, zao zep hëndep tïl zïka. Man zë wal-wale gweka. ");
INSERT INTO ury_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Dekam zep zi mahal makare syauk hïtïn beyam-byana hla nulidak. Syauknu in hëndep zëno mae mo nol bol tahannak zep mawa mo kim ëzauk ine gweꞌanzak. ");
INSERT INTO ury_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Alap mo Enhona dekam zep ing gwe hebiridaka, dekam zep Alap zëre onakore sosonkam owas ola donbiꞌik– zëre mae mo tame gun srëm olkam. ");
INSERT INTO ury_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Dekam Yahudi zini, dawemkam de Alapsa betek gwe-gweblan wenya, zen mes tïngare lang nakon yakla yala in hap Yerusalemk ëtagal gwesïk. ");
INSERT INTO ury_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","11","9 Lang bosem-sena in dekore zi ëtagal gwek– Partia, Media, Elam, Mesopotamia, Kapadokia, Pontus, Asia, 10 Prigia, Pamfilia, Mesir, hen langna Libia mo ë yala Kirene mo ïrïk gïn ë-ë nakon, hen ë yala Roma kon. 11a Ahakon hen lang tekna Kreta kon, hen langna Arab kon. Ahakon Yahudi mo ausu nakorena, hen ahakon men zen aha zi ausu nakore zini Yahudi hon bïtï gwekke. 6 Zini in kim asese aukuna insa ësak, dekam zep anakare hap ëhlu-hluk gwezak, “An ba owas zë lwaꞌan?” Zen dekam zep auna ëhlozak: Sap zen zëre mae mo ë-ë nakore olkam de ëtorannak Alap mo Enho nabare wenya insa sane dabiꞌinzak. 7 Ëtenggwaran hap zep hëndep zënaka nenbiridak, “Zini an zen ëtonꞌan, zen sap tïngan Galilea kore zi. 8 Nen hwëna ba habe nëre mae mo olkam de tonbinnik sane labiꞌin? 11b Zen hwëna owas tangan hap am nëno mae mo olkam Alap mo owas syal gwe-gwibinni donbiꞌin!” ");
INSERT INTO ury_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Zen man tangan sërkam de tenggwanbiridan hap enlala nik topse neibiridaꞌak, “An ba hap ki zë lwaꞌan?” ");
INSERT INTO ury_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ahakon hwëna man swrë dabik. Man nenbiridak, “In ho mamaksa de mamkam otdebin hip ki ëgwër.” ");
INSERT INTO ury_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Petrus ki zep seblaskam de wal bose wal zem in han golëluk taka, zëna ki zep ol mam-mamkam zi trana insa tonbiridaka: “Aha lang nakore aya-wal oso-wal, hen tïngare Yerusalemk awe de lowehe gwen wenya, ëe anik srip gulsuzimk. Dawemkam ësane gwek. ");
INSERT INTO ury_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Zini an ho mamakna hom notdebir. Em bap kirekam kïl lïbir! Sap an nama kaknak– yakla nwena sembilannak. Kire jamnak ho mamakna hom notde gwibirin. ");
INSERT INTO ury_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Hwëna an Alap mo ol ayang gul gwen zini Yoel Bak mo ol gu-gun sun ki lwanan. Zen a kirekam mo gu-gukuye: ");
INSERT INTO ury_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Alap man gu-gubiridaꞌara, “Aumwa hap de yaklanak, Ëe asa ëre mo Enhosa tïngare zi hip hlë ta sonezim. Eno mae mo zi walasna hen wenam tol-tola hamal hap de olsa sa donbirida gwer. Eno mae mo wal sei-siwiri nwena sa ëlirisin gwe-gwizim. Hen eno mae mo bong-bongna abe hap dena eisirkim sa kara nul gwer. ");
INSERT INTO ury_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Hen sap bose srëm wenya men zen zi nik ëbabu gwe-gwenan, Ëe asa zëbe mae hap hen ëre mo Enhosa hlë ta sonezim– sap wekam dena, hen sap zikim dena. Zen hen dekam sa hamal hap de ola donbirida gwer. ");
INSERT INTO ury_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ëe asa owas-owassa syal gwe-gwibir– nglïnak hen kamanak, kalkam dena, syaukkum dena, hen ahakon butkam denaka. ");
INSERT INTO ury_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Yakla nwena sa kawesïk gwera, hen benna zi kal mo kim sa kal-kal gwe-gwer. Bian mo hatan yakla yala in de golek de gwenkam, kirekam sa lwa gwer. ");
INSERT INTO ury_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Dekam men zen de Biansa anakan dakenblaꞌak, ‘Asa Emki ngaya tan,’ zen zen sa ëngaya gwer.”’” ");
INSERT INTO ury_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Petrus ki zep etan ayang gulzimki, “Israelk de zi, asa sane lak. Ena tawana: Nazaret walya Yesus hup Alap man owas-owasna syal gwe-gwibir-blika– em dikim anakan tame tan hap, ‘An Zen tangan– Alap zëre mo zer sonen Zi niye.’ ");
INSERT INTO ury_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Hwëna Alap, zëre mo hamal hap de enlala gwibin sin ki kirekam ebe mae hap tapbla tazimki. Hëndep em dekam zebe karek gol gwen zi niban apdenak te-lidak sonnak de makan ta irinkim lak. ");
INSERT INTO ury_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Hwëna juwen zi mo langnak kim sap ati gwe ineka, hwëna Alap dekon etan zeser soneka, dekam zep etan luwen taka. Sap Alap mo Tanena in, Zen bëjen hëndep denaban zëwe gwë gwen. ");
INSERT INTO ury_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yesus hup dena Daud Bak mes ki hen anakarekam guku, ‘Ëe ama Biansa anakan tame tak, Zen sa asa zergwë gwera. Zen man asa dam taha nakon zerzauk sone gweꞌara, ëe zep asa tatem zauk gwer. ");
INSERT INTO ury_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ano enhona in zep sam gwesïk gwenda, hen mipkam tërkam asa Alapsa isrip-sri gwe-gweblal. Ëe hen ama ëre mo tim hip dena anakan taïblï gweblaꞌan, “Zen sa ano timni tïn hyanak ap ëse gulblula.” ");
INSERT INTO ury_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Sap asa men zao nër dwanuꞌak, Alap, Em molye zë asa da tasïkï. Ere mo lalak Zini ano timni zëwe molya batrek. ");
INSERT INTO ury_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Sap em mese ngaya gwen hap de orana abe hap zertrëblaka. Zep ëe kimë eno dang gwënnak hataꞌak, sërkam tangan asa isrip-sri gwe-gwer.’” ");
INSERT INTO ury_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Petrus ki zep ayang gulzimki, “Aya-wal oso-wal, ëe damnak emsa nëre mae mo auyanna Daud Bak hap denaka gubiridaꞌan: Zen mes tïlkï, ki zep nër dwanuk. Men zao nër dwanuk, zen nama hëndep angkam nëre mae mo ngïrïnnïk lwaꞌan. Zep Daud mo ola in, batren srëm hap dena, zen zëre hap hom ki guku. Zen hwëna Auyan-tane zem Yesus hup ki gu-guku. ");
INSERT INTO ury_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Daud in hen Alap mo olsa de ayang gul gwen hap de zi, hen Alap mes ki desa anakan gu-guk gweblaka, ‘Eno ïrïk gïnnï ere mo auyan-tane hap asa golblal.’ ");
INSERT INTO ury_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Zen ngein sin dep nësa de ngaya tabin hip de Zi hip dena mes tame gulku, zep zëbe hap dena anakan hamal hap gu-guku, ‘Alap molya Desa drë nwanunnak da tasïkï, hen zëno timni molya zëwe batreblak.’ ");
INSERT INTO ury_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Zep eiwa mes tangan dam gwesïnïn: Yesus Zen Zen! Alap mes Desa tïn nïkon etan ngaya taka. Aena mesë kïtak hla lak. ");
INSERT INTO ury_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Zen angkam Alap mo dam taha nakon teipsïnkïm nikinꞌira, hen Alap mes zëre mo Enhona zëbe hap zerblaka. Zen in zep hen Desa abe mae hap namen an hlë ta sonezimnira– in kirekam ena asa kara labiꞌin hen sane labiꞌinye. ");
INSERT INTO ury_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Sap Daud Bak zëna hom ngatan zi mo lang san dep sewe seka. Hwëna zen man Teipsïn nïka dan ake seka. Zep anakan guku, ‘Bian Alap ano Teipsïnnï man gubluka, “Ëre mo dam taha nakon emki nikirin– dekon de hen teipsïnkïm ïrïk gïn hïp. Ki asa hwëna ebe hap de jal zini ere mo tana ïltïkïnnïk sisik gulin.”’ ");
INSERT INTO ury_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Zen in zep, Israelk de zi, emki dam taha nakon de nikirin Zini insa tame tan. Yesussu, men Desa ena te-lidak sonnak makan la inkke, Zen Desa Alap teipsïnkïm drë neka. Zen in Zen– nësa de ngaya tabin hip de Zi niye!” ");
INSERT INTO ury_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Petrussu in kim kirekam sane daꞌak, zëno ola in man tangan zëno mae mo enhonak tïsïk. Dekam zep Petrussu zëre mo wal bose walya in han dakensibiridak, “Aya-wal oso-wal, ëe ki basa asa syal eibir?– Alap dikim etan asa sam gwesibiridan hapye.” ");
INSERT INTO ury_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petrus ki zep ding gulzimki, “Em ëhalek! Dekam ëe asa emsa kïtak Kristus Yesus mo bosekam baptis labir. Dekam sa Alap eno mae mo karek-karekna tap gulsuzimdi. Zen dekam sa hen zëre mo Enhona ebe mae hap hlë ta sonezimdi. ");
INSERT INTO ury_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Zëre mo Enhosa de hlë ta sonezimdin hip dena mensa Alap gu-gubiridaka, zen hwëna nëbe mae en hap hom. Hwëna tïngan men desa Alap Kristussu de taïblïblan hap dam tasibiꞌinka, zen hen zëbe mae hap– sap eno mae mo walas, aza-tane wal, hen sap langanak de zi ausu, hëndep lang topse gwennak dena.” ");
INSERT INTO ury_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kirekam-kirekam ol zïm-zïmkïm zë tonbirida gweꞌanka. Hen dekam de ëhalen hap anakan tïtï ta gwibiꞌinka, “Ëngaya gwen hap de ëdwam gwenna, karek-karek gulin hana gwen zi nikon emki ëwet so gwen.” ");
INSERT INTO ury_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Men zen Petrus mo ola in kon ëhalek, desa dekam zep baptis dabik. Yaklana inkam in zen Yesussu daïblïblak, beyana san ha tiga ribu enkam mes yap. ");
INSERT INTO ury_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Men zen Yesussu daïblïblak, dekam dua-blaskam de zini in mo tawa tabinnik isrip-sri naban ëtagal gwe-gwek. Zen gol-gol san aha-ere enlala naban hen tagal gwenda gwek– dekon de Alapsa abe ta gwen hap, hen Bian Yesussu de enlala gweblan hap de rotisa twenblanda gwen hap, hen zep de anggursu otde gwibin hip. ");
INSERT INTO ury_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Dekam dua-blaskam de dam tasibin zini in owas-owasna beya tangankam syal neibirida gwek, zep dekam kïtak man denggwanbirida gwek. ");
INSERT INTO ury_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Zen kïtak aha-erenak lowehe gwek, hen zëre mae mo kire-kirena apdekam bi nëblanda gwek. ");
INSERT INTO ury_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ahakon zëre mae mo kamana hen kire-kirena te-ala hap lirak da gwibik. Te-alana desa tahalha wenya kip kap da gwizimk. ");
INSERT INTO ury_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Hen dekam Alap mo golak mwin-mwankam ëtagal gwe-gwek– dekon de Alapsa gu sone gweblan hap. Zëre mae mo gol-gol san hen apdekam isrip-sri naban tembane tanda gwek. Zëno mae mo enlalana dekam Alap en mo bosesa de ");
INSERT INTO ury_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","teip gulsublun en hap lwa gwizimki. Dekam tïngare zini man sam neisibirida gwek. Hen Bian mwin-mwankam zini zëbon mae de bïtï gwen hap mas-mas gul gweka– Zëna men desa ëngaya gwen hap dam tasibirkike. ");
INSERT INTO ury_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Aha yaklakam Petrus ne Yohanis ne hen man ang ëka– men kirekam Yahudi zini ëgwë gwenanke. Sap zen kam-en Alapsa nen sone gweblanan. Zen zep hen kam-en Alap mo gol san dep song ëka– dekon de hen en soneblan hap. ");
INSERT INTO ury_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nonol lïlïkïnnï, bosena Nwe-Awesna, zëwe zi lekna yakla jamkam nënne gwezak– dekon de zini, men zen Alap mo golak bïtï gwe-gwek, desa te-ala hap aberbe ta gwibin hip. Zini in jaha gweblannak ki hëndep lek gweka. ");
INSERT INTO ury_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Petrus ne Yohanis neka kim lïl zïnnak ake guku, ki zep abe soka, “Ap tol te-alasa olbla.” ");
INSERT INTO ury_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ki zep zë karatda laꞌanka. Petrus zep hwëna gubluka, “Asa emki karatda son.” ");
INSERT INTO ury_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ki zep anakare enlala naban karatda soꞌanka, “Basa wëhë ap olblaꞌanka?” ");
INSERT INTO ury_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Petrus ki zep etan gubluka, “Ano nik mo te-ala kasona hom tangan. Hwëna ëe ama emsa enblaꞌan: Nazaret walya Kristus Yesus mo bosekam em luwen hen song gwen.” ");
INSERT INTO ury_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ki zep Petrus dam taha nakon sap luwen tan hap mas gweblaꞌanka. Hwëna mumuk ennak zep zini in mo tanana hëndep dek dan naban soson nëblak. ");
INSERT INTO ury_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Hetyak gwesïk kïnïnkam zep luwesïk ane kïnïka. Ki zep hëndep Alap mo gol tekson san ërtïlkï. Hwëna zini in nama ki isrip-sri hap hetyak-hetyak gwe naserankam të nasenꞌanka– Alap mo bosesa de teip gulsublun naban. ");
INSERT INTO ury_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Zi beyam-byana in zen Alapsa de gu soneblan hap teksonna iwe lowe heꞌak, zen kim Alap mo bosesa de teip gulsublun naban de të naserannak hla dak, ");
INSERT INTO ury_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ki zep zë tame dak, “O an zi lekna men sake!– men zen mwin-mwankam nonol lïlïkïnnïk nikin gwendake!” Zao zep sërkam tangan denggwanblaꞌak, “An banakan tangan ki dawem gwenda?!” ");
INSERT INTO ury_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Zini in Alap mo golak de tekson-tekson san Petrus ne Yohanis neka ki babang son naban ang gwizim nisen gweꞌanka– hëndep teipsïn zini Salomo Swe mo teksonnak ërtïlkï. Tïngan men zen zë lowe heꞌak dekam zep tenggwaran naban hlu-hluk gwezak. ");
INSERT INTO ury_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petrus ki zep gubiridaka, “Israelk de zi, em basa lenggwanbir? Em san mae habe asa karatda labiꞌin?– ‘Zini an zëre nik mo sosonkam ki dawem lala?’ Ahaksa, san ha ema asa enlala eizimꞌin?– ‘Zen Alap hon de tal eisïn zi dare. Zep dawem lala.’ ");
INSERT INTO ury_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Hwëna kirekam hom. Zen nëre mae mo auyan walya Abraham, Isak, hen Yakob mo Alap, Zen nëp syal gwibir-zimdi– nen dikim Yesus mo bosesa mam gun hup. Hwëna em Desa zi tan zi hibe nër hom ërguzimk. Hëndep Pilatus mo ola ema blum ulblik– zen kim sap zeser sonen hap gublukaye. ");
INSERT INTO ury_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Em karek gol gwen srëm enho lalak Zini Yesussu ema tan hap ërguk. Hwëna zi tan zini Barabas Baksa dikim zeser sonezimdin hibe Pilatussu asas lak. ");
INSERT INTO ury_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Hwëna nëno mae mo ëngaya gwen hap dena men zëno tahanak lwaꞌan, hwëna Desa ema lak. Hwëna Alap mes Desa tïn nïkon etan ngaya taka. Ëe mesë ëre mae mo nwekam hla la gwek. ");
INSERT INTO ury_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Zini an Yesus mo bosena kim salbiri, dekam zep taïblïblala. Hëndep dekam tangan zep dawem gwera– an kire naka ena hla lanan hen tame lananye. ");
INSERT INTO ury_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Hwëna aya-wal oso-wal, ëe tawana: Em tame gun srëmkame kirekam syal eibik. Hen nëno mae mo nol-nola hom anakan tame nuk, ‘Nen kire zisie karek laꞌan.’ ");
INSERT INTO ury_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Hwëna orep Alap mo ol ayang gul gwen zini mes ki anakan ëgu gwek, ‘Israelsa de ngaya tabin hip de Zini sa karek dal.’ Zep Alap mo ola iwe dikim zaun hup, em mese kirekam tame gun srëmkam syal eibik. ");
INSERT INTO ury_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Zen in zep, em ëhalen, ki Alap osan lwan dahak. Zen dekam sa eno mae mo karek-karekna tap gulsuzimdi. ");
INSERT INTO ury_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Hen Alap dekam sa Yesus mo enhona hlë ta sone gwizimdi– dekam de eno mae mo enhosa tatete ta gwizimdin hipye. Hen Alap sa etan Yesussu nëp zer sonezimdi. Sap Zen Zen– Israelsa de ngaya tabin hip de Zini, Bian Alap mensa dam tasïkïye. ");
INSERT INTO ury_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Hwëna Zen ngatan zi mo langnak sa gwë gwera– hëndep Alap de tïngan oto gulsun hup de yaklanak kim de hataꞌak, men kirekam Alap mo ol ayang gul gwen zini ëgu-guk gwekke. ");
INSERT INTO ury_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Sap Musa man guku, ‘Nëno mae mo Bian Alap sa ere mae onakon Ahanaka dam tasizimdi– men kirekam hen asa zëre mo olsa de ayang gul gwizimdin hip dam tasïkïke. Zëno ola kïtak ësal gwek. ");
INSERT INTO ury_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Hwëna zini men zen de Desa nasalbla srëm gweꞌak, Alap sa desa zëre mo hlïl irin nikon golëalsa sone gwera.’ ");
INSERT INTO ury_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Musa en hom kirekam guku, hwëna kïtak de ahakore Alap mo ol ayang gul gwen zini hen kirekam ëgu-guk gwek. Samuel Bak onakon ki lwasek. Zen an zen ki nër hom lwak, zen kïtak zep denaka hamal hap nen gubirida gwek. ");
INSERT INTO ury_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Hen zëno mae mo ola man apde nëk– men kirekam Alap ola nëno mae mo auyan-aza naban hen ziaha-en gul gwekaye. Zen mes ki hëndep nër hom nëbon mae jowek– men kirekam Abrahamsa gu-gublukaye, ‘Eno auyan nakon sa saltïlï– kïtak de okamanak de zi aususa de oto gulsun hup Denaye.’ ");
INSERT INTO ury_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Zen in zep nonol ebe mae hap zer sonezimki– ebe mae hap dikim dawemsa golzimdin hip, hen emsa dikim ere mae mo karek gulin hala seran nakon halen tabin hip.” ");
INSERT INTO ury_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petrus ne Yohanis ne in kim kirekam tawa labiꞌinka, ki zep hen Alap mo golak de syal tan zini, zëwe de jana nabare zi mo teipsïnnï, hen Sadukikam de gubirida gwen zini yaïng gwezak. ");
INSERT INTO ury_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Zen zep zë jal neizimꞌik, sap zen man tawa labiꞌinka, “Nen tïn nïkon esa ëngaya gwer, sap Yesus ki nër hom tïn nïkon ngaya gweka.” ");
INSERT INTO ury_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Zao zep hëndep balk nosok, ki zep hëndep bwinak se nosoink– kaknak de hwëna taken-taken gwizimdin hip. Sap dekam man kaweꞌak. ");
INSERT INTO ury_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Hwëna men zen zëno nik mo tawa labinni insa ësane gwek, dekam beya tangankam Yesussu etan daïblïblak. Dekam Yesussu de taïblïblan wenya, zi ensa de aïtbinkim, san ha lima ribunak mes yap hatak. ");
INSERT INTO ury_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kaꞌankam zep hwëna Yahudi mo teipsïn sinodenak dena Yerusalemk ëtagam gwek. Teipsïn sinodenak dena in, zen ahakon Yahudi mo nol-nolkam dena, bong-bongkam dena, hen Musa mo tïtï tabin olsa de tawa ta gwibin wenya. ");
INSERT INTO ury_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Alap mo golak de syal tan zi mo teipsïnnï, Hanas Bak, man hen iye zemka tagal gulsuku– Kayafas, Yohanis, hen Aleksander maesa. ");
INSERT INTO ury_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ki zep hwëna Petrus ne Yohanis neka de teisya halzan hap nenbiridak. Zao zep taken-taken nei gwizimꞌik, “Em nara mo bosekam hen nara mo sosonkame zi lekna ansa dawem lala?” ");
INSERT INTO ury_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petrussu ki zep Alap mo Enhona ing gwe heblaka. Zen zep ding gulzimki, “Ano mae mo teipsïn-teipsïnnï hen bong-bongkam dena, ");
INSERT INTO ury_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","zi lekna ansaë mo kwasang ëblalke, em in zebe namen asa taken-taken eizimꞌin, ‘Em banakane dawem lala?’ ");
INSERT INTO ury_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Angkam desaë ebe mae hap srip gulsuzimꞌin– hëndep kïtak Israelk de lowe gwen wenya kip: Zen Nazaret walya Kristus Yesus mo sosonkam dawem gwera– mensa ena te-lidak sonnak makan la inkke. Hwëna Alap mes Desa tïn nïkon etan ngaya taka. Zen in zep tangan zini an zëno sosonkam dawem gwera. ");
INSERT INTO ury_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesus Zen Zen– ngïrïn bol Tenyaye, men kirekam Alap mo olak lwakke, ‘Gol tenya men desa em gol tauk gwen wenya baes eibik, hwëna Bian Alap zep desa bolak ïk gïlkï.’ ");
INSERT INTO ury_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Zen Zëbon en onakon esa ëngaya gwer. Sap Alap hom aha zisi dam tasïꞌïra– zëno bosekam de okamanak de zi ëngaya gwen hap denaye.” ");
INSERT INTO ury_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kim zë nakek, ki zep zë tame nosok, “Zi darena an totore zi. Zen hom sekola ëka.” Hwëna zen mae hap denggwanzimꞌik, “Zen udobe naban aïsïl ëꞌara.” Dekam zep zë tame nosok, “O an Yesus mae han zen am apdenak ëtë gwek.” ");
INSERT INTO ury_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Hwëna zini in desa dawem laka, deban zë apdekam ërzauꞌunka. Zep ding nulzim srëm gwek. ");
INSERT INTO ury_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ki zep ë nakon de eissïlï boran hap nenzimk– dekam de zë-en olsa aha-en gun hup. ");
INSERT INTO ury_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ki zep zë zënaka dakensibiridak, “Nen banakan esa zi darena in eizim? Sap tïngare Yerusalemk de zini mes zëno nik mo sërkam de owas syal gwibinni insa ëtawa gwendal. Hen nen banakan molye anakan ulsuk, ‘Owasna in hom jowek.’ ");
INSERT INTO ury_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Hwëna dekam de langa san gol haladan srëm hap, nen esa jalse eizim: Zen bap zen etan zëno bosekam tawa la gwibin.” ");
INSERT INTO ury_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ki zep etan lïlzïn hap nenzimk. Zao zep jalse neizimk, “Etan bahem Yesus hup dena lonbirida nasen gwen, hen zëno bosekam bahem tawa la gwibin.” ");
INSERT INTO ury_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Hwëna Petrus ne Yohanis ne ki zep ding ulzimki, “Emki dam gulsun: San ha dawemna ëe asa eno mae mo dwam gwibin sin ang ër? San ha Alap mo dwam gwibin sin asa? ");
INSERT INTO ury_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Sap in desaë Yesus hon sane ë gwek hen kara landa gwek, ëe molyë desa lonbirida srëm gwe-gwek.” ");
INSERT INTO ury_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kim zë etan anakan jalse neizimk, “Em de etan kirekam lonbirida naserankam, ki asa emsa karek osol,” ki zep wet oson hap nenzimk. Zen mae hap kirekam nenzimk: Zen hom dam nulsuk, “Kirekam esa karek osol.” Sap tïngare zini zëno nik mo owas syal gwibinni in hap man Alap mo bosena teip nulsubluꞌak. ");
INSERT INTO ury_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Sap zi lekna insa dawem laka, tahunna mes 40kam tamanblak. ");
INSERT INTO ury_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Petrus ne Yohanis neka kim tapbla nosok, dekam zep wal bose wal zebon osan dep ola halka. Zao zep lonbiridaka– in desa jalse neizimkye. ");
INSERT INTO ury_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Zen kim ësak, dekam zep apdekam enlala zon tasïblïn naban Alapsa anakan nen soneblak, “Bian, Em ano mae mo teipsïnnï. Nglïna, kamana, hen hina Eme yang tabirki, hen tïngare kirekam-kirekamna. ");
INSERT INTO ury_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Orep ano mae mo auyanna Daud, men zen ere mo ola ayang gul gwekake, zëbon ere mo Enhona man ing gwe heka, dekam zep anakan ayang gulzimki, ‘Zen ba hap waba hap Alapsa de jal gweblan hap ëïlman gwe-gwenan, hen zi trana ba hap zereijan hap kalang në gweblanan? ");
INSERT INTO ury_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Okamanak de teipsïn-teipsïn wenya zen olsa aha-en nul gweꞌan, hen mam-mam wenya man ëtagal gwe-gweꞌan– Bian, Ere han hen ere mo dam tasïn Zini in han dikim zieijan hap.’ ");
INSERT INTO ury_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Zen eiwa mes ki kirekam nëno mae mo ngïrïnnïk lwak! Sap Herodes ne Pontius Pilatus ne ëna awe mes Yahudi srëm zi niban hen Yahudi zi niban ola iaha-en ulki– dekam de ere mo dam tasïn lalak Zini Yesussu tan hapye. ");
INSERT INTO ury_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Hwëna zen dekam ere mo dwam gwibin sin ki syal neibik– men kirekam ena hamal hap kalang gwe gukuke. ");
INSERT INTO ury_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Zep Bian, emki enlala gwibin– insa anakan asa nenbiridalke, ‘Ëe asa emsa karek labir– em de zëno bosekam tawa tabinkimye.’ Hwëna sosonna E-en esa ki abe mae hap gol gwizimdi– ëe dikim ere mo olsa udobe naban tonbirida gwen hapye. ");
INSERT INTO ury_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Zep Emki ere mo dam tasïn lalak Zini Yesus mo bosekam zi sang-sangsa dawem ta gwibin, hen owas-owassa syal gwe-gwibir-zimdin– dekam deka tïngan daïblïblak.” ");
INSERT INTO ury_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kim nen sonesïblïk, Alap ki zep gola men zao tagal gwek ëwak taka. Zëre mo Enhona dekam zep ing gwe hebiridaka. Zen dekam zep udobe naban Yesus hup de Alap mo ola donbirida gwek. ");
INSERT INTO ury_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tïngare Yesussu de taïblïblan wenya dekam enlala aha-erekam lowehe gwek, hen enho aha-enkam. Zen hom zëre mae mo kire-kirena zëre en hap inik nëblanda gwek, hwëna kïtak apdekam bi nëblanda gwek. ");
INSERT INTO ury_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Dua-blaskam de dam tasibin zinik dekam zep sosonna mam gwizimk– zen dikim anakan gol halada gwen hap, “Yesus mes etan tïn nïkon ngaya gweka.” Alap mo kwasang-kwasangna dekam kïtak zëbon mae onak lwa gwizimꞌik. ");
INSERT INTO ury_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Dekam Yesussu de taïblïblan wenya hom mae ëtahalha gwe-gweꞌak, sap dekam zini zëre mae mo kamasa ahaksa gol maesa te-ala hap lirak da gwibiꞌik. ");
INSERT INTO ury_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Te-alana desa zep dua-blaskam de wenya in hap kap da gwizimzik. Zen desa zep hwëna tahalha wenya kip kae nëblanda gwizimk. ");
INSERT INTO ury_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Dekam zep hen lang tekna Siprus kore zini, Yusup, ngasa te-ala hap lirak taka. Te-alana desa zep kïtak dua-blaskam de wenya in hap zerzim zika. Zini in Lewi Bak mo ausu nakorena. Dua-blaskam de wenya in man hen desa bose dak Barnabaskam. Bosena in mo enlalana, “Zi mo enlalasa de tatete ta gwizimdin hip de zi.” ");
INSERT INTO ury_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ahana hen zini ki, bosena Ananias Bak. We zem bosena Sapira. Zen hen kamasa te-ala hap lirak uk. ");
INSERT INTO ury_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Hwëna zen man te-alana zëre nikip hlï lasïk. Aha hlïk en naka zep Ananias dua-blaskam de wenya kip anakare ola ban zerzimki, “An tïnganë ep zerzimꞌin.” Hwëna we zeban mes kirekam de ahap labin hip ola aha-en uk.