﻿USE sofia;
DROP TABLE IF EXISTS sofia.urw_vpl;
CREATE TABLE urw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES urw_vpl WRITE;
INSERT INTO urw_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Keriab Yaweb dora Amitaib nono Yona gam ogureaga. ");
INSERT INTO urw_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","Nu menüm wageaga, “Na siradibe Niniwe fib erekokai gam kümüne. Na kümnabe ferefinabur dora sogi dünige. Ye kegeafotun nin kabia kogi fanam gedge.” ");
INSERT INTO urw_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Bangeaga ko, Yona Keriab Yawe ebügadid gudi, fib Tarsis kümnebüregeaga. Bana nu siradid fib Yopa gen baba gam kümneaga. Bangüdi nu oude ere güre, fib Tarsis kümne büregeaga baba kaiweaga. Nu oude ere murugafütudi oude ere taugeg ferewar kiab kekia ebeden. Nu Keriab Yawe ebügadid gudi kümne büregeaga. ");
INSERT INTO urw_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Bangeaga ko, Keriab Yawede kübür sogi sugurwar masyag gam taideaga. Bangar kübür tugu yag tugu sogi taideaga, bangar oude ere koigebüregeaga. ");
INSERT INTO urw_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Oude ere taugegwar nin kimigen, bangar gürenakuti gürenagürena nugengab dugtaba yagwen. Nin oude ere kubweg urwen, bangarbere dabadaba düd masyag gam fotutugen. Bangeaga ko, Yona nu oude ere gadi gam egimena kanüdi kinbüreaga. ");
INSERT INTO urw_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Bangar oude ere debetaweg fere nu oguradi Yona menüm waweaga, “Amure na kinin? Na siradibe nagüb dugtaba yaguwe. Nu sigeure korarabuwar sagsigarbere kumeregüdargedag.” ");
INSERT INTO urw_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Bangarbere oude ere taugeg ferewar siradid doragen, “Bana aimag fürüdie kub meme kogifursigebüregeaga baba fere sige sibamgeg.” Nin bangen babade Yonab yanim taideaga. ");
INSERT INTO urw_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Bangar dora menüm wawen, “Na kub meme sige gam taideaga baba ginim wasige. Na meag am gün? Iyo! Na aragüb? Na am gingamnab?” ");
INSERT INTO urw_vpl VALUES ("JH1_9","033_1_9","JON","1","9","10","Bangarbere Yona maig menüm wangeaga, “Ye Ibrub, bangar ye Keriab Yawe gam kunube iruawaigün, nu fib namagamnab Keriab. Nude masyag, kümdim tugu idaweaga.” Bangarbere Yona nu oude ere taugeg ferewar menüm wangeaga, “Ye Keriab ureadi gun.” Nin dora baba edid kimgen. “Na am daba gün?” Nin sibamgafotuwen, Yona Keriab Yaweüre guweaga, wangafotuweaganwai babaure. ");
INSERT INTO urw_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Kübür tugu masyag tugu sogi siradeaga. Bangarbere oude ere taugegwar Yona menüm totowen, “Sin nag gam am bangüdarbere, masyag kumar sin nama büreregenan?” ");
INSERT INTO urw_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Bana Yona maig menüm wangeaga, “Nin ye dibe masyag nigumo fotyarye masyag kumeregeaga. Ye sibam, masyag erekokai nin gam taideaga baba ige ginim.” ");
INSERT INTO urw_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Bangeaga ko, oude ere taugeg ferewar nin oude ere did merai kumnebüregen, bangar nin oude sogi oren. Bangen ko, masyag sogi ferar, nin udi gam taidegi dirugungeaga. ");
INSERT INTO urw_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Bangar nin Keriab Yawe menüm yagwen, “Keriab Yawe, sin nagure sibdibwenan. Bana sin fere meme masyag nigumo fotugar, bana nag sin eusigab kumubugona. Fere gürede fere güre orfotuwar, nag fere baba doragam ifrugawaigün baba sike, sin daka dora gam difrusigegena. Keriab Yawe nagüb ututun gürena daiudi meme kub taideaga.” ");
INSERT INTO urw_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Bana Yona kuadüdi masyag gam fotwen, bangar masyag kumeaga. ");
INSERT INTO urw_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Oude ere taugeg ferewar Keriab Yaweüre erekokai kimgüdi, Keriab Yawe keab bai früdi kob gürena iferen. ");
INSERT INTO urw_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Bana Keriab Yawede wade güre erekokai sugurwar Yona enweaga. Bangar Yona nu sida küi, gitweg küi wadeb sibim gam büreaga. ");
INSERT INTO urw_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Yona nu wadeb sibim gam bürüdi, Keriab Yawe nugeabüre sibdibweaga. ");
INSERT INTO urw_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Nu menüm wageaga, “Keriab Yawe, ye kub kemein, bangar ye nagure yagün, baba na yeb ig edün. Ye kumeg ferengab fib gam bürüdi nagure mürün, nag yeb mereb edün. ");
INSERT INTO urw_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Nagüde ye fotüyab masyag minigo musun, masyagüde gürenakuti koratauyaga. Na bangab masyag ye kekia binaweaga. ");
INSERT INTO urw_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ye menüm wagün, ‘Nag ye kudeiafotun ko, ye fata nagüb maig kegeweregün.’ ");
INSERT INTO urw_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Masyag ye kekia binaud koratauyar, suka nanagün. Bangar masyagüde gürenakuti koratauyaga. Masyag gamnab yabonde yeb taba dariweaga. ");
INSERT INTO urw_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ye masyag nigumob girtorub gürenakutib ginim gam kanün. Ye fib meme kakia gam bürün. Bangeaga ko, na igeab Keriab Yawe na maig ye igain. Ye fib kakia baba ebügadidi mugar omo bürün. ");
INSERT INTO urw_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Keriab Yawe, ye utungün ba, kumebüregün, bangar ye nagure utungün. Yeb sibdib meme nagüb fata gam taideaga. ");
INSERT INTO urw_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Ferefinabur dugtaba nugengab gam kunube iruwawaigen baba, nag ebügaden bangar na nirarangawaigabge. ");
INSERT INTO urw_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Ye nagure mun orudi nagüb yanim sirargabere büregün, bangüdi nagkre bai ferebüregün. Dabadaba gürenakuti ye nagkre kob gürena iferebüregün baba ye bangeregün. Keriab Yawe, nag gürena sin maig kiresigawaigün, bangarbere sin omo burwaigenan.” ");
INSERT INTO urw_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Bana Keriab Yawede wade wawarbere, kümüna Yona udi gam nirfotuweaga. ");
INSERT INTO urw_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Keriab Yaweb dora maig Yona gam ogureaga. ");
INSERT INTO urw_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","Nu menüm waweaga, “Na siradibe Niniwe fib ere gen baba gam kümne. Kümüna fib ere gam taidabye dora dünür ferefinabur pitaid wanüge.” ");
INSERT INTO urw_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Bangar Yona Keriab Yaweb sube daiud siradüdi Niniwe kümüneaga. Niniwe nu fib erekokayau. Bana fere güre nu meirade kümüna fib ere baira taidebureba, dü küi kenegarbere taideregeaga. ");
INSERT INTO urw_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Yona nu urigeg toadid kümüna fib ere gam iruweaga. Nub urigeg dü gürena kenegarbere, ferefinabur gam sogi yagüdire mengeaga, “Dogob tug bede fogo (40) dü kuri kenegarbere, Niniwe gürenakuti koigeregeaga.” ");
INSERT INTO urw_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Niniwe ferefinabur nin Keriabüb doraure kob kainanagen, bangüdi nin menüm wagen, “Sin daba kudigüb. Sige eregeam ferefinabur tugu ugu ferewar tugu, sige gürenakuti korarabüb marsasai tugu kar tugu dagüdi korarab sigeab utungub.” Nin bangen babade nugengab dora daiwen. ");
INSERT INTO urw_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Niniweb erekokayau nu dora baba edidire, nugeab gotogeg kur nama baba ebügadeaga. Bangar nugeab karün nama baba düfotudi korarabüb marsasai dagdüdi kegob gam gotogeaga. ");
INSERT INTO urw_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Bangar Niniweb erekokayau nugeab ferefinabur gam dora sugurweaga. Nu menüm dorageaga, “Meme dora igeab taba ferewar kiabungab. Nin gürenakuti daba kudigane. Ninag ferefinabur, ninagüngab burmakau sipsip tuguna gürenakuti daba yag nagana. ");
INSERT INTO urw_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Nin gürenakuti korarabüb marsasai, kar dagübenar ninagüb burmakau, sipsip tuguna dabadaba baba nümnana dagbürüngane. Nin bangüdi Keriabüre sogi sibdibwane. Nin kabia kokogi ebügafotuwane. Ferefinabur kogi fürüngawaigenan baba gürenakuti ebügafotuwane. ");
INSERT INTO urw_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Sige bangüdarba Keriab nu ututun piruebeagadag, bangar nunur ebügadar, sige kumeregüdige.” ");
INSERT INTO urw_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Bana nugengab kabia kokogi baba ebügaden, bangar Keriab kabia gen baba kegeweaga. Keriab ututun nugeab piruabürudi, kabia kogi gebüre dorageaga baba garge. ");
INSERT INTO urw_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Yona Keriabüb kabia baba kegeudire, kob koigarbere nu magiraweaga. ");
INSERT INTO urw_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Bangar nu Keriab Yaweüre menüm sibdibweaga, “Keriab Yawe, na yeb dora ede. Ye igeab fib ara ebügadibe gam, nag bangebüregün baba, ye sibamgafotun. Bangar ye gudi Tarsis kümünebüregün. Ye sibam, Keriab nag korarabtuka na niraratuka. Na pirika magiranawaigarge. Kene. Na sinure bata korarabsigawaigün. Na ututun nagüb piruafaigün, bangüdi ferefinabur menmen gen ko, kogi fürüngawaigabge. ");
INSERT INTO urw_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Bana Keriab Yawe, mugar yeb etob kenegafotuwe. Ye kumurba, baba nama. Ye kumurgegarba, baba namage.” ");
INSERT INTO urw_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Bana Keriab Yawe maig menüm waweaga, “Yona, nab nunur baba namagünde?” ");
INSERT INTO urw_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Bana Yona fib ere ebügadüdi, kümüna sidamoweg yau gotogeaga. Nu yanafata fürüdid, baba gam gotogüdi büreaga. Nu fib ere gam amdag daba taideregeaga baba kegewebüregeaga. ");
INSERT INTO urw_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Keriab Yawe dugumob muri güre taidügaberar Yona iwagaferar, sidade mube nub gagweregarge, bangar nu namafanam büreregeaga. Bangar Yona muri babaure ebebearweaga. ");
INSERT INTO urw_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Bangeaga ko, kiarige fitunana Keriabde sam güre sugurwar, ogura muri baba koigaberar muri baba genangeaga. ");
INSERT INTO urw_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Bana kuri sida taidarbere, Keriabde kübür sida gag tug sugurwar sidamoweg yau ogureaga. Bangar sidade Yonab taba fugüwarbere ege agüdikuaniniwar fürügaduebüregeaga. Bana Yona menüm utungeaga, “Ye kumurba, ba nama. Ye kumurgegarba, ba namage.” ");
INSERT INTO urw_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Bangar Keriab Yona menüm waweaga, “Na muri meme kumarbere na nunurgün. Nab nunur baba namagünde?” Bangar Yona dora maig menüm waweaga, “Iyo, yeb nunur ba nama. Ye magira erekokai siyarbere kumeg utundün.” ");
INSERT INTO urw_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Bangar Keriab Yawe menüm nu waweaga, “Gitweg gürena gam muri meme foudi erekokaigeaga, gitweg güre gam nu maig kumeaga. Nure na funai fanam dabge, nade nu idawab foudi erekokaigarge. Bangeaga ko, na daba fanamere babaure korarabneaga. ");
INSERT INTO urw_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Ige Niniweure korarabyaga. Fib baba nu erekokai, ferefinabur mabünge, baba ferefinabur kabia nama tugu kogi tugu nin sibamgedge, yanim ninib 120,000 emegerweaga. Bana burmakau tugu mabünge.”");
INSERT INTO urw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Eregeam Tiofilus, na ede. Egime Keriabüde daba daba gürenakuti sin kodigo taiberar taideaga babaure, fere epürade nugengab kube fururugüdi doraman feien. ");
INSERT INTO urw_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ferewar nugengab egede daba daba omogamnana tataigar kegewenwaib, baba ferewarüngab dora daiwen. Baba ferewar Keriabüb dorab saina ferewar sibe bürüdi, doraman baba, wasigen. ");
INSERT INTO urw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Bangar ye tugu, doraman meme feiebüregün, bangüdi na gam sugurur ogureregeaga. Ye baba daba daba gürenakutib ginimure egimenana fünaiudi idadau totogünwaib. Mügar ye baba daba daba tataigen baba sibenana surur fein. ");
INSERT INTO urw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Dora sarigabürünen baba, baba gürenakuti kainana. Na ninaidiba, idadau sibamgeregün. ");
INSERT INTO urw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herot Judiawarüngab erekokayau büreaga sese gam Keriabüb kobegegi fere güre büreaga, yanim nub Sekaraia. Nu Abiyab gingamnab, Keriabüb kobegegi fere. Nub fia Aronüb gingamnab, finegeb yanim baba Elisabet. ");
INSERT INTO urw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nugeküre Keriabüb ege gam idadau büren. Bangar nugeküre Erekokaib kabia gürenakuti tugu dora gürenakuti tugu daiwafaigen, bangar nugeküre ege nub gam menmen kene büren. ");
INSERT INTO urw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bangeagako, nugeküre mogoi kene, amure, Elisabet nu kedemai. Bangar nugeküre goyam abüdigen. ");
INSERT INTO urw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sese güre gam Sekaraiab gin, Keriabüb fata gam kobegebüre kümünen, bangar Sekaraia tugu Keriabüb ege gam kobe fünaiweaga. ");
INSERT INTO urw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Bangar nini Erekokaib kobegegi fere wonide, kumaub bai kebur kuri nama tugu ferebeaga, baba fere fitawebüre ai magi epürawen. Bangar nini baba epüra gamde Sekaraia kaiwen, bangar nu bai ferebüre iruweaga. ");
INSERT INTO urw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Baba bai fereg sese gam, ferefinabur epüra kedeb fata obgoime gurudi bürüdi sibdibwa büren. ");
INSERT INTO urw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Bana bangar Erekokai Keriabüb dora dugurewegi fere güre Sekaraia gam taideaga. Bangüdi kumaub kebur kuri nama tugub, bai feregib kurub kube namayau biboudi büreaga. ");
INSERT INTO urw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraia Keriabüb dora dugurewegi fere kegeudi, tergüdi kimigeaga. ");
INSERT INTO urw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Bangeagako, Keriabüb dora dugurewegi ferede menüm waweaga, “Sekaraia, na kimigegena. Keriab nab sibdib edfotuweaga. Fian Elisabet nono sinoyeregeaga. Bangar na nub yanim Jon yanübaue. ");
INSERT INTO urw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Bangar nab kob nama bürar nag ebebearweregün. Bangar ferefinabur epüra nono baba taidegi gam ebebearweregen. ");
INSERT INTO urw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Amure, nu Erekokaib ege gam yanim erekokai deregeaga. Nu wain mum, kida yag tugu neregarge. Nu anab sibim gam büreaga baba sese gam, Etob Kedebüde korobaweaga. ");
INSERT INTO urw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nude bangar Israel ferefinabur epüra kob pirudi, nugengab Erekokai Keriab gam kümüneregen. ");
INSERT INTO urw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nu Elaijab kabia tugu, sogi tugu düdi, nuge kese agfürüdi kümüneregeaga, bangarie Erekokai kuri daiweregeaga. Nude emnügmana tugu mogoi toi tugu kob gürena gam difürüngeregeaga. Bangüdi dora biregawaigen baba ferewarüngab ututun idabereregeaga, bangar fere namab ututun sibe büreregen. Bangar ferewar ekotagaberar, Erekokai ogureregeaga baba, momoudi büreregen.” ");
INSERT INTO urw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Bangar Sekaraiade Keriabüb dora dugurewegi fere menüm waweaga, “Ye aranüm nab dora baba kainanagüdi sibamgüi? Ye goyamügafotün, fiai tugu nu abüdigeaga.” ");
INSERT INTO urw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Bangar Keriabüb dora dugurewegi ferede dora menüm toweaga, “Ye Gebriel, ye Keriabüb ege gam bibougafaigün. Keriab nugede suguryar ye wanebüre oguran. Bangar dora nama fanam meme dünebüre na gam oguran. ");
INSERT INTO urw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Bana ede. Na yeb dora kob kainanagabge babaure, mügar nab sube gütügar dorageregabge, kümüna baba daba daba gürenakuti taifotuwarie. Dora yeb meme nugeab sese gamie taideregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kedeb fata gam amdag daba taidar, Sekaraia bata büreaga. Bangar ferefinabur dagodaiudi, ututun toitoiudi büren. ");
INSERT INTO urw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bangar kuri füraboudi, nini gam doragegi dirugweaga. Bangar nini sibamgen, Keriabüb fatagoime daba aranümdag kegeweaga. Nugeab kube gamde gürena nini keab dorageaga. Amure, nugeab sube baba gütüweaga. ");
INSERT INTO urw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kuri, Sekaraia nugeab fünaiwegi sese kenegarbere, nugeab fib gam maigüdi kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bangar kuri fia Elisabet mube kub tugu gar, edina taba tugu iwagüdi büreaga. Elisabet menüm wageaga, ");
INSERT INTO urw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Egime ye mogoi kene gar maiagün. Bangeagako, Erekokaide ye nirarayeaga. Babaure, mügar ye mube kub tugu, bangar babade yeb maia, ferefinaburüngab ege gam kenegafotuweregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet mube kub tugub edina kubete gam, Keriabüde nugeab dora dugurewegi fere Gebriel sugurwar, Nasaret kümüneaga. Nasaret nu Galili distrik büreaga. ");
INSERT INTO urw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Momugo güre Devitüb gingamnab fere güre debüre dora idafotuwenwaib baba gam kümüneaga, yanim nub Josep. Momugo babab yanim Maria. ");
INSERT INTO urw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Bana Gebriel nu gam kümünadi menüm waweaga, “Momugo, na büründe? Erekokai naküre bürüdi, unun dünüdi tauneaga.” ");
INSERT INTO urw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria dora baba edüdi, tergüdi menüm utungeaga, “Dora meme aranüm?” ");
INSERT INTO urw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Bangar Keriabüb dora dugurewegi ferede menüm waweaga, “Maria, na kimigegena. Keriab nu kob düneaga. ");
INSERT INTO urw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ede. Na mube kub kaiudi nono güre sinoyeregün. Bangar nub yanim Jisas yanübaue. ");
INSERT INTO urw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nu eregeam büreregeaga. Bangar Keriab Kekia Asaub Nono güdi yanübaweregen. Bangar Erekokai Keriabüde, oyebeb Devit sibe erekokayau difereregeaga. ");
INSERT INTO urw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nu Jekopüb gin toib erekokayau tüpür büreregeaga. Bangar nub koroba baba, kenegeregarge.” ");
INSERT INTO urw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Bangar Mariade Keriabüb dora dugurewegi fere menüm totoweaga, “Baba daba aranüm taidebeaga? Ye fere güre küre kinürge.” ");
INSERT INTO urw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Bangar Keriabüb dora dugurewegi ferede dora nub menüm toweaga, “Etob Kedeb na gam ogureregeaga, bangar Keriab Kekia Asaub sogide korobaneregeaga. Bangar kuri nono sinoyeregün baba, nu Keriabüb fere nama, idadau bürar, Keriabüb Nonogüdi yanübaweregen. ");
INSERT INTO urw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Ede. Anin fanam Elisabet abüdigfotuweagako, nu mube kub tugu gar nono sinoyeregeaga. Egime mogoi sinoyafaigargegenko, mügar nu mube kub tugu, edina nub kubete tugu kenegeaga. ");
INSERT INTO urw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Am daba güre Keriabüde gegi dirugweregarge.” ");
INSERT INTO urw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Bangar Mariade menüm wageaga, “Edün. Ye Erekokaib sarua finege. Nu ye gam nag wagün sibe geregeaga.” Bangar Keriabüb dora dugurewegi fere nu uriaudi kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Baba sese gam Maria pirikanana siradüdi, Judia distriküb gir toi gam bag komeaga. Bangüdi fib ere güre bag büreaga baba gam kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Bangüdi Sekaraiab fata gam iruwaboudi, Elisabet ferebereweaga. ");
INSERT INTO urw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet Mariab ferebere baba edar, nono Elisabetüb sibim gam büreaga baba kutuweaga. Bangar Etob Kedeb Elisabet korobaweaga. ");
INSERT INTO urw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Bangar Elisabet sogsogi igyogüdire wageaga, “Keriabüde unun düneaga, baba unun finabur gürekoi dünügeaga baba emegerweaga. Bangar nono nagüb sibim gam büregeaga baba, nu tugu Keriabüb unun deaga. ");
INSERT INTO urw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ye won gar, igeab Erekokaib ana ye gam ogureaga? Ye finege tün tugubge. ");
INSERT INTO urw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Edün. Kagub yeb nab ferebere edegi sese gam, nono yeb sibim gam büreaga baba, nu tugu ebebearudi kutuweaga. ");
INSERT INTO urw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Na Erekokai nugede waneaga baba sibenana geregeaga, babaure na kob kainanagün, babaure na ebebearue.” ");
INSERT INTO urw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria menüm wageaga, “Kob yeb Erekokaib yanim siradgabereaga. ");
INSERT INTO urw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Bangar kob yeb Keriabure ebebearweaga, nu ye Maig Igayegib Fere. ");
INSERT INTO urw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ye nugeab sarua finege, ye ugu finegeko, nu ye kegeidi nirarayeaga. Mügar, kuridaka ferefinabur gürenakuti Keriabüde ebebear erekokai siagagüdi, dorageregen. ");
INSERT INTO urw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Keriab nu sogi erekokai tugu, nu ye sagiebüre daba amdag sibe banüm geaga, bangar yanim nub kedeb büreregeaga. ");
INSERT INTO urw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nu ferefinabur nuge miniba bürfaigen baba, nirarangafaigeaga. Ferefinabur mügar büren tugu, kuri tataigeregen tugu tüpür babanüm gürena geregeaga. ");
INSERT INTO urw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kube nugeabüde fünai gugub geaganwaib, fere simai sige gürena agferenangüdi nugengab yanim siradgabürügafaigen baba, kudengar sarawen. ");
INSERT INTO urw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Erekokayau toi febangüdi, nugengab gotogegi kur nama gam kudengüdi, fere yanim kenewar baba, yanim ere dünügeaga. ");
INSERT INTO urw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Fere ogunongeaga baba, daba daba nama nama epüra dünügar fugongeaga. Bangüdi fere daba daba epürage tugu baba, kudengar uguna kümünen. ");
INSERT INTO urw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Keriab nugede sigeab oyebesig Abraham dora duweaga, baba tugu Abraham nugeab matanab mana gürenakuti gam tugu dora dünügeaga. Baba dora wanügafotuweaganwaib baba, tüpür tüpür büreregeaga. Baba dora Keriab nugeab utun gamnana bürar nirarangeaga. Nu namana niraragüdi Israelwar sagüngeaga. Israelwar nini Keriab nugeab sarua ferefinabur.” ");
INSERT INTO urw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria Elisabet küre edina küidag banüm büreaga, bangüdie nugeab fib gam maigüdi kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet mogoi sinoyegib sese taidar, nono sinoyeaga. ");
INSERT INTO urw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elisabet nugeab fib büreabmana tugu, nugeab giniabmana tugu, Erekokaide Elisabet nuge niraraweaga baba doraman edüdi, Elisabet keab ebebearwen. ");
INSERT INTO urw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Dü düm kenegarbere nonob mube sike katuwebüre oguren. Yanim Sekaraia duwebüregen, emeb yanim sibe. ");
INSERT INTO urw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Bangeagako, nonob anade wageaga, “Kene. Yanim nub Jon yanübaub.” ");
INSERT INTO urw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bangar wawen, “Ninagüb ginyanügmana güre yanim babanüm kene.” ");
INSERT INTO urw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bangar eme kubede gürena totowen, nu nono am yanim duwebüregeaga. ");
INSERT INTO urw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Wanügar taper mara güre düdi oguredi dora feieregeaga, bangedi dora menüm feiaga, “Nub yanim Jon.” Bangar ututun toitoiwen. ");
INSERT INTO urw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Bangar pirikanana Sekaraiab sube maig taiboyeaga. Bangar doragüdi Keriabüb yanim siradgabereaga. ");
INSERT INTO urw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bangar nugeab fib büreabmana gürenakuti, baba daba adab taideaga baba kegeudi kimigen. Bangar baba daba daba gürenakutib doraman baba saraudi fib gürenakuti, Judia distriküb gir toi gam büren bag kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Fere gürenakuti doraman baba edüdi, ututun toitoiudi menüm totogen, “Kuri nono baba fere aranüm taidebeaga?” Nin sibam, Erekokaib sogi nuküre büreaga. ");
INSERT INTO urw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Bana Etob Kedeb nono babab eme Sekaraia gam gobeaga, bangar kiari dora menüm wageaga, ");
INSERT INTO urw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Erekokaib yanim siradgaberegi, Israelüb Keriab. Nude oguradi sige nugeab ferefinabur sagsigüdi maig igaisigeaga. ");
INSERT INTO urw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Sige Maig Igaisigegi Fere güre sogi tugu, Erekokaide Devitüb gin gam, taibereaga. Devit nu Erekokai nugeab saina mogoi. ");
INSERT INTO urw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nuge egimenana nugeab kiari ferewar dora dünügar doragafotuwenwaib sibe. ");
INSERT INTO urw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Sige sigeab karauyasigmanangab kube gam tugu, sigeure kob koigafaigen baba ferewarüngab kube gam tugu, nugede maig igaisigeregeagagüdi wageaga. ");
INSERT INTO urw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nuge sigeab matuwasigmana nirarangüdi sagüngeaga. Babaure nuge egime dora idafotugeaganwaib baba, nugeab utun gamnana büreaga. ");
INSERT INTO urw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nuge sigeab matuwasig Abraham gam kürüna kekiagüdi wageaga, babaure nuge egime wageaga sibe, mügar sige gam gebüregeaga. ");
INSERT INTO urw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nu sige maig karaungab kube gam igaisigebüregeaga, bangar sige nugeab fünai düdi kimigegige. ");
INSERT INTO urw_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Babaure sige sese gürenakuti omo bürenan baba, nugeab ege gam kabia surur surur gam urigegi, bangar nuge kabia nama nama nimeweaga baba, sige gam goberegeaga. ");
INSERT INTO urw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nono, na ba, kuri Keriab Kekia Asaub Kiari fere güdi yanübaneregen. Nade Erekokai nugeab erekobo daiebüre agfereregün. ");
INSERT INTO urw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","79","Nade nugeab ferefinabur sarigabürüngab, nugeab nirara erekokai baba sibamgeregen. Keriab nugengab menmen unaigafotudi maig igaingebüregeaga. Fere gituwegi gam büren tugu, fere kumegure kimigen gam tugu, baba meram dünügebüre fib nama gamnab suboyegi sugurwar sige gam ogureregeaga. Nuge sigeab kebe sururgar, sige kob ebebear erekobo gam urigegi.” ");
INSERT INTO urw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kuri nono baba adagar, Etob Kedebüde sogi duweaga. Bangar nu kümüna fib fere kene gam büreaga. Bangüdi kuri Israelwarüngab ege gamie, agüba taideaga. ");
INSERT INTO urw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Baba sese gam Sisar Ogastusde ferefinabur gürenakutingab yanim degi kabia güre difereaga. ");
INSERT INTO urw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kübüdim bera taugegi fere Ogastusde, yanim ninib deaga. Baba fünai omo mügarie taideaga, baba sese gam Kwirinius nu Siriawarüngab kübüdim bera taugegi agferegi büreaga. ");
INSERT INTO urw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Babaure ferefinabur gürenakuti nugengab fib mudimere gagam kümünedi, kübüdim bera taugegide yanim ninib deregeaga. ");
INSERT INTO urw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep nu Devitüb gingamnab, babaure Nasaret ebgadeaga. Nasaret nu Galili distrik büreaga. Bangüdi Devitüb fib ere baba gam kümüneaga. Baba fib ereb yanim Betlehem. Nu Judia distrik büreaga. ");
INSERT INTO urw_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nu finege nuge duwebüre dora idafotuwenwaib babaküre kümünedi, kübüdim bera taugegide nugeküreb yanim deregeaga. Baba sese gam Maria nu mube kub tugu. ");
INSERT INTO urw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nugeküre Betlehem bag bürediberenana Maria mogoi sinoyegi sese taideaga. ");
INSERT INTO urw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Bangar nono keman sinoyeaga. Bangüdi ude gamde korotaudi bulmakau toib au fade gam kinmegabereaga, amure guruwegi fata gobeaga. ");
INSERT INTO urw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Baba gam sipsip taugegi ferewar gürekoi, Betlehem fib ere obgoira bürüdi, utumnonou nugengab sipsip toi taugen. ");
INSERT INTO urw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bangarbere, Erekokaib dora dugurewegi nini gam ogureaga, bangar Erekokaide nugeab meram ere güre gar taidüdi koingeaga, bangar nini kürüna kimigen. ");
INSERT INTO urw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bangeagako, Keriabüb dora dugurewegide menüm wangeaga, “Nini kimigagana. Edane. Ye nini gam dora nama meme düdi oguran meme, ferefinabur gürenakuti ebebearwegib dora nama. ");
INSERT INTO urw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Baba dü gam Devitüb fib ere gam, finege güre mogoi sinoyeaga. Baba nono, ninag gürenakuti maig igaingeregeaga. Nu Erekokai, nu fere Keriabüde nugeab ferefinabur maig igaingegib sugurweaga. ");
INSERT INTO urw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Babaure, nini nure menüm sibamgeregenan. Nono güre ude gamde korotaudi, bulmakau toib au fade gam kinimeagabereregen baba, nini kegewane.” ");
INSERT INTO urw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Keriabüb dora dugurewegi doragafotuwarbere, pirikanana Keriabüb fib nama gamnab dora dugurewegiwar epüra namana tataigüdi Keriabüb dora dugurewegi baba keab büren. Bangüdi Keriabüb yanim menüm siradgaberen, ");
INSERT INTO urw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Keriab kekia asau bürfaigeaga babab yanim siradgaberegi. Bangar kübüdim gamnab ferefinabur ninib kob dab fanam büreregeaga. Bangar Keriab ninure kob ebebearweaga.” ");
INSERT INTO urw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Keriabüb dora dugurewegiwar uriangüdi Keriabüb fib nama gam komafotuwen. Bana sipsip taugegi ferewar menüm wagen, “Bana, Betlehem kümüna baba daba taideaga baba kegewegi. Baba Erekokaide wasigeaganwaib.” ");
INSERT INTO urw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bana nini pirikanana kümüna Mariaie Josepküre büren baba kegewen, nono nu bulmakau toib au fade gam kinbüreaga. ");
INSERT INTO urw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nini kegeafotudi, Keriabüb dora dugurewegide nono babaure wangeaganwaib, baba daba dabab doraman pitoien. ");
INSERT INTO urw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bangar fere gürenakuti sipsip taugegi ferewarde doragen baba edüdi, babaure ututun toitoiwen. ");
INSERT INTO urw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Bangeagako, Maria nu dora baba gürenakuti nugeab kob gam difürüdi, utungüdi büreaga. ");
INSERT INTO urw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bangar sipsip taugegi ferewar maigüdi kümünad kümünadi, Keriabüb yanim siradgaberen. Nini daba daba gürenakuti edüdi kegewenwaib babaure, Keriabure ebebearwen. Daba daba Keriabüb dora dugurewegibüde wangeaga baba sibe taideaga. ");
INSERT INTO urw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Finege nono sinoyeaga baba, kunube gürena kenegarbere nonob mube sike katuwen, bangüdi yanim Jisas yanbawen. Anab sibim gam ara taidegi kene gamnana, Keriabüb dora dugurewegibüde yanim baba yanbafotuweaga. ");
INSERT INTO urw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Josepie Mariaküre Keriabüb ege gam, urun taidegi kabia daiwegi sese taideaga. Bangar Mosesüb kabiade wageaga sibe, nugeküre nono Erekokai abatarwebüre Jerusalem igaiudi kümünen. ");
INSERT INTO urw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nugeküre dora Erekokaib kabia gam menüm büreaga baba daiwebüregen, “Nono keman anade sinoyarba, baba mogoi toi Erekokai duwane.” ");
INSERT INTO urw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nugeküre Erekokaib kabia wageaga sibe, bai feregi ai toi tuguna düdi kümünen, “Manab akürede, imid sogub aküre.” ");
INSERT INTO urw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Baba sese gam fere güre Jerusalem büreaga, yanim nub Simeon. Nu kabia surur daiugab fere tugu, Keriabure kunube irugab fere. Nu Keriabüde Israel ferefinaburüngab kob dab fanam difürüngegi fere sugurwebüregeaga baba momoweaga. Bangar Etob Kedeb Simeon gam büreaga. ");
INSERT INTO urw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Etob Kedebüde pirika kumeregabgegüdi banüm wafotuweaganwaib. Nu Erekokaide fere güre sugurwar ogura nugeab ferefinabur maig igaingebüre dorageaganwaib baba fere kegeudie kumeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bangar nu Etob Kedebüde siradgaberar Keriabüb kedeb fatab gübroime iruweaga. Bangar Jisas nogub emeanade igaiudi oguredi, kabiade wageaga sibe nu gam kabia gebüre. ");
INSERT INTO urw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Bangar Simeonde düdi debetaweaga, bangüdi Keriabüb yanim menüm siradgabereaga, ");
INSERT INTO urw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Eregeam, ye nagüb saina mogoi, babaure na mügar euiab kümünai, bangar nag egime wagün sibe, kob yeb dab fanam büreregeaga. ");
INSERT INTO urw_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nag sin maig igaisigegi daba gün baba, igeab egede kegeafotun. ");
INSERT INTO urw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nag ferefinabur gürenakutingab ege gam baba ekotagabürün. ");
INSERT INTO urw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Baba meram nu fere gin adab gamnabwar meram dünügeregeaga. Bangar nagüb ferefinabur Israelwar yanim ere dünügeregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jisasüb emeana, nugeküre dora Simeonde nono gam dorageaga baba edüdi, nugeküre ututun toitoiwen. ");
INSERT INTO urw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Bangar Simeonde unun dünügüdi, nonob ana Maria menüm waweaga, “Edün. Nono meme Keriabüde sugurweaga. Babaure, nude gar Israelwar epüra nure kob kainanageregen tugu, epüra nure kob kainanageregedige. Nu bera güre sibe büreregeaga, bangar fere epürade nenweregen. ");
INSERT INTO urw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Babaure fere epüra ninib ututun iwagegi baba ekeba taideregeaga. Bangar nag tugu, keime asaude nagüb gama duwaiwegi sibe geregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kiari finege güre büreaga, nub yanim Ana. Nu Fanuelrüb momugo, Aserüb gingamnab. Nu gürenakuti abüdigeaga. Nu egime kam düdi kab küre mene nonob tugu büreaganwaib. ");
INSERT INTO urw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Bangarie kuri kab kumar uguna büreaga. Mügar nu kümdan 84 tugu. Ana nu Keriabüb kedeb fatab kudumege ebgadügafaigarge. Nu daba kudigafaigüdi sibdibüdi bürfaigeaga, nu Keriabüb fünai sida tugu utumnonou tugu güfaigeaga. ");
INSERT INTO urw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Baba sese gam, nu tugu nono iroto oguradi, Keriabure esegeaga. Bangüdi ferefinabur gürenakuti, Keriabüde Jerusalemwar maig igaingeregeaga baba dagowen gam, nono babab dora pitoiaga. ");
INSERT INTO urw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Erekokaib kabia wageaga sibe daba daba gürenakuti güfotuwen, bangafotudi nugengab fib ere Nasaret kümünen. Nasaret nu Galili distrik büreaga. ");
INSERT INTO urw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bangar nono nu adagüdi sogideaga. Nu sibam nama nama tugu, bangar Keriabüb nirara nu gam büreaga. ");
INSERT INTO urw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jisasüb emeana mene itut Jerusalem kümünafaigen. Bangüdi Keriabüde Israelwar Eungar Nama Büren Baba Dü Ere Utungegib kegewebüre kümünen. ");
INSERT INTO urw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisas nu mene gürena bede fogo aküre tugu kenegarbere, dü ere babab kabia daiudi Jerusalem kümünen. ");
INSERT INTO urw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kunube iruwegi dü ere ere babab fünai gürenakuti kenegarbere maigüdi fibigo kümünen. Bangeagako, omo mogoi Jisas nu Jerusalemnana büreaga, emeana nono bürdaiweaga baba sibamgedige. ");
INSERT INTO urw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nugeküre nono ferefinabur gürewar keab dag, urigeagagüdi banüm utungen. Bangüdi nugeküre kümünen baba, dü gürena kenegeaga. Bangar kuri nugeküre nugeab giniabmana kodigo tugu, nugeab büreabmana kodigo tugu fitaudi tuwen. ");
INSERT INTO urw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nugeküre fitakakawenko kegewedige. Bangar nugeküre fitawebüre maig maigüdi Jerusalem kümünen baba, dü aküre kenegeaga. ");
INSERT INTO urw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Dü küi gamie, nugeküre nono Keriabüb fatab gübroime büreaga baba kegewen. Nu sibam sarigegi ferewar kodigo gotogüdi büreaga. Bangüdi totongebürewadi dora ninib edüdi büreaga. ");
INSERT INTO urw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Fere simai nub dora eden baba, sibam nubure tugu nugengab dora maig nini gam toweaga baba tugu edüdi tergen. ");
INSERT INTO urw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nugeküre tugu nono kegeudi tergen. Bangar anade menüm waweaga, “Nono, na amure baba kabia sinaküre gam bangün? Igeab kob tugu emünüb kob tugu koigar fitanenan.” ");
INSERT INTO urw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Bangeagako, nugeküre gam dora menüm toweaga, “Ninaküre amure ye fitaienan? Ninaküre sibamgargedag, ye igeab Emügab fata gamnana büreregün?” ");
INSERT INTO urw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bangeagako, nugeküre dora babab iginim nugeküre gam dorageaga baba sibamgedige. ");
INSERT INTO urw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bana nu emeana keab maigüdi kümünadi Nasaret taiden. Nu bata bata emeanab sube daiwafaigeaga. Bangar nonob dora baba gürenakuti anade düdi nugeab kob gam difürüdi debetaudi büreaga. ");
INSERT INTO urw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Bangüdi Jisas adagar sibam nub nama fanam taideaga. Bangar Keriab nure kob ebebearwar, ferefinabur tugu, nure kob ebebearwen. ");
INSERT INTO urw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sisar Taiberius nu Romüb erekokayau mene gürena bede fogo taba tugu büreaga. Baba sese gam Pontius Pailat nu Judia distriküb kübüdim bera taugegi agferegi büreaga. Baba sese gam tugu Herot nu Galili distrik taugeaga. Owa Filip nu Ituria distrik tugu, Trakonitis tugu taugeaga. Bangar Lisanias nu Abilene distrik taugeaga. ");
INSERT INTO urw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Bangar Anasie Kaiafasküre, Keriabure kobegegi taba ferewar büren. Baba sese gam Jon, Sekaraiab nono nu, fib fere kene gam büreaga, bangar Keriabüde dora nugeab Jon düweaga. ");
INSERT INTO urw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Bangar Jon nu fib gürenakuti, Jordan yag iroto büren baba gam kümünadi, ferefinabur gürenakuti kob pirudi yag fidedi Keriabüde menmen nugengab unaigeregeagagüdi dora pitoiaga. ");
INSERT INTO urw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Baba daba kiari fere Aisaiab budi gam dora büreaga babanümnana taideaga, “Fib fere kene gam, fere gürede menüm yogeaga, ‘Erekokaib erekobo idabürügane. ");
INSERT INTO urw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gir ere ere yag güresari güresari büren baba, gürenakuti kurar kanüdi sagugeregeaga. Erekobo kuarig kuarig baba, idawedi surur taideregen. Erekobo toi kogkogi baba, idadau idabürügeregen. ");
INSERT INTO urw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bangar kübüdim gamnab ferefinabur gürenakuti, Keriabüde sige maig igaisigebüre fünaiweaga baba kegeweregen.’” ");
INSERT INTO urw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ferefinabur epüra Jonüb kube gam yag fidebüre oguren, bangar menüm wangeaga, “Nini matu kogib mogoi toi, Keriab ninure magirawar kiasorungeregeaga. Wonide wanügar Keriabüb magira emegerudi gusarawebüregenan, io? ");
INSERT INTO urw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nini kob kürüna piruwenangüdiba, bana kabia ninagüb baba kob piruwegib kabia sibe abatarganegeaga. Bangüdi ninag ninag ‘Abraham nu sinib oyebesigügüdi,’ banüm dorafokowagana. Ye wangün, Keriabüde gar kegenam toi meme Abrahamüb matanabmana sibe tataigeregen. ");
INSERT INTO urw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Man manage au bara gam büreaga, au gürenakuti nama idadau fürfaigedige baba, katudi keb gam fotutgedi kümüneregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ferefinabur Jonüb dora edüdi menüm totowen, “Sin arangeregenan?” ");
INSERT INTO urw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Bangar nini gam dora menüm toweaga, “Fere karün aküre tugu baba, karün güre fere karün kene baba düweregeaga. Fere daba tugudaka, kabia babanüm gürena geregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kegeam degi ferewar gürekoi, nini tugu yag fidebüre oguren. Bangüdi totowen, “Sibam sarigegi fere, sini arangeregenan?” ");
INSERT INTO urw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Bangar menüm wangeaga, “Nini kegeam kübüdim bera taugegi ferede wangeaga baba gürena dane, nini maig gürekoi buruwagana.” ");
INSERT INTO urw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Maraipapa gürekoi tugu totowen, “Be siniba arangeregenan?” Bangar menüm wangeaga, “Nini fere gürewar kogifürüngüdi kegeam ninib begagana. Kegeam ninib debüre nini gam dora kiougagana. Nini menüm utungane, mur ninagüb baba ninagüb gürena. Kegeam ninagüb denan baba ninagüb gürena, babaure nini maig begagana.” ");
INSERT INTO urw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ferefinabur baba daba daba tataigar kegeudi, nugengab kob siradar, menüm ututun toitoiwen, “Jon nu Keriabüde nugeab ferefinabur maig igaingegi fere sugurwebüregeaga baba feredag?” ");
INSERT INTO urw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Bangarbere Jonüde nini gam dora menüm toweaga, “Ye yag gürena fidüngafaigün. Bangeagako, kuri fere güre ogureregeaga baba, sogi nub yeb sogi emegerweaga. Muride kebe sagwegi nub wartauweaga baba, ye kuregegi sogi kene. Nude keb gamde tugu Etob Kedeb gamde tugu yag fidüngeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nu fere nugeab kube gamde gorogoro debetawegi sibe ogureregeaga, nugeab wit gam ina büreaga baba düfotuwebüre. Bangüdi wit nugeab baba wit fata gam tobugeregeaga. Bangeagako, ina toiba keb kumfaigarge baba gam füküraweregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon ferefinaburüngab kob debüre tugu dora güre güre epüra doragarge, baba kabia gamde nini gam dora nama pitoiaga. ");
INSERT INTO urw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Herot nu kübüdim bera taugegi agferegi büreaga. Jonüde Herot nunurweaga, amure Herotüde owab fia Herodias dar nunurweaga. Baba tugu, kabia kogi gürekoi geaga babaure tugu. ");
INSERT INTO urw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Bangar Herot nugeab menmen toi kekia, maig menmen güre korabereaga baba, maig Jon kuadüdi kakia gam difereaga. ");
INSERT INTO urw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ferefinabur gürenakuti yag fidegin sese gam, Jonüde Jisas tugu yag fiduweaga. Nu yag fidfotudi sibdibwa büreaga, bangar fib nama gamnab fubu taiboyeaga. ");
INSERT INTO urw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Bangar Etob Kedeb nuge gam musuweaga. Etob Kedeb ai güre manab gen baba sibe taidüdi, Jisas gam musuweaga baba kegewegin. Bangarbere Keriab fib nama gamde menüm yogeaga, “Na yeb Nono. Ye kürüna kob dünün. Bangüdi ye naure kob ebebearun.” ");
INSERT INTO urw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisas nu mene küi bede fogo banümde, nugeab fünai toadeaga. Bangar ferefinaburde nu Josepüb nonogüdi utungen. Josep nu Helib nono. ");
INSERT INTO urw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli nu Matatüb nono. Matat nu Livaib nono. Livai nu Melkib nono. Melki nu Janaib nono. Janai nu Josepüb nono. ");
INSERT INTO urw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep nu Matatiasüb nono. Matatias nu Amosüb nono. Amos nu Nahumüb nono. Nahum nu Eslib nono. Esli nu Nagaib nono. ");
INSERT INTO urw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai nu Matüb nono. Mat nu Matatiasüb nono. Matatias nu Semenüb nono. Semen nu Joseküb nono. Josek nu Jodab nono. ");
INSERT INTO urw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda nu Joananüb nono. Joanan nu Resab nono. Resa nu Serubabelrüb nono. Serubabel nu Sealtielrüb nono. Sealtiel nu Nerib nono. ");
INSERT INTO urw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri nu Melkib nono. Melki nu Adib nono. Adi nu Kosamüb nono. Kosam nu Elmadamüb nono. Elmadam nu Erüb nono. ");
INSERT INTO urw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er nu Josuab nono. Josua nu Elieserüb nono. Elieser nu Jorimüb nono. Jorim nu Matatüb nono. Matat nu Livaib nono. ");
INSERT INTO urw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai nu Simeonüb nono. Simeon nu Judab nono. Juda nu Josepüb nono. Josep nu Jonamüb nono. Jonam nu Eliakimüb nono. ");
INSERT INTO urw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim nu Meleab nono. Melea nu Menab nono. Mena nu Matatab nono. Matata nu Natanüb nono. Natan nu Devitüb nono. ");
INSERT INTO urw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit nu Jesib nono. Jesi nu Obetüb nono. Obet nu Boasüb nono. Boas nu Salmonüb nono. Salmon nu Nasonüb nono. ");
INSERT INTO urw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason nu Aminadapüb nono. Aminadap nu Atminüb nono. Atmin nu Arnib nono. Arni nu Hesronüb nono. Hesron nu Peresüb nono. Peres nu Judab nono. ");
INSERT INTO urw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda nu Jekopüb nono. Jekop nu Aisaküb nono. Aisak nu Abrahamüb nono. Abraham nu Terab nono. Tera nu Nahorüb nono. ");
INSERT INTO urw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor nu Seruküb nono. Seruk nu Reub nono. Reu nu Peleküb nono. Pelek nu Eberüb nono. Eber nu Selab nono. ");
INSERT INTO urw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela nu Kainanüb nono. Kainan nu Arpaksatüb nono. Arpaksat nu Siemüb nono. Siem nu Noab nono. Noa nu Lameküb nono. ");
INSERT INTO urw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek nu Metuselab nono. Metusela nu Enoküb nono. Enok nu Jaretüb nono. Jaret nu Mahalalelrüb nono. Mahalalel nu Kenanüb nono. ");
INSERT INTO urw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan nu Enosüb nono. Enos nu Setüb nono. Set nu Adamüb nono. Adam nu Keriabüb nono. ");
INSERT INTO urw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Etob Kedeb Jisas korobaweaga. Bangar Jisas Jordan yag ebgadüdi maigeaga. Bangar Etob Kedebüde igaiudi fib fere kene gam kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jisas fib fere kene gam dü dogob tugu bede fogo bürarbere Satande fururfururgeaga. Baba sese gam Jisas daba nargegar ogunoweaga. ");
INSERT INTO urw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Bangar Satande menüm waweaga, “Na kürüna Keriabüb Nono garba, bana doragab kegenam meme bret pirudi taideregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Bangeagako, Jisasde dora nub maig menüm toweaga, “Keriabüb budi gam dora menüm tugu, ‘Ferefinabur dabade gürena omo bürüreregedige.’” ");
INSERT INTO urw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Bana bangar Satande igaiudi komeaga, bangüdi pirikanana meme kübüdim gamnab kantri sogsogi gürenakuti baba, Jisas abataruweaga. ");
INSERT INTO urw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Bangar Satande menüm waweaga, “Kantri gürenakuti meme taugegib sogi dünür na yanim erekokai tugugeregün. Meme daba daba gürenakuti nini yeb gürena, babaure, ye fere güre duwebüregüdiba, ye duweregün. ");
INSERT INTO urw_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Na yeure oksosob orudi kunube iruwaba, ye meme daba daba gürenakuti düneregün.” ");
INSERT INTO urw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Bangeagako, Jisasde dora nub maig menüm toweaga, “Keriabüb budi gam dora menüm tugu, ‘Na Keriabure gürena kunube iruwe, nagüb Erekokai. Bangüdi nugeab fünai gürena de.’” ");
INSERT INTO urw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Bangar Satande Jisas Jerusalem igaiudi kümünadi Keriabüb kedeb fata gam kekia asau difereaga. Bangüdi menüm waweaga, “Na kürüna Keriabüb Nono garba, na paderudi kane. ");
INSERT INTO urw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Amure, Keriabüb budi gam dora menüm tugu, ‘Nuge nugeab dora dugurewegi toi wanügar idadau tauneregen. ");
INSERT INTO urw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Bangüdi, nugengab kubede ebnoneregen, amure, kegenam gürede kebe nagüb duwaiweregeaga babaure.’” ");
INSERT INTO urw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Bangar Jisasde dora nub maig menüm toweaga, “Keriabüb budi gam dora menüm tugu, ‘Na Keriabüb sogi fururegena, nagüb Erekokai.’” ");
INSERT INTO urw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satande Jisas furu adab adab fururugafotudi, Jisas uriaudi kümüna güre sese momoweaga. ");
INSERT INTO urw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jisas, Etob Kedebüb sogi gamde, Galili distrik maigüdi kümüneaga. Bangar ferefinabur Galiliyaub distrik itut büren baba, Jisas ogura Galili distrik büreaga gen baba dora eden. ");
INSERT INTO urw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nu ferefinabur nugengab kunube fata gam dora sabüngegi bata. Bangar ferefinabur nub yanim siradgaberen. ");
INSERT INTO urw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisas Nasaret kümüneaga. Nu fara sese baba fib ere gam bürüdi adageaganwaib. Nuge bata bata güfaigeaga sibe, Dü Kaberegi gam, kunube fata gam iruweaga. Keriabüb dora ninaiebüre biboweaga. ");
INSERT INTO urw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bangar kiari fere Aisaiab budi duwedi fügaidi fitaudi, dora menüm tugu büreaga baba kaiweaga, ");
INSERT INTO urw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Erekokaide uruaiaga, bangüdi yeb taba gam wel kubeiaga. Bangar nugeab Etob ogura ye gam büreaga. Amure, Erekokai nugede nugeab dora nama meme düdi, kümüna kogiwab ferewar dünügebüregüdi ye gam bangeaga. Bangüdi ferewar kakia gam büren baba, dora fotur kakia ebgadüdi uguna kümünebüregüdi, suguryar oguran. Baba tugu fere ege gomowar baba gam dora fotur maig agügeregen. Ferewar gürewarde febangüdi kogifürüngen, baba ferewarüngab kob darab, kenegafotuwebüregüdi suguriaga. ");
INSERT INTO urw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Bangüdi menüm dora fotuwebüregüdi suguriaga, Erekokai nugeab ferefinabur namabürüngegi sese manage taideaga.” ");
INSERT INTO urw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisas budi tabagafotudi fere budi toi taugugab baba maig duabürüdi gotogeaga. Bangar ferefinabur kunube fata gam büren baba, Jisas gürena kegenanawen. ");
INSERT INTO urw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Bana bangar menüm wangeaga, “Keriabüb budi memeb dora ninag edfotuwenan baba, mügarnana kürüna taideaga.” ");
INSERT INTO urw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bangar nub yanim siradgabürüdi dora nama pitoiaga babaure ututun toitoiwen. Bangeagako, wagen, “Sige sibam, fere meme nu Josepüb nono. Aranüm gar nu dora babanüm gebeaga?” ");
INSERT INTO urw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Bangedi Jisasde menüm wangeaga, “Nini ferefinaburde doragafaigen baba düdi ye gam pitoiagade? ‘Kaufere, na nagüb mube namabere.’ Bangar nini wageregenan, ‘Nag daba daba Kaperneam gün baba sin edfotuwenan. Bana mügar na daba daba babanüm gürena nagüb fib mudimere gam meag bange.’” ");
INSERT INTO urw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Bangar wageaga, “Ye kainana wangün, kiari fere güre nugeab fib mudimere gamnab fere simai, nub dora edfaigedige. ");
INSERT INTO urw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ye dora kainana wangün, Elaijab sese gam, oyemadi finabur epüra Israel büren. Baba sese gam kaikere sese. Baba kaikere sese, kümdan küi, edina kubete tugu büreaga. Bangar oguno erekokai baba kantri gam taideaga. ");
INSERT INTO urw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Bangeagako, Keriabüde Elaija sugurwar Israelwarüngab oyemadi finege güre gam, kümünarge. Nu fib ere Sarefat gen baba gam gürena sugurwar kümüneaga. Sarefat nu Saidonüb fib ere yau büreaga. Baba fib ere gamnab oyemadi finege güre gam sugurwar kümüneaga. Baba oyemadi finege nu Israelübge. Bangeagako, Keriabüde Elaija sugurwar nu gam kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Baba tugu, kiari fere Elisab sese gam, fere epüra Israel büren baba, nini lepra subo tutug. Bangeagako, nin kodigo, fere güre subo kenegarge. Naman kantri Siriab, nu nugenakuanab subo kenegeaga. Naman nu Israelübge. Bangeagako, Keriabüde Elisa sugurwar nu gam kümüneaga.” ");
INSERT INTO urw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Israel ferewar gürenakuti kunube fata gam büren baba, dora baba edüdi magirangeaga. ");
INSERT INTO urw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bangar Jisas kudewedi fib ere obgoira kaneaga. Baba fib ere ninib baba, girtorub güre gam büreaga. Bangar fib kogi güre, baba torub gamnana büreaga baba, Jisas fotuwedi kanebüregüdi igaiudi komen. ");
INSERT INTO urw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bangeagako, nu ninag kodigo kümünadi, uriangüdi kümünafotuweaga. ");
INSERT INTO urw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Bana Jisas Nasaret ebgadüdi, Kaperneam kanüdi, bag büreaga. Baba fib aküre Galili distriküb fib toi. Bangüdi Dü Kaberegi itut ferefinabur sabüngafaigeaga. ");
INSERT INTO urw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bangar dora nub edüdi tergen, amure, nu fere yanim tugubüde sabüngegi sibe. ");
INSERT INTO urw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Gürena sese, fere güre kunube fata gam büreaga baba, nu etob kogi tugu. Bangar erenana magaudire mengeaga, ");
INSERT INTO urw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aio, Jisas Nasaretüb, na sin gam am bangebüre oguran? Na sin kogifurusigebüre ogurandag? Ye na sibam. Na fere nama, Keriab nuge gamde oguran.” ");
INSERT INTO urw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Bangeagako, Jisasde etob kogi baba nunurudi menüm waweaga, “Na sube gütubenau fere baba ebgade.” Bangar etob kogi babade gar fere baba ninag kodigo kübüdim gam fürügeaga, bangar kurie, etob kogide uriaweaga, bangüdi kogifuruwarge. ");
INSERT INTO urw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bangar ferefinabur gürenakuti tergüdi, ninag ninag menüm doragen, “Mogoisob, dora meme aranüm? Nu fere yanim tugu, sogi tugude sibe etob kogi toi dora dünügeaga. Bangar nini dora nub edfaigüdi, fere uriaudi kümünafaigen.” ");
INSERT INTO urw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bangar Jisasde daba daba geaga babab doraman toi saraudi distrik babab fib itut kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas kunube fata baba ebgadüdi, Saimonüb fata gam iruwaboweaga. Saimon fiab ana nu subo tugu gar, mube nub füg füg büreaga. Bangar Jisas wawedi saguwebüre. ");
INSERT INTO urw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Bana Jisas kümüna iroto biboudi, subo finege baba gam, subode ebgafotuwebüregüdi, sogsogi dorageaga. Bangar finege baba subo kenegar, pirikanana siradüdi daba saigüdi dünügeaga. ");
INSERT INTO urw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Sida kanebüregeaga gam, fere simai nugengab büreanügmana subo tutug baba igaingüdi Jisas gam oguren. Bangar baba ferefinabur gürena gürena gam nugeab kube, kekia difürügar gürenakuti nama namawen. ");
INSERT INTO urw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nude gar etob kogi toi ferefinabur epüra ebgagaingen. Etob kogi toi ferefinabur uriangen sese gam, menüm yagfaigen, “Na Keriabüb Nono.” Bangeagako, nunurungüdi dorafokoure tugu tageibürüngeaga, amure, nini sibam, nu fere Keriabüde nugeab ferefinabur maig igaingegib fere uruageaga baba dogo. ");
INSERT INTO urw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jisas fitunana fib ere ebgadüdi, adab, fib fere kene gam bag kümüneaga. Bangar ferefinaburde fitawen, kegewen sese gam, uriangüdi kümüneregeagagüdi tageiburuwebüregen. ");
INSERT INTO urw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bangeagako, menüm wangeaga, “Ye fib ere gürekoi gam tugu Keriabüb Korobab dora nama pitoyeregün. Ye Keriabüde baba fünai gebüre suguryar oguran.” ");
INSERT INTO urw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Bangüdi Judia distrik kümüna urigüdi, kunube fata gagam dora pitoiaga. ");
INSERT INTO urw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gürena sese Jisas yag nigu Genesaretüb udi gam biboudi büreaga, bangar ferefinabur epüra Keriabüb dora edebüre nu gam girsa girsa ogura koiwataudi biboudi büren. ");
INSERT INTO urw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Bangar Jisas oude aküre yag nigub udi gam büreaga baba kegeweaga, oude toi baba, wade dügab ferengab. Bangeagako, baba fere toi oude ebgadüdi wade dügab far toi gasa büren. ");
INSERT INTO urw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Bana Jisas oude güre gam ebedeaga, oude baba Saimonüb. Bangüdi Saimon wawar oude gam ebedüdi oude sororowar yag nigu gam kümünaureregeaga. Bangar Jisas oude gam gotogüdi ferefinabur sabüngeaga. ");
INSERT INTO urw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bangafotudi, kuri Saimon menüm waweaga, “Oude orab yag kodigo kümünadi wade debüre wadeb far toi fobotgar kano.” ");
INSERT INTO urw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Bangar Saimonde menüm wageaga, “Eregeam, sin utumnonou bikide gugub dügar subaitausigeagako, wade güre düdarge. Bangeagako, nab sube daiudi wade dügab far toi fotutgeregenan.” ");
INSERT INTO urw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nini bangen babade, wade toi epüra kiregedi wadeb far toi kitkatwebüregen. ");
INSERT INTO urw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bangarbere epeianügmana oude güre gam büren baba, buburengedi oguradi sagüngebüre. Bangar nini ogura wade düdi, oude aküre gobaberen. Bangar oude aküre baba gobudi, yag minigo kanebüregen. ");
INSERT INTO urw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Bangar Saimon Pita wade toi kiregen baba kegeudi tergeaga. Saimonüb epeiabmana, Jemsie Jonküre tugu büren. Nugeküre Sebedib mogoi toi, nugeküre tugu tergen. Bangar epeiabmana tugu tergen. Saimon Pita baba kegeudi, Jisasüb kebe iroto oksosob orudi wageaga, “Erekokai, na ye uriaidi kümüne. Ye menmen fere.” Bangeagako, Jisasde Saimon menüm waweaga, “Kimigegena. Mügar na wade dünko kuriba, na ferefinabur kürengüdi ige gam ogureregün.” ");
INSERT INTO urw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bana oude orudi kümüna merai taidüdi, nugengab daba daba gürenakuti ebgagaiwafotudi, Jisas daiwen. ");
INSERT INTO urw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Gürena sese Jisas fib ere güre gam büreaga, baba fib ere gam fere güre tugu büreaga, mube nub gam lepra subo edi ginginuaboudi büreaga. Nu Jisas kegeudi oksosob orudi nurmaga kübüdim gam difürüdi, Jisas menüm waweaga, “Eregeam, na mednarba na ye idaiab Keriabüb ege gam nama taidüi.” ");
INSERT INTO urw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Bangar Jisasde baba fere gam kube difürüdi menüm waweaga, “Ye mediaga babaure, na idanür Keriabüb ege gam, na namaweregün.” Bangar lepra subo pirikanana fere baba ebgadar namaweaga. ");
INSERT INTO urw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Bangar Jisasde dora sogsogi menüm waweaga, “Meme daba na gam taideaga baba, fere güre wawegena, kedeb. Moses wageaga baba sibe, na kümüna kobegegi fere gam mube nagüb abatarue. Bangüdi nag namaun baba abatargebüre bai fere, amure, subo nagüb kenegeaga baba, fere sibamgeregen.” ");
INSERT INTO urw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Bangeagako, Jisas daba daba geaga babab doraman baba iwagarge, tün nub siradeaga. Bangar ferefinabur epüra dora nub edebüre oguren. Baba tugu, nude ferefinabur subo tutug baba namabürüngebüre güdi oguren. ");
INSERT INTO urw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bangeagako, güre sese sibdibwafaigebüre ferefinabur uriangafaigüdi, fib fere kene gam kümünafaigeaga. ");
INSERT INTO urw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Dü güre gam Jisas ferefinabur sarigabürünga büreaga, Farisiwar tugu kabiab sibam sarigegiwar tugu gotogüdi büren. Nini Jerusalemüb fib ere gamnabwar oguren, Galili distriküb fib toi gürenakutib gamnabwar tugu oguren, Judia distriküb fib toi gürenakutib gamnabwar tugu oguren. Bangar Erekokaib sogi Jisas gam bürar, subo ferefinabur idangeaga. ");
INSERT INTO urw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bangar fere gürekoi fere güre kemeidi oguren. Fere babab dagar toi gürenakuti kumar kur güre gam kinbüreaga. Bangar kemeidi fatagoime kümüna Jisas iroto diferebüregen, ");
INSERT INTO urw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","bangeagako, ferefinabur epürafanam büredigegar fib gütügeaga, bangar subo fere kemeidi iruwegi erekobo, kene. Bangar bere fata Jisas büreaga baba fata tor gam komen. Bangüdi fata tor güresari gogafotudi, kur fere kineaga baba, muride warüdi diferedi dab dab kanüdi, ferefinabur kodigo, Jisasüb nurmaga iroto diferedi büreaga. ");
INSERT INTO urw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisas kegengeaga baba kürüna kob kainanagen, bangar wageaga, “Mai, ye nab menmen gürenakuti kenegafotun.” ");
INSERT INTO urw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kabiab sibam ferewar tugu Farisiwar tugu dora baba edüdi menüm dorafokowen, “Fere meme nu wongar Keriabüb kur debürewadi dora baba dorageaga? Fere gürede menmen unaigafotuweregarge. Baba Keriab nugenakuanab fünai.” ");
INSERT INTO urw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisas ninib ututun sibamgafotüdi, maig nin gam dora menüm toweaga, “Amure ninib kob gam ututun babanüm büreaga? ");
INSERT INTO urw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Am dora ye doragegi diruge? Ye menüm doragegi diruge, ‘Ye nab menmen toi gürenakuti unaigafotun,’ o ye menüm doragegi diruge, ‘Na siradibe urige’? ");
INSERT INTO urw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bangeagako, yeb utun baba nini menüm sibamgane, Fereb Nono nu, meme kübüdim gam sogi tugu, bangar nu menmen toi unaigafotugeregeaga.” Bana Jisas fere dagar gürenakuti kumeaga baba gam agügüdi menüm waweaga, “Ye wanün, na siradibe kur nagüb dibe, fata nagüb gam kümüne.” ");
INSERT INTO urw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Bangar ferefinaburüngab ege gam, fere baba pirikanana siradüdi, kur nuge kineaga baba deaga. Bangüdi Keriabüb yanim siradgabürübina fata nugeab gam kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bangar ferefinabur gürenakuti baba daba kegeudi tergen. Bangar Keriabüb sogi ere baba kegewebüre, kob nugengab siradeaga. Bangar Keriabüb yanim siradgabürüdi menüm wagen, “Mügar sige daba kegeugabge baba daba daba taidar kegewenan.” ");
INSERT INTO urw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kuri Jisas urigüdi kümüna kegenam degi fere güre kegenam debegegi fata gam gotogüdi büreaga baba kegeweaga. Fere babab yanim Livai. Bangar Jisasde menüm waweaga, “Na ogura ye daie.” ");
INSERT INTO urw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Bangar Livai daba daba gürenakuti ebgadüdi, kümüna Jisas daiweaga. ");
INSERT INTO urw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Bana Livai nugeab fata gam Jisasure kobe erekokai kobegeaga. Kegenam degi ferewar epürage tugu ugu ferewar tugu nugeküre keab gotogüdi daba nen. ");
INSERT INTO urw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bangar Farisiwar tugu nugengab kabiab sibam ferewar tugu, Jisasüb daidaiwegi toiure dorafokowen. Menüm wagen, “Nini, amure kegeam degi ferewarie, menmen fere gürekoi keab daba tugu, yag tugu nüfaigenan?” ");
INSERT INTO urw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Bangar Jisasde dora ninib maig menüm toweaga, “Fere subo kene nini, kau fere gam kümünafaigedige. Fere subo tugu gürena kau fere gam kümünafaigen. ");
INSERT INTO urw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Banüm gürena, ye fere nama yagüngür kob piruwebüre ogurarge. Ye menmengeg ferewar yagüngür kob piruwebüre oguran.” ");
INSERT INTO urw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bangar ferewar Jisas menüm wawen, “Güre sese Jonüb daidaiwegi toi daba kudigafaigüdi sibdibwafaigen. Bangar Farisiwarüngab daidaigegi toi tugu bangafaigen. Bangeagako, nab daidaigegi toi nini daba, yag nüdaiwen.” ");
INSERT INTO urw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Bangar Jisasde menüm wangeaga, “Fere güre finege debüregarba, fere baba nugeab büreabmana kiab bürarbere, nini büreabmana wanügar daba kudigeben de? Kene. ");
INSERT INTO urw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bangeagako, kuri fere baba igaiudi kümünafotuwen, bangar büreabmana kiab bürarge, baba sese gamba, nini daba kudigeregen.” ");
INSERT INTO urw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jisas komina dora güre tugu dünügeaga. Menüm wageaga, “Karün güre egimengab aigo tugu garba, ferede karün omo güre dibüragüdi karün egimengab giwafaigarge. Nu bangüdiba, karün omo baba kogifuruweregeaga, baba tugu karün mara omo baba, karün egimengab sibe taideregarge. ");
INSERT INTO urw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Fere dür sike egimengab gamde wain omob mum kunfaigedige. Nu bangüdiba, wain omob mumüde dür sike pusuafotuwar wain kübüdim gam edogeregeaga. Bangar dür sike tugu koigeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Babaure, dür sike omo gamde wain omob mum kunfaigen. ");
INSERT INTO urw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Bangar fere nu wain mum egimengab niaganwaib baba, nu menüm wagfaigeaga, ‘Ye wain omob mum nimeiafaigarge. Egimengab baba nama.’” ");
INSERT INTO urw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Dü Kaberegi güre gam Jisas wit küm toi kodigo urigeaga. Bangar nugeab daidaiwegi toi wit magmagib sike dufotugebüre kubeag noa noagüdi nüdaiwen. ");
INSERT INTO urw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bangeagako, Farisi gürekoi baba kegeudi menüm wagen, “Dü Kaberegi gam baba kabia gegi kedeb, babaure nini amure bangenan?” ");
INSERT INTO urw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Bangar Jisasde dora ninib maig menüm toweaga, “Devitüde daba geaga babab doraman nini ninaiargedag? Baba sese gam nuge, nugeab büreabmana keab ogunongeagagüdi wagün. ");
INSERT INTO urw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bangar Devit Keriabüb sel fata gam iruwaboudi, Keriabüb nurmaga gam bret difürüfaigen baba deaga. Bret baba kedeb babaure, Keriabüb kobegegi ferewar gürena neregen. Bangeagako, Devit nu neaga, bangüdi nugeab büreabmana tugu dünügeaga. Dora baba ninaiargede?” ");
INSERT INTO urw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Bangar Jisasde namana menüm wangeaga, “Fereb Nono nu Dü Kaberegi taugeaga.” ");
INSERT INTO urw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Dü Kaberegi güre gam Jisas kunube fata gam iruwaboudi ferefinabur dora dünügeaga. Baba gam fere güre büreaga, nub kube namayaub kumudi fananamgeaga. ");
INSERT INTO urw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kabiab sibam ferewar tugu Farisiwar keab Jisas idadau taugen, amure, Dü Kaberegi gam fere subo tutug baba idadangebeagade, kenedag baba sibamgebüregen. Jisas dora gam diferebüre, erekobo fitawebüregen. ");
INSERT INTO urw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Bangeagako, Jisas ninib ututun sibamgeaga. Babaure fere kube kogi baba menüm waweaga, “Na siradibe ferengab ege gam meag biboue.” Bangar baba fere siradüdi biboyeaga. ");
INSERT INTO urw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Bangar Jisasde menüm wangeaga, “Ye totongebüregün. Dü Kaberegi gam kabia nama gegide, ede kabia kogi gegide? Fere sagüngüdar nama bürebende, ede kogifürüngegide?” ");
INSERT INTO urw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Bangar Jisas fere gürenakuti gam agügübina kümünadi fere baba menüm waweaga, “Kube nagüb sururgabere.” Fere baba bangeaga babade, kube nugeab maig namaweaga. ");
INSERT INTO urw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bangeagako, kabiab sibam ferewar tugu Farisiwar tugu magirangar nuge nuge menüm wagen, “Jisas gam am bangegi?” ");
INSERT INTO urw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Bana baba sese Jisas sibdibwebüregeaga, bangüdi gir güre gam komadi Keriabure utumnonou sibdibweaga. Baba utumnonou sibdibwa bürar kümüna subaiboiaga. ");
INSERT INTO urw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Sida taideaga, bangar nugeab daidaiwegi toi yagüngar oguren. Bangüdi gürena bede fogo aküre uruangeaga. Bangafotudi Jisasde wageaga, “Nini yeb dora turewegi ferewar.” ");
INSERT INTO urw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Güre baba Saimon, bangar nu Jisasde yanim Pita duweaga. Bangüdi Andru tugu uruageaga, nu Saimonüb mebe, babade Jems babade Jon babade Filip babade Bartolomyu. ");
INSERT INTO urw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Babade Matyu babade Tomas babade Jems, nu Alfiusüb nono, babade Saimon, nu Selot simaingab gingamnab, ");
INSERT INTO urw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Babade Judas, nu Jemsüb nono, babade Judas Iskariot, kuri baba ferede Jisas nugeab karau kube gam difereregeaga. ");
INSERT INTO urw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Bana Jisas nugeab daidaiwegi simai keab gir gamde kanen. Bangüdi nu kümüna kübüdim güre surur fanam gam nugeab daidaiwegi gin ere simai keab biboudi büreaga. Ferefinabur epüra fanamge. Judia distriküb fib toib ferefinabur oguren, fib ere Jerusalemüb ferefinabur tugu oguren, saugu güre Tair fib ereie Saidonküre kodigo büreaga baba gamnabwar, nini tugu komen. ");
INSERT INTO urw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nini nugeab dora edebüre oguren, bangüdi nude subo nugengab namabürüngeregeagagüdi oguren. Bangar ferefinabur etob kogide kogifürüngeaga baba, Jisasde etob kogi baba ferefinabur gam dufotugeaga. ");
INSERT INTO urw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bangar ferefinabur gürenakuti nu gam kube diferebüregen, amure, sogi erekokai nu gam büreaga, baba sogide, ferefinabur nu gam kube diferen baba, namabürüngafaigeaga. ");
INSERT INTO urw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Bana Jisas nugeab daidaiwegi simai gam agügüdi menüm wageaga, “Nin kogiwab ferewar, nini ebebearwane. Keriabüb Koroba baba ninagüngab. ");
INSERT INTO urw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Mügar nin oguno bürenanwar nin ebebearwane. Kuri nini daba fugongeregeaga. “Nini mügar mürbürenan, nini ebebearwane. Kuri nini kuigeregenan. ");
INSERT INTO urw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Kuri nini Fereb Nono daiwar fere simai nini kegengüdi, kob kürüna koigeregen. Bangüdi ninide ninag kudengüdi nenüngeregen. Bangüdi ninide, ninagüngab yanim kegeweregen baba, daba güre kürüna kogi sibe. Bangar baba sese gam daba daba gürenakuti taidarba, nini ebebearwane. ");
INSERT INTO urw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bangar baba kabia nini gam gediba, bana nini ebebearubenar mermerwane. Edane. Fib nama gam mur erekokai dagongüdi büreaga. Egime nugengab matananügmanade kabia baba sigena kiari ferewar gam güfaigen. ");
INSERT INTO urw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Bana nini kegeam ere tutugub fere simai, nini dabnana nini nagüngab kob namaberegi daba daba kiregafotuwenan. ");
INSERT INTO urw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Nini mügar daba nar fugongafaigeaga simai, nini dabnana, kuri nini ogunongeregeaga. “Nini mügar kuigafaigenan simai, nini dabnana kuri baba nini merar agugur nagüngab ege gamde edogeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Bana fere gürenakuti ninib yanim siradgaberediba, bana nini dabnana. Egime nugengab matananügmana kabia baba sibenana kiou kiari ferewar gam güfaigen.” ");
INSERT INTO urw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jisas namana menüm wageaga, “Ferewar nini dora yeb edfaigenan baba wangün, nini ninagüngab karauyanügmana kob dünügane. Bangüdi ferewar ninagure kob koigafaigen babawar gam, kabia nama gane. ");
INSERT INTO urw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Fere gürekoide Keriab nini kogi fürüngeregeagagüdi banüm doragediba, nini baba simai namabürüngebüre Keriab totowane. Bangüdi ferewar ninag kogifürüngen baba, sibdibwar Keriabüde nirarangeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bana fere gürede suagamaranarba, suagab güresari tugu piruab nu gam kümüno. Fere güre karün nab buruwarba, enegi nagüb tuguna ebgafotuwab do. ");
INSERT INTO urw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Fere gürenakuti daba daba sigegüdi totonediba, dünüge. Bana fere gürede daba daba nab kiregarba, nude maig nag dünebüregüdi ere doragegena. ");
INSERT INTO urw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kabia gürenakuti ferefinabur ninag gam gebüregüdi güfaigenan, baba kabia gürena ninide maig gürewar gam gane. ");
INSERT INTO urw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Bana nini fere ninagure güfaigen babawar gürena kob dünügüdiba, Keriabüde yanim ninib siradgabereregarge. Menmen gügab fere simai nini tugu, kabia babanüm gürena güfaigen, fere ninagure güfaigen babawar gürena, kob dünügafaigen. ");
INSERT INTO urw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Bana ferewar kabia nama ninag gam güfaigen, baba kabianana baba ferewar gam maig toudiba, Keriabüde yanim ninib siradgabereregarge. Babanüm gürena, menmen gügab fere simai tugu, ferewarde kabia nama ninag gam güfaigen baba, maig tofaigen. ");
INSERT INTO urw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Bana nini nagüngab utunde, fere simai daba daba maig toweregengüdi, baba fere simai gürena daba daba dünügüdiba, Keriabüde yanim ninib siradgabereregarge. Menmen gügab fere simai tugu, nini fere menmen gügab fere simai gürena daba daba dünügafaigen. Baba amure, nini sibam, baba fere simai nugengab daba daba maig toweregen. ");
INSERT INTO urw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bangeagako, nini ninagüngab karauyanügmana kob dünügafaigane. Nini baba simai gam kabia nama gane. Nini fere simai ninag gam daba daba maig toweregedigegüdi utungenan baba simai, daba daba dünügane. Nini bangüdiba, kuri nini mur erekokai tugu. Bangar nini Keriab Kekia Asaub nono büreregenan. Nu fere simai nugeure esegüfaigedige gam tugu, fere kogi simai gam tugu kabia nama güfaigeaga. ");
INSERT INTO urw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nini fere simai korarabüngane, Keriabüde ninagure kororabgafaigeaga sibe.” ");
INSERT INTO urw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jisasde namana menüm wageaga, “Nini gürekoingab kabia nanaudi nini fere kogi gagana. Keriabüde kabia baba sibenana ninag gam tugu geregeaga. Nini ferengab menmen unaigane, bangar Keriabüde ninagüngab menmen unaigeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nini daba daba gürewar dünügane, bangar Keriabüde daba daba ninag dünügeregeaga. Nu ninag gam nama nama namana kabatangeregeaga, bangüdi gobabereregeaga, bangüdi büraiar kanüdi, namana gobabereregeaga. Bangar daba daba kürüna edogeregeaga, bangüdi ninag dünügeregeaga. Ninagüde aranümdag fere gürekoi dünügawaigenan, baba sibenana, Keriabüde ninag gam maigabürüngeregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jisasde komina dora güre tugu menüm dünügeaga, “Ege gomo gürede ege gomo güre erekobo abatarwebeagade? Kene. Nugekürenana ub gam fürügeregen. ");
INSERT INTO urw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sibam degi mogoide nugeab sibam sarigegi fere emegerwarge. Bangeagako, nu idadau sibam düdi kenegafotudiba, baba sese gam, nu nugeab sibam sarigegi fere sibenana taideregeaga. ");
INSERT INTO urw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Amure büreyanüb ege gam nom fanamere büreaga baba kegeun, bangeagako nagüb ege gam au mara ere baba büreaga baba utungabge? ");
INSERT INTO urw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nagüb ege gam au mara ere büreaga baba kegewabgegarba, bana aranüm büreyan wawege, ‘Mai, ye nab ege gam nom büreaga baba düfotuwebüregün gege’? Na kioutuka fere, nagüb ege gam au mara ere büreaga baba düfotubeie. Bangüdie nag idadau agügüdi, büreyanüb ege gam nom fanamere büreaga baba düfotuwe.” ");
INSERT INTO urw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jisas namana menüm wageaga, “Au nama nu nama kogi fürfaigarge. Baba sibe au kogi nu nama nama fürfaigarge. ");
INSERT INTO urw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Fere au nama ferar kegefaigüdie, au namade kogi baba sibamgeregen. Fere simai nini muri dumegi tugu gam kümüna au kurabüb magi düfaigedige. Baba tugu au fanamere kogi dumegi tugu gam wain murib magi düfaigedige. ");
INSERT INTO urw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Fere nama nu, ututun nama epüra fanam nub kob gam büreaga. Bangar nu kabia nama güfaigeaga. Fere kogi nu ututun kogi epüra nub kob gam bürarge. Bangar nu kabia kogi güfaigeaga. Babanüm ututun kob nub gam gobeaga baba, subede pitaifaigeaga.” ");
INSERT INTO urw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jisas namana menüm wageaga, “Nini ye yanbaidi ‘Erekokai, Erekokai,’ güfaigenanko, amure yeb dora daiwarge? ");
INSERT INTO urw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Fere güre ye gam oguradi dora yeb edüdi daiwarba, bana ye fere babanümüb kabiaure wangeregün. ");
INSERT INTO urw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Baba fere nu fere güre fata idawebüregegi sibe. Nu ub kese kureregeaga, bangüdie kagu diferar kaneregeaga. Bangüdi kübüdim biar kanüdi kagu sogigabereregeaga. Bangüdie baba kekia fata fereregeaga. Bangar kuiai sese taidar yagüde fata baba esuwar, fata suruweregarge. Amure, fere baba nu fata nama sogi fereaga. ");
INSERT INTO urw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Bangeagako fere yeb dora edüdi daiwarge baba, nu fere güre fata udi gam tuaberegi sibe. Babaure kuri yagüde fata baba esuwarba, pirikanana surudi kürüna koigeregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas ferefinabur gam dora pitaifotudi, kümüna Kaperneam fib ere gam taideaga. ");
INSERT INTO urw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Maraipapangab taugegi güre büreaga, nu sarua mogoi güre tugu. Nu nugeab sarua mogoi baba idadau kob duwafaigeagako, mügar baba sarua mogoi nu subo tugu, bangar kumebürenanageaga. ");
INSERT INTO urw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Maraipapangab taugegi, Jisas büreagagegi dora edeaga, bangar nu Judawarüngab taba fere simai sugurungar kümüna totowedi ogura nugeab sarua mogoib subo namaberebüregüdi sugurungeaga. ");
INSERT INTO urw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bana nini kümüna Jisas gam taidüdi, marbinab gamde kororab dora menüm wawen, “Baba taugegi nu fere nama, na nu saguwegi nama. ");
INSERT INTO urw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nu sige Juda simai kob sigafaigeaga. Nugede sinib kunube fata idaweaga.” ");
INSERT INTO urw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Bana Jisas nini keab kümüneaga. Nu kümüna fata gam iroto taidarbere, baba maraipapangab taugegi babade, büreabmana sugurungar Jisas gam menüm dora düdi kümünen, “Erekokai, na ogurebüre utungegena. Ye fere namagar na ogura yeb fata gam iruweregabge. ");
INSERT INTO urw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Babaure ye menüm utungun, ye fere namagegar, igede ogura na kegeneregün. Babaure na dora gürena doragab, yeb sarua mogoi maig namaweregeaga. ");
INSERT INTO urw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ye banüm doragün, baba amure, ige tugu ige fere yanim tugubüde tauiar nu minigo bürün. Bana ige tugu ige maraipapawar tugu ige minigo bürfaigen. Bana ye güre waudi, ‘na kümünegürba’, nu kümünafaigeaga. Bana ige güre waudi, ‘na oguregürba’, nu ogurafaigeaga. Bana igeab sarua mogoi waudi, ‘na fünai baba gegürba’, nu güfaigeaga.” ");
INSERT INTO urw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisas dora baba edüdi, fere babab doraure tergeaga. Bangüdi piruaboudi ferefinabur ginere nuge daiwen baba wangeaga, “Ye wangün, fere memeb kob kainana sibe, Israel fere güre kegeurge.” ");
INSERT INTO urw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bana baba fere simai maraipapangab taugegide sugurungar kümünen baba, nini maigüdi fata gam oguren baba, sarua mogoi namaweaga baba kegewen. ");
INSERT INTO urw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Dü güre gam Jisas fib ere güre gam kümüneaga, yanim nub Nain. Nugeab daidaiwegiwar tugu ferefinabur gin erewar tugu nuge keab kümünen. ");
INSERT INTO urw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nu güb fib ere baba koiweaga babab kudumege ere iroto taideaga, bangüdi fere gürekoi fere güre kumeaganwaib kemeidi fib ere obgoira füraboien baba kaingeaga. Fere babab ana, nu nono gürenakuana baba tugu, kab nugeab tugu kumar oyemadi büreaga. Bangar baba fib ere gamnab ferefinabur gin ere, finege baba keab oguren. ");
INSERT INTO urw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Erekokai finege baba kegeudi, kürüna kororabweaga, bangüdi finege menüm waweaga, “Na meregena.” ");
INSERT INTO urw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Bangüdi kümünadi, fere baba kemeien baba kur gam kube difereaga. Bangar fere simai kur baba kemeien baba biboyen. Bangar Jisasde wageaga, “Omo mogoi, ye wanün, na sirade.” ");
INSERT INTO urw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Bangar fere kumeaganwaib baba, siradüdi gotogeaga, bangüdi dorageaga. Bangar Jisasde nugeab ana maig duweaga. ");
INSERT INTO urw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ferefinabur gürenakuti Keriabüb sogi ere baba kegeudi kob siradar, Keriabüb yanim siradgaberen. Nini wagen, “Kiari fere güre ere manage sige kodigo taideaga.” Bangüdi wagen, “Keriab manage nugeab ferefinabur sagüngebüre ogurafotuweaga.” ");
INSERT INTO urw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Bangar Jisasde daba daba geaga baba doraman, ferefinabur gürenakutide düdi, Judia distriküb fib itut gürenakuti gam tugu eib eib fib gam tugu dora mangüdi urigegin. ");
INSERT INTO urw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jonüb daidaiwegiwarde baba daba daba gürenakuti Jisasde geaga babaure Jon wawen. Bangar Jonüde nugeab daidaiwegi aküre yagüngüdi, ");
INSERT INTO urw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","nugeküre Erekokai gam kümüna menüm totowebüregüdi sugurungeaga, “Na fere Keriabüde sugurwar ogurebüre dora idafotuweaganwaib baba ferede, ede sin güre momoweregenande?” ");
INSERT INTO urw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Baba fere aküre Jisas gam taidüdi, wagen, “Jon Yag Fidegibüde sugursigar na gam ogurenan, menüm totonebüregeaga, ‘Na fere Keriabüde sugurwar ogurebüre dora idafotuweaganwaib baba ferede, ede sin güre momoweregenande?’” ");
INSERT INTO urw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Baba sese gam Jisas ferefinabur eib eib subo tugub namabürüngeaga. Bangüdi etob kogi toi fanamge nini gam büreaga baba düfotugeaga. Bangüdi nude gar ege gomo simai, agügen. ");
INSERT INTO urw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bangüdi Jisasde Jonüb daidaigegi aküre gam dora menüm toweaga, “Ninaküre daba daba mügar kegewenan tugu edenan tugu babaure kümüna Jon wawane. Ege gomowar nini maig agügen, kebe kogiwar urigen. Ferengab mube lepra subo tutug baba, urun taiden, kagub kogi simai nini dora eden, ferewar kugumgafotuwen baba, nini maig siraden, bangar kogiwab ferewar nini dora nama eden. ");
INSERT INTO urw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Bana fere simai ye kegeidi, kob kainana ninib fürügarge baba, nini ebebearwane.” ");
INSERT INTO urw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Fere aküre Jonüb dora düdi ogurenwaib baba, nugeküre kümünafotuwen, bana Jisasde ferefinabur Jonure menüm wangeaga, “Nini fib fere kene gam kümünenan baba, daba güre kegewebüre kümünenan. Nini kübürde kauta güre isoweaga baba kegewebüre kümünarge. ");
INSERT INTO urw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nini am daba kegewebüre kümünenan? Nini kümüna fere güre karün toi nama nama eneaga baba kegewebüre kümünenande, io? Ferewar karün nama nama enüdi, mube gamnab daba daba nama nama tugu, babanüm ferewar erekokayaungab fata gam bürfaigen. ");
INSERT INTO urw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ba nini am daba kegewebüre kümünenan? Nini kiari fere güre kegewebüre kümünenande? Io, nuge dogo. Bana ye nini wangün, baba kiari fere Jon nu, kiari fere gürekoi gürenakuti emegerüngeaga. ");
INSERT INTO urw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Baba fereure dogo Keriabüb budide menüm wageaga, ‘Ede. Ye fere güre igeab dora pitoiebüre sugurweregün, bangar nu kese agfürüdi kümüneregeaga. Bangüdi nagüb erekobo ekotagabereregeaga.’ ");
INSERT INTO urw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ye menüm wangün, Jon fere gürenakuti meme kübüdim gam büren baba, emegerüngeaga. Bangeagako fere nu Keriabüb Koroba gam kürüna fanamere büreaga baba, nu Jon emegerweaga.” ");
INSERT INTO urw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ferefinaburie kegeam degi ferewar keab Jonüb kube gam yag fidenwaib babaure, dora baba edfotudi wagen, “Keriabüb kabia baba gürenakuti nama fanam.” ");
INSERT INTO urw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Bangeagako, Farisiwarie kabiab sibam ferewar keab, nini Jon kube gam yag fidedige. Babaure, Keriabüde erekobo nama abatarüngeaga baba, nige duen. ");
INSERT INTO urw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Bana Jisas namana menüm wageaga, “Ye mügar meme sese gamnab ferefinaburure komina dora doragebüreba, ye komina dora aranüm doragüi? Nini am fere sibe? ");
INSERT INTO urw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nini mogoi farafara sibe guruwegi fib gagam gotogaboudi bürüdi, mogoi farafara gürewarure menüm yogegi sibe, ‘Sin ninag meruwebüregüdi keag fuwenanko, ninag meruwarge, sin kororab mun orenanko, ninag meregi uruwenan.’” ");
INSERT INTO urw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bana Jisas namana menüm wageaga, “Jon yag fidegi nu ogureaga ba, nu bret tugu wain mum tugu nifaigarge. Bangar ninagüde wagenan, ‘Etob kogi nu gam büreaga.’ ");
INSERT INTO urw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mügar Fereb Nono ogureaga meme, nu daba tugu yag tugu neaga, bangar ninagüde wagfaigenan, ‘Kegewenan, baba fere nu daba tugu wain mum tugu gugub nuaigeaga. Nu kegeam degi ferewar tugu menmen gügab fere gürekoi tugub büreanüg.’ ");
INSERT INTO urw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nini banüm wagfaigenan, bangeagako ferefinabur Keriabüb sibam deginwaib baba simaide, sige menüm abatarsigen Keriabüb sibam namafanam.” ");
INSERT INTO urw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi gürede Jisas ogura nuge küre daba nebüregüdi yaguweaga. Judangab kabia nini kurebdir kinboudi daba nuaigen. Babaure Jisas baba Farisib fata gam daba nebüre kurebdir kinboweaga. ");
INSERT INTO urw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Finege güre kabia kogkogi güfaigeaga baba, nu baba fib ere gam büreaga. Nu Jisas Farisi babab fata gam daba neagagegi dora edüdi, wel kiag güre kuri nama tugu baba düdi ogureaga. Baba wel keag, kegenam gamde idawenwaib. ");
INSERT INTO urw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Bangüdi nu kümüna Jisasüb nige gam kebe iroto biboudi, mür büreaga. Agugur nugeab Jisasüb kebemara gam edogeaga, bangar finege baba nugeab taba sarade tatageaga. Nu Jisasüb kebe epüra fanam nur dokuwarge, bangüdi wel kuri nama tugu baba düdi kebemara nub gam kubeiaga. ");
INSERT INTO urw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Baba Farisi Jisas yaguwar ogureaganwaib baba, nu daba daba finege babade geaga baba kegeudi, menüm ututun toitoiweaga, “Baba fere nu kainana kiari fere garba, finege baba nugeab kebemara gam kube difereaga baba sibamgeregeaga, bangüdi kabia nub tugu sibamgeregeaga. Baba finege nu menmen gügab finege.” ");
INSERT INTO urw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisas nu fere babab ututun sibamgeaga, bangüdi menüm waweaga, “Saimon, ye dora güre wanebüregün.” Bangar Saimonde wageaga, “Sibam sarigegi, na dora nab pitoie.” ");
INSERT INTO urw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Bangar Jisasde wageaga, “Fere aküre nini, fere gürena gam nurto tugu. Güre baba nu nurto K500.00 tugu, güre baba nu nurto K50.00 fanam tugu. ");
INSERT INTO urw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nugeküre nugengab nurto maigaberegi towarge, bangar baba ferede nugeküreb nurto ebgafotuweaga. Bana nab ututun baba, aküre baba wonide baba fere namana meduebeaga?” ");
INSERT INTO urw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Bangar Saimonde menüm dora toweaga, “Yeb utunba, fere nurto nugeab erekokai ebgafotuweaga baba.” Bangar Jisasde waweaga, “Ututun nab kainana.” ");
INSERT INTO urw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Bana Jisas piruaboudi finege baba kegeudi, Saimon menüm waweaga, “Na finege meme kegeun de? Ye ogura fata nab gam iruaboinko, na ye yag siab kebemara gasaurge. Bangeagako finege meme nugeab agugurde yeb kebemara gasaweaga, bangüdi nugeab taba sarade püta tatageaga. ");
INSERT INTO urw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na nurdokiabge. Bangeagako, ye ogura iruaboin sese gam, meme finege nu yeb kebemara nurdokua büreaga. ");
INSERT INTO urw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Na wel düdi yeb taba gam kubeiabge. Bangeagako, meme finegede wel kuri nama tugu düdi ogura yeb kebemara gam kubeiaga. ");
INSERT INTO urw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Bangar ye wanün, sige meme finege kegewenan gam, nu ye kürüna medweaga baba, sige sibam, Keriabüde nub menmen toi gürenakuti unaigafotuweaga. Bangeagako fere menmen fanamere gar Keriabüde nub menmen unaigeaga baba, nub medweaga baba fanamere.” ");
INSERT INTO urw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Bana Jisasde finege baba menüm waweaga, “Ye nab menmen toi unaigafotun.” ");
INSERT INTO urw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Fere simai tag gam nugekeab kurebdir kinen baba, dora baba edüdi, nugenuge menüm doragen, “Meme fere nu wonigar nu menmen toi unaigeaga?” ");
INSERT INTO urw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Bana Jisasde finege baba menüm waweaga, “Nagüb kob kainanade gar, mügar na Keriab küre nama bürün. Na kümüne, kob nab dab fanam büreregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bana fanam bururudiba, Jisas fib ere ere gam tugu, fib itut urigüdi, ferefinabur gam Keriabüb Korobab dora nama pitoiaga. Bangar daidaiwegi toi gürena bede fogo aküre, nini tugu nu keab urigüdi kümünen. ");
INSERT INTO urw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Bangar finabur gürekoi, nuge egime Jisas nugede nini gam etob kogi toi difotugüdi, subo nugengab tugu kenegafotugeaga, baba finabur tugu, nu keab urigüdi kümünen. Güre baba Maria, nu Makdala fib ere gamnab Mariagüdi yanbafaigen. Egime Jisasde nu gam etob kogi nonob tugu düfotuweaganwaib. ");
INSERT INTO urw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joanaie Susanaküre tugu, finabur gürekoi epürage tugu nu keab kümünen. Joana nu Kusab fia. Kusa nu Herotüb fatab taugegi büreaga. Baba finaburwarde, Jisas nugeab daidaiwegi simai keab sagüngebüre, nugengab daba daba düdi dünügafaigen. ");
INSERT INTO urw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Fib ere gürenakutib gamnab ferefinabur Jisas gam oguren, bangar ferefinabur epürage gurudi büren. Bangar komina dora güre menüm dünügeaga, ");
INSERT INTO urw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Fere güre kümüna wit magi küm gam furabina kümünar, wit magi gürekoi erekobo gagam musudgeaga. Bangar ferede bitobaitowegin, ai toide tugu ogura nen. ");
INSERT INTO urw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wit magi gürekoi kübüdim kegenam tugu gam musudigen. Bangar wit kuaia tataigenko, kübüdim yag kenegar, baba wit kuaia toi gürenakuti genangabougüdi kugumgen. ");
INSERT INTO urw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wit magi gürekoi muri toi dumegi tutug kodigo musudigen. Bangar muri dumegi tutug baba, wit kiab foudi wit korotaugen. ");
INSERT INTO urw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Wit magi gürekoi kübüdim nama gam musudgüdi kuaia fowen baba, nama, 100, 100 banüm feren.” Jisas komina dora baba doragafotudi menüm yogeaga, “Fere kagub tugu garba dora meme ederegeaga.” ");
INSERT INTO urw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisas komina dora babab ginim pitoiaga babaure, nugeab daidaiwegi toide, nuge totowen. ");
INSERT INTO urw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Bangar menüm wangeaga, “Ninag Keriabüde eungar Keriabüb Korobab, iwagegi dora toib, ginim, sibamgafotuwenan. Bangeagako, ferefinabur gürekoi nini komina dora gürena edfaigen. Bangar nini epürabede agugafaigenko, am daba güre sibamgedige. Nini dora epürabede ederegenko, dora babab ginim sibamgeregedige.” ");
INSERT INTO urw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Bangar Jisas namana menüm wageaga, “Komina dora memeb ginim baba menüm. Meme wit magi toi baba Keriabüb dora sibe. ");
INSERT INTO urw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wit magi toi erekobo gam musudigen baba, nini ferefinabur Keriabüb dora edegi sibeko, kuri Satande oguradi dora baba kob ninib gam düfotuweaga. Satan menüm utungeaga, ‘Nini kob kainanagedi Keriabüde igaingeregeagagüdi bangeaga.’ ");
INSERT INTO urw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Wit magi toi kübüdim kegenam tugu gam musudigen baba, nini ferewar dora edüdi, düdi, dora babaure ebebearwegi sibeko, nini wit magi toi kübüdim gam ginim kanegi kene sibe, babaure sese siga fanam gamba, kob kainanageregen, bangar fürüregi sese gamba unonogüdi Keriab ebgadügafaigen. ");
INSERT INTO urw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wit magi toi dumegi muri toi kodigo musudigen baba, nini ferewar Keriabüb dora edegi sibeko, daba daba nuge gam tataigen babaure ututun toi toiudi, sarawen. Kegeam daba daba tugu kübüdim meme gamnab daba dabaure tugu ebebearwegin. Bangar baba daba dabade korotaungar Keriabüb dora idadau daiwedige. Nini daba idadau ara ebeabgegige sibe. ");
INSERT INTO urw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bangeagako, baba wit magi toi kübüdim nama gam musudigen baba, nini ferewar dora edüdi sogsogi debetawegi sibe. Kob ninib baba nama fanam surur büreaga, bangar sogi biboudi nama für büren.” ");
INSERT INTO urw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jisas namana menüm wageaga, “Fere nini nan furudi sumo saka tormogataugafaigedige, ede tag gadi gam difürügafaigedige. Nini furuadüdi tag kekia difürügafaigen, amure, ferewar fata gam irudiba, meram baba kim kegeweregen. ");
INSERT INTO urw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Daba daba gürenakuti iwagen baba, kuri ekeba tataigeregen. Daba daba gürenakuti ferewarde korotataugedi büreaga baba, kuri ekeba tataigeregen. Bangar fere sibamgeregen. ");
INSERT INTO urw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Nini dabnana, bangüdiba dora idadau ederegenan. Fere güre daba daba gürekoi darba, Keriabüde maig namana gürekoi duweregeaga. Bangeagako, fere daba daba yamaige tugu baba, ige daba daba fanamere tugu güdigarba, Keriabüde nu gam baba daba daba, dufotuweregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Baba sese gam Jisasüb anaie, Jisas nugeab mebemana, Jisas nuge kegewebüre oguren. Bangeagako, ferefinabur epürafanam gurudi büredurudi, Jisas nugeab gin nuge iroto oguregi dirugungeaga. ");
INSERT INTO urw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Fere gürekoide, Jisas menüm wawen, “Anin nagüb, mabünmana keab, nag kegenebüre obugo bai biboudi büren.” ");
INSERT INTO urw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Bangeagako dora ninib maig menüm toweaga, “Ferefinabur Keriabüb dora edüdi daiwen, baba simai gürena nini yeb anigamana, nini yeb mabamana.” ");
INSERT INTO urw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Dü güre gam Jisas nugeab daidaiwegi toi keab oude güre gam ebeden. Bangüdi menüm wangeaga, “Yag nigu bairasari kümünegi.” Bangar kümünen. ");
INSERT INTO urw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Oude gururwarbere, Jisas nu kineaga. Bangarbere yag nigu gam kübür sogi taideaga, bangar oude gam yag gobebüregeaga, bangar kenegebürenanagen. ");
INSERT INTO urw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bangar kümüna Jisas imoudi wagen, “Eregeam, eregeam, sige kenegebüregenan bana.” Bangar siradüdi kübür baba tugu yag nigu baba tugu nunurungeaga. Bangar kübür tugu yag nigu tugu saweaga, bangar yag maig binawarge. ");
INSERT INTO urw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Bangar Jisasde menüm totongeaga, “Aranüm? Kob kainanagegi ninib arag büreaga?” Bangar daidaigegi simai Jisasde fünai gugub geaga baba kegeudi, kimgüdi ututun toitoiwen. Bangar nuge nuge menüm wagen, “Am ferenana menüm? Nu kübür tugu yag tugu kakongar nugeküre dora nub eden.” ");
INSERT INTO urw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bana Jisas nugeab daidaiwegi toi keab Gerasawarüngab yau kümüna taiden. Fib baba Galili yag nigu baira büreaga. ");
INSERT INTO urw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Bana Jisas oude ebgadüdi kümüna taideaga. Baba fib ere gamnab fere güre nuge gam taideaga. Etob kogi gürekoi fere baba gam büren. Egimena ude dagfaigarge. Nu fata güre gam bürfaigarge. Nu ferefib gagam bürfaigeaga. ");
INSERT INTO urw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ferewar fere baba taugafaigen baba, muri sogi saka kube kebe sawaigafaigen. Bangeagako, nu muri sogi baba gürenakuti katafotugafaigeaga. Bangar etob kogi babade gufaigar, gururudi fere kene gam bag kümünafaigeaga. Bangar etob kogi fere baba ebgafotuwebüre güdi Jisas doragafotuweaga. Bangar fere baba Jisas kegeudi, magaudi Jisasüb kebe iroto fürügeaga. Bangüdi erenana yogüdi mengeaga, “Jisas, na Keriab Kekia Asaub Nono, na ye gam am bangebüregün? Aio, na ye kogi fürüiegena.” ");
INSERT INTO urw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Bangar Jisasde menüm totoweaga, “Nab yanim won?” Bangar wageaga, “Yeb yanim Maraipapa,” amure, etob kogi epürage nu gam iruwen babaure, banüm wageaga. ");
INSERT INTO urw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Bangar baba etob kogi toide Jisas gam yogüdi wagen, “Na sin kudesigab ub ginim kene baba gam kanübugona.” ");
INSERT INTO urw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Dawai gin ere iroto gir fanam gam, daba nübüren. Bangar etob kogi toi Jisas sogsogi menüm totowen, “Na eusigab sin baba dawai toi gam iruweregenan.” Bana Jisasde eungar kümünen. ");
INSERT INTO urw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bangar baba etob kogi toi fere baba ebgadüdi kümüna dawai toi gam iruwen. Bangar baba dawai gin, erenana gururudi fib kogi güre gam kanen. Bangüdi yag nigu gam fürügüdi yag nüdi kugumgen. ");
INSERT INTO urw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Dawai taugegiwar baba daba taideaga baba kegeudi gusaraudi, dora düdi fib ere gam tugu, eib eib tugu kümünen. ");
INSERT INTO urw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bangar ferefinabur ogura amdag dabanana taideaga baba kegewebüregen. Bana Jisas gam ogura taiden baba, etob kogi fere baba uriawen baba kegewen. Nu ude dageaga. Ututun nugeab namawar Jisasüb kebe iroto gotogüdi büreaga. Bangar ferefinabur kegeudi kimigen. ");
INSERT INTO urw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bangar fere egime etob kogi nu gam bürar Jisasde düfotuwar namaweaga baba fereb doraman, fere daba daba taidar kegewenwaib babawarde dora mangen. ");
INSERT INTO urw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","39","Bangar Gerasawarüngab distriküb fere gürenakuti Jisas baba fünai gugub geaga babaure ututungüdi, kimgüdi Jisas uriangüdi kümünebüregüdi bikuwen. Bangeagako, fere etob kogi toi uriawen babade Jisas menüm totoudi bikuweaga, “Na euiab ye naküre kümünaide?” Bangeagako, Jisasde sugurwar maigeaga, bangüdi menüm waweaga, “Na maigübe nagüb fib gam kümünabe, Keriabüde nag, sagünebüre daba daba gürenakuti geaga babab dora pitoie.” Bana Jisas oude gam ebedüdi maigeaga. Bangar fere baba nugeab fib ere gam kümünadi, Jisasde nuge saguwebüre daba daba gürenakuti geaga babab dora, ferefinabur gam pitoiaga. ");
INSERT INTO urw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bana Jisas maigüdi yag nigu baira kümünar, ferefinabur gürenakuti ebebearwen, amure, momoudi bürenwaib babaure. ");
INSERT INTO urw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Bangar fere güre taideaga, nub yanim Jairas. Nu kunube fatab taba fere güre. Nu momugo gürenakuana fanam tugu, momugo baba nu mene gürena bede fogo aküre banüm. Momugo baba kumebürenanageaga. Bangar Jairas nugeab momugo babaure kob kürüna koigeaga. Babaure nu Jisasüb kebe iroto oksosob orudi, Jisas igaiudi Jairas nugeab fata gam kümünebüregüdi, totoudi bikuweaga. Bana Jisas kümünar, ferefinabur ginbata nu keab kümünadi nu gam gütgütwanagen. ");
INSERT INTO urw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Finege güre büreaga, nu kagi sinoyegi bata bürfaigeaga, nu mene gürena bede fogo aküre büreaga. Bangeagako kau fere gürede kagi subo nub namaberegi towarge. ");
INSERT INTO urw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Baba finege Jisasüb nige iroto oguradi, Jisasüb karün kuab babab maga kebe gam, gemuna tumaureaga. Banüm bangar, pirikana kagi nugeab paudi, kenegeaga. ");
INSERT INTO urw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Bangar Jisasde menüm totogeaga, “Wonide ye gam kube difereaga?” Bangar gürenakuti wagen, “Ye kene. Ye kenegen.” Bangar Pitade wageaga, “Eregeam, ferefinabur epürage ginbata biboudi koiwataunen, bangüdi nag gam gütgütwanagen.” ");
INSERT INTO urw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Bangeagako Jisasde wageaga, “Gürede ye gam kube difereaga. Sogi gürekoi uriaidi kümünar wagün.” ");
INSERT INTO urw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Finege baba mügar sibamgeaga, iwageregarge. Bangarbere kutudi, Jisas gam iroto oguradi, kübüdim gam nurmaga difürüdi oksosob oreaga. Bangüdi ferefinabur gürenakutingab ege gam wageaga, “Kagi subo yeb pirikanana kenegeaga. Amure, ye Jisasüb karün tumaurun babade.” ");
INSERT INTO urw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Bangar Jisasde menüm waweaga, “Finege, na yeure kob kainanagün, bangarbere na maig namaun. Arie, kob nab dab fanam büreregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas doraga bürarbere, kunube fatab taba fere güreb fata gamnab fere güre oguradi, taba fere baba menüm waweaga, “Nab momugo kumeaga. Sibam sarigegi fere kub namana duwegena.” ");
INSERT INTO urw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jisas baba edüdi, taba fere gam dora menüm toweaga, “Na kimigegena. Na kob gürena kainanagab, momugo nagüb maig siraderegeaga.” ");
INSERT INTO urw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bana Jisas taba fereb fata gam kümüneaga, bangüdi ferefinabur eungar nuge keab fata gam iruwedige. Nu Pita igaiweaga, Jonie, Jems küre tugu, momugo babab emeana, nin gürena nuge keab iruwen. ");
INSERT INTO urw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bangar ferefinabur fata gam bürfotuwen baba, momugo babaure kororabüngar mür büren. Bangeagako, Jisasde menüm wangeaga, “Meragana. Kumarge. Eina kinbüreaga.” ");
INSERT INTO urw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bangar kuipariwen, amure, nini sibamgen, momugo manage kumeaga. ");
INSERT INTO urw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Bangeagako Jisasde momugob kube debetaudi menüm yogeaga, “Momugo, na sirade.” ");
INSERT INTO urw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Bangar momugo babab etob maig nuge gam ogurar pirikanana siradeaga. Bangar Jisasde momugo baba daba gürekoi duwebüregüdi wangeaga. ");
INSERT INTO urw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bangar momugob emeana tergen. Bangeagako, Jisasde nuge küre sogsogi menüm wangeaga, “Ninaküre daba meme taideaga babaure fere güre wawagana.” ");
INSERT INTO urw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisasde daidaigegi gürena bede fogo aküre baba yagüngar oguredi, sogi ere tugu yanim tugu dünügeaga. Baba sogi ere tugu yanim tugu baba, nini etob kogi gürenakuti ferefinabur gagam büren baba difotugegib dünügeaga. Baba tugu ferefinabur amam subo tutug baba, namabürügeregen. ");
INSERT INTO urw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bangüdi Keriabüb Korobab dora pitoiebüre tugu, subo ferewar namabürüngebüre tugu sugurungar kümünen. ");
INSERT INTO urw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Bangüdi menüm wangeaga, “Nini daba daba kiregüdi kümünagana. Nini urigegi at debetawagana, far tugu kemeiagana. Bret tugu kegenam tugu dagana. Baba tugu mube enegi aküre dagana. ");
INSERT INTO urw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nini fib güre gam taidüdi fata güre gam iruwaboidiba, baba fata gamnana bürane. Kuri fib baba ebgadüdi gürekum kümünebüreie, fata baba ebgadane. ");
INSERT INTO urw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Fib ere güre gamnab ferefinabur ninag igaingüdi nugengab fata gam kümünedigegarba, baba fib ere ebgadane. Kümünebüreba ibur kebe gama ninagüngab gam büreaga baba, porowane. Bangar baba kabia gegin baba, kogigüdi kim sibamgeregen.” ");
INSERT INTO urw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bana daidaigegi simai fib adab adab gagam kümünen. Bangüdi dora nama pitoidi, babanana subo ferewar fib itut namabürügen. ");
INSERT INTO urw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kübüdim bera taugegi agferegi Herotüde, Jisas daba daba geaga baba dora edüdi, ututun toitoiweaga, amure, fere gürekoide menüm wagfaigen, “Jon ferefib gamde maig siradeaga.” ");
INSERT INTO urw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bangar gürekoide tugu wagfaigen, “Elaija taideaga.” Bangar gürekoide wagen, “Kiari ferewar egime kugumgen babawar, güre maig ferefib gamde siradeaga.” ");
INSERT INTO urw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Babaure Herotüde menüm wageaga, “Ye sarua mogoi wangür Jonüb barub manage katafotun. Bangeagako, fere baba nu wongar tün nub siradar, ferewarde doragedi edün?” Bangüdi Jisas kegewebüregeaga. ");
INSERT INTO urw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Dora turewegi ferewar maigüdi ogurafotudi, nuge daba daba gegin babaure Jisas wawen. Bangar Jisasde igaingüdi, fib ere güre gam kümünen, nub yanim Betsaida. ");
INSERT INTO urw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ferefinabur epüra, Jisas kümünafotuweagagegi dora edüdi, daiudi kümünen. Bangar nuge gam oguren babaure ebebearweaga. Nin gam Keriabüb Korobab dora pitoiaga, bangüdi babanana subo tutugub ferefinabur idadangeaga. ");
INSERT INTO urw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ututumira nugeab dora turewegi toi, nuge gam oguradi menüm wawen, “Na ferefinabur sugurungab fib itut adab adab kümüneregen. Bangüdi daba tugu, kinegi fib tugu fitaweregen. Meme gam bürenan baba, fere kene.” ");
INSERT INTO urw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Bangeagako, Jisasde daidaiwegi simai menüm wangeaga, “Ninagüde daba dünügane.” Bangar wagen, “Sin daba yamaige. Bret taba tugu, wade aküre fanam gürena büreaga. Na sin kümüna meme ferefinabur gürenakutingab daba murugeregenangüdi gündag?” ");
INSERT INTO urw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Fere 5,000 banümdag büren. Bangar Jisas nugeab daidaiwegi toi menüm wangeaga, “Wanügar 50-50 gurudi gotogeregen.” ");
INSERT INTO urw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Daidaiwegi simai banüm bangedi, ferefinabur gürenakuti gotogen. ");
INSERT INTO urw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Bana bangar Jisas bret taba tugu wade aküre baba tugu düdi, kekia fib nama gam agügüdi Keriabure esegeaga. Bangüdi bret tugu wade tugu pusudi daidaiwegi toi dünügeaga, bangar kabataudi ferefinabur dünügen. ");
INSERT INTO urw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bangar nedi fugongar daba makita makita bürdaiweaga baba, daidaiwegi simaide tobgüdi far gürena bede fogo aküre gobaberen. ");
INSERT INTO urw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Gürena sese Jisas nugenakuana sibdibwabüreaga, bangar nugeab daidaiwegi toi nuge keab büren. Bangar menüm totongeaga, “Ferefinaburde ye woni güfaigen?” ");
INSERT INTO urw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bangar maig menüm dora towen, “Gürekoide menüm wagfaigen, na Jon yag fidegib. Gürekoide wagfaigen na Elaija. Bangar gürekoide wagen, ‘Kiari ferewar egimengab baba, güre maig siradeaga.’” ");
INSERT INTO urw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Bangar totongeaga, “Bana ninagüde ye wonigüdi wagenan?” Bangar Pitade dora maig menüm toweaga, “Keriabüde nugeab ferefinabur maig ogura igaingebüre dora idafotuweaganwaib na baba fere.” ");
INSERT INTO urw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Bana Jisas nuge wondag baba, nugeab daidaiwegi simai dora sogi dünügüdi, fere güre wawagana güdi tageibürüngeaga. ");
INSERT INTO urw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Bangüdi wageaga, “Fereb Nono nu kub epürafanam kemeieregarge. Bangar taba ferewar, kobegegi taba ferewar tugu kabiab sibam ferewar keab, nige duweregen. Bangüdi dora diferedi fere gürekoide orfotuweregen. Bangar dü küi gam ba maig siraderegeaga.” ");
INSERT INTO urw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Bangüdi daidaigegi gürenakuti menüm wangeaga, “Fere güre daiebüreba, nugeab ututun ebgaderegeaga. Bangüdi dü itut nugeab au fabgegi kemeidie daieregeaga. ");
INSERT INTO urw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Amure, fere güre nugeab gotogegi sogsogi debetawebüregüdiba, nub gotogegi kenegeregeaga. Bangeagako, fere güre yeure utungudi gotogegi nugeab uriafürüdiba, nub gotogegi nama büreregeaga. ");
INSERT INTO urw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Fere güre kübüdim gamnab daba daba gürenakuti darbere, nuge koigüdi kumarba, baba daba daba gürenakutide aranüm saguwebeaga? ");
INSERT INTO urw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Fere güre igeure tugu igeab dora tugu febawarba, bana kuri Fereb Nono nugeab meram ere gam tugu, emeb meram tugu, Keriabüb dora dugurewegiwarüngab meram gam tugu büregi sese gam ogureregeaga baba, nu tugu baba fere febaweregeaga. ");
INSERT INTO urw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ye kainana wangün, fere gürekoi meag bibowen baba, ara kumediberenana Keriabüb Koroba baba kegeweregen.” ");
INSERT INTO urw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisas dora baba baba dorageaga baba, dü düm sob banüm kenegarbere, Pita, Jems, Jon, babawar igaingüdi gir gam komen, amure, sibdibwebüregeaga. ");
INSERT INTO urw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Sibdibwa bürarbere, nurmaga nugeab adab taideaga. Bangar karün nugeab maurasau taideaga, bangüdi meramgeaga. ");
INSERT INTO urw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bangar fere aküre nuge keab doraga büren baba, Mosesie Elaijaküre. ");
INSERT INTO urw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nugeküre Keriabüb meram tugu taidüdi, Jisasde Jerusalem bag daba daba güfotudie, kübüdim baba ebgadüdi kümüneregeaga babaure doragen. ");
INSERT INTO urw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pitab mube tugu, daidaigegi aküre babab mube tugu siroi siroingar kinen. Bangar kuri maig siraden baba, Jisasüb mube gam meram kegewen, baba tugu fere aküre Jisas keab bibowen baba tugu kegengen. ");
INSERT INTO urw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bana fere aküre Jisas keab bibowen baba, Jisas ebgadüdi kümünebüregedibere, Pitade Jisas menüm waweaga, “Eregeam, sige meag bürenan baba nama. Sin kim yana fata küi fereregenan. Güre nagüb güre Mosesüb, güre Elaijab.” Pita dora baba dorageagako, nuge dora aranüm dorageaga baba, babab iginim sibamgarge. ");
INSERT INTO urw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita dora baba dora gar bere, demenana fioude korotaungar kimigen. ");
INSERT INTO urw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Bangar demenana sube güre fiou kodigode menüm wageaga, “Meme yeb Nono. Nu igeab fünai gebüre uruagafotur büreaga, nub dora edane.” ");
INSERT INTO urw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Baba sube doragafotuwar agügen baba, Jisas nugenakuana bürar kegewen. Bangafotudi gir ebgadüdi maig musuwen baba, daidaigegi simai baba daba kegewen baba, fere güre wawedige. ");
INSERT INTO urw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Dü güre kenegar, Jisas nugeab daidaiwegi simai keab gir ebgadüdi kanedibere, ferefinabur ginbata oguradi, Jisas gamam kaiwen. ");
INSERT INTO urw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Bangar baba ferefinabur kodigo, fere gürede menüm yogeaga, “Sibam sarigegi, na yeb nono kegewebüregüdi igena totonadaiun. Ye nono gürenakuana baba gürena. ");
INSERT INTO urw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Etob kogi güre nu gam manag manag iruwafaigar nono baba kerübgurofaigeaga. Bangar etob kogi babade güfaigar, nono baba kutuafaigüdi kiregirewar sube gam simuk sapa sapafaigeaga. Baba etob kogide mube nub kogifuruafaigüdi, pirika nono baba ebgadügafaigarge. ");
INSERT INTO urw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Bangar nagüb daidaigegiwar etob kogi baba düfotuwebüre igena wangaurugunko, towedige.” ");
INSERT INTO urw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Bangar Jisasde dora menüm toweaga, “Ferefinabur nini kob kainanagarge baba, ututun ninib tugu kabia ninib tugu namage. Ye aganbede nini keabnana bürüdi kub ninib kemeieregün? Nono nab igaiudi ogure.” ");
INSERT INTO urw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bana nono baba Jisas iroto ogurarbere, etob kogi babade buraifotuwar fürügüdi kiregireweaga. Bangeagako, Jisasde etob kogi baba nunurweaga, bangüdi nono baba namabürüdi maig eme duweaga. ");
INSERT INTO urw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bangar ferefinabur gürenakuti, Keriabüb sogi ere baba kegeudi tergen. Ferefinabur Jisasde daba daba geaga babaurenana ututun toitoiwen, bangar Jisasde nugeab daidaiwegi simai menüm wangeaga, ");
INSERT INTO urw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nini dora meme, kagub idadau difürübenar edane. Fereb Nono ferewarüngab kube gam difereregen.” ");
INSERT INTO urw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bangeagako, daidaigegiwar nini dora babab iginim sibamgedige. Dora babab iginim baba, ninag gam iwageaga, babaure nini idadau sibamgedige. Bangar maig wangebüregüdi totowebüregenko, kimigen. ");
INSERT INTO urw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Gürena sese daidaigegi simai nuge nuge menüm doramaraigen, “Woni nu sinib yanim tugub fere?” ");
INSERT INTO urw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ninib kob gam ututun baba büreaga baba, Jisas nu sibamgeaga. Babaure mogoi fara fanam güre igaiudi ogura nuge iroto difereaga. ");
INSERT INTO urw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Bangüdi daidaigegi simai menüm wangeaga, “Fere yeure ututungüdi mogoi fara fanam meme ebebearuaburuweaga baba, nu ye ebebearuabriaga. Babaure fere ye ebebearuaburuiaga baba, nu emüga ebebearuaburuweaga, nude suguryar oguran. Amure, fere yanim kene ninag kodigo büreregeaga baba, nu fere yanim tugu.” ");
INSERT INTO urw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon Jisasüb dora edüdi dora menüm toweaga, “Eregeam, sini fere güre kegewenan baba, nagüb yanim gamde etob kogi toi difotugeagako, daisigarge. Babaure baba fünai, tageiburuwenan.” ");
INSERT INTO urw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Bangeagako, Jisasde menüm waweaga, “Fere nini keab karau kene baba, baba ninagüb büreyanüg, amure, baba fünai geaga baba ninagüb fünai sibe babaure tageiburuagana.” ");
INSERT INTO urw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Keriabüde Jisas igaiudi fib nama gam komegi sese manage irotogeaga. Babaure Jisas Jerusalem kümünegi ututun sogi deaga. ");
INSERT INTO urw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bangar daba daba dugutuwebüre, ferewar kese sugurungar kümünen. Bangar kümüna Samaria distriküb fib güre gam taiden, bangüdi Jisasüb daba daba dugutuwebüregen. ");
INSERT INTO urw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bangeagako, baba fib gamnab ferewar, Jisas igaiudi nugengab fata gagam kümünegi uruwen. Amure, nini sibam, Jerusalem kümünebüregeaga. ");
INSERT INTO urw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Daidaigegi aküre, Jemsie Jonküre Samaria distriküb ferefinaburüngab kabia baba kegeudi, Jisas menüm totowen, “Eregeam, sin keb yagudar fib nama gamde musudi baba ferewar fükürangeregeaga. Baba fünai gebüregenan baba, na medneagade?” ");
INSERT INTO urw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bangeagako, Jisasde piruaboudi nunurungeaga. ");
INSERT INTO urw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bangar fib güre gam kümünen. ");
INSERT INTO urw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jisas daidaigegiwar keab erekobo gam kümünedibere, fere gürede menüm waweaga, “Na fib gürenakuti gam kümüneregün baba, ye daidaineregün.” ");
INSERT INTO urw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Bangar Jisasde menüm waweaga, “Dugumob mam nini kübüdim gam kinegi abuk tugu, ai toi tugu nini deab tutugko, Fereb Nono nu kinegi kur kene.” ");
INSERT INTO urw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Bana Jisasde fere güre menüm waweaga, “Na ogura daie.” Bangeagako, fere babade wageaga, “Eregeam, uruab ye kümüna emüga ub kurbürüdie.” ");
INSERT INTO urw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Bangar Jisasde waweaga, “Ebgade. Fere kugumgen baba, nuge nuge ub kurwanageregen. Na kümüna Keriabüb Korobab dora pitoie.” ");
INSERT INTO urw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Maig fere gürede Jisas menüm waweaga, “Eregeam, ye dainebüregünko, uruab ye kümüna giniaimana fereberengüdiede?” ");
INSERT INTO urw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Bangar Jisasde menüm waweaga, “Fere Keriabüb fünai toadüdi fünaiwarbere kübüdim gamnab daba dabade burbarweaga babanüm fere, nu Keriabüb Korobab fünai geregarge.” ");
INSERT INTO urw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kuri Erekokaide namana 72 ferewar uruageaga, bangüdi sugurungar aküre aküre kümünen, nini nuge gam agfürüdi kümünen. Sugurungar gürenakuti fib ere gagam tugu fib nugede kümünebüregeaga baba gam tugu. ");
INSERT INTO urw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Bangüdi menüm wangeaga, “Küm gam daba epüra fanam ebeabgafotuwarge. Bangeagako kiregegib sarua fere namai büredige. Babaure küm Emeure sibdibwane, bangar kim sarua ferewar sugurungar kümüna nugeab daba tobgeregen. ");
INSERT INTO urw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Nini kümünane. Edenan, ye nini sugurungür sipsip farafara sibe dugumob mam toi kodigo kümünabewenan. ");
INSERT INTO urw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nini kegeam far tugu far tugu kebemara enegi tugu kemeidi ninag keab kümünagana. Bangüdi ferefinabur erekobo gam kaingüdi fereberengagana. ");
INSERT INTO urw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nini fata güre gam iruwaboidiba, bana nini dora meme kese doragane, ‘Meme fata gamnab ferefinaburwar, kob dab fanam bürane.’ ");
INSERT INTO urw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bana fere güre kob dab fanam büregib baba fata gam bürarba, ninib dora nama baba fere gam kim büreregeaga. Bangeagako babanüm fere sibe bürargegarba, ninib dora nama ninag gamna maigeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nini fata gürena baba gamna bürane. Bangüdi daba daba gürenakuti nugede dünügeregen baba gürena nifaigane, baba daba dünügedi nenan baba, baba ninagüngab mur, amure, fere saruagafaigeaga baba, nu nugeab mur deregeaga. Babaure nini fata itutwagana. ");
INSERT INTO urw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Nini fib ere güre gam kümüna iruwar igaingüdi nugengab fata gam kümünediba, bana daba nugede kabatangeregen baba dane. ");
INSERT INTO urw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nini baba fib ere gam subo fere büren baba namabürügane. Bangüdi babawar gam dora menüm pitoiane, ‘Keriabüb Koroba ogura nini gam etogeaga.’ ");
INSERT INTO urw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Bangeagako nini kümüna fib ere güreb güb gam iruwar, igaingüdi nugengab fata gam kümünegi uruwediba, bana nini kümüna fib ereb erekobo gam biboudi, menüm doragane, ");
INSERT INTO urw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ninib fib ere gamnab kübüdim nom sinib kebe gam büreaga baba, sini düfotuwenan. Baba, nini menüm abatarüngebüre, baba kabia genan babade nini menmen tugu. Bangeagako nini idadau utungane. Keriabüb Koroba ogura etogeaga.’ ");
INSERT INTO urw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ye nini wangün, dü Keriabüde ferefinabur dora gam difürüngebüre uruageaga gam, kub baba, baba fib ere gamnab ferefinabur gam taideregeaga, kub baba Sodom fib erewar gam taideaga baba, kürüna emegerweregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jisas namana menüm wageaga, “Korasin fib ere gamnab ferefinabur nini dabnanai. Betsaida simai nini dabnanai. Fere güre fib ere Tairie Saidon tugu gam kümünadi dora migu ige ninag kodigo idaidaun sibe, nu idaidawagba, egimena Tairie Saidon tugu nini kob pirudi enegi kororabüb enüdi, keb sobo gam gotogag. Amure, nuge menmen toi gegin baba kürüna kororab abatargebüre. ");
INSERT INTO urw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Bangeagako Keriabüde ferefinabur dora gam difürüngebüre dü uruageaga gam, kub nini gam taideregeaga baba kub, Tair simaie Saidon simai gam taideaga baba, kürüna emegerweregeaga. ");
INSERT INTO urw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Bana Kaperneam simai, nini Keriabüde sirarüngaberar fib nama gam komeregenangagana. Kürüna kene. Nini kürüna gemuna fere kumegingab fib gam kaneregenan.” ");
INSERT INTO urw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Bana Jisasde daidaigegi simai menüm wangeaga, “Fere nu ninib dora edeaga baba, nu yeb dora edeaga. Fere nu nige dünügeaga baba, nu ye nige siaga. Bana fere nu ye nige siaga baba, nu Keriab nige duweaga, nugede suguryar oguran.” ");
INSERT INTO urw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kuri Fere simai nonob tugu bede fogo aküre Jisasde sugurungar kümünen baba, nini maigüdi oguradi kürüna ebebearwen. Wagen, “Erekokai, sini nagüb yanim yanbawenan, bangar etob kogkogi sinib dora daiwen.” ");
INSERT INTO urw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Bana Jisasde menüm wangeaga, “Ye Satan kegeun, fib nama ebgadüdi uyankengenimüb meram sibe musuweaga. ");
INSERT INTO urw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Edane. Ye ninag yanim dünügafotun, bangar ninag kogi fürüngegib matu toi tugu makaras toi tugu, bitobaitongeregenan. Bangüdi nini Satanüb sogi gürenakuti emegerweregenan. Satan ninagüngab karauianüg. Bangar nini daba gürede kogifürüngeregarge. ");
INSERT INTO urw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bangeagako nini fidoudi menüm doragagana, ‘Etob kogi simai sinib dora daiwen.’ Kene. Nini nagüngab yanim Keriabüde nugeab budi gam fib nama gam bag feifotuweaga babaure ebebearwane.” ");
INSERT INTO urw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Baba sese gam, Etob Kedebüde gar Jisasüb kob ebebearweaga, bangar Jisasde menüm wageaga, “Emüga, na fib nama gamnab tugu kübüdim gamnab tugu Erekokai, ye naure esegün, amure, na meme daba daba ferewar sibam nama tugu, ututun nama tugu gam iwagafürün, bangüdi na ferewar mogoi farafara sibe büren gam abatargün. Emüga, na nagüb ututun daiudi na banüm bangün.” ");
INSERT INTO urw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jisas namana menüm wageaga, “Emüga nu, daba daba gürenakuti yeb kube gam difereaga. Bangar Nono nu, am fere güre fanamde sibamgarge. Emüga nugenakuana fanam nu sibamgeaga. Bana Emüga tugu, am fere güre fanamde sibamgarge. Nonoie, ferewar nono nugede, Eme abatarüngeaga, nini gürena Emüga sibamgen.” ");
INSERT INTO urw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Daidaigegiwar gürena Jisas keab büren, bangar nu piruaboudi kegengeaga, bangüdi menüm wageaga, “Ferewar daba daba ninag kegefaigenan baba kegeudiba, ebebearweregen. ");
INSERT INTO urw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ye nini wangün, egime kiari fere epürage tugu erekokayau epürage tugu, nini daba daba ninag mügar kegewenan baba kegewebüregen, bangeagako nini kegewedige. Bangüdi nini dora ninag edfaigenan baba edebüregen, bangeagako nin ededige.” ");
INSERT INTO urw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bana kabiab sibam fere güre siradüdi, Jisas fururebürewadi menüm totoweaga, “Sibam sarigegi, ye arangüdie gotogegi nama tüpür tüpür büregib düi?” ");
INSERT INTO urw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Bangar Jisasde menüm totoweaga, “Am dora kabia gam büreaga? Na ninaifotudi aranüm utungun?” ");
INSERT INTO urw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Bangar kabiab sibam ferede menüm dora toweaga, “Nini Keriab kob duwane, Erekokai sigeab. Nini kürüna nagüngab kob gamde kob duwane, nagüngab etob gamde, nagüngab sogi gamde, nagüngab ututun gamde tugu. Bangüdi ninagüde ninag kob duenan sibe, büreanmana kürüna kob dünügane.” ");
INSERT INTO urw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Bangar Jisasde menüm waweaga, “Ebabako, na dora kainana toun. Na bangüdiba, na gotogegi nama tüpür tüpür deregün.” ");
INSERT INTO urw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bangeagako baba kabiab sibam fere, nu Jisasde waudi na sibam kenegegi uruweaga, babaure Jisas menüm totoweaga, “Bana kabiade wagüdi yeb büreyaigeaga baba, woniure dorageaga? Won sob nini yeb büreyaimana?” ");
INSERT INTO urw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Bangar Jisasde dora menüm toweaga, “Fere güre Jerusalem ebgadüdi Jeriko fib ere gam kaneaga. Bangarbere be ferewar erekobo gam iwagüdi büren babade, orudi nub daba daba gürenakuti kiregen, bangafotudi kümünen, bangedi nu erekobo gam kinbüreaga, bangüdi kumebürenanageaga. ");
INSERT INTO urw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Baba sese gam kobegegi fere güre baba erekobo daiudi kaneagaba, fere erekobo gam kinbüreaga baba kegeweaga, bangüdi erekobo kureb gamde katudi emegerudi kaneaga. ");
INSERT INTO urw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Banüm sibenana Livaib gin gamnab fere güre tugu ogura baba gam taideaga, bangüdi baba fere kegeweaga, bangüdi erekobo kureb gamde katudi emegerudi kaneaga. ");
INSERT INTO urw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Bangeagako Samaria distriküb fere güre nu erekobo yau oguraburaka baba fere gam taideaga. Nu baba fere kegeweaga, bana nub kob kürüna baba fereure kororabweaga. ");
INSERT INTO urw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nu baba fere iroto kümünadi, edi toi nub gam wel tugu wain mum tugu kubekubeiweaga, bangüdi korotaugeaga. Bangafotudi baba fere atügüdi, nugeab donki gam diferar gotogeaga. Bangüdi igaiudi guruwegi fata güre gam kümünadi, idadau fere baba taugeaga. ");
INSERT INTO urw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bana dü kuri gam kegeam silva aküre baba guruwegi fatab eme duweaga, bangüdi menüm waweaga, ‘Na meme fere idadau tauge. Meme fere taugüdi nagüb kegeam gürekoi namana ebgafotudiba, bana ye maig maigüdiba, maigabürneregün.’” ");
INSERT INTO urw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Bana Jisasde baba kabiab sibam fere menüm totoweaga, “Na aranüm utungun? Baba fere küi baba, wonide baba fere be ferewarde kogifuruwen babab bureiab bürebeaga?” ");
INSERT INTO urw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Bangar wageaga, “Fere nure kororabwar saguweaga baba fere.” Bangar Jisasde menüm waweaga, “Na kümünabenau, baba kabia sibenana ge.” ");
INSERT INTO urw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisasie daidaigegi simai keab kümünen, bangüdi kümüna fib güre gam taiden. Finege güre baba fib gamnab yanim nub Marta, nu Jisas igaiudi nugeab fata gam kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta nu mebe güre tugu, yanim nub Maria. Maria nu ogura Erekokaib kebe iroto gotogeaga, bangüdi dora nub edeaga. ");
INSERT INTO urw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Bangeagako, Marta nuge daba ekotagegib fünai gugub geaga babaure ututun toitoiweaga. Bangüdi Jisas gam kümünadi menüm waweaga, “Erekokai, maba yeb nu ye ebgaiadar igenakuana fanam daba ekotagün. Na babaure utungabge dag? Wawab ogura sagie.” ");
INSERT INTO urw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bangeagako Erekokaide dora nub menüm toweaga, “Marta, na daba daba gürenakutiure ututun toitoiudi kob kumun. ");
INSERT INTO urw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Na daba gürena fanamure ututunuge. Meme daba Mariade debüregeaga baba, kürüna nama fanam, babaure tageiburubge, nu daba nama debüregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jisas adab sibdibwabüreaga, sibdibwafotuwarbere, daidaigegi gürede menüm waweaga, “Erekokai, sibdib sarigabürüsige. Egime Jonüde nugeab daidaiwegi simai sarigabürüngeaga sibe.” ");
INSERT INTO urw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Bangar Jisasde menüm wangeaga, “Nini sibdibwebüreba, menüm doragane, ‘Sinib Emsig, yanim nab kedeb büreregeaga. Koroba nab ogureregeaga. ");
INSERT INTO urw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Dü gürenakuti gürena gürena gam daba sige, daba tugu dü babab gürena. ");
INSERT INTO urw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gürewarde sin gam menmengafaigen baba, sin unaigafaigenan. Babaure na sinib menmen toi unaigafotuge. Na banaka fururegi wagab sin gam taidebeagana.’ ” ");
INSERT INTO urw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Bangar Jisasde namana menüm wangeaga, “Fere güre ninag kodigo nu epeiab tugugarba, utumnonou kümüna epeiab baba menüm waweaga, ‘Mai, ye bret küi siebüregüdi na gam oguran, kurie maig toweregün. ");
INSERT INTO urw_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Igeab epeai güre ogura fata gam kaiar, daba kenegar na gam oguran.’ ");
INSERT INTO urw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bana bangar fere fata goime büreaga babade dora menüm towarba, ‘Na fünai siegena. Ye fub manage fürtaudi, mogoi keab kinfotuwenan, maig siradüdi daba daba dünegi siroiaga.’ Fere büreab gam dora banüm towebeagade? Kenenai. ");
INSERT INTO urw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ye wangün, fata eme siradüdiba, büreab daba daba gürenakuti kene baba, kiregüdi duweregeaga. Büreab kob kainanagamde saguwebüregarge. Kene. Amure, büreabüde igboroborowar siroiweregeaga babaure, bangeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Babaure ye wangün, ninag daba dabauregüdiba, sibdibubenar Keriab totowar dünügeregeaga. Nini daba daba fitakakaudiba, kegeweregenan. Nini fub poroporowarba, Keriabüde fub taibürüngeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Fere gürenakuti Keriabure sibdibwafaigen baba, nini daba daba kiregafaigen. Fere daba fitafaigeaga baba, kegefaigeaga. Fere fub poroporofaigeaga baba, Keriabüde fub taiburuafaigeaga. ");
INSERT INTO urw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ninagüngab mogoi gürede wagüdi, emüga wade güre siegüdi banüm eme totowarba, emede matu kogi güre duwebeagade, io? Kenenai. ");
INSERT INTO urw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bana mogoi gürede wagüdi, emüga wagib güre sie güdi banüm eme totowarba, emede makaras güre duwebeagade, io? Baba tugu kenenai. ");
INSERT INTO urw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nini mogoi emewar, kabia kogi fanam güfaigenanko, ninagüngab mogoi daba nama nama dünügegi nini idadau sibamgenan. Babaure, nini sibamgeregenan, ninagüngab Emnüg fib nama gam büreaga baba, ferewarde totowen baba, Etob Kedeb dünügebüre ebebearweregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisasde etob kogi güre fere güre gam bürüdi, fere babab sube gütüwataweaga baba etob kogi dufotuweaga. Etob kogi uriawarbere, baba sube güt baba dorageaga. Bangar ferefinabur kegeudi tergen. ");
INSERT INTO urw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bangeagako, fere gürekoide wagen, “Nu Belsebulrüb sogi gamde etob kogiwar kudengafaigeaga. Belsebul nu etob kogiwarüngab taba fere.” ");
INSERT INTO urw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bangar fere gürekoide, Jisas fururebürewadi, Jisas totowedi dora migu güre bera sibe idawebüre güdi totowen. Nu Keriabüb fünai geagade güdi sibamgebüre dora migu güre idawebüre totowen. ");
INSERT INTO urw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Bangeagako, Jisas ninib ututun sibamgeaga babaure, menüm wangeaga, “Kantri güre gamnab ferewar aküresari taidüdi waragediba, baba kantri nu koigeregeaga. Baba tugu, fata gin gürena gamnab fere simai aküresari taidüdi nuge nuge waragediba, baba fata gin koigeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ninagüde wagenan, ye Belsebulrüb sogi gamde etob kogi toi düfotugafaigün. Be Satanüb gin aküresari taidüdi nuge nuge karau karaugediba, Satan nu daba daba taugegi sogi tugu büreregarge. ");
INSERT INTO urw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Belsebulrüde sagiafaigeaga baba kainana garba, wonide ninag Israelüngab gin sagüngüdi etob kogi toi düfotugafaigen? Ninagüngab gindenana dora ninib baba, kainanage güdi abatarüngeregen. ");
INSERT INTO urw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bangeagako, Keriab nuge sogi siar etob kogi toi dufoturba, nini sibamgane, Keriabüb Koroba manage ninag gam ogurafotuweaga. ");
INSERT INTO urw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Fere güre sogi tugude keime maga aküresari sob banüm debetaudi fata nugeab taugarba, nub daba daba gürenakuti idadau büreregeaga. ");
INSERT INTO urw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Bangeagako, fere güre sogi ere tugude taidüdi fere baba küre waragüdi emegerwarba, fere babab marai daba daba gürenakuti kiregaderegeaga. Fere baba, marai daba daba baba bürar baba kekia biboudi sogi deaga. Bangüdi nub daba daba gürenakuti gürewar kabatangeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Fere yeb epeige baba, nu ye küre karaugafaigeaga. Fere ye sagüidi ferefinabur tobgafaigarge baba, nu ferefinabur daidaingar sarafaigen.” ");
INSERT INTO urw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jisas namana menüm wageaga, “Etob kogi fere güre baba ebgadüdiba, fib sabig gam kaberebüre kümünafaigeaga. Bangeagako, fib sabig gam büregi fib nama kegewargegarba, menüm wageregeaga, ‘Fata egime bürünwaib gam maigeregün.’ ");
INSERT INTO urw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bangüdi fata baba ina gasafotudi karün nama nama diferen baba kümüna kegeweregeaga. ");
INSERT INTO urw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Babaure nu kümüna etob kogi toi nonob tugu nuge kabia kogi güfaigeaga baba, emegerwegiwar igaingeregeaga. Bangüdi fata baba gam irudi büreregen. Egime fere nub gotogegi kogi baba erege, mügarba, kürüna erekokaigeregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ferefinabur epüra büren sese gam, Jisasde dora pitoiaga. Baba ferefinabur kodigo, finege gürede menüm yogeaga, “Finege nag sinoidi ebe düneaga baba, nu ebebearweregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bangeagako, Jisasde wageaga, “Banümgena, menüm wagegi, ferewar Keriabüb dora edüdi daiwen baba, nini ebebearweregen.” ");
INSERT INTO urw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ferefinabur epüra Jisas gam namanana oguradaiwen, bangar Jisasde menüm wangeaga, “Meme sese gamnab ferefinabur nini kogi. Ye Keriabüb fünai günde kene baba sibamgebüre, bera güre kegewebüre yogen. Bangeagako, nini bera güre kegeweregedige. Bera gürenakuana kegeweregen baba, kiari fere Jonab bera gürena. ");
INSERT INTO urw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona nu egime bera sibe Keriabüde Ninive fib ereb ferewar abatarüngeaganwaib. Banüm gürena meme sese gamnab ferefinabur gam, Fereb Nono nu, Keriabüde bera sibe abatarüngeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Keriabüde ferefinabur dora gam difürüngegi dü uruageaga gam, Sebayaub finege erekokayau nu dora gam biboweregeaga. Bangüdi meme sese gamnab ferefinaburüngab kabia kogiure dorageregeaga. Amure, baba finege erekokayau nu, kürüna kütüb büreagako, Solomonde nugeab sibam nama pitoiaga baba edebüre Israel ogureaga. Bangeagako, fere güre mügar meag büreaga baba nu Solomonüb sibam kürüna emegerweaga. ");
INSERT INTO urw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Keriabüde ferefinabur dora gam difürüngeaga gam, Niniveb ferewar dora gam biboweregen. Bangüdi meme sese gamnab ferefinaburüngab kabia kogiure dorageregen. Amure, Ninivewar nini Jonade dora pitoiaga baba edüdi kob piruwen. Bangeagako, fere güre mügar meag büreaga baba, nu Jona kürüna emegerweaga.” ");
INSERT INTO urw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jisasde namana menüm wageaga, “Fere meram furuadüdi ub güre fata gadi gamde, ede sumo saka tormogataugafaigedige. Tag kekia diferedi, fere fata gam iruweregen baba, meram baba kegeweregen. ");
INSERT INTO urw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ege nagüb baba, nagüb mubeb nan sibe. Ege nagüb nama garba, mube nab meramgeregeaga. Banüm gürena, ege nab kogi garba, mube nab gituwataweregeaga. ");
INSERT INTO urw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Babaure idadau tauge, meram nag gam büreaga baba, kumatauneregeaga banai. ");
INSERT INTO urw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mube nagüb gituwegi fanam kene, gürenakuti meramgabowarba, bana mube nagüb nan meramde noregi sibe gürenakuti meramgaboweregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisas dora pitaifotuwarbere, Farisi gürede, ogura nugeküre daba nebüregüdi totoweaga. Bangar Jisas fata gam iruwaboudi gotogeaga. ");
INSERT INTO urw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisi baba Jisas kegeweaga baba, gotogüdi daba neaga. Amure, yag fidfotudi daba nargegar, ututun toitoiweaga. ");
INSERT INTO urw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bangeagako, Erekokaide menüm waweaga, “Nini Farisiwar, yag negi noi tugu fade tugu nigeyau baba idadau gasafaigenan. Bangeagako, gama gam ba, be kabia tugu kabia kogkogi nini gam gobeaga. ");
INSERT INTO urw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nini susukuna ferewar! Fere daba daba obgoira idaweaga baba, gama gam tugu idaidaweaga. ");
INSERT INTO urw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bangeagako, daba daba fade gam büren baba, fere daba daba sigagen baba dünügane, bangar baba daba dabade sagüngeregen. Nini bangeregenan baba, ninagüngab daba daba gürenakuti urun büreregegin. ");
INSERT INTO urw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Farisiwar nini dabnanai. Küm gamnab yar fanam fanam tugu sau tugu tobtobgafaigenan baba, tob fogo tugu taibürügafaigenan. Bangüdi tob gürenakuana fanam baba, Keriab duwafaigen. Bangeagako, ninag Keriab kob duwegi kabia tugu kabia nama tugu, ebgadügafaigenan. Babaure nini mügar Keriab kob duwegi kabiaure sogiferane, kabia nama gebüre tugu sogiferane. Bangüdi küm gamnab yar fanam fanam tugu sau tugu, Keriab duwegi kabiaure kagudwagana. ");
INSERT INTO urw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Farisiwar nini dabnana. Nini kunube fata gam gotogegi kur agferegi baba gam gotogebüregüfaigenan. Bangüdi guruwegi gam ferefinabur ninag fereberengebüregüdi güfaigenan. ");
INSERT INTO urw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Nini dabnanai. Nini ferefib gam kadabura ara orbürügedige gar ferede ara sibamgedige sibe. Bangar baba ferefib kekia urikasawedi Keriabüb ege gam tig tugu büregi sibe.” ");
INSERT INTO urw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kabiab sibam fere güre dora baba edüdi Jisas menüm waweaga, “Sibam sarigegi, na Farisiwar gam dora babanüm gün baba, na sin tugu kogifürüsigün.” ");
INSERT INTO urw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Bangar Jisasde wageaga, “Kabiab sibam ferewar nini tugu dabnana. Nini daba daba kub tugu degi kabia sibe genan, bangüdi ferewar dünügenan, bangar kemeiegi dirugungeaga. Bangeagako, ninagüde fanam kube magi güre difürüdi, kub toi baba sagüngüdi kemeifaigarge. ");
INSERT INTO urw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Nini dabnana. Matananügmanade kiari ferewar kiasorungedi kugumgenwaib, bangar nini baba kiari ferewarüngab ferefib karün nübürüngafaigenan. ");
INSERT INTO urw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ninag matananügmanade fere kiangegi kabia abatarungedi, ninagüde nama kabia güdi maig gürewar abatarüngafaigenan. Bangar ninagüde ferefib karün nübürüngafaigenan. Amure, matananügmanade kiari ferewar kiasorungedi kugumgen. ");
INSERT INTO urw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Keriabüb ututun nama surur baba menüm wageaga, ‘Ye kiari ferewar tugu dora turewegi ferewar tugu sugurungür baba ferewar gam kümüneregen. Bangar ferewarde, gürekoi kogifürüngüdi kiasorungedi kugumgeregen.’ ");
INSERT INTO urw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Babaure kiari ferewar kiasorungen baba ferewarüngab menmen baba, Keriabüde kübüdim meme taibereaga sese gamnana toadüdi ogura mügar taideaga. Baba menmen baba, mügarüb ferefinabur gam büreregeaga, bangar baba menmenüb kub kaiweregen. ");
INSERT INTO urw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kiari ferewar kiasorungen baba, Abel gamde tuadüdi ogura Sekaraia gam kenegen. Baba fere nu bai feregi kur tugu Keriabüb fata kodigo orfotuwen. Io, ye wangün, baba kabia kogi gürenakutib mur kogi baba, ferefinabur mügar büren baba gam taideregeaga. ");
INSERT INTO urw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kabiab sibam ferewar nini, dabnana. Sibam kümüna degi fubu gamnab ki manage ninag dufotuwenan. Ninagba fib baba gam kümünegi uruwenanko, ferefinabur gürewar irudi sibam debüregen baba, ninagüde ninib erekobo gütüwatawenan.” ");
INSERT INTO urw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Bana Jisas fata nuge büreaga baba ebgadeaga. Bangar kabiab sibam ferewarie Farisiwar keab Jisasure kob koigen, bangüdi toto eib eib totowen. ");
INSERT INTO urw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Sarabewedi dora güre namage maig towar, dora gam diferebüregüdi, toto totowen. ");
INSERT INTO urw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tausen tugu ferefinabur ogura guruwedi, fib kürüna gütügar, nuge nuge kebe bitobaitawanagegi sibe büreaga. Bangar Jisas nugeab daidaigegi simai gam kese dora menüm pitoiaga, “Nini Farisiwarüngab yisure dabnana. Kiou kabia ninibure wagün. ");
INSERT INTO urw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Baba daba gürenakuti kotobata büreaga baba, agüba tataigeregen. Bangar iwagegi dora gürenakuti baba, fere sibamgeregen. ");
INSERT INTO urw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Babaure, ninag dora gürenakuti utumnonou doragenanwaib baba, ferefinabur sida tugu ederegen. Dora gürenakuti ninag dab fanam fata goime doragenanwaib baba, fata kekia biboudi ferefinabur gam pitoieregen.” ");
INSERT INTO urw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jisas namana menüm wageaga, “Yeb mai sob, ye menüm wangün. Nini ferewar mube gürena orfotugafaigüdi, kuri am daba güre maig gegi kenewar babaure, kimigagana. ");
INSERT INTO urw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bangeagako, ninag wonurenana dag kimigaga babaure, ye wanügebüregün. Nini Keriabure kimigane. Keriab nu fere orfotudiba, fere baba keb gam fotuwegi nu yanim tugu. Ye kainana wangün, nini Keriabure kimigane. ");
INSERT INTO urw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ninag sibam, fere nini aküre magi fanam gamde, ai fanam fanam taba tugu murgafaigen. Bangar Keriab nu baba ai toi, güre fanamure kaguduafaigarge. ");
INSERT INTO urw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Baba tugu, Keriab ninagüb taba sara toi gürenakuti ninaifotuweaga, bangüdi ninag idadau sibamgeaga. Babaure, nini kimigagana. Keriab ninag taungeaga baba, ai toi fanam fanam taungegi kabia emegerweaga. Babaure nini ai fanam fanam epüra emegerüngarge.” ");
INSERT INTO urw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jisas namana menüm wageaga, “Ye wangün, fere nu yeb gin gam bürüngüdi banüm ferefinabur wangarba, Fereb Nono nu tugu, fere baba nugeabgüdi, Keriabüb dora dugurewegi simai banüm wangeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Bangeagako, fere nu yeb gin gamnabge güdi banüm ferefinabur wangarba, ye tugu nu yeb gegüdi banüm Keriabüb dora dugurewegi simai wangere. ");
INSERT INTO urw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Fere nu Fereb Nonoküre dora maraigüdiba, Keriabüde menmen nub baba unaigafotuweregeaga. Fere nu Etob Kedeb nenudiba, Keriab nub menmen baba unaigafotuweregarge. ");
INSERT INTO urw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Bana kunube fata gagam tugu, kübüdim bera taugegi gagam tugu fere yanim tutug gam yatangüdi kümünediba, bana kimgüdi menüm utungagana, ‘Sin dora aranüm maig toweregenan? Sin dora aranüm doragübügo?’ Kenenai. ");
INSERT INTO urw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Baba sese gamnana Etob Kedebüde dora nini gam maig towegi baba abatarüngeregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ferefinabur gin ere baba kodigo, fere gürede Jisas menüm waweaga, “Sibam sarigegi, emüga yeb manage kumeaga, babaure nade igeab awai wawab daba daba emügade ureadi kümüneaga baba, kabataudi güresari siebüregüdigün.” ");
INSERT INTO urw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Bangeagako, Jisasde totoweaga, “Aranüm? Ye ninaküreb dora nanaregi tugu daba daba kabatagegi tugu fere bürürge.” ");
INSERT INTO urw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Bangüdi ferefinabur menüm wangeaga, “Nini dabnana kege kegeudi bürane. Nini irimsorum daba daba kiregebüre ege neregenan banai. Nag daba daba epürage tuguko, baba daba daba nagüb sibe gotogegi nama deregabge.” ");
INSERT INTO urw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Bangar Jisas nini gam komina dora güre menüm pitoiaga, “Kegenam fere güreb küm gam daba epüra fanam ferarge. ");
INSERT INTO urw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Bangar fere baba arangüigüdi, banüm utungeaga, ‘Igeab daba gürenakuti sapagegi baba, igeab daba fata baba towarge.’ ");
INSERT INTO urw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Bangar menüm wageaga, ‘Igeab daba fata toi gürenakuti esuafotugüdi, fata ere ere tuweregün, banguidagugüdi utungeaga. Bangüdi igeab wit magi gürenakuti tugu igeab daba daba nama baba fata toi gam sapagere. ");
INSERT INTO urw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Bangar igeure menüm wageregün. Ye kümdan toi degib daba daba nama epüra fanam tobgafotun. Bana mügar kabereregün. Bangüdi kobe erekokai bata kobegüdi daba yag nüdi ebebearuabüreregün.’ ");
INSERT INTO urw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Bangar Keriabüde menüm waweaga, ‘Na kürüna nanauro fere. Na mügar meme utumnonounana kumeregün. Bangar nag daba daba gürenakuti dugutuafotunwaib baba, wonide debeaga?’” ");
INSERT INTO urw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Bangar Jisasde wageaga, “Baba daba fere nugengab daba daba tobgafaigen baba gam taideregeaga, bangeagako, Keriabüb ege gam koigeb büren.” ");
INSERT INTO urw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Bana bangar Jisas nugeab daidaigegi simai wangeaga, “Ye menüm wangün, nini komina dora baba utungübenar, ninagüb gotogegi namaure ututungüdi am daba nübügogüdi, banüm doragagana. Baba tugu ninagüngab ututun toitoiudi mube gam am ude dagübugogüdi, banüm doragagana. ");
INSERT INTO urw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gotogegi nama nu daba negib daba gürenage, baba tugu mube nu ude dagegib daba gürenage. ");
INSERT INTO urw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Arokwar utungane, nini daba orfaigedige, daba tobugafaigedige. Nini daba fata kene, daba daba sapagegi fata kene. Bangeagako, Keriabüde daba dünügafaigeaga. Bana ferefinabur niniba, ai toi kürüna emegerüngenan. ");
INSERT INTO urw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nini gam güre, idadau büregib kabiaure ututun toitoiwarba, baba ututun toitoiwegib kabiade nugeab gotogegi namab sese baba, fanam buruwaurebeagade? Kenenai. ");
INSERT INTO urw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Bana ninagüngab ututun toitoiwegib kabiade, ninagüb gotogegib sese fanam buruwaurebeagade? Kenegarba, nini amure daba güregüreure kürüna ututun toitoiwenan? ");
INSERT INTO urw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Nini kakas toi idadau kegewane, aranümdag tataigen. Nini bikidefaigedige. Nini ude idafaigedige. Bangeagako, ye wangün, egime erekokayau Solomon nugeab karün nama nama gürenakuti enfaigeaga, bangeagako, kakas toi nama babab karünde Solomonüb karün kürüna emegerweaga. ");
INSERT INTO urw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mügar baba sibir toi meag bag büreaga baba, kiarigenana ferede kitkatüdi keb gam fobotgeregen. Ug sibir sibir baba, Keriabüde karün nübürüngafaigeaga. Babaure, ferefinabur nini kob kainana fanamere tugu baba, nini menüm utungane, ninag tugu Keriabüde karün nama nama, nübürüngeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Babaure, nini am daba nüb, am yag nübügüdi, kororabgüdi banüm ututun toitoiwagana. ");
INSERT INTO urw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kübüdim gamnab ferefinabur gürenakuti, daba daba babanüm fitaudi kororabgafaigen. Bangeagako, ninagüngab emnüg nu sibamgafotuweaga, nini baba daba daba deregenan. ");
INSERT INTO urw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Babaure nini Keriab uruwar ninagüngab erekokayau büregi utun dar, nugede korobangeregeaga. Bangüdi baba daba daba tugu dünügeregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jisas namana menüm wageaga, “Nini sipsip gin fanamere, nini kimigagana. Ninagüngab emnüg, nu ninagüngab erekokayau bürüdi, ninag igaingüdi nugeab koroba gam bürebüregüdi doragafotuweaga. ");
INSERT INTO urw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nini uruwar ferewarde ninagüngab daba daba gürenakuti murugedi, baba kegeam, fere daba daba kene babawar dünügane. Nini kegeam far koigafaigarge babanüm dane, bangüdi fib nama gamnab daba nama nama tobgane. Fib nama gam, daba daba kenegafaigarge, be ferede düfaigedige, sam kokogide daba daba kogifuruwafaigedige. ");
INSERT INTO urw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ninagüngab daba nama nama arag arag dag büreaga baba, baba fib gam gürena ututun ninagüngab tugu büreregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jisas namana menüm wageaga, “Nini ude ninagüngab sigagabürügübenar, sogsogi dagane, bangüdi nan furudi, bigsaisaiudi bürane. ");
INSERT INTO urw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Fere güre finege degib dü gam, eregeam güre büreregeaga, finege degib dü baba gam, kobe ere kobegedi eregeam baba daba nifotudi, ureadi maig ogurebüregar sarua ferewarde momofaigen baba ferewar sibe, nini bürane. Nu ogura fub poraurarba, pirikanana fub taifotuweregen. ");
INSERT INTO urw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Eregeam oguradi nugeab sarua mogoi toi ara kinedi kegengarba, bana baba sarua mogoi toi nini ebebearweregen. Ye nini gam kainana wagün, eregeam nugede, nugeab ude sigagabürüdi sogsogi dageregeaga, bangüdi wanügar daba nebüre kurebdir kinbougeregegin. Bangar nugede oguradi daba dünügeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bana eregeam sigerügde, kuaida omonana doragegin sese gam oguradi, sarua mogoi toi kegengar ara kinedigegarba, baba sarua mogoi toi nini ebebearweregen. ");
INSERT INTO urw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Nini daba baba utungane. Fata eme, be fere oguregi sese nu sibamgüdiba, nu be fere baba euwar fata nugeab gogudi iruweregarge. ");
INSERT INTO urw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nini tugu bigsaisaiwane. Fereb Nono nu ogureregargegüdi utungeregenan baba sese gam, nu ogureregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitade Jisas menüm totoweaga, “Erekokai, komina dora baba sin gürena sigünde, ede ferewar gürenakuti gam tugude?” ");
INSERT INTO urw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bangar Erekokaide menüm wageaga, “Am taugegi nu ututun nama tugu, fünai nugeab tugu nama güfaigeaga, baba fere, eregeam nu taugegi babanüm, sarua mogoi toi nugeab taugebüre uruagafaigeaga. Bangüdi eregeamde daba negi sese uruageaga baba sese gamnana, taugegide sarua mogoi toi gam tugu daba agüregeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Sarua mogoi babanüm baba, nu saruwagabürarbere, eregeam nugeab maig ogura kegeweregeaga baba sese gam, nu ebebearweregeaga. ");
INSERT INTO urw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ye nini gam kainana wagün, eregeam nugeab daba daba gürenakuti taugegi, sarua mogoi baba uruageregeaga. ");
INSERT INTO urw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Bangeagako, baba sarua mogoi menüm utungeaga, ‘Igeab Eregeam pirika ogureregargegüdi,’ sarua mogoi gürekoi tugu sarua finabur tugu kiasorungeaga. Bangüdi daba tugu yag tugu nüdi nanaurogeaga. ");
INSERT INTO urw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Bana sarua mogoi baba dü güre gam ara bigsaisaigarbere, eregeam ogureregeaga, baba tugu, sese güre gam ara sibamgarbere ogureregeaga. Bangar eregeamde sarua mogoi baba kürüna kogifurudi, fere simai dora ara edibe wegi simai keab difereregeaga. ");
INSERT INTO urw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Sarua mogoi güre nugeab eregeamüb ututun sibamgafotuweaga. Bangeagako, daba daba dugutuwarge tugu, eregeam nugeab ututun tugu daiwarge baba, eregeamde sogsogi oreregeaga. ");
INSERT INTO urw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bangeagako, sarua mogoi güre baba, eregeamüb ututun sibamgarge baba, gege degi kabia geaga, bangeagako, eregeamde fanamere oreregeaga. Fere gürenakuti daba daba epüra fanam deginwaib baba, nini daba daba epüra fanam maig toweregegin. Fere gürenakuti fere güreb kube gam daba daba epüra fanam diferegin baba, bana wawedi maig daba daba epüra fanam namana maig toweregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jisas namana menüm wageaga, “Ye kübüdim gam keb fotuwebüre oguranwaib, bangar keb baba pirikanana burirwebüre utungun. ");
INSERT INTO urw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ye yag fidegi gürena babanüm deregün. Mügar durge. Ye kob darab tugu bürüdi kümüna, baba daba taidarie.” Jisas yag fidegi babaure dorageaga baba, nuge kubude korotauweregeaga babaure komina dorageaga. ");
INSERT INTO urw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Jisas namana menüm wageaga, “Nini banaka yeme kübüdim gam marai gürenakuti kumafotuwebüre ogureaga güdi utungeregenan. Kene. Ye wangün, ye ferefinabur aküresari pitaigebüre oguran. ");
INSERT INTO urw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mügar tugu kuri tugu, mogoi gin gürena gamnab taba tugu fata gürena gam bürediba, bana nini gin aküresari pitaigeregegin. Küide aküre gam karaugeregegin, akürede küi gam karaugeregegin. ");
INSERT INTO urw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Pitaigeregegin, emede nugeab nono küre karaugeregeaga, bangar nonode eme küre karaugeregeaga. Bana anade mege küre karaugeregeaga, bangar megede anaküre karaugeregeaga. Fere güreb anade fere babab fiaküre karaugeregeaga, bangar finegede kabüb anaküre karaugeregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jisasde ferefinabur epüra fananam menüm wangeaga, “Ninag sida kanegiyau fiou korowar kegeudiba, ninag pirikanana wagfaigenan, ‘Yag ogurebüregeaga.’ Bangar kürünana yag ogurafaigeaga. ");
INSERT INTO urw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ninag sautüb kübür sogi siradar kegeudiba, wagfaigenan, ‘Mügar sida füg büreregeaga.’ Bangar kürüna sida füg bürfaigeaga. ");
INSERT INTO urw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nini kioutuka fere simai, nini daba daba kübüdim gam tugu magadi gam tugu tataigafaigeaga baba idadau nanafaigenan. Bangeagako, am dabaure, nini mügar meme sese gam daba daba tataigeaga baba nanafaigegi kabia sibamgarge?” ");
INSERT INTO urw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jisas namana menüm wageaga, “Be ninag am dabaure idadau ututun nama degi kene, am kabia nama nama baba namade kogi baba nanafaigarge? ");
INSERT INTO urw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Na fere güre nag dora gam diferebüregeaga, baba fere küre urigüdi kümünadiba, ninagküre erekobo gam kümünad kümünadiba, nuküre fanam dora idaure. Banaka burunüdi jas gam kümünar, jasüde mamüb kube gam difürünar, mamüde igainüdi kakia fata gam iruwabereregeaga babaure. ");
INSERT INTO urw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ye wanün, na kakia fata gam bürübenana, kegeam uruagen baba, na gürenakuti murugafotuabie, euneregen.” ");
INSERT INTO urw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jisas dora pitaifotuwarbere, fere gürekoide, Galili distriküb ferewarure Jisas gam dora mangen. Pailatüde nugeab maraipapawar wanügar, ferewar Keriabure bai feren baba sese gam, kiasorungen baba dora mangen. Bangar kagi ninib dür bai feregib kagi kekia edogeaga. ");
INSERT INTO urw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Bangar Jisasde menüm wangeaga, “Nini aranüm utungenan, Galili distriküb ferewar, kugumgen baba, menmen ninibüde Galili gürekoib menmen emegerüngeagade? Bangar baba daba kogi baba, ferewar gam taideaga babab ginimde, io? ");
INSERT INTO urw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kürüna kene. Ye wangün, nini kob piruwargegarba, kabia babanüm gürena ninag gürenakuti gam taideregeaga. ");
INSERT INTO urw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bana ferewar gürena bede fogo düm egime Jerusalemüb fib fanam Siloam gen bag kekia fata baba pokudi korotaungar kugumgen baba, nini aranüm utungenan, ferewar fata pokudi korotaungeaga baba ferewarüngab menmende ferewar gürekoi Jerusalem büren babawarüngab menmen emegerweagade, io? ");
INSERT INTO urw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kürüna kene. Ye wangün, nini kob piruwargegarba, kabia babanüm gürena ninag gürenakuti gam taideregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Bana Jisasde komina dora güre menüm pitoiaga, “Fere güre nugeab wain küm gam, au kurab güre orbereaganwaib, bangafotudi kuri kurab magi magi fitawebüre baba au bara gam ogureaga. Bangeagako, güre fanam kegewarge. ");
INSERT INTO urw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Babaure, küm gamnab sarua fere menüm waweaga, ‘Edün. Kurab magi fitawebüre au meme gam kümdan küi oguran, bangeagako, magi ferarge. Babaure, na au meme katafotuwe. Amure kübüdimüb kidam uguna kenegafotuweaga.’ ");
INSERT INTO urw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Bangar sarua ferede dora nub menüm toweaga, ‘Eregeam, uruab kümdan gürena meme fanam bururarie. Bara gam kübüdim pusudi bulmakaub sib difereregün. ");
INSERT INTO urw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kümdan güre baba gam nama ferebeagadag. Kene garba, bana katafotuwe.’” ");
INSERT INTO urw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Israelüngab Dü Kaberegi gam, Jisasde kunube fata güre gam, ferefinabur dora sarigabürüngeaga. ");
INSERT INTO urw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Baba gam, finege güre büreaga, etob kogi güre nu gam büreaga. Bangar baba etob kogide subo duwar, kümdan 18 büreaga. Babaure, finege babab gom dagar kuarigeaga, bangar idadau bibowegi dirugweaga. ");
INSERT INTO urw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisasde finege baba kegeudi, yagwar oguradi, menüm waweaga, “Finege, ye nab subo namabürün.” ");
INSERT INTO urw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Bangüdi finege baba kekia kube diferar, finege baba pirikanana idadau biboweaga, bangar Keriabüb yanim siradgabereaga. ");
INSERT INTO urw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bangeagako, kunube fatab taba fere nu, Jisasde finege baba Dü Kaberegi gam namabereaga babaure Jisasure magiraweaga. Bangar taba ferede ferefinabur menüm wangeaga, “Fünaiwegi dü kubete tugu. Nini ferede ninagüngab subo namabürügebüre güdiba, fünaiwegi dü gam ogurane. Banaka Dü Kaberegi gam subo ninagüngab namabürügebüre, fere güre totouagana.” ");
INSERT INTO urw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bana Erekokaide taba fereb dora menüm toweaga, “Nini kioutuka ferewar. Dora ninib tugu kabia ninib tugu gürenage. Dü kaberegi gam, ninag gürenakuti bulmakaub fata gam kümünadi, bulmakau toi tugu donki toi ninagüngab subaifotugafaigüdi, yag nebüre igaingüdi kümünafaigenan. ");
INSERT INTO urw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Bangeagako, finege meme, nu Abrahamüb matanab. Bangar Satande kümdan 18 wartawar büreaga. Bana aranüm? Ye baba dabade finege meme wartaweaga baba namaburuwebüre, Dü Kaberegi gam geregürgede, io?” ");
INSERT INTO urw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Banüm wagar, nugeab karauiabmana kürüna maiagen. Bangar ferefinabur gürenakuti, baba kabia nama nama gürenakuti geaga babaure ebebearwegin. ");
INSERT INTO urw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisasde namana menüm wageaga, “Keriabüb Koroba am daba sibe? Komina dora aranüm güi? ");
INSERT INTO urw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nu sau mastet gen babab magi sibe. Fere gürede mastetüb magi düdi nugeab küm gam oreaga. Bangar kuri mastet baba au sibe erekokaigar, ai toide ogura nub kube gagam deab feren.” ");
INSERT INTO urw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Bangar Jisasde namana menüm wageaga, “Keriabüb Korobaure komina dora aranüm güi? ");
INSERT INTO urw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nu yis sibe. Finege gürede plaua far güre wagwagwafotudi yis baba düdi plaua tugu pirparweaga. Bangar kuri baba plaua gürenakuti dündünweaga.” ");
INSERT INTO urw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisas Jerusalemüb erekoboyau kümünad kümünadi, fib ere ere gagam tugu fib gagam tugu kümünadi ferefinabur dora sarigabürüngeaga. ");
INSERT INTO urw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Bangar fere gürede menüm waweaga, “Erekokai, Keriab fere gürena gürena maig igaingebeaga dag?” Bangar Jisasde menüm wangeaga, ");
INSERT INTO urw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nini kudumege fanam gam iruwebüre, sogi ken biane. Ye wangün, fere epüra iruwebüregenko, dirugungeaga. ");
INSERT INTO urw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kuri fata eme siradüdi, fub fürtauweregeaga. Bangar nini ogura obugo biboudi fub poroudi menüm yogeregenan, ‘Erekokai, fub taibürüsige.’ Bangar nini gam dora menüm toweregeaga, ‘Ye nini sibamgürge, nini aragüb.’ ");
INSERT INTO urw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Bangar ninagüde menüm waweregenan, ‘Sini na keab daba tugu yag tugu nenanwaib. Bangüdi nag sinib erekobo gam biboudi sarigabürüsigün.’ ");
INSERT INTO urw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Bangeagako, menüm wangeregeaga, ‘Ye nini sibamgürge, nini aragüb. Nini kabia kogi gügab ferewar, nini gürenakuti ye gam segane.’ ");
INSERT INTO urw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nini Abraham tugu Aisak tugu Jekop tugu kegengeregenan, baba tugu kiari ferewar gürenakuti Keriabüb Koroba gam büren babawar tugu. Bangeagako, Ninagba, kudengedi obugo büreregenan. Bangar ninag mürüdi maga gürtata büreregenan. ");
INSERT INTO urw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bangar ferefinabur kantri toi sida mowegiyau, sida kanegiyau, notyau, sautyau tugu, nugengab fib ebgagaiudi, oguradi, Keriabüb Koroba gam daba nebüre gotogeregen. ");
INSERT INTO urw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Bana edane. Fere gürekoi mügar kürüna kuri büren baba, nini keseweregen. Fere gürekoi mügar nini kesewen baba, nini kürüna kuri büreregen.” ");
INSERT INTO urw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Baba sese gamnana Farisi gürekoi oguradi, Jisas menüm wawen, “Na fib meme ebgadibe gürekum kümüne, amure, Herotüde norfotuwebüregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Bangar Jisasde menüm wangeaga, “Nini kümüna dugumob mam kogi baba menüm wawane, ‘Mügar kiarige etob kogi toi difotugüdi subo ferewar namabürügere. Dü küi gam ba igeab fünai kenegafotuweregün.’ ");
INSERT INTO urw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bangeagako, mügar, kiarige, ba kiarige, ye urigüdi kümüneregün. Amure, kiari fere fib güre gam bürarbere, orfotuebena. Kene. Jerusalem gam gürena orfotuweregen. ");
INSERT INTO urw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem, na kiari ferewar kiasorungafaigün. Na bangüdi ferewar Keriabüde nag gam sugurungar ogurafaigen baba, kiasorungebüre kegenam saka kurtongafaigün. Kuaida ana nugeab sab sige fara korobangafaigeaga baba sibe, ye epüra bede namana nab mogoi toi korabangebüregün. Bangeagako, nini uruwenan. ");
INSERT INTO urw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Edane. Mügar fib ninib koigüdi uguna büreregeaga. Ye wagün, nini kegeieregarge. Nini ara kegeiegi sese gam menüm wageregenan, ‘Keriab fere meme gam nama geregeaga. Kümüna kümüna Erekokaib yanim gamde ogureregeaga baba sese gamie maig,’ kegeieregenan.” ");
INSERT INTO urw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Israelüngab Dü Kaberegi güre gam, Jisas kümüna Farisiwarüngab taba fere güreb fata gam daba neaga. Bangar idadau taugen. ");
INSERT INTO urw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Bangar fere güre mube nub adagabereaga baba, nu Jisas iroto büreaga. ");
INSERT INTO urw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jisas fere baba kegeabürüdi, kabiab sibam ferewarie Farisiwar keab menüm totongeaga, “Dü kaberegi gam subo ferewar ida idangübüde kenedag?” ");
INSERT INTO urw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bangeagako, nini sube gütudi dora maig towedige. Bangar fere baba igaiudi, namabürüdi uruwar kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Bangafotudi menüm wangeaga, “Ninag kodigo Dü Kaberegi gam fere güreb nonode bulmakau dag yag ubroime kanarba, nonode bulmakau baba pirikanana buruwar mouebeagade kene?” ");
INSERT INTO urw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bangar nini dora baba maig towegi dirugungeaga. ");
INSERT INTO urw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas ferewar baba daba negi gam oguredi kegengeaga baba, gotogegi kur agferegi gam gürena gotogebüregegin. Bangar komina dora güre dünügeaga. Menüm wageaga, ");
INSERT INTO urw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Fere gürede finege degib kobe erekokai gam yagünar na kümünadiba, kur agferegi baba gam gotogegena, güregüdi kur baba fere güre yanim ere tugu, nab yanim emegerwegib uruagedi büreregeaga. ");
INSERT INTO urw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Bangar kuri fere yagüneaga baba fere de, oguradi menüm waneregeaga, ‘Na kur agferegi meme, fere meme duwe.’ Bangar nagna maiagüdi kümüna kürüna kuri gotogeregün. ");
INSERT INTO urw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Babaure, na fere gürede dabaure yagunar kümünadiba, na kürüna kuri gotoge. Bangabba, fere yagüneaga babade oguradi waneregeaga, ‘Mai, na ogura kur agferegi meme gam gotoge.’ Nu bangarba, ferewar nag keab daba nen babawarüngab ege gam, nag yanim erekokai deregün. ");
INSERT INTO urw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Fere nugede nugeab yanim siradgabereaga baba, Keriabüde nub yanim obgogabereregeaga, bangeagako fere nugeab yanim obgogabereaga baba, Keriabüde nub yanim kekia asau siradgabereregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jisasde, fere nuge yaguwar daba negi gam ogureaga baba fere, menüm waweaga, “Na daba güre kobegüdiba, nagüb fib gamnab büreanmana, awanmana, mabünmana, ginianmana tugu nagüb fib büreanmana tugu kegeam ere ere tutug baba yagüngegena. Kuri nag tugu yagnedi kümüna fata ninib gam daba nüduen banai. Bangüdi daba nag gam maig toweregegin. ");
INSERT INTO urw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Baba kene. Na daba erekokai kobegüdiba, bana kororab ferewar, mube koigegi ferewar, tugu kebe kogi, ege kumkumwar yagünge. ");
INSERT INTO urw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Fere babanümwar, nini daba nag gam maig toweregedige. Bangar nag ebebearweregün, amure, kuri surur ferewar ferefib gam siradegi sese gam, Keriabüdeie nag gam daba baba maig toweregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Baba ferewar gamnab fere güre, Jisas keab daba neaga baba, dora baba edüdi Jisas menüm waweaga, “Ferefinabur Keriabüb Koroba gam gotogüdi daba neregen baba, nini ebebearweregegin.” ");
INSERT INTO urw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Bangeagako, Jisasde menüm waweaga, “Fere güre kobe erekokai kobegebürewadi, fere epürafanam yagüngar baba kobe gam ogurebüreba. ");
INSERT INTO urw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bana nuge kobe baba kobegegi dü uruageaga gam, nugeab sarua mogoi wawar, ferewar nuge egime yagüngeaga babawar gam kümünebüregüdi waweaga. Bangüdi sarua mogoide menüm wangeregeaga, ‘Nini ogurane. Daba daba gürenakuti dugutuafotuweaga.’ ");
INSERT INTO urw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bangeagako, baba ferewar wagen, ‘Kümüneregüdarge.’ Fere gürede wageaga, ‘Ye küm güre murugafotun, babaure kümüna kegeweregün. Kororab tugu, ogureregürge.’ ");
INSERT INTO urw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Bangar gürede wageaga, ‘Kororab tugu, ogureregürge. Ye saruagegib bulmakau fogo tugu murgun. Babaure kümüna sarua dünügaurebüregün.’ ");
INSERT INTO urw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Bangar gürede wageaga, ‘Ye müganana meme finege dün. Babaure ogureregürge.’ ");
INSERT INTO urw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Bana, sarua mogoi baba baba dora edüdi nugeab eregeam gam maigeaga. Eregeam baba baba dora edüdi magirawar, nugeab sarua mogoi menüm waweaga, ‘Na fib ere babab erekobo ere ere gürenakuti gam tugu erekobo fanam fanam gürenakuti gam tugu kümünagere. Bangüdi kororab ferewar tugu, fere mube kogkogiwar tugu, ege kumkum, kebe kogkogi ferewar tugu, igaingüdi igeab fata gam ogura iruwane.’ ");
INSERT INTO urw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Bana sarua mogoi bangafotudi wageaga, ‘Eregeam, nag wagün sibe güfotunko, fata gobarge.’ ");
INSERT INTO urw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Bangar eregeamde sarua mogoi menüm waweaga, ‘Na fib ere ebgadibe, erekobo ere ere gürenakuti gam tugu küm toib güb kureb tugu daidaiwe. Bangüdi ferefinabur kirarüngüdiba, sogsogi wangab yeb daba gam ogureregegin. Ye fata gobebürewadigün. ");
INSERT INTO urw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ye wangün, baba ferewar egime yagüngün baba, nini gürenakuti yeb daba makita fanam neregedige.’” ");
INSERT INTO urw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ferefinabur gin ere Jisas daiwen, bangar piruaboudi menüm wangeaga, ");
INSERT INTO urw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Fere ye gam ogurebüreba, nugeab eme ana, fia mogoi toi tugu mebemana ugemana tugu nugeab gotogegure tugu kob kumudi, yeure kob kumarge baba, nu yeb daidaigegi büreregarge. ");
INSERT INTO urw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Fere nugeab au fabgegi ara kemeidi daiarge baba, nu yeb daidaigegi büreregarge. ");
INSERT INTO urw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ninag gam güre, kekia fata idawar ferewar baba fata gam bürüdi nugeab daba daba taugegib fata idawebüregüdiba, bana baba fata idawegib mur agandag baba, gotogüdi utun kese deregeaga. Kegeam nugeab baba, fata kenegafotuebeagade kene baba sibamgebüre. ");
INSERT INTO urw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nu baba kese bangarge baba, bana simen kese difürüdi fata baba kenegafotuwargegarba, fere gürenakuti kegeudi makirkirweregegin. ");
INSERT INTO urw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Menüm wageregen, ‘Baba fere fata baba tuabereagako, kenegafotuwarge.’ ");
INSERT INTO urw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Bana erekokayau güre kümüna erekokayau güre küre waragebüreba, gotogüdi idadau ututungafotudie kümüneregeaga. Nuge 10 tausen maraipapa banüm tugu, erekokayau güre baba nu tugu 20 tausen maraipapa banüm tugu dag ogurebeaga. Babaure nu sibamgafotudie, erekokayau güre babab maraipapawar keab waragüdi kenegafotueben de kene dag baba sibamgebüregeaga. ");
INSERT INTO urw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Bana nu utungar towargegarba, karauiab kütünba bürarberenana, marai kumafotuwebüre fere sugurungar karauiab waurebüre kümüneregen. ");
INSERT INTO urw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Babanüm gürena, ninag gam güre nugeab daba daba gürenakuti nige duwargegarba, nu yeb daidaigegi büreregarge.” ");
INSERT INTO urw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jisas namana menüm wageaga, “Sigai nu daba nama. Bangeagako, sigaib fiam kenegarba, bana arangüdar sigai baba maig fiam bürebeaga? ");
INSERT INTO urw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sigai babanüm baba, küm gam daba saguwar fouweregarge. Baba tugu, bulmakaub sib tugu turudi küm gam difereregüdige. Kene. Sige uguna difotugafaigenan. Fere kagub tugu garba dora meme ederegeaga.” ");
INSERT INTO urw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kegeam degi fere epürage tugu, menmen gügab fere gürekoi tugu Jisasüb dora edebüre Jisas nuge iroto oguren. ");
INSERT INTO urw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bangar Farisiwarie kabiab sibam ferewar keab Jisasure yadigüdi menüm wagen, “Baba fere nu menmen gügab ferewar keab kadkadgüdi nini keab daba nüfaigeaga.” ");
INSERT INTO urw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Bangar Jisasde komina dora meme dünügeaga, ");
INSERT INTO urw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Bana ninag gam güre 100 sipsip tugu bürarbere sipsip güre iwagarba, 99 sipsip baba gürenakum sapagar daba nüdi büreregen. Bangüdi sipsip gürenakuana baba fitaudi kümüna kaiudie. ");
INSERT INTO urw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sipsip baba kaiuabürüdiba, ebebearudi kemeidi fogob nugeab gam kinmegabürüdi maig fibigo ogureregeaga. ");
INSERT INTO urw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Bana fata nugeab gam taidüdiba, büreabmanaie, fib büreabmana tugu yagüngar ogura guruweregen. Bangar wangeregeaga, ‘Nini ye keab ebebearwane! Yeb sipsip güre iwageaganwaib, maig fitaudi dün!’” ");
INSERT INTO urw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Bangar Jisasde menüm wageaga, “Ye wangün, fere güre menmen gügab kob piruwar, ebebear babanüm gürena, fib nama gam taidügafaigeaga. Ferewar 99 baba, nini surur büren baba nini kob piruwegi fünai kene. Bangeagako, menmen gügab fere güre kob piruwarba, dora dugurewegiwarüngab ebebear baba kürüna erekokai, nini namana namana ebebearuafaigen.” ");
INSERT INTO urw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Bangar Jisasde namana menüm wageaga, “Be finege güre kegeam gürena mor tugu, bangarbere kegeam magi aigo tugu güre fata gam iwagarba, arangebeaga? Nan furudi fata gam ina gasaudi idadau agügeregeaga. Bangüdi fitaudi kümüna nugeab kegeam baba kaiuweregeaga. ");
INSERT INTO urw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bana kegeam nugeab kaiudi düdiba, büreabmanaie fib büreabmana keab yagüngar ogura guruweregen. Bangar wangeregeaga, ‘Nini ye keab ebebearwane! Yeb kegeam magi güre kenegeaganwaib maig fitaudi dün!’” ");
INSERT INTO urw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Bangar Jisasde menüm wageaga, “Ye wangün, menmen gügab fere güre kob piruwar, ebebear babanüm gürena Keriabüb dora dugurewegiwar kodigo taidügafaigeaga.” ");
INSERT INTO urw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Bangar Jisasde namana menüm wageaga, “Fere güre nu nono aküre tugu. ");
INSERT INTO urw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Bangar nono fanam babade eme menüm waweaga, ‘Emüga, nag daba daba awai küre gam kabataudi sigebüregün baba, yeb baba mügar sie.’ Bana emnüg nugeab daba daba gürenakuti aküresari kabatageaga. ");
INSERT INTO urw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nono fanam baba, ere batamge nuge daba daba tobgüdi fere gagam sugurweaga. Bangüdi kegeam düdi, fib güre kütünba kümüna büreaga. Nu kümüna baba fib gam bürüdi fido kabia epürafanam geaga. Bangar kegeam nugeab gürenakuti kenegeaga. ");
INSERT INTO urw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Bana kegeam kenegeaga sese gam, baba fib gam oguno sese taideaga. Baba sese gam, nub daba daba gürenakuti kenegeaga. ");
INSERT INTO urw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Bangarbere kümüna baba fib gamnab fere güre gam fünai deaga. Bangar baba ferede nugeab dawai taugebüre, dawai güb gam sugurwar kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Dawai toi omai sige sige negin baba kegengabürüdi, nuge tugu ogunoweaga. Bangeagako, baba sese gam, fere gürede daba duwarge. Bangar omai sige sige gürekoi kiregüdi nebüregeaga. ");
INSERT INTO urw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Bana mügar ututun nama düdi, wageaga, ‘Emügab sarua mogoi gürenakuti nini daba epürage tugu. Bangeagako, ye meag bürün baba oguno kogigiaga. ");
INSERT INTO urw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Bagena, ye maig siradüdi igeab emüga gam kümünere. Bangüdi menüm wawere, “Emüga, ye Keriab gam tugu na gam tugu menmengün. ");
INSERT INTO urw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mügar ye fere namagar, nagüb nono güdi yanbayeregabge. Ye ebgaiadab nagüb sarua mogoi güre sibe büreregün.”’ ");
INSERT INTO urw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Bana siradüdi eme gam kümüneaga. “Nu kütüba bürarberenana, emede kegewarbere ogureaga. Bangar emeb kob, nonoure kürüna kororabweaga. Bangar emede gururudi kümüna nono kobagüdi, nurdokweaga. ");
INSERT INTO urw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Bangar nonode menüm waweaga, ‘Emüga, ye Keriab gam tugu na gam tugu menmengün. Mügar ye fere namagar, nagüb nono güdi yanbayeregabge.’ ");
INSERT INTO urw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Bangeagako, emede nugeab sarua mogoi toi yagüngar oguredi menüm wangeaga, ‘Nini igeab karün namafanam kuab baba düdi ogura pirika enburuwane. Bangüdi kube magi gam saia güre difürüwane. Bangüdi kebe gam tugu kebe sagwegi enburuwane. ");
INSERT INTO urw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bangübenar kümüna bulmakau fara adagegi baba dubenar orane. Bangar kobe nüdi ebebearwegi. ");
INSERT INTO urw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Amure, yeb nono meme nu kumeagagünko, mügar nu maig gotogegi deaga. Nu iwageagako, maig igaiwenan.’ Bana kobe erekokai kobegüdi ebebearua büren. ");
INSERT INTO urw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Bana baba sese gam, nono keman baba, nu küm gam büreaga. Kuri maigüdi fata iroto oguradiba, ferefinabur garabina epüraudi meruwen baba edeaga. ");
INSERT INTO urw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Bangar sarua mogoi güre yagudi menüm totoweaga, baba ‘Amdagegin?’ ");
INSERT INTO urw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Bangar sarua mogoide waweaga, ‘Mabün nagüb manage maig ogura taideaga. Bangar emünde bulmakau fara adagegi baba oreaga, amure, emün kegeweaga baba, mabün nagüb nama fanam bürüdi ogura maig taideaga babaure ebebearweaga.’ ");
INSERT INTO urw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nono keman dora baba edüdi, magirawar fata gam iruwegi uruweaga. Bana eme obugo füraboudi, magira nub kumafotuwebürewadi, dora nama duweaga. ");
INSERT INTO urw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bangeagako, emeb dora menüm toweaga, ‘Aranüm? Ye uguna sarua mogoi sibe, sarua nab kümdan epürafanam dürge. Bangüdi dora nab büraifaigurge. Baba, gürenabede fanam güre meme sogub fanamere güre siab igeab büreyaimana keab ebebearurge. Kürüna kene. ");
INSERT INTO urw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Bangeagako, nono nagüb meme, nagüb daba daba gürenakuti erekobo gamnab finabur gam kenegafotuweaga. Bangafotudi, mügar maig ogurar, nag ebebearuabürüwebürewadi bulmakau fara adagegi baba orun.’ ");
INSERT INTO urw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Bangar emede menüm waweaga, ‘Nono, na bata bata ige küre burfaigün, babaure yeb daba daba gürenakuti baba, nab. ");
INSERT INTO urw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Bangeagako, mügar sige ebebearwegi, bangar kob sigeab namauo, amure, mabün kumeagagünko, mügar maig gotogegi deaga. Iwageagako, mügar sigede maig igaiwenan.’” ");
INSERT INTO urw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisasde nugeab daidaigegi simai menüm wangeaga, “Kegeam fere güreb taugegi güre büreaga. Bangar fere gürekoide, kegeam fere baba gam oguradi, taugegi gam dora menüm oren, ‘Taugegi nagüb baba, nagüb daba daba uguna kenegafotuweaga.’ ");
INSERT INTO urw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Bangarbere kegeam ferede, taugegi yaguwar ogurar waweaga, ‘Nab kabiab dora edün baba aranüm? Na kümüna yeb daba daba nagüb kube gam büreaga babab doraman feie. Na kürüna taugegi büreregabge.’ ");
INSERT INTO urw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Bana baba taugegi nugede, nuge menüm waweaga, ‘Mügar arangüi? Eregeam taugegi fünai ye gam düfotuwebüregeaga. Ye ugu fere taidüdi, fere güre gam kübüdim pusuwegi fünai degi sogi kene. Bangar fere gürekoi kegeam siebüre wangegi tugu maiagün. ");
INSERT INTO urw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Bangeagako, mügar ye daba gegi sibamgün, eregeamde taugegi fünai gam kudeiarba, ferewar nurto tutug baba, kim igaidi nugengab fata gam kümüneregen. Bangar ige sagiebüregüdi nini gam kabia nama nama geregün.’ ");
INSERT INTO urw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Babaure, fere gürena gürena nugeab eregeam gam nurto tutug baba, yagüngar nuge gam oguren. Fere gürekese taidar, taugegide totoweaga, ‘Na yeb eregeam gam nurto agan dün?’ ");
INSERT INTO urw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Bangar wageaga, ‘Ye 100 wel kiag dün.’ Bangar taugegide waweaga, ‘Na budi faga nagüb nurto feienwaib baba de, bangüdi nurto 100 wel kiag baba ebgadibenau pirika gotogaboudi 50 gürena feibere.’ ");
INSERT INTO urw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kuri fere güre taidar, taugegide totoweaga, ‘Nab nurto agan?’ Bangar wageaga, ‘Ye 100 wit far dün.’ Bangar taugegide waweaga, ‘Na budi faga nagüb nurto feienwaib baba de, bangüdi nurto 100 wit far baba ebgadibenau pirika gotogaboudi 80 gürena feibere.’ ");
INSERT INTO urw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Bangar kuri, eregeam baba, taugegide kabia geaga baba sibamgüdi, taugegi kogi babab yanim siradgabereaga, amure, kabia geaga baba, fere ututun tugub sibe. Fere nini kübüdim meme gamnab kabia daiwafaigen baba, nini nugengab fünaiwegi am am erekobo baba kürüna sibamgen. Bangüdi fere meram gamnab kabia daiwafaigen baba, emegerüngen. ");
INSERT INTO urw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ye wangün, meme kübüdim gamnab kegeam kogi gamde, ninag ferefinabur buburengar ninagüngab büreanügmana tataigebüregüdi genan. Bangar kuri kegeam debetawegi sese baba kenegarba, kim igaingüdi tüpür tüpür büregi fata toi gam kümüneregen. ");
INSERT INTO urw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Fere güre daba fanam fanam idadau taugafaigüdiba, nu daba ere ere tugu idadau taugeregeaga. Fere daba fanam fanam idadau taugafaigarge baba, nu daba ere ere tugu idadau taugeregarge. ");
INSERT INTO urw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nini meme kübüdim gamnab kegeam kogi, idadau taugafaigargegarba, wonide kainana daba taugegi ninag dünügebeaga? ");
INSERT INTO urw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Be ninag fere güreb daba daba idadau taugargegarba, wonide ninagüb daba daba dünügebeaga? ");
INSERT INTO urw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Sarua mogoi güre taugegi aküre gamnana minigo büreregarge. Güre ogub dudi, güreure kob darabgeregeaga. Güreb dora edüdi, güre nige duweregeaga. Nini Keriab minigo tugu, kegeam minigo tugu büreregarge.” ");
INSERT INTO urw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisiwar nini kegeamure güfaigegin, babaure, dora Jisasde dorageaga baba dora gürenakuti edüdi makirkir dora duen. ");
INSERT INTO urw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Bangeagako, menüm wangeaga, “Ninag Farisiwar ferewarde menüm wangebüregüdi utun düfaigenan, baba Farisiwar nini surur kabia gürena güfaigen. Bangeagako, daba daba ninagüngab sibim gam iwagüdi büreaga baba, Keriab nu sibam. Daba fereb utunde namageaga baba daba, Keriabüb ege gam kürüna kogi. ");
INSERT INTO urw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Kabiab dora tugu, kiari ferewarüngab dora tugu egimena bürüdi ogura Jonüb sese gam taideaga. Bangeagako, Jonüb sese gam toadeaga baba, Keriabüb Korobab dora nama baba, fib itut taideaga. Bangar fere gürenakuti koroba baba gam iruwebüre sogiferen. ");
INSERT INTO urw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Magadi tugu kübüdim tugu kim kenegeregeaga. Bangeagako, Keriabüb kabiab dora fanamere fanam kenegeregarge.” ");
INSERT INTO urw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jisasde namana menüm wageaga, “Am fere, fia ureadi finege güre deaga baba, siba kabia geaga. Baba tugu finege güre egime kabüde ebgadeaganwaib baba, fere gürede düdiba, baba tugu siba kabia geaga.” ");
INSERT INTO urw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisasde namana menüm wageaga, “Egime kegeam fere güre büreaga, nu karün maur nama nama enüdie, baba kekia karün ebeab kuab baba, enfaigegi bata. Bangüdi dü itut nu daba nama nama nüfaigeaga. ");
INSERT INTO urw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Kegeam fere babab fata kudumege iroto, kogiwab fere güre kinbürfaigeaga. Kogiwab fere babab yanim Lasarus, nu kegeam fere babab kur gadi gam daba makita musuafaigeaga baba düdi nebürewadi utungafaigeaga. Nub mube gam ed gin gin kakagiuaboudi büreaga, bangar mamüde ogura nugengab saguib sige edi nub beraberafaigen. ");
INSERT INTO urw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Kuri kogiwab fere baba kumar, Keriabüb dora dugurewegiwarde kemeidi kümüna Abraham keab diferedi büreaga. Kegeam fere baba tugu kumar ub kurberen. ");
INSERT INTO urw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nu fere kumfotuwenwaib fib gam darab erekokai tugu büreaga. Nu kekia agügüdi, Abraham kegeweaga baba, kütüb asau büreaga, Lasarus tugu nu keab büreaga. ");
INSERT INTO urw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bana kegeam fere baba menüm yogeaga, ‘Emüga Abraham, na yeure kororabge, bangüdi, Lasarus wawab nugeab kube magi gamde yag fanam düdi ogura yeb saguib gam diferar fanam nargeregeaga. Ye keb meme gam bürüdi darab gugub dün.’ ");
INSERT INTO urw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Bangeagako, Abrahamde wageaga, ‘Nono, na daba güre utunge. Nag omo bürün sese gam, na daba nama nama gürenakuti kiregün. Bangar Lasarus nu daba kogkogi gürenakuti kiregeaga. Bangeagako, mügar meme fib gam, kob nub dab fanam büreaga, bangar na darab kogi dün. ");
INSERT INTO urw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Baba tugu, daba güre, sin tugu ninag tugu kodigo, Keriabüde yagbara güre erekokai difereaga. Babaure, fere meag büren baba, yagbara baba bugataiudi nin gam kümünegi baba, dirugungeaga. Baba tugu, fere bag büren baba, yagbara bugataiudi sin gam oguregi dirugungeaga.’ ");
INSERT INTO urw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Bangar kegeam ferede wageaga, ‘Bana bangarba emüga, ye totonün, Lasarus suguruab igeab emügab fata gam kümünebeagade? ");
INSERT INTO urw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ye mabamana taba tugu büren, babaure, Lasarus wawab kümüna dora sogsogi dünügar kabia nugengab idabürügo, banaka nini tugu darab erekokai degib fib gam meag oguraduen, babaure.’ ");
INSERT INTO urw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Bangeagako, Abrahamde wageaga, ‘Mosesüb dora tugu kiari ferewarüngab dora tugu büreaga, baba gam kim kagub difereregen.’ ");
INSERT INTO urw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Bangar kegeam ferede wageaga, ‘Emüga Abraham, kene. Baba towarge. Bangeagako, fere güre kumeaganwaib ferefib gamde siradüdi nini gam kümünarba kob piruweregen.’ ");
INSERT INTO urw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Bangar Abrahamde menüm waweaga, ‘Nini Mosesüb dora tugu kiari ferewarüngab dora tugu edfaigedigegarba, bana fere güre ferefib gamde siraderegeaga tugu, doragar kob kainanageregedige.’” ");
INSERT INTO urw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisasde nugeab daidaigegi simai menüm wangeaga, “Ferefinabur menmen gam fürügebüre, daba daba adab adab tataigeregeaga. Bangeagako, fere baba kabia kabia taibürügeaga baba, nu dabnanai. ");
INSERT INTO urw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kegenam güre erekokai saka nagüb barub wartaudi masyag nigumo fotuwediba, baba kogi. Baba sibenana, na mogoi fara güre namana kabia kogi güre abatarudiba, baba kürüna kogi. ");
INSERT INTO urw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Babaure nini ninagure idadau taugane. “Awan ede mabün nagüb menmen garba, wawab kabia nugeab baba idabero. Kob piruwarba, menmen nub unaige. ");
INSERT INTO urw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Be dü gürena baba gamnana fere güre ogura nag gam menmengafotudiba, wageregeaga, yeure kororabgüdi yeb menmen unaigegarba, bana menmen nub unaige. Maig aküre bede ogura nag gam menmengafotudiba, wageregeaga, yeure kororabgüdi yeb menmen unaigegarba, bana menmen nub unaige. Maig küi bede ogura nag gam menmengafotudiba, wageregeaga, yeure kororabgüdi yeb menmen unaigegarba, bana menmen nub unaige. Banüm gürena kümüna nonob tugu bede taideregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Dora turewegi ferewarde Erekokai menüm wawen, “Na sinib kob kainana baba namana gab erekokaigo.” ");
INSERT INTO urw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bangar Erekokaide menüm wangeaga, “Kob kainana ninib fanamere sau mastet gen babab magi sibeko, nini au wawegi toweregeaga, ‘Na nagüb ginim toi sidiragubenau kümüna masyag nigumo biboudi büregarba,’ au baba ninagüb sube daiweregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jisasde namana menüm wageaga, “Ninag kodigo fere gürede sarua mogoi kümüna küm gam kübüdim pusuwebürede, sipsip toi taugebüre wawarba, bana baba sarua mogoi saruagafotudi maig fata gam ogurarba, nugeab eregeamde menüm wawebeagadag, ‘Na pirika ogura gotogüdi daba ne gebeagade’? ");
INSERT INTO urw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kenenai. Eregeamde sarua mogoi menüm waweregeaga, ‘Na yeb daba ekotagübenau ude dagübe yeb daba ordüdi ogura sie. Ye kese daba tugu yag tugu nürie, bana na kurie daba tugu yag tugu ne.’ ");
INSERT INTO urw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Be eregeamde sarua mogoi baba, sube daidaiweaga babaure esegebeagadag? Kenenai. ");
INSERT INTO urw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Babaure ninag tugu, daba daba gürenakuti Keriabüde wangeaga baba sibenana güfotudiba, bana menüm wagane, ‘Sin eregeamde fünai sigeaga babaure ena sube daidaiwenan. Sin yanim debüre fünaiudarge.’” ");
INSERT INTO urw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas erekobo daiudi Jerusalem kümüneaga. Bangüdi Samaria distrikie Galili distrik kodigode urigüdi kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Fib güre gam taidar, fere fogo tugu lepra subo tutugu ogura erekobo gam kaiwen. Nini kütübana bibowen, ");
INSERT INTO urw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","bangüdi erenana menüm yogen, “Jisas, eregeam, na sinure kororabge.” ");
INSERT INTO urw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisasde kegengüdi, menüm wangeaga, “Nini kümüna mube ninagüngab Keriabüb kobegegi ferewar abatarüngane.” Bana kümünedi mube nugengab urun taideaga. ");
INSERT INTO urw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nin kodigo fere güre kegeweaga baba, nugeab mube maig namaweaga baba kegeudi maigeaga. Nu igyogüdi, Keriabüb yanim siradgabereaga. ");
INSERT INTO urw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nu kümüna Jisas gam taidüdi, Jisasüb kebe iroto oksosob orudi, nurmaga kübüdim gam difürüdi, esegeaga. Fere baba, nu Samaria distriküb ferefinaburüngab gin gamnab. ");
INSERT INTO urw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jisas fere baba kegeudi wageaga, “Yeba, fere fogo tugu urun taiden gün. Bangeagako, fere dam tugu baba arag büren? ");
INSERT INTO urw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Maigüdi, ogura Keriabüb yanim siradgaberegi kenedag, io? Fere meme gin güre gamnab nu nugenakuanade?” ");
INSERT INTO urw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Bana Jisasde fere baba menüm waweaga, “Na siradibe kümüne. Kob kainana nagübüde, nag maig namabereaga.” ");
INSERT INTO urw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisiwarde Jisas menüm totowen, “Am sese gam Keriabüb Koroba ogurebeaga?” Bangar Jisasde dora ninib menüm toweaga, “Keriabüb Koroba oguregi sese gam, am daba güre bera sibe taideregarge, bangar ferefinabur nugengab egede kegeweregedige. ");
INSERT INTO urw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Bangar menüm wageregedige, ‘Kegewenan, meag büreaga,’ ede ‘Egina bag büreaga.’ Edenan. Keriabüb Koroba manage ninag kodigo büreaga.” ");
INSERT INTO urw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bangar Jisas nugeab daidaigegi simai menüm wangeaga, “Kuri sese taideregeaga baba, ninag Fereb Nonob sese güre, kegewebürenana geregenan. Bangeagako, kegeweregarge. ");
INSERT INTO urw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bangar ninag menüm wangeregen, ‘Kegewenan, nu egina bag büreaga,’ ede ‘Kegewenan, nu meag büreaga.’ Bangeagako, nini kümüna daingagana. ");
INSERT INTO urw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ninag sibam, uyankengenim taidügafaigeaga baba, magadi gürenakuti meramgafaigeaga. Bana Fereb Nono tugu nuge oguregi sese gam babanüm gürena geregeaga, bangar ferefinabur gürenakuti kegeweregegin. ");
INSERT INTO urw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bangeagako, nu kub epüra fanam kemeidie, bangar meme sese gamnab ferewar nige duweregegin. ");
INSERT INTO urw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Noab sese gam kabia babanüm geginwaib, kabia babanüm gürena, Fereb Nono oguregi sese gam geregegin. ");
INSERT INTO urw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noab sese gam daba, yag negi fünai gübüren, ferewar finabur kiregegin, finabur kam degin, bangedi kümüna kümüna Noa oude ere gam iruwegi sese gam taiden. Bana kuiai erekokai taidüdi ferefinabur gürenakuti kogifürüngeaga. ");
INSERT INTO urw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ferefinabur kabia babanüm gürena, Lotüb sese gam geginwaib. Baba, yag negi gam büren, daba murugegi, sugurwegi fünai tugu küm fünai fata fünai güdi büren. ");
INSERT INTO urw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Bangeagako, Lot nu Sodom ebgadüdi kümüneaga, bangar baba dü gamnana keb tugu kegenam salfa tugu, yag sibe magadi gamde musuweaga. Bangüdi ferefinabur gürenakuti kogifürüngeaga. ");
INSERT INTO urw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Bana Fereb Nono agüba taidegi dü gam, kabia babanüm gürena taideregeaga. ");
INSERT INTO urw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Baba dü gam, fere güre fata kekia bürar nugeab daba daba fata goime bürarba, debüre iruwebeagana. Babanüm gürena, fere küm gam büreaga baba, fata gam maigüdi ogurebeagana. ");
INSERT INTO urw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nini Lotüb fia gam daba taideaga baba utungane. ");
INSERT INTO urw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Fere güre nugeab gotogegi nugede debetawebüregüdiba, gotogegi nub kenegeregeaga. Bangeagako, fere güre nugeab gotogegi ye gam ebgadüdiba, gotogegi nub nama büreregeaga. ");
INSERT INTO urw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ye wangün, Fereb Nono utumnonou taideregeaga baba, fere aküre kur gürena gam kineregegin, bangar Keriabüde güre igaiudi, güre ebgadar büreregeaga. ");
INSERT INTO urw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Finabur aküre plaua taiberebüre wit magi toabüreregegin, bangar Keriabüde güre igaiudi güre ebgadar büreregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Daidaigegi simai dora baba edüdi, Jisas menüm totowen, “Erekokai, baba daba daba arag taidebeaga?” Bangar Jisasde menüm wangeaga, “Araugam dag fere mob mob büreaga baba gam gürena, mabig ogura guruafaigen.” ");
INSERT INTO urw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisasde komina dora güre dünügeaga, bata bata sibdibwegibure sarigabürüngeaga, bangar siroigeregedige. ");
INSERT INTO urw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Menüm wageaga, “Fib ere güre gam, jas güre büreaga. Jas baba Keriabure kimgafaigarge, nu ferewarure tugu, idau utungafaigarge. ");
INSERT INTO urw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Baba fib ere gam tugu finege güre büreaga, baba oyemadi. Bata bata jas baba gam oguradi wafaigeaga, ‘Karau yeb kogifürüyebüregeaga. Na dora gam sagie.’ ");
INSERT INTO urw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Omo gam jasüde finege baba saguwegi uruweaganwaib. Bangeagako, kuri menüm utungeaga, ‘Ye Keriabure kimigürge, ye ferewarure idau utungurge. ");
INSERT INTO urw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Bangeagako, finege oyemadi baba, ye kub siegi bata. Babaure dora gam saguidag. Banaka bata bata ogureregeaga. Bangar ye nub dora edegi gürenakuti siroieregeaga.’” ");
INSERT INTO urw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Bangar Erekokaide namana menüm wageaga, “Nini jas kogi babab dora baba edane. ");
INSERT INTO urw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Bana aranüm? Ferefinabur Keriabüde nugeab uruageaga, bangar dü itut gituwegi itut nugeure mür büren baba, Keriabüde sagüngeregargedag, io? Dago dagongüdi pirika sagüngeregargedag, io? ");
INSERT INTO urw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ye wangün, nu pirikanana sagüngeregeaga. Bangeagako, Fereb Nono ogureregeaga baba, ferefinabur kübüdim gam büren baba, kob kainanagende, kene? Baba kegengeregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Fere güre güre, nuge surur bürüdi, gürewar sin sibe büredige güdi utungafaigen. Jisasde babanüm ferewarure komina dora menüm dünügeaga, ");
INSERT INTO urw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Fere aküre, sibdibwebüre nugeküre Keriabüb fatab güb gam kümünen. Güre nu Farisi, güre baba nu kegeam degi fere. ");
INSERT INTO urw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisi baba nu biboudi, nugeab kob gamde menüm sibdibweaga, ‘Keriab, ye fere gürewar sibege, babaure ye nagure esegün. Nini begafaigegin, baba tugu kabia nama güfaigedige tugu finabur kam tutug gam menmengafaigegin. Bangeagako, ye kene. Baba tugu ye kegeam degi fere baba sibege. ");
INSERT INTO urw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kunube itut ye daba kudigegib dü aküre uruagafaigün. Ye daba daba gürenakuti düdiba, fogo tugu tobgafaigüdi kabatagafaigün bangüdi tob gürena baba nag dünafaigün.’ ");
INSERT INTO urw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Bangeagako, kegeam degi fere nu kütüba biboweaga, bangüdi fib nama gam kekia agügegi uruweaga. Kene. Nu utugudi wageaga, ‘Keriab, ye menmen gügab fere. Na ye niraraie.’” ");
INSERT INTO urw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Bangar Jisasde wageaga, “Ye wangün, kegeam degi fere baba, nugeab fata gam maigeaga sese gam, nu gürena Keriabüb ege gam surur fere taideaga. Bangeagako, fere güre baba kogi. Amure, fere gürenakuti nugengab yanim siradgaberen baba, Keriabüde nini obgogabereregeaga. Fere gürenakuti nuge obgogaberen baba, Keriabüde yanim ninib siradgabereregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ferefinabur mogoi fara fara Jisas gam yatangüdi oguren, mogoi fara fara ebe gamnab tutug yatangüdi oguren. Jisasde nini gam kube düferebüregar yatangen. Bangeagako, daidaigegi simai kegeudi baba ferefinabur nunurungen. ");
INSERT INTO urw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Bana Jisasde mogoi fara fara yagüngar nuge iroto oguregin, bangüdi daidaigegi simai menüm wangeaga, “Nini mogoi fara fara uruwar ige gam oguren. Tageibürüngagana. Amure, Keriabüb Koroba baba, fere memenüm mogoi fara fara sibeb. ");
INSERT INTO urw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ye nini gam kainana wagün, fere güre Keriabüb Koroba mogoi fara farade düfaigen baba sibe dargegarba, nu baba gam iruweregarge. Kürüna kene.” ");
INSERT INTO urw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Taba fere gürede Jisas menüm totoweaga, “Sibam sarigegi nama, ye am bangüdie gotogegi nama tüpür tüpür büregi düi?” ");
INSERT INTO urw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Bangar Jisasde menüm waweaga, “Amure ye namagüdi yanbain? Keriab nugenakuana nu nama. ");
INSERT INTO urw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Na kabiab dora toi sibamgafotun, ‘Nini finege tutug baba, nini siba kabia gagana. Nini ferefinabur gürekoi kiasorungar kugumgebena. Nini begagana. Nini kiougüdi ferefinabur gürekoi dora gam difürüngagana. Nini emnüg aninigmana minigo bürüdi dora ninib daiwane.’” ");
INSERT INTO urw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Bangar taba ferede wageaga, “Ye fara yeusanana ogura mügar, ye kabia baba gürenakuti daiwafaigün.” ");
INSERT INTO urw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisas dora baba edüdi, taba fere baba menüm waweaga, “Na daba güreure sigagün. Na nagüb daba daba gürenakuti sugurue, bangüdi kegeam baba düdiba, kororab ferewar kabatange. Na bangüdiba, na fib nama gam daba nama nama deregün. Bangüdi ogura ye daie.” ");
INSERT INTO urw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Bangeagako, taba fere dora baba edüdi, kob koigeaga, amure, nu daba daba epüra fanamge tugu. ");
INSERT INTO urw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas taba fere baba kegeweaga baba, kob koigar menüm wageaga, “Ferewar daba daba epürage tugu baba, nini Keriabüb Koroba gam iruwebüre bikideweregegin. ");
INSERT INTO urw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kegeam fere Keriabüb Koroba gam iruwebüre bikideweaga baba sibe, kamel nu daba daba giwegi nil abuk gam iruwebüre bikideweregarge.” ");
INSERT INTO urw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ferewar dora baba edüdi menüm wagen, “Bangarba, wonidenana gotogegi nama tüpür büregi debeaga?” ");
INSERT INTO urw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Bangar Jisasde wageaga, “Baba daba, ferede geregarge, bangeagako, Keriabüde geregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bangar Pitade menüm wageaga, “Edün. Sin fib tugu daba daba sinib tugu ebgafotudi, dainenan.” ");
INSERT INTO urw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Bangar Jisasde menüm wangeaga, “Ye nin gam kainana wagün, fere gürenakuti Keriabüb Korobaure utungüdi, nugengab fata tugu, fianügmana, owa mebemana, emnügmana aninigmana, mogoitoi ebgagaingüdiba, bana kübüdim meme gam büren sese gamnana Keriabüde daba daba epürafanam dünügeregarge. Nuge daba daba egimeb tutug büren baba, emegerweregeaga. Bangar sese kuri taidebüregeaga baba, gotogegi nama tüpür tüpür büregi deregegin.” ");
INSERT INTO urw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas daidaigegi simai gürena bede fogo aküre igaingüdi menüm wangeaga, “Edane. Mügar Jerusalem kümünab. Bangar dora gürenakuti kiari ferewarde Fereb Nono gam daba daba tataigeregeagagüdi feienwaib baba, mügar kürüna tataigeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gürewarüngab gingamnab fere simaingab kube gam nu duweregegin. Bangüdi makirkir dora duweregegin, kogifurudi, sibgoruweregegin. ");
INSERT INTO urw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bangüdi gege düdi orfotuweregegin. Bangeagako, dü küi gamba maig siraderegeaga.” ");
INSERT INTO urw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Bangeagako, daidaigegi simai nini, dora babab ginim sibamgedige. Dora babab ginim ninib kob gam iwageaga, bangar dora baba geaga baba, nini idau sibamgedige. ");
INSERT INTO urw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisas Jeriko fib ere iroto taidüdi, fere güre ege gomo erekobo maga gam gotogüdi ferefinabur kegeamure toto totongeaga, baba kegeweaga. ");
INSERT INTO urw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ferefinabur gin ere oguren baba edüdi, fere menüm totongeaga, “Baba amdagegin?” ");
INSERT INTO urw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bangar wawen, “Jisas Nasaretüb ogureaga.” ");
INSERT INTO urw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Bana baba ege gomo menüm yogeaga, “Jisas, na Devitüb matanab, na ye kororabie.” ");
INSERT INTO urw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Fere agfürüdi oguren babawarde, nunurudi menüm wawen, “Na sube gütüwe.” Bangeagako, nu bikuwadaid igyogüdi, erenana magaudi mengeaga, “Na Devitüb matanab, na ye kororabie.” ");
INSERT INTO urw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Bangar Jisas ogura biboudi, fere baba nuge gam igaiudi ogurebüregüdi wangeaga. Ege gomo baba iroto ogurafotuwarbere, Jisasde menüm totoweaga, ");
INSERT INTO urw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ye na gam am bangebüre güdi gün?” Bangar wageaga, “Erekokai, ye agügebüregün.” ");
INSERT INTO urw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Bangar Jisasde waweaga, “Ege nab kim namaweregeaga. Kob kainana nagübüde gar nag namaun.” ");
INSERT INTO urw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Bangar pirikanana ege nub pitoiar agügeaga. Bangar Jisas daiudi kümünadi, Keriabüb yanim siradgabereaga. Bangar ferefinabur gürenakuti baba kegeudi, nin tugu Keriabüb yanim siradgaberen. ");
INSERT INTO urw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Bana Jisas kümüna Jeriko fib ere gam taideaga, bangüdi fib kodigode kümünadi fib ere emegerwebüregeaga. ");
INSERT INTO urw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Fere güre baba fib ere gam büreaga, nub yanim Sakius. Nu kegeam degi ferewarüngab taba fere, babaure nu kegeam epürage tugu. ");
INSERT INTO urw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jisas nu fere aranümdag baba kegewebüregeaga. Bangeagako, Sakius nu fere siga babaure, ferefinabur gin ere büredurudi Jisas kegewegi dirugweaga. ");
INSERT INTO urw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Bangar Jisas kegewebüre nu kese gururu kümünadi, kurab düm güre komeaga. Nu sibam, Jisas baba erekoboyau kümüneregeaga. ");
INSERT INTO urw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bana Jisas Sakius büreaga baba gam taidüdi, baba au kekia agügüdi, Sakius menüm waweaga, “Sakius, pirika musue. Mügar ye nab fata gam büreregün.” ");
INSERT INTO urw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Bangar Sakius kob ebebearudi pirikanana musudi Jisas igaiudi nugeab fata gam kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bangar fere gürenakuti kegeudi menüm nunurgen, “Nu kümüna fere güre menmengafaigeaga babab fata gam büreaga.” ");
INSERT INTO urw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nini fata gam bürübenana, Sakius biboudi Erekokai menüm waweaga, “Erekokai, ede. Mügar igeab daba daba gürenakuti aküresari kabatagere, bangüdi güresari kogiwab fere dünügere. Baba tugu, ige fere güre sarabeudi am dag daba nub güre begüdiba, bana ye maig baba dabanana dogob tugu toweregün.” ");
INSERT INTO urw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Bangar Jisasde menüm waweaga, “Mügar, Keriabüde meme fata gamnab ferefinabur igaingafotuweaga. Baba fere tugu nu Abrahamüb matanab. ");
INSERT INTO urw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Fereb Nono nu fere kenegen baba maig igaingebüre ogura fitangeaga.” ");
INSERT INTO urw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ferefinabur Jisas doragabüreaga baba eden, bangar komina dora güre tugu dünügeaga. Amure, nu Jerusalem iroto manage taideaga. Bangar Keriabüb Koroba mügarnana agüba taideregeagagüdi utungen. ");
INSERT INTO urw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Menüm wageaga, “Eregeam güre fib güre kütüba kümünebüregarba, nu erekokayau uruageregegin. Bangar kuri nugeab fib mudimere gam maigüdi, nugeab gin taugeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nu kümünebürewadi, nugeab sarua mogoi fogo tugu yagüngeaga, bangüdi kegeam aküre mor aküre mor kabatangeaga. Bangüdi menüm wangeaga, ‘Nini kegeam meme dibenar bisnis fünai fünaiwarbere, ige maigeregün.’ ");
INSERT INTO urw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Bangeagako, fere babab fib büreabmana, nure kürüna kob koigegin. Bangar nu kümünafotuwarbere, fere gürekoi sugurungedi dora düdi fib eregeam kümüneaga baba fib gam kümünen. Menüm wagedua, ‘Sin baba fere sinib erekokayau taidegi uruwenan.’ ");
INSERT INTO urw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Bangeagako, nu manage erekokayau uruagegin, bangafotuwedie kuri maig ogureaga. Nu maigüdi ogurafotudiba, menüm wageaga, ‘Sarua mogoi toi egime kegeam dünügünwaib baba, yagüngane. Fere gürena gürena kegeam agan agan degin baba, kegeam omo agan agan taibürügegin baba sibamgebüregün.’ ");
INSERT INTO urw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Bana fere güre nukese oguradi wageaga, ‘Eregeam, ye nab kegeam aküre mor, düdi fünaiudi omo taibürün baba, kegeam 200 taibürün.’ ");
INSERT INTO urw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Bangar erekokayaude menüm waweaga, ‘Na sarua mogoi nama, babaure na fünai nama gün. Na daba kürüna fanamere baba idadau taugün, babaure na mügar fib ere fogo tugu taugegib yanim dünün.’ ");
INSERT INTO urw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Bana sarua mogoi güre oguradi wageaga, ‘Eregeam, ye nab aküre mor saka bisnis fünaiun baba, mügar ye kegeam omo 100 taibürün.’ ");
INSERT INTO urw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Bangar erekokayaude waweaga, ‘Na fib ere taba tugu taugegib difürünün.’ ");
INSERT INTO urw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Bangar sarua mogoi güre oguradi wageaga, ‘Eregeam, aküre mor nab mia büreaga. Ude dira güre gamde wartaudi difürür büreaga. ");
INSERT INTO urw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Amure, ye kegenün baba, na tamari bürün. Baba daba fere gürewarde diferedi büreaga baba, na düfaigün. Daba daba gürewarde orenwaib baba, baba tuguna, na düfaigün. Babaure ye naure kimigün.’ ");
INSERT INTO urw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Bangar erekokayaude baba sarua mogoi menüm waweaga, ‘Na sarua mogoi kürüna kogi! Ye nagüb dora gamdenana, nag dora gam difürüneregün. Ye fere tamari baba, nag ye sibamgafotun, bangar ye daba daba ferede diferedi büreaganwaib tugu orenwaib tugu yede düfaigün. ");
INSERT INTO urw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bana am ginimure kegeam yeb kegeam fata gam diferabge? Bangar ige maig oguradiba, kegeam omo taibürün baba, gürekoi tugu maig deregün?’ ");
INSERT INTO urw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Bangar fere iroto bibougegin gam menüm wageaga, ‘Aküre mor nu gam baba dane, bangüdi fere kegeam 200 tugu baba duwane.’ ");
INSERT INTO urw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bangar menüm wawen, ‘Eregeam, nu manage kegeam 200 tugu.’ ");
INSERT INTO urw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Bangar wageaga, ‘Yede wangün, fere gürenakuti daba daba gürekoi tugu baba, yede namana gürekoi dünügeregün. Bangeagako, fere güre daba daba kenegarba, bana daba fanam fanam debetaweaga baba, yede nu gam düfotuweregün. ");
INSERT INTO urw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Bangeagako, yeb karautoi baba, nini ye nugengab erekokayau büregi uruwen. Igaingüdi ogura yeb ege gam meag kiasorungar kugumgen.’” ");
INSERT INTO urw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas komina dora baba doragafotudi, urigegi nugeab maig tuadüdi erekobo daiudi Jerusalem komeaga. ");
INSERT INTO urw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jisas fib Betfageie Betani iroto taideaga, girtorub Oliv gen baba gam. Bangüdi daidaigegi aküre sugurungeaga. ");
INSERT INTO urw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Bangüdi nugeküre menüm wangeaga, “Ninaküre fib egina büreaga baba gam kümünane. Ninaküre baba fib gam kümünadiba, donki sogub güre keneigaberedi büreaga baba, ninaküre kegeweregenan. Egime fere güre nu gam gotogaurarge. Donki baba muri kuregafotudi igaiudi meag ogurane. ");
INSERT INTO urw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bangarbere, fere gürede wangüdi, ‘Amure donki baba kuregenan?’ banüm totongarba, bana ninaküre dora nub menüm towane, ‘Erekokai nu gam fünai tugu.’” ");
INSERT INTO urw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jisasde nugeküre sugurungar, nugeküre kümünen baba, daba daba gürenakuti nugede wangeaga baba sibenana kegewegin. ");
INSERT INTO urw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nugeküre donki babab muri kuregedibere, donki ememanade nugeküre menüm totongen, “Ninaküre amure donki baba kuregenan?” ");
INSERT INTO urw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bangar nugeküre wagen, “Erekokai nu gam fünai tugu.” ");
INSERT INTO urw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bana nugeküre donki düdi Jisas gam oguren. Bangüdi nugeküre enegi aküre aküre enenwaib baba, enegi kuab kuab mube obgoira baba, kuguregudi, donki kekia ibarbürügen. Bangüdi Jisas saguwedi donki kekia gotogeaga. ");
INSERT INTO urw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Donki kekia gotogüdi kümünar, ferefinabur nugengab enegi kuab kuab mube obgoira baba kuguregudi erekobo gam ibabarwegin. ");
INSERT INTO urw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nu erekobo güre Oliv gir gamde kaneaga baba erekobo iroto taideaga. Bangar nugeab daidaigegi gin ere ebebear toaden. Nini dora migu gürenakuti kegewenwaib baba utungüdi, erenana yogüdi Keriabüb yanim siradgaberen. ");
INSERT INTO urw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Menüm yogen, “Baba erekokayau Erekokaib yanim gamde ogureaga, Keriabüde nu gam nama geregeaga. Keriab kekia asaub yanim siradgaberegi! Fib nama gam kob dab fanam Keriab keab büreaga.” ");
INSERT INTO urw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farisi gürewar baba ferefinabur gin ere kodigo büren babawarde, Jisas menüm wawen, “Sibam sarigegi, nagüb daidaigegi simai baba nunurunge. Nini dora babanüm doragebena.” ");
INSERT INTO urw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Bangar dora menüm toweaga, “Ye wangün, sube gütüwediba, kegenam toide igyogüdi, Keriabüb yanim siradgabereregen.” ");
INSERT INTO urw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas Jerusalem iroto taidüdi, fib ere kegeudi, Jerusalemure mereaga. ");
INSERT INTO urw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Menüm wageaga, “Jerusalem, mügar meme dü gamnana nag idanedi dab fanam büregi daba daba baba, sibamgebüre wadigün. Na baba sibam garba, baba nama. Bangeagako, baba daba daba iwagegi gam büren, bangar na kegeweregabge. ");
INSERT INTO urw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Na edün. Kuri sese güre taideregeaga, bangar nagüb karauianmanade ogura kübüdim tobgüdi nagüb güb ere koiweregegin. Bangüdi güresari güresari gürenakuti koiwatauneregegin. ");
INSERT INTO urw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bangüdi na nagüb mogoi fara fara nagüb gübroime büren babawar keab, pusunüdi kürüna kogifürüneregen. Bangüdi kegenam nagüb güre euwedi kegenam güre kekia büreregarge, amure, Keriab nag sagünebüre ogureaga baba, na sibamgabge.” ");
INSERT INTO urw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Bana Jisas Keriabüb fatab gübroime iruwaboudi, fere bag bisnis fünaiudi büren baba kudengeaga. ");
INSERT INTO urw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Menüm wangeaga, “Keriabüb budi gam dora menüm büreaga, ‘Fata yeb baba, sibdibwegib fata büreregeaga.’ Bangeagako, ninide gar, be ferewarüngab iwagegi fata sibe taideaga.” ");
INSERT INTO urw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Bangüdi dü itut Keriabüb fatab gübroime ferefinabur sarigabürüngafaigeaga. Bangar kobegegi taba ferewarie, kabiab sibam ferewar tugu, ferefinaburüngab taba ferewar keab, Jisas orfotuwedi kumebüregüdi, erekobo fitawegin. ");
INSERT INTO urw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Bangeagako, ferefinabur gürenakuti dora nub edebüre kürüna sogiferen, bangar taba ferewar nu orfotuwegi erekobo güre kegewedige. ");
INSERT INTO urw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Dü güre gam, Jisas Keriabüb fatab gübroime, ferefinabur dora dünügüdi, nini gam dora nama pitoiaga. Bangar kobegegi taba ferewarie, kabiab sibam ferewar tugu, taba ferewar keab nu gam oguren. ");
INSERT INTO urw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bangüdi menüm wawen, “Na yanim baba tugu sogi baba tugu aragüb düdi meme daba daba gün baba, wasige? Baba tugu wonide yanim baba düneaga?” ");
INSERT INTO urw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Bangar dora ninib menüm toweaga, “Ye tugu, ye daba güreure totongebüregün. Nini waiane, ");
INSERT INTO urw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon fere yag fidüngeaga baba, ninib utun baba, baba fib nama gamnab dabade, ede baba ferewarüngab daba gürenade?” ");
INSERT INTO urw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bana nuge nuge menüm doragen, “‘Baba fib nama gamnab daba güdi,’ wagüdarba, wageregeaga, ‘Amure nure kob kainanagarge?’ ");
INSERT INTO urw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bana, ‘Baba ferewarüngab daba gürena güdi,’ wagüdarba, fere gürenakuti sige gam kegenam fotuweregen, amure, Jon nu kiari fere güdi banüm sogsogi kob kainanagen.” ");
INSERT INTO urw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bana Jisas menüm wawen, “Sin sibamge, Jon kabia baba aragübdag düdi fere yag fidüngeaga.” ");
INSERT INTO urw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Bangar Jisasde menüm wangeaga, “Ye tugu, wonidedag yanim meme siar fünai meme gün baba, wanügeregürge.” ");
INSERT INTO urw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisasde ferefinabur komina dora güre menüm dünügeaga, “Fere güre wain küm idaweaga. Bangüdi wain küm baba, fere gürewar bisnis fünai gebüregen babawarüngab kube gam difereaga. Bangüdi nuge fib güre kütüba kümüna sese kuab büreaga. ");
INSERT INTO urw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Bana wain muri toi nama feregi sese gam, sarua mogoi güre sugurwar fere wain küm gam fünaiwen gam kümüneaga. Küm baba gamnab wain gürekoi duwebüregüdi sugurweaga. Bangeagako, fere küm gam fünaiwen babawarde, sarua mogoi baba orudi, kudewedi uguna kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bangar küm emede maig sarua mogoi güre sugurwar nini gam kümüneaga. Bangeagako, nu tugu füraboudi orudi kogifuruwen. Bangüdi maiagaburudi kudewedi uguna kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Bana maig sarua mogoi güre sugurwar kümüneaga. Bangeagako, kürüna kogifurudi, kudewedi obugo füraboweaga. ");
INSERT INTO urw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Bangarbere küm emede wageaga, ‘Mügar amdagi? Igeab nono sugurweregün, ye nurenana gün. Kim dora nub edebendag.’ ");
INSERT INTO urw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bangeagako, nonob ogurar, fere küm gam saruagen babawarde kegeudi, nuge nuge menüm wagen, ‘Fere baba emeb daba daba gürenakuti deregeaga. Babaure, orfotudar kumar, sigedenana küm meme degi.’ ");
INSERT INTO urw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bangarbere, kudewedi küm obgoira kümünar, orfotuwedi kumeaga. “Bana nin utungenan aranüm, wain kümüb emede baba ferewar gam am bangebeaga? ");
INSERT INTO urw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nu oguradi baba ferewar küm gam fünaiwen baba kiangar kugumgebende. Bangüdi wain küm baba fere gürewar dünügeregeaga.” Fere dora baba edüdi wagen, “Nu bangebeagana.” ");
INSERT INTO urw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Bangeagako, Jisas nin gam agügüdi wageaga, “Bana amure Keriabüb budi gam dora baba feiberedi büreaga, ‘Kegenam baba kamdawarde kogigüdi dufotuwenwaib. Mügar kegenam baba, fatab güb sogi furuwegi agferegi büreaga’? ");
INSERT INTO urw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Fere gürenakuti baba kegenam kekia fürgüdiba, gürenakuti puspasweregegin. Kegenam baba fere güre kekia musudiba, kegenamde gürenakuti ebagudi kogifuruweregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kabiab sibam ferewarie, kobegegi taba ferewarkeab menüm sibamgen, Jisas komina dora baba, ninag gamna oreaga. Babaure, baba sese gamnana siradüdi sauaigebüregen. Bangeagako, ferefinaburure kimigegin. ");
INSERT INTO urw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bana kobegegi taba ferewarie kabiab sibam ferewarkeab, Jisas idadau taugen. Bangar taroudi kegewebüregüdi fere sugurungedi oguren. Baba ferewar kiougüdi sige nub dora kürüna edebüregenangen. Dora gam diferegi dora güre gar dora gam diferebüregüdi sarabewebüregen. Bangar kübüdim bera taugegi agferegib kube gam diferedi, Jisas dora gam difereregeaga. ");
INSERT INTO urw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Menüm totowen, “Sibam sarigegi, sin sibam, dora nab kainana, bangar na ferefinabur dora surur dünügafaigün. Bangar na dora gürena babanüm gürena fere dünügafaigün, fere yanim tugude ede yanim kene tugu. Na kainana dora gamde, ferefinabur Keriabüb kabiaure sarigabürüngafaigün. ");
INSERT INTO urw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Bana na aranüm utungün? Romüb Erekokayau Sisar gen baba kegeam duwegide kene?” ");
INSERT INTO urw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Bangeagako, sarabe baba gen baba, Jisas nu sibamgafotuweaga. Bangar wangeaga, ");
INSERT INTO urw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kegeam güre abataryane. Baba kiangeanim tugu yanim tugu kegeam gam büreaga baba wonib?” Bangar wagen, “Sisarb.” ");
INSERT INTO urw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Bangar menüm wangeaga, “Bana Sisarb daba daba baba, Sisar duwane. Keriabüb daba daba baba, Keriab duwane.” ");
INSERT INTO urw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Babaure ferefinabur keab büreaga baba sese gam, sarabewedi dora güre kogifuruebeagagüdi sarabewebüregenko, dirugungeaga. Dora baba maig nini gam toweaga babaure tergüdi sube gütudi büren. ");
INSERT INTO urw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadyusiwarüngab gin gamnab fere gürekoi Jisas gam oguren. Sadyusiwarde, fere kumenwaib baba, maig siraderegedigegüdi doragafaigen. ");
INSERT INTO urw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Baba ferewarde Jisas menüm wawen, “Sibam sarigegi, Mosesde sigeab dora güre menüm feiaga. Fere güre finege düdi, mogoi kene kene kumarba, bana mebede fere babab fia düdi, mogoi difürüweregeaga. Bangar owab gin baba kenegeregarge. ");
INSERT INTO urw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bana egime owa mebe nonob tugu büren. Keman baba, finege deagako, mogoi kene kene kumeaga. ");
INSERT INTO urw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Bana nono keman kuri babade finege baba deaga. ");
INSERT INTO urw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Bana kuri nono küi babade tugu deaga. Baba owa mebe nonob tugu baba gürenakuti finege baba den, bangeagako, mogoi kene kene kugumgen. ");
INSERT INTO urw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Bangar finege baba tugu, kuri kumeaga. ");
INSERT INTO urw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Bana kuri fere kugumgen baba maig sidiragwediba, finege baba wonibnana bürebeaga? Nag sibam, fere nonob tugude dedi nu ninib fianüg büreaganwaib.” ");
INSERT INTO urw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Bana Jisasde menüm wangeaga, “Mügar meme sese gamnab ferefinabur nini kam düfaigen finege düfaigen. ");
INSERT INTO urw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Bangeagako, ferefinabur Keriabüde wageaga, ferefinabur maig siradüdi, igekeab kurib gotogegi nama tüpür tüpür deregen baba, baba ferefinabur nini kam deregedige finege deregedige. ");
INSERT INTO urw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Amure, nini maig fanam kumeregedige. Nini Keriabüb dora dugurewegiwar sibe büregin. Keriabüde ferefib gam imongafotuweaga, babaure nini nub mogoi toi büren. ");
INSERT INTO urw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Bangeagako, Mosesde tugu sige abatarsigeaga, fere kugumgen baba, ferefib gamde maig sidiraguafaigegin. Au fanamere fügeaga babab doraman gam, menüm wageaga, Erekokai nu Abrahamüb, Aisaküb, Jekopüb Keriab büreaga. ");
INSERT INTO urw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Babade sige menüm abatarsigeaga, Keriab nu kumegi ferengab Keriab ge. Kene. Nu fere omo büren babawarüngab Keriab. Ege nub gam, ferefinabur omo büren.” ");
INSERT INTO urw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kabiab sibam fere gürekoi Jisasde dora baba dorageaga baba edüdi, menüm wawen, “Sibam sarigegi, dora nab baba nama.” ");
INSERT INTO urw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bangar ferewar daba güreure maig Jisas totowegi kimigen. ");
INSERT INTO urw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Bana Jisasde ferefinabur menüm totongeaga, “Arangarbere menüm wagfaigen, fere Keriabüde nugeab ferefinabur maig igaingegi uruageaga baba, nu Devitüb matanab? ");
INSERT INTO urw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Munub budi gam, Devit nugede menüm wageaga, ‘Erekokaide yeb Erekokai menüm waweaga, “Na yeb kube namayau gotogün. ");
INSERT INTO urw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Kim nagüb karauianmana nag miniba difürüngür büreregen.”’ ");
INSERT INTO urw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kegewenan. Devit nugede, meme fere nugeab Erekokaigüdi yanbaweaga. Bana arangarbere meme fere nu Devitüb matanab?” ");
INSERT INTO urw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ferefinabur gürenakuti Jisas dora pitoiaga baba edüdi büredibere, nugeab daidaigegi simai menüm wangeaga, ");
INSERT INTO urw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nini kabiab sibam ferewarure dabnanai. Nini karün kuab enüdi kümünebüre güfaigen. Nini guruwegi fib gagam ferefinaburde fereberengebüregüfaigen. Nini kunube fata gam gotogegi kur agferegi gagam gotogebüre güfaigen, baba tugu, nini kobe erekokai gam gotogegi kur agferegi gagam gotogebüregüfaigen. ");
INSERT INTO urw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nini oyemadi finabur sarabengüdi, fata toi ninib begafaigen. Bangüdi sarabegüdi sibdib kuab kuab güfaigen. Doragegi sese gam, nini kub erekokai namana deregen.” ");
INSERT INTO urw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas kegeudi büreaga baba, kegeam tutugub ferewar ogura Keriabüb fatab gübroime, bokis kegeam gam nugengab bai feregi kegeam enbürügen baba kegeweaga. ");
INSERT INTO urw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Bangüdi kogiwab finege güre, oyemadi baba, kegeam fanam fanam aküre fotuwar bokis gam kaneaga baba kegeweaga. ");
INSERT INTO urw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Bangar Jisasde wageaga, “Ye nini gam kainana wagün, baba kogiwab finege oyemadi baba, nu kegeam erekokai difereaga. Ferefinabur gin ere kegeam difürügenko, baba oyemadide emegerüngeaga. ");
INSERT INTO urw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Baba ferefinabur gürenakuti kegeam ere ere büreagako, güresari gürena bokis gam difürügen. Bangeagako, baba finege nu gürenakuti sigageaga babaure, daba murugegi kegeam nugeab baba, gürenakutina difereaga.” ");
INSERT INTO urw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Fere gürekoi Keriabüb fata kegeudi menüm wagen, “Kegenam nama nama gamde fata tuenwaib baba, ferefinaburde kob ebebear abatargüdi daba daba Keriab duenwaib, baba daba daba saka fata baba karün nüburuwen.” Bangar Jisasde wageaga, ");
INSERT INTO urw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ninag baba daba daba mügar kegewenan babaure wanügebüregün. Sese taidar, babab kegenam güre euwedi kegenam güre kekia büreregarge. Kene. Gürenakuti bürayedi kaneregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bana bangar ferede Jisas menüm totowen, “Sibam sarigegi, am sese gam baba daba daba tataigebeaga? Am bera kese taidar sin baba kegenam toi bürayegi sese irotogeagagüdi sibamgeregenan?” ");
INSERT INTO urw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Bangar Jisasde wageaga, “Nini dabnanai. Sarabengendag banai. Amure, fere epürade ogura yeb yanim yanbaudi wageregen, ‘Igenana ye baba fere.’ Bangüdi wageregen, ‘Sese manage irotogeaga.’ Bangeagako, nini daingagana. ");
INSERT INTO urw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bana kuri kantri toi marai erekokai maraigeregen. Kantri güre gam nuge nuge marai ugug toadügeregegin, gin gürede gin güre küre maraigeregegin. Nini baba edüdiba, bana kimgüdi kutuagana. Baba daba daba kese tataigeregeaga, bangeagako, kübüdim kenegegib sese pirikanana taideregarge.” ");
INSERT INTO urw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Bangüdi namanana menüm wangeaga, “Gürewarüngab ginde güre gürewar gam marai touaderegen. Erekokayau güreb ginde, erekokayau güreb gin keab maraigeregen. ");
INSERT INTO urw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kübüdim gam im ere ere tataigeregeaga. Bangar gürekum gürekum, nini oguno erekokai tugu subo erekokai tugub sese taideregeaga. Bangar magadi gamba, ninag kimigegi bera ere ere tugu daba daba adab adab tataigeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Bangeagako, baba daba daba gürenakuti ara tataigarberenana, ebnongüdi kogifürüngeregen. Bangüdi kunube fata goime gagam, ninag dora gam difürüngüdi kakia gam ninag sapangeregen. Nini igaingüdi kümüna erekokayaungab ege gam tugu kübüdim bere taugegingab ege gam tugu biboweregenan. Baba kabia bangeregen baba, ninag igeure kob kainanagenan babaure. ");
INSERT INTO urw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Bangar baba kabia ninag gam gegin baba, nin gam dora nama pitoiegi erekobo sibe büreregeaga. ");
INSERT INTO urw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Babaure nini am dora kese nin gam maig toweregenangüdi ututun toitoiwagana. ");
INSERT INTO urw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Amure, igede dora ninib sube gam difereregün, bangüdi sibam nama dünügeregün. Bangar babawar ninag dora gam difürüngebüregen baba, nini dora ye dünügün meme, saifotuweregedige ede obgogabereregedige. ");
INSERT INTO urw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Ninagüngab emnüg aninig mana, awanüg mabnüg mana, kagi gürena, büreanüg mana, ninide tugu ninag karau kube gam difürüngeregen. Bangüdi ninag gam gürekoi kiangedi kugumgeregenan. ");
INSERT INTO urw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bangar fere gürenakuti ninagure kob kürüna koigeregen, amure, yanim yeb nini gam büreaga. ");
INSERT INTO urw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bangeagako, ninagüngab taba gam taba sara güre kenegeregarge. ");
INSERT INTO urw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nini sogsogi bürüdiba, gotogegi nama düdi, büreregenan.” ");
INSERT INTO urw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jisas namana menüm wageaga, “Nini maraipapawar kegengar ogura Jerusalem koiwatauwediba, nini sibamgeregenan, meme fib ere koigegi sese irotogeaga. ");
INSERT INTO urw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Baba sese gam, ferefinabur Judia distrik büren baba, gudi gir gagam komedua. Fere Jerusalem kodigo büren baba, fib ere ebgadüdi gürekum kumunedwa. Fere fib ere obgoira büren baba, nini iruwebena. ");
INSERT INTO urw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Baba sese gam, Keriab menmen maig towegi sese, babaure dora gürenakuti Keriabüb budi gam büreaga baba, kürünana taideregeaga. ");
INSERT INTO urw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Baba sese gam, finabur mube kub tutug, finabur mogoi ebe gamnab tutug baba, nini dabnanai. Amure, kübüdim meme gam kub erekokai taidegi sese. Bangar Keriabüb magira baba ferefinabur gam musuweregeaga. ");
INSERT INTO urw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bangar karautoide ogura gürekoi kiangedi kugumgeregen. Bangüdi gürekoi yatangedi kümüna kübüdim gamnab kantri gürenakutib kakia gagam büreregen. Bangar gürekumnab ferewarüngab kebede Jerusalem bitoweregen. Bangar gürekumnab ferewarde Jerusalem taugegi sese Keriabüde uruageaga baba, kenegeregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jisas namana menüm wageaga, “Baba sese gam, sida gam, edina gam, tugu keneb gam tugu, bera adab adab taideregeaga. Bangar kübüdim gamba fere gürenakutingab ututun kürüna koigeregeaga. Bangar masyag binaudi puspasweaga babab gür ederegen. Bangar ututun toitoiudi namana kimigeregen. ");
INSERT INTO urw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ferefinabur epüra, kübüdim gam daba daba tataigebüregeaga babaure ututungeregen, bangar kimgüdi agudkuaningeregeaga, amure magadi gamnab daba daba sogsogi baba isoweregegin. ");
INSERT INTO urw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Bangar baba sese gam, ferefinabur, Fereb Nono fiou güre gam bürüdi, nugeab sogi ere tugu meram ere tugu keab ogureregeaga baba kegeweregen. ");
INSERT INTO urw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Baba daba daba tataigerba, bana nini biboubenar kekia agügane, amure, Keriab ninag igaingegi sese, iroto ogurafotuweaga.” ");
INSERT INTO urw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jisasde komina dora güre menüm dünügeaga, “Nini kurab düm kegeudi au gürekoi tuguna kegewane. ");
INSERT INTO urw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kegengar bikom omo tataigarba, bana ninag sibam, kaikere sese taidebüregeaga. ");
INSERT INTO urw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Babanüm gürena, nini kegewar babanüm daba daba tataigediba, nini sibamgeregenan, Keriabüb Koroba manage ogurafotuweaga. ");
INSERT INTO urw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ye kainana wangün, mügar meme sese gamnab ferefinabur ara kumedibere, baba daba daba gürenakuti tataigeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Magadi tugu kübüdim tugu kenegeregeagako, dora yeb baba, kenegeregarge.” ");
INSERT INTO urw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Jisas namana menüm wageaga, “Bangeagako, nini dabnanai. Banaka nini yag bata nüdi nanarogeregenan banai. Bangüdi mubeb daba dabaure kororabgeregenan banai. Kabia babanümde bitaungarba, Keriabüb dü baba nini gam pirikanana taideregeaga. ");
INSERT INTO urw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ai keb sinade pirikanana orfotugafaigeaga baba sibe, dü baba ferefinabur gürenakuti kübüdim gam büren baba, babanümnana taideregeaga. ");
INSERT INTO urw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nini bata bata bigsaisaigüdi bürane. Bangüdi Keriabüde sogi dünügebüre bata sibdibwane. Bangar nini baba daba daba gürenakuti tataigebüregeaga baba nini emegerweregenan, bangüdi nini Fereb Nonob ege gam biboweregenan.” ");
INSERT INTO urw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Dü itut Jisas Keriabüb fatab gübroime, ferefinabur sarigabürüngafaigeaga. Bangeagako, utumnonou nu kümüna fata güre gir Oliv gen baba gam büreaga bag kinfaigeaga. ");
INSERT INTO urw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bangar ferefinabur gürenakuti fitunana sidiragudi dora nub edebüre Keriabüb fatab gübroime ogurafaigen. ");
INSERT INTO urw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bret Yis Kene Keneb Dü Ere, baba dü ere Keriabüde Israelwar eungar nama büren baba utungegibgüdi yanbafaigen, baba taidebüregeaga. ");
INSERT INTO urw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bangar kobegegi taba ferewarie kabiab sibam ferewarkeab, ferefinaburure kimgüdi, Jisas orfotuwebüre erekobo fitawen. ");
INSERT INTO urw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Bangar Satande Judas gam kobum kaneaga, Judas nu Iskariot yanbawen. Nu daidaigegiwar gürena bede fogo aküre babawarüngab güre. ");
INSERT INTO urw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Bangar nu kümüna kobegegi taba ferewarie Keriabüb fatab maraipapangab agferegiwar keab dorageaga. Nu Jisas ninib kube gam diferebüre, erekobo fitawebüregeaga. ");
INSERT INTO urw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Baba ferewar, Judas kegeudi ebebearudi, kegeam gürekoi düneregenangüdi banüm wawen. ");
INSERT INTO urw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Bangar Judas ninib doraure iogüdi, Jisas ninib kube gam diferebüre erekobo fitaweaga. Ferefinabur gin ere, güre sese Jisas keab büreregedige baba dagoweaga. ");
INSERT INTO urw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bret yis kene keneb dü ere taideaga. Baba dü gamnana, Dü Keriabüde Israelwar eungar nama büren baba utungebüre, sipsip fara nebüre orfotuweregen. ");
INSERT INTO urw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Bangar Jisasde, Pitaie Jonküre sugurungar kümünen, bangüdi nugeküre menüm wangeaga, “Ninaküre kümüna dü ere babab daba sigeab dugutuwane.” ");
INSERT INTO urw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bangar nugekürede totowen, “Na sin kümüna arag dugutuwebüre wasigün?” ");
INSERT INTO urw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Bangar menüm wangeaga, “Edenan. Ninaküre fib ere gam taidarba, fere güre yag sumo erekokai kemeieregeaga baba, erekobo gam kaingeregeaga. Ninaküre daiudi kümüna fata iruweaga baba fata gam iruwane. ");
INSERT INTO urw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Bangüdi ninaküre fata babab eme menüm wawane, ‘Sibam sarigegide totoneaga, “Fata kurumeb baba arag büreaga? Ye igeab daidaigegiwar keab, dü Keriabüde Israelwar eungar nama büren baba utungegib daba neregenan.”’ ");
INSERT INTO urw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Bangar fata kurumeb ere güre tag tutug, gotogegi kur tutug kekia büreaga baba abatarüngeregeaga. Ninaküre baba fata kurumeb gam daba dugutuwane.” ");
INSERT INTO urw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bana nugeküre kümünen, bangüdi daba daba Jisasde wangeaga baba sibenana kegewegin. Bangar nugeküre daba dugutuwegin. ");
INSERT INTO urw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Daba negi sese manage taideaga, bangar Jisas tag gam gotogeaga, bangar dora turewegi ferewar tugu nu keab gotogegin. ");
INSERT INTO urw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Bangüdi menüm wangeaga, “Dü Keriabüde Israelwar Eungar Nama Büren baba Utungegib Dü Ere gam, nini keab daba negi kürüna mediaga. Bangar kurie ige darab kemeieregün. ");
INSERT INTO urw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ye wangün, ye daba meme maig neregürge, kümüna baba daba Keriabüb Koroba gam kürüna taidegi sese gamie.” ");
INSERT INTO urw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bangüdi noi wain mum güre düdi, Keriabure esegeaga. Bangüdi wageaga, “Nini meme dibenar ninag kodigo kabatagane. ");
INSERT INTO urw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Amure, ye wangün, mügar tugu kuri tugu ye wain mum maig neregürge, kümüna Keriabüb Koroba taideregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bangüdi bret güre düdi, Keriabure esegeaga. Bangüdi tukaiudi daidaigegi simai dünügüdi wageaga, “Meme igeab mube, ninag sagüngebüre ye dünügün. Nini ye utungebüre bangafaigane.” ");
INSERT INTO urw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nifotuwedibere, noi wain mum düdi babanüm kabianana geaga. Menüm wageaga, “Noi wain mum meme kontrak omo igeab kagi gamde idaun. Baba ninag sagüngebüre edogün. ");
INSERT INTO urw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Bangeagako, kegewenan, fere karau toib kube gam difürüyebüregeaga. Baba fere, ye keab tag meme gam gotogeaga. ");
INSERT INTO urw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Fereb Nono nu, erekobo nub egime Keriabüde uruageaga babanana daiweregeaga. Bangeagako, karau toib kube gam nu difereaga baba fere, nu dabnanai.” ");
INSERT INTO urw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Daidaigegi simai dora baba edüdi, siradüdi nuge nuge menüm totogen, “Wonide baba kabia gebeaga?” ");
INSERT INTO urw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Bana daidaigegi simai woni nu nugengab agferegigüdi dora marai toaden. ");
INSERT INTO urw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Bangar Jisasde menüm wangeaga, “Ferefinabur gürewarüngab erekokayautoi nini, yanim tutug babaure baba ferefinabur taungen. Bangar baba erekokayau toide sige ferefinabur gam tamari kabia gügab feregüdi, banüm yanim tutug. Bangüdi baba erekokayau toide menüm wagfaigen ferefinabur nini sinib büreasigmana. ");
INSERT INTO urw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bangeagako, nini bangagana. Fere güre ninag kodigo agferegi büreaga baba, nu fere kuri büregi sibe taideregeaga. Bangar ninagüngab taba fere baba, nu ninag sagüngegi sarua fere sibe büreregeaga. ");
INSERT INTO urw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Utungane. Woni nu agferegi? Fere gotogüdi daba neaga babade, ede sarua fere daba orudi ogura duweaga babade? Agferegi baba, fere gotogüdi daba neaga baba, nu gürena. Bangeagako, ye nini kodigo bürün baba, ninag sagüngegi sarua fere sibe bürün. ");
INSERT INTO urw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Daba daba ye fururebüre tataigeaga baba, nini, ye keab bürenan, bangüdi uriaiarge. ");
INSERT INTO urw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Emügade ninag taungegi fünai siaga banüm gürena, gürewar taungegi fünai yede dünügün. ");
INSERT INTO urw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yeb koroba gamba, nini tag yeb gam gotogüdi, daba, yag neregenan. Bangüdi kur nama nama gam gotogüdi, Israelwarüngab gin gürena bede fogo aküre taungeregenan.” ");
INSERT INTO urw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Bana Jisasde menüm wageaga, “Saimon, edün. Satan ninagüngab kob kainana fururebüre doragafotuweaga, fere wit ina düfotuwebüre wit büraibaraiwafaigen baba sibe. ");
INSERT INTO urw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bangeagako, ye nag sagünebüre sibdibwafotun, bangar kob kainana nab kürüna fürügeregarge. Bangeagako, kob kainana nagüb fürügarba nag maig pirudi, oguradiba, bana awanmana mabünmana sogifürüngeregün.” ");
INSERT INTO urw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bangar Pitade menüm waweaga, “Erekokai, ye naküre kakia gam kümünebüre dugutun. Bangüdi naküre kumebüre dugutun.” ");
INSERT INTO urw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Bangar Jisasde wageaga, “Pita, ye wanün, mügar meme utumnonou kuaida maga ara yogarbere, na küi bede ye sibamgabgegüdi wageregün.” ");
INSERT INTO urw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jisasde daidaigegi simai menüm wangeaga, “Nini egime igeab sarua gebüre sugurungun baba sese gam, nini kegeam far, far tugu kebe saguwegi tugu kemegigiraudi kümünarge. Baba sese gam nini daba güreure sigagenande kene?” Bangar wagen, “Kenenai.” ");
INSERT INTO urw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Bangar menüm wangeaga, “Bangeagako, mügar, fere kegeam far tugu baba, deregeaga. Fere far tugu, nudaka deregeaga. Fere keime asau kene baba, nu nugeab enegi kuab kuab sugurudi kegeam düdi, keime asau güre murugeregeaga. ");
INSERT INTO urw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Amure, Keriabüb budi gam dora menüm tugu, ‘Nu ferefinaburde fere kogi sibe kegewenwaib.’ Ye wangün, ferefinabur baba kabia ye gam geregen. Amure, daba daba gürenakuti ye gam taidegi Keriabüb budi gam büreaga baba, taideregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bangar wagen, “Erekokai, kegewe. Sin keime asau aküre mia büreaga.” Bangar menüm wangeaga, “Baba kainana.” ");
INSERT INTO urw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Bana Jisas fib ere ebgadüdi, Oliv girtorub gam komeaga, nuge bata bata güfaigeaga baba sibe geaga. Bangar daidaigegi simaide daiwen. ");
INSERT INTO urw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nu baba fib gam taidüdi, menüm wangeaga, “Nini sibdibwane, bangar fururegi nin gam taideregarge.” ");
INSERT INTO urw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bangüdi, uriangüdi kütüb fanam kümüneaga, fere gürede kegenam fotuwar kümüna musuweregeaga babanüm gam sibe kümüneaga. Bangüdi oksosob orudi menüm sibdibweaga, ");
INSERT INTO urw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Emüga, na mednarba, ye gam noi meme düfotuwe. Bangeagako, na yeb ututun daiwegena. Kene. Na nagüb ututun gürena daiwe.” ");
INSERT INTO urw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Bangar fib nama gamnab dora dugurewegi güre, nu gam oguradi sogifuruweaga. ");
INSERT INTO urw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisas mube kubwar, namana sogsogi sibdibweaga. Bangar egig nub, kagi sibe taidüdi kübüdim gam purotoweaga. ");
INSERT INTO urw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nu sibdibwafotudi, siradüdi nugeab daidaigegiwar gam kümüneaga. Bangüdi daidaigegi simai kob kürüna koigüdi kin büren baba kegengeaga. ");
INSERT INTO urw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Bangar wangeaga, “Nini amure kinenan? Siradibe sibdibwane. Banaka fururegi nin gam taidar fürügeregenan banai.” ");
INSERT INTO urw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas doragadaiwarbere, fere gin ere oguren. Fere Judas gen baba, nu daidaigegi gürena bede fogo aküre babawarüngab güre, nude erekobo abatarüngeaga. Nu Jisas nur dokwebüre, Jisas iroto ogureaga. ");
INSERT INTO urw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Bangeagako, Jisasde menüm totoweaga, “Judas, na Fereb Nono nur dokwebüregün, bangar nab utun baba, baba kabia gamde nu karaungab kube gam diferebüregünde, io?” ");
INSERT INTO urw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Daidaigegiwar Jisas keab büren baba, daba taidebüregeaga baba kegeudi, wagen, “Erekokai, na sin keime asau saka kiangeregenan güdigünde?” ");
INSERT INTO urw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Bangar nin kodigo gürede, keime asau düdi kobegegi taba ferewarüngab sarua mogoi oreaga, bangar keime asaude baba sarua mogoib kagub kube namayau katafotuwar musuweaga. ");
INSERT INTO urw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Bangeagako, Jisasde kegeudi wageaga, “Kabia baba mügar ebgade.” Bangüdi fere babab kagub gam kube difererar kagub maig namaweaga. ");
INSERT INTO urw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bangar Jisasde, kobegegi taba ferewar tugu, Keriabüb fatab maraipapangab agferegiwar tugu, taba ferewar gam tugu, nuge bisigebüre oguren babawar gam dorageaga. Menüm wageaga, “Nini keime asau toi tugu at tugu düdi, fere güre betuka sibe bisigebüre ogurenande, io? ");
INSERT INTO urw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ye dü itut nin keab Keriabüb fatab gübroime bürünwaib, bangeagako, nini ye gam kube diferarge. Bangeagako mügar meme sese gam, baba ninib sese. Mügar gituwegib sogi erekokaigeaga.” ");
INSERT INTO urw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jisas doragafotuwarbere, bisigüdi igaiudi kümünen. Kobegegi taba fereb fata gam igaiudi kümüna iruwen. Bangar Pitade daingüdi kümüneagako, kütüb fanam büreaga. ");
INSERT INTO urw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Fere gürekoi fata babab gübroime keb karaudi, gotogen. Bangar Pita tugu ninkeab gotogeaga. ");
INSERT INTO urw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sarua finege gürede, Pita keb gam gotogüdi büreaga baba kegeweaga. Bangar sarua finege babade, nu gam agügüdi wageaga, “Baba fere tugu Jisas keab büreaganwaib.” ");
INSERT INTO urw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bangeagako, Pitade kenegüdi wageaga, “Ye nu sibamgürge.” ");
INSERT INTO urw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Fanam bururudiba, fere gürede nu kegeudi wageaga, “Na tugu na ninib gin gamnab fere.” Bangeagako, Pitade wageaga, “Kenenai. Ye nub daidaigegige.” ");
INSERT INTO urw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Fanam bürbürdüdiba, fere gürede sogsogi menüm wageaga, “Kürüna kainana, nu Galili distriküb fere dogo. Meme fere tugu, nu keab büreaganwaib.” ");
INSERT INTO urw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Bangeagako, Pitade wageaga, “Na dora baba gün baba, ye kürüna sibamgürge.” Doragarbere pirikanana kuaida maga yogeaga. ");
INSERT INTO urw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bangar Erekokaide, Pita gam agügeaga. Bangar Pita, Erekokaide dorageaga baba dora maig utungeaga. Erekokaide Pita menüm waweaganwaib, “Mügar meme utumnonou, kuaida maga ara yogarbere, na küi bede menüm wageregün, na ye sibamgabge.” ");
INSERT INTO urw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bangar Pita obugo füraboudi mereaga. ");
INSERT INTO urw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Fere Jisas debetawen baba, makirkir dora dudi oren. ");
INSERT INTO urw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ude saka ege nub gomagataudi menüm totowen, “Mügar, kiari dora dorage. Fere noreaga baba, nu woni?” ");
INSERT INTO urw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bangüdi kogi dora gürekoi epüra duwedige. ");
INSERT INTO urw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sida taidarbere, ferefinaburüngab taba ferewar ogura guruwegin, kabiab sibam ferewar tugu kobegegi taba ferewar tugu nini keab guruwegin. Bangüdi Jisas igaiudi nugengab guruwegi gam oguradi, wagen, ");
INSERT INTO urw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Na wasige, na Keriabüde nugeab ferefinabur maig igaingebüre uruageaga baba ferede, kene?” Bangar wangeaga, “Ye wangürba nini kob kainanageregarge. ");
INSERT INTO urw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ye dora gürekoire totongürba, nini yeb dora maig toweregarge. ");
INSERT INTO urw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Bangeagako, mügar tugu kuri sese gürenakuti tugu, Fereb Nono nu Keriab sogi ere tugub kube namayau gotogeregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bangar fere gürenakutide totowen, “Babaure nagüde, nag Keriabüb nonode, io?” Bangar wangeaga, “Ninagüde ba wagenan. Ye dogo.” ");
INSERT INTO urw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bangar wagen, “Fere memeb kabiab dora pitoiegi ferewar yagüngegige. Dora baba, sube nugeabüde doragar sige edfotuwenan.” ");
INSERT INTO urw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bana baba eregeamwar gürenakutinana siradüdi Jisas yataudi Pailat gam kümünen. ");
INSERT INTO urw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nini nu dora gam diferebüre dora toaden, bangüdi menüm wagen, “Sin fere meme kegewenan baba, sinib ferefinaburüngab kabia erimoreaga. Sin Romüb erekokayau Sisar gen baba, kegeam duwegi tageibürüsigeaga. Bangüdi menüm wagfaigeaga, nugenana nu baba erekokayau Keriabüde nugeab ferefinabur maig igaingegi uruageaga.” ");
INSERT INTO urw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bangar Pailatüde Jisas menüm totoweaga, “Na Judawarüngab erekokayaude, io?” Bangar Jisasde dora menüm toweaga, “Nagüde wagün sibe.” ");
INSERT INTO urw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Bangar Pailatüde kobegegi taba ferewarie ferefinabur keab menüm wangeaga, “Ye fere meme gam menmen güre kaiurge.” ");
INSERT INTO urw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bangeagako, namana sogsogi menüm wagen, “Nu Judia distriküb fib itut gürenakutiyau kümünafaigeaga, Galili distrikyau toadüdi ogura sigeab fib ere Jerusalem maig fünai kenegafotugafaigeaga, bangüdi ferefinabur sarigabürüngüdi kob ninib siradgabürügar nugengab taba ferewar maraigebüregen.” ");
INSERT INTO urw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat dora baba edüdi menüm totongeaga, “Fere meme, nu Galili distriküb ferede, io?” ");
INSERT INTO urw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pailat nu, Jisas kübüdim Herotüde taugeaga babayau ogureaga baba sibamgüdiba, Jisas sugurwar Herot gam kümüneaga. Baba sese gam Herot tugu Jerusalem büreaga. ");
INSERT INTO urw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot Jisas kegeudi, kürüna ebebearweaga. Nure dora edüdi, egimena kegewebüregeaganwaib. Nu Jisasde dora migu güre idawar kegewebüregeaga. ");
INSERT INTO urw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Babaure Herotüde, daba daba epürafanamure Jisas totoweaga. Bangeagako, Jisasde nu gam dora gürefanam towarge. ");
INSERT INTO urw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bangar kobegegi taba ferewarie kabiab sibam ferewarkeab, ogura Jisas iroto biboudi, dora gam diferebüre bikuwadaiwen. ");
INSERT INTO urw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Bana Herot nugeab maraipapawar keab, Jisas febaudi makirkir dora duen. Ude güre nama fanam düdi dagbürüwen, bangüdi maig Pailat gam sugurwedi kümüneaga. ");
INSERT INTO urw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Egime Herot nu Pailatküre karaugafaigeagako, mügar meme sese gam, nugeküre kadferen. ");
INSERT INTO urw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bana Pailatüde kobegegi taba ferewarie taba ferewar tugu ferefinabur tugu yagüngar ogura guruwegin. ");
INSERT INTO urw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Bangüdi menüm wangeaga, “Nini fere meme igaiudi ye gam oguradi wagenan, ferefinaburüngab gotogegi erimoreaga. Bangar ninag bürenan sese gam, baba daba dabaure ye Jisas idadau totounwaib. Bana edane. Ye fere meme gam menmen güre kaiurge. Ninag baba daba dabaure nu dora gam diferenan baba, ye utungün baba, nu garge. ");
INSERT INTO urw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot tugu nu ututun babanüm tugu gar, fere meme maig sugurwar sige gam ogureaga. Edenan. Fere meme menmen güre geaga gar, yede waudi, na kumegeregürge. ");
INSERT INTO urw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Bangüdi yede gudeparudi ebgadür kümüneregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bana ferefinabur gürenakutinana sogsogi yogüdi menüm wagen, “Fere baba orfotuwar kumar, Barabas uruwar sin gam oguro.” ");
INSERT INTO urw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas nu fere güre fib ere gam, kübüdim taugegi ferewar gam marai toadeaganwaib. Bangüdi fere güre orfotuwar kakia gam diferenwaib. ");
INSERT INTO urw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bana Pailat nini gam maig dorageaga. Nu Jisas ebgadar kümünebüregeaga. ");
INSERT INTO urw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Bangeagako, menüm yogen, “Orfotuwane! Orfotuwane! Au fabgegi gam orberane!” ");
INSERT INTO urw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Bana küi bede wangeaga, “Amure? Nu am menmen geaga? Nu menmen güre geaga gar, yede waudi, na kumegeregürge. Bangüdi yede gudeparudi ebgadür kümünebeaga.” ");
INSERT INTO urw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bangeagako, nini kürüna sogifürüdi, Pailatüde ferefinabur wanügar Jisas au fabgegi gam orberebüregüdi, namana sogsogi yogen. Bangar maga ninibüde Pailatüb dora emegerweaga. ");
INSERT INTO urw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Bangarbere Pailat ninib dora daiudi, Jisas kumeregeagagudi wageaga. ");
INSERT INTO urw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Fere baba kübüdim taugegi ferewar gam marai toadüdi fere orfotuwar kumar, Romwarde kakia gam diferenwaib, baba fere Pailatüde ebgadebüregüdi ferefinaburde yogen. Bangar Pailatüde ebgadar kümüneaga. Bangar Pailat ninib ututun daiudi maraipapangab kube gam Jisas dünügeaga. ");
INSERT INTO urw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Maraipapawar Jisas yataudi kümünad kümünadiba, fere güre oguradi fib ere gam taidebüregeaga baba kegewegin. Fere baba Sairini fib ere gamnab, yanim nub Saimon. Baba fere sauaigegin. Bangüdi au fabgegi nub fogob gam kemeiburuwedi, Jisas daiweaga. ");
INSERT INTO urw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bangar ferefinabur gin erede daiwen, bangar finabur epürade nure mürüdi kororab mun oregin. ");
INSERT INTO urw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Bangeagako, Jisasde piruaboudi menüm wangeaga, “Jerusalem finabur, nini yeure meragana. Nini ninagure tugu ninagüngab mogoi farafaraure tugu meregi baba nama. ");
INSERT INTO urw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Edenan. Kuri, sese güre taidar menüm wageregen, ‘Eberan finabur tugu kedemai finabur tugu finabur mogoi ara ebe dünügafaigedige tugu baba, nini ebebearweregegin.’ ");
INSERT INTO urw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Baba sese gam girtorub toi menüm wangeregen, ‘Gir ere ere nini korotausigane. Torub fanam fanam nini iwagafürüsigane.’ ");
INSERT INTO urw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mügar au omo gam kabia babanüm gediba, bana au genan gam kabia aranüm geben?” ");
INSERT INTO urw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Maraipapawar fere aküre yatangüdi oguren, fere aküre baba kabia kogi geginwaib. Nugeküre Jisas keab kiangedi kugumgebüregen. ");
INSERT INTO urw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nini kümüna fib güre gam taiden, yanim nub Tabab Dagar. Baba fib gam Jisas au fabgegi gam kuatigaberen. Bangüdi fere kogi aküre baba tuguna kuatigaberen. Güre au fabgegi Jisasüb kube nama yau büreaga, güre au fabgegi kube danaba yau büreaga. ");
INSERT INTO urw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Bangar Jisasde wageaga, “Emüga, na ninib menmen unaige. Baba kabia gegin baba, nini sibamgedige.” Bangar maraipapawarde enegi daba daba nub nuge nuge kabataudi debüre, ai magi epürawen. ");
INSERT INTO urw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ferefinabur biboudi agügüdi bürenko, taba ferewarde Jisas gam menüm makirkir dora gegin, “Nu fere gürewar sagüngeaganwaib. Nu kainana baba fere Keriabüde nugeab sarua gegi tugu nugeab ferefinabur maig igaingegi uruagarba, bana kim nugede nuge saguweregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Maraipapawarde tugu nure makirkir dora gegin. Nini nu iroto oguradi wain mum suga tugu duwebüregen. ");
INSERT INTO urw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Bangüdi menüm wagen, “Na kainana Judawarüngab erekokayau garba, bana nagüde na saguwe.” ");
INSERT INTO urw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bangüdi dora güre feidüdi, Jisasüb taba kekia au fabgegi gam wartawen. Dora baba menüm, “Fere meme, nu Judawarüngab erekokayau.” ");
INSERT INTO urw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Fere kogi aküre Jisas keab kuatigaberen baba, gürede Jisas menüm makirkir dora duweaga, “Na fere Keriabüde nugeab ferefinabur maig igaingebüre uruageagade, io? Bana nagüde nag sagube, sin aküre tugu sagsige.” ");
INSERT INTO urw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Bangeagako, fere güre babade dora baba edüdi fere güre baba menüm nunurweaga, “Na tugu na kub fere meme deaga babanümnana dün, na Keriabure kimigabgede, io? ");
INSERT INTO urw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Sigeküre kiasigedi kumenan baba, nini kabia surur gürena gegin. Sigeküre kub kemeienan meme, kabia kabia sige küre genanwaib baba gürena denan. Bangeagako, fere meme nu menmen güre garge.” ");
INSERT INTO urw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Bangüdi wageaga, “Jisas, na erekokayau taidüdiba, na yeure utunge.” ");
INSERT INTO urw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Bangar Jisasde menüm waweaga, “Ye na gam kainana wagün, mügarnana yeküre fib nama gam büreregün.” ");
INSERT INTO urw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mügar sida ege kodigo banüm. Bangar gituwegide kübüdim gürenakuti korotawar kümüna sida ege küi ututumira, ");
INSERT INTO urw_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","amure, baba sese gam sida meram kenegeaga. Baba sese gamnana baba ude ere Keriabüb fatab kurumeb kürüna kedebüb kudumege gam kuatigüdi büreaga baba, gürenakuti dibüragüdi aküresari taideaga. ");
INSERT INTO urw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Bangar Jisas namana menüm erenana yogeaga, “Emüga, yeb etob nagüb kube gam difürün.” Nu banüm doragafotudi, kumeaga. ");
INSERT INTO urw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Maraipapangab taugegi baba daba kegeudi, Keriabüb yanim siradgabereaga. Bangüdi wageaga, “Kürüna kainana, fere meme nu surur fere, nu menmengarge.” ");
INSERT INTO urw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bangar ferefinabur gürenakuti kegewebüre ogura guruwen baba, daba daba tataigeaga baba kegewegin. Bangar kürüna kororabüngar mereb tutug, nugengab fata gagam kümünegin. ");
INSERT INTO urw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bangar Jisasüb büreabmana gürenakuti tugu, finabur Jisas daiudi Galili distrik ureadi ogurenwaib baba, nini kütüb fanam biboudi, baba daba daba gürenakuti tataigeaga baba kegewegin. ");
INSERT INTO urw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Fere güre büreaga, yanim nub Josep. Nu Judiab fib ere güre Arimatea gen bagüb fere. Nu fere nama surur, nu kaunsilwarüngab güre. Bangeagako, nu kaunsil gürewarüngab ututunure tugu kabiaure tugu namawarge. Nu Keriabüb koroba kegewebüre dagofaigeaga. ");
INSERT INTO urw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Baba ferede, kümüna Pailat totowar euwar, Jisas mob debüregeaga, bangar Pailatüde iogeaga. ");
INSERT INTO urw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Bana bangar nu Jisas mob kemeidüdi musudi, ude maur saka korotaweaga. Bangüdi ferefib güre egime fere mob ara diferegi kene gam, kemeidi kümüna kegenam abukroime difereaga. Fere fib baba, kegenam abuk güre, ferede idaweginwaib. ");
INSERT INTO urw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Dü baba, Dü Kaberegib daba daba dugutuwegib, bangar Dü Kaberegi taidebüre irotogeaga. ");
INSERT INTO urw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Finabur Galili distrik ebgadüdi Jisas keab ogureginwaib baba, nini Josep daiudi kümüna ferefib baba kegewegin. Baba tugu, Josep aranüm Jisas mob difereaga baba kegewegin. ");
INSERT INTO urw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Finabur nini kegeafotudi, bana maig nugengab fata gagam kümüna marasin daba daba tugu wel daba daba kuri nama tugu baba dugutuwegin. Bangüdi kabiade wageaga sibe, Dü Kaberegi gam kaberen. ");
INSERT INTO urw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kunube gam, finabur fitunana ferefib gam kümünen. Nini marasin kuri nama tugu, ekotagafotuwen baba, düdi kümünen. ");
INSERT INTO urw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bangüdi ferede kegenam saka ferefib sube gütüwatawenwaib baba kegenam kegewen baba, bürarge. Kene. Kikiatauwedi kümüna kureb gam büreaga. ");
INSERT INTO urw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bangar kümüna iruwen, bangeagako Erekokai Jisas mob kegewedige. ");
INSERT INTO urw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Jisas mob arag dag büreaga baba, nini sibamgedige. Bangar ututun toitoiudi büren. Bangar fere aküre ninag iroto bibowen baba kegengen. Nuge kürengab enegi baba, kürüna meram asau. ");
INSERT INTO urw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bangar finabur kürüna kimgüdi utugen. Bangeagako fere aküre babade menüm wangen, “Nini amure fere omo büreaga baba, fitaudi fere kumegingab fib gam ogurenan? ");
INSERT INTO urw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nu meag bürarge, manage siradeaga. Nu Galili distrik büreaga sese gam, dora dünügeaga baba utungane. ");
INSERT INTO urw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ninag menüm wangeaganwaib, Fereb Nono menmen gügab ferewarüngab kube gam dünügeregen. Bangar nu au fabgegi gam orbereregen. Bangar nu dü küi gam maig siraderegeaga.” ");
INSERT INTO urw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Bangar nini egime Jisasde dorageaga baba utungegin. ");
INSERT INTO urw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bangar ferefib ebgadüdi maig kümünen. Bangüdi daidaigegi 11 tugu ferefinabur gürewar tugu, baba daba daba gürenakutib dora wangen. ");
INSERT INTO urw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Baba dora finaburde dora turewegi ferewar dünügen, baba Maria fib ere Makdalab tugu Joana tugu, Maria, nu Jemsüb ana, tugu finabur gürekoi finabur küi babawar keab bürfaigen tugu. ");
INSERT INTO urw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bangeagako dora turewegi ferewarde, finabur ugu kiou dora doragengüdi birengen. Bangüdi dora ninibure kob kainanagedige. ");
INSERT INTO urw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bangeagako Pita siradüdi ferefib gam gururu kümüneaga. Bangüdi tormogüdi agügeaga, bangeagako ude tob gürena kegeweaga. Bangüdi fata gam maigüdi kümüna baba daba taideaga babaure ututun toitoiweaga. ");
INSERT INTO urw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Finabur ferefib gam kümünen baba dü gamnana, daidaigegi aküre fib güre Emeus gen baba gam kümünen. Baba fib, Jerusalem kütüba büreaga, kilomita 11 banüm sibe. ");
INSERT INTO urw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nugeküre kümünad kümünadi, daba daba gürenakuti tataigeaga babaure nugeküre dorafokowen. ");
INSERT INTO urw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nugeküre epüra fanam doragedige, bangüdi baba daba dabaure totogen, bangedibere Jisas nuge kodigo taidüdi nugeküre keab kümünen. ");
INSERT INTO urw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bangeagako, daba gürede nugekürengab ege patawar, nugeküre meme Jisas güdi sibamgedige. ");
INSERT INTO urw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Bangar menüm totongeaga, “Ninaküre am dabaure dorafokouabina kümünenan?” Banüm doragar, nugeküre biboudi kob kürüna koigegi sibe abatargen. ");
INSERT INTO urw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Bangar nugeküre gam, fere güre yanim nub Kliopas, nude menüm dora toweaga, “Fere gürekum gürekumüb mügar Jerusalem büren. Na nagnakuana fanam daba daba meme sese gam Jerusalem tataigeaga baba, na sibamgabgedag?” ");
INSERT INTO urw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Banüm dorageaga, bangar Jisasde nugeküre totongeaga, “Am daba?” Bangar menüm wawen, “Sin Nasaretüb Jisas gam daba daba taideaga babaure doragenan. Nu kiari fere güre, nu Keriabüb ege gam tugu ferefinaburüngab ege gam tugu, fünai tugu dora tugu gugub güfaigeaga. ");
INSERT INTO urw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bangar sigeab kobegegi taba fere simai tugu taba fere simai tugude, kübüdim bera taugegib kube gam diferegin. Bangar kübüdim bera taugegide orfotuwar kumebüre dora idaweaga, bangüdi au fabgegi gam orberen. ");
INSERT INTO urw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Omo gam sin menüm kob kainanagenan, Jisas nu baba fere Keriabüde Israel ferefinabur maig igaingegib uruageaga. “Baba tugu dora güre tugu. Baba daba daba taideaga, bana mügar Jisas orfotuwedi kumeaga baba, dü küi kenegeaga. ");
INSERT INTO urw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bana mügar finabur gürekoi sinib gin gamnab, ninide gedi sin kürüna tergenan. Nini fitfitunana ferefib gam kümünen. ");
INSERT INTO urw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Bangeagako, Jisas mob kegewedige. Bangar maigüdi oguradi, menüm wagen, ‘Sin Keriabüb dora dugurewegi simai kegengenan, bangar wasigen, “Nu omo büreaga.”’ ");
INSERT INTO urw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bangar gürekoi sinib gingamnab ferefib gam kümünen. Bangüdi daba daba finaburde doragen baba sibenana, bürar kegewen. Bangeagako, Jisas mob nuge kegewedige.” ");
INSERT INTO urw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Bangar Jisasde nugeküre menüm wangeaga, “Ninaküre ututun kene, bangar ninakürengab kob pirikanana siradargegar, dora gürenakuti kiari ferewarde gegin baba, kob kainanagarge. ");
INSERT INTO urw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Aranüm? Ninaküre sibamgargedag, baba fere Keriabüde sugurwar ogura nugeab ferefinabur maig igaingegib dora idafotuweaga baba, nu darab düdie kuri nu Keriab gam yanim erekokai deregeaga?” ");
INSERT INTO urw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Bangüdi nu nugeküre gam dora pitoiaga, Mosesüb dora gamde tugu kiari ferewarüngab dora gamde tugu totogadeaga, bangüdi nugeküre gam Keriabüb budide nugeure dorageaga babab ginim sarigabürüngeaga. ");
INSERT INTO urw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nini kümüna fib nugeküre bürebüregenwaib baba iroto taiden. Bana Jisas nu namana kümünebüregeaga. ");
INSERT INTO urw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Bangeagako, nugekürede tageiburudi wagen, “Na sin keab büre. Sida kanebüregeaga, ere bürüdi gituweregarge.” Bangedi fatagoime iruwaboudi nugeküre keab büreaga. ");
INSERT INTO urw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kuri daba nebüregen. Bangar Jisas nini keab gotogeaga. Bangüdi bret düdi Keriabure sibdibüdi esegeaga, bangüdi pusudi, nugeküre dünügeaga. ");
INSERT INTO urw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nu bangar, nugekürengab ege putuweaga, bangar nugeküre nu sibamgen. Bangar demenana kenegabowar, nugeküre maig kegewedige. ");
INSERT INTO urw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bangar nuge nuge menüm doragen, “Kürüna kainana, sigeküre erekobo gam ogurenan sese, nu sigeküre dora sabsigeaga, bangüdi nu Keriabüb budib ututunüb ginim sigeküre gam pitoiaga, sigekürengab kob kürüna siradeaga.” ");
INSERT INTO urw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nugeküre banüm doragüdi, pirikana siradüdi maig Jerusalem maigen. Bangüdi nugeküre 11 daidaigegi simai tugu, nugengab epeianügmana gürekoi tugu, gurudi büren baba, kegengen. ");
INSERT INTO urw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bangar nugeküre menüm wangen, “Kürüna kainana, Erekokai maig siradeaga! Saimon nu kegeafotuweaga!” ");
INSERT INTO urw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bangar nugeküre daba daba gürenakuti erekobo gam tataigeaga babaure, nini gam dora mangüdi wagen, bret pusuweaga baba sese gam, sinaküre nu sibamgenan. ");
INSERT INTO urw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Daidaigegi simai doragabüredibere, Jisas nuge nin kodigo biboweaga. Bangüdi menüm wangeaga, “Kob ninib kim dab fanam büreregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bangeagako, nini tergüdi kimigen. Ninide utun gen baba, nini kianim güre kegewenangen. ");
INSERT INTO urw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Bangar menüm wangeaga, “Nini amure tergenan? Nini amure ututun toitoiwenan? ");
INSERT INTO urw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yeb kube tugu kebe tugu kegewane. Ige me bürün. Yeb mube debetaubenar, kegeiane. Dubim tugu dagar tugu ige gam bürar kegewenan sibe, kianim simai nini dubim dagar kene.” ");
INSERT INTO urw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Banüm doragafotudi, nugeab kube kebe tugu abatarüngeaga. ");
INSERT INTO urw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nini kürüna ebebearwenko, kob kainanagedige. Bangüdi ututun toitoiwen. Bangar menüm wangeaga, “Nini daba gürekoi meag büreagade?” ");
INSERT INTO urw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bangar wade saga makita baba duen. ");
INSERT INTO urw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Bangar düdi nar kegewen. ");
INSERT INTO urw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Bangüdi menüm wangeaga, “Ye ninag keab bürün sese gam, ye menüm wangafotunwaib, daba daba gürenakuti yeure Mosesüb Kabia gamde tugu, kiari ferewarüngab budi gamde tugu munub budi gamde tugu feiegin, baba daba daba gürenakuti kürüna tataigeregeaga.” ");
INSERT INTO urw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Bangar nugede sagüngar dora gürenakuti Keriabüb budi gam büreaga baba, ginim idadau sibamgeregen. ");
INSERT INTO urw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Bangüdi menüm wangeaga, “Keriabüb budi gam dora menüm tugu, fere Keriabüde nugeab ferefinabur maig igaingegib uruageaga baba, nu darab düdi kumeregeaga, bangüdi dü küi gam, ferefib gamde maig siraderegeaga. ");
INSERT INTO urw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Bangar nub yanim gamde ferefinabur gürenakuti gam dora pitoieregen, bangar nini kob piruweregen, bangar Keriabüde ninib menmen toi unaigeregeaga. Nini baba fünai Jerusalemde toadane, ");
INSERT INTO urw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","bangüdi nini meme daba daba tataigeaga babaure dora pitoiane. ");
INSERT INTO urw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Edenan. Egime Emügade Etob Kedeb dünügebüre dora idafotuweaganwaib baba, ere bürüdi sugurur ogureregarge. Nini meme fib ere gam bürübenar, Keriabüb sogi baba dibenarie.” ");
INSERT INTO urw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bana Jisasde daidaigegi simai yatangüdi Betani fib gam kümüneaga. Bangüdi Keriab totowar kob nama dünügebüregüdi kube kekiagabereaga. ");
INSERT INTO urw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Unun düngüdi düngüdi, uriangeaga. Bangar Keriabüde igaiudi fib nama gam komeaga. ");
INSERT INTO urw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bangar nini oksosob orudi kunube iruwabürüwen. Bangüdi kürüna ebebearudi maig Jerusalem kümünen. ");
INSERT INTO urw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bangüdi nini Keriabüb fatab gübroime bata bürüdi, Keriabüb yanim siradgabürüga büren.");
ALTER TABLE urw_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
