﻿USE sofia;
DROP TABLE IF EXISTS sofia.uro_vpl;
CREATE TABLE uro_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES uro_vpl WRITE;
INSERT INTO uro_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ama abuk sä ma Jisas ma Krais aa mamäkkäna qärak i ma Devit aa emga näkt ma Abraham aa emga na qa. ");
INSERT INTO uro_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ma Abraham di aa emga ma Aisak näkt ma Aisak di aa emga ma Jekop näkt ma Jekop di aa emga ma Juda qä na aa matpek dä aa läktpek. ");
INSERT INTO uro_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Näkt ma Juda di aa imiom ma Peres kä nä ma Sera nävät ma Tamar. Näkt ma Peres di aa emga ma Hesron näkt ma Hesron di aa emga ma Ram. ");
INSERT INTO uro_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Näkt ma Ram di aa emga ma Aminadap näkt ma Aminadap di aa emga ma Nason näkt ma Nason di aa emga ma Salmon. ");
INSERT INTO uro_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Näkt ma Salmon di aa emga ma Boas nävät ma Rahap näkt ma Boas di aa emga ma Obet nävät ma Rut näkt ma Obet di aa emga ma Jesi. ");
INSERT INTO uro_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Näkt ma Jesi di aa emga ma Devit kärak i ama vitnaqa na qa. Näkt ma Devit di aa emga ma Solomon nävät ma Uraia aa egutki. ");
INSERT INTO uro_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Näkt ma Solomon di aa emga ma Rehoboam näkt ma Rehoboam di aa emga ma Abiya näkt ma Abiya di aa emga ma Asap. ");
INSERT INTO uro_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Näkt ma Asap di aa emga ma Jehosafat näkt ma Jehosafat di aa emga ma Joram näkt ma Joram di aa emga ma Usia. ");
INSERT INTO uro_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Näkt ma Usia di aa emga ma Jotam näkt ma Jotam di aa emga ma Ahas näkt ma Ahas di aa emga ma Hesekia. ");
INSERT INTO uro_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Näkt ma Hesekia di aa emga ma Manase näkt ma Manase di aa emga ma Amos näkt ma Amos di aa emga ma Josaia. ");
INSERT INTO uro_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Näkt ma Josaia di aa emga ma Jekonia qä na aa matpek dä aa läktpek pät ama qäväläm gärqomni i sa ama ulaqimärharhärhäkt nae ma Babilon da rut na rha nae bä sämät ama värhäm ama mor äm ma Babilon. ");
INSERT INTO uro_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bä nasot toqoräkt i sa rha met sämät ma Babilon di ma Jekonia di aa emga ma Sealtiel näkt ma Sealtiel di aa emga ma Serubabel. ");
INSERT INTO uro_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Näkt ma Serubabel di aa emga ma Abiut näkt ma Abiut di aa emga ma Eliakim näkt ma Eliakim di aa emga ma Asor. ");
INSERT INTO uro_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Näkt ma Asor di aa emga ma Sadok näkt ma Sadok di aa emga ma Akim näkt ma Akim di aa emga ma Eliut. ");
INSERT INTO uro_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Näkt ma Eliut di aa emga ma Eleasar näkt ma Eleasar di aa emga ma Matan näkt ma Matan di aa emga ma Jekop. ");
INSERT INTO uro_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Näkt ma Jekop di aa emga ma Josep kärak i ma Maria arha egutka na qa qärakt i sa qia sa ma Jisas kärak i rhat tes ka i ma Krais. ");
INSERT INTO uro_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Bä äkt i ama qoengitnäk moe mänasäng inamäk nävät ma Abraham bä sävät ma Devit di ama ngärhäqyisem da levaet nä itnäk näkt nävät ma Devit bä sävät iomäkt ama qäväläm gärqomni i sa rha met sämät ma Babilon di ama ngärhäqyisem da levaet ama qoengitnäk näkt nävät iomäkt ama qäväläm gärqomni i sa rha met sämät ma Babilon bä sävät ma Krais di ama ngärhäqyisem da levaet ama qoengitnäk. ");
INSERT INTO uro_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Bä ama sameng sävät ma Maria i sa qia sa ma Jisas ma Krais di rhoqortäqyia, i nga rhoqoräkt i aa nanäk ma Maria di sa rha mumänaris pät a qi iva qia rhät ma Josep bä qoki as kaku in mas gem ne dap sa at sarebäm nävät ama Qloqaqa ama Qumärqumärqa. ");
INSERT INTO uro_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Dä arha egutka ma Josep kärak i ama räkt ka ama ruqa na qa di qaku nani a qa iva qä sämäqlu na qi bä qa muräkt iva qä qutmäs a qi i qaku nani a qa iva qunäga sä qi ge ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sokt di nga rhoqoräkt i qat tu aa snäng sävät tärhong däkt di nak päs da ama ensel nage ma Engeska ma Ngämuqa gem ga da ama masirhämgi arha ron bä qä qoar toqortäqyia, “Josep, ma Devit aa emga na nge, qale ngit len iva ngia rhät ma Maria iva gia egutki na qi inguna iaqäkt ama rhoemga qärak i sa at sarebäm na qa di qa nävät ama Qloqaqa ama Qumärqumärqa. ");
INSERT INTO uro_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Bä va qi sa ama rhoemga dä va ngia rhes aa ngärhipki i ma Jisas inguna qa diva qa rhumaiar aa ruvek nämät arha vuirhong.” ");
INSERT INTO uro_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Rhangät täkt ama lat moe di sa ngä märanas ivakt iva rhäkmamär nä iangärhäkt ama enge qärangätni i sa ma Engeska ma Ngämuqa qa märhamän mät akni aa vämginaqa rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“As ngäni lu i ama säs ki ama evopki diva at sarebäm bä va qi sa ama rhoemga dä va rha rhes aa ngärhipki i ma Imanuel” i iaqyäkt ama ngärhipki di at tarimini rhoqortäqyia, ma Ngämuqa di qale qa qä na ut. ");
INSERT INTO uro_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Bä nga rhoqoräkt i ma Josep ka rhäqäm nämät ama mänäpki dä sa qa mualat parhäm ama ensel nage ma Engeska aa enge bä ba qa i qa mät a qi iva aa egutki na qi ");
INSERT INTO uro_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","sokt di qaku in mas kä na qi bä dängdäng doqoräkt i sa qia sa ama rhoemga. Dä qa mes aa ngärhipki i ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Vät ama qäväläm gärqomni i ma Herot kat turäkt i ama vitnaqa na qa di nasot i ma Jisas aa nanäk kia säl a qa e mät ama värhäm ama gaini na äm ma Betlehem bät ama ngärhäktka ma Judia di nak ama mädräm da ama gamoe rha män näsäng ama qunäga aa qamäs bä sämät ma Jerusalem ");
INSERT INTO uro_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","i rhi snanbät toqortäqyia, “Iaqäkt kärak i sa aa nanäk kia säl a qa i ama Judaqäna arha vitnaqa na qa di qa qoe nai? Inguna sa ut lu aa qaega rhoqoräkt i qa sek mes bä sa ut män ivakt iva urhi ansäs sagem ga.” ");
INSERT INTO uro_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bä nga rhoqoräkt i ama vitnaqa ma Herot ka nari rhoqoräkt dä qa qä na ama Jerusalemgäna moe di qänäskänes ta masirhat. ");
INSERT INTO uro_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Bä äkt i qa västämne na ama priskäna ama moräs na rha rhi na ama Skraipkäna bä ba ama ruvek moe bä qa qyarmät na rha mamär sävät ma Krais iva aa nanäk ki säl a qa qoe. ");
INSERT INTO uro_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Dä rha qoar na qa rhoqortäqyia, “E ma Betlehem bät ma Judia inguna sa akni ma Ngämuqa aa vämginaqa qa säm doqoräkt toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Bä ainge ma Betlehem bät ama ngärhäktka ma Juda di nak kaku ama gaini na nge mamär mänguräp ama tpäskinarha e vät ma Juda inguna näväm nge diva akni ama tpäskinaqa qa rhän gärak iva qät lu vät gua ruvek ama Israelqäna mamär.’” ");
INSERT INTO uro_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nasot dä ma Herot ka rhäkne nani ama mädräm da ama gamoe ma ama up bä qa qyarmät na rha iva rhi qoar na qa i sa vuk sa ama qaega qäsnia. ");
INSERT INTO uro_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Dä qa rhäk na rha sae ma Betlehem i qä qoar na rha rhoqortäqyia, “Ngän det bä ngäni ñäm mamär nani ama rhoemga bä nga rhoqoräkt i sa ngän män bät a qa dä va ngän dän sagem ngo sa ama enge ivakt iva qosaqi ngo di mamär vät a ngo iva ngua rhän bä ngu ansäs sagem ga.” ");
INSERT INTO uro_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nasot i sa rha nari ama vitnaqa aa enge dä rha met näva arha iska. Bä nak iaqäkt ama qaega qärak i sa qre rha lu qa i qa sek mes bä qa met pa arhä qamäs bä dängdäng i qa mair daver ama ivärhäs äkt i ama rhoemga qa e. ");
INSERT INTO uro_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bä nga rhoqoräkt i rha lu ama qaega dä rhi qok masirhat bä arhä märmärgem di ama mor ngät mamär. ");
INSERT INTO uro_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dä rha met säva ama vätka bä rha lu qa rhoemga i qale qa qä na aa nanäk ma Maria dä arpus na rha samäk bä rhi nänsäs sagem ga. Näkt nasot dä rha rharmät arhä qärhong na ama mämägän ama vit na ngät bä rha von ga rha ama vänbon na ama gol dä na ama frankinsens dä na ama mir. ");
INSERT INTO uro_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sa evär däm da säva arhä ivärhäs maräkt näva akni ama iska inguna sa rha rha ama mugem da ama masirhämgi arha ron iva qale evär däm da sae sage ma Herot. ");
INSERT INTO uro_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bä nga rhoqoräkt i sa ama mädräm da ama gamoe rha met nae di nak ama ensel nage ma Engeska vuk sä qa ge ma Josep da ama masirhämgi arha ron dä qa qoar na qa rhoqortäqyia, “Ngia rhäranas bä ngi rha ama rhoemga qä na aa nanäk bä ngäni ang sae ma Isip näkt pa qale ngän e bä dängdäng i ngu qoar na nge inguna sa qorhäs iva ma Herot kä ñäm nani qa rhoemga ivakt iva qä veng ga.” ");
INSERT INTO uro_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Dä ma Josep ka märanas bä qa rha ama rhoemga qä na aa nanäk näp bängagi bä rha met sae ma Isip. ");
INSERT INTO uro_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bä qale rha äkt bä dängdäng i sa ma Herot ka ñäp. Rhangät täkt ama lat divakt iva rhäkmamär nä iangärhäkt ma Engeska aa enge qärangätni i sa qa märhamän bät a ngät nämät aa vämginaqa rhoqortäqyia, “Sa ngua mes ngua emga nae nävä ma Isip.” ");
INSERT INTO uro_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Bä nga rhoqoräkt i sa ma Herot ka lu i sa ama mädräm da ama gamoe rha iras täm ga dä nasot dä qär qur masirhat dä qa rhäk na ama ulaqimärharhärhäkt bä rha veng ama rhoes ama gamoe moe e mät ma Betlehem bä qosaqi vät ama ngärhäktka moe namet a äm gärarhani i arhä quiaiom di ama udiom bä rhänavuk parhäm ama rhodäm gärangätni i sa qa rha ngät mamär nage ama mädräm da ama gamoe. ");
INSERT INTO uro_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Di rhoqoräkt di sa rhäkmamär na ama enge qärangätni i sa ama vämginaqa ma Jeremaia qa märhamän bät a ngät toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Sa rha nari akni ama eguinga e ma Rama i na ama näknoqi dä ama muqaia masirhat. Ma Rasiel qit nok nani at toes dä sa qia mer tit sämbulap täm gi inguna ama rhoes di sa qäbäs na rha.” ");
INSERT INTO uro_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Sokt di nga rhoqoräkt i sa ma Herot ka ñäp di nak puk sa akni ama ensel nage ma Engeska da ama masirhämgi arha ron ge ma Josep e vä ma Isip ");
INSERT INTO uro_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","i qä qoar toqortäqyia, “Ngia rhäranas bä ngi rha ama rhoemga qä na aa nanäk bä ngän det sävät ama ngärhäktka ma Israel inguna iarhakt kärarhae i sa rha siqut iva rhi veng ama rhoemga di sa rha ñäp.” ");
INSERT INTO uro_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Bä nasot dä qa märanas i qät ta ama rhoemga qä na aa nanäk bä rha met sävät ama ngärhäktka ma Israel. ");
INSERT INTO uro_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Sokt di nga rhoqoräkt i qa nari i ma Arkelaus di qat turäkt e ma Judia i sa qa rha aa mamäk ma Herot aa släqyäs dä ma Josep kät len gä namet sae. Dä qa rha ama mugem da ama masirhämgi arha ron iva qale qä namet e bä äkt i qa met sävät ama ngärhäktka ma Galili. ");
INSERT INTO uro_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Bä qa met bä qat tas e mät ama värhäm ama gaini na äm gärqom i rhat tes äm i ma Nasaret ivakt iva rhäkmamär na ama enge qärangätni i sa ama vämginarha rha märhamän bät a ngät toqortäqyia, “Va rhat tes ka i ama Nasaretka na qa.” ");
INSERT INTO uro_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Vät iangärhäkt ama qunäng dä ma Jon ama Baptais ka män bät ama qräk dä bäs ama ivärhäs e ma Judia i qä sameng doqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Ngäni näpgoer na nas inguna iaqäkt na rhävuk aa Muräktpäm di sa nga e glaqot.” ");
INSERT INTO uro_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Inguna ma Jon di iaqäkt kärak i sa ma Aisaia ma Ngämuqa aa vämginaqa qa märhamän sävät a qa rhoqoräkt i sa qa qoar toqortäqyia, “Ama eguinga qät näs pät ama ivärhäs ama qräk dä bäs toqortäqyia, ‘Ngäni rhäkmu na ama iska nanokt ma Engeska i ngäni slaräkt na ama is nanokt ka.’” ");
INSERT INTO uro_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Bä ma Jon aa boi qärangätni i qat don mät ngät di na ama kamel aa qäseng näkt kät kop mäni nas na ama saunga na ama släktka aa ngädäga dä aa tmäs di ama mes dä ama mäsu näva urqi. ");
INSERT INTO uro_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Vät iomäkt ama qäväläm di ama ruvek nae ma Jerusalem dä iarhakt moe nae ma Judia dä nävät ama ngärhäktka rhage rhage na ama rigi ma Jordan moe di sa rhat dän sagem ga ");
INSERT INTO uro_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","bä rhi sameng irhäm mes sa arha vuirhong bä qä baptais pät a rha mäni ama rigi ma Jordan. ");
INSERT INTO uro_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Sokt di nga rhoqoräkt i ma Jon ga lu ama rhäqäp na rha ama Farisiqäna dä ama Sadyusiqäna i rhat dän iva nani ama baptais dä qa qoar na rha rhoqortäqyia, “Aingän gärarhae i ama guläñgi na ama uiuvärhirhong na ngän gärqärhongni i irhong ngärhit kut na ama qänogi, sa auge qa qoar na ngän i mamär iva ngäni ingis ma Ngämuqa aa uraqi ama mor qi qäraktni iva nasot dä qia rhän? ");
INSERT INTO uro_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mamär iva ngäni sa ama gavam nävät angäna lat i ngän näpgoer na nas. ");
INSERT INTO uro_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bä qale ngän du angän snäng iva ngäni qoaräs na ne i, ‘Ma Abraham di aut mamäk na qa’ inguna ngu qoar na ngän i nak kop mamär vät ma Ngämuqa iva qä näpgoer nä rhaerhangät ama dui bä va ngä rhän i ama rhoes bä bä ma Abraham. ");
INSERT INTO uro_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sa qäqi rhäkt di sa akni qa rhäkmu na nas sa ama apem iva qä nasäng i qät tap säng ama ngämung na qi. Dä ama ngämung moe qärangätni i sa qaku ngärhit sa anga mär ngät anga gavam diva rhit täpmät na ngät samäk bä rhit don na ngät sämät ama mudäbäs. ");
INSERT INTO uro_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Sa ngu baptais pät a ngän na ama rigi inguna nävät angäna lat i ngän näpgoer na nas sokt di iaqäkt kärak iva dängdäng na qa nasot a ngo di aa qrot ngä vit pät gu qrot angät tpäs dä aa sandal di ngo di qaku ama märqa na ngo iva qäqi ngut ta ngät. Qa diva qä baptais pät a ngän na ama Qloqaqa ama Qumärqumärqa dä na ama mudämgi. ");
INSERT INTO uro_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Sa qa rhäkmu na nas iva qä rharmeng da ama tmäs näva ama qlanäga dä va qä rharmeng da ama tmäs bä qa rhon sä ngät säva vät dap pa qä rhon na ama qlanäga sämät ama mudam gärangätni i sa qaku mamär vät aung iva qä naveng bät a ngät.” ");
INSERT INTO uro_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Dä nasot dä ma Jisas ka män nae ma Galili bä sämäni ama rigi ma Jordan sage ma Jon ivakt iva ma Jon gä baptais pät a qa. ");
INSERT INTO uro_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bä ma Jon di vadi mai qaku qä narhares pät aa rhäng iva qa rhualat toqoräkt i qä qoar toqortäqyia, “Ngut läk nani ama baptais nagem nge sokt di nak ngiat dän nani ama baptais nagem ngo.” ");
INSERT INTO uro_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sokt di ma Jisas ka muvät pät a qa rhoqortäqyia, “Mamär iva rhäkt diva rhoqoräkt inguna iangärhäkt ama lat di ama märäm ivakt iva uni rhäkmamär na ama räkt ngät ama lat moe.” Dä ma Jon ga rhares iva qä baptais pät ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bä nga nasot i ma Jisas ka rha ama baptais dä vuk sä qa namäk masägos näva ama rigi dä nak ama usäpki qia qang ba qa bä qa lu ma Ngämuqa aa Qloqaqa i arhar sä qa i qa rhoqor ama simängaqa bä qa muqun bät a qa. ");
INSERT INTO uro_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Dä nak ama eguinga näda ama usäpki arha ron ga qoar i, “Rhak täkt di ngua emga qärak i sa gua snäng bät a qa qärak i sa märmär gem ngo masirhat nävät a qa.” ");
INSERT INTO uro_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nasot dä ama Qloqaqa qa er nanokt ma Jisas sävät ama ivärhäs ama qräk dä bäs ivakt iva ma Sämga qä siqut na qa. ");
INSERT INTO uro_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Bä vät ama ruiom ama udiom ama qunäng dä ama ruiom ama udiom ama bängang dä qa meranot bä nasot dä anoeng mä qa. ");
INSERT INTO uro_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Dä ama ruqa qärak i qat dräm gä siqut na ama ruvek ka män bä qa qoar nä ma Jisas toqortäqyia, “Ngakt bä ma Ngämuqa aa emga na nge dä mamär iva ngi qoaräs nä rhärhangät täkt ama dui iva ngä rhän i ama bretkäna.” ");
INSERT INTO uro_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sokt di qa muvät toqortäqyia, “Ma Ngämuqa aa enge qärangätni i sa rha säm a ngät di ngät tamän doqortäqyia, “‘Ama ruvek diva rhat däqäm di qaku sokt da ama bret dap kinak pa rhat däqäm nävät ama enge moe qärangätni i ngät dän nämät ma Ngämuqa aa vämgi.’” ");
INSERT INTO uro_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nasot dä ma Sämga qa artäm sä qa sae sämät ama qumärqumär äm mamär ama värhäm ma Jerusalem näkt ka qoar nä ma Jisas bä qa mair tävuk da ama ansäspämgi ama mor qi at täväs mamär. ");
INSERT INTO uro_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Näkt ma Sämga qa qoar na qa rhoqortäqyia, “Ngakt bä ma Ngämuqa aa emga na nge dä ngi rhon na nas mane inguna ma Ngämuqa aa enge qärangätni i sa rha säm a ngät di ngät tamän doqortäqyia, “‘Va qa rhuräkt bä ba aa enselqäna sävät a nge’ dä qosaqi “‘Va rhi sek mä nge na arhä rhäkt i varis ngi nanguñ gi nga qäraet mäni anga duiqa.’” ");
INSERT INTO uro_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Dä ma Jisas ka qoar na qa rhoqortäqyia, “Qosaqi rha säm ama enge qärangätni i ngät tamän doqortäqyia, ‘Qale ngi siqut nä ma Engeska gi Ngämuqa.’” ");
INSERT INTO uro_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nasot dä ma Sämga qa er nanokt ka säda ama uiu qi mamär ama damgi at täväs bä qa qur ma Jisas ta ama muräktpäm moe vät ama ivätki ngä na angät murhämeska. ");
INSERT INTO uro_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Näkt ma Sämga qa qoar nä ma Jisas toqortäqyia, “Va ngu von nge rha rhärhangät täkt moe qrekt bä ngi an dä gi quum sä nas bä ngi von dä gi qutdrir sagem ngo.” ");
INSERT INTO uro_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Dä ma Jisas ka qoar na qa rhoqortäqyia, “Sämga, ngia rhet! Inguna sa rha säm ama enge qärangätni i ngät tamän doqortäqyia, “‘Mamär iva ngi nänsäs sage ma Engeska gi Ngämuqa bä va sokt ka qärak iva qale nge va aa rem.’” ");
INSERT INTO uro_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dä ma Sämga qa met daqule qa dä nak ama enselqäna rha män bä rhat tatnärhäm ga. ");
INSERT INTO uro_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Bä nga rhoqoräkt i sa qa nari i sa rha mu ma Jon ba ama tpäskiarharhäng dä qa met sae ma Galili. ");
INSERT INTO uro_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Näkt ka met nae ma Nasaret bä qa met bä sämät ama värhäm ama mor äm ma Kaperneam bä qat tas e qärqomni i qale läm bät ama namuqa aa väm e va ma Sebulun dä ma Naptali in ngärhäqyiom. ");
INSERT INTO uro_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iangärhäkt ama lat divakt iva rhäkmamär na ama enge qärangätni i sa ama vämginaqa ma Aisaia qa märhamän bät a ngät toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Vät ama ngärhäqyiom i ma Sebulun dä ma Naptali di ama iska qat tet parhäm ama namuqa aa rhäkt tage na ama rigi ma Jordan. Bä e vät ama ngärhäktka ma Galili di ama Jentailqäna ");
INSERT INTO uro_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","qärarhani i sa qale rha va ama bängangit angät tpäs di sa rha lu akni ama neraqa ama mor qa dä bä bä iarhakt kärarhae i qale rha vät ama ivärhäs kärqosni i ama tñäpki qia ong da di sa irige sa ama neraqa sävät a rha.” ");
INSERT INTO uro_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mänasäng na äkt dä ma Jisas ka nasäng iva qä sameng i qä qoar toqortäqyia, “Mamär iva ngäni näpgoer na nas inguna iaqäkt na rhävuk aa Muräktpäm di sa nga e glaqot.” ");
INSERT INTO uro_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Bä vät ama qäväläm gärqomni i ma Jisas kat tet pät ama namuqa ma Galili aa rhäkt dä qa lu ama ruiom ama sägiom ma Saimon gärak i rhat tes ka i ma Pita qä nä aa läktka ma Andru i init don na ama väiuqi va ama namuqa inguna iom di ama väiumärhindäkt. ");
INSERT INTO uro_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Dä qa qoar na iom doqortäqyia, “Ini ang bä init päs gua rhäng bä va ngu su en iva ini rhar sa ama ruvek i rhoqor ma i ini rhar sa ama rhinäm.” ");
INSERT INTO uro_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dä in märanas masägos daqule in bäiu bä in met nasot ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Dä qa met na äkt bä qa lu aiomni ama sägiom ma Jems ma Sebedi aa emga qä na aa läktka ma Jon i qali liom mät ama mlauski ge in mamäk ma Sebedi i ini masartäm mät ama lek pät in bäiu. Dä ma Jisas ka mes iom. ");
INSERT INTO uro_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Dä in met daqule ama mlauski dä in mamäk masägos bä in met nasot a qa. ");
INSERT INTO uro_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Bä qa met e vät ma Galili moe bä qä su va arhä mämairväm dä qä sameng na ama sameng ama mär ngät sävät ama Muräktpäm näkt kat tumäräspät nämät ama räm moe qärangätni i maos maos na ngät dä ama märän moe mänguräp ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bä äkt i aa ngärhipki qia met namet ama ngärhäktka ma Siria moe dä ama ruvek ta män sa ama rämgivärharha moe sagem ga. Sa rha män sä iarhakt kärarhae i arha räm maos maos dä ama ruan dä qärarhani i ama iaus ngärhit täk pät a rha dä qärarhani i sa guani na rha dä ama ngäñäpärharha bä qa mumäräs pät a rha. ");
INSERT INTO uro_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Dä ama mor ngät ama gulañ na ama ruvek ta met nasot a qa nae ma Galili dä nämät ama värhap ama ngärhäqyisem na ap dä nae ma Jerusalem dä nae ma Judia dä nae närhage na ama rigi ma Jordan. ");
INSERT INTO uro_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Bä nga qa lu ama gulañ na ama ruvek dä qa met savono sämäni ama damgi bä nga rhoqoräkt i sa qa muqun dä aa mudäsaqongda rha män sagem ga. ");
INSERT INTO uro_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Dä qa nasäng iva qä su rha i qä qoar toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ma Ngämuqa aa modämne di sa nga e ge iarhakt kärarhae i rhit läk pät ama qloqaqa aa qäge inguna rha diva bä ba rha nä iaqäkt na rhävuk aa Muräktpäm. ");
INSERT INTO uro_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Ma Ngämuqa aa modämne di sa nga e ge iarhakt kärarhae i rhit nok. Rha diva ma Ngämuqa qä säm ama bulap sävät arha iar. ");
INSERT INTO uro_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Ma Ngämuqa aa modämne di sa nga e ge iarhakt kärarhae i ama bulap ta ama ruvek na rha. Rha diva bä ba rha na ama ivätki. ");
INSERT INTO uro_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Ma Ngämuqa aa modämne di sa nga e ge iarhakt kärarhae i anoeng mä rha dä aqäsäk ta nani ama räkt ngät ama lat. Rha diva qä rhäqäp ta bä va mamär na rha. ");
INSERT INTO uro_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Ma Ngämuqa aa modämne di sa nga e ge iarhakt kärarhae i rhir qur arhani rha ama lavuqi. Rha diva qär qur a rha rha ama lavuqi. ");
INSERT INTO uro_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Ma Ngämuqa aa modämne di sa nga e ge iarhakt kärarhae i ama qumärqumär arhä snängaqa. Rha diva rhi lu qa. ");
INSERT INTO uro_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Ma Ngämuqa aa modämne di sa nga e ge iarhakt kärarhae i rhat tu ama bulap mänguräp arhani. Rha diva qat tes ta i aa es na rha. ");
INSERT INTO uro_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Ma Ngämuqa aa modämne di sa nga e ge iarhakt kärarhae i ama ruvek ti sangäm na rha rhoqoräkt i rhat tualat na ama räkt ngät ama lat. Rha diva bä ba rha nä iaqäkt na rhävuk aa Muräktpäm. ");
INSERT INTO uro_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ma Ngämuqa aa modämne di sa nga e gem ngän gre i sa arhani rhat tamän mava na ngän dä rhi sangäm na ngän mavängam dä rhat tamän na ama vu ngät ama enge moe maos maos mavängam sävät a ngän inguna nävät a ngo. ");
INSERT INTO uro_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mamär iva märmär gem ngän bä ngäni qok inguna angän ditsek di ama mor ngät da ama usäpki arha ron inguna sa ama ruvek ta sangäm na ama vämginarha mavängam doqoräkt kärarhae i sa mudu rha män ba angän gamäs. ");
INSERT INTO uro_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Aingän di ama qyiräpki na ngän bä ba ama ruvek nämäni ama ivätki sokt di ngakt bä sa rhäksot na ama qyiräpki at märmät dä ngu lu va saqi as arha anga märmät ngä rhän doqor mäniekt? Qi di sa qaku mamär vät guani na qi dap kinak pa rhit don na qi dalek bä va ama ruvek ti naengmät na qi va arhä qar angärha rem. ");
INSERT INTO uro_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Aingän di ama neraqa na ngän bä ba ama ruvek nämäni ama ivätki. Ama värhäm gärqomni i qale läm da ama dabäm angät tpäs di qaku mamär iva aung gä nangaip äm. ");
INSERT INTO uro_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bä qosaqi qaku ama ruvek ti namudäm säda ama lirhäga bä rha rhu qa va anga uratki arha rem dap kinak tat tu qa rhävuk bä äkt i qät bon da ama neraqa bä bä iarhakt moe qärarhae i sa qale rha va vät. ");
INSERT INTO uro_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mamär iva ngän doqor ama lirhäga rhoqoräkt bä va angän neraqa qä sen da arhani arhä saqong ivakt iva mamär vät a rha iva rhat lu angäna lat ama mär ngät bä va rhit bon da ama murhämeska sage angän mamäk da ama usäpki arha ron. ");
INSERT INTO uro_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Qale ngän namu angän snäng i sa ngua män ivakt iva ngu rhäksot nä ma Ngämuqa aa Muräkt nage ma Moses ura ama vämginarha arha enge. Sa qaku ngua män ivakt iva ngu rhäksot na ngät dap kinak ngua män ivakt iva ngu rhäkmamär na ngät. ");
INSERT INTO uro_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Inguna sa ngu qoar na ngän na ama engäktki iva dängdäng dä qäbäs na ama usäpki dä ama ivätki dap pa qaku qäqi anga gaini mamär anga muqunänini diva rhäksot nä ini nämäni ma Ngämuqa aa Muräkt nage ma Moses. Diva rhoqoräkt bä dängdäng iva iarhongäkt moe qärqärhong i sa rha säm irhong di irhong ngä rhu irhong angät släqyige vät a nas. ");
INSERT INTO uro_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Dä soknga aung gärakni i qäqi qä nänbetäkmät na angätni anga gaini na ngät anga muräkt nävät iangärhäkt ama muräkt dä qä su arhani ama ruvek iva rhat tualat toqoräkt diva iaqäkt na rhävuk kat tu aa snäng i qa di ama gaini na qa mamär da aa Muräktpäm angärha ron. Sokt di aung gärakni i qat tet parhäm ama muräkt dä qä su arhani iva rha rhualat toqoräkt dä va iaqäkt na rhävuk kat tu aa snäng i iaqäkt ama ruqa di ama mor qa na qa mamär da aa Muräktpäm angärha ron. ");
INSERT INTO uro_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Inguna sa ngu qoar na ngän iva qaku ngän namon sädä iaqäkt na rhävuk aa Muräktpäm angärha ron grekt bä qaku angäna lat ama räkt ngät ngät tet e na ama Skraipkäna dä ama Farisiqäna arha lat. ");
INSERT INTO uro_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Sa ngän nari i mudu arhani rhi qoar na angän mamäkkäna rhoqortäqyia, ‘Qale ngi veng dap aung gärakni i qä veng diva qä rha ama matnävämne.’ ");
INSERT INTO uro_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Sokt di ngo di ngu qoar na ngän i aung gärakni i qär qur akni ama ruqa diva qä rha ama matnävämne dä aung gärakni i qat tuma akni ama ruqa diva qä rhäväkt sa aa lat da ama morta arhä saqong dä aung gärakni i qat tamän doqortäqyia, ‘Ainge di ama dädänga!’ diva qa rhet sämät ama mudäbäs ama sok tä bäs. ");
INSERT INTO uro_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Bä äkt i ngakt bä ngit boda gi vänbon bät ama laiqa na ama vodämes näkt nga vuk pät a nge i nak sa qaku märmär ge akni nävät a nge ");
INSERT INTO uro_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","dä va ngia rhet daqule gi vänbon äkt ge ama laiqa na ama vodämes dap ngia rhet bä ama narhoeräm diva ngia rhuräkt mänguräp mä en ngi na qa bä nasot näkt sa ngia rhän bä ngi vodä gi vänbon. ");
INSERT INTO uro_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Mamär iva ngi lir ngia rhuräkt mänguräp mä en ngi nä qa ruqa as pa ama muräkt angät kamäs i varis kä navon däm nge sage ama matnävämnenaqa bä nasot dä va qa rhu nge va ama ulaqimärhaarhäkt aa rhäkt näkt pa qa rhu nge va ama tpäskiarharhäng. ");
INSERT INTO uro_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ngu qoar na nge na ama engäktki iva qaku mamär iva vuk sä nge bä dängdäng iva ngia rhuvät na ama dändängini nä ini ama brasini. ");
INSERT INTO uro_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Sa ngän nari i mudu arhani rhi qoar toqortäqyia, ‘Qale ngi qavatnävätlägut.’ ");
INSERT INTO uro_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sokt di ngo di ngu qoar na nge i aung anga ruqa qärakni i sävetka qat lu ama evopki na ama snängaqa na ama qavatka di sa qa qavatnävätlägut kä na qi mät aa snängaqa. ");
INSERT INTO uro_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ngakt bä gi märmär qa gi saqongaqa qä rhartäm sä nge iva ngia rhualat na anga vuini dä va ngia rhar täm ga bä ngi rhon na qa nae. Inguna va ama märäm doqoräkt iva qäbäs na aomni ama qäväläm nävät gi släqyige dap pa qaku ama märäm doqoräkt iva gi släqyige moe di rhi rhon nä ige sämät ama ivärhäs na ama mudäbäs ama sok tä bäs. ");
INSERT INTO uro_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Dä ngakt bä gi märmär et ngia rhäqyet ngärhi rhartäm sä nge iva ngia rhualat na anga vuini dä ngi rhodäkt sä et bä ngi rhon na et nae. Inguna va ama märäm doqoräkt iva qäbäs na aomni ama qäväläm nävät gi släqyige dap pa qaku ama märäm doqoräkt iva gi släqyige moe ige ngä rhet sämät ama ivärhäs na ama mudäbäs ama sok tä bäs. ");
INSERT INTO uro_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Bä qosaqi sa arhani rhi qoar toqortäqyia, ‘Aung gärakni i qät kutmäs aa egutki di mamär iva qa von gi rha anga abuqit na ama bäñmät.’ ");
INSERT INTO uro_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Sokt di ngu qoar na ngän i aung gärakni i sa qa qutmäs aa egutki dap kaku qia mualat na anga lat na ama qavatka di qat tualat sä qi bä qi qavatnävätlägut. Dä aung gärakni i sa qa mät ama evopki qäraktni i sa arha egutka qa qutmäs a qi di qä qavatnävätlägut. ");
INSERT INTO uro_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Bä qosaqi sa ngän nari i sa mudu arhani rhi qoar na angän mamäkkäna rhoqortäqyia, ‘Qale ngi namusärhämes näkt nasot dä ngit don na nas sävät ama musärhäm angärha rhäng dap kinak pa ngia rhualat bä bä ma Engeska na agi a lat kärangätni i sa ngia musärhämes iva ngia rhualat na ngät.’ ");
INSERT INTO uro_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Sokt di ngu qoar na ngän i nak sa qale ngi namusärhämes näma dä sage ama usäpki inguna sa qale ma Ngämuqa aa mämugunäs e ");
INSERT INTO uro_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ura sage ama ivätki inguna mämae vät aa qäriglem e ura sage ma Jerusalem inguna iomäkt ama värhäm di ama enges ka ama vitnaqa aa värhäm. ");
INSERT INTO uro_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Dä qale ngi namusärhämes nävät ngia väski inguna ainge di sa qaku mamär vät a nge iva ngia rhualat sä gi nga qäsega bä qa rhän i ama qulum ga ura ama iläñ ga. ");
INSERT INTO uro_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Dap kinak mamär iva sokt ngi qoar i ‘Iei’ ura ‘Qaku.’ Dap ngakt bä ngiat tu savono di iangärhäkt ama lat di ngät dän nage ama vu qa ama ruqa ma Sämga. ");
INSERT INTO uro_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Bä sa ngän nari i rhi qoar i, ‘Ngakt bä akni qä slava nä gi saqongaqa dä va ngi slava na aa saqongaqa. Dä ngakt bä akni qä slava nä gia qigi dä va ngi slava na aa qigi.’ ");
INSERT INTO uro_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Sokt di aingo di ngu qoar na ngän i qale ngi natmair särha aung gärakni i ama vu qa. Dap kinak ngakt bä aung gä e säng gia qeng dage vät gi märmär dä qosaqi va ngi rhong na age sävät a qa. ");
INSERT INTO uro_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Dä ngakt bä nani aung iva qa rhu nge va ama muräkt ivakt iva qä rha gi srapki dä mamär iva gia qlak na qa iva qä rha qi näkt kosaqi sävät gi boiqi ama uiu qi navono. ");
INSERT INTO uro_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Dä ngakt bä rhäktuk pät aung sä nge iva ngia rhet ngi na qa vät ama sägäk ama kilomita dä mamär iva ngia rhet ngi na qa vät ama udiom ama kilomitaiom. ");
INSERT INTO uro_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ngi von aung gärakni i qä nän nge dap kale ngi nen aung gärakni i nani a qa iva qä rha ani nagem nge näkt mamär dä va saqi qä evär däm ini. ");
INSERT INTO uro_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Sa ngän nari i rhi qoar i, ‘Mamär iva gia snäng bät gia ruavek maräkt dap ama märäm iva ama vu dä gia ron sävät gia ik.’ ");
INSERT INTO uro_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Sokt di ngo di ngu qoar na nge i, mamär iva gia snäng bät gia ikkäna dä va ngi nän sävät iarhakt kärarhae i rhi sangäm na nge mavängam ");
INSERT INTO uro_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","divakt iva rhoqoräkt di ngän diva angän mamäk aa es na ngän gärak i sa qale qa da ama usäpki arha ron. Inguna sa qat tualat sa aa qunäga iva qä sen sävät ama vu rha ama ruvek ti na ama mär ta ama ruvek dä qät täk na ama suigi bä ba ama räkt ta ama ruvek ti na ama ruvek kärarhani i qaku ama räkt ta na rha. ");
INSERT INTO uro_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Inguna ngakt bä aingän di sokt angäna snäng bät iarhakt kärarhae i arha snäng bät a ngän dä ngu lu angän ditsek di ngä qoe nai? Nga sa qaku qäqi ama ruvek kärarhani i rhit ta ama takes tat tualat toqoräkt? ");
INSERT INTO uro_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Dä ngakt bä sokt ngi rhar sä gia ruavek dä ngu lu nga gia lat ama mär ngät ngät tet e na arhani arha lat ama mär ngät? Nga qaku qäqi ama Jentailqäna rhat tualat toqoräkt? ");
INSERT INTO uro_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Dä soknga mamär iva sa mamär na ngän mamär di qoki rhoqor angän mam dak pono i sa mamär na qa mamär. ");
INSERT INTO uro_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ngänit lu mamär i varis ngän dualat na angäna lat ama räkt ngät da arhani ama ruvek arhä saqong ivakt iva rhat lu ngän inguna rhoqoräkt dä va qaku angän anga rhitsek nage angän mamäk kärak i qale qa da ama usäpki arha ron. ");
INSERT INTO uro_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Bä äkt i qre va ngit bon ama tläkta dä qale ngi naes ama biugal vä gi qamäs toqor ama ruvek tat tualat pa ama mämairväm dä mäni ama is kärarhani i rhat tualat sädä saqong. Tat tualat toqoräkt divakt iva arhani ama ruvek tit sek sä rha. Sa ngu qoar na ngän na ama engäktki i sa rha rha arhä rhitsek. ");
INSERT INTO uro_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Dap kinak kre va ngit bon ama tläkta diva qale ngi naqyiradeng nä ngia rhäqyet ama sael et iva et ngät dräm agi a lat kärangätni i ngia rhäqyet ama märmär et et ngät tualat na ngät ");
INSERT INTO uro_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ivakt iva gi vänbon diva ngit bon däm ngät ma ama up. Dä gi mamäk kärakni i qat lu gia lat kärangätni i ngiat tualat na ngät ma ama up pa qä sek mä nge. ");
INSERT INTO uro_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Bä qre va ngäni nän dä qale ngän namualat toqor ama ruvek kärarhani i rhat tualat sädä saqong. Inguna rha di sa nani a rha masirhat iva rhat mair bä rhi nän ba ama mämairväm dä mät ama ingnas parhäm ama is ivakt iva ama ruvek tat lu rha. Sa ngu qoar na ngän na ama engäktki i sa rha rha arhä rhitsek. ");
INSERT INTO uro_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Sokt kre va ngi nän dä mamär iva ngia rhet sämät ama qäväläm bä gia vätka näkt ngi väs mät ama tmongi bä ngi nän sage gi mamäk kärak i sa qaku ama ruvek tit lu qa. Dä va gi mamäk kärak i qat lu nge äkt pa qä sek mä nge. ");
INSERT INTO uro_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Dä qre va ngi nän dä qale ngiat tamän masirhat pät ama engirhong ama mäñmäñini nä irhong doqor ama Jentailqäna inguna sa rhat tu arhä snäng iva ma Ngämuqa qä nari rha inguna nävät arha engirhong masirhat. ");
INSERT INTO uro_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Qale ngän dualat toqor ta inguna sa angän mamäk kat dräm i agirhong gärqärhongni i sa ngänit läk nani irhong bät ama qäväläm gärqomni i as kaku ngän nän ga rhäm irhong. ");
INSERT INTO uro_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Dä soknga mamär iva ngäni nän doqortäqyia, “Aut mam dak pono da ama usäpki arha ron, mamär iva urhit kutdrir sävät gi ngärhipki i ama qumärqumär qi mamär. ");
INSERT INTO uro_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mamär iva ar sä gi muräkt sarhe bä va iarhongäkt moe irhong ngät tet parhäm gi snängaqa rhe vät ivät i qoki va irhong doqor iarhongäkt da ama usäpki arha ron. ");
INSERT INTO uro_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mamär iva ngi von ut ta ama tmäs kärangätni i urhit läk nani a ngät pät tak täkt ama qunäga. ");
INSERT INTO uro_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Dap pa ngit kyiradeng na aurha vuirhong doqor qre i sa ut kyiradeng na arhani sa arha vuirhong sävät a ut. ");
INSERT INTO uro_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Näkt pa qale ngit kyiradeng na ut sämät ama siqutsiqut dap pa ngiat tumaiar ut nämät ama vuqa. ");
INSERT INTO uro_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Inguna ngakt bä ngänit kyiradeng na arhani sa arha vuirhong di qosaqi angän mamäk tak pono da ama usäpki arha ron ba qät kyiradeng na ngän sa angäna vuirhong. ");
INSERT INTO uro_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Dap kinak ngakt bä qaku ngän naqyiradeng na arhani sa arha vuirhong dä va qosaqi qaku angän mamäk kä naqyiradeng na ngän sa angäna vuirhong. ");
INSERT INTO uro_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Näkt kre va ngän deranot dä qale ngänät nañäm i rhoqor qre i airäs ngän iva ngän doqor ama ruvek kärarhani i rhat tualat sädä saqong gärarhae i rhit kutsasorhane na arhä saqongitnäk ivakt iva ama ruvek tat lu i rhat teranot. Sa ngu qoar na ngän na ama engäktki i sa rha rha arhä rhitsek. ");
INSERT INTO uro_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Dap kinak kre va ngiat teranot dä mamär iva ngit tor gi saqongait näkt ngit prit na ama oel vät ngia väski ");
INSERT INTO uro_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","divakt iva qaku mamär vät ama ruvek iva rhat lu nge i ngiat teranot dap kinak pa sokt gi mamäk kat lu gia lat toqoräkt. Dä gi mamäk kärak i sa qat lu gia lat kärangätni i ngiat tualat na ngät ma ama up diva qä sek mä nge. ");
INSERT INTO uro_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Qale ngän duvärhane na ama mämägän bä ba nas te vät ivät i äkt di mamär iva ama gärhañ ngät täs ngät dä ama urunga qä slava na ngät dä ama suarha rhi nändrukdäm bä rhi sua rhäm ngät. ");
INSERT INTO uro_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Dap kinak mamär iva ngän duvärhane na ama mämägän bä ba nas tävuk da ama usäpki arha ron i äkt di qaku mamär iva anga gärhañ ura anga urunga ngä naslava na ngät ura ama suarha rhi nändrukdäm bä rhi sua rhäm ngät. ");
INSERT INTO uro_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Inguna äkt i sa qale gi mämägän e di qosaqi va qale gi snängaqa e. ");
INSERT INTO uro_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ama saqong di ama lirhäga bä ba ama släqyige. Bä äkt i ngakt bä ama mär gi saqong dä va rhäqäp gi släqyige moe na ama neraqa. ");
INSERT INTO uro_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Sokt di ngakt bä ama vu gi saqong dä va rhäqäp gi släqyige moe na ama bängangit. Ngakt bä ama neraqa väm ngän di ama bängangit mät ka dä sirhäkt ama mor it mamär ama bängangit päm ngän! ");
INSERT INTO uro_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Qaku mamär vät aung iva qat tualat bä ba ama udiom ama moriom inguna ngakt dä va ama vu da aa ron sävät akni dä va aa snäng bät akni ura ngakt dä va qä vodäm mes sage akni dä va ama vu da aa ron sävät akni. Qaku mamär vät a ngän iva ngän dualat pä ma Ngämuqa aa rem dä qosaqi ngän dualat pa ama ligär angärha rem. ");
INSERT INTO uro_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Dä soknga ngu qoar na ngän iva qale qänäskänes ngän sävät angäna iar iva ngän däs agiqa ura va ngäni näkt agiqa bä qale qänäskänes ngän sävät angän släqyige iva ngän don mät agiqa. Nga qaku ama iar ngä vit pa ama tmäs angät tpäs? Dä nga qaku ama släqyige ngä vit pa ama boi angät tpäs? ");
INSERT INTO uro_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ngäni lu ama isäm mät ama leqäs. Ngät di qaku ngärhit kutnanokt ura ngärhit sekdäm ura ngät turhämne na ama tmäs säva ama vät sokt di angän mamäk tak pono da ama usäpki arha ron gät bon ngät ta ama tmäs. Nga qaku ngän bit pä iangärhäkt angät tpäs? ");
INSERT INTO uro_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Auge nävät a ngän di mamär vät a qa iva qa rhu anga sägäk anga aua sävät aa iar toqoräkt i qänäskänes ka masirhat? ");
INSERT INTO uro_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Dä mäniekt bä qänäskänes ngän sävät ama boi? Ngän du angän snäng sävät ama ngualäñngualañ angärha iar vät ama etki. Qaku ngät tualat ura ngärhit kutäm bät ama boi iva ngät donmät ");
INSERT INTO uro_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","sokt di ngu qoar na ngän i qäqi ama vitnaqa ma Solomon sa aa murhämeska moe di qaku ama mär qa masirhat toqor ama sägäk nävät iangärhäkt ama ngualäñngualañ aa murhämeska. ");
INSERT INTO uro_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Dap kre va ma Ngämuqa qat turha ama mran bät ama etki na angät murhämeska rhoqoräkt kärangätni i rhäqyerhäkt ngät däqäm bä duququ dä rhit päs ngät mät ama mudam dä mänia? Nga va nak kaku ma Ngämuqa qat turhäm ngän mamär masirhat pa angät tpäs? Ai, aingän di ama gaini na angän gatnanakt! ");
INSERT INTO uro_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Dä soknga qale qänäskänes ngän i ngäni snanbät toqortäqyia, ‘Va ut täs agirhong?’ ura ‘Va urhit näkt agirhong?’ ura ‘Va ut don mät na agirhong?’ ");
INSERT INTO uro_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Inguna ama Jentailqäna di arhä snängaqa masirhat sävät tärhong däkt moe dap angän mamäk tak pono da ama usäpki arha ron di qat dräm i ngänit läk nani iarhongäkt moe. ");
INSERT INTO uro_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sokt di ama narhoeräm diva ngäni rhares iva ma Ngämuqa qat turäkt täm ngän bä va qänäskänes ngän iva ngän dualat na ama räkt ngät ama lat da aa saqong dä va qosaqi qä von ngän dä iarhongäkt moe qärqärhong i ngänit läk nani irhong. ");
INSERT INTO uro_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Dä soknga qale qänäskänes ngän sävät ama qunäga duququ inguna duququ dä va qänäskänes ngän sävät iarhongäkt kärqärhong iva irhong ngä rhän duququ. Qoki sa mamär na ama qunäng asägäk asägäk sa aa märänga maräkt. ");
INSERT INTO uro_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Qale ngän datnävämne na arhani sa arha lat ivakt iva qaku ma Ngämuqa qä namatnävämne na ngän sa angäna lat. ");
INSERT INTO uro_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Inguna iangärhäkt ama matnävämne qärangät i sa ngän mualat sävät arhani na ngät diva ma Ngämuqa qa rhatnävämne na ngän na ngät. Bä iaqäkt ama siqutka na ama matnävämne qärak i ngän du qa sävät arhani diva qosaqi ma Ngämuqa qa rhu qa sävät a ngän. ");
INSERT INTO uro_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Mäniekt bä ngi saengäkt sävät ama qlanängini mät gia ruaqa aa saqongaqa dap mavängam bät a nge sa ama ngämunget mät gi saqongaqa maräkt? ");
INSERT INTO uro_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ura mäniekt bä va ngi qoar nä gia ruaqa i, ‘Va ngu qumär sa ama qlanängini nämät gi saqongaqa’ dap kre i sa qale ama ngämunget mät gi saqongaqa maräkt? ");
INSERT INTO uro_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ainge qärak i ngiat tualat sädä saqong, as pa ngi er ngi rha ama ngämunget nae nämät gi saqongaqa maräkt dä nasot dä va mamär vät a nge iva ngiat nañäm mamär ivakt iva ngi rha ama qlanängini nämät gia ruaqa aa saqongaqa. ");
INSERT INTO uro_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Qale ngän navon ama im dä iarhongäkt kärqärhong i ama qumärqumär mamär irhong dä qale ngän narhon nä angän pelqäna bä ba ama vlam i varis ngä nanaengmät na ngät pa angärha qar angärha rem näkt ti rhong sävät a ngän ivakt iva rhi sangäm na ngän. ");
INSERT INTO uro_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ngi nän ma Ngämuqa dä va qä von nge dap pa ngit ñäm nani guani dä va ngia rhän bät ini dap pa ngit kut dä va ama tmongi qi rhar bä ba nge. ");
INSERT INTO uro_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Inguna iarhakt moe qärarhae i rhi nän nani guani diva rhi rha ini dap auge qärak i qät ñäm nani guani diva qa rhän bät ini dap auge qärak i qät kut mät ama tmongi diva qi rhar ba qa. ");
INSERT INTO uro_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ura auge nävät a ngän di ngakt bä ngia emga qä nän nani anga bret dä va qä von ga rha anga duiqa? ");
INSERT INTO uro_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ura ngakt bä qä nän nani anga rhinämga di nak nga va ngi von ga rha anga uiuvärhaqa? ");
INSERT INTO uro_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ngakt bä aingän gärarhae i ama vu rha ama ruvek na ngän di ngänät dräm iva ngänit bon angän oes ta ama mär ngät ama vänbon doqoräkt di ngäktki mamär iva angän mamäk tak pono da ama usäpki arha ron ba qä von da ama märirhong bä bä iarhakt kärarhae i rhi nän ga! ");
INSERT INTO uro_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Bä äkt i iangärhäkt ama lat kärangät i nani a ngän iva arhani ama ruvek tat tualat na ngät sävät a ngän di qosaqi mamär iva ngän dualat toqoräkt sävät a rha inguna ma Ngämuqa aa Muräkt nage ma Moses ngä na aa vämginarha arha enge di ngärhi su ut toqoräkt. ");
INSERT INTO uro_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mamär iva ngän don mät ama gaini na qi ama tmongi. Inguna ama tmongi di ama mor qi dä ama iska iva sämät ama mudäbäs ama sok tä bäs di märmärsäs ge iarhakt ama rhäqäp na rha ama ruvek kärarhae i rhat tet näväm ga. ");
INSERT INTO uro_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Inguna ama tmongi di ama gaini na qi dä ama iska iva säda ama iar angärha ron di ama qrot ge iarhakt ama ruvek ama marheka na rha qärarhae i rhat dän bät a qi. ");
INSERT INTO uro_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ngänit lu nämät ama iraski na rha ama vämginarha qärarhani i rhat dän sagem ngän di rhat nañäm doqor ama sipsipkäna dap kinak ama mäsmäs päm ngät ama muräp na rha. ");
INSERT INTO uro_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Diva qunäga vät a ngän sä rha nävät arhä gavam. Nga va ama ruvek tit ta anga wain angät gavam nävät ama ritgung? Ura nga va rhit ta anga gosaqi at gavam nävät ama gurhäk? ");
INSERT INTO uro_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Bä äkt i ama mär ngät ama ngämung moe di ngärhit sa ama mär ngät ama gavam dap ama vu ngät ama ngämung di ngärhit sa ama vu ngät ama gavam. ");
INSERT INTO uro_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ama mär qa ama ngämuga di qaku mamär vät a qa iva qät sa anga vu ngät anga gavam dap kosaqi qaku mamär vät ama vu qa ama ngämuga iva qät sa anga mär ngät anga gavam. ");
INSERT INTO uro_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ama ngämung moe qärangätni i qaku ngärhit sa anga mär ngät anga gavam diva rhit täp mä ngät samäk bä rhit don na ngät sämät ama mudäbäs. ");
INSERT INTO uro_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Bä äkt iva qunäga vät a ngän sä iarhakt ama iraski na rha ama vämginarha nävät arhä gavam. ");
INSERT INTO uro_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Qaku ama ruvek moe qärarhani i rhat tes ngo i ‘Gua Engeska, gua Engeska’ diva rha rhon sädä iaqäkt na rhävuk aa Muräktpäm angärha ron dap sokt iaqäkt kärak i qat tualat parhäm gu mamäk aa snängaqa qärak i qale qa da ama usäpki arha ron diva qa rhon sae. ");
INSERT INTO uro_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Vät iaqäkt ama qunäga dä va ama rhäqäp na rha ama ruvek ti qoar na ngo i, ‘Gua Engeska, gua Engeska, nga qaku sa ut märhamän bät ama enge qärangätni i ngät dän maräkt nage ma Ngämuqa nävät gi ngärhipki? Dä nga qaku sa ut kutmäs ama iaus nävät gi ngärhipki dä ut mualat na ama qrot ngät ama lat masirhat nävät gi ngärhipki?’ ");
INSERT INTO uro_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Bä nasot dä va ngu qoar na rha rhoqortäqyia, ‘Qaku nguat dräm a ngän. Ngän det nävät a ngo aingän gärarhae i qaku ngän dualat parhäm ama muräkt.’ ");
INSERT INTO uro_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Bä äkt i aung gärakni i qat nari rhangät täkt gua enge dä qat tualat parhäm ngät diva qa rhoqor ama ruqa sa ama mädräm ama mär ngät kärakni i sa qa rhäk pät aa vätka aa ribit saimäk i ama qrot it pät ama sinäpki arha rhäng. ");
INSERT INTO uro_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bä nga ama soeng ngä säp dä ama qärhop ngä män dä ama laur ngärhi e dä ngä qut pät iaqäkt ama vätka sokt di qaku arpus na qa inguna iaqäkt ama ruqa di sa qa rhäk pät aa vätka mamär vät ama sinäpki arha rhäng. ");
INSERT INTO uro_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Dap aung gärakni i qat nari rhangät täkt gua enge näkt kaku qat tualat parhäm ngät diva qa rhoqor ama dädän ga ama ruqa qärakni i sa qa rhäk pät aa vätka vät ama qunga. ");
INSERT INTO uro_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Bä nga ama soeng ngä säp dä ama qärhop ngä män dä ama laur ngärhi e dä ngä qut pät iaqäkt ama vätka dä arpus nä qa mäk bä sa mava na qa mas.” ");
INSERT INTO uro_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Bä nga ma Jisas ka märhamän bät tangät täkt ama enge na ama siqut bä rhäksot dä ama gulañ na ama ruvek di qräk mät ta nävät aa rhisu ");
INSERT INTO uro_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","inguna sa qä su rha di qa rhoqor aung gärakni i ama qrot nga e gem ga dap kaku qä su rhoqor arhä Skraipkäna. ");
INSERT INTO uro_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Bä nga sa ar sä ma Jisas nämäni ama damgi dä ama mor ngät ama gulañ na ama ruvek ta met nasot a qa. ");
INSERT INTO uro_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Dä nak akni ama biaspärhaqa qa män sage ma Jisas bä qa an da aa quum sä nas säng aa qar dap kät nok pät a qa i qä qoar toqortäqyia, “Gua morqa, ngakt bä nani a nge di märmärsäs gem nge iva ngia rhumäräs pät a ngo.” ");
INSERT INTO uro_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dä ma Jisas ka rhäk aa rhäqyet bä qa rhäk pät a qa i qä qoar toqortäqyia, “Ari, nani a ngo, rhäkt di sa märäs pät a nge bä ama qumärqumärqa na nge.” Dä sa märäs pät kärak masägos nämät aa bias. ");
INSERT INTO uro_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Dä ma Jisas ka mugem ga rhoqortäqyia, “Qale ngi naqoar na aung sävät a nas dap kinak pa ngia rhet bä ngi qur ama pris täm mes näkt ngi voda ama vodämes toqor varhäm ma Moses aa rhäkne ivakt iva ama ruvek ti lu i sa märäs pät a nge.” ");
INSERT INTO uro_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Bä nga ma Jisas ka mon sae ma Kaperneam dä akni ama narhoerqa bä ba ama handret na rha ama ulaqimärharhärhäkt ka män sagem ga bä qa nagukt pät a qa rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Gua morqa, gua latka di sa qat namas pät aa laiqa vä gua vätka i ama ngäñäp pät a qa bä qat nari ama ruanini masirhat.” ");
INSERT INTO uro_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Dä ma Jisas ka qoar na qa rhoqortäqyia, “Va ngua rhän bä ngua rhumäräs pät a qa.” ");
INSERT INTO uro_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sokt di qä ulaqimärharhärhäkt arhä narhoerqa qa muvät pät ma Jisas toqortäqyia, “Morqa, aingo di qaku ama märqa na ngo iva ngia rhon säp gua vätka. Dap sokt ngi qoar iva märäs pät gua latka dä va märäs pät a qa. ");
INSERT INTO uro_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Inguna qosaqi ngo di ama ruqa qärak i qale ngo va ama narhoerta arhä muräkt angärha rem dap ama ulaqimärharhärhäkt di qale rha vä gua rem. Bä nga ngu qoar nä rhaerhak toqortäqyia, ‘Ngia rhet’ dä qat tet. Dap nga ngu qoar nä rhaerhak toqortäqyia, ‘Ngi ang’ dä qat tet inamuk. Dap nga ngu qoar nä gua latka rhoqortäqyia, ‘Ngia rhualat toqor taerhäkt’ dä qat tualat toqoräkt.” ");
INSERT INTO uro_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Bä nga ma Jisas ka nari rhoqoräkt dä qräk mät ka mamär dä qa qoar nä iarhakt kärarhae i rhat tet nasot a qa rhoqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i qop as kaku ngua män bät anga qatnanakt ama mor ngät toqor täkt ge aung nävät ama Israelqäna. ");
INSERT INTO uro_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ngu qoar na ngän i ama ruvek masirhat diva rha rhän näsäng gunäga aa qamäs dä namone i ama qunäga qat don e bä va rhi rha arhä släqyimek pa ama tmäski ge ma Abraham gä nä ma Aisak dä ma Jekop pä iaqäkt na rhävuk aa Muräktpäm. ");
INSERT INTO uro_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Dap pa iarhakt kärarhae i qinak mai iva mänaris na rha vä ama Muräktpäm diva rhi rhon na rha sainamäk säp bängangit angät tpäs. Vät iosäkt ama ivärhäs diva rhat tuqaia dä va rhit nes arhä qeng angärha rem na ne.” ");
INSERT INTO uro_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Dä ma Jisas ka qoar nä qä ulaqimärharhärhäkt arhä narhoerqa rhoqortäqyia, “Ngia rhet bä sa va rhäkmamär toqoräkt bä ba nge rhoqor varhäm gi qatnanakt.” Dä qoki vät iomäkt ama qäväläm dä sa märäs pät aa latka. ");
INSERT INTO uro_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Bä nga ma Jisas ka met bä qa mon säp ma Pita aa vätka dä qa lu ma Pita aa rhäväski i sa qiat namas mäni lai i aräm gi dä aqärnas päm gi. ");
INSERT INTO uro_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Dä qa rhäk pät at tärhäqyet dä ama rämgi qia met nävät a qi. Näkt kia märanas bä qia nasäng i qit täkmu iva qi rhäk pät a qa na anga tmäs. ");
INSERT INTO uro_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Bä nga bängangäs dä ama ruvek ta met sagem ga sa ama rhäqäp na rha qärarhani i ama iaus ngärhit täk pät a rha dä qa qutmäs ama iaus nämät ta na ama enge dä qa mumäräs pät iarhakt moe qärarhae i aräm da. ");
INSERT INTO uro_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Rhangät täkt ama lat divakt iva rhäkmamär nä iangärhäkt ama enge qärangät i sa ama vämginaqa ma Aisaia qa märhamän bät a ngät toqortäqyia, “Qa mät aut släqyige angät märän maos maos nävät a ut dä qa rha aurha räm nävät a ut.” ");
INSERT INTO uro_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Bä nga ma Jisas ka lu ama mor qi ama guläñgi na ama ruvek namet a nas dä qa qoar na aa mudäsaqongda iva rha rhet samit särhage na ama namuqa. ");
INSERT INTO uro_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Dä ama Skraip ka män bä qa qoar na qa rhoqortäqyia, “Qamorqa, qoe nai i ngiat tet e di qoki va ngut päs gia rhäng.” ");
INSERT INTO uro_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Ama muräp di angärha lek dap ama isäm nämät ama leqäs di angärha vät dap sokt di ma Ruqa aa Emga di qaku aa anga ivärhäs ivakt iva qa rhas na aa uväski e.” ");
INSERT INTO uro_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Akni ama ruqa qärakni i qät päs ma Jisas aa rhäng di qa qoar na qa rhoqortäqyia, “Gua morqa, as ngi rhares pät gua rhäng iva as narhoer dä va ngua rhet ngu sasärhä gu mam.” ");
INSERT INTO uro_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Ngi väs gua rhäng dap ngi qyiradeng na ama ñäpta iva rhi sasärha arhä ñäpta maräkt.” ");
INSERT INTO uro_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Bä nga ma Jisas ka rhon na nas sämät ama mlauski dä aa mudäsaqongda rha met ti na qa. ");
INSERT INTO uro_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Dä mamär di nak sa ama lauräm ama qrot äm mamär ngä märanas pät ama namuqa aa rhäng dä soknga sa qorhäs iva ama mlauski qia rhon nage ama vaeng dap ma Jisas di qä mänatäm. ");
INSERT INTO uro_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Dä rha met bä rha rhäqäm a qa i rhi qoar toqortäqyia, “Engeska, ngia rhumaiar ut! Va u rhon bä va urhi ñäp!” ");
INSERT INTO uro_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Dä qa snanbät sä rha rhoqortäqyia, “Mäniekt bä ngänit len? Aingän di ama gaini nä angän gatnanakt!” Dä qa märanas dä qa märhamän ma ama qrot särha ama laur dä ama vaeng bät ama namuqa iva mae vät a ngät dä mae vät ama lauräm dap mänadin bät ama qoeväs mamär. ");
INSERT INTO uro_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Dä ama gamoe di sa rhäqäptäqäp ta mamär dap ti snanbät toqortäqyia, “Agi a ruqa rhak täkt kärak i qäqi ama laur dä ama vaeng ngät nari nämät ka?” ");
INSERT INTO uro_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Bä nga ma Jisas ka män särhage na ama namuqa bä sävät ama Gadaraqäna arha ivärhäs dä vuk sa ama iaus mät iom ama ruiom nämät ama ñäpta arha lek bä in män sagem ga. Näkt tiom däkt di ama qrot iom ama ruiom mamär bä äkt i sa qaku mamär vät aung iva qat tet nävä iaqyäkt ama iska. ");
INSERT INTO uro_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Dä nak sa in muqaia i in goar i, “Ai, ainge ma Ngämuqa aa emga, nak nani a nge iva ngia mäsana na un? Sa nga ngia män de ivakt iva ngiat turuan bät a un as pa ama rhäkmamär ngät ama rhodäm angät kamäs?” ");
INSERT INTO uro_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Dap ama vlam ama rhäqäp na ngät di qale ngät i ngärhit nges e gläius maqälak na rha. ");
INSERT INTO uro_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Dä ama iaus ngä nok pät ma Jisas i ngärhi qoar toqortäqyia, “Ngakt bä ngi kutmäs a ut dä mamär iva ngi rhäk na ut sämät ama vlam.” ");
INSERT INTO uro_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Dä qa qoar na ngät toqortäqyia, “Ngän det.” Bä äkt i sa vuk sä ngät bä ngä met sämät ama vlam. Dä nak ama vlam moe ngä ang masirhat pät ama qäsäpki bä ngä mon ba ama rigi bä ngä ñäp däm gi. ");
INSERT INTO uro_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bä ama ruvek kärarhani i mai rhit lu vät iangärhäkt ama vlam di sa rha ang masirhat bä sämät ama värhäm bä rha sameng nä iarhongäkt moekt bä qoki sävät ama lat kärangätni i sa ngä märanas pät ama iaus mät iom ama ruiom. ");
INSERT INTO uro_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Dä nak sa ama ruvek moe nämät iomäkt ama värhäm da män ivakt iva rhi lu ma Jisas. Bä nga rha lu qa dä rhat naing bät a qa iva qa rhet nävä iosäkt arha ivärhäs. ");
INSERT INTO uro_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Dä ma Jisas ka veng sämät ama mlauski bä saqi qa mängaläkt särhage säva aa värhäm maräkt ma Kaperneam. ");
INSERT INTO uro_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Dä nak sa arhani ama ruvek ta met sa ama ngäñäpärhaqa sagem ga i sa qat namas mät ama gasgaska. Bä nga ma Jisas ka lu arhä qatnanakt dä qa qoar nä qä ngäñäpärhaqa i, “Ngua emga, qale ngit len. Sa ngua qyiradeng nä gia vuirhong.” ");
INSERT INTO uro_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dä nak sa arhani ama Skraipkäna rha qoar na ne rhoqortäqyia, “Rhak täkt ama ruqa di qat tamän mava nä ma Ngämuqa.” ");
INSERT INTO uro_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Dap ma Jisas sa qat dräm arhä snängaqa bä äkt i qa snanbät toqortäqyia, “Mäniekt bä ngän du angän snäng na ama vu qa ama snängaqa? ");
INSERT INTO uro_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Inguna guaäm goe di märmärsäs mamär sä äm? Va ngu qoar toqortäqyia, ‘Sa ngua qyiradeng nä gia vuirhong’ ura va ngu qoar toqortäqyia, ‘Ngia rhair bä ngiat tet’? ");
INSERT INTO uro_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Bä nävät tom däkt diva mamär vät a ngän iva ngänät dräm i ma Ruqa aa Emga di ama rhares pät aa rhäng de vät ivät iva qät kyiradeng na ama vuirhong.” Dä qa qoar nä qä ngäñäpärhaqa rhoqortäqyia, “Ngia rhair näkt ngi rha gi gasgaska bä ngia rhet säva vät.” ");
INSERT INTO uro_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dä qa märanas bä qa met säva vät. ");
INSERT INTO uro_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bä nga ama gulañ na ama ruvek ta lu rhoqoräkt dä rhit len dä rha voda ama murhämeska sage ma Ngämuqa qärakni i sa qa von da ama qrot toqoräkt bä ba ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Bä nga ma Jisas ka met na äkt bä qat tet dä qa lu akni ama ruqa i qat muqun ba ama vätka qärakni i ama ruvek tit boda ama takes sae. Dä ma Jisas ka qoar na qa rhoqortäqyia, “Ngit päs gua rhäng.” Dä ma Matyu qa märanas bä qa met nasot a qa. ");
INSERT INTO uro_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Bä nga mamär i ma Jisas kat muqun gä nä ma Matyu bä in däs pä ma Matyu aa vätka dä nak sa ama rhäqäp na rha ama ruvek kärarhani i rhit ta ama takes bä sävät ama vu rha ama ruvek ta män bä rha muqun ge ma Jisas kä na aa mudäsaqongda bä rhat täs. ");
INSERT INTO uro_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bä nga ama Farisiqäna rha lu rhoqoräkt dä rha snanbät sä ma Jisas aa mudäsaqongda rhoqortäqyia, “Mäniekt bä angäna morqa di qat täs kä na ama ruvek kärarhani i rhit ta ama takes dä ama vu rha ama ruvek?” ");
INSERT INTO uro_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Bä nga ma Jisas ka nari rhoqoräkt dä qa qoar toqortäqyia, “Iarhakt kärarhae i ama märäs pät a rha di qaku rhit läk nani ama ruqa qärakni i qat dräm gat tumäräspät dap sokt kärarhani i ama rämgi vät a rha di rhit läk nani ama ruqa rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ngän det bä va qunäga vät a ngän sä rhangät täkt ma Ngämuqa aa enge angät tarimini qärangätni i ngät tamän doqortäqyia, ‘Sa nani a ngo iva ngänit lavuqi na arhani dap kaku nani a ngo na anga vodämes.’ Inguna qaku ngua män ivakt iva ngua rhes iarhakt kärarhae i ama räktta na rha sagem ngo dap kinak ngua män ivakt iva nani ama ruvek kärarhani i rhat tualat na ama vuirhong.” ");
INSERT INTO uro_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nasot dä ma Jon aa mudäsaqongda rha män ge ma Jisas bä rhi snanbät sä qa rhoqortäqyia, “Mäniekt bä ut ut na ama Farisiqäna di ut teranot dap ainge gi mudäsaqongda di qaku?” ");
INSERT INTO uro_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Nga mamär iva ama gamoeqa qärakni iva rhit bodäm na qa aa ruavek tit nok na ama iräski rhoqoräkt i qale qa qä na rha? Dap ama qäväläm as pa äm ngä rhän iva ama gamoeqa qärak iva rhit bodäm na qa diva rhi rha qa daqule rha bä vät iomäkt ama qäväläm diva rhat teranot. ");
INSERT INTO uro_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Dä qaku aung gä namu anga iar ini anga baulini mät anga liqi mäni anga mru qi anga boiqi inguna ngakt bä va qa rhualat toqoräkt dä va ama baulini ama iar ini ngärhi arot nämäni ama mru qi ama boiqi bä va ini ngärhi sämamor na ama liqi. ");
INSERT INTO uro_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Dä qosaqi qaku rhi narhor na anga iar qi anga wain sämät anga mru ngät anga ngädäng. Ngakt bä va rha rhualat toqoräkt dä va vukdur va ama ngädäng dä va räp sa ama wain bä va mava na ama ngädäng. Dap kinak tit tor na ama iar qi ama wain sämät ama iar ngät ama ngädäng dä soknga ama wain ngä na ama ngädäng moe diva sa mamär na ngät.” ");
INSERT INTO uro_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Bä nga ma Jisas kat tamän bät tärhong däkt sävät a rha dä nak sa ama tpäskinaqa qa män buk pa vät dä qa an da aa quum sä nas säng ma Jisas aa qar i qä qoar toqortäqyia, “Ngua imgi di sa qia ñäp täkt. Sokt di mamär iva ngi ang bä ngi rhäk pät a qi bä va qiat däqäm.” ");
INSERT INTO uro_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Dä ma Jisas ka märanas bä qa met nasot a qa qä na aa mudäsaqongda. ");
INSERT INTO uro_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Dä nak sa aktni ama evopki qäraktni i vät ama ngärhäqyisem da udiom na ama qoeo dä qaku mae vät at biaska na ama equngi dap as kinak kat tet di qia män säng ma Jisas aa rhäng bä qia rhäk da aa boiqi arha väm ");
INSERT INTO uro_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","inguna qiat tu arhä snäng doqortäqyia, “Ngakt bä qäqi ngu rhäk pät aa boiqi dä sa va märäs pät a ngo.” ");
INSERT INTO uro_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Dä ma Jisas ka rhong bät a nas dä qa lu qi bä qa qoar na qi rhoqortäqyia, “Ngua imgi, qale ngit len. Gi qatnanakt di sa ngä mumäräs pät a nge.” Dä sa märäs pät kärakt ka evopki masägos. ");
INSERT INTO uro_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Bä nga ma Jisas ka män säp ka tpäskinaqa aa vätka dä qa nari arhani ama ruvek arhä mabu dä qa lu ama ruvek i rhit nok na ama iräski. ");
INSERT INTO uro_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Dä qa qoar na rha rhoqortäqyia, “Ngän det nae inguna nak kop kaku ama rhuimgi qia ñäp dap ki mänatäm.” Dä rha rhama täm ga. ");
INSERT INTO uro_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Sokt di sa nga rha rhäk na ama guläñgi sä dalek dä qa met säva qa rhuimgi at käväläm bä qa sangar ama rhuimgi at tärhäqyet bä qia märanas. ");
INSERT INTO uro_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Dä vräs da ama sameng sävät tangät täkt ama lat särhage särhage vät ama ngärhäktka moe. ");
INSERT INTO uro_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Bä nga ma Jisas kat tet na äkt dä ama säsur iom ama ruiom in det nasot a qa i init nok masirhat toqortäqyia, “Ma Devit aa emga, mamär iva ngi lavuqi na un.” ");
INSERT INTO uro_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Bä nga qa mon säva vät dä ama säsuriom in män gem ga dä ma Jisas ka snanbät sä iom doqortäqyia, “Ngä inät nanakt i sa mamär vät a ngo iva ngua rhumäräs pät a en?” Dä in muvät pät a qa i, “Iei Engeska.” ");
INSERT INTO uro_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dä qa rhäk pät in saqong i qä qoar toqortäqyia, “Mamär iva sa rhäkmamär nä iangärhäkt ama lat parhäm in gatnanakt.” ");
INSERT INTO uro_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Dä mamär na in saqong. Dä ma Jisas ka mugem iom ma ama qrot toqortäqyia, “Mamär iva qale aung gä naräm sävät tangät täkt ama lat.” ");
INSERT INTO uro_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Dap kinak in met na äkt bä ini sameng sävät a qa vät ama ngärhäktka moe. ");
INSERT INTO uro_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bä nga ma Jisas kä na aa mudäsaqongda rhat tet na äkt dä nak sa arhani ama ruvek ta män sagem ga sa ama ruqa qärakni i ama iauska qät täk pät a qa dä qaku qat tamän. ");
INSERT INTO uro_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bä nga nasot i ma Jisas ka qutmäs iaqäkt ama iauska nämät ka ruqa qärak i qaku qat tamän dä qärak ka märhamän. Dä ama gulañ na ama ruvek di qräk mät ta i rhi qoar toqortäqyia, “Mänasäng inamäk bä sarhäkt di sa qaku aung ga lu ama lat toqor täkt e ma Israel.” ");
INSERT INTO uro_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Sokt di ama Farisiqäna rhi qoar i, “Qät kutmäs ama iaus nävät ama iaus angät narhoerqa aa qrot.” ");
INSERT INTO uro_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Dä ma Jisas ka met mät ama värhap ama mor ap dä ama värhap ama gaini na ap moe i qä su va ama mämairväm dä qä sameng na ama sameng ama mär ngät sävät ama Muräktpäm dä qat tumäräs pät ama ruvek nämät arhä räm moe maos maos dä nämät arhä släqyige angät märän moe. ");
INSERT INTO uro_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Bä nga qa lu ama gulañ na ama ruvek dä qa lavuqi na rha inguna sa ama inirqi na arhä snängaqa dä qaku mamär vät a rha iva rhat tatnärhäm ne i rha rhoqor ama sipsipkäna qärangätni i qaku angärha anga ruqa iva qät lu vät a ngät. ");
INSERT INTO uro_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Dä qa qoar na aa mudäsaqongda rhoqortäqyia, “Ama tmäs kärangätni iva rhi dodäktgyäm ngät di masirhat na ngät dap ama latta di ama marheka na rha. ");
INSERT INTO uro_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Dä soknga mamär iva ngäni nän ma ama qrot sage ma Engeska bä bä iangärhäkt ama lat toqoräkt iva qä rhäk na anga latta sävät iangärhäkt aa lat.” ");
INSERT INTO uro_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Mamär dä ma Jisas ka mes aa ngärhäqyisem da udiom na rha ama mudäsaqongda sagem mes bä qa von da rha ama qrot ivakt iva rhat turäkt ta ama iaus dä va rhit kutmäs a ngät bä va rhat tumäräs pät ama ruvek nämät ama räm maos maos moe dä nämät arhä släqyige angät märän moe. ");
INSERT INTO uro_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ama ngärhäqyisem da udiom na rha ama ngangda di arhä ngärhep tangät tärhäkt. Narhoer di ma Saimon gärak i rhat tes ka i ma Pita qä nä aa läktka ma Andru dä ma Jems ma Sebedi aa emga qä na aa läktka ma Jon ");
INSERT INTO uro_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","dä ma Filip dä ma Bartolomyu dä ma Tomas dä ma Matyu qärak i ama ruqa qärak i qat dräm gät ta ama takes dä ma Jems ma Alfius aa emga dä ma Tadius ");
INSERT INTO uro_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","dä ma Saimon gärak i qa nämäni ama Selotkäna näkt sävät ma Judas Iskariot kärak i qa vodä ma Jisas sämät aa ikkäna arhä rhäkt. ");
INSERT INTO uro_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Rhärhae rhäkt ama ngärhäqyisem da udiom na rha di ma Jisas ka rhäk na rha sa ama rhodräp toqortäqyia, “Qale ngän namet sä mänguräp ama Jentailqäna. Dä qale ngän namon sämät guaäm nävät ama Samariaqäna arha värhap. ");
INSERT INTO uro_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Dap kinak pa ngän det sage ama Israelqäna qärarhani i rha rhoqor ama sipsipkäna qärangätni i sa musäng sä ngät. ");
INSERT INTO uro_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Bä va nga rhoqoräkt i ngän det dä ngäni sameng i, ‘Iaqäkt na rhävuk aa Muräktpäm di sa nga e glaqot.’ ");
INSERT INTO uro_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Va ngän dumäräs pät ama rämgivärharha dap pa ngän däranas na ama ñäpta dä va ngän dumäräs pät ama biaspärharha näkt pa ngänit kutmäs ama iaus. Sa qaku ngän bodäm bät ma Ngämuqa aa matnärhäm bä ba ngän bä äkt i mamär iva qale arhani rhi natbodäm bät angän matnärhäm bä ba rha. ");
INSERT INTO uro_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Qale ngi nata anga gol ura anga silva ura anga ligärigleng mät gi rhae. ");
INSERT INTO uro_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Dap kale ngi nata anga sägänaqa vät gia tmerhäs ura anga sravem anga unbem ura anga sandal anga unmem na ngät sae ura anga tlaga. “Mamär iva ama latka qä rha iarhongäkt kärqärhong i qät läk nani irhong nage ama ruvek kärarhani i sa qa matnärhäm da. ");
INSERT INTO uro_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Bä äkt i nga rhoqoräkt iva ngia rhon sämät agi a värhäm anga mor äm ura agi a värhäm anga gaini na äm diva ngi ñäm nani anga ruqa e mät äm gärakni i ama räkt ka dä ma Ngämuqa aa saqong bä va qale nge gem ga bä dängdäng iva ngia rhet daqule iomäkt ama värhäm. ");
INSERT INTO uro_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Qre va ngiat don säva iaqäkt ama ruqa aa vätka dä mamär iva ngia rhes ama märmärgem sage ama ruvek kärarhani i qale rha e väm ga. ");
INSERT INTO uro_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Dap ngakt bä iarhakt ama ruvek di sa rha ar sä nge sagem mes dä mamär iva ngi nän iva qale ama bulap nage ma Ngämuqa gem da. Dap ngakt bä qaku rha ar sä nge dä va ngi rhäqäs tä gia enge na ama modämne. ");
INSERT INTO uro_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Dap ngakt bä qaku ama ruvek ti nar sä nge ura qaku rhi nanari gia enge dä va ngia rhet daqule iaqäkt ama vätka ura iomäkt ama värhäm dä va ngi suqup gia qäriglem sa ama rhabuqi samäk dä saqi ngi rhäqäs tä gia enge na ama modämne. ");
INSERT INTO uro_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ngu qoar na ngän na ama engäktki i vät ama qunäga qärakni iva ma Ngämuqa qa rhatnävämne na ama ruvek pät ama ivätki diva qä lavuqi na ama Sodomgäna dä ama Gomoraqäna masirhat pit pa ama ruvek nae nävä iomäkt ama värhäm angät tpäs. ");
INSERT INTO uro_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“As ngäni lu i ngut täk na ngän iva ngän doqor ama sipsipkäna qärangätni i ngät tet sä mänguräp ama mäsmäs päm ngät ama muräp ama mor ngät. Mamär iva ama räpmät na ngän mamär dap kosaqi mamär iva qaku mamär vät aung iva qä narhäksärhäm ngän bät agung angäna lat angät tpäs. ");
INSERT INTO uro_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ngänit lu mamär nämät ama ruvek inguna rha diva rha rhet sä ngän säda ama muräkt angät saqong bä va rha rhäranäs ngän ba arhä mämairväm. ");
INSERT INTO uro_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Näkt pa rhi artäm na ngän säda ama tpäskinarha rhi na ama vitnarha arhä saqong inguna nävät iomäkt i ngänät nanakt na ngo. Va rha rhualat toqoräkt ivakt iva ngäni sameng sävät a ngo ba rha rhi na ama Jentailqäna. ");
INSERT INTO uro_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Qre va rhat tair na ngän ba anga muräkt dä va qale qänäskänes ngän iva ngän damän doqor mäniekt ura sävät agi anga engirhong gärqärhongni iva ngän damän bät irhong inguna va ama Qloqaqa ama Qumärqumärqa qä von ngän dä iarhongäkt ama engirhong bät iomäkt ama qäväläm. ");
INSERT INTO uro_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Inguna va qaku ngän maräkt ngän natmärhamän dap kinak pa angän mamäk aa Qloqaqa qat tamän mät ngän. ");
INSERT INTO uro_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Va ama gamoe diva rhi voda arha matpek dä arha läktpek ba ama ruvek ivakt iva rhi veng da. Dap arhani ama ngätmamäkkäna diva rhi von da arhä rhoes ba ama ruvek bä va rhi veng da dä qosaqi arhani ama rhoes diva uraqi da arha ron na arhä mamäkkäna bä va rhi vodäm da ba ama ruvek bä va rhi veng da. ");
INSERT INTO uro_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ama ruvek moe diva ama vu da arha ron na ngän mamär inguna nävät iomäkt i ngänät nanakt na ngo. Sokt di iaqäkt kärak i qat mair ma ama qrot bä däng bät ama tpäsini diva qä rha ama mumaiar. ");
INSERT INTO uro_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Qre va rhi sangäm na ngän mavängam mät aomni ama värhäm dä va ngäni ang nae sämät aomni. Inguna sa ngu qoar na ngän na ama engäktki iva ma Ruqa aa Emga va qa rhän dap as kaku ngän namet mät ama värhap moe e ma Israel. ");
INSERT INTO uro_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Anga mudäsaqongga di qaku qa vit pa aa morqa aa uväs dap kosaqi anga latka di qaku qa vit pa aa morqa aa uväs. ");
INSERT INTO uro_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sa mamär iva ama mudäsaqongga di qa rhoqor aa morqa dä va ama latka di qa rhoqor aa morqa. Ngakt bä rhat tes ama sägärhae arha morqa i ma Belsebul dä nak pa rhi slava nä iarhakt kärarhae i rha nävät iaqäkt ama morqa aa qärhae na ama enge ama vu ngät masirhat. ");
INSERT INTO uro_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Dä soknga qale ngänit len da inguna qaku guani qärqäni i sa väsdät särhäm ini diva qaku rhi namuqunäga sä ini dä qaku guani qärqäni i ama ngaip ini diva qaku rhi naräm nä ini. ");
INSERT INTO uro_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Agirhong gärqärhongni i sa ngua qoar na ngän nä irhong bä bängangit angät tpäs diva ngän damän bät irhong da eraqi dä agirhong gärqärhongni i sa ngua rhäkdasäkt nä irhong ba ngän diva ngäni näs nä irhong dävuk nävät ama vät angärha rhäng. ");
INSERT INTO uro_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Dap kale ngänit len iarhakt kärarhae i rhi veng ama ruvek arhä släqyigleng dap kaku mamär vät a rha iva rhi veng ama ruvek arhä mungäsnäng. Dap kinak pa ngänit len iaqäkt kärak i mamär vät a qa iva qä slava na ama mungäsnäng ngä na ama släqyige moe mät ama mudäbäs ama sok tä bäs. ");
INSERT INTO uro_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nga qaku rhi navodäm bät ama udom ama isämirhom na ama brasini? Sokt di qaku ani nävät irhom diva arpus nä ini sävät ivät sañis nä ini nämät angän mamäk aa snängaqa. ");
INSERT INTO uro_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Bä qäqi ama qäseng bät angän bäs di sa qat dräm ama rhodäm sä ngät. ");
INSERT INTO uro_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Dä soknga va qale ngänit len. Aingän di ngän bit ge ma Ngämuqa va ama rhäqäp nä irhong ama isämirhong angät tpäs. ");
INSERT INTO uro_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Bä äkt i iaqäkt kärak i qat tamän i qa nämäni ngo da ama ruvek arhä saqong diva qosaqi aingo ngua rhamän i qa nämäni ngo dä gu mam aa saqong gärak i rhak pono da ama usäpki arha ron. ");
INSERT INTO uro_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Dap iaqäkt kärak i qät täqyas na ngo da ama ruvek arhä saqong diva qosaqi aingo ngu rhäqyas na qa dä gu mam aa saqong gärak i rhak pono da ama usäpki arha ron. ");
INSERT INTO uro_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Qale ngän namu angän snäng i sa ngua män ivakt iva ngu voda ama bulap sävät ama ivätki. Qaku ngua män sa ama bulap dap kinak ngua män sa ama ulaqi arha singi. ");
INSERT INTO uro_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Inguna sa ngua män ivakt iva ama ruqa qa rhair sävät aa mamäk dä va ama ngärhuimgi sävät at nanäk dä va ama ngätkluqi sävät at täväski. ");
INSERT INTO uro_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Dä ama ruqa aa ikkäna diva aa qärhae maräkt. ");
INSERT INTO uro_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Aung gärakni i aa snäng bät aa mamäk ura aa nanäk masirhat pit pät ngua väs di qaku ama mär qa na qa iva gu mudäsaqongga na qa. Dap aung gärakni i aa snäng bät aa emga ura aa imgi masirhat pit pät ngua väs di qaku ama mär qa na qa iva gu mudäsaqongga na qa. ");
INSERT INTO uro_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Bä aung gärakni i qaku qät ta aa sämänanamuqa bä qät päs gua rhäng di qaku ama mär qa na qa iva gu mudäsaqongga na qa. ");
INSERT INTO uro_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aung gärakni i qä siqut iva qä sangar aa iar diva qa rhusäng sä ngät nasot dap iaqäkt kärak i qa rhusäng sa aa iar bä ba ngo diva qä rha ngät nasot. ");
INSERT INTO uro_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Auge qärak i qä rhar sä ngän di qosaqi qä rhar sä ngo dap auge qärak i qä rhar sä ngo di qosaqi qä rhar sä iaqäkt kärak i sa qa rhäk na ngo. ");
INSERT INTO uro_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aung gärakni i qä rhar sa ama vämginaqa sagem mes inguna akni ma Ngämuqa aa vämginaqa na qa diva qä rha ama vämginaqa aa rhitsek. Dä aung gärakni i qä rhar sa ama räkt ka ama ruqa inguna akni ama räkt ka ama ruqa na qa diva qä rha ama räkt ka ama ruqa aa rhitsek. ");
INSERT INTO uro_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Dap aung gärakni i qäqi qät bon akni nävät tärhae rhäkt ama rhoes ta anga kap na anga rigi anga umälet na qi inguna sa qät päs gua rhäng di qoki va qä rha aa rhitsek.” ");
INSERT INTO uro_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sa nga ma Jisas ka von dä iangärhäkt ama rhodräp bä ba aa ngärhäqyisem da udiom aa mudäsaqongda bä rhäksot dä qa met na äkt ivakt iva qä su dä qä sameng mät ama värhap pät iosäkt ama ivärhäs. ");
INSERT INTO uro_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Bä nga ma Jon ama Baptais kärak i sa qale qa va ama tpäskiarharhäng ga nari sävät ma Krais aa lat dä qa rhäk na arhani aa mudäsaqongda sagem ga ");
INSERT INTO uro_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","bä rha snanbät sä qa rhoqortäqyia, “Nga qärak na nge iva qa rhän ura va qoki as ut nañäm nani akni?” ");
INSERT INTO uro_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Ngän det bä ngäni qoar nä ma Jon nä iarhongäkt kärqärhong i ngänät nari irhong dä ngänät lu irhong ");
INSERT INTO uro_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","i ama säsurta di sa rhat nañäm dap ama vävarhämda di sa rhat tet dap iarhakt kärarhae i ama bias pät a rha di sa märäs pät a rha dap ama dängbärharha di sa rhat nari dap ama ñäpta di sa rhat täranas bä ama iar ta. Dä ama sameng ama mär ngät di ngu sameng na ngät bä ba ama tläkta. ");
INSERT INTO uro_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Näkt ma Ngämuqa aa modämne di sa nga e ge iarhakt kärarhae i sa qaku rhit kut säda arha ron nävät a ngo dap kinak tat nanakt na ngo.” ");
INSERT INTO uro_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bä nga ma Jon aa mudäsaqongda rhat tet na äkt dä ma Jisas ka nasäng i qat tamän särha ama gulañ na ama ruvek sävät ma Jon doqortäqyia, “Sa ngän met sävät ama ivärhäs ama qräk dä bäs ivakt iva ngäni lu agiqa? Nguaräm ngän met sae ivakt iva ngäni lu ama eqokt ka ama ruqa qärakni i qät lir qät kutsasorhane varhäm ama ruvek arhä snängaqa? ");
INSERT INTO uro_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ngakt bä qaku rhoqoräkt dä ngu lu sa ngän met ivakt iva ngäni lu agi anga ruqa? Nak nga va ngäni lu ama ruqa qärakni i qat don mät ama boi ama mär ngät? As ngäni lu i iarhakt kärarhae i rhat don mät ama mär ngät ama boi di sa qale rha va ama vitnarha arha vät. ");
INSERT INTO uro_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ngakt bä qaku rhoqoräkt dä ngu lu sa ngän met ivakt iva ngäni lu agi anga ruqa? Nguaräm ba ngäni lu akni ma Ngämuqa aa vämginaqa? Ari, sokt di ngu qoar na ngän i iaqäkt di qa vit pät arhani ama vämginarha arhä väs. ");
INSERT INTO uro_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Rhak täkt ama ruqa di iaqäkt kärak i sa rha säm sävät a qa vä ma Ngämuqa aa enge rhoqortäqyia, “‘As ngäni lu i ngut täk nä gua engevärhaqa vä gi qamäs ivakt iva qä rhäkmu nä gia iska nanokt nge.’ ");
INSERT INTO uro_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ngu qoar na ngän na ama engäktki i nä mänguräp ama ruvek kärarhani i sa arhä nanäkkina rha säl a rha di sa qaku aung ga män gärakni i qa vit pä ma Jon ama Baptais aa uväs. Dap iaqäkt kärak i ama gaini na qa mamär va ama Muräktpäm na rhävuk di ama moräs na qa masirhat daver ma Jon. ");
INSERT INTO uro_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Nävät ama qäväläm gärqomni i ma Jon ama Baptais ka nasäng i qä sameng inamäk bä sarhäkt di sa ama Muräktpäm na rhävuk ngärhit ta ama märänga ama mor qa bä ama inirqi mät ta ama ruvek di sa rhi siqut iva rhi sangar a ngät na ama qrot ");
INSERT INTO uro_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","inguna ama vämginarha dä ama muräkt moe di ngät tamän mudu inamäk bä dängdäng i ma Jon ga nasäng i qä sameng iva ama lat toqoräkt ngä rhän. ");
INSERT INTO uro_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Bä nga rhoqoräkt i ma Ngämuqa aa enge ngät tamän sävät ma Elaija iva evär däm ga di ngät tamän sävät ma Jon. Rhoqoräkt di qrekt bä mamär vät a ngän iva ngänät nanakt toqoräkt. ");
INSERT INTO uro_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Iaqäkt kärak i nani a qa iva qunäga vät a qa sä gua enge di mamär iva qat nari mamär. ");
INSERT INTO uro_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ngu lu va ngua rhuqut ta agiqa sävät ama ruvek nävät tit täkt ama qoengait? Rha di rha rhoqor ama rhoes kärarhani i rhat muqun ba ama ivärhäs kärqosni i rhit boda ama tmäs e bä arhani rhit näs sävät arha ruavek toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Urhit kut ama irin dap ngän di qaku ngän dain dä urhit tong ama mabu na ama iräski dap ngän di qaku ngänit nok.’ ");
INSERT INTO uro_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Inguna ma Jon ga män i qaku qat täs ama bret dä qaku qät näkt ama wain dap ti qoar i, ‘Qa di ama iauska qa e mät ka.’ ");
INSERT INTO uro_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Dap ma Ruqa aa Emga qa män i qat täs dä qät nakt dap ti qoar i, ‘Ngäni lu qa! Ama qatmäska dä ama tnaktka na qa bä aa ruavek di iarhakt kärarhae i rhit ta ama takes bä sävät ama vurha!’ Sokt di ama ruvek arha lat kärangätni i rhat tualat na ngät nävät ama mädräm ama mär ngät nage ma Ngämuqa di ngät ngärhi qoar i aa mädräm ama mär ngät di ama räkt ka.” ");
INSERT INTO uro_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Bä nasot dä ma Jisas ka nasäng i qät täksärha ama ruvek nävä iaväkt ama värhap kärqapni i sa qa mualat na ama lat ama qrot ngät masirhat e inguna sa qaku rha näpgoer na nas. ");
INSERT INTO uro_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Aingän ama Korasingäna diva avuqi na ngän mamär! Bä aingän ama Betsaidaqäna diva qosaqi avuqi na ngän mamär! Inguna vadi mai iangärhäkt ama nañis ngät ama lat i sa ngua mualat na ngät gem ngän di nga vadi mai ngä märanas e mänguräp ama ruvek nae ma Tair bä nae ma Saidon di sa vadi mudu iarhakt ama ruvek ta näpgoer na nas nämät arha vuirhong i rhi is nas na ama iläñ ngät ama boi na ama iräski nävät arha vuirhong näkt ti suqup ama ligätki vät a nas. ");
INSERT INTO uro_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Sokt di ngu qoar na ngän i vät ama qunäga qärakni iva ma Ngämuqa qa rhatnävämne na ama ruvek pät ama ivätki diva qä lavuqi na ama ruvek nae ma Tair dä nae ma Saidon masirhat pit pa angän bäs. ");
INSERT INTO uro_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Dä ainge ma Kaperneam, nga va ma Ngämuqa qä sek sä nge sa rhävuk säda ama usäpki arha ron? Nak pa qaku rhoqoräkt. Dap kinak nge diva ma Ngämuqa qä rhon na nge rhämane sävät ama ñäpta arhä ivärhäs. Inguna vadi mai ama qrot ngät ama lat kärangätni i sa ngua mualat na ngät e väm nge di nga vadi mai ngua mualat na ngät e väm ma Sodom di mamär iva as kale läm bä dängdäng däkt. ");
INSERT INTO uro_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Sokt di ngu qoar na ngän i vät ama qunäga qärakni iva ma Ngämuqa qa rhatnävämne na ama ruvek pät ama ivätki diva qä lavuqi nä ma Sodom masirhat pit pä ngia väs.” ");
INSERT INTO uro_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Bä vät iomäkt ama qäväläm dä ma Jisas ka qoar i, “Ngu nän sä nge mam, ainge qärak i ma Engeska na nge bä ba ama usäpki dä bä ba ama ivätki inguna sa ngia ngaip tärhong däkt nämät ama ruvek sa ama mädräm ama mär ngät dä ama mädrämda dap kinak sa ngia muqunäga sä irhong bä ba ama rhoes ama gaini na rha. ");
INSERT INTO uro_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ari mam, i qoki nguna rhoqoräkt di varhäm gi snängaqa na ama ñämsävätki. ");
INSERT INTO uro_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Sa gu mam ga von ngo rha ama qrot daver iarhongäkt moe. Bä qaku aung gat dräm i ama Ngärhoemga di auge dap sokt ama Ngätmamäk. Dä qaku aung gat dräm i ama Ngätmamäk di auge dap sokt ama Ngärhoemga bä qosaqi iarhakt kärarhae i sa ama Ngärhoemga qa muqunäga sä qa ba rha. ");
INSERT INTO uro_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Aingän moe qärarhae i ngän dualat masirhat dä ngänit ta bä amärän, mamär iva ngäni ang sagem ngo dä va ngu von ngän da ama mämaevät. ");
INSERT INTO uro_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mamär iva qale ngän bä gua rem bä ngäni su nagem ngo inguna aingo di ama bulapka na ngo dä ama sämagaininanas nga e gem ngo bä va ngän dän bät ama mämaevät bä ba angäna iar. ");
INSERT INTO uro_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Inguna ama lat kärangätni iva ngu von ngän däm ngät iva ngän dualat na ngät diva qaku ama qrot ngät. Dä ama märän gärangätni iva ngu von ngän iva ngänit ta ngät diva qaku amärän bäm ngät.” ");
INSERT INTO uro_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Vät iomäkt ama qäväläm di vät akni ama Sabat dä ma Jisas kat tet da ama et na ama wit. Dä aa mudäsaqongda di anoeng mä rha dä rha nasäng i rhi nänbäñ sa ama gavämirhong bä rhat täs irhong. ");
INSERT INTO uro_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Bä nga rhoqoräkt i ama Farisiqäna rha lu rhoqoräkt dä rha qoar na qa rhoqortäqyia, “Ura, gi mudäsaqongda di rhi nänbetäkmät na ama Muräkt pät ama Sabat.” ");
INSERT INTO uro_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Dä ma Jisas ka snanbät sä rha rhoqortäqyia, “Nga sa qaku ngän mes sävät ama lat kärangätni i ma Devit ka mualat na ngät kä na aa ruavek toqoräkt i anoeng mä rha? ");
INSERT INTO uro_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ma Ngämuqa aa enge di ngät tamän i qa mon sävä ama ansäspämgi ama me qi bä qa mäs ama bretkäna qärangätni i rhit bodäm ngät sage ma Ngämuqa qärangätni i ama Muräkt ngät tamän i qaku mamär iva qa qä nä qärarhani i rhi na qa rha äs ngät dap sokt ama priskäna di mamär iva rhat täs ngät. ");
INSERT INTO uro_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ura nga sa qaku ngän mes pa ama Muräkt i vät ama Sabatkäna dä ama priskäna va ama ansäspämgi ama mor qi rhat tualat mava na ama Sabat i nga rhat tualat na arha lat dä qaku rhit ta ama rhäksärhäm bät angät tpäs? ");
INSERT INTO uro_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Sa ngu qoar na ngän i ani qärqäni i ini ngä vit pa ama ansäspämgi ama mor qi at täväs di qali lini rhe. ");
INSERT INTO uro_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bä nga vadi mai sa ngänät dräm dangät täkt ama enge angät tarimini qärangätni i ngät tamän doqortäqyia, ‘Sa nani a ngo iva ngänit lavuqi na arhani dap kaku nani a ngo na anga vodämes’ di vadi mai qaku ngän narhäksärhä iarhakt kärarhae i sa qaku rhi namualat na anga vu ngät anga lat. ");
INSERT INTO uro_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Inguna ma Ruqa aa Emga di ma Engeska bä ba ama Sabat.” ");
INSERT INTO uro_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Dä ma Jisas ka met na äkt bä qa mon säva arhä mämairqi. ");
INSERT INTO uro_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Dap akni ama ruqa qa e qärakni i ama ñäp aa rhäqyet. Dä arhani rha snanbät sä ma Jisas toqortäqyia, “Nga maräkt da ama Muräkt angät saqong iva ut tumäräs pät akni vät ama Sabat?” Rhi snanbät toqoräkt dinguna rhit ñäm nani guani iva rhi rhäksärhäm ga vät ini angät tpäs. ");
INSERT INTO uro_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Dä qa snanbät sä rha rhoqortäqyia, “Auge nävät a ngän gärakni i aa anga sipsip kärakni i sa qa säp sämät ama uqupka vät ama Sabat diva qaku qä nasangar a qa bä va qä sek mä qa nämät ka? ");
INSERT INTO uro_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Di nak ama ruqa di qa vit masirhat pa ama sipsip aa uväs! Bä äkt i sa maräkt da ama Muräkt angät saqong iva ut tualat mamär sa akni vät ama Sabat.” ");
INSERT INTO uro_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Dä ma Jisas ka qoar nä qa ruqa i, “Ngia rhurän dä ngia rhäqyet.” Dä qa ruqa qa murän dä bet bä sa märäs pät a et i ama mär et toqor aetni. ");
INSERT INTO uro_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Dä ama Farisiqäna rha met bä rhat tamän särhäm ne sä qa iva rhi veng ga rhoqor mäniekt. ");
INSERT INTO uro_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ma Jisas di sa qunäga vät a qa sä iangärhäkt ama lat bä äkt i qa met nävät iosäkt ama ivärhäs. Dä ama rhäqäp na rha ama ruvek tat tet nasot a qa bä qa mumäräs pät arha rämgivärharha moe. ");
INSERT INTO uro_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Näkt ka von da rha ama enge na ama mugem iva qale rhi namuqunäga sä qa ba ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Qa mualat toqoräkt divakt iva rhäkmamär varhäm ama vämginaqa ma Aisaia aa enge qärangätni i sa qa märhamän bät a ngät toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“As ngäni lu gua latka qärakni i sa ngua armeng däm ga qärak i sa gua snäng bät a qa masirhat bä märmär gem ngo masirhat nävät a qa. Va ngua rhu gu Qloqaqa vät a qa bä va qä sameng na ama räkt ngät ama matnävämne bä ba ama Jentailqäna. ");
INSERT INTO uro_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Qa diva qaku qä na arhani rhi narhäktgyäm sä ne bä va qaku qä natnäs tävuk bä qosaqi va qaku aung gä natnari aa eguinga mäni ama is. ");
INSERT INTO uro_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Va qaku qä narhagär da anga egärhaet kärqetni ivakt pä bet dä va qaku qä naveng anga lirhäga qärakni i sa qorhäs iva qä ñäp. ");
INSERT INTO uro_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Näkt pa ama Jentailqäna rhat nanakt na qa sä nas.” ");
INSERT INTO uro_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mamär dä arhani ama ruvek ta män sage ma Jisas sä akni ama ruqa qärakni i ama iauska qät täk pät a qa bä äkt i ama säsurqa na qa dä qaku qat tamän. Dä ma Jisas ka mumäräs pät a qa bä äkt i nasot dä qa ruqa qat tamän dä qat nañäm. ");
INSERT INTO uro_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Dä ama ruvek moe di qräk mät ta dä rhi snanbät i, “Nak nguaräm ma Devit aa emga rhak täkt iaqäkt kärak i ma Krais?” ");
INSERT INTO uro_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Sokt di nga ama Farisiqäna rha nari rhoqoräkt dä rha qoar toqortäqyia, “Rhak täkt ama ruqa di qät kutmäs ama iaus di sokt nävät ama iaus angät narhoerqa ma Belsebul aa qrot.” ");
INSERT INTO uro_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ma Jisas kat dräm arhä snängaqa dä qa qoar na rha rhoqortäqyia, “Anga muräktpäm moe qärangätni i sa matmät na ngät diva qäbäs na ngät bä ngakt bä anga ruvek e mät anga värhäm ura va anga vätka rhi arhäktgyäm sä ne dä va qaku qale iomäkt ama värhäm ura iaqäkt ama vätka mauiu. ");
INSERT INTO uro_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Bä ngakt bä ma Sämga qät kutmäs ma Sämga dä qa di qat tatmät na nas toqoräkt. Bä nga rhoqoräkt dä ngu lu va aa muräktpäm ngät mair ma ama qrot toqor mäniekt? ");
INSERT INTO uro_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Näkt ngakt bä ngut kutmäs ama iaus di na ama qrot nage ma Belsebul varhäm angäna enge dä ngu lu iarhakt kärarhae i rhat tet nasot a ngän di auge qät boda rha ama qrot bä rhit kutmäs ama iaus? Iarhakt di arha lat ngärhi sameng i angäna enge di qaku maräkt na ngät. ");
INSERT INTO uro_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Sokt di ngakt bä ngut kutmäs ama iaus nävät ma Ngämuqa aa Qloqaqa dä iangärhäkt gua lat di ngärhi sameng i ma Ngämuqa aa Muräktpäm di sa ngä män sagem ngän. ");
INSERT INTO uro_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Qaku mamär vät aung anga ruqa iva qä namon säva anga qrot ka anga ruqa aa vätka mavängam bä qä rha aa qärhong dap as kaku qa er qa qop pät a qa. Ngakt bä qä qop pät a qa dä mamär iva qa rhon bä qä rha aa qärhong. Dä nak as ngäktki va mamär vät a qa iva qä rha aa qärhong moe. ");
INSERT INTO uro_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Auge qärak i qaku qat tair gem ngo di qat tair sävät a ngo. Dap auge qärak i qaku qat tatnärhäm i qä ngingdämne na ama ruvek kä na ngo di qa di qat tusur täm da. ");
INSERT INTO uro_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Dä soknga ngu qoar na ngän i ama vuirhong dä ama märhamän mava moe diva ma Ngämuqa qät kyiradeng na ama ruvek sä irhong. Sokt di aung gärakni i qat tamän mava nä ama Qloqaqa ama Qumärqumärqa diva qaku ma Ngämuqa qä naqyiradeng nä ianiäkt aa vuini. ");
INSERT INTO uro_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bä aung gärakni i qat tamän mava nä ma Ruqa aa Emga diva ma Ngämuqa qä qyiradeng nä ianiäkt aa vuini. Dap aung gärakni i qat tamän mava na ama Qloqaqa ama Qumärqumärqa diva qaku ma Ngämuqa qä naqyiradeng nä ianiäkt aa vuini näma dä vät tom däkt ama qäväläm ura as mirhup. ");
INSERT INTO uro_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Anga mär qa anga ngämuga di sokt kät sa ama mär ngät ama gavam dap anga vu qa anga ngämuga di sokt kät sa ama vu ngät ama gavam. Va ngäni lu ñismäne na ama ngämung di nävät angät gavam. ");
INSERT INTO uro_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Aingän gärarhae i ama guläñgi na ama uiuvärhirhong gärqärhongni i irhong ngärhit kut na ama qänogi, rhoqor mäniekt bä mamär vät a ngän iva ngän damän bät anga mär ngät anga enge qre i sa ama vu rha ama ruvek na ngän? Inguna sävetka aa vämgi di sa qiat tamän nävät agini qärqäni i rhäqäp aa snängaqa nä ini. ");
INSERT INTO uro_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ama mär qa ama ruqa nävät iarhongäkt ama märirhong da aa ron di sa qat tualat na ama mär ngät ama lat dap ama vu qa ama ruqa nävät iarhongäkt ama vuirhong da aa ron di sa qat tualat na ama vu ngät ama lat. ");
INSERT INTO uro_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ngu qoar na ngän i vät ama qunäga qärakni iva ma Ngämuqa qa rhatnävämne na ama ruvek pät ama ivätki diva rhit täväkt sa ama enge moe qärangätni i sa rha märhamän bät a ngät nak kop mavängam ");
INSERT INTO uro_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","inguna nävät angäna enge diva isiska vät a ngän nämät ama rhäksärhäm dap kosaqi nävät angäna enge diva ngäni rha ama rhäksärhäm.” ");
INSERT INTO uro_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Dä arhani ama Skraipkäna dä ama Farisiqäna rha muvät pät a qa i rhi qoar na qa rhoqortäqyia, “Qamorqa, sa nani a ut iva urhi lu anga muqunängi nävät a nge.” ");
INSERT INTO uro_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Sokt di ma Jisas ka muvät pät a rha i, “Aingän nävät tit täkt ama qoengait di ama vu rha ama ruvek na ngän gärarhani i sa qaku qale rha mamär i sägäni na rha rhi nä ma Ngämuqa rhoqor ama ruiom gärqiomni i sa in mätlägut näkt mamär dä akni qa qavatnävätlägut. Bä ngänit ñäm nani anga muqunängi sokt diva qaku anga muqunängi qi namän bä ba ngän dap sokt ama muqunängi nävät ama vämginaqa ma Jona. ");
INSERT INTO uro_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Inguna qoki rhoqor ma Jona qärak i sa qale qa vät ama dävaung ama qunäng dä ama dävagukt ama bängang da ama mor qa ama rhinämga aa ron diva qosaqi ma Ruqa aa Emga rhoqoräkt iva qale qa vät ama dävaung ama qunäng dä ama dävagukt ama bängang da ama ivätki aa ron. ");
INSERT INTO uro_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ama ruvek nae näva ama värhäm ama mor äm ma Ninive va rha rhair ti nä rhit täkt ama qoengait pät ama qunäga qärakni iva ma Ngämuqa qa rhatnävämne na ama ruvek pät ama ivätki bä va iarhakt ama ruvek ti rhäksärhäm ngän inguna mudu rha näpgoer na nas toqoräkt i ma Jona qa sameng bät a rha. Dap täkt di aingo qärak i qale ngo rhe di ngua e daver ma Jona.” ");
INSERT INTO uro_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ama vitnaqi e vät ama ivärhäs ma Seba diva qia rhäranas pät iaqäkt ama qunäga qärakni iva ma Ngämuqa qa rhatnävämne na ama ruvek bä va qi rhäksärhä rhit täkt ama qoengait inguna qia met näva ama iska näda ama ivätki at tärhäkt ivakt iva qi nari ama ruqa sa ama mädräm ama mär ngät ma Solomon aa enge. As ngäni lu i aingo qärak i qale ngo rhe di ngua e daver ma Solomon. ");
INSERT INTO uro_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Qre va vuk sa ama iauska nämät ama ruqa dä qat tet pät ama ivärhäs ama qräk dä bäs bä qät ñäm nani anga ivärhäs ivakt iva mae vät a qa e. Sokt di qaku qä namäqäne dä mamär. ");
INSERT INTO uro_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Dä nasot di qat tu aa snäng doqortäqyia, ‘Va evär däm ngo sävä gua vätka qärak i sa ngua män näväm ga.’ Bä nga rhoqoräkt i qat dän bä samuk dä qä lu qa vätka i ama dungdu ga näkt ama qumärqumär väm ga näkt sa mamär na qa moe. ");
INSERT INTO uro_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Dä qat tet bä qat dän sa ama ngärhäqyet da udiom angätni ama iaus kärangätni i sa ngä met e na qa sa angärha lat ama vu ngät bä ngät don sävä qa vätka bä qale ngät e. Dä iaqäkt ama ruqa di sa mäqi mava na qa dap täkt di sa mava na qa masirhat mamär. Ama ruvek nävät tit täkt ama qoengait diva rha rhoqoräkt.” ");
INSERT INTO uro_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Bä nga as ma Jisas kat tamän särha ama ruvek dä nak sa aa nanäk ki na aa läktpek ta män bä rhat mair dalek bä rhit täkne iva rha rhamän särhäm ga. ");
INSERT INTO uro_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Sokt di qa muvät pät ama engevärhaqa rhoqortäqyia, “Agukt koe di gu nanäk bä guavek koe di gua läktpek?” ");
INSERT INTO uro_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Dä qa rhäk aa rhäqyet sävät aa mudäsaqongda i qä qoar toqortäqyia, “Erhärhae rhäkt, di gu nanäk ki nä gua läktpek! ");
INSERT INTO uro_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Inguna guavek koe qärarhani i rhat tualat parhäm gu mam dak pono da ama usäpki arha ron aa snängaqa di iarhakt di gua läktka dä gua läktki dä gu nanäk na rha.” ");
INSERT INTO uro_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Vät iaqäkt ama sägäk ama qunäga dä ma Jisas ka met daqule ama vätka bä qa met sävät ama namuqa aa rhäkt näkt kat muqun e. ");
INSERT INTO uro_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Dä västämne na ama mor ngät ama gulañ na ama ruvek namet a qa bä äkt i qa veng sämät ama mlauski ama lil qi bä qa muqun. Dap ama ruvek moe di rhat mair vät ama qoan. ");
INSERT INTO uro_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Dä qa qoar na rha na ama rhäqäp nä irhong na ama enge na ama siqut i qä qoar toqortäqyia, “Maos dä akni ama latka qärakni i qät don na ama gavämirhong ga met säva ama etki ivakt iva qä qutnanokt pät a qi. ");
INSERT INTO uro_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Bä nga qät don na ama gavämirhong dä arhongni di irhong ngä säp sä varhäm ama iska dä ama isäm ngä män bä ngä mäs irhong. ");
INSERT INTO uro_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Dap arhongni ngä säp sävät ama ivärhimek kärqämekni i ama dui väm imek äkt i qaku ama ivätki masirhat bä ama gavämirhong ngä lir ngä ir inguna ama ingas ama ivätki. ");
INSERT INTO uro_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Sokt di nga ama qunäga qa sek mes dä qek pät irhong bä nät däm irhong inguna qaku irhong angärha anga qridu anga uiu ngät. ");
INSERT INTO uro_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dap arhongni ama gavämirhong ngä säp sä mänguräp ama ritgung bä nga ama ritgung ngä ir dä ngä ong ama gavämirhong bä ngä slava nä irhong angärha irhirqi. ");
INSERT INTO uro_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Dap arhongni ama gavämirhong ngä säp sävät ama mär qi ama ivätki bä irhong ngä ir bä irhong ngä sa i arhong ngä sa ama handret nä irhong ama gavämirhong dap arhong ngä sa ama dävaung na rha ama ruvek nä irhong dap arhong ngä sa ama ruqa ama rhäk täm ga da ama ngärhäqyisem nä irhong.” ");
INSERT INTO uro_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Dä qosaqi qa qoar toqortäqyia, “Iaqäkt kärak i nani a qa iva qunäga vät a qa sä gua enge di mamär iva qat nari mamär.” ");
INSERT INTO uro_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Dä ama mudäsaqongda rha met sagem ga bä rhi snanbät sä qa rhoqortäqyia, “Mäniekt bä ngiat tamän särha ama ruvek na ama enge na ama siqut?” ");
INSERT INTO uro_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Dä qa muvät pät a rha i, “Aingän di sa ma Ngämuqa qa rhares ba ngän iva qunäga vät a ngän sävät ama Muräktpäm na rhävuk angät ngaivirhong dap ta di sa qaku qa rhares pät arha rhäng. ");
INSERT INTO uro_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Iomäkt di sa ama engäktki na äm inguna aung gärakni i sa aa anga guani diva rhi von ga rha arhongni savono sae bä va masirhat mamär na aa qärhong. Dap aung gärakni i sa qaku aa anga guani diva qäqi rhi rha aa qäni ama gaini nä ini nagem ga. ");
INSERT INTO uro_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iomäkt di ama rharimini qärqäni i nguat tamän särhäm da na ama enge na ama siqut. Inguna rhat nañäm sokt di qaku rhi nalu bä rhat nari sokt di qaku qunäga vät a rha. ");
INSERT INTO uro_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ngäktki i ma Aisaia aa enge nage ma Ngämuqa mudu di sa rhäkmamär na ngät sävät tärhae rhäkt ama ruvek kärangätni i ngät tamän doqortäqyia, “‘ “Aingän di nak pa ngänät nari sokt diva qaku qunäga vät a ngän bä nak pa ngänät nañäm sokt diva qaku ngän nalu guani.” ");
INSERT INTO uro_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Inguna rhärhae rhäkt ama ruvek di sa arhä mädräm ngä män i sa qaku qunäga mät ngät bä sokt mamär vät a rha iva rhat nari ama gaini nämät arha sdäm dä sa rha väsdät mät arhä saqong. Nga vadi mai qaku rhoqoräkt diva mamär iva rhat nañäm na arhä saqong bä va rhat nari nämät arha sdäm bä va qunäga mät arhä mädräm dä va rhi rhong sävät a ngo dä va ngua rhumaiar ta.’ ");
INSERT INTO uro_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Sokt di sa ama modämne nga e gem ngän inguna aingän di sa ngänät nañäm na angän saqong dä ngänät nari nämät angäna sdäm. ");
INSERT INTO uro_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ngu qoar na ngän na ama engäktki i ama rhäqäp na rha ma Ngämuqa aa vämginarha rhi na ama räkt ta ama ruvek mudu di sa nani a rha masirhat iva rhi lu rhärhong däkt kärqärhong i sa ngänät lu irhong sokt di qaku rha lu irhong. Bä qosaqi nani a rha iva rhi nari rhärhong däkt kärqärhong i sa ngänät nari irhong sokt di qaku rha nari irhong. ");
INSERT INTO uro_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Mamär iva qunäga vät a ngän sa ama enge na ama siqutki sävät ama latka qärakni i qät don na ama gavämirhong. ");
INSERT INTO uro_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nga rhoqoräkt i sävetka qat nari ama enge sävät ama Muräktpäm näkt kaku qunäga vät a qa sä ngät di qa rhoqor ama gavämirhong gärqärhong i irhong ngä säp sä varhäm ama iska. Näkt sa ama vu qa ama ruqa ma Sämga qat dän dä qä rharvät dä iarhongäkt näda aa ron gärqärhong i sa qa latka qa qutnanokt irhong. ");
INSERT INTO uro_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Iarhongäkt kärqärhong i irhong ngä säp pät ama ivärhimek kärqämekni i ama dui väm imek di ama siqutki sävät aung gärakni i qat nari ama enge dä qät lir qät ta ngät na ama märmärgem. ");
INSERT INTO uro_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Dap as kaku angät snagut ngä mon säda aa ron mamär dä soknga qat mair di nak kop sokt pät ama qäväläm ama qot äm. Bä nga ama märän ura ama siqutsiqut nage ama ruvek ngät dän bät a qa nävät ma Ngämuqa aa enge dä lärlir mämae da aa qatnanakt. ");
INSERT INTO uro_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Dap sävät ama gavämirhong gärqärhong i sa irhong ngä säp sä mänguräp ama ritgung di ama siqutki nä irhong sävät aung gärakni i sa qa nari sokt di ama qänäskänes sävät ama ivätki at kärhong dä ama mämägän gärangätni i ngärhi irastäm sa ama ruvek di sa ngä män bit pa ama enge angät tpäs bä qaku anga gavam ngät dän nävät a ngät. ");
INSERT INTO uro_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Dä iarhongäkt kärqärhong i qa latka qa qutnanokt irhong bät ama mär qi ama ivätki di ama siqutki sävät aung gärakni i qat nari ama enge bä qunäga vät a qa sä ngät. Qa di ngäktki i qät sa ama gavam. Bä nävät asägäni asägäni ama gavämini di arhani ama ruvek toqoräkt di rhit sa ama handret na ngät ama gavam dap arhani di rhit sa ama dävaung na rha ama ruvek na ngät dap arhani di rhit sa ama ruqa ama rhäk täm ga da ama ngärhäqyisem na ngät ama gavam.” ");
INSERT INTO uro_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Dä ma Jisas ka märhamän bät angätni ama enge na ama siqutki bä ba rha i qä qoar toqortäqyia, “Iaqäkt na rhävuk aa Muräktpäm di mamär vät a ngo iva ngua rhuqut täm ngät di sävät akni ama ruqa qärakni i qa qutnanokt ama mär irhong ama gavämirhong bät aa etki. ");
INSERT INTO uro_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Bä nga aa latta di rhi mänatäm dä aa ik ka män bä qa qutnanokt ama mran ama vu ngät mänguräp ama wit näkt ka met. ");
INSERT INTO uro_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","“Dä soknga nga rhoqoräkt i ama wit ngä ir bä ngä sa dä qosaqi vuk sa ama mran ama vu ngät. ");
INSERT INTO uro_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Dä iaqäkt ama morqa aa latta rha män gem ga bä rhi snanbät sä qa rhoqortäqyia, ‘Morqa, nga qaku ngia qutnanokt ama mär irhong ama gavämirhong bät gia etki? Bä nga rhoqoräkt dä ngu lu ama mran ama vu ngät ngä män na qoe?’ ");
INSERT INTO uro_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Dä qa qoar na rha i, ‘Sa aurha anga ik ka mualat toqoräkt.’ Bä äkt i ama latta rha snanbät sä qa rhoqortäqyia, ‘Näkt nga nani a nge iva u rhet bä u rhar mät iangärhäkt ama mran ama vu ngät nae?’ ");
INSERT INTO uro_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Dä qa morqa qa qoar na rha rhoqortäqyia, ‘Qaku inguna varis ngän namar mät anga wit sä ne na ama mran ama vu ngät. ");
INSERT INTO uro_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mamär iva ama wit ngä na ama mran ama vu ngät ngärhi ir gem ne bä dängdäng bät ama qäväläm iva ama latta rhit dodäkt sa ama tmäs. Bä vät iomäkt ama qäväläm diva ngu qoar nä iarhakt ama latta iva rhi er ti rha ama mran ama vu ngät näkt ti qop pät a ngät ma ama istakt näkt ti väs ngät. Näkt mamär dä va rhi rha ama wit bä va rha rhu ngät puk pä gua vätki qäraktni i qali qi e iva rhoqoräkt.’” ");
INSERT INTO uro_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Dä ma Jisas ka märhamän bät angätni ama enge na ama siqutki bä ba rha i qä qoar toqortäqyia, “Ama Muräktpäm na rhävuk di ngät toqor ama mastard aa gavämini qärqäni i ama ruqa qa rha ini bä qa qutnanokt ini vät aa etki. ");
INSERT INTO uro_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ianiäkt ama gavämini di ama gaini nä ini mamär dap nga sa ini ngä ir dä sa ini ngä män i ama ngämuga. Iaqäkt ama ngämuga diva qä ir vit pa arhongni ama namuirhong moe angät tpäs pät ama et bä aa rhäqyitnäk diva ama mor itnäk bä äkt iva ama isäm nämät ama leqäs ngä rhän bä va ngärhit täk angärha vät pät aa qän.” ");
INSERT INTO uro_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Dä ma Jisas ka märhamän särhäm da na angätni ama enge na ama siqutki rhoqortäqyia, “Ama Muräktpäm na rhävuk di ngät toqor ama yis käraktni i ama ruqi qia rha qi bä qia mu qi va ama mor ngät ama plaua näkt kia näpgoer na ngät päm ne bä dängdäng i ama yis kia mon säva ama qopkopki moe.” ");
INSERT INTO uro_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Rhärhong däkt moe di sa ma Jisas ka märhamän bät irhong bä ba ama gulañ na ama enge na ama siqut. Qop sokt kat tamän särhäm da di na ama enge na ama siqut. ");
INSERT INTO uro_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Dä aa lat iangärhäkt di sa ngä rhäkmamär na ama enge qärangätni i sa akni ama vämginaqa mudu qa märhamän bät a ngät toqortäqyia, “Va ngua rhamän särhäm da di na ama enge na ama siqut bä va nguat tamän sävät iarhongäkt kärqärhong i sa ma Ngämuqa qa ngaip irhong di nävät ama qäväläm gärqomni i qa säm ama ivätki.” ");
INSERT INTO uro_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Dä nasot dä ma Jisas ka met daqule ama gulañ na ama ruvek bä qa met säva vät. Dä aa mudäsaqongda rha män sagem ga i rhi qoar na qa rhoqortäqyia, “Mamär iva ngit täväkt sa ama enge na ama siqutki sävät ama mran ama vu ngät pät ama etki bä ba ut.” ");
INSERT INTO uro_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Dä qa muvät toqortäqyia, “Iaqäkt ka ruqa qärak i qät kutnanokt ama mär irhong ama gavämirhong di aingo ma Ruqa aa Emga. ");
INSERT INTO uro_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Dä ama etki di ama ivätki dap ama gavämirhong ama mär irhong di ama rhoes näva ama Muräktpäm. Dap ama mran ama vu ngät di ama vu qa ama ruqa ma Sämga aa es. ");
INSERT INTO uro_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Dä iaqäkt kärak i qa qutnanokt ama mran ama vu ngät di aurha ik ma Sämga dap ama qäväläm gärqomni i rhit dodäkt sa ama tmäs diva ama qäväläm gärqomni iva rhäksot na ama ivätki dap ama latta qärarhani i rhit dodäkt sa ama tmäs e di ama enselqäna. ");
INSERT INTO uro_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Di qoki rhoqor ama mran ama vu ngät di rhit ta ngät bä rhit päs ngät mät ama mudäbäs diva rhoqoräkt pät ama qäväläm gärqomni iva rhäksot na ama ivätki. ");
INSERT INTO uro_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Va ma Ruqa aa Emga qä rhäk na aa enselqäna bä va rhi rha iarhongäkt kärqärhong i irhong ngät dän sa ama vuirhong moe ngä na ama ruvek kärarhani i rhat tualat na ama vu ngät ama lat näva aa Muräktpäm. ");
INSERT INTO uro_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Bä va rhi rhon sämät ama mudäbäs ama qrot äs. Vät iosäkt ama ivärhäs diva rhat tuqaia dä va rhit nes arhä qeng angärha rem na ne. ");
INSERT INTO uro_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Dä nasot dä va ama räkt ta na rha ama ruvek tit sen i rha rhoqor ama qunäga va arhä mamäk aa Muräktpäm. Aung gärakni i nani a qa iva qunäga vät a qa sä gua enge di mamär iva qat nari mamär. ");
INSERT INTO uro_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Iaqäkt na rhävuk aa Muräktpäm di ngät toqor ama mämägän gärangätni i sa rha ngaip ngät pät ama etki qärangätni i akni ama ruqa qa män bät a ngät dä qa sasärhäm ngät. Näkt nasot dä qat tet nävät ama märmärgem bä qät boda aa qärhong moe näkt kät bodäm bät iaqyäkt ama etki. ");
INSERT INTO uro_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Bä qosaqi iaqäkt na rhävuk aa Muräktpäm di ngät toqor ama ruqa qärakni i qat dräm gät boda ama qärhong gärakni i qät ñäm nani ama mär ngät ama pelqäna. ");
INSERT INTO uro_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bä nga qa män bät aktni ama pel qäraktni i ama ligär masirhat pät a qi dä qa met bä qa voda aa qärhong moe näkt ka vodäm bät a qi. ");
INSERT INTO uro_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Qosaqi iaqäkt na rhävuk aa Muräktpäm di ngät toqor ama väiuqi qäraktni i sa akni qa rhon na qi säva ama namuqa bä qia rha ama rhäqäp na ngät ama rhinäm maos maos. ");
INSERT INTO uro_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bä nga rhäqäp ki mamär dä ama gamoe rha ar mä qi sävät ama qoan bä rha muqun bä rha mät ama mär ngät ama rhinäm bä rha mu ngät mät ama urat dap ta rhon na ama vu ngät nae. ");
INSERT INTO uro_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Vät ama qäväläm gärqomni iva rhäksot na ama ivätki diva rhoqoräkt. Va ama enselqäna rha rhän bä va rha rhatma ama vu rha ama ruvek nämäni ama räkt ta ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Näkt pa rhi rhon na ama vu rha ama ruvek sämät ama qrot äs ama mudäbäs. Vät iosäkt ama ivärhäs diva rhat tuqaia dä va rhit nes arhä qeng angärha rem na ne.” ");
INSERT INTO uro_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Dä ma Jisas ka snanbät sä rha rhoqortäqyia, “Nga sa qunäga vät a ngän sä rhärhong däkt moe?” Dä rha muvät pät a qa i, “Iei.” ");
INSERT INTO uro_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Dä qa qoar na rha rhoqortäqyia, “Iarhakt moe qärarhae i sa rha män i ama mudäsaqongda na rha bä rhi su ama ruvek sävät iaqäkt na rhävuk aa Muräktpäm di rha rhoqor ama morqa qärakni i vukpuk sä qa näva aa vätka sa angätni nävät aa mämägän gärangätni i ama iar ngät dä angätni qärangätni i ama mru ngät.” ");
INSERT INTO uro_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sa nga ma Jisas ka märhamän bät tangät täkt ama enge na ama siqut bä rhäksot dä qa met na äkt. ");
INSERT INTO uro_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bä nga qa män sämät aa värhäm dä qa su ama ruvek pa arhä mämairqi. Dä qräk mät ta nävät aa rhisu bä rhi snanbät sä ne rhoqortäqyia, “Nak tak täkt ama ruqa di sa qa rha rhangät täkt ama mädräm ama mär ngät dä rhangät täkt ama qrot ngät ama lat na qoe? ");
INSERT INTO uro_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nga qaku iaqäkt kärak i qat dräm gät täk pät ama vät aa emga? Nga qaku rhat tes aa nanäk i ma Maria? Bä nga qaku aa läktpek ama gamoe i ma Jems kä nä ma Josep dä ma Saimon näkt ma Judas? ");
INSERT INTO uro_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nga qaku aa läktpek ama evop moe rhe gem ut? Bä nga rhoqoräkt dä rhak täkt ama ruqa qa rha rhärhong däkt moe na qoe?” ");
INSERT INTO uro_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Dä rha qut säda arha ron nävät a qa. Sokt di ma Jisas ka qoar na rha rhoqortäqyia, “Ama vämginaqa di qaku ama ruvek tit kutdrir sagem ga dap sokt mät aa värhäm maräkt dä mänguräp aa qärhae maräkt.” ");
INSERT INTO uro_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Dä qaku qa mualat na anga qrot ngät anga lat masirhat e inguna qaku arha anga qatnanakt. ");
INSERT INTO uro_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Vät iomäkt ama qäväläm dä ama tpäskinaqa ma Herot ka nari ama sameng sävät ma Jisas ");
INSERT INTO uro_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","dä qa qoar na aa latta rhoqortäqyia, “Rhak täkt di ma Jon ama Baptais. Sa qa märanas nämät ama tñäpki bä rhoqoräkt i rhangät täkt ama nañis ngät ama qrot ngät ama lat di ngät tualat gem ga.” ");
INSERT INTO uro_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ma Herot ka märhamän doqoräkt inguna sa qa voda rha ama muräkt ivakt iva rhi sangar ma Jon bä rhi qop pät a qa bä va rha rhu qa va ama tpäskiarharhäng inguna vät ma Filip ma Herot aa läktka aa egutki ma Herodias at täväs ");
INSERT INTO uro_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","inguna ma Jon sa qa qoar na qa rhoqortäqyia, “Qaku maräkt parhäm ama Muräkt iva ngia rhät ma Herodias.” ");
INSERT INTO uro_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Bä näma dä nani a qa iva qä vodäm ga sämät ama tñäpki sokt di qät len ama ruvek inguna rhat nanakt i ma Jon di ama vämginaqa na qa. ");
INSERT INTO uro_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sokt di nga vät ma Herot aa bängagi qäraktni i mudu rha säl a qa dä ma Herodias at tuimgi qia main dä ma Herotkäna arhä saqong bä märmär ge ma Herot nävät a qi. ");
INSERT INTO uro_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Dä soknga qa mumänaris na ama musärhäm iva qä von gi rha agini qärqäni iva qi nän ga rhäm ini. ");
INSERT INTO uro_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Dä at nanäk kia rhäklänge mät ki bä qia qoar nä ma Herot toqortäqyia, “Ngi von ngo rhä ma Jon ama Baptais aa uväski va ama pletige ama mor ige.” ");
INSERT INTO uro_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Dä ama vitnaqa di airäs ka sokt dinguna sa qa mumänaris ma ama qrot da aa ruavek arhä saqong dä qa qoar bä aa latta rha mualat toqoräkt. ");
INSERT INTO uro_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Qa rhäkne bä rha rhodäkt mät ma Jon ba ama tpäskiarharhäng ");
INSERT INTO uro_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","näkt ta män bä samuk sa aa uväski va ama pletige ama mor ige bä rha von ama rhuimgi rhäm gi bä qia rha qi ba at nanäk. ");
INSERT INTO uro_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Dä ma Jon aa mudäsaqongda rha män bä rha rha aa släqyige bä rha sasärhäm ige näkt ta met bä rha sameng bä ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Näkt nga ma Jisas ka nari rhoqoräkt sävät ma Jon dä qa met na äkt mät ama mlauski bä sävät ama ivärhäs kärqosni i qaku anga ruvek e bä qale qa e i sokt ka. Sokt di nga ama ruvek ta nari rhoqoräkt dä rha met näva arha värhap bä rha met nasot a qa. ");
INSERT INTO uro_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Bä nga ma Jisas ka män mit pät a qoan dä qa lu ama mor qi ama guläñgi na ama ruvek dä qa lavuqi na rha dä qa mumäräs pät arha rämgivärharha. ");
INSERT INTO uro_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bä nga bängangäs dä aa mudäsaqongda rha män gem ga bä rha qoar na qa rhoqortäqyia, “Sa ama qunäga qat don dap tos täkt ama ivärhäs di qale läs gläius. Mamär iva ngi rhäk na ama gulañ ivakt iva rha rhet sämät ama värhäm bä va rhi vodäm bät anga tmäs bä ba nas.” ");
INSERT INTO uro_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sokt di ma Jisas ka qoar i, “Mamär iva qoki qale rha dap pa ngäni von da rha anga tmäs.” ");
INSERT INTO uro_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Dä rhi qoar na qa rhoqortäqyia, “Qop sokt ama bretkäna ama ngärhäqyet näkt sävät ama rhinämiom ama udiom nga e gem ut.” ");
INSERT INTO uro_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Dä ma Jisas ka qoar i, “Ngäni rha ngät sagem ngo.” ");
INSERT INTO uro_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Dä qa qoar na ama gulañ na ama ruvek iva rha rhuqun bät ama mran. Näkt ka rha ama ngärhäqyet ama bretkäna dä ama udiom ama rhinämiom näkt ka ñäm dävit säva ama usäpki bä qa mes ama mär sage ma Ngämuqa. Dä qa vonmät na ama bretkäna bä qa von aa mudäsaqongda bä rha are däm ngät bä ba ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bä rha moe rha mäs bä arhä sarem. Näkt ama mudäsaqongda rha rhäqäp ama urat ama ngärhäqyisem da unbem na ngät na ama mäsdävät. ");
INSERT INTO uro_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ama rhodäm sa ama gamoe iarhakt kärarhae i sa rha mäs di ama ngärhäqyet ama tausengäna na rha dap kosaqi ama evop ti na ama rhoes ta mäs. ");
INSERT INTO uro_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Dä nak kop äkt dä ma Jisas ka qoar na ama mudäsaqongda bä rha veng sämät ama mlauski iva rhi rhoer särhage na ama namuqa dap pa dängdäng na qa ivakt iva qä vräs na ama gulañ. ");
INSERT INTO uro_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Dä nasot dä dang däm ga bä sämäni ama damgi ivakt iva qä nän. Bä sa rhoqoräkt i bängangäs dä qop sokt ka qale qa äkt. ");
INSERT INTO uro_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Dap pät iomäkt ama qäväläm di sa ama mlauski di sa qia muk da ama namuqa aa ron i ama vaeng ngärhit don na qi ba ne inguna ama laurqi qi e nani a ne na rha. ");
INSERT INTO uro_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bä nga sa qorhäs iva qunäga dä ma Jisas ka met sagem da i qat tet pät ama qoeväs angärha rhäng. ");
INSERT INTO uro_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Sokt di nga aa mudäsaqongda rha lu qa i qat tet pät ama qoeväs angärha rhäng dä rhit len masirhat mamär bä rhi qoar i, “Ama rhomga iaqäkt!” Bä rhat tuqaia i rhit len. ");
INSERT INTO uro_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Dä qa märhamän särhäm da masägos i qä qoar na rha rhoqortäqyia, “Qale ngänit len! Nak kop mamär. I nak kop aingo.” ");
INSERT INTO uro_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dä ma Pita qa muvät pät a qa rhoqortäqyia, “Engeska, ngakt bä ngäktki i ainge dä ngi qoar na ngo iva ngua rhet pät ama qoeväs angärha rhäng sagem nge.” ");
INSERT INTO uro_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Dä ma Jisas ka qoar na qa i, “Ngi ang!” Dä soknga ma Pita qa sär sä nas nämät ama mlauski bä qat tet pät ama qoeväs angärha rhäng sage ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sokt di nga qa lu ama laurqi dä qät len bä qä nasäng i qat don dä qa näs sävät ma Jisas i, “Engeska, ngia rhumaiar ngo.” ");
INSERT INTO uro_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Dä ma Jisas ka rhäk aa rhäqyet masägos bä qa sangar ma Pita i qä qoar na qa rhoqortäqyia, “Ai, ainge di ama gaini nä gi qatnanakt. Mäniekt bä qaku sägäk nä gi snängaqa?” ");
INSERT INTO uro_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bä nga in beng sämät ama mlauski dä mae da ama laurqi. ");
INSERT INTO uro_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Dä iarhakt kärarhae i qale rha mät kä mlauski di rhi nän sagem ga i rhi qoar i, “Ngäktki i nge di ma Ngämuqa aa emga na nge.” ");
INSERT INTO uro_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bä nga sa rha mängaläkt särhage dä mae vät a rha e vät ama ivärhäs ma Genesaret. ");
INSERT INTO uro_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bä nga ama gamoe nävät iosäkt ama ivärhäs ta räm ma Jisas dä rha rhäkne nani ama rämgivärharha moe nävät iaqäkt ama ngärhäktka bä ama ruvek ta män sä rha sagem ga. ");
INSERT INTO uro_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Näkt tat naing bät a qa iva qät tares pät ama rämgivärharha arha rhäng iva nak kop pa sokt tit täk da aa boiqi arha väm. Bä iarhakt moe qärarhae i sa rha rhäk da arha väm di sa märäs pät a rha. ");
INSERT INTO uro_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mamär dä ama Farisiqäna rhi na ama Skraipkäna rha män nae ma Jerusalem bä sage ma Jisas bä rhi snanbät sä qa rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mäniekt bä gi mudäsaqongda di qaku rhat tet parhäm aurha morta arhä qärhong? Inguna qaku rhit tor arhä rhäkt narhoer näkt sa rhat täs.” ");
INSERT INTO uro_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Dä ma Jisas ka muvät pät a rha i, “Mäniekt bä ngänin nänbetäkmät na ama muräkt nage ma Ngämuqa ivakt iva ngän det parhäm angäna morta arhä qärhong? ");
INSERT INTO uro_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Inguna ma Ngämuqa qa muräkt toqortäqyia, ‘Mamär iva ngit kutdrir sävät gi mamäk dä gi nanäk’ dap ‘Aung gärakni i qat tamän mava na aa mamäk ura aa nanäk diva qoki rhi veng ga.’ ");
INSERT INTO uro_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Sokt di aingän di ngäni qoar i, ‘Ngakt bä aung anga ruqa qä qoar na aa mamäk ura na aa nanäk i agi matnärhäm gärangätni i mai va ngu von en däm ngät di sa ngua von ma Ngämuqa ");
INSERT INTO uro_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","bä rhoqoräkt di sa mamär na qa i qaku qät kutdrir sage aa mamäk.’ Bä äkt i rhoqoräkt di sa ngänit kyiradeng nä ma Ngämuqa aa enge ivakt iva ngän det parhäm angän gärhong. ");
INSERT INTO uro_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Aingän gärarhae i ngän dualat sädä saqong, ma Aisaia di sa qa märhamän mamär bät ama enge nage ma Ngämuqa sävät a ngän doqoräkt i qa qoar toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Rhärhae rhäkt ama ruvek di rhit kutdrir sävät a ngo nämät arha väm dap arhä snängaqa di qa e gläius na ngo. ");
INSERT INTO uro_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Dap ti nänsäs sagem ngo mavängam i rhi su ama ruvek na arhä muräkt kärangätni i rhoqor qre ama muräkt nagem ngo.’” ");
INSERT INTO uro_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Dä ma Jisas ka mes ama ruvek sagem mes bä qa qoar na rha rhoqortäqyia, “Mamär iva ngäni nari ngo bä va qunäga vät a ngän i ");
INSERT INTO uro_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","qaku agini qärqäni i ini ngät don sämät ama ruqa aa vämgi di ini ngät tualat sä qa bä va qaku ama qumärqumär qa dä ma Ngämuqa aa saqong. Dap kinak agini qärqäni i vukpuk sä ini nämät aa vämgi di rhäni rhäkt di ini ngät tualat sä qa bä va qaku ama qumärqumär qa.” ");
INSERT INTO uro_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dä ama mudäsaqongda rha män sagem ga bä rha qoar na qa rhoqortäqyia, “Nga sa ngiat dräm i ama Farisiqäna di nga rha nari rhangät täkt gia enge dä sa rha qut säda arha ron nävät a ngät?” ");
INSERT INTO uro_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Dä ma Jisas ka muvät i, “Ama namuirhong moe qärqärhongni i sa qaku gu mam dak pono da ama usäpki arha ron ga qutnanokt irhong diva rha rhar mät irhong nae. ");
INSERT INTO uro_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ngäni qyiradeng na rha. Rha di ama säsur ta ama ruvek kärarhani i rhi rhoer nanokt ama ruvek. Dä ngakt bä anga säsurta di rhi rhoer nanokt anga säsurta diva rha moe rha rhon sämät ama uqupka.” ");
INSERT INTO uro_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Sokt di ma Pita qa qoar na qa rhoqortäqyia, “Mamär iva ngit täväkt sa ama enge na ama siqutki bä ba ut.” ");
INSERT INTO uro_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Dä ma Jisas ka qoar i, “Nga as kaku qunäga vät a nge? ");
INSERT INTO uro_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nga qaku ngiat dräm i agini qärqäni i ini ngät don sämät ama ruqa aa vämgi di ini ngät don sämät aa sarimgi näkt nasot dä vuk sä ini näva aa släqyige? ");
INSERT INTO uro_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Sokt di agini qärqäni i vukpuk sä ini nämät aa vämgi di ini ngät dän nämät aa snängaqa bä rhäni rhäkt di ini ngät tualat sä qa bä qaku ama qumärqumär qa. ");
INSERT INTO uro_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Inguna namuk nämät ama ruqa aa snängaqa dä ama vu ngät ama mungäsnäng ngärhi rhartäm sä qa bä qä veng dä qä qavatnävätlägut dä qat tualat na ama lat na ama qavatka maos maos dä qä sua dä qä iras na ama enge sävät arhani dä qat tamän mava na ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iarhongäkt toqoräkt di irhong ngät täqäne sa ama ruqa bä qaku ama qumärqumär qa. Sokt di nga aung gat täs sokt di qaku qa er qa rhor aa rhäkt di iangärhäkt ama lat toqoräkt di qaku ngät tualat sä qa bä qaku ama qumärqumär qa.” ");
INSERT INTO uro_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Dä ma Jisas ka met na äkt dä qa met bä sävät ama ngärhäktka namet ma Tair dä ma Saidon. ");
INSERT INTO uro_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Dä nak sa ama evopki nävät ama Kenangäna qäraktni i qiat tas e vä iaqäkt ama ngärhäktka qia män sagem ga bä qit nok i qi qoar toqortäqyia, “Gua morqa ma Devit aa emga, mamär iva ngit lavuqi na ngo inguna ngua imgi di ama iauska qät täk pät a qi mamär.” ");
INSERT INTO uro_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sokt di qaku qa muvät pät a qi na anga enge. Dä aa mudäsaqongda rha män sagem ga bä rhat naing bät a qa i rhi qoar toqortäqyia, “Mamär iva ngi rhäk na qi nae inguna qiat tet nasot a ut dä qiat tuqaia.” ");
INSERT INTO uro_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Dä ma Jisas ka muvät pät a qi rhoqortäqyia, “Sa ma Ngämuqa qa rhäk na ngo sokt sage ama Israelqäna qärarhani i rha rhoqor ama sipsipkäna qärangätni i sa musäng sä ngät.” ");
INSERT INTO uro_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sokt di qia män bä qia an da arha quum sä nas säng ma Jisas aa qar i qi qoar toqortäqyia, “Gua morqa, mamär iva ngia rhatnärhäm ngo.” ");
INSERT INTO uro_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Dä ma Jisas ka muvät pät a qi rhoqortäqyia, “Qaku maräkt iva rhi rha ama rhoes arha tmäs bä rhi rhon na ngät bä ba ama im.” ");
INSERT INTO uro_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Dä qia muvät toqortäqyia, “Ngäktki na nge gua morqa, dap käqi ama im di mamär vät a ngät iva ngät täs ama nesdäm nasot angärha morta qärangätni i suksuk däm ngät säva ama lai angärha rem.” ");
INSERT INTO uro_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Dä ma Jisas ka muvät pät a qi rhoqortäqyia, “Rhaktni, gi qatnanakt di ama mor ngät! Qoki va rhäkmamär varhäm gi snängaqa.” Bä vät iomäkt ama qäväläm dä märäs pät at tuimgi. ");
INSERT INTO uro_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Dä ma Jisas ka met na äkt bä qa met pät ama namuqa ma Galili aa qoan. Näkt dang däm ga sämäni ama dabäm bä qa muqun e. ");
INSERT INTO uro_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Dä ama mor ngät ama gulañ na ama ruvek ta män sagem ga sa ama vävarhämda dä ama säsurta dä ama vaktpärharha dä iarhakt kärarhae i qaku rhat tamän näkt sävät arhani ama rhäqäp na rha ama rämgivärharha bä rha mu rha säng ma Jisas aa qar bä qa mumäräs pät a rha. ");
INSERT INTO uro_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Dä ama guläñgi na ama ruvek di qräk mät ta rhoqoräkt i rha lu ama ruvek kärarhani i qaku rhat tamän i sa rhat tamän dä ama vaktpärharha i sa märäs pät a rha dä ama vävarhämda i sa rhat tet dä ama säsurta i sa rhat nañäm. Dä rhi nän sa ama Israelqäna arhä Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nasot dä ma Jisas ka mes aa mudäsaqongda sagem mes bä qa qoar na rha rhoqortäqyia, “Aingo di ngut lavuqi nä rhärhae rhäkt ama ruvek inguna sa qale rha gem ngo vät ama dävaung ama qunäng näkt kaku guarhong iva rha äs. Bä qaku nani a ngo iva ngu rhäk na rha nae rhoqor täkt i anoeng mä rha i varis deng bät a rha varhäm ama iska.” ");
INSERT INTO uro_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dä ama mudäsaqongda rha snanbät sä qa i, “Nga vät ama ivärhäs gläius toqor täkt diva urhi rha anga bretkäna na qoe qärangätni i mamär iva urhi von ama mor qi ama guläñgi na ama ruvek toqor täkt ivakt iva rha äs?” ");
INSERT INTO uro_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Dä ma Jisas ka snanbät sä rha rhoqortäqyia, “Ama mämänia ama bretkäna nga e gem ngän?” Dä rha qoar i, “Ama ngärhäqyet da udiom ama bretkäna dä ama rhinämirhong ama marheka nä irhong.” ");
INSERT INTO uro_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Dä ma Jisas ka qoar na ama guläñgi na ama ruvek iva rha rhuqun bät ivät. ");
INSERT INTO uro_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Näkt ka rha qä bretkäna ama ngärhäqyet da udiom na ngät näkt sävät kä rhinämirhong näkt ka mes ama mär sage ma Ngämuqa näkt ka vonmät na ngät bä qa von aa mudäsaqongda bä rha are da ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ama ruvek moe rha mäs bä arhä sarem. Näkt ama mudäsaqongda rha matma ama mäsdävät bä rha rhäqäp ama urat ama ngärhäqyet da unbem na ngät. ");
INSERT INTO uro_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Iarhakt kärarhae i sa rha mäs di ama levaet ama tausengäna na rha ama gamoe näkt sävät ama evop ti na ama rhoes. ");
INSERT INTO uro_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Bä nga nasot i sa ma Jisas ka rhäk na ama gulañ na ama ruvek nae dä qa veng sämät ama lil qi ama mlauski bä qa met bä sävät ama ngärhäktka ma Magadan. ");
INSERT INTO uro_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Dä ama Farisiqäna rhi na ama Sadyusiqäna rha män sage ma Jisas ivakt iva rhi siqut na qa i rha nän ga iva qä qur a rha rha anga muqunängi na rhävuk. ");
INSERT INTO uro_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Qre va bängangäs dä ama qurät mät ama leqäs dä va ngäni qoar i duququ dä va ama qunänget. ");
INSERT INTO uro_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Dap pät duququs kre va ama qurät mät ama leqäs dä ama ununige vät ama qunäga aa uväs dä va ngäni qoar iva rhäqyerhäkt diva ama suigi qi säp. Sa ngänät dräm iva ngän datnävämne mamär na ama muqunän mät ama leqäs dap kaku mamär vät a ngän iva ngänät lu ñismäne sävät ama muqunän bät tangät täkt ama rhodäm. ");
INSERT INTO uro_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Aingän nävät tit täkt ama qoengait di ama vu rha ama ruvek na ngän gärarhani i sa qaku qale ngän mamär i sägäni na ngän ngän nä ma Ngämuqa rhoqor ama ruiom gärqiomni i sa in mätlägut näkt mamär dä akni qa qavatnävätlägut. Bä ngänit ñäm nani anga muqunängi sokt diva qaku anga muqunängi qi namän bä ba ngän dap sokt ama muqunängi nävät ma Jona.” Bä äkt i qa märanas bä qa met. ");
INSERT INTO uro_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Näkt ma Jisas kä na aa mudäsaqongda rha mängaläkt särhage na ama namuqa bä nga sa rha män e dä qunäga vät a rha i sa qaku rha rha anga bret. ");
INSERT INTO uro_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Ngänit lu mamär nämät ama Farisiqäna dä ama Sadyusiqäna arha yis.” ");
INSERT INTO uro_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Dä rha nasäng i rhat tamän bät a ne sävät aa enge i rhi qoar toqortäqyia, “Nguaräm ga märhamän doqoräkt dinguna sa qaku ut ta anga bret.” ");
INSERT INTO uro_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Sokt di ma Jisas ka räm arha engirhong dä qa snanbät toqortäqyia, “Mäniekt bä ngän damän bät a ne sa ama bret i qaku agung gem ngän? Ai, nak angän gatnanakt di sa ama gaini na ngät. ");
INSERT INTO uro_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nga as kaku qunäga vät a ngän? Nga qaku vuk pät a ngän i sa ngän däqäp ama urat ama mämänia na ama mäsdävät pät iomäkt ama qäväläm i sa ngua vonmät na ama bretkäna ama ngärhäqyet bä ba ama gamoe ama ngärhäqyet ama tausengäna na rha? ");
INSERT INTO uro_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bä nga qosaqi qaku vuk pät a ngän i sa ngän däqäp ama urat ama mämänia na ama mäsdävät nage qa ngärhäqyet da udiom na ngät ama bretkäna bä bä qa levaet ama tausengäna na ama ruvek? ");
INSERT INTO uro_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ngu lu mäniekt bä qaku qunäga vät a ngän i sa qaku nguat tamän sävät ama bretkäna? Ngänit lu nämät ama Farisiqäna dä ama Sadyusiqäna arha yis.” ");
INSERT INTO uro_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Bä rhoqoräkt dä sa qunäga vät a rha i nak kaku ma Jisas kat tamän sävät ama yis käraktni i säva ama bret dap kat tamän sävät ama Farisiqäna rhi na ama Sadyusiqäna arhä rhisu. ");
INSERT INTO uro_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Bä nga ma Jisas ka män sävät ama ngärhäktka glaqot na ama värhäm ama lel äm ma Sisaria Filipai dä qa snanbät sa aa mudäsaqongda rhoqortäqyia, “Aingo ma Ruqa aa Emga di ama ruvek tat tu arhä snäng i auge na ngo?” ");
INSERT INTO uro_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Dä rha muvät pät a qa rhoqortäqyia, “Arhani ama ruvek di rhi qoar i ma Jon ama Baptais dap arhani di rhi qoar i ma Elaija dap arhani di rhi qoar i ma Jeremaia ura akni nävät ma Ngämuqa aa vämginarha.” ");
INSERT INTO uro_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Dä qa snanbät sä rha rhoqortäqyia, “Dap aingän di ngän du angän snäng i auge na ngo?” ");
INSERT INTO uro_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Dä ma Saimon Pita qa muvät toqortäqyia, “Ainge di ma Krais ma Ngämuqa ama ngätdäqäm ga aa emga na nge.” ");
INSERT INTO uro_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Saimon ma Jona aa emga, ama modämne di sa nga e gem nge inguna ama ruvek di qaku rha muqunäga sä rhangät täkt ama mädräm bä ba nge dap kinak gu mam dak pono da ama usäpki arha ron sa qa muqunäga sä ngät bä ba nge. ");
INSERT INTO uro_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Dä ngu qoar na nge i ainge di ma Pita bä vät tak täkt ama duiqa aa rhäng diva ngua rhair na ama ruvek kärarhani i rhat nanakt na ngo bä va qaku mamär iva ama tñäpki at krot ngä namän näva arhä väs. ");
INSERT INTO uro_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Va ngu von nge rha ama akiqina säva ama Muräktpäm na rhävuk dä agini qärqäni i ngit tares pät ini angärha rhäng de vät ivät diva ma Ngämuqa qät tares pät ini angärha rhäng dävuk da ama usäpki arha ron näkt agini qärqäni i qaku ngit tares pät ini angärha rhäng de vät ivät diva qaku ma Ngämuqa qä narhares pät ini angärha rhäng dävuk da ama usäpki arha ron.” ");
INSERT INTO uro_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nasot dä ma Jisas ka muge ama mudäsaqongda ma ama qrot iva qale rhi naqoar na aung i qa di ma Krais. ");
INSERT INTO uro_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mänasäng na äkt dä ma Jisas ka nasäng iva qat tamän mamär särha aa mudäsaqongda iva qa rhet sae ma Jerusalem bä va qä rha ama märän maos maos masirhat nage ama morta dä ama priskäna ama moräs na rha dä ama Skraipkäna. Bä va rhi veng ga näkt pät ama dävaung na qa ama qunäga dä va ma Ngämuqa qa rhäranas na qa nämät ama tñäpki. ");
INSERT INTO uro_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Dä ma Pita qa rhäqoar sä ma Jisas sä nas bä qa rhäkne vät a qa sä iaqäkt aa muqunäga i qä qoar toqortäqyia, “Engeska, mamär iva qale ma Ngämuqa qä narhares pät iangärhäkt ama lat angärha rhäng. Qoki va qaku ngä namän bät a nge.” ");
INSERT INTO uro_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Sokt di ma Jisas ka rhong bä qa rhäkne vät ma Pita na ama enge ama qrot ngät toqortäqyia, “Sämga, ngia rhet säng gua rhäng. Ainge di ngit päs nas mäni gua iska inguna sa rhak täkt gi snängaqa di qaku qa nage ma Ngämuqa dap ka nage ama ruvek.” ");
INSERT INTO uro_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dä ma Jisas ka qoar na aa mudäsaqongda rhoqortäqyia, “Nga nani aung gärakni iva qat tet nasot a ngo di mamär iva qä qyiradeng na nas dap kä rha aa sämänanamuqa bä qät päs gua rhäng. ");
INSERT INTO uro_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Inguna aung gärakni i nani a qa iva qä sangar vät aa iar mamär diva qa rhusäng sä ngät nasot. Dap iaqäkt kärak i qät kyiradeng na aa iar bä ba ngo diva qa rhumaiar ngät. ");
INSERT INTO uro_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Va mamär vät anga ruqa rhoqor mäniekt kre i mänamär sä qa nage ama ivätki at kärhong moe dap käbäs na aa iar? Bä qop ngu lu va agini qärqäni i mamär vät anga ruqa iva qä vodäm ini ivakt iva saqi qa rhän bät aa iar? ");
INSERT INTO uro_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Inguna sa va ma Ruqa aa Emga qa rhän ba aa mam aa murhämeska qä na aa enselqäna näkt pa qa rhuvät pät ama ruvek asägäk asägäk parhäm aa lat. ");
INSERT INTO uro_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nguat tamän särhäm ngän na ama engäktki i arhani nävät a ngän däkt i ngänät mair diva as kaku rhi nañäp dap as pa rhi lu ma Ruqa aa Emga i qat dän sa aa muräkt i ama vitnaqa na qa.” ");
INSERT INTO uro_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nasot ama qunäng ama ngärhäqyet da sägäk dä ma Jisas ka rhäqoar sä ma Pita qä nä ma Jems näkt ma Jems aa läktka ma Jon bä ma Jisas ka er nanokt ta bä dang däm da säda ama damgi ama uiu qi bä sokt ta sä nas. ");
INSERT INTO uro_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bä nga sa äkt dä ma Jisas aa ñämñämgi qia män maos da arhä saqong bä aa saqongait ngät nañäm doqor ama qunäga dap aa boi di ngärhit sen i ama qulum ngät mamär. ");
INSERT INTO uro_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Dä nak sa väs dä ma Moses kä nä ma Elaija gem da bä rhat tamän särhä ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Dä Pita qa qoar nä ma Jisas toqortäqyia, “Engeska, ama mär toqoräkt i qali lut täkt. Ngakt bä nani a nge diva ngua rhair na anga däpguarhong anga värhirhong anga me irhong de iva ani ba nge dap ani bä bä ma Moses dap ani bä bä ma Elaija.” ");
INSERT INTO uro_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Bä nga as kat tamän dä nak sa ama eqoeqi qäraktni i ama qunäga mät ki qia ong da dä ama eguinga näva ama eqoeqi qat tamän doqortäqyia, “Rhak täkt di ngua emga qärak i sa gua snäng bät a qa masirhat kärak i märmär gem ngo nävät a qa. Ngänät nari nämät ka.” ");
INSERT INTO uro_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bä nga ama mudäsaqongda rha nari rhoqoräkt dä arpus na rha bä rha mas mäk pät ivät i rhit len masirhat mamär. ");
INSERT INTO uro_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Dä ma Jisas ka män gem da bä qa rhäk pät a rha i qä qoar toqortäqyia, “Ngän dair näkt kale ngänit len.” ");
INSERT INTO uro_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bä nga rha ñäm bit dä qaku rha lu aung dap sokt ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Näkt nga rhoqoräkt i arhar sä rha vät ama damgi dä ma Jisas ka mugem da ma ama qrot toqortäqyia, “Qale ngän nasameng bä ba aung sävät iangärhäkt ama lat kärangät i sa ngän lu ngät bä dängdäng i ma Ruqa aa Emga di sa ma Ngämuqa qa märanas na qa nämät ama tñäpki.” ");
INSERT INTO uro_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Dä ama mudäsaqongda rha snanbät sä qa rhoqortäqyia, “Mäniekt bä ama Skraipkäna rhi qoar i nak mamär iva ma Elaija qa er qa rhän?” ");
INSERT INTO uro_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Dä ma Jisas ka muvät toqortäqyia, “Nak koki ma Elaija diva qa er qa rhän bä va qa rhumamär nä iarhongäkt moe. ");
INSERT INTO uro_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Dap ngu qoar na ngän i sa ma Elaija qa män näkt kaku qunäga vät ama ruvek sä qa bä sa rha mualat sä qa qoki varhäm arhä snängaqa. Bä ngäktki va qosaqi ma Ruqa aa Emga qä rha ama märänga nagem da.” ");
INSERT INTO uro_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Dä qunäga vät ama mudäsaqongda i nak ma Jisas kat tamän särhäm da di sävät ma Jon ama Baptais. ");
INSERT INTO uro_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bä nga sa evär däm da sage ama guläñgi dä akni ama ruqa qa män ge ma Jisas bä qa an da aa quum sä nas säng aa qar ");
INSERT INTO uro_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","näkt ka qoar na qa rhoqortäqyia, “Gua morqa, ngi lavuqi nä ngua emga inguna ama guani na qa bä avuqi na qa mamär bä ngäda arharpus na qa sämät ama mudam bä qop säva rigi. ");
INSERT INTO uro_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Näkt ngua met sä qa sage gi mudäsaqongda dä qop kaku mamär vät a rha iva rha rhumäräs pät a qa.” ");
INSERT INTO uro_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Dä ma Jisas ka muvät toqortäqyia, “Ai, aingän di ama qoengait na ama ruvek kärarhae i qaku angän anga qatnanakt dä qosaqi ama vurha na ngän mamär. Ngu lu va qale ngo gem ngän bä dängdäng gäsnia? Dä qosaqi va ngut ta ama märänga sä ngän bä dängdäng gäsnia? Ngäni rha ama rhoemga namuk sagem ngo!” ");
INSERT INTO uro_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Näkt ma Jisas ka rhäk na ama iauska na ama enge ama qrot ngät bä vuk sä qa nämät ka rhoemga bä qop märäs pät a qa masägos. ");
INSERT INTO uro_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nasot dä ama mudäsaqongda rha män ge ma Jisas toqoräkt i sokt ta dä rha snanbät sä qa rhoqortäqyia, “Mäniekt bä qaku mamär vät a ut iva urhi qutmäs iaqäkt ama iauska?” ");
INSERT INTO uro_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Nguna qaku ama mor angän gatnanakt. Ngu qoar na ngän na ama engäktki i qre va angän gatnanakt di ama mor ngät toqor ama mastard aa gavämini di mamär vät a nge iva ngi qoar nä rhärhakt täkt ama damgi i, ‘Ngia rhet narhe bä sarhe!’ Dä va qia rhet toqoräkt bä qop pa qaku a qrot guani gem nge.” ");
INSERT INTO uro_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sa nga ama mudäsaqongda rha män sävät a ne e ma Galili dä ma Jisas ka qoar na rha rhoqortäqyia, “Ma Ruqa aa Emga diva rhi vodäm ga sämät ama ruvek arhä rhäkt ");
INSERT INTO uro_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","bä va rhi veng ga. Näkt pa vät ama dävaung na qa ama qunäga dä va ma Ngämuqa qa rhäranas na qa nämät ama tñäpki.” Dä ama mudäsaqongda di airäs ta masirhat. ");
INSERT INTO uro_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Näkt nga ma Jisas kä na aa mudäsaqongda rha män sae ma Kaperneam dä ama ruvek kärarhani i rhit ta ama takes ba ama ansäspämgi ama mor qi qärangätni i ama qunängiom ama udiom in ditsek angät ligärigleng di sa rha män sage ma Pita bä rhi snanbät sä qa rhoqortäqyia, “Nga gia morqa di qaku qät don na anga ligär bä ba ama ansäspämgi ama mor qi?” ");
INSERT INTO uro_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Dä ma Pita qa muvät pät a rha i, “Ari, nak koki qät don.” Näkt nga ma Pita qa män ba vät dä ma Jisas ka er qa märhamän sävät a qa i qä snanbät sä qa rhoqortäqyia, “Saimon, ngiat tu gi snäng doqor mäniekt? Ama vitnarha nämäni ama ivätki di rhat dräm dit ta ama ligär ngä na ama takes di nage guavek koe? Nga rhit ta ngät nage arha ruvek maräkt ura nage ama nañista?” ");
INSERT INTO uro_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bä nga ma Pita qa muvät i, “Nage ama nañista.” Dä ma Jisas ka qoar i, “Rhoqoräkt di nak kop ama ruvek nae nävä qä vitnarha arha ivärhimek maräkt di isiska vät a rha sa ama takes. ");
INSERT INTO uro_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Sokt di varis ut naslava na rha dä soknga ngia rhet samana sävät a qoan bä va ngi ar sa anga rhinäm bä va nämät ama narhoerqa aa vämgi diva ngi rha ama ligärige qärqigeni i ama levaet na ngät ama qunäng angät titsek nä ige. Dä ngia rhet sä ige bä va ngi vodäm ige bä ba rha iva ama takes bä ba un.” ");
INSERT INTO uro_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Vät iomäkt ama qäväläm dä ma Jisas aa mudäsaqongda rha män sagem ga bä rhi snanbät sä qa rhoqortäqyia, “Auge di ama vit na qa mamär va ama Muräktpäm na rhävuk?” ");
INSERT INTO uro_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dä ma Jisas ka rhäknan da ama rhoemga bä qa mair na qa da arhä saqong. ");
INSERT INTO uro_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Näkt ka qoar na rha rhoqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i ngakt bä qaku ngän nanäpgoer na nas bä ngän dän iva ngän doqor ama rhoes di qop pa qaku ngän namon säva ama Muräktpäm na rhävuk. ");
INSERT INTO uro_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Aung gärakni i qät säm ama gaini na nas bä qa rhän iva qa rhoqor tak täkt ama rhoemga di iaqäkt di ama vit na qa mamär vä iaqäkt na rhävuk aa Muräktpäm. ");
INSERT INTO uro_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Bä aung gärakni i qä rhar sa anga rhoemga rhoqor tak täkt sagem mes nävät gu ngärhipki di sa qä rhar sä ngo. ");
INSERT INTO uro_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Sokt di aung gärakni i qat täqäne sa akni nävät tärhae rhäkt ama rhoes ama gaini na rha qärakni i qat nanakt na ngo bä sämät anga vuini di vadi mai mamär iva rhi er ti qop sa anga märän bäm ga anga duiqa vät aa qän näkt ti rhon na qa säva ama quluñini vä garäska bä va qä näkt märäktki. ");
INSERT INTO uro_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Avuqi na ama ruvek pät ama ivätki qärarhani i rhi rhartäm sa arhani ama ruvek bä sämät ama vuirhong. Qoki qale iangärhäkt ama lat toqoräkt sokt diva avuqi mamär ge auge qärak i qat tualat toqoräkt. ");
INSERT INTO uro_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ngakt bä ngia rhäqyet ura gia qäraet ngärhi rhartäm sä nge sämät anga vuini dä va ngi rhodäkt sä et bä ngi rhon na et nae. Inguna qoki ama mär toqoräkt iva ngia rhon säva ama iar ama sok täm ngät i suktäkt pät a nge. Dap ama vu rhoqoräkt iva ngiat tet nä gia qärisem moe ura qale gia rhäqyisem moe sokt diva rhi rhon na nge sämät ama ivärhäs na ama mudäbäs ama sok tä bäs. ");
INSERT INTO uro_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Dä qosaqi ngakt bä gi saqongaqa qä rhartäm sä nge bä sämät anga vuini dä va ngia rhar täm ga bä ngi rhon na qa nae. Inguna ama mär toqoräkt iva ngia rhon säva ama iar ama sok täm ngät sokt sa ama saqongaqa ama sägäk dap ama vu rhoqoräkt i gi saqongaiom ama udiom sokt diva rhi rhon na nge sämät ama ivärhäs na ama mudäbäs ama sok tä bäs. ");
INSERT INTO uro_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ngänit lu i varis ngän naslava na aung nävät tärhae rhäkt ama rhoes inguna rhävuk da ama usäpki arha ron di arha enselqäna di rhat mair vasägos dä gu mam aa saqong. ");
INSERT INTO uro_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ngu lu ngän du angän snäng doqor mäniekt? Ngakt bä akni anga ruqa di aa anga handret na anga sipsipkäna näkt musäng sa ama sägäk dä mänia? Nga qaku qä namet daqule angätni ama 99 na ngät ama sipsipkäna va ama mran äkt da ama dabap dap pa qa rhet nasot iaqäkt kärak i sa musäng sä qa? ");
INSERT INTO uro_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Bä ngu qoar na ngän na ama engäktki i ngakt bä va qa rhän bät a qa diva märmär gem ga masirhat nävät a qa vä iangärhäkt ama 99 na ngät kärangät i sa qaku musäng sä ngät angät tpäs. ");
INSERT INTO uro_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Bä qosaqi rhoqoräkt di angän mam dak pono da ama usäpki arha ron di qaku nani a qa iva qäbäs na aung nävät tärhae rhäkt ama rhoes. ");
INSERT INTO uro_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ngakt bä akni anga qatnanaktpämga qat tualat na anga vuini sävät a nge dä ngia rhet sagem ga bä va ngia rhuqunäga vät a qa i ngi qur a qa rha aa lat ama vu ngät näkt kaku mänguräp dap sokt en. Näkt ngakt bä qä nari nämät nge dä va saqi as ina ruaiom na ne ngi na qa. ");
INSERT INTO uro_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Sokt di ngakt bä qaku qä nanari nämät nge dä va ngi rhäqoar sa aung ura guaiom bä va ngän det sagem ga ivakt iva gia enge moe di iarhakt di mamär iva rhi sämaengäktki na ngät. ");
INSERT INTO uro_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Näkt ngakt bä qaku qä nanari nämät ta dä va ngän duqunäga vät gi guläñgi na ama qatnanaktpämda. Bä ngakt bä qaku qä nanari nämät ama qatnanaktpämda dä va ngän däqäne sä qa rhoqor qre i anga Jentailqa ura anga ruqa qärakni i qat dräm gät ta ama takes. ");
INSERT INTO uro_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nguat tamän särhäm ngän na ama engäktki i agini qärqäni i ngän dares pät ini angärha rhäng de vät ivät diva ma Ngämuqa qä rhares pät ini angärha rhäng dävuk da ama usäpki arha ron näkt agini qärqäni i qaku ngän dares pät ini angärha rhäng de vät ivät diva qaku ma Ngämuqa qä narhares pät ini angärha rhäng dävuk da ama usäpki arha ron. ");
INSERT INTO uro_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Saqi as ngu qoar na ngän i ngakt bä ama udiom nävät a ngän di sa sägäni na iom bät ama ivätki sävät guani qärqäni i sa in nän nani ini dä va gu mam dak pono da ama usäpki arha ron ga rhualat toqoräkt. ");
INSERT INTO uro_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Inguna nga rhoqoräkt i västämne na anga udiom ura anga dävaung na rha nävät gu ngärhipki di sa qale ngo e gem da.” ");
INSERT INTO uro_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nasot dä ma Pita qa män ge ma Jisas bä qä snanbät sä qa rhoqortäqyia, “Engeska, ngakt bä gua ruaqa qat tualat na ama vuirhong sävät a ngo vasägos dä va ngut kyiradeng na qa sa aa lat ma ama mämänia nä imek? Nga va ngut kyiradeng ba qa ma ama ngärhäqyet da unmem nä imek?” ");
INSERT INTO uro_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Dä ma Jisas ka qoar na qa rhoqortäqyia, “Ngu qoar na nge iva qale ngit kyiradeng ba qa sokt pät ama ngärhäqyet da unmem nä imek dap kinak pa ngit kyiradeng ba qa vät ama dävaung na rha ama ruvek da ama ngärhäqyisem da qäraet da unmem nä imek.” ");
INSERT INTO uro_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Iaqäkt na rhävuk aa Muräktpäm diva ngua rhuqut täm ngät sävät akni ama vitnaqa. Maos dä iaqäkt ama vitnaqa di nani a qa iva qa rhuräkt na aa latta arhä dinau. ");
INSERT INTO uro_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Bä nga qa nasäng iva qat turäkt dä rha män sa akni ama latka qärakni i aa dinau di ama ngärhäqyisem da udiom na ngät ama tausengäna na ama qunäng angät titsek. ");
INSERT INTO uro_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Dap ka latka di qaku aa anga ligär masirhat ivakt iva qa rhuvät na ama vitnaqa aa ligär. Dä soknga ama vitnaqa qa qoar iva rhi vodäm ga qä na aa egutki näkt in oes näkt sävät arhä qärhong iva nani anga ligär bä bä qa vitnaqa. ");
INSERT INTO uro_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Bä äkt i qa latka qa an da aa quum sä nas säng ama vitnaqa aa qar bä qät nok pät a qa sä nas i, ‘Ai, ngi lavuqi na ngo dä va as pa ngua rhuvät nä gi ligär moe.’ ");
INSERT INTO uro_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Dä ama vitnaqa qa lavuqi na qa dä qa qoar na qa i sa isiska vät a qa i sa qaku mamär iva qä namuvät na ama ligär. ");
INSERT INTO uro_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Sokt di mamär dä qa latka qa met bä qa män bät akni aa ruaqa ama latka qärak i sa mudu qa rha ama narhoerqa ama latka aa ligär qärangätni i ama handret na ngät ama qunäng angät titsek näkt as kaku qa muvät na ngät. Bä nga qä narhoerqa qa män bät akni dä qa sangar a qa bä qät täkbrät pät aa qän dap kä qoar na qa i, ‘Qop ngi lir ngia rhuvät nä gu ligär!’ ");
INSERT INTO uro_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Dä sa arpus nä qärak mäk dap kät nok pät a qa i, ‘Ai, ngi lavuqi na ngo dä va as pa ngua rhuvät nä gi ligär.’ ");
INSERT INTO uro_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Qop kä narhoerqa di qa mer dap kinak ka mu qa va ama tpäskiarharhäng ivakt iva qale qa äkt bä dängdäng iva qa rhuvät na aa ligär. ");
INSERT INTO uro_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Nga arhani aa ruavek ama latta rha lu rhoqoräkt dä airäs ta masirhat dä rha met sage ama vitnaqa bä rha sameng ba qa nä iangärhäkt moe ama lat. ");
INSERT INTO uro_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Dä qa vitnaqa qa rhäkne nani qa latka bä qa qoar na qa rhoqortäqyia, ‘Ainge di ama vu qa ama latka na nge. Sa ngua muisiska vät a nge nä iangärhäkt gi dinau moe inguna sa ngia nok pät a ngo. ");
INSERT INTO uro_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Näkt padi mai va qosaqi ngia rhualat sä gia ruaqa rhoqoräkt toqor ngo i sa ngua lavuqi na nge.’ ");
INSERT INTO uro_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Dä qa latka aa morqa di ama uraqi da aa ron dä qa mu qärak pa ama tpäskiarharhäng ivakt iva qale qa äkt bä dängdäng iva qa rhuvät na aa morqa aa ligär moe.” ");
INSERT INTO uro_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Näkt ma Jisas ka qoar i, “Gu mam dak pono da ama usäpki arha ron di qa diva qat tualat sä ngän doqoräkt kre i sa qaku ngit kyiradeng nä gia ruaqa namuk sa aa lat ama vu ngät.” ");
INSERT INTO uro_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sa nga ma Jisas ka märhamän bät tangät täkt ama enge na ama siqut bä rhäksot dä qa met daqule ma Galili bä qa mon säda ama ngärhäktka ma Judia aa ron bä särhage na ama rigi ma Jordan. ");
INSERT INTO uro_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Dä ama mor ngät ama gulañ na ama ruvek ta met nasot a qa bä qa mumäräs pät arha rämgivärharha e. ");
INSERT INTO uro_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Dä arhani ama Farisiqäna rha män gem ga bä rha siqut na qa i rhi snanbät sä qa rhoqortäqyia, “Nga maräkt toqoräkt parhäm ma Ngämuqa aa Muräkt iva akni ama ruqa qä qutmäs aa egutki vät guani angät tpäs?” ");
INSERT INTO uro_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Dä ma Jisas ka muvät toqortäqyia, “Nga sa qaku ngän mes ma Ngämuqa aa enge qärangätni i ngät tamän i mudu vät ama rharimini di sa qa säm ama ruvek i ama gamoe dä ama evop? ");
INSERT INTO uro_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Bä qosaqi ma Ngämuqa qa qoar i, ‘Rhoqoräkt bä va ama gamoeqa qa rhet daqule aa mam dä aa nan bä va västämne na iom gä na aa egutki bä va ama sägäge ama släqyige na iom’? ");
INSERT INTO uro_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Bä äkt i sa qaku as ama udiom na iom dap kinak ama sägäk na iom. Dä soknga qale aung anga ruqa qä namat mät ianiäkt kärqäni i sa ma Ngämuqa qa västämne nä ini.” ");
INSERT INTO uro_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dä rhi snanbät sä qa rhoqortäqyia, “Ngakt bä rhoqoräkt dä mäniekt bä mudu ma Moses kät tares iva ama gamoeqa qä von aa egutki rha anga abuqit na ama bäñmät näkt kä rhäk na qi?” ");
INSERT INTO uro_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Mudu ma Moses ka rhares bä ba ngän iva matmät ama ngärhaegurhini inguna ama qrot angän bäs. Sokt di mudu mänasäng bät ama rharimini di qaku rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Näkt ngu qoar na ngän i aung gärakni i qa qutmäs aa egutki dap sa qaku qia mualat na anga lat na ama qavatka bä qa mät aktni di qä qavatnävätlägut.” ");
INSERT INTO uro_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Dä ma Jisas aa mudäsaqongda rha qoar na qa i, “Di ngakt bä rhoqoräkt mänguräp ama gamoeqa qa na ama evopki di mamär iva qale ama ruvek tat tätlägut.” ");
INSERT INTO uro_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Sokt di ma Jisas ka qoar na rha rhoqortäqyia, “Rhangät täkt gu rhisu di qaku mamär vät ama ruvek moe iva rhat tat maengäkt sä ngät dap ngät di sokt bä bä iarhakt kärarhae i sa ma Ngämuqa qa von da rha ama qrot ivakt iva rhat tat maengäkt sä ngät. ");
INSERT INTO uro_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Inguna arhongni irhong nga e di qaku mamär vät anga ruqa iva qat tätlägut nävät irhong. Arhani di arhä nanäkkina tit säl a rha i qaku mamär na arhä släqyigleng iva rhat tas ti na ama evop dap arhani di ama ruvek ta mualat na arhä släqyigleng doqoräkt dap arhani di qaku rhat tätlägut ivakt iva rhat tualat bä bä iaqäkt na rhävuk aa Muräktpäm. Aung gärakni i mamär vät a qa diva mamär iva qät ta rhangät täkt gu rhisu.” ");
INSERT INTO uro_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nasot dä arhani ama ruvek ta män sa ama rhoes sage ma Jisas ivakt iva qa rhu aa rhäkt pät a rha bä qä nän sävät a rha. Dap ama mudäsaqongda rha mair särha ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Sokt di ma Jisas ka qoar toqortäqyia, “Ngäni rhares pät ama rhoes ama gaini na rha arha rhäng iva rhat tet sagem ngo dap kale ngän dair särhäm da inguna ama Muräktpäm na rhävuk di ngät bä bä iarhakt kärarhae i rha rhoqor tärha rhäkt ama rhoes.” ");
INSERT INTO uro_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Dä ma Jisas ka mu aa rhäkt pät ama rhoes näkt mamär dä qa met. ");
INSERT INTO uro_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Dä nak sa akni ama ruqa qa män ge ma Jisas bä qa snanbät sä qa rhoqortäqyia, “Qamorqa, ngu lu va ngua rhualat na agi a lat anga mär ngät ivakt iva dängdäng dä va bä ba ngo na ama iar ama sok täm ngät?” ");
INSERT INTO uro_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Mäniekt bä ngi snanbät sä ngo nani anga lat kärangätni i ama mär ngät? Sokt ama sägäk ka e qärak i ama mär qa. Ngakt bä nani a nge na ama iar ama sok täm ngät diva ngiat tet parhäm ma Ngämuqa aa Muräkt nage ma Moses.” ");
INSERT INTO uro_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Dä qärak ka snanbät i, “Agi muräkt iangärhäkt?” Dä ma Jisas ka muvät i qä qoar na qa rhoqortäqyia, “Qale ngi veng dä qale ngi qavatnävätlägut dä qale ngi sua dä qale ngi iras na anga engirhong sävät arhani ");
INSERT INTO uro_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","dä ngit kutdrir sävät gi mam dä gi nan dä mamär iva gia snäng bät arhani i rhoqor qre i gia snäng bät a nas.” ");
INSERT INTO uro_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Dä qa evänga qa muvät i qä qoar toqortäqyia, “Rhangät täkt ama muräkt moekt di sa nguat tet parhäm ngät dap saqi as ngut läk nani agini?” ");
INSERT INTO uro_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Dä ma Jisas ka qoar na qa rhoqortäqyia, “Ngakt bä nani a nge iva mamär na nge mamär dä ma Ngämuqa aa saqong diva ngia rhet bä ngi vodä gi qärhong moe bä ngi von ama tläkta dä va ngi rha ama mämägän dävuk. Näkt ngi ang bä ngit päs gua rhäng.” ");
INSERT INTO uro_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Bä nga qärak ka nari rhoqoräkt dä qa met i airäs ka inguna qa di ama qärhong bät a qa masirhat. ");
INSERT INTO uro_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Dä ma Jisas ka qoar na aa mudäsaqongda rhoqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i ama qrot masirhat ge ama qärhongbärharha iva rha rhon säva ama Muräktpäm na rhävuk. ");
INSERT INTO uro_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Saqi as ngu qoar na ngän i ama qrot masirhat ge ama kamel iva qa rhon mät anga liqini va anga släpki qäraktni i rhit kutäm na qi at täväs dap sa ama qrot masirhat mamär ge ama qärhongbärhaqa iva qa rhon sävä ma Ngämuqa aa Muräktpäm.” ");
INSERT INTO uro_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nga ma Jisas aa mudäsaqongda rha nari rhoqoräkt dä qräk mät ta masirhat dä rhi snanbät toqortäqyia, “Ngakt bä nga rhoqoräkt dä ngu lu va sirhäkt auge di mamär vät a qa iva qä rha ama mumaiar?” ");
INSERT INTO uro_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Di nak ma Jisas ka ñäm sävät a rha näkt ka qoar toqortäqyia, “Rhangät täkt ama lat di qaku mamär vät ama ruvek na ngät dap ma Ngämuqa di mamär vät a qa na ama lat moe.” ");
INSERT INTO uro_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Dä ma Pita qa muvät i qä qoar toqortäqyia, “As ngi lu i aiut di sa ut met daqule aut kärhong moe bä ut päs gia rhäng. Bä sirhäkt di nga mamär iva bä ba ut nä guani?” ");
INSERT INTO uro_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Nguat tamän särhäm ngän na ama engäktki iva vät iangärhäkt ama rhodäm gärangät iva iarhongäkt moe di ama iaräs nä irhong gärangät iva ma Ruqa aa Emga qat muqun mät aa vitnaqa aa mämugunäs ama mär äs mamär dä va aingän gärarhae i sa ngänit päs gua rhäng di qosaqi va ngän duqun mät ama vitnarha arhä mämugunimek ama ngärhäqyisem da unmem nä imek. Bä na äkt dä va ngän datnävämne na ama enivirhong ama ngärhäqyisem da udom nä irhong nae ma Israel. ");
INSERT INTO uro_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bä iarhakt moe qärarhae i sa rha met daqule arha vät ura arha matpek ura arha läktpek ura arhä mamäkkäna ura arha nanäkkina ura arhä rhoes ura arha ivätki ivakt iva rhit päs gua rhäng diva rhi rha savit na ama handret nä imek näkt nasot diva bä ba rha na ama iar ama sok täm ngät. ");
INSERT INTO uro_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Sokt di ama rhäqäp na rha qärarhani i rhi rhoer täkt diva dängdäng na rha mamär dä ama rhäqäp na rha qärarhani i dängdäng na rha rhäkt diva rhi rhoer mamär.” ");
INSERT INTO uro_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Iaqäkt na rhävuk aa Muräktpäm di ngät toqor akni ama ruqa qärakni i maos dä qa rhäqasäp ivakt iva qa rhat mä guavek iva rhat tualat pät aa etki na ama wain. ");
INSERT INTO uro_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Sa qa män bät arhani dä rha rhares ba ne qä na rha sa ama ligärige qärqigeni i ama qunäga ama sägäk aa rhitsek pät ama qunäga ama sägäk aa lat dä qa rhäk na rha säva aa etki na ama wain ivakt iva rhat tualat. ");
INSERT INTO uro_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Saqi as mamär vät ama ngärhäqyet da levaet nä irhong dä qa män bät arhani ama ruvek kärarhani i rhat mair mavängam ba ama ivärhäs kärqosni i rhat dräm dit boda ama tmäs e ");
INSERT INTO uro_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","dä qa qoar na rha i, ‘Ngän di qosaqi ngän det sävät gua etki na ama wain ivakt iva ngän dualat bä va ngu sek mä ngän na ama rhitsek ama räkt ngät.’ ");
INSERT INTO uro_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Bä äkt i iarhakt ta met näkt kosaqi qa mualat toqoräkt mäniqunäng näkt kosaqi vät ama däpguarhong säpbängang dä qa mualat toqoräkt. ");
INSERT INTO uro_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Sa qorhäs iva ngärhäqyet nä irhong säpbängang dä saqi qa met säva ama ivärhäs kärqosni i rhit boda ama tmäs e dä qoki as ka lu arhani ama ruvek kärarhani i rhat mair mavängam. Dä qa qoar na rha i, ‘Mäniekt bä ngänit tar sa ama qunäga i nak kop kale ngän mavängam de?’ ");
INSERT INTO uro_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Dä rha qoar na qa i, ‘Qaku aung ga mät a ut iva ut tualat.’ Dä qa qoar na rha i, ‘Ngän det sävät gua etki na ama wain bä qosaqi ngän dualat.’ ");
INSERT INTO uro_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Näkt sa nga bängangäs dä ama etki arha ik ka mes aa latka qärak i qät lu vät ama latta moe bä qa qoar na qa rhoqortäqyia, ‘Ngia rhes ama latta moe bä ngi sek mä rha na arhä rhitsek mänasäng nävät iarhakt kärarhae i rha män nasot bä dängdäng nä qärarhani i rha män narhoer.’ ");
INSERT INTO uro_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Bä nga iarhakt ta män gärarhae i sa rha nasäng na ama lat säpbängang bät ama ngärhäqyet nä irhong di sa asägäk asägäk ka rha ama ligärige. ");
INSERT INTO uro_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","“Bä nga iarhakt kärarhae i mai dä sa rha nasäng iva rhat tualat ta män dä rha mu arhä snäng iva rhi rha anga rhitsek masirhat. Sokt di qosaqi asägäk asägäk sa qa rha ama ligärige. ");
INSERT INTO uro_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bä nga sa rha rha igleng dä rha märhamängus bä ba ama morqa ");
INSERT INTO uro_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","i rhi qoar toqortäqyia, ‘Erhärhae rhäkt kärarhae i ngia mät a rha nasot di nak kop ta mualat pät ama sägäk ama aua dap aiut di ama qunäga qa mäs ut mänasäng mai qre vät duququs sokt di qop ngia sek mä ut na ama rhitsek toqorne, rhi na ut!’ ");
INSERT INTO uro_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Dä qa morqa qa muvät pät akni nävät a rha rhoqortäqyia, ‘Gua ruaqa, qaku ngu slava na nge. Nga mai qaku un dares ba ne sa ama ligärige rhoqoräkt pät ama qunäga aa lat?’ ");
INSERT INTO uro_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ngi rha gi rhitsek bä ngia rhet. Qoki nani a ngo iva ngu von dak täkt ama latka qärak i dängdäng na qa rha ama rhitsek toqor gi rhitsek. ");
INSERT INTO uro_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nga qaku mamär vät a ngo iva ngua rhet parhäm gu snängaqa sä gu qärhong? Ura nga ama vu dä gia ron nävät gua lat ama mär ngät?” ");
INSERT INTO uro_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Dä ma Jisas ka qoar i, “Bä äkt iva iarhakt kärarhae i dängdäng na rha diva rhi rhoer mamär dap kärarhani i rhi rhoer diva dängdäng na rha mamär.” ");
INSERT INTO uro_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Bä nga ma Jisas kat tet tävit iva sae ma Jerusalem dä qa rhäqoar sa ama mudäsaqongda ama ngärhäqyisem da udiom na rha sä nas bä rhat tet dap kat tamän särhäm da rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“As ngäni lu i sa ut tet tävit sae ma Jerusalem bä va ma Ruqa aa Emga diva rhi vodäm ga sämät ama priskäna ama moräs na rha rhi na ama Skraipkäna arhä rhäkt. Bä va rhi rhares pät aa rhäng sämät ama tñäpki. ");
INSERT INTO uro_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Näkt pa rhi vodäm ga ba ama Jentailqäna ivakt iva rhat tuma qa dä rhat täranäs ka näkt ti edämsäs pät a qa mäni ama sämänanamuqa. Näkt pät ama dävaung na qa ama qunäga dä va ma Ngämuqa qa rhäranas na qa nämät ama tñäpki.” ");
INSERT INTO uro_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nasot dä ma Sebedi aa egutki qia män sage ma Jisas sa at tuimiom bä qia an da at kuum säng ma Jisas aa qar bä qi nän ga nani ani. ");
INSERT INTO uro_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Dä ma Jisas ka snanbät sä qi i, “Nani a nge na agiqa?” Dä qi qoar na qa i, “Mamär iva ngi rhares iva mugas pä gi Muräktpäm dä va rhiom däkt ngua imiom in duqun di ak dä gi sael dap ak dä gi märmär.” ");
INSERT INTO uro_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Dä ma Jisas ka muvät pät ma Jems kä nä ma Jon doqortäqyia, “Aien di qaku inät dräm agini ianiäkt kärqäni i ini nän däm ini. Nga mamär vät a en iva ini nakt nämät ama kap na ama märänga qärak iva ngu nakt nämät ka?” Dä in goar na qa rhoqortäqyia, “Mamär vät a un.” ");
INSERT INTO uro_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Dä ma Jisas ka qoar na iom doqortäqyia, “Va ini nakt nämät ama kap kärak iva ngu nakt nämät ka sokt di iomäkt iva aung ga rhuqun dä gu märmär dä aung dä gu sael di qoki qaku mamär iva ngu namuräkt toqoräkt. Iamemäkt ama mämugunimem di qoki bä bä iaiomäkt kärqiom i sa gu mam ga rhäkmu nä imem bä ba iom.” ");
INSERT INTO uro_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bä nga arhani ma Jisas aa mudäsaqongda ama ngärhäqyisem na rha rha nari rhoqoräkt dä rhir qur qärqiomni qa sägiom. ");
INSERT INTO uro_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Sokt di ma Jisas ka mes ama mudäsaqongda moe sagem mes näkt ka qoar na rha rhoqortäqyia, “Sa ngänät dräm i ama Jentailqäna arha tpäskinarha di qoki rhat turäkt täm da masirhat bä arha moräsnarha di rhat sangar a rha na ama muräkt ama qrot ngät daver mä rha. ");
INSERT INTO uro_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Dap kinak mänguräp mä ngän diva qale rhoqoräkt. Dap aung gärakni i nani a qa iva ama moräs na qa mänguräp mä ngän di qoki va qale qa i ama latka na qa va angäna rem ");
INSERT INTO uro_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","bä aung gärakni i nani a qa iva ama narhoer qa mänguräp mä ngän di qoki va qale qa i ama latka na qa va angäna rem. ");
INSERT INTO uro_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Iangärhäkt ama lat di qoki rhoqor ma Ruqa aa Emga qärak i sa qaku qa män ivakt iva ama ruvek tat tualat bä ba qa dap kinak ka män ivakt iva qat tualat ba ama ruvek bä va qä voda aa iar ivakt iva qä rhäksasot ama rhäqäp na rha.” ");
INSERT INTO uro_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Näkt nga ma Jisas kä na aa mudäsaqongda rhat tet nämät ama värhäm ama mor äm ma Jeriko dä ama mor qi ama guläñgi na ama ruvek ta met nasot a qa. ");
INSERT INTO uro_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Dä nak sa aiomni ama säsuriom di inät muqun bät ama iska aa rhäkt bä nga in nari sävät ma Jisas i qat tet e na iom dä init näs toqortäqyia, “Auna morqa, ma Devit aa emga, ngi lavuqi na un!” ");
INSERT INTO uro_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Dä ama guläñgi na ama ruvek ta näs täm iom i rhi qoar na iom iva mänadin däm iom sokt di qop init näs masirhat i, “Auna morqa, ma Devit aa emga, ngi lavuqi na un!” ");
INSERT INTO uro_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Dä ma Jisas ka mair bä qa mes iom sagem mes dä qa snanbät sä iom i, “Nani a en iva ngua rhualat na agiqa bä ba en?” ");
INSERT INTO uro_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Dä in goar na qa i, “Morqa, vadi va unät nañäm.” ");
INSERT INTO uro_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Dä ma Jisas ka lavuqi na iom dä qa rhäk pät in saqong dä qärqiom in ñäm masägos bä in met nasot a qa. ");
INSERT INTO uro_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Bä sa nga ma Jisas kä na aa mudäsaqongda rhat tet bä sa glaqot nä ma Jerusalem dä rha män bät ama värhäm ama lel äm ma Betfage mäni ama damgi ama gaini na qi ama Damgi na ama Olip. Dä ma Jisas ka rhäk na ama mudäsaqongiom ama udiom ");
INSERT INTO uro_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","i qa rhodräp iom doqortäqyia, “In det säp iomäkt ama värhäm gärqomni i äm nga e va in gamäs dä qop äkt dä qoki va in dän bät ama donki qi na at toemga qärqiomni i sa rha qop sä iom dä ini rhäväkt sä iom bä ini ang sä iom sarhe sagem ngo. ");
INSERT INTO uro_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Näkt ngakt bä aung gat tamän sävät a en doqor mäniekt dä va ini qoar i ma Engeska nani a qa na iom näkt pa saqi qä lir qä evär däm iom sagem nge.” ");
INSERT INTO uro_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Rhangät täkt ama lat ngä märanas ivakt iva ngärhi rhäkmamär varhäm ama enge qärangätni i mudu ma Ngämuqa aa vämginaqa qa märhamän bät a ngät toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ngi qoar nä ma Saion at tuimgi i, ‘As ngi lu i gia vitnaqa qat dän sagem ngän! Sa qa säm ama gaini na nas bä qat muqun bät ama donki aa rhäng gärakni i ama donki at toemga.’” ");
INSERT INTO uro_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Dä ama mudäsaqongiom in met bä in mualat parhäm ma Jisas aa enge. ");
INSERT INTO uro_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bä in män sa ama donki qi na at toemga dä in mu in baulem ama uiu em bät ama donki qi na at toemga ina rhäng bä ma Jisas ka muqun bät ama rhoemga aa rhäng. ");
INSERT INTO uro_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ama rhäqäp na rha ama ruvek ti vreng arhä boi ama uiu ngät pät ama iska dap arhani di rhit dodäkt sa ama ngämung angät ngärhäqyitnäk bä rhi aneng itnäk pät ama iska. ");
INSERT INTO uro_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dä ama gulañ na ama ruvek kärarhani i rhi rhoer nanokt ma Jisas dä iarhakt kärarhae i dängdäng na rha di rha moe rhit näs toqortäqyia, “Hosana, ama ansäs sage ma Devit aa emga. Mamär iva ama modämne sävät tak täkt kärak i qat dän nävät ma Engeska ma Ngämuqa aa ngärhipki. Ama ansäs sage ma Ngämuqa rhävuk da ama usäpki arha ron!” ");
INSERT INTO uro_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Bä nga ma Jisas ka mon sae ma Jerusalem dä ama ruvek moe rha märanas masirhat i rhi snanbät i, “Auge rhak täkt?” ");
INSERT INTO uro_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Dä qa gulañ na ama ruvek kärarhani i rhat tet nasot ma Jisas di rha muvät i rhi qoar toqortäqyia, “Ma Ngämuqa aa vämginaqa ma Jisas tak täkt kärak i nae ma Nasaret e ma Galili.” ");
INSERT INTO uro_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Dä ma Jisas ka mon säva ama ansäspämgi ama mor qi arha ivärhäm bä qa qutmäs iarhakt kärarhae i rhit boda arhä qärhong bä sävät kärarhani i rhit bodäm bät arhongni e vä bäm. Bä qa näpgoer nä qärarhani i rhit kutsasorhane na ama ligär arhä lai dä qosaqi qa rhar da ama mämugunimek sä iarhakt kärarhae i rhit boda ama ituap. ");
INSERT INTO uro_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Näkt ka qoar na rha rhoqortäqyia, “Ma Ngämuqa aa enge qärangätni i sa mudu rha säm a ngät di ngät tamän doqortäqyia, ‘Gua vätki diva rhat tes ki i ama vätki na ama nän’ sokt di sa ngän mualat sä qi ma ama suarha arhä qeqi.” ");
INSERT INTO uro_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Dä ama säsurta rhi na ama vävarhämda rha män sagem ga va ama ansäspämgi ama mor qi bä qa mumäräs pät a rha. ");
INSERT INTO uro_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sokt di nga ama priskäna ama moräs na rha rhi na ama Skraipkäna rha lu ma Jisas i qat tualat na ama mär ngät ama lat mamär dä qosaqi rha lu ama rhoes i rhit näs i, “Ama ansäs sage ma Devit aa emga” vuk pa ama ansäspämgi ama mor qi dä rhir qur ");
INSERT INTO uro_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","bä rha snanbät sä ma Jisas toqortäqyia, “Nak nga ngiat nari ama rhoes arha enge?” Dä ma Jisas ka qoar na rha i, “Ari, nguat nari rha dä nga sa qaku ngän des ma Ngämuqa aa enge qärangätni i ngät tamän doqortäqyia, “‘Sa ngia mualat iva ama ansäs ngät dän sagem nge nämät ama rhoes dä nämät ama qokoqirhong angärha väm’?” ");
INSERT INTO uro_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Näkt ka met daqule rha bä vuk sä qa nae ma Jerusalem bä sae ma Betani bä qa mas e. ");
INSERT INTO uro_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Näkt pät duququs i nga saqi as evär dä ma Jisas iva sae ma Jerusalem dä qa nari i anoeng mä qa. ");
INSERT INTO uro_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Dä qa lu ama gosaqi mäni ama iska dä qa met sae dä qop kaku qa män bät guani vät at täqän dap sokt ama ngärhäqyitnäk. Dä soknga qa qoar na qi rhoqortäqyia, “Mamär iva saqi as mirhup kaku ngi natsa anga gavam.” Dä qek dä qärakt masägos. ");
INSERT INTO uro_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bä nga ama mudäsaqongda rha lu rhoqoräkt dä qräk mät ta i rhi qoar i, “Ngu lu rhoqor mäniekt bä qek da ama gosaqi masägos?” ");
INSERT INTO uro_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i ngakt bä ngiat nanakt maengäktki dap kaku gi nga snängaiom ama udiom diva mamär iva ngiat tualat toqor ngo sa ama gosaqi bä va qosaqi mamär iva qäqi ngi qoar nä rhärhakt täkt ama damgi iva qia rhäranas bä säva ama garäska dä mamär iva qoki rhäkmamär toqoräkt.” ");
INSERT INTO uro_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Näkt kre va ngäni nän ma Ngämuqa nani guani näkt sa ngänät nanakt diva qä von ngän däm ini. ");
INSERT INTO uro_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nasot dä ma Jisas ka mon säva ama ansäspämgi ama mor qi bä nga rhoqoräkt i qä su ama ruvek dä ama priskäna ama moräs na rha rhi na ama ruvek arha morta rha män sagem ga bä rhi snanbät sä qa rhoqortäqyia, “Ngiat tualat toqor täkt di na ama qrot nage auge? Sa auge qa von nge rhä rhangät täkt ama qrot?” ");
INSERT INTO uro_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Va qosaqi ngu snanbät sä ngän na ama sägängät ama snanbät näkt ngakt bä ngäni qoar na ngo na ama muvätki diva sirhäkt ngu qoar na ngän i sa auge qa von ngo rha ama qrot iva nguat tualat nä rhärhong däkt. ");
INSERT INTO uro_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ma Jon gä baptais pät ama ruvek di iangärhäkt di nga ngät na rhävuk ura ngät nage ama ruvek?” Dä rhat tamän särhäm ne sä iangärhäkt aa snanbät dä rhi qoar na ne rhoqortäqyia, “Ngakt bä urhi qoar i, ‘ngät di ngät na rhävuk’ dä sirhäkt pa qä snanbät sä ut toqortäqyia, ‘Bä ngakt bä rhoqoräkt dä mäniekt bä qaku ngän mat maengäkt nämät ka?’ ");
INSERT INTO uro_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Dap ngakt bä urhi qoar i ‘ngät di ngät nage ama ruvek’ diva urhit len ama ruvek inguna rha di rhat lu ma Jon i akni ma Ngämuqa aa vämginaqa na qa.” ");
INSERT INTO uro_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Bä äkt i sa rha muvät pät ma Jisas toqortäqyia, “Qaku ut dräm.” Dä ma Jisas ka qoar na rha rhoqortäqyia, “Dä qosaqi ngo diva qaku ngu naqoar na ngän i nguat tualat nävät auge aa qrot. ");
INSERT INTO uro_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ngu lu ngän du angän snäng doqor mäniekt sävät tangät täkt? Maos dä qale akni ama ruqa qärakni i aa imiom ama udiom. Näkt ka met bä sage aa emga ama narhoer qa dä qa qoar na qa rhoqortäqyia, ‘Ngua emga, rhäqyerhäkt diva ngia rhet bä ngia rhualat pät ama etki na ama wain.’ ");
INSERT INTO uro_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Dä qärak ka qoar i, ‘Va qaku ngu namualat toqoräkt.’ Näkt saqi mamär dä qa näpgoer na aa snängaqa bä qa met kat tualat. ");
INSERT INTO uro_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Näkt ama ngätmamäk ka met sage akni aa emga bä qosaqi qa qoar na qa iva qa rhet sävät ama etki na ama wain ivakt iva qat tualat. Dä qärak ka muvät i, ‘Gua morqa, sa nguat tet.’ Näkt mamär dä qop kaku qa met. ");
INSERT INTO uro_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ngu lu auge nävät a iom di qa met parhäm aa mamäk aa snängaqa?” Dä rha muvät i, “Iaqäkt kärak i ama narhoer qa.” Dä ma Jisas ka qoar na rha rhoqortäqyia, “Ngu qoar na ngän na ama engäktki iva ama ruvek kärarhani i rhit ta ama takes näkt ama qavat ta ama evop diva rhi er ta rhon säp ma Ngämuqa aa Muräktpäm as pa angän gamäs. ");
INSERT INTO uro_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Inguna ma Jon ama Baptais di qa män bä qär qur a ngän da ama iska na ama räkt ngät ama lat näkt kop kaku ngän mat maengäkt. Dap kinak ama ruvek kärarhani i rhit ta ama takes ti na ama qavat ta ama evop ta mat maengäkt nämät ka. Bä nga qäqi ngänät lu rhoqoräkt di nak kaku ngän nanäpgoer na angän snängaqa bä ngän mat maengäkt sa aa enge. ");
INSERT INTO uro_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“As ngäni nari angätni ama enge na ama siqutki. Maos dä qale akni ama ivätki arha ik kärakni i qa qutnanokt ama qauligleng bät aa etki qärqiglengni i rhat tes igleng i ama wain. Näkt ka mualat na ama surqa namet igleng dä qosaqi qa nges ama uqupka ama mor qa nanokt ama qauligleng angät gavam iva rhit täkbrät ngät e. Näkt kosaqi qa rhäk pät ama näski ama uiu qi ivakt iva ama latta rhat narhäksärha ama etki näda at täväs. Qa mualat toqoräkt näkt ka von arhani ama latta rha aa lat iva rhat tualat na ngät bä ba qa iva nasot dä va rha rhatmät na ama qauligleng angät gavam iva angätni bä ba ama latta dap pa angätni bä ba qa. Näkt ka met sävät aosni ama ivärhäs. ");
INSERT INTO uro_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Bä sa nga sräp ama etki dä qä ngärhik ka rhäk na arhani aa latta sage ama latta qärarhani i rhit lu vät ama etki ivakt iva rhi rha aa qäväläm na ama gavam. ");
INSERT INTO uro_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Sokt di sa rha sangar ama latta qärarhani i sa rha män bä rha arhäktgyäm sa akni dap ta veng akni dap ta rhumät na akni na ama dui. ");
INSERT INTO uro_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Saqi as mamär dä qä ngärhik ka rhäk na arhani aa latta ama rhäqäp na rha samuk sävät ama etki dä qosaqi ama latta nävät ama etki rha mäqäne sä rha rhoqor iarhakt kärarhae narhoer. ");
INSERT INTO uro_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Dä sa dängdäng dä qä ngärhik ka rhäk na aa emga sagem da i qat tu aa snäng i, ‘Iarhakt diva rhi qutdrir vät ngua emga.’ ");
INSERT INTO uro_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Qinak nga iarhakt ta lu ama etki arha ik aa emga inavuk dä rha qoar na ne rhoqortäqyia, ‘Rhak täkt di iaqäkt kärak iva qä rha ama etki nasot aa mamäk. Ngäni ang bä urhi veng ga dä va ba ut na ama etki.’ ");
INSERT INTO uro_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dä rha sangar a qa näkt ta rhon na qa sä dalek na ama etki bä rha veng ga. ");
INSERT INTO uro_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Rhoqoräkt dä ngu lu va ama etki arha ik di qre va qa rhän dä va qa mäsana nä iarhakt ama latta qärarhae i mudu qa mat ma rha sävät aa etki?” ");
INSERT INTO uro_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Dä ama priskäna ama moräs na rha rhi na ama ruvek arha morta rha muvät pät ma Jisas toqortäqyia, “Qoki va qä sangäm nä iarhakt ama latta ama vu rha mamär i qä veng da dap pa qa rhat mä guavek kärarhani iva nga sräp ama etki dä va rha diva rhit bon ga rha aa qäväläm na ama gavam.” ");
INSERT INTO uro_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Näkt ma Jisas ka qoar na rha rhoqortäqyia, “Nga sa qaku ngän mes ma Ngämuqa aa enge qärangätni i ngät tamän doqortäqyia, “‘Ama duiqa qärak i mudu iarhakt kärarhae i rhat dräm dit täk pät ama vät ta mer mä qa di nak kärak iaqäkt i rhäkt di ama qrot ama vätki nagem ga qärak i qat sangar a qi moe. Qoki ma Ngämuqa qa mualat toqoräkt bä ut lu i iangärhäkt aa lat di ama mär ngät mamär da aut saqong’? ");
INSERT INTO uro_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Dä soknga nguat tamän särhäm ngän iva ma Ngämuqa qä rha aa Muräktpäm daqule ngän bä va qä von ama ruvek täm ngät kärarhani i rhat tualat parhäm aa snängaqa. ");
INSERT INTO uro_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Bä auge qärak i arpus na qa vät tak täkt ama duiqa aa rhäng diva bäktgyäm sä qa mä irhong mä irhong dap ngakt bä arpus nä rhak täkt ama duiqa vät aung aa rhäng diva värhot täm ga mamär.” ");
INSERT INTO uro_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bä nga ama priskäna ama moräs na rha rhi na ama Farisiqäna rha nari ma Jisas aa enge na ama siqut dä rha räm i sa qat tamän sävät a rha. ");
INSERT INTO uro_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bä näma dä sa nani a rha iva rhi sangar a qa sokt di rhit len ama gulañ na ama ruvek inguna rha di rhat lu ma Jisas i akni ma Ngämuqa aa vämginaqa na qa. ");
INSERT INTO uro_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","As ma Jisas kat tamän särha ama priskäna ama moräs na rha rhi na ama Farisiqäna na ama enge na ama siqut i qä qoar toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Iaqäkt na rhävuk aa Muräktpäm di ngät toqor ama vitnaqa qärakni i qa rhäkmu na ama tmäski bä ba aa emga qärak iva rhit bodäm na qa. ");
INSERT INTO uro_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Näkt ka rhäk na aa latta nani iarhakt kärarhae i sa qa ar sä rha säp iaqyäkt ama tmäski. Dä qop kaku rha män. ");
INSERT INTO uro_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Dä saqi as ka rhäk na arhani aa latta sa ama enge sage iarhakt kärarhae i sa qa rhäkne nani a rha rhoqortäqyia, ‘Sa ngua rhäkmu nä gua tmäski. Sa ngua veng gu bulmakaoqäna ama gamoe näkt sävät ama enges ap ama bulmakao aa ebap bä sa maräkt nä iarhongäkt moe. Mamär iva ngäni ang säva ama tmäski.’ ");
INSERT INTO uro_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Sokt di qop kärarhani qaku rha saengäkt sae dap koki varhäm da na nas. Akni qa met sävät aa lat dap ak ka met kät bon da aa qärhong nani ligär. ");
INSERT INTO uro_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Dap arhani rha moe rha sangar qärak aa latta bä rha slava na rha bä rha veng da. ");
INSERT INTO uro_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Dä soknga qa vitnaqa di qär qur masirhat bä qa rhäk na aa ulaqimärharhärhäkt bä samuk sävät kärarhae bä rha veng da näkt ta väs iomäkt arha värhäm. ");
INSERT INTO uro_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nasot dä qa mes aa latta bä qa qoar na rha rhoqortäqyia, ‘Sa ngua rhäkmu nä gua tmäski bä sa maräkt na qi sokt di iarhakt kärarhae i sa ngua ar sä rha di qaku ama mär ta na rha iva rha rhän säp gua tmäski. ");
INSERT INTO uro_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Bä äkt i rhäkt diva ngän det säda ama is angärha väm bä ngäni rhäknan dä guavek masirhat kärarhani i ngän dän bät a rha säp gua tmäski.’ ");
INSERT INTO uro_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Dä qa latta rha met säda ama is angärha väm bä rha rhäknan da ama ruvek moe iarhakt kärarhae i rha män bät a rha qärarhani i ama mär ta dä qosaqi qärarhani i ama vu rha na rha bä sa rhäqäp iaqyäkt ama vätki qäraktni iva ama tmäski väm gi. ");
INSERT INTO uro_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Sokt di nga qa vitnaqa qa mon ivakt iva qä lu qa ruvek dä qa lu akni ama ruqa qärak i sa qaku qa mon mät anga boi qärangätni i ama rhäkmamär ngät sävät iaqyäkt ama tmäski. ");
INSERT INTO uro_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Dä ama vitnaqa qa snanbät sä qa ruqa i, ‘Gua ruaqa, ngia mon doqor mäniekt sarhe dap kaku ngia mon mät ama boi ama rhäkmamär ngät?’ Dä qop mänadin dä qärak. ");
INSERT INTO uro_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Dä ama vitnaqa qa qoar na aa latta rhoqortäqyia, ‘Ngäni qop mät aa rhäkt ngä na aa qar näkt ngäni rhon na qa sainamäk sä dalek säp bängangit angät tpäs. Vät iosäkt ama ivärhäs diva rhat tuqaia dä va rhit nes arhä qeng angärha rem na ne.’ ");
INSERT INTO uro_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Inguna ma Ngämuqa di sa qä rhar sa ama rhäqäp na rha ama ruvek sagem mes sokt di qop ama marheka na rha di sa qä rharmeng däm da iva qale rha e gem ga.” ");
INSERT INTO uro_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nasot dä ama Farisiqäna rha met bä rhi qoar na ne iva rha rhäqäne sä ma Jisas toqor mäniekt iva qä rhärhäp särhäm mes na aa enge. ");
INSERT INTO uro_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Näkt ta rhäk na arhä mudäsaqongda näkt sävät arhani ma Herot aa ruvek sage ma Jisas bä rhat tamän särhäm ga rhoqortäqyia, “Qamorqa, sa ut dräm i ngiat tamän bät ama engäktki bä ngi su na ama engäktki sävät ma Ngämuqa aa snängaqa ba ama ruvek. Bä qaku qänäskänes nge sävät ama ruvek arhä snängaqa dap kosaqi ama ruvek arhä mämairimek di qaku imek ngä narut na nge. ");
INSERT INTO uro_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mamär iva ngi qoar na ut i ngiat tu gi snäng doqor mäniekt sä rhangät täkt. Nga maräkt parhäm ama Muräkt iva urhit bon ma Sisar ta ama takes ura qaku?” ");
INSERT INTO uro_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Sokt di ma Jisas di qat dräm arhä snängaqa ama vu qa i nani a rha iva rhi siqut na qa bä äkt i qa qoar na rha rhoqortäqyia, “Aingän gärarhae i ngän dualat sädä saqong, mäniekt bä ngäni siqut na ngo? ");
INSERT INTO uro_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ngäni qur a ngo rha anga ligärige qärqigeni i sa ngänät dräm ngänit bon däm ige vät ama takes.” Dä rha met sagem ga sa ama qunäga ama sägäk aa rhitsek angät ligärige. ");
INSERT INTO uro_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Dä qa snanbät sä rha i, “Auge aa iauski rhakt täkt päm ige? Dä auge aa sämsäm dangät täkt päm ige?” ");
INSERT INTO uro_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Dä rha muvät i, “Ma Sisar.” Dä ma Jisas ka qoar na rha rhoqortäqyia, “Dä soknga ngäni von ma Sisar tä iarhongäkt kärqärhong i qoki ma Sisar aa qärhong dap pa ngäni von ma Ngämuqa rhä iarhongäkt kärqärhong i qoki ma Ngämuqa aa qärhong.” ");
INSERT INTO uro_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bä nga rha nari rhoqor täkt dä qräk mät ta nävät a qa näkt ta met daqule qa bä rha met. ");
INSERT INTO uro_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mamär vät iaqäkt ama qunäga dä arhani ama Sadyusiqäna qärarhani i qaku rhat nanakt i saqi as pa ama ruvek ta rhäranas nämät ama tñäpki rha män ge ma Jisas bä rha snanbät sä qa rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Qamorqa, ma Moses ka qoar i ngakt bä sa akni anga ruqa qa ñäp dap kaku aa anga es dä mamär iva aa läktka qa rhät iaqyäkt ama maqoski ivakt iva qä sa vät a qi bä ba aa matka. ");
INSERT INTO uro_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Bä mänguräp mä ut di ama sägärhae ama ngärhäqyet da udiom na rha ama gamoe. Näkt ama narhoerqa qa mät ama evopki dä qa ñäp dap nguna sa qaku aa anga es dä aa egutki qia män i aa läktka ama udiom na qa aa egutki na qi. ");
INSERT INTO uro_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Dä qosaqi ama lat toqoräkt ngä märanas bät ama udiomnaqa näkt kosaqi vät ama dävaungnaqa bä äkt bä sävät ama ngärhäqyet da udiom na qa ama ruqa. ");
INSERT INTO uro_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Näkt nasot a rha dä sa qa evopki qia ñäp. ");
INSERT INTO uro_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Dä soknga va auge aa egutki na qi mirhup pät ama qäväläm gärqomni iva ama ruvek ta rhäranas nämät ama tñäpki? Inguna rha moe di sa rha mät a qi.” ");
INSERT INTO uro_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Dä qinak ma Jisas ka muvät pät a rha rhoqortäqyia, “Qaku maräkt na angän snängaqa inguna sa qaku ngänät dräm ma Ngämuqa aa enge näkt kosaqi qaku qunäga vät a ngän sa aa qrot. ");
INSERT INTO uro_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Inguna nasot ama qäväläm gärqomni iva rha rhäranas nämät ama tñäpki diva qaku ama ruvek ti namätlägut bä qosaqi va qaku ama ruvek ti navon da arhani ama ruvek sämät ama ngärhaegurhini dap kinak ta diva rha rhoqor ama enselqäna na rhävuk da ama usäpki arha ron. ");
INSERT INTO uro_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Dap sävät ama ruvek ama ñäp ta qärarhani i rhat täranas nämät ama tñäpki di sa nga qaku ngän mes ma Ngämuqa aa enge bä ba ngän gärangätni i ngät tamän doqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Aingo di ma Abraham gä nä ma Aisak dä ma Jekop arhä Ngämuqa’? Ma Ngämuqa di qaku ama ñäpta arhä Ngämuqa dap kinak ka di ama ngätdäqämda arhä Ngämuqa.” ");
INSERT INTO uro_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Bä nga ama guläñgi na ama ruvek ta nari rhoqoräkt dä qräk mät ta nävät aa rhisu. ");
INSERT INTO uro_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sokt di nga ama Farisiqäna rha nari i sa ma Jisas ka anmae vät ama Sadyusiqäna sa arha enge dä västämne na rha bä rha met sagem ga. ");
INSERT INTO uro_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Dä akni nävät a rha qärak i ama mädräm ga mamär sä ma Ngämuqa aa Muräkt nage ma Moses ka snanbät sä ma Jisas na ama snanbät ivakt iva qä siqut na qa rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Qamorqa, ngu lu agi muräkt di ama moräs na ngät mamär nävät ma Ngämuqa aa Muräkt moe?” ");
INSERT INTO uro_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Mamär iva gia snäng bät ma Engeska gi Ngämuqa nä gi snängaqa moe dä nä gi mungäsnäng moe näkt nä gi mädräm moe. ");
INSERT INTO uro_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Rhangät täkt di ama moräs na ngät mamär dä ama narhoer ngät ama muräkt. ");
INSERT INTO uro_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Dä ama unmem na ngät ama muräkt di ngät toqor ama narhoer ngät toqortäqyia, mamär iva gia snäng bät arhani i rhoqor qre i gia snäng bät a nas. ");
INSERT INTO uro_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bä rhangät täkt ama unmem na ngät ama muräkt di ama rharebäm na ngät kärangätni i sa ama muräkt moe dä ama vämginarha arha enge moe di ngät mair vät angärha rhäng.” ");
INSERT INTO uro_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Bä nga as pästämne na ama Farisiqäna dä ma Jisas ka snanbät sä rha na ama snanbät toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ngu lu ngän du angän snäng sävät ma Krais toqor mäniekt? Qa di auge aa emga na qa?” Dä rha muvät pät a qa rhoqortäqyia, “Ma Devit aa emga na qa.” ");
INSERT INTO uro_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Dä qa muvät i qä snanbät sä rha rhoqortäqyia, “Va sirhäkt ngu lu mäniekt bä nga ama Qloqaqa qa märanas nä ma Devit dä ma Devit ka mes ma Krais i aa Engeska na qa i qä qoar toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Ma Engeska ma Ngämuqa qa qoar nä gua Engeska i, “Ngia rhuqun dä gu märmär bä dängdäng iva ngun but sä gia ikkäna säp gia rem” ’? ");
INSERT INTO uro_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ngakt bä ma Devit kat tes ma Krais i ma Engeska dä sirhäkt ngu lu ma Krais di ma Devit aa emga na qa rhoqor mäniekt?” ");
INSERT INTO uro_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Näkt kaku mamär vät aung iva qa rhuvät pät a qa na anga enge. Bä qosaqi mänasäng nävät iaqäkt ama qunäga inamäk dä qaku aung ga siqut iva qä snanbät sä ma Jisas na agung anga snanbät inguna rha moe di sa rhit len. ");
INSERT INTO uro_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Dä ma Jisas ka qoar na ama gulañ na ama ruvek dä aa mudäsaqongda rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ama Skraipkäna rhi na ama Farisiqäna di rhat muqun bä ma Moses aa mämugunäs i rhat mair nävät aa qrot ");
INSERT INTO uro_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","dä soknga mamär iva ngän dualat parhäm ama enge moe qärangätni i rhat tamän särhäm ngän na ngät. Sokt diva qale ngän natmualat toqor ta inguna qaku rhat tualat parhäm gärangätni ama enge i rhat tamän bät a ngät. ");
INSERT INTO uro_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","“Rhat dräm dit kop sa ama talap ama märän bä bap da ama ruvek arha lang gärqapni i qaku märmärsäs iva rhit tal ap. Dap ta maräkt di qaku nani a rha iva rhi natmualat nä guarhong ivakt iva rhat tatnärhäm da. ");
INSERT INTO uro_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Qärangätni moe arha lat di rhat tualat na ngät ivakt iva ama ruvek tat lu rha. Rhat tualat na ama rhängämitnäk kärqitnäkni i sa rhit kop itnäk sä ma Ngämuqa aa enge mäni arhä rhäkt dä mäni arhä väs kärqitnäk i ama ara itnäk masirhat dä ama ses da arhä boi ama uiu ngät angärha väm di rhit sämauiu na ngät. ");
INSERT INTO uro_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bä qosaqi nani a rha na ama mämugunimek ama vit nä imek pa ama tmäsimek bä va rhat tuqun bät ama lai vuk dä ngärhaväm ba ama mämairväm ");
INSERT INTO uro_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","näkt pa ama ruvek ti rhar sä rha na ama qutdrir vät ama ivärhimek kärqämekni i ama ruvek tit boda arha tmäs e dä nani a rha iva ama ruvek tat tes ta i, ‘Qamorqa.’ ");
INSERT INTO uro_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Dap kinak aingän diva qale aung gä natmes aung nävät a ngän i, ‘Qamorqa’ inguna angäna morqa ama sägäk kärak i sa qa rhoqoräkt dap angäna matpek dä angäna läktpek na ne. ");
INSERT INTO uro_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Dä qale ngän natmes aung narhe nävät ivät i, ‘Gu mam’ inguna sokt angän mamäk ama sägäk iaqäkt kärak i rhak pono da ama usäpki arha ron. ");
INSERT INTO uro_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bä va qale aung gä natmes aung nävät a ngän i, ‘Qamorqa sa ama rhodräp’ inguna sokt angän gamorqa ama sägäk sa ama rhodräp iaqäkt kärak i ma Krais. ");
INSERT INTO uro_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Auge nävät a ngän gärakni i ama moräs na qa mamär mänguräp mä ngän di mamär iva ama latka na qa bä ba ngän moe. ");
INSERT INTO uro_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aung gärakni i qät sämamor na nas diva rhi säm ama gaini na qa dap iaqäkt kärak i qät säm ama gaini na nas diva rhi sämamor na qa. ");
INSERT INTO uro_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Va avuqi na ngän mamär, aingän ama Skraipkäna ngän na ama Farisiqäna aingän gärarhae i ngän dualat sädä saqong, inguna sa ngänit päs mät ama tmongi säva ama Muräktpäm na rhävuk nämät ama ruvek. Aingän di qaku ngän namon bä qosaqi qaku ngänit tares pät iarhakt arha rhäng iva rha rhon gärarhae i nani a rha iva rha rhon. ");
INSERT INTO uro_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Va avuqi na ngän mamär, aingän ama Skraipkäna ngän na ama Farisiqäna, aingän gärarhae i ngän dualat sädä saqong, inguna sa ngän det sa gläius dä garäs angärha ron bä vät ama ivätki ivakt iva ngän däqäne dä mamär na anga ruqa sämäni nas näkt nga sa ngän mäqäne dä mamär na qa dä va ngän dualat sä qa iva ama vuqa na qa masirhat pa angän bäs kärakni iva qa sämät ama mudäbäs ama sok tä bäs toqor ngän. ");
INSERT INTO uro_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Va avuqi na ngän mamär, aingän ama säsur ta ama narhoerta. Aingän di sa ngäni qoar i qre va sävetka qat tusärhämes mäni ama ansäspämgi ama mor qi di nak kop kaku ama musärhäm iangärhäkt dap ngakt bä qat tusärhämes mäni ama gol vuk pa ama ansäspämgi ama mor qi di ama qrot ngät ama musärhäm iangärhäkt. ");
INSERT INTO uro_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ama säsur ta dä ama dädända na ngän! Inguna ngu lu agiqa qa vit? Nga ama gol ngä vit ura ama ansäspämgi ama mor qi qia vit käraktni i qiat tualat na ama gol iva ama qumärqumär ngät? ");
INSERT INTO uro_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Bä qosaqi ngäni qoar i qre va sävetka qat tusärhämes mäni ama laiqa na ama vodämes di nak kop kaku ama musärhäm iangärhäkt dap ngakt bä qat tusärhämes mäni ama vänbon bono vät ama laiqa na ama vodämes aa rhäng di ama qrot ngät ama musärhäm iangärhäkt. ");
INSERT INTO uro_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ama säsur ta ama gamoe na ngän! Inguna ngu lu agiqa qa vit? Nga ama vänbon ngä vit ura ama laiqa na ama vodämes ka vit kärakni i qat tualat na ama vänbon iva ama qumärqumär ngät? ");
INSERT INTO uro_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bä äkt i qre va sävetka qat tusärhämes mäni ama laiqa na ama vodämes di qat tusärhämes mäni qa qä nä iarhongäkt moe vät aa rhäng. ");
INSERT INTO uro_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Näkt kre va sävetka qat tusärhämes mäni ama ansäspämgi ama mor qi di qat tusärhämes mäni qi qi nä ma Ngämuqa qärak i aa vätki iaqyäkt. ");
INSERT INTO uro_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Dap kre va sävetka qat tusärhämes mäni ama usäpki di qat tusärhämes mäni ma Ngämuqa aa mämugunäs ngä nä qärak i qat muqun mät a äs. ");
INSERT INTO uro_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Va avuqi na ngän mamär aingän ama Skraipkäna ngän na ama Farisiqäna aingän gärarhae i ngän dualat sädä saqong, inguna sa ngänit bon ma Ngämuqa rha ama sägäk näda ama ngärhäqyisem nävät iarhongäkt moe qärqärhong i ngän du irhong bät ama tmäs toqor ama mint ngä na ama dil dä ama kumin dap kaku ngän däqäne dä mamär varhäm ama lat kärangätni i ama moräs na ngät. Iangärhäkt ama moräs na ngät ama lat di ama räkt ngät ama muräkt sävät ama ruvek dä ama lavuqi sävät ama ruvek näkt pa mamär iva qale ngän ma ama qrot mäni ama lat ama mär ngät. Mai mamär iva ngän däqäne dä mamär varhäm därhong däkt moe dap kale ngän detdäm särhä guarhong. ");
INSERT INTO uro_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Aingän di ama säsur ta ama narhoerta na ngän! Ngänit tor na ama rigi va ama bauläm iva ngit nakt i varis ngi nanakt sa anga igrongaqa dap ngit koanäkt ama kamel dap kaku ngiat dräm doqoräkt. ");
INSERT INTO uro_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Va avuqi na ngän mamär aingän ama Skraipkäna ngän na ama Farisiqäna aingän gärarhae i ngän dualat sädä saqong, inguna sa ngäni qumär vät ama kapkäna dä ama pletkäna angärha rhäng dap imuk da angäna ron di rhäqäp ngän na ama snängaqa nani ama qärhong masirhat iva bä ba nas dä ama mungäsnäng ba nas. ");
INSERT INTO uro_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ainge ama Farisiqa qärak i ama säsur qa na nge! As ngia er ngi qumär imuk da ama kap kä na ama pletige ina ron ivakt iva sa ama qumärqumär ngät pono. ");
INSERT INTO uro_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Va avuqi na ngän mamär aingän ama Skraipkäna ngän na ama Farisiqäna aingän gärarhae i ngän dualat sädä saqong, inguna ngän di nak ngän doqor ama ñäpta arha lek kärangätni i sa rha vurvur da angärha väm na ama qulumgi bä qoki sa ama mär vono dap imuk di sa rhäqäp ngät na ama ñäpta arha släväs dä iarhongäkt moe qärqärhong i ama siqirqa väm irhong. ");
INSERT INTO uro_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Di ngän doqoräkt ivono vät ngärharhäng di ama mär ngän da ama ruvek arhä saqong dap imuk da angäna ron di rhäqäp ngän nage ama irasirhong dä ama lat kärangätni i qaku varhäm ama Muräkt. ");
INSERT INTO uro_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Va avuqi na ngän mamär aingän ama Skraipkäna ngän na ama Farisiqäna aingän gärarhae i ngän dualat sädä saqong, inguna sa ngänit täkmu na ama lek iva nani ma Ngämuqa aa vämginarha näkt ngän du rha ama räktta arha an ");
INSERT INTO uro_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","näkt ngäni qoar i vadi mudu qale ngän bät iangärhäkt imäk äkt ama rhodäm i angäna ikkäna di qaku ngän namatnärhäm da iva rhi veng ma Ngämuqa aa vämginarha. ");
INSERT INTO uro_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bä ngäni sameng mamär irhäm mes toqoräkt i nak iarhakt kärarhae i rha veng ama vämginarha di nak arhä rhoes na ngän. ");
INSERT INTO uro_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Bä qoki mamär iva ngän dualat nasot angäna ikkäna i ngäni sot na ama lat kärangätni i sa rha nasäng na ngät. ");
INSERT INTO uro_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Aingän gärarhae i ama guläñgi na ama uiuvärhirhong gärqärhongni i irhong ngärhit kut na ama qänogi, va ngäni ingis toqor mäniekt nä ma Ngämuqa aa matnävämne dä nasot dä va qä rhon na ngän sämät ama mudäbäs ama sok tä bäs? ");
INSERT INTO uro_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Dä soknga ngut täk nä ma Ngämuqa aa vämginarha sagem ngän näkt sävät ama mädräm da ama ruvek näkt ama ruvek kärarhani i rhat dräm di su ama ruvek tä ma Ngämuqa aa iska bä va ngäni veng arhani dap pa ngäni edämsäs pät arhani mäni ama sämänanamuqa dap pa ngän däranäs arhani va angän mämairväm dap pa ngäni sangäm na arhani mavängam nämät ama värhap i nämät aom bä sämät aom. ");
INSERT INTO uro_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Rhoqoräkt divakt iva ma Ngämuqa aa rhäksärhäm ngä rhän bät a ngän bät ama räkt ta ama ruvek moe arhä biaska aa uväs kärarhae i mudu sokot na rha mänasäng nävät ama räkt ka ma Abel bä sävät ma Sekaraia ma Berekia aa emga qärak i sa ngän beng ga mänguräp ama ansäspämgi ama mor qi qi na ama laiqa na ama vodämes. ");
INSERT INTO uro_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ngu qoar na ngän na ama engäktki iva rhärhong däkt moe ngä rhäranas pät tit täkt ama qoengait na ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ai, Jerusalem, Jerusalem, ama värhäm gärqomni i ngiat dräm ngi veng ma Ngämuqa aa vämginarha dap ngit tumät nä ma Ngämuqa aa engevärharha na ama dui bä rhit ñäp. Ama rhäqäp nä imek di sa nani a ngo iva ngu imum gia ruvek sävät a ne i ngo rhoqor ama duraktki qäraktni i qi imum at toes säva at kivaet angärha rem dä qaku inguna qaku nani a nge. ");
INSERT INTO uro_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","As ngi lu i gia vätki di ama dungdu gi. ");
INSERT INTO uro_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Inguna sa ngu qoar na nge i saqi as pa qaku ngi nalu ngo bä dängdäng bät iomäkt ama qäväläm gärqomni iva ngi qoar toqortäqyia, ‘Mamär iva ama modämne sävät tak täkt kärak i qat dän nävät ma Engeska ma Ngämuqa aa ngärhipki.’” ");
INSERT INTO uro_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ma Jisas ka met daqule ama ansäspämgi ama mor qi bä nga qat tet dä aa mudäsaqongda rha män sagem ga ivakt iva rhir qur a qa rha ama ansäspämgi ama mor qi arha vät. ");
INSERT INTO uro_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Dä qa muvät pät a rha rhoqortäqyia, “Nga ngänät lu rhangät täkt ama vät moe? Ngu qoar na ngän na ama engäktki i rhangät täkt ama dui moe diva qaku qale anga duiqa vono vät akni aa rhäng de dap kinak pa rha rhartäm sä ngät moe sa rhämono sävät ivät.” ");
INSERT INTO uro_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Bä nga ma Jisas kat muqun da ama Damgi na ama Olip at täväs dä aa mudäsaqongda rha män gem ga dä rha qoar na qa rhoqoräkt i sokt ka qä na rha rhoqortäqyia, “Ngi qoar na ut iva qäsnia dä va rhärhong däkt ngä rhäranas.” Dä rha snanbät sä qa i, “Va agi muqunängi qia rhän iva qi sameng nä gia mänmänäs ngä nä rhangät täkt ama rhodäm angät tpäsini?” ");
INSERT INTO uro_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Mamär iva ngänit lu mamär i varis aung gä nairas täm ngän. ");
INSERT INTO uro_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Inguna ama rhäqäp na rha ama ruvek diva rha rhän bä va rhat tualat nävät gu ngärhipki i rhi qoar i, ‘Aingo di ma Krais!’ Bä va rha rhäqäne sa anga rhäqäp na rha anga ruvek sagem mes. ");
INSERT INTO uro_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Bä nga ngäni nari i sa ama ulaqi qia märanas pät ama ivärhap ama rhäqäp na ap ura vät amekni anga ivärhimek dä mamär iva qale qänäskänes ngän inguna qoki va rhärhong däkt diva irhong ngä rhän dap as pa qaku ama tpäsini. ");
INSERT INTO uro_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dä ama ruvek näva amni ama ivärham diva rhat täranas na ama ulaqi sävät a ne dä ama muräktpäm diva ngät täranas sävät a ne dä va ama ruvek tit ñäp mät ama qärhuqi dä va ama qängän ngä rhän bät apni ama ivärhap. ");
INSERT INTO uro_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Rhärhong däkt moekt di qoki irhong doqor ama evopki at ruanini qärqäni i ini ngät dän narhoer toqoräkt i sa qorhäs iva qi sa. ");
INSERT INTO uro_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Bä nga rhärhong däkt ngät täranas dä va angäna ikkäna rhit sangar ma ngän bä rhit sokot na ngän bä rhi veng ngän bä va ama ruvek pät ama ivätki moe diva ama vu da arha ron mamär sävät a ngän inguna nävät iomäkt i ngänät nanakt na ngo. ");
INSERT INTO uro_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bä va ama rhäqäp na rha ama ruvek diva bok da arhä qatnanakt bä va rhit bodäm ne bä ba arha ikkäna bä va ama vu da arha ron masirhat sävät a ne. ");
INSERT INTO uro_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Näkt pa vuk sa ama rhäqäp na rha ama ruvek kärarhani i rhat tes nas i ma Ngämuqa aa vämginarha sokt di ama iraski na rha bä va rhi artäm sa anga rhäqäp na rha nämäni ma Ngämuqa aa iska. ");
INSERT INTO uro_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dä ama rhäqäp na rha ama ruvek diva rhäktäksot na arhä lavuqi sävät arhani inguna ama lat kärangätni i qaku varhäm ama Muräkt diva ngät dän masirhat bä masirhat mamär. ");
INSERT INTO uro_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sokt di iaqäkt kärak i qat mair ma ama qrot bä dängdäng bät ama tpäsini diva qä rha ama mumaiar. ");
INSERT INTO uro_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Näkt pa rhangät täkt ama sameng ama mär ngät sävät ama Muräktpäm na rhävuk diva rhi sameng na ngät pät ama ivätki moe ivakt iva ama ruvek ti nari ngät näkt nasot dä va ama tpäsini ngä rhän. ");
INSERT INTO uro_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Mudu ma Ngämuqa aa vämginaqa ma Daniel qat tamän sävät ianiäkt kärqäni i ama vu ini mamär dä ma Ngämuqa aa saqong i qali lini vät ama qumärqumär äs mamär ama ivärhäs kärqäni i ini ngärhi slava nä iarhongäkt moe. Näkt mamär iva auge qärak i qat tes tangät täkt ama enge qä räm ama rharimini sä iangärhäkt ama lat. ");
INSERT INTO uro_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Dä mamär iva iarhakt kärarhae i qale rha e ma Judia di rhi ang masirhat pävit sävät ama dam. ");
INSERT INTO uro_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bä mamär iva aung gärakni i qale qa vät ama vätka aa rhäng di saqi as kale ar sä qa bä qä namon säva vät nani aa qärhong. ");
INSERT INTO uro_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bä aung gärakni i qale qa vät aa etki di saqi as kale evär däm ga iva nani aa boiqi ama uiu qi. ");
INSERT INTO uro_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Va ama qrot mamär vät iangärhäkt ama qunäng ba ama evop kärarhani i ama sarem däm da bä qosaqi bä iarhakt kärarhae i ama rhoes pät a rha. ");
INSERT INTO uro_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mamär iva ngäni nän sage ma Ngämuqa iva ngäni ngang di qale mät soeng dä qale vät aung anga Sabat. ");
INSERT INTO uro_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Inguna ama märänga vät iangärhäkt ama qunäng diva ama mor qa masirhat pä ama märän angät tpäs moe qärangätni i mudu vät ama rharimini inamäk bä sarhäkt bä qop as nasot. ");
INSERT INTO uro_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Dap mai ngakt bä qaku ma Ngämuqa qa sämaqot sävä iangärhäkt ama qunäng dä vadi mai qaku anga ruqa qärakni iva ama iar qa. Dap nguna nävät iarhakt kärarhae i sa qa armeng däm da dä va qä sämaqot sävä iangärhäkt ama qunäng. ");
INSERT INTO uro_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Bä nga vät iangärhäkt ama qunäng di ngakt bä aung gä qoar na ngän doqortäqyia, ‘Ngäni lu i ma Krais tak i!’ ura aung gä qoar toqortäqyia, ‘Iak muk i!’ dä qale ngän natnanakt nä iangärhäkt ama enge. ");
INSERT INTO uro_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Inguna ama iraski na rha ama engesta dä ama iraski na rha ama vämginarha diva rha rhäranas bä va rhat tualat na ama muqunän ama mor ngät dä ama lat kärangätni i ngät dän masärmän i vadi vakt iva qäqi rhi irastäm sa ama ruvek kärarhani i sa ma Ngämuqa qa armeng däm da. ");
INSERT INTO uro_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ngäni lu i sa ngua qoar na ngän nä rhärhong däkt bä iomäkt ama qäväläm angät kamäs. ");
INSERT INTO uro_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Bä äkt i nga rhi qoar na nge i, ‘Ngäni lu i qa e vät ama ivärhäs ama qräk dä bäs’ dä qale ngän namet sae. Bä qop nga rhi qoar i, ‘Nak kale qa va ama ngaiväs pa vät’ dä qale ngän dat maengäkt. ");
INSERT INTO uro_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Inguna ma Ruqa aa Emga aa mänmänäs diva äs toqor ama iauska qärakni i qät ñäm mät ama leqäs moe inamäk näsäng gunäga aa qamäs bä samone i qat don e. ");
INSERT INTO uro_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Qoe nai äkt i qale ama säktämgi e diva västämne na ama isäm e qärangätni i ngät dräm ngät täs ama säktämgi. ");
INSERT INTO uro_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Näkt pa äkt nasot iaqäkt ama märänga vät iangärhäkt ama qunäng dä va bängangit mät ama qunäga aa saqong dä va ama equngi diva qaku qiat nañäm dä va ama qaeng diva ngärhi säp nämät ama leqäs dä va iarhongäkt kärqärhongni i qali lirhong mät ama leqäs kärqärhongni i irhong angät krot diva sarhäktsarhäkt pät irhong. ");
INSERT INTO uro_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Mamär dä va vuk sä ma Ruqa aa Emga aa mänmänäs angät muqunängi mät ama leqäs bä va ama ruvek moe nävät ivät diva rhit nok i rhat lu ma Ruqa aa Emga i qat dän bät ama eqoe angärha rhäng na rhävuk sa ama qrot dä sa ama mor qa ama murhämeska. ");
INSERT INTO uro_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Näkt pa qä rhäk na aa enselqäna na ama raunaqa aa eguinga ama mor qa dä va rhi västämne na ama ruvek kärarhani i sa ma Ngämuqa qa armeng däm da nävät ama ivätki qi na ama usäpki in däkt moe. ");
INSERT INTO uro_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mamär iva ngäni räm ama rhisu nävät ama rhaun gärangätni i nga vuk pät angät ngärhäqyitnäk dä sa ngänät dräm i ama qunängit di it nga e glaqot. ");
INSERT INTO uro_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Di rhoqorne rhoqoräkt i ngakt bä va ngänät lu rhärhong däkt moekt i irhong ngät täranas dä va ngänät dräm i qa di sa qa e glaqot i sa qäqi qa e glaqot na ama tmongi. ");
INSERT INTO uro_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nguat tamän särhäm ngän na ama engäktki iva rhit täkt ama qoengait diva qaku rhäksot nä it bä dängdäng i rhärhong däkt moe di sa irhong ngä märanas. ");
INSERT INTO uro_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ama usäpki qi na ama ivätki diva qäbäs na em dap pa gua enge diva qaku qäbäs na ngät. ");
INSERT INTO uro_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Qaku aung anga ruqa qat dräm iaqäkt ama qunäga dä iaqäkt ama qunäga aa qäväläm. Bä qäqi ama enselqäna rhävuk ti na ama Ngärhoemga di qaku rhat dräm dap sokt ama Ngätmamäk kat dräm. ");
INSERT INTO uro_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Vät iomäkt ama qäväläm gärqomni iva ma Ruqa aa Emga qa rhän diva ama lat ngät täranas kärangätni i ngät toqor ama lat mudu vät ama rhodäm i ma Noa. ");
INSERT INTO uro_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Inguna vät iangärhäkt ama rhodäm i as kaku ama qärhop ngä män bit di ama ruvek tat täs dä rhit nakt dä rhat tätlägut dä rhit bodäm na ne bä dängdäng bät ama qunäga qärak i ma Noa qa mon sämät ama mlauski ama mor qi. ");
INSERT INTO uro_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Qop mavängam bät a rha bä dängdäng i ama qärhop ngä met sä rha moe. Ma Ruqa aa Emga aa mänmänäs diva rhoqorne rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Vät iomäkt ama qäväläm dä va qale ama gamuiom ama udiom bät ama etki dä va ma Ruqa aa Emga qa rha akni dap pa qale akni mäk. ");
INSERT INTO uro_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Va ama evovem ama unbem in dualat i ini qräskräs ama wit dä va ma Ruqa aa Emga qä rha aktni dap pa qale aktni mäk. ");
INSERT INTO uro_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Dä soknga mamär iva ama qarhap ngän bä va ngänät nañäm inguna sa qaku ngänät dräm ama qunäga iva angäna Engeska qa rhän. ");
INSERT INTO uro_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sokt di sa ngänät dräm daerhom däkt i ngakt bä ama vätka aa ik di vadi mai qat dräm na ama bängagi at käväläm gärqomni iva ama suaqa qa rhän dä vadi mai ama qarhap ka bä va qaku qä naqyiradeng na aa vätka iva ama suaqa qä drukdäm bäm ga. ");
INSERT INTO uro_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Bä äkt i aingän di mamär iva ngänit täkmu na nas mamär inguna ma Ruqa aa Emga va qa rhän bät ama qäväläm gärqomni i qaku ngän du angän snäng iva qa rhän bät a äm. ");
INSERT INTO uro_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Rhoqoräkt dä ngu lu agi a latka iaqäkt kärak iva qale qa ma ama qrot mäni ama lat dä aa mädräm ama mär ngät kärakni i sa aa morqa qa mu qa ivakt iva qät lu vät ka morqa aa latta i qät boda rha arha tmäs pät ama rhäkmamär ap ama qunäng angät kävälap nasot a ne? ");
INSERT INTO uro_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Va ama märmärgem ge iaqäkt ama latka qärak i nga evär da aa morqa dä va aa morqa qa rhän bät a qa i qat tualat toqoräkt. ");
INSERT INTO uro_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nguat tamän särhäm ngän na ama engäktki iva qa rhu qa ivakt iva qät lu vät aa qärhong moe va aa vätka. ");
INSERT INTO uro_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Dap ngakt bä va iaqäkt ama latka qat tamän särhäm mes doqortäqyia, ‘Gua morqa di qät tiläng bä qaku qät lir qat dän’ ");
INSERT INTO uro_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","dä va qä nasäng i qä arhäktgyäm sa arhani ama latta dap kat täs dä qät nakt dä qät nakt kä na ama gamoe qärarhani i rhat dräm dit näkt ama reng ama qrot ngät bä guani na rha ");
INSERT INTO uro_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","dä va aa morqa qa rhän bät ama qunäga rhoqoräkt i qaku qa latka qat tu aa snäng iva qa rhän bät a qa bä vät ama qunäga aa qäväläm gärqomni i qaku qat dräm na äm. ");
INSERT INTO uro_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Dä va qa morqa qä sangäm na qa näkt pa qä qut na qa sävät ama ivärhäs ge ama latta qärarhani i rhat tualat sädä saqong. Vät iosäkt ama ivärhäs diva rhat tuqaia dä va rhit nes arhä qeng angärha rem na ne. ");
INSERT INTO uro_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Vät iomäkt ama qäväläm di iaqäkt na rhävuk aa Muräktpäm diva äm doqor taerhäkt. Maos pät ama qäväläm na ama rhitbodämnarha di ama säs ta ama evop ama ngärhäqyisem na rha di rha rha arhä lirhäng bä rha met ivakt iva rha rhair nani ama gamoeqa qärak iva rhit bodäm na qa. ");
INSERT INTO uro_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ama ngärhäqyet na rha di ama dädän da dap arhani ama ngärhäqyet na rha di ama mädräm da. ");
INSERT INTO uro_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ama dädända rha rha arhä lirhäng dap kaku rha rha anga kain na ama oel irhäm ngät. ");
INSERT INTO uro_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Dap ama mädrämda di rha rha ama kain na ama oel ngä na arhä lirhäng. ");
INSERT INTO uro_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Bä nga ama gamoeqa qärak iva rhit bodäm na qa di qaku qa lir qa män dä rha moe vurhäm da bä rha mänatäm. ");
INSERT INTO uro_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Näkt mäni bängagi mamär dä ama eguinga qät näs toqortäqyia, ‘Qärak iva rhit bodäm na qa di sa rhakni! Ngäni ang ngän dair nani a qa.’ ");
INSERT INTO uro_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Dä qa ngärhäqyisem na rha qa sästa rha märanas bä rha mudam sämät arhä lirhäng. ");
INSERT INTO uro_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Dä ama dädända rhi qoar na ama mädrämda rhoqortäqyia, ‘Ut sa anga oel sämät aut lirhäng nagem ngän inguna sa qorhäs iva rhäksot nämät aut lirhäng.’ ");
INSERT INTO uro_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Sokt di ama mädrämda rha muvät pät a rha rhoqortäqyia, ‘Qaku anga oel iva mamär vät a ut ut na ngän. Mamär iva ngän det sage iarhakt kärarhae i rhit boda ama oel bä ngäni vodäm bät agung bä ba nas.’ ");
INSERT INTO uro_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Bä nga ama dädända rhat tet ivakt iva rhi vodäm bät anga oel dä ama gamoeqa qärak iva rhit bodäm na qa qa män bä ama ngärhäqyet na rha iarhakt kärarhae i sa rha rhäkmu mamär ba nas di rhi na qa rha mon säva ama tmäski na ama rhitbodämnarha dä ama tmongi qia väs. ");
INSERT INTO uro_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Näkt nasot dä arhani qa ngärhäqyet na rha ama sästa rha män bä rhit näs i, ‘Aurha morqa, aurha morqa, ngi rhar nanokt ut!’ ");
INSERT INTO uro_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Dap kinak ka muvät pät a rha rhoqortäqyia, ‘Nguat tamän särhäm ngän na ama engäktki i qaku nguat dräm a ngän.’” ");
INSERT INTO uro_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Dä ma Jisas ka qoar i, “Va ama qarhap ngän bä ngänät nañäm inguna qaku ngänät dräm ama qunäga ura ama qunäga aa qäväläm sä gu mänmänäs. ");
INSERT INTO uro_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Vät iomäkt ama qäväläm di ama Muräktpäm na rhävuk diva äm doqor taerhäkt. Maos dä akni ama ruqa qa rhäkmu na nas iva qa rhet pät ama tmerhäs sa gläius dä qa mes aa latta bä qa mu aa qärhong ba arhä rhäkt. ");
INSERT INTO uro_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Qa von akni rha ama rhae ama ngärhäqyet na ngät na ama gol dap ka von akni rha ama rhaliom ama udiom na ama gol dap ka von akni rha ama sägäk ama rhaeqa na ama gol. Qoki qa von da maräkt parhäm arhä qrot dä arhä mädräm ama mär ngät. ");
INSERT INTO uro_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Dä iaqäkt ama latka qärak i sa qa rha ama ngärhäqyet na ngät ama rhae na ama gol di qa märanas bä qa märmor ngät bä ngä sa angätni ama ngärhäqyet sae. ");
INSERT INTO uro_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Dä qosaqi qärak sa ama udiom di qa märmor iom bä in sa aiom sae. ");
INSERT INTO uro_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Dap kinak kärak sa ama sägäk ama rhaeqa na ama gol di qa nges bä qa rut aa moräsnaqa aa gol va ama ivätki. ");
INSERT INTO uro_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Sa nasot ama uiu ngät ama rhodäm dä iarhakt ama latta arha moräsnaqa qa män bä qa qoar na rha iva qä lu arha lat angät gavämgi. ");
INSERT INTO uro_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Dä ama latka qärak i sa qa rha ama rhae ama ngärhäqyet na ngät na ama gol di qa män sa angätni ama ngärhäqyet sae bä qa von aa moräsnaqa dä qa qoaräs na qa rhoqortäqyia, ‘Gua morqa, mudu ngia von ngo rha ama ngärhäqyet na ngät ama rhae na ama gol näkt täkt di sa ngua mualat nani ama ngärhäqyet sae.’ ");
INSERT INTO uro_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Dä aa moräsnaqa qa qoar na qa rhoqortäqyia, ‘Gua latka ama mär qa qärak i ama engäktki na qa sä gua lat, ainge di sa ngia mualat mamär. Qoki sa ama engäktki na nge sa ama marheka nä irhong dä soknga va ngua rhu nge iva ngit lu vät ama rhäqäp nä irhong. Ngia rhon sagem ngo vä gu märmärgem.’ ");
INSERT INTO uro_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Näkt kosaqi ama latka qärak i sa qa rha ama rhaliom ama udiom na ama gol qa män bä qä qoar toqortäqyia, ‘Gua morqa, mudu ngia von ngo rha ama udiom ama rhaliom na ama gol näkt täkt di sa ngua mualat nani ama udiom sae.’ ");
INSERT INTO uro_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Dä aa moräsnaqa qa qoar na qa rhoqortäqyia, ‘Gua latka ama mär qa qärak i ama engäktki na qa sä gua lat, ainge di sa ngia mualat mamär. Qoki sa ama engäktki na nge sa ama marheka nä irhong dä soknga va ngua rhu nge iva ngit lu vät ama rhäqäp nä irhong. Ngia rhon sagem ngo vä gu märmärgem.’ ");
INSERT INTO uro_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Dä qosaqi ama latka qärak i sa qa rha ama sägäk ama rhaeqa na ama gol qa män bä qä qoar toqortäqyia, ‘Gua morqa, sa nguat dräm i nge di ama qrotka na nge i ngiat dräm ngit ta ama gavam dap kaku ngiat tualat nani a ngät dä ngit sek mät kärqäni i sa qaku ngia qutnanokt ini. ");
INSERT INTO uro_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Dä soknga ngua len nge dä ngua met bä ngua rut gi gol va ama ivätki. Ani nä rhangät täkt gi gol.’ ");
INSERT INTO uro_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Dä aa moräsnaqa qa muvät pät a qa rhoqortäqyia, ‘Ainge di ama vu qa dä ama rusus pät a qa ama latka na nge. Nga ngäktki sa ngiat dräm i aingo di ngut ta ama gavam dap kaku nguat tualat nani a ngät dä ngut sek mät kärqäni i qaku ngua qutnanokt ini? ");
INSERT INTO uro_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bä nga rhoqoräkt dä vadi mai ngi von iarhakt pa ama vätki na ama ligär ivakt iva rhat tualat sä gu gol iva ngärhi sa sävät a nas savono bä nga evär däm ngo dä vadi va ngu rha ngät sa anga mänbitka.’ ");
INSERT INTO uro_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Dä aa morqa qa qoar na arhani ama latta rhoqortäqyia, ‘Ngäni rha ama gol nagem ga bä ngäni von iaqäkt kärak i aa ngärhäqyisem aa rhae na ama gol ");
INSERT INTO uro_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","inguna aung gärakni i sa aa anga guani diva rhi von ga rha arhongni savono sae bä va masirhat mamär na aa qärhong. Dap aung gärakni i sa qaku aa anga guani diva qäqi rhi rha aa qäni ama gaini nä ini nagem ga.’ ");
INSERT INTO uro_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Dä saqi as ka morqa qa märhamän i, ‘Rhäkt diva ngäni rhon nä iaqäkt ama latka qärak i qaku mamär vät anga lat na qa sainamäk säp bängangit angät tpäs. Vät iosäkt ama ivärhäs diva rhat tuqaia dä va rhit nes arhä qeng angärha rem na ne.’ ");
INSERT INTO uro_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Qre va ma Ruqa aa Emga qa rhän sa aa murhämeska qä na aa enselqäna moe dä va qa rhuqun ba aa vitnaqa aa mämugunäs ama mär äs. ");
INSERT INTO uro_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Näkt pa västämne na ama ruvek moe nävät ama ivärhimek pät ama ivätki da aa saqong. Dä va qa rhatmät na rha i arhani särhage dap arhani särhage iva qa rhoqor ama ruqa qärakni i qat dräm gät lu vät ama sipsipkäna i qä rharmeng da ama sipsipkäna näva ama memeqäna. ");
INSERT INTO uro_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","“Näkt pa qa rhu ama räkt ta ama ruvek säda aa märmär dap pa qa rhu ama vu rha ama ruvek säda aa sael. ");
INSERT INTO uro_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nasot dä va ama vitnaqa qä qoar na ama ruvek da aa märmär toqortäqyia, ‘Ngäni ang, aingän gärarhae i sa gu mam ga modämne na ngän. Ngäni ang bä ngäni sangar ama Muräktpäm gärangätni i sa qa rhäkmu na ngät mudu vät ama rharimini rhoqoräkt i qa säm ama ivätki. ");
INSERT INTO uro_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Inguna mudu di anoeng ma ngo dä ngia von ngo ngua mäs bä aqäsäk ngo dä ngia von ngo ngua nakt bä ama nañiska na ngo dä ngia ar sä ngo sagem mes ");
INSERT INTO uro_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","bä ama vlavel a ngo dä ngia von ngo rha ama boi bä aräm ngo dä ngia igi na ngo näkt nga qale ngo va ama tpäskiarharhäng dä ngia met sagem ngo.’ ");
INSERT INTO uro_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Dä va ama räktta rha rhuvät pät a qa i rhi snanbät sä qa rhoqortäqyia, ‘Engeska, qäsnia dä ut lu nge i anoeng ma nge dä ut bon nge ngia mäs bä qop aqäsäk nge dä ut bon nge ngia nakt? ");
INSERT INTO uro_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Bä qop käsnia dä ut lu nge i ama nañiska na nge dä urha ar sä nge ura ama vlavel a nge dä ut bon nge rha ama boi? ");
INSERT INTO uro_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Bä qop käsnia dä ut lu nge i aräm nge ura qale nge va ama tpäskiarharhäng dä urha igi na nge?’ ");
INSERT INTO uro_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Dä va ama vitnaqa qa rhuvät pät a rha rhoqortäqyia, ‘Nguat tamän särhäm ngän na ama engäktki i qre i sa ngia mualat toqoräkt sa aung gärakni i qaku ama ngärhep pät a qa nävät tärhae rhäkt gu qärhae di sa ngia mualat sä ngo rhoqoräkt.’ ");
INSERT INTO uro_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Nasot dä va qä qoar na ama ruvek da aa sael toqortäqyia, ‘Ngän det nävät gu saqong. Aingän di ma Ngämuqa aa uraqi ama mor qi sävät a ngän. Ngän det sämät ama mudäbäs ama sok tä bäs kärqosni i sa ma Ngämuqa qa rhäkmu na äs nani ma Sämga qä na aa enselqäna. ");
INSERT INTO uro_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Inguna mudu di anoeng ma ngo dä qaku ngia von ngo ngua mäs bä aqäsäk ngo dä qaku ngia von ngo ngua nakt ");
INSERT INTO uro_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","bä ama nañiska na ngo dä qaku ngia ar sä ngo sagem mes bä ama vlavel a ngo dä qaku ngia von ngo rha anga boi näkt aräm ngo bä qop kale ngo va ama tpäskiarharhäng dä qaku ngia igi na ngo.’ ");
INSERT INTO uro_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Dä qosaqi va rha rhuvät pät a qa i rhi snanbät sä qa rhoqortäqyia, ‘Engeska, qäsnia dä ut lu nge i anoeng ma nge ura aqäsäk nge ura ama nañiska na nge ura ama vlavel a nge ura aräm nge ura qale nge va ama tpäskiarharhäng dä qaku ut matnärhäm nge?’ ");
INSERT INTO uro_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Dä va qa rhuvät pät a rha i qä qoar na rha rhoqortäqyia, ‘Nguat tamän särhäm ngän na ama engäktki i ngakt bä qaku ngia mualat sa aung gärakni i qaku ama ngärhep pät a qa nävät tärhae rhäkt gu qärhae di sa qaku ngia mualat sä ngo rhoqoräkt.’ ");
INSERT INTO uro_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Dä va rhärhae rhäkt da aa sael ta rhet sämät ama ruanini qärqäni i qaku ini angärha anga tpäsini. Dap ama räkt ta ama ruvek diva rha rhet säva ama iar ama sok täm ngät.” ");
INSERT INTO uro_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sa nga ma Jisas ka märhamän bät tangät täkt ama enge moe bä rhäksot dä qa qoar na aa mudäsaqongda rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Sa ngänät dräm iva nasot ama qunängiom ama udiom dä va ama tmäski iva rhat tuqunän bät ma Pasova dä va rhi vodä ma Ruqa aa Emga bä ba aa ikkäna ivakt iva rhi edämsäs pät a qa mäni ama sämänanamuqa.” ");
INSERT INTO uro_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Dap pästämne na ama priskäna ama moräs na rha rhi na ama ruvek arha morta va ama pris ama vit na qa aa vätki qärak i rhat tes ka i ma Kaiafas ");
INSERT INTO uro_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","bä rha märhamän bät a ne iva up na rha i rhi sangar ma Jisas bä va rhi veng ga. ");
INSERT INTO uro_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Sokt di rha qoar na ne iva qaku rhi namualat toqoräkt sädamär na ama tmäski i varis ama ruvek ti namäranas na anga inirqi. ");
INSERT INTO uro_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nga qale ma Jisas e ma Betani vä ma Saimon aa vätka qärak i mäqi ama bias pät a qa ");
INSERT INTO uro_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","bä vät ama qäväläm i qat täs nävät ama laiqa dä ama evopki qia män sa ama kainaqi qäraktni i sa rha mualat na qi na ama duiqa ama saksak päm ga qärakni i rhat tes ka i ama alabasta. Iaqyäkt ama kainaqi di rhäqäp ki na ama oel qäraktni i ama mär at tamaska dä ama ligär masirhat pät a qi bä qia rhor na qi dä ma Jisas aa uväs. ");
INSERT INTO uro_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bä nga ama mudäsaqongda rha lu rhoqoräkt dä uraqi da arha ron i rhi snanbät toqortäqyia, “Mäniekt bä qia rhar sa ama oel toqoräkt? ");
INSERT INTO uro_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Inguna mai mamär iva rhi vodä iaqyäkt ama oel iva vät anga ligär masirhat näkt ti von ama tläkta.” ");
INSERT INTO uro_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Dap ma Jisas kat dräm doqoräkt dä soknga qä qoar na rha rhoqortäqyia, “Mäniekt bä ngänit bon gi rha ama märänga? Ngu snanbät toqoräkt dinguna sa qia mualat na ama lat ama mär ngät sä ngo. ");
INSERT INTO uro_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Iarhakt kärarhae i ama tläk ta diva vasägos dä qale rha gem ngän dap aingo diva qaku qale ngo gem ngän basägos. ");
INSERT INTO uro_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Qia rhor nä rhakt täkt ama oel vät gu släqyige vä gua tñäpki at kamäs ivakt iva qi rhäkmu na ngo iva nani iomäkt iva rhi sasärhäm ngo. ");
INSERT INTO uro_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Dä nguat tamän särhäm ngän na ama engäktki i qoe nai vät ama ivätki moe i rhangät täkt ama sameng ama mär ngät di rhi sameng na ngät e dä va ama sameng sävät tangät täkt arha lat diva qosaqi rhi sameng na ngät bä va ama ruvek ta tu arhä snäng sävät a qi.” ");
INSERT INTO uro_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nasot dä akni nävät ama ngärhäqyisem da udiom na rha ama mudäsaqongda qärak i rhat tes ka i ma Judas Iskariot ka met sage ama priskäna ama moräs na rha ");
INSERT INTO uro_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","bä qa snanbät sä rha rhoqortäqyia, “Va ngakt bä ngu vodä ma Jisas bä ba ngän dä va ngäni von ngo rha agiqa?” Dä rha von ga rha ama ligärigleng ama ruqa ama rhäk täm ga da ama ngärhäqyisem nä igleng na ama silva. ");
INSERT INTO uro_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Bä mänasäng na äkt dä ma Judas kät ñäm nani anga qäväläm anga mär äm ivakt iva qä vodä ma Jisas bä ba rha. ");
INSERT INTO uro_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nga vät ama narhoer qa ama qunäga vät ama tmäski at kunäng gärangätni i ama Judaqäna rhat tuqunän i mudu arha morta rhat täs ama bretkäna qärangätni i qaku anga yis päm ngät dä ama mudäsaqongda rha män sage ma Jisas i rhi snanbät sä qa rhoqortäqyia, “Urhi lu i nani a nge na ut iva urhi rhäkmu qoe bä ba nge iva ngia äs ma Pasova angärha tmäs e?” ");
INSERT INTO uro_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Dä qa qoar na rha rhoqortäqyia, “Va ngän det sage akni ama ruqa qärak i sa nguat dräm a qa va ama värhäm ama mor äm dä ngäni qoar na qa rhoqortäqyia, ‘Qamorqa qat tamän doqortäqyia, Gu qäväläm di sa äm ngä män. Ngu nä gu mudäsaqongda va u äs ma Pasova angärha tmäs pä gia vätka.’” ");
INSERT INTO uro_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Dä ama mudäsaqongda rha mualat parhäm ma Jisas aa enge bä rha rhäkmu nä ma Pasova angärha tmäs. ");
INSERT INTO uro_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sa nga rhoqoräkt i ama bängangäs dä ma Jisas ka muqun gä na aa mudäsaqongda ama ngärhäqyisem da udiom na rha bä rhat täs pät ama laiqa aa rhäkt. ");
INSERT INTO uro_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bä nga rhoqoräkt i rhat täs dä ma Jisas ka qoar na rha rhoqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i akni nävät a ngän diva qä vodäm ngo bä gua ikkäna.” ");
INSERT INTO uro_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dä airäs ta masirhat bä rha nasäng i rhi snanbät asägäk asägäk toqortäqyia, “Engeska, nga aingo?” ");
INSERT INTO uro_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Dä qa muvät pät a rha rhoqortäqyia, “Iaqäkt kärak iva ngu na qa uni rhäk ama bret sämät ama dis di qärak iva qä vodäm ngo. ");
INSERT INTO uro_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ma Ruqa aa Emga diva qä ñäp toqor varhäm ama enge qärangätni i mudu sa rha säm a ngät sävät a qa sokt diva avuqi mamär ge iaqäkt kärak iva qä vodä ma Ruqa aa Emga ba aa ikkäna. Nak padi mai qaku aa nanäk ki nasäl a qa di vadi mai ama märäm ba qa.” ");
INSERT INTO uro_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ma Judas kärak iva qä vodä ma Jisas ka snanbät sa ma Jisas i, “Qamorqa, nga aingo?” Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Sa ngia qoar toqoräkt.” ");
INSERT INTO uro_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bä nga rhat täs dä ma Jisas ka rha ama bret bä qa mes ama mär näkt ka vonamät na qa bä qa von aa mudäsaqongda dä qa qoar na rha i, “Ngän dät tangät täkt bä ngän däs. Rhangät täkt di gu släqyige.” ");
INSERT INTO uro_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Näkt ka rha ama kap na ama wain bä nga qa mes ama mär dä qa von da i qä qoar toqortäqyia, “Ngän moe ngäni nakt nämät ka ");
INSERT INTO uro_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","inguna rhak täkt di gu biaska qärakni i qä sämaengäktki na ama rharesbane mänguräp ma Ngämuqa qä na ama ruvek di qärak i qrir na qa ba ama rhäqäp na ama ruvek ivakt iva ma Ngämuqa qä qyiradeng na arha vuirhong. ");
INSERT INTO uro_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nguat tamän särhäm ngän iva saqi as kaku ngu nanakt nävät ama wain angät gavam bä dängdäng bät iaqäkt ama qunäga iva ngu näkt ama iaräs na qi ama wain ngu na ngän bä gu mam aa Muräktpäm.” ");
INSERT INTO uro_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bä nga rha rhong ama mabuqi na ama ansäs bä rhäksot dä rha met na äkt bä säda ama Damgi na ama Olip at täväs. ");
INSERT INTO uro_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nasot dä ma Jisas ka qoar na aa mudäsaqongda rhoqortäqyia, “Näp takt täkt ama bängagi diva ngän moe ngäni ang daqule ngo inguna nävät iomäkt kärqom iva äm ngä rhän bät a ngo inguna mudu di sa rha säm sävät ma Ngämuqa rhoqortäqyia, “‘Va ngu veng ama ruqa qärakni i qät lu vät ama sipsipkäna bä va vräs na ama guläñgi na ama sipsipkäna.’ ");
INSERT INTO uro_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Sokt di nga nasot i ma Ngämuqa qa rhäranas na ngo nämät ama tñäpki dä va ngu er va angän gamäs sae ma Galili.” ");
INSERT INTO uro_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Dä ma Pita qa muvät pät a qa rhoqortäqyia, “Näma dä äkt bä rhärha rhäkt moe rhi ang daqule nge nävät iomäkt kärqom iva äm ngä rhän bät a nge sokt di aingo diva qaku rhäm ngo.” ");
INSERT INTO uro_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Dä ma Jisas ka qoar na qa i, “Ngu qoar na nge na ama engäktki iva näp takt täkt ama bängagi iva as kaku ama duraktka qä nanok dä va ngi rhäqyas na ngo madäpguamek.” ");
INSERT INTO uro_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Dä ma Pita qa qoar toqortäqyia, “Va qaku ngu narhäqyas na nge bä näma dä ngu ñäp ngu na nge.” Dä qosaqi arhani ama mudäsaqongda moe rha qoar toqoräkt. ");
INSERT INTO uro_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nasot dä ma Jisas kä na aa mudäsaqongda rha met sävät ama ivärhäs kärqos i rhat tes äs i ma Getsemani dä qa qoar na rha i, “Ngän duqun däkt dap aingo diva ngua rhet tävit bä ngu nän.” ");
INSERT INTO uro_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Dä qa rhäqoar sä ma Pita näkt ma Sebedi aa imiom bä rha met pävit näkt ka nasäng i qat nari i amärän bä airäs ka. ");
INSERT INTO uro_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Dä qä qoaräs na rha rhoqortäqyia, “Ama iräski imuk dä gua ron di ama mor qi masirhat bä nguat nari iva ngu ñäp. Dap pa qale ngän däkt bä ngänät däqäm ngän na ngo.” ");
INSERT INTO uro_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Näkt ka met nae maqälak dä arpus na qa bä aa uväski sävät ivät näkt kä nän doqortäqyia, “Gu mam, ngakt bä märmärsäs dä va ngi rha rhak täkt ama kap na ama märänga nävät a ngo. Sokt diva qoki qaku varhäm gu snängaqa dap kinak pa varhäm gi snängaqa.” ");
INSERT INTO uro_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nasot dä evär däm ga sage ama mudäsaqongda bä qa män bät a rha i rhi mänatäm dä qa snanbät sä ma Pita rhoqortäqyia, “Ai, nga qaku mamär vät a ngän iva ngänät däqäm ngän na ngo qäqi vät anga aua anga sägäk? ");
INSERT INTO uro_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mamär iva qarhap ngän dap pa ngäni nän sage ma Ngämuqa iva qale ngän namon sämät ama siqutsiqut. Ama qloqaqa di ngäñngäñ ga dap eqokt ama släqyige.” ");
INSERT INTO uro_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Saqi as ka met daqule rha iva maunmem bä qa nän doqortäqyia, “Gu mam, ngakt bä qaku mamär vät a nge iva ngi narha rhak täkt ama kap na ama märänga nävät a ngo di nak pa ngu näkt nämät ka. Mamär iva rhäkmamär toqoräkt parhäm gi snängaqa.” ");
INSERT INTO uro_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Näkt saqi evär däm ga dä qa män bät a rha i rhi mänatäm inguna amärän ba arhä mänap. ");
INSERT INTO uro_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Bä äkt i saqi ma Jisas ka met daqule rha iva madäpguamek bä qä nän i qät täqäs mät aa enge. ");
INSERT INTO uro_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nasot dä evär däm ga sage ama mudäsaqongda dä qa qoar na rha rhoqortäqyia, “Ngäni mänatäm dä mämae vät a ngän di sa mamär nasot. As ngäni lu i sa ama qäväläm ngä män iva rhi vodä ma Ruqa aa Emga säva ama vu rha ama ruvek arhä rhäkt. ");
INSERT INTO uro_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ngän däranas bä ut tet. Ngäni lu qärak iva qä vodäm ngo di sa rhak.” ");
INSERT INTO uro_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bä as nga rhoqoräkt i ma Jisas kat tamän dä väs dä ma Judas kärak i qa nävät ama mudäsaqongda ama ngärhäqyisem da udiom na rha qä na ama guläñgi ama mor qi na ama ruvek sa ama ulaqi arha sen ngä na ama edäm gärarhani i sa ama priskäna ama moräs na rha rhi na ama ruvek arha morta rha rhäk na rha. ");
INSERT INTO uro_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Iaqäkt kärak iva qä vodä ma Jisas di sa qa er qa rhodäm ba rha na aa muqunängi rhoqortäqyia, “Qärak iva ngu vop pa aa sdäm di iaqäkt. Ngäni sangar a qa.” ");
INSERT INTO uro_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Dä ma Judas ka rhäkdävär qa met maräkt bä sage ma Jisas dä qä qoar toqortäqyia, “Bängagi qamorqa.” Näkt ka vop pä ma Jisas aa sdäm. ");
INSERT INTO uro_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Dä ma Jisas ka qoar na qa rhoqortäqyia, “Gua ruaqa, ngi rhäksot nä gia lat.” Dä ama gamoe rha ang sage ma Jisas bä rha qärhäktgyäm ga bä rha sangar a qa. ");
INSERT INTO uro_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Dä nak sa akni nävät iarhakt kärarhae i sa qale rha rhi nä ma Jisas di qa rhäk aa rhäqyet dä qa mar ta aa ulaqi arha singi bä qa rhon na qi sävät ama pris ama vit na qa aa latka bä qa rhodäkt sa aa sdämgi. ");
INSERT INTO uro_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Dä ma Jisas ka qoar na qa rhoqortäqyia, “Ngia rhu gia singi nasot a nas inguna iarhakt moe qärarhae i rhi e na ama ulaqi arha singi diva ama ulaqi arha singi qi veng da. ");
INSERT INTO uro_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nga qaku ngän du angän snäng i mamär vät a ngo iva ngu nän gu mam iva qa rhatnärhäm ngo bä va qä lir qä rhäk na ama ngärhäqyisem da unbem na ngät ama mor ngät ama gulañ na ama enselqäna sagem ngo? ");
INSERT INTO uro_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Sokt di ngu lu i qre va rhoqoräkt diva rhäkmamär varhäm ma Ngämuqa aa enge rhoqor mäniekt kärangät i ngät tamän iva rhangät täkt ama lat diva qoki ngät dän?” ");
INSERT INTO uro_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nasot dä ma Jisas ka qoar na ama gulañ na ama ruvek toqortäqyia, “Nak nga ama suaqa na ngo bä äkt i sa ngän män sävät a ngo sa ama ulaqi arha sen dä ama edäm ivakt iva ngäni sangar a ngo? Vasägos dä sa nguat muqun ba ama ansäspämgi ama mor qi i ngu su ama ruvek sokt di qop kaku ngän sangar a ngo. ");
INSERT INTO uro_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sokt di rhangät täkt ama lat moe di sa ngä män ivakt iva qoki rhäkmamär nä ma Ngämuqa aa enge qärangät i aa vämginarha rha säm a ngät.” Dä ama mudäsaqongda moe rha met daqule ma Jisas bä rha ang masirhat. ");
INSERT INTO uro_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nasot dä iarhakt kärarhae i sa rhat sangar ma Jisas di rha met sä qa sage ama pris ama vit na qa ma Kaiafas äkt i sa västämne na ama Skraipkäna dä ama ruvek arha morta e. ");
INSERT INTO uro_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Dä ma Pita di qät päsais tä ma Jisas bä savuk sä dalek na ama pris ama vit na qa aa vätki arha ivärhäm. Bä nga qa mon mät ama surqa aa tmongi dä qa muqun ge ama ulaqimärharhärhäkt kärarhani i mai rhit lu vät ma Jisas ivakt iva qä lu qärangätni ama lat iva ngät dän. ");
INSERT INTO uro_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Näkt ama priskäna ama moräs na rha rhi na ama morta dä ama Skraipkäna moe nävät ma Sanedrin di rhit ñäm nani anga sameng anga iraski na ngät säng ma Jisas aa rhäng ivakt iva rhi vodäm ga sämät ama tñäpki. ");
INSERT INTO uro_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Sokt di qaku rha män bät agung anga enge rhoqoräkt näma dä ama rhäqäp na rha ama irasmätta sa ama sameng da män. Sokt di nasot a rha moe dä ama udiom in män ");
INSERT INTO uro_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","bä in goar i, “Rhärhak täkt ka qoar i, ‘Nak mamär vät a ngo iva ngu rhar ma Ngämuqa aa ansäspämgi ama mor qi bä saqi as pa ngu rhä qi da ama dävaung ama qunäng angärha ron.’” ");
INSERT INTO uro_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Dä ama pris ama vit na qa qa mair näkt ka snanbät sä ma Jisas toqortäqyia, “Nga qaku gi nga muvätki iva ngia rhuvät? Ngi rhäväkt sä rhangät täkt ama ruiom in sameng sävät a nge.” ");
INSERT INTO uro_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Sokt di qop kale ma Jisas i mänadin däm ga. Dä ama pris ama vit na qa qa qoar na qa rhoqortäqyia, “Ngu qoar na nge iva ngia rhamän dä ma Ngämuqa ama ngätdäqäm ga aa saqong i ma Krais ma Ngämuqa aa emga na nge ura qaku.” ");
INSERT INTO uro_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Dä ma Jisas ka qoar na qa rhoqortäqyia, “Sa ngia märhamän doqoräkt. Dap ngu qoar na ngän i mänasäng narhäkt bä rhävit diva ngäni lu ma Ruqa aa Emga i qat muqun dä iaqäkt kärak i ama qrot moe angät tarebäm aa märmär bä qat dän ba ama eqoe näda ama usäpki arha ron.” ");
INSERT INTO uro_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Dä ama pris ama vit na qa angyiret mät aa boi bä qa qoar i, “Sa qa märhamän mava nä ma Ngämuqa. Mäniekt bä saqi as pa nani a ut na agung anga enge säng aa rhäng? Sa ngän nari aa märhamän mava. ");
INSERT INTO uro_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Angän matnävämne di rhoqor mäniekt?” Näkt ta muvät i, “Sa mamär iva rhi veng ga.” ");
INSERT INTO uro_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nasot dä rha qot pät aa saqongait bä rhi arhäktgyäm sä qa na arhä rhäkt. Dä arhani rhi e va aa sdäm ");
INSERT INTO uro_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","i rhi qoar toqortäqyia, “Ainge qärak i ngiat tes nas i ma Krais, ngi qoar na ut i auge qa an mä nge!” ");
INSERT INTO uro_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ma Pita di sa qat muqun dalek pa ama vätka aa ivärhäm. Dä ama latki qia män sagem ga bä qia qoar i, “Qosaqi nge di ma qale nge ngi nä ma Jisas nae ma Galili.” ");
INSERT INTO uro_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sokt di qa rhäqyas da arhä saqong moe i qä qoar toqortäqyia, “Qaku nguat dräm i agiqa iaqäkt kärak i ngiat tamän bät a qa.” ");
INSERT INTO uro_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Bä nga qa met tämono sämät ama surqa aa tmongi dä aktni ama latki qia lu qa dä qia qoar nä iarhakt kärarhae i qale rha glaqot i, “Rhak täkt ama ruqa di ma qale qa qä nä ma Jisas nae ma Nasaret.” ");
INSERT INTO uro_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Dä saqi as ma Pita qa rhäqyas na ama enge na ama musärhäm doqortäqyia, “Nguat tamän dä ma Ngämuqa aa saqong i sa qaku nguat dräm iaqäkt ama ruqa.” ");
INSERT INTO uro_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Näkt nga nasot ama qäväläm ama qot äm dä iarhakt kärarhae i rhat mair glaqot ta män sage ma Pita bä rhi qoar na qa rhoqortäqyia, “Ngäktki i qosaqi nge di ak na nge nävät a rha inguna urhit träm gia eguinga.” ");
INSERT INTO uro_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nasot dä ma Pita qa nasäng i qat tamän i näma dä ma Ngämuqa qä sangäm na qa qrekt bä qa iras dap kat tu sävät aa enge angärha rhäng i qat tu dä qat tamän doqortäqyia, “Aingo di qaku nguat dräm dak täkt ama ruqa.” Dä vät iomäkt ama qäväläm maräkt dä ama duraktka qa nok. ");
INSERT INTO uro_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Dä vuk pät ma Pita na ama enge qärangät i sa ma Jisas ka märhamän särhäm ga na ngät toqortäqyia, “Va as kaku ama duraktka qa nanok dap pa ngi rhäqyas na ngo madäpguamek i qaku ngiat dräm a ngo.” Dä vuk sä qa sä dalek bä qät nok i airäs ka masirhat. ");
INSERT INTO uro_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Qoki as toqoräkt i vät duququs dä ama priskäna ama moräs na rha rhi na ama ruvek arha morta rha märhamän bät a ne sa ama iska qärakni iva ama Romgäna rhi veng ma Jisas nä varhäm ga. ");
INSERT INTO uro_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Dä rha qop mät aa rhäkt näkt ta met sä qa bä rha vodäm ga ba ama tpäskinaqa ma Pailat. ");
INSERT INTO uro_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nasot i nga ma Judas kärak i sa qa vodä ma Jisas ka lu i sa rha matnävämne nä ma Jisas bä rha muräkt iva rhi veng ga dä qa qutsasorhane na aa snängaqa dä evär däm ga sa qa ruqa ama rhäk täm ga da ama ngärhäqyisem gä ligärigleng na ama silva sage ama priskäna ama moräs na rha rhi na ama morta ");
INSERT INTO uro_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","i qä qoar toqortäqyia, “Sa ngua mualat na ama vuini. Ngua voda akni ama ruqa qärakni i sa qaku qa mualat nä guani anga vuini bä ba ngän bä va rhi veng ga.” Dä rha qoar i, “Qaku qänäskänes ut sä iangärhäkt. Sa gi qäni ianiäkt.” ");
INSERT INTO uro_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Dä qa met daqule rha dä qa rhon na ama ligärigleng na ama silva samäk pa ama ansäspämgi ama mor qi bä qa met ka veng nas i qa ar ma nas sa rhävuk sämäni ama ngämuga. ");
INSERT INTO uro_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bä nga ama priskäna ama moräs na rha rha män bät ama ligärigleng na ama silva dä rha qoar i, “Sa qaku maräkt parhäm ama Muräkt iva u rhu igleng ge ama ansäspämgi ama mor qi at ligär inguna rhangät täkt ama ligär di sa ngä män nävät akni aa biaska.” ");
INSERT INTO uro_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dä soknga rha märhamän bät a ne dä rha vodäm bät ama ruqa qärakni i qä däñdäñ bät ama bäñbäñgi aa etki nä iangärhäkt ama ligär ivakt iva qia rhän i ama ivärhäs iva rhi sasärha ama nañista e. ");
INSERT INTO uro_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Bä äkt i mänasäng na äkt bä dängdäng däkt di rhat tes iaqyäkt ama etki i ma Etki na ama Biaska. ");
INSERT INTO uro_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Rhoqoräkt di sa rhäkmamär na ama enge qärangät i sa ama vämginaqa ma Jeremaia qa märhamän bät a ngät i qä qoar toqortäqyia, “Dä sa rha rha qä ruqa ama rhäk täm ga da ama ngärhäqyisem nä igleng ama ligärigleng na ama silva qärqigleng i sa arhani nävät ama Israelqäna rha mu igleng i ama saqong nä igleng bät kärak ");
INSERT INTO uro_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bä rha von däm igleng bät iaqäkt kärak i qä däñdäñ bät ama bäñbäñgi aa etki. Rha mualat toqoräkt di qoki varhäm ma Ngämuqa aa rhodräp bä ba ngo.” ");
INSERT INTO uro_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sa nga ma Jisas kat mair da ama tpäskinaqa aa saqong dä qa snanbät sä ma Jisas toqortäqyia, “Nga ainge di ama Judaqäna arha vitnaqa na nge?” Dä ma Jisas ka qoar i, “Sa ngia märhamän doqoräkt.” ");
INSERT INTO uro_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sokt di nga ama priskäna ama moräs na rha rhi na ama morta rha rhäksärhäm ga dä sa ma Jisas di qaku qa voda anga muvätki. ");
INSERT INTO uro_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Dä ma Pailat ka snanbät sä qa rhoqortäqyia, “Nga sa qaku ngiat nari i ama mämänia nä irhong iarhongäkt kärqärhong i rhi sameng säng gia rhäng sä irhong?” ");
INSERT INTO uro_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Sokt di qaku ma Jisas ka muvät i qaku qa von da rha anga muvätki käqi vät anga sägängät nävät arhä rhäksärhäm. Dä soknga ama tpäskinaqa ma Pailat di qräk mät ka masirhat. ");
INSERT INTO uro_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Vät ama qoeo nasot a ne vät ma Pasova angät kunäng dä ama tpäskinaqa qat dräm gat tuisiska vät ama sägäk ama ruqa näva ama tpäskiarharhäng gärakni i nani ama guläñgi na ama ruvek na qa. ");
INSERT INTO uro_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Bä rhoqoräkt di qale akni ama ruqa ama vu qa mamär va ama tpäskiarharhäng gärak i rhat tes ka i ma Barabas. ");
INSERT INTO uro_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Bä äkt i nga västämne na rha dä ma Pailat ka snanbät sä rha rhoqortäqyia, “Ngu lu nani a ngän na auge iva ngua rhuisiska vät a qa? Nga va ngua rhuisiska vät ma Barabas ura ma Jisas kärak i rhat tes ka i ma Krais?” ");
INSERT INTO uro_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sa qa snanbät toqoräkt dinguna sa qat dräm i ama priskäna ama moräs na rha di sa rha vodä ma Jisas ba qa inguna nävät arhä snängaqa ama vu qa inguna ma Jisas di qa vit da ama ruvek arhä saqong. ");
INSERT INTO uro_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Bä qosaqi nga rhoqoräkt i ma Pailat kat muqun ba aa mämugunäs na ama matnävämne dä aa egutki qia rhäk na ama enge sagem ga sävät ma Jisas toqortäqyia, “Qale ngi namualat nä guani sävät iaqäkt ama räkt ka ama ruqa inguna rhäqyerhäkt dä sa ngua rha ama märänga ama mor qa da ama masirhämgi arha ron inguna nävät a qa.” ");
INSERT INTO uro_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sokt di ama priskäna ama moräs na rha rhi na ama morta rha qrotpät sa ama guläñgi iva rhi nän ma Pailat tä ma Barabas dap pa qä veng ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Saqi as ama tpäskinaqa qa snanbät sä rha rhoqortäqyia, “Ngu lu nani a ngän iva ngua rhuisiska vät auge nävät a iom?” Dä rha qoar i, “Barabas.” ");
INSERT INTO uro_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Dä ma Pailat ka snanbät sä rha rhoqortäqyia, “Ngu lu va ngua mäsana nä ma Jisas kärak i rhat tes ka i ma Krais?” Dä rha moe rha qoar i, “Ngi edämsäs pät a qa mäni ama sämänanamuqa!” ");
INSERT INTO uro_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Näkt ma Pailat ka snanbät i, “Va vät agiqa? Sa qa mualat na agi a lat anga vu ngät?” Sokt di qop tit näs tävuk masirhat toqortäqyia, “Ngi edämsäs pät a qa mäni ama sämänanamuqa!” ");
INSERT INTO uro_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Dä soknga nga rhoqoräkt i ma Pailat ka lu i qaku qat täqäne dä mamär dap kinak ama inirqi qi nasäng mänguräp ama ruvek dä qa rha ama rigi bä qa rhor aa rhäkt da ama guläñgi at saqong i qä qoar toqortäqyia, “Rhak täkt ama ruqa aa biaska di qaku qale qa vä ngua rhäkt. Sa angän gäni ianiäkt.” ");
INSERT INTO uro_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Näkt ama ruvek moe rha muvät toqortäqyia, “Va aa biaska diva qale qa vä u rhäkt dä va au rhoes arhä rhäkt!” ");
INSERT INTO uro_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nasot dä ma Pailat ka muisiska vät ma Barabas. Dap ka rhäkne bä rha märanäs ma Jisas näkt ka vodäm ga ivakt iva rhi edämsäs pät a qa mäni ama sämänanamuqa. ");
INSERT INTO uro_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nasot dä sa ama tpäskinaqa aa ulaqimärharhärhäkt ta met sä ma Jisas na äkt bä savuk säva ama tpäskinaqa aa vätki arha ivärhäs kärqos i rhat tes äs i ma Pretoriam. Näkt ta mes ama guläñgi na ama ulaqimärharhärhäkt moe sävät a ne. ");
INSERT INTO uro_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Näkt ta vlukt sa aa boi nävät a qa näkt ta rhon na ama qurät ki ama boiqi vät a qa. ");
INSERT INTO uro_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bä rha ing ama guaqi na ama ngämuga aa rhäqyitnäk ama gärgär vät itnäk iva qi rhoqor ama vitnaqa aa qäbautki. Näkt ta mu iaqyäkt ama gärgär vät a qi ama guaqi mäni aa uväski. Näkt ta mu ama iroqi mät aa rhäqyet ama märmär et. Dä rha an da arhä quum sä nas säng aa qar bä rhat tuma qa i rhi qoar i, “Ama märmärgem sagem nge, ama Judaqäna arha vitnaqa!” ");
INSERT INTO uro_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Dä rhit kot pät a qa bä rhi nän aa uväski na ama iroqi. ");
INSERT INTO uro_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bä sa nga rha muma qa bä rhäksot dä rha vlukt sa iaqyäkt ama boiqi nävät a qa näkt ta monmät pät a qa na aa boi maräkt. Nasot toqoräkt i rha monmät pät a qa dä rha met sä qa na äkt ivakt iva rhi edämsäs pät a qa mäni ama sämänanamuqa. ");
INSERT INTO uro_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bä nga ama ulaqimärharhärhäkt ti nä ma Jisas tat tet sä dalek dä rha män bät akni ama ruqa näva ama värhäm ama mor äm ma Sairini qärak i rhat tes ka i ma Saimon. Dä qa ulaqimärharhärhäkt ta qrotpät sä rhak täkt ama ruqa iva qät ta ma Jisas aa sämänanamuqa. ");
INSERT INTO uro_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bä nga rhat tet bä sävät iosäkt ama ivärhäs kärqos i rhat tes äs i ma Golgota qärqos i äs angät tarimini di ama ivärhäs na ama rhomga aa uväski ");
INSERT INTO uro_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","dä arhani ama ruvek ta von ga rha ama wain gäraktni i sa rha modämne na qi na aktni ama rigi qäraktni i qiat dräm gi veng ama ruanirhong gäraktni i rhat tes ki i ama gal. Sokt di nga qa nakt maqälak dä qa nari i rhoqoräkt mät ki dä qa mer qä nanakt. ");
INSERT INTO uro_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bä nga rha edämsäs pät a qa bä rhäksot dä ama ulaqimärharhärhäkt ta matmät na aa boi ba ne na ama serhäm gärangätni i serhäm da nani a ngät. ");
INSERT INTO uro_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nasot dä rha muqun bä rhit lu vät a qa e. ");
INSERT INTO uro_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bä rha mu ama enge qärangätni i sa rha säm a ngät daver mä qa qärangätni i ngät tamän doqortäqyia “Rhak täkt di ma Jisas kärak i ama Judaqäna arha vitnaqa.” ");
INSERT INTO uro_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Dä qosaqi rha edämsäs pät aiomni ama ruiom ama sua iom gem ga i ak di rha mu qa dä ma Jisas aa märmär dap akni da aa sael. ");
INSERT INTO uro_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bä ama ruvek kärarhani i rhat tet e na qa di rhat tuma qa dap ti em arhä väs ");
INSERT INTO uro_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","dap tat tamän doqortäqyia, “Ainge qärak iva ngi rhar ama ansäspämgi ama mor qi näkt saqi as pa ngi rhä qi da ama qunäng ama dävaung angärha ron di ngia rhumaiar nas! Ngakt bä ngäktki i nge di ma Krais ama Judaqäna arha vitnaqa di ngi sär sä nas navuk nämäni ama sämänanamuqa.” ");
INSERT INTO uro_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Dä qosaqi ama priskäna ama moräs na rha rhi na ama Skraipkäna näkt sävät ama morta di rhat tuma qa rhoqoräkt i rhat tamän doqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Sa qat tumaiar arhani sokt di qaku mamär vät a qa iva qä namumaiar nas! Qa di ama Judaqäna arha vitnaqa dä soknga mamär iva qä sär sä nas nämäni ama sämänanamuqa dä va ut nanakt na qa. ");
INSERT INTO uro_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Sa qat nanakt nä ma Ngämuqa. Rhäkt di mamär iva ma Ngämuqa qa rhumaiar qa qre i nani a qa na qa. Inguna sa qa qoar i, ‘Aingo di ma Ngämuqa aa emga na ngo.’” ");
INSERT INTO uro_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bä qosaqi ama suaiom gärqiom i sa rha edämsäs pät a iom mäni ama sämänanamuqa di ini slava nä ma Jisas toqor qärarhae ama ruvek na ama enge ama vu ngät. ");
INSERT INTO uro_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Bä sa nga rhoqoräkt i mäniqunäng mamär dä ama bängangit ngä män bät ama ivätki moe bä qale rhoqoräkt bä dängdäng bät ama däpguarhong säpbängang. ");
INSERT INTO uro_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bä nga nani äkt i ama däpguarhong säpbängang dä ma Jisas ka nok masirhat toqortäqyia, “Eloi, Eloi, lema sabaktani?” Iangärhäkt ama enge di angät tarimini rhoqortäqyia, “Gu Ngämuqa, gu Ngämuqa, mäniekt bä sa ngia qyiradeng na ngo?” ");
INSERT INTO uro_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bä nga arhani nävät iarhakt kärarhae i rhat mair e glaqot ta nari rhoqoräkt dä rhi qoar toqortäqyia, “Rhak täkt ama ruqa di qat tes ma Elaija.” ");
INSERT INTO uro_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Dä akni nävät a rha qa ang masirhat äkt bä qa ok ama bauläm ba ama wain ama valak mät ki at täväs näkt ka mu äm da ama ngämunget angät tpäs näkt ka rhäk et sä äm bä ma Jisas ivakt iva qä nakt. ");
INSERT INTO uro_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Sokt di arhani di rha qoar toqortäqyia, “As kale qa äkt dap pa ut luvät ivar ma Elaija qa rhän ivakt iva qä rhumaiar qa.” ");
INSERT INTO uro_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nasot dä saqi as ma Jisas ka nok masirhat näkt ka voda aa qloqaqa bä bä ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Dä nak sa ama boiqi ama mor qi qärakt i qiat nar va ama ansäspämgi ama mor qi di qyiret mät ki nädä at täväs bä samäk bä ama qävälam ama unbam. Bä vränbrän da ama ivätki dap läktgyäm sa ama dui. ");
INSERT INTO uro_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Näkt ama ñäpta arha lek di ma Ngämuqa qa rhar mät ngät dä ama räkt ta ama ruvek arhä släqyigleng gärarhani i sa rha ñäp di qa märanas nä igleng. ");
INSERT INTO uro_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bä vuk sä rha nämät arha lek toqoräkt i ma Jisas ka märanas nämät ama tñäpki bä nasot dä rha met sämät ama qumärqumär äm mamär ama värhäm ama mor äm näkt päs däm da da ama rhäqäp na rha ama ruvek arhä saqong. ");
INSERT INTO uro_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Bä nga vät ama qäväläm gärqomni i ama narhoerqa bä ba ama handret na rha ama ulaqimärharhärhäkt kä nä iarhakt kärarhae i rhit lu vät ma Jisas di rha lu ama qängängi bä sävät iangärhäkt ama lat kärangät i sa ngä män doqoräkt dä qräk mät ta masirhat mamär dap ti qoar toqortäqyia, “Qoki ngäktki i rhak täkt di ma Ngämuqa aa emga!” ");
INSERT INTO uro_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Dap toqoräkt di qosaqi qale ama rhäqäp na rha ama evop e qärarhani i sa mäqi rhat tet nasot ma Jisas inamuk nae ma Galili i rhat tatnärhäm ga bä rhat mair tämuk gläius i rhat lu rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mänguräp mä rha di qale ma Maria nae näva ama värhäm ama gaini na äm ma Makdala dä ma Jems kä nä ma Josep in nanäk ma Maria näkt ma Sebedi aa imiom ma Jems kä nä ma Jon in nanäk. ");
INSERT INTO uro_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sa nga rhoqoräkt i ama bängangäs dä akni ama qärhongbärhaqa nämät ama värhäm ma Arimatea qärak i rhat tes ka i ma Josep ka män. Qa di qosaqi qät päs ma Jisas aa rhäng. ");
INSERT INTO uro_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ma Josep di sa qa met sage ma Pailat bä qa nän ga rhä ma Jisas aa släqyige. Dä ma Pailat ka rhäkne iva aa ulaqimärharhärhäkt ti von dä ma Jisas aa släqyige ba qa. ");
INSERT INTO uro_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Dä ma Josep ka rha ma Jisas aa släqyige bä qa ong bät ige na ama uiu qi ama boiqi qäraktni i ama ingas ki dä ama qumärqumär qi. ");
INSERT INTO uro_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Näkt ka mas nä ige mät ama ñäpka aa liqi ama iaräs na qi qäraktni i sa qa rhap ma qi mäni ama qäsävit käraktni i qa maräkt aa liqi. Näkt ka egaeng ama dulige ama mor ige bä qa väsdät nä ige mät ka liqi näkt ka met na äkt. ");
INSERT INTO uro_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ma Maria nae ma Makdala qi na aktni ama Maria di qale lem e i in muqun dage nä qa ñäpka aa liqi. ");
INSERT INTO uro_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nga duququ vät ma Sabat dä ama priskäna ama moräs na rha rhi na ama Farisiqäna västämne na rha dä ma Pailat aa saqong ");
INSERT INTO uro_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","bä rha qoar toqortäqyia, “Aurha morqa, vuk pät a ut i as nga rhoqoräkt i iaqäkt ama irasmätka qat däqäm di qa qoar i, ‘Nasot ama dävaung ama qunäng dä va ngua rhäranas.’ ");
INSERT INTO uro_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Dä soknga mamär iva ngi rhäkne iva gi ulaqimärharhärhäkt ti väs mät aa liqi mamär bä dängdäng bät ama dävaung na qa ama qunäga i varis aa mudäsaqongda rha rhet bä rhi sua rha aa släqyige iva nasot dä va rhi qoar na ama ruvek i, ‘Sa qa märanas nämät ama tñäpki.’ Rhoqoräkt diva ama dängdängini ama irasini ama vu ini masirhat pa ama narhoer ini angät tpäs.” ");
INSERT INTO uro_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Näkt ma Pailat ka qoar na rha rhoqortäqyia, “Ngäni rha ama guläñgi na ama ulaqimärharhärhäkt bä ngän det näkt pa ngäni väs mät ka liqi mamär varhäm angän grot.” ");
INSERT INTO uro_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Dä soknga rha met bä rha väs mät ama liqi mamär na ama qrot ki ama ningnigi na arhä muqunän maräkt ivakt iva qaku mamär vät aung iva qä narut na ama dulige. Dap ta mu arhani ama ulaqimärharhärhäkt ivakt iva rhat nañäm säva arha rhäng. ");
INSERT INTO uro_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Bä nga nasot ama Sabat toqoräkt i qorhäs iva irige sa ama qunäga vät ama narhoer qa ama qunäga säng ama tadenas dä ma Maria nae ma Makdala qi na aktni ma Maria in met ivakt iva ini lu ama liqi qärakt i sa rha mu ma Jisas aa släqyige e. ");
INSERT INTO uro_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Dä nak sa ama qängängi ama mor qi qia män dap ama ensel nage ma Ngämuqa di sa ar sä qa inavuk näda ama usäpki arha ron bä qa män näkt ka egaeng ama dulige nae näkt ka muqun bät ige angärha rhäng. ");
INSERT INTO uro_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Aa ñämñämgi di ngi qoar qre bañämbañäm mät ama iauska dä aa boi di ama qulum ngät toqor ama qulum gi mamär ama eqoeqi. ");
INSERT INTO uro_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Dä ama ulaqimärharhärhäkt di värvar vät a rha masirhat mät ama tlenga bä rha män i rhoqor qre i sa ama ñäpta na rha. ");
INSERT INTO uro_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Dap ka ensel qa qoar na ama evovem doqortäqyia, “Qale init len inguna nguat dräm i init ñäm nani ma Jisas kärak i sa rha edämsäs pät a qa. ");
INSERT INTO uro_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Sa qaku a qa rhe inguna sa qa märanas i qoki varhäm aa enge mudu bä bä ngän. Ini ang ini lu nasot a qa i sa rha mas na aa släqyige rhe i. ");
INSERT INTO uro_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Dä mamär iva nasot dä va ini lir in det bä ini qoar na aa mudäsaqongda i sa ma Jisas ka märanas nämät ama tñäpki bä as ngäni lu iva qat tet sae ma Galili va angän gamäs näkt pa ngäni lu qa e. Nak sa ngua qoar na en doqoräkt.” ");
INSERT INTO uro_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bä äkt i in lir in met na äkt nämät ama liqi sa ama tlenga dä ama mor ngät ama märmärgem bä ina ang ivakt iva ini qoar nä ma Jisas aa mudäsaqongda nä iangärhäkt ka ensel aa enge. ");
INSERT INTO uro_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Dä nak sa ma Jisas ka män bät a em mäni ama iska bä qa qoar na em doqortäqyia, “Ama märmärgem sage ben!” Dä in met sagem ga bä in sangar aa qäriglem näkt ini nänsäs sagem ga. ");
INSERT INTO uro_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nasot dä ma Jisas ka qoar na em doqortäqyia, “Qale init len dap in det bä ini qoar nä gua ruavek iva rha rhet sae ma Galili näkt pa rhi lu ngo e.” ");
INSERT INTO uro_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Vät iomäkt ama qäväläm i nga in det dä nak sa arhani ama ulaqimärharhärhäkt kärarhae i mäqi rhit lu vät ma Jisas aa liqi rha met sämät ama värhäm bä rha qoar na ama priskäna ama moräs na rha sä iarhongäkt moe qärqärhong i sa irhong ngä märanas. ");
INSERT INTO uro_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bä sa nga ama priskäna ama moräs na rha sa västämne na rha rhi na ama morta dä rha märhamän bät a ne bä rhäksot dä rha von ga ulaqimärharhärhäkt ta ama ligär masirhat ");
INSERT INTO uro_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","dä rha qoar na rha rhoqortäqyia, “Va ngäni qoar nä guavek anga ruvek i, ‘Ma Jisas aa mudäsaqongda di sa rha män näp bängagi bä rha sua rha aa släqyige na äkt i nga rhoqoräkt i urhi mänatäm.’ ");
INSERT INTO uro_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Dap ngakt bä ama tpäskinaqa qä nari sävät tangät täkt ama lat dä va urhi von ga rha ama bulap sävät a ngän ivakt iva qaku ama märänga qa rhän bät a ngän.” ");
INSERT INTO uro_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bä äkt i rha rha ama ligär dä rha met parhäm ama priskäna ama moräs na rha rhi na ama morta arha enge. Näkt sa vräs dä rhangät täkt ama sameng mänguräp ama Judaqäna nävät iomäkt ama qäväläm bä dängdäng däkt. ");
INSERT INTO uro_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Dä ama ngärhäqyisem da sägäk ama mudäsaqongda rha met sae ma Galili bä sämäni ama damgi qärakt i sa ma Jisas ka qoar na rha na qi. ");
INSERT INTO uro_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bä nga rha lu qa dä rhi nänsäs sagem ga dap arhani nävät a rha di qaku rhat dräm i mamär iva rhat nanakt toqor mäniekt. ");
INSERT INTO uro_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Dä ma Jisas ka män sagem da bä qa qoar na rha rhoqortäqyia, “Sa ma Ngämuqa qa von ngo rha ama qrot moe na rhävuk näda ama usäpki arha ron dä qosaqi narhe nävät ivät. ");
INSERT INTO uro_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dä soknga mamär iva ngän det sage ama ruvek moe vät ama ivätki bä va ngänit säm a rha mä gu mudäsaqongda i ngäni baptais pät a rha na ama rigi nävät ama ngärhipki i ama Ngätmamäk dä ama Ngärhoemga dä ama Qloqaqa ama Qumärqumärqa. ");
INSERT INTO uro_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Näkt pa ngäni su rha iva rhat tet nasot ama muräkt moe qärangätni i sa ngua von ngän däm ngät. Näkt pa qale ngo gem ngän basägos bä dängdäng bät ama qäväläm gärqom iva rhäksot na ama ivätki.” ");
INSERT INTO uro_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Rhangät täkt ama enge di ama rharebäm sa ama sameng ama mär ngät sävät ma Jisas ma Krais ma Ngämuqa aa emga. ");
INSERT INTO uro_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ma Ngämuqa aa vämginaqa ma Aisaia qa säm doqortäqyia, “As ngäni lu i ngut täk nä gua engevärhaqa vä gi qamäs ivakt iva qä rhäkmu nä gia iska” ");
INSERT INTO uro_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","bä va qa diva “ama eguinga na qa qärakni i qät näs pät ama ivärhäs ama qräk dä bäs toqortäqyia, ‘Ngäni rhäkmu na ama iska nanokt ma Engeska dä ngäni slaräkt na ama is nanokt ka.’” ");
INSERT INTO uro_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Bä sa vuk sä ma Jon ama Baptais pät ama ivärhäs ama qräk dä bäs bä qä baptais pät ama ruvek. Dä qä sameng ba ama ruvek i mamär iva rhi näpgoer na nas näkt ti rha ama baptais bä va ma Ngämuqa qä qyiradeng na arha vuirhong. ");
INSERT INTO uro_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Dä ama rhäqäp na rha ama ruvek nävät ama ngärhäktka ma Judia näkt nämät ama värhäm ama mor äm ma Jerusalem dat dän sagem ga bä rhi sameng irhäm mes sa arha vuirhong bä qä baptais pät a rha mäni ama rigi ma Jordan. ");
INSERT INTO uro_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ma Jon aa murhämeska di qa rhoqor mudu ma Ngämuqa aa vämginarha arhä murhämeska i qa murhämes na ama boi i na ama qäseng nävät ama kamel näkt kät kop mäni nas na ama saunga na ama släktka aa ngädäga näkt aa tmäs di qat täs ama mes näkt kät nakt pa ama mäsu näva urqi. ");
INSERT INTO uro_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Näkt kä sameng i qat tamän doqortäqyia, “Qärak iva as dängdäng na qa nasot a ngo di aa qrot ngä vit pä gu qrot angät tpäs dä ama rhängämitnäm sa ama sandal nävät aa qäriglem angät tpäs di qaku ama märqa na ngo iva ngun gär bä ngu rhäväkt sä itnäm. ");
INSERT INTO uro_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aingo di ngu baptais pät a ngän na ama rigi dap ka diva qä baptais pät a ngän na ama Qloqaqa ama Qumärqumärqa.” ");
INSERT INTO uro_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Vät iangärhäkt ama qunäng imäk äkt dä ma Jisas ka män nämät ama värhäm ama gaini na äm ma Nasaret näva ama ngärhäktka ma Galili bä ma Jon gä baptais pät a qa mäni ama rigi ma Jordan. ");
INSERT INTO uro_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bä nga rhoqoräkt i vuk sä qa namäk näva rigi dä qa lu ama usäpki i qit gang masägos näkt arhar sa ama Qloqaqa ama Qumärqumärqa bä qa muqun bät a qa i qa rhoqor ama simängaqa. ");
INSERT INTO uro_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Näkt akni ama eguinga qa märhamän näda ama usäpki arha ron doqortäqyia, “Ainge di ngua emga na nge qärak i sa gua snäng bät a nge dä qosaqi märmär gem ngo masirhat nävät a nge.” ");
INSERT INTO uro_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dä nak kop äkt dä ama Qloqaqa ama Qumärqumärqa qa märanas nä ma Jisas bä qa er nanokt ka bä qa met sävät ama ivärhäs ama qräk dä bäs. ");
INSERT INTO uro_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Näkt kale qa vät iosäkt ama qräk dä bäs ama ivärhäs pät ama ruiom ama udiom na ama qunäng bä ma Sämga qa siqut na qa iva qa rhualat na anga vuirhong dä qale qa ge ama släkt ama ur ngät dap ama enselqäna rhat tatnärhäm ga. ");
INSERT INTO uro_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Näkt nasot toqoräkt i rha mu ma Jon ba ama tpäskiarharhäng dä ma Jisas ka män sae ma Galili bä qä sameng na ama sameng ama mär ngät nage ma Ngämuqa ");
INSERT INTO uro_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","i qat tamän doqortäqyia, “Ama rhodäm di sa rhäkmamär na ngät bä sa ma Ngämuqa aa Muräktpäm di sa nga e glaqot dap ngäni näpgoer na nas näkt ngänät nanakt na ama sameng ama mär ngät.” ");
INSERT INTO uro_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Näkt nga ma Jisas kat tet pät ama namuqa aa rhäkt ma Galili dä qa lu ma Saimon gä na aa läktka ma Andru i init don na ama väiuqi va ama namuqa inguna iom di ama väiumärhindäkt. ");
INSERT INTO uro_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Dä ma Jisas ka qoar na iom doqortäqyia, “Ini ang bä init päs gua rhäng bä va ngu su en iva ini rhar sa ama ruvek i rhoqor ma i ini rhar sa ama rhinäm.” ");
INSERT INTO uro_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Dä in märanas masägos daqule in bäiu bä in met nasot ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Qa met nae maqälak dä qa lu ma Jems ma Sebedi aa emga qä na aa läktka ma Jon i qosaqi qali liom mät in mlauski bä ini masartäm mät ama lek pät in bäiu. ");
INSERT INTO uro_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Dä qop ka mes iom masägos bä in met daqule in mamäk ma Sebedi qä na ama latta mät ama mlauski bä in met nasot a qa. ");
INSERT INTO uro_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bä sa rha met sämät ama värhäm ama mor äm ma Kaperneam bä nga vät ama Sabat dä ma Jisas ka mon säva ama mämairqi e bä qa nasäng iva qä su ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bä qräk mät ta nävät aa rhisu inguna qä su rha di qa rhoqor aung gärakni i ama qrot nga e gem ga dap kaku rhoqor ama Skraipkäna. ");
INSERT INTO uro_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Näkt pät iomäkt ama qäväläm di qale akni ama ruqa e gem da qärakni i ama iauska qa e mät ka. ");
INSERT INTO uro_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Bä qät näs toqortäqyia, “Jisas nae ma Nasaret, ngia män gem ut ivakt iva ngia mäsana? Nga ngia män iva nak ngia rhusar na ut? Nguat dräm i auge na nge. Ainge di ma Ngämuqa aa Qumärqumärqa mamär.” ");
INSERT INTO uro_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Dä ma Jisas ka näs täm ga rhoqortäqyia, “Mänadin däm nge näkt puk sä nge nämät ka.” ");
INSERT INTO uro_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dä ama iauska qa rhästäs a qa masirhat dä qat tuqaia bä vuk sä qa nämät ka. ");
INSERT INTO uro_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bä ama ruvek di qräk mät ta bä nga rhoqoräkt dä rhi snanbät sä ne rhoqortäqyia, “Agi aa lat tangät täkt? Ama rhisu ama iaräs na ngät i ngät dän sa angät krot! Dä na aa qrot dä qäqi qät täk na ama iaus dä ngät nari nämät ka.” ");
INSERT INTO uro_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ama sameng ngä lir ngä met sävät a qa vät ama ivärhäs moe ma Galili. ");
INSERT INTO uro_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nga vät ama qäväläm gärqomni i rha met daqule ama mämairqi di rhi nä ma Jems kä nä ma Jon bä sävä ma Saimon gä nä ma Andru ina vät. ");
INSERT INTO uro_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Dap ma Saimon aa rhäväski di aräm gi mäni lai dä aqärnas päm gi dä rha qoar nä ma Jisas sävät a qi rhoqoräkt i qa män. ");
INSERT INTO uro_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Dä ma Jisas ka met bä qa sangar da at tärhäqyet bä qa mair na qi bä ama rämgi qia met nävät a qi dä qia nasäng i qit täkmu iva qi rhäk pät a rha na anga tmäs. ");
INSERT INTO uro_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Näkt äkt säng ama bängagi arha ribit dä ama ruvek ta män sage ma Jisas sa ama ruvek ama rhäqäp na rha qärarhani i ama rämgi vät a rha bä sävät ama ruvek kärarhani i ama iaus ngärhit täk pät a rha. ");
INSERT INTO uro_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bä qorhäs iva ama ruvek moe nävä iomäkt ama värhäm da män bä västämne na rha da ama vätka aa väm sä ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Dä ma Jisas ka mumäräs pät ama rhäqäp na rha sa ama räm maos maos dä qa qutmäs ama rhäqäp ama iaus nämät ama rhäqäp na rha ama ruvek. Iangärhäkt ama iaus di ngät dräm a qa dä soknga qaku qa rhares pät angärha rhäng iva ngät tamän. ");
INSERT INTO uro_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Qoki as pät duququs mamär toqoräkt i as kaku qunäga dä ma Jisas ka märanas bä vuk sä qa sä dalek bä qa met sävät aosni ama ivärhäs i qaku anga ruvek e bä qä nän. ");
INSERT INTO uro_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Dä ma Saimon gä na aa ruavek ta met ivakt iva rhit ñäm nani a qa. ");
INSERT INTO uro_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bä nga rha män bät a qa dä rha saengäkt ba qa rhoqortäqyia, “Ama ruvek moe di rhit ñäm nani a nge.” ");
INSERT INTO uro_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Va u rhet sa ni as säva anga värhap glaqot ivakt iva qosaqi ngu sameng inguna rhom däkt di ama rharebäm sä gu mänmänäs.” ");
INSERT INTO uro_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Näkt ma Jisas ka met bä qät kutmäs ama iaus nämät ama ruvek dä qä sameng ba ama mämairväm e ma Galili moe. ");
INSERT INTO uro_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Akni ama biaspärhaqa qa män sage ma Jisas bä qa an da aa quum sä nas säng aa qar dap kät nok pät a qa i qä qoar toqortäqyia, “Ngakt bä nani a nge di märmärsäs gem nge iva ngia rhumäräs pät a ngo.” ");
INSERT INTO uro_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Dä ma Jisas ka lavuqi na qa masirhat dä qa rhäk aa rhäqyet bä qa rhäk pät a qa näkt ka qoar na qa rhoqortäqyia, “Ari, nani a ngo. Rhäkt di sa märäs pät a nge bä ama qumärqumärqa na nge.” ");
INSERT INTO uro_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Vät iomäkt ama qäväläm maräkt dä ama bias ngä met nävät a qa bä sa märäs pät a qa. ");
INSERT INTO uro_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Dä ma Jisas ka rhäk na qa masägos sa ama mugem ama qrot ngät toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Qale ngi naqoar na aung sävät a nas dap kinak ngia rhet bä ngi qur ama pris täm mes näkt ngi voda ama vodämes kärangät i mudu ma Moses ka mu ngät nävät gi qumärqumär ivakt iva ama ruvek ti lu i sa märäs pät a nge.” ");
INSERT INTO uro_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Qinak kärak di qaku qa met toqoräkt dap kinak ka met bä qä nasäng i qä sameng sävät iangärhäkt ama mumaiar bä vräs da ama sameng. Nguna nävät iomäkt dä ma Jisas di qaku mamär iva qä namon sämät anga värhäm da ama ruvek arhä saqong dap sokt kale qa rhage va ama ivärhimek kärqämekni i qaku anga ruvek e sokt di qop ama ruvek nävät ama ivärhimek moe rhat dän sagem ga. ");
INSERT INTO uro_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nasot ama marheka na ama qunäng bät ama qäväläm gärqomni i ma Jisas ka mon sämät ama värhäm ma Kaperneam bä ama ruvek ta nari sävät a qa i qa män säva vät ");
INSERT INTO uro_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","dä ama rhäqäp na rha ama ruvek pästämne na rha vuk pa vät gem ga bä qaku anga släqyäs puk pa vät bä sä dalek sämät ama edäbäs. Västämne na rha gem ga bä qä sameng bät a rha nä ma Ngämuqa aa enge. ");
INSERT INTO uro_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dä arhani ama gamoe rha män sa ama ruqa qärakni i ama ngäñäp pät a qa ivakt iva rhi rha qa sage ma Jisas. Rha män sä qa i ama levaet na rha rhit ta qa. ");
INSERT INTO uro_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Rha lu i qaku mamär iva rhi narha qa sage ma Jisas inguna qaku anga släqyäs dä soknga rha mualat na ama liqi va ama vätka aa rhäng daver ma Jisas. Bä nga rha sämamor na ama liqi bä rhäksot dä rha rhäk kärak mät aa gasgaska mät ki bä rha anbut sä qa samäk säva vät sage ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Bä nga ma Jisas ka lu qärangätni arhä qatnanakt dä qa qoar nä qä ngäñäpärhaqa rhoqortäqyia, “Ngua emga, sa ngua qyiradeng nä gia vuirhong.” ");
INSERT INTO uro_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dap arhani ama Skraipkäna di rhat muqun e bä nga rha nari rhoqoräkt dä rhat tu arhä snäng doqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Mäniekt bä rhak täkt kat tamän doqor täkt? Rhak täkt ama ruqa di qat tamän mava nä ma Ngämuqa! Auge mamär vät a qa iva qät kyiradeng na ama ruvek arha vuirhong i qop nguna sokt ma Ngämuqa?” ");
INSERT INTO uro_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Vät iomäkt ama qäväläm dä ma Jisas ka räm gärarhae arhä mungäsnäng dä qa snanbät sä rha rhoqortäqyia, “Mäniekt bä ngän du angän snäng bät tärhong däkt? ");
INSERT INTO uro_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Guaäm goe di märmärsäs mamär iva ngu qoar na ama ngäñäpärhaqa na äm? Va ngu qoar toqortäqyia, ‘Sa ngua qyiradeng nä gia vuirhong’ ura va ngu qoar toqortäqyia, ‘Ngia rhair näkt ngi rha gi gasgaska bä ngiat tet’? ");
INSERT INTO uro_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bä nävät tom däkt diva mamär vät a ngän iva ngänät dräm i ma Ruqa aa Emga di ama rhares pät aa rhäng de vät ivät iva qät kyiradeng na ama vuirhong.” Näkt ka qoar nä qä ngäñäpärhaqa rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ngu qoar na nge i ngia rhair näkt ngi rha gi gasgaska bä ngia rhet säva vät.” ");
INSERT INTO uro_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dä qop kärak ka mair näkt ka lir qa rha aa gasgaska näkt puk sä qa da arhä saqong moe. Rha moe di qräk mät ta rhoqoräkt bä rha voda ama murhämeska sage ma Ngämuqa i rhat tamän doqortäqyia, “Sa mudu qaku ut lu guani rhoqor täkt!” ");
INSERT INTO uro_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Saqi as ma Jisas ka met bä sävät ama namuqa aa rhäkt ma Galili dä ama guläñgi na ama ruvek ta män sagem ga bä qä nasäng i qä su rha. ");
INSERT INTO uro_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Rhoqoräkt i qat tet dä qa lu ma Livai ma Alfius aa emga i qat muqun ba ama vätka qärakni i ama ruvek tit boda ama takes sae. Dä ma Jisas ka qoar na qa rhoqortäqyia, “Ngit päs gua rhäng.” Dä qa märanas bä qa met nasot ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Näkt pät ama qäväläm i ma Jisas kat täs pä ma Livai aa vätka di ma Jisas kä na ama rhäqäp na rha ama ruvek kärarhani i rhit ta ama takes bä sävät arhani ama ruvek kärarhani i ama vu rha di rha moe rhat täs ti na qa qä na aa mudäsaqongda. Rhoqoräkt dinguna ama rhäqäp na rha ama ruvek ta met nasot a qa. ");
INSERT INTO uro_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bä nga ama Skraipkäna qärarhani i rha nävät ama Farisiqäna rha lu qa rhoqoräkt i qat täs kä na ama ruvek kärarhae i rhit ta ama takes näkt sävät arhani ama vurha dä rha snanbät sa aa mudäsaqongda rhoqortäqyia, “Mäniekt bä qat täs kä nä iarhakt ama ruvek kärarhae i rhit ta ama takes dä ama vurha?” ");
INSERT INTO uro_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Bä nga ma Jisas ka nari rhoqoräkt dä qa qoar na rha rhoqortäqyia, “Iarhakt kärarhae i ama märäs pät a rha di qaku rhit läk nani ama ruqa qärakni i qat dräm gat tumäräspät dap sokt kärarhani i ama rämgi vät a rha di rhit läk nani ama ruqa rhoqoräkt. Qaku ngua män ivakt iva ngua rhes iarhakt kärarhae i ama räktta na rha sagem ngo dap kinak ngua män ivakt iva nani ama ruvek kärarhani i rhat tualat na ama vuirhong.” ");
INSERT INTO uro_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ma Jon aa mudäsaqongda näkt ama Farisiqäna di rhat teranot dä arhani ama ruvek ta met sage ma Jisas bä rhi snanbät sä qa rhoqortäqyia, “Mäniekt bä ma Jon aa mudäsaqongda rhi na ama Farisiqäna arhä mudäsaqongda di rhat teranot dap ainge gi mudäsaqongda di qaku?” ");
INSERT INTO uro_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Nga mamär iva ama gamoeqa qärakni iva rhit bodäm na qa aa ruavek tat teranot toqoräkt i qale qa qä na rha?” Dä ma Jisas ka muvät pät a nas toqortäqyia, “Qaku mamär iva rhat teranot toqoräkt i as kale qa gem da.” ");
INSERT INTO uro_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Dap ama qäväläm as pa äm ngä rhän iva ama gamoeqa qärak iva rhit bodäm na qa diva rhi rha qa daqule rha bä vät iangärhäkt ama qunäng nasot a qa dä va rhat teranot. ");
INSERT INTO uro_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Dä qaku aung gä naqutäm sa anga iar ini anga baulini mät anga liqi mäni anga mru qi anga boiqi. Ngakt bä va qa rhualat toqoräkt dä va ama baulini ama iar ini ngärhi arot nämäni ama mru qi ama boiqi bä va ini ngärhi sämamor na ama liqi. ");
INSERT INTO uro_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Näkt nasot dä qä qoar toqortäqyia, “Qosaqi qaku aung gä narhor na anga iar qi anga wain sämät anga mru ngät anga ngädäng gärangätni i rhit tor na ama wain sämät ngät. Ngakt bä va qa rhualat toqoräkt dä va ama wain ama iar qi qi vukdor va ama ngädäng bä va ama wain gi na ama ngädäng diva mava na ngät. Qaku mamär iva aung gä namualat toqoräkt dap sokt mamär iva qät tor na ama iar qi ama wain sämät ama iar ngät ama ngädäng.” ");
INSERT INTO uro_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Vät akni ama Sabat dä ma Jisas kat tet da ama et na ama wit dä qosaqi nga aa mudäsaqongda rhat tet dä rhi nasäng i rhi nänbäñ sa ama gavämirhong. ");
INSERT INTO uro_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Dä ama Farisiqäna rha qoar na qa rhoqortäqyia, “Ura, mäniekt bä rhi nänbetäkmät na ama Muräkt pät ama Sabat?” ");
INSERT INTO uro_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Dä qa snanbät sä rha rhoqortäqyia, “As nga qaku ngän mes sävät agi a lat kärangätni i ma Devit ka mualat na ngät toqoräkt i qa qä na aa ruavek di anoeng mä rha dä rhit läk? ");
INSERT INTO uro_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ngät tamän i nga vät ma Abiatar ama pris ama vit na qa aa qunäng dä ma Devit ka mon säva ama ansäspämgi ama me qi bä qa mäs ama tmäs kärangätni i rhit bodäm ngät sage ma Ngämuqa. Näkt iangärhäkt ama tmäs di ama Muräkt ngät tamän i qaku mamär vät anga ruvek mavängam iva rhat täs nävät a ngät dap sokt ama priskäna. Näkt kosaqi qa von aa ruavek ta angätni.” ");
INSERT INTO uro_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Näkt sa ma Jisas ka qoar na rha rhoqortäqyia, “Ama Sabat diva qat tatnärha ama ruvek dap pa qaku ama Sabat kä natmuräkt ta ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Bä mamär iva ngänät dräm i aingo ma Ruqa aa Emga di qäqi ma Engeska bä ba ama Sabat.” ");
INSERT INTO uro_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Saqi ma Jisas ka mon säva ama mämairqi dap akni ama ruqa qärakni i ama ñäp aa rhäqyet di qale qa e. ");
INSERT INTO uro_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Dap arhani nävät ama Farisiqäna di rhat lu ma Jisas mamär ivar qa rhumäräs pät kärak pät ama Sabat ivakt iva rhi rhäksärhäm ga. ");
INSERT INTO uro_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mamär dä ma Jisas ka qoar nä qärak i ama ñäp aa rhäqyet toqortäqyia, “Ngia rhair bä ngiat mair da ama ruvek moe arhä saqong.” ");
INSERT INTO uro_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Näkt ma Jisas kä snanbät sä rha rhoqortäqyia, “Guani qoe di ama Muräkt ngärhit tares pät ini angärha rhäng bät ama Sabat? Nga maräkt iva ut tualat na ama lat ama mär ngät ura va ut tualat na ama vuirhong bä qosaqi nga maräkt iva ut tumaiar ama ruqa aa iar ura va urhi veng?” Rhoqoräkt dä qop kaku rha muvät pät a qa. ");
INSERT INTO uro_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Dä ma Jisas ka ñäm namet a nas sävät a rha na ama uraqi inguna rhäqäp ka na ama märänga sä rha nävät arhä väs ama qrot ngät dä qa qoar nä qärak ka ruqa rhoqortäqyia, “Ngia rhurän dä ngia rhäqyet.” Dä qa murän da aa rhäqyet bä sa märäs pät a et mamär. ");
INSERT INTO uro_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bä na äkt dä ama Farisiqäna rha met bä rha nasäng i rhat tamän särhäm ne rhi nä ma Herot aa ruvek kärarhani i rhat tair va aa rhäng iva rhi veng ma Jisas toqor mäniekt. ");
INSERT INTO uro_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Evär dä ma Jisas kä na aa mudäsaqongda sävät ama namuqa aa rhäkt dä ama guläñgi ama mor qi na ama ruvek nae ma Galili rhat tet nasot a rha. ");
INSERT INTO uro_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bä nga rha nari sävät kärqärhong moekt i qat tualat nä irhong dä ama rhäqäp na rha ama ruvek ta män sagem ga nae ma Judia näkt ma Jerusalem bä nävät ama ngärhäktka ma Idumea bä näva ama ivärhimek tage na ama rigi ma Jordan bä nae namet ama värham ma Tair dä ma Saidon. ");
INSERT INTO uro_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Dä ma Jisas ka nän aa mudäsaqongda iva rhi rhäkmu na anga mlauski anga gaini na qi bä ba qa inguna ama mor qi ama guläñgi bä varis ngakt dä rhi narhäkbrät ka. ");
INSERT INTO uro_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sa qa nän aa mudäsaqongda rhoqoräkt inguna qa mumäräs pät ama rhäqäp na rha bä arhani sa ama räm di rhit tägär na ama ruvek nanokt nas ivakt iva rhit täk pät a qa. ");
INSERT INTO uro_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Bä nga ama iaus nämät ama ruvek di ngärhit ñäm sävät ma Jisas dä ngät täqäne sä iarhakt ama ruvek iva rhit lir ti nän da arhä quum sä nas säng aa qar dä rhit näs masirhat toqortäqyia, “Ainge di ma Ngämuqa aa emga.” ");
INSERT INTO uro_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sokt di ma Jisas ka von da rha ama enge na ama mugem ama qrot ngät iva qale rhi namuqunäga sä qa ba ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ma Jisas ka met bä sämäni ama damgi näkt ka mes iarhakt kärarhae i nani a qa na rha sagem mes bä rha män sagem ga. ");
INSERT INTO uro_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Näkt ka armeng da ama ngärhäqyisem da udiom na rha bä qa muqunän bät a rha iva ama ngangda na rha sä ma Ngämuqa aa lat. Dä va qale rha gem ga bä va qät täk na rha ivakt iva rhi sameng ");
INSERT INTO uro_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","bä qosaqi va rhi rha ama rhares ivakt iva rhit kutmäs ama iaus nämät ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Sa qa armeng dä rhärha rhäkt ama ngärhäqyisem da udiom na rha i ma Saimon gärak i qa mes ka i ma Pita ");
INSERT INTO uro_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","näkt ma Jems kä na aa läktka ma Jon ma Sebedi aa imiom. Ma Jisas ka mes iom na ama ngärhipki i ma Boanerges i rhakt täkt ama ngärhipki di qi sameng sävät a iom i iom di rhoqor ama iauska qärakni i vukpukdur väm ga ");
INSERT INTO uro_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","dä ma Andru dä ma Filip dä ma Bartolomyu dä ma Matyu dä ma Tomas dä ma Jems ma Alfius aa emga dä ma Tadius dä ma Saimon gärak i rhat tes ka i ama Selot ");
INSERT INTO uro_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","näkt sävät ma Judas Iskariot kärak i qa vodä ma Jisas säva aa ikkäna arhä rhäkt. ");
INSERT INTO uro_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ma Jisas ka mon säva akni ama vätka bä saqi as ama guläñgi na ama ruvek pästämne na rha e bä qa qä na aa mudäsaqongda di qaku anga släqyäs ba rha iva rha äs anga tmäs. ");
INSERT INTO uro_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Dä aa qärhae rha nari sävät a qa rhoqoräkt dä soknga rha män ivakt iva rhi rhäqoar sä qa inguna ama ruvek ti qoar toqortäqyia, “Sa inirqi na qa.” ");
INSERT INTO uro_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Dap ama Skraipkäna qärarhani i rha män nae ma Jerusalem di rhi qoar toqortäqyia, “Ma Jisas di ma Belsebul qa e mät ka bä nävät iaqäkt kärak i ama iaus angät narhoerqa aa qrot di qät kutmäs ama iaus.” ");
INSERT INTO uro_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Dä soknga ma Jisas ka mes ta bä qat tamän särhäm da na ama enge na ama siqut toqortäqyia, “Mamär vät ma Sämga iva qä qutmäs a nas toqor mäniekt? ");
INSERT INTO uro_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ngakt bä anga muräktpäm di sa ngä matmät na nas diva qaku angärha anga uiuit. ");
INSERT INTO uro_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Dä qosaqi ngakt bä nga anga sägärhae näva anga vätka di sa rha matmät na ne diva qaku mamär iva rhi natmair i ama sägärhae na rha. ");
INSERT INTO uro_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Bä ngakt bä ma Sämga aa qärhae rhi arhäktgyäm sä ne bä rhat tatmät na nas diva qaku aa muräkt angärha anga qrot dap aa qrot di sa rhäktäksot na ngät. ");
INSERT INTO uro_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ngäni qoar i ngut kutmäs ama iaus nävät ma Sämga aa qrot sokt di as ngäni lu rhärhom i qaku mamär vät aung iva qa rhon säva anga qrot ka anga ruqa aa vätka bä qä rha aa qärhong dap koki ngakt bä nga qa er qä qop pät a qa. Dä nak as mamär vät a qa iva qä rha aa qärhong. ");
INSERT INTO uro_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nguat tamän särhäm ngän na ama engäktki i ama ruvek arha vuirhong moe näkt sävät arha märhamän mava moe nä ma Ngämuqa diva qä qyiradeng ba rha. ");
INSERT INTO uro_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Dap aung gärakni i qat tamän mava na ama Qloqaqa ama Qumärqumärqa diva qaku ma Ngämuqa qä naqyiradeng ba qa dap ianiäkt aa vuini diva ini ngät däqäm basägos.” ");
INSERT INTO uro_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ma Jisas kat tamän doqoräkt sävät ama märhamän mava inguna qärarhani ama Skraipkäna di rhat tamän doqortäqyia, “Ama Qloqaqa ama Qumärqumärqa di qaku qat tualat gem ga dap kinak ama iauska qa e mät ka.” ");
INSERT INTO uro_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ma Jisas aa nanäk näkt aa läktpek ta män bä rhat mair dalek dap ta rhäk na akni ivakt iva qa rhet nani a qa sagem da. ");
INSERT INTO uro_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dap ama guläñgi na ama ruvek di rhat muqun namet a qa bä rha qoar na qa rhoqortäqyia, “Gi nanäk ki nä gia läktpek di iarha namäk dalek i nani a rha na nge iva ngia rhet sagem da.” ");
INSERT INTO uro_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Dä ma Jisas ka snanbät sä rha rhoqortäqyia, “Agukt koe di gu nanäk bä guavek koe di gua läktpek?” ");
INSERT INTO uro_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Näkt ka ñäm sävät iarhakt kärarhae i rhat muqun namet a qa näkt ka qoar toqortäqyia, “Gu nanäk ki nä gua läktpek di rhärha rhäkt! ");
INSERT INTO uro_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Auge qärak i qat tet parhäm ma Ngämuqa aa snängaqa di iaqäkt di gua läktka bä gua läktki bä gu nanäk.” ");
INSERT INTO uro_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Saqi as ma Jisas kä nasäng i qä su ama ruvek pät ama namuqa aa rhäkt. Dä ama guläñgi na ama ruvek kärarhani i västämne na rha namet a qa di ama mor qi dä soknga qa veng sämät ama mlauski ama lil qi bä qat muqun mät ki va ama namuqa dap kale ama ruvek moe vät a qoan bät ama namuqa aa rhäkt. ");
INSERT INTO uro_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Bä qä su rha rha ama rhäqäp nä irhong na ama enge na ama siqut. Rhoqoräkt i qä su dä qa märhamän doqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“As ngäni nari! Maos dä akni ama latka qärakni i qät don na ama gavämirhong ga met säva ama etki ivakt iva qä qutnanokt pät a qi. ");
INSERT INTO uro_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bä nga qät don na ama gavämirhong bät ama etki dä arhongni ama gavämirhong ngä säp sä varhäm ama iska bä ama isäm ngä män bä ngä mäs irhong. ");
INSERT INTO uro_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Dap arhongni ngä säp sävät ama ivärhimek ama dui väm imek äkt i qaku ama ivätki masirhat. Bä ama gavämirhong ngä lir ngä ir inguna ama ingas ama ivätki. ");
INSERT INTO uro_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sokt di nga ama qunäga qa sek mes dä qek pät irhong bä nät däm irhong inguna qaku irhong angärha anga qridu anga uiu ngät. ");
INSERT INTO uro_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Dap arhongni ama gavämirhong ngä säp sä mänguräp ama ritgung bä nga ama ritgung ngä ir dä ngä ong ama gavämirhong bä ngä slava nä irhong angärha irhirqi bä qaku irhong ngä sa. ");
INSERT INTO uro_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Dap arhongni ngä säp sävät ama mär qi ama ivätki bä irhong ngä ir bä irhong ngä sa i arhong ngä sa ama ruqa ama rhäk täm ga da ama ngärhäqyisem nä irhong ama gavämirhong dap arhong ngä sa ama dävaung na rha ama ruvek nä irhong dap arhong ngä sa ama handret nä irhong ama gavämirhong.” ");
INSERT INTO uro_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Dä qosaqi qa qoar toqortäqyia, “Iaqäkt kärak i nani a qa iva qunäga vät a qa sä gua enge di mamär iva qat nari mamär.” ");
INSERT INTO uro_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Näkt nga mamär i sokt ka qale qa qä na aa mudäsaqongda ama ngärhäqyisem da udiom na rha näkt sävät arhani namet a qa dä rhi snanbät sä qa iva qä rhäväkt sa aa enge na ama siqut. ");
INSERT INTO uro_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Dä qa märhamän särhäm da rhoqortäqyia, “Aingän di sa ma Ngämuqa qa rhares ba ngän iva qunäga vät a ngän sävät ma Ngämuqa aa Muräktpäm. Dap iarhakt kärarhae i qaku qale rha vä ma Ngämuqa aa Muräktpäm di rhat nari iarhongäkt moe na ama enge na ama siqut.” ");
INSERT INTO uro_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Rhoqoräkt diva rhäkmamär varhäm ma Aisaia aa enge qärangät i sa mudu qa säm a ngät toqortäqyia, “‘Näma dä äkt bä rhat nañäm sokt diva qaku rhi nalu guani bä näma dä äkt bä rhat nari sokt diva qaku qunäga vät a rha. Bä nga nävät iangärhäkt arha lat dä va qaku rhi narhong sävät ma Ngämuqa ivakt iva qä qyiradeng na arha vuirhong!’” ");
INSERT INTO uro_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Dä saqi as ma Jisas ka snanbät sä rha rhoqortäqyia, “Nga sa qaku qunäga vät a ngän sä rhangät täkt ama enge na ama siqut? Bä nga rhoqoräkt dä ngu lu va qunäga vät a ngän sa angätni ama enge na ama siqut moe rhoqor mäniekt? ");
INSERT INTO uro_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ama latka qärakni i qät don na ama gavämirhong di qä sameng nä ma Ngämuqa aa enge. ");
INSERT INTO uro_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ama gavämirhong gärqärhongni i irhong ngä säp parhäm ama iska di rhoqor arhani ama ruvek kärarhani i rha nari ma Ngämuqa aa enge dap sokt di vät iomäkt ama qäväläm dä ma Sämga qat dän masägos bä qät ta ama enge näda arha rhon. ");
INSERT INTO uro_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Dap arhani ama ruvek di rha rhoqor ama gavämirhong gärqärhong i sa ama latka qa rhon nä irhong bät ama dui vät imek ama ivärhimek di iarhakt kärarhae i rha nari ma Ngämuqa aa enge näkt ta lir ta sangar sävät a ngät na ama märmärgem. ");
INSERT INTO uro_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Dap kaku ama enge angät snagut ngä mon säda arha ron mamär dä soknga rhat mair ma ama qrot nak kop pät ama qot äm ama qäväläm. Bä nga anga märänga qat dän bät a rha ura ama ruvek ti sangäm na rha inguna nävät ma Ngämuqa aa enge dä lärlir mämae da arhä qatnanakt. ");
INSERT INTO uro_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Dap arhani di rha rhoqor ama gavämirhong gärqärhong i qa latka qa rhon nä irhong sä mänguräp ama ritgung. Iarhakt ama ruvek di rha nari ma Ngämuqa aa enge ");
INSERT INTO uro_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","sokt di ama qänäskänes nämäni rhangät täkt ama iar dä ama snängaqa ama mor qa sävät ama mämägän narhe qärangätni i ngärhi irastäm sa ama ruvek näkt ama snängaqa masirhat sävät arhongni ngät dän bä iarhongäkt ngä ir bä irhong ngä slava nä ma Ngämuqa aa enge angärha irhirqi bä qaku ngä sa anga gavam anga mär ngät pät iarhakt ama ruvek arha iar. ");
INSERT INTO uro_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Dap arhani ama ruvek di rha rhoqor ama gavämirhong gärqärhong i ama latka qa rhon nä irhong bät ama ivätki ama mär qi. Iarhakt di qärarhae i sa rha nari ma Ngämuqa aa enge näkt ta rha ngät bä ba nas bä ngärhit sa ama gavam bät arha iar. Bä nävät ama sägäni sägäni ama gavämini di arhani di rhit sa ama ruqa ama rhäk täm ga da ama ngärhäqyisem na ngät ama gavam dap arhani di rhit sa ama dävaung na rha ama ruvek na ngät dap arhani di rhit sa ama handret na ngät ama gavam.” ");
INSERT INTO uro_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Dä ma Jisas ka snanbät sä rha rhoqortäqyia, “Nga mamär iva aung ga rhon säva anga vätka sa anga lirhäga qärakni i qat dang bä qa rhu qa va anga uratki arha rem ura va anga laiqa aa rem?” Nasot dä qa qoar na rha rhoqortäqyia, “Qaku, dap kat dräm gat täkt a qa rhävuk. ");
INSERT INTO uro_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Inguna qaku guani qärqäni i ama ngaip ini diva qaku rhi namuqunäga sä ini dä qaku guani qärqäni i ini nga e väm diva qaku vuk sä ini säda eraqi.” ");
INSERT INTO uro_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Dä qosaqi qa qoar toqortäqyia, “Iaqäkt kärak i nani a qa iva qunäga vät a qa sä gua enge di mamär iva qat nari mamär.” ");
INSERT INTO uro_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma Jisas kat tamän särhäm da i qa qoar na rha rhoqortäqyia, “Mamär iva ngän du angän snäng mamär vät ianiäkt kärqäni i ngänät nari ini” näkt kosaqi qa qoar na rha rhoqortäqyia, “Iaqäkt ama siqutka qärak i ngän du qa sävät arhani diva qosaqi ma Ngämuqa qa rhu qa sävät a ngän bä qop as pa qä von ngän masirhat. ");
INSERT INTO uro_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Inguna aung gärakni i sa aa anga guani diva rhi von ga rha arhongni savono sae. Dap aung gärakni i sa qaku aa anga guani diva qäqi rhi rha aa qäni ama gaini nä ini nagem ga.” ");
INSERT INTO uro_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Dä ma Jisas kosaqi qä su rha i qä qoar toqortäqyia, “Ma Ngämuqa aa Muräktpäm di ngäkt kre ama ruqa i qät don na ama gavämirhong bät ivät. ");
INSERT INTO uro_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Bä nga ama bängang dä ama qunäng doqoräkt i qä mänatäm ura qat täranas dap ama gavämirhong di vukpukge mät irhong bä irhong ngärhi rhir sokt di qop kaku qunäga vät a qa i rhoqor mäniekt sä irhong angärha irhirqi. ");
INSERT INTO uro_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Näkt koki sokt ama ivätki qia märmor irhong bä irhong ngä sa ama gavam i mänasäng di vuk sa ama rharebäm sa ama ngärhäqyitnäk bä na äkt dä sa ama rharebäm sa ama tpäski näkt sa ama gavämirhong mät ama tpäski moe. ");
INSERT INTO uro_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Bä nga sräp ama gavam dä qa ruqa qa mu aa singi mäni ngät inguna ama qäväläm ngä män ivakt iva sa qät dodäktgyäm ngät.” ");
INSERT INTO uro_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Dä saqi as ma Jisas ka snanbät toqortäqyia, “Ngu lu va ngua rhuqut tä ma Ngämuqa aa Muräktpäm sävät agiqa? Ura va agi enge na ama siqutki diva ngua rhamän na ngät ivakt iva ngärhi sameng sävät a ngät? ");
INSERT INTO uro_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ma Ngämuqa aa Muräktpäm di ngät toqor ama mastard aa gavämini qärqäni i ama gaini mamär qärqäni i akni ama ruqa qa qutnanokt ini va ama ivätki. ");
INSERT INTO uro_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Sokt di sa nga qa qutnanokt ini dä ini ngä ir ma ama mor qa ama ngämuga bä qorhäs iva qä ir va ama lat angät namuirhong angät tpäs moe bä iaqäkt ama ngämuga di aa rhäkt ama mor ngät bä ama isäm di mamär iva ngärhit täk pät angärha vät pät aa qän.” ");
INSERT INTO uro_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Bä qosaqi angätni ama rhäqäp ama enge na ama siqut toqor tangät täkt di ma Jisas kat tamän särhäm da na ngät nä ma Ngämuqa aa enge. Qat tamän särhäm da na ngät as toqoräkt i mamär iva qunäga vät a rha. ");
INSERT INTO uro_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ma Jisas di qop sokt kat tamän särhäm da na ama enge na ama siqut. Dap kinak nga rhoqoräkt i sokt ka qä na aa mudäsaqongda dä qät täväkt sa ama enge moe bä ba rha. ");
INSERT INTO uro_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Vät iaqäkt ama qunäga rhoqoräkt i bängangäs dä ma Jisas ka qoar na aa mudäsaqongda rhoqortäqyia, “U rhet samit särhage na ama namuqa.” ");
INSERT INTO uro_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Dä sa rha met daqule ama ruvek bä rha mon sämät ama lil qi ama mlauski sage ma Jisas bä rha met. Dap kosaqi angätni ama lel ngät ama mlaus ngä väs aa rhäng doqoräkt. ");
INSERT INTO uro_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bä nga rhat tet dä ama lauräm ama qrot äm mamär ngä män masägos bä ama vaeng ngä mon sämät ama mlauski bä rhäqäptäqäp ki bä qorhäs iva qia rhon. ");
INSERT INTO uro_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Dap ma Jisas di qale qa da ama mlauski at es bä qä mänatäm i mae säng aa uväs. Dä aa mudäsaqongda rha rhäqäm a qa näkt ta snanbät sä qa i rhit näs toqortäqyia, “Qamorqa, nga qaku qänäskänes nge qrekt bä ut moe urhi ñäp?” ");
INSERT INTO uro_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Dä ma Jisas ka märanas bä qa anmae da ama laurqi na ama enge ama qrot ngät näkt ka qoar na ama vaeng doqortäqyia, “Mänadin! Mae vät a ngän!” Dä soknga qäp da ama lauräm dap mänadin bät ama qoeväs mamär. ");
INSERT INTO uro_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Näkt ka qoar na aa mudäsaqongda rhoqortäqyia, “Mäniekt bä ngänit len masirhat? Nga qoki as kaku angän anga qatnanakt?” ");
INSERT INTO uro_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Dä rhäqäp ta mamär na ama tlenga dä rhi snanbät sä ne rhoqortäqyia, “Nak sa auge rhak täkt kärak i qäqi ama laurqi dä ama vaeng ngät nari nämät ka?” ");
INSERT INTO uro_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Rha män bä särhage na ama namuqa ma Galili bä sävät ama Gerasaqäna arha ivärhäs. ");
INSERT INTO uro_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Bä nga ma Jisas puk sä qa nämät ama mlauski dä qoki äkt dä akni ama ruqa qärakni i ama iauska qa e mät ka qa män nämät ama ñäpta arha lek ivakt iva qa rhän sage ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Rhak täkt ama ruqa di qale qa mät ama ñäpta arha lek näkt kaku mamär vät aung iva saqi as kä naqop pät a qa na anga qoi bä qäqi qaku mamär vät aung iva qä naqop pät a qa na anga sengäna. ");
INSERT INTO uro_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","I sa nguna sai dä rhit kop mät aa rhäkt dä aa qar na ama sengäna sokt di qop kä nänbäñmät na ama sengäna dä qat tar ta angätni i ama qrot ngät mamär säng aa qar angät tpäs. Bä qop kaku aung gärakni i aa anga qrot iva qä sämbulap täm ga. ");
INSERT INTO uro_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dä qop pät ama qunäng dä ama bängang dä qat tet mänguräp ama ñäpta arha lek bä vät ama dam dap kat tuqaia dä qä nädäktmät na nas na ama dui. ");
INSERT INTO uro_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bä nga qa lu ma Jisas inamuk dä qa ang masirhat sagem ga bä arpus na qa mäk säng ma Jisas aa qar. ");
INSERT INTO uro_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Näkt ka nästäm dävuk toqortäqyia, “Nani a nge iva ngia mäsana na ngo, ainge Jisas ma Moräsnaqa Na Rhävuk aa emga? Ngut nok pät a nge iva ngia rhu sage ma Ngämuqa iva qale ngi nasangäm na ngo.” ");
INSERT INTO uro_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Qat tuqaia rhoqoräkt di sa nguna ma Jisas ka qoar na qa rhoqortäqyia, “Vuk sä nge nämät tak täkt ama ruqa ainge ama iauska!” ");
INSERT INTO uro_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Näkt ma Jisas ka snanbät sä qa rhoqortäqyia, “Rhat tes nge rhoqor mäniekt?” Dä qärak ka muvät toqortäqyia, “Rhat tes ngo i ma Rhäqäp inguna ama rhäqäp na rha na ut.” ");
INSERT INTO uro_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Dap kop kät nok masirhat pät ma Jisas iva qale qä narhäk na ngät nävät iaqäkt ama ngärhäktka. ");
INSERT INTO uro_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Dap ama vlam ama rhäqäp na ngät di qale ngät e vät ama qurängige bä ngät täs. ");
INSERT INTO uro_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Dä ama iaus ngä nok pät ma Jisas i ngärhi qoar toqortäqyia, “Mamär iva ngi rhäk na ut sä mänguräp ama vlam ivakt iva u rhon sämät ngät.” ");
INSERT INTO uro_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Dä ma Jisas ka rhares pät angärha rhäng bä vuk sä ngät bä ngä mon sämät ama vlam. Iangärhäkt ama vlam di ama udiom ama tauseniom na ngät di ngä ang masirhat manäp pät ama qäsäpki bä ngä mon ba ama rigi bä ngä ñäp däm gi. ");
INSERT INTO uro_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bä ama ruvek kärarhani i mai rhit lu vät iangärhäkt ama vlam di sa rha ang masirhat bä rha sameng mät ama värhäm bä särhage särhage. Dä soknga ama ruvek ta met sae ivakt iva rhi lu iangärhäkt ama lat kärangät i sa ngä märanas. ");
INSERT INTO uro_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bä nga rha män ge ma Jisas dä rha lu qa ruqa qärak i vuk sa ama iaus nämät ka i qat muqun i sa qa monmät näkt sa märäs pät a qa bä mamär na aa mädräm bä nga rha lu rhoqoräkt dä rhit len. ");
INSERT INTO uro_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ama ruvek kärarhani i rha lu iangärhäkt ama lat di rha sameng ba ama ruvek sävät iangärhäkt ama lat kärangät i ma Jisas ka mualat na ngät pät kärak i qre ama iaus kale ngät mät ka bä qosaqi rha sameng sävät ama vlam. ");
INSERT INTO uro_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Dä ama ruvek ta nasäng i rhat naing bät ma Jisas iva qa rhet nävä iosäkt arha ivärhäs. ");
INSERT INTO uro_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Bä nga ma Jisas kat don sämät ama mlauski dä qa ruqa qärak i ama iaus ngä met nämät ka qät naing bät ma Jisas iva qä na qa. ");
INSERT INTO uro_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Dap ma Jisas di qop kaku qa rhares pät aa rhäng dap kinak ka qoar na qa rhoqortäqyia, “Ngia rhet sävät gia vät sage gi qärhae bä ngi sameng ba rha i ma Ngämuqa qa mualat pä gia iar toqor mäniekt dä va ngi sameng sävät ma Ngämuqa aa lavuqi sävät a nas.” ");
INSERT INTO uro_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dä soknga qärak ka ruqa qa met bä qä nasäng i qä sameng mät ama ivärhäs na ama ngärhäqyisem na ap ama värhap ama mor ap sävät ama lat kärangät i ma Jisas ka mualat na ngät sä qa bä ama ruvek moe di qräk mät ta. ");
INSERT INTO uro_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Bä sa nga evär dä ma Jisas mät ama mlauski bä särhage na ama namuqa e ma Kaperneam dä ama guläñgi ama mor qi na ama ruvek pästämne na rha namet a qa vät ama namuqa aa rhäkt. ");
INSERT INTO uro_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Dä akni ama tpäskinaqa näva ama mämairqi qärak i rhat tes ka i ma Jairus di qa män sae. Bä nga qa lu ma Jisas dä arpus na qa samäk säng aa qar ");
INSERT INTO uro_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","bä qat naing bät ma Jisas masirhat toqortäqyia, “Ngua imgi ama gaini na qi di qorhäs iva qi ñäp dap ngi ang bä ngia rhu ngia rhäkt pät a qi dä va märäs pät a qi bä va ama iar qi.” ");
INSERT INTO uro_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Dä ma Jisas ka met kä na qa. Dap ama guläñgi ama mor qi na ama ruvek di rha met nasot ma Jisas bä qale rha namet a qa bä rhit tares ka. ");
INSERT INTO uro_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Näkt aktni ama evopki di qali qi e qärakt i qaku mae da arha rämgi na ama equngi dap ama biaska di qop kat tet pät ama ngärhäqyisem da udiom na ama qoeo. ");
INSERT INTO uro_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Bä sa ava gem gi mamär i sa ama rhäqäp na rha ama ruvek kärarhani i rhat dräm dat tumäräspät ta lu vät a qi bä sa qia sot pät a nas ba rha sokt di qop kaku märäs pät a qi dap kinak mor mät arha rämgi. ");
INSERT INTO uro_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Bä nga qia nari sävät ma Jisas dä qia met säng aa rhäng mänguräp ama guläñgi bä qia rhäk pät aa boiqi ");
INSERT INTO uro_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","inguna qiat tu arhä snäng doqortäqyia, “Ngakt bä sokt ngu rhäk pät aa boi dä sa va märäs pät a ngo.” ");
INSERT INTO uro_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Dä soknga mae da ama biaska masägos dap kia nari va arha iar i isiska vät a qi nämät iaqyäkt ama rämgi. ");
INSERT INTO uro_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Bä nga qia rhäk pät ma Jisas aa boi dä qa nari i ama qrot ngä met nävät a qa masägos dä qa rhong namet a nas sävät ama guläñgi dä qa snanbät toqortäqyia, “Auge qa rhäk pät gu boi?” ");
INSERT INTO uro_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Dä ma Jisas aa mudäsaqongda rha qoar na qa rhoqortäqyia, “Ngiat lu i ama rhäqäp na rha ama ruvek tit tares nge sokt di qop ngi snanbät i auge qa rhäk pät a nge?” ");
INSERT INTO uro_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sokt di qop ma Jisas di qät ñäm namet a nas ivakt iva qä lu i auge qa mualat toqoräkt. ");
INSERT INTO uro_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Dä sa qa ruqi qia räm i sa märäs pät a qi dä soknga qia män bä arpus na qi samäk säng aa qar bä värvar vät a qi mät ama tlenga dap kia sameng na ama engäktki moe sävät a nas ba qa. ");
INSERT INTO uro_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Dä qa qoar na qi rhoqortäqyia, “Ngua imgi, gi qatnanakt ngä mumäräs pät a nge. Ngia rhet sa ama isiska bä sak pät a nge nämät iaqäkt gi märänga.” ");
INSERT INTO uro_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Dap as toqoräkt i ma Jisas kat tamän dä arhani ama gamoe rha män nävät ma Jairus ama narhoerqa näva ama mämairqi aa vätka bä rha qoar nä ma Jairus toqortäqyia, “Ngia imgi di sa qia ñäp. Mäniekt bä va saqi as ngia rhuruan bät kamorqa?” ");
INSERT INTO uro_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Dap ma Jisas di qop ka qyiradeng na arha enge dap ka qoar na ama mämairqi at narhoerqa rhoqortäqyia, “Qale ngi natlen, dap sokt ngiat nanakt.” ");
INSERT INTO uro_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Näkt kaku qa rhares pät aung aa rhäng iva qa rhet nasot a qa sae dap sokt kä nä ma Pita näkt ma Jems kä nä ma Jon ma Jems aa läktka. ");
INSERT INTO uro_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bä nga rha män bät ka tpäskinaqa aa vät dä ma Jisas ka lu ama ruvek i rhat tuqaia i rhit nok dä rhit sek arhä qän masirhat. ");
INSERT INTO uro_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Dä ma Jisas ka mon säva vät sagem da bä qa snanbät sä rha rhoqortäqyia, “Mäniekt bä ngänit nok dä ngänit sek angän gän masirhat? Nak kop kaku ama rhuimgi qia ñäp dap ki mänatäm.” ");
INSERT INTO uro_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Dä rha rhama täm ga. Sokt di nasot dä qa rhäk na rha sä dalek dap ka rhäqoar sa ama rhuimgi at mam dä at nan näkt aa mudäsaqongda qärarhae i rhi na qa bä rha met sa äkt i ama rhuimgi qali qi e. ");
INSERT INTO uro_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Näkt ka sangar at tärhäkt dä qa qoar na qi rhoqortäqyia, “Talita kum.” Di ama rharimini rhoqortäqyia, “Qarhuimgi, ngu qoar na nge i ngia rhäranas.” ");
INSERT INTO uro_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dä qa rhuimgi qia märanas masägos bä qiat tet pa vät. Bä nga rhoqoräkt dä qräk mät ta mamär nävät iangärhäkt ama lat. Iaqyäkt ama rhuimgi di ama ngärhäqyisem da udiom na at koeo. ");
INSERT INTO uro_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Dä qa voda rha ama enge ama qrot ngät iva qale rhi nasameng ba aung sävät iangärhäkt ama lat näkt ka qoar na rha iva rhi von gi rhä guani ivakt iva qia äs. ");
INSERT INTO uro_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ma Jisas ka met bä säva aa värhäm maräkt kä na aa mudäsaqongda. ");
INSERT INTO uro_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Bä nga vät ama Sabat dä qa nasäng i qä su va ama mämairqi bä ama rhäqäp na rha qärarhani i rha nari qa di qräk mät ta rhoqoräkt. Dä rhi snanbät toqortäqyia, “Rhak täkt ama ruqa di sa qa rha rhärhong däkt na qoe? Dä qosaqi qa rha rhangät täkt ama mädräm na qoe nai i qat tualat dä qäqi ama nañis ngät ama lat ngät dän? ");
INSERT INTO uro_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Iaqäkt di qärak i nak kop kät täk pät ama vät. Iaqäkt di ma Maria at toemga bä ma Jems kä nä ma Josep dä ma Judas kä nä ma Saimon arha matka. Aa läktpek ama evop di nak kop tärha e gem ut.” Sa rhat tamän doqoräkt bä rha qut säda arha ron nävät a qa. ");
INSERT INTO uro_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Ma Ngämuqa aa vämginaqa di qaku anga qutdrir sävät a qa sokt pä qärqom aa värhäm mamär bä mänguräp aa qärhae bä mäk pa aa vätka.” ");
INSERT INTO uro_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Dä soknga qaku mamär vät a qa iva qä namualat na anga lat anga nañis ngät e dap sokt ka mu aa rhäkt pät ama marheka na rha ama rämgivärharha bä märäs pät a rha. ");
INSERT INTO uro_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Bä qräk mät ma Jisas nävät a rha i sa nguna qaku arha anga qatnanakt. Nasot dä ma Jisas kat tet mät ama värhap ama gaini na ap dap kä su ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dä qa mes aa mudäsaqongda ama ngärhäqyisem da udiom na rha sagem mes näkt ka nasäng i qät täk na rha i udiom udiom näkt kosaqi qa voda rha ama qrot ivakt iva rhit kutmäs ama iaus. ");
INSERT INTO uro_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Qa rhäk na rha sä rhangät täkt ama rhodäm i qat tamän doqortäqyia, “Qale aung gä narha guani sävät kärqos angäna tmerhäs dap sokt anga tlaga dä qale aung gä narha anga tmäs ura anga sägänaqa ura anga ligär mät angäna rhae. ");
INSERT INTO uro_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Dap ngänät don mät anga sandal dap kale aung gä narha agukt anga srapki anga unbem na qi irhäm mes. ");
INSERT INTO uro_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Bä nga qre vakt bä ngänät don säva agi a vätka dä qale ngän äkt pä iaqäkt ama vätka bä dängdäng i ngän det nävä iomäkt ama värhäm. ");
INSERT INTO uro_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Dap ngakt bä anga ruvek näva agi a värhäm gärarhani i ngän män sagem da di qaku rha ar sä ngän dä qaku rha nari nämät ngän dä va ngäni suqup angäna qar sa ama rhabuqi nävät ngät samäk pät ama qäväläm gärqom i ngän det. Rhoqoräkt diva ngäni sameng i iarhakt ama ruvek di qaku mär ge ma Ngämuqa nävät a rha.” ");
INSERT INTO uro_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Dä soknga rha met bä rhi sameng iva ama ruvek ti näpgoer na nas nämät arha vuirhong. ");
INSERT INTO uro_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Näkt tit kutmäs ama rhäqäp ama iaus dä rhit prit na ama oel säda ama rhäqäp na rha ama rämgivärharha arhä väs bä rha mumäräs pät a rha. ");
INSERT INTO uro_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ama vitnaqa ma Herot ka nari rhoqoräkt i ma Jisas aa ngärhipki di sa qia met mät a vät sä qärangät aa lat. Bä arhani rhi qoar toqortäqyia, “Ma Jisas di ma Jon ama Baptais kärakni i sa qa märanas nämät ama tñäpki bä rhoqoräkt i ama nañis ngät ama qrot ngät ama lat di ngät tualat gem ga.” ");
INSERT INTO uro_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Dap kosaqi arhani rhi qoar toqortäqyia, “Iaqäkt di ma Elaija.” Dap arhani rhi qoar toqortäqyia, “Iaqäkt di ma Ngämuqa aa vämginaqa qärak i qa rhoqor ma Ngämuqa aa vämginarha mudu.” ");
INSERT INTO uro_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Bä nga ma Herot ka nari rhoqoräkt dä qa märhamän doqortäqyia, “Ma Jon, ama ruqa qärak i ngua rhares bä rha rhodäkt mät ka di sa qa märanas nämät ama tñäpki!” ");
INSERT INTO uro_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Qa märhamän doqoräkt inguna sa qa voda rha ama muräkt ivakt iva rhi sangar ma Jon bä rhi qop pät a qa bä rha rhu qa va ama tpäskiarharhäng. Sa qa mualat toqoräkt inguna vät aa läktka ma Filip aa egutki ma Herodias at täväs kärakt i sa ma Herot ka mät a qi. ");
INSERT INTO uro_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Qa mualat toqoräkt inguna ma Jon di sa qa qoar na qa rhoqortäqyia, “Qaku varhäm ama Muräkt toqoräkt iva ngia rhät gia läktka aa egutki.” ");
INSERT INTO uro_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Dä qosaqi ma Herodias di rhäptäp da arha ron sävät ma Jon bä nani a qi iva qi rhäk nä guavek ivakt iva rhi veng ga sokt di qop kaku mamär vät a qi ");
INSERT INTO uro_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","inguna ma Herot di qät len ma Jon bä qät lu vät a qa inguna qat dräm i ma Jon di ama räkt ka bä ama qumärqumär qa mamär dä ma Ngämuqa aa saqong. Bä nga ma Herot kat nari ma Jon aa enge dä qat tu aa snäng masirhat sävät a ngät sokt di qop märmär qat nari qa. ");
INSERT INTO uro_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Bä nak as dängdäng dä ama släqyäs ngä män bä ma Herodias ivakt iva qi lu i rhi veng ma Jon. Bä nga vät ma Herot aa bängagi qärakt i mudu qa män dä qa mualat na ama tmäski bä ba aa latta ama narhoerta näkt ama narhoerta ama ulaqimärharhärhäkt näkt ama ruvek ama moräs na rha nae ma Galili. ");
INSERT INTO uro_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bä nga ma Herodias at tuimgi qia mon sagem da bä qiat tain dä märmär ge ma Herot kä na aa ruavek kärarhae i rha män säva aa tmäski nävät a qi. Dä ama vitnaqa ma Herot ka qoar nä qa rhuimgi rhoqortäqyia, “Ngi nän ngo rha agini qärqäni i nani a nge nä ini dä va ngu von nge rhäm ini.” ");
INSERT INTO uro_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Näkt ka mu i qä qoar toqortäqyia, “Agini qärqäni i ngi nän ngo rhäm ini diva ngu von nge bä näma dä äkt bä ngi nän da anga qäväläm nävät kärqärhong i ngut lu vät irhong.” ");
INSERT INTO uro_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dä vuk sä qi bä qia snanbät sa at nan doqortäqyia, “Va ngu nän da agiqa?” Dä at nan gia muvät pät a qi rhoqortäqyia, “Ma Jon ama Baptais aa uväski.” ");
INSERT INTO uro_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Dä qoki äkt dä qa rhuimgi qia lir qia mon sage ama vitnaqa ma Herot sa arha nän bä qia nän doqortäqyia, “Nani a ngo iva ngi von ngo rhäkt tä ma Jon ama Baptais aa uväski va anga pletige ama mor ige.” ");
INSERT INTO uro_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Bä ama vitnaqa ma Herot di airäs ka masirhat sokt dinguna nävät kärangät aa enge i qa mu bä nävät kärarhae aa ruavek i rha män säva aa tmäski dä qaku nani a qa iva qä nen na qi. ");
INSERT INTO uro_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Dä qoki äkt dä qa rhäk na akni nävät aa ulaqimärharhärhäkt sa ama enge ama qrot ngät iva qa rhän sä ma Jon aa uväski. Dä qärak ka met bä qa rhodäkt mät ma Jon ba ama tpäskiarharhäng. ");
INSERT INTO uro_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Näkt ka män sa aa uväski bä samuk pa ama pletige ama mor ige. Näkt ka von ga rhuimgi bä qia von at nanäk. ");
INSERT INTO uro_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Bä nga ma Jon aa mudäsaqongda rha nari rhoqoräkt dä rha män bä rha rha aa släqyige bä rha mas nä ige mät ama ñäpka aa liqi. ");
INSERT INTO uro_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Evär da ama ngangda nävät arha lat bä västämne na rha namet ma Jisas bä rhi sameng ba qa nä iarhongäkt moekt i rha mualat nä irhong dä rha su sävät irhong. ");
INSERT INTO uro_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bä sa nga rhoqoräkt i masirhat na ama ruvek i rhat tet tat dän nagem da bä qaku anga släqyäs bä ma Jisas kä na aa mudäsaqongda ivakt iva rha äs dä soknga ma Jisas ka qoar na rha rhoqortäqyia, “Sokt ngän ngäni ang bä u rhet sävät anga ivärhäs i qaku anga ruvek pät a äs bä va mae vät a ngän.” ");
INSERT INTO uro_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Dä soknga sokt ta rha met mät ama mlauski sävät aosni ama ngaip äs ama ivärhäs. ");
INSERT INTO uro_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sokt di ama rhäqäp na rha ama ruvek kärarhani i rha lu rha i rhat tet di rha räm a rha dä rha ang nasot a rha näkt arhani ama ruvek masirhat näva ama värhap ama mor ap ta mon mäni rha bä rha moe rha er ta män äkt i ma Jisas kä na aa mudäsaqongda rhat tet sae. ");
INSERT INTO uro_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Bä nga ma Jisas ka män mit pät a qoan bä qa lu ama guläñgi ama mor qi dä qa lavuqi na rha inguna rha di rha rhoqor ama sipsipkäna qärangätni i qaku angärha anga ruqa iva qät lu vät a ngät dä soknga qä nasäng i qä su rha rha ama rhäqäp nä irhong. ");
INSERT INTO uro_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Bä nga säpbängang mamär dä aa mudäsaqongda rha män gem ga dä rhi qoar na qa rhoqortäqyia, “Rhos täkt ama ivärhäs di sa qale läs gläius dap sa säpbängang. ");
INSERT INTO uro_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bä nga rhoqor täkt dä mamär iva ngi rhäk na ama ruvek ivakt iva rha rhet sämät ama värhap bä särhage na ap ivakt iva rhi vodäm bät guarhong iva rha äs.” ");
INSERT INTO uro_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Aingän ngäni von da rhä guarhong iva rha äs.” Dä rhi qoar na qa rhoqortäqyia, “Bä nga rhoqoräkt dä ama rhodäm sa ama ligär iva urhi vodäm na ngät di nak kop toqor ama udiom ama handretiom na ama qunäng angät titsek! Nga va u rhet bä urhi vodäm sokt nä rhangät täkt pät anga bretkäna bä va urhi von da?” ");
INSERT INTO uro_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Dä ma Jisas ka snanbät sä rha rhoqortäqyia, “Ama mämänia ama bretkäna nga e gem ngän?” Näkt ka rhäk na aa mudäsaqongda rhoqortäqyia, “Ngän det bä ngäni ñäm.” Bä nga rha män bät ama rhodäm sa ama tmäs dä evär däm da bä rha qoar nä ma Jisas toqortäqyia, “Ama ngärhäqyet ama bretkäna näkt ama rhinämiom ama udiom.” ");
INSERT INTO uro_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dä ma Jisas ka qoar na rha iva rha rhatmät na ama ruvek näkt pa rha rhuqun ba ama mran angät tpäs pa ama guläñap i aomni ama guläñäm sai dä aomni sai. ");
INSERT INTO uro_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Dä soknga rha muqun ba ama guläñap kärqapni i apni di ama handret na ama ruvek pä bap dap apni di ama udiom ama ruiom da ama ngärhäqyisem na ama ruvek pä bap. ");
INSERT INTO uro_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Näkt ka rha ama ngärhäqyet ama bretkäna näkt kä udiom gä rhinämiom näkt sa qa ñäm dävit säva ama usäpki näkt ka mes ama mär näkt ka vonmät na ama bretkäna näkt ka von aa mudäsaqongda ivakt iva rhi are däm ngät bä ba ama ruvek. Dä qosaqi qa matmät na ama rhinämiom bä ba rha moe. ");
INSERT INTO uro_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bä rha moe rha mäs bä arhä sarem. ");
INSERT INTO uro_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Näkt ama mudäsaqongda rha rhäqäp ama urat ama ngärhäqyisem dä unbem na ngät na ama mäsdävät nävät ama bret ngä na ama rhinäm. ");
INSERT INTO uro_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ama rhodäm sa ama gamoe iarhakt kärarhae i rha mäs iangärhäkt ama tmäs di ama ngärhäqyet ama tausengäna na rha näkt sävät ama evop ti na ama rhoes. ");
INSERT INTO uro_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Dä nak kop äkt dä ma Jisas ka qoar na aa mudäsaqongda bä rha veng sämät ama mlauski iva rhi rhoer särhage sämät ama värhäm ama lel äm ma Betsaida dap pa dängdäng na qa ivakt iva qä vräs na ama guläñgi. ");
INSERT INTO uro_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bä nga nasot i sa qa vräs na ama guläñgi dä dang däm ga bä sämäni ama damgi ivakt iva qä nän. ");
INSERT INTO uro_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bä sa rhoqoräkt i bängangäs dä aa mudäsaqongda arhä mlauski di qali qi mänguräp ama namuqa mamär dap ka di sokt ka namit närhage vät ama namuqa aa rhäkt. ");
INSERT INTO uro_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Dä qa lu aa mudäsaqongda i rhi siqut na arhä mlauski iva qiat tet dä qaku inguna ama laurqi qi e nani a ne na rha. Bä nga sa qorhäs iva qunäga dä qa met bä sagem da i qat tet pät ama qoeväs angärha rhäng. Bä qorhäs iva qä rhäqär na rha. ");
INSERT INTO uro_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Sokt di nga rha lu qa i qat tet pät ama qoeväs angärha rhäng dä rhat tu arhä snäng i nguaräm anga rhomga na qa. Bä rhat tuqaia ");
INSERT INTO uro_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","inguna rha moe rha lu qa bä rhit len masirhat. Dä qa märhamän särhäm da masägos i qä qoar na rha rhoqortäqyia, “Qale ngänit len! Nak kop mamär. I nak kop aingo.” ");
INSERT INTO uro_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Näkt ka veng sämät ama mlauski sagem da dä mae da ama laurqi. Bä qräk mät ta mamär ");
INSERT INTO uro_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","inguna qosaqi qaku qunäga vät a rha i ma Jisas di auge iaqäkt nävät aa lat kärangätni i qa mualat na ngät sävät ama bretkäna bä ngä män masirhat inguna ama qrot arhä väs. ");
INSERT INTO uro_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bä nga sa rha mängaläkt särhage dä mae vät a rha e vät ama ivärhäs ma Genesaret bä rha qop sa arhä mlauski e. ");
INSERT INTO uro_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bä nga vät ama qäväläm gärqom i vuk sä rha nämät ama mlauski dä ama ruvek ta räm ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Dä rha ang dä iaqäkt ama ngärhäktka aa ron moe bä rha rha ama rämgivärharha va ama gasgasimek bä sävät ama ivärhimek kärqämekni i rha nari i qale ma Jisas e. ");
INSERT INTO uro_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bä qosaqi nga qoe nai i ma Jisas kat tet i rhoqoräkt i qat tet pa ama värhap ama lel ap ura va ama värhap ama mor ap ura sävät ama värhap angät ngärhakt tage rhage dä ama ruvek tat tu arha rämgivärharha va ama ivärhimek kärqämekni i rhit boda ama tmäs e. Näkt tat naing bät a qa iva qät tares pät ama rämgivärharha arha rhäng iva näma dä äkt bä nak kop pa sokt tit täk da aa boiqi arha väm. Bä iarhakt moe qärarhae i sa rha rhäk da arha väm di sa märäs pät a rha. ");
INSERT INTO uro_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ama Farisiqäna näkt arhani ama Skraipkäna qärarhani i sa rha män nae ma Jerusalem di västämne na rha namet ma Jisas näkt ");
INSERT INTO uro_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ta lu arhani ma Jisas aa mudäsaqongda i rhat täs ama tmäs na arhä rhäkt i qaku ama qumärqumär ngät i sa qaku rha rhor ngät. ");
INSERT INTO uro_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ama Farisiqäna näkt sävät ama Judaqäna moe di qaku mamär iva rhi namäs toqoräkt inguna narhoer diva rhi rhor arhä rhäkt parhäm arha morta arhä qärhong. ");
INSERT INTO uro_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Bä qosaqi rhoqoräkt i rhat dän nävät ama ivärhäs kärqosni i rhit boda arhä qärhong e dä qaku rhat täs bä dängdäng i rhi rhor arhä rhäkt parhäm arhä qärhong. Dä qosaqi rhat tet parhäm ama rhäqäp nä irhong arha morta arhä qärhong doqor iomäkt iva rhit tor iarhongäkt kärqärhong i rhat täs dä rhit nakt nämät irhong bä sävät iarhongäkt kärqärhong i rhat tuqun bät irhong. ");
INSERT INTO uro_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bä nga rhoqoräkt dä ama Farisiqäna näkt sävät ama Skraipkäna rhi snanbät sä ma Jisas toqortäqyia, “Mäniekt bä qaku mamär iva gi mudäsaqongda rhat tet parhäm ama morta arhä qärhong dap kinak tat täs arha tmäs na arhä rhäkt i qaku ama qumärqumär ngät?” ");
INSERT INTO uro_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Dä ma Jisas ka muvät toqortäqyia, “Sa ma Aisaia qa märhamän mamär bät ama enge nage ma Ngämuqa sävät a ngän, aingän gärarhae i ngän dualat sädä saqong, toqor mudu i qa säm doqortäqyia, “‘Rhärhae rhäkt ama ruvek di rhit kutdrir sävät a ngo na arha väm dap arhä snängaqa di qa e gläius na ngo. ");
INSERT INTO uro_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Dap ti nänsäs sagem ngo mavängam i rhi su ama ruvek na arhä muräkt i rhoqor qre ama muräkt nagem ngo.’ ");
INSERT INTO uro_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Bä sa ngän gyiradeng nä ma Ngämuqa aa Muräkt dap ngän sangar sävät ama ruvek arhä qärhong.” ");
INSERT INTO uro_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Näkt kosaqi qa qoar na rha rhoqortäqyia, “Ngän du angän snäng i ngän dualat mamär toqoräkt i ngän du ma Ngämuqa aa enge ama qrot ngät tage ivakt iva ngän det parhäm angäna morta arhä qärhong! ");
INSERT INTO uro_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Inguna ma Moses ka qoar toqortäqyia, ‘Mamär iva ngit kutdrir sävät gi mamäk dä gi nanäk’ näkt ‘Auge qärak i qät tamän mava na aa mamäk bä qop aa nanäk diva qoki rhi veng ga.’ ");
INSERT INTO uro_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Sokt di aingän di ngäni qoar i mamär toqoräkt krekt bä nga anga ruqa qä qoar na aa mamäk ura aa nanäk toqortäqyia, ‘Agi matnärhäm gärangätni i mai va ngu von en däm ngät di sa ngua von ma Ngämuqa’ ");
INSERT INTO uro_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","bä rhoqoräkt di sa ngänit päs särha ama ruvek iva qaku sävetka qät lu vät aa mamäqiom mamär. ");
INSERT INTO uro_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nguna rhoqoräkt bä ngänit kyiradeng nä ma Ngämuqa aa enge qärangät i sa ngä män nage angäna ikkäna ivakt iva ngän det parhäm angän gärhong. Bä ngän dualat na arhong ama rhäqäp nä irhong doqoräkt.” ");
INSERT INTO uro_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Dä saqi as ma Jisas ka mes ama ruvek sagem mes bä qa qoar na rha rhoqortäqyia, “Aingän moe, di mamär iva ngäni nari ngo bä va qunäga vät a ngän i ");
INSERT INTO uro_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","qaku guani vono vät ama ruqa aa släqyige di mamär iva ini ngä rhualat na ama ruqa bä qaku ama qumärqumär qa dä ma Ngämuqa aa saqong doqoräkt i ini ngät don säväm ga. Dap kinak ianiäkt kärqäni i vukpuk sä ini näva ama ruqa aa iar di ianiäkt ngärhit säm a qa bä qaku ama qumärqumär qa.” ");
INSERT INTO uro_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Bä sa nga nasot i qa met daqule ama guläñgi bä qa mon säva aa vät dä aa mudäsaqongda rha snanbät sä qa närhä iangärhäkt ama enge na ama siqutki. ");
INSERT INTO uro_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Dä ma Jisas ka snanbät sä rha rhoqortäqyia, “Nga as kaku qunäga vät a ngän i anga tmäs kärangätni i ngät don säda ama ruqa aa ron nä dalek di qaku mamär iva ngä namualat na qa bä va qaku ama qumärqumär qa dä ma Ngämuqa aa saqong? ");
INSERT INTO uro_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Inguna ama tmäs di qaku ngät don sämät aa snängaqa dap sokt sämät aa sarimgi näkt nasot dä vuk sä ngät näva aa släqyige.” Nga qa märhamän doqoräkt di ma Jisas ka qoar i ama tmäs moe di ama mär ngät. ");
INSERT INTO uro_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Dä saqi as kat tamän doqortäqyia, “Agini qärqäni i vukpuk sä ini näva ama ruqa aa iar di ianiäkt ngät tualat sä qa bä qaku ama qumärqumär qa.” ");
INSERT INTO uro_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Inguna namuk nämät ama ruqa aa snängaqa dä ama vu ngät ama mungäsnäng ngärhi rhartäm sä qa bä qat tualat na ama lat na ama qavatka maos maos dä qä sua dä qä veng dä qä qavatnävätlägut ");
INSERT INTO uro_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","dä qä alek dä qä ngingbäm dä qä iras dä qat nañäm na ama qavatka dä aa snängaqa ama vu qa sävät arhani sa arhä qärhong dä qat tamän mava na ama ruvek dä qat tair na nas dä qat tualat na ama lat maos maos toqor ama dädänga. ");
INSERT INTO uro_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iangärhäkt moekt ama vu ngät ama lat di ngät dän näda ama ruqa aa ron bä qaku ama qumärqumär qa. ");
INSERT INTO uro_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ma Jisas ka met na äkt bä qa met sävät ama ngärhäktka namet ma Tair näkt ma Saidon. Dä qa mon säva akni ama vätka näkt kaku nani a qa iva aung gä naräm na qa. Sokt di qop kaku mamär iva qä ngaip nas. ");
INSERT INTO uro_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Bä nga vät ama qäväläm gärqomni i ama nañiski qia nari sävät ma Jisas di sa qia män sa äkt i qale qa e bä arpus na qi samäk säng aa qar. Iaqyäkt ama ruqi di ama iauska qa e mät at tuimgi. ");
INSERT INTO uro_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Dä sa qia män bä qit nok pät ma Jisas iva qä qutmäs ama iauska nämät at tuimgi inguna iaqyäkt ama ruqi di ama Jentailqi qärakt i qi nae näva ama ngärhäktka ma Fonisia qärak i qale qa va ama ngärhäktka ma Siria aa muräkt. ");
INSERT INTO uro_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Dä ma Jisas kaku qa qur qi dap ka artäm sa at mädräm na aa enge i qä qoar na qi rhoqortäqyia, “Ama narhoeräm di as mamär iva ama rhoes ta äs ama tmäs narhoer bä arhä sarem inguna qaku maräkt iva rhi rha ama rhoes arha tmäs bä rhi rhon na ngät bä ba ama im.” ");
INSERT INTO uro_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Dä qia muvät toqortäqyia, “Ngäktki na nge gua morqa, dap käqi ama im ba ama laiqa aa rem di ngät täs ama rhoes arha nesdäm.” ");
INSERT INTO uro_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dä qa qoar na qi rhoqortäqyia, “Nävät iaqyäkt gi muvätki dä mamär iva ngia rhet i sa ama iauska di qa met näp ngia imgi.” ");
INSERT INTO uro_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dä sa qia met säva arha vät bä qia män bät at tuimgi i qiat namas pät at laiqa i sa ama iauska qa met nävät a qi. ");
INSERT INTO uro_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Bä nga nasot dä ma Jisas ka met nämät ama värhäm ma Tair bä qa met da ama värhäm ma Saidon angärha ron bä mämane da ama ivärhäs na ama ngärhäqyisem na ap ama värhap ama mor ap angärha ron bä sämäni ama namuqa ma Galili. ");
INSERT INTO uro_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bä nga qa män äkt dä arhani ama ruvek ta män sa akni ama ruqa sagem ga qärakni i ama däng bät a qa dä qaku qat tamän bä rhit nok pät a qa iva qa rhu aa rhäkt pät a qa. ");
INSERT INTO uro_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mamär dä ma Jisas ka ar da aa rhäkt näva ama guläñgi bä särhage bä sokt iom näkt ka rhäk aa rhäkt mät aa sdäm näkt kosaqi qa qot pa aa rhäkt näkt ka rhäk pät aa qoebäñga. ");
INSERT INTO uro_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Näkt ka ñäm dävit säva ama usäpki bä vät iomäkt ama qäväläm dä rhäqäp ka na ama iräski dä qa näskänak pät a nas i qa qoar nä qärak toqortäqyia, “Efata!” Iomäkt ama qäväläm angärha ribit di rhoqortäqyia, “Ngi rhar!” ");
INSERT INTO uro_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bä nga rhoqoräkt dä qa ruqa aa sdäm di qunäga mät ngät dä aa qoebäñga di qäva sä qa bä qa nasäng iva qat tamän mamär. ");
INSERT INTO uro_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Dä ma Jisas ka qoar na rha na ama enge ama qrot ngät iva qale rhi naqoar na aung sävät iangärhäkt ama lat kärangät i ngä märanas. Sokt di qop nga rhoqoräkt i qat tair särhäm da rhoqoräkt di nak tat tamän masirhat sävät a ngät. ");
INSERT INTO uro_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bä ama ruvek di qräk mät ta mamär nävät iangärhäkt aa lat bä rhat tamän doqortäqyia, “Iaqäkt di qat tualat nä irhong moe mamär.” Bä qosaqi rhat tamän doqortäqyia, “Iaqäkt di qäqi qat tumäräs pät ama dängbärharha bä rhat nari bä qäqi qat tumäräs pät iarhakt kärarhae i qaku rhat tamän.” ");
INSERT INTO uro_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Vät iangärhäkt ama qunäng dä saqi as aktni ama mor qi ama guläñgi na ama ruvek ta män bä västämne na rha ge ma Jisas. Bä nga qaku anga tmäs iva rha äs dä ma Jisas ka mes aa mudäsaqongda sagem mes bä qa qoar na rha rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Aingo di ngut lavuqi nä rhärha rhäkt ama ruvek inguna sa qale rha gem ngo vät ama dävaung ama qunäng näkt kaku guarhong iva rha äs. ");
INSERT INTO uro_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Näkt ngakt bä nga ngu rhäk na rha rhoqor täkt i anoeng mä rha säva arha vät dä varis deng bät a rha varhäm ama iska inguna arhani di rha män näva ama is ama uiu ngät.” ");
INSERT INTO uro_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Dä aa mudäsaqongda rha muvät pät a qa rhoqortäqyia, “Sokt di urhi lu vät ama ivärhäs gläius toqor täkt di sirhäkt mamär vät aung iva qä rha anga tmäs iva mamär vät a rha moe rhoqor mäniekt?” ");
INSERT INTO uro_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Dä ma Jisas ka snanbät sä rha rhoqortäqyia, “Ama mämänia ama bretkäna nga e gem ngän?” Dä rha muvät pät a qa rhoqortäqyia, “Ama ngärhäqyet da udiom.” ");
INSERT INTO uro_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dä qa qoar na ama guläñgi na ama ruvek iva rha rhuqun bät ivät. Bä sa nga qa rha qä ngärhäqyet da udiom na ama bretkäna näkt sa qa mes ama mär sage ma Ngämuqa näkt sa mamär dä qa vonmät na ngät näkt ka von aa mudäsaqongda iva rhi are da ama ruvek na ngät dä rha mualat toqoräkt. ");
INSERT INTO uro_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Rhoqoräkt dä qosaqi ama marheka nä irhong ama rhinämirhong nga e gem da dä qosaqi qa nän da ama modämne sävät irhong näkt kosaqi qa qoar na aa mudäsaqongda iva rhi are da ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bä sa ama ruvek ta mäs bä arhä sarem. Bä nga mamär dä aa mudäsaqongda rha matma ama mäsdävät bä sämät ama urat ama ngärhäqyet da unbem. ");
INSERT INTO uro_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Dä ama rhodäm sa ama ruvek di rhoqor qre ama levaet ama tausengäna. Dä qa rhäk na ama ruvek ");
INSERT INTO uro_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","dap ka lir qa veng sämät ama lil qi ama mlauski qä na aa mudäsaqongda bä rha met sävät ama ngärhäktka ma Dalmanuta. ");
INSERT INTO uro_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mamär dä ama Farisiqäna rha män bä rhi nasäng i rhi snanbät sä ma Jisas ivakt iva rhi siqut na qa. Dä rhi nän ga nani anga muqunängi na rhävuk. ");
INSERT INTO uro_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Dä qa rha ama märänga sä rha dä qa qoar na rha rhoqortäqyia, “Mäniekt bä rhit täkt ama qoengait di it ngärhit ñäm nani anga muqunängi? Ngu qoar na ngän na ama engäktki iva qaku anga muqunängi qi namän bä bä rhit täkt ama qoengait.” ");
INSERT INTO uro_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bä nga nasot dä qa met daqule rha bä qa mon saqi as sämät ama mlauski bä qa met mät ki qinak saqi särhage. ");
INSERT INTO uro_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ma Jisas aa mudäsaqongda di rät pät a rha iva rhi rha anga bretkäna dap sokt ama sägäk ama bret ka e mät ama mlauski. ");
INSERT INTO uro_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Bä ma Jisas ka rhon sävät a rha rhoqortäqyia, “Va ngänit lu mamär. Ngänit lu nämät ama Farisiqäna näkt ma Herot arha yis.” ");
INSERT INTO uro_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dä rha nasäng i rhat tamän bät a ne sä iangärhäkt aa enge dä rha qoar na ne rhoqortäqyia, “Qat tamän doqoräkt dinguna qaku urha anga bretkäna.” ");
INSERT INTO uro_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ma Jisas ka räm arha engirhong dä qa snanbät sä rha rhoqortäqyia, “Nak mäniekt bä va ngän damän särhäm ne i qaku urha anga bretkäna? Nga as kaku qunäga vät a ngän ma anga gaini? Nga ama qrot angän bäs? ");
INSERT INTO uro_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nga aingän di angän saqong sokt di qop kaku mamär iva ngänät nañäm dä angäna sdäm sokt di qop kaku mamär iva ngänät nari? Dä qosaqi nga qaku vuk pät a ngän? ");
INSERT INTO uro_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nga vät ama qäväläm gärqom i ngua vonmät na ama ngärhäqyet ama bretkäna ba ama ruvek kärarhae i ama rhodäm sä rha di rha met e na ama ngärhäqyet ama tausengäna dä ama mämänia ama urat kärangätni i rhäqäp ngät na ama mäsdävät toqoräkt i ngän matme sämät ngät?” Dä rha muvät toqortäqyia, “Ama ngärhäqyisem da unbem.” ");
INSERT INTO uro_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Bä nga qosaqi qaku vuk pät a ngän i nga rhoqoräkt i ngua vonmät na ama ngärhäqyet da udiom na ama bretkäna ba ama levaet ama tausengäna na ama ruvek dä ama mämänia ama urat kärangätni i sa ngän matme sämät ngät bä rhäqäp ngät na ama mäsdävät?” Dä rha muvät pät a qa rhoqortäqyia, “Ama ngärhäqyet da unbem.” ");
INSERT INTO uro_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Dä qa qoar na rha rhoqortäqyia, “Qoki as nga qaku qunäga vät a ngän sävät a ngo?” ");
INSERT INTO uro_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Sa rha män sae ma Betsaida dä arhani ama ruvek ta män sa ama säsurqa bä rhat naing bät ma Jisas iva qä rhäk pät a qa. ");
INSERT INTO uro_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Dä ma Jisas ka ar dä qä säsurqa aa rhäkt bä qa er nanokt ka bä vuk sä iom nävä iomäkt ama värhäm. Bä sa nga qa qot na aa rhäbañ sämät kä säsurqa aa saqong näkt ka mu aa rhäkt mät ngät dä sa qä snanbät sä qa rhoqortäqyia, “Nga ngiat lu guani?” ");
INSERT INTO uro_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Dä sa qä säsurqa qa ñäm dävit näkt ka qoar toqortäqyia, “Nguat lu ama ruvek sokt di rha rhoqor ama ngämung i ngät tet.” ");
INSERT INTO uro_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Dä saqi as ma Jisas ka mu aa rhäkt mät ka ruqa aa saqong dä soknga aa saqong ngä ñäm bä aa saqong di märäs pät a ngät bä qät lu iarhongäkt moe mamär. ");
INSERT INTO uro_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Dä ma Jisas ka rhäk na qa säva aa vät i qä qoar na qa rhoqortäqyia, “Qale ngi namon sämät ama värhäm.” ");
INSERT INTO uro_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mamär dä ma Jisas kä na aa mudäsaqongda rha met säva ama värhap ama gaini na ap pät ama ivärhäs tage na ama värhäm ama lel äm ma Sisaria Filipai. Bä nga varhäm arha iska dä qa snanbät sä rha rhoqortäqyia, “Ngu lu ngäda ama ruvek ti qoar i aingo di auge na ngo?” ");
INSERT INTO uro_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Dä rha muvät pät a qa rhoqortäqyia, “Arhani di rhi qoar i ainge di ma Jon ama Baptais dap arhani di rhi qoar i ainge di ma Elaija dap koki as arhani di rhi qoar i ainge di akni nävät ma Ngämuqa aa vämginarha.” ");
INSERT INTO uro_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Dä ma Jisas ka snanbät sä rha rhoqortäqyia, “Dap aingän di ngän du angän snäng i auge na ngo?” Dä ma Pita qa muvät toqortäqyia, “Ainge di ma Krais.” ");
INSERT INTO uro_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Dä ma Jisas ka mugem da ma ama qrot iva qale rhi nasameng bä ba aung sävät a qa. ");
INSERT INTO uro_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Dä ma Jisas ka nasäng i qä su aa mudäsaqongda i ma Ruqa aa Emga diva qä rha ama märän maos maos masirhat bä va ama morta rhi na ama priskäna ama moräs na rha rhi na ama Skraipkäna diva rha rher mä qa bä va rhi veng ga. Näkt pa nasot ama qunäng ama dävaung dä va ma Ngämuqa qa rhäranas na qa. ");
INSERT INTO uro_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Qa muqunäga mamär sävät iaqyäkt aa tñäpki dä ma Pita qa rhäqoar sä qa sä nas bä qa rhäkne vät a qa sä iaqäkt aa muqunäga. ");
INSERT INTO uro_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sokt di nga vät ama qäväläm gärqomni i ma Jisas ka rhong bä qa ñäm sävät aa mudäsaqongda dä qa rhäkne vät ma Pita na ama enge ama qrot ngät toqortäqyia, “Sämga, ngia rhet säng gua rhäng. Ainge di ngit päs nas mäni gua iska inguna sa rhak täkt gi snängaqa di qaku qa nage ma Ngämuqa dap ka nage ama ruvek.” ");
INSERT INTO uro_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dä qosaqi qa mes ama guläñgi sä ne na aa mudäsaqongda sagem mes näkt ka qoar na rha rhoqortäqyia, “Nga nani aung gärakni iva qat tet nasot a ngo di mamär iva qä qyiradeng na nas dap pa qä rha aa sämänanamuqa bä qät päs gua rhäng. ");
INSERT INTO uro_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Inguna aung gärakni i nani a qa iva qä sangar vät aa iar mamär diva qa rhusäng sä ngät nasot. Dap iaqäkt kärak i qät kyiradeng na aa iar bä ba ngo dä bä bä ma Ngämuqa aa enge diva qa rhumaiar ngät. ");
INSERT INTO uro_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Va mamär vät ama ruqa na agiqa qre i mänamär sä qa nage ama ivätki at kärhong moe dap käbäs na aa iar? ");
INSERT INTO uro_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Inguna ngu lu agini qärqäni i mamär vät ama ruqa iva qä vodäm ini ivakt iva saqi qa rhän bät aa iar? ");
INSERT INTO uro_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Bä nga mäni rhit täkt ama qoengait nä rhärha rhäkt ama ruvek di ngakt bä nga anga ruqa di aqlus pät a qa na ngo bä na gua enge di ma Ruqa aa Emga diva aqlus pät a qa na qa vät ama qäväläm gärqomni i qa rhän ba aa mamäk aa murhämeska qä na ama qumärqumär ta mamär ama enselqäna.” ");
INSERT INTO uro_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Näkt kosaqi ma Jisas ka qoar na rha rhoqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i arhani nävät a ngän däkt kärarhae i ngänät mair diva as kaku rhi nañäp dap as pa rhi lu ma Ngämuqa aa Muräktpäm i sa ngä män sa angät krot.” ");
INSERT INTO uro_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nasot ama qunäng ama ngärhäqyet da sägäk dä ma Jisas ka rhäqoar sä ma Pita qä nä ma Jems näkt ma Jon bä ma Jisas ka er nanokt ta bä dang däm da säda ama damgi ama uiu qi bä sokt ta sä nas. Bä nga sa äkt dä ma Jisas aa ñämñämgi qia män maos da arhä saqong. ");
INSERT INTO uro_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Bä aa boi di ngä män i qaliqalae vät a ngät i ama qulum ngät mamär i nak sa qaku mamär vät anga ruqa nävät ivät iva qä rhor anga boi bä ngä nañäm doqor ngät. ");
INSERT INTO uro_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bä nasot dä väs dä ma Elaija qä nä ma Moses gem da bä rhat tamän särhä ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Dä ma Pita qa qoar nä ma Jisas toqortäqyia, “Qamorqa, ama mär toqoräkt i qali lut täkt. Bä rhäkt diva u rhair na anga mämairväm anga dävagukt iva aktni bä ba nge dap aemni bä ma Moses kä nä ma Elaija.” ");
INSERT INTO uro_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ma Pita qat tamän doqoräkt inguna qa qä nä ma Jems dä ma Jon di rhäqäp ta na ama tlenga bä qaku qat dräm iva qa rhamän doqor mäniekt. ");
INSERT INTO uro_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Dä ama eqoeqi qia män bä qia ong ma Jisas kä nä ma Elaija näkt ma Moses näkt akni ama eguinga qa män näva ama eqoeqi i qä qoar toqortäqyia, “Rhak täkt di ngua emga qärak i sa gua snäng bät a qa masirhat. Ngänät nari nämät ka!” ");
INSERT INTO uro_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Dä qop äkt pät iomäkt ama qäväläm i nga rha ñäm namet a nas dä qaku rha lu aung dap sokt ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Näkt nga rhoqoräkt i arhar sä rha vät ama damgi dä ma Jisas ka von da rha ama enge na ama mugem ama qrot ngät iva qale rhi nasameng bä ba aung sävät iomäkt ama qäväläm gärqom i sa rha lu äm bä dängdäng i ma Ruqa aa Emga sa qa märanas nämät ama tñäpki. ");
INSERT INTO uro_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Dä soknga rha sangar sävät iangärhäkt ma Jisas aa enge gem mes bä rhat tamän särhäm ne i vadi va rhi räm i mäniekt bä ma Jisas ka qoar i ma Ruqa aa Emga diva qa rhäranas nämät ama tñäpki. ");
INSERT INTO uro_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Dä rha snanbät sä qa rhoqortäqyia, “Mäniekt bä ama Skraipkäna rhi qoar i mamär iva ma Elaija qa er qa rhän näkt nasot dä sä ma Krais?” ");
INSERT INTO uro_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Nak koki ma Elaija diva qa er qa rhän ivakt iva qa rhumamär nä iarhongäkt moe. Dap kosaqi mäniekt bä sa mudu ma Ngämuqa aa enge qärangät i sa rha säm a ngät di ngät tamän i ma Ruqa aa Emga diva qä rha ama märänga masirhat bä va rha rher mä qa? ");
INSERT INTO uro_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Dap ngu qoar na ngän i sa ma Elaija qa män bä sa rha mualat sä qa varhäm arhä snängaqa i varhäm ama enge qärangät i mudu rha säm a ngät sävät a qa.” ");
INSERT INTO uro_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Bä nga sa evär däm da sage ma Jisas aa mudäsaqongda i mai rha met daqule rha dä rha lu ama guläñgi ama mor qi namet a rha dap ama Skraipkäna rhi nä ma Jisas aa mudäsaqongda di rhit beng bät a ne na ama enge. ");
INSERT INTO uro_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bä nga ama ruvek ta lu ma Jisas dä qräk mät ta mamär nävät a qa dä rha moe rha lir ta ang sagem ga ivakt iva rhi sameng na arhä märmärgem sävät a qa. Dä ma Jisas ka snanbät sä rha rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","“Aingän ngän na ama Skraipkäna ngänit beng bät a ne na ama enge sävät agiqa?” ");
INSERT INTO uro_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dä akni ama ruqa näva ama guläñgi qa muvät pät a qa rhoqortäqyia, “Qamorqa, ngua män sä ngua emga qärak i ama iauska qa e mät ka bä qa väsärha aa enge bä qaku qat tamän. ");
INSERT INTO uro_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Bä nga vät ama qäväläm gärqomni i ama iauska qat tualat na qa na ama qrot dä qät don na qa sävät ivät bä vukpuk sa ama goaräm mät ka näkt kät nes aa qeng angärha rem na ne dap rändrän bät a qa. Dä ngua nän gi mudäsaqongda iva rhi qutmäs ama iauska nämät ka sokt di qaku mamär vät a rha.” ");
INSERT INTO uro_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Dä ma Jisas ka muvät toqortäqyia, “Ai, aingän di ama qoengait na ama ruvek kärarhae i qaku angän anga qatnanakt. Ngu lu va qale ngo gem ngän bä dängdäng gäsnia? Dä qosaqi va ngut ta ama märänga sä ngän bä dängdäng gäsnia? Ngäni rha ama rhoemga sagem ngo.” ");
INSERT INTO uro_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dä rha män sa ama rhoemga sagem ga. Bä nga vät ama qäväläm gärqomni i ama iauska qa lu ma Jisas dä qa rhon nä qa rhoemga masägos na ama inirqi. Qa rhoemga di arpus na qa bä qät näpgoer na nas pät ivät dap pukpuk sa ama goaräm mät aa vämgi. ");
INSERT INTO uro_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Dä ma Jisas ka snanbät sä qa rhoemga aa mam doqortäqyia, “Qäsnia dä rhak täkt ka nasäng bä qale qa rhoqor täkt?” Dä aa mam ga muvät toqortäqyia, “Nak sa qa nasäng mudu i ama rhoemga na qa. ");
INSERT INTO uro_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Bä ama iauska di ngäda sai dä qät don na qa sämät ama mudam bä qop säva rigi ivakt iva qä veng ga. Dap ngakt bä nga mamär vät a nge iva ngia rhualat nä guani dä va ngi lavuqi na un dä ngia rhatnärhäm un.” ");
INSERT INTO uro_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Dä ma Jisas kä qoar nä qa rhoemga aa mam doqortäqyia, “Mäniekt bä ngi qoar na ngo i, ‘Nga mamär vät a nge?’ Diva ngu qoar na nge i iarhongäkt moe di mamär iva irhong ngä rhän bä sävetka qärakni i qat nanakt.” ");
INSERT INTO uro_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Dä nak kop äkt dä qa rhoemga aa mam ga nok masirhat i qä qoar toqortäqyia, “Aingo di nguat nanakt. Ngia rhatnärhäm ngo sä gu qatnanakt iva ama qrot ngät.” ");
INSERT INTO uro_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Bä nga vät ama qäväläm gärqom i ma Jisas ka lu ama guläñgi na ama ruvek kärarhani i rhi ngang sagem ga qä nä qärqiom dä qa rhäk na ama iauska na ama enge ama qrot ngät toqortäqyia, “Ainge ama iauska qärak i ama däng bät a nge dä qaku ngiat tamän di ngut kutmäs a nge. Vuk sä nge nämät ka näkt saqi as kale ngi namon sämät ka nasot.” ");
INSERT INTO uro_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dä soknga ama iauska qa muqaia näkt ka rhästäs ka rhoemga na ama inirqi bä vuk sä qa bä qa rhoemga di qa rhoqor aung gärakni i sa qa ñäp bä ama rhäqäp na rha rhi qoar i, “Sa qa ñäp.” ");
INSERT INTO uro_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sokt di qop ma Jisas ka sangar da aa rhäkt näkt ka mair na qa bä qa mair. ");
INSERT INTO uro_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bä sa nga nasot i ma Jisas ka mon säva vät dä aa mudäsaqongda rhi snanbät sä qa rhoqoräkt i sokt ta rhoqortäqyia, “Mäniekt bä qaku mamär vät a ut iva urhi qutmäs iaqäkt ama iauska?” ");
INSERT INTO uro_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Dä ma Jisas ka muvät toqortäqyia, “Rhangät täkt ama iaus toqor täkt diva sokt ngänit kutmäs a ngät na ama nän.” ");
INSERT INTO uro_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Dä sa rha met nae nävät iosäkt ama ivärhäs bä rha met da ama ivärhäs angärha ron ma Galili. Rhoqoräkt di ma Jisas di qaku nani a qa iva aung gä naräm i qale rha äkt ");
INSERT INTO uro_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","inguna rhoqoräkt di qä su aa mudäsaqongda i qat tamän särhäm da rhoqortäqyia, “Ma Ruqa aa Emga diva rhi vodäm ga sämät ama ruvek arhä rhäkt bä va rhi veng ga. Näkt pa nasot ama qunäng ama dävaung dä va qa rhäranas.” ");
INSERT INTO uro_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Sokt di qop aa mudäsaqongda di qaku qunäga vät a rha sä iangärhäkt aa enge. Dä qosaqi qaku rha snanbät sä qa närhäm ngät inguna rhit len. ");
INSERT INTO uro_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bä sa nga rha män e ma Kaperneam bä nga vät ama qäväläm gärqom i qale ma Jisas kä na aa mudäsaqongda va ama vätka dä qä snanbät sä rha rhoqortäqyia, “Ngu lu mai ngänit beng bät a ne sa agiqa inamuk parhäm ama iska?” ");
INSERT INTO uro_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Qa snanbät sä rha dä qop mänadin däm da inguna mai di rhit beng bät a ne i auge nävät a rha di ama vit na qa mamär. ");
INSERT INTO uro_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Bä nga rhoqoräkt i ma Jisas ka muqun dä qa mes aa mudäsaqongda ama ngärhäqyisem da udiom na rha näkt ka qoar na rha rhoqortäqyia, “Ngakt bä nga aung nani a qa iva ama narhoerqa na qa di iaqäkt diva qä säm ama gaini na nas mamär näkt pa qale qa va ama ruvek moe arha rem.” ");
INSERT INTO uro_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Dä qa sangar da ama rhoemga aa rhäkt bä qa mair na qa da arhä saqong. Näkt nga qa qärhäkt dä qa rhoemga dä qä qoar na rha rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Aung gärakni i qä rhar sa anga rhoemga rhoqor tak täkt sagem mes nävät gu ngärhipki di sa qä rhar sä ngo. Dap aung gärakni i qä rhar sä ngo sagem mes di qaku sokt kä rhar sä ngo dap kosaqi qä rhar sä iaqäkt kärak i sa qa rhäk na ngo sarhe.” ");
INSERT INTO uro_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Dä ma Jon gä qoar toqortäqyia, “Qamorqa, ut lu akni ama ruqa i qät kutmäs ama iaus nävät gi ngärhipki dä ut koar na qa iva qale qä natmualat toqoräkt inguna qaku qa nävät a ut.” ");
INSERT INTO uro_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Dä ma Jisas ka qoar toqortäqyia, “Qale ngän dair särhäm ga inguna qaku aung gärakni i qat tualat na anga nañis ngät anga lat nävät gu ngärhipki di mamär iva nasot dä qa rhamän bät anga enge anga vu ngät sävät a ngo.” ");
INSERT INTO uro_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Inguna aung gärakni i qaku qat tair särhäm ut di qa e vät aut käge. ");
INSERT INTO uro_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Bä nguat tamän särhäm ngän na ama engäktki i aung gärakni i qät bon aung nävät a ngän da anga ringini anga gaini inguna ngän nämäni ngo di ngäktki i qoki va qä rha aa rhitsek. ");
INSERT INTO uro_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Auge qärak i qat täqäne sa akni nävät tärhae rhäkt ama rhoes kärak i qat nanakt na ngo bä sämät anga vuini di vadi mai mamär iva rhi er ti qop sa anga märän bäm ga anga duiqa vät aa qän näkt ti rhon na qa säp garäska. ");
INSERT INTO uro_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Dä ngakt bä ngia rhäqyet ngärhi rhartäm sä nge bä sämät anga vuini dä va ngi rhodäkt sä et nae. Inguna ama mär toqoräkt iva ngia rhon säva ama iar ama sok täm ngät i ama suktäkt pät a nge. Dap ama vu rhoqoräkt iva ngiat tet sä gia rhäqyisem moe bä sämät ama ivärhäs na ama mudäbäs ama sok tä bäs. ");
INSERT INTO uro_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Dä ngakt bä gia qäraet ngärhi rhartäm sä nge sämät anga vuini dä va ngi rhodäkt sä et nae. Inguna qoki ama mär toqoräkt iva ngia rhon säva ama iar ama sok täm ngät i suktäkt pät a nge. Dap ama vu rhoqoräkt iva ngiat tet nä gia qärisem moe sokt diva rhi rhon na nge sämät ama ivärhäs na ama mudäbäs ama sok tä bäs. ");
INSERT INTO uro_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Dä qosaqi ngakt bä gi saqongaqa qä rhartäm sä nge bä sämät anga vuini dä va ngia rhar täm ga nae. Inguna ama mär toqoräkt iva ngia rhon säp ma Ngämuqa aa Muräktpäm sokt sa ama saqongaqa ama sägäk dap ama vu rhoqoräkt i gi saqongaiom ama udiom sokt diva rhi rhon na nge sämät ama ivärhäs na ama mudäbäs ama sok tä bäs ");
INSERT INTO uro_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kärqosni i äkt di ‘ama qlap pät ama ruvek asägäk asägäk di qaku ngärhit ñäp dap ama mudäbäs di äs ngät dang basägos bä qaku anga tpäsini.’ ");
INSERT INTO uro_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ama ruvek moe diva rhi rhon bät a rha na ama rhäptäpki rhoqor tit don na ama qyiräpki vät ama tmäs.” ");
INSERT INTO uro_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ama qyiräpki di ama mär qi sokt di ngakt bä rhäksot na at märmät dä ngu lu va saqi as arha anga märmät ngä rhän doqor mäniekt? Mamär iva qale ama qyiräpki väm ngän bä va ama bulap mänguräp mä ngän.” ");
INSERT INTO uro_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Dä sa ma Jisas ka met nävät iosäkt ama ivärhäs bä qa mon säda ama ngärhäktka ma Judia aa ron bä särhage na ama rigi ma Jordan. Dä saqi as ama gulañ na ama ruvek ta män sagem ga. Dä qä su rha saqi rhoqor varhäm gärangätni aa lat. ");
INSERT INTO uro_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Dä arhani ama Farisiqäna rha män bä rha siqut na qa i rhi snanbät sä qa rhoqortäqyia, “Nga maräkt toqoräkt parhäm ma Ngämuqa aa Muräkt iva akni ama ruqa qä qutmäs aa egutki?” Dä qa snanbät sä rha rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","“Mudu ma Moses ka von ngän da ama muräkt toqor mäniekt?” ");
INSERT INTO uro_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Dä rha qoar na qa rhoqortäqyia, “Ma Moses di qa rhares iva ama ruqa qä säm ba ama abuqit na ama bäñmät sage aa egutki näkt kä rhäk na qi.” ");
INSERT INTO uro_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Dä qa muvät pät a rha rhoqortäqyia, “Ma Moses ka säm iangärhäkt ama muräkt dinguna nävät a ngän gärarhae i ama qrot angän bäs. ");
INSERT INTO uro_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Dap mudu vät ama rharimini di ‘sa ma Ngämuqa qa säm ama ruvek i ama gamoe dä ama evop.’ ");
INSERT INTO uro_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Rhoqoräkt bä va ama gamoeqa qa rhet daqule aa mam dä aa nan bä va västämne na iom gä na aa egutki ");
INSERT INTO uro_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","bä va sägäk na iom.’ Bä äkt i saqi as kaku ama udiom na iom dap kinak sa in män i ama sägäge ama släqyige na iom. ");
INSERT INTO uro_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dä soknga qale aung anga ruqa qä namat mät ianiäkt kärqäni i sa ma Ngämuqa qa västämne nä ini.” ");
INSERT INTO uro_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Dä saqi as nga rhoqoräkt i qale ma Jisas kä na aa mudäsaqongda va vät dä aa mudäsaqongda rhi snanbät sä qa närhä iangärhäkt aa enge. ");
INSERT INTO uro_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Dä qa muvät pät a rha rhoqortäqyia, “Aung gärakni i sa qa qutmäs aa egutki bä qa mät aktni di qä qavatnävätlägut sävät a qi. ");
INSERT INTO uro_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Dä qosaqi ngakt bä sa qia qutmäs arha egutka bä qia mät akni di qi qavatnävätlägut.” ");
INSERT INTO uro_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ama ruvek sa rhat dän sa arhä rhoes sage ma Jisas ivakt iva qat tu aa rhäkt pät a rha. Sokt di ama mudäsaqongda rha mair särhäm da. ");
INSERT INTO uro_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Bä nga ma Jisas ka lu rhoqoräkt dä qaku mär gem ga. Dä qa qoar na aa mudäsaqongda rhoqortäqyia, “Ngäni rhares pät ama rhoes arha rhäng iva rhat tet sagem ngo dap kale ngän dair särhäm da inguna ma Ngämuqa aa Muräktpäm di ngät bä bä iarhakt kärarhae i rha rhoqor tärha rhäkt ama rhoes. ");
INSERT INTO uro_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nguat tamän särhäm ngän na ama engäktki i auge qärak i qaku qä narha ma Ngämuqa aa Muräktpäm doqor anga rhoemga diva qaku qä namon säväm ngät.” ");
INSERT INTO uro_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma Jisas ka märhamän doqoräkt näkt sa qät ta ama rhoes bä qat tu aa rhäkt pät a rha dap kat dodämne na rha. ");
INSERT INTO uro_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nga ma Jisas kä nasäng i qat tet parhäm aa iska dä akni ama ruqa qa ang masirhat sagem ga bä qa an da aa quum sä nas gem ga dä qa snanbät sä qa rhoqortäqyia, “Qamorqa ama mär qa, ngu lu va ngua mäsana äkt iva dängdäng dä bä ba ngo na ama iar ama sok täm ngät?” Dä ma Jisas ka muvät pät a qa rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","“Mäniekt bä ngiat tes ngo i ama mär qa na ngo? Qaku aung di ama mär qa dap sokt ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Sa ngiat dräm ama Muräkt nage ma Ngämuqa qärangät i ngät tamän doqortäqyia, ‘Qale ngi veng dä qale ngi qavatnävätlägut dä qale ngi sua dä qale ngi iras na anga engirhong säda arhani arhä väs dä va ngit kutdrir sävät gi mam dä gi nan.’” ");
INSERT INTO uro_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dä qärak ka ruqa qa qoar nä ma Jisas toqortäqyia, “Qamorqa, rhangät täkt ama muräkt moekt di sa nguat tet parhäm ngät mänasäng mudu i ama rhoemga na ngo bä qoki as täkt.” ");
INSERT INTO uro_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Dä ma Jisas ka ñäm sävät kärak dap kät lavuqi na qa masirhat dä qa qoar na qa rhoqortäqyia, “As ama sägäni nga e qärqäni i mamär iva ngia rhualat nä ini. Ngia rhet bä va ngi vodä gi qärhong moe bä ngi von ama tläkta dä va ngi rha ama mämägän dävuk. Näkt pa ngi ang bä ngit päs gua rhäng.” ");
INSERT INTO uro_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Bä nga qa ruqa qa nari rhoqoräkt dä qa met i airäs ka inguna qa di ama qärhong bät a qa masirhat. ");
INSERT INTO uro_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Dä ma Jisas ka ñäm namet a nas näkt ka märhamän särha aa mudäsaqongda rhoqortäqyia, “Ama qrot masirhat ge ama qärhongbärharha iva rha rhon säp ma Ngämuqa aa Muräktpäm.” ");
INSERT INTO uro_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Dä ma Jisas aa mudäsaqongda di qräk mät ta nävät ma Jisas aa enge. Sokt di saqi as ma Jisas ka märhamän doqortäqyia, “Arhoes, ama qrot ka ama iska mamär ba anga ruqa iva qa rhon säp ma Ngämuqa aa Muräktpäm. ");
INSERT INTO uro_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ama qrot masirhat ge ama kamel iva qa rhon mät anga liqini va anga släpki qäraktni i rhit kutäm na qi at täväs dap sa ama qrot masirhat mamär ge ama qärhongbärhaqa iva qa rhon sävä ma Ngämuqa aa Muräktpäm.” ");
INSERT INTO uro_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Dä aa mudäsaqongda di nak sa qräk mät ta mamär dä rhi qoar na qa rhoqortäqyia, “Di rhoqoräkt di qop pa sirhäkt ngu lu va auge diva qä rha ama mumaiar?” ");
INSERT INTO uro_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Dä ma Jisas ka ñäm sävät a rha näkt ka qoar toqortäqyia, “Agini qärqäni i qaku mamär vät ama ruvek nä ini di mamär vät ma Ngämuqa nä ini. Inguna ama lat moe di mamär vät ma Ngämuqa nä ngät.” ");
INSERT INTO uro_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Dä ma Pita qa nasäng i qat tamän särhä ma Jisas toqortäqyia, “As ngi lu i aiut di sa ut met daqule aut kärhong moe bä ut päs gia rhäng!” ");
INSERT INTO uro_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Dä ma Jisas ka muvät pät aa mudäsaqongda rhoqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i iarhakt moe qärarhae i sa rha met daqule arha vät ura arha matpek ura arha läktpek ura arha morta ura arhä rhoes ura arha ivätki ivakt iva rhit päs gua rhang bä rhi sameng na ama sameng ama mär ngät ");
INSERT INTO uro_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","diva rhi rha savit na ama handret nä imek täkt mäni rhäni rhäkt ama rhodämini qärqäni i as tat däqäm i ama vät dä ama ngärhamatpek dä ama ngärhaläktpek dä ama ngätnanäkkina dä ama rhoes dä ama ivärhap ngä na ama märänga ura ama rhäksärhäm mavängam nage ama ruvek. Dap pät ama rhodäm nasot dä va rhi rha ama iar ama sok täm ngät. ");
INSERT INTO uro_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Sokt di ama rhäqäp na rha qärarhani i rhi rhoer täkt diva dängdäng na rha mamär dä ama rhäqäp na rha qärarhani i dängdäng na rha mamär täkt diva rhi rhoer.” ");
INSERT INTO uro_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ma Jisas kä rhoer nanokt aa mudäsaqongda rhi na ama ruvek näva ama iska sae ma Jerusalem dä aa mudäsaqongda di qräk mät ta rhoqoräkt dap ama ruvek kärarhani i rhit päs arha rhäng di qänäskänes ta nävät iangärhäkt aa enge. Dä saqi as ma Jisas ka rhäqoar sa ama ngärhäqyisem da udiom na rha sä nas bä qä sameng ba rha sävät iomäkt ama qäväläm gärqomni iva äm ngä rhän bät a qa i qa sameng doqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“As ngäni lu i sa ut tet tävit sae ma Jerusalem bä va ma Ruqa aa Emga diva rhi vodäm ga sämät ama priskäna ama moräs na rha rhi na ama Skraipkäna arhä rhäkt. Bä va rhi rhares pät aa rhäng sämät ama tñäpki näkt pa rhi vodäm ga ba ama Jentailqäna ");
INSERT INTO uro_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","qärarhani iva rhat tuma qa näkt pa rhit kot pät a qa bä va rha rhäranäs ka näkt pa rhi veng ga. Näkt pa nasot ama dävaung ama qunäng dä qa rhäranas.” ");
INSERT INTO uro_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nasot dä ma Jems kä nä ma Jon ma Sebedi aa imiom in män sage ma Jisas dä ini qoar na qa rhoqortäqyia, “Qamorqa, nani a un iva ngia rhualat na agini qärqäni iva as uni nän nge rhäm ini.” ");
INSERT INTO uro_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Dä ma Jisas ka snanbät toqortäqyia, “Nani a en iva ngua rhualat na agiqa ba en?” ");
INSERT INTO uro_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Dä in muvät toqortäqyia, “Mamär iva ngi rhares iva mugas dä gi murhämeska aa ron dä va un duqun iva ak dä gi sael dap ak dä gi märmär.” ");
INSERT INTO uro_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Dä ma Jisas ka qoar na iom doqortäqyia, “Aien di qaku inät dräm agini ianiäkt kärqäni i ini nän däm ini. Nga mamär vät a en iva ini nakt nämät ama kap na ama märänga qärak iva ngu nakt nämät ka ura nga mamär vät a en iva ini rha ama baptais na ama tñäpki qärangät iva ngu rha ngät?” ");
INSERT INTO uro_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Dä in muvät pät a qa rhoqortäqyia, “Mamär vät a un.” Dä ma Jisas ka qoar na iom doqortäqyia, “Va ini nakt nämät ama kap kärak iva ngu nakt nämät ka bä va ini rha ama baptais na ama baptais kärangät iva ngut ta ngät ");
INSERT INTO uro_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","dap iomäkt iva aung ga rhuqun dä gu märmär ura aung dä gu sael di qoki qaku mamär iva ngu namuräkt toqoräkt. Iamemäkt ama mämugunimem di qoki bä bä iaiomäkt kärqiom i sa ma Ngämuqa qa rhäkmu nä imem bä ba iom.” ");
INSERT INTO uro_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bä nga ma Jisas aa mudäsaqongda arhani ama ngärhäqyisem na rha rha nari rhoqoräkt dä rha nasäng i rhir qur ma Jems kä nä ma Jon. ");
INSERT INTO uro_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Dä qa mes ta sagem mes näkt ka qoar na rha rhoqortäqyia, “Sa ngänät dräm i iarhakt kärarhae i mädräm sä varhäm i ama tpäskinarha bä ba ama Jentailqäna di qoki rhat turäkt täm da masirhat bä arha moräsnarha di rhat sangar a rha na ama muräkt ama qrot ngät daver mä rha. ");
INSERT INTO uro_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Dap kinak mänguräp mä ngän diva qale rhoqoräkt. Dap aung gärakni i nani a qa iva ama moräs na qa mänguräp mä ngän di qoki va qale qa va angäna rem ");
INSERT INTO uro_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","bä aung gärakni i nani a qa iva ama narhoer qa di qoki va qale qa va ama ruvek moe arha rem. ");
INSERT INTO uro_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","I qäqi ma Ruqa aa Emga di qaku qa män ivakt iva ama ruvek tat tualat bä ba qa dap kinak ka män ivakt iva qat tualat ba ama ruvek bä va qä voda aa iar ivakt iva qä rhäksasot ama rhäqäp na rha.” ");
INSERT INTO uro_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nasot dä ma Jisas kä na aa mudäsaqongda rha män sae sämät ama värhäm ama mor äm ma Jeriko. Bä nga vät ama qäväläm gärqomni i ma Jisas kä na aa mudäsaqongda näkt ama guläñgi ama mor qi na ama ruvek tat tet nävä iomäkt ama mor äm ama värhäm dä akni ama säsurqa qärak i rhat tes ka i ma Bartimeus ma Timeus aa emga di qat muqun e vät ama iska aa rhäkt dap kä nän dä ligär toqor vasägos i qat tualat. ");
INSERT INTO uro_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bä nga vät ama qäväläm gärqomni i qa räm i ma Jisas nae ma Nasaret di iaqäkt kärak i qat tet dä qa nasäng i qät näs tävuk toqortäqyia, “Jisas ma Devit aa emga, ngi lavuqi na ngo.” ");
INSERT INTO uro_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Dä ama rhäqäp na rha ama ruvek tit näs täm ga dä rhi qoar na qa iva mänadin däm ga sokt di nak kät näs masirhat toqortäqyia, “Ma Devit aa emga na nge, ngi lavuqi na ngo.” ");
INSERT INTO uro_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Dä ma Jisas ka mair bä qa qoar na aa mudäsaqongda rhi na ama ruvek toqortäqyia, “Ngän des ka sagem ngo.” Dä rha näs sage qä säsurqa rhoqortäqyia, “Mär gem nge! Ngia rhäranas! Ma Jisas kat tes nge!” ");
INSERT INTO uro_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bä nga qärak ka nari rhoqoräkt dä qa rhon na aa boiqi ama uiu qi näda aa lang särhage dap ka märanas masägos bä qa met sage ma Jisas. Dä ma Jisas ka snanbät sä qa rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“Nani a nge iva ngua rhualat na agiqa bä ba nge?” Dä qä säsurqa qa muvät toqortäqyia, “Qamorqa, vadi va nguat nañäm.” ");
INSERT INTO uro_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Dä ma Jisas ka qoar na qa rhoqortäqyia, “Ngia rhet, gi qatnanakt di sa ngä mumäräs pät a nge.” Vät iomäkt ama qäväläm dä qop kärak ka ñäm masägos bä qat tet nasot ma Jisas parhäm ama iska. ");
INSERT INTO uro_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Bä nga ma Jisas kä na aa mudäsaqongda rhat tet bä sa glaqot na ama värhäm ama mor äm ma Jerusalem dä rha män bät ama värham ama lel am ma Betfage dä ma Betani mäni ama damgi ama gaini na qi ama Damgi na ama Olip. Dä ma Jisas ka rhäk na aa mudäsaqongiom ama udiom ");
INSERT INTO uro_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","i qä qoar na iom doqortäqyia, “In det säp iomäkt ama värhäm ama lel äm gärqomni i äm nga e vä in gamäs bä nak kop as pa rhoqoräkt i inät don sävä bäm dä va in dän bät ama donki ama rhoem ga qärakni i sa rha qop sä qa sae i as mudu qaku aung ga muqun bät aa rhäng. Dä ini rhäväkt sä qa näkt in dän sä qa sarhe. ");
INSERT INTO uro_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Dap ngakt bä aung gä snanbät sä en doqortäqyia, ‘Mäniekt bä in dualat toqoräkt?’ dä va ini qoar na qa rhoqortäqyia, ‘Ma Engeska nani a qa na qa näkt pa saqi qä lir qä evär däm ga.’” ");
INSERT INTO uro_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Dä in met bä in män bät ama donki ama rhoem ga dalek mäni ama iska qärakni i sa rha qop sä qa bä nga rhoqoräkt i init täväkt sä qa ");
INSERT INTO uro_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","dä arhani ama ruvek i rhat mair e rha snanbät toqortäqyia, “Init täväkt sä iaqäkt ama donki iva iva?” ");
INSERT INTO uro_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Dä in muvät pät a rha rhoqor varhäm ma Jisas aa enge qärangätni i qa qoar na iom. Dä ama ruvek ta rhares pät ina rhäng bä in met sä qä donki. ");
INSERT INTO uro_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bä in män sä qä donki ge ma Jisas dä in don nä in baulem ama uiu em bät aa rhäng dä ma Jisas ka muqun bät aa rhäng. ");
INSERT INTO uro_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dä ama rhäqäp na rha ama ruvek ti vreng arhä boi ama uiu ngät pät ama iska dap arhani rha rhodäkt sa ama ngämung angät ngärhäqyitnäk sä itnäk angä rhäkt bä rhi aneng itnäk pät ama iska. ");
INSERT INTO uro_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Näkt iarhakt kärarhae i rhi rhoer bä qärarhani i dängdäng na rha di rhit näs toqortäqyia, “Hosana!” “Mamär iva ama modämne sävät tak täkt kärak i qat dän nävät ma Engeska ma Ngämuqa aa ngärhipki!” ");
INSERT INTO uro_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Mamär iva ama modämne sävät aut mamäk ma Devit aa muräktpäm gärangätni i ngät dän! Bä va ngi rha ama vitnaqa aa mämugunäs i mudu nasot aut mamäk ma Devit!” “Hosana, ama ansäs sage ma Ngämuqa rhävuk da ama usäpki arha ron!” ");
INSERT INTO uro_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ma Jisas ka mon sae ma Jerusalem bä qa met bä säva ama ansäspämgi ama mor qi bä qa lu iarhongäkt moe väm gi sokt di sa nguna rhoqoräkt di sa säpbängang mamär dä qop ka met nämät ama värhäm ama mor äm gä na aa mudäsaqongda bä sae ma Betani. ");
INSERT INTO uro_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Vät ama qunäga duququ qärak i ma Jisas kä na aa mudäsaqongda rhat tet nae ma Betani bä saqi sae ma Jerusalem dä ma Jisas di anoeng mä qa. ");
INSERT INTO uro_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Rhoqoräkt dä sa qa ñäm dä qa lu ama gosaqi qäraktni i at tärhäkt di ama ngärhäqyitnäk nga e vät a ngät dä qa met iva qä ñäm sävät at täqän ivar arha anga gavam. Bä nga qa män bät kä gosaqi dä qa lu i qaku arha anga gavam dap sokt ama ngärhäqyäm i as nguna qaku ama gos angät käväläm iva ngärhit sa. ");
INSERT INTO uro_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nasot dä qa märhamän särhä qä gosaqi rhoqortäqyia, “Mamär iva saqi as mirhup kaku aung gä namäs nävät ngia qän.” Dap aa mudäsaqongda di rha nari qa i qa märhamän doqoräkt. ");
INSERT INTO uro_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bä sa nga rha män e ma Jerusalem dä ma Jisas ka mon säva ama ansäspämgi ama mor qi arha ivärhäm bä qa nasäng i qät kutmäs iarhakt kärarhae i rhit boda arhä qärhong bä sävät kärarhani i rhit bodäm bät arhongni e vä bäm. Bä qa näpgoer nä qärarhani i rhit kutsasorhane na ama ligär arhä lai dä qosaqi qa rhar da ama mämugunimek sä iarhakt kärarhae i rhit boda ama ituap arhä lai. ");
INSERT INTO uro_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Näkt kaku qa rhares pät aung aa rhäng iva qät ta aa qärhong da ama ansäspämgi ama mor qi arha ivärhäm angärha ron. ");
INSERT INTO uro_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bä nga rhoqoräkt i qä su rha dä qa qoar toqortäqyia, “Nga sa qaku rha säm doqortäqyia, ‘Gua vätki diva rhat tes ki i ama vätki na ama nän ba ama ruvek moe nävät ama ivätki?’ Dap aingän di sa ngän mualat sä qi ma ‘ama suarha arhä qeqi.’” ");
INSERT INTO uro_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Dä ama priskäna ama moräs na rha dä ama Skraipkäna rha nari rhoqoräkt dä rhi nasäng i rhit ñäm nani anga iska iva rhi veng ma Jisas inguna rhit len ga i sa nguna ama guläñgi moe na ama ruvek di qräk mät ta mamär nävät aa rhisu. ");
INSERT INTO uro_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Bä sa nga rhoqoräkt i bängangäs dä ma Jisas kä na aa mudäsaqongda saqi as evär däm da nämät ama värhäm ama mor äm ma Jerusalem ivakt iva rha rhas. ");
INSERT INTO uro_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Bä nga vät duququs toqoräkt i ma Jisas kä na aa mudäsaqongda rhat tet dä rha lu qä gosaqi i qek däm gi bä samäk i at snagut. ");
INSERT INTO uro_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Dä vuk pät ma Pita dä qa qoar nä ma Jisas toqortäqyia, “Qamorqa, ngi lu! Qä gosaqi qäraktni i sa ngia märhamän särhäm gi na ama enge ama qrot ngät di sa qek däm gi!” ");
INSERT INTO uro_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Dä ma Jisas ka muvät toqortäqyia, “Mamär iva ngänät nanakt nä ma Ngämuqa.” ");
INSERT INTO uro_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“Nguat tamän särhäm ngän na ama engäktki i ngakt bä aung ga rhamän särhä rhakt täkt ama damgi rhoqortäqyia, ‘Ngia rhäranas bä säva ama garäska’ dap kaku aa snängaiom ama udiom dap kat nanakt i iangärhäkt aa enge diva engäktki na ngät diva qoki rhäkmamär toqoräkt. ");
INSERT INTO uro_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Bä nga rhoqoräkt dä ngu qoar na ngän i agini qärqäni i ngäni nän däm ini vät angäna nän dä ngänät nanakt i sa ngän da ini dä va ini ngä rhän ba ngän. ");
INSERT INTO uro_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Dap nga ngänät mair dap ngäni nän näkt nga ama vu dä angäna ron na aung anga ruqa dä va ngäni qyiradeng bä ba qa ivakt iva angän mam na rhävuk pa qä qyiradeng na angäna vuirhong.” ");
INSERT INTO uro_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Dä saqi as ma Jisas kä na aa mudäsaqongda rha män e ma Jerusalem bä nga rhoqoräkt i ma Jisas kat tet da ama ansäspämgi ama mor qi arha ron dä ama priskäna ama moräs na rha rhi na ama Skraipkäna näkt ama morta rha män sagem ga. ");
INSERT INTO uro_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Näkt ti snanbät sä qa rhoqortäqyia, “Ngiat tualat toqor täkt di na ama qrot nage auge? Auge qa von nge rhä rhangät täkt ama qrot?” ");
INSERT INTO uro_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Dä ma Jisas ka muvät toqortäqyia, “Va ngu snanbät sä ngän na ama sägängät ama snanbät. Näkt ngakt bä ngän duvät pät a ngo dä va ngu qoar na ngän i sa auge qa von ngo rha ama qrot iva nguat tualat nä rhärhong däkt. ");
INSERT INTO uro_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ma Jon gä baptais pät ama ruvek di iangärhäkt di nga ngät na rhävuk ura ngät nage ama ruvek? Ngäni qoar na ngo.” ");
INSERT INTO uro_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dä rhat tamän särhäm ne sä iangärhäkt aa snanbät dä rhi qoar na ne rhoqortäqyia, “Ngakt bä urhi qoar i iangärhäkt ma Jon aa baptais di ngät na rhävuk dä va qä snanbät sä ut toqortäqyia, ‘Bä nga rhoqoräkt dä mäniekt bä qaku ngän mat maengäkt nämät ka?’ ");
INSERT INTO uro_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Dap ngakt bä urhi qoar toqortäqyia, ‘ngät di ngät nage ama ruvek’ dä mamär iva urhit len ama ruvek inguna sa rha moe rhat lu ma Jon di nak koki akni ma Ngämuqa aa vämginaqa na qa.” ");
INSERT INTO uro_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bä äkt i sa rha muvät pät ma Jisas toqortäqyia, “Qaku ut dräm.” Dä ma Jisas ka qoar na rha rhoqortäqyia, “Dä qosaqi ngo diva qaku ngu naqoar na ngän i nguat tualat nävät auge aa qrot.” ");
INSERT INTO uro_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Dä ma Jisas ka nasäng i qat tamän särha ama priskäna ama moräs na rha rhi na ama Skraipkäna näkt ama morta na ama enge na ama siqut i qat tamän doqortäqyia, “Maos dä akni ama ruqa qa qutnanokt ama qauligleng bät aa etki qärqiglengni i rhat tes igleng i ama wain. Näkt ka mualat na ama surqa namet igleng dä qosaqi qa nges ama uqupka ama mor qa nanokt ama qauligleng angät gavam iva rhit täkbrät ngät e. Näkt kosaqi qa rhäk pät ama näski ama uiu qi ivakt iva ama latta rhat narhäksärha ama etki näda at täväs. Qa mualat toqoräkt näkt ka von arhani ama latta rha aa lat iva rhat tualat na ngät bä ba qa iva nasot dä va rha rhatmät ama qauligleng angät gavam iva angätni bä ba ama latta dap angätni va bä ba qa. Dap ka met sävät aosni ama ivärhäs. ");
INSERT INTO uro_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Bä sa nga sräp ama etki dä qärak ka ruqa qa rhäk na akni ama latka sage qa latta ivakt iva qä rha aa nengäs na ama qauligleng angät gavam nagem da nävät aa etki. ");
INSERT INTO uro_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Sokt di rha sangar a qa näkt ta arhäktgyäm sä qa näkt ta rhäk na qa dap kaku qa rha agung. ");
INSERT INTO uro_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Bä saqi as mamär dä qa ruqa qa rhäk na akni aa latka sagem da. Dä rha e da aa uväs bä rha von ga rha ama qluqi. ");
INSERT INTO uro_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Sokt di saqi as ka rhäk na akni aa latka rhoqoräkt sae dä rha veng ga. Dä qosaqi qa rhäk na arhani ama rhäqäp na rha sae dä qa latta vät aa etki di rha arhäktgyäm sa arhani dap arhani di sa rha veng da. ");
INSERT INTO uro_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Bä sa qa ruqa di sokt pät aa sägäk ama ruqa qa e iva as kä rhäk na qa. Iaqäkt ama sägäk di aa emga qärakni i aa snäng bät a qa mamär. Iaqäkt di ama dängdängini na qa qärakni i qa ruqa qa rhäk na qa. Bä nga qät täk na qa dä qat tamän doqortäqyia, ‘Iarhakt diva rhi qutdrir vät ngua emga!’ ");
INSERT INTO uro_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Sokt di nak ka latta nävät kärak aa etki rha qoar na ne rhoqortäqyia, ‘Rhak täkt di iaqäkt kärak iva qä rha ama etki nasot aa mam. Ngäni ang bä urhi veng ga dä va ba ut na ama etki.’ ");
INSERT INTO uro_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dä rha sangar a qa bä rha veng ga näkt ta rhon na qa sä dalek na ama etki. ");
INSERT INTO uro_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Rhoqoräkt dä ngu lu va ama etki arha ik kärakni i aa lat iangärhäkt na ama wain ga mäsana? Va qa rhän bä qä veng iarhakt ama latta dap pa qä von guavek tä iangärhäkt ama lat na ama wain. ");
INSERT INTO uro_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nga sa qaku ngän mes ma Ngämuqa aa enge qärangätni i ngät tamän doqortäqyia, “‘Ama duiqa qärak i mudu iarhakt kärarhae i rhat dräm dit täk pät ama vät ta mer mä qa di nak kärak iaqäkt i rhäkt di ama qrot ama vätki nagem ga qärak i qat sangar a qi moe. ");
INSERT INTO uro_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Qoki ma Ngämuqa qa mualat toqoräkt bä ut lu i iangärhäkt aa lat di ama mär ngät mamär da aut saqong’?” ");
INSERT INTO uro_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Dä qä narhoerta di rhit ñäm nani anga iska ivakt iva rhi sangar ma Jisas inguna rha räm i sa qa märhamän na ama enge na ama siqutki di sävät a rha. Sa rha siqut iva rhi sangar a qa dä qaku inguna rhit len ama ruvek dä qop ta met daqule qa. ");
INSERT INTO uro_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nasot dä rha rhäk na arhani ama Farisiqäna rhi na arhani ma Herot aa ruvek sage ma Jisas iva rhi irastäm sä qa i vadi va qa rhamän bät anga enge qärangätni i qaku maräkt ivakt iva rhi sangar a qa nävät a ngät. ");
INSERT INTO uro_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Dä sa rha män ge ma Jisas dä rhi qoar na qa rhoqortäqyia, “Qamorqa, sa ut dräm i ngiat tamän bät ama engäktki bä qaku qänäskänes nge sävät ama ruvek arhä mungäsnäng inguna ama ruvek arhä mämairimek di qaku imek ngä narut na nge. Dap kinak ngi su na ama engäktki sävät ma Ngämuqa aa snängaqa ba ama ruvek. Nga maräkt parhäm ama Muräkt iva urhit bon ma Sisar ta ama takes ura qaku? Mamär iva urhit bon da ama takes ura qaku?” ");
INSERT INTO uro_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sokt di ma Jisas ka räm arha irasini dä qa snanbät sä rha rhoqortäqyia, “Mäniekt bä ngäni siqut na ngo? Ngäni rha anga qunäga ama sägäk aa rhitsek angät ligärige ba ngo ivakt iva ngu lu ige.” ");
INSERT INTO uro_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dä rha rha ama ligärige rhoqoräkt ba qa näkt ka snanbät sä rha rhoqortäqyia, “Auge aa iauski rhakt täkt päm ige? Dä auge aa sämsäm dangät täkt päm ige?” Dä rha muvät toqortäqyia, “Ma Sisar.” ");
INSERT INTO uro_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Ngäni von ma Sisar tä iarhongäkt kärqärhong i qoki ma Sisar aa qärhong dap pa ngäni von ma Ngämuqa rhä iarhongäkt kärqärhong i qoki ma Ngämuqa aa qärhong.” Bä nga ma Jisas ka qoar na rha rhoqoräkt dä qräk mät ta nävät a qa. ");
INSERT INTO uro_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nasot dä arhani ama Sadyusiqäna rha män ge ma Jisas sa arhä snanbät bä rhi qoar na qa rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Qamorqa! Mudu ma Moses ka säm ama muräkt bä ba ut i ngakt bä nga aung anga matka qä ñäp daqule aa egutki dap kaku ina anga es dä va aa läktka qa rhät iaqyäkt ama maqoski ivakt iva qä sa vät a qi bä ba aa matka. ");
INSERT INTO uro_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Maos dä qale ama sägärhae ama ngärhäqyet da udiom na rha ama gamoe. Dä ama narhoerqa qa mät ama evopki näkt ka ñäp dap kaku aa anga es. ");
INSERT INTO uro_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Dä ama udiomnaqa qa mät ama narhoerqa aa egutki sokt di qosaqi qa ñäp daqule qi dap kaku qa sa vät a qi. Dä qosaqi qärak ama dävaungnaqa di qosaqi rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Dä qosaqi sa arhani rhämane arha läktpek ama levaet na rha di rha moe rha ñäp i rha qutsasorhane gem gi. Bä qoki rha moe ama ngärhäqyet da udiom na rha di qaku aung ga sa vät a qi. Dap nga dängdäng dä qosaqi qa ruqi qia ñäp. ");
INSERT INTO uro_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Va auge aa egutki na qi mirhup pät ama qäväläm gärqomni iva ama ruvek ta rhäranas nämät ama tñäpki inguna rha moe ama ngärhäqyet da udiom na rha sa rha mät a qi?” ");
INSERT INTO uro_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Qaku maräkt na angän snängaqa inguna sa qaku ngänät dräm ma Ngämuqa aa enge dap kosaqi qaku qunäga vät a ngän sa aa qrot. ");
INSERT INTO uro_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Inguna nasot ama qäväläm gärqomni iva rha rhäranas nämät ama tñäpki diva qaku ama ruvek ti namätlägut bä qosaqi va qaku ama ruvek ti navon da arhani ama ruvek sämät ama ngärhaegurhini dap kinak ta diva rha rhoqor ama enselqäna na rhävuk da ama usäpki arha ron. ");
INSERT INTO uro_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Dap sävät ama ruvek ama ñäp ta qärarhani i rhat täranas nämät ama tñäpki di nga sa qaku ngän mes pä ma Moses aa abuk i qa säm sävät ama ngämungäm ama iar äm i äm ngät dang. Bä sävät iangärhäkt ma Ngämuqa aa enge qärangätni i qa qoar nä ma Moses toqortäqyia, ‘Aingo di ma Abraham gä nä ma Aisak dä ma Jekop arhä Ngämuqa.’ ");
INSERT INTO uro_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ma Ngämuqa di qaku ama ñäpta arhä Ngämuqa dap kinak ka di ama ngätdäqämda arhä Ngämuqa. Aingän angän mungäsnäng di qoki qaku maräkt na ngät.” ");
INSERT INTO uro_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Rhoqoräkt i ma Jisas kä na ama Sadyusiqäna rhit beng bät a ne na ama enge dä akni ama Skraip ka män bä qat nari rha. Bä nga qa nari rhoqoräkt i ma Jisas ka muvät pät ama Sadyusiqäna na ama mär qi ama muvätki dä soknga qa snanbät sä ma Jisas toqortäqyia, “Agi muräkt di ama moräs na ngät mamär nävät ma Ngämuqa aa Muräkt moe?” ");
INSERT INTO uro_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Dä ma Jisas ka muvät toqortäqyia, “Ama muräkt kärangätni i ama moräs na ngät mamär di rhoqortäqyia, ‘Ngäni nari Israelqäna, ma Engeska aut Ngämuqa di sokt ka ama sägäk. ");
INSERT INTO uro_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mamär iva gia snäng bät ma Engeska gi Ngämuqa nä gi snängaqa moe bä nä gi mungäsnäng moe bä nä gi mädräm moe bä nä gi qrot moe.’ ");
INSERT INTO uro_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Näkt ama unmem na ngät ama muräkt di rhoqortäqyia, ‘Mamär iva gia snäng bät arhani i rhoqor qre i gia snäng bät a nas.’ Dap kaku agung anga muräkt di ama moräs na ngät pä rhangät täkt ama unmem na ngät angät tpäs.” ");
INSERT INTO uro_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dä qärak ka Skraip ka muvät toqortäqyia, “Qamorqa, ngäktki na nge mamär. Ngäktki na nge rhoqoräkt i ngiat tamän i ma Ngämuqa di sokt ka ama sägäk dap saqi as kaku aung. ");
INSERT INTO uro_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bä mamär iva gua snäng bät a qa nä gu snängaqa moe bä nä gu mädräm moe bä nä gu qrot moe bä qosaqi va gua snäng bät arhani i rhoqor qre i gua snäng bät a nas. Di iangärhäkt ama muräkt di ama moräs na ngät mamär daver ama vodämes moe sage ma Ngämuqa.” ");
INSERT INTO uro_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Bä nga ma Jisas ka lu i qärak ka muvät pät a qa na ama mädräm ama mär ngät dä qa qoar na qa rhoqortäqyia, “Ainge di qaku qale nge gläius nä ma Ngämuqa aa Muräktpäm.” Bä sa nga nasot iangärhäkt ma Jisas aa enge dä qaku anga ruqa di nani a qa iva qä snanbät sä ma Jisas na anga snanbät inguna sa rhit len. ");
INSERT INTO uro_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nga vät ama qäväläm gärqomni i ma Jisas kä su ama guläñgi na ama ruvek pa ama ansäspämgi ama mor qi dä qa snanbät sä rha rhoqortäqyia, “Mäniekt bä ama Skraipkäna rhi qoar i ma Krais di nak ma Devit aa emga na qa? ");
INSERT INTO uro_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ngu snanbät toqor täkt inguna mudu ama Qloqaqa qa märanas nä ma Devit bä qa qoar toqortäqyia, “‘Ma Ngämuqa qa qoar nä gua Engeska rhoqortäqyia, “Ngia rhuqun dä gu märmär bä qale nge e bä dängdäng iva ngun but sä gia ikkäna säp gia rem.” ’ ");
INSERT INTO uro_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Bä nga rhoqoräkt di nga ma Devit kat tes ka rhoqortäqyia, ‘Engeska’ dä ngu lu rhoqor mäniekt iva ma Krais diva qosaqi ma Devit aa emga na qa?” Bä sa ama guläñgi na ama ruvek di märmär tat nari ma Jisas toqoräkt. ");
INSERT INTO uro_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Rhoqoräkt i ma Jisas kä su dä qä qoar toqortäqyia, “Ngänit lu nämät ama Skraipkäna. Iarhakt di nani a rha iva rhat pitmane sa ama boi ama uiu ngät pät a nas bä nani a rha masirhat iva ama ruvek ti rhar sä rha na ama qutdrir vät ama ivärhimek kärqämekni i ama ruvek tit boda arha tmäs e ");
INSERT INTO uro_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","dä nani a rha iva rhat tuqun bät ama lai vuk dä ngärhaväm ba ama mämairväm dä nani a rha na ama mämugunimek ama vit nä imek pa ama tmäsimek. ");
INSERT INTO uro_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Dap kosaqi rhat täs pät ama evop ama maqosta sa arhä qärhong näva arha vät dä rhi nän na ama uiu ngät ama nän iva säda ama ruvek arhä saqong. Iarhakt kärarhae i rha rhoqor täkt diva ma Ngämuqa qä rhäksärhäm da dä va qä sangäm na rha masirhat.” ");
INSERT INTO uro_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ma Jisas ka muqun dage na ama ivärhäs kärqosni i ama ruvek tit boda arhä vänbon sae dap kat lu ama guläñgi na ama ruvek i rhit boda arhä ligär sämät ama ansäspämgi ama mor qi at mämuäs na ama vänbon. Rhoqoräkt di ama rhäqäp na rha ama ruvek ama qärhong bät a rha rhit boda ama ligär masirhat. ");
INSERT INTO uro_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Dap aktni ama tlä qi ama maqoski di qia män bä qia voda ama brasirhom ama gaini nä irhom mamär. ");
INSERT INTO uro_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Dä ma Jisas ka mes aa mudäsaqongda sagem mes näkt ka qoar na rha rhoqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i rhakt täkt ama tlä qi ama maqoski di sa qia voda ama ligär masirhat sämät ama mämuäs na ama vänbon ba arhani moe arhä väs. ");
INSERT INTO uro_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Iarhakt moe di rha von nävät arhä mämägän dap takt täkt di sa qia von nävät arha tläqa i qia von dä ianiäkt moe i mai va ama iar qi nävät ini.” ");
INSERT INTO uro_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Bä sa nga rhoqoräkt i ma Jisas kat tet näva ama ansäspämgi ama mor qi dä akni nävät aa mudäsaqongda qa qoar na qa rhoqortäqyia, “Qamorqa, ngi lu ama mor ngät mamär ama vät dä ama enges ngät mamär ama dui qärangätni i sa rha andäm bäm ngät na ngät.” ");
INSERT INTO uro_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Dä ma Jisas ka muvät toqortäqyia, “Nga sa ngiat lu iangärhäkt moekt ama mor ngät mamär ama vät? Rhangät täkt ama dui diva qaku qale akni anga duiqa vono vät akni aa rhäng dap pa rha rhartäm sä ngät moe sa rhämono sävät ivät.” ");
INSERT INTO uro_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Dä sa nga rhoqoräkt i ma Jisas kat muqun da ama Damgi na ama Olip at täväs tage na ama ansäspämgi ama mor qi dä ma Pita qä nä ma Jems dä ma Jon näkt ma Andru rhi snanbät sä qa rhoqoräkt i sokt ka qä na rha rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ngi qoar na ut iva qäsnia dä va rhärhong däkt ngä rhäranas? Dä va agi muqunängi qia rhän iva qi sameng i qorhäs iva sa rhäkmamär nä rhärhong däkt?” ");
INSERT INTO uro_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Dä ma Jisas ka nasäng i qä qoar na rha rhoqortäqyia, “Ngänit lu i varis aung gä nairas täm ngän. ");
INSERT INTO uro_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ama rhäqäp na rha ama ruvek diva rha rhän bä rhat tualat nävät gu ngärhipki i rhi qoar i, ‘Aingo di ma Krais!’ bä va rha rhäqäne sa anga rhäqäp na rha anga ruvek sagem mes. ");
INSERT INTO uro_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Ngakt bä nga ngäni nari i sa ama ulaqi qia märanas pät ama ivärhap ama rhäqäp na ap ura ngäni nari iva ama ulaqi qia rhäranas pät amekni anga ivärhimek dä va qale qänäskänes ngän. Qoki va rhärhong däkt diva irhong ngä rhän dap ama tpäsini di as ini nga e iva as ini ngä rhän. ");
INSERT INTO uro_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dä ama ruvek näva amni ama ivärham diva rhat täranas na ama ulaqi sävät a ne dä ama muräktpäm diva ngät täranas sävät a ne. Dä va ama qängän bät ap ama ivärhap dä va ama ruvek tit ñäp mät ama qärhuqi. Rhärhong däkt di ama narhuirirhong sa ama märänga qärakni iva as kat täranas. ");
INSERT INTO uro_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Sokt diva ngänit lu inguna angäna ikkäna diva rha rhet sä ngän säda ama muräkt angät saqong bä va rha rhäranäs ngän ba ama mämairväm. Dä qosaqi nävät iomäkt i ngänät nanakt na ngo dä va ngän dair da ama tpäskinarha rhi na ama vitnarha arhä saqong bä va ama släqyäs ba ngän ivakt iva ngäni sameng sävät a ngo. ");
INSERT INTO uro_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Näkt pa ama narhoeräm di ama sameng ama mär ngät ngä rhet sage ama ruvek pät ama ivätki moe dä sa va nasot dä va ama tpäsini ngä rhän. ");
INSERT INTO uro_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Qre va rhi sangar a ngän bä rhat tair na ngän ba anga muräkt dä va qale qänäskänes ngän iva ngän damän doqor mäniekt. Dap pa sokt ngän damän bät agi enge qärangätni iva ama Qloqaqa ama Qumärqumärqa qä von ngän däm ngät inguna va qaku ngän maräkt ngän natmärhamän dap kinak pa ama Qloqaqa ama Qumärqumärqa qat tamän. ");
INSERT INTO uro_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Va ama gamoe diva rhi voda arha matpek dä arha läktpek ba ama ruvek ivakt iva rhi veng da. Dap arhani ama ngätmamäkkäna diva rhi von da arhä rhoes ba ama ruvek bä va rhi veng da dä qosaqi arhani ama rhoes diva uraqi da arha ron na arha morta bä va rhi vodäm da ba ama ruvek bä va rhi veng da. ");
INSERT INTO uro_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ama ruvek moe diva ama vu da arha ron na ngän mamär inguna nävät iomäkt i ngänät nanakt na ngo. Sokt di iaqäkt kärak i qat mair ma ama qrot bä dängdäng bät ama tpäsini diva qä rha ama mumaiar.” ");
INSERT INTO uro_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Dap mamär iva auge qärak i qat tes tangät täkt ama enge qä räm ama rharimini sä rhärhangät täkt ama lat toqoräkt i qat lu ianiäkt kärqäni ama vu ini mamär dä ma Ngämuqa aa saqong i qali lini vät ama ivärhäs kärqosni i qaku mamär iva qali lini e qärqäni i ini ngärhi slava nä iarhongäkt moe. Dä mamär iva iarhakt kärarhae i qale rha e ma Judia di rhi ang masirhat pävit sävät ama dam. ");
INSERT INTO uro_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Näkt mamär iva aung gärakni i qale qa vät ama vätka aa rhäng di saqi as kale ar sä qa bä qä namon säva vät nani aa qärhong. ");
INSERT INTO uro_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bä aung gärakni i qale qa vät a etki di saqi as kale evär däm ga iva nani aa boiqi ama uiu qi. ");
INSERT INTO uro_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Va ama qrot mamär vät iangärhäkt ama qunäng ba ama evop kärarhani i ama sarem däm da bä qosaqi bä iarhakt kärarhae i ama rhoes pät a rha. ");
INSERT INTO uro_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bä mamär iva ngäni nän iva rhi ngang di qale mät soeng. ");
INSERT INTO uro_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Inguna ama märänga vät iangärhäkt ama qunäng diva ama mor qa masirhat pa ama märän angät tpäs moe qärangätni i mudu mänasäng bät ama qäväläm gärqomni i sa ma Ngämuqa qa säm iarhongäkt moe bä sarhäkt bä qop as nasot. ");
INSERT INTO uro_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Dap mai ngakt bä qaku ma Ngämuqa qa sämaqot säva ama qunäng dä vadi mai qaku anga ruqa qärakni iva ama iar qa. Dap nguna nävät iarhakt kärarhae i sa qa armeng däm da dä qa sämaqot na ama qunäng. ");
INSERT INTO uro_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Bä nga vät iangärhäkt ama qunäng di ngakt bä aung gä qoar na ngän doqortäqyia, ‘Ngäni lu i ma Krais tak i!’ ura aung gä qoar toqortäqyia, ‘Ngäni lu i iak muk i!’ dä qale ngän natnanakt nä iangärhäkt ama enge. ");
INSERT INTO uro_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Inguna ama iraski na rha ama engesta dä ama iraski na rha ama vämginarha diva rha rhäranas bä va rhat täranas na ama muqunän dä ama nañis ngät ama lat i vadi vakt iva rhi irastäm sa ama ruvek kärarhani i sa ma Ngämuqa qa armeng däm da. ");
INSERT INTO uro_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mamär iva ngänät nañäm särhäm mes. Sa ngua qoar na ngän nä iarhongäkt moekt pä iomäkt ama qäväläm angät kamäs.” ");
INSERT INTO uro_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Bä va vät iangärhäkt ama qunäng nasot iaqäkt ama märänga “‘dä va bängangit mät ama qunäga aa saqong dä va ama equngi diva qaku qiat nañäm’ ");
INSERT INTO uro_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","‘dä va ama qaeng diva ngärhit säp nämät ama leqäs dä va iarhongäkt kärqärhongni i qali lirhong mät ama leqäs kärqärhongni i irhong angät krot diva sarhäktsarhäkt pät irhong.’” ");
INSERT INTO uro_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Mamär dä va ama ruvek ti lu ma Ruqa aa Emga i qat dän ba ama eqoe sa aa qrot ama mor ngät näkt ama murhämeska. ");
INSERT INTO uro_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Näkt pa qä rhäk na ama enselqäna bä va rhi västämne ama ruvek kärarhani i sa ma Ngämuqa qa armeng däm da nävät ama ivätki qi na ama usäpki in däkt moe.” ");
INSERT INTO uro_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mamär iva ngäni räm ama rhisu nävät ama rhaun gärangätni i nga vuk pät angät ngärhäqyitnäk dä sa ngänät dräm i ama qunängit nga e glaqot. ");
INSERT INTO uro_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Di rhoqorne rhoqoräkt i ngakt bä va ngänät lu rhärhong däkt i irhong ngät täranas dä va ngänät dräm i qa di sa qa e glaqot i sa qäqi qa e glaqot na ama tmongi. ");
INSERT INTO uro_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nguat tamän särhäm ngän na ama engäktki iva rhit täkt ama qoengait diva qaku rhäksot nä it bä dängdäng i rhärhong däkt di sa irhong ngä märanas. ");
INSERT INTO uro_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ama usäpki qi na ama ivätki diva qäbäs na em dap pa gua enge diva qaku qäbäs na ngät.” ");
INSERT INTO uro_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Qaku aung anga ruqa qat dräm iaqäkt ama qunäga ura iaqäkt ama qunäga aa qäväläm. Bä qäqi ama enselqäna rhävuk ti na ama Ngärhoemga di qaku rhat dräm dap sokt ama Ngätmamäk kat dräm. ");
INSERT INTO uro_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Bä va ama qarhap ngän bä ngänät nañäm inguna qaku ngänät dräm iva iomäkt ama qäväläm diva äm ngä rhän gäsnia. ");
INSERT INTO uro_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Rhoqoräkt di rhoqor akni ama ruqa qärakni iva qa rhet pät ama tmerhäs sa gläius. Bä nga qa met daqule aa vätka dä qa mu ama lat kärangätni i ñismäne da aa latta arha lang iva rhat tualat na ngät näkt ka muge akni ama latka mät ama edäbäs ivakt iva qat nañäm.” ");
INSERT INTO uro_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Dä soknga mamär iva ama qarhap ngän bä va ngänät nañäm inguna sa qaku ngänät dräm i agi a qäväläm dä va ama ngärhik nävä iaqäkt ama vätka diva evär däm ga. Nguaräm ba qa rhän säng ama bängagi arha ribit ura va mäni bängagi mamär ura va rhoqoräkt i ama durakt ngärhit nok ura va rhoqoräkt i sa ama qunäga qa qot pät duququs. ");
INSERT INTO uro_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Qale ngäni mänatäm i varis kä namän masärmän bät a ngän. ");
INSERT INTO uro_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Rhangät täkt ama enge qärangätni i nguat tamän särhäm ngän na ngät di nguat tamän särha ama ruvek moe rhoqortäqyia, ‘Mamär iva ngänät nañäm!’” ");
INSERT INTO uro_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sa sokt pät ama qunängiom ama udiom iva äkt dä sa ama Judaqäna arha tmäski iva rhat tuqunän bät ma Pasova dä ama tmäski na ama bretkäna qärangätni i qaku anga yis päm ngät bä ama priskäna ama moräs na rha näkt sävät ama Skraipkäna di rhit ñäm nani guani anga iraski nä ini säng ma Jisas aa rhäng iva up na rha i rhi sangar a qa vät ini bä va rhi veng ga. ");
INSERT INTO uro_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Dä sa rhi qoar toqortäqyia, “Va qaku ut nasangar a qa rhoqoräkt i ama tmäski i varis anga ulaqi qi namäranas mänguräp ama ruvek.” ");
INSERT INTO uro_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Dap toqoräkt i qale ma Jisas e ma Betani di qat täs nävät ama laiqa va akni ama ruqa ma Saimon aa vätka qärak i mäqi ama bias pät a qa dap aktni ama evopki qia män sa ama kainaqi qäraktni i sa rha mualat na qi na ama duiqa ama saksak päm ga qärakni i rhat tes ka i ama alabasta. Näkt täqäp ki na ama oel qäraktni i ama mär at tamaska qäraktni i ama ligär masirhat pät a qi. Iaqyäkt ama oel di sokt kiat dän näva ama ngämuga ma Nard aa snagut. Qa evopki qia män bä qia rhar mät iaqyäkt ama kainaqi näkt kia rhor na ama oel dä ma Jisas aa uväs. ");
INSERT INTO uro_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Dap arhani nävät iarhakt kärarhae i qale rha e di ama uraqi da arha ron nä qa evopki dä rhat tamän särhäm ne rhoqortäqyia, “Mäniekt bä sa iaqyäkt kia rhar sa ama oel ama mär at tamaska rhoqoräkt? ");
INSERT INTO uro_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Vadi mai rhi vodä iaqyäkt ama oel bä rha rhän bät anga dävaung anga handretkäna na anga qunäng angät titsek näkt ti von ama tläkta rhä iangärhäkt ama ligär.” Rhat tamän särhäm ne rhoqoräkt näkt tir qur qi masirhat na ama ingnania. ");
INSERT INTO uro_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Ngäni qyiradeng na qi. Mäniekt bä ngänit bon gi rha ama märänga? Nak sa qia mualat na ama lat ama mär ngät sä ngo. ");
INSERT INTO uro_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Qärarhani ama tläk ta diva vasägos dä va qale rha gem ngän bä mamär iva ngän datnärhäm da qre i nani a ngän. Dap aingo diva qaku qale ngo gem ngän basägos. ");
INSERT INTO uro_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Sa iaqyäkt di sa qia mualat nä ianiäkt kärqäni i mamär vät a qi iva qia rhualat nä ini. Sa qia vrit nä rhakt täkt ama oel vät gu släqyige vä gua tñäpki at kamäs ivakt iva qi rhäkmu na ngo iva nani iomäkt iva rhi sasärhäm ngo. ");
INSERT INTO uro_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Dä nguat tamän särhäm ngän na ama engäktki i qoe nai vät ama ivätki moe i ama sameng ama mär ngät di rhi sameng na ngät e dä va ama sameng sävät tangät täkt arha lat diva rhi sameng na ngät bä va ama ruvek ta tu arhä snäng sävät a qi.” ");
INSERT INTO uro_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nasot dä akni nävät ama ngärhäqyisem da udiom na rha ama mudäsaqongda qärak i rhat tes ka i ma Judas Iskariot ka met sage ama priskäna ama moräs na rha ivakt iva qä qoar na rha iva qä vodä ma Jisas bä ba rha. ");
INSERT INTO uro_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bä nga ama priskäna ama moräs na rha rha nari rhoqoräkt dä mär gem da dä rha rhares iva rhi von ga rha anga ligär. Dä soknga rhoqoräkt dä ma Judas Iskariot kät ñäm nani anga qäväläm anga mär äm ivakt iva qä vodä ma Jisas bä ba rha. ");
INSERT INTO uro_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Vät ama narhoer qa ama qunäga vät ama tmäski at kunäng gärangätni i ama Judaqäna rhat tuqunän i mudu arha morta di sa rhat täs ama bretkäna qärangätni i qaku anga yis päm ngät dap toqoräkt i rhit boda ama vodämes na ama sipsipkäna ama ngärhoes bä bä ma Pasova dä ma Jisas aa mudäsaqongda rhi snanbät sä qa rhoqortäqyia, “Urhi lu nani a nge na ut iva u rhet sa qoe bä va urhi rhäkmu bä ba nge iva ngia äs ma Pasova angärha tmäs e?” ");
INSERT INTO uro_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dä qa rhäk na aa mudäsaqongiom ama udiom sa ama rhodräp toqortäqyia, “In det bä in don sämät ama värhäm ama mor äm dä akni ama ruqa va qa rhän bät a en gärakni i qät ta ama kainaqi ama mor qi na ama rigi. Iaqäkt ama ruqa diva in det nasot a qa. ");
INSERT INTO uro_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Näkt pa ini qoar na ama ngärhik näva ama vätka qärakni i iaqäkt ama ruqa qat don säväm ga rhoqortäqyia, ‘Qamorqa qä snanbät toqortäqyia, ngu lu ama qäväläm bä ba ama tmända äm ngä qoe nai qärqomni i sa ngua nän dä bäm iva ngu nä gu mudäsaqongda u äs ma Pasova angärha tmäs e?’ ");
INSERT INTO uro_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Dä va qä qur a en da ama mor äm ama vätka aa qäväläm dävono ba aa vätka qärqomni i sa rha rhäkmu na äm na ama laiqa vä bäm iva nani ama tmäs. Dä va ini rhäkmu na aurha tmäs äkt pä iomäkt ama qäväläm.” ");
INSERT INTO uro_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Dä ma Jisas aa mudäsaqongiom in met bä in mon säva ama värhäm dä in män bät kärqärhongni i irhong doqor mai ma Jisas ka qoar na iom. Dä soknga in däkmu nä ma Pasova angärha tmäs. ");
INSERT INTO uro_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bä sa nga rhoqoräkt i bängangäs dä ma Jisas ka män gä na aa mudäsaqongda ama ngärhäqyisem da udiom na rha. ");
INSERT INTO uro_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bä nga rhoqoräkt i rhat täs nävät ama laiqa dä ma Jisas ka qoar na rha rhoqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i akni nävät a ngän diva qä vodäm ngo bä gua ikkäna. Iaqäkt di ngu na qa un däs.” ");
INSERT INTO uro_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ma Jisas ka märhamän doqoräkt dä rha nasäng i airäs ta dä asägäk asägäk kä qoar na qa rhoqortäqyia, “Nga aingo?” ");
INSERT INTO uro_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Iaqäkt di akni nävät a ngän ama ngärhäqyisem da udiom na ngän gärakni iva qä na ngo uni rhäk ama bret sämät ama dis. ");
INSERT INTO uro_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ma Ruqa aa Emga diva qä ñäp toqor varhäm ama enge qärangätni i mudu sa rha säm a ngät sävät a qa sokt diva avuqi mamär ge iaqäkt kärak iva qä vodä ma Ruqa aa Emga ba aa ikkäna. Nak padi mai qaku aa nanäk ki nasäl a qa di vadi mai ama märäm ba qa.” ");
INSERT INTO uro_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nga rhoqoräkt i rhat täs dä sa ma Jisas ka rha ama bret näkt ka mes ama mär näkt ka vonamät na qa näkt ka von aa mudäsaqongda i qat tamän doqortäqyia, “Ngän dät tangät täkt i ngät di gu släqyige.” ");
INSERT INTO uro_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Näkt kosaqi qa rha ama kap na ama wain bä nga nasot i qa mes ama mär dä qa von da bä rha moe rha nakt nämät ka. ");
INSERT INTO uro_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Näkt ka qoar na rha rhoqortäqyia, “Rhak täkt di gu biaska qärakni i qä sämaengäktki na ama rharesbane mänguräp ma Ngämuqa qä na ama ruvek di qärak i qrir na qa ba ama rhäqäp na rha ama ruvek. ");
INSERT INTO uro_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Dä nguat tamän särhäm ngän na ama engäktki iva saqi as kaku ngu nanakt nävät ama wain angät gavam bä dängdäng bät iaqäkt ama qunäga iva ngu näkt ama iaräs na qi ama wain bä ma Ngämuqa aa Muräktpäm.” ");
INSERT INTO uro_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bä nga rha rhong ama mabuqi na ama ansäs bä rhäksot dä rha met na äkt bä säda ama Damgi na ama Olip at täväs. ");
INSERT INTO uro_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Dä ma Jisas ka qoar na aa mudäsaqongda rhoqortäqyia, “Va ngän moe ngäni ang daqule ngo inguna mudu di sa rha säm sävät ma Ngämuqa rhoqortäqyia, “‘Va ngu veng ama ruqa qärakni i qät lu vät ama sipsipkäna bä va vräs na ama sipsipkäna.’ ");
INSERT INTO uro_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Näkt pa nga nasot i ma Ngämuqa qa rhäranas na ngo nämät ama tñäpki dä va ngu er va angän gamäs sae ma Galili.” ");
INSERT INTO uro_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Dä ma Pita qa qoar nä qa rhoqortäqyia, “Näma dä äkt bä rhärha rhäkt moe rhi ang daqule nge sokt di aingo diva qaku rhäm ngo.” ");
INSERT INTO uro_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Nguat tamän särhäm nge na ama engäktki iva näp takt täkt ama bängagi iva as kaku ama duraktka qä nanok maunmem dä va ngi rhäqyas na ngo madäpguamek.” ");
INSERT INTO uro_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma Jisas ka muvät toqoräkt dä qop tuk pät ma Pita i qat tuvät toqortäqyia, “Va qaku ngu narhäqyas na nge bä näma dä ngu ñäp ngu na nge.” Dä qosaqi arhani ama mudäsaqongda moe rha qoar toqoräkt. ");
INSERT INTO uro_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sa rha met säva ama ivärhäs kärqosni i rhat tes äs i ma Getsemani dä ma Jisas ka qoar na aa mudäsaqongda rhoqortäqyia, “Ngän duqun däkt dap pa ngua rhet sa rhämuk bä va ngu nän.” ");
INSERT INTO uro_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Dä qa rhäqoar sä ma Pita qä nä ma Jems näkt ma Jon bä rhi na qa rha met maqälak nage arhani aa mudäsaqongda. Rhoqoräkt di sa qa nasäng i qät ta ama märänga ama mor qa bä airäs ka. ");
INSERT INTO uro_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Dä qa qoar nä ma Pita qä nä ma Jems dä ma Jon doqortäqyia, “Ama iräski imuk dä gua ron di ama mor qi masirhat bä nguat nari iva ngu ñäp. Dap pa qale ngän däkt bä ngänät däqäm.” ");
INSERT INTO uro_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nasot dä qa met daqule rha maqälak na äkt bä arpus na qa samäk sävät ivät bä qä nän iva iomäkt ama qäväläm ngä rhet nävät a qa qrekt bä märmärsäs iva äm ngä rhet. ");
INSERT INTO uro_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Qa nän i qä qoar toqortäqyia, “Aba, mamga, iarhongäkt moe di märmärsäs sä irhong gem nge. Mamär iva ngi rha rhom däkt ama qäväläm na ama märänga nävät a ngo. Sokt diva qoki qaku varhäm gu snängaqa dap kinak pa varhäm gi snängaqa.” ");
INSERT INTO uro_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nasot dä evär däm ga sage aa mudäsaqongda dä qa män bät a rha i rhi mänatäm. Dä qa snanbät sä ma Pita rhoqortäqyia, “Saimon, nga ngi mänatäm? Nga qaku mamär vät a ngän iva ngänät däqäm gäqi vät anga aua anga sägäk? ");
INSERT INTO uro_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mamär iva ngänät däqäm dap ngäni nän sage ma Ngämuqa iva qale ngän namon sämät ama siqutsiqut. Ama qloqaqa di ngäñngäñ ga dap eqokt ama släqyige.” ");
INSERT INTO uro_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Dä saqi as ma Jisas ka met daqule rha bä qä nän doqor nas mai. ");
INSERT INTO uro_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Näkt saqi evär däm ga dä qa män bät a rha i rhi mänatäm inguna amärän ba arhä mänap mamär. Bä nävät iomäkt dä qaku rhat dräm iva rhi qoar na qa na agiqa. ");
INSERT INTO uro_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Dä saqi as nga evär däm ga sage ama mudäsaqongda iva madäpguamek dä qa snanbät sä rha rhoqortäqyia, “Qoki as nga ngäni mänatäm dä mämae vät a ngän? Sa sokt äkt! Sa ama qäväläm ngä män iva rhi vodä ma Ruqa aa Emga säva ama vu rha ama ruvek arhä rhäkt. ");
INSERT INTO uro_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ngän däranas bä ut tet. Ngäni lu i qärakni iva qä vodäm ngo di sa rhak.” ");
INSERT INTO uro_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Bä as nga rhoqoräkt i ma Jisas kat tamän dä väs dä ma Judas kärak i qa nävät ama mudäsaqongda ama ngärhäqyisem da udiom na rha qä na ama guläñgi na ama ruvek sa ama ulaqi arha sen ngä na ama edäm gärarhani i sa ama priskäna ama moräs na rha näkt sävät ama Skraipkäna rhi na ama morta rha rhäk na rha. ");
INSERT INTO uro_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Sa qärak iva qä vodä ma Jisas di sa qa er qa rhodäm ba rha na aa muqunängi rhoqortäqyia, “Qärakni iva ngu vop pa aa sdäm di iaqäkt. Ngäni sangar a qa bä va ngänit lu vät a qa rhoqoräkt i ngän det sä qa.” ");
INSERT INTO uro_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Bä nga ma Judas ka män dä qa rhäkdävär qa met bä sage ma Jisas näkt ka qoar na qa rhoqortäqyia, “Qamorqa!” Näkt ka vop pä ma Jisas aa sdäm. ");
INSERT INTO uro_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ma Judas ka mualat toqoräkt dä ama gamoe rha qärhäkt dä ma Jisas bä rha sangar a qa. ");
INSERT INTO uro_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Dä akni ama ruqa qärakni i qat mair ge ma Jisas di qa mar ta aa ulaqi arha singi bä qa rhon na qi sävät ama pris ama vit na qa aa latka bä qa rhodäkt sa aa sdämgi. ");
INSERT INTO uro_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Dä ma Jisas ka qoar toqortäqyia, “Nak nga ama suaqa na ngo bä äkt i sa ngän män sävät a ngo sa ama ulaqi arha sen dä ama edäm ivakt iva ngäni sangar a ngo? ");
INSERT INTO uro_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Vasägos dä qale ngo gem ngän bä ngu su ama ruvek pa ama ansäspämgi ama mor qi sokt di qop kaku ngän sangar a ngo. Sokt di qoki va rhäkmamär nä ma Ngämuqa aa enge nä rhangät täkt ama lat.” ");
INSERT INTO uro_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nga rhoqoräkt dä ama mudäsaqongda moe rha ang masirhat daqule ma Jisas. ");
INSERT INTO uro_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Dap akni ama evänga qärakni i mai qat tet nasot ma Jisas di sa sokt ka ong bät a nas na ama boiqi ama ingas ki mamär. Bä iarhakt ama ruvek di sa rha siqut iva rhi sangar a qa ");
INSERT INTO uro_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","sokt di iaqäkt ama evänga qa ang masirhat sä vlavel daqule iaqyäkt aa boiqi. ");
INSERT INTO uro_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Qärarhani qä gamoe rha ang sä ma Jisas bä sage ama pris ama vit na qa näkt ama priskäna ama moräs na rha rhi na ama morta näkt sävät ama Skraipkäna moe di västämne na rha. ");
INSERT INTO uro_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ma Pita di sa qät päsais tä ma Jisas bä savuk säva ama pris ama vit na qa aa vätki arha ivärhäm bä qat muqun ge ama ulaqimärharhärhäkt kärarhani i sa rhit lu vät ma Jisas bä qat narhäkt ama mudam. ");
INSERT INTO uro_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ama priskäna ama moräs na rha dä ma Sanedrin moe di rhit ñäm nani anga ruvek kärarhani iva rhi sameng irhä ma Jisas ivakt iva ama morta rhi veng ga. Sokt di qaku rha män bät anga enge sävät a qa rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Dä ama rhäqäp na rha di rhi sameng na ama irasirhong sävät a qa sokt di qop iarhongäkt arha engirhong di qaku irhong doqorne. ");
INSERT INTO uro_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Vät iomäkt ama qäväläm dä arhani rha mair bä rha voda rhangät täkt ama iraski na ngät ama enge sävät a qa i rhi qoar toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ut nari qa i qä qoar toqortäqyia, ‘Rhakt täkt ama ansäspämgi ama mor qi qäraktni i ama ruvek ta rhä qi diva ngu rhar qi moe näkt nasot ama dävaung ama qunäng dä va saqi ngu rhäk agukt käraktni i qaku anga ruqa qa rhäk pät a qi.’” ");
INSERT INTO uro_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Sokt di qop iangärhäkt arha enge asägäk asägäk di qosaqi qaku ngät toqorne. ");
INSERT INTO uro_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Dä ama pris ama vit na qa qa mair da arhä saqong näkt ka snanbät sä ma Jisas toqortäqyia, “Nga qaku gi nga muvätki iva ngia rhuvät? Ngi rhäväkt sä rhangät täkt ama ruvek arhä sameng sävät a nge.” ");
INSERT INTO uro_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sokt di qop kale ma Jisas i mänadin däm ga dap kaku qa muvät. Dä saqi as ama pris ama vit na qa qa snanbät sä qa rhoqortäqyia, “Nga ainge di iaqäkt kärak i aurha ansäs sagem ga aa emga na nge? Nga ainge di ma Krais?” ");
INSERT INTO uro_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Dä ma Jisas ka muvät toqortäqyia, “Aingo rhäkt. Bä va ngäni lu ma Ruqa aa Emga i qat muqun dä iaqäkt kärak i ama qrot moe angät tarebäm aa märmär bä va qat dän ba ama eqoe näda ama usäpki arha ron.” ");
INSERT INTO uro_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Bä nga ama pris ama vit na qa qa nari rhoqoräkt dä qa angyiret mät aa boi näkt ka snanbät toqortäqyia, “Saqi as pa nani a ut na agung anga enge säng aa rhäng doqor mäniekt? ");
INSERT INTO uro_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nak sa ngän nari aa märhamän mava sävät ma Ngämuqa. Angän matnävämne di rhoqor mäniekt?” Dä rha moe asägäk asägäk di rha qoar i qa di mamär iva rhi veng ga. ");
INSERT INTO uro_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nasot dä arhani rhi nasäng iva rhit kot pät a qa näkt ta qop mät aa saqong näkt ti arhäktgyäm sä qa na arhä rhäkt dap tat tamän sävät a qa rhoqortäqyia, “Ngiat tuqunäga sä ut!” Näkt ama ulaqimärharhärhäkt ta rha qa bä rhi arhäktgyäm sä qa. ");
INSERT INTO uro_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Rhoqoräkt i qale ma Pita inamäk dalek dä aktni ama latki nävät ama pris ama vit na qa aa latta qiat tet e. ");
INSERT INTO uro_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Bä nga vät ama qäväläm gärqomni i qia lu ma Pita i qat narhäkt dä qia ñäm sävät a qa. Dä qi qoar na qa rhoqortäqyia, “Qosaqi nge di ma qale nge ngi nä ma Jisas nae ma Nasaret.” ");
INSERT INTO uro_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Dä ma Pita qa rhäqyas i qa qoar toqortäqyia, “Nak kaku nguat dräm i agiqa iaqäkt kärakni i ngiat tamän bät a qa.” Ma Pita qa muvät toqoräkt näkt puk sä qa nävät iaqäkt ama vätka aa ivärhäm maqälak dä ama duraktka qa nok. ");
INSERT INTO uro_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Näkt nga qa latki qia lu qa äkt dä saqi as kia qoar nä iarhakt kärarhae i rhat mair glaqot toqortäqyia, “Rhak täkt ama ruqa di akni iaqäkt nävät a rha.” ");
INSERT INTO uro_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Dä saqi as ma Pita qa rhäqyas. Näkt nga nasot ama qäväläm ama qot äm dä iarhakt kärarhae i rhat mair glaqot ti qoar nä ma Pita rhoqortäqyia, “Ari, ainge di ak na nge nävät a rha inguna nge di ama Galiliqa na nge.” ");
INSERT INTO uro_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dä ma Pita qa nasäng i qat tamän i näma dä äkt bä ma Ngämuqa qä sangäm na qa qrekt bä qa iras dap kat tu sävät aa enge angärha rhäng i qat tu dä qat tamän doqortäqyia, “Aingo di qaku nguat dräm dak täkt ama ruqa qärakni i ngän damän sävät a qa.” ");
INSERT INTO uro_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Vät iomäkt ama qäväläm maräkt dä ama duraktka qa nok iva maunmem. Dä vuk pät ma Pita na ama enge qärangätni i sa ma Jisas ka märhamän särhäm ga na ngät i qa qoar toqortäqyia, “Va ngi rhäqyas na ngo madäpguamek näkt nasot dä va ama duraktka qä nok maunmem.” Dä ma Pita qa mu aa snäng samäk sävät iangärhäkt ama enge dä däng na ama släpki vät aa qän bä qät nok. ");
INSERT INTO uro_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Qoki as toqoräkt i vät duququs mamär dä ama priskäna ama moräs na rha rhi na ama morta näkt sävät ama Skraipkäna näkt ma Sanedrin moe rha män bät ama snängaqa iva rha rhualat sä ma Jisas toqoräkt. Dä rha qop mät aa rhäkt näkt ta met sä qa bä rha vodäm ga bä ma Pailat. ");
INSERT INTO uro_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Dä ma Pailat kä snanbät sä qa rhoqortäqyia, “Nga ainge di ama Judaqäna arha vitnaqa na nge?” Dä ma Jisas ka muvät toqortäqyia, “Sa ngia märhamän doqoräkt.” ");
INSERT INTO uro_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Dä ama priskäna ama moräs na rha rhit täksärhäm ga na ama rhäqäp nä irhong. ");
INSERT INTO uro_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Dä ma Pailat kä qoar nä ma Jisas toqortäqyia, “Ngi lu i qoki as ama mämänia nä irhong iarhongäkt kärqärhongni i rhit täksärhäm nge nä irhong.” Dä saqi as ka snanbät sä qa rhoqortäqyia, “Nga qaku mamär iva ngi namuvät?” ");
INSERT INTO uro_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Sokt di qop kaku ma Jisas ka muvät saqi as na agung anga enge bä ma Pailat di qräk mät ka rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Vät ama qoeo nasot a ne vät ma Pasova angät kunäng dä ama tpäskinaqa qat dräm gat tuisiska vät ama ruqa ama sägäk näva ama tpäskiarharhäng gärakni i ama ruvek ti nän däm ga. ");
INSERT INTO uro_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Rhoqoräkt di akni ama ruqa qärak i rhat tes ka i ma Barabas di qale qa va ama tpäskiarharhäng gä na aa ruavek kärarhani i sa qale rha da ama inirqi arha ron gäraktni i sa qia märanas sävät ama Romgäna bä ma Barabas di sa qa veng ama ruqa rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dä ama guläñgi ama mor qi na ama ruvek ta män sage ma Pailat bä rhi nän ga iva qa rhuisiska vät anga ruqa näva ama tpäskiarharhäng bä ba rha rhoqor vasägos i qat tualat. ");
INSERT INTO uro_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Dä ma Pailat ka snanbät sä rha rhoqortäqyia, “Nga nani a ngän iva ngua rhuisiska vät ama Judaqäna arha vitnaqa bä ba ngän?” ");
INSERT INTO uro_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ma Pailat ka snanbät sa ama guläñgi rhoqoräkt inguna sa qat dräm i ama priskäna ama moräs na rha di sa rha vodä ma Jisas ba qa inguna nävät arhä snängaqa ama vu qa inguna ma Jisas di qa vit da ama ruvek arhä saqong. ");
INSERT INTO uro_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sokt di qop ama priskäna ama moräs na rha di rhat tuqärnas ta ama guläñgi iva sävät ma Pailat iva qinak ka rhuisiska vät ma Barabas. ");
INSERT INTO uro_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Dä ma Pailat ka snanbät sä rha rhoqortäqyia, “Ngu lu va ngua mäsana nä qa ruqa qärak i ngän des ka i ama Judaqäna arha vitnaqa?” ");
INSERT INTO uro_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Dä saqi as ta näs toqortäqyia, “Ngi edämsäs pät a qa mäni ama sämänanamuqa!” ");
INSERT INTO uro_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Dä ma Pailat ka snanbät toqortäqyia, “Va vät agiqa? Sa qa mualat na agi a lat anga vu ngät?” Sokt di qop tit näs tävuk masirhat toqortäqyia, “Ngi edämsäs pät a qa mäni ama sämänanamuqa!” ");
INSERT INTO uro_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Dä ma Pailat ka muisiska vät ma Barabas sage ama guläñgi inguna nani a qa iva mär gem da. Näkt ka rhäkne bä rha märanäs ma Jisas näkt ka vodäm ga ivakt iva rhi edämsäs pät a qa mäni ama sämänanamuqa. ");
INSERT INTO uro_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sa ama ulaqimärharhärhäkt ta met sä ma Jisas na äkt bä savuk säva ama tpäskinaqa aa vätki arha ivärhäs kärqos i rhat tes äs i ma Pretoriam. Näkt ta mes ama ulaqimärharhärhäkt moe sävät a ne. ");
INSERT INTO uro_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Näkt ta vlukt sa aa boi nävät a qa näkt ta rhon na ama pärpel qi ama boiqi vät a qa näkt kosaqi rha ing ama guaqi na ama ngämuga aa rhäqyitnäk ama gärgär vät itnäk iva rhoqor ama vitnaqa aa qäbautki. Näkt ta mu iaqyäkt ama gärgär vät a qi ama guaqi mäni aa uväski. ");
INSERT INTO uro_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Näkt ta nasäng i rhit näs sagem ga rhoqortäqyia, “Ainge ama Judaqäna arha vitnaqa, di mamär iva qale nge mauiu.” ");
INSERT INTO uro_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Dap ama dämne i rhi nän aa uväski na ama iroqi dä rhit kot pät a qa. Dä qosaqi rhi nän da arhä quum sä nas gem ga iva rhit kutdrir sagem ga. ");
INSERT INTO uro_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bä sa nga rha muma qa bä rhäksot dä rha vlukt sa ama boiqi ama uiu qi nävät a qa näkt ta monmät pät a qa na aa boi maräkt. Nasot toqoräkt i rha monmät pät a qa dä rha met sä qa sä dalek iva rhi edämsäs pät a qa mäni ama sämänanamuqa. ");
INSERT INTO uro_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Akni ama ruqa näva ama värhäm ama mor äm ma Sairini qärak i rhat tes ka i ma Saimon ma Aleksander qä nä ma Rufus in mam di qat tet e nä qä ulaqimärharhärhäkt kärarhani i rhat tet sä ma Jisas. Iaqäkt ma Saimon di qat dän nävät ama värhäm ama mor äm angä rhäkt. Ma Saimon gat tet na rha dä rha qrotpät sä qa iva qät ta ama sämänanamuqa. ");
INSERT INTO uro_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Sa rhat tet bä rha män sä ma Jisas pät ama ivärhäs kärqos i rhat tes äs i ma Golgota qärqos i äs angät tarimini di ama ivärhäs na ama rhomga aa uväski. ");
INSERT INTO uro_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Dä arhani ama ruvek ta von ga rha ama wain gäraktni i sa rha modämne na qi na aktni ama rigi qäraktni i qiat dräm gi veng ama ruanirhong gäraktni i rhat tes ki i ama mir sokt di qop kaku qä nanakt. ");
INSERT INTO uro_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Dä ama ulaqimärharhärhäkt ta edämsäs pät a qa mäni ama sämänanamuqa näkt ta matmät na aa boi ba ne na ama serhäm gärangätni i serhäm da nani a ngät. ");
INSERT INTO uro_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Rhoqoräkt di sa ama ngärhäqyet da levaet nä irhong bät duququs i sa rha edämsäs pät a qa mäni ama sämänanamuqa. ");
INSERT INTO uro_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Näkt ta säm ama enge qärangätni i sa rha sangar a qa vät angät tpäs kärangätni i ngät tamän doqortäqyia, “Ama Judaqäna arha vitnaqa.” ");
INSERT INTO uro_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Dä qosaqi rha edämsäs pät aiomni ama ruiom ama sua iom gem ga i akni di sa rha mu qa dä ma Jisas aa märmär dap akni da aa sael. ");
INSERT INTO uro_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bä ama ruvek kärarhani i rhat tet e na qa di rhat tuma qa masirhat dap ti em arhä väs dap tat tamän doqortäqyia, “Ainge qärak iva ngi rhar ama ansäspämgi ama mor qi näkt saqi as pa ngi rhä qi da ama qunäng ama dävaung angärha ron ");
INSERT INTO uro_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","di ngi sär sä nas navuk nämäni ama sämänanamuqa bä ngia rhumaiar nas!” ");
INSERT INTO uro_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Dä qosaqi ama priskäna ama moräs na rha näkt sävät ama Skraipkäna di rhat tuma qa ba ne i rhat tamän doqortäqyia, “Sa qat tumaiar arhani sokt di qaku mamär iva qä namumaiar nas! ");
INSERT INTO uro_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mamär iva ma Krais ama Judaqäna arha vitnaqa qä sär sä nas navuk nämäni ama sämänanamuqa ivakt iva urhi lu dä u rhat maengäkt.” Dä qosaqi iarhakt kärarhae i rha edämsäs pät a qa mäni ama sämänanamuqa di sa rha slava na qa na ama enge ama vu ngät masirhat. ");
INSERT INTO uro_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Bä sa nga rhoqoräkt i mäniqunäng mamär dä ama bängangit ngä män bät ama ivätki moe bä qale rhoqoräkt bä dängdäng bät ama däpguarhong säpbängang. ");
INSERT INTO uro_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Bä nga rhoqoräkt i däpguarhong säpbängang dä ma Jisas ka nok masirhat toqortäqyia, “Eloi, Eloi, lema sabaktani?” Iomäkt ama qäväläm di äm ngät tamän doqortäqyia, “Gu Ngämuqa, gu Ngämuqa, mäniekt bä sa ngia qyiradeng na ngo?” ");
INSERT INTO uro_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bä nga arhani nävät iarhakt kärarhae i rhat mair e glaqot ta nari rhoqoräkt dä rhi qoar toqortäqyia, “Ngäni nari, qat tes ma Elaija.” ");
INSERT INTO uro_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dä akni qa ang masirhat bä qa ok ama bauläm ba ama wain ama valak mät ki at täväs näkt ka mu äm da ama ngämunget angät tpäs näkt ka rhäqyet sä äm bä ma Jisas iva qä nakt näkt iaqäkt ama ruqa qa qoar toqortäqyia, “As kale qa äkt dap ut luvät ivar ma Elaija qa rhän ivakt iva qä rha qa naivuk äkt.” ");
INSERT INTO uro_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Vät iomäkt ama qäväläm dä ma Jisas ka näs masirhat näkt sa qa ñäp. ");
INSERT INTO uro_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Dä ama boiqi ama mor qi qäraktni i qiat nar va ama ansäspämgi ama mor qi di qyiret mät ki nädä at täväs bä samäk bä ama qävälam ama unbam. ");
INSERT INTO uro_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Bä nga vät ama qäväläm gärqomni i ama narhoerqa bä ba ama handret na rha ama ulaqimärharhärhäkt kat mair e i qat lu ma Jisas dä qa nari vät ma Jisas aa qän dä qa lu iaqyäkt aa tñäpki dä qa qoar toqortäqyia, “Qoki ngäktki i rhak täkt ama ruqa di ma Ngämuqa aa emga!” ");
INSERT INTO uro_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Dap toqoräkt di qosaqi arhani ama evop di as tat mair tämuk gläius bä rhat lu rhoqoräkt. Mänguräp mä rha di qale ma Maria nae näva ama värhäm ama gaini na äm ma Makdala näkt ma Jems kä na aa matka ma Joses in nan ma Maria näkt ma Salome. ");
INSERT INTO uro_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Iarhakt di rhi nä ma Jisas ta met namet ma Galili bä rhat tatnärhäm ga. Dä qosaqi arhani ama evop ama rhäqäp na rha qärarhani i sa rha met ti na qa bä sae ma Jerusalem di qosaqi qale rha e. ");
INSERT INTO uro_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Rhoqoräkt di ama qunäga iva rhit täkmu nä iarhongäkt moe inguna nasot dä va ama Sabat bä sa nga rhoqoräkt di sa qorhäs iva ama bängangäs ");
INSERT INTO uro_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","dä ma Josep nämät ama värhäm ma Arimatea qärakni i qa di ama moräsnaqa näp ma Sanedrin näkt kosaqi qa di qale qa nani ma Ngämuqa aa Muräktpäm ga met na ama qraräk bä sage ma Pailat bä qa nän ga rhä ma Jisas aa släqyige. ");
INSERT INTO uro_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bä ma Pailat ka särmändäm doqoräkt i nak sa ma Jisas ka ñäp. Dä qa rhäkne nani qä ulaqimärharhärhäkt arhä narhoerqa bä qa snanbät sä qa i sa nga ma Jisas ka ñäp. ");
INSERT INTO uro_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bä nga qa räm nagem ga i sa ma Jisas ka ñäp dä qa rhares pät ma Jisas aa släqyige angärha rhäng bä ma Josep. ");
INSERT INTO uro_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Dä ma Josep ka vodäm bät ama uiu qi ama boiqi ama ingas ki näkt ka vlukt sä ma Jisas aa släqyige nämäni ama sämänanamuqa bä qa ong bät ige nä iaqyäkt ama boiqi näkt ka mu ige mät ama ñäpka aa liqi qäraktni i sa rha rhap ma qi mäni ama qäsävit. Näkt ka egaeng ama dulige bä qa väsdät nä ige mät ka liqi. ");
INSERT INTO uro_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ma Maria nae ma Makdala qi nä ma Maria ma Joses aa nan di in lu äkt i sa rha mu ma Jisas aa släqyige e. ");
INSERT INTO uro_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bä nga nasot ama Sabat dä ma Maria nae ma Makdala qi nä ma Maria ma Jems aa nan näkt ma Salome rha vodäm bät arhongni i ama mär irhong angät tamaska ivakt iva rha rhu irhong bät ma Jisas aa släqyige. ");
INSERT INTO uro_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dä sa nga vät ama narhoerqa ama qunäga säng ama tadenas toqoräkt i sa ama qunäga qa qot pät duququs mamär dä sa rha met sämät ama liqi qäraktni i sa rha mu ma Jisas aa släqyige e. ");
INSERT INTO uro_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bä sa nga rhoqoräkt i rhat tet dä rhi snanbät sä ne rhoqortäqyia, “Urhi lu va auge qä egaeng ama dulige näda ama liqi arha väm?” ");
INSERT INTO uro_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bä nga rhoqoräkt i sa rha män dä rha ñäm sae dä rha lu i qärqige qä dulige ama sru ige di sa aung ga egaeng ige nae. ");
INSERT INTO uro_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Dä sa nga rhoqoräkt i rhat don sämät ka ñäpka aa liqi dä rha lu ama gamoeqa ama evänga qärakni i qa murhämes na ama boiqi ama qulum gi dap kat muqun e da arhä märmär dä qräk mät ta. ");
INSERT INTO uro_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Dä qa evänga qa qoar toqortäqyia, “Qale qräqräk mät ngän. Sa nguat dräm i ngänit ñäm nani ma Jisas nae ma Nasaret kärak i sa rha edämsäs pät a qa. Iaqäkt di sa qa märanas! Bä sa qaku a qa rhe. As ngäni lu nasot a qa i rha mas na aa släqyige rhe i. ");
INSERT INTO uro_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Dap ngän det bä ngäni qoar na aa mudäsaqongda näkt ma Pita rhoqortäqyia, ‘Ma Jisas ka qoar iva ngän det sae ma Galili. Bä va ngän dän bät a qa e rhoqor mäqi qre qa qoar na ngän.’” ");
INSERT INTO uro_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nga qärak ka qoar na rha rhoqoräkt dä rha ang masirhat navuk nämät ka liqi i qräk mät ta mamär dä rhit len bä värvar vät a rha. Bä nga rhoqoräkt i rhi ngang dä qaku rha sameng ba aung inguna rhit len. ");
INSERT INTO uro_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Bä sa nga rhoqoräkt i ma Jisas ka märanas nämät ama tñäpki näva ama up mamär vät ama qunäga ama narhoer qa vät iosäkt ama tadenas dä qa er qa män ge ma Maria nae ma Makdala qäraktni i mudu qa qutmäs ama ngärhäqyet da udiom ama iaus nämät ki. ");
INSERT INTO uro_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Dä qia met bä qia sameng ba aa ruavek kärarhani i sa mudu qale rha rhi na qa rhoqoräkt i rhit nok mät ama iräski. ");
INSERT INTO uro_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bä nga rha nari i ma Jisas di ama iar qa bä qosaqi ma Maria nae ma Makdala di sa qia lu qa dä qaku rhat nanakt na arha enge. ");
INSERT INTO uro_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mamär dä ma Jisas ka män ge aa mudäsaqongiom ama udiom i qat nañäm maos toqoräkt i in det pät ama värhäm ama mor äm angä rhäkt. ");
INSERT INTO uro_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Dä qosaqi in män sage arhani ama mudäsaqongda moe bä in sameng ba rha sokt di qosaqi qaku rhat nanakt na ina enge. ");
INSERT INTO uro_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Näkt sa nga nasot dä ma Jisas ka män ge aa mudäsaqongda ama ngärhäqyisem da sägäk na rha rhoqoräkt i rhat täs näkt ka von da rha ama enge ama qrot ngät sävät iomäkt i qaku rhat nanakt dä sävät arhä väs kärangätni i ama qrot ngät dä iomäkt i qaku rhat nanakt nä iarhakt kärarhae i sa rha lu qa nasot iomäkt i qa märanas. ");
INSERT INTO uro_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Näkt sa qa qoar na rha rhoqortäqyia, “Ngän det pät ama ivätki moe bä va ngäni sameng na ama sameng ama mär ngät ba ama ruvek moe. ");
INSERT INTO uro_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Bä nga iaqäkt kärak i qat nanakt bä qa rha ama baptais diva ama iar qa dap kärakni i qaku qat nanakt di sa qa slava dä va ma Ngämuqa qä rhäksärhäm ga dä va qä sangäm na qa. ");
INSERT INTO uro_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Näkt pa rhangät täkt ama muqunän diva nga e vät iarhakt kärarhae i rhat nanakt iva nävät gu qrot dä va rhit kutmäs ama iaus dä va rhat tamän na ama iaräs na ngät ama enge. ");
INSERT INTO uro_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bä nga rhit sangar ama uiuvärhirhong gärqärhongni i irhong ngärhi veng na arhä rhäkt ura ngakt bä rhit näkt anga reng ama qänong bäm ngät dä qaku mamär iva iarhongäkt ngä naslava na rha. Dap pa rhat tu arhä rhäkt pät ama rämgivärharha bä va märäsmäräs pät a rha.” ");
INSERT INTO uro_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Sa nga nasot i ma Engeska ma Jisas ka märhamän särha aa mudäsaqongda rhoqoräkt dä ma Ngämuqa qa rha qa rhävit säva ama usäpki bä qa muqun dä ma Ngämuqa aa märmär. ");
INSERT INTO uro_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nga ma Jisas ka met daqule rha dä rha met pät ama ivätki moe bä rhi sameng. Dä ma Ngämuqa qat tualat kä na rha bä qät tarespäm na arha enge na ama muqunän gärangätni i ngät dän. ");
INSERT INTO uro_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ama rhäqäp na rha ama ruvek sa rha siqut i rha säm bä rha adämne na ama sek sävät ma Jisas aa lat kärangätni i mudu ngä märanas mänguräp mä ut. ");
INSERT INTO uro_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Sa rha säm mamär varhäm ama enge qärangätni i ama latta sä ma Ngämuqa aa enge sa rha von ut täm ngät. Dä iarhakt kärarhae i qale rha vät ama rharimini bä dängdäng däkt di rha lu iarhongäkt moe qärqärhong i irhong ngä mu angät släqyige vät a nas. ");
INSERT INTO uro_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Dap aingo di ngua ñäm mamär bä ngua räm mamär nä ma Jisas aa lat moe dä soknga nani a ngo iva ngu säm anga enge maräkt ba nge, qamorqa ma Tiofilus. ");
INSERT INTO uro_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Rhoqoräkt divakt iva ngiat dräm i iarhongäkt kärqärhong i sa rha su nge nä irhong sävät ma Jisas di ama engäktki nä irhong. ");
INSERT INTO uro_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Vät iangärhäkt ama rhodäm i ma Herot di ama vitnaqa e vät ama ngärhäktka ma Judia dä qale ama pris kärak i rhat tes ka i ma Sekaraia. Näkt ka nämäni ma Abiya aa priskäna. Dä aa egutki ma Elisabet di qosaqi qi nämäni ama enevaqi i ma Aron. ");
INSERT INTO uro_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ma Sekaraia qä nä ma Elisabet di ama räkt iom dä ma Ngämuqa aa saqong dä inät dräm init päs ma Ngämuqa aa Muräkt dä aa enge angärha rhäng mamär. ");
INSERT INTO uro_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Qaku ina anga es inguna ma Elisabet di ama rhängaräs ki bä rhäkt di ama sru iom. ");
INSERT INTO uro_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Vät akni ama qunäga dä ma Sekaraia qat tualat sage ma Ngämuqa va ama ansäspämgi ama mor qi inguna rhoqoräkt di aa qärhae ama priskäna arhä qäväläm iva rhat tualat. ");
INSERT INTO uro_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Rhoqor varhäm arhä qärhong ama priskäna dä sa rha armeng däm ga iva qa rhon säva ama ansäspämgi ama mor qi ivakt iva qä väs ama insens. ");
INSERT INTO uro_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Bä nga ngät dang dap ama guläñgi na ama ruvek di qale rha inamäk dalek bä rhi nän sage ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ma Sekaraia qale qa vuk dä väs da ama ensel nage ma Ngämuqa bä qat mair säda aa märmär na ama vodämes na ama insens angät laiqa. ");
INSERT INTO uro_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Bä ma Sekaraia qa särmän sävät a qa bä rhäqäp ka na ama tlenga mamär. ");
INSERT INTO uro_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Sokt di ama ensel qa qoar na qa rhoqortäqyia, “Sekaraia, qale ngit len! Sa ma Ngämuqa qa nari gia nän bä va gia egutki ma Elisabet diva qi sa ama rhoemga bä va ngia rhes ka i ma Jon. ");
INSERT INTO uro_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Bä va märmär gem nge bä va ngi qok masirhat bä anga rhäqäp na rha diva rhi qok ti na nge rhoqoräkt i qi sa qa ");
INSERT INTO uro_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","inguna qa diva ama moräs na qa dä ma Ngämuqa aa saqong. Bä va qaku qä natnakt ama wain bä ama qrot ki ama rigi näkt ka diva rhäqäp ka na ama Qloqaqa ama Qumärqumärqa nak koki as toqoräkt i qaku rha sa qa. ");
INSERT INTO uro_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","“Bä va qa evär da ama rhäqäp na rha ama Israelqäna sage ma Engeska arhä Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Bä va qa er qa rhet pä ma Engeska aa qamäs sa ama Qloqaqa ama Qumärqumärqa aa qrot toqor ma Elaija bä va qä evär da ama ngätmamäkkäna arhä mungäsnäng sävät arhä rhoes dä qosaqi ama tmervämda diva rhat tet nasot ama mädräm ama mär ngät nage ama räktta. Iva qä rhäkmu vät ama ruvek iva rhit täkmu na nas nani ma Engeska.” ");
INSERT INTO uro_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Dä ma Sekaraia qä snanbät sa ama ensel toqortäqyia, “Va nguat dräm doqor mäniekt i ngäktki nä rhangät täkt ama enge? Inguna aingo di ama sruqa na ngo dä gua egutki di sa qia met e na at koeo.” ");
INSERT INTO uro_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Dä ama ensel qä qoar toqortäqyia, “Aingo di ma Gebriel. Bä aingo di qale ngo ge ma Ngämuqa rhävuk. Näkt sa ma Ngämuqa qa rhäk na ngo sagem nge ivakt iva ngua rhamän särhäm nge i ngu qoar na nge nä rhangät täkt ama sameng ama mär ngät. ");
INSERT INTO uro_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","As ngi nari, va rhäksot nä gia enge bä va qaku ngi natmärhamän bä dängdäng i gua enge ngä rhu angät släqyige vät a nas inguna qaku ngia mat maengäkt sä gua enge. Rhärhong däkt moe diva irhong ngä rhu angät släqyige vät a nas pät ama rhodäm gärangätni i sa ma Ngämuqa qa muqunän bät a ngät.” ");
INSERT INTO uro_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Vät iomäkt ama qäväläm di qale ama ruvek dap tat tu arhä snäng i mäniekt bä qale qa mauiu va ama ansäspämgi ama mor qi. ");
INSERT INTO uro_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bä nak as nga vuk sä qa dä sa qaku mamär iva qat tamän sävät a rha. Dä rha räm nagem ga i rhoqoräkt di qa lu anga ñämñämgi va ama ansäspämgi ama mor qi inguna sokt kä siqutmät dap kaku qat tamän. ");
INSERT INTO uro_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Bä nga rhäksot na ama qunäng gärangätni i rha mu ngät bä ba qa iva qat tualat pa ama ansäspämgi ama mor qi dä evär däm ga säva vät. ");
INSERT INTO uro_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Näkt nga nasot dä aa egutki ma Elisabet at sarebäm näkt kali qi i qep särhäm gi va vät pät ama eqoan ama ngärhäqyet. ");
INSERT INTO uro_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Dä qi qoar toqortäqyia, “Nak as ma Ngämuqa qa mualat toqor täkt ba ngo i qat tu aa snäng sä ngo dä qa rhäksot nä gu qluqi nävät a ngo näda ama ruvek arhä saqong.” ");
INSERT INTO uro_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Sa nga ma Elisabet di at ngärhäqyet da sägäkt ama eqoan dä ma Ngämuqa qa rhäk na ama ensel ma Gebriel sämät ama värhäm ama gaini na äm bät ama ngärhäktka ma Galili qärqomni i rhat tes äm i ma Nasaret ");
INSERT INTO uro_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","bä sage ama säski qäraktni i mänaris na qi sävät akni ama gamoeqa qärak i rhat tes ka i ma Josep kärak i ama enevaqi sä qa nävät ma Devit. Näkt iaqyäkt ama säski di rhat tes ki i ma Maria. ");
INSERT INTO uro_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Bä ama ensel qa män gem gi dä qä qoar na qi rhoqortäqyia, “Ama mär sagem nge inguna ma Ngämuqa qat tu aa snäng sävät a nge masirhat. Bä ma Ngämuqa di qale qa gem nge.” ");
INSERT INTO uro_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ma Maria di rhäqäptäqäp ki masirhat nävät kärak aa enge dä qiat tu at snäng i agi enge na ama arsäs tangät täkt. ");
INSERT INTO uro_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Dä ama ensel qä qoar na qi rhoqortäqyia, “Maria, qale ngit len. Ainge di ma Ngämuqa qat tu aa snäng sävät a nge. ");
INSERT INTO uro_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Näkt as ngi nari, va gi nga sarebäm bä va ngi sa anga rhoemga bä va ngia rhes ka i ma Jisas. ");
INSERT INTO uro_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Bä va qa diva ama moräs na qa mamär bä va qa diva rhat tes ka i ma Moräsnaqa Na Rhävuk aa emga. Bä ma Engeska ma Ngämuqa diva qä von ga rha ama vitnaqa aa mämugunäs nasot mudu aa mamäk ma Devit. ");
INSERT INTO uro_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Bä va qa diva ama vitnaqa na qa vasägos bä ma Jekop aa enevaqi bä va aa muräkt diva qaku rhäksot na ngät.” ");
INSERT INTO uro_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Dä ma Maria qia snanbät sa ama ensel toqortäqyia, “Va sirhäkt toqor mäniekt inguna as kaku ngua mas ngu na anga gamoeqa?” ");
INSERT INTO uro_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Dä ama ensel qa muvät pät a qi rhoqortäqyia, “Ama Qloqaqa ama Qumärqumärqa va qä rhän gem nge bä va ama qrot nage ma Moräsnaqa Na Rhävuk pa ngärhi ong nge dä soknga ama rhoemga qärakni iva ngi sa qa diva rhi qoar i ama qumärqumär qa mamär bä va rhat tes ka i ma Ngämuqa aa emga. ");
INSERT INTO uro_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","As ngi nari, nak ma Elisabet käraktni i sägärhae na nge sävät a qi qärakt i rhi qoar i ama rhängaräs ki dä ama sruqi na qi sokt di at sarebäm na ama gamoeqa bä rhäkt di at ngärhäqyet da sägäkt na arha eqoan. ");
INSERT INTO uro_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Inguna qaku aqrot guani ge ma Ngämuqa.” ");
INSERT INTO uro_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Dä ma Maria qia muvät toqortäqyia, “Ari, aingo di ama latki qäraktni i qale ngo vä ma Ngämuqa aa rem. Vadi va rhäkmamär tä gia enge.” Dä ama ensel qa met daqule qi. ");
INSERT INTO uro_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Näkt nga nasot toqoräkt dä ma Maria qia rhäkmu na nas näkt kia ang sämät ama värhäm bät ama ivärhäs ma Judia. Iomäkt ama värhäm di sa qale läm mäni ama dabap ama lel ap. ");
INSERT INTO uro_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Bä qia mon säp ma Sekaraia aa vätka bä qia mes ama mär sage ma Elisabet. ");
INSERT INTO uro_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Bä nga ma Elisabet kia nari arha enge dä ama rhoemga da arha ron ga iaur bä ma Elisabet di rhäqäp ki na ama Qloqaqa ama Qumärqumärqa. ");
INSERT INTO uro_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Dä qia märhamän dävuk toqortäqyia, “Ma Ngämuqa aa märmärgem ba nge nä mänguräp ama evop moe bä qosaqi ba ama rhoemga qärakni iva ngi sa qa. ");
INSERT INTO uro_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Näkt mäniekt bä va ma Ngämuqa qat tu aa snäng sävät a ngo bä gua Engeska aa nanäk kia rhän gem ngo. ");
INSERT INTO uro_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Bä nga rhoqor täkt i ngua nari gia enge dä ama rhoemga dä gua ron ga iaur nävät ama märmärgem. ");
INSERT INTO uro_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Va ama märmärgem sagem nge, qärakt i qia mat maengäkt sa ama enge nage ma Ngämuqa iva ngä rhu angät släqyige vät a nas.” ");
INSERT INTO uro_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dä ma Maria qia qoar toqortäqyia, “Ngut sek sä ma Engeska ma Ngämuqa mät gu snängaqa ");
INSERT INTO uro_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","bä märmär gem ngo masirhat nävät ma Ngämuqa gu Mumaiar ");
INSERT INTO uro_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","inguna qa mu aa snäng sävät a ngo aingo aa latki qäraktni i ama sämagaininanas nga e gem ngo. Bä va mänasäng narhäkt bä rhävit di ama qoengitnäk moe na ama ruvek diva rhi qoar i ma Ngämuqa aa märmärgem nga e vät a ngo. ");
INSERT INTO uro_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Inguna iaqäkt kärak i aa qrot ngä vit di sa qa mualat na ama enges ngät ama lat ba ngo bä aa ngärhipki di ama qumärqumär qi mamär. ");
INSERT INTO uro_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Bä aa lavuqi di qi sävät iarhakt kärarhae i rhit kutdrir sävät a qa nävät ama qoengitnäk nasot a ne. ");
INSERT INTO uro_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Qa mualat na ama qrot ngät ama lat na aa qrot bä qa vräsmät na ama ruvek kärarhani i rhäqäp ta mamär na ama mairnanas. ");
INSERT INTO uro_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Qa anbut sa ama tpäskinarha nämät arhä mämugunimek dap ka sek sa ama ruvek kärarhani i ama sämagaininanas nga e gem da. ");
INSERT INTO uro_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Qa von iarhakt kärarhae i anoeng mä rha rha ama märirhong bä mamär na rha dap ka rhäk na ama qärhongbärharha i rhi säs. ");
INSERT INTO uro_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Qa matnärha aa latta ama Israelqäna qärarhani i qale rha va aa rem i qaku rät pät a qa iva qät lavuqi ");
INSERT INTO uro_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","nä ma Abraham gä na aa es nasot a ne vasägos parhäm aa enge na ama rharesbane mudu qärangätni i ngät bä ba ut mamäkkäna.” ");
INSERT INTO uro_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Näkt ma Maria qali qi ge ma Elisabet bä qorhäs na ama dävagukt ama eqoan näkt evär däm gi säva arha vät. ");
INSERT INTO uro_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Rhäkt di ama qäväläm ngä män iva ma Elisabet ki sa bä qia sa ama gamoeqa. ");
INSERT INTO uro_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bä rhoqoräkt di iarhakt kärarhae na glaqot na qi bä sävät at kärhae rha nari sävät a qi i ma Ngämuqa qa lavuqi na qi masirhat dä rha moe mär gem da rhi na qi. ");
INSERT INTO uro_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Vät ama ngärhäqyet da dävaung na qa ama qunäga dä rha män iva rhi däkt säng ama rhoemga bä va rha rhes ka na aa mamäk ma Sekaraia. ");
INSERT INTO uro_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Sokt di aa nanäk kia märhamän dä qi qoar toqortäqyia, “Nak kaku, nak pa u rhes ka i ma Jon.” ");
INSERT INTO uro_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Dä rhi qoar na qi rhoqortäqyia, “Qaku aung mänguräp gi qärhae di rhat tes ka nä iaqyäkt ama ngärhipki.” ");
INSERT INTO uro_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Dä rha siqutmät sage aa mamäk ivakt iva rhi räm bät a qa i nani a qa iva qa rhes ama rhoemga rhoqor mäniekt. ");
INSERT INTO uro_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dä qa siqutmät iva nani guani iva qä säm bät ini angärha rhäng. Bä qräk mät ta moe i sa qärak ka säm doqortäqyia, “Aa ngärhipki diva ma Jon.” ");
INSERT INTO uro_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Dä qoki äkt dä sak pä ma Sekaraia aa vämgi bä mamär vät a qa iva qat tamän bä qä nänsäs sage ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Dä ama ruvek nae na glaqot di qräk mät ta masirhat bä rhit len. Bä ama ruvek pät ama dabap ama lel ap e ma Judia di rhat tamän bät tärhong däkt. ");
INSERT INTO uro_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bä iarhakt moe qärarhani i rha nari sävät tärhong däkt di rhat tu arhä snäng masirhat sävät irhong inguna ma Ngämuqa aa rhäqyet nga e vät iaqäkt ama rhoemga dä rhi snanbät toqortäqyia, “Rhak täkt ama rhoemga diva agiqa na qa mugas?” ");
INSERT INTO uro_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Näkt ma Jon aa mamäk ma Sekaraia di rhäqäp ka na ama Qloqaqa ama Qumärqumärqa bä qat tamän na ama enge nage ma Ngämuqa rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ama ansäs sage ma Engeska ma Ngämuqa bä ba ama Israelqäna inguna qa män bä qa rhäksasot aa ruvek. ");
INSERT INTO uro_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Bä qa mair na akni ama qrotka sa ama mumaiar nämäni ama enevaqi i ma Devit kärak i ama latka vä ma Ngämuqa aa rem. ");
INSERT INTO uro_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Iangärhäkt di rhoqor varhäm ma Ngämuqa aa enge qärangätni i mudu nämät aa vämginarha ama qumärqumär ta mamär. ");
INSERT INTO uro_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bä ma Ngämuqa aa snängaqa diva qä lavuqi na ut nämät aurha ikkäna dä nämät iarhakt kärarhae i ama vu da arha ron masirhat sävät a ut ");
INSERT INTO uro_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","bä rhoqoräkt ivakt iva qa rhualat na aa lavuqi bä ba aut mamäkkäna bä va saqi as kat dräm na aa rharesbane mänguräp mä qa qä na rha. ");
INSERT INTO uro_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Iangärhäkt ama mumänaris kärangätni i qa mu ngät ba aut mamäk ma Abraham ");
INSERT INTO uro_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","iva qa rhumaiar na ut nämät aurha ikkäna dä rhoqoräkt i qali lut pä ma Ngämuqa aa rem di qaku mamär iva urhit len ");
INSERT INTO uro_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","doqoräkt i ut tualat na ama qumärqumär ngät ama lat dä ama räkt ngät ama lat da aa saqong bät aut kunäng na aurha iar moe. ");
INSERT INTO uro_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Bä ainge ngua emga diva rhat tes nge i ma Ngämuqa aa vämginaqa nage ma Moräsnaqa Na Rhävuk inguna va ngia er ngia rhet pä ma Engeska aa qamäs bä va ngi rhäkmu na ama iska ba qa ");
INSERT INTO uro_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ivakt iva ngi qoar nä ma Ngämuqa aa ruvek iva rhi rha ama mumaiar qärangätni i ngät dän doqoräkt i ma Ngämuqa qät kyiradeng na arha vuirhong. ");
INSERT INTO uro_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Inguna nävät ma Ngämuqa aa lavuqi ama mor qi diva ama qunäga qa rhäranas bä qa rhän sagem ut na rhävuk ");
INSERT INTO uro_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ivakt iva qä voda ama neraqa sävät iarhakt kärarhae i qale rha vät bängangit angät tpäs dä qärarhani i rhat däqäm dap arha iar di qaku ama iar ama engäktki na ngät nage ma Ngämuqa dä va qa rhuräkt bä ba ut säva ama is na ama bulap.” ");
INSERT INTO uro_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bä ma Jon ga ir bä sa mor qa bä sa ama qrot ka da ama iar vät aa qloqaqa näkt kale qa vät ama qräk dä bäs ama ivärhäs bä dängdäng bät iaqäkt ama qunäga qärakni i vuk sä qa säda eraqi sage ama Israelqäna. ");
INSERT INTO uro_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Vät iangärhäkt ama rhodäm dä ama muqunäga qa met nage ma Sisar ma Ogastas iva rhi säm ama ruvek moe arhä ngärhep nävät ama ivätki qäraktni i ama narhoerta nae näva ama värhäm ama mor äm ma Rom dit lu vät a qi. ");
INSERT INTO uro_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Rhangät täkt di ama narhoer ngät ama rhodäm sa ama ruvek toqoräkt i ma Kwirinius di ama tpäskinaqa va ama ngärhäktka ma Siria. ");
INSERT INTO uro_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Bä ama ruvek moe di vräsmät na rha i qoki ak dä ak sämät aa värhäm iva rhi rha ama rhodäm sä rha. ");
INSERT INTO uro_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Dä soknga ma Josep di qosaqi qa met nae ma Galili nämät ama värhäm ma Nasaret pävit sämät ma Devit aa värhäm ama gaini na äm e ma Judia qärqom i rhat tes äm i ma Betlehem inguna qa di sägärhae na qa sävät ma Devit. ");
INSERT INTO uro_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ma Maria qäraktni i mänaris na qi sävät ma Josep di qä na qi in met ivakt iva rhi rha ama rhodäm sä iom. Dap toqoräkt di qi vät a nas. ");
INSERT INTO uro_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bä nga qali liom e dä sa ama qäväläm ngä män iva qi sa. ");
INSERT INTO uro_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Bä qia sa at toemga ama narhoer qa va ama bulmakaoqäna angärha vätki näkt kia ong ga na ama boi näkt kia mas na qa va ama bulmakaoqäna angärha tmäs näväm ga ama luska inguna qaku anga släqyäs nanokt iom ba ama tmända arha vätki. ");
INSERT INTO uro_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Näkt näp bängagi dä qale ama gamoe qärarhani i rhat dräm dat tas dap tit lu vät ama sipsipkäna vät angärha ivärhäs e glaqot. ");
INSERT INTO uro_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Dä ama ensel nage ma Ngämuqa väs däm ga gem da bä ma Ngämuqa aa murhämeska qa sen namet a rha bä rhäqäp ta mamär na ama tlenga. ");
INSERT INTO uro_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Sokt di ama ensel qa qoar na rha rhoqortäqyia, “Qale ngänit len. As ngäni nari, nak ngua män sa ama sameng ama mär ngät na ama märmärgem bä ba ama ruvek moe. ");
INSERT INTO uro_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Rhäqyerhäkt di sa rha sa qärak iva qa rhumaiar na ngän bä ma Devit aa värhäm. Qa di ma Krais ma Engeska. ");
INSERT INTO uro_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Va ngäni räm a qa nage rhakt täkt ama muqunängi i iaqäkt ama rhoemga di rha ong ga na ama boi näkt kat namas pa ama bulmakaoqäna angärha tmäs näväm ga ama luska.” ");
INSERT INTO uro_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Näkt ama rhäqäp na rha mamär ama enselqäna väs däm da masägos sage qärak kä ensel bä rhi nän sä ma Ngämuqa dap tat tamän doqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Urhit boda ama murhämeska sage ma Ngämuqa rhävuk da ama usäpki arha ron dä ama bulap pät ivät ba ama ruvek kärarhani i aa snäng bät a rha.” ");
INSERT INTO uro_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bä nga ama enselqäna rha met daqule rha sa rhävuk säva usäp dä iarhakt kärarhae i rhit lu vät ama sipsipkäna rhi qoar na ne rhoqortäqyia, “U rhet sae ma Betlehem bä urhi lu iangärhäkt ama lat kärangätni i ngä märanas iangärhäkt kärangät i sa ma Engeska ma Ngämuqa qa qoar na ut sävät a ngät.” ");
INSERT INTO uro_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dä soknga rha ang bä sae dä rhit ñäm bä rha män bät ma Maria qi nä ma Josep dä ama qokokka qärakni i qat namas pa ama bulmakaoqäna angärha tmäs näväm ga ama luska. ");
INSERT INTO uro_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bä nga rha lu qa dä rha vräs ama enge qärangätni i ama ensel qa qoar na rha na ngät sävät ma Jisas. ");
INSERT INTO uro_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bä ama ruvek moe qärarhani i rha nari di qräk mät ta nävät ama sameng nage qärarhani i rhit lu vät ama sipsipkäna. ");
INSERT INTO uro_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Dap ma Maria di qia sangar sävät tärhong däkt ama engirhong mät at snängaqa bä qi manäkt irhong mamär. ");
INSERT INTO uro_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Dä qärarhae i rhit lu vät ama sipsipkäna di evär däm da sage arhä sipsipkäna dap ti nänsäs sage ma Ngämuqa nävät iarhongäkt kärqärhong i rha nari dä rha lu irhong barhäm ama ensel aa enge bä ba rha. ");
INSERT INTO uro_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nasot ama ngärhäqyet da dävaung ama qunäng doqoräkt i rha däkt säng mä qa dä rha mes ka i ma Jisas. Rhakt täkt ama ngärhipki di ama ensel qa mes ka na qi rhoqoräkt i as kaku ma Maria at sarebäm nä ma Jisas. ");
INSERT INTO uro_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nga ama qäväläm ngä män iva rhi qumär nas dä ma Ngämuqa aa saqong sa arha vuirhong doqor varhäm ma Ngämuqa aa Muräkt nage ma Moses dä rha män sä ma Jisas sämät ama värhäm ama mor äm ma Jerusalem ivakt iva rhi vodäm ga bä ma Ngämuqa ");
INSERT INTO uro_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","toqor varhäm gärangätni ama Muräkt nage ma Ngämuqa qärangätni i ngät tamän doqortäqyia, “Ama narhoer ta ama gamoe moe qärarhani i rhit sa rha diva rhi arñis na rha bä bä ma Ngämuqa” ");
INSERT INTO uro_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","dä qosaqi va rhi voda ama vodämes toqor varhäm ama Muräkt nage ma Ngämuqa qärangätni i ngät tamän doqortäqyia, “Mamär iva rhi väs anga unbam anga simängam ura anga unbam anga rhoebam anga ituam.” ");
INSERT INTO uro_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Dap nga rhoqoräkt di qale ama ruqa e ma Jerusalem gärak i rhat tes ka i ma Simeon näkt ka di ama saengäkt ka dä ama räkt ka dä ma Ngämuqa aa saqong gärak i iaqäkt di mudu qat nañäm nani ama ruqa qärak iva qa rhumaiar na ama Israelqäna näkt ama Qloqaqa ama Qumärqumärqa qa e gem ga ma Simeon. ");
INSERT INTO uro_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Näkt ama Qloqaqa ama Qumärqumärqa qa muqunäga vät a qa iva as kaku qä nañäp dap as pa qä lu iaqäkt kärak i sa ma Engeska qa muqunän bät a qa ma Krais. ");
INSERT INTO uro_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Näkt ama Qloqaqa ama Qumärqumärqa qa märanas na qa bä qa er nanokt ka säva ama ansäspämgi ama mor qi näkt nga ama ngätmamäqiom in mon sa ama qokokka ma Jisas ivakt iva rha rhualat sä qa rhoemga rhoqoräkt parhäm ama Muräkt kärangätni i ngät tamän iva rha rhualat toqoräkt ");
INSERT INTO uro_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","dä ma Simeon ga sek mä qa na aa rhäqyisem bä qa ansäs sage ma Ngämuqa näkt kä qoar na qa rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Sokt nge Ngämuqa, rhoqor varhäm gia enge qärangätni i sa ngia märhamän särhäm ngo di sa mamär iva rhäkt di ngi rhares pät gua rhäng aingo ama latka vä gia rem iva ngua rhet sa ama bulap ");
INSERT INTO uro_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","inguna sa ngua lu iaqäkt kärak i sa ngia rhäk na qa sa ama mumaiar ");
INSERT INTO uro_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","iva bä ba ama ruvek moe. ");
INSERT INTO uro_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Qa diva ama neraqa na qa iva qa rhuqunäga bä ba ama Jentailqäna dä va qa rhän sa ama murhämeska sage gia ruvek ama Israelqäna.” ");
INSERT INTO uro_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ama qokokka aa mam dä aa nan di qräk mät iom masirhat nävät ama enge qärangätni i ma Simeon ga märhamän bät a ngät sävät a qa. ");
INSERT INTO uro_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Dä ma Simeon ga nän da ama modämne sävät a iom näkt kä qoar nä ma Maria ama rhoemga aa nanäk toqortäqyia, “As ngi nari, ma Ngämuqa aa muqunän nga e vät tak täkt ama rhoemga iva nävät a qa dä va anga rhäqäp na rha anga ruvek nae ma Israel diva arharpus na arhani dä va arhani rhat täranas. Näkt pa qa diva ama muqunän na qa qärakni iva ama ruvek tat tamän na ama nängoer sävät a qa ");
INSERT INTO uro_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","dap pa anga rhäqäp na rha arhä mungäsnäng diva vuk sä ngät säda eraqi. Näkt kosaqi nge diva ama ulaqi arha singi qi rheräkt gi snängaqa.” ");
INSERT INTO uro_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Qale ma Ngämuqa aa vämginaqi ma Ana ma Fanuel aa imgi qärakni i qa nämäni ama enevaqi i ma Aser. Ama sru qi na qi qäraktni i mudu qia mät arha egutka bä qali liom gem ne vät ama ngärhäqyet da ama udiom na ama qoeo näkt sa qa ñäp ");
INSERT INTO uro_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","näkt ama maqoski na qi bä dängdäng i at koeo di ama ruvek ama levaet na rha da ama levaet. Qaku qiat tet näva ama ansäspämgi ama mor qi dap kit boda ama ansäs pät kunäng näp bängang dä qiat teranot dä qi nän. ");
INSERT INTO uro_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Qia män sagem da vät iomäkt ama qäväläm bä qia voda at märmärgem sage ma Ngämuqa näkt kia sameng sävät ama qokokka bä ba ama ruvek moe qärarhani i qale rha nani ama muisiska bä bä ma Jerusalem. ");
INSERT INTO uro_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bä sa nga ma Josep kä nä ma Maria in mualat nä iarhongäkt moe rhoqor varhäm ama Muräkt nage ma Ngämuqa bä rhäksot dä evär däm da säva arha värhäm ama gaini na äm ma Nasaret e ma Galili. ");
INSERT INTO uro_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Näkt ama qokokka di märmor qa bä ama qrot ka näkt täqäp ka na ama mädräm ama mär ngät näkt ma Ngämuqa aa ñämsävätki di qia e vät a qa. ");
INSERT INTO uro_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Vät ama qoeo moe dä ma Jisas aa mamäkkäna rhat tet sae ma Jerusalem bä säva ama tmäski iva rhat tuqunän bät ma Pasova. ");
INSERT INTO uro_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Bä nga ma Jisas di ama ngärhäqyisem da udiom na aa qoeo dä rha met sae säva ama tmäski rhoqor varhäm ama Judaqäna arhä qärhong. ");
INSERT INTO uro_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bä nga rhäksot na ama tmäski dä evär däm iom säva vät dap ama rhoemga ma Jisas di qale qa e ma Jerusalem. Näkt aa mamäqiom di qaku inät dräm doqor täkt. ");
INSERT INTO uro_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Dap in du in snäng i qa e ge ama gulañ na ama ruvek kärarhani i rha moe rhat tet bä rha met pät ama qunäga ama rhäk täm ga bä nak as nga nasot dä init ñäm nani a qa mänguräp aa ruvek dä aa qärhae. ");
INSERT INTO uro_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bä qop nga qaku in män bät a qa dä evär däm iom sae ma Jerusalem bä init ñäm nani a qa. ");
INSERT INTO uro_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bä nga vät ama dävaung na qa ama qunäga dä in män bät a qa va ama ansäspämgi ama mor qi i qat muqun mänguräp iarhakt kärarhae i rhat dräm dit boda ama rhisu i qat nari rha dä qä snanbät sä rha na ama snanbät. ");
INSERT INTO uro_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Näkt iarhakt moe ama ruvek kärarhani i rhat nari ma Jisas di qräk mät ta nävät aa mädräm dä aa muvät. ");
INSERT INTO uro_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bä ma Jisas aa mamäkkäna di qräk mät ta nävät a qa rhoqoräkt i rha lu qa bä aa nanäk ki qoar na qa rhoqortäqyia, “Ngua emga, mäniekt bä ngia mualat toqor täkt sä un? Ngi lu, gi mam gä na ngo di unit täksot mamär nani a nge.” ");
INSERT INTO uro_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Dä qa muvät pät a iom doqortäqyia, “Mäniekt bä va init ñäm nani a ngo? Nak nga qaku inät dräm i nak pa qale ngo vä gu mam aa vätki?” ");
INSERT INTO uro_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Sokt di qaku qunäga vät a iom sa aa muvätki. ");
INSERT INTO uro_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Näkt sa evär däm ga qä na iom sae ma Nasaret bä qät päs ina enge angärha rhäng dap aa nanäk di qia sangar sävät iarhongäkt ama engirhong moe mät at snängaqa. ");
INSERT INTO uro_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Bä märmor ma Jisas sä ne na aa mädräm bä ma Ngämuqa qä na ma ruvek di sa märmär gem da nävät a qa. ");
INSERT INTO uro_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Vät ama quiaqa ama ngärhäqyisem da qäraet na qa qärakni i ma Taiberius di ama Sisar na qa dap toqoräkt di ma Pontius Pailat di ama tpäskinaqa e ma Judia dap ma Herot di ama tpäskinaqa e ma Galili dap aa läktka ma Filip di ama tpäskinaqa vät ama ivärhäs ma Ituria dä vät ama ivärhäs ma Trakonitis dap ma Lisanias di ama tpäskinaqa vät ama ivärhäs ma Abilene ");
INSERT INTO uro_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","vät iangärhäkt ama rhodäm gärangätni i ma Anas kä nä ma Kaiafas in dualat i ama prisiom ama vit na iom dä ama enge nage ma Ngämuqa ngä män bä ma Jon ma Sekaraia aa emga vät ama qräk dä bäs ama ivärhäs. ");
INSERT INTO uro_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Bä qa met pät ama ivärhäs moe namet ama rigi ma Jordan bä qä sameng ba ama ruvek iva rhi näpgoer na nas näkt ti rha ama baptais bä va ma Ngämuqa qä qyiradeng na arha vuirhong. ");
INSERT INTO uro_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Iangärhäkt ama lat di rhoqor varhäm ma Aisaia ma Ngämuqa aa vämginaqa aa enge qärangätni i qa säm a ngät toqortäqyia, “Ama eguinga qät näs pät ama qräk dä bäs ama ivärhäs toqortäqyia, ‘Ngäni rhäkmu na ama iska nanokt ma Engeska dä ngäni slaräkt na ama is nanokt ka. ");
INSERT INTO uro_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ama up moe diva ngäni rhäqäp ngät dä ama dam ngä na ama dabap ama lel ap moe diva ngän don ngät. Ama is ama vaktmät na ngät diva ngäni slaräkt na ngät bä ama is ama damadam bät a ngät diva maräkt na ngät. ");
INSERT INTO uro_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Näkt ama ruvek moe diva rhi lu ama mumaiar nage ma Ngämuqa.’” ");
INSERT INTO uro_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ma Jon gat tamän särha ama gulañ na ama ruvek kärarhani i rhat dän sagem ga iva qä baptais pät a rha rhoqortäqyia, “Aingän gärarhae i ama guläñgi na ama uiuvärhirhong gärqärhong i irhong ngärhit kut na ama qänogi, auge sa qa qoar na ngän i mamär iva ngäni ingis ma Ngämuqa aa uraqi ama mor qi iva nasot dä qia rhän? ");
INSERT INTO uro_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mamär iva ngäni sa ama gavam nävät angäna lat i ngän näpgoer na nas. Qale ngäni qoaräs na ne i, ‘Ma Abraham di aut mamäk na qa’ inguna ngu qoar na ngän i nak kop mamär vät ma Ngämuqa iva qä näpgoer nä rhaerhangät ama dui bä va ngä rhän i ama rhoes bä bä ma Abraham. ");
INSERT INTO uro_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sa qäqi rhäkt di sa akni qa rhäkmu na nas sa ama apem iva qä nasäng i qät tap säng ama ngämung na qi. Dä soknga ama ngämung moe qärangätni i sa qaku ngärhit sa anga mär ngät anga gavam diva rhit täpmät na ngät samäk dä rhit don na ngät sämät ama mudäbäs.” ");
INSERT INTO uro_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dä ama gulañ na ama ruvek ti snanbät toqortäqyia, “Dä va u rhualat toqor mäniekt?” ");
INSERT INTO uro_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Dä ma Jon ga muvät toqortäqyia, “Ama ruqa qärakni i aa sravem ama unbem di mamär iva qa rhat mät em bä qä von iaqäkt kärak i qaku aa anga agukt. Bä iaqäkt kärak i aa tmäs diva qosaqi qa rhualat toqoräkt.” ");
INSERT INTO uro_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ama ruvek kärarhani i rhit ta ama takes di qosaqi rha män ivakt iva rhi rha ama baptais. Dä rhi snanbät toqortäqyia, “Qamorqa, dap aiut diva u rhualat toqor mäniekt?” ");
INSERT INTO uro_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Dä qa muvät pät a rha rhoqortäqyia, “Qale ngänit ta savit na ama rhodäm sa ama ligär nage ama ruvek.” ");
INSERT INTO uro_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Dä arhani ama ulaqimärharhärhäkt ti snanbät sä qa rhoqortäqyia, “Dap aiut diva u rhualat toqor mäniekt?” Dä qa muvät toqortäqyia, “Qale ngänit säm ama tlenga säda ama ruvek arha ron iva nani ama ligär dä qale ngänit täksärha ama ruvek mavängam dap mamär iva qoki märmär gem ngän na angän ditsek.” ");
INSERT INTO uro_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ama ruvek di rhat namu nani ma Krais dap tat tu arhä snäng ivar ngäktki i ma Jon di qa rhak täkt. ");
INSERT INTO uro_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Dä ma Jon ga muvät pät a rha moe rhoqortäqyia, “Ngu baptais bät a ngän na ama rigi. Dap akni qa e qärakni iva as dängdäng na qa nasot a ngo dä aa qrot ngä vit pä gu qrot angät tpäs dä ama rhängämitnäm sa ama sandal nävät aa qäriglem angät tpäs di qaku ama märqa na ngo iva ngu rhäväkt sä itnäm. Qa diva qä baptais pät a ngän na ama Qloqaqa ama Qumärqumärqa dä na ama mudämgi. ");
INSERT INTO uro_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Sa qa rhäkmu na nas iva qä rharmeng da ama tmäs näva ama qlanäga dä va qa armeng da ama tmäs bä qa rhon sä ngät säva aa vätki qäraktni i qali qi e nani ama lat toqoräkt dap pa qä rhon na ama qlanäga sämät ama mudam gärangätni i sa qaku mamär vät aung iva qä naveng bät a ngät.” ");
INSERT INTO uro_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ma Jon ga märanas na ama ruvek na ama enge masirhat i qä sameng na ama sameng ama mär ngät ba rha. ");
INSERT INTO uro_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Mudu ma Jon di sa qa märhamän na ama enge ama qrot ngät särha ama tpäskinaqa ma Herot inguna vät aa läktka aa egutki ma Herodias at täväs bä qosaqi inguna nävät angätni aa lat ama vu ngät moe. ");
INSERT INTO uro_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Bä rhäkt di ma Herot ka mualat na ama lat ama vu ngät savono sae i qa väsärhä ma Jon ba ama tpäskiarharhäng. ");
INSERT INTO uro_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bä nga rhoqoräkt i ma Jon gä baptais pät ama ruvek moe dä ma Jisas di qosaqi qa baptais pät a qa. Bä nga rhoqoräkt i ma Jisas kä nän dä ama usäpki qia qang ");
INSERT INTO uro_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","bä ar sa ama Qloqaqa ama Qumärqumärqa i qa rhoqor ama simängaqa bä qa muqun bät a qa. Näkt akni ama eguinga qa märhamän näda ama usäpki arha ron doqortäqyia, “Ainge di ngua emga na nge qärak i sa gua snäng bät a nge dä qosaqi märmär gem ngo masirhat nävät a nge.” ");
INSERT INTO uro_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Bä rhoqoräkt i ma Jisas ka nasäng na aa lat di sa qa di qorhäs iva ama ruqa ama rhäk täm ga da ama ngärhäqyisem na aa qoeo. Qa di varhäm ama ruvek arhä mädräm di ma Josep aa emga. Näkt ma Josep di ma Heli aa emga ");
INSERT INTO uro_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","näkt ma Heli di ma Matat aa emga näkt ma Matat di ma Livai aa emga näkt ma Livai di ma Melki aa emga näkt ma Melki di ma Janai aa emga näkt ma Janai di ma Josep aa emga. ");
INSERT INTO uro_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Näkt ma Josep di ma Matatias aa emga näkt ma Matatias di ma Amos aa emga näkt ma Amos di ma Nahum aa emga näkt ma Nahum di ma Esli aa emga näkt ma Esli di ma Nagai aa emga. ");
INSERT INTO uro_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Näkt ma Nagai di ma Mat aa emga näkt ma Mat di ma Matatias aa emga näkt ma Matatias di ma Semein aa emga näkt ma Semein di ma Josek aa emga näkt ma Josek di ma Joda aa emga. ");
INSERT INTO uro_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Näkt ma Joda di ma Joanan aa emga näkt ma Joanan di ma Resa aa emga näkt ma Resa di ma Serubabel aa emga näkt ma Serubabel di ma Sealtiel aa emga näkt ma Sealtiel di ma Neri aa emga. ");
INSERT INTO uro_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Näkt ma Neri di ma Melki aa emga näkt ma Melki di ma Adi aa emga näkt ma Adi di ma Kosam aa emga näkt ma Kosam di ma Elmadam aa emga näkt ma Elmadam di ma Er aa emga. ");
INSERT INTO uro_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Näkt ma Er di ma Josua aa emga näkt ma Josua di ma Elieser aa emga näkt ma Elieser di ma Jorim aa emga näkt ma Jorim di ma Matat aa emga näkt ma Matat di ma Livai aa emga. ");
INSERT INTO uro_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Näkt ma Livai di ma Simeon aa emga näkt ma Simeon di ma Juda aa emga näkt ma Juda di ma Josep aa emga näkt ma Josep di ma Jonam aa emga näkt ma Jonam di ma Eliakim aa emga. ");
INSERT INTO uro_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Näkt ma Eliakim di ma Melea aa emga näkt ma Melea di ma Mena aa emga näkt ma Mena di ma Matata aa emga näkt ma Matata di ma Natan aa emga näkt ma Natan di ma Devit aa emga. ");
INSERT INTO uro_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Näkt ma Devit di ma Jesi aa emga näkt ma Jesi di ma Obet aa emga näkt ma Obet di ma Boas aa emga näkt ma Boas di ma Salmon aa emga näkt ma Salmon di ma Nason aa emga. ");
INSERT INTO uro_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Näkt ma Nason di ma Aminadap aa emga näkt ma Aminadap di ma Admin aa emga näkt ma Admin di ma Arni aa emga näkt ma Arni di ma Hesron aa emga näkt ma Hesron di ma Peres aa emga näkt ma Peres di ma Juda aa emga. ");
INSERT INTO uro_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Näkt ma Juda di ma Jekop aa emga näkt ma Jekop di ma Aisak aa emga näkt ma Aisak di ma Abraham aa emga näkt ma Abraham di ma Tera aa emga näkt ma Tera di ma Nahor aa emga. ");
INSERT INTO uro_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Näkt ma Nahor di ma Seruk aa emga näkt ma Seruk di ma Reu aa emga näkt ma Reu di ma Pelek aa emga näkt ma Pelek di ma Eber aa emga näkt ma Eber di ma Sela aa emga. ");
INSERT INTO uro_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Näkt ma Sela di ma Kainan aa emga näkt ma Kainan di ma Arpaksat aa emga näkt ma Arpaksat di ma Siem aa emga näkt ma Siem di ma Noa aa emga näkt ma Noa di ma Lamek aa emga. ");
INSERT INTO uro_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Näkt ma Lamek di ma Metusela aa emga näkt ma Metusela di ma Enok aa emga näkt ma Enok di ma Jaret aa emga näkt ma Jaret di ma Mahalalel aa emga näkt ma Mahalalel di ma Kenan aa emga. ");
INSERT INTO uro_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Näkt ma Kenan di ma Enos aa emga näkt ma Enos di ma Set aa emga näkt ma Set di ma Adam aa emga näkt ma Adam di ma Ngämuqa aa emga. ");
INSERT INTO uro_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ma Jisas di ama Qloqaqa ama Qumärqumärqa qa rhäqäp ka na nas näkt evär däm ga nämäni ama rigi ma Jordan bä ama Qloqaqa ama Qumärqumärqa qa er nanokt ka sävät ama qräk dä bäs ama ivärhäs ");
INSERT INTO uro_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","bä qale qa vät ama ruiom ama udiom na ama qunäng näkt ma Sämga qa siqut na qa iva qa rhualat na anga vuini. Qaku qa mäs guani vät iangärhäkt ama qunäng näkt nga nasot a ngät moe ama qunäng dä anoeng mä qa. ");
INSERT INTO uro_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dä ma Sämga qa qoar nä ma Jisas toqortäqyia, “Ngakt bä ma Ngämuqa aa emga na nge dä va ngi qoaräs nä rhak täkt ama duiqa iva qä rhän i ama bret.” ");
INSERT INTO uro_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Ma Ngämuqa aa enge qärangätni i sa rha säm a ngät di ngät tamän doqortäqyia, ‘Ama ruvek diva rhat däqäm di qaku sokt da ama bret.’” ");
INSERT INTO uro_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Dä ma Sämga qa er nanokt ka bä sävät ama ivärhäs tävuk bä qa qur ma Jisas ta ama muräktpäm moe vät ama ivätki vät ama qäväläm ama qot äm nak kop. ");
INSERT INTO uro_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Näkt ma Sämga qa qoar nä ma Jisas toqortäqyia, “Va ngu von nge rha ama ivärhap ap angät muräkt moe dä ap angät murhämeska moe inguna sa ma Ngämuqa qa von ngo rha ama rhares iva ngut lu vät a ap. Bä mamär iva ngu von aung dä bap kärakni i nani a ngo iva ngu von ga. ");
INSERT INTO uro_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Bä nga va ngi von dä gi qutdrir sagem ngo dä va ainge sa ap moe.” ");
INSERT INTO uro_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Dä ma Jisas ka muvät toqortäqyia, “Ma Ngämuqa aa enge qärangätni i sa rha säm a ngät di ngät tamän doqortäqyia, ‘Mamär iva ngi nänsäs sage ma Engeska gi Ngämuqa bä va sokt ka qärakni iva qale nge va aa rem.’” ");
INSERT INTO uro_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dä ma Sämga qa artäm sä ma Jisas sae sämät ma Jerusalem näkt ka qoar na qa bä qa mair tävuk da ama ansäspämgi ama mor qi at täväs mamär näkt kä qoar na qa rhoqortäqyia, “Ngakt bä ma Ngämuqa aa emga na nge dä va ngi rhon na nas mane narhäkt. ");
INSERT INTO uro_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Inguna ma Ngämuqa aa enge qärangätni i sa rha säm a ngät di ngät tamän doqortäqyia, “‘Ma Ngämuqa va qa rhuräkt bä ba aa enselqäna sävät a nge iva rhi lu vät a nge mamär.’ ");
INSERT INTO uro_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","bä “‘Va rhi sek mä nge na arhä rhäkt i varis ngi nanguñ gi nga qäraet mäni anga duiqa.’” ");
INSERT INTO uro_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Dä ma Jisas ka muvät toqortäqyia, “Ma Ngämuqa aa enge di ngät tamän doqortäqyia, ‘Qale ngi siqut nä ma Engeska gi Ngämuqa.’” ");
INSERT INTO uro_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Bä nga ma Sämga qa rhäksot na aa siqutsiqut moe sävät ma Jisas dä qa met daqule qa iva qale qa nani anga släqyäs iva saqi as kä siqut na qa. ");
INSERT INTO uro_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Näkt sa evär dä ma Jisas sae ma Galili da ama qrot angärha ron i ama Qloqaqa ama Qumärqumärqa bä ama enge sävät ma Jisas di vräs däm ngät pät iaqäkt ama ngärhäktka moe. ");
INSERT INTO uro_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Qä su va arhä mämairväm bä ama ruvek moe di rhi nänsäs sagem ga. ");
INSERT INTO uro_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Dä qa met sae ma Nasaret äkt i mudu mor qa e bä nga vät ama Sabat dä qat tet bä säva ama mämairqi rhoqor vasägos i qat tualat. Näkt ka mair iva qat tes. ");
INSERT INTO uro_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Dä rha von ga rha ama ilotka na ama abuqit sä ma Ngämuqa aa enge qärangätni i aa vämginaqa ma Aisaia qa säm a ngät. Qa rhäväkt dä bit bä qa män bät iangärhäkt ama enge qärangätni i sa rha säm a ngät kärangätni i ngät tamän doqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ma Engeska aa Qloqaqa di qa rhäqäp ngo na nas inguna sa ma Engeska qa muqunän bät a ngo iva ngu sameng na ama sameng ama mär ngät bä ba ama tläkta. Dä qa rhäk na ngo iva ngu sameng bät ama ruvek kärarhani i qale rha mät ama ispät diva isiska vät a rha bä va iarhakt kärarhae i ama säsur ta diva qunäga mät arhä saqong bä va qärarhani i qale rha da ama märänga aa ron diva isiska vät a rha ");
INSERT INTO uro_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","dä va ngu sameng i sa rhäkt diva ma Ngämuqa qä qur aa ruvek ta aa modämne.” ");
INSERT INTO uro_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nasot dä qa emanäng bät ama ilotka nä qa abuqit näkt ka evär dä bit bä ba ama latka näva ama mämairqi näkt ka muqun ivakt iva qä su. Dap ama ruvek moe va ama mämairqi di arhä saqong moe sävät a qa bä rhat lu qa. ");
INSERT INTO uro_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Dä qa nasäng i qat tamän i qä qoar na rha rhoqortäqyia, “Rhäqyerhäkt di sa ngän nari i ma Ngämuqa aa enge sävät a ngo i mudu rha säm a ngät di ngä mu angät släqyige vät a nas.” ");
INSERT INTO uro_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Rha moe ama ruvek di rhat tamän na ama märmärgem sävät a qa dä qräk mät ta nävät aa enge ama märän bäm ngät. Dä rhi qoar na ne rhoqortäqyia, “Nak kop ma Josep aa emga rhak täkt.” ");
INSERT INTO uro_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Nguat dräm iva ngäni vuk sa ama engini ama mär ngät ama mädräm bät ini sävät a ngo rhoqortäqyia, ‘Ngakt bä nga ainge di ama ruqa qärakni i qat dräm gat tumäräspät dä mamär iva ngia rhumäräs pät a nas! Ngia rhualat te mät gia värhäm nä iarhongäkt kärqärhong i ut nari i sa ngia mualat nä irhong ba ama värhäm ama mor äm ma Kaperneam.’” ");
INSERT INTO uro_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Dä saqi as ma Jisas kä qoar toqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i qaku aung nävät ma Ngämuqa aa vämginarha di sa mär ge aa qärhae na qa. ");
INSERT INTO uro_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Bä nguat tamän särhäm ngän na ama engäktki i vät ama rhodäm imäk äkt kärangätni i qale ma Elaija di masirhat na ama maqosta ama evop ama Israelqina dap toqoräkt di ama qunängit bä qaku anga suigi qia säp pät ama qoeo ama dävaung näkt ama ngärhäqyet da sägäkt ama eqoan bä ama qärhuqi vät ama ivärhäs moe e ma Israel. ");
INSERT INTO uro_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Sokt di ma Elaija di qaku rha rhäk na qa sage agukt nävät iarhakt ama maqosta dap sokt sage aktni ama ruqi qäraktni i qaku qi nävät ama Judaqäna dap iaqyäkt di ama maqoski e mät ama värhäm ama gaini na äm ma Sarefat pät ama ngärhäktka rhage na ama värhäm ma Saidon. ");
INSERT INTO uro_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Vät ama rhodäm gärangätni i qale ma Ngämuqa aa vämginaqa ma Elisa di ama rhäqäp na rha e ma Israel qärarhani i ama bias pät a rha sokt di qaku aung nävät a rha di qa rha ama mumäräspät dap sokt ma Naman nae ma Siria qärakni i qosaqi qa di qaku qa nävät ama Judaqäna.” ");
INSERT INTO uro_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bä nga ama ruvek moe va ama mämairqi rha nari rhoqoräkt dä uraqi da arha ron. ");
INSERT INTO uro_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dä rha qutmäs a qa sä dalek na arha värhäm näkt ta met sä qa säda ama damgi at täväs iaqyäkt i rha rhäk arha värhäm mäni qi iva nguna rhi rhon na qa vät käsap. ");
INSERT INTO uro_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Sokt di qop ka met mänguräp ama guläñgi na ama ruvek bä qa met daqule rha. ");
INSERT INTO uro_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Dä ma Jisas ka met mämane bä sae ma Kaperneam e ma Galili näkt pät ama Sabat dä qa nasäng iva qä su ama ruvek. ");
INSERT INTO uro_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bä ama ruvek di qräk mät ta nävät aa rhisu inguna aa sameng di ngät dän sa angät krot. ");
INSERT INTO uro_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Vät akni ama qunäga vuk pa ama mämairqi di qale akni ama ruqa qa e qärakni i ama iauska qa e mät ka. Di qa näs tävuk toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ai, Jisas nae ma Nasaret, nani a nge iva ngia mäsana na ut? Nak nga ngia män iva ngi slava na ut bä qäbäs na ut? Nak kop nguat dräm a nge. Ainge di ma Ngämuqa aa Qumärqumärqa mamär.” ");
INSERT INTO uro_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Dä ma Jisas ka märhamän ma ama qrot i qä qoar na qa rhoqortäqyia, “Mänadin däm nge! Vuk sä nge nämät ka!” Dä qärak ama iauska qa rhon nä qärak ka ruqa samäk da arhä saqong näkt puk sä qa nämät ka dap kaku qa sangäm na qa. ");
INSERT INTO uro_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ama ruvek moe di qräk mät ta dä rhi snanbät sä ne rhoqortäqyia, “Nak sa agi rhisu rhangät täkt? Qät täk na ama iaus dä vukpuk sä ngät inguna qat sangar ama rhares dä ama qrot. Bä qat tamän dä vukpuk sä ngät!” ");
INSERT INTO uro_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dä vräs da ama enge sävät ma Jisas sävät ama ngärhäktka rhage rhage. ");
INSERT INTO uro_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ma Jisas ka märanas näva ama mämairqi bä qa met bä sävä ma Saimon aa vätka. Dap toqoräkt di ma Saimon aa rhäväski di aräm gi i aqärnas päm gi masirhat dä rha nän ma Jisas iva qa rhumäräs pät a qi. ");
INSERT INTO uro_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Dä ma Jisas ka angär mane sävät a qi näkt ka märhamän na ama enge ama qrot ngät sävät ama rämgi bä qia met nävät a qi. Dä qop kia märanas äkt bä qia nasäng i qit täkmu iva qi rhäk pät a rha na anga tmäs. ");
INSERT INTO uro_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bä sa nga bängangäs bängangäs dä ma ruvek ta rha qärarhani ama ruvek moe sa ama räm maos maos bä sage ma Jisas bä nga qat tu aa rhäkt pät a rha asägäk asägäk dä märäsmäräs pät a rha. ");
INSERT INTO uro_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Dä qosaqi ama rhäqäp na rha ama ruvek di vuk sa ama iaus nämät ta bä ama iaus ngät tuqaia rhoqortäqyia, “Ainge di ma Ngämuqa aa emga na nge.” Sokt di qaku ma Jisas ka rhares pät angärha rhäng iva ngät tamän inguna ngät dräm i qa di ma Krais. ");
INSERT INTO uro_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bä nga qunäga dä ma Jisas ka met sävät ama ivärhäs kärqosni i qaku anga ruvek e. Dap ama ruvek di rhit ñäm nani a qa bä nga rha män bät a qa äkt i qale qa e dä rhi siqut i rhit sangar särhäm ga iva qaku qä namet daqule rha. ");
INSERT INTO uro_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Sokt di qä qoar toqortäqyia, “Nak pa ngu sameng na ama sameng ama mär ngät sävät ma Ngämuqa aa Muräktpäm sämät apni ama värhap inguna ama rharimini i sa ma Ngämuqa qa rhäk na ngo diva nguat tualat toqoräkt.” ");
INSERT INTO uro_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Dä qoki as kä sameng ba ama mämairväm e ma Judia. ");
INSERT INTO uro_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Vät akni ama qunäga dä ma Jisas kat mair vät ama namuqa aa rhäkt ma Galili qä na ama ruvek i rhi nging däm ga bä rhat nari ma Ngämuqa aa enge ");
INSERT INTO uro_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","dä qa lu ama mlausem gärqemni i ama ruvek kärarhani i rhi rhar sa ama rhinäm di rha met nämät em bä rhit tor arhä väiu. ");
INSERT INTO uro_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Dä qa veng sämät aktni qärakt i ma Saimon aa mlauski näkt ka qoar na qa iva qä rhägär na qi maqälak nävät a qoan dä soknga qa muqun bä qä su ama ruvek nämät ki. ");
INSERT INTO uro_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bä nga qat tamän bä rhäksot dä qa qoar nä ma Saimon doqortäqyia, “Ngi rhägär na qi saqi as mono säda ama rigi arha ron mamär näkt ngänin but sa ama väiu samäk iva nani anga rhinäm.” ");
INSERT INTO uro_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Dä ma Saimon ga muvät pät a qa rhoqortäqyia, “Qamorqa, mai ama bängagi moe di urhi siqut dä qop kaku u rhar sä guani. Dap täkt di sa nguna ainge ngia märhamän dä va ngun but sa ama väiu.” ");
INSERT INTO uro_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bä nga rha mualat toqoräkt dä rha ar sa ama rhinäm masirhat bä sa arhä väiu di ngärhi nasäng iva bäñbäñmät na ngät. ");
INSERT INTO uro_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dä soknga rha siqutmät na arhä rhäkt bä ba arha ruavek mät aktni ama mlauski iva rha rhän iva rha rhatnärhäm da dä rha män bä rha rhäqäp ama mlausem bä rhäqäp em mamär bä ini nasäng i inät don. ");
INSERT INTO uro_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Bä nga ma Saimon Pita qa lu rhoqor täkt dä qa an da aa quum sä nas säng ma Jisas aa qar dä qä qoar na qa rhoqortäqyia, “Ngia rhet nävät a ngo Engeska, ama vu qa ama ruqa na ngo!” ");
INSERT INTO uro_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Inguna qa qä na aa ruavek di qräk mät ta nävät ama rhäqäp ama rhinäm gärangätni i sa rha ar sä ngät ");
INSERT INTO uro_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","dä qosaqi ma Sebedi aa imiom ma Jems kä nä ma Jon ma Saimon aa ruaiom di qräk mät iom. Dä ma Jisas kä qoar nä ma Saimon doqortäqyia, “Qale ngit len, va mänasäng narhäkt bä rhävit diva ngi rhar sa ama ruvek i rhoqor ma i ngi rhar sa ama rhinäm.” ");
INSERT INTO uro_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bä nga rha ardrän na arhä mlausem bä samit sävät a qoan dä rha met daqule iarhongäkt moe näkt ta väs ma Jisas aa rhäng. ");
INSERT INTO uro_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Bä nga rhoqoräkt i ma Jisas di qale qa mät aomni ama värhäm nävät iaväkt ama värhap dä ama ruqa qä män sä nas kärakni i ama bias pät a qa moe. Bä nga qa lu ma Jisas dä arpus na qa samäk bä aa uväski mane sävät ivät näkt kä nagukt pät ma Jisas toqortäqyia, “Gua morqa, ngakt bä nani a nge di märmärsäs gem nge iva ngia rhumäräs pät a ngo.” ");
INSERT INTO uro_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Dä ma Jisas ka rhäk aa rhäqyet bä qa rhäk pät ka ruqa. Näkt ka qoar na qa rhoqortäqyia, “Ari, nani a ngo. Rhäkt di sa märäs pät a nge.” Dä qoki äkt dä rhäksot na ama bias. ");
INSERT INTO uro_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Dä ma Jisas ka qoar na qa ma ama qrot toqortäqyia, “Qale ngi naqoar na aung sävät a nas dap kinak pa ngia rhet bä ngi qur ama pris täm mes näkt ngi voda ama vodämes kärangätni i mudu ma Moses ka mu ngät nävät gi qumärqumär ivakt iva ama ruvek ti lu i sa märäs pät a nge.” ");
INSERT INTO uro_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Sokt di qop ama sameng sävät ma Jisas di vräs däm ngät masirhat bä ama gulañ na ama ruvek di rha män ivakt iva rhi nari qa dä qosaqi va qa rhumäräs pät a rha nämät arha räm. ");
INSERT INTO uro_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Sokt di qat dräm uvup na qa bä sävät ama ivärhimek kärqämekni i qaku anga ruvek e bä qä nän. ");
INSERT INTO uro_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Vät akni ama qunäga rhoqoräkt i qä su dä ama Farisiqäna näkt sävät ama ruvek kärarhani i rhi su sävät ama Muräkt di sa rha män näva ama värhap moe e ma Galili dä nae ma Judia näkt nae ma Jerusalem bä rhat muqun e. Bä ma Ngämuqa qa von ga rha ama qrot iva qat tumäräspät nämät ama räm. ");
INSERT INTO uro_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Arhani ama gamoe di rha män i rhit ta akni ama ngäñäpärhaqa mät ama gasgaska bä rhi siqut iva rhi rha qa säva ama vätka ivakt iva rha rhu qa ge ma Jisas. ");
INSERT INTO uro_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bä nga rha siqut nani anga iska iva rha rhon sä qa dä qaku inguna nage ama gulañ na ama ruvek dä dang däm da sä qa savono säva ama vätka aa rhäng bä rha rutnävämne va ama vätka aa rhäng näkt ta anbut sä qa mane mät aa gasgaska mät ama liqi bä sä mänguräp kä gulañ bä qoki sävät ma Jisas aa saqong. ");
INSERT INTO uro_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Bä nga ma Jisas ka lu arhä qatnanakt dä qä qoar toqortäqyia, “Gua ruaqa, sa ngua qyiradeng nä gia vuirhong.” ");
INSERT INTO uro_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bä nga ama Farisiqäna rhi na ama Skraipkäna di rha nari rhoqoräkt dä rhat tu arhä snäng doqortäqyia, “Auge rhak täkt kärak i qat tamän mava nä ma Ngämuqa? Auge mamär vät a qa iva qät kyiradeng na ama ruvek arha vuirhong i qop nguna sokt ma Ngämuqa?” ");
INSERT INTO uro_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Bä nga ma Jisas ka räm i rhat tu arhä snäng doqoräkt dä qa snanbät sä rha rhoqortäqyia, “Mäniekt bä ngän du angän snäng bät tärhong däkt? ");
INSERT INTO uro_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Guaäm goe di märmärsäs mamär sä äm? Va ngu qoar toqortäqyia, ‘Sa ngua qyiradeng nä gia vuirhong’ ura va ngu qoar toqortäqyia, ‘Ngia rhair bä ngiat tet?’ ");
INSERT INTO uro_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bä nävät tom däkt diva mamär vät a ngän iva ngänät dräm i ma Ruqa aa Emga di ama rhares pät aa rhäng de vät ivät iva qät kyiradeng na ama vuirhong.” Näkt ka qoar nä qa ruqa qärak i ama ngäñäp pät a qa rhoqortäqyia, “Ngu qoar na nge i ngia rhair näkt ngi rha gi gasgaska bä ngia rhet säva vät.” ");
INSERT INTO uro_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Dä qop äkt di qa märanas da arhä saqong näkt ka rha iaqäkt kärak i mai qat namas päm ga bä qa met säva vät dap kä nänsäs sage ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Rha moe di qräk mät ta mamär näkt ta voda ama murhämeska sage ma Ngämuqa. Näkt täqäp ta na ama tlenga dä rhi qoar toqortäqyia, “Sa rhäqyerhäkt di sa ut lu ama lat kärangätni i ama nañis ngät masirhat.” ");
INSERT INTO uro_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Näkt nga nasot iangärhäkt ama lat dä vuk sä ma Jisas bä qa met bä qa lu ama ruqa qärakni i qät ta ama takes kärak i rhat tes ka i ma Livai i qat muqun ba ama vätka qärakni i ama ruvek tit boda ama takes sae. Dä ma Jisas ka qoar na qa rhoqortäqyia, “Ngit päs gua rhäng.” ");
INSERT INTO uro_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Dä ma Livai qa märanas näkt ka met daqule iarhongäkt moekt bä qa met nasot a qa. ");
INSERT INTO uro_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nasot dä ma Livai qa mualat na ama tmäski ama mor qi va aa vätka bä ama mor qi ama guläñgi na ama ruvek kärarhani i rhit ta ama takes bä sävät arhani di qale rha e gem iom bä rha moe rhat täs. ");
INSERT INTO uro_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Dap kinak ama Farisiqäna rhi na arhä Skraipkäna di rhat tamängus bä bä ma Jisas aa mudäsaqongda i rhi snanbät toqortäqyia, “Mäniekt bä ngän däs dä ngänit nakt ngän na ama ruvek kärarhani i rhit ta ama takes ti na arhani ama vu rha ama ruvek?” ");
INSERT INTO uro_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Iarhakt kärarhae i ama märäs pät a rha di qaku rhit läk nani ama ruqa qärakni i qat dräm gat tumäräspät dap sokt kärarhani i ama rämgi vät a rha di rhit läk nani ama ruqa rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Qaku ngua män ivakt iva ngua rhes iarhakt kärarhae i ama räktta na rha sagem ngo dap kinak ngua män ivakt iva ngua rhes ama ruvek kärarhani i rhat tualat na ama vuirhong iva rhi näpgoer na nas.” ");
INSERT INTO uro_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Dä rhi qoar nä ma Jisas toqortäqyia, “Ma Jon ama Baptais aa mudäsaqongda di rhat dräm dat teranot dä rhi nän bä qosaqi ama Farisiqäna arhä mudäsaqongda dap ainge gi mudäsaqongda di qop tat täs dä rhit nakt.” ");
INSERT INTO uro_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Nga mamär iva ngi qoar na ama gamoeqa qärakni iva rhit bodäm na qa aa ruavek iva rhat teranot toqoräkt i as kale qa qä na rha? ");
INSERT INTO uro_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Dap ama qäväläm as pa äm ngä rhän iva ama gamoeqa qärak iva rhit bodäm na qa diva rhi rha qa daqule rha bä vät iangärhäkt ama qunäng nasot a qa dä va rhat teranot.” ");
INSERT INTO uro_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Dä qosaqi qa qoar na rha na ama enge na ama siqutki rhoqortäqyia, “Qaku aung gat dräm gä nängyiret sa anga baulini nämäni anga iar qi anga boiqi bä qä naqutäm sä ini mät ama liqi mäni anga mru qi anga boiqi. Ngakt bä va qa rhualat toqoräkt dä va qän gyiret mät ama boiqi ama iar qi dä ani diva qaku ama ñämñämgi rhoqorne qre i qale ama baulini ama iar ini mäni ama mru qi ama boiqi. ");
INSERT INTO uro_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Dä qosaqi qaku aung gat dräm gät tor na anga iar qi anga wain sämät anga mru ngät anga ngädäng gärangätni i rhit tor na ama wain sämät ngät. Ngakt bä va qa rhualat toqoräkt dä va ama iar qi ama wain gi vukdor va ama ngädäng dä räp sa ama wain bä va mava na ama ngädäng. ");
INSERT INTO uro_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Qaku mamär iva rhoqoräkt dap koki sokt tit tor na ama iar qi ama wain sämät ama iar ngät ama ngädäng. ");
INSERT INTO uro_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Sävetka qärakni i qät näkt ama wain ama mru qi bä rhäksot dä qaku nani a qa na anga iaräs na qi anga wain inguna va qä qoar toqortäqyia, ‘Ama mru qi di ama mär mät ki mamär.’” ");
INSERT INTO uro_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Vät akni ama Sabat dä ma Jisas kat tet da ama et na ama wit dä aa mudäsaqongda rhi nasäng i rhi nänbäñ sa ama gavämirhong bä rhit tigus pa arhä rhäkt nä irhong sä irhong angät srot bä rhat täs irhong. ");
INSERT INTO uro_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Dä arhani ama Farisiqäna rhi snanbät toqortäqyia, “Mäniekt bä ngänin nänbetäkmät na ama muräkt pät ama Sabat?” ");
INSERT INTO uro_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Dä ma Jisas ka snanbät sä rha rhoqortäqyia, “As nga qaku ngän mes sävät agi aa lat kärangätni i ma Devit ka mualat na ngät kä na aa ruavek toqoräkt i anoeng mä rha? ");
INSERT INTO uro_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nak pa qunäga vät a ngän i qa mon säva ama ansäspämgi ama me qi bä qa rha ama tmäs kärangätni i rhit bodäm ngät sage ma Ngämuqa bä qa mäs ngät näkt kosaqi qa von aa ruavek ta ngät. Sokt di iangärhäkt ama tmäs di ama Muräkt ngät tamän i qaku mamär vät anga ruvek mavängam iva rhat täs nävät a ngät dap sokt ama priskäna.” ");
INSERT INTO uro_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nasot dä ma Jisas kä qoar na rha rhoqortäqyia, “Ma Ruqa aa Emga di ma Engeska bä ba ama Sabat.” ");
INSERT INTO uro_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Saqi vät akni ama Sabat dä ma Jisas ka met bä säva ama mämairqi bä qä su dap kale akni ama ruqa e qärakni i ama ñäp aa rhäqyet. ");
INSERT INTO uro_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Dap ama Farisiqäna rhi na ama Skraipkäna di rhit ñäm mamär nani guani iva rhi rhäksärhä ma Jisas nä ini dä rhi sangar a qa bä qoki sa rhat lu qa mamär iva qa rhualat na anga mumäräspät pät ama Sabat. ");
INSERT INTO uro_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Dap ma Jisas di qat dräm arhä mungäsnäng sokt di qa qoar nä qärak ka ruqa i aa rhäqyet ngä ñäp doqortäqyia, “Ngia rhäranas bä ngia rhair da ama ruvek moe arhä saqong.” Dä soknga qärak ka märanas bä qat mair da arhä saqong. ");
INSERT INTO uro_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Dä ma Jisas ka snanbät sä rha rhoqortäqyia, “Guani qoe di ama Muräkt ngärhit tares pät ini angärha rhäng bät ama Sabat? Va ut tualat na ama lat ama mär ngät ura va ut tualat na ama vuirhong? Dä qosaqi va ut tumaiar na ama ruqa aa iar ura va urhi slava na ngät bä qäbäs na ngät?” ");
INSERT INTO uro_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Näkt soknga qa ñäm namet a nas sävät a rha moe näkt kä qoar nä qärak ka ruqa rhoqortäqyia, “Ngia rhurän dä ngia rhäqyet tämono.” Dä qa mualat toqoräkt bä märäs pät aa rhäqyet mamär. ");
INSERT INTO uro_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Dap kä Farisiqäna rhi na ama Skraipkäna di uraqi dä arha ron mamär dä soknga rhi veng ne iva sa rha mäsana nä ma Jisas. ");
INSERT INTO uro_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Maos pät akni ama qunäga imäk äkt dä ma Jisas ka met sämäni ama damgi ivakt iva qä nän bä aa bängagi ama rhäk täm gi di qä nän sage ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bä nga vät duququs toqoräkt dä qa mes aa mudäsaqongda moe qärarhani i qale rha gem ga mäni ama damgi sagem mes bä qa armeng da ama ngärhäqyisem da udiom na rha näkt ka mes ta iva ama ngangda na rha sä ma Ngämuqa aa lat i ");
INSERT INTO uro_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ma Saimon gärak i qa von ga rha ama ngärhipki ama iar qi i ma Pita näkt ma Andru qärak i ain nanäk ama sägäkt näkt ma Jems näkt ma Jon näkt ma Filip näkt ma Bartolomyu ");
INSERT INTO uro_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","näkt ma Matyu näkt ma Tomas näkt ma Jems ma Alfius aa emga näkt ma Saimon gärak i rhat tes ka i ama Selot ");
INSERT INTO uro_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","näkt ma Judas ma Jems aa emga näkt sävät ma Judas Iskariot kärak iva sae dä va qä vodä ma Jisas säva aa ikkäna arhä rhäkt. ");
INSERT INTO uro_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Dä ar sä qa qä na rha bä rhat mair vät ama räkt äs ama ivärhäs. Bä iaqyäkt ama guläñgi ama mor qi na aa mudäsaqongda di qale rha e näkt sävät ama ruvek masirhat nae ma Judia moe bä nae ma Jerusalem bä arhani nävät a qoan glaqot na ama värham ma Tair dä ma Saidon. ");
INSERT INTO uro_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Di iarhakt ta män ivakt iva rhi nari ma Jisas dä va qa rhumäräs pät a rha nämät arha räm. Bä qärarhani ama ruvek i ama iaus ngärhit bon da rha ama märänga ama mor qa di märäs pät a rha. ");
INSERT INTO uro_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bä ama ruvek moe rhi siqut iva rhit täk pät a qa inguna ama mumäräspät angät krot di ngät dän nävät a qa bä nga rhit täk pät a qa dä märäsmäräs pät a rha moe. ");
INSERT INTO uro_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Dä qa ñäm sävät aa mudäsaqongda dä qä qoar na rha rhoqortäqyia, “Ma Ngämuqa di sa aa modämne nga e gem ngän gärarhae i ngänit läk inguna va bä ba ngän nä ma Ngämuqa aa Muräktpäm. ");
INSERT INTO uro_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Ma Ngämuqa di sa aa modämne nga e gem ngän gärarhae i anoeng mä ngän däkt inguna va ma Ngämuqa qä rhäqäp ngän bä va mamär na ngän. “Ma Ngämuqa di sa aa modämne nga e gem ngän gärarhae i airäs ngän däkt inguna va nasot dä va ngäni qok dä va ngänit tama. ");
INSERT INTO uro_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ma Ngämuqa di sa aa modämne nga e gem ngän gre i ama vu da ama ruvek arha ron masirhat sävät a ngän dä rhat tetdäm särhäm ngän dä rhat tamän mava na ngän bä rhi slava na angän ngärhep inguna ngänit päs gua rhäng aingo ma Ruqa aa Emga. ");
INSERT INTO uro_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mamär iva ngäni qok kre i rhat tualat toqoräkt sä ngän bä ngänit don na nas na ama märmärgem inguna angän ditsek di ama mor ngät da ama usäpki arha ron. Inguna sa mudu arhä mamäkkäna rha mualat toqoräkt sä ma Ngämuqa aa vämginarha. ");
INSERT INTO uro_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Dap pa avuqi na ngän gärarhae i ama qärhong bät a ngän i sa nguna ngän da angän ditsek. ");
INSERT INTO uro_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Dap ama iräski sagem ngän gärarhae i angän sarem mamär täkt inguna as pa anoeng mä ngän. “Dap kosaqi ama iräski sagem ngän gärarhae i rhäqäp ngän na ama märmärgem bä ngänit tama rhäkt inguna va as nasot dä va airäs ngän bä va ngänit nok. ");
INSERT INTO uro_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Dap kosaqi ama iräski sagem ngän gärarhae i ama ruvek tit kutdrir sagem ngän dä arha enge di ama mär ngät sävät a ngän i sa nguna mudu arhä mamäkkäna rha mualat toqoräkt sa ama vämginarha ama iraski na rha. ");
INSERT INTO uro_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Dap nguat tamän särhäm ngän däkt kärarhae i ngänät nari ngo i mamär iva angän snäng bät angäna ikkäna dä va ngän dualat na ama lat ama mär ngät sävät iarhakt kärarhae i ama vu da arha ron masirhat sävät a ngän. ");
INSERT INTO uro_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Dä ngäni nän dä ma Ngämuqa aa bulap bä bä iarhakt kärarhae i rhit täkngong däm ngän dä va ngäni nän sävät kärarhani i rhi slava na ngän. ");
INSERT INTO uro_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ngakt bä aung gä e säng gia qeng dage dä qosaqi ngi rhong na age sävät a qa. Ngakt bä nga aung gä rha aung nävät a ngän aa boiqi ama uiu qi dä va qale ngi nanen däm gi dap kosaqi va ngi von ga rha aa srapki. ");
INSERT INTO uro_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mamär iva ngänit bon iarhakt kärarhae i rhi nän ngän dap ngakt bä nga aung gä rha gi nga guani dä va qale ngän nanän däm ini nagem ga. ");
INSERT INTO uro_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Iangärhäkt ama lat kärangät i nani a ngän iva arhani ama ruvek tat tualat na ngät sävät a ngän di qosaqi mamär iva ngän dualat toqoräkt sävät a rha. ");
INSERT INTO uro_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ngakt bä nga sokt angäna snäng bät iarhakt kärarhae i arha snäng bät a ngän diva sirhäkt ama märini gem ngän doqor mäniekt? Nak kärarhani i ama vu rha di qäqi arha snäng bät kärarhani ama ruvek i arha snäng bät a rha. ");
INSERT INTO uro_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ngakt bä nga sokt ngän dualat mamär sä qärarhani i rhat tualat mamär sä ngän di nga ama mär toqoräkt ura qaku? Nak kärarhani i ama vu rha di qäqi rhat tualat toqoräkt. ");
INSERT INTO uro_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Näkt ngakt bä nga sokt ngänit bon bä bä qärarhani i nani a ngän na ama muvätki nagem da di nga ama mär toqoräkt ura qaku? Nak ama vurha di qäqi rhit bon bä ba ama vurha näkt tat nanakt iva ama muvätki bä ba rha diva ama rhäk täm gi. ");
INSERT INTO uro_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Dap mamär iva angäna snäng bät angäna ikkäna dä va ngän dualat na ama lat ama mär ngät sävät a rha dä ngänit boda nagem mes näkt kale ngän natmu angän snäng iva ngäni rha anga muvätki nagem da. Bä nga ngän dualat toqoräkt dä mamär iva angän ditsek diva ama mor ngät bä ama ruvek diva rhat lu ngän i ma Moräsnaqa Na Rhävuk aa es na ngän inguna qät lavuqi nä iarhakt kärarhae i qaku rhat dräm dat tes ama mär näkt sävät ama vurha. ");
INSERT INTO uro_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mamär iva ngänät dräm iva ngänit lavuqi rhoqor ma Ngämuqa i qat dräm gät lavuqi. ");
INSERT INTO uro_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Qale ngän datnävämne na arhani arha lat dä va qaku ma Ngämuqa qä namatnävämne na angäna lat. Qale ngänit täksärha arhani dä ngäni sangäm na rha dä va qaku ma Ngämuqa qä narhäksärhäm ngän dä qä nasangäm na ngän. Ngänit kyiradeng na arhani sa arha lat dä va ma Ngämuqa qät kyiradeng ba ngän. ");
INSERT INTO uro_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ngänit bon nagem mes toqor mäniekt diva qosaqi ma Ngämuqa qä von ngän doqoräkt. Ma Ngämuqa diva qä von da ama mär qa ama siqutka iaqäkt kärak i sa rhit tares sävät a ne mane näkt tit kutnesäs bä va qoki rhäqäp mamär bä vritprit dä va vritprit namet a ngän. Iaqäkt ama siqutka qärak i ngän du qa sävät arhani diva qosaqi ma Ngämuqa qa rhu qa sävät a ngän.” ");
INSERT INTO uro_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Dä qosaqi ma Jisas ka qoar na rha na ama enge na ama siqutki rhoqortäqyia, “Var mamär iva anga säsurqa qä rhoer nanokt anga säsurqa? Nga va qaku in moe in namon mät anga uqupka? ");
INSERT INTO uro_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Anga mudäsaqongga di qaku qa vit pa aa morqa aa uväs dap sävetka qärakni i qa rha ama rhisu mamär nage aa morqa diva qa rhän doqor qa.” ");
INSERT INTO uro_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Mäniekt bä ngi saengäkt sävät ama qlanängini mät gia ruaqa aa saqongaqa dap mavängam bät a nge sa ama ngämunget mät gi saqongaqa maräkt? ");
INSERT INTO uro_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ngu lu mäniekt bä mamär iva ngi qoar nä gia ruaqa rhoqortäqyia, ‘Gua ruaqa, va ngu qumär sa ama qlanängini nämät gi saqongaqa’ dap kre i nge di qaku mamär iva ngi lu ama ngämunget mät gi saqongaqa maräkt. Ainge qärak i ngiat tualat sädä saqong, as pa ngi er ngi rha ama ngämunget nae nämät gi saqongaqa maräkt dä nasot dä va mamär vät a nge iva ngiat nañäm mamär ivakt iva ngi rha ama qlanängini nämät gia ruaqa aa saqongaqa.” ");
INSERT INTO uro_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Anga ngämuga anga mär qa di qaku qät sa anga gavam anga vu ngät bä qosaqi anga ngämuga anga vu qa di qaku qät sa anga gavam anga mär ngät. ");
INSERT INTO uro_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Va ngäni lu ñismäne na ama ngämung di nävät angät gavam. Inguna ama ruvek di qaku rhit ta ama gosaqi at gavam nävät ama ritgung. Bä qosaqi qaku rhi nänbäñ sa ama wain angät gavam nävät ama gurhäk. ");
INSERT INTO uro_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ama mär qa ama ruqa nävät iarhongäkt ama märirhong da aa ron di sa qat tualat na ama mär ngät ama lat dap ama vu qa ama ruqa nävät iarhongäkt ama vuirhong da aa ron di sa qat tualat na ama vu ngät ama lat. Inguna sävetka aa vämgi di sa qiat tamän nävät agini qärqäni i rhäqäp aa snängaqa nä ini.” ");
INSERT INTO uro_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Mäniekt bä ngän des ngo rhoqortäqyia, ‘Gua Engeska, gua Engeska’ sokt di qaku ngän dualat parhäm gua enge? ");
INSERT INTO uro_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ama ruqa qärakni i qat dän gem ngo bä qat nari gua enge näkt kat tualat parhäm ngät diva ngu qur a ngän i ");
INSERT INTO uro_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","qa di qa rhoqor mäniekt. Qa di qa rhoqor ama ruqa qärakni i qät täk pät ama vätka i qa nges bä saimäk näkt ka mu ama vätka aa ribit i ama qrot it pät ama sinäpki arha rhäng. Näkt nga ama iqumga qa män bä ama qärhop ngä qut ka vätka dä qop kaku ngä rhästäs a qa inguna qa rhäk mämägän sä qa. ");
INSERT INTO uro_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Dap iaqäkt kärak i qat nari gua enge näkt kaku qat tualat parhäm ngät di qa rhoqor ama ruqa qärakni i qa rhäk pät aa vätka vät ivät näkt kaku qa sämaqrot na aa ribit. Näkt pät ama qäväläm gärqomni i ama qärhop ngä qut iaqäkt ama vätka dä arpus na qa mäk bä sa mava na qa mas.” ");
INSERT INTO uro_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Bä nga ma Jisas kä sameng bät ama ruvek kärarhani i rhat nari qa bä rhäksot dä qa met bä qa mon sae ma Kaperneam. ");
INSERT INTO uro_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Dap e di qale akni ama narhoerqa bä ba ama handret na rha ama ulaqimärharhärhäkt kärakni i aa latka di sa märmär gem ga na qa masirhat sokt di aräm ga bä qorhäs iva qä ñäp. ");
INSERT INTO uro_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Dä qä narhoerqa qa nari sävät ma Jisas dä qa rhäk na ama Judaqäna arha morta ivakt iva rhi nän ga iva qa rhän bä qa rhumäräs pät aa latka. ");
INSERT INTO uro_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bä nga rha män ge ma Jisas dä rhat naing bät a qa masirhat toqortäqyia, “Qoki va ama mär masirhat kre i ngia rhualat toqor täkt bä ba qa ");
INSERT INTO uro_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","inguna qa di aa snäng bät aurha ruvek ama Judaqäna dä qa mair na ut mämairqi.” ");
INSERT INTO uro_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dä soknga ma Jisas ka met kä na rha. Bä nga rhat tet bä sa glaqot nä qä narhoerqa aa vätka dä qa rhäk na aa ruavek ivakt iva rhi qoar nä ma Jisas toqortäqyia, “Gua morqa, qale ngiat turuan bät a nas inguna aingo di qaku ama märqa na ngo iva ngia rhon säp gua vätka. ");
INSERT INTO uro_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Bä ma ngo i qaku ngua met sagem nge dinguna nguat lu nas i qaku ama märqa na ngo. Dap pa sokt ngia rhamän iva märäs pät gua latka dä va märäs pät a qa. ");
INSERT INTO uro_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Inguna qosaqi ngo di ama ruqa qärakni i qale ngo va ama narhoerta arhä muräkt angärha rem dap ama ulaqimärharhärhäkt di qale rha vä gua rem. Bä nga ngu qoar nä rhaerhak toqortäqyia, ‘Ngia rhet’ dä qat tet. Dap nga ngu qoar nä rhaerhak toqortäqyia, ‘Ngi ang’ dä qat tet inamuk. Dap nga ngu qoar nä gua latka rhoqortäqyia, ‘Ngia rhualat toqortäqyia e rhäkt’ dä qat tualat toqoräkt.” ");
INSERT INTO uro_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Bä nga ma Jisas ka nari rhoqoräkt dä qräk mät ka nävät kärak dä qa rhong sävät ama gulañ na ama ruvek kärarhani i rhat tet nasot a qa dä qä qoar na rha rhoqortäqyia, “Nguat tamän särhäm ngän i qop as kaku ngua män bät anga qatnanakt anga mor ngät toqor täkt bä qäqi qaku gem ngän ama Israelqäna.” ");
INSERT INTO uro_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Näkt sa evär dä qa ruvek kärarhae i mai qre qä narhoerqa qa rhäk na rha bä säva ama vätka dä rha män bät ka latka i sa märäs pät a qa. ");
INSERT INTO uro_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bä nga nasot dä ma Jisas ka met bä sämät ama värhäm gärqom i rhat tes äm i ma Nain näkt aa mudäsaqongda rhi na ama mor qi ama guläñgi na ama ruvek di rhi na qa. ");
INSERT INTO uro_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bä nga qat tet bä sämät ama värhäm angärha tmongi dä vukpuk sa ama ruvek sa ama ñäp ka ama ruqa. Näkt ama ñäpka aa nanäk di ama maqoski na qi näkt at toemga iaqäkt di sokt ka ama sägäk. Näkt ama mor qi ama guläñgi na ama ruvek nämät iomäkt ama värhäm di rhi na qi. ");
INSERT INTO uro_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bä nga ma Engeska qa lu qi dä qa lavuqi na qi masirhat dä qä qoar na qi rhoqortäqyia, “Qale ngit nok.” ");
INSERT INTO uro_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Näkt ka met pävit bä qa rhäk pät ama ñäpka aa gasgaska dä iarhakt kärarhae i rhit ta iaqäkt ama gasgaska di rha mair bä mänadin bät a rha. Dä qä qoar toqortäqyia, “Qarhoemga, ngu qoar na nge rhoqortäqyia, ngia rhäranas.” ");
INSERT INTO uro_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Näkt sa qa ñäpka qa märanas bä qat muqun bä qä nasäng i qat tamän dä ma Jisas ka mu qa ge aa nanäk. ");
INSERT INTO uro_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Qärarhani moe di rhäqäp ta na ama tlenga dä rha an sä ma Ngämuqa. Dä rhi qoar toqortäqyia, “Ma Ngämuqa aa vämginaqa ama moräs na qa sa qa män mänguräp mä ut. Ma Ngämuqa sa qa män ivakt iva qa rhatnärha aa ruvek.” ");
INSERT INTO uro_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Bä rhangät täkt ama sameng sävät ma Jisas di vräs däm ngät e ma Judia moe bä särhage särhage nä iaqäkt ama ngärhäktka. ");
INSERT INTO uro_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ma Jon aa mudäsaqongda rha sameng ba qa sävät iangärhäkt ama lat moe qärangätni i sa ngä märanas. Dä qa mes ama udiom nävät a rha ");
INSERT INTO uro_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","näkt ka rhäk na iom sage ma Engeska ivakt iva ini snanbät sä qa rhoqortäqyia, “Nga qärak na nge iva qa rhän ura va qoki as ut nañäm nani akni?” ");
INSERT INTO uro_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bä nga qärqiom in met bä sage ma Jisas dä ini qoaräs na qa rhoqortäqyia, “Ma Jon ama Baptais ka rhäk na un sagem nge ivakt iva uni snanbät sä nge rhoqortäqyia, ‘Nga qärak na nge iva qa rhän ura va qoki as ut nañäm nani aung?’” ");
INSERT INTO uro_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Dap pät iomäkt ama qäväläm di ma Jisas ka mumäräs pät ama rhäqäp na rha nämät ama räm maos maos dä qa qutmäs ama iaus nämät arhani dä qa mumäräs pät ama rhäqäp na rha ama säsurta bä rhat nañäm. ");
INSERT INTO uro_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Dä sa qa muvät pät ma Jon aa mudäsaqongiom doqortäqyia, “In det bä ini qoaräs nä ma Jon sävät ama lat kärangätni i in lu ngät te dä agi enge qärangätni i in nari ngät. Rhoqoräkt i ama säsurta di sa rhat nañäm dap ama vävarhämda di sa rhat tet dap iarhakt kärarhae i ama bias pät a rha di sa märäs pät a rha dap ama dängbärharha di sa rhat nari dap ama ñäpta di sa rhat täranas bä ama iar ta. Dä ama sameng ama mär ngät di ngu sameng na ngät bä ba ama tläkta. ");
INSERT INTO uro_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Näkt mamär iva märmär ge iaqäkt kärak i nga ama ruvek ti slava na qa inguna nävät a ngo dä qaku qa qut säda aa ron.” ");
INSERT INTO uro_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nasot i ma Jon aa mudäsaqongiom in met dä ma Jisas ka nasäng i qat tamän sävät kä guläñgi sävät ma Jon dä qä qoar toqortäqyia, “Ngän met sävät ama qräk dä bäs ama ivärhäs ivakt iva ngäni lu agiqa? Nguaräm ngän met sae ivakt iva ngäni lu ama eqokt ka ama ruqa qärakni i qät lir qät kutsasorhane varhäm ama ruvek arhä snängaqa? ");
INSERT INTO uro_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ngakt bä qaku rhoqoräkt dä ngu lu sa ngän met ivakt iva ngäni lu agi anga ruqa? Nak nga va ngäni lu ama ruqa qärakni i qat don mät ama boi ama mär ngät? Qaku, inguna iarhakt kärarhae i rhat don mät ama boi ama mär ngät bä qale rha i amämägän sä rha di sa qale rha va ama vitnarha arha vät. ");
INSERT INTO uro_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ngakt bä qaku rhoqoräkt dä ngu lu sa ngän met ivakt iva ngäni lu agi anga ruqa? Nguaräm ba ngäni lu akni ma Ngämuqa aa vämginaqa? Ari, sokt di ngu qoar na ngän i iaqäkt di qa vit pät arhani ama vämginarha arhä väs. ");
INSERT INTO uro_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Rhak täkt ama ruqa di iaqäkt kärak i sa rha säm sävät a qa vä ma Ngämuqa aa enge rhoqortäqyia, “As ngäni lu i ngut täk nä gua engevärhaqa vä gi qamäs ivakt iva qä rhäkmu nä gia iska nanokt nge.” ");
INSERT INTO uro_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ngu qoar na ngän na ama engäktki i nävät ama ruvek moe di sa qaku aung gärakni i qa vit pä ma Jon aa uväs dap iaqäkt kärak i ama gaini na qa mamär vä ma Ngämuqa aa Muräktpäm di ama moräs na qa masirhat daver ma Jon. ");
INSERT INTO uro_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bä nga ama ruvek moe bä qäqi sävät kärarhani i rhit ta ama takes di nga rha nari ma Jisas aa enge dä rhat tamän i nak ma Ngämuqa aa lat di ama räkt ngät i sa nguna rha rha ama baptais nage ma Jon. ");
INSERT INTO uro_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Dap ama Farisiqäna rhi nä iarhakt kärarhae i ama mädräm da mamär sa ama Muräkt di rha mer ma Ngämuqa aa snängaqa bä ba rha inguna rha mer ti narha ama baptais nage ma Jon. ");
INSERT INTO uro_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Dä ma Jisas kä qoar toqortäqyia, “Ngu lu va ngua rhuqut ta agiqa sävät ama ruvek nävät tit täkt ama qoengait? Ngu lu rha rhoqor agiqa? ");
INSERT INTO uro_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Rha di rha rhoqor ama rhoes kärarhani i rhat muqun ba ama ivärhäs kärqosni i rhit boda ama tmäs e bä arhani rhit näs sävät arha ruavek toqortäqyia, “‘Urhit kut ama irin dap ngän di qaku ngän dain dä urhit tong ama mabu na ama iräski dap ngän di qaku ngänit nok.’ ");
INSERT INTO uro_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nguat tamän doqor täkt inguna ma Jon ga män di qaku qat täs ama bret dä qaku qät näkt ama wain dap ngäni qoar toqortäqyia, ‘Qa di ama iauska qa e mät ka.’ ");
INSERT INTO uro_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Dap ma Ruqa aa Emga qa män i qat täs dä qät nakt dä ngäni qoar i, ‘Ngäni lu qa. Ama qatmäska dä ama tnaktka na qa bä aa ruavek di iarhakt kärarhae i rhit ta ama takes bä sävät ama vurha!’ ");
INSERT INTO uro_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sokt di ama ruvek arha lat kärangätni i rhat tualat na ngät nävät ama mädräm ama mär ngät nage ma Ngämuqa di ngät ngärhi qoar i aa mädräm ama mär ngät di ama räkt ka.” ");
INSERT INTO uro_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nasot toqoräkt dä akni nävät ama Farisiqäna di qa rhäknan dä ma Jisas iva qä na qa in däs ama tmäs dä soknga qa met bä säva aa vätka bä qale qa vät ama laiqa aa rhäkt ivakt iva qat täs. ");
INSERT INTO uro_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Dap aktni ama vu qi ama evopki nämät iomäkt ama värhäm di nga qia nari sävät ma Jisas i qat täs nävät ama Farisiqa aa laiqa va aa vätka dä sa qia män sage ma Jisas sa ama kainaqi qäraktni i sa rha mualat na qi na ama duiqa ama saksak päm ga. Iaqyäkt ama kainaqi di rhäqäp ki na ama oel qäraktni i ama mär at tamaska. ");
INSERT INTO uro_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Näkt nga qiat mair säng aa rhäng dä qia nasäng i qit nok bä qyiqyikt pät ma Jisas aa qäriglem na at koep. Dä qia angär bä qia suqup pät iglem na at käseng näkt kia qärhäktgyäm iglem näkt kia vrit na ama oel ama mär at tamaska vät iglem. ");
INSERT INTO uro_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Bä nga qärak kä Farisiqa i mai qre qa rhäknan dä ma Jisas di nga qa lu rhoqoräkt dä qa mu aa snäng doqortäqyia, “Vadi mai iaqäkt ama ruqa di nak ma Ngämuqa aa vämginaqa di mai mamär iva qat dräm i agukt koe iaqyäkt käraktni i qit täk pät a qa bä qi di qi rhoqor mäniekt nak nguna qi di ama vu qi ama ruqi.” ");
INSERT INTO uro_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Dä ma Jisas ka qoar na qa rhoqortäqyia, “Saimon, ani rhärhäni va ngua rhamän särhäm nge nä ini.” Dä ma Saimon ga qoar na qa rhoqortäqyia, “Qamorqa, dä a nge ngi qoar na ngo.” ");
INSERT INTO uro_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Dä ma Jisas kä qoar na qa rhoqortäqyia, “Ama ruiom di sa in nän da ama ligär nage ama ruqa qärakni i aa lat diva qät boda ama ligär bä ama ruvek kärarhani i rhi nän ga iva nasot dä rhat dräm dat tuvät. Akni qa nän da ama ngärhäqyet ama handret na ama qunäng angät titsek dap akni sa ama ruiom ama udiom da ama ngärhäqyisem na ama qunäng angät titsek. ");
INSERT INTO uro_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Näkt in moe di qaku ina anga ligär ivakt iva saqi sa in duvät dä soknga iaqäkt kärak i qät lu vät iangärhäkt ama lat di qa anmae vät a iom iva qaku in namuvät na ngät. Bä nga rhoqoräkt dä va auge nävät a iom diva aa snäng bät a qa masirhat?” ");
INSERT INTO uro_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Dä ma Saimon ga muvät toqortäqyia, “Nguat tu gu snäng i iaqäkt kärak i qa nän da ama ligär masirhat näkt ta veng ngät nävät a qa.” Dä ma Jisas kä qoar nä qa rhoqortäqyia, “Ngia matnävämne maräkt toqoräkt.” ");
INSERT INTO uro_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Näkt ka rhong sävät ka evopki dä qä qoar nä ma Saimon doqortäqyia, “Nga ngiat lu rhakt ama evopki? Ngua mon säp gia vätka näkt kaku ngia von ngo rha anga rigi iva rhi rhor gua qäriglem. Dap sa qyikt pät gua qäriglem nage at koep näkt kia suqup pät iglem na at käseng. ");
INSERT INTO uro_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Dä qaku ngia ar sä ngo i ngia qärhäktgyäm ngo dap takt täkt ama ruqi di mänasäng mai qre ngua mon bä sarhe dä qaku mae vät a qi i qit kärhäkt dä gua qäriglem. ");
INSERT INTO uro_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Dä qaku ngia rhor na anga oel vät ngua väski dap ki di sa qia vrit na ama oel ama mär at tamaska sävät gua qäriglem. ");
INSERT INTO uro_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Da soknga va ngu qoar na nge i arha vuirhong di ngua qyiradeng nä irhong inguna at snäng bät a ngo masirhat. Dap iaqäkt kärak i sa ma Ngämuqa qät kyiradeng ba qa maqälak di aa snäng bät a qa maqälak.” ");
INSERT INTO uro_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dä ma Jisas ka märhamän särhä qärakt toqortäqyia, “Ngua qyiradeng nä gia vuirhong.” ");
INSERT INTO uro_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Dä arhani ama ruvek pä iaqyäkt ama tmäski di rhi nasäng i rhat tamän sä mänguräp mä ne rhoqortäqyia, “Auge rhak täkt iva qäqi qät kyiradeng na ama ruvek sa arha vuirhong?” ");
INSERT INTO uro_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Dä ma Jisas ka märhamän särhä qa ruqi rhoqortäqyia, “Gi qatnanakt di sa ngä mumaiar na nge. Ngia rhet sa ama isiska.” ");
INSERT INTO uro_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nasot dä ma Jisas ka met mät ama värhap ama mor ap dä ama lel ap bä qä sameng na ama sameng ama mär ngät sävät ma Ngämuqa aa Muräktpäm. Dä ama mudäsaqongda ama ngärhäqyisem da udiom na rha di rhi na qa ");
INSERT INTO uro_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","näkt sävät arhani ama evop kärarhani i qa qutmäs ama iaus nämät ta dä qa mumäräs pät a rha nämät ama räm. Aktni nävät a rha di ma Maria qärakt i rhat tes ki i ama ruqi nämät ama värhäm ma Makdala qärakt i sa qa qutmäs ama ngärhäqyet da udiom na ama iaus bä vuk sä ngät nämät ki. ");
INSERT INTO uro_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Bä qosaqi qale ma Joana ma Kusa aa egutki e näkt ma Kusa di ma Herot aa lat angät narhoerqa bä qosaqi ma Susana näkt sävät arhani ama rhäqäp na rha. Rhärha rhäkt ama evop di rhat tatnärhä ma Jisas kä na aa mudäsaqongda na arhä ligär qärangätni i nga e gem da. ");
INSERT INTO uro_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bä nga ama mor qi ama guläñgi na ama ruvek di väspästämne na rha sage ma Jisas dap kosaqi ama ruvek tat dän nämät ama värhap ama mor ap i aomni näkt saqi sa aomni dä ma Jisas ka märhamän bät tangät täkt ama enge na ama siqutki rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Maos dä akni ama latka qärakni i qät don na ama gavämirhong ga met säva ama etki ivakt iva qä qutnanokt pät a qi. Bä nga qät don na ama gavämirhong bät ama etki dä arhongni ama gavämirhong ngä säp sä varhäm ama iska dä ama ruvek ta naengmät nä irhong dä ama isäm nämät ama leqäs ngä mäs irhong. ");
INSERT INTO uro_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Dap arhongni ngä säp sävät ama ivätki qäraktni i ama dui väm gi bä nga vur mät irhong dä nät däm irhong inguna qaku anga rigi masirhat pa ama ivätki. ");
INSERT INTO uro_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dap arhongni ama gavämirhong ngä säp sä mänguräp ama ritgung bä ngä moe ngä ir sä ne bä ama ritgung ngä ong ama gavämirhong bä ngä slava nä irhong angärha irhirqi. ");
INSERT INTO uro_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Dap arhongni ngä säp sävät ama ivätki ama mär qi. Bä irhong ngä ir bä irhong ngä sa. Näkt asägäni asägäni ini ngä sa ama sägäk ama handret na ama gavämirhong.” Bä nga qat tamän bä rhäksot dä qa märhamän dävuk toqortäqyia, “Iaqäkt kärak i nani a qa iva qunäga vät a qa sä gua enge di mamär iva qat nari mamär.” ");
INSERT INTO uro_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Bä nga aa mudäsaqongda rha snanbät sä qa iva qä qoar na rha na ama enge na ama siqutki at tarimini ");
INSERT INTO uro_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","dä qa qoar na rha rhoqortäqyia, “Sa ma Ngämuqa qät bon ngän da ama mädräm ivakt iva ngänät dräm sävät aa Muräktpäm dap nguat tamän bät ama enge na ama siqut sage arhani ivakt iva ‘näma dä äkt bä rhat nañäm sokt diva qaku rhi nalu guani bä näma dä äkt bä rhat nari sokt diva qaku mamär iva qunäga vät a rha.’ ");
INSERT INTO uro_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ama enge na ama siqutki at tarimini di rhoqortäqyia, ama gavämirhong di ma Ngämuqa aa enge. ");
INSERT INTO uro_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ama gavämirhong barhäm ama iska di ama siqutki sävät ama ruvek kärarhani i rhat nari näkt ma Sämga qat dän bä qät ta ama enge näda arha ron ivakt iva qaku rhi natnanakt na ngät dä va qaku rhi narha ama mumaiar. ");
INSERT INTO uro_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Dap iarhongäkt kärqärhong bät ama ivätki ama dui väm gi di ama siqutki sävät ama ruvek kärarhani i rhit ta ama enge na ama märmärgem doqoräkt i rhat nari ngät sokt di qaku angät snagut ngät don säda arha ron mamär. Bä rhat nanakt di nak kop sokt pät ama qäväläm ama qot äm näkt nga ama märänga nage ama siqutsiqut kat dän bät a rha dä mämae da arhä qatnanakt. ");
INSERT INTO uro_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Ama gavämirhong gärqärhongni i irhong ngä säp sä mänguräp ama ritgung di ama siqutki sävät ama ruvek kärarhani i rhat nari sokt di nga rhat tet parhäm arha tmerhäs dä ama qänäskänes dä ama märmärgem näkt ama mämägän nämäni ama ivätki di ngärhi slava na rha dä soknga qaku sräpsräp ta mäni arhä qatnanakt. ");
INSERT INTO uro_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Dap ama gavämirhong bät ama ivätki ama mär qi di ama siqutki sävät ama ruvek kärarhani i sa ama räkt ka dä ama mär qa ama snängaqa di rhat nari ama enge näkt tit sangar säväm na ngät ma ama qrot. Dä qale rha ma ama qrot sa ama bulap bä äkt i rhit sa ama gavam bät kärangätni arha iar.” ");
INSERT INTO uro_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Qaku aung gä namudäm säda anga lirhäga näkt kä ngaip ka va anga uratki arha rem ura qa rhu qa va anga laiqa aa rem. Dap kinak kä rhäkt a qa rhävuk ivakt iva nga iarhakt kärarhae i rhat don säva vät diva rhat lu ama neraqa. ");
INSERT INTO uro_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Inguna qaku guani qärqäni i ama ngaip ini diva qaku rhi namuqunäga sä ini dä qaku guani qärqäni i ini nga e väm diva qaku vuk sä ini säda eraqi. ");
INSERT INTO uro_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Dä soknga mamär iva ngänät nari mamär ivakt iva qunäga vät a ngän sa ama enge inguna aung gärakni i sa aa anga guani diva rhi von ga rha arhongni savono sae dap aung gärakni i sa qaku aa anga guani diva qäqi rhi rha iarhongäkt nagem ga qärqärhong i qat tu aa snäng i irhong nga e gem ga.” ");
INSERT INTO uro_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Dä ma Jisas aa nanäk näkt sävät aa läktpek di rha män ivakt iva rhi lu qa sokt di qaku mamär iva rhi namet sa glaqot na qa inguna nage ama guläñgi na ama ruvek. ");
INSERT INTO uro_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Dä akni qa qoar na qa rhoqortäqyia, “Gi nanäk näkt sävät gia läktpek di iarha namäk tat mair dalek i nani a rha iva rhi lu nge.” ");
INSERT INTO uro_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Dä ma Jisas ka muvät toqortäqyia, “Gu nan bä gua läktpek di iarhakt kärarhae i rhat nari ma Ngämuqa aa enge näkt tat tet nasot a ngät.” ");
INSERT INTO uro_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Vät akni ama qunäga dä ma Jisas ka rhon na nas sämät ama mlauski qä na aa mudäsaqongda dä qa qoar na rha rhoqortäqyia, “U rhet samit särhage na ama namuqa.” Dä rha met mämono. ");
INSERT INTO uro_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bä nga rhi ngang bät kä namuqa rhoqoräkt dä ma Jisas di qa mänatäm. Dä but sa ama lauräm ama qrot äm mäk masägos pät ama namuqa aa rhäng bä ama mlauski di rhäqäptäqäp ki na ama rigi bä qale rha da ama tñäpki arha ron. ");
INSERT INTO uro_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Dä ama mudäsaqongda rha met bä rha rhäqäm a qa dä rhi qoar na qa rhoqortäqyia, “Ura, Qamorqa! Va u rhon bä va urhi ñäp!” Dä qa märanas bä qa anmae da ama lauräm dä ama vaeng na ama enge ama qrot ngät dä soknga qäp dä qä lauräm dap mänadin bät ama qoeväs. ");
INSERT INTO uro_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Dä ma Jisas ka snanbät sa aa mudäsaqongda rhoqortäqyia, “Angän gatnanakt ngä qoe nai?” Rhäqäptäqäp ta bä rhit len dä rhi snanbät sagem ne rhoqortäqyia, “Nak sa auge rhak täkt kärak i qät bon da ama rhäkne qäqi särha ama laur dä ama rigi dä ngät nari nämät ka?” ");
INSERT INTO uro_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Dä rha met mät ama mlauski bä särhage na ama namuqa bä sävät ama Gerasaqäna arha ivärhäs kärqosni i äs nga e rhämone nä na Galili. ");
INSERT INTO uro_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Bä nga ma Jisas ka rhon na nas samit sävät a qoan dä akni ama ruqa qärakni i ama iaus nga e mät ka qa met inamuk sagem ga. Iaqäkt ama ruqa di qa nämät iomäkt ama värhäm ama mor äm näkt ka di mudu qaku qat dräm ga is nas bä ama vlavel a qa dä qaku qat tas pa anga vätka dap kat tas mät ama ñäpta arha lek. ");
INSERT INTO uro_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Bä nga qa lu ma Jisas dä qa muqaia näkt arpus na qa mäk säng ma Jisas aa qar bä qät nästäm dävuk toqortäqyia, “Nani a nge iva ngia mäsana na ngo, ainge Jisas ma Moräsnaqa Na Rhävuk aa emga? Ngut nok pät a nge iva qale ngi nasangäm na ngo.” ");
INSERT INTO uro_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Qat tamän doqoräkt di sa nguna ma Jisas ka märhamän ma ama qrot iva vuk sa ama iauska nämät ka. Ma ama rhäqäp nä imek dä ama iauska qä rhartäm sä qa bä näma dä rhit kop mät aa qar dä aa rhäkt na ama sengäna bä qale qa va ama tpäskiarharhäng sokt di qä nänbäñmät na ngät näkt ama iauska qä ngang sä qa bä sävät ama ivärhimek kärqämekni i qaku anga ruvek pät imek. ");
INSERT INTO uro_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ma Jisas ka snanbät sä qa rhoqortäqyia, “Gi ngärhipki agukt koe?” Dä qa muvät toqortäqyia, “Ma Rhäqäp” inguna ama rhäqäp na ngät ama iaus sa ngä mon sämät ka. ");
INSERT INTO uro_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Dä saqi as ngärhit nok pät ma Jisas iva qale qä naqutmäs a ngät bä va ngä namet sämät ama uqupka qärakni i qaku aa anga ribit. ");
INSERT INTO uro_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Dap ama vlam ama rhäqäp na ngät di qale ngät e bä ngät täs pät ama qurängige. Dä ama iaus ngä nok pät ma Jisas ivakt iva qä rhares pät angärha rhäng iva ngä rhon sämät ngät dä qa rhares pät angärha rhäng. ");
INSERT INTO uro_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bä nga vuk sa ama iaus nämät ka ruqa dä ngä met bä ngä mon sämät ama vlam bä ama vlam moe ngä ang masirhat pät ama qäsäpki bä ngä mon ba ama rigi bä ngä ñäp däm gi. ");
INSERT INTO uro_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bä nga ama ruvek kärarhani i mai rhit lu vät iangärhäkt ama vlam di sa rha lu ama lat kärangätni i ngä märanas toqoräkt dä rha ang masirhat bä rha sameng mät ama värhäm bä särhage särhage. ");
INSERT INTO uro_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dä ama ruvek ta met ivakt iva rhi lu iangärhäkt ama lat kärangätni i sa ngä märanas. Bä nga rha män ge ma Jisas dä rha lu qa ruqa qärak i sa vuk sa ama iaus nämät ka i qat muqun säng ma Jisas aa qar i sa mamär na aa mädräm bä qa monmät bä nga rha lu rhoqoräkt dä rhit len. ");
INSERT INTO uro_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ama ruvek kärarhani i rha lu iangärhäkt ama lat kärangät i ma Jisas ka mualat na ngät di sa rha qoar na ama ruvek i sa ma Jisas ka mumäräs pät ama iausmätka rhoqor mäniekt. ");
INSERT INTO uro_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Dä ama ruvek moe nävät ama Gerasaqäna arha ivärhäs taqe rhage rha qoar nä ma Jisas iva qa rhet nagem da inguna rhäqäp ta masirhat na ama tlenga. Dä qa rhon na nas sämät ama mlauski bä qa met. ");
INSERT INTO uro_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Bä ama ruqa qärakni i mai qre vuk sa ama iaus nämät ka di qät nok pät ma Jisas iva qä na qa dä ma Jisas ka evär däm ga näkt kä qoar na qa rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Evär däm nge säva vät bä ngi sameng i sa ma Ngämuqa qa mualat pä gia iar toqoräkt.” Dä soknga qa met mät iomäkt ama mor äm ama värhäm bä qa sameng i ma Jisas ka mualat pa aa iar toqoräkt. ");
INSERT INTO uro_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bä sa nga evär dä ma Jisas särhage na ama namuqa dä ama guläñgi na ama ruvek ta ar sä qa inguna rha moe di mai qale rha dap tat nañäm nani a qa. ");
INSERT INTO uro_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Dä ama tpäskinaqa näva ama mämairqi qärak i rhat tes ka i ma Jairus ka män bä arpus na qa säng ma Jisas aa qar bä qat naing bät a qa ");
INSERT INTO uro_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","iva qä na qa säva aa vätka inguna aa imgi qit ñäp käraktni i qop sokt ki aa imgi ama sägäkt. Näkt at koeo di ama ngärhäqyisem da udiom na ngät. Bä nga ma Jisas kat tet parhäm ama iska dap ama gulañ na ama ruvek di rha moe rhat tet bä rhit tares ka. ");
INSERT INTO uro_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Dap aktni ama ruqi di qali qi e qäraktni i qaku mae da arha rämgi na ama equngi dap at biaska qat tet pät ama ngärhäqyisem da udiom na ama qoeo. Sa qia sot pät a nas iva märäs pät a qi sokt di qaku aung ga mäqäne dä mamär iva qa rhumäräs pät a qi. ");
INSERT INTO uro_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Qia män säng ma Jisas aa rhäng bä qia rhäk da aa boiqi arha väm dä qop käp da ama biaska masägos. ");
INSERT INTO uro_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Dä ma Jisas ka snanbät toqortäqyia, “Auge qa rhäk pät a ngo?” Bä nga rha moe rha rhäqyas dä ma Pita qä qoar toqortäqyia, “Qamorqa, ama ruvek di masirhat na rha bä rhit tares nge.” ");
INSERT INTO uro_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Sokt di ma Jisas ka qoar toqortäqyia, “Aung i ak ka rhäk pät a ngo. Nguat nari i angätni gu qrot ngä met nävät a ngo.” ");
INSERT INTO uro_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Dä qa evopki qiat lu i qaku mamär iva qi namet dap kaku rhi naräm na qi dä soknga värvar vät a qi bä qia met bä arpus na qi säng ma Jisas aa qar. Näkt da ama ruvek arhä saqong moe dä qia qoar i mäniekt bä sa qia rhäk pät ma Jisas bä rhoqor mäniekt bä qia rha ama mumäräspät masägos. ");
INSERT INTO uro_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Dä ma Jisas ka qoar na qi rhoqortäqyia, “Ngua imgi, gi qatnanakt ngä mumäräs pät a nge. Ngia rhet sa ama isiska.” ");
INSERT INTO uro_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Bä as nga rhoqoräkt i ma Jisas kat tamän dä akni ama ruqa qa män näp ma Jairus ama narhoerqa näva ama mämairqi aa vätka. Bä qä qoar toqortäqyia, “Sa ngia imgi qia ñäp. Dap kale ngi namuruan bät kamorqa.” ");
INSERT INTO uro_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Bä nga ma Jisas ka nari rhoqor täkt dä qä qoar nä ma Jairus toqortäqyia, “Qale ngit len dap sokt ngiat nanakt dä va märäs pät a rha qi.” ");
INSERT INTO uro_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bä nga qa män bä ma Jairus aa vätka dä qaku qa rhares pät aung aa rhäng iva qä na qa in don sävät ama ñäpki at tut dap sokt ma Pita dä ma Jon näkt ma Jems näkt sävät ama rhuimgi at mamäk dä at nanäk. ");
INSERT INTO uro_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Dap toqoräkt di ama ruvek di rhat tuqaia dap tit nok pät a qi. Dä ma Jisas ka qoar toqortäqyia, “Qale ngänit nok inguna nak kop kaku qia ñäp dap ki mänatäm.” ");
INSERT INTO uro_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Dä rha rhama täm ga inguna rhat dräm i sa qia ñäp. ");
INSERT INTO uro_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sokt di qa sangar at tärhäqyet näkt kä qoar na qi rhoqortäqyia, “Ngua imgi, ngia rhäranas.” ");
INSERT INTO uro_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Dä saqi sa evär da at kloqaqa bä qia mair masägos. Dä ma Jisas ka qoar na rha iva rhi von gi rhä guani ivakt iva qia äs. ");
INSERT INTO uro_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","At mamäqiom di qräk mät iom mamär sokt di ma Jisas ka qoar na rha ma ama qrot iva qaku rhi nasameng ba aung sävät aa lat iangärhäkt kärangätni i sa ngä märanas pät a qi. ");
INSERT INTO uro_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Mamär dä ma Jisas ka mes ama ngärhäqyisem da udiom na rha ama mudäsaqongda sävät a ne dä qa von da rha ama qrot dä ama rhares ivakt iva rhit kutmäs ama iaus dä qosaqi iva rhat tumäräspät nämät ama räm ");
INSERT INTO uro_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","dä qa rhäk na rha ivakt iva rhi sameng sävät ma Ngämuqa aa Muräktpäm dä va rhat tumäräs pät ama rämgivärharha. ");
INSERT INTO uro_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Qä qoar na rha rhoqortäqyia, “Va qaku ngän nata guani sävät angäna tmerhäs. Qaku ngän nata anga tlang dä anga sägänaqa dä anga tmäs dä anga ligär dä va qaku aung gä nata anga unbem anga sravem. ");
INSERT INTO uro_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Agi a vätka qärakni i ngän don säväm ga diva qale ngän e väm ga bä dängdäng i ngän det daqule iomäkt ama värhäm. ");
INSERT INTO uro_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dap ngakt bä qaku guavek anga ruvek ta ar sä ngän dä va ngäni suqup angäna qar sa ama rhabuqi samäk toqoräkt i ngän det daqule iomäkt ama värhäm ivakt iva rhi lu i sa ma Ngämuqa di qaku märmär gem ga na rha.” ");
INSERT INTO uro_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Dä soknga vräs na rha bä rha met sämät ama värhap asägom asägom bä rhi sameng na ama sameng ama mär ngät dä rhat tumäräspät ama ruvek äkt kärarhani i rhat dän e. ");
INSERT INTO uro_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Bä ma Herot ama tpäskinaqa di qat nari sävät iarhongäkt kärqärhong i irhong ngät täranas bä dädän mä qa inguna arhani rhi qoar i ma Jon sa qa märanas nämät ama tñäpki ");
INSERT INTO uro_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","dap arhani rhi qoar i ma Elaija sa väs däm ga dap koki as arhani di rhi qoar i akni iaqäkt kärak i mudu qa nävät ma Ngämuqa aa vämginarha di sa qa märanas bä ama iar qa. ");
INSERT INTO uro_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Dap ma Herot ka qoar toqortäqyia, “Sa ngua rhodäkt mät ma Jon. Dap auge rhak täkt kärak i nguat nari rhärhong däkt sävät a qa?” Dä qa siqut ivakt iva as kä lu qa. ");
INSERT INTO uro_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bä sa nga evär dä qä ngangda dä rha sameng bä bä ma Jisas nä iarhongäkt moe qärqärhong i sa rha mualat nä irhong. Dä qa rhäqoar sä rha bä rhi na qa bä sokt ta rha met sä nas bä sa glaqot na ama värhäm ama lel äm gärqom i rhat tes äm i ma Betsaida, ");
INSERT INTO uro_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","sokt di qoki as ama gulañ na ama ruvek di rha räm dä rha väs täm ga sae. Dä ma Jisas ka ar sä rha näkt ka märhamän sävät a rha sävät ma Ngämuqa aa Muräktpäm näkt ka mumäräs pät iarhakt kärarhae i rhit läk nani ama mumäräspät. ");
INSERT INTO uro_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Bä nga säpbängang mamär dä qä ngärhäqyisem da udiom na rha rha män gem ga dä rhi qoaräs na qa rhoqortäqyia, “Mamär iva ngi rhäk na ama gulañ bä va rha rhet sämät ama värhap bä särhage na ap ivakt iva rhi ñäm nani anga tmäs dä anga vät iva rha rhas inguna rhos täkt ama ivärhäs di äs nga e gläius.” ");
INSERT INTO uro_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Aingän, ngäni von da rhä guarhong ivakt iva rha äs.” Dä rha muvät i rhi qoar toqortäqyia, “Rhe gem ut di qop sokt ama ngärhäqyet na ngät ama bretkäna näkt ama udiom ama rhinämiom. Dap nga nani a nge iva urhi vodäm bät anga tmäs bä ba ama gulañ moe?” ");
INSERT INTO uro_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Rha märhamän doqoräkt dinguna ama rhodäm sa ama gamoe e di ngäkt kre ama ngärhäqyet ama tausengäna na rha. Dä ma Jisas ka qoar na aa mudäsaqongda rhoqortäqyia, “Ngäni qoaräs na rha iva rha rhuqun bät a ne va ama guläñap. Näkt ama guläñap asägom asägom diva ama ruiom ama udiom da ama ngärhäqyisem na ama ruvek pä bap.” ");
INSERT INTO uro_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Dä ama mudäsaqongda rha mualat toqoräkt bä rha moe rha muqun mäk. ");
INSERT INTO uro_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Dä qa rha qä ngärhäqyet kä bretkäna näkt sävät kä rhinämiom bä qat nañäm dävit säva usäp näkt ka mes ama mär näkt ka vonmät na ngät. Näkt ka von aa mudäsaqongda rhäm ngät ivakt iva rhi are däm ngät bä ba ama ruvek. ");
INSERT INTO uro_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bä rha moe rha mäs bä arhä sarem näkt ama mudäsaqongda rha rha ama urat ama ngärhäqyisem da unbem na ama mäsdävät. ");
INSERT INTO uro_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Maos toqoräkt i ma Jisas di qä nän bät ama ivärhäs kärqosni i qaku anga ruvek e dap aa mudäsaqongda di qale rha e rhi na qa dä qa snanbät sä rha rhoqortäqyia, “Ngu lu ama gulañ na ama ruvek di rhi qoaräs i aingo di auge na ngo?” ");
INSERT INTO uro_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Dä rha muvät pät a qa rhoqortäqyia, “Arhani di rhi qoar i ma Jon ama Baptais dap arhani di rhi qoar i ma Elaija dap koki as arhani di rhi qoar i akni iaqäkt kärak i mudu qa nävät ma Ngämuqa aa vämginarha di sa qa märanas bä ama iar qa.” ");
INSERT INTO uro_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Dä qä snanbät sä rha rhoqortäqyia, “Dap aingän di ngän du angän snäng i auge na ngo?” Dä ma Pita qa muvät pät a qa rhoqortäqyia, “Ainge di ma Krais nage ma Ngämuqa.” ");
INSERT INTO uro_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Dä ma Jisas ka mugem da ma ama qrot iva qale rhi nasameng nä rhom däkt bä ba aung. ");
INSERT INTO uro_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Dä qa qoar toqortäqyia, “Ma Ruqa aa Emga diva as kä na ama märänga masirhat nani a ne bä va ama morta dä ama priskäna ama moräs na rha dä ama Skraipkäna diva rha rher mä qa bä va rhi veng ga näkt pät ama dävaung na qa ama qunäga dä va ma Ngämuqa qa rhäranas na qa nämät ama tñäpki.” ");
INSERT INTO uro_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Dä qa qoaräs na rha moe rhoqortäqyia, “Nga nani aung gärakni iva qat tet nasot a ngo di mamär iva qä qyiradeng na nas dap kä rha aa sämänanamuqa bä qät päs gua rhäng bät ama qunäng nasot a ne. ");
INSERT INTO uro_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Inguna aung gärakni i nani a qa iva qä sangar vät aa iar mamär diva qa rhusäng sä ngät nasot. Dap iaqäkt kärak i qät kyiradeng na aa iar bä ba ngo diva qa rhumaiar ngät. ");
INSERT INTO uro_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Va mamär vät ama ruqa na agiqa qre i mänamär sä qa nage ama ivätki at kärhong ama mär irhong moe dap sa musäng sa aa iar ura käbäs na ngät? ");
INSERT INTO uro_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nga aung gärakni i aqlus pät a qa na ngo dä aqlus pät a qa nä gua enge diva ma Ruqa aa Emga diva aqlus pät a qa na qa vät iomäkt ama qäväläm gärqom i ngua rhän sä gu murhämeska dä ama murhämeska i gu mamäk kä na aa enselqäna ama qumärqumär ta mamär. ");
INSERT INTO uro_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nguat tamän särhäm ngän na ama engäktki i arhani nävät a ngän däkt kärarhani i ngänät mair diva as kaku rhi nañäp dap as pa rhi lu ma Ngämuqa aa Muräktpäm.” ");
INSERT INTO uro_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ngi qoar qre nasot ama ngärhäqyet da dävaung ama qunäng i ma Jisas ka märhamän bät iangärhäkt ama enge dä qä nä ma Pita dä ma Jon näkt ma Jems ta met säda ama damgi ivakt iva rhi nän. ");
INSERT INTO uro_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bä nga rhoqoräkt i qä nän dä aa saqongait angät ñämñämgi qia män maos bä aa boi di ngä män i qaliqalae vät a ngät i ama qulum ngät mamär. ");
INSERT INTO uro_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Dä nak sa vät iomäkt ama qäväläm dä ama ruiom ama udiom ma Moses kä nä ma Elaija ");
INSERT INTO uro_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","di vuk sä iom sa ama murhämeska na rhävuk bä rhat tamän särhäm ne rhi nä ma Jisas. Rha märhamän särhäm ne sävät aa tñäpki qäraktni iva qia rhu at släqyige vät a nas e ma Jerusalem. ");
INSERT INTO uro_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Dap ma Pita qä na aa ruaiom di arhä mänap bä nak as nga bäñmät na ama mänäpki nävät arhä saqong dä rha lu ma Jisas aa murhämeska näkt sävät iaiomäkt kärqiom i init mair in na qa. ");
INSERT INTO uro_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bä nga rhoqoräkt i in met daqule ma Jisas dä ma Pita qa qoar na qa rhoqortäqyia, “Qamorqa, ama mär toqoräkt i qali lut täkt. Bä rhäkt diva u rhair na anga dävagukt anga mämairväm iva aktni bä nge dap aktni bä ma Moses dap aktni bä ma Elaija.” Qa märhamän doqoräkt inguna qaku qat dräm iva qa rhamän bät agiqa. ");
INSERT INTO uro_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Bä nga qat tamän doqoräkt dä ama eqoeqi qia män bä qia ong da bä rhit len masirhat toqoräkt i qi ngäng da. ");
INSERT INTO uro_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dä ama eguinga qa män näva ama eqoeqi i qat tamän doqortäqyia, “Rhak täkt di ngua emga qärakni i sa ngua muqunän bät a qa näkt pa ngänät nari nämät ka.” ");
INSERT INTO uro_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bä nga ama eguinga qat tamän bä rhäksot dä rha lu i sokt ma Jisas kat mair e. Dä ama mudäsaqongda rha ngaip päm mes nä iarhongäkt kärqärhong i sa rha lu irhong imäk äkt bä qaku rha qoaräs na aung nä irhong. ");
INSERT INTO uro_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Näkt nga duququ rhoqoräkt i ar sä rha näda ama damgi dä ama guläñgi ama mor qi qia män bät ma Jisas. ");
INSERT INTO uro_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Dä akni ama ruqa näva ama guläñgi qa näs sävät ma Jisas toqortäqyia, “Qamorqa, ngut nok pät a nge iva ngi lu ngua emga qärakni i qop nguna sokt ka ngua emga ama sägäk dap saqi as kaku aung. ");
INSERT INTO uro_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ngakt bä nga ama iauska qat tualat na qa ma ama qrot dä va qat tuqaia masärmän. Dä qät don na qa na ama inirqi bä vukpuk sa ama goaräm mät ka. Bä qaku ama iauska qat tet näväm ga dap sokt kä slava na qa. ");
INSERT INTO uro_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ngua nok pät gi mudäsaqongda iva rhi qutmäs a qa nämät ka rhoqoräkt i qaku a nge dä rha siqut dä qaku.” ");
INSERT INTO uro_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Dä ma Jisas ka muvät toqortäqyia, “Ai, aingän di ama qoengait na ama ruvek kärarhae i qaku angän anga qatnanakt dä qosaqi ama vurha na ngän mamär. Ngu lu va qale ngo gem ngän bä dängdäng gäsnia? Dä qosaqi va ngut ta ama märänga sä ngän bä dängdäng gäsnia?” Dä ma Jisas ka qoar nä qa ruqa i, “Ngäni rha ama rhoemga namuk.” ");
INSERT INTO uro_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bä qosaqi nga rhoqoräkt i qa rhoemga qa met iva sage ma Jisas dä ama iauska qa rhon na qa samäk sävät ivät na ama inirqi. Dä ma Jisas ka rhäk na ama iauska nämät ka na ama enge ama qrot ngät bä qa mumäräs pät ka rhoemga näkt ka evär däm ga bä ba aa mamäk. ");
INSERT INTO uro_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bä ama ruvek moe di qräk mät ta mamär nävät ma Ngämuqa aa qrot. Bä nga rhoqoräkt i qräqräk mät ama ruvek nävät iangärhäkt ama lat kärangät i ma Jisas ka mualat na ngät dä qa qoar na aa mudäsaqongda rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ngäni nari mamär na agi enge qärangätni iva as pa ngua rhamän särhäm ngän na ngät. Ma Ruqa aa Emga diva rhi vodäm ga sämät ama ruvek arhä rhäkt.” ");
INSERT INTO uro_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Sokt di qaku qunäga vät a rha inguna ama rharimini di sa ama ngaip ini. Dap tit len bä qaku aung ga snanbät sä qa närhäm ini. ");
INSERT INTO uro_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ama engirhong ngä män mänguräp ama mudäsaqongda bä rhi veng ne i auge nävät a rha di ama vit na qa mamär. ");
INSERT INTO uro_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ma Jisas di qat dräm arhä mungäsnäng dä qa sangar da ama rhoemga aa rhäkt bä qa mair na qa gem mes. ");
INSERT INTO uro_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Dä qä qoar na rha rhoqortäqyia, “Aung gärakni i qä rhar sa anga rhoemga rhoqor tak täkt sagem mes nävät gu ngärhipki di qä rhar sä ngo. Dap aung gärakni i qä rhar sä ngo sagem mes di qä rhar sä iaqäkt kärak i sa qa rhäk na ngo sarhe. Inguna iaqäkt kärak i qät säm ama gaini na nas mamär mänguräp mä ngän di ama moräs na qa mamär.” ");
INSERT INTO uro_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Dä ma Jon ga qoar na qa rhoqortäqyia, “Qamorqa, sa ut lu ama ruqa qärakni i qät kutmäs ama iaus nävät gi ngärhipki dä ut siqut iva urhin mae vät a qa inguna qaku qa nämäni ut.” ");
INSERT INTO uro_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Dä ma Jisas kä qoar toqortäqyia, “Qale ngän nanmae vät a qa inguna auge qärak i qaku a urha ik na qa di qa nävät a ut.” ");
INSERT INTO uro_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bä sa nga qorhäs korhäs na ama rhodäm gärangätni iva ma Jisas kä an dävit dä qa mu aa snäng na ama snängaqa ama sägäk iva qa rhet sae ma Jerusalem. ");
INSERT INTO uro_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Dä qa rhäk na aa engevärharha narhoer bä rha met sämät aomni ama Samariaqäna arha värhäm ivakt iva rhi rhäkmu nä iarhongäkt moe nani a qa ");
INSERT INTO uro_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","sokt di ama ruvek nae di qaku rha ar sä qa i qoki nguna qat tet iva sae ma Jerusalem. ");
INSERT INTO uro_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bä nga ama mudäsaqongiom ma Jems kä nä ma Jon in lu rhoqoräkt dä in snanbät sä ma Jisas toqortäqyia, “Una Engeska, nga nani a nge na un iva uni nän da ama rhäptäpki na rhävuk iva qi veng da?” ");
INSERT INTO uro_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Dä ma Jisas ka rhong sävät a iom näkt ka mair särhäm iom sä iaqäkt in snängaqa ");
INSERT INTO uro_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","näkt ta met sämät aomni ama värhäm. ");
INSERT INTO uro_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bä nga rhat tet parhäm ama iska dä akni ama ruqa qa qoar na qa rhoqortäqyia, “Qoe nai i ngiat tet e di qoki va ngut päs gia rhäng.” ");
INSERT INTO uro_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Dä ma Jisas ka muvät toqortäqyia, “Ama muräp di angärha lek dap ama isäm nämät ama leqäs di angärha vät sokt di ma Ruqa aa Emga di qaku aa anga ivärhäs ivakt iva qa rhas na aa uväski e.” ");
INSERT INTO uro_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Dä ma Jisas ka qoar na akni ama ruqa rhoqortäqyia, “Ngit päs gua rhäng.” Dä qa ruqa qa muvät toqortäqyia, “Gua morqa, as ngi rhares pät gua rhäng iva as narhoer dä va ngua rhet ngu sasärhä gu mam.” ");
INSERT INTO uro_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Dä ma Jisas kä qoar toqortäqyia, “Ngi qyiradeng na ama ñäpta iva rhi sasärha arhä ñäpta maräkt dap ngia rhet bä ngi sameng sävät ma Ngämuqa aa Muräktpäm.” ");
INSERT INTO uro_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Dap koki as akni di qä qoar nä ma Jisas toqortäqyia, “Gua Engeska, va ngu väs gia rhäng dap as narhoer dä ngi rhares pät gua rhäng iva evär däm ngo bä ngua rhamän särha ngua es bä ngu sangar arhä rhäkt.” ");
INSERT INTO uro_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Dä ma Jisas ka muvät toqortäqyia, “Iaqäkt kärak i qat tualat na ama iaräs na ngät ama lat ama mär ngät näkt nga qät ñäm da aa rhäng sävät ama mru ngät ama lat kärangätni i mudu qat tualat na ngät di qaku mamär vät a qa iva qat tualat mamär vä ma Ngämuqa aa Muräktpäm.” ");
INSERT INTO uro_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nasot iangärhäkt aa enge dä ma Engeska qa armeng da arhani ama latta qärarhani i ama ruvek ama dävaung na rha da ama ngärhäqyisem da udiom na rha näkt ka rhäk na rha i udiom udiom narhoer nanokt ka sävät ama ivärhimek dä ama värhap iaväkt iva as pa qat tet sämät ap kä na aa mudäsaqongda. ");
INSERT INTO uro_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Näkt kä qoar na rha rhoqortäqyia, “Ama tmäs kärangätni iva rhi dodäktgyäm ngät di masirhat na ngät dap ama latta di ama marheka na rha. Dä soknga mamär iva ngäni nän ma ama qrot sage ma Engeska bä bä iangärhäkt ama lat toqoräkt iva qä rhäk na anga latta sävät iangärhäkt aa lat. ");
INSERT INTO uro_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ngän det! As ngäni lu i ngut täk na ngän doqor ama sipsipkäna ama rhoes mänguräp ama mäsmäs päm ngät ama muräp ama mor ngät. ");
INSERT INTO uro_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Qale ngän nata anga rhae iva nanokt anga ligär ura anga sägänaqa ura anga sandal anga unmem na ngät sae dä qale ngän natmes ama qunäga aa qäväläm sävät aung barhäm ama iska.” ");
INSERT INTO uro_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Bä nga ngän mon säva agi a vätka dä ngäni er ngäni qoar toqortäqyia, ‘Ama bulap bä rhak täkt ama vätka.’ ");
INSERT INTO uro_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Näkt ngakt bä anga ruqa qa ni e qärakni i qat sangar ama bulap diva iangärhäkt angäna enge na ama bulap diva qale ngät gem ga dap ngakt bä nga qaku diva qosaqi evär dä angän modämne sagem ngän. ");
INSERT INTO uro_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Qale ngän bä iaqäkt ama vätka bä ngän däs dä ngänit nakt agirhong gärqärhongni i rhit bon ngän däm irhong inguna ama latka diva nak koki qät ta aa rhitsek. Qale ngän dune na ama vät.” ");
INSERT INTO uro_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Bä nga sa ngän mon sämät agi a värhäm bä sa rha ar sä ngän dä ngän däs agirhong gärqärhongni i rhit täkmu nä irhong bä ba ngän. ");
INSERT INTO uro_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ngän dumäräs pät ama rämgivärharha qärarhani i qale rha e näkt pa ngäni qoaräs na rha rhoqortäqyia, ‘Ma Ngämuqa aa Muräktpäm di sa nga e glaqot na ngän.’ ");
INSERT INTO uro_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Dap krekt bä ngän don säva agi a värhäm bä nga sa qaku rha ar sä ngän dä ngän det sämäni ama iska dalek na äm näkt pa ngäni qoar toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ama rhabuqi qäraktni i dädäktgyäm gi va aurha qar angärha rem diva urhi suqup sä qi ivakt iva urhi qur a ngän i angäna lat di ama vu ngät. Sokt di mamär iva ngänät dräm doqortäqyia, ma Ngämuqa aa Muräktpäm di sa nga e glaqot.’ ");
INSERT INTO uro_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ngu qoar na ngän iva sädä iaqäkt ama qunäga iva ma Ngämuqa qa rhatnävämne na ama ruvek diva qä lavuqi nä ma Saidon masirhat pit pä iomäkt ama värhäm angät tpäs.” ");
INSERT INTO uro_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Aingän ama Korasingäna diva avuqi na ngän mamär! Bä aingän ama Betsaidaqäna diva qosaqi avuqi na ngän mamär! Inguna vadi mai iangärhäkt ama nañis ngät ama lat kärangätni i sa ngua mualat na ngät gem ngän di nga vadi mai ngä märanas e mänguräp ama ruvek nae ma Tair bä nae ma Saidon di sa vadi mudu iarhakt ama ruvek ta näpgoer na nas nämät arha vuirhong i rhat muqun i rhi is nas na ama iläñ ngät ama boi na ama iräski nävät arha vuirhong näkt ti suqup ama ligätki vät a nas. ");
INSERT INTO uro_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Sokt di vät ama qunäga qärakni iva ma Ngämuqa qa rhatnävämne na ama ruvek pät ama ivätki diva qä lavuqi na ama ruvek nae ma Tair dä nae ma Saidon masirhat pit pa angän bäs. ");
INSERT INTO uro_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Dä ainge ma Kaperneam, nga va ma Ngämuqa qä sek sä nge sa rhävuk säda ama usäpki arha ron? Nak pa qaku rhoqoräkt. Dap kinak nge diva ma Ngämuqa qä rhon na nge rhämane sävät ama ñäpta arhä ivärhäs.” ");
INSERT INTO uro_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Iaqäkt kärak i qat nari nämät ngän di qat nari nämät ngo dap auge qärak i qat ter mä ngän di qat ter mä ngo bä auge qärak i qat ter mä ngo di qat ter iaqäkt kärak i sa qa rhäk na ngo sarhe.” ");
INSERT INTO uro_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Evär dä qärarhani ama ruvek ama dävaung na rha da ama ngärhäqyisem da udiom na rha ama latta sa ama sameng na ama märmärgem dä rhi qoar toqortäqyia, “Aurha Engeska, nak ama iaus di qäqi ngät nari nämät ut toqoräkt i urhit kutmäs a ngät nävät gi ngärhipki.” ");
INSERT INTO uro_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Dä ma Jisas ka muvät toqortäqyia, “Aingo di qaku ngua särmändäm i sa nguna ngua lu ma Sämga i arpus na qa näda ama usäpki arha ron doqor ama iauska qärakni i bañäm mät ka. ");
INSERT INTO uro_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Sa ngua von ngän da ama rhares ivakt iva ngäni naengmät na ama uiuvärhirhong dä ama rhäm dä va ngänät dän näva ama qrot moe angät tpäs i ma Sämga. Dä va qaku guani ngä nasangäm na ngän. ");
INSERT INTO uro_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sokt di qale märmär gem ngän inguna ama iaus ngät nari nämät ngän dap mamär iva märmär gem ngän inguna sa ma Ngämuqa qa säm angän ngärhep tävuk.” ");
INSERT INTO uro_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Vät iomäkt ama qäväläm dä ma Jisas di rhäqäp ka na ama märmärgem nage ama Qloqaqa ama Qumärqumärqa dä qä qoar toqortäqyia, “Ngu nän sä nge mam, ainge qärak i ma Engeska na nge bä ba ama usäpki dä bä bä ama ivätki inguna sa ngia ngaip tärhong däkt nämät ama ruvek sa ama mädräm ama mär ngät dä ama mädrämda dap kinak sa ngia muqunäga sä irhong bä ba ama rhoes ama gaini na rha. Ari mam, i qoki nguna rhoqoräkt di varhäm gi snängaqa na ama ñämsävätki.” ");
INSERT INTO uro_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Sa gu mam ga von ngo rha ama qrot daver iarhongäkt moe. Bä qaku aung gat dräm i ama Ngärhoemga di auge dap sokt ama Ngätmamäk dä qaku aung gat dräm i ama Ngätmamäk di auge dap sokt ama Ngärhoemga bä qosaqi iarhakt kärarhae i sa ama Ngärhoemga qa muqunäga sä qa ba rha.” ");
INSERT INTO uro_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nasot dä qa rhong sävät aa mudäsaqongda dä qa qoar na rha rhoqoräkt i sokt ta sä nas toqortäqyia, “Ama märmärgem bä bä iarhakt kärarhae i arhä saqong ngät lu iarhongäkt kärqärhong i sa ngänät lu irhong. ");
INSERT INTO uro_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Inguna ngu qoar na ngän i ama rhäqäp na rha ma Ngämuqa aa vämginarha dä ama vitnarha di sa nani a rha iva rhi lu rhärhong däkt kärqärhong i sa ngänät lu irhong sokt di qaku rha lu irhong. Bä qosaqi nani a rha iva rhi nari rhärhong däkt kärqärhong i sa ngänät nari irhong sokt di qaku rha nari irhong.” ");
INSERT INTO uro_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Maos pät aomni ama qäväläm dä akni ama ruqa qa e qärakni i sa qa su na ama Muräkt kärangätni i sa ma Ngämuqa qa von ma Moses täm ngät. Di qa mair ivakt iva qä siqut nä ma Jisas dä qa qoar nä ma Jisas toqortäqyia, “Qamorqa, ngu lu va ngua mäsana äkt iva dängdäng dä bä ba ngo na ama iar ama sok täm ngät?” ");
INSERT INTO uro_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Dä ma Jisas ka muvät toqortäqyia, “Ngu lu ama Muräkt di ngät tamän doqor mäniekt? Ngu lu ngiat tes ngät toqor mäniekt?” ");
INSERT INTO uro_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Dä qa muvät pät ma Jisas toqortäqyia, “Mamär iva gia snäng bät ma Engeska gi Ngämuqa nä gi snängaqa moe bä nä gi mungäsnäng moe bä nä gi qrot moe bä nä gi mädräm moe dä qosaqi va gia snäng bät arhani i rhoqor qre i gia snäng bät a nas.” ");
INSERT INTO uro_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Sa ngia muvät maräkt. Ngia rhualat toqoräkt dä va ama iar nge.” ");
INSERT INTO uro_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Sokt di qoki as nani a qa iva rhuk pät a qa nävät a nas dä qa snanbät sä ma Jisas toqortäqyia, “Näkt ngu lu auge nävät iarhakt diva gua snäng bät a qa?” ");
INSERT INTO uro_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Akni ama ruqa qat tet mämane nae ma Jerusalem iva sae sämät ama värhäm ama mor äm ma Jeriko bä qa rhon sä nas sämät ama suarha arhä rhäkt. Dä rha set da aa boi nävät a qa näkt ta arhäktgyäm sä qa näkt ta met daqule qa mäk i rät pät a qa. ");
INSERT INTO uro_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Dap akni ama pris nävät ama Judaqäna di mai sävät a qa i qat tet mämane nävä iaqäkt ama iska bä nga qa lu qärak ka ruqa dä qa ang dage bä qa met e na qa. ");
INSERT INTO uro_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Dä akni ama Livaiqa qärakni i qosaqi qa nävät ama Judaqäna di nga qat tet bä sävät iosäkt ama ivärhäs dä qa lu qärak dä qosaqi qa ang dage na qa. ");
INSERT INTO uro_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Dap ama Samariaqa qärakni i aiut ama Judaqäna di ut dräm ut tu ut snäng i ama ruqa ama vu qa na qa di qat tet parhäm aa tmerhäs bä nga qa män äkt i qale qärak ka ruqa e bä nga qa lu qa dä qa lavuqi na qa. ");
INSERT INTO uro_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Dä qa met bä sage qärak dä qa rhor na ama oel dä ama wain mät aa bias näkt ka ispät mät ngät. Nasot dä qa mu qärak pät aa donki aa rhäng. Näkt ka met sä qa ruqa bä säva ama vätki qäraktni i ama ruvek tat dän bä rhat tas päm gi näkt tit bodäm sasot a nas näväm gi bä qa lu vät a qa. ");
INSERT INTO uro_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Näkt duququ dä qa rha ama udiom ama qunängiom angät titsek angät ligäriglem bä qa vodäm iglem bä bä iaqäkt kärak i qät lu vät ama vätki. Näkt ka qoar na qa rhoqortäqyia, ‘Ngit lu vät a qa iva nga evär däm ngo dä va ngu vodäm bät gi matnärhäm bä ba qa.’” ");
INSERT INTO uro_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Dä ma Jisas ka snanbät toqortäqyia, “Ngiat tu gi snäng i auge nävät iarhakt ama dävaung na rha di aa snäng bät ama vospospärhaqa maengäktki?” ");
INSERT INTO uro_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Dä qä mädrämga mamär sa ama Muräkt ka muvät toqortäqyia, “Iaqäkt kärak i sa qa lavuqi na qa.” Dä ma Jisas kä qoar na qa rhoqortäqyia, “Ngia rhet bä va ngiat tualat toqor iaqäkt ama ruqa.” ");
INSERT INTO uro_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Bä nga ma Jisas kä na aa mudäsaqongda di rhat tet parhäm arha iska dä qa män ba aomni ama värhäm ama lel äm bä aktni ama ruqi qäraktni i rhat tes ki i ma Marta di qia ar sä qa säva arha vätka. ");
INSERT INTO uro_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Näkt arha läktki di rhat tes ki i ma Maria. Näkt pät iomäkt ama qäväläm di qiat muqun säng ma Jisas aa qar bä qiat nari iarhongäkt moe qärqärhong i ma Jisas kat tamän bät irhong. ");
INSERT INTO uro_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Dap ma Marta di qänäskänes ki sa at täkmunanaska i vadi va estäm na qa. Qia met bä sage ma Jisas di qia snanbät sä qa rhoqortäqyia, “Gua Engeska, nak kop nga ngiat lu ma Maria nae i qia ang daqule ngo sa ama lat bä sokt ngo nguat tualat na ngät? Mamär iva ngi qoar na qi iva qia rhatnärhäm ngo.” ");
INSERT INTO uro_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Dä ma Engeska qa muvät toqortäqyia, “Marta, Marta, ainge di ngiat tu gi snäng masirhat bä rhäqäptäqäp nge sävät ama rhäqäp nä irhong ");
INSERT INTO uro_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","dap ngit läk nani ama sägäni. Ma Maria di sa qia armeng dä ianiäkt kärqäni i ama mär ini bä va qaku aung gä narha ini daqule qi.” ");
INSERT INTO uro_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Vät akni ama qunäga dä ma Jisas kä nän bät aosni ama ivärhäs. Bä nga qä nän bä rhäksot dä akni nävät aa mudäsaqongda qä snanbät sä qa rhoqortäqyia, “Gua Engeska, mamär iva ngi su ut iva urhi nän doqor ma Jon i qa su aa mudäsaqongda iva rhi nän.” ");
INSERT INTO uro_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Nga ngäni nän dä mamär iva ngän damän doqortäqyia, “Mam, mamär iva urhit kutdrir sävät gi ngärhipki i ama qumärqumär qi mamär bä mamär iva ar sä gi muräkt sarhe. ");
INSERT INTO uro_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mamär iva ngi von ut ta ama tmäs kärangätni i urhit läk nani a ngät pät ama qunäng nasot a ne. ");
INSERT INTO uro_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Dap pa ngit kyiradeng na aurha vuirhong inguna qosaqi urhit kyiradeng na arhani sa arha vuirhong sävät a ut. Näkt pa qale ngit kyiradeng na ut sämät ama siqutsiqut.” ");
INSERT INTO uro_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mamär dä qä qoar na rha rhoqortäqyia, “Ngakt bä nga aung nävät a ngän di aa anga ruaqa näkt ngia rhet sagem ga mäni bängagi bä ngi qoar na qa rhoqortäqyia, ‘Gua ruaqa, as ngi von ngo rha anga bretkäna anga dävaung ");
INSERT INTO uro_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","inguna akni gua ruaqa qärakni i qat tet pät aa tmerhäs sa gläius di qa män gem ngo näkt kaku guani iva ngu von ga rhäm ini.’” ");
INSERT INTO uro_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Dä va iak puk pa aa vätka qa rhuvät toqortäqyia, ‘Qale ngiat tusar na ngo. Sa ngua väs mät ama tmongi bä ngua es di sa rha e mäni lai rhi na ngo. Bä qaku mamär iva ngua rhäranas bä ngu von nge rhä guani.’ ");
INSERT INTO uro_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Dä ngu qoar na nge i näma dä äkt bä qaku qa märanas bä qä navon nge inguna äkt i gia ruaqa na qa sokt di nak kop nguna nävät iomäkt i qaku aqlus pät a nge iva ngiat naingbät i ngi nän diva gia ruaqa qa rhäranas bä va qä von nge masirhat parhäm gia tläqa.” ");
INSERT INTO uro_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Dä soknga va ngu qoar na ngän doqortäqyia, ngi nän ma Ngämuqa dä va qä von nge dap pa ngit ñäm nani guani dä va ngia rhän bät ini dap pa ngit kut dä va ama tmongi qi rhar bä ba nge. ");
INSERT INTO uro_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Inguna iarhakt moe qärarhae i rhi nän nani guani diva rhi rha ini dap auge qärak i qät ñäm diva qa rhänbät dap auge qärak i qät kut mät ama tmongi diva qi rhar ba qa. ");
INSERT INTO uro_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Guavek koe nävät a ngän ama ngätmamäkkäna di nga ngia emga qä nän nani anga rhinämga di nak pa ngi von ga rha anga uiuvärhaqa dap kaku anga rhinämga? ");
INSERT INTO uro_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ura ngakt bä nga qä nän da anga luaqa di nak nga va ngi von ga rha anga rhämga? ");
INSERT INTO uro_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ngakt bä aingän gärarhae i ama vu rha ama ruvek na ngän di ngänät dräm iva ngänit bon angän oes ta ama mär ngät ama vänbon doqoräkt di ngäktki mamär iva angän mamäk tak pono da ama usäpki arha ron ba qä von da ama Qloqaqa ama Qumärqumärqa bä bä iarhakt kärarhae i rhi nän ga!” ");
INSERT INTO uro_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ma Jisas kät kutmäs ama iauska qärakni i qaku qat tamän. Bä nga ama iauska qa met dä ama ruqa qärakni i mudu qaku qat tamän di qa märhamän. Bä ama guläñgi na ama ruvek di qräk mät ta rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Dap arhani nävät a rha di rhi qoar toqortäqyia, “Qät kutmäs ama iaus inguna ama iaus angät narhoerqa ma Belsebul qät bon ga rha ama qrot bä qat tualat toqoräkt.” ");
INSERT INTO uro_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Dap arhani di rha siqut na qa i rha snanbät sä qa ma ama qrot iva qa rhualat na anga muqunängi na rhävuk. ");
INSERT INTO uro_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Sokt di ma Jisas ka räm arhä mungäsnäng i rhat tu arhä snäng i qat tualat nä ma Sämga aa qrot dä qä qoar na rha rhoqortäqyia, “Anga muräktpäm moe qärangätni i sa ngä matmät na nas diva qaku angärha anga uiuit bä qosaqi anga sägärhae näva anga vätka qärarhani i sa rha matmät na ne diva qaku sägäni na rha saqi as. ");
INSERT INTO uro_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Bä ngakt bä nga ma Sämga di qat tatmät na nas di ngu lu va aa muräktpäm ngät mair ma ama qrot toqor mäniekt? Nguat tamän doqor täkt dinguna ngäni qoar i ngut kutmäs ama iaus nä ma Belsebul aa qrot. ");
INSERT INTO uro_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Näkt ngakt bä nga ngut kutmäs ama iaus na ama qrot nage ma Belsebul värhäm angäna enge dä ngu lu iarhakt kärarhae i rhat tet nasot a ngän di auge qät bon da rha ama qrot bä rhit kutmäs ama iaus? Iarhakt kärarhae i rhat tet nasot a ngän di sa arha lat ngärhi sameng i angäna enge di qaku maräkt na ngät. ");
INSERT INTO uro_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Sokt di ngakt bä nga ngut kutmäs ama iaus nä ma Ngämuqa aa qrot di iangärhäkt gua lat di ngärhi sameng i ma Ngämuqa aa Muräktpäm di sa ngä män sagem ngän.” ");
INSERT INTO uro_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nga ama qrot ka ama ruqa di qa rhäkmu na nas mamär na ama ulaqi at kärhong näkt kät lu vät aa vätka dä mamär iva mänarhäk pät aa qärhong. ");
INSERT INTO uro_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Dap ngakt bä anga qrot ka mamär anga ruqa qa rhän bä qä siqut na qa dä va ama qrot ka mamär ama ruqa qa rhän näva aa uväs bä va qä rha iarhongäkt ama ulaqi at kärhong gärqärhong i mai di qat tu aa snäng i mamär na qa nävät irhong bä va qa rhatmät na aa qärhong moe bä ba aa ruavek.” ");
INSERT INTO uro_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Auge qärak i qaku qat tair gem ngo di qat tair sävät a ngo. Dap auge qärak i qaku qat tatnärhäm i qä ngingdämne na ama ruvek kä na ngo di qa di qat tusur täm da.” ");
INSERT INTO uro_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Qre va vuk sa ama iauska nämät ama ruqa dä qat tet pät ama ivärhäs ama qräk dä bäs bä qät ñäm nani anga ivärhäs ivakt iva mae vät a qa e sokt di ngakt bä qaku qä namäqäne dä mamär dä qat tu aa snäng doqortäqyia, ‘Va evär däm ngo sävä gua vätka qärak i sa ngua män näväm ga.’ ");
INSERT INTO uro_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bä nga rhoqoräkt i qat dän bä samuk dä qä lu qa vätka i ama qumärqumär väm ga näkt sa mamär na qa moe. ");
INSERT INTO uro_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Dä qat tet bä qat dän sa ama ngärhäqyet da udiom angätni ama iaus kärangätni i sa ngä met e na qa sa angärha lat ama vu ngät bä ngät don sävä qa vätka bä qale ngät e. Dä iaqäkt ama ruqa di sa mäqi mava na qa dap täkt di sa mava na qa masirhat mamär.” ");
INSERT INTO uro_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Bä nga ma Jisas kat tamän bät tärhong däkt dä ama ruqi nä mänguräp ama gulañ gia näs tävuk toqortäqyia, “Ma Ngämuqa aa modämne di sa nga e ge ama ngätnanäk käraktni i qia sa nge bä qia sek mä nge.” ");
INSERT INTO uro_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Dä qa muvät toqortäqyia, “Nak ma Ngämuqa aa modämne di sa nga e ge iarhakt kärarhae i rhat nari ma Ngämuqa aa enge näkt tat tet nasot a ngät.” ");
INSERT INTO uro_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Bä nga märmor ama gulañ dä ma Jisas kä qoar toqortäqyia, “Irhäkt ama qoengait di ama vu it ama qoengait. It ngärhit ñäm nani anga muqunängi sokt diva qaku anga muqunängi qi namän bä ba it dap sokt ama muqunängi nävät ma Jona. ");
INSERT INTO uro_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mudu ma Jona di sa qa män i ama muqunängi na qa bä ba ama Niniveqäna bä rhoqoräkt diva ma Ruqa aa Emga di ama muqunängi na qa bä bä rhit täkt ama qoengait. ");
INSERT INTO uro_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ama ruqi qäraktni i ama vit na qi e vät ama ivärhäs ma Seba diva qia rhäranas pät iaqäkt ama qunäga qärakni iva ma Ngämuqa qa rhatnävämne na ama ruvek bä va qi rhäksärha ama ruvek näp tit täkt ama qoengait inguna qia met näva ama iska näda ama ivätki at tärhäkt ivakt iva qi nari ama ruqa sa ama mädräm ama mär ngät ma Solomon aa enge. As ngäni lu i aingo qärak i qale ngo rhe di ngua e daver ma Solomon. ");
INSERT INTO uro_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ama ruvek nae näva ama värhäm ama mor äm ma Ninive va rha rhair ti nä rhit täkt ama qoengait pät ama qunäga qärakni iva ma Ngämuqa qa rhatnävämne na ama ruvek pät ama ivätki bä va iarhakt ama ruvek ti rhäksärhäm ngän inguna mudu rha näpgoer na nas toqoräkt i ma Jona qa sameng bät a rha. Dap täkt di aingo qärak i qale ngo rhe di ngua e daver ma Jona.” ");
INSERT INTO uro_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Qaku aung gä namudäm säda anga lirhäga näkt kä ngaip ka ura qa rhu qa va anga uratki arha rem. Dap kinak kä rhäkt a qa rhävuk ivakt iva nga iarhakt kärarhae i rhat don säva vät diva rhat lu ama neraqa. ");
INSERT INTO uro_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Gi saqong di ama lirhäga bä bä gi släqyige. Qre va ama mär gi saqong dä va rhäqäp gi släqyige moe na ama neraqa. Dap ngakt bä gi saqong di mava na ngät dä va rhäqäp gi släqyige na ama bängangit. ");
INSERT INTO uro_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ngit lu mamär i vadi va ama neraqa qä sen bäm nge dap kale bängangit. ");
INSERT INTO uro_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bä va ngakt bä nga gi släqyige moe di rhäqäp ige na ama neraqa dap kaku anga bängangit nani e diva qunäga masirhat mät gi släqyige i rhoqor qre i ama neraqa näda ama lirhäga qä sen nävät a nge.” ");
INSERT INTO uro_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Bä nga ma Jisas kat tamän bä rhäksot dä ama Farisiqa qa rhäknan däm ga iva qä na qa in däs dä soknga qa mon bä qa muqun bät ama laiqa aa rhäkt. ");
INSERT INTO uro_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Dap ama Farisiqa di qa särmän sävät ma Jisas inguna qat dräm i ma Jisas di qaku qa er qa rhor aa rhäkt näkt sa qat täs aa tmäs. ");
INSERT INTO uro_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Dä ma Engeska qä qoar na qa rhoqortäqyia, “Aingän ama Farisiqäna di sa ngäni qumär vät ama kapkäna dä ama pletkäna angärha rhäng dap imuk da angäna ron di rhäqäp ngän na ama snängaqa nani guarhong masirhat iva bä ba nas dä ama mungäsnäng ama vu ngät. ");
INSERT INTO uro_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ama dädän da ama ruvek na ngän! Nga nak kaku ma Ngämuqa qärak i sa qa säm ama släqyige di qosaqi qa säm sädä ige angärha ron? ");
INSERT INTO uro_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Dap mamär iva ngäni von nävät iarhongäkt kärqärhong i qali lirhong mät angäna kapkäna dä angän pletkäna bä ba ama tläkta dä va ama qumärqumärta na ngän dä ma Ngämuqa aa saqong.” ");
INSERT INTO uro_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Avuqi na ngän mamär ama Farisiqäna! Inguna sa ngänit bon ma Ngämuqa rha ama sägäni näda ama ngärhäqyisem nävät iarhongäkt moe qärqärhong i ngän du irhong bät ama tmäs toqor ama mint ngä na ama ru dä ama tmäsirhong maos maos nävät a lat dap kaku ngän dualat parhäm ama räkt ngät ama muräkt sävät ama ruvek dä qaku angäna snäng bät ma Ngämuqa. Mai mamär iva ngän däqäne dä mamär varhäm därhong däkt moe dap kale ngän detdäm särhä guarhong.” ");
INSERT INTO uro_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Avuqi na ngän mamär ama Farisiqäna! Rhoqoräkt dinguna sa nani a ngän iva ngän duqun bät ama lai vuk dä ngärhaväm ba ama mämairväm dä nani a ngän masirhat iva ama ruvek ti rhar sä ngän na ama qutdrir vät ama ivärhimek kärqämekni i ama ruvek tit boda arha tmäs e.” ");
INSERT INTO uro_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Avuqi na ngän mamär! Inguna sa ngän män i ngän doqor ama rhobek arha an gärangätni i qaku rha muqunän sagem ngät bä äkt i ama ruvek tat tet pono va angärha rhäng inguna qaku rhat dräm i ama an iangärhäkt.” ");
INSERT INTO uro_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Dä akni ama mädrämga mamär sa ama Muräkt ka muvät pät ma Jisas toqortäqyia, “Qamorqa, nga ngiat tamän bät iarhongäkt ama engirhong dä qosaqi ut nari i ngi slava na ut nä gia enge.” ");
INSERT INTO uro_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Dä ma Jisas ka muvät toqortäqyia, “Dä aingän ama Farisiqäna di qosaqi avuqi na ngän mamär inguna ngän du ama talap ama märän bä bap pät ama ruvek arha rhäng bä rhi siqut iva rhit ta dä qaku. Dap kinak ngän di qaku nani a ngän iva ngän natmualat nä guarhong iva ngän datnärhäm da.” ");
INSERT INTO uro_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Avuqi na ngän mamär! Inguna ngänit täkmu na ama ñäpta arha lek iva nani ma Ngämuqa aa vämginarha qärarhani i sa mudu angän mamäkkäna rha veng da. ");
INSERT INTO uro_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Angäna lat di ngärhi sameng mamär i sa ngän dares pät angän mamäkkäna arha rhäng i iarhakt ta mualat toqoräkt. Sa rha veng ma Ngämuqa aa vämginarha dap aingän di ngän däkmu na arha lek. ");
INSERT INTO uro_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Inguna nävät iangärhäkt angäna lat dä sa rha säm ba ama abuk ma Ngämuqa Aa Mädräm ama Mär Ngät toqortäqyia, ‘Va ngu rhäk nä gua vämginarha dä ama ngangda sagem da dä arhani nävät a rha diva rhi veng da dap arhani diva rhi sangäm na rha mavängam.’ ");
INSERT INTO uro_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Bä äkt iva rhit täkt ama qoengait pa it ngärhi rha ama rhäksärhäm bät ma Ngämuqa aa vämginarha arhä biaska aa uväs kärakni i qrir na qa mänasäng mudu vät ama rharimini qärqäni i sa ma Ngämuqa qa säm ama ivätki ");
INSERT INTO uro_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mänasäng nävät ma Abel aa biaska bä sävät ma Sekaraia aa biaska qärak i sa rha veng ga mänguräp ama laiqa na ama vodämes kä na ama ansäspämgi ama mor qi. Ari, sa ngu qoar na ngän na ama engäktki i rhit täkt ama qoengait diva ngäni rha ama rhäksärhäm bät iangärhäkt ama lat angät tpäs.” ");
INSERT INTO uro_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Avuqi na ngän mamär ama mädrämda mamär sa ama Muräkt inguna ngänit päs mät ama iska sävät ama mädräm sa ama engäktki sävät ma Ngämuqa. Qaku ngän det parhäm ngät dap kosaqi sa ngänit päs särhä iarhakt kärarhae i rhat tet parhäm ngät.” ");
INSERT INTO uro_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Bä sa nga ma Jisas ka met nae dä ama Farisiqäna rhi na ama Skraipkäna di sa rha nasäng i rhi siqut na qa iva qat tamän sävät ama rhäqäp nä irhong ");
INSERT INTO uro_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","i qale rha nani a qa iva qa rhamän bät agung anga enge qärangätni iva rhi rhäksärhäm ga vät angät tpäs. ");
INSERT INTO uro_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Bä nga rhoqoräkt i ama guläñgi na ama rhäqäp na ngät ama tausengäna na ama ruvek pästämne na rha bä dät mamär bä rhi naengmät na ne. Dä ma Jisas ka nasäng i qat tamän sävät aa mudäsaqongda narhoer toqortäqyia, “Ngänit lu nämät ama Farisiqäna arha yis käraktni i iomäkt i rhat tualat sädä saqong. ");
INSERT INTO uro_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Qaku guani qärqäni i sa rha väsärhäm ini diva qaku rhi namuqunäga sä ini dä qaku guani qärqäni i ama ngaip ini diva qaku rhi naräm nä ini. ");
INSERT INTO uro_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Agi enge iangärhäkt kärangätni i sa ngia märhamän bät a ngät pä bängangit angät tpäs diva rhi nari ngät da eraqi bä agi enge iangärhäkt kärangätni i sa ngia rhäkdasäkt na ngät mät ama sdämgi da ama vät angärha ron mamär diva rhi sameng na ngät nävät ama vät angärha rhäng.” ");
INSERT INTO uro_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Gua ruavek, nguat tamän särhäm ngän i qale ngänit len iarhakt kärarhae i rhi veng ama släqyige näkt nasot dä qaku mamär vät a rha iva rhi namualat nä guani saqi as. ");
INSERT INTO uro_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Dap pa ngu qur a ngän da iaqäkt kärak i mamär iva ngänit len ga. Mamär iva ngänit len iaqäkt kärak i nasot i sa qa veng ama släqyige di aa qrot ngä vit iva qä rhon na ngän sämät ama ivärhäs na ama mudäbäs ama sok tä bäs. Ngäktki, nguat tamän särhäm ngän iva nak pa ngänit len ga. ");
INSERT INTO uro_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Nga qaku rhi navodäm bät ama ngärhäqyet ama isämirhong na ama brasirhom? Sokt di qaku guani nävät irhong di rät pät ma Ngämuqa nä ini. ");
INSERT INTO uro_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bä ngäktki mamär i qäqi ama qäseng bät angän bäs di sa ma Ngämuqa qat dräm ama rhodäm sä ngät. Qale ngänit len. Aingän di ngän bit ge ma Ngämuqa va ama rhäqäp nä irhong ama isämirhong angät tpäs.” ");
INSERT INTO uro_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Dä nguat tamän särhäm ngän i iaqäkt kärak i qat tamän i qa nämäni ngo da ama ruvek arhä saqong diva qosaqi aingo ma Ruqa aa Emga ngua rhamän i qa nämäni ngo dä ma Ngämuqa aa enselqäna arhä saqong. ");
INSERT INTO uro_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Dap kärakni i qät täqyas na ngo da ama ruvek arhä saqong diva ngu rhäqyas na qa dä ma Ngämuqa aa enselqäna arhä saqong. ");
INSERT INTO uro_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Bä aung gärakni i qat tamän mava nä ma Ruqa aa Emga diva ma Ngämuqa qä qyiradeng nä ianiäkt aa vuini. Dap aung gärakni i qat tamän mava na ama Qloqaqa ama Qumärqumärqa diva qaku ma Ngämuqa qa naqyiradeng nä ianiäkt aa vuini.” ");
INSERT INTO uro_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Qre va rhat tair na ngän da ama narhoerta näva ama mämairväm dä ama tpäskinarha näkt ama narhoerta arhä saqong dä va qale qänäskänes ngän iva ngän dair särhäm mes toqor mäniekt ura va ngän damän doqor mäniekt ");
INSERT INTO uro_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","inguna ama Qloqaqa ama Qumärqumärqa va qä su ngän da ama enge iva ngän damän doqoräkt pät iomäkt ama qäväläm.” ");
INSERT INTO uro_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Akni nä mänguräp ama guläñgi qa qoar nä ma Jisas toqortäqyia, “Qamorqa, mamär iva ngi qoar nä gua matka iva qa rhatmät ama gunän nage aun mamäk bä ba un.” ");
INSERT INTO uro_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Rhakni, auge qa armeng däm ngo iva ama matnävämnenaqa na ngo ura ama ruqa iva qa rhatmät bä ba en?” ");
INSERT INTO uro_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Dä qä qoar na rha rhoqortäqyia, “Ngänit lu! Ngänit lu vät a nas mamär nämät ama snängaqa maos maos na ama alek inguna ama ruqa aa iar di qaku ama rhäk täm ngät nävät aa gunän.” ");
INSERT INTO uro_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Dä qa qoar na rha na ama enge na ama siqutki rhoqortäqyia, “Ama etki na ama tmäs pät akni ama qärhongbärhaqa aa ivärhäm di ngä sa masirhat. ");
INSERT INTO uro_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Dä qat tu aa snäng doqortäqyia, ‘Va ngu lu ngua mäsana i sa nguna qaku anga släqyäs iva nanokt ama tmäs iva ngua rhu ngät mamär vät a ne?’ ");
INSERT INTO uro_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Dä soknga qä qoar toqortäqyia, ‘Rhäkt diva ngua rhualat toqortäqyia. Va ngun brut da ama tmäs angärha vät samäk näkt pa ngu rhäk pät anga mor ngät mamär anga vät iva äkt näkt ngua rhuvärhane nä gua tmäs ngä nä gu gunän bäm ngät. ");
INSERT INTO uro_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Bä va ngua rhamän sävät a nas toqortäqyia, “Nak masirhat nä gu gunänirhong gärqärhongni i sa ngua muvärhane nä irhong säda ama rhäqäp ama qoeo angärha ron. Bä va märmärsäs gem ngo i nguat täs dä ngut nakt bä va märmär gem ngo.” ’ ");
INSERT INTO uro_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Sokt di ma Ngämuqa qa qoar na qa rhoqortäqyia, ‘Ainge di ama dädänga na nge. Va näp takt täkt ama bängagi dä va ngu rhäqäs ta ama iar näväm nge. Dä va auge qä rha iarhongäkt kärqärhong i mudu ngia rhäkmu nä irhong iva bä ba nas?’ ");
INSERT INTO uro_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Rhangät täkt ama lat diva ngä rhän bät iaqäkt kärak i qat tuvärhane na aa gunän bä ba nas dap ka di qaku ama qärhong bät a qa sage ma Ngämuqa.” ");
INSERT INTO uro_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Dä ma Jisas kä qoar na aa mudäsaqongda rhoqortäqyia, “Bä äkt iva ngu qoar na ngän i qale qänäskänes ngän sävät angäna iar iva ngän däs agirhong ura va sävät angän släqyige iva ngän don mät agirhong. ");
INSERT INTO uro_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ama iar di ngä vit pa ama tmäs angät tpäs dä ama släqyige di ige ngä vit pa ama boi angät tpäs. ");
INSERT INTO uro_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","As ngäni lu ama ngotkiqäna. Ngät di qaku ngät dräm ngärhit kutnanokt dä ngärhit sekdäm dä qaku angät anga vät nanokt ama tmäs sokt di ma Ngämuqa qät bon ngät ta ama tmäs. Dap aingän di ama vit na ngän masirhat pa ama isäm angät tpäs. ");
INSERT INTO uro_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Auge nävät a ngän di mamär vät a qa iva qa rhu anga sägäk anga aua sävät aa iar toqoräkt i qänäskänes ka masirhat? ");
INSERT INTO uro_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Di ngakt bä nga qaku mamär vät a ngän iva ngän dualat nä rhäni rhäkt ama gaini mamär dä mäniekt bä va qänäskänes ngän nani iarhongäkt moe?” ");
INSERT INTO uro_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“As ngäni lu ama ngualäñngualañ angärha iar. Qaku ngät dräm ngät tualat ura ngärhit kutäm bät ama boi iva ngät donmät sokt di ngu qoar na ngän i qäqi ama vitnaqa ma Solomon sa aa murhämeska moe di qaku ama mär qa masirhat toqor ama sägäk nävät iangärhäkt ama ngualäñngualañ aa murhämeska. ");
INSERT INTO uro_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Dap kre va ma Ngämuqa qat turha ama mran na angät murhämeska rhoqoräkt kärangätni i rhäqyerhäkt ngät däqäm bät ama etki dap kaku duququ inguna rhit päs ngät mät ama mudam dä mänia? Nak nga qaku ma Ngämuqa qat turhäm ngän mamär masirhat pa angät tpäs? Ai, aingän di ama gaini nä angän gatnanakt! ");
INSERT INTO uro_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Bä va qale ngän du angän snäng masirhat nani ama tmäs iva ngän däs ura ama rigi iva ngänit nakt. Nak kop kale qänäskänes ngän masirhat nani iarhongäkt. ");
INSERT INTO uro_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Inguna iarhakt kärarhae i qaku rhat nanakt nä ma Ngämuqa di arhä snängaqa masirhat sävät tärhong däkt dap angän mamäk di sa qat dräm i ngänit läk nani irhong. ");
INSERT INTO uro_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Dap kinak pa ngäni rhares pä ma Ngämuqa iva qat turäkt täm ngän dä qosaqi va qä von ngän dä iarhongäkt moekt.” ");
INSERT INTO uro_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Aingän ama guläñäm na ama sipsipkäna di qale ngänit len inguna angän mamäk di mär gem ga iva qä von ngän da ama Muräktpäm. ");
INSERT INTO uro_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mamär iva ngäni voda angän gärhong näkt ngäni von ama tläkta rha ama ligär. Bä nga rhoqoräkt dä ngänit täkmu ba nas na ama rhae iva nanokt anga ligär qärangätni i qaku mamär iva mava na ngät toqor ama mämägän dävuk ge ma Ngämuqa dä qaku mamär iva rhäksot na ngät bä va qaku mamär iva anga suaqa qä naing glaqot na ngät bä qaku anga gärhañ ngä naslava na ngät. ");
INSERT INTO uro_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Inguna äkt i sa qale angän mämägän e di qosaqi va qale gi snängaqa e.” ");
INSERT INTO uro_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mamär iva ngän durhämes näkt ama qarhap ngän mamär nani agini qärqäni iva ini ngä rhän näkt mamär iva angän lirhäng ngät dang basägos ");
INSERT INTO uro_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","iva ngän doqor ama gamoe qärarhani i qale rha nani arha morqa qärakni iva evär däm ga näva ama tmäski na ama rhitbodämnarha. Bä nga rhoqoräkt dä va ama qarhap ta iva nga i qat dän bä qät kut dä mamär iva rhi lir ti rhar mät ama tmongi bä ba qa. ");
INSERT INTO uro_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Va ama märmärgem ge iarhakt kärarhae ama morqa aa latta qärarhae i qale rha va aa rem gärarhae i nga arha morqa qa rhän bät a rha i qoki as tat nañäm nani a qa. Nguat tamän särhäm ngän na ama engäktki iva qa rhon mät ama boi qärangätni i rhit täkmu na ama tmäs sä ngät näkt pa qä ar sä rha sävät ama laiqa aa rhäkt näkt pa qa rhän bä qä rhatmät na ama tmäs bä ba rha. ");
INSERT INTO uro_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Va ama mär masirhat sage iarhakt ama morqa aa latta rhoqoräkt i nga arha morqa qa rhän bät a rha i qoki as kale rha rhoqoräkt i näma dä äkt bä qa rhän mäni ama mor qi ama bängagi ura näva ama umeqa. ");
INSERT INTO uro_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Dap ngänät dräm daerhom i ngakt bä ama vätka aa ik di sa vadi mai qat dräm iva vät agi a qäväläm dä va ama suaqa qa rhän dä sa vadi mai qaku qä naqyiradeng na aa vätka iva qä drukdäm bäm ga. ");
INSERT INTO uro_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aingän di mamär iva ngänit täkmu na nas mamär inguna ma Ruqa aa Emga va qa rhän bät ama qäväläm gärqomni i qaku ngän du angän snäng iva qa rhän bät a äm.” ");
INSERT INTO uro_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Dä ma Pita qa snanbät sä qa rhoqortäqyia, “Gua Engeska, nga sokt ngiat tamän särhäm ut nä rhangät täkt ama enge na ama siqutki ura ngiat tamän särha ama ruvek moe?” ");
INSERT INTO uro_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Dä ma Engeska qa muvät toqortäqyia, “Rhoqoräkt dä ngu lu agi a latka iaqäkt kärak iva qale qa ma ama qrot mäni ama lat dä aa mädräm ama mär ngät iaqäkt kärak iva aa morqa qa rhu qa ivakt iva qät lu vät aa latta i qät boda rha arha tmäs pät ama qunäga aa qävälap maräkt? ");
INSERT INTO uro_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Va ama märmärgem ge iaqäkt ama latka qärak i nga evär da aa morqa dä va qa rhän bät a qa i qat tualat toqoräkt. ");
INSERT INTO uro_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nguat tamän särhäm ngän na ama engäktki iva qa rhu qa ivakt iva qät lu vät aa qärhong moe va aa vätka. ");
INSERT INTO uro_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Dap ngakt bä iaqäkt ama latka qa rhamän särhäm mes doqortäqyia, ‘Gua morqa di qät tiläng bä sa qaku qa lir qa män’ dä qä nasäng i qä arhäktgyäm sa ama latta ama evop dä ama gamoe dap kat täs dä qät nakt bä guani na qa ");
INSERT INTO uro_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","dä va aa morqa qa rhän bät ama qunäga rhoqoräkt i qaku qa latka qat tu aa snäng iva qa rhän bät a qa bä vät ama qunäga aa qäväläm gärqomni i qaku qat dräm na äm. Dä va qa morqa qä sangäm na qa näkt pa qä qut na qa sävät ama ivärhäs ge iarhakt ama ruvek kärarhae i qaku rhat tualat na aa lat mamär. ");
INSERT INTO uro_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Näkt iaqäkt ama latka qärak i qat dräm mamär na aa morqa aa snängaqa näkt kaku qa rhäkmu na nas bä qaku qa mualat parhäm aa morqa aa snängaqa diva rhi arhäktgyäm sä qa masirhat. ");
INSERT INTO uro_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Dap ama latka qärakni i qaku qat dräm aa morqa aa snängaqa näkt kat tualat na ama lat kärangätni i mamär iva qä rha ama rhäksärhäm bät angät tpäs diva rhi arhäktgyäm sä qa maqälak. Iaqäkt kärak i sa rha von ga masirhat diva rhi nän nagem ga masirhat dap pa rhi nän masirhat mamär nage iaqäkt kärak i sa rha von ga masirhat mamär. ");
INSERT INTO uro_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ngua män ivakt iva ngua rhu ama mudämgi vät ama ivätki bä nani a ngo i sa vadi va qi nasäng i qiat dang! ");
INSERT INTO uro_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Sokt di as pa ngua rhon säda ama qäväläm angärha ron iva ngu rha ama baptais na ama tñäpki bä rhom däkt diva qale läm doqoräkt pät gu snängaqa bä dängdäng i äm ngä rhu angät släqyige vät a nas. ");
INSERT INTO uro_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mäniekt? Nga ngän du angän snäng i sa ngua män ivakt iva ngu voda ama bulap sävät ama ivätki? Nak kaku rhoqoräkt! Ngu qoar na ngän i nak sa ngua män sa ama matmät. ");
INSERT INTO uro_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mänasäng narhäkt bä rhävit diva anga ngärhäqyet na rha anga sägärhae diva matmät ta sävät a ne bä va anga dävaung na rha sävät ama udiom dä anga udiom sävät ama dävaung na rha. ");
INSERT INTO uro_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bä va matmät na ama ruvek iva anga ngätmamäk sävät ama ngärhoemga dä va anga ngärhoemga sävät ama ngätmamäk dä va anga ngätnanäk sävät ama ngärhuimgi dä va anga ngärhuimgi sävät ama ngätnanäk dä va anga ngätäväski sävät ama ngätkluqi dä va anga ngätkluqi sävät ama ngätäväski.” ");
INSERT INTO uro_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Dä ma Jisas ka qoar na ama guläñgi na ama ruvek toqortäqyia, “Qre va ngäni lu i ama eqoeqi qiat täranas na rhämone i ama qunäga qat don e dä ngänit lir ngänät dräm ngäni qoar toqortäqyia, ‘Va ama suigi qi säp’ dä qoki ama suigi qi säp. ");
INSERT INTO uro_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Dap ngakt bä ama laurqi qiat dän na rhänamuk näva ama qräk dä bäs ama ivärhäs dä ngäni qoar toqortäqyia, ‘Va aqärnas mät ama qunäga’ dä qoki aqärnas mät ka. ");
INSERT INTO uro_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Aingän gärarhani i ngän dualat sädä saqong, sa ngänät dräm iva ngän datnävämne mamär na ama muqunän sa ama rhodäm bät ama ivätki dä ama leqäs. Dap mäniekt bä qaku ngänät lu ñismäne sävät iarhongäkt pät tangät täkt ama rhodäm?” ");
INSERT INTO uro_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Mäniekt bä aingän maräkt di qaku mamär vät a ngän iva ngäni lu mamär nä iangärhäkt ama lat kärangät i ama räkt ngät? ");
INSERT INTO uro_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ngakt bä nga aung ga mu ama enge iva rha rhair na ngän ba ama muräkt dä mamär iva ngäni lir ngän det sagem ga bä va ngän duräkt mänguräp mes ngän na qa as pa ama muräkt angät kamäs. Inguna ngakt bä rha rhair na ngän ba ama muräkt dä varis ama matnävämnenaqa qä namu ngän ba ama ulaqimärhaarhäkt aa rhäkt bä va qa rhu ngän ba ama tpäskiarharhäng. ");
INSERT INTO uro_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Dä ngu qoar na ngän i qaku mamär iva vuk sä ngän bä dängdäng i ngän duvät na ama dändängini nä ini ama brasini.” ");
INSERT INTO uro_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Arhani ama ruvek di qale rha e vät iomäkt ama qäväläm bä rha qoaräs nä ma Jisas sävät ama Galiliqäna qärarhani i ma Pailat ka modämne na arhä biaska ngä na arhä vodämes angät biaska rhoqoräkt i qa veng da. ");
INSERT INTO uro_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Dä ma Jisas ka muvät toqortäqyia, “Nga ngän du angän snäng i iarhakt ama Galiliqäna di ama vu rha mamär bä äkt i avuqi na rha masirhat dap arhani ama Galiliqäna moe di qaku? ");
INSERT INTO uro_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ngu qoar na ngän i qaku! Dap aingän di ngakt bä qaku ngän nanäpgoer na nas di qosaqi va qäbäs na ngän. ");
INSERT INTO uro_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ura sävät iarhakt kä ngärhäqyisem da qäraet da dävaung na rha qärarhae i sa arpus na ama näski sävät arha rhäng e vät ama ivärhäs ma Siloam bä rha ñäp di nga ngän du angän snäng i arhani nae ma Jerusalem moe di rha e vät arha qar sa arha vuirhong? ");
INSERT INTO uro_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ngu qoar na ngän i qaku! Dap aingän di ngakt bä qaku ngän nanäpgoer na nas di qosaqi va qäbäs na ngän.” ");
INSERT INTO uro_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Dä qa qoar na rha na ama enge na ama siqutki rhoqortäqyia, “Ama ruqa qa qutnanokt ama gosaqi vät aa etki na ama wain näkt ka met kät ñäm nani anga gavam sävät at täqän bä qop kaku qa lu agung. ");
INSERT INTO uro_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Dä qa qoar na ama ruqa qärakni i qät lu vät ama etki rhoqortäqyia, ‘Sa ama dävaung ama qoeo nä rhak täkt i ngut täqäsdämne sarhe bä ngut ñäm sävät ama gosaqi iva nani anga gavam dä qop kaku agung dä ngi rhäp mä qi samäk! Mäniekt bä qit päs nas pät tos täkt ama ivärhäs?’” ");
INSERT INTO uro_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Dä qärak ka muvät toqortäqyia, ‘Morqa, as kali qi vät aung anga quiaqa anga sägäk dap pa ngu nges namet a qi näkt ngu rhon na anga ivätki anga mär qi anga qärhopka väm gi. ");
INSERT INTO uro_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ngakt bä nga qi sa arha anga gavam bät tak navuk diva mamär! Dap nga qaku dä va rhi rhäp mä qi samäk.’” ");
INSERT INTO uro_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Vät akni ama Sabat dä ma Jisas kä su va aktni ama mämairqi ");
INSERT INTO uro_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","dap aktni ama ruqi di sävät a qi e qäraktni i ama iauska qa vakt pät a qi vät ama ngärhäqyisem da qäraet da dävaung na ama qoeo. Sokt kiat nagär bä qaku mamär vät a qi iva qi namurän da arha rhängait. ");
INSERT INTO uro_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Bä nga ma Jisas ka lu qi dä qa mes ki bä qia met sagem ga dä qä qoar na qi rhoqortäqyia, “Rhaktni, rhäkt di sa isiska vät a nge nämät iaqäkt gi märänga.” ");
INSERT INTO uro_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Dä qa mu aa rhäkt pät a qi bä qia murän däm mes masägos dä qia ansäs sage ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Dä ama narhoerqa näva ama mämairqi di uraqi da aa ron inguna ma Jisas ka mumäräs pät a qi vät ama Sabat dä qä qoar na ama ruvek toqortäqyia, “Ama ngärhäqyet da sägäk di ama lat angät kunäng. Bä va ngänät dän bät iangärhäkt ama qunäng bä ngänit ta ama mumäräspät dap kaku vät ama Sabat.” ");
INSERT INTO uro_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Dä ma Engeska qa muvät pät a qa rhoqortäqyia, “Aingän gärarhani i ngän dualat sädä saqong, ngäda qaku aung nävät a ngän sa qa von da anga rigi vät ama Sabat bä ba aa bulmakao ura ama donki vät ama qäväläm gärqomni i aqäsä qa? ");
INSERT INTO uro_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Dä nga qaku mamär iva rhi namuisiska vät takt täkt ama ruqi ma Abraham aa imgi nämät arha ispätka vät ama Sabat käraktni i sa ma Sämga qa is pät a qi vät ama ngärhäqyisem da qäraet da dävaung na ama qoeo?” ");
INSERT INTO uro_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bä nga qa märhamän doqoräkt dä aa ikkäna moe di aqlus pät a rha dap ama ruvek di nak mär gem da nävät iarhongäkt ama märirhong mamär qärqärhongni i sa qa mualat nä irhong. ");
INSERT INTO uro_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Dä ma Jisas kä snanbät toqortäqyia, “Ngu lu ma Ngämuqa aa Muräktpäm di ngät toqor mäniekt? Ngu lu va ngua rhuqut täm ngät sävät agiqa? ");
INSERT INTO uro_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ngät di ngät toqor ama mastard aa gavämini ama gaini mamär qärqäni i ama ruqa qa rha ini bä qa qutnanokt ini vät aa etki. Näkt ini ngä ir ma ama ngämuga näkt ama isäm nämät ama leqäs ngä rhäk angärha vät pät aa rhäkt.” ");
INSERT INTO uro_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Dä saqi as ka snanbät toqortäqyia, “Ngu lu va ngua rhuqut tä ma Ngämuqa aa Muräktpäm sävät agiqa? ");
INSERT INTO uro_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ngät di ngät toqor ama yis käraktni i ama ruqi qia rha qi bä qia mu qi va ama mor ngät ama plaua näkt kia näpgoer na ngät päm ne bä dängdäng i ama yis kia mon säva ama qopkopki moe.” ");
INSERT INTO uro_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Dä ma Jisas ka met mät ama värhap ama mor ap dä ama lel ap bä qä su dap kat tet parhäm aa iska iva sae ma Jerusalem. ");
INSERT INTO uro_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Dä akni ama ruqa qa snanbät sä qa rhoqortäqyia, “Gua Engeska, nga va ma Ngämuqa sokt ka rhumaiar anga marheka na rha anga ruvek?” Dä ma Jisas ka qoar na rha rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ngän däqäne dä mamär i ngän don mät ama gaini na qi ama tmongi. Ngu qoar na ngän doqoräkt inguna ama rhäqäp na rha diva rhi siqut iva rha rhon sokt diva qaku rhi namäqäne dä mamär. ");
INSERT INTO uro_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ngakt bä nga ama ngärhik nävä iaqäkt ama vätka qa rhäranas äkt bä qä väs mät ama tmongi dä va ngän dair inamäk dalek bä va ngänit kut dap pa ngänät naingbät toqortäqyia, ‘Aurha morqa, ngi rhar nanokt ut.’” “Sokt diva qa rhuvät pät a rha rhoqortäqyia, ‘Qaku nguat dräm a ngän bä qaku nguat dräm i sa ngän män na qoe.’” ");
INSERT INTO uro_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Dä va ngäni qoar na qa rhoqortäqyia, ‘Ut mäs dä ut nakt ut na nge dä sa ngia mualat na ama rhisu varhäm aurha is mänguräp mä ut.’” ");
INSERT INTO uro_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Sokt diva qa rhuvät toqortäqyia, ‘Qaku nguat dräm a ngän bä qaku nguat dräm i ngän män na qoe. Ngän det nävät a ngo aingän gärarhae i ngän dualat na ama vu ngät ama lat!’” ");
INSERT INTO uro_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Vät iosäkt ama ivärhäs diva rhat tuqaia dä va rhit nes arhä qeng angärha rem na ne rhoqoräkt i rhi lu ma Abraham gä nä ma Aisak dä ma Jekop näkt sävät ma Ngämuqa aa vämginarha moe vä ma Ngämuqa aa Muräktpäm dap aingän di sa rha rhon na ngän sä dalek. ");
INSERT INTO uro_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ama ruvek diva rha rhän nävät ama ivätki at tärhäkt moe bä va rhi rha arhä släqyimek pa ama tmäski vä ma Ngämuqa aa Muräktpäm. ");
INSERT INTO uro_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Bä nak pa iarhakt kärarhae i rhi rhoer diva dängdäng na rha mamär dap kärarhani i dängdäng na rha mamär diva rhi rhoer.” ");
INSERT INTO uro_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Vät iomäkt ama qäväläm dä arhani ama Farisiqäna rha män ge ma Jisas dä rha qoar na qa rhoqortäqyia, “Ngia rhäranas narhäkt bä ngia rhet sävät guaäs anga ivärhäs. Ma Herot nani a qa iva qä veng nge.” ");
INSERT INTO uro_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Dä qa muvät toqortäqyia, “Ngän det bä ngäni qoar nä iaqäkt ama muräpka ama iras mät ka rhoqortäqyia, ‘Aingo diva ngut kutmäs ama iaus dä nguat tumäräs pät ama ruvek täkt bä duququ bä vanaia bä va ngua rhäqäne dä mamär nä gua lat.’ ");
INSERT INTO uro_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Näma dä äkt bä rhoqor mäniekt sokt di qoki as pa nguat tualat täkt bä duququ bä vanaia inguna qaku maräkt toqoräkt iva ma Ngämuqa aa vämginaqa qä ñäp sañis nä ma Jerusalem.” ");
INSERT INTO uro_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ai, Jerusalem, Jerusalem, ama värhäm gärqomni i ngiat dräm ngi veng ma Ngämuqa aa vämginarha dap ngit tumät nä ma Ngämuqa aa engevärharha na ama dui bä rhit ñäp. Ama rhäqäp nä imek di sa nani a ngo iva ngu imum gia ruvek sävät a ne i ngo rhoqor ama duraktki qäraktni i qi imum at toes säva at kivaet angärha rem dä qaku inguna qaku nani a nge. ");
INSERT INTO uro_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","As ngi lu i gia vätki di sa rha qyiradeng na qi. Näkt ngu qoar na nge i saqi as pa qaku ngi nalu ngo bä dängdäng bät iomäkt ama qäväläm gärqomni iva ngi qoar toqortäqyia, ‘Mamär iva ama modämne sävät tak täkt kärak i qat dän nävät ma Engeska ma Ngämuqa aa ngärhipki.’” ");
INSERT INTO uro_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Vät akni ama Sabat dä ma Jisas ka met säva ama moräs na qa ama Farisiqa aa vätka ivakt iva qa äs nae dä sa arhä saqong mamär vät a qa. ");
INSERT INTO uro_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Dap akni ama ruqa di sävät a qa e glaqot nä ma Jisas kärakni i ama rämgi na ama rip kia män bät a qa bä rip da aa qar ngä na aa rhäkt. ");
INSERT INTO uro_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Dä ma Jisas ka snanbät sa ama Farisiqäna rhi na ama mädrämda mamär sa ama muräkt toqortäqyia, “Nga maräkt toqoräkt iva aung gat tumäräspät pät ama Sabat ura qaku?” ");
INSERT INTO uro_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Dä qop mänadin däm da. Dä soknga qa sangar qa ruqa bä qa mumäräs pät a qa näkt ka rhäk na qa bä qa met. ");
INSERT INTO uro_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Dä qa snanbät sä rha rhoqortäqyia, “Auge nävät a ngän gärak i aa anga emga ura anga bulmakao di arpus na qa sämät anga qotnaqoanga vät ama Sabat dä nga va qaku ngi nalir ngi nardrän na qa nae?” ");
INSERT INTO uro_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Dä qop kaku mamär vät a rha iva rha rhamän bät guani. ");
INSERT INTO uro_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Bä nga ma Jisas ka lu i iarhakt kärarhae i rha män säva ama tmäski di sa rha rha ama moräs nä imek ama mämugunimek dä ngärhaväm bät ama laiqa aa rhäkt dä qa qoar na rha na ama enge na ama siqutki rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Qre va akni ama ruqa qä ar sä ngän säva ama tmäski na ama rhitbodämnarha dä qale ngänit ta ama moräs nä imek ama mämugunimek dä ngärhaväm inguna sai dä as akni qa e i qa di ama moräs na qa daver mä ngän gärakni i sa qa ar sä qa. ");
INSERT INTO uro_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Inguna ngakt bä nga qa rhän dä iaqäkt kärak i mai qre qa ar sä ngän moe diva qa rhet bä sagem ngän dä va qä qoar na ngän doqortäqyia, ‘Ngän det nae nanokt taerhak.’ Dä va aqlus pät a ngän inguna va ngäni rha ama mämugunimek ama gaini nä imek dä ngärhes. ");
INSERT INTO uro_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Dap kre va rhi ar sä ngän dä mamär iva ngäni rha ama gaini nä imek ama mämugunimek dä ngärhes iva ngakt bä qärak i qä ar sä ngän ga rhän dä va qä qoar na ngän doqortäqyia, ‘Gua ruavek, ngäni rut pit säp iamek puk ama mämugunimek ama moräs nä imek dä ngärhaväm.’ Rhoqoräkt dä va qä sämamor na ngän mänguräp angäna ruavek moe va ama tmäski. ");
INSERT INTO uro_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Inguna aung gärakni i qät sämamor na nas diva rhi säm ama gaini na qa dap iaqäkt kärak i qät säm ama gaini na nas diva rhi sämamor na qa.” ");
INSERT INTO uro_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Dä ma Jisas ka qoar nä qärak i sa qa ar sä qa rhoqortäqyia, “Qre va ngit boda ama tmäs mäniqunäng ura näp bängang dä qale ngi nar sä gia ruavek ura gia matpek ura gia läktpek ura gi qärhae bä sävät iarhakt kärarhae i rhat tas glaqot na nge qärarhani i ama qärhong bät a rha inguna nasot dä varis ti nar sä nge i qosaqi rha rhuvät pät a nas na nge. ");
INSERT INTO uro_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Dap kinak kre va ngia rhualat nä gia tmäski dä ngi ar sa ama tläkta dä ama vaktpärharha dä ama vävarhämda dä ama säsurta ");
INSERT INTO uro_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","dä va ngi rha ama modämne inguna qaku mamär iva rhi namuvät pät a nas na nge. Va ngi rha ama modämne qre va ma Ngämuqa qa rhuvät pät a nge vät iomäkt ama qäväläm gärqomni iva ama räkt ta ama ruvek ta rhäranas nämät ama tñäpki.” ");
INSERT INTO uro_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Bä nga akni ama ruqa nävät iarhakt kärarhae i rhi nä ma Jisas kale rha bät ama laiqa aa rhäkt di qa nari rhoqoräkt dä qa qoar nä ma Jisas toqortäqyia, “Ama märmärgem sage qärak iva qa äs pä iaqyäkt ama tmäski mirhup pä ma Ngämuqa aa Muräktpäm.” ");
INSERT INTO uro_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Dä ma Jisas ka muvät toqortäqyia, “Akni ama ruqa di qät täkmu na aa tmäski dä qa rhäkne sävät ama rhäqäp na rha ama ruvek iva rha rhän. ");
INSERT INTO uro_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bä sa nga qa rhäkmu dä mamär dä qa rhäk na aa latka iva qä qoaräs nä iarhakt kärarhae i sa qa rhäkne nani a rha rhoqortäqyia, ‘Ngäni ang i sä iarhongäkt moe di sa ngua rhäkmu nä irhong.’” ");
INSERT INTO uro_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Di nak ta moe rha nasäng i rhi qoaräs i qaku isiska vät a rha. Akni ama narhoerqa di qa qoar toqortäqyia, ‘Nak kop as ngua vodäm bät ama ivärhäm bä va ngua rhet sae ivakt iva ngu lu äm. Bä mamär iva ngi rhares pät gua rhäng.’” ");
INSERT INTO uro_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Dä akni qä qoar toqortäqyia, ‘Nak kop as ngua vodäm bät ama bulmakaoqäna ama ngärhäqyisem bä va as nguat tet toqor täkt iva ngu siqut na ngät pät a lat. Bä mamär iva ngi rhares pät gua rhäng.’” ");
INSERT INTO uro_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Dä qosaqi akni qä qoar toqortäqyia, ‘Nak kop as ta vodäm na ngo rhoqor täkt bä qaku mamär iva ngu namet.’” ");
INSERT INTO uro_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Dä evär da ama latka bä qa sameng nä iarhongäkt bä ba aa morqa. Dä soknga aa morqa di qär qur masirhat dä qa rhäk na aa latka rhoqortäqyia, ‘Ngi lir ngia rhet parhäm ama is ama mor ngät bä varhäm ama is ama gaini na ngät mät ama värhäm bä ngi rhäqoar sa ama tläkta dä ama vaktpärharha dä ama säsurta dä ama vävarhämda.’” ");
INSERT INTO uro_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Dä ama latka qa muvät toqortäqyia, ‘Morqa, sa gi rhäkne di sa ngä met sokt di qop as masirhat na ama släqyimek iva nani guavek.’” ");
INSERT INTO uro_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Dä ama morqa qa qoar na aa latka rhoqortäqyia, ‘Ngia rhet bä sämäni ama is ama mor ngät bä varhäm ama isitnäk gläius tage rhage bä ngi rhäqoar sa ama ruvek iva rhi rhäqäp gua vätka. ");
INSERT INTO uro_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ngu qoar na ngän iva qaku aung nävät iarhakt kärarhae i sa mai ngua rhäkne nani a rha narhoer qä namäs näp gua tmäski.’” ");
INSERT INTO uro_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ama gulañ na ama ruvek di rhi nä ma Jisas tat tet. Qa rhong bät a nas sävät a rha dä qä qoar toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ngakt bä aung anga ruqa qat tet sagem ngo sokt di qaku qa rhäkmu na nas iva qä naqyiradeng na aa mam dä aa nan bä aa egutki dä aa es dä aa matpek dä aa läktpek bä qosaqi aa iar di qaku mamär vät a qa iva qa rhän i gu mudäsaqongga na qa. ");
INSERT INTO uro_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","“Bä auge qärak i qaku qät ta aa sämänanamuqa maräkt näkt kät päs gua rhäng di qaku mamär vät a qa iva qä namän i gu mudäsaqongga na qa.” ");
INSERT INTO uro_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ngakt bä nga aung nävät a ngän di nani a qa iva qä rhäk pät anga vätka dä mänia, nga qaku mamär iva as ka rhuqun narhoer bä qä siqut iva qä rhodäm nä iangärhäkt ama ligär qärangät iva qä rhar sä ngät pät ama vätka bä qoki va qä rhäksot na qa? ");
INSERT INTO uro_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Inguna ngakt bä nga qa rhu ama vätka aa ribit näkt kaku mamär iva qä narhäksot na qa dä ama ruvek kärarhani i rhat lu iaqäkt ama vätka diva rhi nasäng iva rhat tuma qa ");
INSERT INTO uro_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","bä va rhat tamän doqortäqyia, ‘Rhak täkt ama ruqa qa nasäng iva qat tair na ama vätka näkt kaku qa mäqäne dä mamär i qä rhäksot na qa.’ ");
INSERT INTO uro_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ura ngakt bä nga anga vitnaqa di sa qorhäs iva qa rhet sämät ama ulaqi iva sävät akni ama vitnaqa dä mänia? Nga va qaku qa rhuqun narhoer bä qa rhu aa snäng ivar mamär vät a qa qä na aa ngärhäqyisem ama tausengäna na ama ulaqimärharhärhäkt iva rha rhän näp akni aa uväs kärakni i aa ruqa ama rhäk täm ga ama tausengäna? ");
INSERT INTO uro_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ngakt bä qat tu aa snäng i qaku mamär vät a qa dä va qä rhäk na anga engevärharha sage akni ama vitnaqa sa anga enge na ama bulap toqoräkt i as kale qa gläius. ");
INSERT INTO uro_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Dä qosaqi rhoqorne sävät iaqäkt kärak i qaku qä navoda aa qärhong moe diva qaku mamär iva qa rhän i gu mudäsaqongga na qa.” ");
INSERT INTO uro_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ama qyiräpki di ama mär qi sokt di ngakt bä sa rhäksot na at märmät dä ngu lu va saqi as arha anga märmät ngä rhän doqor mäniekt? ");
INSERT INTO uro_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Qi di qaku ama mär qi iva sävät ama ivätki ura va sävät ama angi na ama bulmakaoqäna angärha snok dap ki diva rhi rhon na qi. Iaqäkt kärak i nani a qa iva qunäga vät a qa sä gua enge di mamär iva qat nari mamär.” ");
INSERT INTO uro_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Maos dä väspästämne na ama ruvek kärarhani i rhit ta ama takes dä arhani ama vu rha ama ruvek bä rhat nari ma Jisas. ");
INSERT INTO uro_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Dap ama Farisiqäna rhi na ama Skraipkäna di rhat tamängus toqortäqyia, “Rhak täkt ama ruqa di qä rhar sa ama vu rha ama ruvek bä qat täs kä na rha.” ");
INSERT INTO uro_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dä ma Jisas kä qoar na rha na ama enge na ama siqutki rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ngakt bä nga ak nävät a ngän di aa anga handret na anga sipsipkäna näkt musäng sa ama sägäk dä mänia? Nga qaku qä namet daqule angätni ama 99 na ama sipsipkäna va ama mran ba ama maläs dap pa qa rhet nasot iaqäkt kärak i sa musäng sä qa bä dängdäng i qa rhän bät a qa? ");
INSERT INTO uro_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Näkt ngakt bä qa rhän bät a qa dä va qa rhu qa da aa lang bä qa rhet sä qa sa ama märmärgem. ");
INSERT INTO uro_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Bä nga va qa rhän ba vät dä qa rhes aa ruavek ti na arhani qärarhani i rhat tas glaqot na qa bä va västämne na rha näkt pa qä qoar na rha rhoqortäqyia, ‘Mär gem ut inguna sa ngua män bät gu sipsip kärak i mäqi musäng sä qa!’ ");
INSERT INTO uro_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Bä va ngu qoar na ngän i rhoqor tangät täkt ama enge na ama siqutki diva ama mor ngät ama märmärgem dävuk da ama usäpki arha ron nävät ama vuqa ama sägäk kärakni i qa näpgoer na nas näva ama 99 na rha ama märta arhä väs kärarhani i sa mudu rha näpgoer na nas.” ");
INSERT INTO uro_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ura qosaqi ngakt bä nga anga ruqi di arha anga ngärhäqyisem ama qunäng angät titsek angät ligärigleng näkt kia musäng sa age, dä mänia? Nga qaku qi namudäm säda anga lirhäga aa väm näkt ki naedäm ba arha vätka dap ki natñäm mamär bä dängdäng i qia rhän bät ige? ");
INSERT INTO uro_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bä nga qia rhän bät ige dä va qia rhes arha ruavek ama evop dä iarhakt kärarhae i rhat tas glaqot na qi sävät a ne näkt pa qi qoar na rha toqortäqyia, ‘Mär gem ut inguna sa ngua män bät gu ligärige qärqige i mäqi musäng sä ige.’ ");
INSERT INTO uro_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Bä va ngu qoar na ngän i nak kop toqorne rhoqoräkt i ama märmärgem masirhat nage ma Ngämuqa aa enselqäna nävät ama vuqa ama sägäk kärakni i sa qa näpgoer na nas.” ");
INSERT INTO uro_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Dä qosaqi ma Jisas kä qoar toqortäqyia, “Akni ama ruqa di aa imiom ama udiom. ");
INSERT INTO uro_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ama ngärhaläktka qä qoar na aa mamäk toqortäqyia, ‘Mamga, ngi von ngo rhä gu gunän gärangätni iva ngu rha ngät nasot a nge.’ Dä soknga qa matmät aa gunän bä ba iom.” ");
INSERT INTO uro_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Nak kop kaku qale qale dä ama ngärhaläktka qa västämne na aa mämägän näkt ka met sämät aomni ama värhäm gläius bä qa rhar sa aa mämägän säda ama iar ama vu ngät angärha ron. ");
INSERT INTO uro_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Bä nga nasot i sa qa rhar sä iangärhäkt aa mämägän dä ama mor qa ama tläqa qa män na ama qärhuqi mät iaqäkt ama ngärhäktka moe bä qärak di qä nasäng iva qat don säda ama tläqa aa ron. ");
INSERT INTO uro_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","“Dä soknga qa met bä qa nokpät sä nas ge ama ruqa qärakni i qat muqun bät iaqäkt ama ngärhäktka dä qa ruqa qa rhäk na qa iva qät lu vät aa vlam. ");
INSERT INTO uro_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nani a qa masirhat iva qä äs anga vlam angät tkutäm sokt di qaku aung ga von ga rhä guani.” ");
INSERT INTO uro_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Bä nak as nga qa rhäksärhäm mes dä qä qoar toqortäqyia, ‘Gu mam aa latta ama rhäqäp na rha qärarhani i qat dräm gät sek mä rha di rhat täs ama tmäs masirhat bä rhat täs nävät angärha rhäng dap aingo rhe i qorhäs iva ngu ñäp! ");
INSERT INTO uro_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Va ngua rhäranas bä va ngua rhet sage gu mam dä va ngu qoaräs na qa rhoqortäqyia, “Mamga, sa ngua slava sage ma Ngämuqa dä sagem nge. ");
INSERT INTO uro_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Sa qaku ama märqa na ngo iva ngiat tes ngo i ngia emga dap ngiat tualat sä ngo rhoqor gia latta qärarhani i ngiat dräm ngit sek mä rha.” ’ ");
INSERT INTO uro_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Dä soknga qa märanas bä qa met sage aa mam. Bä as nga qale qa gläius dap kinak sa aa mamäk ka lu qa dä rhäqäp ka na ama lavuqi sävät a qa dä qa ang sage aa emga bä qa qärhäktgyäm ga näkt ka vop pa aa sdäm.” ");
INSERT INTO uro_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Dä ama ngärhoemga qa qoar na qa rhoqortäqyia, ‘Mam, sa ngua slava sage ma Ngämuqa dä sagem nge. Sa qaku ama märqa na ngo iva ngiat tes ngo i ngia emga.’” ");
INSERT INTO uro_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Dap kinak ama ngätmamäk kä qoar na aa latta rhoqortäqyia, ‘Ngäni lir ngäni rha anga uiu qi anga mär qi anga boiqi bä ngän donmät pät a qa. Dä ngän du anga ring mäni aa rhäktka dä ngän du anga sandal vät aa qäriglem. ");
INSERT INTO uro_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ngäni rha ama bulmakao aa ebäm gärqomni i ngän märmor äm bä ama enges äm näkt ngäni veng äm. Aut, u rhualat na ama tmäski bä urhi qok. ");
INSERT INTO uro_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Inguna rhak täkt ngua emga di sa qa ñäp näkt saqi sa ama iar qa. Mudu musäng sä qa näkt saqi sa qa män.’ Dä soknga rha nasäng na arhä märmärgem.” ");
INSERT INTO uro_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Dap toqoräkt di qale ama ngärhamatka vät a lat. Näkt nga qat tet bä sa glaqot na ama vätka dä qa nari ama mabuirhong dä ama main. ");
INSERT INTO uro_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Dä qa mes akni ama latka bä qa snanbät sä qa i mäniekt toqoräkt. ");
INSERT INTO uro_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Dä qa muvät pät a qa rhoqortäqyia, ‘Sa gia läktka qa män bä gi mam ga veng ama enges äm ama bulmakao aa ebäm inguna gia läktka evär däm ga bä märäs pät a qa bä mamär na qa.’” ");
INSERT INTO uro_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Dä ama ngärhamatka di uraqi da aa ron dä qa mer qä namon säva vät. “Dä aa mamäk puk sä qa bä qat naing bät a qa iva qa rhon säva vät. ");
INSERT INTO uro_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Dä qa muvät pät aa mamäk toqortäqyia, ‘Ngi lu! Vät tangät namäk ama qoeo moe di sa nguat tualat masirhat mamär bä ba nge dä qaku ngia von ngo nak kop ta anga rhoemga anga meme iva mär gem ngo ngu nä gua ruavek. ");
INSERT INTO uro_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Dap nga rhaerhak ngia emga qärak i sa qa rhar sa aa qärhong gä na ama qavat ta ama evop di nga qa män ba vät dä sa ngia veng ama enges äm ama bulmakao aa ebäm bä ba qa!’” ");
INSERT INTO uro_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Dä ama ngätmamäk kä qoaräs na qa rhoqortäqyia, ‘Ngua emga, ainge di vasägos dä sa qale nge gem ngo bä iarhongäkt kärqärhong moe i gu qärhong di gi qärhong iarhongäkt. ");
INSERT INTO uro_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dap mamär iva urhi qok bä märmär gem ut inguna rhaerhak gia läktka di sa qa ñäp näkt saqi sa ama iar qa. Sa mudu musäng sä qa näkt saqi sa evär däm ga.’” ");
INSERT INTO uro_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ma Jisas ka qoar na aa mudäsaqongda rhoqortäqyia, “Akni ama qärhongbärhaqa di maos dä ama enge ngä män bät a qa sävät aa lat angät narhoerqa i qät tar sä qä qärhongbärhaqa aa qärhong. ");
INSERT INTO uro_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Dä soknga qa rhäkne nani a qa bä qa snanbät sä qa rhoqortäqyia, ‘Agini rhäni rhäkt i ngua nari sävät a nge sä ini? Ngi säm anga enge sävät gia lat angät gavämgi inguna va qaku ama lat angät narhoerqa na nge saqi as.’” ");
INSERT INTO uro_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Dä ama lat angät narhoerqa qa mu aa snäng doqortäqyia, ‘Va ngua mäsana rhäkt? Gua morqa di qät täksot na ama lat nävät a ngo. Qaku gu nga qrot iva nguat tualat na ama qrot ngät ama lat dä aqlus pät a ngo ngut nokpät. ");
INSERT INTO uro_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Rhäkt di nguat dräm iva ngua rhualat toqoräkt. Va ngua rhualat na anga märini iva ngakt bä nga rhi rhäksot na ngo nävät gua lat te dä va nasot dä mamär iva ama ruvek ti rhar sä ngo säva arha vät.’” ");
INSERT INTO uro_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Dä qa mes ama ruvek kärarhani i mudu aa morqa qa von da rha arhongni aa qärhong iva nasot dä va rha rhuvät. Dä qa snanbät sa ama narhoerqa ama ruqa rhoqortäqyia, ‘Sa ngia rha ama mämänia nä irhong nage gua morqa?’” ");
INSERT INTO uro_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Dä qa muvät toqortäqyia, ‘Ama dävaung ama tausengäna da ama ngärhäqyet da udiom ama handretkäna na ama litaqäna na ama oel nävät ama olip angät gavam.’” “Dä ama lat angät narhoerqa qä qoar na qa rhoqortäqyia, ‘Ngi rha gia abuqit sä gi dinau bä ngi lir ngia rhuqun näkt ngi rhar ama dävaung ama tausengäna da ama ngärhäqyet da udiom ama handretkäna na ama litaqäna na ama oel dap ngi säm ama sägäk ama tausen da ama ngärhäqyet da dävaung ama handretkäna da ama ruiom ama udiom da ama ngärhäqyisem na ama litaqäna.’” ");
INSERT INTO uro_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Bä äkt dä qa snanbät sa ama udiom na qa rhoqortäqyia, ‘Dap ainge di sa ngia rha ama mämänia nä irhong nage gua morqa?’” “Dä qa muvät toqortäqyia, ‘Ama ngärhäqyisem da levaet ama tausengäna na ama urat na ama tmäs.’” “Dä ama lat angät narhoerqa qä qoar na qa rhoqortäqyia, ‘Ngi rha gia abuqit sä gi dinau bä ngi rhar ama ngärhäqyisem da levaet ama tausengäna na ama urat dap ngi säm ama ngärhäqyet da udiom ama tausengäna na ama urat na ama tmäs.’ ");
INSERT INTO uro_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Mamär dä aa morqa qa räm i ama latta arhä narhoerqa ama räpmät na qa sa qa slava na qa. Näma dä qat dräm doqoräkt sokt di qa an sä qa nävät aa mädräm ama mär ngät inguna qa muräkt mamär narhoer. Inguna ama ruvek nämäni rhaktni ama ivätki di rhat tualat na ama mädräm ama mär ngät masirhat sa arha ruvek bä rha män näva ama ruvek arhä väs kärarhani i rha näda ama neraqa aa ron sa arhä mädräm ama mär ngät. ");
INSERT INTO uro_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ngu qoar na ngän i mamär iva ngän dualat na ama ivätki at mämägän iva ngänit säm angän anga ruavek sävät a nas iva ngakt bä nga rhäksot na ngät dä va rhi ar sä ngän säva ama mämugunäs ama sok tä bäs. ");
INSERT INTO uro_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Auge qärak i mamär vät a qa iva qa rhualat mamär na ama gaini di qosaqi mamär vät a qa iva qa rhualat mamär na ama moräm dap auge qärak i qaku ama saengäktka na qa sa ama gaini diva qaku ama saengäktka na qa sa ama moräm. ");
INSERT INTO uro_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Dä ngakt bä nga qaku ama engäktkinarha na ngän sa angäna lat sa ama ivätki at mämägän dä ngu lu va auge qat nanakt na ngän sa ama engäktki na ngät ama mämägän na rhävuk? ");
INSERT INTO uro_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bä ngakt bä nga qaku ama engäktkinarha na ngän sa akni aa qärhong dä ngu lu va auge qä von ngän da anga qärhong iva ngän sä irhong?” ");
INSERT INTO uro_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Qaku mamär vät ama latka iva qat tualat bä ba ama udiom ama moriom inguna qa diva ama vu dä aa ron sävät akni dap pa aa snäng bät akni ura va qä vodäm mes sage akni dä va ama vu dä aa ron sävät akni. Qaku mamär vät a ngän iva ngän dualat pä ma Ngämuqa aa rem dä qosaqi pa ama ligär angärha rem.” ");
INSERT INTO uro_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ama Farisiqäna qärarhani i arhä snäng bät ama ligär di nga rha nari rhärhong däkt dä rhat tumä ma Jisas. ");
INSERT INTO uro_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Dä qä qoar na rha rhoqortäqyia, “Aingän di qärarhani na ngän i ngän dualat masirhat iva ama ruvek tat lu i ama räkt ta na ngän sokt di ma Ngämuqa qat dräm angän snängaqa. Agini qärqäni i ama vit nä ini ge ama ruvek di ama vu ini mamär dä ma Ngämuqa aa saqong.” ");
INSERT INTO uro_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ama Muräkt nage ma Ngämuqa dä ama enge nage aa vämginarha di sa rhi sameng na ngät bä dängdäng i ma Jon ama Baptais ka män. Bä nävät iangärhäkt ama rhodäm dä ama sameng ama mär ngät sävät ma Ngämuqa aa Muräktpäm di rhi sameng na ngät bä ama ruvek moe di rhäktuk pät a rha i rhit kyir mä ne ivakt iva rha rhon säva ama Muräktpäm. ");
INSERT INTO uro_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Märmärsäs iva qäbäs na ama usäpki dä ama ivätki dap kaku mamär iva qäbäs na anga gaini mamär anga muqunänini nämäni ma Ngämuqa aa Muräkt.” ");
INSERT INTO uro_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Aung gärakni i qa qutmäs aa egutki bä qa mät aktni di qä qavatnävätlägut bä aung gärakni i qa mät ama evopki qäraktni i qia qutmäs arha egutka di qi qavatnävätlägut.” ");
INSERT INTO uro_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Maos dä qale akni ama qärhongbärhaqa. Näkt iaqäkt ama qärhongbärhaqa di qat don mät ama qärhongbärharha arhä boi näkt kale qa i amämägän sä qa vasägos. ");
INSERT INTO uro_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mät aa tmongi di qale akni ama tläqa qärakni i rhat tes ka i ma Lasarus i rhäqäp na ama bias pät a qa ");
INSERT INTO uro_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","näkt pasägos dä nani a qa masirhat iva qat täs ama tmäs kärangätni i arharpus nä ngät nävät ama qärhongbärhaqa aa laiqa. Dä ama im ngät dän bä ngärhi qik mät aa bias.” ");
INSERT INTO uro_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Näkt ama qäväläm ngä män bä ama tläqa qa ñäp dä ama enselqäna rha rha qa sädä ma Abraham aa sdäm. “Ama qärhongbärhaqa di qosaqi qa ñäp bä rha sasärhäm ga. ");
INSERT INTO uro_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Bä qale qa vät ama ñäpta arhä ivärhäs dä qa ñäm bävit dä qa lu ma Abraham gläius i qale ma Lasarus da aa sdäm. ");
INSERT INTO uro_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Dä qa näs sävät a qa rhoqortäqyia, ‘Abraham gu mam, ngi lavuqi na ngo dä ngi rhäk nä ma Lasarus ivakt iva qä rhäk ama gaini vuk da aa rhäktka aa uväs pa ama rigi näkt ka rhu vät gu qoebäñga ivakt iva bok däm ga inguna qale ngo rhe mät ama ruanini ama mor ini mamär mät tos ama mudäbäs.’” ");
INSERT INTO uro_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Dä qinak ma Abraham ga muvät toqortäqyia, ‘Ngua emga, ngiat dräm i mudu vät gi qunäng nä gia iar dä ngit ta ama märirhong dap ma Lasarus di avuqi sä qa dap täkt di mänamär sä qa rhe dap ainge di qale nge mät ama ruanini ama mor ini mamär. ");
INSERT INTO uro_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Dä aomni di sa rha mu ama ar a qa ama uqupka mänguräp mä ut ut na nge iva nga iarhakt kärarhae i nani a rha iva rha rhet narhe sagem nge di qaku mamär vät a rha bä qaku mamär iva aung gä namängaläkt nagem ngän bä sagem ut.’” ");
INSERT INTO uro_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Dä qa muvät toqortäqyia, ‘Dä ngu nän nge mamga iva ngi rhäk nä ma Lasarus säp gu mam aa vätka ");
INSERT INTO uro_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","inguna gua läktpek ama ngärhäqyet na rha ama gamoe rha e i vadi va qa rhugem da ivakt iva qosaqi qale rhi namet sävät tos täkt ama ivärhäs na ama ruanini ama mor ini.’” ");
INSERT INTO uro_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Dä ma Abraham ga muvät toqortäqyia, ‘Qale ma Moses aa enge ngä nä ma Ngämuqa aa vämginarha arha enge gem da bä mamär iva rhat nari ngät.’ ");
INSERT INTO uro_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Dä qä qoar toqortäqyia, ‘Qaku Abraham gu mam, dap ngakt bä nga va aung ga rhäranas nämät ama tñäpki bä sagem da dä va rhi näpgoer na nas.’ ");
INSERT INTO uro_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Dä qä qoar na qa rhoqortäqyia, ‘Ngakt bä qaku rhat nanakt nä ma Moses kä nä ma Ngämuqa aa vämginarha arha enge dä va qaku rhat nanakt näma dä äkt bä va aung ga rhäranas nämät ama tñäpki.’” ");
INSERT INTO uro_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ma Jisas kä qoar na aa mudäsaqongda rhoqortäqyia, “Iarhongäkt kärqärhong i irhong ngärhi rhartäm sa ama ruvek bä sämät ama vuirhong diva qoki va irhong ngät dän sokt diva avuqi mamär ge iaqäkt kärak i qat täranas nä irhong. ");
INSERT INTO uro_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Vadi mai mamär iva rhi er ti qop sa anga märän bäm ga anga duiqa vät aa qän näkt ti rhon na qa säp garäska qre va qa rhäqäne sa akni nävät tärhae rhäkt ama rhoes ama gaini na rha bä sämät anga vuini. ");
INSERT INTO uro_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Bä va ngänit lu vät a nas mamär.” “Ngakt bä akni nävät a ngän di aa anga ruaqa qä slava na qa dä va qa rhamän särhäm ga ma ama qrot iva qale qat tualat toqoräkt dap ngakt bä aa ruaqa qä näpgoer na nas dä va qä qyiradeng ba qa. ");
INSERT INTO uro_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ngakt bä qa slava na nge ma ngärhäqyet da unmem da ama qunäga aa ron näkt ka män gem nge ma ngärhäqyet da unmem bä qä qoar na nge rhoqortäqyia, ‘Sa ngua näpgoer na nas’ dä va ngi qyiradeng ba qa.” ");
INSERT INTO uro_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Dä ama ngangda rhi qoaräs nä ma Engeska rhoqortäqyia, “Mamär iva ngi sämamor na aut katnanakt.” ");
INSERT INTO uro_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Dä qa muvät toqortäqyia, “Ngakt bä nga angän gatnanakt di ama gaini na ngät toqor ama mastard aa gavämini diva mamär vät a ngän iva ngän damän sävät tak täkt ama ngämuga rhoqortäqyia, ‘Ngia rhar täm mes bä ngi qutnanokt sä nas pa ama garäska’ dä mamär iva qä nari nämät ngän.” ");
INSERT INTO uro_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Qre va ak nävät a ngän di aa anga latka qärakni i qät täp ama ivätki ura qät lu vät ama sipsipkäna näkt nga qa män i evär däm ga nävät ama lat dä var qä qoar na aa latka rhoqortäqyia, ‘Ngi ang, ngi lir namuk bä ngia rhuqun bä ngia äs’? ");
INSERT INTO uro_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nguaräm gaku dap kinak pa qä qoar na aa latka rhoqortäqyia, ‘Ngi rhäkmu nä gua tmäs näkt ngi rhäkmu na nas näkt kale nge dävarhäm na ngo dap pa ngua äs dä ngu nakt iva nga nasot dä va sa ngia äs dä ngi nakt’? ");
INSERT INTO uro_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Var qa rhes ama mär sage aa latka inguna qa mualat nä qärqäni i qa qoar na aa latka iva qa rhualat nä ini? ");
INSERT INTO uro_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Di nak kop toqorne na ngän gua latta i nga sa ngän mualat na ama lat kärangätni i sa rha qoar na ngän iva ngän dualat na ngät di nak kop mamär iva ngäni qoar toqortäqyia, ‘Aiut di nak kop ama latta na ut kärarhani i sokt ut tualat!’” ");
INSERT INTO uro_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Näkt sa nga varhäm ma Jisas aa iska iva sae ma Jerusalem dä qa met parhäm ama nägoeqa mänguräp ama ngärhäqyiom ma Samaria dä ma Galili. ");
INSERT INTO uro_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bä nga qat tet iva sämät aomni ama värhäm dä ama ngärhäqyisem na rha ama gamoe rha män bät a qa qärarhani i ama bias pät a rha. As tat mair gläius ");
INSERT INTO uro_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","bä rha näs masirhat tävuk toqortäqyia, “Jisas aurha morqa, mamär iva ngi lavuqi na ut!” ");
INSERT INTO uro_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Bä nga qa lu rha dä qä qoar toqortäqyia, “Ngän det bä ngäni qur ama priskäna rhäm mes.” Bä nga rhat tet parhäm ama iska dä märäs pät a rha. ");
INSERT INTO uro_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ama sägäk nävät a rha di nga qa lu i sa märäs pät a qa dä evär däm ga dap kä nänsäs tävuk sage ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bä arpus na qa säng ma Jisas aa qar bä qat tes ama mär sagem ga. Näkt ka di ama Samariaqa. ");
INSERT INTO uro_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Dä ma Jisas ka snanbät toqortäqyia, “Gusna i märäs pät ama ngärhäqyisem na rha? Dap arhani ama ngärhäqyet da levaet na rha rha qoe? ");
INSERT INTO uro_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Qop nga va qaku aung evär däm ga bä qä navoda ama ansäs sage ma Ngämuqa dap pa sokt tak täkt ama nañiska?” ");
INSERT INTO uro_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Dä qä qoar na qa rhoqortäqyia, “Ngia rhäranas bä ngia rhet. Sa gi qatnanakt ngä mumäräs pät a nge.” ");
INSERT INTO uro_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Maos dä ama Farisiqäna rhi snanbät sä ma Jisas iva qäsnia ma Ngämuqa aa Muräktpäm ngä rhän. Dä ma Jisas ka muvät toqortäqyia, “Ma Ngämuqa aa Muräktpäm diva qaku ngä namän sa anga muqunän iva ngäni lu nämät angän saqong ");
INSERT INTO uro_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","bä va qaku ama ruvek ti naqoar toqortäqyia, ‘Erhangät i’ ura ‘Iangät muk i’ inguna ma Ngämuqa aa Muräktpäm di sa nga e gem ngän.” ");
INSERT INTO uro_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dä soknga qa qoar na aa mudäsaqongda rhoqortäqyia, “Ama qäväläm iva äm ngä rhän gärqomni i aingän diva nani a ngän masirhat iva saqi as ngäni lu anga qunäga nävät ma Ruqa aa Emga aa qunäng sokt diva qaku ngän nalu qa. ");
INSERT INTO uro_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ama ruvek pa rhi qoaräs na ngän doqortäqyia, ‘Iak muk i!’ ura ‘Erhak i!’ dä qale ngän namäranas bä ngän nangang nasot a rha. ");
INSERT INTO uro_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Inguna ma Ruqa aa Emga vät iaqäkt aa qunäga qärak iva saqi as ka rhän diva qa rhoqor ama iauska qärakni i bañäm mät ka vät ama usäpki bä erait närhage bä särhage. ");
INSERT INTO uro_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Sokt diva as narhoer dä va qa rhon säda ama märänga aa ron masirhat näkt pa rhit täkt ama qoengait na ama ruvek diva rhi rhon sasot a nas täm ga. ");
INSERT INTO uro_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Vät ama qäväläm gärqomni iva ma Ruqa aa Emga qa rhän diva ama lat ngät täranas kärangätni i ngät toqor ama lat mudu vät ama rhodäm i ma Noa. ");
INSERT INTO uro_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ama ruvek di sa rhat täs dä rhit nakt dä rhat tätlägut dä rhit bodäm na ne bä dängdäng bät ama qunäga qärakni i ma Noa qa mon sämät ama mlauski ama mor qi dä ama iqum ngä män bä ngä rhäksot na rha moe. ");
INSERT INTO uro_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Qosaqi rhoqorne na ama rhodäm ge ma Lot. Ama ruvek di sa rhat täs dä rhit nakt dä rhit boda arhä gunän dä rhit bodäm bät ama gunän dä rhit kutnanokt dä rhit täk pät ama vät. ");
INSERT INTO uro_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Dap kinak pät iaqäkt ama qunäga qärak i ma Lot ka met nae ma Sodom dä ma Ngämuqa qa rhäk na ama rhäptäpki dä ama qabus täm ga ama duiqa qärakni i qat dang bä qa veng da moe. ");
INSERT INTO uro_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Diva rhoqorne vät iaqäkt ama qunäga qärakni iva vuk sä ma Ruqa aa Emga säda eraqi. ");
INSERT INTO uro_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Va vät iaqäkt ama qunäga di mamär iva aung gärakni i qale qa vät ama vätka aa rhäng di saqi as kale ar sä qa bä qä namon säva vät nani aa qärhong gärqärhongni i qali lirhong ba vät. Bä qosaqi aung gärakni i qale qa vät a etki di saqi as kale evär däm ga nani guani. ");
INSERT INTO uro_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nak pa qunäga vät a ngän sävät ma Lot aa egutki! ");
INSERT INTO uro_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Aung gärakni i qä siqut iva qa rhumaiar na aa iar diva qa rhusäng sä ngät nasot dap iaqäkt kärak i qa rhusäng sa aa iar diva qa rhumaiar ngät. ");
INSERT INTO uro_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ngu qoar na ngän i nävä iaqyäkt ama bängagi diva qale ama ruiom bät ama laiqa ama sägäk näkt pa ma Ruqa aa Emga qä rha ak dap pät ak mäk. ");
INSERT INTO uro_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ama unbem ama evovem diva in moe in dualat i ini qräskräs ama wit dä va ma Ruqa aa Emga qä rha aktni dap pa qale aktni mäk.” ");
INSERT INTO uro_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Dä ama mudäsaqongda rhi snanbät sä ma Jisas toqortäqyia, “Aurha Engeska, va qoe nai rhoqoräkt?” Dä qa muvät toqortäqyia, “Äkt i ama säktämgi qali qi e diva västämne na ama isäm e qärangätni i ngät dräm ngät täs ama säktämgi.” ");
INSERT INTO uro_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Dä ma Jisas ka qoar na aa mudäsaqongda na ama enge na ama siqutki ivakt iva qä qur a rha iva qale mämae vät a rha nävät ama nän dap pa vasägos dä va rhi nän. ");
INSERT INTO uro_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Dä qä qoar toqortäqyia, “Mät aomni ama värhäm di qale akni ama matnävämnenaqa näkt ka di qaku qat dräm gät kutdrir sage ma Ngämuqa dä qaku qat dräm gat tu aa snäng masirhat sävät ama ruvek. ");
INSERT INTO uro_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Näkt aktni ama maqoski di qali qi mät iomäkt ama värhäm näkt pasägos dä qiat dän sagem ga bä qit nok pät a qa rhoqortäqyia, ‘Ngia rhatnärhäm ngo dä ngia rhair vä gua rhäng sävät gua ik inguna aingo di ama mär gua lat.’” ");
INSERT INTO uro_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Dä as kät kutsäs pät a nas i qat ter bä äkt bä nak as nasot dä qa märhamän särhäm mes toqortäqyia, ‘Nak ngäktki i qaku ngut kutdrir sage ma Ngämuqa dä qaku nguat tu gu snäng masirhat sävät ama ruvek ");
INSERT INTO uro_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","sokt di nävät tärhakt ama maqoski qärakt i qiat tusar na ngo dä va ngua rhet parhäm ama räkt ngät ama lat bä ba qi i varis ki namusar na ngo masirhat na at mänmänäs pasägos.’” ");
INSERT INTO uro_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Dä ma Engeska qä qoar toqortäqyia, “Ngäni nari ama enge qärangätni i ama vu qa ama matnävämnenaqa qa märhamän bät a ngät. ");
INSERT INTO uro_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mänia, nak nga qaku ma Ngämuqa qä namualat parhäm ama räkt ngät ama muräkt sävät aa ruvek kärarhani i mudu qa armeng däm da bä ba nas? Nga va qaku qa rhualat toqoräkt kre i rhi nagukt pät a qa vät ama qunäng dä ama bängang moe? Nga va vasägos dä qät kyiradeng na rha? ");
INSERT INTO uro_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nguat tamän särhäm ngän i nak kop pa qä lir qa rhualat toqoräkt. Dap ngakt bä va ma Ruqa aa Emga qa rhän divar qa rhän bät anga qatnanakt te vät ivät ura qaku?” ");
INSERT INTO uro_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ma Jisas ka märhamän bät tangät täkt ama enge na ama siqutki bä iarhakt kärarhae i rhat nanakt i sa rha di ama räkt ta dap tat don arhani. Di qä qoar toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ama ruiom in met pävit säva ama ansäspämgi ama mor qi ivakt iva ini nän. Akni di ama Farisiqa dap akni di ama ruqa qärakni i qät ta ama takes. ");
INSERT INTO uro_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ama Farisiqa qa mair sä nas bä qä nän doqortäqyia, ‘Gu Ngämuqa, nguat tes ama mär sagem nge inguna aingo di qaku ngo rhoqor arhani ama ruvek toqor ama suarha bä iarhakt kärarhae i rhat dräm dat tatmät dä iarhakt kärarhae i rhi qavatnävätlägut bä qäqi rhoqor taerhak ama ruqa qärakni i qät ta ama takes. ");
INSERT INTO uro_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nguat teranot maunmem mäni ama tadenas dä ngut boda ama sägäni nämäni ama ngärhäqyisem nä irhong nävät iarhongäkt moe qärqärhong i ngut ta irhong.’” ");
INSERT INTO uro_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Dap ama ruqa qärakni i qät ta ama takes di qat mair gläius tämuk. Qop kaku mamär iva qä nañäm dävit säva usäp dap kä nän aa brärhäm dä qä qoar toqortäqyia, ‘Ngämuqa, mamär iva ngi lavuqi na ngo ama vuqa.’” ");
INSERT INTO uro_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ngu qoar na ngän i rhak täkt ama ruqa di evär däm ga säva vät i sa ama räkt ka ama ruqa na qa dä ma Ngämuqa aa saqong dap kaku rha ama Farisiqa. Inguna aung gärakni i qät sämamor na nas diva rhi säm ama gaini na qa dap iaqäkt kärak i qät säm ama gaini na nas diva rhi sämamor na qa.” ");
INSERT INTO uro_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ama ruvek di qosaqi rhat dän gäqi sa arhä rhoes ama gaini na rha mamär sage ma Jisas ivakt iva qat tu aa rhäkt pät a rha. Bä nga ama mudäsaqongda rha lu rhoqoräkt dä rhat tair särhäm da. ");
INSERT INTO uro_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Di nak ma Jisas ka mes ama rhoes sagem mes i qä qoar toqortäqyia, “Ngäni rhares pät ama rhoes arha rhäng iva rhat tet sagem ngo dap kale ngän dair särhäm da inguna ma Ngämuqa aa Muräktpäm di ngät bä bä iarhakt kärarhae i rha rhoqor tärha rhäkt ama rhoes. ");
INSERT INTO uro_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nguat tamän särhäm ngän na ama engäktki i aung gärakni i qaku qä narha ma Ngämuqa aa Muräktpäm doqor anga rhoemga diva qaku qä namon säväm ngät.” ");
INSERT INTO uro_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Akni ama narhoerqa qa snanbät sä ma Jisas toqortäqyia, “Qamorqa ama mär qa, ngu lu va ngua mäsana äkt iva dängdäng dä bä ba ngo na ama iar ama sok täm ngät?” ");
INSERT INTO uro_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Dä ma Jisas kä snanbät sä qa rhoqortäqyia, “Mäniekt bä ngiat tes ngo i ama mär qa na ngo? Qaku aung di ama mär qa dap sokt ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Sa ngiat dräm ama Muräkt nage ma Ngämuqa qärangätni i ngät tamän doqortäqyia, ‘Qale ngi qavatnävätlägut dä qale ngi veng dä qale ngi sua dä qale ngi iras na anga engirhong säda arhani arhä väs dä mamär iva ngit kutdrir sävät gi mam dä gi nan.’” ");
INSERT INTO uro_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Dä qä narhoerqa qä qoar toqortäqyia, “Qamorqa, rhangät täkt ama muräkt moekt di sa nguat tet parhäm ngät mänasäng mudu i ama rhoemga na ngo bä qoki as täkt.” ");
INSERT INTO uro_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Bä nga ma Jisas ka nari rhoqoräkt dä qa qoar na qa rhoqortäqyia, “As ama sägäni nga e qärqäni i mamär iva ngia rhualat nä ini. Va ngi vodä gi qärhong moe bä ngi von ama tläkta dä va ngi rha ama mämägän dävuk. Näkt pa ngi ang bä ngit päs gua rhäng.” ");
INSERT INTO uro_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Bä nga qärak ka nari rhoqoräkt dä qa nari i airäs ka masirhat inguna qa di ama qärhong bät a qa masirhat. ");
INSERT INTO uro_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ma Jisas kat lu qa bä airäs ka nävät a qa dä qä qoar toqortäqyia, “Ama qrot masirhat ge ama qärhongbärharha iva rha rhon säp ma Ngämuqa aa Muräktpäm. ");
INSERT INTO uro_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Inguna ama qrot masirhat ge ama kamel iva qa rhon mät anga liqini va anga släpki qäraktni i rhit kutäm na qi at täväs dap sa ama qrot masirhat mamär ge ama qärhongbärhaqa iva qa rhon sävä ma Ngämuqa aa Muräktpäm.” ");
INSERT INTO uro_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Qärarhani i rha nari rhoqor täkt di rha snanbät toqortäqyia, “Di rhoqoräkt di qop pa sirhäkt ngu lu va auge diva qä rha ama mumaiar?” ");
INSERT INTO uro_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Dinak ma Jisas ka qoar toqortäqyia, “Agini qärqäni i qaku mamär vät ama ruvek nä ini di mamär vät ma Ngämuqa nä ini.” ");
INSERT INTO uro_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Dä ma Pita qä qoar na qa rhoqortäqyia, “As ngi lu i aiut di sa ut met daqule aurha vät bä ut päs gia rhäng.” ");
INSERT INTO uro_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Dä ma Jisas kä qoar na rha rhoqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i iarhakt moe qärarhae i sa rha met daqule arha vät ura arha egutpek ura arha läktpek ura arha matpek ura arhä rhoes inguna arhä snäng bät ma Ngämuqa aa Muräktpäm ");
INSERT INTO uro_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","di nak pa rhi rha ama modämne masirhat savono pät tangät täkt ama rhodäm dap pät ama rhodäm nasot dä va rhi rha ama iar ama sok täm ngät.” ");
INSERT INTO uro_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ma Jisas ka rhäqoar sa aa mudäsaqongda ama ngärhäqyisem da udiom na rha bä sokt ta sä nas näkt ka qoar na rha rhoqortäqyia, “Ut tet tävit iva sae ma Jerusalem näkt iarhongäkt moe qärqärhong i mudu ma Ngämuqa aa vämginarha rha säm irhong sävät ma Ruqa aa Emga diva irhong ngä rhu angät släqyige vät a nas. ");
INSERT INTO uro_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Va rhi vodäm ga bä ba ama Jentailqäna. Va rhat tuma qa bä va rhi slava na qa na ama enge ama vu ngät mamär bä va rhit kot pät a qa ");
INSERT INTO uro_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","bä va rha rhäranäs ka näkt pa rhi veng ga. Näkt pa vät ama dävaung na qa ama qunäga dä saqi sa qa rhäranas.” ");
INSERT INTO uro_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ama mudäsaqongda di qaku qunäga vät a rha sä guani narhäkt. Inguna ama enge angät tarimini di ama ngaip ini bä qaku rhat dräm i ma Jisas kat tamän sävät agini rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ma Jisas di sa nga qorhäs na qa iva qa rhän e ma Jeriko dap akni ama ruqa ama säsur qa di qat muqun bät ama iska aa rhäkt bä qä nän nani guarhong nage ama ruvek. ");
INSERT INTO uro_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bä nga qa nari ama gulañ i ngät tet e na qa dä qä snanbät i mäniekt toqoräkt. ");
INSERT INTO uro_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Dä rhi qoar na qa rhoqortäqyia, “Ma Jisas nae ma Nasaret di rhakni i qat tet te.” ");
INSERT INTO uro_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Dä qa näs tävuk toqortäqyia, “Jisas ma Devit aa emga, mamär iva ngi lavuqi na ngo!” ");
INSERT INTO uro_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Dä iarhakt kärarhae i mai rhi rhoer na ama iska rha näs täm ga dap ti qoar na qa iva mänadin däm ga dä qop kät näs masirhat toqortäqyia, “Devit aa emga, ngi lavuqi na ngo!” ");
INSERT INTO uro_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Dä ma Jisas ka mair bä qa rhäkne ivakt iva rha rhän sä qä säsurqa sagem ga. Bä nga qärak kat tet bä sa glaqot dä ma Jisas kä snanbät sä qa rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nani a nge iva ngua rhualat na agiqa bä ba nge?” Dä qärak ka muvät toqortäqyia, “Gua Engeska, vadi va nguat nañäm.” ");
INSERT INTO uro_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Dä ma Jisas ka qoar na qa rhoqortäqyia, “Rhäkt di qunäga mät gi saqong. Gi qatnanakt di sa ngä mumäräs pät a nge.” ");
INSERT INTO uro_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Dä vät iomäkt ama qäväläm dä qop kärak ka ñäm masägos bä qat tet nasot ma Jisas dap kä nänsäs sage ma Ngämuqa. Bä nga ama ruvek moe rha lu rhoqoräkt dä rhi nänsäs sage ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ma Jisas kat tet mät ma Jeriko ");
INSERT INTO uro_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","dap akni ama ruqa qärakni i rhat tes ka i ma Sakias kärakni i ama narhoerqa bä ba ama ruvek kärarhani i rhit ta ama takes näkt ama qärhong bät a qa di qale qa e. ");
INSERT INTO uro_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Di nani a qa iva qä lu i ma Jisas di auge iaqäkt sokt di qaku mamär vät a qa i nage ama gulañ inguna ama qot ka. ");
INSERT INTO uro_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Dä soknga qa ang masirhat narhoer va arhä qamäs bä qa veng bät ama ngämuga ivakt iva qä lu qa inguna ma Jisas diva qa rhet parhäm iaqäkt ama iska. ");
INSERT INTO uro_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bä nga ma Jisas ka män bät iosäkt ama ivärhäs dä qa ñäm savuk dä qä qoar na qa rhoqortäqyia, “Sakias, ngi lir ngi srätdäm inguna va rhäqyerhäkt diva qale ngo vä gia vätka.” ");
INSERT INTO uro_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Dä soknga qa lir qa srätdäm bä qa ar sä ma Jisas na ama märmärgem. ");
INSERT INTO uro_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ama ruvek moe rha lu rhoqoräkt dä rhi nasäng i rhat tamängus toqortäqyia, “Iaqäkt di qa män i ama tmänga na qa säva ama vuqa aa vätka.” ");
INSERT INTO uro_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Dä ma Sakias ka mair dä qä qoar nä ma Engeska rhoqortäqyia, “Gua Engeska, ngi lu! Qoki va rhäkt diva ngu voda ama qäväläm nävät gu qärhong bä ba ama tläkta näkt ngakt bä nga mudu ngua iras ba nas sa aung aa anga guani di rhäkt diva ngua rhuvät pät a qa malevaet nä imek savono nä ianiäkt kärqäni i sa mudu ngua iras ba nas sä ini.” ");
INSERT INTO uro_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Dä ma Jisas kä qoar na qa rhoqortäqyia, “Rhäqyerhäkt di sa ma Ngämuqa qat tumaiar na ama ruvek nävä rhak täkt ama vätka inguna rhak täkt ama ruqa di qosaqi qa nävät ma Abraham aa enevaqi. ");
INSERT INTO uro_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Inguna ma Ruqa aa Emga qa män ivakt iva qät ñäm bä qat tumaiar nä iarhakt kärarhae i musäng sä rha.” ");
INSERT INTO uro_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bä nga rhat nari rhärhong däkt dä saqi as ma Jisas kat tamän särhäm da na ama enge na ama siqutki inguna qale qa glaqot nä ma Jerusalem bä ama ruvek tat tu arhä snäng iva ma Ngämuqa aa Muräktpäm diva ngärhi lir ngä rhän masärmän bät iomäkt ama qäväläm da ama ruvek arhä saqong moe. ");
INSERT INTO uro_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Dä qä qoar toqortäqyia, “Akni ama moräs na qa ama ruqa qa met sävät aosni ama ivärhäs gläius ivakt iva rha rhair na qa iva qa rhän i ama vitnaqa näkt pa saqi evär däm ga. ");
INSERT INTO uro_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Dä qa mes aa latta ama ngärhäqyisem na rha näkt ka von da asägäk asägäk ta ama ligärige na ama gol. Näkt ama ligärige asägäge asägäge di ige ngä met e na ama dävagukt ama eqoan angät titsek. Näkt ka qoar na rha rhoqortäqyia, ‘Va ngäni märmor iaglengäkt ama ligärigleng bä dängdäng i ngua rhän.’” ");
INSERT INTO uro_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Sokt di aa ruvek moe di ama vu da arha ron na qa mamär dä rha rhäk na ama engevärharha nasot a qa ivakt iva rhi qoar nä iarhakt kärarhae iva rha rhair na qa rhoqortäqyia, ‘Ut mer tak täkt ama ruqa qä namän iva ama vitnaqa ba ut.’” ");
INSERT INTO uro_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Sokt di nak ta mair na qa iva ama vitnaqa näkt evär däm ga säva aa vät. Dä qa rhäkne nani ama latta qärarhani i mäqi qa von da rha ama ligär ivakt iva qä lu i rha mualat toqor mäniekt nä iangärhäkt ama ligär.” ");
INSERT INTO uro_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Ama narhoerqa ama ruqa qa män dä qä qoar toqortäqyia, ‘Gua morqa, gi ligär di angät mänbitka di na ama ngärhäqyisem sae.’” ");
INSERT INTO uro_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Dä aa morqa qä qoar toqortäqyia, ‘Mamär mas sagem nge, gua latka ama mär qa. Va rhäkt di ngu von nge rha ama ngärhäqyisem na ap ama värhap ama mor ap iva ngit lu vät ap inguna sa ngia mualat mamär sa ama marheka nä irhong.’” ");
INSERT INTO uro_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ama udiomnaqa qa män dä qä qoar toqortäqyia, ‘Gua morqa, gi ligär di angät mänbitka di na ama ngärhäqyet sae.’” ");
INSERT INTO uro_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Dä aa morqa qa muvät toqortäqyia, ‘Va ngit lu vät ama ngärhäqyet na ap ama värhap ama mor ap.’” ");
INSERT INTO uro_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Dä saqi as akni ama latka qa män dä qä qoar toqortäqyia, ‘Gua morqa, gi ligär tangät. Ngua ong bät a ngät pa ama bauläm näkt ngua ngaip ngät. ");
INSERT INTO uro_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ngua mualat toqoräkt dinguna ngut len nge inguna ama vu qa ama ruqa na nge sä gia latta. Ngit ta agini qärqäni i qaku nge gi qäni näkt ngit sek mät ianiäkt kärqäni i sa qaku ngia qutnanokt ini.’” ");
INSERT INTO uro_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Dä aa morqa qa muvät toqortäqyia, ‘Va ngua rhu nge va ama muräkt pät gia enge angät tpäs. Ainge di ama latka ama vu qa na nge. Sa ngia qoar i gua lat di ama vu ngät sä gua latta i ngut ta agini qärqäni i qaku ngo gu qäni dä ngut sek mät ianiäkt kärqäni i sa qaku ngua qutnanokt ini. ");
INSERT INTO uro_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ngakt bä ngiat tu gi snäng i ngäktki rhoqoräkt sävät a ngo dä mäniekt bä qaku ngia mu gu ligär iva ngärhi sa sävät a nas iva nga evär däm ngo dä va ngu rha ngät sa anga mänbitka?’” ");
INSERT INTO uro_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Dä qä qoar nä iarhakt kärarhae i rhat mair e glaqot toqortäqyia, ‘Ngäni rha aa ligär nagem ga bä ngäni vodäm ngät bä bä iaqäkt kärak i sa ama ngärhäqyisem ama ligär.’” ");
INSERT INTO uro_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Dä rhi qoar toqortäqyia, ‘Aurha morqa, nak sa qa di aa ngärhäqyisem ama ligär nga e gem ga!’” ");
INSERT INTO uro_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Dä qa muvät toqortäqyia, ‘Ngu qoar na ngän i aung gärakni i sa aa anga guani diva rhi von ga rha arhongni savono sae. Dap aung gärakni i sa qaku aa anga guani diva qäqi rhi rha aa qäni ama gaini nä ini nagem ga. ");
INSERT INTO uro_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Dap gua ikkäna qärarhani i qaku nani a rha iva ngua rhän i ama vitnaqa na ngo bä ba rha di ngäni rha rha sarhäkt bä va ngäni veng da dä gu saqong.’” ");
INSERT INTO uro_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nasot i ma Jisas ka märhamän doqoräkt dä qa er va arhä qamäs pävit sae ma Jerusalem. ");
INSERT INTO uro_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bä nga qat tet bä sa glaqot na ama värham ama lel am ma Betfage dä ma Betani mäni ama damgi ama gaini na qi ama Damgi na ama Olip dä qa rhäk na ama udiom nävät aa mudäsaqongda ");
INSERT INTO uro_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","näkt kä qoar na iom doqortäqyia, “In det säp iomäkt ama värhäm gärqomni i äm nga e vä in gamäs bä nga va inät don sävä bäm dä va ini lu ama donki ama rhoem ga qärakni i sa rha qop sä qa sae qärakni i as mudu qaku aung ga muqun bät aa rhäng. Dä ini rhäväkt sä qa näkt pa in det sä qa sarhe. ");
INSERT INTO uro_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ngakt bä nga aung gä snanbät sä en doqortäqyia, ‘Mäniekt bä init täväkt sä qa?’ dä va ini qoar na qa rhoqortäqyia, ‘Ma Engeska nani a qa na qa.’” ");
INSERT INTO uro_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Qärqiomni i ma Jisas ka rhäk na iom sae di in män bät iarhongäkt moe i sa qa qoaräs na iom sävät irhong. ");
INSERT INTO uro_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bä nga init täväkt sä qä donki ama rhoem ga dä iarhakt kärarhae i rhit lu vät a qa di rhi snanbät sä iom doqortäqyia, “Mäniekt bä init täväkt sä qa?” ");
INSERT INTO uro_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Dä in muvät toqortäqyia, “Ma Engeska nani a qa na qa.” ");
INSERT INTO uro_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bä in män sä qä donki ge ma Jisas bä in don nä in baulem ama uiu em bät aa rhäng näkt in mu ma Jisas pono vät aa rhäng. ");
INSERT INTO uro_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bä nga ma Jisas kat tet pät ama donki aa rhäng dä ama ruvek ti vreng arhä boi ama uiu ngät pät ama iska. ");
INSERT INTO uro_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Bä nga qat tet bä sa glaqot na ama ivärhäs i ama iska qat tet tämane näda ama Damgi na ama Olip at täväs dä ama guläñgi moe na ama mudäsaqongda rhi nasäng i rhi nänsäs na ama märmärgem masirhat sage ma Ngämuqa nävät ama lat ama nañis ngät moe i vasägos dä sa rhat lu ma Jisas i qat tualat na ngät dä rhit näs toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Mamär iva ama modämne sävät ama vitnaqa qärakni i qat dän nävät ma Engeska ma Ngämuqa aa ngärhipki.” “Mamär iva ama bulap da ama usäpki arha ron dä ama ansäs sage ma Ngämuqa rhävuk!” ");
INSERT INTO uro_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Arhani ama Farisiqäna mänguräp ama guläñgi rhi qoar nä ma Jisas toqortäqyia, “Qamorqa, ngi näs tä gi mudäsaqongda iva mänadin däm da!” ");
INSERT INTO uro_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Dä qa muvät toqortäqyia, “Ngu qoar na ngän i ngakt bä nga mänadin däm da dä va ama dui ngärhit nästäm.” ");
INSERT INTO uro_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Bä nga qat tet bä sa glaqot nä ma Jerusalem bä qa lu äm dä qa nok sä äm. ");
INSERT INTO uro_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Dä qä qoar toqortäqyia, “Vät tak täkt ama qunäga di nani a ngo masirhat i vadi va ngi lu mamär na agiqa iaqäkt iva qä von nge rha ama bulap sokt di rhäkt di qaku mamär vät a nge iva ngi nalu rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Va ama qäväläm ngä rhän bät a nge iva gia ikkäna rhi ing däm nge na ama surqa bä va rhi slava na nge närhage närhage. ");
INSERT INTO uro_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Va rhi slava na nge Jerusalem samäk sävät ivät ngi nä ngia es muk dä gi surqa aa ron maräkt. Bä va qaku rhi namet daqule anga duiqa vono vät akni aa rhäng inguna sa qaku ngia lu mamär i sa ma Ngämuqa qat dän sagem nge.” ");
INSERT INTO uro_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Dä qa mon säva ama ansäspämgi ama mor qi arha ivärhäm bä qa nasäng i qät kutmäs iarhakt kärarhae i rhit boda arhä qärhong e vä bäm. ");
INSERT INTO uro_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Qä qoar na rha rhoqortäqyia, “Ma Ngämuqa aa enge qärangätni i sa mudu rha säm a ngät di ngät tamän doqortäqyia, ‘Gua vätki diva ama vätki na ama nän sokt di sa ngän mualat sä qi ma ama suarha arhä qeqi.’” ");
INSERT INTO uro_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Vät ama qunäng moe dä ma Jisas kä su va ama ansäspämgi ama mor qi. Dap ama priskäna ama moräs na rha rhi na ama Skraipkäna näkt sävät ama morta mänguräp ama ruvek di rhi siqut i rhit ñäm nani anga iska iva rhi veng ga. ");
INSERT INTO uro_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Sokt di qaku mamär vät a rha iva rhi namän bät aung anga iska iva rha rhualat toqoräkt inguna ama ruvek moe di rhi nging däm ga bä rhat tu arha sdäm mamär sävät aa enge. ");
INSERT INTO uro_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Vät akni ama qunäga rhoqoräkt i qä su ama ruvek pa ama ansäspämgi ama mor qi bä qä sameng na ama sameng ama mär ngät dä ama priskäna ama moräs na rha dä ama Skraipkäna näkt ama morta rha män gem ga. ");
INSERT INTO uro_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Dä rhi qoar na qa rhoqortäqyia, “Ngi qoar na ut i ngiat tualat toqor täkt di na ama qrot nage auge. Auge qa von nge rhä rhangät täkt ama qrot?” ");
INSERT INTO uro_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Dä qa muvät toqortäqyia, “Dä qosaqi va ngu snanbät sä ngän na ama snanbät. Ngäni qoar na ngo. ");
INSERT INTO uro_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ma Jon gä baptais pät ama ruvek di iangärhäkt di nga ngät na rhävuk ura ngät nage ama ruvek?” ");
INSERT INTO uro_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dä rhat tamän särhäm ne sä iangärhäkt aa snanbät dä rhi qoar na ne rhoqortäqyia, “Ngakt bä urhi qoar i iangärhäkt ma Jon aa baptais di ngät na rhävuk dä va qä snanbät sä ut toqortäqyia, ‘Bä nga rhoqoräkt dä mäniekt bä qaku ngän mat maengäkt nämät ka?’ ");
INSERT INTO uro_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Dap ngakt bä urhi qoar toqortäqyia, ‘ngät di ngät nage ama ruvek’ diva ama ruvek moe rhi rhumät nä ut na ama dui inguna rhat nanakt ma ama qrot i ma Jon di akni ma Ngämuqa aa vämginaqa na qa.” ");
INSERT INTO uro_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bä äkt i sa rha muvät pät ma Jisas toqortäqyia, “Qaku ut dräm i ngät na qoe.” ");
INSERT INTO uro_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Dä qosaqi ngo diva qaku ngu naqoar na ngän i nguat tualat nävät auge aa qrot.” ");
INSERT INTO uro_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Dä qa nasäng i qat tamän särha ama ruvek na ama enge na ama siqutki rhoqortäqyia, “Maos dä akni ama ruqa qa qutnanokt ama qauligleng bät aa etki qärqiglengni i rhat tes igleng i ama wain. Qa mualat toqoräkt näkt ka von arhani ama latta rha aa lat iva rhat tualat na ngät bä ba qa dap ka met sävät aosni ama ivärhäs bä va qaku qä nalir qä namän. ");
INSERT INTO uro_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Bä sa nga sräp ama etki dä qärak ka ruqa qa rhäk na akni ama latka sage qa latta ivakt iva rhi von ga rha anga gavam nävät ama etki na ama qauligleng. Sokt di ama latta rha arhäktgyäm sä qa näkt ta rhäk na qa dap kaku qa rha agung. ");
INSERT INTO uro_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Dä qa etki arha ik ka rhäk na akni ama latka sagem da dä qosaqi rha arhäktgyäm sä qa bä rha von ga rha ama qluqi näkt ta rhäk na qa dap kaku qa rha agung. ");
INSERT INTO uro_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Dä qoki as ka rhäk na ama dävaung na qa dä rha muvospos pät a qa näkt ta rhon na qa särhage na ama etki.” ");
INSERT INTO uro_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Nasot dä ama etki arha ik kä qoar toqortäqyia, ‘Ngu lu va ngua mäsana? Rhäkt diva ngu rhäk nä ngua emga qärakni i sa gua snäng bät a qa mamär dä nguaräm ba rhi qutdrir vät a qa.’” ");
INSERT INTO uro_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Bä nga ama latta rha lu qa dä rha märhamän särhäm ne i rhi qoar toqortäqyia, ‘Rhak täkt di iaqäkt kärak iva qä rha ama etki nasot aa mam. Urhi veng ga ivakt iva urhi rha ama etki bä ba nas.’ ");
INSERT INTO uro_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Dä rha rhon na qa sä dalek na ama etki näkt ta veng ga.” “Ngu lu va ama etki arha ik ka mäsana na rha? ");
INSERT INTO uro_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Va qa rhän bä va qä veng iarhakt ama latta dap pa qä von guavek tä iangärhäkt ama lat na ama wain.” Bä nga ama ruvek ta nari rhoqor täkt dä rhi qoar toqortäqyia, “Nak padi va qale qä namualat toqoräkt.” ");
INSERT INTO uro_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ma Jisas ka ñäm maräkt sävät a rha dä qa snanbät toqortäqyia, “Bä nga rhoqoräkt dä ngu lu ama rharimini rhoqor mäniekt sä rhangät täkt ama enge qärangätni i sa rha säm a ngät toqortäqyia, “‘Ama duiqa qärak i mudu iarhakt kärarhae i rhat dräm dit täk pät ama vät ta mer mä qa di nak kärak iaqäkt i rhäkt di ama qrot ama vätki nagem ga qärak i qat sangar a qi moe’? ");
INSERT INTO uro_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Bä iarhakt moe qärarhae i arharpus na rha vät tak täkt ama duiqa aa rhäng diva bäktgyäm sä rha mä irhong mä irhong dap ngakt bä arharpus nä rhak täkt ama duiqa vät aung aa rhäng diva värhot täm ga mamär.” ");
INSERT INTO uro_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ama Skraipkäna näkt sävät ama priskäna ama moräs na rha qärarhani i rhat nari qa di rhit ñäm nani anga iska ivakt iva rhi lir ti sangar a qa äkt inguna rhat dräm i sa qa märhamän bät tangät täkt ama enge na ama siqutki di sävät a rha. Sokt di qaku rha sangar a qa inguna rhit len ama ruvek. ");
INSERT INTO uro_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bä äkt i qoki sa arhä saqong bät ma Jisas mamär dä rha rhäk na arhani ama qasesta sagem ga bä rha irastäm na nas i ama engäktki na rha ama ruvek. Nani a rha iva rhi sangar ma Jisas pät agung aa enge angät tpäs ivakt iva rhi vodäm ga säva ama tpäskinaqa aa rhäkt iva qa rhu qa va aa muräkt. ");
INSERT INTO uro_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Dä soknga qärarhani rha snanbät sä qa rhoqortäqyia, “Qamorqa, sa ut dräm i ngiat tamän bä ngi su na ama engäktki dä ngiat tualat sa ama ruvek moe rhoqorne dap ngi su na ama engäktki sävät ma Ngämuqa aa snängaqa. ");
INSERT INTO uro_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nga maräkt parhäm ama Muräkt iva urhit bon da ama takes sage ma Sisar ura qaku?” ");
INSERT INTO uro_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Qa räm arha irasini dä qä qoar na rha rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ngäni qur a ngo rha anga qunäga ama sägäk aa rhitsek angät ligärige. Auge aa iauski rhakt täkt päm ige? Dä auge aa sämsäm dangät täkt päm ige?” Dä rha muvät toqortäqyia, “Ma Sisar.” ");
INSERT INTO uro_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Dä qa qoar na rha rhoqortäqyia, “Dä soknga ngäni von ma Sisar tä iarhongäkt kärqärhong i qoki ma Sisar aa qärhong dap pa ngäni von ma Ngämuqa rhä iarhongäkt kärqärhong i qoki ma Ngämuqa aa qärhong.” ");
INSERT INTO uro_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Qop kaku mamär vät a rha iva rhi sangar a qa vät guani angät tpäs kärqäni i qa märhamän bät ini ge ama ruvek. Dap kinak kräk mät ta nävät aa muvätki dä soknga mänadin däm da. ");
INSERT INTO uro_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Arhani nävät ama Sadyusiqäna iarhakt kärarhae i qaku rhat nanakt i saqi as pa ama ruvek ta rhäranas näva ama tñäpki di rha män ge ma Jisas sa ama snanbät. ");
INSERT INTO uro_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Bä rhi qoar toqortäqyia, “Qamorqa! Mudu ma Moses ka säm ama muräkt bä ba ut i ngakt bä nga aung anga matka qä ñäp daqule aa egutki dap kaku ina anga es dä va aa läktka qa rhät iaqyäkt ama maqoski ivakt iva qä sa vät a qi bä ba aa matka. ");
INSERT INTO uro_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Maos dä qale ama sägärhae ama ngärhäqyet da udiom na rha ama gamoe. Ama narhoerqa qa mät ama evopki näkt ka ñäp dap kaku ina anga es. ");
INSERT INTO uro_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Dä ama udiomnaqa qa mät a qi näkt ka ñäp ");
INSERT INTO uro_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","dä qosaqi ama dävaungnaqa bä qoki rha moe ama ngärhäqyet da udiom na rha rha mät a qi näkt ta ñäp daqule qi dap kaku aung ga sa vät a qi. ");
INSERT INTO uro_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Dängdäng dä qa evopki qia ñäp. ");
INSERT INTO uro_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Dä soknga va auge aa egutki na qi mirhup pät ama qäväläm gärqomni iva ama ruvek ta rhäranas nämät ama tñäpki inguna rha moe ama ngärhäqyet da udiom na rha sa rha mät a qi?” ");
INSERT INTO uro_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Dä ma Jisas ka muvät toqortäqyia, “Ama ruvek ama gamoe dä ama evop nävät tärhong däkt ama rhodämirhong di rhat tätlägut. ");
INSERT INTO uro_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Dap ama ruvek kärarhani i ama räkt ta dä ma Ngämuqa aa saqong di nga nasot i sa rha rhäranas nämät ama tñäpki diva qaku rhi natmätlägut bä qosaqi va qaku ama ruvek ti navon da arhani ama ruvek sämät ama ngärhaegurhini. ");
INSERT INTO uro_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bä va saqi as kaku rhi natñäp inguna sa rha män i rha rhoqor ama enselqäna. Näkt kosaqi rha di ma Ngämuqa aa es inguna sa rha märanas nämät ama tñäpki. ");
INSERT INTO uro_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Dap sävät ama ruvek ama ñäp ta qärarhani i rhat täranas nämät ama tñäpki di qäqi ma Moses ka qur a ut mamär vät ama enge sävät ama ngämungäm gärqomni i vur ama rhäptäpki vät a äm i ama ñäpta diva saqi as ta rhäranas mugas. Qa qur a ut toqoräkt i qat tes ma Ngämuqa i ma Abraham gä nä ma Aisak dä ma Jekop arhä Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ma Ngämuqa di qaku ama ñäpta arhä Ngämuqa dap ka di ama ngätdäqämda arhä Ngämuqa inguna varhäm aa mädräm di ama ruvek moe di nak ama ngätdäqäm da.” ");
INSERT INTO uro_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Arhani ama Skraipkäna di rhi qoar toqortäqyia, “Qamorqa, sa ngia voda ama mär qi ama muvätki.” ");
INSERT INTO uro_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Näkt sa qaku nani aung iva saqi as kä snanbät sä qa na agung anga snanbät inguna rha moe di sa rhit len. ");
INSERT INTO uro_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Mäniekt bä rhi qoar i ma Krais di nak ma Devit aa emga na qa? ");
INSERT INTO uro_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Inguna ma Devit di sa qa märhamän mamär va ama Abuk na ama Mabu rhoqortäqyia, “‘Ma Ngämuqa qa qoar nä gua Engeska rhoqortäqyia, “Ngia rhuqun dä gu märmär bä qale nge e ");
INSERT INTO uro_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","bä dängdäng iva ngua rhän näp gia ikkäna arhä väs bä rha rhän i ama laiqa na rha nanokt gia qäriglem.” ’ ");
INSERT INTO uro_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ngu lu va sirhäkt ma Devit aa emga na qa rhoqor mäniekt inguna ma Devit ka mes ka rhoqortäqyia, ‘Gua Engeska’?” ");
INSERT INTO uro_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bä nga rhoqoräkt i ama ruvek tat nari qa dä qä qoar na aa mudäsaqongda rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ngänit lu nämät ama Skraipkäna. Nani a rha iva rhat pitmane sa ama boi ama uiu ngät pät a nas bä nani a rha masirhat iva ama ruvek ti rhar sä rha na ama qutdrir vät ama ivärhimek kärqämekni i ama ruvek tit boda arha tmäs e dä nani a rha iva rhat tuqun bät ama lai vuk dä ngärhaväm ba ama mämairväm dä nani a rha na ama mämugunimek ama vit nä imek pa ama tmäsimek. ");
INSERT INTO uro_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Dap kosaqi rhat täs pät ama evop ama maqosta sa arhä qärhong näva arha vät dä rhi nän na ama uiu ngät ama nän iva säda ama ruvek arhä saqong. Iarhakt kärarhae i rha rhoqor täkt diva ma Ngämuqa qä rhäksärhäm da dä va qä sangäm na rha masirhat.” ");
INSERT INTO uro_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Bä nga ma Jisas ka ñäm bävit dä qa lu ama qärhongbärharha i rhat tu arhä vänbon ba ama ansäspämgi ama mor qi at mämuäs. ");
INSERT INTO uro_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Dä qosaqi qa lu ama tlä qi ama maqoski i qia mu ama brasirhom ama gaini nä irhom mamär. ");
INSERT INTO uro_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Dä qä qoar toqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i rhaerhaktni ama maqoski di sa qia mu ama vänbon masirhat pa arhani arhä vänbon angät tpäs. ");
INSERT INTO uro_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Erhärha rhäkt ama ruvek moe di sa rha voda arhä vänbon nävät arhä mämägän dap taerhaktni di qia von nävät arha tläqa rhä qärqäni i mai va mamär vät a qi nävät ini.” ");
INSERT INTO uro_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Arhani ama mudäsaqongda di rhat tamän sävät ama ansäspämgi ama mor qi at murhämeska qäraktni i ama ruvek ta rhäk pät a qi na ama mär ngät ama dui dä ama vänbon iva sage ma Ngämuqa. Sokt di ma Jisas kä qoar toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Bä sävät tärhong däkt kärqärhongni i sa ngiat lu irhong däkt di ama qäväläm nga e iva äm ngä rhän iva qaku qale anga duiqa vono vät akni aa rhäng dap pa rha rhartäm sä ngät moe sa rhämono sävät ivät.” ");
INSERT INTO uro_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Dä rhi snanbät toqortäqyia, “Qamorqa, urhi lu va qäsnia dä rhärhong däkt ngä rhäranas? Dä va agi muqunängi qia rhän iva qi sameng i qorhäs iva rhärhong däkt ngät täranas?” ");
INSERT INTO uro_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Dä qa muvät toqortäqyia, “Ngänit lu mamär i varis aung gä nairas täm ngän. Inguna ama rhäqäp na rha ama ruvek diva rha rhän bä va rhat tualat nävät gu ngärhipki i rhi qoar i, ‘Aingo di ma Krais!’ dä qosaqi ‘Ama qäväläm na aa mänmänäs sa äm nga e glaqot.’ Mamär iva qale ngän det nasot a rha. ");
INSERT INTO uro_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ngakt bä nga sa ama ulaqi qia märanas pät ama ivärhap ama rhäqäp na ap ura ngäni nari iva ama inirqi qiat täranas pät amekni anga ivärhimek mänguräp ama ruvek dä va qale ngänit len. Inguna qoki va rhärhong däkt diva irhong ngä rhän narhoer dap as pa ama tpäsini diva qaku ini ngä namän äkt.” ");
INSERT INTO uro_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Dä qä qoar na rha rhoqortäqyia, “Dä ama ruvek näva amni ama ivärham diva rhat täranas na ama ulaqi sävät a ne dä ama muräktpäm diva ngät täranas sävät a ne. ");
INSERT INTO uro_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dä va ama qängän ama mor ngät dä va ama ruvek tit ñäp mät ama qärhuqi vät apni ama ivärhap dä va ama räm maos maos ngät dän. Dä va ama ruvek tit len masirhat nävät ama rhäqäp nä irhong iva irhong ngät täranas. Dä va ama muqunän ama enges ngät pa ngät dän bät ama usäpki.” ");
INSERT INTO uro_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Dap as nga narhoer vä rhärhong däkt angät kamäs dä va rhi sangar a ngän bä rhi sangäm na ngän mavängam. Va rhat tair na ngän ba ama mämairväm dä va rhat tu ngän ba ama tpäskiarharhäng dä va rhat tair na ngän da ama vitnarha rhi na ama tpäskinarha arhä saqong inguna nävät iomäkt i ngänät nanakt na ngo. ");
INSERT INTO uro_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Rhom däkt diva ama släqyäs bä ba ngän ivakt iva ngäni sameng sävät a ngo. ");
INSERT INTO uro_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","“Sokt di as narhoer dä va ngän du angän snäng mamär iva qale qänäskänes ngän iva ngän dair särhäm mes toqor mäniekt. ");
INSERT INTO uro_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Inguna va ngu von ngän da ama enge dä ama mädräm ama mär ngät bä nga rhoqoräkt dä va qaku mamär vät angäna ikkäna iva rha rhän näva angän bäs sa angäna enge ura va rhi nänairas na ngät. ");
INSERT INTO uro_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bä qäqi va angän mamäkkäna dä angäna matpek dä angäna läktpek dä angän gärhae dä angäna ruavek diva rhi sangar a ngän bä va rhat tu ngän ba ama muräkt dä va rhi veng guavek nävät a ngän. ");
INSERT INTO uro_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ama ruvek moe va ama vu da arha ron mamär sävät a ngän inguna nävät iomäkt i ngänät nanakt na ngo. ");
INSERT INTO uro_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Sokt diva qaku qäbäs na anga sägäk anga qäsega nävät angän bäs. ");
INSERT INTO uro_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nga ngänät mair ma ama qrot diva bä ba ngän na ama iar ama sok täm ngät.” ");
INSERT INTO uro_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ngakt bä nga ngäni lu ama rhäqäp na rha ama ulaqimärharhärhäkt i rhi nging dä ma Jerusalem dä mamär iva ngänät dräm i sa qorhäs iva qäbäs na qi. ");
INSERT INTO uro_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Bä nga rhoqoräkt dä mamär iva iarhakt kärarhae i qale rha e ma Judia di rhi ang masirhat pävit sävät ama dam dap kosaqi va iarhakt kärarhae i qale rha e ma Jerusalem di vuk sä rha nae dap pa iarhakt kärarhae i qale rha dalek nä ma Jerusalem di qale rhi namon sae. ");
INSERT INTO uro_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Inguna rhom däkt ama qäväläm ba äm ngä rhän iva ma Ngämuqa qä sangäm nä ma Jerusalem diva varhäm ma Ngämuqa aa enge qärangätni i ngät tamän doqoräkt. ");
INSERT INTO uro_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Va ama qrot mamär vät iangärhäkt ama qunäng ba ama evop kärarhani i ama sarem däm da bä qosaqi bä iarhakt kärarhae i ama rhoes pät a rha. Inguna ama märänga ama mor qa va qa rhän bät ama Judaqäna arha ivärhäs moe bä va ma Ngämuqa aa uraqi diva arpus na qi sävät iarhakt ama ruvek. ");
INSERT INTO uro_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Arhani diva rhi rhodäkt mät ta na ulaqi arha sen. Dap arhani diva rhi sangar a rha säva ama tpäskiarharhäng ba apni ama ivärhap moe. Ama Jentailqäna va rhi naengmät nä ma Jerusalem näkt pa qale läm ba arhä muräkt bä dängdäng i ma Ngämuqa sa qa mu sa äkt iva qale läkt na arhä muräkt.” ");
INSERT INTO uro_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Va ama muqunän ngä rhän mät ama qunäga dä ama equngi näkt ama qaeng. Dap pa vät ama ivätki moe diva inirqi na ama ruvek dä va rhäqäp ta na ama tlenga nävät ama dädrin nage ama vaeng gärangätni i ngät täranas pä garäska. ");
INSERT INTO uro_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bä va ama ruvek diva räträt pät a rha mät ama tlenga dä iomäkt ama qäväläm angärha ron i qale rha nani agini qärqäni va ini ngä rhän bät ama ivätki inguna va iarhongäkt kärqärhong i qali lirhong mät ama leqäs kärqärhong i irhong angät krot diva sarhäktsarhäkt pät irhong. ");
INSERT INTO uro_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mamär dä va rhi lu ma Ruqa aa Emga i qat dän ba ama eqoeqi sa ama qrot dä ama mor qa ama murhämeska. ");
INSERT INTO uro_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bä nga rhärhong däkt irhong ngärhi nasäng iva irhong ngät täranas dä ngän dair bä va ngäni sek angän bäs inguna sa qorhäs iva rhi rhäqäs täm ngän.” ");
INSERT INTO uro_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Dä ma Jisas kä qoar na rha nä rhangät täkt ama enge na ama siqutki rhoqortäqyia, “Ngäni lu ama rhaunga näkt sävät angät ama ngämung moe. ");
INSERT INTO uro_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ngakt bä vukpuk sa angärha vol bä ngäni lu rhoqoräkt dä sa ngänät dräm i ama qunängit nga e glaqot. ");
INSERT INTO uro_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Di rhoqorne rhoqoräkt i ngakt bä va ngänät lu rhärhong däkt i irhong ngät täranas dä va ngänät dräm i ma Ngämuqa aa Muräktpäm di sa nga e glaqot.” ");
INSERT INTO uro_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nguat tamän särhäm ngän na ama engäktki iva rhit täkt ama qoengait diva qaku rhäksot nä it bä dängdäng i rhärhong däkt di sa irhong ngä märanas. ");
INSERT INTO uro_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ama usäpki qi na ama ivätki diva qäbäs na em dap pa gua enge diva qaku qäbäs na ngät.” ");
INSERT INTO uro_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ngänit lu mamär i varis bok da angän snängaqa nage ama tmäski dä ama tnaktki dä ama qänäskänes masirhat sävät kärqärhongni nämäni rhangätni ama iar i varis iaqäkt ama qunäga qä särmän na ngän masägos toqor ama seoqa qärakni i qä särvät särha ama qaiuqa. ");
INSERT INTO uro_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Bä va iaqäkt ama qunäga qärakni iva evär däm ngo vät a qa diva qa rhän bät ama ruvek moe qärarhani i rhat däqäm bät ama ivätki moe. ");
INSERT INTO uro_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mamär iva ama qarhap ngän basägos dap pa ngäni nän iva ngän däqäne dä mamär i ngäni ingis nämät tärhong däkt kärqärhongni i sa qorhäs iva irhong ngä rhäranas dä qosaqi va ngäni nän iva mamär vät a ngän iva ngänät mair mamär dä ma Ruqa aa Emga aa saqong.” ");
INSERT INTO uro_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Vät ama qunäng nasot a ne dä ma Jisas kä su va ama ansäspämgi ama mor qi näkt ama säpbängang moe dä qat tet bä ama bängagi moe qiat tet pät a qa da ama Damgi na ama Olip at täväs. ");
INSERT INTO uro_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Näkt ama ruvek tat dän bät ama duququs moe mamär ivakt iva rhat nari qa va ama ansäspämgi ama mor qi. ");
INSERT INTO uro_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sa ama tmäski na ama bretkäna qärangätni i qaku anga yis päm ngät käraktni i rhat tes ki i ma Pasova di sa qia e glaqot ");
INSERT INTO uro_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","dä ama priskäna ama moräs na rha näkt sävät ama Skraipkäna di rhit ñäm nani anga iska iva rhi sokot nä ma Jisas ma ama up inguna rhit len ama ruvek. ");
INSERT INTO uro_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Bä nasot dä ma Sämga qa mon sämät ma Judas Iskariot kärakni i qa nävät ama ngärhäqyisem da udiom na rha ama mudäsaqongda. ");
INSERT INTO uro_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Bä qa met bä sage ama priskäna ama moräs na rha dä ama narhoerta bä ama ulaqimärharhärhäkt näva ama ansäspämgi ama mor qi bä rha märhamän särhäm ne rhi na qa iva qä vodä ma Jisas bä ba rha rhoqor mäniekt. ");
INSERT INTO uro_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Dä mär gem da dä rha rhares iva rhi von ga rha anga ligär. ");
INSERT INTO uro_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Bä äkt i qa rhares näkt sa qät ñäm nani anga qäväläm gärqomni i qaku anga guläñgi na anga ruvek ge ma Jisas dap pa qä vodäm ga bä ba rha. ");
INSERT INTO uro_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Sa ama qunäga qa män iva ama Judaqäna rha rhuqunän na ama tmäski na ama bretkäna qärangätni i qaku anga yis päm ngät toqoräkt i rhit boda ama vodämes na ama sipsipkäna ama ngärhoes bä bä ma Pasova. ");
INSERT INTO uro_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Bä äkt i ma Jisas ka rhäk nä ma Pita qä nä ma Jon i qä qoar na iom doqortäqyia, “In det bä ini rhäkmu na ama tmäs sävät ma Pasova bä ba ut iva u äs ngät.” ");
INSERT INTO uro_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Dä in snanbät toqortäqyia, “Nani a nge na un iva uni rhäkmu nä ngät koe?” ");
INSERT INTO uro_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Dä qa muvät pät a iom doqortäqyia, “Nga va inät don sae ma Jerusalem dä va in dän bät ama ruqa i qät ta ama kainaqi na ama rigi. Va in det nasot a qa bä sävä iaqäkt ama vätka qärakni iva qa rhon säväm ga. ");
INSERT INTO uro_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Dä va ini qoar na ama ngärhik nävä iaqäkt ama vätka rhoqortäqyia, ‘Qamorqa qä snanbät toqortäqyia, ngu lu ama qäväläm bä ba ama tmända äm ngä qoe nai iva ngu nä gu mudäsaqongda u äs ma Pasova angärha tmäs e?’ ");
INSERT INTO uro_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Dä va qä qur a en da ama mor äm ama vätka aa qäväläm dävono qärqomni i sa rha rhäkmu na äm. Dä ini rhäkmu na ama tmäski e.” ");
INSERT INTO uro_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","In met bä in lu iarhongäkt moe i qoki rhoqor varhäm ma Jisas aa enge. Dä soknga in däkmu nä ma Pasova angärha tmäs. ");
INSERT INTO uro_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bä nga rhäkmamär na ama qäväläm iva rhat täs dä ma Jisas kä na aa ngangda rha met bä qale rha vät ama laiqa aa rhäkt. ");
INSERT INTO uro_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Dä qa qoar na rha rhoqortäqyia, “Nani a ngo masirhat iva ngua äs takt täkt ama tmäski ma Pasova ngu na ngän narhoer näkt sa nasot dä va ngu rha ama märänga. ");
INSERT INTO uro_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Va ngu qoar na ngän i saqi as kaku ngu namäs näp takt täkt ama tmäski bä dängdäng iva qia rhu at släqyige vät a nas pä ma Ngämuqa aa Muräktpäm.” ");
INSERT INTO uro_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nasot dä ma Jisas ka rha ama kap na ama wain näkt ka mes ama mär sage ma Ngämuqa dä qa qoar toqortäqyia, “Ngäni rha rhärhak bä ngänin bäñmät na ama wain bä ba ne. ");
INSERT INTO uro_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Inguna nguat tamän särhäm ngän iva saqi as kaku ngu nanakt nävät ama wain angät gavam bä dängdäng bät iomäkt ama qäväläm gärqomni iva ma Ngämuqa aa Muräktpäm ngät dän.” ");
INSERT INTO uro_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Näkt ka rha ama bret bä nga nasot i qa mes ama mär dä qa vonamät na qa näkt ka von da näkt kä qoar toqortäqyia, “Rhangät täkt di gu släqyige qärqigeni i ngut bodäm ige iva bä ba ngän. Mamär iva ngän dualat toqor täkt ivakt iva ngän du angän snäng sävät a ngo.” ");
INSERT INTO uro_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Näkt nga rha mäs bä rhäksot dä qosaqi qa rha ama kap na ama wain dä qa qoar toqortäqyia, “Rhak täkt ama kap kärakni i rhit prit na qa iva bä ba ngän di sa qat tuqunän bät ama rharesbane qärangätni i sa gu biaska qa sämaengäktki na ngät. ");
INSERT INTO uro_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Dap sa iaqäkt kärak iva qä vodäm ngo di sa qale qa rhe gem ngo vät ama laiqa aa rhäkt. ");
INSERT INTO uro_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ma Ruqa aa Emga diva qä ñäp toqor varhäm ma Ngämuqa aa snängaqa sokt diva avuqi mamär ge iaqäkt kärak iva qä vodäm ga.” ");
INSERT INTO uro_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Dä rhi nasäng i rhi snanbät sä mänguräp mä ne i auge iaqäkt iva qa rhualat toqoräkt. ");
INSERT INTO uro_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Dä qosaqi ama engirhong ngä märanas mänguräp mä rha i auge nävät a rha di ama vit na qa mamär. ");
INSERT INTO uro_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Dä ma Jisas kä qoaräs na rha rhoqortäqyia, “Ama Jentailqäna arha vitnarha di qoki rhat turäkt täm da masirhat bä arha moräsnarha qärarhani i rhat sangar a rha na ama muräkt ama qrot ngät daver mä rha di rhat tes nas i ama ruvek kärarhani i rhat dräm dat tatnärha ama ruvek. ");
INSERT INTO uro_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Dap aingän diva qale ngän natmualat toqoräkt. Dap kinak iaqäkt kärak i ama moräs na qa mamär mänguräp mä ngän di vadi va qa rhoqor ama rhoemga dap kärakni iva ama narhoerqa na qa diva qa rhoqor ama latka qärakni i qale qa va akni aa rem. ");
INSERT INTO uro_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ngu lu auge di ama moräs na qa mamär nävät taerhiom? Nga qärakni i qat muqun bät ama laiqa aa rhäkt ura ama latka qärakni i qät boda ama tmäs sävät ama laiqa? Iaqäkt kärak i ama moräs na qa mamär di qärak i qat muqun bät ama laiqa aa rhäkt. Sokt di aingo i ngua e mänguräp mä ngän di ngo rhoqor ama latka qärakni i qale qa va akni aa rem. ");
INSERT INTO uro_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Aingän di qärarhae na ngän i ngänät mair irhäm ngo da ama siqutsiqut angärha ron. ");
INSERT INTO uro_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ngut bon ngän dä ama Muräktpäm gosaqi rhoqor gu mamäk i sa qa von ngo rha ama Muräktpäm ");
INSERT INTO uro_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ivakt iva ngän däs dä ngäni nakt pät gu laiqa vä gu Muräktpäm bä va ngän duqun mät ama vitnarha arhä mämugunimek bä va ngän duräkt ba ama ngärhäqyisem da udom na ama enivirhong nae ma Israel. ");
INSERT INTO uro_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Saimon, Saimon, ma Sämga sa qa nän da ama rhares iva qä siqut nä gi qatnanakt iva bok däm ngät. ");
INSERT INTO uro_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Sokt di sa ngua nän sävät a nge iva qale bok dä gi qatnanakt. Näkt nga rhoqoräkt iva evär däm nge sagem ngo dä va ngi sämaqrot nä gia ruavek ama mudäsaqongda.” ");
INSERT INTO uro_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Di nak ka muvät pät a qa rhoqortäqyia, “Gua Engeska, ngua rhäkmu na nas iva ngu na nge säva ama tpäskiarharhäng bä sämät ama tñäpki.” ");
INSERT INTO uro_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Dä ma Jisas ka muvät toqortäqyia, “Pita, nguat tamän särhäm nge iva as kaku ama duraktka qä nanok mamär vät tak täkt ama qunäga dap as pa narhoer dä va ngi rhäqyas na ngo madäpguamek.” ");
INSERT INTO uro_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Dä ma Jisas ka snanbät sä rha rhoqortäqyia, “Nga rhoqoräkt i ngua rhäk na ngän iva ngäni sameng sävät ma Ngämuqa aa Muräktpäm näkt pa qaku ngän nata anga rhae iva nanokt anga ligär ura anga sägän ura anga sandal. Dä mänia, nga ngänit läk nani guani?” Dä rha muvät toqortäqyia, “Qaku.” ");
INSERT INTO uro_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Dä qä qoar na rha rhoqortäqyia, “Dap täkt di ngakt bä gi nga rhaeqa iva nanokt anga ligär dä va ngi rha qa dä qosaqi ngi rha ama sägänaqa dap ngakt bä nga qaku gi nga ulaqi arha singi dä ngi vodä gi nga boiqi anga uiu qi nani anga ligär bä va ngi vodäm bät anga singi. ");
INSERT INTO uro_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Inguna ma Ngämuqa aa enge qärangätni i sa rha säm a ngät di ngät tamän doqortäqyia, ‘Sa rha lu qa sämäni ama ruvek kärarhani i ama vu rha’ bä va ngu qoar na ngän i rhangät täkt ama enge diva ngä rhu angät släqyige vät a ngo. Bä ngäktki, agi a enge qärangätni i sa rha säm a ngät iva sävät a ngo diva ngä rhu angät släqyige vät a nas.” ");
INSERT INTO uro_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Dä ama mudäsaqongda rhi qoar toqortäqyia, “Aurha Engeska, as ngi lu ama ulaqi arha senem ama unbem dä erhem i.” Dä qa muvät toqortäqyia, “Sa qule läkt.” ");
INSERT INTO uro_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ma Jisas ka met säda ama Damgi na ama Olip at täväs toqor vasägos dä aa mudäsaqongda rha met nasot a qa. ");
INSERT INTO uro_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bä nga rha män e vät iosäkt ama ivärhäs dä qä qoar na rha rhoqortäqyia, “Mamär iva ngäni nän sage ma Ngämuqa iva qale ngän namon sämät ama siqutsiqut.” ");
INSERT INTO uro_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Dä qa met sa rhämuk sa gläius maqälak na rha dä qa an da aa quum sä nas näkt kä nän doqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Mam, ngakt bä nga nani a nge dä va ngi rha rhak täkt ama kap na ama märänga nävät a ngo. Sokt di qoki qaku varhäm gu snängaqa dap kinak pa varhäm gi snängaqa.” ");
INSERT INTO uro_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ama ensel na rhävuk päs däm ga gem ga bä qa sämaqrot na qa. ");
INSERT INTO uro_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Qa nari ama märänga ama mor qa dä qä nän mä ama qrot bä aa rega di qa rhoqor ama mädäqap na ama biaska i arharpus na ap sävät ivät. ");
INSERT INTO uro_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bä nga qa märanas nasot aa nän dä evär däm ga samuk sage aa mudäsaqongda bä qa män bät a rha i rhi mänatäm i eqokt ta nage ama märänga ama mor qa. ");
INSERT INTO uro_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Dä qä snanbät sä rha rhoqortäqyia, “Mäniekt bä ngäni mänatäm? Mamär iva ngän däranas bä ngäni nän sage ma Ngämuqa iva qale ngän namon sämät ama siqutsiqut.” ");
INSERT INTO uro_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Bä as nga rhoqoräkt i ma Jisas kat tamän dä ama guläñgi na ama ruvek ta män bä akni ama ruqa qärakni i qa nävät ama ngärhäqyisem da udiom na rha qärak i rhat tes ka i ma Judas kä rhoer nanokt ta. Bä qa met sävät ma Jisas ivakt iva qä vop pa aa sdäm. ");
INSERT INTO uro_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Di nak ma Jisas ka snanbät sä qa rhoqortäqyia, “Judas, nga va ngi vodä ma Ruqa aa Emga rhoqoräkt i ngi vop pa aa sdäm?” ");
INSERT INTO uro_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bä nga ma Jisas aa mudäsaqongda rha lu iangärhäkt ama lat kärangätni iva ngä rhäranas dä rhi qoar na qa rhoqortäqyia, “Aurha Engeska, nga va urhi rhap pät a rha na aurha ulaqi arha sen?” ");
INSERT INTO uro_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Dä akni nävät a rha qa rhäp akni ama pris ama vit na qa aa latka i qa rhodäkt sa aa sdämgi ama märmär qi. ");
INSERT INTO uro_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Dä ma Jisas ka qoar toqortäqyia, “Qule läkt! Saqi as kale guaäm ngä namäranas toqor täkt.” Näkt ka rhäk pät kärak aa sdämgi bä qa mumäräs pät a qa. ");
INSERT INTO uro_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Dä ma Jisas kä qoar na ama priskäna ama moräs na rha dä ama narhoerta bä ba ama ulaqimärharhärhäkt näva ama ansäspämgi ama mor qi näkt sävät ama morta iarhakt kärarhae i sa rha moe rha män nani a qa rhoqortäqyia, “Nak nga ama suaqa na ngo bä äkt i sa ngän män sävät a ngo sa ama ulaqi arha sen dä ama edäm? ");
INSERT INTO uro_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Vasägos dä qale ngo ngu na ngän ba ama ansäspämgi ama mor qi sokt di qaku ngän sangar a ngo. Dap tom däkt di angän gäväläm gärqomni i sa rhäkmamär na äm iva ama bängagi qiat turäkt.” ");
INSERT INTO uro_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Rha sangar ma Jisas näkt ta ang sä qa säva ama pris ama vit na qa aa vätki dap ma Pita di qät päsais täm ga. ");
INSERT INTO uro_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Näkt nga rhoqoräkt i rha ek ta ama mudäbäs mät ama släqyäs pä qa vätki arha ivärhäm dä sa rha muqun bä ma Pita di qa muqun gem da. ");
INSERT INTO uro_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Dä ama latki qia lu qa da ama rhäptäpka nämät ama mudam i qat muqun e. Dä qit täkmareo vät kärak näkt ki qoar toqortäqyia, “Rhak täkt ama ruqa di ma qale qa ge ma Jisas.” ");
INSERT INTO uro_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Sokt di ma Pita qa rhäqyas i qä qoar toqortäqyia, “Rhaktni, qaku nguat dräm iaqäkt.” ");
INSERT INTO uro_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Näkt kale maqälak dä akni qa lu qa dä qä qoar toqortäqyia, “Ainge, di qosaqi ak na nge nävät a rha.” Dä ma Pita qa muvät toqortäqyia, “Rhakni, qaku rhäm ngo.” ");
INSERT INTO uro_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mamär nasot i rhoqor qre i ama aua dä saqi as akni qa märhamän maräkt sävät ma Pita rhoqortäqyia, “Nak ngäktki mamär! Rhak täkt ama ruqa di ma qale qa qä nä ma Jisas inguna qosaqi qa di ama Galiliqa.” ");
INSERT INTO uro_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Dä ma Pita qa muvät toqortäqyia, “Rhakni, sa qaku nguat dräm i ngiat tamän bät agiqa iaqäkt.” Näkt pät iomäkt ama qäväläm maräkt i qat tamän dä ama duraktka qa nok. ");
INSERT INTO uro_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Dä ma Engeska qa rhong bät a nas bä qa ñäm maräkt sävät ma Pita. Dä vuk pät ma Pita na ama enge qärangätni i sa ma Engeska qa märhamän särhäm ga na ngät toqortäqyia, “Va as kaku ama duraktka qä nanok mamär dap pa ngi rhäqyas na ngo madäpguamek i qaku ngiat dräm a ngo.” ");
INSERT INTO uro_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Dä vuk sä qa sä dalek bä qät nok i airäs ka masirhat. ");
INSERT INTO uro_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ama ruvek kärarhani i rhat sangar ma Jisas di rhat tuma qa dä rhi arhäktgyäm sä qa. ");
INSERT INTO uro_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bä qosaqi rha qop mät aa saqong näkt ti qoar na qa rhoqortäqyia, “Ngi qoar na ut i auge qa an mä nge!” ");
INSERT INTO uro_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Näkt ta slava nä ma Jisas na angätni ama rhäqäp na ngät ama enge ama vu ngät. ");
INSERT INTO uro_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bä nga qunäga dä ama guläñgi na ama narhoerta bä ba ama ruvek i ama priskäna ama moräs na rha dä ama Skraipkäna di sa västämne na rha näkt ta rha ma Jisas iva qa rhair da arhä saqong. ");
INSERT INTO uro_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Dä rhi qoar toqortäqyia, “Ngakt bä ma Krais na nge dä va ngi qoar na ut i ngäktki rhoqoräkt.” Dä ma Jisas ka muvät toqortäqyia, “Ngakt bä ngu qoar na ngän doqoräkt dä va qaku ngän namat maengäkt nämät ngo. ");
INSERT INTO uro_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Dap ngakt bä ngu snanbät sä ngän sävät a nas dä va qaku mamär iva ngän namuvät. ");
INSERT INTO uro_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Dap pa mänasäng narhäkt bä rhävit di ma Ruqa aa Emga diva qat muqun dä ma Ngämuqa aa märmär iaqäkt kärak i ama qrot moe angät tarebäm.” ");
INSERT INTO uro_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dä soknga rha moe rha snanbät toqortäqyia, “Bä nak nga ma Ngämuqa aa emga na nge?” Dä qa muvät toqortäqyia, “Sa ngän damän doqoräkt.” ");
INSERT INTO uro_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Dä rhi qoar toqortäqyia, “Saqi as pa nani a ut na agung anga enge säng aa rhäng doqor mäniekt? Nak sa ut nari mamär na ama enge nämät aa vämgi maräkt.” ");
INSERT INTO uro_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Dä soknga iaqyäkt ama guläñgi na ama narhoerta di rha moe rha märanas bä rha artäm sä qa sage ma Pailat. ");
INSERT INTO uro_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Dä rhi nasäng iva rhit täksärhäm ga bä rhi qoar toqortäqyia, “Sa ut lu i rhak täkt ama ruqa di sa qä rhartäm sa aurha ruvek sämät ama vuirhong. Dä qat tair särha ama ruvek iva qale rhit boda ama takes bä bä ma Sisar dä qat tes nas i qa di ma Krais dä ama vitnaqa na qa.” ");
INSERT INTO uro_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Dä ma Pailat ka snanbät sä qa rhoqortäqyia, “Nga ainge di ama Judaqäna arha vitnaqa na nge?” Dä ma Jisas ka muvät toqortäqyia, “Sa ngia märhamän doqoräkt.” ");
INSERT INTO uro_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Dä ma Pailat ka märhamän särha ama priskäna ama moräs na rha rhi na ama guläñgi nä qa ruvek toqortäqyia, “Qop kaku ngua män bät guani vät tärhak ama ruqa.” ");
INSERT INTO uro_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Sokt di rha vono bä rha märhamän ma ama qrot toqortäqyia, “Nak kat tuinirqi na ama ruvek na aa rhisu e ma Judia moe. Qa nasäng nae ma Galili näkt ka met nae bä inamuk bä äkt bä sarhe.” ");
INSERT INTO uro_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Bä nga ma Pailat ka nari rhoqor täkt dä qä snanbät ivar iaqäkt ama ruqa di ama Galiliqa. ");
INSERT INTO uro_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bä nga ma Pailat ka räm doqoräkt i ma Jisas di qale qa vä ma Herot Antipas aa rem dä qa rhäk na qa sage ma Herot inguna vät iangärhäkt ama qunäng di sävät ma Herot e ma Jerusalem. ");
INSERT INTO uro_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bä nga ma Herot ka lu ma Jisas dä mär gem ga masirhat inguna mudu qat namu mauiu iva qä lu qa. Bä nga qa nari sävät ma Jisas dä nani a qa iva qä lu qa i qa rhualat na anga nañis ngät ama lat toqor ma. ");
INSERT INTO uro_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Dä ma Herot ka snanbät sä qa na ama rhäqäp ama snanbät sokt di qop ma Jisas kaku qa muvät pät a qa na anga qäväläm. ");
INSERT INTO uro_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Dä ama priskäna ama moräs na rha näkt sävät ama Skraipkäna di rhat mair e bä rhit kutmät na qa na ama enge ama qrot ngät. ");
INSERT INTO uro_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Bä ma Herot kä na aa ulaqimärharhärhäkt di rhi slava na qa mamär dä rhat tuma qa näkt mamär dä rha monmät pät a qa na ama mär qi mamär ama boiqi ama uiu qi näkt saqi sa rha rhäk na qa sage ma Pailat. ");
INSERT INTO uro_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Vät iaqäkt ama qunäga dä ma Herot kä nä ma Pailat di ina ruaiom na ne mamär dap as mudu di ina iqiom na ne. ");
INSERT INTO uro_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ma Pailat ka mes ama priskäna ama moräs na rha dä ama tpäskinarha näkt ama ruvek ");
INSERT INTO uro_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","bä qa qoar na rha rhoqortäqyia, “Sa ngän män sä rhak ama ruqa gem ngo näkt ngäni qoar i qat tuinirqi na ama ruvek. Sokt di nga ngua snanbät sä qa da angän saqong dä qaku ngua män bät guani qärqäni i ini ngärhi sameng i ngäktki na angäna rhäksärhäm sävät a qa. ");
INSERT INTO uro_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Bä qosaqi ma Herot di qaku qa män bät guani vät a qa dä soknga qa evär däm ga sagem ut. Bä ngänät lu mamär i qaku qa mualat nä guani qärqäni iva ini ngärhi rha qa sämät ama tñäpki. ");
INSERT INTO uro_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Bä va ma ngo i ngu vodäm ga bä va rhi vuspus ka näkt ngu rhäväkt sä qa.” ");
INSERT INTO uro_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Di nak kä guläñgi moe qia nästäm dävuk toqortäqyia, “Sa ngän det sä iaqäkt ama ruqa nae sämät ama tñäpki. Dap pa ngi rhäväkt sä ma Barabas sagem ut!” ");
INSERT INTO uro_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ma Barabas di sa rha mu qa va ama tpäskiarharhäng nävät ama inirqi qäraktni i sa qia märanas e ma Jerusalem näkt kosaqi nguna qa veng ama ruqa rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ma Pailat ka siqut ka mon bät ama ruvek arhä rhut i nani a qa iva qä rhäväkt sä ma Jisas. ");
INSERT INTO uro_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sokt di qop tit nästäm doqortäqyia, “Ngi edämsäs pät a qa mäni ama sämänanamuqa! Ngi edämsäs pät a qa!” ");
INSERT INTO uro_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Näkt sa nga rhoqoräkt iva madäpguamek dä qä snanbät sä rha rhoqortäqyia, “Va vät agiqa? Sa qa mualat na agi a lat anga vu ngät? Qop kaku ngua män bät guani säng aa rhäng iva qa rhet sämät ama tñäpki vät ini angät tpäs. Bä ma ngo iva ngu vodäm ga ivakt iva rhi vuspus ka näkt pa ngu rhäväkt sä qa.” ");
INSERT INTO uro_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Sokt di qop tit näs tävuk masirhat iva qoki qä edämsäs pät a qa bä dängdäng i arha enge ngä mäqäne dä mamär nä ma Pailat. ");
INSERT INTO uro_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Dä ma Pailat ka mu aa snäng iva qa rhet parhäm arhä snängaqa iva rhi edämsäs pät ma Jisas. ");
INSERT INTO uro_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Dä qa rhäväkt sä ma Barabas kärakni i sa mudu rha rhon na qa säva ama tpäskiarharhäng inguna nävät ama inirqi qäraktni i sa qia märanas bä qa veng ama ruqa e ma Jerusalem. Iaqäkt ama ruqa di qärak i sa rha nän däm ga dap ka vodä ma Jisas parhäm arhä snängaqa sämät ama tñäpki. ");
INSERT INTO uro_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bä nga rhoqoräkt i rhat tet sä qa dä rha sangar ma Saimon gärakni i qa näva ama värhäm ama mor äm ma Sairini qärak i mai qat tet parhäm aa iska iva sae ma Jerusalem. Rha sangar a qa bä rha mu ama sämänanamuqa da aa lang näkt pa qät ta qa nasot ma Jisas. ");
INSERT INTO uro_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ama ruvek masirhat tat tet nasot a qa rhi na ama evop i rhit nok mät arha iräski sä qa. ");
INSERT INTO uro_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Dä ma Jisas ka rhong bät a nas dä qä qoar na rha rhoqortäqyia, “Evop nae ma Jerusalem, gale ngänit nok sä ngo dap kinak pa ngänit nok sä nas dä sa angän oes. ");
INSERT INTO uro_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Inguna ama qäväläm nga e iva äm ngä rhän iva ngäni qoar toqortäqyia, ‘Ama märmärgem sage ama evop ama rhängaräs ta qärarhani i qaku rhit sa ama rhoes bä sävät iarhakt kärarhae i qaku rhit bon ama rhoes ti mem!’ ");
INSERT INTO uro_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Vät iomäkt ama qäväläm dä va rha rhamän sävät ama dam doqortäqyia, ‘Arpus na ngän bät urha rhäng’ dap pa rhi qoar na ama dabap toqortäqyia, ‘Ngäni ngaip ut!’ ");
INSERT INTO uro_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ngakt bä rhat tualat nä rhärhong däkt sävät ama ngämuga qärakni i ama iar qa di nak pa rha rhualat nä irhong masirhat mamär sävät kärak ama ngämuga i ama qek däm ga.” ");
INSERT INTO uro_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ama udiom ama ruiom ama vu iom di qosaqi rha met sä iom ivakt iva rhi veng iom in nä ma Jisas. ");
INSERT INTO uro_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bä nga rhat tet bä sävät iosäkt ama ivärhäs kärqosni i rhat tes äs i ama rhomga aa uväski dä rha edämsäs pät a qa e näkt sävät kärqiom ga vuiom i ak sädä ma Jisas aa märmär dap akni säda aa sael. ");
INSERT INTO uro_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Dä ma Jisas kä qoar toqortäqyia, “Mam, ngi qyiradeng ba rha inguna qaku qunäga vät a rha sä iangärhäkt ama lat kärangät i rhat tualat na ngät.” Dä ama ulaqimärharhärhäkt ta matmät na aa boi ba ne na ama serhäm gärangätni i serhäm da nani a ngät. ");
INSERT INTO uro_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ama ruvek di rhat mair bä rhat lu rhoqoräkt bä ama Judaqäna arhä narhoerta di rhat tuma qa. Dä rhi qoar toqortäqyia, “Qa mumaiar na arhani dap padi va qa rhumaiar nas kre i ngäktki i qa di ma Krais nage ma Ngämuqa qärakni i ma Ngämuqa qa armeng däm ga.” ");
INSERT INTO uro_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Bä qosaqi ama ulaqimärharhärhäkt ta met pävit bä sagem ga dä rha muma qa i rha von ga rha arhä wain ama valak mät ki ");
INSERT INTO uro_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","näkt ti qoar na qa rhoqortäqyia, “Ngakt bä ama Judaqäna arha vitnaqa na nge dä sa ngia rhumaiar nas.” ");
INSERT INTO uro_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bä qosaqi rha mu ama enge qärangätni i sa rha säm a ngät daver mä qa qärangätni i ngät tamän doqortäqyia, “Rhak täkt di ama Judaqäna arha vitnaqa.” ");
INSERT INTO uro_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Akni nävät kärqiomni ama vuiom i inät nar di qa slava nä ma Jisas na ama enge ama vu ngät i qa märhamän särhäm ga rhoqortäqyia, “Nak nga qaku ma Krais na nge? Dä ngia rhumaiar nas dä ngia rhumaiar un!” ");
INSERT INTO uro_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Di nak akni ama vuqa qa rhäkne vät kärak na ama enge ama qrot ngät toqortäqyia, “Nak nga qaku ngit kutdrir sävät ma Ngämuqa rhoqor täkt i ut moe ut ta ama rhäksärhäm bä rha sangäm na ut? ");
INSERT INTO uro_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Aiun di mamär na un däkt inguna unit ta ama ruanini vät auna lat ama vu ngät. Dap taerhak täkt ama ruqa di qaku qa mualat na anga lat anga vu ngät.” ");
INSERT INTO uro_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Dä qä qoar nä ma Jisas toqortäqyia, “Jisas, ngakt bä nga ngi nasäng iva ngiat turäkt pä gi muräktpäm dä mamär iva ngia rhu gi snäng sävät a ngo.” ");
INSERT INTO uro_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Nguat tamän särhäm nge na ama engäktki i rhäqyerhäkt diva qale nge ngi na ngo va ama ivärhäs na ama märmärgem.” ");
INSERT INTO uro_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Bä nga nani äkt i mäniqunäng dä ama bängangit ngä män bät ama ivätki moe bä qale rhoqoräkt bä dängdäng bät ama däpguarhong säpbängang ");
INSERT INTO uro_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","inguna qaku ama qunäga qat nañäm. Dä ama boiqi ama mor qi qäraktni i qiat nar va ama ansäspämgi ama mor qi di qyiret mät ki näda at täväs bä samäk bä ama qävälam ama unbam. ");
INSERT INTO uro_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Dä ma Jisas ka näs masirhat toqortäqyia, “Mam, nguat tu gu qloqaqa vä ngia rhäkt.” Bä nga qa märhamän doqor täkt näkt sa qa ñäp. ");
INSERT INTO uro_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Bä nga ama narhoerqa bä ba ama handret na rha ama ulaqimärharhärhäkt ka lu iangärhäkt ama lat moekt dä qa ansäs sage ma Ngämuqa rhoqortäqyia, “Ngäktki mamär i rhak täkt di ama räkt ka ama ruqa dä ma Ngämuqa aa saqong.” ");
INSERT INTO uro_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bä nga ama ruvek moe iarhakt kärarhae i västämne na rha ivakt iva rhi lu di nga rha lu iangärhäkt ama lat sävät ma Jisas dä vräs na rha säva arha vät dap ti nän arhä brärhap mät ama iräski. ");
INSERT INTO uro_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dap iarhakt moe qärarhae i rhat dräm ma Jisas näkt sävät ama evop kärarhani i sa rha väs aa rhäng nae ma Galili di as tat mair tämuk gläius bä rhat lu rhangät täkt ama lat. ");
INSERT INTO uro_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Qale akni ama ruqa e qärakni i rhat tes ka i ma Josep kärak i qa nämät ama värhäm ma Arimatea näkt ka nämäni ama guläñgi na ama narhoerta mamär ma Sanedrin. Qa di ama mär qa ama ruqa dä ama räktka na qa dä ma Ngämuqa aa saqong ");
INSERT INTO uro_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","bä qaku qät tares pät iaqäkt ama snängaqa bä iangärhäkt ama lat kärangätni i sa rha mualat na ngät sä ma Jisas. Näkt kosaqi qale qa nani ma Ngämuqa aa Muräktpäm iva ngä rhän. ");
INSERT INTO uro_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Qa met bä sage ma Pailat dä qa nän ga rhä ma Jisas aa släqyige. ");
INSERT INTO uro_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nasot dä qa rha ama släqyige samäk nämäni ama sämänanamuqa näkt ka ong bät ige na ama uiu qi ama boiqi ama ingas ki. Näkt ka mu ige mät ama ñäpka aa liqi qäraktni i sa rha rhap ma qi mäni ama qäsävit kärakt i as kaku rha mu anga ñäpka aa släqyige mät ki. ");
INSERT INTO uro_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Rhoqoräkt di vät ama qunäga na ama rhäkmunanaska bä sa qorhäs iva ama Sabat kä nasäng. ");
INSERT INTO uro_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ama evop kärarhani i rhi nä ma Jisas ta met nae ma Galili di rha met nasot ma Josep bä rha lu ama ñäpka aa liqi näkt ta lu i qa mas na ama släqyige rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Dä soknga evär däm da bä säva arha vät dä rha rhäkmu na arhong gärqärhongni i ama mär irhong angät tamaska iva sävät ama släqyige. Näkt mae vät a rha vät ama Sabat toqor varhäm ama Muräkt i ngät tamän. ");
INSERT INTO uro_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Näkt duququ vät ama narhoerqa ama qunäga säng ama tadenas toqoräkt i qorhäs iva irige sa ama qunäga dä ama evop ta rha iarhongäkt kärqärhong i sa rha rhäkmu nä irhong i ama mär irhong angät tamaska näkt ta met sä irhong iva sämät ama liqi qäraktni i sa rha mas nä ma Jisas mät ki. ");
INSERT INTO uro_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Dä rha män bät ama dulige qärqigeni i sa aung ga egaeng ige nämät ka liqi qärqige i manaia dä sa rha väsdät nä ige mät ki ");
INSERT INTO uro_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","näkt nga rhoqoräkt i rha mon savuk sämät ka liqi dä qaku rha män bät ma Engeska ma Jisas aa släqyige. ");
INSERT INTO uro_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bä nga rhoqoräkt i rhat tu arhä snäng masirhat sävät tom däkt ama qäväläm dä väs da ama ruiom masägos bä inät mair e gem da näkt ain boi di qaliqalae vät a ngät bä ngi qoar qre bañämbañäm mät ama iauska. ");
INSERT INTO uro_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Dä qa evop ta an da arhä väs samäk sävät ivät mät ama tlenga dä nak kä gamuiom ini qoar na rha rhoqortäqyia, “Mäniekt bä ngänit ñäm nani ama ngätdäqämga mänguräp ama ñäpta? ");
INSERT INTO uro_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Qa di qaku a qa rhe. Nak sa qa märanas! Nga qunäga vät a ngän sa aa enge iangärhäkt kärangät i qa märhamän särhäm ngän na ngät toqoräkt i as kale qa gem ngän e ma Galili?” Qat tamän doqortäqyia, ");
INSERT INTO uro_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Ma Ruqa aa Emga diva rhi vodäm ga säva ama vu rha ama ruvek arhä rhäkt bä va rhi edämsäs pät a qa näkt pa nasot ama dävaung na qa ama qunäga dä va saqi qa rhäranas nämät ama tñäpki.” ");
INSERT INTO uro_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Dä soknga vuk pät a rha na aa enge. ");
INSERT INTO uro_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bä nga evär däm da nämät ama liqi dä rha sameng sävät tärhong däkt moekt bä ba ama ngärhäqyisem da sägäk na rha ma Jisas aa mudäsaqongda näkt sävät arhani ama ruvek moe. ");
INSERT INTO uro_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Iarhakt moekt ama evop kärarhae i rha sameng nä rhom däkt bä ba ama ngangda rhi na arhani ama ruvek di ma Maria näva ama värhäm ama gaini na äm ma Makdala näkt ma Joana näkt ma Maria ma Jems aa nanäk näkt sävät arhani kärarhani i rhi na rha. ");
INSERT INTO uro_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Sokt di qop kaku rhat nanakt na ama evop inguna ama evop arha enge bä ba rha di gem da di ngäkt kre i ama enge mavängam. ");
INSERT INTO uro_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Sokt di qoki as ma Pita di qa märanas bä qa ang masirhat sämät ama ñäpka aa liqi bä qa angär sämät ka liqi dä qa lu ama boiqi i qali qi rhämuk sä nas dä saqi evär däm ga dap kat tu aa snäng sävät iangärhäkt ama lat kärangätni i sa ngä märanas toqoräkt. ");
INSERT INTO uro_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Dap toqoräkt pät iaqäkt ama qunäga di aiomni ama rhisuiom nävät a rha di in det sämät aomni ama värhäm gärqomni i rhat tes äm i ma Emeus näkt iomäkt ama värhäm di ngäkt kre ama ngärhäqyisem na ama kilomitaqäna nae ma Jerusalem sae sämät äm. ");
INSERT INTO uro_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","In det dä in damän särhäm ne sävät iarhongäkt moekt kärqärhong i sa irhong ngä märanas e ma Jerusalem. ");
INSERT INTO uro_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bä nga rhoqoräkt i in damän särhäm ne dap ini veng ne sä iarhongäkt dä ma Jisas maräkt ka met pävit bä qat tet kä na iom ");
INSERT INTO uro_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","sokt di sa rha väs na ama bängagi mät ain saqong bä qaku in dräm a qa. ");
INSERT INTO uro_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Dä qa snanbät sä iom doqortäqyia, “In det dap ini veng ne sa agiqa?” Dä in mair dap mänadin däm iom dap inät nañäm na ama iräski. ");
INSERT INTO uro_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Dä akni nävät a iom gärakni i rhat tes ka i ma Kliopas kä snanbät sä qa rhoqortäqyia, “Nak kop nga ainge di sokt nge ama nañiska na nge sae ma Jerusalem bä äkt i qaku ngiat dräm nä iarhongäkt kärqärhong i sa irhong ngä märanas bät tangät täkt ama qunäng?” ");
INSERT INTO uro_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Dä ma Jisas ka snanbät toqortäqyia, “Agirhong iarhongäkt?” Dä in muvät toqortäqyia, “Sävät ma Jisas nae ma Nasaret. Qa di ma Ngämuqa aa vämginaqa näkt täqäp ka na ama qrot säda aa enge angärha ron bä säda aa lat angärha ron dä ma Ngämuqa aa saqong dä säda ama ruvek moe arhä saqong. ");
INSERT INTO uro_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ama priskäna ama moräs na rha rhi na ama narhoerta rha vodäm ga ivakt iva rhi sangäm na qa sämät ama tñäpki bä rha edämsäs pät a qa ");
INSERT INTO uro_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","sokt di ut tu ut snäng i qa di nak kärak iaqäkt iva qä rhäksasot ma Israel. Sokt di nga rhoqoräkt i iarhongäkt ngä märanas bä sarhäkt di sa ama dävaung na qa ama qunäga rhak täkt. ");
INSERT INTO uro_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Näkt aomni sae sävät tangät täkt angärha rhäng gärqomni i qräk mät ut nävät a äm di nga aurha evop ta rhäqasäp mai vät duququs iva sämät ama liqi ");
INSERT INTO uro_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bä nga qaku rha män bät aa släqyige dä rha män bä rha qoar na ut i sa rha lu ama ñämñämgi sävät ama enseliom bä ama enseliom in goar i ama ngätdäqäm ga. ");
INSERT INTO uro_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Dä soknga arhani aurha ruavek ta met bä sämät ka liqi dä rha lu iarhongäkt moekt i rhoqor varhäm ama evop arha enge qärangätni i sa rha märhamän bät a ngät sokt di qaku rha lu ma Jisas aa släqyige e.” ");
INSERT INTO uro_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dä qa qoar na iom doqortäqyia, “Nak ama dädända na ngän dä qaku ngänit lir ngänät nanakt na ama enge nage ma Ngämuqa aa vämginarha. ");
INSERT INTO uro_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Gusna i ma Krais diva as ka er qä rha rhärhong däkt angät märänga näkt sa nasot dä va qa rhon säda ama usäpki arha ron bä qä rha ama murhämeska nage ma Ngämuqa?” ");
INSERT INTO uro_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dä ma Jisas kät täväktsäs bä ba iom na ama enge sävät a nas kärangätni i mudu ma Moses bä sävät ma Ngämuqa aa vämginarha moe rha säm a ngät. ");
INSERT INTO uro_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bä nga rhat tet bä sa glaqot nä iomäkt ama värhäm gärqomni i rhat tet iva sae dä ma Jisas di qop kat tet iva qa rhet nä iomäkt ama värhäm. ");
INSERT INTO uro_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Dä soknga init sangar na qa i ini qoaräs na qa rhoqortäqyia, “Qale nge gem un i sa qaku anga mor qa anga qunäga dap sa qorhäs iva bängagi.” Dä qa met iva qale qa gem iom. ");
INSERT INTO uro_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bä nga qa muqun bät ama laiqa aa rhäkt kä na iom dä qa rha ama bret bä qa mes pät ama modämne näkt ka von mät ka näkt ka von iom. ");
INSERT INTO uro_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Dä qunäga mät in saqong bä in räm a qa dä soknga qäbäs na qa nädä in saqong. ");
INSERT INTO uro_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Dä ini snanbät sagem ne rhoqortäqyia, “Nga rhäqyerhäkt di nak kaku ngiat nari ama märmärgem dä gia ron barhäm ama iska rhoqoräkt i qät täväktsäs bä ba un nä ma Ngämuqa aa enge?” ");
INSERT INTO uro_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Dä qop in märanas äkt bä evär däm iom sae ma Jerusalem. Bä in män bät ama mudäsaqongda ama ngärhäqyisem da sägäk na rha näkt sävät arhani qärarhani i mäqi rhit päs ma Jisas aa rhäng gärarhae i västämne na rha ");
INSERT INTO uro_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","dap tat tamän doqortäqyia, “Ngäktki mamär, ma Engeska sa qa märanas bä qa män ge ma Saimon.” ");
INSERT INTO uro_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dä in märhamän särhäm da mamär sävät ama lat iangärhäkt kärangät i sa ngä märanas toqoräkt i rhat tet parhäm ama iska. Bä sävät ma Jisas i in dräm a qa di rhoqoräkt i qa von mät ama bret. ");
INSERT INTO uro_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bä as nga in damän särhäm da rhoqor täkt dap kinak päs dä ma Engeska bä qa mair gem da dä qä qoar na rha rhoqortäqyia, “Ama bulap sagem ngän.” ");
INSERT INTO uro_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Dä rhäqäp ta na ama tlenga inguna rhat tu arhä snäng i rhat lu ama rhomga. ");
INSERT INTO uro_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Di nak kä snanbät sä rha rhoqortäqyia, “Mäniekt bä ngänit len dä mäniekt bä qaku ngänät nanakt? ");
INSERT INTO uro_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ngäni lu ngua rhäqyiglem dä gua qäriglem i nak koki ngäktki i ma Jisas na ngo. Ngäni rhäk pät a ngo ivakt iva ngäni räm inguna ama qloqaqa di qaku aa anga släqyige dä anga släp toqor ngo i aingo di gu släqyige dä ama släp nga e väm ngo.” ");
INSERT INTO uro_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Qa qoar na rha rhoqor täkt näkt ka qur a rha rha aa rhäqyiglem dä aa qäriglem. ");
INSERT INTO uro_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Dä qoki as kaku rhat nanakt mamär inguna rhäqäp ta na ama märmärgem dä rhat tu arhä snäng masirhat dä qa snanbät sä rha rhoqortäqyia, “Nga qaku guani rhe iva ngua äs?” ");
INSERT INTO uro_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dä rha von ga rha ama qäväläm nämäni ama rhinämga ama mang ga ");
INSERT INTO uro_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","bä qa rha läm bä qa mäs äm da arhä saqong. ");
INSERT INTO uro_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Dä qä qoar na rha rhoqortäqyia, “Qre rhoqoräkt i as kale ngo gem ngän dä ngua märhamän särhäm ngän nä rhangät täkt ama enge i iarhongäkt moe qärqärhong i sa rha säm irhong sävät a ngo vä ma Ngämuqa aa Muräkt nage ma Moses bä nage ma Ngämuqa aa vämginarha bä sävät ama Abuk na ama Mabu diva irhong ngä rhu angät släqyige vät a nas.” ");
INSERT INTO uro_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dä soknga qa muqunäga mät arhä mädräm ivakt iva qunäga vät a rha sä ma Ngämuqa aa enge. ");
INSERT INTO uro_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Näkt ka qoar na rha rhoqortäqyia, “Ma Ngämuqa aa enge di ngät tamän doqortäqyia, ‘Ma Krais diva rhi veng ga näkt pa qa rhäranas nämät ama tñäpki vät ama dävaung na qa ama qunäga ");
INSERT INTO uro_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","näkt pa rhi sameng nävät aa ngärhipki iva ama ruvek diva rhi näpgoer na nas dä va ma Ngämuqa qä qyiradeng na arha vuirhong. Va rhi sameng bät ama ruvek pät ama ivätki moe mänasäng nae ma Jerusalem.’ ");
INSERT INTO uro_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Bä va aingän diva ngäni sameng sävät tangät täkt ama lat kärangätni i sa ngän lu ngät. ");
INSERT INTO uro_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Va ngu rhäk na ama Qloqaqa ama Qumärqumärqa bä ba ngän gärakni i sa mudu ma Ngämuqa qa märhamän na ama enge na ama mumänaris ba ngän sokt diva qale ngän de ma Jerusalem bä dängdäng iva ngäni rha ama qrot na rhävuk.” ");
INSERT INTO uro_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bä nga qa artäm sä rha nae bä sae ma Betani dä qa sek aa rhäkt bä qa modämne na rha. ");
INSERT INTO uro_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Bä nga qat dodämne na rha dä qat tet daqule rha bä qa an dävit sa rhävono. ");
INSERT INTO uro_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Dä soknga rha ansäs sagem ga näkt evär däm da sae ma Jerusalem sa ama märmärgem ama mor ngät. ");
INSERT INTO uro_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Näkt pasägos dä qale rha va ama ansäspämgi ama mor qi bä rhi nänsäs sage ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mudu vät ama rharimini i as kaku ama ivätki qi na ama usäpki di sa qale ama Enge. Bä iangärhäkt ama Enge di sa qale ngät ngä nä ma Ngämuqa. Bä iangärhäkt ama Enge di ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Näkt iangärhäkt ama Enge di sa qale ngät ngä nä ma Ngämuqa vät ama rharimini. ");
INSERT INTO uro_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Iarhongäkt moe di irhong ngä män nävät a qa. Dap kaku guani ngä män näva aung anga iska. ");
INSERT INTO uro_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Näkt ka di ama rharebäm na qa sa ama iar. Bä iangärhäkt ama iar di ama neraqa na ngät ba ama ruvek moe. ");
INSERT INTO uro_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Näkt kosaqi iaqäkt ama neraqa di qat nañäm ba ama bängagi. Dap sokt di iaqyäkt ama bängagi di qaku mamär vät a qi iva qia rhän näva ama neraqa aa uväs. ");
INSERT INTO uro_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Maos dä akni ama ruqa qa män gärakni i ma Ngämuqa qa rhäk na qa qärak i rhat tes ka i ma Jon. ");
INSERT INTO uro_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Qa män iväkt iva qä sämaengäktki sävät iaqäkt ama neraqa iva nävät ma Jon dä va ama ruvek ta rhat maengäkt. ");
INSERT INTO uro_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Iaqäkt ma Jon di qaku ama neraqa na qa. Dap ka män iväkt iva qä sameng sävät ama neraqa. ");
INSERT INTO uro_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Dap ama engäktki na qa ama neraqa qärakni i qät boda ama neraqa ba ama ruvek moe diva qat dän sämäni ama ivätki. ");
INSERT INTO uro_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Iaqäkt ama neraqa di sa qale qa mäni ama ivätki. Bä ngäktki i sa qa säm iarhongäkt moe nävät ama ivätki sokt di qaku ama ruvek nämäni qi rha lu mamär na qa. ");
INSERT INTO uro_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Qosaqi qa män sage aa ruvek sokt di iarhakt aa ruvek di qaku rha ar sä qa. ");
INSERT INTO uro_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sokt di sage iarhakt kärarhae i sa rha ar sä qa sagem mes bä rhat nanakt na qa di sa qa voda rha ama rhares iva rha rhän i ma Ngämuqa aa es na rha. ");
INSERT INTO uro_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bä iarhakt kärarhae i ma Ngämuqa aa es na rha di sa qaku rha män nävät arhä mamäkkäna arhä biaska ura varhäm ama ruvek arhä snängaqa. Bä qosaqi qaku rha män nävät ama ngärhaegurhini dap ta män doqoräkt i ma Ngämuqa aa es na rha dinguna rha män nävä ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Näkt iaqäkt ama Enge di sa qa mu ama släqyige vät a nas bä qa män i ama ruqa bä iaqäkt ama ruqa di sa qale qa mänguräp mä ut bä ut lu aa murhämeska. Sa ut lu aa murhämeska i ma Ngämuqa aut mamäk aa emga ama sägäk na qa qärakni i rhäqäp ka na ama ñämsävätki ama mor qi dä na ama engäktki. ");
INSERT INTO uro_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ma Jon ga sameng sävät a qa i qät näs masirhat i qat tamän doqortäqyia, “Rhak täkt di iaqäkt kärak i mäqi nguat tamän sävät a qa rhoqortäqyia, ‘Qärak iva as ka rhän nasot a ngo di ama moräs na qa vät ngua väs inguna mudu sa qa er qa män näkt sä ngo.’” ");
INSERT INTO uro_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Bä nävät aa ñämsävätki ama mor qi dä sa ut moe ut ta iangärhäkt ama modämne qärangätni i ngät dän nasot a ne. ");
INSERT INTO uro_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ma Ngämuqa qa von ma Moses ta ama Muräkt. Dap ama ñämsävätki dä ama engäktki di in män nage ma Jisas ma Krais. ");
INSERT INTO uro_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","As kaku aung sa qa lu ma Ngämuqa dap sokt ma Ngämuqa aa emga ama sägäk kärakni i qa di ma Ngämuqa qärak i sa qale qa da aa mamäk aa sdäm di qa qur a ut täm ga. ");
INSERT INTO uro_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Rhangät täkt di ma Jon aa enge sävät a nas toqoräkt i ama Judaqäna näva ama värhäm ama mor äm ma Jerusalem da rhäk na ama priskäna rhi na ama Livaiqäna ivakt iva rhi snanbät sä qa i qa di auge. ");
INSERT INTO uro_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Sokt di qa muqunäga sävät a nas i qa sameng sävät a nas mamär i qä qoar toqortäqyia, “Aingo di qaku ma Krais.” ");
INSERT INTO uro_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Dä rha snanbät sä qa rhoqortäqyia, “Bä nga rhoqoräkt dä sa auge na nge? Nga ainge di ma Elaija?” Dä qa muvät pät a rha rhoqortäqyia, “Qaku ma Elaija na ngo.” Dä qosaqi rha snanbät sä qa rhoqortäqyia, “Nga ainge di iaqäkt kärak ma Ngämuqa aa vämginaqa?” Dä qa muvät toqortäqyia, “Qaku.” ");
INSERT INTO uro_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Dä rha snanbät sä qa rhoqortäqyia, “Dap auge na nge? Ngi von ut ta anga muvätki iva evär däm ut sä qi bä iarhakt kärarhae i sa rha rhäk na ut. Dä ngia rhamän doqor mäniekt sävät a nas?” ");
INSERT INTO uro_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Dä ma Jon ga muvät parhäm ma Aisaia ma Ngämuqa aa vämginaqa aa enge qärangätni i ngät tamän doqortäqyia, “Aingo di iaqäkt kärak i aa eguinga qät näs pät ama qräk dä bäs ama ivärhäs toqortäqyia, ‘Ngäni slaräkt na ama iska nanokt ma Engeska.’” ");
INSERT INTO uro_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Dä arhani ama Farisiqäna qärarhani i sa rha rhäk na rha ");
INSERT INTO uro_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","di rhi snanbät sä qa rhoqortäqyia, “Dap mäniekt bä ngi baptais pät ama ruvek toqoräkt i nge di qaku ma Krais na nge ura ma Elaija ura iaqäkt kärak ma Ngämuqa aa vämginaqa?” ");
INSERT INTO uro_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Dä ma Jon ga muvät pät a rha rhoqortäqyia, “Aingo di ngu baptais pät ama ruvek na ama rigi. Dap mänguräp mä ngän di akni qa e qärakni i qaku ngänät dräm a qa. ");
INSERT INTO uro_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Iaqäkt di qärak iva as dängdäng na qa nasot a ngo dä ama rhängämitnäm sa ama sandal nävät aa qäriglem angät tpäs di qaku ama märqa na ngo iva ngu rhäväkt sä itnäm.” ");
INSERT INTO uro_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Rhangät täkt moe ama lat di ngä märanas pa ama värhäm ama lel äm ma Betani rhage na ama rigi ma Jordan äkt i ma Jon gä baptais pät ama ruvek e. ");
INSERT INTO uro_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Näkt nga duququ vät akni ama qunäga dä ma Jon ga lu ma Jisas i qat tet inamuk dä qa qoar toqortäqyia, “As ngäni lu ma Ngämuqa aa sipsip ama rhoem ga qärakni i qät ta ama ruvek nävät ama ivätki arha vuirhong nae. ");
INSERT INTO uro_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Rhak täkt di iaqäkt kärak i mäqi nguat tamän sävät a qa rhoqortäqyia, ‘Ama ruqa qärakni iva as ka rhän nasot a ngo di ama moräs na qa vät ngua väs inguna mudu sa qa er qa män näkt sä ngo.’ ");
INSERT INTO uro_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Näkt ngo di sa qaku nguat dräm a qa dap ama rharimini i ngua män bä ngu baptais pät ama ruvek na ama rigi divakt iva qunäga vät ama Israelqäna sä qa.” ");
INSERT INTO uro_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Dä ma Jon gä sameng sävät a nas toqortäqyia, “Ngua lu ama Qloqaqa ama Qumärqumärqa i qa rhoqor ama simängaqa i ar sä qa na rhävuk nädä ama usäpki arha ron bä qa muqun bä qale qa vät a qa. ");
INSERT INTO uro_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Dap padi mai qaku ngu naräm a qa sokt di iaqäkt kärak i qa rhäk na ngo ivakt iva ngu baptais pät ama ruvek na ama rigi di sa qa qoar na ngo rhoqortäqyia, ‘Ama ruqa qärakni iva ngi lu ama Qloqaqa ama Qumärqumärqa i ar sä qa bä qale qa gem ga di iaqäkt kärak iva qä baptais pät ama ruvek na ama Qloqaqa ama Qumärqumärqa.’ ");
INSERT INTO uro_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Sa ngua lu rhoqoräkt bä äkt i ngu qoar i rhak täkt di ma Ngämuqa aa emga.” ");
INSERT INTO uro_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Duququ vät akni ama qunäga dä saqi as kale ma Jon i qat mair äkt kä na aiomni nävät aa mudäsaqongda. ");
INSERT INTO uro_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Bä nga rhoqoräkt i qa lu ma Jisas i qat tet e na rha dä qa qoar na iom doqortäqyia, “As ini lu ma Ngämuqa aa sipsip ama rhoem ga.” ");
INSERT INTO uro_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Bä rhoqoräkt i aa mudäsaqongiom in nari i qa märhamän doqoräkt dä in met nasot ma Jisas. ");
INSERT INTO uro_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Dä ma Jisas ka ñäm da aa rhäng dä qa lu iom nasot a nas dä qa snanbät sä iom doqortäqyia, “Nani a en na agiqa?” Dä in muvät pät a qa i ini snanbät toqortäqyia, “Rabai, qale nge qoe nai?” Ama rharimini sa ama rabai di qamorqa. ");
INSERT INTO uro_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Dä sa ma Jisas ka muvät pät a iom doqortäqyia, “Ini ang bä ini lu.” Dä soknga in met bä in lu äkt i qat tas e bä qali liom gem ga bä dängdäng i rhäksot nä iaqäkt ama qunäga inguna rhoqoräkt di sa säpbängang mamär. ");
INSERT INTO uro_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ma Andru ma Saimon Pita aa läktka di akni nävät iomäkt i in nari ma Jon aa sameng dä in met nasot ma Jisas. ");
INSERT INTO uro_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ama narhoeräm gärqomni i ma Andru qa mualat na äm di qa ñäm nani aa läktka ma Saimon bä qa qoar na qa rhoqortäqyia, “Sa ut män bät ma Mesaia.” Ama rharimini sä ma Mesaia di ma Krais. ");
INSERT INTO uro_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Bä nga nasot toqoräkt dä qa met sä qa sage ma Jisas. Dä sa ma Jisas ka ñäm sävät a qa dä qa qoar na qa rhoqortäqyia, “Ainge di ma Saimon, ma Jon aa emga. Rhäkt diva rhat tes nge i ma Sefas.” Ma Sefas di rhoqorne nä ma Pita i ama rharimini di ama duiqa. ");
INSERT INTO uro_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Duququ vät akni ama qunäga dä ma Jisas ka mu aa snäng iva qa rhet säva ama ngärhäktka ma Galili. Näkt nga rhoqoräkt dä qa män bät ma Filip dä qa qoar na qa rhoqortäqyia, “Ngit päs gua rhäng.” ");
INSERT INTO uro_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Näkt iaqäkt ma Filip di qa näva ama värhäm ama lel äm ma Betsaida rhoqor ma Andru qä nä ma Pita. ");
INSERT INTO uro_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ma Filip ka män bät ma Nataniel dä qa qoar na qa rhoqortäqyia, “Sa ut män bät iaqäkt kärak i mudu ma Moses ka säm sävät a qa vä ma Ngämuqa aa Muräkt bä qosaqi ma Ngämuqa aa vämginarha rha säm sävät a qa. Iaqäkt di ma Jisas näva ama värhäm ama gaini na äm ma Nasaret kärakni i ma Josep aa emga.” ");
INSERT INTO uro_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Bä nga ma Nataniel qa nari rhoqoräkt dä qa snanbät toqortäqyia, “Nga mamär iva guani anga mär ini ngä rhän na äkt ma Nasaret?” Dä ma Filip ka muvät pät a qa rhoqortäqyia, “Qoki as ngi ang bä ngi lu.” ");
INSERT INTO uro_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Bä nga rhoqoräkt i ma Jisas ka lu ma Nataniel i qat tet inamuk dä qat tamän sävät a qa i qä qoar toqortäqyia, “Iaqäkt di ama engäktki na qa ama Israelqa qärakni i qaku anga irasini gem ga.” ");
INSERT INTO uro_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Bä nga ma Nataniel qa nari rhoqoräkt dä qa snanbät sä ma Jisas toqortäqyia, “Mäniekt bä ngiat dräm a ngo?” Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Nak as toqoräkt i qaku ma Filip ka mes nge sagem ngo dä sa ngua lu nge rhoqoräkt i as ngiat muqun ba ama gosaqi arha rem.” ");
INSERT INTO uro_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nga ma Nataniel qa nari rhoqoräkt dä qa qoar na qa rhoqortäqyia, “Qamorqa, ainge di ma Ngämuqa aa emga bä ainge di ama Israelqäna arha vitnaqa.” ");
INSERT INTO uro_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Nga rhäkt di ngiat nanakt inguna ngua qoar na nge i sa ngua lu nge va ama gosaqi arha rem? Nak as pa ngi lu ama morirhong masirhat kärqärhongni i qaku rhoqorne nä rhäni rhäkt kärqäni i ini ngä märanas.” ");
INSERT INTO uro_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Dä qosaqi qa qoar toqortäqyia, “Nguat tamän särhäm ngän na ama engäktki iva as ngäni lu i rhi rhar mäni ama usäpki bä va ngäni lu ma Ngämuqa aa enselqäna i dängdang däm da rhävit dä arhar sä rha inavuk sage ma Ruqa aa Emga.” ");
INSERT INTO uro_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dä äkt pät ama dävaung na qa ama qunäga dä rha mualat na ama tmäski na ama rhitbodämnane mät ama värhäm ama lel äm ma Kana mät ama ngärhäktka ma Galili. Näkt toqoräkt di qale ma Jisas aa nanäk e. ");
INSERT INTO uro_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Bä ma Jisas kä na aa mudäsaqongda di qosaqi rha rhäkne nani a rha sävä iaqyäkt ama tmäski na ama rhitbodämnane. ");
INSERT INTO uro_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Näkt nga rhoqoräkt pa ama tmäski dä rhäksot na ama wain dä ma Jisas aa nanäk kia qoar na qa rhoqortäqyia, “Sa rhäksot na ama wain.” ");
INSERT INTO uro_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Di nak ma Jisas ka muvät pät a qi rhoqortäqyia, “Rhaktni, mäniekt bä ngiat tes pät a ngo sä rhäni rhäkt? As nguna gu qäväläm di as kaku äm ngä män.” ");
INSERT INTO uro_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Dä ma Jisas aa nanäk kia qoar nä iarhakt kärarhae i rhit lu vät ama lat pa ama tmäski rhoqortäqyia, “Ngän dualat na agini qärqäni i qä qoaräs na ngän iva ngän dualat nä ini.” ");
INSERT INTO uro_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Dap äkt glaqot di qale ama kain ama ngärhäqyet da sägäkt kärangätni i sa rha mualat na ngät na ama dui. Iangärhäkt ama kain di ama Judaqäna rhit tor nas nämät ngät parhäm arha morta arhä qärhong. Näkt asägäkt asägäkt nävät a ngät di mamär iva rhit täqäp ki na ama ruvek ama dävaung na rha da ama ngärhäqyisem bä sävät ama ruvek ama ngärhäqyet na rha da ama ngärhäqyisem na ama litaqäna na ama rigi. ");
INSERT INTO uro_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Dä ma Jisas ka qoar na ama latta rhoqortäqyia, “Ngäni rhäqäp ama kain na anga reng.” Dä rha rhäqäp ngät bä savono. ");
INSERT INTO uro_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Näkt ma Jisas ka qoar na rha rhoqortäqyia, “Rhäkt di ngäni ok na ama kap nämät agukt bä va ngäni von ama latka qärakni i qät lu vät ama tmäski.” Dä rha mualat toqoräkt parhäm ma Jisas aa enge ");
INSERT INTO uro_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","bä nga rhoqoräkt dä ama latka qärak i qät lu vät ama tmäski qa nakt närhä iaqyäkt ama rigi qäraktni i sa ma Jisas ka rhong na qi bä qia män i ama wain na qi dap toqoräkt di qaku qat dräm i iaqyäkt ama wain di sa qia män na qoe. Dap sokt iarhakt kärarhae ama latta i rha ok iaqyäkt ama rigi di rhat dräm. Bä rhoqoräkt i sa qa nakt närha ama wain dä qa mes iaqäkt kärak i rhit bodäm na qa särhage sagem mes ");
INSERT INTO uro_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","näkt ka qoar na qa rhoqortäqyia, “Ama ruvek moe di rhit bon da ama mär qi mamär ama wain narhoer dä äkt nasot dä sa ama wain gäraktni i qaku ama mär qi mamär toqoräkt i ama ruvek di sa rha nakt masirhat. Dap ainge di nak sa ngia mu ama mär qi mamär ama wain bä va dängdäng na qi.” ");
INSERT INTO uro_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Rhakt täkt di ama narhuir qi ama nañis ki ama muqunängi qäraktni i ma Jisas ka mualat na qi e ma Kana va ama ngärhäktka ma Galili. Näkt iangärhäkt aa lat ngä muqunäga sa aa murhämeska. Bä qärarhani aa mudäsaqongda di rhat nanakt na qa. ");
INSERT INTO uro_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bä nga nasot dä ma Jisas kä na aa nanäk dä aa läktpek näkt sävät aa mudäsaqongda rha met mämane bä sämät ama värhäm ama mor äm ma Kaperneam. Bä nga sa äkt dä qale rha e vät ama marheka na ngät ama qunäng. ");
INSERT INTO uro_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Bä nga rhoqoräkt i qorhäs mamär na ama qäväläm iva ama Judaqäna rha rhualat na ama tmäski iva rhat tuqunän bät ma Pasova dä ma Jisas ka met bä sae ma Jerusalem. ");
INSERT INTO uro_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Näkt toqoräkt i ma Jisas ka mon säva ama ansäspämgi ama mor qi arha ivärhäm dä qa lu arhani ama ruvek kärarhani i rhit boda ama bulmakaoqäna ngä na ama sipsipkäna näkt sävät ama ituap. Näkt kosaqi arhani di rhat muqun ge ama lai bä rhit kutsasorhane na ama ligär. ");
INSERT INTO uro_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Bä nga ma Jisas ka lu rhoqoräkt dä qa mualat na ama vugurqa na ama qoi bä qa qutmäs a rha moe rhi na arhä sipsipkäna ngä na ama bulmakaoqäna nae näva ama ansäspämgi ama mor qi. Näkt kosaqi qa vrit nä iarhakt kärarhae i rhit kutsasorhane na ama ligär arhä ligärigleng näkt ka näpgoer na arhä lai. ");
INSERT INTO uro_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Näkt ka qoar nä iarhakt kärarhae i rhit boda ama ituap toqortäqyia, “Ngäni rha iarhongäkt narhäkt bä sä dalek! Mäniekt bä ngänit dong nä gu mam aa vätki bä qia män i ama vätki qäraktni iva ama ruvek tit boda ama qärhong nani ama ligär väm gi.” ");
INSERT INTO uro_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Bä nga aa mudäsaqongda rha nari rhoqoräkt dä vuk pät a rha nä ma Ngämuqa aa enge qärangätni i mudu sa rha säm a ngät kärangät i ngät tamän doqortäqyia, “Gu snängaqa ama qrot ka sävät gia vätki bä äkt iva sokot na ngo.” ");
INSERT INTO uro_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Bä nga rhoqoräkt dä ama Judaqäna rha snanbät sä qa na ama qrot toqortäqyia, “Agi nañis ki ama muqunängi va ngi qur a ut täm gi iva qi sameng i sa ngia rha ama rhares nage ma Ngämuqa iva ngiat tualat nä rhärhong däkt moekt?” ");
INSERT INTO uro_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Ngänin brut dä rhakt täkt ama ansäspämgi ama mor qi näkt pa saqi ngua rhair na qi da ama qunäng ama dävaung angärha ron.” ");
INSERT INTO uro_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Näkt nga ama Judaqäna rha nari rhoqoräkt dä rha muvät pät a qa rhoqortäqyia, “Nak ta rhäk pät takt täkt ama ansäspämgi ama mor qi vät ama ruiom ama udiom näkt ama ngärhäqyet da sägäk ama qoeo. Dap nga ngäktki i ngiat tu gi snäng i mamär iva ngia rhair na qi da ama qunäng ama dävaung angärha ron?” ");
INSERT INTO uro_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sokt di iaqyäkt ama vätki qäraktni i qat tamän sävät a qi di nak kaku ama ansäspämgi ama mor qi dap aa släqyige. ");
INSERT INTO uro_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Bä nga nasot toqoräkt i ma Jisas ka märanas nämät ama tñäpki dä vuk pät aa mudäsaqongda nä iangärhäkt aa enge. Näkt na äkt dä rhat nanakt nä iangärhäkt ama enge qärangätni i sa mudu rha säm a ngät bä sävät ama enge qärangätni i ma Jisas ka märhamän bät a ngät. ");
INSERT INTO uro_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Bä nga rhoqoräkt i qale ma Jisas e ma Jerusalem ba ama tmäski ma Pasova dä ama rhäqäp na rha ama ruvek ta lu iangärhäkt ama nañis ngät ama muqunän gärangätni i ma Jisas kat tualat na ngät bä rhat nanakt na qa. ");
INSERT INTO uro_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sokt di ma Jisas kaku qat nanakt na rha inguna qat dräm ama ruvek moe arha iar mamär. ");
INSERT INTO uro_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Näkt kaku qät läk nani anga ruvek arhä sameng sävät ama ruvek arha lat inguna sa qat dräm ama ruvek mamär. ");
INSERT INTO uro_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Dä qale akni ama ruqa e qärakni i qa nävät ama Farisiqäna qärak i rhat tes ka i ma Nikodemus kärak i qa nävät ama Judaqäna arhä narhoerta ama vit na rha. ");
INSERT INTO uro_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Bä nga näp bängagi dä qa män ge ma Jisas bä qa qoar na qa rhoqortäqyia, “Qamorqa, sa ut dräm i nge di akni qärak i qä su ama ruvek kärak i qa män nage ma Ngämuqa. Ut dräm doqoräkt inguna qaku mamär vät aung anga ruqa iva qa rhualat na anga nañis ngät anga muqunän doqor nge i ngiat tualat na ngät kre i sa qaku ma Ngämuqa gem ga.” ");
INSERT INTO uro_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Dä ma Jisas ka muvät i qä qoar na qa rhoqortäqyia, “Nguat tamän särhäm nge na ama engäktki mamär i qaku mamär vät anga ruqa iva qä lu ma Ngämuqa aa Muräktpäm gre i saqi as kaku qa män i ama iaräs na qa rhoqor ama rhoemga qärakni i qa män näva ama ngätnanäk.” ");
INSERT INTO uro_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Bä nga ma Nikodemus ka nari rhoqoräkt dä qa snanbät sä ma Jisas toqortäqyia, “Nak nga mamär iva saqi as anga ruqa di anga ngätnanäk ki sa qa rhoqoräkt i sa mor qa? Ngäktki mamär i qaku mamär vät a qa iva qa rhon säda aa nanäk arha ron maunmen bä saqi as pa qi sa qa.” ");
INSERT INTO uro_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Nguat tamän särhäm nge na ama engäktki mamär i iaqäkt kärak i qaku qa män i ama iaräs na qa nävät ama rigi dä nävät ama Qloqaqa ama Qumärqumärqa di qaku mamär vät a qa iva qä namon sävä ma Ngämuqa aa Muräktpäm. ");
INSERT INTO uro_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ama släqyige di sa ige ngärhit sa ama släqyige dap ma Ngämuqa aa Qloqaqa di sa qät sa ama qloqaqa. ");
INSERT INTO uro_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Bä mamär iva qale ngit särmän sävät gua enge, ‘Mamär iva anga ruqa diva rhi sa qa iva ama iaräs na qa nage ma Ngämuqa.’ ");
INSERT INTO uro_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Inguna ama iarhakt ama ruvek moe qärarhae i sa rha män näva ama Qloqaqa ama Qumärqumärqa di rha rhoqor ama laurqi qäraktni i qi e varhäm at snängaqa maräkt bä ngiat nari vät at täqän sokt di qaku ngiat dräm i qiat dän na qoe ura qiat tet sa qoe. Di rhoqorne na ama ruvek kärarhani i ama Qloqaqa ama Qumärqumärqa qa sa rha.” ");
INSERT INTO uro_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Bä nga ma Nikodemus ka nari rhoqoräkt dä qa snanbät toqortäqyia, “Ngu lu va rhärhong däkt moe di mamär iva irhong ngä rhän doqor mäniekt?” ");
INSERT INTO uro_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Nak ainge di ngiat dräm ngi su ama Israelqäna näkt mäniekt bä qaku ngiat dräm därhong däkt? ");
INSERT INTO uro_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nguat tamän särhäm nge na ama engäktki mamär i ut tamän sävät iarhongäkt kärqärhong i sa ut dräm irhong bä qosaqi urhi sameng sävät kärqärhongni i sa ut lu irhong sokt di ngän ama ruvek di qaku ngänät nanakt na ut sameng. ");
INSERT INTO uro_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Sa ngua märhamän särhäm ngän sävät ama ivätki at kärhong näkt kaku ngänät nanakt dap sa ngu lu va ngänät nanakt toqor mäniekt kre i nguat tamän sävät ama usäpki at kärhong? ");
INSERT INTO uro_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Näkt kaku aung anga ruqa qärakni i sa qa met säda ama usäpki arha ron dap sokt ma Ruqa aa Emga ama sägäk kärakni i sa qa män näda ama usäpki arha ron. ");
INSERT INTO uro_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Rhoqorne nä ma Moses kärakni i qa sek sa ama uiuvärhaqa vät ama qräk dä bäs ama ivärhäs di qosaqi ma Ruqa aa Emga diva rhi sek sä qa rhoqoräkt ");
INSERT INTO uro_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ivakt iva iarhakt ama ruvek moe qärarhae i rhat nanakt na qa diva rha sa ama iar ama sok täm ngät. ");
INSERT INTO uro_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Inguna ma Ngämuqa sa aa snäng bät ama ruvek nävät ama ivätki bä äkt i sa qa von da aa emga qärakni i ama sägäk ivakt iva aung gärakni i qat nanakt na qa diva qaku qä nañäp dap pa qa sa ama iar ama sok täm ngät. ");
INSERT INTO uro_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Inguna ma Ngämuqa di sa qaku qa rhäk na aa emga sämäni ama ivätki ivakt iva qa rhatnävämne na ama ruvek dap ka rhäk na qa ivakt iva qa rhumaiar na rha. ");
INSERT INTO uro_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Näkt iaqäkt kärak i qat nanakt na qa di qaku qä narha ama rhäksärhäm nage ma Ngämuqa dap iaqäkt kärak i qaku qat nanakt di sa qa rha ama rhäksärhäm inguna sa qaku qat nanakt nä ma Ngämuqa aa emga ama sägäk. ");
INSERT INTO uro_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Bä rhom däkt di ama rharimini sa ama matnävämne i ama neraqa qa män sämäni ama ivätki sokt di ama ruvek di arhä snäng bät ama bängagi dap kaku rha ama neraqa inguna rhat tualat na ama vuirhong. ");
INSERT INTO uro_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Näkt iarhakt ama ruvek moe qärarhae i rhat tualat na ama vuirhong di qaku nani a rha na ama neraqa inguna rhit len i varis kunäga sa arha vuirhong. ");
INSERT INTO uro_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Sokt di iaqäkt kärak i qat tualat parhäm ama engäktki di sa qat dän sage ama neraqa ivakt iva ama ruvek moe di mamär iva rhi lu i iangärhäkt aa lat di ngät nage ma Ngämuqa.” ");
INSERT INTO uro_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bä nga nasot tärhong däkt dä ma Jisas kä na aa mudäsaqongda rha met bä sävät ama ngärhäktka ma Judia bä qale qa e qä na rha dap kä baptais pät ama ruvek. ");
INSERT INTO uro_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Näkt toqoräkt di qosaqi ma Jon di qä baptais pät ama ruvek pät ama ivärhäm ma Ainon glaqot na ama värhäm ama gaini na äm ma Salim inguna äkt di masirhat na ama reng e. Bä ama ruvek di rhat dän basägos ivakt iva qä baptais pät a rha. ");
INSERT INTO uro_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Rhoqoräkt di as kaku rha mu ma Jon ba ama tpäskiarharhäng. ");
INSERT INTO uro_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Näkt maos dä ama enge ngä märanas mänguräp ma Jon aa mudäsaqongda rhi na akni nävät ama Judaqäna sävät iomäkt i ama ruvek ti qumär nas parhäm arha morta arhä qärhong. ");
INSERT INTO uro_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dä rha män ge ma Jon bä rha qoar na qa rhoqortäqyia, “Qamorqa, iaqäkt ama ruqa qärak i sa qale qa qä na nge rhage na ama rigi ma Jordan bä qärak i ngi sameng sävät a qa di nak sa qä baptais pät ama ruvek bä ama ruvek moe di rhat tet sagem ga.” ");
INSERT INTO uro_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Dä ma Jon ga muvät toqortäqyia, “Ama ruqa di sokt mamär iva qä rha ianiäkt kärqäni i sa ma Ngämuqa qa von ga rhäm ini näda ama usäpki arha ron. ");
INSERT INTO uro_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Näkt aingän maräkt di mamär iva ngäni sameng i sa ngua qoar toqortäqyia, ‘Aingo di qaku ma Krais na ngo dap aingo di sa ma Ngämuqa qa rhäk na ngo narhoer nanokt ka.’ ");
INSERT INTO uro_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“Ma Krais di qa rhoqor ama gamoeqa qärakni iva rhit bodäm na qa bä qa va rhät ama evopki. Dap aingo di ngo rhoqor iaqäkt ama gamoeqa aa ruaqa qärak i qät lu vät a qa qärak i sa qale qa dap kat nari ma nas bä rhäqäp ka na ama märmärgem doqoräkt i qat nari iaqäkt ama gamoeqa aa eguinga. Iangärhäkt ama märmärgem di nga e gem ngo bä sa rhäqäp ngo na ngät mamär. ");
INSERT INTO uro_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Bä ma Jisas di mamär iva qa rhän i ama moräs na qa dap aingo di mamär iva ngua rhän i ama gaini na ngo.” ");
INSERT INTO uro_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Iaqäkt kärak iva qa rhän na rhävuk di qa enges tävuk daver ama ruvek moe dap iaqäkt kärak i qa narhe nävät ivät di qa nämäni ama ivätki dä qat tamän doqor ama ruqa nävät ivät. Näkt iaqäkt kärak iva qa rhän na rhävuk näda ama usäpki arha ron di sa qa enges tävuk mamär daver ama ruvek moe. ");
INSERT INTO uro_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Bä qa di qä sameng sävät iarhongäkt kärqärhong i sa qa lu irhong dä sävät iarhongäkt kärqärhong i sa qa nari irhong sokt di qaku aung gat nanakt na aa sameng. ");
INSERT INTO uro_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Bä aung anga ruqa qärakni i sa qat tat maengäkt sa aa sameng di sa qä sämaengäktki i ma Ngämuqa di qat tamän bät ama engäktki. ");
INSERT INTO uro_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Inguna iaqäkt kärak i ma Ngämuqa sa qa rhäk na qa di qat tamän bät ma Ngämuqa aa enge inguna ma Ngämuqa qät täqäp ka masirhat na ama Qloqaqa ama Qumärqumärqa. ");
INSERT INTO uro_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ama Ngätmamäk di aa snäng bät ama Ngärhoemga dä sa qa mu iarhongäkt moe va aa rhäkt. ");
INSERT INTO uro_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Näkt iaqäkt kärak i qat nanakt na ama Ngärhoemga di sa qa sa ama iar ama sok täm ngät. Dap iaqäkt kärak i qaku qat nanakt na ama Ngärhoemga diva qaku qä nalu ama iar inguna ma Ngämuqa aa uraqi ama mor qi di sa qali qi vät a qa. ");
INSERT INTO uro_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Rhoqoräkt di ma Jisas ka räm i ama Farisiqäna sa rha nari sävät ama ruvek masirhat i rhat dän sagem ga bä qä baptais pät a rha bä rhit päs aa rhäng dap ma Jon di qaku masirhat na anga ruvek tat dän sagem ga. ");
INSERT INTO uro_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Sokt di sa qaku ngäktki i ma Jisas kä baptais pät ama ruvek dap kärarhani aa mudäsaqongda rhi baptais pät a rha. ");
INSERT INTO uro_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Bä nga ma Jisas ka räm doqoräkt dä qa met nae ma Judia bä saqi as sae ma Galili. ");
INSERT INTO uro_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Näkt pa qoki qa rhet mät ama ngärhäktka ma Samaria. ");
INSERT INTO uro_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Bä nga nasot dä qa män e mät ama värhäm gärqomni i rhat tes äm i ma Sikar e ma Samaria glaqot na ama ivärhäm gärqomni i sa mudu ma Jekop ka von aa emga ma Josep tä bäm. ");
INSERT INTO uro_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Näkt äkt pät iomäkt ama ivärhäm di qale ma Jekop aa qotnaqoanga e. Bä ma Jisas di arusus pät aa släqyige inguna sa qa met näva ama iska ama uiu qa dä qa muqun bät iaqäkt ama qotnaqoanga aa rhäkt. Rhoqoräkt di sa mäniqunäng mamär. ");
INSERT INTO uro_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Näkt toqoräkt i qale qa äkt dä aktni ama ruqi nae ma Samaria qia män e ivakt iva qi ok anga rigi. Bä nga ma Jisas ka lu qi dä qa qoar na qi rhoqortäqyia, “Nga mamär iva ngi von ngo ngu nakt?” ");
INSERT INTO uro_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Rhoqoräkt di sa aa mudäsaqongda rha met sämät ama värhäm ma Sikar ivakt iva rhi vodäm bät anga tmäs. ");
INSERT INTO uro_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Dä iaqyäkt ama ruqi nae ma Samaria qia qoar na qa rhoqortäqyia, “Ainge di nge nävät ama Judaqäna dap aingo di ama ruqi nävät ama Samariaqäna. Mäniekt bä va ngi nän ngo va ngi nakt?” Qia qoar na qa rhoqoräkt dinguna ama Judaqäna di qaku sägäni na rha rhi na ama Samariaqäna. ");
INSERT INTO uro_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Bä nga ma Jisas ka nari rhoqoräkt dä qa muvät pät a qi rhoqortäqyia, “Ngakt bä vadi mai qunäga vät a nge sä ma Ngämuqa aa vänbon bä qosaqi iaqäkt kärak i qä nän nge iva qä nakt dä vadi mai ngi nän ga dä sa va qä von nge rha ama rigi na ama iar.” ");
INSERT INTO uro_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Dä qa ruqi qia qoar na qa rhoqortäqyia, “Qamorqa, nge di qaku gi nga guani iva ngi ok nä ini inguna ma uqupka di ama dur da aa ron. Dap ngu lu va ngi rha iaqyäkt ama rigi na ama iar na qoe? ");
INSERT INTO uro_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nak nga nge di ama moräs na nge masirhat tävuk daver aut mamäk ma Jekop kärakni i sa qa von ut tärhak täkt ama uqupka rhak täkt kärakni i qa qä na aa es dä aa sipsipkäna rhit nakt nämät ka?” ");
INSERT INTO uro_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Dä ma Jisas ka muvät pät a qi i qä qoar na qi rhoqortäqyia, “Iarhakt moe ama ruvek kärarhae i rhit näkt takt täkt ama rigi diva saqi as aqäsäk ta ");
INSERT INTO uro_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","dap aung gärakni i qät näkt ama rigi nagem ngo diva saqi as kaku aqäsä qa. Inguna ama rigi qäraktni iva ngu von ga rhäm gi diva qia rhän i ama rigi qäraktni i qiat dräm git don na nas tävit imuk da aa ron bä va qi von ga rha ama iar ama sok täm ngät.” ");
INSERT INTO uro_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Dä qia qoar na qa rhoqortäqyia, “Qamorqa, rhäkt di mamär iva ngi von ngo rhä iaqyäkt ama rigi iva saqi as kaku ngu natmet sarhäkt ivakt iva ngu naqäk anga rigi.” ");
INSERT INTO uro_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Dä ma Jisas ka qoar na qi rhoqortäqyia, “Ngia rhet bä ngia rhes gia egutka dä saqi evär däm nge.” ");
INSERT INTO uro_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Dä nak kia muvät pät a qa rhoqortäqyia, “Qaku gu nga egutka.” Nävät at muvätki dä ma Jisas ka qoar na qi rhoqortäqyia, “Qoki ngäktki na nge rhoqoräkt i ngi qoar i qaku gi nga egutka. ");
INSERT INTO uro_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ama engäktki di rhoqortäqyia, mäqi gia egutpek ama ngärhäqyet na rha näkt tak täkt kärak i sa qale qa gem nge rhäkt di qaku gia egutka na qa. Ngäktki nä gia enge rhoqoräkt.” ");
INSERT INTO uro_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Dä qärakt ka ruqi qia qoar toqortäqyia, “Qamorqa, rhäkt di sa ngua lu mamär i nge di nak akni na nge nävät ma Ngämuqa aa vämginarha. ");
INSERT INTO uro_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Aiut ut mamäkkäna di rhi nänsäs dä rhakt täkt ama damgi dap ngän ama Judaqäna di ngäni qoar i ama ivärhäm gärqomni iva ama ruvek moe rhi nänsäs e di ma Jerusalem.” ");
INSERT INTO uro_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Dä ma Jisas ka muvät maräkt pät a qi rhoqortäqyia, “Rhaktni, mamär iva ngiat nanakt na ngo inguna sa qorhäs na ut sävät ama qäväläm iva äm ngä rhän gärqomni iva qaku ngi nänsäs sage ama Ngätmamäk dä rhakt täkt ama damgi ura e ma Jerusalem. ");
INSERT INTO uro_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Sokt di ngän ama Samariaqäna di ngäni nänsäs sage ianiäkt kärqäni i qaku ngänät dräm ini dap aiut di urhi nänsäs sage qärqäni i ut dräm ini inguna ama mumaiar di ngät nävät ama Judaqäna. ");
INSERT INTO uro_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nak as pa ama qäväläm ngä rhän bä rhäkt di sa äm ngä män iva ama engäktki na rha ama ansäspämda diva rhi nänsäs sage ama Ngätmamäk nävät ama qloqaqa bä nävät ama engäktki inguna iarhakt ama ansäspämda rhoqoräkt di ama Ngätmamäk kät ñäm nani a rha. ");
INSERT INTO uro_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ma Ngämuqa di ama qloqaqa bä iarhakt kärarhae i aa ansäspämda na rha di mamär iva rhi nänsäs sagem ga nävät ama qloqaqa bä nävät ama engäktki.” ");
INSERT INTO uro_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Bä nga iaqyäkt ama ruqi qia nari rhoqoräkt dä qia qoar na qa rhoqortäqyia, “Nguat dräm i iaqäkt ma Mesaia qärak i rhat tes ka i ma Krais diva qa rhän. Näkt toqoräkt iva qa rhän dä va qä rhäväktsäs ba ut sävät iarhongäkt moekt.” ");
INSERT INTO uro_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Dä ma Jisas ka qoar na qi mamär toqortäqyia, “Aingo rhäkt kärak i nguat tamän särhäm nge di iaqäkt.” ");
INSERT INTO uro_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Vät iomäkt ama qäväläm dä evär dä ma Jisas aa mudäsaqongda bä rha män bät a qa i qat tamän särhäm ne qä na ama evopki dä qräk mät ta nävät a iom. Sokt di qaku aung nävät a rha qa snanbät sä qi rhoqortäqyia, “Ngu lu nani a nge na agiqa?” ura sä qa rhoqortäqyia, “Mäniekt bä ngiat tamän särhäm ne ngi na qi?” ");
INSERT INTO uro_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nasot toqoräkt dä iaqyäkt ama ruqi qia märanas daqule at kainaqi qäraktni i qiat dräm gi qäk ama reng sämät ki bä evär däm gi sävät arha värhäm bä qia qoar na ama ruvek toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“As ngäni ang ivakt iva ngäni lu akni ama ruqa qärakni i qa qoar na ngo sävät iarhongäkt moekt kärqärhong i sa mäqi ngua mualat nä irhong. Nguaräm ma Krais na qa.” ");
INSERT INTO uro_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bä nga rhoqoräkt dä vuk sä rha näva arha värhäm bä rha met iva sagem ga. ");
INSERT INTO uro_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Dap toqoräkt i sa iaqyäkt ama ruqi qia met dä ma Jisas aa mudäsaqongda rhit tägär sä qa i rhi qoar na qa rhoqortäqyia, “Qamorqa, rhäkt di ngia äs guani.” ");
INSERT INTO uro_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Sokt di ma Jisas ka muvät i qa qoar toqortäqyia, “Aingo di gua tmäs iva nguat täs ngät kärangätni i qaku ngänät dräm guani sävät a ngät.” ");
INSERT INTO uro_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Bä nga ma Jisas aa mudäsaqongda rha nari rhoqoräkt dä rha qoar na ne rhoqortäqyia, “Sa nguaräm aung ga ang sa anga tmäs bä ba qa.” ");
INSERT INTO uro_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Gua tmäs di iomäkt iva nguat tualat parhäm iaqäkt aa snängaqa qärak i sa qa rhäk na ngo bä va ngu sot nä iangärhäkt aa lat. ");
INSERT INTO uro_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Dä ngänät dräm ngäni qoar toqortäqyia. ‘As anga levaet anga eqoan sae dä sa va sräp ama tmäs iva rhit ta ngät.’ Ngu qoar na ngän i mamär iva ngäni ñäm sävät ama et na ama tmäs! Ama tmäs di sa sräp ngät mamär ivakt iva ama ruvek ti ta ngät. ");
INSERT INTO uro_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","“Bä sa rhäkt di iaqäkt kärak i qat dräm gät ta ama tmäs di sa qät ta aa rhitsek i iangärhäkt ama tmäs di nä iarhakt ama ruvek kärarhae i rhat nanakt bä rhit ta ama iar ama sok täm ngät. Qat tualat toqoräkt ivakt iva iaqäkt kärak i qät kutnanokt ama tmäs dä iaqäkt kärak i qät ta ama tmäs diva märmär gem iom moe. ");
INSERT INTO uro_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Inguna rhangät täkt di ngä sämaengäktki na ama enge qärangätni i ngät tamän doqortäqyia, ‘Akni ama ruqa qät kutnanokt ama tmäs dap pa akni qät ta ngät.’ ");
INSERT INTO uro_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ngua rhäk na ngän ivakt iva ngänit ta ama tmäs kärangätni i mäqi qaku ngän mualat nani a ngät. Sa arhani rha mualat toqoräkt dap täkt di ngän dualat ngän na rha i ngänit ta iangärhäkt ama tmäs kärangätni i sa sräp ngät.” ");
INSERT INTO uro_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Näkt toqoräkt dä ama rhäqäp na rha ama Samariaqäna di rhat nanakt na qa inguna nävät ka ruqi at sameng gärangät i qia qoar toqortäqyia, “Qa qoar na ngo sävät iarhongäkt moe qärqärhong i sa mäqi ngua mualat nä irhong.” ");
INSERT INTO uro_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Bä nga rhoqoräkt dä ama Samariaqäna rha met bä sagem ga dä rha qoar na qa iva qale qa qä na rha. Dä sa qale qa gem da vät ama qunängiom ama udiom. ");
INSERT INTO uro_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bä ama rhäqäp na rha ama ruvek di rhat nanakt inguna nävät aa enge. ");
INSERT INTO uro_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Dä sa rha qoar nä qa ruqi rhoqortäqyia, “Ut di ut nanakt dinguna qaku sokt nävät agini qärqäni i sa ngia qoar na ut nä ini sävät a qa dap ut nanakt inguna rhäkt di sa ut nari bä ba nas bä ut dräm i rhak täkt ama ruqa di qoki ngäktki i qa di ma Mumaiar bä ba ama ruvek nävät ama ivätki.” ");
INSERT INTO uro_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Näkt nasot ama qunängiom ama udiom dä ma Jisas ka märanas bä qa met sae ma Galili. ");
INSERT INTO uro_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Bä rhoqoräkt dä sa qa qoar mamär i akni nävät ma Ngämuqa aa vämginarha di qaku anga qutdrir sävät a qa mät aa värhäm maräkt. ");
INSERT INTO uro_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Näkt nga rhoqoräkt i qa män e ma Galili dä ama Galiliqäna rha ar sä qa sagem mes inguna sa rha lu iarhongäkt moekt kärqärhong i qa mualat nä irhong ba ama tmäski ma Pasova e ma Jerusalem inguna rhoqoräkt di sa qale rha e. ");
INSERT INTO uro_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Bä nga rhoqoräkt i qale qa e ma Galili dä saqi as ka met bä sae ma Kana äkt i sa mudu qa rhong na ama rigi bä qia män i ama wain. Näkt e ma Kaperneam di qale akni ama narhoerqa ama moräs na qa qärakni i aa emga di qat namas mät ama rämgi. ");
INSERT INTO uro_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Näkt nga rhoqoräkt i iaqäkt ama narhoerqa qa nari sävät ma Jisas i sa qa män e ma Galili nae ma Judia dä qa met bä sagem ga bä qa qoar na qa iva qä na qa ivakt iva qa rhumäräs pät aa emga inguna sa qorhäs iva qä ñäp. ");
INSERT INTO uro_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Bä nga rhoqoräkt dä ma Jisas ka qoar na qa rhoqortäqyia, “Aingän ama ruvek di qaku mamär iva ngänät nanakt kre i qaku ngän lu anga muqunän näkt ama lat kärangätni i ngät dän masärmän.” ");
INSERT INTO uro_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Dä qä narhoerqa qa muvät pät a qa rhoqortäqyia, “Morqa, mamär iva ngia rhet sae rhoqor täkt i varis ngua emga qä nañäp.” ");
INSERT INTO uro_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Bä nga rhoqoräkt dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Rhäkt di mamär iva evär däm nge. Sa ngia emga diva qat däqäm.” Dä sa qä narhoerqa qa märanas bä qa met inguna qa mat maengäkt sä ma Jisas aa enge. ");
INSERT INTO uro_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Näkt nga rhoqoräkt i as kat tet parhäm aa iska säva vät dä aa latta rha män bät a qa bä rha sameng ba qa sävät aa emga i qat däqäm. ");
INSERT INTO uro_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Bä nga qa nari rhoqoräkt dä qa snanbät sä rha närha ama qäväläm doqoräkt i märäs pät aa emga dä rha qoar na qa rhoqortäqyia, “Mäqirhe vät ama sägäni säpbängang dä rhäksot na ama qärnaqi nävät a qa.” ");
INSERT INTO uro_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Bä nga rhoqoräkt dä qunäga vät iaqäkt ama rhoemga aa mamäk i iomäkt ama qäväläm di ama qäväläm maräkt kärqomni i sa ma Jisas ka qoar na qa rhoqortäqyia, “Ngia emga diva qat däqäm.” Bä nävät tangät täkt dä qa qä na aa ruvek moe va aa vätka di rhat nanakt nä ma Jisas. ");
INSERT INTO uro_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Rhangät täkt di qosaqi ama nañis ngät ama muqunän ama unmem na ngät kärangätni i ma Jisas ka mualat na ngät toqoräkt i qa met nae ma Judia bä sae ma Galili. ");
INSERT INTO uro_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bä nasot iangärhäkt dä aktni ama Judaqäna arha tmäski qia män e ma Jerusalem dä ma Jisas ka met bä sae. ");
INSERT INTO uro_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Dap e ma Jerusalem di ama qärhopka qa e qärakni i na ama Judaqäna arha enge di rhat tes ka i ma Betesda. Näkt iaqäkt ama qärhopka di qa e glaqot na ama värhäm ama mor äm angärha surqa aa tmongi qäraktni i rhat tes ki i ama sipsipkäna angärha tmongi. Näkt namet iaqäkt ama qärhopka di ama ngärhäqyet na ap ama suqulap kärqapni i qaku rha adäm namet ap kärqap i ap ngät mair sa ama ungi. ");
INSERT INTO uro_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Näkt e di qale ama ruvek masirhat kärarhani i ama rämgi vät a rha rhi na ama säsurta rhi na ama vaktpärharha näkt sävät ama ngäñäpärharha. Rha moe rhat namas pä iaqyäkt ama ungi. ");
INSERT INTO uro_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Akni nävät iarhakt ama ruvek di sa ama rämgi qia rha qa vät ama ruqa ama rhäk täm ga da ama ngärhäqyisem da qäraet da dävaung na ngät ama qoeo. ");
INSERT INTO uro_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Bä nga rhoqoräkt i ma Jisas ka lu qa i qat namas äkt dä qa räm i sa qale qa mät iaqyäkt ama rämgi vät ama uiu ngät ama rhodäm dä sa qa snanbät sä qa rhoqortäqyia, “Nga nani a nge iva märäs pät a nge?” ");
INSERT INTO uro_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Dä ama rämgivärhaqa qa muvät pät ma Jisas toqortäqyia, “Qaku anga ruqa iva qa rhatnärhäm ngo säva ama qärhopka rhoqoräkt i ama rigi sarhäktsarhäkt pät a qi. Bä nga rhoqoräkt i ngu siqut iva ngua rhon sae di nak ngäda akni qa er vät na ngo i qa mon samäk.” ");
INSERT INTO uro_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Dä sa ma Jisas ka qoar na qa rhoqortäqyia, “Ngia rhair näkt ngi rha gi gasgaska bä ngiat tet.” ");
INSERT INTO uro_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Dä qoki äkt di iaqäkt ama ruqa di märäs pät a qa dä sa qa rha aa gasgaska bä qat tet. Näkt tak täkt ama qunäga di ama Sabat. ");
INSERT INTO uro_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Bä äkt i nga rhoqoräkt dä soknga ama Judaqäna rha qoar nä iaqäkt ama ruqa qärak i sa ma Jisas ka mumäräs pät a qa rhoqortäqyia, “Rhäkt di ama Sabat bä varhäm ama Muräkt diva qaku ngi nata gi rhatdingit.” ");
INSERT INTO uro_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Sokt di qa muvät pät a rha rhoqortäqyia, “Ama ruqa qärakni i qa mumäräs pät a ngo di sa qa qoar na ngo rhoqortäqyia, ‘Ngi rha gi rhatdingit bä ngiat tet.’” ");
INSERT INTO uro_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bä nga rha nari rhoqoräkt dä rha snanbät sä qa rhoqortäqyia, “Ngu lu agi a ruqa rhak täkt kärak i qa qoar na nge iva ngi rha gi rhatdingit bä ngiat tet?” ");
INSERT INTO uro_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Sokt di iaqäkt ama ruqa qärak i sa märäs pät a qa di qaku qat dräm i auge iaqäkt inguna ma Jisas di sa qäbäs na qa mänguräp ama guläñgi na ama ruvek nä iarhakt kärarhae i qale rha e. ");
INSERT INTO uro_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Näkt nga nasot tangät täkt dä ma Jisas ka män bät iaqäkt ama ruqa va ama ansäspämgi ama mor qi dä qa qoar na qa rhoqortäqyia, “As ngi lu i rhäkt di sa märäs pät a nge. Sa qale ngiat tualat na ama vuirhong i varis nga äkt dä va guani anga mor ini masirhat ini ngä namän bät a nge qärqäni i qaku rhoqorne nä qäraktni gia rämgi qäraktni i mäqi qia män bät a nge.” ");
INSERT INTO uro_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dä qa ruqa qa met bä qa qoar na ama Judaqäna arhä narhoerta sävät ma Jisas i qa mumäräs pät a qa. ");
INSERT INTO uro_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Bä nävät tom däkt dä iarhakt ama narhoerta rhi sangäm nä ma Jisas nävät aa lat inguna qat tualat pät ama Sabat. ");
INSERT INTO uro_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Sokt di ma Jisas ka qoar na rha rhoqortäqyia, “Gu mamäk di vasägos dä sa qat tualat nä qärangätni aa lat bä sarhäkt sävät tak täkt ama qunäga bä ngo di qosaqi nguat tualat.” ");
INSERT INTO uro_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Bä äkt i nävät tom däkt dä ama Judaqäna rhi siqut ma ama qrot iva rhi veng ga inguna qaku sokt nävät iomäkt i qaku qat tet parhäm ama Muräkt sävät ama Sabat dap nguna qosaqi qat tes ma Ngämuqa i qa maräkt aa mamäk bä qä qoaräs i qa qä nä ma Ngämuqa di iom doqorne. ");
INSERT INTO uro_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Dä sa ma Jisas ka muvät pät a rha nä rhakt täkt ama muvätki i qä qoar toqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i ma Ngämuqa aa emga di qaku mamär iva sokt ka qä namualat nä guani dap mamär iva sokt kat tualat nä ianiäkt kärqäni i qat lu aa mamäk i qat tualat nä ini. Inguna agini qärqäni i ama Ngätmamäk kat tualat nä ini di qosaqi ama Ngärhoemga diva qat tualat nä ini. ");
INSERT INTO uro_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ama Ngätmamäk di qär qur ama Ngärhoemga rhä iarhongäkt moe qärqärhong i qat tualat nä irhong inguna ama Ngätmamäk di aa snäng bät ama Ngärhoemga. Nak as pa qräk mät ngän mamär nävät ama mor ngät masirhat ama lat iva as ama Ngätmamäk kär qur ama Ngärhoemga rhäm ngät. ");
INSERT INTO uro_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Inguna ama Ngätmamäk di qat täranas na ama ñäpta näkt kät bon da rha ama iar dä qosaqi ama Ngärhoemga di qät bon da ama iar bä iarhakt kärarhae i nani a qa iva qä von da rhäm ngät. ");
INSERT INTO uro_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","“Näkt kosaqi ama Ngätmamäk di qaku qä namatnävämne na anga ruqa dap sa qa von da ama matnävämne moe ba ama Ngärhoemga ");
INSERT INTO uro_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ivakt iva ama ruvek moe diva rhit kutdrir sage ama Ngärhoemga rhoqoräkt i rhit kutdrir sage ama Ngätmamäk. Näkt nga auge qärak i qaku qät kutdrir sage ama Ngärhoemga di qaku qät kutdrir sage ama Ngätmamäk iaqäkt kärak i sa qa rhäk na qa. ");
INSERT INTO uro_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nguat tamän särhäm ngän na ama engäktki i nga aung gärakni i qat nari gua enge bä qosaqi qat nanakt nä iaqäkt kärak i sa qa rhäk na ngo di sa qa rha ama iar ama sok täm ngät dap pa qaku rhi namatnävämne na qa inguna sa qa met daqule ama tñäpki bä särhage säva ama iar. ");
INSERT INTO uro_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Näkt kosaqi nguat tamän särhäm ngän na ama engäktki i ama qäväläm nga e iva as äm ngä rhän bä sa rhäkt di äm ngä män iva ama ñäpta diva rhi nari ma Ngämuqa aa emga aa eguinga bä va iarhakt kärarhae i rha nari qa diva ama iar ta. ");
INSERT INTO uro_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bä äkt i sa ama Ngätmamäk ka von da ama iar säva ama Ngärhoemga qoki rhoqor qa i ama iar nga e väm ga. ");
INSERT INTO uro_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Näkt kosaqi qa von ga rha ama rhares iva qa rhatnävämne na ama ruvek inguna qa di ma Ruqa aa Emga. ");
INSERT INTO uro_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Bä va qale ngänit särmän sävät täni rhäkt inguna ama qäväläm nga e qärqomni iva äm ngä rhän iva iarhakt moekt kärarhae i rha e mät arha uqup kärangätni i mudu rha sasärhäm da mät ngät diva rhi nari aa eguinga ");
INSERT INTO uro_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","dä va vuk sä rha. Näkt iarhakt kärarhae i sa rha mualat na ama märirhong diva rha rhäranas bä va ama iar ta dap kärarhani i sa rha mualat na ama vuirhong diva rha rhäranas bä va rha rhatnävämne na rha. ");
INSERT INTO uro_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Qaku mamär vät a ngo iva sokt ngo ngu namualat nä guani dap nguat tatnävämne na ama ruvek di sokt parhäm iarhongäkt kärqärhong i sa ngua nari irhong. Bä äkt iva gu matnävämne diva ama räkt ngät inguna qaku nguat tualat sagem mes dap kinak nguat tualat sage iaqäkt kärak i qa rhäk na ngo.” ");
INSERT INTO uro_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Näkt kosaqi ma Jisas ka qoar na rha rhoqortäqyia, “Ngakt bä ngu sameng sävät a nas dä iangärhäkt gu sameng diva qaku ngä nalu i ama engäktki na ngät. ");
INSERT INTO uro_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Dap gu mamäk ka e näkt kä sameng sävät a ngo bä nguat dräm i aa sameng sävät a ngo di ama engäktki na ngät. ");
INSERT INTO uro_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Sa ngän däkne sävät ma Jon dä qa sameng ba ngän na ama engäktki sävät a ngo. ");
INSERT INTO uro_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Sokt di qaku ngut läk nani anga ruqa aa sameng sävät a ngo dap ngut puk pät a ngän nä rhärhong däkt ivakt iva ngäni rha ama mumaiar. ");
INSERT INTO uro_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Bä ma Jon di ama lirhäga qärakni i qat dang bä qät bon da ama neraqa näkt ngän di nani a ngän bät ama qäväläm ama qot äm iva märmär gem ngän dä iaqäkt aa neraqa. ");
INSERT INTO uro_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Dap aingo di ngo sa angätni ama sameng gärangätni i ama vit na ngät masirhat pä ma Jon aa sameng angät tpäs. Iangärhäkt ama sameng di ngät sävät ama lat kärangätni i sa ama Ngätmamäk ka von ngo rhäm ngät iva ngu sot na ngät. Dä iangärhäkt ama lat di rhangät täkt maräkt kärangät i nguat tualat na ngät bä ngät di ngärhi sameng i sa ama Ngätmamäk ka rhäk na ngo. ");
INSERT INTO uro_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Bä ama Ngätmamäk kärakni i qa rhäk na ngo di sa qa maräkt ka sameng sävät a ngo. Sokt di as mudu qaku ngän nari aa eguinga dä qaku ngän lu qa ");
INSERT INTO uro_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","bä qosaqi qaku qale aa enge väm ngän inguna qaku ngänät nanakt nä iaqäkt kärak i sa qa rhäk na qa. ");
INSERT INTO uro_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Ngänät dräm ngänit ñäm dä ma Ngämuqa aa enge angärha ron inguna ngän du angän snäng iva nävät a ngät dä va ngäni rha ama iar ama sok täm ngät dap iangärhäkt ma Ngämuqa aa enge di nak ngärhi sameng sävät a ngo ");
INSERT INTO uro_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","sokt di ngän der ngän namet sagem ngo ivakt iva ngäni rha ama iar.” ");
INSERT INTO uro_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Näkt kosaqi ma Jisas ka qoar na rha rhoqortäqyia, “Aingo di qaku ngut läk nani ama ruvek arha ansäs ");
INSERT INTO uro_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","dap ngän di nguat dräm angäna iar. Bä qosaqi nguat dräm i qaku angän snäng bät ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Bä ngo di sa ngua män nävät gu mam aa ngärhipki sokt di qaku ngän nar sä ngo. Dap kre va akni anga ruqa qa rhän bä sagem ngän nävät aa ngärhipki maräkt diva ngäni ar sä qa. ");
INSERT INTO uro_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ngu lu va ngänät nanakt toqor mäniekt kre i nani a ngän na angäna ansäs nagem ngän gane dap kaku angän anga qänäskänes iva ngäni rha iangärhäkt ama ansäs kärangät i ngät dän nage ma Ngämuqa ama sägäk? ");
INSERT INTO uro_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Sokt di qale ngän namu angän snäng iva ngu rhäksärhäm ngän da ama Ngätmamäk aa saqong. Dap iaqäkt kärak iva qä rhäksärhäm ngän di ma Moses inguna qa di sa ngänät nanakt na qa. ");
INSERT INTO uro_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ngakt bä sa ngänät nanakt nä ma Moses dä mamär iva ngänät nanakt na ngo inguna qa di sa qa säm sävät a ngo. ");
INSERT INTO uro_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Bä nga rhoqoräkt dä ngu lu va ngänät nanakt na agirhong gärqärhongni i nguat tamän bät irhong doqor mäniekt kre i qaku ngänät nanakt nä iarhongäkt kärqärhong i qa säm irhong?” ");
INSERT INTO uro_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Näkt nasot tangät täkt dä ma Jisas ka met bä särhage na ama namuqa ma Galili iaqäkt kärak i qosaqi rhat tes ka i ama namuqa ma Taiberias. ");
INSERT INTO uro_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Näkt nga rhoqoräkt di ama guläñgi ama mor qi na ama ruvek di rhit päs aa rhäng inguna sa rha lu i qa mualat na ama muqunän ama nañis ngät pät ama rämgivärharha. ");
INSERT INTO uro_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Dä dang dä ma Jisas kä na aa mudäsaqongda bä säda ama dabäm dä rha muqun. ");
INSERT INTO uro_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Näkt toqoräkt di sa qorhäs na ama Judaqäna arha tmäski ma Pasova. ");
INSERT INTO uro_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Bä nga rhoqoräkt i ma Jisas ka ñäm dävit bä qa lu ama mor qi ama guläñgi na ama ruvek i rhat tet iva sagem ga dä qa qoar nä ma Filip toqortäqyia, “Ngu lu va urhi vodäm bät anga bretkäna na qoe bä bä rhärha rhäkt ama ruvek iva rha äs ngät?” ");
INSERT INTO uro_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Bä ma Jisas ka snanbät sä qa rhoqoräkt di nak kop pakt iva qä siqut na qa inguna sa ma Jisas ka er qat dräm iva qa rhualat toqoräkt. ");
INSERT INTO uro_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Dä ma Filip ka muvät pät a qa rhoqortäqyia, “Ama tbodäm bät ama udiom ama handretiom na ama qunäng angät titsek di qaku mamär iva rhi navodäm na ngät bä mamär vät anga bretkäna bä bä rhärha rhäkt ama ruvek moekt iva qäqi rha äs ama gaini nävät a ngät.” ");
INSERT INTO uro_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Dä akni nävät aa mudäsaqongda qärakni i rhat tes ka i ma Andru qärak i ma Saimon Pita aa läktka qa qoar nä ma Jisas toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Akni ama rhoemga qa e qärakni i qät ta ama ngärhäqyet ama gaini na ngät ama bretkäna qärangätni i sa rha mualat na ngät nävät ama barli näkt sävät ama udiom ama rhinämiom sokt di rhangät täkt ama tmäs di ama gaini na ngät mamär i qaku mamär iva bä ba ama ruvek ama rhäqäp na rha rhoqor täkt.” ");
INSERT INTO uro_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Dä ma Jisas ka qoar na aa mudäsaqongda rhoqortäqyia, “Ngäni qoar na ama ruvek iva rha rhuqun.” Rhoqoräkt di vät iosäkt ama ivärhäs di masirhat na ama mran bä iarhakt ama ruvek ta muqun i ama rhodäm sa ama gamoe di qorhäs iva ama ngärhäqyet ama tausengäna. ");
INSERT INTO uro_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Dä sa ma Jisas ka rha iangärhäkt ama bretkäna bä qa mes ama mär näkt ka matmät na ngät bä qa ruvek kärarhae i rhat muqun näkt kosaqi qa mualat toqoräkt sa ama rhinämiom bä rha rha bä mamär vät a rha. ");
INSERT INTO uro_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Näkt sa rhoqoräkt i iarhakt moekt ta mäs bä mamär vät a rha dä qa qoar na aa mudäsaqongda rhoqortäqyia, “Ngän datma ama tmäsirhong gärqärhongni i sa rha mäs bä nävät irhong iva qale guani ngän narhar sä nas.” ");
INSERT INTO uro_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bä äkt i sa rha matma ama tmäsirhong nävät kärangät ka ngärhäqyet ama bretkäna na ama barli nasot kärarhani ama ruvek i sa rha mäs bä rha rhäqäp ama ngärhäqyisem da unbem ama urat na ngät. ");
INSERT INTO uro_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bä nasot toqoräkt i ama ruvek ta lu iaqyäkt ama muqunängi ama nañis ki qärakni i sa ma Jisas ka mualat na qi dä rhi nasäng iva rhat tamän doqortäqyia, “Bä ngäktki mamär i rhak täkt di iaqäkt kärak ma Ngämuqa aa vämginaqa iva qa rhän sämäni ama ivätki.” ");
INSERT INTO uro_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Näkt nga rhoqoräkt i ma Jisas ka räm iva rha rhän inguna nani a rha iva rha rhualat na ama ulaqi ivakt iva rha rhair na qa iva ama vitnaqa na qa dä saqi as sokt ka qa met na äkt bä säda ama damgi. ");
INSERT INTO uro_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Bä nga rhoqoräkt i säpbängang mamär dä ma Jisas aa mudäsaqongda rha met bä samana säva ama namuqa aa rhäkt ");
INSERT INTO uro_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","bä rha veng sämät ama mlauski bä rha nasäng iva rhat tet särhage na ama namuqa sämät ama värhäm ma Kaperneam. Bä nga rhoqoräkt di sa rät pä bäs dap ma Jisas di as kaku qa män sagem da. ");
INSERT INTO uro_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Näkt nga rhoqoräkt i sävät a rha i rhi ngang mät arhä mlauski dä ama laurqi ama qrot ki qia nasäng gi e bä ama vaeng ngä män. ");
INSERT INTO uro_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bä nga nasot ama ngärhäqyet ura ama ngärhäqyet da sägäk na ama kilomitaqäna i sa rha met pät a ngät dä nak as ta lu ma Jisas i namuk i qat tet pät ama qoeväs angärha rhäng iva sagem da. Bä nga rha lu qa rhoqoräkt dä rhit len masirhat. ");
INSERT INTO uro_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Nak kop aingo dap kale ngänit len.” ");
INSERT INTO uro_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bä nga rha nari rhoqoräkt dä nak as ta rhäknan däm ga sagem mes bä qoki vät iomäkt ama qäväläm dä arhä mlauski qia män dage äkt i mai iva rhat tet sae. ");
INSERT INTO uro_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Näkt nga duququ vät akni ama qunäga dä ama guläñgi na ama ruvek kärarhani i qale rha rhage na ama namuqa äkt i ma Jisas aa mudäsaqongda rha met nae di qunäga vät a rha i sokt ama sägäkt ama mlauski di qali qi e di sa qia met nae. Bä rhoqoräkt di sa qaku ma Jisas ka muqun mät ki qä na aa mudäsaqongda dap sokt ta rha met mät ki. ");
INSERT INTO uro_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Näkt nasot iangärhäkt dä angätni ama mlaus näva ama värhäm ama mor äm ma Taiberias ngä män bä ngä mair glaqot nä iosäkt ama ivärhäs kärqos i ama ruvek ta mäs ama bretkäna e nasot i sa ma Engeska qa mes ama mär sävät a ngät. ");
INSERT INTO uro_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bä nga rhoqoräkt i iaqyäkt ama guläñgi na ama ruvek ta lu i qaku ma Jisas bä qosaqi qaku qärarhani aa mudäsaqongda äkt dä sa rha muqun mät iangärhäkt ama mlaus bä rha met sae ma Kaperneam ivakt iva rhi ñäm nani ma Jisas. ");
INSERT INTO uro_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bä nga rhoqoräkt i sa rha män bät a qa rhage vät ama namuqa aa rhäkt dä rha snanbät sä qa rhoqortäqyia, “Qamorqa, qäsnia ngia män sarhäkt?” ");
INSERT INTO uro_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Dä ma Jisas ka muvät i qä qoar toqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i ngänit ñäm nani a ngo di qaku nävät ama muqunän ama nañis ngät kärangätni i sa ngän lu ngät dap nguna nävät iomäkt i ngän mäs ama bretkäna bä angän sarem. ");
INSERT INTO uro_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bä mamär iva qale ngän natmualat nani ama tmäs kärangätni i mavamava na ngät dap mamär iva ngän dualat nani ama tmäs kärangätni i ngät säva ama iar ama sok täm ngät iangärhäkt kärangät i ma Ruqa aa Emga va qä von ngän däm ngät. Inguna qa di sa ma Ngämuqa qa von ga rha ama rhares iva qat tualat nä iarhongäkt.” ");
INSERT INTO uro_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Bä nga rhoqoräkt dä rha snanbät sä qa rhoqortäqyia, “Ngu lu va u rhualat toqor mäniekt ivakt iva ut tualat na ama lat kärangätni i sa ma Ngämuqa nani a qa na ngät?” ");
INSERT INTO uro_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Dä ma Jisas ka muvät i qä qoar na rha rhoqortäqyia, “Iangärhäkt ma Ngämuqa aa lat kärangät i nani a qa na ngät di rhoqortäqyia, va ngänät nanakt nä iaqäkt kärak i sa qa rhäk na qa.” ");
INSERT INTO uro_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bä äkt i rha snanbät sä qa rhoqortäqyia, “Ngu lu va agi anga muqunängi anga nañis ki qäraktni iva ngia rhualat na qi ivakt iva urhi lu qi dä va ut nanakt na nge? Ngu lu va ngia rhualat toqor mäniekt? ");
INSERT INTO uro_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Aut mamäkkäna di sa mudu rha mäs ama tmäs kärangätni i rhat tes ngät i ama mana vät ama ivärhäs ama qräk dä bäs di varhäm ama enge qärangätni i sa rha säm a ngät toqortäqyia, ‘Qa von da rha ama bretkäna qärangätni i ngät näda ama usäpki arha ron iva rhat täs ngät.’” ");
INSERT INTO uro_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i qaku ma Moses iaqäkt kärak i qa von da rhä iangärhäkt ama bretkäna qärangätni i ngät näda ama usäpki arha ron dap ngät di nage gu mam gärak i qät bon ngän da ama engäktki na ngät ama bret kärangätni i ngät näda ama usäpki arha ron. ");
INSERT INTO uro_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Inguna ma Ngämuqa aa bret di iaqäkt kärak i qat dän näda ama usäpki arha ron bä sarhe bä qät bon da ama iar bä ba ama ruvek nävät ama ivätki.” ");
INSERT INTO uro_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Dä soknga rha qoar na qa rhoqortäqyia, “Morqa, mänasäng narhäkt bä rhävit dä ngit bon ut tä iaqäkt ama bret.” ");
INSERT INTO uro_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Aingo di ama bret na ama iar. Näkt aung gärakni i qa rhän sagem ngo diva qaku mamär iva saqi as anoeng mä qa bä qosaqi iaqäkt kärak i qat nanakt na ngo diva qaku mamär iva saqi as aqäsä qa. ");
INSERT INTO uro_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Sokt di sa ngua qoar na ngän i sa ngän lu ngo sokt di sa qaku ngänät nanakt. ");
INSERT INTO uro_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Iarhakt kärarhae moe ama ruvek i ama Ngätmamäk kät bon ngo rhäm da diva rha rhän sagem ngo bä iarhakt kärarhae iva rha rhän sagem ngo diva qaku ngu naqutmäs a rha. ");
INSERT INTO uro_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“Inguna sa ngua män na rhävuk näda ama usäpki arha ron bä sarhe di qaku va nguat tualat parhäm aingo gu snängaqa maräkt dap pa nguat tualat parhäm iaqäkt kärak i sa qa rhäk na ngo aa snängaqa. ");
INSERT INTO uro_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Näkt iaqäkt kärak i qa rhäk na ngo di varhäm aa snängaqa di qaku nani a qa iva ngu namusäng sa aung nävät iarhakt moe qärarhae i sa qa von ngo rhäm da dap pa ngua rhäranas na rha vät ama dängdängini na qa ama qunäga. ");
INSERT INTO uro_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Inguna varhäm gu mam aa snängaqa di iarhakt kärarhae i sa rha lu mamär na ama Ngärhoemga bä rhat nanakt na qa diva rha sa ama iar ama sok täm ngät bä va ngua rhäranas na rha vät ama dängdängini na qa ama qunäga.” ");
INSERT INTO uro_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Dä ama Judaqäna rha nasäng i rhat tamängus nävät aa enge inguna qa qoar toqortäqyia, “Aingo di iaqäkt ama bret kärak i sa qa män na rhävuk näda ama usäpki arha ron bä sarhe.” ");
INSERT INTO uro_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Dä sa rhi qoaräs na ne rhoqortäqyia, “Nga qaku rhak täkt di nak kop ma Jisas ma Josep aa emga qärak i ut dräm aa mamäqiom? Ngu lu mäniekt bä mamär iva qä qoar toqortäqyia, ‘Sa ngua män näda ama usäpki arha ron bä sarhe?’” ");
INSERT INTO uro_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Dä ma Jisas ka muvät i qä qoar na rha rhoqortäqyia, “Qale ngän damängus. ");
INSERT INTO uro_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Inguna qaku mamär vät anga ruqa iva qa rhän sagem ngo bä va ngua rhäranas na qa vät ama dängdängini na qa ama qunäga qre i qaku ama Ngätmamäk kärakni i sa qa rhäk na ngo qä rha qa sagem ngo. ");
INSERT INTO uro_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Bä varhäm ama enge qärangätni i sa mudu ma Ngämuqa aa vämginarha rha säm a ngät kärangät i ngät tamän doqortäqyia, ‘Iarhakt moe diva ma Ngämuqa qä su rha.’ Ama ruvek moe qärarhani i rhat nari nämät ma Ngämuqa bä rhat tet parhäm aa enge diva rha rhän sagem ngo. ");
INSERT INTO uro_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Qaku aung anga ruqa di sa qa lu ama Ngätmamäk dap sokt iaqäkt kärak i qa nage ma Ngämuqa di sa sokt ka qa lu qa. ");
INSERT INTO uro_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Dä sa nguat tamän särhäm ngän na ama engäktki i iaqäkt kärak i qat nanakt na ngo diva qä rha ama iar ama sok täm ngät. ");
INSERT INTO uro_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Nak aingo di ama bret na ama iar. ");
INSERT INTO uro_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bä mudu angän mamäkkäna di rhat täs ama mana vät ama qräk dä bäs ama ivärhäs sokt di rha ñäp. ");
INSERT INTO uro_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Dap tak täkt ama bret kärak i nguat tamän sävät a qa qärak i qat dän näda ama usäpki arha ron bä sarhe di mamär iva aung anga ruqa qa äs nävät a qa dä va qaku qä nañäp. ");
INSERT INTO uro_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aingo di iaqäkt ama bret ama ngätdäqäm ga qärak i qa män näda ama usäpki arha ron bä sarhe. Näkt iaqäkt kärak i qat täs nävät iaqäkt ama bret diva qat däqäm basägos. Inguna rhak täkt ama bret kärak iva ngu vodäm ga nani ama ruvek nämäni rhakt täkt ama ivätki arha iar di gu släqyige na qa.” ");
INSERT INTO uro_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bä nga ama Judaqäna rha nari rhoqoräkt dä rhi nasäng i rhit beng bät a ne nävät ma Jisas aa enge i rhi qoar na ne rhoqortäqyia, “Ngu lu mäniekt iva rhak täkt ama ruqa di mamär iva qä von ut ta aa släqyige iva u äs ige?” ");
INSERT INTO uro_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Dä soknga ma Jisas ka qoar na rha rhoqortäqyia, “Sa nguat tamän särhäm ngän na ama engäktki i ngakt bä qaku ngän namäs nävät ma Ruqa aa Emga aa släqyige bä qosaqi qaku ngän nanakt nävät aa biaska dä va qaku ngän narha iangärhäkt ama iar. ");
INSERT INTO uro_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Dap iaqäkt kärak i qat täs nävät gu släqyige dä qät nakt nävät gu biaska diva qat sangar ama iar ama sok täm ngät bä va ngua rhäranas na qa vät ama dängdängini na qa ama qunäga. ");
INSERT INTO uro_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Inguna gu släqyige di ama engäktki na ngät ama tmäs bä qosaqi gu biaska di ama engäktki na qi ama rigi. ");
INSERT INTO uro_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Bä äkt i iaqäkt kärak i qat täs nävät gu släqyige dä qät nakt nävät gu biaska di iaqäkt di sa qale qa mäni ngo bä ngo di sa qale ngo mäni qa. ");
INSERT INTO uro_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Ama Ngätmamäk ama ngätdäqäm ga di sa qa rhäk na ngo bä nguat däqäm inguna nävät a qa di rhoqorne i iaqäkt kärak i qat täs nävät a ngo diva qat däqäm inguna nävät a ngo. ");
INSERT INTO uro_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bä rhak täkt ama bret di iaqäkt kärak i qa män näda ama usäpki arha ron bä sarhe. Rhak täkt ama bret di qaku qa rhoqorne nä iangärhäkt ama bretkäna qärangät i angän mamäkkäna rha mäs ngät dä sa rha ñäp. Iaqäkt kärak i qat täs nävät tak täkt ama bret diva qat däqäm mas.” ");
INSERT INTO uro_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Rhangät täkt ama enge di ma Jisas ka märhamän bät a ngät toqoräkt i qä su ama ruvek pa ama mämairqi e ma Kaperneam. ");
INSERT INTO uro_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bä nga rhoqoräkt i ama ruvek kärarhani i rhat tet nasot ma Jisas ta nari iangärhäkt aa enge dä ama rhäqäp na rha nävät a rha rha qoar toqortäqyia, “Nak tangät täkt di ama qrot ngät ama rhisu. Ngu lu mamär vät auge iva qä rha ngät?” ");
INSERT INTO uro_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Sokt di ma Jisas di sa qat dräm i sa rhat tamängus pät iangärhäkt aa enge bä äkt i qa qoar toqortäqyia, “Nga rhangät täkt ama enge ngärhi slava na ngän? ");
INSERT INTO uro_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Bä nga rhoqoräkt dä ngu lu vä ngän du angän snäng mäniekt kre i ngäni lu ma Ruqa aa Emga i dängdang däm ga rhävit sa äkt i mäqi qale qa e? ");
INSERT INTO uro_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ama Qloqaqa ama Qumärqumärqa di qät boda ama iar dap ama släqyige di qaku ige ngärhit boda guani. Bä iangärhäkt ama enge qärangät i sa ngua märhamän särhäm ngän na ngät di ama qloqaqa na ngät bä ngät di ama ngätdäqäm ngät. ");
INSERT INTO uro_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Sokt di as arhani rha e nävät a ngän gärarhani i qaku rhat nanakt.” Ma Jisas ka märhamän doqoräkt dinguna sa qat dräm mäk pät ama rharimini i qa nasäng na aa lat nä iarhakt kärarhae iva qaku rhat nanakt bä qosaqi auge iaqäkt kärak iva qä vodä ma Jisas säva aa ikkäna arhä rhäkt. ");
INSERT INTO uro_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Näkt kosaqi ma Jisas kä qoar na rha rhoqortäqyia, “Bä nga rhoqoräkt dä sa ngua qoar na ngän i qaku mamär iva anga ruqa qä namet sagem ngo qre i sa qaku ama Ngätmamäk ka von ga rha ama rhares.” ");
INSERT INTO uro_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Bä nga iarhakt ama ruvek kärarhae i rhat tet nasot a qa rha nari rhoqoräkt dä ama rhäqäp na rha nävät a rha evär däm da bä saqi as kaku rhat tet nasot a qa. ");
INSERT INTO uro_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Dä soknga ma Jisas ka snanbät sä qärarhani ama ngärhäqyisem da udiom na rha aa mudäsaqongda rhoqortäqyia, “Nga nani a ngän iva qosaqi ngän det daqule ngo rhoqor iarhakt?” ");
INSERT INTO uro_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Dä ma Saimon Pita qa muvät pät a qa rhoqortäqyia, “Urha Engeska, ngu lu va auge qärak iva u rhet sagem ga? Inguna nge di ama enge na ama iar ama sok täm ngät nga e gem nge. ");
INSERT INTO uro_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Bä qosaqi ut nanakt bä ut dräm i nge di ma Ngämuqa aa Qumärqumärqa mamär.” ");
INSERT INTO uro_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Dä sa ma Jisas ka muvät toqortäqyia, “Nak ngän ama ngärhäqyisem da udiom na ngän di sa ngua armeng däm ngän. Sokt di akni nävät a ngän di ama iauska qa e mät ka.” ");
INSERT INTO uro_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ma Jisas ka märhamän doqoräkt di sävät ma Judas ma Saimon Iskariot aa emga iaqäkt kärak i qa nävät ama ngärhäqyisem da udiom na rha aa mudäsaqongda qärak iva nasot dä va qä von däm ga säva aa ikkäna arhä rhäkt. ");
INSERT INTO uro_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Näkt nga nasot tangät täkt dä ma Jisas kat tet tage rhage bä qä su ama ruvek muk pät ama ngärhäktka ma Galili. Ama rharimini rhoqoräkt di sa qale qa sañis na ama ngärhäktka ma Judia inguna ama Judaqäna nae di sa qale rha nani a qa iva rhi veng ga. ");
INSERT INTO uro_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Sokt di rhoqoräkt i qorhäs na ama qäväläm gärqomni iva ama Judaqäna rhat tuqunän na ama tmäski va ama mämairväm ama me ngät ");
INSERT INTO uro_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","dä sa ma Jisas aa läktpek ta qoar na qa rhoqortäqyia, “Qoki va ngia rhet narhäkt bä sae ma Judia iväkt iva iarhakt ama ruvek kärarhae i rhat tet nasot a nge diva rhi lu qärangätni ama lat i ngiat tualat na ngät. ");
INSERT INTO uro_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Inguna qaku anga ruqa qärakni i nani a qa iva ama ruvek tat dräm aa lat di qat dräm gä ngaip sä iangärhäkt aa lat. Dap nguna ngiat dräm ngiat tualat nä rhärhong däkt dä mamär iva sa ngi qur a nas bä ba ama ruvek moe.” ");
INSERT INTO uro_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ama rharimini i aa läktpek ta märhamän särhäm ga rhoqoräkt dinguna qäqi rha di qaku rhat nanakt na qa. ");
INSERT INTO uro_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Bä nga rhoqoräkt dä ma Jisas ka qoar na rha rhoqortäqyia, “Gu qäväläm di as kaku rhäkmamär na äm dap aingän di ama qävälap moe di märmärsäs gem ngän sa ap. ");
INSERT INTO uro_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ama ruvek nävät ama ivätki di qaku mamär iva ama vu da arha ron na ngän dap ama vu da arha ron na ngo dinguna ngu sameng sävät a rha i rhat tualat na ama vuirhong. ");
INSERT INTO uro_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Rhäkt diva ngän det sae ma Jerusalem säva iaqyäkt ama tmäski. Dap ngo di as kaku ngu namet sae inguna gu qäväläm di as kaku rhäkmamär na äm.” ");
INSERT INTO uro_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Bä nga nasot tangät täkt aa enge dä qale qa e ma Galili. ");
INSERT INTO uro_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Näkt nasot toqoräkt i sa aa läktpek ta met säva ama tmäski dä nak as ka met nasot a rha sae. Sokt di qaku qat tet da ama ruvek arhä saqong dap kä ngaip nas. ");
INSERT INTO uro_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bä nga rhoqoräkt iva ama tmäski dä ama Judaqäna arhä narhoerta rhit ñäm nani a qa dap ti snanbät toqortäqyia, “Ngu lu iaqäkt ama ruqa qa qoe nai?” ");
INSERT INTO uro_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Dap toqoräkt pa ama tmäski mänguräp ama gulañ na ama ruvek di vräs da ama enge bä rhit täkdasäkt na ne sä ma Jisas i arhani rhi qoar toqortäqyia, “Qa di ama mär qa ama ruqa.” Dap arhani rhi qoar toqortäqyia, “Qaku, nak kat dräm ga iras ta ama ruvek.” ");
INSERT INTO uro_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Sokt di qaku aung nävät a rha qa märhamän masirhat toqoräkt mänguräp ama ruvek moekt inguna rhit len iarhakt ama Judaqäna. ");
INSERT INTO uro_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Näkt nga rhoqoräkt i sa mäni iaqyäkt ama tmäski mamär dä nak as ma Jisas ka met bä säva ama ansäspämgi ama mor qi bä qä nasäng i qä su ama ruvek. ");
INSERT INTO uro_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Bä ama Judaqäna di qräk mät ta nävät aa rhisu dä rhi snanbät toqortäqyia, “Ngu lu rhak täkt ama ruqa qärakni i qaku qa rha ama rhisu ama mor ngät di sa mäniekt bä aa mädräm ama mor ngät?” ");
INSERT INTO uro_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Dä ma Jisas ka muvät i qä qoar na rha rhoqortäqyia, “Rhangät täkt gu rhisu di qoki qaku ngät nagem ngo. Dap ngät dän nage iaqäkt kärak i sa qa rhäk na ngo. ");
INSERT INTO uro_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ngakt bä nga aung gärakni i nani a qa iva qa rhualat parhäm ma Ngämuqa aa snängaqa di mamär vät iaqäkt iva qä lu mamär i nga rhangät täkt gu rhisu di ngät dän nage ma Ngämuqa ura qoki ngät nagem ngo. ");
INSERT INTO uro_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Inguna iaqäkt kärak i qat tamän nävät aa qrot maräkt di qat tualat toqoräkt ivakt iva ama ruvek tit kutdrir sagem ga. Dap iaqäkt kärak i qat tualat nani ama qutdrir iva sage iaqäkt kärak i qa rhäk na qa di sa qat tamän na ama engäktki bä qaku anga irasini sävät a qa. ");
INSERT INTO uro_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Sa ma Moses ka von ngän dä ma Ngämuqa aa Muräkt sokt di qaku aung nävät angän di qat tet parhäm ngät. Ngu lu mäniekt bä ngäni siqut iva ngäni veng ngo?” ");
INSERT INTO uro_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bä nga rhoqoräkt dä ama guläñgi na ama ruvek ta muvät pät a qa rhoqortäqyia, “Ainge di ama iauska qa e mät nge. Ngu lu auge qä siqut iva qä veng nge?” ");
INSERT INTO uro_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Dä ma Jisas ka muvät i qä qoar na rha rhoqortäqyia, “Sa ngua mualat na ama sägängät ama lat ama nañis ngät dä ngän moe di qräk mät ngän nävät a ngät. ");
INSERT INTO uro_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Näkt nguna nävät ma Ngämuqa aa Muräkt nage ma Moses i qa qoar na ngän iva ngäni nädäkt angän släqyigleng bä äkt i rhoqor täkt iva vät ama Sabat dä ngänät dräm ngäni nädäkt ama rhoemga aa släqyige. Sokt di nak iangärhäkt ama Muräkt di qaku ngät nage ma Moses dap ngät nage angän mamäkkäna. ");
INSERT INTO uro_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ngakt bä nga rhoqoräkt i vät ama Sabat di qoki mamär iva rhi däkt ama rhoemga aa släqyige varhäm ma Ngämuqa aa Muräkt nage ma Moses dä ngu lu mäniekt bä ngänir qur ngo inguna sa ngua mumäräs pät ama ruqa aa släqyige moe vät ama Sabat? ");
INSERT INTO uro_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Qale ngän datnävämne varhäm ianiäkt kärqäni i ama räkt ini gem ngän dap kinak mamär iva ngän datnävämne na ama räkt ngät ama matnävämne.” ");
INSERT INTO uro_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Rhoqoräkt di arhani ama ruvek nae ma Jerusalem di rhi nasäng i rhi snanbät toqortäqyia, “Nga rhak täkt di ama ruqa qärak i rhi siqut iva rhi veng ga? ");
INSERT INTO uro_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Sokt di ngäni lu qa i nak kop ama qraräqa na qa i qat tamän mänguräp ama ruvek dap ama narhoerta di qaku rhat tamän bät anga enge sävät a qa. Nga sa ama narhoerta rhat nanakt i qa di ma Krais? ");
INSERT INTO uro_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Sokt di ut dräm äkt i rhak täkt ama ruqa qa män nae dap toqoräkt iva ma Krais ka rhän dä qaku aung gä naräm i qa män na äkt.” ");
INSERT INTO uro_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Dä ma Jisas ka märhamän masirhat toqoräkt i qoki as kä su ama ruvek pa ama ansäspämgi ama mor qi i qä qoar toqortäqyia, “Qoki ngäktki rhoqoräkt i ngänät dräm a ngo bä qosaqi ngänät dräm äkt i ngo nae. Sokt di qaku ngua män sarhe varhäm gu snängaqa dap iaqäkt kärak i sa qa rhäk na ngo di ama engäktki na qa. Näkt ngän di qaku ngänät dräm a qa ");
INSERT INTO uro_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","dap ngo di nguat dräm a qa inguna ngo di ngo nagem ga bä qa di sa qa rhäk na ngo.” ");
INSERT INTO uro_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Bä nga ama ruvek ta nari rhoqoräkt dä nani a rha iva rhi sangar a qa sokt di qaku aung nävät a rha qa rhäk pät a qa inguna aa qäväläm di sa as kaku rhäkmamär na äm. ");
INSERT INTO uro_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sokt di ama rhäqäp na rha nävät iaqyäkt ama guläñgi na ama ruvek di qoki as ta nanakt na qa. Bä nga rhoqoräkt dä rhi qoar toqortäqyia, “Qre va ma Krais ka rhän dä nga va qa rhualat na anga rhäqäp anga muqunän anga nañis ngät kärangätni i ngä vit masirhat pät tak täkt ama ruqa aa lat toqoräkt angät tpäs?” ");
INSERT INTO uro_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bä nga rhoqoräkt i ama Farisiqäna rha nari iaqyäkt ama guläñgi na ama ruvek i rhat tamän särhäm ne nä iarhongäkt ama engirhong sävät a qa dä ama priskäna ama moräs na rha rhi na ama Farisiqäna rha rhäk na ama ruvek kärarhani i rhit lu vät ama ansäspämgi ama mor qi ivakt iva rhi sangar a qa. ");
INSERT INTO uro_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Aingo diva qale ngo ngu na ngän bät ama qot äm ama qäväläm nak kop näkt saqi ngua rhet sage iaqäkt kärak i qa rhäk na ngo sarhe. ");
INSERT INTO uro_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Näkt toqoräkt iva ngua rhet dä va ngänit ñäm nani a ngo sokt diva qaku ngän namän bät a ngo bä qosaqi äkt iva qale ngo e di qaku mamär vät a ngän iva ngän namet sae.” ");
INSERT INTO uro_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Dä rha qoar na ne rhoqortäqyia, “Ngu lu rhak täkt ama ruqa di qat tu aa snäng iva qa rhet sa qoe nai ivakt iva qaku ut namän bät a qa? Nga va qa rhet sa gläius sa äkt i qale ut kärhae mänguräp ama Jentailqäna bä va qä su rha? ");
INSERT INTO uro_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ngakt bä nga rhoqoräkt dä ngu lu ama rharimini mäniekt bä qa qoar toqortäqyia, ‘Va ngänit ñäm nani a ngo sokt diva qaku ngän namän bät a ngo’ bä qosaqi qa qoar toqortäqyia, ‘Äkt i qale ngo e di qaku mamär vät a ngän iva ngän namet sae’?” ");
INSERT INTO uro_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Näkt nga rhoqoräkt pät ama dängdängini na qa ama qunäga qärakni i ama moräs na qa ama qunäga vät iaqyäkt ama tmäski dä ma Jisas ka mair bä qa näs i qa qoar toqortäqyia, “Ngakt bä aung gärakni i aqäsä qa di mamär iva qä ang sagem ngo bä qä nakt. ");
INSERT INTO uro_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Bä auge qärak i qat nanakt na ngo di ma Ngämuqa aa enge ngärhi qoar iva ama reng na ama rigi ama ngätdäqäm gi va qiat dän bä qi ngang näväm ga.” ");
INSERT INTO uro_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Qa märhamän doqoräkt di qa muqunäga sävät ama Qloqaqa ama Qumärqumärqa qärakni i iarhakt kärarhae i rhat nanakt na qa diva nasot dä va rhi rha qa. Näkt as mudu inamäk bä sävät iomäkt ama qäväläm di as kaku ma Ngämuqa qa von da ama Qloqaqa ama Qumärqumärqa inguna ma Jisas di as kaku rha sek sa aa ngärhipki. ");
INSERT INTO uro_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bä nga rhoqoräkt i arhani ama ruvek nävät iaqyäkt ama guläñgi ta nari iangärhäkt aa enge dä rha qoar toqortäqyia, “Qoki ngäktki mamär i rhak täkt ama ruqa di iaqäkt kärak i ma Ngämuqa aa vämginaqa.” ");
INSERT INTO uro_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bä qosaqi arhani di rha qoar toqortäqyia, “Qa di nak ma Krais.” Dap koki as arhani di rhi snanbät toqortäqyia, “Ngu lu mäniekt bä va ma Krais di nak kop pa qa rhän nae ma Galili? ");
INSERT INTO uro_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nga qaku ngäktki rhoqoräkt i ma Ngämuqa aa enge ngät tamän i ma Krais diva akni nävät ma Devit aa enevaqi näkt pa qa rhän nämät ama värhäm ama gaini na äm ma Betlehem äkt i mudu ma Devit nae?” ");
INSERT INTO uro_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Näkt nga rhoqoräkt dä matmät ama ruvek inguna nävät ma Jisas. ");
INSERT INTO uro_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bä arhani ama ruvek di nani a rha iva rhi sangar a qa sokt di qaku aung nävät a rha qa rhäk pät a qa. ");
INSERT INTO uro_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Näkt nga nasot dä nak as ama ulaqimärharhärhäkt näva ama ansäspämgi ama mor qi evär däm da bä sage ama priskäna ama moräs na rha rhi na ama Farisiqäna dä iarhakt ama narhoerta rha snanbät sä iarhakt toqortäqyia, “Mäniekt bä qaku ngän män sä qa sarhe?” ");
INSERT INTO uro_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Dä iarhakt ama ulaqimärharhärhäkt ta muvät toqortäqyia, “As mudu qaku aung i qat tamän doqor tak täkt ama ruqa.” ");
INSERT INTO uro_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Bä nga rhoqoräkt dä ama Farisiqäna rha snanbät sä rha rhoqortäqyia, “Nga rhoqoräkt di ngäni qoar i qosaqi qa iras täm ngän? ");
INSERT INTO uro_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","As ngäni lu i ama tpäskinarha dä ama Farisiqäna di qaku rhat nanakt na qa. ");
INSERT INTO uro_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Sokt di iaqyäkt ama guläñgi na ama ruvek di sa rhat nanakt iarhakt kärarhae i qaku rhat dräm mamär nä ma Ngämuqa aa Muräkt. Rha di sa qale rha vä ma Ngämuqa aa rhäksärhäm.” ");
INSERT INTO uro_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Dä akni nävät ama Farisiqäna ma Nikodemus iaqäkt kärak i sa mäqi qa met sage ma Jisas ka snanbät sa arhani nävät iarhakt ama narhoerta rhoqortäqyia, ");
INSERT INTO uro_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nga varhäm aut muräkt di mamär iva urhi rhäksärha anga ruqa narhoer näkt nasot dä urhit träm i qat tualat toqor mäniekt?” ");
INSERT INTO uro_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Dä rha muvät pät a qa rhoqortäqyia, “Nak nga ainge di qosaqi nge nae ma Galili? As ngi lu ma Ngämuqa aa enge mamär dä va ngi lu i ngät tamän i qaku ma Ngämuqa anga vämginaqa qä namän nae ma Galili.” ");
INSERT INTO uro_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bä nasot toqoräkt dä rha moe rha met säva arha vät ");
INSERT INTO uro_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","dap ma Jisas di qa met säda ama damgi ama gaini na qi ama Damgi na ama Olip. ");
INSERT INTO uro_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Näkt duququ vät duququs mamär dä saqi as ka män bä säva ama ansäspämgi ama mor qi bä ama rhäqäp na rha ama ruvek tat dän bä sagem ga dä qa muqun bä qä nasäng i qä su rha. ");
INSERT INTO uro_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Bä nga rhoqoräkt i qä su rha dä ama Skraipkäna rhi na ama Farisiqäna rha män gem ga sa ama ruqi qäraktni i rha sangar a qi rhoqoräkt i qi qavatnävätlägut bä rha mair na qi dä qa guläñgi at saqong nä qa ruvek ");
INSERT INTO uro_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","näkt ta qoar nä ma Jisas toqortäqyia, “Qamorqa, rhakt täkt ama ruqi di ut sangar a qi inguna qia qavatnävätlägut. ");
INSERT INTO uro_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Varhäm ma Ngämuqa aa Muräkt di ma Moses kat tamän ma ama qrot särhäm ut iva urhi rhumät na ama ruqi rhoqor takt täkt na ama dui bä va qi ñäp. Bä nga rhoqoräkt dä ngu lu ainge di ngiat tamän mäniekt?” ");
INSERT INTO uro_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nävät tangät täkt arhä snanbät di rhi siqut nä ma Jisas i rhit ñäm nani anga rharimini ivakt iva rhi rhäksärhäm ga. Sokt di ma Jisas ka angär bä qä nasäng i qät säm bät ivät na aa rhäktka. ");
INSERT INTO uro_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bä nga rhoqoräkt i qoki rhat naingbät mät ka i rhi snanbät sä qa rhoqoräkt dä qa sek aa uväs bä qa qoar na rha rhoqortäqyia, “Ngakt bä auge nävät a ngän di qaku aa anga vuini di mamär iva qä er qä rhu qi na anga duiqa.” ");
INSERT INTO uro_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Bä nasot toqoräkt dä saqi qa angär bä qät säm bät ivät. ");
INSERT INTO uro_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Näkt nga nävät iangärhäkt aa enge dä arhani qärarhani i rha nari qa di rhi nasäng i asägäk asägäk tat tet i mänasäng nävät ama srurha mamär näkt sä rha moekt bä äkt bä sokt nävät ma Jisas kä nä qa ruqi qäraktni i qoki as kiat mair. ");
INSERT INTO uro_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Dä ma Jisas ka mair bä qa snanbät sä qi rhoqortäqyia, “Rhaktni, qärarhae rha qoe? Nga qaku aung iva qä rhäksärhäm nge?” ");
INSERT INTO uro_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Dä sa qärakt ka ruqi qia qoar toqortäqyia, “Morqa, qop kaku aung.” Dä ma Jisas ka qoar na qi mamär toqortäqyia, “Bä nga rhoqoräkt dä qosaqi aingo di qaku ngu narhäksärhäm nge. Dap täkt di ngia rhet sokt di saqi as pa qale ngi narhäk pät anga vuini.” ");
INSERT INTO uro_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Dä saqi as ma Jisas ka märhamän särha ama ruvek i qä qoar na rha rhoqortäqyia, “Aingo di ama neraqa bä ba ama ruvek pät ama ivätki. Näkt iaqäkt kärak i qät päs gua rhäng di qaku mamär iva qä natmet pät bängangit angät tpäs dap pa qa sa ama neraqa na ama iar.” ");
INSERT INTO uro_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Dä soknga ama Farisiqäna rha märhamän ma ama qrot särhäm ga rhoqortäqyia, “Iangärhäkt gi sameng di qaku ama engäktki na ngät inguna rhäkt di qoki nge maräkt ngia män bä ngi sameng sävät a nas.” ");
INSERT INTO uro_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Dä ma Jisas ka muvät pät a rha i qä qoar toqortäqyia, “Näma dä ngo maräkt ngu sameng sävät a nas sokt di iangärhäkt gu sameng di ama engäktki na ngät inguna nguat dräm äkt i sa ngua män nae bä qosaqi nguat dräm äkt iva ngua rhet sae. Dap ngän di qaku ngänät dräm i ngua män na qoe nai bä qosaqi qaku ngänät dräm äkt iva ngua rhet sae. ");
INSERT INTO uro_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Näkt aingän di ngän datnävämne na ama ruvek arha lat parhäm ama ruvek arhä snängaqa dap ngo di qaku ngu namatnävämne na aung anga ruqa aa lat. ");
INSERT INTO uro_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Sokt di ngakt bä nga nguat tatnävämne na ama ruvek arha lat dä qärangätni gu matnävämne di ama räkt ngät inguna qaku sokt ngo nguat tatnävämne dap ngu na ama Ngätmamäk kärakni i sa qa rhäk na ngo un datnävämne. ");
INSERT INTO uro_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Näkt käqi varhäm angän Muräkt maräkt di sa rha säm i ngakt bä ama udiom ama ruiom ini sameng sävät ani di iomäkt in sameng di ngärhi qoar i ianiäkt di ama engäktki nä ini. ");
INSERT INTO uro_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Dap aingo di ama sägäk na ngo qärak i qä sameng sävät a nas. Näkt kosaqi akni qärak i qä sameng sävät a ngo di ama Ngätmamäk kärakni i sa qa rhäk na ngo.” ");
INSERT INTO uro_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bä nga rhoqoräkt dä rhi nasäng i rhi snanbät sä qa rhoqortäqyia, “Ngu lu iaqäkt gi mam ga qoe?” Dä ma Jisas ka muvät toqortäqyia, “Aingän di qaku ngänät dräm a ngo bä qosaqi gu mamäk. Inguna vadi mai ngänät dräm a ngo dä qosaqi vadi mai ngänät dräm gu mamäk.” ");
INSERT INTO uro_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Rhangät täkt ama enge qärangät i qa märhamän bät a ngät di rhoqoräkt i qä su ama ruvek pa ama ansäspämgi ama mor qi glaqot na ama ivärhäs kärqosni i rhat dräm dat tu ama vänbon na ama ligär e. Sokt di qaku aung ga sangar a qa inguna as toqoräkt di aa qäväläm di as kaku rhäkmamär na äm. ");
INSERT INTO uro_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Näkt saqi as ma Jisas ka qoar na rha rhoqortäqyia, “Aingo diva ngua rhet daqule ngän bä va ngänit ñäm nani a ngo sokt diva ngäni ñäp mät angäna vuirhong. Inguna äkt iva ngua rhet sae di qaku mamär vät a ngän iva ngän namet sae.” ");
INSERT INTO uro_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bä äkt i ama Judaqäna rhi snanbät sä ne rhoqortäqyia, “Nga va qä veng näs inguna sa qa qoar i äkt iva ngua rhet sae di qaku mamär vät a ngän iva ngän namet sae?” ");
INSERT INTO uro_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Dä ma Jisas di qop kat tamän i qä qoar na rha rhoqortäqyia, “Aingän di ngän narhe dap aingo di ngo na rhävuk. Bä aingän di ngän nämäni rhakt täkt ama ivätki dap aingo di qaku ngo nämäni rhakt täkt ama ivätki. ");
INSERT INTO uro_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Bä äkt i sa ngua qoar na ngän iva ngäni ñäp mät angäna vuirhong inguna ngakt bä qaku ngänät nanakt i ngo di iaqäkt kärak i ngu sameng i aingo di iaqäkt di qoki va ngäni ñäp mät angäna vuirhong.” ");
INSERT INTO uro_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bä nga rha nari rhoqoräkt dä rha snanbät sä qa rhoqortäqyia, “Ngu lu auge na nge?” Dä ma Jisas ka muvät toqortäqyia, “Nak kop toqor varhäm gärangätni gua enge moe inamäk kärangät i sa ngu sameng sävät a nas.” ");
INSERT INTO uro_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","“Nak as masirhat nä gua enge sävät a ngän sä iarhongäkt kärqärhong iva ngua rhatnävämne na ngän bät irhong angät tpäs. Sokt di iaqäkt kärak i qa rhäk na ngo di qat dräm ama engäktki bä sokt agirhong gärqärhongni i sa ngua nari irhong nämät ka di nguat tamän särha ama ruvek nävät ama ivätki nä irhong.” ");
INSERT INTO uro_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Sokt di rhoqoräkt di qaku rhat dräm i nak ma Jisas kat tamän särhäm da sävät ama Ngätmamäk. ");
INSERT INTO uro_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Bä nga rhoqoräkt dä ma Jisas ka qoar na rha rhoqortäqyia, “Ngakt bä sa ngän sek sä ma Ruqa aa Emga dä va ngäni räm i aingo di iaqäkt kärak i ngu sameng i aingo di iaqäkt bä ngo di qaku sokt ngo ngu namualat nä guani dap sokt nguat tamän bät iarhongäkt kärqärhong i ama Ngätmamäk sa qa su ngo rhäm irhong. ");
INSERT INTO uro_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Näkt iaqäkt kärak i qa rhäk na ngo sarhe di qaku qa met daqule ngo dap kale qa gem ngo inguna vasägos dä nguat tualat nä qärangätni ama lat i märmär gem ga nävät a ngät.” ");
INSERT INTO uro_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bä nga rhoqoräkt i as kat tamän bät iangärhäkt ama enge dä sa ama rhäqäp na rha ama ruvek tat nanakt na qa. ");
INSERT INTO uro_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Dä soknga ma Jisas ka qoar nä iarhakt ama Judaqäna qärarhani i rhat nanakt na qa rhoqortäqyia, “Ngakt bä ngän det parhäm gu rhisu di aingän di nak gu mudäsaqongda mamär. ");
INSERT INTO uro_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Bä va ngänät dräm ama engäktki bä va iaqyäkt ama engäktki qia rhuisiska vät a ngän.” ");
INSERT INTO uro_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Dä rha muvät pät a qa rhoqortäqyia, “Nak aiut di ma Abraham aa qärhae na ut bä as mudu qaku qali lut i ama latta mavängam ba aung aa rem. Ngu lu mäniekt bä va ngi qoar iva ngia rhuisiska vät a ut?” ");
INSERT INTO uro_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Dä sa ma Jisas ka muvät toqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i iarhakt moe qärarhae i rhat tualat na ama vuirhong di iarhakt di qale rha va ama vuirhong angärha rem. ");
INSERT INTO uro_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Näkt ama latka mavängam gärakni i qale qa va akni aa rem di qaku qa nämäni ama enevaqi ma ama soktäm dap ama ruqa aa emga di sa qale qa ma ama soktäm mäni iaqyäkt ama enevaqi. ");
INSERT INTO uro_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Bä äkt i ngakt bä ma Ruqa aa Emga sa qa muisiska vät a nge diva isiska vät a nge mamär. ");
INSERT INTO uro_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Bä nguat dräm i ngän di ma Abraham aa qärhae. Sokt di nani a ngän masirhat iva ngäni veng ngo inguna qaku ngänät nanakt nä qärangätni gua enge. ");
INSERT INTO uro_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Näkt aingo di nguat tamän särhäm ngän nä iarhongäkt kärqärhong i sa ngua lu irhong doqoräkt i qale ngo ge gu mam dap ngän di ngän dualat nä iarhongäkt kärqärhong i sa ngän nari irhong nämät angän mamäk.” ");
INSERT INTO uro_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bä nga rha nari rhoqoräkt dä rha muvät toqortäqyia, “Ma Abraham di aut mamäk.” Dä ma Jisas ka qoar na rha rhoqortäqyia, “Ngakt bä ma Abraham aa es na ngän mamär dä vadi mai mamär iva ngän dualat na ama lat kärangätni i sa ma Abraham ga mualat na ngät. ");
INSERT INTO uro_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Aingo di sa ngua sameng ba ngän na ama engäktki qäraktni i ngua nari qi nage ma Ngämuqa dap täkt di nani a ngän iva ngäni veng ngo. Ma Abraham di mudu qaku qa mualat na agung anga lat toqoräkt. ");
INSERT INTO uro_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Dap ngän di ngän dualat nä iarhongäkt kärqärhong i qoki angän mamäk kat tualat nä irhong.” Bä nga rhoqoräkt dä rha muvät pät a qa i rha märhamän särhäm ga na ama qrot toqortäqyia, “Aiut di qaku ama rhoes na ut kärarhani i sa rha män nävät ama qavatka. Sokt aut mamäk ama sägäk bä iaqäkt di ma Ngämuqa.” ");
INSERT INTO uro_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Ngakt bä ma Ngämuqa di nak angän mamäk na qa di mamär iva angäna snäng bät a ngo inguna ngua män nage ma Ngämuqa bä rhäkt di sa qale ngo rhe. Bä qosaqi qaku ngua män barhäm gu snängaqa dap ka maräkt ka rhäk na ngo. ");
INSERT INTO uro_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mäniekt bä qaku qunäga vät a ngän sä rhangät täkt gua enge? Ama rharimini qärqäni i qaku qunäga vät a ngän sä gua enge dinguna qaku nani a ngän iva ngän namat maengäkt sä ngät. ");
INSERT INTO uro_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Aingän di angän mamäk ma Sämga bä nani a ngän iva ngän dualat parhäm aa snängaqa. Näkt ka di sa qat dräm gä veng ama ruvek mänasäng nävät ama rharimini. Bä qa di qaku qat dräm gat tualat parhäm ama engäktki inguna qaku ama engäktki qia e gem ga. Bä nga rhoqoräkt iva qä iras dä qat dräm gat tualat parhäm aa snängaqa maräkt inguna qa di ama irasmätka bä ama irasirhong angät mamäk. ");
INSERT INTO uro_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","“Bä äkt i qaku ngänät nanakt na ngo inguna nguat tamän bät ama engäktki. ");
INSERT INTO uro_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nga mamär iva aung nävät a ngän gä qoaräs na ngo sävät anga vuini qärqäni i sa ngua mualat nä ini? Ngakt bä nga nguat tamän bät ama engäktki dä mäniekt bä qaku ngänät nanakt na ngo? ");
INSERT INTO uro_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Iarhakt kärarhae i ma Ngämuqa aa es na rha di rhat nari ma Ngämuqa aa enge. Bä ama rharimini qärqäni i qaku ngänät dräm ngänät nari ngät dinguna qaku ma Ngämuqa aa es na ngän.” ");
INSERT INTO uro_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Dä ama Judaqäna rha muvät pät a qa i rhi snanbät toqortäqyia, “Nga ngäktki na ut toqoräkt i urhi qoar i nge di ama Samariaqa na nge dä ama iauska qa e mät nge?” ");
INSERT INTO uro_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Dä ma Jisas ka qoar toqortäqyia, “Aingo di qaku ama iauska qa e mät ngo dap ngut kutdrir sage gu mamäk sokt di aingän di qaku ngänit kutdrir sagem ngo. ");
INSERT INTO uro_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Bä aingo di qaku ngut ñäm nani ama murhämeska bä ba nas dap akni qa e qärakni i qät ñäm nani ama murhämeska bä ba ngo bä qa diva qat tatnävämne na ama ruvek. ");
INSERT INTO uro_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Näkt nguat tamän särhäm ngän na ama engäktki i ngakt bä iaqäkt kärak i qat tet parhäm gua enge di qa di qaku mamär iva qä nañäp.” ");
INSERT INTO uro_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Dä soknga ama Judaqäna rha qoar na qa rhoqortäqyia, “Nak täkt di ut dräm i nge di ama iauska qa e mät nge inguna ma Abraham gä nä qärarhani ma Ngämuqa aa vämginarha di sa rha ñäp. Dap nge di ngi qoar i iaqäkt kärak i qat tet parhäm gia enge di qaku mamär iva qä nañäp. ");
INSERT INTO uro_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nak nga nge di ama moräs na nge masirhat pät aut mamäk ma Abraham aa uväs? Ma Abraham di sa qa ñäp bä qosaqi sävät kärarhani ma Ngämuqa aa vämginarha. Ngu lu ngiat tu gi snäng i nge di auge na nge?” ");
INSERT INTO uro_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Dä sa ma Jisas ka muvät toqortäqyia, “Ngakt bä ngut sek sä gu ngärhipki dä iaqäkt gu murhämeska di qaku mamär vät guani na qa. Dap sokt gu mamäk kärakni i ngäni qoar i angän Ngämuqa na qa di iaqäkt kärak i qät sek sä gu ngärhipki. ");
INSERT INTO uro_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Bä näma dä qaku ngänät dräm a qa sokt di aingo di nguat dräm a qa. Ngakt bä nga vadi mai ngua qoar i qaku nguat dräm a qa dä va ama irasmätka na ngo rhoqor ngän sokt di nak nguat dräm a qa bä nguat tet parhäm aa enge. ");
INSERT INTO uro_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Bä angän mamäk ma Abraham di qä qok masirhat nävät iomäkt iva qä lu gu mänmänäs. Bä qa lu äs dä märmär gem ga.” ");
INSERT INTO uro_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Dä soknga ama Judaqäna rha qoar na qa rhoqortäqyia, “Nga sa ngia lu ma Abraham doqoräkt i gi qoeo di as kaku ama ruiom ama udiom da ama ngärhäqyisem na ngät?” ");
INSERT INTO uro_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Dä sa ma Jisas ka qoar na rha rhoqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i as toqoräkt i qaku rha sa ma Abraham dä sa ngo di sa qale ngo.” ");
INSERT INTO uro_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Bä nga rha nari rhoqoräkt dä rha mat ma ama dui ivakt iva rhi rhumät na qa sokt di ma Jisas ka ngaip nas bä up na qa i qa lir qa met näva ama ansäspämgi ama mor qi. ");
INSERT INTO uro_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Näkt nga rhoqoräkt i ma Jisas ka met näva ama ansäspämgi ama mor qi bä qat tet parhäm aa iska dä qa lu ama ruqa qärakni i qa säsur mänasäng doqoräkt i rha sa qa. ");
INSERT INTO uro_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Dä aa mudäsaqongda rha snanbät sä qa rhoqortäqyia, “Qamorqa, ngu lu auge qa mualat na ama vuini bä äkt i rha sa rhak täkt ama ruqa i ama säsur qa? Nga rhak täkt ama ruqa ura aa mamäqiom?” ");
INSERT INTO uro_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Dä ma Jisas ka qoar toqortäqyia, “Qaku rhak täkt ama ruqa bä qosaqi qaku qärqiomni aa mamäqiom da mualat na anga vuini dap ka män i ama säsurqa na qa divakt iva ama ruvek diva rhi lu ma Ngämuqa aa lat pät kärangätni aa iar. ");
INSERT INTO uro_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Bä nga rhoqor täkt i as ge qunäga dä mamär iva ut tualat nä iaqäkt kärak i qa rhäk na ngo aa lat inguna qorhäs iva bängagi iva qaku aung gä namualat. ");
INSERT INTO uro_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Näkt as toqor täkt i qale ngo mäni ama ivätki di ama neraqa na ngo bä ba ama ruvek nävät ama ivätki.” ");
INSERT INTO uro_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Bä nga nasot iangärhäkt aa enge dä qa qot pät ivät näkt ka näpgoer na ama ivätki qi na aa rhäbäñgi näkt ka mat a qi bä qa mu qi vät ka ruqa aa mänap angärha rhäng. ");
INSERT INTO uro_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Näkt ka qoar na qa rhoqortäqyia, “Ngia rhet bä ngi rhor nas mät ama egoga qärakni i rhat tes ka i ma Siloam.” Näkt iaqyäkt ama ngärhipki i Siloam di na ama Judaqäna arha enge di rhoqortäqyia, qa rhäk na qa. Bä äkt i iaqäkt ama ruqa qa met bä qa rhor nas näkt sa qa män säva vät i qat nañäm. ");
INSERT INTO uro_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Dä qärarhani ama ruvek i rhat dräm dat tas glaqot na qa bä sävät kärarhani i mudu rhat lu qa i qä nän nani anga ligär di rhi snanbät sä ne rhoqortäqyia, “Nguaräm dak täkt ama ruqa di nak kop iaqäkt kärak i qat dräm gat muqun bä qä nän nani anga ligär.” ");
INSERT INTO uro_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Dä arhani rha qoar i nak kop iaqäkt. Dap arhani di rha qoar toqortäqyia, “Qaku, nak kop kat nañäm doqor qa.” Sokt di qa ruqa maräkt di qop kat tamän doqortäqyia, “Nak kop aingo rhäkt.” ");
INSERT INTO uro_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bä äkt i rhoqoräkt dä rha snanbät sä qa mamär toqortäqyia, “Dä ngu lu mäniekt bä äkt i ngiat nañäm?” ");
INSERT INTO uro_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Dä sa qa muvät toqortäqyia, “Ama ruqa qärakni i rhat tes ka i ma Jisas ka näpgoer na ama ivätki qi na aa rhäbäñgi näkt ka mu qi vät gu mänap angärha rhäng. Näkt ka qoar na ngo iva ngua rhet sämät ama egoga ma Siloam bä va ngu rhor nas. Bä nga nasot toqoräkt i sa ngua met bä sae bä ngua rhor nas dä nguat nañäm.” ");
INSERT INTO uro_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Näkt nga rha nari rhoqoräkt dä rha snanbät sä qa rhoqortäqyia, “Ngu lu iaqäkt ama ruqa qa qoe nai?” Dä sa qa qoar toqortäqyia, “Qaku nguat dräm.” ");
INSERT INTO uro_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Näkt nga nasot dä rha met sa ama ruqa qärakni i mudu ama säsur qa bä sage ama Farisiqäna. ");
INSERT INTO uro_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Iaqäkt ama qunäga qärakni i ma Jisas ka näpgoer na ama ivätki qi na aa rhäbäñgi bä qa mu qi vät ama säsurqa aa mänap angärha rhäng bä sa qat nañäm di ama Sabat. ");
INSERT INTO uro_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bä nga rhoqoräkt dä qosaqi ama Farisiqäna rhi snanbät sä qa i mäniekt bä qat nañäm. Dä qa muvät pät a rha rhoqortäqyia, “Qa mu ama ivätki i qa näpgoer na qi qi na aa rhäbäñgi vät gu mänap angärha rhäng näkt ngua rhor nas bä rhäkt di nguat nañäm.” ");
INSERT INTO uro_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Dä arhani ama Farisiqäna rha qoar toqortäqyia, “Iaqäkt ama ruqa di qaku qa nage ma Ngämuqa inguna qaku qat tet parhäm ama Sabat aa muräkt.” Dap arhani nävät a rha di rha snanbät toqortäqyia, “Ngu lu nga mamär iva anga ruqa qärakni i qat tualat na ama vuirhong di qa rhualat na anga muqunän anga nañis ngät toqor tangät täkt?” Bä nga nävät tom däkt dä matmät arhä snängaqa bä ama udiom na rha. ");
INSERT INTO uro_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bä äkt i saqi rha rhong sävät kärak ka ruqa i mudu ama säsur qa bä rha snanbät sä qa rhoqortäqyia, “Ngu lu ainge qärak i sa iaqäkt ka ruqa qa mumäräs pät gi saqong diva ngia rhamän doqor mäniekt sävät a qa?” Dä qa muvät toqortäqyia, “Qa di akni ma Ngämuqa aa vämginaqa.” ");
INSERT INTO uro_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Sokt di ama Judaqäna di qoki as kaku rhat nanakt i iaqäkt ama ruqa di mudu ama säsur qa näkt nasot dä sa märäs pät aa saqong bä qat nañäm bä dängdäng i sa rha rhäkne nani aa mamäqiom. ");
INSERT INTO uro_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bä sa nga rhoqoräkt i aa mamäqiom in män dä rha snanbät sä iom doqortäqyia, “Nga rhak täkt di in oemga iaqäkt kärak i ini qoar i sa in sa qa i ama säsurqa na qa? Ngu lu mäniekt bä rhäkt di qat nañäm?” ");
INSERT INTO uro_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Dä sa aa mamäqiom in muvät toqortäqyia, “Unät dräm i qa di un oemga bä qosaqi unät dräm i aa nanäk kia sa qa i ama säsur qa. ");
INSERT INTO uro_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Sokt di qaku unät dräm i mäniekt bä sa rhäkt di qat nañäm bä qosaqi qaku unät dräm i auge iaqäkt kärak i qa mumäräs pät aa saqong bä qat nañäm. Ngäni snanbät sä qa inguna qa di sa ama mor qa bä va qa rhamän bä ba nas.” ");
INSERT INTO uro_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Näkt ama rharimini qärqäni i aa mamäqiom in märhamän doqoräkt dinguna init len ama Judaqäna i sa nguna ama Judaqäna rha rhares ba ne iva iaqäkt kärak i qä qoaräs mamär i ma Jisas di ma Krais na qa diva rhi qutmäs a qa näva arhä mämairqi. ");
INSERT INTO uro_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Bä äkt i rhoqor täkt dä sa aa mamäqiom in goaräs na rha rhoqortäqyia, “Sa qa di ama mor qa dap ngäni snanbät sä qa.” ");
INSERT INTO uro_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bä äkt i saqi as ama Judaqäna rha mes kärak ka ruqa i mudu ama säsur qa bä rha qoar na qa rhoqortäqyia, “Ut dräm i iaqäkt ama ruqa qärak i qa mumäräs pät gi saqong di qat dräm gat tualat na ama vuirhong. Dap täkt di mamär iva ngi vodä gia ansäs sage ma Ngämuqa.” ");
INSERT INTO uro_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Dä sa qa muvät toqortäqyia, “Qaku nguat dräm i iaqäkt ama ruqa di qat dräm gat tualat na ama vuirhong ura qaku. Dap sokt kärqäni i nguat dräm ini di mudu ama säsurqa na ngo dap täkt di sa nguat nañäm.” ");
INSERT INTO uro_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Dä soknga rha snanbät sä qa rhoqortäqyia, “Ngu lu qa mäsana na nge? Ngu lu qa mumäräs pät gi saqong doqor mäniekt?” ");
INSERT INTO uro_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Dä qa muvät pät a rha rhoqortäqyia, “Sa mai ngua qoar na ngän sokt di qop kaku ngän nari. Ngu lu mäniekt bä nani a ngän iva saqi ngäni nari nasot a nas? Nga nani a ngän iva qosaqi aa mudäsaqongda na ngän?” ");
INSERT INTO uro_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bä nga rha nari rhoqoräkt dä rhat tuma qa i rhi qoar toqortäqyia, “Nge di iaqäkt ama ruqa aa mudäsaqongga na nge dap aiut di ma Moses aa mudäsaqongda na ut! ");
INSERT INTO uro_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Inguna sa ut dräm i ma Ngämuqa qa märhamän särhä ma Moses dap iaqäkt ama ruqa di qoki sa qaku ut dräm äkt i qa män nae.” ");
INSERT INTO uro_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Dä qärak ka ruqa qa muvät pät a rha i qä qoar toqortäqyia, “Nak täkt di qräk mät ngo inguna sa ngäni qoar i qaku ngänät dräm äkt i qa män nae sokt di nak ka mumäräs pät gu saqong! ");
INSERT INTO uro_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Näkt ut dräm i ma Ngämuqa di qaku qat nari nämät ama ruvek kärarhani i rhat tualat na ama vuirhong. Dap sokt kat nari nämät ama ruvek kärarhani i rhat nanakt na qa bä rhat tet parhäm aa snängaqa. ");
INSERT INTO uro_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Näkt kosaqi mudu as kaku aung ga nari sävät anga ruqa qärakni i aa nanäk kia sa qa i ama säsur qa näkt nasot dä akni ama ruqa qa mumäräs pät aa saqong. ");
INSERT INTO uro_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ngakt bä iaqäkt ama ruqa di qaku qa nage ma Ngämuqa di vadi mai qaku qä namualat nä guani.” ");
INSERT INTO uro_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Dä rha muvät pät a qa i rhi qoar toqortäqyia, “Nge di sa rhäqäp gia iar mamär na ama vuirhong doqoräkt i gi nanäk kia sa nge. Ngu lu mäniekt bä nani a nge iva ngi su ut? Qaku mamär vät a nge iva ngi nasu ut.” Näkt nga nasot iangärhäkt arha enge dä rha qutmäs a qa näva arhä mämairqi. ");
INSERT INTO uro_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Bä nga rhoqoräkt i ma Jisas ka nari i sa rha qutmäs iaqäkt ama ruqa näkt toqoräkt i qa män bät a qa dä qa qoar na qa rhoqortäqyia, “Nga ngiat nanakt nä ma Ruqa aa Emga?” ");
INSERT INTO uro_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Dä qa ruqa qa snanbät toqortäqyia, “Qamorqa, ngu lu auge iaqäkt? Ngi qoar na ngo ivakt iva nguat nanakt na qa.” ");
INSERT INTO uro_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Dä sa ma Jisas ka qoar na qa rhoqortäqyia, “Rhäkt di nak sa ngia lu qa bä qa di rhak täkt kärak i ngi na qa in damän särhäm ne.” ");
INSERT INTO uro_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Dä qa ruqa qa qoar nä ma Jisas toqortäqyia, “Gua Engeska, sa rhäkt di nguat nanakt.” Näkt nga rhoqoräkt dä sa qa ansäs sage ma Jisas. ");
INSERT INTO uro_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Dä ma Jisas ka qoar na qa rhoqortäqyia, “Ngua män sämäni ama ivätki ivakt iva ngua rhatnävämne na ama ruvek iva ama ruvek kärarhani i qaku rhat nañäm diva rhat nañäm dap iarhakt kärarhae i rhat nañäm diva qaku rhat nañäm.” ");
INSERT INTO uro_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Näkt arhani ama Farisiqäna qärarhani i qale rha rhi nä ma Jisas ta nari qa i qa märhamän doqoräkt dä sa rha snanbät toqortäqyia, “Ngu lu mänia? Nga aiut di qosaqi ama säsurta na ut?” ");
INSERT INTO uro_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Dä ma Jisas ka qoar toqortäqyia, “Nak ngakt bä nga ama säsurta na ngän dä vadi mai qaku ngän nata ama rhäksärhäm inguna nävät angäna vuirhong dap nguna rhäkt di ngäni qoar i ngänät nañäm di as pa qale ngän ba angäna vuirhong angät täksärhäm angärha rem.” ");
INSERT INTO uro_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Näkt kosaqi ma Jisas ka qoar na rha rhoqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i ama ruqa qärakni i qaku qat don sämät ama sipsipkäna angärha surqa mät ama tmongi dap kät beng mavängam bät a qa bä savuk di iaqäkt di ama suaqa bä qa di qosaqi ama ruqa qärakni i qä rhar ta ama ruvek arhä qärhong. ");
INSERT INTO uro_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Dap ama ruqa qärakni i qat don mät ama tmongi bä savuk di iaqäkt di ama ruqa qärak i qät lu vät iangärhäkt ama sipsipkäna. ");
INSERT INTO uro_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Näkt ama ruqa qärakni i qät lu vät ama tmongi di qät tar nanokt ka savuk bä ama sipsipkäna ngät nari nämät iaqäkt kärak i qät lu vät a ngät. Näkt kat tes iangärhäkt aa sipsipkäna na angät ngärhep asägäk asägäk bä qä rhoer nanokt ngät navuk bä sä dalek. ");
INSERT INTO uro_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","“Bä nga rhoqoräkt i sa vuk sä qa sä iangärhäkt aa sipsipkäna moekt dä sa qä rhoer nanokt ngät dap dängdäng na ngät nasot a qa inguna ngät dräm aa eguinga. ");
INSERT INTO uro_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sokt di iangärhäkt aa sipsipkäna di qaku mamär mas iva ngä namet nasot anga ruqa anga nañis ka i ngakt bä nga rhoqoräkt dä va ngärhi ang daqule qa inguna sirhäkt kaku ngä naräm anga nañiska aa eguinga.” ");
INSERT INTO uro_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ma Jisas ka märhamän bät tangät täkt ama enge na ama siqutki sokt di qaku qunäga vät a rha sä iangärhäkt aa enge. ");
INSERT INTO uro_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Dä soknga saqi as ka qoar na rha rhoqortäqyia, “Nguat tamän särhäm ngän na ama engäktki i ngo di ama tmongi na ngo bä ba ama sipsipkäna. ");
INSERT INTO uro_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Näkt sa iarhakt kärarhae moekt ama ruvek i mudu rha er ta män näkt sä ngo di ama suarha na rha bä rha di ama ruvek kärarhani i rhi rhar ta arhani arhä qärhong sokt di ama sipsipkäna di qaku ngät nari nämät ta. ");
INSERT INTO uro_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Aingo di ama tmongi näkt kärakni i qat don mät iaqyäkt ama tmongi diva ama iar va aa uväs. Bä va qa di qat don savuk dä saqi vukpuk sä qa bä va qat dän bät ama mämägän. ");
INSERT INTO uro_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Näkt ama suaqa di qat dän divakt iva sokt kä sua bä qä veng näkt kosaqi qä slava mamär nä iarhongäkt moe. Dap aingo di sa ngua män ivakt iva ba ngät na ama iar qärangätni i rhäqäp ngät na ama mämägän. ");
INSERT INTO uro_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Näkt kosaqi aingo di ama ruqa qärakni i qät lu vät ama sipsipkäna mamär i sa qat dräm gät boda aa iar ba ngät. ");
INSERT INTO uro_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Dap ama ruqa qärakni i rhit sek mä qa vät ama lat i qät lu vät ama sipsipkäna di iaqäkt di qaku ama ngärhik bä ba ama sipsipkäna. Bä äkt i nga rhoqoräkt i qä lu ama mäsmäs päm ga ama muräpka i qä ngang inamuk dä va qä ngang masirhat daqule ama sipsipkäna. Bä sa va iaqäkt ama muräpka qä nesmät na angätni nävät ama guläñgi nä iangärhäkt ama sipsipkäna dap pa vräs na ngät i ngärhi ang mavängam. ");
INSERT INTO uro_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Bä iaqäkt ama ruqa diva qä ang masirhat daqule ama sipsipkäna inguna qa di sokt tit sek mä qa vät ama lat i qät lu vät ama sipsipkäna bä äkt i qaku qänäskänes ka iva qät lu vät a ngät mamär. ");
INSERT INTO uro_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Aingo di iaqäkt ama ruqa qärak i qät lu vät ama sipsipkäna mamär bä ngo di nguat dräm gu sipsipkäna bä iangärhäkt ama sipsipkäna di ngät dräm a ngo ");
INSERT INTO uro_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","nak kop toqorne rhoqoräkt i ama Ngätmamäk di qat dräm a ngo dä qosaqi ngo di nguat dräm ama Ngätmamäk. Bä ngut bodä gua iar bä ba ama sipsipkäna. ");
INSERT INTO uro_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Näkt kosaqi angätni gu sipsipkäna nga e qärangätni i qaku ngät nämäni rhakt täkt ama guläñgi na ama sipsipkäna diva qoki as pa ngu rha ngät sagem mes. Bä va ngät di qosaqi ngät nari nämät ngo bä sa va ama sägäkt ama guläñgi na ama sipsipkäna dä va ama sägäk ama ruqa qärakni iva qät lu vät a qi. ");
INSERT INTO uro_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Näkt ama rharimini qärqäni i gu mamäk aa snäng bät a ngo dinguna ngut bodä gua iar ivakt iva saqi as ngu rhäqäs täm ngät. ");
INSERT INTO uro_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Näkt pa qaku aung gä narhäksot nä gua iar dap pa ngu vodäm ngät parhäm gu snängaqa. Inguna sa gu mamäk ka rhares pät gua rhäng iva ngu vodä gua iar dä saqi ngu rhäqäs täm ngät. Gu mam ga muräkt bä ba ngo rhoqoräkt.” ");
INSERT INTO uro_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Bä nga nävät tangät täkt ma Jisas aa enge dä saqi as matmät ama Judaqäna. ");
INSERT INTO uro_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bä ama rhäqäp na rha nävät a rha di rhi qoar toqortäqyia, “Iaqäkt di ama iauska qa e mät ka bä guani na qa mamär. Ngu lu mäniekt bä va ut nari nämät ka?” ");
INSERT INTO uro_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Dap arhani di rhi qoar toqortäqyia, “Nga mamär iva anga iauska qa rhumäräs pät ama ruvek ama säsur ta arhä saqong? Nak tangät täkt ama enge di qaku ngät nämät ama ruqa qärakni i ama iauska qät täk pät a qa.” ");
INSERT INTO uro_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Näkt nga nasot iangärhäkt dä ama tmäski ama mor qi qia män e ma Jerusalem gäraktni iva rha rhu arhä snäng sävät ama ansäspämgi ama mor qi qäraktni i mudu saqi as ta vodäm gi sage ma Ngämuqa. Bä rhoqoräkt di ama soeng angät kunäng ");
INSERT INTO uro_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","bä ma Jisas di qale qa va ama ansäspämgi ama mor qi bä qat tet mänguräp ama suqulap sa ama ungi qärqapni i rhat tes ap i ma Solomon Aa Suqulap. ");
INSERT INTO uro_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bä rhoqoräkt dä sa västämne na ama Judaqäna namet a qa bä rhi qoar na qa rhoqortäqyia, “Ngu lu va qäsnia dä va ngi qoar na ut mamär sävät a nas? Ngakt bä ma Krais na nge dä ngi qoaräs na ut mamär.” ");
INSERT INTO uro_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Sa ngua qoaräs na ngän sokt di qaku ngänät nanakt. Iangärhäkt gua lat kärangät i nguat tualat na ngät di ngät nävät gu mamäk aa ngärhipki bä ngät di ngärhi sameng sävät a ngo ");
INSERT INTO uro_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","sokt di qaku ngänät nanakt inguna ngän di qaku ngän nämäni gu guläñgi nä gu sipsipkäna. ");
INSERT INTO uro_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Gu sipsipkäna di ngät nari gua eguinga dä ngärhit päs gua rhäng bä nguat dräm a ngät. ");
INSERT INTO uro_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Näkt ngut bon ngät ta ama iar ama sok täm ngät bä sa va qaku mamär iva qäbäs na ngät dä va qaku mamär iva aung gä nar täm ngät nagem ngo. ");
INSERT INTO uro_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bä gu mamäk kärakni i qa von ngo rhäm ngät di ama moräs na qa masirhat pa ama ruvek moe arhä väs bä äkt i qaku mamär iva aung gä nar täm ngät nagem ga. ");
INSERT INTO uro_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Bä ngo ngu na ama Ngätmamäk di sägäk na un.” ");
INSERT INTO uro_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Näkt nga ama Judaqäna rha nari rhoqoräkt dä saqi as ta mat ma ama dui ivakt iva rhi rhumät na qa. ");
INSERT INTO uro_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Sokt di ma Jisas ka qoar na rha rhoqortäqyia, “Sa ngua qur a ngän da ama rhäqäp na ngät ama mär ngät ama lat nage ama Ngätmamäk. Ngu lu agi a lat nävät iangärhäkt diva ngäni rhumät na ngo vät angät tpäs?” ");
INSERT INTO uro_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Dä sa ama Judaqäna rha muvät pät a qa rhoqortäqyia, “Aiut diva qaku ut narhumät na nge vät agung angät tpäs nävät iangärhäkt gia lat ama mär ngät dap pät iomäkt i qaku ngit kutdrir sävät ma Ngämuqa inguna nge di nak kop ama ruqa mavängam näkt mamär dä ngiat tes nas i nge di ma Ngämuqa na nge.” ");
INSERT INTO uro_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Sa ngänät dräm i sa rha säm ama enge vä ma Ngämuqa aa Muräkt kärangätni i ngärhi qoar toqortäqyia, ‘Sa ngua qoar i aingän asägäk asägäk di ama ngämuqa na ngän.’ ");
INSERT INTO uro_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ngakt bä ma Ngämuqa qa mes iarhakt ama ruvek i ama ngämuqa na rha iarhakt kärarhae i sa qa von da aa enge ba rha näkt kaku mamär vät anga ruqa iva qä nanbetäk mät na aa enge ");
INSERT INTO uro_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","dä ngu lu mäniekt bä ngäni qoar nä iaqäkt kärak i sa ama Ngätmamäk ka arñis na qa bä ba nas bä qa rhäk na qa sämäni rhakt täkt ama ivätki i qaku qät kutdrir sage ma Ngämuqa rhoqoräkt i qä qoar toqortäqyia, ‘Aingo di ma Ngämuqa aa emga na ngo’? ");
INSERT INTO uro_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ngakt bä qaku nguat tualat nä iarhongäkt kärqärhong i gu mamäk kat tualat nä irhong dä mamär iva qale ngänät nanakt na ngo. ");
INSERT INTO uro_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Dap ngakt bä nguat tualat nä iarhongäkt sokt di ngän di qaku ngän dat maengäkt sä gua enge dä mamär iva ngänät nanakt nä gua lat ivakt iva qunäga vät a ngän i ama Ngätmamäk di qa e gem ngo bä ngo di sa ngua e ge ama Ngätmamäk.” ");
INSERT INTO uro_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bä nga ama Judaqäna rha nari rhoqoräkt dä saqi as ta siqut iva rhi sangar a qa sokt di qa met nämät arhä rhäkt. ");
INSERT INTO uro_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Näkt nga nasot toqoräkt dä evär dä ma Jisas särhage na ama rigi ma Jordan bä sävät ama ivärhäs kärqosni i mäqi ma Jon gä baptais pät ama ruvek bä qale qa e. ");
INSERT INTO uro_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bä ama rhäqäp na rha ama ruvek ta män sagem ga näkt ti qoar na ne rhoqortäqyia, “Nak ngäktki i ma Jon di qaku qa mualat na anga muqunängi anga nañis ki sokt di nak aa enge moe qärangätni i qa märhamän bät a ngät sävät tak täkt ama ruqa di ama engäktki na ngät.” ");
INSERT INTO uro_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Dä sa ama rhäqäp na rha ama ruvek nävät iosäkt ama ivärhäs tat nanakt nä ma Jisas. ");
INSERT INTO uro_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Näkt nga rhoqoräkt di akni ama ruqa qärakni i rhat tes ka i ma Lasarus nämät ama värhäm ma Betani qärqomni i ma Maria qi na arha matki ma Marta ina värhäm di aräm ga. ");
INSERT INTO uro_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Bä iaqyäkt ma Maria qäraktni i qale arha matka ma Lasarus mät ama rämgi di nak kop iaqyäkt kärakt i sa qia vrit na ama oel ama mär at tamaska vät ma Engeska aa qäriglem dä qia suqup pät iglem na at käseng. ");
INSERT INTO uro_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bä nga rhoqoräkt dä iaemäkt ki na arha matki in däk na ama enge sage ma Jisas toqortäqyia, “Engeska, ama ruqa qärakni i gia snäng bät a qa di aräm ga.” ");
INSERT INTO uro_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Bä nga rhoqoräkt i ma Jisas ka nari iangärhäkt ina enge dä qa qoar toqortäqyia, “Rhakt täkt ama rämgi di qaku mamär iva iaqäkt kä nañäp mät ki. Dap iaqyäkt ama rämgi diva nani ma Ngämuqa aa murhämeska ivakt iva nävät a qi diva rhi sek sä ma Ngämuqa aa emga.” ");
INSERT INTO uro_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ma Jisas di aa snäng bät ma Marta qi na arha läktki dä ma Lasarus. ");
INSERT INTO uro_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Bä nga qa nari i ma Lasarus di aräm ga dä as kale qa äkt pät aiomni ama qunängiom. ");
INSERT INTO uro_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Näkt nga nasot iangärhäkt dä qa qoar na aa mudäsaqongda rhoqortäqyia, “Saqi as evär däm ut sae ma Judia.” ");
INSERT INTO uro_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Sokt di nga rha nari rhoqoräkt dä rha qoar na qa rhoqortäqyia, “Qamorqa, nak kop kre rhäkt di nani ama Judaqäna iva rhi rhumät na nge na ama dui dap nga nani a nge iva evär däm nge sae?” ");
INSERT INTO uro_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Dä ma Jisas ka muvät pät a rha rhoqortäqyia, “Ngänät dräm i mänasäng bät duququs bä dängdäng säpbängang di ama qunäga qät bon da ama neraqa. Ama ruqa qärakni i qat tet pät kunäng di qaku qat dräm arharpus na qa inguna qat nañäm da ama neraqa ba ama ivätki. ");
INSERT INTO uro_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Dap nga qat tet näp bängagi diva arpus na qa inguna qaku anga neraqa gem ga.” ");
INSERT INTO uro_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Näkt nga nasot tangät täkt aa enge dä saqi as ka qoar na rha rhoqortäqyia, “Aurha ruaqa ma Lasarus di sa qa mänatäm sokt diva ngua rhet sae ivakt iva ngu rhäqäm a qa.” ");
INSERT INTO uro_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Dä soknga aa mudäsaqongda rha qoar na qa rhoqortäqyia, “Engeska, ngakt bä qä mänatäm diva märäs pät a qa.” ");
INSERT INTO uro_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Näkt toqoräkt di ma Jisas di sa qat tamän sävät ma Lasarus aa tñäpki sokt di aa mudäsaqongda di rhat tu arhä snäng i qat tamän sävät ama mänäpki mamär. ");
INSERT INTO uro_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Dä ma Jisas ka qoar na rha mamär toqortäqyia, “Ma Lasarus di sa qa ñäp ");
INSERT INTO uro_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","sokt di märmär gem ngo i qaku qale ngo e divakt iva sä ngän iva ngänät nanakt. Dap täkt di u rhet sagem ga.” ");
INSERT INTO uro_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Dä ma Tomas kärakni i rhat tes ka i ma Didimus i iaqyäkt ama ngärhipki at tarimini di ama mäsangaqa di qa qoar nä iarhakt moe ama mudäsaqongda rhoqortäqyia, “Rhäkt di qosaqi ut moe u rhet ivakt iva urhi ñäp ut na qa.” ");
INSERT INTO uro_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Näkt nga rhoqoräkt i sa ma Jisas ka män e dä qa lu i sa qale ma Lasarus aa släqyige mät ama liqi qäraktni i sa rha rhap mä qi mäni ama qäsäpki. Aa släqyige di sa qale ige äkt pät ama levaet ama qunäng. ");
INSERT INTO uro_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Näkt ma Betani di ngäkt kre ama dävaung ama kilomitaqäna nae ma Jerusalem sae sämät äm ");
INSERT INTO uro_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","bä äkt i sa ama rhäqäp na ama ruvek ta män sage ma Marta qi nä ma Maria ivakt iva rhit säm ama märmärgem sävät in snängaqa nasot in gamoeqa ma Lasarus. ");
INSERT INTO uro_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Bä sa nga rhoqoräkt i ma Marta qia nari sävät ma Jisas i as kat tet inamuk iva sagem da dä sa qia met ivakt iva qi rhäknais nani a qa dap ma Maria di qali qi va vät. ");
INSERT INTO uro_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Bä nga rhoqoräkt i ma Marta qia män bät ma Jisas dä qia qoar na qa rhoqortäqyia, “Engeska, nga vadi mai qale nge rhe dä sa vadi mai qaku mamär iva gua läktka qä nañäp. ");
INSERT INTO uro_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Näma dä sa qa ñäp sokt di nguat dräm iva ma Ngämuqa qä von nge rha agini qärqäni i ngi nän ga rhäm ini.” ");
INSERT INTO uro_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Dä ma Jisas ka qoar na qi rhoqortäqyia, “Gia läktka di saqi as pa qa rhäranas nämät ama tñäpki.” ");
INSERT INTO uro_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Bä nga ma Marta qia nari rhoqoräkt dä qia qoar na qa rhoqortäqyia, “Nguat dräm iva saqi as pa qa rhäranas nämät ama tñäpki vät ama qäväläm gärqomni iva ama ruvek moe rha rhäranas pät ama dängdängini na qa ama qunäga.” ");
INSERT INTO uro_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Dä ma Jisas ka qoar na qi rhoqortäqyia, “Aingo di iaqäkt kärak i qat täranas na ama ruvek nämät ama tñäpki bä qosaqi ngo di ama iar. Näkt aung gärakni i qat nanakt na ngo i näma dä sa qa ñäp sokt diva ama iar qa ");
INSERT INTO uro_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","bä qosaqi iarhakt moe qärarhae i rhat däqäm näkt tat nanakt na ngo di qaku mamär iva rhi nañäp. Nga ngiat nanakt toqor täkt?” ");
INSERT INTO uro_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Dä sa qia qoar nä qa rhoqortäqyia, “Ari Engeska, nguat nanakt i nge di ma Ngämuqa aa emga ma Krais iaqäkt kärak i sa mudu rha säm iva as mirhup nasot dä va qa rhän sämäni ama ivätki.” ");
INSERT INTO uro_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Näkt nga nasot i sa qia qoar nä ma Jisas toqoräkt dä saqi evär däm gi bä qia siqutmät ba arha läktki ma Maria iva qia rhet särhage sagem gi. Näkt kia qoar na qi rhoqortäqyia, “Sa Qamorqa di rhakni dap kät täkne nani a nge.” ");
INSERT INTO uro_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Bä äkt i nga ma Maria qia nari rhoqoräkt dä sa qia lir qia märanas bä qia met sagem ga. ");
INSERT INTO uro_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Rhoqoräkt di ma Jisas di as kaku qa män mät iomäkt ama värhäm dap kale qa as pät ama ivärhäs äkt kärqosni i sa ma Marta qia män bät a qa e. ");
INSERT INTO uro_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Näkt nga rhoqoräkt i ama ruvek kärarhani i sa qale rha rhi nä ma Maria va vät i rhit säm ama märmärgem sävät at snängaqa di rha lu rhoqoräkt i qia lir qia märanas bä vuk sä qi sä dalek dä sa rha met nasot a qi i rha mu arhä snäng iva qia rhet sävät ama ivärhäs kärqosni i rha mu ma Lasarus aa släqyige e ivakt iva qi igi sävät ige. ");
INSERT INTO uro_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Bä nga rhoqoräkt i ma Maria qia män äkt pät iosäkt ama ivärhäs kärqosni i qale ma Jisas e dä sa qia lu qa dä arpus na qi samäk säng aa qar bä qia qoar na qa rhoqortäqyia, “Engeska, nga vadi mai qale nge rhe dä sa vadi mai qaku mamär iva gua matka qä nañäp.” ");
INSERT INTO uro_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Näkt nga rhoqoräkt i ma Jisas ka lu qi i qi na ama ruvek kärarhani i sa rha män di na qi i rhit nok dä sa airäs ka masirhat bä qät lavuqi na rha mamär. ");
INSERT INTO uro_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Bä äkt i ma Jisas ka snanbät toqortäqyia, “Ngu lu ngän mu aa släqyige qoe nai?” Dä rha muvät pät a qa rhoqortäqyia, “Engeska, ngi ang bä ngi lu.” ");
INSERT INTO uro_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Dä vrakt sä ma Jisas bä qät nok. ");
INSERT INTO uro_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Dä sa ama ruvek ti qoar na ne rhoqortäqyia, “As ngäni lu i aa snäng bät a qa mamär!” ");
INSERT INTO uro_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Dap arhani nävät a rha di rhi qoar toqortäqyia, “Rhak täkt kärak i sa qa mumäräs pät ama säsurqa aa saqong di vadi mai mamär iva qa rhumaiar tak täkt ama ruqa bä va qaku qä nañäp.” ");
INSERT INTO uro_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Bä ma Jisas di saqi as airäs ka masirhat toqoräkt i qa män bät iosäkt ama ivärhäs kärqosni i qale ma Lasarus aa släqyige e. Sa rha mu ige mät ama liqi näkt ta väs na ama duiqi da arha väm. ");
INSERT INTO uro_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Dä ma Jisas ka qoar toqortäqyia, “Ngäni rhägär na ama duiqi nae.” Dä sa ma Marta qäraktni i arha läktka di iaqäkt ama ñäpka di qia qoar nä ma Jisas toqortäqyia, “Engeska, sokt di rhoqor täkt di sa imuk di ama rhamaska ama vu qa inguna sa qale aa släqyige äkt pät ama levaet ama qunäng.” ");
INSERT INTO uro_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Dä ma Jisas ka muvät pät a qi rhoqortäqyia, “Nga sa qaku ngua qoar na ngän i ngakt bä ngänät nanakt diva ngäni lu ma Ngämuqa aa murhämeska?” ");
INSERT INTO uro_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Bä äkt i sa rha rhägär na ama duiqi nae. Dä sa ma Jisas ka ñäm dävit säva usäp näkt ka qoar toqortäqyia, “Mam, nguat tes ama mär sagem nge inguna sa ngia nari ngo. ");
INSERT INTO uro_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Sa nguat dräm i vasägos dä ngiat nari ngo sokt di ngua märhamän doqoräkt iva ba ama ruvek kärarhani i qale rha rhäkt ivakt iva rhat nanakt i sa ngia rhäk na ngo sarhe.” ");
INSERT INTO uro_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Näkt nga nasot i ma Jisas ka märhamän doqoräkt dä sa qa näs masirhat toqortäqyia, “Lasarus, puk sä nge!” ");
INSERT INTO uro_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Dä sa vuk sä qa ñäpka sä dalek i aa rhäkt ngä na aa qar di sa rha is pät a ngät na ama baulitnäk ama ingas itnäk näkt kosaqi rha is pät aa uväski na ama bauläm. Dä ma Jisas ka qoar na rha rhoqortäqyia, “Ngäni rhäväkt sa ama tñäpki at boi nävät a qa näkt kale qa äkt iva qat tet.” ");
INSERT INTO uro_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Dä soknga ama rhäqäp na ama ruvek kärarhani i sa rha män sage ma Maria ivakt iva rhit säm ama märmärgem sävät at snängaqa di rha lu iarhongäkt kärqärhong i sa ma Jisas ka mualat nä irhong dä rhat nanakt na qa. ");
INSERT INTO uro_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Dap arhani nävät a rha di rha met bä sage ama Farisiqäna bä rha qoar na rha sävät iarhongäkt kärqärhong i sa ma Jisas ka mualat nä irhong. ");
INSERT INTO uro_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Bä nga rhoqoräkt dä ama priskäna ama moräs na rha rhi na ama Farisiqäna rha mu ama mämugunäs bä ba ama guläñgi na ama narhoerta mamär ma Sanedrin. Näkt ta snanbät sä ne rhoqortäqyia, “Ngu lu va u rhualat toqor mäniekt? Inguna rhak täkt ama ruqa di qat tualat na ama rhäqäp na ngät ama muqunän ama nañis ngät. ");
INSERT INTO uro_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ngakt bä urha qlak na qa rhoqoräkt dä va ama ruvek moe diva rhat nanakt na qa. Näkt na äkt dä va ama Romgäna va rha rhän bä rhi slava mamär na aurha ivärhäm ama qumärqumär äm ngä na aurha ruvek.” ");
INSERT INTO uro_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Dä akni nävät a rha qärakni i rhat tes ka i ma Kaiafas iaqäkt kärak i ama pris ama vit na qa vät iaqäkt ama quiaqa qa qoar toqortäqyia, “Aingän di qaku ngänät dräm guani mamär! ");
INSERT INTO uro_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Näkt kosaqi qaku qunäga vät a ngän i nak ama märäm masirhat kre i ama sägäk ama ruqa qä ñäp bä ba ama ruvek i varis kre va dä qärarhani aurha ruvek moe diva qäbäs na rha.” ");
INSERT INTO uro_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Bä rhangät täkt di qaku qa maräkt aa enge sokt dinguna ma Kaiafas di ama pris ama vit na qa vät iaqäkt ama quiaqa dä sa qä sameng sävät agini qärqäni iva ini ngä rhän nasot i ma Jisas diva qä ñäp bä ba ama Judaqäna. ");
INSERT INTO uro_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Bä iangärhäkt aa enge di qaku sokt toqoräkt iva ma Jisas kä ñäp bä bä iarhakt ama Judaqäna dap kosaqi va qä ñäp bä bä iarhakt ma Ngämuqa aa es kärarhae i sa qale rha sañis na ne ivakt iva qä västämne na rha bä va sägäk na rha moe. ");
INSERT INTO uro_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Bä äkt i nga mänasäng nävät iaqäkt ama qunäga dä rhat tamän särhäm ne iva rhi veng ga. ");
INSERT INTO uro_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Dä soknga na äkt dä saqi as kaku ma Jisas kat tet mät saqong mänguräp ama Judaqäna. Dap kinak ka met na äkt bä sämät ama värhäm gärqomni i rhat tes äm i ma Efraim bät ama ngärhäktka glaqot na ama qräk dä bäs ama ivärhäs bä qale qa e qä na aa mudäsaqongda. ");
INSERT INTO uro_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Rhoqoräkt di qorhäs mamär na ama qäväläm gärqomni iva ama Judaqäna arha tmäski ma Pasova bä ama rhäqäp na rha rha met nävät iaqäkt ama ngärhäktka bä sae ma Jerusalem ivakt iva rhi qumär nas narhoer iva äkt dä sa va ma Pasova. ");
INSERT INTO uro_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bä nga rhoqoräkt i rhat mair va ama ansäspämgi ama mor qi dä rhat nañäm nani ma Jisas dap ti snanbät sä ne rhoqortäqyia, “Ngu lu ngän du angän snäng doqor mäniekt? Nga va qoki sa qaku qä namän säva ama tmäski?” ");
INSERT INTO uro_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sokt di ama priskäna ama moräs na rha rhi na ama Farisiqäna rha von da arha enge ama qrot ngät i ngakt bä aung gat dräm äkt i qale ma Jisas e dä mamär iva qä qoaräs irhäm ga ivakt iva rhi sangar a qa. ");
INSERT INTO uro_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Näkt as pät ama ngärhäqyet da sägäk ama qunäng iva äkt dä sa ma Pasova dä sa ma Jisas ka män e ma Betani äkt i ma Lasarus kärakni i ma Jisas ka märanas na qa nämät ama tñäpki qale qa e. ");
INSERT INTO uro_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Bä nga rhoqoräkt i sa ma Jisas ka män e dä rha mualat na ama tmäs bä ba qa. Ma Marta qiat tatmät na ama tmäs dap ma Lasarus di qale qa qä nä iarhakt kärarhae i rhat täs ti nä ma Jisas nävät ama laiqa. ");
INSERT INTO uro_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Dä sa ma Maria qia rha ama oel qäraktni i mamär iva qorhäs sämät ama kapiom ama udiom gäraktni i rhat tes ki i ama nard. Iaqyäkt ama oel di at tamaska ama mär qa masirhat bä ama ligär masirhat pät a qi. Näkt kia rhor na qi vät ma Jisas aa qar näkt kia suqup pät aa qar na at käseng. Bä iaqäkt ama vätka di rhäqäp ka na ama mär qa ama rhamaska. ");
INSERT INTO uro_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Sokt di akni nävät ma Jisas aa mudäsaqongda qärakni i rhat tes ka i ma Judas Iskariot iaqäkt kärak iva nasot dä va qä vodäm ga bä ba aa ikkäna qa qoar toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ngu lu mäniekt bä qaku rha vodä rhakt täkt ama oel bä rha von ama tläkta rha ama ligär? Nak at saqong di rhoqorne na ama dävaung ama handretkäna na ama qunäng angät titsek.” ");
INSERT INTO uro_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Sa qa märhamän doqoräkt di qaku vadi vakt inguna qät lavuqi na ama tläkta dap nguna qa di ama suaqa. Qa di qat dräm gat lu vät ama rhaeqa na ama ligär dä qat dräm gat tat nae nävät ama ligär qärangätni i rhit näs ngät sae bä mamärmamär vät a qa. ");
INSERT INTO uro_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Dä soknga ma Jisas ka muvät pät a qa maräkt toqortäqyia, “Ngi qyiradeng na qi inguna sa qiat tu qi nani ama qäväläm gärqomni iva rhi sasärhäm ngo. ");
INSERT INTO uro_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Inguna qärarhani ama tläkta diva vasägos dä qale rha gem ngän dap aingo diva qaku qale ngo gem ngän basägos.” ");
INSERT INTO uro_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Dap toqoräkt dä sa ama guläñgi ama mor qi na ama Judaqäna rha räm nä ma Jisas i qale qa e dä rha män i qaku va sokt ti lu ma Jisas dap pakt iva qosaqi rhi lu ma Lasarus iaqäkt kärak i sa ma Jisas ka märanas na qa nämät ama tñäpki. ");
INSERT INTO uro_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Sokt di ama priskäna ama moräs na rha rhat tamän särhäm ne iva qosaqi rhi veng ma Lasarus ");
INSERT INTO uro_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","inguna nävät a qa bä ama rhäqäp na rha ama Judaqäna rhat tet sage ma Jisas bä rhat nanakt na qa. ");
INSERT INTO uro_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Näkt duququ vät akni ama qunäga dä iaqyäkt ama guläñgi ama enges ki mamär na ama ruvek kärarhani i sa rha män säva ama tmäski rha nari sävät ma Jisas i qa e varhäm aa iska sae ma Jerusalem. ");
INSERT INTO uro_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bä äkt i sa rha rha ama ngämung gärangätni i rhat tes ngät i ama pam angä rhäqyitnäk bä rha met ivakt iva rhi rhäknais nani a qa dap tit näs toqortäqyia, “Hosana! Mamär iva ama modämne sävät tak täkt kärak i qat dän nävät ma Engeska ma Ngämuqa aa ngärhipki! Ama modämne sage ama Israelqäna arha vitnaqa!” ");
INSERT INTO uro_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Dä sa ma Jisas ka män bät ama donki ama rhoem ga bä sa qa muqun bät aa rhäng doqor varhäm ama enge qärangätni i sa rha säm a ngät i ngät tamän doqortäqyia, ");
INSERT INTO uro_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Va qale ngit len ma Saion at tuimgi. As ngi lu gia vitnaqa iak navuk i qat dän i qat muqun bät ama donki at toemga aa rhäng.” ");
INSERT INTO uro_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Näkt nga rhoqoräkt narhoer dä as kaku qunäga vät aa mudäsaqongda sä rhangät täkt. Sokt di nga nasot i sa rha sek sä ma Jisas aa ngärhipki dä nak as ta lu mamär nä rhangät täkt kärangät i sa rha säm a ngät sävät a qa bä qosaqi iarhongäkt kärqärhong i sa rha mualat nä irhong sävät a qa. ");
INSERT INTO uro_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Dap toqoräkt dä ama guläñgi na ama ruvek kärarhani i sa qale rha rhi na qa rhoqoräkt i qa mes ma Lasarus nämät ama liqi näkt ka märanas na qa nämät ama tñäpki di qoki as tit präs dä ama enge sävät iarhongäkt. ");
INSERT INTO uro_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Bä ama ruvek ama rhäqäp na rha di rha met sae ivakt iva rhi lu qa inguna rha nari i sa qa mualat nä iaqyäkt ama muqunängi ama nañis ki. ");
INSERT INTO uro_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Bä nga rhoqoräkt dä ama Farisiqäna rha qoar na ne rhoqortäqyia, “As ngäni lu i aiut di qaku ut täqäne dä mamär nä guani. As ngäni lu i sa ama ruvek moe di sa rha met nasot a qa!” ");
INSERT INTO uro_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Sa rhoqoräkt di arhani ama Jentailqäna di rha e mänguräp iarhakt kärarhae i sa rha met ivakt iva rhi ansäs pa ama tmäski ma Pasova. ");
INSERT INTO uro_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Dä rha met sage ma Filip iaqäkt kärak i qa näva ama värhäm ama lel äm ma Betsaida e ma Galili sa ama nän i rha qoar na qa rhoqortäqyia, “Morqa, nani a ut iva urhi lu ma Jisas.” ");
INSERT INTO uro_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Dä sa ma Filip ka met bä qa qoar nä ma Andru bä in met na äkt bä in goar nä ma Jisas. ");
INSERT INTO uro_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Dä ma Jisas ka muvät pät a iom doqortäqyia, “Sa ama qäväläm ngä män iva ma Ruqa aa Emga diva rhi sek sa aa ngärhipki. ");
INSERT INTO uro_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nguat tamän särhäm ngän na ama engäktki i ngakt bä nga qaku anga wit aa gavämini ngä säp sävät ivät bä ini ngärhi ñäp diva qale ianiäkt ama gavämini i ama sägäni nä ini. Dap ngakt bä ini ngärhi ñäp dä va ini ngärhi sa ama rhäqäp nä irhong ama gavämirhong. ");
INSERT INTO uro_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Aung gärakni i aa snäng bät aa iar diva qa rhusäng sä ngät nasot dap iaqäkt kärak i qaku aa snäng bät aa iar mäni rhakt täkt ama ivätki diva qä sangar a ngät bä va ngä rhän i ama iar ama sok täm ngät. ");
INSERT INTO uro_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Näkt iaqäkt kärak i qat tualat ba ngo di mamär iva qät päs gua rhäng bä äkt i qoe nai i qale ngo e di äkt di qosaqi gua latka diva qale qa e. Bä auge qärak i qat tualat bä ba ngo diva gu mamäk kät kutdrir sävät a qa. ");
INSERT INTO uro_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Rhäkt di vät gu snängaqa di qänäskänes ngo dä sa va ngu qoar toqor mäniekt? ‘Mam, sa ngia rhumaiar ngo nämät tom däkt ama qäväläm’? Sokt di sirhäkt kaku inguna ama rharimini qärqäni i sa ngua män di varhäm dom däkt. ");
INSERT INTO uro_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mam, mamär iva ngi sek sä gi ngärhipki!” Bä nga nasot iangärhäkt aa enge dä ama eguinga qa män näda ama usäpki arha ron i qat tamän doqortäqyia, “Sa ngua sek sä qi näkt saqi as pa ngu sek sä qi.” ");
INSERT INTO uro_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Dä ama guläñgi na ama ruvek kärarhani i qale rha e bä rha nari rhoqoräkt di rha qoar i iaqäkt ama eguinga di ama iauska qärakni i vukpukdur väm ga dap arhani di rha qoar i sa ama ensel qa märhamän särhäm ga. ");
INSERT INTO uro_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Dä sa ma Jisas ka muvät i qä qoar na rha rhoqortäqyia, “Rhak täkt ama eguinga di qaku ba ngo dap iaqäkt diva bä ba ngän. ");
INSERT INTO uro_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sa rhäkt di ama qäväläm gärqomni iva ama matnävämne ngä rhän bät takt täkt ama ivätki bä rhäkt di ama narhoerqa nämäni rhakt täkt ama ivätki diva rhi qutmäs a qa nae. ");
INSERT INTO uro_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Dap ngo di ngakt bä rhi sek mä ngo rhävit nävät ivät dä va ngu artäm sa ama ruvek moe sagem mes.” ");
INSERT INTO uro_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Sa qa märhamän doqoräkt ivakt iva qä qur a rha iva qä ñäp toqoräkt. ");
INSERT INTO uro_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Bä qä guläñgi na ama ruvek ta muvät toqortäqyia, “Sa ut nari i ama Muräkt di ngärhi qoar i ma Krais diva qale qa mas dap mäniekt bä ngi qoar toqortäqyia, ‘Ma Ruqa aa Emga diva qoki rhi sek mä qa rhävit’? Ngu lu auge rhak täkt kärak i qa di ma Ruqa aa Emga?” ");
INSERT INTO uro_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Ama neraqa diva as kale qa gem ngän bät ama qäväläm ama uiu äm maqälak nak kop. Dap mamär iva ngän det da ama neraqa rhoqoräkt i as kale ama neraqa gem ngän inguna nasot dä va bängangit pät a ngän. Ama ruqa qärakni i qat tet pät bängangit angät tpäs di qaku qat dräm i qat tet koe nai. ");
INSERT INTO uro_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mamär iva ngänät nanakt na ama neraqa rhoqoräkt i as kale qa gem ngän ivakt iva ngän dän i ama neraqa aa es na ngän.” Bä nga rhoqoräkt i sa ma Jisas ka märhamän bät tangät täkt bä rhäksot dä qa met bä qa ngaip nas nämät ta. ");
INSERT INTO uro_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Näkt nasot toqoräkt i sa ma Jisas ka mualat nä iangärhäkt ama muqunän ama nañis ngät mänguräp mä rha dä qoki as ta di qaku rhat nanakt na qa. ");
INSERT INTO uro_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bä iangärhäkt divakt iva rhäkmamär varhäm ma Ngämuqa aa vämginaqa ma Aisaia aa enge qärangätni i ngät tamän doqortäqyia, “Engeska, sa ngu lu auge qat nanakt na aut sameng bä qosaqi auge qärak i sa qa lu mamär nä ma Engeska aa qrot?” ");
INSERT INTO uro_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bä ama rharimini qärqäni i sa qaku rhat nanakt dinguna qosaqi angätni ma Aisaia aa enge ngät tamän doqortäqyia, ");
INSERT INTO uro_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Sa qa väsdät mät arhä saqong dä qa mualat sä rha iva ama qrot arhä väs ivakt iva qaku mamär iva rhat nañäm na arhä saqong dä va qaku mamär iva qunäga vät a rha mät arhä mädräm bä qop pa qaku mamär vät a rha iva rhi rhong sävät a ngo ivakt iva ngua rhumäräs pät a rha.” ");
INSERT INTO uro_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ma Aisaia qa märhamän doqoräkt inguna sa qa lu ma Jisas aa murhämeska bä qa sameng sävät a qa. ");
INSERT INTO uro_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Dap toqoräkt di qoki ama rhäqäp na rha nä mänguräp ama narhoerta di rhat nanakt na qa. Sokt dinguna nävät ama Farisiqäna dä qaku rhi nasameng irha arhä qatnanakt inguna rhit len i varis ti naqutmäs a rha näva ama mämairqi ");
INSERT INTO uro_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","inguna nani a rha na ama ansäs masirhat nage ama ruvek dap kaku nani a rha na ama ansäs nage ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Dä ma Jisas ka märhamän masirhat toqortäqyia, “Auge qärak i qat nanakt na ngo di qaku sokt kat nanakt na ngo dap kosaqi qat nanakt nä iaqäkt kärak i qa rhäk na ngo. ");
INSERT INTO uro_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Bä iaqäkt kärak i sa qa lu ngo di qosaqi sa qa lu iaqäkt kärak i qa rhäk na ngo. ");
INSERT INTO uro_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Sa ngua män sämäni ama ivätki i ama neraqa na ngo ivakt iva aung gärakni i qat nanakt na ngo diva qaku qale qa vät bängangit angät tpäs. ");
INSERT INTO uro_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Dap auge qärak i qat nari gua enge sokt di qaku qat tet parhäm ngät diva qaku ngo ngu namatnävämne na qa. Inguna sa qaku ngua män ivakt iva ngua rhatnävämne na ama ruvek dap ngua män divakt iva ngua rhumaiar ta. ");
INSERT INTO uro_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Sa akni di qa e qärakni iva qat tatnävämne nä iaqäkt kärak i qät kyiradeng na ngo dä qaku qat tat maengäkt sä gua enge. Bä iangärhäkt ama enge qärangätni i sa ngua märhamän bät a ngät diva ngä rhatnävämne na qa vät ama dängdängini na qa ama qunäga. ");
INSERT INTO uro_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Inguna sa qaku ngua märhamän nävät gu mädräm maräkt dap ama Ngätmamäk kärakni i qa rhäk na ngo sa qa qoar na ngo nä qärangätni ama enge iva ngua rhamän bät a ngät bä va ngua rhamän bät a ngät toqoräkt. ");
INSERT INTO uro_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Bä nguat dräm i iangärhäkt aa rhäkne di ngärhit bon da ama iar ama sok täm ngät. Bä äkt i sa agini qärqäni i nguat tamän bät ini di ianiäkt di qärqäni ianiäkt i sa ama Ngätmamäk ka qoar na ngo iva ngua rhamän bät ini.” ");
INSERT INTO uro_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Näkt toqoräkt di sa qorhäs mamär na ama qäväläm gärqomni iva ama tmäski ma Pasova bä ma Jisas di qat dräm i sa ama qäväläm ngä män iva qa rhet daqule rhakt täkt ama ivätki bä sage ama Ngätmamäk. Sa nguna aa snäng bät aa ruvek pät ama ivätki qärarhani i sa qa ernanas täm da dä aa snäng bät a rha mamär. ");
INSERT INTO uro_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Bä nga rhoqoräkt i rhat täs säpbängang dä nak sa ma Sämga qa mu ama snängaqa dä ma Judas Iskariot ma Saimon aa emga aa ron iva qä vodä ma Jisas bä ba aa ikkäna. ");
INSERT INTO uro_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ma Jisas di qat dräm i sa ama Ngätmamäk ka mu iarhongäkt moe va aa rhäkt bä qosaqi qat dräm i qa di sa qa män nage ma Ngämuqa dä va qa diva evär däm ga sage ma Ngämuqa ");
INSERT INTO uro_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Bä äkt i nga rhoqoräkt dä qa märanas nagem da qärarhani i rhat täs bä qa mu aa boiqi ama uiu qi rhämone näkt ka qop mäni nas na ama boiqi qäraktni i rhat dräm di suqup pät a nas na qi. ");
INSERT INTO uro_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Näkt nasot toqoräkt dä sa qa rhor na ama rigi sämät ama luska bä qa nasäng i qät tor aa mudäsaqongda arha qar näkt kä suqup pät a ngät nä iaqyäkt ama boiqi qärakt i sa qa qop ki mäni nas. ");
INSERT INTO uro_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Sa qät tor arha qar bä sävät ma Saimon Pita iaqäkt kärak i qa snanbät sä ma Jisas toqortäqyia, “Engeska, nga ngiat tu gi snäng iva ngi rhor gua qar?” ");
INSERT INTO uro_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “As kaku qunäga vät a nge rhäkt sa agini qärqäni i nguat tualat nä ini dap pa nasot dä va qunäga vät a nge.” ");
INSERT INTO uro_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Dä sa ma Pita qa qoar na qa rhoqortäqyia, “Qale, qaku mamär iva ngi narhor gua qar.” Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Ngakt bä nga qaku ngu narhor gia qar dä va qaku rhäm nge nämäni ngo.” ");
INSERT INTO uro_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Dä ma Saimon Pita qa muvät pät a qa rhoqortäqyia, “Qaku sokt gua qar dap kosaqi ngua rhäkt ngä nä ngua väski!” ");
INSERT INTO uro_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Dä sa ma Jisas ka qoar na qa rhoqortäqyia, “Ama ruqa qärakni i sa qa rhor nas mamär di qaku qät läk iva qä lir qä rhor nas inguna aa släqyige moe di ama qumärqumär ige dap sokt kät läk iva qä rhor aa qar. Bä ngän di ama qumärqumärta na ngän sokt di qaku ngän moe.” ");
INSERT INTO uro_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Sa qa märhamän doqoräkt dinguna qat dräm i iaqäkt kärak iva qä vodäm ga bä ba aa ikkäna bä äkt i qa qoar i qaku rha moe di ama qumärqumär ta. ");
INSERT INTO uro_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Näkt nga rhoqoräkt i qa rhor arha qar bä rhäksot dä saqi qa mon mät aa boiqi ama uiu qi näkt evär däm ga sa äkt i mai qat muqun e. Näkt ka snanbät sä rha rhoqortäqyia, “Nga qunäga vät a ngän sa ama rharimini qärqäni i sa ngua mualat sä ngän di rhoqoräkt?” ");
INSERT INTO uro_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Bä ngän des ngo i Qamorqa dä Engeska di ngäktki rhoqoräkt i ngän damän doqoräkt inguna aingo di ngo rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Bä äkt i nga rhoqor täkt i angäna Engeska dä angän gamorqa na ngo dä sa ngua rhor angäna qar bä va ngän di mamär iva qosaqi ngänit tor angäna qar qane. ");
INSERT INTO uro_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Sa ngua mualat sä ngän doqoräkt di sa ngur qur a ngän iva ngän dualat toqoräkt. Bä mamär iva qosaqi ngän dualat toqor ngo. ");
INSERT INTO uro_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Näkt nguat tamän särhäm ngän na ama engäktki i sa qaku anga latka qa vit pa aa morqa aa uväs bä qosaqi anga ngangga di qaku qa vit pa iaqäkt kärak aa uväs i sa qa rhäk na qa. ");
INSERT INTO uro_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ngakt bä qunäga vät a ngän sä rhangät täkt dä sa va ama modämne sävät a ngän gre i ngän dualat na ngät. ");
INSERT INTO uro_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Sa nguat tamän doqoräkt di qaku sävät a ngän moe inguna nguat dräm iarhakt kärarhae i sa ngua armeng däm da. Dap toqoräkt i ngua qoar i akni diva qä vodäm ngo bä bä gua ikkäna diva rhäkmamär varhäm ma Ngämuqa aa enge qärangätni i ngät tamän doqortäqyia, ‘Iaqäkt kärak i qat täs gu bret di sa qa rhong mes na ngo.’ ");
INSERT INTO uro_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Bä va narhäkt diva nguat tamän särhäm ngän narhoer na agi a lat kärangätni iva ngä rhän ivakt iva qre i sa ngä män dä va ngänät nanakt i aingo di iaqäkt. ");
INSERT INTO uro_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Bä nguat tamän särhäm ngän na ama engäktki mamär i auge qärak i qä rhar sa akni qärak i sa ngua rhäk na qa di qä rhar sä ngo bä qosaqi iaqäkt kärak i qä rhar sä ngo di qä rhar sä iaqäkt kärak i sa qa rhäk na ngo sarhe.” ");
INSERT INTO uro_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Näkt nga nasot i ma Jisas ka märhamän doqoräkt dä sa rhäqäp ka na ama qänäskänes bä qa qoar na rha rhoqortäqyia, “Nak nguat tamän särhäm ngän na ama engäktki i akni nävät a ngän diva qä vodäm ngo bä gua ikkäna.” ");
INSERT INTO uro_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Bä nga rhoqoräkt dä sa aa mudäsaqongda rhi nasäng i rhit ñäm sävät a ne i qaku rhat dräm i qat tamän sävät auge mamär nävät a rha. ");
INSERT INTO uro_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Näkt akni nävät ama mudäsaqongda qärakni i ma Jisas aa snäng bät a qa mamär di sa qat muqun glaqot na qa. ");
INSERT INTO uro_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Bä äkt i sa ma Saimon Pita qa siqutmät sävät iaqäkt ama mudäsaqongga bä qa qoar na qa iva qä snanbät sä ma Jisas i rhoqoräkt di qat tamän sävät auge. ");
INSERT INTO uro_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Dä sa qä mudäsaqongga qa angär sävät ma Jisas näkt ka snanbät sä qa rhoqortäqyia, “Engeska, ngu lu auge iaqäkt?” ");
INSERT INTO uro_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Dä ma Jisas ka muvät toqortäqyia, “Iaqäkt di qärak iva ngu rha ama bretige bä ngu rhäk ige sämät ama dis näkt pa ngu von ga.” Bä nga rhoqoräkt i sa qa rhäk ama bretige dä qa von ma Judas Iskariot ma Saimon aa emga. ");
INSERT INTO uro_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Bä nga rhoqoräkt i sa ma Judas ka rha ama bretige dä ma Sämga qa mon sämät ka. Näkt ma Jisas ka qoar na qa rhoqortäqyia, “Ianiäkt kärqäni iva ngia rhualat nä ini di ngi lir ngia rhualat nä ini.” ");
INSERT INTO uro_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Sokt di qaku aung bät ama laiqa aa rhäkt di qunäga vät a qa i mäniekt bä ma Jisas ka qoar na qa rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bä arhani di rha mu arhä snäng i ma Jisas kat tamän särhä ma Judas iva qä vodäm bät guarhong gärqärhongni i rhit läk nani irhong ba ama tmäski ura va sa qa von da rhä guani bä ba ama tläkta inguna qa di qat dräm gät lu vät ama ligär. ");
INSERT INTO uro_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Näkt nga rhoqoräkt i sa ma Judas ka rha ama bretige dä qop puk sä qa masägos sä dalek. Sa rhoqoräkt di sa bängagi. ");
INSERT INTO uro_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Bä nga rhoqoräkt i sa ma Judas ka met dä ma Jisas ka qoar toqortäqyia, “Sa rhäkt di ma Ngämuqa qät sek sä ma Ruqa aa Emga aa ngärhipki. Bä nävät a qa di rhit sek sä ma Ngämuqa aa ngärhipki. ");
INSERT INTO uro_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Näkt ngakt bä nävät ma Ruqa aa Emga aa lat di rhit sek sä ma Ngämuqa aa ngärhipki dä va qosaqi ma Ngämuqa maräkt kät sek sä iaqäkt bä va qa rhualat toqoräkt masägos.” ");
INSERT INTO uro_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Dä saqi as ka qoar na rha rhoqortäqyia, “Ngua es, pa qaku qale ngo mauiu ngu na ngän. Bä va ngänit ñäm nani a ngo sokt di nguat tamän särhäm ngän däkt di qoki rhoqor ama Judaqäna qärarhani i sa ngua qoar na rha rhoqortäqyia, ‘Äkt iva ngua rhet sae di qaku mamär iva ngän namet sae.’ ");
INSERT INTO uro_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Näkt ama iaräs na ngät ama muräkt iva ngu von ngän däm ngät di ngät tamän doqortäqyia, ‘Angäna snäng bät a ne. Sa mamär iva angäna snäng bät a ne rhoqor ngo i sa gua snäng bät a ngän.’ ");
INSERT INTO uro_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ngakt bä angäna snäng bät a ne diva rhoqoräkt dä va ama ruvek tat dräm i ngän di gu mudäsaqongda na ngän.” ");
INSERT INTO uro_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Dä ma Saimon Pita qa snanbät sä qa rhoqortäqyia, “Engeska, ngu lu va ngia rhet sa qoe?” Dä ma Jisas ka muvät toqortäqyia, “Äkt iva ngua rhet sae di qaku mamär iva rhäkt di ngi namet nasot a ngo sae dap pa nasot dä va dängdäng na nge sae.” ");
INSERT INTO uro_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Dä ma Pita qa snanbät toqortäqyia, “Engeska, ngu lu mäniekt bä qaku mamär iva ngu namet nasot a nge rhäkt? Aingo diva ngu ñäp iva ngua rhatnärhäm nge.” ");
INSERT INTO uro_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Bä äkt i ma Jisas ka muvät toqortäqyia, “Nga ngäktki iva ngi ñäp toqoräkt? Nak nguat tamän särhäm nge na ama engäktki i as toqoräkt i qaku ama duräktka qa nok dä va ngi rhäqyas na ngo madäpguamek!” ");
INSERT INTO uro_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Näkt kosaqi ma Jisas ka qoar na rha rhoqortäqyia, “Sa varis äkt bä qänäskänes ngän inguna ngänät nanakt nä ma Ngämuqa dä qosaqi ngänät nanakt na ngo. ");
INSERT INTO uro_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Sa vä gu mam aa vätka di ama rhäqäp na ap ama qävälap kärqapni iva qale ngän bä bap. Näkt nga vadi mai sa qaku rhoqoräkt di sa vadi mai ngua qoar na ngän. Bä ngo di nguat tet sae ivakt iva ngu rhäkmu na ap bä ba ngän. ");
INSERT INTO uro_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Näkt ngakt bä ngua rhet bä ngu rhäkmu na ama qävälap bä ba ngän dä sa va evär däm ngo bä va ngu rha ngän sagem mes ivakt iva qale ngän ngän na ngo äkt i qale ngo e. ");
INSERT INTO uro_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Aingän di sa ngänät dräm ama iska sävä iosäkt ama ivärhäs kärqos i nguat tet sae.” ");
INSERT INTO uro_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Dä sa ma Tomas ka snanbät toqortäqyia, “Engeska, sa qaku ut dräm i ngiat tet sa qoe nai bä äkt i ngu lu va urhi räm ama iska sae rhoqor mäniekt?” ");
INSERT INTO uro_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Aingo di ama iska bä ama engäktki bä ama iar. Sa qaku aung gä namet sage ama Ngätmamäk näva aung anga iska dap sokt nävät a ngo. ");
INSERT INTO uro_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Vadi mai sa ngänät dräm a ngo mamär di qosaqi vadi mai ngänät dräm gu mamäk. Bä va narhäkt bä rhävit dä sa ngänät dräm a qa bä sa ngän lu qa.” ");
INSERT INTO uro_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Dä ma Filip ka qoar na qa rhoqortäqyia, “Engeska, ngi qur a ut ta ama Ngätmamäk. Ngakt bä nga rhoqoräkt diva mamär na ut.” ");
INSERT INTO uro_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Dä ma Jisas ka snanbät sä qa rhoqortäqyia, “Filip, nak sa qale ngo mänguräp mä ngän bät ama qäväläm ama uiu äm näkt nga as kaku ngiat dräm a ngo? Sa iaqäkt kärak i qa lu ngo di sa qa lu ama Ngätmamäk. Ngu lu mäniekt bä ngi qoar toqortäqyia, ‘Ngi qur a ut ta ama Ngätmamäk’? ");
INSERT INTO uro_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nga qaku ngiat nanakt i ngo di ngua e va ama Ngätmamäk dä ama Ngätmamäk di qa e väm ngo? Ama enge kärangätni i nguat tamän bät a ngät bä ba ngän di qaku sokt ngät nagem ngo. Dap kinak iaqäkt ama Ngätmamäk kärak i qale qa väm ngo di sa qat tualat na aa lat. ");
INSERT INTO uro_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","“Bä mamär iva ngänät nanakt na ngo rhoqoräkt i nguat tamän i aingo di ngua e va ama Ngätmamäk dap ka di qa e väm ngo ura ngakt bä qaku dä mamär iva ngänät nanakt na ngo nävät ama lat kärangätni i nguat tualat na ngät. ");
INSERT INTO uro_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Näkt nguat tamän särhäm ngän na ama engäktki i iaqäkt kärak i qat nanakt na ngo diva qat tualat nä iarhongäkt kärqärhong i sa nguat tualat nä irhong. Bä va qa di qat tualat na ama moräsnirhong bät tärhong däkt angät tpäs inguna nguat tet sage ama Ngätmamäk. ");
INSERT INTO uro_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Bä va ngua rhualat na agini qärqäni i ngäni nän ngo rhäm ini nävät gu ngärhipki ivakt iva ama Ngätmamäk kä rha ama murhämeska nävät ama Ngärhoemga. ");
INSERT INTO uro_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Näkt ngakt bä ngäni nän ngo nani guani nävät gu ngärhipki dä sa va ngua rhualat nä ini.” ");
INSERT INTO uro_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Näkt kosaqi ma Jisas ka qoar toqortäqyia, “Ngakt bä angäna snäng bät a ngo dä va ngän det parhäm gu muräkt. ");
INSERT INTO uro_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Bä va ngu nän ama Ngätmamäk dä va qä von ngän da akni ama ruqa qärakni iva qat tatnärhäm ngän bä va qale qa mas kä na ngän. ");
INSERT INTO uro_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iaqäkt ama ruqa di ama Qloqaqa na ama engäktki. Bä ama ruvek nävät ama ivätki diva qaku mamär vät a rha iva rhi narha qa inguna qaku rhat lu qa bä qosaqi qaku rhat dräm a qa. Dap ngän di sa ngänät dräm a qa inguna sa qale qa qä na ngän bä va qale qa väm ngän. ");
INSERT INTO uro_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Näkt pa qaku ngu namet daqule ngän i ngän doqor ama säbotta dap saqi as pa evär däm ngo sagem ngän. ");
INSERT INTO uro_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Bä vät ama qäväläm ama qot äm dä va ama ruvek nävät ama ivätki di saqi as pa qaku rhi nalu ngo dap ngän diva ngäni lu ngo. Näkt nguna äkt i sa nguat däqäm dä va ngän di qosaqi va ngänät däqäm. ");
INSERT INTO uro_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Näkt pät iomäkt ama qäväläm dä va qunäga vät a ngän mamär i ngo di ngua e vä gu mamäk dap ngän di ngän nae väm ngo bä ngo di ngua e väm ngän. ");
INSERT INTO uro_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Aung gärakni i qat sangar sävät gu muräkt bä qat tet parhäm ngät di iaqäkt di qärak i aa snäng bät a ngo. Näkt iaqäkt kärak i aa snäng bät a ngo diva gu mamäk aa snäng bät a qa bä qosaqi ngo diva gua snäng bät a qa bä va ngu qur a qa rhäm mes.” ");
INSERT INTO uro_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Dä ma Judas kärakni i qaku ma Judas Iskariot na qa qa qoar toqortäqyia, “Engeska, ngu lu mäniekt bä va ngi qur a ut täm mes dap kaku rha ama ruvek nävät ama ivätki?” ");
INSERT INTO uro_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Dä ma Jisas ka muvät pät a qa i qä qoar toqortäqyia, “Bä aung gärakni i aa snäng bät a ngo diva qat tet parhäm gu rhisu. Bä va gu mamäk diva aa snäng bät a qa dä va un dän sagem ga bä va qali lun e väm ga. ");
INSERT INTO uro_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Dap iaqäkt kärak i qaku aa snäng bät a ngo diva qaku qat tet parhäm gu rhisu. Näkt tangät täkt ama enge qärangätni i sa ngänät nari ngät nämät ngo di qaku gua enge dap kinak ama Ngätmamäk kärakni i sa qa rhäk na ngo aa enge iangärhäkt. ");
INSERT INTO uro_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Bä rhangät täkt ama enge moe di sa ngua märhamän bät a ngät as toqoräkt i qale ngo ngu na ngän. ");
INSERT INTO uro_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Sokt di ama ruqa qärakni iva qat tatnärhäm ngän di ama Qloqaqa ama Qumärqumärqa qärak i ama Ngätmamäk pa qä rhäk na qa nävät gu ngärhipki diva qä su ngän dä iarhongäkt moe dä va qät puk pät a ngän nä iarhongäkt moekt kärqärhong i sa ngua qoar na ngän nä irhong. ");
INSERT INTO uro_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ama bulap di nguat tet daqule ngät gem ngän bä iangärhäkt gu bulap di ngut bon ngän däm ngät. Näkt sa qaku nguat dräm ngut bon ngän däm ngät toqor ama ruvek nävät ama ivätki qärarhani i rhat dräm dit bon. Dap kale qänäskänes ngän dä qale ngänit len. ");
INSERT INTO uro_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Sa ngän nari ngo i ngua qoar toqortäqyia, ‘Nguat tet daqule ngän näkt saqi va evär däm ngo sagem ngän.’ Näkt ngakt bä sa angäna snäng bät a ngo dä vadi mai märmär gem ngän iva nguat tet sage ama Ngätmamäk inguna qa di ama moräs na qa masirhat pä ngua väs. ");
INSERT INTO uro_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","“Sa ngua märhamän särhäm ngän narhoer nä rhangät täkt iva ngä rhän ivakt iva ngakt bä sa ngät dän dä va ngänät nanakt. ");
INSERT INTO uro_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Näkt sa qaku ngu natmärhamän särhäm ne ngu na ngän mauiu inguna ama tpäskinaqa nämäni rhakt täkt ama ivätki di sa iak kat dän. Bä qa di nak kaku aa anga qrot iva qa rhualat nä guani qärqäni iva qa rhäqäne dä mamär na ngo nä ini. ");
INSERT INTO uro_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Sokt di nguat tualat maräkt parhäm iarhongäkt kärqärhong i sa ma Ngämuqa qa qoar na ngo iva ngua rhualat nä irhong ivakt iva ama ruvek nävät ama ivätki di mamär vät a rha iva qunäga vät a rha i gua snäng bät a qa. “Ngän däranas bä u rhet narhäkt.” ");
INSERT INTO uro_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Näkt kosaqi ma Jisas ka qoar na rha rhoqortäqyia, “Aingo di ama qaulige na ama wain ama engäktki nä ige dap gu mamäk di iaqäkt kärak i qät lu vät ama qauligleng nävät ama etki. ");
INSERT INTO uro_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Sa qät dodäkt sa ama ngärhäqyitnäk moe nae nämäni ngo qärqitnäkni i qaku itnäk ngärhit sa anga gavam dap sa qä qumär vät ama ngärhäqyitnäk moe qärqitnäkni i itnäk ngärhit sa ama gavam ivakt iva itnäk ngärhit sa masirhat. ");
INSERT INTO uro_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Bä aingän di sa ama qumärqumärta na ngän inguna nävät gua enge qärangätni i sa ngua märhamän särhäm ngän na ngät. ");
INSERT INTO uro_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","“Näkt kale ngän basägos mäni ngo dä sa va qale ngo vasägos mäni ngän. Inguna qaku anga ngärhäqyit ngä nasa anga gavam gop äkt mavängam gre i qali lit mät släqyäs dap koki mamär iva qali lit pasägos mäni ama qaulige. Bä äkt i qaku mamär vät a ngän iva ngäni sa anga gavam gre i qaku qale ngän basägos mäni ngo. ");
INSERT INTO uro_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Aingo di ama qaulige na ngo dap aingän di ama ngärhäqyitnäk na ngän. Näkt ngakt bä qale anga ruqa vasägos mäni ngo bä ngo di qale ngo mäni qa dä sa va qät sa ama gavam masirhat inguna ngakt bä qaku qale ngän mäni ngo diva qaku mamär iva ngä namualat nä guani. ");
INSERT INTO uro_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ngakt bä aung anga ruqa di qaku qale qa vasägos mäni ngo di qa rhoqor ama ngärhäqyit kärqitni i sa rha rhon na it bä qek dä bit näkt sa iatnäqäkt ama ngärhäqyitnäk toqoräkt di rhat tat mä itnäk bä rhit don nä itnäk sämät ama mudam bä itnäk ngät dang. ");
INSERT INTO uro_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Dap ngakt bä qale ngän basägos mäni ngo dä gua enge di qale ngät gem ngän basägos dä mamär iva ngäni nän da agini qärqäni i nani a ngän nä ini dä sa va ma Ngämuqa qa rhualat nä ini. ");
INSERT INTO uro_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Va ngänit bon gu mamäk ta ama murhämeska qre i ngänit sa ama gavam masirhat bä rhoqor täkt di ngänir qur ama ruvek i ngän di gu mudäsaqongda na ngän. ");
INSERT INTO uro_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Qoki rhoqor ama Ngätmamäk i aa snäng bät a ngo dä qosaqi ngo di gua snäng bät a ngän. Sa rhäkt diva qale ngän basägos mäni gu lavuqi. ");
INSERT INTO uro_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Näkt ngakt bä ngän det parhäm gua enge diva qale ngän basägos mäni gu lavuqi nak kop toqor ngo i nguat tet parhäm gu mamäk aa enge dä sa qale ngo vasägos mäni aa lavuqi. ");
INSERT INTO uro_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Bä sa ngua qoar na ngän nä rhärhong däkt divakt iva gu märmärgem diva qale ngät gem ngän bä va ngän di märmär gem ngän masirhat. ");
INSERT INTO uro_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Näkt ngu qoar na ngän iva angäna snäng bät a ne i qoki rhoqor ngo i gua snäng bät a ngän. ");
INSERT INTO uro_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ama ruqa aa lavuqi di ama enges ki masirhat mamär qrekt i qät boda aa iar iva bä ba aa ruavek. ");
INSERT INTO uro_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Bä aingän di gua ruavek na ngän gre i ngän det parhäm gua enge. ");
INSERT INTO uro_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","“Näkt sa va qaku ngu natmes ngän i ama latta na ngän gärarhani i qale rha vä gua rem inguna ama latka rhoqoräkt di qaku qat dräm aa morqa aa qärhong. Dap sa ngua mes ngän i gua ruavek na ngän inguna iarhongäkt moekt nage gu mamäk kärqärhong i ngua räm irhong di sa ngua muqunäga vät a ngän sä irhong. ");
INSERT INTO uro_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Bä qaku ngän narmeng däm ngo dap aingo ngua armeng däm ngän näkt ngua muqunän bät a ngän ivakt iva ngän det bä ngänit sa ama gavam bä va iangärhäkt ama gavam diva qale ngät mas. Bä nga rhoqoräkt dä ama Ngätmamäk pa qä von ngän da agini qärqäni i ngäni nän däm ini nävät gu ngärhipki. ");
INSERT INTO uro_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Näkt tangät täk gua enge bä ba ngän divakt iva angäna snäng bät a ne.” ");
INSERT INTO uro_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Näkt kosaqi ma Jisas ka qoar na rha rhoqortäqyia, “Ngakt bä ama ruvek nävät ama ivätki di ama vu da arha ron sävät a ngän dä mamär iva qunäga vät a ngän i aingo di ama vu da arha ron sävät a ngo narhoer. ");
INSERT INTO uro_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ngakt bä ngän di nak nämäni ama ivätki mamär dä ama ruvek nävät ama ivätki diva arhä snäng bät a ngän. Sokt di sa ngua armeng däm ngän nämäni ama ivätki bä rhäkt di qaku ngän nämäni qi bä nävät tom däkt dä ama vu da arha ron mamär sävät a ngän. ");
INSERT INTO uro_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mamär iva ngän du angän snäng sävät gua enge qärangätni i sa ngua qoar na ngän doqortäqyia, ‘Qaku anga latka di qa vit pa aa morqa aa uväs.’ Ngakt bä rha sangäm na ngo dä va qosaqi rhi sangäm na ngän. Dap ngakt bä rhat tet parhäm gua enge dä va qosaqi rhat tet parhäm angäna enge. ");
INSERT INTO uro_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","“Bä va rhat tualat sä ngän doqoräkt dinguna nävät gu ngärhipki inguna qaku rhat dräm iaqäkt kärak i qa rhäk na ngo. ");
INSERT INTO uro_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ngakt bä vadi mai qaku ngua män bä ngua märhamän särhäm da dä vadi mai qaku ma Ngämuqa qä narhäksärhäm da sa arha vuirhong. Dap täkt di sa qale rha va arha vuirhong angät täksärhäm angärha rem. ");
INSERT INTO uro_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","“Bä auge qärak i ama vu da aa ron sävät a ngo di qa di qosaqi ama vu da aa ron sävät gu mamäk. ");
INSERT INTO uro_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Näkt ngakt bä vadi mai qaku ngua mualat mänguräp mä rha nä iangärhäkt ama lat kärangät i qaku mamär vät aung iva qä namualat nä ngät dä vadi mai qaku ma Ngämuqa qä narhäksärhäm da sa arha vuirhong. Dap täkt di sa rha lu iangärhäkt ama lat dä sa ama vu da arha ron sävät a ngo bä qosaqi sävät gu mam. ");
INSERT INTO uro_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Sokt di qoki rha mualat toqoräkt ivakt iva sa rhäkmamär ta ama enge qärangätni i sa rha säm a ngät pa arhä muräkt kärangätni i ngät tamän doqortäqyia, ‘Sa ama vu da arha ron sävät a ngo mavängam dap kaku vät guani angät tpäs.’ ");
INSERT INTO uro_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Bä nga rhoqoräkt i ama ruqa qärakni i qat tatnärhäm ngän ba qa rhän iaqäkt kärak iva ngu rhäk na qa sagem ngän nage ama Ngätmamäk kärak i ama Qloqaqa na ama engäktki qärak i qat dän nage ama Ngätmamäk dä sa va qä sameng sävät a ngo. ");
INSERT INTO uro_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Bä ngän diva qosaqi ngäni sameng sävät a ngo inguna sa qale ngän ngän na ngo nävät ama rharimini.” ");
INSERT INTO uro_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Näkt tärhong däkt moekt kärqärhong i sa ngua qoar na ngän nä irhong divakt iva qale arharpus na ngän. ");
INSERT INTO uro_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Va rhi qutmäs a ngän näva ama mämairväm näkt ama qäväläm diva qäqi äm ngä rhän gärqomni iva aung gärakni i qä veng ngän diva qat tu aa snäng i qat tualat na ama märini bä bä ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bä va rhat tualat nä rhärhong däkt inguna sa qaku rhat dräm ama Ngätmamäk bä qosaqi qaku rhat dräm a ngo. ");
INSERT INTO uro_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Näkt sa ngua qoar na ngän nä rhärhong däkt divakt iva ngakt bä iomäkt ama qäväläm ngä rhän bät a ngän dä va vuk pät a ngän nä gua enge. “Dap kaku ngua qoar na ngän nä rhärhong däkt pät ama rharimini inguna qale ngo gem ngän. ");
INSERT INTO uro_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Sokt di rhäkt diva nguat tet sage iaqäkt kärak i qa rhäk na ngo sokt di qop kaku aung nävät a ngän gä snanbät sä ngo rhoqortäqyia, ‘Ngu lu va ngia rhet sa qoe?’ ");
INSERT INTO uro_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Dap täqäp ngän na ama iräski inguna sa ngua qoar na ngän nä rhärhong däkt. ");
INSERT INTO uro_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Sokt di nguat tamän särhäm ngän na ama engäktki rhoqortäqyia, va ama märini ngä rhän bä ba ngän gre iva ngua rhet daqule ngän. Inguna ngakt bä qaku ngu namet daqule ngän dä ama ruqa qärakni i qat tatnärhäm ngän diva qaku qä namän sagem ngän. ");
INSERT INTO uro_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Näkt toqoräkt iva qa rhän dä va qär qur ama ruvek nävät ama ivätki i agi arha lat di ama vu ngät dä agi arha lat di ama räkt ngät dä ma Ngämuqa aa saqong bä sävät ma Ngämuqa aa matnävämne qärangätni iva ngä rhän. ");
INSERT INTO uro_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Dä va qär qur ama ruvek sävät arha vuirhong inguna ama ruvek di qaku rhat nanakt na ngo. ");
INSERT INTO uro_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Dä va qosaqi iaqäkt ama ruqa qärak i qat tatnärhäm ngän ba qär qur ama ruvek sävät ama räkt ngät ama lat inguna va ngua rhet sage ama Ngätmamäk bä saqi as pa qaku ngän nalu ngo. ");
INSERT INTO uro_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","“Näkt pa qär qur ama ruvek sävät ama matnävämne inguna ama tpäskinaqa nämäni rhakt täkt ama ivätki di sa qale qa da ama matnävämne angärha ron. ");
INSERT INTO uro_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Näkt as masirhat mamär nä gua enge bä ba ngän sokt di sa sirhäkt kaku ngän nasangar mamär sävät iangärhäkt ama enge moekt. ");
INSERT INTO uro_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Sokt di nga rhoqoräkt iva iaqäkt ama Qloqaqa na ama engäktki qa rhän dä va qär qur a ngän da ama engäktki moe. Qaku qä natmärhamän nävät aa mädräm maräkt dap pa sokt kat tamän bät iarhongäkt kärqärhong i qat nari irhong. Dä va qär qoar na ngän nä qärqärhongni iva as irhong ngä rhän. ");
INSERT INTO uro_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Bä va qä von ngo rha ama murhämeska inguna va qät ta qärqärhongni i irhong nagem ngo bä va qat tuqunäga sä irhong bä ba ngän. ");
INSERT INTO uro_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Bä iarhongäkt moe qärqärhong i ama Ngätmamäk aa qärhong di ngo gu qärhong. Bä äkt i sa ngua qoar iva ama Qloqaqa ama Qumärqumärqa qät ta agini qärqäni i ini nagem ngo bä va qat tuqunäga sä ini bä ba ngän. ");
INSERT INTO uro_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Näkt nasot ama qäväläm ama qot äm diva as kaku ngän nalu ngo näkt pät ama qäväläm ama qot äm nasot dä saqi va ngäni lu ngo.” ");
INSERT INTO uro_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Dä soknga arhani nävät ma Jisas aa mudäsaqongda rha qoar na ne rhoqortäqyia, “Ngu lu ama rharimini rhoqor mäniekt sa aa enge qärqäni i sa qä qoar toqortäqyia, ‘Bä nasot ama qäväläm ama qot äm diva as kaku ngän nalu ngo näkt pät ama qäväläm ama qot äm nasot dä saqi va ngäni lu ngo’ dä qosaqi qä qoar toqortäqyia, ‘Inguna va ngua rhet sage ama Ngätmamäk’?” ");
INSERT INTO uro_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Bä qoki mai na rha i rhi snanbät sä ne rhoqortäqyia, “Ngu lu ama rharimini rhoqor mäniekt bä äkt i qä qoar toqortäqyia, ‘ama qäväläm ama qot äm’? Sa qaku qunäga vät a ut sä iangärhäkt aa enge.” ");
INSERT INTO uro_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Bä nga ma Jisas kat dräm i nani a rha iva rhi snanbät sä qa närha aa enge dä qa snanbät sä rha rhoqortäqyia, “Nga ngäni snanbät sä ne närha ama rharimini mäniekt kärqäni i ngua qoar toqortäqyia, ‘Nasot ama qot äm ama qäväläm dä as kaku ngän nalu ngo näkt nasot ama qäväläm ama qot äm dä saqi va ngäni lu ngo’? ");
INSERT INTO uro_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sa nguat tamän särhäm ngän na ama engäktki iva ngän di ngänit nok dä airäs ngän dap ama ruvek nävät ama ivätki di sa va märmär gem da masirhat. Bä ngän diva airäs ngän sokt diva iaqyäkt angäna iräski diva qi rhong na nas ma ama märmärgem. ");
INSERT INTO uro_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","“Ama evopki di nga rhoqoräkt i qit sa ama qokokka dä qi nari ama ruanini inguna sa at käväläm ngä män iva qi sa sokt di nga rhoqoräkt i sa qia sa at kokokka dä sa rät pät a qi na ama ruanini inguna nävät at märmärgem i sa at kokokka qa män sämäni ama ivätki. ");
INSERT INTO uro_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Bä äkt i aingän di rhäkt di airäs ngän masirhat sokt di saqi as pa ngu lu ngän dä va mär gem ngän masirhat bä va qaku aung gä nasot nä iangärhäkt angän märmärgem. ");
INSERT INTO uro_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Näkt pät iomäkt ama qäväläm diva qaku ngän nasnanbät sä ngo na anga snanbät. Sa nguat tamän särhäm ngän na ama engäktki iva ama Ngätmamäk pa qä von ngän da agini qärqäni i ngäni nän ga rhäm ini nävät gu ngärhipki. ");
INSERT INTO uro_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Qoki as inamäk bä sarhäkt di as kaku ngän nän dä guani nävät gu ngärhipki. Ngäni nän ma Ngämuqa dä va qä von ngän ivakt iva märmär gem ngän masirhat. ");
INSERT INTO uro_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Bä inamäk dä sa nguat tamän särhäm ngän na ama enge qärangätni i qaku qunäga vät a ngän sä ngät sokt di as ama qäväläm iva äm ngä rhän gärqomni iva qaku ngu natmärhamän doqoräkt dap pa nguat tamän särhäm ngän mamär sävät ama Ngätmamäk. ");
INSERT INTO uro_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Näkt pät iomäkt ama qäväläm dä va ngäni nän nävät gu ngärhipki. Sa qaku nguat tamän iva ngu nän ama Ngätmamäk bä ba ngän. ");
INSERT INTO uro_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Dap kinak mamär iva ngäni nän doqoräkt inguna ama Ngätmamäk di aa snäng bät a ngän inguna sa angäna snäng bät a ngo dä ngänät nanakt i sa ngua män nagem ga. ");
INSERT INTO uro_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Sa ngua män nage ama Ngätmamäk bä sämäni ama ivätki näkt saqi rhäkt diva ngua rhet nämäni ama ivätki bä va evär däm ngo sage ama Ngätmamäk.” ");
INSERT INTO uro_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dä sa ma Jisas aa mudäsaqongda rha qoar toqortäqyia, “I, sa rhäkt di ngiat tamän mamär dä qaku ngiat tamän na ama enge qärangätni i qaku qunäga vät a ut sä ngät. ");
INSERT INTO uro_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Bä rhäkt di sa ut lu i ngiat dräm iarhongäkt moe bä nge di qäqi qaku ngit läk iva aung gä snanbät sä nge na anga snanbät inguna ama ruvek moe di sa ngiat dräm arhä snängaqa mamär. Bä nävät tom däkt dä ut nanakt i sa ngia män nage ma Ngämuqa.” ");
INSERT INTO uro_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Dä ma Jisas ka snanbät sä rha rhoqortäqyia, “Nga rhäkt di sa ngänät nanakt? ");
INSERT INTO uro_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","As ngäni lu i as ama qäväläm ba äm ngä rhän bä sa rhäkt di sa äm ngä män iva vräsmät na ngän bä säva angäna värhap ak dä ak na ngän. Bä va ngän det daqule ngo i sokt ngo maräkt. Sokt di qaku sokt ngo qale ngo inguna ama Ngätmamäk di sa qale qa qä na ngo. ");
INSERT INTO uro_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Näkt sa ngua qoar na ngän nä rhärhong däkt divakt iva nävät a ngo diva qale ama bulap gem ngän. Inguna mäni rhakt täkt ama ivätki diva ngänit ta ama märänga. Sokt di mamär iva märmär gem ngän. Sa ngua män näva ama ivätki at täväs.” ");
INSERT INTO uro_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Näkt sa nasot tangät täkt aa enge dä ma Jisas ka ñäm dävit säda ama usäpki arha ron bä qä nän doqortäqyia, “Mam, ama qäväläm di sa äm ngä män. Sa ngi sek sä ngia emga aa ngärhipki ivakt iva ngia emga qä sek sä gi ngärhipki. ");
INSERT INTO uro_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Inguna sa ngia von ga rha ama qrot daver ama ruvek moe ivakt iva qä von dä ama iar ama sok täm ngät bä bä iarhakt kärarhae i sa ngia von ga rhäm da. ");
INSERT INTO uro_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Bä rhangät täkt di ama iar ama sok täm ngät iva rhat dräm i ainge di sokt nge ama engäktki na qa ma Ngämuqa näkt sävät ma Jisas ma Krais iaqäkt kärak i sa ngia rhäk na qa. ");
INSERT INTO uro_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Sa ngua von nge rha ama murhämeska rhe mäni ama ivätki i ngua sot na ama lat kärangätni i sa ngia von ngo rhäm ngät iva ngua rhualat na ngät. ");
INSERT INTO uro_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Näkt sa rhäkt mam, diva ngi sek sä ngo sa äkt i qale nge e sädä gia sdäm. Näkt sa rhäkt mam, diva ngi von ngo rha ama murhämeska qärakni i mudu nguat sangar a qa ngu na nge rhoqoräkt i as kaku ama ivätki qia män. ");
INSERT INTO uro_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Sa ngua muqunäga sä nge bä bä iarhakt kärarhae i sa ngia von ngo rhäm da nämäni ama ivätki. Bä rha di sa gia ruvek bä sa ngia von ngo rhäm da bä sa rha met parhäm gia enge. ");
INSERT INTO uro_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Bä rhäkt di rhat dräm i iarhongäkt moe qärqärhong i sa ngia von ngo rhäm irhong di irhong nagem nge. ");
INSERT INTO uro_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Inguna ngua von da rha ama enge qärangätni i sa ngia von ngo rhäm ngät dä rhat nanakt na ngät. Bä rhat dräm ama engäktki i sa ngua män nagem nge dä rhat nanakt i sa ngia rhäk na ngo. ");
INSERT INTO uro_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Bä ngu nän di sävät a rha. Dap kaku ngu nän sävät ama ruvek mavängam nävät ama ivätki dap kinak ngu nän sävät iarhakt kärarhae i sa ngia von ngo rhäm da inguna rha di gia ruvek na rha. ");
INSERT INTO uro_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Näkt gu qärhong moe di gi qärhong bä qosaqi gi qärhong moe di gu qärhong. Bä nävät iarhongäkt dä sa ama murhämeska qa män sagem ngo. ");
INSERT INTO uro_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Bä rhäkt di qaku qale ngo mäni ama ivätki inguna nguat dän sagem nge. Dap ta diva as kale rha mäni ama ivätki. Gu mamäk ama qumärqumär qa mamär, sa mamär iva ngit lu vät a rha mamär na ama qrot nävät gi ngärhipki qäraktni i sa ngia von ngo rhäm gi iväkt iva sägäk na rha rhoqor un i sägäk na un. ");
INSERT INTO uro_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sa rhoqoräkt i qale ngo ngu na rha dä ngut lu vät a rha bä ama iar va arhä väs nävät iaqyäkt ama ngärhipki qärakt i sa ngia von ngo rhäm gi. Sa ngut lu vät a rha bä sa qaku aung nävät a rha di musäng sä qa dap sokt iaqäkt kärak i sa ma Ngämuqa qa muqunän bät a qa iva rhi sangäm na qa ivakt iva rhäkmamär varhäm gia enge qärangätni i sa rha säm a ngät. ");
INSERT INTO uro_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Bä rhäkt di nguat dän sagem nge sokt di nguat tamän bät tärhärhong däkt as toqoräkt i qale ngo mäni ama ivätki ivakt iva rhäqäp ta mamär na ama märmärgem doqor ngo. ");
INSERT INTO uro_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Näkt sa ngua von da rhä gia enge dä ama ruvek nävät ama ivätki di sa ama vu da arha ron na rha inguna qaku rha nämäni ama ivätki rhoqor ngo. ");
INSERT INTO uro_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Bä rhangät täkt gua nän di qaku va ngi narhat ta nämäni ama ivätki dap pakt iva ngit lu vät a rha mamär nämät ma Sämga. ");
INSERT INTO uro_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bä sa rha di qaku rha nämäni ama ivätki i nak kop toqor ngo i qaku ngo nämäni qi. ");
INSERT INTO uro_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sa ngia arñis na rha na ama engäktki. Gia enge di ama engäktki na ngät. ");
INSERT INTO uro_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Bä sa ngua rhäk na rha sämäni ama ivätki i rhoqor nge i sa ngia rhäk na ngo sämäni ama ivätki. ");
INSERT INTO uro_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Näkt ngua arñis na nas iva bä ba rha. Rhoqoräkt divakt iva qosaqi rhi arñis na nas nä gia engäktki.” ");
INSERT INTO uro_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Bä rhangät täkt gua nän di qaku sokt sävät a rha. Dap ngu nän di qosaqi sävät iarhakt kärarhae iva rhat nanakt na ngo nävät arhä sameng ");
INSERT INTO uro_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ivakt iva rha moe diva sägäk na rha i nak kop toqor nge mam i sa ngia e väm ngo dä ngua e väm nge. Bä rha di qosaqi mamär iva qale rha väm un ivakt iva ama ruvek nävät ama ivätki diva rhat nanakt i sa ngia rhäkt na ngo. ");
INSERT INTO uro_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Sa ngua von da rha ama murhämeska qärakni i sa ngia von ngo rhäm ga ivakt iva sägäk na rha rhoqor un i sägäk na un. ");
INSERT INTO uro_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Bä äkt i qosaqi aingo di sa ngua e väm da dä ainge di sa ngia e väm ngo ivakt iva rha rhän i sägäk na rha mamär. Bä nävät tom däkt dä va ama ruvek nävät ama ivätki rhi räm i sa ngia rhäk na ngo bä gia snäng bät a rha di qoki rhoqor nge i sa gia snäng bät a ngo. ");
INSERT INTO uro_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mam, sa nani a ngo nä iarhakt kärarhae i sa ngia von ngo rhäm da iva qale rha rhi na ngo äkt i qale ngo e ivakt iva rhi lu gu murhämeska qärakni i sa ngia von ngo rhäm ga inguna sa gia snäng bät a ngo as toqoräkt i qaku ama ivätki qia män.” ");
INSERT INTO uro_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Gu mamäk ama räkt ka, näma dä qaku ama ruvek nävät ama ivätki rhat dräm a nge sokt di nguat dräm a nge bä rhärha rhäkt ama gamoe di rhat dräm i sa ngia rhäk na ngo. ");
INSERT INTO uro_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Bä sa ngua muqunäga sä nge bä ba rha bä va qoki as nguat tuqunäga sä nge ivakt iva gi lavuqi qäraktni i sävät a ngo diva qali qi e väm da bä aingo diva qale ngo e väm da.” ");
INSERT INTO uro_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Bä nga rhoqoräkt i ma Jisas kä nän bä rhäksot dä sa qä na aa mudäsaqongda rha met na äkt bä rha mängaläkt ama uväs kärqosni i rhat tes äs i ma Kidron. Näkt nga rhage nä iosäkt ama uväs di ama ivärhäs kärqosni i qale ama erhäs na ama ngämung na ama olip e dä sa qä na aa mudäsaqongda rha mon sae. ");
INSERT INTO uro_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Dä ma Judas kärakni iva qä vodä ma Jisas säva aa ikkäna arhä rhäkt di qosaqi qat dräm iosäkt ama erhäs inguna ma Jisas kä na aa mudäsaqongda rhät dräm bäspästämne na rha e. ");
INSERT INTO uro_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Bä äkt i sa ma Judas ka er nanokt ama guläñgi na ama ulaqimärharhärhäkt näkt sävät arhani ama narhoerta nävät ama priskäna ama moräs na rha näkt ama Farisiqäna bä sa äkt sävät iosäkt ama erhäs. Näkt iaqyäkt ama guläñgi di rhit ta ama lirhäng dä ama ngämungiseng gärqisengni i rhat dräm dat tudäm sädä iseng angät tpäs näkt ama ulaqi at kärhong. ");
INSERT INTO uro_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Bä ma Jisas di sa qat dräm iarhongäkt moe qärqärhong iva irhong ngä rhän bät a qa bä äkt i vuk sä qa nävä iosäkt ama erhäs bä qa snanbät sä rha rhoqortäqyia, “Ngu lu ngänit ñäm nani auge?” ");
INSERT INTO uro_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Dä rha muvät pät a qa rhoqortäqyia, “Ma Jisas nae ma Nasaret.” Dä ma Jisas ka qoar toqortäqyia, “Nak kop aingo rhäkt.” Näkt toqoräkt di ma Judas kärakni iva qä vodäm ga säva arhä rhäkt di qa e qä na rha. ");
INSERT INTO uro_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Bä nga rhoqoräkt i ma Jisas ka qoar na rha rhoqortäqyia, “Nak kop aingo rhäkt” dä sa rha moda arha rhäng bä arpus na rha sävät ivät. ");
INSERT INTO uro_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Dä saqi as ma Jisas ka snanbät sä rha rhoqortäqyia, “Ngu lu ngänit ñäm nani auge?” Dä rha qoar toqortäqyia, “Ma Jisas nae ma Nasaret.” ");
INSERT INTO uro_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Dä ma Jisas ka muvät toqortäqyia, “Sa ngua qoar na ngän i nak kop aingo rhäkt. Ngakt bä ngänit ñäm nani a ngo dä sa angäna qlak nä rhärha e ama gamoe iva rha rhet.” ");
INSERT INTO uro_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Bä rhangät täkt ngä märanas divakt iva rhäkmamär varhäm ama enge qärangätni i sa qa märhamän bät a ngät toqortäqyia, “Sa qaku ngua musäng sa aung nävät iarhakt kärarhae i ngia von ngo rhäm da.” ");
INSERT INTO uro_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Bä nga rhoqoräkt dä ma Saimon Pita qärakni i qät ta ama ulaqi arha singi di qa mar täm gi bä qa rhodäkt sa ama pris ama vit na qa aa latka aa sdämgi ama märmär qi. Iaqäkt ama latka di aa ngärhipki ma Malkus. ");
INSERT INTO uro_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Dä soknga ma Jisas ka märhamän särhä ma Pita ma ama qrot toqortäqyia, “Ngia rhu gia singi nasot a nas! Nga va qaku ngu nanakt nämät ama kap na ama märänga qärakni i sa ama Ngätmamäk ka von ngo rhäm ga iva ngu nakt nämät ka?” ");
INSERT INTO uro_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Bä äkt i sa ama guläñgi na ama ulaqimärharhärhäkt ti na arhä narhoerqa näkt sävät ama Judaqäna arhä narhoerta rha sangar ma Jisas. Dä rha qop mät aa rhäkt ");
INSERT INTO uro_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","näkt ta er ta met sä qa sage ma Anas kärakni i ma Kaiafas ama pris ama vit na qa vät iaqäkt ama quiaqa aa rhäväska. ");
INSERT INTO uro_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Näkt iaqäkt ma Kaiafas di qärak i sa qa qoar na ama Judaqäna i sa ama märäm masirhat iva ama sägäk ama ruqa qä ñäp bä ba ama ruvek. ");
INSERT INTO uro_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Bä nga rhoqoräkt i rhat tet sä ma Jisas dä ma Saimon Pita qä na akni nävät ama mudäsaqongda in det nasot a rha. Sokt di iaqäkt ama mudäsaqongga di ama pris ama vit na qa qat dräm a qa bä nga rhoqoräkt dä qä na rha sä ma Jisas savuk säva ama pris ama vit na qa aa vätka aa ivärhäm ");
INSERT INTO uro_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","dap ma Pita di qale qa inamäk dalek glaqot na ama tmongi. Bä äkt i qä mudäsaqongga qärakni i ama pris ama vit na qa qat dräm a qa evär däm ga navuk bä qa märhamän särha ama latki qäraktni i qit lu vät ama tmongi bä sa qa mon sä ma Pita savuk. ");
INSERT INTO uro_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Dä sa qa latki nämät ama tmongi qia snanbät sä ma Pita rhoqortäqyia, “Nga sa qaku ak na nge nävät ma Jisas aa mudäsaqongda?” Dä qa muvät toqortäqyia, “Qaku rhäm ngo.” ");
INSERT INTO uro_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Näkt nga rhoqoräkt i qale rha vuk dä ama latta rhi na ama narhoerta di sa rha ek ta ama mudäbäs bä rhat mair namet a äs i rhat narhäkt inguna ama iski. Bä ma Pita di qosaqi qat mair qä na rha i qat narhäkt. ");
INSERT INTO uro_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Dap toqoräkt dä ama pris ama vit na qa kä snanbät sä ma Jisas närha aa mudäsaqongda dä närha aa rhisu. ");
INSERT INTO uro_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Dä ma Jisas ka muvät pät a qa rhoqortäqyia, “Sa ngua märhamän mamär särha ama ruvek nävät ama ivätki dap kaku ngua ngaip sa anga enge. Sa nguat dräm ngu su ama ruvek pa ama mämairväm bä qop pa ama ansäspämgi ama mor qi äkt i väspästämne ama Judaqäna moe e. ");
INSERT INTO uro_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ngu lu mäniekt bä ngi snanbät sä ngo? Sa ngi snanbät sä iarhakt kärarhae i rha nari ngo inguna sa rhät dräm doqoräkt i nguat tamän.” ");
INSERT INTO uro_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Bä nga ma Jisas ka märhamän doqoräkt dä akni nävät ama narhoerta na glaqot na qa qa e va aa sdäm. Näkt ka snanbät sä qa ma ama qrot toqortäqyia, “Nga va ngiat tuvät pät ama pris ama vit na qa rhoqoräkt?” ");
INSERT INTO uro_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Dä ma Jisas ka muvät toqortäqyia, “Ngakt bä ngua märhamän bät anga enge qärangätni i qaku ama räkt ngät dä ngäni qoar mamär i qaku ama räkt ngät. Dap ngakt bä sa ngua märhamän bät ama enge qärangätni i ama räkt ngät dä ngu lu mäniekt bä ngia e vä gua sdäm?” ");
INSERT INTO uro_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Bä na äkt dä ma Anas ka rhäk na qa i qoki as ta qop mät aa rhäkt sage ma Kaiafas ama pris ama vit na qa. ");
INSERT INTO uro_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Dap toqoräkt dä ma Saimon Pita di as kat mair bä qat narhäkt dä rha snanbät sä qa rhoqortäqyia, “Nga qosaqi qaku ak na nge nävät ma Jisas aa mudäsaqongda?” Dä qa rhäqyas i qa qoar toqortäqyia, “Qaku rhäm ngo.” ");
INSERT INTO uro_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Dä akni nävät ama pris ama vit na qa aa latta qärakni i aa aka di sa ma Pita qa rhodäkt sa aa sdämgi qa snanbät sä qa rhoqortäqyia, “Nga ngäktki na ngo i sa ngua lu nge ngi na qa mäk pa ama erhäs na ama olip?” ");
INSERT INTO uro_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Dä saqi as ma Pita qa rhäqyas näkt pät iomäkt ama qäväläm maräkt dä ama duraktka qa nok. ");
INSERT INTO uro_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Näkt na äkt dä ama Judaqäna rha met sä ma Jisas nage ma Kaiafas bä säva ama Romgäna arha tpäskinaqa aa vätki ama mor qi. Näkt toqoräkt i sa rha män e di as pät duququs mamär dä qaku rha mon sävä iaqyäkt ama vätki inguna nani a rha iva ama qumärqumär ta rhoqor varhäm arhä qärhong ivakt iva rhoqoräkt dä mamär iva rha äs ama tmäski ma Pasova. ");
INSERT INTO uro_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Bä äkt i sa vuk sä ma Pailat sagem da bä qa snanbät sä rha rhoqortäqyia, “Ngu lu ngän däksärhä rhak täkt ama ruqa na agini?” ");
INSERT INTO uro_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Dä rha muvät pät a qa i rhi qoar toqortäqyia, “Ngakt bä vadi mai qaku qa mualat nä guani dä vadi mai qaku ut namän sä qa sagem nge.” ");
INSERT INTO uro_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Dä sa ma Pailat ka qoar na rha rhoqortäqyia, “Qoki ngän, ngän det sä qa bä ngän datnävämne na qa varhäm angän muräkt.” Sokt di qä Judaqäna rha muvät pät a qa rhoqortäqyia, “Aut Muräkt di qaku ngärhit tares pät urha rhäng iva urhi veng aung.” ");
INSERT INTO uro_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Rhangät täkt di ngä märanas ivakt iva rhäkmamär varhäm ama enge qärangätni i sa ma Jisas ka märhamän bät a ngät sävät aa tñäpki iva qä näp di rhoqoräkt. ");
INSERT INTO uro_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Bä nga ma Pailat ka nari rhoqoräkt dä saqi evär däm ga savuk säva aa vätki ama mor qi näkt ka rhäkne nani ma Jisas bä qa snanbät sä qa rhoqortäqyia, “Nga ainge di ama Judaqäna arha vitnaqa na nge?” ");
INSERT INTO uro_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Dä ma Jisas ka snanbät sä qa rhoqortäqyia, “Nga ainge maräkt gi snanbät iangärhäkt ura arhani rha qoar na nge sävät a ngo?” ");
INSERT INTO uro_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Dä ma Pailat ka muvät toqortäqyia, “Nak nga ama Judaqa na ngo? Qoki gia ruvek ti nä gi priskäna ama moräs na rha di iarhakt kärarhae i rha män sä nge sagem ngo. Ngu lu ngia mune vät a nas na agini?” ");
INSERT INTO uro_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Dä ma Jisas ka muvät toqortäqyia, “Gu muräktpäm di qaku ngät nämäni rhakt täkt ama ivätki. Ngakt bä vadi mai ngät nämäni ama ivätki dä sa vadi mai gua latta vä gua rem di e vät ngua väs ivakt iva qaku ama Judaqäna rhi nasangar a ngo. Dap täkt di gu muräktpäm di qaku ngät narhe.” ");
INSERT INTO uro_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Dä soknga ma Pailat ka qoar na qa rhoqortäqyia, “Bä äkt i nge di ama vitnaqa. Nga ngäktki rhoqoräkt?” Dä ma Jisas ka muvät toqortäqyia, “Qoki nge ngi qoar i aingo di ama vitnaqa. Ama rharimini qärqäni i sa ngua män sämäni ama ivätki divakt iva ngu sameng sävät ama engäktki. Näkt iarhakt ama ruvek moe qärarhae i rha nävät ama engäktki at käge di rhat nari nämät ngo.” ");
INSERT INTO uro_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Dä ma Pailat ka snanbät sä qa rhoqortäqyia, “Ngu lu ama engäktki di agiqa?” Näkt nga nasot i qa snanbät toqoräkt dä saqi as puk sä qa sä dalek sage ama Judaqäna bä qa qoar na rha rhoqortäqyia, “Qaku ngua män bät guani qärqäni iva ngu rhäksärhäm ga nä ini. ");
INSERT INTO uro_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Sokt di varhäm angän gärhong diva ngua rhuisiska vät akni anga ruqa näva ama tpäskiarharhäng bä ba ngän bät ma Pasova angät kunäng. Nga nani a ngän iva ngua rhuisiska vät ‘ama Judaqäna arha vitnaqa’ bä ba ngän?” ");
INSERT INTO uro_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dä sa rha muvät pät a qa i rhit näs toqortäqyia, “Qaku, qaku rhä iaqäkt ama ruqa! Ngi von ut tä ma Barabas!” Rhoqoräkt di ma Barabas di sa qale qa va ama tpäskiarharhäng inguna ak na qa nävät iarhakt kärarhae i sa rha märanas na ama inirqi. ");
INSERT INTO uro_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Rhoqoräkt dä sa ma Pailat ka vodä ma Jisas bä ba ama ulaqimärharhärhäkt bä sa rhat täranäs ka. ");
INSERT INTO uro_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Näkt ama ulaqimärharhärhäkt ta mualat na ama guaqi na ama ngämuga aa rhäqyitnäk ama gärgär vät itnäk iva rhoqor ama vitnaqa aa qäbautki bä rha mu qi dä aa uväs. Näkt kosaqi rha monmät pät a qa na ama pärpel qi ama boiqi ");
INSERT INTO uro_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","näkt sa rhit täqäs mät ama enge nasot arha rhäng gane qärangätni i rhat tamän särhäm ga na ngät toqortäqyia, “Ama märmärgem sage ama Judaqäna arha vitnaqa!” Näkt ti e va aa sdäm. ");
INSERT INTO uro_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Dä saqi as puk sä ma Pailat sä dalek bä qa qoar na ama Judaqäna rhoqortäqyia, “As ngäni lu i sa rhäkt di ngut täk na qa sagem ngän divakt iva ngänät dräm i sa qaku ngua män bät guani iva ngu rhäksärhäm ga vät ini.” ");
INSERT INTO uro_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Bä nga rhoqoräkt i vuk sä ma Jisas navuk sa ama guaqi na ama gärgär da aa uväs näkt ama boiqi qäraktni i sa rha monmät pät a qa na qi dä sa ma Pailat ka qoar na rha rhoqortäqyia, “Ngäni lu qärak ka ruqa.” ");
INSERT INTO uro_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bä nga rhoqoräkt i ama priskäna ama moräs na rha rhi na ama narhoerta rha lu qa dä sa rha näs i rhi qoar toqortäqyia, “Ngi edämsäs pät a qa mäni ama sämänanamuqa! Ngi edämsäs pät a qa!” Sokt di ma Pailat ka muvät toqortäqyia, “Ngän det sä qa bä ngäni edämsäs pät a qa. Inguna ngo di sa qaku ngua män bät guani qärqäni iva ngu rhäksärhäm ga vät ini.” ");
INSERT INTO uro_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Dä ama Judaqäna rha muvät pät a qa rhoqortäqyia, “Aiut di aut muräkt näkt parhäm iangärhäkt ama muräkt di qoki mamär iva qä ñäp inguna qä qoar i qa di ma Ngämuqa aa emga.” ");
INSERT INTO uro_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Bä nga ma Pailat ka nari rhoqoräkt dä nak sa qät len masirhat. ");
INSERT INTO uro_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Dä saqi evär däm ga savuk säva ama vätki ama mor qi. Näkt ka snanbät sä ma Jisas toqortäqyia, “Ngu lu ngia män na qoe nai?” Sokt di ma Jisas di qaku qa muvät pät a qa. ");
INSERT INTO uro_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Bä äkt i ma Pailat ka snanbät sä qa rhoqortäqyia, “Nga va qaku ngi namärhamän särhäm ngo? Nga qaku ngiat dräm i aingo di gu qrot iva ngua rhuisiska vät a nge bä qosaqi gu qrot iva ngua rhuräkt iva rhi edämsäs pät a nge mäni ama sämänanamuqa?” ");
INSERT INTO uro_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Dä ma Jisas ka muvät toqortäqyia, “Nga vadi mai qaku rhi navon nge rha ama rhares na rhävuk dä vadi mai sa qaku mamär vät gi qrot nä guani. Bä äkt i iaqäkt kärak i sa qa von nge rhäm ngo di aa vuini ama mor ini mamär.” ");
INSERT INTO uro_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Mänasäng na äkt dä ma Pailat kä siqut iva qa rhuisiska vät ma Jisas sokt di qop ama Judaqäna di rhit näs i rhi qoar toqortäqyia, “Ngakt bä gia qlak nä rhak täkt ama ruqa bä qa rhet dä sa qaku ma Sisar aa ruaqa na nge inguna iaqäkt kärak i qä qoaräs i qa di ama vitnaqa di iaqäkt di qaku qät kutdrir vät ma Sisar.” ");
INSERT INTO uro_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Bä nga ma Pailat ka nari rhoqoräkt dä vuk sä qa sä ma Jisas sä dalek näkt ka muqun mät ama matnävämnenaqa aa mämugunäs pät ama ivärhäm gärqomni i rhat tes äm i ama ivärhäm i sa rha mas na ama duligleng ama rhäqäp nä igleng i na ama Judaqäna arha enge di rhat tes äm i ma Gabata. ");
INSERT INTO uro_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Näkt toqoräkt di sa mäniqunäng bät iaqäkt ama qunäga na ama rhäkmu irhä ma Pasova angät tadenas. Dä ma Pailat ka qoar na ama Judaqäna rhoqortäqyia, “Angäna vitnaqa rhak i.” ");
INSERT INTO uro_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Sokt di rhit näs toqortäqyia, “Ngia rhet sä qa na äkt bä va ngi rhäksot na qa! Ngi edämsäs pät a qa mäni ama sämänanamuqa!” Dä ma Pailat ka snanbät sä rha rhoqortäqyia, “Nak nga mamär iva ngu edämsäs pät angäna vitnaqa?” Dä ama priskäna ama moräs na rha rha muvät toqortäqyia, “Qaku aurha anga vitnaqa aung dap sokt ma Sisar.” ");
INSERT INTO uro_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Bä nga rhoqoräkt dä sa ma Pailat ka vodä ma Jisas ivakt iva rhi edämsäs pät a qa. Dä sa ama ulaqimärharhärhäkt ta rha ma Jisas ");
INSERT INTO uro_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","näkt kat tet i sokt ka qät ta aa sämänanamuqa bä säva ama ivärhäs sä dalek na ama värhäm ama mor äm gärqosni i rhat tes äs i ama rhomga aa uväski. Iosäkt ama ivärhäs di na ama Judaqäna arha enge di rhat tes äs i ma Golgota. ");
INSERT INTO uro_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bä rha edämsäs pät a qa äkt mäni ama sämänanamuqa qä na aiomni ama udiom i ma Jisas sä mänguräp mä iom i ak särhage dä akni särhage. ");
INSERT INTO uro_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Näkt sa ma Pailat ka säm ama enge bä rha däktgyäm ngät mäni ama sämänanamuqa. Iangärhäkt ama enge di ngät tamän doqortäqyia, “Ma Jisas nae ma Nasaret, ama Judaqäna arha vitnaqa.” ");
INSERT INTO uro_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ama rhäqäp na rha ama Judaqäna di rha mes iangärhäkt ama enge inguna ama ivärhäs iosäkt kärqos i sa rha edämsäs pät ma Jisas e di glaqot na ama värhäm ama mor äm. Näkt ama enge qärangätni i sa rha säm a ngät di na ama Judaqäna arha enge näkt sävät ama enge i ama Romgäna rhi na ama Grikkäna. ");
INSERT INTO uro_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bä nga rhoqoräkt dä ama Judaqäna arhä priskäna ama moräs na rha rha qoar nä ma Pailat toqortäqyia, “Qale ngi nasäm doqortäqyia, ‘Ama Judaqäna arha vitnaqa’ dap kinak ngi säm doqortäqyia, ‘Rhak täkt ama ruqa di qa qoar i qa di ama Judaqäna arha vitnaqa.’” ");
INSERT INTO uro_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Dä ma Pailat ka muvät toqortäqyia, “Ianiäkt kärqäni i sa ngua säm ini diva qali lini rhoqoräkt.” ");
INSERT INTO uro_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Näkt nga rhoqoräkt i ama ulaqimärharhärhäkt ta edämsäs pät ma Jisas dä sa rha rha aa boi bä rha matmät na ngät sävät ama levaet nä imek ama ningimek i asägäk asägäk nävät a rha sa aa nengäs. Dä nani a rha iva rha rhualat toqoräkt sa aa boiqi ama uiu qi sokt di iaqyäkt di ama sägäkt na qi navuk bä samäk. ");
INSERT INTO uro_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bä äkt i rha qoar na ne rhoqortäqyia, “Qale ut nangyiret mät ki. Dap kinak pa u rhualat na anga serhäm ivakt iva urhi lu iva auge qä rha qi.” Rhangät täkt di ngä märanas ivakt iva rhäkmamär varhäm ma Ngämuqa aa enge qärangätni i ngät tamän doqortäqyia, “Rha matmät nä gu boi bä ba ne dä serhäm da nani gu boiqi.” Bä qoki rhäkmamär i ama ulaqimärharhärhäkt ta mualat toqoräkt. ");
INSERT INTO uro_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Dap toqoräkt di ma Jisas aa nanäk ki na arha matki näkt sävät ma Maria qäraktni i ma Klopas aa egutki näkt sävät ma Maria nae näva ama värhäm ama gaini na äm ma Makdala di rhat mair e glaqot nä ma Jisas aa sämänanamuqa. ");
INSERT INTO uro_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Bä nga rhoqoräkt i ma Jisas ka lu aa nanäk näkt aa mudäsaqongga qärakni i aa snäng bät a qa i qat mair glaqot na qi dä sa qa märhamän särha aa nanäk toqortäqyia, “Rhaktni, as ngi lu i ngia emga rhak i.” ");
INSERT INTO uro_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Dap ka qoar nä qä mudäsaqongga rhoqortäqyia, “As ngi lu i gi nanäk takt i.” Bä sa na äkt dä iaqäkt aa mudäsaqongga qä na qi säva aa vät bä qät lu vät a qi. ");
INSERT INTO uro_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Näkt nga nasot iangärhäkt dä ma Jisas kat dräm i ama lat moe di sa rhäksot na ngät iva sa rhäkmamär varhäm ma Ngämuqa aa enge bä äkt i sa qa qoar toqortäqyia, “Aqäsäk ngo.” ");
INSERT INTO uro_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Rhoqoräkt di qale ama kainaqi na ama wain ama valak mät ki e bä äkt i rha ok ama bauläm mät ki näkt ta srät na äm da ama ngämungäm ama hisop angät ngärhäktka aa uväs näkt ta sek mä qa sä äm sämät ma Jisas aa vämgi. ");
INSERT INTO uro_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Bä nga nasot toqoräkt i sa ma Jisas ka nakt ama wain ama valak mät ki dä qa qoar toqortäqyia, “Sa rhäksot.” Nasot iangärhäkt aa enge dä qa an da aa uväs näkt ka voda aa qloqaqa bä bä ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Näkt toqoräkt di ama qunäga na ama rhäkmu iva duququ vät akni ama qunäga diva ama moräs na qa ama qunäga bä ba ama Judaqäna. Bä äkt i ama Judaqäna rha nän ma Pailat iva rhin betäk pät ama gamoe qärarhani i sa rha edämsäs pät a rha arha qar näkt pa rhin but sa arhä släqyigleng samäk inguna qaku nani a rha iva qale arhä släqyigleng mäni ama sämänanamu rhoqoräkt pät ama Sabat. ");
INSERT INTO uro_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Bä äkt i nga rhoqoräkt dä ama ulaqimärharhärhäkt ta män bä rha anbetäk pät ama narhoer qa ama ruqa aa qar qärakni i rha edämsäs pät a qa qä nä ma Jisas näkt nasot dä qosaqi sa akni aa qar. ");
INSERT INTO uro_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Dap nga rhoqoräkt iva sä ma Jisas di nak sa rha lu i sa qa ñäp dä qaku rha anbetäk säva aa qar. ");
INSERT INTO uro_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Dap kinak akni nävät ama ulaqimärharhärhäkt ka qut mäni ma Jisas aa brät na ama qepka bä qärir na ama biaska masägos kä na ama rigi. ");
INSERT INTO uro_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Näkt iaqäkt kärak i qa lu rhoqoräkt di sa qa sameng sävät iangärhäkt ama lat bä iangärhäkt aa sameng di ama engäktki na ngät. Bä qa di qat dräm i qat tamän bät ama engäktki bä qä sameng iväkt iva ngän di mamär iva qosaqi ngänät nanakt. ");
INSERT INTO uro_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Rhangät täkt di ngä märanas ivakt iva rhäkmamär varhäm ma Ngämuqa aa enge qärangätni i ngät tamän doqortäqyia, “Qaku anga sägäkt nävät aa släp diva vetäk mäni qi” ");
INSERT INTO uro_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","dä qosaqi va rhäkmamär varhäm angätni ma Ngämuqa aa enge qärangätni i ngärhi qoar toqortäqyia, “Va rhat nañäm sävät iaqäkt kärak i sa rha qut mä qa.” ");
INSERT INTO uro_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nasot iangärhäkt dä ma Josep nämät ama värhäm ma Arimatea qa nän ma Pailat tä ma Jisas aa släqyige. Ma Josep di ma Jisas aa mudäsaqongga na qa sokt di qä ngaip nas inguna qät len ama Judaqäna arhä narhoerta. Dä ma Pailat ka rhares pät aa rhäng bä äkt i qa män bä qa rha ma Jisas aa släqyige nae. ");
INSERT INTO uro_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Näkt ma Nikodemus kärakni i sa mäqi qa met sage ma Jisas näp bängagi di qosaqi qä nä ma Josep toqoräkt. Ma Nikodemus di qät ta arhom gärqärhomni iva irhom sävät ma Jisas aa släqyige qärqärhom i rhat tes irhom i ama mir näkt ama alos i sa rha modämne nä irhom angät märänga di qorhäs na ama ruqa ama rhäk täm ga da ama ngärhäqyisem da levaet ama kilogramgäna. ");
INSERT INTO uro_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Dä soknga in da ma Jisas aa släqyige bä sa in mu ama mir ngä na ama alos pät ige näkt ina ong bät ige na ama baulitnäk ama ingas itnäk. In däkmamu nä ma Jisas aa släqyige rhoqoräkt di varhäm ama Judaqäna arhä qärhong. ");
INSERT INTO uro_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Näkt glaqot na ama ivärhäs iosäkt kärqos i sa rha edämsäs pät ma Jisas mäni ama sämänanamuqa e di ama etki qia e näkt pät iaqyäkt ama etki di qale ama iaräs na qi ama ñäpka aa liqi. Iaqyäkt ama liqi di as kaku rha mu anga ñäpka aa släqyige mät ki. ");
INSERT INTO uro_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Dap toqoräkt di ama Sabat bä äkt i nga rhoqoräkt dä rha mu ma Jisas aa släqyige mät iaqyäkt ama liqi inguna sa qia e glaqot. ");
INSERT INTO uro_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Vät ama narhoer qa ama qunäga säng ama tadenas toqoräkt i as kaku irige sa ama qunäga dä ma Maria nae ma Makdala qia met sämät ama liqi qäraktni i sa rha mas nä ma Jisas mät ki dä qia lu i sa rha rut na ama dulige näda ama liqi arha väm. ");
INSERT INTO uro_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bä äkt i sa evär däm gi i qi ngang masirhat bä sage ma Saimon Pita qä na akni ama mudäsaqongga qärakni i ma Jisas aa snäng bät a qa mamär bä qia qoar na iom doqortäqyia, “Sa rha rha aurha Engeska aa släqyige nämät ama liqi bä qaku ut dräm i sa rha mu ige qoe nai!” ");
INSERT INTO uro_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Bä nga rhoqoräkt dä sa ma Pita qä na ak kä mudäsaqongga in märanas bä in nasäng i in det iva sa äkt sämät ama liqi. ");
INSERT INTO uro_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","In moe di ini ngang ini ngang sokt di sa ak kä mudäsaqongga qa ang daqule ma Pita bä qa er qa män e. ");
INSERT INTO uro_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Dä sa qa angär bä qa ñäm bävit sävät ka baulitnäk ama ingas itnäk kärqitnäkni i qali litnäk mät ka liqi sokt di qaku qa mon sae. ");
INSERT INTO uro_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Bä nga rhoqoräkt i dängdäng nä ma Saimon Pita nasot a qa bä qa män e dä maräkt na qa bä qa mon sämät ka liqi. Dä sa qa lu ama baulitnäk ama ingas itnäk i qali litnäk i itnäk ngät namas e ");
INSERT INTO uro_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","näkt sävät ama baulit kärqitni i sa rha is pät ma Jisas aa uväski na it. Irhäkt ama baulit di it ngä vaktmät na nas bä ba nas näkt kali lit sä nas dap ama ingas itnäk ama baulitnäk sä nas. ");
INSERT INTO uro_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Bä nga rhoqoräkt dä nak as kä mudäsaqongga qärakni i sa mai qa er qa män e qosaqi qa mon sämät ka liqi. Qa lu rhoqoräkt dä qa mat maengäkt. ");
INSERT INTO uro_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Sokt di qoki as kaku qunäga vät a rha sä ma Ngämuqa aa enge i ma Jisas diva qa rhäranas nämät ama tñäpki. ");
INSERT INTO uro_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nasot dä sa evär dä qä mudäsaqongiom sävä ina vät ");
INSERT INTO uro_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","dap ma Maria di qiat mair dalek na ama liqi bä qit nok. Bä nga rhoqoräkt i qit nok dä qia angär ivakt iva qi ñäm sämät ama liqi ");
INSERT INTO uro_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","dä qia lu ama enseliom gärqiomni i ama qulum in boi i sa inät muqun äkt nasot ma Jisas aa släqyige i ak kat muqun äkt i aa uväski nae dä akni qat muqun äkt i aa qar nae. ");
INSERT INTO uro_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Dä in snanbät sä qi rhoqortäqyia, “Rhaktni, mäniekt bä ngit nok?” Dä qia qoar na iom doqortäqyia, “Sa rha rha gua Engeska aa släqyige bä qaku nguat dräm i sa rha mu ige qoe nai.” ");
INSERT INTO uro_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Bä nasot i sa qia märhamän doqoräkt dä qia rhong bät a nas bä qia lu ma Jisas i qat mair e sokt di qaku qia räm i ma Jisas na qa. ");
INSERT INTO uro_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Dä qa snanbät sä qi rhoqortäqyia, “Rhaktni, mäniekt bä ngit nok? Ngu lu auge iaqäkt kärak i ngit ñäm nani a qa?” Sokt di qiat tu at snäng i qa di ama latka na qa nävät iaqyäkt ama etki bä äkt i qia qoar na qa rhoqortäqyia, “Morqa, ngakt bä sa ngia rha aa släqyige dä va ngi qoar na ngo i sa ngia mu ige qoe nai dä va ngu rha ige nae.” ");
INSERT INTO uro_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Dä ma Jisas ka qoar na qi rhoqortäqyia, “Maria.” Dä qia ñäm sävät a qa dä qia näs i qia märhamän na ama Judaqäna arha enge rhoqortäqyia, “Rabonai!” i iaqyäkt ama ngärhipki at tarimini di qamorqa. ");
INSERT INTO uro_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Dä ma Jisas ka qoar toqortäqyia, “Qale ngi nasangar a ngo inguna as kaku evär däm ngo sage ama Ngätmamäk. Dap kinak ngia rhet bä sage gua ruavek bä va ngi qoar na rha rhoqortäqyia, ‘Aingo diva evär däm ngo sage gu mamäk dä angän mamäk i sage gu Ngämuqa dä angän Ngämuqa.’” ");
INSERT INTO uro_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Dä ma Maria nae ma Makdala qia met bä sage ama mudäsaqongda sä rhangät täkt ama sameng doqortäqyia, “Sa ngua lu ma Engeska!” Näkt kia sameng ba rha na ama engirhong gärqärhongni i qa märhamän särhäm gi nä irhong. ");
INSERT INTO uro_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Näkt toqoräkt i bängangäs pät ama narhoer qa ama qunäga säng ama tadenas dä ama mudäsaqongda di sa qale rha moe va vät. Dap ta väs mät ama tmon mamär särhäm mes inguna rhit len ama Judaqäna. Dä sa ma Jisas ka män bä qat mair mänguräp mä rha näkt ka qoar na rha rhoqortäqyia, “Qale ama bulap gem ngän.” ");
INSERT INTO uro_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Näkt ngä nasot i qa märhamän särhäm da rhoqoräkt dä sa qa qur a rha rha aa rhäqyiglem dä mäni aa brät. Bä nga rhoqoräkt i ama mudäsaqongda rha lu ma Engeska dä rhäqäp ta mamär na ama märmärgem. ");
INSERT INTO uro_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Dä saqi as ma Jisas ka qoar na rha rhoqortäqyia, “Qale ama bulap gem ngän. Rhoqor ama Ngätmamäk i sa qa rhäk na ngo dä qosaqi aingo di ngut täk na ngän.” ");
INSERT INTO uro_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Näkt nasot iangärhäkt aa enge dä qa es da aa qänäqaqa vät a rha näkt ka qoar toqortäqyia, “Ngäni rha ama Qloqaqa ama Qumärqumärqa. ");
INSERT INTO uro_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ngakt bä ngäni qyiradeng na aung aa anga vuirhong diva ma Ngämuqa qä qyiradeng nä irhong dap ngakt bä qaku ngän naqyiradeng na aung aa anga vuirhong diva qaku ma Ngämuqa qä naqyiradeng nä irhong.” ");
INSERT INTO uro_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Sokt di ma Tomas kärakni i rhat tes ka i ma Didimus i iaqyäkt ama ngärhipki at tarimini di ama mäsangaqa qärak i qa nävät ama ngärhäqyisem da udiom na rha ama mudäsaqongda di qaku qale qa qä na rha rhoqoräkt i ma Jisas sa qa män gem da. ");
INSERT INTO uro_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bä äkt i arhani ama mudäsaqongda di sa rhi qoar na qa rhoqortäqyia, “Sa ut lu ma Engeska!” Di nak ka qoar na rha rhoqortäqyia, “Ngakt bä qaku ngu nalu ama nilqäna angät bungbung ba aa rhäqyiglem dä qaku ngu narhäk ngua rhäktka mät ngät dä qaku ngu narhäk ngua rhäkt mäni aa brät diva qaku ngu namat maengäkt.” ");
INSERT INTO uro_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Näkt nasot ama ngärhäqyet da dävaung na ama qunäng dä saqi as kale ma Jisas aa mudäsaqongda va vät bä rhoqoräkt di qale ma Tomas kä na rha. Rhoqoräkt di saqi rha väs mät ama tmon mamär särhäm mes sokt di ma Jisas ka män bä qat mair mänguräp mä rha näkt ka qoar toqortäqyia, “Qale ama bulap gem ngän.” ");
INSERT INTO uro_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Dä qa qoar nä ma Tomas toqortäqyia, “Ngi rhäk ngia rhäktka rhe dä ngi lu gua rhäqyiglem. Ngi rhäk gia rhäkt inamuk bä ngi rhäk mäni gu brät. Qale gi snängaiom ama udiom dap sa ngiat nanakt.” ");
INSERT INTO uro_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Dä ma Tomas ka muvät i qä qoar na qa rhoqortäqyia, “Gua Engeska dä gu Ngämuqa!” ");
INSERT INTO uro_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Dä ma Jisas ka märhamän särhäm ga rhoqortäqyia, “Sa ngiat nanakt na ngo inguna äkt i sa ngia lu ngo. Ama modämne sävät iarhakt kärarhae i sa qaku rha lu ngo sokt di rhat nanakt.” ");
INSERT INTO uro_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Näkt ma Jisas di qa mualat na angätni ama rhäqäp ama muqunän ama nañis ngät da aa mudäsaqongda arhä saqong gärangätni i sa qaku ngua säm a ngät pä rhakt täkt ama abuk. ");
INSERT INTO uro_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Dap tangät täkt di sa ngua säm a ngät ivakt iva ngänät nanakt i ma Jisas di ma Krais ma Ngämuqa aa emga na qa bä va bä ba ngän na ama iar ama sok täm ngät nävät aa ngärhipki. ");
INSERT INTO uro_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nasot iangärhäkt dä saqi as päs dä ma Jisas bä aa mudäsaqongda rha lu qa vät ama namuqa aa rhäkt ma Taiberias kärakni i qosaqi i rhat tes ka i ama namuqa ma Galili. Näkt aa mänmänäs gem da di rhoqortäqyia. ");
INSERT INTO uro_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ma Saimon Pita qä nä ma Tomas kärakni i rhat tes ka i ma Didimus i iaqyäkt ama ngärhipki at tarimini di ama mäsangaqa näkt ma Nataniel nae ma Kana e ma Galili näkt ma Sebedi aa imiom näkt sävät aiomni ama mudäsaqongiom di västämne na rha e. ");
INSERT INTO uro_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Dä ma Saimon Pita qa qoar na rha rhoqortäqyia, “Aingo diva ngua rhet ngu rhon na ama väiu.” Dä rha qoar na qa rhoqortäqyia, “Va u rhet ut na nge.” Bä äkt i rha met bä rha muqun mät ama mlauski sokt di nävä iaqyäkt ama bängagi di qaku rha ar sä guani. ");
INSERT INTO uro_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bä nga rhoqoräkt i qunäga qunäga di sa qale ma Jisas i qat mair vät a qoan sokt di aa mudäsaqongda di qaku rha räm i ma Jisas na qa. ");
INSERT INTO uro_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Dä ma Jisas ka näs sävät a rha rhoqortäqyia, “Gua ruavek, nga qaku angän anga rhinäm?” Dä rha muvät toqortäqyia, “Qaku.” ");
INSERT INTO uro_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Dä qa qoar na rha rhoqortäqyia, “Ngäni rhon na angän bäiuqi särhage na ama mlauski säda märmär dä va ngäni ar sa agung.” Bä nga nasot i rha mualat toqoräkt dä sa qaku mamär vät a rha iva rhi ardrän na ama väiuqi savono sämät ama mlauski inguna nage ama rhinäm gärangätni i masirhat na ngät. ");
INSERT INTO uro_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Bä nga rha lu rhoqoräkt dä ama mudäsaqongga qärakni i ma Jisas aa snäng bät a qa mamär qa qoar nä ma Pita rhoqortäqyia, “Nak iak mit äkt di ma Engeska.” Bä nga rhoqoräkt i ma Saimon Pita qa nari qa i qä märhamän doqoräkt dä sa qa qop mäni nas na aa boiqi ama uiu qi inguna rhoqoräkt di sa qa set däm gi nävät aa nas bä qa rhon na nas säp koep. ");
INSERT INTO uro_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Dap arhani ama mudäsaqongda di rha väs aa rhäng mät ama mlauski i rhi rhardrän nä qä väiuqi qäraktni i rhäqäp ki na ama rhinäm inguna rhoqoräkt di qaku gläius samit sävät a qoan. Sa na äkt i qale rha e bä samit sävät a qoan di qorhäs na ama levaet na ama ruvek da ama ngärhäqyisem da sägäk na ama mitaqäna. ");
INSERT INTO uro_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Näkt nga rhoqoräkt i sa rha män mit pät a qoan dä rha lu ama rhinäm i qale ngät mät ama mudäbäs kärqosni i äs angärha iläñga qat dang näkt ama bretkäna. ");
INSERT INTO uro_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Ngäni rha agung anga rhinäm nävät kärangätni i sa ngäna ar sä ngät.” ");
INSERT INTO uro_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Dä ma Saimon Pita qa veng sämät ama mlauski bä qa ardrän na ama väiuqi samit sävät a qoan. Iaqyäkt ama väiuqi di rhäqäp ki na ama rhinäm ama mor ngät i ama rhodäm sä ngät di ama ngärhäqyet da udiom na ama ruvek da ama ngärhäqyisem da dävaung. Rhoqoräkt di nak täqäp ama väiuqi mamär sokt di qaku bäñmät na qi. ");
INSERT INTO uro_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Dä ma Jisas ka qoar na rha rhoqortäqyia, “Ngäni ang iva ngän däs.” Rhoqoräkt di qaku aung nävät ama mudäsaqongda qa mu aa snäng iva qä snanbät sä qa rhoqortäqyia, “Auge na nge?” inguna sa rhat dräm i qa di ma Engeska. ");
INSERT INTO uro_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Dä sa ma Jisas ka met sae dä qa rha ama bretkäna bä qa von da näkt kosaqi qa mualat toqoräkt sa ama rhinäm. ");
INSERT INTO uro_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Rhos täkt di ma Jisas aa däpguamek na äs ama mänmänäs sage aa mudäsaqongda nasot toqoräkt i qa märanas nämät ama tñäpki. ");
INSERT INTO uro_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Näkt nga rhoqoräkt i rha mäs bä rhäksot dä ma Jisas ka snanbät sä ma Saimon Pita rhoqortäqyia, “Saimon ma Jon aa emga, nga ngäktki i gia snäng bät a ngo masirhat mamär vät tärhärha rhäkt arhä väs?” Dä ma Saimon ga muvät pät a qa rhoqortäqyia, “Iei Engeska, sa ngiat dräm i sa gua snäng bät a nge.” Dä ma Jisas ka qoar na qa rhoqortäqyia, “Ngit bon gu sipsipkäna ama rhoes iva ngät täs.” ");
INSERT INTO uro_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Dä saqi as ka snanbät sä qa bä maunmem doqortäqyia, “Saimon ma Jon aa emga, nga ngäktki i gia snäng bät a ngo?” Dä sa qa muvät pät a qa rhoqortäqyia, “Iei Engeska, sa ngiat dräm i gua snäng bät a nge.” Dä ma Jisas ka qoar na qa rhoqortäqyia, “Ngit lu vät gu sipsipkäna.” ");
INSERT INTO uro_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Näkt kosaqi ma Jisas ka snanbät sä ma Saimon iva madäpguamek toqortäqyia, “Saimon ma Jon aa emga, nga gia snäng bät a ngo?” Bä nga rhoqoräkt dä ma Pita di qänäskänes ka masirhat inguna ma Jisas sa qa snanbät sä qa iva madäpguamek toqortäqyia, “Nga gia snäng bät a ngo?” Dä qa muvät pät a qa rhoqortäqyia, “Engeska, sa ngiat dräm iarhongäkt moe dä ngiat dräm i gua snäng bät a nge.” Dä ma Jisas ka qoar na qa rhoqortäqyia, “Ngit bon gu sipsipkäna iva ngät täs. ");
INSERT INTO uro_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nguat tamän särhäm nge na ama engäktki i sa rhoqoräkt i ama rhoemga na nge di ngiat donmät pät a nas dä ngiat tet parhäm gi snängaqa. Dap kre va ama sruqa na nge dä va ngi is ngia rhäqyisem bä va akni qat donmät pät a nge nakt kä rhoer nanokt nge sa äkt i qaku nani a nge iva ngi namet sae.” ");
INSERT INTO uro_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ma Jisas ka märhamän doqoräkt di na ama muqunäga sävät ma Pita aa tñäpki qäraktni iva qä ñäp ivakt iva qä von ma Ngämuqa rha ama murhämeska na qi. Näkt nasot iangärhäkt aa enge dä ma Jisas ka qoar na qa rhoqortäqyia, “Ngit päs gua rhäng!” ");
INSERT INTO uro_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Dä ma Pita qa rhong bät a nas dä qa lu ama mudäsaqongga qärakni i ma Jisas aa snäng bät a qa mamär i sa qat tet nasot a iom. Iaqäkt ama mudäsaqongga di iaqäkt kärak i sa qa an aa rhäng dä ma Jisas toqoräkt i rhat täs ma Pasova bä qa snanbät sä qa rhoqortäqyia, “Engeska, ngu lu va auge qä vodäm nge sävä gia ikkäna arhä rhäkt?” ");
INSERT INTO uro_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Näkt nga rhoqoräkt i ma Pita qa lu qa dä qa snanbät sä ma Jisas toqortäqyia, “Engeska, dap taerhak ama ruqa diva rhoqor mäniekt na qa?” ");
INSERT INTO uro_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Dä ma Jisas ka muvät toqortäqyia, “Ngakt bä nani a ngo iva qat däqäm bä dängdäng i evär däm ngo dä mäniekt bä qänäskänes nge sä qa? Mamär iva ngit päs gua rhäng.” ");
INSERT INTO uro_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Bä nga nävät tangät täkt aa enge dä vräs da ama enge ge ama qatnanaktpämda iva rhak täkt ama mudäsaqongga diva qaku qä nañäp. Sokt di ma Jisas di qaku qa qoar iva qaku qä nañäp dap kinak ka qoar toqortäqyia, “Ngakt bä nani a ngo iva qat däqäm bä dängdäng i evär däm ngo dä mäniekt bä qänäskänes nge sä qa?” ");
INSERT INTO uro_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Rhak täkt di ama mudäsaqongga qärakni i qä sameng sävät tärhong däkt bä qa di sa qa säm irhong. Näkt sa ut dräm i aa sameng di ama engäktki na ngät. ");
INSERT INTO uro_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Näkt ma Jisas di qosaqi qa mualat na angätni ama lat masirhat. Ngakt bä vadi mai rhi säm a ngät moe dä nguat tu gu snäng i mamär iva qaku anga släqyimek pät ama ivätki moe nanokt ama abukkina qärangätni iva rhi säm iangärhäkt ama lat moe väm ngät. ");
INSERT INTO uro_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiofilus, pä gua abuk ama narhuir qi di sa ngua säm sävät iarhongäkt kärqärhong i mäqi ma Jisas ka nasäng iva qat tualat nä irhong dä qä nasäng iva qä su sävät irhong ");
INSERT INTO uro_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","bä dängdäng sävät iaqäkt ama qunäga qärakni i sa ma Ngämuqa qa rha qa rhävit sa rhävono. Rhoqoräkt di nasot dä qa voda ama rhodräp nävät ama Qloqaqa ama Qumärqumärqa bä ba ama ngangda sä ma Ngämuqa aa lat kärarhani i sa qa armeng däm da. ");
INSERT INTO uro_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Vät ama ruiom ama udiom na ama qunäng nasot aa märänga ama mor qa dä qär qur a nas gem da dä qat tualat na ama rhäqäp nä irhong gärqärhongni iva irhong ngärhi sameng i ngäktki i ama ngätdäqäm ga. Bä qat tamän sävät ma Ngämuqa aa Muräktpäm. ");
INSERT INTO uro_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Bä nga rhoqoräkt i qale qa gem da dä qa von da rhä rhangät täkt ama enge na ama muqunäga rhoqortäqyia, “Qale ngän namet nae nämät ama värhäm ama mor äm ma Jerusalem dap pa qale ngän nani ama vänbon gärangätni i mudu ama Ngätmamäk ka mumänaris na ngät kärangät i ngänät nari ngo i sa nguat tamän sävät a ngät. ");
INSERT INTO uro_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Iangärhäkt dinguna ma Jon sa qä baptais pät ama ruvek na ama rigi dap pa nasot ama marheka na ama qunäng dä va ngu baptais pät a ngän na ama Qloqaqa ama Qumärqumärqa.” ");
INSERT INTO uro_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Bä äkt i nga rhoqoräkt i sa västämne na rha rhi nä ma Jisas dä rhi snanbät sä qa i rhi qoar toqortäqyia, “Engeska, nga rhoqor täkt diva saqi as ngia rhumamär na ama Israelqäna arhä muräktpäm?” ");
INSERT INTO uro_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Dä qa muvät pät a rha rhoqortäqyia, “Qoki qaku ngän angän gäni ianiäkt iva ngäni räm ama qunäng bä ama rhodäm gärangätni i sa ma Ngämuqa qa mu ngät parhäm aa snängaqa maräkt. ");
INSERT INTO uro_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Dap pa ngäni rha ama qrot toqoräkt i sa ama Qloqaqa ama Qumärqumärqa qä rhäk pät a ngän bä va ngäni sameng sävät a ngo e ma Jerusalem bä säva ama ngärhäqyiom ma Judia dä ma Samaria bä sävät ama ivätki at tärhäkt moe.” ");
INSERT INTO uro_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Bä nga qat tamän doqoräkt bä rhäksot dä släqyäs pa aa qar bä qa an dävit da arhä saqong bä ama eqoeqi qia ong ga da arhä saqong. ");
INSERT INTO uro_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bä qoki as tat nañäm säva usäp toqoräkt i qat tet pävit dä väs da ama ruiom masägos kärqiomni i in boi ama qulum ngät bä inät mair gem da. ");
INSERT INTO uro_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Dä ini qoar na rha rhoqortäqyia, “Aruvek näva ama ngärhäktka ma Galili, mäniekt bä ngänät mair täkt bä ngänät nañäm säva usäp? Rhak täkt ama ruqa ma Jisas kärak i sa ma Ngämuqa qa rha qa rhävit säda ama usäpki arha ron nagem ngän di qoki va evär däm ga rhoqor nas toqoräkt i ngän lu qa i qa an dävit säda ama usäpki arha ron.” ");
INSERT INTO uro_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nasot dä evär däm da bä sae ma Jerusalem näda ama damgi ama gaini na qi ama Damgi na ama Olip at täväs. Rha met sämät ama värhäm ama mor äm di ngi qoar qre i ama tmerhäs da ama kilomita näkt ama qäväläm angärha ron. ");
INSERT INTO uro_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bä nga rha män e ma Jerusalem dä dang däm da da ama vätka aa ron sämät aomni ama qäväläm inavuk kärqomni i rhat tas e. Iarhakt kärarhae i qale rha e di ma Pita qä nä ma Jon dä ma Jems näkt ma Andru dä ma Filip näkt ma Tomas dä ma Bartolomyu näkt ma Matyu dä ma Jems ma Alfius aa emga näkt ma Saimon gärakni i qa nämäni ama Selotkäna näkt ma Judas ma Jems aa emga. ");
INSERT INTO uro_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Vasägos dä väspästämne na rha sa ama snängaqa ama sägäk ivakt iva rhi nän. Rhoqoräkt di rhi na ama evop näkt sävät ma Maria ma Jisas aa nanäk näkt sävät aa läktpek. ");
INSERT INTO uro_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Dä vät iangärhäkt ama qunäng dä ma Pita qa mair mänguräp ama qatnanaktpämda i ama guläñgi na rha di ngäkt kre ama ruvek ama ngärhäqyet da sägäk na rha moe. Näkt kä qoar toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Gua ruavek, ma Ngämuqa aa enge qärangätni i mudu sa rha säm a ngät di qoki va rhäkmamär na ngät parhäm ngät kärangät i nak sa mudu ma Devit ka märhamän bät a ngät nävät ama Qloqaqa ama Qumärqumärqa sävät ma Judas i qa diva ama iska na qa bä bä iarhakt kärarhae iva rhi sangar ma Jisas. ");
INSERT INTO uro_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Qa di ak na qa nämäni ut inguna qä na ut ut met sa ama sameng mät a vät. ");
INSERT INTO uro_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ma Judas di qa vodäm bät ama ivärhäm na ama ligär qärangätni i sa rha sek mä qa na ngät pät aa lat ama vu ngät angät tpäs. Qa veng nas pät iomäkt ama ivärhäm i qa säp na rhävuk nämät a leqäs i aa uväski qia er nanokt ka bä samäk dä vukdur va aa sarimgi bä vuk sa aa qusem sä dalek. ");
INSERT INTO uro_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ama ruvek moe e ma Jerusalem da nari rhoqor täkt sävät ma Judas bä äkt i rha mes iomäkt ama ivärhäm na arha enge i Akeldama di ama rharimini di rhoqortäqyia, ma Etki na ama Biaska.” ");
INSERT INTO uro_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ma Pita qä qoar toqortäqyia, “Inguna ma Ngämuqa aa enge qärangätni i sa rha säm a ngät pa ama Abuk na ama Mabu di ngät tamän doqortäqyia, “‘Mamär iva ama dungdung aa vätka bä va qale aung gat tas päm ga.’ Dä qosaqi ngät tamän doqortäqyia, “‘Mamär iva aung gä rha iosäkt aa släqyäs bä va qale ama nengäs da aa lang.’ ");
INSERT INTO uro_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Bä qoki rhoqor täkt di mamär iva urhi armeng da aung anga gamoeqa nävät iarhakt kärarhae i ma ut moe ut tet dä iangärhäkt ama rhodäm moe angärha ron gärangätni i ma Engeska ma Jisas sa qale qa qä na ut ");
INSERT INTO uro_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","mänasäng na äkt i ma Jon ga baptais pät a qa bä dängdäng bät iomäkt ama qäväläm gärqomni i ma Jisas ka an dävit ivakt iva aung nävät tärha rhäkt diva qoki qä na ut ut tet sa ama sameng sävät ma Jisas i qa märanas nämät ama tñäpki.” ");
INSERT INTO uro_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bä äkt i rha mu ama gamuiom ama udiom i ma Josep na qa ma Barsabas kärakni i qosaqi rhat tes ka i ma Jastus näkt sävät ma Matias. ");
INSERT INTO uro_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Näkt ta nän doqortäqyia, “Engeska, sa ngiat dräm mamär na ama ruvek moe arhä mungäsnäng. Mamär iva ngi qur a ut i auge nävät tiom däkt di sa ngia armeng däm ga ");
INSERT INTO uro_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ivakt iva qä rha nasot sä rhangät täkt ama lat iva ama ngangga na qa iva qä rha ma Judas aa släqyäs kärqosni i ma Judas sa qa met nämät äs ivakt iva qa rhet sa äkt i qoki mänaris iva qa rhet sae.” ");
INSERT INTO uro_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dä rha mualat parhäm arha morta arhä qärhong na ama armengdäm bä sa rha mon sä ma Matias sae sämäni ama ngärhäqyisem da sägäk na rha ama ngangda. ");
INSERT INTO uro_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Bä nga sädamär na ama qunäga qärakni i rhat tes ka i ma Pentikos dä sa ama qatnanaktpämda di västämne na rha vät ama ivärhäs ama sägos. ");
INSERT INTO uro_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Dä rha särmändäm masägos i rhat nari i arus i ngäkt kre ama laurqi ama qrot ki i qi e na rhävono inavuk bä qia rhäqäp ama vätki moe iaqyäkt kärakt i qale rha e i rhat muqun bäm gi. ");
INSERT INTO uro_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bä rha lu iangärhäkt kärangät i ngät toqor ama qoebañ na ama rhäptäpki qärangätni i vräsmät na ngät bä ngä muqun bät a rha moe ak dä ak na rha. ");
INSERT INTO uro_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Rha moe di ama Qloqaqa ama Qumärqumärqa qa rhäqäp ta na nas bä rhi nasäng i rhat tamän na arhani ama ruvek arha enge nävät ama Qloqaqa ama Qumärqumärqa. ");
INSERT INTO uro_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Näkt toqoräkt di sa qale arhani ama Judaqäna e ma Jerusalem gärarhani i ama engäktki na rha sage ma Ngämuqa qärarhae i rha nävät ama ivärhimek moe. ");
INSERT INTO uro_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bä nga rhoqoräkt i rha nari i arus dä ama guläñgi na ama ruvek di väspästämne na rha bä rhit särmändäm bä adädän da masirhat inguna ak dä ak na rha di sävetka qat nari aa enge maräkt i qä qatnanaktpämda rhat tamän na ngät. ");
INSERT INTO uro_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bä qräk mät ta mamär dä rhi qoar toqortäqyia, “Rhärha rhäkt ama gamoe qärarhani i rhat tamän doqoräkt di nak ama Galiliqäna. ");
INSERT INTO uro_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Bä rhoqor täkt dä mäniekt bä ak dä ak nävät a ut di sa ut nari i rhat tamän na aurha enge maräkt? ");
INSERT INTO uro_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Bä ut nari i rhat tamän na ama enge bä ba ama ruvek näva ama ngärhakt ma Partia näkt ma Midia näkt ma Elam näkt ma Mesopotemia näkt ma Judia näkt ma Kapadosia näkt ma Pontus näkt ma Esia ");
INSERT INTO uro_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","näkt näva ama ngärhakt ma Frigia näkt ma Pamfilia näkt ma Isip näkt nävät ama qävälap pa ama ngärhäktka ma Libia glaqot na ama värhäm ama mor äm ma Sairini dä arhani ama tmända näva ama värhäm ama mor äm mamär ma Rom. ");
INSERT INTO uro_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Iarhakt ama tmända di ama Judaqäna bä sävät ama ruvek kärarhani i sa rha näpgoer na nas sämäni ama Judaqäna. Dä qosaqi ut nari ama enge bä ba ama ruvek näva ama urqa ma Krit näkt näva ama ngärhäktka ma Arebia bä ut nari rha i rhi sameng na aurha enge maräkt sävät ma Ngämuqa aa lat ama qrot ngät.” ");
INSERT INTO uro_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bä rha moe di qräk mät ta bä adädän da masirhat dä rhi snanbät sä ne rhoqortäqyia, “Ama rharimini mäniekt sä rhangät täkt ama lat?” ");
INSERT INTO uro_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Dap arhani ama ruvek di nak tat tuma rha i rhi qoar toqortäqyia, “Iarhakt di sa rha nakt ama wain masirhat.” ");
INSERT INTO uro_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Sokt di ma Pita qa mair ge ama ngangda bä qa sek aa eguinga bä qä sameng ba ama guläñgi nä qa ruvek toqortäqyia, “Aruvek nae ma Judia bä aingän moe qärarhae i rhat tas e ma Jerusalem, däkt diva ngua rhuqunäga vät a ngän sävät tangät täkt ama lat kärangät i sa ngä märanas. Ngänät nari mamär na ama enge qärangätni iva nguat tamän bät a ngät. ");
INSERT INTO uro_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Qale ngän du angän snäng i rhaerhärhae ama gamoe di sa rha nakt ama wain bä guani na rha i nak kop as nguna rhäkt di ama ngärhäqyet da levaet nä irhong bät duququs. ");
INSERT INTO uro_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Dap tangät täkt ama lat kärangätni i sa ngä märanas di qärangät i ma Ngämuqa sa qa märhamän sävät a ngät nämät aa vämginaqa ma Joel toqortäqyia, ");
INSERT INTO uro_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Ma Ngämuqa qa qoaräs toqortäqyia, ‘Va vät ama dängdängini na ngät ama rhodäm dä va ngu rhor nä gu Qloqaqa sävät ama ruvek moe. Bä va angän oes ama gamoe dä angän oes ama evop diva rhat tamän bät ama enge qärangätni i ngät dän maräkt nagem ngo. Dä va angäna evända ama gamoe diva rhit lu ama ñämñäm. Dä va angän sru rha ama gamoe diva rhit lu ama masirhäm. ");
INSERT INTO uro_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Bä qäqi va ngu rhor nä gu Qloqaqa vät iangärhäkt ama rhodäm sävät gua latta moe ama gamoe dä ama evop bä va rhat tamän bät ama enge qärangätni i ngät dän maräkt nagem ngo. ");
INSERT INTO uro_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Bä va ngua rhualat na ama lat kärangät i ngät dän masärmän mät ama leqäs dä ama muqunän mana vät ama ivätki. Ama biaska dä ama rhäptäpki dä ama rhämän bäm gi ama butbutki diva ngät täranas. ");
INSERT INTO uro_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Bä nga narhoer vä iaqäkt ama moräs na qa mas ama qunäga aa qamäs kärak iva ma Engeska qat tatnävämne na ama ruvek dä va bängangit pät ama qunäga aa saqong dap pa ama equngi diva qurät ki rhoqor ama biaska. ");
INSERT INTO uro_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Näkt toqoräkt di guavek koe qärarhani i rhit näs sage ma Engeska diva maiar na rha.’” ");
INSERT INTO uro_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Näkt sa ma Pita qä qoaräs na rha rhoqortäqyia, “Aruvek nae ma Israel, as ngäni nari rhaerhangät ama enge. Ma Jisas nae ma Nasaret di ama ruqa qärakni i sa ma Ngämuqa qa qur a ut täm ga mamär i qa di sa qa män nagem ga nage aa lat ama nañis ngät dä ama lat kärangätni i ngät dän masärmän dä ama muqunän. Rhangät täkt di sa ma Ngämuqa qa mualat na ngät nä ma Jisas mänguräp mä ngän bä rhoqoräkt di sa ngänät dräm a ngät. ");
INSERT INTO uro_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Rhak täkt ama ruqa di sa rha vodäm ga bä ba ngän näkt aingän bä sävät ama ruvek ama vu rha masirhat sa arhä matnärhäm di sa ngän moe ngän beng ga i ngäna edämsäs pät a qa mäni ama sämänanamuqa. Rhangät täkt moe ama lat di varhäm ma Ngämuqa aa snängaqa bä qa di sa qat dräm doqoräkt narhoer va angät kamäs. ");
INSERT INTO uro_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sokt di ma Ngämuqa qa märanas na qa nämät ama tñäpki bä qa muisiska vät a qa nämät ama ruanini qärqäni i ama tñäpki inguna qaku mamär vät ama tñäpki iva qi nasangar säva aa rhäng. ");
INSERT INTO uro_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Inguna mudu ma Devit ka märhamän sävät ma Jisas toqortäqyia, “‘Nguat lu ma Engeska i qa e vä gu qamäs pasägos. Bä qaku mamär vät ama ruvek iva rhi namäqäne dä mamär na ngo inguna qa e gem ngo. ");
INSERT INTO uro_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Bä nga rhoqor täkt dä märmär gem ngo bä ngu qok dä nguat tamän bät ama enge na ama märmärgem bä qosaqi va mämae vät gu släqyige mamär va aa luvät ");
INSERT INTO uro_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","inguna nge diva qaku ngi namet daqule ngo va ama ñäpta arha ivärhäs bä qosaqi va qaku ngi naqyiradeng nä gi Qumärqumärqa aa släqyige bä va säkt täm ige. ");
INSERT INTO uro_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Dä sa ngia muqunäga vät a ngo sa ama is säva ama iar ama sok täm ngät bä va ngi rhäqäp ngo na ama märmärgem masirhat nä gi qäranas.’” ");
INSERT INTO uro_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Dä ma Pita qä qoar toqortäqyia, “Gua ruavek, mamär vät a ngo iva ngu qoar na ngän mamär na ama engäktki i ama ngätmamäk ma Devit di sa qa ñäp bä rha mu aa släqyige mät ama liqi bä iaqyäkt aa liqi di qop as kia e gem ut bä dängdäng däkt. ");
INSERT INTO uro_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Sokt di qa di akni na qa qärakni i ma Ngämuqa aa vämginaqa bä qat dräm i ma Ngämuqa sa qa musärhämes iva qa rhu ma Devit anga aka nämäni aa enevaqi mugas nasot kärak iva qä rha ma Devit aa vitnaqa aa mämugunäs nasot a qa. ");
INSERT INTO uro_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","“Bä nga rhoqoräkt dä ma Devit di qat dräm i rhangät täkt ama lat diva ngä rhäranas narhoer bä äkt i qa märhamän sävät ma Krais aa tñäpki iva nasot diva qa rhäranas nämät ama tñäpki dä va qaku ma Ngämuqa qä namet daqule qa va ama ñäpta arha ivärhäs bä qop pa qaku qä naqyiradeng na qa bä va säkt ta aa släqyige. ");
INSERT INTO uro_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Rhak täkt ma Jisas di iaqäkt kärak i ma Ngämuqa qa märanas na qa nämät ama tñäpki bä aiut moe rhäkt di sa ut lu mamär nä iaqyäkt ama engäktki i qa märanas bä ama iar qa. ");
INSERT INTO uro_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","“Bä ma Jisas di qa märanas näkt ka an dävit sa rhävuk säda ama usäpki arha ron bä qa e dä ma Ngämuqa aa märmär bä sa qa rha ama Qloqaqa ama Qumärqumärqa nage ama Ngätmamäk kärakni i mudu qa mumänaris iva qä von ma Jisas täm ga. Bä rhäkt di sa ma Jisas ka von dä iaqäkt ama Qloqaqa bä ba ut bä qat täranas nä rhangät täkt ama lat kärangät i ngänät lu ngät bä ama enge qärangät i ngänät nari ngät. ");
INSERT INTO uro_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“Näma dä ma Devit di qaku qa an dävit sa rhävuk sokt di qa qoar toqortäqyia, “‘Ma Ngämuqa qä qoar nä gua Engeska rhoqortäqyia, “Ngia rhuqun dä gu märmär bä qale nge e ");
INSERT INTO uro_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","bä dängdäng iva ngua rhän näp gia ikkäna arhä väs bä va rha rhän i ama laiqa na rha nanokt gia qäriglem.” ’ ");
INSERT INTO uro_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Dä soknga mamär iva ama Israelqäna moe diva qunäga vät a rha rhoqortäqyia, ma Jisas kärakni i sa ngäna edämsäs pät a qa di qa di sa ma Ngämuqa qa muqunän bät a qa iva aurha Engeska bä ma Krais na qa.” ");
INSERT INTO uro_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bä nga ama ruvek ta nari rhoqor täkt dä ama enge ngä qut da arha ron dä rhi snanbät sä ma Pita qä na arhani ama ngangda rhoqortäqyia, “Aurha ruavek, ngu lu mamär iva ut mäsana?” ");
INSERT INTO uro_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Dä ma Pita qa muvät pät a rha rhoqortäqyia, “Ngän moe asägäk asägäk diva ngi näpgoer na nas nämät angäna vuirhong näkt pa ngäni rha ama baptais nävät ma Jisas ma Krais aa ngärhipki dä va ma Ngämuqa va qä qyiradeng na angäna vuirhong näkt pa ngäni rha ama vänbon na ama Qloqaqa ama Qumärqumärqa. ");
INSERT INTO uro_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Rhangät täkt ama mumänaris di ngät bä ba ngän dä bä ba angän oes dä bä bä iarhakt kärarhae i qale rha gläius dä bä bä qärarhani moe iva ma Engeska aut Ngämuqa qä rhar sä rha sagem mes.” ");
INSERT INTO uro_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ma Pita qät don sävät ama ruvek mauiu dä qat naing bät a rha i qä qoar na rha rhoqortäqyia, “Ngän dumaiar nas nämät tit täkt ama qoengait ama vu it.” ");
INSERT INTO uro_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bä iarhakt kärarhae i rha mat maengäkt sä ma Pita aa sameng di rha baptais pät a rha bä rhoqoräkt di ngäkt kre ama dävaung ama tausengäna na ama ruvek ta män sae sämäni ama qatnanaktpämda. ");
INSERT INTO uro_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bä rha vodäm mes säda ama ngangda arhä rhisu angärha ron bä vasägos dä väspästämne na ama qatnanaktpämda moe bä rhat täs dä rhi nän. ");
INSERT INTO uro_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ma Ngämuqa di qat tualat na ama lat masirhat kärangätni i ngät dän masärmän bä sävät ama muqunän nävät ama ngangda arha lat bä ama ruvek moe e ma Jerusalem di qräkräk mät ta masirhat toqoräkt. ");
INSERT INTO uro_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bä iarhakt moe ama qatnanaktpämda di vasägos dä väspästämne na rha sa ama snängaqa ama sägäk dä rhit bon na ne rha arhä qärhong moe. ");
INSERT INTO uro_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Dä rhit boda arhä qärhong dä arhä gunän nani ama ligär bä rhat tatmät na ngät ba ne varhäm sävetka aa tläqa. ");
INSERT INTO uro_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Dä vät ama qunäng moe dä rhit täqäs däm ne i väspästämne na rha va ama ansäspämgi ama mor qi dä väspästämne na rha va ama vät asägäk asägäk bä rhit bonmät na ama bret näkt tat täs sa ama märmärgem dä sa ama snängaqa ama räkt ka. ");
INSERT INTO uro_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bä ama ruvek di rhi nänsäs sage ma Ngämuqa dä ama ruvek moe di märmär gem da nävät ama qatnanaktpämda. Näkt pät ama qunäng moe asägäk asägäk di iarhakt kärarhae i ma Ngämuqa qat tumaiar ta di qat tu rha sae sävät ama rhodäm sa ama qatnanaktpämda. ");
INSERT INTO uro_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Vät akni ama qunäga dä ma Pita qä nä ma Jon in det pävit säva ama ansäspämgi ama mor qi inguna rhoqoräkt di ama qäväläm na ama nän bät ama däpguarhong säpbängang. ");
INSERT INTO uro_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Dap toqoräkt di ama ruvek tit ta akni ama ruqa qärakni i mudu rha sa qa i ama väva rhäm ga bä sämät ama ansäspämgi ama mor qi arha edäbäs kärqosni i rhat tes äs i ma Mär Qi ama Ñämñämgi. Rhat tu qa e vät ama qunäng moe ivakt iva qä nän da ama ligär nage iarhakt kärarhae i rhat don iva säva ama ansäspämgi ama mor qi. ");
INSERT INTO uro_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Bä nga qa lu ma Pita qä nä ma Jon i qorhäs iva in don säva ama ansäspämgi ama mor qi dä qa nän sävät a iom nani anga ligär. ");
INSERT INTO uro_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Dä ma Pita qä nä ma Jon in ñäm maräkt sävät a qa näkt ma Pita qa qoar na qa rhoqortäqyia, “Ngi ñäm sävät a un.” ");
INSERT INTO uro_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Bä äkt i qä vävarhämga qa ñäm sävät kärqiom masirhat i qat tu aa snäng iva qä rha guani nagem iom. ");
INSERT INTO uro_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Dap kinak ma Pita qa qoar toqortäqyia, “Qaku gu nga ligär dap pa ngu von nge rha agini qärqäni i ini nga e gem ngo. Di nävät ma Jisas ma Krais nae ma Nasaret aa ngärhipki di ngiat tet.” ");
INSERT INTO uro_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Näkt ka sangar aa märmäret näkt ka mair na qa namäk dä qop äkt dä ma Ngämuqa qa sämaqrot nä qa ruqa aa qar. ");
INSERT INTO uro_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Dä qop ka rhon na nas namäk bä qa mair näkt kä nasäng i qat tet. Dä qa met kä na iom säva ama ansäspämgi ama mor qi bä qat tet dap kät don na nas dap kä nänsäs sage ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bä nga ama ruvek moe rha lu qa i qat tet dap kä nänsäs sage ma Ngämuqa ");
INSERT INTO uro_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","dä rha räm a qa i nak kop ama sägäk na qa ama ruqa iaqäkt kärak i vasägos dä qat muqun dap kä nän ama ruvek ta ama ligär mät ama ansäspämgi ama mor qi arha edäbäs kärqosni i rhat tes äs i ma Mär Qi ama Ñämñämgi. Rha lu rhoqoräkt dä qräk mät ta masirhat dä rhat tu arhä snäng masirhat sävät ama lat kärangätni i sa ngä märanas pät a qa. ");
INSERT INTO uro_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bä rhoqoräkt i qat nangärhäkt dä ma Pita qä nä ma Jon dä ama ruvek moe di qräk mät ta masirhat dä rha ang masirhat sagem da vät ama ansäspämgi arha ivärhäm at käväläm gärqomni i rhat tes äm i ma Solomon Aa Suqulap. ");
INSERT INTO uro_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Bä nga ma Pita qa lu ama ruvek toqoräkt dä qä qoar na rha rhoqortäqyia, “Aruvek nae ma Israel, mäniekt bä qräk mät ngän nävät tangät täkt ama lat? Mäniekt bä ngänät lu ut masirhat? Varis ngän du angän snäng i aiut nävät aut krot maräkt ura nävät aurha iar ama räkt ngät dä ma Ngämuqa aa saqong bä mä rhak täkt ama ruqa bä va qat tet. ");
INSERT INTO uro_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Iaqäkt ma Ngämuqa qärak i ma Abraham gä nä ma Aisak dä ma Jekop arhä Ngämuqa bä qosaqi qärak i aurha morta arhä Ngämuqa na qa di sa qa vuk sa ama murhämeska vät aa latka ma Jisas. Qa di sa aingän ngän bodäm ga iva rhi veng ga bä ngän goer qa ge ma Pailat dap sokt di ma Pailat sa qa muräkt iva qä rhäväkt sä qa. ");
INSERT INTO uro_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","“Sa ngän goer iaqäkt kärak i ama Qumärqumärqa Mamär dä ama Räktka na qa dap kinak ngän nän ma Pailat iva qä rhäväkt sa akni ama ruqa qärakni i qat dräm gä veng. ");
INSERT INTO uro_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Bä ngän beng ama iar angät tarebäm gärakni i ma Ngämuqa qa märanas na qa nämät ama tñäpki bä sa ut lu iangärhäkt ama lat toqoräkt. ");
INSERT INTO uro_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Rhak täkt ama ruqa qärak i ngänät lu qa bä ngänät dräm a qa qärak i sa märäs pät a qa bä ama qrot pät a qa di nak märäs pät a qa nävät ama qatnanakt mäni ma Jisas aa ngärhipki. Bä sa ngänät dräm doqoräkt dinguna iangärhäkt ama lat di sa ngä märanas mänguräp mä ngän moe. ");
INSERT INTO uro_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Gua ruavek, rhäkt di sa nguat dräm i sa ngän mualat nä iangärhäkt ama lat ama vu ngät sä ma Jisas di rhoqoräkt di qaku qunäga vät a ngän mamär sä iangärhäkt bä qosaqi angän narhoerta. ");
INSERT INTO uro_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Sokt di iangärhäkt ama lat di sa ngä märanas ivakt iva ma Ngämuqa aa enge qärangätni i mudu qa märhamän bät a ngät mät aa vämginarha moe diva rhäkmamär na ngät. Iangärhäkt ama enge di ngät tamän i ma Krais diva qa rhon säda ama märänga ama mor qa aa ron. ");
INSERT INTO uro_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Bä äkt iva ngäni näpgoer na nas näkt pa ngäni rhong sävät ma Ngämuqa ivakt iva qä qyiradeng na angäna vuirhong dä ama qäväläm na ama mämaevät ama mär äm diva äm ngä rhän nage ma Engeska. ");
INSERT INTO uro_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Dä va qä rhäk nä ma Krais bä ba ngän gärakni i ma Jisas kärak i mudu ma Ngämuqa qa muqunän bät a qa bä ba ngän. ");
INSERT INTO uro_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Mamär iva qale ma Jisas tävono da ama usäpki arha ron bä dängdäng iva iangärhäkt ama lat moekt kärangät i mudu ma Ngämuqa qa märhamän bät a ngät nämät aa vämginarha diva qa rhumamär na ngät. ");
INSERT INTO uro_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Rhoqor ma Moses i qa qoar toqortäqyia, ‘Va ma Engeska ma Ngämuqa va qä vuk sa akni aa vämginaqa bä ba ngän nä mänguräp angäna ruvek kärakni iva qa rhoqor ngo bä va ngänit päs iangärhäkt aa enge angärha rhäng moekt kärangät i qat tamän bät a ngät ba ngän. ");
INSERT INTO uro_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Bä aung gärakni i qaku qat nari nämät ka diva qäbäs na qa nä mänguräp ma Ngämuqa aa ruvek.’ ");
INSERT INTO uro_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Bä ngäktki i iarhakt moe ma Ngämuqa aa vämginarha qärarhae i mänasäng nävät ma Samuel bä inamäk di rha märhamän sävät tangät täkt ama rhodäm. ");
INSERT INTO uro_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Aingän di bä ba ngän nä ma Ngämuqa aa vämginarha arhä mumänaris näkt ama rharesbane angät modämne di ngät bä ba ngän gärangätni i sa mudu ma Ngämuqa qa mualat na ngät kä nä ma Abraham gärangät i ngät tamän doqortäqyia, ‘Va nävät gia enevaqi diva ngua rhodämne na ama ruvek moe vät ama ivätki.’ ");
INSERT INTO uro_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nga rhoqoräkt i ma Ngämuqa qa märanas na aa latka dä qa er qa rhäk na qa sagem ngän ivakt iva qa rhodämne na ngän i qä näpgoer na ngän asägäk asägäk nämät sävetka aa lat ama vu ngät.” ");
INSERT INTO uro_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Bä as nga rhoqoräkt i ma Pita qä nä ma Jon in damän särha ama ruvek dä ama Judaqäna arhä priskäna näkt ama narhoerqa ba ama ulaqimärharhärhäkt näva ama ansäspämgi ama mor qi näkt sävät ama Sadyusiqäna rha män gem iom. ");
INSERT INTO uro_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nak arusus pät a rha masirhat inguna ama ngangda di rhi su ama ruvek dä rhi sameng i ma Jisas ka mu ama iska ivakt iva ama ruvek pa rhit ñäp näkt pa nasot dä va rha rhäranas. ");
INSERT INTO uro_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bä äkt i rha sangar ma Pita qä nä ma Jon näkt ta mu iom ba ama tpäskiarharhäng iva sa duququ dä va rha rhuqun sä iom i sa nguna bängangäs. ");
INSERT INTO uro_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Dap ama rhäqäp na rha ama ruvek kärarhani i rha nari ama ngangda arha enge di rhat nanakt na ngät bä ama rhodäm sa ama gamoe di ngä män bät ama ngärhäqyet ama tausengäna. ");
INSERT INTO uro_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Qale bä nga duququ dä ama narhoerta dä ama morta bä ba ama Judaqäna näkt sävät ama Skraipkäna di sa västämne na rha e ma Jerusalem. ");
INSERT INTO uro_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Dap mänguräp mä rha di qale ma Anas ama pris ama vit na qa näkt sävät ma Kaiafas kä nä ma Jon gä nä ma Aleksander näkt sävät arhani ama gamoe moe nämäni ama pris ama vit na qa aa qärhae. ");
INSERT INTO uro_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bä nga rhoqoräkt i sa rha mair nä ma Pita qä nä ma Jon da arhä saqong dä rhi nasäng i rhi snanbät sä iom doqortäqyia, “Auge qa von en da ama qrot bä nävät auge aa ngärhipki dä in mualat nä iangärhäkt ama lat?” ");
INSERT INTO uro_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Dä ma Pita di rhäqäp ka na ama Qloqaqa ama Qumärqumärqa dä qa muvät pät a rha rhoqortäqyia, “Aingän ama narhoerta ba ama ruvek bä sävät a ngän ama morta, ");
INSERT INTO uro_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ngakt bä nga rhäkt di ngän mair na un ba ama muräkt nävät ama lat ama mär ngät kärangätni i ngä märanas pät tärhak ama vävarhämga dä ngäni snanbät sä un i qa rha ama mumäräspät toqor mäniekt ");
INSERT INTO uro_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","diva un duqunäga vät a ngän aingän ama ruvek moe nae ma Israel toqortäqyia, erhak täkt ama ruqa qärak i sa märäs pät a qa bä qat mair da angän saqong di nak ka rha ama mumäräspät nävät ma Jisas nae ma Nasaret ma Krais aa ngärhipki iaqäkt kärak i sa ngäna edämsäs pät a qa mäni ama sämänanamuqa bä qärak i ma Ngämuqa qa märanas na qa nämät ama tñäpki. ");
INSERT INTO uro_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iaqäkt di ama duiqa qärak i mudu aingän gärarhae i ngänät dräm ngänit täk pät ama vät ngän mer mä qa di nak kärak iaqäkt i rhäkt di ama qrot ama vätki nagem ga qärak i qat sangar a qi moe. ");
INSERT INTO uro_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Qaku ngi namän bät ama mumaiar ge aung saqi as inguna qaku agukt anga ngärhipki rhe vät ivät käraktni iva urhit ta ama mumaiar nävät a qi.” ");
INSERT INTO uro_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bä nga rha lu rhoqoräkt i ma Pita qä nä ma Jon di ama qraräk iom sa ama enge sokt di ama ruiom nämät a vät kärqiomni i sa qaku in su sävät ma Ngämuqa aa Muräkt pa anga rhisu dä qräk mät ta dä qunäga vät a rha i nak tiom däkt di sa mudu di qali liom ge ma Jisas. ");
INSERT INTO uro_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Dap kaku arha anga enge sävät a iom inguna rhat lu qa ruqa qärak i sa qa rha ama mumäräspät i qat mair e gem iom. ");
INSERT INTO uro_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bä äkt i rha rhäk na iom iva as puk sä iom nädä ma Sanedrin arhä saqong dä rhi nasäng i rhat tamän särhäm ne sävät a iom. ");
INSERT INTO uro_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Dä rhi snanbät sä ne rhoqortäqyia, “Va ut mäsana nä rhiom däkt ama ruiom inguna ama ruvek kärarhani i rhat tas e ma Jerusalem di rhat dräm i in mualat na ama enges ki ama muqunängi bä qaku mamär vät a ut iva ut narhäqyas na qi? ");
INSERT INTO uro_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Dap nga nani a ut iva qale vräspräs da ama enge imono ge ama ruvek dä sa u rhugem iom iva qale in natmärhamän sävät guavek nä ma Jisas aa ngärhipki.” ");
INSERT INTO uro_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bä äkt i rha mes iom saqi as savuk dä rha mugem iom iva sa qale in damän bä va qale ini su ama ruvek sävät iaqäkt ma Jisas. ");
INSERT INTO uro_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Sokt di ma Pita qä nä ma Jon in muvät i ini qoar toqortäqyia, “Mamär iva ngän datnävämne mamär ivar ama mär dä ma Ngämuqa aa saqong iva un det nasot angäna enge ura va unät nari nämät ma Ngämuqa. ");
INSERT INTO uro_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Inguna qaku mamär vät a un iva mänadin däm un bä va qaku un natmärhamän bät agirhong gärqärhongni i sa un lu irhong bä un nari irhong.” ");
INSERT INTO uro_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Näkt nasot angätni arha enge na ama mugem bä ba iom dä rha rhäväkt sä iom. Inguna qaku mamär vät a rha iva rha rhän bät anga iska ivakt iva rhi sangäm na iom dinguna nävät ama ruvek moe qärarhani i rhi nänsäs sage ma Ngämuqa nävät kärangätni ama lat i sa ngä märanas. ");
INSERT INTO uro_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Rhi nän sä ma Ngämuqa di nak nguna qärak ka ruqa i qa rha ama mumäräspät di aa qoeo ngä met e na ama ruiom ama udiom. ");
INSERT INTO uro_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bä nga nasot i rha rhäväkt sä iom dä ma Pita qä nä ma Jon in met bä sage ina ruavek dä in sameng bä ba rha nä iarhongäkt moe qärqärhong i ama priskäna ama moräs na rha dä ama morta rha märhamän särhäm iom nä irhong. ");
INSERT INTO uro_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bä nga rha nari rhoqoräkt dä rha moe västämne na rha sa ama nän sage ma Ngämuqa. Bä rhi nän doqortäqyia, “Sokt nge ma Engeska ma Ngämuqa, sa ngia säm ama usäpki bä ama ivätki bä ama garäska näkt sävät iarhongäkt moe qärqärhong i qali lirhong e väm ngät. ");
INSERT INTO uro_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Aut mamäk ma Devit kärakni i gia latka na qa di mudu ngia märhamän nä gi Qloqaqa ama Qumärqumärqa mät aa vämgi rhoqortäqyia, “‘Mäniekt bä ama Jentailqäna di sa rha mair na nas dap ama ruvek di sa rha rhäkmu na arhä snängaqa ama suk pa aa qamäs iva sävät ma Engeska ma Ngämuqa? ");
INSERT INTO uro_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ama vitnarha nävät ivät di sa rha märanas sa arhä qrot dä ama tpäskinarha di sa västämne na rha iva sävät ma Engeska dä sävät aa Muqunänbärhaqa ma Krais.’ ");
INSERT INTO uro_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Bä qoki rhäkmamär i ma Herot näkt ma Pontius Pailat pästämne na iom in na ama Jentailqäna näkt sävät ama ruvek nae ma Israel näp tom däkt ama mor äm ama värhäm. Sa västämne na rha ivakt iva rha rhäranas sävät gi qumärqumär qa mamär ama latka ma Jisas kärakni i mudu ngia muqunän bät a qa. ");
INSERT INTO uro_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bä rhäkmamär i rha mualat na agirhong gärqärhongni i mudu ainge ma Ngämuqa gi snängaqa bä gi qrot ngä rhares iva irhong ngä rhäranas. ");
INSERT INTO uro_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“Engeska, rhäkt di mamär iva ngiat lu arhä mugem dap pa ngi von ut gia latta rha ama qrot ivakt iva ama qraräkta na ut iva urhi sameng nä gia enge. ");
INSERT INTO uro_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Dap mamär iva ngit täk ngia rhäqyet iva et ngät tumäräspät dä va et ngät tualat na ama muqunän ama nañis ngät dä ama lat kärangätni i ngät dän masärmän nävät gia latka ama qumärqumär qa mamär ma Jisas aa ngärhipki.” ");
INSERT INTO uro_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bä nga rhi nän bä rhäksot dä vrän bät iosäkt ama ivärhäs kärqos i västämne na rha e. Bä rhäqäp ta moe na ama Qloqaqa ama Qumärqumärqa bä ama qraräkta na rha i qoki as ti sameng nä ma Ngämuqa aa enge. ");
INSERT INTO uro_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ama qatnanaktpämda di sa ama sägäk na rha vät arhä snängaqa. Bä qaku aung gä naqoaräs i aa qärhong di qoki qa aa qärhong maräkt dap tat tatmät na arhä qärhong bä ba ne. ");
INSERT INTO uro_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ama ngangda di rhi sameng nävät ama mor ngät ama qrot sävät ma Engeska ma Jisas kärakni i qa ñäp bä ma Ngämuqa qa märanas na qa nämät ama tñäpki näkt ama rhäk täm gi ama ñämsävätki di qia e vät a rha moe. ");
INSERT INTO uro_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Bä qaku anga ruvek kärarhani i rhit läk e mänguräp mä rha inguna mät amekni di iarhakt kärarhae i arha ivärhap bä arha vät di rhit bodäm ngät näkt tit ta iangärhäkt ama ligär ");
INSERT INTO uro_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bä rhat tu ngät mäk säng ama ngangda arha qar dä rhat tatmät na ngät bä ba auge qärak i qät läk. ");
INSERT INTO uro_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Qale akni ama ruqa e qärakni i rhat tes ka i ma Josep kärak i qa näva ama urqa ma Saiprus näkt ka nämäni ama enevaqi i ma Livai. Qa di qosaqi ama ngangda rhat tes ka i ma Barnabas. Iaqyäkt ama ngärhipki at tarimini i ama ruqa qärakni i qat dräm gät täsläp pät ama ruvek. ");
INSERT INTO uro_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Iaqäkt di qa voda aa etki näkt ka rha iangärhäkt ama ligär bä qa mu ngät mäk säng ama ngangda arha qar. ");
INSERT INTO uro_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Dap toqoräkt di akni ama ruqa qärakni i rhat tes k