﻿USE sofia;
DROP TABLE IF EXISTS sofia.urim_vpl;
CREATE TABLE urim_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES urim_vpl WRITE;
INSERT INTO urim_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ri kil pa nang a tu mamikg mamin mansan a tu nira nira ela wrkapm pa. Tu pa angket ale kul angko Sisas Krais. Sisas pa kil palng wli tu a Tepit, wa Tepit pa kil palng wli tu a Apraam. ");
INSERT INTO urim_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Wa Apraam pa angket Aisak, wa Aisak pa angket Sekop. Wa Sekop pa angket Suta nampikgen tu wusokwail alkilen. ");
INSERT INTO urim_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Wa Suta pa angket Peres ekg Sera. Man atuwekg pa Tamar. Wa Peres pa angket Esron, wa Esron pa angket Ram. ");
INSERT INTO urim_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Wa Ram pa angket Aminatap, wa Aminatap pa angket Nason. Wa Nason pa angket Salmon. ");
INSERT INTO urim_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Wa Salmon pa angket Poas. Man a Poas pa Raap. Wa Poas pa angket Opet. Man a Opet pa Rut. Wa Opet pa angket Sesi. ");
INSERT INTO urim_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Wa Sesi pa angket Tepit, melnum tukgunakg. Wa Tepit pa angket Solomon. Man a Solomon pa pikekg kin a Uria. ");
INSERT INTO urim_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Wa Solomon pa angket Reopoam, wa Reopoam pa angket Apiya. Wa Apia pa angket Asa. ");
INSERT INTO urim_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Wa Asa pa angket Seosapat, wa Seosapat pa angket Seoram. Wa Seoram pa angket Usia. ");
INSERT INTO urim_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Wa Usia pa angket Sotam, wa Sotam pa angket Aas. Wa Aas pa angket Esekia. ");
INSERT INTO urim_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Wa Esekia pa angket Manase, wa Manase pa angket Emon. Wa Emon pa angket Sosaia. ");
INSERT INTO urim_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Wa Sosaia pa angket Seoiakin, nampikgen tu wusokwail alkilen. Ak wang pa, tu Isrel pikekg tu Papilon awiyen aye kai alken wang paipm kai anong kanokg alntuwen atom tu akenten kwap kalpmlel. ");
INSERT INTO urim_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tu awiyen aye kai rpma Papilon pa pipa, Seoiakin pa angket Sealtiel. Wa Sealtiel pa angket Serupapel. ");
INSERT INTO urim_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Wa Serupapel pa angket Apiut, wa Apiut pa angket Eliakim. Wa Eliakim pa angket Asor. ");
INSERT INTO urim_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Wa Asor pa angket Satok, wa Satok pa angket Akim, wa Akim pa angket Eliut. ");
INSERT INTO urim_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Wa Eliut pa angket Eleasar. Wa Eleasar pa angket Matan, wa Matan pa angket Sekop. ");
INSERT INTO urim_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Wa Sekop pa angket Sosep, kipman a Maria. Atom Maria pa man a raku Sisas, Sisas pa Krais. ");
INSERT INTO urim_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tu yantin a angko kai Apraam a angket ale kulngkul, kul angko Tepit pa wampwam yikakwom wikgwikg. Wa tu yantin a angket ale angko Tepit ti kulngkul, kul angko wang a tu Papilon awi tu Isrel aye kai alken wang paipm kai anong kanokg alntuwen pa, wampwam yikakwom wikgwikg. Wa tu yantin a angket ale kai angko wang a tu Papilon awiyen aye kai anong kanokg alntuwen ti kul angko Sisas pa am wa palng wampwam yikakwom wikgwikg pa yat pake. ");
INSERT INTO urim_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yangkipm a la Sisas Krais kil palng pati la kol kil: Man alkil pa Maria, tu aknamputel la rpmi eng Sosep. Pake tuwekg itna watin watin, ake tuwekg okg kin kipman, pa apa. Atom ak wang pa tu ari Maria kil am arkolng wang kainil ase. Kil itna atnen Maur Wor a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pake Sosep, kipman a aknamputel la uwiyel pa, kil melnum ute wor. Wa kil karken a ungkwan kin a tu aknamputel pa itna wulmpa a tu wrongkwail ti mpa alkel numpaipm. Kolpa ti kil akwonalmpen rpma nikg a kil alkil ti la kil a nuurngkel meen kolti. ");
INSERT INTO urim_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kil akwonalmpen kolpa itna pa, kil okgwangket ari maur angklin a Maur Wailen palng lanakel la, “Sosep, watnom walpopm a yoampei Tepit, ampur kitn ngkark eng la ake mpa uwi Maria ti iye kolen kin alkitnen pa. Itning, warim ri rpma ipma a Maria a pa pikekg Maur Wor a Maur Wailen ai alkel ai. ");
INSERT INTO urim_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kil ikga raku warim kipman pake kitn ukwe nang akilen pa Sisas. Eng ntei, kil ikga ik uwi tu wrong kin a kipman a antokg paipmpaipm pa iye kul kai eng alkilen.” ");
INSERT INTO urim_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kweikwei kol a palng ti pa kai kanun yangkipm a pikekg Maur Wailen kil la kai ok a melnum okwripm pa, kil la kolkil la, ");
INSERT INTO urim_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","”Itning, kin ur a pikekg ake okg kinkipman nampon kipman ur pa, kil ikga itni, atom raku warim kipman. Ikga tu ukwe nang akilen pa Imanuel.” Yiprokgen a nang pa pati, la Maur Wailen antiwo rpma. ");
INSERT INTO urim_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Atom Sosep kil wrekg kanun okgwangket kol a maur angklin a Maur Wailen kil lanakel pa, atom kil awi kin a tu aknamputel pa aye. ");
INSERT INTO urim_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pake ake kil antiwel okg kinkipman pa, kolpa kai angko wang a kil raku warim kipman pa. Atom kil akwe nang a warim pa la Sisas. ");
INSERT INTO urim_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Sisas pa Maria kil raku kinar anong Petleem, a anong kanokg Sutia, ak wang a Erot kil itna melnum tukgunakg. Kil raku plalng pa tunteng melnum ariwe a takgni no pa tunteng kaino anong wail Serusalem. ");
INSERT INTO urim_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Atom tunteng asen tu Suta pa la, “Warim weten a ikga palng melnum tukgunakg itni ep a kipm Suta pa rpma kai a i? Men ari kumeim akilen a palng a takgni no ti, atom men kul la kipor kilko ilein a ngkit nang akilen.” ");
INSERT INTO urim_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pake Erot, melnum tukgunakg kil atning yangkipm pa, pa kolen ikyom ikningkil ur arkewel, a wa nampon tu wrongkwail kin a kipman a Serusalem ti yat. ");
INSERT INTO urim_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Atom kil akwe tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen pa, nampon tu melnum a aroaro wonel tu yangkipm a Moses pa, atom kil asenten la, “Kipm ariwe Krais pikekg tu nira la ikga man rakuwel rpmi kai a i?” ");
INSERT INTO urim_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ari tu akalmpe la, “Ikga rakuwel rpmi kinar anong Petleem a anong kanokg Sutia pa, kol a pikekg melnum okwripm a Maur Wailen kil nira yangkipm pa kolpa la, ");
INSERT INTO urim_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","'Kitn Petleem, anong a ela anong kanokg Sutia pa, kitn ake nang kalpisen pa itna kuin a kipm melnum tukgunakg a anong kanokg Sutia pa. Eng ntei, melnum wailen ur ikga palng kai kitn pa, atom ikga kil itni ep eng ikglen kipm Isrel, kipm wrong kin a kipman akupmen.'” ");
INSERT INTO urim_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kolpa atom Erot kil awi tunteng melnum ariwe a takgni no pa kai itna ampen, atom kil asenten eng la uwi riwe riworwor wang na pikekg kumeim pa palng pa. ");
INSERT INTO urim_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kil awi ariwe wang pa plalng pa, kil ukwa tunteng pa kinar Petleem, atom kil la kolpa, “Kipm kinar ikor riworwor warim pa plalng pipa, kipm iye yangkipm pa yaper no lanikopm! Eng kupm ti yat, kupm la wa kinar eng kipor kilko ilein ngkit nang a kil pa yat.” ");
INSERT INTO urim_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tunteng atning yangkipm a melnum tukgunakg pa la plalng pa tunteng kinar. Kumeim a pikekg tunteng ari ep a palng a takgni no pa ep ep, a tunteng pa kanun kanun kolpa kinar, kumeim pa kinar rpma kwa ute wan a warim pa armpe pa. ");
INSERT INTO urim_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tunteng ari pa, ipma a tunteng pa atopen paipm wrisen. ");
INSERT INTO urim_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Atom tunteng kai kawor wan pa, tunteng ari warim pa nampon man alkil Maria pa rpma. Tunteng kapor kilko alein ngkat nang a warim pa. Atom tunteng nakle kweikwei wor wor alntunteng pa plalng pa, tunteng uk kweikwei wor wor kolen wes maur muinmainet, a kweikwei yaprekget wor a ampor eng aris wor, a u wor a ak anel num pa, uk kai warim pa eng ak atopentel. ");
INSERT INTO urim_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pake wa Maur Wailen kil lanaken titnongket kai okgwangket pa la, ake mpa tunteng yaper or ya wrik wrik pa kaino eng Erot pa, kalpis. Tunteng atning kolpa atom tunteng yaper kai or ya manet ur ai kai anong kanokg alntuntengen pa. ");
INSERT INTO urim_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tunteng melnum ariwe tunteng kai plalng pa, maur angklin a Maur Wailen kil lanaki Sosep pa kai okgwangket pa la, “Kitn wrekg uwi tuwekg mantwarim pa, atom kipmteng ngkirk kai rpmi kai Isip! Eng ntei, Erot kil la ikor warim ti eng la or imo. Kitn rpmi kai pa rpmi i, wang a kupm lanikeitn pa kitn yaper kul.” ");
INSERT INTO urim_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Sosep kil atning kolpa, kil wrekg awi tuwekg mantwarim pa, tunteng ngkark ak mining pa kai Isip. ");
INSERT INTO urim_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kil ayewen rpma kai Isip pa a a, Erot pa amo plalng pipa, tunteng yaper kul. Kweikwei a palngten pa kai kanun kol a pikekg Maur Wailen kil lanaki melnum okwripm alkilen pa la, “Kupm akwe warim kipman alkupm a rpma kai Isip pa la, kil kul o! Atom kil kul.” Yangkipm kil a pikekg la pa am palng okarke tike. ");
INSERT INTO urim_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pake tunteng melnum ariwe a takgni no pa tunteng or ya manet ur pa kai anong alntuwen ase. Atom Erot kil rpma nungkwangen a a, ining. Atom kil ariwe la, tunteng untel ak, atom nikgwalpm a kil pa wleket paipm. Ti kil ukwa melnum tiur la kinar Petleem, wa anong wrongkwail a ela wreren, eng tu or tu warim kipman wrongkwail a angko wring wekg pa aye nar. Atom tu or tu warim a kilmik wris kai or wang a pikekg kil asen tunteng melnum ariwe pa ariworwor, atom tunteng lanakel wang a pikekg kumeim palng pa. ");
INSERT INTO urim_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Atom kuina ur a pikekg Maur Wailen la palng kai ok a Seremaia, melnum okwripm alkilen la pa, am palng ok arke aklale tike. Pikekg kil la kolkil la, ");
INSERT INTO urim_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","”Tu atning ok ur a akg kinar anong Rama, kirkar akg arein wail. Resel akgen warim alkil a amo. Ake antiwe mpa tu ntokg ipma akilen pa rpmi wor. Eng ntei, warim alkilen pa am amo plalng ase.” ");
INSERT INTO urim_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tunteng rpma kai Isip pa, Erot pa amo plalng pipa, maur angklin a Maur Wailen pa naki Sosep kai okgwangket ");
INSERT INTO urim_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","pa la, “Kitn wrekg uwi tuwekg mantwarim pa, atom kipmteng yaper kai anong kanokg Isrel pawo! Tu melnum pikekg ampen la ilm warim pa imo pa, tu pa am amo plalng ase.” ");
INSERT INTO urim_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kolpa atom Sosep kil wrekg awi tuwekg mantwarim pa, tunteng yaper kul anong kanokg Isrel. ");
INSERT INTO urim_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pake ak wang a Sosep kil atning la Arkelaus pa kil palng melnum tukgunakg a ikgalen anong kanokg Sutia, awi wrik a yan alkil Erot pa, kil ngkark eng la kai anong pa. Ari wa kai okgwangket pa, Maur Wailen kil lanakel, atom kil kaino rpma kaino anong kanokg Kalili. ");
INSERT INTO urim_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kil kaino rpma anong ur a tu namput la Nasaret. Atom yangkipmok kuina ur a pikekg tu melnum okwripm a Maur Wailen la kolkil la, “Ikga tu ukwewel la melnum a Nasaret”, pa am palng ok arke aklale tike. ");
INSERT INTO urim_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kil yangkipm a la Son melnum a kaluk tu. Wring aripm ur kai plalng pa Son kil ngkaten kwap a laron yangkipm a Maur Wailen pa rpma kai wrik mpang kalpmel a anong kanokg Sutia. ");
INSERT INTO urim_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Pa kil la, “Maur Wailen wreren eng a itni wailen ikglen ipma a kipm pake, ti kipm plelng ipma!” ");
INSERT INTO urim_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Pikekg ep ak ai, Aisaia, melnum okwripm a Maur Wailen pikekg la Son pa kolkil la, “Ok ur okok itna wrik mpang kalpmel pa la kolpa la, 'Nimprampen ya eng Wailen, ukulentel ya pa wunong riworwor!'” ");
INSERT INTO urim_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Apm a Son nowe pa pikekg antokg walkg a manto meng watin (kamel). Kil ak manto meng watin palk pa ak angket apm pa tatu tom pa. Wa okipma a kil al pa, kil al ka wa u pong mpangen a kumplun. ");
INSERT INTO urim_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ak wang pa, tu wrongkwail kai eng atning yangkipm a kil angkli. Tu a anong wail Serusalem, tu a anong kanokg wrongkwail a Sutia, a anong wrongkwail a ela narno u kop Sotan yamping yamping pa, tu kul eng Son. ");
INSERT INTO urim_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tu laron paipmpaipm alntuwen pa, atom Son kil kaluken itna u kop Sotan. ");
INSERT INTO urim_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pake ak wang a Son kil ari tu melnum a arpmen yangkipm yiprokgen a Moses a tu Satyusi watipmen a kul eng la kol a kil kuluken pa, kil lanaken la, “Kipm ti kolen ul angketepm. Mla lanakepm pa atom kipm akor ya eng la ikga ngkirk tukuleikgen ipma wakget a Maur Wailen a ikga nar ti! ");
INSERT INTO urim_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kolpa ti kipm plan atn a rpma akipmen ti kol yo a angko oken wor, eng mpa plan la kipm am plelng ipma ase. ");
INSERT INTO urim_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kipm am palng angkai Apraam pa angket alewepm kul pake, pake ake mpa kipm won ngklin la Apraam pa maminwror akipmen, ti ikga ngklinsepm pa. Eng ntei, kupm lanakepm la, Maur Wailen ti antiwe la wes tatu ti wa palng walwalpopm walyaru a Apraam ti. ");
INSERT INTO urim_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ti kotwang pa am numprampen rmpa yo yiprokg wrongkwail pa yat ase. Yo a ake ok arke ariwor pa, ikga ware ngkit ngkli elng kai wakg. ");
INSERT INTO urim_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kupm kalukepm itna kil pa, kupm kalukepm ak u kalpmel kolti, pa ak plan la kipm am plelng ipma ase. Pake melnum a ikga kul kunukg kupm kil pa, antiwe titnongket wail angen kupm ti. Kupm ti ake melnum wor antiwe mpa kupm iner nepm palk a melnum Wailen a kolpa. Kil pa ikga kulukepm ik Maur Wor alkilen wa ik wakg. ");
INSERT INTO urim_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kil aye kaimung pa itna kai wam alkil pa, eng la ik ngkwol wit ok pa ik wripm uwi, atom misen wor wor pa kil ikga ngkiten nimong iye kai rpmi wan wit ok alkilen ai. A kil ikga numpron plepm paipm paipm pa elng itni manet, eng ikga lap kai wakg a ikgake ime pa, kalpis.” ");
INSERT INTO urim_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ak wang pa Sisas kil wrekg a anong kanokg Kalili pa nar u kop Sotan eng la Son kulukel. ");
INSERT INTO urim_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pake Son la ngkengkel la, “Kupm kil kol am kitn pa kulukopm pake. Ari kitn pa wa kul lala kupm ti wa kulukeitn!” ");
INSERT INTO urim_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pake Sisas akalmpe la, “Ntokg kol a kupm la pa pen. Pa wor kol mentekg kunun ntokg kitila nikgwalpm wrongkwail ute wor a Maur Wailen kil la pa.” Son awi wor atom kil kalukel. ");
INSERT INTO urim_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kil kalukel plalng pipa, Sisas kil a u pa no pa, ak wang ketn pa, kitnong pa rakol, a kil ari Maur Wor a Maur Wailen pa nar kol wel punum pa narntel. ");
INSERT INTO urim_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pipa ok ur la angkaino kitnong pa nar la, “Pa warim kipman wor wris alkupm a kupm plan ipma wor wakrongentel. Kupm ipma wor atopentel.” ");
INSERT INTO urim_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Son kil kaluk Sisas plalng pa Maur Wor a Maur Wailen kil awi Sisas aye kai wrik kalpmel ur a ake melnum ur arke, eng mpa Maur Paipm kil ningkailel. ");
INSERT INTO urim_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sisas kil uk wang rpma ak nikg wang kamel misen wekg miningkranen pa atom nikgalmpel. ");
INSERT INTO urim_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pa pipa Maur Paipm a ningkail kamel pa wli palngtel kolti lanakel la, “Kol kitn Warim Kipman a Maur Wailen pa pati, kitn la wes ti palng kolen okipma pa, atom kitn il!” ");
INSERT INTO urim_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ari Sisas akalmpe la, “Wrkapm a Maur Wailen pa la kolkil la, 'Melnum ake antiwe a rpma ak okipma kolti pa, kalpis. Pa rpma ak yangkipmok wrongkwail a palng kai ok a Maur Wailen!'” ");
INSERT INTO urim_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kil akalmpe kolpa plalng pipa, wa Maur Paipm wa awiyel a pa wa ayewel kai kaino anong wail Serusalem a pikekg Maur Wailen amprin eng kil alkil pa atom ayewel kai kaino itna kaino wan kimpo kwa wai, yalming a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Atom kil lanakel la, “Kitn ti Warim Kipman a Maur Wailen, ti kitn tipra elng kinar kanokg ai! Nira ela wrkapm a Maur Wailen pa la kolkil la, 'Mpa kil uk yangkipm tu maur angklin alkil ti mpa tu rkuleitn pa.' A wa nira kolpa yat la, 'Mpa tu wamplilngteitn pa, eng ake mpa kitn ngko ngket nepm pa eli wes ur pa.'” ");
INSERT INTO urim_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ari Sisas akalmpentel la, “Pake wrkapm a Maur Wailen wa la kolkil yat la, 'Ampur kitn ningkail Wailen, kil Maur Wailen akitnen ti.'” ");
INSERT INTO urim_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Wa Satan awiyel a pa wa ayewel kaino itna kaino wrik nangen watin ur pa. Kil plantel anong nampon kanokg, a kweikwei wrongkwail a wor wor a antiwe titnongket a itna anong kanokg yela pa. ");
INSERT INTO urim_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Atom kil lanakel la, “Kol kitn kipor kilko ilein ngkit nang akupmen ti pa, kweikwei wrongkwail ri pa mpa kupm lkeitn.” ");
INSERT INTO urim_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pake Sisas akalmpe la, “Satan, kitn kai tukwelkg kupm ti! Eng ntei, nira ela wrkapm a Maur Wailen pa la kolkil la, 'Kitn kipor kilko ilein ngkit nang a Wailen, kil Maur Wailen alkitnen, kitn ikwap a kil wris ita!'” ");
INSERT INTO urim_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Atom pake, Maur Paipm Satan kil wrekg naurngkel a tu maur angklin tiur a Maur Wailen pa wli angklinsel. ");
INSERT INTO urim_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sisas atning la tu arkul Son kil aye kai rpma wan tipmining pa, kil wrekg kaino anong kanokg Kalili. ");
INSERT INTO urim_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kil wrekg naurng anong Nasaret pa wa kai kaino rpma anong Kaperneam. Kaperneam pa ela wreren ukupuk wail a Kalili, kai kanokg a tu Sepulun a tu Naptali. ");
INSERT INTO urim_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kil kaino akwap rpma kaino Kaperneam pa, yangkipm a Maur Wailen kil la kai melnum ok wripm Aisaia kil la pa, am palng angko oken ase, kil pikekg la kolkil la, ");
INSERT INTO urim_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","”Kanokg a tu Sepulun, a kanokg a tu Naptali, pa kanokg a ela ya a kai unokg. A kanokg a itna kai u kop Sotan wompel pa, pa kanokg wompel a Kalili, tu melnum tiur a ake Suta pa tu wli antiwen rka anong kanokg pa. ");
INSERT INTO urim_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tu melnum a rpma anong kanokg pa tu rka miningket, atom tu ari klalen wail. Tu a rka wrik om miningkon pa, klalen pa palngten.” ");
INSERT INTO urim_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Angko wang pa atom wa aye or pa kai pa, Sisas kil ngkaten eng laron yangkipm pa la kolkil la, “Maur Wailen wreren eng a itni wailen ikglen nol nikgwalpm a kipm wrong kin kipman ti, ti kipm plelng ipma!” ");
INSERT INTO urim_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sisas kil angkom antilawe ukupuk yamping a Kalili pa kinar ari wusok wail wekg, ekg ak apm mumu pa akawi yul pa itna. Saimon, nang wompel pa Pita, wa wusok pa Antru. Pa kol kwap marpm atuwekg. ");
INSERT INTO urim_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Sisas kil lanaken la, “Kipmekg kul kunun kupm ti, eng mpa kupm kiling plantepm atom ikga kipmekg uwi tu melnum kolen a kipmekg awi yul pa.” ");
INSERT INTO urim_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tuwekg atning kolti, tuwekg naurng apm mumu pa rmpa, a tuwekg kai kanun Sisas. ");
INSERT INTO urim_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Wa tunteng angkom kolpa kai pipa, tunteng ari yantwarim ur pa rpma kai nim ukupuken pa rpma. Semis ekg Son anti yan alntuwekg pa Sepeti, teng noworel angkut karpo apm mumu pa rpma. Ari Sisas akwewen. ");
INSERT INTO urim_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Atom tuwekg atning kolpa, tuwekg naurng yan pa nampon nim ukupuken pa rpma wai a tuwekg penterng kul kanuntel. ");
INSERT INTO urim_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Sisas kil akwe Semis ekg Son pa plalng pa kil wa alekgen tuwekg pa angkom or kai yela anong kanokg Kalili ti. Kil kaling planten, a kil laron yangkipm wor ti itna wan a tu atning atning yangkipm a Maur Wailen atnewe pa. Kil laron yangkipm wor a Maur Wailen a kil a itni wailen ikglen ipma a mentepm wrongkwail, a kil antokg tu melnum a awi numpet a wleket auraur pa palng wor. ");
INSERT INTO urim_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tu lakati kwap a Sisas kil ak kolpa yela anong kanokg wrongkwail a Siria ti. Atom tu wrongkwail atning kolpa, tu aye tu a awi numpet auraur, tu melnum a maur paipm arpme, a amo titno titno, a amo nepm wam plupmen, atom Sisas kil antokg tu melnum a awi numpet a kolpa tu palng wor. ");
INSERT INTO urim_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Wrong wailet paipm a anong kanokg Kalili a Tekapolis, a anong wail Serusalem, a anong kanokg Sutia, a kai u kop wompel Sotan pa, tu kanun kil pa. Tu ak wail kunturng kanuntel. ");
INSERT INTO urim_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sisas kil ari tu wrongkwailet paipm a wli kanuntel kanuntel, kolpa atom kil kaino itna wrik nangen ur pa, atom kil rpma. A tu watnom alkil a kil aroaro wonel pa, tu kul rpma kapringentel. ");
INSERT INTO urim_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Atom kil kaling planten, lanaken kolkil la, ");
INSERT INTO urim_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","”Tu mla ur a ariwe la kil alkil ti ake ute wor itna wulmpa a Maur Wailen pa, tu pa wor pake, tu itopen o! Maur Wailen pa am rpma wail ikgalen ipma a tu pake. ");
INSERT INTO urim_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Wa tu mla ur a akg arein pa, tu pa wor pake, tu itopen o! Maur Wailen mpa ntokg ipma atuwen pa rpmi itopen. ");
INSERT INTO urim_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Wa tu mla ur a tu arku tu alntu orngwatneikgen pa, tu pa wor pake, tu itopen o! Ikga tu uwi kanokg yela ti a Maur Wailen kil yapon yangkipm pa. ");
INSERT INTO urim_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Wa tu mla ur a tu nikgalmpen a uwaketen eng la palng ute wor itni wulmpa a Maur Wailen pa, tu pa wor pake, tu itopen o! Maur Wailen ikga ngklinsen nikgwalpm ute wor wor or pa kai. ");
INSERT INTO urim_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Wa tu mla ur a tu arein angklin mla ur pa, tu pa wor pake, tu itopen o! Ikga Maur Wailen kil rein ngklin tu pa yat. ");
INSERT INTO urim_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wa tu mla ur a nol nikgwalpm a tu pa rka wriwen wor pa, tu pa wor pake, tu itopen o! Ikga tu ri Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Wa tu mla ur a nikgwalpm wor eng kapor angkeng akle or tita pa, tu pa wor pake, tu itopen o! Ikga Maur Wailen kil ukwe tu pa la warim akilen. ");
INSERT INTO urim_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Wa tu mla ur a tu arki kalkuten atnen a tu palng ute wor itna wulmpa a Maur Wailen pa, tu pa wor pake, tu itopen o! Maur Wailen rpma wail ikgalen ipma a tu pake. ");
INSERT INTO urim_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Wa kipm mla ur a tu aklewepm ak yangkipm paipm, a akor lawepm kalpmel, a antokgtepm paipmel atnen a kipm kanun kupm ti pa, kipm pa wor pake, kipm itopen o! ");
INSERT INTO urim_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kipm itop rimomo! Kweikwei wor wor a ikga kipm uwi ikilmpe kwap a kipm aken pa, pa elngtepm itna kaino anong wor. Kol pikekg tu antokg paipmel tu melnum okwripm a Maur Wailen, wa kol tu antokg paipmel kipm ti yat.” ");
INSERT INTO urim_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Sisas la kolpa plalng, wa kil wa la kolkil la, “Am kipm ti kolen nokg a tu wrong kin a kipman a kanokg ti. Kol nokg pa kai kupuk pa, mpa wa mentepm ntokg kolai eng wa kil wa kleset pa? Pa ya kalpisen, pa am kai kupuk ase. Ti mpa mentepm ngkiten lung, atom tu rkganti la, pa paipm ase. ");
INSERT INTO urim_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Wa kipm ti yat, kipm kolen wakg a akalen tu a itna kanokg ti. A wa kolen anong wail ur a itna kaino wrik nangen ti ake antiwe mpa am pa. ");
INSERT INTO urim_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mentepm ake mpa la wakg pa atom ik kuntuk mipmapm pa ik aur pa, kalpis. Mpa la atom erki kaino kwa ti eng len wrongkwail a rka wan pa. ");
INSERT INTO urim_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kipm am kolen wakg pake, mpa nuruk iklen tu wrongkwail. Eng mpa tu ri kwap wor a kipm ak pa tu ngkit nang a Yan akipmen kaino anong wor.” ");
INSERT INTO urim_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Sisas kil la kolpa atom wa kil wa lala, “Ampur kipm akwonalmpen la kupm nar eng ungkwan yangkipm titnongket a Moses a yangkipm a tu melnum okwripm a Maur Wailen kaling plan tu pa. Kupm ake nar eng la ungkwan pa, kalpis. Kupm nar eng la kunun ik titnongketel yangkipm wrongkwail pa eng palng kai iklale. ");
INSERT INTO urim_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kupm lanakepm aklale wrisen. Kitnong a kanokg ti pa ikga kai plalng. Pake ikgake yangkipm titnongket ketn ur aki krakg ur a ak nira yangkipm a Maur Wailen ti ikga kai am pa, kalpis. Ikgam itna kolpa kai ngko wang a kweikwei wrongkwail a la pa palng. ");
INSERT INTO urim_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kol melnum ur kil tulpulng yangkipm waiketn ur a ela kai wrkapm a Maur Wailen kil, a wa kil kiling planten eng tu kunun irir kolen kil pa pipa, ikga kil uwi nang wusok itna kuin a tu a Maur Wailen ikgalen ipma atuwen. Pake mla ur a kil kanun a kaling plan tu eng yangkipm titnongket wrongkwail alkil pa, ikga kil uwi nang wailen itna kuin a tu a Maur Wailen ikgalen ipma atuwen. ");
INSERT INTO urim_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kol tu melnum a aroaro wonel tu yangkipm a Moses, a tu melnum a arpmen yangkipm yiprokgen a Moses pa, tu ariwe nikgwalpm ute wor a Maur Wailen, pake ake tu kanun ariworwor. Kupm lanakepm aklale la, kol kipm ti ake kanun nikgwalpm ute wor a Maur Wailen pa angen tu melnum a arpmen yangkipm yiprokgen a Moses pa, kipm ikgake kawor anong wor a Maur Wailen kil ikgalen pa.” ");
INSERT INTO urim_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Sisas kil la pa plalng wa kil wa la kil, “Kipm atning yangkipm titnongket a pikekg lanaki tu mamikg mamin mansan akipmen ep ak ai la, 'Ampur almpor melnum amo. Wa kol mla ur ilmpor melnum imo pa, mpa tu iyewel kai ntokg yangkipm, atom kil mpa uwi paipm.' ");
INSERT INTO urim_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kupm pa lanakepm kolkilke la, mla ur ipma wakget eng wusok aki wailen alkil kolti pa, mpa tu iyewel kai itni ntokg yangkipm, atom kil mpa uwi paipm yat. A mla ur a wa rku wusok aki wailen alkil pa la, kil wor kalpmel, pa ikga tu iyewel kai ntokg yangkipm kaikuten wail itni tu mring man tukgunakgen a itna ep. A wa mla ur a kil la wusok aki wailen alkil pa la, kil melnum titno, pa kil ikga kai anong paipm a wakg atne. ");
INSERT INTO urim_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kol kitn la iye kweikwei kawor yalming a Maur Wailen pa eng uk wor kil pa, ari wa kitn wonuwen wusok aki wailen ur alkitn a nikgwalpm paipm eng kitn pa. ");
INSERT INTO urim_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Kolpa pati, elng kweikwei pa ermpi papen, a kitn kai la ipma wris nimpon kil pa, plalng pipa, kitn yaper kul uk kweikwei pa kai eng ukwor Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Wa kol melnum ur la nti kitn ntokg yangkipm pa, ntiwel ntokg itatu! Kipmekg la or ya pa kai eng la ntokg yangkipm itni mring man pa, kitn ntiwel la yangkipm pa kai ipma wris pinterng, eng mpa kipmekg or yangkipm pa kai imo. Kalpis pa pati, mpa kil iyeweitn kai ntokg yangkipm pa itni tu mring man pa atom, mpa wa tu pa elng kitn kai wam a tu nepimpalo, atom tu pa iyeweitn kai rpmi wan tipmining. ");
INSERT INTO urim_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kupm lanakeitn aklale la, kitn ikga rpma akampen akalmpe marpm kol a tu la pa kai plalng pipa, tu ungkwanteitn kul or en.” ");
INSERT INTO urim_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","”Kipm atning yangkipm titnongket a pikekg lanaki tu mamikg mamin mansan akipmen ep ak ai la, 'Ampur angkli arkul tita.' ");
INSERT INTO urim_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tu pa lanakepm kolpake, kupm kil lanakepm kolkil, kol melnum ur ri ngkowe kin ur pa pipa, pa kawor nol nikgwalpm akilen pa am kil angkli arkul kin pa yat ase. ");
INSERT INTO urim_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kol wulmpa wompel akitnen pa rkolngkeitn iye kai ngko eng ntokg paipmpaipm pa, inen ngkli kai ai. Wor kol a kitn ungkwan kwei ur wris a num akitnen ti kolti. A paipm eng kol a tu ngkli num alkitnen ti kimeket elng kinar anong paipm pa. ");
INSERT INTO urim_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Wa kolen wam wompel akitn pa rkolngkeitn iye kai ngko eng ntokg paipmpaipm pa, wangket ngkli kai ai. Wor kol a kitn nuurng wam wompel wris pake, a paipm eng kol a kitn uk num alkitnen ti kimeket elng kinar anong paipm pa.” ");
INSERT INTO urim_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","”Kipm atning yangkipm pikekg la ep pa la, 'Melnum la ungkwan kin alkil pa, mpa kil lkel wrkapm wompel ur a ik ngketen kil ti atom ungkwan kin pa kai.' ");
INSERT INTO urim_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tu pa lanakepm kolpake, kupm kil lanakepm kolkil: kol kin alkil kil ikwap numkropis a uk numpaipm kamel pa, pa kil antiwe ungkwantel. Pake kin pa ake kil akwap kolpa pa, pa ampur kil ungkwantel. Kolpa mpa kil antokg kin pa angko eng kil kai angkli arkul kipman ur ai. A wa kol kipman ur wa uwi kin ur a kipman ep ungkwan pa iye pa, pa kil angkli arkul kin pa.” ");
INSERT INTO urim_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","”Kipm atning yangkipm titnongket a pikekg lanaki tu mamikg mamin mansan akipmen ep ak ai la kolkil la, 'Kol kipm naren kwei ur pa, ampur kipm angketen yangkipm a kipm naren pa. Kipm ntokg kuina ur a pikekg kipm naren pawo, eng ntei, kipm naren nang a Wailen.' ");
INSERT INTO urim_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tu pa lanakepm kolpake, kupm kil lanakepm kolkil la, ampur kipm naren kuina ur a kipm antokg pa. Ampur kipm naren atom wam kaino kwa pa, pa wrik a Maur Wailen awi nang wailen arpme eng ikgalento. ");
INSERT INTO urim_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Aki naren kanokg ti pa, pa wrik a kil elng nepm atne, aki naren anong wail Serusalem pa, pa anong wail a Melnum Tukgunakg Wailen amentepmen. ");
INSERT INTO urim_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","A wa ampur kipm naren wam kaino tukgunakg akipmen ti. Kipm itna tukgunakg waipmun pa kaingkai, kai werk almpepm pa, pa ake kipm ti antokg, pa Maur Wailen alkil antokg. ");
INSERT INTO urim_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kolpa ti kitn la la kuina ur pa, kitn la iklale kolti. Kitn la kalpis pa, kitn la kalpis kolti. Kitn naren kwei ur eng ak titnongketel yangkipm pa pati, pa nikgwalpm a Maur Paipm.” ");
INSERT INTO urim_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","”Kipm atning yangkipm pikekg la ep pa la, 'Kol melnum ur ntokg wulmpa wompel akitnen pa paipm pa, mpa kitn ikilmpe ntokg wulmpa wompel akilen pa paipm yat. Wa melnum ur kil kipor oktelp akitnen pa, mpa wa kitn ikilmpe kipor oktelp akilen pa.' ");
INSERT INTO urim_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tu pa lanakepm kolpake, kupm ti lanakepm kolkil: ampur kipm akalmpe melnum a antokgtepm paipm pa. Melnum ur oreitn kai tangkwei wompel pa, wa plelng wompel pa lkel eng kil oreitn. ");
INSERT INTO urim_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A wa kol melnum ur kil uwi kitn ti iye kai ntokg yangkipm eng la uwi apm a kitn nowe angkaino ti nar pa, iner, lkel o! A wa lkel apm a kitn nowe eng wropuk ti pa wa kai iken pa! ");
INSERT INTO urim_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Wa kol melnum ur wa erkisen kitn ti la ntiwel iyentel kweikwei ur pa iye kai ketn ti, pa wa ntiwel iye kai ketn ai! ");
INSERT INTO urim_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kol melnum ur kil isenteitn la uwi kwei ur pa, pa kitn lkel kolti! A melnum la isenteitn la uwi kwei ur akitnen ti iye kai ik ntokg kwei ur atom wa iyenteitn kul pa, ampur kitn langkin, kitn lkel kolti!” ");
INSERT INTO urim_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","”Kipm atning yangkipm pikekg la ep pa la, 'Kipm mpa plan ipma wor wakrongen yiprokgen alkipm pake, kipm mpa kirken kamel mis a wrongmanto pa.' ");
INSERT INTO urim_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tu pa lanakepm kolpake, kupm kil lanakepm kolkil: kipm mpa plan ipma wor wakrongen tu wrongmanto alkipm pa, a kipm mpa oklala niki Wailen eng mpa kil ngklin tu melnum a antokgtepm paipm pa, ");
INSERT INTO urim_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","eng mpa tu riwepm la kipm pa warim a Yan kaino kitnong. Kipm mpa plan ipma wor wakrongen melnum wor a melnum paipm. Eng ntei, Maur Wailen kil pa antokg takgni el eng akangklin melnum wor a melnum paipm, a wa antokg u awei eng akangklin mentepm plalngen, melnum ute wor a melnum a antokg paipm. ");
INSERT INTO urim_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kol kipm plan ipma wor wakrongen tu a plan ipma wor wakrongen kipm pa kolti, pa Maur Wailen ake mpa lkepm kweikwei ur ikilmpe kwap a kipm ak kolpa. Ti tu melnum a awi marpmel kipm pa am wa antokg kolpake. ");
INSERT INTO urim_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kol kipm plan ipma wor tu yiprokgen alkipm ti kolti, a ake kipm plan ipma wor tu mlaur kamel misen ai pa, pa ake kipm ak kuina ur manet kolai. Tu a ake ukipma pa am ak kolpa yat pake. ");
INSERT INTO urim_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kolpa ti kipm rpmi wriwen wor yek kimeket kolen Yan akipmen a rpma wriwen yek kimeket wor kaino kitnong pa!” ");
INSERT INTO urim_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","”Kipm lala kunun nikgwalpm ute wor ur a Maur Wailen pa, kipm ik iriwe! Ampur kipm antokg itna wulmpa a tu wrongkwail pa, kipm ik ampen. Kol kipm ik itni wulmpa a tu wrongkwail eng tu ri pa, Yan alkipm kaino kitnong pa ikgake lkepm kweikwei ur eng ikilmpe kwap a kipm ak kolpa. ");
INSERT INTO urim_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kolpa ti kol kitn la uk kwei ur melnum ur a rpma tukwok pa, ampur kitn ik kolen tu melnum a kansil plan ak num enen kolti antokg itna wan a atning atning yangkipm a Maur Wailen atnewe, a itna tatu ya eng la tu wrong kin a kipman riwen atom kiporng yangkipm tu pa. Kupm lanakepm aklale wrisen la, kweikwei a tu awi eng akalmpe kwap a tu ak kolpa, am tu awi plalng ampake. ");
INSERT INTO urim_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pake kitn ti pa, kitn la ngklin melnum ur a rpma tukwok pa, ik meen ampen kolti eng ampake melnum yek ur a rpma wrerenteitn pa riwe pa. ");
INSERT INTO urim_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Pa mpa rpmi ampen kai kipmekg ti kolti. Pa pati mpa Yan akitnen kil ari a kitn ak ampen kolpa pipa, ikga kil lkeitn kweikwei ikilmpe kwap a kitn ak kolpa.” ");
INSERT INTO urim_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","”Kipm la oklala niki Wailen pa, ampur kipm antokg kolen tu melnum a kansil ak num enen kolti. Tu kawor wan a atning atning yangkipm a Maur Wailen atnewe, atning yangkipm a Maur Wailen pa, wakrongen la wrekg itni kwa oklala niki Wailen, a kai itni ya wenting akapm a anong wail pa oklala nakel kolpa, eng mpa tu wrongkwail pa ri pa. Kupm lanakepm aklale la, kweikwei a tu awi eng kwap a tu ak kolpa, am tu awi plalng ampake. ");
INSERT INTO urim_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pake kipm ti pa, kipm la oklala niki Yan akipmen a rpma am pa, kipm kawor wan ok wunen ur pa ir wanyun pa atom kipm oklala nikel. Eng mpa Yan akipmen pa kil ri a kipm ak ampen kolpa, mpa kil ikilmpe. ");
INSERT INTO urim_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kipm la oklala niki Wailen pa, ampur kipm lanikel oklala a yiprokgen kalpisen a rkolng watin kol tu ipmawekg a la lalongen mring maur pa. A tu akwonalmpen la mring mpa itning oklala atuwen atnen oklala a tu or wrikel lala pa. ");
INSERT INTO urim_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ampur kipm antokg kol tu pa, kol Yan akipmen pa kil ariwe ep ase kuina ur kipm la mpa isentel pa. ");
INSERT INTO urim_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mpa kipm laniki Maur Wailen pa kolkil: 'Yaiyai amenen kaino kitnong, men lala nang akitnen pa itni klalen wakget. ");
INSERT INTO urim_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kitn itni wailen ikglen men wrong kin a kipman nimpon kweikwei wrongkwail pa. Kitn kunun wakrongen alkitn pa ntokg kweikwei itni kanokg ti kol a kitn antokg itna kaino kitnong pa. ");
INSERT INTO urim_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kitn lko okipma kol a antiwe am ti. ");
INSERT INTO urim_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kitn ungkwan paipmpaipm amenen ti, kol men ungkwan paipmpaipm a tu antokg kul men ti ase. ");
INSERT INTO urim_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kitn iyewo ngkom nilokgen Maur Paipm a ningkailo la men ngko kai paipmpaipm.' ");
INSERT INTO urim_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kol kipm ungkwan paipmpaipm a tu melnum antokg kai kipm ti pa, Yan akipmen kaino kitnong pa mpa wa kil ungkwan paipmpaipm akipmen pa yat. ");
INSERT INTO urim_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pake kol ake kipm ungkwan paipmpaipm a tu melnum antokg kai kipm ti pa, Yan akipmen ake mpa wa ungkwan paipmpaipm akipmen pa kalpis.” ");
INSERT INTO urim_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","”Kipm la kalpis okipma a al eng uk wang Maur Wailen pa, ampur kipm atn plan tu kolen la kipm nikg almpepm pa, kolen tu melnum a plan ak num enen ti la tu melnum wor pa. Tu atn plan tu kolen la nikg almpen, atom tu ari pa tu la, tu pa kalpis okipma eng uk wang Maur Wailen. Kupm lanakepm aklale wrisen, tu ak kolpa tu awi kweikwei akalmpe kwap a tu ak pa, am tu awi plalng ampake. ");
INSERT INTO urim_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pake kitn ti pa, kitn la kalpis okipma eng uk wang Maur Wailen pa, kitn kurkuk, ik u yiwa pa ikinel ikgokg tukgunakg pa, kintirng. ");
INSERT INTO urim_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kolpa eng ake mpa tu riwe la kitn kalpis okipma eng uk wang Maur Wailen pa. Pa mpa Yan wris ata alkitnen a rpma ampen pa, kil ari kuina ur a kitn ak ampen kolpa pa, ikga kil ikilmpe pa.” ");
INSERT INTO urim_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","”Ampur kipm la uwi wrikya wailet wor wor elngkitni lala eng rpmi ntiwe i kanokg ti. Kweikwei pa ikga atok, kitningkin ngket a ikga mingkirpet, a ikga tu melnum ikgwampet tikale wan ik ikgwampel. ");
INSERT INTO urim_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kipm uwi wrikya wailet wor wor elngkitni kaino kitnong. Kweikwei kaino kitnong pa ikgake atok, kitningkin ngket, a ikgake mingkirpet, a tu melnum ikgwampet ikgake ik ikgwampel, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kweikwei wor wor akitnen a itna a i pa, nikgwalpm wail akitnen am arken pake.” ");
INSERT INTO urim_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Wulmpa pa kol wakg a akalen num wrongkwail. Wulmpa akitn pa wor pa, num wrongkwail akitnen pa mpa klalen wor. ");
INSERT INTO urim_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pake kol wulmpa akitnen pa paipm pa, num wrongkwail akitnen pa mpa miningket. Kol wakg a akalen num akitnen pa miningket pa, pa mpa miningket paipm wrisen.” ");
INSERT INTO urim_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ake antiwe melnum wris ur kil iken kwap mring wekg pa. Kolpa pa, mpa kil ipma paipm eng ur a plan ipma wor wakrongen ur. Aki mpa kil uwi wor la ur a uwi paipm uk ur. Kolpa ti kitn ake antiwe akwap eng tuwekg yatenen, Maur Wailen a marpm pa.” ");
INSERT INTO urim_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","”Kolpa ti kupm lanakepm la, ampur kipm nikgwalpm kalkut akwonalmpen watipmen la, mpa kipm il u a okipma a i, aki la mpa kipm nowe apm a i ikaur num akipmen ti. Okipma pa itna ep angen amen wor a melnum pake? Aki apm pa itna ep angen numpalk pake? ");
INSERT INTO urim_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kipm ari wel a taur atn or kaino kwa pa aki! Tu pa ake kol mentepm melnum ti a aken kwap okipma angketuwai aye kawor itna wan pa, kalpis. Yan akipmen a rpma kaino kitnong ti kil ikgalenten eng okipma. Ti wel pa itna ep angen kipm melnum pake? ");
INSERT INTO urim_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kipm mlaur a akwonalmpen watipmen eng okipma pa, antiwe mpa wa kipm ngkine wang alkipmen a rpma ti wa iye kai ketn pake? ");
INSERT INTO urim_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Kolpa ti wa kipm wa akwonalmpen watipmen eng apm pa eng ntei? Kipm ri kweikwei rwin a ari wor pa. Tu ake akwap aki antokg apm ur alntu eng nowe pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pake kupm lanakepm la, pikekg Solomon, melnum tukgunakg a antiwe kweikwei wor wor watipmen pa ak apm ari wor wor ak nowe num pake ake apm ur ari wor kolen kweikwei rwin pa. ");
INSERT INTO urim_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ti ri Maur Wailen kil antokg kweikwei rwin pa palng ariwor. Pake kweikwei rwin weti arimo pa, ikg pa wa tu ngket ngkli kai wakg. Ti kil ake antiwe ikgalen kipm melnum eng apm kweikwei pa? Kipm melnum ti pa wa itna ep angen kweikwei pa, ari ake wa kipm ukipma titnongket pa. ");
INSERT INTO urim_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kolpa ti ampur kipm nikgwalpm kaikut akwonalmpen watipmen la, mpa kipm il u a i, okipma a i, a nowe apm a i pa. ");
INSERT INTO urim_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Eng ntei, tu wrong kin kipman a kanokg ti pa nikgwalpm arken la uwi kweikwei a kolpa, pake Yan a kipm a rpma kaino kitnong pa kil ari ase kuina ur a kipm tukwok pa. ");
INSERT INTO urim_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kolpa ti kipm nikgwalpm rkekgen eng elng Maur Wailen pa itni wailen ikglen ipma akipmen, a wa kipm nikgwalpm rkekgen eng palng ute wor itni wulmpa alkilen pa pipa, mpa kil lkepm kweikwei wrongkwail pa yat. ");
INSERT INTO urim_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ampur kipm akwonalmpen watipmen kalkuten a ikg pa palngtepm pa. Kalkuten a ikg pa, pa a wang alkil ikg ai. Ikwonilmpen kol a am ti kolti.” ");
INSERT INTO urim_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","”Ampur kipm ari elukgen melnum ur pa la paipm pa eng ake mpa wa Maur Wailen ri elukgen kipm ti la kipm paipm pa. ");
INSERT INTO urim_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kipm ri elukgen melnum ur kolai pa, pa ikga wa Maur Wailen kil wa ri elukgen kipm pa kolpa yat pake. Kipm ri ilmpil itne melnum ur pa kolai pa, pa ikga wa Maur Wailen wa ri ilmpil itne kipm pa kolpa yat pake. ");
INSERT INTO urim_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Antokg kolai atom kitn wa ari ipik wasek ur a ela wulmpa a melnum ur alkitnen, pake ake wa kitn ari yo wail ur a ela wulmpa alkitnen ti! ");
INSERT INTO urim_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Antokg kolai ti kitn lanaki melnum wor ur alkitn pa la, 'Ti kitn itni eng kupm kiplim ipik wasek ur a ela wulmpa akitnen pa ri.' Ti ake kitn ari yo wail a ela wulmpa alkitnen ti! ");
INSERT INTO urim_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Pa kitn melnum a kansil plan ak num enen ti la kitn melnum wor. Kola kitn uwi yo wail a ela wulmpa alkitnen ti tukwlekg plalng pa, wulmpa akitnen pa wor pa, kitn ri kiplim ipik wasek a ela wulmpa a melnum wor alkitnen pa. ");
INSERT INTO urim_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ampur kipm angkli kweikwei a Maur Wailen amprin eng kil alkil pa uk kai nimpa pa, mpa nimpa plelng nam kamel. Ampur kipm angkli krim kwalo wor wor alkipm pa uk kai manto pa, mpa manto rkganti plelng nam kamel.” ");
INSERT INTO urim_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","”Kipm isen pa, mpa kipm uwi. Kipm ikor pa, mpa kipm ri. Wa kipm kulkwon pa, wanyun mpa kukwantepm pa. ");
INSERT INTO urim_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kol mla ur a kil asen pa, mpa kil uwi. Mla ur a kil akor pa, mpa kil ri. A mla ur a kil kalkwon pa, wanyun mpa kukwantel pa. ");
INSERT INTO urim_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mla ur kitn kol warim alkitnen pa isenteitn eng okipma pa, mpa wa kitn uwi wes pa lkel pake? ");
INSERT INTO urim_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Aki kol kil isenteitn eng yul pa, mpa wa kitn lkel ul tike? Kalpis. ");
INSERT INTO urim_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kipm melnum paipm pake, kipm uk uk kweikwei wor wor kai warim alkipmen pa. Ti kipm riwe la, Yan akipmen kaino kitnong pa kil atopen paipm la uk kweikwei wor wor tu mla ur a asentel pa. ");
INSERT INTO urim_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kipm wakrongen la mla ur iktepm kolai pa, kipm wa ntokgten irir kol a kipm wakrongen la tu iktepm pa. Yangkipm kil kai kanun yangkipm a Moses, a yangkipm a tu melnum okwripm a Maur Wailen a kaling planto pa.” ");
INSERT INTO urim_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Kipm mpa kawor or wanyun wusok, pa ya wa kai kaino anong wor. Wa wanyun wail pa, ya wail wor wunongket a kinar anong paipm, wrongkwail am angkom or ya wail pake. ");
INSERT INTO urim_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pake wanyun wasek a ya wusok a kaino anong wor a rpma yongkyong pa kwapet, ti wrong wusoken kolti ansil ya kil ore.” ");
INSERT INTO urim_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","”Kipm itn riwe tu melnum okwripm kansil pa. Tu wli akipaarepm kolen manto walkg malkgu ak num enen tike, a ipma wunen pa kolen nimpa tilpmingen a aro angkwrer al kamel pa. ");
INSERT INTO urim_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mpa kipm uwi riwe tu pa kai ok alkil a angko pa la angko yo ok wor aki yo ok paipm. Melnum antiwe anel yo ok wain ur kai ampei iket paipm ur pa aki? Wa melnum antiwe awi tikga kulok aki tikga tukgun ur pa kai mi rungulet paipm ur pake? Kolpa kalpis. ");
INSERT INTO urim_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yo wor pa angko yo ok wor, a yo paipm pa angko yo ok paipm. ");
INSERT INTO urim_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yo wor ake mpa ngko yo ok paipm pa, a yo paipm ake mpa ngko yo ok wor pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yo wrongkwail a ake angko ok wor pa, mpa ware kirkok wangket rkol ngkli elng kai wakg. ");
INSERT INTO urim_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Am kolpa kipm ri nireinen tu melnum okwripm kansil pa kai kwap a tu ak pa.” ");
INSERT INTO urim_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","”Ikgake kipm wrongkwail mla ur a akwe nang a kupm ti la, 'Wailen, Wailen', pa ikga kawor anong wor a Yan akupmen kil ikgalen kaino kitnong pa, kalpis. Ikga tu mla ur a kanun nikgwalpm a Yan akupm wris ata pati ikga kawor anong wor pake. ");
INSERT INTO urim_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ik wang a kupm nar pa, ikga tu lanikopm la, 'Wailen, Wailen, am pikekg kitn pa ngkat okel men ti atom men laron nikgwalpm akitnen, a am men pikekg naren kitn ti ungkwan maur paipm a antokg kweikwei watipmen a men melnum ake antiwe antokg ak titnongket alpmen pa.' ");
INSERT INTO urim_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pake ikga ik wang pa ikga kupm laniken ngko wunong la, 'Kupm akwekgelepm paipm kolti, kipm a antokg paipmpaipm, ti kipm itni kai ai tukwelkgen kupm ti!'” ");
INSERT INTO urim_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kolpa ti wrongkwail mla ur a kil atning yangkipm akupmen kil alupmen atom kanun pa, kil pa kolen melnum wontrakole a kil ale wan ela wulkging. ");
INSERT INTO urim_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","U wail awei, minip kuwokg kop el, a wripm mring mring el pupu yikakatnen paipm kai itna wan pa, pake wan pa ake tapor, kalpis. Pati atnen pikekg kil ale ela wulkging. ");
INSERT INTO urim_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pake melnum a kil atning yangkipm akupmen ti atom ake kil kanun pa, kil kolen melnum titnowen a ale wan ela nimilpm. ");
INSERT INTO urim_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","U wail awei, minip kuwokg kop el, a wripm mring mring el pupu yikakatnen paipm kai itna wan pa, wan pa am tapor elng nar prapm paipm kolti.” ");
INSERT INTO urim_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Sisas kil la yangkipm pa kai plalng pa, wrongkwail kin a kipman pa tu atning yangkipm a kil kaling planten pa ari, pa almpen ipma. ");
INSERT INTO urim_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Eng ntei, kil ake kaling planten kolen tu melnum atuwen a aroaro wonel tu yangkipm a Moses pa, kalpis. Kil kaling planten nampon titnongket kol kil alkil yangkipm yiprokgen. ");
INSERT INTO urim_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sisas kil rpma kaino nang pa kaling planten plalng, atom kil kulnar pa, tu wrong kin a kipman wailet tu kanuntel nar. ");
INSERT INTO urim_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Atom melnum ur a i paipuk awi pa kil kai kapor kilko alein Sisas pa atom kil la, “Wailen, kupm ariwe la kitn antiwe titnongket pa, kol kitn wakrongen pa kitn antiwe antokg kupm ti palng wor.” ");
INSERT INTO urim_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sisas kil elng wam itna melnum pa a kil la, “Kupm wakrongen pa, kitn palng wor o!” Sisas kil la kolpa pa, i paipuk pa kai palng wor penterngen kolti. ");
INSERT INTO urim_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Atom Sisas kil lanakel la, “Ampur kitn lanaki melnum ur, yaper. Kitn or ya kai plan num akitnen pa kai melnum ipma krakgen a ak ak kwap eng al wor uk Maur Wailen pa eng kil ri kiporng yangkipm atom il wor uk kweikwei wor wor pa kai eng Maur Wailen, kol yangkipm titnongket a Moses kil la pa. Eng mpa tu wrongkwail riweitn la, i akitnen pa am wor ase.” ");
INSERT INTO urim_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Sisas kil kawor anong Kaperneam pa, melnum ur a tu Rom a itna ep eng tu melnum kamel wampwomis a almpwrong pa, kul lanaki Sisas la ngklinsel. ");
INSERT INTO urim_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Kil lanakel la, “Wailen, melnum akwapel a kupm ti numpet ti okg rmpa kai wan. Numpwam a kil pa amo plupmplepm a wa wleket paipm wrisen.” ");
INSERT INTO urim_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Sisas lanakel la, “Mpa kupm kai ungkwan numpet akilen pa.” ");
INSERT INTO urim_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pake melnum pa akalmpe Sisas pa la, “Wailen, kupm ake melnum wor eng mpa kitn kai wan akupmen pa. Kitn la ik ok ti kolti eng mpa kil palng wor. ");
INSERT INTO urim_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kupm ti yat kupm itna orngwatneikgen melnum wailen a itna ep eng kupm ti. Wa kupm ti tu melnum kamel wampwomis almpwrong wa itna orngwatneikgen kupm ti. Kupm lanaki melnum ur la, 'Kitn kai', pa kil kai, wa ur pa la, 'Kitn kul', pa kil kul. La melnum akwapel pa la, 'Kitn ikwap ti', pa kil ak.” ");
INSERT INTO urim_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sisas kil atning a kil la kolpa, kil wrekg paipm, atom kil la kai tu a kanuntel pa la, “Kupm lanakepm aklale wrisen, ake kupm ari melnum ur a kipm Isrel ti kil ukipma kolpa. ");
INSERT INTO urim_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kupm lanakepm la, wrong kin a kipman watipmen ikga ingkai takgni no a takgni kinar ikga wli uwi wrik rpmi eng il okipma nimpikgen Apraam, Aisak a Sekop, rpmi kaino anong wor a Maur Wailen kil ikgalen pa. ");
INSERT INTO urim_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pake kipm Isrel, kipm pa kol a rpmi kawor anong wor a Maur Wailen kil ikgalen pake, ari kalpis. Tiur ikga Maur Wailen kil ungkwantepm kai kinar anong miningket. Kinar anong pa ikga kipm uwi wleket paipm akg nampok paipm wrisen.” ");
INSERT INTO urim_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Atom Sisas kil lanaki melnum a itna ep eng tu melnum a almpwrong pa la, “Pati kitn kai o! Mpa kupm ntokg kitila kuina ur wet kitn la pa, kai or ipma alkitn a kitn uk pa.” Atom ak wang ketn pa melnum akwapel a melnum pa palng wor. ");
INSERT INTO urim_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sisas kil antokg melnum pa palng wor plalng pa wa kil kai kawor wan wunen a Pita pa, kil ari man yalmpikg a Pita pa numpet num wakget ti okg rmpa wrik pa. ");
INSERT INTO urim_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Sisas kil elng wam atne wam a man yalmpikg a Pita pa pipa, numpwakget pa kai kupuk, atom kil wrekg antokg okipma pa uk Sisas pa al. ");
INSERT INTO urim_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ak nungkurikg ti pa, tu aye melnum watipmen a maur paipm arpme pa, aye wli eng Sisas. Kil la kolti maur paipm pa kai takwlelkgten a kil antokg numpet a tu melnum wrongkwail pa palng wor. ");
INSERT INTO urim_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kil ak kolpa ti yangkipm a pikekg palng ep kai ok a Aisaia, melnum okwripm a Maur Wailen pa palng aklale, kil la kolpa, “Kil alkil pa arki numpet a wleket wakget amentepmen pa, atom kil ak titnongket alkil pa ak ungkwan.” ");
INSERT INTO urim_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sisas kil ari tu wrongkwailet paipm wli kapringentel pa, atom kil lanaki tu watnom alkil a kil aroaro wonel pa la, “Uwi nim ukupuken ti eng tepm kai ukupuk wompel ai!” ");
INSERT INTO urim_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Atom melnum ur a aroaro wonel tu yangkipm a Moses pa kul lanakel la, “Melnum a aroaro wonel tu, kupm nimprampen rpma la ntiweitn kai or ai ai. Ya wrik wrongkwail a ikga kitn kai pa, kupm ikga ntiweitn kai.” ");
INSERT INTO urim_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ari Sisas wa akalmpentel la, “Nimpa tilpmingen ti pa kanokg tawong a tu a okge pa itna. Wa wel ti pa wel ila alntu a okge pa itna. Warim Kipman a Melnum kil pa wrik kalpisen a okg armpe.” ");
INSERT INTO urim_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wa watnom ur a kil aro arowonel pa la, “Wailen, kitn la eng kupm yaper kai rpmi i eng uwen yan alkupm pa pen, plalng pipa, kupm wa kul kununteitn.” ");
INSERT INTO urim_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pake Sisas lanakel la, “Yaper, ampur kai. Tu alntu melnum a amo pa uwen tita o, a kitn ti kul kununtopm!” ");
INSERT INTO urim_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sisas kil elng kaino nim ukupuken pa, tu watnom alkil a kil aroaro wonel pa wa elng kaino. ");
INSERT INTO urim_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tu kai angko ukupuk kuin pa u mringkwripm wail pa el, atom ukupuk pa naimpur la kol a tipurng nim ukupuken pa, pake Sisas pa okg akwekgel rmpa. ");
INSERT INTO urim_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Atom tu aro ikgyokgel Sisas pa lanakel la, “Wailen, kitn wrekg ngklinso pen! U mringkwripm eng a tipurngto elng kinar ukupuk ti!” ");
INSERT INTO urim_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ari Sisas kil lanaken la, “Kipm ngkark eng kuina? Kipm ti ake ukipma itna titnongket!” Pipa kil wrekg angkeng u mringkwripm pa kai plalng. ");
INSERT INTO urim_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tu wrekg paipm atom tu la, “Kil pa kil melnum kolai, atom u a mringkwripm pa wa atning ok a kil pa atom tork pa?” ");
INSERT INTO urim_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sisas kil kai palng kai ukupuk wompel kai kanokg a tu Katara. Atom melnum wekg a maur paipm arpme pa kul ansilel angko ya. Wrik a tuwekg arpme rpma rpma pa kirkap. Tuwekg am wuten wrekg a pa kul pake. Tuwekg pa wrongen paipm a or kamel, ti tu melnum ake antiwe mpa or ya ri pa. ");
INSERT INTO urim_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Atom tuwekg kirkar la kolpa, “Warim Kipman a Maur Wailen, kitn la ntokg na men ti? Ti kitn wli la uk wleket men ti ep, a wang alkilen a antokg yangkipm pa apa?” ");
INSERT INTO urim_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Manto klungen ur al okipma itna wrerenten pa. ");
INSERT INTO urim_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tu maur paipm akwe Sisas pa yikakatnen la kolpa, “Kitn la ungkwanto kai kawor en pa, kitn la eng men kai kawor nowe manto klungen wailet pa.” ");
INSERT INTO urim_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Atom kil lanaken la, “Kipm kai o!” Kolpa atom tu naurng melnum wekg pa, tu kulor kai kawor nowe manto klungen pa. Atom manto klungen pa anel ngkark paipm kai kinar angko tipmining kinar al ukupuk pa amo plalng. ");
INSERT INTO urim_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tu melnum a ikgalen manto pa anel ngkark tulntul kai tatu anong wail pa lakati kweikwei wrongkwail wet a palng pa, wa nampon kuina ur a wet palng kai melnum wekg a maur paipm arpme pa. ");
INSERT INTO urim_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Atom tu melnum wrongkwail a anong pa tu wli ari Sisas. Tu akrarowel la mpa kil wrekg nuurng anong kanokg atuwen pa a kil kai itn kol ur ai. ");
INSERT INTO urim_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sisas wrekg elng kaino nim ukupuken pa kolti, kil wangket ukupuk pa kul kai anong alkil ai. ");
INSERT INTO urim_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Atom tu ngkat melnum ur a numpet nepm wam amo plupmplepm pa aye wli eng Sisas, aye kai ngkaten wrik pa rmpa. Sisas kil ari tu ukipma kil pa, kolpa atom kil lanaki melnum a numpet pa la, “Yek alkupm, ampur kitn ngkark. Paipmpaipm akitnen am Maur Wailen ungkwan ase.” ");
INSERT INTO urim_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Atom tu melnum tiur a aroaro wonel tu yangkipm a Moses pa, tu la ak ipma alntuwen pa la, “Melnum pa kil la kolpa pa kil ak nokgel Maur Wailen.” ");
INSERT INTO urim_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pake Sisas kil ariwe ase nikgwalpm a tu pa kolpa atom kil la, “Wa kipm akwonalmpen nikgwalpm paipm kolpa kai ipma akipmen pa eng ntei? ");
INSERT INTO urim_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ai wunongket eng mpa laniki melnum pa eng mpa kipm riwe la, paipmpaipm a kil pa am Maur Wailen ungkwan ase, aki mpa lanikel la, kil wrekg ngkom kai? ");
INSERT INTO urim_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pati mpa kupm plantepm eng kipm ri la, kupm Warim Kipman a Melnum antiwe titnongket itna kanokg ti a ak ungkwan paipmpaipm.” Atom wa kil plelng lanaki melnum nepm wam amowe pa la, “Kitn wrekg, uwi wrik alkitn pa atom iye kai wan alkitn pawo!” ");
INSERT INTO urim_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Melnum pa atning kolti, kil wrekg kai wan alkil ai. ");
INSERT INTO urim_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tu wrong kin kipman tu ari pa atom tu ngkark paipm. Atom tu ngkat nang a Maur Wailen eng kil uk titnongket kolpa kai tu melnum. ");
INSERT INTO urim_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Sisas kil wa antokg melnum nepmwam amo plupmplepm pa palng wor plalng pa, kil wa naurng anong pa angkom kai pa, kil ari melnum ur a awi awi marpmel tu pa rpma wan alkil a ak ak kwap pa. Nang a kil pa Matyu. Sisas kil lanakel la, “Kitn kul kununtopm!” Atom kil atning kolti, kil wrekg kanuntel. ");
INSERT INTO urim_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Wang wris ur pa Sisas nampon tu watnom alkil a kil aro wonel pa al okipma rka wan a Matyu pa, tu melnum wailet a awi awi marpmel tu, a tu melnum a antokg paipmpaipm, tu wli antiwen al okipma. ");
INSERT INTO urim_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tu melnum a arpmen yangkipm yiprokgen a Moses ari a tu al okipma nampon tu kolpa atom tu asen tu watnom a Sisas aroaro wonel pa la, “Antokg kolai ti melnum akipmen a kaling plan tu pa kil anti tu melnum a awi marpmel tu, a tu melnum a antokg paipmpaipm pa al okipma pa?” ");
INSERT INTO urim_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Sisas atning pa atom kil akalmpe la, “Tu melnum a numpworen pa tu ake kai eng tu melnum a ikgalen i numpet pa, kalpis. Tu melnum a numpet kolti. ");
INSERT INTO urim_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kipm kai uwi riwe yangkipm a ela kai wrkapm a Maur Wailen a la kolpa, 'Kupm karken a kipm alwor uk kupm ti pa, kupm wakrongen la kipm plan ipma wor rein tita.'” Sisas kil la oklala a Maur Wailen pa plalng pipa, wa kil la kil alkil ti la, “Kupm ake wli eng kipm melnum ute wor pa, kalpis. Kupm wli eng tu melnum paipm.” ");
INSERT INTO urim_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tu watnom a Son a kaluk tu aroaro wonel pa tu kul asen Sisas pa la, “Men ti nampon tu melnum a arpmen yangkipm yiprokgen a Moses pa men anti watipmen kalpis okipma eng uk wang Maur Wailen pake. Antokg kolai atom tu watnom a kitn aroaro wonel ti ake wa tu kalpis okipma eng uk wang Maur Wailen pa?” ");
INSERT INTO urim_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Sisas kil la kolpa, “Kin kipman ur a awi tita weten, atom tu yiprokgen alntuwekgen pa antokg okipma wail al atopen atnen. Ak wang a kipman pa antiwen rpma pa, tu ake rpma paipm, tu rpma atopen rpma. Pake ikga ik wang a tu uwi kipman pa iye kai tukuleikgten pa, ikga tu ipma kaikut ukwakg nare okipma pa rpmi.” ");
INSERT INTO urim_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sisas kil la pa plalng wa kil wa lala, “Mentepm ake wa awi apm umpu maing pa, atom angkut arpme apm nungkwor a rakol pa. Kolpa mpa apm umpu maing pa ik rkolng apm nungkwor pa mpa kai rakol wail. ");
INSERT INTO urim_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mentepm ake wa alung u wain weten pa elng kinar rka palk tingklaket a manto walkg tumpulmpis pa. Kolpa pa mpa u wain weten pa la ngki pa, mpa ik tita palk tingklaket pa kitnangku kai paipm, atom u wain pa turus kai paipm. U wain weten pa mentepm alung alung elng kinar rka manto palk weten alkil ai, pati mpa wor yatenen pake.” ");
INSERT INTO urim_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Sisas kil la yangkipm pa itna pa, melnum wailen ur a tu Suta pa kul kapor kilko alein kil pa la, “Warim kin akupmen wet ketn ti amo, kolpa ti kitn kai la elng wam itne, eng mpa kil wrekg rpmi.” ");
INSERT INTO urim_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Atom Sisas kil wrekg kanun melnum pa kai, a tu watnom alkil pa wa antiwel kai. ");
INSERT INTO urim_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Atom kin ur num walmpopm alp akangklei wang pa, itna kolen wring wampwam yikak wekg. Kil kanukg yirokg a Sisas pa akwonalmpen atom kil la kai kil alkil pa la, “Kol kupm ik wam inte apm wulompen a Sisas pa waiketn kolti pa, kupm mpa palng wor.” Atom kil ak katila kol a kil akwonalmpen pa. ");
INSERT INTO urim_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sisas kil plelng ariwel kolti lanakel la, “Warim kin yek alkupm, ipma akitnen pa rki meen. Kitn palng wor ase atnen a kitn ukipma kupm ti.” Atom ak wang ketn pa, kin pa kil palng wor. ");
INSERT INTO urim_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Atom Sisas kil anti melnum wailen pa kai palng kai wan pa, kil ari tu a rka wan pa tiplam wampeng a akg nurkgatne antokg nungkulkg titno wailet paipm. ");
INSERT INTO urim_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Atom kil lanaken la, “Kipm kul or kai tukwelkg! Warim kin pa ake amo, palpa okg rmpa pa.” Ari tu pa wa ak ino almpel. ");
INSERT INTO urim_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tu ungkwan tu wrongkwail pa kul or kai en pa, atom kil kai kawor wamanti wam a warim kin pa pipa, kil wrekg. ");
INSERT INTO urim_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tu atning ari pa, atom tu aye yangkipm pa kai yela naki tu wrong kin a kipman tatu anong alntu pa. ");
INSERT INTO urim_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sisas kil naurng anong pa angkom kai pipa, melnum wulmpa paipmen wekg pa ekg kanuntel kai, atom ekg akwewel yikakatnen la, “Kitn watnom walpopm a yoampei a Tepit, kitn rein ngklin mentekg ti pen!” ");
INSERT INTO urim_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sisas kil kai kawor wan ur pa, ari melnum wulmpa paipmen wekg pa, ekg kai kaworntel. Atom kil asenten la, “Ipma akipmekg pa rka kol lala kupm antiwe titnongket mpa ngklinsepm aki?” Atom tuwekg akalmpe la, “Ei, Wailen, kitn antiwe pa.” ");
INSERT INTO urim_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Atom kil elng wam pa ela wulmpa atuwekg pa a kil la, “Kil mpa palng kunun kol a kipmekg ukipma pa.” ");
INSERT INTO urim_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kolpa atom wulmpa atuwekg pa palng kitnangku wor ari kweikwei. Atom kil alken yangkipm titnongket la, “Ampur kipmekg lanaki tu ur ai, yaper. Rpmi kipmekg alkipmekg ti kolti.” ");
INSERT INTO urim_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ari kalpis, tuwekg kai naki tu yela anong kanokg pa kwap a Sisas kil ak itna wulmpa a tuwekg ti. ");
INSERT INTO urim_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Melnum wekg pa kawor en la kai pipa, wa tu aye melnum ur a okmise a maur paipm arpme pa, aye or eng Sisas. ");
INSERT INTO urim_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sisas kil ungkwan maur paipm pa takwelkgen melnum pa, melnum okmise pa oklala. Tu wrongkwail ari pa, tu wrekg paipm atom tu la kolpa, “Pikekg ep pa ake mentepm ari kwei ur a kolpa palng itna Isrel ti!” ");
INSERT INTO urim_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pake tu melnum a arpmen yangkipm yiprokgen a Moses pa tu la elukgen kolpa la, “Palpa maur paipm a itna ep pa alkel titnongket, atom kil ak ungkwan tu maur paipm pa.” ");
INSERT INTO urim_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Atom Sisas kil kai tatu anong wail wail a wusok wusok pa, kil kaling plan tu itna wan a tu atning atning yangkipm a Maur Wailen atnewe pa. A kil laron yangkipm wor a la Maur Wailen kil a itni wailen ikglen nol nikgwalpm amentepm. A kil antokg tu melnum a awi numpet a wleket auraur pa palng wor. ");
INSERT INTO urim_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kil ari tu wrong wailet paipm pa, ipma a kil pa areinsen paipm. Eng ntei, kil ari tu rka paipm titnowen num kolen manto walkg malkgu a ake melnum yan ur ikgalen tu pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Atom kil lanaki tu watnom alkil a kil aroaro wonel pa la, “Okipma wailet paipm tukgun kakir itna wring a pa, pake ake melnum akwapel wailet ur angketuwai okipma pa. ");
INSERT INTO urim_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kolpa ti kipm isen melnum yan a wring pa, eng mpa kil ukwa tu melnum kai eng ngketuwai okipma akilen pa.” ");
INSERT INTO urim_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sisas kil akwe tu watnom wampwam yikak wekg alkilen a kil aroaro wonel pa kaintel, atom kil alken titnongket a ak ungkwan maur paipm kimpilpet a, numpet a wleket wrongkwail a tu melnum pa palng wor. ");
INSERT INTO urim_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ri kil pa nang a tu melnum wampwam yikak wekg a kil takweien la ukwawen pa. Melnum ep pa Saimon, nang wompel pa Pita. A Antru paipmen a Pita pa, wa Semis ekg paipmen alkil pa Son, warim kipman wekg a Sepeti pa. ");
INSERT INTO urim_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Wa Pilip, Partolomyu, Tomas, Matyu melnum a pikekg awi marpmel tu, Semis warim kipman a Alpius, a Taitus. ");
INSERT INTO urim_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Wa Saimon a tu Selot, a Sutas Iskariot, melnum a ikga uk Sisas kai wam a tu wrongmanto. ");
INSERT INTO urim_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sisas kil lala ukwa tu watnom wampwam yikak wekg a kil pa kai laron yangkipm akilen pa, atom naki karkurngken la kolkil, “Ampur kipm kai eng tu melnum a ake Suta pa, a kai rka anong wail ur a tu Samaria pa, yaper! ");
INSERT INTO urim_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kipm kai eng tu melnum a Isrel, tu pa kolen manto walkg malkgu a kai atn palpa. ");
INSERT INTO urim_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kipm kai laron yangkipm pa laniken la, 'Maur Wailen wreren eng a ikglen ipma a kipm ti.' ");
INSERT INTO urim_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kipm kai ntokg tu melnum numpet pa palng wor, melnum a amo wa wrekg, melnum a i paipuk palng wor a ungkwan maur paipm! Kipm awi titnongket pa kalpmlel, kolpa ti kipm ik kalpmel kolti, ampur awi marpm. ");
INSERT INTO urim_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ampur kipm aye marpm kweikwei pa alupm kinar apm pa. ");
INSERT INTO urim_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ampur kipm aye apmkok pa nakurnum eng alupme apmnung kweikwei pa. Kuina ur wet kipm nowe itna num pa am iye pa kolti. Ampur wa aye apm a nowe, a nepm palk aki yo tuk a ak atnen pa, iyai. Kipm ngkompwam kolti, eng ntei, melnum a aken kwap angklin tu mla ur pa, mpa tu pa ikglentel pake. ");
INSERT INTO urim_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kipm kai kawor anong wail aki anong wusok ur pa pipa, kipm ri la melnum ur a wor a kil lkepm wor itopen la kipm ntiwel rpmi pa, kipm ntiwel rpmi kai wang pa plalng pa, kipm nuurng anong pa kipm kai. ");
INSERT INTO urim_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kipm kai kawor wan wunen a melnum ur pa pipa, kipm lken wor kolkil, 'Alkepm wor, Maur Wailen antiwepm rpma.' ");
INSERT INTO urim_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kol tu melnum a wan pa uwi wor eng ukwor a kipm alken pa, ukwor akipmen pa ntiwen rpmi. Pake kol ake tu awi wor eng ukwor a kipm alken pa, kipm wa uwi iye yaper kai. ");
INSERT INTO urim_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kol ake melnum ur awi wor eng awiyepm aye kai wan anong, a wa itning yangkipm a kipm la pa, kipm lo nepm mang pa itni pa, pa planten la kalkuten pa itna kai tu alntu pake, a kipm nuurng anong pa, a kipm kai. ");
INSERT INTO urim_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kupm lanakepm aklale wrisen. Ikga ik wang a tu wrong kin a kipman itni yangkipm wail a Maur Wailen pa, ikga Maur Wailen uk wleket waiketn tu Sotom a Komora. Pake ikga kil uk wleket wail manten kai tu anong a uk yirokg kipm, a yangkipm a kipm laron pa.” ");
INSERT INTO urim_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Sisas kil la kolpa plalng wa kil wa lanaki tu watnom alkilen a kil aroaro wonel pa la, “Kipm itning, kupm ukwawepm kai kol manto walkg malkgu kai kuin a nimpa tilpmingen. Kolpa ti kipm itni wontrakole kol ul pa. Kipm kunun nikgwalpm ute wor kolen wel punum pa. ");
INSERT INTO urim_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kipm itn riwe, eng kol tu melnum ikga uwiyepm iye kai ntokg yangkipm itni tu mring man ikgalen anong pa, a ikga wa kai ik ampei ntrawepm itni wan a kipm atning atning yangkipm a Maur Wailen atnewe. ");
INSERT INTO urim_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kipm ikga tu iyewepm kai ntokg yangkipm itni tu mring man wail wail a tu melnum tukgunakg, atnen kipm ak kwap a kupm. Kolpa eng mpa kipm laron yangkipm wor a kupm pa laniki tu melnum wail wail kolpa wa nimpon tu a ake Suta pa. ");
INSERT INTO urim_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ik wang a tu iyewepm kai eng ntokg yangkipm pa, ampur kipm ipma kaikut akwonalmpen watipmen la, mpa kipm la yangkipm na aki la kolai pa. Ikga ik wang ketn pa, ikga Maur Wailen lkepm yangkipm atom kipm la pa. ");
INSERT INTO urim_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yangkipmok ikga kipm la pa, ikgake kipm ti la pa, pa ikga Maur Wor a Yan Wailen alkipmen ti a rpma kawor ipma wunen a kipm ti oklala pa. ");
INSERT INTO urim_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ikga wailen wrekg uk wusok alkil kai wam a tu wrong manto eng tu ilmpel imo. Wa wusok wrekg wa ik kolpa yat kai eng wailen alkil. Tu yantin wa ntokg tu warim alntuwen kolpa yat. Wa tu warim wa plelng uk tu mansan alntu kai tu wrong manto eng tu ilmpen imo. ");
INSERT INTO urim_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tu wrongkwail ikga nikgwalpm paipm eng kipm, eng ntei kipm pa a kupm. Pake kol melnum a kil itna titnongket kolpa kaingkai angko wang a plalng pa, ikga Maur Wailen kil uwiyel iye kai rpmi wor. ");
INSERT INTO urim_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kol tu orepm ungkwantepm i anong ur pa pipa, kipm ngkirk kai anong ur ai. Kupm lanakepm aklale wrisen. Kipm ake antiwe ikwap a kupm ti kai yela tutu anong wrongkwail a Isrel ti plalng pa, kupm Warim Kipman a melnum pa ikga yaper nar. ");
INSERT INTO urim_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Warim a awi ariwe ti ampake itni ep wailen angen melnum a kaling plantel pa. A melnum a ak kwap kalpmel orngwatneikgen melnum ur pa, ake mpa wa kil itni ep wailen angen melnum yan a kwap pa. ");
INSERT INTO urim_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ariwe a warim pa mpa kaino repmrepm melnum a kaling plantel pa kolti, pa am apake. Am wa kolpa yat pake, melnum a ak kwap kalpmel orngwatneikgen yan a kwap pa, mpa ikwap repmrepm yan a kwap pa kolti, pa am apake. Pa planto la, tu aknokgel melnum yan a kin watnom a wan wris pa namput la Pelsepul pa, pa ikga wa tu iknokgel kin watnom akilen pa paipm wrisen angen melnum yan a wan pa!” ");
INSERT INTO urim_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","”Kolpa ti ampur kipm ngkark eng melnum pa. Kuina ur a pikekg aur pa ikga alken kai rmpi wunong. A kweikwei a itna ampen pa, ikga palng kai ngko wunong. ");
INSERT INTO urim_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kuina ur a kupm lanakepm ak mining pa, ikga kipm laron kolpa ik ran. Kuina ur a kupm akoo nakepm kai nungkulkg pa, ikga kipm itni tutu akapm wail pa la ik ok wail. ");
INSERT INTO urim_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ampur kipm ngkark eng melnum a alm numpalk amo pa, a ake antiwe mpa ilm amen wor pa imo pa. Pake kol a kipm ngkirk eng melnum a alm yatenen, numpalk a amen wor angkli elng kai anong paipm a awi wleket wakget. ");
INSERT INTO urim_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kol melnum ur la iye wel ikrawis wasek paipm wekg la iye kai eng ik uwi marpm pa, ake antiwe mpa uwi marpm wail, pa antiwe mpa uwi ik marpm watet wompel wris pa. Pake pa wail itna wulmpa a Yan Wailen, kil alkil la wel wasek pa la imo pa, antiwe mpa imo. Kalpis pa mpa kalpis. ");
INSERT INTO urim_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ti kipm ri, tukgunakg walk wris wris akipmen a itna tukgunakg ti pa kil angkleikg ase. Pa plantepm la Maur Wailen kil ikgalentepm. ");
INSERT INTO urim_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kolpa ti ampur kipm ngkark. Kipm melnum pa wa wor angen wel ikrawis waseksek pa.” ");
INSERT INTO urim_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Mla ur kil a laron kil alkil itna kuin a tu wrongkwail kin a kipman pa la kil akupmen pa, ikga kupm laron kil pa itni wulmpa a Yan akupmen kaino kitnong la kil pa akupmen. ");
INSERT INTO urim_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pake mla ur kil lam nang akupmen pa itna kuin a tu wrongkwail kin a kipman pa, ikga wa kupm lam nang a kil pa itni wulmpa a yan akupmen kaino kitnong. ");
INSERT INTO urim_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ampur kipm akwonalmpen la kupm kulnar kanokg ti eng ikga kipm rpmi meen wor pa, kolpa kalpis. Kupm nar eng ak aye rapon pa palng. ");
INSERT INTO urim_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kupm nar eng wako aro kipm itna manman. Warim kipman pa mpa nikgwalpm paipm eng yan alkil. Warim kin pa mpa nikgwalpm paipm eng man alkil. Wa warim kin pa mpa nikgwalpm paipm eng yalmpikg mayen alkil. ");
INSERT INTO urim_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Wrongmanto pa ikga palng itni wan wunen alkitn pake. ");
INSERT INTO urim_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Melnum a nikgwalpm wail a kil pa arken man a yan alkil pa, a nikgwalpm wusok a kil pa arken kupm ti pa, kil pa ake melnum wor antiwe a kanun kupm ti. Melnum a nikgwalpm wail a kil pa arken warim kipman a warim kin alkil pa, a nikgwalpm wusok a kil pa arken kupm ti pa, kil ake melnum wor antiwe a kanun kupm pa. ");
INSERT INTO urim_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Melnum a ake arki yo okgmangki alkilen atom kanuntopm pa, pa kil akentiwe a kanun kupm pa. ");
INSERT INTO urim_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Melnum a kil la ikglen numpalk a kil ti kolti pa, pa amen wor akilen pa ikga kai paipm. Pake melnum a kil uk num alkil ti kolti eng aken kwap kupm pa, pa amen wor akilen pa ikga rpmi wor yongkyong. ");
INSERT INTO urim_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Melnum a kil awi wor eng kipm pa, pa kil awi wor eng kupm ti, wa nampon melnum a kil ukwa kupm ti nar pa yat. ");
INSERT INTO urim_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kol melnum ur kil uk wor melnum okwripm a Maur Wailen eng kil melnum okwripm a Maur Wailen pa, ikga kil uwi kweikwei a akalmpe kwap a kol a melnum okwripm pa awi pa. A melnum a kil uk wor melnum ute wor kai wulmpa a Maur Wailen pa, ikga kil uwi kweikwei a akalmpe kwap a kol a melnum ute wor kai wulmpa a Maur Wailen awi pa. ");
INSERT INTO urim_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Wa kol melnum ur kil anong u ur uk melnum ur kolti il eng kil watnom alkupm a kupm aroaro wonel pa, kupm lanakepm aklale wrisen la, kil ikgake kalpis eng uwi kweikwei a akalmpe kwap a kil ak pa.” ");
INSERT INTO urim_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sisas kil uk yangkipm tu watnom wampwam yikak wekg a kil aroaro wonel pa plalng pa, kil wrekg a pa kai atn tatu anong tiur a Kalili pa eng kaling plan tu, laron yangkipm pa naki tu. ");
INSERT INTO urim_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Son kil rpma wan tipmning pa, kil atning yangkipm a kwap a Sisas kil ak pa, atom kil ukwa tu watnom tiur a kil aro arowonel pa ");
INSERT INTO urim_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kai asen Sisas pa la, “Sisas, am kitn ti melnum a pikekg men atning a lala ikga nar pa, am kitn tike, aki melnum ur a wai, mpa men rpmi nungkwangen?” ");
INSERT INTO urim_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ari Sisas akalmpe la, “Kipm yaper kai niki Son pawo, la kitila kuina ur a kipm atning a ari ti. ");
INSERT INTO urim_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tu a wulmpa tilmpisen pa tu wa ari kweikwei, tu a nepm paipmen pa tu wa wrekg angkom, tu a i paipuk awiyen pa tu wa palng wor, tu a nungkulkg titnowen tu antiwe atning kweikwei, tu melnum a amo tu wrekg rka, a tu melnum a rpma tukwok pa tu wa atning yangkipm wor a la Krais. ");
INSERT INTO urim_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mla ur a ari kwap a kupm ak ti atom ake kil uk yirokg kupm ti pa, kil pa wor pake, kil itopen o!” ");
INSERT INTO urim_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tu watnom a Son kil aro arowonel pa tu kai plalng pipa, Sisas kil lakati Son pa naki tu wrong kin kipman pa la, “Pikekg kipm kai wrik mpang kalpmel pa la ri kuina? Kipm kai la ri warum a wripm almpen aye kaingkul tike aki, ");
INSERT INTO urim_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","kipm kai la ri kuina? Kipm kai la ri melnum a nowe apm wor wor aki? Tu melnum a nowe apm wor wor a ak noworel num kolpa am rka kai wan a tu melnum tukgunakg pake. ");
INSERT INTO urim_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Atom ti pikekg kipm kai la ri kuina? Pikekg kipm kai la ri melnum okwripm pake? Kupm lanakepm aklale, Son a kipm pikekg kai ari pa, kil pa wa wailen angen melnum okwripm wrongkwail ai. ");
INSERT INTO urim_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Son, melnum pikekg wrkapm a Maur Wailen la ampake, la kolkil la, 'Itning! Kupm ikga ukwa melnum angklin ur akupmen a iye yangkipm ep eng kitn, kil ikga ep ukule ya eng kitn.' ");
INSERT INTO urim_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Pikekg Maur Wailen lanakopm kolpake. Kupm lanakepm aklale wrisen, itna kuin a tu melnum wrongkwail a pikekg man rakuwen itna kanokg a ti pa, ake melnum ur wailen angen Son melnum a kaluk tu pa. Pake melnum a awi nang wasek itna kuin a tu melnum a Maur Wailen kil itna wailen ikgalen nol nikgwalpm atuwen pa, kil pa awi nang wailen angen Son pake. ");
INSERT INTO urim_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Angkai wang a Son melnum a kaluk tu, kil angkli yangkipm pa kul wli wang ti pa, kwap a Maur Wailen la itni wailen ikglen nol nikgwalpm a kipm wrong kin kipman pa kul nampon titnongket, atom tu melnum kalnten titnongket pa kai antimprak tirpmingen titnongket la Maur Wailen kil itni wailen ikglen kipm wrongkwail. ");
INSERT INTO urim_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tu melnum okwripm wrongkwail a Maur Wailen, a yangkipm titnongket a Moses pa, tu kimeket la melnum ur ikga palng kolpa kulngkul wli wang a Son kil palng pa. ");
INSERT INTO urim_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kipm la itning yangkipm kil pa, kipm itning: Son pa kil Elaisa. Pikekg ep ai tu melnum okwripm a Maur Wailen tu la melnum ur ikga palng kolen Elaisa pa, ti Son am tike. ");
INSERT INTO urim_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Melnum a nungkulkg itnawe pa, kil itning o! ");
INSERT INTO urim_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Mpa kupm la yangkipm kla ur kolai eng tu melnum a ak wang ti? Mpa kupm la kolkil la: tu kolen tu warim a rka akapm, atom tu warim ur ai akwewen la, ");
INSERT INTO urim_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","'Men tiplam wampeng eng kipm ti, pake ake wa kipm atop. Wa men akg ak ok namputen, pake ake wa kipm akg arein.' ");
INSERT INTO urim_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Am kolpa yat pake, ake pikekg tu atning Son pa. Kil wli palng pa, kil uk wang eng oklala naki Maur Wailen, ake kil al u a okipma pa. Atom tu lawel la kil pa maur paipm arpme. ");
INSERT INTO urim_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pa wa warim Kipman a Melnum pa wli palng al u a okipma pa, tu la kil pa yat lala, 'Kipm ri kil pa! Kil al u a okipma watipmen paipm. Kil melnum a atn erkwon anti tu melnum a awi marpmel tu, a tu melnum a antokg paipmpaipm.' Pake nikgwalpm ariwe watin a Maur Wailen pa plan kai kweikwei a kil antokg pa palng ute wor aklale.” ");
INSERT INTO urim_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Atom Sisas kil la tu anong tiur a ake plelng ipma pa, la pikekg tu ari kweikwei titnongket titnongket wailet a kil antokg a melnum ake antiwe antokg pa, pake ake tu plelng ipma. Atom Sisas aklewen la pa tu antokg paipm. ");
INSERT INTO urim_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kil la, “Woi, arein kipmekg anong wekg pa, Korasin a Petsaita, kipmekg ikga uwi paipm! Kupm pikekg antokg kweikwei titnongket titnongket a melnum ake antiwe antokg pa itna kai anong akipmekg pa, ari ake wa kipm plelng ipma la arein. Kol pikekg kupm ntokg kweikwei titnongket titnongket irir kolti itni kai anong Tair a anong Saiton pa, tu kol piketak ai ngkli yipan akg rein paipmpaipm a tu antokg pa atom plelng ipma ase. ");
INSERT INTO urim_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kupm lanakepm la, ikga ik wang wail a itni yangkipm pa, kipmekg anong wekg pa ikga uwi wleket angen wleket a anong Tair a anong Saiton ikga uwi pa. ");
INSERT INTO urim_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ti kitn anong Kaperneam ti, kitn akwonalmpen la kitn ti wor, ti ikga uwiyetn iye kaino kitnong? Ikga kolpa kalpis. Pa kitn ikga ngkliweitn elng ngko wrik om miningket paipm kolti. Eng ntei, pikekg kupm antokg kweikwei titnongket titnongket a melnum ake antiwe antokg pa itna anong a kitn pa, ari ake wa kitn plelng ipma la arein. Kol pikekg kupm ntokg kweikwei titnongket titnongket irir kolti itni kai Sotom ai pa, tu ai kol am elngen a antokg paipmpaipm ase, ti anong a tu pa pikekg kol ake wakg il, kol a itni ik wang ti pa. ");
INSERT INTO urim_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pake kupm lanakepm la, ikga ik wang wail a itni yangkipm pa, ikga kipm uwi wleket paipm angen tu a anong kanokg Sotom pa.” ");
INSERT INTO urim_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ak wang pa Sisas kil la, “Yaiyai, kitn Wailen a kitnong a kanokg, kupm alkeitn wor ngkat nang akitnen eng kitn lam ariwe wor a kitn pa eng tu melnum a nikgwalpm arke, a tu melnum a awi ariwe wail pa, a kitn laron naki tu melnum a rpma titnowen kolen warim. ");
INSERT INTO urim_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aklale, Yaiyai akupmen, nikgwalpm ariwe wor akitnen pa am kitn ak kolpake. ");
INSERT INTO urim_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kweikwei wrongkwail am pikekg Yan akupmen elng kul wam akupmen ti ase. Melnum ur ake ariwe Warim Kipman pa, kalpis, Yan pa ariwe pake. Wa melnum ur ake wa ariwe Yan pa, kalpis, Warim Kipman wris ata pa ariwe pake. Wa tu mla ur a Warim Kipman kil wakrongen la plan Yan alkilen pa kai tu pa, am tu pa ariwe pake. ");
INSERT INTO urim_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kipm a aken kwap a arki kaikuten pa, kipm kul eng kupm ti, eng mpa kipm rpmi eng yapm. ");
INSERT INTO urim_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kipm uwi wor eng uwi riwe kupm ti a orngwatneikg kunun yangkipm a kupm ti, kolen manto nongko nepm watin a tu angkuten yo wompel ur itna meng pa eng ak arkolng kweikwei pa. Kipm uwi riwe kupm ti, eng kupm melnum a atn a rpma meen a orngwatneikgen mlaur, eng mpa nol nikgwalpm akipmen rpmi wor eng yapm. ");
INSERT INTO urim_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ei, yo wompel a kupm alkepm la kipm rki pa kukula antiwe a kipm rki. Wa kaikut a kupm alkepm la kipm rki pa ake kaikut.” ");
INSERT INTO urim_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ak wang wail a rpma eng yapm pa, Sisas anti tu watnom alkil a kil aroaro wonel pa anel angkom or wring wit kuin ur pa kai. Tu watnom alkil pa nikg alm, atom anel ipaar wit pa raing al itna wampel kai. ");
INSERT INTO urim_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tu melnum a arpmen yangkipm yiprokgen a Moses pa ari kolpa, tu lanaki Sisas pa la, “Kitn ri, tu watnom alkitn pa talpulng yangkipm titnongket a Maur Wailen eng tu ak kwap kolpa ak wang wail a rpma eng yapm pa.” ");
INSERT INTO urim_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ari Sisas kil akalmpe kolpa la, “Ake kipm angkleikg oklala a la kuina ur a pikekg Tepit antokg nampon tu melnum alkilen ak wang a pikekg tu nikg almpen pa? ");
INSERT INTO urim_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tepit awi tu melnum alkil pikekg kai kawor yalming apm a Maur Wailen ti awi nok tingklak a tu ermpa eng alwor uk Maur Wailen ti al eng nikg ti. Pa krimperken ti kol ake tu yimponen pa il pa, kol a tu melnum ipma krakgen a ak ak kwap eng al wor uk Maur Wailen ai il ai. ");
INSERT INTO urim_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ati ake wa kipm angkleikg yangkipm titnongket a Moses a la tu melnum ipma krakgen a rka yalming a Maur Wailen pa. Tu ak ak kwap eng al wor uk Maur Wailen ak wang wail a rpma eng yapm pa yat tu talpulng yangkipm titnongket a ampake ikwap ik wang wail a Maur Wailen a rpma eng yapm pa, pake pa ake tu antokg paipm pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kupm lanakepm la, melnum a itna ti pati itna ep angen yalming apm a Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nira ela wrkapm a Maur Wailen pa la kolkil la, 'Kupm karken a kipm alwor uk kupm ti pa, kupm wakrongen la kipm plan ipma wor rein tita.' Kol kipm riwe yangkipm yiprokgen kil riworwor pa, kol ake wa kipm elng ok itni tu melnum a ake antokg paipm pa. ");
INSERT INTO urim_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Eng ntei, Warim Kipman a Melnum pa kil Wailen itna ep ikgalen wang wail a rpma eng yapm.” ");
INSERT INTO urim_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Sisas kil wrekg a pa wa kil kai kawor wan ur a tu atning atning yangkipm a Maur Wailen atnewe pa. ");
INSERT INTO urim_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Atom melnum ur a wam wompel amo plupm tupmungkul kalpmlel pa anti tu rpma kawor wan wunen pa. Tu melnum a arpmen yangkipm yiprokgen a Moses a rka pa akor yangkipm la iye Sisas kai ntokg yangkipm, kolpa atom tu asen Sisas pa la, “Antiwe mpa mentepm ntokg tu melnum numpet ti palng wor ik wang wail a rpma eng yapm ti aki kalpis?” ");
INSERT INTO urim_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ari Sisas kil lanaken kolpa la, “Kol manto walkg malkgu wris anangket a kipm ur ti ngko lkim ik wang wail a rpma eng yapm pa, mpa kipm rpmi ri wulmpa kolti aki, mpa kipm latok ampei ik rkolng elng no? ");
INSERT INTO urim_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A melnum pa wa wor wrisen angen manto walkg malkgu pa. Kolpa ti pa wa ntiwe a ntokg kweikwei wor ik wang wail a rpma eng yapm pa.” ");
INSERT INTO urim_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Atom kil la kai melnum a wam wompel amo plupm tupmungkul kalpmlel pa la, “Ntran wam pawo!” Kil ntran pa, wam pa palng wor kolen wam wompel pa. ");
INSERT INTO urim_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tu melnum a arpmen yangkipm yiprokgen a Moses pa ari kolpa, tu kawor en kai or yangkipm eng la ilm Sisas pa imo. ");
INSERT INTO urim_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sisas kil ariwe nikgwalpm a tu melnum a arpmen yangkipm yiprokgen a Moses a akor yangkipm la ilmpel imo pa, atom kil naurngten itna anong pa a kil kai. Tu melnum watipmen kanuntel, atom kil antokg numpet wrongkwail a tu pa palng wor. ");
INSERT INTO urim_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","A kil alken yangkipm titnongket la, ampur tu lakati kil pa kai angko wunong naki tu wrong kin a kipman pa. ");
INSERT INTO urim_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kil ak kolpa atom oklala a Maur Wailen pikekg Aisaia melnum okwripm a Maur Wailen la pa palng aklale. ");
INSERT INTO urim_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Kil la kolpa, “Ri kil melnum akwapel a kupm alkupm pikekg takwei, kupm plan ipma wor wakrongentel, kupm ipma wor atopentel. Ikga kupm lkel Maur Wor akupmen ti, atom ikga kil laron nikgwalpm ute wor wor a kupm eng tu wrong kin a kipman itni kanokg pa. ");
INSERT INTO urim_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kil ikgake plalplal mainmain ikle kamel pa. Wa tu wrong kin a kipman ikgake itning kil oklala minsiranget tutu ya pa. ");
INSERT INTO urim_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wark ur a tapor umuwen pa, ikgake kil kipor eng kil tipor pa. Aki wakg tareing ur a wakg a itna tareing tringil pa waiketn eng a ime pa, ikgake kil mpe. Ikga kil ik kolpa kai, atom kweikwei wrongkwail ikga kitila nikgwalpm ute wor a Maur Wailen pake. ");
INSERT INTO urim_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Wrong kin a kipman a ake a tu Suta pa ikga ukipma kil pa a rpmi nungkwangen eng kil pa ngklinsen pake.” ");
INSERT INTO urim_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tu melnum tiur aye melnum ur a wulmpa tilmpisen a okmise, a maur paipm arpme pa, aye wli eng Sisas. Atom kil antokg ok a melnum pa kil oklala a wulmpa pa palng wor ari kweikwei. ");
INSERT INTO urim_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tu wrongkwail pa tu ari pa atom tu wrekg paipm asen tita la, “Melnum pa, mpam watnom walpopm a Tepit a mentepm nungkwangen am tike?” ");
INSERT INTO urim_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tu melnum a arpmen yangkipm yiprokgen a Moses pa atning a tu la kolpa atom tu aknokgel la, “Palpa Pelsepul, maur paipm tukgunakg a tu maur paipm pa alkel titnongket, atom kil ak ungkwan maur paipm pa takwelkg melnum pa.” ");
INSERT INTO urim_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sisas kil ariwe kuina ur a tu akwonalmpen pa atom kil lanaken la, “Kol tu anong kanokg wail ur wako iro wrong atom tu ilm tita pa, anong kanokg pa ake antiwe titnongket, ti tu mpa kai paipm. Kol om ur aki tu walmpopm wris pa wako iro tu alntu ti or tita pa, ampake ntiwe titnongket, ti tu mpa kai paipm. ");
INSERT INTO urim_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kolpa ti kol tu maur paipm ak kwapel tiur a Maur Paipm Satan pa tu ungkwan tu maur paipm ak kwapel tiur akilen pa, tu am wako aro ase. Ti mpa wa kil pa wa itni wailen ikglen tu pa la kolai? ");
INSERT INTO urim_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kipm la kupm ti la Pelsepul, melnum tukgunakg a tu maur paipm pa uk titnongket kupm ti atom kupm ak ungkwan maur paipm pa, ti tu alkipmen pa wa mla uk titnongket ti, atom tu ak ungkwan maur paipm pa? Atom tu alkipmen pa plan la yangkipm a kipm la pa kipm kansil. ");
INSERT INTO urim_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pake kil kupm ak titnongket a Maur Wor a Maur Wailen ak ungkwan maur paipm pa, ti kolpa plan kolen la Maur Wailen am nar itna wailen la ikgilen nol nikgwalpm a kipm tike. ");
INSERT INTO urim_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ake antiwe melnum ur kil tikale wan a melnum titnongket kalnten pa atom kawor ik ikgwampel kweikwei akilen pa. Mpa kil yipo nepm wampel melnum titnongket pa ep pa pati, antiwe mpa kil tikale wan akilen pa kawor uwi kweikwei pa iye kai plalng pake. ");
INSERT INTO urim_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Melnum a ake akupmen pa, kil pa awi wrongmanto lan eng kupm. A melnum a ake angklinsopm eng awi tu wrong kin kipman pa aye wli itna wris pa, kil pa melnum a ungkwan tu kai. ");
INSERT INTO urim_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kolpa ti kupm la lanikepm la, paipmpaipm a yangkipm paipm wrongkwail a melnum kil antokg pa, Maur Wailen kil ungkwan ase, pake kwei ur wris kil pa kalpis. Kol kil la paipmel Maur Wor pa, Maur Wailen ikgake ungkwan paipmpaipm akilen pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Melnum ur la paipmel Warim Kipman a Melnum pa, ikga Maur Wailen kil ungkwan paipmpaipm a kil pa. Pake melnum a kil la paipmel Maur Wor pa, paipmpaipm akilen pa ikgake Maur Wailen ungkwan ik wang ti a wa ik wang kunukg pa kalpis.” ");
INSERT INTO urim_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","”Kol kipm alkipm ikwonilmpen la yo pa wor pipa, pa mpa ngko ok wor. A kol kipm alkipm ikwonilmpen la yo pa paipm pipa, pa mpa ngko ok paipm. Kol kipm am ari nareinen yo pa kai ok alkil a angko pa la, yo wor a i, yo paipm a i. ");
INSERT INTO urim_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kipm pa kol ul angketepm, kipm alupm nikgwalpm paipm paipm kolti, kolpa ti oklala a kipm la pa ake antiwe mpa palng wor. Oklala ur a palng wli ok a melnum pa la pa, pa am plan nol nikgwalpm alkilen pa am kolpake. ");
INSERT INTO urim_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Melnum a kil alupm nikgwalpm ariwe wailet wor wor pa, oklala a kil pa palng kul or kai wor. Melnum a kil alupm nikgwalpm ariwe paipm paipm wailet pa, oklala a kil pa kul or kai paipm. ");
INSERT INTO urim_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kupm lanakepm la, ikga ik wang wail a itni yangkipm pa, kin a kipman wris wris ikga kai itni laron yangkipmok wrongkwail a pikekg kil la kalpmel pa. ");
INSERT INTO urim_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ikgam oklala a kitn lakati pa la palng wor pa, ikga Maur Wailen ukweweitn la kitn melnum wor. La oklala alkitn pa palng paipm pa, ikga Maur Wailen ukweweitn la kitn melnum paipm.” ");
INSERT INTO urim_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tu melnum tiur a aroaro wonel tu yangkipm a Moses, a tu melnum tiur a arpmen yangkipm yiprokgen a Moses pa anel la, “Melnum a aroaro wonel tu, men la ri kitn elng kla ur itni ik plan titnongket a Maur Wailen pa.” ");
INSERT INTO urim_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ari Sisas akalmpe ok a tu pa lala, “Kipm melnum paipm a ak wang ti, kipm a itna watin uk yirokg Maur Wailen kolen kin a angkli arkul kipman ur pa, ti wa kipm wa la ri kla ur la Maur Wailen elng itni ik plan titnongket akilen ai? Pake mpa kalpis. Ikga kipm ri kuina ur pikekg palng ep eng Sona, melnum okwripm a Maur Wailen pa kolti. Pa kol kla a Maur Wailen ikga elng itni ik plantepm titnongket akilen pake. ");
INSERT INTO urim_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ikgam palng irir kolen Sona pake. Sona pikekg rpma wang wraur miningkranen kawor nikg wunen a yul wail pa, am wa kol Warim Kipman a Melnum ikga rmpi wang wraur miningkranen kawor kirk wunen ti. ");
INSERT INTO urim_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ikga ik wang a Maur Wailen ntokg yangkipm nimpon kipm wrong kin kipman a ak wang ti pa, tu melnum a anong Ninipe pa ikga palng elng wam itni kipm wrong kin kipman a wang ti la kipm paipm. Eng ntei, pikekg tu atning yangkipm a Sona angkli pa, atom yangkipm pa almpen ipma atom tu pikekg plelng ipma ase. Ari melnum a itna ti pa wail angen Sona, ari ake wa kipm plelng ipma. ");
INSERT INTO urim_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ikga ik wang a Maur Wailen kil ntokg yangkipm eng tu wrong kin a kipman pa, ikga kin tukgunakg a pikekg itna ep ikgalen anong kanokg wangkokg ti ikga palng elng wam itni kipm wrong kin a kipman a wang ti la kipm paipm. Kin itna ep pa kil pikekg rpma kai kanokg wulompen watin ai a kanokg ti, ari kil pikekg aken kwap kul no la itning nikgwalpm ariwe watin a Solomon. Pake melnum ri kil pa angen Solomon, ari ake wa kipm atning nikgwalpm ariwe watin a kil ti.” ");
INSERT INTO urim_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Maur paipm kimpilpet kil kulor takwelkg melnum pa kai en pa, kil atn yela tatu wrik ur a ake melnum ur arpme pa akor wrik ur la la rpmi eng uwi yapm, pake ake kil ari wrik ur, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Atom kil wa la kolpa la, 'Pati mpa wa kupm yaper kai uwi wan anong alkupm a pikekg arpme ep pa.' Kil wa yaper kai ari wan kalpmel a pikekg kil arpme ep pa, am tu kansim ipikel noworel nakure ariworwor elng itna. ");
INSERT INTO urim_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Atom wa kil yaper kai, wa ikyakur maur paipm wampwomis wampwompwekg a paipm wrisen angen kil ti, wa aye wli antiwel rpma ipma a melnum a kil arpme ti. Pikekg ep pa melnum pa kil rpma paipm kolpake, wa kanukg ti a tu maur paipm pa wa kawor rpma pa kil pa wa rpma paipm wrisen or kai ai. Ti ikgam wa palng kolpake kai tu melnum paipm ik wang ti.” ");
INSERT INTO urim_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ak wang a Sisas kil oklala itna kuin a tu wrong kin a kipman wailet pa, man nampon tunteng wusok wusok alkil pa wli itna en akorel la ntiwel oklala. ");
INSERT INTO urim_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Atom melnum ur ai lanakel la, “Man alkitn ti nampon tunteng wusok wusok alkitn ti, wli itna kawor en ti akoreitn la ntiweitn oklala.” ");
INSERT INTO urim_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ari Sisas akalmpe nakel la, “Mla man akupm, a mla wusok wusok a kupm pa?” ");
INSERT INTO urim_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kil wam ntan tu watnom alkilen a kil aroaro wonel pa la, “Kitn ri man a tu wusok wusok akupmen pa am kilke. ");
INSERT INTO urim_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kol mla ur a antokg kuina ur kanun nikgwalpm wakrongen a Yan alkupm kaino kitnong pa, tu pa wusok wusok a manmuikg a mantin akupmen pake.” ");
INSERT INTO urim_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Itna wang pa Sisas kil wrekg a wan pa kawor en, atom kai rpma kai ukupuk yamping. ");
INSERT INTO urim_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pa tu wrong kin a kipman wailet paipm wli eng kil kolpa atom, kil tipra elng kaino rpma kaino nim ukupuken pa a, tu wrong kin a kipman pa rka ukupuk yamping pa. ");
INSERT INTO urim_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Atom kil lanaken yangkipm kla wailet. Kil lanaken la, “Kipm itning yangkipm kla ur kil: melnum ur kai laik wanukg erk kai wring. ");
INSERT INTO urim_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kil laik kolpa kai pa, ok tiur pa angko elng nar rmpa ya mlik kai wring wunen pa, atom wel pa wli al. ");
INSERT INTO urim_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Wanukg erk tiur pa angko elng nar rmpa tatu wrik weset. Ake kanokgen kolpa atom pa anip kulno pinterng. ");
INSERT INTO urim_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ari kalpis, takgni kulno el almpen pa, am amo ase. Eng ntei, ake angkli ningnakg pa elng kinar watin. ");
INSERT INTO urim_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wa wanukg erk tiur pa, angko elng nar rmpa wrik a ampei iket atne, atom ampei iket pa anip kulno ak ipaarng. ");
INSERT INTO urim_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Wanukg erk tiur pa angko elng nar kanokg wor, atom anip kaino palng ariwor. Tiur pa angko wailet, tiur pa wailet paipm, a tiur pa wa klangkil. ");
INSERT INTO urim_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kitn mlaur a nungkulkg atnewe pa, kitn itning yangkipm kil.” ");
INSERT INTO urim_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tu watnom a Sisas kil aroaro wonel pa kul asentel la, “Wa kitn la kla kla lanaken eng ntei?” ");
INSERT INTO urim_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Sisas kil akalmpe la, “Nikgwalpm ariwe ampen a Maur Wailen kil ikgalen ipma a melnum pa, am kil plan kipm tike, a kai tu pa kalpis. ");
INSERT INTO urim_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Eng ntei, melnum a kil antiwe pa, mpa Maur Wailen kil wa ngkine lkel wa klangkil. Pake melnum a kil tukwok pa, mpa Maur Wailen kil ungkwan waiketn a kil antiwe pa kai tukuleikgentel. ");
INSERT INTO urim_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kolpa ti kupm lanaken ak yangkipm kla pa la kai a tu ari pa, ake tu ari. Wa kai a tu atning ti pa, ake wa tu atning aki wa awi ariwe pa. ");
INSERT INTO urim_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kai tu pa, yangkipm a pikekg Aisaia, melnum okwripm la pa palng aklale. Kil la kolpa, 'Ikga kipm itning a itning, pake ikgake kipm riwe. Wa ikga kipm ri a ri, pake ikgake wa kipm ri. ");
INSERT INTO urim_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Eng ntei, ipma a tu melnum kil pa am kakiren paipm ase. Tu ampri nungkulkg alntu ti a ampri wulmpa alntu ti. Kolpa ti tu ake la itning a ri a uwi riwe pa, eng mpa tu plelng ipma, atom mpa kupm ntokgten palng wor pa.' ");
INSERT INTO urim_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kipm pa wor pake, kipm itopen o! Nungkulkg a kipm pa ak atning a wulmpa a kipm pa ak ari kweikwei pake. ");
INSERT INTO urim_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kupm lanakepm aklale wrisen la, pikekg ep ak ai tu melnum okwripm watipmen, a tu melnum ute wor a Maur Wailen pa wakrongen paipm la ri kuina ur a kipm ari ti, pake ake antiwe a tu ari. Wa la itning kuina ur a kipm atning ti, ari ake antiwe a tu atning.” ");
INSERT INTO urim_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Sisas kil la kolpa, “Atom kipm itning yangkipm yiprokgen a yangkipm kla a la wanukg erk a melnum laik kai wring pa. ");
INSERT INTO urim_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yangkipm kla a la wanukg erk a laik atom angko rmpa tatu ya mlik kai wring wunen pa, atom wel wli al pa pati la kolkil: kol melnum itning yangkipm a la Maur Wailen kil itna wailen ikgalen nol nikgwalpm a melnum pa, atom ake ariwe la yangkipm pa la kuina pa, maur paipm kil wli ungkwan yangkipm wor wuten a angkli naki melnum pa. ");
INSERT INTO urim_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Wanukg erk a angko rmpa wrik weset pati pa la tu melnum a atning yangkipm a Maur Wailen pa. Tu atopen eng awi yangkipm pa ak wang lmpiwen kolti. ");
INSERT INTO urim_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kai wang tingklaket pa melnum a kolpa ningnakg kalpisen, kil itna waiketn kolti. Tu melnum la paipmel nang a Maur Wailen pa alkel kaikuten a antokgtel paipm, pa kil am angko ase. ");
INSERT INTO urim_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Wanukg erk tiur a angko rmpa wrik a ampei ik ele pa pati, kol tu melnum a atning yangkipm a Maur Wailen pake wa tu ipma kaikut akwonalmpen watipmen eng kweikwei wrongkwail a kanokg ti, a wa tu aringkowe kweikwei watipmen la rpmi ntiwe. Atom pa akaur yangkipm a Maur Wailen ti atom ake anip kaino palng ariwor. ");
INSERT INTO urim_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pake wanukg erk a angko rmpa kanokg wor pa pati, la tu melnum a atning yangkipm a Maur Wailen pa alupmen ariworwor atom kanun pa, tu pa anip kaino palng ariwor. Tiur pa anip kaino wailet, tiur pa anip kaino wailet paipm, a tiur pa anip kaino wailet klangkil.” ");
INSERT INTO urim_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sisas kil wa la yangkipm kla ur a la Maur Wailen kil itna wailen ikgalen ipma a melnum pa la kolkil la, “Melnum ur kil kai laik wanukg erk kai wring alkil. ");
INSERT INTO urim_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mining wris ur pa, wrongkwail kin a kipman pa anel okg akwekgel rmpa pa, wrongmanto a melnum pa aye mi paipm pa kai laik kai wring pa nampon wanukg pa, atom am wa tital kai ase. ");
INSERT INTO urim_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ak wang a wanukg pa anip no eng a palng ariwor pa, wa tu ari mi paipm pa wa anip no nampon. ");
INSERT INTO urim_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tu melnum akwapel a melnum yan a wring pa kai asentel la, 'Melnum Wailen, men ti lala kitn pikekg laik wanukg akalkil kolti, ari wa antokg kolai atom mi paipm pa anip nampon wanukg pa itna pa?' ");
INSERT INTO urim_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Melnum yan a wring pa akalmpe la, 'Pa mpa wrongmanto pa ak kwap pake.' Ari tu ti wa asentel la, 'Ti kitn wakrongen la men kai iser mi paipm ai tukwelkg wanukg ai?' ");
INSERT INTO urim_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ari kil akalmpe naken la, 'Kalpis, ampur kipm kai aser, kol kipm kai iser pa, mpa wa kipm nulu wanukg pa nimpon. ");
INSERT INTO urim_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Elng itni yatenen wanukg a mi paipm kolpa kai ngko wang a wanukg pa inip kaino riwor pa, nulu kul. Ikga kupm laniki tu melnum ak kwapel alkupm ti, atom tu iser mi paipm pa ep elngtitni mapming mapming eng mpa ngkwol ngkli elng kai wakg. A tu iser wanukg pa iye kai ermpi wan okipma akupmen pa.'” ");
INSERT INTO urim_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sisas kil wa lanaken yangkipm kla ur kil la, “Maur Wailen kil itna wailen ikgalen nol nikgwalpm a melnum pa pati, kolen trumpwilm ipopm ok a wripm almpen aye kai anip yela tatu palpa. ");
INSERT INTO urim_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Trumpwilm ipopm ok pa waseksek, pake kil anip kaino watin wail talpuk atnewe atnewe kai pa kai pa kolen yo pa, angen okipma kweikwei a itna wring pa. Atom wel wrongkwail wli ak ila rka tatu talpuk pa.” ");
INSERT INTO urim_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sisas kil la yangkipm kla ur kil kolpa, “Maur Wailen kil itna wailen ikgalen nol nikgwalpm a melnum pa kolen mpim ap mringen a ak antokg nok mringen eng angki. Kin ur kil awi mpim ap pa aye kai ak oren nok nimongen pa plalng pa nok pa angki.” ");
INSERT INTO urim_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sisas kil la yangkipm wrongkwail a kil angkli kai eng tu wrongkwail kin a kipman pa ak yangkipm kla kolti. A ake kil laron yangkipm ur naken kai angko wunong pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kil ak kolpa pati pa palng aklale kai kanun ok a melnum okwripm pikekg awi ok a Sisas akla kolkil la, “Kupm mpa ik yangkipm kla ikalkilel ik laron yangkipm. Mpa kupm laron kweikwei auraur a itna am ep ak a antokg kanokg ai kul wli wang ti.” ");
INSERT INTO urim_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sisas kil ukwa tu wrongkwail kin a kipman pa kai, a kil kai kawor wan. Tu watnom alkil pa kaintel kai wan pa atom lanakel la, “Kitn laniko yangkipm kla a la mi paipm a itna wring pa ak la kuina?” ");
INSERT INTO urim_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Sisas kil akalmpe la, “Melnum a laik wanukg erk wor pa pati Warim Kipman a Melnum. ");
INSERT INTO urim_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Wring pa yangkipm kla a la kanokg ti. Wanukg erk pa pati la tu melnum a Maur Wailen itna wailen ikgalen pa, a mi paipm pa pati la tu melnum a Maur Paipm Satan itna wailen ikgalen pa. ");
INSERT INTO urim_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Wrongmanto a laik mi paipm pa pati la Maur Paipm Satan pake. Wang a nulu wanukg erk pa pati wang umpuwen a plalng a kanokg ti. Tu melnum ak kwapel a yan a wring pa pati tu maur angklin a Maur Wailen kolti. ");
INSERT INTO urim_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mi paipm pa tu melnum ikga iser atom lap kai wakg. Ikgam tu maur angklin a Maur Wailen ik kolpa ik wang umpuwen a plalng a kanokg ti. ");
INSERT INTO urim_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Warim Kipman a Melnum ikga ukwa tu maur angklin alkil pa eng tu ungkwan kweikwei a ak antokg tu melnum angko, a tu melnum wrongkwail a antokg paipmpaipm kai tukwelkg kweikwei wrongkwail wor wor a Maur Wailen kil ikgalen pa. ");
INSERT INTO urim_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Atom ngkliwen elng kai wakg wail manten. Kai wakg pa ikga tu kirkar akg nam ok paipm wrisen. ");
INSERT INTO urim_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pilpa tu wrong kin a kipman a Maur Wailen pa ikga klalen len kolen takgni a el pa kaino anong wor a Yan alntu ikgalen pa. Kipm melnum a nungkulkg atne pa, kipm itning o!” ");
INSERT INTO urim_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Maur Wailen itna wailen ikgalen ipma a melnum pa pati kolen kweikwei titnongket wor wor melnum ur kai ansil kai mpang pa, a melnum ur pikekg lam. Kil ari pa kil atopen paipm kolti. Kil kai uk kweikwei wrongkwail alkil ti ak awi marpm, atom wa aye yaper kai akarmpen kanokg pa, eng mpa kil uwi kweikwei titnongket wor wor pa.” ");
INSERT INTO urim_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Am wa kolpa yat pake, Maur Wailen itna wailen ikgalen ipma a melnum pa pati am kolen krim mikam wor a melnum aye marpm ak akor pake. ");
INSERT INTO urim_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kil ari krim mikam ur pa ari wor wail manten ak marpm wail, atom kil kai ak kweikwei alkil pa ak awi marpm kolti plalng pa, kil aye kai ak armpen krim mikam ari wor pa.” ");
INSERT INTO urim_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Yangkipm kla ur pa la kolpa, Maur Wailen itna wailen ikgalen ipma a melnum pa pati kolen apm mumu a angkli rka ukupuk pa eng ak awi yul auraur pa. ");
INSERT INTO urim_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Apm mumu pa pik eng yul pa, tu melnum a ak apm mumu awi awi yul pa, arkolng apm mumu pa ngkaten yul pa aye kulno nimilpm ti. Atom tu rpma angklo yul wor wor pa alupm rkwa, pake a paipm paipm pa awi angkli. ");
INSERT INTO urim_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ikgam palng kolpake ik wang umpuwen a kanokg ti kai plalng pa. Tu maur angklin a Maur Wailen pa ikga kai ngklo uwi tu melnum paipm pa itna kuin a tu melnum wor pa. ");
INSERT INTO urim_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Atom ngkliwen elng kai wakg wail, kai wakg pa ikga tu kirkar akg nam ok paipm wrisen kolti.” ");
INSERT INTO urim_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sisas asenten la, “Kipm ariwe kweikwei wrongkwail a kupm la pa aki?” Ari tu pa akalmpe la, “Ei, men ariwe pa.” ");
INSERT INTO urim_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Atom Sisas lanaken kolpa la, “Tu melnum a aroaro wonel tu yangkipm a Moses pa, tu ukipma Maur Wailen atom Maur Wailen itna wailen ikgalen ipma a tu pa pati, tu pa antiwe kaling plan yangkipm a Maur Wailen a ela kai wrkapm tingklaket wa nampon yangkipm weten ti. Tu pa kolen yan a wan wail ur. Tu kai kawor wan okipma ur pa, atom awi kweikwei weten a tingklaket pa nampon tita, atom aye kul or en ai, atom ampreing uk tu.” ");
INSERT INTO urim_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sisas lanaken yangkipm kla pa plalng pa, kil wrekg naurng anong pa. ");
INSERT INTO urim_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","A kil yaper kai anong alkil pa. Atom kil kaling plan tu yangkipm a Maur Wailen pa itna wan a tu atning atning yangkipm a Maur Wailen atnewe pa. Tu atning yangkipm pa kolpa atom tu wrekg paipm, atom tu la, “Kil awi nikgwalpm ariwe wail a kolpa kai a i? A wa kil awi titnongket a ak antokg kweikwei titnongket titnongket a melnum ake antiwe antokg pa kai a i? ");
INSERT INTO urim_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Melnum pa kil ti mpam warim kipman a Sosep, melnum a ale ale wan tike aki? A man alkil pa am nang a namput la Maria pake! Wa tu wusok wusok alkilen pa am Semis, Sosep, Saimon a Sutas pake! ");
INSERT INTO urim_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Wa tu muikgmayen akil pa am anti mentepm ti rpma tike! Ti melnum pa kil awi nikgwalpm ariwe wail pa kai a i?” ");
INSERT INTO urim_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tu la kolpa atom tu ipma paipm eng kil pa. Pake Sisas lanaken la, “Melnum okwripm pa akwap yela tatu anong wrongkwail ai, pa tu la kil nang arke. Pake anong alkilen, a tu a rka wan wris alkilen pa tu elukgentel la kil pa ake nang arke.” ");
INSERT INTO urim_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Atom ake kil antokg kweikwei watipmen ak plan titnongket a Maur Wailen. Pa atnen tu melnum ti ake ukipma kil pa. ");
INSERT INTO urim_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ak wang pa Erot, mring tukgunakg a ikgalen anong kanokg Kalili pa, kil atning yangkipmok kwap a Sisas kil ak pa. ");
INSERT INTO urim_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Atom kil lanaki tu melnum ak kwapel alkil pa la, “Pa Son melnum a pikekg kaluk tu pa mol? Kil pikekg kupm la tu orel amo, atom kil wa wrekg a kirkap pa kulor rpma, ti kil antiwe titnongket wail a antokg kweikwei kolpake.” ");
INSERT INTO urim_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Pilip pa paipmen a Erot. Erot kil karpo wampel Erotias, kin paipmen alkil. Pikekg Erot kil or Son a kaluk tu pa eng kil oren lala, ake wor a kil awi kin a paipmen alkil pa aye pa. Kolpa atom Erot kil lanaki tu arkul Son pa angkuten wampel kolti aye kai rpma kai wan tipmining pa. ");
INSERT INTO urim_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kil la orel imo pake tu wrong kin a kipman pa lala Son pa melnum okwripm a Maur Wailen, kolpa atom kil ngkark eng tu wrong kin a kipman tike. ");
INSERT INTO urim_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ak wang ur pa tu wli rka nampon Erot pa antokg okipma al akwonalmpen wang a pikekg man rakuwel pa. Atom warim kin a Erotias ekg Pilip, a Erot awi wampuk pa, or angkli nepm eng nangnang a tu antokg pa itna kuin a tu wrong a wli rka pa. Atom Erot pa kil atopen paipm. ");
INSERT INTO urim_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kolpa atom kil yapon yangkipm wam kaino kwa la, kuina ur a warim kin alkil isen pa, mpa kil lkel pa. ");
INSERT INTO urim_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Erotias, man a warim kin pa, alkel yangkipm atom kil lanaki Erot pa la, “Kitn la eng tu wangket mengkel Son a pikekg kaluk tu pa atom nimong rmpen tukgunakg pa iye kul lkopm!” ");
INSERT INTO urim_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pake Erot melnum tukgunakg kil atning kolpa atom kil ipma kaikuten paipm. Pake kil akwonalmpen yangkipm a wet kil yapon wam kaino kwa itna wulmpa a tu wrongkwail a antiwel al okipma rka pa. Kolpa atom kil awi wor eng la ntokg kol ok a warim kin alkil la pa. ");
INSERT INTO urim_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Atom kil ukwa tu kai angket mengkel Son kai wan tipmining pa. ");
INSERT INTO urim_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Plalng pa, wa awi tukgunakg pa kimpang armpen kolti aye kai uk warim kin pa, atom kil awi aye kai uk man alkil pa. ");
INSERT INTO urim_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tu watnom a Son pikekg aroaro wonel pa atning kolpa atom tu anel kulngkul ngkat num mutung a kil pa aye kai uwen, atom tu kai lakati naki Sisas pa. ");
INSERT INTO urim_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sisas kil atning a tu kul lanakel a tu wangket mengkel Son pa kolpa atom kil tipra kaino awi nim ukupuken pa kai wrik kalpmel ur pa eng mpa kil alkil rpmi pen. Ari kalpis, tu wrong kin a kipman wailet a anong lkgung lkgung pa atning a kil kai kolpa atom tu angkom ak nepm pa kanuntel kai wrik ur a kil kaiye pa. ");
INSERT INTO urim_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sisas kil awi nim ukupuken pa kai palng tipra elng nar kolti ari tu wrong kin a kipman wailet am anel wli pilpal tike. Kil ari kolpa, kil areinsen paipm. Atom kil ungkwan numpet wrongkwail a tu pa palng wor. ");
INSERT INTO urim_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kil ak kwap kolpa kaingkai nungkurikg pa, tu watnom alkil a kil aroaro wonel pa kai lanakel la, “Wang am plalng tike. Mentepm rpma wrik mpang mis kolti, ti mpa mentepm uwi okipma kai ai il. Ti la eng kai tu kai rmpen okipma il tutu anong tiur ai.” ");
INSERT INTO urim_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ari Sisas lanaken la, “Tu ake mpa kaingkai, kipm ti lken okipma ur eng tu il rki tike.” ");
INSERT INTO urim_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ari wa tu wa akalmpe lala, “O! Men ti wet ake aye okipma watipmen ur kalpis. Men wet aye nok tingklak wampwomis a yul wekg kolti.” ");
INSERT INTO urim_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ari Sisas akalmpe la, “Pati uwi iye kul lkopm.” ");
INSERT INTO urim_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Atom Sisas lanaki tu wrong kin a kipman pa la, “Kipm ngko rpmi tutu mi ti.” Atom kil awi nok tingklak wampwomis a yul wekg pa aye itna, kil ngkat ikg kaino kitnong pa ukwor Maur Wailen pa plalng pa, kil kapor uk tu watnom alkil pa awi ampreing uk tu wrong kin a kipman pa al. ");
INSERT INTO urim_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tu al al nikgwor kolti atom, umpu umpu pa tu watnom pa awi aye kai alupm kai numong pa wampwam yikak wekg. ");
INSERT INTO urim_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tu melnum a al okipma pa wailet paipm kamel kamel (5,000), pake ake tu angkleikg tu kin a warim pa. ");
INSERT INTO urim_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Atom Sisas kil naki tu watnom alkil a kil aroaro wonel pa la, “Kipm tipra kaino nim ukupuken pa atom kipm eptopm kai itni kai ukupuk wompel ai o! A kupm itni ukwa tu ti kaingkai atom kupm am kaintepm pake.” ");
INSERT INTO urim_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kil ukwa tu pa kai plalng pa, wrik kalpm ti pa kil kai kaino mining kaino nang ai. Kil alkil wris rpma oklala naki Maur Wailen pa rpma. ");
INSERT INTO urim_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pipa tu watnom a kil aroaro wonel a wet awi nim ukupuken kai pa, pa tu am kai angko kai ai wreren ukupuk kuin ase, ari kalpis, wripm wail pa el a won tu pa kul kolti la ik tipurngten, ari tu ak erkise kolpa ampen kai. ");
INSERT INTO urim_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wreren eng a ukwe ti pa Sisas angkaino nang pa nar angkom or u kwa pa kanunten kai. ");
INSERT INTO urim_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tu ariwel a kil angkom a u kwa pa kul pa tu ngkark kirkar akg paipm la mring maur ur ingkai wli pa. ");
INSERT INTO urim_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ari Sisas am la ase, “Ampur kipm ngkark, kipm kirkiti num walmpopm pa rki o! Kil kil kupm tike.” ");
INSERT INTO urim_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Atom Pita kil lala, “Wailen kol kitn iklale pa, kitn lanikopm eng kupm ngkom or u kwa pa kainteitn.” ");
INSERT INTO urim_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ari Sisas la, “Ti kitn kul o.” Atom Pita wrekg naurng nim ukupuken pa kil angkom or u kwa pa kaintel. ");
INSERT INTO urim_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pake kil ari wripm pa el titnongket wail paipm atom kil ngkark, kolpa atom nepm wekg kil ti elng kinar kinar u wunen ai. Atom kil kirkar akwe la, “Wailen, kitn ngklinsopm pen.” ");
INSERT INTO urim_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ari Sisas kil pinterng kai wamparpmewel elng no a lanakel la, “Ipma wail a kitn ti ake arken kupm ti. Ipma a kitn ti rka wekg wekg eng ntei?” ");
INSERT INTO urim_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Atom tuwekg tipra elngkaino nim ukupuken pa, a wripm pa kai tork kolti. ");
INSERT INTO urim_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","A tu a rka nim ukupuken pa kapor kilko aleinsel a tu lala, “Aklale wrisen, kitn pa Warim Kipman a Maur Wailen.” ");
INSERT INTO urim_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tu rpma nim ukupuken angket ukupuk pa kai palng kai ukupuk yamping a anong Kenesaret. ");
INSERT INTO urim_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Atom tu wrong kin kipman a anong pa ariwel kolpa tu lala, Sisas ampake. Atom tu ayewen yangkipm pa kai yela tatu anong a ela wreren anong pa, atom tu aye tu melnum numpet numpet pa aye wli eng Sisas pa. ");
INSERT INTO urim_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Wa tu lanakel la kol a kil la eng tu wampirpme apm umpu waiketn ur akilen ti kolti. Atom tu a wamparpme apm umpu akilen pa tu palng wor. ");
INSERT INTO urim_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tu tiur a tu melnum a arpmen yangkipm yiprokgen a Moses, a tu melnum tiur a aroaro wonel tu yangkipm a Moses pa, tu naurng Serusalem pa kul ari Sisas, atom tu asentel la, ");
INSERT INTO urim_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Antokg kolai atom wa tu melnum a kanun kitn pa tu angketen yangkipm a tu mamikgmamin mansan yapon pa? Ake tu klak wam alntu pa ep atom tu ak al okipma pa!” ");
INSERT INTO urim_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ari Sisas kil akalmpe la, “Kipm pa klak wam pake, antokg kolai atom kipm ti kanun yangkipm titnongket a tu mamikgmamin mansan pa, atom ak angketen yangkipm titnongket a Maur Wailen a la kolkil ");
INSERT INTO urim_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","la, 'Kipm mpa orngwatneikgen man a yan alkipm.' A 'Mlaur a kil la paipmel man a yan pa, pa ikga tu orel imo.' ");
INSERT INTO urim_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pake kipm wa la kolkil, 'Melnum ur a kil lanaki man a yan pa la, “Kweikwei kil kupm la ik ngklinsepm pake, pikekg kupm ermpa ak namput la uk Maur Wailen.” ");
INSERT INTO urim_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kolpa ti kil ake mpa orngwatneikgen man a yan alkil pa atom lken marpm pa.' Kwap a kipm ak kolpa pa ake kipm orngwatneikgen man a yan alkipm pa, pa kipm kanun ya nilping a mamikgmamin mansan alkipm pa atom kipm ak angketen yangkipm a Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kipm melnum a plan num enen pa manet, a num wunen pa manet pa, kuina ur a pikekg Aisaia melnum okwripm la pa, kai atnen kipm pake, kil la kolkil, ");
INSERT INTO urim_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'Tu wrong kin a kipman pa ngkat nang akupmen pa ak num enen. Pake ipma wunen a tu pa itna watin eng kupm ti. ");
INSERT INTO urim_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tu ngkat nang a kupm ti kalpmel kolti. Eng ntei, yangkipm a tu kaling plan tu pa, pa yangkipm pikekg tu melnum ti yapon kolti, a ake akupmen pa.'” ");
INSERT INTO urim_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Sisas kil akwe tu wrongkwail pa wli itna atom kil lanaken la, “Kipm itning a riwe kuina ur a kupm la kil! ");
INSERT INTO urim_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kweikwei a a en ti kai kawor ok wunen a melnum pa, ake antokg melnum pa kimpilpet, kalpis. Pake kweikwei a rpma kawor ipma wunen a melnum pa atom kulor kai en pa, antokg melnum pa kimpilpet pake.” ");
INSERT INTO urim_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tu watnom a Sisas aroaro wonel pa, tu kul ari Sisas pa lanakel la, “Ti kitn ariwe tu melnum a arpmen yangkipm yiprokgen a Moses pa ipma paipm eng yangkipm wuten a kitn la pa aki?” ");
INSERT INTO urim_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ari Sisas kil akalmpe la, “Yan akupmen a rpma kaino kitnong pa wring itna. Kweikwei a ake pikekg kil alkil ti alin pa, ikga kil ngkon nulung kulung. ");
INSERT INTO urim_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Elngen tu pa itni pa, pa tu kolen melnum a wulmpa tilmpisen. Melnum ur a wulmpa tilmpisen pa kil irkwampel melnum wulmpa tilmpisen ur pa iye kai pa, tuwekg yatenen mpa ekg ngko elng kinar wrik tungkuren pa.” ");
INSERT INTO urim_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ari Pita kil lala, “Kitn lakiti yiprokgen a yangkipm kla pa eng men ti itning ri!” ");
INSERT INTO urim_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ari Sisas lanaken la, “Kipm ti yat, nikgwalpm a kipm ti titno, ake kipm ariwe la, ");
INSERT INTO urim_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","kweikwei wrongkwail a elng kawor ok atom al elng kinar rpma nikg pa, pa am aken pain kai kinar tingkil ase. Kweikwei pa ake antokg melnum kimpilpet pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pake kweikwei a akwonalmpen rpma kawor nol nikgwalpm pa, atom palng la kai ok ti kulor kai en pa pati, pa antokg melnum pa palng kimpilpet pake. ");
INSERT INTO urim_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kweikwei kimpilpet a palng kawor nol nikgwalpm pa pati: nikgwalpm paipm, or melnum amo, angkli arkul tita, akwap numkropis a uk numpaipm kamel, a ak ikgwam, la yangkipm kansil, a la paipmel melnum ur aki Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kweikwei wrongkwail kolpa pa antokg melnum pa palng kimpilpet. Pake kol ake klak wam atom al okipma pa, pa ake antokg melnum pa kimpilpet, pa kalpis.” ");
INSERT INTO urim_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sisas kil naurng anong pa, wa kil kai anong kanokg a Tair a Saiton. ");
INSERT INTO urim_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kin wris ur a tu Kenan, kil alkil a rpma anong kanokg a pake. Ake kil kin a tu Isrel pa, kil kai eng Sisas pa atom kil la, “Wailen, kitn walpopm a angket ale a Tepit pa kul, kitn rein kupm ti. Maur paipm rpma kawor warim kin a kupm ti atom antokgtel paipm.” ");
INSERT INTO urim_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pake Sisas ake akalmpe ok a kin pa, ake kil la kwei ur. Atom tu watnom alkil pa kaintel atom tu lanakel la, “Kitn ukwa kin ti kai, wet ak ai kanun akwe akwe atn ai.” ");
INSERT INTO urim_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ari Sisas kil akalmpe la, “Maur Wailen ake ukwa kupm ti nar eng tu anong manet pa. Kil ukwa kupm ti nar eng tu Isrel ti kolti. Tu a kol manto walkg malkgu a kai am atn palpa.” ");
INSERT INTO urim_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ari kalpis, kin pa kil kai kapor kilko aleinsel a lanakel la, “Wailen, kitn ngklinsopm pen.” ");
INSERT INTO urim_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ari Sisas kil akalmpe ak yangkipm kla pa la kolpa la, “Ampake kupm uk okipma a tu warim ti kai nimpa pa il, kolpa ake wor.” ");
INSERT INTO urim_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pake kin pa akalmpe la, “Wailen, pa aklale wrisen, pake nimpa antiwe al okipma a yan pa kil uk warim pa al, atom ipran angko rmpa kanokg pa.” ");
INSERT INTO urim_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Atom Sisas akalmpentel la, “Ai, kin, kitn ukipma wail paipm eng kupm ti. Kolpa ti mpa palng ntokg kitila kol a kitn wakrongen pa.” Atom ak wang pa, warim kin a kil pa palng wor. ");
INSERT INTO urim_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Sisas kil naurng anong pa a kil antila or ukupuk Kalili yamping pa kai kaino rpma kaino wrik nangen ur pa. ");
INSERT INTO urim_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kin a kipman wrongkwail aye tu a nepm paipm, wulmpa tilmpisen, yilo tintompen, ok mise, wa nampon tu watipmen tiur ai aye wli yat, rka nepm a kil pa. Atom kil ungkwan numpet a tu pa palng wor. ");
INSERT INTO urim_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Atom tu wrong kin a kipman tu wrekg paipm or nol alntu, eng tu ari tu melnum okmise pa oklala, yilo tintompen pa angkom ute, nepm paipmen pa angkom ariwor a wulmpa tilmpisen pa ari kweikwei. Kolpa atom tu ngkat nang a Maur Wailen a tu Isrel pa. ");
INSERT INTO urim_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sisas kil akwe tu watnom alkil a kil aroaro wonel pa kul atom kil lanaken la, “Kupm arein tu wrong kin a kipman ti, tu antiwopm rpma wang wraur, ti mpa tu il kuina. Kupm karken ukwawen kai anong pa, mpa nikg ilmpen a wulmpa pereten tutu ya pa.” ");
INSERT INTO urim_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Atom tu watnom alkil pa asentel la, “Mpa mentepm ikor okipma ur kai a i itni wrik mis ti eng ik kiporlei tu wrong wailet paipm ti?” ");
INSERT INTO urim_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ari Sisas asenten la, “Nok tingklak aripm rmpa?” Ari tu akalmpe la, “Nok tingklak rmpa wampwomis wampwompwekg nampon yul waseksek pa ake watipmen.” ");
INSERT INTO urim_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Atom Sisas kil lanaki tu wrong kin a kipman pa la tu rpmi kanokg pa. ");
INSERT INTO urim_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","A kil awi nok tingklak wampwomis wampwompwekg pa nampon yul waseksek pa, atom kil ukwor Maur Wailen pa plalng pa, kil kapor kolpa uk kaingkai tu watnom alkil pa, atom tu pa awi ampreing uk tu melnum pa. ");
INSERT INTO urim_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tu al al nikgwor antiwe kolti, a okipma umpu umpu pa rmpa. Atom tu watnom pa awi okipma umpu umpu pa alupm kinar numong pa, numong wampwomis wampwompwekg pa no pik. ");
INSERT INTO urim_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tu melnum a al okipma pa, tu melnum wailet paipm kamel kamel (4,000), ake tu angkleikg tu kin a warim pa. ");
INSERT INTO urim_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kil ukwa tu wrong kin a kipman wailet pa kai plalng pa, kil elng kaino nim ukupuken pa, atom kil kai anong kanokg a Makatan. ");
INSERT INTO urim_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tu melnum a arpmen yangkipm yiprokgen a Moses a tu Satyusi tu kul eng Sisas pa. Atom tu aknukwar akor nikgwalpm a Sisas pa la kil laron kwei ur pa niken. Tu lanakel la, “Kitn elng kla ur itni ik plan titnongket a Maur Wailen pa, eng men ri la Maur Wailen alkeitn titnongket aki.” ");
INSERT INTO urim_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ari Sisas akalmpe ok atuwen pa la, “Nungkurikg pa takgni yipuken pa aner watet pa, ikg pa ikga takgni wor. ");
INSERT INTO urim_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Wa or kong pa takgni pa aro tangkoren a elng nar mining pati plan kolen la u mpa wei. Pa aklale, kipm ariwe kitnong a plan u a takgni pake, kweikwei a palng ak wang ti pa, pa ake kipm ariwe la pa akla kuina. ");
INSERT INTO urim_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kipm wrong kin kipman a wang ti pa, kipm paipm a uk yirokg Maur Wailen kolen kin a angkli arkul kipman ur pa. Kipm akor la ri kla ur a ik plantepm titnongket a Maur Wailen pake, mpa kalpis. Ikga kipm ri kuina ur pikekg palng ep eng Sona, a ur manet pa kalpis. Pa kol kla a Maur Wailen ikga elng itni ik plantepm titnongket akilen pake.” Kil la kolpa plalng kil naurngken kai. ");
INSERT INTO urim_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Sisas anti tu watnom alkil a kil aroaro wonel pa awi nim ukupuken pa angket kai wompel ai. Pa tu watnom alkil pa woniketen nok tingklak wet la mpa uwi iye pa. ");
INSERT INTO urim_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ari Sisas lanaken la, “Kipm uk ikg riwe itni watin tukwleikgen nikgwalpm a tu melnum a arpmen yangkipm yiprokgen a Moses a tu Satyusi pa: tu pa kansil plan ak num enen ti kolti, pa kol mpim ap mringen a ak oren kai or arpme nok ti plalng, atom angki wail.” ");
INSERT INTO urim_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tu alntu watnom a Sisas pa akor la itna kuin alntuwen pa la, “Ati kil la yangkipm pa eng ake mentepm aye nok tingklak ur aye kul.” ");
INSERT INTO urim_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ari Sisas kil ariwe kuina ur a tu la pa atom kil lanaken la, “Ake kipm ukipma kupm ti itna titnongket, atom wa kipm akor la watipmen la nok tingklak pa kalpis pa. ");
INSERT INTO urim_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ake wa kipm ariwe? Ake kipm akwonalmpen nok tingklak wampwomis pikekg kipm ampreing uk tu melnum watipmen paipm kamel kamel (5,000) pa, a umpu umpu pikekg kipm alupm nimong watipmen pik pik pa? ");
INSERT INTO urim_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kipm ariwe nok tingklak wampwomis wampwompwekg pikekg kupm kapor ampreing uk tu melnum kamel kamel (4,000) pa al aki? Ti nok tingklak umpu umpu pa pikekg kipm alupm nimong aripm? ");
INSERT INTO urim_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kipm ti ake ariwe yangkipm yiprokgen na a wet kupm la pa. Kupm ake wet la nok tingklak pa, kupm wet la kipm itn wonrpme eng mpim ap mringen a tu melnum a arpmen yangkipm yiprokgen a Moses a tu Satyusi a ak oren nok tingklak eng angki pa.” ");
INSERT INTO urim_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kolpa atom tu ariwe a kil la pa lala, ake kil la mpa tu itn wonrpme eng mpim ap mringen a tu ak oren nok mringen pa eng angki pa, kalpis. Kil la tu itn wonrpme ikglen tu alntu eng yangkipmok a tu melnum a arpmen yangkipm yiprokgen a Moses a kaling plan tu, a wa yangkpmok a tu Satyusi pa. ");
INSERT INTO urim_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sisas kil kai anong kanokg a Sisaria Pilipai. Ak wang pa kil asen tu watnom alkil a kil aroaro wonel alkilen pa la, “Kipm atning tu wrong kin a kipman la Warim Kipman a Melnum pa mla?” ");
INSERT INTO urim_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Atom tu la, “Tu pa la kitn melnum ur a pikekg amo atom wa wrekg. Tu tiur pa tu la, pa kitn Son a pikekg kaluk tu. A tu tiur pa wa la, pa kitn Elaisa. Wa tu tiur pa la, pa kitn melnum okwripm Seremaia, aki kitn melnum okwripm ur ai.” ");
INSERT INTO urim_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Atom Sisas kil la, “Ti kipm ti la kupm ti kupm mla?” ");
INSERT INTO urim_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Atom Saimon Pita pa akalmpe la, “Pa kitn Krais, kitn Warim Kipman a Maur Wailen a rpma yongkyong.” ");
INSERT INTO urim_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ari Sisas kil akalmpe la, “Saimon, alkeitn wor, kitn warim kipman a Sona. Eng ntei, nikgwalpm ariwe pa ake melnum ur a kanokg ti alkeitn pa, kalpis. Nikgwalpm ariwe pa mpam Yan akupmen kaino kitnong pa alkeitn pake. ");
INSERT INTO urim_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pita kitn pa kolen wulkging. Ikga kupm uwi uwi tu wrong kin a kipman iye kul eng kupm ti kolen kupm ale wan akupmen ti eli wulkging pa. Ti wrik om a tu melnum a ake ukipma amo kai arke arke pa ake antiwe titnongket a tikale wan pa. ");
INSERT INTO urim_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mpa kupm lkeitn titnongket a ikgalen ampei umpu a wanyun a kweikwei wrongkwail a Maur Wailen kil ikgalen pa. Kitn ngkuten itni kanokg ti pa, Maur Wailen wa ngkuten kaino kitnong ai. Kitn inelkgen itni kanokg ti pa, Maur Wailen wa inelkgen kaino kitnong ai.” ");
INSERT INTO urim_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kil lanaki Pita oklala pa plalng pa, kil lanaki tu watnom alkil pa la, “Ampur kipm laron naki tu wrong kin a kipman pa la kupm pa Krais pa, yaper.” ");
INSERT INTO urim_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Angko wang pa aye kai pa, Sisas kil la alupm alupm naki tu watnom alkil a kil aroaro wonel pa la, “Ikga kupm kai anong wail Serusalem pa ep atom ikga tu melnum wailen, a tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen, a tu melnum a aroaro wonel tu yangkipm a Moses, ikga tu ntokg kupm ti rki kalkuten wail, a wa oropm imo rmpi wang wraur plalng pa, kupm wa wrekg.” ");
INSERT INTO urim_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita kil atning kolpa, kil epilng Sisas pa aye kai itna laikge atom kil angkengkel la, “Ai Wailen, kupm karken kitn antokg kolpa. Kwei ur kol wet kitn la pa ampur palng eng kitn pa.” ");
INSERT INTO urim_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Sisas kil wa atning kolpa, kil plelng won la Pita pa lanakel la, “Maur Paipm Satan, kitn itni tukwelkg kupm ti! Kitn pa kol yopmiri ur a ak lawopm nepm eng la kupm ngko. Eng ntei, nikgwalpm pa ake a Maur Wailen pa, pa nikgwalpm a melnum.” ");
INSERT INTO urim_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Atom Sisas lanaki tu watnom alkil a kil aroaro wonel pa la, “Kol melnum ur la kul kunun kupm ti pa, kil mpa elngen a kanun nikgwalpm alkil pa, a kil mpa rki yo okgmangki alkilen pa, atom kil kul kununtopm. ");
INSERT INTO urim_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Melnum a kil la ikglen numpalk akil ti kolti pa, pa amen wor akilen pa ikga kai paipm. Pake melnum a kil uk num alkil ti kolti eng aken kwap kupm pa, pa amen wor akilen pa ikga rpmi wor yongkyong. ");
INSERT INTO urim_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kol melnum ur kil uwi kweikwei wrongkwail a itna kanokg ti, atom amen wor a kil pa ikga kai paipm. Ti mpa wa kweikwei wrongkwail a kanokg pa mpa wa ik ngklin amen wor a kil pa la kolai? Melnum pa mpa wa kil ik marpm kolai ik rmpen amen wor alkil pa iye kul wor kolai? ");
INSERT INTO urim_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kol Warim Kipman a Melnum ikga nar nimpon titnongket a nang wailen a Yan alkil a nimpon tu maur angklin alkilen. Atom ikga kil ikilmpe uk kweikwei kai melnum wris wris kitila kwap a kil ak pa. ");
INSERT INTO urim_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kupm lanakepm aklale wrisen, kipm tiur a itna ti pa kipm ikgake imo, kipm ikga rki kolpa rki, atom ikga ri Warim Kipman a Melnum ikga nar kolen melnum tukgunakg a ikgalen kweikwei wrongkwail. Kipm rki ri pa plalng pipa, kipm imo kaingkai.” ");
INSERT INTO urim_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wang wampwomis wampwompwris pa kai plalng pa, Sisas kil awi Pita, Semis, a wailen alkil Son pa tunteng kaino wrik nangen watin ur pa, atom tunteng alntunteng pa rka. ");
INSERT INTO urim_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tunteng rka pa, tunteng ari numpalk a Sisas pa palng manet. Ikgokg a kil pa palng klalen alenten kolen takgni. A apm a kil nowe pa palng tangkor pupu. ");
INSERT INTO urim_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tunteng ari kweikwei a palng kolpa kai eng Sisas pa plalng pa, wa tunteng ari Moses a Elaisa pa wa palng kolti anti Sisas pa oklala. ");
INSERT INTO urim_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita ti wa la yangkipmok ur manet alkil ai naki Sisas pa la, “Wailen, mentepm rka kolkil pa wor. Kitn wakrongen pa, mpa kupm ngkam pilmpal wraur ur ai. Wris ur eng kitn a ur eng Moses a ur eng Elaisa.” ");
INSERT INTO urim_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita kil oklala itna pa, waipmunu klalen ur pa nar akipaarngken. Atom tunteng atning ok ur a la kawor waipmunu wunen pa la, “Pa Warim Kipman a kupm, kupm plan ipma wor wakrongentel a kupm ipma wor atopentel, ti kipm itning yangkipm akilen pawo!” ");
INSERT INTO urim_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tunteng watnom alkil atning pa, teng ngkark paipm angko elng kai lam ikgokg kai kanokg pa. ");
INSERT INTO urim_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ari Sisas kai ak wam rkawen lanaken la, “Teng wrekg o, ampur kipmteng ngkark.” ");
INSERT INTO urim_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Atom tunteng plelng ngkat ikg kaino kwa pa ari, ake tunteng ari melnum ur kalpis, tunteng ari Sisas wris ata kolti. ");
INSERT INTO urim_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tunteng wrekg angkaino nang pa kai kinar pa, Sisas alken yangkipm pa la, “Ampur kipmteng lanaki tu kuina ur wet kipmteng ari pa. Pa mpa rpmi kai ipma a kipmteng ti kolti, kai ngko wang a Warim Kipman a Melnum pa imo pa wa wrekg pipa, kipmteng laniken kul.” ");
INSERT INTO urim_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wa tunteng watnom alkil pa asentel la, “Ti wa antokg kolai atom tu melnum a aroaro wonel tu yangkipm a Moses ti wa lala, Elaisa pa ikga nar ep, a Warim Kipman a Melnum pa kul nar kunukg?” ");
INSERT INTO urim_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Atom Sisas akalmpe la, “Pa aklale, Elaisa pa ikga nar ep noworel nimprampen kweikwei wrongkwail pa elng itni. ");
INSERT INTO urim_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pake kupm lanakepm aklale la, Elaisa am pikekg nar ase. Pake tu wrong kin a kipman pa ake ariwe la pa Elaisa pa. Atom tu antokgtel paipm ak wakrongen alntu, kolen ikga wa tu uk wleket Warim Kipman a Melnum pa.” ");
INSERT INTO urim_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Atom tunteng watnom alkil pa am ariwe ase la, wet kil la Elaisa, pake pa am kil la Son a pikekg kaluk tu. ");
INSERT INTO urim_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tunteng nar palng ari tu wrong kin a kipman pa rka. Atom melnum wris ur pa kul kapor kilko alein Sisas pa ");
INSERT INTO urim_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","a kil la, “Wailen, kitn rein warim kipman akupmen tipen. Kil titno, kil awi numpet rpma paipm wrisen. Almpla titnowel talpul angko angko wakg a u. ");
INSERT INTO urim_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Wet kupm ayewel kai eng tu watnom a kitn aroaro wonel pa ari, tu ake antiwe antokgtel palng wor.” ");
INSERT INTO urim_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Atom Sisas lanakel la, “O! Kipm wrong kin kipman ak wang ti, ake kipm ukipma, ipma a kipm ti am kai ar ase. Ikga kupm rpmi ntiwepm or ai kai rki kaikuten akipmen pa? Ti iye warim pa kul o!” ");
INSERT INTO urim_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tu aye warim kipman pa kul, atom Sisas kil akle ungkwan maur paipm a rpma warim pa kolti, warim pa palng wor. ");
INSERT INTO urim_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Atom tu watnom alkil pa awi Sisas pa aye kai itna laikge pa atom asentel la, “Antokg kolai atom men ti ake antiwe titnongket a ungkwan maur paipm takwleikg warim pa?” ");
INSERT INTO urim_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Atom Sisas pa akalmpenten kolpa la, “Kol kipm ukipma waiketn ur kol marer ok wasek pa, pa antiwe ak antokg kweikwei wail wail, pa antiwe kol a kipm la tipmining wail ti la, 'Kitn kai itni kai wompel ai', ti tipmining mpam kai itni wompel pa. Pa kweikwei wrongkwail kol a ake wonet eng kipm. Ati, ake kipm ukipma itna titnongket, kolpa atom ari ake kipm antiwe ungkwan maur paipm takwleikg warim pa. ");
INSERT INTO urim_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Maur paipm kolti pati ake antiwe mpa kipm ungkwan kolti pa. Kipm kalpis okipma eng uk wang Maur Wailen pa, pati antiwe mpa kipm ungkwan pake.” ");
INSERT INTO urim_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Ak wang ur a tu kai rka wris rka kai anong kanokg a Kalili pa, Sisas lanaken la, “Ikga tu elng Warim Kipman a Melnum ti kai wam a tu wrong kin kipman eng ilmporel imo, atom ikga wang wraur pa kai plalng pipa, wa kil wrekg.” Tu atning yangkipm a kil la kolpa pa tu ipma kalkuten paipm. ");
INSERT INTO urim_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Sisas nampon tu watnom alkil a kil aroaro wonel tu kul anong Kaperneam, atom tu melnum awi marpmel tu itna yalming a Maur Wailen pa kul asen Pita pa la, “Melnum alkipm a alkepm ariwe pa kil angkli angkli marpm ur kai yalming a Maur Wailen pa aki kalpis?” ");
INSERT INTO urim_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Atom Pita akalmpe la, “Ei, kil angkli angkli marpm pa.” Atom kil kai kawor wan pa ari Sisas am asentel ase la, “Saimon, kitn akwonalmpen kolai tu melnum tukgunakg a kanokg ti? Tu awi awi marpm kai tu melnum yiprokg yiprokg alntu nampon aki awi awi kai tu miskalpm ai kolti?” ");
INSERT INTO urim_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Atom Pita akalmpe la, “Am tu awi awi kai tu miskalpm pa akalkil pake.” Atom Sisas lanakel la, “Ti pa! Tu yiprokg yiprokg alntuwen pa ake tu awi awi marpmel tu pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kai kwap a yalming a Maur Wailen pa kol am kol pake, ari kolpa kalpis. Pake mentepm kalpis a angkli marpm pa, mpa tu ipma paipm eng mentepm. Kolpa ti kai kitn kai ngklitilo ampei kai ukupuk pa ik rkolngtilo yul pa. Yul a kitn rkolng ep pa, irontokel yul pa, mpa kitn ri marpm a rpma yul ok pa. Kitn nikletilo, yekul kai ngklitilo kai kuin amentekgen pa uk melnum a awi marpmel tu kai yalming pa.” ");
INSERT INTO urim_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Itna wang pa tu watnom a Sisas aroaro wonel pa kulntel atom asentel la, “Mla itna nang wailen itna kuin a tu a Maur Wailen itna wailen ikgalen ipma atuwen pa?” ");
INSERT INTO urim_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ari Sisas akwe warim yek ur pa kul kolti, kil wamparpme aye kaino itna kuin atuwen pa akla la, ");
INSERT INTO urim_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","”Kil kupm la aklale, ake kipm plelngen nikgwalpm akipmen pa palng kolen tu warim yekyek a kolkil pipa, Maur Wailen ake antiwe a itna wailen ikgalen ipma akipmen. ");
INSERT INTO urim_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Melnum a kil arku kil alkil palng kolen tu warim yekyek a kolkil pa, pa kil itna nang wailen itna kuin a tu a Maur Wailen itna wailen ikgalen ipma atuwen. ");
INSERT INTO urim_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Melnum a kil ikgalen tu melnum a arku tulntu palng kolen tu warim yekyek a kolkil pa, pa kil ikgalen kupm.” ");
INSERT INTO urim_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Kol melnum ur ningkail warim yekyek wris ur a kolkil a ukipma kupm ti kil ngko pa, pa wor kol a tu yipo wes wail ur rpmi mengkel, atom ngkit ngkliwel kinar unokg ai. ");
INSERT INTO urim_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Woi, arein kipm wrong kin a kipman! Kweikwei wailet a itna kanokg ti ak ningkailepm, atom kipm angko kai paipmpaipm. Ari kweikwei a ak ningkailepm pa am palng kolpa itna pake, ikgake kalpis pa. Pake woi, arein melnum a ningkail melnum ur iye kai ngko pa. ");
INSERT INTO urim_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kol wam aki nepm ur a kitn pa rkolngkeitn la kitn la kai ntokg paipmpaipm pa, pa kitn wangket atom ngkli kai ai tukwelkg. Pa wor eng a kitn pa ngkiten wam wompel wris aki nepm wompel wris pa iye itni kolti eng mpa kitn uwi yaprekg watin a Maur Wailen atom ikga kaino rpmi wor yongkyong. Kitn elng nepm wam pa itni yatenen, atom kai anong paipm a wakg atne yongkyong pa, pa paipm. ");
INSERT INTO urim_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Am kolpake, kol wulmpa wompel ur a kitn pa ak arkolngkeitn la kitn kai ntokg paipmpaipm pa, pa kitn inen ngkli tukwelkg. Kitn ngkiten wulmpa wompel pa uwi yaprekg watin a Maur Wailen pa kaino rpmi wor yongkyong pa pati wor pake. Kitn elng wulmpa pa itni yatenen, atom kai anong paipm a wakg atne pa, pa paipm. ");
INSERT INTO urim_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ti mpa wa kipm ikwonilmpen tu warim a kolpa. Mpa wa kipm lala tu pa warim paipm paipm ur kalpmel kolti, pa kalpis. Eng ntei, kupm lanakepm la, tu maur angklin a Maur Wailen ikgalen tu warim a kolpa pa, tu pa antiwe kai itna wulmpa a Yan akupmen kaino kitnong pake. ");
INSERT INTO urim_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Warim Kipman a Melnum wli la ik uwi tu melnum a kai oror ya paipm pa iye yaper kul.” ");
INSERT INTO urim_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ti kipm wa akwonalmpen kolai? Kol melnum ur a kil ikgalen manto walkg malkgu kamel wampwomis, atom wris ur pa kai am pa, pa ake mpa kil kai ikor wris ur a kai am pa? Pa mpa kil elngen manto walkg malkgu kamel wikgwikg tuwek wampwam yikakwomis yikakwompwikgwikg pa elngkitni nang i pa, a kil mpa wa kai wa ikor wris ur a am ai pen. ");
INSERT INTO urim_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kol kil nsil pa, kupm lanakepm aklale, kil mpa wa itopen paipm wrisen eng manto walkg malkgu wris pa wa angen manto walkg malkgu a itna ti. ");
INSERT INTO urim_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Am kolpake, kol Yan akipmen a rpma kaino kitnong ti ake wakrongen la mpa warim waseksek ur a kolpa kai paipm pa.” ");
INSERT INTO urim_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Sisas kil wa la kolpa la, “Kol wusok aki wailen ur alkitn, kol kil ntokg nikgwalpm paipm ur kai kitn ti pa, kitn kai riwel. Kipmekg alkipmekg wekg kolti rpmi la kuina ur a kil antokg paipm kai kitn pa. Kol kil itning yangkipm a kitn la pa, am kitn angklinsel awiyel aye yaper kul ase. ");
INSERT INTO urim_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pake kol kil ake atning pa, mpa kitn uwi kol melnum wris aki melnum wekg ur ai kai ntiweitn kai itni yirokgel kitn pa, eng ik titnongketel yangkipm pa. ");
INSERT INTO urim_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kol kil ake la itning yangkipm a kipmteng pa pipa, wa kitn laniki tu wrong kin a kipman a ukipma Maur Wailen. Pa la ake wa kil atning yangkipm a tu pa yat pipa, mpa kitn la melnum pa la, pa kil kol melnum ipmawekg aki melnum paipm ur a antokg paipmpaipm. ");
INSERT INTO urim_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ti kupm lanakepm aklale wrisen, kuina ur a kipm yapo itna kanokg a ti pa, pa wa Maur Wailen yipo kolpa kaino kitnong ai. Wa kuina ur a kipm alken itna kanokg a ti pa, pa kil alken kolpa yat itna kaino kitnong ai. ");
INSERT INTO urim_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kupm la wa lanikepm nti ur la, kol kipmekg melnum wekg ur itni kanokg ti ipma wris eng kuina ur a kipmekg asen pa, mpa Yan akupmen a rpma kaino kitnong mpa kil lkepm pa. ");
INSERT INTO urim_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ti kol melnum wekg ur aki wraur ur, tunteng kai rki wris ngkit nang akupmen pa, pa kupm antiwen rpma.” ");
INSERT INTO urim_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Atom Pita kil kul eng Sisas, atom kil asentel la, “Wailen, kol wusok aki wailen ur alkupm pa perper ntokg paipm kul kupm pa ikngklei wang pa, mpa kupm ungkwan paipmpaipm a kil pa nti aripm? Mpa kupm ungkwan kaino elngen wampwomis wampwompwekg aki?” ");
INSERT INTO urim_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ari Sisas kil akalmpentel la, “Kupm ake wa lanakeitn la mpa nti wampwomis wampwompwekg pa, kupm lanakeitn la mpa nti kamelwraur tuwek wampwam yikakwomis yikakwompwekg. ");
INSERT INTO urim_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ti kitn itning, kupm la yangkipm kla ur kil a ak la arein a Maur Wailen itna wailen ikgalen nol nikgwalpm a mentepm. Pa kolen melnum tukgunakg ur, kil akwen tu melnum akwapel alkilen pa la tu ikilmpentel kweikwei kuloken alkil a rpma kai tu pa. ");
INSERT INTO urim_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Atom tu aye ker a pikekg akawiye kweikwei kuloken akilen pa aye wli alkel, atom kil awi angkleikg rpma. Kil angkleikg kolpa kai, atom tu aye melnum wris ur pa aye wli. Ker alkilen pa palng watipmen paipm kamel kamel (10 milyen). ");
INSERT INTO urim_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Akentiwe mpa kil ikilmpe, ker pa watipmen paipm ai. Kolpa atom melnum tukgunakg pa lanaki tu la mpa tu uwi melnum pa nimpon kin a watnom alkil pa, a kweikwei wrongkwail alkilen pa, mpa tu iye kai uk tu melnum ur ai rmpen. Atom mpa tu uwi marpm pa ikilmpe kweikwei kuloken pa. ");
INSERT INTO urim_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Melnum pa kil atning kolpa, kil elngangko kinar rmpa nepmel melnum tukgunakg pa, a kil kirkar akg la, 'Kitn reinsopm pen, ikga kupm ikilmpenteitn kweikwei wrongkwail palpa.' ");
INSERT INTO urim_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Melnum tukgunakg alkil pa areinsel kolti a kil la, 'Wor pa, kai kitn kai o! Kuloken akupmen a rpma kai kitn pa am kupm ungkwan ase.' ");
INSERT INTO urim_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Melnum akwapel pa wrekg kai ari, kil ansil melnum a tuwekg akwap wris a pikekg awi marpm kuloken wasek ur kul kil ti. Atom kil kai arkulel a wamparpmewel meng kolpa, a lanakel la, 'Kitn ikilmpe kuina ur a pikekg kupm alkeitn tiwo!' ");
INSERT INTO urim_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ari melnum pa kil elngangko rmpa nepm kil ti, a kil lanakel la, 'Kitn reinsopm pen, ikga kupm ikilmpenteitn pa.' ");
INSERT INTO urim_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ari kil ti la, kil karken kolpa. Atom kil la tu awiyel kolti angkliwel kawor rpma wan tipmining pa eng ikga kil rpmi i i. Kil ikilmpentel kuloken pa kai plalng pa, kil kulor en om. ");
INSERT INTO urim_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Atom tu melnum akwap wris tiur alkil pa tu itna ari kuina ur a palng kolpa atom, tu ipma kalkut. Kolpa a tu kai lanaki melnum tukgunakg alntu pa kweikwei wrongkwail a wuten palng pa. ");
INSERT INTO urim_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Atom melnum tukgunakg pa akwe melnum akwapel a wuten awi melnum ur alkil pa kawor rpma wan tipmining pa kul aklewel la, 'Kitn ti antokg paipm. ");
INSERT INTO urim_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ake wa kitn ipma arein melnum akwap wris alkitn ti, kol a kupm arein kitn ti?' ");
INSERT INTO urim_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Melnum tukgunakg pa kil ipma wakget. Kolti kil ukwa melnum pa la kai rpmi wan tipmining pa rpmi i i, kil ikilmpe kuina ur kuloken a rpma num a kil pa plalng. ");
INSERT INTO urim_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Am kolpake, Yan akupmen a rpma kaino kitnong ti pa mpam wa kil ik kolpa kai kipm wris wris pake. Kol ake kipm ungkwan paipmpaipm ur kai wusok aki wailen alkipm pa, kipm ungkwan ik ipma wor iklale pa, Yan akupmen ikgake ungkwan paipmpaipm akipmen pa.” ");
INSERT INTO urim_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sisas kil lanaken yangkipm kweikwei wrongkwail pa kai plalng pipa, kil naurng anong kanokg a Kalili pa kil wangket u kop Sotan pa kai wompel ai. Atom kil nar kai wompel ai kai kinar wangket kul anong kanokg a Sutia. ");
INSERT INTO urim_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ari kalpis, tu wrong kin kipman wailet am kanuntel kolpa atn pake, atom kil ungkwan numpet atuwen pa itna wrik pa. ");
INSERT INTO urim_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ari wa tu melnum tiur a melnum a arpmen yangkipm yiprokgen a Moses pa tu kul alm ipmawel kil pa, asentel la, “Men la itningke kai kitn ti la yangkipm titnongket pa la kipman pa antiwe a ungkwan kin alkil pa ik wakrongen alkil aki, kalpis?” ");
INSERT INTO urim_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ari Sisas pa akalmpe la, “Ake wa kipm angkleikg yangkipm wrkapm a Maur Wailen pa, a la, pikekg ep lmpiwen ak a kil antokg kweikwei wrongkwail pa, kil antokg kin, kil antokg kipman. ");
INSERT INTO urim_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Atom am yiprokgen kolpa atom kil la, 'Warim kipman mpa nuurng mansan alkil, a kai rpmi numpon kin alkil, atom mpa tuwekg palng kol num wris.' ");
INSERT INTO urim_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kolpa atom ake wa tuwekg itna kol melnum wekg pa, kalpis, tuwekg am kai wris ase. Eng ntei, kwei ur a pikekg Maur Wailen yapo kai wris pa, pa ake antiwe mpa melnum ur wangketen itni manman pa, kalpis.” ");
INSERT INTO urim_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tu melnum a arpmen yangkipm yiprokgen a Moses tu asen Sisas pa la, “Ti antokg kolai atom pikekg Moses kil alko yangkipm la, kipman antiwe a nira wrkapm wompel a ak wangketen kin pa atom ungkwan kin pa kai pa?” ");
INSERT INTO urim_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ari Sisas kil akalmpenten la, “Moses pikekg kil anti la kipm ungkwan kin alkipmen atnen a kipm melkget. Pake pikekg ake ya ur kolpa ak ep ilmpiwen ai, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kin a kipman ur pa kai ikwap numkropis a uk numpaipm kamel pa, pa kil antiwe ungkwan kin pa. Kol kil ungkwan kin alkil a ake kai akwap num kropis ur pa, atom kil uwi kin ur manet ai iye pa, pa kil angkli arkul kin pa. Wa kipman a awi kin ur a kipman ep ungkwan pa, pa kil wa angkli arkul kin pa.” ");
INSERT INTO urim_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tu watnom a Sisas pa tu atning yangkipm a tu la kolpa atom tu lanakel la, “Kolpa pa, pa wor eng ake mpa uwi tita.” ");
INSERT INTO urim_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ari Sisas pa akalmpenten la, “Yangkipm a la kin a kipman ake mpa uwi tita pa, wrongkwail ake antiwe ariwe yangkipm pa eng mpa tu kunun. Tu tiur a Maur Wailen alken titnongket kolti pa tu awi ariwe yangkipm pa atom kanun. ");
INSERT INTO urim_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Pa yiprokgen watipmen eng tu kipman ake la uwi kin pa. Tu tiur pa pikekg awi ipma angko, atom nikgwalpm a tu a rka eng la ntokg kin pa, pa kalpis. A tu tiur pa tu angklo mamrowel, atom nikgwalpm a tu a rka eng la ntokg kin pa, pa kalpis. Tiur pa tu karken la tu ake la uwi kin pa, eng ntei, tu la uk tu alntu ti kai eng ikwap a Maur Wailen. Mlaur a awi ariwe yangkipm kil pa, pa kil kunun.” ");
INSERT INTO urim_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ak wang pa tu wrong kin kipman pa tu aye tu warim alntu pa aye kai eng Sisas la kil elng wam pa eliwen a oklala niki Maur Wailen eng ngklinsen. Ari tu watnom alkil pa aklewen. ");
INSERT INTO urim_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ari Sisas lanaken la, “Kipm elngen eng tu warim pa kulntopm o! Ampur angkengken. Anong wor a Maur Wailen itna wailen ikgalen pa am a tu melnum a kolen tu warim yekyek tike.” ");
INSERT INTO urim_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kil elng wam pa elawen oklala naki Maur Wailen angklinsen plalng, kil naurngten kil kai. ");
INSERT INTO urim_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Atom melnum ur pa kul eng Sisas atom asentel la, “Melnum a aroaro wonel tu, mpa kupm ntokg kweikwei wor ur kolai eng mpa kupm uwi yaprekg watin eng rpmi wor yongkyong?” ");
INSERT INTO urim_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ari Sisas akalmpe la, “Wa kitn asentopm eng kuina a i wor pa eng ntei? Kwei ur wris a wor pa pati Maur Wailen. Kol kitn la uwi yaprekg watin eng kitn pa rpmi wor yongkyong pa pati, mpa kitn kunun yangkipm titnongket a Maur Wailen pa riworwor.” ");
INSERT INTO urim_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ari melnum pa asentel la, “Yangkipm titnongket a i mpa wa kupm wa kunun pa?” Ari Sisas akalmpentel la, “Ti yangkipm titnongket mpa kitn kunun ti kil: ake mpa ilm melnum imo, a ake mpa ngkli rkul kin a kipman pa, ake mpa ik ikgwam, a ake mpa kinsil lakiti melnum ur pa, ");
INSERT INTO urim_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","a orngwatneikgen mansan, a plan ipma wor wakrongen mla ur yiprokg watinet alkitn kol a kitn plan ipma wor wakrongen kitn alkitn.” ");
INSERT INTO urim_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Melnum warimpen pa la, “Yangkipm titnongket a wet la pa kupm kanun pake, ti wa tiur a i eng kupm a wa kunun?” ");
INSERT INTO urim_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ari wa Sisas pa akalmpe la, “Kitn la palng melnum wor wrisen pa, kitn kai atom kitn uk kweikwei wrongkwail alkitnen ti kai tu rmpenteitn. Plalng pipa, kitn uwi marpm pa kai uk tu melnum a rpma tukwok pa. Pa ikga kitn rpmi ntiwe kolpa kaino anong wor ai. Atom plalng pa, kitn kul kununtopm!” ");
INSERT INTO urim_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Melnum warimpen pa kil atning yangkipm pa, kil kai nampon ipma kalkut, eng ntei, kil melnum a antiwe kweikwei wailet. ");
INSERT INTO urim_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Atom Sisas lanaki tu watnom alkil pa la, “Ti pa, kupm lanakepm aklale. Melnum a antiwe kweikwei watipmen pa, pa wonet eng kil elng Maur Wailen kawor itna wailen ikgalen nol nikgwalpm akilen pa. ");
INSERT INTO urim_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ti kupm wa la lanikepm la, kol ling pa la or tawong a ikyom a ak angkut apm pa kawor pa, ake aken kwap kol melnum a antiwe kweikwei watipmen la elng Maur Wailen kawor itni wailen ikglen nol nikgwalpm akilen, pa aken kwap paipm.” ");
INSERT INTO urim_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ti tu watnom alkil pa, tu atning yangkipm a kil la pa atom tu wrekg paipm eng yangkipm pa. Atom tu asen tita la, “Woi, ti mla a i antiwe mpa Maur Wailen ik uwiyel iye kul wor pa!” ");
INSERT INTO urim_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ari Sisas ariwen kolpa atom kil lanaken la, “Melnum pa ake antiwe, pake Maur Wailen pa antiwe a antokg kweikwei wrongkwail.” ");
INSERT INTO urim_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Atom Pita akalmpentel la, “Ti kitn ri, men naurng kweikwei wrongkwail alpmenen ase, a men am kul kanun kitn tike. Ti ikga men uwi kuina?” ");
INSERT INTO urim_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ari Sisas wa akalmpe la, “Kupm lanakepm aklale. Ikga ik wang a kil ntokg kitnong a kanokg weten pa, ik wang pa Warim Kipman a Melnum ikga kil rpmi wrik wor a awi titnongket a nang wailen. Ti kipm watnom wampwam yikak wekg a kupm pa, pa kipm pa yat ikga kipm rpmi wrik wampwam yikak wekg wor a awi nang wailen eng ikga ikglen tu om wampwam yikak wekg a Isrel. ");
INSERT INTO urim_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kolpa ti melnum a kil naurng wan anong alkil aki kil naurng muinwror, muikgmayen, mansan, warim, a wring alkil pa eng kil akwap akupmen pa, ikga kil uwi melnum a kweikwei pa watipmen paipm ai angen a kil naurng itna pa, wa kil uwi yaprekg watin atom ikga kil rpmi wor yongkyong. ");
INSERT INTO urim_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pake watipmen a tu a itna ep pa, tu pa ikga kai itni kunukg, a watipmen a tu itna kanukg pa, tu pa ikga kai itni ep.” ");
INSERT INTO urim_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Maur Wailen itna wailen ikgalen ipma a melnum pa pati kol melnum a antiwe wring ampei wain ok wail. Atom kil wrekg ak kong miningket paipm ai, eng kil kai akor tu melnum la tu kai iktel kwap kai wring alkil eng mpa kil rmpenten. ");
INSERT INTO urim_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kil yapon yangkipm la mpa kil rmpenten marpm a wang wris pa, atom kil ukwawen tu kai ikwap kai wring alkil pa. ");
INSERT INTO urim_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Wa takgni no rpma kai kitnongkwang ti pipa, wa kil wa yaper kai. Ari wa kil ari tu melnum tiur a tu rpma kalpmel angkai wrik mapming ur a tu kai arke arke pa. ");
INSERT INTO urim_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Atom kil lanaken la, 'Kipm ti yat, kipm kai iktopm kwap kai wring akupm. Eng mpa kupm rmpentepm kitila kwap a kipm ak pa.' ");
INSERT INTO urim_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kolpa atom tu kai akwap. Takgni kaino wreren eng a pirng pa, kil wa yaper kai la ikor tu tiur pen. Wa ak takgni plelng pa am wa kil wa ak kolpake. ");
INSERT INTO urim_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Wa kwikwai ok angko pa wa kil kai ari, tu tiur am wa itna ase. Atom kil wa asenten la, 'Wa kipm rpma kalpmlel wang wris ti antokg kuina?' ");
INSERT INTO urim_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ari tu pa akalmpentel la, 'Ake wa tu melnum ur armpento la men iktel kwap ur, kalpis.' Atom kil lanaken la, 'Ti kipm kul kai ikwap kai wring akupm ai.' ");
INSERT INTO urim_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Atom nungkurikg ti pipa, melnum yan a wring pa lanaki melnum wantengkwang alkil pa la, 'Kitn ukwe tu melnum wet akwap akupm pa kul lken marpm. Mpa kitn uk tu melnum a kupm awiyen kanukg pa ep, plalng pa, wa uk kolpa kai elngen kai tu melnum a wuten kupm awi ep ai.' ");
INSERT INTO urim_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tu wet ketn ti akwap ak nungkurikg ti pa, tu kai itna awi marpm a wang wris pa aknirake tu pa kimeket. ");
INSERT INTO urim_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pipa tu melnum a kil awiyen ep ak kong pa wa kul wa itna eng la wa uwi marpm pa. A tu akwonalmpen la tu pa mpa wa uwi marpm wa wail angen tu pa. Ari kalpis, tu kimeket am tu awi repmrepm kol marpm a wang wris kolpa kimeket pake. ");
INSERT INTO urim_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tu ari marpm a tu awi kolpa, atom tu la watipmen kai melnum yan a wring pa. ");
INSERT INTO urim_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Tu la, 'Tu melnum a kitn awiyen kanukg kil pati, tu wuten akwap waiketn kolti ak takgni nungkurikg ti. Ari wa kitn wa armpenten marpm pa wa repmrepm kul kol marpm a wa kitn armpen men ti tuwa. Men ti wuten akwap ak kong ai, takgni alo kul wli nungkurikg tike.' ");
INSERT INTO urim_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ari melnum yan a wring pa akalmpe kai melnum wris ur pa la, 'Kupm antokg na paipm eng kitn ti? Kitn alkitn wuten awi wor la kitn ikwap wang wris eng uwi marpm kol a wang wris pake. ");
INSERT INTO urim_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kolpa ti kitn uwi marpm pa atom kitn iye kai o! Pa nikgwalpm akupm, atom ari kupm uk marpm pa kai tu melnum a kupm awi ayewli kanukg pa repmrepm kol a kupm uk kitn pake. ");
INSERT INTO urim_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Pa marpm alkupmen, kupm la ntokg kolai kweikwei alkupmen pa, pa nikgwalpm alkupmen. Ake mpa mlaur la. Ake wor eng kitn ipma paipm eng kupm akwap wor kolpa.' ");
INSERT INTO urim_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kolpa ti mla ur a kil itna kanukg pa kil ikga kai itni ep, a mlaur a kil itna ep pa kil ikga kulkai itni kunukg.” ");
INSERT INTO urim_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tu angkom kai eng a kaino Serusalem pa, Sisas kil awi tu watnom wampwam yikak wekg alkil pa ayewen kai itna wrik laikge ur pa, atom kil lanaken kolpa itna wampel la, ");
INSERT INTO urim_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","”Kipm itning, mentepm mpa kai eng ikga kaino anong wail Serusalem. Kaino anong pa ikga tu uk Warim Kipman a Melnum kai wam a tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen, a tu melnum a aroaro wonel tu yangkipm a Moses. Ikga tu uwiyel iye kai itni yangkipm eng la ikga ilmpel imo. ");
INSERT INTO urim_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ikga tu uk kil kai wam a tu melnum a ake Suta eng ikga tu la iknokgelel, a ik ampei iket pa ikntrawel a kurkurngkel rki yo okgmangki, kil imo. Wang wraur pa kai plalng pipa, ikga wa kil wa wrekg i kirkap pa.” ");
INSERT INTO urim_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Atom man nampon warim kipman wekg a tuwekg Sepeti pa tunteng kai ari Sisas. Atom man pa kapor kilko aleinsel, atom kil la lanikel yangkipmok. ");
INSERT INTO urim_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ari kil asentel la, “Kitn la la kuina?” Ari kin pa la, “Kupm la kitn yipon yangkipm eng warim kipman wekg alkupmen kil, eng ikga uwi nang wailen nimpon kitn, ikga ur rpmi wam wi, a ur rpmi wam wangkokg akitn, ik wang a kitn itni wailen ikglen kweikwei wrongkwail.” ");
INSERT INTO urim_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ari Sisas kil akalmpe la, “Kipmteng ake ariwe kuina ur a kipmteng la pa. Kipmekg antiwe a ikga il u kai kaimung a ikga kupm il tike?” Tuwekg akalmpe la, “Mentekg antiwe pa.” ");
INSERT INTO urim_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ari Sisas lanaken la, “Pa aklale, kipmekg ikga il u kai kaimung akupmen pake. Kupm ti ake melnum ikga tukwei melnum eng la rpmi kai wam wi a kupm aki wam wangkokg a kupm pa, kalpis. Wrik pa pati a tu melnum a Yan akupmen numprampen eng tu pake.” ");
INSERT INTO urim_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tu watnom wampwam alkil pa tu atning yangkipm pa ari tu ipma wakget nampon tuwekg wusokwail pa. ");
INSERT INTO urim_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Atom Sisas kil akwewen kul itna wris atom kil lanaken la, “Kipm ariwe pa. Tu melnum tukgunakg pa tu itna kalnten ikgalen tu wrong kin a kipman pa tirpmingen ak wakrongen alntu. Wa tu melnum wail wail pa tu ikgalen tu wrongkwail ak titnongket kalnten alntuwen. ");
INSERT INTO urim_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nikgwalpm akipmen pa ake mpa rki kolpa. Kol mlaur kil la palng melnum wailen itna kuin akipmen pa, pa kil orngwatneikgen ngklin mlaur ai. ");
INSERT INTO urim_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Wa kol mlaur kil wakrongen la kil a itni ep pa pati, mpa kil palng kolen melnum ur a aken kwap kalpmel orngwatneikgen kipm pa. ");
INSERT INTO urim_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kol Warim Kipman a Melnum ti pa am kolpake, pikekg ake kil nar la kipm pa ngklin kil ti pa. Kil nar la ngklin kipm pa, wa uk num alkil ti kai eng la ikirmpen kipm wrongkwail.” ");
INSERT INTO urim_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sisas nampon tu watnom a kil aroaro wonel pa naurng anong Seriko pa kai ari tu wrong kin kipman wailet paipm a pa anel kai kanuntel. ");
INSERT INTO urim_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ari melnum wulmpa paipmen wekg ur pa ekg rpma ya yamping pa rpma. Tuwekg atning a tu lanaken la Sisas ampake, atom ekg akwe yikakatnen la, “Wailen, kitn watnom walpopm a Tepit, kitn reinso pen!” ");
INSERT INTO urim_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tu wrong kin kipman wailet apa anel atning a tuwekg akwe kolpa, a anel kilkampen a lanaken la tuwekg tatar rpmi. Ari wa tuwekg wa akwe yikakatnen paipm ai la, “Wailen, yipetatnong a yoampei Tepit, kitn reinso pen!” ");
INSERT INTO urim_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Atom Sisas kil kai itna a kil akwewen, atom kil asenten la, “Kipmekg wakrongen kupm ti la kupm ntokgtepm kuina?” ");
INSERT INTO urim_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ari tuwekg pa akalmpe la, “Mentekg wakrongen la kitn ntokg wulmpa amentekgen ti palng wor.” ");
INSERT INTO urim_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Sisas kil ipma areinsen, atom kil elng wam pa kai itna wulmpa a tuwekg pa. Atom penterngen kolti wulmpa a tuwekg pa palng ari kweikwei pa. Atom tuwekg wrekg kolti kai kanuntel. ");
INSERT INTO urim_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sisas nampon tu watnom alkilen pa, anel kaino angko Petpake, anong wasek ur a ela krongkwang a nang Olip pa, kaino wreren Serusalem ase. ");
INSERT INTO urim_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Pipa Sisas lanaki watnom wekg ur alkil pa la, “Kipmekg ep kaino anong ingkaino ai, pa mpa kipmekg ri penterngen kolti nimpa nungkulkg watin ur a tu latok ampeiyel elng itna anong pa nampon war alkil pa. Kipmekg inelkgen atom kipmekg iyentopm nar o! ");
INSERT INTO urim_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kol melnum ur isen rapontepm pa, laniken la, 'Wailen kil wakrongen la uwi eng ik ik kwap ur alkil ai atom wa ukwanteitn yaper no pinterng.' Kolpa mpa kil ukwor eng kipmekg iye nar pa.” ");
INSERT INTO urim_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kweikwei kolpa palng kai kanun yangkipm a pikekg melnum okwripm a Maur Wailen kil la pa, atom yangkipm pa palng aklale. Pikekg kil la kolkil la, ");
INSERT INTO urim_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","”Kipm laniki tu wrong kin a kipman a Saion pa la, 'Kipm ri, melnum tukgunakg wailen akipmen arpme nimpa nungkulkg watin wlintepm pa. Kil wli eng antokg nikgwalpm wor. Kil arpme nimpa nungkulkg watin warimpen ti wli pa.'” Yangkipm a pikekg melnum okwripm la pa, am angko okarke tike. ");
INSERT INTO urim_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Atom tuwekg watnom alkilen pa kaino ak katila kolen a wet Sisas lanaken pa. ");
INSERT INTO urim_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tuwekg kai awi nimpa nungkulkg watin mantwarim pa aye kul, atom aner apm a tu nowe eng wropuk ti kai ukulam ela nimpa yilo pa atom Sisas kil kaino arpme ur pa. ");
INSERT INTO urim_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Atom wrong kin a kipman wailet pa anel awi apm alntu ti ukulam or ya ti kai kaino, a wa tiur pa wa angket yo ipm pa ukulam tatu ya pa. ");
INSERT INTO urim_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tiur kai ep a tiur kai kanukg, a Sisas pa rpma kuin. Atom tu atop arkol la kolkil la, “O, men atopen kitn watnom walpopm a yoampei amentepmen Tepit. Maur Wailen ukwor kitn atom kil ukwaweitn nar. Men ngkat nang a Maur Wailen aye kaino kwa aklale wrisen.” ");
INSERT INTO urim_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ak wang a Sisas kil kaino kawor anong wail Serusalem pa, wrongkwail kin a kipman a rka anong wail pa anel ari Sisas pa, atom anel akentatu wli asen tita kai pa kai pa la, “Pa melnum mla pa?” ");
INSERT INTO urim_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ari tu wrongkwail kin a kipman a wet antiwel kawor pa akalmpe la, “Melnum kil pa Sisas, melnum okwripm a Nasaret kai anong kanokg a Kalili.” ");
INSERT INTO urim_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sisas Krais kawor Serusalem kol melnum tukgnakg plalng pa, wa kil kawor yalming a Maur Wailen pa ari, kil ari tu wrong kin a kipman tu ak kweikwei awi marpm, a armpen kweikwei pa. Atom kil ungkwanten takwleikg wan pa. Kil taipurng tipmakg a tu ak marpm one tita atne pa, a wa ungkwa wrik a tu ak wel punum awi marpm arpme pa. ");
INSERT INTO urim_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kil la kolpa, “Ela wrkapm a Maur Wailen pa la kolkil la, 'Wan akupmen pa namput la pa wan a oklala naki naki kupm ti.' Wrkapm a Maur Wailen pa la kol pake, pake wa kipm ak kwap kolpa atne, atom wa palng kolen la pa tipmining tawong ur a tu melnum a akikgwam arke.” ");
INSERT INTO urim_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Sisas kil ungkwan tu pa takwelkg yalming pa plalng pa, kil rpma pa. Tu melnum a wulmpa paipmen a nepm paipmen pa wli kai kaworntel wan pa, atom kil antokgten palng wor. ");
INSERT INTO urim_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pake wa tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen, a tu melnum a aroaro wonel tu yangkipm a Moses pa, anel ari kwap a Sisas kil akwap ak titnongket a Maur Wailen. A wa tu ari tu warim pa anel la yikakatnen rka yalming pa kolkil la, “Mentepm atopen watnom walpopm a yoampei amentepmen Tepit.” Kolpa atom antokg ipma a tu pa paipm eng Sisas pa. ");
INSERT INTO urim_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tu asentel la, “Ti kitn atning a tu warim ngkat nang akitnen kolpa wor aki paipm?” Sisas akalmpenten la, “Ei, kupm atning pa. Ake kipm angkleikg wrkapm a Maur Wailen pa a la kolkil la, 'Warim waiketnketn a warim a rka ma pa pikekg kitn arowen won ti tu ngkat nang akitnen pake.'” ");
INSERT INTO urim_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Atom Sisas nampon tu watnom alkil pa naurng tu pa itna pa, a tu angkawor anong wail pa kulor kai okg mining wris pa kinar anong Petani. ");
INSERT INTO urim_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sisas nampon tu watnom alkil pa tu wrekg ak kong miningket pa angkom or ya pa la kaino anong wail pa, ari nikgalmpel. ");
INSERT INTO urim_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Atom kil ari yo kampuk mringen ur pa itna ya yamping pa. Atom kil angkom kai yo yiprokg ai, ikgen kaino talpuk ai, la kol a ok ur rki pa, kol a kil inel il eng nikg ti, ari kalpis. Kil ari ipm kalpmel kolti, atom kil akle yo pa la, “Kitn ikgake ngko oken, ikga kalpis kolti.” Atom yo kampuk pa nungkwor plulng pinterngen kolti. ");
INSERT INTO urim_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tu watnom alkil pa tu ari pa atom tu wrekg paipm, atom tu asentel la, “Antokg kolai atom yo kampuk pa wa plulng pinterngen kolpa?” ");
INSERT INTO urim_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ari Sisas kil akalmpe lanaken kolkil la, “Kupm lanakepm aklale wrisen, kol kipm ukipma itni titnongket a nikgwalpm a kipm pa ake rka wekg wekg pa, kipm antiwe antokg kolen yo kampuk wet a kupm antokg pa, wa antokg kweikwei tiur ai yat. Kipm antiwe la wrik nangen a mentepm atnewe ti la, 'Kai o, kai kitn kai kinar am kinar unokg ai!' Pa kol am palng kolpake. ");
INSERT INTO urim_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kol kipm ukipma yek kimeket atom kipm isen Maur Wailen eng kuina ur pa, mpa kipm uwi kuina ur a kipm asentel pa.” ");
INSERT INTO urim_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sisas wa yaper kaino wa kawor yalming a Maur Wailen pa atom kil kaling plan tu wrong kin a kipman pa itna pa. Tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen pa, nampon tu melnum wail wail pa wli palng ariwel asentel la, “Kitn ti, kitn melnum wailen atom kitn ak kwap kolpa? Wa yat wa mla alkeitn titnongket pa?” ");
INSERT INTO urim_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ari wa Sisas akalmpenten la, “Ti itni eng kupm ikisentepm akasen wris ur kil la kipm ikilmpe pa, pati mpa kupm lanikepm yiprokgen a titnongket a kupm ak ak kwap pa. Akasen akupmen kolkil la: ");
INSERT INTO urim_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","kwap a Son pikekg kaluk tu pa la, pa kwap a melnum aki pa kwap a Maur Wailen?” Tu akor la itna kuin a tu alntu pa kolkil la, “Mpa mentepm ikilmpe kolai? Kol mentepm la, pa kwap a Maur Wailen, kolpa pa mpa wa kil wa iklewo la, 'Ti karken a kipm ukipma yangkipm a Son la pa?' Kolpa ti ake mpa mentepm la kolpa. ");
INSERT INTO urim_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kol mentepm la kolkil la, pa kwap a melnum a kanokg ti, pa mpa mentepm wa ngkirken ok a tu wrong kin kipman pa atnen tu ariwe la Son pa kil melnum okwripm a Maur Wailen. Kolpa ti ake mpa wa mentepm la kolpa.” Tu akwonalmpen kai lawe kolti mpa tu la kolai. ");
INSERT INTO urim_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Atom tu kaporkla akalmpe kai Sisas pa la, “Ake men ariwe kwap a Son pa la, pa kwap a melnum aki, pa kwap a Maur Wailen.” Ari wa Sisas lanaken kolpa la, “Kupm yat, kupm ake mpa wa nikepm la kupm awi titnongket kai a i atom kupm ak ak kwap kil.” ");
INSERT INTO urim_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Kipm akwonalmpen kolai? Melnum yan ur pa warim kipman wekg. Atom yan pa ep kai lanaki warim kipman ep pa la, 'Warim, am ti mpa kitn kai ikwap kai wring ampei wain.' ");
INSERT INTO urim_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ari wa warim pa akalmpe la, 'Kupm karken.' Ari wa kanukg ti kil akwonalmpen la kil a kai, kolpa atom kil kai. ");
INSERT INTO urim_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Atom wa yan pa wa wrekg kai lanaki warim kipman ur pa kolen a wet kil la kai warim kipman ep pa. Warim kipman pa akalmpe la, 'Yayai, kupm mpa kai pa.' Ari kalpis ake wa kil kai. ");
INSERT INTO urim_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ti kipm akwonalmpen kolai warim kipman wekg pa, la mla ai atning nungkulkg kanun ok a yan alkil la pa?” Wa tu akalmpe la, “Am warim kipman ep pake.” Ari Sisas wa la kai tu pa la, “Kil kupm lanakepm aklale wrisen la, tu melnum awi marpmel tu, a tu kin a atn ya pa, tu pa ikga ep eng kipm ti kai kawor anong a Maur Wailen kil ikgalen pa. ");
INSERT INTO urim_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kol Son pa kil pikekg wli kalukepm a plantepm ya ute wor, ari ake wa kipm ukipma kanun yangkipm a kil la pa. Pake tu melnum awi marpmel tu, a tu kin a atn ya pa, tu pa ukipma kanun pake. Atom kipm ari tu pa, pake ake wa kipm plelng ipma, ukipma kanun ok a Son la pa.” ");
INSERT INTO urim_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Sisas la yangkipm pa kai plalng pipa wa kil wa la, “Wa kipm wa itning yangkipm kla ur kil. Melnum kanokg yiprokg ur pa kil antokg wring ampei wain alkil pa plalng pa, kil ak yipmingki pa kapringen. Plalng pa, wa kil ak ilkim wail ur pa numprampen elng itna, eng ikga tipon u ampei ok pa kai elng nare. A wa kil wa ale wan kwa ur pa elng itna. Kil antokg kweikwei pa plalng, kil awi melnum tiur ai wli ikgalen akentel wring pa kolpa itna, a kil wrekg kai anong ya watinet ur ai. ");
INSERT INTO urim_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ampei ok pa tukgun kakir pa, melnum yan a wring pa kil ukwa melnum akwapel alkil pa kai ari tu melnum a ikgalen wring alkil pa la uwi wain ok alkilen a aknamputel pa iye kai. ");
INSERT INTO urim_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pake tu melnum a ikgalen wring pa tu kai arkulen oren tiur, wa tiur pa tu oren amo. Wa tiur pa tu or ak wes. ");
INSERT INTO urim_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Wa melnum yan a wring pa wa kil ukwa melnum akwapel alkil pa wa wailet ketn ketn, angen a pikekg kil ukwa ep pa wa kai. Ari tu melnum a ikgalen wring pa wa ak kolen a pikekg tu ak ep kai tu tiur a kil ukwawen ep pa. ");
INSERT INTO urim_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kil akor ya ari kalpis, atom am kil almpil ukwa warim kipman alkil ti kai tuwa. Eng ntei, kil akwonalmpen la, 'Mpa kupm ukwa warim kipman yiprokgen alkupm a wring kil kai pa, kolpa ti ikgake tu ntokgtel paipm, ikga tu ntokgtel riwor pa.' ");
INSERT INTO urim_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ari kalpis, tu ariwel a kil kai palng atom tu lanaki tita la, 'Pa warim kipman a melnum yan a wring ikga uwi num ngklin wring tike. Ti kipm kul eng tepm orel imo tukuleikgen, eng mpa mentepm iye kweikwei akilen ti eng almentepmen.' ");
INSERT INTO urim_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Atom tu arkul warim kipman alkil pa arkol wampel angkli elng kulor takwleikg wring pa atom orel amo.” ");
INSERT INTO urim_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Sisas la yangkipm kla pa kai plalng pa kil asen tu a itna pa la, “Kolpa ti ik wang a melnum yan a wring ampei wain pa yaper kai wring alkil pa, pati ikga kil ntokg kolai eng tu melnum a ikgalen wring akilen pa?” ");
INSERT INTO urim_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tu akalmpe kolpa la, “Ikga kil or tu melnum paipm a ikgalen wring akilen pa imo plalng. Atom wa elng wring alkil pa elng kai wam a tu melnum manet tiur ai eng ikglentel. Atom ik wang a okipma alkilen pa tukgun kakir pa, ikga tu ngketuwai okipma alkilen pa wako, atom wompel alkilen pa ikgam iyentel kai pake.” ");
INSERT INTO urim_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Atom Sisas lanaken la, “Ei, ikgam antokg kolpake. Ari ake kipm angkleikg yangkipm yiprokgen pa eng mpa kipm uwi riwe. Yangkipm pa la ela wrkapm a Maur Wailen a la kolkil la, 'Ong a tu melnum a ale wan pa tu ari la la paipm pa, tu ungkwan pa, am ong kimpowen wor wrisen a akale wan am pake. Maur Wailen kil alkil antokg pa, atom mentepm ari la pa wor wrisen atom mentepm atopen.' ");
INSERT INTO urim_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kolpa ti kupm lanakepm la, wring a Maur Wailen pa ikga kil uwi kai wam a kipm pa, atom wa uk kai wam a tu a ikgalen wring ariworwor eng angko ok arke pa. ");
INSERT INTO urim_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Melnum a kil angko ela ong kil pa, mpa kil ngket numpwam alkil pa paipm. Pake melnum a ong kil angko kinar karkurel pa, mpa ningnapis waiketnketn kolti.” ");
INSERT INTO urim_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen, a tu melnum a arpmen yangkipm yiprokgen a Moses tu atning yangkipm kla a Sisas kil la pa, tu ariwe la yangkipm kla pa am kil la eng akla tu alntu tike, la tu paipm. ");
INSERT INTO urim_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kolpa atom tu la kol a rkulel eng iye kai, ari tu ngkark eng wrongkwail kin a kipman wailet a itna ti, tu ariwe la pa kil melnum okwripm a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Sisas kil wa la yangkipm kla ur kil kolkil la, ");
INSERT INTO urim_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Maur Wailen kil itna wailen ikgalen ipma a melnum pa, pati kolen melnum tukgunakg ur a itna ep ikgalen anong kanokg wail ur pa, kil la ntokg okipma wail ur il itnen warim kipman alkil la uwi kin iye. ");
INSERT INTO urim_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kil ukwa tu melnum akwapel alkil pa kai lanaki tu melnum a pikekg kil akwenten ep, la mpa tu wli eng okipma wail a kil antokg pa, ari tu karken. ");
INSERT INTO urim_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Atom wa kil wa ukwa tu melnum akwapel tiur alkil pa wa kai anti ur lanaki tu melnum a pikekg kil akwenten pa la, 'Kipm kul eng tepm kai o! Okipma am kil numprampen ase. Kil alm manto nongko nepm watin a wa nampon manto nepm watin warimpen wor tiur pa alm ntampen numprampen elngtitna ase. Ti kipm kul eng tepm kai ntokg okipma pa il itopen, itnen warim kipman akilen la uwi kin iye ai.' ");
INSERT INTO urim_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tu melnum akwapel alkil pa kai lanaken pa ari, ake tu atning. Am anel kai rak atn palpa ase. Tiur pa kai akwap kai wring, wa tiur pa kai akwap marpm alntuwen. ");
INSERT INTO urim_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Wa tiur a rka pa tu arkulen antokgten paipm, atom oren amo. ");
INSERT INTO urim_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Melnum tukgunakg pa ari kolpa, kil ipma wakget paipm. Atom kil ukwa tu melnum a almpwrong alkilen pa kai alm tu melnum a wet almpor tu melnum akwapel alkil pa, a ak lap wan anong atuwen pa kai plalng. ");
INSERT INTO urim_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Atom kil lanaki tu melnum akwapel alkil pa la, 'Okipma am kupm numprampen plalng elng itna ase. Pake tu melnum a pikekg kupm akwenten ti pa tu antokg paipm, eng tu talpulng ok a kupm akwenten la wli ntiwopm il okipma ti. ");
INSERT INTO urim_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kolpa ti kipm kai tutu ya wail wail, ya wenting wenting pa. Kipm ri tu mlaur pa, kipm laniken la tu kul il okipma akupmen ti.' ");
INSERT INTO urim_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tu melnum akwapel alkil pa atning kolpa atom tu kai tatu ya wail wail, a ya wenting wenting pa. Tu ari tu mlaur a wor aki paipm pa tu lanaken kolti. Atom tu kimeket arpme tita kolpa kai wan ok okkapmet wail a al al okipma atnewe pa, kaingkai wan pa pik antiwe wrong a wli pa kolti. ");
INSERT INTO urim_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tu kai rka wan okipma pa plalng pa, melnum tukgunakg pa kil kai kawor ari wrong a wli rka wan pa. Atom kil ari melnum wris ur pa ake kil nowe apm wor ur eng aye kai ak ari kin kipman a awi tita pa. ");
INSERT INTO urim_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Atom melnum wailen pa lanaki melnum ake nowe apm wor pa la, 'Melnum alkupm, ake kitn nowe apm wor a kin kipman awi tita wai aye wli rpma ti?' Melnum pa atning, yangkipm kalpisen tarng rpma kolti. ");
INSERT INTO urim_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Atom melnum tukgunakg kil lanaki tu melnum akwapel alkil pa la, 'Kipm yipo nepm wampel melnum pa, atom ngkit ngkliwel elng kawor miningket pa. Pa wrik paipm a tu kirkar akg nampok paipm wrisen rkawe.'” ");
INSERT INTO urim_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sisas la yangkipm kla pa plalng pa wa kil wa la, “Kol Maur Wailen pa kil akwen wrong wailet, pake kil awi wrong wusoken a kil takwei pa kolti.” ");
INSERT INTO urim_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Atom tu melnum a arpmen yangkipm yiprokgen a Moses pa tu kai rka yapon yangkipm eng la mpa ilm ipmawel Sisas pa, eng la kil la oklala ur kai paipm pa, mpa tu iyewel kai ntokg yangkipm. ");
INSERT INTO urim_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Atom tu ukwa tu melnum tiur alntuwen pa nampon tu melnum tiur a Erot pa kai eng Sisas. Atom tu armpwonel aknukwar la, “Melnum a kaling plan tu, men ariwe la kitn pa melnum a la yangkipm a aklale wrisen kolti. Kitn ake ngkark eng nikgwalpm oklala a mlaur pa, kalpis. Kitn laron naken ya a Maur Wailen pa ute wor aklale kolti naki tu wrongkwail a wor a paipm. ");
INSERT INTO urim_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kitn laniko nikgwalpm ur a kitn akwonalmpen pa ri? La kol mentepm uk marpm Kaisarus, melnum tukgunakg a tu Rom a awi marpmel mentepm pa la, pa wor aki?” ");
INSERT INTO urim_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ari Sisas pa kil ariwe nikgwalpm paipm atuwen pa ase. Atom kil lawen la, “Kipm pa melnum a kansil plan ak num enen ti kolti. Wa kipm wa aknukuar akor kupm ti eng ntei? ");
INSERT INTO urim_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ti kipm plantopm marpm a kipm angkli angkli uk melnum tukgunakg a tu Rom ti ri!” Atom tu aye marpm ok ur pa aye kai alkel. ");
INSERT INTO urim_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Atom kil asenten la, “Ti nang ikgokg a mla ela marpm kil?” ");
INSERT INTO urim_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tu akalmpe la, “Nang ikgokg pa a Kaisarus, melnum tukgunakg a Rom pake.” Atom kil lanaken la, “Kolpa ti kipm uk kweikwei a melnum tukgunakg a Rom pa kipm uk kai kil alkil. A kipm uk kweikwei a Maur Wailen pa kai eng Maur Wailen kil alkil.” ");
INSERT INTO urim_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tu atning kolpa, tu wrekg paipm kolti. Tu wrekg naurngkel kolti am kaingkai ase. ");
INSERT INTO urim_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ak wang wris pa tu Satyusi tu wa kul eng Sisas. Am tu pa pati tu melnum a lala tu melnum a amo kaingkai pa, ikgake wa wrekg wrekg, kalpis. Tu alntu pa ariwe ase, atom tu ak yangkipm kolkil la alm ipmawel Sisas pa la kolpa la, ");
INSERT INTO urim_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","”Melnum a kaling plan tu, yangkipm a Moses pikekg kil kaling planto pa la kolpa la, 'Kol kipman aye kin, atom warim kalpisen, atom kil imo pa, mpa wa wusok alkil pa uwi kin karpikg pa iye eng ngket warim eng ngklin wailen alkil a pikekg amo pa.' ");
INSERT INTO urim_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kol wusok wail wampwomis wampwompwekg pikekg rpma a pa. Wailen pa aye kin, atom warim kalpisen, atom amo naurng kin pa rpma pa eng tu wusok wusok alkil pa. ");
INSERT INTO urim_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Wailen pa amo pa warim kalpisen kolti. Pa wa wusok pa awi wampuk wa warim kalpisen, wa kil amo. Tunteng wusokwail klungen wampwomis wampwompwekg pa am teng karpo tita aye kin karpikg pa kai, warim kalpisen kolti amo kimeket. ");
INSERT INTO urim_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kanukg pa kin pa amo eng plalng pake. ");
INSERT INTO urim_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Atom kol wang a tu wusokwail wusokwail a pikekg amo kaingkai pa wa wrekg wrekg i kirkap a u mlaminel pa kulor pa, kin a pikekg tu pa kimeket aye pa, kin pa ikga kil kin a mla?” ");
INSERT INTO urim_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ari Sisas akalmpe la, “Nikgwalpm akipmen ti kai ar atnen a ake kipm ariwe yangkipm wrkapm a Maur Wailen ti, a titnongket akilen pa. ");
INSERT INTO urim_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ikga ik wang a tu kin a kipman a pikekg amo kaingkai pa wa wrekg wrekg pa, tu ikgake iye tita pa, kalpis. Tu ikga rki i kolti kolen tu maur angklin a Maur Wailen a rka kaino anong wor pa. ");
INSERT INTO urim_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Akasen a kipm asen kai melnum a amo kaingkai pa la tu ikga wrekg wrekg aki kalpis, ti ake kipm angkleikg oklala a Maur Wailen lanakepm ela kai wrkapm alkilen pa. Pa la kolkil la, ");
INSERT INTO urim_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","'Kupm ti kupm Maur Wailen a Apraam, kupm Maur Wailen a Aisak, kupm Maur Wailen a Sekop.' Yangkipm pa planto la, melnum amo kai kalpis kolpa pa, pa mpa Maur Wailen kil ikglenten kolai, kalpis. Melnum a amo pa tu ake kai kalpis pa. Tu kai rka, atom Maur Wailen kil ikgalen tu pake.” ");
INSERT INTO urim_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tu wrongkwail kin a kipman atning yangkipm a kil laron naken kolpa atom tu wrekg paipm. ");
INSERT INTO urim_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sisas kil la yangkipm pa elng kai eng tu Satyusi pa, tu arkol ok tatar rka. Wa tu melnum a arpmen yangkipm yiprokgen a Moses pa atning pa, tu kai rka wris akorla yapon yangkipm. ");
INSERT INTO urim_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tu yapon yangkipm plalng pa, melnum wris ur atuwen a itna yirokgel angklin melnum a antokg yangkipm pa wrekg itna akasen Sisas pa almpel ipma la, ");
INSERT INTO urim_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Melnum a aroaro wonel tu, yangkipm titnongket a i itna ep?” ");
INSERT INTO urim_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ari Sisas akalmpe lanakel la, “'Kitn mpa plan ipma wor wakrongen Wailen kil Maur Wailen akitnen pa nimpon nol nikgwalpm, amen wor, a lngkep akitnen pa kai kimeket.' ");
INSERT INTO urim_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Pa yangkipm titnongket wail manten a itna ep ampake. ");
INSERT INTO urim_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wa yangkipm titnongket wail manten ur a wa itna kai arkekg pa pati itna kolkil, 'Kitn mpa plan ipma wor wakrongen mlaur kolen kitn plan ipma wor wakrongen kitn alkitn pa.' ");
INSERT INTO urim_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yangkipm titnongket wekg pa pati yangkipm yiprokgen a yangkipm titnongket wrongkwail a Moses a tu melnum okwripm a Maur Wailen laron pa, pa am kai alm itna yangkipm manten wekg pake.” ");
INSERT INTO urim_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tu melnum a arpmen yangkipm yiprokgen a Moses pa tu rka aken tita rka pa atom Sisas asenten la, ");
INSERT INTO urim_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","”Kipm akwonalmpen kolai Krais a Maur Wailen ukwa kul nar pa, pa la pa kil palng wli mla?” Ari tu lanakel la, “Kil walpopm ur a angket ale a Tepit ti kul tike.” ");
INSERT INTO urim_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Sisas kil wa la kolkil lanaken la, “Tepit kil pikekg ep ai la kolkil, 'Maur Wailen kil la kai Krais Wailen pa la kolkil la, “Rpmi kai wam wi akupmen pa rpmi i, kupm or tu wrongmanto akitnen pa yikak rkganti mengkel itni orngwatneikgen kitn pa.”' Antokg kolai atom Maur Wor a Maur Wailen pa uk nikgwalpm Tepit pa, atom wa kil wa akwe kil pa la Krais Wailen pa? ");
INSERT INTO urim_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ti kol Tepit pa kil ukwewel la Krais Wailen pa, pati wa antokg kolai atom Krais Wailen pa kil walpopm a Tepit pa?” ");
INSERT INTO urim_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Akentiwe mpa ur ikilmpe ok akilen pa, kalpis. Atom ak wang pa aye or pa kai pa, tu ngkark om. Atom ake wa tu akasen oklala ur wa kai eng kil pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Atom Sisas lanaki tu wrong kin a kipman wailet pa, a wa lanaki tu watnom alkil pa la kolkil la, ");
INSERT INTO urim_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Tu melnum a aroaro wonel tu yangkipm a Moses nampikgen tu melnum a arpmen yangkipm yiprokgen a Moses pa, tu pa awi wrik a Moses kaling plantepm yangkipm titnongket pa kolen pikekg Moses kil kaling plan pa. ");
INSERT INTO urim_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kolpa ti kipm itning kunun ntokg kitila kweikwei wrongkwail a tu lanakepm pawo. Pake ampake ntokg kitila kuina ur a tu antokg pa. Pati atnen ake tu antokg katila yangkipm a tu angkli pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yangkipm titnongket a tu yapon pa kolen kalkuten wail ur a tu alkepm la kipm rki. Pake tu alntu ti pa ake wa wakrongen la ipo wam ngklinsepm ngkit kalkut pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kweikwei wrongkwail a tu antokg pa, tu antokg la tu melnum ti ri kolti. Mikgni yawet a rpma wuntu, a yalmis a rpma elngkep pa tu ak wail ariworwor manet, atom yangkipm titnongket a Maur Wailen a tu nira pa tu la itna aye atn. A wa tu pa al pimpra watin ari wor wor rka tatu apm wulompwulom a tu nowe pa. Eng mpa tu melnum riwen nirein la tu melnum wor a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tu la ntokg okipma wail il pa, tu pa wakrongen la rpmi ep eng uwi okipma. Tu la kaingkai wan a atning atning yangkipm a Maur Wailen atnewe pa, tu pa mpa rki ep. ");
INSERT INTO urim_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kol melnum ur nsilen pa, tu wakrongen la, tu lken wor, il wuntuwel, a ukwewen la, tu melnum wailen a kaling plan tu. ");
INSERT INTO urim_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pa tu melnum a arpmen yangkipm yiprokgen a Moses pake, kipm pa ake mpa kol tu pa. Ake mpa wa tu wa ukwewepm la kipm melnum wailen a kaling plan tu melnum pa. Eng ntei, melnum a kaling plan kipm pa wris ata. Kipm pa repmrepm kolen kipm wusok wail ase. ");
INSERT INTO urim_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kolpa ti ampake wa kipm ukwe melnum ur a itna kanokg a ti la yan pa, iyai. Kol kipm Yan wris ata pa rpma kaino anong wor ai. ");
INSERT INTO urim_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ake mpa wa tu wa ukwe kipm pa la kipm melnum wailen pa, kalpis. Melnum wris a wailen pa pati Krais. ");
INSERT INTO urim_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Melnum wailen a itna ep itna kuin akipmen pa, mpa wa kil palng melnum a akwap angklin kipm. ");
INSERT INTO urim_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Melnum a kil ngkat nang alkilen aye kaino kwa pa, nang akilen pa ikga kinar kanokg. A melnum a kil arku nang alkilen aye kinar kanokg pa, ikga kil uwi nang wailen.” ");
INSERT INTO urim_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Woi, areinsepm, kipm melnum a aroaro wonel tu yangkipm a Moses, a kipm melnum a arpmen yangkipm yiprokgen a Moses ti pa, kipm ikga uwi paipm. Kipm plan ak num enen ti pa la kipm wor pake wunen ai pa paipm. Atom kipm pa ampri ya a tu melnum la kol a ore kawor anong wor a Maur Wailen. Kipm alkipm ti karken a kawor anong wor pa, wa kipm ampri ya wa tu la ore pa. ");
INSERT INTO urim_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Woi, areinsepm, kipm melnum a aroaro wonel tu yangkipm a Moses, a kipm melnum a arpmen yangkipm yiprokgen a Moses ti pa, kipm ikga uwi paipm. Kipm plan ak num enen ti pa la kipm wor pake wunen ai pa paipm. Kipm uk yangkipm armponel tu kin karpikg pa la uwi wan a kweikwei atuwen pa, a wa akwen Maur Wailen itna watin eng akaur paipm a kipm antokg pa. Kolpa ti kipm ikga uwi paipm wrisen eng ikilmpe paipm a kipm antokg pa. ");
INSERT INTO urim_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Woi, areinsepm, kipm melnum a aroaro wonel tu yangkipm a Moses, a kipm melnum a arpmen yangkipm yiprokgen a Moses ti, kipm ikga uwi paipm. Kipm plan ak num enen ti pa la kipm wor pake wunen ai pa paipm. Kipm angket unokg kai atn tatu anong manet watipmen akor tu melnum la kul kunun ya wa kipm ti ore ti. Kipm awi tu melnum pa kul kaling planten atom tu kul kanuntepm pa, tu palng paipm wrisen angen kipm ti, atom ikga tu kai anong paipm. ");
INSERT INTO urim_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Woi, areinsepm, kipm melnum wulmpa tilmpisen a plan ya tu melnum pa, kipm ikga uwi paipm. Kipm la kolkil la, 'Tu melnum a naren yalming a Maur Wailen pa eng ak titnongketel yangkipm ur pa, pa mpa wa ntei, kai tu lalowe o! Pake kol mlaur kil naren kweikwei a ak wes muinmainet antokg a rpma yalming a Maur Wailen pa, pa ake antiwe mpa lalowe, kalpis, pa titnongket itna.' ");
INSERT INTO urim_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kipm titnowen a kipm wulmpa tilmpisen! Kuina a i wail manten itna ep, wes muinmainet pa aki pa yalming ti antokg wes muinmainet pa klalen wakget? ");
INSERT INTO urim_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kipm wa la kolkil la, 'Melnum a kil naren tipmakg a alm itna eng alwor uk Maur Wailen atnewe pa, pa wa ntei, kai kil lalowe o! Pake kol melnum a kil naren okipma a aye kawor rmpa tipmakg pa eng alwor uk kai Maur Wailen pa, pa ake antiwe mpa lalowe pa, kalpis, pa titnongket itna.' ");
INSERT INTO urim_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kipm ti wulmpa tilmpisen, ake kipm ariwe la kuina ai wail manten itna ep pa, okipma pa wailen aki, a tipmakg pa a antokg okipma pa klalen wakget? ");
INSERT INTO urim_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kol melnum a kil naren tipmakg pa pati, am kil naren kweikwei wrongkwail a tu elng itna kaino tipmakg pa nampon pake. ");
INSERT INTO urim_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Wa kol melnum a kil naren yalming a Maur Wailen pa pati, pa kil naren Maur Wailen a rpma kawor yalming pa nampon pake. ");
INSERT INTO urim_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wa melnum a kil naren kitnong pa, pa kil naren wrik a Maur Wailen arpme pake, kolpa ti pa kil naren melnum kil alkil a rpma wrik pa nampon pake. ");
INSERT INTO urim_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Woi, areinsepm, kipm melnum a aroaro wonel tu yangkipm a Moses, a kipm melnum a arpmen yangkipm yiprokgen a Moses ti pa, kipm ikga uwi paipm. Kipm melnum plan ak num enen ti pa la kipm wor pake wunen ai pa paipm. Wanukgnung waiketnketn kai wringkya alkipm pa kipm awi elng itna mpil wampwam pa atom kipm uk mpil wris pa kai Maur Wailen. Kweikwei waiketnketn pa kipm kanun pake, ake wa kipm kanun yangkipm titnongket a lala ri lok melnum eng ntokg nikgwalpm ute wor, a ya a arein a ya a ukipma. Kweikwei waiketnketn pa kipm kanun pake, kol a kipm kunun kweikwei wail wail pa ep pake. ");
INSERT INTO urim_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kipm melnum wulmpa tilmpisen ti la plan ya tu melnum tike. Kipm alung u wilmpet, pake manto meng watin (kemel) pa kipm wonmis angklei nampon u pa kolti. ");
INSERT INTO urim_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Woi, areinsepm, kipm melnum a aroaro wonel tu yangkipm a Moses pa, wa kipm melnum a arpmen yangkipm yiprokgen a Moses ti pa, kipm ikga uwi paipm. Kipm plan ak num enen ti pa la kipm wor pake wunen ai pa paipm. Kipm klak kuntuk kaimung ti or en tike, a kawor kuntuk wunen pa kalpis. Kweikwei kol ikgwam a nikgwalpm wakrongen alkipm pa ake kipm klak, kalpis, kipm alupm rpma pa. ");
INSERT INTO urim_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kitn melnum a arpmen yangkipm yiprokgen a Moses, pa kitn wulmpa tilmpisen. Ep pa kol a kitn klak or wunen pa ep, atom kawor en pa mpa rukis pa. ");
INSERT INTO urim_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Woi, areinsepm, kipm melnum a aroaro wonel tu yangkipm a Moses, a kipm melnum a arpmen yangkipm yiprokgen a Moses ti pa, kipm ikga uwi paipm. Kipm plan ak num enen ti pa la kipm wor pake wunen ai pa paipm. Kipm pa kolen kirkap a tu aser miwel, ma kiminim wak kweikwei pa ak nakure ariworwor tatu en tike, kinar wunen pa pik atnen melnum tupmungkul a u mainilng paipm paipm a kimpilpet pa arke. ");
INSERT INTO urim_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kipm alkipm ti am kolpake. Tu melnum ariwepm num enen ti pa tu lala kipm melnum ute wor. Pake kawor wunen akipmen pa pik eng nikgwalpm paipm a paipmpaipm a kipm antokg.” ");
INSERT INTO urim_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Woi, areinsepm, kipm melnum a aroaro wonel tu yangkipm a Moses, a kipm melnum a arpmen yangkipm yiprokgen a Moses pa, kipm ikga uwi paipm. Kipm plan num enen ti pa la kipm wor pake wunen ai pa paipm. Kipm a alen wanel kirkap a tu melnum okwripm a Maur Wailen. A kipm nakure kirkap a tu melnum ute wor a pikekg amo epep ai. ");
INSERT INTO urim_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Atom kipm la kolkil la, 'Kol a pikekg men rpmi ik wang a tu mamikg mamin mansan amenen pa, men kolake ntimprak ilm tu melnum okwripm pa imo pa, kalpis.' ");
INSERT INTO urim_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yangkipm a kipm la kolpa pa, pa kipm laron kipm alkipm la kipm walwalpopm walyaru a tu melnum a pikekg alm tu melnum okwripm a Maur Wailen pa amo pake. ");
INSERT INTO urim_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kolpa ti kai kipm kai ntokg nikgwalpm kol a pikekg tu wapyipmiri a walyipmiri akipmen antokg pa kolpa kai lan o! ");
INSERT INTO urim_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kipm pa paipm kolen ul angketepm. Ikga wa kipm ngkom nlokgen anong paipm pa la kolai, kalpis. Kipm ikgam kai ore pake. ");
INSERT INTO urim_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kupm lanakepm kolkil la, kupm ukwa tu melnum okwripm, a tu melnum a antiwe ariwe watin a tu melnum a aroaro wonel kipm yangkipm a Moses pa tu kaintepm. Pake ikga kipm ilm tiur imo, a kurkurng tiur rki yo okgmangki a wa or tiur itni wan a atning atning yangkipm a Maur Wailen atnewe, a wa ungkwanten kai anong yela tatu palpa. ");
INSERT INTO urim_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kolpa ti ikga kipm uwi paipm nimpon tu a pikekg alm tu melnum ute wor a pikekg rka kanokg ti amo kaingkai pa. Melnum wor wor pikekg tu alm pa, tu alm angko Apel pa aye or pa kulngkul kul plalng angko Sekaraia, warim a Perekia. Sekaraia pa pikekg tu almpel kawor itna kawor yipmingki wunen itna kuin a wan klalen, a tipmakg a alm eng alwor uk Maur Wailen. Pati am pikekg tu a kipm ti antokg paipm tike. ");
INSERT INTO urim_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kil kupm lanakepm aklale wrisen. Akalmpe a paipm a pikekg tu pa antokg paipmel tu melnum wor pa, ikgam kipm wrong kin a kipman a rka ti uwi tike.” ");
INSERT INTO urim_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Woi, arein kipm anong Serusalem, kipm akangklei almpalm tu melnum okwripm a Maur Wailen pa amo, a wa kipm akwesel tu melnum akwapel a Maur Wailen a kil ukwa kulngkul eng kipm ti. Wang watipmen ai kupm la uwi kipm wrong kin kipman a anong Serusalem pa iye kul itni wris, eng ikglen kolen karek man a ak iplepm ipaarng karek nampi pa, ari kipm karken. ");
INSERT INTO urim_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kolpa ti kipm itning, anong akipmen pa ikga Maur Wailen nuurng itni kupuk kalpmel kolti. ");
INSERT INTO urim_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kol kupm lanakepm kolkil la, kipm ikgake wa riwopm nti ur, kolpa kai ngko wang a ikga kipm laron kupm ti la, 'Maur Wailen ukwa melnum pa, atom kil nar, ti mentepm lkel wor ngkit nang akilen.'” ");
INSERT INTO urim_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Sisas kil naurng yalming a Maur Wailen pa kil kai, atom tu watnom alkilen pa tu kul kai eng kil pa la, kil itni pen, eng tu plantel wan anong a yalming wail manten ariwor a Maur Wailen pa pen. ");
INSERT INTO urim_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Atom kil lanaken la, “Kipm ri kweikwei a itna ti, kupm lanakepm aklale wrisen. Wan wrongkwail a tu ale ak wes a ela tatu ti pa, ikgake kwei ur itni, ikga tu tikale ngkli plalng.” ");
INSERT INTO urim_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Sisas kil naurng yalming a Maur Wailen pa, kil kaino rpma nang Olip pa. Tu watnom alkil pa tu kanuntel kaino ariwel kaino wrik kalpmlel pa. Atom tu asentel la, “Kitn laniko riworwor ri la, wang a i ikga tu tikale yalming a Maur Wailen pa? Wa kla kuina ikga palng eng iklawen wang umpuwen a ikga kitn nar pa? Wa kla kuina palng iklawen wang wulompen a kanokg ti kai plalng pa?” ");
INSERT INTO urim_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ari Sisas akalmpenten la, “Kipm rpmi wonirpme eng ikgake melnum ur kinsilepm. ");
INSERT INTO urim_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tu wailet ikga wli numput nang akupmen pa la, 'Kil kupm Krais', a ikga ik rkolng tu wrongkwail kin a kipman wailet iye kai ar. ");
INSERT INTO urim_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Wa kipm ikga itning milpming a tu almpwrong wli wreren, a kipm ikga itning yangkipm wripm a tu alm tita. Pake kipm itning, ake mpa kipm ngkirk eng pa, kweikwei kolpa pa ikgam palng pake, pake pa ake wang wulompen pa, palpa apa. ");
INSERT INTO urim_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tu anong kanokg ur ikga wrekg rapon numpon tu anong kanokg ur. Wa wrong a mring tukgunakg ompur ikga wa wrekg rapon numpon wrong a mring tukgunakg ompur pa. Wa wang nikg ikga palng, a yelm ikga no anong kanokg tiur. ");
INSERT INTO urim_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kweikwei wrongkwail kil pa, pa kol kin a awi wleket ep eng raku warim. ");
INSERT INTO urim_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ikga ik wang pa pa, ikga tu uwiyepm iye kai lkepm kalkuten a wleket, a ikga ilmpepm imo. A tu wrong kin kipman ikga ipma paipm wrisen eng kipm, eng ntei, kipm a kupm. ");
INSERT INTO urim_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wa wrong kin a kipman watipmen a ukipma pa ikga wa ngko yaper kai ik wang pa. Wa ikga tu uk tita tu alntu ti kai wam a wrongmanto, a tu alntu ikga wa plelng wrongmanto eng tita. ");
INSERT INTO urim_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wa tu melnum okwripm kansil watipmen ikga palng, atom ik rkolng tu wrong kin a kipman watipmen. ");
INSERT INTO urim_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nikgwalpm paipm pa ikga palng wail paipm, kolpa atom wa tu wrong kin kipman watipmen ikga wa nuurng nikgwalpm a plan ipma wor wakrongen tita pa. ");
INSERT INTO urim_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pake mlaur a kil itna titnongket kai ngko wang wulompen pa, pa ikga Maur Wailen kil uwiyel. ");
INSERT INTO urim_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tu ikga iye yangkipm wor a la Maur Wailen kil la itni wailen ikglen mentepm wrongkwail pa kai yela kanokg ti, laniki tu anong kanokg mapming wrongkwail pa itning plalngen, plalng pipa, wang wulompen pa palng.” ");
INSERT INTO urim_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Sisas kil la watipmen la, “Kipm ikga ri kweiur paipm wrisen itni kawor wrik a Maur Wailen amprin eng kil alkil pa, kol a pikekg Taniel, melnum okwripm, la pa.” Ti melnum a kil angkleikg yangkipm wrkapm kil a Sisas la pa, kil ikwonilmpen pa riworwor! ");
INSERT INTO urim_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Kipm ri kweikwei paipm wrisen pa palng pa, kipm a rka anong kanokg a Sutia pa, kipm ikga ngkirk tukulelkg kaino nang ai. ");
INSERT INTO urim_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kol melnum ur ikga rpmi kawor wan male pa, ampake kil wa kai kawor wan wunen pa eng uwi kweikwei tiur alkil pa, mpa kil kai or yawel kolti kai. ");
INSERT INTO urim_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wa kol melnum ur ikga ikwap itni wring alkil pa, kil ake antiwe ikga yaper kai uwi apm alkil kai anong pa, kalpis, kil i pa kai pake. ");
INSERT INTO urim_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ti arein eng tu mantin a itna, a tu kin a warim rka ma ikga ik wang pa. ");
INSERT INTO urim_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kolpa ti kipm laniki Maur Wailen, eng ikgake kalkuten pa palng ik wang a uwei wropuk aki ik wang a wang wail a rpma eng yapm pa, atom kipm ngkirk pa. ");
INSERT INTO urim_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ikga ik wang pa, pa ikga kalkuten wail manten paipm. Pikekg ak wang ep a Maur Wailen antokg kanokg ti weten, wa kul elngen ak wang ti pa, kalkuten ur kolpa pikekg ake wa palng ep. Ti kalkuten ur a kolpa pa ikgake wa palng ntiur ik wang kunukg pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kol ake Maur Wailen angket wang a kalkuten pa kul tukwok pa, pa tu wrong kin kipman pa kol a kai paipm plalng. Ari kil akwonalmpen tu wrong kin kipman alkil a kil takwei ase. Kolpa atom kil ikga ngket wang pa kul tukwok. ");
INSERT INTO urim_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ti ikga ik wang pa kol melnum ur lanikepm la, 'Kipm ri, Krais itna ti', aki 'Krais ingkai itna kai ai.' Pa ampur kipm atning pa. ");
INSERT INTO urim_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tu melnum tiur kolpa ikga wli kinsilepm la, 'Kil kupm Krais', a 'Kil kupm melnum okwripm a Maur Wailen.' Wa ikga tu elng kla tiur itna ik plan titnongket alntuwen, wa ntokg kweikwei manet manet ur ai a ikga melnum wrekg paipm eng ri pa, eng ik rkolng tu wrong kin kipman, wa nimpon tu a Maur Wailen takweiyen eng alkilen eng la tu ngko. ");
INSERT INTO urim_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kweikwei ikga palng pa, am wuten kupm lanakepm ep ase. ");
INSERT INTO urim_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kol tu la lanikepm la, 'Kipm kai ri, Krais ingkai itna kai mpang a pa.' Pa ampur kipm kai pa. Aki kol tu la lanikepm la, 'Ti kipm kawor ri, Krais itna kawor wan a pa.' Pa ampur kipm atning pa, yaper. ");
INSERT INTO urim_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Warim Kipman a Melnum ikga nar pa, ikga tu wrong kin a kipman ri pa kolen milmal a plaing i takgni yiprokgen pa len kulkai plalng kai takgni yipuken ai. ");
INSERT INTO urim_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","A wa kolen kipm ari kirmpa taung ur a o o akam ela pa pati kipm ariwe la pa kil ari wlikgok ur alkil a la mpa il pa am rpma ase.” ");
INSERT INTO urim_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","”Ti ikga kalkuten wail pa plalng pa, ikga penterngen kolti takgni ti kai miningket. Wa kainil pa ikgake wa len, wa kumeim ikga nurku ingkaino kitnong ti nar. Wa kweikwei titnongket wrongkwail a itna kaino kitnong ti pa ikga palng titu plalng. ");
INSERT INTO urim_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Atom ikga ik wang pa, pa kla a Warim Kipman a Melnum ikga palng eli kaino kitnong pa. Atom tu wrongkwail om ompen a yela kanokg ti, ikga tu ri Warim Kipman a Melnum ikga itni waipmunu kwa pa ik iyewel ingkaino kitnong pa nar, nimpon titnongket wail a nang wailen pa, atom tu ikga rka nol akg paipm. ");
INSERT INTO urim_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Atom ikga tu itning nol pa tiplam yikakitnen pa, pa kil ukwa tu maur angklin alkil pa kai yela tungtangkem pa, eng uwi tu wrong kin kipman alkil pikekg kil takwei eng alkilen pa yela kanokg ti. ");
INSERT INTO urim_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Kolpa ti mpa kipm uwi riwe kai yangkipm kla a la yo kampuk pa: ipm wulkga pa nowen itni wamtalpuk pa, pa kipm ariwe la, pa wreren eng u eng a wei pake. ");
INSERT INTO urim_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ti am kolpake, ti ikga kipm ri kweikwei wrongkwail kol a wuten kupm la pa palng pa, pa kipm riwe la wang a Warim Kipman a Melnum la nar pa, am kul wreren itna yamping a tike. ");
INSERT INTO urim_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ti kupm lanakepm aklale, kipm wrong kin kipman a rka ti, tiur akipmen pa ikga imo, a tiur akipmen pa ikga rki, kolpa kai nsil kweikwei wrongkwail a ikga palng pa. ");
INSERT INTO urim_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ti kitnong a kanokg pa ikga kai plalng, pake yangkipm akupmen kil pa ikgake kai plalng. Ikgam itna kolpa kai pake.” ");
INSERT INTO urim_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","”Melnum ur ake ariwe wang a ikga kweikwei pa palng pa. Tu maur angklin alkil ti, wa nampon Warim Kipman alkil pa, tu ake wa ariwe wang pa yat. Pa Yan alkil wris pa kil ariwe wang pake. ");
INSERT INTO urim_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ikga ik wang wreren Warim Kipman a Melnum ikga nar pa, atn a rpma a tu wrong kin kipman pa ikgam repmrepm kol pikekg palng ak wang a Nowa pake. ");
INSERT INTO urim_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ti am kolpake, wreren eng u wail la ilen pa, tu wrong kin kipman pikekg tu al okipma, al u, awi tita, kolpa itna pa, Nowa kil kai kawor wan unokgen pa. ");
INSERT INTO urim_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tu ake ariwe kuina ur a ikga palng pa, tu rka wonmis kolpa rka pa, u wail pa wrekg alen. Ti am kolpake, ikgam wa palng kolpa ik wang a Warim Kipman a Melnum ikga kil nar pake. ");
INSERT INTO urim_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kipman wekg ikga ekg ikwap itni wring, atom ikga kil uwi ur, a ur pa ikgam kil nuurng itni pa. ");
INSERT INTO urim_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kin wekg pa ikgam wa kolpake, ikga tuwekg ntokg okipma pa rpmi, atom ikga kil uwi ur, a ur pa ikga kil nuurng rpmi pa. ");
INSERT INTO urim_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kolpa ti kipm rpmi wonirpme, eng ntei kipm ake ariwe wang a i ikga Wailen alkipmen nar pa. ");
INSERT INTO urim_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ti wa kipm riwe kil, kol melnum yan a wan pa kil riwe la melnum ikgwampet pa mpa palng ik wang kolai a mining pa, ti kil mpa rpmen wan alkil pa rpmi i, eng ake mpa melnum pa tikale wan alkil pa. ");
INSERT INTO urim_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kolpa ti kipm ti yat, kipm mpa rpmi numprampen, eng ntei Warim Kipman a Melnum ikga nar ik wang ur a kipm ake ariwe la kil ikga nar pa.” ");
INSERT INTO urim_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Melnum akwapel wor a atning nungkulkg nikgwalpm arke pa melnum akwap kolkil: melnum wailen wris ur, kil la kai itn ya ur alkil, atom kil elng melnum wor wris ur kolpa itna ep ikgalen tu melnum akwapel alkilen. Melnum pa ikgalenten eng kwap, a ampreingten okipma akangklei wang wris wris. ");
INSERT INTO urim_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Melnum wailen pa kil yaper kul ari kwap a pikekg kil alkel pa, ari kil akwap wor kolpa itna, kil pa wor pake, kil itopen o! Melnum a kil akwap wor kolpa pa kil itopen o! ");
INSERT INTO urim_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Pa kupm lanakepm aklale wrisen, melnum wailen pa ikga elng melnum akwapel alkil pa itni melnum wailen eng ikglen kweikwei wrongkwail alkilen pa. ");
INSERT INTO urim_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pake kol melnum a kil akwap paipm pa, kil mpa ikwonilmpen kolpa la, 'Melnum wailen alkupmen pa kil ikgake wli iktatu.' ");
INSERT INTO urim_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kolpa atom kil kai anti tu a al al u titno pa rpma al okipma, a al u titno atom titno titno, a kil or tu melnum alkil a tu akwap wris pa kolpa wonmis rpma. ");
INSERT INTO urim_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Melnum akwapel alkil pa kil ake ariwe wang a ikga kil yaper wli pa. Kil rpma tutus kolti ari kil am palng tike. ");
INSERT INTO urim_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Atom ikga melnum wailen alkil pa orel paipm wrisen, a ungkwantel kil kai rpmi nimpon tu melnum a kansil plan ak num enen ti kolti. Wa kai wrik pa, pa ikga tu akg paipm wrisen nam ok alntu pa paipm kolti.” ");
INSERT INTO urim_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Atom Sisas kil la, “Ikga ik wang a Warim Kipman a Melnum pa la nar pa, pa tu melnum a Maur Wailen ikgalen nol nikgwalpm atuwen pa, tu pa ikga kol tu kin wampwam a aye wakg amprepm alntuwen pa aye kai, la rpmi nungkwangen kipman ur pa la mpa wli uwi kin iye, atom tu ikyewel iyekul wan, eng tuwekg uwi tita. ");
INSERT INTO urim_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ari kin wampwomis pa titnowen nikgwalpm kalpisen, wa tunteng kin wampwomis ur pa nikgwalpm arke wontrakole. ");
INSERT INTO urim_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Atom tunteng kin wampwomis a titnowen nikgwalpm kalpisen pa, tunteng la amprepm mpil wris wris kolti aye, pake ake wa tunteng aye amprepm tiur nar num nakure pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Wa tunteng kin wampwomis ur a nikgwalpm arke wontrakole pa, tunteng aye amprepm mpil tiur pa nakure pake. ");
INSERT INTO urim_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ari kipman a la uwi kin pa ake kul atatu, atom tu pa ikgyokg alen paipm wrisen, atom tu am kai okg akwekgel ase. ");
INSERT INTO urim_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Atom ak mining kuin pa tu atning ok ur a akwe la, 'Oi, kipm wrekg wrekg o! Melnum a la uwi kin iye pa am wli tike! Ti kipm kul eng tepm kai ikyakurel o!' ");
INSERT INTO urim_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Atom tu kin wampwam a anel okg akwekgel rka pa, anel wrekg kolti a awi wakg amprepm alntu pa la. ");
INSERT INTO urim_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Wa tunteng kin wampwomis a titnowen nikgwalpm kalpisen pa tunteng wa wrekg ak ok la kin wampwomis a nikgwalpm arke wontrakole pa la, 'Amprepm a minto ti am kai raipmot eng a plalng tike, ti kipmteng pa lko amprepm ur eng minto la iye!' ");
INSERT INTO urim_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ari tunteng kin wampwomis a nikgwalpm arke wontrakole pa akalmpenten la, 'Amprepm mpil ti ake mpa ntiwe kipmteng pa nimpon minto alminto ti. Kolpa ti kai kipmteng ikor amprepm ur ukul eng alkipmtengen pawo! Kil pa am antiwe minto alminto kilke.' ");
INSERT INTO urim_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Atom tunteng kai akor la ukul ur alntuntengen ari kalpis, melnum a la uwi kin pa am palng ase. Atom tunteng kin wampwomis a numprampen pa, tunteng kai akyakur kipman pa antiwel kul kawor wan pa, la ntokg okipma wail il itopen kin a kil la uwi pa. Pa tu ar wanyun pa. ");
INSERT INTO urim_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tu ar wanyun pa plalng pa, tunteng kin wampwomis a nikgwalpm titnowen pa wa wli palng, atom tunteng akwe la, 'Woi, woi, kitn pa, aleitn pain nanikg, kitn kukwanto wanyun pa pen!' ");
INSERT INTO urim_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ari kil akalmpenten la, 'Kupm lanakepm aklale wrisen. Kupm ake ariwe kipm pa.'” ");
INSERT INTO urim_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Sisas lanaken yangkipm kla pa kai plalng pipa, kil lanaken la, “Kolpa ti kipm rpmi riwe, eng ntei kipm ake ariwe wang a ikga Wailen nar pa.” ");
INSERT INTO urim_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Atom Sisas kil wa la, “Ikga ik wang a Warim Kipman a Melnum pa la nar pa, tu melnum a elng Maur Wailen itna wailen ikgalen nol nikgwalpm atuwen pa, tu pa ikga kolkil: melnum ur la kai ya watinet, atom kil akwe tu melnum akwapel alkilen pa wli, atom kil alken kweikwei wrongkwail alkilen pa, la tu ikglentel. ");
INSERT INTO urim_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ti kai melnum ur pa kil alkel marpm wail manten wampwomis. Wa kai melnum ur pa wa kil wa alkel marpm wail wekg. Wa kai ur pa kil wa alkel marpm wail wris. Am kil alken katila titnongket a ariwe a melnum pa kolpake. Atom kil am kai ase. ");
INSERT INTO urim_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ti melnum a kil awi marpm wail manten wampwomis pa, kil am kai yatnenen kolti elng marpm alkil pa kai ak ak kwap, atom kil wa akawi marpm warim pa wa kaino wampwomis repmrepm kol marpm man a pikekg kil awi pa. ");
INSERT INTO urim_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Am wa kolpake, melnum a kil awi marpm wail wekg pa, kil wa akawi marpm warim pa wa kaino wekg repmrepm kol marpm man a pikekg kil awi pa. ");
INSERT INTO urim_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pake melnum a kil awi marpm wail wris pa, kil kai kolti, kil uwen kanokg lam marpm a melnum wailen alkel pa. ");
INSERT INTO urim_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Melnum wailen pa kil kai rpma wang watinet, atom kil wa yaper wli rpma, la itningke tu melnum akwapel alkil pikekg kil alken marpm pa, la tu ak ak kwap kolai. ");
INSERT INTO urim_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Atom melnum a pikekg kil awi marpm wail manten wampwomis pa, kil awi marpm warim pa kai nampon marpm man pa, atom kil aye kai plan melnum wailen pa la, 'Kitn ri, kitn pikekg alkopm marpm wampwomis kil. Ti kupm awi marpm pa ak ak kwap ti wa kupm wa akawi marpm warim pa wa kaino wampwomis repmrepm kol marpm man a pikekg kitn alkopm pa.' ");
INSERT INTO urim_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Atom melnum wailen alkilen pa akalmpentel la, 'Kitn pa akwap wor wrisen, kitn pa melnum nungkulkg wor akwap wor akupmen pake. Kitn pa pikekg akwap wor ikgalen kwap waiketn a pikekg kupm alkeitn pa, ti mpa kupm ngkiteitn itni ep ikglen kwap wail ur. Ti mpa kitn kul rpmi itopen nimpon kupm melnum wailen alkitn ti.' ");
INSERT INTO urim_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Wa melnum a pikekg kil awi marpm wail wekg pa, wa aye marpm pa wli wa la, 'Melnum wailen, kitn ri, kitn pikekg alkopm marpm wail wekg pa. Kupm wa ak marpm pa ak ak kwap, atom wa kupm wa akawi marpm warim pa kaino wekg repmrepm kol a pikekg kitn alkopm pa.' ");
INSERT INTO urim_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Atom melnum wailen alkilen pa akalmpentel la, 'Kitn pa akwap wor wrisen, kitn pa melnum nungkulkg wor akwap wor akupmen pake. Kitn pa pikekg akwap wor ikgalen kwap waiketn a pikekg kupm alkeitn pa, ti mpa kupm ngkiteitn itni ep ikglen kwap wail ur. Ti mpa kitn kul rpmi itopen nimpon kupm melnum wailen alkitn ti.' ");
INSERT INTO urim_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pipa wa melnum a pikekg kil awi marpm wail wris pa wa aye wli wa la, 'Melnum wailen, kupm ariwe kitn pa melnum kalnten a yangkipm lan kweikwei, a kitn pa melnum a angketuwai okipma kai wring a ake kitn alkitn aken pa, wa kitn wa angkon okipma kai wring a ake pikekg kitn alkitn alin pa. ");
INSERT INTO urim_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kolpa atom ari kupm ngkark, atom kupm kai uwen kanokg lam marpm wail wris alkitn pa. Ti kitn ri, kweikwei alkitnen am kilke.' ");
INSERT INTO urim_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ari melnum wailen alkilen pa akalmpentel la, 'Kitn pa melnum lpmaak klang paipm. Kitn ariwe pa la kupm melnum a kai angketuwai okipma ur kai wring a kupm alkupm ti ake aken pa, wa kupm melnum a kai angkon okipma ur kai wring a kupm alkupm ti ake alin pa. ");
INSERT INTO urim_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kolpa ti kol a kitn uk marpm alkupm pa kai tu melnum a akwap itna wan marpm, eng mpa ik uwinteitn marpm warim, eng kol a kupm wa yaper kul pipa, kol a kupm uwi marpm warim pa nimpon marpm man alkupmen pa. ");
INSERT INTO urim_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kolpa ti kipm uwi marpm wail wris pa kai wam a kil pa, uk kai melnum a kil aye marpm wail wampwam pa. ");
INSERT INTO urim_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Eng ntei, melnum a antiwe kweikwei pa, mpa wa Maur Wailen kil lkel iken eng kil wailet. Pake melnum a rpma tukwok pa, mpa Maur Wailen kil ungkwan kweikwei waiketn a kil antiwe pa. ");
INSERT INTO urim_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kolpa ti kipm ungkwan melnum akwapel paipm a kolpa kawor en ai kai itni kai miningket paipm ai, kai wrik a ikga tu melnum akg tilntul nam ok paipm.'” ");
INSERT INTO urim_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Sisas kil wa la, “Ik wang a Warim Kipman a Melnum kil nar nimpon titnongket a nang wailen alkil, numpon tu maur angklin alkilen pa, kil ikga rpmi wrik wor alkilen eng rpmi itning yangkipmok. ");
INSERT INTO urim_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tu wrong kin kipman wrongkwail ikga tu wli itni wris i wulmpa akilen, atom ikga kil lok mpreingen tu wrong kin kipman pa kai itni mapming wekg. Kol a melnum a ikgalen manto walkg malkgu, atom alok ampreingen manto walkg malkgu kai itna man, a manto walkg tumpulmpis pa kai itna man. ");
INSERT INTO urim_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Am kolpake, kil ikga lok mpreingen manto walkg malkgu pa kai itni wam wi pa, wa manto walkg tumpulmpis pa kai itni wam wangkokg pa. ");
INSERT INTO urim_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Atom ikga Melnum Tukgunakg ikga kil la kai tu melnum a rpma wam wi pa la, 'Kulntopm o! Kipm pa wor pake. Yan akupmen pa ipma wor eng kipm pake. Kolpa ti kipm or rpmi uwi numitnen kweikwei wor wor a pikekg Maur Wailen kil numprampentepm ak wang a pikekg kil antokg kanokg pa. ");
INSERT INTO urim_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pikekg kupm nikgalmpopm pa, kipm alkopm okipma al. Wa pikekg kupm uwaketopm pa, kipm alkopm u al. Wa kupm melnum a ya watinet ai wli, ari wa kipm ikgalentopm ariworwor. ");
INSERT INTO urim_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Wa kupm rpma apm kalpisen pa, kipm wa alkopm apm eng kupm nowe. Wa kupm numpet pa, wa kipm ikgalentopm ariworwor. Wa kupm kai rpma wan tipmining pa, kipm kul ariwopm.' ");
INSERT INTO urim_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ti tu melnum ute wor a pikekg akwap kolpa, ikga tu ikilmpentel kolpa la, 'Wailen, men pikekg ake ari kitn pa nikgalmpeitn a uwaketeitn, atom men alkeitn u a okipma pa al. ");
INSERT INTO urim_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Men pikekg ake ari kitn pa a ya watinet ai wli, atom men ikgalenteitn pa. Men pikekg ake ari kitn apm kalpisen pa, atom men alkeitn apm pa kitn nowe pa. ");
INSERT INTO urim_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Men pikekg ake ari kitn numpet aki kitn rpma kai wan tipmining pa, atom men kai ariweitn pa.' ");
INSERT INTO urim_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Atom Melnum Tukgunakg pa kil ikga ikilmpe kolpa la, 'Kupm lanakepm aklale, kuina ur a kipm angklin wris ur a tu paipm paipm akupmen a nang kalpisen pa, pa kipm akwap eng angklin kupm tike.' ");
INSERT INTO urim_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","A ikga kil wa lanaki tu melnum a rpma wam wangkokg a kil pa la, 'Kipm melnum a kai paipm pa kipm kai tukwelkgtopm, kai wakg a ikga itna yongkyong, a numprampen eng Maur Paipm itna ep nampon tu maur angklin alkilen. ");
INSERT INTO urim_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Pikekg kupm nikgalmpopm pa, ake kipm alkopm okipma al. Wa pikekg kupm uwaketopm pa, ake wa kipm alkopm u al. ");
INSERT INTO urim_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Wa kupm melnum a ya watinet wli pa, ake wa kipm ikgalentopm. A kupm apm kalpisen pa, ake wa kipm alkopm apm ur eng kupm nowe. Wa kupm numpet pa, ake wa kipm kai ikgalentopm, a wa kupm rpma kai wan tipmining pa, ake wa kipm kai ariwopm.' ");
INSERT INTO urim_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Atom tu ikga ikilmpe kolpa la, 'Wailen, men pikekg ake ari kitn a nikgalmpeitn a uwaketeitn, kitn a ya watinet ai wli, kitn apm kalpisen, kitn numpet, a kitn rpma wan tipmining angkai ai pa, eng mpa men ngklinseitn pa.' ");
INSERT INTO urim_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ari kil ikga ikilmpe la, 'Kupm lanakepm aklale wrisen, pikekg ake kipm angklin melnum ur a tu nang kalpisen kil pa, pa ake kipm angklin kupm.' ");
INSERT INTO urim_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Atom tu pa kai awi wleket a itna yongkyong akalmpe a ake tu arein angklin tu melnum pa. Pake tu melnum a akwap ute wor angklin tu melnum pa, tu pa ikga kai rpmi wor yongkyong.” ");
INSERT INTO urim_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sisas kil la oklala pa plalng pa, wa kil wa la kai tu watnom alkil ti la, ");
INSERT INTO urim_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","”Kipm ariwe pa, a wang wekg kolti eng wang wail a pikekg Maur Wailen ak awi tu amentepmen aye kul takuleikgen tu Isip pa, atom ik wang pa tu ikga elng Warim Kipman a Melnum pa kai eng tu kurkurngkel rki yo okgmangki.” ");
INSERT INTO urim_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","A wang wekg pa, tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen, a tu melnum wail wail pa, tu anel kai rka wris kai wan anong a Kaiapas, melnum tukgunakg a tu melnum ipma krakgen. ");
INSERT INTO urim_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Atom tu akor ya ampen la rkul Sisas eng la orel imo. ");
INSERT INTO urim_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ari tu la kolkil la, “Ake mpa mentepm rkulel ik wang wail a antokg okipma pa, pa mpa ntokg tu wrong kin kipman ipma wakget or tita wail, ti kai itni papen.” ");
INSERT INTO urim_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Atom Sisas kinar anong Petani rpma wan a Saimon, melnum a pikekg i paipuk awi pa. ");
INSERT INTO urim_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Kin wris ur pa kil aye wes kaingkuren ur pa pik atnen u yaprekget wor a pikekg ak marpm wail paipm awi pa, aye or eng Sisas. Kil ngkaten ak kaluk Sisas pa kai tukgunakg pa ak wang a kil al okipma pa rpma. ");
INSERT INTO urim_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tu watnom alkil pa tu ari kolpa, tu karken atom tu la kolpa la, “Wa kil kaken u yaprekget wor pa eng kuina wai? ");
INSERT INTO urim_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kol u pa kol a ik uwi marpm wail manten, atom kol a uk tu melnum a rpma tukwok pa.” ");
INSERT INTO urim_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Sisas kil ariwe kuina ur a tu la pa atom kil lanaken la, “Wa kipm uk kaikuten kai kin pa eng ntei? Pa kil akwap wor wrisen eng kupm ti. ");
INSERT INTO urim_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tu melnum a tukwok pa ikgam antiwepm rpma pa rpma pake. Pake kupm ti pa ikgake ntiwepm rpmi pa i pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","A kil alung u yaprekget wor kil kai num akupmen kil pati, kil antokg kupm ti nimprampen eng ikga tu uwen kupm ti kai kirk pa. ");
INSERT INTO urim_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kupm lanakepm aklale wrisen, ikga tu a laron yangkipm wor yela tungtangkem a kanokg ti pa, ikga kuina ur a wet kin ti antokg pa, ikga wa tu laron kolpa eng ikwonilmpen kil pa iye or pa kai.” ");
INSERT INTO urim_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Atom Sutas Iskariot, watnom ur a tu melnum wampwam yikak wekg a Sisas aroaro wonel pa, kil aye yangkipm itna ya kai naki tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Kil la kolkil la, “Mpa kipm uk kuina kupm ti, eng mpa kupm elng Sisas ti kai wam akipmen pa?” Atom tu angkleikg marpm a tu Suta pa kamel wris tuwek wampwam pa alkel. ");
INSERT INTO urim_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kil awi krimpwayek pa plalng pa, kil akor ya ur eng la uk Sisas pa kai wam a tu pa. ");
INSERT INTO urim_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Wang wail aripm ur a akangklei wring wris wris men angklon nok tingklak a ak mpim ap mringen ak oren pa am ngkaten ak wang wet tike. Tu watnom a Sisas aroaro wonel pa kai eng Sisas pa atom lanakel la, “Kitn la men nimprampen manto walkg malkgu war kweikwei okipma ti itni kai a i, atom mpa kitn il pa?” ");
INSERT INTO urim_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kil lanaken la, “Kipm kai laniki melnum ur kil kai anong wail pa la kolkil la, 'Kupm Melnum a kaling plan tu melnum pa la kolkil la, “Wang akupmen am kul wreren tike, ti kupm nampon tu watnom alkupmen ti, mpa men il manto walkg malkgu kweikwei ti rpmi wan akitnen tike.”'” ");
INSERT INTO urim_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Atom tu watnom alkil pa akwap katila ok a kil lanaken pa, atom tu numprampen okipma pa. ");
INSERT INTO urim_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Takgni kinar pelpel ti pa, Sisas nampon tu watnom wampwam yikak wekg alkil pa kai rpma okg arke tita la il okipma pa. ");
INSERT INTO urim_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tu rka al okipma pa pipa, Sisas lanaken la, “Kupm lanakepm aklale wrisen la, wris ur akipmen ti mpa uk ya eng uk kupm ti kai wam a tu wrongmanto.” ");
INSERT INTO urim_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tu watnom alkil pa anel ipma kaikut paipm, atom ur asen plalng pa wa ur asen kolpa la, “Wailen, mpam kupm ti aki mla?” ");
INSERT INTO urim_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ari Sisas akalmpe la, “Melnum a anti kupm angkle okipma kai kaimung wris pa pati am melnum pake. ");
INSERT INTO urim_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Warim Kipman a Melnum ikga imo kolen wrkapm a Maur Wailen la pake. Pake woi, arein melnum a uk ya eng uk Warim Kipman a Melnum pa kai wam a tu wrongmanto pa, kil ikga uwi paipm. Kola wor kol melnum pa kolake pikekg man raku, kol a kalpis.” ");
INSERT INTO urim_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Atom Sutas, melnum a uk ya pa, kil wrekg akalmpe kolkil la, “Melnum a kaling plan men, mpam kupm ti ur tike?” Ari Sisas lanakel la, “Am kol a kitn la pa aklale pake.” ");
INSERT INTO urim_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tu al okipma pa rka pa, Sisas awi okipma pa aye itna ukwor Maur Wailen pa plalng pipa, kapor alken atom lanaken la, “Kipm uwi ilo, kil num akupmen.” ");
INSERT INTO urim_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Atom tu al plalng pa, wa kil wa awi u wain pa aye itna ukwor Maur Wailen pa plalng pipa, almten atom kil lanaken la, “Kipm plalngen il o! ");
INSERT INTO urim_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Pa walmpopm akupmen a ungkwan eng lam kla nampon Maur Wailen, atom kil ungkwan paipmpaipm wrongkwail a kipm melnum antokg pa. ");
INSERT INTO urim_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kupm lanakepm la, kupm ikgake il u wain kil nti ur. Kupm ikga itni nungkwangen kolpa kai ngko wang a ikga Yan alkupm kil ikglen kweikwei wrongkwail pa pipa, kupm ntiwepm il u wain weten pa.” ");
INSERT INTO urim_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tu awi okipma pa plalng pa, tu ngkat nang ur pa ak plalng pa, tu kai kaino nang Olip. ");
INSERT INTO urim_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sisas kil lanaken kolpa, “Ik mining ti pa kipm plalngen mpa ngkirk nuurngtopm plalng. Kol Maur Wailen la ela wrkapm alkilen pa la kolkil la, 'Kupm ilm melnum a ikgalen manto walkg malkgu pa pipa, manto walkg malkgu pa ikga ngkirk kai itn palpa.' ");
INSERT INTO urim_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pake wa kol kupm wrekg i kirkap pa kulno pa, ikga kupm eptepm eng kipm kai rpmi kai Kalili.” ");
INSERT INTO urim_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita kil akalmpe kai eng Sisas pa la, “Tu men alpmen ti pa mpa ngkirk pake, kupm pa mpa kalpis.” ");
INSERT INTO urim_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ari Sisas kil akalmpe kolpa la, “Kil kupm lanakeitn aklale wrisen la, ik mining ti pa, karek ake la pa, kitn mpa lam nang a kupm ti nti wraur.” ");
INSERT INTO urim_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pake Pita kil la kolpa la, “Kol tu ilmpopm imo nimpokgenteitn pa, kupm ake mpa ngkirk eng lam nang akitnen pa, kalpis.” Wa tu watnom alkil pa, tu plalngen am wa la kolpake. ");
INSERT INTO urim_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sisas anti tu watnom alkil pa anel kai wrik ur a namput la Ketsemani, atom kil lanaken la, “Kipm rki kil, a kupm kai oklala niki Maur Wailen kai ketn ti.” ");
INSERT INTO urim_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kil awi Pita pa nampon warim kipman wekg a Sepeti pa antiwel. Ipma a kil pa kaikut paipm wrisen, kil rpma paipm titnowen num. ");
INSERT INTO urim_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Atom kil lanaken la, “Ipma a kupm kil kaikut paipm wrisen ai eng a lok ngkliwopm kai imo. Ti kipmteng rpmi wulmpa ore oklala niki Wailen ti nti kupm ti.” ");
INSERT INTO urim_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Atom kil wa naurngten kai ketn, atom kil elngtangko kinar kanokg ti akg arein oklala naki Maur Wailen pa la kolkil la, “La woi, Yaiyai akupm, kol antiwe pa, mpa kitn ngkit kalkuten a rpma kaimung ti tukulelkgtopm. Ik ik nikgwalpm akitnen pawo, ake mpa kitn ik ik nikgwalpm akupm kil.” ");
INSERT INTO urim_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kil oklala naki Maur Wailen plalng pa, kil wa yaper kai ari tu watnom alkil pa ari okg plalngen rka. Atom kil arowen ikgyokg, atom kil lanaki Pita pa la, “Karken a kipm antiwopm rpma waiketn ur? ");
INSERT INTO urim_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Rpmi wonirpme, a oklala niki Maur Wailen ti, eng ake mpa kalkuten a palngtopm pa ik rkolng kipm pa ngko. Nol nikgwalpm ti pa atopen pake, numpwam ti pa lpmaak.” ");
INSERT INTO urim_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wa kil wa yaper kai anti ur eng oklala naki Maur Wailen pa la, “La woi, Yaiyai akupm, kol kitn ake la ngkiten kaimung a kaikuten kil tukuleikgtopm pa, kitn ik ik nikgwalpm alkitnen pa, kupm antiwe mpa il pa.” ");
INSERT INTO urim_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kil wa yaper kul ariwen ari ikgyokgalen ti okg rka. ");
INSERT INTO urim_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Wa kil wa naurngten rka pa, kil wa yaper kai oklala naki Maur Wailen anti ur, kol wet kil oklala nakel anti wekg ai. ");
INSERT INTO urim_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","46","Kil oklala naki Maur Wailen plalng pa, kil wa yaper kul arowen ikgyokg lanaken la, “Kipm okgen na rka? A pake, wrekg ri! Wang am plalng tike, melnum a uk ya pa am wli tike, mpa uk Warim Kipman a Melnum ti kai wam a tu melnum a antokg paipmpaipm. Wrekg wrekg eng tepm kai o!” ");
INSERT INTO urim_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sisas la okyangkipm pa itna pa, Sutas melnum wris ur a tu watnom alkilen pa wli palng. Tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen nampon tu melnum wail wail pa, tu ukwa tu melnum watipmen aye kowri a yomis yomis kweikwei pa anti Sutas pa aye wli. ");
INSERT INTO urim_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Atom melnum a la mpa uk Sisas kai wam a tu wrongmanto pa, kil pikekg yapon yangkipm nampon tu pa la, “Kipm ri melnum a kupm kai rkul nikron pa pipa, kipm rkul o! Melnum ampake.” ");
INSERT INTO urim_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Sutas pinterng kai arkul nakrontel akwampor la, “Alketn wor, melnum a kaling planto!” ");
INSERT INTO urim_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ari Sisas akalmpe la, “Melnum wor alkupm, kitn wet kul la ntokg kuina, pa kitn ntokg o!” Atom tu kul yipuket Sisas pa wamparpmewel kolti, tu arkulel. ");
INSERT INTO urim_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Watnom wris ur a Sisas aroaro wonel pa ari kolpa, kil wamnalu kowri alkil ti ak wangket nungkulkg wompel ur a melnum akwapel a melnum tukgunakg a tu ipma krakgen pa kitnangku kolti. ");
INSERT INTO urim_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ari Sisas kil lanakel la, “Lupm kowri pa elngkinar timpal alkil pa! Melnum a alm tita ak kowri pa, ikgam wa tu uwi kowri pa ikilmpen pake. ");
INSERT INTO urim_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kitn ti akwonalmpen la kupm ti akentiwe akwe Yan akupmen ai, eng mpa kil ukwa tu maur angklin almpwrong akilen a angen mapming wail manten wampwam yikakwompwekg akilen ai nar eng ngklin kupm ti? ");
INSERT INTO urim_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yangkipm wrkapm a Maur Wailen la pa mpam palngtopm kolpake. Kol kupm ukwen tu pa nar ngklinsopm pa, yangkipm wrkapm a Maur Wailen la pa, ake mpa palng iklale.” ");
INSERT INTO urim_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sisas kil la kai tu melnum a kul la rkulel pa la, “Kipm la kupm ti melnum paipm ur, atom kipm aye kowri a yo kweikwei pa wli la ik rkulopm? Akangklei wang kupm itna wunong kaling plan tu melnum itna yalming a Maur Wailen pa, ake kipm kul arkulopm. ");
INSERT INTO urim_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pake kweikwei wrongkwail ri kil pa palng kanun yangkipm a tu melnum okwripm a Maur Wailen pikekg la ela kai wrkapm pa palng aklale.” Atom tu watnom plalngen alkil pa naurngkel itna pa, a tu am ngkark kaingkai ase. ");
INSERT INTO urim_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tu melnum wet arkul Sisas pa, anel aye Sisas pa kai wan a Kaiapas, melnum tukgunakg a tu ipma krakgen. Tu melnum a aroaro wonel tu yangkipm a Moses pa nampon tu melnum wail wail, am rka wan pake. ");
INSERT INTO urim_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pake Pita pa angklokg wang kanukg kanukg, kolpa kanunten kai kawor wan anong akapm a melnum tukgunakg a pa, kai rpma nampon tu melnum wantengkwang pa rpma, la rkolng nungkulkg itning yangkipm a tu la Sisas pa la, mpa tu ntokg kai kolai. ");
INSERT INTO urim_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen, a tu mringman pa tu akor yangkipm kansil ur, eng la mpa ik ilm Sisas ti imo. ");
INSERT INTO urim_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tu wailet pa aye yangkipm kansil wli pake, ake tu ansil yangkipm ur eng mpa ilmpel imo, kolpa kaingkai, melnum wekg ur pa wa wrekg kai itna. ");
INSERT INTO urim_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Tuwekg la Sisas pa la, “Melnum pa la kolkil la, kil ikga tikale yalming a Maur Wailen pa plalng pipa, kil le wan weten pa ik wang wraur.” ");
INSERT INTO urim_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Atom melnum tukgunakg a itna ep eng tu ipma krakgen kimeket pa wrekg la kai Sisas pa la, “Kitn ti ok kalpisen a akalmpe kai tuwekg a laweitn pa.” ");
INSERT INTO urim_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pake Sisas pa terng itna, ake akalmpe ok ur. Atom melnum tukgunakg a itna ep pa lanakel la, “Kitn naren Maur Wailen a rpma yongkyong pa, kitn laniko iklale la, kitn Krais, Warim Kipman a Maur Wailen aki kalpis?” ");
INSERT INTO urim_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Sisas akalmpe la, “Ei, aklale, am kol a kitn la pake. Kil kupm lanaki kipm wrongkwail kolkil la, ikga itni waiketn kolti pa, ikga kipm ri Warim Kipman a Melnum ikga rpmi wam wi a Maur Wailen a Antiwe Titnongket Wail Manten. Wa kipm ikga ri kil ikga itni waipmunu pa ikiyewel nar.” ");
INSERT INTO urim_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Atom melnum tukgunakg a itna ep pa nikgwalpm wakget aro apm alkil pa kil lanakel la, “Kil aknokgel Maur Wailen! Yangkipm ti kai paipm ase, ti ake mpa wa mentepm uwi melnum weten ur wa iyewli eng lawel pa! Ti kipm alkipm wet atning a kil ak nokgel Maur Wailen pa! ");
INSERT INTO urim_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ti kipm akwonalmpen kolai melnum pa?” Ari tu akalmpe ok akil pa la, “Pa kil antokg paipm eng kil la kil alkil la kil Krais, ti kai kil imo!” ");
INSERT INTO urim_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Atom tu ungkwawel wlikg kai ikgokg ti, a tu orel ak wam. Wa tu tiur pa wampor wam ntrawel kai tangkwei pa. ");
INSERT INTO urim_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tu orel kolpa a angklo ok pa lala, “Kitn Krais pipa, kitn la melnum ur a oreitn pa ri!” ");
INSERT INTO urim_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita pa kil anti tu rpma kawor akapm. Atom kin akwapel ur pa kul ariwel atom lanakel la, “Kitn melnum ur pikekg anti Sisas kai Kalili am tike.” ");
INSERT INTO urim_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ari Pita kil la kil kalpis itna wulmpa a tu melnum wrongkwail a rka pa. Atom kil la, “Kupm akwekgel kuina ur a kitn la pa.” ");
INSERT INTO urim_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wa kil wa wrekg a pa wa kai itna kai yipmingki yun a kawor en ai, pa wa kin ur wa ariwel, atom wa la kai tu wrongkwail a rka pa la, “Melnum pa pikekg anti Sisas a Nasaret am tike.” ");
INSERT INTO urim_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ari kil wa lam nang a Sisas pa anti ur, atom kil akwen la, “Aklale wrisen kaino kwa, kupm akwekgel melnum a kipm la pa!” ");
INSERT INTO urim_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Wa itna waiketnketn pa, tu melnum tiur a itna pa wa kai lanaki Pita pa la, “Kitn pa am kitn melnum ur a tu pa aklale pake. Men atning ok kromeng akitnen pa atom men ariwe la kitn melnum ur atuwen Kalili ampake.” ");
INSERT INTO urim_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ari Pita kil nikgwalpm wakget akwen aklale wrisen la, “Kupm akwekgel melnum pa, kupm kalpis. Kol yangkipm a kupm la kil kupm kansil pa, kupm ikga uwi paipm.” Kil la kolpa plalng pa karek kil la. ");
INSERT INTO urim_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pipa Pita kil akwonalmpen yangkipm a pikekg Sisas kil la pa la, “Karek ikgake la pa, kitn ikga lam nang akupmen pa nti wraur.” Pa Pita kil kawor akg paipm kawor en ai. ");
INSERT INTO urim_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ak kong miningket ti pa, tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen pa nampon tu melnum wail wail a ikgalen tu wrong kin kipman pa, tu akor nikgwalpm la ilm Sisas imo. ");
INSERT INTO urim_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tu angkuten wam a Sisas pa plalng, atom tu ayewel kai uk kai wam a Pailat, mringman wailen a tu Rom a ikgalen anong kanokg a Sutia pa. ");
INSERT INTO urim_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Sutas, melnum a pikekg uk Sisas kai wam a tu wrongmanto pa, kil ari a tu yapon yangkipm la ilm Sisas pa imo kolpa atom, nikgwalpm wor pa palngtel, atom kil arein la, “Pa kupm ak kwap paipm tuwa.” Kil awi lukgwayek kamel wris tuwek wampwam a angkli kul rpma kil pa, aye yaper kai uk tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen nampon tu melnum wail wail pa. ");
INSERT INTO urim_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Atom kil la kolkil la, “Kupm antokg paipm ase, eng kupm uk ya la kipm ilm melnum wor wrisen pa imo.” Atom tu akalmpentel la, “Pa ake kwap a men ti, kol am kitn alkitn pa ikwonilmpen ai.” ");
INSERT INTO urim_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kolpa atom Sutas angkli lukgwayek pa elng kawor rmpa yalming a pa, a kil kai angko til. ");
INSERT INTO urim_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen pa awi lukgwayek pa atom tu la kolkil la, “Kil lukgwayek la ikilm melnum, ti ake mpa mentepm ermpi nimpon marpm a yalming a Maur Wailen pa.” ");
INSERT INTO urim_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kolpa atom tu yapon yangkipm la ik krimpwayek pa ik rmpen kanokg ur a tu angkon eng ak ak kuntuk, a wa elng itni kolen kirkap ur a uwen tu melnum a ya watinet wli pa. ");
INSERT INTO urim_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kolpa atom tu akwe wrik nang pa la, Kanokg Walmpopm. Atom wrik nang pa am tu akwe kolpa itna pake. ");
INSERT INTO urim_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Atom yangkipm ur a pikekg Seremaia melnum okwripm a Maur Wailen la pa palng aklale, pati la kolkil, “Tu Isrel awi marpm kamel wris tuwek wampwam pa kai repmrepm kolen lukgwayek a pikekg tu elng itna la ikga ikirmpen kil pa am kolpake. ");
INSERT INTO urim_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Atom tu ak marpm pa akarmpen kanokg ur a tu angkon eng ak ak kuntuk. Pa kanun yangkipm a pikekg Wailen kil lanakopm pa.” ");
INSERT INTO urim_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Atom tu aye Sisas pa kaino itna wulmpa a Pailat mringman wailen pa atom kil asentel la, “Kitn pa melnum tukgunakg a tu Suta am tike?” Atom Sisas kil la kolpa la, “Ei, am kol a kitn la pake.” ");
INSERT INTO urim_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen nampon tu melnum wail wail pa tu almpel yangkipmok watipmen, ari ake Sisas akalmpe yangkipm ur, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kolpa atom wa Pailat lanakel la, “Ti ake kitn atning yangkipmok watipmen a tu almpeitn ti?” ");
INSERT INTO urim_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ake wa Sisas akalmpe ok ur. Kolpa atom mringman wailen a itna ep pa kil akwonalmpen watipmen. ");
INSERT INTO urim_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Akangklei wring wris wris atom angko wang a tu al akule wan pa, mringman wailen pa ungkwan melnum wris a rpma wan tipmining pa kulor kai en. Wrongkwail kin a kipman pa wakrongen melnum mla ai, atom tu la pa Pailat kil ungkwan melnum pa a wan tipmining pa kulor kai en. ");
INSERT INTO urim_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ak wang ti pa melnum ur a rpma wan tipmining a tu ariwewel worwor la kil melnum paipm, nang akilen pa Parapas. ");
INSERT INTO urim_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tu wrong kin a kipman kai rka wris pa, Pailat asenten la, “Kipm wakrongen melnum mla lala kupm ungkwan kawor en eng kipm pa? Parapas aki Sisas a namput la Krais?” ");
INSERT INTO urim_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pa kil ariwe la wet tu elng Sisas pa kul wam akilen ti pati atnen tu ipma paipm eng kil pake. ");
INSERT INTO urim_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat kil rpma wrik alkil a rpma rpma eng atning yangkipm pa, kin alkil pa ukwa yangkipm kil kulntel ak angkengkel la kolkil la, “Ake mpa kitn ntokg kwei ur kai melnum ute wor pa eng ake kil antokg paipmpaipm pa, kalpis. Wet ak mining kil pa kupm okgwangket kai melnum pa ari kupm awi kaikuten wail.” ");
INSERT INTO urim_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pake tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen nampon tu melnum wail wail pa tu uk yangkipm tu wrong kin a kipman pa atom tu mpraken la, “Elngen Parapas pa kai o, a kipm ilm Sisas pawo!” ");
INSERT INTO urim_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Atom mring wailen pa wa asenten la, “Kipm wakrongen mla wris ur a tuwekg la mpa kupm elng kulor kai eng kipm pa?” Ari tu akalmpe la, “Men wakrongen Parapas.” ");
INSERT INTO urim_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailat kil asen tu pa la, “Ti mpa kupm ntokg kolai Sisas a tu namput la Krais ti?” Ari tu akalmpe la, “Kurkurngkel rki yo okgmangki pawo!” ");
INSERT INTO urim_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ari Pailat kil asenten la, “Eng kil antokg paipmpaipm kuina wai?” Ari tu mpraken akalmpe yikakatnen paipm la, “Kurkurngkel o!” ");
INSERT INTO urim_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tu itna pa itna pa, la plalplal mainmain wreren eng a or tita, kolpa atom Pailat kil titnowen num, yangkipm kalpisen a ak angkeng tu pa. Atom kil ari kolpa, kil awi u pa aklak wam alkilen ti eng mpa tu wrongkwail pa ri, a kil la kolkil la, “Kupm yangkipm kalpisen eng antokg melnum kil amo. Kalkuten pa itna kai kipm alkipm pake, kupm pa kalpis.” ");
INSERT INTO urim_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ari tu wrongkwail kin a kipman a pa akalmpe la kolkil la, “Elng kalkuten a amo akilen pa kul men ti nimpon tu warim amenen ti rki!” ");
INSERT INTO urim_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Atom Pailat pa kil ipma kalkuten, pake kil katila nikgwalpm a tu pa kolti ungkwan Parapas pa a wan tipmining pa kulor kai en eng tu pa. A kil lanaki tu melnum a almpwrong pa awi ampei pa ak ake Sisas pa plalng pa, uk kil elng kai wam atuwen pa la tu iyewel kai kurkurngkel rki yo okgmangki ai. ");
INSERT INTO urim_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Atom tu melnum a almpwrong a mringman wailen pa tu aye Sisas pa kai kawor wan a mringman wailen pa, atom tu akwe tu melnum wailet a almpwrong pa wli kapringentel. ");
INSERT INTO urim_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tu aner apm akilen pa, atom tu nowewel apm watet wail ur pa. ");
INSERT INTO urim_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tu kapring ampei iket ur pa kolen wanukgmis pa, atom tu elng rpma tukgunakg akilen pa. Tu alkel wark pa kai wam wi akilen pa. Tu kalingkake kil pa kol kil melnum tukgunakg atom tu kapor kilko aleinsel, a ak nokgelel la, “Melnum tukgunakg a tu Suta, alkeitn wor!” ");
INSERT INTO urim_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tu ungkwawel wlikg, plalng pipa, tu awi wark kai wam alkilen ti wa akorel kai tukgunakg ti. ");
INSERT INTO urim_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tu ak kolpa kai, plalng pipa, tu aner apm watet wail kai num a kil pa kai takwelkg, a wa nowewel apm alkilen pa. Atom tu ayewel kai eng la kurkurngkel rki yo okgmangki. ");
INSERT INTO urim_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tu akawi Sisas pa angkom naurng anong wail pa or ya pa kai la kurkurngkel rki yo okgmangki pipa, tu ansil melnum ur kai anong Sairini, nang akilen pa Saimon. Atom tu tirpmingentel la kil ngkit yo okgmangki a Sisas pa iye. Atom kil ngkat aye kai. ");
INSERT INTO urim_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tu kai palng kai wrik ur a tu namput la Kolkota. Yiprokgen a wrik nang pa pati tukgunakg timpal. ");
INSERT INTO urim_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tu kai palng wrik pa pipa, tu ngkaten u wain ur a wuten tu ak kweikwei kinipis ak oren pa ngkaten alkel, la mpa kil il eng ik kupuketel num a wleket pa. Atom kil al akwiyen ari ake kil lala il pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tu karkurngkel rka yo okgmangki pa, plalng pa, tu alm nep pimpos pa la mla ai klangkil pipa, mpa tu mpreing apm a Sisas pa. ");
INSERT INTO urim_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tu antokg kolpa rka ikgalen Sisas pa rka. ");
INSERT INTO urim_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tu nira yangkipm yiprokgen na a tu alm Sisas pa, atom karkurng itna kaino yo okgmangki tukgunakgen kwa a Sisas pa kolkil la, “Kil Sisas, kil Melnum Tukgunakg a tu Suta.” ");
INSERT INTO urim_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tu karkurng melnum paipm wekg pa itna wreren Sisas pa. Ur pa itna wam wi a ur pa itna wam wangkokg. ");
INSERT INTO urim_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Atom tu wrongkwail kin a kipman pa kaingkul angkli wulmpa pa elng kaino ariwel atom tukgunakg wilwil a ak nokgelel ");
INSERT INTO urim_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","lala, “Kitn pikekg lala kitn antiwe titnongket a tikale yalming a Maur Wailen pa atom wa le weten ik wang wraur ti, pati kitn ngklin kitn alkitn pawo! Aki kitn la kitn Warim Kipman a Maur Wailen pa pati, kitn nuurng yo okgmangki pa nar o!” ");
INSERT INTO urim_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen, a tu melnum a aroaro wonel tu yangkipm a Moses pa nampon tu melnum wail wail pa am wa tu wa aknokgelel kolpa yat pake. ");
INSERT INTO urim_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Tu la kolpa la, “Kil pikekg angklin tu wrong kin kipman pake, kil akentiwe angklin kil alkil ti, kalpis. Kil melnum tukgunakg a mentepm Isrel, ti itni eng kil nuurng yo okgmangki pa kulnar pa pati, mpa mentepm ukipma kunun kil pa. ");
INSERT INTO urim_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kil pa ukipma kai Maur Wailen, kolpa ti mpa mentepm ri Maur Wailen kil mpa ipma wor eng kil pa atom ngklinsel ur pa. Eng ntei, kil alkil ti la kil Warim Kipman a Maur Wailen.” ");
INSERT INTO urim_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Am wa kolpa yat pake. Melnum ikgwampet wekg a tu karkurngken itna wreren kil pa, wa ekg wa aknokgelel yat. ");
INSERT INTO urim_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Takgni no pirng pa, aye mining pa kul kai akipaarng kanokg ti yela, kolpa itna a a, tukoryauk pa angkli om pa, mining pa kai plalng pa wa ran. ");
INSERT INTO urim_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mining itna pa Sisas kirkar akg akwe yikakatnen la, “Eli, Eli, lema sapaktani?” Pa la kolkil la, “Maur Wailen akupm, Maur Wailen akupm, wa kitn naurngkopm eng ntei?” ");
INSERT INTO urim_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wa tu melnum tiur atning pa atom tu wa lala, “Palpa kil akwe Elaisa.” ");
INSERT INTO urim_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Atom melnum wris ur pa pinterng kai ak kweikwei ur a akarkolng u pa, angklewe u wain kinipis pa, atom aye kai elng itna wark pa uk kai Sisas pa la kil il. ");
INSERT INTO urim_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ari wa tu tiur pa wa lala, “Itni pen, itni eng tepm ri la, mpa Elaisa pa kulnar ngklinsel aki kalpis?” ");
INSERT INTO urim_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Wa kil wa kirkar akg akwe yikakatnen anti ur plalng pipa, kil amo. ");
INSERT INTO urim_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Atom ak wang ketn pa pipa, apm kaki wail a tu alekg rka akangketen yalming tiwel a Maur Wailen pa rakol wompwekg, angkaino kwa ai kinar plalng kinar kanokg ti. A yelm ti no a wes wail wail ti rakol. ");
INSERT INTO urim_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kirk a tu u mlamin pa rakol wompwekg okore itna atom, tu melnum wailet ute wor itna wulmpa a Maur Wailen pikekg amo kaingkai pa, wa wrekg wrekg rka. ");
INSERT INTO urim_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tu wrekg wrekg a kirk pa or rka nungkwangen, tu alil Sisas pa rmpa kawor mlamin pa plalng pa, kil wrekg or rpma pa, tu palng angko wunong kai anong wail a Maur Wailen amprin eng kil alkil pa, eng tu wrongkwail ariwen om. ");
INSERT INTO urim_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tu melnum a almpwrong pa nampon melnum tukgunakg alntuwen pa tu ikgalen Sisas pa rka. Pa tu ari yelm pa no, a wa kweikwei wrongkwail a palng pa atom, tu ngkark warwar paipm wrisen, atom tu la, “Pa kil Warim Kipman a Maur Wailen aklale tuwa!” ");
INSERT INTO urim_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tu kin wailet a pikekg anti Sisas atn angklinsel angkai Kalili ai kul pa, tu itna kai watin ai ari kuina ur a palng kai Sisas pa. ");
INSERT INTO urim_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kin wris ur pa Maria a Maktala, wa ur pa Maria man a Semis ekg Sosep. A wa wris ur pa man a Son ekg Semis, kin a Sepeti. ");
INSERT INTO urim_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Atom ak nungkurikg ti pa melnum ur a kai anong Arimatea a antiwe kweikwei pa, nang akilen pa Sosep, kil wa melnum ur a ukipma Sisas a aroaro wonel tu pa. ");
INSERT INTO urim_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kil kai ari Pailat pa asentel la uwi yipmiri a Sisas pa. Atom Pailat kil awi wor la kil uwi yipmiri a Sisas pa iye kai. ");
INSERT INTO urim_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Atom Sosep awi yipmiri pa kolti, yapo ak apm tangkoren maing wor ur pa, ");
INSERT INTO urim_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","plalng pipa, ngkat aye kawor alil ermpa kirk weten alkil a pikekg kil u mlamin itna krongkwang pa elngitna eng kil alkil pa. Kil alil yipmiri pa ela kawor mlamin pa plalng pipa, kil talpul wes wail pa aye kai akampri mlamin ok pa plalng pa, kil kai. ");
INSERT INTO urim_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Maktala wa nangkur alkil pa, ekg rpma won kai kirk pa arpmen rpma. ");
INSERT INTO urim_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pa ak wang a tu Suta nimprampen eng wang wail a rpma eng yapm pa, atom wa okg or kong pa, tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen, a tu melnum a arpmen yangkipm yiprokgen a Moses pa, tu kai rka wris anti Pailat pa. ");
INSERT INTO urim_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Atom tu la kolpa la, “Mring Wailen, men wonuwen yangkipm a pikekg melnum yangkipm kansil pa la pa. Pikekg kil rpma pa, kil pikekg la kolkil la, 'Ikga kupm imo rmpi wang wraur kai plalng pa, kupm wa wrekg i kirk pa kulor.' ");
INSERT INTO urim_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kolpa ti kitn uk yangkipm titnongket tu melnum a atnen kirk pa, eng mpa tu ikglen riworwor kolpa itni, wang wraur pa kai plalng. Mpa tu watnom alkil pa kai ik ikgwampel yipmiri a kil pa atom, wa laniki tu melnum pa la, kil am wrekg ase. Atom kansil a tu la kanukg ti pa, mpa wa wail manten angen kansil a pikekg kil la ep ai.” ");
INSERT INTO urim_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Atom Pailat kil lanaken kolpa la, “Wor pa, kipm uwi tu melnum tiur alkupmen a almpwrong ti iye kai itnen kirk pa riworwor, ampur atnen paipmtel pa.” ");
INSERT INTO urim_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Atom tu kai anel kla ur pa amprin wes a ak ampri mlamin ok pa elngitna ikgompen, a tu elng tu melnum a almpwrong pa itna atnen kirk pa itna. ");
INSERT INTO urim_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mining angket wang wail a tu Suta rpma eng yapm pa kai plalng pa, or kong miningket nungkwat tita ak wang itna ep a wang wampwomis wampwompwekg ti pa, Maria a anong Maktala nampon nangkur alkil pa, tuwekg kai ari kirk a Sisas. ");
INSERT INTO urim_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yelm wail pa no atnen maur angklin a Wailen pa angkaino kitnong pa kulnar. Kil kulnar talpul wes wail a akampri kirk ok pa aye kai takwelkg, atom kil kaino rpma kaino wes kwa pa. ");
INSERT INTO urim_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Numpwam ikgokg akilen pa ari kolen mringmalo a plaing pa. Wa apm akilen pa tangkoren pupu kolen wel tangkor pa. ");
INSERT INTO urim_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tu melnum a almpwrong a atnen kirk pa itna pa, tu ngkark num lantiwe warwar paipm wrisen, atom tu elng angko kai amo rmpa kanokg ti kol tu melnum a amo ut ase. ");
INSERT INTO urim_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pa maur angklin a Maur Wailen pa la kai kin wekg pa la, “Ake mpa kipmekg ngkirk. Kupm ariwe la kipmekg pa kul akor Sisas a pikekg tu karkurngkel rka yo okgmangki pa. ");
INSERT INTO urim_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yipmiri a Sisas pa ake rmpa kirk wunen a tu u mlaminel pa, kalpis. Kil am wrekg ase, katila ok kol a pikekg kil alkil la pa. Kipmekg kul ri kirk a pikekg tu alilel armpe kil. ");
INSERT INTO urim_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kipmekg kai itatu laniki tu watnom alkil pa la, kil am wrekg ase. Ti kil am ep kaino Kalili pake, mpa kipm kaino riwel kaino pake, kol a kupm lanakepm pa.” ");
INSERT INTO urim_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tuwekg atning kolpa, tuwekg ngkark naurng kirk pa aktatu kai, ari nikgwalpm wompel a tuwekg pa atopen paipm. Atom tuwekg aye yangkipm wor pa kai lanaki tu watnom alkilen pa. ");
INSERT INTO urim_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tuwekg kai tutusele ari Sisas am itna ya tike, atom kil lanaken la, “Kupm alkepm ipma meen wor.” Atom tuwekg kapor kilko aleinsel arkulel kai nepm pa. ");
INSERT INTO urim_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Atom kil lanaken la, “Kipmekg kaino kolti, ake mpa kipmekg ngkirk. Kipmekg kaino laniki tu melnum alkupmen a kipm ukipma kupm pa la, tu kaino Kalili pawo! Ikga tu riwopm kaino pake.” ");
INSERT INTO urim_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kin wekg pa ekg angkom or ya pa kai pa, tu melnum a atnen kirk pa tu kai kawor anong wail pa, lakati naki tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen pa kweikwei wrongkwail a wet palng pa. ");
INSERT INTO urim_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tu melnum tukgunakgen a tu melnum ipma krakgen pa, tu atning kolpa atom tu kai rka wris akor nikgwalpm nampon tu melnum wail wail pa, plalng pipa, tu yapon yangkipm la uwi marpm wail uk tu melnum a almpwrong pa. ");
INSERT INTO urim_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Atom tu lanaken la, “Mpa kipm laniki tu wrong kin kipman pa la, tu watnom alkil pa wli akikgwampel yipmiri a Sisas pa ak mining, ak a kipm okg akwekgel. ");
INSERT INTO urim_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ampur kipm ipma kalkut, kol Pailat kil itning yangkipm kil pa, mpa men lok ilmpil yangkipm pa laniki Pailat pa, ti ake mpa kipm uwi kaikuten ur.” ");
INSERT INTO urim_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kolpa atom tu melnum a almpwrong pa awi marpm pa, atom tu aye yangkipm kansil a tu la tu watnom a kil alkil Sisas pa akikgwampel yipmiri pa. Tu aye yangkipm pa kai yela, naki tita orarpme tu Suta pa, kolpa kulngkul ak wang ti. ");
INSERT INTO urim_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tu watnom wampwam yikakwris a Sisas aroaro wonel pa tu kaino nang kaino Kalili a pikekg kil lanaken la tu kaino pa. ");
INSERT INTO urim_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tu ari Sisas pa atom tu kapor kilko alein ngkat nang akilen pa, ari tu tiur a tu pa wa akwonalmpen watipmen. ");
INSERT INTO urim_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Atom Sisas kul lanaken la, “Maur Wailen kil alkopm titnongket wrongkwail, atom kweikwei wrongkwail a itna kaino kitnong a itna kanokg ti, am elngkul wam a kupm ti ikgalen tike. ");
INSERT INTO urim_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kolpa ti kipm kai yela anong wrongkwail a yela tungtangkem. Atom kipm ntokg tu pa palng watnom akupm: kipm naren Yan, a Warim Kipman, a Maur Wor atom kuluken! ");
INSERT INTO urim_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","A wa kipm kiling planten eng tu kunun yangkipm wrongkwail a kol a pikekg kupm lanakepm la kipm kunun pa. Kupm lanakepm aklale, kupm ikgam antiwepm rpma kolpa akangklei wang, kolpa kaingkai kai angko wang a kanokg ti kai plalng.” ");
INSERT INTO urim_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wrkapm kil yangkipm wor a la Sisas Krais, Warim Kipman a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yangkipm wor kil pekg palng ep naki Aisaia, kil melnum ok wripm a Maur Wailen, atom kil nira yangkipm kolpa, “Itning, mpa kupm ukwa melnum a aye yangkipm itna ya pa kai ep eng numprampen ya akitnen. ");
INSERT INTO urim_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Angko wrik kalpmilel a ake melnum ur arpme pa, ok a melnum ur pa akwe la, 'Numprampen o! Numprampen ya eng Wailen! Ukulentel ya pa riworwor!'” ");
INSERT INTO urim_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yangkipm pekg Aisaia nira pa, am palng ok arke tike. Son, kil melnum a kaluk tu pa am wli itna wrik kalpmilel ake melnum ur arpme tike. Kil angkli yangkipm eng tu wrong kin kipman eng mpa tu plelng ipma, eng mpa kil kuluken, atom mpa Maur Wailen kil ungkwan paipmpaipm atuwen. ");
INSERT INTO urim_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tu wrongkwail a Sutia, a anong wail Serusalem tu kai eng Son. Tu laron paipmpaipm alntuwen pa, atom Son kil kaluken kai u kop Sotan. ");
INSERT INTO urim_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Son kil nowe apm a tu antokg walkg a manto meng watin (kemel), kil ak ampei angket apm alkilen. Kil al ka nampokgen u pong tatu mpang. ");
INSERT INTO urim_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kil angkli yangkipm la kolpa, “Melnum ur a kul katnukg kupm ti pa, kil pa melnum wailen nang arke, kupm kil pa warim korpis nang kalpisen a kol kil pa akentiwe mpa iner nepm palk a melnum wailen a kolpa. ");
INSERT INTO urim_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kupm ti kalukepm ak u kolti, pake ikga kil alkil kulukepm ik Maur Wor alkilen ai.” ");
INSERT INTO urim_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ak wang pa Sisas kil atnurng anong Nasaret a anong kanokg Kalili pa kil nar, atom Son kil kalukel itna u kop Sotan. ");
INSERT INTO urim_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kil wrekg penterngen a u ti no kwa kolti, kil ari kitnong a rakol pa, Maur Wor kil narntel kol wel punum pa. ");
INSERT INTO urim_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Plalng pipa, ok ur akwe angkaino kitnong pa nar la kolpa, “Pa kitn Warim Kipman akupmen, kupm plan ipma wor wasrongenteitn. Ipma akupmen pa wor atopen kitn.” ");
INSERT INTO urim_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Maur Wor tilp Sisas atatu kai wrik kalpmilel ur a ake melnum ur arpme. ");
INSERT INTO urim_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Sisas rpma wrik kalpmilel pa kol wang kamel wekg miningkranen, atom Maur Paipm Satan ningkailel la kil ngko. Kil rpma nampokgen ul a kirko wanin kweikwei paipm tilpmingen, pake tu maur akwapel a Maur Wailen pa wli angklinsel. ");
INSERT INTO urim_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tu arkul Son kil aye kai rpma wan tipmining pipa, Sisas kil kaino anong kanokg Kalili ngkaten laron yangkipm wor a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kil la, “Wang pekg Son lala pa am palng tike. Maur Wailen la itni wailen ikglen nol nikgwalpm a kipm wrong kin kipman pa am wang tike. Kolpa ti kipm plelng ipma, ukipma yangkipm wor a Maur Wailen!” ");
INSERT INTO urim_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sisas kil angkom antilawe ukupuk yamping a Kalili pa, atom kil ari Saimon nampokgen wusok alkilen Antru. Tuwekg angkli apm mumu pa elng kinar ukupuk pa eng akawi yul pa itna. Kwap pa pati pa kol kwap marpm alntuwekgen. ");
INSERT INTO urim_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Atom Sisas kil lanaken la, “Kipmekg kul kutnun kupm ti, eng mpa kupm kiling plantepm, atom ikga kipmekg rkolng tu wrong kin kipman iyekul kolen a kipmekg arkolng yul pa!” ");
INSERT INTO urim_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tuwekg atnurng apm mumu pa pinterngen kolti rmpa pa, a tuwekg kai katnun Sisas. ");
INSERT INTO urim_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tunteng angkom katila ukupuk yamping pa kai, atom tunteng ari warim kipman warimpen wekg a Sepeti, tuwekg wusok wail, Son a Semis. Tuwekg rpma kawor nim ukupuken pa angkut karpo noworel apm mumu a kitnangku pa. ");
INSERT INTO urim_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sisas kil akwewen, atom tuwekg atnurng yan Sepeti nampokgen tu melnum akwapel a Sepeti pa kai nim ukupuken wail pa penterngen kolti, a tuwekg kai katnun Sisas. ");
INSERT INTO urim_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sisas nampokgen tunteng melnum a katnuntel pa, tunteng kai anong wail Kaperneam. Ak wang wail a rpma eng yapm pa Sisas kil kawor wan a tu atning atning yangkipm a Maur Wailen atnewe pa. Kil kaling plan tu wrong kin kipman pa yangkipm a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ake kil aro wonelen kol tu melnum a aroaro wonel tu yangkipm a Moses pa, kalpis, kil aro wonelen nampon titnongket kol kil alkil yangkipm yiprokgen. Tu atning yangkipm pa, atom tu wrekg paipm. ");
INSERT INTO urim_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ak wang pa melnum wris ur a maur paipm kimpilpet arpme pa, kil kawor wan a atning atning yangkipm a Maur Wailen atnewe pa, kil kirkar akwe la kolpa, ");
INSERT INTO urim_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","”Sisas a Nasaret, kitn kul eng la ntokg na men ti? Aki kitn kul eng la ntokg men ti kai paipm? Kupm ariweitn pa, kitn Melnum Klalen Wakget a Maur Wailen!” ");
INSERT INTO urim_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Sisas kil akle maur paipm pa la kolpa, “Kitn yipo ok akitnen pa! Kitn or kai tukwleikgen melnum pa kai o!” ");
INSERT INTO urim_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Maur paipm kimpilpet kil laik melnum pa ngkrang kolti, atom kil kirkar yikakatnen paipm, atom kil or takwlelkgen melnum pa. ");
INSERT INTO urim_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tu wrong kin kipman pa ari pa tu wrekg paipm, atom tu naki tita la, “Ei, kipm itning yangkipm pa ri, yangkipm pa titnongket tuwa! Tu maur paipm kimpilpet atning yangkipm a melnum pa ungkwanten pa atom tu ngkark!” ");
INSERT INTO urim_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Atom penterng kolti tu aye yangkipm pa kai yela anong kanokg a Kalili pa lanaki tu pa. ");
INSERT INTO urim_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tunteng atnurng wan a atning atning yangkipm a Maur Wailen atnewe pa, tunteng or en, atom Sisas kil awi Semis ekg Son pa aye kawor wan a Saimon a Antru. ");
INSERT INTO urim_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tunteng naki Sisas pa penterngen la yalmpikg mayen a Saimon pa amo num wakget paipm, ti okg rmpa wrik a pa. ");
INSERT INTO urim_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Atom Sisas kai wrerentel a kil wamparmpewel wam pa aye wrekg pipa, amo num wakget a kil pa am kai plalng ike. Atom kil antokg okipma pa uk tu pa al. ");
INSERT INTO urim_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Takgni kai kinar wreren eng a mining turkget pa tu aye tu melnum numpet kimeket nampokgen tu a maur paipm arpmewen pa aye kul eng Sisas. ");
INSERT INTO urim_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tu wrong kin kipman a anong wail Kaperneam pa tu angkli mapming mapming rka wanyun pa. ");
INSERT INTO urim_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Sisas kil ungkwan numpet auraur a tu melnum wailet pa. Kil ungkwan maur paipm watipmen. Tu maur paipm pa tu ariwe Sisas, kolpa ti Sisas kil wa angkengken la ampake tu oklala. ");
INSERT INTO urim_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ak kong miningket paipm ai Sisas kil kai wrik ur a ake melnum ur arpme pa atom kil oklala naki Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon kil awi tu alkil pa tu katnun akorel kolpa kai, ");
INSERT INTO urim_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","tu ansilel, atom tu lanakel la, “Tu wrongkwail pa asen akoreitn.” ");
INSERT INTO urim_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ari Sisas kil la, “Ti tepm kai tutu anong ur a itna wreren tatu ti! Kupm am wa la ngkli yangkipm eng tu pa yat pake, kolpa atom kupm kul.” ");
INSERT INTO urim_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Sisas kai yela or kai anong kanokg a Kalili. Kil ak kwap angkli yangkipm yela wan a atning atning yangkipm a Maur Wailen atnewe pa. Kil ungkwan maur paipm nampokgen. ");
INSERT INTO urim_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Melnum ur a i paipuk awiyel pa kil kul eng Sisas. Atom kil kapor kilko aleinsel a akg a oklala nakel la, “Kol kitn wasrongen pipa, kupm ariwe la kitn antiwe mpa ntokg numpet a kupm ti palng wor pa.” ");
INSERT INTO urim_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sisas kil areinsel atom kil elng wam elewel, atom kil lanakel la, “Kupm wasrongen pa.” ");
INSERT INTO urim_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Sisas kil la plalng, penterng kolti numpet i paipuk akilen pa palng wor. ");
INSERT INTO urim_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Sisas kil tilpel minsrang la kil kai itatu. ");
INSERT INTO urim_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Kil alkel yangkipm titnongket kolpa la, “Ampake kitn laniki melnum ur tutu ya pa kai pa, yaper! Kitn kai plan nepmwam akitnen pa kai melnum ipma krakgen a ak ak kwap eng al wor uk Maur Wailen pa kolti, il wor uk Maur Wailen pa itnen numpet akitnen a palng wor pa kol yangkipm titnongket a pekg Moses lanakepm pa. Kolpa eng mpa tu wrongkwail riwe la numpet a kitn pa am plalng ike.” ");
INSERT INTO urim_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ari melnum pa kil ake wa atning, kil kai yela laron naki tu wrongkwail eng yangkipm yiprokgen a wet Sisas kil antokg numpet a kil palng wor pa. Tu wrongkwail atning yangkipm a kil la pa aklale, atom tu kai akoporel angko ya. Sisas kil akentiwe kai angko wunong kai anong ur pa kalpis. Tu wrongkwail yela takwleikgen tita kul eng ari Sisas. ");
INSERT INTO urim_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Sisas kil rpma wang aripm ur pa kai plalng pipa, wa kil yaper kai anong alkil Kaperneam ike. Tu wrong kin kipman atning a kil kai rpma anong pa, atom tu la kai riwel. ");
INSERT INTO urim_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tu kawor wan a kil pa rka antiwe. Wailet tiur alkil pa angkli rka wanyun enen ti akampri wrik pa rka. Kil angkli yangkipm pa naki tu pa itna, ");
INSERT INTO urim_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ari tunteng melnum wikgwikg pa ngkat melnum ur a nepmwam amowe pa la iye kai eng Sisas. ");
INSERT INTO urim_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mpa tu iye melnum numpet pa iye kawor eng Sisas pa la kolai? Wrong wailet paipm ai. Tunteng akor ya, atom tunteng aye no ya ur a tu antokg pa kaino wan kimpo pa atom tunteng angkut wan kimpo pa tumute Sisas pa. Atom tunteng alekg melnum numpet a rmpa wrik pa elng kinar eng Sisas. ");
INSERT INTO urim_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Sisas kil ari nikgwalpm atuntengen pa atom kil lanaki melnum pa la, “Yek alkupm, paipmpaipm alkitnen am plalng ike!” ");
INSERT INTO urim_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tu melnum a aroaro wonel tu yangkipm a Moses pa anel akwonalmpen kolpa rpma, ");
INSERT INTO urim_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ai, kil pa la yangkipm na kolpa! Pa kil la paipmel Maur Wailen. Ake melnum ur antiwe ungkwan paipmpaipm pa, pa kwap a Maur Wailen wris ata.” ");
INSERT INTO urim_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Sisas kil ariwe nikgwalpm a tu melnum a aroaro wonel tu yangkipm a Moses pa penterngen kolti, atom kil lanaken lala, “Kipm akwonalmpen nikgwalpm kolpa eng ntei? ");
INSERT INTO urim_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Yangkipm a i wunongen eng mpa laniki melnum numpet pa la, paipmpaipm akilen am plalng ike, aki nikel, kil wrekg ngkit wrik ti iye kai? ");
INSERT INTO urim_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kupm la mpa kipm riwe: Warim Kipman a Melnum pa kil antiwe titnongket a ungkwan paipmpaipm a itna kanokg a ti.” Atom Sisas kil lanaki melnum numpet pa la, ");
INSERT INTO urim_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kupm lanakeitn la kitn wrekg o, ngkit wrik alkitn pa iye kai wan alkitnen pawo!” Sisas kil la yangkipm kolpa eng aktitnongketel yangkipm a wet kil la ep pa. ");
INSERT INTO urim_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Melnum pa wrekg kolti, awi wrik alkil pa, angkom or wulmpa a tu kin kipman wrongkwail. Tu ari pa, tu wrekg paipm, tu ngkat nang a Maur Wailen, tu la, “Pekg ake mentepm ari kweiur a palng kolpa ep pa, kalpis.” ");
INSERT INTO urim_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Sisas kil wa yaper kai ukupuk yamping a Kalili. Tu wrongkwail kul eng kil, atom kil angklinten yangkipm a Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sisas kil angkom kai pipa, kil ari Lipai, warim a Alpius, kil rpma wan a tu awi awi marpmel tu atnewe. Sisas kil lanakel la, “Kitn kul kutnuntopm!” Kil atning kolpa, kil wrekg katnuntel. ");
INSERT INTO urim_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wang wris ur pa Sisas nampokgen tu watnom alkilen a kil aroaro wonel pa al okipma rpma wan a Lipai. Tu melnum watipmen a awi awi marpmel tu a tu melnum a antokg paipmpaipm pa wa antiwen anel al okipma pa rpma. Eng ntei, melnum watipmen tiur kolpa wa katnun Sisas yat. ");
INSERT INTO urim_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tu melnum tiur a tu melnum a arpmen yangkipm yiprokgen a Moses pa wa ak ak kwap a aroaro wonel tu yangkipm a Moses pa, tu ari Sisas a al okipma anti tu melnum paipm paipm, wa anti tu melnum a awi awi marpmel tu, kolpa atom tu asen tunteng watnom alkil pa la, “Wa kil al okipma anti tu melnum a awi awi marpmel tu, nampokgen tu melnum paipm paipm pa eng na?” ");
INSERT INTO urim_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sisas kil atning kolpa atom kil naken la, “Melnum a numpworen pa ake mpa kai eng melnum a antokg i numpet pa, kalpis. Tu melnum a numpet akalkilel pa tu kai eng melnum a antokg i numpet pake. Kupm ake kul eng la ukwe tu melnum a akwonalmpen tu alntu la tu ute wor pa, kupm kul eng la ukwe tu melnum a paipm.” ");
INSERT INTO urim_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tu watnom a Son aroaro wonel pa a tu melnum a arpmen yangkipm yiprokgen a Moses pa tu kalpis okipma eng uk wang Maur Wailen. Tu ari kolpa atom tu kul asen Sisas pa la, “Tu watnom a Son aroaro wonel pa, a tu watnom a tu melnum a arpmen yangkipm yiprokgen a Moses pa aroaro wonel pa, tu pa kalpis okipma eng uk wang Maur Wailen. Ti tu watnom alkitn a kitn aroaro wonel pa tu ake kalpis okipma pa eng ntei?” ");
INSERT INTO urim_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ari Sisas kil akalmpe la, “Kol tu yiprokgen ur a melnum wris ur a la uwi kin iye pa, tu mpa kalpis okipma ik wang a kipman pa antiwen rpma? Pa kalpis. Kipman a la uwi kin pa rpma nampokgenten pa, tu atopen, kolpa ti akentiwe mpa tu kalpis okipma pa. ");
INSERT INTO urim_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ikga ik wang a tu ungkwan melnum a la uwi kin pa iye pa kai tukulelkgten pa, tu ikgake uwi okipma, tu ikga ipma kalkut, ti tu ikga kalpis okipma rpmi kolti. ");
INSERT INTO urim_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mentepm ake awi awi apm umpu weten pa ak angkut apm nungkwor a rakol pa. Kol mentepm ntokg kolpa pipa, apm umpu weten pa ikga ik iro apm nungkwor pa kai rakol paipm. ");
INSERT INTO urim_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mentepm ake yapo nok maing weten pa ak ipm nungkwor nungkwor pa, kalpis. Kol mentepm yipo ik ipm nungkwor pa, pa mpa nok maing pa ngki ti, ipm mpa rakolngen nok ti, nok lmpa mpa elng kinar kanokg ti takote. Nok maing weten pa, pa mpa yipo ik ipm maing misen ai kolti.” ");
INSERT INTO urim_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ak wang wail ur a rpma eng yapm pa, Sisas kil angkom or wring wit kuin pa. Tunteng watnom alkilen a kil aroaro wonel pa tunteng angkom katnuntel. Tunteng apur wit ok pa al aye itna wampel. ");
INSERT INTO urim_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Atom tu melnum a arpmen yangkipm yiprokgen a Moses pa lanaki Sisas pa la, “Ai, kitn itning, tu watnom alkitn tu kapor yangkipm titnongket a la, ampake mentepm ikwap ik wang a Maur Wailen kil amprin eng mentepm rpmi eng yapm pa!” ");
INSERT INTO urim_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ari Sisas kil akalmpe ok atuwen pa la, “Ake kipm angkleikg kweikwei a pekg Tepit antokg nampokgen tu melnum alkil ak wang a pekg tu okipma kalpisen a nikgalmpen pa? ");
INSERT INTO urim_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ak wang pa Apiatar kil itna tukgunakg eng tu ipma krakgen kimeket. Tepit kil kawor wan yalming a Maur Wailen pa. Kil al nok tingklak a pekg tu alwor uk Maur Wailen a la ake mpa tu melnum a itna kolti il. Mpa tu melnum a ak ak kwap eng al wor uk Maur Wailen pa il pake. Tepit kil angklon pake wa kil al. Kil awi uk tu melnum alkil pa al nampokgentel. ");
INSERT INTO urim_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Maur Wailen kil ake elng wang wail a rpma eng yapm pa elngitna eng ak angkeng melnum pa. Kil elng wang wail pa itna eng ak angklin melnum. ");
INSERT INTO urim_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kolpa atom Warim Kipman a Melnum pa kil wailen itna ep ikgalen wang wail a rpma eng yapm.” ");
INSERT INTO urim_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ak wang ur pa, Sisas kil kawor wan a tu Suta atning atning yangkipm a Maur Wailen atnewe pa anti ur. Melnum ur pa aye wam paipm alkil pa rpma, ari kolen walmpopm am tingklak plalng ike. ");
INSERT INTO urim_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tu melnum pa rka la mpa ri la Sisas kil ntokg wam a melnum pa palng wor ik wang wail a rpma eng yapm pa aki kalpis. Kol mpa tu ri pa, mpa tu kai or yangkipm nampikgen mring man alntuwen. ");
INSERT INTO urim_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Atom Sisas lanaki melnum a wam paipmen tupmungkul kalpmlel pa lala, “Kitn wrekg itni wulmpa a tu wrongkwail ti!” ");
INSERT INTO urim_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Wa kil asenten la, “Mentepm ntokg nikgwalpm wor ik wang wail a mentepm rpma eng yapm pa aki mentepm ntokg nikgwalpm paipm? Mentepm ngklin melnum eng kil rpmi wor aki mpa mentepm or imo?” Ari tu ake wa akalmpe ok a Sisas pa. ");
INSERT INTO urim_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kil ikatnen tu wrongkwail pa, atom kil nikgwalpm wakget. Kil ari nikgwalpm a tu pa kakiren paipm, atom kil wa nikgwalpm kalkuten eng pa. Wa kil lanaki melnum pa la, “Tita wam alkitnen pawo!” Atom kil tita wam a kil pa am palng wor ike. ");
INSERT INTO urim_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tu melnum a arpmen yangkipm yiprokgen a Moses pa ari pa, tu wrekg aktatu kai, tu kai rka nampokgen tu melnum tiur a melnum tukgunakg Erot. Tu rka wris akor lala tu a ilm Sisas eng kil imo. ");
INSERT INTO urim_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sisas anti tu watnom alkil a kil aroaro wonel pa tunteng wrekg kai ukupuk yamping. Tu wrong kin a kipman ak wail katnuntel. ");
INSERT INTO urim_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tu anong kanokg Kalili, tu anong kanokg Sutia, tu anong wail Serusalem, tu anong kanokg Itumea nampokgen tu melnum a rka wreren u kop Sotan, kai kop wom ai, tu a rka wompel a anong wail Tair a Saiton. Tu kin kipman wrongkwail tu atning kweikwei a Sisas kil antokg. Tu atning pa, tu kul katnuntel. ");
INSERT INTO urim_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sisas kil naki tu watnom alkil pa la, “Rkolngtopm nim ukupuken pa iye kul rpmi ukupuk yamping ti eng mpa kupm kaino rpme, eng ake mpa tu ik tulpul tita kul rkgantiwopm pa!” ");
INSERT INTO urim_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Eng pekg ep kil antokg tu kin kipman wrongkwail palng wor, kolpa atom tu wrong kin kipman a numpet pa tu ak ampri Sisas. Tu ak talpul tita kai la wampirpme Sisas. ");
INSERT INTO urim_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tu melnum a maur paipm kimpilpet arpmewen ariwel kolpa, wa tu kapor kilko aleinsel, tu kirkar paipm, tu la, “Kitn warim a Maur Wailen!” ");
INSERT INTO urim_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ari wa Sisas wa la yangkipm titnongket pa naken la, “Ampur kipm laron kupm ti kai angko wunong la kupm mla pa!” ");
INSERT INTO urim_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sisas kil kaino wrik nangen pa atom tu melnum a kil alkil wasrongen la kulntel pa, kil akwe tu melnum pa, atom tu kulntel. ");
INSERT INTO urim_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Atom kil takwei tu melnum wampwam yikakwompwekg, eng la tu ntiwel rpmi. Eng ikga kil ukwawen kai eng tu itn laron yangkipm a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Kil la lken titnongket eng ikga tu ungkwan tu maur paipm. ");
INSERT INTO urim_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kil takwei melnum wampwam yikakwompwekg: Saimon, pa kil alil nangkel Pita. ");
INSERT INTO urim_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Semis ekg Son, pa warim kipman wekg a Sepeti, kil alil nang wompel atuwekg pa Poanerkes. Yiprokgen a nang pa pati kolpa: warim kipman a milmal. ");
INSERT INTO urim_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Antru, Pilip, Partolomyu, Matyu, Tomas, Semis warim kipman a Alpius, Taitus, Saimon, kil pa a mapming ur a tu a la ungkwan tu Rom. ");
INSERT INTO urim_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Wa Sutas Iskariot, kil pa melnum a ikga uk Sisas kai wam a tu wrongmanto pa. ");
INSERT INTO urim_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sisas angkaino wrik nangen pa nar kai wan anong alkil ike. Tu wrong wailet paipm tu wa wli rka anti ur. Kolpa atom Sisas nampokgen tu watnom alkil a kil aroaro wonel pa akentiwe mpa tu il okipma pa kalpis. ");
INSERT INTO urim_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tu manmuikg alkil pa tu atning a tu la kolpa atom, tu kul eng la ikyakurel. Tu lala kil am titno ike. ");
INSERT INTO urim_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tu melnum a aroaro wonel tu yangkipm a Moses a rka Serusalem pa tu tiur atuwen pa nar kul no la, “Pelsepul, maur paipm tukgunakg a itna ep eng tu maur paipm pa arpmewel. Kil ungkwan maur paipm pa ak titnongket a melnum tukgunakg a maur paipm.” ");
INSERT INTO urim_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sisas akwewen kul wrerentel, atom kil naken yangkipm kla ur pa eng ik laniken la titnongket a kil pa angen titnongket a maur paipm. Atom kil la, “Maur paipm Satan mpa ungkwan kil alkil pa la kolai? ");
INSERT INTO urim_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kol tu anong kanokg wail ur wako iro wrong atom tu or tita pa, anong kanokg wail pa ikgake itni titnongket, kalpis. ");
INSERT INTO urim_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kol tu melnum a anong wris tu la iro or tita pa, ikga tu rak kai rki manman. ");
INSERT INTO urim_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kol Satan, melnum tukgunakg a tu maur paipm, pa la wrekg uwi wrongmanto lan tu alkilen, atom tu iro itni manman pa, mpa tu itni titnongket kolai, kalpis. Pa tu ikga kai plalng. ");
INSERT INTO urim_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Melnum ur ake antiwe mpa tikale wan a melnum titnongket kalnten pa kai kawor ik ikgwampel kweikwei wrikya a melnum pa, kalpis. Mpa kil yipo melnum titnongket pa plalng pipa, antiwe mpa kil tikale wan akilen pa kawor ik ikgwampel kweikwei pa iye kai plalng pake. ");
INSERT INTO urim_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Kupm lanakepm aklale kolpa, mpa paipmpaipm wrongkwail, a yangkipm wrongkwail a tu wrong wailet la paipmel Maur Wailen pa, ikga Maur Wailen ungkwan pa. ");
INSERT INTO urim_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ari melnum a la paipmel Maur Wor a kil pa, Maur Wailen ikgake ungkwan paipmpaipm alkilen pa kalpis. Paipmpaipm alkil pa ikga itni ikngklei wang.” ");
INSERT INTO urim_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tu melnum tiur wet la kolpa la, “Kil palpa maur paipm kimpilpet arpmewel.” Kolpa atom Sisas kil la yangkipm pa. ");
INSERT INTO urim_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ak wang pa man nampokgen tunteng wusok wusok a Sisas pa tunteng kul palng itna kawor en pa, atom tunteng lanaki melnum ur pa laniki Sisas pa eng kil or. ");
INSERT INTO urim_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tu wrong wailet tu rka kapringentel, atom tu lanakel la, “Kitn itning, man nampokgen tunteng wusok wusok alkitnen ai rka kawor en ai akoreitn.” ");
INSERT INTO urim_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kil akalmpe la, “Mpa kupm lanikepm la mla a i man akupmen, a mla mla a i wusok wusok akupmen.” ");
INSERT INTO urim_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kil ikatnen tu wrongkwail kin kipman a rpma kapringentel pa a kil la, “Kipm ri, man a tu wusok wusok akupmen am rpma kapringentopm rpma tike. ");
INSERT INTO urim_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Melnum a katnun wasrongen a Maur Wailen pa, tu pa wusok wusok a muikgmayen a man akupmen pake.” ");
INSERT INTO urim_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ak wang ur pa Sisas kil wa ngkaten kwap pa ak eng kaling plan tu wrong kin kipman a rka ukupuk yamping. Tu wrong wailet paipm tu wli eng kil, kolpa atom kil elng kaino rpma nim ukupuken wris ur. Nim ukupuken pa ela kai u ai. Tu kin kipman wrongkwail pa rka nimilpm wreren ukupuk yamping. ");
INSERT INTO urim_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kil ak yangkipm kla pa ak lanaken kweikwei. Kweikwei watipmen pa kil lanaken ak yangkipm kla kolti. Kil kaling planten kolpa la, ");
INSERT INTO urim_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kipm itning! Kol melnum ur kai laik wanukg erk kai wring. ");
INSERT INTO urim_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kil laik wanukg erk kolpa, tiur pa angko rmpa tatu ya kawor wring wunen, atom tu wel wli al. ");
INSERT INTO urim_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wanukg erk tiur pa angko kai wrik kangirngket. Kanokg waiketn kolti ela kangirng kwa, kolpa atom wanukg pa anip atatu. ");
INSERT INTO urim_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Atom takgni pa no lampul, wanukg pa am amo plalng ike, kol ningnakg alkil pa ake kinar watin. ");
INSERT INTO urim_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wanukg ok tiur pa angko rmpa kawor ampei iket kuin ai. Ampei iket pa anip wrekg kaino ak yapo wanukg pa, kolpa atom wanukg pa ake anip wor. ");
INSERT INTO urim_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wanukg erk tiur pa angko elng nar kanokg wor, atom anip kaino ariwor. Tiur pa anip kaino wailet, tiur pa anip kaino wailet paipm, a tiur pa wa klangkil.” ");
INSERT INTO urim_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Atom Sisas wa angkine lanaken la, “Melnum a nungkulkg atne pa, kil itning yangkipm kil!” ");
INSERT INTO urim_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tu wrongkwail rak plalng, a Sisas kil alkil wris rpma. Tu watnom wampwam yikak wekg a kil aroaro wonel pa nampokgen tu melnum tiur pa, tu rka kapringentel ak asentel yiprokgen a yangkipm kla pa. ");
INSERT INTO urim_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kil lanaken la, “Nikgwalpm ariwe ampen a Maur Wailen kil ikgalen ipma a melnum pa, am kil laron naki kipm ike, pake tu enen pa kil lanaken ak yangkipm kla akalkilel kolti. ");
INSERT INTO urim_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Eng akentiwe mpa tu plelng ipma, atom ake Maur Wailen ungkwan paipmpaipm alntuwen pa. Kolpati tu antokg la mpa riri, pake ake tu ari kweiur. Tu ntokg la itning itning yangkipm, pake ake tu ariwe yiprokgen pa kalpis.” ");
INSERT INTO urim_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sisas kil lanaken la, “Ake kipm ariwe yangkipm kla a ak la wanukg erk pa pipa, yangkipm kla wrongkwail pa mpa kipm riwe la kolai? ");
INSERT INTO urim_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Melnum a laik wanukg erk pa, pa kil laik yangkipm a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wanukg erk a angko rmpa ya pa kol tu wrong kin kipman a atning yangkipm a Maur Wailen. Ake ampenet, Maur Paipm Satan kil kul kolti, ungkwan yangkipm a Maur Wailen a laik rpma ipma a tu melnum pa. ");
INSERT INTO urim_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Melnum tiur pa kol wanukg erk a angko rmpa kanokg kangirngket. Tu atning yangkipm pa, tu awi penterngen kolti, tu atopen eng yangkipm pa. ");
INSERT INTO urim_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tu pa ningnakg kalpisen. Tu rpma waiketn kolti. Ak wang a kalkuten ur palngten aki tu tiur alken nikgwalpm kalkuten eng la ampake tu itning yangkipm a Maur Wailen pa, atatu kolti tu uk yirokg yangkipm a Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tu wrong kin kipman tiur pa kol wanukg erk a angko rmpa ampei iket kuin. Tu melnum pa atning yangkipm pa ari, ");
INSERT INTO urim_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tu ipma kalkuten eng kweikwei watipmen a itna kanokg ti, a tu aringkowe marpm watipmen a kweikwei wrongkwail, a tu katnun ipma wasrongen alntu a wrekg la ntokg kuina ur. Kweikwei pa ak yapo yapo yangkipm a Maur Wailen, kolpa atom ake wa anip kaino palng ariwor. ");
INSERT INTO urim_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tu wrong kin kipman tiur pa kol wanukg erk a angko rmpa kanokg wor. Tu atning yangkipm pa katnun, atom tu pa anip kaino palng ariwor: tiur pa anip kaino wailet, a tiur pa anip kaino wailet paipm, a tiur pa wa klangkil.” ");
INSERT INTO urim_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sisas kil lanaken la, “Wakg pa kipm aye or la ik kuntuk mipmapm pa ik aur aki elng rpmi kawor wrik watneikgen pake? Kolpa kalpis. ");
INSERT INTO urim_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Am kolpake, kweikwei wrongkwail a itna ampen, kutnukg ikga palng kul kai ngko wunong. Kweikwei wrongkwail a ak aur pa, ikga uwi iye kai rmpi wunong. ");
INSERT INTO urim_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Melnum a nungkulkg atne pa, kil itning yangkipm pa riworwor.” ");
INSERT INTO urim_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Wa kil wa lanaken la, “Yangkipm a kipm atning pa, kipm kirpo lupmen riworwor! Kipm a aye kaimung wusok la uwi ntiwe pa, Maur Wailen kil mpa lkepm ntiwe kol kaimung wusok pa. Kipm iye kaimung wail pa, Maur Wailen kil mpa lkepm ntiwe kol kaimung wail pa, wa klangkil. ");
INSERT INTO urim_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Eng ntei, melnum a awi watipmen pa, mpa Maur Wailen lkel ngko angen. Pake melnum a ake awi kweiur aken kweikwei tiur a pekg kil awi ai pa, pa kweikwei a pekg kil awi pa ikga kai plalng.” ");
INSERT INTO urim_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sisas kil la, “Maur Wailen itna wailen ikgalen nol nikgwalpm a melnum pa kol melnum ur a laik kweikwei ok kai wring. ");
INSERT INTO urim_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Akangklei mining pa melnum pa okg rmpa, ak takgni pa kil wrekg atn. Kweikwei ok a anip wrekg wail pa, melnum pa mpa kil riwe la kolai? Kil ake mpa riwe. ");
INSERT INTO urim_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kanokg alkil pa antokg atom kweikwei ok pa wrekg anip, ipm atne, kai kaino wail, ok arke, tukgun. ");
INSERT INTO urim_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kweikwei pa tukgun pa, pa wang a angket tuwai tike. Kolpa atom melnum pa la tu awi telpmirik pa kai ak wangket kweikwei pa.” ");
INSERT INTO urim_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sisas kil la, “Kuina a i kolen a Maur Wailen itna wailen ikgalen nol nikgwalpm a melnum pa? Aki yangkipm kla a i mpa mentepm ik la a Maur Wailen itna wailen ikgalen nol nikgwalpm a melnum pa? ");
INSERT INTO urim_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Pa kol trumpwilm ipopm ok a wripm almpen kai tatu palpa. Ok pa pati waiketnketn, ");
INSERT INTO urim_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","pake kil wrekg kaino wail angen yo wrongkwail, alm wamtalpuk atne kai pa kai pa, antiwe tu wel kai ik ila rke.” ");
INSERT INTO urim_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sisas kil awi yangkipm kla watipmen kolpa eng ak la yangkipm a Maur Wailen pa naki tu wrongkwail kin kipman, antiwe kol nikgwalpm alntuwen. ");
INSERT INTO urim_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yangkipm ok wrongkwail pa kil lanaken ak yangkipm kla kolti. Tu watnom alkilen a kil aroaro wonel pa rpma nampokgentel kai wrik kalpmet pa atom kil laron yiprokgen a yangkipm kla pa naken ariworwor. ");
INSERT INTO urim_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ak nungkurikg pa, Sisas kil lanaki tu watnom alkilen a kil aroaro wonel pa la kolpa la, “Mentepm kai ukupuk wompel ai!” ");
INSERT INTO urim_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tu atnurng wrong kin kipman wailet pa, tu kaino rpma nim ukupuken a Sisas arpme pa, anel awiye la kai ukupuk wompel ai. Tu tiur awi nim ukupuken pa kai katnunten. ");
INSERT INTO urim_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tu awi nim ukupuken pa kai, ari mringkwripm wail pa el. Ukupuk pa tapor elng kawor nim u kopen pa, kolpa atom u eng a kai kawor pik kawor nim ukupuken pa. ");
INSERT INTO urim_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sisas kil rpma kinar nim ukupuken kulu pa kil alilng yo timpam pa, kil okg. Tu arowel ikgyokg atom tu la, “Ai, melnum a aroaro wonel men, mentepm a kai paipm ti, ake kitn akwonalmpen?” ");
INSERT INTO urim_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sisas kil pirpakg, kil wrekg, kil akle wripm pa, a la u pa, “Apake! Kitn plalng o!” Atom wripm pa tork, ukupuk pa terngkirka. ");
INSERT INTO urim_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Sisas kil lanaken, “Kipm ngkark kolpa eng ntei? Ati, ake wa kipm ukipma?” ");
INSERT INTO urim_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tu wrekg ngkark paipm, atom tu la itna kuin a tu alntu pa la, “Melnum pa ntei, atom u a wripm pa atning ok a kil pa!” ");
INSERT INTO urim_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tu arpme nim ukupuken pa kai palng kai ukupuk wompel a tu Kerasa. ");
INSERT INTO urim_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Sisas kil atnurng nim ukupuken pa, atom melnum ur a maur paipm kimpilpet arpmewel pa kil kul eng Sisas. Melnum pa atn rpma tatu kirkap. ");
INSERT INTO urim_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kil okg rmpa tatu kirk a tu u mlaminel a tu alil melnum armpewe pa akalkil. Melnum ur ake antiwe mpa rkul yipo kil pa, kalpis. Tu wa ak ampei mringen kalnten pa ak yapo ari ake wa antiwe. ");
INSERT INTO urim_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Anti watipmen pekg tu yapo nepmwampel ak ampei mpangen, a ampei mringen pa, ari akentiwe. Ampei mpangen pa kil kangku, a ampei mringen pa kil karkur karkur kaingkai kai kitnangku. Melnum ur ake antiwe mpa rkul ngkeng kil pa kalpis. ");
INSERT INTO urim_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Akangklei akangklei mining a ran pa kil am rpma tatu wrik nangen, a kirkap a pake. Kil akangklei akangklei kirkar akg raingen numpwam alkil ela wes. ");
INSERT INTO urim_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kil ari Sisas kai watin ai, kil pirng kul kapor kilko aleinsel. ");
INSERT INTO urim_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Atom Sisas kil nakel la, “Maur paipm kimpilpet, kitn or tukulelkg melnum pa kai o!” Melnum pa kil kirkar ak ok wail paipm, atom kil la, “Sisas, kitn warim a Maur Wailen a itna ep eng kweikwei wrongkwail. Kitn la ntokg na kupm ti? Tukulelkgtopm! Kitn la iklale kaino kwa, eng ampur kitn alkopm wleket.” ");
INSERT INTO urim_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Atom Sisas kil asen maur paipm kimpilpet pa la, “Nang a kitn ti mla?” Kil akalmpe la, “Nang akupmen Wrong Watipmen, eng men pa maur paipm watipmen.” ");
INSERT INTO urim_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kil ak asen unsa unsa kai Sisas pa la, ampake kil ungkwanten tukulelkgen anong kanokg pa. ");
INSERT INTO urim_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Manto wailet al okipma itna kaino wrik nangen wompel ai. ");
INSERT INTO urim_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tu maur paipm kirkar akwen Sisas titnongket la, “Kitn la eng men a kawor nowe tu manto ai!” ");
INSERT INTO urim_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Sisas kil awi wor, atom tu maur paipm atnurng melnum pa, a or kai kawor nowe tu manto ti. Atom tu manto wailet paipm kamel kamel wampwomis (2,000) pa anel raras angkaino krongkwang ai kul nar aren kinar kinar ukupuk ai, al u amo amo plalng ike. ");
INSERT INTO urim_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tu melnum a ikgalen manto pa ngkark. Tu aye yangkipm pa kai anong wail, wa kai anong yela tatu palpa. Atom tu wrong kin kipman kai ari kweikwei a wet palng pa. ");
INSERT INTO urim_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tu kai palng ari Sisas pa, tu ari melnum a wet maur paipm watipmen arpmewel pa. Kil aning apm, nikgwalpm a kil pa palng wontrakole wor, atom kil rpma meen. Tu wrong kin kipman ari pa, tu ngkark. ");
INSERT INTO urim_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tu melnum a wet itna ari pa, tu lakati kweikwei a wet palng kai melnum pa a wet maur paipm arpmewel pa, a wa palng kai tu manto pa yat. ");
INSERT INTO urim_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Atom tu wrong kin kipman la titnongket eng Sisas, la kil utnurng anong pa kai anong ur ai. ");
INSERT INTO urim_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Atom Sisas kawor nim ukupuken pa. Wa melnum a wet maur paipm arpmewel pa kil asen Sisas pa la kolpa la, “Antiwe mpa kupm ntiweitn kai?” ");
INSERT INTO urim_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pake Sisas ake awi wor la mpa kil ntiwel kai pa. Atom kil la, “Kitn kai rpmi nimpokgen tu alkitnen pa niken ipma arein a Maur Wailen wet angklinseitn, a kweikwei wrongkwail a wet kil akteitn pa!” ");
INSERT INTO urim_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Atom melnum pa kai anong a tu Tekapolis, laron yangkipm kweikwei a wuten Sisas kil aktel pa. Tu kin kipman wrongkwail tu atning pa, atom tu akwonalmpen watipmen. ");
INSERT INTO urim_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Atom Sisas kil awi nim ukupuken pa wa yaper kul ukupuk wompel ti. Tu wrong kin kipman wailet paipm tu kul ariwel ak wang a kil wli palng kai itna ukupuk yamping pa. ");
INSERT INTO urim_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Melnum tukgunakg ur a ikgalen wan a tu Suta atning atning yangkipm a Maur Wailen atnewe pa kil kul. Nang a kil pa Sairus. Kil ari Sisas, atom kil kapor kilko alein wreren nepm a Sisas. ");
INSERT INTO urim_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Kil la ak ok a ikgakgel lanaki Sisas kolpa, “Warim kin wusok yek akupmen wreren eng a imo. Kitn kul elng wam elewel, eng mpa kil wor rpmi, eng ake mpa kil imo.” ");
INSERT INTO urim_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Atom Sisas kil antiwel kai. Atom tu kin kipman wrongkwail tu katnuntel. Tu aktalpul tita aye kolpa kai wrerentel. ");
INSERT INTO urim_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kin wris ur pa kil anti tu wrongkwail itna, kil akapore perper, am rpma kolpa rpma kol wring wampwam yikak wekg. ");
INSERT INTO urim_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tu melnum a antokg i numpet pa alkel wleket watipmen paipm, atom kin pa angkli marpm alkil plalng eng tu pa. Pake numpet alkil pa ake kai wor ur, kalpis, am paipm kolpa itna pake. ");
INSERT INTO urim_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kin pa atning yangkipm a tu la Sisas kil antokg numpet a tu melnum palng wor, kolpa atom kil ak angkom angkom tu wrong wailet a yirokg a Sisas kul wamanti apm akilen. ");
INSERT INTO urim_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kil akwonalmpen la, “Kol mpa kupm waminti apm a kil pa, mpa kupm palng wor.” ");
INSERT INTO urim_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Penterngen kolti, num walmpopm a kil pa am plalng ike. Kil almpen almpen numpwam kil pa ari, numpet kil pa am plalng ike. ");
INSERT INTO urim_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Penterngen kolti Sisas kil ariwe la, titnongket ur am atnurngkel kai ike. Kil plelng ari tu kin kipman wrongkwail ti, atom kil la, “Mla wuten wamanti apm akupmen ti?” ");
INSERT INTO urim_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Atom wa tu watnom a kil aroaro wonel pa lanakel la, “Ti ake kitn ari tu wrong kin kipman wailet itna kapringenteitn itna ti aki, atom wa kitn wa asen la, mla wamantiweitn ai?” ");
INSERT INTO urim_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sisas kil ikgen yela la mla wet wamantiwel pa. ");
INSERT INTO urim_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kin pa ariwe kweikwei a wet palngtel pa, atom kil ngkark warwar. Atom kil kul wreren kapor kilko alein Sisas, a kil laron la, “Wuten kupm antokg.” ");
INSERT INTO urim_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Atom Sisas kil lanakel la, “Warim kin, nikgwalpm wor akitnen a kitn ukipma pa antokgteitn kitn palng wor. Kupm alkeitn wor, kitn kai rpmi meen, numpet a kitn pa am plalng ike.” ");
INSERT INTO urim_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sisas kil anti kin pa la okyangkipm pa itna, atom tu melnum tiur angkai wan a Sairus, melnum tukgunakg a ikgalen wan a tu atning atning yangkipm a Maur Wailen atnewe pa, kul la, “Ngkeng Sisas pa, ampur kil kul, warim kin akitn pa am amo ike.” ");
INSERT INTO urim_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ari Sisas kil ake atning yangkipm a tu angkengkel pa kalpis. Kil lanaki Sairus la, “Ampur kitn ipma kalkuten, ukipma kolti!” ");
INSERT INTO urim_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Sisas kil karken la ake mpa wrong ur ntiwel kai. Mpa Pita, Son, wusok alkilen Semis. ");
INSERT INTO urim_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ak wang a tu kul wan a Sairus pa, Sisas kil atning tu antokg nungkulkg titno wail paipm, tu akg paipm ak ok namputen. ");
INSERT INTO urim_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ak wang a kil kawor wan pa kil lanaken la, “Kipm akg antokg nungkulkg titno paipm eng ntei? Warim ake amo, palpa okg kolti.” ");
INSERT INTO urim_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tu akinoalmpel paipm kolti. Ari kil ungkwanten kawor en plalng. Kil awi mansan a warim pa nampokgen tunteng melnum wraur pa antiwel, kai kawor wrik a warim yipmiri armpe pa. ");
INSERT INTO urim_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kil wamanti kai wam pa, kil la, “Talita kumi!”, pa pati kil ak ok alkilen la kolpa la, “Warim kin wasek, kupm lala, kitn wrekg o!” ");
INSERT INTO urim_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Pilpa, warim kin pa wrekg angkom atatu kolti. Warim kin pa kin tangkis, wring alkilen pa wampwam yikakwompwekg. Tu ari pa, tu wrekg paipm. ");
INSERT INTO urim_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sisas kil la yangkipm titnongket pa naken la, “Akentiwe mpa kipm laniki mla ur eng kuina ur a kupm antokg kil. Ti kipm uk okipma warim kin pa il o!” ");
INSERT INTO urim_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sisas atnurng Kaperneam pa nar kul anong yiprokg alkilen, wa tu watnom a kil aroaro wonel pa kul katnuntel. ");
INSERT INTO urim_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ak wang wail a rpma eng yapm pa Sisas kil kawor wan a men Suta atning atning yangkipm a Maur Wailen atnewe pa. Kil kaling plan yangkipm a Maur Wailen pa naki tu wrong kin kipman. Tu wrongkwail rka atning yangkipm akilen pa, tu wrekg paipm la, “Melnum pa kil awi titnongket a ariwe pa kai a i, atom kil ak antokg kweikwei titnongket titnongket a melnum ake antiwe antokg pa? ");
INSERT INTO urim_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Palpa kil melnum a ale ale wan kolti. Kil warim a Maria, wailen a Semis, Sosep, Sutas, Saimon. Tu muikgmayen alkil pa antiwo rka yat.” Tu la kolpa, tu nikgwalpm paipm eng kil pa. ");
INSERT INTO urim_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Sisas lanaken la, “Tu anong manet ai tu lala kil nang arke melnum ok wripm a Maur Wailen, pake tu anong yiprokg a tu walmpopm wris a tu wan wris alkil pa tu elukgentel.” ");
INSERT INTO urim_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kolpa atom kil ake antiwe mpa ntokg kweikwei ak plan titnongket a Maur Wailen pa itni anong pa. Kil elng wam ele tu melnum numpet tiur kolti, atom tu palng wor. ");
INSERT INTO urim_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kil akwonalmpen watipmen eng ake tu ukipma kil pa. Atom kil atnurng anong yiprokg alkil pa a kil atn tatu anong a ela wreren anong a kil pa laron yangkipm a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sisas kil akwe tu watnom wampwam yikak wekg a kil aroaro wonel pa kul. Kil ukwawen la tu kai itn wekg wekg. Kil alken titnongket wail la tu ik ungkwan tu maur paipm kimpilpet. ");
INSERT INTO urim_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Atom kil lanaken la tu ngkompwam kolti. Ampake tu iye apmkok pa eng lupme okipma, marpm, kweikwei pa iye, kalpis. Mpa tu iye yotuk pa ik itnen kolti. ");
INSERT INTO urim_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nepm palk pa tu nowe o, apm pa pati ampur tu aye ur nampikgen. ");
INSERT INTO urim_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wa kil lanaken la, “Kipm la kawor wan ur pa, kipm rki pa i i, kipm utnurng anong pa kai. ");
INSERT INTO urim_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kol anong ur ake tu awi wor eng kipm pa, wa ake tu atning yangkipm a kipm pa, kipm kulkwin yipur pa itni pa, a kipm utnurng anong pa kai. Kol pa eng mpa kipm utnurng kalkuten pa kai rki tu alntu.” ");
INSERT INTO urim_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Atom tu watnom alkil pa tu kai, atom tu angkli yangkipm naken la, “Kipm plelng ipma!” ");
INSERT INTO urim_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tu ungkwan maur paipm watipmen a rpma kawor tu melnum, tu ak uyiwa akanel tu melnum a numpet atom tu palng wor. ");
INSERT INTO urim_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Atom nang a Sisas am palng wail ike. Melnum tukgunakg Erot kil atning kweikwei wrongkwail a Sisas antokg. Tu tiur pa la kai Sisas pa la, kil Son a kaluk tu. Kil wrekg a kirk, kolpa atom kil antiwe titnongket a kil ak ak kwap pa. ");
INSERT INTO urim_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tu tiur pa la, kil Elaisa, melnum ok wripm a Maur Wailen. Tu tiur pa la, kil kol tu melnum ok wripm tiur a pekg ep. ");
INSERT INTO urim_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Erot kil atning pa, atom kil akwonalmpen la, Sisas pa Son a kaluk tu, atom kil la, “Son pekg kupm la tu angket mengkel pa am wa wrekg ike.” ");
INSERT INTO urim_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Pekg Erot la tu kai arkul yapo Son aye kawor rpma wan tipmining. Erot kil antokg kolpa eng Erotias, kin a wusok alkilen Pilip a kil karpo atnwampel. ");
INSERT INTO urim_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Pekg Son lanaki Erot la, “Ake wor eng kitn aye kin a wusok alkitn pa.” ");
INSERT INTO urim_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kolpa atom Erotias nikgwalpm wakget paipm eng Son, kil la ilmpel imo. Pake kil ake antiwe mpa ntokg. ");
INSERT INTO urim_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Eng ntei, Erot kil ngkark eng Son. Kil ariwe la Son pa melnum ute wor a Maur Wailen amprin eng kil alkil, kolpa atom kil ikgalentel. Kil atning yangkipm a Son pa wor, kil wasrongen paipm eng la itning yangkipm akilen, pake nikgwalpm a kil pa wa ngkark. ");
INSERT INTO urim_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Erotias kil ansil ya wor ur eng la ikilmpe nikgwalpm wakget akil kai eng Son ak wang a Erot kil antokg okipma wail eng al akwonalmpen wang a pekg man rakuwel. Atom kil akwe tu mring man wail wail alkil, nampokgen tu melnum tukgunakg a almpwrong, nampokgen tu melnum wail wail a nang arke a anong kanokg Kalili pa wli eng al okipma. ");
INSERT INTO urim_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Warim kin a Erotias kil or plelplel. Erot nampokgen tu melnum a antiwel al okipma, tu ari plelplel akil pa ari wor. Atom Herot melnum tukgunakg pa asen kin warimpen pa la, “Kitn a uwi kuina? Kitn wasrongen kuina mpa kupm lkeitn.” ");
INSERT INTO urim_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Erot kil la aklale wrisen kaino kwa eng aktitnongketel yangkipm alkilen la, “Kitn isentopm kweiur a kitn wasrongen pa, mpa kupm lkeitn. Kol kitn la kupm iro anong kanokg a kupm ikgalen ti, lkeitn wompel, kupm iye wompel, pa kupm antiwe.” ");
INSERT INTO urim_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kin warimpen pa am kawor en kai lanaki man alkil pa la, “Mpa kupm la na eng mpa kil lkopm?” Man pa la, “La nikel la kitn uwi tukgunakg a Son a kaluk tu.” ");
INSERT INTO urim_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kin warimpen pa atatu kolti kawor naki Erot melnum tukgunakg pa la, “Kupm wasrongen tukgunakg a Son, melnum a kaluk tu, kitn elngkirmpi kai kimpang ti lkopm pinterngen!” ");
INSERT INTO urim_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kil la kolpa, ti nikgwalpm a Erot pa kalkut paipm. Pake kil akwonalmpen a wet kil la aklale wrisen kaino kwa ike, itna wulmpa a tu melnum a antiwel rpma al okipma. Kolpa ti akentiwe mpa kil tulpulng ok a kin warimpen pa. ");
INSERT INTO urim_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Atatu kolti Erot la melnum ur a almpwrong pa la kai ngket mengkel Son pa atom uwi tukgunakg pa iye kul. Melnum a almpwrong pa kai wan tipmining, wangket mengkel Son. ");
INSERT INTO urim_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kil elng tukgunakg a Son pa elng rmpa kimpang ur pa aye kul, uk kin warimpen pa. Kin warimpen pa awi aye kai uk man alkil pa. ");
INSERT INTO urim_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tu watnom a Son pekg aroaro wonel tu atning yangkipm pa, atom tu kul ngkat yipmiri a Son pa aye kai uwen kai kirkap ai. ");
INSERT INTO urim_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tu melnum a pekg Sisas ukwawen kai ak kwap tatu anong pa, tu yaper kul eng Sisas, lakati nakel kwap kweikwei a pekg tu ak pa. ");
INSERT INTO urim_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tu wrong watipmen paipm tu kaingkul eng ari Sisas, atom tu wang kalpisen eng al okipma. Kolpa atom kil lanaken la, “Kul eng mentepm almentepm kolti kai rki kai wrik kalpmet ur ai, rki eng yapm pen!” ");
INSERT INTO urim_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Atom tu alntu kolti kai awi nim ukupuken pa am kai wrik kalpmet ur pa. ");
INSERT INTO urim_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ari tu wrongkwail ariwe yat ike, la tu mpa kai wrik pake, kolpa atom tu wrongkwail a anong tatu palpa, tu pirng ep angklin ya arkenten rka. ");
INSERT INTO urim_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sisas aye nim ukupuken pa kai rka u yamping, kil ari wrong watipmen paipm ai. Tu pa kol manto walkg malkgu a ake melnum ur ikgalenten, kolpa atom kil areinsen paipm. Kil lanaken yangkipm ok watipmen a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Takgni kinar plalng, eng a nungkurikg tike. Atom tu melnum a ak kwap nampokgen Sisas, tu kai eng Sisas, lanakel lala, “Mentepm rka wrik mis, takgni am kinar eng a mining tike. ");
INSERT INTO urim_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ti laniken tu kai anong wail a anong wusok tutu palpa, ikor rmpen okipma ur alntu pa eng mpa tu il.” ");
INSERT INTO urim_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ari Sisas akalmpe la, “Kipm alkipm ti lken okipma eng tu il tike!” Atom tu lanakel la, “Mpa men uwi marpm wail kai a i eng ikirmpen okipma eng uk tu wrong kin kipman wailet pa il?” ");
INSERT INTO urim_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sisas asenten la, “Kipm aye nok tingklak ur aki kalpis? Kipm kai ikor ri!” Atom tu asen akor tu alntu pa atom tu ansil, atom tu la, “Nok tingklak wampwomis, yul wekg.” ");
INSERT INTO urim_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sisas kil lanaken la, “Kipm niken eng tu rpmi mapming mapming tutu mi pa rki!” ");
INSERT INTO urim_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tu tiur pa rpma kol kamel wampwomis a tu tiur pa kamel wekg tuwek wampwam. ");
INSERT INTO urim_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kil awi nok tingklak wampwomis a yul wekg pa, kil ikg kaino kitnong pa, a kil uk wor Maur Wailen, plalng pa, kil kapor nok tingklak pa uk tu watnom alkil pa, eng mpa mpreing eng tu wrong kin kipman pa il. Wa yul wekg pa yat kil ampreing uk tu aknirake tu plalngten. ");
INSERT INTO urim_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tu al nikgwor. ");
INSERT INTO urim_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Okipma umpu umpu tiur pa itna. Atom tu watnom a Sisas pa tu awi, ninan, alupm kai nimong pa, wa palng wampwam yikak wekg. ");
INSERT INTO urim_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tu wrong a wuten al okipma pa tu wrong wailet paipm kamel kamel (5,000), ake tu angkleikg kin a watnom pa kalpis. ");
INSERT INTO urim_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tu al plalng pipa, Sisas almayel tu watnom alkil a kil aroaro wonel pa, aktatu kolti, la tu kaino rpmi nim ukupuken pa eptel kai ukupuk wompel a Petsaita. Eng kil la tu wrong kin kipman wailet pa kai rak. ");
INSERT INTO urim_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tu rak kai plalng, kil kaino tipmning, la ok yangkipm nampokgen yan alkilen. ");
INSERT INTO urim_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wreren eng a ari kamel wukg wekg ti pa, nim ukupuken pa am kai angko kai ukupuk kuin ike. Sisas alkil wris pa itna kai ai a wai. ");
INSERT INTO urim_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Atom kil ari wripm titnongket pa el a won a tu pa kul, atom tu aken kwap wail paipm eng angket u pa kai. Wreren eng a ukwe, Sisas kil angkom or u kwa pa kainten, pake kil a ikopor tu pa ep kai. ");
INSERT INTO urim_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tu ariwel, atom tu akwonalmpen la, pa mring maur, kolpa atom tu ngkark, tu kirkar paipm. ");
INSERT INTO urim_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tu plalngten ariwel, la mring maur atom tu ngkark paipm. Penterngen kolti Sisas lanaken kolpa la, “Kil kupm kilke, ampur kipm ngkark! Kipm rpmi titnongket!” ");
INSERT INTO urim_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kil kai kawor nim ukupuken pa antiwen rpma. Atom wripm pa kai tork. Tu wrekg paipm, nikgwalpm a tu pa no ros kolti. ");
INSERT INTO urim_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Eng ake tu akwonalmpen okipma a wuten Sisas ampreing eng tu wrong kin kipman al pa kalpis. Ipmanikg a tu pa ake umpen. ");
INSERT INTO urim_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tu awi nim ukupuken pa angket ukupuk pa kai palng kai wompel a anong kanokg Kenesaret ai, atom tu angkuten nim ukupuken pa rka pa. ");
INSERT INTO urim_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tu atnurng nim ukupuken pa, penterng kolti tu am ariwel yat ike, tu la Sisas ampake. ");
INSERT INTO urim_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tu pirng aye yangkipm pa kai tatu palpa, atom tu ngkat tu melnum numpet pa aye kai wrik ur a wuten tu atning la Sisas kil arpme pa. ");
INSERT INTO urim_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kil kai anong wail wail aki, anong wusok wusok aki, kil kai tatu palpa, tu elng tu melnum numpet elngkirmpa akapm kuin ur. Tu asen lala, “Ti, men elng wam itne apm umpu waiketn ur akitnen ti kolti!” Tu elng wam elng itna apm alkilen pa tu palng wor. ");
INSERT INTO urim_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tu melnum a aroaro wonel tu yangkipm a Moses pa nampokgen tu melnum tiur a arpmen yangkipm yiprokgen a Moses pa, tu angkaino anong wail Serusalem pa nar kul no rka nampokgen Sisas. ");
INSERT INTO urim_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tu ari tu watnom a Sisas aroaro wonel pa tu ake klak wam pa atom tu al okipma pa. Tu ngkaten wam kimpilpet alntuwen pa ak al okipma pa kolti. ");
INSERT INTO urim_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tu melnum a arpmen yangkipm yiprokgen a Moses, a men alpmen Suta pa, ake men klak wam pa, men akentiwe mpa il okipma pa kalpis. Pa angklonake a tu mamikgmamin mansan a men Suta am kolpake. ");
INSERT INTO urim_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Men katnun angklonake watipmen tiur a pekg men awi kai tu mamikgmamin mansan pa a la men angkai akapm a armpen okipma atnewe pa kul pa, kol ake men angkle wam u pa ak rka tita pa, pa men ake kukula pa. Wa men ake klak kuntuk kaimung kweikwei pa, men ake mpa il okipma pa. ");
INSERT INTO urim_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tu melnum a arpmen yangkipm yiprokgen a Moses nampokgen tu melnum a aroaro wonel tu yangkipm a Moses tu asen Sisas, “Antokg kolai atom tu watnom a kitn aroaro wonel pa ake katnun angklonake a tu mamikgmamin mansan ai? Ake tu klak wam kimpilp alntu ti atom tu ak al.” ");
INSERT INTO urim_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Sisas kil lanaken la, “Aisaia, melnum ok wripm pekg ep ak ai, kil la yangkipm ute aklale. Kil la yangkipm pa kul kunturng kipm ti yat. Kil pekg la kolpa, 'Kipm melnum a kansil, kipm ngkat nang akupmen ak num enen ti kolti. Ipmanikg akipmen pa itna watinet eng kupm. ");
INSERT INTO urim_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kipm kaling planten kweikwei angklonake a tu mamikgmamin mansan pa kipm lala, “Kil pa kweikwei a Maur Wailen am pake.” Pa kipm kapor kilko aleinsopm kalpmilel, kipm ale mining kolti.' ");
INSERT INTO urim_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aisaia kil pekg la yangkipm pa kul kunturng kipm ti. Kipm talpulng yangkipm a Maur Wailen. Kipm arkul titnongket kweikwei a mamikgmamin mansan plantepm itna kanokg a ti.” ");
INSERT INTO urim_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Wa Sisas wa lanaken kolpa kai la, “Kipm pa awi ariwe wor pake, atom kipm angkom nalokgen ok a Maur Wailen eng katnun kweikwei a mamikgmamin mansan alkipmen pake! ");
INSERT INTO urim_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Pekg Moses kil la, 'Kitn orngwatneikgen mansan alkitn!' Wa kil la, 'Melnum ur la paipmel mansan alkilen pa, mpa orel imo.' ");
INSERT INTO urim_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ari kol wa kipm melnum a arpmen yangkipm yiprokgen a Moses a kipm melnum a ikgalen wrkapm a Moses, kipm ti wa lala, 'Kol melnum ur a antiwe marpm a kweikwei a angklin mansan alkilen, pake kil lanaken la, “Kupm aknamput Maur Wailen ike. Ti akentiwe mpa kupm lkepm.”' ");
INSERT INTO urim_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Angklonake alkipmen pa titnongket paipm, la ampake melnum pa uwi kweikwei a wet kil aknamputen Maur Wailen pa ik ngklin mansan alkil pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nikgwalpm pa, nikgwalpm a kipm pekg awi a tu mamikgmamin mansan, atom kipm uk yirokg yangkipm a Maur Wailen. Kipm antokg kweikwei watipmen kolpa yat.” ");
INSERT INTO urim_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sisas kil wa akwen tu wrong wailet pa antiur, atom kil lanaken la, “Kipm wrongkwail, itning yangkipm ok akupmen kil, ikwonilmpen! ");
INSERT INTO urim_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kweikwei a en a melnum kai kawor wunen a melnum pa ake antokg melnum pa kimpilpet, kalpis. Kweikwei a wunen a melnum or kai en pa antokg melnum palng kimpilpet. ");
INSERT INTO urim_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Melnum a nungkulkg atnewe pa kil itning yangkipm pa riworwor!” ");
INSERT INTO urim_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Sisas kil atnurng tu wrong kin kipman wailet, a kil kai kawor wan. Atom tu watnom a kil aroaro wonel pa asentel eng yangkipm kla a wuten kil ak la pa. ");
INSERT INTO urim_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Wa kil lanaken la, “Kipm ti ake wa wontrakole? Ti kipm kol a riwe la, kweikwei wrongkwail a itna kawor en a melnum kawor wunen alkilen pa, pa ake antokg melnum palng kimpilpet. ");
INSERT INTO urim_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Eng ntei, kweikwei a kolpa ake antiwe mpa kawor nikgwalpm a melnum pa, kalpis. Pa kawor rpma ipmanikg a melnum pa kai aken pain kolti.” Yangkipm pa Sisas lanaken eng la okipma wrongkwail pa wor. ");
INSERT INTO urim_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kil wa la or pa kai la, “Kweikwei a rpma wunen a melnum kawor en pa, am antokg melnum palng kimpilpet pake. ");
INSERT INTO urim_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ipma paipm a kipm la ntokg, kweikwei numkropis a uk numpaipm kamel, ikgwam, a alm melnum amo pa, pa palng a nikgwalpm pake. ");
INSERT INTO urim_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Aringkowe, kweikwei paipm paipm auraur, kansil yangkipm ok, melkget, nikgwalpm wleket, la paipmel Maur Wailen, ngkat nang a kil alkil pa, a antokg nikgwalpm titno. ");
INSERT INTO urim_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Am kweikwei wrongkwail paipm pa rpma kawor wunen a melnum or en pa antokg melnum pa palng kimpilpet paipm.” ");
INSERT INTO urim_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sisas wrekg atnurng anong pa, a kil kai anong kanokg a anong wail Tair a Saiton. Atom kil kawor wan ur pa la kil a rpme. Kil karken la ake mpa mla ur riwel a kil kawor rpma wan pa. Pake ake antiwe mpa kil rpmi am pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kin ur pa atning yangkipm a la Sisas kil kul rpma. Kin pa warim kin alkil pa pati maur paipm kimpilpet arpmewel. Kin pa atatu kul kapor kilko alein wreren nepm a Sisas. ");
INSERT INTO urim_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kin pa pati kil a ak ok Krik. Pa ok ur alntuwen. A anong yiprokg alkil pa Ponisia a itna kai anong kanokg a Siria. Kil la unsa unsa la Sisas kil ungkwan maur paipm a rpma kai warim kin alkil pa kai tukulelkg. ");
INSERT INTO urim_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sisas kil akalmpe ak yangkipm kla kolpa, “Mentepm uk okipma tu warim tipen. Pa ake wor eng mentepm awi okipma a tu warim pa uk nimpa pa al.” Warim pa la tu a Suta, nimpa pa la tu a ake a Suta pa. ");
INSERT INTO urim_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ari kin pa akalmpe ok a Sisas pa kolpa la, “Wailen, kitn la aklale. Pake ipin ipran a tu warim al angko kinar kanokg pa, mpa tu nimpa pa il pake.” ");
INSERT INTO urim_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sisas kil lanakel la, “Yangkipm ok a wuten kitn la pa wor pake, ti kitn yaper kai o! Maur paipm am kai takwlelkgen warim kin a kitn pa ike.” ");
INSERT INTO urim_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kil atning pa atom kil yaper kai wan alkilen pa ari warim alkilen a okg rmpa wrik pa rmpa. Maur paipm am atnurngkel ike. ");
INSERT INTO urim_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sisas atnurng anong kanokg a anong wail Tair pa, a kai or anong wail Saiton, wa kil or pa kai anong kanokg Tekapolis pa wa kil wa or pa kai palng kai ukupuk Kalili. ");
INSERT INTO urim_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tu aye melnum ur a nungkulkg titnowen a ok mise, aye kul eng Sisas. Tu lanaki Sisas la kil elng wam elewel, oklala niki Maur Wailen eng ik ngklin melnum pa. ");
INSERT INTO urim_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Atom Sisas kil awiyel aye kai itna kai laikge, takwlelkgen wulmpa a tu wrong kin kipman pa. Sisas elng wamipis pa elngkawor nungkulkg a melnum pa. Kil ungkwa wlikg pa, elng wam itna ok milip alkil pa. ");
INSERT INTO urim_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sisas kil ikg kaino kitnong pa, kil arein la kolpa, “Epata”, pa ok a Sisas ak lala, “Wor o!” ");
INSERT INTO urim_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nungkulkg a melnum pa am palng wor ike. Ok milip a kalkut pa am palng kukula wor ike, kil ak la ok yangkipm ariworwor ike. ");
INSERT INTO urim_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Atom Sisas angkengken titnongket, eng ake mpa tu niki melnum ur eng kweikwei pa. Kil angkengken titnongket, pake akentiwe. Tu la kolpa aye kai naki tu wrongkwail. ");
INSERT INTO urim_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tu wrekg paipm wrisen atom tu la, “Kweikwei wrongkwail a kil antokg pa palng wor kolti. Kil antokg tu nungkulkg titnowen pa palng wor atning yangkipm ok, tu a ok mise pa palng wor la yangkipm ok.” ");
INSERT INTO urim_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ak wang pa tu wrong wailet wa anel wli rka anti ur. Tu okipma kalpisen, atom Sisas akwe tu watnom alkil a kil aroaro wonel pa kul, atom kil lanaken la, ");
INSERT INTO urim_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kupm arein tu wrong kin kipman pa, eng tu antiwopm rpma kol wang wraur ike, ti tu okipma kalpisen. ");
INSERT INTO urim_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kol tu rpmi ik nikg eng kupm la tu kai wan anong alntu pa, pa titnongket a tu mpa kai plalng ngko ya. Eng tu tiur pa angkai anong ya watinet ai wli.” ");
INSERT INTO urim_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tu watnom a kil aroaro wonel pa tu akalmpentel ok pa kolpa la, “Mentepm rka wrik mis, mpa mentepm uwi okipma pa kai a i eng uk tu wrong pa il?” ");
INSERT INTO urim_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kil asenten la, “Kipm nok tingklak aripm rmpa?” Tu akalmpe la, “Wampwomis wampwompwekg.” ");
INSERT INTO urim_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Atom kil lanaki tu wrong kin kipman pa la, “Kipm rpmi kanokg ti!” Kil awi nok tingklak wampwomis wampwompwekg pa, uk wor Maur Wailen. Atom kil kapor uk tu watnom alkil pa, eng la tu mpreing uk tu wrong kin kipman. Atom tu antokg katila ok a Sisas kil la pa. ");
INSERT INTO urim_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tu aye yul waseksek tiur pa aye kul elngkirmpa. Atom Sisas kil awi yul pa uk wor Maur Wailen pa plalng, pa kil wa lanaki tu watnom alkil pa tu wa awi ampreing uk tu pa. ");
INSERT INTO urim_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tu al nikgwor plalng. Tu narein okipma umpu umpu tiur a itna pa, alupm kai nimong pa, palng kol nimong wampwomis wampwompwekg. ");
INSERT INTO urim_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tu wrong kin kipman a wet al nikgwor pa wailet paipm kamel kamel (4,000). Tu al plalng, Sisas kil lanaken la tu kai. ");
INSERT INTO urim_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Aktatu kolti kil kai kawor rpma nim ukupuken nampokgen tu watnom alkil pa, tu angket ukupuk pa kai anong kanokg a Talmanuta. ");
INSERT INTO urim_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tu melnum a arpmen yangkipm yiprokgen a pekg Maur Wailen uk Moses tu kul la nti Sisas ik yangkipm rapon. Tu la kil elng kla ur itni ik plan titnongket a Maur Wailen eng tu ri. Tu alm ipmawel kolti. ");
INSERT INTO urim_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sisas kil arkolng la, “Wi, antokg kolai eng kipm wrong kin kipman ak wang ti kipm la kupm elng kla ur elng itni ik plan titnongket a Maur Wailen eng kipm ri? Kupm lanakepm aklale wrisen: ake antiwe mpa kupm elng kla ur itni eng kipm a ak wang ti ri. Kalpis wrisen.” ");
INSERT INTO urim_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kil atnurngken, kil yaper kaino nim ukupuken pa anti tu watnom alkil a kil aroaro wonel pa, angket ukupuk pa la kai wompel ai. ");
INSERT INTO urim_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tu watnom a Sisas kil aroaro wonel pa tu woniketen, atom ake tu aye nok tingklak watipmen ur nakur num. Tu pa nok tingklak wris ata kolti rmpa nim ukupuken pa. ");
INSERT INTO urim_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sisas la yangkipm titnongket karkurng tu kolpa, “Kipm itn riwe ngkirk tukwleikgen nikgwalpm a Erot a nikgwalpm a tu melnum a arpmen yangkipm yiprokgen a Moses: tu pa kansil plan ak num enen ti kolti, pa kol mpim ap mringen a ak oren kai or arpme nok ti plalng, atom angki wail.” ");
INSERT INTO urim_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tu asen tu alntu ti la, “Mentepm ti nok tingklak kalpis, atom kil la kolpa, aki?” ");
INSERT INTO urim_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Sisas kil ariwe, tu asen tita eng nok tingklak pa, atom kil lanaken, “Kipm akor la nok tingklak pa kolpa, eng kipm ti nok tingklak kalpisen? Ai, kipm ti nikgwalpm kalpisen? Ipmanikg a kipm ti ake wontrakole! ");
INSERT INTO urim_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nungkulkg a wulmpa itnewepm pati kol a kipm itningkri pa. Ari ake kipm atning ari. ");
INSERT INTO urim_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ak wang a kupm kapor nok tingklak wampwomis eng tu wrong kin kipman wailet paipm kamel kamel (5,000) pa. Kipm alupm nok tingklak umpu umpu a angko itna pa kai nimong aripm?” Ari tu akalmpe kolpa la, “Men alupm kinar nimong pa wampwam yikak wekg.” ");
INSERT INTO urim_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Wa ak wang a kupm kapor nok tingklak wampwomis wampwompwekg pa eng tu wrong kin kipman wailet paipm kamel kamel (4,000) pa, kipm alupm nok tingklak umpu umpu a angko itna pa kai nimong aripm?” Ari tu akalmpe la, “Wampwomis wampwompwekg.” ");
INSERT INTO urim_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Atom kil asenten la, “Nikgwalpm a kipm ti titnowen apa?” ");
INSERT INTO urim_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tu palng kai anong Petsaita pa. Tu aye melnum wulmpa tilmpisen ur pa aye kul eng Sisas. Atom tu lanaki Sisas eng la kil elng wam ele melnum pa. ");
INSERT INTO urim_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Atom Sisas wamparpme wam a melnum a wulmpa tilmpisen pa. Kil ayewel kai laikge takwlelkgen anong pa. Kil ungkwa wlikg elng kai wulmpa a kil pa, kil elng wam elewel, a kil asentel la, “Kitn ak ari kweikwei ur aki kalpis?” ");
INSERT INTO urim_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Melnum pa kil ikatnen atom kil la, “Kupm ari melnum tiur pake ake kupm ari klalen pa kalpis, tu ari kolen yo a angkom pa.” ");
INSERT INTO urim_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Atom wa Sisas wa elng wam ele wulmpa a kil pa antiur. Melnum pa ikatnen titnongket, atom wulmpa a kil pa wor om, atom kil ari kweikwei wrongkwail pa palng klalen om. ");
INSERT INTO urim_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sisas lanaki melnum pa la, kil kai kawor rpmi wan alkilen. Ampur kil kai angko wunong kai anong pa. ");
INSERT INTO urim_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sisas wrekg nampokgen tu watnom alkil a kil aroaro wonel pa, tu kai tatu anong a anong kanokg Sisaria Pilipai. Kai angko ya pa kil asen tu watnom pa la kolpa la, “Tu wrong kin kipman ti mpa numput kupm ti la mla?” ");
INSERT INTO urim_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Atom tu lanakel la, “Tu tiur pa la kitn Son a kaluk tu. Tu tiur pa la kitn Elaisa. A tu tiur pa la kitn melnum ok wripm a Maur Wailen pa ur ai.” ");
INSERT INTO urim_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Sisas kil asenten la, “Kipm alkipm ti mpa kipm la kupm ti la kupm mla?” Pita akalmpe ok a kil pa kolpa la, “Kitn Krais, Maur Wailen kil ukwaweitn nar eng la ikirmpen men wrong kin kipman a itna kanokg a ti.” ");
INSERT INTO urim_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Sisas angkengken la ampake tu laron yiprokgen a nang alkil pa niki melnum ur pa kalpis. ");
INSERT INTO urim_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sisas kil kaling plan tu watnom alkil kolpa, “Warim Kipman a Melnum ikga rki wleket. Tu melnum wailen wailen a tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen a tu melnum a aroaro wonel tu yangkipm a Moses pa ikga tu uk yirokg kil pa, a tu ilmpel imo. Wang wraur pa kai plalng pa kil wrekg.” ");
INSERT INTO urim_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yangkipm ok pa Sisas kil laron kai palng klalen ariworwor eng tu. Atom Pita kil awi Sisas aye kai laikge eng aklewel eng yangkipm a kil alkil la kil ikga imo. ");
INSERT INTO urim_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ari Sisas kil plelng ari tu watnom a kil aroaro wonel pa, kil akle Pita pa kolpa la, “Satan, kitn kul kai yirokg akupmen! Kitn ake katnun nikgwalpm a Maur Wailen, kalpis. Kitn katnun nikgwalpm a melnum kolti.” ");
INSERT INTO urim_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Atom Sisas kil lanaki tu wrong pa kul antiwel rpma, nampokgen tu watnom a kil aroaro wonel pa, atom kil lanaken, “Kol melnum ur la kul kutnun kupm ti pa, kil mpa elngen a katnun nikgwalpm a kil alkil pa, a kil mpa rki yo okgmangki alkilen pa, atom kil kul kutnuntopm. ");
INSERT INTO urim_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kol melnum ur la ikglen num alkil ti pa, pa kil takote amen wor alkil pa ikga kai rpmi paipm yongkyong. Kol melnum ur wampor ngkli kil alkil ti itnen kupm ti a yangkipm wor akupmen pa, pa kil awi yaprekg watin eng rpmi wor ikngklei. ");
INSERT INTO urim_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kol melnum ur uwi kweikwei wrongkwail a itna kanokg ti, atom amen wor a kil pa ikga kai paipm. Melnum pa mpa wa kil ik marpm kolai ik rmpen amen wor alkil pa iye kul eng wor kolai? ");
INSERT INTO urim_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Melnum pa awi kweikwei wrongkwail a itna kanokg ti, akentiwe mpa kweikwei alkilen pa ikirmpen amen wor alkilen pa kalpis. ");
INSERT INTO urim_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ak wang ti a tu angkli arkul tita, a antokg paipmpaipm wailet pa, kol kipm num paipm eng laron kupm ti a yangkipm akupmen pa, pa ikga Warim Kipman a Melnum, kil ikga wa num paipm eng laron kipm pa, ikga ik wang a kil nar ik titnongket a nang wailen a Yan alkilen, a wa nimpokgen tu maur akwapel klalen alkilen pa.” ");
INSERT INTO urim_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sisas kil lanaken la, “Kupm lanakepm aklale wrisen: kipm tiur a itna ti pa, kipm ikga rki kolpa rki, kipm ri a Maur Wailen ikga itni wailen ikglen kweikwei wrongkwail nimpokgen titnongket. Kipm rki ri pa plalng pipa, kipm imo kaingkai.” ");
INSERT INTO urim_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wang wampwomis wampwompwris pa kai plalng pa, Sisas kil awi Pita, Semis a Son pa antiwel kaino rpma kaino wrik nangen ur pa. Atom tunteng rka ak tunteng alntunteng pa. Ak wang pa tunteng ari Sisas pa, numpalk a kil pa palng manet. ");
INSERT INTO urim_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Apm a kil pa palng tangkoren pupup muinmainet paipm ai, tu melnum alkil a klak klak apm itna kanokg ti pa ake antiwe mpa klak apm tangkoren ur palng rukis tangkoren pupup kolpa. ");
INSERT INTO urim_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Atom tunteng watnom a Sisas aroaro wonel pa, tunteng ari Elaisa a Moses palng la ok yangkipm nampokgen Sisas. ");
INSERT INTO urim_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Atom Pita lanaki Sisas, “Melnum a aroaro wonel men, mentepm rka ti pa wor! Mpa minto ngkam pilmpal pa wraur, ur eng kitn ur eng Moses, ur eng Elaisa.” ");
INSERT INTO urim_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tunteng ngkark paipm, atom ari Pita kil akwekgel yangkipm ok a wuten kil la pa. ");
INSERT INTO urim_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Waipmunu kul ak auren ak mrangkum alkilen. Ok a la angkaino waipmunu pa nar la, “Kil pa Warim Kipman akupmen, kupm plan ipma wor wasrongentel. Yangkipm a kil la pa kipm itning!” ");
INSERT INTO urim_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Penterngen kolti tunteng ikgen yela, ari ake tunteng ari melnum ur kalpis. Sisas wris ata kolti itna. ");
INSERT INTO urim_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tunteng atnurng tipmning pa nar pa, Sisas kil alken yangkipm pa la, “Ampur kipmteng lanaki melnum ur eng kweikwei a wuten kipmteng ari pa. Rpmi nikgwalpm alkipmtengen pa i i, Warim Kipman a Melnum pa kil wrekg i kirk a tu u mlaminel pa or plalng pipa, kipmteng laron.” ");
INSERT INTO urim_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yangkipm pa rpma tunteng altunteng ti kolti. Tunteng asen tita akor lala, “Kil wrekg i kirk pa no pa kil la kolai?” ");
INSERT INTO urim_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Atom tunteng asen Sisas eng yangkipm pa, “Antokg kolai eng tu melnum a aroaro wonel tu yangkipm a Moses pa la Elaisa ikga ep nar pa? Wa melnum a Maur Wailen ukwa pa ikga nar kutnukg?” ");
INSERT INTO urim_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Sisas kil akalmpe kolpa, “Pa aklale, Elaisa ikga nar ep eng ntokg kweikwei a paipm ikga palng wor. Pake kipm ikwonilmpen yangkipm ok a ela wrkapm a Maur Wailen pa. Kil la Warim Kipman a Melnum ikga rki kalkuten watipmen, ikga tu la paipmel kil pa. ");
INSERT INTO urim_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ari kil kupm lanakepm aklale: Elaisa am palng ike. Ti tu antokgtel paipm ak wasrongen alntu kolti, kolen wrkapm a Maur Wailen kil la.” ");
INSERT INTO urim_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sisas nampokgen watnom wraur a kil aroaro wonel pa atnurng wrik nangen pa nar pa, tunteng ari tu wrong wailet kapringen tu watnom wampwomis wampwompwikgwikg a Sisas aroaro wonel pa itna. Wa tu melnum a aroaro wonel tu yangkipm a Moses, tu anti tu ak yangkipm rapon alilakel tita itna. ");
INSERT INTO urim_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tu wrong kin kipman ari Sisas palng, atom tu wrekg paipm. Tu pirng aktatu kaintel, tu alkel wor. ");
INSERT INTO urim_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Sisas kil asenten la, “Kipm wet ak yangkipm rapon tita eng la kuina?” ");
INSERT INTO urim_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Melnum ur a itna kuin a tu pa akalmpe ok a Sisas pa la kolpa, “Kitn melnum a kaling plan men, warim kipman akupmen kil maur paipm ur ampri okel, ti kupm aye kul eng kitn. ");
INSERT INTO urim_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ak wang a maur paipm wrekg arpmewel pa, kil ngkrangkel elng kinar kanokg. Ipopm merk pilpil wli okel, pa ok itna tita, num pa titnongket itna tita plalng. Ti kupm la tu watnom a kitn aroaro wonel pa ungkwan maur paipm pa tukulelkgtel, ari tu ake antiwe.” ");
INSERT INTO urim_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Sisas kil lanaken la, “Antokg kolai kipm wrong kin kipman ak wang ti, ake kipm ukipma! Wang na tukwok pekg kupm antiwepm rpma ti rpma? Mining paipmtopm eng kipm pake. Kipm iyentopm warim kipman pa kul ri!” ");
INSERT INTO urim_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tu aye warim kipman pa kul eng Sisas. Maur paipm am ari Sisas ike. Atom laik ngkrang warim kipman pa paipm. Atom kil angko kinar kanokg pa tilntul raing raing kapring kapring, ipopm merk pa pilpil wli okel rmpa. ");
INSERT INTO urim_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sisas kil asen yan pa la kolpa la, “Ak wang na kil palng kolpa?” Ari kil akalmpe la, “Pekg ak a paipmen ai. ");
INSERT INTO urim_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Maur paipm am antokgtel kolngkolpake. Angkliwel elng kai wakg, a elng kinar u, la orel imo. Kol kitn ntiwe pipa, mpa kitn reinso a ngklinso!” ");
INSERT INTO urim_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Sisas kil lanakel la, “Ampur kitn la kupm akentiwe pa! Kol kitn ukipma pa Maur Wailen antiwe angklinseitn kweikwei wrongkwail pa.” ");
INSERT INTO urim_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ari yan a warim pa kirkar akwe la kolpa, “Kupm ukipma pake, kupm akentiwe. Mpa kitn ngklinsopm kol a wai!” ");
INSERT INTO urim_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Sisas kil ari tu wrong tiur wa atatu wli wli tipen, kolpa atom kil akle maur paipm kimpilpet pa la kolpa la, “Kitn maur paipm a ok mise a nungkulkg titnowen, kupm lanakeitn la, kitn kai tukulelkg warim pa! Ikgake kitn kawor rpmewel nti ur!” ");
INSERT INTO urim_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Maur paipm pa kirkar paipm, angkli warim kipman pa elng kinar nepm ai, plalng pipa, kil or ngkark kai. Ti warim pa num lpmaake rmpa, ari katiwen melnum yipmiri rmpa pa. Atom tu wrongkwail lala kil am amo ike. ");
INSERT INTO urim_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sisas kil wamparpme wam a warim kipman pa ayewel wrekg itna kwa pa. ");
INSERT INTO urim_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Sisas kil kawor wan pa atom, tu watnom a kil aroaro wonel pa asentel ampen la, “Antokg kolai, atom ake antiwe men ti ungkwan maur paipm pa kai takwlelkg?” ");
INSERT INTO urim_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Sisas kil akalmpe la, “Kweikwei wrongkwail pa ake antiwe. Akwen Maur Wailen wris ata pa antiwe mpa ungkwan maur paipm pa kai tukulelkg.” ");
INSERT INTO urim_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Sisas nampokgen tu watnom a kil aroaro wonel pa atnurng anong kanokg pa angkom kolpa yaper kul nar anong kanokg Kalili. Kil karken la ake mpa mla ur riwe wrik a kil kaiye pa. ");
INSERT INTO urim_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Eng ntei, kil a iro wonel tu watnom alkil eng yangkipm a Maur Wailen. Kil lanaken kolpa, “Warim Kipman a Melnum ikga elng kai wam a tu melnum, ikga ilmpel imo. Ikga wang wraur pa kai plalng pipa, kil wa wrekg.” ");
INSERT INTO urim_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ari ake tu atning kuina ur a kil la pa la kil la kolai. Tu wa ngkark la, mpa mla isen pa. ");
INSERT INTO urim_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tu angkom kolpa kul nar palng anong Kaperneam. Atom tu kai rka wan ur pa. Sisas kil asen tu melnum alkilen pa la, “Kipm wet alilakel tita kuina tatu ya pa?” ");
INSERT INTO urim_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mpa wa tu uwi yangkipm kai a i eng ikilmpe ok a Sisas pa. Eng ntei, tatu ya pa wuten tu anel alilakel tita la, mla a i mpa itni wailen. ");
INSERT INTO urim_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sisas angko rpma, atom kil lanaken la tu kul rki wris eng kil laniken yangkipm. Kil la, “Melnum mla ur kil a itni ep pa kil mpa kai itni kutnukg eng ngklin tu wrongkwail.” ");
INSERT INTO urim_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Atom kil awi warim ur pa aye kai elngkitna kuin a tu pa. Atom kil ngkat warim pa aye itna, atom kil lanaken la, ");
INSERT INTO urim_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","”Mla ur kil itopen uwi warim ur kolkil ikyakur iye kai wan atnen a kil ukipma kupm pa, pa kil atopen awi kupm ti akyakuropm aye kai wan. Wa mla ur itopen awi kupm ti pa, pa ake wa atopen awi kupm alkupm wris ti pa, pa wa kil atopen awi melnum a ukwawopm nar pa atom akyakurel aye kai wan.” ");
INSERT INTO urim_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Son kil lanaki Sisas kolpa, “Melnum a aroaro wonel men, men ari melnum ur naren kitn ti atom ak ungkwan maur paipm. Atom men angkengkel la kil elngen kwap pa, eng kil pa ake ak kwap nampokgen mentepm ti.” ");
INSERT INTO urim_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sisas kil lanaken la, “Ampur kipm angkengkel. Kol melnum ur naren kupm ti atom ntokg kweikwei ik plan titnongket a Maur Wailen pa, pa kil ikgake wa la paipmel kupm ti penterngen pa. ");
INSERT INTO urim_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Melnum a ake awi wrongmanto lan mentepm pa, pa kil melnum wor a mentepmen. ");
INSERT INTO urim_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kol melnum ur naren kupm Krais ti atom lkepm u il pa eng kipm pa akupmen pa, kupm lanakepm aklale la, ikga Maur Wailen kil ikilmpe nikgwalpm wor a melnum pa antokg eng kipm pa kutnukg.” ");
INSERT INTO urim_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Kol melnum ur ningkail warim ur a ukipma kupm pa kil ngko pa, kol a tu yipo wes wail ur ai rpmi mengkel melnum pa tulpul ngkli elng kinar unokg kuin ai pa pati wor pake. ");
INSERT INTO urim_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kol wam wompel alkitnen pa rkolngkeitn iye kai ngko eng ntokg paipmpaipm pa, wangket ngkli kai ai. Kitn ngkiten wam wompel wris pa iye itni kolti eng mpa kitn uwi yaprekg watin a Maur Wailen atom ikga kaino rpmi wor yongkyong kaino anong wor, pa kol a wor. Kol kitn iye wam wekgenen pa itni pa, ikga iyeweitn kinar anong paipm a wakg naruk itna yongkyong. ");
INSERT INTO urim_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Wilm a al melnum pa ikgake imo, a wakg pa ikgake ime, ikga itni ikngklei wang. ");
INSERT INTO urim_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kol nepm wompel alkitnen pa rkolngkeitn iye kai la kitn ntokg paipmpaipm pa, utnurng ya wor akupmen pa, pa wor eng kol a kitn wangket nepm wompel pa ngkli. Kitn ngkiten nepm wompel wris pa iye itni eng mpa kitn uwi yaprekg watin a Maur Wailen atom ikga kaino rpmi wor ikngklei wang kaino anong wor. Kol kitn iye nepm wekgenen pa itni pa, mpa tu ngkliweitn elng kai anong paipm. ");
INSERT INTO urim_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Wilm a al melnum pa ikga ake imo, a wakg pa ikga ake imo, ikga itni ikngklei wang. ");
INSERT INTO urim_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kol wulmpa wompel akitnen pa rkolngkeitn iye kai ngko eng ntokg paipmpaipm pa, pa kol a wor eng inen wulmpa wompel ur pa ngkli. Kitn iye wulmpa wompel wris ita pa itni eng mpa kitn elng Maur Wailen itni wailen ikglen nol nikgwalpm akitnen atom ikga kitn kaino anong wor alkilen. Kol wulmpa wekg akitnen pa itni pa, ikga tu ngkliweitn elng kinar anong paipm pa. ");
INSERT INTO urim_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Wilm a al melnum pa ikga ake imo, a wakg pa ikga ake imo, ikga itni ikngklei wang. ");
INSERT INTO urim_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kalkuten a palng kai kipm wris wris pa, kol wakg alepm eng kipm ikga palng kleset wor kol nokg. ");
INSERT INTO urim_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nokg pa wor pake, kol kleset a nokg pa kai kupuk pa, mpa kipm ntokg kolai eng nokg pa palng kleset nti ur pa? Nokg a itna num a kipm pa ampur kai plalng! Kolpa ti kipm rpmi riworwor, uk ipma wor eng tita!” ");
INSERT INTO urim_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sisas wrekg atnurng anong kanokg pa nar anong kanokg a Sutia, atom angket u kop Sotan pa kai wompel ai. Tu wrong wailet wa anel wli wli kapringentel antiur. Kil lanaken yangkipm a Maur Wailen kol a kil lala pa. ");
INSERT INTO urim_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tu tiur a tu melnum a arpmen yangkipm yiprokgen a Moses tu kul eng Sisas, tu la ilmpel nikgwalpm. Atom tu asentel la, “Kitn laniko, yangkipm titnongket amentepmen pa la kolai la mentepm ungkwan kin aki kalpis?” ");
INSERT INTO urim_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sisas kil akalmpe ok a tu pa kolpa la, “Yangkipm pekg Moses kil lanakepm kolai eng la kipm kutnun?” ");
INSERT INTO urim_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tu akalmpe kolpa la, “Moses awi wor eng tu la tu nira wrkapm wompel eng ik ngketen kin pa a ungkwan kin pa kai.” ");
INSERT INTO urim_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Sisas lanaken la, “Pekg tu antokg melkget kol pa atom Moses kil anti a kil nira wrkapm wompel pa eng ik ngketen kin pa. ");
INSERT INTO urim_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pekg ep pa Maur Wailen kil ake awi wor eng pa. Pekg ak wang ep pa Maur Wailen kil antokg kweikwei wrongkwail, kil antokg melnum kolen kin a kipman. ");
INSERT INTO urim_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kolpa atom kipman pa mpa utnurng mansan alkil pa kai rpmi wris nimpokgen kin alkilen pa, ");
INSERT INTO urim_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","mpa tuwekg palng kol num wris. Tuwekg ake wa itna kol melnum wekg, kalpis om. Tuwekg am palng kol num wris ike. ");
INSERT INTO urim_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kolpa ti ake antiwe mpa kipm ngketen kweikwei ur a Maur Wailen aye kai itna wris pa, kalpis om.” ");
INSERT INTO urim_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tu oklala plalng pa, Sisas a tu watnom a kil aroaro wonel pa yaper kawor rpma wan pa, tu watnom pa asen Sisas eng oklala wet kil la pa. ");
INSERT INTO urim_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kil akalmpe la kolkil, “Kol melnum ur ungkwan kin alkil pa atom uwi kin ur manet ai pa, kipman pa kil antokg paipm kai kin alkil eng angketen rpma alntuwekgen pa. ");
INSERT INTO urim_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Am kol pake, kol kin ur pa utnuurng kipman alkil atom uwi kipman manet ur ai pa, kin pa antokg paipm kai kipman alkil eng angketen rpma alntuwekgen pa.” ");
INSERT INTO urim_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tu aye warim tiur pa aye kul eng Sisas la kil elng wam elewen a oklala niki Maur Wailen eng ngklin tu pa, ari tu watnom a alkil pa aklewen. ");
INSERT INTO urim_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Sisas ari pa, kil nikgwalpm wakget eng tu watnom alkil pa, atom kil la kolpa la, “Elng tu pa kul eng kupm, ampur angkengken. Maur Wailen am ikgalen nol nikgwalpm a tu melnum a kolen tu warim yekyek tike. ");
INSERT INTO urim_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kupm lanakepm aklale, mla ur ake elng Maur Wailen pa itni wailen ikglen nol nikgwalpm akilen pa kol tu warim antokg pa, pa akentiwe mpa kil kawor yipmingki wunen a Maur Wailen pa, kalpis wrisen.” ");
INSERT INTO urim_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Atom Sisas kil ak wam ti aloken aye kul rpma kimang alkilen ti, a kil elng wam pa kai ele tu pa oklala naki Maur Wailen pa la kil plan ipma wor ngklin tu warim pa. ");
INSERT INTO urim_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sisas wrekg angkom kai pa, melnum ur pa pirng kai akoporel kai kapor kilko aleinsel a asentel la, “Melnum wor a aroaro wonelo, mpa kupm ntokg kolai eng uwi yaprekg watin atom ikga kupm rpmi wor ikngklei wang pa?” ");
INSERT INTO urim_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sisas kil akalmpewel la, “Kitn la kupm ti melnum wor kolai? Ake melnum ur wor kol Maur Wailen kil alkil ai. ");
INSERT INTO urim_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yangkipm titnongket kil pekg Maur Wailen alkepm la kipm kutnun pa, kitn am ariwe ike, la: ampur alm melnum amo, ampur angkli arkul tita, ampur ak ikgwam, ampur kansil lakati melnum ur, ampur kansil yangkipm eng awi kweikwei a melnum ur kalpmilel, orngwatneikgen mansan.” ");
INSERT INTO urim_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ari melnum pa la, “Melnum a kaling planto, pekg ak a kupm warimpen ai kulngkul kul wang ti pa, kupm atning katnun yangkipm titnongket a kitn la pa.” ");
INSERT INTO urim_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sisas kil ariwel kolpa, kil plan ipma wor wasrongentel, kil la, “Kitn tukwok eng kweiur wris ur a pa. Kitn kai la eng tu rmpenteitn apm nung kweikwei alkitn pa plalng pipa, mpreing uk tu melnum a rpma tukwok pa. Atom kitn kul kutnuntopm! Ikga kitn ntiwe kweikwei watipmen kaino kitnong ai.” ");
INSERT INTO urim_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Melnum pa atning yangkipm pa kolti, kil mining paipmen num, ipma a kil pa kalkut paipm kolti, am kai ike. Eng ntei, kil antiwe kweikwei watipmen. ");
INSERT INTO urim_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sisas kil ari tu watnom alkil pa la, “Melnum a antiwe kweikwei watipmen pa wonet paipm eng kil elng Maur Wailen kawor itna wailen ikgalen nol nikgwalpm akilen pa.” ");
INSERT INTO urim_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tu watnom alkil pa tu wrekg paipm eng yangkipm a kil la pa. Atom Sisas kil wa lanaken la, “Kipm warim alkupmen. Melnum la elng Maur Wailen kawor itni wailen ikglen nol nikgwalpm akilen pa wonet paipm. ");
INSERT INTO urim_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kol ling pa la or tawong a ikyom a ak angkut apm pa kawor pa, ake aken kwap kol melnum a antiwe kweikwei watipmen la elng Maur Wailen kawor itni wailen ikglen nol nikgwalpm akilen, pa aken kwap paipm.” ");
INSERT INTO urim_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tu watnom alkilen pa tu wrekg paipm arkolng anel asen tita la, “Woi, ti mla a i antiwe mpa uwi yaprekg watin atom ikga kil rpmi ikngklei wang pa!” ");
INSERT INTO urim_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Sisas ariwen kolpa atom kil lanaken la, “Melnum pa ake antiwe, Maur Wailen pa kil antiwe pake. Maur Wailen pa kil antiwe antokg kweikwei wrongkwail.” ");
INSERT INTO urim_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita lanakel la, “Ti antokg kolai men ti, men pekg atnurng kweikwei wrongkwail ike, men am katnunteitn itna tike?” ");
INSERT INTO urim_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Sisas akalmpe ok a tu pa la, “Kupm lanakepm aklale wrisen la, melnum a atnurng wan anong alkilen, a tu wail wail wusok wusok, a muikgmayen, mansan, warim, wringkya alkilen eng la ikwap akupmen ngkli yangkipm wor a Maur Wailen pa, ");
INSERT INTO urim_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ikga ik wang a kil rpmi ti i pa, Maur Wailen kil lkel wail wail, wusok wusok, muikgmayen, mansan, warim, wan anong, wringkya kweikwei watipmen. Pa ikga Maur Wailen kil ikilmpentel ngko angen. Ikga wa kil uwi kalkuten nampokgen kweikwei wor pa, kol tu melnum tiur ikga or ungkwan ntokg paipmel kil. Wa kil uwi yaprekg watin atom ikga ik wang kutnukg pa kil ikga rpmi wor lantlan kaino anong wor. ");
INSERT INTO urim_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pake tu watipmen a itna ep pa, tu ikga kai itni kutnukg. Tu a itna katnukg pa, tu ikga kai itni ep.” ");
INSERT INTO urim_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tu angkom tatu ya pa kai eng la kaino anong wail Serusalem. Sisas kil epten, a tu watnom a kil aroaro wonel pa tu katnuntel, tu akwonalmpen watipmen. Tu wrong tiur a katnunten pa, tu ngkark paipm. Sisas awi tu watnom wampwam yikakwompwekg alkil pa aloken aye kai or kai ya yamping, kil lanaken kweikwei ikga palngtel pa. ");
INSERT INTO urim_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kil lanaken la, “Kipm itning, mentepm mpa kinar atom kai kaino anong wail Serusalem. Warim Kipman a Melnum ikga elng kai wam a tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen, a tu melnum a aroaro wonel tu yangkipm a Moses pa. Ikga tu ntokg yangkipm eng ilmpel imo, plalng pa, tu elng kil kai wam a tu a ake Suta pa. ");
INSERT INTO urim_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ikga tu iknokgelel paipm, ungkwawel wlikg, orel ilmpel imo, pake ikga wang wraur pa kai plalng pipa, wa kil wa wrekg.” ");
INSERT INTO urim_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Atom Semis ekg Son, warim wekg a Sepeti, tuwekg kul wreren Sisas atom asentel la, “Melnum a kaling plan men, mentekg la kitn ntokgto kweiur a mentekg wasrongen kil aki?” ");
INSERT INTO urim_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Sisas kil asenten la, “Kipmekg wasrongen kuina, la kupm ntokgtepm?” ");
INSERT INTO urim_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tuwekg akalmpe la, “Kitn elng mentekg ti ur rpmi wam wi, ur rpmi wam wangkokg nti kitn rpmi ik wang a titnongket a nang wailen akitnen palng ngko wunong.” ");
INSERT INTO urim_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Sisas akalmpe la, “Kipmekg titnowen! Ake kipmekg akwonalmpen yangkipm a kipmekg la pa. Ti antiwe mpa kipmekg il u kai kaimung kol mpa kupm il aki, mpa kipmekg kurkuk ik u kol mpa tu kulukopm ti?” ");
INSERT INTO urim_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tuwekg akalmpe la, “Mentekg antiwe.” Sisas lanaken la, “Kipmekg il u ngko kaimung kol mpa kupm ile pa, wa kipmekg kurkuk ik u kol mpa tu ik kulukopm pa. ");
INSERT INTO urim_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pake pa ake kweikwei akupmen ti eng mpa kupm la mla ur ikga rpmi wam wi a wam wangkokg akupmen ti. Pa kweikwei a Maur Wailen alkil ai ikga la pa.” ");
INSERT INTO urim_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tu watnom wampwam pa atning yangkipm a tuwekg Semis ekg Son la pa, tu nikgwalpm wakget eng tuwekg pa. ");
INSERT INTO urim_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Sisas akwewen la tu kul wrerentel eng kil la laniken yangkipm ok ur, “Kipm ariwe, tu melnum a itna kol melnum tukgunakg a ikgalen tu wrong kin kipman, tu ngkat tulntu itna ep, tu arku tu wrongkwail. Tu melnum wail wail pa tu ikgalen tu wrongkwail ak titnongket kalnten alntuwen. ");
INSERT INTO urim_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pake nikgwalpm kolpa ampake rpmi kipm pa. Kitn mla ur kitn a itni wailen eng kipm pa, mpa kitn iken kwap kipm kimeket. ");
INSERT INTO urim_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kitn mla ur kitn la itni ep eng kipm pa, mpa kitn iken kwap orngwatneikgen kipm kimeket. ");
INSERT INTO urim_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Eng ntei, Warim Kipman a Melnum pa yat pekg ake nar eng la kipm pa ngklin kil ti pa kalpis. Kil pekg nar eng kil la ngklin kipm pa. Wa kil la uk num alkil ti kai imo eng la ikirmpen kipm wrongkwail.” ");
INSERT INTO urim_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Sisas nampokgen tu watnom a kil aroaro wonel pa nar palng anong Seriko. Sisas anti tu watnom alkilen pa la utnurng anong pa atom tu wrong kin kipman wailet wa katnunten. Tu atnurng Seriko pa tu kul angko ya pa, melnum ur a wulmpa tilmpisen pa rpma ya yamping pa. Melnum pa Partimaios, warim a Timias. Kil rpma asen asen tu wrongkwail la tu lkel lkel kweikwei. ");
INSERT INTO urim_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kil atning tu la Sisas a Nasaret wli pake, atom kil akwe ak ok wail la, “Sisas, kitn yipetatnong a Tepit, kitn reinsopm!” ");
INSERT INTO urim_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tu wrong wailet kilkampen kolpa la, “Kitn yipo ok pa!” Pake ake kil atning a tu angkengkel pa, kalpis. Kil akwe ak ok wail yikakatnen, “Yipetatnong a Tepit, kitn reinsopm!” ");
INSERT INTO urim_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sisas kil atning ok a akwe pa, atom kil itna la, “Kipm lanikel eng kil kul!” Atom tu akwe melnum wulmpa tilmpisen pa la, “Ampur kitn ipma kalkuten! Kitn wrekg o! Kil akweweitn pake!” ");
INSERT INTO urim_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Atom kil angkli apm alkil a wropuk pa elng kai kanokg ai, kil wrekg kolti kai eng Sisas. ");
INSERT INTO urim_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sisas asentel la, “Kitn wasrongen kuina la kupm ntokgteitn?” Melnum a wulmpa maur amo pa la, “Ntokgtopm wulmpa a kupm a tilmpis ti palng wor, eng kupm a ik ri kweikwei!” ");
INSERT INTO urim_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Sisas lanakel la, “Kitn kai o! Nol nikgwalpm akitnen pa rka eng kupm pa atom antokg kitn palng wor.” Penterngen kolti wulmpa a melnum pa am wor ike. Atom kil anti tu katnun Sisas. ");
INSERT INTO urim_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tu kul no wreren anong wail Serusalem pa no angko Petpake a Petani, anong wasek wekg a ela wreren wrik nangen Olip. Sisas ukwa watnom wekg a kil aroaro wonel pa kai ep. ");
INSERT INTO urim_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Kil lanaken la, “Kipmekg kaino anong a kipmekg ari wreren pawo! Kipmekg kaino anong pa, mpa kipmekg ri nimpa nepm kuinen warimpen a ake melnum ur arpme arpme pa, tu angkuten itna yo wang a pa. Inelkgentopm nimpa nepm kuinen pa, atom iye nar eng kupm rpme! ");
INSERT INTO urim_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mla ur la isentepm la, 'Kipmekg anelkgen nimpa nepm kuinen pa la ik ntokg kuina?' pipa, kipmekg lanikel kolpa, 'Melnum Wailen ai kil la uwi nimpa nepm kuinen eng ik ik kwap ur alkil ai, plalng pipa, wa kil penterng ukwanteitn no pa!'” ");
INSERT INTO urim_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tuwekg kawor ari nimpa nepm kuinen warimpen pa a tu angkuten itna yo wang a wanyun enen pa, atom tuwekg anelkgentel. ");
INSERT INTO urim_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tu melnum tiur a rka anong pa asenten kolpa la, “Kipmekg anelkgen nimpa nepm kuinen pa eng ntei?” ");
INSERT INTO urim_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tuwekg lanaken yangkipm ok a wuten Sisas kil lanaken pa. Tu atning atom tu awi wor alken. ");
INSERT INTO urim_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kolpa atom tuwekg aye nimpa nepm kuinen warimpen pa aye nar eng Sisas. Atom tuwekg angkli apm pa elng kaino nimpa nepm kuinen pa ukulam, atom Sisas kaino arpme. ");
INSERT INTO urim_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tu melnum watipmen anel elng apm alntu pa elngkirmpa ya pa, tu tiur angket yo ipm itna ya yamping pa elngkirmpa ya pa eng Sisas kil arpme nimpa nepm kuinen aye ore. ");
INSERT INTO urim_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tu wrong tiur a ep pa, a tu wrong tiur a katnukg pa, tu anel ngkat ok la yikakatnen atopen Sisas pa la, “Osana, Maur Wailen, men atopenteitn! Kitn plan ipma wor ik ngklin melnum ti. Kitn alkel nang Wailen atom kil wli ti. ");
INSERT INTO urim_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kitn plan ipma wor ik ngklin melnum tukgunakg a wli ti, kil la wrekg itni wailen ikglen men ti, kol pekg yipetatnong amentepmen Tepit itna wailen ikgalen tu amenen pa. Maur Wailen, men atopenteitn, kitn melnum a rpma kaino kwa ai!” ");
INSERT INTO urim_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sisas kil no palng no anong wail Serusalem atom kil kawor yipmingki wunen a yalming a Maur Wailen. Kil ari yela kweikwei wrongkwail pa plalng, ari takgni am kinar nungkurikg plalng tike. Kolpa atom am wa kil nampokgen tu melnum wampwam yikakwompwekg alkil pa yaper kinar anong wasek Petani pa. ");
INSERT INTO urim_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tu okg or kong ti pa, tu wrekg atnurng anong Petani ti pa Sisas pa nikgalmpel. ");
INSERT INTO urim_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kil ikg kai ari yo kampuk ur a ipm atnen pa itna kai ai. Kil la kai ri la tikga kulok aki tikga tukgun ur rka aki kalpis. Kil kai palng kai yo kampuk yiprokg, pake ake kil ari ok ur rka, ipm kalpmilel kolti, eng ntei, ake wang alkil a ok arke pa. ");
INSERT INTO urim_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Atom Sisas lanaki yo pa la, “Ikgake mla ur il ok kai kitn pa nti ur!” Tu watnom alkil pa tu atning yangkipm a kil lanaki yo pa. ");
INSERT INTO urim_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tu no palng no Serusalem pa, Sisas kil kawor yipmingki wunen a yalming a Maur Wailen. Kil ngkaten eng ungkwan tu a akwap marpm a ak kweikwei awi marpm itna kawor yipmingki wunen pa. Kil taipurng tipmakg a elng marpm elngarmpe eng ak awiye awiye marpm, nampokgen wrik tipmakg a tu melnum a aye wel punum kai armpe eng tu armpenten pa. ");
INSERT INTO urim_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kil angkengken la, ake mpa mla ur iye kweikwei ur ngkom or kawor yipmingki wunen a kapringen yalming a Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kil aro wonelen la, “Wrkapm a Maur Wailen pa la kolkil, 'Wan akupmen ti wan a tu wrong a awen wli eng oklala naki naki kupm ti.' Wrkapm a Maur Wailen pa la kol pake, ari kipm antokg wan kil palng paipm kol wrik ampen a tu melnum ikgwampet ak ikgwampel kweikwei wli lam armpe.” ");
INSERT INTO urim_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen nampokgen tu melnum a aroaro wonel tu yangkipm a Moses tu atning pa, atom tu akor ya la ilmpel imo. Pake tu ngkark eng yangkipm a Sisas kil kaling plan pa alm ipma a tu wrongkwail. ");
INSERT INTO urim_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ak nungkurikg pa Sisas nampokgen tu watnom alkil pa tu atnurng Serusalem pa kinar. ");
INSERT INTO urim_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ak kong Sisas nampokgen tu watnom a kil aroaro wonel pa kai akanele yo kampuk pa, tu ari, yo pa am nungkwor nungen ike kinar yapoko alkil ai. ");
INSERT INTO urim_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita kil won uwen pa atom kil lanaki Sisas pa la, “Melnum a kaling planto, kitn ri! Yo kampuk a pekgkil kitn akle pa am nungkwor nungen ike!” ");
INSERT INTO urim_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Sisas akalmpenten kolpa la, “Kipm rkul ipma a kipm ukipma Maur Wailen pa itni tongtong! ");
INSERT INTO urim_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kupm lanakepm aklale wrisen la, kol melnum ur a ukipma Maur Wailen pa kil laniki tipmining a itna ti la, 'Tipmining, kitn tipor ngko elng kinar unokg pawo!' Kol melnum pa ake nikgwalpm wekg wekg, kil nikgwalpm wris kolti la, 'Yangkipm akupmen kil pa mpa palng iklale', kol kil la kolpa pa, pa mpa palng iklale kol a melnum kil la pa. ");
INSERT INTO urim_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kupm lanakepm la, kol kipm oklala niki Maur Wailen atom ukwentel la kil ngklinsepm pa. Kol kipm ukipma la, kipm am awi ike, kil mpa ngklinsepm kitila kol a kipm ukipma pake. ");
INSERT INTO urim_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ik wang a kipm itni oklala niki Maur Wailen pa, kipm utnurng paipm a mla ur antokgtepm pa ep, plalng pipa, mpa Yan akipmen kaino kitnong pa mpa wa kil ungkwan paipmpaipm a kipm antokg pa. ");
INSERT INTO urim_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kol ake kipm utnurng paipm a mla ur antokgtepm pa, Yan akipmen kaino kitnong pa ampake wa ungkwan paipmpaipm a kipm antokg pa.” ");
INSERT INTO urim_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tu yaper kaino Serusalem antiur. Atom Sisas kawor yipmingki wunen a kapringen yalming a Maur Wailen. Tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen, tu melnum a aroaro wonel tu yangkipm a Moses nampokgen tu melnum wail wail tu kul eng kil. ");
INSERT INTO urim_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tu asentel la, “Pekg kitn asen mla awi wor atom kitn antokg kweikwei pa? Mla alkeitn titnongket atom kitn antokg kweikwei pa?” ");
INSERT INTO urim_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ari wa Sisas kil akalmpenten la, “Ti itni eng kupm ik isentepm akasen wris ur kil. Kol kipm ikilmpe akasen akupmen kil pipa, mpa kupm lanikepm titnongket a kupm ak ak kwap pa. ");
INSERT INTO urim_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Son kil kaluk tu, pekg mla la atom kil kaluk tu pa? Maur Wailen aki melnum? Kipm lanikopm ri!” ");
INSERT INTO urim_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Atom tu rpma akor la, “Kol mpa mentepm la kolpa, 'Maur Wailen, kil la atom kil kaluk tu', pa mpa kil iklewo la, 'Ti ake kipm ukipma kil?' ");
INSERT INTO urim_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aki mentepm la, 'Son pa kil kaluk tu ak nikgwalpm alkilen kolti?'” Pake tu wrong kin kipman a rka pa ukipma la Son pa kil melnum ok wripm a Maur Wailen aklale, kolpa atom tu ngkark, ");
INSERT INTO urim_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","atom tu kansil akalmpe kai Sisas pa la, “Men akwekgel.” Atom wa Sisas lanaken la, “Kupm yat, kupm ake mpa wa lanikepm la mla a i alkopm titnongket atom kupm ak ak kwap kil.” ");
INSERT INTO urim_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sisas kil la yangkipm kla ur kolkil naken, “Melnum ur antokg wring ampei wain. Kil ak yipmingki kapringen. Plalng pa, kil aro lkim wail ur pa numprampen elngitna, eng ikga tu rkganti tipon u ampei ok pa kai elng nare. A wa kil wa ale wan kwa ur pa elngitna eng ikga rpmen wring pa rpmewe. Kil antokg kweikwei pa plalng, kil awi melnum tiur ai wli ikgalen akentel wring pa kolpa itna, a kil wrekg kai anong ya watinet ur ai. ");
INSERT INTO urim_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wain ok pa tukgun pipa, kil ukwa melnum akwapel ur akilen pa la kil kai ri tu melnum a ikgalentel wring ampei wain pa la uwi wain ok alkilen a aknamputel pa iyentel kai. ");
INSERT INTO urim_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ari kalpis, tu arkul melnum a kul awi wain ok pa orel paipm, ungkwantel la kil ngkompwam yaper kai. ");
INSERT INTO urim_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wa kil wa la melnum manet ur wa kainten, ari kalpis, tu or melnum pa kai tukgunakg a kil pa paipm, tu ak nokgelel ari paipm. ");
INSERT INTO urim_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kil la melnum ur wa kai pa, wa tu orel amo. Wa kil la wrong tiur wa kai pa, wa tu or tiur pa paipm, a tiur pa tu or amo. ");
INSERT INTO urim_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kil warim kipman wris ata kolti, ti kil plan ipma wor wasrongentel. Kil la warim kipman alkil pa kai eng plalng pake. Kil la, 'Mpa tu numpaipm eng warim kipman akupmen kil ur pa.' ");
INSERT INTO urim_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pake tu melnum a ikgalen wring wain pa naki tita la, 'Melnum pa ikga kil uwi num ngklin kweikwei wrongkwail a yan alkil. Ti kipm kul eng tepm ilmpel imo wo, eng mpa mentepm iye kweikwei akilen ti eng almentepm!' ");
INSERT INTO urim_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kolpa atom tu arkulel aye kai wring arkikg ai, tu almpel amo, angkli kawor en takuleikgen yipmingki pa ike.” ");
INSERT INTO urim_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Sisas la yangkipm kla pa kai plalng pa, kil asen tu a atning rka pa la, “Ti melnum yan a wring ampei wain pa mpa ntokg kolai? Mpa kil kul ilm tu melnum a ak kwap itna wring pa tukuleikg, plalng pa, mpa kil uk wring ampei wain pa kai tu melnum ur manet tiur ai. ");
INSERT INTO urim_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kipm ti, ake kipm angkleikg yangkipm wompel a Maur Wailen a nira ela wrkapm pa, pa la kolpa, 'Ong a tu melnum a ale wan pa tu ari la la paipm pa, tu ungkwan, am ong kimpowen wor wrisen a akale wan am pake. ");
INSERT INTO urim_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Maur Wailen kil alkil antokg pa, atom mentepm ari la pa wor wrisen atom mentepm atopen.'” ");
INSERT INTO urim_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tu melnum wail wail a tu Suta pa tu ariwe la Sisas ak yangkipm kla ak la tu pake. Kolpa atom tu la rkulel eng la ntokgtel paipm. Ari tu ngkark eng tu wrong watipmen a itna pa, atom tu atnurngkel kai. ");
INSERT INTO urim_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tu ukwa tu melnum tiur a tu melnum a arpmen yangkipm yiprokgen a Moses nimpokgen tu melnum tiur a Erot, tu kai alm ipmawel Sisas eng la kil la oklala ur kai paipm pa, mpa tu iyewel kai ntokg yangkipm. ");
INSERT INTO urim_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tu kai eng Sisas pa, tu alkel wor la, “Melnum a kaling plan tu, men ariwe, kitn melnum ute wor a la yangkipm ok aklale. Kitn ari men wrongkwail la men kimeket irir. A kitn ake ngkat nang a melnum wail pa kaino kwa, a kitn ake arku melnum paipm pa kinar kanokg, pa kalpis. Kitn kaling planto ya a Maur Wailen pa ute kolti. Kitn akwonalmpen kolai? Pa wor eng mentepm uk marpm Kaisarus, melnum tukgunakg a Rom a awi marpmel mentepm ti, aki kalpis? Mentepm uk aki ampur mentepm uk?” ");
INSERT INTO urim_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pake Sisas kil ariwe la palpa nikgwalpm ampen a tu almpel ipma, atom kil lanaken la, “Kipm almpopm ipma pa kolpa eng ntei? Uwi marpm ur pa iye kul eng kupm ri!” ");
INSERT INTO urim_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tu aye marpm ok pa aye kul, atom kil asenten la, “Tukgunakg a nang a mla ela marpm kil?” Tu akalmpe la, “A Kaisarus, melnum tukgunakg a Rom pa.” ");
INSERT INTO urim_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Atom Sisas lanaken la, “Kweikwei a Kaisarus mpa kipm uk Kaisarus. Kweikwei a Maur Wailen mpa kipm uk Maur Wailen.” Tu atning kolpa, tu akwonalmpen watipmen. ");
INSERT INTO urim_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tu melnum Satyusi tiur tu kul eng Sisas. Tu Satyusi pa lala, tu melnum a amo kaingkai pa ikgake wa wrekg wrekg. Tu asen Sisas pa la, ");
INSERT INTO urim_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","”Melnum a kaling plan yangkipm a Maur Wailen, Moses kil niranto yangkipm ok ur kolkil la: kol melnum nangkworen la imo utnurng kin alkil pa, pa kil warim kalpisen. Meten alkil pa mpam uwi kin karpikg alkil pa eng ngket warim eng ngklin nangkworen alkil pa. ");
INSERT INTO urim_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Wusokwail wusokwail kulungen tunteng karpo tita kin wris a wailen alntuntengen pa aye. Ep pa nangkworen pa awi kin pa aye ari wa kil amo atnurng kin pa, warim kalpisen itna pa. ");
INSERT INTO urim_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pipa wa meten pa wa awi karpikg pa wa aye, am wa kol pake. Kipman pa amo atnurng kin pa, warim kalpisen itna pa. Wangen pa am wa kolpake. ");
INSERT INTO urim_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aklale wrisen, ake wris a tu wampwomis wampwompwekg pa angket warim ur eng angklinsen, kalpis. Kolpa kai, kin pa wa amo kai katnunten. ");
INSERT INTO urim_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ikga ik wang kutnukg a tu melnum a amo kaingkai pa wa wrekg wrekg, ikga ik wang pa kin pa ikga rpmi eng mla? Pekg tu melnum wampwomis wampwompwekg pa aye pa?” ");
INSERT INTO urim_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ari Sisas kil akalmpe la, “Kipm ake ariwe yangkipm ela wrkapm a Maur Wailen la pa. Kipm ake ariwe titnongket a Maur Wailen pa. Kolpa atom kipm la yangkipm ok pa atn palpa. ");
INSERT INTO urim_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ikga ik wang a tu melnum a amo kaingkai pa wa wrekg wrekg i kirk pa, pa tu wrong kin kipman ikgake uwi tita, kalpis. Ikga tu rpmi muikgmuin kolti kol tu maur akwapel a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yangkipm a la tu melnum a amo kaingkai ikga wa wrekg wrekg pa ake kipm angkleikg wrkapm a Moses, a la wakg al yo wasek pa? Yangkipm pa la Maur Wailen kil lanaki Moses la, 'Kupm Maur Wailen a tunteng Apraam, Aisak, Sekop.' Tunteng ake amo, tunteng kai rpma. ");
INSERT INTO urim_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kil Maur Wailen a tu melnum a amo kaingkai rka wai, kil Maur Wailen a mentepm melnum a rka ti. Palpa kipm la yangkipm raimpe tuwa.” ");
INSERT INTO urim_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Melnum ur a aroaro wonel tu yangkipm a Moses kil kul atning a tu alilakel tita yangkipm ok pa itna. Kil atning Sisas kil akalmpenten yangkipm ok wor wor kolti. Atom wa kil asen Sisas pa la, “Yangkipm titnongket a i a i wail itna ep a la men kutnun pa, a yangkipm titnongket wrongkwail pa kai arkekg?” ");
INSERT INTO urim_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Sisas kil akalmpe la kolpa la, “Yangkipm titnongket wail a itna ep a la kipm kutnun pa kilke: Kipm Isrel pa, kipm itning! Wailen kil Maur Wailen a mentepmen. Kil wris ata, kil wail itna ep. ");
INSERT INTO urim_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kitn mpa plan ipma wor wasrongen Wailen, Maur Wailen alkitnen pa nimpon nol nikgwalpm alkitn, a amen wor alkitn, a ariwe alkitn, a titnongket alkitn ti kimeket. ");
INSERT INTO urim_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yangkipm titnongket a kai arkekg yangkipm pa, pa la kolkil: Kitn mpa plan ipma wor wasrongen mla ur ai kol a kitn plan ipma wor wasrongen kitn alkitn pa! Ake yangkipm titnongket ur a la kipm kutnun pa angen yangkipm titnongket wail wekg kil.” ");
INSERT INTO urim_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Melnum a aroaro wonel tu yangkipm a Moses pa kil lanaki Sisas pa kolpa la, “Melnum a kaling planto yangkipm a Maur Wailen, kitn la aklale. Maur Wailen kil wris ata kil itna ep, ake kuina ur itna ep eng kil pa kalpis. ");
INSERT INTO urim_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kol mentepm plan ipma wor wasrongen Maur Wailen nampon nikgwalpm, ariwe, titnongket almentepmen ti. Wa kol mentepm plan ipma wor wasrongen mla ur kol a mentepm plan ipma wor wasrongen mentepm almentepm ti. Kol mentepm ntokg kolpa pa, pa wail itna ep eng kweikwei a mentepm lap alwor uk Maur Wailen, aki yawor a mentepm alm alwor uk Maur Wailen.” ");
INSERT INTO urim_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sisas kil atning a melnum pa akalmpe pa ute wor, atom kil lanakel la, “Kitn itna wreren eng kitn a kawor yipmingki wunen a Maur Wailen ikgalen pa.” Ak wang pa tu ngkark, atom ake wa tu asen Sisas pa anti ur. ");
INSERT INTO urim_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sisas kil rpma yipmingki wunen a yalming a Maur Wailen pa, kil lanaki tu wrong kin kipman yangkipm a Maur Wailen. Kil asenten la, “Antokg kolai, ti tu melnum a aroaro wonel tu yangkipm a Moses pa tu la Krais, melnum a Maur Wailen ukwa nar pa kil walpopm ur a angket ale a Tepit ti kul tike? ");
INSERT INTO urim_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pekg Maur Wor uk nikgwalpm Tepit, atom Tepit kil alkil la kolpa la, 'Wailen kil lanaki Wailen alkupm pa kolpa la, “Kitn rpmi wam wi akupmen pa rpmi i, kupm or tu wrongmanto akitnen pa yikak rkganti mengkel itni orngwatneikgen kitn pa.”' ");
INSERT INTO urim_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tepit kil akwe Krais, melnum a Maur Wailen la ukwa nar, la kil Wailen akilen. Ti antokg kolai atom wa kil walpopm a Tepit pa?” Tu wrongkwail tu atopen eng atning yangkipm a Sisas la pa. ");
INSERT INTO urim_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sisas kil wa ak yangkipm ok a Maur Wailen pa ak angklinsen anti ur, kil la kolpa la, “Kipm itn riwe eng tu melnum a aroaro wonel tu yangkipm a Moses. Eng ntei, tu wasrongen paipm eng la ining apm watin wail wail eng la ye itn. Tu wasrongen paipm eng la tu yangkipmenten kai akapm wail a tu armpen armpen okipma kweikwei atnewe pa. ");
INSERT INTO urim_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tu wasrongen eng la tu a kai rpmi wrik a ela ep kawor wan a tu atning atning yangkipm a Maur Wailen atnewe pa. Wa ak wang a tu antokg okipma pa tu akwonalmpen la tu ti melnum wailen ti kol a tu ik wam rku okipma wailet eng tu pake. ");
INSERT INTO urim_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tu ak palk upaar armpwonel tu kin karpikg pa la tu a uwi kweikwei atuwen pa iye kaingkai plalng, wan kalpmilel kolti. Tu akwen Maur Wailen pa arkolng itna watin eng mpa tu ri la tu ti melnum wor. Tu melnum kuin wentingen kolpa ikga tu uwi wleket wail ikilmpe nikgwalpm paipm a tu antokg pa.” ");
INSERT INTO urim_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sisas kil rpma wreren yotimpal a tu alupme marpm eng uk Maur Wailen rpma wanyun a wan yalming a Maur Wailen. Kil ikatnen tu aye aye marpm a tu uk Maur Wailen pa aye wli alupm kinar yo timpal pa. Tu melnum watipmen a antiwe marpm pa tu angkli marpm wail wail. ");
INSERT INTO urim_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pake kin karpikg ur a rpma tukwok pa kul angkli marpm watet yek wekg pa kolti. ");
INSERT INTO urim_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sisas lanaki tu watnom a kil aroaro wonel pa la tu kai wrerentel, atom kil lanaken la, “Kupm lanakepm aklale wrisen, kil kin karpikg a rpma tukwok, pake kil angkli marpm wail elng kinar yotimpal pa angen marpm a tu wrong kin kipman wris wris angkli pa. ");
INSERT INTO urim_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tu melnum wrongkwailet pa tu antiwe marpm wailet rmpa, tu angkli tiur kolti elng kinar yotimpal. Pake kin karpikg pa kil tukwok wrisen, pake kil angkli marpm alkil pa plalngten, ake yek ur rmpa eng mpa ikirmpen kuina ur a kil tukwok pa kalpis.” ");
INSERT INTO urim_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sisas itna yipmingki wunen a yalming a Maur Wailen pa eng a kul or en pa, watnom ur a kil aroaro wonel pa lanakel la, “Woi, melnum a aroaro wonel men ti, kitn ri yalming wor ti, tu ak wes wail manten manten ak ale!” ");
INSERT INTO urim_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Sisas akalmpentel kolpa la, “Ei, wan wail wor pa, pake ikgake wes ur itni, kalpis. Ikga tu tikale ngkli plalng.” ");
INSERT INTO urim_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sisas kil rpma wrik nangen Olip ikg kai ari yalming a Maur Wailen a ela kai wompel ai. Pita, Semis, Son, Antru, tunteng pa kolti antiwel rpma atom tunteng asentel la, ");
INSERT INTO urim_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kitn laniko la, wang a i ikga yalming a Maur Wailen pa topor pa? Kla kuina ikga palngto ep, atom mpa men riwe la, wang am kul wreren tike?” ");
INSERT INTO urim_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Atom Sisas kil lanaken yangkipm pa la, “Kipm itn riwe! Melnum ur ikga kinsilepm. ");
INSERT INTO urim_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Melnum watipmen ikga kul uwi nang akupmen ik la la, 'Kupm ti, kupm Sisas.' Ikga tu kinsil kipm wrongkwailet iye kai ar. ");
INSERT INTO urim_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ikga kipm itning yangkipm a tu la tu alm tita, a ikga kipm itning milpming a tu almpwrong la kul wreren pa, ampur kipm ngkark! Eng ntei, kweikwei a kolpa ikgam palng pake, wang a kweikwei wrongkwail ti kai plalng pa a pa. ");
INSERT INTO urim_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tu anong ur ai ikga wrekg ilm tu anong ur ai. Tu wrong a mring tukgunakg ompur ai ikga wrekg ilm wrong a mring tukgunakg ompur ai. Yelm ikga no, wang nikg wail paipm ikga palng tutu anong kanokg tiur. Kweikwei pa ikga wleket kol wleket a palng ep kai kin a la raku warim pa. ");
INSERT INTO urim_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kipm pa, kipm rpmi riwe! Ikga tu iyewepm kai itni tu mring man alkipm a ikgalen anong pa. Pa tu orepm tutu wan a kipm atning atning yangkipm a Maur Wailen atnewe pa. Pa tu ikwonilmpen la rku nang akupmen. Wa ikga kipm itn ikwap akupmen ti, atom ikga tu iyewepm kai itni wulmpa a tu mring man wail wail, a tu melnum tukgunakg a itna ep. Pa ikga palng kol ya ur eng kipm laron yangkipm wor a la kupm ti niken eng tu itning. ");
INSERT INTO urim_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ep pa kipm ngkli yangkipm wor a la kupm ti kai niki tu yela kanokg ti plalng pa, wang a kweikwei wrongkwail ti kai plalng pake. ");
INSERT INTO urim_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ik wang a tu uwiyepm iye kai eng ntokg yangkipm pa, ampur kipm nikgwalpm kaikuten la, kipm ikga la kolai pa. Maur Wor a Maur Wailen ikga ngklin nikgwalpm wrongkwail eng kipm ik la yangkipm pa. Eng ntei, ikgake kipm ti laron pa, kalpis. Ikga Maur Wor alkil ai laron ai. ");
INSERT INTO urim_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ikg a tu wusok wusok uk wailen alntu kai wam a tu wrongmanto, eng tu ilmpel imo. Tu yantin ikgam ntokg kolpa eng tu warim alntu pake. Tu warim ikgam ilmpor tu mansan alntu pa kolpa yat pake. ");
INSERT INTO urim_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kol kipm ukipma kupm pa, ikga tu wrongkwail nikgwalpm wakget eng kipm pa. Pake mlaur a kil itna titnongket kai ngko wang wulompen pa, pa ikga Maur Wailen kil uwiyel.” ");
INSERT INTO urim_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","”Ikg a kipm ri kweiur paipm wrisen a numkropise kamel pa itni kawor wrik a Maur Wailen amprin eng kil alkil pa. Ti melnum a kil angkleikg yangkipm wrkapm kil a Sisas la pa, kil ikwonilmpen pa riworwor! Kipm ri palng pa, la ampake. Kipm wrong kin kipman a rka anong kanokg a Sutia pa kipm ngkirk kaino nang ai! ");
INSERT INTO urim_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kol melnum ur ikga rpmi kawor wan male pa, ampake kil wa kawor wan wunen pa eng uwi uwi kweikwei tiur alkil pa, mpa kil kai or yawel kolti kai! ");
INSERT INTO urim_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wa kol melnum ur ikga kai ikwap itni wring alkil pa, ampur kil wa yaper kul uwi apm nung alkil kul anong pa, kalpis, kil i pa kai pake! ");
INSERT INTO urim_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Arein eng tu kin a itna, a tu mantin a warim rka ma ikga ik wang pa! ");
INSERT INTO urim_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kipm laniki Maur Wailen eng kweikwei pa ikgake palng ik wang a u awei pa! ");
INSERT INTO urim_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ikg a ik wang pa kipm ikga rki kalkuten wail paipm. Pekg ep Maur Wailen antokg kitnong a kanokg pa, pekg ake kalkuten ur kolpa palng ep kulngkul wang ti, kalpis, a pa, a kutnukg pa ikgake wa kalkuten ur kolpa wa palng. ");
INSERT INTO urim_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kol Maur Wailen pa ikgake rukge wang a kalkuten pa kai tukwok pa, tu wrong kin kipman pa ikga kai paipm plalng. Pake kil arein tu wrong kin kipman alkil pa, kolpa atom kil ikga rukge wang pa kul tukwok. ");
INSERT INTO urim_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ik wang pa melnum ur la lanikepm la, 'Kipm ri, Krais, melnum a Maur Wailen ukwa nar pa, rpma ti', aki 'Kipm ri, Krais, melnum a Maur Wailen ukwa nar pa, rpma kai ai.' Ampur kipm atning yangkipm a tu la kolpa. ");
INSERT INTO urim_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Melnum tiur pa ikga kinsil la kolpa, 'Kupm Krais, melnum a Maur Wailen ukwa nar. Kupm melnum ok wripm a Maur Wailen.' Ikga tu elng kla tiur itna ik plan titnongket alntuwen, wa ntokg kweikwei manet manet ur ai a ikga melnum wrekg paipm eng ri pa. Aklale wrisen, tu ntokg la lok rku tu wrong kin kipman a Maur Wailen eng la tu ngko. ");
INSERT INTO urim_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kolpa ti kipm itn riwe! Kweikwei wrongkwail pa am pekg kupm lanakepm ike.” ");
INSERT INTO urim_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","”Wang a kalkuten wail pa kai plalng pa, ikga ik wang pa takgni pa ikga kai miningket a kainil pa ikgake len. ");
INSERT INTO urim_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kormeim ikga nurku ngko, a kweikwei wrongkwail kaino kitnong pa ikga titu plalng. ");
INSERT INTO urim_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ik wang pa ikga tu ri Warim Kipman a Melnum ikga ingkaino kitnong pa nar nimpokgen waipmunu, a nimpokgen nang wailen a titnongket wail. ");
INSERT INTO urim_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ik wang pa kil ikga ukwa tu maur akwapel alkil pa nar, eng tukwem uwi tu wrong kin kipman a pekg kil takweiyen eng kil alkil pa. Ikga kil uwiyen yela kai tutu kanokg yiprokgen a kitnong yiprokgen ai.” ");
INSERT INTO urim_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kol kipm riwe yangkipm kla a la yo kampuk: wam alkil pa u rke a yo ipm pa inip no wulkga pa, pa kipm riwe la takgni eng a wor pake. ");
INSERT INTO urim_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Am kolpake, ikga kipm ri kweikwei kalkuten pa palng pa, kipm riwe la, wang am kul wreren itna yamping a tike. ");
INSERT INTO urim_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kupm lanakepm aklale wrisen: kipm wrong kin kipman a rka ti, tiur akipmen pa ikga imo, a tiur akipmen pa ikga rki kolpa kai, kweikwei wrongkwail pa palng. ");
INSERT INTO urim_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kitnong a kanokg ti ikga kai plalng, pake yangkipm akupmen pa ikgake kai plalng, ikgam itna kolpa kai pake.” ");
INSERT INTO urim_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Melnum ur ake ariwe wang a ikga kweikwei pa palng pa. Tu maur akwapel a Maur Wailen kaino kitnong pa, tu ake wa ariwe wang pa. Warim Kipman pa kil ake wa ariwe wang pa yat. Yan kil alkil wris ata kil ariwe wang pa. ");
INSERT INTO urim_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kipm rpmen rpmi, wonrpme nungkulkg lan! Kipm akwekgel wang a i ikga kweikwei pa palng. ");
INSERT INTO urim_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Pa ikga kol melnum ur a atnurng wan anong alkilen kai atn or kol ur ai. Kil uk wan anong kweikwei tu melnum akwapel alkilen la tu ikglentel, a kil ampreing kwap pa ak nirake tu melnum wris wris. Wa kil wa lanaki melnum a arpmen yipmingki yun pa la kil rpmi nungkwangentel rpmi! ");
INSERT INTO urim_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kolpa ti kipm rpmen riworwor! Kipm akwekgel wang a i mpa melnum yan a wan pa wli. Mpa kil wli ik nungkurikg aki, mining kuin aki, ik karek lala aki, ik kong wor wor aki, kipm ake ariwe. ");
INSERT INTO urim_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kol mpa kil wli penterngen ari kipm okg rmpa pa paipm. Kolpa ti kipm rpmi nungkwangen! ");
INSERT INTO urim_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yangkipm a kupm lanakepm ti pa, pa yangkipm a ak angklin wrongkwail: kipm rpmi wonrpme nungkulkg lan!” ");
INSERT INTO urim_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A wang wekg eng ikga wang wail a mentepm akwonalmpen a pekg Maur Wailen ak awi tu amentepmen aye takuleikgen tu Isip pa kul, a wang wail a tu ake al al nok tingklak a tu ak mpim ap mringen ak oren pa. Pa tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen, a tu melnum a aroaro wonel tu yangkipm a Moses, tu anel akor ya ampen la rkul Sisas eng la ilmpel imo. ");
INSERT INTO urim_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tu la kolpa, “Ampur mentepm antokgtel ak wang wail pa, mpa tu wrong kin kipman wrekg or tita.” ");
INSERT INTO urim_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sisas kil rpma anong Petani a wan a Saimon, melnum a pekg i paipuk awiyel ep pake kil am palng wor ise. Tu al okipma pa rka pa, kin ur pa or nampokgen wes kaingkuren ur a alupme u yaprekget wor. U pa ak marpm wail paipm akarmpen. Kil kapor okel u wes kaingkuren pa, atom kil alung u yaprekget wor pa ak anel tukgunakg a Sisas pa. ");
INSERT INTO urim_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tu melnum tiur a rka ari pa, tu nikgwalpm paipm. Tu anel rka akor la kolpa, “Kil kaken u yaprekget wor pa kai kil pa eng ntei? ");
INSERT INTO urim_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kol uk u yaprekget ti eng tu rmpen ik marpm wail, eng marpm pa uk tu melnum a rpma tukwok.” Tu akle kin pa kolpa. ");
INSERT INTO urim_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ari Sisas kil la kolpa, “Elngen nikgwalpm pa! Kipm uk nikgwalpm kalkuten kin pa kolpa eng ntei? Kil ak kwap wor eng kupm ti. ");
INSERT INTO urim_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tu melnum a rpma tukwok pa ikga rpmi pa i pake. Kipm la ngklinsen pa, wang ur kipm ngklinsen kul! Kupm ti ikgake ntiwepm rpmi ti i. ");
INSERT INTO urim_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kin pa ak kwap ak nikgwalpm ariwe alkil. Kil ak u yaprekget wor ak anel num akupmen, numprampentopm ep, eng ikga tu uwentopm. ");
INSERT INTO urim_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kupm lanakepm aklale wrisen, ikga tu ngkli yangkipm yela tatu kanokg ti, kuina ur wet kin pa antokg, pa ikga wa tu laron yat, eng ikga tu ikwonilmpen kin pa iye or pa kai.” ");
INSERT INTO urim_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Atom Sutas Iskariot, watnom wris ur a tu watnom wampwam yikak wekg a Sisas aroaro wonel pa kai eng tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen, eng la elng Sisas kai wam atuwen. ");
INSERT INTO urim_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tu atopen eng atning yangkipm pa, atom tu yapon yangkipm eng la uk marpm ur Sutas pa. Kolpa atom Sutas akor ya ur eng la elng Sisas kai wam atuwen pa. ");
INSERT INTO urim_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Wang wail aripm ur a akangklei wring wris wris men angklon nok tingklak a ak mpim ap mringen ak oren pa am ngkaten ak wang wet tike. Atom ti wang a men alm manto walkg malkgu war ur eng rki ntokg il wor uk Maur Wailen eng ikwonilmpen a pekg Maur Wailen ak awi tu amenen aye kul takuleikgen tu Isip pa. Atom tu watnom a Sisas kil aroaro wonel pa asentel la, “Kitn wasrongen wrik kai a i, la mpa men kai numprampen manto walkg malkgu kweikwei okipma pa, eng mpa kitn il pa?” ");
INSERT INTO urim_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Atom kil ukwa watnom wekg alkil pa kai, kil lanaken la, “Kipmekg kawor anong wail pa. Melnum ur iye u kuntuken pa kul nsilepm ngko ya pa pipa, kipmekg kutnuntel kai o! ");
INSERT INTO urim_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kil kai kawor wan ur pa pipa, kipmekg laniki yan a wan pa la kolpa la, 'Melnum a kaling planto yangkipm a Maur Wailen la kolpa, “Wan ok akupmen ti a i, eng mpa kupm rpmi il manto walkg malkgu war kweikwei, nimpokgen tu watnom alkupmen ti?”' ");
INSERT INTO urim_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mpa kil plantepm wan ok okkapmet ur a itna kaino walop ur ai. Kweikwei wrik a arpme pa am numprampen itna ike. Kipmekg numprampentilo okipma pa kaino wan ok kwa pawo!” ");
INSERT INTO urim_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Atom tuwekg am ekg kai, kai kawor anong wail pa, ansil kweikwei kol wuten Sisas lanaken pa. Atom tuwekg numprampen okipma pa. ");
INSERT INTO urim_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Takgni kinar pelpel ti pa Sisas nampokgen tu watnom wampwam yikak wekg pa or palng. ");
INSERT INTO urim_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tu rka al okipma pa rka. Sisas lanaken kolpa la, “Kupm lanakepm aklale wrisen: melnum ur a rpma kuin amentepmen ti, mpa kil elng kupm ti elngkai wam a tu wrongmanto. Melnum pa am antiwo al okipma rpma tike.” ");
INSERT INTO urim_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tu ipma kalkuten eng atning yangkipm a Sisas la pa, atom anel asentel wris wris la, “Kupm ti kalpis ur aki?” ");
INSERT INTO urim_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kil akalmpe la, “Am melnum ur a rpma kuin a kipm wampwam yikakwekg pake. Melnum ur a anti kupm angkle nok tingklak kinar unokg pa, pa am melnum pake. ");
INSERT INTO urim_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Aklale, Warim Kipman a Melnum ikga imo kol wrkapm a Maur Wailen la pa. Pake woi, arein melnum a elng Warim Kipman a Melnum elngkai wam a tu wrongmanto pa, pa kil ikga uwi paipm! Pekg wa man raku kil pa eng ntei? Pekg kol a kil kalpis pa pati, kol a wor.” ");
INSERT INTO urim_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tu al okipma pa rka pa, Sisas kil awi okipma pa, uk wor Maur Wailen pa, atom kil kapor uk tu watnom alkil pa la tu il. Kil lanaken la, “Kil num alkupmen. Kipm uwi il o!” ");
INSERT INTO urim_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kil awi u wain kaimungen pa, uk wor Maur Wailen pa, atom kil uk tu watnom alkil pa la tu il. ");
INSERT INTO urim_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Atom kil lanaken la, “Walmpopm akupmen kil mpa ungkwan ik rmpen kipm wrong kin kipman pa, kol kla weten a Maur Wailen lam nampokgen kipm pa. ");
INSERT INTO urim_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kupm lanakepm aklale la, kupm ikgake il u wain ur ik wang ti kai, ngko wang a ikga Maur Wailen kil ikglen kweikwei wrongkwail pa pipa, ikga kupm il u wain weten pa.” ");
INSERT INTO urim_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tu ak nang wris pa plalng pipa, tu kaino wrik nangen Olip. ");
INSERT INTO urim_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sisas kil lanaken kolpa, “Kipm plalngten ikga utnurngkopm, kol a wrkapm a Maur Wailen la pa la, 'Maur Wailen ikga kil ilm melnum a atnen manto walkg malkgu pa, atom manto walkg malkgu pa ikga ngkirk kai tutu palpa.' ");
INSERT INTO urim_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ikg a kupm wrekg i kirk pa or eptepm kai kaino rpmi kaino Kalili.” ");
INSERT INTO urim_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita akalmpe ok a kil pa kolpa la, “Tu wrongkwail pa ikga utnurngkeitn pake, kupm ti pa ikga kalpis.” ");
INSERT INTO urim_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Sisas akalmpe ok a Pita pa kolpa, “Pita, kupm lanakeitn aklale wrisen, mpa ik mining ti karek la nti ur plalng pa wa itni i i wa la nti ur pipa, mpa kitn lam nang akupmen pa nti wraur.” ");
INSERT INTO urim_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ari Pita akalmpe ok a Sisas pa titnongket la, “Kupm ikga ake lam nang akitnen pa, kalpis. Kupm ikga imo nimpokgenteitn!” Tu watnom pa kimeket am wa anel la katila ok kol a Pita la pa. ");
INSERT INTO urim_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tu kai wrik ur a tu namput la Ketsemani, atom Sisas lanaken la, “Kipm rpmi pa, a kupm mpa kai oklala niki Yan alkupmen.” ");
INSERT INTO urim_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Atom Sisas kil awi Pita, Semis, Son nampokgentel, tunteng kai. Nikgwalpm a kil pa no ros kalkuten paipm wrisen. ");
INSERT INTO urim_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Atom kil lanaken la, “Ipma a kupm kil kalkut paipm wrisen ai kolen la kupm a imo, ti kipmteng mongklan kolpa rpmi ti!” ");
INSERT INTO urim_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kil kai watinet waiketnketn, atom kil angko rpma kanokg pa oklala naki Yan alkilen pa la, “Kol ya ur itni pipa, kol a kitn ungkwan wang paipm ti kai tukuleikgentopm!” ");
INSERT INTO urim_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wa kil la, “Yaiyai, kweikwei wrongkwail antiwe a kitn antokg, ti kitn ungkwan kalkuten kil kai tukulelkgtopm! Kupm ti la tuwa, ake kwei ur a kupm ti, kupm kutnun wasrongen alkitnen pake.” ");
INSERT INTO urim_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Atom kil yaper kul ari tunteng watnom alkilen pa, ari tunteng okg rmpa a pa. Atom kil lanaki Pita pa la, “Saimon, kitn okg eng na? Akentiwe mpa kitn rpmi kwa ti watinet ketnketn ur? ");
INSERT INTO urim_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Wrekg rpmi mongklan oklala niki Maur Wailen, eng ake mpa kipm ngko kai kalkuten eng kuina ur mpa ningkailepm eng kipm ngko pa. Nikgwalpm a melnum pa arkekgen la itni titnongket tulpulng kalkuten pake, numpwam ti ake antiwe titnongket a talpulng pa.” ");
INSERT INTO urim_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Wa kil wa kai anti ur oklala naki Maur Wailen pa katila ok kol a wet kil oklala ep pa. ");
INSERT INTO urim_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Atom kil yaper kul ari watnom alkilen pa, ari tunteng pa okg rmpa a pa. Wulmpa a tunteng pa kalkut paipm la tunteng la okg rmpi pen, ti tunteng ake ariwe mpa tunteng ikilmpe kuina ur a Sisas la pa. ");
INSERT INTO urim_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Atom kil wa atnuurngken wa yaper kai oklala naki Maur Wailen pa wa anti ur ti pa anti wraur tike, plalng pipa, kil wa yaper kul atom kil aro ikgyokgel tu watnom pa kimeket, atom asen la, “Wa kipm okg rmpa wrisen eng na? A pake, wang am kul wreren tike! Kipm ri, Warim Kipman a Melnum pa am elng kai wam a tu melnum paipm tike. ");
INSERT INTO urim_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kipmteng wrekg eng tepm kai om! Melnum a uk kupm ti kai wam a tu wrong manto pa am kul wrerento tike.” ");
INSERT INTO urim_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sisas kil la yangkipm ok pa itna, ari Sutas melnum wris ur a tu watnom wampwam yikakwekg alkilen pa kil kul kolti, a tu wrong wailet tu aye yo, aye wri a aye sakal wri pa tu kunturng kul katnuntel. Tu ipma krakgen tukgunakgen a Maur Wailen, a tu melnum a aroaro wonel tu yangkipm a Moses, a tu mring man wailen wailen, tu ukwawen eng la tu kul. ");
INSERT INTO urim_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Melnum a la mpa uk Sisas kai wam a tu wrong manto pa mpa kil elng kla ur elngitni eng mpa tu riwe la melnum ampake. Kil lanaken kolpa la, “Kipm ri melnum a mpa kupm rkul nikron pa pati, melnum ampake. Kipm wampirpmewel ikglen riworwor iye kai o!” ");
INSERT INTO urim_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tu kai palng pa, Sutas kil kai nakron Sisas atom lanakel la, “Melnum a kaling plan men.” ");
INSERT INTO urim_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tu ari melnum a kil nakrontel pa atom tu kul arkulel angkli wampel titnongket. ");
INSERT INTO urim_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Atom melnum ur a itna wrerentel pa kil nalu sakal wri kai apm alkil ti no kolti, laik ak wangket nungkulkg wompel a melnum ur a aken kwap orngwatneikgen melnum tukgunakg a itna ep eng tu ipma krakgen kimeket pa. ");
INSERT INTO urim_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Atom Sisas kil lanaken kolpa la, “Kipm awi sakal wri a yomis pa aye kul eng kipm la ik ilm melnum ikgwampet ur alkipm a itna kol ti? ");
INSERT INTO urim_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Pekg kipm karken arkulopm ak wang a kupm kaingkai antiwepm itna angkli yangkipm a Maur Wailen itna kawor yipmingki wunen a yalming a Maur Wailen pa? Kupm la tuwa, yangkipm a Maur Wailen a nira ela wrkapm am palng aklale tike.” ");
INSERT INTO urim_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Sisas la kolpa plalng pipa, tu watnom alkilen a kil aroaro wonel pa atnuurngkel itna pa, a tu am anel ngkark kaingkai ike. ");
INSERT INTO urim_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Melnum warimpen ur pa kil aning apm ute tangkoren kolti, ake kil nowe apm ur pa, kil wa katnun Sisas kai atom tu antokg la rkulel. ");
INSERT INTO urim_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ari kil atnurng apm ute alkil pa akukewen itna pa a kil am ngkark numpalpen kai ike. ");
INSERT INTO urim_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tu awi Sisas aye kai eng melnum tukgunakg a itna ep eng tu ipma krakgen kimeket. Atom tu ipma krakgen a Maur Wailen a pekg itna tukgunakgen, a tu melnum wailen wailen, nampokgen tu melnum a aroaro wonel tu yangkipm a Moses pa tu wa wli rka wris. ");
INSERT INTO urim_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita kil angklokg wang katnukg katnukg katnun Sisas pa kai kawor yipmingki wunen a wan a melnum tukgunakg a itna ep eng tu ipma krakgen kimeket pa. Kil rpma arkgin wakg pa nampokgen tu melnum wantengkwang. ");
INSERT INTO urim_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tu melnum ipma krakgen tukgunakgen a Maur Wailen nampokgen tu melnum a aye tamtimpal tu akor yangkipm yiprokgen ur a Sisas antokg pa eng tu la ilmpel imo. Ari ake tu ansil yangkipm yiprokgen ur a kil antokg pa kalpis. ");
INSERT INTO urim_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tu wailet tiur arkiwel yangkipm kalpmilel, pake ake tu la kai or wris aklale. ");
INSERT INTO urim_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Atom tu tiur pa wrekg itna la yangkipm kansil kai arki Sisas pa kolpa la, ");
INSERT INTO urim_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","”Men atning kil la kolpa, 'Ikga kupm tikale yalming a Maur Wailen kil a pekg tu melnum ale pa, pake pa ikga kupm le yalming weten ur pa ik wang wraur kolti, pa ikgake ik titnongket a melnum a kanokg ti le pa.'” ");
INSERT INTO urim_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ari yangkipm ok a tu la pa ake wa yangkipm ok ur la kai or wris. ");
INSERT INTO urim_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Atom melnum tukgunakg a itna ep eng tu ipma krakgen kimeket a Maur Wailen pa kil wrekg itna kuin a tu pa asen Sisas pa la, “Karken a kitn akalmpe yangkipm ok ur a tu arkiweitn pa?” ");
INSERT INTO urim_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sisas kil tarng itna kolti, ake kil akalmpe yangkipm ur. Melnum tukgunakg a itna ep kil asentel anti ur la, “Kitn Krais, Warim Kipman a Maur Wailen a mentepm kapor kilko aleinsel aki?” ");
INSERT INTO urim_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Sisas kil akalmpe kolpa, “Am kupm tike. Ikga kipm ri Warim Kipman a Melnum ikga kaino rpmi wam wi a Maur Wailen a antiwe titnongket pa ikglen kweikwei wrongkwail. Ikga kipm ri kil ingkaino kitnong pa nar nimpokgen waipmunu.” ");
INSERT INTO urim_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Melnum tukgunakg a itna ep kil atning yangkipm a Sisas la kolpa, atom kil aro apm alkilen pa la, “Men akentiwe mpa itning yangkipm ok ur. Yangkipm pa am kai itna kolpake. ");
INSERT INTO urim_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kipm atning ike, wuten kil la paipmel Maur Wailen. Ti kipm akwonalmpen kolai?” Tu plalngten la kolpa la, “Kil antokg paipm, kolpa ti ilmpel imo wo!” ");
INSERT INTO urim_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Atom tu tiur ungkwa wlikgel Sisas. Tu yapowel wulmpa pa, a tu orel, a tu asentel la, “Atom kitn la ri, wuten mla oreitn?” Atom tu melnum wantengkwang pa tu awiyel aye kai orel. ");
INSERT INTO urim_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita kil rpma kinar akapm a yipmingki wunenen pa, kin wris ur a aken kwap orngwatneikgen melnum tukgunakg a itna ep ikgalen tu ipma krakgen a Maur Wailen pa, kil kul. ");
INSERT INTO urim_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Atom kil ari Pita pa arkgin wakg pa rpma. Kin pa ikatnentel titnongket a kil la, “Kitn ti yat, kitn pekg rpma nampokgen Sisas a Nasaret.” ");
INSERT INTO urim_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ari Pita kil la, “Kalpis, kupm akwekgel yangkipm a kitn la pa.” Kolpa atom kil wrekg kai or wanyun pa kai eng a kawor en pa pipa, karek pa la. ");
INSERT INTO urim_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Am kin pa wa kil ari Pita pa anti ur, atom wa kil lanaki tu melnum wailet a itna pa la, “Ti melnum ur atuwen am tike!” ");
INSERT INTO urim_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ari wa Pita pa lala, “Kupm ti kalpis.” Itna waikenketn pipa, tu melnum a itna wrerentel pa lawel antiur, “Aklale, kitn melnum ur atuwen am tike! Men atning ok kromeng akitnen pa kol a tu Kalili.” ");
INSERT INTO urim_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ari Pita aner ok paipm la, “Kupm naren Wailen la kupm la yangkipm aklale, kupm akwekgel melnum ur a kipm la pa.” ");
INSERT INTO urim_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Atom wa karek pa wa la anti ur, atom Pita kil akwonalmpen yangkipm a pekgkil Sisas lanakel pa la, “Mpa karek la nti ur plalng wa itni i i, wa la wa la nti ur pipa, mpa kitn lam nang akupmen pa nti wraur.” Atom Pita kil akg arein wail. ");
INSERT INTO urim_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ak kong miningket ai tu ipma krakgen tukgunakgen a Maur Wailen, tu melnum wailen wailen, nampokgen tu melnum a aroaro wonel tu yangkipm a Moses, a tu melnum wailen wailen kimeket mapming a ikgalen tu Suta pa, tu la yangkipm pa kai itna wris, plalng pipa, tu ak ampei pa yapo Sisas pa ayewel kai wam a Pailat, mringman a Rom kil kul rpma ikgalen tu Suta. ");
INSERT INTO urim_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat kil asentel la, “Kitn pa melnum tukgunakg a kipm Suta aki?” Sisas kil akalmpe la, “Kolpa ok a kitn pa la pake.” ");
INSERT INTO urim_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tu ipma krakgen tukgunakgen pa tu ak akorel kalpmilel. ");
INSERT INTO urim_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pailat kil asentel anti ur la, “Ake kitn akalmpe yangkipm ok ur a tu ti asenteitn ti? Ake kitn atning a tu la almpetn yangkipm watipmen ti!” ");
INSERT INTO urim_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ari Sisas ake akalmpe yangkipm ok ur, kolpa atom Pailat kil akwonalmpen watipmen. ");
INSERT INTO urim_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Akangklei wring wris wris ak wang wail a men akwonalmpen a pekg Maur Wailen ak awi tu amenen aye kul takuleikgen tu Isip pa, Pailat kil elngen melnum ur a rpma wan tipmining pa kul or en. Tu wrong kin kipman tu la nang a melnum wris ur pa atom Pailat kil elngen melnum pa kul or en. ");
INSERT INTO urim_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ak wang pa melnum ur pa, nang akilen pa Parapas, nampokgen tu melnum tiur pa, tu rka wan tipmining. Pekg tu wrekg la ungkwan tu Rom pa atom tu or tita, atom tu tiur am pekg tu alm amo ike. ");
INSERT INTO urim_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Atom tu wrong kin kipman pa tu wli eng Pailat eng la kil elngen melnum wris ur pa kul or en, kol a kil antokg akangklei wring wris wris pa. ");
INSERT INTO urim_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailat kil akalmpe ok a tu pa kolpa, “Kipm wasrongen la kupm elngen melnum tukgunakg akipmen Suta ti eng kil kai?” ");
INSERT INTO urim_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat kil ariwe la, tu ipma krakgen tukgunakgen a Maur Wailen tu nikgwalpm paipm eng Sisas pa, kolpa atom tu elng Sisas kai wam akilen. ");
INSERT INTO urim_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tu ipma krakgen tukgunakgen a Maur Wailen tu tirpmingen tu wrong kin kipman eng la tu elng ok itni wris laniki Pailat pa la kil elngen Parapas pa kul or en. ");
INSERT INTO urim_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat kil lanaken anti ur kolpa, “Ti mpa kupm ntokg kolai melnum ti a kipm akwewel la kil melnum tukgunakg a la ikglen kipm Suta pa?” ");
INSERT INTO urim_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tu elng ok itna wris la yikakatnen la, “Kurkurngkel rki yo okgmangki!” ");
INSERT INTO urim_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Atom Pailat kil akasenten la, “Kil antokg kuina paipm?” Ari tu la titnongket paipm la, “Kurkurngkel rki yo okgmangki!” ");
INSERT INTO urim_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat kil la armponel tu wrong kin kipman, kolpa atom kil elngen Parapas pa kai. Sisas pa kil elngen kai wam a tu melnum a almpwrong pa eng ak ampei iket ntrawel, plalng pipa, tu ayewel kai eng la kurkurngkel rki yo okgmangki. ");
INSERT INTO urim_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tu anti Sisas antokg yangkipm pa plalng pa, tu awiyel a wan pa kulor itna yipmingki wunen a tu melnum a almpwrong atne pa. Atom tu akwe tu wrongkwail a almpwrong pa tu kul itna. ");
INSERT INTO urim_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tu nowewel apm watet wail ur pa kol tu melnum wail wail nowe pa, atom tu wale ampei iket pa elngtirmpa tukgunakg a kil pa. ");
INSERT INTO urim_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tu kai itna atom tu la akinowel Sisas pa la, “Men alkeitn wor, kitn melnum tukgunakg a ikgalen kipm Suta itni wang watin!” ");
INSERT INTO urim_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tu orel ak yo kai tukgunakg a kil pa, atom tu ungkwa wlikgel. Tu kapor kilko alein a akinoalmpel. ");
INSERT INTO urim_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tu la paipmel kil plalng pipa, tu aner apm watet kai num a kil pa atom tu awi apm alkil pa nowewel kai num kil pa. Atom tu awiyel aye kai eng la kurkurngkel rki yo okgmangki. ");
INSERT INTO urim_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Saimon, melnum ur a Sairini, yan a Aleksanter ekg Rupus, kil angkai wring pa kul la kil a kai anong. Atom tu melnum a almpwrong tu ansilel angko ya pa, atom tu la titnongket la kil ngkit yo okgmangki a Sisas pa iye. ");
INSERT INTO urim_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tu awi Sisas aye kai wrik ur a tu namput la Kolkota. Yiprokgen a wrik nang pa pati kolpa: tukgunakg timpal. ");
INSERT INTO urim_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tu la uk Sisas u wain tiur a arongke nampokgen kweikwei kupuk kupuk pa ari ake kil al. ");
INSERT INTO urim_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tu karkurngkel rka yo okgmangki. Atom tu awi apm akilen pa elngkirmpa. Tu nalu yo ipik eng mpa ri la mpa mla a i uwi apm kuina kuina pa. ");
INSERT INTO urim_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Takgni al num wleket pa, tu karkurngkel rka yo okgmangki. ");
INSERT INTO urim_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ela kaino yo okgmangki kwa pa tu nira yangkipm yiprokgen a pekg kil antokg pa. Tu nira kolpa: Melnum tukgunakg a ikgalen tu Suta. ");
INSERT INTO urim_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Melnum wekg a antokg paipm pa tu karkurngken nampokgen Sisas, ur rka kai wam wi, a ur rka kai wam wangkokg. ");
INSERT INTO urim_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kol yangkipm ur a ela kai wrkapm tingklaket a Maur Wailen pa am palng ok arke tike. Yangkipm pa kolpa: “Tu namputel nang nampokgen tu melnum paipm.” ");
INSERT INTO urim_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tu wrong kin kipman kaingkul angkli wulmpa pa elng kaino ariwel atom tukgunakg wilwil a ak nokgel Sisas pa la, “A, kitn melnum a pekg la tikale yalming a Maur Wailen, plalng pa, wa le ik wang wraur, ");
INSERT INTO urim_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","kolpa ti kitn ngklin kitn alkitn ti utnurng yo okgmangki ti nar kanokg ti ri!” ");
INSERT INTO urim_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tu ipma krakgen tukgunakgen a Maur Wailen nampokgen tu melnum a aroaro wonel tu yangkipm a Moses pa, tu yat tu la paipmel Sisas pa naki tita kolpa, “Kil pekg angklin tu wrong kin kipman tiur ai, pake kil akentiwe mpa ngklin kil alkil ti. ");
INSERT INTO urim_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Krais melnum tukgunakg a ikgalen men wrong kin kipman a Isrel ti kil nar kanokg ti ri, eng mpa mentepm ri, ukipma kil pa!” Melnum wekg a tu karkurng nampokgen Sisas pa tuwekg wa la paipmel kil pa yat. ");
INSERT INTO urim_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Takgni no pirng pa, mining pa kul kai ak upaarng kanokg ti yela, itna a a, kai nungkurikg. ");
INSERT INTO urim_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nungkurikg ti pipa, Sisas kil akwe yikakatnen la kolpa, “Eloi, Eloi, lama sapaktani.” Pa la kolpa: “Maur Wailen akupmen, Maur Wailen akupmen, kitn atnurng kupm ti eng ntei?” ");
INSERT INTO urim_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tu melnum tiur a itna wreren kil pa, tu atning ok a kil akwe pa, atom tu la, “Kipm itning, kil akwe Elaisa aki?” ");
INSERT INTO urim_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Melnum ur pa pirng kai elng kweikwei ur kolen nok ing pa angklewe u wain kinipis pa elntitna wark pa aye kaino uk Sisas eng la kil rkolng il. Melnum pa la, “Itni pen, eng mentepm ri la mpa Elaisa uwiyel iye nar kanokg ti aki kalpis.” ");
INSERT INTO urim_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Sisas kirkar yikakatnen kolti, kil nol angkon. ");
INSERT INTO urim_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Apm kaki wail a tu alekg rka ak angketen yalming tiwel a Maur Wailen pa rakol wompwekg angkaino kwa wai elngen kinar kanokg ti. ");
INSERT INTO urim_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Melnum tukgunakg a ikgalen tu melnum kamel wampwomis a almpwrong pa kil itna wreren ari Sisas amo kolpa, atom kil la, “Aklale wrisen, melnum pa Warim Kipman a Maur Wailen.” ");
INSERT INTO urim_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tu kin tiur pa itna kai watinet ai ikatnen itna. Kin ur a anti tu pa itna pa, nang alkilen pa Maria a Maktala. Wa ur pa Maria, man a Semis, wusok a Sosep. Wa ur pa Salome. ");
INSERT INTO urim_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tu kin pa katnun Sisas angklinsel okipma kweikwei ak wang a kil rpma Kalili. Tu kin watipmen tiur pa rka. Pekg tu kul Serusalem nampokgen Sisas. ");
INSERT INTO urim_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ikgkil pa wang wail a rpma eng yapm. Wang weti pa wang a numprampen kweikwei pake. ");
INSERT INTO urim_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ak nungkurikg pa Sosep a Arimatea kil kai ari Pailat. Kil ake ngkark, kalpis. Kil asentel la kil a uwi yipmiri a Sisas. Sosep kil melnum a aye tamtimpal a anti tu mring man wail wail rpma atning atning yangkipm, atom tu wrong kin kipman kaporng yangkipm la kil melnum wor. Kil yat kil rpma nungkwangen la Maur Wailen kil ikglen nol nikgwalpm akilen. ");
INSERT INTO urim_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Sosep kil asentel kolpa atom Pailat kil akwonalmpen watipmen la, “Sisas kil amo aki kil rka?” Atom kil akwe melnum tukgunakg a ikgalen tu melnum kamel wampwomis a almpwrong pa kul asentel la, “Sisas amo aki kalpis?” ");
INSERT INTO urim_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Atom melnum tukgunakg a ikgalen tu melnum kamel wampwomis a almpwrong pa lanaki Pailat pa la, “Sisas amo ike.” Atom kil awi wor la Sosep kil uwi palk a Sisas pa iye kai. ");
INSERT INTO urim_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sosep kil armpen apm tangkoren watinet ur pa aye kai elngtirmpa. Kil ngkat palk a Sisas pa aye nar kanokg ti atom ak apm pa ak yapowel. Plalng pipa, kil ngkat aye kawor rmpa kirk ur a pekg kil u mlamin kai wrik krongen pa eng kil alkil pa. Atom kil talpul wes pa kai ak tikrawin lkim ok a u mlamin pa. ");
INSERT INTO urim_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria a Maktala nampokgen Maria, man a Sosep, tuwekg itna ari wrik a kil aye Sisas kawor armpe pa. ");
INSERT INTO urim_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Wang wail a mentepm rpma eng yapm pa kai plalng pa, okg or kong, wang a itna ep a wang wampwomis wampwompwekg. Salome, Maria a Maktala, a Maria, man a Semis, tunteng armpen kweikwei yaprekget la ik inel palk a Sisas. ");
INSERT INTO urim_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Atom am tunteng aye ak kong miningket ai kai kirkap ike. ");
INSERT INTO urim_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tu akor la tatu ya pa kai la, “Wes pa wail paipm ai. Mla mpa ntiwo eng tulpul wes pa tukulelkg mlamin ok pa?” ");
INSERT INTO urim_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tunteng ikg kai ari, wes pa am wet melnum ur talpul takwlelkg mlamin ok pa ike. ");
INSERT INTO urim_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Atom tunteng kai kawor kirk wunen a tu u mlaminel ai ari melnum ur a nowe apm tangkoren pupup watinet ur pa rpma wam wi pa, atom tunteng tutusraing. ");
INSERT INTO urim_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Atom melnum pa lanaken la, “Ampur kipm ngkark. Kupm ariwe kipm la ikor Sisas kai Nasaret, melnum a pekg tu karkurngkel rka yo okgmangki. Ake kil rmpa ti, kil am wrekg ike. Ti kipm ri wrik kalpmilel a pekg tu elngkel rmpa ti. ");
INSERT INTO urim_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ti kipm kai niki tu watnom alkilen a kil aroaro wonel pa nimpikgen Pita pa yat la, kil am ep kaino anong kanokg a Kalili ike. Ti kipm kai o, mpa kipm riwel kaino anong kanokg pake, kol pekg kil lanakepm ep pa.” ");
INSERT INTO urim_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tunteng atning yangkipm a kil la pa plalng, tunteng atnurng kirk pa kul or en am ngkark kai ike. Tunteng ngkark warwar paipm wrisen, kolpa ti akentiwe mpa tunteng laniki melnum ur. ");
INSERT INTO urim_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mining angket wang wail a tu Suta rpma eng yapm pa kai plalng pa, or kong miningket ti pa, Sisas kil wrekg a kirk a tu u mlamin pa or. Kil palng atom Maria a anong Maktala pa ariwel ep; kin pa pekg maur paipm wampwomis wampwompwekg pa arpmewel, atom pekg Sisas ungkwan takwlelkgtel. ");
INSERT INTO urim_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tu melnum alkilen a pekg antiwel atn pa tu nikgwalpm kaikuten akg rka. Atom Maria aye yangkipm pa kai naken, la kolpa, ");
INSERT INTO urim_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Kupm ari Sisas am wrekg ike.” Tu atning yangkipm a kil la pa, ari ake tu ukipma. ");
INSERT INTO urim_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Melnum wekg wet atning yangkipm a Maria lanaken pa, tuwekg atnurng anong wail pa kinar angko ya, atom Sisas palng tuwekg ariwel ari palng manet. ");
INSERT INTO urim_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tuwekg aye yangkipm pa yaper no naki tu melnum a pekg anti Sisas atn pa ari ake tu atning yangkipm a tuwekg la pa. ");
INSERT INTO urim_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Katnukg pa Sisas wa palng ari tu watnom wampwam yikak wris alkilen a kil aroaro wonel a al okipma rka pa. Atom kil aklewen la, “Ake kipm ukipma. Ipma akipmen ti kakiren paipm ai, ti ake kipm atning yangkipm a tu pekg ariwopm la kupm am wrekg ike.” ");
INSERT INTO urim_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Atom wa kil wa la, “Kipm kai ngkli yangkipm wor a Maur Wailen ti niki tu wrong kin kipman yela kanokg pa! ");
INSERT INTO urim_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kol melnum ur kil ukipma atom kipm kulukel pa, mpa Maur Wailen kil ikuwiyel pa. Kol melnum ur ake ukipma pa, kil angkom or ya a kai anong paipm kolpa kai. ");
INSERT INTO urim_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Melnum a ukipma pa, mpa Maur Wailen lkel kla alkil pa eng kil ik ntokg kweikwei ik plan titnongket a Maur Wailen pa. Ikga kil lken kla kolkil: ikga tu naren kupm ti atom ik ungkwan maur paipm, wa tu ikga oklala ik ok manet manet a tu ake awi ariwe pa a palng la wli ok a tu ti. ");
INSERT INTO urim_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kol tu rkul ul paipm aki tu il kweikwei paipm paipm a alm melnum amo pa, akentiwe mpa tu imo, kalpis. Kol tu elng wam ele tu melnum a numpet pa, ikga tu palng wor.” ");
INSERT INTO urim_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Wailen Sisas kil la yangkipm pa naki tu watnom alkilen a kil aroaro wonel pa plalng atom Maur Wailen kil awiyel aye kaino kitnong. Atom tuwekg rpma ikgalen kweikwei wrongkwail pa. ");
INSERT INTO urim_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tu watnom alkil a kil aroaro wonel pa tu kai angkli yangkipm yela tatu palpa. Wailen kil ak kwap nampokgenten, elng kla a ak plan titnongket a Maur Wailen pa eng ak titnongketel yangkipm a tu angkli pa. ");
INSERT INTO urim_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Melnum Wailen Tiopilus! Kupm ari tu melnum watipmen asen atning ariworwor, atom tu nira kweikwei kwap wrongkwail a pikekg palng ep, a men ariwe la pa aklale, atom men ukipma. ");
INSERT INTO urim_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kuina ur a tu nira pa, tu atning kai ok a tu melnum a pikekg ari kweikwei a pikekg palng ep ai, atom tu lakati nako, pa am tu melnum akwapel a laron yangkipm a Maur Wailen am pake. ");
INSERT INTO urim_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kupm alkupm kil wa akor asen atning yangkipm pa yek kimeket kai itna yiprokgen ai. Atom kupm akwonalmpen ari pa wor eng kupm, la mpa kupm nira wrkapm kil kitila yangkipm pa kimeket riworwor eng kitn, Melnum Wailen Tiopilus. ");
INSERT INTO urim_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kupm ak kolpa eng mpa kitn uwi riwe worwor yangkipm a kweikwei a pikekg tu lakati a kaling planteitn pa, la pa aklale. ");
INSERT INTO urim_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ak wang a pikekg Erot itna melnum tukgunakg ikgalen anong kanokg a Sutia pa, melnum ipma krakgen ur a ak ak kwap eng al wor uk Maur Wailen, nang akilen pa Sekaraia, kil melnum ipma krakgen ur a akwap itna mapming a Apia. Sekaraia nampokgen kin alkil Elisapet pa tuwekg yatenen palng a om a melnum ipma krakgen Aron pa. ");
INSERT INTO urim_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tuwekg pa, ipma a tuwekg pa ute wor itna wulmpa a Maur Wailen, wa tuwekg katnun yangkipm titnongket wrongkwail a Wailen, a tuwekg ake wa plan paipm ur pa kalpis. ");
INSERT INTO urim_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisapet pa kimpong, atom tuwekg ake wa angket warim ur, kaingkai, tuwekg am wror mayen ise. ");
INSERT INTO urim_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wang wris ur pa Sekaraia kil ak kwap alkil a melnum ipma krakgen pa itna yalming a Maur Wailen. Pa wang a mapming a Apia a akwap itna yalming pa. ");
INSERT INTO urim_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Atom tu klasinen wes pa awi awi ari eng la mla a i a i mpa ikwap na na pa katila ya a tu ak eng ampreingen kwap pa. Atom Sekaraia pa awi a lap kweikwei yaprekget wor wor itna kawor wan yalming ok klalen pa. ");
INSERT INTO urim_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kil kawor lap kweikwei yaprekget wor pa itna pa, tu wrong wailet a wli rka wris kawor en pa, tu kapor kilko alein, a oklala naki Maur Wailen pa rka. ");
INSERT INTO urim_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ak wang ketn pa maur akwapel ur a Maur Wailen, kil palngtel itna wam wi yamping a tipmakg a kil lap kweikwei yaprekget wor atnewe pa. ");
INSERT INTO urim_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraia kil ariwel kolpa kil wrekg paipm ngkark warwar kolti. ");
INSERT INTO urim_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ari maur akwapel a Maur Wailen pa lanaki Sekaraia pa la, “Sekaraia, ampur kitn ngkark, oklala a kitn naki naki Maur Wailen pa, kil atning ise. Elisapet, kin alkitnen pa, kil ikga raku warim kipman ur eng kitn, atom ikga kitn lil nang akilen pa Son. ");
INSERT INTO urim_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ti kitn ikga itopen paipm, wa tu wrongkwailet tiur ai tu ikga wa itopen wail, ik wang a man rakuwel pa. ");
INSERT INTO urim_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wa kil ikga palng melnum wailen itni wulmpa a Maur Wailen. Kil ikgake il u wain pa, aki a il u titno titnongket titnongket pa. Eng ntei, ikga warim pa rpmi kawor ipma a man pa, kil am awi Maur Wor antiwe rpma ise. ");
INSERT INTO urim_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kil ikga lok kipm wrong kin kipman wailet a Isrel pa iye yaper kul eng Wailen, Maur Wailen akipmen pa. ");
INSERT INTO urim_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A kil ikga kai ep eng Wailen, kil ikga ntiwe Maur Wor, a ntiwe titnongket kolen Elaisa melnum ok wripm a Maur Wailen pikekg ep. Kil ikga lok nikgwalpm a tu yantin pa kai or wris kol nikgwalpm a tu warim alntuwen pa. Kil ikga rku ngkeng lok tu melnum a talpulng yangkipm pa uwi riwe nikgwalpm a tu melnum ute wor. Wa kil ikga numprampen tu wrong kin a kipman pa rpmi nungkwangen Wailen.” ");
INSERT INTO urim_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Atom Sekaraia kil akalmpe yangkipm a maur akwapel a Maur Wailen pa la la, “Kolpa kalpis. Kupm ti wror, wa kin akupm pa am wa mayen kolpa yat pake. Ti pa mpa kuina a i plantopm la yangkipm pa aklale pa?” ");
INSERT INTO urim_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ari maur akwapel a Maur Wailen pa akalmpe la, “Kil kupm Kepriel, kupm maur akwapel a itna wreren Maur Wailen. Kil alkil ukwawopm nar la lanikeitn yangkipm wor kil. ");
INSERT INTO urim_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ari ake wa kitn ukipma yangkipm wor a kupm la kil. Ti kitn itning, kitn mpa ok mise kolpa kai ngko wang alkilen a yangkipm pa kai ok rke ai.” ");
INSERT INTO urim_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Atom ak wang pa tu wrong ak wail pa arkentel rka yipmingki wunen a yalming pa nungkwangen Sekaraia pa akwonalmpen watipmen la, antokg kolai atom kil ti rpma wang watinet kawor wan yalming ok a Maur Wailen ti. ");
INSERT INTO urim_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kil angkawor yalming wunen pa or pa, kil ake antiwe a oklala anti tu pa. Pake tu pa am ariwe ise, la kil wet ari kweikwei wet Maur Wailen plantel itna kawor wan yalming ok pa. Atom kil ak wam ti lanaken kolti, a kil am ok mise kolpa rpma pake. ");
INSERT INTO urim_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sekaraia kil akwap itna yalming a Maur Wailen pa itna, kai angko wang a tu alm pa kai plalng pa, kil wa yaper kai wan anong alkilen pa. ");
INSERT INTO urim_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wang aripm ur kai plalng pipa, Elisapet kil am itna ise. Atom kol kainil wampwomis pa kil ake or angko en pa, kalpis. Kil atopen la la, ");
INSERT INTO urim_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Wailen kil arein kupm ti, atom kupm awi warim ti rpma ipma ti, kolpa atom kil ungkwan numpaipm akupmen ti itna wulmpa a tu wrong kin a kipman pa.” ");
INSERT INTO urim_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisapet kil itna kainil wampwomis wampwompwris, atom ak kainil pa Maur Wailen kil ukwa maur akwapel alkil Kepriel pa kil nar kai Nasaret, anong ur a anong kanokg Kalili. ");
INSERT INTO urim_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kil aye yangkipm ur kai la laniki kin warimpen ur a ake atn nampokgen kipman ur. Kin pa pati pikekg tu ak namputen kipman ur a tu namput la Sosep, kil om wris a Tepit. Nang a kin warimpen pa Maria. ");
INSERT INTO urim_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maur akwapel a Maur Wailen pa kil palng eng kin pa atom kil la, “Maria, alkeitn wor! Kitn pa Maur Wailen planteitn ipma wor ak angklinseitn wail manten, Wailen antiweitn rpma.” ");
INSERT INTO urim_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria kil wrekg titnowen num eng atning yangkipm a maur akwapel a Maur Wailen pa lanakel pa, atom kil akwonalmpen watipmen la, yiprokgen a oklala a kil la ukwor kolpa pa kil la eng itna kolai? ");
INSERT INTO urim_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ari maur akwapel a Maur Wailen pa lanakel la, “Maria, ampur kitn ngkark, eng ntei, Maur Wailen kil plan ipma wor alkil ak angklin kitn. ");
INSERT INTO urim_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ti kitn itning, kitn mpa itni atom ikga raku warim kipman ur. Atom ikga kitn lil nang akilen pa la Sisas. ");
INSERT INTO urim_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kil ikga palng melnum wailen a ikga Maur Wailen a itna ep angen kweikwei wrongkwail pa numputel la kil Warim Kipman alkilen. A Wailen, Maur Wailen pa, ikga ntokg kil melnum wailen itni tukgunakg ikglen kweikwei wrongkwail, a kil ikga wa itni klangkil yoampei alkil Tepit pa. ");
INSERT INTO urim_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Atom kil ikga itni melnum tukgunakg ikglen kipm walwalpopm walyaru a Sekop ikngklei wang iye or pa kai. Kil ikgam itni tukgunakg ikglen kweikwei wrongkwail kolpa kai pake, a ikgake kai plalng.” ");
INSERT INTO urim_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria kil atning a maur akwapel a Maur Wailen la kolpa, atom kil akalmpentel la, “Kupm ti ake atn anti kipman ur pa, ti mpa wa kupm palng kol a i kol a kitn la pa?” ");
INSERT INTO urim_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ari maur akwapel a Maur Wailen pa akalmpentel la, “Maur Wor a Maur Wailen mpa nar kawor ipma akitnen, a titnongket a Maur Wailen a itna ep angen kweikwei wrongkwail pa mpa ik aureitn. Kolpa ti warim a ikga kitn raku pa, Maur Wailen amprin elngkitna manet, atom ikga tu numputel la Warim Kipman a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ti kitn itning, kin om wris alkitnen Elisapet pa, kil am mayen ise. Tu pikekg lawel la kil kimpong ari kil am itna kainil wampwomis wampwompwris tike, atom kil ikga raku warim kipman ur. ");
INSERT INTO urim_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Eng ntei, ake kwei ur wonet eng Maur Wailen ti.” ");
INSERT INTO urim_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Atom Maria pa akalmpentel la, “Am ntei, kupm kin akwapel a Wailen, ti kuina ur a wuten kitn la la mpa palng kul kupm ti pa, kupm awi wor kolti.” Atom maur akwapel a Maur Wailen pa atnuurngkel kai. ");
INSERT INTO urim_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wang aripm ur kai plalng pa, Maria kil numprampen kolti, kil wrekg atatu kinar kai kaino anong kanokg nangen Sutia, atom kil kai anong a Sekaraia a Elisapet arpme pa. ");
INSERT INTO urim_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Atom kil kai kawor wan a Sekaraia pa, atom kil kai arkul nakron Elisapet pa, a kil alkel wor. ");
INSERT INTO urim_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ak wang a Elisapet kil atning a Maria kil alkel wor pa, warim pa alm num kawor ipma wunen a kil pa, wa Maur Wor pa akwap titnongket kai Elisapet pa, ");
INSERT INTO urim_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","atom kil la yikakatnen la, “Kitn pa Maur Wailen planteitn ipma wor angklinseitn angen tu kin tiur ai, wa kil wa plan ipma wor angklin warim ipmawen a rpma ipma a kitn pa yat. ");
INSERT INTO urim_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Antokg kolai atom mpa wa kitn man a ikga raku Melnum Wailen a kupm ti wa kul ari kupm kin a kol ti! ");
INSERT INTO urim_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ti kitn ri, ak wang a kupm atning ok a kitn alkopm wor nakrontopm pa, warim a rpma kawor ipma akupmen pa kil alm num atopen wail. ");
INSERT INTO urim_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kitn pikekg ukipma yangkipm a Wailen la pa la, pa ikga palng ok rke iklale, kolpa ti kitn pa wor pake, kitn itopen o!” ");
INSERT INTO urim_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Elisapet kil ngkat nang a Maur Wailen kolpa kai plalng pipa, wa Maria kil wa la kolpa la, “Ipma akupmen pa ngkat nang a Wailen. ");
INSERT INTO urim_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Maur wor akupmen pa atopen Maur Wailen, melnum akupmen a akawiyopm. ");
INSERT INTO urim_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Eng ntei, kil pikekg akwonalmpentopm, kupm kin ur a nang kalpisen a akwap orngwatneikgen kil. Atom ik wang ti iye or pa kai pa, tu wrong kin kipman ikga uwi wor lawopm la, kupm pa wor pake, eng ntei, Maur Wailen uk ipma wor kupm ti. ");
INSERT INTO urim_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Eng ntei, kil antiwe titnongket wail, atom kil antokg kweikwei wail manten eng kupm ti. Nang a kil pa klalen wakget. ");
INSERT INTO urim_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kil plan ipma wor a kil pa arein tu melnum a ngkark eng kil. A ikgam wa itna kolpa kai eng tu watnom walpopm walyaru pa aye or pa kai pake, pikekg, ak wang ti, a wa ikga ik wang kutnukg. ");
INSERT INTO urim_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A kil plan titnongket wail akilen eng tu wrong kin kipman ari, a kil ungkwan tu melnum a akwonalmpen la tu ti melnum wailen pa ngkark pumprarng kai tatu palpa. ");
INSERT INTO urim_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kil wam kai arkolng nalu tam timpal a tu melnum wailen wailen a itna tukgunakg pa aye kai takuleikgen atom tu itna nang kalpisen. A kil ngkat nang a tu melnum a nang kalpisen pa, aye kaino kwa. ");
INSERT INTO urim_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kil uk kweikwei wor wor tu melnum a nikgalmpen pa, a kil ukwa tu melnum a antiwe kweikwei pa, tu angkompwam kaingkai. ");
INSERT INTO urim_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Yangkipm a kil pikekg yapon nampokgen tu walyipmiri wapyipmiri amentepmen pa kil ake woniketen, kil alupm rpma pa. Kolpa atom kil plan ipma wor alkil pa arein mentepm Isrel, mentepm wrong kin kipman akwapel akilen. ");
INSERT INTO urim_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Am kol a pikekg kil yapon yangkipm naki tu walyipmiri wapyipmiri amentepmen pake, Apraam pa nampokgen walwalpopm walyaru alkil kolpa aye kul pa, la kil ikga planten ipma wor alkil pa reinsen ikngklei wang or pa kai.” ");
INSERT INTO urim_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Oklala a Maria pa am kai kol pake. Atom kil anti Elisapet pa rpma pa a a, kainil wraur pa kai plalng, atom kil wa yaper nar kul no anong alkil. ");
INSERT INTO urim_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisapet kil itna kolpa kai angko wang alkil a kil raku pa, kil raku warim kipman pa. ");
INSERT INTO urim_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Atom tu melnum tiur alkil a rpma wrerentel pa, a tu om wris alkil pa, tu atning a Wailen kil plan ipma arein wail manten kolpa kai eng Elisapet pa, atom tu atopen paipm nampokgentel. ");
INSERT INTO urim_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kil aye warim pa aye rpma kol wang wampwomis wampwompwekg pa kai plalng pa, wang wampwomis wampwompwraur ti pipa, tu wli la wangket numpalk a warim pa, wa tu la kol a lil nang a yan alkilen Sekaraia. ");
INSERT INTO urim_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ari man alkil pa lala, “Mpa kalpis, mpa lil nang akilen pa la Son.” ");
INSERT INTO urim_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ari wa tu akalmpentel la, “Ake tu ur kai om akitnen pa alil nang kolpa, kalpis.” ");
INSERT INTO urim_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Atom tu ak wam ti ak asen yan alkil pa la, kil wasrongen la mpa lil nang mla kai warim pa. ");
INSERT INTO urim_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ari Sekaraia kil ak wam pa lanaken la tu lkel tangkurong wompel wasek ur a nira kweikwei angkowe pa, atom kil nira nang a warim pa la Son. Tu wrongkwail tu ari pa, tu wrekg paipm. ");
INSERT INTO urim_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ak wang ketn pa Sekaraia a pikekg ok mise pa wa kil oklala, atom kil wa ngkat nang a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tu a rka anong pa tu atning a ari pa atom tu ngkark. Atom tu aye yangkipm a kweikwei a palng pa kai yela anong a ela wrik nangen a anong kanokg a Sutia ise. ");
INSERT INTO urim_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Atom tu wrongkwail atning yangkipm pa, tu alupm yangkipm pa rpma ipma alntu pa rpma. Tu ariwe la titnongket a Wailen pa ikgalen warim pa rpma, atom tu asen tita la, “Warim pa ikga palng melnum kolai?” ");
INSERT INTO urim_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yangkipm a la Son pa am ok arke ise, atom Maur Wor pa akwap titnongket kawor ipma a Sekaraia, yan a Son pa, atom kil laron kuina ur a Maur Wor ngkatel ok la kil la pa, ");
INSERT INTO urim_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","”Ngkit nang a Wailen Maur Wailen a Isrel! Eng ntei, kil narnto la ikirmpen mentepm wrong kin kipman alkilen. ");
INSERT INTO urim_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A kil ngkat melnum a antiwe titnongket a ikga ikuwiyo, melnum pa kai om a Tepit, melnum akwapel alkilen. ");
INSERT INTO urim_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kolen a pikekg kil la palng kai ok a tu melnum okwripm a pikekg kil amprin eng alkilen ep ak ai, la ikga kil ukwa melnum pa nar, ");
INSERT INTO urim_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","eng ikga kil ikuwiyo kai wam a tu wrongmanto, wa kai wam a tu melnum a ipma paipm eng mentepm. ");
INSERT INTO urim_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kil plan ipma wor akilen pa atom kil arein mentepm ti. Wa a pikekg kil alkil lam kla klalen wakget nampokgen tu walyipmiri a wapyipmiri a yoampei amentepmen pa, pa kil alupmen rpma pa. ");
INSERT INTO urim_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kil naren kil alkil ti atom kil naki Apraam, yoampei amentepmen pa la ");
INSERT INTO urim_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kil ikga ikuwi mentepm ti tukulelkgen kai wam a tu wrongmanto amentepmen, eng mentepm ikgake ngkirk, mentepm ikga wirng no kukula wor ikwap akilen pa. ");
INSERT INTO urim_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","A mentepm ikga kil mprinso eng alkilen elngkitni manet, wa mentepm ikga itn a rpmi a ikwap ute wor itni wulmpa akilen ikngklei wang a mentepm rpmi kanokg ti.” ");
INSERT INTO urim_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sekaraia ngkat nang a Maur Wailen kolpa kai plalng pa, wa kil wa la warim kipman alkil Son ti la, “Oi, kitn warim wasek yek alkupm, kitn ti ikga tu numputeitn la kitn melnum okwripm a Maur Wailen a itna ep angen kweikwei wrongkwail pa. Kitn ikga kai ep ukule ya pa numprampen eng Wailen. ");
INSERT INTO urim_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","A ikga kitn laron laniki tu wrong kin kipman alkil pa, eng tu riwe la Maur Wailen ikga ikuwiyen a ungkwan paipmpaipm atuwen. ");
INSERT INTO urim_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Eng ntei, ipma arein a Maur Wailen amentepmen pa wail manten paipm. Atom ikga kolen takgni a aro pa ingkaino kitnong pa nar lento, ");
INSERT INTO urim_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","eng uk klalen tu melnum a rka miningket, a ngkark eng amo, a loko nepm pa eng ikga mentepm ngkom or ya wor a rpma meen wor pa.” Nangnang a Sekaraia ak pa am kai plalng kolpake. ");
INSERT INTO urim_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Atom warim pa kil wrekg wail, a wontrakole nikgwalpm arke pipa, kil kai rpma wrik kalpmlel a ake melnum ur arpme pa, a a, kil wrekg a pa kil kai angko wunong tu wrong kin kipman a Isrel ariwel. ");
INSERT INTO urim_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ak wang pa Okastus, melnum tukgunakg a tu Rom pa, kil ukwa yangkipm kai la tu uwi nangkel tu wrongkwail a rka yela anong kanokg a kil alkil ikgalen pa. ");
INSERT INTO urim_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Pa pikekg ake tu awi awi nangkel tu kolpa, itna itna, tu la uwi nangkel tu wrong kin kipman ti pen. Ak wang pa Kwirinius kil itna melnum wailen a anong kanokg a Siria. ");
INSERT INTO urim_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Atom tu wrongkwail tu wrekg kai yela anong yiprokg wris wris alntuwen pa eng tu awiyen nang. ");
INSERT INTO urim_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kolpa atom Sosep yat kil wrekg a Nasaret, anong ur a anong kanokg a Kalili, wa kil la kinar Petleem, anong yiprokg a Tepit a ela anong kanokg a Sutia pa, eng ntei, kil am kulung ur kai om wris a Tepit pake. ");
INSERT INTO urim_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Atom kil awi kin alkil Maria pa, tuwekg kai kinar la tu uwiyen nang. Maria pa pikekg tu ak namputel la ikga rpmi eng kil pa, kin pa am itna warim kakir eng a raku tike. ");
INSERT INTO urim_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Atom ak wang a tuwekg rpma Petleem pa, pa wang alkilen eng kil la raku warim. ");
INSERT INTO urim_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Atom kil raku warim kipman payen wris alkil pa, atom kil yapowel ak apm pa, alupm elng kinar yo timpal a manto nepm watin ale ale okipma armpewe pa. Eng ntei, wan a tu wli okg arke arke pa, am lawe ise. ");
INSERT INTO urim_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tu melnum tiur a ikgalen manto walkg malkgu a rka wrik laikge a ela wreren anong Petleem pa, tu atnen manto walkg malkgu pa ak mining pa itna. ");
INSERT INTO urim_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Atom maur akwapel a Wailen kil palng itna kuin a tu pa, a klalen a titnongket a Wailen pa nar ak alenten, atom tu wrekg paipm ngkark. ");
INSERT INTO urim_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ari maur akwapel a Maur Wailen pa lanaken la, “Kipm itning, ampur kipm ngkark, kupm aye yangkipm wor nar lanikepm. Yangkipm wor pa ikga ntokg tu wrongkwail tu itopen wail paipm. ");
INSERT INTO urim_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Melnum a ikga ikuwiyepm pa weti man ur raku kai anong a Tepit pa. Kil pa kil Wailen, a kil Krais. Melnum a Maur Wailen kil takwei atom ukwa kul nar eng la imo ikrmpen kipm wrong kin a kipman. ");
INSERT INTO urim_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mpa kipm kai ri warim a tu ak apm yapo alupm kinar yo timpal a manto nepm watin ale ale okipma armpewe pa. Mpa kipm riwe la, pa warim am pake.” ");
INSERT INTO urim_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tu maur akwapel a Maur Wailen a rka kaino anong wor pa, wailet paipm ai kolen tu melnum a almpwrong pa tu anel palng penterngen kolti nar itna nampokgen maur akwapel a Maur Wailen pa, a tu ngkat nang a Maur Wailen pa ak nangnang pa kolpa la, ");
INSERT INTO urim_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","”Ngkit nang a Maur Wailen a rpma kaino kwa, eng kil plan ipma wor wasrongen kipm wrong kin kipman a rpma kanokg ti, atom kipm rpma meen wor.” ");
INSERT INTO urim_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tu maur akwapel a Maur Wailen tu ak nang pa plalng, tu atnuurngken yaper kaino anong wor ai pipa, tu melnum a ikgalen manto walkg malkgu pa anel lanaki tita la, “Ti mentepm kai Petleem ai, eng ri kuina ur a wuten palng ti, a wuten Wailen kil lanako pa!” ");
INSERT INTO urim_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Atom tu wrekg atatu kolti, kai ansil Maria ekg Sosep nampokgen warim pa, a okg rmpa yo timpal a manto nepm watin ale ale okipma armpewe pa. ");
INSERT INTO urim_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tu ari warim pa, tu lakati kuina ur a wuten maur akwapel a Maur Wailen lanaken kai warim pa, naki tu a rka pa. ");
INSERT INTO urim_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Atom tu atning yangkipm pa, tu wrekg paipm akwonalmpen watipmen kuina ur a tu melnum a ikgalen manto walkg malkgu pa lanaken pa. ");
INSERT INTO urim_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pake Maria pa kil alupmen yangkipm wrongkwail pa atom kil akwonalmpen yangkipm pa rpma. ");
INSERT INTO urim_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tu melnum a ikgalen manto walkg malkgu pa tu wa yaper kai, a tu ak nangnang pa itna wampel ak ngkat nang a Maur Wailen eng kuina ur a tu atning a ari, kol a wuten tu maur akwapel a Maur Wailen lanaken pa. ");
INSERT INTO urim_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Maria raku Sisas rpma a a, wang wampwomis wampwompwraur pa, pa tu angket numpalk a kil pa. A tu alil nang a kil pa Sisas. Nang pa pati, pikekg maur akwapel a Maur Wailen kil alilel ep ak ai, ak wang a kil pikekg ake palng rpma ipma a man alkil pa. ");
INSERT INTO urim_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Maria karkuk ak u wor eng palng kukula wor itna wulmpa a Maur Wailen pa, katila yangkipm titnongket a Moses la pa plalng pipa, tuwekg mansan pa aye Sisas pa kinar kai kaino anong wail Serusalem eng uk kil kai wam a Yan Wailen eng elngkitna manet eng alkilen. ");
INSERT INTO urim_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kol yangkipm titnongket a Wailen a nira la, “Warim Kipman payen wrongkwail pa, tu mpa iye kai uk Wailen la pa alkilen pake.” ");
INSERT INTO urim_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","A tuwekg la lap il wor uk kitila yangkipm titnongket a Wailen la pa la, iye punum wekg aki, a kilmpin plampiwen wekg. ");
INSERT INTO urim_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ak wang ti melnum ur a rpma Serusalem pa, nang a melnum pa namput la Simeon. Kil melnum ute wor a alupm aye Maur Wailen. Kil rpma nungkwangen la Maur Wailen kil ngklin tu Isrel a ungkwan kalkuten atuwen. Melnum pa kil antiwe Maur Wor. ");
INSERT INTO urim_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","A kil pikekg Maur Wor lanakel la, kil ikgake imo, kil ikga rpmi i i, kil ri Krais, melnum a Maur Wailen kil yapon yangkipm la ikga nar eng ikrmpen mentepm wrong kin kipman pa plalng pa, kil imo. ");
INSERT INTO urim_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Maur Wor pa kil akwap kai Simeon pa, kolpa atom kil kai kawor yipmingki wunen a yalming a Maur Wailen, ak wang a mansan tuwekg aye warim Sisas pa aye kawor yalming a Maur Wailen, la ikwap kol yangkipm titnongket a Moses la pa. ");
INSERT INTO urim_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Atom Simeon ari warim pa, kil kai ngkatel kolti, a kil uk wor Maur Wailen la kolpa la, ");
INSERT INTO urim_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Wailen, kupm melnum akwapel alkitnen, kitn pikekg lala kupm ikgake imo, kupm rpmi ri Krais pa plalng pipa kupm imo. Ti warim ti am kupm ari tike. Ti kitn la uwiyopm pa, kitn uwiyopm o! ");
INSERT INTO urim_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kupm ari ak wulmpa alkupmen ise. Warim alkitnen kil ikga ikuwi tu wrong kin kipman wrongkwail iye yaper kai eng kitn, ");
INSERT INTO urim_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","a pikekg kitn numprampen la mpa tu wrong kin a kipman wrongkwail ri. ");
INSERT INTO urim_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Pa warim klalen a ikga iklen tu a ake Suta, a ikga uk nang wailen tu wrong kin kipman alkitnen a Isrel.” ");
INSERT INTO urim_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ti tuwekg mansan a warim pa, tuwekg wrekg paipm eng atning kuina ur a Simeon la kai warim pa. ");
INSERT INTO urim_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Atom Simeon kil oklala naki Maur Wailen la kil ngklinsen, wa la kai Maria, man a warim pa la, “Kipmekg itning, warim kil pa, Maur Wailen kil takwei eng ikga ntokg tu wailet tiur a Isrel ikga wutat ngko, a wa wailet tiur pa ikga wa wrekg itni. Maur Wailen takwei kil itna kol kla ur a ikga tu la paipmel. ");
INSERT INTO urim_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kolpa ti nikgwalpm ampen wor a paipm a tu wrongkwail pa ikga palng ngko wunong. Ti wa Maria kitn ti yat, kalkuten wail ur a ikga palngteitn pa, pa ikga kungkuweitn nol.” Yangkipm a Simeon la pa am kai kol pake. ");
INSERT INTO urim_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ti kin okwripm ur pa, nang alkilen pa Ana, kil warim kin a Panuel, a om ur a Aser. Kil pa kin mayen, wa wring alkilen pa kamel wikgwikg tuwek wikgwikg. Pikekg awi kipman rpma wring wampwomis wampwompwekg. Kipman pa amo, a kil rpma kin karpikg kolti rpma. Wa kil ake wa atnuurng yipmingki wunen a yalming a Maur Wailen pa, mining ranen kolpa, kil am kalpis okipma uk wang kapor kilko alein oklala naki naki Maur Wailen pa kolngkol pa rpma pake. ");
INSERT INTO urim_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeon la okyangkipm naki Maria pa itna pa, Ana wa kul no itna uk wor Maur Wailen, a kil lanaki tu wrongkwail a nungkwangen melnum a ikga ikirmpen tu wrong kin kipman a Serusalem pa la la, ti warim pa am kilke. ");
INSERT INTO urim_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sosep ekg Maria tuwekg akwap wrongkwail pa katila yangkipm titnongket a Wailen kil la pa plalng pipa, tuwekg wa yaper kinar kai kaino anong alntuwekgen Nasaret a anong kanokg Kalili. ");
INSERT INTO urim_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tunteng kaino rpma a, warim pa kil wrekg wail a awi titnongket, a kil nikgwalpm arke wontrakole. Wa Maur Wailen plan ipma wor alkil ak atopentel. ");
INSERT INTO urim_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Akangklei wring wris wris pa, mansan a Sisas pa, tuwekg kinar kai kaino Serusalem eng antokg okipma wail al ak wang a tu Suta rpma akwonalmpen Maur Wailen pikekg ak awiyen angkai Isip kul. ");
INSERT INTO urim_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sisas pa kil wrekg wail om, wring wampwam yikak wekg pa, atom kil anti mansan alkilen pa kinar kai kaino eng antokg okipma wail al katila ya a rpma alntuwen pa. ");
INSERT INTO urim_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tu antokg okipma wail pa al plalng pipa, mansan a Sisas pa am ekg wa atnuurng Serusalem pa yaper kinar kai la kaino anong Nasaret pa. Pake warim kipman Sisas pa kil rpma a no Serusalem ti rpma. Ti tuwekg mansan pa tuwekg ake wa ariwe. ");
INSERT INTO urim_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tuwekg akwonalmpen la, kil am tu kimeket kinar kai la kaino pake. Tu angkom or ya pa kaino, miningten angko ya pa, tuwekg akorel itna kuin a tu yiprokgen a walmpopm wris alntuwekgen pa. ");
INSERT INTO urim_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ari ake wa tuwekg ariwel, atom wa tuwekg yaper nar kul akorel no Serusalem. ");
INSERT INTO urim_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tuwekg akorel kolpa kai, mining wraur pa kai plalng pa, tuwekg ansilel rpma kai yalming a Maur Wailen. Kil rpma nampokgen tu melnum a rpma rpma aro wonel tu yangkipm a Moses, kil rpma atning yangkipm ok tiur a tu la pa ak asenten kolpa rpma. ");
INSERT INTO urim_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kolpa atom tu wrongkwail a atning yangkipm a kil pa, tu wrekg paipm eng nikgwalpm ariwe a kil akalmpe yangkipm a tu la pa. ");
INSERT INTO urim_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tuwekg mansan alkil pa ariwel pa, tuwekg wrekg paipm wrisen. Atom man pa la kai warim kipman alkil pa la, “Wa kitn wa antokgto kolkil eng ntei? Yan alkitn pa nampokgen kupm ti, mentekg pikekg ipma kalkut paipm eng mentekg akoreitn.” ");
INSERT INTO urim_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ari warim kipman alkil pa akalmpe la, “Wa kipmekg akoropm eng na? Kipmekg kol a riwe la kupm am rpma wan a yan alkupmen tike!” ");
INSERT INTO urim_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ari tuwekg ake wa ariwe kuina ur a kil la pa. ");
INSERT INTO urim_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Atom kil wrekg antiwen kinar kai kaino Nasaret, a wa kil akangklei atning nungkulkg yangkipmok a tuwekg. Pake man pa alupmen yangkipm wrongkwail a warim kipman pa rpma kawor nol nikgwalpm alkil pa. ");
INSERT INTO urim_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Sisas kil wrekg wail nampokgen nikgwalpm ariwe wor, a Maur Wailen nampokgen tu wrong kin kipman pa tu plan ipma wor alntuwen ak atopentel. ");
INSERT INTO urim_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Taiperius kil itna Kaisarus, melnum tukgunakg a ikgalen anong kanokg wail a Rom. A Pontius Pailat pa, kil itna mringman ikgalen anong kanokg a Sutia. Wa Erot kil ikgalen anong kanokg a Kalili, wa wusoken alkilen Pilip pa kil ikgalen anong kanokg a Ituria a Trakonitis. A Lisanias pa kil ikgalen anong kanokg a Apilene. Wa Anas a Kaiapas tuwekg itna melnum tukgunakg a itna ep eng tu melnum ipma krakgen kimeket a Maur Wailen. Taiperius kil itna kolen wring wampwam yikakwomis pa. Atom Taiperius kil itna melnum tukgunakg pa itna kol wring wikgwikg pa kai plalng, wa wring wris ti wa kai aken wikgwikg ai kai wampwomis pipa, ok a Maur Wailen kil akwe Son warim kipman a Sekaraia pa, itna kai wrik kalpmlel a ake melnum ur arke pa. ");
INSERT INTO urim_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Atom Son kil wrekg kai yela tatu anong kanokg wrongkwail a ela wreren u kop Sotan pa, a kil laron yangkipm pa la tu plelng ipma, eng mpa kil kuluken, eng mpa Maur Wailen kil ungkwan paipmpaipm atuwen. ");
INSERT INTO urim_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kol a pikekg nira ela kai wrkapm a melnum okwripm Aisaia la pa la, “Ok a melnum ur akwe kai wrik kalpmlel pa la, 'Numprampen ya pa eng Wailen, a ukulentel ya pa riworwor! ");
INSERT INTO urim_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","A ipil ngkle wrik a nare pa kulno irir, a ngkon wrik nangen a wrik tipminingen pa iye nar irir. A wa ukule ya wa raimpe pa kai ute riwor, a ipil ngkle ya wa wilpik walpoket nung nangen pa palng wor! ");
INSERT INTO urim_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Wa wrongkwail kin a kipman yela ikga ri kwap a Maur Wailen kil ikga ik, eng ikuwi mentepm wrongkwail.'” Yangkipm a pikekg melnum okwripm Aisaia pa am pikekg la Son pake. ");
INSERT INTO urim_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Atom Son lanaki tu wrongkwail kin a kipman wailet a anel wli wli la kil kuluken pa la, “Kipm ti kolen ul angketepm! Mla lanakepm pa atom kipm akor ya eng la ikga ngkirk tukuleikgen ipma wakget a Maur Wailen a ikga nar ti! ");
INSERT INTO urim_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kolpa ti kipm plan atn a rpma akipmen ti kol yo a angko oken wor, eng mpa plan la kipm am plelng ipma ise. Kipm am palng angkai Apraam pa angket alewepm kul pake, pake ake mpa kipm won ngklin la Apraam pa mamin wror akipmen, ti ikga ngklinsepm pa. Eng ntei, kupm lanakepm la, Maur Wailen ti antiwe la wes tatu ti wa palng walwalpopm a walyaru a Apraam ti. ");
INSERT INTO urim_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ti kotwang pa am numprampen rmpa yo yiprokg wrongkwail pa ise. Yo a ake angko oken wor pa, ikga ware ngket rkol ngkli elng kai wakg.” ");
INSERT INTO urim_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Atom wrongkwail kin a kipman pa wa asentel la, “Ti mpa wa men ntokg kolai eng men ngko ok wor pa?” ");
INSERT INTO urim_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ari Son akalmpenten la, “Melnum a kil antiwe apm wekg a nowe angkaino ti nar pa, kil uk ur kai melnum ur a kalpis pa. Wa melnum ur a antiwe okipma pa, am wa kil ik kol pake.” ");
INSERT INTO urim_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wa tu melnum tiur a awi marpmel tu pa, tu wa wli la kil kuluken yat. Atom anel asentel la, “Melnum a kaling plan tu, mpa men ntokg kuina?” ");
INSERT INTO urim_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ari kil lanaken la, “Ake mpa kipm uwi marpmel tu pa klangkil marpm mrangkum a pikekg tu yapon pa.” ");
INSERT INTO urim_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wa tu melnum tiur a almpwrong pa wli asentel la, “Ti men ti, men ti mpa ntokg kuina?” Ari kil akalmpenten la, “Ake mpa kipm kinsil a tirpmingen tu mla ur eng uwi kweikwei alntuwen pa. Kipm mpa uwi wor eng marpm a kipm awi awi eng kwap a kipm ak pa, pa am a pake.” ");
INSERT INTO urim_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tu wrong kin a kipman pa tu atning a Son kil la kolpa atom tu rpma nungkwangen la ri, wa tu akwonalmpen watipmen kawor nol nikgwalpm atuwen ti lala, kol Son pa mpam kil Krais pa ur pake. ");
INSERT INTO urim_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Atom Son kil akalmpe kai tu wrongkwail pa la, “Kupm ti pa, kupm kalukepm ak u ti kolti. Pake melnum ur a antiwe titnongket wail manten angen kupm ti pa ikga wli. Ti kupm kil melnum paipm a nang kalpisen a kolkil pa, kol a kupm ikwap paipm ur kol a iner nepm palk kai melnum wailen kol pake, ari kupm ake wa antiwe akwap kolpa yat. Kil pa ikga kulukepm ik Maur Wor, wa ik wakg. ");
INSERT INTO urim_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kil aye kaimung pa itna kai wam alkil pa, eng la ik ngkwol wit ok pa ik wripm uwi, atom misen wor wor pa kil ikga ngkiten nimong iye kai rpmi wan wit ok alkilen ai. A kil ikga numpron plepm paipm paipm pa elng itni manet, eng ikga lap kai wakg a ikgake ime pa, kalpis.” ");
INSERT INTO urim_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Son kil alken nikgwalpm watipmen auraur kolpa ak alm ipmawel tu pa, wa laron yangkipm wor a Maur Wailen pa lanaken. ");
INSERT INTO urim_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pake kil akle Erot, melnum wailen a ikgalen Kalili pa, ok atnen a kil karpo Erotias atn wampel Pilip, wailen alkilen Erot, a wa kil antokg paipmpaipm wrongkwail tiur yat. ");
INSERT INTO urim_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kolpa atom Erot kil awi Son ti aye kawor rpma wan tipmining ti, pa wa kil antokg paipm angkine paipmpaipm tiur a kil antokg ai. ");
INSERT INTO urim_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ak wang a Son ake Erot awi aye kai rpma wan tipmining pa, kil kaluk tu wrong kin a kipman wailet. Plalng wa kil wa kaluk Sisas pa. Sisas wrekg itna oklala naki Maur Wailen pa, kitnong pa okore kolti, ");
INSERT INTO urim_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","pa Maur Wor pa nar kol wel punum pa rpma tukgunakg a kil pa. A ok ur pa akwe angkaino kitnong pa nar la, “Kitn pa Warim Kipman akupmen, kupm plan ipma wor wasrongenteitn, a kupm ipma wor atopenteitn.” ");
INSERT INTO urim_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sisas kil warimpen ise, wring kamel wris tuwek wampwam pipa, kil ngkaten kwap pa ak. A kil pa warim kipman a tu akwonalmpen la kil warim a Sosep. Wa Sosep pa warim kipman a Eli, ");
INSERT INTO urim_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","wa Eli pa warim kipman a Matat. Wa Matat pa warim kipman a Lipai. Wa Lipai pa warim kipman a Melki. Wa Melki pa warim kipman a Saina. Wa Saina pa warim kipman a Sosep. ");
INSERT INTO urim_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Wa Sosep pa warim kipman a Matatias. Wa Matatias pa warim kipman a Amos. Wa Amos pa warim kipman a Naum. Wa Naum pa warim kipman a Esli. Wa Esli pa warim kipman a Nakai. ");
INSERT INTO urim_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Wa Nakai pa warim kipman a Mat. Wa Mat pa warim kipman a Matatias. Wa Matatias pa warim kipman a Semen. Wa Semen pa warim kipman a Sosek. Wa Sosek pa warim kipman a Sota. ");
INSERT INTO urim_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Wa Sota pa warim kipman a Soanan. Wa Soanan pa warim kipman a Resa. Wa Resa pa warim kipman a Serupapel. Wa Serupapel pa warim kipman a Sealtiel. Wa Sealtiel pa warim kipman a Neri. ");
INSERT INTO urim_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Wa Neri pa warim kipman a Melki. Wa Melki pa warim kipman a Ati. Wa Ati pa warim kipman a Kosam. Wa Kosam pa warim kipman a Elmatam. Wa Elmatam pa warim kipman a Er. ");
INSERT INTO urim_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Wa Er pa warim kipman a Sosua. Wa Sosua pa warim kipman a Elieser. Wa Elieser pa warim kipman a Sorim. Wa Sorim pa warim kipman a Matat. Wa Matat pa warim kipman a Lipai. ");
INSERT INTO urim_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Wa Lipai pa warim kipman a Simeon. Wa Simeon pa warim kipman a Suta. Wa Suta pa warim kipman a Sosep. Wa Sosep pa warim kipman a Sonam. Wa Sonam pa warim kipman a Eliakim. ");
INSERT INTO urim_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Wa Eliakim pa warim kipman a Melea. Wa Melea pa warim kipman a Mena. Wa Mena pa warim kipman a Matata. Wa Matata pa warim kipman a Natan. Wa Natan pa warim kipman a Tepit. ");
INSERT INTO urim_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Wa Tepit pa warim kipman a Sesi. Wa Sesi pa warim kipman a Opet. Wa Opet pa warim kipman a Poas. Wa Poas pa warim kipman a Salmon. Wa Salmon pa warim kipman a Nason. ");
INSERT INTO urim_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Wa Nason pa warim kipman a Aminatap. Wa Aminatap pa warim kipman a Atmin. Wa Atmin pa warim kipman a Arni. Wa Arni pa warim kipman a Esron. Wa Esron pa warim kipman a Peres. Wa Peres pa warim kipman a Suta. ");
INSERT INTO urim_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Wa Suta pa warim kipman a Sekop. Wa Sekop pa warim kipman a Aisak. Wa Aisak pa warim kipman a Apraam. Wa Apraam pa warim kipman a Tera. Wa Tera pa warim kipman a Naor. ");
INSERT INTO urim_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Wa Naor pa warim kipman a Seruk. Wa Seruk pa warim kipman a Reu. Wa Reu pa warim kipman a Pelek. Wa Pelek pa warim kipman a Eper. Wa Eper pa warim kipman a Sela. ");
INSERT INTO urim_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Wa Sela pa warim kipman a Kainan. Wa Kainan pa warim kipman a Arpaksat. Wa Arpaksat pa warim kipman a Sem. Wa Sem pa warim kipman a Nowa. Wa Nowa pa warim kipman a Lamek. ");
INSERT INTO urim_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Wa Lamek pa warim kipman a Metusela. Wa Metusela pa warim kipman a Enok. Wa Enok pa warim kipman a Saret. Wa Saret pa warim kipman a Maalalel. Wa Maalalel pa warim kipman a Kainan. ");
INSERT INTO urim_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Wa Kenan pa warim kipman a Enos. Wa Enos pa warim kipman a Set. Wa Set pa warim kipman a Atam. Wa Atam pa warim kipman a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Sisas kil atnuurng u kop Sotan pa, kil antiwe Maur Wor, atom Maur Wor pa ak awiyel aye kai wrik kalpmlel ur a ake melnum ur arke. ");
INSERT INTO urim_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kai wrik pa kil rpma kol wang kamel wekg miningkranen, wa Maur Paipm kil ningkailel la kil ngko. Ake kil al okipma ur, kolpa kaingkai wang pa kai eng a plalng pa, nikgalmpel. ");
INSERT INTO urim_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kolpa atom Maur Paipm pa lanakel la, “Kitn ti Warim Kipman a Maur Wailen, ti kitn la wes ti palng kol okipma pa eng kitn il!” ");
INSERT INTO urim_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ari Sisas akalmpe la, “Wrkapm a Maur Wailen pa la kolkil la, 'Melnum ake antiwe a rpma ak okipma kolti pa.'” ");
INSERT INTO urim_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Wa Satan wa ak awiyel a pa wa kai kaino itna wrik nangen ur pa, atom penterngen kolti palng plantel wrik kanokg, a anong kweikwei wrongkwail a itna kanokg ti. ");
INSERT INTO urim_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Atom kil lanakel la, “Kupm mpam uk nang wailen a titnongket kitn tike eng kitn ikglen kweikwei wor wor wrongkwail a itna kanokg ti. Kweikwei wrongkwail ti am pikekg elng kul wam akupmen ti ise. Ti kupm la uk kai mla ur a kupm la uk pa, mpa kupm uk kolti. ");
INSERT INTO urim_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ti kol kitn kipor kilko ilein ngkit nang akupmen ti pa, kweikwei wrongkwail pa mpa alkitnen plalngten.” ");
INSERT INTO urim_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ari Sisas akalmpentel la, “Nira ela wrkapm a Maur Wailen pa la kolkil la, 'Kitn kipor kilko ilein ngkit nang a Wailen, kil Maur Wailen alkitnen, a kitn ikwap a kil wris ita.'” ");
INSERT INTO urim_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ake wa kil wa angko, kolpa atom wa Maur Paipm wa ak awiyel a pa wa kai kaino anong wail Serusalem pa, atom awiyel aye kaino itna kaino wan kimpo kwa a yalming a Maur Wailen pa. Atom kil lanakel la, “Kitn ti Warim Kipman a Maur Wailen, ti kitn tipra itni ti elng kinar kanokg ai! ");
INSERT INTO urim_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Nira ela Wrkapm a Maur Wailen pa la kolkil la, 'Mpa kil uk yangkipm tu maur akwapel alkilen ti mpa tu itnenteitn riworwor pa.' ");
INSERT INTO urim_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","A wa nira kolpa yat la, 'Mpa tu wamplilngteitn pa, eng ake mpa kitn ngko ngket nepm pa eli wes ur pa.'” ");
INSERT INTO urim_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ari Sisas akalmpentel la, “A wa kil wa la kolkil yat la, 'Ake mpa kitn ningkail Wailen, kil Maur Wailen akitnen ti.'” ");
INSERT INTO urim_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Maur Paipm Satan kil ningkailel kai kweikwei wrongkwail pa plalng pa, wa kil wa atnuurngkel kai pen. ");
INSERT INTO urim_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Atom Sisas wa yaper kaino anong kanokg Kalili nampokgen titnongket a Maur Wor. Wa yangkipm a la kil pa am kai yela anong kanokg yamping tiur pa ise. ");
INSERT INTO urim_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kil kaling plan tu wrongkwail kin a kipman pa itna wan alntuwen a tu atning atning yangkipm a Maur Wailen atnewe pa, wa tu wrongkwail pa tu ngkat nang akilen pa. ");
INSERT INTO urim_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Wa Sisas kil kai Nasaret, anong a pikekg kil wrekg wor wail atnewe pa. Ak wang wail a men Suta rka eng yapm pa, kil kai kawor wan a tu atning atning yangkipm a Maur Wailen atnewe pa. Kil akangklei ak kolngkolpake. Atom kil wrekg itna la ngkleikg wrkapm a Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Atom tu awi wrkapm a melnum okwripm Aisaia pa alkel, atom kil ari atom kil awi wrkapm pa kil nampreingen akor yangkipm ur a nira la, ");
INSERT INTO urim_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","”Maur Wor a Wailen rpma kupm, eng ntei, kil alkil takweiyopm la kupm laron yangkipm wor a la Krais niki tu melnum a rpma tukwok. A kil ukwawopm la kupm laron yangkipm pa eng ikuwi tu melnum a rka wan tipmining pa iye kulor en. A wa laniki tu mla ur a wulmpa tilmpisen mpa wa tu wulmpa ore ri kweikwei. A kupm nar la ungkwan kalkuten a tu arkuwen a wleket a tu alken pa eng mpa tu rpmi kukula wor. ");
INSERT INTO urim_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Wa laron niki tu wrong kin kipman pa la wring ti pa, wring a Wailen la rein ngklinsen.” ");
INSERT INTO urim_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kil angkleikg plalng pipa wa kil wale wrkapm pa uk yaper kai melnum alkil a ikgalen wrkapm pa, a kil angko rpma. Ari tu wrong kin kipman a rpma kawor wan pa, tu ikatnentel titnongket. ");
INSERT INTO urim_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Atom kil wa lanaken la, “Yangkipm wrkapm a Maur Wailen wet kipm atning a kupm angkleikg kil pa, am palng ok arke tike, am kupm tike.” ");
INSERT INTO urim_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tu kaporng yangkipm la kil pa wor, wa tu wrekg paipm eng atning yangkipm a plan ipma wor a palng kai ok akilen pa. Wa tu lanaki tita la, “Palpa kil pa warim kipman a Sosep ti kolti!” ");
INSERT INTO urim_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ari Sisas lanaken la, “Kupm ariwe la kipm ti ake ukipma kupm ti kolen wrkapm a Aisaia la pa. Nikgwalpm akipmen pa kipm aklawopm ak yangkipm kla lala kupm melnum a antokg i numpet pa, kol a kupm ntokg kupm alkupm ti palng wor pen. Kipm wasrongen la la kupm ntokg kuina ur itni anong yiprokg alkupmen ti, kol a pikekg kipm atning a kupm antokg itna kai kaino Kaperneam ai.” ");
INSERT INTO urim_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Wa kil wa la kolpa kai la, “Kupm lanakepm aklale wrisen, tu melnum ake antiwe a atning katnun yangkipm a melnum okwripm ur angkli itna anong yiprokg alkil pa. ");
INSERT INTO urim_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kolen pikekg ep ak wang a Elaisa kil rpma, ak wang pa u ake awei itna kol wring wraur misen wompel, atom wa wang nikg wail palngten yela anong kanokg a Isrel ti. Atom ak wang pa tu kin karpikg wailet rka Isrel ti. Pake kupm lanakepm aklale wrisen, ");
INSERT INTO urim_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","la Elaisa ake pikekg ukwa kai eng la ngklin tu kin karpikg a rpma Isrel, anong yiprokg alkil ti, kalpis. Kil pikekg ukwa kaino eng kin karpikg wris ur kaino Sarepat kaino anong kanokg manet ur a Saiton ai. ");
INSERT INTO urim_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Wa kolen tu melnum watipmen a Isrel ti tu awi numpet a i paipuk ak wang a Elaisa kil itna melnum okwripm, ti ake wris ur atuwen a rpma anong yiprokg akil ti palng wor pa, kalpis. Naman, melnum wris ur a kaino anong manet ur a Siria wai pa kolti palng wor.” ");
INSERT INTO urim_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tu wrongkwail a rka kawor wan a tu atning yangkipm a Maur Wailen atne atne pa tu atning yangkipm a Sisas la kolpa atom, tu ipma wakget paipm wrisen. ");
INSERT INTO urim_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Atom tu wrekg kolti arkol wampel Sisas pa aye kulor en a anong pa. Anong pa tu ngkat ela wrik krongen ur, a tu arkol wampel talpul angkli kol pa ayewel kinar tipmining. Tu ayewel kinar la kol a ngkliwel elng kinar tipmining watin ai, ari kalpis, ");
INSERT INTO urim_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","kil atnuurngken kolti, kil angkom or kuin a tu wrongkwail pa am kai ise. ");
INSERT INTO urim_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Atom Sisas kai kaino Kaperneam, anong a anong kanokg a Kalili. Ak wang wail a rpma eng yapm pa kil ngkaten kwap a kaling plan tu. ");
INSERT INTO urim_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tu wrekg paipm atnen yangkipm a kil kaling planten pa, eng ntei, yangkipm a kil kaling planten pa kil kaling planten nampokgen titnongket. ");
INSERT INTO urim_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Melnum ur a maur paipm kimpilpet arpmewel pa kil rpma kawor wan a tu atning atning yangkipm a Maur Wailen atnewe pa. Atom kil kirkar yikakatnen ");
INSERT INTO urim_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","la, “Ei, Sisas a Nasaret! Kitn la ntokg na kul men ti? Kitn kul la ntokg men ti kai paipm aki? Kupm ariweweitn pa, kitn pa Melnum Klalen Wakget a Maur Wailen.” ");
INSERT INTO urim_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ari Sisas kil akle maur paipm pa la, “Mpri ok akitn pa, or kai tukuleikgen melnum pa kai o!” Atom maur paipm laik melnum pa ngkrang kolti elng kai angko rmpa kai kuin a tu ai, a wrekg or kai takwleikgentel, a melnum pa ake wa kil awi paipm ur. ");
INSERT INTO urim_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tu wrongkwail pa tu ari pa tu wrekg paipm lanaki tita la, “Kil pa la yangkipm na kolpa? Kil pa kil melnum a nang arke antiwe titnongket a la tu maur paipm kimpilpet pa kulor kai takwleikg pake!” ");
INSERT INTO urim_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Atom tu aye yangkipm a la kweikwei wrongkwail a kil antokg pa aye kai yela anong wrongkwail a ela wreren pa. ");
INSERT INTO urim_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sisas kil atnuurng wan a tu atning atning yangkipm a Maur Wailen atnewe pa, a kil kai wan a Saimon. Wa yalmpikg mayen a Saimon pa kil amo numpwakget wail paipm, atom Saimon lanakel la kil ngklinsel. ");
INSERT INTO urim_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Atom kil kai itna wreren wrik a man pa, atom kil la titnongket ungkwan numpet pa takwleikgentel, atom numpet pa kai plalng. Wa kil wrekg pirpiren antokg okipma kweikwei pa uk tu pa al. ");
INSERT INTO urim_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Takgni kai kinar timpal ti pipa, tu wrong kin kipman tu aye tu a awi numpet wrongkwail pa aye wli eng Sisas. Atom kil elng wam pa ele tu melnum numpet pa wris wris, a antokg numpet a tu pa palng wor. ");
INSERT INTO urim_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Wa maur paipm wailet tu or kai takwleikgen tu wrong kin kipman watipmen pa, a tu kirkar la, “Kitn pa Warim Kipman a Maur Wailen!” Ari Sisas aklewen a angkengken la ake mpa tu oklala. Eng ntei, tu ariwe la kil pa Krais. ");
INSERT INTO urim_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Takgni pa no pus pa, Sisas kil wrekg atnuurng anong pa, a kil kai wrik laikge ur pa. Tu wailet a pa anel akorel yela, kolpa kai ansilel kai wrik a kil kai arpme pa. Atom tu la mpa ngkengkel, eng ake mpa kil utnuurngten. ");
INSERT INTO urim_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ari kil lanaken la, “Kupm mpa kai tutu anong wail tiur ai yat laron yangkipm wor a la kweikwei wrongkwail a Maur Wailen ikgalen pa. Eng ntei, Maur Wailen am ukwawopm nar la ikwap kol pake.” ");
INSERT INTO urim_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kil lanaken kolpa plalng, kil laron yangkipm a Maur Wailen pa kolpa kai itna wan a tu atning atning yangkipm a Maur Wailen atnewe, yela anong kanokg Kalili ai. ");
INSERT INTO urim_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ak wang wris ur pa, Sisas kil itna ukupuk yamping a Kenesaret pa, a tu wrongkwailet paipm anel wli kulkai kapringentel la itning yangkipm a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kil ari nim ukupuken wekg ur pa rka kai ukupuk yamping pa. A tu melnum a ak apm mumu awi yul pa atnuurng nim ukupuken pa rka, tu kinar klak apm mumu pa itna. ");
INSERT INTO urim_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Atom Sisas kil kaino rpma nim ukupuken ur pa, pa nim ukupuken a Saimon, a kil lanaki Saimon pa la, “Kitn uwi nim ukupuken ti ik uwiyopm iye kai waiketnketn!” Atom Saimon kil ak katila kol a kil lanakel pa. Atom kil rpma nim ukupuken a pa, a kil kaling plan tu wrong kin kipman wailet a wli itna ukupuk yamping pa. ");
INSERT INTO urim_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kil kaling planten plalng pa, kil lanaki Saimon pa la, “Kitn uwi tu alkitn pa kipm uwi nim ukupuken ti kai rki kai ukupuk kapmen ai, atom kipm ngkli apm mumu pa elng kinar ukupuk pa eng ik uwi yul pa.” ");
INSERT INTO urim_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ari Saimon pa akalmpe la, “Melnum Wailen, men am wuten aken kwap pa ak mining ai kulngkul am kong tike, ake wa men awi yul ur. Ari kitn pa la kolpa ti, mpa kupm ngkli apm mumu pa.” ");
INSERT INTO urim_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tu alekg apm mumu pa elng kinar, ari tu ak awi yul wailet paipm, wreren eng apm mumu pa eng a kitnangku. ");
INSERT INTO urim_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kolpa atom tu ak wam pa akwe tu tiur alntu a rka kai nim ukupuken ur pa la tu kul ngklinsen. Tu kul kolti, tu kimeket awi yul pa alupm kai nim ukupuken wekg pa no pik waiwai, ak kaikutel ak arku nim ukupuken wekg ti eng a elng kinar u kanokg tike. ");
INSERT INTO urim_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita kil ari pa, kil kapor kilko alein Sisas pa, a kil la, “Wailen, kitn kai tukuleikg kupm ti, kupm ti melnum a antokg paipmpaipm.” ");
INSERT INTO urim_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kil la kolpa atnen a kil pa nampokgen tu tiur alkilen pa, tu wrekg paipm eng ari yul wailet paipm a wuten tu awi pa. ");
INSERT INTO urim_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Wa Semis ekg Son, warim kipman wekg a Sepeti, tuwekg akwap wris nampokgen Saimon pa, tuwekg wa wrekg paipm eng pa yat. Ari Sisas lanaki Saimon pa la, “Ampur kitn ngkark. Ak wang ti kai pa kitn ikga uwi tu melnum kol a kitn awi yul pa.” ");
INSERT INTO urim_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Atom tu awi nim ukupuken pa aye kai itna kai nimilpm ai, nampokgen kweikwei wrongkwail pa elngkitna pa plalng pa, tu kai katnun Sisas. ");
INSERT INTO urim_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ak wang a Sisas rpma anong wris ur pa, melnum ur a i paipuk al num a kil ti plalng pa kil wli eng Sisas. Kil ari Sisas pa, kil elngtangko wontaipur rmpa won a Sisas pa, a kil lanakel la, “Melnum Wailen, kitn wasrongen pipa, kupm ariwe la kitn antiwe mpa ntokg numpet akupmen kil palng wor!” ");
INSERT INTO urim_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ari Sisas pa akalmpe kai melnum pa la, “Kupm wasrongen pa.” Atom kil elng wam pa kai itna melnum pa, a kil la, “Kitn palng wor o!” Kil la kolpa, i paipuk pa kai takwleikgen melnum pa penterngen kolti. ");
INSERT INTO urim_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Atom Sisas uk yangkipm titnongket kai melnum pa la, “Ampur kitn lanaki mla ur. Kitn kai o, plan num alkitn pa kai melnum ipma krakgen a Maur Wailen pa ri, eng mpa kil il wor uk Maur Wailen pa, kol yangkipm titnongket a Moses la pa. Eng mpa plan tu wrongkwail eng tu riwe la, kitn am palng wor ise.” ");
INSERT INTO urim_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ari kalpis, yangkipm a la Sisas pa am kai umpen yela tu wrongkwail atning ise. Atom tu wrong kin kipman wailet paipm anel wli la itning yangkipm a kil pa, a tu la kil ungkwan numpet atuwen pa yat. ");
INSERT INTO urim_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pake wang tiur pa Sisas kai wrik kalpmlel ur a ake melnum ur arpme, eng kil oklala naki Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ak wang wris ur a Sisas kaling plan tu wrong kin kipman pa, tu melnum a arpmen yangkipm yiprokgen a Moses, a tu melnum a aroaro wonel tu yangkipm a Moses pa, tu rka yat. Tu wli a pa a pa, a anong wail Serusalem, a anong wrongkwail a Kalili, a Sutia pa. Maur Wailen alkel titnongket, atom kil antokg tu melnum numpet pa palng wor. Kil ak kwap kolpa itna pa, ");
INSERT INTO urim_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","melnum tiur yapo melnum ur a nepm wam plupmen pa aye wli, atom tunteng akor ya la iyewel kawor wan eng Sisas pa. ");
INSERT INTO urim_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ari tu wrongkwailet paipm ak ampri ya pa atom tunteng ake antiwe aye melnum pa aye kawor wan pa. Kolpa atom tunteng ngkat melnum pa aye kaino wan kimpo kwa pa. Atom tunteng angketen wutneik tiur pa plalng, alekg melnum pa elngkinar rmpa tumute won a Sisas pa rmpa kuin a tu wrongkwail. ");
INSERT INTO urim_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Sisas ari a tunteng ukipma kolpa, atom kil la, “Melnum wor alkupm, paipmpaipm akitnen am kupm ungkwan ise.” ");
INSERT INTO urim_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Atom tu melnum a aroaro wonel tu yangkipm a Moses, a tu melnum a arpmen yangkipm yiprokgen a Moses pa, tu atning yangkipm pa, tu akwonalmpen watipmen la, “Kil pa melnum kolai, atom kil aknokgel Maur Wailen pa? Melnum ur akentiwe a ungkwan paipmpaipm pa. Maur Wailen wris ata pa kil antiwe pake.” ");
INSERT INTO urim_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ari Sisas pa kil am ariwe nikgwalpm kuina ur a tu akwonalmpen pa ise, atom kil asenten la, “Wa kipm akwonalmpen nikgwalpm kolpa eng ntei? ");
INSERT INTO urim_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yangkipm a i wunongket antiwe mpa laniki melnum numpet ti la, paipmpaipm akilen am kupm ungkwan ise, aki mpa lanikel la, kil wrekg ngkom kai? Yangkipm wekg pa ake antiwe mpa melnum ur la atom palng katila pa. ");
INSERT INTO urim_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pake mpa kupm plantepm eng kipm riwe la, Warim Kipman a Melnum pa, kil antiwe titnongket itna kanokg a ti eng ungkwan paipmpaipm.” Sisas lanaki tu pa kolpa plalng pa, kil lanaki melnum a nepm wam plupmen pa la, “Kupm lanakeitn la kitn wrekg ngkit wrik alkitn ti iye kai wan anong alkitn ai!” ");
INSERT INTO urim_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Atom penterngen kolti kil wrekg itna wulmpa a tu wrongkwail pa, a kil ngkat wrik alkil pa. A kil ngkat nang a Maur Wailen pa itna wampel kolti kai anong. ");
INSERT INTO urim_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tu wrongkwail tu wrekg paipm, a ngkat nang a Maur Wailen. Wa tu ngkark paipm wrisen, atom tu la, “Weti mentepm ari kweikwei titnongket manet a pikekg ake mentepm ari ep pa.” ");
INSERT INTO urim_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Itna kolpa kai pa Sisas kil angkom kai pa, kil ari melnum ur a awi awi marpmel tu pa, nang akilen pa Lipai. Kil rpma wan alkil a awi awi marpmel tu pa. Atom Sisas akwewel la, “Kitn kul kutnuntopm!” ");
INSERT INTO urim_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Atom kil wrekg atnuurng kweikwei wrongkwail alkil pa itna pa, a kil kai katnuntel. ");
INSERT INTO urim_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Atom Lipai kil antokg okipma wail eng Sisas itna wan alkil pa, atom tu wrongkwailet paipm a awi awi marpmel tu pa, a tu tiur ai, anel wli antiwen al okipma pa. ");
INSERT INTO urim_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tu melnum a arpmen yangkipm yiprokgen a Moses, a tu melnum a aroaro wonel tu yangkipm a Moses pa, tiur atuwen pa am tu alntu melnum a arpmen yangkipm yiprokgen a Moses pake. Tu la watipmen kai tu watnom a Sisas pa la, “Wa kipm al u a okipma pa anti tu melnum a awi marpmel tu pa, wa nampokgen tu melnum a antokg paipmpaipm tiur ai pa eng ntei?” ");
INSERT INTO urim_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ari Sisas akalmpenten kolpa la, “Melnum a numpworen pa, kil ake la kai eng melnum a antokg i numpet pa, pa mpa tu melnum a numpet kolti. ");
INSERT INTO urim_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Pake kupm ake wli la ukwe tu melnum ute wor wor pa, kupm wli la ukwe tu melnum a antokg paipmpaipm pake, la tu plelng ipma.” ");
INSERT INTO urim_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Atom tu la kai Sisas pa la, “Tu watnom a Son aroaro wonel pa, anti watipmen tu kalpis okipma eng uk wang Maur Wailen, a tu oklala naki naki Maur Wailen, wa tu watnom a melnum a arpmen yangkipm yiprokgen a Moses pa yat. Pake tu akitnen pa wa al u a okipma kolpa kai.” ");
INSERT INTO urim_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ari Sisas akalmpenten la, “Kipm ti antiwe a kalpis okipma ik wang a melnum la uwi kin iye pa ik wang a kil antiwepm rpma pake? ");
INSERT INTO urim_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wangkur ikga wa tu uwiyel iye kai tukuleikgten pa, pa ikga tu ipma kaikut ukwakg nare okipma pa rki pake.” ");
INSERT INTO urim_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wa kil wa lanaken yangkipm kla kil kolpa la, “Mentepm ur ake mpa ngketen apm maing a nowe pa, atom wa kai ngkut rpme apm nungkwor a rakol pa. Kol mentepm ntokg kolpa pa, mpa ak aro apm maing pa. Apm umpu maing pa mpa wa ri nirak apm nungkwor pa. ");
INSERT INTO urim_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Am wa kol pake, mentepm ur ake mpa wa inen nok maing a wa lupm elngkinar tikaiyo tingklaket pa. Kol mentepm ntokg kolpa pa, nok maing pa mpa arolanti tikaiyo tingklaket pa ungkwan lolos, atom tikaiyo pa mpa kai rakol paipm. ");
INSERT INTO urim_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kalpis, nok maing a ak pa mpa lupm elngkinar tikaiyo maing wor. ");
INSERT INTO urim_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Melnum a al al nok ruk nungkworen pa, pa kil la pa al wor pake, a nok walmpopmet pa al paipm.” ");
INSERT INTO urim_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ak wang wail wris ur a tu rpma eng yapm pa, Sisas anti tu watnom alkilen pa angkom or wring wit kuin pa. A tu upaar wit ok pa raing al itna wampel kai. ");
INSERT INTO urim_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Atom tu tiur a tu melnum a arpmen yangkipm yiprokgen a Moses tu ari pa, atom tu asenten la, “Wa kipm kapor yangkipm titnongket a la, akentiwe mpa mentepm ikwap ik wang wail a rpma eng yapm pa?” ");
INSERT INTO urim_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ari Sisas akalmpenten la, “Kuina ur a pikekg Tepit anti tu alkil pa antokg ak wang a tu nikgalmpen pa? ");
INSERT INTO urim_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kil kai kawor wan yalming a Maur Wailen pa, atom kil awi nok tingklak a pikekg tu alwor uk Maur Wailen pa, atom kil al, a kil uk tiur kai tu melnum alkil pa al. Ti yangkipm titnongket la kolpa la, mpa tu melnum ipma krakgen kolti il nok tingklak a alwor uk Maur Wailen pake.” ");
INSERT INTO urim_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wa Sisas wa lanaken la, “Warim Kipman a Melnum pa, kil wailen itna ep ikgalen wang wail a rpma eng yapm pa.” ");
INSERT INTO urim_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Wang ur ak wang wail a rpma eng yapm pa, Sisas kil kawor wan a tu atning atning yangkipm a Maur Wailen atnewe pa, atom kil kaling plan tu wrong kin kipman yangkipm a Maur Wailen. A melnum ur a wam wi amo tupmungkul kalpmilel pa kil wa rpma kawor wan pa atning yangkipm pa rpma. ");
INSERT INTO urim_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pake tu melnum a aroaro wonel tu yangkipm a Moses a tu melnum a arpmen yangkipm yiprokgen a Moses pa, tu akor ya la, mpa tu uwi Sisas pa or kol ya a i, eng mpa tu uwiyel iye kai itni yangkipm pa. Kolpatom tu wulmparpmewel yek kimeket la mpa tu ri kil ntokg melnum numpet ur palng wor ik wang wail a rpma eng yapm pa, aki kalpis. ");
INSERT INTO urim_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pake, Sisas pa am ariwe nikgwalpm kuina ur a tu akwonalmpen pa ise, atom kil lanaki melnum a wam amo tupmungkul kalpmilel pa la, “Kitn wrekg itni wulmpa a tu wrongkwail ti!” Atom kil wrekg itna kwa pa. ");
INSERT INTO urim_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Atom Sisas lanaken la, “Kupm la ik isentepm la, ti yangkipm titnongket amentepmen ti lanako la, mpa mentepm kutnun kolai ik wang wail a rpma eng yapm pa? Mpa mentepm ntokg nikgwalpm wor aki, nikgwalpm paipm? La ngklin melnum eng kil rpmi wor, aki ntokg melnum eng kil rpmi paipm?” ");
INSERT INTO urim_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kil itna ari tu wrongkwail pa yela plalng, a kil lanaki melnum pa la, “Ntran wam alkitn pa!” Kil atning kolpa, kil ntran wam alkil pa, atom wam kil a amo pa am palng wor ise. ");
INSERT INTO urim_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pake nikgwalpm a tu pa wakget paipm ai, atom anel akor la itna kuin a tu alntu pa la, mpa tu ntokg kuina ur kai Sisas pa. ");
INSERT INTO urim_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ak wang wris ur pa, Sisas kaino oklala naki Maur Wailen kaino wrik nangen ur pa, atom ak mining wris pa, kil oklala naki Maur Wailen kolpa rpma a, ");
INSERT INTO urim_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","or kong pa, kil akwe tu melnum a katnuntel pa wli. Atom kil takwei melnum wampwam yikak wekg la tu watnom alkilen a kil la iroro wonel pa, a wa kil namput tu pa la tu melnum wokgen alkilen: ");
INSERT INTO urim_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon, kil alil nangkel la Pita, wusok alkil Antru, Semis, Son, Pilip, Partolomyu, ");
INSERT INTO urim_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, Semis, warim kipman a Alpius, nampokgen Saimon, melnum ur a tu Selot. ");
INSERT INTO urim_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Sutas, warim kipman a Semis, a Sutas Iskariot, melnum a ikga elng Sisas kai wam a tu wrongmanto. ");
INSERT INTO urim_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Sisas anti tu watnom alkil a kil aroaro wonel pa anel angkaino nang pa nar itna wrik ipmawen pa, a tu wrongkwailet paipm alkilen a katnuntel pa tu am rka ise, a wa nampokgen tu wrong kin a kipman wailet a anong wail Serusalem, a yela anong kanokg Sutia, a nampokgen anong kanokg a ela unokg yamping wreren anong Tair a anong Saiton. ");
INSERT INTO urim_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tu wli la itning yangkipm akilen pa, a la kil ntokg numpet a tu pa eng tu palng wor. Tu melnum tiur a maur paipm kimpilpet arpmewen pa, Sisas ungkwan takwleikgten, atom tu palng wor. ");
INSERT INTO urim_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","A tu wrong kin a kipman pa ampen la ik wam intewel, eng ntei, titnongket a kil pa antiwe a antokg tu wrongkwail pa palng wor. ");
INSERT INTO urim_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sisas awi tu melnum a katnuntel atn pa atom kil ikatnenten a kil la, “Kipm melnum a rka tukwok pa, kipm pa wor pake, kipm itopen o! Maur Wailen am itna wailen ikgalen ipma a kipm pake. ");
INSERT INTO urim_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kipm melnum a nikgalmpepm ak wang ti pa, kipm pa wor pake, kipm itopen o! Kipm ikga rpmi ntiwe. Wa kipm melnum a akg ak wang ti pa, kipm pa wor pake, kipm itopen o! Kipm ikga itopen paipm. ");
INSERT INTO urim_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Tu la rpmentepm paipm pa, pa kipm rpmi itopen kolti. Kipm melnum a tu arpmen paipmelepm, ungkwantepm, aklewepm ak yangkipm paipm, a alkepm nang paipm, eng ntei, kipm melnum a katnun Warim Kipman a Melnum pa, kipm pa wor pake, ti kipm itopen o! ");
INSERT INTO urim_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kipm itopen ik wang pa, a tipra tipra itopen paipm kolti, eng ntei, kweikwei wailet wor wor pa Maur Wailen kil elngtepm itna kai anong wor alkil ai. Tu mamikg mamin mansan atuwen, am pikekg antokg paipmel tu melnum okwripm a Maur Wailen pa kolpa yat pake. ");
INSERT INTO urim_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pake arein, kipm melnum a rpma antiwe ak wang ti pa kipm ikga uwi paipm. Eng ntei, kweikwei wor wor a kipm la ikga uwi pa, am kipm awi antiwe kolpake. ");
INSERT INTO urim_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Arein kipm melnum a rka wor al nikgwor ak wang ti, pa kipm ikga nikgilmpepm. Wa arein kipm melnum a rpma atopen inyo katnong ak wang ti, pa kipm ikga akg rein paipm. ");
INSERT INTO urim_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Arein kipm melnum a tu ngkat nang akipmen pa, pa kipm ikga uwi paipm, eng ntei, tu yantin mamin wror wror akipmen pa, am pikekg ngkat nang a tu melnum okwripm kansil kolpa yat pake.” ");
INSERT INTO urim_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Wa Sisas kil wa la kolkil la, “Pake kupm laniki kipm melnum a atning yangkipm a kupm la pa, kipm mpa plan ipma wor wasrongen tu wrongmanto alkipm pa. Kipm mpa plan nikgwalpm wor kai eng tu a ipma paipm eng kipm pa. ");
INSERT INTO urim_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kipm mpa oklala niki Maur Wailen eng kil uk wor ngklin tu melnum a la lalongentepm pa. A wa laniki Maur Wailen la kil ngklin tu a arpmen paipmelepm pa. ");
INSERT INTO urim_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kol melnum ur oreitn kai tangkwei wompel pa, wa kitn wa plelng tangkwei wompel pa wa kil oreitn. Aki kol melnum ur iner apm wakget a kitn nowe eng wropuk pa, wa kitn wa iner apm ur a kitn nowe ti wa lkel, ampur wa kitn wa langkinen pa. ");
INSERT INTO urim_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kol mla ur kil ik ok la, la kitn lkel kweikwei ur pa, kitn lkel kolti. A mlaur awi kweikwei akitn ti aye kai pa, ampur wa kai la eng wa awi aye yaper kul pa. ");
INSERT INTO urim_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kipm wasrongen la tu mla ur iktepm kolai pa, mpa kipm ti ikten kolpake. ");
INSERT INTO urim_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kol kipm plan ipma wor wasrongen tu mla ur a plan ipma wor wasrongen kipm pa kolti pa, mpa Maur Wailen kiporngtepm yangkipm la kolai? Ti tu melnum a antokg paipmpaipm pa am wa plan ipma wor wasrongen tu melnum a plan ipma wor wasrongenten kolpa yat pake. ");
INSERT INTO urim_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","A kol kipm antokg wor eng mla ur a antokg wor eng kipm pa, mpa Maur Wailen kiporngtepm yangkipm la kolai? Ti tu a antokg paipmpaipm pa, am wa ak kolpa yat pake. ");
INSERT INTO urim_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Wa kol kipm uk kweikwei akipmen pa kai mla ur a kipm akwonalmpen la ikga tu ikilmpentepm pa, mpa Maur Wailen kiporngtepm yangkipm la kolai? Ti tu melnum a antokg paipmpaipm pa am wa ak kolpa yat pake. Tu uk kuloken mla ur a tu ariwe la ikga tu ikilmpenten kiti kiti kolpake. ");
INSERT INTO urim_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pake kipm mpa plan ipma wor wasrongen tu wrongmanto alkipm pa, a ntokgten riworwor, a lken kweikwei pa kolti, ampur wa kipm akwen. Eng ikga kipm uwi kweikwei wailet wor wor, wa kipm plan kipm alkipm kol a kipm warim a Maur Wailen a itna ep angen kweikwei wrongkwail. Eng ntei, kil pa melnum a plan ipma wor tu melnum a ake alkel wor, a tu a antokg paipmpaipm. ");
INSERT INTO urim_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kipm rein tu wrongkwail, kol a Maur Wailen, Yan alkipmen, arein kipm wrongkwail pa.” ");
INSERT INTO urim_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Wa Sisas kil wa la kolkil la, “Ampur ari elukgen melnum ur pa la paipm pa, pa ikga wa Maur Wailen kil ri elukgen kipm ti la kipm paipm. Ampur elng wam itna melnum ur la kil ikga uwi paipm pa, pa ikga wa Maur Wailen wa elng wam itni kipm ti yat la kipm ikga uwi paipm. A kipm mpa ungkwan paipmpaipm a mla ur eng ikga wa Maur Wailen wa ungkwan paipmpaipm akipmen ti yat. ");
INSERT INTO urim_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kipm uk kweikwei mla ur pa, pa ikga wa Maur Wailen wa lkepm kol pake. Atom ikga kipm uwi nimong wail, watnompen ngklin no pik waiwai ampei iken. Kipm lupm nimong kolai uk mla pa, ikga wa Maur Wailen ikilmpentepm nimong kolpake.” ");
INSERT INTO urim_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Wa Sisas kil wa la yangkipm kla ur kil wa la, “Antiwe mpa melnum wulmpa tilmpisen ur plan ya melnum wulmpa tilmpisen ur pake? Pa akentiwe, mpa tuwekg yatenen ngko elng kinar wrik tungkuren pa. ");
INSERT INTO urim_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Melnum a awi ariwe pa ake itna angen melnum alkil a kaling plantel pa. Kil uwi ariwe pa plalng pipa, kil ikga palng kolen melnum alkil a kaling plantel pake. ");
INSERT INTO urim_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Antokg kolai atom kitn wa ari ipik waiketn a ela wulmpa a melnum ur alkitn pa, pake ake wa kitn ari yo wompel wail a ela wulmpa alkitnen ti! ");
INSERT INTO urim_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Antokg kolai atom kitn lanaki kil pa la, 'Melnum wor alkupmen, itni eng kupm kiplim ipik ur pa tukuleikgteitn wulmpa pa ri.' Pake ake kitn ari yo wompel wail a ela wulmpa alkitnen ti? Kitn melnum a kansil plan ak num enen ti kolti. Kitn uwi yo wompel wail a ela wulmpa alkitnen pa ep, atom mpa wulmpa a kitn pa wor, eng mpa kitn ik ri ipik a ela wulmpa a melnum wor alkitnen pa kiplim tukuleikgentel.” ");
INSERT INTO urim_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Wa Sisas kil wa la kolkil la, “Yo wor pa ake mpa ngko ok paipm pa, a yo paipm pa ake mpa ngko ok wor pa. ");
INSERT INTO urim_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yo wris wris pa am ari kai yo ok alkil a angko pake. Mentepm ake anel tikga kulok aki tikga tukgun pa kai ampei iket paipm pa, aki anel ampei ok wain pa kai mi rungulet pa. ");
INSERT INTO urim_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Am kolpake, melnum a kil alupm nikgwalpm ariwe wor wor wailet pa, oklala a kil pa palng kul or kai wor. A melnum a kil alupm nikgwalpm ariwe paipm paipm wailet pa, oklala a kil pa palng kul or kai paipm. Oklala ur a palng wli ok a melnum pa la pa, pa am plan nol nikgwalpm akilen pa am kolpake.” ");
INSERT INTO urim_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Wa Sisas kil wa la kolkil la, “Antokg kolai atom, kipm akwe nang a kupm ti la, 'Wailen, Wailen', pake ake kipm antokg katila kuina ur a kupm lanakepm pa? ");
INSERT INTO urim_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mpa kupm plantepm melnum a kul eng kupm ti, atom atning katnun katila yangkipm akupmen pa, la kil melnum kolai. ");
INSERT INTO urim_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kil pa kol melnum a ale wan. Kil ak lkim pa watin, atom uwen ong pa itna wrik kangirngket. Kop pa u nar ak anel wan pa, ari ake wa or, eng ntei, wan pa pikekg kil ale ariworwor. ");
INSERT INTO urim_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pake melnum a kil atning yangkipm akupmen pa, ari ake wa kil katnun katila pa, kil pa kol melnum a ale wan, atom ak lkim tukwok, uwen ong pirpar paipm. Kop u nar ak anel wan pa, am tapor or kai prapm paipm ise.” ");
INSERT INTO urim_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sisas la yangkipm ok kweikwei pa naki tu wrong kin kipman pa plalng pipa, kil kai Kaperneam. ");
INSERT INTO urim_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kai anong pa, melnum mring tukgunakg ur a tu Rom a ikgalen tu melnum kamel wampwomis a almpwrong pa rpma, pake melnum akwapel ur alkil pa numpet paipm rmpa, wreren eng a imo tike. Melnum pa, mring tukgunakg alkil pa wasrongentel paipm. ");
INSERT INTO urim_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kil atning a Sisas akwap itna Kaperneam ti, atom kil ukwa tu melnum wailen tiur a Suta pa la, tu kai isentel la, kil kul eng ungkwan numpet a melnum akwapel alkilen pa. ");
INSERT INTO urim_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tu kai eng Sisas pa, atom tilpel titnongket la, “Melnum pa melnum wor amenen, kol a kitn kai ngklinsel eng ntokg melnum akwapel akilen pa palng wor pen. ");
INSERT INTO urim_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Eng ntei, kil plan ipma wor wasrongen mentepm Suta ti, a kil pikekg angklinso alento wan a men atning atning yangkipm a Maur Wailen atne pa.” ");
INSERT INTO urim_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Sisas awi wor, atom kil wrekg antiwen kai. Kil kai wreren wan pa, ari mring tukgunakg pa ukwa tu yiprokgen alkil pa kai angkeng Sisas pa la, “Wailen, alkeitn kwap wail, kupm ti ake melnum wor, eng mpa kitn kul wan akupmen ti. ");
INSERT INTO urim_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kupm ari kupm alkupm ti la, ake mpa wor eng kupm alkupm ti kai riweitn. Kolpa atom ari kupm ukwa melnum akwapel alkupm pa kai ariweitn. Ti kitn itni ti o, la ik ok ti kolti, eng mpa melnum akwapel akupmen ti palng wor. ");
INSERT INTO urim_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kupm ti wa itna orngwatneikgen tu melnum tiur a itna ep, wa kupm ti wa itna ep ikgalen tu melnum a almpwrong. Atom kupm la melnum ur la kil kai pa, kil mpa kai, kupm la melnum ur la kil kul pa, kil mpa kul, kupm la melnum akwapel alkupmen pa la, kil ntokg kweikwei pa, kil mpa ntokg.” ");
INSERT INTO urim_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sisas atning yangkipm a kil la pa, kil wrekg paipm. Kil plelng wa lanaki tu wrong kin kipman wailet a katnuntel pa la, “Ake kupm atning ari melnum ur a kipm Isrel pa ukipma titnongket kol mring tukgunakg kil pa.” ");
INSERT INTO urim_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Atom tu melnum a wuten mring tukgunakg alntuwen ukwawen kul pa, anel yaper kawor wan pa, atom tu ari melnum akwapel a mring tukgunakg pa am palng wor ise. ");
INSERT INTO urim_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Itna waiketn pa, Sisas wa wrekg a pa wa kai anong wail a namput la Nain, nampokgen tu melnum alkil a katnuntel pa, a tu melnum wrong kin a kipman wailet pa tu wa antiwel kai. ");
INSERT INTO urim_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tu kai kolpa kaingkai, angko wreren yipmingki yayun a anong Nain pa, tu ari melnum yipmiri ur pa a tu ngkat aye or. Melnum a amo pa pati, warim kipman wrisen a kin karpikg yek ur. A tu wrong kin a kipman wailet a anong pa akupewel aye melnum yipmiri pa or. ");
INSERT INTO urim_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ak wang a Wailen kil ari kin karpikg yek pa kolpa, ipma akil pa ak areinsel paipm. Atom kil lanakel la, “Ampur kitn yek akg.” ");
INSERT INTO urim_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","A kil kai wamanti wrik a tu ngkatel pa, a tu a ngkatel pa wa anel itna. A Sisas lanaki melnum yipmiri a rmpa pa la, “Melnum warimpen kupm lanakeitn la, kitn wrekg o!” ");
INSERT INTO urim_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Melnum yipmiri pa wrekg rpma, a kil oklala, atom Sisas lanakel la kil kai eng man yek alkil pa. ");
INSERT INTO urim_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tu wrongkwail tu ari kolpa, tu wrekg ngkark paipm wrisen, a tu ngkat nang a Maur Wailen. Tu lala, “Melnum okwripm a Wailen am palng itna kuin amentepmen tike. Maur Wailen am nar ise, la ngklin mentepm wrong kin a kipman alkilen.” ");
INSERT INTO urim_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Atom tu aye yangkipm a Sisas antokg melnum yipmiri pa wrekg kai naki tu yela anong kanokg Sutia, a anong kanokg a ela wreren Sutia pa. ");
INSERT INTO urim_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Tu watnom a Son kil aro arowonel pa, tu lakati nakel kweikwei a Sisas antokg, atom Son akwe melnum wekg pa kulntel, ");
INSERT INTO urim_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","atom kil ukwawen kai asen Sisas pa ri la, “Kitn melnum pikekg Maur Wailen la ukwa nar eng la ikga ik rmpento ampake, aki ikga men rpmi nungkwangen melnum ur a wai?” ");
INSERT INTO urim_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tuwekg kai palng eng Sisas pa, tuwekg lala, “Son, melnum a kaluk tu pa, ukwawo kul la mentekg isenteitn la, 'Kitn melnum pikekg Maur Wailen lala ukwaweitn nar am tike, aki ikga men rpmi nungkwangen melnum ur a wai?'” ");
INSERT INTO urim_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ak wang pa Sisas antokg tu melnum numpet auraur, melnum a maur paipm arpme, a tu melnum watipmen a wulmpa tilmpisen pa palng wor kolpa itna. ");
INSERT INTO urim_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Atom kil akalmpe yangkipm a melnum wekg pa la, “Yaper kai lakiti niki Son pa kweikwei a kipmekg atning ari ti, la melnum a wulmpa tilmpisen ti palng wulmpa ore ari kweikwei, nepm paipmen wa tu angkom wor, melnum a i paipuk awi pa tu palng wor, nungkulkg titnowen pa tu atning kweikwei, tu melnum a amo ut pa tu wa wrekg rka, wa yangkipm wor a la Krais ti, angkli eng tu melnum a rka tukwok. ");
INSERT INTO urim_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Melnum ur a ake uk yirokg elukgen kupm ti pa, kil pa wor pake, kil itopen o!” ");
INSERT INTO urim_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Melnum wekg a aye yangkipm a Son pa kul la pa, atning yangkipm a Sisas la pa plalng pa, tuwekg wa yaper kai pipa, Sisas kil lakati Son pa lanaki tu wrongkwail kin a kipman pa la, “Pikekg Son kil angkli yangkipm itna wrik kalpmlel ur pa, kipm pikekg kai la ri kuina? Kipm kai la ri warum a wripm almpen pake? ");
INSERT INTO urim_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kipm pikekg kai la ri kuina? Melnum a nowe apm wor wor aki? Tu melnum a nowe apm wor wor kolpa pati, tu mpa kipm ri kai wan wail a tu melnum tukgunakg a antiwe kweikwei wor wor ai. ");
INSERT INTO urim_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Aki kipm kai la ri na? Kipm kai la ri melnum okwripm a Maur Wailen? Ei aklale, kupm lanakepm la, Son pa wa wailen angen melnum okwripm wrongkwail ai. ");
INSERT INTO urim_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Son pa melnum a pikekg Maur Wailen la kolpa, 'Kitn itning, kupm ikga ukwa melnum a aye yangkipm pa iye ep eng kitn. Melnum pa kil ikga ep numprampen ya eng kitn.' ");
INSERT INTO urim_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kupm lanakepm la, itna kuin a tu melnum wrongkwail a pikekg man raku pa, ake melnum ur wailen angen Son pa. Pake melnum a awi nang wasek itna kuin a tu melnum a Maur Wailen itna wailen ikgalen nol nikgwalpm atuwen pa, kil pa awi nang wailen angen Son pake.” ");
INSERT INTO urim_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tu plalngten, kin a kipman nampokgen tu melnum a awi marpmel tu pa, anel atning yangkipm a Sisas la pa, atom tu ariwe la, ya a Maur Wailen pa ute wor pake. Tu melnum pa pati, tu pikekg awi wor atom Son kil kaluken. ");
INSERT INTO urim_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pake tu melnum a arpmen yangkipm yiprokgen a Moses a tu melnum a aroaro wonel tu yangkipm a Moses pa, anel uk yirokg ya wor a Maur Wailen akten pa. Tu melnum pa pati, tu pikekg karken atom ake pikekg Son kaluken. ");
INSERT INTO urim_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Atom Sisas lanaken la, “Mpa kupm la kipm melnum ak wang ti la kipm melnum kolai? ");
INSERT INTO urim_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kipm kol tu warim pa, anel rka anong akapm pa. Kipm warim tiur pa lanaki tu warim tiur pa la, 'Men tiplam wampeng ti, pake ake wa kipm wa plel plel, men ak ok namputen, pake ake wa kipm akg arein.' ");
INSERT INTO urim_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Am wa kolpa yat pake, Son, melnum a kaluk tu pa, pikekg kul, kil uk wang Maur Wailen, ake kil al u wain a okipma wor pa, pake kipm lawel la maur paipm rpmawel. ");
INSERT INTO urim_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Warim Kipman a Melnum pa nar pa, kil al u wain a okipma wor pa, pake wa kipm wa la, 'Kipm ri melnum kil! Kil al u a okipma pa wailet, kil melnum yiprokg ur a tu melnum a awi marpmel mentepm ti, a tu melnum paipm tiur ai.' ");
INSERT INTO urim_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kipm am kolpake, kipm elukgen Son, wa kipm elukgen Warim Kipman a Melnum ti. Pake nikgwalpm ariwe wor wor a Maur Wailen pa plan aklale kai tu melnum a atning katnun pake.” ");
INSERT INTO urim_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Melnum a arpmen yangkipm yiprokgen a Moses ur pa, nang akilen pa Saimon, kil akwen Sisas la kai ntiwel il okipma, atom Sisas kai wan a melnum a arpmen yangkipm yiprokgen a Moses pa antiwel al okipma pa rpma. ");
INSERT INTO urim_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kai anong pa, kin wris ur a antokg paipmpaipm pa rpma. Kil atning la Sisas anti melnum a arpmen yangkipm yiprokgen a Moses pa al okipma rpma wan akilen pake. Atom kil aye wes kaingkuren ari wor ur a u yaprekget wor arkewe pa aye kai kawor. ");
INSERT INTO urim_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Atom kil kul itna wreren nepm a Sisas pa akg, a ikgakg pa ungkwan kul nar kaluk nepm a Sisas. Atom kil alo ikgakg pa ak tukgunakg walk alkilen pa, wa nakron nepm a Sisas pa. Plalng pa, kil alung u yaprekget wor pa ak kaluk nepm akilen pa. ");
INSERT INTO urim_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Melnum a arpmen yangkipm yiprokgen a Moses a wuten akwentel kai al okipma pa ari kolpa, kil la kai kil alkil pa la, “Kol melnum ti kil melnum okwripm a Maur Wailen pa, kol a kil riwe kin a wamparpmewel pa la, kil kin kolai, kol a kil riwe la, kil kin a antokg paipmpaipm am pake.” ");
INSERT INTO urim_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ari Sisas kil ari nikgwalpm a Saimon pa ise, atom kil lanakel la, “Saimon, kupm la lanikeitn yangkipm ur kil.” Ari wa kil wa kapor won lanakel la, “Melnum a kaling plan tu, wor pa, lanikopm o!” ");
INSERT INTO urim_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Atom Sisas lanakel yangkipm kla ur kil la, “Melnum wekg ur pikekg tuwekg awi kuloken kai melnum ur. Ur awi marpm wail wrkapm kamel wekg tuwek wampwam, a ur awi marpm wusok wrkapm wampwomis. ");
INSERT INTO urim_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tuwekg angkli pa kai plalng pa tuwekg rpma tukwok, tuwekg ur ake antiwe mpa ikilmpe marpm pa, atom melnum a alken marpm pa areinsen, atom lanaken la, kai itni pa, ampur tuwekg akalmpe kuloken pa! Ti mla a i a tuwekg pa mpa plan ipma wor wasrongentel pa?” ");
INSERT INTO urim_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ari wa Saimon akalmpe la, “Kupm akwonalmpen ari mpam melnum a kil ungkwan kuloken wail a kil awi pake.” Atom Sisas la, “A kitn akalmpe pa ute pake.” ");
INSERT INTO urim_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Atom kil plelng kai kin pa, a la kai Saimon pa la, “Kitn ari kin ti. Kupm or wan akitnen ti, ake kitn ak u ur klakopm nepm ti. Pake kin ti kil klakopm ak ikgakg ti, atom wa alowopm ak tukgunakg walk alkilen ti. ");
INSERT INTO urim_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kupm or wan akitnen ti, ake wa kitn ti alkopm wor nakrontopm, pake kin ti am nakron nepm akupmen ti kolpa rpma tike. ");
INSERT INTO urim_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ake kitn numprampen uyiwa wor eng alung ak anel tukgunakg akupmen ti, pake kin ti alung u yaprekget wor a kil ti ak anel nepm akupmen ti. ");
INSERT INTO urim_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kolpa ti kupm lanakeitn la, kitn ri kin ti, kil pa plan ipma wor wasrongentopm worwor ai, pa plan la paipmpaipm wailet akilen pa am wet Maur Wailen ungkwan plalng ise. Mla ur a ake antokg paipmpaipm wailet atom Maur Wailen kil ungkwan pa, kil pa ake plan ipma wor wasrongentopm.” ");
INSERT INTO urim_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Atom Sisas lanaki kin pa la, “Paipmpaipm akitnen pa am kupm ungkwan ise.” ");
INSERT INTO urim_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ari tu melnum tiur a antiwel al okipma rka pa la kai tu alntu pa la, “Melnum kolai ti, atom kil ak ok aloken kil alkil ti la kil antiwe titnongket a ungkwan paipmpaipm ti?” ");
INSERT INTO urim_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pake Sisas lanaki kin pa la, “Kitn ukipma, atom Maur Wailen akawiyeitn takuleikgen paipmpaipm akitnen, ti kitn kai wor o, kitn kai nimpokgen ipma meen wor!” ");
INSERT INTO urim_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wang aripm ur kai plalng pa, Sisas kil wrekg atn kai anong wail wail a anong wusok wusok, angkli yangkipm wor lanaki tu wrong kin kipman pa la tu elng Maur Wailen pa itni wailen ikglen nol nikgwalpm atuwen. Tu watnom wampwam yikakwekg alkilen pa antiwel atn, ");
INSERT INTO urim_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","a wa nampokgen tu kin tiur a pikekg kil ungkwan maur paipm a pikekg arpmewen pa a tiur a numpet pa wa palng wor pa, tu pa wa antiwel yat. Nang atuwen pa, Maria a kai anong Maktala, a pikekg Sisas ungkwan maur paipm wampwomis wampwompwekg takwleikgtel pa. ");
INSERT INTO urim_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Soana, Susana a tu kin watipmen tiur ai. Soana pa kin a Kusa, melnum wailen ur a ikgalen wan a melnum tukgunakg Erot. Tu kin pa tu uk kweikwei alntuwen ti kai eng ak angklin Sisas nampokgen tu watnom alkilen pa kolpa atn pake. ");
INSERT INTO urim_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tu wrong wailet paipm anel a pa a pa wli, atom Sisas la yangkipm kla ur pa la, ");
INSERT INTO urim_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Melnum ur pa kai laik wanukg erk kai wring alkilen. Kil laik yela wring pa, atom tiur pa angko nar rmpa ya milik pa, atom tu rkganti tiur, a wel al tiur. ");
INSERT INTO urim_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tiur pa angko nar rmpa wrik weset, atom anip kaino, ari kanokg ti tingklak kalnten atom amo, eng ntei, ake kanokg apen rurusen wor pa. ");
INSERT INTO urim_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wanukg erk tiur pa angko elng nar rmpa mi iket pa, anip nampokgen tita, atom mi iket pa akaparng. ");
INSERT INTO urim_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","A tiur pa angko elngnar rmpa wring wunong kanokg wor, atom anip kaino wailet paipm klangkil ise.” Sisas la yangkipm kla pa kai plalng pa, kil wa la yikakatnen la, “Kipm melnum a nungkulkg atnewe pa, kipm itning o!” ");
INSERT INTO urim_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tu watnom a Sisas kil aroaro wonel pa asentel la, “Yiprokgen a yangkipm kla ti pa la kolai?” ");
INSERT INTO urim_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Sisas akalmpe la, “Nikgwalpm ariwe ampen a Maur Wailen kil ikgalen ipma a melnum pa, kil plan kipm ti kolti. Pake tu wailet tiur ai pa kupm laron naken ak yangkipm kla ti kolti, eng mpa tu ikitnen, pake ake antiwe mpa tu ri pa, a mpa tu itning, pake ake antiwe mpa tu uwi riwe worwor.” ");
INSERT INTO urim_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Atom Sisas laron yiprokgen a yangkipm kla a wanukg erk ti naken la, “Ti kipm itning yiprokgen a yangkipm kla kil pati la kolkil la: wanukg erk pa ti, pa la yangkipm a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wanukg erk a angko nar rmpa ya milik pati, pa la tu a atning yangkipm wor a Maur Wailen, pake Maur Paipm awi yangkipm pa takwleikgten, eng ampake tu ukipma Maur Wailen pa, eng mpa kil ikuwiyen eng alkilen. ");
INSERT INTO urim_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Wanukg erk a angko nar rmpa kanokg weset pa ake angkli ningnakg pa elng kinar kanokg pa pati, la tu melnum a atning a awi yangkipm a Maur Wailen pa atopen. Pake ake tu awi alupmen pa, tu ukipma itna waiketn kolti. Kweiur a ak arkolngken eng tu angko pa, tu am wa angko yaper kai ise. ");
INSERT INTO urim_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wanukg erk a angko nar rmpa mi iket wunen pati, pa la tu melnum a atning yangkipm a Maur Wailen, itna kolpa kai waiketnketn, ari kalpis, marpm, a kweikwei wor wor a ak atopen numpalk nampokgen kalkuten a itna kanokg ti alok yapowen, atom tu anip kaino arpongket paipm. ");
INSERT INTO urim_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","A wanukg erk a angko nar rmpa wring wunong kanokg wor anip kaino palng ari wor pati, pa la tu melnum nikgwalpm ute wor a atning alupmen yangkipm a Maur Wailen itna titnongket, kolpa atom tu anip kaino wailet paipm.” ");
INSERT INTO urim_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","”Ake melnum ur la la wakg pa, atom ak kuntuk mipmapm pa ak aur pa, aki elng elngtirpma kinar wrik watneikgen ti. Kil la atom elng rka kaino kwa ti, eng mpa tu wrong la wli pa, mpa tu ri wakg pa. ");
INSERT INTO urim_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kuina ur a itna am pa, ikga iye kul kai ngko wunong. A kuina ur a aur pa, ikga ri uwi iye kai ngko wunong. ");
INSERT INTO urim_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kolpa ti kipm itning riworwor yangkipm a la pa. Eng ntei, melnum a kil antiwe pa, mpa Maur Wailen kil wa lkel ur wa iklanti. A wa melnum a kil ake antiwe pa, kuina ur a kil akwonalmpen la kil antiwe pa, mpa Maur Wailen kil ungkwan kai tukuleikg.” ");
INSERT INTO urim_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Man nampokgen tunteng wusok wusok a Sisas pa kul la riwel, pake ake antiwe mpa tu riwel, eng ntei, tu wrong watipmen paipm. ");
INSERT INTO urim_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kolpa atom melnum ur ai kawor naki Sisas pa la, “Man a tunteng wusok wusok alkitn itna kawor en a ti la riweitn.” ");
INSERT INTO urim_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ari Sisas akalmpe tu pa la, “Wor pake, tu wusok wusok a tu mantin akupmen pa pati, tu a atning katnun yangkipm wor a Maur Wailen.” ");
INSERT INTO urim_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wang ur ti pa Sisas nampokgen tu watnom a kil aroaro wonel pa anel awi nim ukupuken, pa atom Sisas naken la, “Mpa mentepm ngket elng or ti kai ukupuk wompel ai.” Atom tu anel angket kai. ");
INSERT INTO urim_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tu angket kai pa, Sisas pa am okg ise. Ari wripm mring mring wail pa el ak tiklas u pa elng kawor nim ukupuken, wreren eng a tipurngenten tu il u imo tike. ");
INSERT INTO urim_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tu watnom a Sisas pa kai aro ikgyokgel Sisas pa lala, “Melnum Wailen, Melnum Wailen, mentepm eng a kai paipm tike!” Atom Sisas pirpakg wrekg angkeng wripm mring mring a el pa, a u a naimpur tiklas pa, atom pa kai plalng kalpis kolti, a u ti terng rka om. ");
INSERT INTO urim_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Atom kil lanaki tu watnom alkilen pa la, “Kipm ti ukipma aki kalpis?” Pake tu wrekg paipm a ngkark, a tu lanaki tita la, “Kil ti melnum kolai, atom wa kil la wripm mring mring, a u a naimpur ti wa kai plalng ti!” ");
INSERT INTO urim_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tu rpma nim ukupuken pa angket or pa kul anong kanokg a Kerasa, a wet atnurng anong kanokg Kalili pa ela kai wompel ai. ");
INSERT INTO urim_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Sisas tipra a nim ukupuken pa nar kanokg, ari melnum ur a maur paipm arpme a pa ariwel. Wang watin kil atn numpalpen kolti, ake kil rpma kanokgel kai anong pa, kil rpma tatu wrik krongen a u mlamin eng alil melnum armpe armpe ti kolti. Melnum pa am rpma a a pake. ");
INSERT INTO urim_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kil ari Sisas pa, kil kirkar akg wail paipm angko rmpa nepm a kil ti a lanakel la, “Sisas, kitn Warim Kipman a Maur Wailen a Itna Ep angen kweikwei wrongkwail! Kitn la mpa ntokg na kupm ti? Ampur antokg paipm kupm ti.” ");
INSERT INTO urim_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kil la kolpa atnen wuten Sisas la maur paipm kimpilpet la kil or kai tukuleikgentel. Akangklei wang maur paipm pa almpla titnowel, atom tu angkuten nepm wampel ak ampei mpangen, a ampei mringen pa. Pake maur paipm kangku ampei pa, alok melnum pa titno titno aye kai takwleikgen wrik a tu melnum arpme pa. ");
INSERT INTO urim_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sisas asentel la, “Nang a kitn ti mla?” Kil akalmpe la, “Nang a kupm pa Wrong Watipmen.” Yiprokgen a kil la kolpa pati maur paipm watipmen pa arpmewel a pa. ");
INSERT INTO urim_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tu maur paipm pa kirkar la kai Sisas pa la, “Ampur ungkwanto elng kinar lkim watin kinar tak ai a plalng kalpisen pa.” ");
INSERT INTO urim_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Manto wailet pa anel atniir al tuwol itna kaino krongkwang pa. Atom tu maur paipm lanaki Sisas pa la, “La men ti kai kawor nowe manto pawo!” Atom Sisas la tu maur paipm pa kai kawor nowe manto pa. ");
INSERT INTO urim_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tu maur paipm ngkark angkawor melnum ti or kai elng kawor nowe manto ti. Atom manto pa anel ngkark raras angkaino krongkwang ti kulnar angko kimeket elngkinar ukupuk ai, al u amo plalng. ");
INSERT INTO urim_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tu melnum a ikgalen manto pa ari kolpa, atom tu ngkark pirng atatu aye yangkipm pa kai naki tu melnum kai anong wail ai, a anong wusok wusok a ela wreren tatu pa. ");
INSERT INTO urim_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tu wrong kin a kipman pa anel kai ari kweikwei a wet palng pa. Pa tu ari melnum a wet maur paipm ngkark takwleikgtel pa rpma kai nepm a Sisas ai, nowe apm pa ti rpma. Kil am palng wor wontrakole ise, atom tu ngkark. ");
INSERT INTO urim_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tu melnum tiur a wet itna ari pa tu wa lakati naki tu tiur a wli pa, la maur paipm pa wuten wrekg or kai takwleikgen melnum pa kolai. ");
INSERT INTO urim_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Atom tu wrong kin a kipman a anong kanokg a Kerasa pa ari kolpa, tu ngkark, atom tu ungkwan Sisas la kil yaper kai. Atom Sisas wa tipra elng kaino nim ukupuken ai, kil la yaper kai tike. ");
INSERT INTO urim_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ari melnum a wet Sisas ungkwan maur paipm takwleikg pa lanaki Sisas pa la, “Kupm a ntiweitn kai.” Ari Sisas akrarowel la, ");
INSERT INTO urim_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Yaper kai anong pa laniki tu kweikwei a Maur Wailen antokg eng kitn pa.” Melnum pa atning kolpa, kil kai lanaki tu wrong kin a kipman a rka anong pa yela kuina ur a wet Sisas antokg kai kil ti. ");
INSERT INTO urim_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tu wrong kin kipman kul ukupuk wompel pa rka nungkwangen Sisas pa rka. Atom Sisas yaper kul palng pa, tu atopen paipm eng kil kulnten pa. ");
INSERT INTO urim_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ari tu ari melnum ur a itna tukgunakg eng ikgalen wan a tu atning atning yangkipm a Maur Wailen atnewe pa, nang akilen pa Sairus, kil wli kolti elng angko rmpa wreren nepm a Sisas ti, a lanakel la tuwekg kai wan anong akilen. ");
INSERT INTO urim_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Eng ntei, warim kin tangkis wris nangket akilen pa am ikganti nol tike. Sisas angkom kai pa tu wrong watipmen paipm a pa kul kai antiwel ak num anel tita angkom antiwel kolpa kai. ");
INSERT INTO urim_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kin ur a num walmpopm alp wring wampwam yikak wekg pa anti tu pa kai. Kil angkli marpm alkil ti kai plalng la kol a tu melnum a antokg i numpet pa ntokg numpet a kil pa palng wor. Ari ake wa melnum ur antiwe a angklinsel, eng mpa kil palng wor. ");
INSERT INTO urim_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kil ak aroro wrong kuin ti a yirokg pa kai kaino wamanti apm a Sisas pa, atom num walmpopm a kil a alp pa kai plalng. ");
INSERT INTO urim_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Atom Sisas asen tu pa la, “Mla wamantiwopm pa?” Ari tu wrong kin a kipman pa la, “Ake tu mlaur wamantiweitn.” Atom Pita la, “Wailen, ake kitn ari tu wrong kin a kipman ti ak talpul tita ak num aneleitn ti.” ");
INSERT INTO urim_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pake Sisas lala, “Melnum ur wuten wamantiwopm pa. Ti kupm ariwe la titnongket akupmen wuten angklin melnum pa ise.” ");
INSERT INTO urim_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kin pa am ariwe la tu am ariwel ise, atom kil warwar kolti kai kaino itna ikgokg a Sisas ai, kapor kilko aleinsel. Kai wulmpa a tu wrongkwail pa kil la yiprokgen a kil wamanti Sisas pa, a numpet a kil pa palng wor ak wang ketn pa. ");
INSERT INTO urim_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Sisas lanakel la, “Kin yek alkupm, kitn ukipma kupm ti atom kitn palng wor pake. Kitn kai o! Ampur kitn ipma kaikuten.” ");
INSERT INTO urim_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sisas la pa itna, ari melnum ur angkai wan a melnum itna tukgunakg a ikgalen wan a atning atning yangkipm a Maur Wailen atnewe pa, aye yangkipm pa kul lanaki yan a warim pa lala, “Kai ngkeng Melnum Wailen pa kil rpmi pawo! Warim kin kitn am amo ise.” ");
INSERT INTO urim_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pake Sisas atning pa atom kil la kai Sairus, “Ampur kitn ipma kaikuten, ukipma kolti, kil mpa palng wor pa.” ");
INSERT INTO urim_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kil kai palng wan pa, kil angkeng tu wrongkwail pa itna en pa, kil la mpa Pita, Semis, Son nimpokgen mansan a warim kin pa kolti ntiwel kawor. ");
INSERT INTO urim_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tu wrong tiur a rka kawor wan pa akg ak ok namputen warim kin pa rka. Sisas kil lala, “Ampur kipm akg! Warim ti ake amo, palpa kil okg rmpa pa.” ");
INSERT INTO urim_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tu atning kolpa, tu wa anel akinyo alm Sisas pa, eng ntei, warim pa am wuten amo ise. ");
INSERT INTO urim_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pake Sisas kai wamanti wam a warim kin ti akwewel la, “Warim kin, kitn wrekg o!” ");
INSERT INTO urim_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Atom maur wor pa yaper kul nakurng yipmiri alkil ti kolti, kil wrekg. Atom Sisas lanaken la ikor okipma ur ai iye kul lkel il. ");
INSERT INTO urim_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tu mansan akilen pa wrekg paipm, pake Sisas lanaken la, “Ampur kipmekg lanaki tu tiur kweikwei a wuten palng ti.” ");
INSERT INTO urim_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sisas akwe tu watnom wampwam yikakwekg a kil aroaro wonel pa anel kul itna wris, atom kil alken titnongket a alken ong talpen la mpa tu ntiwe a ungkwan maur paipm a i numpet a tu melnum pa palng wor. ");
INSERT INTO urim_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Atom kil ukwawen la tu kai ngkli yangkipm niki tu yangkipm wor a la Maur Wailen la itni wailen ikglen nol nikgwalpm atuwen, wa ntokg numpet a tu melnum a awi numpet pa palng wor. ");
INSERT INTO urim_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kil lanaken la, “Ampur kipm aye yotuk a ak atnen pa, a apm kok, marpm a okipma kweikwei pa aye nakur num pa. A apm pa kipm iye a kipm nowe itna num ti iye kai kolti. Kipm wampwampwris kolti. ");
INSERT INTO urim_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tu uwi wor eng wan ur la kipm rke pa, kipm rki wris i pake. Wang ur a kipm la kai anong ur ai pipa, kipm wrekg i pa kai. ");
INSERT INTO urim_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tu melnum a anong ur la ungkwantepm kai pa, pa kipm kilkwin nepm yipur ti itni pa, eng mpa tu ri. Pa kol yangkipm ur a ak lawen am pake, la tu a antokg paipm.” ");
INSERT INTO urim_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tu watnom wampwam yikakwekg a Sisas pa tu atning yangkipm a kil la karkurngken plalng pa, tu wrekg atnuurng anong pa, anel atn kai yela anong wrongkwail pa, angkli yangkipm wor a la Krais pa, wa ak ungkwan numpet a tu pa palng wor. ");
INSERT INTO urim_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erot, melnum tukgunakg a ikgalen anong kanokg Kalili, kil atning kweikwei watipmen a Sisas akwap kolpa atom, kil akwonalmpen watipmen titnowen num rpma kolti. Eng ntei, tu melnum tiur pa wa la, Son a pikekg kaluk tu, kil a pikekg amo, am wa wrekg rpma akwap pake. ");
INSERT INTO urim_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wa tu tiur pa la, “Pa kalpis, pa mpa Elaisa pa palng akwap pa mol.” Wa tu tiur pa la, “Palpa melnum okwripm manet ur a pikekg amo ak ai, ti wa wrekg a kirk pa or pa.” ");
INSERT INTO urim_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Atom Erot lala, “Son am pikekg kupm angket mengkel amo ise, pake wa mla wa rpma wai, ti antokg kweikwei ai?” Erot kil angkweingen la kil a ri Sisas. ");
INSERT INTO urim_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tu watnom a pikekg Sisas ukwa kai akwap pa yaper wli lanakel kwap wrongkwail a tu atn ak pa. Atom Sisas awiyen a pa am wa anel kai wrik ur a wreren anong ur a namput la Petsaita pa, takwleikgen tu pa la tu a kai rki ik tu alntu kolti. ");
INSERT INTO urim_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pake tu wrong kin a kipman maur alkil pa atning kolpa anel kai wa katnunten. Kol a Sisas ngkengken, ari kalpis, kil wa alken wor kolti, a kil wa lanaken yangkipm wor a la Maur Wailen pa itna wailen ikgalen nol nikgwalpm atuwen. A tu tiur a numpet pa kil antokg numpet a tu pa wor. ");
INSERT INTO urim_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Wreren eng a takgni pa kinar pelpel eng a ngkon pa, tu watnom wampwam yikak wekg pa kai lanakel la, “Ukwa tu ti kai o, eng mpa tu kai anong ai, a kai tutu palpa, eng mpa tu ikor okipma ai il okg! Eng ntei, ti wrik kalpmlel.” ");
INSERT INTO urim_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ari wa Sisas lanaken la, “Kipm alkipm ti ikor okipma ur eng tu il tike!” Tu watnom alkil pa akalmpe la, “Ti kitn la la mpa men kai rmpen okipma ur ai eng tu wrong wailet pake? Men aye ti pa nok tingklak wampwomis a yul wekg kolti.” ");
INSERT INTO urim_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tu melnum pa wailet paipm ai, kamel kamel (5,000). Ari Sisas lanaki tu watnom alkilen pa la, “Wako tu melnum pa rki kamel wekg tuwek wampwam, kamel wekg tuwek wampwam!” ");
INSERT INTO urim_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tu watnom alkilen antokg kol a Sisas la pa, atom lanaken la tu rki kanokg. ");
INSERT INTO urim_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tu rka pa, Sisas awi nok tingklak wampwomis pa a yul wekg pa, ikg kaino kitnong pa a, ukwor Maur Wailen eng pa, atom kil kapor uk tu watnom alkil pa, la tu mpreing uk wrong kin a kipman pa. ");
INSERT INTO urim_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tu al al ining, tu nikgwor paipm, atom okipma umpu umpu pa tu awi aye wli alupm rkwa wail wampwam yikakwekg pa rpma. ");
INSERT INTO urim_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wang wris ur pa Sisas alkil wris kai oklala naki Maur Wailen, atom tu watnom alkilen pa wa kai katnuntel. Atom Sisas asenten la, “Kipm atning tu wrong kin a kipman ai tu akor la kupm ti la kupm mla?” ");
INSERT INTO urim_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tu akalmpe la, “Tu tiur pa la kitn Son, melnum a pikekg kaluk tu. A tiur pa la la kitn Elaisa, a wa tu tiur pa la kitn melnum okwripm ur a pikekg amo ep ai, atom wa kitn wa wrekg.” ");
INSERT INTO urim_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wa kil wa asenten la la, “Ti kipm ti? Kipm akwonalmpen la kupm ti mla?” Ari Pita akalmpentel la, “Kitn melnum a Maur Wailen takweiyeitn, atom ukwaweitn nar la ikirmpen men wrong kin a kipman.” ");
INSERT INTO urim_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Atom Sisas naken titnongket la ampake tu laron kil ti niki tu mla ur ai. ");
INSERT INTO urim_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Atom wa kil wa la, “Warim Kipman a Melnum ikga rki kalkuten wailet, a kil ikga tu melnum wailen wailen, a tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen, a tu melnum a aroaro wonel tu yangkipm a Moses ikga tu tulpulng ungkwantel. Kil ikga tu ilmpel imo lilel rmpi wang wraur, atom wa wrekg.” ");
INSERT INTO urim_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Atom Sisas la kai tu wrongkwail pa la, “Kol melnum ur la kul kutnun kupm ti pa, kil mpa elngen a katnun nikgwalpm a kil alkil pa, a kil mpa rki yo okgmangki alkilen pa ikngklei wang, atom kul kutnuntopm. ");
INSERT INTO urim_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kol melnum ur la ikglen numpalk a kil ti kolti pipa, pa amen wor akilen pa ikga kai paipm. A kol melnum ur kil uk numpwam akilen pa eng ik ik kwap akupmen ti pa, pa kil mpa rkolng yaprekg watin eng rpmi wor yongkyong. ");
INSERT INTO urim_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kol melnum ur uwi kweikwei wrongkwail a itna kanokg ti, atom ik ntokg kil melnum ti ikga kai paipm kai anong paipm pa, ikga kweikwei pa wa ngklinsel la kolai? ");
INSERT INTO urim_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kol melnum ur kil numpaipm eng laron kil alkil, la kil ukipma kupm ti, a yangkipm a kupm angkli pa, pa Warim Kipman a Melnum ikga wa kil numpaipm eng laron melnum pa la kil akilen, ik wang a kil nar nimpokgen nang wailen a titnongket klalen alkilen, a nang wailen a titnongket klalen a Yan nimpokgen tu maur akwapel a tuwekg amprin eng tuwekg alntuwekg. ");
INSERT INTO urim_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kupm lanakepm aklale wrisen, kipm tiur a itna ti pa, ikgake imo. Kipm ikga ri a Maur Wailen itna wailen ikgalen kweikwei wrongkwail. Kipm rki ri pa plalng pa, kipm imo kaingkai.” ");
INSERT INTO urim_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Sisas laron yangkipm pa kai plalng pipa, wa kil wa rpma a, wang wampwomis wampwompwraur pa kai plalng pa, kil awi Pita, Semis a Son, tunteng kaino oklala naki Maur Wailen kaino wrik nangen ur. ");
INSERT INTO urim_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kil oklala naki Maur Wailen pa rpma pa, ikgokg numpwam a kil pa palng manet, a apm a kil ti pa tangkor pupu muinmainet kolti. ");
INSERT INTO urim_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ari tunteng ari melnum wekg pa palng kolti antiwel oklala, melnum wekg pa Moses a Elaisa. ");
INSERT INTO urim_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tuwekg palng nampokgen klalen anti Sisas pa oklala kweikwei a ikga palng eng Sisas pa, kitila nikgwalpm yiprokgen a Maur Wailen yapon pa la ikga kil imo kai Serusalem pa. ");
INSERT INTO urim_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita anti tuwekg pa teng okg rmpa. Ari teng wa pirpakg ikg kaino ari Sisas pa palng klalen paipm ai. Tunteng ikg kaino ariri melnum wekg ur anti Sisas pa itna. ");
INSERT INTO urim_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Melnum wekg pa wreren eng a kai ti pa, Pita lanaki Sisas pa la, “Wailen, kol a minto rki tike, minto rpma ari am wor ise. Kol a minto ngkam pilmpal wraur, ur eng kitn, ur eng Moses, a ur eng Elaisa.” Pita pa ake akwonalmpen oklala na ur a kil la pa, ti kil la kolti. ");
INSERT INTO urim_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita la yangkipmok pa itna, ari waipmunu pa elngkul nar ak ipaarngten. Pita, Son a Semis pa teng ngkark eng waipmunu pa elngkul nar ak ipaarngten pa. ");
INSERT INTO urim_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ok ur angklo la a waipmunu wunen pa kulor la kolpa la, “Kil warim yek akupmen a pikekg kupm takwei, ti kipm itning ok yangkipm a kil la pawo!” ");
INSERT INTO urim_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Oklala pa kai plalng pa, tunteng ari Sisas alkil wris ata kolti itna. Tunteng ake apo ok lanaki tu tiur ai kweikwei wuten a palngten pa, teng tatar rka pa pen. ");
INSERT INTO urim_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Okg or kong ti Sisas nampokgen tunteng watnom a kil aroaro wonel pa anel yaper angkaino nang pa nar, ari tu wrong wailet paipm pa anel rka. ");
INSERT INTO urim_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Melnum ur pa ari Sisas angkaino krongkwang pa nar, atom akwewel ak okwail ak arongke tu wrongkwail a rka pa la, “Wailen, kitn kul ri warim kipman akupmen ti! Kupm warim kipman wris nangket kolti. ");
INSERT INTO urim_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ari maur paipm kawor rpma warim kipman akupm ti, atom antokgtel kil kirkar tilntul, nepmal wampal, ipopm werk ti pilpil wli ok ti. Maur paipm pa ake kai takwleikgentel anti watipmen, kalpis, kil am alkel wleket kol pake. ");
INSERT INTO urim_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kupm la nampokgen ipma arein lanaki tu watnom akitnen pa la ungkwan maur paipm pa, ari tu ake antiwe.” ");
INSERT INTO urim_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ari Sisas aklewen la, “Antokg kolai kipm wrong kin kipman ak wang ti, kipm ake ukipma Maur Wailen, a kipm melnum a antokg paipm! Kupm rpma antiwepm rpma wang watin paipm ai. Kupm num lpmaakopm paipm eng kipm pake!” Atom kil la kai melnum pa la, “Iye warim kipman ti no!” ");
INSERT INTO urim_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Warim kipman pa kaino eng Sisas pa, ari maur paipm pa laik ngkrangkel elngkai kanokg ti warwar nepmal wampal rmpa. Pa Sisas akle a ungkwan maur paipm kimpilpet pa takwleikgentel, kil palng wor atom kil lanaki yan alkil pa la, “Atom kul uwiyel iye kai o!” ");
INSERT INTO urim_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tu wrong kin a kipman pa wrekg paipm eng tu ari titnongket wail a Maur Wailen. Tu wrong kin a kipman pa wrekg paipm eng kweikwei a kil antokg pa itna kolti, kil la kai eng tu watnom alkilen pa la, ");
INSERT INTO urim_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","”Ampur kipm woniketen yangkipm a kupm la lanikepm kil. Warim Kipman a Melnum pa mpa uk kai wam a tu melnum a kanokg a ti.” ");
INSERT INTO urim_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pake ake tu watnom alkilen pa ariwe yangkipm a kil la pa la kil la kolai. Yangkipm yiprokgen pa itna ampen, eng ake mpa tu riwe, kolpa atom tu wa ngkark la, mpa mla isen pa. ");
INSERT INTO urim_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tu watnom a Sisas pa alilakel tita la, mla ur a tu pa mpa itni wailen. ");
INSERT INTO urim_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ari Sisas ariwen kawor nol wunen a tu pa ari tu akwonalmpen kolpa, atom kil awi warim ur pa aye kul itna ");
INSERT INTO urim_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","akla la, “Mla ur a ukipma kupm atom uk wor angklin warim ur kol kil pa, pa wa kil uk wor kupm ti yat. Wa melnum a ukwor kupm ti pa, pa am wa kil uk wor melnum a ukwawopm nar ti. Eng ntei, melnum ur a kipm ti orngwatneikgen angklin mla ur pa, kil pa itna ep pake.” ");
INSERT INTO urim_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Son watnom ur a Sisas wa angklo ok pa la, “Wailen, men ari melnum manet ur naren kitn ti atom ak ungkwan maur paipm. Atom men nakel la kil elngen, eng ntei, kil melnum a ake anti mentepm ti.” ");
INSERT INTO urim_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ari Sisas akalmpe la, “Ampur wa kipm angkengkel, eng ntei, melnum a ake awi wrongmanto lan mentepm pa, pa kil melnum wor a mentepmen.” ");
INSERT INTO urim_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Wang wreren eng a Maur Wailen uwi Sisas iye kaino kitnong, ti nikgwalpm akilen pa rka wris la kil ikgam kinar kai kaino Serusalem pake. ");
INSERT INTO urim_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kil ukwa tu aye yangkipm pa ep kinar anong ur a tu Samaria, la tu numprampen kweikwei wan anong pa eng kil ikga kinar. ");
INSERT INTO urim_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pake tu melnum a anong pa ake awi wor eng Sisas pa, eng ntei, kil pa la kil a kinar kai kaino Serusalem. ");
INSERT INTO urim_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Semis ekg Son, watnom a Sisas, ari pa, atom tuwekg la, “Wailen, kitn awi wor la men la wakg kaino kitnong ai nar lap anong pa, kol a pikekg Elaisa la, atom wakg nar al tu tiur ai?” ");
INSERT INTO urim_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ari Sisas plelng aklewen kolpa la, “Kipm ti titno, kipm melnum a Maur Wailen pake kipm ake ariwe nikgwalpm a Maur Wailen pa ake rka kolpa.” Sisas kil aklewen kolpa plalng pa, ");
INSERT INTO urim_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","kil wa awiyen anel kinar anong manet ur ai. ");
INSERT INTO urim_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tu or ya pa kai pa melnum wris ur pa lanaki Sisas pa la la, “Kitn la ikga kai i kai i pa, kupm ikgam kutnunteitn itn kolpa itn pake.” ");
INSERT INTO urim_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ari Sisas wa akalmpentel la, “Nimpa tilpmingen ti pa kanokg tawong a tu a okge pa itna. Wa wel ti pa tingkil alntu a okge pa itna. Warim Kipman a Melnum ti pa wrik kalpisen a okg armpe.” ");
INSERT INTO urim_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wa melnum ur pa Sisas lanakel la, “Kul kutnuntopm!” Ari melnum pa la la, “Wailen, itni eng kupm kai rpmi eng yan alkupmen ti imo, kupm uwen plalng pipa, wa kupm wa kul kutnunteitn.” ");
INSERT INTO urim_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ari Sisas akalmpe la, “Kai tu melnum a amo pa uwen tita o! Kitn ti pa kai itn laron niki tu la Maur Wailen la itni wailen ikglen nol nikgwalpm akipm wrongkwail.” ");
INSERT INTO urim_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wa melnum ur pa la la, “Wailen, kupm mpa kutnunteitn pake, itni waiketn eng kupm kai ukwor tu alkupmen kil pen.” ");
INSERT INTO urim_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ari Sisas lanakel la, “Melnum a kil ak tuk eng u wayu pa, ake mpa kil ikg plelng, mpa kwap a kil ak pa kai paipm. Melnum a kolpa pa kil akentiwe elng Maur Wailen pa itna ep ikgalen nol nikgwalpm akilen pa.” ");
INSERT INTO urim_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Atom Sisas wa takwei tu melnum kamel wraur tuwek wampwam yikak wekg pa kai mapming a tu a katnuntel pa, atom la ukwawen wekg wekg rak kai yela anong wail wail a wusok wusok a lala kil ikga kai pa. ");
INSERT INTO urim_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kil ak yangkipm kla kil lanaken la, “Kweikwei wailet am tukgun kakir itna pake, pake melnum a angketuwai ti yek wraur kolti. Kolpa ti kipm isen melnum Yan a wring pa, eng mpa kil ukwa melnum akwapel watipmen kai ngketuwai kweikwei akilen pa! ");
INSERT INTO urim_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kipm kai o! Kil kupm ukwawepm kol manto walkg malkgu kai kuin a tu nimpa tilpmingen. ");
INSERT INTO urim_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ampur kipm aye apm kok, kweikwei a alupme marpm, a nepm palk alkipmen pa nukur num. Ake mpa kipm kai oklala itni yaya, kipm or yawel itn kolti. ");
INSERT INTO urim_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kipm la kai kawor wan anong ur pa, ep pa kipm yangkipmen tu a rka wan pa la, 'Maur Wailen mpa plan ipma wor alkil ngklinsepm!' ");
INSERT INTO urim_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kol melnum ur rki wan pa kil itopen uwi ipma meen wor pa, pa mpa Maur Wailen kil plan ipma wor alkil ngklinsel. La kalpis pa, Maur Wailen ake mpa plantel ipma wor alkil pa ngklinsel, kalpis, kil mpa ngklin kipm tike. ");
INSERT INTO urim_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kipm rki wan wris ur kolti a tu awi wor la kipm rki pa. Ampur kipm kai wan ur wan ur. Kipm rki pa il u okipma a tu alkepm pa. Pa tu ikgalentepm ariworwor eng kwap a kipm ak pake. ");
INSERT INTO urim_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kipm kai anong ur pa, tu itopen ikyakurepm iyewepm kai wan anong atuwen pa numprampentepm okipma pa, kipm uwi il kolti. ");
INSERT INTO urim_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wa kipm ungkwan numpet a tu melnum numpet a anong pa, a laron niken la, 'Maur Wailen pa nar itna wailen la ikglen nol nikgwalpm akipmen.' ");
INSERT INTO urim_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pake kipm kai kawor anong ur pa, ari tu ake atopen alkepm wor akyakurepm ayewepm kai wan anong alntuwen pa, pa kipm itn tutu ya wail wail itna anong pa laniken la, ");
INSERT INTO urim_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Yipur a itna anong akipmen wet karponte nepm a men ti pa, am wa men kalkwintepm elngtitna tike, kipm ikga yangkipm kalpisen eng ikilmpe yangkipm pa. Pake kipm wonirpme riwe yangkipm kil: Maur Wailen la itni wailen ikglen nol nikgwalpm akipmen.'” ");
INSERT INTO urim_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Sisas la karkurng tu kamel wraur tuwek wampwam yikak wekg a kil la ukwa kai ikwap pa plalng pipa, wa kil wa la, “Kupm lanakepm la ikga ik wang wail a Maur Wailen ntokg yangkipm numpokgen kipm wrong kin kipman pa, kalkuten a tu pa ikga wa angen a tu anong Sotom pa.” ");
INSERT INTO urim_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Sisas arein anong a tu ake ukipma pa la, “Woi, arein kipm anong Korasin a kipm anong Petsaita, kipm ikga uwi paipm! Kupm pikekg antokg kweikwei titnongket titnongket a melnum ake antiwe antokg pa itna kai anong wekg a kipmekg pa, ari ake wa kipm plelng ipma la arein. Kol pikekg kupm ntokg kweikwei titnongket titnongket kolti kai anong Tair a anong Saiton pa, tu kol pikekg tak ai ngko yipan akg rein paipmpaipm a tu antokg pa atom plelng ipma ise. ");
INSERT INTO urim_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ikga ik wang wail a Maur Wailen ntokg yangkipm pa, kalkuten a ikga palng kai kipm ti pa, ikga wa angen a anong Tair a Saiton pa ");
INSERT INTO urim_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ti kitn anong Kaperneam ti. Kitn akwonalmpen la kitn ti wor, ti ikga uwiyeitn iye kaino anong wor pake? Ikga kolpa kalpis. Kipm ikga ngkliwepm elng ngko wrik om miningket paipm kolti.” ");
INSERT INTO urim_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sisas arein tu anong pa plalng pipa, kil lanaki tu melnum a kil la ukwa kai eng ikwap pa la, “Melnum ur a atning yangkipm akipmen pa, pa kil atning yangkipm akupmen ti. A melnum ur a talpulng yangkipm akipmen pa, pa kil talpulng yangkipm akupmen tike. A wa kil a talpulng yangkipm akupmen ti pa, pa kil talpulng yangkipm a Yan a pikekg ukwawopm nar kanokg ti.” ");
INSERT INTO urim_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tu melnum kamel wraur tuwek wampwam yikak wekg a pikekg Sisas ukwawen la tu kai ikwap pa tu wa anel yaper wli nampokgen atopen wail manten. Tu lala, “Wailen, men naren kitn ti atom men ungkwan tu maur paipm pa tu atning katnun ok a men ungkwanten!” ");
INSERT INTO urim_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ari Sisas akalmpe la, “Aklale, kolpa atom kupm ariri maur paipm Satan angko angkaino kitnong ai nar kol milmal a plaing pa. ");
INSERT INTO urim_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kipm itning, kupm pikekg alkepm titnongket, ti ake kwei ur antokgtepm paipm, ti kipm atn rkganti ul a kirko, a wa kipm angen titnongket a wrongmanto akipmen. ");
INSERT INTO urim_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pake ampur kipm atopen lala tu maur paipm pa atning katnun ok akipmen pa. Kipm mpa itopen eng nang akipmen pa am nira ela kai wrkapm a Maur Wailen ise.” ");
INSERT INTO urim_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ak wang ketn pa Maur Wor pa ak kwap titnongket kawor ipma a Sisas pa, atom kil lala, “Yaiyai, kitn Wailen a kitnong a kanokg. Kupm alkeitn wor ngkat nang akitnen, eng ntei, kitn plan ariwe wor a kitn ti tu melnum ti a rpma titnowen kolen warim pa, a kitn lam eng tu melnum ariwe wail wail a nikgwalpm watin pa. Aklale, Yaiyai akupmen, pa kitn ak katnun nikgwalpm wasrongen a ariwe wor alkitnen pake.” ");
INSERT INTO urim_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sisas ngkat nang a Yan alkil pa kolpa plalng pa, wa kil wa lanaki tu a rka pa la, “Kweikwei wrongkwail am pikekg Yan akupmen elng kul wam akupmen ti ise. Ake melnum ur ariwe la Warim Kipman pa mla, Yan akupmen kolti pa kil ariwe pake. A melnum ur ake wa ariwe Yan pa yat, Warim Kipman ti nampokgen tu melnum a kil wasrongen la plan Yan pa, tu melnum pa ariwe pake.” ");
INSERT INTO urim_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ak wang a Sisas nampokgen tu watnom alkilen pa rka ak tu alntu pa, kil lanaken la, “Kipm ti pa wor pake, kipm itopen o, eng kipm ari kweikwei a kipm ari ti. ");
INSERT INTO urim_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kupm lanakepm la tu melnum okwripm a Maur Wailen nampokgen tu melnum tukgunakg pa pikekg anel antokg la mpa tu ri kuina ur a kipm ari ti, ari ake antiwe a tu ari. Tu la mpa itning kuina ur a kipm atning ti, ari ake antiwe a tu atning.” ");
INSERT INTO urim_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wang wris ur pa melnum ur a aroaro wonel tu yangkipm a Moses pa kai kaino la ilm ipmawel Sisas pa la, “Melnum a aroaro wonel tu, mpa kupm ntokg kolai eng mpa kupm uwi yaprekg watin eng rpmi wor yongkyong pa?” ");
INSERT INTO urim_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sisas akalmpentel la, “Ti wrkapm a Maur Wailen a kitn angkleikg pa, pa lanakeitn kolai?” ");
INSERT INTO urim_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Melnum pa akalmpe naki Sisas pa la, “Kitn mpa plan ipma wor wasrongen Wailen, Maur Wailen akitnen pa itna ep pake. Kitn mpa uk amen wor, a nol nikgwalpm, a titnongket, a ariwe akitnen ti plalng kai eng kil. Wa kai arkekg pa, kitn mpa plan ipma wor wasrongen tu mla ur ai pa kol a kitn plan ipma wor wasrongen kitn alkitn pa.” ");
INSERT INTO urim_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Sisas akalmpe la, “Pa kitn la pa aklale, ti kitn ik kitila kolpa pa, kitn ikgam uwi yaprekg watin eng rpmi wor yongkyong pake.” ");
INSERT INTO urim_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ari melnum a aroaro wonel tu yangkipm a Moses pa akor yangkipm ur ai la ik aure kil alkil ti, atom wa kil wa asen Sisas pa la, “Ti tu melnum mla a i mpa kupm plan ipma wor wasrongen pa?” ");
INSERT INTO urim_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ari Sisas akalmpe lala, “Kol melnum ur pikekg a Serusalem ti kinar kai Seriko pa. Ari tu melnum paipm ur arkulel angko ya pa, aner apm, a awi kweikwei wrongkwail a kil ti plalng, a orel paipm, wreren eng kil a imo. Atom tu atnuurngkel rmpa pa, a tu am ngkark kaingkai ise. ");
INSERT INTO urim_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Atom melnum ipma krakgen ur a ak ak kwap eng al wor uk Maur Wailen pa kil nar ya pa kinar. Angkli wulmpa yampingen ti ikg kai ari melnum a rmpa pa kolti, angkom nalokgen or kai ya yamping pa kai ise. ");
INSERT INTO urim_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Wa melnum Lipai ur pa am wa kolpake. Kil nar ya pa kinar, kil ari melnum pa, kil angkom takwleikgen or kai ya yamping ai kai ise. ");
INSERT INTO urim_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ari melnum Samaria ur pa am katila ya pa nar pa nar pake, kil ari melnum pa, ipma wunen a kil pa akg arein paipm eng melnum pa. ");
INSERT INTO urim_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kil kai kinar wreren kolti, kil alung uyiwa pa nampokgen u wain pa ak raro i kweikwei pa yapowel. Plalng pipa, kil ngkat elng kaino nimpa nepm kuinen nungkulkg watin alkil ti kolti, a ayewel kinar wan ur a tu a a ya watinet ai wli okg arke pa. Atom kil alkil ikgalentel. ");
INSERT INTO urim_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kil kai okg, kong ti, kil nakle marpm ur pa aye kai uk melnum a ikgalen wan pa, lanakel la, 'Ikglentel kolpa kaingkai, marpm ur a kitn wa uk klangkil marpm a kupm alkeitn kil pa, ik wang ur a kupm yaper kul pa, ikga kupm ikilmpenteitn pa.'” ");
INSERT INTO urim_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sisas la yangkipm pa plalng pa, wa kil wa asen melnum a aroaro wonel tu yangkipm a Moses pa lala, “Ti kitn akwonalmpen kolai melnum wraur kil, la mla a i kil melnum a alupmen melnum a tu melnum paipm orel rmpa ya pa?” ");
INSERT INTO urim_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Melnum a aroaro wonel tu yangkipm a Moses pa akalmpe la, “Melnum a kinar arein angklin melnum pa, pa am kil pake.” Sisas lanakel la, “Am kolpake. Kitn kai atom kitn ik kolpake!” ");
INSERT INTO urim_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sisas nampokgen tu watnom alkilen pa or ya pa kai kaino pa, tu kaino palng kaino anong ur. Kin wris ur a rpma anong pa, nang alkilen pa Marta, kil alkel wor eng la kil ntiwel rpmi wan anong akilen pake. ");
INSERT INTO urim_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maria pa wusoken a Marta. Sisas kil angkli yangkipm pa rpma pa, Maria pa kil rpma wreren nepm a Sisas pa atning yangkipm pa rpma. ");
INSERT INTO urim_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kil akuke Marta pa ampurkg ampenen antokg wakgkuntuk kweikwei pa rpma, atom ipma a kil pa paipm eng Maria pa, atom kil kai naki Sisas pa la, “Wailen, ake kitn ari la kupm alkupm wris numprampen okipma kweikwei ti! Ti antiwe mpa kitn laniki Maria pa eng kil or ngklinsopm pen?” ");
INSERT INTO urim_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ari Wailen akalmpentel la, “Marta, Marta, kitn nikgwalpm kalkut akwonalmpen kweikwei watipmen. ");
INSERT INTO urim_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pake kwei ur wor wris kil pa kitn a uwi tipen. Maria pa am awi ise, pa kweikwei wor wrisen, ikgake melnum ur ungkwan tukuleikgentel pa.” ");
INSERT INTO urim_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wang wris ur pa Sisas kai oklala naki Maur Wailen kai wrik ketn ur pa. Kil oklala naki Maur Wailen pa plalng pa, watnom wris ur alkilen pa lanakel la, “Wailen, kol a kitn kiling planto ya a oklala naki Maur Wailen pa pen, kol pikekg Son melnum a kaluk tu kil kaling plan tu watnom akilen pa.” ");
INSERT INTO urim_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Sisas lanaken la, “Kipm la oklala niki Maur Wailen pipa, kipm oklala nikel kolkil, 'Yaiyai, nang a kitn pa mpa itni klalen wakget. Kitn mpa itni wailen ikglen men wrong kin a kipman nimpon kweikwei wrongkwail. ");
INSERT INTO urim_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kitn lko okipma pa ntiwe ikngklei wang wris wris. ");
INSERT INTO urim_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kitn ungkwan paipmpaipm a men ti, eng ntei, men wa ungkwan paipmpaipm a tu wris wris a antokg kul men ti. Kitn ikglento eng ake mpa kweiur ik rkolngko kai ngko pa.'” ");
INSERT INTO urim_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Atom wa kil wa lanaken yangkipm kla kil eng mpa tu oklala niki Maur Wailen kolpa itni, ake mpa tu elngen, atom kil la kolkil la, “Ti wris ur a kipm ti kai wan a melnum ur a kipmekg atn or wris pa ik mining kuin pa, atom kil isentel la, 'Kitn antiwe mpa kitn lkopm nok ipm wris ur, atom ikga kupm ikilmpenteitn kul. ");
INSERT INTO urim_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Melnum wor ur alkupmen wuten a ya watinet ai wli wan akupmen ti, ti wan a kupm ti timpal okipma kalpisen a alkel al.' ");
INSERT INTO urim_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ari kol melnum pa lanikeitn angkawor wan pa or lala, 'Wanyun kweikwei am men ar ise. Kupm nampokgen tu kin watnom alkupmen ti men am okg tike. Ti kitn wet wa rpma kai a i? Ti akentiwe mpa kupm wrekg lkeitn kwei ur.'” ");
INSERT INTO urim_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Wa Sisas wa lala, “Kupm lanakepm la, yan a wan pa kol ake wrekg uk kweikwei pa kai melnum wor alkil pa, pa kol a kalpis. Kil wrekg alkel pati atnen a kil itna asen erkisen. Atom kil wrekg awi kweikwei pa wailet alkel katila kuina ur a kil asen pa. ");
INSERT INTO urim_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kolpa atom kupm lanakepm kolkil la, kipm isen pa, mpa kipm uwi; kipm ikor pa, mpa kipm nsil; a kipm kulkwon pa, wanyun pa mpa kukwantepm. ");
INSERT INTO urim_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Eng ntei, mla ur a kil asen pa, mpa kil uwi, a mla ur a kil akor pa, mpa kil nsil, a mla ur a kil kalkwon pa, wanyun mpa kukwantel pa. ");
INSERT INTO urim_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ti kipm yantin mla ur pa, kol warim alkipm pa isentepm eng yul pa, mpa wa kipm lkel ul pake? Kalpis. ");
INSERT INTO urim_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Aki kol kil isen karek lmpa pa, mpa kipm lkel kirko pake? ");
INSERT INTO urim_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ti kol kipm yantin a antokg paipm pa, wa kipm wa uk kweikwei wor wor tu warim alkipmen pa. Kolpa ti wa kipm riwe la Yan alkipm a rpma kaino kitnong pa, wa wor wrisen angen kipm yantin a kanokg ti. Kipm la isentel la kil lkepm Maur Wor alkil pa, kil mpa itopen eng lkepm pa.” ");
INSERT INTO urim_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sisas kil ungkwan maur paipm a antokg melnum ur okmise pa kai takwleikgentel, atom kil wa oklala. Tu wrongkwail ari pa, atom tu wrekg paipm. ");
INSERT INTO urim_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ari wa tu tiur pa la la, “Palpa kil akwap nampokgen Pelsepul, melnum tukgunakg a tu maur paipm pa alkel titnongket, atom kil ungkwan maur paipm pa.” ");
INSERT INTO urim_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","A tu tiur pa la alm ipmawel Sisas, atom tu lanakel la, kol a kil elng kla ur itni ik plan titnongket a Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pake Sisas pa kil ariwe kuina ur a tu akwonalmpen pa, atom kil lanaken la, “Kol kupm ik titnongket a maur paipm ikwap pa, pa kolen tu anong kanokg wail ur wako iro wrong atom ilm tita pa, ikga anong kanokg pa kai paipm. Wa kol melnum ur kil wrekg nti kinwatnom alkil or tita pa, rpma wor a tu rpma wris pa mpa kai paipm. ");
INSERT INTO urim_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ti kipm la Pelsepul, maur paipm a itna tukgunakg a ikgalen tu maur paipm pa, alkopm titnongket pa, atom kupm ungkwan tu maur paipm pa. Ti kol maur paipm Satan nti tu alntu pa or tita pa, mpa wa kil itni titnongket ikglen tu alntu pa kolai? ");
INSERT INTO urim_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pake kol Pelsepul pa lkopm titnongket atom kupm ungkwan tu maur paipm pa, ti tu alkipmen pa mpa wa uwi titnongket kai mla, atom ik ungkwan tu maur paipm pa? Am tu pa planto la yangkipm a kipm la pa ake aklale. ");
INSERT INTO urim_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pake kol Maur Wailen pa kil lkopm titnongket atom kupm ungkwan maur paipm pa, pa plan kolen la, Maur Wailen am nar itna wailen la ikgilen nol nikgwalpm a kipm tike. ");
INSERT INTO urim_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Melnum titnongket pa kil numprampen ikwri alkil pa, atom kil arpmen wan alkil pa, kweikwei alkil pa rmpa wor. ");
INSERT INTO urim_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pake kol melnum ur ai a antiwe titnongket wail angen titnongket a kil pa, kil wa wli orel lok ngkliwel, atom uwi ikwri a pikekg ak titnongketel kil pa iye kai tukuleikgentel kolpa pipa, kil kawor uwi kweikwei wrongkwail a itna kawor wan a kil pa, uwiye kai mpreing uk tu tiur ai.” ");
INSERT INTO urim_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Sisas la yangkipm kla kolpa plalng pipa, kil la, “Melnum a ake akupmen pa, kil awi wrongmanto lan eng kupm. A melnum a ake angklinsopm eng awi tu wrong kin kipman pa aye wli itna wris pa, kil pa melnum a ungkwan tu kai.” ");
INSERT INTO urim_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Sisas wa kil wa la, “Kol maur paipm kimpilpet kil kul or tukuleikg melnum pa kai en pa, kil kai atn yela tatu wrik ur a ake melnum ur arpme, ikor wrik lala rpmi eng uwi yapm. Kol ake kil ansil ur pa, mpa kil la kolpa la, 'Pati mpa wa kupm yaper kai rpmi wan alkupm a pikekg kupm arpme ep pa.' ");
INSERT INTO urim_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Atom kil kai ari wan pa kansim ipikel noworel nakure ariworwor elng itna. ");
INSERT INTO urim_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Atom, mpa wa kil yaper kai, wa ikyakur maur paipm wampwomis wampwompwekg a paipm wrisen angen kil ti, wa aye wli antiwel rpma ipma a melnum a kil arpme ti. Pikekg ep pa melnum pa kil rpma paipm kolpake, wa kanukg ti a tu maur paipm pa wa kawor rpma pa kil pa wa rpma paipm wrisen or kai ai.” ");
INSERT INTO urim_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Sisas kil la pa itna pa, kin ur a itna kuin a tu wrongkwail pa la ak ok wail kolkil la, “Kin a pikekg rakuweitn atom ikgalenteitn alkeitn ma al pa, kil pa wor pake, kil itopen o!” ");
INSERT INTO urim_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ari wa Sisas akalmpe la, “Pa wor, pake wor a kol a mentepm la kolkil la, melnum a kil atning yangkipm a Maur Wailen pa atom kil katnun pa, kil pa wor pake, kil itopen o!” ");
INSERT INTO urim_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tu wrongkwail pa kapringen Sisas kolpa itna pa, wa tiur wa anel wli wli kolpa, pa kil la kolpa la, “Kipm wrong kin kipman ak wang ti pa, kipm wrong kin kipman paipm. Kipm akor la ri kla ur a ik plan titnongket a Maur Wailen eng kipm ri, pake mpa kalpis. Ikga kipm ri kuina ur a pikekg palng ep eng Sona pa kolti. Pa kol kla a Maur Wailen ikga elng itni ik plantepm titnongket akilen pake. ");
INSERT INTO urim_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ti am wa kolpake, kol Sona pa kla a pikekg Maur Wailen kil elngitna ak plan titnongket akilen tu wrong kin kipman a anong wail Ninipe pikekg ari pa. Ti Warim Kipman a Melnum pa am wa kla a Maur Wailen ikga elng itni ik plan titnongket akilen kipm wrong kin kipman a rpma ak wang ti pa ikga ri. ");
INSERT INTO urim_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ti ikga ik wang wail a mentepm wrong kin kipman itni yangkipm wail pa, kin a pikekg itna tukgunakg ikgalen anong kanokg a yamping kinar pa, ikga kil wrekg itni elng wam itni kipm wrong kin kipman a ak wang ti la kipm antokg paipm. Kin pa kil pikekg rpma kinar kanokg yiprokgen watin ai ari kil pikekg aken kwap kulno atning nikgwalpm ariwe watin a Solomon pa. Pake melnum kil ti pa angen Solomon, ari ake wa kipm atning nikgwalpm ariwe watin a kil ti. ");
INSERT INTO urim_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ti wa ikga ik wang wail a itni yangkipm pa, tu wrong kin kipman a Ninipe pa ikga wa tu wrekg itni elng wam itni kipm wrong kin kipman a ak wang ti la kipm antokg paipm. Eng ntei, pikekg tu atning yangkipm a Sona angkli pa, atom yangkipm pa almpen ipma atom tu pikekg plelng ipma ise. Pake melnum a itna ti pa wail angen Sona pa, pake ake wa kipm plelng ipma.” ");
INSERT INTO urim_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","”Ti melnum ur akentiwe mpa kil la wakg pa, atom kil lam aki a kil ik kuntuk mipmapm pa ik ipaarng pa, kalpis. Mpa kil la atom elng rki kaino kwa ti, eng tu wrong la wli pa, mpa tu ri wakg pa. ");
INSERT INTO urim_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ti wulmpa akitnen pa kol wakg a ak alen numpwam pa. Wulmpa akitn pa wor pa, numpwam wrongkwail akitnen pa mpa klalen wor. Pake kol wulmpa akitn pa paipm pa, numpwam wrongkwail akitnen ti mpa miningket plalng. ");
INSERT INTO urim_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ti kitn rpmi riwe, eng klalen a rpma kawor kitn pa ake mpa kai miningket. ");
INSERT INTO urim_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ti kol numpwam wrongkwail akitnen ti wakg len yela pa, num wompel ur akitnen ti pa ampake itni miningket pa, mpa klalen plalng, kolen klalen a wakg yilpo a alenteitn pa.” ");
INSERT INTO urim_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Sisas kil oklala plalng pa, melnum ur a tu melnum a arpmen yangkipm yiprokgen a Moses pa lanakel la tuwekg kai il okipma kai wan akilen. Atom kil antiwel kai kawor kolti, kil ngkaten okipma pa aye kul, tuwekg al. ");
INSERT INTO urim_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Melnum a arpmen yangkipm yiprokgen a Moses pa, kil wrekg paipm eng ari Sisas ake klak wam pa ep atom ak al okipma pa. ");
INSERT INTO urim_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Atom Wailen kil lanakel la, “Ti kipm melnum a arpmen yangkipm yiprokgen a Moses pa, kipm klak kuntuk kaimung pa or en tike, a kawor wunen akipmen pa pik atnen ikgwam a paipmpaipm tiur a kipm antokg. ");
INSERT INTO urim_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ti kipm titnowen! Ti Maur Wailen kil pikekg antokg en ti kolti, a ake pikekg kil antokg kawor wunen ai? ");
INSERT INTO urim_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kol a kipm uk kweikwei a rpma kuntuk kaimung ti kai ngklin tu a rpma tukwok pati, kweikwei wrongkwail pa mpa palng rukis wor eng kipm pa. ");
INSERT INTO urim_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Woi, arein kipm melnum a arpmen yangkipm yiprokgen a Moses ti, kipm ikga uwi paipm! Kipm uk tiwel wampwam akipmen kolen kweikwei wrongkwail a itna wring kai nampokgen wanukg wakg kweikwei waiketnketn pa plalngten kai Maur Wailen pake, ake wa kipm antokg tu mla ur ai ute wor, wa ake wa kipm katnun nikgwalpm a plan ipma wor wasrongen Maur Wailen ti. Kipm uk tiwel wampwam pa wor pake, wor kol a wa kipm kutnun nikgwalpm wor wor tiur ai. ");
INSERT INTO urim_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Woi, arein kipm melnum a arpmen yangkipm yiprokgen a Moses ti! Kipm wasrongen la rpmi wrik wor wor kawor wan a atning atning yangkipm a Maur Wailen atnewe pa, wa kipm wasrongen la tu lkepm wor itni tutu akapm itni wulmpa a tu wrongkwail, ti kipm ikga uwi paipm. ");
INSERT INTO urim_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Woi, arein kipm ti! Kipm pa kolen kirkap mampis paipm a ake tu ima kiminim a wak atne pa, atom ake tu ariwe, atom tu wonmis angkom elewepm kai. Ti kipm ikga uwi paipm.” ");
INSERT INTO urim_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Atom melnum wris ur a aroaro wonel tu yangkipm a Moses pa la, “Melnum a kaling plan tu, kitn wa la tu melnum a arpmen yangkipm yiprokgen a Moses kolpa ti, wa kitn wa uk ipma kaikuten men ti yat.” ");
INSERT INTO urim_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ari wa Sisas lanakel la, “Woi, arein kipm melnum a aroaro wonel tu yangkipm a Moses ti yat! Kipm uk kalkut wail tu wrong kin kipman pa ti akentiwe mpa tu rki. Pake ake kipm alkipm ti apo wam ti angklinsen ngkat kalkut pa. Kalpis, kipm rka ari wulmpa kolti. Ti kipm ikga uwi paipm. ");
INSERT INTO urim_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Woi, areinsepm, kipm wa awiyen ikgalen kirkap a tu melnum okwripm a pikekg tu mamikg mamin akipmen or amo ep ep pa. ");
INSERT INTO urim_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pa kipm plan kolen la kipm ti awi wor eng kwap a pikekg tu mamikg mamin akipmen ak pa. Eng ntei, tu mamikg mamin pa pikekg alm tu melnum okwripm a Maur Wailen pake, a kipm ti pa awiyen ikgalen kirkap a tu pa. Ti kipm ikga uwi paipm. ");
INSERT INTO urim_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Am kolpa atom, nikgwalpm ariwe wor a Maur Wailen pa la kolkil la, 'Ikg a kupm ukwa tu melnum okwripm, a tu melnum a kupm takweiyen atom ukwawen pa kainten, atom ikga tu ntokg paipm tiur, a oren tiur imo.' ");
INSERT INTO urim_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tu or tu melnum okwripm amo ak ai angkai a antokg kitnong a kanokg ai, kulngkul angko wang ti pa, kalkuten a amo a tu pa, pa am kipm wrong kin kipman a rka ak wang ti arki tike. ");
INSERT INTO urim_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kol pikekg tu or Apel pa, wa tu tiur a pa kulngkul angko Sekaraia ti. Sekaraia pa tu orel itna kawor yipmingki wunen a yalming a Maur Wailen, itna kuin a tipmakg a tu alwor uk Maur Wailen atnewe pa, a yalming pa. Kupm lanakepm aklale, la kalkuten pa am kipm ti arki tike. ");
INSERT INTO urim_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Arein kipm melnum a aroaro wonel tu yangkipm a Moses ti! Wa kipm ak tilel wanyun a awi nikgwalpm ariwe wor wor ti. Kipm alkipm ti ake kipm ore wanyun pa, kolpa ti wa kipm ak tilel wanyun a tu tiur ai la kol a ore pa. Kolpa ti kipm ikga uwi paipm.” ");
INSERT INTO urim_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sisas la yangkipm pa plalng pa kil la utnuurng kai pa, tu melnum a aroaro wonel tu yangkipm a Moses pa, wa tu melnum a arpmen yangkipm yiprokgen a Moses pa ipma wakget, la tirpmingen watipmen aknukwarel, ");
INSERT INTO urim_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","nungkwangen la kol a kil la yangkipm ur kai ar pa, pa mpa tu uwiyel iye kai itni yangkipm. ");
INSERT INTO urim_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tu wrongkwailet paipm ai anel wli rka amprilawe tita paipm ai, mpa tu ngkom kolai. Tu angkom ari rkganti tita kolti, atom Sisas kil la ep naki tu watnom alkil pa la, “Kipm uk ikg riwe nikgwalpm a tu melnum a arpmen yangkipm yiprokgen a Moses pa: tu kansil plan ak num enen ti kolti, pa kol mpim ap mringen a ak arongke kai or arpme nok ti plalng, atom angki wail. ");
INSERT INTO urim_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ti kol kuina ur a itna ampen pa, ikga palng kai ngko wunong, a kuina ur a aur pa, ikga uwiye kai ngko wunong. ");
INSERT INTO urim_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pa am wa kolpake, kuina ur a kipm la ak mining pa, ikga tu itning ik ran, wa kuina ur a kipm la akoo ampen naki tita kai nungkulkg rpma kawor wan wunen pa, ikga tu kul or la ik ok wail kai en ai.” ");
INSERT INTO urim_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ti kipm melnum wor wor alkupm, kupm lanakepm la ampur kipm ngkarken melnum a almpepm amo pa. Pa tu almpepm numpalk ti kolti tuwa, tu ake antiwe antokg kuina ur kolai. ");
INSERT INTO urim_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pake mpa kupm iyewepm ngkirken melnum ur kil. Kil pa antiwe titnongket a antokg kamel amo plalng pa, angkli kamel elngkai anong paipm. Ti kipm ngkirken melnum pa! ");
INSERT INTO urim_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ti kipm ariwe pa, wel waseksek wampwomis pa mentepm am ak marpm watet wompel wekg kolti pa ak armpen armpen pake. Pake, Maur Wailen pa ake wonmisen kweikwei waseksek kol wel ti, kil ikgalen pa. ");
INSERT INTO urim_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ti am wa kolpake, tukgunakg walk wris wris akipmen ti pa, am kil am wa angkleikg kimeket ise, ti ampur kipm ngkark, eng ntei, kipm ti pa wa wail manten itna ep angen wel waseksek watipmen pa.” ");
INSERT INTO urim_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Pake kupm lanakepm la, mla ur a kil laron nang a kupm ti itna tu wrongkwail pa la kil alkil la kil akupmen ti pa, ikga wa Warim Kipman a Melnum pa kil laron nang a kil pa itni wulmpa a tu maur akwapel a Maur Wailen pa la kil akilen. ");
INSERT INTO urim_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pake mla ur a lam nang akupmen ti itna wulmpa a tu wrongkwail pa, ikga Warim Kipman a Melnum wa lam nang akilen pa itni wulmpa a tu maur akwapel a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ti mla ur a kil la paipmel Warim Kipman a Melnum pa, ikga Maur Wailen ungkwan paipmpaipm akilen pake. A melnum a kil la paipmel Maur Wor a Maur Wailen pa, paipmpaipm akilen pa ikgake kil ungkwan. ");
INSERT INTO urim_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ti kol tu uwiyepm iye kawor wan a atning atning yangkipm a Maur Wailen atnewe pa eng ntokg yangkipm, aki iye kai itni tu mringman a tu melnum wailen pa, ampur kipm ngkark, la mpa kipm ikilmpe aki kipm la kolai pa. ");
INSERT INTO urim_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Maur Wor a Maur Wailen pa mpa lanikepm ik wang ketn pa kuina ur la mpa kipm la pa.” ");
INSERT INTO urim_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Atom melnum wris ur itna kuin a tu wrong kin kipman pa lanaki Sisas pa la, “Melnum a kaling plan tu, kupm wasrongen la kitn laniki wailen alkupm ti eng mentekg wako kweikwei a yan elngnto itna ti.” ");
INSERT INTO urim_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ari Sisas lanakel la, “Kipmekg! Mla la mpa kupm rpmi itning yangkipm a kipmekg ti mpreingtepm kweikwei ti?” ");
INSERT INTO urim_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Atom wa kil lanaki tu wrong kin kipman pa la, “Kipm wonirpme ikglen kipm alkipm ti riworwor, eng ake mpa kipm ringkowe la uwi kweikwei watipmen pa, eng ntei, kweikwei watipmen a kolpa ake antiwe angklin melnum eng rpma wor wa awi rpma wor a rpma yongkyong pa.” ");
INSERT INTO urim_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Atom Sisas lanaken yangkipm kla ur pa la, “Melnum ur a antiwe kweikwei wailet pa, kil antokg wringkya kweikwei pa, kweikwei a kil antokg pa nurkgatne wailet wor. ");
INSERT INTO urim_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ari wa kil akwonalmpen la, 'Kweikwei a kupm antokg ti wailet paipm kolpa ti mpa kupm iye kai elngkitni wan a i?' ");
INSERT INTO urim_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Atom wa kil akwonalmpen la, 'Wan waseksek a kupm elng kweikwei ti armpe ari ros lawe, ti mpa kupm le wan wail wail tiur ai eng elng okipma a kweikwei wor wor alkupmen ti elng itnewe. ");
INSERT INTO urim_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Atom mpa kupm la kupm alkupm pa la, wor wrisen. Kweikwei wor wor a kupm aye pa, ikga itni wring watipmen. Ti kupm mpa ntokg okipma pa il rpmi itopen ikngklei wang.' ");
INSERT INTO urim_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ari Maur Wailen lanakel la, 'Kitn titnowen! Kitn mpa imo ik mining ti, atom ti kweikwei a kitn numprampen rmpa ti ikga mla uwi?'” ");
INSERT INTO urim_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yangkipm kla a Sisas la pa kai kolpa. Atom wa kil la kolkil la, “Melnum ur a kil takwem kweikwei wor wor elngkitna eng la ik ngklin kil alkil pa eng rpmi wor, pake itna wulmpa a Maur Wailen pa kil rpma tukwok paipm wrisen.” ");
INSERT INTO urim_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Atom Sisas kil lanaki tu watnom alkil pa la, “Ampur kipm akwonalmpen watipmen kweikwei a numpalk ti la mpa kipm il okipma a i aki la mpa kipm nowe apm a i. ");
INSERT INTO urim_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Eng ntei, amen wor a melnum ti pa wail itna ep angen okipma ti, wa numpalk ti pa, wa wail itna ep angen apm pa. ");
INSERT INTO urim_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ti kipm ikwonilmpen wel pa, tu ake alin okipma pa, aki angket tuwai okipma pa aye wli itna wan, pake Maur Wailen ti ikgalenten eng okipma. Atom ti kipm pa wa kweiur wail manten itna ep angen wel pa. ");
INSERT INTO urim_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kipm ipma kalkut kolpa mpa pa ik rukge wang akipmen a rpma kanokg ti wa iye kai ketn? ");
INSERT INTO urim_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kol la kipm akentiwe a antokg kweikwei waiketnketn akolpa pa, antokg kolai atom wa kipm akwonalmpen watipmen eng kweikwei tiur ai? ");
INSERT INTO urim_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ti wa kipm ri kweikwei rwin pa, tu ake akwap aki antokg apm alntu eng nowe pa. Pake kupm lanakepm la, pikekg Solomon, melnum tukgunakg a antiwe kweikwei wor wor watipmen pa ak apm ari wor wor ak nowe num pake ake apm ur a ari wor kolen kweikwei rwin pa. ");
INSERT INTO urim_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ti ri Maur Wailen kil antokg kweikwei rwin pa palng ariwor. Pake kweikwei rwin weti arimo pa, ikg pa tu wangket ngkli kai wakg. Kipm melnum ti pa wail manten, ti kil ikga ngklinsepm apm kweikwei pa. Ti ake wa kipm ukipma titnongket. ");
INSERT INTO urim_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Atom ampur kipm ipma kalkuten a akwonalmpen watipmen la mpa kipm il u a okipma a i pa. Ake mpa kipm ikwonilmpen watipmen kweikwei a kolpa. ");
INSERT INTO urim_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Eng ntei, tu wrong kin kipman a kanokg ti pa, am nikgwalpm arken la uwi kweikwei a kol pake. Pake Yan alkipmen pa ariwe kuina ur a kipm tukwok pa. ");
INSERT INTO urim_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kolpa ti kipm nikgwalpm rkekgen eng elng Maur Wailen pa itni wailen ikgilen nol nikgwalpm akipmen pa ep, mpa wa kil lkepm kweikwei wrongkwail pa yat.” ");
INSERT INTO urim_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ti kipm manto walkg malkgu yekyek alkupm pa, ampur kipm ngkark, eng ntei, Yan alkipm pa atopen la ikga lkepm nang wailen eng kipm ntiwel ikglen kweikwei wrongkwail. ");
INSERT INTO urim_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ti kipm uk kweikwei alkipmen a kipm antiwe ti ik uwi marpm pa atom uk kai tu melnum a rpma tukwok pa. Kol kipm ntokg kolpa pa, pa kolen kipm numprampen apmkok weten ur ai kaino anong wor ai, eng mpa tukwem lupme kweikwei wor wor, a kweikwei a ikgake plalng aki tinginin atok ngket, aki melnum ikgwampet ik ikgwampel pa. ");
INSERT INTO urim_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kipm takwem kweikwei wor wor akipmen pa itna a i pa, nol nikgwalpm wail akipmen pa am rken pake.” ");
INSERT INTO urim_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","”Ti kipm kipor apm pa ining tukwok atom ik ampei pa ik ngket, a la wakg pa, atom kipm numprampen rpmi nungkwangen. ");
INSERT INTO urim_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kolen tu melnum akwapel a rpma numprampen nungkwangen yan a kwap alntu kai eng okipma wail ur a antokg al atnen kin a kipman ur a awi tita, atom yaper wli pa. Kil wli itna wanyun pa akwe pa, tu am atning atatu wli kukwa wanyun ise. ");
INSERT INTO urim_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Atom kol yan a kwap pa kil ri tu melnum akwapel alkil pa tu numprampen, atom rpmi nungkwangentel pa, tu pa wor pake, tu itopen o! Kupm lanakepm la, yan a kwap alntu pa mpa kil kipor apm pa ining tukwok ik ampei pa ngket plalng pa, kil laniken la tu rpmi kai wrik ai, atom kil ngkiten okipma pa iye kai lken il. ");
INSERT INTO urim_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ti wa kol kil wli ik mining kuin ti aki, kil wli ik ikwe ti ur pa, kil ri tu numprampen rpmi pa, mpa kil uwi wor lawen la tu pa ak wor pake, tu itopen o! ");
INSERT INTO urim_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ti wa kipm riwe kil: kol melnum yan a wan pa kil riwe la melnum ikgwampet mpa kul ik wang kolai pa, kil mpam arpmen wan alkil pa rpma a eng ampake melnum pa tikale wan alkil pa. ");
INSERT INTO urim_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Atom wa kipm ti yat, kipm mpa rpmi numprampen, eng ntei Warim Kipman a Melnum ikga nar ik wang ur a kipm ake ariwe la kil ikga nar pa.” ");
INSERT INTO urim_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Atom Pita kil asen Sisas pa la, “Wailen, yangkipm kla pa kitn la kul eng men ti kolti aki, kitn la eng tu wrongkwail ai nampokgen?” ");
INSERT INTO urim_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ari Wailen kil akalmpe la, “Ti mla melnum akwapel a i nungkulkg wor nikgwalpm arke? Pati ikgam yan a kwap alkil pa elng kil pa itni wailen eng ikglen tu alntu akwapel pa eng mpreingten okipma pa ik wang alkil a tu awi awi okipma pake. Atom kil kai ise. ");
INSERT INTO urim_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Atom kol melnum wailen pa kil yaper kul ri kwap a pikekg kil alkel pa, ari kil akwap wor kolpa itna pa, kil pa wor pake, kil itopen o! ");
INSERT INTO urim_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ti kupm lanakepm aklale wrisen, yan a kwap pa ikga elng melnum akwapel alkil pa itni melnum wailen ikgilen kweikwei wrongkwail alkilen pa. ");
INSERT INTO urim_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pake, kol melnum akwapel pa kil ikwonilmpen la, 'Melnum wailen alkupmen pa kil ikgake wli itatu', kolpa atom ari kil rpma antokg okipma al, a al u titno, atom kil titno titno or tu wrong kin kipman a tu akwap wris kol kil pa kolpa wonmis rpma. ");
INSERT INTO urim_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ari kalpis, melnum wailen pa wli palng tike. Kil wli palng ak wang a kil ake ariwe a kil ake akwonalmpen la mpa kil wli pa, atom kil orel paipm wrisen a ungkwantel kai rpmi nampokgen tu melnum a ake ukipma pa. ");
INSERT INTO urim_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","A melnum akwapel a kil ariwe kuina ur a yan a kwap alkil lanakel pake, ake kil numprampen rpma katila nikgwalpm a kil la pa, pa kil pa ikga kil orel ri paipm. ");
INSERT INTO urim_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pake, melnum akwapel a ake kil ariwe kuina ur a yan a kwap alkil pa la pa, atom ake kil ak katila nikgwalpm a kol a kil la pa, kil pa ikga kil orel waiketn kolti. Melnum a pikekg kil awi wail pa, mpa Maur Wailen ikwen wail, angen melnum a pikekg kil awi waiketn pa. Melnum a pikekg kil awi kuloken wail pa, ikga wa tu ukwentel eng kil ikilmpe wail, wa angen pa.” ");
INSERT INTO urim_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Kupm am nar la lile wakg itni kanokg tike, ti kupm wasrongen la mpa kirpowe nuruk il itatu. ");
INSERT INTO urim_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kupm ikga rki kalkuten wail manten kutnukg, ti kupm ipma kalkuten paipm kolpa kai ngko wang a kalkuten pa kai plalng. ");
INSERT INTO urim_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ti kipm ti la kupm ti nar kanokg ti la ntokg kipm ti rpmi meen wor? Kolpa kalpis, pa kupm nar la wako irowepm. ");
INSERT INTO urim_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Atom ak wang ti or pa kai pa, melnum wampwomis a rka wan wris pa ikga iro, atom melnum wraur pa ikga itni paipm eng melnum wekg pa, wa melnum wekg pa am wa kolpake, tuwekg ikga itni paipm eng melnum wraur pa. ");
INSERT INTO urim_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tu yantin ikga itni paipm eng tu warim kipman alntu, wa tu warim kipman ikga itni paipm eng tu yantin alntu. Wa tu mantin ikga itni paipm eng tu warim kin alntu, wa tu warim kin ikga itni paipm eng tu mantin alntu. Wa tu yalmpikg mayen ikga itni paipm eng tu yalmpikg anei alntu, wa tu yalmpikg anei ikga itni paipm eng tu yalmpikg mayen alntu.” ");
INSERT INTO urim_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Wa Sisas kil lanaki tu wrong kin kipman pa la, “Kipm ri waipmunu wrekg ingkinar takgni kinar pa kulno pa, kipm am ariwe ise, la u mpa wei. Pa u mpa uwei pake. ");
INSERT INTO urim_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wa kipm ri wripm a el a kanokg yamping kinar ti no pa, kipm am ariwe ise, la mpa takgni wor pake. Pa takgni mpa wor pake. ");
INSERT INTO urim_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ti kipm melnum a kansil plan ak num enen ti kolti. Kweikwei a ela kaino kitnong ai, a itna kanokg ti akayewen kweikwei a palng, pa kipm ariwe wor pake, ari ake wa kipm ariwe kuina ur a palng eng akayewen wang ti?” ");
INSERT INTO urim_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Karken a kipm alkipm ti ri la pa ute wor pake, atom kipm kutnun? ");
INSERT INTO urim_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kol melnum ur la uwiyeitn iye kai itni yangkipm pa, kipmekg ngkom or ya pa kai pa, kitn mpa mpen eng kipmekg or yangkipm pa kai imo. Kalpis pa, mpa kil uwiyeitn iye kai itni yangkipm itni wulmpa a mring man, wa mringman pa iyeweitn iye kai wam a tu mring nepimpalo, atom tu nepimpalo pa wa uwiyeitn iye kai rpmi wan tipmining. ");
INSERT INTO urim_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kupm lanakeitn la, kitn akentiwe mpa or en pa, kitn mpa rpmi i i, kitn ikilmpen marpm kaingkai kai plalng pipa, tu ungkwanteitn kul or en.” ");
INSERT INTO urim_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Atom ak wang pa, tu tiur wli lakati naki Sisas tu melnum tiur a Kalili a pikekg Pailat la atom tu almpen amo, atom walmpopm a tu pa ungkwan akoren walmpopm a wlikgok kweikwei a tu itna lap alwor uk Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ari Sisas akalmpenten la, “Eng ntei, tu melnum a Kalili a amo kolpa atom, kipm pa akwonalmpen la tu pa tu melnum paipm wrisen a angen tu Kalili a antokg paipmpaipm ai? ");
INSERT INTO urim_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kalpis. Ti kupm lanakepm la, kol ake kipm plelng ipma alkipm pa utnuurng paipmpaipm pa, kipm ikgam imo kolen tu pake. ");
INSERT INTO urim_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ti wa tu melnum wampwam yikakwomis yikakwom wraur a pikekg wan watin tapor or angkai anong Siloam pa, pa kipm pa akwonalmpen la tu pa melnum paipm wrisen a antokg paipm angen tu melnum a rka Serusalem pake? ");
INSERT INTO urim_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kalpis. Kupm lanakepm, kol ake kipm plelng ipma utnuurng paipmpaipm alkipm pa, kipm ikgam uwi paipm kolen tu pake.” ");
INSERT INTO urim_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Atom Sisas la yangkipm kla ur pa lanaki tu wrong kin kipman pa kolpa la, “Melnum ur pa yo kampuk ur alkil pikekg alin itna wring ampei wain pa, atom kil kai ari ake angko, kalpis. ");
INSERT INTO urim_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Atom kil lanaki melnum a ikgalen yo kampuk akilen pa la, 'Ti kipm ri, wring wraur misen kupm kul ari yo kampuk pa ari ake wa angko. Ti kitn ware yo pawo! Eng itna ti arkolng kanokg wor pa kalpmlel.' ");
INSERT INTO urim_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ari melnum pa la, 'Melnum, elngtilo itni ukwiyen kol wring wris pa pen, eng kupm kurkurng up ngklin pen. ");
INSERT INTO urim_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wring kutnukg pa, ri la kil ngko pa, pa elng itni. Kol ake kil ngko pa, kitn ware kul.'” ");
INSERT INTO urim_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ak wang wail ur a rpma eng yapm pa, Sisas kil angkli yangkipm itna kawor wan ur a atning atning yangkipm a Maur Wailen atnewe pa. ");
INSERT INTO urim_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kin wris ur a numpet pa wa rpma kawor wan pa ak wang pa yat. Kin pa maur paipm ur rpmawel, atom antokg yirokg akilen pa tompoket, atom akentiwe mpa kil ngkom itn ute, kolpa itna a wring wampwam yikakwomis yikakwompwraur ise. ");
INSERT INTO urim_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Atom Sisas kil ariwel pa, kil lanakel la, “Kitn pa, kul o! Numpet akitnen pa am kupm ungkwan ise.” ");
INSERT INTO urim_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Atom kil elng wam pa elewel kolti, kil wrekg itna ute wor kolti, kil ukwor Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Atom melnum tukgunakg a ikgalen wan a atning atning yangkipm a Maur Wailen atnewe pa ipma wakget eng Sisas antokg numpet a kin pa wor ak wang wail pa, atom kil lanaki tu wrong kin kipman pa la, “Kola kipm wli ik wang wampwomis wampwompwris pa, wang a akwap pa eng ntokgtepm numpet pa wor ik wang pake, wa ampur kipm wli ak wang wail a rpma eng yapm pa.” ");
INSERT INTO urim_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ari Wailen kil akalmpe kolkil la, “Kipm melnum a kansil plan ak num enen ti kolti. Ak wang wail a kol a rpmi eng yapm pa, kipm yat, kipm anelkgen manto nepm watin aki nimpa nungkulkg watin alkipm pa aye kai eng uk uk u al ti. ");
INSERT INTO urim_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ti kin ti, yaru marpmeng a Apraam pikekg Maur Paipm Satan yapowel rpma kolen wring wampwam yikakwomis yikakwompwraur, kolpa atom kupm wuten anelkgen ampei a ak yapowel ti ak wang wail a mentepm rpma eng yapm ti. Ti kipm ti lala kupm ti akwap paipm kolai?” ");
INSERT INTO urim_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kil akalmpe kolpa atom antokg tu a arpmen paipmel kil pa numpaipm. Pake tu wrongkwail pa atopen paipm eng kweikwei weten wor wor a kil antokg pa. ");
INSERT INTO urim_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sisas lanaki tu wrong kin kipman pa la, “Mpa kupm ik kuina a i ik la a kai irir kolen Maur Wailen itna wailen ikgalen nol nikgwalpm a kipm wrong kin kipman pa? ");
INSERT INTO urim_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Pa am kolen trumpwilm ipopm ok a wripm almpen aye kai anip yela tatu palpa. Atom anip kaino kol yo pa, alm talpuk atnewe kai pa kai pa. Atom wel pa wli ak ila rka tatu talpuk pa.” ");
INSERT INTO urim_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Atom wa Sisas asenten la, “Mpa wa kupm ik kuina a i ik la a kai irir kolen Maur Wailen itna wailen ikgalen nol nikgwalpm a kipm wrong kin kipman pa? ");
INSERT INTO urim_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Am kol mpim ap mringen pake. Kin pa awi waiketn kolti alung ak oren nok mringen kinar kuntuk mangkei wail pa, kolti nok pa angki kai wail.” ");
INSERT INTO urim_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sisas kil angkom kai anong lkgungkur lkgungkur kaling plan yangkipm a Maur Wailen, kolpa kai, la kaino Serusalem. ");
INSERT INTO urim_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ari melnum ur pa asentel la, “Wailen, ti ikga Maur Wailen ik uwi melnum yek wraur ur kolti iye kai eng alkilen?” Ari wa Sisas akalmpentel la, ");
INSERT INTO urim_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kitn nikgwalpm rkekgen eng kai or wanyun wasek pa. Eng ntei, kupm lanakepm la tu wailet ikga mpen la kai or wanyun wasek pa, pake ikgake ntiwe. ");
INSERT INTO urim_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Melnum yan a wan pa ikga wrekg kolti ir wanyun pa, atom ikga kipm itni kawor en pa kulkwon la, 'Wailen, kukwanto wanyun ti!' Pa ikga kil ikilmpentepm la, 'Kupm akwekgel kipm pa la kipm pa angkai a i wli?' ");
INSERT INTO urim_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Wa ikga kipm ikilmpentel la, 'Men pikekg al okipma rka wris nampokgen kitn, wa kitn pikekg kaling planto yangkipm a Maur Wailen tatu anong amenen ti.' ");
INSERT INTO urim_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Wa ikga kil ikilmpentepm la, 'Kupm akwekgel kipm pa. Ti kipm melnum a antokg paipmpaipm pa, kipm kai tukuleikgentopm.' ");
INSERT INTO urim_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ti kipm ti ikga tu tulpulepm itni en, atom ikga ik wang a kipm ri Apraam, Aisak, Sekop numpokgen tu melnum okwripm a rpma kawor anong wor a Maur Wailen pa, kipm ikga akg paipm nampok. ");
INSERT INTO urim_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tu wrongkwail ikga ingkai takgni no, takgni kinar, i yamping yamping pa wli uwi wrik nti Maur Wailen il okipma kaino anong wor. ");
INSERT INTO urim_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kipm itning, melnum tiur a katnukg pa tu ikga wa kai ep, a melnum tiur a ep pa tu ikga wa kai kutnukg.” ");
INSERT INTO urim_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Atom ak wang pa, tu melnum a arpmen yangkipm yiprokgen a Moses tiur, tu kul lanaki Sisas pa la, “Ti kitn kai itn kol ur ai tukuleikgen anong ti! Eng ntei, Erot la ikga wangketeitn meng.” ");
INSERT INTO urim_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ari wa Sisas lanaken la, “Ti kipm kai laniki nimpa tilpmingen pa la kil itni, kupm ikwap ungkwan maur paipm, a ntokg tu melnum numpet palng wor amti ikgkil, atom kwaikg ai pa kwap a kupm ak kil pa ikgam kai plalng ngko pake. ");
INSERT INTO urim_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kolpa ti, amti, ikgkil, kwaikg pa, kupm mpa ngkom kai kolpa, eng ntei, ake wor mpa tu ilm melnum okwripm ur a Maur Wailen pa imo rmpi wrik ur manet pa, kalpis, ikga tu ilmpel imo rmpi Serusalem ai kolti. ");
INSERT INTO urim_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Woi, arein kitn anong Serusalem, Serusalem! Kitn akangklei almpalm tu melnum okwripm, kitn akwesel tu melnum yangkipm kuin a Maur Wailen ukwanteitn kulngkul pa. Wang watipmen ai kupm la lok tu warim alkitnen pa kul rki wris ikglen kol karek man a ak iplepm aur nampi alkil pa, ari wa kipm karken. ");
INSERT INTO urim_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kolpa ti Serusalem, kitn itning, wan yalming a kitn pa ikga Maur Wailen utnuurng itni kupuk kalpmlel kolti. Pake kupm lanakeitn kolkil: ti wa kitn ikgake wa riwopm nti ur, kolpa kai ngko wang a ikga kitn laron kupm ti la, 'Maur Wailen ukwa melnum pa atom kil nar, ti mentepm lkel wor ngkit nang akilen!'” ");
INSERT INTO urim_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ak wang wail ur a rpma eng yapm pa, Sisas kil kai al okipma kai wan anong a melnum wailen ur a tu melnum a arpmen yangkipm yiprokgen a Moses pa, ari tu wrongkwail tu wulmparpmewel. ");
INSERT INTO urim_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ari melnum ur a awi numpet a numpwam oren pa, kil rpma wreren Sisas pa. ");
INSERT INTO urim_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Atom Sisas asen tu melnum a aroaro wonel tu yangkipm a Moses pa, wa nampokgen tu melnum a arpmen yangkipm yiprokgen a Moses pa la, “Ti yangkipm titnongket amentepmen pa la antiwe mpa ntokg tu melnum numpet pa palng wor ik wang wail ti aki, kalpis?” ");
INSERT INTO urim_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ari tu pa ake la kwei ur, atom kil wamparpme melnum pa ungkwan numpet akil pa takwleikgentel kolti, a ukwawel kai. ");
INSERT INTO urim_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Atom kil lanaken kolpa la, “Ti kol warim kipman ur aki a manto nepm watin ningko ur a kipm pa ngko elng kinar u pa ik wang wail ur a rpma eng yapm pa, akentiwe mpa kipm rkolngkel iye no tukuleikg u pa ik wang wail pa?” ");
INSERT INTO urim_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ari tu akentiwe mpa tu ikilmpe yangkipm pa. ");
INSERT INTO urim_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Atom Sisas kil ari tu melnum tiur a tu akwenten wli la tu il okipma pa, tu awi wrik wor wor pa arpme, atom kil lanaken yangkipm kla ur pa la, ");
INSERT INTO urim_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","”Melnum ur ukwentepm eng okipma wail ur a ntokg il itnen kin kipman a awi tita pa, ampur kitn kai arpme wrik wor pa ep. Kol a kitn elng wrik pa elngkitni eng kol a uk melnum wailen ur a angen kitn ti a pikekg kil akwen pa mpa wli rpme. ");
INSERT INTO urim_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Pake kol kitn ti rpme pa, melnum a akwentepm yatenen pa mpa kai lanikeitn la, 'Ai, kitn elng wrik ti elngitni eng melnum wailen ti.' Kolpa kitn mpa wa numpaipm eng kil lanakeitn la kitn wrekg tukuleikgen wrik ti kinar rpmi kinar kanokg ai. ");
INSERT INTO urim_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kolpa ti wang a tu akwenteitn pa, kitn kai rpmi kanokg pa ep pen, atom kol melnum a akwenteitn pa riweitn pa, mpa kil lanikeitn la, 'Yek alkupm, wrekg kaino rpmi wrik wor ai.' Kolpa kitn mpa uwi nang wailen itna wulmpa a tu mla ur a kipm al okipma rka wan pa. ");
INSERT INTO urim_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Eng kol melnum a antokg kil alkil palng nang wailen pa, ikga itni nang wusok. A melnum a arku kil alkil pa, ikga itni nang wailen.” ");
INSERT INTO urim_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Atom Sisas kil lanaki melnum a akwentel pa la, “Kol kitn ntokg okipma wail ur pa, ampur kitn akwen tu melnum wor alkitn, aki wusok wail alkitn, aki yiprokg ur alkitn, aki tu alkitn a kipm rka wris a rpma antiwe pa. Eng ntei, wang ur a ikga tu wa ntokg okipma wail pa, ikga wa tu wa ukwenteitn ikilmpe a pikekg kitn akwenten pa. ");
INSERT INTO urim_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kitn la ntokg okipma wail ur pa, kitn ukwen tu melnum a rpma tukwok, tu a numpwam paipmen, a tu melnum nepm paipmen, a wulmpa tilmpisen. ");
INSERT INTO urim_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kitn angklin tu a kolpa pa, kitn akwap wor pake, kitn itopen o! Eng tu pa akentiwe ikga ikilmpenteitn. Ikga Maur Wailen kil alkil ikilmpenteitn ik wang a tu melnum ute wor pa wrekg wrekg i kirkap ai.” ");
INSERT INTO urim_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wa melnum wris ur a antiwen al okipma rpma pa, atning yangkipm a Sisas la pa, atom kil lanakel la, “Mla ur a ikga il okipma wail kaino anong wor a Maur Wailen pa, kil pa wor pake, kil itopen o!” ");
INSERT INTO urim_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ari wa Sisas kil akalmpentel la, “Melnum wris ur pikekg kil la ntokg okipma wail, atom kil ukwa yangkipm kai lanaki tu wrong watipmen pa la, ikga tu wli eng ntiwel rpmi il okipma pa. ");
INSERT INTO urim_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kil numprampen okipma pa plalng pa, wang a il okipma pa, kil ukwa tu melnum akwapel alkil pa kai ri tu a pikekg kil akwenten la ikyakuren atom wa laniken la, 'Kipm kul o, kweikwei wrongkwail am numprampen yat ise!' ");
INSERT INTO urim_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tu kai la ikyakuren, ari tu kimeket la la tu arkewe kweikwei tiur ai, ti tu ake mpa kai. Atom melnum ur pa lanakel la, 'Wai, areinseitn eng kupm arkewe. Kanokg ur a kupm armpen kil, ti kupm mpam kai ri kilke. Ti kupm ake mpa kai.' ");
INSERT INTO urim_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wa ur pa lanakel la, 'Wai, areinseitn, eng kupm arkewe manto nepm watin wampwam kupm armpen ti, ti kupm la kai uwiyen eng ik ik kwap ukwiyen pen, kolpa ti akentiwe mpa kupm kai.' ");
INSERT INTO urim_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wa ur pa la, 'Kupm wuten awi kin ti pen, ti akentiwe mpa kupm utnurngkel kai.' ");
INSERT INTO urim_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Atom melnum akwapel pa yaper kul naki melnum yan a numprampen okipma pa la tu arkewe, ti tu ake mpa wli. Kil atning a tu la kolpa atom kil ipma wakget paipm, atom kil lanaki melnum akwapel alkil pa la, 'Kolpa ti kitn penterng kai tutu ya wenting wenting akapm wail wail a anong wail ti ikor ik yakur tu melnum a rpma tukwok, tu a numpwam paipmen, tu a nepm paipmen, a wulmpa tilmpisen ai tu kul!' ");
INSERT INTO urim_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Atom melnum akwapel alkil pa am kai ak katila kol a kil la pa, atom wa kil wa yaper kul la, 'Wailen, oklala a kitn pa kupm katnun, pake wrik wailet wa itna ai.' ");
INSERT INTO urim_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ari wa melnum yan a numprampen okipma pa lanakel la, 'Ti wa kitn wa utnuurng ti wa kai tutu ya wail wail a ya waiketnketn a kai tatu wringkya kweikwei pa, ukwe ikor laniken erkisen ikyakuren iye wli kawor wan a kupm ti ninin, kil ntiwe. ");
INSERT INTO urim_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ti kupm lanakepm la, tu melnum a kupm akwenten ep pa, akentiwe ikga ur il okipma wail akupmen pa!'” ");
INSERT INTO urim_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ak wang wris ur pa, tu wrong wailet paipm anti Sisas pa angkom kai, atom kil plelng lanaken la, ");
INSERT INTO urim_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","”Kitn mla ur a kul eng kupm pa, pake ake wa kitn uk yirokg mansan, kinwatnom, muinwror muikgmayen, a wa kitn alkitn ti yat, kitn akentiwe a palng watnom akupmen a kupm aroaro wonel pa. ");
INSERT INTO urim_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wa melnum a ake arki yo okgmangki alkilen atom katnuntopm pa, kil ake antiwe mpa palng watnom akupmen a kupm aroaro wonel pa. ");
INSERT INTO urim_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kol kipm ur akwonalmpen la le wan wail watin ur pa, kitn rpmi ikwonilmpen pen, la ikga kitn ntiwe a le wan pa plalng pipa, kitn le. ");
INSERT INTO urim_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pake kol kitn uwen ong lil mpangkil pa kolti, ari ake kitn antiwe antokg wan pa plalng pa, tu riweitn pa, ikga tu ik nokgeleitn. ");
INSERT INTO urim_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ikga tu wa la, 'Melnum ti ngkaten kwap ti, ari ake wa kil antiwe a kil ak pa kai plalng!' ");
INSERT INTO urim_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Wa kol melnum tukgunakg ur kil uwi wrong wusoken kamel kamel (10,000) a kil pa iye kai eng rapon numpokgen wrong wailet kamel kamel (20,000) a melnum tukgunakg ur ai pa, kil mpa rpmi eng ikwonilmpen la, wrong wusoken kolpa tu antiwe mpa lok ngkli tu wrong wailet pa aki, kalpis. ");
INSERT INTO urim_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kol la kil akentiwe pipa, mpa kil ukwa melnum yangkipm kuin pa kai ri melnum tukgunakg ur pa ngko ya ur ai pa la ipma wris ngkeng tita, eng ake mpa tuwekg rapon pa. ");
INSERT INTO urim_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kolpa ti kupm lanakepm la, kol melnum ur ake kil uk yirokg kweikwei alkilen pa, kil akentiwe a palng watnom akupmen.” ");
INSERT INTO urim_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Nokgnok pa kleset pake, kol kil kupuk pa, akentiwe mpa wa mentepm ntokg eng wa kil palng kleset. ");
INSERT INTO urim_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ti nokgnok kupuk paipm a kolpa, pa mpa ngkiten kai lung ngklin nep a namung kweikwei pa kolti, pake ake wa antokg nep a namung pa wor kolai. Ti kol kipm melnum a nungkulkg atnewe pa, kipm itning o!” ");
INSERT INTO urim_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wang wris ur pa, tu melnum a awi marpmel tu, a tu melnum tiur a antokg paipmpaipm pa, wli la itning yangkipm a Sisas angkli pa. ");
INSERT INTO urim_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ari tu melnum a arpmen yangkipm yiprokgen a Moses, wa nampokgen tu melnum a aroaro wonel tu yangkipm a Moses pa, anel ipma paipm eng pa, atom anel la, “Melnum pa wa kai atn orwris wa al okipma anti tu melnum a antokg paipmpaipm pa eng ntei?” ");
INSERT INTO urim_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Atom Sisas lanaken yangkipm kla ur la, ");
INSERT INTO urim_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","”Ti kol kipm ur ikglen manto walkg malkgu kamel wampwomis, atom wris ur pa kai am pa, mpa kitn ntokg kolai? Kitn mpa utnuurng kamel wikgwikg tuwek wampwam yikakwomis yikakwompwikgwikg pa itni wrik laikge wor pa, a kai ikor wris pa, kaingkai, kitn nsil. ");
INSERT INTO urim_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kitn nsil pa, mpa kitn ngkit ngkli kaino maleng ai, atom itopen paipm kolti am aye kai anong ise. ");
INSERT INTO urim_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Atom mpa kitn ukwen tu yiprokgen a tu anongwris alkitn pa kolti wli, atom kitn laniken la, 'Kupm atopen paipm eng kupm ansil manto walkg malkgu wris ur alkupm a pikekg am. Ti tepm ntokg okipma il itnen!' ");
INSERT INTO urim_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ti am wa kolpake, kupm lanakepm la, pa tu a rpma kaino anong wor ai pa, tu atopen tu melnum ute wor kamel wikgwikg tuwek wampwam yikakwomis yikakwompwikgwikg a pikekg plelng ipma ise. Pake melnum paipm wris ur a kil plelng ipma pa, mpa tu itopen wail paipm angen pa.” ");
INSERT INTO urim_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Aki kol kin ur pa kil aye marpm wampwam, ari wris ur pa angko am pa, mpa kil ntokg kolai? Mpa kil la wakg ti ik ikor kai la kalpis pa, kil kinsim ipikel wan ti irongen ikor ikgen yela kolpa kaingkai, kil nsil. ");
INSERT INTO urim_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kil nsil pa, mpa kil ukwen tu yiprokg a anong wris alkil pa wli kolti, wa kil laniken la, 'Kupm ti atopen paipm, eng marpm a am pa am kupm ansil ise. Ti tepm ntokg okipma il itnen!' ");
INSERT INTO urim_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ti am wa kolpake, kupm lanakepm la, wang a melnum paipm wris ur kil plelng ipma pa, tu maur akwapel a Maur Wailen pa atopen paipm.” ");
INSERT INTO urim_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Atom Sisas kil wa la, “Yan ur pa, warim kipman wekg. ");
INSERT INTO urim_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Atom warim kipman paipmen pa lanaki yan alkil pa la, 'Kitn iro kweikwei wompel akupmen ti lkopm!' Atom yan pa wrekg kolti, a ampreing kweikwei pa uk warim kipman wekg alkil pa. ");
INSERT INTO urim_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Plalng pa, warim kipman paipmen pa rpma wang aripm ur kolti, awi kweikwei alkil ti ak awi marpm, plalng pa, kil wrekg kolti kai rpma kol anong watin ur ai. Kil rpma anong pa, kil angkli marpm alkil pa kai eng kweikwei paipm paipm kolti. ");
INSERT INTO urim_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kil angkli marpm alkil pa kolpa kaingkai kai plalng pa, wangnikg wail palng kai anong pa, atom ak antokg kil pa rpma tukwok paipm wrisen kolti. ");
INSERT INTO urim_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Atom kil kai ari melnum ur a anong kanokg pa, atom kil lanakel la, kil la ikwap ur. Atom kil alkel kwap a ikgalen manto itna kai wrik a elng manto atnewe atnewe pa. ");
INSERT INTO urim_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ari ake melnum ur alkel okipma ur, atom kil akwonalmpen la, kil a nti manto pa il yampis palk a tu aye kai alung uk manto pa al pa. ");
INSERT INTO urim_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ari nikgwalpm wor pa palngtel, atom kil akwonalmpen kai kil alkil pa la, 'Tu melnum a akwap eng yan alkupm pa, tu antiwe okipma watipmen eng al, pake kupm am amo eng nikg rpma tike! ");
INSERT INTO urim_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ti mpa kupm wrekg yaper kai eng yan alkupm pa, atom mpa kupm lanikel kolkil la, “Yaiyai, arein, kupm antokg paipm kai kitn a wa kai Maur Wailen ai. ");
INSERT INTO urim_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ti kupm ti ake wor eng mpa kitn ukwewopm la warim kipman akitnen pa. Ntokg kupm ti kol melnum akwapel akitnen!”' ");
INSERT INTO urim_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kil akwonalmpen kolpa, kil wrekg kolti kai eng yan alkil. Yan alkil pa ikg kai ariwel kai watin ai, a kil arein paipm, atom kil pirng kai kolti arkulel, nakrontel. ");
INSERT INTO urim_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Atom kil lanaki yan alkil pa la, 'Yaiyai, kupm arein eng kupm pikekg antokg paipm kai kitn ti a wa Maur Wailen ai. Kolpa ti kupm ti ake wor antiwe mpa kitn ukwewopm la warim akitnen pa.' ");
INSERT INTO urim_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ari yan alkil pa akwe tu melnum akwapel alkil pa la, 'Kipm itatu wli! Kipm iye apm watinet wor ur pa iye wli nowewel, a uwi mikgni pa rpmewel kai wam kil pa, wa uwi nepm palk pa nowel kai nepm kil pa! ");
INSERT INTO urim_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kai ilm manto nepm watin war ur a numpu arke pa eng mpa mentepm ntokg okipma il itnentel. ");
INSERT INTO urim_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Eng ntei, warim kipman akupmen kil, kol am pikekg amo ur ise, ari wa wrekg wa rpma. Wa kil am pikekg atnuurngko kai wrisen ise, ari wa kil wa yaper wlinto tike.' Tu melnum akwapel atning a kil la kolpa atom tu numprampen antokg okipma wail pa al atnentel. ");
INSERT INTO urim_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Atom ak wang pa, warim kipman wailen pa kil angkai wring pa kul wreren wan anong ti pa, kil atning tu atopen a antokg nangnang pa, ");
INSERT INTO urim_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","atom kil akwe melnum akwapel ur a yan alkil pa wli atom kil asentel la, 'Tu antokg nangnang atnen kuina wai?' ");
INSERT INTO urim_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ari wa melnum akwapel a yan alkil pa akalmpe la, 'Wusok alkitnen pa am wa wli ise, atom yan alkipmekgen pa alm manto nepm watin war wris ur a numpu arke pa, atopentel eng kil ake kai paipm, aki amo ur pa kalpis, kil rpma, atom am wa yaper wlintel ise.' ");
INSERT INTO urim_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Wailen pa nikgwalpm paipm la kil ampake kawor wan pa, ari yan alkil pa or armponel la tuwekg kawor wan pa. ");
INSERT INTO urim_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ari kil ti la kai yan alkil pa la, 'Kitn itning, wring watipmen paipm kupm aken kwap kitn ti kolen melnum akwapel akitnen pake. A ake wa kupm nungkulkget wang ti ur. Ake pikekg kitn alkopm kweiur? Ti ake wa kitn alkopm manto walkg malkgu war ur ti eng mpa kupm ntokg okipma ur il itopen numpokgen tu yiprokg alkupmen ti! ");
INSERT INTO urim_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Warim kipman alkitnen ti pa, kil pikekg angkli kweikwei wor wor akitnen pa itna tu kin a angkli arkul tu kipman pa plalng, wa kil wa yaper wli pa, wa kitn wa alm manto nepm watin war a numpu arke pa, atom wa antokg okipma al atnen kil pa eng ntei?' ");
INSERT INTO urim_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ari wa yan pa akalmpentel la, 'Kitn ti pa am mentepm rpma rpma tike, ti kweikwei wrongkwail akupmen ti pa am akitnen pake. ");
INSERT INTO urim_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pake mentepm mpa ntokg okipma il a itopen, itnen wusok alkitn ti pikekg kol am kai imo ur ise, ari wa kil rpma. Wa kil am pikekg atnuurngko kai wrisen ise, ari wa kil wa akwonalmpento, atom kil am wa yaper wlinto tike.'” ");
INSERT INTO urim_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Atom wa Sisas lanaki tu watnom alkil pa la, “Melnum ur pa kil antiwe kweikwei watipmen, atom wang ur pa tu tiur wli lanakel la, 'Melnum akwapel akitnen ti ake akwap a kitn ti ariworwor. Kil kaken kweikwei akitnen ti kai eng a kai plalng ti.' ");
INSERT INTO urim_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Atom kil akwe melnum akwapel pa kul kolti, a kil lanakel la, 'Kupm atning yangkipm a tu la kitn ti akwap paipm. Ti kitn kai ik ker uwiye kweikwei wrongkwail akupmen a kitn ikgalen pa kimeket atom nirantopm iye wli, atom mpa kitn plalng kwap akupmen ti.' ");
INSERT INTO urim_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Atom melnum pa akwonalmpen la, 'Ai, ikga wa kil ungkwantopm tukwleikgen kwap alkupm kil tuwa. Ti mpa kupm ntokg kolai? Ti kupm ti ake antiwe titnongket a akwap wringkya kweikwei pa, wa kupm numpaipm eng ak okla kweikwei atu. ");
INSERT INTO urim_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pake kupm ariwe ya ur kil: mpa kupm ngklin tu mlaur ai, eng ikga kol kil ungkwantopm eng kwap a kupm ak ti pa, ikga kupm won ngklin kweikwei a pikekg kupm uk tu pa.' ");
INSERT INTO urim_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Atom kil akwen tu a pikekg awi kuloken kai melnum a kil aken kwap pa wli. Atom kil asen tu pa wris wris la, 'Kitn pikekg awi kweikwei aripm kai melnum a kupm aken kwap ti?' Ari wa ur pa akalmpe la, ");
INSERT INTO urim_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","'Kupm awi nep numong kamel wampwomis.' Atom wa kil lanakel la, 'Ti kitn uwi wrkapm kil rpmi ingkai wrik ai, pirpiren lo kamel wampwomis pa wa nira kamel wekg tuwek wampwam ti kolti penterngen!' ");
INSERT INTO urim_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wa kil wa asen ur pa, wa kil wa la, 'Kupm awi okipma numong wail kamel wampwomis.' Atom wa kil lanakel la, 'Ti kitn uwi wrkapm kil lo kamel wampwomis pa wa nira kamel wikgwikg ti kolti!' ");
INSERT INTO urim_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Atom melnum a antiwe kweikwei watipmen pa kaporng yangkipm lanaki melnum akwapel alkil a aklampe kweikwei alkilen pa la, 'Ya tiur a kitn ak pa kitn ak wontrakole wor eng ak angklin kitn alkitn.' Eng ntei, tu melnum a katnun kuina ur a itna kanokg ti pa tu akwap wontrakole itna kuin a tu alntu ti angen tu melnum a awi klalen a Maur Wailen pa.” ");
INSERT INTO urim_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Sisas la yangkipm kla pa kai plalng pa, wa kil wa la, “Ti kupm lanakepm la, kipm ik kweikwei a kipm antiwe itna kanokg paipm ti ik ngklin tu mlaur pa eng mpa ntokg tu palng melnum wor akipmen pa, eng ikga wang a kweikwei pa kai plalng pa, ikga tu uwiyepm iye kai wan anong wor a rpma yongkyong won ngklin kweikwei a pikekg kipm uk tu pa. ");
INSERT INTO urim_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ti kol mlaur a nungkulkg wor eng ikglen kweikwei waseksek pa, kil pa wa nungkulkg wor antiwe eng ikgalen kweikwei wail wail ai yat. Wa am kolpake, melnum a ikgalen paipmel kweikwei waseksek pa, pa kil ikgam wa ikglen paipmel kweikwei wail wail ai kolpa yat pake. ");
INSERT INTO urim_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ti kol ake kipm nungkulkg wor ikglen kweikwei a itna kanokg paipm a ti riworwor pa, ti ikga wa mla lkepm kweikwei wor wor a itna yongkyong pa eng kipm ikglen? ");
INSERT INTO urim_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ti kol ake kipm nungkulkg wor ikglen kweikwei a melnum manet pa riworwor pa, ti ikga mla wa lkepm kweikwei alkipmen a aknamputepm pa? ");
INSERT INTO urim_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ti melnum ur akentiwe mpa kil iken kwap mring wekg pa, pa mpa kil ipma paipm eng ur, wa plan ipma wor wasrongen ur, aki mpa kil uwi wor la ur pa, wa kil uwi paipm la ur pa. Ti akentiwe mpa kipm orngwatneikgen kweikwei wekg pa ngkompwris, Maur Wailen a marpm kweikwei pa.” ");
INSERT INTO urim_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pake tu melnum a arpmen yangkipm yiprokgen a Moses pa tu melnum a aringkowe marpm atom ak wang a tu atning yangkipm a Sisas kil la kolpa pa, tu la paipmelel. ");
INSERT INTO urim_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Atom Sisas lanaken la, “Kipm ti la plan kipm alkipm ti la tu wrong kin kipman riwepm la kipm ti melnum ute wor, pake Maur Wailen pa ariwe kawor nol wunen akipmen ai. Kuina ur a kipm melnum ti ari la wor pa, Maur Wailen pa kil ari la pa uk numkropis kamel.” ");
INSERT INTO urim_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Sisas wa kil wa la kolkil la, “Kol yangkipm titnongket a pikekg Maur Wailen uk Moses, wa yangkipm a pikekg tu melnum okwripm a Maur Wailen nira pa, pikekg alkepm ariwe, kolpa kul angko wang a Son kil kaluko ti. Atom Son pa pikekg kil ngkaten eng laron yangkipm wor a la Maur Wailen itna wailen la ikglen nol nikgwalpm a kipm wrongkwail kin a kipman kolpa kai yela. Atom tu wrong wailet tu nikgwalpm arkekgen aken kwap akoporen tita la kawor yipmingki wunen a Maur Wailen itna wailen ikgalen kweikwei wrongkwail pa. ");
INSERT INTO urim_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pake pa ake la la yangkipm titnongket a pikekg Maur Wailen alko ep ti pa kai kalpis pa, kolpa kalpis. Kitnong a kanokg pa ikga kai plalng, pake yangkipm titnongket a Maur Wailen ti pa, ikgam itna kati kati kolpa kimeket pake. Ikgake yangkipm ketn ur kai am, pa kalpis.” ");
INSERT INTO urim_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Sisas la kolpa plalng pa, wa kil wa la kolkil la, “Ti kol melnum ur ungkwan kin alkil, wa uwi kin weten pa, pa kil angkli arkul kin pa. Wa melnum a awi kin ur a kipman ur manet ungkwan pa, pa wa kil angkli arkul kin pa.” ");
INSERT INTO urim_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Sisas la melnum wekg ur pa kolkil la, “Melnum ur pa kil antiwe kweikwei watipmen. Kil nowe apm tangkoren wor wor nakure ariworwor a, antokg okipma wor wor wail wail al akangklei wang. ");
INSERT INTO urim_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Wa melnum ur a tu namput la Lasarus pa, kil rpma tukwok eng kweikwei wrongkwail. Wa kil pa i al numpwam a kil ti plalng. Kil am rpma rpma wanyun a melnum a rpma antiwe pake. ");
INSERT INTO urim_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kil la kol a il okipma ipran a angko rmpa tatu wrik a melnum a antiwe kweikwei rpma al okipma pa. Wa nimpa pa akangklei wli nipla al i akilen pa itna. ");
INSERT INTO urim_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kolpa kaingkai, Lasarus kil amo, atom tu maur akwapel a Maur Wailen awi maur amen wor akilen pa aye kaino rpma wor nampokgen Apraam ise. Wa melnum a antiwe kweikwei watipmen pa wa kil amo atom tu uwentel. ");
INSERT INTO urim_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Amen wor akilen pa kai rpma wrik om a tu melnum amo kai arke arke pa, kil awi wleket paipm, atom kil ikg kaino ari Lasarus pa nampokgen Apraam pa rpma kaino watin ai. ");
INSERT INTO urim_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Atom kil akwe la, 'Yayai Apraam, kitn reinsopm pen! Kitn ukwa Lasarus pa kil ipo wam pa ngkle u ur pa, atom ungkwan polng elngkul nar ik itnewopm kromeng kil pen! Numpwam kupm ti wakg atne waiwai wleket paipm kolti.' ");
INSERT INTO urim_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ari wa Apraam lanakel la, 'Warim, kupm ake antiwe mpa ik kolpa. Ti kitn ikwonilmpen wang a pikekg kitn rpma kinar kanokg pa, kitn pikekg rpma antiwe kweikwei wor wor watipmen, pake Lasarus kil pikekg rpma tukwok. Ti ak wang ti am wa kolpake, kil awi wang wor atopen rpma wor kilke, a kitn pa awi wleket rpma paipm pake. ");
INSERT INTO urim_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Wa yat, watu wail manten pikekg angklo itna kuin ak aro mentepm ti, la akentiwe mpa men ti kai riwepm aki, kipm pa kul riwo pa, kalpis.' ");
INSERT INTO urim_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ari melnum a antiwe kweikwei watipmen pa lanaki Apraam la, 'Kolpa ti, yayai, kitn laniki Lasarus pa la kil kinar wan a yan alkupmen pa, ");
INSERT INTO urim_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","atom laniki tu paipm paipm wampwomis alkupm pa titnongket, la tu ngkom nulokgen ya wakget wleket paipm a kupm ore kil!' ");
INSERT INTO urim_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ari wa Apraam akalmpe la, 'Yangkipm wrkapm a pikekg Moses nampokgen tu melnum okwripm a Maur Wailen nira pa am rmpa pake. Tu itning kutnun yangkipm pawo!' ");
INSERT INTO urim_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ari wa melnum pa la, 'Yaiyai Apraam, kolpa kalpis, pa akentiwe. Kol melnum ur a pikekg amo ti wrekg i kirkap ti kinar laniken pa pati, mpa tu plelng ipma pake.' ");
INSERT INTO urim_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ari Apraam kil la kolpa, 'Kol ake tu atning katnun yangkipm a Moses pa nampokgen tu melnum okwripm a Maur Wailen pa, pa ikgake wa ntiwe a tu itning yangkipm a melnum a pikekg amo ti wrekg a kirkap ti.'” ");
INSERT INTO urim_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Atom Sisas lanaki tu watnom alkil a kil aroaro wonel pa la, “Kweikwei a ak ningkailo la mentepm ngko pa am palng kolpa itna pake, ikgake kalpis pa. Pake woi, arein eng melnum a kil ningkail melnum ur iye kai ngko pa! ");
INSERT INTO urim_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kol kil ningkail kipm melnum ur a ake ukipma kupm ti itna titnongket pa kil ngko pa, kol a tu yipo wes wail ur pa rpmi mengkel kil pa atom ngkliwel elng kinar unokg ai, pa kol a wor. Pa kil ikga uwi paipm wrisen angen a tu yapo wes rpma mengkel angkliwel elng kinar unokg pa. ");
INSERT INTO urim_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ti kipm rpmi riwe kipm alkipm ti! Kol melnum ur alkitn a kipmekg ukipma kupm ti pa ntokgteitn paipm pa, kitn ngkengkel titnongket eng ake mpa kil ntokg pa. Pake kol kil la rein pipa, kitn utnuurng paipmpaipm a kil antokg pa. ");
INSERT INTO urim_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Wa kol kil ntokgteitn paipm nti watipmen ik wang wris pa atom wa kil wli la rein nti watipmen pa, kitn mpa itopen kolti eng utnuurng paipmpaipm a kil antokgteitn pa.” ");
INSERT INTO urim_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Atom tu melnum wokgen a Sisas pa lanaki Sisas pa la, “Men wasrongen la kitn ngklinso eng mpa men ukipma itni titnongket.” ");
INSERT INTO urim_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ari Wailen kil akalmpenten la, “Wor pa, kol kipm ukipma waiketn kol marer ok wasek pa, kol a kipm laniki yo ti la, 'Ti kitn nulu kitn alkitn ti ngkiten kulung kinar inip itni kinar unokg ai', ti yo ti mpam itning yangkipm kol a kipm la pake.” ");
INSERT INTO urim_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ti kol kipm ur melnum akwapel ur akitnen ikwap kai wring akitnen a ikglen manto walkg malkgu akitnen pa, ampake wa kitn ti wa lanikel la, 'Kitn wli itatu il okipma ti!' ");
INSERT INTO urim_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kolpa kalpis. Kitn mpa la, 'Kitn numprampen kitn alkitn ti rpmi ntokgtopm wakgkuntuk ti or yawel iye kul mpreingtopm eng kupm il plalng pa, wa kitn wa kai ntokg alkitnen pa wa il kul!' ");
INSERT INTO urim_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ake melnum pa kaporng yangkipm la melnum akwapel alkil pa, kwap a melnum akwapel pa am kil ak kolpake. Ti mpa wa melnum pa kiporngtel yangkipm la eng ntei? ");
INSERT INTO urim_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ti kipm ti am wa kolpake, kol kipm ntokg kuina ur a pikekg Maur Wailen la kipm ntokg pa, plalng pipa, kipm la kolkil, 'Ampur kipm uk wor ngkat nang amenen ti, palpa men ak kwap almenen.'” ");
INSERT INTO urim_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sisas kil angkom or ya pa kinar kolpa la kinar anong wail Serusalem pa, kil kinar angko Samaria a kirng kowak a anong kanokg Kalili a uk tita pa. ");
INSERT INTO urim_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Atom kil kai palng kai anong ur pa, kil ikg kai ari tu melnum numpet wampwam a i paipuk awi pa tu kul itna kai watinet ai, ");
INSERT INTO urim_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","atom anel akwewel la, “Melnum Wailen Sisas, kitn reinso pen!” ");
INSERT INTO urim_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ari Sisas lanaken la, “Ti kipm kai plan numpwam akipmen ti kai tu melnum ipma krakgen a ak ak kwap eng al wor uk Maur Wailen pa riwepm pen!” Tu atning kolpa kai angko ya pa ari numpet a tu pa am palng wor ise. ");
INSERT INTO urim_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Atom wris ur atuwen a palng wor pa kil ari kolpa atom, kil plelng kolti tipra ngkat nang a Maur Wailen pa yikakatnen kolpa yaper a ya pa kul eng Sisas pa. ");
INSERT INTO urim_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Atom kil elng angko wontaipur rmpa nepm a Sisas ti alkel wor. Melnum pa kil melnum a anong kanokg Samaria. ");
INSERT INTO urim_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Wa Sisas asen la, “Melnum wampwam wuten palng wor ti, ti wampwomis wampwompwikgwikg pa a i? ");
INSERT INTO urim_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Antokg kolai atom wa melnum wris ur a anong manet ur ai ti kolti wa yaper wli ngkat nang a Maur Wailen ti?” ");
INSERT INTO urim_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Atom Sisas lanaki melnum pa la, “Kitn wrekg kai o! A kitn ukipma titnongket kolpa atom, numpet alkitnen am palng wor ise.” ");
INSERT INTO urim_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Atom tu melnum a arpmen yangkipm yiprokgen a Moses tiur pa asen Sisas la, “Wang a i ikga Maur Wailen nar itni wailen ikglen kweikwei wrongkwail pa?” Ari wa kil akalmpe kolpa la, “Maur Wailen am nar ise eng la itni wailen ikgilen nol nikgwalpm akipmen tike, pake ake mpa kipm ri wunongen ik wulmpa pa. ");
INSERT INTO urim_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ti ake antiwe mpa ur wa la, 'Ti itna ti' aki, 'Ti itna kai ai', eng ntei, Maur Wailen pa am antiwepm itna wailen ikgalen nol nikgwalpm akipmen tike.” ");
INSERT INTO urim_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Atom kil lanaki tu watnom alkil pa la, “Wang kalkuten ur ikga palngtepm. Atom ikga ik wang pa kipm ikga wasrongen paipm la kol a ri wang wris ur a Warim Kipman a Melnum la nar itni wailen ikglen kweikwei wrongkwail pen. Pake kipm ikgake ri itatu ik wang pa, a pa. ");
INSERT INTO urim_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tu tiur ikga wa lanikepm la, 'Ti kil itna kai ai.' Wa tu tiur pa ikga wa lanikepm la, 'Ti kil itna ti.' Pake ampur kipm pirng katnunten akor kai pa kai pa. ");
INSERT INTO urim_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ik wang a Warim Kipman a Melnum pa nar pa, ikga palng kipm ri yela kolen milmal a plaing kaino kitnong pa. ");
INSERT INTO urim_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pake ep pa kil ikga rki kalkuten a tu melnum a ak wang ti pa ikga lkel yirokg papen. ");
INSERT INTO urim_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ikga ik wang wreren Warim Kipman a Melnum ikga nar pa, atn a rpma a tu wrong kin kipman pa ikgam palng repmrepm kol a tu pikekg palng ak wang a Nowa pa. ");
INSERT INTO urim_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tu wrongkwail pikekg awi tita, antokg okipma al rka, kolpa kai angko wang ketn a Nowa kil kai kawor wan unokgen pa, u wail awei nar akalen. ");
INSERT INTO urim_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ti ikga wa palng kolen pikekg ak wang a Lot pa. Wrongkwail pikekg antokg okipma al, armpen kweikwei, ak kweikwei awi marpm, antokg wring, ale wan kolpa kaingkai, ");
INSERT INTO urim_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","kai angko wang a Lot kil atnuurng Sotom pa, wakg wail manten nampokgen wes wakget kolen karin a tu lap ti angkaino kitnong ti nar ake u a awei pa, kolti lapen kimeket kolti. ");
INSERT INTO urim_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ti wang a Warim Kipman a Melnum pa palng ngko wunong pa, ikgam kolpake. ");
INSERT INTO urim_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kol melnum ur ikga ik wang pa rpmi kawor wan male pa, ampur wa kil kawor wan wunen pa eng uwi kweikwei tiur alkil pa. Wa kol melnum ur ikga ikwap itni kai wring alkil pa, ampur kil wa yaper kul anong pa, kalpis, kil i pa kai pake! ");
INSERT INTO urim_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ti kipm ikwonilmpen kin a Lot pa! ");
INSERT INTO urim_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Atom melnum a kil ikgalen num alkil a aye num alkil ngkark pa, amen wor alkil pa ikga kai paipm. Pake mla ur a kil angkli num alkil pa, amen wor a kil pa ikga kai wor. ");
INSERT INTO urim_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kupm lanakepm la, ikga ik mining pa, melnum wekg a okg rmpa wris pa, wris ur pa ikga kil uwi, wa wris ur pa ikga kil utnuurng okg rmpi pa. ");
INSERT INTO urim_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wa kol ikga wa kin wekg ur ntokg wakg kuntuk rpmi wris pa, wris ur pa ikga kil uwi a wris ur pa kil ikga utnuurng rpmi pa. ");
INSERT INTO urim_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wa melnum wekg a ak kwap itna wring pa, wris ur pa ikga kil uwi, a wris ur pa ikga kil utnuurng itni pa.” ");
INSERT INTO urim_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Atom tu watnom alkil pa asentel la, “Wailen, ti kweikwei pa ikga palng itni kai a i?” Ari wa Sisas akalmpe la, “Kipm ikga ri kirmpa taung ur a o o akam ela pa pati, kipm ariwe la, kil ari wlikgok ur alkil a la mpa il pa am rmpa pake.” ");
INSERT INTO urim_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Atom Sisas lanaken yangkipm kla ur pa eng mpa tu uwi riwe atom mpa tu oklala niki Wailen pa ikngklei wang, a ake mpa tu kai lpmaaken pa. ");
INSERT INTO urim_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yangkipm kla pa kil la kolkil, “Kai anong wail ur pa, melnum ur a rpma eng atning atning yangkipm pa rpma, kil ake ngkarken Maur Wailen pa, aki akwonalmpen melnum ti, kalpis. ");
INSERT INTO urim_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wa kin karpikg ur pa, am wa rpma anong wail pa yat pake. Atom akangklei wang kil wli erkisen lanakel la, 'Kitn ngklinsopm eng kaikuten a pikekg melnum ti antokgtopm ti.' ");
INSERT INTO urim_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kil kul perper lanakel pake ake kil atning kaikuten a kil lanakel pa. Kolpa kaingkai, wang wris ur pa, kil akwonalmpen la, 'Kupm ti ake ngkarken Maur Wailen pa, aki akwonalmpen tu melnum ti. ");
INSERT INTO urim_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pake kil perper kul lanakopm atom antokg kupm ti numpatningkewopm paipm ai, ti kai kupm ngklinsel pen.'” ");
INSERT INTO urim_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Wailen la yangkipm kla pa plalng pipa, wa kil wa la, “Ti wet kipm atning kuina ur a melnum paipm a rpma eng atning yangkipm pa la pa. ");
INSERT INTO urim_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ti Maur Wailen ake antiwe mpa itning tu melnum a kil takweiyen a tu akg lanakel miningkranen la kil ngklinsen. Ti kil mpa nungkulkg lantok rpmi wang watin? Kalpis. ");
INSERT INTO urim_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kupm lanakepm la, kil mpa itning kalkuten a tu pa ngklinsen itatu pa. Pake Warim Kipman a Melnum ikga nar kanokg ti pa ikga kil nsil tu melnum tiur a ukipma kil pa aki, kalpis?” ");
INSERT INTO urim_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Atom Sisas kil la yangkipm kla kil kai eng tu melnum a akwonalmpen la tu alntu pa ute wor pake, arku tu tiur ai la paipm pa. ");
INSERT INTO urim_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Atom melnum wekg pa kaino la oklala naki Maur Wailen kaino yalming a Maur Wailen pa. Melnum ur pa melnum a arpmen yangkipm yiprokgen a Moses, a ur pa melnum a atn eng awi marpmel tu. ");
INSERT INTO urim_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Melnum a arpmen yangkipm yiprokgen a Moses pa kai itna atom, kil oklala naki Maur Wailen ak nikgwalpm pa la, 'Maur Wailen, kupm alkeitn wor, eng ntei, kupm ake melnum a ak ikgwam kweikwei, a antokg kweikwei a paipm, a angkli arkul kolen tu tiur pa. Wa kupm alkeitn wor eng kupm ti ake wa melnum kolen melnum a awi marpmel tu ingkai itna pa. ");
INSERT INTO urim_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Akangklei wang wekg a wang wampwomis wampwompwekg pa kupm kalpis okipma eng uk wang kitn, a kweikwei wrongkwail a kupm awi pa, kupm uk tiwel wampwam kai kitn.' ");
INSERT INTO urim_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pake melnum a awi marpmel tu pa, kil itna watinet ketnketn omtompok ikgkinar kanokg pa, atom kil wam karkur nol alkil pa a kil la, 'Woi, Maur Wailen, kupm ti melnum a antokg paipmpaipm, ti kitn reinsopm pen!' ");
INSERT INTO urim_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tuwekg rak yaper kai wan anong alntuwekgen pa. Kupm lanakepm la, melnum a awi marpmel tu pa kil pa palng ute wor itna wulmpa a Maur Wailen pake, a melnum a arpmen yangkipm yiprokgen a Moses pa kalpis. Eng ntei, melnum a ngkat nang a kil alkil pa, ikga Maur Wailen kil rku nang a kil pa kinar kanokg. A melnum a kil arku nang a kil alkil pa, ikga Maur Wailen kil ngkit nang a kil pa iye kaino kwa.” ");
INSERT INTO urim_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Atom tu tiur pa tu aye warim waseksek alntu pa kai la mpa Sisas kil elng wam pa elewen. Tu watnom alkil pa tu ari pa, atom tu aklewen. ");
INSERT INTO urim_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ari Sisas akwe tu warim pa kulntel atom kil la, “Kipm elng tu warim pa kulntopm o! Ampur kipm angkengken. Maur Wailen am itna wailen ikgalen nol nikgwalpm a tu melnum a kolen tu warim yekyek tike. ");
INSERT INTO urim_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ti kipm itning! Mla ur a ake elng Maur Wailen pa itna wailen ikgalen nol nikgwalpm akilen pa kol tu warim pa, kil ake melnum wor a Maur Wailen pa.” ");
INSERT INTO urim_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Melnum wailen ur pa asen Sisas pa la, “Melnum wor a aroaro wonel tu, mpa kupm ntokg kolai eng mpa kupm uwi yaprekg watin eng rpmi wor yongkyong pa?” ");
INSERT INTO urim_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ari wa Sisas lanakel la, “Kitn la kupm ti melnum wor kolai? Ake melnum ur wor kol Maur Wailen kil alkil ai. ");
INSERT INTO urim_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ti kitn ariwe yangkipm titnongket a Maur Wailen pa la kolkil la, 'Kitn mpa orngwatneikgen mansan, ampur kitn angkli arkul kin ur, ampur kitn alm melnum amo, ampur kitn ak ikgwam, ampur kitn kansil lakati melnum ur.'” ");
INSERT INTO urim_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ari wa melnum pa wa akalmpe la, “Ti yangkipm titnongket pa kupm am pikekg katnun ak wang a kupm a warimpen ai kul pake.” ");
INSERT INTO urim_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sisas kil atning pa atom kil la, “Kolpa kupm atning kitn ak wor pake, wa a kol kweiur wris kil: kitn ik kweikwei wrongkwail a kitn pa ik uwi marpm atom mpreing uk tu melnum a rpma tukwok pa, eng ikga kitn wa rpmi ntiwe kaino anong wor ai, a wa kitn kul kutnuntopm!” ");
INSERT INTO urim_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kil atning kolpa pa, kil ipma kalkut paipm, eng ntei, kil pa antiwe kweikwei watipmen paipm ai. ");
INSERT INTO urim_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Sisas kil ari pa atom kil la, “Melnum a antiwe kweikwei watipmen pa, wonet eng kil elng Maur Wailen kawor itna wailen ikgalen nol nikgwalpm akilen pa. ");
INSERT INTO urim_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kol ling pa la or tawong a ikyom a ak angkut apm pa kawor pa, ake aken kwap kol melnum a antiwe kweikwei watipmen la elng Maur Wailen pa kawor itni wailen ikglen nol nikgwalpm akilen pa, pa aken kwap paipm.” ");
INSERT INTO urim_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tu a atning a kil la kolpa pa, tu asentel la, “Woi, ti mla a i antiwe mpa Maur Wailen ik uwiyel iye kai wor pa?” ");
INSERT INTO urim_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ari wa Sisas akalmpenten la, “Kuina ur melnum ake antiwe antokg pa, Maur Wailen antiwe antokg.” ");
INSERT INTO urim_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ari Pita akalmpentel la, “Ti men ti ntei? Men atnuurng wan anong kweikwei almenen itna wai, a men am kul katnun kitn tike.” ");
INSERT INTO urim_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Atom wa Sisas lanaken la, “Kupm lanakepm aklale wrisen la kol melnum ur kil elng Maur Wailen itni wailen ikglen nol nikgwalpm akilen atom kil utnuurng watnom alkil aki mansan a wusok wusok a wail wail alkil a wan anong alkil pa ti, ");
INSERT INTO urim_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ikga Maur Wailen kil lkel melnum a kweikwei pa wailet paipm ikilmpentel ngko angen, ik wang ti, wa ikga ik wang kutnukg pa kil ikga rpmi wor yongkyong kaino anong wor.” ");
INSERT INTO urim_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Atom Sisas kil awi tu watnom wampwam yikakwekg alkil a kil aroaro wonel pa aye kai itna kai laikge ur pa atom kil lanaken la, “Atom kipm itning! Mentepm kai eng ikga kaino Serusalem pake. Kuina ur a pikekg tu melnum okwripm nira la Warim Kipman a Melnum pa, pa ikga palng iklale. ");
INSERT INTO urim_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ikg a tu uk kil kai wam a tu melnum a ake Suta, atom ikga tu ik nokgelel inelel melkg, a ungkwa wlikgelel. ");
INSERT INTO urim_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Wa ikga tu ik ampei ntrawel a orel imo rmpi wang wraur pa kai plalng pa, wa kil wa wrekg.” ");
INSERT INTO urim_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ari tu watnom alkil pa tu ake wa ariwe yangkipm pa. Yangkipm yiprokgen pa itna ampen eng ake mpa tu riwe kuina ur a kil la pa. ");
INSERT INTO urim_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sisas nar wreren Seriko pa, kil ari melnum wulmpa tilmpisen ur pa rpma ya yamping pa akwen tu eng marpm pa rpma. ");
INSERT INTO urim_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kil atning wrong a oklala nurkgatne wli kul kai, atom kil asen la, “Kuina ti?” ");
INSERT INTO urim_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ari wa tu lanakel la, “Men katnun Sisas, melnum a Nasaret pake. Ti tatu ti!” ");
INSERT INTO urim_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Atom kil kirkar akwe la, “Sisas! Yipetatnong a Tepit! Kitn reinsopm pen!” ");
INSERT INTO urim_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ari tu melnum a ep pa kilkampel a aklewel la kil tatar rpmi. Ari wa kil akwe yikakatnen paipm ai la, “Yipetatnong a Tepit! Kitn reinsopm pen!” ");
INSERT INTO urim_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Atom Sisas kil kai itna a lanaki tu la wampirpmewel iye kul. Atom tu wamparpmewel aye kul wrerentel atom Sisas asentel la, ");
INSERT INTO urim_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Kitn la kupm ntokgteitn na?” Ari wa kil akalmpe la, “Wailen, kupm la kitn ntokg wulmpa a kupm a tilmpis ti wor ri kweikwei.” ");
INSERT INTO urim_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Atom Sisas lanakel la, “Wulmpa kitn pa kitnangku ri kweikwei o! Kitn ukipma titnongket kolpa atom, wulmpa kitn am palng wor ise.” ");
INSERT INTO urim_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kil la kolpa, wulmpa kil pa wor penterng kolti, kil wa ari kweikwei pa, atom kil ngkat nang a Maur Wailen pa katnun Sisas pa kolpa kai. Tu wrongkwail tu ari pa, tu ngkat nang a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Sisas kil kai palng kai anong Seriko pa kil angkom or anong pa kai. ");
INSERT INTO urim_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Melnum ur a itna ep eng tu melnum a awi marpmel tu pa rpma kai anong pa, nang a kil pa Sakius, kil pa antiwe kweikwei watipmen. ");
INSERT INTO urim_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kil pa melnum tukwok kolpa atom, kil ntan ampen nalulng akor kai pa kai pa la mpa kil ri Sisas pa ari kalpis, tu wrongkwailet paipm ak ampri kolpa atom kil ake antiwe a ariwel. ");
INSERT INTO urim_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Atom kil pirng ep kai nowen yo kampuk mingen ur a itna ya yamping pa la mpa eli iri Sisas a angkom a ya pa kul pa. ");
INSERT INTO urim_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Atom Sisas angkom or ya pa kul pa, kil ikg kaino ari Sakius a ela kaino yo kwa pa, atom kil akwe la, “Sakius, itatu nar o! Kupm mpa ntiweitn rpmi kai wan akitnen ik wang am tike.” ");
INSERT INTO urim_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kil atning kolpa, a kil pa atopen paipm kolti, kil raras atatu nar kanokg ti awi Sisas pa am aye kai wan alkil ise. ");
INSERT INTO urim_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tu wrongkwailet pa tu ari pa, atom tu ipma paipm atom tu la, “Melnum pa wa kil kai kawor wan a melnum a antokg paipm a kolpa eng ntei!” ");
INSERT INTO urim_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tu kawor rka wan pa Sakius kil wrekg lanaki Wailen pa la, “Wailen, kitn itning! Mpa kupm wako kweikwei wrongkwail akupmen ti, atom mpreing wompel pa uk tu melnum a rpma tukwok. A kol pikekg kupm kansil awi marpmel tu pa klangkil marpm a tu la mpa kupm uwi pa, pa mpa kupm ikilmpenten nti wikgwikg.” ");
INSERT INTO urim_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Atom Sisas lanakel la, “Tu a rka wan ti pa, Maur Wailen am weti awiyen eng alkilen ise. Ti melnum ti pa, am yaru marpmeng a Apraam pa yat pake. ");
INSERT INTO urim_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ti Warim Kipman a Melnum am nar eng akor melnum a am pake, atom awiyen eng alkilen.” ");
INSERT INTO urim_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tu atning yangkipm a Sisas la itna pa, atom tu akwonalmpen watipmen la kil mpa kai kaino palng Serusalem pa pipa, Maur Wailen kil mpa palng ngko wunong itni wailen ikgilen kweikwei wrongkwail kai pa ur pake. Eng ntei, tu anti Sisas pa am kai wreren Serusalem pa ise. Kolpa atom kil wa lanaken yangkipm kla ur pa la ik lok nol nikgwalpm a tu akwonalmpen watipmen pa kai wris. ");
INSERT INTO urim_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Atom kil la kolpa la, “Melnum wailen ur pa kil la kai anong kanokg ur a ela kai watin ai eng la melnum tukgunakg a itna ep pa ngkitel kolen melnum tukgunakg, plalng pa, ikga wa kil wa yaper wli atom ikglen anong kanokg alkilen ti. ");
INSERT INTO urim_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Atom kil akwe tu melnum wampwam akwapel alkil pa wli, atom kil alken marpm wail wampwam aknirake tu pa atom kil lanaken la, 'Kipm ik ik kwap ur eng ik uwi marpm warim pa, kolpa kaingkai wa kupm wa yaper wli.' Kil lanaken kolpa plalng pa, kil am wrekg kai ise. ");
INSERT INTO urim_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ari tu anong wris alkil pa tu karkentel, atom tu ukwa melnum yangkipm kuin ur pa kai katnuntel eng mpa laniki tu la, 'Men ti ake wasrongen la mpa kil pa itni tukgunakg eng men pa.' ");
INSERT INTO urim_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Melnum wailen pa palng melnum tukgunakg plalng pa, wa kil yaper wli anong. Kolti kil akwen tu melnum akwapel alkil a pikekg kil alken marpm la tu ik ik kwap pa, la tu iye marpm a pikekg tu ak ak kwap pa atom ak awi marpm warim pa iye wli. ");
INSERT INTO urim_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Atom melnum ur pa ep kul la, 'Wailen, marpm wail wris a pikekg kitn alkopm pa, kupm ak ak kwap, atom wa kupm akawi marpm wail wampwam aken.' ");
INSERT INTO urim_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Atom wa kil la, 'Wor wrisen, kitn pa melnum akwapel wor! Kol pikekg kitn nungkulkg wor ikgalen kweikwei waseksek pa ariworwor, ti mpa kupm elng kitn itni wailen ikglen anong wampwam.' ");
INSERT INTO urim_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wa melnum ur wa wli wa la, 'Wailen, marpm wail wekg a pikekg kitn alkopm pa, kupm ak ak kwap atom kupm akawi marpm wekg aken.' ");
INSERT INTO urim_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ari wa kil lanakel la, 'Ikga kupm elng kitn itni wailen ikglen anong wampwomis.' ");
INSERT INTO urim_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Wa ur pa kul lanakel la, 'Wailen, kitn ri, marpm kitn ti! Pikekg kupm aye kai ak apm yaponteitn lamteitn ariworwor rmpa. ");
INSERT INTO urim_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kol kitn pa melnum kalnten a awi num angklin kweikwei a melnum manet ai, a kai akor kweikwei kai wring a melnum manet, kolpa atom kupm ngkark.' ");
INSERT INTO urim_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ari kil lanakel la, 'Kitn pa melnum akwapel lpmaaken paipm! Ti mpa kupm ikilmpe kwap paipm a pikekg kitn ak kolpa kitila ok a kitn alkitn la ti la kitn pikekg akwap paipm pa. Kol kitn riwe la kupm ti melnum paipm a awi num angklin kweikwei a melnum manet ai, a kupm melnum a wa kai akor kweikwei kai wring a kupm alkupm ti ake alin pa. ");
INSERT INTO urim_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kol a kitn elng marpm pa rpmi wan marpm pa, eng mpa ik uwintopm marpm warim pa, eng mpa kupm kul pa, mpa kupm uwi numpokgen marpm man pa.' ");
INSERT INTO urim_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Atom kil lanaki tu wrong a itna pa la, 'Kipm uwi marpm pa tukwleikgentel atom, kipm iye kai uk melnum a pikekg kil awi marpm wail wampwam pa.' ");
INSERT INTO urim_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ari wa tu la, 'Wailen, kil am pikekg awi marpm wail wampwam ise!' ");
INSERT INTO urim_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ari wa kil akalmpenten la, 'Melnum a kil antiwe kweikwei pa, mpa wa Maur Wailen kil wa lkel ngko angen. Pake melnum ur kil rpma tukwok pa, mpa Maur Wailen kil ungkwan kweiur waiketn a kil antiwe pa kai tukwleikgentel. ");
INSERT INTO urim_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Wa tu melnum a pikekg awi wrongmanto lantopm la ampake kupm ti itni wailen ikglenten pa, uwiyen iye wli, atom ilmpen imo itni wulmpa akupmen ti!'” ");
INSERT INTO urim_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Sisas kil la kolpa plalng pa, kil angkom kai kaino la kawor anong wail Serusalem. ");
INSERT INTO urim_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kil kaino wreren anong Petpake a anong Petani, a ela krong a tu namput la Olip pa, a kai kaino wreren Serusalem pa. Kil ukwa watnom wekg alkil pa ep. ");
INSERT INTO urim_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Atom kil lanaken la, “Kol kipmekg ep kaino anong ingkaino ela kaino ai pa, mpa kipmekg ri nimpa war nepm kuinen warimpen ur a ake pikekg ur arpme ep pa, tu angkuten itna. Pipa, kipmekg inelkgen atom iye nar. ");
INSERT INTO urim_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kol melnum ur isentepm la, 'Kipmekg la inelkgen eng ik ntokg na?' Pipa kipmekg lanikel la, 'Melnum Wailen kil la ik ik kwap ur alkil.'” ");
INSERT INTO urim_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Atom tuwekg kaino ari kweikwei pa am itna katila ok a wet Sisas la pake. ");
INSERT INTO urim_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Atom tuwekg anelkgen ari, melnum yan a nimpa nepm kuinen plampiwen pa asenten la, “Kipmekg la inelkgen eng ik ntokg na?” ");
INSERT INTO urim_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ari tuwekg akalmpe la, “Melnum Wailen kil la ik ik kwap ur alkil.” ");
INSERT INTO urim_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kolti, tuwekg aye nar eng Sisas. Atom tuwekg awi apm alntuwekgen ti ukwulampen plalng pipa, tuwekg angklin Sisas pa kaino arpme. ");
INSERT INTO urim_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Atom Sisas kil arpme nimpa nepm kuinen plampiwen pa kaino pa, tu wrong kin kipman wailet apa, anel awi apm alntu pa ukwulampen ya pa. ");
INSERT INTO urim_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Atom wang a kil ep ep kolpa kaino palng ya a angkaino wrik nangen Olip pa kulnar kinar eng kaino Serusalem pa, tu wrongkwail a katnuntel pa anel atop arkol ngkat nang a Maur Wailen yikakatnen eng kweikwei titnongket wail wail a pikekg tu ari a kil antokg pa. ");
INSERT INTO urim_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Tu atop arkol la kolkil la, “Maur Wailen kil ukwa melnum tukgunakg ti nar, ti mentepm itopentel. Kil alko ipma wor pa itna eng mentepm, ti mentepm ngkit nang a Maur Wailen a itna wailen ikgalen kweikwei wrongkwail. Maur Wailen, kitn plan ipma wor ngklin melnum kil, kil melnum tukgunakg a kitn ukwa nar ti. Ti mentepm ngkit nang a Maur Wailen a rpma kaino kwa wai, kil ipma kukula wor eng mentepm melnum ti.” ");
INSERT INTO urim_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ari tu melnum a arpmen yangkipm yiprokgen a Moses tiur pa lanaki Sisas pa la, “Melnum a kaling plan tu, kol a kitn laniki tu watnom alkitn ti eng tu tatar itni.” ");
INSERT INTO urim_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ari wa Sisas lanaken la, “Kol tu pa tatar itni pa, kol tu wes a rpma tatu ti pa mpa wa ngkit nang a Maur Wailen kol tu a atop itna tike.” ");
INSERT INTO urim_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sisas kil kaino wreren ari anong wail Serusalem pa, kil akg arein paipm, ");
INSERT INTO urim_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","a ak ok namputen la, “Arein kitn Serusalem, ak wang ti kitn am kol am riwe la kuina ur a ntokg kitn uwi ipma kupuket a rpma meen wor pa ise, ari wa kitn wa uk yirokg, kolpa ti am kai lamteitn ise. ");
INSERT INTO urim_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Wang paipm ur ikga palngteitn pa, tu wrongmanto ikga wli kipringenteitn, iken yipmingki, a mprinteitn ya yela. ");
INSERT INTO urim_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","A ikga tu tikale yipmingki pa kawor tikale wan anong pa ilm oren tu wrong kin kipman pa kai plalng. Ikgake wes ur a kipm ak ale wan pa ur lile tita itni pa, kalpis, ikga tu tikale ngkli plalng. Eng ntei, wang wor akitnen pikekg Maur Wailen nar la ngklinseitn pa, kitn karken uk yirokg.” ");
INSERT INTO urim_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Atom Sisas kil kai kawor yipmingki wunen a kapringen yalming a Maur Wailen pa, atom kil ungkwan tu melnum a elng kweikwei alntu rpma eng ak awi marpm pa. ");
INSERT INTO urim_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Atom kil lanaken la, “Ela wrkapm a Maur Wailen pa la kolkil, 'Wan akupmen pa itna eng kipm kawor oklala naki naki kupm.' Maur Wailen pa am la kolpake, ari wa kipm elng wan pa itna la tu melnum ikgwampet pa or am arke tike.” ");
INSERT INTO urim_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Atom am Sisas kil kawor yipmingki wunen a yalming pa kaling plan tu akangklei wang kolpa kai pake. Ari tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen pa, wa tu melnum a aroaro wonel tu yangkipm a Moses pa, wa tu melnum wailen wailen a ikgalen men wrong kin kipman pa tu akor la ilmpel imo. ");
INSERT INTO urim_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pake tu wrong kin kipman pa wasrongen paipm, la tu am a rki pa rki pake, itning yangkipm a kil la pake, kolpa atom tu la mpa ikor ya or kolai, eng mpa tu ilm kil pa imo pa. ");
INSERT INTO urim_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wang wris ur pa, Sisas kil angkli yangkipm wor a Maur Wailen, a kaling plan tu itna kawor yipmingki wunen a yalming a Maur Wailen pa itna, ari tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen a tu melnum a aroaro wonel tu yangkipm a Moses, a tu melnum wail wail pa anel wli itna. ");
INSERT INTO urim_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Atom tu lanakel la, “Kitn pa kitn melnum titnongket pake! Ti kitn laniko ri la mla alkeitn ong talpen pa, atom kitn ak ak kwap pa?” ");
INSERT INTO urim_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ari wa Sisas akalmpenten la, “Ti itni eng kupm isentepm akasen ur kil: ti wa kipm lanikopm ri la, ");
INSERT INTO urim_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ti ong talpen pikekg Son a kaluk tu pa, kil awi kai Maur Wailen pa aki, kai tu melnum ti?” ");
INSERT INTO urim_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tu atning a kil asen kolpa, atom tu takwem rka ak tu alntu pa, atom tu akor la la, “Mpa mentepm la kolai? Ti kol mentepm la, pa am Maur Wailen pa ak ong pa atnewel pake, ti mpa wa kil wa la kolkil la, 'Kolpa ti pikekg kol a kipm itning kutnun yangkipm a pikekg kil la pa.' ");
INSERT INTO urim_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wa kol wa mentepm lala kolkil la, 'Pa am tu melnum ti ak ong atnewel pake', ti mpa wa tu wrongkwail ti ik wes ti oro imo, eng ntei, tu pa ukipma titnongket la, Son pa kil melnum okwripm a Maur Wailen.” ");
INSERT INTO urim_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tu akor la kai ari mpa wa tu ikilmpentel ik yangkipm a i, eng ntei, ya wrongkwail am kil ampri plalng ise. Atom tu kai kansilel kolti la, “Men akwekgel la mla a i ak ong atnewel.” ");
INSERT INTO urim_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Atom wa Sisas lanaken la, “Am kolpa yat pake, kupm ake mpa wa lanikepm la, mla a i ak ong atnewopm, atom kupm ak ak kwap kil.” ");
INSERT INTO urim_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Atom Sisas la yangkipm kla ur pa naki tu wrong kin kipman pa la, “Melnum ur pa, kil antokg wring ampei wain ur, atom kil awi melnum tiur ai wli ikgalen akentel wring pa kolpa itna, a kil wrekg kai anong ya watinet ur ai rpma wang watinet. ");
INSERT INTO urim_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kil rpma a a, ampei ok kil pa am angko ise. Atom kil ukwa tu melnum akwapel ur alkil pa kai, la mpa tu lkel wain ok alkilen a aknamputel pa iyentel kai. Ari tu melnum a ikgalen wring pa orel kolti, ungkwantel kil angkompwam kolti yaper kai. ");
INSERT INTO urim_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kolpa atom wa melnum yan a wring pa, wa ukwa melnum akwapel ur pa wa kai, ari am wa tu orel, antokgtel paipm kolti alkel numpaipm kolti, wa ukwawel wampwampwris wa yaper kai. ");
INSERT INTO urim_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kolpa atom wa kil ukwa ur pa wa kai, ari am wa tu orel yongwalmpopm paipm kolti, ngkatel angkli kawor en ai. ");
INSERT INTO urim_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Atom melnum yan yiprokg a wring pa la, 'Mpa kupm ntokg kolai? Ti pati mpa kupm ukwa warim kipman wris nangket alkupm a kupm plan ipma wor wasrongen ti kai pati, mpa tu itningkel ur pake.' Kil akwonalmpen kolpa plalng pa, kil ukwa warim kipman alkil pa kai. ");
INSERT INTO urim_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ari tu melnum a ikgalen wring pa tu itna ari a kil kul pa, atom anel naki tita la, 'Pa warim kipman ikga uwi num ngklin kweikwei a yan alkil am pake. Ti tepm ilmpel imo wo, eng ikga tepm uwi kweikwei wrongkwail akilen pa!' ");
INSERT INTO urim_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Atom tu kai arkulel ngkat angkliwel kawor wring en ai kolti, tu orel amo.” Sisas la yangkipm kla pa kai plalng pa kil asen tu a atning rka pa la, “Atom melnum yan a wring pa mpa ntokg kolai eng tu melnum a ikgalen wring pa? ");
INSERT INTO urim_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ikga kil wli ilm tu melnum pa imo, a uk wring ampei wain pa kai tu ur ai.” Tu wrongkwail atning pa tu la, “Kolpa ikga kalpis.” ");
INSERT INTO urim_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Atom Sisas ikatnenten a kil la, “Ti antokg kolai yangkipm kil a ela kai wrkapm a Maur Wailen pa wa la kolkil la, 'Ong ur a tu melnum a ale wan pa tu ari la la paipm pa, tu ungkwan pa, am ong kimpowen wor wrisen a akale wan am pake?' ");
INSERT INTO urim_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Atom melnum ur a wutat angko ela ong kimpowen wor kil pa, pa mpa ngket numpwam alkil pa kai paipm. Ari kol ong pa or kai or melnum ur pa, kil pa mpa kai ningnapis waiketnketn kolti.” ");
INSERT INTO urim_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Atom tu melnum a aroaro wonel tu yangkipm a Moses, a tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen pa tu atning yangkipm kla a wuten Sisas la kolpa ari, almpen ipma la yangkipm pa am akla tu pake, kolpa atom tu la rkul yipowel ik wang ketn pa, pake tu ari tu wrong wailet a itna pa, atom tu ngkark eng arkulel. ");
INSERT INTO urim_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Atom tu melnum a aroaro wonel tu yangkipm a Moses, a tu melnum tukgunakgen a tu ipma krakgen pa tu ukwa melnum tiur pa kai ikgla Sisas pa a antiwel atn akipaarel. A tu la alm ipmawel Sisas pa la mpa kil la yangkipm ur kai ar pipa, mpa tu kai laniki tu melnum mringman pa, atom tu uwiyel yekai itni yangkipm kai tu melnum tukgunakg a tu Rom pa? ");
INSERT INTO urim_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Atom tu aknukwar Sisas pa la, “Melnum a kaling plan tu, men ariwe la kuina ur a kitn pa kaling plan pa ute pake. Men ariwe la, kitn ake ari melnum wor aki paipm pa, kitn laron yangkipm aklale a Maur Wailen ti ak lanaken kolti. ");
INSERT INTO urim_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ti mentepm uk marpm Kaisarus, melnum tukgunakg a Rom a awi marpmel mentepm pa, ti kitn ikwonilmpen ri la pa wor aki pa paipm?” ");
INSERT INTO urim_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pake Sisas pa ariwe nikgwalpm ampen paipm a tu ak kol pa, atom kil lanaken la, ");
INSERT INTO urim_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ti kipm plantopm marpm pa ri, la ikgokg a nang a ela marpm pa a mla?” Ari tu akalmpentel la, “Am a Kaisarus, melnum tukgunakg a Rom pake.” ");
INSERT INTO urim_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Atom Sisas akalmpe la, “Kol melnum tukgunakg a Rom kil awi marpmel mentepm ti pa, pa marpm alkilen, mpa mentepm uk kai kil pake. La kweikwei a Maur Wailen pa, kipm mpa uk kai Maur Wailen pake.” ");
INSERT INTO urim_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tu atning a kil akalmpenten kolpa, atom tu wrekg paipm yapo ok alntu pa tatar itna kolti. Sisas ake la yangkipm ur kai ar kai wulmpa a tu wrong kin kipman pa, eng mpa tu a alm ipmawel kil pa laniki mring man pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Atom tu Satyusi tiur pa, tu kul ari Sisas. Tu Satyusi pa tu melnum a akwonalmpen la, melnum a amo pa ake antiwe ikga wrekg. ");
INSERT INTO urim_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Atom tu aknukwarel la, “Melnum a kaling plan tu, pikekg Moses nako yangkipm titnongket kol kil la, kol melnum ur kil awi kin ur, ari ake wa kil angket warim ur, kil wa amo atnurng kin pa, mpa wa paipmen alkil pa wa uwi wampuk iye wa ngket warim ur eng ngklin wrik a wailen alkil pa. ");
INSERT INTO urim_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kol wusokwail wampwomis wampwompwekg ur pa rpma, atom wailen pa awi kin pa aye, ari ake kil angket warim ur kil amo atnuurng. ");
INSERT INTO urim_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Atom wa ur a wa kai arkekg kil pa wa awi wampuk. ");
INSERT INTO urim_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ari kalpis, am wa kil amo atnuurng wa kai, a ake wa kil angket warim ur. Tu am kolpa kimeket pake, tu awi kin pa aye ari ake ur angket warim ur, am tu amo atnuurngkel kolpake. ");
INSERT INTO urim_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Atom wa kin pa rpma kolpa kaingkai, kil wa amo kai katnunten. ");
INSERT INTO urim_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kitn pa la tu melnum a amo kaingkai pa la ikga wrekg wrekg pake? Ti tu wrekg wrekg pa, pa kin pa a pikekg awi kipman wampwomis wampwompwekg pa, pa ikga kil rpmi eng kipman mla?” ");
INSERT INTO urim_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ari Sisas akalmpe la, “Tu kin kipman ak wang ti pa tu awi tita pake. ");
INSERT INTO urim_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ari tu kin a kipman a Maur Wailen awi wor lawen pa, tu ikga wrekg ik wang kutnukg pa, tu akentiwe ikga uwi tita, kalpis. ");
INSERT INTO urim_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Atnen a tu ikgake imo nti ur, eng tu pa kol tu maur akwapel a Maur Wailen. Ti tu pikekg amo kaingkai atom wa wrekg wrekg pa, tu pa warim a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Wa Moses planto la tu a pikekg amo kaingkai pa, tu ake amo kaingkai plalng, kalpis. Pa tu amo kaingkai ti rka pa. Kipm ariwe yangkipm a pikekg Moses la yo wasek a pikekg wakg naruk atne pake, ake wakg al. Atom kil akwe la, 'Wailen, kitn Maur Wailen a Apraam, kitn Maur Wailen a Aisak, a Sekop.' ");
INSERT INTO urim_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ti pa planto la Maur Wailen pa kil Maur Wailen a tu melnum a amo kaingkai rpma pa yat. Eng ntei, Maur Wailen ari tu a amo kaingkai pa, wa mentepm a rka ti pa, la mentepm rka yatenen.” ");
INSERT INTO urim_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Atom tu melnum a aroaro wonel tu yangkipm a Moses pa la, “Melnum a kaling plan tu! Pa kitn akalmpe wor pa.” ");
INSERT INTO urim_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Atom tu ngkark kolpa atom, ake wa tu asentel ur. ");
INSERT INTO urim_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Atom Sisas lanaki tu melnum a arpmen yangkipm yiprokgen a Moses pa la, “Kipm akwonalmpen kolai, la Krais, melnum a Maur Wailen ukwa nar la ik uwi kipm wrong kin kipman pa, la kil pa walpopm ur a angket ale a Tepit ti kul tike? ");
INSERT INTO urim_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kol pikekg Tepit kil alkil la ela kai wrkapm Nangnang pa la, 'Maur Wailen kil lanaki Krais Wailen akupm pa kolkil la, “Kitn rpmi wam wi akupmen ti, ");
INSERT INTO urim_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","rpmi i, kupm or tu wrongmanto akitnen pa yikak rkganti mengkel itni orngwatneikgen kitn pa.”' ");
INSERT INTO urim_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tepit akwe kil pa la Wailen, ti wa antokg kolai atom wa tu akwe kil pa la walpopm a angket ale angkai Tepit pa kul pake?” ");
INSERT INTO urim_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tu ak wail atning rka pa Sisas lanaki tu watnom a kil aroaro wonel pa la, ");
INSERT INTO urim_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kipm rki riwe eng tu melnum a aroaro wonel tu yangkipm a Moses pa. Eng ntei, tu pa nowe apm wail wail ti akalm nepmel, tu alntu ti la mpa tu riwen la tu melnum wailen wailen, a la tu wrongkwail yangkipmenten itni tutu akapm. Wa tu kawor wan a atning atning yangkipm a Maur Wailen atnewe pa, tu wasrongen la uwi wrik wor wor pa rpmi pake. Wa ak wang a antokg okipma wail al pa, tu pa la tu ukwewen eng tu pa ngkiten ep pake. ");
INSERT INTO urim_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tu kansil awi kweikwei wrongkwail a tu kin karpikg a kipman amo atnuurng pa, a kansil ak ipaar oklala naki Maur Wailen pa itna watin watin paipm, eng mpa tu riwen la tu melnum akwapel wor a Maur Wailen. Kolpa ti ikga ik wang a tu itni yangkipm pa, tu ikga uwi kalkuten wail manten paipm ikilmpe paipm a tu antokg pa.” ");
INSERT INTO urim_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Wang wris ur pa Sisas kil itna yipmingki wunen a yalming a Maur Wailen pa itna ari tu melnum a antiwe kweikwei pa tu aye kweikwei pa kai alupm kinar yotimpal eng uk Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Atom kil ari kin karpikg yek ur a rpma tukwok pa kil uk marpm watet ok wekg pa. ");
INSERT INTO urim_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Atom wa kil la, “Kupm lanakepm aklale wrisen la, kin karpikg yek a rpma tukwok kil pa, kil uk wail manten paipm angen tu wrongkwail. ");
INSERT INTO urim_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kol tu wrongkwail a antiwe kweikwei pa tu uk pake, ake tu uk plalng, kweikwei wailet tiur alntu pa rmpa. Pake kin karpikg yek a rpma tukwok pa kil uk kimeket kolti kuina ur wasek akilen pa.” ");
INSERT INTO urim_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Atom tu tiur pa, tu rka akor la yalming a Maur Wailen pa la wan pa ari wor tuwa, tu ale ak wes arimomo, wa tu nakure ak kweikwei wor wor a tu uk Maur Wailen pa. Ari Sisas lanaken la, ");
INSERT INTO urim_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","”Kweikwei wrongkwail a kipm ari ti pa, wang ur ikga palng pa, ikgake wes ur a tu ak ale wan ti pa ur lile tita itni wrik alkil pa, kalpis, ikga tu tikale ngkli kimeket.” ");
INSERT INTO urim_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Atom tu wrong kin kipman asen Sisas la, “Melnum a kaling plan tu, kweikwei pa ikga wangkarke palng? Aki, ikga kuina a i palng eng ik lawen wang pa palng pa?” ");
INSERT INTO urim_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ari wa Sisas akalmpenten la, “Kipm rki riwe, tu melnum kansil ikga wli kinsilepm eng lokepm iye kai ar pa. Eng ntei, tu watipmen ikga wli la kolkil la, 'Am kupm melnum a kipm nungkwangentopm ti am tike!' A wa, 'Wang a kipm lala pa, am palng tike!' Pake ampur kipm anti katnun tu pa. ");
INSERT INTO urim_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kol kipm itning la wrong rapon aki, tu melnum palng melkget paipm pa, ampur kipm ngkark, pa kweikwei kolpa ikgam palng pake, wang umpuwen pa a pa.” ");
INSERT INTO urim_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Atom wa kil wa la, “Tu anong kanokg ur ikga rapon nti tu anong kanokg ur, a wrong a mring tukgunakg ompur ikga rapon nti wrong a mring tukgunakg ompur. ");
INSERT INTO urim_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ti kol yelm wail wail ikga no, wang nikg, a numpet wail wail ikga palng tutu anong kanokg tiur, a ikga kipm ri kweikwei tiur a palng kaino kitnong ti, a wa kweikwei paipm paipm tiur a ikga ik ntokg kipm eng kipm ngkirk pa, ikga palng. ");
INSERT INTO urim_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pake ep pa ikga tu rkul yipowepm a ntokgtepm paipm, a ikga tu iyewepm kai itni yangkipm kawor wan a atning atning yangkipm a Maur Wailen atnewe pa, atom iyewepm kawor rpmi wan tipmning. A ikga tu uwiyepm iye kai itni wulmpa a tu melnum tukgunakg a tu mring man wail wail kolpa atnen a kipm ukipma kupm ti. ");
INSERT INTO urim_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ik wang pa, ikga wang wor akipm eng laron kipm alkipm la kipm ukipma kupm. ");
INSERT INTO urim_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ti kipm lupmen yangkipm a kupm lanakepm kil: ampur kipm akwonalmpen watipmen la ikga kipm la yangkipm kolai ik wang a kipm itni yangkipm pa. ");
INSERT INTO urim_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Eng ntei, kupm ikga ngklinsepm oklala wor wor eng kipm oklala ik wang pa. Tu wrong manto akipmen pa ikga yangkipm kalpisen a ikga ikilmpe oklala akipmen pa. ");
INSERT INTO urim_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ti kipm ikga tu mansan, a tu wail wail wusok wusok, a tu walmpopm wris, a tu yiprokgen alkipm pa uwiyepm iye kai itni yangkipm, a tiur akipmen pa ikga tu orepm imo. ");
INSERT INTO urim_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tu wrongkwail ikga lkepm ipma paipm atnen a kipm ukipma kupm ti. ");
INSERT INTO urim_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pake kol tukgunakg walk wris ur akipmen pa, ikgake unur. ");
INSERT INTO urim_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ti kipm itni titnongket, pa ikga kipm rpmi wor yongkyong.” ");
INSERT INTO urim_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Wa Sisas kil wa la kolkil la, “Ti kol kipm ri tu melnum a almpwrong pa wli kipringen Serusalem pa, pa kipm riwe la, Serusalem wreren eng a kai paipm pake. ");
INSERT INTO urim_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Wang pa palng pa, kipm melnum a Sutia ti pa, kipm ngkirk kaino am kaino tipmining ai, wa kipm a rpma Serusalem kil pa, kipm wrekg ngkirk tukuleikgen, wa kipm a rka tatu wreren anong wail ti pa, ampur kipm or kil, kipm ngkirk i pa kai o! ");
INSERT INTO urim_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Eng ntei, pa wang paipm wrisen a Maur Wailen ikga ikilmpe paipmpaipm a tu wrong kin kipman antokg pa kai kolpa katila kolen yangkipm wrongkwail a nira ela wrkapm ti. ");
INSERT INTO urim_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ti arein eng tu kin a itna, wa tu mantin a warim rka ma pa ikga ik wang pa! Kalkuten wail ikga palng itni kanokg ti, a ipma wakget a Maur Wailen itna la ikga ntokg paipm tu wrong kin kipman a Suta a talpulng yangkipm pa. ");
INSERT INTO urim_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tu tiur a rka Serusalem ti pa, pa ikga tu a ake a Suta pa wli ik kosakal ilmpen imo, a ikga tu uwiyen plalng iye kai rak yela tutu palpa ikwap orngwatneikgen tu anong kanokg wrongkwail. A wa tu alntu a ake Suta ti uwi wrik pa rki ikgilen Serusalem ti ik wasrongen alntu, kolpa kaingkai ngko wang ur a Maur Wailen la tu ikgilen kai elngen pake.” ");
INSERT INTO urim_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Wa Sisas kil wa la kolkil la, “Ik wang pa, ikga kipm ri kweikwei a palng kaino kitnong pa kai takgni ti, kainil, a kurmeim pa. A itna kanokg a ti pa, tu wrongkwail ikga itning kilko a unokg wail a ngkat tapor aner arar wli pa. Tu ikga ngkirk paipm num lantiwe warwar. ");
INSERT INTO urim_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ti tu wrong kin kipman ikga ngkirk paipm, nol kaino rki okaluk a ikga rki nungkwangen kweikwei ikga palng yela kanokg ti. A kweikwei titnongket titnongket a itna kaino kitnong pa, ikga titu weingkweing eng a nurku. Kweikwei kolpa palng pipa, ");
INSERT INTO urim_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","pa ikga tu ri Warim Kipman a Melnum pa ikga waipmunu pa ik uwiyel iye nar numpokgen titnongket, a klalen wail manten. ");
INSERT INTO urim_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ti kol wreren eng kweikwei pa eng a palng pa, pa kipm wrekg ngkit ikg pa kaino kwa pa rpmi itopen nungkwangen, eng wang a Maur Wailen la ik uwiyepm, atom ikga kipm wirng no itni kukula wor pa, am wreren tike.” ");
INSERT INTO urim_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Atom Sisas lanaken yangkipm kla ur pa la, “Ti kipm ikwonilmpen yo kampuk pa, wa yo tiur ai. ");
INSERT INTO urim_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ik wang a kipm ri ipm nur, ok pa tukgun umpen pa pati, kipm ariwe la, wang wreren eng a takgni wor a angketuwai pake. ");
INSERT INTO urim_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ti am wa kolpa yat pake, ik wang a kipm ri kweikwei kolpa la palng pa, kipm riwe la, wang wreren eng Maur Wailen eng a itni wailen ikgilen kweikwei wrongkwail pake. ");
INSERT INTO urim_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kupm lanakepm aklale wrisen la, kipm wrong kin kipman a rka ak wang ti pa kipm ikgake imo, kipm tiur ikga rki i kaingkai, kipm ri kweikwei pa palng. ");
INSERT INTO urim_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ti kitnong a kanokg pa ikga kai plalng, pake yangkipm alkupmen kil pa, ikgake kai plalng, ikgam itna kolpa kai pake.” ");
INSERT INTO urim_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Wa Sisas kil wa la, “Ti kipm rpmi wonrpme! Ampur kipm won itna okipma a, al u titno kweikwei pa, aki ampur kipm nikgwalpm kalkuten eng kweikwei a numpalk a itna kanokg ti. Kipm rpmi wonrpme, eng wang pa ikga palngtepm kolen lem a ale ep elngitna. ");
INSERT INTO urim_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ti kipm ikga wonmis kai ngkowe kolti. Wang pa ikga palng eng tu wrongkwail kin a kipman yela tungtangkem a kanokg ti. ");
INSERT INTO urim_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ti kipm rpmi wonrpme a oklala niki Maur Wailen ti ikngklei wang, eng mpa kil lkepm titnongket, eng kipm ikga ntiwe ngkom nilokgen kweikwei a ikga palngtepm pa, a eng kipm ikga ntiwe itni wrongen numpaipm kalpisen itni wulmpa a Warim Kipman a Melnum pa.” ");
INSERT INTO urim_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Akangklei wang pa, Sisas kil am kaling plan tu wrong kin kipman pa itna kawor yipmingki wunen a yalming a Maur Wailen pake. A wa akangklei nungkurikg mining wris wris pa, kil kai kaino okg okg kaino wrik nangen Olip ai, ");
INSERT INTO urim_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","atom kil nar ak kong miningket wris wris pa. Tu wrong kin kipman pa wli rka atning yangkipm a kil angkli pa, itna kawor yipmingki wunen a yalming a Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Wang aripm ur a wring wris wris pa tu Isrel angklon nok tingklak a ak mprang ap mringen ak oren pa am kul wreren tike. Wang wail pa mentepm namput la Wang wail eng tu akwonalmpen a pikekg Maur Wailen ak awi tu amentepmen aye kul takwleikgen tu Isip pa. ");
INSERT INTO urim_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pa tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen pa, nampokgen tu melnum a aroaro wonel tu yangkipm a Moses pa, tu akwonalmpen watipmen akor ya la mpa tu or Sisas pa imo or kol ya a i, eng ntei, tu ngkark eng tu wrong kin kipman ti. ");
INSERT INTO urim_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Atom Satan kil kai kawor Sutas pa, tu namput la Iskariot, pa kil melnum wris ur a tu watnom wampwam yikak wekg a Sisas aroaro wonel pa. ");
INSERT INTO urim_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Atom Sutas kil wrekg kai akor la anti tu melnum tukgunakg a tu melnum ipma krakgen pa wa tu melnum tukgunakg a tu melnum nepimpalo a ikgalen yalming a Maur Wailen pa, la ya kolai mpa kil uk Sisas pa kai wam atuwen pa. ");
INSERT INTO urim_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Atom tu melnum pa, tu atopen, eng Sutas kil kai alken ya kolpa, atom tu ipma wris la lkel marpm. ");
INSERT INTO urim_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Sutas kil awi wor, atom kil akor ya ampen ur la mpa uk Sisas pa kai wam a tu pa, eng ampake tu wrong kin kipman pa riwe. ");
INSERT INTO urim_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Wang wail aripm ur a akangklei wring wris wris men angklon nok tingklak a ak mpim ap mringen ak oren pa am ngkaten ak wang wet tike. Atom ti wang a men alm manto walkg malkgu war ur eng rki ntokg il wor uk Maur Wailen eng ikwonilmpen a pekg Maur Wailen ak awi tu amenen aye kul takuleikgen tu Isip pa rka, ti am wang tike. ");
INSERT INTO urim_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Atom Sisas kil lanaki Pita ekg Son pa la kolkil la, “Kipmekg kai numprampentilo manto war walkg malkgu kweikwei pa rpmi, mpa men kai pa, mentepm il.” ");
INSERT INTO urim_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ari wa tuwekg asentel la, “Ti kitn wasrongen la mpa mentekg numprampen ules pa rpmi kai a i?” ");
INSERT INTO urim_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ari wa kil la, “Ti kipmekg itning! Kipmekg kai kawor anong wail pa, mpa kipmekg ri melnum ur a aye u kuntuken pa pipa, kipmekg kutnuntel kai kawor wan ur a kil kawore pa. ");
INSERT INTO urim_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Atom kipmekg isen melnum yan a wan pa la, 'Melnum a kaling plan men pa lanako, la mentekg isenteitn, la wrik mpa kil numpokgen men watnom alkil pa mpa il manto walkg malkgu war kweikwei rke pa, pa a i?' ");
INSERT INTO urim_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Atom mpa kil plantepm wan ok okkapmet ur a itna kaino walop ur ai, eng mpa kipmekg numprampentilo kweikwei pa itni pake.” ");
INSERT INTO urim_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tuwekg atning plalng pa, tuwekg wrekg kai ari kweikwei wrongkwail pa, am palng katila kolen a wuten Sisas lanaken pake, atom tuwekg numprampen kweikwei pa rpma. ");
INSERT INTO urim_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tuwekg numprampen manto walkg malkgu war kweikwei pa elngtirpma pa, pa wang a tu al okipma, atom Sisas kil anti tu wokgen alkil pa kai rpma okg arke tita la il okipma pa. ");
INSERT INTO urim_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Atom kil lanaken la, “Kupm pikekg wasrongen paipm la il okipma ti numpokgentepm wrisen plalng pipa, kupm rki kalkuten. ");
INSERT INTO urim_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ti kupm lanakepm la, kupm ikgake wa il okipma ur kol ti ntiur kai ngko wang a kweikwei pa palng iklale ik wang a Maur Wailen itni wailen ngko wunong ikglen kweikwei wrongkwail.” ");
INSERT INTO urim_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Atom Sisas kil awi kaimung pa aye itna uk wor Maur Wailen plalng pa, kil la, “Kipm uwi ti mpreing il o! ");
INSERT INTO urim_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kupm lanakepm la, kupm ikgake wa il u wain ti nti ur, kolpa kai ngko wang a Maur Wailen kil itni wailen ikglen kweikwei wrongkwail ti ngko wunong.” ");
INSERT INTO urim_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Atom wa kil awi okipma pa aye itna uk wor Maur Wailen plalng pa, kil kapor alken kolti a kil la, “Kil num akupmen a kupm alkepm la ik ngklinsepm. Ti kipm ik kolpa kai eng ikga kipm ikwonilmpen kupm ti!” ");
INSERT INTO urim_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tu al okipma pa plalng pa, kil awi kaimung pa aye itna ak katila kol a wet ep pa plalng pa, kil la, “U wain kaimungen kil pa pati, pa Maur Wailen lam kla weten nampokgen kipm. Kil walmpopm akupmen a ungkwan eng la ik ngklinsepm. ");
INSERT INTO urim_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pake ti kipm itning! Melnum a mpa uk ya kupm ti kai wam a tu wrong manto pa, am antiwo al okipma rpma tike! ");
INSERT INTO urim_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kol Warim Kipman a Melnum ti ikgam imo kolen pikekg Maur Wailen la pake. Pake woi, arein melnum a uk ya Warim Kipman a Melnum ti kai wam a tu wrong manto pa, kil ikga uwi paipm.” ");
INSERT INTO urim_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tu atning kolpa, tu asen tita la, “Mla ur amentepm ti, ikga ikwap pa?” ");
INSERT INTO urim_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tu watnom a Sisas pa alilakel tita la mla a i mpa itni wailen eng tu pa. ");
INSERT INTO urim_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ari Sisas lanaken la, “Tu melnum tukgunakg a kanokg ti pa, tu plan titnongket a tu ti itna wailen ikgalen tu wrong kin kipman alntu, wa tu melnum wail wail pa tu la tu wrong kin kipman pa riwen la tu melnum wailen wor a akwap wor eng ikgalenten. ");
INSERT INTO urim_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pake kipm pa ake mpa ntokg kolpa. Kipm mla ur la palng melnum wailen itni kuin akipmen pa, kil mpa rku kil alkil orngwatneikgen kipm ti, wa mla ur akipmen la palng melnum a itna ep ikglentepm pa, kil mpa palng melnum akwapel wor a angklin kipm ti. ");
INSERT INTO urim_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kipm ikwonilmpen: melnum a rpma la il okipma ti pa melnum wailen aki, melnum a ampreing okipma ti eng kil al ti pa melnum wailen? Melnum a kil rpma la il pa melnum wailen pake. Pake, kupm ti ake kolpa, kupm kolen melnum akwapel orngwatneikgen kipm eng angklinsepm. ");
INSERT INTO urim_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kipm pikekg antiwopm arki kaikuten ak ai kulngkul kul ti, a ake kipm atnuurngkopm. ");
INSERT INTO urim_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kolpa ti mpa kupm ngkit kipm ti itni melnum tukgunakg ikglen kweikwei wrongkwail, pikekg yan alkupm ngkat kupm ti itna melnum tukgunakg ikgalen kweikwei wrongkwail. ");
INSERT INTO urim_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ti kipm ikga ntiwopm itopen il okipma wail kaino anong wor akupmen pa, a kipm ikga rpmi wrik wor wor eng ikglen tu om wampwam yikakwekg a Isrel.” ");
INSERT INTO urim_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Sisas lanaki Saimon la, “Saimon, Saimon! Ti kitn itning! Maur Wailen uk ya Satan la ikga ningkailepm la kipm ngko kai wrisen kolen wit ok plepm a melnum kalkwin pa atom ak wripm awi pa. ");
INSERT INTO urim_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pake, kupm oklala naki Maur Wailen la kil ngklinseitn eng ikgake kitn ngko kai wrisen. Kitn wa la yaper kul pipa, kitn ik titnongketel tu wail wail a paipm paipm alkitn pa.” ");
INSERT INTO urim_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ari wa Pita kil akalmpe la, “Wailen, kupm am numprampen la tu iyeweitn kai rpmi wan tipmining aki, ilmpeitn imo pa, kupm ikga ikilenteitn!” ");
INSERT INTO urim_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ari wa Sisas akalmpentel la, “Pita, kupm lanakeitn la, amti karek ake la pa, mpa kitn lam nang akupmen ti nti wraur la kitn ake ariwe kupm ti.” ");
INSERT INTO urim_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Atom Sisas kil asen tu watnom alkil pa la, “Pikekg ep a kupm ukwawepm kai pa, ake pikekg kipm aye kweikwei a alupme marpm aki, apm kok aki nepm palk kakir pa, kalpis, kipm pikekg angkompwam. Ti pikekg kipm tukwok eng kwei ur aki, kalpis?” Ari wa tu wa la, “Kalpis, men pikekg ake tukwok eng kwei ur.” ");
INSERT INTO urim_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Atom Sisas lanaken la, “Pikekg kolpake, kil pa mpa kol kilke, mla ur a antiwe apm kok a kweikwei a alupme marpm pipa, kil mpa uwi iye. A mla ur a kosakal kalpisen pipa, kil uwi apm ur alkil a nowe eng wropuk pa ik uwi marpm pa, atom kil ikrmpen ur iye. ");
INSERT INTO urim_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ti yangkipm ur a la ela kai wrkapm a Maur Wailen pa la kolkil, 'Tu wrongkwail pa la kil melnum trangkowet paipm.' Yangkipm kil am la kupm tike. Ti am palng aklale tike. Yangkipm wrongkwail a pikekg nira akla kupm ti pa, ikgam palng iklale pake.” ");
INSERT INTO urim_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Atom tu lanakel la, “Wailen, kitn iri, kosakal wekg men aye itna ti.” Ari wa kil lanaken la, “A pawo! Ampur akor la pa watipmen.” ");
INSERT INTO urim_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sisas kil oklala nampokgen tu watnom alkil pa plalng pipa, kil awiyen anel atnuurng anong pa kai kaino wrik nangen Olip kol a kil ak ak pa. ");
INSERT INTO urim_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tu kaino pilng kaino nang pa, Sisas lanaken la, “Kipm oklala niki Maur Wailen eng mpa kil iyewepm ngkom nilokgen kalkuten eng a palng eng ik rkolngkepm pa.” ");
INSERT INTO urim_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Atom kil atnurngken kai watinet ketn ketn kapor kilko alein a, oklala naki Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Atom kil lanakel kolpa la, “Yaiyai, kol wasrongen alkitn pipa, kitn uwi kaimung kil kai tukuleikgentopm. Pake ampur kitn katnun wasrongen a kupm ti pa, kitn ik ik wasrongen alkitnen pawo!” ");
INSERT INTO urim_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Atom maur akwapel ur a Maur Wailen pa angkaino kitnong ai nar palngtel, ak titnongketelel. ");
INSERT INTO urim_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ipma a kil pa alupm wes noros paipm kolti. Kolpa atom wa kil wa oklala naki Maur Wailen titnongket, pa nsam pa namperkgen wom pa wom elng nar kanokg ti kolen walmpopm pa. ");
INSERT INTO urim_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kil oklala naki Maur Wailen plalng, kil wrekg kai ari tu watnom alkil pa ari, tu pa ipma kalkut paipm, atom anel okg rka. ");
INSERT INTO urim_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Atom kil la, “Ei, wa kipm okg okg rka eng na? Ti kipm wrekg oklala niki Maur Wailen ti eng mpa kil iyewepm ngkom nilokgen kalkuten eng a palng eng ik rkolngkepm ti.” ");
INSERT INTO urim_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Atom Sisas kil oklala kolpa itna, ari tu wrong wailet am anel wli wli tike. Melnum ur a tu namput la Sutas pa, kil pa melnum ur a tu watnom wampwam yikakwekg a Sisas aroaro wonel pa, am kil pa awiyen aye wli pake. Kil kai wreren Sisas pa la nikrontel. ");
INSERT INTO urim_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ari Sisas asentel la, “Sutas, kitn la nukrontopm kolpa eng uk Warim Kipman a Melnum ti kai wam a tu wrong manto tike?” ");
INSERT INTO urim_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tu watnom a Sisas pa, tu ari kuina ur eng a palng pa, atom tu la, “Wailen, men ik kosakal ti ik wangketen om?” ");
INSERT INTO urim_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ari kalpis, wris ur atuwen pa am ak kosakal pa wangket nungkulkg wi a melnum akwapel a melnum tukgunakg a itna ep eng tu ipma krakgen kimeket pa ise. ");
INSERT INTO urim_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ari, Sisas wa la, “Elngen o!” Kolti kil elng wam pa itna nungkulkg a melnum pa, atom nungkulkg pa wa palng wor itna kati kati. ");
INSERT INTO urim_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Atom kil lanaki tu melnum tukgunakgen a tu ipma krakgen pa, wa tu melnum tukgunakg a tu nepimpalo a ikgalen yalming a Maur Wailen pa, wa tu melnum wailen wailen a wli la rkulel pa la, “Ti kipm aye kosakal a yomis ti wli la rkul kupm ti, eng kupm ti melnum trangkowet ur akipmen tike? ");
INSERT INTO urim_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ti akangklei wang kupm antiwepm rpma kawor yipmingki wunen a yalming a Maur Wailen pa, karken a kipm arkulopm ak wang pa. Pake, wang ketn ti pa, pa wang akipmen, pa wang a miningket, mpa Maur Paipm kil ikwap ik titnongket akilen.” ");
INSERT INTO urim_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tu arkul Sisas pa aye kai kawor wan a melnum tukgunakg a itna ep eng tu ipma krakgen kimeket pa, Pita pa katnunten kolpa angklokg wang katnukg katnukg kai kawor. ");
INSERT INTO urim_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kil kai anti tu arkgin wakg wail ur a tu alile arkgin pa rka mapmingkyun pa wreren wan a tu antokg yangkipm atne pa. ");
INSERT INTO urim_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kil arkgin wakg pa rpma ari wakg pa naruk alentel atom kin akwapel ur pa ikg kai ariwel atom kil lala, “Ti melnum ur ari kolen pikekg anti Sisas atn ti pa ti ingkai rpma ti!” ");
INSERT INTO urim_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ari Pita kil akalmpe kai kin pa la, “Kupm akwekgel melnum a kitn la pa!” ");
INSERT INTO urim_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wa tu wa rka ketn ketn kolpa kai ari, wa melnum ur pa ariwel atom wa la, “Kitn pa melnum ur atuwen am pake!” Ari wa Pita akalmpe la, “Kupm ti kalpis!” ");
INSERT INTO urim_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Itna watinet ketn ketn ari wa melnum ur pa la titnongket la, “Ti kipm la ntei, melnum a rpma ti pa a Kalili, kil pikekg anti Sisas atn pa.” ");
INSERT INTO urim_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ari wa Pita akalmpe la, “Kupm ti ake ariwe kuina ur a kipm la pa!” Pita oklala kolpa itna pa, karek am la ise. ");
INSERT INTO urim_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Atom Wailen kil plelng ikatnen Pita pa kolpa pipa, nol nikgwalpm a Pita pa am plelngen ise, kil akwonalmpen yangkipm a pikekg Wailen kil la kolpa la, “Amti mpa ik mining ti karek ake la wai, kitn mpa lam nang akupmen ti nti wraur, la kitn ake ariwe kupm ti.” ");
INSERT INTO urim_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Atom Pita wrekg kawor akg paipm wrisen kawor en ai. ");
INSERT INTO urim_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tu melnum a wet arkul Sisas pa, tu anel aknokgelel a, orel. ");
INSERT INTO urim_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tu ak apm umpu pa ak yapo wulmpawel plalng pipa, tu orel kai ikgok kil pa, atom asentel la, “Kitn melnum okwripm pa, kitn la ri, la wet mla oreitn?” ");
INSERT INTO urim_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","A wa tu ak nokgelel ak yangkipm paipm paipm tiur ai. ");
INSERT INTO urim_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Takgni aro pa, tu mring man wailen wailen a ikgalen tu wrong kin kipman pa, pa tu melnum tukgunakgen a tu ipma krakgen pa, a tu melnum a aroaro wonel tu yangkipm a Moses pa, anel ep wli rka wris. Tu pa mring man wailen wailen mapming a rpma eng atning yangkipm ok atom tu aye Sisas pa kai itna antokg yangkipm ok itna tu pake. ");
INSERT INTO urim_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Atom tu la kolpa la, “Ti kitn laniko ri la, kitn pa Krais?” Ari wa Sisas lanaken la, “Kol kupm lanikepm pa, mpa wa kipm ake ukipma. ");
INSERT INTO urim_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Wa kol kupm isentepm pa, kipm ampake ikilmpe. ");
INSERT INTO urim_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pake kol ak wang ti, wa or pa kai pa, Warim Kipman a Melnum ti pa, kil ikga rpmi kaino wam wi a Maur Wailen a antiwe titnongket wrongkwail.” ");
INSERT INTO urim_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Atom wa tu asentel la, “Ti kitn ti kitn Warim Kipman a Maur Wailen?” Ari wa kil akalmpe la, “Am kipm alkipm pa la la kupm tike.” ");
INSERT INTO urim_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Atom tu la kolpa la, “Men ake la itning melnum ur wa laniko or pa kai! Men am wet atning a kil laron kil alkil angko wunong ise, ti a pake!” ");
INSERT INTO urim_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tu melnum wail wail antokg yangkipm nampokgen Sisas pa plalng pa, wa tu kimeket ak wail anel awiyel a pa wa aye kai eng Pailat, ");
INSERT INTO urim_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","atom anel lakati naki Pailat pa kolpa la, “Men ari melnum ti pa kil wa alok tu wrong kin kipman amenen ti kai or ya paipm, a wa kil wa angkengko la ake mpa men ngkli marpm kai eng melnum tukgunakg a kipm Rom pa, wa kil ngkat nang a kil alkil ti la kil ti Krais, melnum tukgunakg a Maur Wailen ukwa nar la ikuwi tu wrong kin kipman.” ");
INSERT INTO urim_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Atom Pailat pa asentel la, “Ti kitn pa melnum tukgunakg a tu Suta pake?” Ari wa Sisas akalmpe la, “Am kitn alkitn pa la kolpake.” ");
INSERT INTO urim_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Atom wa Pailat pa lanaki tu melnum ipma krakgen tukgunakgen a Maur Wailen pa, wa tu wrongkwail a itna pa la, “Melnum ti ake kupm ari la kil antokg paipm ur eng mpa kupm la tu ilmpel imo pa.” ");
INSERT INTO urim_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ari wa tu wa la titnongket paipm la, “Kil pikekg ak kwap kaling plan tu wrong kin kipman itna yela Sutia ti. Pikekg kil ngkaten itna kaino Kalili ai atom am wa aye nar ti kul no tike. Kolpa atom kil arongke nikgwalpm a tu wrong kin a kipman pa rka kai pa kai pa.” ");
INSERT INTO urim_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat kil atning a tu melnum wail wail la kolpa atom kil asen la, “Kil ti melnum a anong kanokg a Kalili?” ");
INSERT INTO urim_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tu akalmpe la, “Ei, kil melnum a Kalili pake.” Atom Pailat tilp tu ayewel kai eng Erot eng ntei, Erot pa kil itna melnum wailen a ikgalen anong kanokg a Kalili pake. Pake ak wang pa, Erot am rpma Serusalem pa yat pake. ");
INSERT INTO urim_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tu ayewel kai palng pa, Erot ari Sisas kolpa kil atopen paipm, eng ntei, kil pikekg atning a tu la Sisas pa, atom kil pikekg lantwang wang watinet la kil la kol a riwel. Wa kil akwonalmpen la kol a ri Sisas ntokg kwei ur titnongket kol a pikekg kil antokg atom tu wrong kinkipman ari atom tu wrekg paipm pa, eng kol a kil ri. ");
INSERT INTO urim_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Atom Erot kil akasen Sisas oklala watipmen, ari ake kil akalmpe oklala ur. ");
INSERT INTO urim_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ari tu melnum ipma krakgen tukgunakgen pa nampokgen tu melnum a aroaro wonel tu yangkipm a Moses pa a antiwel itna pa anel arkiwel titnongket la, kil melnum a antokg paipmpaipm. ");
INSERT INTO urim_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Atom Erot nampokgen tu melnum alkil a almpwrong pa, anel ari elukgen la paipmelel, a ak nokgelel. Atom tu awi apm ariwor ur pa nowewel plalng pipa, anel ukwawel yaper kai eng Pailat. ");
INSERT INTO urim_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ak wang ketn pa, Erot ekg Pailat a pikekg wrongmanto eng tita pa, wa ekg kai wangkir a yapon or wris. ");
INSERT INTO urim_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Atom Pailat kil akwe tu melnum ipma krakgen tukgunakgen, a tu melnum wailen wailen a ikgalen men Suta pa nampokgen tu wrong kin kipman pa anel wli. ");
INSERT INTO urim_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Atom kil lanaken la, “Wet kipm ayewel wli ep pa, kipm arkiwel la kil arongke nikgwalpm a tu wrong kin kipman pa kai atn palpa. Pake kipm alkipm wet atning pa, kupm ariwel a kupm atning yangkipm akilen pa, ari ake kupm ari kil antokg paipm ur, kol a kipm arkiwel pa. ");
INSERT INTO urim_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Wa Erot pa ake wa ari la kil antokg paipm ur kolpa, atom wa kil ukwawel yaper kul eng mentepm ti. Ti melnum ti ake antokg paipm ur, eng mpa mentepm ilmpel imo pa. ");
INSERT INTO urim_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ti mpa kupm la tu orel plalng pa, kupm ungkwantel kil kai.” ");
INSERT INTO urim_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Akangklei wring wris wris a tu antokg okipma wail al al kol ri ti pa, Pailat kil mpa ngketen melnum wris ur a rpma wan tipmining pa kul or kai en. ");
INSERT INTO urim_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ari tu wrongkwail kin kipman a itna pa anel la wlipa wlipa yikakatnen la, “Or kil pa imo o! A ngketen Parapas pa kul or kai en!” ");
INSERT INTO urim_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Kol Parapas pa pikekg anti tu melnum tiur wrekg itna anong wail ti la tulpulng ungkwan tu melnum wailen wailen a Rom a ikgalenten ti kai tukulelkg, atom alm melnum ur amo, atom tu awiyel aye kai rpma wan tipmining. ");
INSERT INTO urim_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pake Pailat pa wasrongen la mpa wangketen Sisas pa or en, atom wa kil lanaki tu wrong kin kipman pa anti ur. ");
INSERT INTO urim_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ari wa tu la yikakatnen la, “Iyewel kai kurkurngkel rki yo okgmangki pawo!” ");
INSERT INTO urim_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Wet Pailat asenten anti wekg ise, ari wa kil wa asenten anti ur la, “Pikekg kil antokg kuina paipm? Ake kupm ari kil pa antokg paipm ur eng mpa orel imo pa! Ti mpa kupm la tu orel plalng pa, kupm ungkwantel kil kai.” ");
INSERT INTO urim_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ari tu itna pa itna pa la plalplal mainmain la, kurkurng Sisas pake, atom ampri okel Pailat pa. ");
INSERT INTO urim_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kil atning a tu wrongkwail tu la titnongket kolpa atom, kil awi wor la mpa tu kurkurng Sisas rki yo okgmangki. ");
INSERT INTO urim_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Atom kil angketen melnum a tu wasrongen a pikekg wrekg la tulpulng ungkwan tu wailen wailen a Rom a ikgalenten pa antokg melkget alm tita atom kil alm melnum ur amo pa, atom tu ayewel kawor rpma wan tipmining pa kul or kai en, a kil elng Sisas pa kai wam a tu melnum a almpwrong pa la tu ntokg kitila ik wasrongen alntu pa. ");
INSERT INTO urim_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Atom tu melnum a almpwrong pa tu awi Sisas pa kolti, tu aye kai. Tu angkom kai pa, tu ansil melnum ur pa, nang alkilen pa Saimon, kil melnum kai anong Sairini. Kil angkai wring pa kul la kai kawor Serusalem pa ari tu angkengkel kolti, tu alkel yo okgmangki a Sisas pa la kil rki iye kutnun Sisas pa ntiwen iye kai. ");
INSERT INTO urim_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tu wrong watipmen paipm pa tu katnun Sisas, nampokgen tu kin tiur pa, akg atop ak ok namputen areinsel. ");
INSERT INTO urim_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ari Sisas plelng lanaken la, “Kipm kin a Serusalem pa! Ampur kipm akg arein kupm ti pa, kipm akg rein kipm alkipm ti numpokgen tu warim alkipmen pawo! ");
INSERT INTO urim_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ik wang ur pa ipma wakget a Maur Wailen ikga palng, atom tu ikga la kolpa la, 'Tu kin a kimpong, a tu kin mamingkisen, a tu kin a ake uk ma warim pa, ik wang pa tu pa ikga worenen ketnketn pake, ti tu pa tu itopen o!' ");
INSERT INTO urim_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ik wang pa, tu wrongkwail ikga la tipmining ti la, 'Tipor nar ik auro!' A la wrik nangen ti la, 'Ik lampo!' ");
INSERT INTO urim_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yo maing kil pa tu antokg kolpake, a yo nungkwor pa ikga tu ntokg paipm wrisen ai. Kol melnum a ake antokg paipm ur pa tu antokg kolkilke, a kipm melnum a antokg paipmpaipm pa ikga tu ntokgtepm paipm wrisen ai or kai ai.” ");
INSERT INTO urim_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Atom melnum trangkowet wekg ur pa wuten tu melnum a almpwrong pa ayewen aye kul la kurkurngken imo numpokgen Sisas pa. ");
INSERT INTO urim_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Atom tu wli palng kul wrik a tu namput la Melnum Tukgunakg Timpal pa, tu karkurng Sisas rka yo okgmangki nampokgen melnum trangkowet wekg pa, ur rka wam wi pa, wa ur rka wam wangkokg. ");
INSERT INTO urim_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Atom Sisas kil la, “Yaiyai! Kitn ungkwan paipmpaipm a tu ti, eng ntei, tu ake ariwe kuina ur a tu antokg ti.” Atom tu klasinen wes pa awi awi ari eng mpreing apm akilen pa. ");
INSERT INTO urim_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Atom tu wrong kin kipman pa anel itna ikatnen kolpa itna, tu melnum wailen wailen pa anel akgnokgel Sisas pa la, “Kil pikekg angklin tu tiur ai. Ti kol kil melnum a pikekg Maur Wailen takweiyel aklale la kil ikuwi tu wrong kin kipman pa, ti kil ngklin kil alkil tiwo!” ");
INSERT INTO urim_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wa tu melnum a almpwrong pa wa anel ak nokgelel, anel kulno kolti alkel u titno kinipis pa la kil il, ");
INSERT INTO urim_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","atom anel la kolpa la, “Kol kitn melnum tukgunakg a tu wrong kin kipman a Suta ti pa, kitn ngklin kitn alkitn tiwo!” ");
INSERT INTO urim_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ela kaino yo tukgunakgen pa tu nira kolpa la la, “Kil melnum tukgunakg a tu Suta.” ");
INSERT INTO urim_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wa melnum trangkowet ur a rka kai yamping wompel a Sisas pa kil wa ak nokgelel la, “Ti kitn ti, kitn la kitn melnum a pikekg Maur Wailen kil ukwaweitn nar ti, kol a kitn ngklin kitn alkitn ti ri, wa kol a kitn ngklin mentekg ti yat!” ");
INSERT INTO urim_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ari wa ur a rka yamping wompel pa akle ur a wuten la rka kai yamping wompel pa la, “Ti kitn ti ake ngkarken Maur Wailen ti? Ti mentekg am arki kalkuten wris kol kil pake. ");
INSERT INTO urim_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kol mentekg ti pa pikekg antokg paipmpaipm atom tu karkurngko pake, pake kil pa pikekg ake antokg paipmpaipm ur.” ");
INSERT INTO urim_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Atom kil lanaki Sisas pa la, “Sisas, ik wang a ikga kitn palng wailen ikglen kweikwei wrongkwail pa, kitn ikwonilmpentopm!” ");
INSERT INTO urim_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ari wa Sisas lanakel la, “Kupm lanakeitn aklale wrisen la, amti kitn mpa nti kupm rpmi kaino anong wor tike.” ");
INSERT INTO urim_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Atom ak takgni no pirng pa, elng kul kai mining karng kolti akaur kanokg ti yela, itna a, a, tukoryauk pa angkli om pa, mining pa kai plalng om, ");
INSERT INTO urim_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","elng kul kai mining pa atnen takgni ake el, a apm kaki wail a tu alekg rka akangketen yalming a Maur Wailen pa rakol wompwekg. ");
INSERT INTO urim_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Atom Sisas kil kirkar akg yikakatnen ak ok namputen yan alkil pa la, “Yaiyai, uwi maur amen wor akupmen pawo!” Kil la kolpa, a kil amo. ");
INSERT INTO urim_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Melnum itna ep a tu melnum a almpwrong kamel wampwomis pa kil ari kweikwei a palng kolpa atom kil ngkat nang a Maur Wailen pa la, “Aklale wrisen, kil pa ake melnum ur a antokg paipm ur!” ");
INSERT INTO urim_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tu wrongkwail a wli rka pa tu ari kweikwei a palng kolpa pa, tu arein paipm kolti, wam yapo nol kolti yaper kaingkai wan anong alntu ai. ");
INSERT INTO urim_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tu yiprokgen, a tu melnum wor a Sisas pa, wa tu kin a katnuntel angkaino Kalili ai nar pa, anel itna watinet ketn ketn atom ari kweikwei a palng pa. ");
INSERT INTO urim_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Melnum ur pa, tu namput la Sosep, melnum ur kai anong Arimatea. Kil anong ur a ela anong kanokg a Sutia, pa melnum ute wor a rpma nungkwangen la ri Maur Wailen itni wailen ikglen kweikwei wrongkwail. Kil pa am wa mring man wail ur a mapming a rpma atning atning yangkipm pa yat pake, pake kil ake pikekg ipma wris nampokgen tu kwapwris alkil a tu rpma yapon yangkipm a ak nikgwalpm kolpa eng Sisas pa. ");
INSERT INTO urim_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Atom kil kai kawor ari Pailat pa, eng la uwi palk a Sisas pa iye kai lil. ");
INSERT INTO urim_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Atom Pailat awi wor pa, kil kul or kai nalu palk pa kolti, aye nar ak apm tangkoren pa yapo plalng pipa, kil ngkat aye kai alil ermpa kawor mlamin wunen ur a pikekg tu u pa, a ake pikekg tu alil melnum ur armpe pa. ");
INSERT INTO urim_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Atom wang pa wang a tu numprampen kweikwei eng rpma eng awi yapm, pa kol weti kai elngen nungkurikg ari kamel lukg wekg pa, a ngkiten i pa kai ikgkil wang misen pa, pa wang wail a tu rpma eng yapm pake. ");
INSERT INTO urim_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Tu kin tiur a pikekg anti Sisas angkaino Kalili ai nar pa anel katnun Sosep pa atom, tu ari mlamin pa, wa palk a Sisas a kil alil pa. ");
INSERT INTO urim_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kolti, tu yaper kai numprampen u yiwa wa kweikwei yaprekget yaprekget pa eng la ikinel palk akilen pa. Atom ak wang wail pa tu rpma eng yapm kol a yangkipm titnongket pa la pa. ");
INSERT INTO urim_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wang wail a rpma eng yapm pa plalng pipa, tu kin pa wrekg ak kong miningket paipm ai, aye u a kweikwei yaprekget yaprekget a tu numprampen pa aye kai kirkap pa la ik inel palk a Sisas pa. ");
INSERT INTO urim_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ari tu ari wes a pikekg akampri mlamin ok pa, am wa talpul takwleikgen ise. ");
INSERT INTO urim_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Atom tu kai kawor mlamin wunen pa ari, ake tu ari palk a Wailen Sisas pa. ");
INSERT INTO urim_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Atom tu itna pa akwonalmpen watipmen ari, tu ari melnum wekg ur a nowe apm klalen muinmainet paipm ai palng itna wrerenten. ");
INSERT INTO urim_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tu kin pa ari kolpa tu ngkark paipm, atom anel omtompok lam wulmpa alntu pa kinar kanokg ai kolti. Ari melnum wekg pa lanaken la, “Ti wa kipm kul akor melnum a rpma malepmen ti kul wrik a alil melnum a amo ti, eng ntei? ");
INSERT INTO urim_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ti kipm ri, kil ake rmpa ti, kil am wrekg ise. Ti kipm ikwonilmpen yangkipm a pikekg kil lanakepm angkaino Kalili pa la, ");
INSERT INTO urim_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","'Warim Kipman a Melnum pa ikga tu uk kai wam a tu melnum a antokg paipmpaipm pa, atom ikga tu kurkurngkel rki yo okgmangki pa, uwiyel iye kai lilel rmpi, i i, wang wraur pa kai plalng pa, wa kil wa wrekg.'” ");
INSERT INTO urim_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Atom wa tu kin pa wonarpme yangkipm a pikekg kil la pa, ");
INSERT INTO urim_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","atom wa tu wa yaper a wrik a tu alil Sisas pa kai kolti, lakati naki tu watnom wampwam yikakwris a Sisas pa, nampokgen tu wrongkwail ai, kweikwei wrongkwail a wet tu ari a palng pa. ");
INSERT INTO urim_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tu kin a kai lakati yangkipm pa naki tu melnum wokgen a Sisas pa pati, Maria a anong Maktala, a Soana, a Maria, man a Semis pa, wa tu kin tiur ai nampokgenten. ");
INSERT INTO urim_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ari tu watnom pa la la, palpa tu la yangkipm kansil ur kolti. Tu ake ukipma yangkipm pa la yangkipm pa aklale pa. ");
INSERT INTO urim_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ari Pita pa kil wrekg kolti, kil pirng kai wrik a pikekg tu alil Sisas armpe pa. Atom kil itna en ti ikgarmpen ari, kil ari apm kalpmilel kolti rmpa. Atom kil yaper kai kolti wa akwonalmpen watipmen eng kweikwei a palng kolpa. ");
INSERT INTO urim_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Itna wang pa, watnom wekg ur a Sisas pa, tuwekg la ekg kai anong ur a tu namput la Emeus, anong ur a ela watinet ketn eng Serusalem pa. ");
INSERT INTO urim_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Atom tuwekg akor la tatu ya pa kai kweikwei wrongkwail a palng pa. ");
INSERT INTO urim_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tuwekg akor la kolpa kai pa, Sisas kil palng angkom kai arken nepm atom teng angkompwris kolpa kai. ");
INSERT INTO urim_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Atom tuwekg pa ariwel pake, ake tuwekg ariwe la, Sisas pa. ");
INSERT INTO urim_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Atom Sisas asenten la, “Kipmekg akor la kuina itna wampel ti?” Tuwekg atning pa, tuwekg kai itna, atom kil ari la tuwekg pa ipma kaikut. ");
INSERT INTO urim_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Atom wris ur a tuwekg a tu namput la Kliopas pa la, “Ti kitn ti pikekg rpma atn kolai, atom kitn ake ariwe kweikwei wail a pikekg palng ti?” ");
INSERT INTO urim_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ari wa Sisas asenten la, “Kuina wai?” Ari wa tuwekg akalmpe la, “Mentekg wuten akor la Sisas a Nasaret pa. Kil melnum okwripm a Maur Wailen takweiyel alkel titnongket, atom kil laron yangkipm nampokgen titnongket, wa antokg kweikwei titnongket weten weten, atom tu wrong kin kipman ariwel la kil melnum wailen. ");
INSERT INTO urim_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tu melnum ipma krakgen tukgunakgen a tu melnum wailen wailen amentepmen ti uk kil kai wam a tu Rom la orel imo, atom tu karkurngkel rka yo okgmangki. ");
INSERT INTO urim_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Atom men ti pikekg akwonalmpen la kil pa melnum a kol a ikrmpen mentepm Isrel pake! Atom kweikwei a pikekg palng pa, am wang wraur ak angketen kai ise. ");
INSERT INTO urim_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Atom weti ak kong pa, wa men wrekg paipm eng tu kin tiur amenen a pikekg atn angklinsel pa, anel wrekg ak kong miningket paipm ai kai kawor mlamin kirk wunen a tu alil Sisas rmpawe pa. ");
INSERT INTO urim_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ari tu kai ari palk akilen pa ake rmpa. Atom tu yaper wli lanako la, tu ari maur akwapel wekg a Maur Wailen pa, atom tuwekg lanaken la, kil am wrekg ise! ");
INSERT INTO urim_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Atom wa tu tiur amenen pa, wa anel kai wrik a tu alilel pa ari, am kol a tu kin pa la pake: ake tu ariwel.” ");
INSERT INTO urim_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Atom Sisas lanaken la, “Ti kipmekg ti titnowen, a ake wa kipmekg ukipma alupmen yangkipm wrongkwail a pikekg tu melnum okwripm a Maur Wailen la pa! ");
INSERT INTO urim_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ti kipmekg ti ake ariwe la wrkapm a Maur Wailen la ikg am palng kolpake, la melnum a pikekg Maur Wailen ukwa nar la ikuwi kipm wrong kin kipman pa, kil ikga uwi wleket wail, plalng pipa, kil kaino rpmi numpokgen Maur Wailen, uwi titnongket a nang wailen pake.” ");
INSERT INTO urim_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Atom Sisas laron yangkipm ok yiprokgen wrongkwail a lakati kil alkil ti naken ngkaten angkai Moses ai, wa kulngkul tu melnum okwripm a Maur Wailen a tu nira ela kai wrkapm a Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tunteng kul wreren anong pa, atom Sisas pa alen ipma la aren oryawel, ");
INSERT INTO urim_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ari wa tuwekg pa angkengkel la, “Ti mining kreet eng a mining tike, ti kitn kul ntiwo okg rmpi tipen!” Atom kil kawor la ntiwen rpmi. ");
INSERT INTO urim_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tunteng rpma la il okipma pa, kil awi nok tingklak pa ukwor Maur Wailen plalng pipa, kil kapor alken. ");
INSERT INTO urim_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kil antokg kolpa atom, wulmpa a tuwekg pa kitnangku ariwel, ari kil am wa kai titalam ise. ");
INSERT INTO urim_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Atom tuwekg naki tita la, “Aklale, ti wet kil lakati nako yiprokgen a ela kai Wrkapm a Maur Wailen pa angko ya pa, pa wuten almpo ipma.” ");
INSERT INTO urim_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Atom ak wang ketn pa tuwekg wrekg kolti, yaper kai Serusalem ari tu watnom wampwam yikak wris a Sisas a anel rka wris pa. ");
INSERT INTO urim_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ari tu mprak mprak lailai lakati naken kuina ur a wuten palng eng Saimon pa, pa la, “Wailen am wrekg aklale ise! Ti wuten palng eng Saimon ari pa.” ");
INSERT INTO urim_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tu la kolpa naken plalng pipa, tuwekg ti wa lakati naken la, Sisas palngten angko ya pa, atom tunteng angkom or ya pa kai pa tuwekg ake ariwe la kil pa Sisas pa. Tunteng kai palng rpma kai wan ai, kil kapor nok tingklak pa alken pipa, tuwekg ariwe la Sisas am pake. ");
INSERT INTO urim_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tu watnom a Sisas tu lakati kolpa itna pa, Wailen pa palngten pinterngen kolti lanaken la, “Ipma akipmen pa rki meen!” ");
INSERT INTO urim_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ari tu pa la tu ari maur ur atom tu ngkark paipm wrisen kolti. ");
INSERT INTO urim_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ari wa kil lanaken la, “Ti wa kipm wrekg paipm akwonalmpen watipmen eng ntei? ");
INSERT INTO urim_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ti kipm ri nepm wam akupmen ti! A wa kipm ri la, am kupm tike. Wa kipm kul ri wampirpme ik wampla ik itningke numpwam akupmen ti! La maur pa, kol ake numpu rke kol kupm ti, kol a kipm ri kolti kai titalam ise.” ");
INSERT INTO urim_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kil la kolpa plalng pipa, kil planten nepm wam akilen pa. ");
INSERT INTO urim_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Atom tu atopen, pake nikgwalpm a tu pa rka nowe nare, ake kai wris. Atom kil asenten la, “Kipm aye okipma ur aki?” ");
INSERT INTO urim_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Atom tu alkel yul tiwel a wet tu alilng pa, ");
INSERT INTO urim_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","atom tu ari a kil awi al pa. ");
INSERT INTO urim_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kil al yul pa plalng pa, kil lanaken la, “Kipm ariwe pa, pikekg kupm antiwepm rpma pa, kupm lanakepm la, yangkipm ok wrongkwail a ela kai wrkapm a Moses a tu melnum ok wripm a Maur Wailen nira pa, a wa ela kai wrkapm nangnang a Tepit nira pa, a akla kupm ti pa, pa mpa palng ok rke, ake mpa kalpis pa, ti am palng tike.” ");
INSERT INTO urim_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Atom kil antokg nol nikgwalpm a tu pa palng wontrakole ariwe yangkipm a Maur Wailen a nira ela wrkapm pa. ");
INSERT INTO urim_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Atom kil lanaken la, “Tu nira kolpa la, melnum a Maur Wailen ukwa nar la ikuwi tu wrong kin kipman pa, ikga kil imo, atom wang wraur kai plalng pa, wa kil wa wrekg. ");
INSERT INTO urim_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","A ikga tu laron nang akilen pa niki tu wrong kin kipman pa, ikga tu plelng ipma, atom ikga kil ungkwan paipmpaipm atuwen. Ikga tu ngkiten kwap pa ik itni Serusalem ti, atom iye kai yela kanokg ti. ");
INSERT INTO urim_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kipm alkipm ti pekg nungkulkg a wulmpa eng kweikwei wrongkwail a palng pa, ti ikgam kipm ti laron ik titnongketel niki tu wrong kin kipman tike la pa aklale. ");
INSERT INTO urim_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ti kipm itning, ikga kupm ukwantepm Maur Wor a pikekg Yan alkupmen kil yapon yangkipm pa. Ti ikga kipm rpmi nungkwangen i anong wail ti rpmi i i, ikga kipm uwi titnongket wail pa a ikga kupm ukwantepm nar pa.” ");
INSERT INTO urim_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Atom Sisas awi tu watnom alkilen pa anel atnurng Serusalem pa kai kinar angko wreren anong Petani pa, atom kil ngkat wam pa, a kil lanaki Maur Wailen pa la kil planten ipma wor alkil pa ngklinsen. ");
INSERT INTO urim_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kil lanaki Maur Wailen kolpa itna pa, kil atnurngken kolti, Maur Wailen awiyel kolpa aye kai kaino kaino anong wor alkil ise. ");
INSERT INTO urim_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tu kapor kilko alein ngkat nang alkilen plalng pa, tu atopen wail manten yaper kaino kawor Serusalem pa. ");
INSERT INTO urim_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Atom tu anel rka yipmingki wunen a yalming a Maur Wailen pa ngkat nang alkilen pa angkli alkel wor akangklei wang kolpa rka. ");
INSERT INTO urim_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Yangkipm a laron nikgwalpm yiprokgen a Maur Wailen pa kil pikekg rpma ep ak ai kul ai, a kitnong a kanokg pa Maur Wailen kil la atom palng katnukg. Wa Yangkipm pa kil pikekg rpma nampokgen Maur Wailen. A wa Yangkipm pa kil Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yangkipm kil alkil kolti pikekg rpma ak ep lmpiwen ai nampokgen Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yangkipm pa kil ya a pikekg Maur Wailen la atom kweikwei wrongkwail palng or kil pa, ake pikekg palng kolti pa, am pikekg palng or Yangkipm pake. ");
INSERT INTO urim_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yangkipm pa kil yiprokgen a Yaprekg Watin eng rpma wor yongkyong. Yaprekg Watin alkil pa Wakg a naruk ak alen tu wrong kin a kipman. ");
INSERT INTO urim_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Wakg pa kil naruk ak alen miningket pa, pake miningket pa ake antiwe iye kul kai ik ipaarng kil pa. ");
INSERT INTO urim_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Melnum ur pa rpma, nang alkilen pa Son, Maur Wailen kil takweiyel ukwawel kul. ");
INSERT INTO urim_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Kil pikekg atning a Maur Wailen lanakel, atom kil aye yangkipm pa kul laron Wakg pa naki tu kin a kipman pa aktitnongketel la pa aklale, eng mpa tu wrongkwail itning ukipma Wakg pa. ");
INSERT INTO urim_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Son kil alkil ti pa ake Wakg pa. Pake kil pikekg atning a Maur Wailen lanakel, atom kil kul laron Wakg pa naki tu wrongkwail kin a kipman pa la, ");
INSERT INTO urim_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Wakg aklale wrisen pa kil eng a nar eng la ik len mentepm wrong kin a kipman wrongkwail a kanokg ti. ");
INSERT INTO urim_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Wakg pa kil ya a pikekg Maur Wailen la atom kitnong a kanokg a kweikwei wrongkwail ti palng or ya pa. Kil nar rpma kanokg a tike, pake wrong kin a kipman a kanokg ti ake wa ariwe la kil melnum kolpa. ");
INSERT INTO urim_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kil nar anong yiprokg alkilen tike, pake tu alkilen ti pa ake wa atopen awiyel kolen la kil pa melnum wailen alntuwen pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pake tu melnum a atopen awiyel la kil pa melnum wailen atuwen atom wa ukipma kil pa, pa kil alken nang wailen la tu pa palng warim a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tu pa ake palng warim a Maur Wailen or ya a man a yan ti angket pa, aki nikgwalpm a melnum ti la, aki melnum ti antokg kuina ur kolai atom tu palng warim a Maur Wailen pa kalpis. Pa Maur Wailen kil alkil pikekg antokg tu palng warim alkilen ai. ");
INSERT INTO urim_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yangkipm a laron nikgwalpm yiprokgen a Maur Wailen pa pikekg kil nar kanokg ti pa kil palng melnumpen, atom kil pikekg rpma nampokgen men ti. Pikekg men ari nang wailen a titnongket alkilen. Nang wailen a titnongket pa am a Warim Kipman yek wris anangket pake, pa Yan alkil pa alkel pake. Kil pa melnum wor wrisen a planto ipma wor a angklinso a wa kil antiwe nikgwalpm ute aklale a Yan alkil. ");
INSERT INTO urim_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Son a kaluk tu kil atning a pikekg Maur Wailen lanakel atom kil itna aktitnongketel laron melnum pa la yikakatnen naki tu wrongkwail pa kolpa la, “Melnum a ikga kul kutnukg kupm ti pa, am melnum a pikekg kupm laron nakepm la kil wreren eng a kul pake. Kil pa nang wailen angen kupm ti. Eng ntei, kil pa pikekg rpma ak klaingkil u ai, a kupm ti man rakuwopm katnukg.” ");
INSERT INTO urim_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kil antiwe nikgwalpm ute aklale a kil planto ipma wor angklinso wail manten paipm or kai ai. Atom mentepm kimeket awi kweikwei wor wor wailet paipm nurkg nurkg antiwe kolpa itna. ");
INSERT INTO urim_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Atom ti kipm ri, yangkipm titnongket pa pikekg Maur Wailen kil yapon uk Moses atom Moses kil alko. Pake nikgwalpm ute aklale a ipma wor a Maur Wailen kil planto a angklinso pa Maur Wailen uk Sisas Krais atom Sisas Krais kil alko. ");
INSERT INTO urim_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ake melnum ur ari Maur Wailen pa, kalpis wrisen. Warim Kipman yek wris anangket alkil pa, kil alkil Maur Wailen, kil anip no nol a Yan alkil ai. Am kil alkil wris ata pa kolti laron Maur Wailen pa prepmprepm nako a kaling planto atom mentepm ariwe pake. ");
INSERT INTO urim_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yangkipm kil pa Son kil laron Sisas pa aktitnongketel la kil Krais, melnum a Maur Wailen kil yapon la ikga nar ikrmpento pa. Tu melnum wailen wailen a men Suta a rpma kaino anong wail Serusalem pa tu ukwa tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen nampokgen tu Lipai tiur pa tu nar kul no eng Son atom tu alm ipmawel Son pa asentel la, “Kitn melnum mla atom kitn akwap ti?” ");
INSERT INTO urim_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ari Son kil ake lam kil alkil pa, kil laron angko wunong la, “Kupm ake Krais pa.” ");
INSERT INTO urim_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ari wa tu asentel anti ur la, “Ti kitn mla? Kitn Elaisa melnum ok wripm a pikekg Maur Wailen la la ikga yaper nar tike aki?” Ari Son kil akalmpe la, “Ake kupm Elaisa pa.” Atom wa tu wa asen anti ur la, “Ti kitn melnum okwripm kol Moses a Maur Wailen pikekg la ukwa nar ti mol?” Ari wa Son wa akalmpe la, “Ake kupm melnum okwripm a kipm la pa, kalpis.” ");
INSERT INTO urim_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Atom wa tu wa asentel la, “Ti kitn mla? Kitn la kitn alkitn ti riworwor niko ri, eng mpa men wa iye yangkipm ti kinar kai kaino niki tu a pikekg ukwawo nar kul no ti.” ");
INSERT INTO urim_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ari kil akalmpe la, “Kupm ti ok ur a okok la yikakatnen itna wrik mpang kalpmlel ti. Kol Aisaia melnum okwripm a Maur Wailen pikekg la ep la ok ur kolpa ikga la kolkil lala, 'Wailen ikga nar, ti kipm numprampen ya pa ik riworwor!' Ti kupm ti am ok pake.” ");
INSERT INTO urim_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tu melnum tiur a tu melnum wailen wailen ukwa nar kul no pa, tu pa tu melnum a arpmen yangkipm yiprokgen a Moses, ");
INSERT INTO urim_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","atom tu pa asentel la, “Kol kitn la la kitn ake Krais, aki Elaisa aki melnum okwripm a Maur Wailen la ukwa nar ep pa, ti wa antokg kolai atom wa kitn kaluk tu wrong kin a kipman pa?” ");
INSERT INTO urim_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ari Son kil akalmpe la, “Aklale, kupm ti kaluken ak u ti kolti, pake melnum ur antiwepm itna ti a kipm ake ariwe la kil melnum wailen ur. ");
INSERT INTO urim_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Melnum a ikga kul kutnukg yirokg a kupm ti, kil pa melnum nang wailen, a kupm ti nang kalpisen a ake antiwe mpa kupm inelkgentel ampei a kil ak angkuten nepm palk a kil arpme pa.” ");
INSERT INTO urim_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kweikwei wrongkwail pa palng itna wrik Petani itna u kop wompel a Sotan, wrik a Son kaluk kaluk tu wrong kin a kipman atnewe pa. ");
INSERT INTO urim_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Okg or kong ti pa, Son kil kai oklala naki tu wrong kin kipman pa itna pa, kil ikgkai ari Sisas pa angkom wli la kulntel, atom kil lanaki tu pa la, “Kipm ri, pa Manto Walkg Malkgu War a Maur Wailen ikga ik ungkwan nikgwalpm paipm a itna kanokg ti. ");
INSERT INTO urim_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kil melnum a pikekg kupm lanakepm ep lala, 'Melnum a ikga palng kul kutnukg kupm ti pa, kil pa nang wailen angen kupm ti. Eng ntei, kil pa pikekg rpma ak klaingkil u ak ai, a kupm ti pa man rakuwopm pikekg ketn ti.' ");
INSERT INTO urim_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Kupm pikekg ariwe kil worwor, pake kupm ake pikekg ariwe la kil melnum wailen ur kolpa. Pake kupm ari pa atom kupm kul kalukepm ak u ti itna ti eng mpa kipm Isrel wrong kin kipman a Maur Wailen ti uwi riwe la pa melnum am pake.” ");
INSERT INTO urim_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Atom Son kil laron kuina ur a pikekg kil ari pa lanaki tu pa la, “Kupm alkupm pikekg ari Maur Wor angkaino Anong Wor a Maur Wailen ai nar kolen wel punum pa rpma melnum pa. ");
INSERT INTO urim_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kol kupm ti pa kupm pikekg ake wa ariwe la melnum pa kil melnum wailen ur kolpa, pake melnum a ukwawopm atom kupm kalukepm ak u ti pa, kil pikekg lanakopm la, 'Kitn ri Maur Wor akupmen pa nar rpmi melnum ur pa, pa pati la am melnum pake, melnum a ikga kuluk tu ik Maur Wor akupmen pake.' ");
INSERT INTO urim_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Atom yangkipm pa aklale. Kupm ari a palng aklale kai melnum pa kolpa atom kupm lanakepm la melnum pa am Warim Kipman a Maur Wailen pake.” ");
INSERT INTO urim_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Okg or kong ti pa, Son wa wrekg anti watnom wekg ur alkilen a kil aroaro wonel pa kai itna wrik wrik pa anti ur. ");
INSERT INTO urim_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kil ari Sisas pa angkom or kai ai, atom kil lanaki tuwekg pa la, “Kipmekg ri, pa Manto Walkg Malkgu War a Maur Wailen ingkai angkom or kai ai!” ");
INSERT INTO urim_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Watnom wekg a Son aroaro wonel pa atning a kil la kolpa, atom tuwekg kai katnun Sisas. ");
INSERT INTO urim_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Sisas kil plelng ariwen ari tuwekg katnuntel atom kil asenten la, “Kipmekg a kai or kolai?” Ari tuwekg akalmpe la, “Rapi, kitn ti rpma kai a i?” Yiprokgen a Rapi pa pati la melnum a aro wonel tu melnum. ");
INSERT INTO urim_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kil lanaken la, “Ti kipmekg kul o, eng mpa minto kai eng kipmekg ri wrik a kupm arpme ai!” Atom tuwekg kai ari wan a kil arpme ai ak nungkurikg kwikwai pa antiwel rpma pa, kaingkai kai mining kwawen ai pipa tuwekg kai. ");
INSERT INTO urim_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Melnum wris ur a tuwekg wet atning a Son la pa atom kil kai katnun Sisas pa Antru, paipmen a Saimon Pita. ");
INSERT INTO urim_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tuwekg atnuurng Sisas pa kul pa, Antru pa kil wrekg atatu kai akor wailen alkil Saimon pa ep, kolpa kai ansilel kolti a kil lanakel la, “Mentekg ari Mesaya, melnum a Maur Wailen pikekg yapon la ikga nar ikrmpen mentepm wrong kin kipman pa ise.” ");
INSERT INTO urim_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kil lanakel kolpa plalng pipa, kil ak awiyel kai eng Sisas. Sisas ariwel kolti atom kil lanakel la, “Kitn pa Saimon, warim a Son. Tu ikga ukweweitn la Sipas.” Nang Sipas a Sisas alilel pa akwe ak ok Krik pa la Pita. Yiprokgen a nang pa pati la wes. ");
INSERT INTO urim_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Okg or kong pa Sisas la kil a kaino anong kanokg Kalili. Kil kaino pa, kil ari melnum ur nang akilen pa Pilip, atom kil lanakel la, “Kitn kul kutnuntopm!” ");
INSERT INTO urim_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Anong yiprokg a Pilip pa Petsaita pake. Kil anong wris a Antru ekg Pita. ");
INSERT INTO urim_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip kil kai ansil Nataniel pa atom kil lanakel la, “Melnum a pikekg Moses nira yangkipm titnongket ak la ela wrkapm alkil pa, wa tu melnum okwripm nira akla la ikga kil nar ikrmpento pa, am minto ansil ise. Pa Sisas a Nasaret, warim kipman a Sosep.” ");
INSERT INTO urim_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ari wa Nataniel wa arkolng la, “Yo! Am kolpake! Kwei ur wor ur mpa wa palng kai kinar Nasaret pake?” Ari Pilip wa akalmpe la, “Ei, ti kitn kul eng ekg kai eng kitn ri!” Atom Nataniel antiwel kai. ");
INSERT INTO urim_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Sisas ari Nataniel pa anti Pilip pa wli pa, kil almpyapmel Nataniel pa la, “Ei, melnum wor yek wris anangket a Isrel a katnun ya a Maur Wailen pa am tike, kil ake melnum a kansil pa.” ");
INSERT INTO urim_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ari Nataniel wrekg paipm akalmpe la, “Kitn ariwe kupm ti or kolai?” Ari Sisas akalmpe la, “Ti ak wang a kitn rpmangkai tikga yiprokg ak angkom kupuket pa, pa kupm ariweitn ise. A Pilip wa kai ariweitn lakati kupm ti nakeitn pa, pa katnukg, a kupm ti ariweitn ep ise.” ");
INSERT INTO urim_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Atom Nataniel la, “Rapi, ti kupm ariwe pake, la kitn pa Warim Kipman a Maur Wailen a wa kitn melnum tukgunakg itna ep a ikgalen Isrel.” ");
INSERT INTO urim_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Atom Sisas lanakel la, “Ti kitn ukipma atnen a wet kupm lanakeitn a kupm ariweitn ak wang a kitn rpma kai yo tikga yiprokg pake? Pa kweikwei waiketn, kutnukg pa or pa kai pa ikga kitn ri kweikwei wail manten manten paipm angen pa!” ");
INSERT INTO urim_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Wa Sisas wa lanaki tunteng pa lala, “Kupm lanakepm aklale wrisen, la kutnukg pa ikga kipmteng ri kitnong ti ikga rakol atom tu maur akwapel a Maur Wailen pa ikga narno nepm itnen Warim Kipman a Melnum ti.” ");
INSERT INTO urim_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Sisas alekgen tu watnom alkil a kil aroaro wonel pa tu rka pa wang wekg pa kai plalng, okg or kong pa, tu a pa la kaino rki wris nimpokgen tu a antokg okipma al atnen kin a kipman a la uwi tita kaino anong Kana a anong kanokg Kalili. Ak wang pa man a Sisas pa kil ep kaino antiwen rpma ise. ");
INSERT INTO urim_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Tu pikekg akwen Sisas nampokgen tu watnom alkilen pa la tu ntiwen rpmi ik wang pa yat. ");
INSERT INTO urim_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Atom tu al u wain okipma kweikwei pa rpma kolpa kai pa, u wain pa am plalng ise. Atom man a Sisas pa ari pa, kil lanaki Sisas pa la, “U wain am plalng ise.” ");
INSERT INTO urim_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ari Sisas akalmpe naki man alkil pa la, “Mamam, kitn lanakopm la kol a kupm ntokg kwei ur pake, wang alkupmen pa a pa.” ");
INSERT INTO urim_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Man a Sisas wa kai naki tu melnum akwapel a angklin tu pa la, “Warim kipman akupmen la lanikepm kuina ur la kipm ntokg pa, pa kipm itning ntokg kolti!” ");
INSERT INTO urim_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Itna wrik a tu arke pa, kuntuk mang wail wampwomis wampwompwris pa rpma. Pa kuntuk a men Suta arpmen u eng ak klak klak nepm wam a kweikwei, pa ya almenen a men katnun katnun eng palng kukula wriwen wor itna wulmpa a Maur Wailen. U wampeng wampwomis wampwompwraur aki wampwam aki wampwam karpo tuwek pa (80-130 lita) antiwe alung elng kinar kuntuk mang wris pa mpa no pik. ");
INSERT INTO urim_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Sisas lanaki tu melnum akwapel pa la, “Kipm inong u pa wli lung kinar kuntuk mang pa no pik.” Tu atning kolpa atom tu anong u pa alung kinar kuntuk mang pa kulno pik. ");
INSERT INTO urim_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Atom kil lanaken la, “Kipm unong u tiur a rka kuntuk mang ti ngkiten iye kai eng melnum yan a ngkaten ok okipma pa.” Atom tu ngkaten u pa aye kai. ");
INSERT INTO urim_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Atom melnum yan a ngkaten ok okipma wail pa al u pa akwiyen, ari u pa am wet palng u wain ise, pake kil ake ariwe la u pa wet palng or kolai? Pake tu melnum a anong u pa aye kaino pa, tu pa ariwe pake. Atom kil akwe melnum kipman a awi kin weten pa kul, ");
INSERT INTO urim_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","a kil lanakel la, “Mla ur a ngkaten ok okipma kol ti pa, kil ampreing ampreing u wain titnongket wor pa uk uk tu pa ep ep. Tu al kolpa kai atom tu eng a kai titno pake, a pa kil ampreing u wain a ake titnongket wor pa alken tu al katnukg. Pake kitn ti lam u wain wor wrisen ti rpma kai a i atom wa kitn awi aye wli ti!” ");
INSERT INTO urim_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Sisas ake pikekg elng kla ur ak plan titnongket a Yan alkil angkai ai kulngkul, kil antokg itna anong Kana a anong kanokg Kalili tike. Pa kil plan kil alkil angko wunong, atom tu wrong kin kipman ari titnongket a nang wailen alkilen pa. Atom tu watnom alkilen a kil aroaro wonel pa ari pa, atom tu ukipma kil pa. ");
INSERT INTO urim_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Sisas nampokgen tu wusok wusok, a man alkilen pa wa tu watnom a kil aroaro wonel pa, tu atnuurng anong Kana pa a tu kai kaino rka kaino anong Kaperneam. Tu kai rka pa wang aripm ur a pa. ");
INSERT INTO urim_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pa wreren wang wail a men Suta la wli tukwem rki wris ikwonilmpen a pikekg Maur Wailen akawi tu amenen takwleikgen tu Isip pa aye kul wor. Wang wail pa kul wrer, atom Sisas kil angkaino anong kanokg a Kalili pa nar anong kanokg a Sutia ti kul no anong wail Serusalem. ");
INSERT INTO urim_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kil no palng Serusalem ai pipa, kil kai kawor yipmingki wunen a yalming a Maur Wailen pa, kil ari tu melnum a aye manto nepm watin, a manto walkg malkgu a wel punum aye wli itna eng mpa tu wrong rmpen iye kai uk tu ipma krakgen a al wor uk uk Maur Wailen. A wa tu alntu a ak ak marpm a yalming awiye marpm a tu ak armpen armpen kweikwei kawor en ai pa rka. ");
INSERT INTO urim_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Sisas awi ampei pa ak or ungkwan tu pa kimeket nampokgen manto nepm watin, a manto walkg malkgu takwleikgen wan yalming pa, a kil taipurng tipmakg a tu a akawiye tita marpm ok pa elng kai punprarng kai kanokg ai. ");
INSERT INTO urim_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kil akle ungkwan tu a ak wel punum awi marpm pa la, “Wrekg wrekg, ilmnon kweikwei alkipm ti plalng iye kai tukuleikgen o! Wa kipm antokg wan a Yan akupmen ti palng kolen la wan ur a armpen kweikwei a ak kweikwei awi marpm atne tuwa!” ");
INSERT INTO urim_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tu watnom a kil aroaro wonel pa atning ari pa, atom tu wonuwen yangkipm ur a nira ela wrkapm a Maur Wailen pa lala, “Kupm langkinen wan akitnen pa paipm wrisen, atom kupm la rki kaikuten eng la ntokg wan akitnen pa palng wor.” ");
INSERT INTO urim_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tu melnum wailen wailen a men Suta tu ari a Sisas ungkwan tu kolpa atom tu pa la, “Mla la atom kitn ungkwan tu pa kolpa? Kol kitn la kitn melnum a antiwe titnongket nang arke pa, ti kitn elng kla ur pa elngkitni ik planto nang wailen akitnen a kitn antiwe ntokg kweikwei kolpa.” ");
INSERT INTO urim_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ari Sisas akalmpe la, “Kipm tikale Wan Yalming a Maur Wailen tiwo! Ikga kupm wa le wan ti itni kiti kiti ik wang wraur kolti.” ");
INSERT INTO urim_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tu wailen wailen a men Suta akalmpe la, “Pikekg tu ngkat ale wan ti, pikekg ampenet, itna wringkwringen, wring kamel wekg tuwek wampwomis wampwompwris. Pake wa kitn wa la ngkit le wan ti ik wang wraur kolti!” ");
INSERT INTO urim_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pake yalming a Sisas kil la pa, pa kil la num a kil alkil ti. ");
INSERT INTO urim_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Wa tu watnom a Sisas a kil aroaro wonel pa wa ake wa ariwe yangkipm pa, kolpa kulngkul, kul angko wang a Sisas amo plalng wa kil wrekg rpma, pa tu wonuwen yangkipm a kil la ti. Atom tu ukipma yangkipm a la ela wrkapm a Maur Wailen pa la, aklale wrisen. Yangkipm a kil pikekg la le wan pa, am palng aklale tike. ");
INSERT INTO urim_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Sisas kil rpma anong wail Serusalem ak wang wail a men wli takwem rka akwonalmpen a pikekg Maur Wailen akawi tu amenen takwleikgen tu Isip pa aye kul wor. Tu wrongkwail kin a kipman pa tu ari kla a Sisas kil elngkitna ak plan titnongket a Maur Wailen pa. Tu ari pa atom tu ukipma Sisas. ");
INSERT INTO urim_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ari Sisas kil ake planten kil alkil ti kimek kimek, eng ntei, kil ariwe tu pa worwor. ");
INSERT INTO urim_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kil alkil ariwe nol nikgwalpm a melnum pa worwor, ti akentiwe mpa melnum ur lanikel nol nikgwalpm a melnum pa. ");
INSERT INTO urim_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Melnum ur pa nang alkilen pa Nikotimus. Kil melnum wris ur a tu melnum a arpmen yangkipm yiprokgen a Moses pa, wa kil mring man ur a tu mring man wail wail mapming a ikgalen men Suta ti. ");
INSERT INTO urim_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mining ur pa Nikotimus kil kai ari Sisas atom kil la, “Kitn melnum a kaling plan men, men ariwe la kitn pa melnum a kaling plan men, pikekg Maur Wailen ukwaweitn nar la irowonelo pa. Kol Maur Wailen ake rpma nampokgen melnum pa, kil ake antiwe elng kla ak plan titnongket a Maur Wailen pa kol a kitn antokg pa.” ");
INSERT INTO urim_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Atom Sisas akalmpe la, “Kupm lanakeitn aklale wrisen. Kol Maur Wailen ntokg melnum ur kil palng weten kol warim walmpopmet a man raku weten pa, mpa kil ntiwe kawor yipmingki wunen a Maur Wailen itna wailen ikgalen pa. Kol kalpis pa, mpa kalpis.” ");
INSERT INTO urim_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ari Nikotimus pa lala, “Iss! Ake kolpa! Kin nangkwor a mel nangkwor pa mpa wa palng weten pa la kolai? Aki antiwe kin nangkwor a mel nangkwor pa mpa wa kawor ipma a man pa, atom kil wa rakuwel nti ur?” ");
INSERT INTO urim_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ari Sisas akalmpe la, “Kupm lanakeitn aklale la, kol Maur Wor a Maur Wailen a u ti ake antokg melnum palng weten pa, melnum pa akentiwe mpa kawor yipmingki wunen a Maur Wailen itna wailen ikgalen pa. ");
INSERT INTO urim_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Melnum a kanokg ti raku warim pa, kil raku melnum. Maur Wor a Maur Wailen raku warim pa, pa kol kil uk maur wor weten melnum atom kil antiwe katnun nol nikgwalpm a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ampur kitn wrekg paipm eng yangkipm a wet kupm lanakeitn la, kipm mpa elngen Maur Wor a Maur Wailen ntokgtepm palng weten kol warim a man raku weten pa. ");
INSERT INTO urim_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kolen wripm a el pa kil el ak wasrongen alkil. Mentepm atning milpming alkil pake, ake mentepm ariwe la kil el a pa wli aki a ti kai pa, kalpis. Pati melnum a Maur Wor a Maur Wailen antokg palng weten pa am kolpake.” ");
INSERT INTO urim_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikotimus wa asentel la, “Kitn la Maur Wor a Maur Wailen antokg melnum palng weten pa itna kolai?” ");
INSERT INTO urim_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ari Sisas akalmpe la, “Kitn pa melnum ariwe a Isrel a kaling plan tu, pake wa kitn akwekgel pa! ");
INSERT INTO urim_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kupm lanakeitn aklale wrisen, men laron kuina ur a men ariwe a pikekg men nungkulkg a wulmpa pa, ari ake wa kipm atopen awi yangkipm pa la yangkipm pa aklale pa. ");
INSERT INTO urim_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kupm laron kweikwei a itna kanokg ti, ari ake wa kipm ukipma katnun. Ti kol wa kupm laron nikepm kweikwei a itna kaino anong wor ai pa, pa mpa wa kipm wa ukipma kutnun la kolai? ");
INSERT INTO urim_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ake pikekg melnum ur kaino Anong Wor pa atom wa nar kanokg ti lakati nakepm pa, kalpis. Warim Kipman wris a Melnum pa kolti pikekg rpma kaino Anong Wor pa, atom kil ariwe kweikwei a itna kaino pa, atom kil nar lakati nakepm pa. ");
INSERT INTO urim_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pikekg Moses ngkat kweiur a kalingen a ari kolen ul pa, atom ak alm itna yo pa aye itna wrik wes ningkrapm kalpmilel pa, la tu melnum a ngkit ikg ikitnen ul pa, tu ake mpa imo, tu mpa rpmi. Ikg am wa tu ik irir kolpake. Tu ikga wa ngkit Warim Kipman a Melnum pa iye kaino kurkurng rki yo okgmangki kolpake. ");
INSERT INTO urim_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kolpa atom kol mla ur kil ukipma kutnun kil pa, kil mpa uwi yaprekg watin akilen atom kil ikga rpmi wor yongkyong. ");
INSERT INTO urim_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kolpa atnen Maur Wailen kil plan ipma wor wasrongen kipm wrongkwail kin a kipman a kanokg ti. Atom kil ukwa Warim Kipman yek wris anangket alkil pa nar akarmpentepm, eng ikgake melnum wris ur a ukipma kil pa kai paipm, kalpis. Kil ikga uwi yaprekg watin eng rpmi wor yongkyong. ");
INSERT INTO urim_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yiprokgen a Maur Wailen kil ukwa Warim Kipman alkilen pa nar kanokg ti eng ake la ntokg yangkipm nimpikgen kipm wrong kin a kipman a kanokg ti, atom la kipm ikga uwi wleket. Kil ukwawel nar eng la ik uwiyepm iye yaper kai eng kil alkil. ");
INSERT INTO urim_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mla ur kil ukipma Warim Kipman pa, ikgake Maur Wailen ntokg yangkipm nimpokgen kil pa. Mla ur kil ake ukipma kil pa, kil am itna antokg yangkipm ise. Atom yangkipm pa la kolkil: kil ake ukipma Warim Kipman yek wris anangket a Maur Wailen pa ti kil ikga uwi wleket. ");
INSERT INTO urim_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tu melnum a kolpa pa Maur Wailen pikekg la ise, la tu ikga uwi wleket itnen yiprokgen kil: Warim Kipman pa kil wakg a pikekg nar kanokg ti ise, pake wrong kin a kipman ti antokg paipmpaipm kolpa atom tu plan ipma wor wasrongen miningket pa, a tu karken wakg klalen ti. ");
INSERT INTO urim_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mla ur a antokg paipmpaipm pa awi wrongmanto lan klalen ti a kil karken a kul kai itna kai klalen pa. Kil karken mpa klalen pa ak alen paipmpaipm a kil pa kai angko wunong. ");
INSERT INTO urim_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pake mla ur a katnun nikgwalpm ute aklale pa kil kai itna kai klalen. Pake klalen pa plan angko wunong la kwap a kil ak pa la pa kil katnun nikgwalpm a Maur Wailen.” ");
INSERT INTO urim_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Sisas nampokgen tu watnom a kil aroaro wonel pa tu rka anong wail Serusalem pa plalng pa, tu atnuurng anong wail pa tu kai rka tatu wrik mpang a anong kanokg Sutia pa. Tu rka pa wang watin ur, atom kil kaluk tu wrong kin a kipman. ");
INSERT INTO urim_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ak wang pa Son a kaluk tu pa wa ak ak kwap kaluk tu wrong kolpa itna kaino wrik Ainon a itna wreren anong Salim, pa wrik a u watipmen arke. Tu wrong kin a kipman wli wli la kil kuluken atom kil kaluken kolpa itna. ");
INSERT INTO urim_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Pa la wang a pikekg Son kil akwap kaluk tu kolpa itna, a wang a pikekg tu arkulel aye kai rpma wan tipmining pa, a pa. ");
INSERT INTO urim_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Atom wang ur pa, tu watnom a Son a kil aroaro wonel nampokgen melnum ur a mentepm almentepm Suta pa, tu alilakel tita ya a karkuk eng mpa palng kukula wor itni wulmpa a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tu watnom a Son pa tu ipma kalkut, atom tu kai ariwel a lanakel la, “Melnum a aroaro wonel men, kitn wonarpme melnum a pikekg antiweitn itna kai u kop wompel Sotan pa? Pikekg kitn laron nako aktitnongketel la, kil pa melnum a pikekg Maur Wailen la ukwa kil nar pa, kil itna akwap kaluk tu kol kitn tike. Atom tu kimeket kaingkai eng kil kaluken.” ");
INSERT INTO urim_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ari Son akalmpe la, “Kol Maur Wailen ake yapon melnum eng kwap ur pa, kil ake antiwe akwap pa. ");
INSERT INTO urim_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kipm alkipm pikekg atning a kupm laron kupm alkupm pa la, kupm ake Krais, melnum a pikekg Maur Wailen la ukwa nar ik rmpen mentepm wrong kin kipman pa, kalpis. Kupm kil pikekg Maur Wailen yapontopm la kupm numprampen ya elng itna ep eng Krais pa.” ");
INSERT INTO urim_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Son wa lanaki tu watnom a kil aroaro wonel pa la kolpa kai, “Sisas pa kol kipman a la kul uwi kin pa iye, a kupm ti pa kol melnum wor alkil a numprampen ep eng kil kul uwi kin pa iye pa. Kipman a la uwi kin pa iye pa, kin pa am a kipman pake. Pake melnum wor alkil a numprampen ep pa, kil itning ok kromeng a kipman awi kil pa aye pa, pa kil atopen paipm eng atning ok kromeng a kipman pa. Eng ntei, kwap a kil numprampen ep pa angko oken ise. Am kupm ti kolpa yat pake: kipm kul lanakopm yangkipm ti la tu wailet kai eng Sisas pa, atopen akupmen pa kul plalng kolpake. ");
INSERT INTO urim_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kolpa ti Sisas pa palng melnum wailen o! A rku kupm ti kinar o! Kolpa ute wor pake. Pa pikekg Maur Wailen akwonalmpen ep ak ai la ikga palng kolpake! ");
INSERT INTO urim_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Melnum a angkaino kwa pa nar pa, kil pa melnum itna ep angen kweikwei wrongkwail. Melnum a kanokg ti pa pati, am a kanokg tike. Melnum a kanokg ti kil la kweikwei a kanokg ti kolti. A melnum a pikekg angkaino Anong Wor pa nar pa, ");
INSERT INTO urim_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","kil laron kuina ur a pikekg kil atning a ari pa aktitnongketel la pa aklale. Ari ake wa mla ur atopen awi la yangkipm a kil la pa aklale pa. ");
INSERT INTO urim_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mla ur a atopen awi yangkipm a pikekg melnum a angkaino kitnong nar laron pa la aklale pa, kil pa ak titnongketel la kuina ur a Maur Wailen kil la pa, pa kil la ute aklale wrisen. ");
INSERT INTO urim_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Eng ntei, melnum a pikekg Maur Wailen ukwa nar pa, kil lakati nikgwalpm a oklala a Maur Wailen la pa. Kil antiwe antokg kolpa atnen a Maur Wailen ake alkel Maur Wor pa alung kol u pa waiketn a waiketn pa, kalpis, kil alung akwrisel kimeket kolti. ");
INSERT INTO urim_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yan kil plan ipma wor wasrongen Warim Kipman alkilen pa, atom kil elng kweikwei wrongkwail ti kai wam akilen la kil ikglen. ");
INSERT INTO urim_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Melnum a kil ukipma Warim Kipman pa, pa kil awi yaprekg watin atom rpma wor yongkyong. Pake melnum a talpulng ok a Warim Kipman la pa, melnum pa ake awi yaprekg watin eng kil rpma wor yongkyong pa. Maur Wailen ipma wakget eng melnum pa kolpa rpma.” ");
INSERT INTO urim_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Wailen Sisas kil atning a tu lakati la tu melnum a arpmen yangkipm yiprokgen a Moses atning a kil ti arkolng melnum wailet ai kul katnuntel, atom kil arowonelen, a kil kaluk tu wailet angen Son ai. ");
INSERT INTO urim_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ake Sisas kil alkil ti kaluk tu pa, kalpis. Pa tu watnom a kil aroaro wonel pa ak pake. ");
INSERT INTO urim_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Sisas atning a tu melnum a arpmen yangkipm yiprokgen a Moses pa atning ari kil ti kolpa atom kil la itnuurng anong kanokg Sutia pa a wa la yaper kaino anong kanokg Kalili. ");
INSERT INTO urim_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ya a kaino Kalili pa or anong kanokg Samaria pa kaino, atom kil mpa lekgen tu watnom a kil aroaro wonel pa or ya Samaria pa kaino. ");
INSERT INTO urim_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tu or pa kaino palng kaino anong ur a Samaria a tu namput la Sikar. Anong pa ela wreren kanokg a pikekg Sekop uk warim kipman alkilen Sosep, tuwekg yoampei amenen. ");
INSERT INTO urim_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Angko wrik pa, u yaur a Sekop akwle pa rka. Tu angkom kaino angko u yaur pa, takgni no pirng. Takgni alel a uwaketel a nepm amowel paipm atom kil rpma pa eng yapm. ");
INSERT INTO urim_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kil rpma ari kin ur a Samaria pa wli anong u. Atom Sisas kil lanakel la, “Inong u ur pa iye kul eng kupm il!” ");
INSERT INTO urim_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ak wang a kin pa wli anong u pa, Sisas kil alkil wris rpma. Tu watnom alkil pa tu kai armpen okipma kai anong pa. ");
INSERT INTO urim_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kin Samaria pa atning yangkipm a Sisas la pa atom kil wrekg paipm akalmpe la, “Kitn pa a Suta, a kupm ti pa kin a Samaria, ti wa kitn asentopm la kupm lkeitn u pa il eng itna kolai?” Men Suta pa ake kai orwris anti tu Samaria ti pa, men itna man man, kolpa atom ari kin Samaria pikekg wrekg paipm eng Sisas antiwel oklala pa. ");
INSERT INTO urim_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Atom Sisas akalmpe la, “Kitn ake ariwe kweikwei wor a Maur Wailen la lkeitn kalpmlel pa. Kitn ake ariwe kupm a wet asenteitn la, kitn lkopm u ti il pa. Kol wet kitn riwe pa, kol a kitn pa wa isen kupm ti pa kol a kupm ti lkeitn u a rka yongkyong ti il.” ");
INSERT INTO urim_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ari kin Samaria pa la, “Melnum wailen, u pa rka angkinar watinet paipm ai. Ti kol a wet kitn iye numong ur a angklewe ampei watin pa atom ngkli elng kinar ik inong u pa. Kol kalpis pa, mpa kitn kai inong u a rka yongkyong pa kai a i? ");
INSERT INTO urim_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kitn pa akwonalmpen la kitn pa melnum wail angen yan Sekop yoampei amenen pake? Kil pikekg akwle u ti eng alkilen eng anong al ak antokg kweikwei, a anong uk manto nepm watin a manto walkg malkgu al al. Atom wa elng rka kolpa kulngkul, kul men ti anong anong tike.” ");
INSERT INTO urim_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ari Sisas akalmpe la, “Melnum a al al u ti pa, kil ikga wa u waketel ntiur. ");
INSERT INTO urim_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pake melnum la il u a kupm alkel pa, kil ikgake u waketel ntiur, kalpis. U a kupm alkel pa, pa palng kawor ipma akilen pa kul no kol u yaur a elng kul no antokg melnum pa rpma yongkyong.” ");
INSERT INTO urim_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kin a Samaria pa asentel la, “Melnum Wailen, pati kitn lkopm u pa eng kupm il, eng kupm ikgake perper kul inong u ti iye kai eng il eng kupm ikgake u waketopm pa.” ");
INSERT INTO urim_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Atom Sisas lanakel la, “Ti kitn kai ikyakur kipman alkitn pa, atom wa kipmekg wa kul.” ");
INSERT INTO urim_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kin Samaria pa la, “Kupm ti kipman kalpisen.” Ari wa Sisas akalmpe la, “Ei, kitn la pa aklale, kitn kipman kalpisen pake. ");
INSERT INTO urim_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pikekg kitn awi kipman wampwomis. Wa kipman a kitn awi ti pa, ake kipman a kitn pa, pa kitn awi aye rpma kolti. Yangkipm a kitn la pa aklale wrisen.” ");
INSERT INTO urim_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kin pa la, “Melnum wailen, kupm ari la kitn pa melnum okwripm a Maur Wailen pake. ");
INSERT INTO urim_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tu wapyipmiri walyipmiri a men Samaria pa pikekg kapor kilko alein Maur Wailen, a antiwel oklala kolpa ak ai kulngkul, kul wa men ti am wa ak yat kolpake itna wrik nangen Kerisim ti ikg kinar ari kinar ai. Pake kipm Suta pa la, wrik a kapor kilko alein a anti Maur Wailen oklala itnawe pa itna kinar Serusalem ai. Ti kitn akwonalmpen wrik a i wor?” ");
INSERT INTO urim_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Sisas lanakel la, “Kin, kitn ukipma yangkipm kil a kupm la lanikeitn kil: wangkur ikga palng a kipm ikgake kipor kilko ilein Yan ti itni kinar kinar wrik nangen Kerisim pa aki itni kinar kinar Serusalem pa kolti pa. Kipm ikga kipor kilko ileinsel itni yela tutu palpa. ");
INSERT INTO urim_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kipm Samaria pa kipm kapor kilko alein Yan Wailen, pake kipm ake ariwewel worwor. Pake kwap a Yan Wailen pikekg ak eng ak awi tu wrong kin a kipman ti aye yaper kai eng kil alkil ti pa, pikekg ngkaten ep itna men almen Suta tike. Kolpa atom men Suta ti pa men kapor kilko alein Yan Wailen a men ariwewel worwor. ");
INSERT INTO urim_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ikga ik wang a wet kupm lala ikga palng pa, tu melnum a wasrongen la kipor kilko ilein Yan Wailen pa ik ipma iklale pa, Maur Wor alkil ikga nar rpmi tu pa, atom ngklinsen eng tu itn a rpmi ikwap kitila nikgwalpm aklale a Yan Wailen pa. Atom tu ikga kipor kilko ilein Yan Wailen pa kolpa. Yan Wailen pa kil wasrongen la tu melnum pa kipor kilko ileinsel kolpake. Wang a ikga palng kolpa, am ngkaten ak wang ti aye kai tike. ");
INSERT INTO urim_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Maur Wailen pa kil Maur. Kolpa ti kol melnum ur la kipor kilko ileinsel pa, kil mpa elng Maur Wor pa plantel Maur Wailen pa la kil am aklale kolpake, wa elng Maur Wor pa lokel eng mpa kil kipor kilko ilein Maur Wailen pa iklale.” ");
INSERT INTO urim_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Atom kin Samaria pa la, “Kupm ariwe la Mesaya kil ikga nar pa. Tu namput la Krais. Kil ikga nar kanokg ti pa, ikga kil laron kimek kimek kweikwei wrongkwail ti niko.” ");
INSERT INTO urim_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ari Sisas akalmpe la, “Am kupm tike. Kupm a antiweitn oklala tike.” ");
INSERT INTO urim_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tuwekg oklala kolpa itna ari tu watnom a Sisas aroaro wonel pa yaper angkai anong pa kul palng. Tu wrekg paipm eng tu ari Sisas pa anti kin Samaria pa oklala. Ari ake tu ur asentel la, kil wasrongen kuina wai, aki kil antiwel oklala eng kuina wai. ");
INSERT INTO urim_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Atom kil elng u kuntuken pa rpma pa, atom kil pirng atatu ruyapm kai lakati naki tu kai anong ai, kil lanaken la, ");
INSERT INTO urim_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Kipm pa, kipm kul eng mentepm kai ri melnum ur a kil lanakopm kweikwei wrongkwail ti pikekg kupm antokg pa. Pa mpam Krais pa ur pake?” ");
INSERT INTO urim_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tu atning a kil la kolpa atom tu atnuurng anong pa a tu kaingkai eng Sisas. ");
INSERT INTO urim_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kin pa atnuurng kai pa, tu watnom a Sisas pa lanakel la, “Melnum a aroaro wonel men, kitn il okipma wet men kai armpen aye wli ti!” ");
INSERT INTO urim_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ari Sisas akalmpe la, “Okipma a kupm al pa rmpa pa, pake kipm ti ake ariwe.” ");
INSERT INTO urim_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Atom wa tu watnom alkilen pa anel asen tita la, “Kil ti wet melnum ur wli alkel okipma ur aki?” ");
INSERT INTO urim_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Sisas naken la, “Okipma akupmen pa la kupm kitila nikgwalpm a kil a pikekg ukwawopm nar pa, a wa ikwap akilen pa kai iro yiprokg. ");
INSERT INTO urim_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kipm la kolpa la, 'Kainil wikgwikg pa kai plalng pa, wang a angket tuwai pake.' Ari kupm ti la kolkil la, kipm ri wring pa kaino ware a kinar kwak pa ri! Wring pa am tukgun kakir antiwe a angket tuwai tike. ");
INSERT INTO urim_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Atom melnum a angket tuwai pa kil am awi kweikwei wor wor akalmpe kwap a kil ak pa itna tike. Kil takwem okipma kweikwei pa aye kawor itna wan okipma pa eng ikga rmpi wor yongkyong. Atom melnum a angket tuwai pa anti melnum a alin pa tuwekg atopen yatenen. ");
INSERT INTO urim_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kolpa ti yangkipm a kipm lala, 'Melnum ur pa alin a melnum ur manet pa angketuwai pa', pa am palng aklale tike. ");
INSERT INTO urim_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kupm ukwawepm la kipm kai ngket tuwai okipma a ake pikekg kipm ti aken kwap eng alin pa. Palpa kipm angket tuwai okipma wunongket a pikekg tu melnum manet ai aken kwap ai.” ");
INSERT INTO urim_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tu Samaria wailet a rka anong Sikar pa, tu ukipma Sisas. Eng ntei, tu wet atning a kin pa lakati naken Sisas pa la, “Melnum pa kil laron kweikwei wrongkwail a kupm antokg ak ai kulngkul kul ti.” ");
INSERT INTO urim_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tu Samaria atning kolpa, atom tu wrekg la kul eng Sisas. Tu kul palng pa tu la titnongket naki Sisas pa la kil kai ntiwen rpmi. Atom kil alekgen tu watnom a kil aroaro wonel pa kai antiwen rpma wang wekg. ");
INSERT INTO urim_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tu atning yangkipm a kil angkli pa, atom tu tiur manet pa wa ukipma kai aken tu wailet ai. ");
INSERT INTO urim_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Atom tu lanaki kin pa lala, “Kitn pikekg laron Sisas pa nako, atom men ukipma kil. Pake ak wang ti men alpmen ti atning yangkipm a kil alkil ai la, atom men ariwe la kil pa melnum a ak awi mentepm wrong kin a kipman a rka kanokg ti aye yaper kai eng kil alkil pa am aklale pake.” ");
INSERT INTO urim_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sisas pa anti tu watnom alkilen pa rpma anong Sikar pa wang wekg pa plalng, tu wrekg a pa la wa ngkom kolpa kaino anong kanokg yiprokg alkilen Kalili ai. ");
INSERT INTO urim_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Pikekg Sisas kil alkil ari ak wulmpa atom kil pikekg lala, “Melnum okwripm a Maur Wailen pa kil rpma anong kanokg a tu mamikg mamin mansan alkilen pa, tu alkilen pa tu arku nang akilen pa la kil ake melnum okwripm a Maur Wailen pa.” ");
INSERT INTO urim_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tu wa kaino kolpa kaino palng kaino anong kanokg yiprokg alkilen Kalili pa, tu wrong kin a kipman a rka pa tu atopentel a awiyel aye kai. Tu wailet pikekg kinar kai kaino anong wail Serusalem ak wang wail a atopen a pikekg Maur Wailen awi tu amenen pa aye kul wor takwleikgen tu Isip pa. Atom tu pa pikekg ari a Sisas kil antokg kweikwei titnongket tiur itna kinar kai kaino Serusalem ak wang wail pa, kolpa atom ari tu atopentel itna no Kalili tike. ");
INSERT INTO urim_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sisas atn kolpa or wrik kanokg a Kalili pa kolpa kai kaino palng kaino anong Kana. Pa anong a pikekg Sisas rpma, atom antokg u pa palng u wain atnewe pa. Ak wang pa warim kipman a mring man ur pa numpet paipm rmpa kai kaino anong Kaperneam. Mring man pa ikgalen tu melnum akwapel a melnum tukgunakg a ikgalen anong kanokg Kalili pa. ");
INSERT INTO urim_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mring man pa kil atning a tu la Sisas pa kil pikekg angkinar anong kanokg Sutia pa no anong kanokg Kalili ti, ti rpma no anong Kana a anong kanokg Kalili ti. Atom mring man pa angkaino Kaperneam pa nar kul anong Kana ti lanakel la kil ntiwel kai kaino Kaperneam pa ntokg warim kipman akilen a wreren eng a imo pa, palng wor. ");
INSERT INTO urim_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Atom Sisas lanaki yan a warim numpet pa la, “Kol ake kipm ari kla a kupm elng itna ak plan titnongket a Maur Wailen, a kweikwei a kupm antokg a melnum wrekg paipm eng ari pa, kipm ake la ukipma.” ");
INSERT INTO urim_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Atom mring man a melnum tukgunakg pa aye uwel Sisas pa la, “Melnum wailen, kitn kul eng mentekg kai kaino itatu ep pen, warim akupmen ti wreren eng a imo tike.” ");
INSERT INTO urim_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ari Sisas akalmpe la, “Kitn kai kaino o! Warim kipman akitnen ake mpa imo, mpa wor pa.” Atom mring man pa kil ukipma yangkipm a Sisas la kolpa, atom kil kai kaino. ");
INSERT INTO urim_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kil angkom kolpa kai kaino pa, tu melnum akwapel tiur alkil pa nar ansilel angko ya pa atom tu lanakel la, “Warim kipman akitnen pa ake amo, am numpworen ti wrekg rpma ise.” ");
INSERT INTO urim_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kil asenten la, “Kil palng wor ak wang kolai?” Ari tu akalmpe la, “Pikekgkil takgni no pirng plelng pa amo numpwakget a kil pa kupuk wor om.” ");
INSERT INTO urim_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yan pa atning kolpa, kil ariwe wang ketn a pikekg Sisas lanakel la, “Warim kitn ake mpa imo, mpa wrekg wor rpmi pa.” Kolpa atom kil alkil ti a tu kin a watnom alkil pa, a wa tu a antiwel rka wan wris pa tu ukipma Sisas pa. ");
INSERT INTO urim_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Sisas pikekg atnuurng anong kanokg Sutia no anong kanokg Kalili ti pa, kil elng kla ur itna eng ak plan titnongket a Maur Wailen pa, wa kil yaper kinar, plalng, wa kil no ti pa, kil wa elng kla titnongket ur ti wa itna atom aken tita kil elng kla titnongket wekg alkil pa elng itna anong kanokg Kalili ti ise. ");
INSERT INTO urim_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Sisas rpma anong kanokg Kalili kolpa kai angko wreren wang wail ur a men Suta wli wli takwem rka wris no anong wail Serusalem ti eng ngkat nang a Maur Wailen pa, atom Sisas la yaper nar kul no Serusalem ti. ");
INSERT INTO urim_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Itna Serusalem ti u yaur wail a pikekg tu akwle pa rka. U yaur pa tu akwe ak ok Ipru pa la Petesta. U pa rka wreren yipmingki yayun a anong wail pa, tu namput la Yipmingki Yayun a Manto Walkg Malkgu pa. Wan okore wail wampwomis pa ela yamping a u yaur pa. ");
INSERT INTO urim_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tu melnum numpet watipmen pa anel okg klilklil rka wan okore wampwomis pa. Tu melnum a wulmpa tilmpisen, a nepm paipmen, a nepm wam plupmen a num traimingen pa. Tu nungkwangen la mpa u yaur pa tiklas. ");
INSERT INTO urim_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Maur akwapel a Wailen pa nar nar u yaur pa ak wangklawe atom ak ak klaingkel u yaur pa tiklas. Atom tu melnum numpet pa okg rka atning u a tiklas pa, tu aken tatu kai kinar u yaur pa. Melnum ur a kil kinar naren u pa ep pa, numpet kolai kolai a itna kil ti pa, kil mpa palng wor. ");
INSERT INTO urim_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Melnum wris ur a rmpa pa numpet rmpa wrik pa wring kamel wris tuwek wampwam yikakwomis yikakwompwraur. ");
INSERT INTO urim_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Sisas kil wli palng rpma Serusalem, atom wang ur pa kil wrekg kai u yaur Petesta pa, pa kil ari melnum a kil rmpa kanokg pa. Kil ariwe la, pa kil yek pikekg numpet rmpa wang watin paipm. Atom kil asentel la, “Kitn la kitn a palng wor?” ");
INSERT INTO urim_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ari melnum numpet pa akalmpe la, “Wailen, kupm melnum kalpisen a angklinsopm aye kinar u yaur pa ak wang a u pa tiklas pa. Kupm la mpen kinar pa, tu melnum tiur ai akoporopm kinar ise.” ");
INSERT INTO urim_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Atom Sisas lanakel la, “Wrekg ngkit wrik alkitn ti ngkom kai o!” ");
INSERT INTO urim_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Melnum pa palng wor pinterngen kolti, kil wrekg ngkat wrik alkilen pa kolti, kil angkom kai. Sisas antokg melnum pa palng wor pa, pa ak wang wail a men rpma eng yapm. ");
INSERT INTO urim_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kolpa atom tu melnum wailen wailen a men Suta pa ari pa atom tu lanaki melnum a wuten Sisas antokg numpet a kil pa wor pa la, “Pa kitn kapor yangkipm titnongket a mentepmen eng kitn akwap a ngkat wrik ti aye ak wang wail a kitn kol a rpmi eng yapm ti.” ");
INSERT INTO urim_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ari kil akalmpe la, “Melnum a antokg numpet akupmen ti palng wor pa tilpopm la kupm wrekg ngkit wrik ti ngkom kai.” ");
INSERT INTO urim_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Wa tu wa asentel la, “Melnum mla wuten lanakeitn la kitn wrekg ngkit wrik a kitn ti atom kitn iye kai pa?” ");
INSERT INTO urim_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ari melnum a palng numpworen pa kil ake ariwe melnum a antokg numpet a kil ti palng wor pa, eng ntei, Sisas pa am angkom ak aroaro wrong kuin pa kai ise, kil ake itna. ");
INSERT INTO urim_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Wangkur ti pa Sisas ansil melnum pa angkawor yipmingki wunen a yalming a Maur Wailen pa, atom kil lanakel la, “Kitn itning, numpet a kitn ti am palng wor ise. Pikekg kitn antokg paipmpaipm pa atom a pawo! Wa kitn wa ntokg kolpa iye kai pa, kitn ikga uwi paipm klangkil pa.” ");
INSERT INTO urim_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Melnum pa wrekg kolti yaper kai lanaki tu melnum wailen wailen a men Suta pa la, “Melnum a pikekg antokg numpet a kupm pa palng wor pa pati, pa Sisas.” ");
INSERT INTO urim_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sisas antokg numpet kweikwei ak wang wail a men rka eng yapm pa atom tu melnum wailen wailen pa tu ngkaten eng la orel a ungkwantel. ");
INSERT INTO urim_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Sisas lanaken la, “Akangklei wang pa Yan akupmen am akwap kolpa kul pake. Wa kupm ti pa am wa akwap kolpake.” ");
INSERT INTO urim_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tu melnum wailen wailen a men Suta atning a Sisas la kolpa, atom tu ipma wakget nikgwalpm arkekgen akor ya la orel imo, la kil kapor yangkipm titnongket a wang wail a kol a rpmi eng yapm pa. Yiprokgen a tu la orel imo pa pati ake la kil kapor yangkipm titnongket a itna la ake mpa ikwap ik wang wail pa wris pa, wa kil wa akwe Maur Wailen pa la Yan alkilen. Kil la kolpa pa, kil ngkat kil alkil ti la kil ti irir kolen Maur Wailen ai. ");
INSERT INTO urim_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tu melnum wailen wailen a men Suta arki Sisas kolpa, atom Sisas akalmpe lanaken la, “Kupm lanakepm aklale wrisen, Warim Kipman ti ake antiwe antokg kwei ur ak nikgwalpm a kil alkil pa. Kil ari kuina ur a Yan pa antokg pa, atom kil antokg katila. Kuina ur a Yan pa antokg pa, Warim Kipman am wa antokg kolpake. ");
INSERT INTO urim_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yan Wailen pa kil wasrongen Warim Kipman alkilen pa. Atom kil plantel kweikwei wrongkwail a kil alkil antokg pa. Aklale, ti a kipm ari a kil antokg ti pa waiketn, ikga kil wa plantel kweikwei wail wail eng kil ntokg kitila pa, ti kipm ikga wa wrekg paipm eng ri pa. ");
INSERT INTO urim_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kol Yan kil la tu melnum a amo kaingkai ai pa wa wrekg rpmi pa, am wa kolpake, Warim Kipman mpa wa la melnum a amo pa wa wrekg rpmi. Kil alkil la mla a i wrekg rpmi pa, pa itna katila nikgwalpm a kil alkil ti. ");
INSERT INTO urim_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Wa Yan pa ake wa akwap a rpma atning yangkipm a melnum ur pa, atom arila wor a paipm a kil antokg pa. Kil uk kwap pa kimeket kul Warim Kipman alkil tike. ");
INSERT INTO urim_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kil ak kolpa eng mpa tu a alupm aye kil Yan pa, mpa wa tu wa lupm iye Warim Kipman ti kol pake. Kol melnum ur ake alupm aye Warim Kipman ti pa, pa kil ake wa alupm aye Yan a pikekg ukwawel nar pa. ");
INSERT INTO urim_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Kupm lanakepm aklale wrisen la, mla ur kil itning yangkipm akupmen atom ukipma kil a pikekg ukwawopm nar pa, kil mpa uwi yaprekg watin a antokg kil mpa rpmi wor yongkyong. Kil ikgake itni yangkipm wail pa. Kil am apo angen amo pa kul itna kul wompel kil ise, atom ikga rpma wor yongkyong. ");
INSERT INTO urim_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kupm lanakepm aklale wrisen, wang ur ikga palng, ti wang am tike, am ngkaten ak ti aye kai tike, atom tu melnum a katnun ya a ikga kai imo pa, tu mpa itning ok a Warim Kipman a Maur Wailen pa. Atom tu mla ur itning kutnun pa, tu mpa uwi yaprekg watin atom tu mpa rpmi wor yongkyong. ");
INSERT INTO urim_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yan kil alkil pa kil yiprokgen a uk yaprekg watin melnum atom kil rpma wor yongkyong. Am wa kil wa antokg Warim Kipman alkil pa wa palng yiprokgen a uk yaprekg watin melnum eng kil rpma wor yongkyong. ");
INSERT INTO urim_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yan pa naren Warim Kipman a Melnum ti, la kil rpmi itning yangkipm a tu melnum atom ri la wor a paipm a tu antokg pa. ");
INSERT INTO urim_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ampur kipm wrekg paipm eng pa, eng ntei, wang ikga palng eng tu melnum kimeket a amo kaingkai pa tu ikga itning ok kromeng alkilen pa pipa, tu ikga wrekg wrekg i kirkap pa. ");
INSERT INTO urim_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Tu melnum a pikekg antokg nikgwalpm wor wor kolpa kai pa, tu ti ikga wrekg rki wor yongkyong. A tu melnum a pikekg antokg nikgwalpm paipm kolpa kai pa, tu pa ikga wrekg itni yangkipm wail atom uwi wleket ikilmpe paipm a tu antokg pa. ");
INSERT INTO urim_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Kupm ake antiwe antokg kweiur ak kupm alkupm ti pa, kalpis. Kupm rpma atning kweikwei a tu melnum antokg pa, atom kupm ari la tu antokg wor aki tu antokg paipm eng mpa ikilmpe kitila pa. Pa kupm ak katila kol a melnum a ukwawopm nar la pa. Kupm ake ari la katila wasrongen a kupm alkupm ti pa, kupm ari la katila wasrongen a melnum a ukwawopm nar pa kolti, kolpa atom kupm ak ute wor.” ");
INSERT INTO urim_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Wa Sisas la kolpa kai la, “Kol kupm alkupm wris ti kolti iktitnongketel yangkipm a kupm alkupm ti nikepm la pikekg Maur Wailen ukwawopm nar ti pipa, pa ake yangkipm kaikut antiwe mpa ik titnongketel yangkipm pa la pa aklale pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pake melnum ur manet a ariwe kupm ti pa rpma, kil Maur Wailen Yan akupmen, atom kil pa wa laron kupm ti nakepm la pa aklale. A kupm ariwe la, yangkipm a kil laron kupm pa aklale. ");
INSERT INTO urim_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Wa kipm ti pa, kipm pikekg ukwa tu melnum tiur a awi ok akipmen pa kai eng Son a kaluko, atom Son kil wa laron kupm ti ute aklale. ");
INSERT INTO urim_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pake kupm ake rpma ak yangkipm a melnum ti laron kupm ti pa aktitnongketel la kupm mla pa. Palpa kupm ngkat wonelepm kolti eng la kipm ukipma yangkipm a pikekg Son laron kupm ti, eng mpa Maur Wailen ikuwiyepm iye yaper kul eng kil alkil. ");
INSERT INTO urim_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Son pa kolen wakg a naruk wail alen yela. Kipm pikekg atopen wakg akilen pa itna wang waiketn kolti kai plalng. ");
INSERT INTO urim_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pake kupm antiwe kweiur manet a laron kupm ti ak titnongketel yangkipm a kupm ti la kupm ti mla pa: pa kwap a pikekg Yan Wailen kil alkopm pa la kupm ik kai iro yiprokg. Pa titnongket kalkut klangkil a pikekg Son laron kupm ti ep pa. Ti kwap wrongkwail a kupm ak yela pa plantepm angko wunong aktitnongketel la, kupm ti pa pikekg Yan Wailen pa ukwawopm nar pake. ");
INSERT INTO urim_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Wa Yan Wailen a ukwawopm nar pa kil wa lakati kupm ti aktitnongketel la pa aklale. A wa kipm ake wa atning oklala akilen pa aki ari ikgokg akilen pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Wa ake kipm arkul yangkipm a akilen pa katnun kolpa itna. Eng ntei, kipm ake ukipma kupm ti la kil ti ukwawopm nar pa. ");
INSERT INTO urim_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Wa kipm wa rpma ari ari wrkapm ti angkleikg, akor akor la mpa kipm nsil ya a awi yaprekg watin a antokg melnum rpma wor yongkyong pa ela wrkapm pake? Am wrkapm pa la ak titnongketel la ya pa am kupm tike. ");
INSERT INTO urim_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pake kipm ake la kul eng kupm ti, eng uwi yaprekg watin a antokg melnum rpma wor yongkyong pa. ");
INSERT INTO urim_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Kupm ake ak ak kwap ti lala kipm melnum pa lupm iye ngkit nang akupmen ti pa. ");
INSERT INTO urim_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pake kupm ariwewepm pa, kipm ake alupm nikgwalpm a plan ipma wor wasrongen Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Kupm awi ok a Yan alkupmen ai nar lanakepm yangkipm akilen, ari ake wa kipm atopen awi yangkipm a kupm laron nakepm pa. Pake melnum tiur ai wlintepm ak tu alntu pa, kipm wa atopen awi yangkipm a tu laron nakepm pa. ");
INSERT INTO urim_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Wa kipm wasrongen la lupm iye ngkit nangkel tita, pake kipm ake wa antokg kuina ur wor eng mpa Maur Wailen kil alkil wris pa kolti ngkit nangkelepm a kiporngkepm yangkipm pa. Kipm ak kolpa ti, pa mpa wa kipm wa ukipma yangkipm a kupm la ti kolai, pa mpa akentiwe. ");
INSERT INTO urim_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ampur kipm akwonalmpen la kupm ti pa ikga rkiwepm itni Yan pa. Melnum a ikga rkiwepm pa, pa ikgam Moses pake. Kipm pa ukipma akwonalmpen la ikga Moses pa itni yirokgel ngklinsepm ntokg yangkipm pake. Ari kolpa ikga kalpis. ");
INSERT INTO urim_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moses pa am pikekg nira yangkipm ak la kupm tike. Kolpa ti kol kipm ukipma yangkipm a Moses la pa pati, kol am wa kipm ukipma yangkipm a kupm ti la yat tike. ");
INSERT INTO urim_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pake kol ake kipm ukipma aklale yangkipm a Moses nira ela wrkapm pa, pa mpa wa kipm ukipma yangkipm a kupm la ti!” ");
INSERT INTO urim_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Sisas atnuurng Serusalem plalng pa, kil yaper kinar kai kaino anong kanokg Kalili, atom kil rpma pa pen. Wang ur ti pa kil alekgen tu watnom a kil aroaro wonel pa awi nim ukupuken pa angket ukupuk Kalili pa kai wompel ai. Nang wompel a ukupuk pa tu namput la Taiperias. ");
INSERT INTO urim_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tu wrong ak wail katnunten kai. Tu pikekg ari a Sisas kil antokg tu melnum numpet palng wor pa kolen kla a kil elngitna elngitna ak plan titnongket a Yan alkilen pa. Kolpa atom ari tu akwail katnunten kai. ");
INSERT INTO urim_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Atom tu watnom a kil aroaro wonel pa tu antiwel kaino rpma kaino wrik laikge kaino nang ai. ");
INSERT INTO urim_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Wang wail a men Suta wli wli takwem rka wris atopen atnen a pikekg Maur Wailen awi tu amenen pa aye kul wor takwlelkgen tu Isip pa am kul wreren tike. ");
INSERT INTO urim_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Sisas ngkat ikg pa ari yela ari kil ari tu wrong akwail pa wli wli eng kil ti. Atom kil lanaki Pilip watnom wris ur a kil aroaro wonel pa la, “Mpa mentepm rmpen okipma wailet ur kai a i eng uk tu wrong pa il?” ");
INSERT INTO urim_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kil asen la ik ri ipma a kil ti kolti tuwa, kil alkil alupm nikgwalpm ariwe ur rpma mpa kil ntokg pa. ");
INSERT INTO urim_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip akalmpe la, “Oi, pa ampake antiwe! Kol mentepm ntiwe marpm wes tangkoren kamel wampwam pa, pa antiwe a ak awi okipma wailet pake, pa ampake ntiwe tu pa. Pa mpa kai praras kolti. Pa antiwe melnum yek aripm ur kolti.” ");
INSERT INTO urim_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ari wris ur a tu watnom alkil pa Antru, wailen a Saimon Pita pa lala, ");
INSERT INTO urim_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ti warim kipman yek ur itna ti a aye nok tingklak wampwomis a yul tingklak wekg, ti ake antiwe mpa mpreing ik nirake wrong kin kipman wailet a itna ti.” ");
INSERT INTO urim_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Atom Sisas lanaki tu watnom alkil pa la, “Laniki tu wrong kin kipman pa eng tu rpmi tutu kanokg pa eng tu il okipma pa!” Atom tu lanaken. Wrik pa mi anip wailet atnewe, atom tu arku mi pa rpma yela tatu pa. Tu melnum pa wailet paipm. Kol ngkleikg tu kipman ikalkil pa palng wailet paipm kamel kamel (5,000). ");
INSERT INTO urim_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Atom Sisas awi nok tingklak pa aye itna, uk wor Maur Wailen, plalng pa, kapor uk tu watnom alkilen ampreing uk tu wrong kin a kipman a wet rpma pa al. Wa yul pa am wa kil ak katila kolpake. Tu al kolpa kaingkai, tu al nikgwor antiwe. ");
INSERT INTO urim_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tu al nikgwor antiwe plalng pa, Sisas lanaki tu watnom alkil pa la, “Kipm uwi okipma umpu umpu pa iye wli elngkitni wris eng ikga il! Itna kolpa mpa takote.” ");
INSERT INTO urim_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tu awi okipma umpu umpu wet tu al nikgwor atom angko itna pa awi alupm rkwa wail wampwam yikakwekg pa elngkirpma. ");
INSERT INTO urim_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tu wrong kin kipman pa tu ari kla titnongket a Sisas elngkitna ak plan titnongket a Maur Wailen pa, atom tu wrekg paipm lanaki tita la, “Yek ei, aklale wrisen! Melnum ti melnum ok wripm a pikekg Maur Wailen kil la ukwa nar kanokg ti am tike!” ");
INSERT INTO urim_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Sisas pa kil ari la tu pa la kai ikyakurel iye wli tirpmingen la ngkitel palng melnum tukgunakg eng itni ep ikglen anong kanokg a men Suta ti. Kolpa atom kil atnuurng tu pa a kil alkil wris kaino nang ai. ");
INSERT INTO urim_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nungkurikg ti pa, tu watnom a Sisas pa tu atnuurng Sisas pa itna kaino wrik nangen ai, a tu yaper nar ukupuk pa. ");
INSERT INTO urim_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tu rpma pa nungkwangen Sisas pa ari am kai miningket tike, a Sisas pa ake wa narnten. Atom tu tipra kaino nim ukupuken pa angket ukupuk pa la kul anong Kaperneam. ");
INSERT INTO urim_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tu angket or ukupuk pa kul pa, wripm mringmring wail pa el titnongket antokg ukupuk pa ngkat tapor tiklas kai pa kai pa paipm wrisen. ");
INSERT INTO urim_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tu angket or ukupuk pa kul angko kuin (5-6 km) pa, tu ari Sisas pa angkom or u kwa pa kul yupute nim ukupuken pa, atom tu ngkark paipm. ");
INSERT INTO urim_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ari Sisas lanaken la, “Ampur kipm ngkark, am kupm tike.” ");
INSERT INTO urim_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tu atning a kil la kolpa, atom tu wasrongen la mpa kil kaino ntiwen rpmi, ari kalpis, pinterngen kolti tu am palng kul wrik a wet tu la mpa kul pa ise. ");
INSERT INTO urim_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tu wrong pa tu itna kai ukupuk wompel pa kolpa itna nungkwangen Sisas pa. Tu pikekg ari nim ukupuken wris ata kolti rka kai pa, wa tu wa ari Sisas pa pikekg ake wa anti tu watnom a kil aroaro wonel pa tipra kaino nim ukupuken pa kul, kalpis. Tu ari tu watnom alkil kolti pikekg tipra kaino pa kul. Okg or kong ti tu am nungkwangentel kolpa rka pake. ");
INSERT INTO urim_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ari nim ukupuken tiur a anong Taiperias pa kai rka werpm wreren wrik a pikekg Wailen kil uk wor Maur Wailen eng okipma atnewe atom tu al nikgwor antiwe pa. ");
INSERT INTO urim_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tu wrong kin kipman pa ari la Sisas nampokgen tu watnom alkil pa ake rka kai pa, atom tu wrekg kolti, awi nim ukupuken pa angket ukupuk pa kul akor Sisas itna anong Kaperneam ti. ");
INSERT INTO urim_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tu wrong pa anel akor Sisas pa itna kul ukupuk wompel ti kolpa kai pa, tu ansilel, atom tu asentel la, “Melnum a aroaro wonel men, kitn wet or kolai?” ");
INSERT INTO urim_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ari Sisas akalmpe la, “Kupm lanakepm aklale wrisen, ake kipm akor kupm ti eng kipm ari kla titnongket titnongket a kupm antokg ti, atom kipm awi ariwe kupm ti la kupm mla pa, kalpis. Kipm katnuntopm ti pa atnen a pikekg kipm al okipma ti wailet nikg wor. ");
INSERT INTO urim_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ampur kipm aken kwap okipma a ikga kai plalng pa. Kipm iken kwap okipma a ikgake kai plalng. Pa okipma a alkepm yaprekg watin a antokg kipm rpma wor yongkyong. Okipma pa am Warim Kipman A Melnum ti alkepm tike. Maur Wailen Yan akilen pa kil alkil pikekg elng kla akilen pa itna kil ti la mpa kil ik kolpake.” ");
INSERT INTO urim_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Atom tu asentel la, “Mpa men ntokg kwap kuina eng mpa Maur Wailen uwi wor lawo pa?” ");
INSERT INTO urim_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ari Sisas akalmpe la, “Kwap a Maur Wailen awi wor lawepm pa pati kolpa: kipm ukipma kupm melnum a kil ukwawopm nar ti.” ");
INSERT INTO urim_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Atom wa tu asentel la, “Mpa kitn ntokg kuina weten ik titnongket akitnen pa, eng mpa men ri la pa kla akitnen, mpa men ukipma yangkipm a wet kitn la la Maur Wailen pikekg ukwaweitn nar pa. Mpa kitn ntokg kuina eng men ri? ");
INSERT INTO urim_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tu wapyipmiri walyipmiri a mentepmen pikekg tu al okipma mana itna kinar wrik wes ningkrapm kalpmlel. Kol a pikekg nira ela Wrkapm a Maur Wailen pa ak la Moses pa la, 'Kil pikekg alken okipma a angkaino anong wor ai nar eng tu al.'” ");
INSERT INTO urim_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Sisas akalmpenten la, “Kupm lanakepm aklale wrisen, ake pikekg Moses pa uk okipma a anong wor pa tu akipmen pa al pa, kalpis. Pa am Yan akupmen pa alkepm okipma wor aklale a anong wor tike. ");
INSERT INTO urim_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Eng ntei, okipma a Maur Wailen uk ti pa, pa la melnum pikekg Maur Wailen ukwa angkaino anong wor pa nar, atom uk yaprekg watin kipm wrong kin a kipman a kanokg ti.” ");
INSERT INTO urim_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tu akalmpe la, “Melnum Wailen, wa ik ti kai pa am kitn lko okipma kolpake!” ");
INSERT INTO urim_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Atom Sisas la prepmprepm kil alkil ti naken la, “Am kupm tike, kupm ti pa okipma a yaprekg watin a al eng rpma wor yongkyong. Melnum a kil kul eng kupm ti pa, kil ikgake nikgilmpel. A melnum a kil ukipma kupm ti pa, kil ikgake u waketel. ");
INSERT INTO urim_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pake kipm ti pa, kol wet kupm lanakepm pa, kipm ari titnongket a kupm ak pake, kipm ake wa ukipma. ");
INSERT INTO urim_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tu melnum a Yan kil alkopm pa, tu mpa kul eng kupm. A wa melnum a kul eng kupm ti pa, kupm ake mpa ungkwantel, mpa kalpis wrisen. ");
INSERT INTO urim_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kol ake kupm angkaino anong wor pa nar la ntokg kuina ur a kupm alkupm ti wasrongen pa. Kupm nar la ntokg kuina ur a melnum a ukwawopm nar pa wasrongen pake. ");
INSERT INTO urim_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kil a ukwawopm nar pa kil pa wasrongen la ikgake kupm utnuurng melnum yekwris ur a pikekg kil alkopm pa. Ikga kupm la atom tu ikga wrekg ik wang aimprek a wang ti kai plalng. ");
INSERT INTO urim_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kol nikgwalpm a Yan akupmen pa kil wasrongen la melnum a kil ari kupm Warim Kipman pa a ukipma kupm pa, kil pa awi yaprekg watin a Maur Wailen a antokg kil rpma wor yongkyong. Atom ikga kupm la, atom kil ikga wrekg ik wang aimprek a wang ti kai plalng.” ");
INSERT INTO urim_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ak wang a Sisas kil la, “Kupm ti pa okipma a angkaino anong wor ai nar”, pa tu melnum wailen wailen a men Suta pa atning kolpa, tu nikgwalpm paipm lawel watipmen ");
INSERT INTO urim_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","kolpa lala, “Palpa Sisas, warim kipman a Sosep, mansan a mentepm ariwe pa. Mpa wa kil wa la kil alkil ti la, kil pikekg angkaino anong wor ai nar?” ");
INSERT INTO urim_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ari Sisas akalmpenten la, “Elngen a kipm nikgwalpm paipm lawopm watipmen kolpa! ");
INSERT INTO urim_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Akentiwe mpa melnum ur kul eng kupm ti ik nikgwalpm alkilen pa. Mpam Yan kil a pikekg ukwawopm nar pa or ipmawel pa, kil antiwe kul eng kupm ti. Atom ikga ik wang aimprek a wang ti kai plalng pa ikga kupm la atom kil wrekg. ");
INSERT INTO urim_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nira ela wrkapm a tu melnum okwripm pa la kolkil la, 'Maur Wailen pa kil ikga kiling plan tu wrongkwail kin a kipman pa.' Melnum a atning awi ariwe atom kil katnun Yan pa, pa kil kul eng kupm. ");
INSERT INTO urim_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ake melnum ur ari Yan pa, pa melnum a pikekg kil anti Maur Wailen pa rpma atom nar ti pa, kil wris pa ari Yan pake. ");
INSERT INTO urim_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kupm lanakepm aklale wrisen la, melnum a kil ukipma kupm pa, pa kil awi yaprekg watin a antokg kil rpma wor yongkyong. ");
INSERT INTO urim_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kupm ti pa okipma a yaprekg watin a al eng rpma wor yongkyong. ");
INSERT INTO urim_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tu wapyipmiri walyipmiri akipmen pikekg al okipma a tu namput la mana angkinar wrik wes ningkrapm kalpmlel pa. Ari ake wa tu rpma lantlan, tu am wa amo kaingkai ise. ");
INSERT INTO urim_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pake okipma a kupm la ti pa, pa okipma a angkaino anong wor ai nar, eng la tu melnum il pa, maur wor a tu pa ikgake imo. ");
INSERT INTO urim_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kupm ti pa okipma a rpma wor yongkyong a angkaino anong wor ai nar. Kol melnum ur il okipma kil pa, kil mpa uwi yaprekg watin a antokg kil rpma wor yongkyong. Okipma kil pa pati num akupmen a kupm uk tu wrong kin a kipman a kanokg ti eng mpa tu il eng rpmi wor yongkyong.” ");
INSERT INTO urim_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ari tu melnum wailen wailen a men Suta pa nikgwalpm paipm akle tita kolpa la, “Antokg kolai atom melnum ti la lko num a kil ti eng mentepm il ti?” ");
INSERT INTO urim_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Sisas lanaken la, “Kupm lanakepm aklale wrisen la, kol ake kipm il num a walmpopm a Warim Kipman a Melnum ti pa, kipm ake antiwe mpa uwi yaprekg watin pa rpmi kawor ipma akipmen pa. ");
INSERT INTO urim_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Melnum a al num a walmpopm akupmen pa, kil pa awi yaprekg watin a antokg kil rpma wor yongkyong. Wa ikga ik wang aimprek a wang ti kai plalng pa kupm ikga la, atom kil ikga wrekg rpmi. ");
INSERT INTO urim_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Num akupmen ti pa, pa okipma aklale, a wa walmpopm akupmen ti pa, pa u aklale. ");
INSERT INTO urim_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Melnum a kil al num a walmpopm akupmen ti pa, pa kil rpma kawor kupm ti, wa kupm rpma kawor kil pa. ");
INSERT INTO urim_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yan a ukwawopm nar pa kil Yan yiprokgen a uk yaprekg watin melnum atom kil rpma wor yongkyong. Atom kupm rpma yongkyong atnen a kupm awi yaprekg watin kai Yan ai. Am wa irir kolpa yat pake: melnum a kil al al kupm ti pa, kil wa rpma yongkyong atnen a kil awi yaprekg watin kul kupm ti. ");
INSERT INTO urim_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kupm kil okipma a angkaino anong wor ai nar. Tu walyipmiri wapyipmiri akipmen pikekg al okipma manet, kolpa atom ari ake wa tu rpma yongkyong, tu wa amo kaingkai. Pake melnum a al al okipma a angkaino anong wor ai nar ti pa, kil pa awi yaprekg watin atom kil rpma wor yongkyong.” ");
INSERT INTO urim_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sisas kil la yangkipm kil ak aro wonel tu itna wan a men atning atning yangkipm a Maur Wailen atnewe itna anong Kaperneam. ");
INSERT INTO urim_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tu melnum a katnun Sisas pa tu atning yangkipm a kil arowonelen pa, atom tu lanaki tita kolkil la, “Yangkipm pa wonet paipm ai, mpa mla itning pa?” ");
INSERT INTO urim_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Sisas kil ariwe tu pa tu akor la yangkipm pa watipmen, atom kil lanaken la, “Yangkipm wet a kupm la pa antokg kipm eng a kirken a ukipma aki? ");
INSERT INTO urim_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ti ikga kipm wa ikwonilmpen kolai, kol kipm ri kupm Warim Kipman A Melnum ti kupm wa yaper kaino wrik wrik a pikekg kupm arpme ep pa? ");
INSERT INTO urim_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Maur Wor a Maur Wailen pa kolti antiwe antokg melnum awi yaprekg watin atom kil rpma wor yongkyong. Pake titnongket a melnum ti pa ake antiwe antokg kwei ur. Yangkipm a kupm lanakepm ti pa, yangkipm a Maur Wor arpmen wa yangkipm a uk yaprekg watin melnum atom kil rpma wor yongkyong. ");
INSERT INTO urim_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pake tiur akipmen pa ake ukipma yangkipm a kupm la ti la aklale.” Sisas la kolpa atnen a kil ariwe ak wang a kil ngkaten kwap alkil ak ak ai kul ai pa kil ariwe ise la, tu mla mla ake ukipma kil ti pa. A wa kil wa ariwe la melnum mla ikga uk kil ti kai wam a tu wrongmanto. ");
INSERT INTO urim_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wa kil la kolpa kai la, “Kolpa atom kupm lanakepm la, ake antiwe melnum ur kul eng kupm ti ik wasrongen alkil pa, kalpis. Yan pa or ipma a kil pa pati, kil antiwe a kul eng kupm pake.” ");
INSERT INTO urim_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ak wang pa tu melnum a katnun Sisas pa atning a kil la kolpa, atom tu wailet pa almpil yirokg lawel atnuurngkel, a ake tu katnuntel om. ");
INSERT INTO urim_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Sisas wa asen kul tu watnom wampwam yikakwekg a kil aroaro wonel pa la, “Ti kipm ti, kipm la wa utnuurngkopm yat?” ");
INSERT INTO urim_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ari Saimon Pita akalmpe la, “Wailen, ti kitn la mpa men utnuurngkeitn kai eng mla? Am kitn pa yiprokgen a lanako yangkipm ok a alko yaprekg watin a antokg men rpma wor yongkyong pake. ");
INSERT INTO urim_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Men pikekg ukipma kitn pa kolpa kul, atom men ariwe worwor la kitn pa Melnum a Maur Wailen Amprin atom ukwaweitn nar pake, kolpa atom men ukipma kitn pa.” ");
INSERT INTO urim_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ari Sisas akalmpe la, “Kipm wampwam yikakwekg ti pa pikekg kupm alkupm ti takweiyepm kimeket, pake wris ur akipmen ti pa melnum a Maur Paipm Satan.” ");
INSERT INTO urim_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Pa kil la Sutas, warim kipman a Saimon Iskariot. Sutas pa melnum wris ur a tu watnom wampwam yikak wekg a kil aroaro wonel a ikga elng kil kai wam a tu wrongmanto. ");
INSERT INTO urim_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Sisas wrekg atnuurng anong Kaperneam pa, kil atn yela tatu anong kanokg Kalili ti kolti kaling plan tu wrong kin kipman yangkipm a Maur Wailen. Kil karken mla kinar anong kanokg Sutia pa. Eng ntei, tu melnum wailen wailen a men Suta pa yapon yangkipm la ilmpel imo. ");
INSERT INTO urim_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kil atn yela kolpa kai, wang wail a men Suta wli takwem rka anong wail Serusalem, ngkam pilmpal arke kalingen wang a pikekg tu a men angkom or wrik wes ningkrapm pa, am kul wreren tike. ");
INSERT INTO urim_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Atom tunteng paipm paipm a Sisas pa tilpel la, “Kitn itnuurng anong kanokg Kalili ti a kitn kinar anong kanokg a Sutia wai, eng mpa tu melnum a katnunteitn ai ri kwap weten a kitn ak ti. ");
INSERT INTO urim_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kol melnum ur la tu wrong kin kipman uwi riwe kil pa la kil mla pa, kil ake mpa ntokg itni ampen. Kil mpa ntokg itni wulmpa a wrongkwail eng mpa tu ri. Ti kweikwei titnongket titnongket a kitn antokg ti pa kol a kitn iye kinar ntokg kinar ai, ik plan kitn alkitn ti, eng mpa tu wrongkwail kin a kipman a itna yela kanokg ti riweitn la kitn melnum wailen ur kol pake!” ");
INSERT INTO urim_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tunteng paipm paipm a Sisas ti pa kol am tunteng pa ukipma pake, ari wa kalpis, tunteng aknokgel lawel kolpa. ");
INSERT INTO urim_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ari Sisas akalmpe la, “Wang wrongkwail pa wang a kipmteng pake, kai kipmteng pa kinar itopen wang wail pawo! Kupm ti pa kupm mpa kalpis, wang a kupm pa a pa. ");
INSERT INTO urim_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tu wrong kin a kipman a kanokg ti yiprokgen kalpisen eng mpa tu nikgwalpm paipm eng kipmteng pa. Pake kupm ti ariwe kweikwei a tu antokg pa ari paipm, atom kupm laron la pa aklale, tu am antokg antokg kolpake, kolpa atom tu nikgwalpm paipm eng kupm tike. ");
INSERT INTO urim_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kai kipmteng pa kinar itopen wang wail pawo! A kupm ti pa wang akupmen pa a pa, ti ake mpa kupm kinar itopen wang wail ti pa.” ");
INSERT INTO urim_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kil la kolpa atom kil am rpma Kalili pake. ");
INSERT INTO urim_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Atom tunteng paipm paipm alkilen pa tunteng wrekg atnuurng anong pa la kinar nti tu wrong pa tukwem rki wris kai kaino anong wail pa itopen wang wail pa. Tunteng kinar plalng pa, Sisas kil wa wrekg katnunten kinar atom kai kaino anong wail pa. Pake ake kil plan kil alkil ti angko wunong eng mpa tu wrongkwail ai riwel. ");
INSERT INTO urim_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ak wang aripm ur a tu rka atopen wang wail pa, tu melnum wail wail a men Suta pa tu ikgen akor asen tu wrong pa la, “Melnum pa itna kai a i?” ");
INSERT INTO urim_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tu wrong kin a kipman a rka pa tu akoo alilakel tita la Sisas pa. Tiur pa lala, “Kil pa melnum wor.” A tiur pa elukgentel la, “Kil ake melnum wor, kil melnum a kansil mentepm wrong kin a kipman atom aloko aye kai ar.” ");
INSERT INTO urim_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tu ngkark eng tu melnum wailen wailen a men Suta ti, kolpa atom ake tu akor la Sisas pa ak ok wail pa. ");
INSERT INTO urim_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Wang wail a men rka pilmpal pa wang wampwomis wampwompwraur. Atom ak wang wail ti pa men rka kolpa rka kai turngkuin pa pilpa, Sisas kai kawor yipmingki wunen a yalming a Maur Wailen pa ngkaten eng kaling plan tu wrong kin a kipman a rka pa. ");
INSERT INTO urim_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tu melnum wailen wailen a men Suta pa wrekg paipm kolti anel asen tita la, “Melnum pa ake pikekg melnum ariwe ur kaling plantel yangkipm titnongket amentepmen pa, ti antokg kolai atom wa kil kaling planto kolen kil alkil yiprokgen a yangkipm pa!” ");
INSERT INTO urim_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ari Sisas pa akalmpe la, “Ariwe a kupm kaling plantepm ti pa ake a kupm alkupm ti pa. Ariwe kil pa a melnum pikekg ukwawopm nar pake. ");
INSERT INTO urim_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kol melnum ur la kutnun nikgwalpm a Maur Wailen kil wasrongen pa pati, pa kil mpa uwi riwe la, yangkipm a i a Maur Wailen, a i a kupm ak nikgwalpm a kupm alkupm ti. ");
INSERT INTO urim_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Melnum a kil la yangkipm ak nikgwalpm ariwe a kil alkil ti pa, pa kil ak eng mpa tu a atning yangkipm a kil laron pa mpa ngkit nang akilen. Pake melnum a kil wasrongen la tu uk nang wailen melnum a ukwawel kul pa, pa kil ake melnum a alupm nikgwalpm a kansil pa, kil melnum a aye nikgwalpm ute aklale kolti. ");
INSERT INTO urim_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Pikekg Moses alkepm yangkipm titnongket pa, pake ake kipm ur atning katnun pa. Ti antokg kolai atom kipm wa la ilm kupm ti imo eng na wai?” ");
INSERT INTO urim_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ari tu wrong a rka pa akalmpentel la, “Kitn pa maur paipm arpmeweitn! Ti mla la ilm kitn pa imo?” ");
INSERT INTO urim_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Wa Sisas akalmpenten la, “Ti pikekg kupm ak kwap wris ur ak wang wail a mentepm rpma eng yapm pa, atom kipm plalngten akwonalmpen watipmen eng pa. ");
INSERT INTO urim_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kipm pa pikekg Moses alkepm yangkipm titnongket a angket num. Pa pikekg ake Moses pa ngkaten angket num a tu warim kipman pa. Pa pikekg tu yoampei yaru marpmeng wapyipmiri a walyipmiri alkipmen pa ak angkai ai kul ai. Moses ti pa wa angkine ak ak ti kul ti. Kol man ur raku warim kipman ur pa, kil mpa iyewel rpmi i wang wampwomis wampwompwraur pa, kipm mpa ngket num ik wang pa. Atom kipm am wa akwap angket num a tu warim tiur pa wa ak wang wail a rpma eng yapm pa yat pake. ");
INSERT INTO urim_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ti kol tu warim kipman tiur pa kipm mpa wa ngket num ik wang wail a rpma eng yapm pa pipa, kipm mpa angket, ake mpa kalpis pa. Eng ntei, kipm ake la kipor yangkipm titnongket a Moses la pa. Pake kipm wa kapor yangkipm titnongket eng kipm wa akwap pa ak wang wail a kipm kol a rpmi eng yapm pa. Ti antokg kolai atom wa kipm nikgwalpm paipm eng kupm a pikekg antokg numpwam, a nol nikgwalpm a maur wor a melnum pa palng wor kimeket ak wang wail a rpma eng yapm pa? ");
INSERT INTO urim_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kipm ari kwap wor a kupm pikekg ak pa ak wulmpa pa kolti, la kupm akwap ak wang wail a rpma eng yapm pa. Kipm elngen a ari la kwap a melnum ak pa kolpa! Kipm ri ute iklale kwap a melnum ak pa la kil akwap ute wor aki kil akwap paipm!” ");
INSERT INTO urim_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sisas oklala kolpa itna pa, tu melnum tiur a anong wail Serusalem ti asen tita la, “Ti melnum a tu lala ilmpel imo ti am tike! ");
INSERT INTO urim_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ti kipm ri, kil am oklala itna wulmpa a mentepm wrongkwail a rka tike, atom ake tu melnum wailen wailen ur angkengkel ti. Aki tu wa plelngen nikgwalpm a awi ariwe la kil ti Krais am pa ur pake? ");
INSERT INTO urim_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pake melnum ti pa mentepm ariwe anong yiprokg akilen pake, kolpa ti kil ake Krais. Pake Krais melnum a Maur Wailen lawen itna lala ikga nar pa, pa mentepm ikgake riwe la kil a a i wli.” ");
INSERT INTO urim_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Sisas pa kaling plan tu pa kawor yipmingki wunen a kapringen yalming a Maur Wailen pa. Kil la ak ok wail la, “Ei, kipm ariwe kupm ti a wa anong a kupm wliwe pa aki? Kupm ti ake wli ti ak nikgwalpm a kupm alkupm ti pa. Melnum a ukwawopm nar pa kil pa, kil melnum a antokg kweikwei a aklale. Ari kipm ake wa ariwe kil pa. ");
INSERT INTO urim_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pake kupm ti pa ariwe kil pa pati, atnen kupm am pikekg anti kil pa rpma pake, am kil pa pikekg ukwawopm pake. Kolpa atom kupm ariwe kil pa.” ");
INSERT INTO urim_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tu atning kolpa atom tu lala rkulel ari ake melnum ur wam kai la rkulel, eng ntei, wang alkilen pa a pa. ");
INSERT INTO urim_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pake tu wailet a rka atning a kil la kolpa, pa tu ukipma kil pa la kil pa Krais melnum a Maur Wailen ukwa nar pa. Atom tu lala, “Melnum ti elng kla titnongket wailet elngitna ak plan titnongket a Maur Wailen pa. Ti wa mentepm nungkwangen melnum ur a wai a ikga nar elng kla wailet klangkil kol a melnum ti elngitna pa eng na? Melnum a Maur Wailen la ukwa nar pa am itna tike!” ");
INSERT INTO urim_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tu melnum tiur a arpmen yangkipm yiprokgen a Moses pa tu atning a tu lanaken la tu wrongkwail akoo alilakel tita Sisas pa. Atom tu pa, a tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen pa ukwa tu melnum a atnen yalming a Maur Wailen pa eng la tu kai rkulel, atom tu kai. ");
INSERT INTO urim_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Atom Sisas la kolpa la, “Palpa kupm antiwepm rpma wang tukwok ketn kolti, atom kupm ikga wa yaper kaino eng melnum a pikekg ukwawopm nar ti. ");
INSERT INTO urim_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kipm ikga ikoropm, pake kipm ikgake riwopm. Eng ntei, wrik a kupm kaino pa kipm ikgake ntiwe kaino.” ");
INSERT INTO urim_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tu melnum wailen wailen a men Suta tu alntu ak nokgel naki tita lala, “Melnum ti kil lala ikga kil kaino wrik a i a ikgake mentepm riwel pa? Ikga kil kaino yela anong kanokg a Krik ai a tu tiur a mentepm Suta arpme ai eng kiling plan tu Krik pa, aki? ");
INSERT INTO urim_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Wa kil lala, mentepm ikga ikorel, pake mentepm ikgake riwel, wa anong a ikga kil kaino rpme pa mentepm ikgake ntiwe kaino, kil la kolpa eng itna kolai?” ");
INSERT INTO urim_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Men takwem rka pilmpal wris wris a men ngkam pa atopen wang wail pa, kolpa rka wang wail wampwomis wampwompwekg pa kai plalng pa, atom okg or kong ti pa wang aimprek, pa wang wail manten. Atom ak wang pa Sisas wrekg itna la yikakatnen lala, “Mla ur a u waketel pa kil kul eng kupm ti eng mpa kupm lkel u ti il! ");
INSERT INTO urim_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mla ur a kil ukipma kupm ti pa, u mreren wriwen wor a waroong atne ti mpa i nol nikgwalpm a kil pa kul no, atom pik turus or en ti kolpa kai, kolen wrkapm a Maur Wailen la pa.” ");
INSERT INTO urim_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Pa Sisas ak la Maur Wor a Maur Wailen a ak wang pa ake nar, a pa. Kil ikga kaino rki yo okgmangki imo, wa Maur Wailen ikga uwiyel yaperkaino anong wor lkel titnongket a nang wailen plalng pa pati, kil ikga ukwa Maur Wor pa nar kol u a tarus nar, atom tu a ukipma kil pa uwi. ");
INSERT INTO urim_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tu wrong kin kipman atning yangkipm a Sisas kil la kolpa atom tu tiur pa la, “Aklale, melnum ti pa kil melnum okwripm a Maur Wailen a mentepm nungkwangen am pake.” ");
INSERT INTO urim_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tu tiur pa la, “Kil Krais.” A wa tiur pa lala, “Krais ikga nar pa, kil ikgake ingkaino anong kanokg a Kalili pa nar pa. ");
INSERT INTO urim_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ti ake kipm ariwe la yangkipm a Maur Wailen a nira ela wrkapm pa la, 'Krais pa ikga man rakuwel kinar Petleem anong yiprokg a Tepit melnum tukgunakg akipmen pa, wa kil om wris a Tepit pa.'” ");
INSERT INTO urim_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Atom tu wrong kin a kipman pa womnowe womnare, arowom arowom atnen Sisas pa. ");
INSERT INTO urim_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tu melnum tiur la rkulel ari ake melnum ur arkulel. ");
INSERT INTO urim_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Atom tu melnum a atnen yalming a Maur Wailen pa anel yaper kul ari tu melnum tukgunakgen a ikgalen tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen nampokgen tu melnum a arpmen yangkipm yiprokgen a Moses a wet ukwawen la tu kai rkul Sisas pa. Ari tu asenten la, “Antokg kolai atom ake kipm arkul melnum ai aye wli?” ");
INSERT INTO urim_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ari tu melnum a atnen yalming pa lanaken la, “Ngkaten ak ai kul men pikekg ake atning melnum ur oklala kol melnum ti oklala ti! Oklala a melnum ti wa manet!” ");
INSERT INTO urim_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ari wa tu melnum a arpmen yangkipm yiprokgen a Moses pa asenten la, “Am kil pa kansil alokepm kai ar pake? ");
INSERT INTO urim_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Wa kipm atning la men mring man wail wail ur mapming a ikgalen mentepm Suta ti, kol men melnum a arpmen yangkipm yiprokgen a Moses ur ti ukipma kil pake? Kalpis wrisen! ");
INSERT INTO urim_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tu wrong pa rka wanteng won ai ake ariwe yangkipm titnongket a pikekg Moses alko pa, kolpa atom ari tu ukipma melnum pa. Maur Wailen am ok anti tu wrong pa ise atom tu ikga kai paipm.” ");
INSERT INTO urim_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pake Nikotimus melnum wris ur a tulntu melnum a arpmen yangkipm yiprokgen a Moses pa, kil melnum a pikekg kai ari Sisas pa ep ur ak ai, atom kil lanaki tu alntu pa lala, ");
INSERT INTO urim_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Yangkipm titnongket a pikekg yapon ti pa la, mpa mentepm uk wleket melnum ur ikilmpe paipm a mentepm arkiwel la kil antokg pa? Aki yangkipm titnongket a pikekg yapon pa la, mpa mentepm uwiyel iye kai itni yangkipm pa itning ri uwi riwe riworwor la kil ntokg paipm pa pipa, ikilmpe pa kutnukg kul?” ");
INSERT INTO urim_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tu melnum a arpmen yangkipm titnongket a Moses a tu melnum wailen wailen atning a Nikotimus la kolpa atom tu lawel la, “Yo, ti kitn ti am a Kalili pake! Kitn rpmi ngkleikg wrkapm a Maur Wailen ti riworwor, eng mpa kitn riwe la melnum okwripm ur pa ake mpa ingkai tu Kalili pa kul pa.” ");
INSERT INTO urim_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tu oklala kolpa kai plalng pa, tu rak kai wan anong alntu ai. ");
INSERT INTO urim_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tu wrong pa rak rak kaingkai wan anong alntu ai pa, Sisas wrekg kolti kai kaino nang Olip pa. ");
INSERT INTO urim_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Wa kong miningket ai kil am wa yaper nar atom kawor yipmingki wunen a kapringen yalming a Maur Wailen pa. Ari tu wrong kin kipman pa wa wli kapringentel. Kil angko rpma kolti a kil kaling planten yangkipm a Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kil kaling plan tu rpma ari, tu melnum a aroaro wonel tu yangkipm a Moses pa, a tu melnum a arpmen yangkipm yiprokgen a Moses pa tu awi kin ur a melnum ur ai ari kil okg kin kipman anti kipman ur, atom ak angketen yangkipm titnongket a kin a kipman awi tita pa. Atom tu awiyel aye wli itna wulmpa a tu wrongkwail. ");
INSERT INTO urim_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Atom tu lanaki Sisas pa la, “Melnum a kaling plan tu, kin kil pa melnum ur ari kil anti kipman ur okg kin kipman ak angketen yangkipm titnongket a kin a kipman awi tita pa. ");
INSERT INTO urim_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ti yangkipm titnongket a Moses a ela wrkapm pa lala, kin a kolpa pa, mpa ikwesel imo kolti. Ti kitn pa la kolai?” ");
INSERT INTO urim_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tu alm ipmawel Sisas pa lala kil la yangkipm pa kul or kol a nikgwalpm a tu yapon ti pa, tu a uwiyel iye kai itni yangkipm pake. Ari Sisas pa ikg nar kanokg ti kolti ak wamipis pa nira kweikwei ela kanokg pa rpma. ");
INSERT INTO urim_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tu asentel asentel kolpa itna pa, atom kil ngkat ikg pa kai kwa ariwen a kil lanaken la, “Mla ur kitn a itna ti a paipmpaipm kalpisen pa, ti kitn pa ikwesel kin ti ep o!” ");
INSERT INTO urim_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kil lanaken kolpa plalng, wa kil wa ikg nar kanokg ti ak wamipis pa nira kweikwei ela kanokg pa. ");
INSERT INTO urim_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tu atning a Sisas la kolpa pa, tu wrekg akwris akwekg kolti am kaingkai ise. Tu kilmik a angkaino kwa pa ep ep, a tu a kai arken tu pa katnunten kaingkai, a atnuurng kin pa anti Sisas pa kolti itna. ");
INSERT INTO urim_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Sisas ngkat ikg pa kaino kwa a kil asen kin pa lala, “Kin! Ti tu a wet awiyeitn aye wli ti itna a i? Ake wa ur a tu wet arkiwetn pa itna ti eng mpa ikwesel kitn ti?” ");
INSERT INTO urim_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kin pa akalmpe la, “Melnum wailen, ake melnum ur pa itna ti.” Atom Sisas la karkurngkel la, “Wa kupm ti yat, kupm ake la mpa rkiweitn pa. Ti kitn kai o! Kitn kai a kitn plalng paipmpaipm a kitn antokg pa!” ");
INSERT INTO urim_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Sisas kil lanaki tu wrong kin a kipman pa anti ur lala, “Kupm ti wakg a akalen kanokg ti. Mla ur a kil katnuntopm pa, kil ake angkom ak miningket pa. Kupm mpa lkel wakg klalen a mpa iklentel ya a awi yaprekg watin eng rpma wor yongkyong.” ");
INSERT INTO urim_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tu melnum a arpmen yangkipm yiprokgen a Moses akalmpentel la, “Yangkipm a kitn alkitn wris laron kitn alkitn pa ake kaikut antiwe a ak titnongketel yangkipm pa la aklale pa. Kol melnum ur ai la nimpokgenteitn pa pati, pa kaikut antiwe pake.” ");
INSERT INTO urim_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Sisas akalmpe la, “Ake kupm wris ti laron kupm alkupm ti pa. Pake kol kupm alkupm wris ti laron kupm alkupm ti pa, pa yangkipm kaikut antiwe a ak titnongketel la kupm la yangkipm aklale. Eng ntei, kupm ti pa ariwe anong a pikekg kupm wliwe, a anong ikga wa kupm wa kaiye. Pake kipm ti ake ariwe anong a pikekg kupm wliwe pa, a ikga wa kupm wa kaiye pa. ");
INSERT INTO urim_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kipm melnum a kanokg ti ari la tita atn a rpma a tu melnum ti kol a kipm melnum a kanokg ti ari la tita pa. A kupm ti pa ake ari la melnum pa kol kipm pa ari la pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pake kol kupm ti ri la melnum ur pa pati, pa yangkipm kaikut antiwe a ak titnongketel la pa kupm ak ute wor pa, eng ntei, ake kupm alkupm ti ari la pa, kupm anti Yan alkupmen a ukwawopm nar pa ari la melnum pa. ");
INSERT INTO urim_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kol yangkipm a nira ela Yangkipm Titnongket alkipmen pa lala, melnum wekg la nikgwalpm wekg kolen tita pa, pa yangkipm kaikut antiwe a ak titnongketel la, pa aklale pake. ");
INSERT INTO urim_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ti melnum wekg pa laron kupm ti: kupm alkupm ti a wa Yan a pikekg ukwawopm nar pa, wa kil wa laron kupm ti yat ak titnongketel la, pa kupm la aklale.” ");
INSERT INTO urim_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Atom tu melnum a arpmen yangkipm yiprokgen a Moses pa asentel la, “Ti Yan akitnen ti a i?” Ari Sisas akalmpe la, “Kipm ake ariwe kupm ti, a wa kipm ake ariwe Yan akupmen pa. Kol a kipm riwe kupm ti pa, kol a wa kipm riwe Yan akupm pa kolpa yat pake.” ");
INSERT INTO urim_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Sisas la yangkipm pa naki tu wrong kin kipman ak wang a kil kaling planten rpma kawor yipmingki wunen a yalming a Maur Wailen pa, rpma wreren wan ok a tu aye marpm wli uk uk Maur Wailen atnewe pa, ari ake wa tu ur arkulel. Eng ntei, wang akilen a Maur Wailen alm pa, a pa. ");
INSERT INTO urim_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Wa Sisas lanaki tu wrong kin kipman pa kolpa la, “Kupm ikga utnurngkepm kaino. Kipm ikga ikoropm ikoropm ining, atom kipm ikga imo ngkiten paipmpaipm a kipm antokg pa. Wrik a kupm kaino pa, kipm ikgake ntiwe kaino.” ");
INSERT INTO urim_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Atom tu melnum wailen wailen a men Suta pa naki tita lawel lala, “Kil la wrik a kil ikga kaino pa mentepm ikgake ntiwe kaino. Kil la kolpa eng kil ikga ilm kil alkil ti imo aki?” ");
INSERT INTO urim_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kil wa la kolpa la, “Kipm pa a nar ti, a kupm ti pa a kaino kwa ai. Kipm pa melnum a kanokg ti, a kupm ti pa ake melnum a kanokg ti pa. ");
INSERT INTO urim_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kolpa atom ari kupm wet lanakepm la, kipm ikga imo itnen paipmpaipm a kipm antokg pa. Kupm ti a Rpma Kolpa Rpma kol a kupm laron kupm alkupm nakepm nakepm pa. Kol ake kipm ukipma kupm ti la kupm melnum kolpa pa, pa kipm ikga imo itnen paipmpaipm a kipm antokg pa.” ");
INSERT INTO urim_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tu asentel la, “Ti kitn mla wai?” Ari Sisas akalmpe la, “Wa kipm wa asen, ti pikekg kupm lanakepm ak ep ak ai kul ti! ");
INSERT INTO urim_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kupm nikgwalpm watipmen rpma a kol a lanikepm, wa kupm ari la atn a rpma akipmen ti a kol a lanikepm la pa paipm. Pake kupm atning kuina ur a melnum a ukwawopm nar pa kil lanakopm pa, pa kupm la pa kolti naki kipm wrong kin a kipman a kanokg ti. Kil pa melnum a la yangkipm aklale.” ");
INSERT INTO urim_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tu atning yangkipm a Sisas la pake, tu ake wa ariwe la pa kil lakati Yan alkilen pa naken pa. ");
INSERT INTO urim_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kolpa atom wa Sisas lanaken la, “Kipm ikga ngkit Warim Kipman A Melnum pa iye kaino yo okgmangki pa. Atom ik wang pa kipm ikga riwe kupm ti la Kupm ti a Rpma Kolpa Rpma pake kol a kupm lanakepm lanakepm pa. A wa kipm ikga riwe la kupm ti ake antokg kweikwei ur ak nikgwalpm a kupm alkupm ti pa, kalpis. Kupm la yangkipm kil katila kol a Yan kil alkil pa kaling plantopm pa. ");
INSERT INTO urim_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yan a ukwawopm nar ti pa kil antiwopm rpma. Kil ake wa atnuurng kupm ti rpma ak kupm alkupm ti pa, kalpis. Eng ntei, kupm akangklei wang antokg kweikwei a wor wor kolti a ak antokg kil atopen.” ");
INSERT INTO urim_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tu atning yangkipm a kil la kolpa, atom tu wailet ukipma kil pa. ");
INSERT INTO urim_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Atom Sisas naki tu men Suta a ukipma kil pa la, “Kipm rkul yangkipm a kupm aroaro wonelepm pa kutnun kolpa iye kai pati, kipm ikga palng melnum akupmen a katnuntopm aklale. ");
INSERT INTO urim_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kipm ikga uwi riwe yangkipm aklale a Maur Wailen pa atom yangkipm aklale pa ikga ntokg kipm a ampei yapowepm pa wirng no kukula wor.” ");
INSERT INTO urim_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tu akalmpe la, “Men ti pa men yaru marpmeng a Apraam. Men ake pikekg rka aken kwap kalpmilel orngwatneikgen melnum ur. Ti wa kitn la Maur Wailen ikga ntokg men wirng no itni kukula wor eng na?” ");
INSERT INTO urim_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ari Sisas akalmpe la, “Kupm lanakepm aklale wrisen, melnum a antokg paipm pa, am paipmpaipm pa alok yapowel titnongket pake. ");
INSERT INTO urim_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Melnum a aken kwap kalpmilel orngwatneikgen mring ur pa, pa kil ikgake nti mring a kinwatnom a mring pa rpmi yongkyong pa. Pake Warim Kipman alkil a mring pa kil ikga nti yan alkil pa rpmi yongkyong pake. ");
INSERT INTO urim_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kol Warim Kipman ti ngketen ampei a paipmpaipm a yapowepm tukwleikgen kipm ti pa, pa kipm am wirng no kukula wor ise, ake kweiur ketn yapowepm om. ");
INSERT INTO urim_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kupm ariwe la kipm yaru marpmeng a Apraam, pake kipm ti ake ukipma kol Apraam pa. Nikgwalpm a kipm ti rka manet, atom kipm akor ya la ilmpopm imo. Eng ntei, kipm ake la rkul yangkipm akupmen ti rpmi kawor ipma akipmen ti. ");
INSERT INTO urim_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kupm ti pa lakati nakepm kuina ur a pikekg kupm anti Yan alkupm rpma, atom kupm atning a ari pa. Kipm ti pa antokg kuina ur kol a kipm atning a yan alkipm ti lanakepm pake.” ");
INSERT INTO urim_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tu akalmpentel la, “Apraam pa wapyipmiri a walyipmiri amenen.” Ari Sisas wa lanaken la, “Ti kol kipm yaru marpmeng iklale a Apraam pa, kol a kipm ntokg kweikwei kitila kol a pikekg Apraam kil antokg pa. ");
INSERT INTO urim_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ari wa kalpis, wa kipm akor ya la ilm kupm melnum a lanakepm yangkipm aklale a kupm atning a Maur Wailen kil nakopm pa. Ti Apraam pa ake pikekg ak nikgwalpm ur kolpa. ");
INSERT INTO urim_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kipm ti pa kipm antokg kuina ur kol yan alkipmen antokg pake.” Ari wa tu pa akalmpe la, “Men ti pa ake warim a pikekg man angkli arkul atom angket men ti pa, men ti pa warim a yan wris ata kolti, pa Maur Wailen kil alkil pake.” ");
INSERT INTO urim_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Sisas atning tu wrong pa la tu pa warim a Maur Wailen atom kil akalmpe lanaken la, “Kol Maur Wailen ti Yan akipmen pa, kipm kol a wa plan ipma wor wasrongen kupm ti. Eng ntei, kupm ti pikekg anti Maur Wailen ai rpma, atom angkaino ai nar ti am antiwepm rpma tike. Ake pikekg kupm ti nar ak wasrongen a kupm alkupm ti pa, kil alkil pa ukwawopm atom kupm nar pake. ");
INSERT INTO urim_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Antokg kolai atom ake kipm atning awi ariwe yangkipm a kupm la ti? Pa atnen a kipm karken a atning yangkipm a kupm la pa. ");
INSERT INTO urim_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kipm pa yan akipmen pa Maur Paipm Satan, atom kipm la kutnun nikgwalpm wasrongen paipm a yan alkipm pa kolpa itni. Pikekg ngkaten ak ep lmpiwen ai kul pa, kil melnum a alm melnum amo, a kil ake itna nampokgen yangkipm a kweikwei a ute aklale pa, kolpa atom kil ake alupm nikgwalpm ute aklale ur rpma kil pa. Kil kansil pa, pa am kil antokg nikgwalpm paipm alkil a kil antokg antokg pake. Eng ntei, kil pa melnum a kansil, a kil pa yan yiprokgen a nikgwalpm kansil. ");
INSERT INTO urim_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Atom kipm pa alupm nikgwalpm kansil a kil pake. Pake yangkipm a kupm ti lanakepm ti pa, kipm pa ake ukipma la pa aklale pa. Eng ntei, kupm ti laron nakepm nikgwalpm aklale. ");
INSERT INTO urim_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ti kol kupm ntokg paipm ur pa, ti kipm laron paipm na ur a kupm antokg pawo! Kol kupm ake antokg paipm ur, a wa la yangkipm iklale pa, ti antokg kolai atom ake wa kipm ukipma kuina ur a kupm la ti la aklale pa? ");
INSERT INTO urim_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Melnum a Maur Wailen pa Yan eng kil pa, kil pa atning kuina ur a Maur Wailen la pa. Yiprokgen a kipm ake atning yangkipm a Maur Wailen la pa pati, Maur Wailen ake yan eng kipm pa.” ");
INSERT INTO urim_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tu men Suta akalmpe yangkipm a Sisas la pa la, “Kitn pa titno kol tu Samaria, kitn pa maur paipm arpmeweitn. Ti kol a men la la pa aklale pake?” ");
INSERT INTO urim_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Sisas naken la, “Kupm ti ake maur paipm ur arpmewopm. Kupm ti alupm aye Yan akupmen ai, ari wa kipm ti arku nang akupmen ti. ");
INSERT INTO urim_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kupm ti ake antokg eng la kipm ngkit nang a kupm alkupm ti pa. Melnum a kil wasrongen la la ngkit nang a kupm ti pa, pa kil rpma, a wa kil ikga rpmi itning yangkipm a mentepm wrongkwail atom ikilmpe kitila pa. ");
INSERT INTO urim_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kil kupm lanakepm aklale wrisen la, kol mla ur kil rkul yangkipm akupmen ti pa kil ikgake imo kai.” ");
INSERT INTO urim_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ari wa tu men Suta akalmpe la, “Ti men ariweitn worwor la kitn pa maur paipm arpmeweitn. Apraam pikekg amo a wa tu melnum okwripm a Maur Wailen pikekg wa amo, pake kitn ti la, mla ur kil rkul yangkipm a kitn ti pa kil ikgake imo. ");
INSERT INTO urim_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ti kitn ti melnum wailen angen yan Apraam wapyipmiri walyipmiri amenen ai? Apraam pikekg amo a wa tu melnum okwripm a Maur Wailen pa pikekg wa amo yat. Ti kitn ti la kitn alkitn ti la kitn ti am melnum kolpake!” ");
INSERT INTO urim_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Sisas akalmpe la, “Kol kupm alkupm ti ngkit nang alkupmen ti pa la kupm antiwe titnongket a nang wailen pa, pa kupm ake nang arke, pa kupm nang kalpisen kolti. Pake am Maur Wailen a kipm lala Maur Wailen akipmen pa a wa kupm ti lala Yan akupmen ti pa, am kil pa ngkatopm a plan titnongket a nang wailen akupmen tike. ");
INSERT INTO urim_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pake kipm pa ake ariwe kil pa, kupm ti ariwe kil pake. Kol kupm ti lala, ake kupm ariwe kil pa, pa kupm ti melnum ur a kansil kolen kipm pa, ari kupm ti ariwe kil pa atom kupm arkul katnun yangkipm akilen pa. ");
INSERT INTO urim_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yan Apraam walyipmiri wapyipmiri akipmen pa pikekg kil won momo eng kil ariwe la kil ikga ri wang a kupm ikga nar kanokg ti. Kil ari pa kil atopen.” ");
INSERT INTO urim_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ari tu men Suta pa akalmpentel la, “Apraam pa pikekg ak yo ampei ai. A kitn ti pa warimet pikekg ketn ti palng ti, pa kitn ake pikekg ari Apraam pa.” ");
INSERT INTO urim_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Sisas akalmpe la, “Kupm lanakepm aklale wrisen la, Kupm ti Rpma Kolpa Rpma, a Apraam pa man rakuwel katnukg.” ");
INSERT INTO urim_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tu atning kolpa, tu awi wes pa la ik orel, ari Sisas wrekg tital ak angkom tu wrong pa am kul or kai takwuleikgen yipmingki a kapringen yalming a Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Sisas anti tu watnom a kil aroaro wonel pa angkom kai pa, tu ari melnum wulmpa tilmpisen ur a pikekg awi ipmangko pa rpma. ");
INSERT INTO urim_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Atom tu watnom a Sisas aroaro wonel pa asen Sisas pa la, “Melnum a aroaro wonel men, mla antokg paipmpaipm atom kil awi ipmangko wulmpa tilmpisen kolpa? Paipmpaipm a kil alkil ti aki a mansan alkil ai?” ");
INSERT INTO urim_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ari wa Sisas akalmpe la, “Ake la kil wulmpa tilmpisen atnen paipmpaipm a kil alkil ti aki a mansan alkil pa, kolpa kalpis. Kil wulmpa tilmpisen pa pati, yiprokgen itna la mpa tu ri titnongket a Maur Wailen mpa ikwap kai kil ti.” ");
INSERT INTO urim_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Atom Sisas kil lala, “Mentepm ikwap a Wailen a pikekg ukwawopm nar ti ik ran takgni a rpma tike! Mining iye wam kul pa, melnum ur akentiwe mpa ikwap ik mining pa. ");
INSERT INTO urim_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ak wang a kupm rpma a kanokg ti pa, kupm ti pa wakg a akalen kanokg ti.” ");
INSERT INTO urim_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Sisas la kolpa plalng, kil ungkwa wlikg pa kai kanokg pa a ak wam raingen kanokg pa ak anel wulmpa a melnum wulmpa tilmpisen pa. ");
INSERT INTO urim_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Plalng pipa kil lanakel la, “Kitn kai klak ikgok kai u tungkur Siloam.” Yiprokgen a nang Siloam pa lala, “Ukwa kai.” Atom melnum pa kai karkuk plalng, kil wa yaper wli wan anong alkil pa, kil antiwe ari kweikwei. ");
INSERT INTO urim_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tu melnum a rka wris nampokgentel pa a tu tiur a pikekg ariwel a kil rpma akwen akwen kweikwei pa tu la, “Pa melnum wulmpa tilmpisen a pikekg rpma akwen akwen kweikwei am pake?” ");
INSERT INTO urim_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ari wa tiur pa lala, “Melnum a kipm la pa am tike.” Ari wa tu tiur pa lala, “Kalpis, ake melnum pa, melnum a kipm la pa am wa ari kolen melnum tike.” Ari wa melnum kil alkil pa wa lala, “Ei, am kupm melnum a kipm la pa am kupm am tike.” ");
INSERT INTO urim_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Atom tu wa asen melnum pa la, “Antokg kolai atom kitn antiwe ari kweikwei pa?” ");
INSERT INTO urim_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ari wa kil akalmpenten la, “Melnum a tu namput la Sisas, kil awi kanokg pa ak wam raingen ak anel wulmpa akupmen ti. Atom kil wa lanakopm la, kupm kai klak ikgok kai u tungkur Siloam ai! Kupm kai klak kolti, kupm wulmpa ore ari kweikwei ak wang ketn a kupm karkuk pake.” ");
INSERT INTO urim_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Atom tu wa asentel la, “Ti melnum pa a i?” Ari wa kil akalmpe la, “Awai, kupm ake ariwe.” ");
INSERT INTO urim_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Atom tu awi melnum a wet wulmpa tilmpisen pa aye kai eng tu melnum a arpmen yangkipm yiprokgen a Moses. ");
INSERT INTO urim_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Wang a wet Sisas ak mang ak anel wulmpa a melnum wulmpa tilmpisen pa palng wor pa, pa kil ak ak wang wail a rpma eng yapm. ");
INSERT INTO urim_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ari tu melnum a arpmen yangkipm yiprokgen a Moses pa wa asen melnum pa la, “Antokg kolai atom wulmpa akitnen ti wa wor ti?” Ari wa melnum pa akalmpe la, “Kil ak mang ti anelopm wulmpa ti a kil lanakopm atom kupm kai karkuk klaken kolti a kupm wulmpa ore ari kweikwei.” ");
INSERT INTO urim_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pake tu melnum tiur a arpmen yangkipm yiprokgen a Moses pa la, “Melnum a antokgtel wor pa ake melnum a Maur Wailen pa, eng ntei, kil wa lalowe akwap ak wang wail a rpma eng yapm pa.” Ari tiur atuwen pa lala, “Kil melnum a antokg paipm pa, pa mpa wa kil elng kla titnongket titnongket kolti la kolai?” Tu alntu melnum a arpmen yangkipm yiprokgen a Moses pa arowom arowom alilakel tita kolpa kai. ");
INSERT INTO urim_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Atom wa tu wa asen melnum a pikekg wulmpa tilmpisen pa anti ur la, “Ti kitn alkitn melnum a pikekg kil antokg wulmpa akitnen wor pa, ti kitn akwonalmpen melnum pa la kil melnum kolai?” Ari wa melnum pa akalmpe la, “Kil melnum okwripm a Maur Wailen.” ");
INSERT INTO urim_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pake tu melnum wailen wailen a men Suta pa ake tu ukipma la melnum pa pikekg wulmpa tilmpisen pa, atom wa kil wulmpa ore pa. Kolpa atom tu ukwa yangkipm pa kai eng mansan alkil pa eng la tuwekg kul. ");
INSERT INTO urim_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Tuwekg kul ariwen pa, tu asenten la, “Ti warim kipman akipmekgen a kipmekg lala kil pikekg man raku awi ipmangko wulmpa tilmpisen am tike? Ti antokg kolai atom wulmpa a kil ti wa wor ari kweikwei ti?” ");
INSERT INTO urim_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ari wa tuwekg mansan pa akalmpe la, “Mentekg ariwe la ti warim kipman amentekgen, a pikekg man raku awi ipmangko wulmpa tilmpisen am tike. ");
INSERT INTO urim_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pake mentekg ti ake ariwe la antokg kolai atom wulmpa akilen pa wor ari kweikwei pa. Wa mentekg ake wa ariwe la pikekg mla a i antokg wulmpa akilen pa palng wor pa. Isen kil alkil pawo, kil wail wontrakole antiwe mpa kil alkil la pa.” ");
INSERT INTO urim_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tuwekg mansan alkil pa la kolpa eng ntei, tuwekg ngkark eng tu melnum wailen wailen a men Suta pa yapon nikgwalpm ise, la mla ur a kil ukipma Sisas pa la kil Krais pa, mpa tu ungkwantel kul or tukwuleikgen tu wrong kin kipman mapming a ukipma Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kolpa atom ari tuwekg mansan alkilen pa lanaken la, “Am kipm isen kai kil alkil pake. Kil wail wontrakole wor antiwe mpa kil alkil lanikepm pa.” ");
INSERT INTO urim_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Atom wa tu melnum a arpmen yangkipm yiprokgen a Moses pa akwe melnum a pikekg wulmpa tilmpisen pa wa kul antiur lanakel la, “Kitn naren Maur Wailen ti la yangkipm ti iklale! Men ti ariwe la melnum pa melnum a antokg paipmpaipm.” ");
INSERT INTO urim_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ari wa kil akalmpe la, “Kupm ake ariwe la kil melnum a antokg paipmpaipm pa aki kalpis. Pake kwei ur wris a kupm ariwe pa pati, pikekg ep pa kupm pikekg wulmpa tilmpisen, pake ak wang ti pa kupm antiwe wa ari kweikwei.” ");
INSERT INTO urim_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Wa tu asentel la, “Melnum pa kil antokg kuina? Kil antokgteitn kolai atom wulmpa akitnen pa wulmpa ore ari kweikwei pa?” ");
INSERT INTO urim_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Kil akalmpe la, “Ake wet kipm atning a kupm lanakepm pa. Antokg kolai atom kipm wa la wa itning ntiur pen? Kipm la kipm a wa palng watnom akilen eng mpa kil wa iroro wonelepm?” ");
INSERT INTO urim_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Atom tu la akgnokgelel la, “Kitn pa kitn watnom a kil pa aroaro woneleitn pake. A men ti pa men watnom a Moses ai aroaro wonelo ai. ");
INSERT INTO urim_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Men ariwe la, Moses pa pikekg Maur Wailen lanakel yangkipm ok pake, pake melnum ti pa, ake men ariwe ketnketn ur la kil ti angkai a i wli.” ");
INSERT INTO urim_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ari wa melnum pa akalmpe la, “Ti kipm ake ariwe melnum pa la kil angkai a i wli! Wai, wet ak ai kipm asen asen kolpa itna wai! Ti ake kipm ari wulmpa a pikekg kil antokgtopm wor ti! ");
INSERT INTO urim_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Mentepm ariwe la, Maur Wailen pa ake antiwe mpa itning mla ur a antokg paipmpaipm pa. Kil atning tu melnum a orngwatneikgen kil antokg kuina ur a kil wasrongen pa. ");
INSERT INTO urim_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Pikekg ep ak ai kul pa, ake pikekg mentepm atning a melnum ur antokg melnum wulmpa tilmpisen ur a awi ipmangko ur kolpa palng wulmpa ore ari kweikwei pa. ");
INSERT INTO urim_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kol melnum pa ake a Maur Wailen pa, kil ake ntiwe ntokg kweikwei ur kolpa.” ");
INSERT INTO urim_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tu melnum wailen wailen pa atning a kil la kolpa atom tu aklewel la, “Kitn pikekg paipmpaipm yapoweitn ak a man rakuweitn ai kolpa kul pake, ti kitn la wa kiling plan men tike!” Tu la kolpa a tu ungkwantel kai kawor en ai. ");
INSERT INTO urim_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Sisas atning a tu melnum wailen wailen a men Suta pa ungkwan melnum a pikekg wulmpa tilmpisen pa kul or en, atom kil kai ansilel kolti a kil lanakel la, “Kitn ukipma Warim Kipman A Melnum ti aki, kalpis?” ");
INSERT INTO urim_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ari melnum pa akalmpe la, “Melnum wailen, Warim Kipman a Melnum pa mla wai? Ti kitn lanikopm eng mpa kupm ukipma melnum pa.” ");
INSERT INTO urim_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ari Sisas lanakel la, “Kupm lanakeitn aklale wrisen, melnum a kitn ari antiweitn oklala itna ti pa am melnum pake.” ");
INSERT INTO urim_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Atom melnum pa lala, “Wailen, kupm ukipma kitn pake.” Kolti, kil kapor kilko alein Sisas pa. ");
INSERT INTO urim_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Sisas lala, “Kupm nar kanokg ti eng ari la tu wrong kin kipman, eng mpa tu melnum a wulmpa tilmpisen pa mpa wa palng wulmpa ore ari kweikwei, a tu a wulmpa ore pa mpa wa tu palng wulmpa tilmpisen.” ");
INSERT INTO urim_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ari tu melnum a arpmen yangkipm yiprokgen a Moses tiur a itna pa atning a kil la kolpa atom tu asentel la, “Kitn la kuina wai? Kitn wa la men ti wa wulmpa tilmpisen?” ");
INSERT INTO urim_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Sisas akalmpe lala, “Kol wulmpa a maur wor akipmen pa tilmpis ake riwe nikgwalpm a Maur Wailen pa pipa, kipm kol a ntiwe yangkipm a ikga ikilmpe yangkipm pa. Pake kipm la wulmpa a maur wor akipmen ore ariwe nikgwalpm a Maur Wailen pa, kolpa ti kipm yangkipm kalpisen a ikga ikilmpe yangkipm pa.” ");
INSERT INTO urim_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Sisas lanaki tu pa la kolpa la, “Kupm lanakepm aklale wrisen la, melnum a ake or yipmingki yun a manto walkg malkgu pa kawor wunen pa, kil nowen or kol yipmingki yamping ur pa kaino kawor pa, pa kil melnum ikgwampet a la ik ikgwampel manto walkg malkgu ti iye kai. ");
INSERT INTO urim_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Melnum a kil or yipmingki yun pa kawor wunen pati, kil melnum wor a ikgalen manto walkg malkgu pake. ");
INSERT INTO urim_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","A melnum a arpmen arpmen yipmingki yun pa kukwa kukwa yipmingki yun pa eng melnum wor alkil a ikgalen manto walkg malkgu pa kolti, wa manto walkg malkgu pa am atning kromeng a melnum alkil a ikgalenten pa. Atom melnum pa akwe nang atuwen pa wris wris atom alekgenten aye or en. ");
INSERT INTO urim_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kil alekgenten aye or en ti plalng pa, kil ep alekgenten a tu pa rka yirokg akilen pa katnuntel kolpa kai, eng ntei, tu pa ariwe kil pa a atning kromeng akilen ise. ");
INSERT INTO urim_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pake kol melnum misen ur ukwe manto walkg malkgu pa, tu mpa ngkirk tukuleikgen melnum pa, eng ntei, tu ake atning ok kromeng a melnum misen pa.” ");
INSERT INTO urim_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Sisas ak yangkipm kla pa ak la, ari ake tu awi ariwe yangkipm yiprokgen na ur a kil lanaken pa. ");
INSERT INTO urim_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Atom Sisas lanaken yangkipm yiprokgen pa la, “Kupm lanakepm aklale wrisen, kupm ti pa kupm yipmingki yun a manto walkg malkgu a ore kawor kul or. ");
INSERT INTO urim_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tu melnum a pikekg wli ep ep ak palk upaar ikgalen manto walkg malkgu pa, pa tu melnum ikgwampet a tu melnum a atn la ilmpor manto walkg malkgu pa, atom tu manto walkg malkgu pa ake pikekg atning ok kromeng a tu pa. Kolpa itna a a, kupm ti wli palng. ");
INSERT INTO urim_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kupm ti pa yipmingki yayun. Manto walkg malkgu a or kupm ti kawor pa, kil ake mpa ngkirk, kil mpa itni wor, a kil mpa kawor kul or il mi itni tutu wrik a mi anip atnewe wor pa. ");
INSERT INTO urim_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Melnum ikgwampet pa ake wli la ntokg kwei ur pa, kalpis. Kil wli eng la ik ikgwam, a ilmpor ntokg paipm manto walkg malkgu pa. Pake kupm ti pa, kupm nar eng mpa ikglen manto walkg malkgu pa riworwor, tu mpa itni wor ntiwe itopen worwor kolpa itni ikngklei wang. ");
INSERT INTO urim_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Melnum wor a ikgalen manto walkg malkgu ti pa, am kupm kilke. Melnum wor pa kil ak num upaarng manto walkg malkgu pa la imo ok itnen manto walkg malkgu alkilen pa. ");
INSERT INTO urim_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pake melnum a tu armpen eng kil akwap ikgalen manto walkg malkgu pa, pa ake melnum alkil a ikgalen manto walkg malkgu pa, wa kil ake yan yiprokgen a manto walkg malkgu pa, pa kil melnum a akwap marpm kolti. Atom melnum a kolpa pa kil ri nimpa tilpmingen pa wli pa, kil mpa wrekg ngkirk utnuurng manto walkg malkgu pa itni pa a kil am kai ise. Atom nimpa tilpmingen pa mpa wli kolti, kai kawor ilm manto walkg malkgu tiur pa a tiur pa ngkirk punprarng kai tutu palpa. ");
INSERT INTO urim_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Melnum pa tu armpentel kolti, atom kil ake nikgwalpm arken manto walkg malkgu pa eng ikglen riworwor pa, kolpa atom kil am ngkark kai ise. ");
INSERT INTO urim_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Pake kupm ti pa melnum wor a ikgalen manto walkg malkgu. Kupm ti ariwe manto walkg malkgu ti a manto walkg malkgu pa wa ariwe kupm ti. ");
INSERT INTO urim_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Am wa kolpake, Yan kil ariwe kupm ti a kupm ti wa ariwe Yan pa, a kupm ikga imo ikirmpen manto walkg malkgu alkupmen pa. ");
INSERT INTO urim_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Wa manto walkg malkgu tiur a ake itna kawor yipmingki wunen ti pa, pa akupmen yat. Pa kupm ikga wa lekgen tu pa yat. Atom tu ikga wa itning ok kromeng akupmen ti. Tu ikga wa kawor iken tita itni mapming wris kolti a ikga melnum wris kolti ikglenten. ");
INSERT INTO urim_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ti yiprokgen a Yan alkupm plan ipma wor wasrongen kupm ti pati atnen kupm la uk kupm alkupm ti imo. Pake ikga wa kupm wrekg rpmi pa. ");
INSERT INTO urim_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kupm ti ikga imo ik wasrongen a kupm alkupm ti kolti, ikgake melnum ur ik wam iyewentopm. Kupm antiwe titnongket a uk kupm alkupm ti eng tu ilmpopm imo pa. Wa kupm antiwe titnongket a wa wrekg rpmi pa. Pa am Yan alkupm pa alkopm yangkipm titnongket pa la kupm ik kol pake, atom kupm ak katila pa.” ");
INSERT INTO urim_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tu a men Suta atning yangkipm a kil la kolpa atom, tu wa wrekg alilakel tita arowom arowom itna tu alntu ti. ");
INSERT INTO urim_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tu wrong wailet pa la, “Kil pa Maur Paipm arpme atom almpla titnowel kil pa. Ti wa kipm wa atning yangkipm a kil pa la pa eng ntei?” ");
INSERT INTO urim_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ari tu tiur pa wa lala, “Melnum a Maur Paipm arpme pa ake mpa oklala kol melnum a oklala itna ti. Ti mpa Maur Paipm pa ntokg melnum a wulmpa tilmpisen pa palng wor la kolai?” ");
INSERT INTO urim_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Atom men Suta wli wli takwem rka anong wail Serusalem pa. Pa wang wail a men akwonalmpen wang a pikekg tu almenen awi yalming a Maur Wailen angkai wam a tu wrongmanto ai aye yaper kul almenen, atom atopen atnen uk kai wam a Maur Wailen. Pa wang alkil a wripm wail el el pa. ");
INSERT INTO urim_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Sisas pa angkom narno itna wan male wail ur a itna yipmingki wunen a yalming a Maur Wailen pa. Tu akwe wan male pa la Wan Male a Solomon. ");
INSERT INTO urim_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Atom tu melnum wailen wailen a men Suta pa anel wli itna kapringentel kolti a asentel la, “Wa kitn ayewo kai wang watin, ake kitn laron oklala ti angko wunong eng mpa men riwe. Kol kitn Krais pa, mpa kitn laron kitn alkitn ti ngko wunong eng mpa men riwe.” ");
INSERT INTO urim_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Sisas akalmpenten la, “Kupm pikekg lanakepm lanakepm, ining, ake kipm ukipma la pa aklale. Yan akupmen alkopm nang wailen atom kupm antokg kweikwei titnongket titnongket a kipm ari a kupm antokg pa, pa wa laron ak titnongketel kupm ti la kupm mla pa. ");
INSERT INTO urim_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pake kipm ake wa ukipma, eng ntei, kipm ake manto walkg malkgu akupmen pa. ");
INSERT INTO urim_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kupm ariwe manto walkg malkgu alkupmen pa a manto walkg malkgu atning ok kromeng akupmen pa atom katnuntopm pa. ");
INSERT INTO urim_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Kupm alken yaprekg watin alkupmen a ak antokg tu rpma wor yongkyong. A tu pa ikgake kai paipm tukwleikgen kupm ti. A ikgake ntiwe melnum ur rkolngken iye kai tukuleikgen wam akupmen ti. ");
INSERT INTO urim_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yan akupmen a uk tu pa kul kupm ti, pa kil itna wailen angen kweikwei wrongkwail. Ti melnum ur ake ntiwe rkolng tu melnum pa tukuleikgen wam a Yan akupmen ti. ");
INSERT INTO urim_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kupm ti, a Yan pa, mentekg ake manman, mentekg almentekg wris kolti.” ");
INSERT INTO urim_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ari wa tu melnum wailen wailen a men Suta pa tu atning a kil la kolpa atom tu wa awi wes pa la wa ik orel eng kil imo. ");
INSERT INTO urim_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ari Sisas lanaken la, “Kipm ari kupm ti antokg kweikwei weten weten wor wor watipmen a Yan alkupmen lanakopm la kupm ntokg pa. Ti kipm ari ur a i paipm, atom kipm wa la wa ikweselopm imo pa?” ");
INSERT INTO urim_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tu melnum wailen wailen a men Suta akalmpe la, “Men ake la ikweseleitn imo eng kweikwei wor wor tiur ai a kitn antokg pa, men la ikweseleitn itnen a kitn la paipmel Maur Wailen. Ti kitn am melnum kolti kol men tike, ari wa kitn ngkat kitn alkitn ti la kitn Maur Wailen.” ");
INSERT INTO urim_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Sisas akalmpe naken la, “Ti ake kipm angkleikg yangkipm titnongket alkipmen a ela wrkapm pa nira lakati ok a Maur Wailen la kolkil la, 'Kupm Maur Wailen la, kipm pa maur wailen.' Pa kipm angkleikg angkleikg, ti kipm ariwe pa. ");
INSERT INTO urim_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Pikekg Maur Wailen akwe tu pa la maur wailen. Pa tu walyipmiri wapyipmiri wailen wailen amentepmen a pikekg ep ak ai kil ukwa yangkipm alkilen pa nar naken pa. Yangkipm alkilen a nira ela wrkapm pa mpam ela kolpake, ake mpa ungkwan. ");
INSERT INTO urim_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kupm ti pa, pikekg Yan pa amprinsopm eng alkilen atom ukwawopm nar kanokg ti. Kolpa atom kupm la kupm Warim Kipman a Maur Wailen pa. Ti antokg kolai atom kipm la kupm ti la kupm ak nokgel Maur Wailen pa? ");
INSERT INTO urim_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kol ake kipm ari titnongket a Yan alkopm atom kupm ak antokg kweikwei ti, ti ampur wa kipm ukipma yangkipm a kupm la kupm alkupm ti la kupm Warim Kipman alkilen pa. ");
INSERT INTO urim_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pake kol kipm ri la kweikwei a kupm antokg ti pa la pa Yan ti lanakopm atom kupm antokg ti, ti kol ake kipm ukipma yangkipm a kupm la kupm ti la kupm Warim Kipman alkilen pa, ti kol a wa kipm ukipma kweikwei a Yan lanakopm atom kupm antokg tiwo! Kol kipm ukipma kolpa pa, nol akipmen ti mpa umpen wontrakole riwe la, kupm ti rpma kawor Yan ti, a Yan ti rpma kawor kupm ti, atom mentekg wris pa.” ");
INSERT INTO urim_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tu melnum wailen wailen atning a Sisas la kolpa atom tu aye kul kai la rkulel nti ur, ari kil am kai takwleikgen wam atuwen ise. ");
INSERT INTO urim_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Atom Sisas kil kinar kai angket u kop Sotan pa kaino rpma kaino wrik a pikekg Son kil kaluk tu atne pa. Kil rpma pa wang aripm ur pa pen. ");
INSERT INTO urim_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","A tu wrong kin a kipman watipmen pa anel wlintel. Tu lanaki tita lala, “Son kil alkil ti pa pikekg ake kil elng kla titnongket titnongket elngkitna ak plan titnongket a Maur Wailen pa, pake yangkipm a pikekg kil lakati melnum ti pa, pa aklale wrisen.” ");
INSERT INTO urim_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Atom tu wrong kin a kipman watipmen a wli eng Sisas itna wrik pa tu ukipma kil pa. ");
INSERT INTO urim_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Melnum wris ur pa nang akilen pa Lasarus, kil numpet paipm rmpa no anong Petani. Petani pa anong a Maria ekg Mata, muikgmayen wekg a Lasarus pa. ");
INSERT INTO urim_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria pa kin a pikekg alung u yiwa yaprekget pa ak kaluk nepm a Wailen Sisas pa atom kil ak tukgunakg walk alkilen pa ak alo. A Lasarus a numpet rmpa pa kil muinwror a Maria ekg Mata pake. ");
INSERT INTO urim_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Atom muikgmayen wekg pa ukwa yangkipm pa kinar kai kaino naki Sisas pa la, “Wailen, melnum a kitn wasrongen pa kil numpet paipm.” ");
INSERT INTO urim_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Sisas atning kolpa a kil lala, “Numpet pa ikgake lok ngkliwel imo pa, kalpis. Pa tu wrong kin kipman ikga ngkit nang a Maur Wailen, a ikga wa ik plan titnongket a nang wailen a Warim Kipman a Maur Wailen ti wa ngko wunong.” ");
INSERT INTO urim_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Sisas pa plan ipma wor wasrongen Mata, a paipmen alkil Maria pa wa muinwror alntuwekgen Lasarus pa. ");
INSERT INTO urim_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kil atning a tu lanakel la Lasarus pa numpet paipm, ari ake wa nar kul no atatu, wa kil rpma pa wang wekg a pa pen. ");
INSERT INTO urim_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Atom kil lanaki tu watnom alkilen a kil aroaro wonel pa la, “Ti wa tepm yaper kinar anong kanokg Sutia wai!” ");
INSERT INTO urim_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tu akalmpentel la, “Melnum a aroaro wonel men. Ake wang aripm ur angketen a pikekg tu melnum wailen wailen a Suta antokg la ikweseleitn imo ingkinar pa. Ti wa kitn la wa yaper kinar pa eng ntei?” ");
INSERT INTO urim_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Sisas akalmpe la, “Ti ran wulmpa wail ti! Melnum a atn ak ran ti pa, ake antiwe mpa nilkwok ngko pa, eng takgni ti alen kanokg ti atom kil ari ya ti angkom ti. ");
INSERT INTO urim_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kol melnum itn ik mining pa pati, mpa kil nilkwok ngko pake, eng ntei, kil wakg kalpisen a ak alen ya a angkom atn pa.” ");
INSERT INTO urim_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kil la kolpa plalng pipa, wa kil wa lanaken la, “Lasarus melnum wor a mentepmen pa okg rmpa, pake mpa kupm kinar irowel ikgyokg, ti kil mpa wrekg pa.” ");
INSERT INTO urim_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tu watnom a kil aroaro wonel pa akalmpe la, “Wailen, kol kil okg rmpi pa, ti kil mpa wrekg numpworen rpmi pa.” ");
INSERT INTO urim_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Sisas pa wet la kil okg pake kil ariwe la kil am amo ut ise, pake tu watnom alkilen pa akwonalmpen la wet Sisas lanaken la la palpa kil okg kolti. ");
INSERT INTO urim_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Atom Sisas lanaken angko wunong ariworwor la, “Lasarus pa am amo ut ise. ");
INSERT INTO urim_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pake kupm atopen eng ake kupm pikekg rpma kinar pa ak wang a kil numpet pa. Ti mpai eng mentepm kinar riwel o! Kweikwei kil ikga kipm ri pa atom ik titnongketel ipma a kipm ukipma kupm ti.” ");
INSERT INTO urim_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Atom Tomas, nang wompel a kil pa Titimus, kil wrekg itna lanaki tu alntu watnom a Sisas pa la, “Ti wrekg mai eng tepm kimeket kinar imo ikilen kil pa kinar ai!” ");
INSERT INTO urim_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ak wang a Sisas anti tu watnom a kil aroaro wonel pa nar wreren eng a palng no anong Petani pa, kil atning yangkipm a tu lanakel la Lasarus pa am tu alilel rmpa kawor kirk a tu u mlaminel pa wang wikgwikg ise. ");
INSERT INTO urim_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Petani pa ela wreren anong wail Serusalem, tu ngkom a Petani ti kaino Serusalem pa wreren kolen wang tiwel waiketn ur kolti (kilomita wraur). ");
INSERT INTO urim_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Atom tu Suta wailet pa tu anel nar rka ak num kapor Maria ekg Mata eng kalkuten a muinwror alntuwekgen a amo pa. ");
INSERT INTO urim_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tu la Sisas pa yaya wreren eng a palng pake. Atom Mata atning kolpa, kil wrekg kolti atnuurng Maria pa rpma wan pa a kil kinar ansilel angko ya pa akyakurel aye no. ");
INSERT INTO urim_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Atom Mata lanaki Sisas pa la, “Wailen! Kol pikekg kitn rpmi ti pa, muinwror a kupm ti kol ake imo. ");
INSERT INTO urim_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pake kupm ariwe la, kuina ur a kitn lanikel ik wang ti pa, Maur Wailen mpa ntokg pa.” ");
INSERT INTO urim_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Sisas akalmpentel la, “Muinwror akitnen mpa wrekg rpmi malepmen pa.” ");
INSERT INTO urim_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata akalmpe la, “Kupm ariwe pa, kil ikga wa wrekg rpmi ik wang umpuwen nimpokgen tu a amo kaingkai ai pa.” ");
INSERT INTO urim_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Sisas lanakel la, “Kupm ti pa yiprokgen a la tu melnum wrekg rpma, a kupm yiprokgen a alken yaprekg watin atom tu rpma wor yongkyong. Melnum a kil ukipma kupm ti kil imo pa, kil mpa rkolng yaprekg watin pa kolpa rpmi wor yongkyong. ");
INSERT INTO urim_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Melnum a rpma malepmen rpma ti atom kil ukipma kupm ti pa, kil ikgake imo kai wrisen pa. Ti kitn ukipma kolpa aki?” ");
INSERT INTO urim_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mata akalmpe Sisas pa kolpa la, “Wailen! Ei, kupm ukipma pake, kupm ukipma la kitn pa Krais, Warim Kipman a Maur Wailen a pikekg Maur Wailen la la ikga ukwa nar kanokg ti eng ik rmpen men wrong kin kipman.” ");
INSERT INTO urim_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata la kolpa plalng pipa, kil yaper no kawor wan lanaki paipmen alkilen Maria pa meenen kai nungkulkg ai la, “Melnum a Kaling Plan Mentepm pa am wli wreren tike. Kil asen eng la ri kitn pake.” ");
INSERT INTO urim_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria atning kolpa, kil wrekg pinterng or en ti kil atatu kinar la riwel. ");
INSERT INTO urim_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Sisas pa ake no palng no anong ti pa, kil angko ya wai a pa. Kil itna wrik a wuten Mata kinar ansilel pa. ");
INSERT INTO urim_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tu Suta a ak num kapor Maria rpma wan pa ari Maria wrekg atatu or en ti atom tu katnuntel. Pa tu akwonalmpen la kil kai akgen Lasarus pa ak ok namputen kai kirkap ai. ");
INSERT INTO urim_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria kil kinar palng ari Sisas pa, kil elngtangko rmpa nepm a kil pa a kil la, “Wailen! Kol kitn pikekg ntiwo rpmi ti pa, muinwror akupmen ti kol ake imo.” ");
INSERT INTO urim_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Sisas ari Maria pa akg ak ok namputen a wa tu men Suta a antiwel pa wa anel akg ak ok namputen yat. Atom kil arein wail manten paipm. ");
INSERT INTO urim_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kil asenten la, “Ti kipm alilel ermpa kaino a i?” Ari tu akalmpe la, “Ti kitn no eng mentepm kai planteitn wrik a men alilel ermpa wai.” ");
INSERT INTO urim_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Atom Sisas akg. ");
INSERT INTO urim_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Atom tu Suta pa lanaki tita la, “Kipm ri o! Kil wasrongen Lasarus pa paipm atom kil akg kolpa.” ");
INSERT INTO urim_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ari tu tiur pa lala, “Kil melnum a pikekg antokg melnum wulmpa tilmpisen ti palng wor. Ti kol a kil ntokg Lasarus a pikekg numpet paipm la kol a imo ti palng wor eng kol ake kil imo.” ");
INSERT INTO urim_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Sisas pa ak won kati Lasarus pa kai paipm atom kil akg arein or ya pa kai kirkap pa. Kirk pa tu u mlamin atom tu ak wes kimplangen wail pa ak ipaarng mlamin ok pa. ");
INSERT INTO urim_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Sisas lanaken la, “Tulpul wes pa tukuleikgen o!” Ari Mata muikgmayen a melnum a amo pa la, “Wailen, kil am men alilel ermpa wang wikgwikg ti am yaprekget paipm ise.” ");
INSERT INTO urim_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ari Sisas akalmpentel la, “Ti ake kitn wonarpme a wuten kupm lanakeitn pa la, kitn ukipma pa, mpa kitn ri titnongket a nang wailen a Maur Wailen pa.” ");
INSERT INTO urim_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Atom tu talpul wes pa takwleikgen a Sisas ikg kaino kwa pa a kil lanaki Yan alkil pa la, “Alkeitn wor Yayai, eng kitn atning atning oklala akupmen. ");
INSERT INTO urim_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kupm alkupm pa ariwe la akangklei wang kitn atningkopm atningkopm pa, pake kupm la pa eng tu wrong kin a kipman a itna ti mpa tu itning ukipma la kupm ti pa, am kitn alkitn pa ukwawopm nar pake.” ");
INSERT INTO urim_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Sisas la kolpa plalng pa kil akwe yikakatnen la, “Lasarus, wrekg i kirk pa or o!” ");
INSERT INTO urim_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Melnum yipmiri pa wrekg ngkaten apm a tu akalmpel nepm a wam a ak yapowel ikgokg pa ngkaten aye or en ti. Kolti, Sisas lanaken la, “Nelkgen apm pa tukuleikgentel eng kil kai o!” ");
INSERT INTO urim_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kolpa atom tu wailet a men Suta a wli ari Maria antiwel rpma pa, anel ari kuina ur a Sisas antokg pa atom tu ukipma Sisas. ");
INSERT INTO urim_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ari wa tu tiur pa kai ari tu melnum a arpmen yangkipm yiprokgen a Moses pa atom tu lakati naki tu pa a wet Sisas la Lasarus a amo pa wrekg rpma pa. ");
INSERT INTO urim_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Atom tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen nampokgen tu melnum a arpmen yangkipm yiprokgen a Moses pa ukwa yangkipm kai naki tu mring man wailen wailen a antiwen ikgalen men Suta pa wli kimeket takwem rka akor la asen tita kolpa la, “Mpa mentepm ntokg kolai eng ngketen melnum a antokg kla titnongket titnongket wailet kolpa? ");
INSERT INTO urim_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kol mentepm ri wulmpa eng melnum pa kil ikwap pa kolpa iye kai pa, ikga kil ik rkolng tu wailet ikgam wli ukipma kutnun kil pa, la kil melnum a Maur Wailen ukwa nar pake. Atom tu Rom pa ikga ipma wakget wli tikale ntokg paipm yalming a Maur Wailen a ntokg paipm tu wrong kin a kipman a mentepmen ti.” ");
INSERT INTO urim_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tu asen tita kolpa, atom melnum wris ur a tu tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen pa, nang alkilen pa Kaiapas. Melnum pa kil tukgunakgen itna ep eng tu kimeket a ak ak kwap itna wan yalming a Maur Wailen ak wring pa. Kil lala, “Kipm ake ariwe kuina ur! ");
INSERT INTO urim_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kipm ti titnowen ya a ikga ngklinso ti! Ti mpa kupm lanikepm pa: kol wrong kin a kipman amentepmen ti kai paipm plalng pa, pa ake mpa wor. A kol melnum wris ur pa uwi wrik a tu wrong kin a kipman pa imo pati, pa mpa wor pake.” ");
INSERT INTO urim_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ake kil alkil ti la ak nikgwalpm a kil alkil ti pa, kalpis. Ak wring ti pa kil itna ep eng tu ipma krakgen kimeket a ak ak kwap itna yalming a Maur Wailen, kolpa atom Maur Wor a Maur Wailen pa ngkat okel kil pa atom kil la ep lala, Sisas pa ikga uwi wrik a men wrong kin a kipman a Suta ti imo. ");
INSERT INTO urim_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ake la imo eng men Suta ti wris pa, kil la ikga imo eng ik uwi tu warim a Maur Wailen a rka purngprarng yela kanokg ti iyewen wli itni wris. ");
INSERT INTO urim_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Atom tu melnum wailen wailen a ikgalen men Suta pa anel akor la yapon yangkipm la ilm Sisas pa imo. Atom ak wang pa kai pa tu numprampen la ilmpel imo pake. ");
INSERT INTO urim_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kolpa atom Sisas ake wa atn or wunong itna wulmpa a tu wrongkwail Suta pa om. Kil wrekg anti tu watnom a kil aroaro wonel pa kinar kai anong ur a tu namput la Epraim, a ela wreren wrik wes ningkrapm kalpmilel. Atom kil anti tu watnom akilen pa rka pake. ");
INSERT INTO urim_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Wang wreren eng a men Suta a kai rki wris eng ikwonilmpen wang wail a pikekg Maur Wailen awiyo angkai Isip pa aye kul wor pa. Atom tu melnum wailet a yela anong kanokg pa anel wli wli anong wail Serusalem pa la kurkuk il wam kipmanen a kurkuk il wam kinen numprampen tu alntu ti ep rpmi kukula wor itni wulmpa a Maur Wailen, plalng pa tu ikga rki wris itopen wang wail pa. ");
INSERT INTO urim_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tu am akor Sisas pake, atom anel asen tita itna kawor yipmingki wunen a yalming a Maur Wailen pa la, “Kipm akwonalmpen kolai? Sisas ikga wli ntiwo itopen ngkit nang a Maur Wailen pa ik wang wail ti aki kalpis?” ");
INSERT INTO urim_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen, a tu melnum a arpmen yangkipm yiprokgen a Moses, tu pa uk yangkipm titnongket la, kol melnum ur ri Sisas pa wli itni kol ur pa pipa, mpa tu wli laniken eng mpa tu kai rkulel iye kai. ");
INSERT INTO urim_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","A wang wampwomis wampwompwris pa a eng men Suta ikwonilmpen wang wail a pikekg Maur Wailen awi tu amenen angkai Isip pa aye kul wor ti. Pipa Sisas nar Petani, anong a Lasarus melnum a pikekg amo atom Sisas la ti wa wrekg rpma pa. ");
INSERT INTO urim_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tu numprampen okipma pa eng la il itopen uk Sisas pa. Atom Mata pa ampreing okipma pa a muinwror alkilen Lasarus pa anti tu a wli anti Sisas pa anel rka al okipma pa rka. ");
INSERT INTO urim_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Pipa Maria pa ngkaten u yiwa wriwen yaprekget wor a pikekg armpen ak marpm wail manten a rpma o maleek ok a no pik pa aye kul kai ak kaluk nepm a Sisas pa. Plalng pipa, kil ak tukgunakg walk alkil ti ak alo. Yaprekg aris wor wrisen pa pus kai or arpme wan wunen pa kimeket. ");
INSERT INTO urim_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ari watnom wris ur a Sisas kil aroaro wonel pa, nang akilen pa Sutas Iskariot. Melnum pa ikga uk Sisas kai wam a tu wrongmanto pa, kil lala, ");
INSERT INTO urim_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Yekei, u yuwa yaprekget wor pa wa takote ak klak nepm a kil pa tuwa! Kol a mentepm ik uwi marpm wail ur ai eng ik ngklin tu melnum a rpma tukwok.” ");
INSERT INTO urim_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Oklala a kil la kolpa, palpa kil ake arein la ik ngklin tu yek yek kun a rka paipm tukwok aklale pa, kalpis. Kil melnum a ikgalen marpm apmkoken a tu wrong kin kipman angkli angkli marpm ak angklin Sisas pa a tu watnom a kil aroaro wonel pa, pake kil melnum ikgwampet, atom kil aklampe marpm tiur pa eng alkilen. ");
INSERT INTO urim_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ari wa Sisas lala, “Wa la eng ntei, itni eng kil ik u yiwa pa ik inelopm o, numprampen kupm ti ep eng ikga kupm imo pa tu uwi palk a kupm pa iye kai lil kawor kirk a u mlaminel pa rmpi. ");
INSERT INTO urim_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kol tu melnum a rpma tukwok pa tu pa antiwepm rpma pa akangklei wang pake. Kupm ti pa ikgake ntiwepm rpmi ti ikngklei wang pa, kalpis.” ");
INSERT INTO urim_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ari wailet a tu Suta pa atning la Sisas pa rpma anong Petani. Atom tu wli wli la riwel. Ake tu wli la ri Sisas pa wris pa, tu wli wa la ri Lasarus a pikekg amo atom wa Sisas wa la atom kil wrekg rpma pa. ");
INSERT INTO urim_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kolpa atom tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen pa akor la yapon yangkipm la wa ilm Lasarus pa wa imo yat. ");
INSERT INTO urim_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Eng ntei, wailet a men Suta pa atnuurng tu pa rka wai, a tu kul ukipma Sisas pa atnen a kil la Lasarus a amo pa wrekg rpma pake. ");
INSERT INTO urim_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Atom tu okg or kong ti pa, tu wailet paipm a pikekg anel wli wli eng akwonalmpen wang a pikekg Maur Wailen awi tu a men angkai Isip pa kul wor ti, tu atning la Sisas pa yaya eng a no Serusalem tike. ");
INSERT INTO urim_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Tu kai angket paimplong ipm pa aye kinar ansilel angko ya pa, tu akyakurel aye no kolpa, tu atop ngkat ok la, “Ti tepm itopentel ngkit nang a Maur Wailen! Maur Wailen, kitn mpa uk ipma wor ngklin melnum a kitn naren atom kil angkom no ti! Kil melnum wailen ikga itni tukgunakg a ikglen men Isrel wrong kin kipman akitnen ti.” ");
INSERT INTO urim_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Sisas awi nimpa nungkulkg watin warimpen ur pa kaino arpme, kol a wrkapm a Maur Wailen la pa, ");
INSERT INTO urim_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","”O, kipm wrong kin kipman a Saion pa, ampur kipm ngkark. Kipm ri melnum wailen a itna tukgunakg a kipm Isrel pa rpma kaino nimpa nungkulkg watin warimpen pa ti wli pake.” ");
INSERT INTO urim_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ak wang pa tu watnom a kil aroaro wonel pa ake tu ariwe yiprokgen a yangkipm a nira ela wrkapm pa. Kil amo atom wrekg kaino anti Yan pa rpma awi titnongket a nang wailen pa, pa tu ariwe la la kuina ur a pikekg palng eng Sisas ti pa, pa a katnun yangkipm a pikekg tu melnum ok wripm nira ela wrkapm pa ep ak ai. ");
INSERT INTO urim_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Atom tu wrongkwailet a pikekg anti Sisas itna anong Petani pa anel ari a Sisas la Lasarus pa wrekg a mlamin pa or rpma, atom tu ti pikekg lakati naki tu ai, ti tu atning yela ise. ");
INSERT INTO urim_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kolpa atom ari tu ak wail wrekg wli rka la riwel, eng ntei, tu pikekg atning a kil pikekg elng kla titnongket titnongket itna eng ak plan titnongket a Yan alkil pa. ");
INSERT INTO urim_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Atom tu melnum a arpmen yangkipm yiprokgen a Moses pa anel naki tita la, “Kipm ri, kuina ur a mentepm alok angkengken pa ari akentiwe. Tu wrongkwail a yela kanokg ti pa am kai katnun kil ise.” ");
INSERT INTO urim_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tu Krik tiur pa pikekg wli aken men Suta pa, atom tu wa rka anong wail Serusalem pa eng la kipor kilko ilein Maur Wailen ik wang wail ti eng ikwonilmpen wang a pikekg Maur Wailen awi tu a men Isrel angkai Isip pa aye kul pa. ");
INSERT INTO urim_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Atom tu Krik pa kai ari Pilip. Pilip pa melnum a anong Petsaita a anong kanokg Kalili. Atom tu asentel la, “Melnum wailen, men la ri Sisas.” ");
INSERT INTO urim_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Atom Pilip pa kai naki Antru pa kolti, tuwekg yatenen wa kai lanaki Sisas. ");
INSERT INTO urim_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ari Sisas akalmpenten la, “Wang am kul wreren eng Yan a plan titnongket a nang wailen klalen a kil la uk Warim Kipman A Melnum ti eng kipm ri. ");
INSERT INTO urim_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kupm lanakepm aklale wrisen: kol kwei wris ur a ake alin kinar kanokg pa, ikgam rmpa kati kati kolpa rmpa pake. Pake kol kwei a alin kinar kanokg atom nilong pa kai plepm pa, pa kil raku wailet. ");
INSERT INTO urim_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kol melnum ur kil ikwonilmpen kil alkil kolti la rpmi wor i kanokg ti pa, pa kil ikga kai paipm. Pake kol melnum ur kil ake akwonalmpen kil alkil kolti la rpmi wor i kanokg ti pa, pa kil awi yaprekg watin eng rpma wor yongkyong. ");
INSERT INTO urim_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Melnum ur la ikwap eng kupm ti pa, pa kil kul kutnuntopm o! Wrik ur a kupm arpmewe pa, kil ikgam antiwopm rpma wrik pake. Wa kil ikwap eng kupm ti pa, pa Yan mpa ngkit nang akilen ti a lkel wor.” ");
INSERT INTO urim_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Atom Sisas wa la kolpa la, “Ak ketn ti pa ipma akupmen ti pa kaikut paipm wrisen, ti mpa kupm la kolai? Mpa kupm la kolkil la, 'Oi Yaiyai, wang a kalkuten wail eng a palngtopm tike, ti kitn uwiyopm iye kai tukuleikgen kalkuten ti!' A'a, ake mpa kupm la kolpa. Yiprokgen a pikekg kitn ukwawopm nar pa am la kupm rki kalkuten pake. ");
INSERT INTO urim_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Yaiyai, kuina ur la mpa palngtopm ti pa, mpa kitn plan titnongket a nang wailen klalen alkitnen pa ngko wunong!” Atom ok ur la angkaino kitnong pa nar lala, “Kupm pikekg plan titnongket a nang wailen klalen akupmen ise, ti mpa wa kupm plan nti ur pa.” ");
INSERT INTO urim_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ari tu wrongkwail a itna pa atning atom tu anel la kolpa la, “Pa milmal aki?” Ari tiur pa la, “Palpa maur akwapel a Maur Wailen nakel yangkipm ok ur pa.” ");
INSERT INTO urim_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Atom Sisas lanaken la, “Ok pa ake la nar la ik ngklin kupm ti pa, pa la nar la ik ngklin kipm pa. ");
INSERT INTO urim_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ti am wang a Maur Wailen la kipm wrong kin a kipman a itna kanokg ti la kipm antokg paipm tike atom ikga kipm uwi wleket. Ti am wa wang a kil mpa lok ngkli Maur Paipm Satan a itna tukgunakg ikgalen kanokg ti ik tike. ");
INSERT INTO urim_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wa kupm ti pa, ikga tu ngkitopm iye kaino rki kaino yo okgmangki pa. Atom wa Maur Wailen ikga wa uwiyopm iye kaino kwa ai tukwleikgen kanokg ti pa, ikga kupm uwi kipm wrongkwail kin a kipman pa iye kaino eng kupm alkupm.” ");
INSERT INTO urim_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kil la yangkipm pa naken ep la tu riwe ya a ikga kil imo pa. ");
INSERT INTO urim_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ari tu wrongkwail kin a kipman a itna pa la wli pa wli pa la, “Ti men pikekg atning yangkipm titnongket amenen a la kolpa la, ti Krais a pikekg Maur Wailen la ukwa nar eng ikuwiyo pa ikga rpmi yongkyong. Ti wa antokg kolai ti kitn wa lala Warim Kipman A Melnum ikga wa tu ngkit iye kaino rki yo okgmangki? Warim Kipman A Melnum a kitn la ti pa mla?” ");
INSERT INTO urim_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Sisas akalmpe la kil alkil la, “Wakg a ak alentepm ti pa ikga iklentepm itni waiketn kolti. Ti ik wang waiketn a wakg alen itna ti pa, kipm ngkom ik klalen tiwo, mpa miningtepm angko ya! Tu melnum a angkom atn ak miningket pa, tu ake mpa ri ya atom tu ngkom pa. ");
INSERT INTO urim_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ik wang a wakg ti ak alentepm itna ti pa, kipm kul ukipma wakg tiwo, eng mpa wakg ti kawor len itni ipma akipmen pa.” Sisas lanaki tu wrong kin a kipman pa yangkipmok pa kai plalng pa, kil am atnuurngken kai atom ake kil wa atn angko wunong eng mpa tu riwel. ");
INSERT INTO urim_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Sisas elng kla wailet ak plan titnongket a Yan alkil pa tu ari ai, pake tu ake wa ukipma kil ti. ");
INSERT INTO urim_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kolpa ti yangkipm a Aisaia melnum ok wripm a Maur Wailen pikekg la pa am palng aklale tike. Pikekg kil la, “Maur Wailen, yangkipm ti men lanaken lanaken ining, ti mla a i mpa wa ukipma yangkipm a men lanaken ti? Kalpis tuwa! A wa mla a i mpa wa ri titnongket a kitn Maur Wailen plan plan angko wunong ti? Kalpis tuwa!” ");
INSERT INTO urim_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Oklala a pikekg Aisaia nira la kolpa, pa am wa palng aklale tike. Kil pikekg nira la tu wrong kin kipman ti ake antiwe ukipma eng ntei. Kil awi ok a Maur Wailen nira kolkil la, ");
INSERT INTO urim_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","”Kupm ampri wulmpa atuwen pa, atom tu ake antiwe mpa ik ri kuina ur. A kupm antokg ipma atuwen wa kakiren, atom ake antiwe mpa tu riwe yiprokgen a yangkipm pa, atom akentiwe mpa tu plelng ipma wa yaper kul, atom ake antiwe mpa kupm ntokg tu palng wor.” ");
INSERT INTO urim_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia pikekg nira pa atnen Maur Wailen plantel ep atom kil ari a Sisas kil awi nang wailen a antiwe titnongket pa, atom kil laron Sisas pake. ");
INSERT INTO urim_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ei aklale, tu wrong wailet ake ukipma Sisas pa. Pake tu mring man wailen wailen wailet tiur pa tu ukipma. Pake tu ngkark eng laron tu alntu ti angko wunong atnen ikga tu melnum a arpmen yangkipm yiprokgen a Moses pa ungkwanten tukwuleikgen tu wrong kin a kipman mapming a ukipma Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Pa plan la tu ake wasrongen la mpa Maur Wailen pa kiporngken yangkipm ngkit nang atuwen pa. Tu wasrongen la tu melnum ti kiporngken yangkipm ngkit nang atuwen pake. ");
INSERT INTO urim_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Atom Sisas la yikakatnen ak ok wail pa la, “Melnum a kil ukipma kupm ti pa, pa ake kil ukipma kupm alkupm wris ti kolti pa. Kil wa ukipma melnum a pikekg ukwawopm atom kupm nar pa. ");
INSERT INTO urim_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Melnum a kil ari kupm ti pa, am wa kil ari melnum a ukwawopm nar pa yat pake. ");
INSERT INTO urim_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Kupm ti nar kanokg ti kolen wakg a ak alen miningket, eng mla ur a ukipma kupm ti pa kil ikgake rpmi ik miningket pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kol melnum ur kil itning yangkipm akupmen, pake kil ake katnun pa, pa kupm ti ikgake uwiyel iye kai itni yangkipm la kil ikga uwi wleket pa. Kupm ake nar kanokg ti la uwi kipm wrong kin kipman a kanokg ti iye kai itni yangkipm pa la kipm ikga uwi wleket pa. Kupm nar eng la ikuwiyepm iye yaper kul eng Yan pa. ");
INSERT INTO urim_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Melnum ur a uk yirokg kupm ti a talpulng yangkipm akupmen ti pa, am yangkipm a kupm laron ti pa ikga uwiyel iye kai itni ntokg yangkipm ik wang umpuwen pake, a kupm ti pa kalpis. ");
INSERT INTO urim_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Eng ntei, kupm ake laron yangkipm pa ak nikgwalpm alkupmen ti pa, kalpis. Yan alkupmen a pikekg ukwawopm nar pa, kil pa alkopm yangkipm titnongket la mpa kupm la kolai, a wa mpa kupm laron kuina. ");
INSERT INTO urim_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kupm ariwe la melnum a atning katnun yangkipm titnongket a kil alkopm pa, yangkipm pa mpa lkel yaprekg watin eng rpmi wor yongkyong. Atom oklala wrongkwail a kupm la ti pa, am Yan alkupm pa alkopm yangkipm titnongket la kupm lakiti kimek kimek nikepm pake.” ");
INSERT INTO urim_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Wang wail a men Suta takwem rka akwonalmpen wang a pikekg Maur Wailen awi tu a men angkai Isip pa aye kul wor ti wreren eng a palng. Pa Sisas pa kil ariwe la wang a pikekg Yan alkil alm pa am wreren tike, eng kil a utnuurng kanokg ti a kaino nti Yan alkil pa rpmi. Kil pa plan ipma wor wasrongen tu melnum alkilen a katnuntel rpma kanokg ti ak ai kulngkul, kul ngko wang a kil imo pa, pa kil plan ipma wor wasrongenten wrisen. ");
INSERT INTO urim_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ak nungkurikg pa Sisas nampokgen tu watnom a kil aroaro wonel pa tu al okipma pa rka pa, Maur Paipm Satan pa am plelngen nikgwalpm a Sutas warim kipman a Saimon Iskariot pa ise, eng mpa kil uk Sisas pa kai wam a tu wrongmanto pa. ");
INSERT INTO urim_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Sisas pa kil ariwe la Yan alkil pa pikekg alkel kweikwei wrongkwail pa kul wam akilen plalng ise. Kil ariwe la kil pikekg anti Yan Maur Wailen rpma atom nar ti kil ikga wa yaper kainontel. ");
INSERT INTO urim_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tu al okipma rka pa, kil wrekg aner apm a wropuk alkil pa, a kil ak apm a ak akul akul num pa ak angket tatu kinslikg alkilen pa. ");
INSERT INTO urim_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kil alung u kai kaimung pa ngkaten eng klak nepm a tu watnom a kil aroaro wonel pa a kil ak apm a kil ak angket kinslikg pa ak akul nepm atuwen pa. ");
INSERT INTO urim_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kil klak klak nepm a tu pa kolpa kai, kil la klak nepm a Saimon Pita pa pipa, Pita pa asentel la, “Ai, Wailen, ti kitn pa ake melnum wusok ur la mpa klak nepm akupmen ti!” ");
INSERT INTO urim_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ari Sisas akalmpentel la, “Kitn ake ariwe yiprokgen a kupm ak kolpa, pake kutnukg pa kitn ikga uwi riwe worwor pa.” ");
INSERT INTO urim_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita akalmpe la, “Akentiwe mpa kitn klak nepm akupmen ti. Kalpis wrisen!” Ari Sisas akalmpentel kolpa la, “Kol kitn ngkengkopm eng ake kupm klakeitn nepm pa, kitn ake mpa kul or wris nimpokgen kupm ti.” ");
INSERT INTO urim_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pita akalmpe la, “Wailen, kolpa pipa, ake mpa kitn klak nepm ti kolti pa, kol a kitn wa klak wam a tukgunakg ti wa nimpokgen!” ");
INSERT INTO urim_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Sisas la kolpa la, “Melnum a pikekg karkuk pa, pa kil am rukis wor ise, ti kil ake mpa wa kurkuk nti ur pa, mpa klakel nepm ti kolti. Kipm ti pa rukis wor, pake melnum wris ata pa kil pa kimpilpet.” ");
INSERT INTO urim_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Sisas pa kil ariwe ise, la mla a i mpa uk kil ti kai wam a tu wrongmanto pa, kolpa atom kil la tu kimeket pa kimpilp kalpisen wor pake, wris pa pati kimpilpet. ");
INSERT INTO urim_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kil klak nepm a tu pa kai plalng pa, kil awi apm wropuk alkil pa nowe kolti a kil kul rpma wrik a wuten kil arpme pa a tu al okipma pa rka. Atom kil asenten la, “Kipm ariwe kuina ur a wuten kupm aktepm pa aki kalpis? ");
INSERT INTO urim_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kipm akwewopm la kupm melnum a kaling plantepm a wa kipm akwewopm la kupm Wailen. Kipm akwewopm kolpa pa, pa kipm akwewopm ute pake, am kupm melnum kolpa aklale pake. ");
INSERT INTO urim_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kupm Wailen alkipmen a kupm melnum a kaling plantepm, pake kupm wuten arku kupm alkupm klakepm nepm pa, kolpa ti kipm pa mpam wa rku kipm alkipm ti klak titawel nepm pa kolpa yat pake. ");
INSERT INTO urim_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kupm ak kolpa plantepm la ikga kipm ik kitila kol a kupm ak pake. ");
INSERT INTO urim_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kupm lanakepm aklale wrisen, melnum a aken kwap orngwatneikgen mring alkil pa kil ake wailen angen mring alkil pa. A melnum a aye yangkipm itna ya pa ake wailen angen melnum a ukwawel kai pa. ");
INSERT INTO urim_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kipm am ariwe a wuten kupm ak kalingtepm pa yat ise. Ti kol kipm ikwap kol a kupm ak kil kitila kolpa iye kai pipa, kipm itopen o! Maur Wailen mpa plan ipma wor kipm pake. ");
INSERT INTO urim_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Yangkipm a kupm la kil pa ake kupm la eng kipm kimeket pa. Kupm ariwe kipm wris wris ti worwor la kipm melnum kolai, pake pikekg kupm takwei kipm ti kimeket eng mpa yangkipm a la ela wrkapm a Maur Wailen pa palng ok rke. Yangkipm pa la kolkil la, 'Melnum a kil antiwopm al okipma ti pa, kil plelng yirokg lawopm.' ");
INSERT INTO urim_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Yangkipm a kupm la ti pa ake palng, a pa. Pake kupm lanakepm ep ep eng ikga palng kolpa pipa, kipm ikga ukipma la Kupm am Rpma Kolpa Rpma pake kol a wet kupm lanakepm ti. ");
INSERT INTO urim_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kupm lanakepm aklale wrisen, melnum ur a kil atopen awi melnum a kupm ukwa kai pa atom kil ukipma pa, pa wa kil atopen awi kupm ti yat. A melnum ur a kil atopen awi kupm ti pa, pa kil atopen awi melnum a kil ukwawopm atom kupm nar pa.” ");
INSERT INTO urim_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Sisas la kolpa plalng pa, ipma a kil pa kalkut paipm kolti, atom kil laron angko wunong la, “Kupm lanakepm aklale wrisen, melnum wris ur akipmen ti pa mpa uk kupm ti kai wam a tu wrongmanto.” ");
INSERT INTO urim_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tu watnom a kil aroaro wonel pa anel tutus ikg kai tita la, pa kil la mla wai. ");
INSERT INTO urim_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Watnom wris ur a Sisas plan ipma wor wasrongen pa, kil arm yamping rmpa wreren Sisas pa al okipma rmpa. ");
INSERT INTO urim_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Atom Saimon Pita ak ikg almpel la, “Ti isentel ri, la kil la mla wai!” ");
INSERT INTO urim_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kolpa atom kil elng kai rka won a Sisas pa a asentel la, “Wailen, kitn la mla wai?” ");
INSERT INTO urim_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Sisas lanakel la, “Mpa kupm kipor nok tingklak pa ngklewe ulaket pa lkel pa, pa pati am melnum pake.” Atom kil awi okipma pa kapor kolti angklewe ulaket pa atom uk Sutas, warim kipman a Saimon Iskariot pa. ");
INSERT INTO urim_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ak wang a Sutas awi nok tingklak pa, Satan pa am pinterngen kawor rpma ipma alkilen ise. Atom Sisas lanakel la, “Kitn la ntokg kuina pa, kitn ntokg or yawel o!” ");
INSERT INTO urim_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tu rka wris al okipma pa ake ur ariwe yangkipm a Sisas naki Sutas pa. ");
INSERT INTO urim_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Sutas pa kil melnum a ikgalen marpm apmkoken atuwen pa, atom tu akwonalmpen la pa Sisas lanakel la kil kai rmpenten kweikwei elngkirmpi eng wang wail aripm ur ti ikga tu rpmi wris eng ngkit nang a Maur Wailen, aki la kil kai uk marpm tiur ik ngklin tu a rpma tukwok pa. ");
INSERT INTO urim_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Sutas awi nok tingklak pa al plalng pipa, kil wrekg kawor en ai kai. Am mining tike. ");
INSERT INTO urim_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Sutas kil kai elng kawor en ai pa, Sisas kil lanaki tu watnom alkil a rka pa kolpa la, “Wreren eng a Maur Wailen la plan titnongket a nang wailen a Warim Kipman a Melnum tike. A kuina ur wreren eng a kil la ntokg ti pa, pa mpa ik plan titnongket a nang wailen a Maur Wailen ti ngko wunong tike. ");
INSERT INTO urim_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Wa kol kil ntokg kuina ur wreren eng a kil la ntokg ti plalng atom ik plan titnongket a nang wailen a Maur Wailen ti ngko wunong ti plalng pipa, Maur Wailen kil alkil ti mpa wa plan titnongket a nang wailen akilen ti wa ngko wunong kolpa yat pake. Ti ake mpa mpen, kil eng am a ik penterngen tike. ");
INSERT INTO urim_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kipm watnom alkupmen, kupm ikgake ntiwepm rpmi i kanokg ti wang watin pa. Kipm ikga ikoropm, pake kupm la lanikepm iklale kuina ur kol a pikekg kupm naki tu melnum wailen wailen a Suta pa, la anong a kupm la kaino pa kipm ikgake ntiwe a kaino pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kupm la wa lanikepm yangkipm titnongket weten ur kil eng kipm kutnun: ti kipm mpa plan ipma wor wasrongen tita kol a kupm plan ipma wor wasrongen kipm pa! Ti kipm mpa plan ipma wor wasrongen tita kolpake! ");
INSERT INTO urim_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kol kipm kutnun nikgwalpm a plan ipma wor wasrongen tita pa pati, mpa ik plan tu wrongkwail riwepm la kipm pa kipm watnom akupmen a kupm arowonelepm pa.” ");
INSERT INTO urim_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita asen Sisas pa la, “Wailen, kitn a kai a i?” Ari Sisas akalmpe la, “Wrik a i a kupm kaiye pa, kitn akentiwe mpa ntiwopm kai ik wang ti pa. Pake ik wang kutnukg pa ikga kitn kutnuntopm kai pake.” ");
INSERT INTO urim_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Wa Pita asen la, “Wailen, antokg kolai atom wa kitn angkengkopm la akentiwe mpa kupm ntiweitn kai ik wang ti? Kupm numprampen la imo ikirmpenteitn.” ");
INSERT INTO urim_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Atom Sisas akalmpentel la, “Kitn numprampen aklale la mpa imo ikilen kupm tike! Kupm lanakeitn aklale la, mpa ik mining ti pa kitn mpa lam nang akupmen pa nti wraur, plalng pa, karek pa la!” ");
INSERT INTO urim_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Sisas lanaki tu watnom a kil aroaro wonel pa kolpa la, “Ampur kipm ipma kalkut, kipm ukipma kupm ti a wa kipm ukipma Maur Wailen pa itni titnongket. ");
INSERT INTO urim_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ti anong a Yan akupmen pa wrik wail itna. Kolpa ti kupm la ep kaino numprampen wan ti ik uwiye kipm ti wris wris iknumputepm elngtepm itni. Kol anong pa kalpis pa, pa kol ake kupm lanakepm la, kupm kaino numprampen wrik pa elngkitna eng kipm pa. ");
INSERT INTO urim_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Pake wrik wail itna pa, kolpa ti kupm la ep kaino numprampentepm wrik pa elngtepm itni. Ikga kupm wa yaper nar ik yakurepm iye kaino eng alkupmen, eng ikga kipm ntiwopm rpmi kaino anong a kupm arpme ai. ");
INSERT INTO urim_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ya a kaino anong a kupm la kainowe pa kipm ariwe pa.” ");
INSERT INTO urim_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ari Tomas lanakel la, “Wailen, men ti ake ariwe anong ikga kitn kainowe pa, ti ikga men riwe ya pa kolai eng men kaino pa?” ");
INSERT INTO urim_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Sisas akalmpentel la, “Kupm alkupm ti pa kupm ya, a kupm yiprokgen a nikgwalpm aklale, a wa kupm yiprokgen a uk yaprekg watin eng rpma wor yongkyong. Akentiwe mpa melnum ur or kol ya manet ur ai ngkom nlokgen kupm ti kaino eng Yan pa, kalpis, mpa or kupm ti kaino pake. ");
INSERT INTO urim_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Atom kol kipm riwe kupm ti worwor pa, pa am wa kipm ariwe Yan akupmen pa yat pake. Kipm am ariwel ise, atom ik wang ti kai pa, kipm mpa wa uwi riwe kil pa worwor.” ");
INSERT INTO urim_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ari Pilip la kai Sisas pa la, “Wailen, kwei ur wail a men wasrongen la kitn ntokg pa pati lala kitn planto Yan ti. Kitn planto pa, men ake mpa wa isenteitn eng Yan pa wa or pa kai om.” ");
INSERT INTO urim_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Sisas akalmpe la, “Pilip, akangklei wang angkai ai kul ti kupm antiwepm rpma ti, ake wa kitn ariwe kupm ti? Melnum ur a kil ari kupm ti pa, am kil ari Yan akupmen pa yat ise. Ti antokg kolai atom, kitn wa lala plantepm Yan ti? ");
INSERT INTO urim_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ti ake kitn ukipma la kupm ti rpma kawor Yan ti a wa Yan ti rpma or kupm ti? Ti yangkipm a kupm lanakepm pa, pa ake yangkipm a kupm la ak nikgwalpm a kupm alkupm ti pa. Pa am Yan pa rpma or kupm ti atom kwap wrongkwail a kupm ak ti pa, am kil alkil pa ak pake. ");
INSERT INTO urim_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ti kipm ukipma la Yan pa rpma or kupm ti a wa kupm ti rpma kawor Yan pa. Pake kol ake kipm ukipma kol a kupm la la pipa, ti kol a kipm ri kwap titnongket weten weten a kupm antokg ak titnongket a Yan ti pa, kol kipm ukipma kol a kupm la pa am aklale pake. ");
INSERT INTO urim_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kupm lanakepm aklale wrisen la, melnum ur a kil ukipma kupm ti pa, kil ikga ikwap kol kupm ak pa. Wa kil ikga wa ikwap kai klangkil kwap wrongkwail a kupm ak ti, eng ntei, kupm am kaino eng Yan kilke. ");
INSERT INTO urim_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Atom kuina ur a kipm ikga naren kupm ti niki Yan pa, pa ikga kupm ik pa, eng ikga Yan pa uwi nang wailen itnen kuina ur a kupm Warim Kipman alkilen ikga ik ikilmpe asen akipmen pa. ");
INSERT INTO urim_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Am wa kolpake, kipm isen kweikwei ur ik ok akupmen ti pa, pa ikga kupm ik pa.” ");
INSERT INTO urim_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Sisas kil lala, “Kol kipm plan ipma wor wasrongentopm pa, pa kipm orngwatneikg katnun yangkipm titnongket wrongkwail a kupm alkepm la kipm kutnun pa. ");
INSERT INTO urim_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Wa ikga kupm laniki Yan atom kil ikga ukwa Angklin ur a ikga itni yirokgelepm pa narntepm, a ikga ntiwepm rpmi yongkyong. ");
INSERT INTO urim_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Pa Maur Wor a la yangkipm aklale. Tu melnum a kanokg ti pa ikgake ri Maur Wor pa a tu ikgake uwi riwe kil pa, kolpa ti tu ikgake ntiwe uwi Maur Wor pa. Pake kipm ti pa kil ikga rpmi kawor kipm ti a kil ikga ntiwepm rpmi, kolpa ti kipm ikga riwe kil pa. ");
INSERT INTO urim_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Kupm ikgake utnuurngkepm rpmi kolen warim lmpo pa, kupm ikga narntepm pa. ");
INSERT INTO urim_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ikgake ingkai ai tu melnum a kanokg ti ikgake riwopm om. Pake kipm ti pa ikga riwopm pa, eng ntei, kupm ikga wa wrekg rpmi pa, a kipm ti yat ikga wa rpmi yongkyong pa. ");
INSERT INTO urim_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ikga ik wang pa kipm ikga riwe la kupm am rpma kawor Yan alkupmen ise, a kipm ikga rpmi or kupm ti, wa kupm ikga rpmi kawor kipm pa. ");
INSERT INTO urim_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Melnum ur kil itning yangkipm titnongket a pikekg kupm alkepm la kipm kutnun pa, atom kil kutnun pa, pa kil melnum a kil plan ipma wor wasrongen kupm pake. A melnum a kil plan ipma wor wasrongen kupm ti pa, pa wa Yan akupmen wa plan ipma wor wasrongen kil pa. Wa kupm ti wa plan ipma wor wasrongen melnum pa a kupm ikga plan kupm alkupm ti eng kil ri kupm ti la kupm melnum kolpake.” ");
INSERT INTO urim_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Sisas la kolpa atom ake Sutas Iskariot pa, Sutas ur manet ai akalmpe la, “Wailen, kitn la ikga plan kitn alkitn ti ngko wunong eng men ti kolti, a ikgake wa kitn plan tu wrongkwail kin a kipman a kanokg ti eng ntei?” ");
INSERT INTO urim_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ari Sisas akalmpe la, “Kol melnum ur kil plan ipma wor wasrongen kupm ti pa, pa kil mpa itning kutnun yangkipmok wrongkwail akupmen pa. Wa Yan akupmen mpa wa plan ipma wor wasrongentel, a mentekg mpa wa wlintel a wa kawor ntiwel rpmi. ");
INSERT INTO urim_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pake kol melnum ur ake plan ipma wor wasrongen kupm ti pa, pa kil ake antiwe atning katnun yangkipm akupmen ti pa. Yangkipm a kipm atning ti pa a Yan Wailen alkupm ai a ukwawopm nar ai, pa ake yangkipm a kupm alkupm ti pa. ");
INSERT INTO urim_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Yangkipm a kupm lanakepm ti pa, kupm lanakepm ak wang a kupm antiwepm rpma tike. ");
INSERT INTO urim_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pake Maur Wor Angklin a ikga itni yirokgelepm a pikekg Yan la ikga ukwa nar uwi wrik akupmen pa, kil pa ikga kiling plantepm kweikwei wrongkwail, a ikga kil ngkitepm won eng yangkipm wrongkwail a kupm lanakepm kil. ");
INSERT INTO urim_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Kupm eng a utnuurngkepm tike, ti kupm la lkepm ipma meen wor kil eng mpa kipm rpmi meen wor, pa ipma meen akupmen. A ipma meen wor a kupm la lkepm kil pa, pa ake kol a tu wrong kin a kipman a kanokg ti alkepm pa. Kolpa ti ipma akipmen pa ampur kalkut ngkark pa. ");
INSERT INTO urim_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kipm atning a kupm lanakepm pa la, kupm ikga kaino plalng atom kupm ikga wa yaper narntepm. Kol kipm plan ipma wor wasrongentopm pa, kipm mpa itopen eng kupm kaino eng Yan akupmen ti, kil pa Yan a itna wailen angen kupm ti. ");
INSERT INTO urim_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kweikwei a kupm la kil pa ake palng, a pa, pake kupm la lanikepm ep, eng kweikwei pa palng pa kipm ikga ukipma kupm ti itni titnongket. ");
INSERT INTO urim_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ti ake mpa kupm oklala ntiwepm wang watin, eng Maur Paipm Satan a itna tukgunakg ikgalen kanokg ti am wli tike. Kil ake antiwe titnongket na ur mpa wa itni ep ikglen kupm ti pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pake kweikwei pa mpam palng pake, eng mpa tu wrong kin a kipman a kanokg ti riwe la kupm plan ipma wor wasrongen Yan akupmen a kupm antokg kweikwei katila nikgwalpm a Yan lanakopm la kupm ntokg pa. Am pake, kolpa ti kipm wrekg wrekg eng tepm kai!” ");
INSERT INTO urim_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Sisas wa la kolkil la, “Kupm ti pa yo wain wor aklale. A Yan akupmen pa kil pa yan a wring wain. ");
INSERT INTO urim_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kil angket angklon wam talpuk a kul itna kupm a ake angko oken pa ungkwan ti aye kai lap takwuleikg. A wamtalpuk a ok arke pa kil kampel angklon awiyen, atom itna wriwen eng mpa ilkg inip no ngko oken yangkyang watipmen wor. ");
INSERT INTO urim_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yangkipm a pikekg kupm kaling plantepm atom kipm atning pa ak antokg kipm palng wriwen wor ise. ");
INSERT INTO urim_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kipm kirpon kupm kil itni kolpa itni pipa, kupm mpa wa kirpon kipm pa wa itni kolpa itni pa. Wam talpuk a ake almpatne itna yo manten alkil pa, kil ake antiwe mpa ok rke pa, kalpis. Yo talpuk a almpatne itna yo manten kil itna pa, pa mpa ok rke pake. Ti kipm am kolpake, ake kipm almpatne itna kupm ti pa, kipm ake antiwe mpa ok rke pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Kupm ti pa yo wain manten pake. A kipm pa wam talpuk. Wam talpuk kitn pa ilmpitne itni kupm yo manten kil, a wa kupm yo manten kil wa ilmpitne itni kitn wam talpuk pa pati, kitn ikga ok rke wailet. Kol kitn alkitn itni manet tukuleikgen kupm ti pa, kitn ake antiwe ntokg kuina ur ik kitn alkitn pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Melnum ur kitn ake karpon itna kolpa itna kupm kil pa, kitn pa kol yo talpuk wraket ti mpa tu kimpel rkol iye kai itni eng la kil nungkwor nungen pipa, lap. ");
INSERT INTO urim_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kol kipm kirpon kupm kil itni kolpa itni a wa kipm nira yangkipm a kupm kil eli kawor nol nikgwalpm akipmen pa, atom kipm isen kuina ur a kipm wasrongen pa, ikga kipm uwi pa. ");
INSERT INTO urim_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kol kipm ngko oken wor pa, mpa ik ngkit nang wailen a Yan akupmen, atom mpa plan ngko wunong la kipm watnom aklale a kupm aroaro wonel pa. ");
INSERT INTO urim_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kol Yan kil plan ipma wor wasrongen kupm ti pa, kupm am wa plan ipma wor wasrongen kipm pa kolpake. Ti kipm rkul nikgwalpm a kupm plan ipma wor wasrongentepm pa kolpa itni! ");
INSERT INTO urim_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kol kipm itning nungkulkg kutnun yangkipm titnongket a kupm alkepm la kipm kutnun pa pati, mpa kipm rkul nikgwalpm a kupm plan ipma wor wasrongentepm pa itni. Kol kupm ti am wa ak kolpake, kupm atning nungkulkg katnun yangkipm titnongket a Yan a kupm alkopm la kupm kutnun pa, atom pa kupm arkul nikgwalpm a kil plan ipma wor wasrongentopm pa itna. ");
INSERT INTO urim_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Kupm lanakepm yangkipm kil eng mpa kipm uwi atopen akupmen ti rpmi nol nikgwalpm akipmen pa, pa kipm mpa atopen wail paipm wrisen. ");
INSERT INTO urim_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yangkipm titnongket a kupm alkepm la kipm kutnun kil pati la kol kil la, kipm mpa plan ipma wor wasrongen tita, kolen a kupm plan ipma wor wasrongen kipm pa. ");
INSERT INTO urim_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kol melnum ur plan ipma wor wasrongen melnum wor ur alkil pa atom kil yipo lapen ikilentel pa, pa nikgwalpm wor wrisen itna ep am pake. Ake nikgwalpm ur manet a plan ipma wor wasrongen tita pa angen nikgwalpm pa. ");
INSERT INTO urim_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kol kipm ntokg kol kuina ur a kupm lanakepm pa, kipm pa kol melnum wor akupmen. ");
INSERT INTO urim_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Pikekg kupm akwewepm la kipm melnum a aken kwap orngwatneikgen kupm pa, pake kupm ake wa akwewepm kolpa itna pa, kalpis. Ak ti kai pa kupm akwewepm la kipm pa melnum wor akupmen. Pati atnen melnum a aken kwap orngwatneikgen mring pa, kil ake mpa riwe kuina ur a mring alkil a ikgalentel pa antokg pa, kalpis. Pake kupm am pikekg lanakepm kweikwei wrongkwail pa ise a pikekg kupm atning a Yan alkupmen lanakopm pa. ");
INSERT INTO urim_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kipm ake pikekg takwei kupm ti pa, kalpis. Pikekg kupm ti takwei kipm pake, atom ngkat kipm pa elng itna eng la kipm wrekg kai ikwap wor, a la kipm ngko ok rke wor a wa la ok akipmen pa ikga rki yongkyong. Kolpa ti Yan akupmen pa mpa kil lkepm kuina ur a kipm naren kupm ti asentel pa. ");
INSERT INTO urim_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Wa kupm wa la lanikepm yangkipm titnongket a wet kupm la kipm kutnun pa lala, kipm mpa plan ipma wor wasrongen tita.” ");
INSERT INTO urim_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Atom wa Sisas wa lanaki tu watnom a kil aroaro wonel pa kolkil la, “Kol tu wrongkwail kin a kipman a alupm nikgwalpm a kanokg ti uwi wrongmanto lan kipm pa pati, kipm mpa wonrpme riwe la kupm am tu pikekg awi wrongmanto lantopm ep kolpa yat pake. ");
INSERT INTO urim_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kol kipm a kanokg ti pati, kol a wrong kin a kipman a kanokg ti wasrongen kipm ti kolen la kipm ti atuwen pa. Pake pikekg kupm takwei kipm ti eng alkupmen elngkitna manet takwulelkgen tu melnum a alupm nikgwalpm a kanokg ti. Kolpa ti kipm pa ake a kanokg ti pa. Atom ari wrong kin a kipman a kanokg ti awi wrongmanto lantepm pa. ");
INSERT INTO urim_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kipm wonrpme yangkipm a pikekg kupm lanakepm pa: melnum a aken kwap kalpmlel orngwatneikgen mring alkil pa, kil pa ake mpa wa itni wailen klangkil mring alkil pa. Kol pikekg tu uk wleket or ungkwan kupm kil pa, tu ikgam wa uk wleket or ungkwan kipm pa kolpa yat pake. Kol pikekg tu itning yangkipm akupmen kil kutnun pa, tu ikgam wa itning yangkipm akipmen pa kutnun kolpa yat pake. ");
INSERT INTO urim_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ikg am tu iktepm paipmel kolpake, itnen kipm ti akupmen. Pati atnen tu ake ariwe melnum a pikekg ukwa kupm ti nar pa. ");
INSERT INTO urim_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kol kupm pikekg ake nar naken yangkipm a Yan pa, tu kol a ake elukgen yangkipm a kupm pa, kolpa ti tu kol a ntiwe yangkipm a ikilmpe yangkipm pa. Ari am pikekg tu atning yangkipm a kupm laron naken ise, kolpa ti tu yangkipm kalpisen mpa tu la kolai, eng paipmpaipm a tu antokg pa. ");
INSERT INTO urim_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Melnum ur a awi wrongmanto lan kupm ti pa, am wa kil awi wrongmanto lan Yan akupmen pa yat pake. ");
INSERT INTO urim_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ti kol kupm pikekg ake antokg kweikwei titnongket titnongket itna wulmpa atuwen a kol akentiwe a melnum ur a itna kanokg ti antokg pa, pa tu kol a ntiwe yangkipm a ikilmpe yangkipm pa. Ari tu ari kweikwei titnongket titnongket a kupm antokg ti, ari wa tu wa awi wrongmanto lan kupm ti nampokgen Yan alkupmen pa. ");
INSERT INTO urim_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pake pa palng kolpa eng mpa yangkipm titnongket ur alkipm a nira ela wrkapm pa palng ngko ok rke, pa la kolkil la, 'Pa yiprokgen kalpisen a tu awi wrongmanto lan kupm ti.' ");
INSERT INTO urim_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pake ikga Maur Wor a anti Yan pa rpma pa narntepm. Kil Maur Wor a ikga itni yirokgelepm a ngklinsepm, a lkepm nikgwalpm ute aklale. Kil anti Yan pa rpma atom ikga kupm ukwawel nar. Kil ariwe kupm ti atom kil ikga laron kupm ti nikepm nikepm ik titnongketel la pa aklale. ");
INSERT INTO urim_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Wa kipm ti yat, ngkaten ak wang a kupm ak kwap ti pa, kipm am antiwopm rpma ak ai kulngkul am kul tike, kolpa ti kipm ikga wa laron kupm ti ik titnongketel la pa aklale.” ");
INSERT INTO urim_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Atom wa Sisas lanaki tu watnom a kil aroaro wonel pa kolpa la, “Ti kupm lanakepm kweikwei pa eng ake mpa kipm utnuurng a kipm ukipma kupm pa. ");
INSERT INTO urim_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Aklale wrisen, ikga tu ungkwantepm i wan a kipm atning yangkipm a Maur Wailen arpme arpme pa or kai en ti tukuleikgen. Wang ur kolpa ikga wa palngtepm a tu melnum ikga wli ilmpepm imo pa, pa tu ikga ikwonilmpen la pa tu akwap wor eng ukwor Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Tu ikga ntokg kweikwei paipm paipm kolpa, eng ntei, tu ake ariwe Yan pa a wa tu ake ariwe kupm ti yat. ");
INSERT INTO urim_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ti kupm lanakepm yangkipm kil ep eng ikga wang pa palng pa, kipm ikga riwe la yangkipm pa am pikekg kupm naki karkurngkepm yat ise.” Wa Sisas la kolpa kai la, “Ake pikekg kupm lanakepm kalkuten kweikwei a ikga palngtepm pa ep ak ai, eng ntei, kupm pikekg antiwepm rpma a pa. ");
INSERT INTO urim_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kupm am a kaino eng melnum a pikekg ukwawopm nar tike, pake ake wa kupm atning kipm ur wa asentopm la, 'Kitn a kai a i?' ");
INSERT INTO urim_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kipm tatar rka eng ntei, kipm atning oklala a wet kupm lanakepm pa atom kipm ipma kalkut paipm. ");
INSERT INTO urim_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pake kupm lanakepm aklale wrisen la, kol a kupm utnuurngkepm kaino tukwleikgtepm pa pati, kol a wor eng kipm pake. Ake kupm utnuurngkepm kaino tukwleikgtepm pa, pa Maur Wor a ikga itni yirokgelepm a ngklinsepm pa ikgake narntepm. Ti kupm kaino tukwlelkgtepm pa, ikga kupm ukwa Maur Wor pa narntepm pa. ");
INSERT INTO urim_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Atom ik wang a Maur Wor pa nar pa, kil ikga plan ngko wunong nikgwalpm kuina kuina a i paipm, a nikgwalpm kuina kuina a i ute wor a kipm wrong kin a kipman a kanokg ti antokg pa. A wa kil ikga wa plan ngko wunong mla mla a i Maur Wailen ikga ri la tu antokg paipm pa, kil ikga lken wleket ikilmpe paipm a tu antokg pa. ");
INSERT INTO urim_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tu ake ukipma kupm ti pa, ikga Maur Wor pa planten ngko wunong la pa tu antokg paipmpaipm. ");
INSERT INTO urim_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kol kupm melnum paipm kolpa pa, kupm kol ake antiwe kaino eng Yan pa. Ari Maur Wor pa plan tu wrong kin a kipman a kanokg ti la kupm kil pa melnum ute wor itna wulmpa a Yan pa. Atom kupm ikga utnuurngkepm kaino eng Yan pa, a kipm pa ikgake ntiwe wa riwopm. ");
INSERT INTO urim_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Atom ikga Maur Wor pa plan tu wrong kin kipman pa la Maur Wailen ikga uk wleket tu a antokg paipmpaipm, pa ikgake kalpis pa. Eng ntei, Maur Wailen atning yangkipm a Maur Paipm Satan a itna tukgunakg ikgalen kanokg ti ise, atom kil ikgam wa ntokgtel paipm pake. ");
INSERT INTO urim_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Kupm nikgwalpm watipmen rpma la kol a lanikepm ari, pa wonet eng kipm uwi riwe yangkipm pa kimeket, kolpa ti tiur pa itni pa pen. ");
INSERT INTO urim_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pake ik wang a Maur Wor a alupm nikgwalpm aklale pa kil nar pa, pa kil ikga ikupewepm itn a kiling plantepm nikgwalpm iklale wrongkwail ikalkilel kolpa iye or pa kai. Ikgake kil alkil ti la ik nikgwalpm a kil alkil ti pa, kalpis, kil ikga itning kuina ur a Yan pa la atom kil lanikepm. A kil ikga wa laron nikepm kuina ur ikga palng kutnukg ai. ");
INSERT INTO urim_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Kil ikga ik ngkit nang wailen klalen akupmen ti iye kaino kwa, eng ntei kil ikga uwi nikgwalpm akupmen atom lanikepm ngko wunong. ");
INSERT INTO urim_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kweikwei wrongkwail a Yan pa, pa akupmen. Kolpa atom kupm la Maur Wor pa ikga uwi nikgwalpm akupmen ti atom laron nikepm.” ");
INSERT INTO urim_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Atom Sisas lanaki tu watnom a kil aroaro wonel pa kolpa itna la, “Ikg a itni wang tukwok ketn kolti, kipm ikgake riwopm. Wa ikga wa itni wang tukwok ketn kolti, kipm ikga wa riwopm pa.” ");
INSERT INTO urim_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Atom tu watnom alkil pa tu atning kolpa atom tu asen tita la, “Ti kil la kolpa eng itna kolai, la ikga itni wang tukwok ketn kolti, mentepm ikgake riwel. Wa ikga wa itni wang tukwok ketn kolti, mentepm ikga wa riwel. A wa kil la kolpa la kil am kaino eng Yan tike, ti wa kil la kolpa eng itna kolai?” ");
INSERT INTO urim_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","A wa tu wa asen tita kolkil la, “Kil la kolpa la ikga itni wang tukwok ketn kolti, pa kil la kolpa eng itna kolai? Mentepm akwekgel yangkipm a kil la kolpa.” ");
INSERT INTO urim_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ari Sisas pa ari ise la tu la isentel, atom kil lala, “Kipm asen tita yangkipm a kupm la la, ikga itni wang tukwok ketn kolti, kipm ikgake riwopm. Wa ikga wa itni wang tukwok ketn kolti, kipm ikga wa riwopm. ");
INSERT INTO urim_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kupm lanakepm aklale wrisen, kipm ti ikga akg rein ik ok numputen, pake tu wrong kin a kipman a kanokg ti pa tu ikga itopen. Kipm ikga ipma kalkut wail pake, ipma kalkut akipmen pa ikga wa palng atopen. ");
INSERT INTO urim_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pa ikga kolen kin a raku warim pa: ak wang a warim alm num pa kil awi wleket, am wang alkil a kil eng a raku warim pake. Kil raku warim pa plalng pa kil atopen, kil ake wa akwonalmpen wleket pa, eng ntei, warim am kil raku ise. ");
INSERT INTO urim_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ti am kolpake, ti wang akipmen a ipma kaikut tike, pake ikga kupm riwepm pa, kipm ikga itopen paipm ik wang pa. Atopen pa ikgake antiwe a melnum ur ungkwan tukwlelkgen kipm pa. ");
INSERT INTO urim_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ikg a ik wang pa kipm ikgake wa lanikopm nti ur eng kupm wa lkepm nikgwalpm ur pa. Wa kupm lanakepm aklale wrisen, kuina ur ikga kipm naren kupm ti isen Yan akupmen ti pa, Yan ikga lkepm pa. ");
INSERT INTO urim_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Pikekg kipm ake narentopm asentel kwei ur. Ti kipm isentel o! Kipm ikga uwi pa. Eng mpa ntokg kipm itopen wail manten.” ");
INSERT INTO urim_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Pikekg kupm ak yangkipm kla kolngkolti nakepm nakepm yangkipm ok ti. Pake wang ur ikga palng pa, ikgake kupm lanikepm ik yangkipm kla pa. Ikga kupm lanikepm ngko wunong kolti yangkipm a ak la Yan pa. ");
INSERT INTO urim_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ik wang pa kipm alkipm pa ikga naren kupm ti oklala naki Yan pake, ikgake wa kupm ti wa uwi ok akipmen pa atom oklala niki Yan pa. ");
INSERT INTO urim_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Eng ntei, Yan kil alkil pa wasrongen kipm pa, eng ntei kipm ti pikekg uk ipma wor wasrongen kupm ti a kipm pikekg ukipma la Maur Wailen kil ukwawopm nar. ");
INSERT INTO urim_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Kupm pikekg atnuurng Yan akupmen pa nar kanokg ti. Ti kupm am wa la utnuurng kanokg ti a wa yaper kaino eng Yan akupmen tike.” ");
INSERT INTO urim_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Sisas la pa, atom tu watnom a kil aroaro wonel pa lala, “Ti atn atn, kitn wa laron yangkipmok pa kai angko wunong tike, ake kitn ak yangkipm kla pa. ");
INSERT INTO urim_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Pake men ariwe la kitn ariwe kweikwei wrongkwail, kuina ur a men la mpa oklala nikeitn pa, kitn am ariwe ise, kolpa atom antokg men ukipma la kitn pikekg Yan pa ukwaweitn nar aklale pake.” ");
INSERT INTO urim_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Sisas akalmpenten la, “Ti kipm ukipma kupm ti aklale! ");
INSERT INTO urim_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pake kipm rpmi won rpme! Wang pa ikga palng, ti am palng tike, eng ikga kipm ngkirk purngprarng utnuurngkopm kai tutu palpa, atom ikga kupm alkupm wris kolti itni. Pake ikga ake kupm alkupm wris ti itni pa, Yan alkupmen ikga ntiwopm itni pa. ");
INSERT INTO urim_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kupm lanakepm yangkipm kil eng mpa kipm rkul kupm ti rpmingkawor ipma akipmen pa, eng mpa kipm uwi ipma kupuk meen wor. Kipm rpma nampokgen tu melnum a alupm nikgwalpm a kanokg ti pa kipm ikga uwi kalkuten wail wail. Pake titnongket a kanokg ti pa am pikekg kupm alok angkli ise, ti ampur kipm akwonalmpen watipmen, kipm ukipma itopen itni titnongket kolpa kai o!” ");
INSERT INTO urim_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Sisas la yangkipm pa naki tu watnom a kil aroaro wonel pa plalng pa, kil ikg kaino kitnong ai a kil oklala naki Maur Wailen pa la, “Yayai, wang am kul wreren tike. Ti kai kitn plan titnongket a nang wailen a Warim Kipman alkitnen ti ngko wunong, eng mpa wa Warim Kipman alkitnen ti wa plan titnongket a nang wailen a kitn Yan pa. ");
INSERT INTO urim_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pikekg kitn alkel titnongket a nang wailen eng la kil itni ikglen tu wrong kin kipman wrongkwail ti, eng ikga kil uk yaprekg watin akilen pa tu melnum wrongkwail a pikekg kitn uk kul wam akilen ti atom tu ikga rpmi wor yongkyong. ");
INSERT INTO urim_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tu ikga uwi yaprekg watin a ak angklin tu rpma wor yongkyong pa ti itna kolkil: tu ikga uwi riwe kitn pa la, kitn Maur Wailen wris ata aklale, a tu ikga wa uwi riwe Sisas Krais pa la kil melnum a pikekg kitn ukwa nar ti. ");
INSERT INTO urim_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kwap wrongkwail pikekg kitn alkopm pa, kupm ak plalng, atom pa ak plan titnongket a nang wailen akitnen itna kanokg ti, atom tu wrong kinkipman wrongkwail ari pa. ");
INSERT INTO urim_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Yaiyai, kupm pikekg antiwe titnongket a nang wailen antiweitn rpma ep ise, atom kitn antokg kitnong a kanokg pa. Ti kitn uwiyopm iye yaper kaino ntiweitn rpmi ntiwe titnongket a nang wailen irir kol a pikekg kupm antiwe ep pa.” ");
INSERT INTO urim_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Kupm laron nang akitnen ti naki tu melnum akitnen a itna kanokg ti a pikekg kitn takweiyen atom alkopm pa, atom tu ariwe kitn pa ise. Tu melnum akitnen pake, pikekg kitn uk kul wam akupmen ti, atom tu awi yangkipm akitnen pa katnun. ");
INSERT INTO urim_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Atom tu ariwe la kweikwei wrongkwail a kitn alkopm pa, pa am angkaino kitn alkitn pa nar pake. ");
INSERT INTO urim_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ti yangkipm pikekg kitn alkopm pa, pa kupm lanaken, ti tu atopen awi ise. Tu ariwe la pa aklale wrisen la, kupm pikekg anti kitn pa rpma kaino pa atom kupm angkaino pa nar, a wa tu ukipma la kupm ti pa am pikekg kitn alkitn pa ukwawopm nar pake. ");
INSERT INTO urim_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Kupm oklala nakeitn eng kitn ngklin tu pa. Ake kupm oklala nakeitn eng kitn ngklin tu melnum a alupm nikgwalpm a kanokg ti pa. Kupm oklala nakeitn eng kitn ngklin tu melnum a kitn alkopm tike, eng ntei, tu pa akitnen. ");
INSERT INTO urim_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ti tu melnum akupmen ti pa, pa tu akitnen, a tu melnum akitnen pa, pa tu akupmen. Tu pa plan titnongket a nigkwalpm wor akupmen pa atom ak ngkat nang akupmen ti. ");
INSERT INTO urim_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kupm ikgake rpmi watinet i kanokg ti, pake tu ti pa ikga rpma kanokg ti, a kupm ti pa ikga kainonteitn. Yaiyai alkupm! Kitn pa melnum klalen wakget. Ti kitn ik upaarngken o, eng mpa tu rkul nang akitnen a pikekg kitn alkopm pa tongtong, eng mpa tu palng wris nimpokgen tita kol mentekg a wris pa. ");
INSERT INTO urim_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ak wang a kupm antiwen rpma ti pa, kupm ak ipaarngken ariworwor ak titnongket a nang akitnen a kitn alkopm pa. Kupm atnenten ariworwor itna pa atom ake melnum ur atnuurngkopm kai am pa, tu kimeket rka. Melnum wris a talpulng ok akupmen pa kolti atnuurngkopm atom ikga uwi wleket itni yongkyong, eng mpa palng ok rke kol a wrkapm la pa. ");
INSERT INTO urim_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kupm am a kainonteitn pake. Pake kupm la yangkipmok kweikwei tiur ti ak wang ketn a kupm antiwen rpma kanokg a ti pen, eng mpa tu uwi atopen wail akupmen ti rpmi kawor ipma atuwen pa eng mpa tu itopen worwor kol kupm ti. ");
INSERT INTO urim_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Kupm laron yangkipm a kitn pa naken plalngten ise, atom tu melnum a alupm nikgwalpm a kanokg ti pa tu awi wrongmanto lan tu ti, atnen tu ti ake alupm nikgwalpm a kanokg ti pa. Kol kupm ti yat, kupm ti ake wa alupm nikgwalpm a kanokg ti pa. ");
INSERT INTO urim_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ti kol a kupm lanakeitn ti pa, ake kupm lanakeitn la kitn uwiyen iye kai tukwlelkgen kanokg ti pa, a'a. Kupm lanakeitn la kitn ikglenten eng ake mpa Maur Paipm pa ntokgten paipm pa. ");
INSERT INTO urim_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tu ti ake melnum a kanokg ti, a wa kol kupm ti yat pa kupm ti ake wa melnum a kanokg ti pa. ");
INSERT INTO urim_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kitn ntokg yangkipm aklale akitnen ti ikwap kawor ipma atuwen ti ik mprinsen elngitni manet eng alkitnen. Ti am yangkipm akitnen pa laron nikgwalpm aklale wrisen pake. ");
INSERT INTO urim_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kol a pikekg kitn ukwawopm nar kanokg ti pa, pa am wa kupm wa ukwawen kolpa kai yela kanokg ti. ");
INSERT INTO urim_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kupm amprin kupm alkupm ti itna manet eng kitn eng ik ngklin tu ti, eng nikgwalpm aklale wrisen akitnen pa mpa wa ik mprin tu ti wa itni manet eng kitn pa.” ");
INSERT INTO urim_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Wa Sisas asen Yan alkilen pa kolpa itna la, “Ake kupm oklala nakeitn la kitn ngklin tu watnom a kupm aroaro wonel ti kolti pa, a'a. Kupm wa lanakeitn la la kitn wa ngklin tu melnum a ikga itning yangkipm a tu ti laron niken, atom ikga tu ukipma kupm ti iye or pa kai. ");
INSERT INTO urim_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kolpa eng mpa tu ti a tu ai mpa tu palng wris, kol kitn Yaiyai rpma or kupm ti wa kupm ti rpma kawor kitn pa. Wa tu pa yat ikga wa rpmi or mentekg ti, eng mpa tu melnum a kanokg ti tu ukipma la kupm ti pikekg kitn ukwawopm nar pa. ");
INSERT INTO urim_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kupm alken titnongket a nang wailen a pikekg kitn alkopm pa, eng mpa ntokg tu palng wris nimpokgen tita kol mentekg a wris pa. ");
INSERT INTO urim_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kupm ti rpma kawor tu ti, a kitn pa rpma or kupm ti. Kolpa eng mpa tu palng num wris kolti nimpokgen mentekg ti, eng mpa tu melnum a kanokg ti ri atom tu uwi riwe la, kupm ti pa pikekg kitn alkitn pa ukwawopm nar, a wa kitn plan ipma wor wasrongen tu ti kol a kitn plan ipma wor wasrongen kupm ti pa. ");
INSERT INTO urim_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Yaiyai, kupm wasrongen tu melnum a kitn alkopm pa la tu ntiwopm rpmi kaino anong a ikga kupm rpmi pa, eng mpa tu ri titnongket a nang wailen a pikekg kitn alkopm pa. Pikekg ep ak wang lmpiwen ai pa kitn pikekg plan ipma wor wasrongentopm, kolpa atom ari kitn pikekg alkopm titnongket a nang wailen pa, plalng pipa, kitn antokg kitnong a kanokg ti pa. ");
INSERT INTO urim_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Yaiyai, kitn pa ute wor wrisen, ti tu a kanokg ti pa ake ariwe kitn pa. Pake kupm ti ariwe kitn pa, atom tu akupmen ti pa wa awi ariwe kitn pa la pikekg kitn pa ukwawopm nar kanokg ti. ");
INSERT INTO urim_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kupm lakati kitn pa naken, ti tu ariweweitn worwor pa. Ti ikgam wa kupm lakiti kitn pa niken kolpa kai pake, eng mpa tu plan ipma wor wasrongen nikgwalpm a plan ipma wor wasrongen tita irir kol kitn plan ipma wor wasrongen kupm ti, eng mpa kupm rpmi kawor tu pa kolpa kai pa.” ");
INSERT INTO urim_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Sisas oklala naki Maur Wailen pa plalng pa, kil awi watnom a kil aroaro wonel pa atom tu kawor angket kwokg Kitron pa kai kwokg wompel a melnum ur antokg wring olip atnewe pa, atom tu rka pa. ");
INSERT INTO urim_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ari Sutas, melnum mpa elng Sisas pa kai wam a tu wrongmanto pa, kil wa ariwe wrik pa. Eng ntei, anti watipmen pa Sisas awi tu watnom a kil aroaro wonel pa aye kawor kai rka rka kai wrik pa. ");
INSERT INTO urim_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Atom Sutas kai ari tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen a wa tu melnum a arpmen yangkipm yiprokgen a Moses pa ukwa tu wantengkwang atuwen a wa tu melnum a almpwrong a tu Rom pa, atom kil awi tu pa anel kulngkul. Tu ngkat wri pa arki arki a wakg yilpo tareing pa aye aye ak alen ya pa anel kulngkul. ");
INSERT INTO urim_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tu kul palng kul wrik a tu watnom a Sisas arke ti atom Sisas pa ariwe kuina ur mpa palngtel pa ise, atom kil wrekg or asenten la, “Kipm akor mla wai?” ");
INSERT INTO urim_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ari tu pa akalmpe la, “Men akor Sisas a Nasaret.” Kolpa ari wa kil akalmpe la, “Kupm am Rpma Kolpa Rpma pake, kupm am tike!” A Sutas melnum mpa elng kil kai wam atuwen pa antiwen itna. ");
INSERT INTO urim_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ak wang ketn a tu atning a Sisas lala, “Kupm am Rpma Kolpa Rpma pake” pipa, tu anel arkolng ak yirokgel kai angko elng kai kanokg ai. ");
INSERT INTO urim_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Wa Sisas asenten anti ur la, “Kipm akor mla?” Ari tu akalmpe lala, “Men akor Sisas a Nasaret.” ");
INSERT INTO urim_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Sisas akalmpe la, “Kupm wet lanakepm ti la Kupm am Rpma Kolpa Rpma pake, kupm am tike! Kol kipm ikor kupm ti pa, mpa kipm ntokg kolai kupm ti kolti, a tu pa kalpis, itni eng tu kai o!” ");
INSERT INTO urim_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kil la kolpa eng mpa yangkipm a pikekg kil alkil la pa mpa palng ok rke, yangkipm pa la kolkil la “Ake pikekg kupm atnuurng melnum wris ur a pikekg kitn alkopm pa tu kai am pa.” ");
INSERT INTO urim_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ari Saimon Pita pa nalu kowri pa no wampor ak wangket melnum akwapel ur a melnum tukgunakgen a itna ep eng tu ipma krakgen kimeket a ak ak kwap itna yalming a Maur Wailen pa, kai nungkulkg wompel wiyen a melnum pa kitnangku kolti ok atnen Sisas pa. Nang a melnum pa Malkus. ");
INSERT INTO urim_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ari Sisas lanakel la “Kitn lupm kowri pa kinar timpal alkil ai! Kitn lala, ake mpa kupm uwi wleket ti kol u kinipis a rpma kaimung a pikekg Yan alkopm lala mpa kupm il ngkowe pa aki?” ");
INSERT INTO urim_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kolti tu a almpwrong pa nampokgen melnum wailen itna ep alntu pa, a wa tu wantengkwang a tu melnum wailen wailen a men Suta pa anel arkul Sisas pa angkuten ak ampei pa. ");
INSERT INTO urim_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Atom anel ayewel kai itna Anas pa ep, yalmpin wror a Kaiapas, melnum a pikekg awi wrik a Anas pa itna ep eng tu ipma krakgen kimeket a ak ak kwap itna yalming a Maur Wailen ak wring pa. ");
INSERT INTO urim_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kil pa Melnum a pikekg uk nikgwalpm tu melnum wailen wailen a ikgalen men Suta pa la, “Kol melnum wris ur kolti uwi wrik a tu wrong kin a kipman pa imo pati, kol a wor pake.” Melnum a pikekg lanaken kolpa pa am Kaiapas pake. ");
INSERT INTO urim_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita nampokgen watnom ur manet a Sisas pa, tuwekg katnun Sisas pa kai. Watnom pa melnum tukgunakg a itna ep eng tu ipma krakgen kimeket pa ariwe kil pa worwor pake, atom kil pa katnun Sisas pa kai kawor wan anong a melnum tukgunakg pa. ");
INSERT INTO urim_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ari Pita pa kai itna yipmingki yun enen ai itna wai. Atom watnom a Sisas pa a melnum tukgunakg a itna ep eng tu ipma krakgen kimeket pa ariwewel worwor pa yaper or wa anti kin ur a atnen yipmingki yun pa oklala. Atom kin pa awi wor atom kil or ak yakur Pita pa tuwekg kawor yipmingki wunen. ");
INSERT INTO urim_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Atom kin pa lanaki Pita pa la, “Kupm akwonalmpen la kitn ti am wa watnom ur a melnum a wet or ti aroaro wonel pake.” Ari Pita aner ok lala, “Kupm kalpis.” ");
INSERT INTO urim_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ak wang pa kupuk paipm atom tu wantengkwang a ikgalen yalming a Maur Wailen, a nampokgen tu melnum akwapel pa alile wakg, atom Pita pa antiwen arkgin wakg pa itna. ");
INSERT INTO urim_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Atom tu awi Sisas pa aye kai itna Anas melnum tukgunakgen a pikekg itna ep eng tu ipma krakgen kimeket pa, atom kil asen Sisas pa eng tu watnom alkil a kil aroaro wonel pa ti a wa asentel eng yangkipm a pikekg kil aroaro wonel tu wrong kin kipman pa. ");
INSERT INTO urim_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ari Sisas akalmpe la, “Ake kupm la yangkipm ur pa ampen pa. Yangkipm wrongkwail ti pa kupm laron itna wulmpa a tu wrongkwail a kanokg ti. A kupm laron itna wan a mentepm atning yangkipm a Maur Wailen atne atne pa, wa itna yipmingki wunen a yalming a Maur Wailen pa a mentepm Suta wli takwem rka wris pa. ");
INSERT INTO urim_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kitn asen kupm ti eng na wai? Kol a kitn isen tu melnum a pikekg atning yangkipm a kupm laron pa. Tu pa ariwe kuina ur a pikekg kupm la pake.” ");
INSERT INTO urim_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Sisas la kolpa ari kalpis, melnum wantengkwang wris ur a ikgalen yalming a Maur Wailen pa wampor wam plas atnentel kai tangkwei wompel pa a kil la, “Pa nikgwalpm wor a kitn akalmpe kolpa naki melnum tukgunakg a pikekg itna ep eng tu ipma krakgen kimeket a Maur Wailen pake?” ");
INSERT INTO urim_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ari Sisas akalmpe la, “Ti pa kupm la paipm, ti kitn lakiti paipm ur a wuten kupm la pawo! Kol kupm la ute wor aklale pa, ti wa kitn wa oropm eng ntei?” ");
INSERT INTO urim_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tu oklala kolpa itna pa plalng, atom wa Anas wa lanaki tu awiyel a pa wa aye kai itna Kaiapas melnum tukgunakg a ak wring pa itna ep eng tu ipma krakgen kimeket a Maur Wailen. Kil ngkaten ampei a tu angkutentel pa aye kolpa kai pake. ");
INSERT INTO urim_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita am anti tu arkgin wakg itna pa itna pake. Atom tu a itna pa asentel la, “Ti kitn ti watnom ur a melnum a kawor ai aroaro wonel pa aki?” Ari Pita wa aner ok la, “Kupm akwekgel melnum pa, kupm kalpis.” ");
INSERT INTO urim_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ari melnum ur a akwap orngwatneikgen melnum tukgunakg a itna ep eng tu ipma krakgen kimeket a Maur Wailen pa, melnum pa walmpopm wris ur a melnum wuten Pita angket nungkulkgel pa, kil lala, “Ti kupm wuten ari kitn anti melnum pa itna kai wring olip pa!” ");
INSERT INTO urim_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ari wa Pita wa aner ok la anti ur lala, “Kupm akwekgel melnum pa, kupm kalpis.” Kil la kolpa pipa, karek pa la. ");
INSERT INTO urim_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tu wailen wailen a men Suta pa antokg yangkipm anti Sisas itna Kaiapas pa plalng pipa, wa tu awi Sisas ak kong miningket ai a wan a Kaiapas pa, wa anel aye kai wan anong a Pailat, mring man wailen a Rom a itna tukgunakg ikgalen anong kanokg a Sutia pa. Atom tu melnum wailen wailen a men Suta pa karken a kawor wan a melnum yimponen a Rom pa, mpa ntokg tu ti kalkut, atom tu ake antiwe ikgkil itopen wang wail a pikekg Maur Wailen awi tu amenen angkai Isip pa kul wor pa. ");
INSERT INTO urim_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kolpa atom Pailat pa or en ti, a asenten la, “Kipm arkiwel eng kil antokg na paipm atom kipm ayewel wli la ntokg yangkipm ti?” ");
INSERT INTO urim_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ari tu pa akalmpe la, “Kol kil ake ntokg paipmpaipm ur pa, men kol ake uwiyel iye wli itni kitn ti pa.” ");
INSERT INTO urim_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Atom Pailat pa lanaken la, “Kai kipm uwiyel iye kai ntokg yangkipm kutnun yangkipm titnongket a kipm alkipm Suta yapon pawo!” Kolpa ari wa tu wailen wailen a men Suta pa akalmpe la, “Yangkipm titnongket a kipm Rom pa la ake mpa men ilm melnum ur imo pa.” ");
INSERT INTO urim_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yangkipm a tu la Sisas kolpa pa, pa tu la kai katila oklala a kil alkil a pikekg kil lakati la kil ikgam imo or kol ya tike. Atom yangkipm a kil la pa am palng ok arke aklale tike. ");
INSERT INTO urim_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Wa Pailat wa yaper kawor wan wail alkil pa, atom kil la atom tu awi Sisas pa aye kaworntel. Atom kil asentel lala, “Kitn ti am melnum tukgunakg a kipm Suta tike?” ");
INSERT INTO urim_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Sisas akalmpe la, “Pa kitn atning tu tiur ai lakati kupm ti nakeitn aki, a kitn ak nikgwalpm a kitn alkitn ti la?” ");
INSERT INTO urim_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ari Pailat pa akalmpe la, “Kitn akwonalmpen la la kupm ti melnum Suta pake! Pa am tu wrong kin kipman alkitnen pa nampokgen tu melnum tukgunakgen a tu a ak ak kwap eng al wor uk Maur Wailen alkipmen a kipm Suta pa ayeweitn wli itna kupm tike. Kitn antokg kuina atom tu ayeweitn wli itna kupm ti?” ");
INSERT INTO urim_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Sisas wa la, “Ake pikekg tu wrong kin kipman a kanokg ti ngkatopm la kupm itni melnum tukgunakg ikglen kweikwei wrongkwail ti. Kol tu a kanokg ti ngkitopm pa, pa kol tu melnum akupmen pa ngklinsopm or tu Suta wailen wailen pa okitnentopm pa. Ari kalpis, pa ake tu a kanokg ti ngkatopm pa!” ");
INSERT INTO urim_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Atom Pailat pa asentel la, “Ti kitn pa melnum tukgunakg ur aklale pake?” Kil asen kolpa ari wa Sisas pa akalmpe la, “Ei, am kol a kitn la pake, kupm am melnum tukgunakg pake. Yiprokgen a pikekg kupm nar kanokg ti atom man rakuwopm ti pati, am la kupm la ik titnongketel pa ngko wunong eng mpa kipm wrong kin kipman a kanokg ti itning uwi riwe nikgwalpm ute aklale pa. Ti melnum a itna nampokgen nikgwalpm ute aklale pa, kil pa atning katnun yangkipm a kupm la pa.” ");
INSERT INTO urim_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Wa Pailat pa asentel la, “Ti nikgwalpm ute aklale pa a i?” Kolti Pailat pa wa kul or ari tu melnum wailen wailen a men Suta a nungkwangen itna en pa anti ur atom kil lala, “Ake kupm ari kil antokg paipm ur, kalpis. ");
INSERT INTO urim_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Akangklei wring wris wris ak wang wail a kipm atopen wang wail a pikekg tu kipm Isrel angkai Isip pa kul pa, kupm elngentepm melnum wris ur or kai takwulelkgen wan tipmining pa. Ti kipm wasrongen la kupm elngentepm melnum tukgunakg a kipm Suta a itna kawor wan akupmen ti kul or en kai om?” ");
INSERT INTO urim_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kolpa ari tu la yikakatnen la, “Ampur elngen melnum pa or en kai pa! Elngen Parapas pa or o!” Parapas pa melnum melkget kalnten. ");
INSERT INTO urim_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Atom Pailat melnum a Rom a itna tukgunakg ikgalen anong kanokg Sutia pa la atom tu melnum a almpwrong pa aye Sisas pa kai eng tu ak wanteng pa ak akewel. ");
INSERT INTO urim_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tu melnum a almpwrong pa ayengkalel Sisas pa anel awi ampei iket pa wale atom elng rpma tukgunakg a Sisas pa, a anel awi apm wail torpinet ur pa angkuten ak ningkangen maleng a kil pa la kil kol melnum tukgunakg. ");
INSERT INTO urim_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Atom tu anel itna kuluwel tita kolpa kai wampor wam pa plas atnentel kai tangkwei ti, a tu aknokgelel lala, “Men alkeitn wor, kitn melnum tukgunakg a kipm Suta!” ");
INSERT INTO urim_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Atom Pailat pa wa yaper or lanaki tu wrong kin a kipman wailet a rka or en ti la, “Kupm mpa la tu uwintepm melnum pa iye or atom mpa plantepm eng kipm riwe la, kupm ake ansil paipm ur a kil pa antokg pa.” ");
INSERT INTO urim_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tu aye Sisas ngkaten ampei iket a rpma tukgunakg pa a apm torpinet a tu angkuten ak ningkangen pa angkawor wan pa or, atom Pailat pa lanaken la, “Kipm ri, kil ti melnum kolti!” ");
INSERT INTO urim_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tu melnum tukgunakgen a tu ipma krakgen a ak ak kwap eng al wor uk Maur Wailen pa nampokgen tu nepimpalo alntuwen pa ari Sisas pa atom tu la yikakatnen la, “Kurkurngkel rki yo okgmangki pawo! Kurkurngkel o!” Ari Pailat pa akalmpenten la, “Kipm pa uwiyel iye kai kurkurngkel o! Kupm ti pa kupm ari la kil ake antokg paipm ur.” ");
INSERT INTO urim_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tu wailen wailen a men Suta pa akalmpe la, “Men ti yangkipm titnongket pa itna, ti yangkipm titnongket a pikekg men yapon ti la la mpa ik wesel imo pake, eng ntei, kil ngkat kil alkil ti la kil ti Warim Kipman a Maur Wailen.” ");
INSERT INTO urim_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailat pa atning a tu la kolpa atom kil wa ngkark paipm wrisen. ");
INSERT INTO urim_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Atom kil wa awi Sisas pa aye yaper kawor wan wail alkilen pa, wa kil asentel la, “Kitn ti kai a i?” Ari Sisas pa ake akalmpe. ");
INSERT INTO urim_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Atom Pailat pa lanakel la, “Kitn karken a akalmpe ok akupmen ti? Ake kitn ariwe la kupm ti antiwe titnongket a angketenteitn eng kitn kai aki, a la eng tu kurkurngkeitn?” ");
INSERT INTO urim_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Sisas akalmpe la, “Kol Maur Wailen a rpma kaino kitnong pa ake lkeitn titnongket pa, pa kitn ake antiwe titnongket na ur mpa ntokg kuina ur kul kupm ti. Ti melnum a kil awi kupm ti kul uk kai wam a kitn ti pa, paipmpaipm akilen pa wail manten paipm ai.” ");
INSERT INTO urim_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailat atning a Sisas la kolpa atom kil akor ya lala ngketen Sisas pa kai, ari tu melnum wailen wailen a men Suta pa tu itna pa itna pa la yikakatnen la, “Kol kitn ngketen melnum pa eng kil kai pa, kitn ake mpa melnum wor a Kaisarus pa. Kol melnum ur ngkit kil alkil ti la kil melnum tukgunakg a anong kanokg a Kaisarus itna ep ikgalen ti pa, kil mpa tulpulng yangkipm a Kaisarus pa.” ");
INSERT INTO urim_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailat pa atning kolpa, kil la atom tu awi Sisas pa aye or en ti kai akapm ur a tu ak ok Ipru la Kapata. Atom Pailat pa rpma wrik a melnum a rpma eng atning atning yangkipm pa. Yiprokgen a nang pa la akapm a tu ak wes ante eng arke arke. ");
INSERT INTO urim_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ti wang ti pa wang a men Suta numprampen kweikwei eng ikgkil rpmi ikwonilmpen wang wail a pikekg Maur Wailen awi tu amenen angkai Isip pa aye kul wor. Wreren eng a takgni no pirng ti pa, Pailat pa lanaki tu melnum wailen wailen a ikgalen men Suta pa la, “Ti kipm ri melnum tukgunakg a ikgalen kipm Suta ti itna ti!” ");
INSERT INTO urim_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ari wa tu pa la yikakatnen la, “Uwiyel iye kai o! Uwiyel iye kai o! Uwiyel iye kai kurkurngkel rki yo okgmangki pawo!” Ari wa Pailat asenten la, “Kipm wasrongen la kupm kurkurng melnum tukgunakg akipmen ti?” Ari tu melnum ipma krakgen tukgunakgen pa akalmpe la, “Pa ake melnum tukgunakg amenen pa. Men pa melnum tukgunakg amenen pa Kaisarus wris ata kolti.” ");
INSERT INTO urim_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pailat kil atning kolpa atom kil anti ok atuwen pa elng Sisas kai wam a tu melnum almpwrong pa la tu kurkurngkel. ");
INSERT INTO urim_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tu melnum a almpwrong pa awi Sisas pa aye kai la kurkurngkel rki yo okgmangki. Sisas kil alkil ngkat yo okgmangki alkil pa arki aye kai atnuurng anong pa aye kai wrik ur a tu namput la, “Wrik a Tukgunakg Timpal”, wa ak ok Ipru pa tu namput la Kolkota. ");
INSERT INTO urim_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Am tu karkurngkel rka yo okgmangki itna wrik pake. Wa tu karkurng melnum wekg ur pa yat. Ur rka yamping wom a ur rka yamping wom, a Sisas pa rka kuin. ");
INSERT INTO urim_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Tu karkurngken plalng pa tu awi tangkwrong wompel ur a wet Pailat nira ak krakg wail oklala ur elawe, atom tu karkurng itna kaino yo okgmangki tukgunakgen a Sisas pa. Oklala pa la kolkil la, “Sisas a Nasaret, melnum tukgunakg a tu Suta.” ");
INSERT INTO urim_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Wrik a tu karkurng Sisas rka yo okgmangki pa itna wreren anong wail pa, a wa oklala a wuten Pailat nira pa kil nira ak ok wraur, kil nira ak ok Ipru, wa ak ok Latin, a wa ak ok Krik. Kolpa atom tu Suta watipmen a wli wli takwem rka anong wail pa tu angkom kaingkul pa tu angkleikg oklala a kil nira pa. ");
INSERT INTO urim_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ari wa tu tukgunakgen a tu ipma krakgen a Maur Wailen pa tu yaper kai naki Pailat pa lala, “Kitn ungkwan a wet kitn nira la, kil melnum tukgunakg a men Suta pa, kolpa ake wor. Kol a kitn nira kitila ok a melnum kil alkil pa pikekg la kolkil la, 'Kupm ti Melnum Tukgunakg a kipm Suta.'” ");
INSERT INTO urim_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ari wa Pailat akalmpe la, “Kuina ur a wet kupm nira pa, mpam eli kiti kiti kol a nira ela pake.” ");
INSERT INTO urim_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tunteng melnum a almpwrong pa tunteng karkurng Sisas pa plalng pipa, tunteng awi apm akilen a wet anerel pa ampreing aknirake tunteng melnum wikgwikg pa elngkirmpa. Wa tunteng awi apm wail ur a kil nowe pa, ari apm pa ake angkut wompel wompel angkine tita pa, kalpis. Pa apm a tu an misen kolti. ");
INSERT INTO urim_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kolpa atom tunteng lanaki tita la, “Ake mpa minto ungkwrer apm ti, itni pa. Mpa minto ilm pimpos nep mring pa eng ri la mla a i klangkil pipa, kil iye apm ti.” Kweikwei a palng kil pati, palng eng mpa ok rke iklale kutnun yangkipm a la ela wrkapm a Maur Wailen a la kolkil la, “Tunteng ampreing apm kweikwei akupmen pa aknirake tunteng melnum wikgwikg pa, a tunteng alm pimpos nepmring pa eng la uwi apm misen wail akupmen pa.” Am wet tunteng ak katnun kol a wrkapm pa la pake. ");
INSERT INTO urim_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Man a Sisas pa, wa man wusok alkil pa, wa Maria kin a Klopas pa, wa Maria a anong Maktala pa, tunteng itna wreren yo okgmangki a tu karkurng Sisas arke pa. ");
INSERT INTO urim_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Sisas kil ari man alkil pa a watnom alkil a kil plan ipma wor wasrongentel pa itna wreren, atom kil lanaki man alkil pa la, “Mamam, kitn pa, kitn ri, melnum itna ti pa, pa warim kipman akitnen pake.” ");
INSERT INTO urim_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Wa Sisas wa lanaki watnom alkil pa la, “Kitn ri, kin itna ti pa, pa man akitnen pake.” Kil la kolpa plalng pa, watnom alkil pa awi man a Sisas pa aye kai rpma wan anong alkilen ai ikgalen om. ");
INSERT INTO urim_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Sisas ariwe kwap pikekg Yan alkilen alkel pa am kil ak kul plalng aro yiprokg kolpake, kolpa atom Sisas la, “Uwaketopm”, eng mpa kweikwei wrongkwail a la ela wrkapm a Maur Wailen pa mpa palng ok rke iklale. ");
INSERT INTO urim_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","U wain kinipis kuntuken pa rpma atom tu angkle nep ikli pa kinar u wain pa atom angkuten elng itna wark isop pa aye kaino itna ok a Sisas pa. ");
INSERT INTO urim_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kil arkolng u pa al plalng pa, kil angklo ok pa lala, “Kwap wrongkwail am kupm ak kul plalng aro yiprokg kolpake.” Plalng pa, kil amo ak wang alkil pa nol angkon atom tukgunakg pa elng nar mlak rka. ");
INSERT INTO urim_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Wang ti pa wang a men Suta numprampen kweikwei eng ikgkil pa wang a men a rpma eng yapm. Wa wang ikgkil pa wang wail a men akwonalmpen wang a pikekg Maur Wailen awi tu amenen angkai Isip pa aye kul wor. Kolpa atom tu melnum wailen wailen a men Suta pa karken paipm la palk a tu melnum a tu karkurng rka yo okgmangki pa ake mpa rki kaino pa ik wang wail pa. Kolpa atom tu kai lanaki melnum tukgunakg Pailat pa la eng kil laniki tu melnum almpwrong pa kipor nepm a tunteng melnum wraur a wet tu karkurngken rka yo okgmangki pa, eng mpa tu imo itatu, atom tu nulu palk a tunteng pa iye nar kai lil kawor kirk a u mlamin pa. ");
INSERT INTO urim_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Atom tu melnum a almpwrong pa anel kaino la kipor nepm a tunteng pa, atom tu kapor nepm a melnum ur a rka wompel pa ep plalng pa, a wa kai kapor nepm a melnum ur a rka wompel ai. ");
INSERT INTO urim_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Wa tu la kipor nepm a Sisas pa ari tu ari kil am amo ise, atom ake tu kapor nepm akilen pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pake melnum ur a almpwrong pa alm Sisas ti ak wri pa kai yampingkik wompel ti kolti, atom walmpopm nampokgen u pa elng kul or ungkwan. ");
INSERT INTO urim_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Melnum a kil itna ari pa kil laron kweikwei a palng kolpa la pa aklale wrisen. Kil ariwe la kil la yangkipm aklale, a kil laron pa eng mpa kipm a angkleikg yangkipm kil yat pa, kipm mpa wa ukipma. ");
INSERT INTO urim_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kweikwei a tu ak kolpa pa tu ak katila yangkipm a la ela wrkapm ti a la kolkil lala, “Tupmungkul ur akilen pa ikgake tu kipor.” Atom tu akwap kolpa eng mpa yangkipm a la ti palng ok rke. ");
INSERT INTO urim_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Wa yangkipm ur a wa la ela wrkapm a Maur Wailen pa wa lala, “Tu ikga ikitnen melnum a tu alm pa.” ");
INSERT INTO urim_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tu melnum a almpwrong pa tu ak kolpa plalng pipa, Sosep melnum ur a anong Arimatea pa kai asen Pailat pa la, kil a uwi palk a Sisas pa iye kai lil kawor kirk ur a tu u mlaminel pa. Kil pa melnum ur a katnun Sisas. Pake kil ake aye kil alkil ti angko wunong, eng kil ngkark eng tu alntu melnum wailen wailen a Suta pa. Kil asen Pailat pa ari, Pailat pa awi wor alkel, atom kil kai nalu Sisas pa aye nar. ");
INSERT INTO urim_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Itna waiketnketn pipa, Nikotimus, melnum a pikekg kai ari Sisas ak mining pa wa kai palng. Kil aye kweikwei yaprekget aris wor ur a tu alm yo wakum wekg ak arongke tita pa. Kalkut a kweikwei yaprekget pa kolen nok wail ur a yapo pa (33 kg). ");
INSERT INTO urim_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tuwekg ngkat palk a Sisas pa ak kweikwei yaprekget aris wor pa ak antokg apm pa, atom ak apm pa akalmpalm num akilen pa ariworwor, katila ya a men Suta ak ak tu melnum a amo amo pa. ");
INSERT INTO urim_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Wring ur itna wreren wrik a wet tu karkurng Sisas arke pa, atom kirk ur a tu u mlaminel itna wring pa, pa itna kalpmilel, a ake pikekg tu alil melnum yipmiri ur armpe. ");
INSERT INTO urim_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pa wang a men Suta numprampen eng wang wail a rpma eng yapm ti pa takgni eng a kinar ngkon tike, a kirk a tu u mlamin pa itna wreren. Atom tuwekg alil palk a Sisas pa rmpa pake. ");
INSERT INTO urim_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wang wail a men Suta rpma eng yapm pa kai plalng pa, tu okg, or kong miningket paipm ai pa, Maria a anong Maktala wrekg kai kirk a u mlaminel pa. Kil kai palng kai kirk ai, ari wes pilmpalen wail a pikekg tu ak ipaarng kirk pa am arukge kai takwulelkgen ise. ");
INSERT INTO urim_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kil ari kolpa, kil wa pirng wa yaper kul ari Saimon Pita nampokgen watnom a pikekg Sisas wasrongen paipm pa atom Maria kil lanaken la, “Tu ngkat palk a Wailen kai kirk pa aye kai ermpa kol ur pa, men akwekgel la tu awi aye kai ermpa kai wrik a i!” ");
INSERT INTO urim_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Atom Pita nampokgen watnom wris pa tuwekg atning a Maria Maktala kil la kolpa atom tuwekg wrekg la kai kirk ai. ");
INSERT INTO urim_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tuwekg pirng kolpa kai pa, watnom wris pa pirng akopor Pita pa ep kai palng kai kirk ai. ");
INSERT INTO urim_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kil ikgarmpen ari kawor kirk wunen pa, ari kil ari apm a pikekg tu ak almpalm palk a kil ti kolti pa rmpa, pake ake kil kawor wunen ai. ");
INSERT INTO urim_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ari Saimon Pita pirng katnuntel kai aren kawor kirk wunen ai, atom kil ari akwonalmpen, ari apm alkil a pikekg tu ak almpalm palk a kil pa rmpa kati kati rmpa wrik alkil pa rmpa. ");
INSERT INTO urim_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","A apm alkil a pikekg tu ak almpalm yapo tukgunakg akilen pa ake rmpa nampokgen apm alkil a ak almpalm num pa, pa rmpa man kati kati rmpa wrik alkil pa rmpa. ");
INSERT INTO urim_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","A wa watnom a wuten pirng ep kai pa wa kawor. Kil kawor ari kolpa a kil ukipma la pa aklale, Sisas am wrekg ise. ");
INSERT INTO urim_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Wrkapm a Maur Wailen pa la kolpa la, Sisas ikga imo atom wa wrekg pa, ikgake kalpis pa. Pake ak wang pa tuwekg ake ariwe yiprokgen a yangkipm pa, a pa. ");
INSERT INTO urim_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Atom tuwekg watnom a pikekg Sisas aroaro wonel pa tuwekg ari kolpa plalng pa, tuwekg yaper kul wan anong a tu arke pa. ");
INSERT INTO urim_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria pa yaper kai akg itna mlamin en ti. Kil akg kolpa itna pa, wa kil ikgarmpen ari kawor wunen ai. ");
INSERT INTO urim_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ari kil ari maur akwapel wekg a Maur Wailen pa ekg nowe apm tangkoren pa ekg rpma wrik a pikekg palk a Sisas armpewe pa. Ur rpma kaino tukgunakgen a wa ur rpma kinar nepmen pa. ");
INSERT INTO urim_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Atom maur akwapel wekg pa asen Maria pa la, “Kin, kitn yek akg eng na?” Ari wa kil pa akalmpe la, “Tu awi palk a Wailen akupmen ti aye kai atn kol ur pa. Ti ake kupm ariwe la tu aye kai elng rmpa kai a i!” ");
INSERT INTO urim_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Atom kil wa plelng ikg kinar yirokg alkil pa, ari, kil ari Sisas pa itna, pake kil ake wa ariwe la pa Sisas pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ari wa Sisas asen Maria pa la, “Kin, kitn akg eng kuina wai? A wa kitn akor mla wai?” Atom kin pa kil atning kolpa, kil wa akwonalmpen la pa kil melnum a ikgalen wring pa. Kolpa atom kil lanaki melnum pa lala, “Melnum wailen, kol kitn awi palk a Sisas pa aye kai elng rmpa kai a i pa, kitn lanikopm wrik a kitn elng rmpa pa eng kupm a kai eng uwi.” ");
INSERT INTO urim_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ari wa Sisas lanakel la, “Maria!” Atom kil plelng ariwel kolti, kil ak ok Ipru pa la, “Raponai!” Yiprokgen a ok Raponai pa lala, Melnum a Aroaro Wonel Men. ");
INSERT INTO urim_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Atom kil kai arkulel, ari Sisas pa lanakel la, “Wampelngentopm, kupm ake mpa kaino eng Yan akupmen ai itatu, kupm mpa ntiwepm rpmi pa pen. Ti kitn wa kai laniki tu melnum wor alkupmen a kipm ukipma kupm ti la, kupm am wrekg ise, ti kupm eng a wa yaper kaino eng Yan akupmen tike. Kil Yan akupmen, a wa kil Yan akipmen, wa kil Maur Wailen akupmen, a wa kil Maur Wailen akipmen.” ");
INSERT INTO urim_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria a anong Maktala pa atning kolpa plalng pa kil wa yaper kul lakati naki tu watnom a pikekg Sisas kil aroaro wonel pa la, kil wet ari Wailen Sisas ise. A wa kil lanaken kuina ur wuten Wailen lanakel pa. ");
INSERT INTO urim_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Wang wail a men rpma eng yapm pa kai plalng pa, tu okg or kong ti pa, Maria ari Sisas kai kirkap ai. Atom ak mining kwawen ti pa tu watnom a pikekg Sisas aroaro wonel pa tu takwem rka wan pa rka. Tu ngkark paipm eng tu melnum wailen wailen almenen Suta pa atom tu ar wanyun pa ak tilel tongtong atom tu rka. Ari Sisas ake or kolai kawornten pa, kil palngten kolti itna kuin a tu pa a kil lanaken la, “Ipma akipmen pa mpa rki meen wor!” ");
INSERT INTO urim_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kil la kolpa a kil plan wam kimpang a yampingkik wompel alkil pa eng tu watnom a pikekg kil aroaro wonel pa ari. Tu ari la pa am Wailen alntuwen pa aklale pake, kolpa atom nikgwalpm atuwen pa atopen wail manten paipm wrisen. ");
INSERT INTO urim_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kolpa a Sisas wa lanaken anti ur la, “Ipma akipmen pa mpa rki meen wor. Yan kil pikekg ukwawopm nar kanokg ti atom kupm am wa la ukwa kipm ti kai kolpa yat pake.” ");
INSERT INTO urim_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kil la kolpa plalng pipa, wa kil kaplim okyaprekg a kil ti kainten a kil lanaken la, “Kipm uwi Maur Wor pawo! ");
INSERT INTO urim_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kol kipm ngketen paipmpaipm a yapo melnum ur pa, paipmpaipm akilen pa ake yapowel itna om, kil am wirng no itna kukula wor ise. Pake kol kipm ake angketen paipmpaipm a yapo melnum ur pa kolpa itni pa, paipmpaipm akilen pa yapowel kolpa itna pa.” ");
INSERT INTO urim_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas nang wompel alkil pa namput la Titimus, watnom wris ur a tu wampwam yikakwekg a pikekg Sisas aroaro wonel pa, kil ake pikekg anti tu watnom tiur pa rpma ak wang a Sisas wli palng atom tu ariwel pa. ");
INSERT INTO urim_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Atom tu lanakel la, “Wailen pikekg wli palngto atom men ariwel ise!” Ari Tomas pa wa lala, “Kipm kansil! Kupm ake ukipma oklala a kipm la ti la pa aklale pa! Kupm mpa ri kai wam a tu pikekg ak ikyom karkurngkel pa, a lang wam ipis kawor tawong pa, wa elng wam pa kai wampirpme yampingkik a pikekg tu almpel pa pipa, pa mpa kupm ukipma pake.” ");
INSERT INTO urim_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wang wampwomis wampwompwekg pa kai plalng pa, okg or kong ti pa, tu watnom a pikekg Sisas aroaro wonel pa wa tu takwem rka wris rka wan pa. Wa Tomas pa wa antiwen rpma yat. Wanyun pa tu ar ak tilel. Tu rka ari kalpis, Sisas pa wa wli palng itna kuin atuwen pa anti ur a kil lala, “Ipma akipmen pa mpa rki meen wor!” ");
INSERT INTO urim_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sisas lanaki tu pa kolpa plalng pa, wa kil wa lanaki Tomas pa kolpa la, “Kitn ri wam akupmen kil, ti kitn iye wam ipis pa kul ik inte o! A kitn ntran wam akitnen ti kul waminti yampingkik akupmen kil! Kitn elngen a kitn akwonalmpen watipmen kolpa, kitn ukipma kolti.” ");
INSERT INTO urim_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas akalmpe la, “Am aklale pake! Kitn Wailen a kitn Maur Wailen akupmen am tike!” ");
INSERT INTO urim_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Wa Sisas lanaki Tomas pa lala, “Kitn ariwopm atom kitn ukipma. Pake tu melnum a ake tu ariwopm atom tu ukipma pa, tu pa itopen o! Maur Wailen mpa uk wor tu pa.” ");
INSERT INTO urim_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ak wang a pikekg Sisas kil anti tu watnom a kil aroaro wonel pa atn a rpma kanokg ti pa tu ari kla titnongket titnongket wailet a kil elngitna elngitna pa. Pake kla wailet tiur a kil elngitna pa, pa ake wa nira kimeket ela wrkapm ti. ");
INSERT INTO urim_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","A kla a nira ela wrkapm ti pati, pa nira la mpa kipm ngkleikg ukipma la Sisas pa kil Krais, melnum a pikekg Maur Wailen ukwa nar la ik rmpento, wa ukipma la kil pa Warim Kipman a Maur Wailen. Wa nira lala mpa or ya a kipm ukipma Sisas pa mpa Maur Wailen kil kiplim yaprekg watin akilen pa kaintepm eng mpa kipm rpmi wor yongkyong. ");
INSERT INTO urim_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Wang aripm ur pa kai plalng pipa, Sisas wa palng angko wunong plan kil alkil ti tu watnom a pikekg kil aroaro wonel pa ariwel anti ur itna kai ukupuk Taiperias yamping ai. Kil palngten kolkil: ");
INSERT INTO urim_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tu watnom a pikekg kil aroaro wonel pa rka wris rka: Saimon Pita, Tomas, nang wompel ur akilen pa Titimus, a Nataniel melnum a anong Kana a anong kanokg Kalili, a warim kipman wekg a Sepeti nampokgen watnom wekg ur a tu alntu pa. ");
INSERT INTO urim_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Atom Saimon Pita pa lanaken la, “Kupm a kai ikor yul.” Ari wa tu lanakel la, “Men la ntiweitn kai pake.” Kolpa atom tu kimeket elng kaino nim ukupuken pa kolti a tu kimeket kai akor yul ise. Tu akor yul ak mining pa kaingkai kai akwe kitnangku, ari ake tu awi yul ur, kalpis. ");
INSERT INTO urim_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ak kong miningket ti pa Sisas palng itna ukupuk yamping pa. Atom tu watnom alkilen pa tu ariwel, ari tu ake ariwe la pa Sisas pa. ");
INSERT INTO urim_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Atom kil akwewen asenten la, “Oi, kipm warimpen pa, kipm awi yul tiur aki kalpis?” Ari wa tu akalmpe la, “Kalpis, ake men awi yul ur.” ");
INSERT INTO urim_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Atom kil lanaken la, “Kipm ngkli apm mumu pa elng kinar ukupuk wam wi a nim ukupuken pa, eng mpa kipm uwi yul pa.” Tu atning kolpa, tu angkli apm mumu pa elng kinar ukupuk pa atom anel arkolng, ari akentiwe mpa tu rkolng apm mumu pa ngkiten yul pa elng kul no pa, eng ntei, yul pa watipmen paipm ai. ");
INSERT INTO urim_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Atom watnom a Sisas plan ipma wor wasrongentel pa lanaki Pita pa la, “Pa am Wailen pake.” Saimon Pita atning a kil la kolpa, kil awi apm a nowe eng wropuk a wet kil aner ermpa pa nowe kolti a kil tipra elng kinar ukupuk ai. ");
INSERT INTO urim_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tu watnom a rka nim ukupuken pa tu awi yo timpam pa ak angket u pa ak arkolng apm mumu pa ngkaten yul pa kolpa la iye kai werpm ai. Ake tu rka watinet takwleikgen werpm pa, tu rka wreren. Kol ngkleikg ik wampeng pa, wampeng watin wampwam (100 m). ");
INSERT INTO urim_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tu kul palng kul werpm ti, a tu tipra a nim ukupuken pa elng nar kanokg ti pipa, tu ari wakg a alile itna pa yelket itna, wa yul pa alilng ela wakg pa ela a nok tingklak pa rmpa. ");
INSERT INTO urim_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Atom wa Sisas lanaken la, “Kipm iye yul tiur a wuten kipm awi ak apm mumu pa iye kul o!” ");
INSERT INTO urim_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tu atning kolpa, atom Saimon Pita pa kai tipra elng kaino nim ukupuken pa ampen arkolng apm mumu pa ngkaten yul pa ampen aye meen meen no werpm ti. Yul wail wail aklawe kolti, tu angkleikg ari kamel wampwomis wampwompwekg tuwek wampwam yikakwraur (153). Yul pa wailet paipm ai, pake apm mumu pa ake wa kitnangku. ");
INSERT INTO urim_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Atom Sisas lanaken la, “Kipm kul il okipma waiketn ti!” Ari tu watnom a pikekg kil aroaro wonel pa akwonayewel atom ake ur asentel la, “Kitn mla pa?” Tu ariwe la pa am Wailen pake. ");
INSERT INTO urim_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Sisas kai awi nok tingklak pa alken plalng pa wa kil awi yul pa wa alken atom tu al. ");
INSERT INTO urim_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Sisas pikekg amo atom wa wrekg, atom kil pikekg palng tu watnom a pikekg kil aroaro wonel pa ariwel anti wekg ise. Wa kil wa palngten anti ur ti itna ukupuk yamping ti, atom tu ariwel anti wraur ise. ");
INSERT INTO urim_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tu anti Sisas al okipma pa plalng pa, Sisas asen Saimon Pita pa la, “Saimon, warim kipman a Son, kitn plan ipma wor wasrongen kupm ti angen a tu ti aki kalpis?” Ari kil ntran ikg la, “Ei, Wailen. Kitn ariwe ipma akupmen pa, kupm wasrongenteitn pa.” Atom Sisas lanakel la, “Ti kitn uk u a okipma manto walkg malkgu war akupmen pawo!” ");
INSERT INTO urim_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Wa Sisas asentel anti ur la, “Saimon, warim kipman a Son, kitn plan ipma wor wasrongen kupm ti aki kalpis?” Ari kil akalmpe la, “Ei Wailen, kitn ariwe la kupm wasrongenteitn pa.” Atom wa Sisas lanakel la, “Ti kitn ikglen manto walkg malkgu akupmen pawo!” ");
INSERT INTO urim_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Sisas asentel anti wekg ise, ti wa kil wa asentel ti eng anti wraur tike, “Saimon, warim kipman a Son, kitn wasrongentopm aki kalpis?” Ari Pita pa kil ipma kalkut atnen a kil asentel kolpa anti wraur la, “Kitn wasrongentopm aki kalpis?” Atom kil akalmpentel la, “Wailen, kitn melnum a ariwe kweikwei wrongkwail, kitn ariwe la kupm wasrongenteitn pa.” Atom Sisas lanakel la, “Kitn uk u a okipma manto walkg malkgu akupmen pawo! ");
INSERT INTO urim_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kupm lanakeitn aklale wrisen la, ak wang a kitn itna warimpen ti kitn wrekg atatu kolti awi ampei pa ak angket apm ti a kitn kai wrik a i a kitn la kaiye pa. Pake ik wang a ikga kitn kai wror pa, kitn ikga ngkit wam akitnen pa tukuleikg, atom ikga melnum manet ur ai uwi ampei pa atom ik ngket apm akitnen pa plalng, wampirpmeweitn iyeweitn kai wrik ur a kitn ake wasrongen la kaiye pa.” ");
INSERT INTO urim_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yangkipm kla a Sisas la kolpa pati, pa ak laron ya a Pita ikga imo eng ik ngkit nang a Maur Wailen pa. Sisas la kolpa plalng atom kil lanakel la, “Kitn kutnuntopm o!” ");
INSERT INTO urim_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita plelng ari kil ari watnom a Sisas plan ipma wor wasrongen pa katnunten kul. Melnum a pikekg arm yamping rmpa wreren won a Sisas ak wang a pikekg tu arm yamping al okipma pa, atom ak wang pa kil pikekg asen Sisas pa lala, “Wailen, kitn la mla ikga uk kitn ti kai wam a tu wrongmanto pa?” ");
INSERT INTO urim_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita ariwel kolpa, a kil asen Sisas pa la, “Wailen, ti melnum pa tu ikga ntokgtel kolai?” ");
INSERT INTO urim_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Sisas akalmpe la, “Kol kupm ti lala kil rpmi kanokg ti i i, kai ngko wang a kupm yaper nar pa, ti ake kwei ur akitnen ti eng mpa kitn ti la. Kitn ti pa mpa kutnuntopm kolti!” ");
INSERT INTO urim_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tu atning yangkipm a Sisas la watnom a kil plan ipma wor wasrongen pa kolpa, atom tu naki tita kolpa kai, atom tu melnum a ukipma Sisas yela pa tu atning pa atom tu la watnom a Sisas plan ipma wor wasrongen pa, kil ikgake imo. Pake Sisas pa ake la kolpa. Kil la kolti la, “Kol kupm lala kil rpmi kanokg ti i i, kai ngko wang a kupm yaper nar pa, pa ake wa kwei ur akitnen ti eng mpa kitn ti la pa.” ");
INSERT INTO urim_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Watnom a Sisas plan ipma wor wasrongen ti pa am kil ti melnum pikekg nungkulkg a wulmpa atom kil laron yangkipm ok kweikwei ti la pa aklale wrisen atom nira katila pa ela wrkapm ti, atom men ariwe kuina ur a kil la ti pa aklale. ");
INSERT INTO urim_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Pake kweikwei watipmen paipm tiur ai a Sisas pikekg antokg pa, ake wa nira kimeket ela wrkapm ti pa. Ti kol nira kweikwei pa kimeket eli wrkapm pa ikga wrkapm wailet paipm ai. Kupm akwonalmpen la kol nira kimeket pa, kanokg ti kol a lawe eng elng wrkapm pa ermpi pa. ");
INSERT INTO urim_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Melnum wor akupmen Tiopilus, alkeitn wor. Kupm pikekg nira wrkapm pa ak lanakeitn kweikwei kwap wrongkwail a pikekg Sisas kil ak a kaling plan arowonel tu wrong kin kipman ak ep ilmpiwen ai, ");
INSERT INTO urim_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kulngkul kul angko wang a kil amo wa wrekg rpma, atom kil palng kai tu melnum wokgen akwapel alkilen a kil takweiyen pa tu ariwel. Atom Maur Wor angklinsel atom kil alken kwap, a alken yangkipm ok wrongkwail pa plalng pipa, Maur Wailen awiyel aye kaino kwa ise. ");
INSERT INTO urim_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pikekg ak wang a kil pikekg rpma kanokg ti pa, kil arki kalkuten kolpa kai amo. Atom kil wrekg plan kil alkil ti angko wunong, atom tu ariwel la kil am wrekg ise. Ake antiwe mpa melnum ur ikwonilmpen watipmen la kil ake wa wrekg pa. Kil palng wli pa wli pa anti watipmen tu ariwel, kolpa kai wang kamel wekg. A kil laron yangkipm wor pa naken la, Maur Wailen itna wailen ikgalen nol nikgwalpm a tu wrong kin kipman. ");
INSERT INTO urim_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Wang ur pa kil palng anti tu melnum wokgen akwapel alkil pa rka wris, atom kil la karkurngken lanaken la, “Kipm rpmi Serusalem ti rpmi pen, ampur kipm atnuurng Serusalem ti kai pa. Kipm rki nungkwangen kwei ur a Yan akupmen yapon la lkepm, kol pikekg kupm lanakepm pa. ");
INSERT INTO urim_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Son kil pikekg kalukepm ak u kolti, pake wang wreren eng Yan akupmen ikga kulukepm ik Maur Wor akilen.” ");
INSERT INTO urim_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Wa ak wang ur pa kil wa palng kai tu melnum wokgen akwapel akilen a tu wli rka wris pa, atom tu asentel la, “Wailen, wang a kitn la la wrekg itni tukgunakg ikglen mentepm Isrel ti am tike, kol a pikekg tu melnum tukgunakg amentepmen ikgalento pa?” ");
INSERT INTO urim_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ari Sisas lanaken la, “Pa ake kwei ur a kipm ti la mpa kipm riwe wring a wang pa, kalpis. Pa kweikwei a Yan kil alkil ai alm wang ak ariwe a titnongket a kil alkil ai, a kil lala ikga palng pa. ");
INSERT INTO urim_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pake ikga Maur Wor nar kawor rpmi kipm ti, atom kipm ikga uwi titnongket, atom kipm ikga laron nang akupmen ti itni Serusalem ti, a yela tutu anong kanokg a Sutia ti, wa kai yela tutu anong kanokg a Samaria ai, wa kolpa iye kai yela kanokg ti.” ");
INSERT INTO urim_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Sisas lanaken yangkipm ok pa plalng pipa, Maur Wailen awiyel aye kaino kwa, a tu melnum wokgen akwapel akilen pa itna ikatnentel kolpa itna. A kil kaino kolpa kaino kaino elng kawor am kawor waipmunu wunen ai kolti, a tu ake ariwel om. ");
INSERT INTO urim_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tu itna ikatnentel kaino kitnong kolpa itna a a, tu tutusraing ari melnum wekg ur pa palng kulnar penterngen kolti itna wreren tu ti. Tuwekg pa nowe apm tangkoren muinmainet pa. ");
INSERT INTO urim_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","A tuwekg asenten la, “Kipm melnum a Kalili, wa kipm itna itna ikatnen erkisen kaino kitnong pa kolpa itna eng ntei? Sisas kil a wet Maur Wailen awiyel aye kaino kitnong pa, kil ikgam wa yaper nar kol a kipm ariwel a kil kaino pake.” ");
INSERT INTO urim_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wrik a tu melnum wokgen akwapel a Sisas itna ikatnentel pa pati, pa tu namput la la Wrik Nangen Olip. Tu itna ari Sisas pa kaino kitnong plalng pa, tu a pa yaper nar kul no anong wail Serusalem a ela wreren kolti. Pa wang wail a rpma eng yapm atom ake mpa tu ngkom kai watin pa, mpa tu ngkom kai wreren kolti. ");
INSERT INTO urim_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tu no palng or Serusalem pa, tu kai kaino rka wan walop ur a ela kaino kwa. Tu rka wan a tu wli arke arke pake. Tu melnum a kai rpma wan pa pati nang atuwen pa pati kil: Pita, Son, Semis, Antru, Pilip, Tomas, Partolomyu, Matyu, a Semis, warim kipman a Alpius, a Saimon, melnum ur a tu Selot, a Sutas, warim kipman a Semis. ");
INSERT INTO urim_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tu kulkai takwem rka wris nampokgen tu kin tiur, a wa Maria man a Sisas, a nampokgen tu wusok wusok a Sisas pa. Nikgwalpm a tu pa rka wris oklala naki Maur Wailen akangklei wang kolpa rka pake. ");
INSERT INTO urim_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tu rka kolpa kai, wang ur pa tu alntu melnum wokgen akwapel a Sisas nampokgen tu melnum wrongkwailet paipm a ukipma Sisas tu wli takwem rka wris. Tu wrong pa palng kol kamel wampwomis wampwompwris. Atom Pita kil wrekg itna lanaken la, ");
INSERT INTO urim_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","”Kipm melnum alkupm a mentepm ukipma Sisas, kipm itning! Kuina ur pikekg palng kai Sutas, melnum a pikekg uk ya eng tu arkul or Sisas pa, pa am palng katila kol ok a Maur Wor a Maur Wailen la ep ak ai la wli ok a Tepit, atom kil nira ela wrkapm a Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Sutas pa am pikekg melnum wokgen ur amenen a kil akwap wris kol a men ak ti, laron yangkipm a Maur Wailen eng ak angklin tu wrong kin kipman.” ");
INSERT INTO urim_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Marpm a Sutas akarmpen kanokg pa kil awi or ya paipm, kolpa atom ari kil kai kaino angko aye tukgunakg a kil pa ep kulnar ngkrang rmpa kanokg ti atom nikgnampi pa turus elngkul or en. ");
INSERT INTO urim_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Atom tu wrongkwail a rka Serusalem ti pa tu atning ari pa, atom tu alil nangkel wrik kanokg pa ak ok anongen alntu pa lala Akeltama. Yiprokgen a wrik nang kil pa pati la, “Kanokg a walmpopm ungkwan atne!” ");
INSERT INTO urim_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Wa Pita kil wa la, “Ti yangkipm kil a pikekg Tepit nira ela wrkapm Nangnang pa la kolkil la 'Ti anong a kil pa elng itni kupuk, ake mpa melnum ur rke!', wa nira yat la, 'Tu mpa tukwei melnum ur mpa wa uwi wrik a kil pa ikwap pa.' Ti yangkipm wekg a pikekg lawen ak ai la ikga palng pa, am palng tike. ");
INSERT INTO urim_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Kolpa ti mpa mentepm ngkit melnum ur uwi wrik a Sutas pa. Mpa mentepm ngkit melnum a pikekg antiwo atn akangklei wang ak wang a Sisas kil antiwo atn a rpma pa, ");
INSERT INTO urim_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ak wang ep lmpiwen a Son kil kaluk Sisas, angkai ai kulngkul wli wang a Maur Wailen Yan alkil awiyel aye kaino kitnong. Kolpa ti mpa mentepm ngkit melnum ur pake, kil a pikekg nungkulkg a wulmpa antiwo atn pa kul ntiwo itn, eng mpa men niki tu wrong kin kipman pa la Sisas a pikekg amo pa, aklale, pa am wrekg ise.” ");
INSERT INTO urim_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita la kolpa plalng pa, tu rkan melnum wekg pa elng itna: ur pa Sosep a tu namput la Parsapas, a nang wompel a kil pa Sastus, a ur pa Matias. ");
INSERT INTO urim_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Atom tu asen Wailen pa la, “Wailen, kitn alkitn pa ariwe nol nikgwalpm a men melnum ti. Mpa kitn planto wris ur a tuwekg ti a kitn takwei la, ");
INSERT INTO urim_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","mpa uwi wrik a Sutas pa palng melnum wokgen akwapel akitnen, eng mpa ntiwo ikwap akitnen. Ti kwap pa pikekg Sutas antiwo ak pa atom kil atnuurng itna pa, a kil amo kai wrik ur alkil a tu melnum paipm a kolpa amo kai arke arke pake.” ");
INSERT INTO urim_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Atom tu kapor ker pa ak awiye tita la mla a i klangkil pa, mpa kil pa uwi wrik a Sutas pa, atom am Matias pa klangkil pake. Atom am kil pa awi wrik a Sutas kai aklanti tu melnum wokgen akwapel wampwam yikak wris a Sisas pake. ");
INSERT INTO urim_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ak wang pa tu Suta angket tuwai kweikwei ep kai wring alntuwen. Tu angket tuwai plalng pipa, pa wang wail a tu kai rka wris al wor uk Maur Wailen pa. Atom tu melnum a ukipma Krais pa ak wail kai rka wris kolpa rka. ");
INSERT INTO urim_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tu rka ari kalpis, tu atning milpming wail kolen wripm wail pa el pupu angkaino kitnong pa kul nar or arpme wan a tu arke pa yela. ");
INSERT INTO urim_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tu ari wakg yuk ur pa kul nar ari kolen ok milip pa purngprarng nar itna tukgunakg a tu melnum pa wris wris. ");
INSERT INTO urim_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tu plalngten a rka kawor wan pa Maur Wor pa nar rpma kawor ipma atuwen pa, atom tu ak ok watipmen aur aur. Pa Maur Wor pa la kawor ipma atuwen pa, atom ngkat okel tu pa laron oklala pa kai ok a tu pa. ");
INSERT INTO urim_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ak wang pa tu Suta watipmen a pikekg rka yela anong kanokg ti pa, tu wli rka Serusalem. Tu pa tu melnum a kapor kilko alein Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tu atning milpming wail pa, atom anel ak wail a pa a pa wli atning tu melnum a wuten Maur Wor awiyen pa tu ak ok anongen manet manet aur aur a tu wris wris a wli itna atning ti ak la, kolpa atom tu wrekg paipm eng atning pa. ");
INSERT INTO urim_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tu wrekg paipm kolti akor lanaki tita la, “Tu melnum a oklala kil pa, tu melnum a Kalili! ");
INSERT INTO urim_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ari wa antokg kolai atom wa mentepm atning a tu ak ok anongen manet manet a mentepm wris wris ak ti? ");
INSERT INTO urim_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ti mentepm ti a anong kanokg Partia ai wli, a tiur pa a anong kanokg tiur ai a namput la Mitia, a Elam pa wli. A tiur pa a anong kanokg a Mesopotemia, a Sutia, a Kapatosia, a Pontus, a Esia. ");
INSERT INTO urim_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","A tiur pa a anong kanokg a Prikia, a Pampilia, a Isip. A mentepm tiur pa a anong kanokg Lipia a ela wreren anong Sairini, a mentepm tiur ti a anong wail Rom ai wli. ");
INSERT INTO urim_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ti mentepm kanokg yiprokg a Suta ti, a tu a ake a Suta, pake tu plelngen katnun rpma a mentepm Suta ti, ti mentepm tiur ti pa a anong kanokg Krit, wa mentepm tiur pa a anong kanokg Arepia. Ti wa antokg kolai atom wa mentepm kimeket, mentepm atning a tu laron kwap titnongket a Maur Wailen pa ak ok anongen wris wris almentepmen ti?” ");
INSERT INTO urim_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tu wrekg paipm titnowen akwonalmpen watipmen asen tita la, “Pa tu antokg na kolpa?” ");
INSERT INTO urim_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ari tu tiur pa tu la aknokgel tu pa la kolpa la, “Palpa tu al u wain titno watipmen atom ari tu titno.” ");
INSERT INTO urim_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tu akwonalmpen watipmen a asen tita kolpa itna pa, Pita kil wrekg nampokgen tu melnum wokgen akwapel wampwam yikak wris a Sisas pa, atom kil la yikakatnen naki tu wrong kin kipman wailet a rka pa la, “Kipm melnum a Suta, a kipm mlaur a wli rka Serusalem ti pa, kupm la lanikepm kuina ur a kipm ari ti riworwor, kolpa ti kupm la kipm elng nungkulkg pa itni eng itning kuina ur a kupm la lanikepm ti. ");
INSERT INTO urim_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tu melnum kil pa ake tu al u wain titno pa, atom titno pa, kol a kipm akwonalmpen pa, kil kil takgni no alm num wleket a pa. ");
INSERT INTO urim_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kuina ur a kipm atning ari ti pa pati, pikekg palng kai ok a melnum okwripm Soel la ep ak ai, atom nira ela wrkapm pa la kolkil la, ");
INSERT INTO urim_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","'Maur Wailen la kolpa la, “Ikga ik wang umpuwen pa, ikga kupm ukwa Maur Wor akupmen kil kinar kawor rpmi tu wrongkwail kin a kipman. Ti tu warim kin a warim kipman akipmen pa ikga Maur Wor akupmen ngkiten ok, atom tu laron yangkipm akupmen kol tu melnum okwripm. A tu kipman warimpen akipmen pa ikga kiporng wulmpa pa ri kweikwei kolen a tu okgwangket a ikga Maur Wor akupmen planten pa. A tu mel nangkwor akipmen pa ikga planten kai okgwangket. ");
INSERT INTO urim_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wa tu kin a kipman akwapel akupmen pa ikga kupm ukwa Maur Wor kil kinar kawor rpmi tu ik wang pa, ti tu ikga Maur Wor akupmen ngkiten ok, atom tu laron yangkipm akupmen kol tu melnum okwripm. ");
INSERT INTO urim_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","A ikga kupm plan kweikwei titnongket weten a kipm melnum wrekg paipm eng ari itni no kitnong kil. Wa ikga kupm plan kla ur itni kinar kanokg pa ik plan wang pa, pa ikga tu ri walmpopm, wakg, a wa wakg wuan kitnilokgis wail paipm ikga nukur iye no no. ");
INSERT INTO urim_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A takgni pa ikga iner kulkai mining, a kainil pa ikga palng walmpopm rke rke, pa pati wreren wang a Wailen eng a palng nimpokgen titnongket a klalen wail akilen pake. ");
INSERT INTO urim_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ikga ik wang pa mla ur kil ukwen nang a Wailen pa, ikga kil uwiyel eng alkilen pa.”' Pa ok a Maur Wailen pikekg palng kai ok a melnum okwripm Soel la. ");
INSERT INTO urim_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Oklala a ela wrkapm a Maur Wailen pa am la kolpake, kolpa ti kipm melnum a Isrel, kipm elng nungkulkg pa itning yangkipm kil a kupm la mpa lanikepm pa: Sisas a Nasaret pa melnum a pikekg Maur Wailen takweiyel la nar eng la ngklin kipm pake. Ti kil pikekg antokg kweikwei weten a ake melnum ari ep, kweikwei titnongket wrongkwail, a kil elng kla watipmen pa elng itna, ti kipm ariwe pa. Pa Maur Wailen ak plantepm eng kipm ri la la, am Maur Wailen kil alkil pa ukwa Melnum pa nar pake. ");
INSERT INTO urim_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ari kipm awi melnum pa uk kai wam a tu melnum a ake katnun yangkipm titnongket a mentepm Suta pa, atom tu almpel amo karkurngkel rka yo okgmangki. Pake pikekg ep ak ai, wasrongen a ariwe a Maur Wailen kil alkil ai ak kolpake, atom am kil akwonalmpen pa yat ise, la kil ikga elng Sisas elng kai wam akipmen. Atom am kipm pikekg ak katnun kolpake. ");
INSERT INTO urim_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ari Maur Wailen la kil wrekg, a ungkwan kalkuten a wleket a kil amo pa kai takwlelkg. Eng ntei, Amo ti ake antiwe titnongket mpa rkul kil pa rpmi i wrik om a tu a amo kai arpme pa. ");
INSERT INTO urim_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kol a mentepm angkleikg kai wrkapm Nangnang a Tepit awi ok a Sisas pa nira lala, 'Kupm akangklei ari Wailen kil antiwopm rpma. Kil itna wrerentopm alkopm titnongket, eng ake antiwe mpa kupm nulkwok ngko. ");
INSERT INTO urim_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kolpa atom ipma akupmen pa atopen paipm, a ok akupmen ti ak ak nangnang atopen kolti. Wa numpalk ti a ikga imo atom uwen kawor kirk a tu u mlaminel pa, kupm ariwe la kupm ikga rmpi uwi yapm rmpi waiketn kolti. ");
INSERT INTO urim_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Eng ntei, kupm ariwe la kitn Maur Wailen ikgake elng amen wor akupmen pa rpmi i yongkyong kai wrik om a tu melnum a amo pa kai arke pa. A kitn ikgake elngen numpalk a kupm melnum wriwen wor alkitn kil kai rmpi mampis paipm pa. ");
INSERT INTO urim_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ti kitn pikekg plantopm ya wor a rpma yongkyong, a kitn ikga uwiyopm iye kaino ntiweitn rpmi, a lkopm atopen wail manten.' Yangkipm a pikekg Tepit awi ok a Sisas lanaki Maur Wailen pa, am kupm lakati nakepm kai kolpake. ");
INSERT INTO urim_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ti kipm wusok wusok, wail wail a mansan alkupm a mentepm Suta pa, kupm ake mpa ngkirk, kupm mpa lanikepm ngko wunong la mentepm wrongkwail ariwe mamikgmaminen a mentepmen Tepit pa la, pikekg kil amo, tu alupm kil kawor mlamin pa elngkirmpa, ti mlamin a kil am itna wrerento a tike. Ti ak wang ti pa mentepm ari itna wunong a pa. ");
INSERT INTO urim_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tepit pa kil melnum okwripm a Maur Wailen, atom Maur Wailen kil naren kil alkil, atom wa yapon yangkipm nampokgen Tepit pa la, kil ikga ngkit yoampei ur a Tepit pa ikga palng melnum wailen itni tukgunakg kol Tepit kil alkil pa. ");
INSERT INTO urim_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tepit kil ariwe pa ep ak ai kuina ur a Maur Wailen la ntokg pa, kolpa atom ari kil laron Krais, melnum a Maur Wailen takwei la ukwa nar ikirmpen paipmpaipm amentepmen ti, la kil ikga imo atom wa wrekg. Atom kil la la Maur Wailen ikgake utnuurngkel rpmi wrik om pa rpmi, wa ikgake wa kil elngen numpalk a kil pa rmpi mampis kawor mlamin a uwen melnum ti armpe pa, kalpis. ");
INSERT INTO urim_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Atom am Sisas pake, a pikekg amo atom Maur Wailen la atom kil wrekg. Ti men wrongkwail men pikekg nungkulkg a wulmpa ari pa, atom men laron pa. ");
INSERT INTO urim_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kil am Maur Wailen Yan alkilen pa ngkatel alkel nang wailen kaino rpma nampokgen kil alkil ise. Kil awi Maur Wor a pikekg Yan alkil yapon yangkipm nampokgentel pa, atom kil ukwa Maur Wor pa narnto, ti am kipm atning a ari itna tike. ");
INSERT INTO urim_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tepit kil alkil pa pikekg ake wrekg kaino anong wor a Maur Wailen pa, kalpis. Pikekg kil la ela wrkapm Nangnang akilen pa la Sisas pa kolkil la, 'Maur Wailen pa naki Wailen akupmen pa la, “Kitn kulno ntiwopm rpmi, eng mpa kupm lkeitn titnongket akupmen a lkeitn nang wailen. ");
INSERT INTO urim_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Kitn kul no rpmi i i, ikga kupm la kitn rkganti tu wrongmanto akitnen pa.”' ");
INSERT INTO urim_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kolpa ti kipm wrong kin kipman a Isrel pa, kipm mpa uwi riwe kil: Sisas, melnum a kipm or amo karkurng rka yo okgmangki pa pati, pa pikekg Maur Wailen alkil la kil Wailen, a kil Krais, melnum a pikekg kil takweiyel la ikirmpen mentepm wrong kin kipman ti.” ");
INSERT INTO urim_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tu wrong kin kipman atning yangkipm a Pita la pa, pa almpen ipma pa kolpa atom tu numpaipm. Atom tu asen Pita nampokgen tu melnum wokgen akwapel a Sisas pa la, “Kipm melnum wor amenen, ti mpa men ntokg kolai?” ");
INSERT INTO urim_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ari Pita pa akalmpenten la, “Kipm wris wris ti mpa kipm plelng ipma, atom kipm kul eng mpa men naren nang a Sisas Krais kulukepm, eng mpa Maur Wailen ungkwan paipmpaipm akipmen kai tukulelkg, plalng pipa, kipm uwi Maur Wor a Maur Wailen. ");
INSERT INTO urim_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Maur Wailen am pikekg yapon yangkipm nampokgen kipm pa, a tu watnom walpopm akipmen a aye or pa kai pake, la ikga lkepm Maur Wor alkil pa. Wa nampokgen tu mla ur a rka tatu anong ya watinet ai, am tu a Wailen, Maur Wailen amentepmen akwewen pake, la tu kul eng kil.” ");
INSERT INTO urim_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita kil angkli yangkipm lanaken kolpa kai, atom kil wa la karkurngken aloken la, “Kipm rpmi uk ikg riwe ikglen kipm alkipm, eng ikgake kipm uwi wleket kolen tu melnum a antokg paipmpaipm ti ikga uwi wleket atnen paipm a tu antokg pa.” ");
INSERT INTO urim_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tu wrong watipmen atning yangkipm a Pita laron naken pa, atom tu a ukipma katnun pa, tu kaluken. Ti tu melnum a ukipma Sisas ak wang pa, pa palng wailet paipm, kamel kamel (3,000). ");
INSERT INTO urim_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ti tu a ukipma katnun yangkipm a tu melnum wokgen akwapel a Sisas kaling planten pa, tu uk tu alntu kai eng atning katnun yangkipm pake. Tu akangklei kai rka wris al al okipma wa awi okipma a Sisas a wa oklala naki Maur Wailen kolpake. ");
INSERT INTO urim_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tu melnum wokgen akwapel a Sisas pa, tu antokg kweikwei weten titnongket a ak plan titnongket a Maur Wailen ti tu wrongkwail ari pa, tu ngkark paipm. ");
INSERT INTO urim_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tu kin a kipman a ukipma Sisas pa, tu am kaingkai rka wris kolpa, a tu alupm nikgwalpm kolpa la kweikwei atuwen pa a wrongkwail. Tu ari la mla ur kil tukwok eng kuina a i pa, tu ak angklin kil pa. ");
INSERT INTO urim_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Atom tu uk kanokg a kuina ur atuwen pa kai tu armpenten, atom tu awi marpm pa atom tu ak angklin tu mla ur a rpma tukwok pa. ");
INSERT INTO urim_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Akangklei wang wris wris pa tu am anel kai rka rka wris a yipmingki wunen a yalming a Maur Wailen. Tu anel atopen angklin tita okipma kweikwei ti aye kai takwem al rka wris, wa awi okipma a Sisas al kolpa wan ur wan ur. ");
INSERT INTO urim_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tu ngkat nang a Maur Wailen atopen kolpa rpma. Tu wrongkwail ariwen kolpa, tu atopen kaporng yangkipm. Akangklei wang wris wris pa titnongket a Wailen Sisas akwap kolpa awi tu melnum weten weten tiur aye kai aken tu a Maur Wailen akawiyen aye kai eng alkilen pa, atom tu palng wailet a wailet kolpa aye kai. ");
INSERT INTO urim_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wangkur ak nungkurikg a tukoryauk angkli om eng ukwa takgni kai pa Pita ekg Son la kawor yipmingki wunen a yalming a Maur Wailen pa, pa wang a tu Suta oklala naki naki Maur Wailen am pake. ");
INSERT INTO urim_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tuwekg kai kawor angko yipmingki yun ur a tu namput la Yipmingki Yun Ariwor pa la kai kawor wunen pa, tu ngkat melnum ur a pikekg awi ipma angko nepm plupmen pa aye kai kawor rpma yipmingki yun. Kolpa atom akangklei wang pa tu ngkatel aye kaingkai rpma wanyun pa eng kil rpma rpma akwen marpm kweikwei tu a kai kawor kulor yipmingki wunen a yalming pa. ");
INSERT INTO urim_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Melnum pa ari Pita nampokgen Son a la kai kawor pa, kil akwenten la tuwekg lkel kweikwei ur. ");
INSERT INTO urim_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ari Pita ekg Son pa ikatnentel titnongket, atom Pita pa lanakel la, “Kitn ri mentekg ti ri!” ");
INSERT INTO urim_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Atom melnum pa ikatnenten, a akwonalmpen nungkwangen la, tuwekg pa mpa lkel kweikwei ur pake. ");
INSERT INTO urim_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ari Pita lanakel la, “Kupm marpm kalpis, pake mpa kupm lkeitn kuinaur a kupm antiwe kil pa pati, kupm naren Sisas Krais a Nasaret pa kupm lala kitn wrekg ngkom o!” ");
INSERT INTO urim_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Atom Pita kil wamparpmewel kai wam wi pa eng kil wrekg. Atom pinterngen kolti nepm wasen a nepm ningkli a pikekg plupm pa itna tita titnongket wor om. ");
INSERT INTO urim_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Atom kil wrekg itna akwiyen ari nepm a kil pa am wor ise, atom kil angkom om. Kil angkom anti tuwekg pa kolpa kai kawor yipmingki wunen a yalming pa tipra tipra ngkat nang a Maur Wailen pa. ");
INSERT INTO urim_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tu wrongkwail tu ariwel a kil ngkat nang a Maur Wailen angkom kolpa kai pa, ");
INSERT INTO urim_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","tu ariwe lala, am melnum wris a pikekg rpma yipmingki yun a tu namput la Yipmingki Yun Ariwor pa, eng akwen akwen marpmel tu pa ampake. Tu ari a kil wrekg angkom wor kolpa, tu wrekg paipm titnowen num akwonalmpen watipmen. ");
INSERT INTO urim_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Melnum nepm plupmen a palng wor pa, kil anti Pita ekg Son pa atn kolpa kai itna wan kling wail a Solomon pa itna, ari tu wrong wailet paipm tu wrekg paipm titnowen num eng tu ari kolpa, tu pirng akentatu wli itna aye oningkewen. ");
INSERT INTO urim_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita kil ari tu wrong kin kipman a anel wli ariwen pa, atom kil asenten la, “Kipm melnum a Isrel ti! Ti wa antokg kolai atom kipm wa wrekg paipm eng kipm ari ti? Ti wa kipm ikatnen mentekg ti titnongket eng kuina? Pa kipm akwonalmpen la pa mentekg antokg ak titnongket a mentekg ti, aki a mentekg ti ute wor itna wulmpa a Maur Wailen, atom mentekg antokg melnum pa palng wor, atom kil wrekg itna angkom pake? ");
INSERT INTO urim_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mentekg ti pa kalpis, pa am Sisas pake. Am Maur Wailen pa ngkat Sisas pa la kil melnum akwapel akilen, atom kil alkel nang wailen pake. Am Maur Wailen a Apraam, a Aisak, a Sekop, wa a tu mamikgmamin mansan amentepmen ti pa am kil pa alkel nang wailen pake. Pikekg ak wang a Pailat, mring man wailen a Rom a pikekg ikgalen anong kanokg a Sutia pa kil rpma atning yangkipm a Sisas pa, kil pikekg la kol a elng kil kai, ari wa kipm ti awi paipm uk karkentel la kil melnum paipm, atom kipm la kai tu ilmpel imo o. ");
INSERT INTO urim_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kipm ukyirokg melnum klalen ute wor itna wulmpa a Maur Wailen ti itna, a wa kipm tirpmingen Pailat pa la, kil elngen melnum paipm a alm melnum ti orntepm or en ti. ");
INSERT INTO urim_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","A kipm alm melnum yiprokgen a uk melnum yaprekg watin eng rpma yongkyong pa. Pake Maur Wailen kil la kil wrekg a kirkap pa, ti mentekg ari ak wulmpa almentekgen atom ari, mentekg laron pa. ");
INSERT INTO urim_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kipm wrongkwail ariwe melnum a palng wor itna wulmpa akipmen ti; wet mentekg naren nang a Sisas a antiwe titnongket pa nakel, atom melnum pa kil atning ukipma kolpa atom kil palng titnongket wor ise. Sisas kil ngkatel ipma, atom kil ukipma Sisas pa atom kil palng wor atnen pake. ");
INSERT INTO urim_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Kipm wusok wusok a wail wail, a yantin mantin alkupm a Suta pa, kupm ariwe la kipm ti nampokgen tu melnum wailen wailen akipmen pa, kipm pikekg akwekgel kolpa atom kipm wonmis ak Sisas pa paipm kolpa. ");
INSERT INTO urim_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pake pikekg ep ak ai, ok a Maur Wailen kil palng no la kai ok a tu melnum okwripm wrongkwail, atom tu la kolpa la melnum akilen a kil takwei la ikrmpento pa kil ikga rki kalkuten. Ti wleket a pikekg kipm alkel pa, pa palng katila nol nikgwalpm alkil a pikekg kil lanaki tu melnum okwripm pa. ");
INSERT INTO urim_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kolpa ti kipm laron paipmpaipm akipmen pa a kipm ukipma, eng mpa Maur Wailen ungkwan paipmpaipm akipmen pa plalng. ");
INSERT INTO urim_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Eng mpa Maur Wailen kil lkepm titnongket weten kawor ipma wunen akipmen pa, atom kipm uwi itopen wor a rpma wor eng yapm, a eng mpa Maur Wailen ukwa Sisas pa wa narntepm ntiur. Pa melnum a pikekg Maur Wailen kil alkil takwei la ikrmpento. Melnum pa am Sisas pake. ");
INSERT INTO urim_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ik wang ti pa kil ikga rpmi kaino kitnong pa i pa pen, nungkwangen wang a ikga Maur Wailen ntokg kweikwei wrongkwail pa palng weten wor pen, kol a Maur Wailen pikekg la kai ok a tu melnum okwripm a Maur Wailen amprin eng alkilen la ep ak ai. ");
INSERT INTO urim_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kolen pikekg Moses melnum okwripm la kolpa, 'Wailen, Maur Wailen akipmen kil ikga tukwei melnum okwripm ur, kol a kil takwei kupm ti. Melnum pa ikga melnum ur alkipmen pake. Ti kipm ikga itning kutnun kweikwei wrongkwail a kil ikga lanikepm pa. ");
INSERT INTO urim_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kol melnum ur ake atning katnun kuina ur a melnum okwripm pa la pa, pa ikga Maur Wailen ungkwan tu pa kai itni manet tukwuleikgen mentepm wrong kin kipman a Maur Wailen ti atom ilmpen imo.' ");
INSERT INTO urim_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Oklala a Moses pikekg la pa, kai kolpake. Wa tu melnum ok wripm a pa kulngkul kul angko Samuel ti wa or pa kul pa, am wa la kolpa yat pake, kuina ur kol a palng ok arke ak wang ti. ");
INSERT INTO urim_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","A kipm ti pa kipm walyaru yipetatnong a tu melnum okwripm a angkai ai kulngkul kul ti. Pikekg Maur Wailen lam kla nampokgen Apraam la, 'Ikg a kupm ukwa melnum ur a numwalmpopm wris akipmen ti, atom kai kil pa ikga kupm plan ipma wor ikngklin tu wrong kin kipman wrongkwail a rpma yela kanokg ti.' Kuina ur a pikekg Maur Wailen lam kla nampokgen tu wapyipmiri walyipmiri akipmen ti, a wa kipm a ake Suta ti yat. ");
INSERT INTO urim_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kolpa ti Maur Wailen kil takwei melnum wor akwapel akilen pa ukwa eng kipm mentepm ti ep tike, eng la kil uk ipma wor ikngklin kipm mentepm tike, wa ntokg kipm mentepm wrongkwail plelng ipma ukyirokg paipmpaipm a mentepm antokg pa.” ");
INSERT INTO urim_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita ekg Son tuwekg itna angkli yangkipm naki tu wrong kin kipman pa kolpa itna pa, tu melnum ipma krakgen a ak ak kwap eng al wor uk Maur Wailen, nampokgen melnum tukgunakg a tu wantengkwang a atnen yalming a Maur Wailen nampokgen tu melnum tiur a Satyusi pa wa wli. ");
INSERT INTO urim_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tu ipma wakget eng tuwekg melnum wokgen akwapel a Krais pa, pa pati atnen tuwekg kaling plan tu wrong kin kipman wa laron Sisas a pikekg amo atom wa wrekg pa naken, atom planten angko wunong la tu melnum a pikekg amo amo pa tu ikga wa wrekg wrekg. ");
INSERT INTO urim_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kolpa atom tu arkul tuwekg pa aye kai la kol a ntokg yangkipm, ari mining atom tu ayewen kawor okg rmpa wan tipmining ti pen. Ikgkil kong pa tu ntokg yangkipm. ");
INSERT INTO urim_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ari tu wrong kin kipman watipmen pa tu atning yangkipm a pikekg laron pa, atom tu ukipma. Ti tu a ukipma pa palng wailet paipm, tu angkleikg wrong a tu kipman pa wailet paipm kamel kamel (5,000). ");
INSERT INTO urim_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Okg or kong pa tu mring tukgunakg a ikgalen men Suta, a tu melnum wailen wailen, a tu melnum a aroaro wonel tu yangkipm a Moses pa, tu kai takwem rka wris rka anong Serusalem yapon nikgwalpm la ngketen la ampake Pita ekg Son pa laron Sisas pa. ");
INSERT INTO urim_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas a pikekg itna melnum tukgunakg a itna ep eng tu ipma krakgen a Maur Wailen, wa Kaiapas a itna ep eng tu ipma krakgen kimeket ak wring ti, wa Son, wa Aleksanter wa nampokgen tu tiur ai a om wris alntuwen a tu ngkat ngkat itna melnum tukgunakg a itna ep eng tu ipma krakgen a Maur Wailen pa, tu am rka pake. ");
INSERT INTO urim_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tu rka pa, tu la tu awi tuwekg melnum wokgen akwapel a Sisas pa aye kul or itna wulmpa atuwen ti, atom tu asenten naimpilng akor la, “Kipmekg la yangkipmen mring a i atom titnongket a mring pa antokg melnum nepm plupmen ti wrekg wor angkom pa?” ");
INSERT INTO urim_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Maur Wor a Maur Wailen pa nar rpma wail kawor ipma wunen a Pita ak wang ketn pa, atom kil akalmpe ok a tu pa la, “Kipm mring tukgunakg a ikgalen men wrong kin kipman wa kipm melnum wailen wailen! ");
INSERT INTO urim_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ti am kipm ari a mentekg antokg melnum nepm plupmen ti wor kolpa atom kipm la isen ikor itning pake! Wa kipm la itning la mentekg la yangkipmen mring a i atom kil palng wor pa! ");
INSERT INTO urim_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kipm akasen kolpa ti mpa kipm wrongkwail itning kil atom uwi riwe kil riworwor, atom mpa wa kipm niki tu wrongkwail a Isrel a rka yela pa wa yat eng tu uwi riwe riworwor, la ti mentekg la yangkipmen Sisas Krais a Nasaret pa, atom melnum a pikekg nepm plupmen ti palng wor itna ti, kipm wrongkwail ari ti. Sisas a pikekg kipm la atom tu karkurngkel amo rka yo okgmangki pa, atom wa Maur Wailen la ti kil wrekg rpma pa. Am kil pa antokg melnum ti palng wor itna tike. ");
INSERT INTO urim_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Sisas pa kol ong kimpowen a kipm melnum a ale wanel pa elukgen la palpa ong paipm. Pake pa ake ong paipm, pa ong kimpowen titnongket wor wris anangket a ak ale ale wan ampake. ");
INSERT INTO urim_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ti ake melnum ur manet antiwe akawiyo aye kai eng Maur Wailen pa. Maur Wailen alko Sisas wris ata kolti. Ti ake wa kil namput nang a melnum manet ur a itna kanokg ti a antiwe akawiyo aye kai wor pa, kalpis.” ");
INSERT INTO urim_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tu melnum wailen wailen a rpma atning yangkipm a Pita itna oklala pa, tu wrekg paipm eng ari Pita a Son a ekg itna titnongket wrongen la yangkipm ok kalnten pa, a tu ariwe la, tuwekg pa melnum anongen kolti, ake tuwekg ur pikekg kai awi ariwe wail ur pa. Tu ariwe lala, tuwekg melnum pikekg atn akwap anti Sisas. ");
INSERT INTO urim_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Wa tu ari melnum a pikekg palng wor pa anti Pita ekg Son pa itna, kolpa atom tu ari pa, tu yangkipm kalpisen eng akalmpe kai tuwekg pa. ");
INSERT INTO urim_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kolpa atom tu lanaki tuwekg pa la tuwekg utnuurng wan a tu mring man wail wail a rpma atning yangkipm pa kul or en, a tu alntu pa rka akorla nikgwalpm tiur eng tuwekg pa rka. ");
INSERT INTO urim_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tu asen tita la, “Mpa mentepm ntokg kolai melnum wekg pa? Tu wrongkwail a rka Serusalem ti pikekg ari kwap titnongket a ake pikekg mentepm ari ep pa, a tuwekg ak kai melnum ti. Ti mentepm akentiwe mpa kuruken pa. ");
INSERT INTO urim_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mentepm or lam ngkengken ik wusoket pake, eng ake mpa tuwekg ikwap kolpa kai wail yela. Mpa mentepm autun lken atom ngkengken la, ampake tuwekg laron nang a Sisas pa niki mla ur nti ur.” ");
INSERT INTO urim_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tu akwewen yaper kawor, atom tu alken yangkipm titnongket la, “Pikekg kipmekg akwap kolpa ti kipmekg yat autun. Ikgake wa kipmekg wa kiling plan aki laron nang a Sisas pa niki melnum ur nti ur.” ");
INSERT INTO urim_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ari Pita ekg Son pa akalmpe la, “Kipm alkipm ti ikwonilmpen kai kipm alkipm ti la, pa Maur Wailen wasrongen kolai la, mpa mentekg kutnun yangkipm a kipm ti la aki mentekg kutnun yangkipm a Maur Wailen ai? ");
INSERT INTO urim_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ti mentekg ake antiwe elngen kuina ur a pikekg mentekg nungkulkg a wulmpa pa, kalpis. Mentekg ikgam laron kolpa kai pake.” ");
INSERT INTO urim_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tu wrong kin kipman ari tuwekg antokg melnum pa palng wor pa, atom tu ngkat nang a Maur Wailen yela ise. Kolpa atom tu mring man a rpma atning yangkipm pa tu ngkark eng tu wrong ai kolpa atom ake tu uk kalkuten ur tuwekg pa. Tu alken yangkipm titnongket ti kolti, la tuwekg autun la ikgake tuwekg wa laron nang a Sisas pa nti ur, atom tu ungkwanten kul or en kolti, tuwekg kai. ");
INSERT INTO urim_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Eng ntei, tu mring man pa ake antiwe karuken melnum nepm plupmen a palng wor pa. Melnum pa wring kamel wekg ise, ti am ompalm ise, pikekg rpma wringkwringen ak ai kul ai, ti tu wrongkwail ariwe ise. ");
INSERT INTO urim_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tu ungkwan Pita ekg Son kulor en ti pa, tuwekg wa yaper kai eng tu melnum alntuwekgen pa a lakati naken kuina ur a tu tukgunakgen a tu ipma krakgen, a tu melnum wailen wailen lawen pa. ");
INSERT INTO urim_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tu atning pa, tu elng ok itna wris oklala naki Maur Wailen pa la, “Melnum Wailen, kitn Wailen a antokg kitnong, a kanokg a unokg, wa kweikwei wrongkwail yela. ");
INSERT INTO urim_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Pikekg ep pa M