﻿USE sofia;
DROP TABLE IF EXISTS sofia.uri_vpl;
CREATE TABLE uri_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES uri_vpl WRITE;
INSERT INTO uri_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Melnum Wailen Tiopilus! Kupm ari tu melnum wailet ropon ekg atning ariworwor, yatom tu ro wurkapm ekg kwap kweiur kweiur wrongwailet a pike paln hep, a men ari tolpa pa aklahle, yatom men ukpma. Kuina ur a tu ro pa, tu atning kai ek a tu melnum a pike ari kweiur kweiur a pike paln hep ak ai, yatom tu la kiti naso, pa apm tu melnum akwapel a laron yangkipm a Maur Wailen apm pake. ");
INSERT INTO uri_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kupm alkupm yat kupm kor ropon atning yangkipm pa yekworwor kai atn yiprokgen ai, yatom pa kupm akwonalmpen ari pa wor ekg kupm akal ro wurkapm kil komkiti yangkipm pa yekworwor ekg kitn, Melnum Wailen Tiopilus. ");
INSERT INTO uri_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kupm ak tolpa ekg kitn wi arie worwor yangkipm a kweiur kweiur pa, a pike tu la kiti rowepm tukgunakg lngkep pa, pa aklahle. ");
INSERT INTO uri_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ak wang a pike Herot atn melnum tukgunakgen ikghlen ha knokg Jutia pa, melnum ipma krakgen ur a Maur Wailen, nang akil pa Sekaraia, kil pa melnum ipma krakgen ur a mapming a Apia. Wa kin akil Elisapet pa apm wa walyaru a Eron, melnum tukgunakgen ipma krakgen a pike atn hep. ");
INSERT INTO uri_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tuwekg pa, ipma atuwekg pa nipet wor kai ikg a Maur Wailen, wa katnun yangkipm titnongket wrongwailet a Wailen, ake wa tuwekg plan paitn ur. ");
INSERT INTO uri_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisapet pa kmpong, yatom ake tuwekg ye warim ur, kaingkai, tuwekg apm wror mayen ase. ");
INSERT INTO uri_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Wang wrij ur pa Sekaraia kil akwap a lap kweiur kweiur wepmij worwor pa atn wan yalming a Maur Wailen. Pa apm wang a mapming wrij alkilen a akwap atn wan yalming pake. Pike tu nalu yo yipik pa ekg ak laron kwap yatom Sekaraia pa nalu a lap kweiur kweiur wepmij worwor pake. Pa ya a tu ipma krakgen a ak ekg laron kwap apm tolpake. ");
INSERT INTO uri_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kil kahor lap kweiur kweiur wepmij wor pa atn pa, tu wrongwailet a kul ark wrij kahor hen pa, tu kpor klko lein, ropon Maur Wailen pa ark. ");
INSERT INTO uri_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ak wang ketn pa maur akwapel a Maur Wailen, kil palntel atn wam wien yampingken tpmakg a kil lap kweiur kweiur yaprekget wor atne pa. ");
INSERT INTO uri_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraia kil ariel, om kil wreitn paitn kark kwarkwar tolti. ");
INSERT INTO uri_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ari maur akwapel a Maur Wailen pa la nasi Sekaraia la tolpa, “Sekaraia, ampur kitn kark, ropo alkitnen pa Maur Wailen atning ase. Elisapet, kin alkitnen pa, kil hi raku warim kpman ur ekg kitn, yatom hi kitn alil nang akil pa Jon. ");
INSERT INTO uri_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ti kitn hi utopen paitn, wa tu wrongwailet tiur pa tu hi wa utopen paitn, ak wang a man rakuel pa. ");
INSERT INTO uri_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wa kil hi paln melnum wailen kai ikg a Maur Wailen. Kil hi ake al hu wain pa, aki al hu hmit titnongket titnongket pa. Ekg nte, hi warim pa arpm kahor ipma a man pa, kil apm wi Maur Wor ntie arpm ase. ");
INSERT INTO uri_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kil hi lok kipm wrong kinkpman wailet a Israel pa wa ye kul yawrik ekg Wailen, Maur Wailen alkipmen. ");
INSERT INTO uri_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Wa kil hi kai hep ekg Wailen, kil hi ntie Maur Wor, ntie titnongket tol a Ilaija melnum ek wripm a Maur Wailen pike hep pa. Kil hi pleln nikgwalpm a tu yantin pa kai ark ipma wrij namponen tu warim alntuen pa. Kil hi noworel tu melnum a talpuln yangkipm pa ekg wi arie a nikgwalpm a tu melnum nipet wor. Wa kil hi numprampen tu wrong kinkpman pa arpm nungkwangen Wailen.” ");
INSERT INTO uri_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Yatom Sekaraia kil akalmpe yangkipm a maur akwapel a Maur Wailen la tolpa, “Tolpa kalpm. Kupm ti wror, wa kin akupm pa apm wa mayen tolpa yat pake. Ti pa kuina ur hi wa plantopm la tolpa yangkipm pa aklahle pa?” ");
INSERT INTO uri_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ari maur akwapel a Maur Wailen pa akalmpe tolpa, “Kil kupm Keprel, kupm maur akwapel a atn yampingken Maur Wailen. Kil alkil kwaopm nar ekg la naseitn yangkipm wor kil. ");
INSERT INTO uri_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ari ake wa kitn ukpma yangkipm wor a kupm la pa, ti kitn al ek miteitn tolpa kai ngko wang alkilen a yangkipm pa ek arke.” ");
INSERT INTO uri_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Yatom ak wang pa tu wrong wail ark hen nungkwangen Sekaraia, tu akwonalmpen wailet tolpa, ntekg tolhai yatom kil ti arpm wang watin kahor wan yalming a Maur Wailen ti? ");
INSERT INTO uri_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kil ha kahor wan yalming wonen pa hor pa, kil ake ntie ekg ekla nti tu pa. Pake tu pa apm ari ase tolpa, kil wet ari kweiur kweiur wet Maur Wailen plantel atn kahor wan yalming pa. Yatom kil ak wam ti la nasen tolti, kil apm ek mite tolpa atn pake. ");
INSERT INTO uri_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sekaraia kil akwap atn wan yalming a Maur Wailen pa atn, kai ngko wang a tu alm pa kai plaln pa, kil wa kai wan ha alkilen. ");
INSERT INTO uri_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wang aripm ur kai plaln pa, Elisapet kil apm itna ase. Yatom tol kainil wampomit pa kil ake hor ngko hen pa, kalpm. Kil utopen la tolpa, ");
INSERT INTO uri_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Wailen kil rein ekg kupm ti, yatom kupm wi warim ti arpm ipma ti, tolpa yatom kil kwan numpaitn alkupmen ti kai ikg a tu wrong kinkpman.” ");
INSERT INTO uri_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Elisapet kil itna kainil wampomit wampomwrij, yatom ak kainil ripa Maur Wailen kil kwa maur akwapel alkil Keprel kil nar kai Nasaret, ha ur a ha knokg Kalili ekg ye yangkipm ur ekg kin warimpen ur a ake atn namponen kpman ur. Kin pa pati pike tu ak namputen kpman ur a tu kwe tolpa Josep, kil hom wrij a Teipit. Nang a kin warimpen pa Maria. ");
INSERT INTO uri_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maur akwapel a Maur Wailen pa kil paln ekg kin pa yatom kil la tolpa, “Maria, ukweitn wor! Kitn pa Maur Wailen ukweitn ipma wor wailmanten, Wailen ntieitn arpm.” ");
INSERT INTO uri_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria kil wreitn paitn ekg atning yangkipm a maur akwapel a Maur Wailen pa la nasel pa, yatom kil akwonalmpen wailet tolpa, ekla a kil la ukwor tolpa, pa atn tolhai? ");
INSERT INTO uri_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ari maur akwapel a Maur Wailen pa la nasel la tolpa, “Maria, ampur kitn kark, ekg nte, Maur Wailen kil uk ipma wor ekg kitn. ");
INSERT INTO uri_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kitn itning, kitn hi itna yatom raku warim kpman ur. Yatom hi kitn alil nang akil pa Jisas. ");
INSERT INTO uri_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kil hi paln melnum wailen yatom tu hi kwewel tolpa kil Warim Kpman a Maur Wailen a atn hep hangken kweiur kweiur wrongwailet. Wa Wailen, Maur Wailen pa, hi ntekg kil melnum wailen atn tukgunakgen ikghlen kweiur kweiur wrongwailet, wa kil hi wa atn komkiti yohmpei alkil Teipit pa. ");
INSERT INTO uri_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yatom kil hi atn melnum tukgunakgen ikghlen kipm walmpopmen walyaru a Jekob aklei wang ye hor pa kai. Kil hi apm atn tukgunakgen ikghlen kweiur kweiur wrongwailet tolpa kai pake, hi ake kai plaln.” ");
INSERT INTO uri_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria kil atning a maur akwapel a Maur Wailen la tolpa, yatom kil akalmpentel la tolpa, “Kupm ti ake atn nti kpman ur pa, ti ntekg tolhai yatom al wa kupm kai tol ek a kitn la pa?” ");
INSERT INTO uri_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ari maur akwapel a Maur Wailen pa akalmpentel la tolpa, “Maur Wor a Maur Wailen al nar kahor ipma alkitnen, wa titnongket a Maur Wailen pa al ak haureitn. Tolpa ti warim a hi kitn raku pa, hi paln wri wor, yatom hi tu kwewel tolpa Warim Kpman a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ti kitn akwonalmpen Elisapet, hom wrij alkitnen pa, kil apm mayen ase. Tu pike lawel tolpa kil kmpong ari kil apm itna kainil wampomit wampomwrij tike, yatom kil hi raku ak mayenel warim kpman. ");
INSERT INTO uri_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ekg nte, ake kwei ur wonet ekg Maur Wailen ti.” ");
INSERT INTO uri_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Yatom Maria pa akalmpentel la tolpa, “Apm nte, kupm kin akwapel a Wailen, ti kuina ur a wet kitn la akal paln kai kupm ti pa, kupm wi wor tolti.” Yatom maur akwapel a Maur Wailen pa nuhurntel kai. ");
INSERT INTO uri_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wang aripm ur kai plaln pa, Maria kil numprampen tolti, kil wreitn, aktutu kai kinar ha knokg nangen Jutia, yatom kil kai ha ur a Sekaraia a Elisapet arpme pa. ");
INSERT INTO uri_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Yatom kil kai kahor wan a Sekaraia pa, om kil uk wang wor Elisapet pa. ");
INSERT INTO uri_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ak wang a Elisapet kil atning a Maria kil ukwel wor pa, warim pa alm num kahor ipma wonen a kil pa, tolpa yatom Maur Wor pa akwap titnongket kai Elisapet pa, ");
INSERT INTO uri_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","yatom kil la yikaktnen la tolpa, “Kitn pa Maur Wailen ukweitn ipma wor wrijen hangken tu kin tiur ai, wa kil wa uk ipma wor warim a arpm ipma a kitn ti yat. ");
INSERT INTO uri_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ntekg tolhai yatom al wa kitn man a hi raku Melnum Wailen a kupm ti wa kul ari kupm kin a tolti! ");
INSERT INTO uri_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ti kitn ari, wang a kupm atning ek a kitn ukopm wang wor pa, warim a arpm kahor ipma alkupmen pa kil alm num utopen wail. ");
INSERT INTO uri_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pike kitn ukpma yangkipm a Wailen la tolpa, pa hi paln ek arke aklahle, tolpa ti kitn pa wor pake, kitn utopen om!” ");
INSERT INTO uri_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Elisapet kil kat nang a Maur Wailen tolpa kai plaln pa, wa Maria kil wa la tolpa, “Ipma akupm ti pa kat nang a Wailen. ");
INSERT INTO uri_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Maur wor alkupmen pa ak utopen Maur Wailen, melnum alkupmen a akwiopm. ");
INSERT INTO uri_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ekg nte, kil pike akwonalmpentopm, kupm kin ur a arpm tolti nang kalpmel, akwap horhanekg ekg kil. Yatom ak wang ti ye hor pa kai pa tu wrong kinkpman hi wa wi wor laopm tolpa, kupm pa wor, ekg nte, Maur Wailen ukpma wor ekg kupm ti. ");
INSERT INTO uri_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ekg nte, kil ntie titnongket wail, yatom kil ntekg kweiur kweiur wailmanten ekg kupm. Nang alkilen pa atn wri wor. ");
INSERT INTO uri_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kil plan ipma rein a kil pa kai ekg tu melnum a arku tu alntu horhanekg ekg kil. Apm hi wa atn tolpa kai ekg tu warim walmpopmen walyaru pa ye hor pa kai pake. ");
INSERT INTO uri_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wa kil ntekg kweiur kweiur titnongket wail ak wam alkilen, wa kil kwan tu mla ur a pike akwonalmpen tolpa kat nang alntuen tolpa tu melnum wailen, kil kwanten kai hor pa hor pa. ");
INSERT INTO uri_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kil arku tu melnum wailwail a atn tukgunakgen pa, ye kinar knokg. Wa kil kat nang a tu melnum a nang kalpmten pa, ye kaino kwa. ");
INSERT INTO uri_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kil uk kweiur kweiur worwor kai tu melnum a nikgten pa, wa kil kwa tu mla ur a ntie kweiur kweiur pa, tu kompwam kaingkai. ");
INSERT INTO uri_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kil aklin Israel, tu melnum akwapel alkilen. Wa kil ake wonhmiten tu wrong kinkpman alkilen, yatom wa kil reinjen ikghlenten. ");
INSERT INTO uri_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Apm tol a pike kil yipon yangkipm la nasi tu yantin maminen alpmenen pake, Apraham namponen walmpopmwrij walyaru alkil pa aklei wang hor pa kai.” Nangnang a Maria pa apm kai tolpake. ");
INSERT INTO uri_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Yatom kil nti Elisapet pa arpm pa kaingkai, kainil wraur pa kai plaln, yatom kil wa kai ha alkilen. ");
INSERT INTO uri_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisapet kil itna tolpa kai ngko wang alkil a raku pa, kil raku warim kpman. ");
INSERT INTO uri_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yatom tu melnum tiur alkil a arpm yampingkentel pa, tu hom wrij alkil pa, tu atning Wailen kil plan ipma rein wailmanten tolpa kai ekg Elisapet pa, yatom tu utopen paitn nampontel. ");
INSERT INTO uri_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kil ye warim pa ye arpm, wang wampomit wampomwekg pa kai plaln pa, wang wampomit wampomwraur pa, tu kul akal kwat numpalk a warim pa, wa tu la tolpa akal alil nang a yan alkilen ti Sekaraia. ");
INSERT INTO uri_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ari man alkil pa la tolpa, “Pa kalpm, al alil nang akil pa Jon.” ");
INSERT INTO uri_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ari wa tu akalmpe tolpa, “Ake tu tiur kai hom alkitnen pa alil nang ur tolpa, kalpm.” ");
INSERT INTO uri_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yatom tu ak wam ti ak ropon yan alkil pa tolpa, kil wakrongen akal alil nang mla kai warim pa. ");
INSERT INTO uri_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ari Sekaraia kil ak wam pa la nasen la tolpa tu ukwel tangwrong wompel ur a ro kweiur kweiur hele pa, yatom kil ro nang a warim pa tolpa Jon. Tu wrongwailet tu ari pa, tu wreitn paitn. ");
INSERT INTO uri_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ak wang ketn pa Sekaraia a pike ek mite pa wa kil ekla, yatom kil wa kat nang a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tu a ark yampingkentel pa tu ari pa, tu kark akwonalmpen wailet. Wa yangkipm a kweiur kweiur a paln pa apm wa tu ye kai hor ha a ark knokg nangen a Jutia ase. ");
INSERT INTO uri_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yatom tu wrongwailet atning yangkipm pa, tu akwonalmpen wailet ropon tita la tolpa, “Warim pa hi paln melnum tolhai?” Tu ari tolpa titnongket a Wailen pa ikghlentel arpm. ");
INSERT INTO uri_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yangkipm a Jon pa ek arke ase, yatom Maur Wor pa akwap titnongket kahor ipma a Sekaraia, yan a Jon pa, yatom kil laron kuina ur a Maur Wor katel ek om kil la pa, ");
INSERT INTO uri_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kat nang a Wailen, Maur Wailen a Israel. Ekg nte, kil nar ekg akarmpen mento wrong kinkpman alkilen. ");
INSERT INTO uri_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wa kil kat melnum nang wailen ntie titnongket hi akwio, melnum pa kai hom a Teipit, melnum akwapel alkilen. ");
INSERT INTO uri_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tukol pike hep ak ai kil la om paln kai ek a tu melnum ek wripm wri wor alkilen hep ak ai. ");
INSERT INTO uri_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kil la tolpa, kil pa hi akwio kai wam a tu wrongmnto, wa kai wam a tu melnum a ipma paitn ekg mento. ");
INSERT INTO uri_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kil plan ipma rein alkilen pa kul ekg mento ti. Wa kla a pike kil lam namponen tu yantin mamin mamei alpmenen pa, pa kil akwonkiti arpm. ");
INSERT INTO uri_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kil atn hel nang a kil alkil ti la nasi Apraham, yohmpei alpmenen, ");
INSERT INTO uri_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","la tolpa kil hi wa akwi mento ti tukulein kai wam a tu wrongmnto alpmenen, ekg mento hi ake kark ekg kat nang alkilen pa. ");
INSERT INTO uri_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Wa mento hi arpm wri wor nipet wor kai ikg alkilen aklei wang a mento arpm knokg ti.” ");
INSERT INTO uri_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wa Sekaraia wa la warim kpman alkil Jon ti la tolpa, “Ti kitn warim alkupmen ti, tu pa hi kweweitn tolpa kitn melnum ek wripm a Maur Wailen a atn hep hangken kweiur kweiur wrongwailet pa. Kitn hi kai hep numprampen ya ekg Wailen. ");
INSERT INTO uri_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kitn hi wa laron la nasi tu wrong kinkpman alkil pa, ekg tu ari tolpa Maur Wailen hi wawien om kwan paitnpaitn alntuen. ");
INSERT INTO uri_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ekg nte, ipma rein a Maur Wailen alpmenen pa wailmanten paitn, yatom hi tukol takgni a ro ha kaino ktnong pa nar ak helento ");
INSERT INTO uri_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ekg uk klalet tu melnum a ark mningket, a kark ekg mo, om lok nepm pa ekg hi mento ngkom hor ya wor a arpm mehen wor.” Nangnang a Sekaraia ak pa apm kai plaln tolpake. ");
INSERT INTO uri_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yatom warim pa kil wreitn wail, wonrekele nikgwalpm arke pa, kil kai arpm wrik kalpmel a ake melnum ur arpme pa, kaingkai, kil wreitn pa, kil kai ngko wurknong a tu wrong kinkpman. ");
INSERT INTO uri_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ak wang pa Okastus, melnum tukgunakgen a tu Rom pa, kil kwa yangkipm pa kai la tolpa tu al wi nangkel tu wrongwailet a ark hor ha knokg a kil alkil ikghlen pa. ");
INSERT INTO uri_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Wang hep a tu wi nangkel tu wrong kinkpman. Ak wang pa Kwirinius kil atn melnum wailen a ha knokg Siria. ");
INSERT INTO uri_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yatom tu wrongwailet tu wreitn kai hor ha yiprokg wrij wrij alntuen pa ekg tu wiyen nang. ");
INSERT INTO uri_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tolpa yatom Josep yat kil wreitn kai Nasaret, ha wail ur a ha knokg Kalili, wa kil akal kinar Petlehem, ha yiprokg a Teipit a ark ha knokg a Jutia, ekg nte, kil apm walyaru a hom wrij a Teipit pake. ");
INSERT INTO uri_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yatom kil wi kin alkil Maria pa, tuwekg kai kinar akal tu wiyen nang. Maria pa pike tu ak namput tolpa hi arpm ekg kil pa, kin pa apm itna warim kakir ekg akal raku tike. ");
INSERT INTO uri_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Yatom ak wang a tuwekg arpm Petlehem pa, pa wang alkilen ekg kil akal raku warim. ");
INSERT INTO uri_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Yatom kil raku warim kpman kmpayen wrij alkil pa, yatom kil yipoel ak hapm pa, alupm eln kinar yo tmpal a kau al ekpma nare pa. Ekg nte, wan a tu kul hokg atne pa, apm lawe ase. ");
INSERT INTO uri_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tu melnum tiur a ikghlen sipsip pa ark wrik henen a ark yampingken ha Petlehem pa, tu atnen sipsip pa ak mning pa atn. ");
INSERT INTO uri_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yatom maur akwapel a Maur Wailen kil paln kai kuin a tu pa, wa wakg a Wailen pa nar ak helenten, yatom tu wreitn paitn kark. ");
INSERT INTO uri_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ari maur akwapel a Maur Wailen pa la nasen la tolpa, “Kipm itning, ampur kipm kark, kupm ye yangkipm wor nar ekg la nasepm. Yangkipm wor pa hi ak ntekg tu wrongwailet tu utopen wail paitn. ");
INSERT INTO uri_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Melnum a hi akwiyepm pa wet ti man ur raku kai ha a Teipit pa. Kil pa kil Wailen, kil Krais, Melnum a Maur Wailen kil rkahan yatom kwa kul nar ekg mo akarmpen kipm wrong kinkpman. ");
INSERT INTO uri_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Al kipm kai ari warim a tu ak hapm yipo alupm eln kinar yo tmpal a kau al ekpma nare pa. Al kipm ari pa, warim apm pake.” ");
INSERT INTO uri_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tu maur akwapel a Maur Wailen a ark kaino ha wor pa, wailet paitn ai tukol tu melnum a almpwrong pa tu nel paln aktutu tolti kai atn namponen maur akwapel a Maur Wailen pa, wa tu kat nang a Maur Wailen pa la tolpa atn, ");
INSERT INTO uri_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kat nang a Maur Wailen a arpm kaino kwa, ekg kil ukpma wor wakrongen kipm wrong kinkpman a arpm knokg ti, tolpa yatom kipm arpm mehen wor.” ");
INSERT INTO uri_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tu maur akwapel a Maur Wailen tu kat nang a Maur Wailen pa plaln pa, tu nuhurnten wa kaino ha wor ai, tu melnum a ikghlen sipsip pa nel la nasi tita la tolpa, “Ti mento kai Petlehem ai, ekg ari kuina ur a wet paln ti, a Wailen kil la naso pa.” ");
INSERT INTO uri_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yatom tu wreitn aktutu tolti, kai kor kor om hantil Maria ekg Josep namponen warim pa, a hokga yo tmpal a kau al ekpma nare pa. ");
INSERT INTO uri_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tu ari warim pa, om tu la kiti kuina ur a wet maur akwapel a Maur Wailen la nasen kai warim pa, nasi tu a ark pa. ");
INSERT INTO uri_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Yatom tu atning yangkipm pa, tu wreitn paitn akwonalmpen wailet ekg kuina ur a tu melnum a ikghlen sipsip pa la nasen pa. ");
INSERT INTO uri_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pake Maria pa kil alupm yangkipm wrongwailet pa, yatom kil akwonalmpen yangkipm pa arpm. ");
INSERT INTO uri_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tu melnum a ikghlen sipsip pa tu wa pleln kai, wa tu ak nangnang ak kat nang a Maur Wailen ekg kuina ur a tu atning ari, tol a wet tu maur akwapel a Maur Wailen la nasen pa. ");
INSERT INTO uri_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Maria raku Jisas arpm kaingkai, wang wampomit wampomwraur pa, tu kwat numpalk a kil pa. Wa tu alil nang a kil pa Jisas. Nang pa pati, pike maur akwapel a Maur Wailen kil alilel hep ak ai, ak wang a kil ake pike paln arpm ipma a man alkil pa. ");
INSERT INTO uri_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ak wang a Maria karkuk ak hu wor ekg paln wri wor kai ikg a Maur Wailen pa, komkiti yangkipm titnongket a Moses la pa, tuwekg ye Jisas ye kaino Jerusalem ekg uk kai wam a Wailen. ");
INSERT INTO uri_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tukol yangkipm titnongket a Maur Wailen ro pa la tolpa, “Warim kpman kmpayen wrongwailet pa, tu al ye kai uk Maur Wailen pa, pa alkilen pake.” ");
INSERT INTO uri_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Wa tuwekg kai lap al wor uk komkiti yangkipm titnongket a Wailen la pa, ye putnum wekg aki, ye kilmpin wlampien wekg e. ");
INSERT INTO uri_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ak wang ti melnum ur a arpm kai Jerusalem pa, nang a kil pa Simion, kil melnum nipet wor a ukpma Maur Wailen. Kil arpm nungkwangen tolpa akal Maur Wailen kil aklin tu Israel a kwan kalkuten alntuen. Melnum pa kil ntie Maur Wor. ");
INSERT INTO uri_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Wa kil pike Maur Wor la nasel la tolpa, kil hi ake mo, kil hi arpm ekg ari Krais, melnum a Maur Wailen kil yipon yangkipm tolpa hi nar ekg akarmpen tu wrong kinkpman pa plaln pa, kil mo. ");
INSERT INTO uri_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Maur Wor pa kil akwap kai Simion pa, tolpa yatom kil kai kahor yipmingki wonen a wan yalming a Maur Wailen, ak wang a manjan tuwekg ye warim Jisas pa ye kahor yipmingki wonen a wan yalming a Maur Wailen, akal ak kwap tol yangkipm titnongket a Moses la pa. ");
INSERT INTO uri_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Yatom Simion ari warim ripa, kil kai katel, kil ukwor kai Maur Wailen, wa kil la tolpa, ");
INSERT INTO uri_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Wailen, kupm melnum akwapel alkitnen, kitn pike la tolpa kupm hi ake mo, kupm hi arpm ari Krais pa plaln, pa kupm mo. Ti warim ti apm kupm ari apm tike. Ti kitn akal wiopm pa, kitn wiopm om! ");
INSERT INTO uri_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Kupm ari ak ikg alkupmen ase warim alkitnen a hi akwi mento wrong kinkpman, a pike kitn numprampen kai ikg a tu wrong kinkpman wrongwailet. ");
INSERT INTO uri_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Warim pa tol wakg a hi ak helen tu a ake Juta, a hi wa uk nang wail kai tu wrong kinkpman alkitnen a Israel.” ");
INSERT INTO uri_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ti tuwekg manjan a warim pa, tuwekg wreitn paitn ekg atning kuina ur a Simion la kai warim ripa. ");
INSERT INTO uri_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Yatom Simion kil ukwen wor, wa la kai Maria, man a warim pa la tolpa, “Warim kil pa, Maur Wailen kil rkahan ekg hi wa ntekg tu wailet a Israel hi wa wutat ngko, wa wailet pa hi wa wreitn atn. Maur Wailen kil rkahan kil atn tol klal ur a hi tu la paitnel. ");
INSERT INTO uri_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tolpa ti nikgwalpm hampen wor a paitn a tu wrongwailet pa hi paln ngko wurknong. Ti wa Maria kitn ti yat, kalkut wail ur a hi palnteitn pa, pa hi wa kungkueitn nikgwalpm.” Yangkipm a Simion la pa apm kai tolpake. ");
INSERT INTO uri_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ti kin ek wripm ur pa, nang akil pa Ana, kil warim kin a Panuel, hom ur a Aser. Kil pa kin mayen, wring akil pa kmel witnweitn tuwek witnweitn (84). Kil pike wi kpman arpm wring wampomit wampomwekg. Kpman pa mo, wa kil arpm kin karpikg tolti arpm. Wa kil ake wa nuhurn yipmingki wonen a wan yalming a Maur Wailen pa, mning hranen, kil arpm uk wang, ekpma kalpmen, kpor klko lein ropon Maur Wailen tolpa kai pake. ");
INSERT INTO uri_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simion la yangkipm nasi Maria pa atn pa, Ana wa kul no atn ukwor Maur Wailen, wa kil la nasi tu wrongwailet a nungkwangen melnum a hi akarmpen tu wrong kinkpman a Jerusalem pa la tolpa, ti warim pa apm tike. ");
INSERT INTO uri_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep ekg Maria tuwekg ak kwap wrongwailet pa komkiti yangkipm titnongket a Wailen kil la pa, plaln pa, tuwekg wa pleln kaino ha alntuwekgen Nasaret a ha knokg Kalili. ");
INSERT INTO uri_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tunten kaino arpm arpm, warim pa kil wreitn wail wi titnongket, wa kil nikgwalpm arke wonrekele. Wa Maur Wailen utopen ukwel wor. ");
INSERT INTO uri_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Aklei wring wrij wrij pa, manjan a Jisas pa, tuwekg kinar Jerusalem ekg ntekg ekpma wail al ak wang a tu arpm akwonalmpen Maur Wailen pike akwi tu Israel hakai Ijip kul. ");
INSERT INTO uri_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisas pa wreitn klom watin ase, wring wampwam yikakwomwekg (12) pa, yatom kil nti manjan alkil pa kinar ekg ntekg ekpma wail al komkiti ya a arpm alntuen pa. ");
INSERT INTO uri_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tu ntekg ekpma wail pa al plaln pa, manjan a Jisas pa apm ekg wa nuhurn Jerusalem pa akal wa kaino ha wail Nasaret pa. Pake warim kpman Jisas pa kil arpm kinar Jerusalem ai arpm ai. Ti tuwekg manjan pa tuwekg ake wa ariel. ");
INSERT INTO uri_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tuwekg akwonalmpen tolpa, kil apm nti tu pa kaino pake. Tu ngkom hor ya pa kaino, mninget ngko ya pa, tuwekg korel kai kuin a tu yiprokgen walmpopm wrij alntuwekgen pa. ");
INSERT INTO uri_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ari ake wa tuwekg ariel, yatom wa tuwekg wa pleln kinar korel kinar ha wail Jerusalem ai. ");
INSERT INTO uri_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tuwekg korel tolpa kai, mning wraur pa kai plaln pa, tuwekg hantilel arpm kahor yipmingki wonen a wan yalming a Maur Wailen. Kil arpm namponen tu melnum a arpmen yangkipm yiprokgen a Maur Wailen, kil arpm atning yangkipmek tiur a tu la pa ak roponten tolpa arpm. ");
INSERT INTO uri_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tolpa yatom tu wrongwailet a atning yangkipm a kil pa, tu wreitn paitn ekg nikgwalpm arie a kil akalmpe yangkipm a tu la pa. ");
INSERT INTO uri_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tuwekg manjan alkil pa ariel, om tuwekg wreitn paitn wrijen. Yatom man pa la kai warim kpman alkil pa la tolpa, “Kitn wa ntekg tolpa ekg mentekg ti ekg nte? Yan alkitnen pa namponen kupm ti, mentekg pike ipma kalkut paitn ekg mentekg koreitn.” ");
INSERT INTO uri_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ari warim kpman alkil pa akalmpenten la tolpa, “Wa kipmekg koropm ekg kuina? Kipmekg ari tolpa, kupm apm arpm wan a yan alkupmen tike!” ");
INSERT INTO uri_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ari tuwekg ake wa ari kuina ur a kil la pa. ");
INSERT INTO uri_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yatom kil wreitn ntien kaino Nasaret, wa kil aklei wang atning nungkulkg yangkipmek atuwekg. Pake man pa alupm yangkipm wrongwailet a warim kpman pa arpm kahor nikgwalpm alkil pa. ");
INSERT INTO uri_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas kil wreitn wail namponen nikgwalpm arie wor, yatom ntekg Maur Wailen namponen tu wrong kinkpman pa tu utopentel. ");
INSERT INTO uri_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taiperius kil atn melnum tukgunakgen ikghlen Rom atn tukol wring wampwam yikakwomit (15) pa. Wa Pontius Pailat pa, kil atn melnum wailen ikghlen ha knokg a Jutia. Wa Herot kil ikghlen ha knokg a Kalili, wa wasok alkil Pilip pa kil ikghlen ha knokg a Ituria a Trakonitis. Lisanias pa kil ikghlen ha knokg a Apilene. ");
INSERT INTO uri_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Wa Anas ekg Kaiapas pa tuwekg atn melnum tukgunakgen a ikghlen tu melnum ipma krakgen a Maur Wailen. Yatom ak wang pa ek a Maur Wailen kil kwe Jon warim kpman a Sekaraia pa, atn kai wrik kalpmel a ake melnum ur arke pa. ");
INSERT INTO uri_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yatom Jon kil wreitn hor pa kai ha knokg wrongwailet a ark yampingken kop Jotan pa, wa kil laron yangkipm pa tolpa tu pleln ipma, ekg al kil kaluken, ekg al Maur Wailen kil kwan paitnpaitn alntuen. ");
INSERT INTO uri_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tukol a pike ro hel kai wurkapm a melnum ek wripm Aisaia pa la tolpa, “Ek a melnum ur kwe kai wrik kalpmel pa la tolpa, ‘Numprampen ya pa ekg Wailen, kuleinjel ya pa riworwor! ");
INSERT INTO uri_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ilm hap nare wrik tungkurin tungkurin pa kul no hirhir, rku wrik nimlien nimlien a wrik tipmningken pa ye nar hirhir. Wa tukule ya a raimpen pa kai nipet wor, wa tukule ya a watinet a paitn pa wa paln wor! ");
INSERT INTO uri_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Wa kinkpman wrongwailet hi wa ari kwap a Maur Wailen kil hi wa ak, ekg akwi mento wrongwailet’.” Yangkipm a pike melnum ek wripm Aisaia pa apm pike la ekg Jon pake. ");
INSERT INTO uri_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yatom Jon la nasi tu wrong kinkpman wailet a nel kulngkul akal kil kaluken pa la tolpa, “Kipm ti ul paitn! Mla ur la nasepm tolpa kipm hi wa kark tukulein ipma wleket a Maur Wailen a hi nar ti? ");
INSERT INTO uri_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ti atn a arpm alkipmen pa al ngko ek arke wor, ekg al plan tolpa kipm apm pleln ipma ase. Ake al kipm akwonalmpen tolpa kipm wor, ekg nte melnum nipet wor Apraham pa mamin wror alkipmen pa. Tol kupm la nasepm tol kil, Maur Wailen ti ntie ekg ntekg weij ti paln walmpopm a walyaru a Apraham. ");
INSERT INTO uri_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ti kotwang pa apm numprampen ha yo yiprokg wrongwailet pa ase. Yo wrongwailet a ake ngko ek arke wor pa, hi tu ware kwat rkol piln eln kai wakg.” ");
INSERT INTO uri_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yatom kinkpman wrongwailet pa wa ropontel la tolpa, “Ti al men ntekg tolhai ekg men ngko ek arke wor?” ");
INSERT INTO uri_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ari Jon akalmpenten la tolpa, “Melnum a kil ntie hapm wekg a nowe pa, kil uk ur kai melnum ur a kalpm pa. Wa melnum ur a ntie ekpma pa, apm wa kil ak tolpa yat pake.” ");
INSERT INTO uri_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wa tu melnum tiur a wi takis marpm kai tu pa, tu kul ekg akal kil kaluken yat. Yatom nel ropontel la tolpa, “Melnum a Uk Arie, al men ntekg kuina?” ");
INSERT INTO uri_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ari kil la nasen la tolpa, “Ake al kipm wi takis marpm kai tu pa hangken marpm a pike tu yipon pa.” ");
INSERT INTO uri_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wa tu melnum tiur a almpwrong pa kul ropontel la tolpa, “Om men ti, al ntekg kuina?” Ari kil akalmpenten la tolpa, “Ake al kipm akplain a titnongket kalpmel ekg tu mla ur ekg wi kweiur kweiur alntuen pa. Kipm al wi wor ekg marpm a kipm wi ekg kwap a kipm ak pa, pa apm ha pake.” ");
INSERT INTO uri_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tu wrong kinkpman pa tu atning a Jon kil la tolpa, yatom tu nungkwangen arpm ari, wa tu akwonalmpen wailet kahor nikgwalpm alntuen ti la tolpa, Jon pa apm kil Krais pa ur pake. ");
INSERT INTO uri_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yatom Jon kil akalmpe kai tu wrongwailet pa la tolpa, “Kupm ti pa, kupm kalukepm ak hu ti tolti. Pake melnum ur a ntie titnongket wailmanten hangken kupm ti pa hi wa kul. Ti kupm kil melnum paitn a nang kalpmel a tolti, pa wa tol a kupm akwap paitn ur tol a nir nepm palk kai melnum wailen tolpake, ari kupm ake ntie ekg akwap a tolpa yat. Kil pa hi wa kalukepm ak Maur Wor a ak wakg. ");
INSERT INTO uri_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kil nampil keimung pa ye atn kai wam alkil pa, ekg akal ak ngkol wit ek pa, ekg al wripm pa wi palk pa kai manet, won wor pa eln nar ha. Yatom kil ngkol won wor pa elntatn wrij kai wan wit alkilen pa. Pake hi kil lap palk paitn pa kai wakg a hi ake me.” ");
INSERT INTO uri_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon kil ukwen nikgwalpm wailet aur aur tolpa ak alm ipma a tu pa, wa laron yangkipm wor a Maur Wailen pa la nasen. ");
INSERT INTO uri_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pake kil kle Herot, melnum wailen a ikghlen ha knokg Kalili pa, ektnen a kil krpo Herotias itna wampel Pilip, wasok alkilen pa, wa ekg paitnpaitn wrongwailet tiur a kil ntekg pa yat. Herotias pa kil kin a Pilip. ");
INSERT INTO uri_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tolpa yatom Herot kil kwa Jon ti uk tu ye kahor arpm kahor wan tipmning, pa wa kil ntekg paitn akntie paitnpaitn tiur a kil ntekg pa. ");
INSERT INTO uri_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ak wang a Jon ake Herot wiyel ye kai arpm wan tipmning pa, kil kaluk tu wrong kinkpman wailet. Plaln, wa kil wa kaluk Jisas pa yat. Jisas wreitn atn ropon Maur Wailen pa, ktnong pa rekel tolti, ");
INSERT INTO uri_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","om Maur Wor pa nar tukol wel putnum pa arpm tukgunakg a kil pa. Wa ek ur pa kwe ha kaino ktnong pa nar la tolpa, “Kitn pa Warim Kpman alkupmen, kupm wakrongenteitn, wa kupm utopenteitn paitn wrijen.” ");
INSERT INTO uri_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisas kil warimpen ase, wring kmel wrij tuwek wampwam (30) pa, kil katen kwap ak. Wa kil pa warim kpman a tu akwonalmpen tolpa kil warim kpman a Josep. Wa Josep pa warim kpman a Heli, ");
INSERT INTO uri_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","wa Heli pa warim kpman a Matat. Wa Matat pa warim kpman a Lipai. Wa Lipai pa warim kpman a Melki. Wa Melki pa warim kpman a Jainai. Wa Jainai pa warim kpman a Josep. ");
INSERT INTO uri_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Wa Josep pa warim kpman a Matatias. Wa Matatias pa warim kpman a Amos. Wa Amos pa warim kpman a Nahum. Wa Nahum pa warim kpman a Esli. Wa Esli pa warim kpman a Nakai. ");
INSERT INTO uri_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Wa Nakai pa warim kpman a Mat. Wa Mat pa warim kpman a Matatias. Wa Matatias pa warim kpman a Semen. Wa Semen pa warim kpman a Josek. Wa Josek pa warim kpman a Jota. ");
INSERT INTO uri_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Wa Jota pa warim kpman a Joanan. Wa Joanan pa warim kpman a Resa. Wa Resa pa warim kpman a Serupapel. Wa Serupapel pa warim kpman a Sealtiel. Wa Sealtiel pa warim kpman a Neri. ");
INSERT INTO uri_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Wa Neri pa warim kpman a Melki. Wa Melki pa warim kpman a Ati. Wa Ati pa warim kpman a Kosam. Wa Kosam pa warim kpman a Elmatam. Wa Elmatam pa warim kpman a Er. ");
INSERT INTO uri_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Wa Er pa warim kpman a Josua. Wa Josua pa warim kpman a Elieser. Wa Elieser pa warim kpman a Jorim. Wa Jorim pa warim kpman a Matat. Wa Matat pa warim kpman a Lipai. ");
INSERT INTO uri_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Wa Lipai pa warim kpman a Simion. Wa Simion pa warim kpman a Juta. Wa Juta pa warim kpman a Josep. Wa Josep pa warim kpman a Jonam. Wa Jonam pa warim kpman a Eliakim. ");
INSERT INTO uri_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Wa Eliakim pa warim kpman a Melea. Wa Melea pa warim kpman a Mena. Wa Mena pa warim kpman a Matata. Wa Matata pa warim kpman a Natan. Wa Natan pa warim kpman a Teipit. ");
INSERT INTO uri_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Wa Teipit pa warim kpman a Jesi. Wa Jesi pa warim kpman a Opet. Wa Opet pa warim kpman a Poas. Wa Poas pa warim kpman a Salmon. Wa Salmon pa warim kpman a Nason. ");
INSERT INTO uri_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Wa Nason pa warim kpman a Aminatap. Wa Aminatap pa warim kpman a Atmin. Wa Atmin pa warim kpman a Arni. Wa Arni pa warim kpman a Hesron. Wa Hesron pa warim kpman a Peres. Wa Peres pa warim kpman a Juta. ");
INSERT INTO uri_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Wa Juta pa warim kpman a Jekob. Wa Jekob pa warim kpman a Aisak. Wa Aisak pa warim kpman a Apraham. Wa Apraham pa warim kpman a Tera. Wa Tera pa warim kpman a Nahor. ");
INSERT INTO uri_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Wa Nahor pa warim kpman a Seruk. Wa Seruk pa warim kpman a Reu. Wa Reu pa warim kpman a Pelek. Wa Pelek pa warim kpman a Eper. Wa Eper pa warim kpman a Sela. ");
INSERT INTO uri_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Wa Sela pa warim kpman a Kainan. Wa Kainan pa warim kpman a Arpaksat. Wa Arpaksat pa warim kpman a Siem. Wa Siem pa warim kpman a Noa. Wa Noa pa warim kpman a Lamek. ");
INSERT INTO uri_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Wa Lamek pa warim kpman a Metusela. Wa Metusela pa warim kpman a Enok. Wa Enok pa warim kpman a Jaret. Wa Jaret pa warim kpman a Mahalalel. Wa Mahalalel pa warim kpman a Kenan. ");
INSERT INTO uri_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Wa Kenan pa warim kpman a Enos. Wa Enos pa warim kpman a Set. Wa Set pa warim kpman a Atam. Wa Atam pa warim kpman a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisas kil nuhurn kop hu Jotan pa, kil ntie Maur Wor, yatom Maur Wor pa ak wiyel ye kai wrik kalpmel ur a ake melnum ur arke. ");
INSERT INTO uri_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kai wrik pa kil arpm tol wang kmel wekg (40) wa Maur Paitn Satan kil rkolel ekg akal kil ngko kai paitn. Ake kil al ekpma ur, tolpa kaingkai wang pa kai ekg akal plaln pa, nikgtel paitn wrijen. ");
INSERT INTO uri_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tolpa yatom Maur Paitn Satan pa la nasel la tolpa, “Kitn ti Warim a Maur Wailen, ti kitn la ekg weij ti paln tol ekpma pa ekg kitn il.” ");
INSERT INTO uri_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ari Jisas akalmpe la tolpa, “Wurkapm a Maur Wailen pa la tolpa, melnum ake ntie ekg arpm ak ekpma hute.” ");
INSERT INTO uri_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Wa Maur Paitn Satan pa ak wiyel wa kai kaino atn wrik tipmningken watin ur pa, yatom aktutu tolti paln plantel wrik knokg, a ha kweiur kweiur wrongwailet a atn knokg ti. ");
INSERT INTO uri_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Yatom kil la nasel la tolpa, “Kupm akal ukweitn titnongket ekg kitn ikghlen kweiur kweiur worwor wrongwailet a atn knokg ti. Kweiur kweiur wrongwailet ti apm pike eln kul wam alkupmen ti ase. Ti kupm akal uk kai mla ur a kupm akal uk pa, pa kupm uk tolti. ");
INSERT INTO uri_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ti tol kitn kpor klko lein kupm ti pa, kweiur kweiur wrongwailet pa alkitnen plaln.” ");
INSERT INTO uri_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ari Jisas akalmpentel la tolpa, “Wurkapm a Maur Wailen pa la tolpa, ‘Kpor klko lein Wailen, Maur Wailen alkitnen, wa kat nang alkilen wrij tolti.’ ” ");
INSERT INTO uri_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ake kil wa ngko, tolpa yatom wa Maur Paitn Satan wa ak wiyel ye kai Jerusalem pa, yatom wiyel ye kaino atn kaino wan kmpo kwa a wan yalming a Maur Wailen pa. Yatom kil la nasel tolpa, “Kitn ti Warim Kpman a Maur Wailen pa, kitn tpra itn ti eln kinar knokg ai! ");
INSERT INTO uri_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ro hel kai Wurkapm a Maur Wailen pa la tolpa, ‘Al kil nasi tu maur akwapel alkilen ti ekg al tu atnenteitn ariworwor pa.’ ");
INSERT INTO uri_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Wa ro tolpa yat, ‘Al tu wamalilnteitn, tolpa ti ake al kitn kwat nepm hel weij ur pa, kalpm.’ ” ");
INSERT INTO uri_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ari Jisas akalmpentel la tolpa, “Wurkapm a Maur Wailen pa la tolpake, pake wa la yat tolkil, ‘Ake al kitn uktiel Wailen, Maur Wailen alkitnen ti.’ ” ");
INSERT INTO uri_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Maur Paitn Satan kil uktiel Jisas kai kweiur kweiur wrongwailet pa plaln pa, wa kil wa nuhurntel kai pen. ");
INSERT INTO uri_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yatom Jisas wa kaino ha knokg Kalili namponen titnongket a Maur Wor. Wa yangkipm a la kiti kil pa apm kai hor ha knokg yampingken tiur pa ase. ");
INSERT INTO uri_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kil ro tukgunakg lngkep a tu kinkpman wrongwailet pa atn wan alntuen a tu atning yangkipm a Maur Wailen atne pa, wa tu wrongwailet pa tu kat nang akil pa. ");
INSERT INTO uri_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisas kil wa kai Nasaret, ha a pike kil wreitn wail atne pa. Ak wang a tu Juta ark ekg yapm pa, kil kai kahor wan a tu atning yangkipm a Maur Wailen atne pa, kil aklei wang pa apm ak tolpake. Yatom kil wreitn atn akal klein wurkapm a Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Yatom tu wi wurkapm a melnum ek wripm Aisaia pa ukwel, yatom kil ari om kil wi wurkapm pa kil halken kor yangkipm ur a ro tolpa, ");
INSERT INTO uri_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Maur Wor a Wailen arpm kupm, ekg nte, kil alkil akrkahantopm akal kupm laron yangkipm wor a Maur Wailen nasi tu melnum a arpm warkip. Wa kil kwaopm akal kupm laron yangkipm pa ekg akwi tu melnum a ark wan tipmning pa ye kulhor hen. Wa la nasi tu mla ur a ikg paitnen pa wa tu ikg nungkwat ari kweiur kweiur. Wa kupm nar akal kwan kalkut a tu ye a wleket a tu ukwen pa ekg al tu arpm kulkula wor. ");
INSERT INTO uri_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Wa laron nasi tu wrong kinkpman pa tolpa wring ti pa, wring a Wailen akal rein aklinjen.” ");
INSERT INTO uri_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kil klein plaln pa wa kil wale wurkapm pa uk kai melnum a ikghlen wurkapm pa, wa kil eln nar arpm. Ari tu wrong kinkpman a arpm kahor wan pa, tu ikghnentel titnongket. ");
INSERT INTO uri_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yatom kil wa la nasen la tolpa, “Yangkipm wurkapm a Maur Wailen wet kipm atning a kupm klein kil pa, apm paln ek arke tike.” ");
INSERT INTO uri_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tu kporn yangkipm tolpa yangkipm a kil la pa wor, wa tu wreitn paitn ekg atning yangkipm wor a paln kai ek alkilen pa. Wa tu la nasi tita la tolpa, “Plpa warim kpman a Josep!” ");
INSERT INTO uri_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ari Jisas la nasen la tolpa, “Al kipm wi yangkipm kla a tu la tolpa, ‘Kupm melnum a ntekg hi numpet pa, tolpa ti kupm ntekg kupm alkupm ti paln wor hep pen.’ Kipm wakrongen ekg al kupm ntekg kuina ur atn ha alkupmen ti yat, tukol a pike kipm atning a kupm ntekg atn kai Kaperneam ai.” ");
INSERT INTO uri_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Wa kil wa la tolpa, “Kupm la nasepm aklahle wrijen, tu melnum ur ake ntie ekg atning nungkulkg yangkipm a melnum ek wripm ur atn ha alkilen pa. ");
INSERT INTO uri_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tukol pike hep ak ai Ilaija kil arpm, ak wang pa hu ake wei atn tol wring wraur mit wompel, yatom wa wang nikg wail palnten hor ha knokg a Israel pa. Yatom ak wang pa tu kin karpikg wailet ark kai Israel pa. Pake kupm la nasepm aklahle wrijen, ");
INSERT INTO uri_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","la tolpa Ilaija ake pike Maur Wailen kwa kai ekg akal kil aklin tu kin karpikg a arpm Israel, ha yiprokg alkil pa, kalpm. Kil pike kwa kai ekg kin karpikg wrij ur kai Sarepat kai ha knokg manet ur a Saiton ai. ");
INSERT INTO uri_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Wa tukol tu melnum wailet a Israel pa tu wi numpet a hi kark ak wang a Ilaija kil atn melnum ek wripm ti, ake wrij ur alntuen a arpm ha alkil pa paln wor pa, kalpm. Naman, melnum wrij ur hute kai ha manet ur a Siria ai pa paln wor.” ");
INSERT INTO uri_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tu wrongwailet a ark kahor wan a tu atning yangkipm a Maur Wailen atne pa, tu atning yangkipm a Jisas la tolpa yatom, tu ipma wakget paitn wrijen. ");
INSERT INTO uri_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Yatom tu wreitn tolti rkol wampel Jisas pa ye kahor hen a ha wail pa. Ha wail pa tu kat ark wrik krongkwangken ur, wa tu rkol wampel talpul eln kinar tolpa yewel kinar tipmning. Tu yewel kinar akal pilntel eln kinar tipmning watin ari kalpm, ");
INSERT INTO uri_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","kil nuhurnten tolti, kil ngkom hor kuin a tu wrongwailet pa apm kai ase. ");
INSERT INTO uri_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yatom kil kinar Kaperneam, ha wail ur a ha knokg a Kalili. Ak wang a arpm ekg yapm pa kil katen kwap a ro tukgunakg lngkep a tu. ");
INSERT INTO uri_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tu wreitn paitn itnen yangkipm a kil rowen tukgunakg lngkep pa, ekg nte, yangkipm a kil laronten pa kil laron namponen titnongket. ");
INSERT INTO uri_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Melnum ur a maur paitn arpme pa kil apm arpm kahor wan a tu atning yangkipm a Maur Wailen atne pa. Yatom kil wlakil yikaktnen ");
INSERT INTO uri_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","la tolpa, “Ei, Jisas a Nasaret! Kitn akal ntekg kuina ur kul ekg men ti? Kitn kul akal ntekg men ti kai paitn aki? Kupm arieitn pa, kitn pa melnum wri wor a Maur Wailen.” ");
INSERT INTO uri_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ari Jisas kil kle maur paitn pa la tolpa, “Hmpri ek akitn pa, hor kai tukulein melnum pa!” Yatom maur paitn halik melnum pa eln kai ngko arpm kai kuin a tu ai, wa wreitn hor tukuleinjel, wa melnum pa ake wa kil wi paitn ur. ");
INSERT INTO uri_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tu wrongwailet tu wreitn paitn la nasi tita la tolpa, “Kil pa la yangkipm kuina tolpa? Kil pa kil melnum a nang itne ntie titnongket ekg la tu maur paitn pa kulhor kai tukulein pake?” ");
INSERT INTO uri_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yatom tu ye yangkipm a la kiti kweiur kweiur wrongwailet a kil ntekg pa ye kai hor ha wrongwailet a ark yampingken pa. ");
INSERT INTO uri_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas kil nuhurn wan a tu atning yangkipm a Maur Wailen atne pa, wa kil kai wan a Saimon. Wa man yalmpikg a Saimon pa kil numpet num wakget wail paitn, yatom tu ropontel ekg kil akal aklinjel. ");
INSERT INTO uri_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yatom kil kai atn yampingken wrik a man pa, yatom kil la titnongket kwan numpet pa tukuleinjel, yatom numpet pa kai plaln. Wa kil wreitn pirpiren ntekg ekpma kweiur kweiur pa ekg tu pa. ");
INSERT INTO uri_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Takgni kai kinar tmpal ti pa, tu wrong kinkpman tu ye tu a wi numpet wrongwailet pa ye kul ekg Jisas. Yatom kil eln wam pa hel tu melnum a numpet pa wrij wrij, om ntekg numpet a tu pa paln wor. ");
INSERT INTO uri_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Wa maur paitn wailet, tu hor kai tukulein tu wrong kinkpman wailet pa, wa tu wlakil tolpa, “Kitn pa Warim Kpman a Maur Wailen!” Ari Jisas klewen loken la tolpa ake akal tu ekla. Ekg nte, tu ari la tolpa kil pa Krais. ");
INSERT INTO uri_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Takgni pa no rkapen pa, Jisas kil wreitn nuhurn ha pa, wa kil kai wrik hampen ur pa. Tu wailet ripa nel korel hor pa kai, tolpa kai hantilel kai wrik a kil kai arpme pa. Yatom tu akal lokel, ekg ake al kil nuhurnten. ");
INSERT INTO uri_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ari kil la nasen la tolpa, “Kupm akal laron yangkipm wor a la ekg Kingdom a Maur Wailen hor ha wail tiur ai yat. Ekg nte, Maur Wailen apm kwaopm nar ekg akal akwap a tolpake.” ");
INSERT INTO uri_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kil la nasen tolpa plaln, kil laron yangkipm a Maur Wailen pa tolpa kai atn wan a tu atning yangkipm a Maur Wailen atne hor ha knokg a Jutia. ");
INSERT INTO uri_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ak wang ur pa, Jisas kil atn hu hmeij yampingken Kenesaret pa, wa tu wrongwailet paitn nel kul kai yeningkentel akal atning yangkipm a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kil ari nim hu hmeij wekg ur pa ark kai hu hmeij arkikg pa. Wa tu melnum a ak hapm mumu wi yul pa nuhurn nim hu hmeij pa ark, tu kinar klak hapm mumu pa atn. ");
INSERT INTO uri_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yatom Jisas kil kaino arpm nim hu hmeij ur pa, pa nim hu hmeij a Saimon, wa kil la nasi Saimon pa la tolpa, “Kitn wi nim hu hmeij ti ik wiopm ye kai waitketn ketn!” Yatom kil arpm nim hu hmeij pa arpm, om kil ro tukgunakg lngkep a tu wrong kinkpman wailet a kul atn pa. ");
INSERT INTO uri_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kil rowen tukgunakg lngkep a tu pa plaln pa, kil la nasi Saimon pa la tolpa, “Kitn nti tu alkitnen pa wi nim hu hmeij ti kai irk kai hu hmeij kuin kapmet ai, yatom kipm piln hapm mumu pa eln kinar hu hmeij pa ekg ik wi yul pa.” ");
INSERT INTO uri_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ari Saimon pa akalmpe la tolpa, “Melnum Wailen, men wet aken kwap pa ak mning ai kulngkul apm tike, ake men wi yul ur. Ari kitn pa la tolpa ti, kupm al piln pa.” ");
INSERT INTO uri_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tu lekg hapm mumu pa eln kinar, ari tu ak wi yul wailet paitn, yampingken ekg hapm mumu akal nungkwaten. ");
INSERT INTO uri_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tolpa yatom tu ak wam pa kwe tu tiur alntu a ark kai nim hu hmeij ur pa ekg tu kul aklinjen. Tu kul tolti, tu wailet wi yul pa alupm kai nim hu hmeij wekg pa notuln waiwai, ak kalkutel nim hu hmeij wekg pa ekg akal eln kinar hu knokg. ");
INSERT INTO uri_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita kil ari pa, kil kpor klko lein Jisas pa, wa kil la tolpa, “Wailen kitn kai tukuleinjopm, kupm ti melnum a ntekg paitnpaitn!” ");
INSERT INTO uri_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kil la tolpa, ekg nte kil pa namponen tu tiur alkilen pa, tu wreitn paitn ekg ari yul wailet paitn a wet tu wi pa. ");
INSERT INTO uri_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Wa Jems ekg Jon, warim kpman wekg a Sepeti, tuwekg akwap wrij namponen Saimon pa, tuwekg wa wreitn paitn ekg pa yat. Ari Jisas la nasi Saimon pa la tolpa, “Ampur kitn kark. Ak wang ti kai pa kitn hi wi tu melnum tol a kitn wi yul pa.” ");
INSERT INTO uri_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yatom tu wi nim hu hmeij pa ye kai atn kai nimilpm ai, namponen kweiur kweiur wrongwailet pa elntatn pa plaln pa, tu kai katnun Jisas. ");
INSERT INTO uri_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ak wang a Jisas arpm ha wail ur pa, melnum ur a hi kark alel paitn pa kil kul ekg Jisas. Ak wang a kil ariel pa, kil kpor klko lein eln tukgunakg kinar knokg kai won a Jisas pa, om kil ropontel la tolpa, “Melnum Wailen, kitn wakrong pa, kitn ntekg numpwam akupm kil paln wri wor!” ");
INSERT INTO uri_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ari Jisas pa akalmpe kai melnum pa la tolpa, “Kupm wakrong pa.” Yatom kil eln wam pa kai hel melnum pa, wa kil la tolpa, “Kitn paln wri wor om!” Kil la tolpa, yatom hi kark pa kark kai tukulein melnum pa aktutu tolti. ");
INSERT INTO uri_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yatom Jisas uk yangkipm titnongket kai melnum pa la tolpa, “Ampur kitn la nasi mla ur. Kitn kai om, plan num alkitnen pa kai melnum ipma krakgen a Maur Wailen pa ri, ekg al kil al wor uk Maur Wailen pa, tol yangkipm titnongket a Moses la pa. Ekg plan tu wrongwailet ekg tu ari tolpa, kitn apm paln wor ase.” ");
INSERT INTO uri_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ari kalpm, yangkipm a la Jisas pa apm kai hompen hor tu wrongwailet atning ase. Yatom tu wrong kinkpman wailet paitn nel kul akal atning yangkipm a kil pa, wa tu akal kil kwan numpet alntuen pa yat. ");
INSERT INTO uri_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pake wang tiur pa Jisas kai wrik kalpmel ur a ake melnum ur arpme, ekg kil ropon Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ak wang ur a Jisas ro tukgunakg lngkep a tu wrong kinkpman pa, tu Parasi, wa tu melnum a arpmen yangkipm yiprokgen a Maur Wailen pa, tu ark yat. Tu wli pa wli pa kul, ha ha wail Jerusalem, wa ha wrongwailet a ha knokg Kalili a ha knokg Jutia pa. Maur Wailen ukwel titnongket, yatom kil ntekg tu melnum numpet pa paln wor, kil ak kwap tolpa atn pa, ");
INSERT INTO uri_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","tu yipo melnum ur a nepm wam mowe pa ye kul, yatom tu kor ya akal wiyel ye kahor wan ekg Jisas. ");
INSERT INTO uri_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ake ya ur ntie ekg al tu ye melnum pa ye kahor wan pa, ekg nte, tu wrongwailet paitn ak hmpri ya pa. Tolpa yatom tu kat melnum pa ye kaino wan kmpo kwa pa. Yatom tu kwaten wutneij tiur pa plaln, lekg melnum pa eln kinar arpm won a Jisas pa kai kuin a tu wrongwailet. ");
INSERT INTO uri_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisas ari a tu ukpma tolpa, yatom kil la tolpa, “Melnum wor alkupmen, paitnpaitn akitn apm kupm kwan ase.” ");
INSERT INTO uri_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tu Parasi, wa tu melnum a arpmen yangkipm yiprokgen a Maur Wailen pa, tu atning yangkipm pa, tu akwonalmpen wailet la tolpa, “Kil pa melnum tolhai, yatom kil akal wi wrik a Maur Wailen pa? Melnum ur ake ntie ekg kwan paitnpaitn pa. Maur Wailen wrij hute pa kil ntie pake.” ");
INSERT INTO uri_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ari Jisas pa kil apm ari nikgwalpm kuina ur a tu akwonalmpen pa ase, yatom kil roponten la tolpa, “Wa kipm akwonalmpen nikgwalpm tolpa ekg nte? ");
INSERT INTO uri_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yangkipm hai wor, ntie ekg al la nasi melnum numpet ti tolpa, paitnpaitn alkil pa apm kupm kwan ase, aki al la nasel tolpa, kil wreitn wi wrik pa ngkom kai? ");
INSERT INTO uri_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pake al kupm plantepm ekg kipm ari tolpa, Warim Kpman a Melnum pa, kil ntie titnongket atn knokg ti ekg kwan paitnpaitn.” Yatom kil la nasi melnum a nepm wam mowe pa la tolpa, “Kupm la naseitn tolpa kitn wreitn kit wrik alkitnen ti om ye kai wan alkitnen ai!” ");
INSERT INTO uri_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yatom aktutu tolti kil wreitn atn kai ikg a tu wrongwailet pa, wa kil kat wrik alkilen pa. Wa kil kat nang a Maur Wailen pa itna wampel tolti kai wan alkilen pa. ");
INSERT INTO uri_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tu wrongwailet tu wreitn paitn, wa kat nang a Maur Wailen. Wa tu kark paitn wrijen, yatom tu la tolpa, “Wet ti mento ari kweiur kweiur titnongket manet a pike ake mento ari hep pa.” ");
INSERT INTO uri_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kanukg pa Jisas kil ngkom kai pa, kil ari melnum ur a wi takis marpm kai tu pa, nang akil pa Lipai. Kil arpm wan a kil wi takis marpm kai tu pa. Yatom Jisas la nasel la tolpa, “Kitn kul kutnuntopm!” ");
INSERT INTO uri_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yatom kil wreitn nuhurn kweiur kweiur wrongwailet alkilen pa atn pa, wa kil kai katnuntel. ");
INSERT INTO uri_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Yatom Lipai kil ntekg ekpma wail ekg Jisas atn wan alkilen pa, yatom tu wrongwailet paitn a wi takis marpm kai tu pa, wa tu tiur ai, nel kul ntien al ekpma pa. ");
INSERT INTO uri_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tu Parasi, wa tu melnum a arpmen yangkipm yiprokgen a Maur Wailen pa, tiur alntuen pa apm tu alntu Parasi pake. Tu ekla wailet kai tu disaipel a Jisas pa la tolpa, “Wa kipm al hu a ekpma pa nti tu melnum a wi takis marpm kai tu pa, wa namponen tu melnum a ntekg paitnpaitn tiur pa ekg nte?” ");
INSERT INTO uri_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ari Jisas akalmpenten la tolpa, “Melnum a wor pa, kil ake kai ekg melnum a ntekg hi numpet pa, pa tu melnum a numpet tolti. ");
INSERT INTO uri_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Pake kupm ake kul ekg kwe tu melnum nipet wor pa, kupm kul ekg kwe tu melnum a ntekg paitnpaitn pa ekg tu pleln ipma.” ");
INSERT INTO uri_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Yatom tu melnum tiur pa la kai Jisas pa la tolpa, “Tu disaipel a Jon pa, aklei wang tu kalpm ekpma ekg uk wang Maur Wailen, wa tu disaipel a Parasi pa yat. Pake tu alkitnen pa wa al hu a ekpma tolpa kai.” ");
INSERT INTO uri_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ari Jisas akalmpenten la tolpa, “Kipm ti ntie ekg kalpm ekpma ak wang a melnum a wi kin ye pa ak wang a kil ntiepm arpm pake aki? ");
INSERT INTO uri_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ak wang ur hi wa tu wiyel ye kai tukulein pa, tu pa hi ipma kalkut uk wang ekg ake al ekpma pa ark pake.” ");
INSERT INTO uri_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wa kil wa la nasen yangkipm kla kil tolpa, “Mento ur ake al kwat hapm mahin a nowe pa, yatom wa kai kut arpme hapm nungkor a rekel pa. Tol mento ntekg tolpa pa, al ak ro hapm mahin pa. Hapm wompel mahin pa al wa ari ak ro hapm nungkor pa. ");
INSERT INTO uri_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Apm wa tolpake, mento ur ake akal alung hu wain weten pa nar meme palk peset pa, kalpm. Tol mento ntekg tolpa pa, al wa ak ro meme palk pa rekel om hu wain pa suruij eln kinar knokg. Wa meme palk pa kai paitn. ");
INSERT INTO uri_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kalpm, hu wain peset pa apm alupm nar meme palk weten. ");
INSERT INTO uri_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Melnum a al hu wain peset pa al nokgij wor hangken hu wain weten. Tu la tolpa, hu wain peset pa wor, hu wain weten pa paitn.” ");
INSERT INTO uri_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ak wang wrij ur a tu arpm ekg yapm pa, Jisas nti tu disaipel alkilen pa ngkom hor wring wit kuin pa. Wa tu hpar wit ek pa rahin al itna wampel tolpa kai. ");
INSERT INTO uri_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Yatom tu tiur a tu Parasi pa tu ari pa, yatom tu roponten la tolpa, “Wa kipm kpor yangkipm titnongket a la tolpa, ake ntie ekg al mento ak kwap ak wang a arpm ekg yapm pa ekg nte?” ");
INSERT INTO uri_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ari Jisas akalmpe tolpa, “Kipm ari pa kuina ur a pike Teipit nti tu alkil pa ntekg ak wang a tu nikgten pa. ");
INSERT INTO uri_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kil kai kahor yipmingki wonen a wan yalming hapm a Maur Wailen pa, yatom kil wi nak tngklak a pike tu al wor uk Maur Wailen pa, yatom kil al, wa kil uk tiur kai tu melnum alkil pa al. Ti yangkipm titnongket ti pa la tolpa, hi tu melnum ipma krakgen tolti al nak tngklak a al wor uk Maur Wailen pake.” ");
INSERT INTO uri_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wa Jisas wa la nasen la tolpa, “Warim Kpman a Melnum pa, atn hep ikghlen wang a arpm ekg yapm pa.” ");
INSERT INTO uri_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Wang ur ak wang a arpm ekg yapm pa, Jisas kil kahor wan a tu atning yangkipm a Maur Wailen atne pa, yatom kil ro tukgunakg lngkep a tu wrong kinkpman ekg yangkipm a Maur Wailen. Wa melnum ur a wam wien mowe tupmungkul kalpmel pa kil wa arpm kahor wan pa atning yangkipm pa arpm. ");
INSERT INTO uri_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pake tu Parasi a tu melnum a arpmen yangkipm yiprokgen a Maur Wailen pa, tu kor ya akal tu wi Jisas pa hor ya a tolhai, ekg akal tu wiyel ye kai atn yangkipm pa, tolpa yatom tu ikgarpmel worwor akal tu ari a kil ntekg melnum numpet ur paln wor ak wang a arpm ekg yapm pa, aki kalpm e. ");
INSERT INTO uri_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pake Jisas pa apm ari nikgwalpm kuina ur a tu akwonalmpen pa, yatom kil la nasi melnum a wam mowe tupmungkul kalpmel pa la tolpa, “Kitn wreitn itn kwa.”, yatom kil wreitn atn kwa pa. ");
INSERT INTO uri_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yatom Jisas la nasen la tolpa, “Kupm akal ropontepm la tolpa, ti yangkipm titnongket alpmenen ti la naso tolhai, al mento katnun tolhai ak wang a arpm ekg yapm pa? Al mento ntekg wor ekg melnum ur aki, ntekg paitn ekg melnum ur e? Akal aklin melnum ekg kil arpm wor, aki ntekg kil paitn e?” ");
INSERT INTO uri_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kil atn ari tu wrongwailet pa plaln, wa kil la nasi melnum pa la tolpa, “Hntra wam alkitnen pa!” Kil atning tolpa, kil hntra wam alkilen pa, yatom wam kil a mo pa apm paln wor ase. ");
INSERT INTO uri_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pake nikgwalpm a tu Parasi a tu melnum a arpmen yangkipm yiprokgen a Maur Wailen pa wakget paitn ai, yatom nel kor la kai kuin a tu alntu pa la tolpa, al tu ntekg kuina ur kai Jisas pa. ");
INSERT INTO uri_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","13","Ak wang wrij ur pa, Jisas kaino ropon Maur Wailen kaino wrik nimli ur pa, yatom ak mning wrij pa, kil ropon Maur Wailen tolpa arpm, wa kang pa, kil kwe tu disaipel alkilen pa kul. Yatom kil akrkahan wampwam yikakwomwekg (12), yatom kil kwewen la tolpa, tu melnum yangkipm kuinen alkilen. ");
INSERT INTO uri_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon, Jisas kil alil nangkel tolpa Pita, wasok alkil Antru, Jems, Jon, Pilip, Partolomyu, ");
INSERT INTO uri_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, Jems, warim kpman a Alpius, namponen Saimon, melnum ur a tu Selot. ");
INSERT INTO uri_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jutas, warim kpman a Jems, wa Jutas Iskariot, melnum a hi wa eln Jisas kai wam a tu wrongmnto. ");
INSERT INTO uri_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisas nti tu melnum yangkipm kuinen alkilen pa nel hakaino nimli pa nar atn wrik hpok pa, wa tu disaipel wrongwailet paitn alkilen pa tu apm ark ase, wa namponen tu wrong kinkpman wailet a ha wail Jerusalem, wa hor ha knokg Jutia, wa namponen ha knokg a ark hunokg yampingken ha wail Tair wa ha wail Saiton. ");
INSERT INTO uri_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tu kul ekg akal atning yangkipm alkilen pa, ekg kil ntekg numpet a tu pa paln wor. Tu melnum tiur a maur paitn arpmen pa, Jisas kwan tukuleinjen, yatom tu paln wor. ");
INSERT INTO uri_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wa tu wrong kinkpman pa akal eln wam helel, ekg nte, titnongket a kil pa ntie ekg ntekg tu wrongwailet pa paln wor. ");
INSERT INTO uri_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas ari tu disaipel alkilen atn pa om kil la tolpa, “Kipm melnum a ark warkip pa, kipm pa wor pake, kipm utopen om! Kingdom a Maur Wailen pa apm akipm pake. ");
INSERT INTO uri_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kipm melnum a nikgtepm ak wang ti pa, kipm pa wor pake, kipm utopen om! Kipm hi arpm ntie. Wa kipm melnum a hakg ak wang ti pa, kipm pa wor pake, kipm utopen om! Kipm hi utopen paitn. ");
INSERT INTO uri_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Tu akal ntekgepm paitn pa, pa kipm irpm utopen tolti. Kipm melnum a tu arpm ekg paitnjepm, kwantepm, akepm nokg, wa ukwepm nang paitn, ekg nte, kipm pa melnum a katnun Warim Kpman a Melnum pa, kipm pa wor pake, ti kipm utopen om! ");
INSERT INTO uri_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kipm utopen ak wang pa, wa kipm tpra tpra utopen paitn tolti, ekg nte, kweiur kweiur wailet worwor pa Maur Wailen elntepm atn kai ha wor alkilen ai. Tu mamikgmamin manjan alntuen apm pike ntekg paitnel tu melnum ek wripm a Maur Wailen pa tolpa yat pake.” ");
INSERT INTO uri_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Pake rein, kipm melnum a arpm ntie ak wang ti kipm hi wa wi paitn. Ekg nte, kweiur kweiur worwor a kipm akal wi pa, apm kipm wi ase. ");
INSERT INTO uri_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Wa rein kipm melnum a ark wor al nikgwor ak wang ti, pa kipm hi nikgtepm. Wa rein ekg kipm melnum a arpm utopen utop ak hino ak wang ti, pa kipm hi hakg rein paitn. ");
INSERT INTO uri_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Rein kipm melnum a tu kat nang alkipmen pa, pa kipm hi wi paitn, ekg nte, tu yantin maminen wror wror alkipmen pa, apm pike kat nang a tu melnum ek wripm a akplain tolpa yat pake.” ");
INSERT INTO uri_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jisas kil wa la tolpa, “Pake kupm la nasi kipm melnum a atning yangkipm a kupm la pa, kipm al wakrongen tu wrongmnto alkipmen pa. Kipm al ntekg wor kai ekg tu a ipma paitn ekg kipm pa. ");
INSERT INTO uri_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kipm ropon Maur Wailen ekg kil ukwor aklin tu melnum a ropon Maur Wailen ekg kil ntekg paitn ekg kipm pa. Wa ropon Maur Wailen tolpa kil aklin tu melnum a arpm ekg paitnjepm pa yat. ");
INSERT INTO uri_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tol melnum ur ereitn kai tangkokg wompel pa, wa pleln tangkokg wompel pa ekg wa kil ereitn. Aki tol melnum ur nir hapm wakget a kitn nowe ekg kupuk pa, wa kitn wa nir hapm ur a kitn nowe ti wa ukwel, ampur wa lawen. ");
INSERT INTO uri_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tol mla ur ak ek la roponteitn ekg kitn ukwel kweiur kweiur pa, kitn ukwel tolti. Wa mla ur wi kweiur kweiur akitn ti ye kai pa, ampur wa kai ekg wa wi ye kul, yaper. ");
INSERT INTO uri_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kipm wakrongen akal tu mla ur aktepm tolhai pa, pa kipm ti akten tolpa hep. ");
INSERT INTO uri_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Tol kipm wakrongen tu mla ur a wakrongentepm tolti pa, pa al Maur Wailen kporntepm yangkipm tolhai? Ti tu melnum a ntekg paitnpaitn pa apm wa wakrongen tu melnum a wakrongenten tolpa yat pake. ");
INSERT INTO uri_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Wa tol kipm ntekg wor ekg mla ur a ntekg wor ekg kipm pa, pa al Maur Wailen kporntepm yangkipm tolhai? Ti tu a ntekg paitnpaitn pa, apm wa ak tolpa yat pake. ");
INSERT INTO uri_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Wa tol kipm uk kweiur kweiur alkipmen pa kai mla ur akipm akwonalmpen tolpa hi wa tu akalmpentepm pa, pa al Maur Wailen kporntepm yangkipm tolhai? Ti tu melnum a ntekg paitnpaitn pa apm wa ak tolpa yat pake. Tu uk kloken mla ur a tu ari tolpa hi wa tu akalmpenten kiti kiti tolpake. ");
INSERT INTO uri_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pake kipm al wakrongen tu wrongmnto alkipm pa, wa ntekgen wor, wa ukwen kweiur kweiur pa tolti, ampur wa kipm kwe. Ekg hi wa kipm wi kweiur kweiur wailet worwor, wa kipm plan kipm alkipm tol kipm warim a Maur Wailen a atn hep hangken kweiur kweiur wrongwailet. Ekg nte, kil pa melnum a ukpma wor tu melnum a ake ukwel wor, wa tu a ntekg paitnpaitn. ");
INSERT INTO uri_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kipm rein tu wrongwailet tol Maur Wailen, Yan alkipmen, rein kipm wrongwailet pa.” ");
INSERT INTO uri_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Wa Jisas kil wa la tolpa, “Ampur kipm ari klon melnum ur, pa hi wa Maur Wailen kil ari klon kipm pa yat. Ampur eln wam itna melnum ur kil ntekg paitn pa, pa hi wa Maur Wailen wa eln wam itna kipm ti yat. Wa kipm pa kwan paitnpaitn a mla ur ekg hi wa Maur Wailen wa kwan paitnpaitn alkipmen ti yat. ");
INSERT INTO uri_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kipm uk pa, kipm wi. Hi wa kipm wi nmong wail, wutnampen klin notuln waiwai hmpei aken. Kipm alupm nmong tolhai ukwel pa, hi wa Maur Wailen akalmpentepm nmong tolpake.” ");
INSERT INTO uri_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Wa Jisas kil wa la yangkipm kla ur tolpa, “Ntie melnum ikg paitnen ur plan ya melnum ikg paitnen ur pake? Pa ake ntie, tuwekg yaten ngko eln kinar yilkgim pa. ");
INSERT INTO uri_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Melnum a wi arie pa ake atn hangken melnum alkil a rowel tukgunakg lngkep pa. Kil wi arie pa plaln pa, kil hi paln tukol melnum alkil a rowel tukgunakg lngkep pa. ");
INSERT INTO uri_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ntekg tolhai yatom kitn ari yipik waitketn a hel kai ikg a wasok aki wailen ur alkitnen pa, pake ake wa kitn ari yo wompel wail a hel kai ikg alkitnen ti? ");
INSERT INTO uri_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ntekg tolhai yatom kitn kai la nasi kil pa tolpa, ‘Wailen, itn ekg kupm kipieitn yipik ur pa tukuleinjeitn ikg pa ri’. Pake ake kitn ari yo wompel wail a hel kai ikg alkitnen ti? Kitn melnum a akplainel plan ak num henen ti tolti. Kitn wi yo wompel wail a hel kai ikg alkitnen pa hep, yatom ikg akitn pa wor, ekg al kitn ak ari yipik a hel kai ikg a wailen alkitnen pa kipiel tukuleinjel.” ");
INSERT INTO uri_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Wa Jisas kil la tolpa, “Yo wor pa ake al ngko ek paitn pa, wa yo paitn pa ake al ngko ek wor pa. ");
INSERT INTO uri_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yo wrij wrij pa apm ari kai yo ek alkil a ngko pake. Mento ake al nel yo fik ek pa kai yo hngkem, aki nel hmpei wain ek wor pa kai hmpei weipmun pa. ");
INSERT INTO uri_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Apm tolpake, melnum a kil alupm nikgwalpm arie worwor pa, ekla a kil pa paln kulhor kai wor. Wa melnum a kil alupm nikgwalpm arie paitn pa, ekla a kil pa paln kai paitn. Ekla ur a paln kai ek a melnum pa, pa apm plan tukol nikgwalpm alkilen pa apm tolpake.” ");
INSERT INTO uri_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jisas kil wa la tolpa, “Ntekg tolhai yatom, kipm kweopm tolpa, ‘Wailen, Wailen’, pake ake kipm ntekg komkiti kuina ur a kupm la nasepm pa? ");
INSERT INTO uri_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Pa kupm plantepm, melnum a kul katnun kupm ti, yatom atning katnun komkiti yangkipm akupm pa, kil pa melnum tolhai. ");
INSERT INTO uri_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kil pa tol melnum a ntekg wan. Kil ak yilkgim pa watin, yatom uwen hong pa atn wrik weijet. Kop pa u nar ak nel wan pa, ari ake wa or, ekg nte, wan pa pike kil ntekg ariworwor. ");
INSERT INTO uri_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pake melnum a kil atning yangkipm akupm pa, ari ake wa kil katnun komkiti pa, kil pa tol melnum a ntekg wan, yatom ak yilkgim warkip, uwen hong prpar paitn. Kop u nar ak nel wan pa, apm or kai parpm ha paitn ase.” ");
INSERT INTO uri_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas la yangkipmek kweiur kweiur pa nasi tu wrong kinkpman pa plaln pa, kil kai Kaperneam. ");
INSERT INTO uri_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kai ha pa, melnum tukgunakgen ur a ikghlen tu melnum kmel wampomit (100) a almpwrong pa arpm, pake melnum akwapel ur alkil pa numpet paitn ha, yampingken ekg kil akal mo. Melnum pa, melnum tukgunakgen alkil pa wakrongentel paitn. ");
INSERT INTO uri_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kil atning a Jisas ak kwap atn Kaperneam ti, yatom kil kwa tu melnum wailen tiur a Juta pa, tu kai ropontel ekg kil kul kwan numpet a melnum akwapel alkilen. ");
INSERT INTO uri_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tu kai ekg Jisas pa, yatom la titnongket la tolpa, “Melnum pa melnum wor alpmenen, tolpa ti kitn kai iklinjel ekg ntekg melnum akwapel alkilen pa paln wor pen. ");
INSERT INTO uri_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ekg nte, kil ukpma wor men Juta ti, wa kil pike aklinjo ntekgto wan a men atning yangkipm a Maur Wailen atne pa.” ");
INSERT INTO uri_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jisas, kil wi wor, yatom kil wreitn ntien kai. Kil kai yampingken wan pa, ari melnum tukgunakgen pa kwa tu yiprokgen alkil pa kahor hen nasi Jisas pa la tolpa, “Wailen, kil ukweitn kwap wail, kil la tolpa kil ti ake melnum wor, ekg kitn kahor wan alkilen ti. ");
INSERT INTO uri_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kil akwonalmpen tolpa, kil ti ake melnum wor ekg kil hor arieitn. Ti kitn itn ti om, la ak ek ti tolti, ekg pa melnum akwapel alkilen pa paln wor. ");
INSERT INTO uri_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kil la tolpa, kil ti pa, wa horhanekg a tu melnum tiur a atn hep, pake kil ti pati, atn hep ikghlen tu melnum a almpwrong. Kil la melnum ur tolpa kil kai pa, kil kai, kil la melnum ur tolpa kil kul pa, kil kul, kil la melnum akwapel alkilen pa la tolpa, kil ntekg kweiur kweiur pa, kil ntekg.” ");
INSERT INTO uri_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisas atning yangkipm a kil la pa, kil wreitn paitn. Kil pleln om la nasi tu wrong kinkpman wailet a katnuntel pa la tolpa, “Ake kupm atning ari melnum ur a kipm Israel pa ukpma titnongket tukol melnum tukgunakgen ripa.” ");
INSERT INTO uri_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yatom tu melnum a wet melnum tukgunakgen alntuen pa kwawen kul pa, nel wa kahor wan pa, yatom tu ari melnum akwapel a melnum tukgunakgen pa apm paln wor ase. ");
INSERT INTO uri_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Atn waitketn pa, Jisas wa wreitn ha pa kai ha wail ur a tu namput la tolpa Nain, namponen tu disaipel alkilen pa, tu wrong kinkpman wailet pa tu wa ntiel kai. ");
INSERT INTO uri_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tu kai tolpa kaingkai, ngko yampingken yipmingki wanyun a ha wail Nain pa, tu ari melnum yipmri ur pa a tu kat ye hor. Melnum a mo pa pati, warim kpman wrij a kin karpikg yek ur. Wa tu wrong kinkpman wailet a ha pa ntiel ye melnum yipmri ripa hor. ");
INSERT INTO uri_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ak wang a Wailen kil ari kin karpikg yek pa tolpa, ipma akil pa ak reinjel paitn. Yatom kil la nasel la tolpa, “Ampur kitn yek hakg.” ");
INSERT INTO uri_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Wa kil kai eln wam hel wrik a tu katel pa, wa tu a katel pa tu nel atn. Om Jisas la nasi melnum yipmri a ha wrik pa la tolpa, “Kmel warimpen, kupm la naseitn tolpa, kitn wreitn om!” ");
INSERT INTO uri_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Melnum yipmri pa wreitn arpm, wa kil ekla, yatom Jisas la nasel la tolpa “Kitn kai ekg man alkitnen pa om”. ");
INSERT INTO uri_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tu wrongwailet tu ari tolpa, tu wreitn kark paitn wrijen, wa tu kat nang a Maur Wailen. Tu la tolpa, “Melnum ek wripm wail a Wailen apm paln atn kuin a men tike. Maur Wailen apm nar ase, akal aklin mento wrong kinkpman alkilen.” ");
INSERT INTO uri_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yatom tu ye yangkipm a Jisas ntekg melnum yipmri pa wreitn pa ye kai nasi tu hor kai ha knokg a Jutia pa, wa ye kai ha knokg a ark yampingken Jutia pa yat. ");
INSERT INTO uri_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Tu disaipel a Jon pa, tu la kitintel kweiur kweiur a Jisas ntekg, yatom Jon kwe melnum wekg pa kulntel, ");
INSERT INTO uri_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","yatom kil kwawen la tolpa, “Kipmekg kai ropon Jisas pa ri, ‘Kitn melnum pike Maur Wailen akal kwa nar ekg akal hi akarmpento apm pake, aki hi wa men arpm nungkwangen melnum ur manet e?’ ” ");
INSERT INTO uri_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tuwekg kai paln ekg Jisas pa om, tuwekg la tolpa, “Jon, Melnum A Kaluk Tu pa, kwao kul ekg akal mentekg roponteitn la tolpa, ‘Kitn melnum a pike Maur Wailen akal kwaweitn nar apm tike, aki hi wa men arpm nungkwangen melnum ur manet e?’ ” ");
INSERT INTO uri_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ak wang pa Jisas ntekg tu melnum wailet a numpet aur aur, melnum wailet a maur paitn arpme, wa tu melnum wailet a ikg paitnen pa paln wor tolpa atn. ");
INSERT INTO uri_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yatom kil akalmpe yangkipm a melnum wekg pa la tolpa, “Wa kai la kiti Jon pa kweiur kweiur a kipmekg atning ari ti, la melnum a ikg paitnen ti paln ikg nungkwat ari kweiur kweiur, nepm paitnen pa wa tu ngkom wor, melnum a hi kark wi pa tu paln wor, nungkulkg parnpo pa tu atning kweiur kweiur, tu melnum a mo hut pa tu wa wreitn ark, wa yangkipm wor a Maur Wailen ti, piln ekg tu melnum a ark warkip. ");
INSERT INTO uri_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Melnum ur a ake uk yirokg kupm ti pa, kil pa wor pake, kil utopen om!” ");
INSERT INTO uri_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Melnum wekg a ye yangkipm a Jon pa kul pa, atning yangkipm a Jisas la plaln pa, om tuwekg wa kai, yatom Jisas kil la kiti Jon pa la nasi tu kinkpman wrongwailet pa la tolpa, “Pike Jon kil piln yangkipm atn wrik kalpmel ur pa, kipm pike kai akal ari kuina ur? Kipm kai akal ari mi a wripm almpe pake? ");
INSERT INTO uri_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kipm pike kai akal ari kuina ur? Melnum a nowe hapm worwor aki? Tu melnum a nowe hapm worwor tolpa pati, tu pa al kipm ari kai wan a tu melnum wail wail a ntie kweiur kweiur worwor ai. ");
INSERT INTO uri_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Aki kipm kai akal ari kuina ur? Kipm kai akal ari melnum ek wripm a Maur Wailen? Ei aklahle, kupm la nasepm la tolpa, melnum ek wripm pa wa hangken melnum ek wripm wrongwailet ai. ");
INSERT INTO uri_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jon pa melnum a pike Maur Wailen la tolpa, ‘Itning, kupm hi wa kwa melnum a ye yangkipm pa ye hep ekg kitn. Melnum pa kil hi wa hep numprampen ya ekg kitn.’ ");
INSERT INTO uri_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kupm la nasepm la tolpa, kai kuin a tu melnum wrongwailet a pike man raku pa, ake melnum wailen ur hangken Jon pa. Pake melnum a wi nang wasok kai Kingdom a Maur Wailen pa, kil pa utopen om, pa kil wailen hangken Jon pake.” ");
INSERT INTO uri_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tu wrong kinkpman namponen tu melnum a wi takis marpm kai tu pa, nel atning yangkipm a Jisas la pa, yatom tu ari la tolpa, ya a Maur Wailen pa nipet wor pake. Tu melnum pa pati, tu pike wi wor yatom Jon kil kaluken. ");
INSERT INTO uri_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pake tu Parasi wa tu melnum a arpmen yangkipm yiprokgen a Maur Wailen pa, nel uk yirokg ya wor a Maur Wailen akten pa. Tu melnum pa pati, tu pike hret yatom ake pike Jon kaluken. ");
INSERT INTO uri_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yatom Jisas la nasen la tolpa, “Kupm akal la kipm melnum ak wang ti kipm melnum tolhai? ");
INSERT INTO uri_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kipm tol tu warim a nel ark ha kuin pa. Om kipm warim tiur pa la nasi tu warim tiur pa la tolpa, ‘Men tplam wampeng ti, pake kipm ake wa plel plel, men ak ek namputen, pake kipm ake hakg rein.’ ");
INSERT INTO uri_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Apm wa tolpa yat pake, Jon, Melnum A Kaluk Tu pa, pike kul, kil uk wang Maur Wailen, ake kil al hu wain a ekpma tol a men ti pa, pake kipm lawel la tolpa maur paitn arpmel. ");
INSERT INTO uri_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Warim Kpman a Melnum pa nar pa, kil al hu wain a ekpma pa, pake wa kipm wa la tolpa, ‘Kipm ari melnum kil! Kil al hu a ekpma pa wailet, kil melnum yiprokgen ur a tu melnum a wi takis marpm kai mento ti, wa tu melnum paitn tiur ai.’ ");
INSERT INTO uri_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kipm apm tolpake kipm nlokgen Jon, wa kipm nlokgen Warim Kpman a Melnum ti. Pake nikgwalpm arie worwor a Maur Wailen pa plan aklahle kai tu melnum a atning katnun pake.” ");
INSERT INTO uri_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Melnum Parasi ur pa, nang alkilen pa Saimon, kil kwe Jisas akal kai ntiel al ekpma, yatom Jisas kai wan a Parasi pa ntiel al ekpma pa arpm. ");
INSERT INTO uri_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kai ha pa, kin wrij ur a ntekg paitnpaitn pa arpm. Kil atning tolpa Jisas nti melnum Parasi pa al ekpma arpm wan alkilen pake. Yatom kil ye weij keimung korkokgen ariwor ur a hu wepmij wor arke pa ye kai kahor. ");
INSERT INTO uri_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yatom kil kul atn yampingken nepm kmpang nimlien a Jisas pa hakg, wa ikghakg pa ungkwan kul nar kaluk nepm kmpang nimlien a Jisas. Yatom kil kule ikghakg pa ak tukgunakg walkg alkilen pa, wa nakron nepm kmpang nimlien a Jisas pa. Plaln pa, kil alung hu wepmij wor pa ak kaluk nepm kmpang nimlien alkilen pa. ");
INSERT INTO uri_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Melnum Parasi a wet kwewel kai al ekpma pa ari tolpa, kil la kai kil alkil pa la tolpa, “Tol melnum ti kil melnum ek wripm a Maur Wailen pa, tol kil ari kin a wamparpmel pa tolpa, kil tolhai, tol kil ari tolpa, kil kin a ntekg paitnpaitn apm pake.” ");
INSERT INTO uri_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ari Jisas kil ari nikgwalpm a Saimon pa ase, yatom kil la nasel la tolpa, “Saimon, kupm akal la naseitn yangkipm ur kil.” Ari wa Saimon ipma wrij la nasel la tolpa, “Wailen, wor pa, la nisopm om.” ");
INSERT INTO uri_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yatom Jisas la nasel yangkipm kla ur pa la tolpa, “Melnum wekg ur pike tuwekg wi kloken kai melnum ur. Ur wi marpm wail, tenari kmel wekg tuwek wampwam (500), wa ur wi marpm wasok, tenari wampomit (50). ");
INSERT INTO uri_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tuwekg piln pa kai plaln pa tuwekg arpm warkip, tuwekg ur ake ntie ekg akalmpe marpm ripa, yatom melnum a ukwen marpm pa reinjen, yatom la nasen la tolpa, ‘Alkil itn ai, ampur kipmekg akalmpe kloken pa!’ Ti mla ur kai kuin a tuwekg pa utopen ukwel wor wailmanten pa?” ");
INSERT INTO uri_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ari wa Saimon akalmpe la tolpa, “Kupm akwonalmpen ari melnum a kil kwan kloken wail a kil wi pake.” Yatom Jisas la tolpa, “Akalmpe a kitn la pa nipet wor pake.” ");
INSERT INTO uri_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yatom kil pleln kai kin pa, wa la kai Saimon pa la tolpa, “Kitn ri kin ti. Kupm hor wan alkitnen ti, ake kitn ak hu ur klakopm nepm kmpang nimlien ti. Pake kin ti kil klakopm ak ikghakg ti, yatom wa kuleopm ak tukgunakg walkg alkilen ti. ");
INSERT INTO uri_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kupm hor wan alkitnen ti ake wa kitn ti ukopm wor nakrontopm, pake kin ti apm nakron nepm kmpang nimlien akupm ti tolpa arpm tike. ");
INSERT INTO uri_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ake kitn numprampen hu yuwa wor ekg alung ak nel tukgunakg akupm ti, pake kin ti alung hu wepmij wor a kil ti ak nel nepm kmpang nimlien akupm ti. ");
INSERT INTO uri_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tolpa ti kupm la naseitn la tolpa, kitn ari kin ti, nikgwalpm a kil pa ark ekg kupm ti wail, pa plan tolpa paitnpaitn wailet alkilen pa apm wet Maur Wailen kwan plaln ase. Mla ur a ake ntekg paitnpaitn wailet yatom Maur Wailen kil kwan pa, nikgwalpm a kil pa ake ark ekg kupm ti wail.” ");
INSERT INTO uri_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yatom Jisas la nasi kin pa tolpa, “Paitnpaitn akitn pa apm kupm kwan ase.” ");
INSERT INTO uri_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ari tu melnum tiur a ntiel al ekpma ark pa la kai tu alntu pa la tolpa, “Melnum tolhai ti, yatom kil ntie titnongket ekg ak kwan paitnpaitn ti?” ");
INSERT INTO uri_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pake Jisas la nasi kin pa la tolpa, “Kitn ukpma Maur Wailen, yatom kil rein aklinjeitn, ti kitn kai om, ampur kitn ipma kalkut.” ");
INSERT INTO uri_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wang aripm ur kai plaln pa, Jisas kil wreitn kai ha wailwail nti ha wasokwasok, piln yangkipm wor ekg Kingdom a Maur Wailen. Tu melnum yangkipm kuinen wampwam yikakwomwekg (12) alkilen pa ntiel atn, ");
INSERT INTO uri_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","wa namponen tu kin tiur a pike kil kwan maur paitn arpme pa wa tu tiur a numpet pa wa paln wor pa, tu pa wa ntiel yat. Nang atu pa, Maria a kai ha wail Maktala, a pike Jisas kwan maur paitn wampomit wampomwekg (7) tukuleinjel pa. ");
INSERT INTO uri_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana, Susana wa tu kin wailet tiur ai. Joana pa kin a Kusa, melnum wailen ur a ikghlen wan a melnum tukgunakgen Herot. Tu kin pa tu uk kweiur kweiur alntuen ti kai ekg aklin Jisas namponen tu melnum akwapel alkilen pa tolpa atn pake. ");
INSERT INTO uri_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tu wrong wailet paitn nel ha pa ha pa kul, yatom Jisas la yangkipm kla ur pa la tolpa, ");
INSERT INTO uri_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Melnum ur pa kil kai halik wit ek kai wring alkilen. Kil halik hor wring pa, yatom tiur pa ngko nar ha ya mlik pa, yatom tu rkgangki, om wel kul al. ");
INSERT INTO uri_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tiur pa ngko nar ha wrik weijet, yatom nip kaino, ari knokg ti tngklak kalnten yatom mo, ekg nte, ake knokg hapet hluluij wor. ");
INSERT INTO uri_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wit ek tiur pa ngko eln nar kai kuin a hmpei hiket pa, nip namponen tita, yatom hmpei hiket pa nip ak hparn. ");
INSERT INTO uri_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Wa tiur pa ngko eln kinar kai wring wurknong knokg wor, yatom nip kaino ngko wailet ase.” Jisas la yangkipm kla pa kai plaln pa, kil wa la yikaktnen la tolpa, “Kipm melnum a nungkulkg itne pa, kipm itning om!” ");
INSERT INTO uri_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tu disaipel a Jisas pa ropontel la tolpa, “Yiprokgen a yangkipm kla ti pa la tolhai?” ");
INSERT INTO uri_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jisas akalmpe la tolpa, “Kweiur kweiur wrongwailet a Kingdom a Maur Wailen pa pike atn hampen. Pake Maur Wailen kil plan kipm alkipm ti tolti ari pake. Pake tu wailet tiur ai pa kupm laron nasen ak yangkipm kla ti tolti, ekg al tu ikghle, pake ake ntie ekg al tu ari pa, wa al tu atning hute, pake ake ntie ekg al tu wi arie worwor.” ");
INSERT INTO uri_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yatom Jisas laron yiprokgen a yangkipm kla a wit ek ti la nasen la tolpa, “Ti kipm itning, yiprokgen a yangkipm kla kil pati la tolpa: Wit ek pati, pa la yangkipm a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wit ek a ngko nar ha ya mlik pa pati, pa la ekg tu a atning yangkipm wor a Maur Wailen, pake Maur Paitn Satan wi yangkipm pa tukuleinjen, ekg ake al tu ukpma Maur Wailen, ekg kil akwien ekg alkilen. ");
INSERT INTO uri_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Wit ek a ngko nar ha knokg weijet pa ake kli ningnakg pa eln kinar knokg pa pati, pa la ekg tu melnum a atning a wi yangkipm a Maur Wailen pa utopen. Pake ake tu wi alupm worwor, tu ukpma atn waitketn tolti. Kweiur kweiur a ak rkolen ekg tu ngko pa, tu apm wa pleln wa kai yawrik. ");
INSERT INTO uri_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wit ek a ngko nar kai mi hiket wonen pati, pa la ekg tu melnum a atning yangkipm a Maur Wailen, atn tolpa kai waitketn, ari kalpm, marpm a kweiur kweiur worwor a ak utopen numpalk namponen kalkuten a atn knokg ti lok yipoen, yatom tu nip kaino harpongket paitn. ");
INSERT INTO uri_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Wa wit ek a ngko nar ha wring wurknong knokg wor nip kaino ngko ek arke wor pati, pa la ekg tu melnum a nikgwalpm nipet wor a atning alupm yangkipm a Maur Wailen atn titnongket ngko wor ek arke.” ");
INSERT INTO uri_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ake melnum ur akal nihil wakg pa, yatom ak kuntuk mang pa ak naren pa, aki eln ark kinar wrik hanekg ti. Kil nihil yatom eln ark kaino kwa, ekg ak helen tu melnum a kahor wan pa. ");
INSERT INTO uri_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kuina ur a ha hampen pa, hi wa ye kul kai ngko wurknong. Wa kuina ur a ak haur pa, hi wa paln wi ye kai ngko wurknong yat. ");
INSERT INTO uri_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kipm itning worwor yangkipm a kupm la pa. Ekg nte, melnum a kil ntie pa, apm Maur Wailen kil wa ukwel ur wa akntie. Wa melnum a kil ake ntie pa, kuina ur a kil akwonalmpen tolpa kil ntie pa, Maur Wailen kil apm kwan kai tukuleinjel.” ");
INSERT INTO uri_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Man namponen tu wasokwasok a Jisas pa kul akal ariel, pake ake ntie ekg tu ariel, ekg nte, tu wrongwailet paitn. ");
INSERT INTO uri_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tolpa yatom melnum ur kahor nasi Jisas pa la tolpa, “Man nti tu wasokwasok alkitnen atn kahor hen ti akal arieitn.” ");
INSERT INTO uri_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ari Jisas akalmpe tu pa la tolpa, “Wor, pake tu wasokwasok a tu mantin alkupmen pa pati, tu a atning katnun yangkipm wor a Maur Wailen.” ");
INSERT INTO uri_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wang ur pa Jisas namponen tu disaipel alkilen pa nel wi nim hu hmeij pa yatom, Jisas la nasen la tolpa, “Pal mento kwat hor ti kai hu hmeij wompel ai.” Yatom tu nel kwat kai. ");
INSERT INTO uri_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tu kwat kai pa, Jisas pa apm hokg ase. Ari wripm wail pa eln ak klaijen hu pa eln kahor nim hu hmeij pa, yampingken ekg akal teipurnten ekg tu akal al hu mo. ");
INSERT INTO uri_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tu disaipel a Jisas pa kai ro ikgyokgel Jisas pa la tolpa, “Melnum Wailen, Melnum Wailen, mento ntekg ekg al kai paitn tike!” Yatom Jisas prpakg wreitn om kle wripm wail a hor pa, wa hu a tupor klaijen eln kahor nim hu hmeij pa, yatom pa kai plaln kalpm tolti, wa hu ti ternget hel om. ");
INSERT INTO uri_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yatom Jisas kil la nasi tu disaipel alkilen pa tolpa, “Kipm ti ukpma aki kalpm e?” Pake tu wreitn paitn wa kark, wa tu la nasi tita la tolpa, “Kil ti melnum a tolhai, yatom kil wa la wripm wail a hu a tupor ti wa kai plaln ti!” ");
INSERT INTO uri_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tu arpm nim hu hmeij pa kwat hor pa kul ha knokg a Kerasa, wa nuhurn ha knokg Kalili pa ark kai wompel ai. ");
INSERT INTO uri_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jisas nuhurn ha nim hu hmeij pa nar, ari melnum ur a maur paitn arpme pa wa ariel. Wang watin kil atn num halk tolti, ake kil arpm knokgel kai ha pa, kil arpm hor yilkgim a tu uwe ekg uwen melnum arpme ti tolti. Melnum pa kil pa apm arpm kaingkai pake. ");
INSERT INTO uri_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kil ari Jisas pa, kil wlakil hakg wail paitn ngko ha nepm kmpang nimlien a kil ti wa la nasel la tolpa, “Jisas, kitn Warim Kpman a Maur Wailen a atn hep hangken kweiur kweiur wrongwailet! Kitn akal ntekg kuina ur ekg kupm ti? Ampur kitn ntekg paitn ekg kupm ti.” ");
INSERT INTO uri_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kil la tolpa, ekg nte, wet Jisas la nasel hep ase la tolpa kil hor kai tukuleinjel. Aklei wang maur paitn pa ntekgel hmithmit, yatom tu arpmentel aklei wang, yatom tu kuten nepm wampel ak hmpei titnongket, pake maur paitn kungku hmpei pa nungkwat tukuleinjel, wa lok melnum a hmithmit pa ye kai tukulein wrik a tu melnum arpme pa. ");
INSERT INTO uri_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisas ropontel la tolpa, “Nang a kitn ti mla?” Kil akalmpe la tolpa, “Nang a kupm pa Wrongwailet.” Yiprokgen a kil la tolpa pati maur paitn wailet pa arpmel arpm pa. ");
INSERT INTO uri_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tu maur paitn pa wlakil la kai Jisas pa la tolpa, “Ampur kwanto eln kinar ha paitn pa.” ");
INSERT INTO uri_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mnto wailet pa nel nihir al tol atn kaino krongkwang pa. Yatom tu maur paitn pa la nasi Jisas pa la tolpa, “La men ti kai kahor tu mnto pa om!” Yatom Jisas la tu maur paitn pa kai kahor tu mnto ripa. ");
INSERT INTO uri_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tu maur paitn kark ha kahor melnum ti hor kai eln kahor mnto. Tu mnto pa nel kark urur ha kaino krongkwang ti kul nar ngko plalnten eln kinar hu hmeij ai, al hu om mo plaln. ");
INSERT INTO uri_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tu melnum a ikghlen mnto pa ari tolpa, yatom tu kark aktutu ye yangkipm pa kai nasi tu melnum kai ha wail ai, wa ha wasokwasok a ark yampingken pa. ");
INSERT INTO uri_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tu wrong kinkpman pa nel kai ari kweiur kweiur a wet paln pa. Pa tu ari melnum a wet maur paitn kark tukuleinjel pa arpm kai nepm kmpang nimlien a Jisas pa, nowe hapm pa arpm. Kil apm paln wor wonrekele ase, yatom tu kark. ");
INSERT INTO uri_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tu melnum tiur a wet atn ari pa tu wa la kiti nasi tu tiur a kul pa, la tolpa maur paitn pa wet wreitn hor kai tukulein melnum pa tolhai. ");
INSERT INTO uri_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yatom tu wrong kinkpman a ha knokg a Kerasa pa ari tolpa, tu kark, yatom tu kwan Jisas pa, la tolpa “Kitn pa pleln kai om.” Yatom Jisas wa tpra eln kahor nim hu hmeij ekg kil akal wa kai om. ");
INSERT INTO uri_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ari melnum a wet Jisas kwan maur paitn tukuleinjel pa ropon Jisas pa la tolpa, “Kupm akal ntieitn kai aki?” Ari Jisas akratoel la tolpa, ");
INSERT INTO uri_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kitn kai ha pa om ekg la nasi tu kweiur kweiur a Maur Wailen ntekg ekg kitn pa.” Melnum pa atning tolpa, kil kai la nasi tu wrong kinkpman a ark ha pa la kiti kuina ur a wet Jisas ntekg kai kil pa. ");
INSERT INTO uri_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tu wrong kinkpman kai hu hmeij wompel pa ark nungkwangen Jisas pa ark. Yatom Jisas wa kul paln, om tu utopen paitn ekg kil kulnten ase. ");
INSERT INTO uri_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Melnum ur a atn tukgunakgen ekg ikghlen wan a atning yangkipm a Maur Wailen atne pa, nang akil pa Jairus. Kil kul ngko ha yampingken nepm kmpang nimlien a Jisas ti, wa ropontel la tolpa tuwekg ekg kai wan akil. ");
INSERT INTO uri_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ekg nte, warim kin tangkij wrij hute alkilen pa apm ikgkiti nikgwalpm tike. Jisas ngkom kai pa tu wrong wailet paitn pa ha pa ha pa kul kai ntiel ak num alm tita ngkom ntiel tolpa kai. ");
INSERT INTO uri_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kin ur a num walmpopm ngko wring wampwam yikakwomwekg (12) pa nti tu pa kai yat. Ari ake wa melnum ur ntie ekg aklinjel, ekg akal kil paln wor. ");
INSERT INTO uri_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kil ro wrong kuin ti ha yirokg pa kai kaino eln wam hel hapm a Jisas pa, yatom num walmpopm a kil a ngko pa kai plaln. ");
INSERT INTO uri_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yatom Jisas ropon tu pa la tolpa, “Mla ur wet eln wam helopm pa?” Ari tu wrong kinkpman pa la tolpa, “Ake tu mla ur eln wam heleitn. Yatom Pita la tolpa, ‘Wailen, ake kitn ari tu wrong kinkpman pa ak talpul tita ak num ak neleitn ti.’ ” ");
INSERT INTO uri_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pake Jisas pa la tolpa, “Melnum ur wet eln wam helopm pa. Ti kupm atningke tolpa titnongket akupm wet aklin melnum pa ase.” ");
INSERT INTO uri_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kin pa apm ari tolpa tu apm ariel ase, yatom kil kwarkwar tolti kai kaino atn ikgek a Jisas pa, om kil kpor klko leinjel. Kai ikg a tu wrongwailet pa kil la yiprokgen a kil eln wam hel Jisas pa, wa numpet a kil pa paln wor ak wang ketn ripa. ");
INSERT INTO uri_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisas la nasel la tolpa, “Yek alkupm, kitn ukpma kupm ti yatom kitn paln wor pake. Kitn kai om! Ampur kitn ipma kalkut.” ");
INSERT INTO uri_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas la tolpa atn, ari melnum ur hakai wan a Jairus ye yangkipm pa kul la nasi yan a warim pa la tolpa, “Kai lok Melnum Wailen pa kil irpm pa om! Warim kin a kitn pa apm mo ase.” ");
INSERT INTO uri_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pake Jisas atning pa yatom kil la kai Jairus, “Ampur kitn ipma kalkut, ukpma tolti, kil pa pal paln wor pa.” ");
INSERT INTO uri_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kil kai paln wan pa, kil lok tu wrongwailet pa atn hen pa, kil la nasi Pita, Jems, Jon namponen manjan a warim kin ripa tolti hute ntiel kahor. ");
INSERT INTO uri_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tu wrong a ark kahor wan pa hakg la ekg warim kin pa ark. Jisas kil la tolpa, “Ampur kipm hakg! Warim ti ake mo, plpa kil hokga pa.” ");
INSERT INTO uri_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tu atning tolpa, tu wa nel akhinowel Jisas pa, ekg nte, warim pa apm wet mo ase. ");
INSERT INTO uri_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pake Jisas kai nampil wam a warim kin ti kwewel, “Warim kin, kitn wreitn om!” ");
INSERT INTO uri_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yatom maur wor alkilen pa wa kulhor yipmri alkil ti tolti, kil wreitn ak wang ketn ripa. Yatom Jisas la nasen la tolpa kor ekpma ur ai ye kul ukwel il om. ");
INSERT INTO uri_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tu manjan alkilen pa wreitn paitn, pake Jisas la nasen la tolpa, “Ampur kipmekg la nasi tu tiur ekg kweiur kweiur a wet paln ti.” ");
INSERT INTO uri_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas kwe tu melnum yangkipm kuinen wampwam yikakwomwekg (12) alkilen pa nel kul atn wrij, yatom kil ukwen titnongket ekg tu ntie ekg kwan maur paitn a ntekg hi numpet a tu melnum pa paln wor. ");
INSERT INTO uri_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Yatom kil kwawen akal tu kai piln yangkipm nasi tu ekg yangkipm wor a la Kingdom a Maur Wailen, wa ntekg numpet a tu melnum a wi numpet pa paln wor. ");
INSERT INTO uri_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kil la nasen la tolpa, “Ampur kipm ye tuk a ak atnen pa, a hapm kok, marpm, ekpma. Wa hapm a kipm nowe pa yat, kipm nowe a arpm num ti hute. Kipm wampwampwrij tolti. ");
INSERT INTO uri_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tu wi wor ekg wan ur akal kipm arke pa, kipm kai yatom irk wrij. Wang ur a kipm akal kai ha ur pa, kipm wreitn hi pa om kai. ");
INSERT INTO uri_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tol tu melnum a ha ur ake wi wor ekg kipm pa, pa kipm kwalkwin nepm hngrapm eln hi pa ekg al tu ari. Pa tol yangkipm ur a ak la nasen la tolpa, pa tu ntekg paitn.” ");
INSERT INTO uri_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tu melnum yangkipm kuinen wampwam yikakwomwekg (12) a Jisas pa tu atning yangkipm a kil la nasen karkurnten plaln pa, tu wreitn nuhurn ha pa kai ha wrongwailet pa, piln yangkipm wor a Maur Wailen pa, wa ak kwan numpet a tu pa paln wor. ");
INSERT INTO uri_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herot, melnum tukgunakgen a ikghlen ha knokg Kalili, kil atning kweiur kweiur wailet a Jisas akwap tolpa, yatom kil akwonalmpen wailet hmit arpm tolti. Ekg nte, tu melnum tiur pa la tolpa, Jon a pike kaluk tu, kil a pike mo, apm wa wreitn arpm akwap apm pake. ");
INSERT INTO uri_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wa tu tiur pa la tolpa, pa kalpm, pa Ilaija pike nar. Wa tu tiur pa la tolpa, plpa melnum ek wripm manet ur a pike mo ak ai pen, ti wa wreitn ha kirkhap pa no. ");
INSERT INTO uri_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Yatom Herot pa la tolpa, “Jon apm pike kupm kwat krongkel mo ase, pake wa mla ur wa arpm ai pen, om kupm atning a kil ntekg kweiur kweiur riai?” Herot kil kor ya ekg akal ari Jisas. ");
INSERT INTO uri_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tu melnum yangkipm kuinen a Jisas pa wa kul la nasel kwap wrongwailet a tu kai ak pa. Yatom Jisas wa wiyen ha pa apm wa nel kai wrik ur a ha yampingken ha ur a kwe la tolpa Petsaita pa, tukulein tu pa akal tu kai ark ak tu alntu tolti. ");
INSERT INTO uri_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pake tu wrong kinkpman wailet pa atning tolpa nel kai wa katnunten om kil wa ukwen wor tolti wa kil wa la nasen yangkipm wor a la kiti Kingdom a Maur Wailen. Wa tu tiur a numpet pa kil ntekg numpet a tu pa paln wor. ");
INSERT INTO uri_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yampingken ekg al takgni pa kinar tmpal ekg al ham pake, tu melnum yangkipm kuinen a Jisas pa kai la nasel la tolpa, “Kwa tu ti kai om, ekg tu kai ha ai pen, wa kai hor plpa, ekg al tu kor ekpma pa ekg al hokg atn!” Ekg nte, ti wrik kalpm. ");
INSERT INTO uri_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ari Jisas wa la nasen la tolpa, “Kipm alkipm ti kor ekpma ur ekg tu il!” Tu melnum yangkipm kuinen akil pa akalmpe tolpa, “Men ti ye nak tngklak wampomit a yul wekg tolti. Ti kitn la tolpa akal men kai armpen ekpma ur ai ekg tu wrongwailet pake?” ");
INSERT INTO uri_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tu kmel pa wailet paitn ai (5,000). Ari Jisas la kai tu disaipel alkilen pa la tolpa, “Ro tu melnum pa irk kmel wekg tuwek wampwam (50), kmel wekg tuwek wampwam (50)!” ");
INSERT INTO uri_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tu disaipel alkilen ntekg tukol a Jisas la pa, yatom la nasen la tolpa tu irk knokg. ");
INSERT INTO uri_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tu ark pa, om Jisas wi nak tngklak wampomit pa a yul wekg pa, ikg kaino ktnong, ukwor Maur Wailen pa plaln, yatom kil kpor uk tu disaipel alkilen pa, ekg tu nampreng uk tu wrong kinkpman pa. ");
INSERT INTO uri_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tu al al, al hipen, om ekpma hmpu hmpu pa ha, om tu wi ye kul alupm hrkwa wail wail wampwam yikakwomwekg (12) pa nowli elntarpm. ");
INSERT INTO uri_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wang wrij ur pa Jisas alkil wrij kai ropon Maur Wailen, yatom tu disaipel alkilen pa wa kai katnuntel. Yatom Jisas roponten la tolpa, “Kipm atning tu wrong kinkpman riai tu kor la tolpa kupm ti kupm mla?” ");
INSERT INTO uri_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tu akalmpe la tolpa, “Tu tiur pa la kiti tolpa kitn Jon, Melnum a pike Kaluk Tu. Wa tiur pa la tolpa kitn Ilaija, wa tu tiur pa la tolpa kitn melnum ek wripm ur a pike mo hep ak ai, om kitn wa wreitn.” ");
INSERT INTO uri_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wa kil roponten la tolpa, “Ti kipm ti? Kipm akwonalmpen tolpa kupm ti pa mla?” Ari Pita, kil akalmpentel la tolpa, “Kitn melnum a Maur Wailen akrkahanteitn ekg akarmpen men wrong kinkpman.” ");
INSERT INTO uri_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yatom Jisas la nasen titnongket la tolpa ampur tu laron kil ti nasi tu mla ur pa. ");
INSERT INTO uri_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yatom kil wa la tolpa, Warim Kpman a Melnum hi wa arki kalkuten wailet, kil hi wa tol melnum wailen wailen wa tu melnum ipma krakgen a Maur Wailen a atn hep, wa tu melnum a arpmen yangkipm yiprokgen a Maur Wailen, hi wa tu kwantel. Kil hi wa tu almpel mo uwen, ak wang wraur pa kil wa wreitn. ");
INSERT INTO uri_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yatom Jisas la kai tu wrongwailet pa la tolpa, “Tol mla ur akal kul katnun kupm ti pa, pa ampur kil akwonalmpen kil alkil pa, kil arki yo kwatingki alkilen pa aklei wang, yatom kul kutnuntopm. ");
INSERT INTO uri_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tol mla ur a ake uk num alkilen pa ekg ak ak kwap akupm ti pa, pa kil hi wa kai paitn. Wa mla ur a nuhurn numpwam alkilen pa ekg ak ak kwap akupm ti pa, pa kil hi wa arpm wor aklei wang. ");
INSERT INTO uri_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tol melnum ur wi kweiur kweiur wailet a knokg ti, yatom ntekg kil melnum ti kai paitn pa, al kweiur kweiur pa aklinjel tolhai? ");
INSERT INTO uri_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tol melnum ur kil numpaitn ekg laron kil alkil tolpa, kil ukpma kupm ti, a yangkipm a kupm piln pa, pa Warim Kpman a Melnum hi wa kil numpaitn ekg laron nang a melnum ripa, ak wang a kil nar namponen titnongket klalen alkilen, a titnongket klalen a Yan namponen titnongket klalen a tu maur akwapel wri wor alntuwekgen. ");
INSERT INTO uri_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kupm la nasepm aklahle, kipm tiur a ark ti, kipm hi ake mo. Kipm hi wa ari Kingdom a Maur Wailen pa, plaln pa, kipm hi mo.” ");
INSERT INTO uri_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisas laron yangkipm pa kai plaln pa, kil wa arpm ha, wang wampomit wampomwraur pa kai plaln pa, kil wi Pita, Jon a Jems, tunten kaino ropon Maur Wailen kaino wrik nimlien ur. ");
INSERT INTO uri_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kil ropon Maur Wailen pa arpm pa, ikgek akil pa paln manet, a hapm akil ti pa tungkoren pupu muinmainet tolti. ");
INSERT INTO uri_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ari melnum wekg pa paln tolti ntiel ekla, melnum wekg pa Moses ekg Ilaija. ");
INSERT INTO uri_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tuwekg paln namponen klalen a Maur Wailen om nti Jisas pa ekla yangkipm ekg kweiur kweiur a hi wa paln ekg Jisas pa, komkiti nikgwalpm yiprokgen a Maur Wailen yipon pa tolpa hi wa kil mo kai Jerusalem pa. ");
INSERT INTO uri_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita nti tuwekg pa ten hokga. Ari tunten wa prpakg ikg kaino ari Jisas pa paln klalen paitn ai. Tunten ikg kaino ari melnum wekg ur nti Jisas pa atn. ");
INSERT INTO uri_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Melnum wekg pa yampingken ekg akal kai om, Pita ropon Jisas pa la tolpa, “Melnum a Uk Arie, tolpa ti wa mento irk ti om, mento arpm ari apm wor ase. Tolpa ti mento lil walopm wraur, ur ekg kitn, ur ekg Moses, wa ur ekg Ilaija.” Pita pa ake akwonalmpen ekla kuina ur a kil la pa, kil la tolti. ");
INSERT INTO uri_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita la yangkipmek pa atn, ari weipmunu pa elngkul nar ak narenten. Pita, Jon a Jems pa ten kark ekg weipmunu pa elngkul nar ak narenten. ");
INSERT INTO uri_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ek ur klo la ha weipmunu wonen pa kulhor la tolpa, “Kil Warim yek alkupmen a pike kupm akrkahan, ti kipm itning yangkipmek a kil la pa om!” ");
INSERT INTO uri_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ekla pa kai plaln pa, tunten ari Jisas kil alkil wrij hute tolti atn. Tunten ek mit tolti ake la nasi tu tiur ai ekg kweiur kweiur a wet palnten pa, ten elntmpei ark. ");
INSERT INTO uri_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ak kang ripa Jisas namponen tunten melnum yangkipm kuinen alkilen pa nel wa hakaino wrik nimlien pa nar, ari tu wrongwailet paitn ai nel ark. ");
INSERT INTO uri_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Melnum ur pa ari Jisas hakaino krongkwang pa nar, yatom kil kwewel yikaktnen kai kuin a tu wrongwailet a ark pa la tolpa, “Melnum a Uk Arie, kitn kul ri warim kpman alkupmen ti! Kupm warim kpman wrij hnangket apm tike. ");
INSERT INTO uri_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Maur paitn kahor arpm warim kpman akupm ti, yatom ntekg kil wlakil tilntul, hlal nepm wam, hpopm werk wli ekel. Maur paitn pa ake kai tukuleinjel ak wang ur, aklei wang apm ukwel wleket tolpa atn pake. ");
INSERT INTO uri_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kupm ropon tu disaipel alkitnen pa akal kwan maur paitn pa, ari tu ake ntie.” ");
INSERT INTO uri_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ari Jisas klewen la tolpa, “Ntekg tolhai yatom kipm ake ukpma Maur Wailen, wa kipm kinkpman a ak wang ti, kipm melnum a ntekg paitnpaitn! Kupm arpm ntiepm arpm wang watinet paitn ai. Kupm num lpmahakopm paitn ekg kipm pake! Yatom kil la kai melnum pa la tolpa, ‘Ye warim kpman ti no!’ ” ");
INSERT INTO uri_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Warim kpman pa kaino ekg Jisas pa, ari maur paitn pa halik krangkel elngkai knokg pa kwarkwar hlal nepm wam pa ha. Pa Jisas kle kwan maur paitn pa tukuleinjel, kil paln wor yatom kil la nasi yan alkil pa la tolpa, “Kul wiyel ye kai om!” ");
INSERT INTO uri_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tu wrong kinkpman pa wreitn paitn ekg tu ari titnongket wail a Maur Wailen. Tu wrong kinkpman pa wreitn paitn ekg kweiur kweiur a kil ntekg pa atn tolti, kil la nasi tu disaipel alkilen pa la tolpa, ");
INSERT INTO uri_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ampur kipm wonhmiten yangkipm a kupm la nasepm kil. Warim Kpman a Melnum pa hi tu uk kai wam a tu melnum a atn knokg ti.” ");
INSERT INTO uri_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pake ake tu disaipel pa ari yangkipm a kil la ripa pa kil la tolhai. Yangkipm yiprokgen pa ha hampen, ekg ake tu ari, tolpa yatom tu wa kark ekg al mla ur ropontel ekla ripa. ");
INSERT INTO uri_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tu disaipel a Jisas pa alilhakel tita ekg mla ur akal atn hep ekg tu pa. ");
INSERT INTO uri_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ari Jisas arien kahor nikgwalpm wonen a tu pa ari tu akwonalmpen tolpa, yatom kil wi warim ur pa ye kul atn ");
INSERT INTO uri_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","om ak la tolpa, “Mla ur a ukpma kupm ti yatom kil wi wor aklin warim ur tol kil pa, pa wa kil wi wor ekg kupm ti yat, wa melnum a wi wor ekg kupm ti pa, pa apm wa kil wi wor ekg melnum a kwaopm nar ti. Ekg nte, melnum ur kai kuin a kipm ti horhanekg ekg mla ur pa, kil pa atn hep pake.” ");
INSERT INTO uri_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon wa kat ek pa la tolpa, “Wailen, men ari melnum manet ur kwan maur paitn ak nang a kitn, yatom men nasel la tolpa kil elnten, ekg nte, kil melnum a ake nti mento ti.” ");
INSERT INTO uri_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ari Jisas akalmpe tolpa, “Ampur wa kipm lokel, ekg nte, mla ur a ake ntekgepm paitn pa, pa tu melnum alkipmen.” ");
INSERT INTO uri_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Wang yampingken ekg al Maur Wailen wi Jisas ye kaino ktnong, ti nikgwalpm alkilen pa ark wrij ekg kil akal kai Jerusalem pake. ");
INSERT INTO uri_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kil kwa tu ekg ye yangkipm pa hep kai ha ur a ark ha knokg Samaria, akal tu numprampen kweiur kweiur tukol wan ha pa ekg kil hi wa kai. ");
INSERT INTO uri_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pake tu melnum a ha ripa ake wi wor ekg Jisas pa, ekg nte, kil pa akal wa kai Jerusalem. ");
INSERT INTO uri_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jems ekg Jon, disaipel wekg a Jisas, ari pa, yatom tuwekg la tolpa, “Wailen, kitn wi wor ekg men la wakg hakaino ktnong ai nar ekg lap ha ripa?” ");
INSERT INTO uri_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ari Jisas pleln om klewen, plaln pa, ");
INSERT INTO uri_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","kil wa wiyen om ten kai ha manet ur ai. ");
INSERT INTO uri_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tu hor ya pa kai pa melnum wrij ur pa la nasi Jisas pa la tolpa, “Kitn akal hi wa kai hor ha ha pa, kupm hi katnunteitn tolpa atn pake.” ");
INSERT INTO uri_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ari Jisas wa akalmpentel la tolpa, “Kitn akal ntiopm pa, kitn ikwonilmpen worwor pen, yatom kitn ntiopm om! Ekg nte, tu nmpa mingken ti pa knokg teng a tu hokge pa atn. Wa tu wel ti pa tingkil alntu a hokg itne pa atn. Warim Kpman a Melnum ti pa wrik kalpmen a hokgawe.” ");
INSERT INTO uri_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wa melnum ur pa Jisas la nasel la tolpa, “Kul kutnuntopm!” Ari melnum pa la tolpa, “Wailen, htni ekg kupm kai ekg yan alkupmen ti pen, kupm uwentel plaln pa, kupm wa kul ul.” ");
INSERT INTO uri_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ari Jisas akalmpentel la tolpa, “Eln tu melnum a mo pa tu alntu uwen tita om! Kitn ti pa kai laron nasi tu ekg yangkipm wor a Kingdom a Maur Wailen.” ");
INSERT INTO uri_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wa melnum ur pa la tolpa, “Wailen, kupm akal katnunteitn, pake htni waitketn ekg kupm kai ukwor tu alkupmen kil pen.” ");
INSERT INTO uri_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ari Jisas la nasel la tolpa, “Melnum a kil ak tuk ekg u wi pa, ake al wa kil ikg pleln, al kwap a kil ak pa kai paitn. Melnum a tolpa pa kil ake ntie ekg ak kwap a Kingdom a Maur Wailen pa.” ");
INSERT INTO uri_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jisas akrkahan tu melnum kmel wraur tuwek wampwam yikakwomwekg (72) pa, yatom kwawen wekg wekg kai hor ha wail wail a ha wasok wasok ekg akal kil hi wa kai pa. ");
INSERT INTO uri_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kil la nasen la tolpa, “Kweiur kweiur wailet apm tukgun kakir atn pake, pake melnum a kitin ti yek aripm ur tolti. Tolpa ti kipm ropon melnum yan a wring pa, ekg akal kil kwa melnum akwapel wailet kai kitin kweiur kweiur alkilen pa! ");
INSERT INTO uri_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kipm kai om! Kil kupm kwaepm tol sipsip kai kuin a tu nmpa mingken. ");
INSERT INTO uri_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ampur kipm ye hapm kok, marpm a nepm palk alkipmen pa. Ampur kipm kai om ekla atn ya pa, yaper, kalpm, kipm hor yawel itn tolti. ");
INSERT INTO uri_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kipm akal kai kahor wan ha a tu tiur pa, hep pa kipm yangkipmen tolpa, ‘Ukwepm wor! Kipm irpm namponen ipma mehen wor.’ ");
INSERT INTO uri_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tu wi wor pa, pa Maur Wailen kil ukwen wor. Lak kalpm pa, pa Maur Wailen ake ukwen wor, ukwor kipm tike. ");
INSERT INTO uri_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kipm irk wan wrij ur tolti a tu wi wor akal kipm arke pa. Ampur kipm kai wan ur wan ur tuko. Kipm irk pa irk om ekg kipm il hu ekpma a tu ukwepm pa. Al tu ikghlentepm ariworwor ekg kwap a kipm ak pake. ");
INSERT INTO uri_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kipm kai ha wail ur pa, tu wiepm ukwepm wor numprampentepm ekpma pa, kipm wi il tolti. ");
INSERT INTO uri_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wa kipm kwan numpet a tu melnum numpet a ha wail ripa, wa laron nasen tolpa, ‘Kingdom a Maur Wailen pa apm nar yampingken tike.’ ");
INSERT INTO uri_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pake kipm kai kahor ha wail ur pa, ari tu ake wi wor ekg kipm pa, pa kipm itn hor ya atn ha wail pa la nasen la tolpa, ");
INSERT INTO uri_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nepm hngrapm a kipm wet krponte nepm a men ti pa, apm men wa kule elntha ekg ak plantepm tolpa kipm ntekg paitn. Pake kipm wonirpme riworwor yangkipm kil: Kingdom a Maur Wailen apm nar yampingken tike.’ ");
INSERT INTO uri_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kupm la nasepm tolpa hi wa ak wang wail a Maur Wailen ntekg yangkipm namponen kipm wrong kinkpman pa, kalkut a hi wa paln atn ha wail pa, hi wa hangken a ha wail Sotom pa.” ");
INSERT INTO uri_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Rein kipm a ha wail Korasin a kipm a ha wail Petsaita, kipm hi wa wi paitn! Kupm akwap plan titnongket a Maur Wailen kai kipm ti, ari ake wa kipm rein. Tol pike akwap tolpa kai ha wail Tair a Saiton pa, tu tol pike nowe hapm paitn om nar yipan hakg rein paitnpaitn a tu ntekg pa ase. ");
INSERT INTO uri_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hi wa ak wang wail a Maur Wailen ntekg yangkipm pa, kalkut a hi wa paln ekg kipm pa, hi wa hangken a ha wail Tair a Saiton pa. ");
INSERT INTO uri_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Wa kipm Kaperneam ti. Kipm akal kat nang akipm alkipm ti kaino kwa aki? Kipm hi wa tu pilntepm eln kinar ha paitn tolti. ");
INSERT INTO uri_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisas la karkurnten tolpa plaln pa, kil la nasi tu disaipel alkilen pa la tolpa, ‘Mla ur atning yangkipm akipm pa, pa kil atning yangkipm akupm ti yat. Wa mla ur talpuln yangkipm akipm pa, apm wa talpuln yangkipm akupm ti yat tike. Wa mla ur a talpuln yangkipm akupm ti pa, apm wa talpuln yangkipm a Yan a pike kwaopm nar knokg ti.’ ” ");
INSERT INTO uri_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tu disaipel kmel wraur tuwek wampwam yikakwomwekg (72) a pike Jisas kwawen pa tu wa nel kul namponen utopen wailmanten. Tu la tolpa, “Wailen, tu maur paitn yat pa atning katnun ek a men kwanten ak nang akitn.” ");
INSERT INTO uri_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ari Jisas akalmpe la tolpa, “Aklahle, tolpa yatom kupm ari Maur Paitn Satan pa ngko hakaino ktnong ai nar yat tukol mlmal a plaij pa. ");
INSERT INTO uri_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kipm itning, kupm pike ukwepm titnongket, ti ake kwei ur ntekgepm paitn, ti kipm atn rkgangki ul a krko, wa kipm hangken titnongket a wrongmnto alkipmen. ");
INSERT INTO uri_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pake ampur kipm utopen la tolpa tu maur paitn pa atning katnun ek akipm pa. Kipm pa utopen ekg nang alkipmen pa apm ro hel kai wurkapm a Maur Wailen ase.” ");
INSERT INTO uri_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ak wang ketn pa Maur Wor pa akwap titnongket kahor ipma a Jisas pa, yatom kil la tolpa, “Yan, kitn Wailen a ktnong a knokg. Kupm ukweitn wor kat nang akitn, ekg nte, kitn plan kweiur kweiur ripa ekg tu melnum ti a arpm hmit tol warim pa, wa kitn lam ekg tu melnum arie wailwail a nikgwalpm watin pa. Pa kitn ak katnun nikgwalpm wakrongen a arie worwor alkitnen Yan pake.” ");
INSERT INTO uri_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jisas kat nang a Yan akil pa tolpa plaln pa, wa kil wa pleln la nasi tu a ark pa la tolpa, “Kweiur kweiur wrongwailet ti pa Yan akupm ti ukopm plaln. Ake mla ur ari worwor Warim Kpman pa tolpa kil pa mla, Yan akupm tolti pa kil ari pake. Wa ake mla ur wa ari Yan pa yat, kupm alkupm ti hute namponen tu a kupm wakrongen ekg plan Yan pa, tu pa hute ari pake.” ");
INSERT INTO uri_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ak wang a Jisas namponen tu disaipel alkilen pa ark ak tu alntu pa, kil la nasen la tolpa, “Kipm ti pa wor ase, kipm utopen om, ekg kipm ari kweiur kweiur a kipm ari ti. ");
INSERT INTO uri_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kupm la nasepm tolpa tu melnum ek wripm a Maur Wailen namponen tu melnum tukgunakgen pa pike ntekg akal tu ari kweiur kweiur pake, ake pike tu ari. Tu akal atning, ari ake pike tu atning.” ");
INSERT INTO uri_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ak wang wrij ur pa melnum ur a arpmen yangkipm yiprokgen a Maur Wailen pa wreitn kaino akal alm ipmael Jisas pa la tolpa, “Wailen, akal kupm ntekg tolhai ekg kupm hi wa arpm wor aklei wang kai ha wor?” ");
INSERT INTO uri_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisas akalmpentel la tolpa, “Ti wurkapm a Maur Wailen a kitn klein pa, pa la tolhai, pa kitn klein tolhai?” ");
INSERT INTO uri_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Melnum pa akalmpe kai Jisas pa la tolpa, “Kitn akal wakrongen Wailen, Maur Wailen alkitnen pa, atn hep pake. Kitn akal uk maur wor, a nikgwalpm, a titnongket, a arie akitn ti plalnten kai ekg kil. Wa kitn wakrongen tu mla ur ai tol a kitn wakrongen kitn alkitn ti yat.” ");
INSERT INTO uri_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisas akalmpentel la tolpa, “Kitn la pa aklahle, ti kitn ak komkiti tolpa pa, kitn hi apm arpm wor tolpa kai pake.” ");
INSERT INTO uri_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ari melnum a arpmen yangkipm yiprokgen a Maur Wailen pa kor yangkipm ur akal ak plan kil alkil ti nipet wor, yatom kil wa ropon Jisas pa la tolpa, “Ti tu mla ur ai akal kupm wakrongen pa?” ");
INSERT INTO uri_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ari Jisas akalmpentel la tolpa, “Melnum ur pike ha ha wail Jerusalem ti kinar ha wail Jeriko pa. Ari tu melnum paitn ur arkulel ngko ya, nirel hapm, wa wi kweiur kweiur wrongwailet a kil ti plaln, wa erel paitn, yampingken ekg kil akal mo. Yatom tu nuhurntel elntha ya pa, wa tu apm kark kaingkai ase. ");
INSERT INTO uri_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yatom melnum ipma krakgen ur a Maur Wailen pa kil nar ya pa kinar. Kil piln ikg arkikg pa kai ari melnum a ha ya pa tolti, kil ngkom nlokgen hor kai ya wompel pa apm kai ase. ");
INSERT INTO uri_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Wa melnum Lipai ur pa apm wa tolpa yat. Kil nar ya pa kinar, kil ari melnum pa, kil ngkom tukulein hor kai ya wompel pa apm kai ase. ");
INSERT INTO uri_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ari melnum Samaria ur pa apm wa komkiti ya pa nar, kil ari melnum a tu er pa ha ya, ipma wonen akil pa hakg rein paitn ekg melnum pa. ");
INSERT INTO uri_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kil kai kinar yampingken tolti, kil alung hu yuwa pa namponen hu wain pa ak nel hi kweiur kweiur pa, yipoel. Plaln pa, kil kat eln kaino donki alkil ti tolti, wa wiyel ye kinar wan ur a tu kaingkai ya watinet ai kul hokg arke pa. Yatom kil alkil ikghlentel. ");
INSERT INTO uri_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kil kai hokg, ak kang ti, kil nkle marpm tenari wekg pa ye kai uk melnum a ikghlen wan pa, la nasel la tolpa, ‘Ikghlentel tolpa kaingkai, marpm ur a kitn wa uk hangken marpm a kupm ukweitn kil pa, wang ur a kupm wa kul pa, hi kupm akalmpenteitn.’ ” ");
INSERT INTO uri_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jisas la yangkipm kla pa plaln, wa kil wa ropon melnum a arpmen yangkipm yiprokgen a Maur Wailen pa la tolpa, “Ti kitn akwonalmpen tolhai melnum wraur kil, mla ur hai kil melnum a uk ipma wakrongen melnum a tu melnum paitn erel elntha ya pa?” ");
INSERT INTO uri_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Melnum a arpmen yangkipm yiprokgen a Maur Wailen pa akalmpe tolpa, “Melnum a kinar rein ekg aklin melnum pa, pa apm kil pake.” Jisas la nasel la tolpa, “Apm tolpake. Kitn kai om kitn ik tolpa kai om!” ");
INSERT INTO uri_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisas namponen tu disaipel alkilen pa hor ya pa kai pa, tu kai paln kai ha ur. Kin wrij ur a arpm ha pa, nang akil pa Mata, kil wi wor ekg akal kil ntiel arpm wan akil pake. ");
INSERT INTO uri_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maria pa wasok a Mata. Jisas kil piln yangkipm pa arpm, pa Maria pa kil arpm yampingken nepm a Jisas pa atning yangkipm a kil la pa arpm. ");
INSERT INTO uri_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kil akuke Mata pa hmurkg wampen ntekg wakgkuntuk kweiur kweiur pa arpm, yatom ipma a kil pa paitn ekg Maria pa, yatom kil kai nasi Jisas pa la tolpa, “Wailen, kitn ari kupm alkupm wrij numprampen ekpma kweiur kweiur ti! Ti ntie ekg kitn la nasi Maria pa ekg kil nar iklinjopm pen?” ");
INSERT INTO uri_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ari Wailen akalmpentel la tolpa, “Mata, Mata, kitn nikgwalpm kalkut akwonalmpen kweiur kweiur wailet. ");
INSERT INTO uri_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pake kwei ur wor wrij wailmanten kil pa ha ai pen, ake kitn wi pen. Maria pa apm wi ase, pa kweiur kweiur wor wrijen, hi ake melnum ur kwan tukuleinjel pa.” ");
INSERT INTO uri_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ak wang wrij ur pa Jisas kai ropon Maur Wailen kai wrik ketn ur pa. Kil ropon Maur Wailen pa plaln pa, disaipel wrij ur alkilen pa ropontel tolpa, “Wailen, tol wa kitn klingkento ya a ropon Maur Wailen pa pen, tol pike Jon Melnum a Kaluk Tu kil kaling plan tu disaipel alkilen pa.” ");
INSERT INTO uri_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jisas la nasen la tolpa, “Kipm akal ropon Maur Wailen pa, kipm ropon tolkil: Yan, nang a kitn pa al atn wri wor. Kingdom a kitn pa al nar. ");
INSERT INTO uri_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kitn uko ekpma pa iklei wang wrij wrij pa. ");
INSERT INTO uri_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kitn kwan paitnpaitn a men ti, tol a men kwan paitnpaitn a tu ntekg kul ekg men ti. Ampur yeo kai kalkut pa ekg akal ak rkolo kai paitnpaitn pa.” ");
INSERT INTO uri_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yatom kil wa la nasen yangkipm kla kil ekg akal tu ropon Maur Wailen tolpa kai pake, ake al tu elnten, “Ti wrij ur a kipm ti kai wan a melnum ur a kipmekg atn hor wrij pa, ak mning kuin kuin pa, yatom kitn ropontel la tolpa, ‘Kitn arpm e? Ntie ekg kitn ukopm nak tngklak wraur, yatom hi wa kupm akalmpenteitn ul. ");
INSERT INTO uri_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Melnum wor ur alkupmen wet ha ya watinet ai kul wan akupm ti, ti wan akupm ti tmpal ekpma kalpmtopm ekg ukwel al.’ ");
INSERT INTO uri_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ari wa melnum pa akalmpe hakahor wan pa kulhor tolpa, ‘Ampur ukopm kwap wailet! Wanyun apm men kli ase. Kupm namponen tu kin warim alkupmen ti men hokg tike. Ti ake ntie ekg kupm wreitn ukweitn kwei ur.’ ” ");
INSERT INTO uri_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Wa Jisas wa la tolpa, “Kupm la nasepm tolpa, yan a wan pa tol ake wreitn uk kweiur kweiur pa kai melnum wor akil pa, tolpa kalpm. Kil wreitn ukwel pati ekg nte wa kil atn ropon atn lan. Yatom kil wreitn wi kweiur kweiur pa wailet ukwel komkiti kuina ur a kil ropon pa. ");
INSERT INTO uri_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Tolpa yatom kupm la nasepm la tolpa, tol kipm ropon pa, pa kipm wi; tol kipm kor pa, pa kipm hantil; wa tol kipm klpon pa, wanyun pa al kukwantepm. ");
INSERT INTO uri_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ekg nte, mla ur a kil ropon pa, kil wi, wa mla ur a kil kor pa, kil hantil, mla ur a kil klpon pa, wanyun pa al kukwantel. ");
INSERT INTO uri_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ti kipm yantin pa, tol warim wrij ur a kipm ropon ekg yul pa, pa al kipm ukwel ul pake? ");
INSERT INTO uri_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Aki tol kil ropontepm ekg krek hlmpa pa, pa kipm ukwen krko pake? ");
INSERT INTO uri_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ti tukol kipm yantin a ntekg paitn pa, wa kipm wa uk kweiur kweiur worwor tu warim alkipmen pa. Tolpa ti wa kipm ari tolpa Yan alkipmen a arpm kaino ktnong pa, wa wor wrijen hangken kipm yantin a knokg ti. Ti kipm akal ropontel ekg kil ukwepm Maur Wor alkil pa, kil utopen ekg ukwepm pake.” ");
INSERT INTO uri_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisas kil kwan maur paitn a ntekg melnum ek mite ur pa kai tukuleinjel, yatom kil wa ekla. Tu wrongwailet ari pa, yatom tu wutnanten. ");
INSERT INTO uri_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ari wa tu tiur pa la tolpa, “Kil akwap namponen Pelsepul, melnum tukgunakgen a tu maur paitn pa, ukwel titnongket, yatom kil kwan maur paitn pa.” ");
INSERT INTO uri_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wa tu tiur pa akal alm ipmael Jisas, yatom tu ropontel tolpa, tol kil ntekg kwei ur weten a ake pike tu ari hep pa ekg ik plan titnongket a Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pake Jisas kil ari nikgwalpm a tu pa, om kil la nasen la tolpa, “Tol kupm ak titnongket a Maur Paitn Satan ik kwap pa, pa tukol ha ur a kil ro kil alkil tolpa alm tita pa, pa apm paitn ase. Wa tukol melnum ur kil wreitn nti kin warim alkil er tita pa, arpm wor a tu arpm wrij pa apm kai paitn ase. ");
INSERT INTO uri_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ti kipm la Pelsepul, melnum a atn tukgunakgen a ikghlen tu maur paitn pa, ukopm titnongket pa, yatom kupm kwan tu maur paitn pa. Ti tol Maur Paitn Satan nti tu alntu pa er tita pa, pa wa kil atn titnongket ikghlen tu alntu pa tolhai? ");
INSERT INTO uri_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ti tol Pelsepul pa ukopm titnongket yatom kupm kwan tu maur paitn pa, ti tu alkipmen ti wi titnongket kai mla, yatom ak kwan tu maur paitn pa? Apm tu pa planto tolpa yangkipm a kipm la pa ake aklahle. ");
INSERT INTO uri_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ti tol Maur Wailen pa kil ukopm titnongket yatom kupm kwan maur paitn pa, pa plan tolpa, Kingdom a Maur Wailen pa apm narntepm ase. ");
INSERT INTO uri_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Melnum titnongket pa kil numprampen wri hik alkil pa, yatom kil arpmen wan alkil pa, kweiur kweiur akil pa arpm wor. ");
INSERT INTO uri_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pake tol melnum titnongket ur ai wa hangkentel pa, kil wa kul almpel, wi wri wamung a pike ak titnongketel kil pa ye kai tukuleinjel, om kil kahor wi kweiur kweiur wrongwailet a atn kahor wan a kil pa, wi ye kai nampreng uk tu tiur ai.” ");
INSERT INTO uri_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Jisas la yangkipm kla tolpa plaln pa, kil la tolpa, “Tu melnum a ake alkupmen pa, tu atn wrongmnto ekg kupm. Wa tu melnum a ake aklinjopm ekg wi tu wrong kinkpman pa ye kul pa, pa tu kwanten kai.” ");
INSERT INTO uri_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jisas kil wa la tolpa, “Tol tu kwan maur paitn a arpm kahor melnum ur pa kai tukulein pa, pa kil kai atn hor wrik tngklak kalpmel, kor wrik akal arpm ekg wi yapm. Tol ake kil hantil ur pa, pa kil la tolpa, ‘Wa kupm pleln kai irpm wan alkupmen a pike kupm arpme hep ai.’ ");
INSERT INTO uri_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yatom kil kai ari wan pa kingkim yipikel om atn wor. ");
INSERT INTO uri_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Om kil wa kai, wa wi maur paitn wampomit wampomwekg a ntie titnongket hangkentel pa ye kul ekg tu arpm pa. Yatom melnum pa hi wa kai paitn wrijen hangken a pike hep pa.” ");
INSERT INTO uri_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas kil ekla atn pa, kin ur a atn kuin a tu wrongwailet pa la ak ek wail tolpa, “Kin a pike rakueitn yatom ikghlenteitn ukweitn ma al pa, kil pa wor pake, kil utopen om!” ");
INSERT INTO uri_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ari Jisas akalmpe la tolpa, “Pa wor, pake wor a tol wa mento la tolpa, melnum a kil atning yangkipm a Maur Wailen pa yatom kil katnun pa, kil pa wor pake, kil utopen om!” ");
INSERT INTO uri_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tu wrongwailet pa atn yeningken Jisas tolpa atn. Pa wa tiur wa nel kulngkul, om kil katen ekla pa la tolpa, “Kipm wrong kinkpman ak wang ti pa, kipm wrong kinkpman paitn. Kipm ropontopm ekg al kupm ntekg kweiur weten titnongket a ake pike kipm ari hep ekg kipm akal ari, pake hi wa kipm ari klal wrij hute tol a pike paln ekg Jona pa. ");
INSERT INTO uri_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ti apm wa tolpa yat, tol Jona pa klal a pike Maur Wailen kil plan tu wrong kinkpman a ha wail Ninipe, hi Warim Kpman a Melnum pa apm wa klal a hi wa plan kipm wrong kinkpman ak wang ti yat. ");
INSERT INTO uri_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ti hi ak wang wail a atn yangkipm pa, kin a pike atn tukgunakgen arpm knokg ur kinar pa, hi wa kil wreitn atn hntra wam itne kipm wrong kinkpman a ak wang ti la tolpa kipm ntekg paitn. Kin pa kil pike arpm kinar watinet ai, ari kil pike kul no atning arie wor a Solomon pike kaling plantel pa. Pake kipm ti pa ake wa kipm atning yangkipm a melnum wailen ripa a hangken Solomon pa. ");
INSERT INTO uri_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ti wa hi ak wang wail a atn ekg yangkipm pa, tu wrong kinkpman a Ninipe pa hi wa tu wreitn atn hntra wam itne kipm wrong kinkpman ak wang ti la tolpa kipm ntekg paitn. Ak wang a Jona pike kil piln yangkipm pa, tu atning, om tu pike pleln ipma. Pake kipm ti pa ake wa kipm atning yangkipm a melnum wailen ripa a hangken Jona pa.” ");
INSERT INTO uri_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ti melnum ur ake al kil nihil wakg pa, yatom kil lam aki wa kil ak kuntuk mang ak naren pa, kalpm. Kil al nihil om elntark kaino kwa ti, ekg wang a tu wrong akal kul pa, pa tu ari wakg ripa. ");
INSERT INTO uri_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ti ikg akitn pa tukol wakg a numpwam pa. Ikg akitn pa wor pa, numpwam akitn pa klalet yat. Pake tukol ikg akitn pa paitn pa, numpwam wrongwailet akitn ti mningket plaln. ");
INSERT INTO uri_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ti kitn irpm ri, ekg wakg a arpm kahor kitn pa ake al kai mningket. ");
INSERT INTO uri_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ti tol numpwam wrongwailet akitn ti wakg helen plaln pa, num wompel ur akitn ti pa ake atn mningket pa, pa klalet plaln, tukol klalet a wakg hmprepm ak helenteitn pa.” ");
INSERT INTO uri_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisas kil ekla plaln pa, melnum ur a tu Parasi pa ropontel ekg al ekpma kai wan akil. Yatom kil ntiel kai kahor tolti, kil katen ekpma pa ye kul, om tu al. ");
INSERT INTO uri_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Melnum Parasi pa, kil wreitn paitn ekg ari Jisas ake klak wam pa hep yatom ak al ekpma pa. ");
INSERT INTO uri_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yatom Wailen kil la nasel la tolpa, “Ti kipm Parasi ti yat, kipm klak keimung pa hor hen, wa kahor wonen akipm pa yipiket, ekg nte ikgwam a paitnpaitn wailet a kipm ntekg pa ha pa. ");
INSERT INTO uri_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ti kipm hmit! Ti Maur Wailen kil pike ntekg hen ti tolti, wa ake pike kil ntekg kahor wonen pa aki? ");
INSERT INTO uri_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tol wa kipm uk kweiur kweiur a arpm keimung ti kai aklin tu a arpm warkip pa pati, kweiur kweiur wrongwailet pa paln hrukij wor ekg kipm. ");
INSERT INTO uri_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Woi, rein kipm Parasi ti, kipm hi wa wi paitn! Kipm uk tiel wampwam alkipmen tukol kweiur kweiur wrongwailet a atn wring kai namponen wanukgnung kweiur kweiur waitketn ketn pa plalnten kai Maur Wailen, pake ake wa kipm ntekg nipet wor ekg tu mla ur ai, ake wa kipm wakrongen Maur Wailen ti. Kipm uk tiel wampwam pa wor pake, wor tol wa kipm katnun nikgwalpm worwor tiur ai yat. ");
INSERT INTO uri_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Woi, rein kipm Parasi ti! Kipm wakrongen tolpa akal arpm wrik worwor kahor wan a atning yangkipm a Maur Wailen pa, wa kipm wakrongen akal tu ukwepm wor atn ha kuin kai ikg a tu wrongwailet, ti kipm hi wa wi paitn. ");
INSERT INTO uri_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Woi, rein kipm ti! Kipm pa tukol kirkhap a ake tu hma kminim wak atne pa, om ake tu ari, yatom tu wonmit ngkom hele tolti kai. Ti kipm hi wa wi paitn.” ");
INSERT INTO uri_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yatom melnum wrij ur a arpmen yangkipm yiprokgen a Maur Wailen pa la tolpa, “Melnum Wailen, kitn wa la tu Parasi tolpa, ti wa kitn la ekla paitn ekg men ti yat.” ");
INSERT INTO uri_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ari Jisas wa la nasel la tolpa, “Woi, rein kipm melnum a arpmen yangkipm yiprokgen a Maur Wailen ti yat! Kipm uk kalkut wail tu wrong kinkpman pa ti ake ntie ekg tu arki. Pake ake kipm alkipm ti hntra wam ti aklinjen ekg ye kalkut pa. Kalpm, kipm ark ari ak ikg tolti. Ti kipm hi wa wi paitn. ");
INSERT INTO uri_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Woi, rein kipm ti! Wa kipm wien ikghlen kirkhap a tu melnum ek wripm a pike tu mamikgmamin akipm er mo hep pa. ");
INSERT INTO uri_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pati kipm plan tolpa kipm ti wi wor ekg kwap a pike tu mamikgmamin alkipmen ak pa. Ekg nte, tu mamikgmamin pike er tu melnum ek wripm a Maur Wailen pa mo pake, wa kipm ti pa ikghlen wien kirkhap a tu pa. Ti kipm hi wa wi paitn. ");
INSERT INTO uri_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Apm tolpa yatom, nikgwalpm arie wor a Maur Wailen pa la tolpa, ‘Hi kupm kwa tu melnum ek wripm, wa tu melnum yangkipm kuinen a kupm pa kainten, yatom hi wa tu ntekg paitn ekg tiur, wa er tiur mo.’ ");
INSERT INTO uri_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tu er tu melnum ek wripm pa mo ak wang a ntekg ktnong a knokg ti, kulngkul ak wang ti pa, kalkut a mo a tu pa, pa apm kipm wrong kinkpman a ark ak wang ti ye tike. ");
INSERT INTO uri_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tukol pike tu er Apel pa, wa tu tiur a kulngkul ngko Sekaraia ti. Sekaraia pa tu erel mo atn kahor yipmingki wonen a wan yalming a Maur Wailen, atn kuin a wan yalming a tpmakg a tu ukwor Maur Wailen atne pa. Kupm la nasepm aklahle, kalkut pa apm arku kipm tike. ");
INSERT INTO uri_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Rein kipm melnum a arpmen yangkipm yiprokgen a Maur Wailen ti! Wa kipm kli wanyun a wi nikgwalpm arie worwor ti. Kipm alkipm ti ake kipm kahor wanyun pa, wa kipm kli wanyun ekg tu tiur ai akal kahor pa. Tolpa ti kipm hi wa wi paitn.” ");
INSERT INTO uri_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jisas la yangkipm pa plaln pa kil akal nuhurn wan pa kai, ari tu melnum a arpmen yangkipm yiprokgen pa, wa tu Parasi pa ipma wakget, la tilpentel wailet aknukwarel, ");
INSERT INTO uri_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","nungkwangen tolpa, tol akal kil la yangkipm ur kai paitn pa, tu wiyel ye kai atn yangkipm. ");
INSERT INTO uri_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tu wrongwailet paitn ai nel kulngkul ark ak hmpri wrik ekg tita pa atn, al tu ngkom tolhai. Tu ngkom ari rkgangki tita tolti, om Jisas kil katen ekla pa la nasi tu disaipel alkilen pa la tolpa, “Ti kipm itn uk ikg ri akplain a tu Parasi pa! Tu akplain plan ak num henen ti tolti. ");
INSERT INTO uri_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ti tol kuina ur a atn hampen pa, hi wa paln kai ngko wurknong, wa kuina ur a haur hampen ha pa, hi wa wi ye kai ngko wurknong. ");
INSERT INTO uri_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pa apm wa tolpake, kuina ur a pike kipm la ak mning hep pa, hi wa tu atning ak hran, wa kuina ur a pike a kipm la hep ak ho hampen nasi tita kai nungkulkg arpm kahor wan wonen pa, hi wa tu kulhor la ak ek wail kai hen ai.” ");
INSERT INTO uri_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ti kipm melnum worwor alkupm, kupm la nasepm la tolpa ampur kipm kark ekg melnum a almpepm mo pa. Pa tu alm numpalk ti tolti hute, tu ake ntie ekg ntekg kuina ur tolhai. ");
INSERT INTO uri_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pake akal kupm yewepm kark ekg melnum ur kil. Kil pa ntie titnongket ekg ntekg kmel mo plaln pa, piln kmel elngkai wakg. Ti kipm kirk ekg melnum ripa om! ");
INSERT INTO uri_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ti kipm ari pa, wel wasikyikek wampomit pa mento apm ak marpm wasikyikek tolti pa ak armpen pake. Pake, Maur Wailen pa ake wonhmiten kweiur kweiur wasikyikek tukol wel ti, kil ikghlenten pa. ");
INSERT INTO uri_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ti apm tolpake, tukgunakg walkg wrij wrij alkipmen ti pa, apm kil wa klein yekworwor ase, ti ampur kipm kark, ekg nte, kipm ti pa wa wailmanten atn hep hangken wel wasikyikek wailet pa.” ");
INSERT INTO uri_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ti kupm la nasepm tolpa, mla ur a kil laron nang a kupm ti atn kai ikg a tu wrongwailet pa la tolpa kil pa akupm, hi wa Warim Kpman a Melnum pa kil laron nang a kil pa atn kai ikg a tu maur akwapel a Maur Wailen pa, kil yat hi wa la tolpa kil pa akupm. ");
INSERT INTO uri_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pake, mla ur a lam nang a kupm ti atn kai ikg a tu wrongwailet pa, hi wa Warim Kpman a Melnum pa wa lam nang a kil pa yat atn kai ikg a tu maur akwapel a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Wa mla ur a kil la paitnel Warim Kpman a Melnum pa, hi wa Maur Wailen kwan paitnpaitn alkilen pake. Pake melnum a kil la paitnel Maur Wor a Maur Wailen pa, paitnpaitn alkilen pa hi ake kil kwan. ");
INSERT INTO uri_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ti tol tu wiyepm ye kahor wan a atning yangkipm a Maur Wailen atne pa ekg ntekg yangkipm pa, aki ye kai atn ikg a tu melnum tukgunakgen nti tu melnum wailen pa, ampur kipm kark ekg al kipm akalmpe aki kipm la tolhai pa. ");
INSERT INTO uri_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ekg nte Maur Wor a Maur Wailen pa al ukwepm nikgwalpm ak wang ketn pa ekg kuina ur a kipm akal la pa.” ");
INSERT INTO uri_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yatom melnum wrij ur kai kuin a tu wrong kinkpman pa la nasi Jisas pa la tolpa, “Melnum a Uk Arie, kupm wakrongen tolpa kitn la nasi wailen akupm ti ekg mentekg wako kweiur kweiur a yan a mentekg a mo ase elnto atn ti.” ");
INSERT INTO uri_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ari Jisas la nasel la tolpa, “Kipmekg pa! Mla ur la akal kupm arpm atning yangkipm a kipmekg ti om rontepm kweiur kweiur ripa?” ");
INSERT INTO uri_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yatom wa kil la nasi tu wrong kinkpman pa la tolpa, “Kipm wonirpme om ikghlen kipm alkipm ti worwor, ekg ake al kipm arikowe akal wi kweiur kweiur wailet pa, ekg nte, kweiur kweiur wailet a tolpa pa ake al aklin melnum ekg arpm wor, wa wi arpm wor a arpm aklei wang ye hor pa kai.” ");
INSERT INTO uri_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yatom Jisas la nasen yangkipm kla ur pa la tolpa, “Melnum ur a ntie kweiur kweiur wailet pa kil ntekg wringkya kweiur kweiur pa a kil ntekg pa turkget wailet wor. ");
INSERT INTO uri_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ari wa kil akwonalmpen tolpa, ‘Kweiur kweiur a kupm ntekg ti wailet paitn, tolpa ti al kupm ye kai elntatn wan hai?’ ");
INSERT INTO uri_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yatom wa kil akwonalmpen tolpa, ‘Wan tiur a kupm eln kweiur kweiur ti hawe ti apm lawe ase, ti al kupm ntekg wan wailwail tiur pa ekg eln ekpma a kweiur kweiur worwor alkupmen ti elntatne. ");
INSERT INTO uri_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yatom al kupm la kupm alkupm ti la tolpa, wor wrijen. Kweiur kweiur worwor a kupm ye pa, hi wa atn wring wailet. Ti kupm al al hu a ekpma pa arpm utopen aklei wang.’ ");
INSERT INTO uri_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ari Maur Wailen la nasel la tolpa, ‘Kitn hmit! Kitn pal mo ak mning ti om, ti kweiur kweiur a kitn numprampen ha ti hi wa mla ur wi?’ ” ");
INSERT INTO uri_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yangkipm kla a Jisas la ripa kai tolpa. Yatom wa kil la tolpa yat, “Melnum ur a kil kor tita kweiur kweiur worwor elntatn ekg akal ak aklin kil alkil pa ekg arpm wor, pake kai ikg a Maur Wailen pa kil arpm warkip paitn wrijen.” ");
INSERT INTO uri_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yatom Jisas kil la nasi tu disaipel alkilen pa la tolpa, “Ampur kipm akwonalmpen wailet ekg kweiur kweiur a numpalk ti, tol al kipm al ekpma hai aki al kipm nowe hapm hai. ");
INSERT INTO uri_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ekg nte, melnum ti pa wailmanten atn hep hangken ekpma ti, wa numpalk ti yat, wa wailmanten atn hep hangken hapm pa. ");
INSERT INTO uri_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ti kipm ikwonilmpen wel pa, tu ake alin ekpma pa, aki kitin ekpma pa ye kul elntatn wan ekpma pa, kalpm. Pa Maur Wailen kil alkil ukwen ekpma. Ari kipm ti pa wa tol kweiur wailmanten paitn atn hep hangken wel pa. ");
INSERT INTO uri_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kipm ipma kalkut tolpa pa hi wa ak arukge wang alkipmen a arpm knokg ti wa ye kai watin ketn aki? ");
INSERT INTO uri_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tol a kipm ake ntie ekg ntekg kweiur kweiur waitketn ketn tolpa pa ti, ntekg tolhai yatom wa kipm akwonalmpen wailet ekg kweiur kweiur tiur ai? ");
INSERT INTO uri_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ti wa kipm ari kweiur kweiur hrin pa, tu ake ak kwap aki ntekg hapm alntuen ekg nowe pa. Pake kupm la nasepm tolpa, pike Solomon, melnum tukgunakgen a ntie kweiur kweiur wailet pa ake nowe hapm ur a ariwor tukol kweiur kweiur hrin pa. ");
INSERT INTO uri_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kipm ari pa Maur Wailen kil alkil ikghlen kweiur kweiur hrin pa. Pa ake wailmanten, tol kweiur kweiur hrin a atn ak wang ti pa, hi kil kwat piln kai wakg. Kipm melnum ti pa wailmanten, ti kil hi wa aklinjepm ekg hapm kweiur kweiur pa. Ti ake wa kipm ukpma titnongket. ");
INSERT INTO uri_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yatom ampur kipm ipma kalkut, om akwonalmpen wailet ekg kipm al al hu a ekpma hai pa. ");
INSERT INTO uri_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tu kinkpman wrongwailet a knokg ti pa, apm akwonalmpen kweiur kweiur tukol pake. Pake Yan alkipmen pa ari kuina ur a kipm warkip pa. ");
INSERT INTO uri_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tolpa ti kipm ikwonilmpen ekg kor Kingdom a Maur Wailen hep pen, yatom al kil ukwepm kweiur kweiur wrongwailet ripa.” ");
INSERT INTO uri_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ti kipm melnum yikek alkupm pa, ampur kipm kark, ekg nte, Yan alkipmen ti pa utopen ekg al hi kil ukwepm Kingdom alkilen pa. ");
INSERT INTO uri_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ti kipm uk kweiur kweiur alkipmen a kipm ntie ti ik wi marpm pa yatom uk kai tu melnum a arpm warkip pa. Tol kipm ntekg tolpa pa, pa wa tukol kipm numprampen hapm kok weten ur ai kaino ha wor ai ekg al kor tita alupm kweiur kweiur worwor, wa kweiur kweiur a hi ake plaln aki yakning kwat al, aki melnum ikgwampet akikgwampel pa. ");
INSERT INTO uri_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ekg nte, kipm kor tita kweiur kweiur worwor alkipmen pa atn hai pa, nikgwalpm wail alkipmen pa apm ark pake.” ");
INSERT INTO uri_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ti kipm ik hmpei pa kwat hapm a kpor hapm pa ning warkip, nihil wakg pa, yatom kipm numprampen irpm nungkwangen. ");
INSERT INTO uri_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tukol tu melnum akwapel a numprampen arpm nungkwangen yan a kwap alntu a kai ekg ekpma wail ur a ntekg al itnen kin a kpman ur a ye tita, yatom wa kul. Kil kul atn wanyun pa kwe, tu apm atning aktutu kul kukwa wanyun ase. ");
INSERT INTO uri_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Yatom tol yan a kwap pa kil ari tu melnum akwap kalpmel alkilen pa tu numprampen, yatom nungkwangentel arpm pa, tu pa wor pake, tu utopen om! Kupm la nasepm tolpa, yan a kwap alntuen pa akal kil kpor hapm pa ning warkip om ik hmpei pa kwat plaln pa, kil la nasen la tolpa, tu irpm kai wrik ai, yatom kil katen ekpma pa ye kai ukwen al. ");
INSERT INTO uri_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ti wa tol kil kul ak mning kuinkuin ti aki, kil kul ak nungkwat ti ur pa, kil ari tu numprampen arpm pa, al kil wi wor lawen tolpa tu pa wor pake, tu utopen om! ");
INSERT INTO uri_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ti wa kipm ari kil: tol melnum yan a wan alkil pa kil ari tolpa melnum ikgwampet akal kul ekg tikale wan alkil pa, pa kil ake nuhurn wan alkil pa kai ekg kil tikale pa. Kalpm, kil apm arpmen arpm pa arpm pake. ");
INSERT INTO uri_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yatom wa kipm ti yat, kipm akal numprampen arpm nungkwangen Warim Kpman a Melnum hi wa nar ak wang ur a kipm ake ari akal kil wa nar pa.” ");
INSERT INTO uri_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yatom Pita kil ropon Jisas pa la tolpa, “Wailen, yangkipm kla pa kitn la kul ekg men ti tolti aki, kitn la ekg tu wrongwailet ai yat e?” ");
INSERT INTO uri_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Om Wailen kil akalmpe la tolpa, “Ti melnum akwapel atn hep hai ur wor nikgwalpm arke? Pa hi yan a kwap alkil pa eln kil pa atn wailen ekg ikghlen tu alntu akwapel pa ekg nampreng ekpma pa ak wang alkilen a tu wi ekpma pake. Yatom kil kai. ");
INSERT INTO uri_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yatom tol yan a kwap pa wa kul ari melnum akwap kalpmel alkilen pa akwap tolpa atn pa, kil pa wor pake, kil utopen om! ");
INSERT INTO uri_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ti kupm la nasepm aklahle wrijen, yan a kwap pa hi wa eln melnum akwap kalpmel alkilen pa atn yan ikghlen kweiur kweiur wrongwailet alkilen pa. ");
INSERT INTO uri_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pake, tol melnum akwap kalpmel pa kil akwonalmpen tolpa, yan a kwap alkilen pa ake kul aktutu pa, pa kil arpm al hu a ekpma pa, wa al hu hmit pa, om er tu wrong kinkpman a tu akwap wrij tol kil pa, tolpa wonmit arpm. ");
INSERT INTO uri_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ari kalpm, yan a kwap alkilen pa apm paln tike. Kil kul paln ak wang a kil ake ari akal kil kul pa, yatom kil erel paitn wrijen kwantel kai arpm namponen tu melnum a ake ukpma pa. ");
INSERT INTO uri_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Wa melnum akwapel a kil ari kuina ur a yan a kwap alkilen la nasel pa, ake kil numprampen arpm komkiti nikgwalpm a kil la pa, pa kil pa hi wa kil erel paitn. ");
INSERT INTO uri_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pake, melnum akwapel a ake kil ari kuina ur a yan a kwap alkilen pa la pa, yatom ake kil ak komkiti nikgwalpm tol a kil la pa, kil pa hi kil erel waitketn tolti. Melnum a pike kil wi wailet kai Maur Wailen pa, al kil akalmpe wailet kai Maur Wailen, hangken melnum a pike kil wi waitketn pa. Melnum a pike kil wi kloken wailet pa, hi wa tu ukwempentel ekg kil akalmpe wailet, wa hangken ripa.” ");
INSERT INTO uri_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Kupm pike nar ekg alile wakg atn knokg tike, ti kupm wakrongen tolpa wakg pa krpo iktutu. ");
INSERT INTO uri_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kupm hi wa ye kalkut wailmanten kanukg, ti kupm ipma kalkut paitn tolpa kai ngko wang a kalkut pa kai plaln. ");
INSERT INTO uri_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ti kipm ti lak kupm ti nar ekg al ntekg kipm ti arpm mehen wor aki? Tolpa kalpm, pa kupm nar ekg al wako rowepm. ");
INSERT INTO uri_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yatom ak wang ti hor pa kai pa, melnum wampomit a ark wan wrij pa hi wa ro, yatom melnum wraur pa hi wa atn paitn ekg melnum wekg pa, wa melnum wekg pa apm wa tolpake, tuwekg hi wa atn paitn ekg melnum wraur pa. ");
INSERT INTO uri_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tu yantin hi wa atn paitn ekg tu warim kpman alntuen, wa tu warim kpman pa hi wa atn paitn ekg tu yantin alntuen. Wa tu mantin hi wa atn paitn ekg tu warim kin alntuen, wa tu warim kin pa hi wa atn paitn ekg tu mantin alntuen. Wa tu yalmpikg hi wa atn paitn ekg tu yalmpikg itnei alntuen, wa tu yalmpikg itnei pa hi wa atn paitn ekg tu yalmpikg alntu.” ");
INSERT INTO uri_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jisas kil wa la nasi tu wrong kinkpman pa la tolpa, “Kipm ari weipmunu a wreitn hakinar takgni nare pa kul no pa, pati kipm apm ari ase, al hu wei. Pa hu wei pake. ");
INSERT INTO uri_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wa kipm ari wripm a hor ha knokg kinar ti no pa, kipm apm ari ase, ekg al takgni wor pake. Pa takgni wor. ");
INSERT INTO uri_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ti kipm melnum a akplain plan ak num henen ti tolti. Kweiur kweiur a hel kaino ktnong ai, wa atn knokg ti ak ye kweiur kweiur a paln pa, pa kipm ari wor pake, ari ake wa kipm ari kuina ur a paln ekg ak ye wang ti kul?” ");
INSERT INTO uri_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Tukol hai yatom kipm alkipm ti ake ari tolpa, kuina ur a wor ekg kipm katnun? ");
INSERT INTO uri_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tukol melnum ur akal wiyeitn ye kai atn yangkipm pa, kipmekg ngkom hor ya pa kai pa, kitn kor ya ekg kipmekg er yangkipm pa kai mo. Kalpm pa, al kil wiyeitn ye kai atn yangkipm atn ikg a melnum a noworel yangkipm, wa melnum a noworel yangkipm pa wiyeitn ye kai ekg wam a tu pangklelek, yatom tu pangklelek pa wa wiyeitn ye kai arpm wan tipmning. ");
INSERT INTO uri_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kupm la nasepm tolpa, kitn ake ntie al hor hen pa, kalpm, kitn al arpm pa arpm arpm, kitn armpen kaingkaing kai plaln pa, tu kwanteitn kulhor hen.” ");
INSERT INTO uri_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yatom ak wang pa, tu tiur kul la kitin Jisas ekg tu melnum tiur a Kalili a pike Pailat la yatom tu almpen mo, om walmpopm a tu pa ungkwan ak horen walmpopm a wlikgek kweiur kweiur a tu atn ekg lap al wor uk Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ari Jisas akalmpenten la tolpa, “Ekg nte, tu melnum a Kalili a pike wi kalkut tolpa yatom, kipm pa akwonalmpen tolpa tu pa tu melnum paitn wrijen a hangken tu Kalili a ntekg paitnpaitn ai aki? ");
INSERT INTO uri_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kalpm. Pake kupm la nasepm la tolpa, tol ake kipm pleln ipma om nuhurn paitnpaitn alkipmen pa, kipm wrongwailet hi apm mo tukol tu pake. ");
INSERT INTO uri_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ti wa tu melnum wampwam yikakwomit womwraur (18) a pike wan wlop wlop kaino kwa tupor ak arkuen om tu mo hakai ha Siloam pa, pa kipm pa akwonalmpen tolpa, tu pa melnum paitn wrijen a ntekg paitnpaitn hangken tu melnum a ark Jerusalem pake? ");
INSERT INTO uri_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kalpm. Pake kupm la nasepm tolpa, tol ake kipm pleln ipma nuhurn paitnpaitn alkipmen pa, kipm hi wa wi paitn tukol a tu wrongwailet wi yat pake.” ");
INSERT INTO uri_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yatom Jisas la yangkipm kla ur pa la nasi tu wrong kinkpman pa la tolpa, “Melnum ur pa yo fik ur a kil pike alin atn kai wring wain alkilen pa, yatom kil kai ari, ari ake ngko, kalpm. ");
INSERT INTO uri_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Yatom kil la nasi melnum a ikghlen yo fik alkil pa la tolpa, ‘Ti wring wraur mit kupm kul ari yo fik pa ari ake wa ngko. Ti kitn ware yo pa om! Ekg nte, atn ti rkoln knokg wor ti kalpmel.’ ");
INSERT INTO uri_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ari melnum pa la tolpa, ‘Melnum, elntol itn ukwin tol wring wrij pa pen, ekg kupm al karkurn om hap klin pen. ");
INSERT INTO uri_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wring kanukg pa, kitn ari tolpa kil ngko pa, pa elntitn. Tol ake kil ngko pa, kitn ware ul.’ ” ");
INSERT INTO uri_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ak wang ur a arpm ekg yapm pa, Jisas kil piln yangkipm atn kahor wan ur a atning yangkipm a Maur Wailen atne pa. ");
INSERT INTO uri_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kin wrij ur a numpet pa arpm kahor wan pa ak wang ripa yat. Kin pa maur paitn ur arpmel, yatom ntekg yirokg akil pa ngkom tmpok tmpok, yatom ake ntie ekg al kil ngkom nipet, tolpa atn kai wring wampwam yikakwomit womwraur (18) ase. ");
INSERT INTO uri_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yatom wang a Jisas kil ariel pa, kil la nasel la tolpa, “Kitn pa, kul om! Numpet akitn pa apm kupm kwan ase.” ");
INSERT INTO uri_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yatom kil eln wam pa helel. Tolti, ak wang ketn ripa kil wreitn atn nipet wor, kil ukwor Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yatom melnum a ikghlen wan pa ipma wleket ekg Jisas ntekg numpet a kin pa wor ak wang a arpm ekg yapm pa, yatom kil la nasi tu wrong kinkpman pa la tolpa, “Tol kipm kul ak wang wampomit wampomwrij pa, ak wang a akwap pa ekg kil ntekg numpet akipm pa wor ak wang pake, wa ampur kipm kul ak wang a arpm ekg yapm pa.” ");
INSERT INTO uri_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ari Wailen kil akalmpentel la tolpa, “Kipm melnum a akplain plan ak num henen ti tolti. Ak wang a arpm ekg yapm pa, kipm pa yat, kipm kai wan a kau om nelkgen kau nongko aki donki alkipmen pa ye kai ekg uk hu al yat. ");
INSERT INTO uri_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ti kin ti, walyaru walmpopmen a Apraham pike maur paitn yipoel arpm tukol wring wampwam yikakwomit womwraur (18), tolpa yatom kupm wet nelkgen hmpei a ak yipoel ti ak wang a arpm ekg yapm ti. Om kipm ti la tolpa kupm ti akwap paitn tolhai?” ");
INSERT INTO uri_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kil akalmpe tolpa yatom ntekg tu a la paitnel kil pa numpaitn. Pake tu wrongwailet pa utopen paitn ekg kweiur kweiur weten worwor a kil ntekg ripa. ");
INSERT INTO uri_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisas kil ropon tu wrong kinkpman pa la tolpa, “Al kupm ak kuina ur ak la tolpa ekg wa kai hirhir tukol kingdom a Maur Wailen? ");
INSERT INTO uri_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Pa apm tukol mastet ek pake, a melnum wi, yatom arm kai wring alkilen pa. Yatom nip kaino tol yo pa, talpuk alm kai pa kai pa. Om wel pa kul akal ark hor talpuk alkil pa.” ");
INSERT INTO uri_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yatom wa Jisas roponten la tolpa, “Al wa kupm ak kuina ur ak la ekg wa kai hirhir tukol kingdom a Maur Wailen? ");
INSERT INTO uri_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Apm tukol yis pake. Kin ur pa wi waitketn tolti alung ak ro nak mringet pa kinar kuntuk mangkeyen wail pa, tolti nak pa paln kai wailmanten.” ");
INSERT INTO uri_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisas kil ngkom kai ha wail wail a ha wasok wasok ro tukgunakg lngkep a tu ekg yangkipm a Maur Wailen tolpa kai, akal kai Jerusalem. ");
INSERT INTO uri_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ari melnum ur pa ropontel la tolpa, “Wailen, ti hi wa Maur Wailen akwi melnum yikek tiur pa tolti ye kai ekg alkilen aki?” Ari wa Jisas akalmpenten la tolpa, ");
INSERT INTO uri_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kipm nikgwalpm arke ekg kai kahor wanyun wasok pa. Ekg nte, kupm la nasepm tolpa tu wailet hi wa wampen akal kai kahor wanyun wasok pa, pake hi ake ntie ekg tu kahor. ");
INSERT INTO uri_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Melnum yan a wan pa hi wa wreitn tolti kli wanyun pa, yatom hi kipm atn kahor hen pa klpon la tolpa, ‘Wailen, kukwanto wanyun ti!’ Pa hi kil akalmpentepm la tolpa, ‘Kupm akwekgel kipm pa, wa kupm akwekgel kipm pa a ha hai.’ ");
INSERT INTO uri_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hi wa kipm akalmpentel la tolpa, ‘Men pike al hu a ekpma ark wrij namponen kitn, kitn pike rowo tukgunakg lngkep ekg yangkipm a Maur Wailen hor ha alpmenen ti yat.’ ");
INSERT INTO uri_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Om hi wa kil akalmpentepm la tolpa, ‘Kupm akwekgel kipm pa wa kupm akwekgel kipm pa a ha hai. Ti kipm melnum a ntekg paitnpaitn pa, kipm wrongwailet kai tukuleinjopm om.’ ");
INSERT INTO uri_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ti kipm ti hi tu talpulntepm atn hen, yatom wang a kipm ari Apraham, Aisak, Jekob namponen tu melnum ek wripm a arpm kahor Kingdom a Maur Wailen pa, kipm hi wa hakg paitn wam itna ek. ");
INSERT INTO uri_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tu wrongwailet hi hakai takgni nowe, a takgni nare, ha kinar ti no ha kaino ti nar pa kul wi wrik ekg al ekpma kahor Kingdom a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kipm itning, melnum tiur a kanukg pa tu hi wa kai hep, wa melnum tiur a hep pa tu hi wa kul kanukg.” ");
INSERT INTO uri_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Yatom ak wang pa, tu Parasi tiur, tu kul la nasi Jisas pa la tolpa, “Ti kitn kai tukol ur ai tukulein ha ti pen! Ekg nte, Herot la akal hi wa kwateitn krong.” ");
INSERT INTO uri_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ari Jisas wa la nasen la tolpa, “Ti kipm kai la nasi nmpa mingken pa la tolpa kil hini pen, kupm ikwap kwan maur paitn, wa ntekg tu melnum numpet wor ik am ti hikg kil, yatom ik wang wraur pa kwap a kupm ak kil pa apm kai plaln ngko pake. ");
INSERT INTO uri_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tolpa ti, am ti, hikg kil, kwahikg pa, kupm akal ngkom kai, ekg nte, ake wor akal tu alm melnum ek wripm ur a Maur Wailen pa mo ha wrik ur manet pa, kalpm, hi wa tu alm mo hakai Jerusalem ai tolti. ");
INSERT INTO uri_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Woi, rein kitn Jerusalem! Kitn alm tu melnum ek wripm mo, kitn akweijel tu melnum yangkipm kuinen a Maur Wailen kwa kulnteitn pa. Wang wailet kupm akal lok tu warim alkitnen pa kai ark wrij tol krek man a ak tmpulo naren nampi alkilen pa, ari wa kitn hreteitn. ");
INSERT INTO uri_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tolpa ti Jerusalem kitn itning om, wan akitn pa hi wa kupm nuhurn atn ak kupuk kalpmel tolti. Ti kitn hi ake wa ariopm tolpa kai ngko wang a hi wa kitn laron kupm ti la tolpa, ‘Maur Wailen kwa melnum pa yatom kil nar, ti men ukwel wor kat nang alkilen.’ ” ");
INSERT INTO uri_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ak wang ur a arpm ekg yapm pa, Jisas kil kai akal al ekpma kai wan a melnum wail ur a tu Parasi pa, ari tu wrongwailet pa tu ikgarpmel. ");
INSERT INTO uri_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ari melnum ur a wi numpet a numpwam hurn pa, kil arpm yampingken Jisas pa. ");
INSERT INTO uri_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yatom Jisas ropon tu melnum a arpmen yangkipm yiprokgen a Maur Wailen pa, wa namponen tu Parasi pa la tolpa, “Ti yangkipm titnongket alpmento pa la tolhai, ntie ekg akal ntekg tu melnum a numpet pa paln wor ak wang a arpm ekg yapm aki, kalpm e?” ");
INSERT INTO uri_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ari tu pa ake la kwei ur, yatom kil wamparpme melnum pa kwan numpet akil pa tukuleinjel tolti, wa kwawel kai. ");
INSERT INTO uri_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yatom kil la nasen la tolpa, “Ti tol warim kpman ur aki wa kau nongko ur akipm pa ngko eln kinar hu kapmet ur pa ak wang ur a arpm ekg yapm pa, ake ntie ekg al kipm rkolntel ye no tukulein hu pa ak wang ripa aki?” ");
INSERT INTO uri_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ari ake ntie ekg tu akalmpe yangkipm ripa. ");
INSERT INTO uri_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yatom Jisas kil ari tu melnum tiur a tu kwewen kul ekg akal tu al ekpma pa, tu wi wrik worwor pa arpme, yatom kil la nasen yangkipm kla ur pa la tolpa, ");
INSERT INTO uri_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Wang a melnum ur kweweitn ekg ekpma wail ur a ntekg al itnen kin kpman a ye tita pa, ampur kitn kai arpme wrik wor pa hep. Kitn eln wrik pa hi ekg uk kmel wail ur a hangken kitn ti pike kil kwe pa akal kul arpme. ");
INSERT INTO uri_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kitn ti arpme pa, melnum a kwewepm yaten pa akal kai la naseitn tolpa, ‘Ai, kitn eln wrik ti elnthi ekg melnum wail ti.’ Tolpa ti kitn wa numpaitn ekg kil la naseitn la tolpa kitn wreitn tukulein wrik ti kinar irpm kunukg kinar yirokg ai. ");
INSERT INTO uri_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tolpa ti wang a tu kweweitn pa, kitn kai irpm kunukg hep pen, yatom tol melnum a kweweitn pa arieitn plaln pa, pa kil la naseitn la tolpa, ‘Yek alkupm, wreitn kaino irpm wrik wor ai.’ Tolpa ti kitn pa wi nang wail kai ikg a tu mla ur a kipm al ekpma ark wan pa. ");
INSERT INTO uri_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ekg nte, melnum a kat kil alkil pa, hi wa tu arkuel kinar knokg. Wa melnum a arku kil alkil pa, hi wa tu katel kaino kwa.” ");
INSERT INTO uri_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yatom Jisas kil la nasi melnum a kwewel pa la tolpa, “Tol kitn ntekg ekpma wail ur pa, ampur kitn kwe tu melnum worwor alkitnen pa, aki wasok wail alkitnen, aki yiprokgen ur alkitnen, aki tu alkitnen a kipm ark wrij a arpm ntie pa. Ekg nte, wang ur a hi wa tu ntekg ekpma wail pa, hi wa tu kweweitn akalmpe a pike kitn kwewen pa. ");
INSERT INTO uri_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kitn akal ntekg ekpma wail ur pa, kitn kwe tu melnum a arpm warkip, tu a numpwam paitnen, wa tu melnum a nepm paitnen, a ikg paitnen. ");
INSERT INTO uri_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kitn aklin tu a tolpa pa, kitn akwap wor pake, kitn utopen om! Ekg nte, tu pa ake ntie ekg hi wa akalmpenteitn. Hi wa Maur Wailen kil alkil akalmpenteitn ak wang a tu melnum nipet wor pa wreitn ha kirkhap ai.” ");
INSERT INTO uri_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wa melnum wrij ur a ntien al ekpma arpm pa, atning yangkipm a Jisas la pa, yatom kil la nasel la tolpa, “Mla ur a hi wa al ekpma wail kahor Kingdom a Maur Wailen pa, kil pa wor pake, kil utopen om!” ");
INSERT INTO uri_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ari wa Jisas kil akalmpentel la tolpa, “Melnum wrij ur pike kil akal ntekg ekpma wail, yatom kil kwa yangkipm kai la nasi tu wrong wailet pa la tolpa, hi wa tu kul ekg ntiel arpm al ekpma pa. ");
INSERT INTO uri_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ak wang a kil numprampen ekpma pa arpm pa, kil kwa melnum akwap kalpmel alkilen pa kai ari tu a pike kil kwewen ekg akwiyen ye kul yatom wa la nasen la tolpa, ‘Kipm kul om, kweiur kweiur wrongwailet apm numprampen yat ase!’ ");
INSERT INTO uri_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kil kai akal akwiyen kul, ari tu wrongwailet la tolpa tu arke ekg kweiur kweiur wrongwailet, ti tu ake al kai. Yatom melnum ur pa la nasel la tolpa, ‘Woi, reinjeitn ekg kupm arke. Knokg ur a kupm armpen kil, ti kupm apm kai ari kilke. Ti kupm ake al kai.’ ");
INSERT INTO uri_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wa ur pa la nasel la tolpa, ‘Woi, reinjeitn, ekg kupm arke ekg kau nongko wampwam kupm armpen ti, ti kupm al kai wiyen ekg ak ak kwap hep pen, tolpa ti ake ntie ekg kupm kai.’ ");
INSERT INTO uri_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wa ur pa la tolpa, ‘Kupm wet ti wi kin ti pen, ti ake ntie ekg kupm nuhurntel kai.’ ");
INSERT INTO uri_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Yatom melnum akwap kalpmel pa wa kai nasi melnum yan a numprampen ekpma pa la tolpa tu arke, ti tu ake al kul. Kil atning a tu la tolpa yatom kil ipma wleket paitn, om kil la nasi melnum ak kwap kalpmel alkilen pa la tolpa, ‘Tolpa ti kitn iktutu kai hor ya wail wail a ya wasok wasok a ha wail ripa kor ik nakur tu melnum a arpm warkip, tu a numpwam paitnen, tu a nepm paitnen, a ikg paitnen ai kul!’ ");
INSERT INTO uri_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Yatom melnum akwap kalpmel alkilen pa apm kai ak komkiti tol a kil la pa, yatom kil wa pleln kul la tolpa, ‘Wailen, ekla a kitn la pa kupm katnun, pake wrik tiur ha ti pen.’ ");
INSERT INTO uri_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ari wa melnum yan a numprampen ekpma pa la nasel la tolpa, ‘Ti kitn wa nuhurn ti kai hor ya wailwail a ya waitketn ketn ai hor wringya kweiur kweiur pa, kor kwewen la nasen titnongket ekg tu wreitn kulngkul wan a kupm ti nti. ");
INSERT INTO uri_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ti kupm la nasepm tolpa, tu melnum a kupm kwewen hep pa, ake ntie ekg hi wa ur al ekpma wail akupm pa, kalpm!’ ” ");
INSERT INTO uri_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ak wang wrij ur pa, tu wrong wailet paitn nti Jisas pa ngkom kai, yatom kil pleln la nasen la tolpa, ");
INSERT INTO uri_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kitn mla ur a kul ekg kupm ti, pake ake wa kitn uk yirokg manjan, kin warim, muinwror muitnwror, wa kitn alkitn ti yat pa, kitn ake ntie ekg paln tukol disaipel akupm ti. ");
INSERT INTO uri_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wa melnum a katnuntopm pa, pake ake kil arki yo kwatingki alkilen pa, kil ake disaipel akupm ti. ");
INSERT INTO uri_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tol kipm ur akwonalmpen akal ntekg wan wlop wlop kaino kwa pa, kitn irpm ikwonilmpen hep plaln ekg marpm a ak ntekg wan ripa pen. Hi wa kitn ntie ekg ak ntekg wan pa plaln pa, pa kitn ik ntekg. ");
INSERT INTO uri_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pake tol kitn uwen hong pa alil hmpangkil pa tolti, ari ake kitn ntie ekg ntekg wan pa plaln pa, tu arieitn pa, hi tu akeitn nokg. ");
INSERT INTO uri_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Hi tu wa la tolpa, ‘Melnum ti katen kwap ti, ari ake wa kil ntie ekg kil ak pa kai plaln.’ ");
INSERT INTO uri_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Wa tol melnum tukgunakgen ur kil wi wrong wasok ur a kmel 10,000 a kil pa ye kai ekg hripon namponen wrong wail ur a kmel 20,000 a melnum tukgunakgen ur pa, kil akal arpm ekg akwonalmpen hep pen, wrong wasok ripa, al tu ntie ekg hangken tu wrong wail ripa aki kalpm e. ");
INSERT INTO uri_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tol ake kil ntie pa, akal kil kwa melnum yangkipm kuinen tiur pa kai ekg ari ropon melnum tukgunakgen ripa ngko ya pa la nasel la tolpa, ‘Al men ntekg kuina ur ekg ak ntekg ipma a kitn ti pa paln wor?’ ");
INSERT INTO uri_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Tolpa ti kupm la nasepm la tolpa, tol melnum ur ake kil uk yirokg kweiur kweiur alkilen pa, kil ake ntie ekg paln disaipel akupm.” ");
INSERT INTO uri_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Nokg pa nokgij wor pake, tol kil kupuk pa, ake ntie ekg mento wa ntekg ekg kil wa paln nokgij. ");
INSERT INTO uri_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ti nokg kupuk paitn a tolpa, pa ake wa ak ntekg nep a hamung pa nip wor yat. Ti men piln kai hup yipik tolti. Ti tol kipm melnum a nungkulkg itnentepm pa, kipm itning om!” ");
INSERT INTO uri_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wang wrij ur pa, tu melnum a wi takis marpm a tu, wa tu melnum tiur a ntekg paitnpaitn pa, kul akal atning yangkipm a Jisas piln pa. ");
INSERT INTO uri_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ari tu Parasi, wa namponen tu melnum a arpmen yangkipm yiprokgen a Maur Wailen pa, nel ipma paitn ekg pa, yatom nel la tolpa, melnum pa wa kai atn hor wrij wa al ekpma nti tu melnum a ntekg paitnpaitn pa ekg nte? ");
INSERT INTO uri_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yatom Jisas la nasen yangkipm kla ur a la tolpa, ");
INSERT INTO uri_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ti tol kipm ur ikghlen sipsip kmel wampomit (100), yatom wrij ur pa kai ham pa, al kitn ntekg tolhai? Kitn akal nuhurn 99 pa atn wrik wor pa, wa kai kor wrij ur pa, kaingkai, kitn hantil. ");
INSERT INTO uri_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kitn hantil pa, pa kitn kat piln kaino mlem, yatom kitn utopen paitn tolti apm ye kai ha ase. ");
INSERT INTO uri_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Yatom kitn kwe tu melnum wokgen alkitnen a tu hawrij alkitnen pa tolti kul, yatom kitn la nasen la tolpa, ‘Kupm utopen paitn ekg kupm hantil sipsip wrij ur akupm a pike ham. Tolpa ti mento utopen ntekg ekpma il.’ ");
INSERT INTO uri_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ti apm wa tolpake, kupm la nasepm la tolpa, tu a arpm kaino ha wor pa, tu utopen paitn ekg melnum paitn wrij ur a kil pleln ipma. Pake tu ake utopen ekg melnum 99 a akwonalmpen tolpa tu pa nipet wor ase.” ");
INSERT INTO uri_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Aki tol kin ur pa kil ye marpm ek wampwam, ari wrij ur pa ngko kai ham pa, akal kil ntekg tolhai? Akal kil nihil wakg ti ak kor kai ari kalpm pa, kil kingkim yipik wan ti hrongke kor ikgen tolpa kaingkai, kil hantil. ");
INSERT INTO uri_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kil hantil plaln pa, kil kwe tu melnum wokgen a hawrij akil pa kul om, wa kil la nasen la tolpa, ‘Kupm ti utopen paitn, ekg marpm a ham pa apm kupm hantil ase. Ti mento utopen ntekg ekpma il.’ ");
INSERT INTO uri_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ti apm wa tolpake, kupm la nasepm la tolpa, wang a melnum paitn wrij ur kil pleln ipma pa, tu maur akwapel a Maur Wailen pa utopen paitnpaitn.” ");
INSERT INTO uri_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yatom Jisas kil wa la tolpa, “Yan ur pa, warim kpman wekg. ");
INSERT INTO uri_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yatom wasok pa la nasi yan alkil pa la tolpa, ‘Kitn ro kweiur kweiur wompel akupm ti ukopm.’ Yatom yan pa wreitn tolti, wa nampreng kweiur kweiur pa uk warim kpman wekg alkil pa. ");
INSERT INTO uri_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Plaln pa, wasok pa arpm wang aripm ur tolti, kil wi kweiur kweiur alkil ti ak wi marpm pa, plaln pa, kil wreitn tolti kai arpm tol ha watin ur ai. Kil arpm ha pa, kil piln marpm alkil pa plaln kai ekg kweiur kweiur a paitnpaitn tolti. ");
INSERT INTO uri_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kil piln marpm alkilen pa tolpa kaingkaing kai plaln pa, wangnikg wail paln kai ha pa, yatom ak ntekg kil pa arpm warkip wrijen paitn tolti. ");
INSERT INTO uri_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yatom kil kai ari melnum ur a ha knokg pa, om kil ropontel la tolpa, kil akal ak kwap ur. Yatom kil ukwel kwap a uk mnto atn kai wrik a eln mnto atne. ");
INSERT INTO uri_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ari ake melnum ur ukwel ekpma ur, yatom kil akwonalmpen tolpa, kil akal nti mnto pa al yamingkit palk a tu ye kai alung uk mnto al pa, ari kalpm, tu lokel ekg ake akal kil al ekpma a mnto. ");
INSERT INTO uri_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ari nikgwalpm wor pa palntel, yatom kil akwonalmpen kai kil alkil pa tolpa, ‘Tu melnum akwap marpm ekg yan akupm pa, tu ntie ekpma wailet ekg al, pake kupm apm mo ekg nikg arpm tike! ");
INSERT INTO uri_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ti kupm wreitn wa kai ekg yan alkupmen ayom, yatom al kupm la nasel la tolpa, “Yan, rein, kupm ntekg paitn kai ikg a Maur Wailen wa kai kitn yat. ");
INSERT INTO uri_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ti kupm ti ake wor ekg akal kitn kweopm tolpa warim kpman alkitnen pa. Ntekg kupm ti tol melnum akwap marpm ekg kitn!” ’ ");
INSERT INTO uri_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kil akwonalmpen tolpa, kil wreitn tolti kai ekg yan alkilen. Yan alkil pa ikg kai ariel kai watin ai, wa kil rein paitn, yatom kil aktutu kai tolti arkulel, nakrontel. ");
INSERT INTO uri_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yatom kil la nasi yan alkil pa la tolpa, ‘Yan, kupm rein ekg kupm pike ntekg paitn kai ikg a Maur Wailen wa kai ikg a kitn yat. Tolpa ti kupm ti ake wor ekg kitn kweopm tolpa warim kpman alkitnen pa.’ ");
INSERT INTO uri_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ari yan alkil pa kwe tu melnum akwap kalpmel alkilen pa la tolpa, ‘Kipm iktutu kul! Kipm ye hapm wor ur pa ye kul ekg nowel, wa wi marpm pa ye kul ekg elntel irpm kai wam hpij pa, wa wi nepm palk pa ye kul ekg nowel kai nepm ti yat! ");
INSERT INTO uri_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kai ilm kau wlampien ur a num itnen pa ekg al mento ntekg ekpma ntiel al. ");
INSERT INTO uri_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ekg nte, warim kpman alkupmen kil, tol apm pike mo ur ase, ari wa wreitn wa arpm. Wa kil apm pike nuhurnto kai wrijen ase, ari wa kil wa kulnto tike.’ Kil la tolpa yatom tu pa ntiel utopen ark. ");
INSERT INTO uri_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Yatom ak wang pa, warim kpman wailen pa kil hakai wring pa kul yampingken wan ha ti pa, kil atning tu utopen wa ntekg nangnang pa, ");
INSERT INTO uri_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","om kil kwe melnum ur pa kul, om kil ropontel la tolpa, ‘Tu ntekg nangnang ekg kuina ur ai?’ ");
INSERT INTO uri_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ari wa melnum pa akalmpe la tolpa, ‘Wasok alkitnen pa apm wa kul ase, yatom yan alkipmekgen pa alm kau wlampien wrij ur a num itnen pa, ti kil utopentel ekg kil ake kai paitn, aki mo ur pa kalpm, kil arpm, yatom apm wa kulntel ase.’ ");
INSERT INTO uri_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Wailen pa nikgwalpm paitn ekg wasok alkil pa, yatom kil ake akal kahor wan pa, ari yan alkil pa hor armwonel akal tuwekg kahor wan pa. ");
INSERT INTO uri_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ari kil la kai yan alkil pa la tolpa, ‘Wring wailet paitn kupm ak kwap ekg kitn ti tol melnum akwap kalpmel tolti. Ake wa kupm nungkulkget ak wang ur. Ake pike kitn ukopm kweiur! Ti ake wa kitn ukopm meme wlampien ur ti ekg kupm ntekg ekpma ur al namponen tu yiprokgen alkupmen ti! ");
INSERT INTO uri_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Warim a kitn ti pa, kil pike piln kweiur kweiur worwor akil pa kai ekg tu kin a atn ya wa kil wa kul pa, wa kitn wa alm kau wlampien a num itnen pa, yatom wa ntekg ekpma al nti kil pa ekg nte?’ ");
INSERT INTO uri_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ari wa yan pa akalmpentel la tolpa, ‘Warim alkupm, apm mentekg arpm ha tike, ti kweiur kweiur wrongwailet akupm ti pa apm akitn pake. ");
INSERT INTO uri_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pake mento akal ntekg ekpma al a utopen, ekg nte wasok alkitnen ti tol pike apm kai mo ur ase, ari wa kil arpm. Wa kil pike nuhurnto kai wrijen ase, ari wa kil wa akwonalmpento, yatom kil apm wa kulnto tike.’ ” ");
INSERT INTO uri_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yatom wa Jisas la nasi tu disaipel alkilen pa la tolpa, “Melnum ur pa, kil ntie kweiur kweiur wailet, yatom ak wang ur pa tu tiur kul la nasel la tolpa, ‘Melnum akwapel atn hep alkitnen ti ake ak kwap a kitn ti ariworwor. Kil ntekg paitnel kweiur kweiur alkitnen pa ekg al kai plaln pake.’ ");
INSERT INTO uri_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yatom kil kwe melnum akwapel atn hep ripa kul tolti, om wa kil la nasel la tolpa, ‘Kupm atning yangkipm a tu la tolpa, kitn ti ak kwap paitn. Ti kitn kai ro nangkel kweiur kweiur wrongwailet alkupmen a kitn ikghlen pa, om kitn plaln ekg ak kwap akupm ti.’ ");
INSERT INTO uri_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yatom melnum pa akwonalmpen tolpa, ‘Ai, hi wa kil kwantopm tukulein kwap akupm ak tike. Ti al kupm ntekg tolhai? Ti kupm ti ake ntie titnongket ekg ak kwap wringkya kweiur kweiur pa, wa kupm numpaitn ekg ak ekla kweiur kweiur atu. ");
INSERT INTO uri_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pake kupm ari ya ur kil: al kupm aklin tu mla ur ai hep pa, ekg hi wa kil kwantopm ekg kwap a kupm ak ti pa, hi wa kupm wonklin kweiur kweiur a pike kupm uk tu hep pa.’ ");
INSERT INTO uri_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yatom kil kwe tu a pike wi kloken kai melnum a kil aken kwap pa kul. Yatom kil ropon tu pa wrij wrij la tolpa, ‘Kitn pike wi kloken aripm kai melnum a kupm aken kwap ti?’ Ari wa ur pa akalmpe la tolpa, ");
INSERT INTO uri_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Kupm wi hu yuwa tol wampeng wail kmel wampomit (100).’ Yatom wa kil la nasel la tolpa, ‘Ti kitn wi wurkapm hel kai wrik pa om ye kul, pirpiren kule kmel wampomit (100) pa, om ro kmel wekg tuwek wampwam (50) ti tolti iktutu.’ ");
INSERT INTO uri_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wa kil ropon ur pa la tolpa, ‘Kitn wi nmong aripm?’ Wa kil pa la tolpa, ‘Kupm wi wit ek nmong kmel wampomit (100).’ Yatom wa kil la nasel la tolpa, ‘Ti kitn wi wurkapm kil om kule kmel wampomit (100) pa wa ro kmel witnweitn (80) tolti!’ ");
INSERT INTO uri_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yatom melnum a ntie kweiur kweiur wailet pa kporn yangkipm la nasi melnum akwapel alkil a lokarku kweiur kweiur alkilen pa la tolpa, ‘Ya tiur a kitn ak pa kitn ak wonrekele wor ekg ak aklin kitn alkitn.’ Ekg nte, tu melnum a katnun kuina ur a atn knokg ti pa tu ak kwap wonrekele kai kuin a tu alntu ti hangken tu melnum a wi klalen a Maur Wailen pa.” ");
INSERT INTO uri_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jisas la yangkipm kla pa kai plaln pa, wa kil la tolpa, “Ti kupm la nasepm la tolpa, kipm ik kweiur kweiur a kipm ntie atn knokg paitn ti ak aklin tu mla ur pa ekg al ntekg tu pa paln melnum wor alkipmen, ekg hi wa ak wang a kweiur kweiur pa kai plaln pa, hi wa Maur Wailen wiyepm ye kai ha wor a arpm aklei wang, wa wonklin kweiur kweiur a pike kipm uk tu pa. ");
INSERT INTO uri_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ti tol mla ur a wor ekg ikghlen kweiur kweiur wasikyikek pa, kil pa wa wor ntie ekg ikghlen kweiur kweiur wailwail pa yat. Wa apm tolpake, melnum a ikghlen paitnel kweiur kweiur wasikyikek pa, pa kil hi wa ikghlen paitnel kweiur kweiur wailwail pa tolpa yat pake. ");
INSERT INTO uri_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ti tol ake kipm ikghlen kweiur kweiur a atn knokg paitn ti ariworwor pa, ti hi wa mla ur ukwepm kweiur kweiur worwor a atn aklei wang pa ekg kipm ikghlen? ");
INSERT INTO uri_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ti tol ake kipm ikghlen kweiur kweiur a melnum manet pa ariworwor pa, ti hi wa mla ur ukwepm kweiur kweiur alkipmen a aknamputepm pa? ");
INSERT INTO uri_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ti melnum ur ake ntie ekg al kil eln melnum wekg pa atn hep yaten ekg kil, pa wa kil wi paitn la ur, wa wi wor la ur, aki wa kil wakrongen ur pa, wa kil ipma paitn ekg ur pa. Ti ake ntie ekg al kipm hor hanekgel kweiur kweiur wekg pa tol tita, Maur Wailen, a marpm kweiur kweiur pa.” ");
INSERT INTO uri_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pake wa tu Parasi pa tu melnum a arikowe marpm yatom, wang a tu atning yangkipm a Jisas kil la tolpa pa, tu la paitnel kil. ");
INSERT INTO uri_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yatom Jisas la nasen la tolpa, “Kipm ti plan kipm alkipm ti ekg al tu wrong kinkpman ariepm lak kipm ti melnum nipet wor, pake Maur Wailen pa ariepm kahor nikgwalpm wonen alkipmen ai. Kuina ur a kipm melnum ti ari lak wor pa, Maur Wailen pa kil ari la tolpa pa paitn wrijen.” ");
INSERT INTO uri_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jisas kil wa la tolpa, “Ti tol yangkipm titnongket a Moses, wa yangkipm a tu melnum ek wripm a Maur Wailen ro pa, apm pike ukwepm arie tolpa kul ngko Jon pa. Yatom Jon pa pike kil katen ekg laron yangkipm wor a la Kingdom a Maur Wailen. Yatom tu wrongwailet apm tu nikgwalpm arken aken kwap titnongket ekg akal kahor kingdom a Maur Wailen ripa. ");
INSERT INTO uri_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ktnong a knokg pa hi wa kai plaln, pake yangkipm titnongket a Maur Wailen ti pa, hi apm atn kiti kiti tolpa atn pake. Hi ake yangkipm ketn ur pa kai ham, kalpm.” ");
INSERT INTO uri_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jisas la tolpa plaln pa, wa kil wa la tolpa, “Ti tol melnum ur a kil kwan kin alkil, om wa wi kin weten ur pa, pa kil kli arkul kin ripa, wa melnum ur a wi kin ur a kpman ur manet kwan pa, pa wa kil kli arkul kin ripa yat.” ");
INSERT INTO uri_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisas la kiti melnum wekg ur pa la tolpa, “Melnum ur pa kil ntie kweiur kweiur worwor wrongwailet. Kil nowe hapm worwor nakure numpwam ariworwor wa ntekg ekpma worwor wailwail al aklei wang. ");
INSERT INTO uri_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Wa melnum ur a tu kwe la tolpa Lasarus pa, kil arpm warkip ekg kweiur kweiur wrongwailet. Kil pa hi al hor numpwam a kil ti plaln. Kil pa tu yewel kul aklei wang apm arpm wanyun a melnum a arpm ntie pake. ");
INSERT INTO uri_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kil akal al ekpma hprap a ngko ha hor knokg a melnum a ntie kweiur kweiur worwor arpm ekg al ekpma pa. Wa tu nmpa pa aklei wang pa kul npla al hi akil pa atn. ");
INSERT INTO uri_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tolpa kaingkai, Lasarus kil mo, yatom tu maur akwapel a Maur Wailen wi maur wor alkilen pa ye kaino arpm wor namponen Apraham ase. Wa melnum a ntie kweiur kweiur worwor wailet pa wa kil mo yat yatom tu uwentel. ");
INSERT INTO uri_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Maur wor alkilen pa kai arpm wrik a tu melnum a mo kai arke pa, kil wi wleket paitn, yatom kil ikg kaino kwa ari Lasarus pa namponen Apraham pa arpm kaino watin ai. ");
INSERT INTO uri_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yatom kil kwe tolpa, ‘Yeye Apraham, kitn reinjopm pen! Kitn kwa Lasarus pa kil ik wam pa nong hu ketn ur pa, yatom eln poln eln nar krong akupm kil pen! Numpwam akupm ti wakg itne wleket paitn tolti.’ ");
INSERT INTO uri_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ari wa Apraham la nasel la tolpa, ‘Warim alkupm, kitn ikwonilmpen wang a pike kitn arpm kinar knokg pa, kitn pike arpm ntie kweiur kweiur worwor wrongwailet, pake Lasarus kil pike arpm warkip. Ti ak wang ti apm wa tolpake, kil wi wang wor utopen arpm wor kilke, wa kitn pa wi wleket arpm paitn pake. ");
INSERT INTO uri_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Wa kwei ur yat, watu wailmanten pike kitin atn kuin ak ro mento ti, tolpa ti ake ntie ekg akal men ti kai ariepm aki, kipm pa kul ario pa, kalpm.’ ");
INSERT INTO uri_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ari melnum a ntie kweiur kweiur worwor wrongwailet pa la nasi Apraham pa la tolpa, ‘Tolpa ti, yeye, kitn la nisi Lasarus pa la tolpa kil kinar wan a yan alkupmen pa, ");
INSERT INTO uri_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","yatom la nisi tu wasokwasok wampomit alkupmen pa titnongket, ekg al tu ngkom nlokgen ya wleket paitn a kupm hore kil!’ ");
INSERT INTO uri_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ari wa Apraham akalmpe la tolpa, ‘Yangkipm wurkapm a pike Moses namponen tu melnum ek wripm a Maur Wailen ro pa apm ntien ha pake. Tu itning kutnun yangkipm ripa om.’ ");
INSERT INTO uri_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ari wa melnum pa la tolpa, ‘Yeye Apraham, tolpa kalpm, pa ake ntie. Tol melnum ur a pike mo ti wreitn ha kirkhap ti om kinar la nasen tolpa pati, al tu pleln ipma pake.’ ");
INSERT INTO uri_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ari Apraham kil la tolpa, ‘Tol ake tu atning om katnun yangkipm a Moses pa namponen tu melnum ek wripm a Maur Wailen pa, pa hi ake wa ntie ekg tu atning yangkipm a melnum a pike mo om wa wreitn ha kirkhap pa la pa.’ ” ");
INSERT INTO uri_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yatom Jisas la nasi tu disaipel alkilen pa la tolpa, “Kweiur kweiur a ak rkolo ekg mento ngko kai paitnpaitn pa apm tolpa atn pake, pake rein paitn ekg melnum a kil rkol melnum ur yatom kil ngko kai paitnpaitn pa, pa kil hi wa wi paitn. ");
INSERT INTO uri_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Melnum a kil ntekg melnum ur a ake atn titnongket pa ngko kai paitnpaitn pa, pa kil ntekg paitn wrijen ai. Tol wa tu ak hmpei yipo weij tengket wail ur arpm krongkel kil pa om pilntel eln kai hunokg pa, pa waitketn. Pake kil hi wa wi paitn wail wrijen hangken ripa. ");
INSERT INTO uri_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ti kipm irpm ri! Tol wasok ur aki wailen ur alkitnen pa ntekgeitn paitn pa, kitn lokel titnongket ekg ake al kil ntekg paitn pa. Pake tol kil la rein paitn a kil pa, kitn nuhurn paitnpaitn a kil ntekg pa om. ");
INSERT INTO uri_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pake wa tukol kil ntekgeitn paitn nti wailet ak wang wrij ur pa yatom wa kil kul la rein nti wailet pa, kitn nuhurn paitnpaitn a kil ntekg pa.” ");
INSERT INTO uri_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yatom tu melnum yangkipm kuinen a Jisas pa la nasi Jisas pa la tolpa, “Men wakrongen tolpa kitn ntekg men ti ukpma titnongket.” ");
INSERT INTO uri_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ari Wailen kil akalmpenten la tolpa, “Wor pa, tol a kipm ukpma waitketn tol mastet ek pa, ti tol wa kipm la nasi yo wail riai la tolpa, ‘Ti kitn nalu kitn alkitn ti katen klung kinar nip itn kinar hunokg kuin ai’, kil apm atning yangkipm tol a kipm la pake.” ");
INSERT INTO uri_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ti tol mla ur kai kuin a kipm pa la nasi melnum akwap kalpmel ekg kil pa la tolpa, ‘Kitn kai ikwap kai wring akupm aki kai ikghlen sipsip a kupm.’ Wang a kil wa kul ha pa, ake al kipm la tolpa, ‘Kitn kul iktutu om kitn irpm om il ekpma ti om!’ ");
INSERT INTO uri_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tolpa kalpm. Kipm al la tolpa, ‘Kitn numprampen ekpma ntekgtopm ekg kupm ti hep ekg iklin kupm ti il, plaln pa, wa kitn wa kai il knukg ul.’ ");
INSERT INTO uri_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ake wa kipm pa ukwel wor pa, kwap a tu melnum akwap kalpmel pa apm tu ak tolpake. Ti al wa kipm ukwel wor ekg nte? ");
INSERT INTO uri_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ti kipm ti apm tolpake, tol kipm ntekg kuina ur a pike Maur Wailen lak kipm ntekg pa, plaln pa, kipm la tolkil, ‘Ampur kipm ukwor kat nang amen ti, plpa men ak kwap alpmenen tolti.’ ” ");
INSERT INTO uri_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas kil ngkom hor ya pa kinar tolpa akal kinar Jerusalem pa kil kinar ngko kirngkuwak a Samaria a ha knokg Kalili uk tita pa. ");
INSERT INTO uri_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Yatom kil kai paln kai ha ur pa, kil ikg kai ari melnum numpet wampwam a hi kark wien pa tu kul atn kai watin ai, ");
INSERT INTO uri_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","yatom nel kwewel la tolpa, “Melnum Wailen Jisas, kitn reinjo pen!” ");
INSERT INTO uri_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisas arien, om la nasen la tolpa, “Ti kipm kai plan numpwam alkipmen ti kai ekg tu melnum ipma krakgen a Maur Wailen pa ekg tu riepm pen.” Tu atning tolpa, om tu kai ngko ya pa ari numpet a tu pa apm paln wor ase wa tu paln wri wor kai ikg a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yatom wrij ur alntuen a paln wor pa kil ari tolpa yatom, kil pleln tolti tpra kat nang a Maur Wailen pa yikaktnen tolpa pleln hor ya pa kul ekg Jisas pa. ");
INSERT INTO uri_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yatom kil eln ngko wonteipur ha nepm a Jisas ti ukwel wor. Melnum pa kil melnum a ha knokg Samaria. ");
INSERT INTO uri_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Wa Jisas ropo la tolpa, “Melnum wampwam wet paln wri wor ti, ti wampomit wampomwitnweitn pa haike? ");
INSERT INTO uri_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ntekg tolhai yatom wa melnum wrij ur a ha manet ur ai tolti wa kul kat nang a Maur Wailen ti?” ");
INSERT INTO uri_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yatom Jisas la nasi melnum pa la tolpa, “Kitn wreitn kai om! Wa kitn ukpma titnongket tolpa yatom, numpet akitn apm paln wor ase.” ");
INSERT INTO uri_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Yatom tu Parasi tiur pa ropon Jisas la tolpa, “Wang a hi Kingdom a Maur Wailen nar pa ak wang kuina?” Ari wa kil akalmpe la tolpa, “Kipm ake ntie ekg ari ak ikg kweiur kweiur a plan tolpa Kingdom a Maur Wailen apm nar ase. ");
INSERT INTO uri_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ti ake al ur la tolpa, ‘Ti atn ti’ aki, ‘Ti atn kai atn ai e’, ekg nte, Kingdom a Maur Wailen pa apm ntiepm atn tike.” ");
INSERT INTO uri_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yatom kil la nasi tu disaipel alkilen pa la tolpa, “Wang ur hi wa paln pa kipm hi wa wakrongen paitn lak al ari wang wrij ur a kipm ari Warim Kpman a Melnum pa, pake kipm hi ake ntie ekg ari. ");
INSERT INTO uri_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ti tiur hi wa la nasepm la tolpa, ‘Ti atn kai ai’. Wa tu tiur pa hi wa la nasepm la tolpa, ‘Ti atn ti.’ Pake ampur kipm aktutu katnunten, om kor kai pa kai pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ak wang a Warim Kpman a Melnum pa nar pa, hi wa paln pa, kipm hi ari tukol mring malo a plaij hor kaino ktnong pa. ");
INSERT INTO uri_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pake hep pa kil hi wa ye kalkuten, wa tu melnum a ak wang ti pa hi wa ukwel yirokg pa pen. ");
INSERT INTO uri_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kuina ur a pike tu ak ak wang a Noa pa, ti hi apm wa tu ak tolpa ak wang a Warim Kpman a Melnum kil wa nar yat pake. ");
INSERT INTO uri_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tu wrongwailet pike wi kin pa alupm ekpma yelan ye kai uk tita, ntekg ekpma al ark tolpa kai ngko wang ketn a Noa kil kai kahor wan hunokgen pa, hu wail wei nar ak alen. ");
INSERT INTO uri_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ti hi wa paln tukol pike ak wang a Lot pa yat. Wrongwailet pike ntekg ekpma al, armpen kweiur kweiur, ak kweiur kweiur wi marpm, ntekg wring, a wan tolpa kai pake, ");
INSERT INTO uri_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","kai ngko wang a Lot kil nuhurn Sotom pa, wakg wailmanten namponen weij wakget tukol weij karin a tu lap ti hakaino ktnong ti nar, ake hu a wei pa, tolti lapen yekmeket tolti. ");
INSERT INTO uri_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ti wang a Warim Kpman a Melnum pa paln ngko wurknong pa, apm hi tolpake. ");
INSERT INTO uri_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tukol melnum a arpm kahor wan kling pa, ampur wa kil kahor wan wonen pa ekg wi kweiur kweiur tiur alkilen pa. Wa tol melnum a kil atn kai wring pa, ampur kil wa pleln kul ha pa. ");
INSERT INTO uri_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ti kipm ikwonilmpen kin a Lot pa! ");
INSERT INTO uri_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yatom mla ur a kil ikghlen numpwam alkil pa ye num alkil kark pa, maur wor alkilen pa hi wa kai paitn. Pake mla ur a kil piln num alkil pa, maur wor a kil pa hi ake wa kai paitn. ");
INSERT INTO uri_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kupm la nasepm la tolpa, hi ak mning pa, melnum wekg a hokga wrik wrij pa, wrij ur pa hi wa kil wi, wa wrij ur pa hi wa kil nuhurn hokga wrik pa. ");
INSERT INTO uri_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Wa kin wekg ur a ntekg wakg kuntuk arpm wrij pa, wrij ur pa hi wa kil wi, wa wrij ur pa hi wa kil nuhurn elntarpm pa.” ");
INSERT INTO uri_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yatom tu melnum akwapel alkilen pa ropontel la tolpa, “Wailen, ti kweiur kweiur pa hi wa paln atn kai hai?” Ari Jisas wa akalmpe la tolpa, “Kipm hi wa ari wel kmong a ho rkam hel pa pati, kipm ari tolpa, kil ari wlikgek ur a kil akal al pa apm arpm pake.” ");
INSERT INTO uri_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yatom Jisas la nasen yangkipm kla ur pa ekg al tu wi arie yatom al tu ropon Maur Wailen pa aklei wang, ake al tu elnten. ");
INSERT INTO uri_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yangkipm kla pa kil la tolkil, “Kai ha wail ur pa, melnum ur a arpm ekg atning yangkipm pa arpm, kil ake kark ekg Maur Wailen pa, aki akwonalmpen melnum ur, kalpm. ");
INSERT INTO uri_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wa kin karpikg ur pa, apm wa arpm ha wail pa yat pake. Yatom aklei wang kil kul tongtong ropontel la tolpa, ‘Kitn iklinjopm ekg kalkuten a pike melnum ti ntekg kulntopm ti pen.’ ");
INSERT INTO uri_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kil kul perper la nasel pake ake kil atning kalkuten a kil la nasel pa, tolpa kaingkai wang wrij ur pa, kil akwonalmpen tolpa, ‘Kupm ti ake kark ekg Maur Wailen pa, aki akwonalmpen tu melnum ur. ");
INSERT INTO uri_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pake kil perper kul ropontopm yatom ntekg kupm ti numlpmahakopm paitn, ti kupm iklinjel om.’ ” ");
INSERT INTO uri_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Wailen la yangkipm kla plaln pa, wa kil wa la tolpa, “Ti wet kipm atning kuina ur a melnum paitn a arpm ekg atning yangkipm pa la pa. ");
INSERT INTO uri_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ti Maur Wailen ake ntie ekg al atning tu melnum a kil akrkahan a hakg ropontel mning hranen ekg al kil aklinjen aki? Ti kil nungkulkget arpm wang watin aki kalpm e? Kalpm. ");
INSERT INTO uri_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kupm la nasepm la tolpa, kil pa atning kalkuten a tu pa aklinjen aktutu pa. Pake Warim Kpman a Melnum hi wa nar knokg ti pa hi wa kil hantil tu melnum tiur a ukpma kil pa aki, kalpm e?” ");
INSERT INTO uri_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yatom Jisas kil la yangkipm kla kil kai ekg tu melnum a akwonalmpen tolpa tu alntu pa nipet wor pake, arku tu tiur ai la tolpa tu pa paitn. ");
INSERT INTO uri_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Yatom melnum wekg pa kaino akal ropon Maur Wailen kaino wan yalming a Maur Wailen pa. Melnum ur pa Parasi, wa ur pa melnum a wi takis marpm a tu. ");
INSERT INTO uri_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Melnum Parasi pa kai atn yatom, kil ropon Maur Wailen ak nikgwalpm pa la tolpa, ‘Maur Wailen, kupm ukweitn wor, ekg nte, kupm ake melnum a ak ikgwampel kweiur kweiur, a akplainel tu kmel, a kli arkul pa tukol tu tiur ai. Wa kupm ukweitn wor ekg kupm ti ake wa melnum tukol melnum a wi takis marpm a tu ri atn kai atn pa. ");
INSERT INTO uri_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aklei wang wekg a wang wampomit wampomwekg pa kupm kalpm ekg ekpma ekg uk wang kitn, wa kweiur kweiur wrongwailet a kupm wi pa, kupm uk tiel wampwam kai ekg kitn.’ ");
INSERT INTO uri_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pake tukol melnum a wi takis marpm a tu pa, kil atn watinet ketnketn homtmpok ikgkinar knokg pa, yatom kil arku nikgwalpm pa la tolpa, ‘Woi, Maur Wailen, kupm ti melnum a ntekg paitnpaitn, ti kitn reinjopm om.’ ");
INSERT INTO uri_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tuwekg hrak wa kai wan ha alntuwekgen pa. Kupm la nasepm la tolpa, melnum a wi takis marpm a tu pa kil pa paln nipet wor kai ikg a Maur Wailen pake, wa melnum Parasi pa kalpm. Ekg nte, melnum a kat nang a kil alkil pa, hi wa Maur Wailen arku nang a kil pa kinar knokg. Wa melnum a kil arku nang a kil alkil pa, hi wa Maur Wailen kat nang a kil pa ye kaino kwa.” ");
INSERT INTO uri_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yatom tu tiur ye warim ark malung pa kai ekg al Jisas kil eln wam pa helen. Tu disaipel alkilen pa tu ari a tu ye kul pa, om tu klewen. ");
INSERT INTO uri_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ari Jisas kwe tu warim pa kulntel yatom kil la tolpa, “Kipm eln tu warim pa kulntopm om! Ampur kipm loken. Kingdom a Maur Wailen apm a tu a tolpake. ");
INSERT INTO uri_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ti kipm itning! Mla ur ake wi Kingdom a Maur Wailen tukol tu warim pa, kil ake ntie ekg akal kahor Kingdom a Maur Wailen.” ");
INSERT INTO uri_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Melnum tukgunakgen ur pa ropon Jisas la tolpa, “Melnum Wor a Uk Arie, al kupm ntekg tolhai ekg hi wa kupm arpm wor aklei wang pa?” ");
INSERT INTO uri_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ari Jisas wa ropontel la tolpa, “Ti kitn lak kupm ti wor tolhai? Ake melnum ur wor tol Maur Wailen kil alkil wrij pa. ");
INSERT INTO uri_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ti kitn ari yangkipm titnongket a Maur Wailen pa la tolpa: ‘Ampur kitn kli arkul kin ur, ampur kitn alm melnum ur mo, ampur kitn akikgwam, ampur kitn la yangkipm akplainel tu kmel a atn ntekg yangkipm, kitn al horhanekg ekg manjan.’ ” ");
INSERT INTO uri_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ari melnum pa wa akalmpe la tolpa, “Ti yangkipm titnongket pa kupm apm pike katnun ak kupm a warimpen ak ai kul ai pen.” ");
INSERT INTO uri_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisas kil atning pa yatom kil la tolpa, “Tolpa ti kupm atning kitn ak wor pake, wa kwei ur wrij kil ake kitn wi pen: kitn ik kweiur kweiur wrongwailet akitn pa ik wi marpm pa yatom nampreng uk tu melnum a arpm warkip pa, ekg hi wa kitn arpm ntie kaino ha wor ai, om kitn kul kutnuntopm!” ");
INSERT INTO uri_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kil atning tolpa pa, kil ipma kalkut paitn, ekg nte, kil pa ntie kweiur kweiur wailet paitn. ");
INSERT INTO uri_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas kil ari pa yatom kil la tolpa, “Melnum a ntie kweiur kweiur wailet pa, wonet ekg kil kahor Kingdom a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tukol kamel pa, wonet ekg arkul kamel pa om lang eln kahor teng a hikyom ak kut hapm pa, pake melnum a ntie kweiur kweiur wailet pa, wonet paitn ekg kil kahor Kingdom a Maur Wailen pa.” ");
INSERT INTO uri_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tu atning a kil la tolpa yatom, tu ropontel la tolpa, “Tolpa ti mla ur ntie ekg kil wi arpm wor a arpm aklei wang?” ");
INSERT INTO uri_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ari wa Jisas akalmpenten la tolpa, “Kuina ur a melnum ake ntie ekg ntekg pa, pa Maur Wailen kil ntie ekg ntekg.” ");
INSERT INTO uri_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ari Pita pa la tolpa, “Ti men ti al nte? Men apm nuhurn wan ha kweiur kweiur alpmenen apm atn ase, wa men apm kul katnun kitn tike.” ");
INSERT INTO uri_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yatom wa Jisas la nasen la tolpa, “Kupm la nasepm aklahle wrijen la tolpa, tukol mla ur kil eln Kingdom a Maur Wailen atn hep, yatom kil nuhurn kin warim alkilen aki manjan a wasokwasok a worwor alkilen a wan ha alkilen pa yat, ");
INSERT INTO uri_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","hi wa kil wi kweiur kweiur wailet paitn ak wang ti hangken a pike kil nuhurn pa. Wa hi wa kil wi arpm wor a arpm aklei wang ak wang kanukg.” ");
INSERT INTO uri_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yatom Jisas kil wi tu melnum yangkipm kuinen wampwam yikakwomwekg (12) alkilen pa ye kai atn hampen ur pa yatom kil nasen la tolpa, “Kipm itning! Mento wa kai Jerusalem pake, kuina ur a pike tu melnum ek wripm ro ekg Warim Kpman a Melnum pa, pa hi wa paln aklahle. ");
INSERT INTO uri_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Hi wa tu uk kil kai wam a tu melnum a ake Juta, yatom hi wa tu la paitnel akel nokg, komitel paitn, wa ungkwawel wlikg. ");
INSERT INTO uri_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Hi wa tu ak hmpei rkwawel wa almpel mo, ak wang wraur pa kil wa wreitn.” ");
INSERT INTO uri_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ari tu disaipel alkilen pa tu ake arie kuina ur a kil la pa, yiprokgen a yangkipm pa ha hampen. ");
INSERT INTO uri_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisas kil kul yampingken Jeriko pa, kil ari melnum ikg paitnen ur pa arpm ya arkikg pa ukwempen tu ekg marpm pa arpm. ");
INSERT INTO uri_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kil atning tu wrong a ekla naurkge kul kai, yatom kil ropon la tolpa, “Kuina ur pa?” ");
INSERT INTO uri_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ari wa tu la nasel tolpa, “Men katnun Jisas, melnum a Nasaret pake. Ti hor ti!” ");
INSERT INTO uri_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yatom kil wlakil kwe la tolpa, “Jisas! Walyaru a Teipit! Kitn reinjopm pen!” ");
INSERT INTO uri_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ari tu melnum a hep pa klkampentel om klewel la tolpa, “Kitn elntmpei irpm.” Ari wa kil kwe nti ur yikaktnen paitn ai la tolpa, “Walyaru a Teipit! Kitn reinjopm pen!” ");
INSERT INTO uri_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yatom Jisas kil kai atn la nasi tu la tolpa, “Nmpilel ye kul om.” Yatom tu wamparpmel ye kul yampingkentel, Jisas ropontel la tolpa, ");
INSERT INTO uri_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Kitn akal kupm ntekg kuina ur kai ekg kitn ti?” Ari wa kil akalmpe la tolpa, “Wailen, kupm akal kitn ntekg ikg a kupm a paitn ti wa wor ari kweiur kweiur.” ");
INSERT INTO uri_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yatom Jisas la nasel la tolpa, “Ikg a kitn pa nungkwat ari kweiur kweiur om! Kitn ukpma titnongket tolpa yatom, ikg a kitn pa apm paln wor ase.” ");
INSERT INTO uri_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kil la tolpa, ikg a kil pa wor aktutu tolti, kil wa ari kweiur kweiur pa, yatom kil kat nang a Maur Wailen pa katnun Jisas pa tolpa kai. Tu wrongwailet tu ari pa, tu kat nang a Maur Wailen pa yat. ");
INSERT INTO uri_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas kil kai paln kai ha wail Jeriko pa, om kil ngkom hor ha pa kai. ");
INSERT INTO uri_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pa melnum ur arpm ha ripa, nang a kil pa Sakias. Kil melnum ur a atn hep ekg tu melnum a wi takis marpm a tu pa arpm, kil pa ntie kweiur kweiur wailet paitn ai. ");
INSERT INTO uri_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kil pa melnum warkip tolpa yatom, kil tetanen om kor kai pa kai pa ekg kil akal ari Jisas pa ari kalpm, tu wrongwailet paitn ak hmpri tolpa yatom kil ake ntie ekg ariel. ");
INSERT INTO uri_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yatom kil aktutu hep kai nowe yo fik ur a atn kai ya pa ekg al kil hel om ari Jisas a ngkom hor ya pa kul pa. ");
INSERT INTO uri_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yatom Jisas ngkom hor ya pa kai pa, kil ikg kaino ari Sakias a hel kaino yo kwa pa, om kil kwe la tolpa, “Sakias, kitn nar om! Kupm akal ntieitn arpm kai wan akitn ak am ti.” ");
INSERT INTO uri_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kil atning tolpa, kil pa utopen paitn tolti, kil hraraij aktutu nar knokg ti, om kil wa wi Jisas pa ye kai wan alkilen. ");
INSERT INTO uri_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tu wrongwailet pa tu ari pa, yatom tu ipma paitn yatom tu la tolpa, “Melnum pa wa kil kai kahor wan a melnum a ntekg paitnpaitn a tolpa ekg nte!” ");
INSERT INTO uri_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tu kahor ark wan pa, Sakias kil wreitn la nasi Wailen pa la tolpa, “Wailen! Al kupm wako kweiur kweiur wrongwailet alkupmen ti, yatom nampreng wompel pa uk tu melnum a arpm warkip. Wa tol pike kupm akplainel wi marpm a tu pa hangken marpm a tu a pike kupm wi pa, pa al kupm akalmpenten nti witnweitn.” ");
INSERT INTO uri_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yatom Jisas la nasel la tolpa, “Tu a ark wan ti pa, Maur Wailen apm wet ti wiyen ekg alkilen ase. Ti melnum ti pa, apm walyaru walmpopmen a Apraham pa yat pake. ");
INSERT INTO uri_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ti Warim Kpman a Melnum apm pike nar ekg kor tu melnum a ham pa, yatom wawiyen ekg alkilen.” ");
INSERT INTO uri_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tu atning yangkipm a Jisas la atn pa, yatom tu akwonalmpen wailet tolpa kil al kai paln Jerusalem pa, pa Kingdom a Maur Wailen apm yampingken ekg al paln ngko wurknong pake. Ekg nte, tu nti Jisas pa apm kai yampingken Jerusalem pa ase. Tolpa yatom kil la nasen yangkipm kla ur pa ekg ak lok nikgwalpm a tu akwonalmpen wailet pa kai wor. ");
INSERT INTO uri_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yatom kil la tolpa, “Melnum wailen ur pa kil akal kai ha ur a ark kai watin ai ekg al tu katel tukol melnum tukgunakgen, yatom kil hi wa kul ha ekg ikghlenten. ");
INSERT INTO uri_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yatom kil kwe tu melnum akwap kalpmel wampwam alkilen pa kul, om kil ukwen marpm, plaln pa, kil la nasen la tolpa, ‘Kipm wi marpm rikil ekg ik ikwap ur, tolpa kaingkai wa kupm kul yawrik.’ Kil uk marpm tu pa plaln pa, kil apm wreitn kai ase. ");
INSERT INTO uri_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ari tu hawrij alkilen pa tu ipma paitn ekg kil, yatom tu kwa tu melnum yangkipm kuinen tiur pa kai katnuntel ekg akal tu la nasi tu la tolpa, ‘Men ti ake wakrongen akal kil pa atn tukgunakgen ekg ikghlen men ti.’ ");
INSERT INTO uri_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Melnum wailen pa paln tukgunakgen plaln pa, wa kil wa kul ha. Tolti kil kwe tu melnum akwap kalpmel alkilen a pike kil ukwen marpm ekg tu ak akwap pa, al tu la nasel kwap kuina ur a tu ak om ak wi marpm warim aripm ur pa. ");
INSERT INTO uri_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yatom melnum akwap kalpmel a kul hep pa la tolpa, ‘Wailen, marpm a pike kitn ukopm pa, kupm ak akwap, yatom wa kupm akwi marpm wampwam hangken.’ ");
INSERT INTO uri_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Yatom wa kil wa la tolpa, ‘Wor wrijen, kitn pa melnum akwap kalpmel wor! Tukol pike kitn ikghlen kweiur kweiur wasikyikek pa ariworwor, ti al kupm eln kitn atn wailen ikghlen ha wail wampwam.’ ");
INSERT INTO uri_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wa melnum akwap kalpmel a kul katnuntel wa la tolpa, ‘Wailen, marpm a kitn ukopm pa, kupm ak akwap yatom kupm akwi marpm wampomit hangken.’ ");
INSERT INTO uri_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ari wa kil la nasel la tolpa, ‘Hi wa kupm eln kitn atn wailen ikghlen ha wail wampomit.’ ");
INSERT INTO uri_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Wa ur pa kul katnunten la nasel la tolpa, ‘Wailen, marpm a kitn ti, pike kupm ye kai ak hapm yiponteitn lamteitn ariworwor ha. ");
INSERT INTO uri_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ekg nte kupm ari kitn melnum ipma wakget. Kitn pa melnum a wi kweiur kweiur a melnum manet ai elntha, wa kai kor kweiur kweiur kai wring a melnum manet pa, tolpa yatom kupm kark.’ ");
INSERT INTO uri_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ari kil la nasel la tolpa, ‘Kitn pa melnum akwap kalpmel lpmahaklang paitn! Ti al kupm ntekg yangkipm namponen kitn komkiti ek a kitn alkitn la ti. Tukol kitn ari lak, kupm ti melnum paitn a wi kweiur kweiur a melnum manet ur ai elntha, a wa kupm melnum a wa kai kor kweiur kweiur kai wring a tu tiur ai pa. ");
INSERT INTO uri_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tol wa kitn eln marpm pa arpm wan marpm pa, ekg al akwi marpm warim pa, ekg al kupm kul pa, al kupm wi namponen marpm man pa yat.’ ");
INSERT INTO uri_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Yatom kil la nasi tu wrong a atn pa la tolpa, ‘Kipm wi marpm pa tukuleinjel, yatom kipm ye kai uk melnum a pike kil wi marpm wampwam pa.’ ");
INSERT INTO uri_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ari wa tu la tolpa, ‘Wailen, kil apm pike wi marpm wampwam ase!’ ");
INSERT INTO uri_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ari wa kil akalmpenten la tolpa, ‘Mla ur a kil ntie kweiur kweiur wailet pa, al wa kupm ukwel hangken. Pake tol melnum ur a kil arpm warkip pa, kweiur kweiur waitketn alkilen pa al wa kupm kwan tukuleinjel. ");
INSERT INTO uri_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Wa tu melnum a pike wi wrongmnto lantopm la tolpa ake al kupm ti atn wailen ikghlenten pa, wi tu pa ye kul, yatom ilmpen mo itn ikg a kupm ti!’ ” ");
INSERT INTO uri_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas kil la tolpa plaln pa, kil ngkom kaino akal kai kahor ha wail Jerusalem. ");
INSERT INTO uri_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kil kaino yampingken ha Petpake a ha Petani, a ark tipmning a tu kwe tolpa Olip pa. Kil kwa disaipel wekg alkilen pa hep. ");
INSERT INTO uri_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Yatom kil la nasen la tolpa, “Kipmekg hep kaino ha a arkkaino ark pa, om kipmekg ari donki wlampien ur a ake pike ur arpme hep pen, tu kuten elntatn. Pa, kipmekg nelkgen yatom ye nar. ");
INSERT INTO uri_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tol mla ur ropontepm la tolpa, ‘Kipmekg al nelkgen ekg al ak ntekg kuina?’ Pa kipmekg la nisel la tolpa, ‘Melnum Wailen kil akal ak ak kwap ur alkilen.’ ” ");
INSERT INTO uri_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yatom tuwekg kaino ari kweiur kweiur pa apm atn komkiti ek a wet Jisas la pake. ");
INSERT INTO uri_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Yatom tuwekg nelkgen donki wlampien pa, ari tu melnum yan a donki wlampien pa roponten la tolpa, “Kipmekg akal nelkgen ekg ak ntekg kuina?” ");
INSERT INTO uri_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ari tuwekg akalmpe la tolpa, “Melnum Wailen kil akal ak ntekg kwap ur alkilen.” ");
INSERT INTO uri_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tolti, tuwekg ye kinar ekg Jisas. Yatom tuwekg wi hapm alntuwekgen a nowe ekg wrokg pa, kulampen plaln pa, tuwekg aklin Jisas pa kaino arpme. ");
INSERT INTO uri_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yatom Jisas kil arpme donki wlampien pa kaino pa, om tu wrong kinkpman wailet ha pa ha pa, nel wi hapm alntuen a tu nowe ekg wrokg pa, kulampen ya pa. ");
INSERT INTO uri_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yatom ak wang a kil hep kaino paln kaino ya a hakaino tipmning Olip pa kul nar ekg kaino Jerusalem pa, tu disaipel wrongwailet pa nel utop rkolel kat nang a Maur Wailen yikaktnen ekg kweiur kweiur weten wailwail a pike tu ari a kil ntekg pa. ");
INSERT INTO uri_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Tu utopen rkolel tolpa kai la tolpa, “Maur Wailen kil kwa melnum tukgunakgen ti nar, ti mento utopentel. Kil uko ipma wor pa atn ekg mento, ti mento kat nang a Maur Wailen a atn wailen ikghlen kweiur kweiur wrongwailet.” ");
INSERT INTO uri_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ari tu Parasi tiur a ark kuin a tu wrongwailet pa la nasi Jisas pa la tolpa, “Melnum a Uk Arie, ti kitn la nasi tu disaipel alkitnen ti ekg tu elntmpei itn pen.” ");
INSERT INTO uri_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ari wa Jisas la nasen la tolpa, “Tol tu pa elntmpei atn pa, al tu weij a arpm hor ti pa al wa kat nang a Maur Wailen tol tu a utopen atn tike.” ");
INSERT INTO uri_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas kil kaino yampingken ari ha wail Jerusalem pa, kil hakg rein paitn, ");
INSERT INTO uri_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","wa ak ek namputen la tolpa, “Rein kitn Jerusalem, ak wang ti tol kitn ari kuina ur a ntekg kitn wi ipma mehen wa arpm mehen wor, ari wa kitn wa uk yirokg, tolpa ti apm kai hamteitn ase. ");
INSERT INTO uri_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Wang paitn ur hi wa palnteitn pa, tu wrongmnto hi kul kapringenteitn, ak ntekg yipmingki titnongket, wa akhmpri ya wrongwailet a kitn. ");
INSERT INTO uri_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Hi wa tu tikale yipmingki pa kahor tikale wan ha pa alm er tu wrong kinkpman pa kai mo plaln, hi wa ake weij ur a kipm ak le wan pa ur hi wa alile tita atn pa, kalpm, hi tu tikale piln plaln. Ekg nte, wang wor alkitnen a pike Maur Wailen nar akal aklinjeitn pa, kitn pike hret uk yirokg pa pen.” ");
INSERT INTO uri_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yatom Jisas kil kai kahor yipmingki wonen a kapringen wan yalming a Maur Wailen pa, yatom kil kwan tu melnum a eln kweiur kweiur alntuen arpm ekg ak wi marpm pa. ");
INSERT INTO uri_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yatom kil la nasen la tolpa, “Maur Wailen pa la kai wurkapm alkilen pa la tolpa, ‘Wan akupm pa atn ekg al kipm kahor eklala namponen kupm’. Maur Wailen pa apm la tolpake, ari wa kipm eln wan pa atn ekg tu melnum ikgwampet pa kahor apm arke ase.” ");
INSERT INTO uri_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yatom apm Jisas kil kahor yipmingki wonen a wan yalming pa ro tukgunakg lngkep a tu pa aklei wang tolpa kai pake. Ari tu melnum ipma krakgen a Maur Wailen a atn hep pa, wa tu melnum a arpmen yangkipm yiprokgen a Maur Wailen pa, wa tu melnum wailen wailen a ikghlen tu wrong kinkpman pa tu kor akal almpel mo. ");
INSERT INTO uri_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pake tu wrong kinkpman pa wakrongen paitn, ekg tu akal ark pa ark pake, ekg atning yangkipm a kil la pa, tolpa yatom tu akal kor ya hor tolhai, ekg al tu alm kil pa mo. ");
INSERT INTO uri_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wang ur pa, Jisas kil piln yangkipm wor a Maur Wailen, wa kil ro tukgunakg lngkep a tu a atn kahor yipmingki wonen a wan yalming a Maur Wailen pa atn, ari tu melnum ipma krakgen a Maur Wailen a atn hep wa tu melnum a arpmen yangkipm yiprokgen, wa tu melnum wail wail pa nel kul atn. ");
INSERT INTO uri_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Yatom tu la nasel la tolpa, “Kitn pa kitn melnum a wi nang wail pake! Ti kitn la niso ri ekg mla ur a ukweitn wor pa, yatom kitn ak kwap ripa?” ");
INSERT INTO uri_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ari Jisas akalmpenten la tolpa, “Ti kipm itn ekg kupm ropontepm akropon ur kil, om wa kipm la nisopm pen, ");
INSERT INTO uri_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ti titnongket a pike Jon a kaluk tu pa, kil wi kai Maur Wailen pa aki, kai tu melnum ur e?” ");
INSERT INTO uri_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tu atning a kil roponten la tolpa, yatom tu kor tita ark ak tu alntu, yatom tu la kor tolpa, “Al mento la tolhai? Ti tol mento la tolpa, ‘Pa apm Maur Wailen pa ukwel titnongket pake’, ti pa al kil wa la tolpa, ‘Tolpa ti ntekg tolhai yatom pike ake kipm ukpma katnun yangkipm a pike kil la pa.’ ");
INSERT INTO uri_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Om tol wa mento la tolpa, ‘Pa apm tu melnum ti ukwel titnongket tike’, ti akal wa tu wrongwailet ti ak weij ti ero mo, ekg nte, tu apm akwonalmpen tolpa, Jon pa kil melnum ek wripm a Maur Wailen.” ");
INSERT INTO uri_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tu kor la tolpa kai ari al wa tu akalmpentel yangkipm pa tolhai, ekg nte, ya wrongwailet pa apm kil hmpri plaln ase, yatom tu la tolpa, “Men akwekgel mla ur a ukwel titnongket pa.” ");
INSERT INTO uri_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yatom Jisas wa la nasen la tolpa, “Apm tolpa yat pake, kupm ake al wa la nasepm la tolpa mla ur ukopm wor, yatom kupm ak kwap kil.” ");
INSERT INTO uri_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yatom Jisas la yangkipm kla ur pa nasi tu wrong kinkpman pa la tolpa, “Melnum ur pa, kil ntekg wring hmpei wain ur, yatom kil armpen melnum tiur pa akal ikghlentel wring pa atn pa. Kil nuhurn ha pa, yatom kil kai arpm wang watin. ");
INSERT INTO uri_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kil arpm kaingkai, hmpei kil pa apm ngko ek arke ase. Yatom kil kwa kmel akwap kalpmel ur alkilen pa kai, ekg akal tu ukwel hmpei ek tiur ekg yentel kul. Ari tu melnum a ikghlen wring pa tu erel kwantel tolti, kil wa kompwam tolti wa kai. ");
INSERT INTO uri_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tolpa yatom wa melnum yan a wring pa, wa kwa kmel akwap kalpmel ur pa wa kai, ari apm wa tu erel, ntekgel paitn tolti ukwel numpaitn tolti, wa kwawel kalpmel wa kai. ");
INSERT INTO uri_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tolpa yatom wa kil kwa ur pa wa kai, ari apm wa tu erel yongwalmpopm paitn tolti, katel piln kahor hen ai. ");
INSERT INTO uri_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yatom melnum yan yiprokgen a wring pa la tolpa, ‘Al kupm ntekg tolhai? Tolpa pati al kupm kwa warim kpman wrij hnangket alkupmen a kupm wakrongen paitn ti kai pati, al tu atningkel ur aki, kalpm e.’ Kil akwonalmpen tolpa plaln pa, kil kwa warim kpman alkilen pa kai. ");
INSERT INTO uri_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ari tu melnum a ikghlen wring pa tu atn ari a kil kul pa, yatom nel nasi tita la tolpa, ‘Pa warim kpman a hi wi num atnen kweiur kweiur a yan alkilen apm pake. Ti mento ilmpel mo om, ekg hi mento wi kweiur kweiur wrongwailet alkilen pa!’ ");
INSERT INTO uri_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Yatom tu kai arkulel kat piln eln kahor wring henen ai tolti, tu erel mo. Yatom Jisas ropon tu wrong kinkpman a atning ark pa la tolpa, ‘Yatom melnum yan a wring pa akal ntekg tolhai ekg tu melnum a ikghlen wring pa?’ ");
INSERT INTO uri_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Hi kil kul alm tu melnum pa mo, wa uk wring wain pa kai ekg tu ur ai.” Tu wrongwailet a atning pa tu la tolpa, “Tolpa kalpm.” ");
INSERT INTO uri_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yatom Jisas ikgarpmen wa kil la tolpa, “Ti ntekg tolhai om yangkipm kil a hel kai wurkapm a Maur Wailen pa wa la tolpa, ‘Hong ur a tu melnum a le wan pa tu ari lak paitn pa, apm hong yahuwen wor wrijen a atnen wan apm pake?’ ");
INSERT INTO uri_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yatom melnum ur a wutat ngko hel hong wor kil pa, pa al kwat numpwam alkilen pa kai paitn. Ari tol hong pa ngko kai er melnum ur pa, kil pa kai mnampij waitketn ketn tolti.” ");
INSERT INTO uri_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yatom tu melnum a arpmen yangkipm yiprokgen a Maur Wailen pa, wa tu melnum ipma krakgen a Maur Wailen a atn hep pa tu ari tolpa, Jisas pa la yangkipm kla ripa kai ekg tu pa ekg ak almpen ipma. Tolpa yatom tu akal arkul yipoel ak wang ketn apm pake, pake tu ari tu wrong kinkpman a atn pa, yatom tu kark ekg arkulel. ");
INSERT INTO uri_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yatom tu melnum a arpmen yangkipm yiprokgen a Maur Wailen, wa tu melnum ipma krakgen a Maur Wailen a atn hep pa tu kwa melnum tiur pa kai ham atn ari Jisas pa wa ntiel atn akhparel. Wa tu akal alm ipmael Jisas pa ekg akal kil la yangkipm ur kai paitn pa, al tu wiyel ye kai atn yangkipm kai ikg a melnum tukgunakgen a ikghlen ha knokg Judea pa. ");
INSERT INTO uri_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yatom tu ropon nukwar Jisas pa la tolpa, “Melnum a Uk Arie, men ari tolpa kuina ur a kitn pa la ekg ro tukgunakg lngkep a men pa nipet wor pake. Men ari tolpa, kitn ake ari melnum ur nang itne aki melnum ur nang kalpmen pa, kitn laron yangkipm a Maur Wailen ti la nasen aklahle tolti. ");
INSERT INTO uri_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ti mento uk takis marpm kai melnum tukgunakgen a Rom pa, ti kitn ikwonilmpen ri lak pa wor aki pa paitn e?” ");
INSERT INTO uri_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pake Jisas pa ari nikgwalpm hampen paitn a tu ak tolpa, yatom kil la nasen la tolpa, ");
INSERT INTO uri_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ti kipm plantopm marpm pa ri, ikgek a nang a hel kai marpm pa a mla ur?” Ari tu akalmpentel la tolpa, “Apm a Sisar pake.” ");
INSERT INTO uri_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yatom Jisas kil akalmpe la tolpa, “Kwei ur a Sisar pa, kipm uk kai Sisar pa om. Wa kwei ur a Maur Wailen pa, kipm uk kai Maur Wailen pa.” ");
INSERT INTO uri_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tu atning a kil akalmpenten la tolpa, yatom tu wreitn paitn hmpri ek alntuen pa elntmpei atn tolti. Jisas ake la yangkipm ur kai paitn kai ikg a tu wrong kinkpman pa, ekg al tu yewel kai ekg ntekg yangkipm pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Yatom tu Satyusi tiur pa, tu kul ari Jisas. Tu Satyusi pa tu melnum a akwonalmpen tolpa, melnum a mo pa ake ntie ekg hi wa wreitn. ");
INSERT INTO uri_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Yatom tu nukwarel la tolpa, “Melnum a Uk Arie, pike Moses naso yangkipm ur tol kil, tol melnum ur a kil wi kin ur, ari ake kil kwat warim ur, kalpm, kil mo nuhurntel ase, pa wa wasok alkilen pa wa wi wampuk ye, kwat warim ur ekg aklin wrik a wailen alkilen pa. ");
INSERT INTO uri_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tol wasokwail wampomit wampomwekg ur pa ha, yatom wailen pa wi kin pa ye, ari ake kil kwat warim ur, kalpm, kil mo nuhurntel. ");
INSERT INTO uri_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Yatom wa ur a rken kil pa wa wi wampuk. ");
INSERT INTO uri_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ari kalpm, apm wa kil mo nuhurntel wa kai, wa ake wa kil kwat warim ur. Tu apm tolpa plalnten pake, tu wi kin pa ye ari ake ur kwat warim ur, kalpm, apm tu mo nuhurntel tolpake. ");
INSERT INTO uri_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Yatom wa kin pa arpm tolpa kaingkai, kil wa mo kai katnunten. ");
INSERT INTO uri_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kitn pa la tolpa tu melnum a mo pa hi wa wreitn pake? Ti tu wreitn pa, pa kin pa a pike wi kpman wampomit wampomwekg pa, pa hi kil arpm ekg kpman mla?” ");
INSERT INTO uri_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ari Jisas akalmpe la tolpa, “Tu kinkpman ak wang ti pa tu ye tita pake. ");
INSERT INTO uri_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ari tu kinkpman a Maur Wailen wi wor lawen pa, tu hi wa wreitn ak wang kanukg pa, tu ake ntie ekg hi wa ye tita, kalpm. ");
INSERT INTO uri_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ekg nte tu hi ake wa mo nti ur, ekg tu pa tol tu maur akwapel a Maur Wailen. Ti tu pike mo yatom wa wreitn pa, tu pa warim a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Wa Moses planto tolpa tu a pike mo kai pa, tu ake mo kai haren, kalpm. Pa tu kai ti ark pa. Kipm ari yangkipm a pike Moses la yo wasok a pike wakg krpo itne pake, ake wakg al. Yatom kil kwe la tolpa, ‘Wailen, kitn Maur Wailen a Apraham, kitn Maur Wailen a Aisak, a Jekob.’ ");
INSERT INTO uri_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ti pa planto tolpa Maur Wailen pa kil Maur Wailen a tu melnum a mo kai arpm pa yat. Ekg nte, Maur Wailen ari tu a mo kai, wa mento a ark ti pa, lak mento ark yaten.” ");
INSERT INTO uri_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yatom tu melnum tiur a arpmen yangkipm yiprokgen a Maur Wailen pa la tolpa, “Melnum a Uk Arie! Pa kitn akalmpe wor pa.” ");
INSERT INTO uri_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yatom tu kark tolpa yatom, ake wa tu ropontel ur, kalpm. ");
INSERT INTO uri_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yatom Jisas kil la nasi tu melnum a arpmen yangkipm yiprokgen a Maur Wailen pa la tolpa, “Kipm akwonalmpen tolhai, lak Krais, melnum a Maur Wailen kwa nar akal akwi tu wrong kinkpman pa, tukol walyaru walmpopmen a Teipit pa? ");
INSERT INTO uri_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tol pike Teipit kil alkil la hel kai wurkapm a Nangnang pa la tolpa, ‘Maur Wailen kil la nasi Krais Wailen akupm pa la tolpa, Kitn kulno irpm wam wien a kupm, ekg al kupm ukweitn titnongket akupm wa ukweitn nang wail. ");
INSERT INTO uri_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Kitn kul no irpm, kupm eln tu wrongmnto alkitnen ti itn horhanekg ekg kitn.’ ");
INSERT INTO uri_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Teipit kwe kil pa tolpa Wailen, ti wa ntekg tolhai yatom wa tu kwe kil pa tolpa walyaru walmpopmen a Teipit pa?” ");
INSERT INTO uri_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tu ak wail atning ark pa Jisas la nasi tu disaipel alkilen pa la tolpa, ");
INSERT INTO uri_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kipm irk ri ekg tu melnum a arpmen yangkipm yiprokgen a Maur Wailen pa. Ekg nte, tu pa nowe hapm watinwatin ti ak lam nepm alntuen ti, ekg akal tu arien lak tu pa tu melnum wailwail, akal tu wrongwailet yangkipmenten ukwen wor atn hor ha kuin. Wa tu kahor wan a atning yangkipm a Maur Wailen atne pa, tu akal wi wrik worwor pa arpm pake. Wa wang a ntekg ekpma wail al pa, tu pa akal tu kwewen ekg tu pa katen hep hep pake. ");
INSERT INTO uri_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tu akplain om wi kweiur kweiur wrongwailet a tu kin karpikg a kpman mo nuhurnten pa, wa akplain ropon Maur Wailen pa atn wang watin, ekg al tu arien la tolpa tu melnum akwapel wor a Maur Wailen. Tolpa ti hi ak wang a tu atn yangkipm pa, tu hi wi kalkuten wailmanten paitn.” ");
INSERT INTO uri_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ak wang ketn ripa Jisas kil atn yipmingki wonen a wan yalming a Maur Wailen pa atn ari tu melnum a ntie kweiur kweiur wailet pa tu ye kweiur kweiur pa kai alupm kinar yo tmpal ekg uk kai Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yatom kil ari kin karpikg yek ur a arpm warkip pa kai uk marpm watet ek wekg pa. ");
INSERT INTO uri_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yatom wa kil la tolpa, “Kupm la nasepm la tolpa, kin karpikg yek a arpm warkip kil, pa kil uk wailmanten paitn hangken tu wrongwailet. ");
INSERT INTO uri_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tol tu wrongwailet a ntie kweiur kweiur pa tu uk pake, ake tu uk kweiur kweiur alntuen a ha pa plaln, kweiur kweiur wailet tiur alntuen pa ha. Pake kin karpikg yek a arpm warkip pa kil uk plaln tolti kuina waitketn ur alkilen pa.” ");
INSERT INTO uri_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yatom tu tiur pa, tu ark la kiti wan yalming a Maur Wailen pa la tolpa wan pa ari wor wrijen, tu le ak weij a ariworwor, wa tu nakure ak kweiur kweiur worwor a tu uk kai Maur Wailen pa. Ari Jisas la nasen la tolpa, ");
INSERT INTO uri_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kweiur kweiur wrongwailet a kipm ari ti pa, wang ur hi wa paln pa, hi ake weij ur a tu ak le wan ti pa ur ak alile tita atn wrik alntuen pa, kalpm, hi tu tikale piln plaln.” ");
INSERT INTO uri_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yatom tu wrong kinkpman ropon Jisas pa la tolpa, “Melnum a Uk Arie, kweiur kweiur pa hi paln ak wangkarke? Aki, hi kuina ur paln ekg ak plan wang ripa yampingken ekg al paln pake?” ");
INSERT INTO uri_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ari wa Jisas la nasen la tolpa, “Tolpa ti kipm irk ri, tu melnum akplain hi kul akepmplain ekg lokepm ye kai pa kai pa. Ekg nte, tu wailet hi kul ak nang a kupm pa la tolpa, ‘Apm kupm melnum a kipm nungkwangen apm tike!’ Wa la tolpa ‘Wang a kipm la pa, apm yampingken ekg al paln tike!’ Pake ampur kipm kai katnun tu pa, yaper. ");
INSERT INTO uri_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tol kipm atning tolpa wrong hripon aki, tu melnum paln wrongken paitn pa, ampur kipm kark, pa kweiur kweiur tolpa hi apm paln pake, pake wang humpuen pa ha pa.” ");
INSERT INTO uri_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yatom wa kil wa la tolpa, “Ha knokg wail ur hi wa hripon nti ha knokg wail ur, wa wrong a melnum tukgunakgen ur hi wa hripon nti wrong a melnum tukgunakgen ur. ");
INSERT INTO uri_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ti yelm wailwail tiur hi wa no, a wang nikg a numpet wailwail tiur hi paln hor ha tiur, hi wa kipm ari kweiur kweiur tiur a paln kaino ktnong ti, wa kweiur kweiur paitnpaitn tiur a hi ak ntekg kipm ekg kipm kark pa, hi paln. ");
INSERT INTO uri_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pake, hep pa, hi tu arkulepm om yipowepm a ntekgepm paitn, wa hi tu wiyepm ye kai atn yangkipm kahor wan tiur a atning yangkipm a Maur Wailen atne pa, om wiyepm ye kahor arpm wan tipmning. Wa hi tu wiyepm ye kai atn ikg a tu melnum tukgunakgen a tu melnum wailwail ekg nte, kipm ukpma kupm. ");
INSERT INTO uri_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ak wang ripa, hi wa wang wor akipm ekg laron kipm alkipm pa tolpa kipm ukpma kupm. ");
INSERT INTO uri_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ti kipm lupm yangkipm a kupm la nasepm kil: ampur kipm akwonalmpen wailet tolpa hi wa kipm la yangkipm tolhai ak wang a kipm atn yangkipm pa. ");
INSERT INTO uri_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ekg nte, kupm hi wa ukwepm ekla nikgwalpm arie worwor ak wang ripa. Tu wrongmnto akipm pa hi ake ntie ekg talpulntepm ek aki lok arkuepm pa. ");
INSERT INTO uri_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ti kipm hi wa tu manjan, a tu wailwail wasokwasok, a tu walmpopmwrij, a tu melnum wokgen alkipmen pa wiyepm ye kai atn yangkipm, wa tiur alkipmen pa hi wa tu erepm mo. ");
INSERT INTO uri_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tu wrongwailet hi wa ukwepm ipma paitn, ekg nte wa kipm ukpma kupm. ");
INSERT INTO uri_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pake tol tukgunakg walkg wrij ur alkipmen pa, hi ake nur. ");
INSERT INTO uri_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ti kipm itn titnongket, pa hi wa kipm arpm wor aklei wang.” ");
INSERT INTO uri_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Om Jisas kil wa la tolpa, “Ti tol kipm ari tu wrongmnto pa kul kapringen Jerusalem pa, pa kipm ari tolpa, Jerusalem yampingken ekg al kai paitn pake. ");
INSERT INTO uri_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Wang pa paln pa, kipm melnum a Jutia ti pa, kipm kirk kaino ham kaino tipmning ai om, wa kipm a arpm Jerusalem kil pa, kipm wreitn kirk tukulein, wa kipm a ark hor yampingken ha wail ti pa, ampur kipm kahor kil, kipm kirk hor pa kai om! ");
INSERT INTO uri_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ekg nte, pa wang paitn wrijen a Maur Wailen hi wa akalmpe paitnpaitn a tu wrong kinkpman ntekg pa kai tolpa komkiti tukol yangkipm wrongwailet a ro hel kai wurkapm a Maur Wailen ti. ");
INSERT INTO uri_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ti rein ekg tu kin a itna, wa tu mantin a warim ark ma pa ak wang pa! Hi ak wang pa kalkut wail hi wa paln atn knokg ti, wa ipma wakget a Maur Wailen atn ekg al hi wa ntekg paitn ekg tu wrong kinkpman a Juta. ");
INSERT INTO uri_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tu tiur a ark Jerusalem ti pa, pa hi wa tu a ake Juta pa kul ak painat almpen mo, wa hi wa tu wiyen plaln ye kai hrak hor pa hor pa ekg akwap horhanekg a tu atn knokg wrongwailet. Wa tu a ake Juta ti wi wrik pa ark ikghlen Jerusalem ti ak wakrong alntuen, tolpa kaingkai ngko wang ur a Maur Wailen la tolpa tu ikghlen kaingkai elnten pake.” ");
INSERT INTO uri_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Wa Jisas kil wa la tolpa, “Ak wang pa, hi wa kipm ari kweiur kweiur a paln kaino ktnong pa kai takgni ti, kainil, wa kungkumeim pa. Wa atn knokg ha ti pa, tu wrongwailet hi wa atning lko a hunokg wail a kat tupor harharen kul pa. Tu hi wa kark paitn kwarkwar tolti. ");
INSERT INTO uri_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ti tu wrong kinkpman hi wa kark paitn, nikgwalpm kaino hroij wa hi wa ark nungkwangen kweiur kweiur hi wa paln atn hor knokg ti. Wa kweiur kweiur titnongket titnongket a atn kaino ktnong pa, hi wa tutut tutut winwin ekg al narku. Kweiur kweiur tolpa paln pa, ");
INSERT INTO uri_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","pa hi wa tu ari Warim Kpman a Melnum pa hi wa weipmunu ak wi ye nar namponen titnongket a klalen wailmanten. ");
INSERT INTO uri_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ti tol yampingken ekg kweiur kweiur pa ekg al paln pake, pa kipm wreitn kit ikg pa kaino kwa pa irpm utopen nungkwangen, ekg wang a Maur Wailen ekg al akwiyepm pa, apm yampingken tike.” ");
INSERT INTO uri_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yatom Jisas la nasen yangkipm kla ur pa la tolpa, “Ti kipm ikwonilmpen yo fik pa, wa yo wrongwailet manet ai yat. ");
INSERT INTO uri_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Wang a kipm ari hipm wulkga horen pa, kipm ari tolpa, wang yampingken ekg al takgni wor pake. ");
INSERT INTO uri_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ti apm wa tolpa yat pake, wang a kipm ari kweiur kweiur tolpa akal paln pa, kipm ari tolpa, wang yampingken ekg al Kingdom a Maur Wailen paln pake. ");
INSERT INTO uri_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kupm la nasepm aklahle wrijen la tolpa, kipm wrong kinkpman a ark ak wang ti pa kipm hi ake mo, kipm tiur hi wa ark, kaingkai kipm ari kweiur kweiur ripa a paln pa. ");
INSERT INTO uri_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ti ktnong a knokg pa hi wa kai plaln, pake yangkipm alkupmen pa, hi ake kai plaln, hi apm ha tolpa kai pake.” ");
INSERT INTO uri_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Wa Jisas kil wa la tolpa, “Ti kipm irpm wonirpme! Ampur kipm nikgwalpm ark ekg ekpma, wa al hu hmit kweiur kweiur pa, aki ampur kipm nikgwalpm ark ekg kweiur kweiur a numpalk pa atn knokg ti. Kipm irpm wonirpme, ekg wang pa hi wa palntepm tukol hik a le hep elntatn, ");
INSERT INTO uri_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ti kipm hi wa wonmit kai om ngkowe tolti. Wang pa hi wa paln ekg tu kinkpman wrongwailet atn hor ha knokg ti. ");
INSERT INTO uri_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ti kipm irpm wonirpme om wa ropon Maur Wailen ti aklei wang, ekg al kil ukwepm titnongket, ekg kipm hi wa ntie ngkom nlokgen kweiur kweiur a hi akal palntepm pa, wa ekg kipm hi wa ntie atn kai ikg a Warim Kpman a Melnum pa.” ");
INSERT INTO uri_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Aklei wang pa, Jisas kil apm ro tukgunakg lngkep a tu wrong kinkpman pa atn kahor yipmingki wonen a wan yalming a Maur Wailen pake. Wa aklei nungkutikg mning wrij wrij pa, kil kai kaino hokg kaino tipmning Olip, ");
INSERT INTO uri_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","yatom kil nar ak kang mningket wrij wrij pa. Tu kinkpman wrongwailet pa tu kul ark atning yangkipm a kil piln pa, atn kahor yipmingki wonen a wan yalming a Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Aklei wring wrij wrij pa tu Israel ntekg nak tingklak a yis kalpmen pa akal akwonalmpen wang a pike Maur Wailen kil wiyen ye kai tukulein Ijip, wang wail pa apm kul yampingken tike. ");
INSERT INTO uri_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pa tu melnum ipma krakgen a Maur Wailen a atn hep pa, namponen tu melnum a arpmen yangkipm yiprokgen a Maur Wailen pa, tu akwonalmpen wailet kor ya akal tu er Jisas pa mo la tolhai, ekg nte, tu kark ekg tu wrong kinkpman ti. ");
INSERT INTO uri_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yatom Satan kil kai kahor Jutas pa, tu kwe tolpa Iskariot, pa kil melnum wrij ur a tu wampwam yikakwomwekg a Jisas pa. ");
INSERT INTO uri_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yatom Jutas kil wreitn kai ekla namponen tu melnum ipma krakgen a Maur Wailen a atn hep pa wa tu melnum tukgunakgen a tu melnum a ikghlen wan yalming a Maur Wailen pa, ekg akal uk Jisas pa kai wam atu pa. ");
INSERT INTO uri_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yatom tu melnum pa, tu utopen paitn, ekg Jutas kil kai ukwen ya tolpa, yatom tu nasel akal ukwel marpm. ");
INSERT INTO uri_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jutas kil wi wor, yatom kil kor ya hampen ur akal uk Jisas pa kai wam atu pa, ekg ake akal tu wrong kinkpman pa ari. ");
INSERT INTO uri_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tu ntekg nak tingklak a yis kalpmen pa al ekg akal akwonalmpen wang a pike Maur Wailen kil wiyen kai tukulein Ijip pa ark, tolpa kaingkai wang a tu pike alm elntatn ekg alm sipsip warim wrij ur ekg ntekg al wor uk Maur Wailen, ti apm wang apm tike. ");
INSERT INTO uri_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yatom Jisas kil la nasi Pita ekg Jon pa la tolpa, “Kipmekg kai numprampentol ekpma pa irpm, ekg al mento kai pa, mento al.” ");
INSERT INTO uri_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ari wa tuwekg ropontel la tolpa, “Ti kitn wakrongen akal mentekg numprampen ekpma pa arpm kai hai?” ");
INSERT INTO uri_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ari wa kil la tolpa, “Ti kipmekg itning! Kipmekg kai kahor ha wail pa, om kipmekg ari melnum ur a ye hu kuntuk wail pa pati, kipmekg kutnuntel kai kahor wan ur a kil kai kahore pa, ");
INSERT INTO uri_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","om kipmekg ropon melnum yan a wan pa la tolpa, ‘Melnum a Uk Arie pa la naso, la tolpa mentekg roponteitn, la tolpa wrik wan al kil namponen men disaipel akil pa al ekpma arke pa, pa ha hai?’ ");
INSERT INTO uri_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yatom al kil plantepm wan wonen wail ur a ha kaino wan wlop wekg pa numprampen pa, om kipmekg numprampentol ekpma pa itne.” ");
INSERT INTO uri_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tuwekg atning plaln pa, tuwekg wreitn kai ari kweiur kweiur wrongwailet pa, apm paln komkiti tukol a wet Jisas la nasen pake, yatom tuwekg numprampen ekpma pa arpm. ");
INSERT INTO uri_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tuwekg numprampen ekpma pa elntatn pa, takgni kinar tmpal pa wang alkilen a tu kai ark al ekpma wail pa, Jisas kil kai kahor nti tu melnum yangkipm kuinen alkilen pa ekg akal tu al ekpma pa. ");
INSERT INTO uri_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yatom kil la nasen la tolpa, “Kupm pike wakrongen paitn ekg akal ntiepm al ekpma ak wang ripa, plaln pa, kupm ye kalkut. ");
INSERT INTO uri_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ti kupm la nasepm la tolpa, kupm hi ake wa al ekpma ur tolti nti ur kai ngko wang a kweiur kweiur pa paln aklahle kai Kingdom a Maur Wailen.” ");
INSERT INTO uri_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yatom Jisas kil wi keimung wain ur pa ye atn ukwor Maur Wailen plaln pa, kil la tolpa, “Kipm wi ti nampreng il om! ");
INSERT INTO uri_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kupm la nasepm la tolpa, kupm hi ake wa al hu wain ti nti ur, tolpa kai ngko wang a Kingdom a Maur Wailen paln ngko wurknong.” ");
INSERT INTO uri_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yatom wa kil wi nak tngklak ur pa ye atn ukwor Maur Wailen pa plaln pa, kil kpor ukwen om wa kil la tolpa, “Kil num alkupmen a kupm ukwepm ekg aklinjepm. Ti kipm ik tolpa kai ekg hi kipm ikwonilmpen kupm ti!” ");
INSERT INTO uri_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tu al ekpma pa plaln pa, kil wi keimung ripa ye atn ak komkiti tol a wet hep pa plaln pa, kil la tolpa, “Hu wain keimungen kil pa pati, pa Maur Wailen lam kla weten namponen kipm. Kil walmpopm alkupmen a ungkwan ekg akal aklinjepm. ");
INSERT INTO uri_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pake ti kipm itning! Melnum a hi uk ya kupm ti kai wam a tu wrongmnto pa, apm ntio al ekpma arpm tike! ");
INSERT INTO uri_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Warim Kpman a Melnum ti hi wa komkiti ya a pike Maur Wailen la pake. Pake rein melnum a uk ya Warim Kpman a Melnum ti kai wam a tu wrongmnto pa, kil hi wi paitn.” ");
INSERT INTO uri_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tu atning tolpa, om tu kor ropon tita la tolpa, “Mla ur a mento ti, hi ak kwap ripa?” ");
INSERT INTO uri_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tu disaipel a Jisas pa alilhakel tita ekg la mla ur al atn wailen ekg tu pa. ");
INSERT INTO uri_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ari Jisas la nasen la tolpa, “Tu melnum tukgunakgen a knokg ti pa, tu plan titnongket a tu ti ekg atn wailen ikghlen tu wrong kinkpman alntuen, wa tu wakrongen tolpa al tu wrong kinkpman pa la tolpa tu pa melnum wailen wor a akwap wor ekg ikghlenten. ");
INSERT INTO uri_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pake kipm pa ake al ntekg tolpa. Kipm mla ur akal paln melnum wailen kai kuin alkipmen pa, kil al arku kil alkil hor hanekg a kipm alkipm ti, wa mla ur alkipmen akal paln melnum a atn hep ikghlentepm pa, kil al paln melnum akwapel a aklin kipm ti yat. ");
INSERT INTO uri_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kipm ari tolpa, melnum a arpm akal al ekpma ti pa melnum wailen aki, melnum a nampreng ekpma ti ekg kil al ti pa melnum wailen e? Melnum a kil arpm akal al pa melnum wailen pake. Pake kupm ti ake tolpa, kupm tukol melnum akwapel a hor hanekg a kipm ekg aklinjepm. ");
INSERT INTO uri_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kipm pike ntiopm ye kalkut ak ai kulngkul ngko wang ti, wa ake kipm nuhurntopm. ");
INSERT INTO uri_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Wa tolpa ti tol pike yan alkupmen kat kupm ti atn melnum wailen ikghlen kweiur kweiur wrongwailet, tolpa ti hi wa kupm ti wa kat kipm ti atn melnum wailen ikghlen kweiur kweiur wrongwailet yat. ");
INSERT INTO uri_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ti kipm hi ntiopm al hu a ekpma kahor Kingdom alkupmen pa, wa kipm hi arpm tol melnum tukgunakgen, om ntekg yangkipm namponen hom wampwam yikakwomwekg a Israel pa.” ");
INSERT INTO uri_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisas la nasi Saimon la tolpa, “Saimon, Saimon! Ti kitn itning! Maur Wailen uk ya Maur Paitn Satan ekg akal hi rkolepm ekg akal kipm ngko kai wrijen tukol nmpek ek palk a melnum kwalkwin pa yatom ak wripm wi pa. ");
INSERT INTO uri_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pake, kupm pike ropon Maur Wailen ekg akal kil aklinjeitn ekg hi ake kitn ngko kai wrijen. Kitn hi wa kul pa, kitn ik titnongketel tu wailenwailen a wasokwasok alkitnen pa.” ");
INSERT INTO uri_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ari wa Saimon kil akalmpe la tolpa, “Wailen, kupm apm numprampen ekg al ntieitn kai arpm wan tipmning aki, akal tu almpeitn mo pa, kupm hi ak ntieitn!” ");
INSERT INTO uri_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ari wa Jisas akalmpe la tolpa, “Pita, kupm la naseitn la tolpa, am ti krek ake la pen, kitn lam nang akupm ti nti wraur.” ");
INSERT INTO uri_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yatom Jisas kil ropon tu disaipel alkilen pa la tolpa, “Pike hep a kupm kwawepm kai pa, ake pike kipm ye kweiur kweiur a alupme marpm aki, hapm kok aki nepm palk kakir pa, kalpm, kipm pike kompwam tolti. Ti pike kipm warkip ekg kwei ur aki kalpm e?” Ari wa tu wa la tolpa, “Kalpm, men pike ake warkip ekg kwei ur”. ");
INSERT INTO uri_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yatom Jisas la nasen la tolpa, “Apm pike tukol pake, pake ak wang kil pa tol kil, mla ur a ntie hapm kok a kweiur kweiur a alupm marpm pa, kil pa wi ye. Wa mla ur a painat kalpmen pa, kil wi hapm ur alkil a nowe ekg wrokg pa ik wi marpm pa, plaln, yatom kil ik wi ur ye. ");
INSERT INTO uri_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ti yangkipm ur a hel kai wurkapm a Maur Wailen pa la tolpa, ‘Tu wrongwailet pa la tolpa kil pa melnum ikgwampet paitn’. Yangkipm kil apm la ekg kupm tike. Ti apm paln aklahle tike. Yangkipm wrongwailet a pike ro ak la kupm ti pa, yampingken ekg apm paln aklahle tike.” ");
INSERT INTO uri_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yatom tu la nasel la tolpa, “Wailen, painat wekg men ye arpm ti.” Ari wa kil la nasen la tolpa, “Ha pa om! Ampur kor la wailet.” ");
INSERT INTO uri_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisas kil ekla namponen tu melnum disaipel pa plaln pa, kil wiyen nel nuhurn ha pa kai kaino tipmning Olip tol a pike kil ak hep aklei wang pa. ");
INSERT INTO uri_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tu kaino paln tipmning pa, Jisas la nasen la tolpa, “Kipm ropon Maur Wailen pa ekg ake al Maur Paitn Satan ak lokepm ekg ake al kipm katnuntopm.” ");
INSERT INTO uri_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yatom kil nuhurnten kai watinet ketn ketn ai om kil kpor klko lein, wa ropon Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Yatom kil ropon la tolpa, “Yan, tol wakrong akitn pa, kitn kwan keimung ripa kai tukuleinjopm. Pake, ampur kitn katnun wakrong akupm ti pa, kitn ik kutnun wakrong alkitnen.” ");
INSERT INTO uri_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Yatom maur akwapel ur a Maur Wailen pa hakaino ktnong ai nar palntel, ak titnongketel kil. ");
INSERT INTO uri_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ipma a kil pa kalkut paitn tukol weij tolti. Tolpa yatom kil wa ropon Maur Wailen titnongket, pa hnjam pa horel hor wom wom pa eln nar knokg ti tukol walmpopm pa. ");
INSERT INTO uri_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kil ropon Maur Wailen plaln, kil wreitn kai ari tu disaipel alkilen pa, ari tu pa ipma kalkut paitn, yatom nel hokg atn ase. ");
INSERT INTO uri_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yatom kil la tolpa, “Woi, wa kipm hokg ekg kuina? Ti kipm wreitn ropon Maur Wailen ekg ake al Maur Paitn Satan ak lokepm ekg ake al kipm katnuntopm.” ");
INSERT INTO uri_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yatom Jisas kil ekla tolpa atn, ari tu wrongwailet nel kulngkul. Melnum ur a tu kwe tolpa Jutas pa, kil pa melnum ur a wampwam yikakwomwekg (12) a Jisas pake, apm kil pa wiyen ye kul pake. Kil kai yampingken Jisas pa akal nakrontel. ");
INSERT INTO uri_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ari Jisas ropontel la tolpa, “Jutas, kitn akal nakrontopm tolpa ekg uk Warim Kpman a Melnum ti kai wam a tu wrongmnto pake?” ");
INSERT INTO uri_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tu melnum akwapel a Jisas pa, tu ari kuina ur ekg al paln pa, yatom tu la tolpa, “Wailen, men ik painat ti ik kwaten aki?” ");
INSERT INTO uri_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ari kalpm, wrij ur a tu pa apm ak kwat ase yatom painat pa kwat nungkulkg wien a melnum akwapel a melnum tukgunakgen a melnum ipma krakgen pa ase. ");
INSERT INTO uri_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ari, Jisas wa la tolpa, “Elnten om!” Tolti kil eln wam pa itna nungkulkg a melnum pa, yatom nungkulkg pa wa paln wor itna kiti kiti. ");
INSERT INTO uri_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yatom kil la nasi tu melnum ipma krakgen a Maur Wailen a atn hep pa, wa melnum tukgunakgen a tu a ikghlen wan yalming a Maur Wailen pa, wa melnum wail wail a kul akal arkulel pa la tolpa, “Ti kipm ye painat a yomit ti kul akal arkul kupm tike, tol kupm ti melnum ikgwampet ur akipm pake? ");
INSERT INTO uri_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ti aklei wang kupm ntiepm arpm kahor yipmingki wonen a wan yalming a Maur Wailen pa, ti kipm ake arkulopm ak wang ripa. Pake, wang ketn ti pa, pa wang alkipmen, pa wang a mningket, akal Maur Paitn Satan kil akwap ak titnongket alkilen.” ");
INSERT INTO uri_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tu arkul Jisas pa ye kai kahor wan a melnum tukgunakgen a melnum ipma krakgen pa, Pita pa katnunten tolpa atn watinet ketn ketn katnunten kai kahor. ");
INSERT INTO uri_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kil kai nti tu arkgin wakg wail ur a tu ka arkgin pa ark kor tita ark kahor yipmingki wonen a wan ripa. ");
INSERT INTO uri_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kil arkgin wakg pa arpm ari wakg pa krpo hlentel yatom kin akwapel ur pa ikg kai ariel yatom kil la tolpa, “Ti melnum ur ari tukol a pike nti Jisas atn pa!” ");
INSERT INTO uri_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ari Pita kil akalmpe kai kin pa la tolpa, “Kin! Kupm akwekgel melnum a kitn la pa!” ");
INSERT INTO uri_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wa tu wa ark ketn ketn tolpa kai pa, melnum ur pa ariel yatom wa la tolpa, “Kitn pa melnum ur atu apm kitn pake!” Ari wa Pita akalmpe la tolpa, “Melnum! Kupm ti kalpm!” ");
INSERT INTO uri_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Atn watinet ketn ketn ari wa melnum ur pa la titnongket la tolpa, “Ti kipm la tolhai, melnum a arpm ti pa a ha knokg Kalili, kil pike nti Jisas atn pa.” ");
INSERT INTO uri_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ari wa Pita akalmpe la tolpa, “Kupm ti ake ari kuina ur a kipm la pa!” Pita ekla tolpa atn pa, krek apm la ase. ");
INSERT INTO uri_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yatom Wailen kil pleln ikghnen Pita pa tolpa pa, nikgwalpm a Pita pa apm pleln ase, kil akwonalmpen yangkipm a pike Wailen kil la tolpa, “Am ti ak mning ti krek ake la pen, kitn pal lam nang akupm ti nti wraur, lak kitn ake ari kupm ti.” ");
INSERT INTO uri_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Yatom Pita wreitn kahor hakg paitn paitn kahor hen ai. ");
INSERT INTO uri_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tu melnum a wet arkul Jisas pa, tu nel akhinowel, wa erel. ");
INSERT INTO uri_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tu ak hapm wompel pa ak yipo ikgel plaln, om tu erel kai ikgek, yatom ropontel la tolpa, “Kitn melnum ek wripm pa, kitn la ri, wet mla ur ereitn?” ");
INSERT INTO uri_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wa tu klewel ak yangkipm paitn paitn tiur ai. ");
INSERT INTO uri_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Takgni hompen pa, tu melnum ipma krakgen a atn hep pa, wa tu melnum a arpmen yangkipm yiprokgen a Maur Wailen pa, nel hep kul ark wrij. Tu pa tu hong tukgunakgen a ikghlen tu Juta pa, tu pa arpm ekg atning yangkipmek yatom tu ye Jisas pa kai atn ntekg yangkipmek atn kai tu pake. ");
INSERT INTO uri_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Yatom tu la tolpa, “Ti kitn la niso ri, ti kitn pa Krais aki?” Ari wa Jisas la nasen la tolpa, “Tol kupm la nasepm pa, al kipm la tolpa, kupm akepmplain. ");
INSERT INTO uri_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Wa tol kupm ropontepm pa, kipm ake akalmpe. ");
INSERT INTO uri_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pake tol ak wang ti, a wa hor pa kai pa, Warim Kpman a Melnum ti pa, kil hi arpm kaino wam wien a Maur Wailen a ntie titnongket wrongwailet.” ");
INSERT INTO uri_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yatom wa tu ropontel la tolpa, “Ti kitn ti kitn Warim Kpman a Maur Wailen e?” Ari, wa kil akalmpe la tolpa, “Apm kipm alkipm pa la tolpa pati kupm apm pake.” ");
INSERT INTO uri_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yatom tu la tolpa, “Men ake akal atning melnum ur wa la naso hor pa kai! Men apm wet atning a kil laron kil alkil ngko wurknong ase, ti ha pake!” ");
INSERT INTO uri_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tu hong tukgunakgen wrongwailet ntekg yangkipm namponen Jisas plaln pa, wa tu nel wiyel ha pa ye kai ekg Pailat, ");
INSERT INTO uri_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","yatom la kiti nasi Pailat pa la tolpa, “Men ari melnum ti pa kil wa lok tu wrong kinkpman alpmenen ti kai hor ya paitn, wa kil wa loko ekg ake al men piln takis marpm kai ekg Sisar, melnum tukgunakgen a kipm Rom pa, wa kil kat nang a kil alkil ti la tolpa kil ti Krais, melnum tukgunakgen a Maur Wailen kwa nar akal akwi tu wrong kinkpman.” ");
INSERT INTO uri_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Yatom Pailat pa ropontel la tolpa, “Ti kitn pa melnum tukgunakgen a tu Juta pake?” Ari wa Jisas akalmpe la tolpa, “Apm kitn alkitn pa la pa apm tolpake.” ");
INSERT INTO uri_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Yatom wa Pailat pa la nasi tu melnum a tu ipma krakgen a Maur Wailen a atn hep pa, wa tu wrongwailet a atn pa la tolpa, “Melnum ti ake kupm ari tolpa kil ntekg paitn ur.” ");
INSERT INTO uri_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ari wa tu wa la titnongket paitn la tolpa, “Kil pike akwap ro tukgunakg lngkep a tu wrong kinkpman atn hor ha knokg Jutia ti. Pike kil katen atn kai ha knokg Kalili ai yatom wa ye hor ti kul tike. Tolpa yatom kil ak ntekg nikgwalpm a tu wrong kinkpman pa ark hor pa hor pa.” ");
INSERT INTO uri_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat kil atning a tu melnum wail wail la tolpa yatom kil roponten la tolpa, “Kil ti melnum a Kalili?” ");
INSERT INTO uri_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tu akalmpe la tolpa, “Ei, kil melnum a Kalili pake.” Yatom Pailat la nasi tu ekg tu wiyel ye kai ekg Herot ekg nte, Herot pa kil atn melnum tukgunakgen ikghlen ha knokg Kalili pake. Ak wang pa, Herot apm arpm Jerusalem pa yat pake. ");
INSERT INTO uri_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tu wiyel ye kai paln, om Herot ari Jisas tolpa kil utopen paitn, ekg nte, kil pike atning a tu la Jisas pa, yatom kil pike lantwang atn wang watin ekg kil akal ariel. Wa kil akwonalmpen akal ari Jisas ntekg kwei ur weten ak titnongket alkilen ekg al kil ari. ");
INSERT INTO uri_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yatom Herot kil ropon Jisas ekla wailet, ari ake kil akalmpe ekla ur. ");
INSERT INTO uri_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ari tu melnum ipma krakgen a Maur Wailen a atn hep pa namponen tu melnum a arpmen yangkipm yiprokgen a Maur Wailen pa a ntiel atn pa nel lawel titnongket la tolpa, kil melnum a ntekg paitn paitn. ");
INSERT INTO uri_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yatom Herot namponen tu melnum alkilen a almpwrong pa, nel ari la paitnel, wa ak hinowel. Yatom tu wi hapm ariwor ur pa nowel plaln pa, nel kwawel wa kai ekg Pailat. ");
INSERT INTO uri_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ak wang ripa, Herot ekg Pailat a pike wrongmnto ekg tita pa, wa ekg kai hor wrij. ");
INSERT INTO uri_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yatom Pailat kil kwe tu melnum ipma krakgen a Maur Wailen a atn hep, wa tu melnum wail wail pa namponen tu wrong kinkpman pa nel kul. ");
INSERT INTO uri_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Yatom kil la nasen la tolpa, “Wet kipm wiyel ye kul hep pa, kipm la tolpa kil ak ntekg nikgwalpm a tu wrong kinkpman pa kai hor pa hor pa, pake kupm wet ariel a atning yangkipm akil pa kai ikg a kipm pa, ari ake kupm ari kil ntekg paitn ur, tol a kipm lawel pa. ");
INSERT INTO uri_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Wa Herot pa yat ake wa kil ari a kil ntekg paitn ur, tolpa yatom wa kil kwawel wa kul ekg mento ti. Ti melnum ti ake ntekg paitn ur, ekg al mento almpel mo pa. ");
INSERT INTO uri_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Ti al kupm la tolpa tu erel, plaln pa, kupm kwawel ekg kil kai.” ");
INSERT INTO uri_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ari tu kinkpman wrongwailet a atn pa nel la yikaktnen la tolpa, “Er kil pa mo om! Wa, kwa Parapas pa kulhor hen!” ");
INSERT INTO uri_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tol Parapas pa pike wreitn nti tu akal talpuln kwan tu melnum wail wail a ikghlen ha wail ti kai tukulein, om alm melnum ur mo, yatom tu wiyel ye kai arpm wan tipmning. ");
INSERT INTO uri_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pake Pailat pa wakrongen tolpa al kwa Jisas pa kahor hen, yatom wa kil la nasi tu wrong kinkpman pa nti ur. ");
INSERT INTO uri_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ari wa tu la yikaktnen la tolpa, “Erel om! Erel om! Er mo om! Kurkurntel kai yo kwatingki pa om!” ");
INSERT INTO uri_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Wet Pailat roponten nti wekg ase, ari wa kil wa roponten nti ur la tolpa, “Pike kil ntekg kuina paitn? Ake kupm ari kil pa ntekg paitn ur ekg al kipm erel mo pa! Ti al kupm la tolpa tu erel plaln pa, kupm kwawel ekg kil kai.” ");
INSERT INTO uri_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ari tu atn pa atn pa la plulnplaln mainmain la tolpa, kurkurn Jisas pa om. Yatom ekla a tu pa ak hangken ekla a Pailat pa. ");
INSERT INTO uri_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kil atning a tu wrongwailet tu la titnongket tolpa yatom, kil wi wor ekg al tu karkurn Jisas kai yo kwatingki. ");
INSERT INTO uri_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yatom kil kwa melnum a tu wakrongen a pike talpuln kwan tu melnum wail wail a ikghlen ha wail ti kai tukulein, om alm melnum ur mo. Yatom tu wiyel arpm wan tipmning pa kulhor hen, om kil eln Jisas pa kai wam a tu alntu pa al tu ntekg ak wakrong alntuen. ");
INSERT INTO uri_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yatom tu melnum almpwrong tu wi Jisas pa tolti, tu ye kai. Tu ngkom kai pa, tu hantil melnum ur pa, nang akil pa Saimon, kil melnum kai ha wail Sairini. Kil kul akal kai kahor Jerusalem pa, ari tu lokel tolti tu ukwel yo kwatingki a Jisas pa ekg kil kat ye katnun Jisas pa ntien ye kai. ");
INSERT INTO uri_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tu wrong wailet paitn tu katnun Jisas, namponen tu kin tiur pa, hakg la ak ek namputen reinjel. ");
INSERT INTO uri_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ari Jisas pleln la nasen la tolpa, “Kipm kin a Jerusalem pa! Ampur kipm hakg rein ekg kupm ti pa, kipm hakg rein ekg kipm alkipm ti a ekg tu warim alkipmen pa yat! ");
INSERT INTO uri_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Wang ur hi wa paln, yatom tu hi la tolpa, ‘Tu kin a kmpongmamukij, wa tu kin wnakul, wa tu kin a pike ake uk ma warim pa, ak wang pa tu pa hi utopen pake.’ ");
INSERT INTO uri_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ak wang pa, tu wrongwailet hi wa la nasi tipmning ti la tolpa, ‘Tpor nar ak hauro!’ Om wa la wrik nang ti la tolpa, ‘Ik lampo!’ ");
INSERT INTO uri_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yo mahin kil pa tu ntekg tolpake, wa yo nungkwor pa hi wa tu ntekg paitn wrijen ai.” ");
INSERT INTO uri_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tu melnum almpwrong pa wi melnum wekg ur ye kul, melnum wekg a pike ntekg paitnpaitn, ekg akal karkurnten mo namponen Jisas pa. ");
INSERT INTO uri_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Yatom tu kul paln kul wrik a tu namput tolpa Melnum Tukgunakg Tmpal pa, tu karkurn Jisas kai yo kwatingki namponen melnum ikgwampet wekg pa, ur ark wam wien pa, wa ur ark wam wangkekg. ");
INSERT INTO uri_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yatom Jisas kil la tolpa, “Yan! Kitn kwan paitnpaitn a tu ti, ekg nte, tu ake ari kuina ur a tu ntekg ti.” Yatom tu utop ekg nalu yo hpin, ekg akal ari tolpa mla ur nalu watin pa, al tu pa nampreng hapm alkilen pake. ");
INSERT INTO uri_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Yatom tu wrong kinkpman pa nel atn ikghnen tolpa atn, tu melnum wail wail pa yat nel akhinowel Jisas pa la tolpa, “Kil pike aklin tu tiur ai. Ti tol kil melnum a pike Maur Wailen akrkahan aklahle akal kil akwi tu wrong kinkpman pa, ti kil iklin kil alkil ti yat om!” ");
INSERT INTO uri_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wa tu melnum a almpwrong pa yat nel wa akhinowel, nel kulno tolti ukwel hu wain a armpen ak marpm wasok pa ekg kil akal al, ");
INSERT INTO uri_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","yatom tu nel la tolpa, “Tol kitn melnum tukgunakgen a tu wrong kinkpman a Juta ti pa, kitn iklin kitn alkitn ti om!” ");
INSERT INTO uri_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Hel kaino yo tukgunakg pa tu ro la tolpa, “Melnum rikil pa kil tukgunakgen a tu Juta.” ");
INSERT INTO uri_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wa melnum ikgwampet ur a ark kai yamping wompel a Jisas pa kil wa la akhinowel la tolpa, “Ti kitn ti, kitn melnum a pike Maur Wailen kil akrkahanteitn aki? Pati, wa kitn iklin kitn alkitn ti ri, om wa kitn iklin mentekg ti yat!” ");
INSERT INTO uri_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ari wa ur a ark yamping wompel pa kle ur a la ark kai yamping wompel pa la tolpa, “Ti kitn ake kark ekg Maur Wailen ti? Ti kitn apm ye kalkut wrij tol a kil ye pake. ");
INSERT INTO uri_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tol mentekg ti tu karkurnto komkiti paitn a pike mentekg ntekg pa, pake kil pa ake pike ntekg paitn ur, kalpm.” ");
INSERT INTO uri_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yatom kil la nasi Jisas pa la tolpa, “Jisas, ak wang a hi kitn paln wailen atn kahor kingdom a kitn pa, hi kitn ikwonilmpentopm!” ");
INSERT INTO uri_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ari wa Jisas la nasel la tolpa, “Kupm la naseitn aklahle wrijen la tolpa, am ti kitn pal nti kupm arpm kaino ha Paradais tike.” ");
INSERT INTO uri_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Yatom ak takgni no arpm kuin pa, eln kul kai mning karn tolti ak hmpri takgni ti, ak haur ha knokg wrongwailet pa, atn kaingkai, om wang kai wi wraur pa, mning pa apm kai plaln ase, wa hapm wail a lekg ark kai wan yalming a Maur Wailen pa rekel wom wekg. ");
INSERT INTO uri_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yatom Jisas kil wlakil hakg yikaktnen ak ek namputen yan alkilen pa la tolpa, “Yan, wi maur wor akupm pa om!” Kil la tolpa, om kil apm mo ase. ");
INSERT INTO uri_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Melnum a atn hep ekg tu melnum a almpwrong pa kil ari kweiur kweiur a paln, tolpa yatom kil kat nang a Maur Wailen pa la tolpa, “Aklahle wrijen, kil pa melnum nipet wor.” ");
INSERT INTO uri_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wang a tu wrongwailet a kul ark pa tu ari kweiur kweiur a paln tolpa pa, tu rein paitn tolti, om homtmpok wam kli won tolti om tu pleln wa kaingkai wan ha alntuen ai. ");
INSERT INTO uri_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tu yiprokgen, wa tu melnum wor a Jisas pa, wa tu kin a katnuntel hakaino Kalili ai nar pa, nel atn watin ketn ketn yatom ari kweiur kweiur a paln ripa. ");
INSERT INTO uri_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Melnum ur pa, tu kwe tolpa Josep, melnum ur kai ha wail Arimatea. Ti pa ha ur a ark ha knokg a Jutia, pa kil melnum nipet wor a arpm nungkwangen akal ari Kingdom a Maur Wailen. Kil pa apm wa hong tukgunakgen a arpm atning yangkipm pa yat pake, pake kil ake pike ipma wrij namponen tu kwapwrij alkilen a tu arpm yipon yangkipm ekg ak nikgwalpm tolpa ekg Jisas pa. ");
INSERT INTO uri_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yatom kil kai kahor ari Pailat pa, ekg akal wi yipmri a Jisas pa ye kai uwen. ");
INSERT INTO uri_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Om Pailat wi wor, om kil kulhor kai nalu yipmri a Jisas pa tolti, ye nar ak hapm tungkoren pa yipo plaln om, kil kat ye kai elnthel kahor tipmning teng wonen ur a pike tu uwe weten pa, a ake pike tu eln kmel ur hele pen, kalpm. ");
INSERT INTO uri_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yatom wang pa, wang a tu numprampen kweiur kweiur ekg arpm ekg wi yapm, pa tol wet ti kai eln ak nungkutikg ari kmel ikgukg wekg pa, wa katen ha pa kai hikgkil pa wang miten pa, pa wang wail a tu arpm ekg yapm pake. ");
INSERT INTO uri_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Tu kin tiur a pike nti Jisas hakaino Kalili ai nar pa nel katnun Josep pa, yatom tu ari tipmning teng pa, wa ari a kil eln yipmri a Jisas pa elnthel tolhai. ");
INSERT INTO uri_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tolti, tu wa kai numprampen hu yuwa a wa kweiur kweiur wepmij ekg akal ak nel yipmri akil pa. Yatom ak wang wail pa, tu arpm ekg yapm tol a yangkipm titnongket la pa. ");
INSERT INTO uri_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wang a arpm ekg yapm pa plaln pa, tu kin pa wreitn ak kang mningket paitn ai ye kweiur kweiur wepmij wor a tu numprampen pa ye kai tipmning teng pa akal ak nel yipmri a Jisas pa. ");
INSERT INTO uri_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pake tu ari weij a ak hmpri tipmning teng ek pa, pa apm wa talpul tukulein ase, ");
INSERT INTO uri_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","yatom tu kai kahor tipmning teng wonen pa ari, ake tu ari yipmri a Wailen Jisas pa. ");
INSERT INTO uri_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Yatom tu atn akwonalmpen wailet atn pa, ari tu wutnan ekg ari melnum wekg ur a nowe hapm tungkoren muinmainet paitn ai paln atn yampingkenten. ");
INSERT INTO uri_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tu kin pa ari tolpa tu kark paitn, yatom nel homtmpok lam ikg alntuen pa kinar knokg tolti, ari melnum wekg pa la nasen la tolpa, “Ti wa kipm kul kor melnum a arpm mlepm ti kul wrik a uwen tu kmel a mo ti, ekg nte? ");
INSERT INTO uri_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ti kipm ri kil ake ha ti, kil apm wreitn ase. Ti kipm ikwonilmpen yangkipm a pike kil la nasepm hakaino Kalili pa la tolpa, ");
INSERT INTO uri_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Warim Kpman a Melnum hi tu uk kai wam a tu melnum a ntekg paitnpaitn pa, yatom hi tu karkurntel kai yo kwatingki pa wiyel ye kai uwentel, om ak wang wraur pa kil hi wa wreitn.’ ” ");
INSERT INTO uri_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yatom wa tu kin akwonalmpen yangkipm a pike kil la pa, ");
INSERT INTO uri_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","yatom tu wa pleln atn wrik a tu uwen Jisas pa kai tolti, la kiti nasi tu melnum wampwam yikakwomwrij a Jisas pa, namponen tu wrongwailet pa, ekg kweiur kweiur wrongwailet a wet tu ari a paln pa. ");
INSERT INTO uri_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tu kin a kai la kiti yangkipm pa nasi tu melnum yangkipm kuinen a Jisas pa pati, Maria a ha wail Maktala, a Joana, a Maria, man a Jems pa, wa tu kin tiur ai namponenten. ");
INSERT INTO uri_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ari tu pa la tolpa, plpa tu la yangkipm akplain ur tolti. Tu ake ukpma ekla a tu la pa. ");
INSERT INTO uri_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ari Pita pa kil wreitn tolti, kil aktutu kai wrik a pike tu eln Jisas hele pa, yatom kil atn hen ti ikglangken ari, kil ari hapm kalpmel tolti ha. Yatom kil wa pleln kai tolti om wa kil akwonalmpen wailet ekg kweiur kweiur a wet paln ripa. ");
INSERT INTO uri_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ak wang pa, disaipel wekg ur a Jisas pa, tuwekg akal ekg kai ha ur a tu kwe tolpa Emeus, ha ur a ark watinet ketn, tol kilomita wampwam yikakwomwrij (11), ekg Jerusalem pa. ");
INSERT INTO uri_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yatom tuwekg kor la kiti hor ya pa kai ekg kweiur kweiur wrongwailet a pike paln ripa. ");
INSERT INTO uri_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tuwekg ekla wailet la kiti tolpa kai pa, Jisas kil alkil palnten ngkom ntien kai kompwrij tolpa kai. ");
INSERT INTO uri_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yatom kwei ur ak hmprien ikg, om tuwekg ake ari tolpa, kil pa Jisas. ");
INSERT INTO uri_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yatom Jisas roponten la tolpa, “Kipmekg la kiti kuina ur itna wampel kai?” Om tuwekg atning tolpa, tuwekg kai atn ya pa, yatom kil ari tolpa tuwekg pa ipma kalkut. ");
INSERT INTO uri_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yatom wrij ur a tuwekg pa tu kwe tolpa Kliopas. Pa kil akalmpe tolpa, “Ti kitn wrij hute ti kitn ake ari kweiur kweiur wailmanten a pike paln kai Jerusalem pa?” ");
INSERT INTO uri_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ari wa Jisas roponten la tolpa, “Kuina ai?” Ari wa tuwekg akalmpe la tolpa, “Mentekg wet la kiti Jisas a Nasaret pa. Kil melnum ek wripm a Maur Wailen akrkahan ukwel titnongket, yatom kil laron yangkipm namponen titnongket, wa ntekg kweiur kweiur titnongket weten, yatom tu wrong kinkpman ariel tolpa kil pa melnum wailen pake. ");
INSERT INTO uri_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tu melnum ipma krakgen a Maur Wailen a atn hep wa tu melnum wail wail amen ti uk kil kai wam a tu Rom ekg erel mo, yatom tu karkurntel kai yo kwatingki. ");
INSERT INTO uri_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ari men ti pike akwonalmpen tolpa kil pa melnum a tol kil ikirmpen mento Israel pake! Yatom kweiur kweiur a pike paln pa, apm tol wang wraur ase. ");
INSERT INTO uri_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Yatom wet ti ak kang pa, wa men wreitn paitn ekg tu kin tiur alpmenen, tu wreitn ak kang mningket paitn ai kai kahor tipmning teng wonen a tu eln Jisas hele pa. ");
INSERT INTO uri_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ari tu kai ari yipmri akil pa ake ha. Yatom tu wa plelnten kul la naso la tolpa, tu ari maur akwapel wekg a Maur Wailen pa, yatom tuwekg la nasen la tolpa, kil apm wreitn arpm mlepm ase. ");
INSERT INTO uri_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Yatom wa tu tiur alpmenen pa wa pike nel kai wrik a tu elntel hele pa ari apm tol a tu kin pa la kiti pake: ake tu ariel.” ");
INSERT INTO uri_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yatom Jisas la nasen la tolpa, “Ti kipmekg ti hmit, ake wa kipmekg akwonalmpen yangkipm wrongwailet a pike tu melnum ek wripm a Maur Wailen la pa! ");
INSERT INTO uri_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ti kipmekg ti ake ari tolpa melnum a Maur Wailen kwa nar ekg akwi tu wrong kinkpman pa, kil wi wleket wail ripa plaln pa, kil kai arpm namponen Maur Wailen, wi titnongket klalen wail pa?” ");
INSERT INTO uri_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yatom Jisas laron yangkipm yiprokgen wrongwailet a la kiti kil ti nasen katen kai Moses ai, wa kulngkul tu melnum ek wripm a Maur Wailen a tu ro hel kai wurkapm a Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tunten kul yampingken ha a tuwekg akal arpme pa, yatom Jisas pa akplainel ipma a tuwekg pa akal kai ekg haren kai om, ");
INSERT INTO uri_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ari wa tuwekg pa lokel la tolpa, “Ti mning krehet ekg al mning tike, ti kitn kul ntio hokgi tipen.” Yatom kil kahor akal ntien arpm. ");
INSERT INTO uri_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tunten arpm akal al ekpma pa, kil wi nak tingklak pa ukwor Maur Wailen plaln pa, kil kpor ukwen. ");
INSERT INTO uri_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kil ntekg tolpa yatom, ikg a tuwekg pa apm nungkwat ariel, ari kil apm wa kai hamten ase. ");
INSERT INTO uri_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Yatom tuwekg nasi tita la tolpa, “Aklahle! Ti wet kil la kiti naso yiprokgen a hel kai Wurkapm a Maur Wailen pa ngko ya pa, pa wet ak ntekg ipma a mentekg ti utopen paitn.” ");
INSERT INTO uri_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yatom ak wang ketn pa tuwekg wreitn tolti, pleln kai Jerusalem ari tu melnum yangkipm kuinen wampwam yikakwomwrij a Jisas nti tu tiur pa kor tita ark. ");
INSERT INTO uri_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ari tu hmprak la kiti nasen kuina ur a wet paln ekg Saimon pa, pa la tolpa, “Wailen apm wreitn aklahle ase! Ti kil wet paln kai Saimon, kil ariel pa.” ");
INSERT INTO uri_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tu la tolpa nasen plaln pa, tuwekg ti wa la nasen la tolpa, Jisas palnten ngko ya pa, yatom tunten ngkom hor ya pa kai pa tuwekg ake ari tolpa kil Jisas pa, om tunten kai paln arpm kai wan pa. Kil kpor nak tingklak pa ukwen plaln pa, om tuwekg ari tolpa Jisas apm pake. ");
INSERT INTO uri_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tu disaipel a Jisas tu la kiti la tolpa atn pa, Wailen pa palnten aktutu tolti la nasen la tolpa, “Ipma akipm pa irk mehen!” ");
INSERT INTO uri_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ari tu akwonalmpen tolpa tu ari maur a kmel ur yatom tu kark paitn wrijen tolti. ");
INSERT INTO uri_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ari wa kil la nasen la tolpa, “Ti wa kipm wreitn paitn akwonalmpen wailet ekg nte? ");
INSERT INTO uri_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ti kipm ri nepm wam akupm ti! Wa kipm ari tolpa, pa apm kupm apm tike. Ti kipm kul ri wampirpme ik wampla ik itningke numpwam akupm ti! Lak maur pa, tol ake kipm ari palk a knal tol a kipm ari kupm ti.” ");
INSERT INTO uri_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kil la tolpa plaln pa, kil planten nepm wam akil pa. ");
INSERT INTO uri_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Yatom tu utopen, pake nikgwalpm a tu pa ark nowe nare, ake kai wrij. Om kil roponten la tolpa, “Kipm ye ekpma ur aki?” ");
INSERT INTO uri_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yatom tu ukwel yul tiel a wet tu aliln pa, ");
INSERT INTO uri_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","om tu ari a kil wi al. ");
INSERT INTO uri_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kil al yul pa plaln pa, kil la nasen la tolpa, “Kipm ari pa, pike kupm ntiepm arpm pa, kupm la nasepm yangkipmek wrongwailet a hel kai wurkapm a Moses a tu melnum ek wripm a Maur Wailen ro pa, wa hel kai wurkapm a Nangnang pa, a ak la kupm ti pa, pa apm paln ek arke ase, ti apm paln apm tike.” ");
INSERT INTO uri_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yatom kil ntekg nikgwalpm a tu pa paln wonrekele ari yangkipm wrongwailet a Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yatom kil la nasen la tolpa, “Tu ro la tolpa, melnum a Maur Wailen kwa nar ekg akwi tu wrong kinkpman pa, hi kil mo, om ak wang wraur pa, kil apm wa wreitn arpm. ");
INSERT INTO uri_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Hi wa tu laron nang akil pa nasi tu wrong kinkpman pa, hi tu pleln ipma, yatom hi kil kwan paitnpaitn atu. Hi tu katen kwap ripa ak atn Jerusalem ti, yatom ye kai knokg wrongwailet ai. ");
INSERT INTO uri_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kipm alkipm ti pike nungkulkg a ikg ekg kweiur kweiur wrongwailet a paln pa, ti hi apm kipm alkipm ti laron nasi tu wrong kinkpman tike. ");
INSERT INTO uri_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ti kipm itning, hi kupm kwa Maur Wor nar ekg kipm a pike Yan alkupmen kil yipon yangkipm pa. Ti hi kipm irk nungkwangen irk ha wail ti irk kai ngko wang a hi kipm wi titnongket wail a Maur Wailen pa.” ");
INSERT INTO uri_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yatom Jisas wi tu disaipel alkilen pa nel kai kinar ngko yampingken ha Petani pa, yatom kil kat wam pa, wa kil ropon Maur Wailen ekg al kil aklinjen. ");
INSERT INTO uri_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kil ropon Maur Wailen tolpa atn pa, kil nuhurnten tolti, Maur Wailen wiyel tolpa ye kai kaino ha wor alkilen ase. ");
INSERT INTO uri_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tu kpor klko lein kat nang akil plaln pa, tu pleln kaino kahor Jerusalem pa namponen utopen wailmanten. ");
INSERT INTO uri_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Yatom tu ark wan yalming a Maur Wailen pa kat nang akil pa ukwel wor aklei wang tolti ark.");
INSERT INTO uri_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Melnum wor Tiopilus kupm ukweitn wor. Kupm pike ro wurkapm pa ak la naseitn ekg kwap kweiur kweiur wrongwailet a pike Jisas kil ak ekg kaling plan ro tukgunakg lngkep a tu wrong kinkpman ak hep ai ");
INSERT INTO uri_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kulngkul ngko wang a Maur Wailen wiyel ye kaino kwa ase. Kulngkul ngko wang a kil mo wa wreitn yatom kil paln kai tu melnum yangkipm kuinen alkilen a kil akrkahan pa om Maur Wor aklinjel yatom kil ukwen kwap a yangkipmek wrongwailet pa plaln pa, Maur Wailen wiyel ye kaino kwa kaino ha wor alkilen ase. ");
INSERT INTO uri_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ak wang a kil arpm knokg ti pa kil ye kalkut wailet yatom kil mo, om kil wa wreitn plan kil alkil ti ngko wurknong, yatom tu ariel tolpa kil apm wreitn ase. Ake melnum ur akwonalmpen wailet tolpa kil ake wa wreitn pa. Tu ariel kil paln wli pa wli pa nti wailet, wa kil laron yangkipm wor ekg Kingdom a Maur Wailen, tolpa kai wang kmel wekg (40). ");
INSERT INTO uri_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Wang ur pa kil paln nti tu melnum yangkipm kuinen alkilen pa kai ark wrij, yatom kil la karkurnten la nasen la tolpa, “Ampur kipm nuhurn Jerusalem pa pen. Kipm irk nungkwangen kwei ur a pike Yan alkupmen yipon yangkipm ekg akal ukwepm, tol pike a kupm la nasepm pa. ");
INSERT INTO uri_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon kil pike kalukepm ak hu tolti, pake wang yampingken ekg Yan a kupm hi kalukepm ak Maur Wor alkilen.” ");
INSERT INTO uri_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ak wang ur pa kil paln kai tu melnum yangkipm kuinen alkilen a tu kul ark wrij pa, yatom tu ropontel la tolpa, “Wailen, wang a kitn la pa apm tike aki, ekg kitn akal wreitn atn tukgunakgen ikghlen mento Israel pa, tol a pike tu melnum tukgunakgen alpmenen ikghlento pa?” ");
INSERT INTO uri_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ari Jisas la nasen la tolpa, “Pa ake kwei ur a kipm ti ekg al kipm atning ari pa, kalpm, pa kweiur kweiur a Yan alkupmen a kil alkil ai alm wang alkil ai, wa kil alkil lak hi paln pa, hi paln. ");
INSERT INTO uri_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pake hi Maur Wor nar wiyepm pa kipm hi wi titnongket yatom kipm hi laron nang akupm atn ha wail Jerusalem ti wa hor ha knokg Jutia ti wa hor kai ha knokg Samaria a wa ye tolpa hor pa kai knokg wrongwailet.” ");
INSERT INTO uri_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kil la nasen yangkipmek pa plaln pa, Maur Wailen wiyel ye kaino kwa, wa tu melnum yangkipm kuinen alkilen pa atn ikghnentel tolpa atn, kil kaino kaino tolpa kai eln kahor ham kahor weipmunu wonen ai tolti om ake tu ntie ekg ariel. ");
INSERT INTO uri_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tu atn ikghnentel kaino ktnong tolpa atn kaingkai, tu wreitn paitn ekg ari melnum wekg ur pa paln atn yampingken tu ti. Tuwekg pa nowe hapm tungkoren muinmainet pa. ");
INSERT INTO uri_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Wa tuwekg roponten la tolpa, “Kipm melnum a Kalili, ntekg tolhai ti kipm al wa atn ti ikghnen titnongket kaino ktnong pa? Pa apm Jisas kil alkil pa, melnum a wet Maur Wailen wiyel ye kaino ktnong pa, apm kil hi wa nar tol a wet kipm ariel a kil kaino pake.” ");
INSERT INTO uri_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wrik a tu melnum yangkipm kuinen a Jisas atne pa pati pa tu kwe la tolpa tipmning Olip. Tu atn ari Jisas kil kaino ktnong plaln pa, tu ha pa wa nar kul kai ha wail Jerusalem a ark yampingken tol tu ntie ekg ngkom ak wang a tu arpm ekg yapm pa. ");
INSERT INTO uri_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tu kai paln kai Jerusalem pa, tu kai kaino wan wlop ur a hel kaino kwa, pa wrik a tu arke arke. Nang a tu melnum pa pati kil: Pita, Jon, Jems, Antru, Pilip, Tomas, Partolomyu, Matyu, wa Jems, warim kpman a Alpius, wa Saimon, melnum ur a tu Selot, wa Jutas, warim kpman a Jems. ");
INSERT INTO uri_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tu kulkai kahor kor tita ark wrij namponen tu kin tiur, wa man a Jisas, wa namponen tu wasokwasok a Jisas. Tu apm ye nikgwalpm wrij tolpa ark pake ekg ropon Maur Wailen aklei wang. ");
INSERT INTO uri_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tu ark tolpa kai, wang ur pa tu alntu melnum yangkipm kuinen a Jisas namponen tu wrongwailet paitn tu kul kor tita ark wrij. Tu wrong pa paln tol kmel wampomit wampomwrij (120). Yatom Pita kil wreitn atn la nasen la tolpa, ");
INSERT INTO uri_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Kipm melnum worwor alkupmen, kipm itning, kuina ur a pike paln kai Jutas, melnum a pike uk ya ekg tu arkul Jisas pa om erel, pa apm paln komkiti tol ek a Maur Wor a Maur Wailen la hep ak ai wli ek a Teipit yatom kil ro hel kai wurkapm a nangnang alkilen pa. ");
INSERT INTO uri_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jutas pa apm pike melnum yangkipm kuinen ur alpmenen a kil ak kwap wrij tol a men ak tike, laron yangkipm a Maur Wailen ekg aklin tu wrong kinkpman. ");
INSERT INTO uri_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Marpm a Jutas ak armpen knokg pa, kil wi hor ya paitn, tolpa yatom kil ngko eln kai knokg ti yatom ipma a kil pa pus wa nikg a kil pa sruij hor ha knokg. ");
INSERT INTO uri_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ti tu wrongwailet a ark kai Jerusalem pa tu atning ari pa, yatom tu alil nangkel knokg pa ak ek hawen alntuen pa la tolpa Akeltama, yiprokgen a wrik nang kil pa pati, ‘Knokg a walmpopm hawe.’ ” ");
INSERT INTO uri_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Wa Pita kil wa la tolpa, “Ti yangkipm kil a ro hel kai wurkapm a Nangnang a Teipit pa la tolpa, ‘Ti knokg a kil pa al atn kalpmel, wa ampur melnum ur arpme, kalpm.’ Ti wa ro yat la tolpa, ‘Al melnum manet ur wi wrik a kwap a kil.’ ” ");
INSERT INTO uri_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Tolpa ti al mento akrkahan melnum ur a pike ntio atn aklei wang ak wang a Jisas kil ntio atn a arpm, ak wang a pike Jon kil kaluk Jisas, hakai ai kulngkul ngko wang a Maur Wailen Yan alkil wiyel ye kaino ktnong. Tolpa ti al mento akrkahan melnum ur a pike ikg a nungkulkg ntio atn pa kul ntio atn ekg al men nasi tu wrong kinkpman pa ekg Jisas a pike mo pa apm wa wreitn ase.” ");
INSERT INTO uri_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita la tolpa plaln pa tu akrkahan melnum wekg, ur pa Josep a tu kwe tolpa Parsapas, wa nang wompel akil pa Jastus, wa ur pa Matias. ");
INSERT INTO uri_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Yatom tu ropon Maur Wailen pa la tolpa, “Wailen, kitn alkitn pa ari nikgwalpm a men melnum wrongwailet ti. Al kitn planto wrij ur a tuwekg ti a kitn akal akrkahan ");
INSERT INTO uri_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ekg wi wrik a Jutas pa paln melnum yangkipm kuinen alkitnen. Ti kwap pa pike Jutas ntio ak pa, yatom kil nuhurn atn pa, wa kil mo om kil kai wrik ur alkil a tu melnum paitn a tolpa kai arpme pake.” ");
INSERT INTO uri_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Yatom tu kpor ker wekg ur, warkip ur watin ur ekg akal mla ur nalu watin pa, kil pa wa wi wrik a Jutas pa, yatom apm Matias pa nalu watin pake, yatom apm kil pa wi wrik a Jutas kai akntie tu melnum yangkipm kuinen wampwam yikakwomwrij a Jisas pake. ");
INSERT INTO uri_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Wang wail a Pentikos pa paln plaln pa, yatom tu ipma wrij a ukpma Krais pa ak wail kai ark wrij tolpa ark. ");
INSERT INTO uri_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tu ark ari kalpm, tu atning lko wail tukol wripm wail pa eln pupu hakaino ktnong pa kul nar kai kahor nti wan a tu arke pa. ");
INSERT INTO uri_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tu ari wakg ek ur kul paln nar ari tukol ek mlip a tu melnum pa purnprarn kai helen tukgunakg a tu melnum pa wrij wrij. ");
INSERT INTO uri_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tu a ark kahor wan pa Maur Wor pa nar arpm kahor ipmanikg atu pa plalnten, yatom tu ak ek wailet aur aur. Pa Maur Wor pa ekla kahor ipmanikg alntuen pa, yatom paln no tu la ak ek alntuen pa wrij wrij. ");
INSERT INTO uri_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ak wang pa tu Juta tiur a pike ark hor ha knokg wrongwailet ti pa, tu kul ark Jerusalem. Tu pa tu melnum a kpor klko lein Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tu atning lko wail tolpa, yatom nel ak wail ha pa ha pa kul atning tu melnum a wet Maur Wor wiyen pa tu ak ek hawen wrij wrij a tu a kul atn atning pa tu ak la, tolpa yatom tu wreitn paitn ekg atning pa. ");
INSERT INTO uri_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tu wreitn paitn tolti kor la tolpa nasi tita la tolpa, “Tu melnum a ekla kil pa, tu melnum a ha knokg Kalili! ");
INSERT INTO uri_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ari wa ntekg tolhai yatom wa men atning a tu ak ek hawen manet manet a men wrij wrij ak ti pa? ");
INSERT INTO uri_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ti men ti wli hakai ha knokg Partia, wa tiur pa wli hakai ha knokg tiur ai a kwe tolpa Mitia a Elam. Wa tiur pa wli hakai ha knokg a Mesopotemia, wa ha knokg Jutia, wa ha knokg Kapatosia, wa ha knokg Pontus, wa ha knokg Esia. ");
INSERT INTO uri_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Wa tiur pa hakai ha knokg a Prikia, wa ha knokg Pampilia, wa ha knokg Ijip. Wa men tiur pa wli hakai ha knokg Lipia a ark yampingken ha wail Sairini, ti men tiur ti apm hakai ha wail Rom pake. ");
INSERT INTO uri_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ti men knokg yiprokg a Juta ti, wa tu a ake Juta, pake tu pleln katnun yangkipm a ya a men Juta ti, ti men tiur ti pa hakai ha knokg Krit, wa men tiur pa hakai ha knokg Arepia. Ti wa ntekg tolhai yatom wa men wrongwailet, men atning a tu laron kwap titnongket a Maur Wailen ak ek hawen wrij wrij alpmenen ti?” ");
INSERT INTO uri_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tu wreitn paitn tolti akwonalmpen wailet ropon tita la tolpa, “Pa tu ntekg kuina ur tolpa?” ");
INSERT INTO uri_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ari tu tiur pa tu la akhinowel tu pa la tolpa, “Plpa tu al hu wain hmit wailet om ri tu hmit hmit pa.” ");
INSERT INTO uri_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tu akwonalmpen wailet om wa ropon tita tolpa atn pa, Pita kil wreitn namponen tu melnum yangkipm kuinen wampwam yikakwomwrij a Jisas pa, yatom kil la yikaktnen nasi tu wrong kinkpman wailet a ark pa la tolpa, “Kipm melnum a Juta, wa kipm mla ur a kul ark Jerusalem ti pa, kupm akal la nasepm ekg kuina ur a kipm ari kil yekworwor, tolpa ti kupm akal la tolpa kipm eln nungkulkg pa hi ekg itning kuina ur a kupm akal la nasepm kil. ");
INSERT INTO uri_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tu melnum kil pa ake tu al hu wain hmit pa, yatom tu hmit hmit pa, tol a kipm akwonalmpen pa, kalpm, kil takgni no alm numpalk wleket tolti pen. ");
INSERT INTO uri_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kuina ur a kipm atning ari ti pa pati, pike paln kai ek a melnum ek wripm Joel la hep ak ai, yatom ro hel kai wurkapm pa la tolpa, ");
INSERT INTO uri_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Maur Wailen la tolpa, “Hi ak wang humpuen pa, hi kupm kwa Maur Wor akupm kil kinar kahor arpm tu kinkpman wrongwailet. Ti tu warim kin a warim kpman akipm pa hi Maur Wor akupm katen ek, yatom tu laron yangkipm akupm tol tu melnum ek wripm. Wa tu kpman warimpen akipm pa ari kweiur kweiur a hi Maur Wor akupm planten tukol ak hokgwangket pa. Wa tu wror wror akipm pa hi wa planten kai hokgwangket. ");
INSERT INTO uri_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ti wa kai tu kinkpman akwapel akupm pa yat, hi kupm kwa Maur Wor akupm kil kinar kahor arpm tu ak wang pa, ti tu hi wa Maur Wor akupm ti katen ek, yatom tu hi laron yangkipm akupm tol tu melnum ek wripm. ");
INSERT INTO uri_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Hi wa kupm plan kweiur kweiur titnongket weten weten a kipm melnum hi wreitn paitn ekg ari atn kaino ktnong pa. Hi wa kupm plantepm klal ur atn kinar knokg pa ekg ak plan wang ripa, pa hi tu ari walmpopm, a wakg, a wakghuwakg kuntukij paitn hi nakur ye no no. ");
INSERT INTO uri_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Wa takgni pa hi nir kulkai mninget, a kainil pa hi paln watet tukol walmpopm pa, tolpa pati yampingken wang a Wailen ekg al paln namponen titnongket a klalen wail alkilen pake. ");
INSERT INTO uri_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Hi ak wang pa mla ur kil hi kwe nang a Wailen pa, hi kil wiyel ekg alkilen pake.” Pa ek a Maur Wailen pike paln kai ek a melnum ek wripm Joel la pa.’ ");
INSERT INTO uri_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ekla a hel wurkapm a Maur Wailen pa apm la tolpake, tolpa ti kipm melnum a Israel, kipm eln nungkulkg pa hi ekg itning yangkipm kil a kupm akal la nasepm pa: Jisas a Nasaret pa melnum a pike Maur Wailen akrkahan ekg nar ekg akal aklin kipm pake. Ti kil pike ntekg kweiur kweiur weten a ake melnum ur ntie ekg ntekg, kweiur kweiur titnongket wrongwailet, wa kil eln klal wailet pa elntatn, ti kipm ari pa. Pa Maur Wailen ak plantepm ekg kipm ari tolpa, apm Maur Wailen kil alkil pa kwa Melnum pa nar pake. ");
INSERT INTO uri_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ari kipm wi melnum pa uk kai wam a tu melnum a ake katnun yangkipm titnongket a men Juta pa yatom tu karkurntel kai yo kwatingki om kil mo. Pake pike hep ak ai, wa wakrong a arie a Maur Wailen kil alkil ai tolpake, yatom apm kil akwonalmpen pa yat ase, al kil hi eln Jisas eln kai wam akipm. Om kipm pike ak katnun tolpake. ");
INSERT INTO uri_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ari Maur Wailen la ekg kil wreitn, wa kwan kalkut a wleket a kil mo pa kai tukuleinjel. Ekg nte, mo ti ake ntie titnongket ekg nampilel arpm wrik a tu mo kai arpme pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tol mento klein kai wurkapm a Nangnang a Teipit wi ek a Jisas pa ro la tolpa, ‘Kupm aklei wang ari Wailen kil ntiopm arpm. Kil atn yampingkentopm ukopm titnongket, ekg ake ntie ekg al kupm wutat ngko pa. ");
INSERT INTO uri_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Tolpa yatom ipma akupm pa utopen paitn, wa ek akupm ti ak ak nangnang utopen kat nang a Maur Wailen tolti. Ekg nte, numpalk ti pa hi mo kinar arpm knokg ti, pake kupm ari tolpa hi wa kupm wreitn. ");
INSERT INTO uri_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kupm ari tolpa Maur Wailen kitn hi ake eln maur wor akupm pa ha ha aklei wang kai wrik a uwen melnum a mo pa. Wa kitn hi ake elnten numpalk a kupm Melnum Wri Wor alkitnen kil kai ha mampij paitn pa. ");
INSERT INTO uri_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ti kitn pike plantopm ya wor a arpm aklei wang, wa kitn hi wiopm ye kaino ntieitn arpm, wa ukopm utopen wailmanten.’ Yangkipm a pike Teipit wi ek a Jisas la pa, apm kupm la kiti nasepm kai pake. ");
INSERT INTO uri_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ti kipm wasokwasok a wailwail alkupm pa, kupm al la nasepm wrijen ngko wurknong la tolpa, mento wrongwailet ari yohmpei alpmenen Teipit pa tolpa, pike kil mo, tu uwen kil kinar kirkhap, ti kirkhap a kil pa ha yampingkento ha tike. Ti ak wang ti pa mento ari kirkhap pa, a ha ha wurknong. ");
INSERT INTO uri_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Teipit pa kil melnum ek wripm a Maur Wailen, yatom Maur Wailen kil kwe nang akil, yatom wa yipon yangkipm namponen Teipit pa la tolpa, kil hi kat warim walmpopmen ur a Teipit pa hi wa paln melnum wail ur a atn melnum tukgunakgen tukol Teipit kil alkil pa. ");
INSERT INTO uri_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Teipit kil ari pa hep ak ai ekg kuina ur a Maur Wailen akal ntekg pa, tolpa yatom kil laron Krais, melnum a Maur Wailen akrkahan ekg kwa nar akarmpen paitnpaitn amen ti la tolpa, kil hi mo om wa wreitn. Yatom wa kil wa la tolpa Maur Wailen hi ake wa eln numpalk a Krais pa ha mampij kinar kirkhap a uwen tu melnum pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yatom apm Jisas pake, a pike mo yatom Maur Wailen la om kil wa wreitn. Ti men wrongwailet men pike ikg a nungkulkg ari ripa, yatom men laron pake. ");
INSERT INTO uri_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kil apm Maur Wailen Yan alkilen katel arpm kai wam wien a kil om ukwel nang wail ase, wa kil wi Maur Wor a pike Yan alkil yipon yangkipm namponentel pa, yatom kil kwa Maur Wor pa narnto, ti apm kipm atning ari atn tike. ");
INSERT INTO uri_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Teipit kil alkil pa pike ake wreitn kaino ha wor a Maur Wailen pa, kalpm. Pike kil la hel wurkapm a Nangnang alkilen pa la kiti Jisas pa la tolkil, ‘Maur Wailen pa nasi Krais Wailen akupm pa la tolpa, “Kitn kulno irpm wam wien a kupm, ekg al kupm ukweitn titnongket akupm wa ukweitn nang wail. ");
INSERT INTO uri_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Kitn kul no irpm, kupm eln tu wrongmnto alkitnen ti itn horhanekg ekg kitn.” ’ ");
INSERT INTO uri_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Tolpa ti kipm wrong kinkpman a Israel pa, kipm wi arie rikil worwor: Jisas, melnum a pike kipm karkurntel mo kai yo kwatingki pa pati, pa pike Maur Wailen alkil la ekg kil Wailen, wa kil Krais, melnum a pike kil akrkahan ekg akarmpen mento wrong kinkpman ti.” ");
INSERT INTO uri_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tu wrong kinkpman atning yangkipm a Pita la ripa, pa almpen ipma paitn. Yatom tu ropon Pita namponen tu melnum yangkipm kuinen a Jisas pa la tolpa, “Kipm melnum wor alpmenen ti, al men ntekg tolhai?” ");
INSERT INTO uri_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ari Pita pa akalmpenten la tolpa, “Kipm wrij wrij ti al kipm pleln ipma, yatom kipm kul ekg al men kalukepm ak nang a Jisas Krais, ekg al Maur Wailen kwan paitnpaitn akipm kai tukuleinjepm, plaln pa, kipm wi Maur Wor a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Maur Wailen apm pike yipon yangkipm namponen kipm pa, wa tu warim warim walyikek akipm pa ye hor pa kai pake, akal hi kil ukwepm Maur Wor alkilen pa. Wa namponen tu mla ur a ark hor ha ya watinet pa yat, apm tu a Wailen, Maur Wailen alpmenen kwewen pake, ekg tu kul ekg kil yat.” ");
INSERT INTO uri_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita kil piln yangkipm la nasen tolpa kai, yatom kil wa la karkurnten loken la tolpa, “Kipm irpm ikgirpme kipm alkipm, ekg hi ake kipm wi wleket tukol tu melnum a ntekg paitnpaitn ti om hi wi wleket ekg paitn a tu ntekg pa.” ");
INSERT INTO uri_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tu wrong wailet atning yangkipm a Pita laron nasen ripa, yatom tu a ukpma katnun pa, tu kaluken. Ti tu melnum a ukpma Jisas ak wang ripa, pa paln wailet paitn ai (3,000). ");
INSERT INTO uri_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ti tu a ukpma katnun yangkipm a tu melnum yangkipm kuinen a Jisas rowen tukgunakg lngkep pa, tu uk tu alntu kai ekg atning katnun yangkipm pake. Tu aklei wang kai ark wrij al ekpma wa wi ekpma a Jisas wa ropon Maur Wailen tolpa ark pake. ");
INSERT INTO uri_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Maur Wailen kil ntekg kweiur kweiur weten titnongket kai wam a tu melnum yangkipm kuinen a Jisas om tu wrongwailet ari om tu kark paitn. ");
INSERT INTO uri_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tu kinkpman a ukpma Jisas pa, tu apm kaingkai ark wrij tolpake, wa tu alupm nikgwalpm tolpa ekg kweiur kweiur alntuen pa a tu wrongwailet. ");
INSERT INTO uri_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yatom tu uk knokg a kuina ur alntuen pa kai ekg tu armpenten, yatom tu wi marpm pa om tu aklin tu mla ur a arpm warkip pa. ");
INSERT INTO uri_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Aklei wang wrij wrij pa tu apm nel kai ark wrij ark yipmingki wonen a wan yalming a Maur Wailen. Tu nel utopen aklin tita ekg ekpma kweiur kweiur ti ye kai kor tita ekg al ark wrij, a wa wi ekpma a Jisas al tolpa wan ur wan ur ark pake. ");
INSERT INTO uri_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tu kat nang a Maur Wailen om utopen tolpa ark. Tu wrongwailet arien tolpa, tu utopen kporn yangkipm. Aklei wang wrij wrij pa titnongket a Wailen Jisas akwap ekg akwi tu melnum weten weten tiur ye kai namponen tu a Maur Wailen akwiyen ye kai ekg alkilen ase. Tolpa om tu paln wailet ye hor pa kai. ");
INSERT INTO uri_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wangkur ak nungkutikg pa wel tukoryok la ekg kwa takgni kinar tmpal, om Pita ekg Jon tuwekg akal kai kahor yipmingki wonen a wan yalming a Maur Wailen pa, takgni wang a tu Juta a ropon Maur Wailen apm pake. ");
INSERT INTO uri_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tuwekg kai kahor ngko yipmingki yun ur a tu kwe la tolpa Yipmingki Yun Ariwor pa akal kai kahor wonen pa, tu kat melnum ur a pike nepm mowe arpm kahor ipma wonen pa ye kai kahor arpm yipmingki yun. Aklei wang pa tu katel ye kaingkai arpm wanyun ripa ekg kil arpm pa ekg kwempen marpm kweiur kweiur ekg tu a kai kahor kulhor wan yalming pa. ");
INSERT INTO uri_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Melnum pa ari Pita namponen Jon pa akal kai kahor pa, kil roponten ekg tuwekg ukwel kweiur. ");
INSERT INTO uri_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ari Pita pa ikghnentel titnongket, wa Jon pa yat, yatom Pita pa la nasel la tolpa, “Kitn ri mentekg ti!” ");
INSERT INTO uri_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yatom melnum pa ikgkitien, om wa akwonalmpen nungkwangen tolpa, tuwekg pa al ukwel kweiur aki? ");
INSERT INTO uri_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ari Pita la nasel la tolpa, “Kupm marpm kalpm, pake akal kupm ukweitn kuina ur a kupm ntie kil pa pati, kai nang a Jisas Krais a Nasaret kupm la naseitn ekg kitn wreitn ngkom om!” ");
INSERT INTO uri_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yatom Pita kil wamparpmel kai wam wien pa ekg kil wreitn. Yatom aktutu tolti nepm ikg a nepm kmpang a pike mo pa paln titnongket wor om. ");
INSERT INTO uri_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Yatom kil wreitn atn ukwien, ari nepm kil pa apm wor ase, yatom kil ngkom kai. Om kil ngkom nti tuwekg pa tolpa kai kahor tpra tpra kat nang a Maur Wailen ngkom tolpa kai. ");
INSERT INTO uri_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tu wrongwailet tu ariel a kil kat nang a Maur Wailen ngkom tolpa kai pa. ");
INSERT INTO uri_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Tu ari tolpa, apm melnum wrij a pike arpm yipmingki yun a tu kwe la tolpa Yipmingki Yun Ariwor pa, ekg kwempen kwempen marpm ekg tu pa apm pake. Tu ari a kil wreitn ngkom wor, tolpa yatom tu wreitn paitn om akwonalmpen wailet. ");
INSERT INTO uri_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Melnum nepm mowe a paln wor pa, kil nti Pita ekg Jon pa atn tolpa kai atn wan kling wail a Solomon pa atn, ari tu wrongwailet paitn tu wreitn paitn ekg tu ari tolpa pa, tu aktutu kul atn yeningkenten. ");
INSERT INTO uri_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita kil ari tu wrong kinkpman a nel kul arien pa, yatom kil roponten la tolpa, “Kipm melnum a Israel ti! Ti wa ntekg tolhai yatom kipm wa wreitn paitn ekg kipm ari riti? Ti wa kipm ikghnen mentekg ti titnongket ekg kuina? Pa kipm akwonalmpen tolpa, pa mentekg ntekg ak titnongket a mentekg tike, aki mentekg ti nipet wor kai ikg a Maur Wailen yatom mentekg ntekg melnum pa paln wor, om kil wreitn atn ngkom pake? ");
INSERT INTO uri_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mentekg ti pa kalpm, pa apm Jisas pake. Apm Maur Wailen pa kat Jisas pa la tolpa kil melnum akwapel alkilen, yatom kil ukwel nang wail pake. Apm Maur Wailen a Apraham, a Aisak, a Jekob, wa a tu mamikgmamin manjan alpmento ti pa apm kil pa ukwel nang wail pake. Pike ak wang a Pailat kil arpm atning yangkipm a kil pa, kil pike la tolpa tol wa kwa kil kai, ari wa kipm ti hret la tolpa kil melnum paitn, yatom kipm la tolpa akal tu almpel mo! ");
INSERT INTO uri_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kipm uk yirokg melnum wri nipet wor kai ikg a Maur Wailen, wa kipm tilpen Pailat pa la tolpa, kil elnten melnum paitn a alm melnum ti horntepm hor hen ti. ");
INSERT INTO uri_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Wa kipm alm melnum yiprokgen a uk wripm kmel a arpm aklei wang pa. Pake Maur Wailen kil la ekg kil wreitn ha kirkhap pa, ti mentekg ari ak ikg alpmentekgen yatom ti mentekg laron pa. ");
INSERT INTO uri_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kipm wrongwailet ari melnum a paln wor atn ikg akipm ti; wet mentekg laron nang a Jisas a ntie titnongket pa nasel yatom melnum pa kil atning om ukpma, tolpa yatom kil paln titnongket wor ase. Jisas kil katel won, yatom kil ukpma Jisas pa om kil paln wor pake. ");
INSERT INTO uri_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Kipm wasokwasok a wailwail alkupm pa, kupm ari tolpa kipm ti namponen tu melnum tukgunakgen akipm pa, kipm pike akwekgel, tolpa yatom kipm wonmit ntekg paitn ekg Jisas. ");
INSERT INTO uri_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pake pike hep ak ai, ek a Maur Wailen kil paln la kai ek a tu melnum ek wripm wrongwailet alkilen, yatom tu la tolpa ekg melnum alkilen a kil akrkahan ekg akwio pa kil hi ye kalkut. Ti wleket a kipm pa pike ukwel pa paln komkiti nikgwalpm akil a pike kil la nasi tu melnum ek wripm pa. ");
INSERT INTO uri_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Tolpa ti kipm laron paitnpaitn akipm pa wa kipm pleln ipma, ekg al Maur Wailen kwan paitnpaitn a kipm pa plaln, ");
INSERT INTO uri_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ekg al Maur Wailen kil ukwepm titnongket weten kahor ipma wonen akipm pa yatom kipm wi utopen wor a arpm wor ekg wi wripm, wa ekg al Maur Wailen hi kwa Jisas pa wa narntepm. Pa melnum a pike Maur Wailen kil alkil akrkahan ekg akarmpento. Kil pa apm Jisas pake. ");
INSERT INTO uri_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ak wang ti pa kil hi arpm kaino ktnong pa arpm pa pen, nungkwangen wang a hi Maur Wailen ntekg kweiur kweiur wrongwailet pa paln weten wor pen, tol pike Maur Wailen la kai ek a tu melnum ek wripm wri wor la hep ak ai. ");
INSERT INTO uri_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tukol pike Moses melnum ek wripm la tolpa, ‘Wailen, Maur Wailen alkipmen kil hi akrkahan kmel ur a kipm alkipm ti pa wa atn melnum ek wripm ur a tol kupm ti. Ti kipm hi itning om kutnun kweiur kweiur wrongwailet a kil hi la nasepm pa. ");
INSERT INTO uri_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tol melnum ur ake atning katnun kuina ur a melnum ek wripm pa la pa, pa hi Maur Wailen kwan tu pa kai atn manet tukulein mento wrong kinkpman a Maur Wailen ti yatom almpen mo.’ ");
INSERT INTO uri_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ekla a Moses pike la pa, kai tolpake. Wa tu melnum ek wripm, ak wang a Samuel pa wa hor pa kul pa, apm wa la tolpa yat pake, kuina ur tol a paln ek arke ak wang ti. ");
INSERT INTO uri_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kipm ti pa kipm walyaru walmpopmen a tu melnum ek wripm hakai ai kulngkul kul ti. Pike Maur Wailen yipon yangkipm namponen Apraham la tolpa, ‘Hi wa kupm kwa melnum ur a walmpopmwrij alkipmen ti, yatom kai kil pa hi wa kupm ukwor aklin tu wrong kinkpman wrongwailet a arpm hor knokg ti.’ ");
INSERT INTO uri_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tolpa ti Maur Wailen kil akrkahan melnum wor akwapel alkilen pa kwa ekg kipm hep tike, ekg al kil ukwor aklin kipm tike, wa ntekg kipm wrongwailet ti pleln ipma om uk yirokg paitnpaitn alkipmen pa.” ");
INSERT INTO uri_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita ekg Jon tuwekg atn piln yangkipm nasi tu wrong kinkpman pa tolpa atn pa, tu melnum ipma krakgen a Maur Wailen, namponen melnum tukgunakgen a tu wantengkwang a atnen wan yalming a Maur Wailen namponen tu melnum tiur a Satyusi pa wa kul. ");
INSERT INTO uri_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tu ipma wakget ekg tuwekg melnum yangkipm kuinen a Krais pa, pati ekg nte tuwekg ro tukgunakg lngkep a tu wrong kinkpman wa laron nasen Jisas a pike mo yatom wa wreitn pa, pa laron la tolpa tu melnum a pike mo pa tu hi wa wreitn. ");
INSERT INTO uri_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tolpa yatom tu arkul tuwekg pa ye kai akal wa ntekg yangkipm, ari mning yatom tu yewen kahor hokga kahor wan tipmning pa pen. Hor ak kang pa tu ntekg yangkipm. ");
INSERT INTO uri_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ari tu wrongwailet pa tu atning yangkipm a pike tuwekg laron pa, yatom tu ukpma. Ti tu a ukpma pa paln wailet paitn ai, tu klein wrong a tu kpman pa wailet paitn ai (5,000). ");
INSERT INTO uri_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Hor kang pa tu melnum tukgunakgen a tu Juta, wa tu melnum wail wail, wa tu a arpmen yangkipm yiprokgen a Maur Wailen pa, tu kai kor tita ark wrij ark ha wail Jerusalem. Tu pa tu hong tukgunakgen a tu Juta. ");
INSERT INTO uri_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas a pike atn melnum tukgunakgen a ikghlen tu ipma krakgen a Maur Wailen, wa Kaiyapas, wa Jon, wa Aleksanter wa namponen tu tiur a hom wrij a melnum tukgunakgen a ikghlen tu ipma krakgen a Maur Wailen pa, tu apm ark pake. ");
INSERT INTO uri_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tu ark pa, tu la ekg tu wi tuwekg melnum yangkipm kuinen a Jisas pa ye kulhor atn ikg atu pa, yatom tu ropon nukwar koren la tolpa, “Kipmekg la ak titnongket a mla aki kai nang a mla om ntekg melnum nepm mowe ti wreitn wor ngkom pa?” ");
INSERT INTO uri_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Maur Wor a Maur Wailen pa nar arpm wail kahor ipma wonen a Pita, ak wang ketn pa, yatom kil akalmpe ek a tu pa la tolpa, “Kipm melnum tukgunakgen a men wrong kinkpman wa kipm melnum wail wail! ");
INSERT INTO uri_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ti kipm ari a mentekg ntekg melnum nepm mowe pa wor tolpa yatom kipm akal ropon kor atning pake! Wa kipm akal atning lak mentekg la yangkipmen mla yatom kil paln wor! ");
INSERT INTO uri_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kipm akropon tolpa ti kipm wrongwailet itning kil, yatom wa wi arie kil worwor, yatom al wa kipm nasi tu wrongwailet a tu Israel a ark hor pa kai pa ekg al wa wi arie worwor tolpa, ti pa mentekg la ak nang a Jisas Krais a Nasaret pa, yatom melnum a pike nepm mowe ti pa paln wor atn ti, kipm wrongwailet ari ti. Jisas a pike kipm la yatom tu karkurntel mo kai yo kwatingki pa, yatom wa Maur Wailen la om kil wa wreitn atn pa. Apm kil pa ntekg melnum pa paln wor atn tike. ");
INSERT INTO uri_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jisas pa tol hong yahuwen a kipm melnum a le wan hele pa kipm kwan lak plpa hong paitn. Pake ake paitn, pa apm hong yahuwen titnongket wor wrij hnangket a le wan hele apm pake. ");
INSERT INTO uri_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ti ake melnum manet ur ntie ekg akwiyo ye kai ekg Maur Wailen pa. Maur Wailen uko Jisas wrij hute tolti. Ti ake wa kil namput nang a melnum manet ur a atn knokg ti a ntie ekg akwiyo ye kai wor pa, kalpm.” ");
INSERT INTO uri_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tu hong tukgunakgen a arpm atning yangkipm a Pita atn ekla pa, tu wreitn paitn ekg ari Pita ekg Jon wa ekg atn titnongket la yangkipmek pa, wa tu ari tolpa, tuwekg pa melnum hawen tolti, ake tuwekg ur pike kai wi arie wail ur pa, kalpm. Tu ari tolpa, tuwekg melnum pike atn nti Jisas. ");
INSERT INTO uri_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Wa tu ari melnum a pike paln wor pa nti Pita ekg Jon pa atn, tolpa yatom tu ari pa, om tu yangkipm kalpmten ekg akalmpe kai tuwekg pa. ");
INSERT INTO uri_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tolpa yatom tu la nasi tuwekg pa la tolpa tuwekg nuhurn wan a tu hong tukgunakgen pa kahor hen, wa tu alntu pa ark kor la nikgwalpm tiur ekg tuwekg pa ark. ");
INSERT INTO uri_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tu ropon tita la tolpa, “Al mento ntekg tolhai ekg melnum wekg ripa? Tu wrongwailet a ark Jerusalem ti pike ari kwap titnongket a ake pike men ari hep pa, a tuwekg ak kai melnum ti. Ti mento ake ntie ekg karuken pa. ");
INSERT INTO uri_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mento er lam loken ik wasoket pake, ekg ake al tuwekg akwap tolpa kai wail hor pa kai. Al mento ukwen yangkipm titnongket la tolpa, ake al tuwekg laron nang a Jisas pa nasi mla ur nti ur, kalpm.” ");
INSERT INTO uri_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tu kwewen kul hor, yatom tu ukwen yangkipm titnongket la tolpa, “Pike kipmekg akwap tolpa, ti kipmekg yat kalpm. Hi ampur wa kipmekg wa ro tukgunakg lngkep a tu aki laron nang a Jisas pa nasi melnum ur nti ur, yaper.” ");
INSERT INTO uri_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ari Pita ekg Jon pa akalmpenten la tolpa, “Kipm alkipm ti ikwonilmpen kai kipm alkipm ti tolpa, pake Maur Wailen wakrongen tolhai, al mentekg katnun yangkipm a kipm ti tolpa aki mentekg katnun yangkipm a Maur Wailen ai e? Pa mentekg katnun yangkipm a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ti mentekg ake ntie elnten kuina ur a pike mentekg nungkulkg a ikg pa, kalpm. Mentekg hi laron tolpa kai pake.” ");
INSERT INTO uri_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tu wrong kinkpman ari tuwekg ntekg melnum pa paln wor pa, yatom tu kat nang a Maur Wailen ye hor pa kai ase. Tolpa yatom tu hong tukgunakgen pa tu kark ekg tu wrong, tolpa yatom ake tu ari ya ur ekg uk kalkut ur ekg tuwekg pa, tu ukwen yangkipm titnongket tolti, la tolpa tuwekg kalpm ekg hi ake tuwekg wa laron nang a Jisas pa nti ur, yatom tu kwanten kahor hen tolti, om tuwekg kai. ");
INSERT INTO uri_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ekg nte, tu hong tukgunakgen pa ake ntie ekg karuken melnum nepm mowe a paln wor pa. Melnum pa hangken wring kmel wekg (40) ase. ");
INSERT INTO uri_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tu kwan Pita ekg Jon pa kulhor hen ti, tuwekg wa kai ekg tu melnum alntuwekgen pa wa la kitinten kuina ur a tu melnum ipma krakgen a Maur wailen a atn hep, wa tu melnum wail wail lawen pa. ");
INSERT INTO uri_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tu atning om, tu eln ek atn wrij ropon Maur Wailen pa la tolpa, “Melnum Wailen, kitn Wailen a ntekg ktnong, a knokg a hunokg, a kweiur kweiur wrongwailet ye hor pa kai. ");
INSERT INTO uri_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Pike hep pa Maur Wor alkitnen paln la kai ek a Teipit, melnum akwapel alkitnen a kil wapyipmri walyipmri alpmenen pa la tolpa, ‘Ntekg tolhai ti wa tu a ake Juta pa tu kai ipma wakget paitn? Wa ntekg tolhai ti wa tu wrong kinkpman pa yipon yangkipm paitn tolpa, pa tu yipon kalpmel, pa hi ake ntie ekg tu ak, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Wa tu melnum tukgunakgen a hor knokg ti tu wreitn numprampen akal almpwrong, yatom tu kai ark wrij namponen tu melnum wail wail yipon yangkipm pa, yatom tu akal hripon nti Wailen, Maur Wailen wa nti melnum a pike kil akrkahan ekg akarmpen mento kinkpman wrongwailet pa.’ ” ");
INSERT INTO uri_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Wa tu ropon Maur Wailen tolpa: “Pa aklahle, apm pike paln tolpa atn ha wail Jerusalem tike. Herot ekg Pontius Pailat, melnum tukgunakgen wekg pa namponen tu wrong kinkpman a ake Juta pa, wa namponen tu a men wrong kinkpman a Israel ti tu yipon yangkipm wrij akal kwan alm Jisas, melnum akwapel wri wor alkitnen a kitn alkitn akrkahan ekg akwi men ti pa. ");
INSERT INTO uri_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Titnongket a kitn pike yipon ekg hi wa tu ntekg komkiti nikgwalpm alkitnen a pike kitn akwonalmpen hep ak ai, akal hi wa tu ak tolpake. Yatom apm pike tu ak komkiti tolpake. ");
INSERT INTO uri_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Wailen, ti kitn wet atning yangkipmek a wet tu yewo kark, tolpa ti kitn iklin men melnum akwapel alkitnen ti pen, ekg hi men atn titnongket laron yangkipm alkitnen pa. ");
INSERT INTO uri_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kitn pa eln wam akitn pa hel tu melnum numpet pa ekg al tu paln wor, wa kitn ntekg kweiur kweiur titnongket wrongwailet, wa kweiur kweiur weten a pike ake melnum ari hep, wa kitn plan klal ur alkitnen kai nang a Jisas pa, ekg al tu ari la tolpa titnongket a Jisas, melnum akwapel wri wor alkitnen pa ntie ekg akwap tolpake.” ");
INSERT INTO uri_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tu ropon Maur Wailen pa kai plaln pa, wrik a tu kai ark ti pa, apm tutut tutut ase, yatom Maur Wor a Maur Wailen pa nar kahor arpm tu pa, yatom ukwen titnongket, yatom tu atn titnongket laron yangkipm a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tu melnum a ukpma Jisas pa nikgwalpm a tu ti pa kai wrij. Ake al melnum ur la kweiur alkil pa la tolpa, alkilen pa, tolpa kalpm. Tu akal nampreng kweiur kweiur alntuen pa aklin tita plalnten. ");
INSERT INTO uri_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tu melnum yangkipm kuinen a Jisas tu wi titnongket wail yatom tu laron yangkipm a Wailen Jisas a pike mo yatom wa wreitn pa, la tolpa aklahle. Yatom Maur Wailen kil pleln won kainten arien ukwen ipma wor wailmanten. ");
INSERT INTO uri_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ake wa melnum ur kai kuin a tu pa warkip ekg ekpma a hapmnung kweiur kweiur pa. Ti tu melnum a ntie knokg a wan wailet pa, tu ak pa ak wi marpm pa yatom wi marpm pa ye kul uk kai wam a tu melnum yangkipm kuinen a Jisas pa, yatom tu ari mla ur a warkip pa, tu wi marpm pa aklin tu a arpm warkip pa. ");
INSERT INTO uri_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Melnum wrij ur pa, nang akil pa Josep. Kil a hom wrij a Lipai, kil kai ha knokg Saiprus. Wa tu melnum yangkipm kuinen a Jisas pa kwe nang wompel akil pa tolpa Parnapas. Yiprokgen a nang ripa pati, “Melnum a ak titnongketel ipma a tu melnum”. ");
INSERT INTO uri_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Kil ntie knokg yatom kil uk knokg ur alkil pa, ekg ak wi marpm, yatom ye marpm pa ye kul kai uk kai wam a tu melnum yangkipm kuinen a Jisas pa. ");
INSERT INTO uri_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tu wrongwailet apm ak tolpake, kinkpman wekg ur kil pa, ekg ak manet. Ti nang a kpman pa Ananaias wa nang a kin pa Sapaira. Ananaias uk knokg ur a tuwekg pa kai tu armpenten. ");
INSERT INTO uri_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yatom kil wi marpm pa plan kin pa, tuwekg ipma wrij la tolpa eln wompel ti irpm ekg mentekg alpmentekg, wa kil ye wompel pa ye kai uk kai wam a tu melnum yangkipm kuinen a Jisas pa. ");
INSERT INTO uri_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ari Pita ropontel la tolpa, “Ananaias, ntekg tolhai ti om kitn eln Maur Paitn Satan pa ikghlen nikgwalpm alkitnen pa yatom kitn eln marpm wompel a kitn wi kai knokg pa elntarpm ekg kitn alkitn pa? Wa kitn akplainel Maur Wor a Maur Wailen tolpa ekg nte? ");
INSERT INTO uri_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Knokg pa alkitnen. Kitn akal uk tu armpen aki kalpm e, pa nikgwalpm alkitnen. Wa kitn akal wi marpm pa yatom kitn akal ye aki kitn akal uk aripm ur kai Maur Wailen pa, pa ha kai kitn alkitn pa. Ari wa ntekg tolhai yatom wa kitn akwonalmpen yatom kitn ak tolpa! Kitn ake akplainel melnum ti pa, pa kitn akplainel Maur Wailen.” ");
INSERT INTO uri_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaias kil atning pa, kil ngko eln nar knokg om mo ase. Wa tu mla ur a tu atning yangkipm pa, tu kark paitn wrijen. ");
INSERT INTO uri_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kil mo ha pa, tu warim kpman tiur pa wli wi hapm pa akyipoel plaln pa, wa tu katel ye kai uwentel. ");
INSERT INTO uri_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tu uwen kpman pa plaln, wa tu atn watin ketnketn ari kin alkil pa wa kul paln, kil ake ari kpman alkil Ananaias a wet mo pa yatom tu uwentel pa. ");
INSERT INTO uri_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Yatom Pita ropontel la tolpa, “Ti kitn la nisopm ri, marpm a tu ak armpentepm knokg akipmekg pa apm tike aki?” Ari kin pa akalmpe la tolpa, “Ei, apm pake.” ");
INSERT INTO uri_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Yatom Pita la nasel la tolpa, “Ntekg tolhai ti kipmekg wet yipon yangkipm akwonalmpen la akal uktiel Maur Wor a Maur Wailen ti? Tu melnum a wet uwen kpman alkitn ti pa wa kul atn wanyun pa, ekg al wa kateitn ye kai ekg uwenteitn yat.” ");
INSERT INTO uri_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ak wang ketn a Pita la nasel la tolpa, pa kil mo eln nar ha nepm a Pita pa, yatom tu warim kpman ripa wa kul ari kil mo ha, yatom tu katel yewel kai uwentel arpm yampingken kpman alkilen pa. ");
INSERT INTO uri_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tu wrong kinkpman a ukpma Maur Wailen pa wa namponen tu wrongwailet pa, tu atning yangkipm ripa, pa tu kark paitn wrijen. ");
INSERT INTO uri_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ti tu melnum yangkipm kuinen a Jisas pa tu ntekg kweiur kweiur titnongket wailet, wa plan klal manet manet tiur wa ntekg kweiur kweiur titnongket titnongket tiur a melnum ake ntie ekg ntekg paln kai kuin a tu wrong kinkpman ekg tu ari. Tu melnum a ukpma Jisas pa tu nikgwalpm wrij wa tu kul kai kahor yipmingki wonen a wan yalming a Maur Wailen pa ark, ark wrij ha wan kling wail a Solomon pa. ");
INSERT INTO uri_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pake tu melnum a ake ukpma Jisas pa tu kark, yatom tu ake wa kul kai ark wrij namponen tu pa. Ari tu kinkpman wrongwailet pa, kporn yangkipm la tolpa tu pa akwap wor. ");
INSERT INTO uri_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Yatom tu wrong a wli ukpma Wailen pa, paln wailet wailet tolpa ye kaino, tu kinkpman yaten. ");
INSERT INTO uri_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tu ari tolpa yatom tu kat tu melnum a numpet pa ye kai kulamten wrik nmong, wakg a kweiur kweiur pa ha ya, ekg al Pita kil ngkom hor ya pa kai, om al takgni wi klal a kil pa kai helenten, om al ntekg tu pa paln wor. ");
INSERT INTO uri_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Wa tu wrong kinkpman wailet a ark ha wasok a ha yampingken ha wail Jerusalem pa, tu ye tu melnum numpet a namponen tu melnum a maur paitn arpmen pa ye kulngkul, yatom tu melnum yangkipm kuinen a Jisas pa ak titnongket a Jisas pa ak ntekg tu paln wor. ");
INSERT INTO uri_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Yatom melnum tukgunakgen a ikghlen tu ipma krakgen a Maur Wailen pa, wa namponen tu alkil a atn akwap aklinjel pa, tu plalnten pa wa tu Satyusi, tu wreitn ipma paitn wrijen ekg tu ari kwap wor a tu melnum yangkipm kuinen a Jisas pa ak. ");
INSERT INTO uri_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tolpa yatom tu kai arkulen wiyen ye kai kahor arpm wan tipmning a tu ye tu melnum wrongwailet a ntekg paitnpaitn pa kai arke pa. ");
INSERT INTO uri_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ari ak mning pa maur akwapel ur a Maur Wailen pa kukwa wanyun a wan tipmning pa yatom, kil eln tu melnum yangkipm kuinen a Jisas pa kahor hen, yatom kil la nasen la tolpa, ");
INSERT INTO uri_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kipm kai kahor atn yipmingki wonen a wan yalming a Maur Wailen pa la nasi tu wrong kinkpman yangkipm wor wrongwailet a la ya weten wor a arpm wor aklei wang pa ekg akal tu katnun apm tike.” ");
INSERT INTO uri_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tu melnum yangkipm kuinen a Jisas tu atning pa tu katnun yatom nungkwat pa, tu kahor yipmingki wonen a wan yalming a Maur Wailen pa ro tukgunakg lngkep a tu wrong kinkpman ekg yangkipm a Maur Wailen. Ak wang a tu ro tukgunakg lngkep a tu wrong kinkpman atn pa, melnum tukgunakgen a ikghlen tu ipma krakgen a Maur Wailen, wa namponen tu melnum aklin akil pa tu kwe tu hong tukgunakgen wrongwailet a tu Israel a ark atning yangkipm pa. Yatom tu nel kul kai ark wrij ekg akal ntekg yangkipm. Yatom tu kwa tu wakmit kai ekg al akwi tu melnum yangkipm kuinen a Jisas a ark wan tipmning pa ye kul ekg akal ntekg yangkipm. ");
INSERT INTO uri_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tu melnum wakmit tu kai paln kai wan tipmning pa ari, ake tu melnum yangkipm kuinen a Jisas pa arpm kahor wan tipmning pa, yatom apm wa tu pleln kai la nasi tu melnum wailen wailen pa la tolpa, ");
INSERT INTO uri_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Men kai paln kai wan tipmning pa, men ari wanyun pa hmpei aken tongtong worwor atn kiti kiti, wa tu wantengkwang a atnen wanyun pa, tu atnen wanyun pa tolpa atn. Wa men kukwa wanyun pa kai kahor akal akwien ye kul ari tu melnum pa wolen, ake ark.” ");
INSERT INTO uri_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Melnum tukgunakgen a tu wantengkwang a ikghlen wan yalming a Maur Wailen wa namponen tu melnum ipma krakgen a Maur Wailen a atn hep pa tu atning pa, yatom tu akwonalmpen wailet la tolpa, “Tu wet kulhor tolhai pa?” ");
INSERT INTO uri_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tu kor la tolpa atn pa, melnum ur pa kul nasen la tolpa, “Oi, kipm a ekla pa kipm itning pen! Tu melnum a kipm kor pa, apm atn kahor yipmingki a wan yalming a Maur Wailen pa, ekg ro tukgunakg lngkep a tu ekg yangkipm a Maur Wailen nasi tu wrong kinkpman pa atn kai ai ase!” ");
INSERT INTO uri_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tu atning tolpa pa, melnum tukgunakgen a tu wantengkwang a ikghlen wan yalming a Maur Wailen pa, kil wi tu tiur alkilen pa kai akwi tu melnum yangkipm kuinen a Jisas pa ye kul. Tu kai akwien mehen tolti ye kul, ake tu eren aki ntekgen paitn pa, kalpm. Tu kark tol tu er tu melnum yangkipm kuinen a Jisas pa aki ntekgen paitn pa, pa apm tu wrong kinkpman pa eren ak weij. ");
INSERT INTO uri_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Yatom tu akwi tu melnum yangkipm kuinen a Jisas pa ye kul atn kai ikg a tu hong tukgunakgen a arpm ekg atning yangkipm pa. Yatom melnum tukgunakgen a ikghlen tu ipma krakgen a Maur wailen pa ntien eklala, ");
INSERT INTO uri_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","yatom kil la nasen la tolpa, “Men pike lokepm wa ukwepm yangkipm titnongket la tolpa kipm hi ake laron nang a melnum pa nti ur. Ari ake wa kipm atning, kipm alilohak om ro tukgunakg lngkep a tu tolpa kai, ti yangkipm pa apm paln wail tu atning atn hor ha wail Jerusalem ti ase. Wa kipm ti arki men ti la tolpa men ti alm melnum pa mo pake!” Melnum tukgunakgen a tu ipma krakgen pa la tolpake. ");
INSERT INTO uri_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ari Pita namponen tu alntu melnum yangkipm kuinen a Jisas pa akalmpe la tolpa, “Men ake al atning katnun yangkipm a melnum la pa, men al atning katnun yangkipm a Maur Wailen la tolti. ");
INSERT INTO uri_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Apm pike kipm pa karkurn Jisas kai yo kwatingki pa yatom kil mo pake. Ari Maur Wailen a mamikgmamin manjan alpmenen ti la yatom kil wreitn ha kirkhap pa, om kil atn. ");
INSERT INTO uri_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yatom Maur Wailen wiyel ye kaino elntarpm kaino wam wiyen akil, om ukwel nang wail. Kil paln melnum tukgunakgen a ikghlento, wa melnum a akwiyo. Yatom kil aklin mento Israel ti ekg al mento ntie ekg pleln ipma uk yirokg paitnpaitn ti, yatom al Maur Wailen kil kwan paitnpaitn amento pa kai plaln. ");
INSERT INTO uri_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kweiur kweiur wrongwailet a men laron atn ti pa, men alpmen ti pike nungkulkg a ikg. Ake wa men wrij ti pa, kalpm, men ti wa Maur Wor a Maur Wailen uk tu a atning katnun yangkipm alkilen pa wa ak titnongketel yangkipm pa yat.” ");
INSERT INTO uri_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tu hong tukgunakgen a arpm atning yangkipm pa, tu atning yangkipm pa ari paitn yatom tu ipma wakget nikgwalpm wrongken paitn akal alm tu melnum yangkipm kuinen a Jisas pa mo. ");
INSERT INTO uri_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ari melnum ur a tu Parasi pa, nang akil pa Kamaliel, melnum a arpmen yangkipm yiprokgen a Maur Wailen, a tu wrong kinkpman wi wor lawel la tolpa, kil melnum nang wail. Kil wrij ur a tu hong tukgunakgen a tu Juta pa. Kil wreitn atn wa kil la nasi tu melnum wantengkwang pa la tolpa, tu wi tu melnum yangkipm kuinen a Jisas pa ye kahor atn kahor hen pa itn waitketn pen. ");
INSERT INTO uri_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Yatom kil la nasi tu alntu a hong tukgunakgen a tu Juta pa la tolpa, “Kipm melnum a Israel ti pa, tol kipm akal ntekg kuina ur ekg tu ti pa, kipm ikwonilmpen worwor pen! ");
INSERT INTO uri_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ti kipm ari wring aripm ur kai pa, pa pike Teutas kil wreitn atn, wa kat kil alkil ti la tolpa, kil pa melnum wailen, yatom kpman wailet paln tol kmel kmel (400) tu kai katnun kil pa. Ari tu almpel mo, yatom tu melnum alkil a horhanekg katnuntel pa apm hor kark hrak kai atn tukuleinjel ase. Ti kwap akil pa kai plaln tolpake. ");
INSERT INTO uri_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Wa atn waitketn ketn pa, Jutas, melnum ur a Kalili wreitn atn wailen ak wang a pike tu wi nangkel tu wrong kinkpman. Kil hepiln tu wrong wailet kai katnuntel ari apm wa tolpa yat pake, wa tu wa almpel mo. Yatom tu wrong a kai katnuntel pa, tu kark kai atn tukuleinjel ase. ");
INSERT INTO uri_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Tolpa ti, ri ti pa kupm la nasepm la tolpa, ake al kipm ntekg paitn kai tu melnum ti, kipm elnten kai om! Ekg nte, tol tu ak kwap pa ak nikgwalpm a titnongket a tu alntu melnum ti tolti tol a pike Teutas a Jutas pa, pa hi wa kai plaln. ");
INSERT INTO uri_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pake tol Maur Wailen kil alkil yiprokgen a kwap ripa, kipm ake ntie ekg loken pa, kalpm. Pa hi wa kipm ari tolpa pa apm kipm hripon namponen Maur Wailen kil alkil pake.” Tu alntu a arpm atning yangkipm pa tu atning katnun eklala a Kamaliel la nasen pa, yatom tu wi ipma mehen wor om tu ak katnun tolpa kai, ");
INSERT INTO uri_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","yatom kwe tu melnum yangkipm kuinen a Jisas pa wa kul hor wan pa, yatom tu la nasi tu wantengkwang pa, om tu aken wanteng, plaln pa, tu ukwen yangkipm titnongket la tolpa, hi ake wa tu laron nang a Jisas pa wa nti ur, pa kalpm. Tu ntekgen tolpa plaln pa, om tu kwawen kai. ");
INSERT INTO uri_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yatom tu melnum yangkipm kuinen a Jisas pa tu nuhurn tu hong tukgunakgen a tu Juta pa, tu kahor hen pa, tu utopen paitn. Tu ukwen wleket wa tu wi numpaitn wail yektnen nang a Jisas ti, pake tu ari tolpa Maur Wailen ari tolpa tu pa wor ntie ekg ye kalkut pa yatom tu utopen wailmanten ye kalkut pa. ");
INSERT INTO uri_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ake wa tu elnten kwap pa, kalpm. Tu ro tukgunakg lngkep a tu wrong kinkpman pa atn yipmingki wonen a wan yalming a Maur Wailen pa wa atn wan ur wan ur a tu pa. Tu laron nasen Jisas pa la tolpa melnum a pike Maur Wailen akrkahan yatom kwa nar akal akarmpento apm pake. ");
INSERT INTO uri_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ak wang ti pa tu wrong disaipel a Jisas pa tu paln wailet tolpa ye kaino. Yatom tu Juta a ak ek Krik pa tu ipma kalkut a tu la wailet kai tu Juta a ak ek Aram pa la tolpa, “Aklei wang kipm akwap aklin kweiur kweiur tolpa kai ekg tu melnum a arpm warkip, pake ake wa kipm aklin tu kin karpikg alpmenen ti.” ");
INSERT INTO uri_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yatom tu melnum yangkipm kuinen wampwam yikakwomwekg a Jisas pa, tu kwe tu disaipel wrongwailet a Jisas pa tu kul ark wrij, yatom tu la nasen la tolpa, “Ake wor ekg akal men nuhurn kwap a laron yangkipm a Maur Wailen ti, wa ikghlen kwap a wako nampreng kweiur kweiur wrongwailet ekg aklin tu melnum a arpm warkip pa. ");
INSERT INTO uri_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Tolpa ti kipm worwor a wasokwasok alpmenen, kipm ri kipm alkipm ur ti a atn a arpm wor a tu melnum kporn yangkipm, a ntie Maur Wor a Maur Wailen, a nikgwalpm arke worwor pa, pa apm mento kat tunten melnum wampomit wampomwekg ur a tolpake ekg akal tunten melnum pa ikghlen kwap ripa om! ");
INSERT INTO uri_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Wa men alpmen melnum yangkipm kuinen a Jisas ti pa, men akal uk wang wail alpmenen ti kai ekg ropon Maur Wailen ekg wa laron yangkipm a Maur Wailen.” ");
INSERT INTO uri_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ti tu wrong kinkpman tu atning nikgwalpm wor a tu melnum yangkipm kuinen a Jisas la nasen pa yatom tu utopen wi wor. Yatom tu kat Stipen, melnum a kil ukpma Maur Wailen atn titnongket, wa kil ntie Maur Wor a Maur Wailen arpm kahor ipmanikg alkilen pa. Wa tu kat Pilip, Prokorus, Nikanor, Timon, Parmenas, Nikolas. Wa Nikolas pa kil melnum a ha wail Antiok, kil ake a Juta, pake kil apm pleln kai katnun yangkipm a ya a tu Juta, yatom kil apm paln tol melnum Juta pake. ");
INSERT INTO uri_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Yatom tu wi tunten melnum wampomit wampomwekg pa ye kaino atn, wa tu melnum yangkipm kuinen a Jisas pa kul eln wam pa helen ropon Maur Wailen pa ekg aken titnongket ekg tunten al akwap ripa. ");
INSERT INTO uri_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Yatom yangkipm a Maur Wailen pa paln kai wail hor ha wail Jerusalem. Tu wrong kinkpman wailet paitn a ark ha wail Jerusalem pa tu atning yangkipm pa, yatom tu pleln ipma a ukpma Jisas. Wa tu melnum ipma krakgen wailet a Maur Wailen pa wa tu pleln ipma ukpma Jisas pa yat. ");
INSERT INTO uri_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stipen pa kil melnum a Maur Wailen wi wor lawel yatom ukwel titnongket wail. Kil plan klal wailwail wa kil ntekg kweiur kweiur titnongket weten wrongwailet kai kuin a tu wrong kinkpman ekg tu ari. ");
INSERT INTO uri_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ari tu tiur wreitn nti Stipen pa kle tita. Tu pa tu melnum a wan ur a tu atning yangkipm a Maur Wailen atne pa. Wan ripa pa tu kwe la tolpa wan a tu wrong wompel ur a pike tu ak kwap kalpmel horhanekg ekg kmel ur. Tiur alntuen a ha wail Sairini, wa tiur a ha wail Aleksantria, namponen tu tiur a ha knokg Silisia, wa ha knokg Esia. ");
INSERT INTO uri_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ari Maur Wor a Maur Wailen pa uk nikgwalpm a arie wor pa kai Stipen pa, ti tu ake ntie ekg wa akalmpe ekla a kil pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yatom tu kai uk marpm hampen tu melnum tiur pa, la nasen la tolpa tu akenplain yangkipm ti ye hor pa kai la tolpa, “Men atning ari Stipen pa kil la paitnel ekg Moses namponen Maur Wailen.” ");
INSERT INTO uri_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Om tu ye yangkipm pa kai nasi tu hor pa kai yatom tu wrong kinkpman pa, wa tu melnum wail wail, wa tu melnum a arpmen yangkipm yiprokgen a Maur Wailen, ari ake wa wor kai ipma atu pa, yatom tu kai arkul Stipen pa yewel kai ekg ntekg yangkipm atn kai ikg a tu hong tukgunakgen a tu Juta. ");
INSERT INTO uri_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Yatom tu wi tu melnum tiur pa ye kahor atn yirokg akal la yangkipm akplain arki Stipen pa la tolpa, “Men nungkulkg a ikg atning yangkipm a kil aklei wang la paitnel wan yalming a Maur Wailen ti, namponen yangkipm titnongket a Moses ti. ");
INSERT INTO uri_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Wa men atning a kil la tolpa, Jisas a Nasaret pa hi tikale wan yalming a Maur Wailen ti, wa kil hi wa ak lok ya a pike Moses la nasi tu yohmpei manjan ak ai kulngkul, kul la naso la tolpa al mento katnun pa.” ");
INSERT INTO uri_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tu hong tukgunakgen wrongwailet a ark wan a tu ark atning yangkipm pa, tu ikghnen Stipen pa titnongket ari ikgek akil pa ari klalen tol ikgek a tu maur akwapel a Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Melnum tukgunakgen a ikghlen tu ipma krakgen a Maur Wailen pa atning yangkipm a tu arki Stipen pa plaln pa, kil wa akropon Stipen pa la tolpa, “Yangkipm tol a tu arkieitn pa aklahle aki?” ");
INSERT INTO uri_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ari Stipen pa akalmpe la tolpa, “Kipm wasokwasok a wailenwailen, wa yantin alkupmen a Israel! Kipm itning! Yohmpei alpmento Apraham pa kil ake kaino arpm kai ha wail Haran pa pen, kil arpm ha knokg Mesopotemia pa, yatom Maur Wailen kil ntie klalen wail, kil paln ari Apraham pa ");
INSERT INTO uri_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ntiel ekla la tolpa, ‘Kitn wreitn nuhurn ha knokg alkitnen ti, wa tu hom alkitnen ti atn pa, wa kitn kaino ha knokg ur a hi wa kupm planteitn pa!’ ");
INSERT INTO uri_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Apraham kil atning tolpa, kil wreitn nuhurn ha knokg alkilen pa namponen tu alkilen a Kaltia pa arpm pa, wa kil wreitn kaino ha Haran. Kil arpm pa arpm, yan alkilen pa mo, plaln pa, Maur Wailen wa la nasel yatom kil wa wreitn ha pa nar arpm ha knokg a kipm arpme ti. ");
INSERT INTO uri_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Maur Wailen kil ake wa uk knokg tiel ketn ur ekg Apraham pa atn ti ekg alkil pa, kalpm. Apm tolpake Maur Wailen kil yipon yangkipm lak kil hi wa ukwel knokg ti kanukg namponen tu warim warim walyikek alkilen ekg al hi wa tu wi ekg alntuen. Ari Apraham pa warim kalpmen. ");
INSERT INTO uri_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Wa Maur Wailen la nasel la tolpa, ‘Tu warim warim walyikek alkitnen pa hi wa tu arpm tol melnum yawen kai ha manet ur pa, om hi wa tu ntekgen ari paitnpaitn a hi wa tu aken kwap kalpmel horhanekg ekg tu pa arpm tol wring kmel kmel (400). ");
INSERT INTO uri_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pake hi wa kupm ye tu kai atn ntekg yangkipm akalmpe paitnpaitn a tu wiyen ye kinar akten kwap kalpmel pa.’ Wa Maur Wailen wa kil la tolpa, ‘Hi wa kanukg pa tu warim warim walyikek alkitnen pa hi wa nuhurn ha knokg pa kulno kpor klko lein kupm ti atn wrik rikil.’ ");
INSERT INTO uri_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Yatom Maur Wailen kil uk yangkipm Apraham la tolpa hi kil nti tu a kanukg pa kwat numpalk a tu warim kpman atu, pa tol kla ur a kil lam namponen Apraham pa la tolpa tu alkilen. Yatom Apraham kil kwat warim kpman Aisak kai kin alkilen pa kil raku ye arpm tol wang wampomit wampomwraur pa yatom kil kwat numpalk a warim pa. Om Aisak kil paln tol yan a Jekob wa Jekob kil paln tol yan a mamin wampwam yikakwomwekg amento. ");
INSERT INTO uri_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Tu maminen pa, tu pike ipma paitn ekg wasok wangkuin alntu pa Josep, yatom tu uk Josep pa kai ekg tu ha knokg manet ur pa armpenten wi kil ye kinar Ijip. Ari Maur Wailen pa ntiel arpm, ");
INSERT INTO uri_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kalkut wailet palntel pake, Maur Wailen kil aklinjel yatom kwan kalkut wrongwailet pa kai tukuleinjel. Yatom Maur Wailen kil ukwel nikgwalpm arie worwor yatom melnum tukgunakgen a Ijip pa kil ari atn a arpm, wa ekla a kil pa ari wor, yatom kil katel atn melnum wail kul rken kil atn ikghlen tu wrong kinkpman a Ijip wa ikghlen kweiur kweiur wrongwailet a atn wan a melnum tukgunakgen kil alkil pa. ");
INSERT INTO uri_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Yatom ak wang pa wang nikg wailmanten paln hor kinar ha knokg Ijip wa no ha knokg Kenan ti. Pa kalkut wailmanten paitn, yatom tu yohmpei alpmenen pa ekpma kalpmten, yatom nikgten paitn. ");
INSERT INTO uri_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Tu ark tolpa kaingkai, Jekob kil atning a tu la tolpa tu Ijip pa tu wit ek ur ha pa. Yatom kil kwa tu warim kpman alkilen pa, tu kinar Ijip, tu pa apm tu maminen amento tike. Tu pike ake kinar Ijip pa nti ur, kalpm, tu atn ti ekg al wa kinar tipen. ");
INSERT INTO uri_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Wa tu wa kinar nti ur ti pa, Josep laron kil alkil ti nasi wasok nti tu wailenwailen alkilen pa la tolpa, ‘Kupm Josep, wangkuin alkipmen apm tike.’ Yatom melnum tukgunakgen pa wa kil ari tolpa pa tu walmpopmwrij alkilen a Josep apm pake. ");
INSERT INTO uri_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yatom Josep kil nasi wasok nti tu wailenwailen alkilen pa la tolpa tu wa no akwi yan alkilen Jekob pa namponen tu kin warim yalmpikgne nti walyikek alkil pa plalnten ye kinar Ijip pa. Ti tu a kil pa tol kmel wraur tuwek wampwam yikakwomit (75). ");
INSERT INTO uri_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jekob kil atning yangkipm a Josep la ripa, tolpa om kil almnon kin warim walyikek a namponen tu alkilen pa tu plalnten kinar Ijip pa ark pa ark ark, Jekob pa mo, wa tu warim kpman alkilen pa wa mo. Tu pa tu maminen alpmentoen pake. ");
INSERT INTO uri_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yatom tu wi tupmungkul a tu pa wa ye no kaino ha wail Sekem, yatom tu ye kahor elntha tipmning teng a pike Apraham armpen kai tu warim a Hamor a ha wail Sekem pa. ");
INSERT INTO uri_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Wang a Maur Wailen pike yipon yangkipm namponen Apraham pa, apm kul yampingken tike ekg akal ngko ek arke tike. Ti tu wrong kinkpman amento a ark Ijip pa kwat lei tolpa ye kaingkai kai wailet paitn ai. ");
INSERT INTO uri_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Yatom tu Ijip pa kat melnum weten ur alntuen atn melnum tukgunakgen ekg ikghlenten, yatom kil ake wa ari Josep pa a kwap wor a pike kil ak pa. ");
INSERT INTO uri_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tolpa yatom kil akplainel tu yohmpei amento ti ntekgen paitnpaitn, akenplain wa ukwen kalkut, wa la titnongket la tolpa tu piln tu warim wasikyikek pa eln kai ekg tu mo. ");
INSERT INTO uri_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ak wang ripa a melnum weten pa atn melnum tukgunakgen pa man raku Moses pa. Warim pa warim wor, yatom Maur Wailen utopen warim ripa. Manjan alkilen pa ikghlentel lampel arpm wan pa tol kainil wraur, plaln pa, ");
INSERT INTO uri_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","tuwekg kat warim ripa ye hor hen om ye kinar elntarpm kop hu arkikg pa, yatom warim kin a melnum tukgunakgen a tu Ijip pa kil hantil warim pa yatom kil katel ye no lokli tol warim alkilen pa. ");
INSERT INTO uri_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tolpa yatom tu kaling plan rowonel Moses pa ekg nikgwalpm a arie worwor a tu Ijip pa, yatom kil wreitn paln tol melnum wonrekele wor a ekla, wa melnum titnongket a ak kwap wrongwailet. ");
INSERT INTO uri_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Tolpa om kil arpm kinar pa arpm, kil apm yampingken ekg al warim woren tike, wring a kil pa kmel wekg (40), yatom nikgwalpm akil pa wreitn akal kil wa kai ari tu alntu melnum a Israel pa. ");
INSERT INTO uri_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yatom kil kai ari, kil ari melnum ur a Ijip pa ntekg paitn ekg melnum ur a Israel pa, tolpa yatom ake wa kil atn ari ak ikg pa, kalpm, kil kai aklin melnum a Israel ripa, yatom kil er melnum a Ijip pa mo akalmpe a kil ntekg paitn ekg melnum Israel ti. ");
INSERT INTO uri_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kil akwonalmpen tolpa tu melnum alkil a Israel pa akal ari tolpa Maur Wailen kil akrkahan kil pa akal kil aklinjen wiyen ekg ye kai tukulein ha knokg Ijip pa, ari ake tu ari pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Hokg hor kang pa kil wa kai ari tu alntu a Israel pa, pa kil ari melnum wekg ur ekg er tita. Yatom kil kai akal loken la tolpa, ‘Oi, kipmekg itning, kipmekg pa kipmekg alkipmekg a Israel pake. Wa kipmekg ipma paitn ntekg tita tolpa ekg nte?’ ");
INSERT INTO uri_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ari melnum a wet ntekg nikgwalpm paitn pa kil talpul Moses pa kai tukuleinjel, wa kil ropontel la tolpa, ‘Mla ur la yatom kitn akal atn melnum wailen ekg akal ikghlen men ti, a arpm atning yangkipm a men ti yat? ");
INSERT INTO uri_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kitn akal er kupm ti mo, tol pikekg kitn er melnum Ijip ur pa mo pake?’ ");
INSERT INTO uri_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses kil atning a melnum ripa la tolpa, yatom kil kark kai ha Ijip pa kai arpm kai ha knokg a tu Mitian. Kil melnum yawen, kil ake knokg yiprokg a ha pa, pake kil wi kin a ha ripa ye arpm pa, om kwat warim kpman wekg. ");
INSERT INTO uri_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Moses arpm kai ha knokg a Mitian pa arpm pa arpm, tol wring kmel wekg (40), om wangkur pa kil ari maur akwapel a Maur Wailen palntel ari tol wakg ek a narukg al yo hiket wasok ur a atn wrik weij hngrapm kalpmel a atn yampingken tipmning Sainai pa. ");
INSERT INTO uri_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses kil ari pa, kil wreitn paitn akwonalmpen wailet, yatom kil kai atn yampingken yo pa akal ari worwor. Ari kil atning ek a Wailen pa kwewel la tolpa, ");
INSERT INTO uri_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Kil kupm Maur Wailen a tu yohmpei alkitnen. Kupm Maur Wailen a Apraham, Aisak a Jekob.’ Moses kil atning ekla ripa, kil kark ekg ari om kwarkwar tolti, lam ikgek alkilen ti. ");
INSERT INTO uri_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ari Wailen pa la nasel la tolpa, ‘Kitn nir nepm palk alkitnen pa tukulein nepm alkitnen pa pen, ekg nte knokg a kitn atne ti pa wri wor. ");
INSERT INTO uri_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ti kitn itning, kupm ari a tu ntekg paitn ekg tu wrong kinkpman alkupmen eren ukwen kalkut atn Ijip pa, wa kupm atning a tu wlakil hakg, tolpa ti kupm nar ekg akal aklinjen wiyen ye tukulein Ijip pa. Tolpa ti kitn wreitn ekg kupm kwaweitn kai Ijip ai pen.’ ” ");
INSERT INTO uri_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Yatom Stipen wa la kiti Moses pa wa la tolpa, “Ti apm Moses wrij pake a pike tu yohmpei amento ti kwantel la tolpa, ‘Mla la om kitn akal atn melnum tukgunakgen a ikghlen men ti, wa kitn akal atn melnum a arpm atning yangkipm a men tike?’ Pa apm Moses wrij pake a maur akwapel a Maur Wailen palntel om kil ari tukol wakg al yo hiket pa, kil wi ek a Maur Wailen pa la nasi Moses pa la tolpa, kil hi wa kai Ijip, al kil atn melnum wail, a melnum a hi wa wi tu alkil pa ye kai tukulein Ijip pa. ");
INSERT INTO uri_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Tolpa yatom apm Moses wrij pake, kil wi tu wrong kinkpman pa nuhurn Ijip. Yatom kil ntekg kweiur kweiur titnongket wrongwailet, wa ntekg kweiur weten ekg ak plan titnongket a Maur Wailen. Kil ntekg atn Ijip, a atn Hunokg Watet, wa hor wrik weij hngrapm kalpmel a tu hore kai pa tolpa kaingkai wring kmel wekg (40). ");
INSERT INTO uri_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ti apm Moses pake, kil la nasi tu wrong kinkpman a Israel pa la tolpa, ‘Maur Wailen kil hi akrkahan kmel ur a kipm alkipm ti pa wa atn melnum ek wripm ur tol kupm tike.’ ");
INSERT INTO uri_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yatom apm Moses pake, kil nti tu wrong kinkpman a mento Israel tu ark wrij hakai wrik weij hngrapm kalpmel. Kil wi yangkipm titnongket a Maur Wailen, a maur akwapel a Maur Wailen la nasel atn kaino tipmning Sainai pa yatom ye nar nasi tu yohmpei amento pa. Yangkipm a pike kil wi ye nar pa Maur Wor a Maur Wailen arpme, apm pike kil ye nar ekg ak nasi mento tike. ");
INSERT INTO uri_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ari tu yohmpei amento pa hret ekg atning katnun yangkipm a kil la pa, tu talpuln uk yirokg kil pa wa nikgwalpm a tu pa ark manet akwonalmpen la tolpa tu akal wa pleln wa kai Ijip pa yawrik. ");
INSERT INTO uri_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tolpa yatom tu la nasi Aron pa la tolpa, ‘Mento ake ari Moses a pike wio hakai Ijip ti ye kul ti, kil kaino main kaino tipmning ti ekg ntekg tolhai. Ti kitn ntekgto kweiur tiur tol a Maur Wailen kil alkil pa ekg al tu kai hep ekg akal ikghlento.’ ");
INSERT INTO uri_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Yatom ak wang ripa, tu lap weij malungkij muinmainet ur pa ntekg kalingken tol kau wlampien ur pa, yatom elntatn tol maur wailen ur alntuen. Yatom tu ye wlikgek kweiur kweiur pa ye kul al wor uk wa tu utopen ntekg ekpma wail al ekpma a nangnang atnen, wa kpor klko lein ekg kuina ur a tu alntu ntekg pa. ");
INSERT INTO uri_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tu ak tolpa yatom Maur Wailen kil ukwen yirokg, wa kil eln tu ekg tu kpor klko lein ekg kat nang a kweiur kweiur tukol takgni kainil a kungkumeim a atn kaino ktnong pa, tol a ro hel kai wurkapm a tu melnum ek wripm a Maur Wailen pa la tolpa, ‘Ti kipm wrong kinkpman a Israel ti, pike kipm ark kai wrik weij hngrapm kalpmel pa ark tol wring kmel wekg (40) pa, pike kipm alm wlikgek a kweiur kweiur ekg lap al wor uk kpor klko lein kupm tike aki? Pa kalpm. ");
INSERT INTO uri_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Wan yalming hapm a pike kipm kat ye pa, pa ake kipm kat wan yalming alkupmen ti pa, kipm kat yalming a mring Molek tukol maur wailen ur alkipmen. Wa pike kipm ari Repan, mring a ha ur ai pa, yatom wa kipm ntekg mring pa kalingken tol kungku yatom kat pa ye atn akal kpor klko lein tukol Maur Wailen alkipmen pake. Tolpa ti hi kupm kwantepm ekg tu wiyepm ye kai arpm kai yirokgen a ha wail Papilon pa.’ Yangkipm a Maur Wailen pa kil la kiti tu yohmpei alpmento pa apm kai tolpake.” ");
INSERT INTO uri_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Pike ak wang a tu manjan amento ark kai wrik weij hngrapm kalpmel pa, tu kpor klko lein Maur Wailen atn wan yalming hapm a tu ntekg pa. Pa planten tolpa Maur Wailen ntien arpm pa. Wan yalming hapm pa tu ntekg komkiti ek a Maur Wailen la nasi Moses akal tu ntekg pa, komkiti tol a kil kaling plan Moses ekg kil ari pa. ");
INSERT INTO uri_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Yatom tu warim a yohmpei wapyipmri, walyipmri amento ti pa tu wreitn wi wan yalming hapm a Maur Wailen pa. Yatom Josua pa atn hep wi tu amento pa wi wan yalming hapm pa ye nakur num kai alm kwan tu knokg yiprokgen pa, yatom Maur Wailen kwan tu pa kai tukulein wrik pa, om tu ti wi wrik pa arke ark. Yatom tu le wan yalming hapm a Maur Wailen pa elnthel tike. Om wan yalming hapm pa hel tolpa hel, kulngkul kul ngko wang a Teipit pa kil paln melnum tukgunakgen a ikghlenten. ");
INSERT INTO uri_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ti Teipit kil atn a arpm akwap wor tolpa kai ikg a Maur Wailen pa yatom Maur Wailen wi wor lawel. Yatom kil ropon Maur Wailen la tolpa, ‘Kitn Maur Wailen a yohmpei amento Jekob kpor klko leinjeitn pa, kitn wi wor akal kupm lenteitn wan yalming ur ti aki?’ ");
INSERT INTO uri_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Teipit yan pa la tolti, pake Maur Wailen ake wi wor, yatom warim kpman Solomon alkil pa lentel wan yalming pake. ");
INSERT INTO uri_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pake Maur Wailen a atn hep hangken kweiur kweiur wrongwailet pa kil ake arpm wan a mento melnum ti le pa, tol a pike Maur Wailen la hor ek a melnum ek wripm ur pa la tolpa, ");
INSERT INTO uri_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ktnong ti pa wrik a kupm arpme ikghlen kweiur kweiur wrongwailet ti, wa knokg ti pa, wa kupm eln nepm atne. Ti hi kipm lentopm wan tolhai? Hel wrik hai ekg al kupm arpm ekg wi yapm pa? Pa kipm ake ntie. ");
INSERT INTO uri_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kweiur kweiur wrongwailet a kipm ari ti pa, mla ur ntekg? Apm kupm tike.’ Yangkipm a Maur Wailen a melnum ek wripm ro pa apm la tolpake.” ");
INSERT INTO uri_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Yatom wa Stipen wa la nasi tu hong tukgunakgen a tu Juta pa la tolpa, “Kipm pa nungkulkget ikg kai pa kai pa! Kipm weij arpmepm nikgwalpm wa kweiur ak hmpriepm nungkulkg tukol tu a ipma wekg a ake pike tu kwat numpalk pa, kalpm. Ti kipm pa apm tol tu yohmpei alkipmen a pike hep aklei wang talpuln ek a Maur Wor a Maur Wailen la nasepm pake. ");
INSERT INTO uri_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ti tu yohmpei alkipmen ti pike ikghlen tu melnum ek wripm ur a Maur Wailen pa arpm wor aki? Kalpm. Pike tu ntekgen paitn ukwen wleket wailet. Maur Wailen pike kil kat ekel tu ekg laron melnum nipet wor a Maur Wailen akal hi nar pa, ari tu eren almpen mo tolti. Ti melnum nipet wor pa pike nar pa, apm pike kipm ak tol tu yohmpei alkipmen pake, uk ya ekg tu wrongmnto kul almpel mo. ");
INSERT INTO uri_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yangkipm titnongket a Maur Wailen pa apm pike maur akwapel alkil pa laron nasi kipm tike, ari ake wa kipm atning katnun yangkipm ripa!” ");
INSERT INTO uri_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tu hong tukgunakgen atning yangkipm a Stipen la pa ari yangkipm pa almpen tukol hikyom ur, yatom nikgwalpm a tu pa rkahangken om tu nam ek paitn tolti. ");
INSERT INTO uri_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ari Stipen pa Maur Wor a Maur Wailen akwap titnongket kai kil pa yatom kil ikgkaino ktnong pa ari, kil ari klalen a Maur Wailen, wa kil ari Jisas pa kil atn kai wam wien a Maur Wailen pa, ");
INSERT INTO uri_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","yatom kil la tolpa, “Ti kipm ikgkaino ri! Kupm ari ktnong ti rekel yatom kupm ari Warim Kpman a Melnum pa kil atn kai wam wien a Maur Wailen.” ");
INSERT INTO uri_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tu atning a Stipen la tolpa yatom, tu wreitn ipma wleket hmpri nungkulkg a tu plalplal tolti tu plalnten wreitn kul apm arkulel ase! ");
INSERT INTO uri_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tu arkulel talpulel rkol wampel tolpa ye kahor hen kai tukulein ha wail pa, plaln pa, tu nir hapm kakir wail a tu alntu nowe pa piln eln kai ha nepm a melnum warimpen ur a arpm atning yangkipm pa, nang akil pa Sol. Tu pa ak titnongketel yangkipm pa la tolpa apm aklahle pake, tu melnum a wet atning ari yangkipm a Stipen la pa, tu ak weijel akal kil mo. ");
INSERT INTO uri_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Plaln pa, tu plalnten tu wi weij pa ekg ak er Stipen atn pa, kil kwe la tolpa, “Wailen Jisas, kitn wi maur wor akupm ti om!” ");
INSERT INTO uri_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kil eln nepm klko pa atn wa kil wlakil hakg yikaktnen la tolpa, “Wailen, ampur kitn akalmpe paitnpaitn a tu ntekg kul ekg kupm ti, yaper.” Kil la tolpa plaln pa, kil mo. ");
INSERT INTO uri_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol pa kil atn ari ak ikg wi wor tolti yatom tu er Stipen pa mo. Ak wang pa tu er kwan uk wleket tu wrong kinkpman a ukpma Jisas a ark kai Jerusalem pa. Yatom tu wreitn hrak purnprarn, kai ark hor ha knokg Jutia a Samaria. Pake tu melnum yangkipm kuinen a Jisas pa tu ake kark kai hor ha ur ha ur kalpm, tu apm ark pa ark pake. ");
INSERT INTO uri_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Yatom tu melnum nipet wor tiur a ukpma Maur Wailen pa tu uwen Stipen pa, wa tu hakg wail. ");
INSERT INTO uri_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ari Sol pa kil atn er kwan uk wleket ntekg paitn ekg tu melnum a ukpma Jisas pa. Kil kahor wan ur wan ur er talpul tu kinkpman pa piln eln kulhor hen ai, om wiyen ye kai arpm wan tipmning. ");
INSERT INTO uri_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yatom tu wrong kinkpman a ukpma Jisas pa a pike purnprarn kai ark hor pa hor pa, tu kai atn ha ur ha ur om laron yangkipm wor a la kiti Jisas pa. ");
INSERT INTO uri_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip pa kil melnum wrij ur a tu pa kil kaino ha wail ur a ha knokg Samaria ekg laron yangkipm a Krais pa, nasi tu wrong kinkpman a ark kaino ha knokg ripa. ");
INSERT INTO uri_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Tu atn atning yangkipm a kil laron wa ari kweiur kweiur titnongket weten a kil ntekg pa, yatom tu ak wail kul kai eln nungkulkg pa atn atning yangkipm wor a kil piln pa. ");
INSERT INTO uri_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Wa tu ari a kil kwan maur paitn pa wlakil yikaktnen kark tukulein tu melnum wailet pa kulhor kai hen, wa kil ntekg tu melnum nepm paitn a numpwam mowe pa paln wor. ");
INSERT INTO uri_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tolpa yatom tu wrong kinkpman wailet, tu utopen wailmanten atn kaino ha wail ripa. ");
INSERT INTO uri_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Melnum ur a arpm kaino ha wail a Samaria pa, nang akil pa Saimon, kil pa melnum yar man, pike akwap pa wang watin, ntekg kweiur kweiur titnongket tiur atn kaino ha wail ripa, kil laron kil alkil pa, la tolpa kil pa melnum wailen ur. Yatom ak ntekg tu wrong kinkpman wailet a ark hor ha knokg a Samaria pa tu wreitn paitn ekg tu atning ari ripa. ");
INSERT INTO uri_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Yatom tu wrongwailet, tu a nang itnen, wa tu a nang kalpmen pa, tu plalnten ye nungkulkg a ikg a tu pa ye kai atn yampingken ekg akal atning ari worwor, wa tu la tolpa, “Melnum pa kil ntie titnongket tolpa om, mento kwe la tolpa ‘Melnum a arpmen titnongket wail tukol a Maur Wailen’ pa, apm melnum ripake.” Nikgwalpm a tu wrongwailet pa apm tolpake. ");
INSERT INTO uri_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kil pike akwap tolpa kul, yatom kil ntekg tu wreitn paitn katnuntel atn akal atning ari kweiur kweiur a kil ntekg ak titnongket a maur paitn pa. ");
INSERT INTO uri_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pake ak wang riti pa tu atning yangkipm wor a Pilip kil laron Jisas pa kil Krais, melnum a Maur Wailen kil kwa kul nar ekg akarmpento, wa kil laron yangkipm wor ekg Kingdom a Maur Wailen. Tu atning yangkipm ripa om ukpma, yatom tu kaluken wrongwailet, kinkpmanen. ");
INSERT INTO uri_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Wa Saimon yar man pa yat kil ukpma yatom tu kalukel, yatom kil katnun Pilip pa atn hor pa hor pa, ari kuina ur a Pilip ntekg ak titnongket a Maur Wailen pa, kweiur kweiur weten a melnum ake ntie ekg ntekg pa. Tolpa om kil wreitn paitn akwonalmpen wailet. ");
INSERT INTO uri_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yatom tu melnum yangkipm kuinen a Jisas tu ark kai Jerusalem pa tu atning tolpa, tu a ha knokg Samaria pa apm wa wi yangkipm wor a Maur Wailen ase. Tolpa yatom tu kwa Pita ekg Jon wa kainten. ");
INSERT INTO uri_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tuwekg kaino paln kaino Samaria pa, tuwekg ropon Maur Wailen ekg al tu wi Maur Wor. ");
INSERT INTO uri_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ekg nte Maur Wor ake kul nar arpm tu pa, kalpm. Tu pa pike tu kaluken kai nang a Wailen Jisas tolti hute. ");
INSERT INTO uri_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Yatom Pita ekg Jon eln wam hel tu pa ropon Maur Wailen pa om tu wi Maur Wor pa. ");
INSERT INTO uri_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon yar man kil ari a tuwekg eln wam hele tu pa ropon Maur Wailen pa yatom tu wi Maur Wor pa, tolpa om kil wi marpm pa ye kul uk Pita ekg Jon pa, wa kil la tolpa, ");
INSERT INTO uri_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Kipmekg ukopm titnongket ripa yat, ekg kupm eln wam hel tu melnum pa ekg tu wa wi Maur Wor pa yat.” ");
INSERT INTO uri_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ari Pita pa akalmpe la tolpa, “Kitn ye nikgwalpm paitn alkitnen a la tolpa, wa namponen marpm pa ye kai ha paitn pa om! Mla ur la naseitn la tolpa ekg kitn akal armpen kweiur kweiur wor a Maur Wailen uk kalpmel melnum ti pa, ak marpm pa! ");
INSERT INTO uri_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kil ake kwap ur a ak kathangkel kitn pa ekg al kitn ak kwap kil nti mentekg ti, ekg nte, nikgwalpm a kitn pa ake nipet wor kai ikg a Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ti kitn pleln ipma, wa uk yirokg nikgwalpm paitn a kitn akwonalmpen pa, yatom kitn ropon Wailen pa ekg kil kwan nikgwalpm a kitn akwonalmpen tolpa aki kalpm e. ");
INSERT INTO uri_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kupm ari kitn alupm nikgwalpm raimpen paitn tolpa, pa tukol hngkotong a kitn ye atn, wa kitn pa tukol wampung a ngko hmpei katen elntark pa.” ");
INSERT INTO uri_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimon kil atning tolpa yatom kil akalmpe Pita ekg Jon pa la tolpa, “Ti kipmekg ropon Wailen ekg kil iklinjopm ekg kuina ur paitn tol a wet kipmekg la pa ake al wa paln kul ekg kupm ti.” ");
INSERT INTO uri_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Yatom Pita ekg Jon laron yangkipm a Wailen a pike tuwekg atning ari a ntiel akwap pa nasen plaln pa, tuwekg wa pleln kinar Jerusalem. Tuwekg kinar pa, tuwekg piln yangkipm wor pa itna wampel tolpa kinar atn hor ha tiur a Samaria pa tolpa kinar Jerusalem pa. ");
INSERT INTO uri_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Maur akwapel a Wailen pa la nasi Pilip pa la tolpa, “Kitn wreitn hi ti om kinar hor ya a wrik weij hngrapm kalpmel pa, ya a atn Jerusalem pa wa kinar om wa kai ha wail Kasa pa, pa ya al kitn hore pa apm pake!” ");
INSERT INTO uri_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kil atning tolpa, kil wreitn om kinar. Kil hor ya pa kinar ari, kil hantil melnum ur a ha knokg Itiopia pa a pike kaino Jerusalem ekg kat nang a Maur Wailen yatom wa hakaino pa wa nar pa. Melnum pa pike tu klo nmroel. Melnum pa kil alkil melnum tukgunakgen wail a atn hep ikghlen marpm a kweiur kweiur wrongwailet a kin tukgunakgen atn hep ekg ikghlen tu melnum a Itiopia pa. ");
INSERT INTO uri_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Melnum wailen pa kil arpm wrik a hos pa rkolntel ye nar pa, kil wi wurkapm a melnum ek wripm Aisaia pa arpm klein itna wampel tolpa kinar akal kinar ha alkilen. ");
INSERT INTO uri_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Yatom Maur Wor pa la nasi Pilip pa la tolpa, “Kitn kinar ngkom yampingken wrik a hos rkol pa tolpa kai kinar.” ");
INSERT INTO uri_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilip kil atning a Maur Wor la tolpa, kil aktutu kinar yampingken wrik a hos rkol pa ngkom yampingken wrik pa tolpa kai kinar pa, om atning wurkapm a melnum wailen pa klein. Kil klein wurkapm a melnum ek wripm Aisaia ro pa. Yatom Pilip ropontel la tolpa, “Kitn klein pake, kitn ari wurkapm pa la tolhai?” ");
INSERT INTO uri_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ari melnum wailen pa akalmpe la tolpa, “Tol melnum ur ake la kiti yiprokgen pa worwor pa, al wa kupm wa ari tolhai?” Kil la nasi Pilip pa la tolpa plaln, om kil la nasel la tolpa kil al kaino ekg tuwekg arpm. ");
INSERT INTO uri_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Yatom Pilip kil kaino ntiel arpm. Yangkipm a melnum pa klein kai wurkapm pa pati la tolkil, “Kil pa tol sipsip a tu wiyel ye kai akal almpel mo. Wa kil tol sipsip warim a elntmpei arpm tolti ak wang a tu kwat walkg akil pa, kil apm tolpake, kil ake wlakil ur, kil elntmpei arpm tolti. ");
INSERT INTO uri_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tu ntekgel ari paitn. Tu arkuel, tu wiyel ye kai atn ekg ntekg yangkipm pa, ari ake wa tu ntekg yangkipm worwor ekg kil pa. Tolpa om kil alkil yek wrij, ti al mla ur la tolpa tu walmpopmen walyaru walyikek alkilen pa? Ekg kil apm tu almpel mo kai kwat lam tukulein knokg ti ase.” ");
INSERT INTO uri_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Melnum wailen pa kil klein wurkapm pa tolpa, kil ropon Pilip pa la tolpa, “Kitn nisopm ri, melnum ek wripm a ro wurkapm a kupm klein kil pa, kil ro ak la mla? Kil la kil alkil ti aki kil la melnum manet ur e?” ");
INSERT INTO uri_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Yatom Pilip kil la nasi melnum wailen pa yangkipm yiprokgen a wet kil klein pa. Kil katen yangkipm yiprokgen pa om laron yangkipm wor a la ekg Jisas pa ye ha pa kul pake. ");
INSERT INTO uri_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Tuwekg nar ya pa kinar pa, tuwekg kai paln kai wrik ur a hu arke pa, yatom melnum wailen pa la nasi Pilip pa la tolpa, “Kitn ri hu ur ark ti. Tol kitn klukopm itn ti aki? Aki wa kwei ur ha pen e?” ");
INSERT INTO uri_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Yatom melnum wailen pa la nasi melnum a ikghlen hos a rkol wrik pa ekg kil atn. Yatom hos pa kai atn pa, tuwekg yaten, Pilip ekg melnum wailen pa, ekg kai kinar atn hu pa, yatom Pilip kalukel. ");
INSERT INTO uri_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pilip kalukel plaln pa, tuwekg hakinar hu pa no pa, Maur Wor a Wailen pa wi Pilip pa titalhampen ye kai atn tol ur pa. Yatom melnum wailen pa ake wa ari Pilip pa, pake ak wang a kil nar ya pa kinar pa, ipma a kil pa utopen wailmanten. ");
INSERT INTO uri_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Maur Wor wi Pilip pa ye kai titalhampen tolpa, yatom wa tu ari kil wa paln atn kaino ha wail Astot pa, yatom apm kil atn hor ha lkgung lkgung pa laron yangkipm wor a la ekg Jisas pa itna wampel tolpa kaino, kaino paln kaino ha wail Sisaria pa. ");
INSERT INTO uri_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sol kil nikgwalpm wleket paitn ekg akal er tu disaipel a Wailen pa mo. Tolpa yatom kil kai ari melnum tukgunakgen a ikghlen tu ipma krakgen a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Yatom kil ropontel ekg akal kil ro wurkapm wompel ur, ekg al kil ye kaino klein atn wan wrij wrij a tu Juta kai atning yangkipm a Maur Wailen atne pa kaino ha wail Tamaskus. Melnum tukgunakgen a ikghlen tu ipma krakgen a Maur Wailen pa, kil atning tolpa, om kil rontel wurkapm wompel pa uk Sol pa. Wurkapm wompel pa ro tolkil: “Tol Sol kil kaino hantil kin aki kpman tiur a katnun ya a ukpma Jisas pa, pa kil arkulen, kinkpmanen, yipo wampel yatom wiyen ye kai arpm wan tipmning, om wiyen ye nar Jerusalem ti.” ");
INSERT INTO uri_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Yatom Sol kil kaino tolpa kaino yampingken ha wail Tamaskus pa, kil ari wakg titnongket ur a plaij hakaino ktnong pa kul nar helentel tolti kai plaln. ");
INSERT INTO uri_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Yatom kil ngko eln kinar ha knokg pa, wa kil atning ek ur a kwewel la tolpa, “Sol, Sol! Ntekg tolhai ti kitn uk kalkut a wleket ekg kupm ti?” ");
INSERT INTO uri_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Yatom Sol kil ropon la tolpa, “Melnum Wailen, kitn mla pa?” Ari ek ripa akalmpe la tolpa, “Kil kupm Jisas, kupm melnum a kitn ukopm kalkut a wleket aklei wang pa. ");
INSERT INTO uri_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ti kitn wreitn yatom kitn kaino kai kahor ha wail pa, om al melnum ur la naseitn kuina ur al kitn ntekg pa.” ");
INSERT INTO uri_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ti tu melnum a num akupe Sol atn pa, pa tu wreitn paitn hmit atn tolti, wa tu atning ek a la tolpa, pake ake wa tu ari melnum ripa, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol kil wreitn ha knokg pa arpm, pa ikg akil pa nungkwat, pake ake ntie ekg kil ari kweiur kweiur pa, kalpm. Yatom tu melnum a ntiel pa wamparpmel ye kaino kai kahor ha wail Tamaskus pa. ");
INSERT INTO uri_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kil arpm ikg mite arpm, kil ake ntie ekg ari kweiur kweiur pa kil ake wa al hu ekpma pa, kalpm. Kil arpm tolpa tol wang wraur miten. ");
INSERT INTO uri_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Wa disaipel ur a Jisas a arpm Tamaskus pa, nang akil pa Ananaias. Kil ari Wailen pa kwewel tukol ak hokgwangket pa la tolpa, “Ananaias.” Ari Ananaias pa akalmpe la tolpa, “Wailen, kupm apm kilke.” ");
INSERT INTO uri_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Yatom Wailen la nasel la tolpa, “Kitn wreitn hor ya pa kai, ya a tu kwe la tolpa Ya Nipet. Kitn hor ya pa kai paln wan a Jutas pa, kitn ropon tu ekg melnum ur a ha wail Tarsus, nang akil pa tu kwe la tolpa Sol, kil pa apm arpm wan ripake. Pa kitn kahor riel om, kil ropon Maur Wailen arpm pa. ");
INSERT INTO uri_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Kil wet kupm plantel kweiur tukol hokgwangket pa hep ase, ti kil ari tolpa akal kitn Ananaias kai ariel eln wam helel ropon Maur Wailen ekg akal aklin ikg akil pa paln wor ekg ari kweiur kweiur pa.” ");
INSERT INTO uri_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaias akalmpe kai Wailen pa la tolpa, “Kupm atning a tu melnum wailet la kiti melnum ripa la tolpa, kil melnum a ntekg paitn uk wrongmnto tu wrong kinkpman wri wor alkitnen atn kinar Jerusalem pa. ");
INSERT INTO uri_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ti kil pikekg no Tamaskus ti namponen wurkapm titnongket a melnum ipma krakgen a Maur Wailen a atn hep ukwel la tolpa, kil arkul tu men a kpor klko lein kitn wa kat nang akitn pa yatom wiyo ye kai kinar arpm wan tipmning.” ");
INSERT INTO uri_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ari Wailen la nasel la tolpa, “Kitn kai om, melnum Sol pa melnum a kupm akrkahan tukol sakal a kotwang alkupmen ekg ak ak kwap alkupmen ekg ye nang alkupmen kai laron nasi tu melnum a ake Juta, wa tu melnum tukgunakgen wail wail atn hep, wa tu wrong kinkpman a Israel. ");
INSERT INTO uri_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Al kupm wa plantel ekg kil hi wa ye kalkut a wleket aur aur ekg katen ak kwap a laron nang a kupm hor pa kai.” ");
INSERT INTO uri_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananaias kil atning ekla a Wailen kil la nasel la tolpa plaln pa, kil ak komkiti. Kil kai ari wan a Sol arpme pa tolti, kil kai kahor wan wonen pa, eln wam hel Sol pa wa kil la tolpa, “Melnum wor alkupmen Sol. Wailen Jisas kil kwawopm kul ekg kitn tike, Jisas kil alkil melnum a pike palnteitn ngko kinar ya pa ak wang a kitn no ti. Kil kwawopm kul ekg kitn ti ekg ikg akitn ti al paln wor ari kweiur kweiur, ekg kitn hi wa wi Maur Wor a Maur Wailen nti.” ");
INSERT INTO uri_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Yatom aktutu tolti kweiur tol yul kerpm ur a ak hmpri ikg a Sol pa eln kinar knokg ai, wa ikg akil pa paln wor ari kweiur kweiur pa om. Tu kalukel ak nang a Jisas pa plaln pa, ");
INSERT INTO uri_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","kil wi ekpma pa al, yatom kil wi titnongket pa om. Sol kil arpm wang aripm ur nti tu disaipel a Jisas arpm Tamaskus. ");
INSERT INTO uri_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ak wang a kil nti tu pa arpm pa, ake wampen kil wreitn tolti katen kwap a laron nang a Jisas ti hor wan a tu Juta atning yangkipm a Maur Wailen atne pa la tolpa, “Jisas pa Warim Kpman aklahle a Maur Wailen.” ");
INSERT INTO uri_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Yatom tu melnum a tu atning yangkipm a Sol laron pa, tu wreitn paitn ekg yangkipm a kil la pa. Yatom tu ropon tita la tolpa, “Apm melnum a pike ntekg paitn alm tu melnum a kpor klko lein kwe nang a Jisas atn kinar Jerusalem pa apm pake! Ti apm kil no akal arkulo wiyo ye kinar ekg tu melnum ipma krakgen a Maur Wailen a atn hep pake!” ");
INSERT INTO uri_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ari Pol kil wi titnongket tolpa ye kai wail wail, yatom kil laron Jisas pa yekariworwor kai itna yiprokgen la tolpa kil melnum a pike Maur Wailen akrkahan yatom kwa nar ekg akwi tu wrong kinkpman, yatom yangkipm a kil la pa ak ntekg tu wrong kinkpman a Juta a ark Tamaskus pa, tu wreitn paitn kor yangkipm ur akal akalmpe kai kil pa ari tu yangkipm kalpmten. ");
INSERT INTO uri_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Wang aripm ur kai plaln pa, tu Juta tu kai ark wrij yipon yangkipm akal alm Sol pa mo. ");
INSERT INTO uri_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ari kil atning tu ur la nasel la tolpa, tu pa yipon yangkipm akal tu wa almpel mo. Yatom aklei mning a hran pa tu atnen yipmingki wanyun a ha wail pa atn, akal kil hor wanyun pa kahor ngko hen pa, tu almpel mo. ");
INSERT INTO uri_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ari tu disaipel a nti Sol pa wiyel ak mning ur pa ye kaino atn yipmingki a kapringen ha wail pa yatom kil kahor arpm hrkwa wail ur pa, yatom tu lekg kil pa ark hmpei eln kinar knokg pa. Yatom kil kinar Jerusalem ase. ");
INSERT INTO uri_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol kil kinar paln kinar Jerusalem pa, kil akal wa kai nti tu disaipel a Jisas. Ari tu disaipel a Jisas pa tu kark paitn ekg kil pa, wa tu ake ari lak kil pa apm paln disaipel aklahle ase. ");
INSERT INTO uri_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ari Parnapas kil wi Sol pa ye kai ikghlentel arpm, yatom wiyel ye kai ekg tu melnum yangkipm kuinen a Jisas pa, wa la kiti nasen la tolpa, Sol pike ari Wailen ngko ya yatom Wailen la nasel yangkipmek. Wa kil la kiti nasen a pike kil wi titnongket yatom laron nang a Jisas atn kaino Tamaskus. ");
INSERT INTO uri_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tu atning Parnapas laron Sol tolpa, yatom tu ake kark, tu ukwel wor. Om Sol kil kai ntien arpm yatom kil atn titnongket ntien laron nang a Wailen hor kai Jerusalem pa. ");
INSERT INTO uri_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yatom wa kil wa laron yangkipm pa nasi tu Juta a ak ek Krik pa yatom tu ak yangkipm pa hripon, ari tu ntekg akal almpel mo. ");
INSERT INTO uri_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pake tu melnum ipma wrij a ukpma Krais, tu atning a tu la tolpa, tu akal almpel mo, tolpa yatom tu wiyel ye kaino ha wail Sisaria yatom kwawel ha pa kaino ha wail Tarsus. ");
INSERT INTO uri_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yatom tu wrong kinkpman a ukpma Jisas a ark hor ha knokg Jutia, ha knokg Kalili, a ha knokg Samaria pa tu arpm mehen wor utopen. Tu kark ekg Wailen yatom tu ark horhanekg ekg Wailen tolti, wa Maur Wor aklinjen ukwen titnongket, yatom tu wrong kinkpman pa kai wailet wailet tolpa ukpma katnunten. ");
INSERT INTO uri_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita kil atn ha ur ha ur, yatom wang ur pa, kil kai ari tu wrong kinkpman a Maur Wailen a ark kai ha wail Lita pa. ");
INSERT INTO uri_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yatom kai ha pa kil hantil melnum ur, nang akil kwe la tolpa Ainias. Melnum pa nepm wam mowe hokga wrik wringkwringen. Kil ha wrik pa ha tol wring wampomit wampomwraur (8). ");
INSERT INTO uri_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Yatom Pita kil la nasi melnum pa la tolpa, “Ainias, Jisas Krais kil ntekg kitn paln wor. Ti kitn wreitn kit wrik kweiur kweiur alkitn ti ye kai elntirk om!” Pita kil la tolpa, pa melnum pa kil wreitn wor tolti kat wrik akil pa ye kai elntark. ");
INSERT INTO uri_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Yatom tu wrong kinkpman wailet a ark ha wail Lita, wa ark wrik hmpreket wail a tu kwe la tolpa Saron pa, tu ari melnum a paln wor pa, pa tu pleln ipma kai katnun Wailen. ");
INSERT INTO uri_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kin wrij ur a ukpma katnun Jisas a arpm ha wail Jopa pa, nang akil pa Tapita. Nang wompel a kwe ak ek Krik pa, kwe la tolpa Tokas. Kil kin a alupm nikgwalpm worwor, ak kwap wor, wa kil aklei wang aklin tu melnum a arpm warkip. ");
INSERT INTO uri_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ari ak wang pa kil yek wi numpet, yatom kil mo. Tu kaluk palk yek a kil pa, yatom ye kaino elntha kaino wan kwa wlop wekg pa. ");
INSERT INTO uri_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ha wail Lita pa ark yampingken ha wail Jopa ti. Tu disaipel a Jisas a arpm ha wail Jopa ti pa, tu atning tolpa Pita pa arpm kinar ha wail Lita pa, yatom tu kwa melnum wekg ur pa kinar ari Pita pa la nasel la tolpa, “Kitn wreitn ntio kaino ha wail Jopa ti iktutu!” ");
INSERT INTO uri_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Yatom Pita wreitn ntien kaino. Kil kaino paln kaino ha wail Jopa pa, tu wiyel ye kaino wan kwa wlop wekg ripa. Tu kin karpikg wi hapm a nowe arpm wonen, wa hapm a nowe ti a pike Tokas kut ak wang a kil arpm pa yatom ukwen pa, hakg rein plan Pita. ");
INSERT INTO uri_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ari kalpm, Pita la tolpa tu kai kahor hen, wa kil kpor klko lein ropon Maur Wailen. Plaln pa, kil pleln kaino ari yipmri a kin a ha pa om la tolpa, “Tapita, wreitn om!” Yatom kil ikg wor ari Pita pa, yatom kil wreitn arpm. ");
INSERT INTO uri_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita kai wamparpmel aklinjel ekg kil wreitn atn. Yatom kil kwe tu wrong kinkpman wri wor a Maur Wailen namponen tu kin karpikg pa hor ariel tolpa kil wreitn ase. ");
INSERT INTO uri_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yatom yangkipm pa hompen kai tu atning hor ha wail Jopa pa, om tu wailet tu pleln ipma, ukpma katnun Wailen. ");
INSERT INTO uri_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Yatom Pita kil nti Saimon melnum a nir palk a wlikgek pa arpm ha wail Jopa pa wang aripm ur pen. ");
INSERT INTO uri_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Melnum ur a arpm kaino ha wail Sisaria pa, nang akil pa Kornilius. Kil atn hep ikghlen tu melnum kmel wampomit (100) a almpwrong a tu mapming ur a tu kwe la tolpa tu Itali. ");
INSERT INTO uri_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kil ake melnum a Juta pake kil melnum wor a kpor klko lein katnun Maur Wailen, wa kil pa namponen tu a ark wan alkilen pa tu kark ekg ikg a Maur Wailen, yatom tu arpm horhanekg ekg kil. Kil aklin tu Juta wailet a arpm warkip, wa kil ropon Maur Wailen aklei wang. ");
INSERT INTO uri_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Om ak wangkur pa takgni pleln kinar ekg akal wel tukoryok la pa kil ari Maur Wailen plantel tukol hokgwangket pa kil ari worwor tolpa maur akwapel a Maur Wailen pa paln kahor wan alkil ti kwewel la tolpa, “Kornilius!” ");
INSERT INTO uri_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornilius pa ikghnentel yatom wa kil wutnan paitn la tolpa, “Melnum Wailen, kitn kweopm ekg kuina?” Ari maur akwapel a Maur Wailen pa akalmpentel la tolpa, “Maur Wailen atning ropo akitn pa. Ti kweiur kweiur wrongwailet a kitn ntekg ekg aklin tu melnum a arpm warkip pa, Maur Wailen ari pa om kil wi wor lawen. ");
INSERT INTO uri_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yatom kitn kwa melnum aripm ur pa kinar ha wail Jopa pa ikwi melnum ur, nang akil pa Saimon pa, ye no. Nang wompel akil pa Pita. ");
INSERT INTO uri_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Kil nti nangkur alkil Saimon, melnum a nir palk a wlikgek pa arpm, wan akil pa hel yampingken hunokg.” ");
INSERT INTO uri_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Maur akwapel a Maur Wailen pa la ekla pa plaln pa kil nuhurntel kai. Kornilius wi melnum akwapel wekg alkil a akwap atn wan alkilen pa, namponen melnum wrij a almpwrong pa yat. Melnum a almpwrong pa kil melnum wrij ur kai kuin a tunten melnum a alupmel worwor horhanekg ekg Kornilius pa, wa kil melnum wor a kpor klko lein katnun Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kil la nasen worwor ekg maur akwapel a Maur Wailen wet palntel la nasel ekla kweiur kweiur pa plaln, yatom kil kwawen ekg tunten kinar ha wail Jopa pa ekg akwi Pita pa ye no. ");
INSERT INTO uri_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tunten kinar hokga ya pa, om hor kang pa tunten wreitn ha pa kinar yampingken ha wail Jopa pa. Ak wang a yampingken ekg akal takgni no kwarngkwarn pa tunten ngkom nar ya ti yampingken ekg akal kinar paln pa, Pita wa arpm kinar ha wail Jopa pa arpm, kil pa kaino arpm kaino wan kmpo kwa a wan wlop wekg pa ekg ropon Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kil ropon Maur Wailen tolpa arpm ari nikgtel, om kil akal al ekpma ur. Yatom ak wang a tu numprampen ekpma pa, kil ari kweiur tukol hokgwangket. ");
INSERT INTO uri_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kil ari ktnong ti rekel tolti, kil ari nmong hute wail ur a hmpei itne nmpel witnweitn akil pa, om lekg hakaino ktnong ti kul nar, ari tol hapm hute wail ur pa. ");
INSERT INTO uri_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Hel nmong hute pa wlikgek a ikgur ikgur. Tukol mnto, wampung a kweiur kweiur a hrong hor knokg pa tukol ul pa, wa wel a hor kaino kwa pa. ");
INSERT INTO uri_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ari ek ur pa la nasel la tolpa, “Pita, wreitn om, ilm wlikgek ur pa ntekg il om!” ");
INSERT INTO uri_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ari Pita pa la tolpa, “Wailen, kalpm wrijen! Kupm ake pike al kweiur kweiur a hongket hongket a pike men klon ekg al pa.” ");
INSERT INTO uri_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ari kalpm, ek pa wa la nti ur la tolpa, “Kweiur kweiur pa pike klon ekg al pa, pake ak wang ti pa Maur Wailen kil ntekg wor plalnten ekg akal al wangkwrije tolti, ti ampur kitn la tolpa pa hongket hongket a kitn klon ekg al pa, kalpm.” ");
INSERT INTO uri_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ek pa la tolpa nti wekg pa kai plaln, wa la nti wraur ti pa, wlikgek a hel nmong hute pa apm wa rkoln ye wa kaino ktnong ase. ");
INSERT INTO uri_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita pa kil arpm akwonalmpen wailet akal kil wa ari yiprokgen a kweiur kweiur a wet kil ari pa. Ari kalpm, melnum wraur a pike Kornilius kwa kul ekg akwiel pa, apm ten kul paln atn yipmingki yun tike. Wet tunten ropon ropon tolpa kinar kinar, yatom tu planten la tolpa wan a Saimon a Pita arpme pa apm tike. ");
INSERT INTO uri_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tunten atn yipmingki yun pa kwe yikaktnen kahor wan pa roponten la tolpa, “Oi, Saimon, nang wompel a kil pa Pita, pa ntiepm arpm pake?” ");
INSERT INTO uri_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita pa arpm kaino kwa pa akwonalmpen kweiur kweiur a wet palntel pa, ari Maur Wor a Maur Wailen pa la nasel la tolpa, “Melnum wraur ur kul koreitn atn ti. ");
INSERT INTO uri_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kitn wreitn kinar rien om! Tunten pa pike kupm ti kwawen nar ekg akwiyeitn. Ti ampur kitn akwonalmpen wailet, kitn ntien kaino om!” ");
INSERT INTO uri_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Yatom Pita atning nungkulkg tolti wreitn kinar arien om la nasen la tolpa, “Kupm a kipm koropm apm kupm apm tike. Ti kipm koropm nar ekg kuina?” ");
INSERT INTO uri_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yatom tunten akalmpe la tolpa, “Kornilius melnum ur a atn hep ikghlen tu melnum kmel wampomit (100) a almpwrong pa kwawo nar. Kil melnum wor a kpor klko lein katnun Maur Wailen, wa kil melnum a kark ekg Maur Wailen. Kil melnum a Rom, pake kil melnum a tu Juta a ariel kporn yangkipm la tolpa, kil pa melnum wor. Maur akwapel a Maur Wailen pa pike la nasel, yatom kil kwa mento ti nar ekg akwi kitn ti ye kaino wan ha alkilen pa, ekg kitn al la kiti kuina ur a kitn akal la kitintel kaino ai.” ");
INSERT INTO uri_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pita atning a tunten la nasel plaln pa, kil akwiyen ye kahor wan pa om loklien ntiel hokga mning wrij. Yatom hor kang pa kil wreitn ntien kaino. Wa tu melnum ipma wrij tiur a tu ukpma Jisas a arpm ha wail Jopa pa wa tu wreitn ntien kaino yat. ");
INSERT INTO uri_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Tu kaino hokga mning wrij ha ya pa, plaln, wa tu wreitn ha pa kaino paln kaino ha wail Sisaria. Kornilius pa kil wi tu walmpopmwrij, wa tu melnum worwor tiur alkilen pa kul kor tita ark nungkwangkenten arkenten ark. ");
INSERT INTO uri_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tu kaino paln ha pa tolti, Pita kai herk ekg akal kahor wan pa, Kornilius kil kul eln kpor klko leinjel ukwel wor. ");
INSERT INTO uri_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ari Pita la nasel la tolpa, “Wreitn om! Kupm apm melnum tol kitn pa yat pake.” Yatom kil wamparpmel om kil wreitn. ");
INSERT INTO uri_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tuwekg ekla itna wampel kai kahor, ari Pita ari tu wrong wailet pa apm ark tike. ");
INSERT INTO uri_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Om Pita la nasen la tolpa, “Kipm ari yangkipm titnongket a men Juta pa la tolpa ake al men kai atn a ark horwrij namponen kipm a ake Juta pa, kalpm. Ari ak wang ti Maur Wailen pike plantopm klal a la tolpa ake al kupm kwe melnum ur la tolpa kil pa ake wor kai ikg a Maur Wailen aki, ake al kupm klon ekg atn horwrij namponen kil pa. ");
INSERT INTO uri_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tolpa om ake kupm talpuln ek a kitn kwa tunten kinar ekg akwiyopm pa. Kupm atning nungkulkg tolti, om kupm no. Tolpa ti kupm akal roponteitn la tolpa, kipm lak kupm al kul no ekg kuina?” ");
INSERT INTO uri_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ari Kornilius akalmpe la tolpa, “Wang wraur kwaten ase, pike kupm arpm wan ti ropon Maur Wailen. Om ak wang ketn tolti, ak wang a takgni pleln kinar ekg akal wel tukoryok wa la pa, kupm ropon Maur Wailen arpm ari, aktutu tolti melnum ur pa paln atn ikgek a kupm ti. Hapm pa tungkoren muinmainet tolti. ");
INSERT INTO uri_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Yatom wa kwe nang a kupm Kornilius ti wa la nasopm la tolpa, ‘Kornilius, Maur Wailen atning ropo akitn pa. Wa kweiur kweiur a kitn ak ekg aklin tu melnum a arpm warkip pa kil ari pa om kil wi wor lawen pa. ");
INSERT INTO uri_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tolpa ti kitn kwa melnum tiur kinar Jopa ekg akwi Saimon, nang wompel akil pa Pita. Melnum pa arpm wan a Saimon melnum nangwrij alkil a nir palk a wlikgek. Wan pa hel hunokg arkikg kinar Jopa.’ ");
INSERT INTO uri_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Maur akwapel a pike palntopm pa la nasopm tolpake. Om kupm kwa melnum wraur ti kinarnteitn aktutu. Ari wa wor ekg kitn atning nungkulkg tolti kitn no. Ti men apm kul ark ti atn ikg a Maur Wailen ti, akal atning yangkipmek a pike Wailen la naseitn pa ekg al kitn la naso.” ");
INSERT INTO uri_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita la tolpa, “Aklahle wrijen, ak wang ti kupm ari worwor tolpa, Maur Wailen ake al wi wor la ur, a wa wi paitn la ur, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Melnum a ha ha knokg wrongwailet a atn knokg ti mla ur a kark kai ikg a Maur Wailen pa, yatom ntekg kuina ur a nipet wor kai ikg a Maur Wailen pa, Maur Wailen kil wi wor la melnum ripa. ");
INSERT INTO uri_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kipm ari yangkipm a Maur Wailen kwa nar ekg men wrong kinkpman a Israel pa. Pa yangkipm wor a laron Jisas Krais tolpa kil Wailen a mento wrongwailet, wa kil ntekg ipma a Maur Wailen pa kil ipma wrij namponen mento ti. ");
INSERT INTO uri_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ti kipm ari kuina ur a pike paln pa. Pike Jon kil laron yangkipm la tolpa, tu pleln ipma om kil kaluken. Kil katen ak atn kaino ha knokg Kalili pa, yatom wa tu laron kul nar hor ha knokg Jutia ti. ");
INSERT INTO uri_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Wa kipm ari a pike Maur Wailen kil kwa Maur Wor alkilen kul nar kaluk Jisas a Nasaret, wa ukwel titnongket wail, yatom Maur Wailen ntiel arpm om kil atn akwap wor aklin tu wrong kinkpman hor ha ur ha ur tolpa kai, wa kwan Maur Paitn Satan tukulein tu wrongwailet a pike Satan yipoen pa. ");
INSERT INTO uri_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yatom men pike nungkulkg a ikg ekg kwap wrongwailet a pike kil ak atn ha knokg a men Juta, wa atn kinar ha wail Jerusalem pa, yatom men laron la tolpa aklahle. Wa tu karkurn melnum ripa ark yo pa yatom kil mo. ");
INSERT INTO uri_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pake ak wang wraur pa, Maur Wailen wa la ekg kil wa wreitn, om ntekg kil wa paln ngko wurknong ekg tu ariel. ");
INSERT INTO uri_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Maur Wailen ake la ekg akal kil kai paln ngko wurknong ekg tu wrongwailet pa ariel pa, kalpm. Kil la ekg akal kil paln ngko wurknong ekg tu melnum a pike kil akrkahanten hep ak ai, pa apm men tike. Kil mo om wa wreitn kai palnto tolti men ariel, men al hu a ekpma ntiel, apm men tike. ");
INSERT INTO uri_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Yatom kil la nasi men ti la tolpa hi men laron nasi tu wrong kinkpman pa la tolpa, Maur Wailen kil kat kil pa atn ekg hi arpm atning yangkipm a tu melnum a arpm ti, a tu melnum a mo kaingkai pa yat. Om men laron la tolpa pa aklahle. ");
INSERT INTO uri_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tu melnum ek wripm wrongwailet a Maur Wailen pike hep pa apm wa laron kil pa tolpa yat pake la tolpa pa aklahle pa, nang akil pa ntie titnongket wa ak kwan paitnpaitn a mla ur a ukpma kil pa.” ");
INSERT INTO uri_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita piln yangkipm pa tolpa atn ari Maur Wor a Maur Wailen pa nar arpm tu melnum a arpm atning yangkipm pa. ");
INSERT INTO uri_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tu melnum a Juta a ukpma Jisas a wet nti Pita no pa, tu ari Maur Wor pa kul nar arpm tu melnum a ake Juta pa yat, yatom tu wreitn paitn, ");
INSERT INTO uri_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ekg nte tu atning a tu ak ek manet tiur pa ekla, ak kat nang a Maur Wailen pa tolpa atn. Yatom Pita la tolpa, ");
INSERT INTO uri_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ake al melnum ur loko ekg mento kaluken! Kipm ri tu wi Maur Wor hirhir tukol mento ti, ti mento kaluken ak hu ti om.” ");
INSERT INTO uri_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Yatom Pita la nasen la tolpa, tu al kaluken ak nang a Jisas Krais. Yatom tu kaluken plaln pa, tu lokel la tolpa kil al ntien arpm wang aripm ur pen. ");
INSERT INTO uri_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tu melnum yangkipm kuinen a Jisas namponen tu melnum ipma wrij a ukpma Jisas a ark hor ha knokg a Jutia pa tu atning yangkipm a tu la kiti nasen la tolpa ake tu alntu Juta ti tolti pa, pa tu wrong kinkpman manet tiur a ake Juta pa tu wa ukpma a katnun yangkipm a Maur Wailen pa yat ase. ");
INSERT INTO uri_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Yatom Pita kinar Jerusalem, ari tu melnum a ukpma Jisas Krais pa, tu a kwat numpalk pa, tu klewel, ");
INSERT INTO uri_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","yatom tu la tolpa, “Kitn ntekg tolhai om kitn pike kahor wan a tu melnum a ake kwat numpalk pa, wa kitn al ekpma pa namponen tu pa!” ");
INSERT INTO uri_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ari Pita la kitinten kuina ur a pike palntel pa, om kil ak komkiti pa, om kil la nasen worwor, la nasi tu la tolpa, ");
INSERT INTO uri_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Kupm arpm kaino ha wail Jopa pa arpm, ak wang wrij ur pa kupm ropon Maur Wailen pa arpm, om kupm ari kweiur tukol hokgwangket pa. Yatom kupm ari nmong hute wail tukol hapm hute wail ur a hmpei itne nmpel witnweitn pa yatom lekg hakaino ktnong ti katen kweiur kweiur kul nar ha won akupm ti. ");
INSERT INTO uri_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Kupm ari ikgarpme yekworwor, ari wlikgek a ikgur ikgur, wlikgek tilipmingken tukol mnto, wampung, a wa kweiur kweiur tukol ul a hrong hor knokg ti, a wel a hor kaino kwa ai. ");
INSERT INTO uri_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Yatom kupm atning ek ur pa kwe nang a kupm Pita ti la tolpa, ‘Pita, kitn wreitn ilm wlikgek ur pa ntekg il om!’ ");
INSERT INTO uri_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ari kupm ti akalmpe la tolpa, ‘Wailen, kalpm wrijen! Kupm ake pike al kweiur kweiur a hongket hongket a pike men klon ekg al pa.’ ");
INSERT INTO uri_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ari kalpm, ek pa wa la hakaino ktnong pa nar nti ur la tolpa, ‘Kweiur kweiur pa pike klon ekg al pa, pake ak wang ti pa Maur Wailen kil ntekg wor plalnten ekg akal al wangkwrije tolti, ti ampur kitn la tolpa pa hongket hongket a kitn klon ekg al pa, kalpm.’ ");
INSERT INTO uri_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ek pa la nti wraur, plaln pa, wlikgek ha nmong hute pa apm wa rkoln ye kaino ktnong ase. ");
INSERT INTO uri_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kupm ari paln tukol hokgwangket pa ha kaino Jopa pa ak wang pa, melnum wraur a pike Kornilius, melnum wailen ur, kwawen hakaino ha wail Sisaria ti kul nar ha wail Jopa pa, apm ten nar paln ak wang ketn ripake, ariopm atn wanyun a pike men arke ark kaino pa. ");
INSERT INTO uri_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Yatom Maur Wor a Maur Wailen pa la nasopm la tolpa, pa al kupm ntien kaino wa ake al kupm akwonalmpen wailet. Kupm atning tolpa, om kupm wreitn akal kaino pa, melnum wampomit wampomwrij ti wa wreitn ntiopm yat om men kaino. Men kaino paln kaino wan a Kornilius ai. ");
INSERT INTO uri_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kil la kitinto tolpa kil pike ari maur akwapel a Maur Wailen nar kahor atn wan akil. Om maur akwapel pa la nang akupm Saimon ti wa nang wompel akupm pa Pita la nasel la tolpa, kil kwa melnum tiur pa nar ha wail Jopa pa ekg akwiopm ye kaino. ");
INSERT INTO uri_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Kil la tolpa kupm hi wa ukwel yangkipm ur, yangkipm ripa, hi wa Maur Wailen akwiyel ekg alkilen namponen tu a ntiel ark wan akil pa. ");
INSERT INTO uri_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kornilius atning a maur akwapel pa la nasel tolpa, yatom kil kwa tunten kul nar akwiopm ye kaino. Om kupm la nasen yangkipmek pa atn, ari Maur Wor pa nar kahor arpm tu wrij wrij pa, tol a pike nar arpm mento ti hep ak ai pen. ");
INSERT INTO uri_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kupm atning a ari pa om, katopm won ekg akwonalmpen yangkipm a pike Wailen Jisas kil la tolpa, ‘Jon pike kaluk tu ak hu, pake mento ti pa hi wa kaluko ak Maur Wor.’ ");
INSERT INTO uri_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pike mento Juta ti ukpma Wailen Jisas Krais, yatom Maur Wailen kil uko Maur Wor pa tol kweiur kweiur wor alkilen a aklin mento. Wa ak wang ti Maur Wailen wa kil uk kweiur kweiur wor akil pa ekg akal wa aklin tu a ake Juta pa yat. Tolpa ti kupm ti melnum tolhai al kupm ak hmpri kwap a Maur Wailen pike ak kai tu pa!” ");
INSERT INTO uri_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tu atning yangkipm a Pita la pa yatom nikgwalpm a tu wet klewel pa, wa tu elnten, wa tu ipma wrij namponentel. Tu kat nang a Maur Wailen ti om tu la tolpa, “Woi, kipmten! Mento la tolpa, al tolpa kalpm, ari wa Maur Wailen uk ya tu a ake Juta pa yat, om tu pa yat ntie ekg pleln ipma om wi Maur Wor a arpm wor aklei wang hor pa kai.” ");
INSERT INTO uri_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Pike tu akweijel Stipen pa mo om, wa tu uk wleket wailmanten tu kinkpman wrongwailet a ukpma Jisas pa. Tolpa yatom tu melnum tiur a ukpma Jisas pa tu kark purnprarn kai atn hor pa hor pa. Tu kaino ha knokg a Ponisia, ha knokg wasok Saiprus a ark hunokg kuin, wa ha wail Antiok. Tu ake laron yangkipm a Maur Wailen pa nasi tu manet pa, kalpm. Tu laron yangkipm pa nasi tu alntu a Juta pa hute. ");
INSERT INTO uri_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pake tu tiur kai kuin a tu pa tu melnum tiur a Saiprus, wa tiur a ha wail Sairini. Yatom tu kaino paln kaino ha wail Antiok pa tu wa laron yangkipm wor a la Wailen Jisas pa nasi tu Krik a ake Juta pa yat. ");
INSERT INTO uri_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Titnongket a Wailen pa arpmen, om tu wrong kinkpman wailet pa pleln ipma ukpma kai katnun Wailen. ");
INSERT INTO uri_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tu melnum a ukpma Jisas a arpm kai Jerusalem pa atning yangkipm a tu la kiti la tolpa Maur Wor a Maur Wailen akwap atn kaino Antiok pa, yatom tu kwa Parnapas pa kaino. ");
INSERT INTO uri_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Kil kaino paln kaino pa kil ari Maur Wailen kil plan ipma wor akil pa kai ekg tu pa, yatom kil utopen. Kil kat nikgwalpmel tu pa la tolpa tu uk nikgwalpm wor yahuwen a tu ti kai ark Wailen pa atn titnongket ye tolpa kai. ");
INSERT INTO uri_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Parnapas pa kil melnum wor, Maur Wor pa arpm wail akwap wail arpm kahor nikgwalpm a kil pa, wa kil melnum a ukpma Wailen ti titnongket. Yatom tu wrong kinkpman wailet pa tu pleln ipma kai katnun Wailen. ");
INSERT INTO uri_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Yatom Parnapas apm kai kor Sol kai ha wail Tarsus pake. ");
INSERT INTO uri_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kil kor kaingkai, kil hantilel yatom kil akwiyel om tuwekg kul nar Antiok. Wring miten wrij pa tuwekg arpm nti tu wrong kinkpman a ukpma Krais atn Antiok pa. Yatom tuwekg ro tukgunakg lngkep a tu wrong kinkpman wailet pa ekg yangkipmek a Maur Wailen. Pike hep pa tu ake kwe tu disaipel a Jisas pa la tolpa tu a Krais pa. Atn atn apm tu kwe nang weten tolpa tu a Krais atn Antiok ti. ");
INSERT INTO uri_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ak wang pa tu melnum ek wripm tiur a Maur Wailen tu nuhurn Jerusalem pa, tu no Antiok. ");
INSERT INTO uri_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Melnum ek wripm wrij ur atu pa, nang akil pa Akapus. Maur Wor akwap kai kil pa, om kil wreitn atn la nasi tu wrong kinkpman pa la tolpa wang nikg wail hi wa paln kai hor ha knokg wrongwailet. Ei, tol ek a kil la pa, ti wang nikg wail apm pike paln ase, ak wang a Klotius atn melnum tukgunakgen a tu Rom. ");
INSERT INTO uri_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tolpa yatom tu disaipel a Krais pa tu atning pa tu ark yipon yangkipm akal kor tita marpm kweiur kweiur tiur ekg ye kinar ekg aklin tu ipma wrij a ark kinar Jutia pa. Tu melnum a ntie pa tu uk wailet, wa tu melnum a warkip pa, tu uk wasok. ");
INSERT INTO uri_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Yatom apm tu ak komkiti tol a tu la pake. Tu kor tita marpm kweiur kweiur pa plaln pa, tu kwa Parnapas ekg Sol pa ekg ye kweiur kweiur pa ye kinar uk tu melnum wail wail a ikghlen tu wrong kinkpman a ukpma Krais a atn kinar ha wail Jerusalem pa. ");
INSERT INTO uri_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ak wang pa Herot melnum tukgunakgen pa kil uk yangkipm tu melnum alkil a almpwrong pa yatom tu arkul tu wrong kin a kpman tiur a ukpma Krais pa ekg akal tu ukwen wleket. ");
INSERT INTO uri_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Herot kil la yatom tu ak painat alm Jems, wailen a Jon pa mo. ");
INSERT INTO uri_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herot kil ari tolpa tu Juta pa utopen ekg kil ak tolpa, pa wa kil la ekg tu arkul Pita pa yat. Ari wang wail a tu Juta klon nak tingklak a ak yis ak ntam pa, ");
INSERT INTO uri_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","tolpa yatom tu arkulel plaln pa, Herot la nasen yatom tu wiyel ye kahor arpm wan tipmning pa pen. Yatom tu eln kil kai wam a tu melnum a almpwrong alkilen a kil ro elntatn mapming witnweitn pa akal tu uk wang tita ekg atnen Pita pa arpm wan tipmning pake. Mapming wrij wrij pa melnum a almpwrong pa witnweitn. Herot akal atn nungkwangen wang a pike Maur Wailen kil wiyen kai tukulein Ijip pa kai plaln pa, kil wi Pita pa ye kulhor kai ekg ntekg yangkipm atn ikg a tu wrongwailet. ");
INSERT INTO uri_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Tu atnentel atn wan tipmning pa atn pa, tu wrong kinkpman a Krais pa nel ropon Maur Wailen pa titnongket ekg aklinjel. ");
INSERT INTO uri_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ak mning pa Pita kil hokga ha kuin a melnum wekg a almpwrong pa ha wan tipmning pa ha. Wam wompel ur akil pa pike tu kuten ak hmpei tiel ur pa kai namponen wam wompel ur a melnum ur, wa kuten wompel pa namponen wam a melnum ur. Wa tu wantengkwang pa tu atnen wanyun a wan tipmning pa atn yatom akal hikg pa Herot melnum tukgunakgen ye Pita pa kulhor kai atn ntekg yangkipm pa. ");
INSERT INTO uri_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Maur akwapel a Maur Wailen pa paln aktutu tolti atn won a Pita kahor wan tipmning pa. Yatom wakg a kil pa ak helen tunten a ark wan tiel wonen pa. Om kil eln wam kai yampinghik a kil pa om ak ro ikgyokgel la tolpa, “Pita, kitn ti wreitn iktutu om!” Yatom kil wreitn ari kalpm, hmpei a pike tu ak kuten wam akil pa apm nuhur tukulein wam a kil ase. ");
INSERT INTO uri_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Yatom maur akwapel pa la tolpa, “Kitn wi hmpei ti ik kwat hapm ti, wa kitn wi nepm palk alkitnen pa nowe!” Pita kil atning tolpa kil ntekg komkiti plaln pa, maur akwapel pa wa la nasel la tolpa, “Kitn nowe hapm ak naren num ekg wrokg ti, yatom kitn kul kutnuntopm!” ");
INSERT INTO uri_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Yatom Pita kil atning tolti, kil nuhurn wan tiel pa kulhor katnun maur akwapel pa. Ake kil ari tolpa, kuina ur a maur akwapel ntekg ti pa, pa aklahle pake, kil akwonalmpen tolpa, plpa kil ari kweiur tukol hokgwangket ti tolti. ");
INSERT INTO uri_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Om tuwekg kulhor nuhurn wanyun hep a tu melnum wantengkwang atnen atn pa, wa ekg hakahor pa kulhor wanyun kanukg pa plaln pa, wa ekg kulhor ngkom hore tolpa kai kahor atn yipmingki yun titnongket wail a atn hor hen ti a kapringen wan tipmning pa, ya a kai kahor paln ha wail tike. Yipmingki yun pa pike kli titnongket pa ari kalpm, kukwa elntha tolti. Tuwekg ngkom hor ya pa kai, ari kalpm, maur akwapel a Maur Wailen pa apm nuhurntel kai ase. ");
INSERT INTO uri_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pita kil atn akwonalmpen ari nikgwalpm akil pa nungkwat wokget om kil la tolpa kai kil alkil pa, “Ei, aklahle pa! Kupm ari pa, Wailen kil kwa maur akwapel akil pa nar wiyopm kai wam a Herot om ye kai tukulein nikgwalpm paitn a tu Juta akwonalmpen akal tu ntekgopm paitn.” ");
INSERT INTO uri_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nikgwalpm a kil a wet nir hmit ha pa nungkwat wonrekele wor plaln, om kil ngkom kai wan a Maria, man a Jon, nang wompel akil pa Mak. Kil kai atn wanyun pa atning ari tu wrongwailet paitn pa apm nel kor tita kul ark ropon Maur Wailen pa ark. ");
INSERT INTO uri_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita klpon wanyun ti atn kahor hen pa, yatom Rota, kin akwapel ur a atn wan pa kil atning tolpa, yatom kil wreitn kai akal kukwa wanyun pa. ");
INSERT INTO uri_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ari Rota kil atning ek meheng pa, yatom kil akwonalmpen tolpa, pa ek meheng a Pita, apm pake. Kil atning tolpa, kil utopen paitn tolti, om ake kil kukwa wanyun pa, kalpm. Kil wa pleln aktutu kahor tolti la nasi tu a ark kahor wan pa la tolpa, “Kipm pa, Pita apm kul ase, ti atn kahor wanyun hen atn ti!” ");
INSERT INTO uri_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ari tu pa la tolpa, “Rota, kitn ti hmit aki, yatom kitn la yangkipm pa!” Ari Rota kil la titnongket la tolpa, aklahle, yatom tu la tolpa, “Pa kitn atning maur akwapel a kil pa mol!” ");
INSERT INTO uri_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tu nel kor la tolpa ark, ari Pita pa apm klpon klpon wanyun pa tolpa atn kahor hen pa atn pake. Yatom tu hor kukwa wanyun pa om tu ari Pita pa atn, tolpa yatom tu wreitn paitn rkoln hmit ekg tu ariel. ");
INSERT INTO uri_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita ak wam kpor tu pa la tolpa, “Kipm elntmpei irk, ekg al kupm la nasepm yangkipm wor ur kil. Wet titnongket a Wailen wiyopm kahor wan tipmning pa ye kulhor. Ti al kipm la kiti yangkipm kil nasi Jems namponen tu mento a ukpma Krais pa!” Pita la nasen tolpa plaln pa, kil apm hor hen tolti apm kai ha ur ase. ");
INSERT INTO uri_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ak kang pa tu melnum a almpwrong tu wreitn ari Pita pa ari kalpm, yatom nel wreitn paitn kark wam itna ek tolti ropon kor la tolpa, “Woi, melnum ti kai hor tolhai?” ");
INSERT INTO uri_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Yatom Herot kil la nasi tu atn kor Pita pa. Yatom tu korel ari kalpm, ake tu hantilel. Tolpa om Herot kil wi tu wantengkwang pa kai atn om roponten nukwaren koren pa, om la nasi tu la tolpa al eren mo. Plaln pa, kil apm wreitn nuhurn ha knokg Jutia pa kaino arpm kaino ha wail Sisaria pa arpm pen. ");
INSERT INTO uri_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Melnum tukgunakgen Herot pa pike ipma wleket wrongken paitn ekg tu wrong kinkpman a ark ha wail Tair a ha wail Saiton pa. Tu kor tita kor tita kai wrij, yatom nel ak wail nar ari Herot pa. Tu nel nar ariel pati tolkil: tu apm wi ekpma kweiur kweiur pa nar ha knokg a Herot kil ikghlen pake. Tu nar paln plaln pa, hep pa tu kai armwonel Plastus, melnum wail ur a ikghlen wan a Herot melnum tukgunakgen pa. Ari Plastus pa kil wi wor, yatom yewen kai ari Herot pa ekg la nasel la tolpa, kil kwan ipma wleket akil pa wa kil reinjen. Ekg nte, ekpma kweiur kweiur tu apm wi nar ha knokg a Herot pa ikghlen pake. ");
INSERT INTO uri_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ak wang ur a Herot kil alkil alm pa, kil wi hapm a lukglukg alkil a melnum tukgunakgen pa nowe num tolti, kil kai wi wrik alkil a melnum tukgunakgen a arpme ekg ntekg yangkipm pa arpme arpm, yatom kil ekla nasi tu wrong kinkpman pa. ");
INSERT INTO uri_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tu wrong kinkpman pa nel atning a kil ekla pa tu kporn yangkipm, ekla pa wor pake, om nel la plalplal yikaktnen la tolpa, “Ek pa ake atning tol a melnum ekla pa, ek pa atning tol a mring maur ekla pa!” ");
INSERT INTO uri_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tu kat nang a kil tol a kat nang a Maur Wailen om kil wi wor. Ake kil kat nang a Maur Wailen, tolpa yatom maur akwapel a Maur Wailen pa erel aktutu tolti, pa kil wi numpet wail tolti wilm alel ipma pa tolpa kaingkai, om kil apm mo ase. ");
INSERT INTO uri_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pake yangkipm a Maur Wailen ti nip kaino hompen wail akwap titnongket hor pa hor pa. ");
INSERT INTO uri_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Parnapas ekg Sol tuwekg ye marpm a kweiur kweiur a tu kor tita pa ye kinar aklin tu kinar Jerusalem pa, plaln pa, tuwekg akal wa pleln no Antiok ti pa, tuwekg akwi Jon, nang wompel a kil pa kwe la tolpa Mak, om tunten wa no. ");
INSERT INTO uri_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Tu wrong kinkpman a ukpma Krais a ark Antiok pa, melnum tiur a tu pa paln tol melnum ek wripm a Maur Wailen, wa tiur pa wa ro tukgunakg lngkep a tu ekg yangkipm wor a Maur Wailen. Nang atu pa: Parnapas, Simion, nang wompel akil pa Niker, a Lusius a ha wail Sairini, a Sol, a Manain, kil pa klmik ur a melnum tukgunakgen Herot a pike tuwekg wreitn wor wail kompwrij atn hor wrij. ");
INSERT INTO uri_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ak wang ur a tu kalpm ekpma ekg uk wang Wailen wa tu kpor klko lein kat nang akil tolpa ark pa, Maur Wor a Maur Wailen pa la nasen la tolpa, “Kipm ikrkahantopm Parnapas ekg Sol pa ekg tuwekg al ak kwap a pike kupm kwewen ekg tuwekg ak pa.” ");
INSERT INTO uri_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tu kalpm ekpma ark uk wang ropon Maur Wailen pa plaln pa, tu eln wam helen ekg ropon Maur Wailen pa ekg aklinjen plaln pa, tu kwawen kai ekg akwap akil pa. ");
INSERT INTO uri_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Maur Wor pa kwawen ha pa om tuwekg wa kinar ha wail Selusia pa. Tuwekg kinar paln ha wail pa plaln pa, tuwekg wi wan hunokgen ha pa wa hor hunokg pa kinar Saiprus, ha knokg ur a ark kai hunokg kuin ai. ");
INSERT INTO uri_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tuwekg kinar paln kinar Salamis, ha wail a Saiprus pa, tuwekg piln yangkipm a Maur Wailen pa atn hor wan a tu Juta atning yangkipm a Maur Wailen atne pa. Jon Mak pa akntien atn ekg aklinjen. ");
INSERT INTO uri_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tuwekg kai akwap tolpa komkiti hor ha knokg a Saiprus pa, tolpa kinar paln kinar ha wail ur a tu kwe la tolpa Papos. Tuwekg hantil melnum Juta yar man ur, nang akil pa tu kwe la tolpa Par-Jisas. Wa kil la yangkipm akplain tolpa kil alkil ti kil melnum ek wripm ur. ");
INSERT INTO uri_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Melnum rikil pa kil nti melnum tukgunakgen a ikghlen ha knokg Saiprus pa arpm. Nang akil pa Serkius Paulus. Serkius Paulus pa kil melnum wonrekele wor. Kil ti kwe Parnapas ekg Sol pa kul ariel ekg la nasel yangkipm a Maur Wailen ti ekg kil akal atning. ");
INSERT INTO uri_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Par-Jisas, nang wompel a kil pa Elimas, yiprokgen a nang pa pati yar man. Elimas pa kil ak kwat kwap a Parnapas ekg Sol pa nti wailet ase, ekg ake al melnum tukgunakgen Serkius pa atning yangkipm a tuwekg piln pa yatom ukpma katnun Jisas pa. ");
INSERT INTO uri_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Yatom Sol, nang wompel akil pa Pol, Maur Wor akwap wail kai kil pa yatom kil ikgtnen Elimas pa titnongket, ");
INSERT INTO uri_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","wa kil la tolpa, “Kitn pa warim a Satan pake! Kitn pa wrongmnto ekg kweiur kweiur wrongwailet a nipet wor wrijen pa! Nikgwalpm wail a kitn ark ekg ya paitn wrongwailet a akplainel tu melnum tolti! Wa ake kitn elnten a ak lok ya nipet wor a Wailen pa kai raimpen aklei wang pa. ");
INSERT INTO uri_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ti kitn itning: Wailen kil akal ereitn ak wam alkil ai, kil akal ntekg ikg alkitnen ti kai mningket, yatom ake ntie ekg al kitn ak ari takgni pa nti ur.” Pol la tolpa pa, om aktutu kweiur tol weipmunu ti ye kul kai ak hmpri ikg a Elimas ti aktutu tolti. Om kil kai kor melnum ur kai pa kai pa akal ur wamparpmel ye hor ya ti kai. ");
INSERT INTO uri_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Melnum tukgunakgen pa kil ari kuina ur a paln kai Elimas pa, om kil ukpma pake. Kil wreitn paitn ekg kil ari titnongket a yangkipm wor a Wailen a tuwekg rowel tukgunakg lngkep pa. ");
INSERT INTO uri_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol namponen tu tiur a ntiel atn pa wi wan hunokgen ha ha wail Papos pa wa kai kaino ha wail Perka a ha knokg a Pampilia ai. Wa Jon Mak pa wa wreitn nuhurnten ha pa pleln kai kinar ha wail Jerusalem pa yawrik. ");
INSERT INTO uri_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Tu nuhurn ha wail Perka pa, ngkom kai kaino paln kaino ha wail Antiok a ha knokg a Pisitia ai. Tu paln kaino pa, yatom ak wang a arpm ekg yapm pa tu kai kahor wan a tu Juta atning yangkipm a Maur Wailen atne pa, om tu arpm. ");
INSERT INTO uri_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Melnum ur klein yangkipm titnongket a Moses a yangkipm a tu melnum ek wripm pa nasen plaln pa, tu melnum a ikghlen wan a atning yangkipm a Maur Wailen atne pa kwa melnum ur pa kinar la nasi Pol namponen tu a ntiel atn pa la tolpa, “Kipm melnum, kipm worwor wasokwasok a mento Juta ti, kipm akal la yangkipm ur ekg ak titnongketel ipma a tu wrong kinkpman ti pa, pa kipm la om!” ");
INSERT INTO uri_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Yatom Pol wreitn atn ak wam pa lok tu a ekla pa wa la nasen la tolpa: “Kipm mento alpmento a Israel pa, wa kipm melnum a ake Juta a arpm horhanekg ekg Maur Wailen pa, kipm eln nungkulkg pa hi ekg itning kuina ur al kupm la nasepm ti! ");
INSERT INTO uri_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Maur Wailen a mento wrong kinkpman a Israel ti pa kil akrkahan tu yo hmpei a walyaru a mento ti ekg alkilen. Ak wang a tu arpm kinar Ijip pa, Maur Wailen ntekg tu nungkwat wailet paitn ai. Kanukg pa Maur Wailen wiyen kulhor tukulein ha knokg ripa kulhor ak titnongket wailmanten a kil alkil ai. ");
INSERT INTO uri_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tu arpm kai wrik weij hngrapm kalpmel tol wring kmel wekg (40), tu ake atning nungkulkg Maur Wailen, pake Maur Wailen kil ikghlenten. ");
INSERT INTO uri_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Maur Wailen alm kwan wrong a ark ha knokg wampomit wampomwekg a ha knokg wail a Kenan pa hor hrak kai tukulein knokg ripa, yatom kil nampreng knokg ripa uk tu ti, om tu wi num atnen knokg pa tukol knokg alntuen om tu arke ark. ");
INSERT INTO uri_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tu yohmpei a mento pike kinar Ijip om ark kai Ijip, plaln, wa nuhurn Ijip pa wa kai arpm ha weij hngrapm kalpmel pa, plaln, om wa tu wi ha knokg Kenan kai wam a Maur Wailen pa, pa wring 450. Om Maur Wailen akrkahan melnum tukgunakgen ur ekg ikghlen tu Israel, tolpa kaingkai ngko wang a melnum ek wripm Samuel. ");
INSERT INTO uri_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Yatom ak wang pa, tu wrong kinkpman kwe Maur Wailen pa la tolpa kil kat melnum tukgunakgen wail ur ekg ikghlen ha wrongwailet a ha knokg Israel. Yatom Maur Wailen kat Sol, warim kpman a Kis. Kil pa hom wrij a Penjamin. Kil atn melnum tukgunakgen wail ikghlen tu pa tol wring kmel wekg (40). ");
INSERT INTO uri_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pake Maur Wailen wa kwan Sol pa wa kat Teipit pa wa wi wrik a Sol pa atn melnum tukgunakgen wail ekg ikghlenten. Kil ari Teipit pa wor, tolpa yatom kil kporn yangkipm a kil la tolpa, ‘Kupm ari Teipit warim kpman a Jesi pa, nikgwalpm wakrongen a kil pa tukol akupm. Tolpa om kupm wakrongentel paitn. Kil pa hi wa ak katnun komkiti nikgwalpm wrongwailet akupm pake.’ ");
INSERT INTO uri_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Maur Wailen pike yipon yangkipm ak ai om kil ak komkiti pake. Kil pike la tolpa, yohmpei ur kai hom a mapming a Teipit pa hi wa kil akrkahantel ekg akwi tu Israel pa ye kai ekg kil alkil. Apm Jisas pake. ");
INSERT INTO uri_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jisas kil numprampen akal kai atn ekg akwap akil pa, Jon kil piln yangkipm pa nasi tu wrong kinkpman a Israel pa la tolpa, tu laron paitnpaitn pa plaln om rein nasi Maur Wailen pa ekg akal kil kaluken. ");
INSERT INTO uri_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kwap a Jon kil ak pa, kil ak kai yampingken ekg al plaln yatom kil ropon tu wrong kinkpman pa la tolpa, ‘Kipm ari la tolpa kupm ti kupm melnum mla? Kupm melnum a kipm nungkwangen pake aki? Kipm itning, kupm ake melnum a Maur Wailen akrkahan ekg akwi mento Israel, pa kalpm. Pake melnum ur hi wa kul katnuntopm ti pa, kupm ti ake melnum wor ntie ekg hi wa nir hmpei arpm nepmpalk akil pa.’ ");
INSERT INTO uri_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Kipm yohmpei a Apraham, wa kipm a ake Juta a horhanekg ekg Maur Wailen pa, kipm wrongwailet pa wasokwail a kupm, kipm itning! Yangkipm a pike kipm atning la tolpa Maur Wailen akal akwio ye kai ekg alkilen ti pa, apm pike kil kwa kul ekg mento tike. ");
INSERT INTO uri_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tu wrong kinkpman a ha wail Jerusalem wa tu melnum tukgunakgen wail wail ake wa tu ari Jisas pa melnum a pike Maur Wailen akrkahan akal akwio pa. Ake wa tu akwonalmpen yangkipm a pike tu melnum ek wripm a Maur Wailen ro pa wa tu aklei wang klein klein ak wang a arpm ekg yapm pa. Tolpa yatom tu yipon yangkipm ekg alm melnum ripa mo, apm tu ak komkiti yangkipm a pike tu melnum ek wripm a Maur Wailen ro pake, apm paln ek arke apm tike. ");
INSERT INTO uri_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ake wa tu ari paitn ur a Jisas kil ntekg pa ekg akal tu almpel mo pa. Pake tu ropon Pailat ekg Pailat la ekg tu akal almpel mo. ");
INSERT INTO uri_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Yangkipm wrongwailet a tu melnum ek wripm pike ro ekg Jisas pa, apm tu ak komkiti tolpake, plaln pa, tu kwan palk a Jisas pa hakaino yo kwatingki pa ye nar tolti ye kai kahor elnthel tipmning teng wonen ai. ");
INSERT INTO uri_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pake Maur Wailen wa la yatom kil apm wa wreitn ha tipmning teng pa hor kai ase. ");
INSERT INTO uri_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Yatom ak wang wailet, tol wang kmel wekg (40) pa kil kai paln ngko wurknong nti wailet ekg tu melnum a pike katnuntel hakaino ha knokg Kalili ti kul nar ha wail Jerusalem pa ariel om. Yatom tu a pike ariel pa, tu pa laron yangkipm pa ak wang ti nasi tu wrong kinkpman pake. ");
INSERT INTO uri_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Mentekg la nasepm yangkipm wor wrijen: yangkipm wor a pike Maur Wailen kil yipon nti tu yohmpei amento ak ai akal hi wa kil ak pa. ");
INSERT INTO uri_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Pati Jisas pa apm wa wreitn ha tipmning teng pa kulhor mlepm arpm, pa apm kil akto komkiti tukol a pike kil yipon yangkipm akal hi kil ak pa ekg mento walyaru a tu yohmpei amento ti. Yangkipm pa kil ak komkiti tukol a ro hel kai wurkapm a Nangnang pa pati la tolpa, ‘Wet ti pa kupm plan kitn kai ikg a tu wrongwailet tol kitn warim kpman akupm wa kupm yan akitn pake.’ ");
INSERT INTO uri_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Maur Wailen la Jisas kil wreitn ha tipmning teng pa kulhor arpm, ti kil hi ake wa mo yawrik yatom eln kahor arpm tipmning teng pa kai mampij, pa kalpm. Apm tol a pike Maur Wailen la hep pake, la tolpa, ‘Kupm pa hi katnun yangkipm wri wor a kupm alkupm wa kupm ipma wor wailmanten ekg kipm om aklinjepm tukol kupm pike yipon yangkipm namponen Teipit.’ ");
INSERT INTO uri_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Apm yiprokgen ripa om, wa hel kai wurkapm a Maur Wailen pa yat la tolpa, ‘Kitn hi ake eln melnum wri wor alkitn a pike kitn akrkahan pa kai mampij kahor tipmning teng wonen pa, tolpa kalpm.’ ");
INSERT INTO uri_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Yangkipm pa ake la Teipit pa. Teipit pa arpm knokg ti pa, kil akwap ikghlen tu wrong kinkpman a ark ak wang ripa komkiti nikgwalpm wrongwailet a Maur Wailen kil wakrongen pa, tolpa kaingkai, kil mo. Yatom tu uwentel tol tu yohmpei mamikgmamin manjan alkilen a pike mo hep, pake palk akil pa apm pike ha mampij kahor kirkhap wonen pa ha pake. ");
INSERT INTO uri_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ari melnum ripa a pike Maur Wailen la yatom kil wreitn hakahor tipmning teng pa kulhor arpm pa, palk a kil pa ake ha mampij kahor tipmning teng pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Tolpa ti kipm worwor wasokwasok alkupm pa, kupm akal kipm wi arie yangkipm a kupm laron nasepm kil la tolpa: mento ukpma Jisas pa, Maur Wailen kwan paitnpaitn a mento pa. ");
INSERT INTO uri_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Wa yangkipm titnongket a Moses pa ake ntie ekg ak kwan paitnpaitn pa yatom ntekg melnum pa paln nipet wor kai ikg a Maur Wailen pa. Pake mla ur a ukpma Jisas pa, Maur Wailen kil kwan paitnpaitn akil pa kai plaln tukulein, om kil apm paln nipet wor ase. ");
INSERT INTO uri_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kipm irpm wonirpme! Ekg ake akal kuina ur a pike tu melnum ek wripm a Maur Wailen la pa wa paln kai kipm ti. ");
INSERT INTO uri_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Maur Wailen pike la kai ek a tu melnum ek wripm pa la tolpa, ‘Oi! Kipm melnum a aknokgel kupm Maur Wailen ti, kipm itning! Kipm hi wreitn paitn ari kalpm, kipm apm kai paitn ase! Kupm hi wa ntekg kweiur wail titnongket ak wang a kipm arpm knokg ti. Yatom tol melnum ur la kitintepm kuina ur a kupm hi wa ntekg pa, kipm hi ake ukpma pa!’ ” ");
INSERT INTO uri_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol kil piln yangkipm pa plaln pa, tuwekg nuhurn wan a wet tu atning yangkipm a Maur Wailen atne ti akal kulhor kai pa, tu wrong kinkpman pa wa roponten la tolpa, tuwekg wa kul piln yangkipm nti ur ak wang a tu arpm ekg yapm a hel kaino kwa pa, wa la nasen yangkipm ripa ekg tu akal wa atning yawrik. ");
INSERT INTO uri_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tu wrong kinkpman pa kulhor hen ti ekg hrak kaingkai pa, tu wailet a Juta a tu wailet a ake Juta a pleln kai katnun yangkipm a ya a tu Juta pa, nel nti Pol a Parnapas pa ngkom tolpa kai pa, tuwekg kat nikgwalpmel tu pa la nasen la tolpa, “Maur Wailen pa pike ipma wor wailmanten ekg kipm. Tolpa ti ake al kipm elnten, kipm ukpma kil pa itn titnongket tolpa itn om!” ");
INSERT INTO uri_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Wang wampomit wampomwrij pa kai plaln pa, ak wang a arpm ekg yapm pa tuwekg wa kul aklinjen ekg yangkipm a Wailen. Ari tukol wrong wailet a ark ha wail ripa kul plalnten ekg atning yangkipm a tuwekg laron pa. ");
INSERT INTO uri_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Tu Juta ari tu wrong wailet paitn kul atning yangkipm pa, om tu ipma paitn la paitnel aknokgel yangkipm a Pol piln pa. ");
INSERT INTO uri_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pake Pol ekg Parnapas tuwekg atn wrongken la nasen titnongket la tolpa, “Yangkipm a Maur Wailen ti pa al la nasi kipm Juta ti hep tike. Ari kipm talpuln yangkipm pa, wa kipm alkipm ti ntekg kipm alkipm ti ake ntie ekg wi Maur Wor a arpm wor aklei wang pa. Tolpa ti, kipm itning! Mentekg akal nuhurntepm, ye yangkipm wor ti ye kai laron nasi tu wrong kinkpman a ake Juta pa. ");
INSERT INTO uri_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ekg nte, pike Wailen la naso la tolpa al mentekg ak tolpa: ‘Kupm akrkahan kitn tukol wakg a hi akhelen tu a ake Juta. Hi wa kitn ro tukgunakg lngkep a tu ekg ya a hi wa Maur Wailen akwiyen ye kai ekg alkilen pa tolpa kai hor knokg wrongwailet ti plaln.’ ” ");
INSERT INTO uri_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tu a ake Juta pa tu atning yangkipm a Pol piln pa, yatom tu utopen ukwor yangkipm a Wailen pa. Yatom tu melnum a pike Maur Wailen akrkahan akal wi Maur Wor a Maur Wailen a arpm wor aklei wang pa, tu pa ukpma katnun yangkipm pake. ");
INSERT INTO uri_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Om tu ye yangkipm a Wailen pa ye kai nasi tu hor pa hor pa, om yangkipm ripa kai hompen wail kai ha knokg ripa. ");
INSERT INTO uri_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pake tu Juta pa wa uk nikgwalpm tu kin wail wail a nang itne a pike kai katnun ya a tu Juta wa arpm horhanekg a Maur Wailen pa, wa namponen tu melnum wail wail a atn hep a ha wail ripa, yatom tu pa uk yangkipm tu wrong kinkpman pa om tu pa uk wleket tuwekg pa la titnongket kwanten kulhor kai tukulein ha knokg a tu pa. ");
INSERT INTO uri_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tolpa om Pol ekg Parnapas pa ekg kwalkwin nepm mang yipur elntha pa ekg ak plan tu akal tol Maur Wailen ukwen wleket pa pati, pa apm paitn a tu alntu pake. Yatom tuwekg apm kai ha wail Aikoniam ai ase. ");
INSERT INTO uri_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pake Maur Wor pa akwap wail kai tu disaipel a Jisas pa, wa tu wi utopen wailmanten tolpa kai. ");
INSERT INTO uri_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kai ha wail Aikoniam pa Pol ekg Parnapas pa ak tukol a tuwekg ak pa: ekg kai kahor wan a tu Juta atning yangkipm a Maur Wailen atne pa, yatom tuwekg piln yangkipm. Tuwekg piln yangkipm namponen titnongket tolpa yatom tu wrong wail a Juta a Krik pa tu ukpma Jisas. ");
INSERT INTO uri_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pake tu tiur a Juta a ake ukpma Jisas pa tu kat nikgwalpm a tu wrong kinkpman a ake Juta pa yatom ntekg nikgwalpm a tu ti kai paitn om tu ipma paitn ekg tu a ukpma Jisas pa. ");
INSERT INTO uri_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pake Pol ekg Parnapas, tuwekg arpm wang watin arpm ha wail Aikoniam pa atn wrongken piln yangkipm pa atn. Yangkipm a tuwekg piln pa, tuwekg laron a Maur Wailen plan ipma wor ekg mento ti wa reinjo. Yatom Maur Wailen ukwen titnongket, om tuwekg ntekg kweiur kweiur weten weten, a plan klal wailwail ak titnongket a Maur Wailen a ake ntie ekg melnum ntekg. Kai ya ripa pa Maur Wailen ak titnongketel yangkipm a tuwekg piln pa, pa aklahle. ");
INSERT INTO uri_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ari tu wrong kinkpman a ha wail Aikoniam pa tu ro atn wekg. Yatom tiur pa nti tuwekg melnum yangkipm kuinen a Jisas pa, wa tiur pa kai nti tu Juta. ");
INSERT INTO uri_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Yatom tu melnum a ake Juta, wa tu Juta tu wreitn kai nti tu melnum tukgunakgen alntuen pa tu ark kor nikgwalpm akal ntekg tuwekg paitn ekg eren ak weij ekg tuwekg mo. ");
INSERT INTO uri_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ari tuwekg atning tolpa, yatom tuwekg wreitn kark kinar ha wail wekg a ha knokg Likonia, pa ha wail Listra a ha wail Terpe, namponen ha wasok tiur a ark yampingken ha wail wekg ripa. ");
INSERT INTO uri_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Yatom tuwekg piln yangkipm wor a la Krais pa atn hor ha a tuwekg kaie pa. ");
INSERT INTO uri_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Melnum nepm paitnen ur pa arpm kinar ha wail Listra pake. Nepm akil pa mo paitn ak wang a man rakuel ai pen, ti ake ntie ekg kil ngkom. ");
INSERT INTO uri_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Kil arpm atning yangkipm a Pol laron pa arpm, ari ikg a Pol pa apm kai wi melnum pa ase. Kil ari ipma a melnum pa ari, kil ukpma wail titnongket ekg kil akal paln wor. ");
INSERT INTO uri_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Yatom Pol la nasel ak ek wail la tolpa, “Wreitn itn kwa hntra nepm ti itn nipet!” Yatom melnum pa wreitn tpra atn hntra nepm pa, ari wor, apm kil ngkom kai ase. ");
INSERT INTO uri_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tu wrong kinkpman wailet pa tu ari Pol ntekg melnum pa wor, yatom tu la mainmain la ak ek hawen alntuen Likonia pa la tolpa, “Ti ake melnum pa, plpa maur wekg ur nar ekg mento ti wi wrik a melnum wekg ti a mento ari atn tike!” ");
INSERT INTO uri_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Tu kwe nangkel Parnapas pa la tolpa kil maur Sus. Wa Pol pa melnum a wi ek a tu ekg ekla, tolpa om tu kwe nang a kil pa maur Hermes. ");
INSERT INTO uri_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Wan yalming a maur Sus pa atn kinar ha yampingken pa. Melnum ipma krakgen a ikghlen wan yalming pa pati ye kau nongko a nakmlai kul atn yipmingki yun a kapringen ha wail pa. Kil namponen tu wrong kinkpman wakrongen akal al wor uk melnum yangkipm kuinen wekg a Krais pa. ");
INSERT INTO uri_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Melnum yangkipm kuinen wekg Parnapas ekg Pol atning ari kweiur kweiur a tu akal ntekg pa, yatom tuwekg hreten om ro hapm alntuwekgen pa tolti. Tuwekg aktutu kai atn kuin a tu pa, ekg la yikaktnen la tolpa, ");
INSERT INTO uri_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Oi! Kipm melnum ti! Kipm ntekg tolti ekg kuina? Elnten om! Mentekg ti apm melnum tike, mentekg apm tol kipm pake. Mentekg kul arpm ti piln yangkipm wor a la Krais ekg al kipm pleln wrijen nuhurn maur a ake ntie ekg aklinjepm pa, wa kipm kul ukpma katnun Maur Wailen aklahle a arpm aklei wang ti. Kil Maur Wailen a ntekg ktnong a knokg a hunokg a kweiur kweiur wrongwailet a atn hor ti. ");
INSERT INTO uri_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Aklahle, pike hep ak ai kulngkul kul pa kil eln tu kinkpman wrongwailet hor knokg ti pa kai atn ak nikgwalpm alntu pa wrij wrij tolti. ");
INSERT INTO uri_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pake ake kil lamtepm wrijen kuina ur a kil aktepm ekg ak plan kil alkil ti, kalpm. Kil ntekg nikgwalpm wor ekg kipm: kil ntekg hu ti wei, wa takgni ti hel, yatom ntekg kweiur kweiur ti paln ngko ek arke ak wang alkilen pa. Kil aklinjepm ekg ekpma a ntekg ipma a kipm pa arpm utopen wor.” ");
INSERT INTO uri_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Tuwekg akal loken titnongket tolpa, ari tu pa wa la titnongket ekg akal al wor uk tuwekg ti. Pake tuwekg wa akwap wail ekg lok tu pa tolpa kaingkai, tu elnten nikgwalpm ripa. ");
INSERT INTO uri_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ari tu Juta tiur a ha wail Antiok a ha wail Aikoniam pa tu kul nar Listra ti tolti, kwan nikgwalpm wor a tu wrong kinkpman pa, wa lok tu ye kul kai katnun yangkipm nikgwalpm wleket a tu ti. Yatom tu ak weij pa er Pol pa ngko kai mo ha, yatom tu rkolel ye kai tukulein ha pa. Tu akwonalmpen tolpa kil apm mo ase. ");
INSERT INTO uri_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ari tu disaipel a Jisas pa tu kai atn yampingken yeningkentel, yatom kil wreitn tolti, wa kahor ha pa. Kil hokga hor kang pa, kil nti Parnapas tuwekg wreitn nuhurn ha pa wa kinar ha wail Terpe. ");
INSERT INTO uri_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Tuwekg piln yangkipm wor a la Krais atn ha wail Terpe pa, yatom tu wrong kinkpman wailet atning yangkipm pa, tu pleln ipma om paln disaipel a Jisas. Plaln pa, wa tuwekg wa pleln kaino ha wail Listra, plaln wa wreitn ha pa wa kai kaino ha wail Aikoniam. Plaln pa, wa tuwekg wreitn ha pa wa kai kaino ha wail Antiok. ");
INSERT INTO uri_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Yatom tuwekg uk nikgwalpm wor tu disaipel a Jisas pa, wa tuwekg aken titnongket, akal tu ukpma Krais pa atn titnongket. Tuwekg la tolpa, “Mento akal kahor Kingdom a Maur Wailen pa, mento hi apm ye kalkut wailet tolpa kaingkai ngko wang a mento kaino arpm ekg wi yapm kaino Kingdom a Maur Wailen alkilen ai.” ");
INSERT INTO uri_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tuwekg ak titnongketel tu pa, plaln pa, wa tuwekg kat melnum tiur pa atn melnum wailen wailen ikghlen tu wrong kinkpman a ukpma Jisas a arpm hor ha wrij wrij pa. Wa tuwekg kalpm ekpma ekg uk wang ropon Wailen ekg uk tu a ukpma Jisas pa kai wam a Wailen ekg kil ikghlenten. ");
INSERT INTO uri_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Yatom tuwekg wreitn nuhurn ha wail Antiok pa om ngkom hor ha knokg Pisitia pa tolpa kai kinar paln kinar ha knokg Pampilia ai. ");
INSERT INTO uri_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Tuwekg kinar tolpa kinar paln kinar ha wail Perka. Tuwekg piln yangkipm atn ha pa, plaln pa, wa tuwekg wreitn ha pa wa kai kinar ha wail Atalia a ark yampingken hunokg. ");
INSERT INTO uri_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tuwekg wa wreitn wi wan hunokgen nuhurn ha wail Atalia pa wa kai ha wail Antiok a ark ha knokg Siria. Ha wail pa apm tu ipma wrij a pike kwawen ha pa kai laron yangkipm wor a la Krais pa kai pake. Apm tu a ha wail Antiok pake. Tu pike ropon Maur Wailen ekg akal kil ikghlenten aklinjen. Tuwekg atn akwap pa kai plaln, wa tuwekg wa kul Antiok yawrik. ");
INSERT INTO uri_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tuwekg kai paln kai ha wail Antiok ti pa, tuwekg wi tu wrong kinkpman a ukpma Krais pa kai ark wrij, wa la kiti nasen kweiur kweiur wailwail a Maur Wailen kil ntien atn ak pa, wa ya a pike a Maur Wailen akwap ekg kukwa wanyun ekg tu a ake Juta pa ukpma Jisas pa. ");
INSERT INTO uri_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Yatom tuwekg arpm pa wang watin nti tu disaipel a Jisas pa. ");
INSERT INTO uri_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tu melnum tiur hakinar Jutia pa tu no ark no Antiok ti, yatom tu ro tukgunakg lngkep a tu melnum ipma wrij a ukpma Krais pa la tolpa, “Kipm kwat numpalk komkiti yangkipm titnongket a pike Moses kil kaling plan pa pati, kipm hi Maur Wailen akwiyepm pa. Kalpm pa, hi kalpm.” ");
INSERT INTO uri_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol ekg Parnapas ake wi wor ekg nikgwalpm a tu la pa. Yatom tuwekg nti tu pa kle tita alilhakel tita ekg nikgwalpm ripa. Tu alilhakel tita tolpa atn, tolpa yatom tu akrkahan Pol a Parnapas pa namponen tunten melnum tiur pa akal ntien kinar Jerusalem ekg ari tu melnum yangkipm kuinen a Jisas, wa tu melnum wail wail a ikghlen kwap a Maur Wailen, ekg ak ropon yangkipm a tu alilhakel tita pa. ");
INSERT INTO uri_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Tu wrong kinkpman a ukpma Jisas pa kwa Pol ekg Parnapas namponen tunten pa ekg akal tu kinar Jerusalem pa. Tu wreitn kai kinar ha knokg Ponisia a Samaria pa, nar pa kai kinar pa, tu la nasi tu melnum ipma wrij a ukpma Jisas pa a tunten hantilen hor yaya pa kinar la tolpa, tu a ake Juta pa, tu pa yat tu a Maur Wailen yat, ekg nte tu pleln ipma ukpma Jisas. Tu atning yangkipm a tu la tolpa, yatom tu utopen paitn wrijen. ");
INSERT INTO uri_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Tu kinar paln kinar Jerusalem pa, tu wrong kinkpman a Maur Wailen a ark kinar Jerusalem, wa tu melnum yangkipm kuinen a Jisas, wa tu melnum wail wail a ikghlen kwap a Maur Wailen pa, tu ukwen wor utopenten paitn ekg tu kinar arien. Yatom tu a kinar arien pa la kitinten nasen kwap wrongwailet a Maur Wailen aklinjen ekg tu atn hor pa hor pa kai akwap aklin tu wrong kinkpman. ");
INSERT INTO uri_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ari tu Parasi tiur a pleln ipma ukpma Jisas pa wreitn atn la tolpa, tu a ake Juta pa al tu kwat numpalk, wa la karkurnten ekg al tu katnun yangkipm titnongket a Moses pa yat. ");
INSERT INTO uri_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Yatom tu melnum yangkipm kuinen a Jisas namponen tu melnum wail wail a ikghlen kwap a Maur Wailen, tu kai ark wrij ekg kor la nikgwalpm a wet tunten alilhakel tita pa ekg akal tu la tolhai. ");
INSERT INTO uri_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Tu ark la kiti yangkipmek watinet ketn ark hor pa kai pa, Pita kil wreitn atn la nasen la tolpa, “Kipm melnum ipma wrij a mento ukpma Jisas pa. Kipm ari, pike hep ak ai Maur Wailen akrkahan kupm ti kai kuin akipm ti akal hi kupm kai ekg laron yangkipm wor a la Krais ti nasi tu a ake Juta, ekg tu atning ekg tu pleln ipma. ");
INSERT INTO uri_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Maur Wailen kil ari nikgwalpm a kinkpman wrongwailet. Kil uk Maur Wor a kil pa kai tu pa hirhir tol a kil uk men Juta ti. Pa ak plan akal kil wi wor ekg tu pa yat. ");
INSERT INTO uri_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Kil ake ak tolhai ekg mento ti wa ak manet ekg tu manet tiur pa. Tu ukpma kil pa, yatom kil klak nikgwalpm atu pa paln wri wor ase, hirhir tukol mento tike. ");
INSERT INTO uri_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ari kipm wa tilpen alilhakel tita la tolpa, al tu a ake Juta a ukpma Jisas ti katnun yangkipm titnongket amento ti pa, tol wa kipm akal wa kat yo kalkut ur wa ukwen ekg tu ye hel mlem pa. Pike hep a tu mamikgmamin amento ai, wa mento alpmento ti pa, mento ake wa ntie ye kalkuten a katnun yangkipm titnongket pa yat. Kipm tilpen tu pa tolpa pa, pa kipm wa uktiel Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Mento ukpma tolpa, apm ipma rein wrij a Wailen Jisas pa akwiyo pake, tolpa om ipma rein wrij a kil akwi tu pa yat. Wa ake mento katnun yangkipm titnongket a Moses pa yatom kil akwiyo, pa kalpm.” ");
INSERT INTO uri_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tu wailet a kul ark pa, tu atning yangkipm a Pita la pa, tu elntmpei ark. Wa tu atning yangkipm a Parnapas ekg Pol ekg la kiti nasen kwap a pike tuwekg ak kai kuin a tu melnum a ake Juta pa ak titnongket a Maur Wailen ukwen pa, yatom plan klal a kweiur kweiur titnongket a melnum ake ntie ekg ntekg pa. ");
INSERT INTO uri_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Tuwekg la kiti nasen yangkipmek kweiur kweiur pa kai plaln pa, Jems kil wreitn atn la nasen la tolpa, “Kipm melnum ipma wrij a mento ukpma Jisas pa, kipm itning yangkipm a kupm la kil! ");
INSERT INTO uri_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon wet la kiti naso wang hep a pike Maur Wailen kil rein akwonalmpen tu a ake Juta pa ekg akal akwi tu mapming ur kai kuin a tu pa paln tukol mapming ur alkilen. ");
INSERT INTO uri_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Yangkipm a Saimon la kiti pa, apm kai hirhir tukol yangkipm a tu melnum ek wripm a Maur Wailen ro la hel kai wurkapm pake, ");
INSERT INTO uri_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Wailen kil la tolpa, “Tu walyipmri wapyipmri a Teipit pa tukol wan ur a pike tpor paitn ase. Hi kupm nar pa, hi wa kupm le wan a Teipit a pike tpor pa. Hi kupm wa le wan a pike tpor nar ha paitn pa wreitn atn kiti kiti tukol a pike hep pa. ");
INSERT INTO uri_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","Ekg hi wa tu wrong kinkpman manet ai a ake Juta pa tu plalnten hi kor Wailen pa, pa apm tu a pike kupm akrkahan ekg nang a kupm alkupm tike ekg akal tu paln tukol kinkpman alkupmen.” Yangkipm kil pa yangkipm a Wailen, pike kil la hep ak ai la ekg kweiur kweiur wrongwailet a hi paln.’ ” ");
INSERT INTO uri_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jems kil wa la tolpa, “Tu melnum ek wripm a Maur Wailen pa pike la tukol kupm wet la nasepm pa, tolpa yatom nikgwalpm a kupm kil pa apm kai tolpa, mento ake akal la titnongket ekg tu a ake Juta a pleln ipma pa katnun yangkipm titnongket plalnten amento pa. Mento ak tolpa pa, pa tukol mento ukwen kalkut wail ur ekg tu ye. ");
INSERT INTO uri_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Pake yangkipm titnongket wail yek aripm ur kil pa mento ro hel wurkapm la nasen ekg tu katnun pake. Yangkipm titnongket tukol: ake akal tu al ekpma a tu al wor uk mring maur, a mring, a kweiur kweiur tolpa, wa ake akal tu kli arkul tita, wa ake akal tu al walmpopm, a wlikgek ur a mo yatom walmpopm pa tupor kinar ark wonen pa. ");
INSERT INTO uri_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ekg nte, yangkipm titnongket a Moses pike tu klein hor ha wail wail ak ai kulngkul kul ngko ti, wa tu apm piln piln atn hor wan a tu kai ark atning yangkipm a Maur Wailen arke pa aklei wang a arpm ekg yapm pa.” ");
INSERT INTO uri_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tolpa ti tu melnum yangkipm kuinen a Jisas namponen tu melnum wail wail atn hep a tu pa, wa tu wrong kinkpman plalnten a ukpma Jisas pa, tu ark kor la akal akrkahan tu tiur alntu kai kuin a tu alntu pa ekg akal kwawen kaino Antiok namponen Pol ekg Parnapas. Yatom tu akrkahan Jutas, nang wompel akil pa Parsapas, ekg Sailas. Tuwekg melnum wekg ur a atn tukgunakgen ikghlen tu melnum ipma wrij a ukpma Jisas pa. ");
INSERT INTO uri_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Tu ro wurkapm ur pa, yatom ukwen ekg tunten ye kaino. Wurkapm a tu ro pa la tolpa, “Wurkapm kil pa men melnum yangkipm kuinen a Jisas, namponen tu melnum wail wail atn hep pa, pa men melnum ipma wrij akipm a mento ukpma Jisas, men rontepm wurkapm kil yatom ye kaino ekg kipm a ake Juta a ukpma Jisas ark kaino ha wail Antiok, ha knokg Siria a ha knokg Silisia. Men ukwepm wor. ");
INSERT INTO uri_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tol men arpm nar kil atning yangkipm ur a tu la kiti naso la tolpa, melnum tiur alpmenen tu pike kaino ariepm ukwepm yangkipm, yatom lok nikgwalpm a kipm pa kai atn pa atn pa yatom ukwepm kalkuten. Pake men ti ake kwawen kaino ekg akal tu ak tolpa, pa tu ak, ak nikgwalpm alntuen. ");
INSERT INTO uri_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Tolpa ti men kai ark wrij ipma wrij yipon yangkipm, yatom men akrkahan melnum tiur a wi ek a men ti, yatom men kwawen kaino ekg kipm namponen Pol ekg Parnapas melnum ipma wrij yek wekg amento ukpma Jisas a men wakrongen paitn. ");
INSERT INTO uri_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pol nti Parnapas, tuwekg melnum tolpake. Tuwekg ake wa kark ekg tu eren mo aki tuwekg ye kalkuten pa, tuwekg uk num alntuwekgen ti tolti kai ekg laron nang a Wailen alpmentoen Jisas Krais pa tolpa kai pake. ");
INSERT INTO uri_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Melnum wekg a men akrkahan pa Jutas ekg Sailas men kwa kainontepm namponen tuwekg pake. Tuwekg hi wa la nasepm ak ek ti katnun komkiti tol a men ro hel wurkapm ti. ");
INSERT INTO uri_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Maur Wor a Maur Wailen arpm namponen men ti, yatom men kai ipma wrij la tolpa, ake akal wa men ukwepm kalkuten ur, yatom ti men la ekg al kipm katnun yangkipm yek aripm ur tol a men rontepm hel kai wurkapm ti tolti. Men ari tolpa pati, pa wor ekg kipm pake, ampur elnten. ");
INSERT INTO uri_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ampur kipm al ekpma a al wor uk mring maur, a mring, a kweiur kweiur tolpa, wa ampur al walmpopm, aki wlikgek a tu wi ark hmpei yatom walmpopm a tupor kinar ark wonen pa, wa ake al kipm kli arkul tita pa. Tol kipm ngkom nlokgen kweiur kweiur ripa pati, pa wor wrijen ekg kipm pake. Apm pake, yangkipm a men ro ak la nasepm apm kai tolpake. Men ukwepm wor.” ");
INSERT INTO uri_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Tunten melnum witnweitn a tu kwawen kaino Antiok pa, tunten kaino paln, yatom tunten kwe tu wrong kinkpman a ukpma Jisas pa kul ark wrij, yatom tunten ukwen wurkapm ripa. ");
INSERT INTO uri_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tu wrong kinkpman tu klein wurkapm pa, yatom yangkipm a tu ro ak la nasen hel wurkapm pa ukwen titnongket a ipma kulkula utopen wor. ");
INSERT INTO uri_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jutas ekg Sailas pa, tuwekg pa wa melnum ek wripm a Maur Wailen pa yat pake. Tuwekg piln yangkipm wailet worwor, yatom aklin tu pa wailmanten paitn, wa ak titnongketel tu ekg tu ukpma atn titnongket. ");
INSERT INTO uri_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Tuwekg arpm kaino pa wang watin ketnketn, plaln pa, tu melnum ipma wrij a tu ukpma Jisas kaino pa, ukwen wor, yatom kwawen namponen ipma mehen wor ekg tuwekg wa kinar ekg tu melnum a pike kwawen kulno pa. ");
INSERT INTO uri_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ari Pol ekg Parnapas pa ekg arpm kaino Antiok pa arpm pa. Yatom tuwekg pa namponen tu melnum wailet tiur tu ro tukgunakg lngkep a tu, wa laron yangkipm a Wailen la nasen la tolpa kai. ");
INSERT INTO uri_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pol ekg Parnapas ekg arpm wang aripm ur kai plaln pa, Pol kil la nasi Parnapas pa la tolpa, “Mentekg wa kai yawrik atn ngkom ari tu melnum ipma wrij a mento ukpma Jisas pa hor ha a pike mentekg atn laron yangkipm a Wailen pa ekg ari tu ark tolhai.” ");
INSERT INTO uri_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Yatom Parnapas kil wakrongen tolpa akal kil wi Jon, nang wompel akil pa Mak, pa ekg akal ntien kai. ");
INSERT INTO uri_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ari Pol kil pa akwonalmpen la tolpa, pa ake wor ekg akal kil pa ntien atn pa. Ekg nte, kil pike hep pa kil pike nuhurnten atn kai ha knokg Pampilia, yatom ake pike ntien akwap atn pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Parnapas akal wi Jon pa, ari Pol pa la tolpa ake akal wi kil pa, tolpa yatom ekg kle tita tolpa kai, yatom ekg hrak kai atn manman. Yatom Parnapas kil wi Jon Mak apm ekg wi wan hunokgen kinar ha knokg Saiprus a ark kai hunokg kuin pa ase. ");
INSERT INTO uri_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Wa Pol kil akrkahan Sailas pa ekg kil ntiel atn. Tuwekg akal nuhurnten kai pa, tu melnum ipma wrij a tu ukpma Jisas pa kul ropon Wailen pa ekg kil ukwen ipma wor. ");
INSERT INTO uri_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Tuwekg ngkom hor ya ha knokg Siria, wa hor ya ha knokg Silisia pa atn hor pa kai pa, yatom Pol kil ak titnongketel tu wrong kinkpman a Maur Wailen a ark hor yaya pa kai. ");
INSERT INTO uri_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Sailas nti Pol ekg ngkom kai paln kai ha wail Terpe, plaln pa, wa tuwekg wreitn ha pa wa ekg kai paln kai ha wail Listra. Kai ha pa tuwekg ari disaipel wrij ur a Jisas apm arpm kai pake, nang a melnum pa Timoti. Wa man alkilen pa wa ukpma Jisas yat, kil kin a Juta, wa yan alkilen pa a ha knokg a Krik. ");
INSERT INTO uri_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tu melnum a ukpma Jisas ark kai ha wail Listra wa ha wail Aikoniam pa tu kporn yangkipm la tolpa Timoti pa kil melnum wor. ");
INSERT INTO uri_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol kil wakrongen tolpa Timoti pa akal ntiel kai, ari tu Juta wailet a ark kai ha knokg ripa, tu ari tolpa yan a Timoti pa a tu Krik a ake kwat numpalk pa. Tolpa yatom kil kwat numpalk a Timoti pa. ");
INSERT INTO uri_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Timoti pa wa kul kai nti Sailas ekg Pol tunten ngkom hor ha wail wail pa tolpa kai pa, tunten la nasi tu melnum a ukpma Jisas pa nasen kuina ur a pike tu melnum yangkipm kuinen a Krais namponen tu melnum wail wail a ikghlen kwap a Maur Wailen a ark kinar Jerusalem pa yipon ekg akal tu wrong kinkpman a ake Juta pa tu katnun yangkipm pa. ");
INSERT INTO uri_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tu wrong kinkpman a ukpma Jisas a ark hor ha a tunten atn laron yangkipm a Maur Wailen atne pa, tu ukpma titnongket, yatom aklei wang wrij wrij ti pa tu wrong a ukpma Wailen pa nip wail wail tolpa ye kai. ");
INSERT INTO uri_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Timoti, Sailas namponen Pol tunten akal kai atn hor kai ha knokg a Esia pa, ari Maur Wor a Maur Wailen loken ekg ake al tunten laron yangkipm kai Esia pa, yatom ake tunten kai. Tunten atn hor kaino ha knokg a Prikia a Kalesia tike. ");
INSERT INTO uri_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Yatom tunten wa hor pa kaino paln kai kirngkuwak a uk tita a ha knokg a Misia pa yatom tunten akal wa hor pa kai kaino ha knokg a Pitinia pa. Ari Maur Wor a Jisas pa loken ekg ake al tunten wa hor pa kai kaino pa. ");
INSERT INTO uri_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tolpa yatom tunten hor ha knokg a Misia, nuhurn Misia om kai ha wail Troas ti tolti. ");
INSERT INTO uri_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ak mning pa Maur Wailen plan Pol melnum ur a ha knokg a Masetonia pa kul atn ariel tol hokgwangket pa, yatom ropontel titnongket la tolpa, “Kitn wreitn yatom kai iklin men ti kai Masetonia ai!” ");
INSERT INTO uri_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol ari ripa, yatom aktutu tolti mento kor ya ekg akal kai Masetonia. Mento ari tolpa Maur Wailen kil kweo ekg mento kai yatom kai laron yangkipm wor a Krais pa nasi tu wrong kinkpman a ark kai pake. ");
INSERT INTO uri_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Mento wi wan hunokgen ha Troas pa yeo kaino yatom yeo haren horyawel tolti kaino Samotres, ha knokg ur a ark kai kuin a hunokg ai, mento hokga pa, hor kang pa, wa wiyo ha pa wa yeo kai ha wail Neapolis. ");
INSERT INTO uri_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Wa mento wreitn nuhurn ha wail Neapolis pa, wa mento ha pa kaino Pilipai, ha wail a pike tu Rom pa kul kat hep arke pake, ha wail pa ha wail atn hep ur a ha knokg a Masetonia. Yatom mento wa arpm pa wang aripm ur ai pen. ");
INSERT INTO uri_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ak wang a arpm ekg yapm pa, mento ha ha wail pa kulhor hen kai kop pa, ekg nte mento akwonalmpen tolpa, wrik a tu arke ekg ropon Maur Wailen pa apm ark kop yampingken ti ur tike. Om kai wrik a mento kai pa mento ari tu kin tiur apm wet kul ark wrij ark pake, yatom mento wa ntien arpm pa eklala. ");
INSERT INTO uri_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ti kin wrij ur a atning yangkipm a amento ti pa, nang akil pa Litia. Kil kin a armpen hapm watet ariworwor ekg ak wi marpm, kil kin a ha wail Taiataira. Kil kin a ake Juta pa, pake kil katnun ya a tu Juta wa arpm horhanekg a Maur Wailen. Yatom Wailen kil ntekg nikgwalpm a kin pa hompen wonrekele yatom kil atning wi alupm katnun ekla a Pol kil la pa. ");
INSERT INTO uri_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Yatom kil namponen tu alkilen a tu ark wan wrij pa tu kaluken, yatom kil kweo la tolpa mento kai wan alkilen. Kil la titnongket akal mento ntiel kai la tolpa, “Tol kipmten akwonalmpen tolpa kupm ti kin a ukpma Wailen ti pa, kipmten kul ekg mento kai, kipmten kai irpm wan a kupm ai, ntiopm irpm pen.” Tolpa yatom mento ntiel kai. ");
INSERT INTO uri_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ak wang wrij ur pa mento akal kai wrik a tu ropon Maur Wailen arke pa, yatom mento kai, hantil kin warimpen ur a akwap kalpmel horhanekg a melnum tiur pa, kul hantilo ngko ya pa, warim kin pa pati maur paitn ur akwap kahor ipma a kil pa, yatom kil pa ntie ekg la nasen kweiur kweiur a akal paln kanukg pa. Yatom tu melnum a kil horhanekg ekg tu pa tu wi marpm wailet kai kwap a kil ak pa. ");
INSERT INTO uri_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Yatom kin pa katnun Pol namponen mento ti tolpa kai pake, wa kil krkar kwe la tolpa itna wampel kai la tolpa, “Kipm pa, tunten melnum pa pati tunten melnum akwapel a Maur Wailen a atn hep hangken kweiur kweiur wrongwailet. Tunten pa la nasepm ya a Maur Wailen akwi mento ti ye kai ekg alkilen.” ");
INSERT INTO uri_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Wang wailet a tunten atn pa, warim kin pa apm katnunten hakg krkar kwewen tolpa atn pake. Tolpa yatom Pol numlpmahake paitn ekg wet kil atning a kil krkar hakg kwe tolpa atn ai, tolpa yatom kil pleln ariel tolti, kil la nasi maur paitn pa la tolpa, “Kai nang a Jisas Krais kupm la naseitn la tolpa kitn hor kai tukulein kin warimpen ripa!” Yatom maur paitn pa apm hor tukuleinjel ak wang ketn ripake. ");
INSERT INTO uri_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Yatom tu melnum a kin warimpen horhanekg ekg tu pa, tu ari tolpa ya yiprokgen a wi marpm kai kwap a kin warimpen pa ak pa, apm plaln ase. Tolpa yatom tu arkul Pol nti Sailas, rkolen yewen kai ekg tu tukgunakgen a ha kai ha kuin ur a tu wrongwailet kai arke pa. ");
INSERT INTO uri_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Yatom tu wiyen ye kai atn ikg a tu melnum a ark atning yangkipm pa, yatom tu la nasen la tolpa, “Melnum wekg ti pati tuwekg a tu Juta, tuwekg pa kmel a ntekg yangkipmek paitn ekg ak ntekg tu wrongwailet a ha wail amento ti ekg al kai paitn. ");
INSERT INTO uri_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wa tuwekg loko ekg akal kai ya a yangkipm titnongket amento Rom ti la tolpa ake akal mento katnun pa.” ");
INSERT INTO uri_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tu la nasen la tolpa plaln pa, tu wrong wail la ek hmpraken atn pa atn pa lawen la tolpa, pa tuwekg ntekg paitn. Wa tu melnum a ark atning yangkipm pa la nasi tu melnum pangklelek tiur pa la tolpa, tu nir hapm kai num a Pol ekg Sailas ti, om tu ak wanteng pa ak rkwawen. ");
INSERT INTO uri_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Tu rkwawen hrket paitn tolti, plaln pa, tu wiyen ye kahor arpm wan tipmning pa. Yatom tu melnum a arpm atning yangkipm pa uk yangkipm titnongket kai melnum wantengkwang a atnenten pa la tolpa, al kil atnenten worwor. ");
INSERT INTO uri_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kil atning a tu ukwel yangkipm titnongket tolpa, yatom kil wa wiyen ha pa, wa wiyen ye kahor arpm kahor wan wasikyek ur a atn kahor wonen ai. Yo wail wekg a pike tu kut ekg lang nepm kahore pa apm ha ase. Kil wiyen ye kahor tolti tuwekg arpm, wa kil wi yo wekg pa ak yipo nepm a tuwekg pa, om tuwekg katen yearpm pake. ");
INSERT INTO uri_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Yatom ak mning kuin kuin pa Pol ekg Sailas ekg ropon Maur Wailen, om ekg nangnang arpm. Yatom tu a ntien arpm wan tipmning pa, tu atning a tuwekg ak nangnang pa arpm. ");
INSERT INTO uri_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Yatom ake wa wampen, yelm pa no wailmanten aktutu tolti akal ak huwan wan ti yikaktnen tolti, a wanyun a wan wasikyikek wrongwailet a wan tipmning pa kukwa ekore plaln, wa hmpei mringet kalnten wrongwailet pa nuhur plaln tukulein tu melnum a arpm wan tipmning pa. ");
INSERT INTO uri_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Melnum wantengkwang a atnenten pa prpakg wreitn ari wanyun pa apm ekore plaln ase, yatom kil akwonalmpen tolpa tu melnum a arpm wan tipmning pa apm hor kark plaln ase, tolpa yatom kil nalu painat alkilen ti akal ak alm kil alkil ti mo. ");
INSERT INTO uri_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ari Pol kil plalaln la yikaktnen la tolpa, “Ai! Ampur alm kitn alkitn pa, elnten om! Men arpm plaln arpm ti, ake ur kark.” ");
INSERT INTO uri_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Yatom melnum wantengkwang pa kwe tu ekg tu ye wakg ur pa kul ekg akhlentel ekg kil aktutu kai kahor wan kuin a Pol ekg Sailas arpme pa, om kil ngko kwarkwar wonteipur ha won a nepm a Pol ekg Sailas pa. ");
INSERT INTO uri_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kil wreitn wiyen ye kahor hen ai, yatom kil roponten la tolpa, “Melnum Wailen wekg, al kupm ntekg tolhai ekg al Maur Wailen wiopm ekg alkilen pa?” ");
INSERT INTO uri_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ari tuwekg pa akalmpe la tolpa, “Kitn ukpma kai Wailen Jisas, ekg al kil akwiyeitn namponen tu alkitnen a kipm ark wan wrij pa.” ");
INSERT INTO uri_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Yatom tuwekg laron yangkipm a Wailen pa nasel namponen tu alkilen a ark kahor wan alkilen pa. ");
INSERT INTO uri_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Yatom ak mning kuinkuin pa melnum wantengkwang pa kaluk klaken hi a pike tu ak wanteng rkwawen pa, plaln pa, kil namponen tu alkilen pa tuwekg pa kaluken plalnten ak mning wrij pa tolti. ");
INSERT INTO uri_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Yatom melnum pa wi Pol ekg Sailas pa yewen kai wan alkilen pa ukwen ekpma pa tuwekg al arpm pa, kil namponen tu alkilen a ark wan wrij pa, tu plalnten ukpma Maur Wailen, tolpa yatom tu wi utopen wail. ");
INSERT INTO uri_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Hor ak kang pa tu melnum a ark atning yangkipm pa uk yangkipm tu melnum pangklelek pa ekg tu kai la nasi melnum wantengkwang pa ekg kil elnten melnum wekg pa kai. ");
INSERT INTO uri_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kil atning a tu melnum pangklelek pa kul nasel la tolpa, kil kai la nasi Pol pa la tolpa, “Tu melnum a ark atning yangkipm a tu melnum pa kwa yangkipm kul la nasopm la tolpa, kupm kul ekg akal eln kipmekg ti kahor hen pa, om kipmekg kai. Tolpa om kipmekg kahor hen pa om kipmekg kai! Kipmekg kai namponen ipma wor pa kai om!” ");
INSERT INTO uri_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ari Pol pa akalmpe ek a tu pangklelek a wet nasi wantengkwang kul la nasen pa la tolpa, “Pike kipm wiyo ye kai rkwao kalpmel tolti atn kai ikg a tu wrongwailet pa, ake pike kipm ntekg yangkipm ur ntio ari tolpa mentekg ntekg paitn ur. Mentekg ti pa, apm nang a mentekg hel namponen kipm Rom pake, tol ake tu ntekgo tolti. Ari kalpm, tu wiyo eln kahor arpm wan tipmning ti. Ti ak wang ti pa tu wa akal wa kwanto tital hampen tolti kai? Pa kalpm! Tol wa tu alntu ai kul kwanto ekg mentekg kahor hen ai.” ");
INSERT INTO uri_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Tu melnum pangklelek atning Pol kil la tolpa yatom, tu wa wi ekla a Pol kil la pa kai nasi tu melnum a ark atning yangkipm pa. Tu atning tolpa nang a Pol ekg Sailas pa, apm hel namponen tu Rom pake, tolpa yatom tu kark. ");
INSERT INTO uri_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Tu kai arien kai wan tipmning ai, tu reinjen akwiyen kulhor hen, yatom tu la nasen la tolpa, “Kipmekg nuhurn ha wail ti om kai om.” ");
INSERT INTO uri_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Tuwekg nuhurn wan tipmning pa kulhor hen tolti, tuwekg kai arpm kai wan a Litia. Tuwekg la yangkipmek worwor tiur pa ak titnongketel tu melnum ipma wrij alntuwekgen a tu ukpma Krais, a tuwekg ntien arpm pa. Plaln pa, wa tuwekg wreitn nuhurnten ha pa om tuwekg kai. ");
INSERT INTO uri_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol ekg Sailas tuwekg wreitn atn ha wail Pilipai pa akal kai ha wail Tesalonaika. Yatom tuwekg wreitn hor ya a ha wail Ampipolis pa kai kinar ha wail Apolonia pa yatom ekg kwat hor pa kai paln kai Tesalonaika. Wan ur a tu Juta kai atning yangkipm a Maur Wailen atne pa apm hel pake. ");
INSERT INTO uri_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pol kil kai ha ur pa, kil akal kahor wan a tu Juta atning yangkipm a Maur Wailen atne atn ha pa. Kil pa apm aklei wang apm ak tolpake. Tolpa om kil kai wli ha wail Tesalonaika, kil kai kahor wan a tu Juta atning yangkipm a Maur Wailen atne pa. Yatom ak wang a arpm ekg yapm pa, kil nti tu wrong kinkpman ark wan pa kor la yangkipm a Maur Wailen a hel kai wurkapm alkilen pa. Kil ak tolpa ak wang wraur a arpm ekg yapm pa. ");
INSERT INTO uri_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kil laron nasen yangkipm yiprokgen a Maur Wailen pa worwor planten la tolpa, Krais melnum a pike Maur Wailen kil akrkahan ekg hi akwi tu wrong kinkpman pa, kil pike ye kalkut om mo yatom wa wreitn komkiti nikgwalpm a Yan alkil pa. Yatom wa Pol la nasen la tolpa, “Jisas a kupm laron nasepm kil pa pati, apm Krais pake.” ");
INSERT INTO uri_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Tolpa yatom tu Juta tiur pa tu ukpma yangkipm a Pol kil la pa, pa aklahle, yatom tu kai katnun Pol ekg Sailas, wa namponen tu wrong kinkpman wailet a Krik a katnun ya a tu Juta wa arpm horhanekg a Maur Wailen pa, wa tu kin wailet a nang itne pa yat. ");
INSERT INTO uri_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pake tu wailet tiur a tu alntu Juta pa tu ipma paitn ekg tu wrong tiur kai katnun Pol ekg Sailas pa. Tolpa yatom tu nikgwalpm wrongken kai kor tita kor tu melnum ipma wleket lpmahaklang alntu a hop atn tolti kai ha kuin a tu kor tita arke pa, yatom tu kor tu wrong pa kul kor tita ark wrij yatom ukwen nikgwalpm paitn akal ntekg paitn ekg tuwekg pa, yatom tu ak wail nel kunturn aktutu kai tikale wanyun a melnum ur, nang a kil pa Jeson, wa kor Pol ekg Sailas pa akal wiyen ye kai uk kai wam a tu wrong kinkpman. ");
INSERT INTO uri_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ari ake wa tu hantilen. Yatom tu rkol wampel Jeson pa namponen tu melnum ipma wrij tiur a tu ukpma Krais pa yewen kai ekg tu melnum tukgunakgen a ikghlen ha wail pa. Yatom tu plalplal atn pa atn pa la tolpa, “Melnum wekg a rkol tu wrongwailet hor knokg ti ekg ntekg paitn pa, apm kulhor tolti atn tike. ");
INSERT INTO uri_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ti apm Jeson ti wiyen ye kahor ikghlenten arpm kahor wan alkilen tike. Wa tu plalnten, tu kat melnum manet ur ai, nang akil pa Jisas, la tolpa melnum tukgunakgen ur alntuen. Pa tu kpor yangkipm titnongket a melnum tukgunakgen alpmentoen Sisar a ikghlen ha knokg a men Rom ti ekg tu la tolpa.” ");
INSERT INTO uri_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tu wrong kinkpman a tu melnum tukgunakgen a ikghlen ha wail pa, tu atning yangkipm pa ari tukol hikyom ningkil ur a arken wleket om krkar tolpa yatom ake ntie ekg akal tu arpm mehen. ");
INSERT INTO uri_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Yatom tu melnum tukgunakgen a ikghlen ha wail pa tu la titnongket ekg akal Jeson namponen tu a ukpma Jisas a ark pa piln marpm pa, plaln pa, tu elnten Jeson namponen tu a ukpma Jisas pa kai. Tol wa kwei ur a tolpa paln kanukg pa, hi wa tu wi paitn. ");
INSERT INTO uri_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Yatom ak mning pa tu melnum ipma wrij a ukpma Jisas pa tu kwa Pol ekg Sailas pa kai ha wail Peria. Tuwekg kai paln pa, tuwekg kai kahor wan a tu Juta atning yangkipm a Maur Wailen atne pa. ");
INSERT INTO uri_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tu Juta a ark ha wail Peria ti pa tu nikgwalpm hompen wonrekele wor hangken tu Juta a ark kai ha Tesalonaika ai. Tu atning yangkipm a Pol laron nasen pa ari tu utopen paitn. Yatom tu ari klein wurkapm a Maur Wailen pa aklei wang wrij wrij, ekg ari katnun kuina ur a Pol kil laron nasen pa, pa aklahle aki kalpm e. ");
INSERT INTO uri_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Pol laron yangkipm pa tolpa kaingkai yatom wrong kinkpman wailet a tu Juta pa tu ukpma Jisas, wa namponen tu wrong kinkpman wail wail wailet a nang itne a tu Krik pa, tu wa ukpma yat. ");
INSERT INTO uri_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ari tu Juta a ark kai Tesalonaika pa tu wa atning a Pol laron yangkipm a Maur Wailen wa atn Peria ti. Tolpa yatom tu kul ha wail ti lok tu wrong kinkpman a ark kul ti ukwen yangkipm kalkut, yatom ak ntekg ipma a tu pa wakget paitn ekg tuwekg pa. ");
INSERT INTO uri_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tolpa yatom tu melnum ipma wrij a tu ukpma Jisas pa tu atning pa yatom tu aktutu kwa Pol pa ekg kil kark tukulein tu pa kinar hunokg yampingken ai. Pake Sailas ekg Timoti pa ekg yaten arpm Peria arpm ai pen. ");
INSERT INTO uri_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Wa tunten melnum a akye Pol kinar pa, tunten wa akyewel haren kinar paln kinar ha wail Atens ai. Tunten akal wa kulno pa, Pol ukwen yangkipm pa la tolpa, “Kipmten kaino paln pa, kipmten la nisi Sailas ekg Timoti pa la tolpa, ampur tuwekg arpm wampenet arpm kaino pa arpm, tuwekg kul narntopm iktutu!” ");
INSERT INTO uri_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ak wang a Pol kil arpm kinar ha wail Atens pa nungkwangen Sailas a Timoti a ntiel atn pa, kil atn ari klal a tu ntekg kalingken kweiur kweiur tiur a tu kpor klko lein pa wailet paitn ai atn ha wail Atens pa, yatom kil ipma kalkut wailmanten paitn. ");
INSERT INTO uri_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Tolpa yatom kil nti tu talpuln ekel tita atn kahor wan a tu Juta atning yangkipm a Maur Wailen atne pa, namponen tu Juta, wa namponen tu a ake Juta a katnun ya a tu Juta wa arpm horhanekg a Maur Wailen pa. Wa aklei wang wrij wrij pa kil wa kai ha kuin ur a tu kai kor tita arke pa, kil ari mla ur pa, kil ntiel ekla. ");
INSERT INTO uri_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Wa tu melnum arie tiur a tu kwewen la tolpa Epikurien a Stoik, tu klohitnel tita nti Pol pa. Yatom tu tiur pa la elukgentel la tolpa, “Arie hmpeinena arpm melnum a tolpa!” Ari tu tiur pa la tolpa, “Plpa kil akal laron mring maur a ha manet ur ai ukpma ai.” Tu la tolpa ekg tu atning a kil laron yangkipm wor a la Jisas, wa tu kmel a mo pa hi wa wreitn. ");
INSERT INTO uri_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Tolpa yatom tu wiyel ye kai atn ikg a tu melnum tukgunakgen a kul ark wrij kaino wrik nimlien ur a tu namput tolpa Areopakus pa, yatom tu ropontel la tolpa, “Men akal wi arie yangkipm weten ur a kitn ro tukgunakg lngkep a tu wrong kinkpman tolti. ");
INSERT INTO uri_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Yangkipm tiur a kitn la pa men atning ari wa manet kai nungkulkg a men ti, ti men akal atning ari worwor yiprokgen kuina ur a yangkipm ripa?” ");
INSERT INTO uri_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tu alntu a ha yiprokg a Atens pa, wa tu a ha manet tiur a kul ark Atens pa, tu aklei aklei wang pa akal atning nungkulkg arpme kor la kiti yangkipm weten weten kuina ur a tu atning pa. ");
INSERT INTO uri_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Yatom Pol kil wreitn kai atn kuin a tu melnum tukgunakgen a ha wrik nimlien Areopakus pa wa kil akalmpe la tolpa, “Kipm Atens! Kupm ari nikgwalpm a kipm pa ari ark wail akal kpor klko lein kweiur kweiur titnongket a ikghlentepm pa. ");
INSERT INTO uri_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ekg nte, kupm atn hor ha ti pa, kupm ari tpmakg a kipm eln kweiur kweiur a kipm kpor kilko lein atne pa wailet paitn ai. Wa kupm ari tpmakg ur pa ari, kipm ro tolpa, ‘Tpmakg kil pati tpmakg a Maur Wailen ur a ake men ari!’ Ti Maur Wailen a ake kipm ari kil pa, ari kipm kpor klko lein kalpmel kil pa, pa kupm akal laron Maur Wailen pa nasepm pake. ");
INSERT INTO uri_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Maur Wailen kil Maur Wailen a ntekg knokg a ntekg kweiur kweiur wrongwailet atne, kil Wailen a ktnong a knokg ti, kil ake arpm wan yalming a melnum le ak wam alntuen pa. ");
INSERT INTO uri_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Wa kil ake arpm warkip ekg kwei ur yatom melnum ur aklinjel pa. Kil alkil yiprokgen a uk wripm melnum a ntekg melnum arpm mlepm, wa kil uk kweiur kweiur wrongwailet pa kai ekg mento wrong kinkpman. ");
INSERT INTO uri_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ti Maur Wailen kil ntekg melnum wrij pa hep yatom melnum wrongwailet hor knokg ti apm paln hakai melnum wrij pa kul pake. Wa Maur Wailen kil alkil alm wang ekg mento melnum ntie ekg arpm kai ngko wang a kil alm pa, wa uk knokg ekg mento arke. ");
INSERT INTO uri_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Apm tolpa yatom Maur Wailen kil wakrongen tolpa akal mento kai ekg kil, ekg akal mento ari kil pa worwor, tolpa yatom kil eln mento pa arpm ekg akal mento korel. Kil ake arpm kai watin, kil apm ntio arpm tike. Kil arpm nti mento wrij wrij. ");
INSERT INTO uri_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ekg nte, mento melnum ti, mento arpm, wa mento atn pa, apm mento arpm kahor kil pake. Pa tol melnum arie ur alkipmen a ro wurkapm pa, apm wa la hirhir la tolpa, ‘Mento ti pa warim alkilen!’ ");
INSERT INTO uri_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ti tol tu lak mento warim a Maur Wailen pa, pa ake ntie ekg al mento akwonalmpen tolpa, Maur Wailen pa tol weij, aki weij muinmainet, aki weij ariwor tiur pa a melnum ak wam ntekg ari worwor pa, tolpa kalpm. ");
INSERT INTO uri_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Apm tolpa yatom pike hep ak ai kulngkul ak wang ti pa Maur Wailen kil ake ekla wailet ekg ye kalkut ekg paitnpaitn a tu melnum a hmit ntekg pa. Pake ak wang ti pa kil la titnongket nasi tu kinkpman wrongwailet hor pa hor pa ekg akal tu pleln ipma uk yirokg paitnpaitn a tu ntekg pa. ");
INSERT INTO uri_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ekg nte, kil apm pike alm wang ase, wang kuina ur hi wa kil wi tu wrong kinkpman a hor knokg ti kul ekg ntekg yangkipm. Wa kil komkiti nikgwalpm nipet wor alkilen pa tolti, hi ake ntie ekg melnum ur la tolhai ekg pa. Wa melnum a arpm atning yangkipm pa apm pike kil akrkahan ase. Melnum pa pike mo, yatom Maur Wailen la yatom wa kil wreitn ase. Pa Maur Wailen planto tolpa melnum pa apm hi kil ak tolpake.” ");
INSERT INTO uri_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Tu atning a Pol la nasen ekg tu a mo om wa wreitn pa, ari tu tiur pa la akhinowel kil pa, ari tu tiur pa la tolpa, “Pati men utopen akal wa wangkur pa wa kitn wa la niso pen kuina ur a wet kitn la pa.” ");
INSERT INTO uri_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pol kil la nasen tolpa plaln pa, kil nuhurn tu pa, om kil kai. ");
INSERT INTO uri_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Yatom tu melnum tiur pa kai katnun Pol wa tu ukpma Maur Wailen a kil laron pa. Tu melnum a katnuntel pa, nang a tiur pa tolpa, Tionisius kil pa melnum tukgunakgen ur a tu melnum tukgunakgen a Areopakus pa, wa namponen kin ur kwe la tolpa Tamaris wa namponen tu wailet tiur ai yat. ");
INSERT INTO uri_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ekla a Pol piln atn ha wail Atens pa plaln pa, Pol kil nuhurn ha wail Atens pa wa kai ha wail Korin. ");
INSERT INTO uri_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kil hantil melnum Juta ur kai ha wail pa, nang akil pa Akwila, ha yiprokg akil pa ha knokg Pontus a hel ha knokg wail a Esia. Melnum pa kil wreitn hakai ha knokg wail a Itali kul namponen kin alkilen Prisila. Pike Sisar Klotius, melnum tukgunakgen a Rom pa uk yangkipm titnongket ekg kwan tu Juta tukulein ha wail Rom pa kai ha ur manet, yatom pike tuwekg kul. Yatom Pol wa wreitn kai arien. ");
INSERT INTO uri_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Apm kil melnum a ak kwap wrij tukol tuwekg pake, kil kut palk a wlikgek ekg hi tu wa wi ak ntekg wan. Tolpa om Pol apm nti Akwila a Prisila arpm wan a tuwekg pake om kil ntien kut palk a wlikgek pa arpm pake. ");
INSERT INTO uri_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Yatom aklei wang a arpm ekg yapm pa kil kai wan a tu Juta atning yangkipm a Maur Wailen atne pa ukwen yangkipm ekg ak kat nikgwalpm a tu Juta a Krik ti ekg kul kai ukpma Jisas Krais ti. ");
INSERT INTO uri_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sailas ekg Timoti tuwekg nuhurn ha knokg Masetonia pa kul nar, Pol kil uk wang wrongwailet akil pa kai ekg laron yangkipm pa, ro tukgunakg lngkep a tu ariworwor nasi tu Juta pa la tolpa, Jisas pa, kil melnum a pike Maur Wailen kil akrkahan ekg akwio. ");
INSERT INTO uri_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pake tu Juta pa ake akal atning yangkipm a Pol la pa, wa tu la paitnel ekg kil pa, tolpa yatom kil kule yipik itna hapm pa, wa kil la nasen la tolpa, “Tol kipm kai paitn pa, pa ha kai kipm alkipm ha pa. Kupm ti pa kalpm. Ti ak wang ti ye hor pa kai pa kupm hi wa kai ekg tu a ake Juta pa.” ");
INSERT INTO uri_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kil la nasen tolpa plaln pa, kil nuhurn wan a tu atning yangkipm a Maur Wailen atne pa, wa kil kai kahor wan a Titius Jastus pa ntiel arpm pa. Melnum pa melnum wor a katnun ya a tu Juta wa arpm horhanekg a Maur Wailen. Wan a kil pa hel yampingken wan a tu atning yangkipm a Maur Wailen atne pa. ");
INSERT INTO uri_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Wa melnum tukgunakgen a wan a tu Juta atning yangkipm a Maur Wailen atne pa kil ukpma Wailen, nang akil pa Krispus. Kil nti tu kin warim alkilen pa tu ukpma Wailen. Yatom tu wailet a Korin pa tu atning yangkipm a Pol la pa, yatom tu ukpma Wailen, om wa tu kaluken kai nang a Jisas Krais. ");
INSERT INTO uri_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Wa mning wrij ur pa Pol kil ari kwei ur tol hokgwangket pa, yatom Wailen kil nasel la tolpa, “Ampur kitn kark. Kitn laron yangkipm pa ye tolpa kai om, ampur kitn wa kai elnten! ");
INSERT INTO uri_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kupm ntieitn arpm pa, wa ake ntie ekg al melnum ur almereitn pa, ekg nte kinkpman wailet akupm ti arpm kai ha wail ripa.” ");
INSERT INTO uri_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pol kil arpm Korin pa wring wrij wompel wa ro tukgunakg lngkep a tu wrong kinkpman ekg yangkipm a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pol akwap tolpa kai pa, wa tu kat Kalio pa wreitn atn melnum tukgunakgen a ikghlen ha knokg Akaia ti, yatom ak wang pa tu Juta kor tita ipma wrij om wreitn ipma wakget ekg Pol. Yatom tu wreitn plalnten wiyel ye kai atn ekg ntekg yangkipm, ");
INSERT INTO uri_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","yatom tu arkiel la tolpa, “Melnum kil ro tukgunakg lngkep a tu wrong kinkpman pa armpenwon akal wiyen ye kai kpor klko lein Maur Wailen hor ya ur manet a ake komkiti ya a yangkipm titnongket pa la pa.” ");
INSERT INTO uri_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol kil akal klo ek ekg akal akalmpe, ari Kalio kil la nasi tu Juta pa la tolpa, “Kipm Juta pa, tol melnum rikil ak kwat yangkipm titnongket ur aki ntekg paitn ekg kmel ur pati, pa tol al kupm ukwepm ipma wor arpm mehen atning yangkipm a kipm la pake. ");
INSERT INTO uri_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ari kipm no hangken tita akal kle tita ekg yangkipm a kipm alkipm ro tukgunakg lngkep ekg tita, a nang a melnum, a yangkipm titnongket ur alkipmen a Juta pa, tolpa ti kipm alkipm er lam yangkipm pa hi kai kipm alkipm pa om! Kupm ake akal arpm atning yangkipm a kipm ntekg tolpa.” ");
INSERT INTO uri_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Yatom kil kwan tu a wet akal ntekg yangkipm pa wa kaingkai. ");
INSERT INTO uri_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Yatom tu kmel wrongwailet arkul Sostenes pa, melnum tukgunakgen a ikghlen wan a tu Juta atning yangkipm a Maur Wailen atne pa, tu er atn yampingken wan a ntekg yangkipm atne pa. Kalio kil ari, kil elnten tolti, ake kil lok aki ntekg tolhai ur, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol kil arpm Korin pa wang aripm ur kai plaln pa, kil ukwor tu a ukpma Jisas ark pa, wa kil wreitn akwi Prisila ekg Akwila pa tunten ha pa kai ha wail Senkria pa akal wi wan hunokgen pa kinar ha knokg Siria ai. Tunten kai arpm Senkria pa, Pol kil u tukgunakg akil pa slaln arpm pa, katnun ekla ur akil a pike kil yipon namponen Maur Wailen pa, pa apm kul ngko wang pake, yatom kil u tukgunakg pa. ");
INSERT INTO uri_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Wa tunten wreitn wi wan hunokgen ha pa wa kai paln kai ha wail Epesus pa yatom Pol kil nuhurn Prisila ekg Akwila pa arpm pa, om wa kil alkil wrij pa kai kahor wan a tu Juta atning yangkipm a Maur Wailen atne pa, yatom kil eklala namponen tu Juta. ");
INSERT INTO uri_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Tu la nasel tolpa akal kil ntien arpm pen. Ari kil la nasen tolpa kil ake akal arpm, kil akal kai om. ");
INSERT INTO uri_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Kil ukwen wor plaln pa kil la nasen la tolpa, “Tol Maur Wailen kil wi wor pa, hi wa kupm wa kulntepm pa.” Kil la tolpa plaln pa, kil nuhurnten kai wi wan hunokgen pa nuhurn ha wail Epesus pa kil kinar. ");
INSERT INTO uri_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kil kinar paln kinar ha wail Sisaria yatom kil nuhurn wan hunokgen pa ark pa, yatom kil ngkom kinar ekg ari ukwor tu wrong kinkpman a ukpma Maur Wailen kinar ha wail Jerusalem pa plaln pa, kil wa no kai kaino ha wail Antiok. ");
INSERT INTO uri_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pol kil arpm Antiok pa wang aripm ur plaln pa, kil kaino atn hor ha knokg a Kalesia wa hor pa kai ha knokg a Prisia pa piln yangkipm a Maur Wailen pa ak titnongketel tu disaipel wrongwailet a Jisas pa. ");
INSERT INTO uri_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Pol kil kai atn piln yangkipm hor ha tiur ai pa, melnum ur a Juta pa, nang akil pa Apolos, pike man rakuel arpm kinar ha wail Aleksantria, melnum pa kil kul no Epesus. Kil melnum wonrekele ek yangkipmen wor, a la yangkipm yiprokgen a Maur Wailen worwor. ");
INSERT INTO uri_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Kil pike tu rowel tukgunakg lngkep ekg ya wor a Wailen, tolpa yatom kil nikgwalpm arke piln yangkipm wor pa namponen titnongket wail, wa kil rowen tukgunakg lngkep la nasen Jisas pa ariworwor. Pake kil ari tol a pike Jon kil kalukel pa tolti. ");
INSERT INTO uri_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Kil kai kahor wan a tu Juta atning yangkipm a Maur Wailen atne pa atn wrongken piln yangkipm tolpa, yatom Prisila ekg Akwila tuwekg arpm atning yangkipm a kil piln tolpa, yatom tuwekg wiyel ye kai wan alntuwekgen pa ekg la nasel a rowel tukgunakg lngkep ariworwor ekg ya a Maur Wailen pa ekg akal kil wi arie ariworwor. ");
INSERT INTO uri_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Yatom Apolos kil akal wa kai ha knokg a Akaia, yatom tu wrong kinkpman a Epesus a ukpma pa tu ukwel nikgwalpm ak titnongketel kil pa ekg kil kai. Wa tu ro wurkapm pa kai ak la nasi tu disaipel a Jisas kai pa akal tu wiyel ye kai ikghlentel ariworwor. Apolos kil kai paln kai pa, pa kil akwap wail aklin tu melnum a pike ipma wor a Maur Wailen akwiyen ye kul pa. ");
INSERT INTO uri_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kil wreitn atn kai kuin a tu wrong kinkpman wailet ak ek wail namponen titnongket akalmpe lok arku ekla a tu Juta. Wa kil wi yangkipm wurkapm a Maur Wailen ak planten ngko wurknong lak Jisas pa kil melnum a pike Maur Wailen akrkahan ekg akal akwi tu wrong kinkpman. ");
INSERT INTO uri_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ak wang a Apolos arpm kai Korin pa, Pol kil atn hor kaino wrik nimlien tolpa kaingkai kinar paln kinar ha wail Epesus ai. Kil kinar paln pa, kil hantil disaipel tiur a Jisas apm ark kinar pake. ");
INSERT INTO uri_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Yatom kil roponten la tolpa, “Pike kipm pleln ipma om ukpma pa, pike kipm wi Maur Wor pa aki kalpm e?” Ari tu akalmpentel la tolpa, “Kalpm, men pike ake atning hep ur a tu la Maur Wor pa, kalpm, atn atn apm kitn la naso apm tike.” ");
INSERT INTO uri_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Tolpa yatom Pol roponten la tolpa, “Ti tu kalukepm ekg yiprokgen kuina?” Ari tu akalmpe la tolpa, “Pike men pleln ipma yatom tu kaluko tukol a pike Jon kil kaluk tu pa.” ");
INSERT INTO uri_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ari Pol la tolpa, “Jon pa pike kaluk tu ekg ak plan tolpa, tu pleln ipma ase. Wa kil la nasi tu wrong kinkpman pa la tolpa, tu ukpma melnum ur a kul katnuntel pa. Apm Jisas apm pake.” ");
INSERT INTO uri_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Tu atning tolpa, om tu kaluken ak nang a Wailen Jisas. ");
INSERT INTO uri_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Tu kaluken plaln pa, Pol kil eln wam pa hel tu pa, om Maur Wor pa nar wiyen, yatom tu ak ek aur aur wa Maur Wor kat ekel tu pa yatom tu laron yangkipm a Maur Wailen pa tukol tu melnum ek wripm. ");
INSERT INTO uri_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Tu melnum a Maur Wor akwap kai tu pa tol tu melnum wampwam yikakwomwekg (12). ");
INSERT INTO uri_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pol kil kahor kulhor wan a tu Juta atning yangkipm a Maur Wailen atne pa tolpa aklei wang laron yangkipm a Maur Wailen pa titnongket nasi tu wrong kinkpman pa tolpa atn kainil wraur. Kil nti tu pa ak yangkipm alilhakel tita ekg Kingdom a Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ari ipma nikg a tu tiur pa kakren paitn wrijen, tu ake akal ukpma Maur Wailen pa, wa tu la paitnel akhinowel ya a Wailen kai ikg a tu wrong kinkpman wailet a ark pa. Tolpa yatom Pol kil wi tu disaipel a Jisas pa tu nuhurn wan a tu Juta atning yangkipm a Maur Wailen atne pa apm tu kai ase. Tu kahor wan wail a Tironus a tu ro tukgunakg lngkep a tu ekg kweiur kweiur atne pa. Yatom aklei wang wrij wrij pa Pol kil ro tukgunakg lngkep a tu ekg yangkipm a Maur Wailen atn wan ripake. ");
INSERT INTO uri_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Apm kil ak tolpa atn kai tol wring wekg, tolpa yatom tu wrong kinkpman a tu Juta a tu Krik a ark kai ha knokg a Esia pa, tu plalnten atning yangkipm a Wailen pa. ");
INSERT INTO uri_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Maur Wailen kil pike ntekg kweiur kweiur titnongket weten weten kai wam a Pol, tol melnum ake ntie ekg ntekg. ");
INSERT INTO uri_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Om tu wrong kinkpman tu ari pa tu wi hapm a ak kule hnjam pa wa hapm wompel a kil ning ak haur hapm wor a Pol pa, wa tu ye kai elnthel tu melnum a numpet pa, om numpet a tu pa paln wor, wa tu maur paitn pa kulhor kai tukuleinjen. ");
INSERT INTO uri_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Wa tu Juta tiur pa tu akwap tol yar meneng atn ha ur ha ur kwan maur paitn kai tu melnum pa, pa kwap ur a tu ak ak apm pake. Tu akal wa ye nang a Wailen Jisas ti wa ak kwan maur paitn tukulein tu melnum a maur paitn arpmen ti. Tu la yangkipmen la tolpa, “Kai nang a Jisas, melnum a Pol kil laron pa, kupm la tolpa ‘kitn hor kai tukulein!’ ” ");
INSERT INTO uri_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Tu warim kpman wampomit wampomwekg a Skewa, melnum ipma krakgen a Maur Wailen a atn hep a tu Juta pa, tu apm ak kwap a kwan maur paitn kai nang a Jisas pake. ");
INSERT INTO uri_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Yatom maur paitn pa akalmpenten la tolpa, “Kupm ari Jisas wa kupm ari Pol, pake kipm ti pa, kipm mla?” ");
INSERT INTO uri_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Yatom kmel a maur paitn arpme pa kil wreitn tpra kai tu om eren kai pa kai pa paitn tolti, hangkenten tolti, ukwen yongwalmpopm wail, wa ro hapm a tunten pa wa ten kark ha wan a kil pa kulhor hen tolti apm ten kark numhalk kai ase. ");
INSERT INTO uri_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Om yangkipm a kweiur kweiur a paln pa, kai paln wail wa tu Juta a tu Krik a ark kai Epesus pa tu atning plaln. Tolpa yatom tu pa kark paitn wrijen, om tu kat nang a Wailen Jisas pa ye kaino kwa. ");
INSERT INTO uri_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Tolpa yatom tu wailet a ukpma pa tu kul kai laron kweiur kweiur paitn alntuen a tu ntekg pa atn ikg a tu wrongwailet. ");
INSERT INTO uri_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Yatom tu wailet a ntekg kweiur kweiur tukol hngktong a yar pa, tu ye wurkapm alntuen a ukwen arie a ntekg hngktong a yar a kweiur kweiur a tu ntekg pa ye kulkai alung akentita atn wrij plaln pa, tu lap kai ikg a tu wrongwailet a atn pa. Om tu klein marpm a tu akarmpen wurkapm pa ari paln kmel kmel wailet paitn ai (50.000). ");
INSERT INTO uri_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tolpa om yangkipm a Wailen pa paln wailmanten ntie titnongket tolpa ye kai ye kai. ");
INSERT INTO uri_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Kwap pa paln titnongket atn Epesus pa, pa Maur Wor a Maur Wailen pa kat nikgwalpmel Pol pa akal kil kinar ha wail Jerusalem, pake akal kil wa kai kaino ha knokg Masetonia pa plaln pa, wa kai kinar ha knokg Akaia pa plaln pa, wa pleln ekg kai kinar ha wail Jerusalem pake. Kil wa la tolpa, “Kupm kinar paln arpm Jerusalem pa plaln pa, kupm wa kai atn ngkom ari ha wail Rom pa yat pake.” ");
INSERT INTO uri_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Yatom kil kwa aklin wekg alkilen pa, Timoti ekg Erastus pa, hep kaino Masetonia pa. Wa kil alkil Pol pa arpm wang watin ketnketn arpm ha knokg a Esia pa pen. ");
INSERT INTO uri_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ti ak wang ripa tu wailet ipma paitn ekg ya a Wailen om kat praraij la wailet kai wail ase ekg ya a Wailen. ");
INSERT INTO uri_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ti melnum ur, nang akil pa Temetrius, kil pa melnum a ntekg wan yalming wasikyikek ak weij muinmainet. Pa tu ntekg tol wan yalming a mring kin Artemis a tu kpor klko lein atn yalming pa. Ti kwap marpm a kil pa paln wailmanten, wa kil uk kwap tu melnum a akwap tolpa pa, tu yat wi marpm warim wailet. ");
INSERT INTO uri_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Yatom Temetrius kil kwe tu pa kul kai ark wrij namponen tu melnum a tu akwap wrij tol a tu ti ak pa, yatom kil la nasen la tolpa, “Kipm melnum pa, kipm ari pa, mento ti pa mento wi marpm wail wor kai kwap a mento ak ti. ");
INSERT INTO uri_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ti kipm alkipm atning a ari melnum Pol ti pa, kil alm nikgwalpmel a ak rkoln tu wrong kinkpman wailet paitn ai atn Epesus ti, wa yampingken ekg kil wa wi hor ha knokg a Esia ti. Kil la tolpa mring maur a melnum ntekg ak wam tolti pa, pa ake mring maur aklahle. ");
INSERT INTO uri_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ti yangkipm a Pol kil la tolpa pa ntie ekg uk nang paitn arku kwap wor amento, a mento ak ekg akwi marpm ti. Wa yangkipm a kil pa ntie ekg ntekg tu wrong kinkpman pa la paitnel akhinowel arku wan yalming wail a mring maur kin Artemis pa. Ti wrong kinkpman a hor ha knokg a Esia, wa hor knokg ti pa, tu kpor klko lein mring maur kin Artemis amento ti. Ari yangkipm a Pol pa ntie ekg wa uk nang paitn a arku nang wail titnongket akil pa!” ");
INSERT INTO uri_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Tu atning yangkipm pa, tu nikgwalpm wakget paitn la plalplal mainmain wli pa wli pa la tolpa, “Mring maur kin Artemis a men Epesus pa wailmanten atn hep pake!” ");
INSERT INTO uri_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Yatom tu wrong kinkpman plalnten a ark ha wail pa tu nikgwalpm paitn la plalplal nel ha pa ha pa kunturn aktutu kaingkai ark kai ha kuin a tu kor tita arke ekg ekla pa. Yatom tu arkul Kaias ekg Aristarkus, melnum wekg a Masetonia a nti Pol atn pa tu wiyen ye kai atn kai ha kuin pa. ");
INSERT INTO uri_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol kil akal kai kuin a tu kinkpman wrongwailet a ark kai ha kuin pa, ari tu disaipel a Jisas pa lokel ekg ake akal kil kai. ");
INSERT INTO uri_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Wa tu tiur melnum tukgunakgen, tu melnum wor alkilen, tu a ikghlen ha knokg Esia pa, tu pa wa kwa yangkipm kai ak lokel titnongket la tolpa, ake akal kil kai plan ikgek a kil alkil ti kai ha kuin a tu kor tita arke ekg ekla pa. ");
INSERT INTO uri_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tu wrong kinkpman a wet kai ark wrij ark pa, tu atn pa atn pa la plalplal mainmain la wli pa wli pa, ti tu wrongwailet paitn pa tu ake ari yiprokgen kuina ur a tu kul ark wrij ark ha kuin pa. ");
INSERT INTO uri_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Om tu Juta alm mayel Aleksanta pa kai kaino atn kaino ikg a tu wrongwailet ai, yatom tu ari pa om tu wonmit la tolpa, pa apm melnum a wet tu la wailet klewen tita apm pake. Yatom Aleksanta pa kil akal akalmpe ek a tu wrong kinkpman pa, om kil kat wam alkilen pa kaino kwa akal ak kpor tu pa ekg akal tu elntmpei ark. ");
INSERT INTO uri_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Tu ariel pa, tu ari tolpa, kil pa kil melnum Juta pake, tolpa yatom tu nel hmpraken eln ek pa atn wrij la yikaktnen lawen mring maur alntuen pa la wli pa wli pa la tolpa, “Mring maur kin Artemis a men Epesus pa wailmanten atn hep pake!” Tolpa atn wang watin, tol takgni wang wekg ur. ");
INSERT INTO uri_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ari kalpm, melnum wail a ha wail Epesus a wamparpme yotalpuk a ak ro wurkapm pa, kil kilkampen tu wrong kinkpman wailet a arpm pa elntmpei plaln pa kil la tolpa, “Kipm melnum a Epesus, tu wrongwailet a knokg ti pa tu ari tolpa apm ha wail Epesus ti pa yiprokgen a ikghlen wan yalming a mring maur Artemis pake. Wa apm wa kipm Epesus pa yan ekg ikghlen weij msanet a mring maur Artemis a pike ngko hakaino ktnong pa nar pake. Kipm alkipm ari pa, ti wa kipm wa la wailet ekg kuina ai? ");
INSERT INTO uri_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ake ntie ekg akal melnum ur lalo pa, tolpa ti kipm kai mehen, ampur kipm huren, om ntekg paitnel aktutu pa. ");
INSERT INTO uri_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kipm wet wi melnum wekg kil ye kul atn kil, pake tuwekg kil pa pike ake tuwekg akikgwampel kwei ur atn wan yalming a mring maur a mento atn ti, aki ake tuwekg la paitnel mring maur amento ti pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Tol Temetrius namponen tu melnum a tu ak kwap wrij ti pa tol tu ipma paitn ekg mla ur pa, pa wang ur alkilen a ntekg yangkipm pa, pa hi wa wiyen ye kai atn ntekg yangkipm aiyul. Wa tu melnum alkilen a arpm ekg atning yangkipm pa hi wa arpm atning pa, yatom hi wa akalmpe paitn a melnum ntekg pa. ");
INSERT INTO uri_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Tol yangkipm kalkut tiur akipm ha pa, kipm ye kai er lam ak wang alkilen a tu alm ekg tu kinkpman wrongwailet kai ekg ntekg yangkipm pa. ");
INSERT INTO uri_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Tolpa ti kipm itning, tol tu tukgunakgen a Rom tol tu atning kuina ur a wet mento ntekg ti pa, pa tu ntie ekg yeo kai atn yangkipm wa tu ntie ekg la tolpa, mento akal katen kalkut wailmanten kai ha wail ripa. Wa tol tu wa roponto la tolpa, mento wa kul atn wrij ekg yiprokgen kuina ur om la wailet kor tita tolti pa, ake yiprokgen wor ur ekg mento ntie ekg akalmpe.” ");
INSERT INTO uri_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Kil la nasen yangkipmek ripa plaln pa, pa ak kwan tu ekg wreitn kaingkai om. ");
INSERT INTO uri_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Melnum wail lok tu wrongwailet a plalplal mainmain wli pa wli pa naurkge pa, yatom tu hrak plaln pa, Pol kil kwe tu disaipel a Jisas pa kul kai ark wrij, yatom kil ukwen yangkipm ekg akal ak titnongketel ipma atu pa. Kil ak tolpa plaln pa, kil ukwen wor om wa kil wreitn nuhurnten akal kaino ha knokg a Masetonia ai. ");
INSERT INTO uri_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kil ngkom hor ya pa ekg kaino pa, kil uk yangkipmek tu wrong kinkpman ekg ak titnongketel ipma atu, tolpa kai ha ur ha ur a ark kaino ha knokg a Masetonia ai, wa kai kinar paln kinar ha knokg a Krik ai. ");
INSERT INTO uri_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Kil arpm pa kainil wraur plaln pa, kil wa numprampen ekg akal wa wi wan hunokgen pa ekg wa ha pa wa kinar kai ha knokg a Siria. Ari kil atning yangkipm a tu Juta yipon ekg akal almpel mo, tolpa yatom kil wa akwonalmpen tolpa kil wa pleln kaino ha knokg a Masetonia pa pen, plaln pa, kil akal wa ha pa wa kinar Siria pa. ");
INSERT INTO uri_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Yatom tu melnum a nti Pol pati nang atu pa pati kil: Sopater warim kpman a Pirus, kil melnum a ha wail Peria, wa Aristarkus namponen Sekuntus, tuwekg melnum a ha wail Tesalonaika, wa Kaius pa a ha wail Terpe, a Timoti, namponen melnum wekg a ha knokg Esia pa, Tikikus ekg Tropimus. ");
INSERT INTO uri_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Yatom tu melnum pa tu hepo kaino kai kinar arpmento arpm kinar ha wail Troas pa. ");
INSERT INTO uri_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Pake mento tiur a katnunten pa, mento arpm ha wail Pilipai pa arpm pa arpm, wang wail a tu Juta klon nak tingklak a ak yis ntam pa kai plaln pa, men wi wan hunokgen pa nuhurn ha wail Pilipai pa kai kinar om. Men hor hunokg pa wang wampomit, men kai kinar paln om hantil tu a hepo kinar arpmento kinar ha wail Troas pa. Yatom men ark ha ripa wang wampomit wampomwekg. ");
INSERT INTO uri_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Wang a arpm ekg yapm pa kai plaln pa, hor kang ti pa tu melnum a ukpma wa men ti men kul ark hor wrij ark ntekg ekpma pa al, kat nang a Maur Wailen pa tolpa ark. Pa Pol kil la kiti yangkipm a Maur Wailen pa nasi tu men wrong kinkpman pa. Kil akal wreitn nuhurnten ak kang pa, tolpa om kil laron nasen yangkipm pa tolpa kaingkai mning kuinkuin. ");
INSERT INTO uri_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Wan a men arke pa wlop wraur, yatom men ark kaino wlop wraur ai. Wakg wailet pa nihil elntarpm akhelen wan wonen a men arke pa. ");
INSERT INTO uri_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pol kil laron yangkipm pa rkol atn wang watin tolpa kai, ari melnum warimpen ur, nang akil pa Yutikus, kil arpm kwa a wanyun wasok pa. Kil ikgyokg alel paitn, yatom nikgwalpm akil pa nir kai hmit tolti, kil ngko arpm wanyun wasok a wan wlop wraur pa eln kinar knokg ai. Tu kinar katel, ari kil apm mo ase. ");
INSERT INTO uri_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ari Pol kil pa hakaino wan kwa pa nar knokg pa tolti, eln kai hokg hele arkul melnum warimpen pa, yatom kil la nasi tu pa la tolpa, “Ampur kipm ipma kalkut, nikgwalpm ha pa.” ");
INSERT INTO uri_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kil la nasen la tolpa plaln pa, kil wa pleln kaino wan kwa pa, ntien arpm al ekpma a eklala ekg kweiur kweiur ark kaingkai mning nungkwat, kang pa, wa kil nuhurnten kai. ");
INSERT INTO uri_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Wa melnum warimpen a wet ngko mo pa, apm wreitn arpm mlepm wor ase. Yatom ipma a tu pa kulkula wor, yatom tu akyewel kai om. ");
INSERT INTO uri_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Yatom Pol kil la nasi men a ntiel atn pa la tolpa, men al wi wan hunokgen pa kinar ha wail Asos pa, kil pa akal wa ngkom kwat hor ya knokg ti kinar tike. Om men wi wan hunokgen pa kai kapring kinar ha wail Asos pa ekg akal wa wi Pol kinar pake, katnun tol ek a pike kil alkil la pa. ");
INSERT INTO uri_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kil kinar hantilo, om men wiyel ak wan hunokgen ha pa tolti, apm men kinar ha wail Mitilini ase. ");
INSERT INTO uri_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Men wa nuhurn ha pa, wa men kinar kinar kai mning. Wa men ak mning mning kinar kinar kai nungkwat. Tolpa kinar ak nele ha knokg Kios a ark hunokg pa. Tolpa kai kinar mning ngko ya. Wa ak mning mning tolpa kinar kinar nungkwat, pa men kinar paln kinar ha wail Samos pa ark. Wa men wreitn ha pa, men kinar mning ngko ya. Wa men ak mning mning tolpa kinar kinar nungkwat pa, men kinar paln kinar ha wail Miletus pa. ");
INSERT INTO uri_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Men ake nar ark Epesus pa, kalpm. Men apm haren nar ha wail Miletus ase. Ekg nte, Pol hret ekg ake akal men ark ya ya a ha knokg Esia pa. Kil akal aktutu kai, ekg nte, tol kil ntie pa, kil akal arpm ekg wang wail a Pentikos atn kinar Jerusalem. ");
INSERT INTO uri_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Men arpm Miletus pa yatom Pol uk yangkipm tu pa kaino nasi tu melnum wail wail a ikghlen tu wrong kinkpman a ukpma Krais a ark kaino Epesus pa la tolpa tu al kul nar ariel. ");
INSERT INTO uri_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Tu kul nar paln ntiel arpm pa, kil la nasen la tolpa, “Kipm ari atn a arpm a kwap a kupm ak ak wang a pike kupm ntiepm ak hep wlimpien ai a kupm kul ha knokg Esia ti, wa aklei wang wrongwailet a pike kupm ntiepm arpm. ");
INSERT INTO uri_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Kupm arku kupm alkupm ti hor hanekg ak kwap a Wailen tolpa kai. Tu Juta yipon yangkipm hampen hampen akal almpopm eropm klewopm, tu ntekgopm tolpa, om kupm hakg ekg tu ukopm kalkut a wleket tolpa. ");
INSERT INTO uri_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Kipm ari pa, kupm pike ake ye num alkupm ti kark ekg laron nikgwalpm kuina ur a wor ekg aklinjepm pa, kalpm. Kupm pike laron wa rowepm tukgunakg lngkep kai wan ur wan ur. Wa kupm pike laron kai kuin a kipm wrongwailet atning pa. ");
INSERT INTO uri_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Kipm Juta a kipm Krik ti pa, kupm apm aklei wang la nasepm tolpa, al kipm kul ekg Maur Wailen, pleln ipma a ukpma Wailen Jisas Krais alpmentoen ti. ");
INSERT INTO uri_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Kipm itning, ak wang ti pa wa Maur Wor a Maur Wailen kil tilpentopm titnongket la tolpa, ekg kupm kai kinar Jerusalem. Ti kupm ake ntie ekg akal arpm, kupm akal kai kinar Jerusalem ai. Pake kupm ake ari kuina ur al hi palntopm atn kinar pa. ");
INSERT INTO uri_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kupm ari kwei ur wrij ur kil, aklei ha wail wail a kupm kai pa, Maur Wor a Maur Wailen la nasopm la tolpa, tu hi akal wiyopm ye kai arpm wan tipmning pa, wa uk kalkut a wleket ekg kupm ti. ");
INSERT INTO uri_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Pake kupm ake akwonalmpen kupm alkupm ti akal kupm arpm aki kupm mo e, pa kupm uk num alkupm ti tolti. Kupm akal tol wa aktutu kai ngko kirngkuwak a Wailen Jisas la pa, wa ak kwap a pike kil ukopm pa kai plaln pen. Kwap pa pati a laron yangkipm wor a la Maur Wailen kil ipma wor ekg mento ti. ");
INSERT INTO uri_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Wa kipm itning kil: kupm pike atn kuin a kipm om laron yangkipm a Kingdom a Maur Wailen pa la nasepm, hi ake wa wrij ur akipm pa ari ikgek akupm ti nti ur pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Yangkipm wrongwailet apm kupm la nasepm ak ai kulngkul, apm kai eln tolpake. Ti kupm la nasepm aklahle wrijen la tolpa, tol wrij ur akipm ti hi kai ha paitn pa, paitn pa apm ha kai kipm alkipm pake, kupm ti pa kalpm. ");
INSERT INTO uri_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nikgwalpm wrongwailet a Maur Wailen apm kupm laron nasepm kulngkul apm kai tolpake. Kupm pike ake wa ye num alkupm ti kark, yatom elnten ngko wang pa, kalpm. Kupm laron nasepm plaln ase. ");
INSERT INTO uri_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Tolpa ti kipm al ikghlen kipm alkipm ti ariworwor. Wa Maur Wor a Maur Wailen kil akrkahan kipm tike, ekg akal kipm ikghlen sipsip alkilen ti, ti kipm ikghlenten riworwor. Sipsip pa, pa tu wrong kinkpman alkilen a pike kil akarmpenten ak walmpopm alkilen. ");
INSERT INTO uri_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Kupm ari tolpa hi kupm nuhurntepm kai pa, hi nmpa tilipmingken wrongken kul kai kuin akipm pa. Om tu hi ake rein, hi ntekg paitnel ekg sipsip a kipm ikghlen pa. ");
INSERT INTO uri_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Hi wa tu melnum tiur a kipm alkipm ti hi wa akplain laron yangkipm ur manet ai, ekg ak lok tu disaipel a Jisas pa kai katnun tu pa. ");
INSERT INTO uri_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Tolpa ti kipm irpm wonirpme ukikg ri! Kipm ikwonilmpen wring wraur a pike kupm atn mning a hran akwap namponen ikghakg la karkurntepm wrij wrij pa. ");
INSERT INTO uri_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ti ak wang ti pa kupm eln kipm ti kai wam a Maur Wailen, ekg akal kipm akwonalmpen yangkipm wor a la Maur Wailen kil ukwepm ipma wor. Yangkipm wor pa ntie titnongket ekg ak titnongketel kipm pa, wa ukwepm kweiur kweiur wor wor a Maur Wailen kil numprampen akal uk mento wrong kinkpman wri wor alkilen pa. ");
INSERT INTO uri_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Kupm ti ake pike arikowe marpm aki hapmnung a kweiur kweiur wor wor a melnum ur pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kipm alkipm pike ari tolpa, kupm alkupm pike ak wam alkupmen ti aken kwap ekg aklin kupm alkupm ti, wa aklin tu melnum a ntiopm atn akwap ti yat. ");
INSERT INTO uri_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ti kipm ari kweiur kweiur wrongwailet a kupm ak pa pati, pa kupm ak ekg plantepm tolpa al kipm ak titnongket komkiti tolpa, ekg akal aklin mla ur a titnongket kalpmen pa. Wa la nasepm la tolpa kipm wonirpme yangkipm a pike Wailen Jisas la tolpa, ‘Kitn uk kweiur kweiur ekg aklin melnum ur pa, pa kitn wi utopen wailmanten hangken tol a melnum ur aklinjeitn ekg kweiur kweiur pa.’ ” ");
INSERT INTO uri_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pol kil la nasen yangkipm pa plaln pa, kil kpor klko lein, wa kil nti tu melnum wrongwailet a ark pa tu ropon Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Tu ropon Maur Wailen pa plaln pa, tu plalnten arkulel nakrontel hakgntel wailmanten. ");
INSERT INTO uri_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Tu ipma kalkut paitn wrijen ekg ekla ur a wet kil la nasen la tolpa, tu hi ake ariel ikgek nti ur. Om wa tu aklantel kai wan hunokgen pa. ");
INSERT INTO uri_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Men nuhurn tu Miletus, a tu melnum wail wail a Epesus tu ark Miletus ark pa, wa men wi wan hunokgen pa kinar, ekg akal hor pa kinar ha knokg Kos a hel hunokg pa. Wa men hokg ark pa, wa hor kang pa men wa wreitn ha pa, men wa kai kinar paln kinar ha knokg Rotes a hel hunokg pa. Wa men wreitn ha pa men kai ha wail Patara ase. ");
INSERT INTO uri_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kai ha wail Patara pa men wa ari wan hunokgen ur manet ekg akal kai kinar ha knokg Ponisia pa, yatom apm men wi wan hunokgen pa kai kinar pake. ");
INSERT INTO uri_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Men hor pa kai kinar pa, men ari ha knokg Saiprus pa hel hunokg pa. Men tolpa kaingkai kinar ak nele Saiprus pa hel wam wangkekg. Wa men apm wa haren horyawel nar pa kai kinar paln kinar ha wail Tair a hel ha knokg Siria pa, ekg tu nkle wrikya a arpm wan hunokgen a men arpme ti. ");
INSERT INTO uri_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kai ha pa men kai ari tu disaipel a Jisas pa yatom men ntien ark pa wang wampomit wampomwekg. Ari Maur Wor kil la nasen ekg kuina ur al paln ekg Pol atn kinar Jerusalem pa, yatom tu la nasi Pol pa la tolpa, “Ampur kitn wa kinar Jerusalem pa.” ");
INSERT INTO uri_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Men ntien ark pa kai plaln pa, men wa wreitn akal kai pa, tu ak wail wreitn ntio plalnten namponen tu kin a warim alntu pa, tu akyeo nuhurn ha wail pa kulhor kai ark hunokg hngrapm pa tolti, men kpor klko lein ropon Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Men kpor klko lein ropon Maur Wailen pa plaln pa, men kwa tita aklan tita tolti, men tpra kaino wan hunokgen ti kinar, wa tu pa pleln kai kahor wan ha alntuen pa. ");
INSERT INTO uri_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Men arpm wan hunokgen pa nuhurn ha wail Tair pa, kinar paln kinar ha wail Tolemes pa. Ya a men atn hor hunokg pa, apm kinar eln ngko ha wail Tolemes pake. Men kai ari tu ipmawrij a mento ukpma Krais pa, ntien ark pa wang wrij. ");
INSERT INTO uri_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Wa men hokg ark pa, wa hor kang ti pa, wa men wreitn ha pa men wa kinar paln kinar ha wail Sisaria. Yatom men kai ari Pilip, melnum wrij ur a tu wampomit wampomwekg (7) a pike tu akrkahan atn kinar Jerusalem ekg akwap a aklin tu melnum a arpm warkip. Wa kil melnum a laron yangkipm a Maur Wailen worwor. Yatom apm men ntiel ark wan akil pake. ");
INSERT INTO uri_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ti Pilip pa warim kin witnweitn (4), tunten ake wi kpman ur pen. Tunten laron yangkipm a Maur Wailen tol tu melnum ek wripm pa. ");
INSERT INTO uri_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Men ntien ark pa wang aripm ur pa, melnum ek wripm ur a Maur Wailen, nang akil pa kwe la tolpa Akapus, kil ha kinar ha knokg Jutia pa kul no ario no ha wail Sisaria pa. ");
INSERT INTO uri_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Kil no ario yatom kil nelkgen hmpei a Pol a ak kwat hapm pa, om kil kuten nepm wam a kil alkil pa, om kil la tolpa, “Maur Wor a Maur Wailen kil la tolpa, hi wa tu Juta kuten melnum yan a hmpei kil atn kinar Jerusalem pa tol a kupm ak kuten kupm alkupm ti, yatom uk kil kai wam a tu a ake Juta pa.” ");
INSERT INTO uri_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Men atning yangkipm a Akapus la tolpa, yatom men ti namponen tu alntu a ark pa men lok Pol pa la tolpa, ake al kil kinar Jerusalem pa. ");
INSERT INTO uri_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ari Pol kil akalmpe la tolpa, “Kipm wa hakg tolpa lokopm ekg nte? Kipm wa hakg ntekg tolpa ti kipm kungku nikgwalpm akupm ti! Kupm numprampen tolti ekg tu akal kutentopm om wiopm ye kai arpm wan tipmning pa, kupm numprampen yat ekg akal mo kinar Jerusalem ekg nang a Wailen Jisas pake.” ");
INSERT INTO uri_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Men lokel ari kil alkil titnongket akal kinar, tolpa yatom men wa wi nikgwalpm alkilen wor wa la tolpa, “Kuina ur a Maur Wailen lak al paln pa, pa kil paln tolti!” ");
INSERT INTO uri_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Men ark wang aripm ur ark ha wail Sisaria pa kai plaln pa, men numprampen wrikya kweiur kweiur pa alupm plaln pa, men kinar Jerusalem pa om. ");
INSERT INTO uri_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Yatom tu disaipel tiur a Jisas a ark Sisaria pa, tu wa wreitn akyeo kinar wrik ur a men akal hokg arke pa. Pa wrik wan ha a melnum ur, nang alkilen pa Nason. Kil pa melnum ur a Saiprus, wa kil pe hep ak ai pa kil pe disaipel a Jisas. ");
INSERT INTO uri_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Men hokg ark pa hor kang pa, wa men wreitn ha pa, wa men kinar paln kinar Jerusalem pa. Tu ipma wrij a mento ukpma Jisas a ark kinar pa, tu utopento uko wor wailmanten paitn ai. ");
INSERT INTO uri_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Yatom men hokg ark pa, hor kang pa, men nti Pol men kai ari Jems. Wa tu melnum wail wail a ikghlen tu wrong kinkpman a ukpma Jisas pa wa wli ntio ark wrij ak wang pa. ");
INSERT INTO uri_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Men ark pa, Pol kil ukwor tu pa plaln pa, kil la kiti nasen kweiur kweiur wrongwailet a Maur Wailen kil akwap wail ak wang a kil atn akwap aklin tu a ake Juta pa. ");
INSERT INTO uri_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Tu atning kuina ur a Pol kil la kiti nasen pa, yatom tu kat nang a Maur Wailen. Yatom tu la nasi Pol pa la tolpa, “Kitn melnum ipma wrij a mento ukpma Jisas pa, kitn ari pa, tu wrong kinkpman wailet paitn a mento Juta pa, tu ukpma Jisas, pake tu plalnten tu wa la titnongket akal wa nampil yangkipm titnongket amento Juta pa katnun komkiti yekworwor. ");
INSERT INTO uri_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ari tu a pike atning yangkipm a kitn laron pa, tu pa wa pleln yangkipm a kitn pa la nasi tu ti la tolpa, pike kitn ro tukgunakg lngkep a tu Juta wrongwailet a ark hor ha a tu a ake Juta pa la tolpa, tu uk yirokg yangkipm titnongket a Moses uk mento Juta pa. Wa tu pleln la tolpa kitn pike loken la tolpa, ake al tu kwat numpalk a tu warim kpman pa, aki katnun atn a arpm a klon a mento Juta ti. ");
INSERT INTO uri_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ti tu wrongwailet akal atning tolpa kitn apm nar paln ase. Tolpa ti al men ntekg tolhai? ");
INSERT INTO uri_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ti kitn ntekg komkiti kuina ur a men la naseitn akal kitn ntekg pa: melnum witnweitn a ntio arpm kil pa pati, tunten pike yipon yangkipm ur namponen Maur Wailen, yatom tunten ak komkiti. ");
INSERT INTO uri_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Tolpa ti al kitn wi tunten melnum kil, yatom kipmten kai komkiti ya a paln wri wor kai ikg a Maur Wailen pa tukol yangkipm titnongket a Moses la pa. Ti kitn al armpen kweiur kweiur a tunten melnum witnweitn akal al wor uk Maur Wailen pa, ekg al tunten u tukgunakg alntunten pa. Kitn ak komkiti tol a men la kil pa, ekg al tu wrongwailet ari tolpa, yangkipm a tu ye ekg kitn pa, pa ake yangkipm aklahle, ekg al tu ari tolpa, kitn katnun yangkipm titnongket amento Juta pa katnun atn pa. ");
INSERT INTO uri_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Pake tu a ake Juta a ukpma Jisas pa pati, men pike ronten wurkapm pa kai ak la nasen la tolpa, tu al katnun yangkipm titnongket witnweitn kil tolti: ake al tu al ekpma ur a tu al wor uk mring maur aki mring ur, wa ake al tu al walmpopm, aki wlikgek ur a walmpopm a tupor kahor arpm wonen pa, wa tu ti al atn watin tukulein kli arkul tita pa.” ");
INSERT INTO uri_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Tolpa om Pol kil wi tunten melnum witnweitn pa, hor kang pa, Pol kil nti tunten pa kai komkiti ya a paln wri wor kai ikg a Maur Wailen pa. Om kil kai kahor yipmingki wonen a wan yalming a Maur Wailen pa, nasi tu melnum ipma krakgen a ikghlen wan yalming pa, ak wang hai tunten akal paln wri wor, wa tunten hi ye kweiur kweiur pa nar num atunten wrij wrij pa ye kai ekg al wor uk Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Wang wampomit wampomwekg a pike tunten alm akal arpm pa, yampingken ekg al kai plaln pake, tu Juta tiur a ha knokg Esia a nar ark Jerusalem ti pa, tu ari Pol pa atn kahor yipmingki wonen a wan yalming a Maur Wailen pa, yatom kat nikgwalpmel tu wrongwailet paitn pa tu ipma wakget, yatom tu kunturn ak wail kul kai arkul Pol pa. ");
INSERT INTO uri_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Yatom tu la yikaktnen la tolpa, “Kipm melnum a Israel ti, kipm iklinjo! Melnum ti pa kil melnum a pike ro tukgunakg lngkep a tu melnum wailet hor ai, wa arku nang a tu wrong kinkpman amento, wa namponen yangkipm titnongket amento Juta, wa wan yalming a Maur Wailen ti. Wa kil ake wa akwap tolpa wrij, kil wa wi tunten melnum a ake Juta, a ha knokg Krik ti, tunten wa hor wan yalming ti ak kimpilpel wrik wri wor ti.” ");
INSERT INTO uri_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Yiprokgen a tu arki Pol pati, tu pike ari Tropimus a ha wail Epesus pa nti Pol atn ha wail Jerusalem ti, yatom tu akwonalmpen la tolpa, Pol kil wet akwi melnum a ake Juta Tropimus pa ye hor yipmingki wonen a wan yalming a Maur Wailen ti. ");
INSERT INTO uri_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tu wrongwailet a ark ha wail pa, tu atning lkowet wail pa, yatom tu hor ngko ha pa ha pa wli. Tu lape arkul Pol ti rkol wampel rkol ye kai kahor hen ai tukulein yipmingki wonen a wan yalming a Maur Wailen pa. Pa tu lok wanyun pa kul kai kli aktutu. ");
INSERT INTO uri_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Tu ntekg akal alm Pol pa mo pa, yangkipm pa kai wi melnum a atn hep ekg ikghlen tu a almpwrong a tu Rom pa. Yatom kil atning yangkipm a tu la tolpa, tu wrongwailet a Jerusalem pa tu ntekg nikgwalpm paitn atn tolti, yampingken ekg al er tita tike. ");
INSERT INTO uri_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Yatom aktutu tolti melnum a atn hep ekg almpwrong pa kil wi tu tiur alkilen a kul rkentel pa namponen tu tiur a almpwrong pa, tu aktutu kai kinar kai ari tu wailet a atn pa. Yatom tu wrongwailet a ha pa tu ari melnum a atn hep ekg almpwrong pa kil kul namponen tu alkil a almpwrong pa, yatom tu elnten a er Pol pa. ");
INSERT INTO uri_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Yatom melnum a atn hep ekg tu almpwrong pa kil kul tolti, kil wamparpme Pol pa, wa kil la nasi tu alkilen pa la tolpa, tu kuten Pol ak hmpei wekg. Yatom kil ropon tu wrong pa la tolpa, “Kil ti kil melnum mla, wa kil ntekg kuina ur?” ");
INSERT INTO uri_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ari tu plalplal atn pa atn pa la akalmpe tita la wli pa wli pa, yatom melnum atn hep pa ake kil atning nungkulkg arpme ariworwor kuina ur a paitn a kil ntekg pa. Tolpa yatom kil la nasi tu melnum alkil a almpwrong pa la tolpa, tu wiyel ye kai kaino wrik a tu melnum a almpwrong atne ai pen. ");
INSERT INTO uri_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Tu wiyel ye kai kaino ngko leta a ngkom kaino wan alntuen pa, ari tu melnum a almpwrong pa tu ari tu wrong kinkpman pa ipma wakget paitn akal erel mo, tolpa yatom tu katel akal ye kaino wan kwa ai. ");
INSERT INTO uri_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Tu wrong kinkpman pa kunturn arkenten katnunten kaino akal hmpraken kaino la tolpa, “Er melnum pa mo om!” ");
INSERT INTO uri_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Tu melnum a almpwrong pa akal ye Pol kahor arpm wan pa, ari Pol kil ropon melnum a atn hep ekg almpwrong pa la tolpa, “Ntie ekg akal kupm la naseitn ekla ur aki?” Ari melnum a atn hep ekg almpwrong pa akalmpe la tolpa, “Kitn ntie ekg ak ek Krik pa aki? ");
INSERT INTO uri_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kupm ti wa akwonalmpen tolpa kitn pa melnum ur a Ijip a pike ak wangkur pa wreitn atn minjirangket akal alm kwan tu melnum tukgunakgen a ikghlen ha ti, yatom wi tu wrong ipma wleket kmel 4,000 a ye painat a ak alm kmel mo pa, nel ye kai kor tita ark wrik knokg a kmel kalpmen ai. Kupm akwonalmpen tolpa apm kitn melnum pake, ari ake kitn melnum pa.” ");
INSERT INTO uri_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Yatom Pol pa akalmpe la tolpa, “Kil kupm melnum a Juta. Kupm pike man rakuopm arpm kai ha wail Tarsus a ha knokg Silisia. Ti ha wail a kupm Tarsus pa nang itne, kipm wrongwailet ari pa. Ti kupm melnum knokg yiprokg apm a ha ritike. Ti kitn wi wor ekg kupm la yangkipmek ur kil nasi tu wrong kinkpman ti aki?” ");
INSERT INTO uri_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Yatom melnum a atn hep ekg almpwrong pa kil wi wor ekg kil la ekla ur alkilen pa. Yatom tu eln kil atn leta a ngkom kaino wan kwa pa, kil atn eln wam pa atn ak lok tu wrongwailet a ekla kor tita pa. Tu elntmpei atn pa, kil la nasen ekla pa ak ek Hipru. ");
INSERT INTO uri_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Tu wrong kinkpman pa nel elntmpei atn pa, Pol la nasen la tolpa, “Kipm yantin a wasokwasok a wailenwailen alkupmen pa, kipm itning! Kupm akal laron nasepm ngko wurknong la tolpa kupm ake pike ntekg paitn ur, kalpm.” ");
INSERT INTO uri_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Tu atning a Pol kil ak ek Hipru la nasen la tolpa, yatom tu elntmpei eln nungkulkg a tu pa ha ekg atning ekla a Pol la nasen pa. Yatom Pol kil la nasen yangkipmek pa tolpa kai ");
INSERT INTO uri_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Kupm ti pa, kupm melnum a Juta, man pike rakuopm arpm ha wail Tarsus a ha knokg Silisia. Pake kupm apm wreitn wail atn ha wail Jerusalem tike. Kupm apm pike Kamaliel pa rowopm won a kaling plantopm pake. Kil ro tukgunakg lngkep a kupm ti ekg yangkipm titnongket a tu mamikgmamin manjan amento pa ekg kupm katnun komkiti ariworwor. Kupm apm pike tol kipm pake. Kupm pike nikgwalpm arke atn kalnten lok tu ekg katnun yangkipm a Maur Wailen pa ariworwor, tol a kipm ti ak, ak wang tike. ");
INSERT INTO uri_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Wa kupm pike uk kalkut a wleket ekg tu melnum a katnun ya a Jisas. Wa kupm yipowen wiyen kinkpmanen yewen kahor arpm wan tipmning pa, om tu uk wleket kai tu pa om tiur a tu pa mo. ");
INSERT INTO uri_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ti akal melnum tukgunakgen a ikghlen tu ipma krakgen a Maur Wailen, wa tu hong tukgunakgen wrongwailet a tu Juta pa, akal wa tu pa la nasepm yat. Tu pa pike ro wurkapm wompel ukopm ekg kupm ye kaino Tamaskus pa uk tu wasokwail alpmento a ark kaino pa. Wurkapm wompel pa la tolpa kupm arkul kuten wampel tu melnum a ukpma katnun ya a Jisas ti, yatom yewen kul nar Jerusalem ti, ekg akal tu pa ukwen wleket.” ");
INSERT INTO uri_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Pol kil ekla tolpa kai la tolpa, “Kupm pike ngkom tolpa kaino kaino yampingken Tamaskus ti pa, aktutu tolti ari wakg klal wail hakaino ktnong ti kul nar plaij helentopm wail ak hran takgni wail a no kwarngkwarn. ");
INSERT INTO uri_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Kupm ngko eln kinar knokg ti, wa kupm atning ek ur pa kwewopm namputopm nang Sol ti la tolpa, ‘Sol, Sol! Ntekg tolhai yatom kitn uk kalkut a wleket ekg kupm ti?’ ");
INSERT INTO uri_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Yatom kupm ropontel la tolpa, ‘Melnum Wailen, kitn mla?’ Ari kil la tolpa, ‘Kupm Jisas a Nasaret a kitn ukopm kalkut a wleket pa.’ ");
INSERT INTO uri_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Tu melnum a ntiopm pa, tu ari wakg ti hute, ake tu wa atning ek a melnum a ekla ekg kupm ti. ");
INSERT INTO uri_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Yatom kupm ropon la tolpa, ‘Wailen, ti al kupm ntekg tolhai?’ Ari wa Wailen kil la nasopm la tolpa, ‘Wreitn kaino Tamaskus pa om! Melnum ur a arpm kaino ha pa, akal la naseitn kwap wrongwailet a akrkahanteitn atn akal hi kitn ak pa.’ ");
INSERT INTO uri_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Wakg akil pa ak helentopm paitn, yatom kupm ake ntie ekg ari kweiur kweiur, ti ake ntie ekg kupm ari ya pa. Yatom tu melnum a ntiopm pa tu wamparpmeopm ye kaino Tamaskus ai. ");
INSERT INTO uri_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Tu yeopm kaino arpm kaino Tamaskus pa. Yatom melnum ur a tu kwe tolpa Ananaias pa arpm. Kil pa kil melnum nipet wor a horhanekg ekg Maur Wailen, wa kil melnum a katnun yangkipm titnongket a men Juta pa yek ariworwor. Yatom tu Juta wrongwailet a ark kaino ha pa, tu ari kporn yangkipm pa la tolpa, kil pa melnum wor. ");
INSERT INTO uri_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Kil wreitn kul ariopm, yatom kil kul atn yampingkentopm tolti, kil la kul kupm ti la tolpa, ‘Sol, melnum wor alkupmen! Ikg alkitnen pa nungkwat ri kweiur kweiur ti om!’ Yatom ak wang ketn pa ikg akupm pa paln wor ari kweiur kweiur, yatom kupm ariel. ");
INSERT INTO uri_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Yatom wa kil wa la nasopm la tolpa, ‘Maur Wailen amento a tu mamikgmamin, manjan amento katnun pa, pike akrkahanteitn ekg akal kil hi planteitn kweiur kweiur wraur kil: akal kitn wi arie nikgwalpm wakrongen wrongwailet alkil, ekg akal kitn ari Melnum Nipet Wor, ekg akal kitn hi atning yangkipm kai ek a kil alkil la naseitn pa. ");
INSERT INTO uri_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ti kitn pa melnum a kil akrkahanteitn, ekg akal hi kitn laron kuina ur akil a kitn atning ari pa, ye kai hor ai nasi tu wrong kinkpman pa. ");
INSERT INTO uri_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ti kitn arpm nungkwangen kuina ur? Kitn wreitn om! Kitn kwe nang akil pa ekg al kil aklinjeitn. Kitn kai ekg tu kalukeitn, ekg al kwan paitnpaitn a pike kitn ntekg pa.’ ” ");
INSERT INTO uri_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Pol kil wa la nasen la tolpa, “Kupm wa nuhurn Tamaskus pa pleln nar Jerusalem ti pa, kupm kahor ropon Maur Wailen atn yipmingki wonen a wan yalming a Maur Wailen pa atn, ari nikgwalpm a ikg akupm pa nir kai hmit tolti, ");
INSERT INTO uri_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","yatom kupm ari Wailen pa paln la nasopm la tolpa, ‘Kitn wreitn iktutu nuhurn Jerusalem ti kai om! Tu melnum a ark ti pa, hi ake tu atning ukpma yangkipm a kitn laron ekg kupm ti la nasen pa.’ ");
INSERT INTO uri_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ari kupm akalmpe kai Wailen pa la tolpa, ‘Tu al atningkopm pa. Tu wrong kinkpman kil pa tu ari a pike kupm kai atn hor hor wan a men atning yangkipm a Maur Wailen atne pa, er a uk wleket tu a ukpma kitn pa, yatom wiyen ye kai arpm wan tipmning pa. ");
INSERT INTO uri_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Wa ak wang a pike tu akweijel Stipen pa mo ekg kil laron nang alkitnen ti pa, kupm pike atn ari wi wor. Wa hapm a tu melnum a pike akal akweijel pa, apm pike tu nir ha nepm akupm tike, yatom kupm ti ikghlen atn tike.’ ");
INSERT INTO uri_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ari Wailen kil la nasopm la tolpa, ‘Kitn kai om! Kupm akal kwaweitn kai ha ya watinet ur ai ekg tu a ake Juta pa.’ ” ");
INSERT INTO uri_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Tu wrong kinkpman wailet tu atn atning yangkipm a Pol kil la tolpa kaingkai, tu atning ekla wrij ur a Pol kil la nasen la tolpa Maur Wailen akal kwawel kai ekg tu a ake Juta pa, pa ipma a tu wreitn, tu plalplal mainmain wli pa wli pa la tolpa, “Ilm er kwan melnum a tolpa mo kai tukulein knokg ti om!” ");
INSERT INTO uri_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Nikgwalpm a tu pa wreitn wakget hret paitn wrijen ekg ekla pa, yatom tu mainmain plalplal tolpa atn, wamparpme kungku nir hapm alntu ti piln, wa ngkol knokg hngrapm ti piln eln kaino kwa. ");
INSERT INTO uri_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Yatom melnum a atn hep ikghlen tu melnum a almpwrong pa ukwen yangkipm titnongket pa, la tolpa tu wi Pol pa ye kahor wan a tu melnum a almpwrong pa, wa la tolpa tu ak hmpei ak rkwawel ekg a kil laron yiprokgen kuina ur yatom tu wrong kinkpman plalplal mainmain ekg kil ti tolti. ");
INSERT INTO uri_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Yatom tu ye Pol pa ye kahor yipo nepm wampel elntarpm plaln pa, tu akal ak hmpei pa ak rkwawel. Ari kil ari melnum ur a atn hep ikghlen melnum kmel wampomit (100) a almpwrong atn yampingken ti yatom kil ropontel la tolpa, “Yangkipm titnongket a Rom pa la tolhai? Kipm ntie ekg rkwa melnum ur a nang a kil hel namponen kipm Rom tike? Ti nang a kupm apm hel namponen kipm Rom tike! Tol kipm yewopm ye kai ekg mento ntekg yangkipm pa hep, la tolpa kupm ntekg paitn ur pa, kipm ik hmpei ti ik rkwaopm.” ");
INSERT INTO uri_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Melnum a atn hep ikghlen melnum kmel wampomit (100) a almpwrong pa, kil atning ekla a Pol pa, yatom kil wa kai la nasi melnum a atn hep a kil pa la tolpa, “Kitn ari a kitn ntekg melnum pa tolpa, pa kitn ak wor aki? Kil pa, nang a kil pa apm hel namponen men Rom tike!” ");
INSERT INTO uri_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Melnum a atn hep pa kil atning tolpa, yatom kil kai ropon Pol pa la tolpa, “Kitn la nisopm kitn alkitn ti riworwor ri, kitn ti, nang a kitn ti hel namponen men Rom ti aki?” Ari Pol akalmpe la tolpa, “Ei, nang akupm apm hel namponen kipm Rom tike.” ");
INSERT INTO uri_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Yatom melnum a atn hep ekg almpwrong pa la tolpa, “Kupm ti armpen marpm wail uk tu Rom, yatom kupm paln tol tu Rom ti.” Ari Pol pa akalmpe la tolpa, “Kitn pa armpen pake, wa kupm ti pa manjan pa wi nang namponen Rom yatom kwat kupm ti, yatom kupm ti pa apm tukol tu Rom tike.” ");
INSERT INTO uri_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Tu melnum a akal ropon Pol ekg kweiur kweiur a wet paln pa, tu kark mehen tolti nuhurntel kai. Wa melnum kil alkil a atn hep pa yat, kil wa kark yat, ekg kil wet la nasi tu ekg yipo nepm wampel Pol, kil melnum tol tu Rom pake. ");
INSERT INTO uri_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Melnum a atn hep ikghlen tu melnum a almpwrong pa, kil apm wakrongen akal kor ariworwor ekg yiprokgen kuina ur a tu Juta arki Pol pa. Yatom hor kang pa, kil la tolpa tu nelkgen hmpei pa tukulein nepm wam a Pol pa. Yatom kil kwe tu melnum ipma krakgen a Maur Wailen a atn hep, a tu hong tukgunakgen wrongwailet a Juta pa, tu kul ark wrij pa, kil wi Pol pa kai kinar atn kinar ikg a tu pa ekg ntekg yangkipm pa. ");
INSERT INTO uri_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol pa ikgtnen tu hong tukgunakgen a tu Juta pa, yatom kil la tolpa, “Kipm yantin a wasokwasok a wailwail akupm ti, kai arpm a atn a kupm ti pa, kupm pe ak ai kul ngko wang ti pa, kupm katnun nikgwalpm wakrongen wrongwailet a Maur Wailen worwor wa kupm ak tolpa atn tike.” ");
INSERT INTO uri_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananaias, melnum tukgunakgen a ikghlen tu ipma krakgen a Maur Wailen pa, kil atning a Pol kil la tolpa, yatom kil la nasi tu melnum a atn yampingken Pol pa la tolpa tu rkwa ekel Pol pa. ");
INSERT INTO uri_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ari Pol pa akalmpe ek a kil pa la tolpa, “Kitn pa tol melnum akplain ak palk ti tolti, pake kahor wonen a kitn pa paitn. Ari kitn pa arpm ekg atning yangkipm akupm ti tukol melnum ur a arpm atning atning yangkipm katnun kuina ur a yangkipm titnongket la pa. Ari kitn pa la nasi tu pa la tolpa ekg tu rkwaopm. Tolpa yatom kitn alkitn ti lalo yangkipm titnongket ti ase.” ");
INSERT INTO uri_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ari tu melnum tiur a atn yampingken Pol pa wa la nasel la tolpa, “Kitn ti aknokgel melnum tukgunakgen a ikghlen tu ipma krakgen a Maur Wailen pa!” ");
INSERT INTO uri_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ari Pol pa akalmpe la tolpa, “Kipm yantin a wasokwasok a wailwail alkupm ti, kupm ti akwekgel kil pa melnum tukgunakgen a ikghlen tu ipma krakgen a Maur Wailen pa, tolpa yatom kupm la tolpa. Wurkapm a Maur Wailen pa la tolpa, ‘Ake al mento aknokgel tu melnum wail wail a atn ikghlen mento wrong kinkpman pa.’ ” ");
INSERT INTO uri_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pol kil ari tolpa, tu hong tukgunakgen a tu Juta pa, tu tiur pa a Satyusi, wa tu tiur pa a Parasi, tolpa yatom kil la nasen yikaktnen kai ikg a tu hong tukgunakgen pa la tolpa, “Kipm wasokwasok a wawilen alkupmen ti! Kupm ti pa, kupm a Parasi, wa tu yantin a kwat lei kulngkul kwat kupm ti pa, apm a Parasi pa yat pake. Tu wiyopm ye kul atn ti ntekg yangkipm ektnen yiprokgen a kupm arpm nungkwangen hirhir tol kipm Parasi ti la tolpa, tu melnum a mo pa, tu hi wa wreitn.” ");
INSERT INTO uri_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Kil la yangkipm pa kai yatom tu Satyusi a tu Parasi pa, nel wreitn kle tita wail, yatom nel wako ro atn manman. Tu tiur kai nti tu Satyusi, wa tu tiur kai nti tu Parasi. ");
INSERT INTO uri_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ekg nte, tu Satyusi pa tu la tolpa, tu melnum a mo kaingkai pa, hi ake wa wreitn. Wa tu la tolpa, ake wa maur akwapel ur a Maur Wailen aki maur ur arpm pa, kalpm. Pake wa tu Parasi pa tu la tolpa, kweiur kweiur tol maur a maur akwapel a Maur Wailen pa arpm pa. Wa tu la tolpa, tu a mo kaingkai pa, tu hi wa wreitn pa. ");
INSERT INTO uri_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ari kalpm, apm nel plalplal mainmain kle tita kai wail ase. Yatom tu Parasi tiur a arpmen yangkipm yiprokgen a Maur Wailen pa, tu wreitn atn loken la ak ek titnongket la tolpa, “Ake men hantil paitn ur a melnum pa ntekg pa. Ekla a kil la tolpa pa, plpa mring aki maur ur aki maur akwapel ur a Maur Wailen pa la nasel, yatom kil la naso ur pake.” ");
INSERT INTO uri_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ari apm nel kle tita kai wailmanten ase. Yatom melnum a atn hep ekg tu melnum a almpwrong pa, kil arpm ari tu kwreitnunen tita rkol Pol pa kai pa kai pa, yatom kil kark ekg akal tu alm kwreitnunen Pol pa uk tita, tolpa ti kil akal kai paitn mo ur pa. Tolpa yatom kil uk yangkipm tu melnum alkil a almpwrong pa la tolpa, tu kinar namponen titnongket pa rkol Pol pa kai wam a tu pa ye kul kai kahor hen ai, ye kai kaino arpm wan ha a tu melnum a almpwrong arke ai. ");
INSERT INTO uri_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Yatom ak mning pa Wailen kil paln atn yampingken Pol pa, wa kil la tolpa, “Pol, kitn itn titnongket, ampur kitn kark! Kitn pike laron nang akupm nasi tu a atn Jerusalem ti, ti apm wa tolpa yat, kitn hi wa laron nang a kupm nasi tu a atn kai Rom pa yat.” ");
INSERT INTO uri_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Hokg hor kang ti pa, tu Juta tu kor tita kai ark wrij yipon yangkipm hampen akal alm Pol pa mo. Yatom tu yipon yangkipm titnongket aklahle pa la tolpa, ake al tu al hu a ekpma pa, atn kaingkai, hi tu alm Pol pa mo plaln pa, tu al hu a ekpma pa om. ");
INSERT INTO uri_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ti tu melnum a yipon yangkipm hampen ekg akal alm Pol mo pa, tu wrong pa wailet hangken tol kmel wekg (40) pa. ");
INSERT INTO uri_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Yatom tu melnum pa tu kai ari tu melnum ipma krakgen a Maur Wailen a atn hep, namponen tu melnum wail wail pa, yatom tu la nasen la tolpa, “Men pike yipon yangkipm titnongket aklahle pa la tolpa, men hi ake al ekpma ur, atn kaingkai, men alm Pol pa mo plaln pa, men al ekpma pa om. ");
INSERT INTO uri_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Tolpa ti kipm pa namponen tu hong tukgunakgen a tu Juta pa, kipm kwa yangkipm ti kaino ekg nisi lok melnum a atn hep ekg almpwrong a Rom pa la tolpa, kil kwa Pol pa nar, ekg akal kipm ropon wi arie worwor ekg yiprokgen kuina ur paitn a Pol kil ntekg pa. Tu akal yewel nar ekg akal ntekg yangkipm pa, men numprampen tolpa ekg men akal almpel mo ngko ya pa.” ");
INSERT INTO uri_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pake warim war kpman a Pol pa kil atning ari a tu ark kor la akal alm Pol pa mo. Kil atning tolpa, kil apm kaino wan ha a tu melnum a almpwrong arke pa, kil la nasi Pol ekg yangkipm a wet kil atning pa. ");
INSERT INTO uri_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Yatom Pol kil kwe melnum ur a atn hep ikghlen tu melnum kmel wampomit (100) a almpwrong pa kul ariel, yatom kil la nasel la tolpa, “Kitn wi melnum warimpen ti ye kai ekg ari melnum a atn hep ekg almpwrong ai, ekg kil akal la nasel yangkipmek ur alkilen ti pen.” ");
INSERT INTO uri_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Yatom melnum a atn hep ikghlen tu melnum kmel wampomit (100) a almpwrong pa kil wiyel ye kai ari melnum a atn hep akil pa, la nasel la tolpa, “Pol, melnum a arpm wan tipmning pa, kil wet kweopm kai ariel, yatom kil la nasopm la tolpa, kupm wi melnum warimpen ti ye kul arieitn, ekg kil akal la naseitn yangkipmek ur alkilen.” ");
INSERT INTO uri_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Melnum a atn hep akil pa atning tolpa, om kil wamparpme melnum warimpen pa ye kai atn hampen, yatom kil ropontel la tolpa, “Kitn kul ariopm ekg akal la nasopm yangkipm kuina?” ");
INSERT INTO uri_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Yatom kil la nasel la tolpa, “Tu Juta yipon yangkipm akal akeitnplain roponteitn la tolpa, hikg kitn wi Pol pa ye kinar, ekg tu hong tukgunakgen alntuen a arpm atning yangkipm pa, ekg akal tu wi arie wor wor ekg yiprokgen kuina ur paitn a Pol kil ntekg pa. ");
INSERT INTO uri_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Pake ampur kitn atning yangkipm a tu pa wi wor ukwen, yatom kitn wiyel ye kinar pa. Ekg nte, tu wrong wailet paitn, hangken kmel wekg (40) pa, tu pa apm nel arpm nungkwangen kil pa arpm kai ya pa arpm pake. Tu pike yipon yangkipm titnongket aklahle tolpa, tu hi ake al ekpma aki al hu ur pa, atn kaingkai, tu alm kil ti mo plaln pa, tu al hu a ekpma pa om. Ti tu numprampen ark ya ark pa ekg akal ari kitn akal akye Pol pa kinar.” ");
INSERT INTO uri_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Melnum warimpen pa la nasel yangkipm pa plaln pa, melnum a atn hep ekg almpwrong pa la karkurntel la tolpa, “Ampur kitn la nasi mla ur a wet kitn la nasopm yangkipm kil pa.” Yatom kil kwawel kai. ");
INSERT INTO uri_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Yatom melnum a atn hep ekg almpwrong pa, kil kwe melnum wekg alkilen a almpwrong a kul rken kil pa, kul ukwen yangkipm la tolpa, “Kipmekg numprampen tu melnum a almpwrong pa tolpa: tu melnum a ngkom ak nepm pa tol kmel wampwam (200), wa tu melnum a arpme hos pa tol kmel wraur tuwek wampwam (70), wa tu melnum a ye wri pa tol kmel wampwam (200) pa. Yatom kipmekg wi tu pa plalnten ye kul atn wrij, yatom ak mning kwawen ti pa, kipmekg wiyen om kipm nuhurn ti ak alupm Pol pa ye kai kaino ha wail Sisaria pa. ");
INSERT INTO uri_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ti kipmekg numprampen hos aripm ur pa ye namponen, ekg al Pol pa arpme. Yatom kipm ak alupmel ikghlentel ariworwor yewel tolpa kai kaino uk kai wam a Peliks pa, melnum wailen a ikghlen ha knokg pa.” ");
INSERT INTO uri_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Melnum a atn hep ekg almpwrong pa ukwen yangkipm pa tolpa plaln pa, kil wa ro wurkapm ur pa ukwen ekg akal tu ye nakure Pol pa ye kaino uk Peliks pa. Wurkapm pa la tolpa, ");
INSERT INTO uri_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Ukweitn wor Peliks, kitn melnum wail alpmenen a nang itne wor a ikghlen ha knokg Jutia. Kupm Klotius Lisias, kupm ronteitn wurkapm rikil. ");
INSERT INTO uri_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Melnum kil pati, pike tu Juta arkulel akal almpel mo. Ari kupm atning a tu la tolpa, kil pa apm nang a kil pa hel namponen tu Rom pake, yatom kupm namponen tu melnum alkupmen a almpwrong pa, men kai rkolel kai wam a tu pa ye kai tukuleinjen. ");
INSERT INTO uri_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Yatom pike kupm wakrongen akal wi arie ekg yiprokgen kuina ur a tu arkiel lak kil ntekg paitn pa, yatom kupm wiyel ye kinar atn ikg a tu hong tukgunakgen alntuen a arpm atning yangkipm pa. ");
INSERT INTO uri_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Kupm atning a tu arkiel la tolpa, kil kpor yangkipm titnongket ur a tu alntu Juta pa tolti, yatom tu wiyel kai atn ntekg yangkipm pa ektnen pake. Pake ake kupm ari paitn ur a kil ntekg pa, ekg akal wiyel ye kahor arpm wan tipmning pa, aki almpel mo pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ari melnum warimpen wrij ur pa kul la nasopm yangkipm hampen ur a la tolpa, tu yipon yangkipm hampen ekg akal alm melnum pa mo. Tolpa yatom kupm kwawel aktutu tolti kai kainonteitn pake. Wa kupm la nasi tu melnum a arkiel pa, la tolpa kil ntekg kuina ur paitn pa, al tu kaino ntekg yangkipm namponen melnum pa atn, kitn pake.” ");
INSERT INTO uri_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ekla a melnum a atn hep ekg almpwrong a ro hel kai wurkapm pa apm kai eln tolpake. Yatom kil uk wurkapm pa tu melnum a almpwrong alkilen pa ye. Yatom tu atning katnun yangkipm a kil ukwen pa, yatom tu wi Pol pa yewel kaino ak mning mning kaino paln kaino ha wail Antipatris ai. ");
INSERT INTO uri_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Tu hokg ark pa, hor kang ti pa, tu ak lakg tita: tu melnum a arpme hos pa akye Pol pa kaino, wa tu melnum a ngkom ak nepm, wa tu melnum a ye wri pa tu pleln kinar wan ha a tu alntu melnum a almpwrong arke ark kinar Jerusalem ai. ");
INSERT INTO uri_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Tu melnum a arpme hos pa, tu kaino paln kaino Sisaria pa, yatom tu uk Pol pa namponen wurkapm pa kai wam a melnum tukgunakgen a ikghlen ha knokg Jutia pa. ");
INSERT INTO uri_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Yatom melnum tukgunakgen pa kil klein wurkapm pa plaln pa, kil ropon Pol pa la tolpa, “Ha knokg yiprokgen a kitn pa hai?” Ari Pol pa la nasel la tolpa, “Kupm a Silisia.” ");
INSERT INTO uri_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Kil atning a Pol la nasel la tolpa, yatom kil la nasel la tolpa, “Ti kitn kai irpm pen! Hi tu melnum a arkieitn pa kul no paln pa, kupm hi arpm atning yangkipm akitn pa.” Yatom kil la nasi tu pa wiyel ye kahor elntarpm wan wail alkilen a tu melnum tukgunakgen arpme arpme a pike hep ak ai pen Herot ntekg. Kil arpm kahor pa tol a kil arpm wan tipmning. ");
INSERT INTO uri_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Wang wampomit kai plaln pa, Ananaias, melnum tukgunakgen a ikghlen tu ipma krakgen a Maur Wailen pa kil wi tu melnum wail wail tiur, a melnum ur, kil melnum arie a yangkipm titnongket a tu Rom pa, nang akil pa Tertulus, pa nel kul no Sisaria ti. Yatom tu kai atn la kuina ur akal tu ntekg nti Pol pa nasi Peliks, melnum a Rom pa, kil atn tukgunakgen a ikghlen ha knokg Jutia a arpm atning yangkipm pa. ");
INSERT INTO uri_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Plaln pa, melnum tukgunakgen pa la nasi tu ekg wi Pol pa kul hor atn ekg akal ntekg yangkipm pa, Tertulus pa wi ek a tu pa ekla arki Pol pa la tolpa, “Peliks, kitn pa melnum wail alpmenen a nang itne wor. Kitn ikghlento ariworwor, wa lok ya a nikgwalpm tiur a paitn pa, yatom men ark mehen utopen wor wang watin ak ai kulngkul apm kul tike. Kitn pa nikgwalpm arke wonrekele wor, yatom kitn ye kweiur kweiur weten wor wor ye kul ak aklin men ti arpm utopen wor, yatom kweiur kweiur wrongwailet pa paln ariwor. ");
INSERT INTO uri_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ti men arieitn kai ya wrongwailet a kitn ak tolpa ari, pa wor wrijen, yatom men wrongwailet a ark hor ti pa, men arieitn kpornteitn yangkipm a men ukweitn wor wailmanten. ");
INSERT INTO uri_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Pake ake akal kupm rkoln yangkipm pa kai watin pa. Kupm la tolpa, tol kitn nikgwalpm wor reinjo pa, pa kitn itning ekla waitketn amen kil. ");
INSERT INTO uri_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Men ari melnum kil ari, kil melnum a rkol men Juta wrongwailet ti kai ngko kai walmpopm paitn a kil pake. Kil ye numpet paitn alkilen pa ak ro wrong tiur pa kai atn namponen kil pa, yatom tu kwewen la tolpa tu Nasaret. Yatom apm kil pa atn hep ekg tu pake. Kil melnum a alm ipmael tu Juta wrongwailet a ark hor ha knokg wrongwailet om ntekg tu kle er tita. ");
INSERT INTO uri_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","8","Wa kil pike ntekg akal aknokgijel wan yalming a Maur Wailen. Apm yiprokgen wailmanten a kil ak tolpa, yatom men arkulel. Tolpa yatom men yewel kul atn ti, ekg akal kitn alkitn pa ropon atning kai ek a kil alkil ai la naseitn kuina ur a men arkiel atn ti.” ");
INSERT INTO uri_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tertulus kil la ekla pa plaln pa, tu Juta pa apm wa nel la yangkipm wrij hirhir tol a kil pa la pake, nel la Pol pa la tolpa kil pa melnum paitn a ntekg paitn tolpake. ");
INSERT INTO uri_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Melnum tukgunakgen a ikghlen ha knokg Jutia pa, kil ak ikg nasi Pol pa la tolpa, “Kitn la ekla pa om”. Yatom Pol akalmpe la tolpa, “Kupm ari tolpa wring a wang wailet kitn pike arpm atning yangkipmek wrongwailet a tu wrong kinkpman a hor kul ntekg yangkipm atn nti kitn ti. Tolpa ti ipma a kupm ti pa utopen ekg kupm ntie ekg akalmpe ekla a tu arkiopm atn ti ekg kitn atning. ");
INSERT INTO uri_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Tol kitn alkitn akal ropon pa, hi kitn atning tolpa, ake wa pike ak ai, kweke ti, ak wang wampwam yikakwomwekg (12) kai ase, kupm pike kinar arpm kinar Jerusalem ekg kpor klko lein Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ti tu Juta ake ari kupm alilhakel tita nti mla ur atn yipmingki wonen a wan yalming a Maur Wailen pa. Wa ake tu ari kupm kle er mla ur atn wan a men Juta atning atning yangkipm a Maur Wailen atne pa, aki hor ha wail pa, ekg akal tu wrongwailet aktutu kul ari pa, pa kalpm. ");
INSERT INTO uri_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Tu ake ntie ekg la yangkipm ur ekg ak planteitn tolpa pa yangkipm a tu arkiopm pa, pa aklahle pa, pa kalpm. ");
INSERT INTO uri_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Pake yangkipm wrij ur a tu arkiopm kil pa pati, kupm la pa aklahle pake. Kupm katnun ya a tu la tolpa, pa ya raimpen. Kupm katnun ya pa om kupm kpor klko lein Maur Wailen a tu mamikgmamin manjan alpmenen. Wa kupm ukpma yangkipm wrongwailet a ro hel kai yangkipm titnongket a Moses, wa hel kai wurkapm a tu melnum ek wripm a Maur Wailen ro pa. ");
INSERT INTO uri_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Apm wa tolpake, kupm apm ukpma arpm nungkwangen tolpa, Maur Wailen la pa, tu men a mo pa hi wa wreitn, melnum wor wa melnum paitn yaten. Tu melnum a arkiopm pa, tu pa yat tu arpm nungkwangen tolpa yat pake. ");
INSERT INTO uri_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Tolpa yatom kupm aklei wang nikgwalpm arke ikghlen ipma akupm pa ark nipet wor kai ikg a Maur Wailen, wa kai ikg a tu wrong kinkpman. ");
INSERT INTO uri_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Kupm pike arpm wring aripm ur hor ha knokg manet tiur ai. Plaln pa, wa kupm wa pleln kinar Jerusalem, ye marpm a hapmnung kweiur kweiur tiur a men kor tita pa ye kinar ekg aklin tu men alpmen Juta a arpm warkip pa. Wa kupm al wor uk Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Pike ak wang a tu Juta ari a kupm kai kahor yipmingki wonen a wan yalming a Maur Wailen pa al wor uk Maur Wailen akwap kweiur kweiur pa, kupm pike paln wri wor kai ikg a Maur Wailen ase. Ake wa tu wrongwailet ur ntiopm pa, kalpm, ake wa melnum ur ekla wailet pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Pake tu Juta tiur a ha knokg Esia pa, tu pike ark kinar Jerusalem pa ak wang pa om ariopm pa. Pa wor tol tu alntu pa kul itn ikg a kitn alkitn ti, om la kiti kuina ur paitn a pike tu ari a kupm ntekg atn kai pa. ");
INSERT INTO uri_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Aki tol tu melnum a arkiopm atn ti, tu la kiti kuina ur paitn a tu hantil kai kupm ti ak wang a pike kupm atn kai ikg a tu hong tukgunakgen a tu Juta a arpm atning yangkipm kinar Jerusalem pa. ");
INSERT INTO uri_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ti apm ekla wrij a pike kupm atn kuin a tu pa la yikaktnen nasen la tolpa, ‘Kupm ukpma tolpa tu melnum a mo kai pa, hi wa wreitn. Apm yiprokgen pa yatom tu yeopm kul atn ntekg yangkipm atn ikg a kipm tike.’ Apm pike kupm la yangkipm ketn pa tolti atn kinar ai.” Ekla a Pol la pa apm kai tolpake. ");
INSERT INTO uri_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ti Peliks pa kil ari worwor ya a tu katnun Jisas pa a wet Pol la kiti tolpa, yatom kil arukge wang pa ye kai wang ur ai la nasen la tolpa, “Lisias melnum a atn hep ekg almpwrong pa kil nar pa, hi wa kupm ntekg yangkipm akipm pa.” ");
INSERT INTO uri_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Kil la nasi melnum ur a atn hep ekg ikghlen tu melnum kmel wampomit (100) almpwrong pa la tolpa, kil wi Pol ye kahor elntarpm kahor wan tipmning pa. Pake ake al tu ak hmpei pa yipoel aki eln yangkipm titnongket pa atn ekg ak lok tu mla ur melnum wor alkilen a kul ekg akal ariel a aklinjel ekg kweiur kweiur tiur a kil warkip pa. ");
INSERT INTO uri_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Wang aripm ur kai plaln pa, Peliks kil kul namponen kin alkilen pa Trusila, kin alkilen pa a Juta. Peliks kwa melnum ur kai akwi Pol pa ye kul. Yatom Pol pa la nasel yangkipmek tiur a la ya a ukpma Krais Jisas pa, yatom kil atning. ");
INSERT INTO uri_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pol kil la nasel ya a paln nipet wor kai ikg a Maur Wailen, ya a lokhparn kitn alkitn, wa Maur Wailen hi ntekg yangkipm namponen mento ak wang kanukg. Peliks kil atning yangkipm pa ari kil kark, wa kil la tolpa, “Kitn kai pen! Wangkur wa kupm alm wang la naseitn pa, kitn wa kul ul.” ");
INSERT INTO uri_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Peliks kil ak wonye Pol pa, ekg akal wa kil ukwel marpm ur ekg ak armwonel kil ti, ekg akal kil ak kwat yangkipm a kil pa kai tukulein. Apm wa yiprokgen ur pa yat, yatom ari kil kwa melnum ur pa akwi Pol pa ye kul nti aripm ur ekg kil akal ntiel eklala. ");
INSERT INTO uri_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Pol kil arpm wan tipmning pa tolpa kai, ngko wring wekg pa, Porsius Pestus kil wi wrik a Peliks pa wa atn melnum tukgunakgen. Peliks pa kil wakrongen tolpa kil wa ntekg ipma a tu Juta pa utopen ekg kil pa, tolpa yatom kil eln Pol kil kai arpm wan tipmning pa arpm. ");
INSERT INTO uri_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pestus kil kul wli ha knokg Jutia pa om kil wi kwap a melnum tukgunakgen a ikghlen ha knokg ripa. Kil arpm wang wraur kai plaln pa, kil wreitn atn Sisaria pa kai kinar ha wail Jerusalem pa. ");
INSERT INTO uri_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Kinar ha wail pa tu melnum ipma krakgen a Maur Wailen a atn hep, wa tu melnum wail wail a tu Juta pa, tu kul ari Pestus pa, wa la nasel ekg ekla a tu arki Pol pa. ");
INSERT INTO uri_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Wa tu la titnongket la tolpa, tol kil wi wor ekg tu pa, al wa kil kwa tu akye Pol pa nar ekg ntekg yangkipm nar Jerusalem ti. Ekg nte, tu apm numprampen akal ark nungkwangen tolpa, tol wa Pol ti nar pa, tol tu ilmpel mo ngko ya. ");
INSERT INTO uri_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ari Pestus pa akalmpe la tolpa, “Pol apm tu elntarpm kaino wan tipmning arpm kaino Sisaria ase. Ti kupm ti yampingken ekg al wa kaino Sisaria pa yat pake. ");
INSERT INTO uri_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Tol kipm la tolpa melnum ripa ntekg paitn pa, tol kipm wa kwa tu melnum wail wail tiur akipm ti ntiopm kaino Sisaria pa, ekg nti melnum ripa ntekg yangkipm akil kaino pa.” ");
INSERT INTO uri_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pestus kil arpm pa wang wampomit wampomwraur aki wampwam pa kai plaln pa, kil wa wreitn ha pa kai kaino Sisaria ase. Kil hokg hor kang pa, pa kil arpm wrik alkilen a kil arpme ekg ntekg yangkipm pa arpm ekg akal atning yangkipm ripa. Yatom kil la nasi tu la tolpa, “Kipm wi Pol pa ye kul ekg kupm.” ");
INSERT INTO uri_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Tu wi Pol pa ye kul atn, tu Juta a pike ha kinar Jerusalem pa no pa, nel kul kai atn yeningkentel atn. Wa tu ye yangkipm kalkut wailet tiur a pike tu arkiel pa ye kul atn akal ntekg ntiel. Pake tu ake ntie ekg plan tolpa yangkipm ur a tu arkiel pa aklahle. ");
INSERT INTO uri_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Om Pol kil la yangkipm akil pa ak kwat yangkipmek wrongwailet a tu arkiel pa la tolpa, “Kupm ake pike ntekg paitn ur, ekg akal ak kwat yangkipm titnongket ur a men Juta ti, aki wa ntekg paitnel wan yalming a Maur Wailen pa, aki wa ntekg paitnel Sisar melnum tukgunakgen a Rom ti.” ");
INSERT INTO uri_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pake Pestus pa kil wakrongen ekg akal ntekg ipma a tu Juta pa paln wor ekg kil, yatom kil ropon Pol pa la tolpa, “Kitn wi wor akal kinar Jerusalem ekg ntekg yangkipm nti tu pa atn ikg akupm ti kinar pa aki?” ");
INSERT INTO uri_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ari Pol pa akalmpe la tolpa, “Ti kupm kul atn ikg a kipm a horhanekg ekg Sisar ti pa, yangkipm akupm ti pa apm kipm a Sisar pa atning atn tike, wa ake akal ye kinar Jerusalem pa. Ti kitn alkitn pa ari worwor tolpa, kupm ake ntekg paitn ur kai tu Juta pa. ");
INSERT INTO uri_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Tol kupm ntekg kwei ur paitn, yatom yangkipm titnongket a tu Rom pa la tolpa tu al almpopm mo, pa kupm wi wor ekg al tu almpopm mo pake. Pake tol yangkipm a tu Juta kul ntiopm ntekg yangkipm atn ti pa, pa ake yangkipm ur aklahle. Tolpa yatom melnum ur ake ntie ekg eln kupm ti kai wam a tu pa, kalpm. Kupm la tolpa, yangkipm akupm ti hi ye kai ntekg atn kai ikg a Sisar ai.” ");
INSERT INTO uri_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Yatom Pestus kil ekla namponen tu melnum a arie a ukwel nikgwalpm arie pa plaln, yatom kil la nasi Pol pa la tolpa, “Kitn akal ntekg yangkipm atn kai ikg a Sisar pa pati, kitn kai ntekg yangkipm itn kai ikg a Sisar pa om!” ");
INSERT INTO uri_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Tu ntekg yangkipm a Pol pa kai plaln, om wang aripm ur pa kai plaln pa, melnum tukgunakgen Akripa namponen Pernaisi, muitnwror alkilen pa, tuwekg kul Sisaria ekg ukwor utopen Pestus pa. ");
INSERT INTO uri_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Tuwekg arpm pa wang wailet, pa Pestus kil la kiti ekla a Pol la pa nasi melnum tukgunakgen pa. Kil la nasel la tolpa, “Melnum ur arpm wan tipmning arpm ti pa pike Peliks wiyel elntarpm ak ai, ti arpm lan arpm ti. ");
INSERT INTO uri_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Pike ak wang a kupm arpm kinar Jerusalem pa, tu melnum ipma krakgen a Maur Wailen a atn hep, wa tu melnum wail wail a tu Juta pa, tu kul ariopm, yatom tu arkiel la nasopm la tolpa, ‘Kil pa pike ntekg paitn, ti kitn ukwel wleket akalmpe paitn a kil ntekg pa om!’ ");
INSERT INTO uri_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ari kupm la nasen la tolpa, ‘Yangkipm titnongket a men Rom pa, pati la tolpa, ake al ye melnum ur pa kul ekg ukwel wleket kalpmel, pa kalpm. Hep pa men wiel ye kul atn ntekg yangkipm pa pen kai ikg a tu kmel a arkiel pa, yatom wa uk wang atn, ekg akal wa kil pa wa akalmpe ekla a tu arkiel pa pen, lak kil ntekg paitn pa, ukwel wleket pa kanukg ul.’ ");
INSERT INTO uri_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Tu atning tolpa tu ntiopm kul no. Ake wa kupm ye tu pa atn wang watin pa, kalpm. Men hokg hor kang ti tolti, kupm kai arpm wrik a kupm arpme ekg ntekg yangkipm pa, yatom kupm la tolpa tu wi melnum pa ye kul ekg ntekg yangkipm ti om. ");
INSERT INTO uri_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Yatom tu melnum a ntiel ntekg yangkipm pa tu atn yeningkentel. Pa kupm akwonalmpen tolpa, tu pa la tolpa, kil pike ntekg paitnpaitn tiur, ari kalpm. ");
INSERT INTO uri_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ti yiprokgen a tu arkiel pa pati, tu alilhakel tita ekg ya alntuen a Juta a ukpma Maur Wailen alntuen. Wa tu alilhakel tita a kle tita ekg ekla ur a Pol la ekg kmel ur a mo ase, nang a kil pa Jisas. Ari Pol kil la tolpa kmel ripa, kil wa wreitn arpm. ");
INSERT INTO uri_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ti nikgwalpm akupm ti apm kai hmit ase, ekg akal kupm wi yiprokgen a yangkipm pa la tolhai. Tolpa yatom kupm ropontel la tolpa tol wa kil wi wor pa pati, kil wa kinar Jerusalem ai, ekg wa kupm itning yangkipm akil pa itn kinar Jerusalem ai. ");
INSERT INTO uri_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ari Pol kil pa la titnongket la tolpa, kil al wa kai arpm wan tipmning pa arpm pa pen, ekg yangkipm akil ti hi ye kai ntekg atn kai ikg a Sisar ai. Tolpa yatom kupm la nasi tu tolpa wiyel ye kai elntirpm kai wan tipmning pa pen kai ngko wang a hi kupm wa kwawel kai ekg kil ntekg yangkipm atn ikg a Sisar.” ");
INSERT INTO uri_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Akripa atning a Pestus la tolpa, yatom kil akalmpe la tolpa, “Ti kupm wakrongen yat ekg kupm akal atning yangkipm a melnum kil alkil pa la yat.” Ari wa Pestus pa akalmpe la tolpa, “Ti hikg pa kitn atning yangkipm a kil pake.” ");
INSERT INTO uri_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Hokg hor ak kang pa, Akripa ekg Pernaisi pa tuwekg kul namponen lukglukg worwor kai kahor wan a arpm ekg ntekg yangkipm pa, wa namponen tu melnum a atn hep ekg almpwrong pa, wa tu melnum wail wail a ikghlen ha pa. Yatom Pestus uk yangkipm tu pa yatom tu wi Pol pa ye kulhor wan wonen pa. ");
INSERT INTO uri_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Yatom Pestus kil la tolpa, “Melnum tukgunakgen Akripa, wa namponen kipm mla ur a ntio kul atn ti pa, kipm ari melnum kil! Tu wrong kinkpman wrongwailet a Juta a atn kinar Jerusalem ai, wa atn Sisaria ti, tu la titnongket wailet la wli pa wli pa ekg kupm ti la tolpa, kil ampur arpm pa, tu akal almpel mo. ");
INSERT INTO uri_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Pake ake kupm hantil paitn ur kai kil pa ekg akal almpel mo pa. Pake kil alkil pa la tolpa akal ntekg yangkipm atn kai ikg a Sisar kil alkil pa, tolpa yatom kupm yipon yangkipm akal kwawel kai Rom. ");
INSERT INTO uri_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Pake kupm nikgwalpm kalpmtopm, ekg akal kupm ro tolhai ekg ak nasi melnum tukgunakgen Sisar pa ekg ak la melnum kil. Tolpa ti kupm wiyel ye kul atn ikg a kipm wrongwailet ti, wa atn ikg alkitnen melnum tukgunakgen Akripa tike. Tolpa om akal mento plalnten atning yangkipm a kil pa, ekg al kupm ari yangkipmek kuina ur a kupm al ro hel wurkapm ti, ekg kwa ye nakurel kai pa. ");
INSERT INTO uri_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Tol ake kupm ro yangkipmek ur a la kiti paitn ur a tu wiyel ye kai arpm wan tipmning pa kwa namponentel kai pa, kupm ak paitn, pa ake ya ur a kupm ak tolpa, pa kalpm.” ");
INSERT INTO uri_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Tu ntekg yangkipm pa atn, pa Akripa la nasi Pol pa la tolpa, “Ti kitn ti, men ukweitn wang ekg kitn ekla ekg kitn alkitn om!” Yatom Pol kil kat wam pa kaino kwa om kil atn la akalmpe ekla a tu pa. ");
INSERT INTO uri_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Melnum tukgunakgen Akripa, kupm akwonalmpen ari wor wrijen ekg kupm ari kitn ti kul arpm ti, yatom kupm am ti ntekg yangkipm akalmpe yangkipm wrongwailet a pike tu Juta arkiopm pa atn kai ikg a kitn tike. ");
INSERT INTO uri_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ekg nte, kupm ari arie a kitn pa arie worwor ekg yangkipm titnongket, a arpm amen Juta ti, wa yangkipm yiprokgen a men ntekg alilhakel tita pa. Tolpa ti kupm la tolpa kitn eln nungkulkg a kitn pa hi, ekg itning yangkipm a kupm la ti kai plaln pen. ");
INSERT INTO uri_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Tu Juta wrongwailet pa tu ari worwor atn a arpm akupm a pike kupm ntien arpm ha knokg yiprokg alkupmen ti ak wang a kupm pike warim wasikyek ak ai pen, kulngkul, wa ak wang a kupm kinar arpm kinar Jerusalem pa. ");
INSERT INTO uri_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Tu pa pike ari kupm ti hep ak ai. Ti tol tu wakrongen pa, tol wa tu laron tolpa, kupm ti a Parasi. Kupm pike katnun hom wrij ur a tu Parasi a tu eln yangkipm titnongket pa atn, ekg tu akal ukpma Maur Wailen katnun komkiti yangkipm wrongwailet pa yekworwor. ");
INSERT INTO uri_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ti kupm atn ti ekg ntekg yangkipm atn ti pati, ektnen a kupm ukpma arpm nungkwangen kuina ur a Maur Wailen pike yipon yangkipm namponen tu mamikgmamin alpmenen pa akal hi kil ntekg pa. ");
INSERT INTO uri_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ti kil pa yipon yangkipm namponen tu hom wampwam yikakwomwekg (12) alpmenen a tu ukpma arpm nungkwangen ekg akal ari kuina ur a hi paln pa. Tolpa om tu kpor klko lein Maur Wailen pa mning hranen tolpa arpm nungkwangen atn pake. Ti kitn melnum tukgunakgen, apm kupm ukpma a arpm nungkwangen ekg akal ari kuina ur a Maur Wailen hi ntekg pa, tolpa yatom tu Juta arkiopm atn tike. ");
INSERT INTO uri_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Yatom ntekg tolhai ti kipm ti ake wa ukpma tolpa tu men a mo kaingkai pa, hi wa Maur Wailen la om tu wa wreitn yawrik? ");
INSERT INTO uri_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Pike hep kupm yat, kupm akwonalmpen tolpa, al kupm akwap titnongket ekg ak arku nang a Jisas a Nasaret. ");
INSERT INTO uri_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Kupm apm pike akwap tolpa atn kinar Jerusalem pake. Yatom tu melnum ipma krakgen a Maur Wailen a atn hep pa tu pike ro wurkapm wompel pa uk wor kupm ti, yatom kupm wi tu wrong kin kpman wailet a Maur Wailen wiyen ye kai arpm kai wan tipmning. Tu eln ek atn wrij la ekg alm tu pa mo. Wa kupm ti apm pike wa akhmprakel tu pa ekg akal almpen mo yat pake. ");
INSERT INTO uri_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Yatom ak wang wailet pa kupm pike atn hor wan a men Juta atning yangkipm a Maur Wailen atne pa. Kupm pike uk wleket tu wrong kinkpman a ukpma Jisas, wa kupm akal ntekg tu ekg tu la paitnel Jisas pa. Ake pike kupm ak atn ha alkupmen pa tolti pa, kalpm. Nikgwalpm akupm pike wrongken paitn tolti ngko hen, yatom kupm pike wa kai atn hor ha knokg tiur ai, ekg uk wleket tu pa.” ");
INSERT INTO uri_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ak wang wrij ur pa, kupm ngkom kaino Tamaskus atn ekg akal uk wleket tu wrong kinkpman a Maur Wailen. Ak wang ripa pa kupm pike ye wurkapm wompel ur a tu melnum ipma krakgen a Maur Wailen a atn hep ro om uk wor uk titnongket kupm ti ekg akal kupm atn akwap pa. ");
INSERT INTO uri_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Om, kitn melnum tukgunakgen! Kupm kaino ngko ya pa, pa yampingken ekg al takgni no kwarngkwarn tike, pa kupm ari wakg ur a hangken takgni ti, hakaino ktnong pa nar helentopm namponen tu melnum a ntiopm kaino pa. ");
INSERT INTO uri_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ak wang a men ari wakg wail a nar helento pa, men plalnten men ngko eln kai knokg ti. Wa kupm atning ek ur a kwe nang akupm ti ak ek Hipru pa la tolpa, ‘Sol! Sol! Wa kitn uk kalkut a wleket ekg kupm ti ekg nte? Kitn kintirn kweiur a tampij pa, om kitn alkitn wi wleket pa.’ ");
INSERT INTO uri_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Om kupm ropon la tolpa, ‘Oi, melnum wailen, kitn mla pa?’ Om Wailen pa akalmpe la tolpa, ‘Kupm Jisas, kupm melnum a kitn ukopm kalkut a wleket tike. ");
INSERT INTO uri_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ti kitn wreitn itn om! Kupm apm paln arieitn tike, ekg kupm akal akrkahan kitn ekg ak kwap akupm, ekg kitn al laron kuina ur a wet kitn ari ak ti, wa kuina ur a hi kupm planteitn ak wang kanukg pa. ");
INSERT INTO uri_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Kupm hi kwaweitn kai ekg tu a ake Juta pa, wa tu wrong kinkpman alkitnen, ti tu apm hi ukweitn wleket, pake kupm hi ikghlenteitn ariworwor tolpa atn pake. ");
INSERT INTO uri_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Kupm hi wa kwaweitn, ekg hi kitn ntekg ikg a tu pa paln wor, ekg hi tu pleln ipma, ekg uk yirokg mningket pa, wa kul kai klalet, tukulein titnongket a Satan pa om kul kai ekg Maur Wailen, ekg hi kupm kwan paitnpaitn atu, yatom wiyen ye kul arpm namponen tu wrong kinkpman a Maur Wailen akrkahanten om tu ukpma kupm ti.’ ” ");
INSERT INTO uri_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Pol kil wa la hor pa kai tolpa, “Melnum tukgunakgen Akripa, kupm ake ntie ekg talpuln kuina ur a Maur Wailen plantopm ekg kupm ari pa. ");
INSERT INTO uri_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ti hep pa kupm laron yangkipm pa nasi tu Tamaskus pa plaln pa, wa kupm wa kinar laron nasi tu a Jerusalem pa, wa hor ha knokg a Jutia pa, wa laron nasi tu a ake Juta pa yat. Kupm laron nasen tolpa tu al pleln ipma ukpma Maur Wailen, yatom katnun nikgwalpm worwor a Maur Wailen pa, ekg ak plan tolpa tu apm pleln ipma ase. ");
INSERT INTO uri_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Apm yiprokgen ripa yatom tu Juta arkulopm atn kahor yipmingki wonen a wan yalming a Maur Wailen pake, om tu ntekg ekg akal almpopm mo. ");
INSERT INTO uri_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Pike Maur Wailen kil aklinjopm ikghlentopm ariworwor ak ai kulngkul, kul ngko wang kil. Tolpa yatom kupm atn ti laron yangkipm rikil nasi tu wrongwailet kinkpman a nang kalpmen wa nang itne. Ti yangkipm kuina ur kupm la kil pati hirhir tol a pike Moses namponen tu melnum ek wripm a Maur Wailen la ekg hi paln pa. Ake wa kupm laron yangkipm ur manet. ");
INSERT INTO uri_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ti kupm apm wa la tol a pike tu pa la pake la tolpa, Krais melnum a Maur Wailen akrkahan ekg akwi tu wrong kinkpman pa, kil hi ye kalkut om mo, wa kil hi wreitn ha kirkhap pa hep, om laron yangkipm a Maur Wailen a tol wakg a akhelen tu Juta wa tu a ake Juta yat.” ");
INSERT INTO uri_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ak wang a Pol kil la yangkipm pa atn pa, Pestus kil la ak ek wail kai ekg Pol pa la tolpa, “Pol, kitn pa hmit. Kitn wi arie wailet, tolpa yatom ak ntekg kitn hmit paitn tolti.” ");
INSERT INTO uri_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ari Pol akalmpe la tolpa, “Melnum wailen Pestus, kitn ukopm hmit hmit, pake kupm nikgwalpm arkopm wonrekele. Ti kuina ur a kupm la kil pa, pa wor aklahle wrijen. ");
INSERT INTO uri_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Melnum tukgunakgen Akripa, kil ari kweiur kweiur wrongwailet a kupm la ti, ti kupm ntie ekg wa laron kweiur kweiur wrongwailet pa wurknongket kai ikg a nungkulkg alkilen. Ti kupm ari tolpa kil pike atning a ari kweiur kweiur wrongwailet pa ase. Ekg nte, kweiur kweiur wrongwailet pa pike ake ntekg atn wrik hampen ur pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Melnum tukgunakgen Akripa, ti kitn pa ukpma ekg yangkipm a tu melnum ek wripm ro pa aki kalpm e? Kupm ari pa, kitn ukpma pa.” ");
INSERT INTO uri_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ari Akripa pa akalmpe kai Pol pa la tolpa, “Kitn ikwonilmpen ri, ekla waitketn a kitn la ripa, ntie ekg al ak lok nikgwalpm akupm ti, ekg akal kupm ukpma Jisas tike?” ");
INSERT INTO uri_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ari Pol akalmpe la tolpa, “Ekla waitketn aki, ekla wail aki, wa kupm la nasepm ti pa, pa kupm ropon Maur Wailen ekg kil aklin kitn ti, wa tu wrongwailet a atning yangkipm akupm ark ti yat, ekg al kipm ukpma Jisas hirhir tol a kupm alkupm ti. Pake kupm ake wakrongen ekg akal tu yipowepm ak hmpei tol a tu yipowopm ti pa.” ");
INSERT INTO uri_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Tu atning yangkipm pa plaln pa, melnum tukgunakgen Akripa pa kil wreitn. Wa melnum tukgunakgen a atn hep ekg ikghlen ha knokg ripa, wa Pernaisi, namponen tu mla ur a wet arpm namponenten pa, tu wa wreitn yat. ");
INSERT INTO uri_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Tu nuhurn wan a tu arpme pa kai kahor hen, om tu la kitin tita la tolpa, “Melnum pa kil ake pike ntekg kwei ur paitn, yatom tu wiyel ye kai arpm wan tipmning pa, aki tu akal almpel mo pa.” ");
INSERT INTO uri_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Tu ekla tolpa kai om, Akripa pa la nasi Pestus pa la tolpa, “Melnum pa kil alkil pa pike akal kai ntekg yangkipm atn kai ikg a Sisar, melnum tukgunakgen a Rom pa. Kalpm pa, kitn elnten ekg kil kai om.” ");
INSERT INTO uri_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Tu yipon yangkipm ekg men akal wi wan hunokgen pa kai kaino ha knokg Itali. Yatom tu akye Pol pa namponen tu melnum tiur a ntekg paitn a arpm wan tipmning pa eln kai wam a melnum ur a atn hep ikghlen tu melnum kmel wampomit (100) a almpwrong mapming ur a Sisar ikghlen. Nang a melnum ripa Julius. ");
INSERT INTO uri_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Men tpra kaino wan hunokgen a ha wail Atramitium a numprampen ark ekg akal kaino kai hor wrik a wan hunokgen kai arke a atn hor ha knokg a Esia pa. Yatom men wreitn ha pa kaino. Yatom Aristarkus, melnum ur a Tesalonaika a ha knokg Masetonia pa, wa kil ntio yat. ");
INSERT INTO uri_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Men ark wan hunokgen pa tolpa kaino. Kang pa, men paln kaino Saiton ai. Men ark pa, Julius pa kil plan nikgwalpm wor pa kai ekg Pol pa, om wa kil wi wor ekg Pol kil kai ari tu wokg hmprak alkilen pa, ekg al tu ikghlentel wa aklinjel ekg kweiur kweiur tiur a kil warkip pa. ");
INSERT INTO uri_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Wa men wa wreitn ha Saiton pa, wa men akal kai pa, ari wripm wail pa hor titnongket akwi wan hunokgen pa. Tolpa yatom men wa lok wan hunokgen pa wa ye kai kahor yeningken Saiprus ha knokg a ark hunokg kuin pa, ak ngkom no pa kai pake. ");
INSERT INTO uri_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Men wa kwat hor hunokg kuin pa tukulein ha knokg a Silisia, wa ha knokg a Pampilia pa hor pa kai ark kai ha wail Maira a ha knokg a Lisia. ");
INSERT INTO uri_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Men kai paln kai Maira pa, melnum a atn hep ikghlen tu melnum kmel wampomit (100) a almpwrong pa kil wi wan hunokgen ur a tu Aleksantria pa akal kai kaino Itali pa. Yatom kil wi men pa ye kai kaino arpm wan hunokgen ripa. ");
INSERT INTO uri_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Men ark wan hunokgen pa ark wang wailet ai, wampen hal hal tolpa kaingkai kai yampingken ha wail Nitus, ari men ake ntie ekg hor ya a men akal hore pa, ekg nte wripm wail paitn ur pa hor titnongket wail kul nar akwio ye kinar. Om wa men wa nar kwat hor hunokg kuin pa kai kinar aknele Salmone ai, ha wlompen a ha knokg Krit a ark hunokg kuin pa, ak ngkom yeningken tolpa kai. ");
INSERT INTO uri_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Men wampen hal hal tolpa komkiti hunokg yamping a Krit pa, tolpa kai paln kai wrik ur a wan hunokgen arke arke pa, a tu kwe la tolpa Hunokg Kapmet Wor, kai yampingken ha wail a Lasea pa. ");
INSERT INTO uri_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Wang wailet a mento hor yaya pa kul pa kai plaln ase, wa wang wailmanten a tu Juta kalpm ekpma pa yat kai ase. Pa wang paitn a hunokg tupor wail. Ti wang a men akal wa kai ti pa, ti wang paitn om. Yatom Pol akal lok tu pa la tolpa, ");
INSERT INTO uri_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Kipm melnum pa, kupm ari tol mento wi wan hunokgen ti tolpa kai pa, mento al kai wi wang paitn, wa kweiur kweiur wrongwailet atn wan hunokgen ti akal kai paitn plaln. Wan hunokgen ti akal teipurn namponen wrikya ti eln kinar hunokg wonen ai. Wa mento melnum ti yat akal wa eln kinar hunokg wonen ekg al hu mo yat.” ");
INSERT INTO uri_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ari melnum a atn hep ikghlen tu melnum kmel wampomit (100) a almpwrong pa kil ake atning yangkipm a Pol la pa, kalpm. Kil atning yangkipm a melnum a wamparpme yamingkit taklo a wan hunokgen, wa melnum yan a wan hunokgen pa la pake. ");
INSERT INTO uri_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ti wrik ti pa ake wor ekg wan hunokgen pa arke ak wang a wripm wail hor pa. Tolpa ti tu melnum wailet pa tu akwonalmpen tolpa, akal men nuhurn wrik ti kai ikwiyen, tol men ntie ekg kai pa, al men kai paln kai ha wail Piniks ai. Hor pa kai atn nangkin wang a wripm wail pa hor kai plaln pa. Wrik a wan hunokgen pa akal kai atn nangkin kai pa pati, apm atn ha knokg Krit tike, ark ikg kai ari wrik a takgni nare kaino ai wa wrik a takgni nare kinar ai. ");
INSERT INTO uri_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Yatom wripm pa hor waitketn ketn tolti ha kinar hunokg pa no. Tolpa om tu akwonalmpen tolpa, tu ntie ekg katnun nikgwalpm tol a wet tu la pa. Tolpa yatom tu rkoln weij kalkut a ak nampil wan hunokgen pa no kwa ti tolti, wa tu wi wan hunokgen pa tu kai komkiti hunokg arkikg a Krit pa kai. ");
INSERT INTO uri_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ari kalpm. Ake wa atn watin, wripm titnongket wail ur pa hor ha wompel a Krit ti kul nar itne wan hunokgen pa. Wripm pa tu kwe la tolpa “Wripm a hor nar pa hakaino wrik a takgni nowe pa nar pake”. ");
INSERT INTO uri_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Wripm wail paitn kil hor titnongket nar akye wan hunokgen pa kinar. Yatom tu lok wan hunokgen pa ari ake ntie. Tolpa om tu elnten tolti komkiti titnongket a wripm ti lok yeo tolti kai. ");
INSERT INTO uri_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Wripm ti ak loko tolpa ye kaingkai kai ak ngkom Kauta, ha knokg waitketn ur a ark hunokg kuin pa, yatom ak hmpri wripm a kul titnongket pa kai wasok. Yatom men aken kwap wail paitn ekg men rkoln nim hunokgen a ark wan hunokgen yampingken ekg wripm tupor wail ti ye kul no elntarpm wan hunokgen kwa ti. ");
INSERT INTO uri_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Men rkoln ye kul no plaln pa, men akwonalmpen ekg wan hunokgen ti akal kai tupor paitn. Tolpa om men wi hmpei pa ak ningkir wan hunokgen pa titnongket. Wa men kark ekg wripm pa akal akwi wan hunokgen pa ye kai atn wrik hngrapm nimlien ur a tu kwe la tolpa Sirtis pa, wan hunokgen ti akal kai tupor paitn. Tolpa yatom men rkoln hapm a wripm akwi wan hunokgen pa ye kai pa eln nar, wa hunokg pa tupor titnongket akyewo tolpa ye kai. ");
INSERT INTO uri_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Wripm pa hor, wa hunokg pa tupor kai wail paitn akwio titnongket. Om men ark mning pa kai, hor kang ti pa, tu wreitn atn, wa wi wrikya a arpm wan hunokgen pa, piln eln kinar hunokg ai. ");
INSERT INTO uri_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Wa men ark mning ur pa tolpa kai, kai mning nungkwat pa, wa tu alntu nelkgen wa wi kweiur kweiur alkilen a atn wan hunokgen ti ak wam alntu ti wa piln eln kinar hunokg ai. ");
INSERT INTO uri_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Wang wailet pa men ake ari takgni aki kungkumeim ur, kalpm. Wripm pa apm wa hor, wa hunokg pa tupor titnongket tolpa atn pake. Tolpa yatom men akwonalmpen tolpa men ake al atn wor, kalpm. Men wrongwailet akwonalmpen tolpa, men al kai mo plaln. ");
INSERT INTO uri_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ti wang watin a wripm wail hor, wa hunokg tupor titnongket ha pa kul pa, ake men al ekpma ur, kalpm. Yatom Pol wreitn atn kuin atu pa, wa kil la nasen la tolpa, “Kipm melnum pa, ake pike kipm atning yangkipm a kupm la nasepm pa. Tol ake pike kipm wi wan hunokgen ha Krit pa kul ti pa, pa tol ake men wi wang paitn, wa kweiur kweiur wrongwailet atn wan hunokgen ti ake kai paitn plaln. ");
INSERT INTO uri_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Pake ak wang rikil pa kupm la nasepm la tolpa, ipma akipm pa irk mehen wor! Ekg nte, ur akipm ti ake al paitn. Wan hunokgen wrij hute kil pa al kai paitn. ");
INSERT INTO uri_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kupm ti pa kupm melnum a Maur Wailen wa kupm melnum akwapel alkilen, ti wet ak mning ti pa kil kwa maur akwapel alkilen pa nar atn wrik yamping akupm ti. ");
INSERT INTO uri_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Om kil la tolpa, ‘Pol! Kitn ampur kark. Kitn hi kai atn ikg a Sisar. Maur Wailen kil uk tu melnum wrongwailet a ntieitn arpm wan hunokgen ti plalnten kai wam alkitnen pake, la tolpa wrij ur atu pa ake al mo.’ ");
INSERT INTO uri_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Maur akwapel a Maur Wailen wet ak mning la nasopm tolpake. Tolpa ti kipm melnum pa, ampur kipm kark! Kupm ukpma Maur Wailen tolpa kil akal ntekg komkiti tukol kuina ur a wet maur akwapel alkilen la nasopm pa. ");
INSERT INTO uri_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Mento al wor, pake al wripm hute pa yeo kai tolti eln kai ark kai ha knokg ur a ark hunokg kuin ai.” ");
INSERT INTO uri_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Wripm wail hor titnongket wail akwio ye kai ak wakrong a kil alkil yeo kai hunokg wail a Metiterenian pa kai om men ark tolpa kai. Mning wampwam yikakwomwraur (13) pa kai plaln pa, hokg hor kang pa kai yampingken ekg mning kuinkuin ti pa, tu melnum a akwap atn wan hunokgen pa, tu atningke tolpa men yampingken ekg akal kai yampingken hunokg hngrapm ur pake. ");
INSERT INTO uri_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Tolpa om tu piln hmpei pa eln kinar aklan hunokg ti ari watin ha pa. Tu klein ari tukol ntie mita kmel wekg (40). Wa wripm pa wa yeo tolpa kai ketn ketn pa, wa tu aklan nti ur ari ntie mita melmit tuwek wampwam (30), kai yampingken yampingken hngrapm pake. ");
INSERT INTO uri_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Pake tu kark paitn wrijen ekg akal wan hunokgen ti kai al itna weij ur pa, om al tupor. Tolpa yatom tu nelkgen weij kalkut witnweitn ur pa kinar atn wan hunokgen klu pa, piln eln kinar hunokg knokg ai ekg ak arkul wan hunokgen pa ark. Wa tu ropon Maur Wailen ekg takgni akal no aktutu. ");
INSERT INTO uri_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Tu melnum akwapel a atn wan hunokgen pa tu kor ya ekg kark tukulein wan hunokgen pa. Om tu lekg nim hunokgen pa eln kinar hunokg pa akplainel tolpa, tu akal wi weij kalkut tiur alkil a ak arkul wan hunokgen ekg kai ark pa, piln eln kinar hunokg ngko tukgunakgen a wan hunokgen pa. ");
INSERT INTO uri_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ari Pol pa la nasi melnum a atn hep ikghlen tu melnum kmel wampomit (100) a almpwrong pa, wa namponen tu melnum alkilen a almpwrong pa la tolpa, “Tol tu melnum a akwap atn wan hunokgen ti, tol tu kirk nuhurn wan hunokgen ti kai pa, pa kipm ti tol wa kai paitn.” ");
INSERT INTO uri_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Tu melnum a almpwrong pa tu atning tolpa, om tu kwaten hmpei a nim hunokgen a tu lekg eln kinar hunokg pa tukulein, om hunokg ye kai. ");
INSERT INTO uri_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Yampingken ekg takgni no wli pa, Pol tilpen tu pa la tolpa “Kipm wi ekpma pa il om”. Kil la nasen la tolpa, “Wang wampwam yikakwomwitnweitn (14) pa kipm pike kark arpm namponen ipma kalkut paitn wrijen. Pa apm kipm ark tolpa ark ak nikg tolpa ark pake, ake kipm al ekpma ur. ");
INSERT INTO uri_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Tolpa ti kupm tilpentepm titnongket la tolpa ekg kipm wi ekpma ur pa il, ekg al ak titnongketel ipma akipm pa, ekg kipm ntie ekg kai wor. Kipm itning! Kipm ake al paitn, kalpm. Kipm wrongwailet pa al wor.” ");
INSERT INTO uri_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kil la nasen ekla pa plaln pa, kil wi nak tingklak pa ye atn ikg a tu a ark pa, om kil ukwor Maur Wailen pa, yatom kil kpor nak tingklak pa, om kil al. ");
INSERT INTO uri_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Tu ari a kil al tolpa, om ipma a tu pa ark kulkula wor om, yatom tu wi ekpma pa al. ");
INSERT INTO uri_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Men a ark wan hunokgen pa men paln tol kmel 276. ");
INSERT INTO uri_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Tu wi ekpma pa al nti plaln pa, tu wi wrikya ekpma pa piln eln kinar hunokg pa, ekg ak kulkulael wan hunokgen pa. ");
INSERT INTO uri_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Tu ark tolpa kai, nungkwat, pa men ari knokg pa om. Pake tu melnum a akwap atn wan hunokgen pa, tu ake ari hunokg hngrapm a ha kuina ur. Pake tu ari wrik kapmet wor ur a hunokg kahore pa wa hngrapm wor ur hawe. Yatom tu akwonalmpen tolpa, tol tu ntie pa, tu akal ye wan hunokgen pa ye kai kahor ark hunokg hngrapm ripa. ");
INSERT INTO uri_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Tu la tolpa plaln pa, tu kwat hmpei a lekg weij kalkut a ak arkul wan hunokgen pa eln kinar ha hunokg ha pake. Wa tu nelkgen hmpei tukulein yo tmpam wail wekg a ak kwat hu ekg ak lok wan hunokgen pa. Wa tu rkoln hapm wail pa ye kaino lekg ark kaino tukgunakgen a wan hunokgen pa, yatom wripm pa akwi hapm wail pa. Om tu lok wan hunokgen pa ekg ye kai kahor wrik kapmet ripa wa kai hunokg hngrapm. ");
INSERT INTO uri_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ari wan hunokgen pa kai al itna tangirn ur a nip atn hunokg pa. Yatom wan hunokgen tukgunakgen pa kai itna tangirn pa, kahor karn titnongket atn pa tolti, ti ake ntie ekg al kil kai. Tolpa yatom hunokg pa tupor titnongket kul ak kpor wan hunokgen klu pa tupor kai manman paitn tolti. ");
INSERT INTO uri_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Yatom tu melnum a almpwrong pa tu kor nikgwalpm tolpa, tu akal alm tu melnum a pike tu wiyen arpm wan tipmning pa mo plaln ekg ake akal wrij ur atu pa lkgang kai alupm om kark numpworen kai hngrapm pa. ");
INSERT INTO uri_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Pake melnum a atn hep ikghlen tu melnum kmel wampomit (100) a almpwrong pa kil rein Pol, tolpa yatom kil loken ekg ake akal tu almpen mo. Om kil uk yangkipm tu melnum a ntie ekg lkgang pa la tolpa, tu tpra ha wan hunokgen pa eln kinar hunokg pa lkgang hep kai hngrapm pa om. ");
INSERT INTO uri_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Wa tu tiur a akwekgel lkgang pa, pa tu wi yo wompel aki kweiur kweiur wompel wompel a wan hunokgen a hunokg kpor pa, om tu ak lkgang kai hngrapm pa. Apm men ak komkiti ek a melnum a atn hep a tu melnum a almpwrong pa la, om men plalnten kai wor kai hngrapm ase. ");
INSERT INTO uri_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Men plalnten kai wor ark kai hngrapm ai. Men arpm pa, tu la naso la tolpa ha knokg a men arke riti pa Malta, ha knokg a ark hunokg kuin. ");
INSERT INTO uri_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Hu wail wei almpo om wrokgnto paitn wrijen, ari tu a ha yiprokg a atn pa tu planto nikgwalpm wor wrijen. Tolpa om tu wiyo ye kai kanto wakg wailmanten pa ekg men arkgin ark. ");
INSERT INTO uri_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pol kai kor nung tiur pa wi ye kul piln eln kai wakg pa. Ari ul paitn ur a arpm nung ti karken wakg pa kulhor, kai alm Pol pa lekglekg ark wam akil. ");
INSERT INTO uri_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Tu melnum ha yiprokg a ark pa, tu ari ul a lekglekg ark wam a Pol pa, yatom tu la nasi tita la tolpa, “Melnum ripa melnum ur a alm melnum mo pa ur pake. Ti tol wet kil wa mo kai hunokg ai, ari kalpm, kil kul hngrapm ti. Tolpa ti ul pa almpel pa pati, maur a akalmpe paitn a mento ntekg pa almpel mo pake.” ");
INSERT INTO uri_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ari Pol haliken wam ul pa eln kai wakg ai. Wa ake kil wi paitn ur itnen a ul pa almpel, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Yatom tu atn ari tolpa al num a Pol pa al hurn, aki kil wa ngko mo eln kai knokg ai, ari kalpm. Tu atn nungkwangen wang watin, ari ake tu ari kweiur a paln kai num a Pol pa. Om tu pleln nikgwalpm atu pa la tolpa, plpa kil maur ur. ");
INSERT INTO uri_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Knokg a atn yampingken wrik ti pati, a Puplius, melnum a atn hep ekg ikghlen tu wrong kinkpman a ark ha knokg a ark hunokg tike. Melnum pa kil wiyo ye kai wan ha alkilen pa ikghlento ariworwor. Wa men ntiel ark pa wang wraur. ");
INSERT INTO uri_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ti yan a Puplius pa kil numpet hantin walmpopm numwakget paitn kalkut ha wrik ai. Yatom Pol kil kahor ariel kahor wan alkilen pa, om ropon Maur Wailen, wa eln wam pa hel num akil pa, om numpet a kil pa apm paln wor ase. ");
INSERT INTO uri_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Tu ari a kil ak tolpa, yatom melnum numpet tiur a ark ha ripa, tu ye numpet alntu pa ye kul, ekg Pol ropon Maur Wailen ekg aklin numpet atu pa, om numpet atu pa apm paln wor. ");
INSERT INTO uri_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Tu a ha ripa tu kat nang amen ti, om uko ipma wor ikghlento ariworwor. Men akal numprampen ekg wi wan hunokgen ur ekg wa kai pa, tu kor tita kweiur kweiur a men warkip pa, tu ye aklanto ye kai alupmto kai wan hunokgen ai. ");
INSERT INTO uri_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Men ark ha knokg Malta pa kainil wraur plaln, wa men wi wan hunokgen ur a pike kul ark hunokg yamping a Malta ti, ark nangkin wripm wail a hor pa. Wan hunokgen pa pati, kai ha wail Aleksantria. Tu hpar yo tkatet ur kalingken tukol maur wekg a tu kwe la tolpa Kastor ekg Poluks, a ikghlen wan hunokgen pa yatom pike elntatn hep atn wan hunokgen pa. ");
INSERT INTO uri_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Men wa wi wan hunokgen pa nuhurn Malta ti wa kaino ha wail Sirakyus pa arpm wang wraur. ");
INSERT INTO uri_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Men wa wreitn ha pa kaino ark kaino ha wail Rekium pa. Men hokg ark pa hor kang ti, ari wripm hor hakinar yirokg pa no akwio, yatom wang wekg pa apm men hor hunokg pa kaino paln kaino ha wail Puteoli ai. ");
INSERT INTO uri_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Om kaino ha ripa men hantil tu melnum ipma wrij tiur a men ukpma Krais pa. Tu roponto ekg men akal ntien ark pa wang wampomit wampomwekg pa pen. Yatom men ntien ark pa kai plaln pa, wa men wreitn ha pa, men akal wa kaino ha wail Rom. ");
INSERT INTO uri_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Tu melnum ipma wrij a men ukpma Krais a ark kaino Rom pa, tu atning tolpa men kaino pake, pa tu kul nar atnto atn ya tolpa nar ngko wrik a tu armpen ekpma atne ha ya wail a tu kwe la tolpa Apius. Wa men ngkom tolpa wa kaino pa, om men hantil tu tiur ngko ya a ha wail a tu kwe la tolpa Wan Wraur a tu kai armpen ekg hokg atne pa. Pol kil ikg kaino ari tu pa, kil utopen paitn wi titnongket kai tu pa, om kil ukwor Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Men kaino paln kaino ha wail Rom pa. Pa tu melnum tukgunakgen a ikghlen Rom pa, tu wi wor ekg Pol akal arpm ak wrij arpm wan ur manet, wa melnum wrij ur a almpwrong pa atnentel atn. ");
INSERT INTO uri_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Pol kil arpm wan ripa pa wang wraur pa plaln, om kil kwe tu melnum wail wail a tu Juta pa tu kul ark wrij. Tu plalnten kul ark wrij plaln pa, kil la nasen la tolpa, “Kipm wasokwasok a wailwail alkupmen! Kupm ti pike ake ntekg kwei ur paitn, ekg ak arku nang a mento Juta pa, aki la paitnel arpm a atn a tu mamikgmamin manjan amento pa, kalpm. Kupm pike tu arkulopm wiyopm ye kahor arpm wan tipmning a Jerusalem, wa tu uk kupm ti kai wam a tu Rom pa kalpmel tolti. ");
INSERT INTO uri_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Yatom tu wiyopm ye kai atn ntekg yangkipm. Tu atning yangkipm akupm la pa, ari ake tu hantil paitn ur a kupm ntekg, ekg akal tu almpopm mo pa, kalpm. Tolpa om tu akal kwantopm ha wan tipmning pa kulhor kai hen. ");
INSERT INTO uri_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ari tu Juta pa hret la tolpa, ake akal eln kupm ti kahor hen pa. Ya wrongwailet pa tu hmprinjopm plaln, ti ya wrij hute al kupm la nasen la tolpa, yangkipm akupm pa al ye kai ntekg atn ikg a Sisar pa. Pake kupm ake akal arki yangkipm ur ekg tu a mento alpmento ti, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Yiprokgen a kupm kwewepm kul ekg al ariepm a ntiepm ekla kil pati, ektnen a kupm ukpma a arpm nungkwangen kuina ur a pike Maur Wailen yipon yangkipm namponen tu mamikgmamin manjan alpmento Israel ekg akal kil hi ntekg pa. Apm yiprokgen ripa yatom tu kutentopm elntarpm wan riti.” ");
INSERT INTO uri_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Pol la nasen tolpa yatom tu akalmpentel la tolpa, “Men ake wi wurkapm ur a tu a ha knokg Jutia pa ro hakai ha pa kul ekg ak la naso kitn pa. Wa tu melnum ur amento Juta a hakai pa kul pa, ake wa tu la naso aki la kitinto la tolpa kitn pa paitn pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Pake men wakrongen akal atning nikgwalpm ekla ur a kitn la kiti Jisas pa. Ekg nte, men ari tolpa tu wrong kinkpman hor pa hor pa, tu la paitnel tu weten tiur a men Juta a ukpma Jisas pa.” ");
INSERT INTO uri_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Tolpa om tu alm wang namponen Pol, akal wang ur pa tu kul ariel. Yatom ak wang a tu alm pa, tu wrong kinkpman wailet ketn ketn, tu kai wan a Pol kil arpme pa. Om ak kang pa kaingkai ngko nungkutikg pa, kil la nasen ariworwor a laron nasen ekg Kingdom a Maur Wailen pa. Wa kil wi yangkipm titnongket a Moses, a yangkipm a tu melnum ek wripm a Maur Wailen pa, ekg akal ak pleln nikgwalpm a tu pa wi arie ariworwor tolpa, Jisas pa melnum a tu nungkwangen pake. ");
INSERT INTO uri_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Yatom tu tiur a atning yangkipm a Pol la kiti pa, akwonalmpen tolpa, pa aklahle. Pake tu tiur pa tu ake atning ukpma yangkipm a Pol la kiti pa. ");
INSERT INTO uri_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Tolpa om ipma a tu pa atn manman nowe nare, yatom tu akal wreitn kai. Ari Pol kil la nasen yangkipm ur pa la tolpa, “Maur Wor kil la yangkipm aklahle nasi tu mamikgmamin manjan alkipmen, pike la wli ek a melnum ek wripm Aisaia pa la tolpa, ");
INSERT INTO uri_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Kitn kai ri tu wrong kinkpman kil, yatom kitn la nisen la tolpa, “Kipm hi atning atning kalpmel pake kipm hi ake ari yiprokgen alkilen pa. Kipm hi ari ari pake kipm hi ake ari kuina ur a paln pa. ");
INSERT INTO uri_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kitn kai la nisen la tolpa, ekg nte, ipma a tu wrong kinkpman pa apm kakren paitn ase. Nungkulkg atu ake wor ekg atning, wa tu hmpri ikg alntu ti, om tu ake al ari kwei ur, ake al nikgwalpm atu pa wa hompen wonrekele wi arie yiprokgen a yangkipm a kupm kil, ekg ake al tu pleln ipma wa kul ekg kupm, ekg al wa kupm aklinjen, ekg tu paln wor pa.” ’ ” ");
INSERT INTO uri_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Pol kil la kiti ekla a Aisaia melnum ek wripm pa la pa apm kai tolpake. Wa kil wa la tolpa, “Kipm hret uk yirokg a atning, tolpa ti kupm la nasepm ekg kipm ari tolpa, yangkipm wor a la kiti kwap wor a Maur Wailen pike kil ak ekg akwi mento wrong kinkpman pa, apm pike kil kwa kai ekg tu a ake Juta ase. Ti tu pa tu hi atning ukpma pake.” ");
INSERT INTO uri_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pol kil arpm wan alkilen a kil armpen uk melnum yan a wan pa tolpa kaingkai wring wekg miten. Kil ukwor tu mla ur a kul ariel pa. ");
INSERT INTO uri_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Kil ake kark aki melnum ur lokel, kalpm. Kil atn wrongken tolti, laron nasi tu wrong kinkpman ekg Kingdom a Maur Wailen, wa ro tukgunakg lngkep a tu ekg yangkipm wor a la Wailen Jisas Krais pa.");
INSERT INTO uri_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","Kupm Pol namponen Timoti, mentekg melnum a ak kwap kalpmel horhanekg a Krais Jisas, mentekg ukwor kipm wrong kinkpman wri wor a Krais Jisas a ark kai ha wail Pilipai pa. Mentekg ro wurkapm rikil ekg kipm, namponen kipm melnum a atn hep ikghlen kwap a Maur Wailen, wa kipm melnum a ak kwap ekg aklin tu melnum. ");
INSERT INTO uri_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","Kupm ropon Maur Wailen, Yan amento, namponen Wailen Jisas Krais, ekg al tuwekg reinjepm ekg al ukwepm ipma mehen wor. ");
INSERT INTO uri_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","Aklei wang a kupm akwonalmpentepm pa, kupm ukwor Maur Wailen alkupmen. ");
INSERT INTO uri_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","Kupm aklei wang utopen ekg ropon Maur Wailen ekg aklin kipm wrongwailet. ");
INSERT INTO uri_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","Kupm ukwor Maur Wailen ekg nte kipm ntio ak kwap wrij ekg laron yangkipm wor a Krais pa, hep ak ai a kipm ukpma Maur Wailen pa kulngkul kul ngko wang ti. ");
INSERT INTO uri_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","Tolpa ti kupm ari tolpa ase, Maur Wailen alkil a pike katen kwap wor kahor ipma alkipmen pa, kil alkil hi apm ak kwap tolpa kahor ipma alkipmen pa ye kaingkai, kai ro hmpu la ak wang a Jisas Krais kil wa nar. ");
INSERT INTO uri_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","Kipm ark nikgwalpm akupm, ti wor wrijen ekg kupm akwonalmpentepm tolpa. Kupm ari kipm pa alupm nikgwalpm worwor hirhir tol nikgwalpm worwor a Maur Wailen kil uk kul kupm ti, yatom kipm aklinjopm ak wang a kupm arpm wan tipmning ti, wa ak wang a kupm pike atn ak titnongketel yangkipm wor a la ekg Krais pa, atn minjirangket talpuln yangkipm a tu alilopmhak. ");
INSERT INTO uri_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","Maur Wailen kil ari tolpa, kil kupm la aklahle wrijen: nikgwalpm wail a kupm pa akwonalmpentepm ark, tol nikgwalpm a Krais Jisas kil akwonalmpentepm ark pa. ");
INSERT INTO uri_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","Kupm ropon Maur Wailen ekg al kil aklin kipm pa, ekg al kipm ukpma wakrongen tita ye hor pa kai wail, ekg al arie alkipmen ti wa nip ye kaino watin, a kai wail, wa nikgwalpm alkipmen ti al hompen wonrekele wor, ekg al kipm ntie ekg ari kuina ur a wor, kuina ur a paitn. ");
INSERT INTO uri_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","Wa kupm ropon Maur Wailen pa ekg al kipm ntie ekg elnten paitn pa atn, wa wi kuina ur a wor wrijen ai, ekg al kipm arpm wri wor tolti, ekg ake ntie al melnum ur arkiepm tolpa, kipm melnum a ntekg paitn pa, tolpa ye kaingkai ngko wang a Krais kil wa nar. ");
INSERT INTO uri_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","Jisas kil alkil aklinjepm ekg kipm ntie ekg katnun nikgwalpm nipet wor a ngko ek arke wailet wor. Tu wrongwailet ari pa, pa tu ukwor kat nang a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","Kupm wakrongen tolpa al kipm yanipopm muitnwar pa, kipm ari tolpa, kalkut a palntopm kil pati, ampur kipm ipma kalkut la tolpa, pa ak hangken kwap a laron yangkipm wor a Krais pa, kalpm, pa paln ekg ak titnongketel kwap ripa. ");
INSERT INTO uri_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","Tolpa ti tu melnum wantengkwang a ark wan wail a Sisar, a atnen wanyun ti, a tu tiur hor ai, tu ari tolpa, kupm arpm wan tipmning ti ekg nte kupm melnum a ak kwap a Krais. ");
INSERT INTO uri_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","Wa tu ipmawrij wailet a men ukpma Krais a atn kil pa, tu ari titnongket a Maur Wailen aklinjopm arpm wan tipmning kil, yatom pa ak titnongketel tu pa, om tu ake wa kark, tu atn titnongket laron yangkipm a Maur Wailen tolpa kai. ");
INSERT INTO uri_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","Aklahle pake, tu tiur pa ipma paitn akal no atn hangken kupm ti, yatom tu laron nang a Krais pa. Pake tu tiur pa nikgwalpm wor yatom laron nang a kil pa ak ipma wor. ");
INSERT INTO uri_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","Tu wakrongentopm, ekg nte, tu ari Maur Wailen kil ukopm kwap ekg akal atn ekg talpuln yangkipm a tu a la paitnel yangkipm wor a Krais pa, yatom kupm planten tolpa pa yangkipm aklahle wrijen. ");
INSERT INTO uri_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","Tu a laron nang a Krais ak ipma paitn ti pa, tu akwonalmpen tu alntu ti tolti akal wi nang wail hangken kupm ti. Ari nikgwalpm a tu pa ark raimpen, tu akwonalmpen tolpa tu wa ukopm kalkut tiur ak hangken kalkut a kupm ye arpm wan tipmning ti. ");
INSERT INTO uri_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","Ti ante! Pa wor wrijen ekg ya wailet atn ekg tu laron yangkipm a Krais. Tol tu laron ak ipma akplain aki ak ipma aklahle aki, kupm ti utopen tolti ekg tu laron nang a kil tolpa kai pake. Pa kupm utopen tolti ye kai. ");
INSERT INTO uri_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","Kupm utopen ekg nte kupm ari kipm ropon Maur Wailen pa ekg aklinjopm, wa kupm ari Maur Wor a Jisas Krais pa wa aklinjopm yat, tolpa ti hi ake kalkut ti lok yipowopm, kupm hi hangken yangkipm pa. ");
INSERT INTO uri_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","Pike hep ak ai pa kupm ake kark ekg laron yangkipm a Krais pa kulngkul ak wang ti. Ti apm wa tolpa yat, kupm arpm nungkwangen a wakrongen paitn tolpa, arpm a atn a kwap a kupm ak pa al ak kat nang a Krais. Kupm arpm aki kupm mo e, pa ak kat nang a Krais pake ekg kupm hi ake wi numpaitn kai ikg a kil pa. ");
INSERT INTO uri_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","Tol kupm ake mo pa, tol kupm arpm knokg ti pa, kupm akal kat nang a Krais pa tolpa kai pake. Pake tol kupm mo pa, pa wa wor wrijen hangken pa. ");
INSERT INTO uri_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","Tol kupm ake mo, kupm arpm pa, al kwap a kupm ntekg hi ngko ek arke wailet tolpa ye kai. Tolpa ti kupm ake ari al kupm komkiti ya hai, kupm mo aki kupm arpme. ");
INSERT INTO uri_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","Nikgwalpm akupm ti pa ark wekg wekg ark ti: nikgwalpm ur pa kupm wakrongen paitn tolpa, kupm mo nuhurn knokg ti kai nti Krais pa irpm, pa tol wor wrijen. ");
INSERT INTO uri_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","Ari wa kupm akwonalmpen tolpa, tol kupm arpm ti pa hi kupm ak kwap tolpa kai pa, pa wor ekg akal aklinjepm. ");
INSERT INTO uri_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","Kupm ari tolpa kwap wail atn ekg kupm arpm ekg ak pen, tolpa ti kupm ari tolpa kupm hi ake mo pen, kupm hi arpm. Kupm hi nti kipm wrongwailet arpm ekg aklinjepm ekg kipm ukpma Maur Wailen ti atn titnongket tolpa kai, ekg al kipm utopen ark. ");
INSERT INTO uri_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","Ti ak wang a kupm hi wa palntepm pa, kipm hi kat nang a Krais Jisas pa utopen wailmanten paitn ekg ari kuina ur a Jisas ntekg ekg kupm ti. ");
INSERT INTO uri_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","Kwei ur wail wrij ur tol a kipm katnun pa pati kil: kipm al atn a arpm katnun yangkipm wor a la kiti Krais! Tol kupm kai ariepm aki, tol kupm arpm ti atning aki, pa kupm akal atning tu la kiti kipm alupm nikgwalpm wrij ak kwap hor wrij atn titnongket talpuln wrongmnto ekg al tu wrong kinkpman ukpma yangkipm wor a la kiti Krais pa. ");
INSERT INTO uri_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","Wa kupm akal atning tolpa, kipm ake kark ekg wrongmnto alkipm pa, kalpm. Kipm atn titnongket tolpa, pa klal ur a Maur Wailen elntha ekg ak plan tu wrongmnto tolpa, tu pa hi kai ha paitn pake, wa ak plan kipm pa tolpa, kipm pa Maur Wailen aklinjepm pake, ti kipm hi atn wor wrijen. ");
INSERT INTO uri_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","Maur Wailen kil ntekgepm wor, om kipm ukpma Krais pa. Ake wa kipm ukpma tolti hute, kipm ye kalkut pa yat ekg nte kipm ukpma Krais. ");
INSERT INTO uri_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","Tolpa yatom kipm ye kalkut wrij tol pike kipm ari a kupm ntiepm arpm kai pa yatom kupm ye pa, wa ak wang ti kipm wa atning a kupm ye kalkut tolpa atn ti yat. ");
INSERT INTO uri_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","Ak wang a ake kipm titnongket pa, Krais pa akepm titnongket aki? Kil ukpma wor wakrongentepm, tolpa om ak ntekg ipma akipm pa arpm mehen wor aki? Yatom Maur Wor kil pa wiyepm ye kai hor wrij, tolpa om kipm nikgwalpm wor rein tita lokli tita aki? ");
INSERT INTO uri_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","Ti kupm la nasepm titnongket la tolpa, al kipm alupm nikgwalpm wrij, kipm plalnten ukpma wor wakrongen tita, wa kipm irk hor wrij kor tita. Kipm ak tolpa pa, kupm utopen wailmanten paitn ekg kipm. ");
INSERT INTO uri_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","Ampur kipm akwonalmpen kipm alkipm ti tolti, yatom kipm ntekg kweiur kweiur pa ekg kipm akal wi nang wail hangken tu tiur ai, tolpa yaper. Kipm rku kipm alkipm ti ye nar horhanekg ekg mla ur ai, kipm kit nang a tu pa, la tolpa tu pa wor pake. ");
INSERT INTO uri_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","Kipm wrij wrij atning ari kuina ur a tu tiur manet wakrongen pa, yatom kipm iklin tu pa hep pen. Ampur kipm akwonalmpen kipm alkipm pa akal aklin kipm alkipm ti hute, pa kalpm. ");
INSERT INTO uri_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","Nikgwalpm a kipm pa, apm kipm alupm nikgwalpm tol a Krais Jisas alkil pake: ");
INSERT INTO uri_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","Krais kil alkil apm hirhir tol Maur Wailen pake, ari kil ake wa akal nampil nang wail alkil pa atn pa atn. ");
INSERT INTO uri_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","Kil nuhurn nang wail alkil a hirhir tol Maur Wailen pa. Wa kil paln tol melnum a ak kwap kalpmel horhanekg ekg melnum ur tolti. Kil pike man rakuel paln melnum tol mento tike. ");
INSERT INTO uri_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","Kil arku kil alkil atning nungkulkg hor hanekg ekg Maur Wailen. Kil atning nungkulkg tolpa kaingkai, tu karkurntel kai yo kwatingki pa om kil mo. ");
INSERT INTO uri_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","Kil arku kil alkil tolpa yatom, Maur Wailen wiyel ye kaino ukwel nang wail a atn hep hangken nang wrongwailet. ");
INSERT INTO uri_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","Kil uk nang ripa ekg Jisas, ekg kweiur kweiur wrongwailet a atn kaino ktnong pa, a atn hor knokg ti, a ark kinar knokg wonen pa, tu hi eln nar kpor klko leinjel, horhanekg ekg kil wrij hute. ");
INSERT INTO uri_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","Hi wa tu wrongwailet a ark hor pa laron nang a Jisas Krais ti la tolpa, kil pa Melnum Wailen a atn hep, yatom ak kat nang a Maur Wailen, Yan Wailen pa. ");
INSERT INTO uri_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","Tolpa ti kipm melnum wokgen yikek alkupm, aklei wang kipm atning nungkulkg ak wang a pike kupm ntiepm arpm kai pa. Pake wailmanten pa pati, kipm itning nungkulkg ik wang ti a kupm ake ntiepm arpm. Tolpa ti kipm kirk kwarkwar kai ikg a Maur Wailen pa, ukpma Jisas titnongket tolpa ye kai, ekg nte kil apm pike aklin akwiyepm ase. ");
INSERT INTO uri_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","Pa ekg nte Maur Wailen kil alkil pa kil yiprokgen, yatom kil ntekg kipm utopen ekg atning nungkulkg, wa ukwepm titnongket pa, yatom kipm ak kwap katnun nikgwalpm wakrongen a kil wrij hute. ");
INSERT INTO uri_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","Kweiur kweiur wrongwailet a kipm akal ntekg pa pati, ampur kipm ekla wailet ak kiti ekel tita ekg yangkipmek tiur pa, yaper. ");
INSERT INTO uri_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","16","Ekg ake al melnum ur lawepm tolpa, kipm pa melnum a ntekg paitnpaitn pa, kalpm. Kipm arpm hrukij wri wor tol warim wor a Maur Wailen. Kipm arpm knokg mningket a tu melnum a ntekg paitnpaitn arke, yatom nuhurn ya nipet, wa ngkom hor ya raimpen pa. Al kipm ye yangkipm a Maur Wailen a arpm aklei wang pa laron ak aklin tu pa ekg tu atning katnun pa, om hi wa tu arpm wor aklei wang. Kipm pa tol wakg a ak helen ya ekg tu pa ngkom hore. Tol kipm ak katnun ye tolpa kai pa, kupm hi wa utopentepm paitn tpra ak wang a Krais kil wa nar pa, pa ak plan tolpa kwap wail a pike kupm ntekg ekg aklin kipm pa, ake kupm ak kalpmel. ");
INSERT INTO uri_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","Pike kipm ukpma Maur Wailen tol kipm al wor uk kipm alkipm kai ekg Maur Wailen. Tol tu ntekg akal almpopm ur pa, kupm utopen. Tol walmpopm akupm ti ungkwan ekg ak kaluk kipm pa namponen al wor uk a kipm alkipm ti kai ekg Maur Wailen ti pa, kupm hi wa utopentepm yat. ");
INSERT INTO uri_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","Tolpa ti kipm apm wa tolpa yat pake. Kipm utopen namponentopm pa, tol kupm wa utopen ntiepm yat! ");
INSERT INTO uri_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","Kupm akwonalmpen tolpa, wakrong a Wailen Jisas ti pa, kupm akal kwa Timoti kil ak ketn ur ti kai atn ariepm atning ariepm tolpa kipm ark tolhai, plaln pa, wa kil kul la nasopm tolpa kipm ark wor pa, ipma a kupm pa kulkula wor om. ");
INSERT INTO uri_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","Ake kupm ari melnum ur a nikgwalpm ark ekg kipm pa tol kupm ti pa, kalpm. Kupm ari tol Timoti wrij hute tolti kil nikgwalpm ark ekg kipm pake. ");
INSERT INTO uri_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","Ari tol wrongwailet ti nikgwalpm rein akwonalmpen kuina ur a tu alntu ti tolti. Ake tu nikgwalpm rein kwap a Jisas Krais ti. ");
INSERT INTO uri_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","Pake kipm apm ari Timoti pa kil melnum wor a atn titnongket ye kalkut. Kil apm pike nti kupm ti atn tukol warim alkupmen pake, om kil aklinjopm ekg mentekg ak kwap ekg yangkipm wor a Krais. ");
INSERT INTO uri_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","Ti kupm akal hi kwa Timoti kil alkil pa kai ariepm pake. Ari kupm akal atn nungkwangen yangkipm alkupmen kil pen, tu ntekg yangkipm akupm kil kai tolhai plaln pa, kupm kwawel kai pake. ");
INSERT INTO uri_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","Ti kupm alkupm ti yat, kupm ari tolpa Wailen hi aklinjopm pa, ti kupm arpm nungkwangen tolpa kupm hi wa ak ketn ur ti katnuntel kai ariepm pake. ");
INSERT INTO uri_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","Kupm wa akwonalmpen yat tolpa hi kupm kwa Epaprotitus ti wa kaintepm. Melnum yek pa pike kipm kwawel kul tol melnum yangkipm kuinen alkipmen yatom kil aklinjopm ekg kwap hlaikip wrongwailet. Kil pa tukol wasok alkupmen, kil pike ntiopm ak kwap wrij. Mentekg yaten pike ye kalkut ekg talpuln tu a la paitnel yangkipm a Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","Pike tu ur la nasepm tolpa kil ti numpet paitn, yatom kipm ipma kalkut ekg kil. Kil atning pa, yatom kil nikgwalpm ark ekg kipm paitn tolpa kil akal kai ariepm, ti kupm akal kwawel kai pake. ");
INSERT INTO uri_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","Ei, aklahle, kil apm pike wi numpet wail akal tol mo pake. Ari apm pike Maur Wailen kil alkil pa akmekgel reinjel yatom aklinjel, ti kil paln wor arpm pa. Ake kil rein kil wrij pa, kalpm, wa kil wa rein kupm ti yat, tolpa ekg ake wa ye kalkut ur pa wa ye kul ak arkuopm hangken kalkut a kupm ye kil pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","Tolpa ti kupm wakrongen paitn ekg al kwawel kai pake. Ak wang a kil kai palntepm pa, kipm utopentel om! Tolpa ekg hi wa ntekg ipma alkupmen ti wa kai kulkula ketnketn. ");
INSERT INTO uri_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","Kipm ukwel wor utopentel tol kil melnum ur a ukpma Wailen. Kipm wiyel tol melnum ur a nang itne, ");
INSERT INTO uri_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","ekg nte melnum yek pike uk num alkilen ti kai ekg ak kwap a Krais, kil wi numpet wail akal mo akarmpen kwap a kil pa. Kil ari tolpa kipm pa arpm watinet, ake ntie ekg al kipm kul aklinjopm, tolpa yatom kil ti wi wrik a kipm pa kul aklinjopm tike. ");
INSERT INTO uri_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","Yangkipm a wet kupm la hep pa, kai ekg al plaln pake. Kipm yanipopm muitnwar a kupm pa, kipm a Wailen pa ti kipm irpm utopen tolpa kai om! Kupm ake hretopm num lpmahak ekg wa la yangkipm a pike kupm rontepm hep pa. Pa wor ekg al kipm atning hep kanukg tolpa kai ekg al aklin kipm pa, ekg hi wa aklinjepm pake. ");
INSERT INTO uri_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","Tu tiur pa la tolpa, ake kipm kwat numpalk katnun ya a men Juta pa, kipm pa ake warim a Maur Wailen pa. Pake tu akplain. Tu pa tu melnum a kwat numpalk alntuen ti yehngkalel ari paitn. Tu pa tu melnum a ak kwap paitn tol nmpa mingken a nam kmel pa. Ti kipm ngkom nlokgen ukikg ri tu melnum a tolpa! ");
INSERT INTO uri_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","Ekg nte, tol mento kwat numpalk yatom mento la tolpa mento apm paln nipet wor kai ikg a Maur Wailen ase, pake ake tolpa. Mento wi Maur Wor yatom, mento kpor klko lein Maur Wailen, a mento utopen kat nang a Krais Jisas ekg kwap a pike kil akto pa, pati, pa tol mento kwat numpalk aklahle pake. Mento ari tolpa kuina ur a mento melnum ti ntekg kai num a melnum ti pa, pa ake ntie ekg ntekg melnum ti paln nipet wor kai ikg a Maur Wailen pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","Tol kupm kat nang a kupm alkupm ti ekg kuina ur pa, kupm ntie, ekg nte, tol kupm ti wa la komkiti yipuk a yiprokg alkupmen ti pa, pa wailet paitn. Tol mla ur kil akwonalmpen la tolpa kil ntie ekg kat nang a kil alkil pa, wa kil ari yat tolpa, wa kupm ti ntie ekg kat nang alkupmen ti hangken kil pa yat. ");
INSERT INTO uri_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","Tol kupm la kiti yipuk a yiprokg alkupmen pa pati tolkil: kupm pike man rakuopm, arpm wang wampomit wampomwraur plaln pa, tu kwatopm numpalk ti. Yiprokgen a kwat lei men Juta ti kulngkul ti pa, apm Israel pake. Israel wa kwat Penjamin, Penjamin wa kwat lei kulngkul kwat kupm tike. Tu mamikgmamin manjan alkupmen pa tu apm a Juta pa tolti hute tike. Kupm a Parasi, tolpa ti yangkipm titnongket a Moses, a tu mamikgmamin manjan a men pa kupm alupm worwor, yatom kupm katnun yekworwor. ");
INSERT INTO uri_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","Kupm pike atn titnongket katnun yangkipm titnongket a Moses ti pa, apm kupm tike, yatom kupm er tu a ukpma katnun Jisas pa ukwen wleket kwanten. Wa tu wrong kinkpman pike ari atn a arpm akupm pa namponen yangkipm titnongket a Moses, a tu mamikgmamin manjan alpmenen pa, ake pike tu ur ari kupm ti lalo yangkipm ur pa, kalpm. Kupm pike katnun yangkipm titnongket pa yekworwor. ");
INSERT INTO uri_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","Kweiur kweiur a wet kupm la tolpa a pike ak kat nang alkupmen pa, pa pike kupm ari tolpa pa wor ak aklinjopm. Ari wa kupm ukpma Krais ti, yatom kupm ari tolpa kweiur kweiur a tolpa pa ake wor, ake ntie ekg aklinjopm. ");
INSERT INTO uri_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","Ake kweiur kweiur a wet kupm la ti hute, kalpm, kweiur kweiur wrongwailet ti apm kupm kwan, pa paitn, ekg kupm al wi arie a Krais Jisas, Wailen alkupmen a atn hep wor wrijen hangken kweiur kweiur wrongwailet ai. Kweiur kweiur wrongwailet pa kupm kwan tol yipik klain paitn a mento piln kai hup yipik pa, ekg kupm nampil Krais pa atn titnongket pake. ");
INSERT INTO uri_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","Wa ekg nikgwalpm akupm ti kai irk wrij namponen kil. Pike kupm katnun yangkipm titnongket a Moses, a tu mamikgmamin manjan pa ake wa ntekg kupm ti nipet wor kai ikg a Maur Wailen pa. Tolpa yatom kupm ukpma Krais pa, ekg al kupm paln nipet wor kai ikg a Maur Wailen. Kupm ukpma Krais pa, yatom Maur Wailen kil alkil pa ntekg kupm paln nipet wor kai ikg alkilen pake. ");
INSERT INTO uri_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","Kweiur kweiur wrongwailet apm kupm uk yirokg ase, ekg kupm akal ari Krais ekg paln tukol kil, wa kupm akal ari titnongket tukol a pike kil wreitn ha kirkhap pa. Wa kupm akal ye kalkut tukol a pike kil ye pa, tolpa kaingkai mo tol a pike kil mo pa. ");
INSERT INTO uri_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","Wakrong a Maur Wailen la pa, pa hi kupm wreitn ha kirkhap pa, pa hi kupm wreitn. ");
INSERT INTO uri_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","Kupm ake akwonalmpen tolpa kupm aktutu kai ngko wrik a kai elnten pa, kalpm, ha pa, kupm aktutu atn ya atn pa. Kupm ake la tolpa kupm ti wor wrijen ase, tolpa kalpm. Kupm nikgwalpm ark ekg aktutu ti pen, ekg akal wi Krais Jisas ti tol kwei ur wor a tu aktutu ak wampol tita akal wi pa, tol pike kil wi kupm ti ekg alkilen pa. ");
INSERT INTO uri_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","Kipm yanipopm muitnwar pa, apm aklahle pake, ake kupm akwonalmpen tolpa kupm aktutu kai paln wrik a wi kweiur kweiur wor ase. Pake nikgwalpm wrij hute a kupm akwonalmpen pa pati, kupm akal aktutu ikg itna ya tolti kai pake, ake wa ikg hel yirokg pa. ");
INSERT INTO uri_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","Ti kupm nikgwalpm arke aktutu atn ya atn pa ekg akal kai ngko wrik a elnten pa, ekg akal wi lukglukg worwor a pike Maur Wailen aknamput tu melnum a ukpma Krais Jisas pa la tolpa hi tu kaino wi kaino ha wor alkilen aiyul. ");
INSERT INTO uri_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","Mento wrongwailet, nikgwalpm amento ti pa ark tol kin nangkor a mel nangkor pa, mento apm al alupm nikgwalpm worwor tol a wet kupm la nasepm pa. Tu tiur a alupm nikgwalpm manet pa, hi wa Maur Wailen planten nikgwalpm wor alkilen pa, ekg tu katnun. ");
INSERT INTO uri_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","Mla ur a kil hep aki ngko kuin aki kanukg pa, pa apm nte, pake wailmanten pa pati, mento plalnten kai ekg katnun tita hor ya wrij pa kai pake. ");
INSERT INTO uri_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","Kipm yanipopm muitnwar pa, pa kipm ri atn a arpm akupm ti, yatom kipm kutnun! Wa kipm ri tu tiur a katnun yikak mlik a kimpron a pike men ngkom hore pa, kipm kutnun komkiti om! ");
INSERT INTO uri_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","Pike kupm la nasepm hep nti wailet, pake kupm wa la nasepm ak ikghakg la nti ur la tolpa, tu wailet pa tu ngkom hor ya manet, ti tu pa wrongmnto a Krais a pike mo kai yo kwatingki. ");
INSERT INTO uri_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","Tu katnun kuina ur a ipma a tu alntu ti wakrongen ekg ntekg tolti, pa tol maur wailen alntuen pake. Tu ntekg kweiur kweiur a numnungkwat a numpaitn pa tu utopen kat nang alntuen pa tukol tu ntekg kweiur kweiur a numpwor. Nikgwalpm a tu ark ekg kweiur kweiur a atn knokg ti tolti, tolpa ti tu pa hi wa kai paitn kai wakg. ");
INSERT INTO uri_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","Mento pati, ha mreren alpmento pa ha kaino ktnong ai. Mento ti nikgwalpm ark ekg arpm nungkwangen Wailen Jisas Krais hi wa ha kaino ktnong pa nar akwiyo ye kaino. ");
INSERT INTO uri_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","Hi wa kil ak titnongket a kil alkil ti ak wi kweiur kweiur wrongwailet pa kai hor hanekg ekg kil alkil, wa kil atn hep ikghlen kweiur kweiur wrongwailet pa. Hi ak titnongket wrij ripa, kil hi ntekg numpalk paitn amento ti kai tukulein om, mento wi numpalk weten wor tol numpalk alkilen pa yat. ");
INSERT INTO uri_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","Tolpa ti, kipm yanipopm muitnwar alkupmen pa, kipm itn titnongket iklahle ekg katnun Wailen! Yikek alkupm, kupm ti wakrongentepm paitn, nikgwalpm ark ekg kipm ark. Kipm pa ekpma alkupmen a kupm pike aken kwap ti apm ngko ek arke ase, ti kupm utopentepm paitn wrijen, kipm pa tol lukglukg worwor ur a kupm aktutu akal wi pa. ");
INSERT INTO uri_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","Kupm la kipmekg kin wekg Yutia ekg Sintike, kipmekg kin a ukpma Wailen Jisas, tolpa ti kipmekg elnten kle tita, om kipmekg kai hor wrij. ");
INSERT INTO uri_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","Wa kitn Sisikus, melnum alkupmen a mentekg ye kalkut ak kwap wrij, kupm la tolpa kitn iklin kin wekg pa, ekg al tuwekg arpm ukpma wor tita! Tuwekg pike ak kwap titnongket aklinjopm ak wang a kupm laron yangkipm wor a Krais. Tuwekg pa namponen Klemen, wa tu tiur a pike men ak kwap hor wrij pa, nang atu pa hel wurkapm a arpm wor aklei wang hor pa kai. ");
INSERT INTO uri_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","Kipm a Wailen pa, ti kipm utopen om! Wa kupm wa la nasepm nti ur la tolpa, kipm utopen iklei wang tolpa kai om! ");
INSERT INTO uri_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","Wailen yampingken ekg al wa nar, ti kipm lokli tita irk riworwor! Kipm ik tolpa, ekg ak plan tu wrongwailet pa, ekg tu al ari. ");
INSERT INTO uri_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","Ampur kipm ipma kalkut ekg kuina ur a al palntepm pa, kalpm. Aklei wang pa kipm kwe Maur Wailen pa ropontel, ekg wa ukwel wor, ekg al kil aklinjepm. ");
INSERT INTO uri_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","Kipm ropon Maur Wailen tolpa, om kil al ukwepm ipma mehen wor a Krais Jisas pa arpm wail ikghlen nikgwalpm alkipmen pa, ti kipm ake al kark. Ipma kulkula kupuk mehen wor a Maur Wailen ukwepm tolpa pa ye kinar knokg wonen kinar ai, a wa kaino kwa watin kaino ai, kmel ur ake ntie ekg ari yiprokgen a ripa. ");
INSERT INTO uri_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","Kipm yanipopm muitnwar pa, ekla akupm ekg al kai plaln pake. Tolpa ti kupm akal la ak arkupmentepm la tolpa, nikgwalpm akipm pa irk ekg kweiur kweiur a wor, wa kweiur kweiur a wrongwailet ari om kporn yangkipm tolpa pa wor. Kweiur kweiur a wor pa pati tukol kil: kweiur kweiur a aklahle, kweiur kweiur a nipet wor, kweiur kweiur a wri wor, kweiur kweiur a utopen, wa kweiur kweiur tol a tu wi wor lawepm! Nikgwalpm a kipm pa irk ekg kweiur kweiur a worwor tolti! ");
INSERT INTO uri_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","Kuina ur a pike kupm rowepm tukgunakg lngkep yatom kipm wi arie pa, wa pike kipm atning a kupm laron pa, wa ari a kupm ntekg pa, apm kipm wi ik komkiti tolpa ye kai om! Tolpa pa al Maur Wailen ntiepm arpm ukwepm ipma mehen wor. Kil pa yan yiprokgen a ipma mehen wor pake. ");
INSERT INTO uri_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","Kipm pike atn utopen aklinjopm kweiur kweiur ak ai kul pake. Kupm nuhurntepm ti pa, kipm utopen tolpa atn ekg akal aklinjopm, pake ya kalpmtepm ekg kipm kwa kweiur kweiur pa kul ekg aklinjopm hor tolhai. Yatom ak wang ti kipm wa wonuwen ekg wa kwa kweiur kweiur pa kul ekg aklinjopm, ti kupm utopen paitn kat nang a Wailen. ");
INSERT INTO uri_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","Kupm ake la tolpa ekg nte, kupm arpm paitn aki warkip ekg ekpma a kweiur kweiur a numpalk pa, tolpa kalpm. Kupm arpm tolhai pa, pa ake paitn. Kupm arpm wor utopen arpm tolti. Wang wor wang paitn pa, kupm apm arpm ari ase. ");
INSERT INTO uri_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","Kupm ari kupm arpm ntie kweiur kweiur, a kupm ari kupm arpm warkip pa, apm kupm arpm ari ase. Aklei wang a kupm arpm ti aki, arpm hor pa kai pa, nikgtopm aki, nikgwor aki, kupm ntie kweiur kweiur wailet aki, kupm arpm warkip pa, kupm arpm wor tolti. Ya wrongwailet a tolpa pa apm kupm ari yat ase. ");
INSERT INTO uri_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","Kupm ntie ye kalkut wrongwailet, a ntekg kweiur kweiur wrongwailet pa ak titnongket a Krais ukopm pa. Kupm arpm tolhai pa, kupm ari tolpa Krais ak titnongketel kupm, yatom kupm ntie ekg arpm pake. ");
INSERT INTO uri_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","Ari kipm pike kwa kweiur kweiur pa kul ekg aklinjopm ak wang a kupm ye kalkut, a kupm arpm warkip tolkil pa wa wor yat. ");
INSERT INTO uri_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","Ak wang hep a pike kupm piln yangkipm wor a Krais pa ekg aklin kipm a ark ha knokg Masetonia, wa kupm nuhurntepm kai ha ur ai pa, apm kipm melnum a ukpma Maur Wailen kai Pilipai pa kwa kweiur kweiur pa kul ekg aklinjopm pake. Kipm pa ari pa, ake wa tu ha manet tiur a ukpma Maur Wailen pa yipon yangkipm namponen kupm ti pa, kalpm, apm kipm alkipm pake. Kupm pike laron yangkipm pa ekg aklinjepm, wa kipm wa akalmpe kwa kweiur kweiur a kupm warkip pa kul ekg aklinjopm. ");
INSERT INTO uri_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","Wa ak wang a pike kupm arpm kai Tesalonaika pa, kupm warkip ekg kuina ur pa, kipm pa pike kwa kweiur kweiur kul ekg aklinjopm nti aripm ur pake. ");
INSERT INTO uri_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","Kupm utopen ekg kweiur kweiur a kipm kwa kul ekg aklinjopm, pake wailmanten pa kupm wakrongen tolpa kipm ik tolpa ye kai om, pa tol kipm akntie marpm alkipmen a Maur Wailen ikghlen kaino ha wor pa kil nip tolpa kai wail om. ");
INSERT INTO uri_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","Ti kil, ker a pike kupm kwat akwiye kweiur kweiur a pike kipm uk Epaprotitus yatom yentopm kul pa, wailet paitn hangken. Pa tol yaprekg wor a kipm al wor uk Maur Wailen ti kil wi wor utopen pa. ");
INSERT INTO uri_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","Maur Wailen alkupmen, wa Maur Wailen alkipmen yat, kil ntie kweiur kweiur worwor wrongwailet paitn. Kipm melnum a ukpma Krais Jisas pa, kuina ur a kipm warkip pa, al Maur Wailen kil ukwepm pa. ");
INSERT INTO uri_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","Tolpa ti mento kit nang a Maur Wailen, Yan alpmentoen pa, iklei wang tolpa ye kai om! Aklahle. ");
INSERT INTO uri_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","Ukwepm wor, kipm wrong kinkpman a Maur Wailen a ukpma Krais Jisas! Tu worhkanen yikek a ntiopm ark ti pa, wa tu ukwepm wor yat. ");
INSERT INTO uri_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","Tu wrongwailet a Maur Wailen a ark ti pa, tu ukwepm wor, pake tu a ak kwap ark wan wail a Sisar, melnum tukgunakgen a Rom ti pa, tu ukwepm wor wailmanten. ");
INSERT INTO uri_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","Yangkipm a kupm Pol ro ekg aklinjepm pa apm kai tolpake. Kupm ropon Wailen Jisas Krais tolpa ekg ipma wor a kil ark nti maur wor a kipm wrij wrij.");
INSERT INTO uri_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","Kupm Pol, kupm melnum yangkipm kuinen a Jisas Krais. Kai wakrong a Maur Wailen kil kweopm tukol melnum yangkipm kuinen alkilen. Kupm nti Timoti, wasok a men kai nang a Krais. ");
INSERT INTO uri_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","Mentekg ro wurkapm kil kai ekg kipm yanipopm muitnwar a mentekg kai nang a Krais, kipm a atn wri wor ukpma Krais kai ha wail Kolosi. Kupm ropon Maur Wailen, Yan alpmenen ekg al kil reinjepm yatom ntekg kipm arpm namponen ipma mehen wor. ");
INSERT INTO uri_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","Mentekg aklei wang ukwor Maur Wailen, Yan a Wailen Jisas Krais alpmenen, ak wang a men ropon Maur Wailen ekg kil aklinjepm. ");
INSERT INTO uri_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","Mentekg ukwor Maur Wailen pati ekg mentekg atning a kipm ukpma Krais Jisas wa mentekg atning a kipm wakrongen tu kinkpman wrongwailet wri wor a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","Kipm ukpma ariworwor arpm nungkwangen kweiur kweiur worwor a Maur Wailen kil numprampen ikghlen elntha kaino ha wor ai. Tolpa ti kipm arpm nungkwangen ekg wi. Kipm pike atning katnun yangkipm wor aklahle a Maur Wailen pa yatom, kipm ukpma arpm nungkwangen pake. ");
INSERT INTO uri_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","Pike tu melnum ye yangkipm wor pa ye kaintepm pake. Yangkipm wor pa kai hor ha knokg wrongwailet ti, yatom paln wail nip wor kaino wail ngko ek arke hor knokg ti ase. Apm tol pike hep a kipm yat atning kai ha alkipmen pake. Kipm atning yangkipm wor aklahle a ipma wor a Maur Wailen pa, yatom kipm atning wi ariworwor om katnun pa. ");
INSERT INTO uri_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","Epapras kil ro tukgunakg lngkep a kipm ti om kipm wi arie worwor pa. Kil pa melnum akwapel wor a Krais alpmenen, kil ak kwap wrij tukol men ti, kil laron yangkipm wor a Krais pa ak aklin kipm pake. ");
INSERT INTO uri_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","Apm pike Epapras kil pa wa la kiti nasi mentekg ti tolpa Maur Wor ak kwap kai kipm pa, yatom kipm ukpma wor wakrongen tita pake. ");
INSERT INTO uri_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","Tolpa yatom, ak wang a mentekg atning a tu la kiti kipm pa tolpa, ake wa mentekg elnten a kwe Maur Wailen ekg kil aklinjepm pa. Mentekg ropon ekg al kipm wi arie ekg kweiur kweiur wrongwailet a kil wakrongen pa ntie yekworwor, ekg al Maur Wor ukwepm arie a nikgwalpm wonrekele worwor wrongwailet pa. ");
INSERT INTO uri_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","Wa mentekg ropon Maur Wailen ekg al arpm alkipmen pa paln wor kai ikg a Wailen ekg kil kporn yangkipm. Wa kipm wi arie a Maur Wailen pa yatom kipm ik iken kwap wor ekg kil pa, pa tol kipm ngko ek arke wor kai kwap wrongwailet a kipm ntekg pa, wa kipm wi arie a nikgwalpm wor a Maur Wailen pa atn lan lan. ");
INSERT INTO uri_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","Wa mentekg ropon Maur Wailen ekg al kil ak titnongketel kipm pa kai ya wailet ak titnongket a klalen wailmanten alkilen pa, yatom ti tol kalkut tiur akal palntepm pa, kipm ntie ekg arpm mehen ye kalkut pa namponen ipma utopen pa, ");
INSERT INTO uri_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","om al kipm ukwor utopen Yan God ekg kil ntekg kipm ntie ekg wi kweiur kweiur worwor alkipmen a kil numprampen ekg tu wrong kinkpman alkilen a atn kahor kingdom alkilen ai. ");
INSERT INTO uri_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","Maur Wailen kil kwan titnongket a Maur Paitn Satan atn wailen ikghlen nikgwalpm alpmenen a yipowo kai mninget pa kai tukulein, wa kil wiyo kai pa ye kul kai ekg Warim Kpman alkil a kil wakrongen paitn ai atn wailen ikghlen nikgwalpm alpmenen. ");
INSERT INTO uri_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","Warim Kpman pa kil akarmpen paitnpaitn alpmenen plaln ase, om kwan paitnpaitn alpmenen ti ase. ");
INSERT INTO uri_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","Mento ake ntie ekg ari Maur Wailen pa, pake mento ari Krais pa apm hirhir tukol Maur Wailen pake. Kil pa warim atn hep akil apm pike arpm hep ak ai arpm pake, ktnong a knokg a kweiur kweiur wrongwailet a Maur Wailen ntekg pati pa pike paln kanukg. ");
INSERT INTO uri_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","Maur Wailen apm nti kil pa ntekg kweiur kweiur wrongwailet: kweiur kweiur a atn kaino ktnong ai, a atn knokg ti, kweiur kweiur a ari ak ikg, a kweiur kweiur a ake ntie ekg ari tukol tu mring maur a maur a kweiur kweiur wrongwailet a ntie titnongket. Kweiur kweiur wrongwailet pa pike Maur Wailen nti Krais pa ntekg pake, wa kweiur kweiur wrongwailet a kat nang a Krais pake. ");
INSERT INTO uri_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","Kil pike arpm hep ak ai, a kweiur kweiur wrongwailet ti pa paln kanukg. Yatom apm kil alkil pa wamparpme kweiur kweiur wrongwailet pa ikghlen ye atn pake. ");
INSERT INTO uri_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","Mento kinkpman wrongwailet a Maur Wailen pa, mento tukol numpwam alkilen. Wa kil alkil pa tukgunakgen a numpwam ti. Kil pike mo pake kil wa wreitn hep, tolpa om kil alkil pa atn tukgunakgen ekg kweiur kweiur wrongwailet. ");
INSERT INTO uri_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","Maur Wailen pa kil utopen paitn wrijen ekg kil wi wrik arpm wail kahor Warim Kpman alkilen pake. ");
INSERT INTO uri_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","Maur Wailen yipon kla ekg akwi kweiur kweiur wrongwailet a atn knokg ti a atn kaino ktnong ai ye kai hor wrij kor tita hor ya a Warim Kpman alkilen pake. Kil kwawel mo kai yo kwatingki pa yatom walmpopm a kil pa ungkwan yatom ak kwan ipma wakget a Maur Wailen atn ekg mento wrongwailet pa kai plaln. ");
INSERT INTO uri_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","Kipm pike hep pa, kipm pike atn kai watin ai ntekg paitnpaitn wi wrongmnto lan Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","Krais kil paln melnum tukol mento ti, yatom kil mo kai yo kwatingki ak kwan ipma wakget a Maur Wailen a atn ekg kipm pa, yatom kil ntekg kipm ti paln wri wor, paitnpaitn pa kalpm, kai ikg a Maur Wailen. Wa ake al mla ur arkiepm tolpa kipm paitn pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","Pake kipm al ukpma Maur Wailen pa itn titnongket ye kai tukol yo a kli yipoko eln kinar knokg wonen ai yatom nampil knokg atn titnongket pa. Wa kipm ukpma irpm nungkwangen kuina ur a kipm atning a tu laron yangkipm wor a Maur Wailen nasepm pa, pa ampur kipm nuhurn. Yangkipm wor pa pike tu laron nasi tu kinkpman wrongwailet hor knokg ti. Kupm alkupm ti apm pike paln melnum akwapel a laron yangkipm wor pake. ");
INSERT INTO uri_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","Ak wang ti pa, kupm utopen ekg ye kalkut ekg aklin kipm pake. Kupm wa utopen yat ekg uk num a kupm alkupm ti kai ekg ye kalkut tiur a pike Krais kil ye pa tolpa kai ekg aklin tu wrong kinkpman a Maur Wailen pa, tu tukol num a Krais pake. ");
INSERT INTO uri_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","Kupm pike Maur Wailen kil kweopm hep ak ai, yatom kupm paln melnum akwapel alkilen ekg aklinjepm ekg laron yangkipm wor alkilen ti klalen hmpreket wor nasi tu wrong kinkpman a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","Nikgwalpm a Maur Wailen kil pa pike atn hampen ekg tu yohmpei a mamikgmamin manjan ak ai kul ai. Pake ak wang ti pa, kil laron ngko wurknong ekg tu wrong kinkpman wri wor alkilen pake. ");
INSERT INTO uri_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","Kai tu pa, Maur Wailen kil pike yipon yangkipm ak wakrong alkilen hep ase tolpa, kil hi laron ngko wurknong nikgwalpm a kweiur kweiur wailet worwor a atn hampen pa kul kai ngko wurknong ekg tu wrongwailet a ake Juta pa yat. Nikgwalpm hampen pa pati, la tolpa Krais kil arpm kahor ipma wonen a kipm ti, yatom ti kipm ukpma arpm nungkwangen ekg al kil wiyepm ye kai arpm ntiel, om al kipm wi kweiur kweiur worwor alkilen ai a arpm kaino ha wor alkilen. ");
INSERT INTO uri_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","Men laron yangkipm wor pa nasi tu wrongwailet a rowen tukgunakg lngkep ekg ya wor, a tukulein ya paitn ak nikgwalpm arie worwor, tolpa ekg al tu wreitn wail nikgwalpm arke wonrekele wi arie Krais ti ariworwor, pa men wiyen ye kai atn hor wrij namponen Krais. ");
INSERT INTO uri_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","Tolpa yatom kupm aken kwap a laron yangkipm a Maur Wailen titnongket ak titnongket a Krais a ak kwap titnongket minjirangket kahor kupm ti. ");
INSERT INTO uri_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","Kupm wakrongen tolpa, kipm ari kupm a hmurkg wampenen ak kwap ekg aklin kipm pa, wa tu a ark kai ha wail Laotisia, wa tu wrongwailet a ake ari ikgek a kupm ti yat. ");
INSERT INTO uri_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","Yiprokgen a kupm ak tolpa pati, kupm ak ekg akal ak titnongketel nikgwalpm a tu pa ekg al tu ukpma wor wakrongen tita, ekg al tu wi nikgwalpm arie wor kai itn yiprokgen a nikgwalpm wrongwailet. Ekg al tu ari nikgwalpm hampen a Maur Wailen pa. Nikgwalpm ariworwor hampen wrongwailet pa apm Krais kil alkil pake. ");
INSERT INTO uri_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","Kai kil pa, kil melnum yiprokgen a arie nikgwalpm wonrekele worwor pa apm arpm hampen kai kil pake. ");
INSERT INTO uri_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","Kupm la nasepm yangkipm a Krais kil pa, ekg nte kupm kark ekg hi wa tu tiur manet ai ukwepm yangkipm ur manet a atning wor kai nungkulkg alkipmen ti yatom wa rkoln kipm ti ye kai hor ya paitn pa. ");
INSERT INTO uri_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","Tol kupm ake ntiepm arpm, pake nikgwalpm wail alkupmen kil pa apm ark ekg kipm pa arpm kai pake. Tolpa ti kupm utopen ekg kupm atning a kipm hor wrij arpm wor katnun yangkipm a Maur Wailen, wa kipm ukpma Krais pa atn titnongket pa. ");
INSERT INTO uri_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","Kipm wi Krais Jisas tukol Wailen alkipmen ase, tolpa ti ampur kipm elnten, kipm kutnun kil pa itning yangkipm pa tolpa ye kai om! ");
INSERT INTO uri_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","Kipm ukpma Krais pa itn titnongket tukol yo klung a kli yipoko ningnakg alkil pa eln kinar ak nampil knokg. Wa kipm ukpma kil pa itn titnongket tolpa ye kai pa, pa tol a kipm atn le wan hel hong kmpoen wor pa itn ye tolpa ye kai om. Tol a pike men rowepm tukgunakg lngkep ase. Ti ipma wonen alkipmen ti al utopen wailmanten wa ukwor kil pa. ");
INSERT INTO uri_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","Kipm irpm wonirpme ekg hi wa tu melnum tiur akepmplain lokepm ye kai hor ya wailet katnun nikgwalpm arie akplain a tu pa. Nikgwalpm arie akplain pa tu wi kai tu mamikgmamin manjan a tu mring maur a maur akplain a ikghlen ktnong a knokg, pa ake arie wor a Krais pa. ");
INSERT INTO uri_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","Maur Wailen pa apm arpm kahor Krais pake. Kil wi numpalk tukol mento melnum ti, pake kweiur kweiur wrongwailet a Maur Wailen pa apm arpm kahor wonen a kil pake. ");
INSERT INTO uri_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","Wa Krais pa arpm wail kai kipm ti yatom kipm ntie ekg ntekg kweiur kweiur wrongwailet. Kil pa atn tukgunakgen ikghlen kweiur kweiur wrongwailet. Kil atn wailen ikghlen tu mring maur a maur a kweiur kweiur wrongwailet a ntie titnongket pa. ");
INSERT INTO uri_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","Kipm ukpma Jisas pa, pa tukol kil kwat numpalk a kipm pa aklahle ekg kwan titnongket a paitnpaitn a ak yipowepm pa. Pa ake kweiur a melnum ur ntekg pa, kalpm. Krais, kil pa kwan paitnpaitn a mento pa, om kil alkil pa kwat numpalk a mento aklahle. ");
INSERT INTO uri_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","Wa tol tu pike kalukepm kai nang a Krais pa, pa plan tol kipm mo namponen Krais pa ase, yatom uwentepm kai kirkhap pa ase. Wa kipm ukpma tolpa, titnongket a Maur Wailen pa ntie, om kil la yatom kipm nti Krais wreitn atn. Pa tol pike Maur Wailen kil la yatom Krais kil wa wreitn atn pa. ");
INSERT INTO uri_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","Kipm pike ntekg paitnpaitn atn pa yatom paitnpaitn alkipmen pa ntekg maur wor alkipmen pa apm mo ase. Pake Maur Wailen wa ntekg kipm pa arpm mlepm namponen Krais pa pati, kil kwan paitnpaitn wrongwailet alpmenen pa plaln ase. ");
INSERT INTO uri_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","Pa tol Maur Wailen kil kule wurkapm a tu ro ak plan paitnpaitn a mento ntekg ekg talpuln yangkipm titnongket. Kil kwan wurkapm ripa plaln, ak wang a tu alm Jisas Krais kai yo kwatingki om kil mo. ");
INSERT INTO uri_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","Kai yo kwatingki pa Krais kil mo pa kil lok arku kwan titnongket a mring maur a ntie titnongket. Kil wi nang wail ti uk numpaitn tu kai ikg a tu wrongwailet a atn knokg ti a kaino ktnong ai yat, pa kil planten tolpa kil atn hep hangken tu ase. ");
INSERT INTO uri_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","Tolpa yatom ampur kipm eln melnum ur namputepm kalpmel ekg kipm al wangkwrije aki kipm al klon aken pa, wa namputepm kalpmel ekg kipm ntekg ekpma wail al atnen wang wail ur aki, atnen ekpma nangnang ur aki, atnen kainil weten a paln pa, wa namputepm kalpmel ekg wang a kipm ark ekg wi yapm. ");
INSERT INTO uri_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","Kweiur kweiur ripa pa lukgklal a kweiur aklahle a akal paln kanukg. Krais kil alkil pa yiprokgen a kweiur kweiur aklahle. ");
INSERT INTO uri_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","Ake al kipm atning katnun nikgwalpm a tu mla ur ai a rkolepm ye kai tukulein ya wor a kipm hore pa. Tukol tu melnum tiur a arku tu alntu, kalpm ekpma uk wang Maur Wailen pa akplainel tu alntu ti tolpa tu pa wor pake. Aki tukol tu tiur a ari kweiur kweiur tol a Maur Wailen planten aki, tukol hokgwangket worwor pa. Wa tu tiur a kpor klko lein tu maur akwapel a Maur Wailen pa. Plpa tu akepmplain, ekg nte, tu pa nampil nikgwalpm tngklaket paitn alntuen ti a wamparpme nikgwalpm a kat nang tolpa, apm ya wor wrijen apm tu hantil apm tike. ");
INSERT INTO uri_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","Tu pa nlokgen tu alntu ti kai atn tukulein Krais ti. Krais pa kil tukgunakgen a numpwam wrongwailet alkilen pake. Numpwam wrongwailet ti kai almitne atn num a Krais. Ningkli ti kli hore tita ak nampil numpwam wrongwailet ti ye kai atn wrij yatom nip ak titnongket a Maur Wailen wreitn wor wail. ");
INSERT INTO uri_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","Kipm apm pike mo namponen Krais ase ekg kweiur kweiur peset paitnpaitn a atn knokg ti ase. Yatom titnongket a ya peset a pike kipm katnun atn knokg ti pa ake wa atn wail hangken kipm ti pa, kalpm. Kipm ti hangken yat ase. Tolpa om ampur kipm kai horhanekg katnun pa atn lan atn pa. ");
INSERT INTO uri_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","Tol tu lokepm la tolpa, “Ake al kipm wamparpme, ake al kipm al, ampur kipm wam hele.” ");
INSERT INTO uri_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","Pake tolpa kalpm. Pa kweiur kweiur a mento aken kwap atn knokg ti tolti hute. Yangkipm titnongket a arpm knokg ti tolti, pa hi kai plaln. Plpa melnum ti hute la nasepm rowepm tukgunakg lngkep ti tolti. ");
INSERT INTO uri_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","Tol tu katnun yangkipm a tu rowepm tukgunakg lngkep pa, tu arku tu alntu atn mehen a arpm mehen akplain plan ak num henen ti tolti. Wa tu uk wleket num alntu ti kalpmel tolti. Tu wrongwailet arien pa, pa tu la tolpa, pa tu komkiti ariworwor a kpor klko lein Maur Wailen, pake ake ntie titnongket a ak kpor hmpei ipma alntuen ekg tu elnten ipma tingklaket ripa. ");
INSERT INTO uri_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","Maur wor alkipmen apm pike mo ase, yatom Maur Wailen ntekg kipm pa wreitn atn mlepm namponen Krais ase. Tolpa ti kipm al lok nikgwalpm alkipmen ti ye kai ark ariworwor ekg kweiur kweiur wrongwailet a atn kaino ha wor ai. Kaino ha wor a Krais kil arpm wam wien a Yan alkilen wi nang wail a atn hep ekg ikghlen kweiur kweiur wrongwailet. ");
INSERT INTO uri_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","Lok nikgwalpm alkipmen ti ye ekg akwonalmpen nikgwalpm worwor a kweiur kweiur kaino ha wor pa tolti. Wa ampur akwonalmpen kweiur kweiur a atn knokg ti. ");
INSERT INTO uri_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","Maur wor alkipmen apm pike mo ase, yatom ti maur wor alkipmen wreitn arpm mlepm namponen Krais, om Maur Wailen lampepm arpm worwor. ");
INSERT INTO uri_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","Krais, kil melnum a ukwepm maur wor weten pa kil hi paln ngko wurknong pa, kipm ti yat, kipm hi wa paln ngko wurknong wi titnongket klalen wailmanten namponen kil. ");
INSERT INTO uri_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","Kipm kwan ipma tngklaket wrongwailet a knokg ti a ak kwap atn kai ipma alkipmen pa. Kweiur kweiur tukol: Kli arkul tita aki a kweiur kweiur a tu wi numpaitn aki, kipm ake ntie ekg arku nikgwalpm titnongket a ipma wakrongen tolpa nti kin aki kpman ur hokg pa. Nikgwalpm a wreitn titnongket akal ntekg kuina ur a paitn aki, arikowe arpm wail akal wi kweiur kweiur wrongwailet a knokg ti. Nikgwalpm a arikowe tolpa pa tukol Maur Wailen alkipmen apm pake. ");
INSERT INTO uri_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","Mla ur a ntekg paitnpaitn a tolpa pa, Maur Wailen kil ipma wakget paitn ekg kil, yatom kil hi uk wleket ntekg paitnel kil pa. ");
INSERT INTO uri_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","Kipm yat apm pike nikgwalpm tolpa rkolepm yatom kipm atn ntekg kweiur kweiur tolpake. ");
INSERT INTO uri_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","Tolpa ti, kipm kwan nikgwalpm wrongwailet a paitn pa. Nikgwalpm tukol: Ipma wleket, a ipma wreitn ekg er kmel, a ipma paitn, la paitnel ekg kmel ur, la yangkipmek a paitn pa. ");
INSERT INTO uri_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","Ampur kipm la yangkipmek ekg akplainel mla ur, ekg nte, kipm apm pike kwan ipma tngklaket a pike kipm ak tolpa yat ase. ");
INSERT INTO uri_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","Wa ipma alkipmen pa apm wa paln weten ase. Melnum a pike ntekg kipm ti pa, apm kil ntekg kipm paln weten tolpa ye kai pake, ekg kipm hi wi arie a kil pa worwor, yatom hi kipm paln hirhir tukol kil pa yat. ");
INSERT INTO uri_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","Mento a paln weten pa, mento ake wa manet manet, tu Krik, aki tu Juta, tu a pike kwat numpalk, aki tu a ake pike kwat numpalk, tu a ak ek manet manet, aki tu a ha knokg manet manet, a tu a aken kwap kalpmel horhanekg melnum ur, aki tu a ark ak wakrong alntu. Pake Krais wrij hute pa kil a mento wrongwailet, yatom apm kil pa arpm kahor ipma a mento wrongwailet ti. ");
INSERT INTO uri_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","Maur Wailen kil ukpma wor wakrongen kipm yatom kil kwewepm ekg arpm wri wor ekg alkilen, tolpa ti nikgwalpm alkipmen pa irk tolti: al kipm ipma rein iklin mla ur, rku kipm alkipm ye kinar irpm mehen horhanekg ekg tita, irpm mehen ye kalkut namponen ipma wor. ");
INSERT INTO uri_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","Melnum ur akal ukwepm kalkut pa, ampur kipm akalmpe pa, kalpm. Kipm utopen ekg ye kalkut pa namponen ipma wor irpm tolti. Wa kipm nuhurn paitn kuina ur a tu ntekg kul ekg kipm pa. Pati ekg nte Maur Wailen kil pike nuhurn paitnpaitn alkipmen pa ase. ");
INSERT INTO uri_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","Nikgwalpm wrongwailet a wet kupm la hel hep pa wor pake, atn hep hangken nikgwalpm wrongwailet pa pati, kupm la tolpa kipm ukpma wor wakrongen tita. Pa pati ye kipm kai itn hor wrij wa kipm atn titnongket ekg komkiti nikgwalpm wrongwailet pa ariworwor. ");
INSERT INTO uri_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","Kipm eln ipma mehen wor a Krais pa itn wail ikghlen nikgwalpm alkipmen pa. Krais kil kwe kipm ti tukol numpwam wrij wrij ur a kai almitne atn num wrij alkilen ti. Yatom kipm irpm mehen ukwor Maur Wailen aklei wang tolti. ");
INSERT INTO uri_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","Kipm eln yangkipm a laron Krais pa irpm titnongket kahor ipma a kipm wrij wrij. Kipm wi arie a Krais worwor ekg al kipm uk arie a ro tukgunakg lngkep ekg tita a noworel tita ekg al kipm ntie ekg katnun ya wor tolti. Wa kipm ik nangnang a hel kai wurkapm a Nangnang a Teipit, wa kipm ik nang ekg ak kat nang a Wailen, wa ik nangnang weten weten tiur a Maur Wor ukwepm pa. Kipm ik tolpa utopen ik kit nang a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","Kweiur kweiur wrongwailet a kipm ntekg pa, kipm ekla aki kipm ik kwap pa, kipm ik tukol kipm ak kwap a Wailen Jisas wa kipm ukwor Maur Wailen, Yan alpmenen pa, kai nang a Jisas pa. ");
INSERT INTO uri_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","Kipm kin pa, kipm pa itning nungkulkg horhanekg ekg kpman alkipmen pa. Wailen al wi wor lawepm, kil utopen tolpa ekg kipm katnuntel. ");
INSERT INTO uri_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","Kipm kpman pa, kipm ukpma wor wakrongen tu kin alkipmen pa, ampur kipm ntekgen paitn. ");
INSERT INTO uri_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","Kipm warim pa, kipm itning nungkulkg horhanekg a manjan alkipmen pa ekg kweiur kweiur a worhampe. Wailen kil al wi wor lawepm kporn yangkipm ekg kipm ak tolpa. ");
INSERT INTO uri_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","Kipm yantin pa, ampur kipm er kle tu warim alkipmen pa aklei wang, tolpa pa tu ipma kalkut ekg arpm a tu pa wa paitn. ");
INSERT INTO uri_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","Kipm melnum a ak kwap kalpmel pa, itning nungkulkg ik kwap kuina ur komkiti wakrong a melnum tukgunakgen alkipmen pa riworwor. Ake la nak kipm akplain kai ikg akil pa ekg al kil wi wor lawepm pa. Kipm kirk ekg Maur Wailen, yatom kipm ik kwap namponen nikgwalpm aklahle. Kipm ik tukol a kipm ak ekg Wailen Jisas. ");
INSERT INTO uri_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","Tolpa ti, kuina ur a kipm ntekg pa, kipm ik namponen nikgwalpm aklahle, tol a ak ekg Wailen Jisas pa, ake ak ekg melnum pa. ");
INSERT INTO uri_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","Ti kipm ari tolpa, kipm hi wi kweiur kweiur worwor a Maur Wailen kil numprampen elntha ekg akalmpe kwap a kipm ak ekg Wailen pa. Pa ake tol kipm ak ekg melnum ur tolti, kalpm, pa kipm ak ekg Wailen Jisas Krais. ");
INSERT INTO uri_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","Mla ur a kil ntekg paitn pa, kil hi wi paitn akalmpe paitn a kil alkil ntekg pa. Maur Wailen ake al wi wor la ur, a wa wi paitn la ur, kalpm. ");
INSERT INTO uri_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","Kipm melnum tukgunakgen pa, kipm ikghlen tu melnum a pike kipm armpen ekg akal aktepm kwap pa nipet yekriworwor. Ekg nte, kipm ti wa ari yat melnum tukgunakgen a ikghlen kipm ti pa arpm kaino ktnong ai. ");
INSERT INTO uri_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","Ampur kipm elnten a kipm ropon Maur Wailen pa. Kipm irpm wonirpme nikgwalpm irke ukwor kil a ropontel aklei wang tolpa kai pake. ");
INSERT INTO uri_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","Wa kipm ropon Maur Wailen ekg kil aklin men ti yat, ekg Maur Wailen kil kuleinjo ya ekg al men laron nikgwalpm hampen a la kiti Krais pa. Apm yiprokgen ripa yatom tu wiopm ye hor arpm wan tipmning kil. ");
INSERT INTO uri_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","Kipm ropon Maur Wailen pa ekg kil iklin kupm ti ekg kupm laron yangkipm a kil ti wurknongket wor komkiti nikgwalpm a kil alkil ti. ");
INSERT INTO uri_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","Kai kuin a tu a ipma wekg pa, kipm itn wonirpme. Ya ur wokget ekg kipm pa, ampur kipm eln wang ur pa kai kalpmel pa, kalpm. Kipm aklei wang plan nikgwalpm wor a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","Kipm akal ekla namponen tu mla ur pa, kipm ekla mehen namponen nikgwalpm wor, tukol nokg a ak rato ekpma kai nokgij wor. Wa al kipm pa wa arie ya a akalmpe ropon a tu wrongwailet pa yat. ");
INSERT INTO uri_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","Tikikus pa hi la nasepm worwor kuina ur wrongwailet a paln ekg kupm atn kil. Kil yek pa wasok alpmentoen kai nang a Krais. Wa kil melnum akwapel wor a ntio ak kwap a Krais atn titnongket. ");
INSERT INTO uri_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","Tolpa yatom ti kupm akal kwa kil kaintepm ekg al kil hi la nasepm kuina ur a palnto atn kul kil, ekg al kil ak titnongketel kipm. ");
INSERT INTO uri_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","Wa kupm hi kwa Onesimus ntiel kaintepm pake. Kil yek melnum wor a horhanekg a nikgwalpm arke wa wasok alpmentoen kai nang a Krais. Kil pa apm melnum wrij ur a kipm alkipm Kolosi pake. Hi tuwekg la kiti nasepm kweiur kweiur wrongwailet a paln atn ti. ");
INSERT INTO uri_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","Aristarkus, melnum wor ur alkupm a mentekg arpm wan tipmning kil namponen Mak, melnum a Parnapas, tuwekg ukwor kipm. Pike kupm la nasepm hep ase tolpa, tol kil kaintepm pa, kipm utopen ekg wiyel ye kai wan pa, om ikghlentel yekriworwor. ");
INSERT INTO uri_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","Jisas, nang wompel alkilen pa kwe la tolpa Jastus, kil pa yat wa ukwepm wor. Kai kuin a tu Juta pa apm tunten melnum wraur apm pake, tunten atn ntiopm ak kwap laron yangkipm wor a la Kingdom a Maur Wailen. Wa wailmanten pa pati tunten wor ekg ak titnongketel kupm ti. ");
INSERT INTO uri_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","Epapras, melnum alkipmen pake, kil wa ukwepm wor yat. Kil melnum akwapel a Krais Jisas. Kil aklei wang ropon Maur Wailen titnongket ekg akal kil ak titnongketel kipm pa ekg kipm paln kinkpman wri wor ekg atn titnongket komkiti nikgwalpm wakrong a Maur Wailen tolti. ");
INSERT INTO uri_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","Aklahle wrijen, kupm alkupm ti pike atning ari a kil ak kwap wail ekg aklin kipm wrong kinkpman a Maur Wailen a ark kai pa wa tu a ark kai ha wail Laotisia a Hierapolis pa. ");
INSERT INTO uri_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","Luk, melnum yek wor alpmentoen, melnum a ak kwap a hi numpet, ekg Temas, tuwekg pa wa ukwepm wor yat. ");
INSERT INTO uri_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","Kipm la nasi muitnwar yanipopm a kupm kai ha wail Laotisia pa wa la nasi kin ur, nang a kil pa Nimpa, pa namponen tu wrong kinkpman a Maur Wailen a kor tita ekg kat nang a Maur Wailen kai wan a kil pa la tolpa, kupm ukwen wor. ");
INSERT INTO uri_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","Kipm klein wurkapm kil ekg kipm wrong kinkpman a Kolosi pa, atning plaln pa, wa ye kai ekg tu klein nasi tu wrong kinkpman a Maur Wailen a Laotisia pa. Wa wi ur manet pa a pike kupm ro kai ekg tu Laotisia pa, wa ye kul klein ekg nasi kipm Kolosi ti. ");
INSERT INTO uri_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","Kipm la nasi Arkipus pa la tolpa, ekg kil ikghlen kwap a pike Wailen ukwel pa ik yekriworwor tolpa kai. ");
INSERT INTO uri_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","Kupm Pol, kupm alkupm ro yangkipm ketn rikil, ak wam alkupmen ekg ukwepm wor. Ti ampur kipm wonhmiten kupm a arpm wan tipmning kil. Kupm ropon Maur Wailen ekg al kil reinjepm. Yangkipm akupm apm kai tolpake.");
INSERT INTO uri_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","Wurkapm kil pa kupm Pol ro ekg kitn Taitus. Kupm melnum akwap kalpmel a Maur Wailen wa kupm melnum yangkipm kuinen a Jisas Krais. Ti kil kwaopm ekg kupm kai aklin tu wrong kinkpman a Maur Wailen akrkahan ekg al tu ukpma kil pa yekworwor, wa wi arie ekg yangkipm aklahle akil pa ariworwor. Apm yangkipm pa aklin tu ekg katnun nikgwalpm alkilen pake. ");
INSERT INTO uri_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","Kupm akwap ekg aklinjen ekg tu ukpma titnongket arpm nungkwangen wang wor a hi tu ntiel arpm aklei wang. Ak wang a pike hep, Maur Wailen ake ntekg ktnong a knokg pa pen, kil yipon yangkipm aklahle wrijen la tolpa tu wrong kinkpman hi ntiel arpm wor aklei wang. Pa kil ake akplain. ");
INSERT INTO uri_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","Yatom ak wang a Maur Wailen alkil pa la pa, kil uk yangkipm a kil kupm ti om kupm laron yangkipm akil pa paln kai ngko wurknong. Ti kupm ti pike Maur Wailen kil alkil kweopm, kil a pike akarmpento pa, kil la nasopm la tolpa kupm laron yangkipm akil pa nasi tu wrong kinkpman. ");
INSERT INTO uri_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","Kupm ro wurkapm kil kai ekg kitn Taitus. Mentekg ukpma wrij kai Jisas Krais, tolpa yatom kitn pa tukol warim kpman aklahle a kupm. Kupm ropon Maur Wailen, Yan amento, ekg Krais Jisas a pike akarmpento, ekg al tuwekg nikgwalpm wor ekg kitn, ekg kitn arpm ipma kulkula mehen wor tolti. ");
INSERT INTO uri_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","Kupm pike nuhurnteitn elntarpm atn Krit ekg kitn noworel kwap humpu wrongwailet a ake paln wor pen. Wa kitn kit tu melnum a wor pa tu atn melnum wail ekg ikghlen kwap a Maur Wailen a ark hor ha wail wrij wrij pa, tol a pike kupm la naseitn pa. ");
INSERT INTO uri_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","Melnum wail a ikghlen kwap a Maur Wailen pa pati, kitn kit melnum wor ur a ake melnum ur ariel tolpa, kil pa ntekg paitnpaitn ur pa. Melnum a tolpa pa, al kil atn wrij namponen kin alkil wrij hute. Tu warim akil pa al ukpma Jisas Krais. Ake al tu talpuln yangkipm a manjan pa. Ake al tu ntekg ipma wleket ekg wi nang paitn pa. ");
INSERT INTO uri_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","Melnum wail a ikghlen kwap a Maur Wailen pa, kil pa pati hi ikghlen tu wrong kinkpman a ukpma Maur Wailen, kil pa ak kwap kai nang a Maur Wailen alkilen. Tolpa ti al kil melnum a ake melnum ur ariel tolpa, kil pa ntekg paitnpaitn ur pa. Kil ake al plan kil alkil pa tol kil melnum wailen, kil ake al ipma wleket aktutu pa, kil ake al al hu hmit pa, yatom kil hmithmit pa. Kil pa ake al melnum a ekla a wampor wam ekg mla ur pa, kil ake al akplainel mla ur ekg wi marpm. ");
INSERT INTO uri_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","Ake al kil ntekg tolpa, al kil ntekg tolkil: al kil wor ekg kporlei wokghmprak, al kil wakrongen kuina ur a wor, nikgwalpm a kil pa al wor ekg ntekg kuina ur a wor, al kil melnum nipet wor, al kil melnum wri wor kai ikg a Maur Wailen, al kil lokhparn kil alkil. ");
INSERT INTO uri_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","Al kil nampil titnongket yangkipm aklahle a Maur Wailen, tol a pike kil atning a wi pa, atn titnongket, ekg al kil ntie ekg ak yangkipm aklahle alkil pa ak titnongketel tu, wa ak plan tu a talpuln ek a Maur Wailen pa tolpa, nikgwalpm kuina ur a tu pa paitn. ");
INSERT INTO uri_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","Al kitn kat melnum wor tol a wet kupm la pa, ekg nte tu melnum wailet a Krit pa tu talpuln yangkipm aklahle a Maur Wailen, laron yangkipm kalpmel ekg ak rkol tu melnum kul katnun yangkipm akplain alntuen tolti. Kai kuin a tu pa, tu wailet a tu Juta pa la titnongket ekg tu a ukpma Krais Jisas pa la tolpa, tu a ukpma Krais Jisas pa, tu al kwat numpalk katnun ya a men Juta pake. ");
INSERT INTO uri_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","Ti kitn la nisi tu a laron yangkipm paitn pa ekg tu elnten yangkipm a tu laron pa. Ekg nte, tu rowen tukgunakg lngkep ekg yangkipm a ake wor ekg tu rowen tukgunakg lngkep pa. Tolpa yatom tu ntekg tu wrong kinkpman namponen walmpopmwrij alntuen a ukpma Maur Wailen pa tu nuhurn ya a ukpma Maur Wailen. Tu akenplain tolpa ekg wa wi marpm kalpmel. ");
INSERT INTO uri_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","Tukol pike melnum a arie wail ur a tu Krit pa la tolkil: “Tu Krit pa tu melnum a la yangkipm akplainplain, tu melnum paitn tukol wlikgek mingken a wrongken. Tu lpmahaklang ark akal al wailet tolti.” ");
INSERT INTO uri_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","Ti yangkipm a melnum alntu la pa aklahle, tolpa ti kitn kle tu pa yikaktnen, ekg al tu ukpma yangkipm aklahle a Maur Wailen pa atn titnongket. ");
INSERT INTO uri_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","La nisen ekg ake al tu atning por kalpmel a tu Juta ti, wa ake al tu katnun yangkipm a tu melnum a uk yirokg yangkipm aklahle a Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","Tol melnum ur a ipma alkilen a wri wor kai ikg a Maur Wailen pa, kweiur kweiur wrongwailet pa wri wor ekg kil wi. Pake tol ipma a melnum ur kimpilpet kai ikg a Maur Wailen pa, wa ake kil ukpma Krais Jisas pa, kweiur kweiur wrongwailet a kil ntekg pa, kimpilpet. Aklahle wrijen, nikgwalpm a kil pa nokgij paitn, tolpa om kil ake ntie ekg ari kuina ur a wor kuina ur a paitn kai ikg a Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","Kil ak ek loken kil alkil pa la tolpa kil ukpma Maur Wailen, pake atn a arpm akil pa pati, plan tolpa kil ake ukpma Maur Wailen pa. Kil pa nungkulkget paitn, kil ake atning yangkipm a Maur Wailen la pa. Kil ake ntie ekg ntekg kuina ur a wor, kalpm. ");
INSERT INTO uri_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","Kitn Taitus, yangkipm kuina ur a kitn ro tukgunakg lngkep a tu kinkpman pa, pa kitn laron yangkipm aklahle a komkiti yangkipm a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","Tu kpman wror pa, al kitn rowen tukgunakg lngkep tolkil: tu lokhparn tu alntu pa itn riworwor, atn tol tu wail wail, wa al tu atn wonrekele. Tu al atn titnongket ukpma yangkipm aklahle a Maur Wailen, wakrongen tu wrongwailet pa aklahle, wa atn titnongket ekg ye kalkut. Tu kpman wror pa, al kitn rowen tukgunakg lngkep tolpake. ");
INSERT INTO uri_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","Wa tu kin mayen pa, al kitn rowen tukgunakg lngkep tolpa yat pake: al tu arpm wor tukol kin wor a ukpma Maur Wailen, ake al tu la yangkipm paitn ekg mla ur, ake al tu eln hu hmit pa atn wailen atn kahor nikgwalpm a tu pa. Ake al tu ntekg tolpa, al tu kaling plan kuina ur a wor tolti. ");
INSERT INTO uri_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","Yatom al tu kin mayen pa tu rowonel tu kin warimpen ekg al tu ntekg nikgwalpm wor kai tu kpman a warim warim alntuen, ");
INSERT INTO uri_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","ekg al tu lokhparn tu alntu, ekg al tu atn namponen kpman alntu tolti hute. Tu al akwap titnongket wor tolti, ekg ikghlen tu kpman a warim warim alntu wa hor hanekg a kpman alntu. Al tu katnun yangkipm a tu kin mayen la nasen pa. Kalpm pa, al tu mla ur aknokgel yangkipm a Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","Tu kpman warimpen al wa kitn la nasen tolpa yat, la tolpa al tu lokhparn tu alntu pa yat. ");
INSERT INTO uri_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","Ti kai kweiur kweiur wrongwailet pa, al kitn alkitn Taitus ti planten klal wor hep, ekg al tu ari kwap wor a kitn ak ekg aklin tu mla ur pa, yatom al tu katnun. Kitn akal ro tukgunakg lngkep a tu pa, kitn rowen tukgunakg lngkep aklahle tolti, tol a kitn warim woren pa. ");
INSERT INTO uri_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","Kai ekla alkitnen pa, al kitn ekla nipet wor tolti ekg ake ntie ekg al melnum ur a atn talpuln ekla a kitn piln pa. Kil la paitnel ekla a kitn piln pa, pa kil numpaitn, ekg kil la yangkipm paitnel tolpa ekg ake yangkipm yiprokgen ur. ");
INSERT INTO uri_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","Tu melnum akwap kalpmel ekg melnum ur pa, al kitn rowen tukgunakg lngkep tolkil: tu al hor hanekg ekg yan a kwap pa ekg kweiur kweiur wrongwailet, tu al katnun tu yan a kwap pa ekg ak ntekg yan a kwap pa wi wor utopen ekg kwap a tu ak pa, ake al tu talpuln yangkipmek kuina ur a tu la pa. ");
INSERT INTO uri_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","Ake al tu akikgwampel kweiur wrij ur a yan a kwap pa, al tu akwap wor ikghlen kweiur kweiur a yan a kwap pa tol kweiur kweiur alntuen. Tol kwap wrongwailet a tu ak pa wor, pa ak plan kai tu wrong kinkpman pa tolpa, pa wor wrijen ekg tu akal katnun yangkipm a Maur Wailen a akwio pa. ");
INSERT INTO uri_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","Al kitn ro tukgunakg lngkep a tu ipma wrij pa ekg tu al arpm tolpa, ekg nte, pike Maur Wailen kil ntekg ipma wor alkilen pa paln ngko wurknong kai tu kinkpman wrongwailet ekg kil kwa Jisas Krais pa nar ekg akwio. ");
INSERT INTO uri_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","Ipma wor akil pa ak la naso la tolpa, al mento elnten kweiur kweiur paitnpaitn a mento ntekg a ake wor kai ikg a Maur Wailen pa. Al mento nuhurn kuina ur paitn a mento wakrongen ekg ntekg atn knokg ti. Al mento lokhparn mento alpmento ti arpm nipet wor, katnun nikgwalpm nipet wor a Maur Wailen tolti, tolpa ak wang a mento arpm knokg ti ");
INSERT INTO uri_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","om nungkwangen ekg mento hi ari tolpa Jisas Krais hi nar namponen wakg wail, ti mento hi utopen paitn. Ti mento nungkwangen wang wail akil pa arpm. Kil pa Maur Wailen alpmento a ntie titnongket, kil melnum a pike mo ekg akwiyo. ");
INSERT INTO uri_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","Kil uk num akil ti akarmpento ekg mento ake akal atn hanekg a titnongket a paitnpaitn a knokg ti, ekg ak klak ipma wonen amento paln wri wor ekg mento paln wrong kinkpman alkilen tolti, wa nikgwalpm a mento arke ekg ak kwap wor ekg aklin tu mla ur tolti. ");
INSERT INTO uri_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","Apm kitn wi ek a kupm Pol kil ak ro tukgunakg lngkep a tu ekg yangkipmek kweiur kweiur a kupm ronteitn kil. Kitn ak titnongketel tu ekg tu katnun yangkipm kil a Maur Wailen pike ukweitn ekg al kitn laron titnongket nasi tu. Wa kitn la yangkipm kil titnongket ekg ak talpuln tu mla ur a ake katnun yangkipm kil. Mla ur laweitn paitnel pa, kitn ampur atning pa. ");
INSERT INTO uri_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","Kitn kit wonel tu wrong kinkpman ekg al tu hor hanekg atning katnun tu melnum tukgunakgen alntuen a ikghlenten pa. Al tu numprampen ekg ak kwap kweiur kweiur wrongwailet a wor ekg aklin tu mla ur pa. ");
INSERT INTO uri_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","Ti kitn la nisen tolpa ake al tu la paitnel melnum ur, kle melnum ur. Tu iklin tita elntatar irk, tu arku tu alntu ntekg nikgwalpm wor ekg tu wrongwailet. ");
INSERT INTO uri_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","Al kitn kat wonel tu wrong kinkpman ekg tu arpm horhanekg ekg tita, ekg nte, mento yat apm pike ak tolkil: Mento pike hmit, mento pike nungkulkget, tu pike akplainel mento om rkolo ye hor ya paitn. Pike ipma wakrongen a ipma wreitn arikowe tu kin a kpman pa ak arkulo titnongket. Nikgwalpm a mento ti pike ark ekg ntekg paitnpaitn a arikowe kweiur kweiur tiur tolti. Mento ti pike tu ipma wleket paitn ekg mento, wa mento ti pike ipma paitn ekg tita. ");
INSERT INTO uri_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","5","Pake Maur Wailen, melnum a akwiyo pa, kil ntekg nikgwalpm wor a ipma wakrongen a kil pa paln ngko wurknong, yatom kil akwiyo. Ake wa kil akwiyo ekg kwap kuina ur nipet wor a mento ti ak pa, kalpm. Ti apm ipma rein akil ti yatom kil akwiyo pake. Kil kaluko om mento paln tol warim weten alkilen pa om Maur Wor a kil pa uko nikgwalpm weten wor. ");
INSERT INTO uri_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","Kai kwap a Jisas Krais, melnum a pike akwiyo pa, Maur Wailen pike kwa titnongket a Maur Wor nar wail ekg mento ti. ");
INSERT INTO uri_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","Tolpa yatom nikgwalpm wor akil pa om kil ntekg mento ti paln nipet wor kai ikg alkilen. Kil ntekg tolpa ekg mento hi ntie ekg wi kweiur kweiur worwor a kil yipon yangkipm ekg akal uko pa. Mento ari tolpa, kil numprampento elntha ha wor a hi mento arpm wor aklei wang. ");
INSERT INTO uri_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","Ti yangkipm a wet kupm la pa aklahle wrijen. Ti kupm wakrongen la tolpa kitn kit nikgwalpmel tu ekg yangkipm wrongwailet ripa, ekg al tu a ukpma Maur Wailen pa ikwap wor ekg aklin tu mla ur titnongket yekriworwor. Yangkipm wrongwailet ripa pa wor, ekg wa aklin tu kinkpman wrongwailet. ");
INSERT INTO uri_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","Tol kitn atning a tu hmithmit alilhakel tita ekg kweiur, aki tu ekla ekg tu mamikgmamin yohmpei a tu aki, kle tita ekg yangkipm titnongket a Moses uk tu Juta pa, ampur kitn atning. Yangkipm ripa pa ake wor ekg aklin mla ur, kuina ur wor ake ntie ekg paln kai yangkipm pa. Ti kitn ngkom nlokgen yangkipm ripa om! ");
INSERT INTO uri_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","Tol melnum ur kil piln yangkipm a ak rowepm ekg kipm kai atn manman pa, kitn noworel nti wrij aki nti wekg e. Ake kil atningkeitn pa, pa kitn ukwel yirokg om! ");
INSERT INTO uri_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","Ekg nte, kitn ari pa, melnum a tolpa pa, kil pa nuhurn ya a Maur Wailen ase, tolpa om kil paln melnum a ntekg paitn. Paitnpaitn a kil ntekg pa, plan tolpa kil apm paitn ase, tolpa om kil alkil ntekg yangkipm kai kil alkil pa. ");
INSERT INTO uri_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","Ti kupm la naseitn tolpa ak wang a kupm kwa Artemas aki Tikikus, tuwekg ur kil kai wi wrik a kitn pa, kitn pa wa kor ya ur pa aktutu wa kulntopm kai ha wail Nikopolis pa. Ak wang a hu wei wripm wail hor pa, kupm hi kai arpm kai ha wail ripa, arpm kai ngko wang a hu wei pa kai plaln. ");
INSERT INTO uri_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","Wa tol melnum wekg ur kil, Sinas, melnum arie a ikghlen yangkipm titnongket, wa namponen Apolos, pa kitn itning rien tolpa tuwekg warkip ekg kuina ur pa, kitn iklinjen, ekg hi tuwekg ye kai. ");
INSERT INTO uri_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","Apm tolpa yat pake, tu wrong kinkpman alpmento a ukpma Maur Wailen pa, al tu wi nikgwalpm wor ak kwap wor ekg aklin tu mla ur a arpm warkip pa, ekg al tu arpm wor. Tol ake tu aklinjen pa, tu al paln tukol yo a ake ek arke wor pa. ");
INSERT INTO uri_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","Yangkipm apm kai eln tolpake. Ti tu men a ukpma Maur Wailen a ntiopm ark ha kil pa, men ukweitn wor. Ti wa kitn la nisi ukwor amen ti kai ekg tu a ukpma Maur Wailen a wakrongen men ti. Apm pake, wurkapm a kupm Pol ronteitn apm kai eln tolpake. Ipma wor a Maur Wailen ntiepm arpm!");
INSERT INTO uri_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Kipm hom wampwam yikakwomwekg a Israel, yohmpei alpmento, kipm a hor ark kai ark hor pa kai, kupm ukwepm wor! Kupm Jems, kupm melnum a ak kwap a Maur Wailen, a Wailen Jisas Krais, kupm ro wurkapm rikil ekg aklin kipm. ");
INSERT INTO uri_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","Muitnwar yanipopm alkupm, kalkut a kipm ye pa, ampur kipm akwonalmpen tolpa pa paitn, kalkut wrongwailet pa wor ekg aklinjepm, ti kipm utopen om! ");
INSERT INTO uri_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","Kipm ari pa, kipm nampil Jisas Krais pa ak wang a kipm ye kalkut pa, pa ak ntekg kipm ekg kipm ntie ekg atn titnongket ukpma Jisas Krais. ");
INSERT INTO uri_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Kipm atn titnongket hor pa ye kai, ekg hi kipm paln wor, ekg hi ake kipm warkip ekg nikgwalpm wor ur a Maur Wailen. Kipm hi atn wor, ak kwap wor wrijen. ");
INSERT INTO uri_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Tol kipm warkip ekg arie a nikgwalpm wor ekg ntekg kuina ur a wor kai ikg a Maur Wailen pa, kipm ropon Maur Wailen, kil ntie ekg ukwepm. Kil melnum a ake lawen kweiur kweiur pa, kil melnum a nikgwalpm wor. Tol mla ur ropontel ekg kuina ur pa, kil uk tolti. ");
INSERT INTO uri_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Ampur kipm akwonalmpen wailet yatom kipm ropon Maur Wailen. Kipm ye nikgwalpm wrij tolti, yatom kipm ropon Maur Wailen! Melnum a ye nikgwalpm wailet pa kil atn kaingkul tol hunokg a wripm hor kai ak ntekg yatom tupor pa. ");
INSERT INTO uri_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","8","Nikgwalpm a melnum pa ark pa ark pa, tol yawrik a kil atne pa, ake wa kil atn hute. Melnum a tolpa pa ampur kil akwonalmpen tolpa, al Wailen akalmpe ropo alkilen pa yatom ukwel kweiur pa, pa kalpm. ");
INSERT INTO uri_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Melnum a ukpma Jisas Krais, kil a arpm warkip nang kalpmen ekg kweiur kweiur pa, melnum a tolpa pa kil utopen om! Kil pa nang wail ntie kweiur kweiur kai ikg a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","11","Tol Maur Wailen plan melnum a nang wail, a ntie kweiur kweiur pa tolpa kil paln warkip wrijen kai ikg alkilen pa, kil utopen om! Kweiur kweiur a kil ntie pa hi kai plaln, tol hmpei hrin ariwor a takgni rkwa, yatom kai tngklak paitn om nur. Melnum a ntie kweiur kweiur pa apm tolpake, kil hi mo tol hmpei hrin a takgni rkwa ak wang a kil arpm ak kwap ti pen. ");
INSERT INTO uri_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Melnum a atn titnongket ye kalkut pa, kil utopen om! Tol kil ake ngko, kil nampil Jisas pa atn titnongket ak wang a kil ye kalkut pa, pa hi Maur Wailen kil ukwel arpm a aklei wang, tol pike kil yipon yangkipm namponen tu a wakrongen kil. ");
INSERT INTO uri_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","Tol kalkut ur paln ekg melnum ur ak ariel pa, ampur kil akwonalmpen tolpa, Maur Wailen kil lokel nikgwalpm om kil ngko kai paitnpaitn pa, tolpa kalpm. Paitnpaitn pa ake ntie ekg al rkoln Maur Wailen kai ngko pa, wa Maur Wailen pa ake al pleln nikgwalpmel melnum ur ekg kil ngko kai paitnpaitn pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","Pa ipma wakrongen a melnum kil alkil pa ak nikgwalpm alkilen ngko kai paitnpaitn. Tol kweiur kweiur a ak nikgwalpm tukol wampung a kai ngko hmpei a melnum ur lekg pa. ");
INSERT INTO uri_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Ipma wakrongen a kil pa atn kaingkai, kil ntekg ase. Pa tol kin a itna, kai ipma wail, kai raku. Kil ntekg paitnpaitn pa tolpa kaingkai wail tolti, maur wor a kil pa apm mo ase. Pa tol warim alkil pa wreitn wail kai wa kwat warim ur. ");
INSERT INTO uri_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","Muitnwar yanipopm alkupm, ipma a kupm pa reinjepm paitn, tolpa ti kipm atn ari, ampur kipm la Maur Wailen tolpa kil pa paitn. Kil pa wor wrijen. ");
INSERT INTO uri_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","Yiprokgen a nikgwalpm wor a kweiur kweiur worwor wrongwailet pa ha kaino ha wor a Maur Wailen pa nar pake. Kil ntekg takgni, kainil, kungkumeim, a apm paln, apm paln, a ntekg mrangku alkil pa warkip watin. Pake alkilen pa ake apm paln warkip watin tolpa, kil pa apm wor tolpa atn pake. ");
INSERT INTO uri_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","Ipma wakrongen a Maur Wailen alkil pa tolpa yatom, kil uko yangkipm wor a la tolpa, Jisas Krais pike kil mo akarmpen mento, yatom mento paln tol warim alkilen, ekg al mento paln tol ekpma a tukgun hep a kil ntekg, wa kweiur kweiur wrongwailet a kil ntekg pa kul kai atn kanukg. ");
INSERT INTO uri_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","Yanipopm muitnwar alkupm, kipm itning yangkipm ti worwor! Ampur ek akipm pa kulkula ekg ekla aktutu, kalpm. Kipm nungkulkg irpme worwor pen, plaln pa, kipm ekla! Ampur kipm ipma wleket aktutu! ");
INSERT INTO uri_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","Melnum a ipma wleket tolpa pa, ake ak kwap wor kai ikg a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Tolpa ti kipm kwan nikgwalpm paitn a kweiur kweiur paitnpaitn wrongwailet pa, wa kipm rku kipm alkipm pa ekg wi yangkipm a Maur Wailen a kil arm arpm kahor ipmanikg alkipmen. Yangkipm pa la Jisas Krais a ntie ak aklinjepm akarmpentepm pake. ");
INSERT INTO uri_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","Kipm atning katnun yangkipm alkilen pa pati wor pake. Kipm atning ak nungkulkg kalpmel tolti, pa kipm akplainel ipmanikg alkipmen. ");
INSERT INTO uri_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","Melnum a atning yangkipm a Maur Wailen, pake kil ake katnun pa pati, tol melnum a wi mrangku ak ari ikgek alkilen pa. ");
INSERT INTO uri_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","Kil ak ari plaln, kil elntha tolti om kil kai, apm wa kil wonhmiten ikgek alkilen ase. ");
INSERT INTO uri_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Tol melnum ur kil wi yangkipm titnongket wor a Maur Wailen pa, kil ak ari worwor pake aklei wang ye hor pa kai. Tol ake kil wi yatom kil wonhmiten pa, kalpm. Kil wi tolti, kil ntekg komkiti, yatom yangkipm a Maur Wailen pa ak kwan titnongket a paitnpaitn akil pa om kil paln wor. Yatom kuina ur a kil ntekg pa, paln wor tolti. ");
INSERT INTO uri_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Tol melnum ur kil akwonalmpen tolpa, “Kupm kil melnum wor a ak kwap a Maur Wailen”. Ari ake kil ikghlen ek alkil pa ariworwor, pa kil akplainel ipma alkilen. Ti kwap a Maur Wailen a kil ak pa, ake paln wor ek arke. ");
INSERT INTO uri_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Kwap a Yan Maur Wailen pa pati, kil wakrongen tolpa, kipm kai iklin tu a arpm paitn, tol warim hlompo a kin karpikg. Wa kil wakrongen yat tolpa, kipm alkipm ngkom nlokgen kweiur kweiur paitnpaitn kimpilpet a atn knokg ti. Kwap a kipm ak tolpa pati, nipet wor wrijen kai ikg a Maur Wailen pake. ");
INSERT INTO uri_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","Kipm yanipopm muitnwar alkupm, tol kipm ukpma Wailen Jisas Krais, kil tukol Maur Wailen, pa ampur kipm wi wor uk melnum ur pa, wa wi paitn uk melnum ur pa, tolpa yaper! ");
INSERT INTO uri_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Tol kipm ikwonilmpen yangkipm kil: ak wang a kipm arpm atning yangkipm a Maur Wailen arpm wan alkilen pa, kipm ari melnum wail ur a ak lukglukg worwor nowe num pa kulhor wan pa, wa melnum ur a arpm warkip a nowe hapm rekel pa wa kulhor. ");
INSERT INTO uri_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","Kipm ari melnum wail a ak lukglukg worwor nowe num pa, kipm pirpiren kulamtel wrik wor pa ekg kil arpme. Pake melnum a arpm warkip pa, kipm la tolpa, “Kitn itn kwa” aki “Kitn irpm kai knokg ti!” ");
INSERT INTO uri_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","Kipm ntekg nikgwalpm tolpa pa, pa kipm ari wor aki? Pa kipm wako kipm alkipm ti atn wekg. Pa kipm ari klon melnum pa ak nikgwalpm paitn alkipmen. ");
INSERT INTO uri_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","Kipm yanipopm muitnwar alkupm! Kipm wa itning yangkipm ti: melnum a arpm warkip kai ikg a tu melnum a arpm knokg ti pa, pake kil ukpma Jisas Krais, pa kil paln melnum wail ntie kweiur kweiur kai ikg a Maur Wailen, wa kil hi wi num aklin kweiur kweiur worwor a Maur Wailen pake, tol pike kil yipon yangkipm namponen tu a wakrongen kil. ");
INSERT INTO uri_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Ti ntekg tolhai ti wa kipm uk numpaitn tu a arpm warkip pa? Ake tu pa ntekgepm paitn ukwepm kalkut rkolepm ye kai ekg ntekg yangkipm pa, kalpm. Pa tu melnum a ntie kweiur kweiur pa ntekgepm paitn pake. ");
INSERT INTO uri_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Kipm a Jisas Krais, kipm ye nang wor alkilen, ari nang wor wrijen alkilen a kipm ye pa, mla ur la paitnel? Pa apm tu kmel a ntie kweiur kweiur pa la paitnel pake! ");
INSERT INTO uri_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Tol kipm katnun yangkipm titnongket kil a hel kai wurkapm a Maur Wailen pa pati wor pake. Pa atn hep hangken yangkipm titnongket wrongwailet a Maur Wailen pa la tolpa, “Kitn wakrongen tu wrongwailet, tol a kitn wakrongen kitn alkitn!” ");
INSERT INTO uri_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Tol kipm ari melnum a arpm warkip pa, kipm wi paitn uk. Wa kipm ari melnum a arpm ntie pa, kipm wi wor uk, tolpa pa ake wor. Pa kipm kwaten yangkipm titnongket kil ase, a la tolpa, “Kitn wakrongen tu wrongwailet, tol a kitn wakrongen kitn alkitn!” ");
INSERT INTO uri_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Ekg nte, kipm katnun yangkipm titnongket wrongwailet tiur pake, kipm kwaten yangkipm wrij ur tolti pa, pa kipm ntekg paitn tol a tu melnum a kwaten yangkipm titnongket wrongwailet. ");
INSERT INTO uri_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","Maur Wailen kil la tolpa, “Ampur kitn wi kin nanen kpman nanen a kmel ur pa.” Wa kil la tolpa yat, “Ampur kitn alm melnum ur mo.” Tol ake kitn wi kin nanen kpman nanen pake, tol kitn alm melnum ur mo pa, apm pake, apm kitn ntekg paitn kwaten yangkipm titnongket wrongwailet a Maur Wailen pa yat ase. ");
INSERT INTO uri_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","Hi Maur Wailen alkil yewepm kai atn ekg ntekg yangkipm katnun yangkipm a la Krais a ntie ekg ak kwan titnongket a paitnpaitn alkipmen. Tolpa ti kipm itn worwor la yangkipmek worwor katnun yangkipm ripa. ");
INSERT INTO uri_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","Ak wang a Maur Wailen wiyepm ye kai atn ntekg yangkipm pa, kil hi ake rein melnum ur a ake rein melnum ur pa, kalpm. Kil hi wa akalmpe paitnpaitn alkilen. Melnum ur a kil rein melnum ur pa, Maur Wailen hi wa reinjel ak wang a kil hi wa atn ntekg yangkipm pa, kil hi ake akalmpe paitnpaitn alkilen pa. ");
INSERT INTO uri_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","Oi, kipm muitnwar yanipopm alkupm! Tol melnum ur la tolpa, “Kupm kil ukpma Jisas Krais”. Pake atn a arpm a kil pa paln manet, tolpa ake wor. Ukpma a kil pa hi ak aklinjel ekg ak wi maur wor akil pa ye kul ekg Maur Wailen tolhai? Kalpm. ");
INSERT INTO uri_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Tol muinwror aki muitnwror ur alkitnen kil arpm warkip ekg ekpma aki, nung aki, kweiur kweiur tolpa, ");
INSERT INTO uri_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","om kitn la tolpa, “Yek alkupm, Maur Wailen ukweitn wor, kai om! Kitn kai ka wakg pa rkgin irpm om, ntekg ekpma pa il nikgwor irpm worwor irpm om!” Ek a kitn la tolti hute, ake kitn aklinjel ekg ekpma a nung kweiur kweiur pa, kalpm. Yangkipm a kitn la tolpa pa al aklinjel tolhai? Pa kalpm. ");
INSERT INTO uri_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Kitn ukpma Jisas Krais pa apm tolpake. Kitn ukpma pake, atn a kwap a kitn ak pa paln manet. Tolpa ti ake kitn ukpma Jisas pa aklahle. ");
INSERT INTO uri_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Aki nikgwalpm alkipmen pa ur la tolpa, “Kupm kil ukpma Jisas Krais, a kitn pa atn wor ak kwap worwor, pa mentekg katnun Jisas Krais tol tita pake.” Pake kupm la naseitn tolkil: tol kitn ake ak kwap wor, atn worwor pa, al kupm ari tolhai kitn ukpma Jisas Krais aki? Pake tol kitn ari atn wor, kwap wor a kupm ntekg pa, pa planteitn tolpa kupm ukpma Jisas Krais. ");
INSERT INTO uri_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","Kitn ari tolpa Maur Wailen kil wrij hute. Kitn ari wor pake, pa tu mring maur apm wa ari tolpa yat pake. Maur Wailen kil wrij hute, ti tu kark kwarkwar paitn. ");
INSERT INTO uri_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","Nikgwalpm a kitn la tolpa pa kitn hmithmit, kitn ukpma Jisas Krais, ari kitn ake atn ariworwor, kitn ake ak kwap wor, ti a kitn ukpma Jisas Krais pa ake ngko ek arke. Ti kitn wakrongen akal ari yiprokgen a yangkipm ripa worwor aki? ");
INSERT INTO uri_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","Ti ntekg tolhai Apraham yohmpei alpmenen ti? Kil eln warim kpman alkilen Aisak elnthel kaino nung kwa weij a kil kat alile tita pa, ekg akal alm Aisak mo om lap, al wor uk Maur Wailen. Kil ntekg katnun yangkipmek a Maur Wailen pa, yatom Maur Wailen la tolpa, kil ukpma kupm, kil pa melnum nipet wor pake. ");
INSERT INTO uri_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Apraham kil ukpma Maur Wailen ti, wa kil ak kwap katnun yangkipm alkilen pa yat. Ti kitn ari aki kalpm e? Kil ak kwap katnun ek a Maur Wailen la pa ak planto tolpa, kil ukpma Maur Wailen pa aklahle. ");
INSERT INTO uri_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","Ti yangkipm a Maur Wailen a pike tu ro, ti paln aklahle ak wang a Apraham akal alm Aisak ekg al wor uk Maur Wailen, yangkipm pa la tolpa, “Apraham kil ukpma Maur Wailen, ti kil paln melnum nipet wor kai ikg a Maur Wailen.” Tolpa ti Maur Wailen kil kwewel tolpa melnum wor alkilen. ");
INSERT INTO uri_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","Ti kipm ari pa, melnum ake ntie ekg ukpma Jisas Krais kalpmel tolti, kalpm. Kil ukpma, kil ak kwap pa katnun pati, al kil paln melnum nipet wor kai ikg a Maur Wailen. Kalpm pati, pa kalpm. ");
INSERT INTO uri_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Tol Rehep, kin a pike atn ya pa yat, kil pa apm tolpake. Kil katnun yangkipmek a Maur Wailen, tolpa yatom Maur Wailen kil kwewel tolpa kil kin nipet wor kai ikg alkilen ekg kil wi melnum wekg a Israel lam, kil la nasen ya pa ekg al tuwekg ngkom nlokgen wrongmnto alntuen. ");
INSERT INTO uri_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Tol melnum ur ukpma Maur Wailen kalpmel tolti pa, ake wa kil ak kwap katnun yangkipmek a Maur Wailen la pa, kil ake ukpma pa aklahle. Ti a kil ukpma tolpa pa kai kalpm tolti tol yipmri a maur wor alkilen hor kai tukuleinjel ase. ");
INSERT INTO uri_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","Kipm yanipopm muitnwar alkupm! Kipm ari pa, men melnum a uk arie ekg yangkipm a Maur Wailen, men ntekg paitn pa, men wa hi atn yangkipm wail; tu melnum a ukpma Jisas Krais tolti pa, hi ake atn yangkipm wail. Tolpa yatom ake wor ekg al kipm melnum wailet atn hep uk arie ekg yangkipm a Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Mento melnum a ntekg paitnpaitn plaln. Ti tol melnum ur ake la yangkipmek paitn ur kai ek a kil pa, pa kil pa wor wrijen pake. Melnum a tolpa pa ntie ekg ikghlen numpwam a ek wrongwailet alkil ariworwor pake. ");
INSERT INTO uri_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Tol mento eln weij wasok ur pa elntarpm ek a hos pa, kuten hmpei pa atn ek pa ntie ekg ak lok hos pa kai ak wakrong alpmenen pa, kil pa atning nungkulkg tolti kai. ");
INSERT INTO uri_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Kipm akwonalmpen wan hunokgen pa! Wan hunokgen pa wailmanten paitn ai. Wripm titnongket wail hor ak wi wan hunokgen pa ye kai hunokg kuin pa, pake yamingkit taklo wasok tolti, ari kil wa ntie ekg ak lok wan hunokgen wail pa kai wrik ur a melnum a wamparpme yamingkit taklo pa akal kai pa. Ti wripm titnongket pa ake ntie ekg ak wi wan hunokgen pa ye kai atn tol ur pa. ");
INSERT INTO uri_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Tol ek a men ti wasikyek, ari ntie ekg ak la kweiur paitnpaitn ti wailet wa kat nang alkilen pa. Ti tol wakgyelk waitketn ur kil tupor eln nar krpo al kweiur nungkor waitketn ur pa nungkwat wail tolti kai krpo al ming wail ur hor pa kai. ");
INSERT INTO uri_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","Ti ek amen pa tol wakg pa, paitnpaitn wrongwailet pa apm paln kai ek amen pa kai pake. Ek wasikyek a num amen ti ak ntekg numpwam wrongwailet, a atn a arpm amen ti kai paitn. Tol wakg a krpo al ming wail ur pa, wakg pa nungkwat ha kai maur paitn pa kul pake. ");
INSERT INTO uri_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Wlikgek, wel, a kweiur kweiur wasok, a wail, a kweiur kweiur tilipmingken wrongwailet, a kweiur kweiur hunokgen pa melnum pa uk ikghlen, pa ntie ekg paln wampil ase. ");
INSERT INTO uri_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","Ari ek a men ti pa kalpm, paln paitn wrijen atn tolti, tol wanin a pleln alm kmel ak tukgunakg ak nimpilpm pa. Melnum ur ake ntie ekg ikghlen ek akil pa, kalpm. ");
INSERT INTO uri_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","Wangkur pa ek amen ti ak kat nang a Wailen, a Yan Wailen. Wa wangkur pa ek amen ti ak la paitnel ekg melnum ur a Maur Wailen kil ntekg tol kil alkil. ");
INSERT INTO uri_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","Ek amen pa paln wekg, paln wor ekg ak kat nang a Maur Wailen, a paln paitn ekg ak la paitnel melnum ur. Kipm muitnwar yanipopm alkupm, ek amen ak la tolpa pa paitn, elnten om! ");
INSERT INTO uri_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Hulkung ur ake al yinokg a hukupuk pa ark wrij, tolpa kalpm. ");
INSERT INTO uri_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","Muitnwar yanipopm alkupm! Mento ari pa, yo fik pa ake ntie ekg al ngko hmpei wain ek, wa hmpei wain pa ake ntie ekg al ngko yo fik ek pa, kalpm. Apm tolpa yat pake, mento ake ntie ekg nong hukupuk pa kai yinokg pa, kalpm. Ti ek amen ti apm tolpake, ampur paln wekg ak la yangkipm wor a paitn pa, tolpa yaper! ");
INSERT INTO uri_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","Tol melnum ur kai kuin alkipmen pa kil la tolpa, kil arie wor a nikgwalpm wor pa, al kil arku nang akil pa, wa atn wor a arpm wor. Kil ntekg tolpa pa, pa tu ari tolpa kil pa melnum a arie wor a nikgwalpm wor pake. ");
INSERT INTO uri_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Tol kahor ipmanikg wonen akil pa, kil akwonalmpen ipma alkilen pa, a ipma alkilen pa wreitn ekg ak kle melnum ur, a kil ari kweiur kweiur a mla ur a ntie kweiur kweiur wailet pa, kil ipmanikg paitn. Tolpa pa, ake wor ekg kil kat nang akil pa tolpa, kil wi arie wail pa. Pa kil akplainel kil alkil, kil ake katnun yangkipm a Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","Arie a tolpa pa ake Maur Wailen pa ukwel, pa kalpm. Arie a tolpa pa arie a ipma peset a knokg ti tolti. Pa hakai maur paitn pa kul pake. ");
INSERT INTO uri_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","Tu melnum a ipma paitn ekg melnum ur, a kat nang alntuen a arku nang a melnum ur pa, tu melnum a tolpa pa, tu ntekg paitnpaitn wrongwailet, yatom tu ak ro ipma wrij a kipm ukpma Maur Wailen pa kai ark manman. ");
INSERT INTO uri_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Melnum a wi arie wor, nikgwalpm wor a Maur Wailen ukwel pa tol kil: atn hep pati la tolpa: kil melnum nipet wor, kanukg pa la tolpa: kil hretel ekg kle er tita, kil nikgwalpm wor, arpm atn mehen, kil melnum a hor hanekg mla ur, kil melnum a ipma rein, kil ak kwap a Maur Wailen wor tol yo a ngko ark ye ek wor. Kil ake ari klon la tolpa melnum ur wor, melnum ur paitn. Kil melnum a la yangkipmek aklahle, a ntekg kweiur kweiur aklahle tolti. ");
INSERT INTO uri_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","Tol melnum ur kil arpm ipma wrij namponen mla ur, tol kil hretel ekg kle er tita, pa tol kil alin ekpma wor. Tol kil arpm ipma wrij pa, ekg atn a arpm alkilen pa paln nipet wor, pa tol ekpma wor a kil kitin. ");
INSERT INTO uri_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Nikgwalpm a kipm alm er tita kle tita pa kipm wi kai hai? Nikgwalpm a tolpa pa paln kahor ipmanikg alkipmen. Nikgwalpm a kipm wreitn arikowe, ak wakrongen kweiur kweiur wrongwailet, akwonalmpen kuina ur wailet, nikgwalpm paitn a tolpa pa ak rkoln tita arpm kahor ipmanikg alkipmen pa, yatom kipm alm er tita kle tita pake. ");
INSERT INTO uri_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Ipmanikg a kipm pa wreitn arikowe kweiur kweiur wrongwailet a atn knokg ti, pake ake wa kipm wi, tolpa yatom kipm alm melnum mo pa. Kipm kwarkwaren kweiur kweiur a kmel ur, ari ake wa kipm wi, yatom kipm kle er tita pa. Ake kipm wi, ekg nte, ake kipm ropon Maur Wailen pa. ");
INSERT INTO uri_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Kipm ropon, pake ake kipm wi, ekg nte, kahor nikgwalpm alkipmen pa kipm akwonalmpen tolpa kipm akal wi kweiur kweiur ekg aklin kipm alkipm ti tolti hute. ");
INSERT INTO uri_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Kipm wakrongen kweiur kweiur a knokg ti, pa kipm uk yirokg Maur Wailen. Pa kipm ntekg paitn tukol kin a nuhurn kpman alkil om kai wi kpman ur pa. Kipm ari aki kalpm e? Nikgwalpm a mla ur kil ark wail ekg kweiur kweiur wrongwailet a atn knokg ti pa, kil pa wrongmnto a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Yangkipm ur a hel kai wurkapm a Maur Wailen pa la tolpa, “Maur wor a kil elntarpm kahor ipma alpmenen ti pa, kil lawen ekg arpm hor hanekg ekg kil alkil wrij.” Yangkipm a Maur Wailen ti a kipm atning pa, yangkipm kalpmel ur tolti aki? Pa kalpm, pa yangkipm aklahle. ");
INSERT INTO uri_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Pake ipma rein a Maur Wailen rein mento pa wailmanten paitn, tol a wurkapm alkilen pa la, “Tol melnum ur a kil kat nang alkilen pa, al Maur Wailen kil ukwel yirokg. Melnum a kil arku kil alkil pa, Maur Wailen kil rein aklinjel.” ");
INSERT INTO uri_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Tolpa ti kipm rku kipm alkipm hor hanekg ekg Maur Wailen, ekg atn titnongket talpuln Maur Paitn Satan pa, ekg al kil kark kai tukuleinjepm. ");
INSERT INTO uri_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Kipm kai yampingken Maur Wailen, om Maur Wailen kil kul yampingken kipm! Kipm melnum a ntekg paitnpaitn pa, kipm klak wam a kipm pa! Kipm melnum a nikgwalpm wekg pa, kipm elnten nikgwalpm paitn pa, om kipm rkul nikgwalpm wor pa ye itn! ");
INSERT INTO uri_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Kipm a arpm ipma utopen pa, kipm irpm ipma kalkut om! Ampur kipm nmpa, kipm hakg rein paitnpaitn a kipm ntekg pa om! ");
INSERT INTO uri_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Kipm rku kipm alkipm pa hor hanekg ekg Maur Wailen pa, ekg al kil kat nang alkipmen. ");
INSERT INTO uri_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","Kipm yanipopm muitnwar alkupm, ampur kipm la yangkipm paitnel ekg tita. Tol melnum ur kil la paitnel melnum ur pa aki ari klon melnum ur pa, pa kil la paitnel yangkipm titnongket a Maur Wailen pa, wa kil la yangkipm titnongket akil pa paitn. Tol kil la yangkipm titnongket a Maur Wailen pa paitn pa, kil ake komkiti yangkipm titnongket a Maur Wailen. Ti kil paln tol melnum wail a ari klon yangkipm hai wor, yangkipm hai paitn. ");
INSERT INTO uri_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","Maur Wailen kil alkil kil hi arpm atning yangkipmek amen. Kil alkil kil yiprokgen a yangkipm titnongket wrongwailet, wa kil alkil wrij a ntie ekg ntekg yangkipm. Kil alkil kil ntie titnongket ekg ak wi melnum pa ye kul wor aki ak kwan melnum pa ye kai paitn. Ti kil apm tolpake. Ti kitn ropon mla yatom kitn arpm tol melnum a arpm atning yangkipm a melnum ur pa la tolpa, kil pa wor, aki wa arpm atning yangkipm a melnum ur pa la tolpa, kil pa paitn, tolpa ake wor. ");
INSERT INTO uri_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","14","Kipm tiur pa kipm la tolpa kipm arpm ak wakrong a kipm alkipm, yatom kipm la tolpa, “Am aki hikg pa kupm kai ha wail ur ai, arpm tol wring wrij ur, kor kwap ekg akal ak kwap marpm wail ur ai.” Kipm pa itning om, kipm ari kipm hikg arpm aki kalpm e? Kipm pa tol hu yiprak a ngko ak kang pa, takgni no almpen pa, apm kai tngklak ase. Ti kipm apm tolpake. Kipm arpm waitketn tolti, apm mo ase. ");
INSERT INTO uri_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","Tolpa ti ake wor ekg kipm la tolpa. Pa wakrong a Maur Wailen alkil ai. Kil la ekg mento ntekg kuina ur pa, mento ntekg. Tolpa ti kipm la tolkil, “Tol wakrong a Wailen alkil pa, hi wa mento arpm knokg ti watin, ekg ntekg kweiur kweiur aur aur arpm knokg ti pen.” ");
INSERT INTO uri_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Ari ake kipm la tolpa, kalpm. Kipm akwonalmpen kipm alkipm ti tol kipm ntie titnongket. Ake wor ekg melnum ur kat nang a kil alkil. Tolpa ake wor. ");
INSERT INTO uri_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Ti kipm ikwonilmpen kil worwor: tol melnum ur kil ari kweiur kweiur wor ekg akal kil ntekg, pake ake wa kil ntekg, pa kil ntekg paitnpaitn. ");
INSERT INTO uri_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","Kupm akal la yangkipm kil nasi kipm melnum a ntie kweiur kweiur wailet, kipm itning! Kipm akwonalmpen kalkut wailmanten hi wa kipm ye kanukg, ti kipm hakg rein om! ");
INSERT INTO uri_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Kweiur kweiur wrikya alkipmen pa htnok al paitn a hapmnung kweiur kweiur alkipmen pa tumpung kwatkwat. ");
INSERT INTO uri_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Kipm kor tita marpm kweiur kweiur worwor wailet pa elntirk, ari ake kipm akwonalmpen wang humpuen a kul yampingken ti. Marpm a kweiur kweiur worwor alkipmen pa kai kimpilpet, kweiur kweiur wailet alkipmen a atn kimpilpet pa hi wa ak la kwap a kipm ak pa ake wor, pa hi wa alepm tol wakg pa. ");
INSERT INTO uri_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Kipm itning! Tu melnum a aktepm kwap kitin kweiur kweiur kai wring alkipmen pa, tu hakg la wailet ekg ake kipm armpenten, ti Maur Wailen ntie titnongket apm kil atning ase. ");
INSERT INTO uri_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Ak wang a kipm arpm knokg ti kipm ntie kweiur kweiur worwor wailet ak ntekg kipm alkipm ti arpm utopen. Kipm ntie kweiur kweiur worwor wrongwailet, pake kipm atn hmit, tol mnto a tu uk ti atn hmit akwekgel wang a tu akal almpel mo pa. ");
INSERT INTO uri_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","Kipm wi melnum nipet wor ye kai atn ntekg yangkipm, kipm erel mo, pake ake kil akalmpe wam a kipm erel pa, kil uk num tolti. ");
INSERT INTO uri_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Kipm yanipopm muitnwar alkupm, kipm rku ipmanikg alkipm pa itn titnongket nungkwangen wang a Wailen, Jisas Krais, kil nar. Kipm rku ipma alkipmen pa itn nungkwangen tol melnum a ntekg wring pa, yatom kil arku ipma alkil pa atn titnongket nungkwangen wang a hu a takgni ak ntekg knokg pa ekg ekpma pa paln wor. ");
INSERT INTO uri_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","Kipm apm tolpake. Kipm rku ipma alkipm pa itn titnongket, ipma alkipmen pa irpm kulkula, ekg nte, wang a Wailen nar pa ake atn watin, wang apm kul yampingken tike. ");
INSERT INTO uri_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Yanipopm muitnwar alkupm, ampur kipm ipma paitn la yangkipm helyirokgel tita pa, al Maur Wailen wiyepm ye kai atn yangkipm. Melnum a arpm atning yangkipm pa hi wa nar pa, wang apm kul yampingken tike. ");
INSERT INTO uri_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Kipm muitnwar yanipopm alkupm, kipm ikwonilmpen tu melnum ek wripm a Maur Wailen a pike laron ak nang a Maur Wailen. Tu pike arku ipma alntu pa atn titnongket ye kalkut. Ti kipm ntekg tol tu pa om, kipm rku ipma alkipm pa itn titnongket ekg ye kalkut. ");
INSERT INTO uri_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","Mento kat nang a tu melnum a Maur Wailen ekg pike tu arku ipma alntu pa atn titnongket ye kalkut. Kipm atning por a Jop pa ase, kil pike ye kalkut wail arku ipma alkil pa atn titnongket tolpa kaingkai, kanukg pa Wailen kil reinjel om aklinjel. Aklahle, Wailen pa melnum a ipma wor a ipma rein ekg mento melnum ti. ");
INSERT INTO uri_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Kipm muitnwar yanipopm alkupm, kipm itning yangkipm titnongket kil! Ampur kipm ukwe msan, aki kwe Maur Wailen wam kaino kwa, aki la kweiur a ak titnongketel yangkipm ur a kipm la pa. Kipm la aklahle pa, apm pake. Kalpm pa, kalpm. Pa Maur Wailen kil hi ake wa la yangkipm ur ntiepm ak wang a kil wiyepm ye kai atn ntekg yangkipm. ");
INSERT INTO uri_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Kipm mla ur a ye kalkut pa, kipm ropon Maur Wailen. Wa kipm mla ur a arpm utopen pa, kipm ak nangnang ak kat nang a Maur Wailen. ");
INSERT INTO uri_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","Melnum ur kil numpet pa, kil kwe tu melnum a atn hep ekg ak kwap a Maur Wailen pa, tu kul eln kweiur tol hu yuwa pa eln hel melnum numpet pa kai nang a Wailen Jisas Krais, ropon Maur Wailen ekg al kil ntekg kil paln wor. ");
INSERT INTO uri_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","Tol tu ukpma Maur Wailen ekg kil ntie ekg akalmpe kuina ur a tu ropontel pa, yatom tu ropontel, pa kil aklin melnum ripa wreitn paln wor. Tol kil ntekg paitnpaitn ur pa, pa Maur Wailen kil wa kwan paitnpaitn a kil ntekg pa. ");
INSERT INTO uri_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Tolpa ti kipm wrij wrij laron paitnpaitn alkipmen pa la nasi tita om, wa kipm ropon Maur Wailen pa iklin tita ekg al kil ntekg kipm pa paln wor. Ropo a melnum nipet wor pa titnongket, om ropo akil pa paln ngko ek arke wailet. ");
INSERT INTO uri_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","Ilaija pa melnum ur tol mento tike. Kil pike ropon Maur Wailen titnongket la tolpa, hu pa ake al wei. Tolpa yatom hu pa pike ake wei atn knokg ti tol wring wraur wompel. ");
INSERT INTO uri_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Yatom wa kil ropon nti ur, yatom hu pa wei nar ak ntekg knokg pa, yatom tu ntekg kweiur kweiur pa wa paln wor atn wring pa. ");
INSERT INTO uri_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","20","Kipm muitnwar yanipopm alkupm, tol melnum ur ngko kai uk yirokg yangkipm wor aklahle a Maur Wailen pa, wa melnum ur wiyel ye kul pa, tol kitn melnum pa, kitn itning yangkipm kil. Kitn wi melnum pa yewel kul, yatom kitn aklin maur wor a kil pa paln wor. Kalpm pa, maur wor akil pa al mo. Kitn ak kwap wor, yatom Maur Wailen kwan paitnpaitn wrongwailet a kil ntekg pa. Yangkipm a kupm Jems ro pa apm kai eln tolpake.");
ALTER TABLE uri_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
