﻿USE sofia;
DROP TABLE IF EXISTS sofia.urdoucv_vpl;
CREATE TABLE urdoucv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES urdoucv_vpl WRITE;
INSERT INTO urdoucv_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","اِبتدا میں خُدا نے آسمان اَور زمین کو خلق کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","تَب زمین بے ڈول اَور سُنسان تھی، اَور گہراؤ کے اُوپر تاریکی چھائی ہویٔی تھی اَور خُدا کی رُوح پانی کی سطح پر جنبش کرتی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","اَور خُدا نے فرمایا، ”رَوشنی ہو جا،“ اَور رَوشنی ہو گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","خُدا نے دیکھا کہ رَوشنی اَچھّی ہے اَور اُس نے رَوشنی کو تاریکی سے جُدا کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","خُدا نے رَوشنی کو ”دِن“ اَور تاریکی کو ”رات“ کا نام دیا۔ تَب شام ہُوئی اَور پھر صُبح یہ پہلا دِن تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","اَور خُدا نے فرمایا، ”پانیِوں کے درمیان فِضا ہو تاکہ وہ پانی کو پانی سے جُدا کر دے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","چنانچہ خُدا نے فِضا کو قائِم کیا اَور فِضا کے نیچے کے پانی کو فِضا کے اُوپر کے پانی سے جُدا کر دیا اَور اَیسا ہی ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","خُدا نے فِضا کو ”آسمان“ کا نام دیا اَور شام ہُوئی اَور پھر صُبح یہ دُوسرا دِن تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","اَور خُدا نے فرمایا، ”آسمان کے نیچے کا پانی ایک جگہ جمع ہو اَور خُشکی نموُدار ہو اَور اَیسا ہی ہُوا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","خُدا نے خُشکی کو ”زمین“ کا نام دیا اَورجو پانی جمع ہو گیا تھا اُسے ”سمُندر“ کا نام دیا۔ اَور خُدا نے دیکھا کہ یہ اَچھّا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","تَب خُدا نے فرمایا، ”زمین سبزی پیدا کرے جَیسے بیج والے پَودے اَور بیج والے پھلدار درخت جو اَپنی اَپنی جنس کے مُطابق زمین پر پھُولیں پھلیں۔“ اَور اَیسا ہی ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","تَب زمین نے سبزی پیدا کی یعنی بیج دار پَودے اَور پھلدار درخت جِن میں اَپنی اَپنی جنس کے مُطابق بیج ہوتے ہیں اَور خُدا نے دیکھا کہ یہ اَچھّا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","اَور شام ہُوئی اَور پھر صُبح یہ تیسرا دِن تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","اَور خُدا نے فرمایا، ”دِن کو رات سے الگ کرنے کے لیٔے آسمان کی فِضا میں نیّر ہُوں تاکہ وہ موسموں دِنوں اَور برسوں میں اِمتیاز کرنے کے لیٔے نِشان ٹھہریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","اَور وہ آسمان کی فِضا میں چمکیں، تاکہ زمین پر رَوشنی ڈالیں،“ اَور اَیسا ہی ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","خُدا نے دو بڑی رَوشنیاں بنائیں بڑی رَوشنی یعنی سُورج دِن پر حُکومت کرنے کے لیٔے اَور چُھوٹی رَوشنی یعنی چاند رات پر حُکومت کرنے کے لیٔے۔ خُدا نے سِتارے بھی بنائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","خُدا نے اُنہیں آسمان کی فِضا میں قائِم کیا تاکہ وہ زمین پر رَوشنی ڈالیں، ");
INSERT INTO urdoucv_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","دِن اَور رات پر حُکومت کریں اَور رَوشنی کو تاریکی سے جُدا کریں۔ اَور خُدا نے دیکھا کہ یہ اَچھّا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","اَور شام ہُوئی اَور پھر صُبح یہ چوتھا دِن تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","اَور خُدا نے فرمایا، ”پانی جانداروں کی کثرت سے بھر جائے اَور پرندے زمین کے اُوپر آسمان کی فِضا میں پرواز کریں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","چنانچہ خُدا نے بڑی بڑی سمُندری مخلُوقات کو اَور سَب زندہ اَور حرکت کرنے والی اَشیا کو جو پانی میں کثرت سے پائی جاتی ہیں اَور طرح طرح کے پرندوں کو اُن کی جنس کے مُطابق پیدا کیا۔ اَور خُدا نے دیکھا کہ یہ اَچھّا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","خُدا نے اُنہیں برکت دی اَور کہا، ”پھُولو، پھلو اَور تعداد میں بڑھو اَور سمُندر کے پانی کو بھر دو اَور پرندے زمین پر بہت بڑھ جایٔیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","اَور شام ہُوئی اَور صُبح ہویٔی، یہ پانچواں دِن تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","اَور خُدا نے فرمایا، ”زمین جانداروں کو اَپنی اَپنی جنس کے مُطابق پیدا کرے جَیسے مویشی، زمین پر رینگنے والے جاندار اَور جنگلی جانوروں کو جو اَپنی اَپنی قِسم کے مُطابق ہُوں اَور اَیسا ہی ہُوا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","خُدا نے جنگلی جانوروں کو اُن کی اَپنی اَپنی جنس کے مُطابق، مویشیوں کو اُن کی اَپنی اَپنی جنس کے مُطابق اَور زمین پر رینگنے والے تمام جانداروں کو اَپنی اَپنی جنس کے مُطابق بنایا اَور خُدا نے دیکھا کہ یہ اَچھّا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","تَب خُدا نے فرمایا، ”آؤ ہم اِنسان کو اَپنی صورت اَور اَپنی شَبیہ پر بنائیں اَور وہ سمُندر کی مچھلیوں، ہَوا کے پرندوں، مویشیوں، اَور ساری زمین پر اَور اُن تمام زمین کی مخلُوقات پر رینگنے والے جنگلی جانوروں پر، اِختیار رکھے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","چنانچہ خُدا نے اِنسان کو اَپنی صورت پر پیدا کیا، اُسے خُدا کی صورت پر پیدا کیا؛ اَور اُنہیں مَرد اَور عورت کی شکل میں پیدا کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","خُدا نے اُنہیں برکت دی اَور اُن سے کہا، ”پھُولو پھلو اَور تعداد میں بڑھو اَور زمین کو معموُر و محکُوم کرو۔ سمُندر کی مچھلیوں، ہَوا کے پرندوں اَور ہر جاندار مخلُوق پرجو زمین پر چلتی پھرتی ہے، اِختیار رکھو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","پھر خُدا نے فرمایا، ”مَیں تمام رُوئے زمین پر کا ہر بیج دار پَودا اَور ہر درخت جِس میں اُس کا بیج دار پھل ہو تُمہیں دیتا ہُوں۔ وہ تمہاری خُوراک ہوں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","اَور مَیں زمین کے تمام چرندوں اَور ہَوا کے کُل پرندوں اَور زمین پر رینگنے والوں کے لیٔے جِن میں زندگی کا دَم ہے، ہر طرح کے سبز پَودے خُوراک کے طور پر دیتا ہُوں۔“ اَور اَیسا ہی ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","اَور خُدا نے جو کچھ بنایا تھا اُس پر نظر ڈالی اَور وہ بہت ہی اَچھّا تھا اَور شام ہویٔی اَور صُبح ہویٔی، یہ چھٹا دِن تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","اِس طرح آسمان اَور زمین کا اَورجو کچھ اُن میں تھا اُن سَب کا بنایا جانا مُکمّل ہو گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ساتویں دِن تک خُدا نے اُس کام کو پُورا کیا جسے وہ کر رہے تھے؛ چنانچہ ساتویں دِن وہ اَپنے سارے کام سے فارغ ہُوئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","اَور خُدا نے ساتویں دِن کو برکت دی اَور اُسے مُقدّس ٹھہرایا، کیونکہ اُس دِن خُدا نے تخلیقِ کائِنات کے سارے کام سے فراغت پائی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","یہ ہے آسمان اَور زمین کی پیدائش جَب وہ وُجُود میں لایٔے گیٔے۔ جَب یَاہوِہ خُدا نے زمین اَور آسمان کو بنایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","تو اُس وقت نہ تو کھیت کی کویٔی جھاڑی زمین پر نموُدار ہویٔی تھی اَور نہ ہی کھیت کا کویٔی پَودا اُگا تھا، کیونکہ یَاہوِہ خُدا نے زمین پر پانی نہیں برسایا تھا اَور نہ زمین پر کویٔی اِنسان ہی تھا جو کاشتکاری کرتا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","لیکن زمین سے کُہر اُٹھتی تھی جو تمام رُوئے زمین کو سیراب کرتی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","یَاہوِہ خُدا نے زمین کی مٹّی سے اِنسان کو بنایا اَور اُس کے نتھنوں میں زندگی کا دَم پھُونکا اَور آدمؔ زندہ نَفس بنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","اَور یَاہوِہ خُدا نے مشرق کی جانِب عدنؔ میں ایک باغ لگایا اَور آدمؔ کو اُنہُوں نے بنایا تھا اَور وہاں رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","اَور یَاہوِہ خُدا نے زمین سے ہر قِسم کا درخت اُگایا جو دیکھنے میں خُوشنما اَور کھانے میں لذیذ تھا۔ اُس باغ کے درمیان زندگی کا درخت اَور نیک و بد کی پہچان کا درخت بھی تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","عدنؔ سے ایک ندی نکلتی تھی جو اُس باغ کو سیراب کرتی ہُوئی چاروں ندیوں میں بٹ جاتی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","پہلی ندی کا نام پشونؔ ہے جو حَویلہؔ کی ساری زمین کو جہاں سونا ہوتاہے، گھیرے ہویٔے ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","اُس زمین کا سونا عُمدہ ہوتاہے اَور وہاں موتی اَور سنگِ سُلیمانی بھی ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","دُوسری ندی کا نام گیحونؔ ہے جو کُوشؔ کی ساری زمین کو گھیرے ہویٔے ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","تیسری ندی کا نام حِدیکیل ہے جو اشُور کے مشرق کو جاتی ہے اَور چوتھی ندی کا نام فراتؔ ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","اَور یَاہوِہ خُدا نے آدمؔ کو باغِ عدنؔ میں رکھا تاکہ اُس کی باغبانی اَور نِگرانی کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","اَور یَاہوِہ خُدا نے آدمؔ کو حُکم دیا، ”تُم اِس باغ کے کسی بھی درخت کا پھل بے روک ٹوک کھا سکتے ہو؛ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","لیکن تُم نیک و بد کی پہچان کے درخت کا پھل ہرگز نہ کھانا، کیونکہ جَب تُم اُسے کھاؤگے تو یقیناً مَر جاؤگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","یَاہوِہ خُدا نے فرمایا، ”آدمؔ کا اکیلا رہنا اَچھّا نہیں۔ مَیں ایک مددگار بناؤں گا جو اُس کا ہم شریک ہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","تَب یَاہوِہ خُدا نے تمام جنگلی جانور اَور ہَوا کے سَب پرندے زمین پر بنائے اَور وہ اُنہیں آدمؔ کے پاس لے آئے، تاکہ دیکھیں کہ وہ اُن کے کیا نام رکھتا ہے؛ اَور آدمؔ نے ہر جاندار مخلُوق کو جِس نام سے پُکارا، وُہی اُس کا نام ٹھہرا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","اِس طرح آدمؔ نے سبھی مویشیوں، ہَوا کے پرندوں اَور سارے جنگلی جانوروں کے نام رکھے۔ لیکن آدمؔ کے لیٔے اُس کی مانند کوئی مددگار نہ مِلا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","تَب یَاہوِہ خُدا نے آدمؔ پر گہری نیند بھیجی؛ اَور جَب آدمؔ سو رہے تھے، تو یَاہوِہ نے آپ کی پسلیوں میں سے ایک پسلی نکال لی اَور اُس کی جگہ گوشت بھر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","تَب یَاہوِہ خُدا نے اُس پسلی سے جسے خُدا نے آدمؔ میں سے نکالا تھا، ایک عورت بنائی اَور وہ آدمؔ کے پاس لے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","آدمؔ نے فرمایا، ”اَب یہ میری ہڈّیوں میں سے ہڈّی، اَور میرے گوشت میں سے گوشت ہے؛ وہ ’ناری‘ کہلائے گی، کیونکہ وہ نر سے نکالی گئی تھی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","اِس لیٔے مَرد اَپنے باپ اَور ماں سے جُدا ہوکر اَپنی بیوی کے ساتھ مِلا رہے گا اَور وہ دونوں ایک جِسم ہوں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","اَور آدمؔ اَور اُن کی بیوی دونوں ننگے تھے، اَور شرماتے نہ تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","یَاہوِہ خُدا نے جتنے جنگلی جانور بنائے تھے، سانپ اُن سَب سے عیّار تھا۔ اُس نے عورت سے کہا، ”کیا واقعی خُدا نے فرمایاہے کہ تُم باغ کے کسی درخت کا پھل نہ کھانا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","عورت نے سانپ سے کہا، ”ہم باغ کے درختوں کا پھل کھا سکتے ہیں، ");
INSERT INTO urdoucv_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","لیکن خُدا نے یہ ضروُر فرمایاہے کہ جو درخت باغ کے درمیان ہے، ’اُس کا پھل مت کھانا بَلکہ اُسے چھُونا تک نہیں، ورنہ تُم مرجاؤگے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","تَب سانپ نے عورت سے کہا، ”تُم ہرگز نہیں مروگے! ");
INSERT INTO urdoucv_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","بَلکہ خُدا جانتا ہے کہ جِس دِن تُم اُسے کھاؤگے، تمہاری آنکھیں کھُل جایٔیں گی اَور تُم خُدا کی مانند نیکی اَور بدی کے جاننے والے بَن جاؤگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","جَب عورت نے دیکھا کہ اُس درخت کا پھل کھانے کے لیٔے اَچھّا اَور دیکھنے میں خُوشنما اَور حِکمت پانے کے لیٔے خُوب مَعلُوم ہوتاہے، تو اُس نے اُس میں سے لے کر کھایا اَور اَپنے خَاوند کو بھی دیا، جو اُس کے ساتھ تھا اَور اُس نے بھی کھایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","تَب اُن دونوں کی آنکھیں کھُل گئیں اَور اُنہیں مَعلُوم ہُوا کہ وہ ننگے ہیں۔ اَور اُنہُوں نے اَنجیر کے پتّوں کو سِی کر اَپنے لیٔے پیش بند بنا لیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","تَب آدمؔ اَور اُن کی بیوی نے یَاہوِہ خُدا کی آواز سُنی جَب کہ وہ دِن ڈھلے باغ میں گھُوم رہے تھے اَور وہ یَاہوِہ خُدا کے حُضُوری سے باغ کے درختوں میں چھُپ گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","لیکن یَاہوِہ خُدا نے آدمؔ کو پُکارا اَور پُوچھا، ”تُم کہاں ہو؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","آدمؔ نے جَواب دیا، ”مَیں نے باغ میں آپ کی آواز سُنی اَور مَیں ڈر گیا کیونکہ مَیں ننگا تھا اِس لیٔے مَیں چھُپ گیا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","اَور یَاہوِہ نے فرمایا، ”تُمہیں کِس نے بتایا کہ تُم ننگے ہو؟ کیا تُم نے اُس درخت کا پھل کھایا ہے، جسے کھانے سے مَیں نے تُمہیں منع کیا تھا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","آدمؔ نے کہا، ”جِس عورت کو آپ نے یہاں میرے ساتھ رکھا ہے اُس نے مُجھے اُس درخت کا وہ پھل دیا اَور مَیں نے اُسے کھا لیا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","تَب یَاہوِہ خُدا نے عورت سے فرمایا، ”تُم نے یہ کیا کیا؟“ عورت نے کہا، ”سانپ نے مُجھے بہکایا اَور مَیں نے کھایا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","تَب یَاہوِہ خُدا نے سانپ سے کہا، ”چونکہ تُونے یہ کیا ہے، ”اِس لیٔے تُو گھریلو مویشیوں میں، اَور تمام جنگلی جانوروں میں ملعُون ٹھہرا! تُو اَپنے پیٹ کے بَل رینگے گا، اَور اَپنی عمر بھر خاک چاٹے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","اَور مَیں تیرے اَور عورت کے درمیان، اَور تیری نَسل اَور اُس کی نَسل کے درمیان؛ عداوت ڈالوں گا؛ وہ تیرا سَر کُچلے گا، اَور تُو اُس کی اِیڑی پر کاٹے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","پھر خُدا نے عورت سے فرمایا، ”مَیں تمہارے دردِ حَمل کو بہت بڑھاؤں گا؛ تُو درد کے ساتھ بچّے جنے گی۔ اَور تیری رغبت اَپنے خَاوند کی طرف ہوگی، اَور وہ تُجھ پر حُکومت کرےگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","اَور خُدا نے آدمؔ سے فرمایا، ”چونکہ تُم نے اَپنی بیوی کی بات مانی اَور اُس درخت کا پھل کھایا، ’جسے کھانے سے مَیں نے منع کیا تھا،‘ ”اِس لیٔے زمین تمہارے سبب سے ملعُون ٹھہری، تُم محنت اَور مشقّت کرکے عمر بھر اُس کی پیداوار کھاتے رہوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","وہ تمہارے لیٔے کانٹے اَور اُونٹ کٹارے اُگائے گی، اَور تُم کھیت کی سبزیاں کھاؤگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","تُم اَپنے ماتھے کے پسینے کی روٹی کھاؤگے: جَب تک کہ تُم زمین میں پھر لَوٹ نہ جاؤ، اِس لیٔے کہ تُم اُسی میں سے نکالے گئے ہو؛ کیونکہ تُم خاک ہو اَور خاک ہی میں پھر لَوٹ جاؤگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","آدمؔ نے اَپنی بیوی کا نام حوّاؔ رکھا، اِس لیٔے کہ وہ تمام زندوں کی ماں ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","یَاہوِہ خُدا نے آدمؔ اَور اُن کی بیوی کے لیٔے چمڑے کے کُرتے بنا کر اُنہیں پہنا دئیے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","اَور یَاہوِہ خُدا نے فرمایا، ”اَب آدمی نیک و بد کی پہچان میں ہم میں سے ایک کی مانند ہو گیا ہے۔ کہیں اَیسا نہ ہو کہ وہ اَپنا ہاتھ بڑھائے اَور زندگی کے درخت سے بھی کچھ لے کر کھالے اَور ہمیشہ جیتا رہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","لہٰذا یَاہوِہ خُدا نے اُسے باغِ عدنؔ سے نکال دیا تاکہ وہ اُس زمین کی، جِس میں سے وہ لیا گیا تھا کھیتی کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","آدمؔ کو نکال دینے کے بعد خُدا نے باغِ عدنؔ کے مشرق کی طرف کروبیوں کو اَور چاروں طرف گھُومنے والی شُعلہ زن تلوار کو رکھا تاکہ وہ زندگی کے درخت کی طرف جانے والے راستہ کی حِفاظت کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","اَور آدمؔ نے اَپنی بیوی حوّاؔ سے ہمبستری کی اَور وہ حاملہ ہُوئی، اَور حوّاؔ نے قائِنؔ کو پیدا کیا۔ حوّاؔ نے کہا، ”مُجھے یَاہوِہ کی طرف سے ایک فرزند عطا ہُواہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","اُس کے بعد قائِنؔ کے بھایٔی ہابلؔ کو پیدا کیا۔ ہابلؔ بھیڑ بکریوں کا چرواہا تھا، اَور قائِنؔ کھیتی باڑی کرتا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","کچھ عرصہ کے بعد قائِنؔ زمین کی پیداوار میں سے یَاہوِہ کے لیٔے ہدیہ لایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","اَور ہابلؔ بھی اَپنی بھیڑ بکریوں کے چند پہلوٹھے بچّے اَور اُن کی چربی لے آیا، یَاہوِہ نے ہابلؔ اَور اُس کے ہدیہ کو قبُول کیا، ");
INSERT INTO urdoucv_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","لیکن قائِنؔ اَور اُس کے ہدیہ کو منظُور نہیں کیا۔ لہٰذا قائِنؔ نہایت برہم ہُوا اَور اُس کا چہرہ اُتر گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","تَب یَاہوِہ نے قائِنؔ سے فرمایا، ”تُو کیوں برہم ہو گیا اَور تیرا چہرہ کِس لیٔے اُترا ہُواہے؟ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","اگر تُو بھلا کرے تو کیا تُو مقبُول نہ ہوگا؟ لیکن اگر تُو بھلا نہ کرے، تو گُناہ تیرے دروازہ پر دبکا بیٹھا ہے، اَور تُجھے دبوچ لینا چاہتاہے۔ لیکن تُجھے اُس پر غالب آنا چاہئے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","تَب قائِنؔ نے اَپنے بھایٔی ہابلؔ سے کہا، ”چلو ہم کھیت میں چلیں۔“ اَور جَب وہ کھیت میں تھے تو قائِنؔ نے اَپنے بھایٔی ہابلؔ پر حملہ کیا اَور اُسے قتل کر ڈالا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","تَب یَاہوِہ نے قائِنؔ سے فرمایا، ”تیرا بھایٔی ہابلؔ کہاں ہے؟“ اُس نے کہا، ”مُجھے مَعلُوم نہیں۔ کیا مَیں اَپنے بھایٔی کا نگہبان ہُوں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","تَب یَاہوِہ نے فرمایا، ”تُونے یہ کیا کیا؟ تمہارے بھایٔی کا خُون زمین سے مُجھے پُکارتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","اَب تُجھ پر لعنت ہے اَور جِس زمین نے تمہارے ہاتھ سے تمہارے بھایٔی کا خُون لینے کے لیٔے اَپنا مُنہ کھولا تھا، اُس نے تُجھے دھتکار دیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","جَب تُو زمین کو جوتے گا، تو وہ تُجھے اَپنی پیداوار نہیں دے گی؛ اَور تُو بےچین ہوکر زمین پر مارا مارا پھرتا رہے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","قائِنؔ نے یَاہوِہ سے کہا، ”میری سزا میری برداشت سے باہر ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","آج آپ مُجھے وطن سے نکال رہے ہیں اَور مَیں آپ کی حُضُوری سے روپوش ہو جاؤں گا اَور بےچین ہوکر رُوئے زمین پر مارا مارا پھرتا رہُوں گا اَورجو کویٔی مُجھے پایٔےگا، قتل کر ڈالے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","لیکن یَاہوِہ نے اُس سے فرمایا، ”اَیسا نہیں ہوگا، بَلکہ جو کویٔی قائِنؔ کو قتل کرےگا، اُس سے سات گُنا بدلہ لیا جائے گا۔“ تَب یَاہوِہ نے قائِنؔ پر ایک نِشان لگا دیا، تاکہ کویٔی اُسے پا کر قتل نہ کر دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","چنانچہ قائِنؔ یَاہوِہ کی حُضُوری سے نکل گیا اَور عدنؔ کے مشرق میں نودؔ کے علاقہ میں جا بسا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","اَور قائِنؔ نے اَپنی بیوی سے ہمبستری کی اَور وہ حاملہ ہُوئی اَور اُس سے حنوخؔ پیدا ہُوا۔ تَب قائِنؔ نے ایک شہر بسایا اَور اُس کا نام اَپنے بیٹے کے نام پر حنوخؔ رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","حنوخؔ سے عیرادؔ پیدا ہُوا، اَور عیرادؔ سے مخُویاایلؔ پیدا ہُوا۔ اَور مخُویاایلؔ سے مِتھوشاایلؔ پیدا ہُوا، اَور مِتھوشاایلؔ سے لمکؔ پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","لمکؔ نے دو عورتوں سے شادی کی، اُن میں سے ایک کا نام عدہؔ اَور دُوسری کا ضِلّہؔ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","عدہؔ کے ہاں یابلؔ پیدا ہُوا؛ وہ اُن کا باپ تھا جو خیموں میں رہتے تھے اَور مویشی پالتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","اُس کے بھایٔی کا نام یُوبلؔ تھا۔ وہ اُن لوگوں کا باپ تھا جو بربط اَور بانسری بجاتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ضِلّہؔ کے ہاں بھی تُوبل قائِنؔ نامی بیٹا پیدا ہُوا جو کانسے اَور لوہے سے مُختلف قِسم کے اوزار بناتا تھا۔ نعمہؔ، تُوبل قائِنؔ کی بہن تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","لمکؔ نے اَپنی بیویوں سے کہا، ”اَے عدہؔ اَور ضِلّہؔ! میری بات سُنو؛ اَے لمکؔ کی بیویو! میرے سُخن پر کان لگاؤ؛ مَیں نے ایک آدمی کو جِس نے مُجھے زخمی کیا تھا، مار ڈالا ہے، اَور چوٹ کھا کر ایک جَوان کو قتل کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","اگر قائِنؔ کا بدلہ سات گُنا لیا جائے گا، تو لمکؔ کا ستّر اَور سات گُنا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","اَور آدمؔ پھر اَپنی بیوی کے پاس گیا اَور اُن کے یہاں بیٹا پیدا ہُوا اَور اُس کا نام شیتؔ رکھا اَور کہا، ”خُدا نے مُجھے ہابلؔ کی جگہ جسے قائِنؔ نے قتل کیا، دُوسرا فرزند عطا فرمایا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","شیتؔ کے ہاں بھی ایک بیٹا پیدا ہُوا اَور اُس نے اُس کا نام انُوشؔ رکھا۔ اُس وقت سے لوگ یَاہوِہ کا نام لے کر دعا کرنے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","آدمؔ کا شجرہ نَسب یہ ہے: جَب خُدا نے اِنسان کو پیدا کیا، تو خُدا نے اُسے خُدا کی صورت پر بنایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","خُدا نے اِنسان کو مَرد اَور عورت کرکے پیدا کیا اَور اُنہیں برکت دی اَور جَب وہ خلق کئے گیٔے تو اُن کا نام آدمؔ رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","جَب آدمؔ ایک سَو تیس بَرس کے ہویٔے تَب اُن کے یہاں اُس کی مانند اَور اُس کی اَپنی صورت پر ایک بیٹا پیدا ہُوا اَور اُس نے اُس کا نام شیتؔ رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","شیتؔ کی پیدائش کے بعد آدمؔ آٹھ سَو بَرس تک زندہ رہے اَور اُن کے یہاں اَور بیٹے اَور بیٹیاں پیدا ہُوئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","آدمؔ پُورے نَو سَو تیس بَرس تک زندہ رہے اَور پھر اُن کی وفات ہوئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","شیتؔ ایک سَو پانچ بَرس کے تھے جَب اُن کے یہاں انُوشؔ پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","اَور انُوشؔ کی پیدائش کے بعد شیتؔ آٹھ سَو سات بَرس تک جیتے رہے اَور اُن کے یہاں اَور بیٹے اَور بیٹیاں پیدا ہُوئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","شیتؔ نے پُورے نَو سَو بَارہ بَرس زندہ رہنے کے بعد وفات پائی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","انُوشؔ نوّے بَرس کے ہویٔے تَب اُن کے یہاں قینانؔ پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","اَور قینانؔ کی پیدائش کے بعد انُوشؔ آٹھ سَو پندرہ بَرس تک جیتے رہے اَور اُن کے یہاں اَور بیٹے اَور بیٹیاں پیدا ہُوئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","انُوشؔ کی کُل عمر نَو سَو پانچ بَرس کی ہُوئی اَور تَب وہ مَر گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","جَب قینانؔ ستّر بَرس کا تھا تَب اُن کے یہاں مہلل ایل پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","اَور مہلل ایل کی پیدائش کے بعد قینانؔ آٹھ سَو چالیس بَرس تک جیتے رہے اَور اُن کے یہاں اَور بیٹے اَور بیٹیاں پیدا ہُوئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","قینانؔ کی کُل عمر نَو سَو دس بَرس کی ہُوئی اَور تَب وہ مَر گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","جَب مہلل ایل پَینسٹھ بَرس کا تھا تَب اُن کے یہاں یاردؔ پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","اَور یاردؔ کی پیدائش کے بعد مہلل ایل آٹھ سَو تیس بَرس تک جیتے رہے اَور اُن کے یہاں اَور بیٹے اَور بیٹیاں پیدا ہُوئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","مہلل ایل کی کُل عمر آٹھ سَو پچانوے بَرس کی ہُوئی اَور تَب وہ مَر گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","جَب یاردؔ ایک سَو باسٹھ بَرس کا تھا تَب اُن کے یہاں حنوخؔ پیدا ہُوا ");
INSERT INTO urdoucv_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","اَور حنوخؔ کی پیدائش کے بعد یاردؔ آٹھ سَو بَرس تک جیتے رہے اَور اُن کے یہاں اَور بیٹے اَور بیٹیاں پیدا ہُوئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","یاردؔ کی کُل عمر نَو سَو باسٹھ بَرس کی ہُوئی اَور تَب وہ مَر گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","جَب حنوخؔ پَینسٹھ بَرس کا تھا تَب اُن کے یہاں متُوسِلحؔ پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","اَور متُوسِلحؔ کی پیدائش کے بعد حنوخؔ تین سَو بَرس تک خُدا کے ساتھ ساتھ چلتا رہا اَور اُن کے یہاں اَور بیٹے اَور بیٹیاں پیدا ہُوئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","حنوخؔ کی کُل عمر تین سَو پَینسٹھ بَرس کی ہُوئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","حنوخؔ خُدا کے ساتھ ساتھ وفاداری سے چلتے رہے اَور پھر وہ نظروں سے غائب ہو گئے کیونکہ خُدا نے اُنہیں آسمان پر زندہ اُٹھالیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","جَب متُوسِلحؔ ایک سَو ستاسی بَرس کے ہویٔے تَب اُن کے یہاں لمکؔ پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","اَور لمکؔ کی پیدائش کے بعد متُوسِلحؔ سات سَو بیاسی بَرس تک جیتے رہے اَور اُن کے یہاں اَور بیٹے اَور بیٹیاں پیدا ہُوئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","متُوسِلحؔ کی کُل عمر نَو سَو اُنہتّر بَرس کی ہُوئی اَور تَب وہ مرگیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","جَب لمکؔ ایک سَو بیاسی بَرس کے ہویٔے تَب اُن کے یہاں ایک بیٹا پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","اُس نے اُس کا نام نوحؔا رکھا اَور کہا، ”یہ ہمیں اَپنے ہاتھوں کی محنت اَور مشقّت سے جو ہم اِس زمین پر کرتے ہیں، جسے یَاہوِہ نے ملعُون قرار دیا، آرام دے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","نوحؔا کی پیدائش کے بعد لمکؔ پانچ سَو پچانوے بَرس تک جیتے رہے اَور اُن کے یہاں اَور بیٹے اَور بیٹیاں پیدا ہُوئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","لمکؔ کی عمر سات سَو ستہتّر بَرس کی ہُوئی اَور تَب وہ مَر گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","اَور نوحؔا پانچ سَو بَرس کے تھے جَب اُن کے یہاں شِمؔ، حامؔ اَور یافیتؔ پیدا ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","جَب رُوئے زمین پر اِنسانوں کی تعداد بڑھنے لگی اَور اُن کے بیٹیاں پیدا ہُوئیں، ");
INSERT INTO urdoucv_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","تو خُدا کے بیٹوں نے دیکھا کہ آدمیوں کی بیٹیاں خُوبصورت ہیں، اَور اُنہُوں نے جِن جِن کو چُنا اُن سے شادی کرلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","تَب یَاہوِہ نے فرمایا، ”میری رُوح اِنسان کے ساتھ ہمیشہ مزاحمت نہ کرتی رہے گی کیونکہ وہ فانی ہے۔ اُس کی عمر ایک سَو بیس بَرس کی ہوگی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","اُن دِنوں میں زمین پر بڑے قدآور اَور مضبُوط لوگ مَوجُود تھے بَلکہ بعد میں بھی تھے، جَب خُدا کے بیٹے اِنسانوں کی بیٹیوں کے پاس گیٔے اَور اُن سے اَولاد پیدا ہُوئی۔ یہ قدیم زمانہ کے سُورما اَور بڑے نامور لوگ تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","یَاہوِہ نے دیکھا کہ زمین پر اِنسان کی بدی بہت بڑھ گئی ہے، اَور اِنسانی دِل کے خیالات ہمیشہ بدی کی طرف مائل رہتے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","یَاہوِہ کو افسوس ہُوا کہ اُنہُوں نے زمین پر اِنسان کو پیدا کیا اَور اُن کا دِل غم سے بھر گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","چنانچہ یَاہوِہ نے فرمایا، ”مَیں اِنسان کو جسے مَیں نے پیدا کیا، رُوئے زمین پر سے مٹا دُوں گا بَلکہ سَب کو خواہ وہ اِنسان ہُوں یا جانور؛ خواہ وہ زمین پر رینگنے والے جانور ہُوں اَور ہَوا کے پرندے۔ مُجھے افسوس ہے کہ مَیں نے اُنہیں بنایا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","لیکن نوحؔا یَاہوِہ کی نظر میں مقبُول ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","نوحؔا کے خاندانی حالات یُوں ہیں: نوحؔا راستباز اِنسان تھا اَور اَپنے زمانہ کے لوگوں میں بے عیب تھا اَور وہ خُدا کے ساتھ ساتھ وفاداری سے چلتا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","نوحؔا کے تین بیٹے تھے: شِمؔ، حامؔ اَور یافیتؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","اَب زمین خُدا کی نگاہ میں بگڑ چُکی تھی اَور ظُلم و تشدّد سے بھری ہُوئی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","خُدا نے دیکھا کہ زمین بہت بگڑ چُکی ہے، کیونکہ زمین پر سَب لوگوں نے اَپنے ضوابط بِگاڑ لیٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","چنانچہ خُدا نے نوحؔا سے فرمایا، ”مَیں سَب لوگوں کا خاتِمہ کرنے کو ہُوں، کیونکہ زمین اُن کی وجہ سے ظُلم سے بھر گئی ہے۔ اِس لیٔے مَیں یقیناً نَوع اِنسان اَور زمین دونوں کو تباہ کر ڈالوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","لہٰذا تُم صنوبر کی لکڑی کا ایک جہاز بناؤ؛ اُس میں کمرے بنانا اَور اُسے اَندر اَور باہر سے رال سے پوت دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","تُم اَیسا کرنا کہ جہاز کی تین سَو ہاتھ لمبائی، پچاس ہاتھ چوڑائی اَور تیس ہاتھ اُونچائی ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","جہاز کی چھت سے لے کر ہاتھ بھر نیچے تک روشندان بنانا۔ جہاز کے اَندر تین درجے بنانا نِچلا، درمیانی اَور بالائی، اَور جہاز کا دروازہ جہاز کے پہلو میں رکھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","دیکھو مَیں زمین پر سیلابی پانی لانے والا ہُوں تاکہ آسمان کے نیچے کا ہر جاندار یعنی ہر وہ مخلُوق جِس میں زندگی کا دَم ہے، ہلاک ہو جائے۔ سَب جو رُوئے زمین پر ہیں، مَر جایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","لیکن تمہارے ساتھ مَیں اَپنا عہد باندھوں گا اَور تُم جہاز میں داخل ہوگے۔ تُم اَور تمہارے ساتھ تمہارے بیٹے اَور تمہاری بیوی اَور تمہارے بیٹوں کی بیویاں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","اَور تمہارے تمام حَیوانات میں سے دو دو کو، جو نر اَور مادہ ہُوں، جہاز میں لے آنا تاکہ وہ تمہارے ساتھ زندہ بچ جائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ہر ایک اَپنی اَپنی جنس کے پرندے، جانوروں اَور زمین پر رینگنے والے جانداروں میں سے دو دو اَپنی اَپنی جنس کے تمہارے پاس آئیں تاکہ وہ بھی زندہ بچ جائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","اَور تُم ہر طرح کی کھانے والی چیز لے کر اَپنے پاس جمع کر لینا تاکہ وہ تمہارے اَور اُن کے لیٔے خُوراک کا کام دے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","نوحؔا نے ہر کام ٹھیک اُسی طرح کیا جَیسا خُدا نے اُنہیں حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","تَب، یَاہوِہ نے نوحؔا سے فرمایا، ”تُم اَپنے پُورے خاندان کے ساتھ جہاز میں چلے جانا کیونکہ مَیں نے اِس پُشت میں تُمہیں ہی راستباز پایا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","تُم تمام پاک جانوروں میں سے سات سات نر، اَور مادہ اَور ناپاک جانوروں میں سے ایک ایک نر اَور مادہ ساتھ لے لینا، ");
INSERT INTO urdoucv_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","اَور ہر قِسم کے پرندوں میں سے سات سات نر اَور مادہ بھی لینا، تاکہ اُن کی مُختلف نَسلیں زمین پر باقی رہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","مَیں سات دِن کے بعد زمین پر چالیس دِن اَور چالیس رات پانی برساؤں گا، اَور ہر اُس جاندار شَے کو جسے مَیں نے بنایا ہے، مٹا دُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","اَور نوحؔا نے وہ سَب کیا جِس کا یَاہوِہ نے حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","نوحؔا چھ سَو بَرس کے تھے، جَب زمین پر سیلابی پانی آیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","اَور نوحؔا اَور آپ کے بیٹے اَور آپ کی بیوی اَور آپ کے بیٹوں کی بیویاں سیلابی پانی سے بچنے کے لیٔے جہاز میں داخل ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","پاک اَور ناپاک دونوں قِسم کے جانوروں، پرندوں اَور زمین پر رینگنے والے جانوروں کے دو دو، ");
INSERT INTO urdoucv_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","نر اَور مادہ، خُدا کے دئیے گیٔے حُکم کے مُطابق نوحؔا کے پاس آئے اَور جہاز میں داخل ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","اَور سات دِن کے بعد سیلابی پانی زمین پر آ گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","جَب نوحؔا کی عمر کے چھ سَوویں بَرس کے دُوسرے مہینے کی سترھویں تاریخ تھی، اُس دِن زمین کے نیچے سے سارے چشمے پھوٹ نکلے اَور آسمانی سیلاب کے دروازے کھُل گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","اَور زمین پر چالیس دِن اَور چالیس رات لگاتار مینہ برستا رہا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","اُسی دِن نوحؔا اَور اُن کی بیوی اَپنے تین بیٹوں، شِمؔ، حامؔ اَور یافیتؔ اَور اُن کی بیویوں سمیت جہاز میں داخل ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","اَور ہر جنس کے چُھوٹے بڑے جنگلی جانور، مویشی، زمین پر رینگنے والے جانور، پرندے اَور پروں والے جاندار اُن کے ساتھ تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","یہ تمام جوڑے، جِن میں زندگی کا دَم تھا نوحؔا کے پاس آئے اَور جہاز میں داخل ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","نوحؔا کو خُدا کے دئیے گیٔے حُکم کے مُطابق، جو جاندار اَندر آئے، وہ نر اَور مادہ تھے۔ تَب یَاہوِہ نے جہاز کا دروازہ بند کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","چالیس دِن تک زمین پر سیلاب جاری رہا اَور جُوں جُوں پانی چڑھتا گیا، جہاز زمین سے اُوپر اُٹھتا چلا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","پانی زمین پر چڑھتا گیا، اَور بہت ہی بڑھ گیا اَور جہاز پانی کی سطح پر تیرتا رہا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","پانی زمین پر اِس قدر چڑھ گیا کہ سارے آسمان کے نیچے کے تمام اُونچے اُونچے پہاڑ ڈُوب گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","پانی بڑھتے بڑھتے پہاڑوں سے بھی پندرہ ہاتھ اُوپر چڑھ گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","زمین پر ہر پرندہ، ہر مویشی، جنگلی جانور اَور ہر اِنسان گویا ہر جاندار فنا ہو گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","خُشکی پر کی ہر شَے جِس کے نتھنوں میں زندگی کا دَم تھا مَر گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","یَاہوِہ نے رُوئے زمین پر کی ہر جاندار شَے مٹا دی، کیا اِنسان، کیا حَیوان، کیا زمین پر رینگنے والے جاندار اَور کیا ہَوا میں اُڑنے والے پرندے، سَب کے سَب نابود ہو گئے۔ صِرف نوحؔا باقی بچے اَور وہ جو اُن کے ساتھ جہاز میں تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","اَور سیلابی پانی زمین پر ایک سَو پچاس دِن تک چڑھتا رہا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","لیکن خُدا نے نوحؔا اَور تمام جنگلی جانوروں اَور مویشیوں کو، جو اُن کے ساتھ جہاز میں تھے یاد رکھا اَور خُدا نے زمین پر ہَوا چلائی اَور پانی کم ہو گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","اَب زمین کے نیچے کے چشمے اَور آسمانی سیلاب کے دروازے بند کر دئیے گیٔے، اَور آسمان سے مینہ کا برسنا تھم گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","اَور پانی رفتہ رفتہ زمین پر سے ہٹتا گیا اَور ایک سَو پچاس دِن کے بعد بہت کم ہو گیا، ");
INSERT INTO urdoucv_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","اَور ساتویں مہینے کے سترھویں دِن جہاز اراراطؔ کے پہاڑوں میں ایک چوٹی پر ٹِک گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","دسویں مہینے تک پانی گھٹتا رہا اَور دسویں مہینے کے پہلے دِن پہاڑوں کی چوٹیاں نظر آنے لگیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","چالیس دِن کے بعد نوحؔا نے جہاز کی کھڑکی کو کھول دیا جو اُنہُوں نے بنائی تھی ");
INSERT INTO urdoucv_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","اُنہُوں نے ایک کوّے کو باہر اُڑا دیا، جو زمین پر کے پانی کے سُوکھ جانے تک اِدھر اُدھر اُڑتا رہا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","تَب اُنہُوں نے ایک فاختہ کو اُڑایا تاکہ یہ دیکھے کہ زمین پر سے پانی ہٹا ہے یا نہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","لیکن اُس فاختہ کو اَپنے پنجے ٹیکنے کو جگہ نہ مِل سکی کیونکہ ابھی تمام رُوئے زمین پر پانی مَوجُود تھا۔ چنانچہ وہ نوحؔا کے پاس جہاز میں لَوٹ آئی۔ تَب اُنہُوں نے اَپنا ہاتھ بڑھا کر اُسے تھام لیا اَور جہاز کے اَندر اَپنے پاس لے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","مزید سات دِن اِنتظار کرنے کے بعد اُنہُوں نے پھر سے اُس فاختہ کو جہاز سے باہر بھیجا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","شام کو جَب وہ فاختہ اُن کے پاس لَوٹی تو اُس کی چونچ میں زَیتُون کی ایک تازہ پتّی تھی! تَب نوحؔا جان گئے کہ پانی زمین پر کم ہو گیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","وہ سات دِن اَور رُکے اَور فاختہ کو ایک بار پھر اُڑایا لیکن اَب کی بار وہ اُن کے پاس لَوٹ کر نہ آئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","نوحؔا کی عمر کے چھ سَو ایک بَرس کے پہلے مہینے کے پہلے دِن زمین پر مَوجُود پانی سُوکھ گیا۔ تَب نوحؔا نے جہاز کی چھت کھولی اَور دیکھا کہ زمین کی سطح خشک ہو چُکی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","اَور دُوسرے مہینے کے ستّائیسویں دِن تک زمین بالکُل سُوکھ گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","تَب خُدا نے نوحؔا سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","”تُم اَپنی بیوی اَور اَپنے بیٹوں اَور اُن کی بیویوں سمیت جہاز سے باہر نکل آؤ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","اَور اَپنے ساتھ سارے حَیوانات کو بھی نکال لاؤ جو تمہارے ساتھ ہیں یعنی پرندے، جانور اَور زمین پر رینگنے والے سَب جاندار، تاکہ زمین پر اُن کی نَسل خُوب بڑھے، وہ پھُولیں، پھلیں اَور اُن کی تعداد بہت زِیادہ ہو جائے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","چنانچہ نوحؔا اَپنے بیٹوں، اَپنی بیوی اَور اَپنے بیٹوں کی بیویوں سمیت باہر نکلے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","اَور تمام قِسم کے جانور اَور زمین پر رینگنے والے جاندار، سَب پرندے اَور ہر وہ شَے جو زمین پر چلتی پھرتی ہے، اَپنی اَپنی جنس کے مُطابق جہاز سے باہر نکل آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","تَب نوحؔا نے یَاہوِہ کے لیٔے ایک مذبح بنایا اَور سَب پاک چرندوں اَور پرندوں میں سے چند کو لے کر اُس مذبح پر سوختنی نذر کی قُربانیاں چڑھائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","جَب اُن کی فرحت بخش خُوشبو یَاہوِہ تک پہُنچی تو یَاہوِہ نے دِل ہی دِل میں کہا، ”مَیں اِنسان کے سبب سے پھر کبھی زمین پر لعنت نہ بھیجوں گا۔ حالانکہ اُس کے دِل کا ہر خیال بچپن ہی سے بدی کی طرف مائل ہوتاہے، اَور آئندہ کبھی تمام جانداروں کو ہلاک نہ کروں گا جَیسا مَیں نے کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","”جَب تک زمین قائِم ہے، تَب تک بیج بونے اَور فصل کاٹنے کے اوقات، خنکی اَور حرارت، گرمی اَور سردی، اَور دِن اَور رات، کبھی موقُوف نہ ہوں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","پھر خُدا نے نوحؔا اَور اُن کے بیٹوں کو یہ کہہ کر برکت دی، ”پھُولو پھلو اَور تعداد میں بڑھو اَور زمین کو معموُر کرو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","زمین کے تمام حَیوانات اَور ہَوا کے سَب پرندوں پر تمہارا رُعب اَور ڈر چھایا رہے گا، اَور ہر رینگنے والا جاندار اَور سمُندر کی سَب مچھلیاں تمہارے ہاتھ میں دی گئی ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ہر شَے جو زندہ ہے اَور چلتی پھرتی ہے، تمہاری خُوراک کے لیٔے ہے۔ مَیں نے سبز پَودوں کی طرح تُمہیں سَب کا سَب دے دیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","”لیکن تُم وہ گوشت جِس میں جان کا خُون باقی ہو ہرگز نہ کھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","اَور مَیں تمہارے خُون کا بدلہ ضروُر لُوں گا۔ مَیں ہر جانور سے بدلہ لُوں گا۔ ہر ایک اِنسان کے خُون کا بدلہ اِنسان سے لُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","”جو کویٔی اِنسان کا خُون کرےگا، اُس کا خُون اِنسان ہی کے ہاتھوں سے ہوگا؛ کیونکہ خُدا نے اِنسان کو اَپنی صورت پر بنایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","اَور تُم پھُولو، پھلو اَور تعداد میں بڑھو؛ زمین پر اَپنی نَسل بڑھاؤ۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","تَب خُدا نے نوحؔا اَور اُن کے بیٹوں سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","”اَب مَیں تُم سے اَور تمہارے بعد تمہاری نَسل سے عہد کرتا ہُوں ");
INSERT INTO urdoucv_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","اَور اِس کے علاوہ سَب جانداروں سے جو تمہارے ساتھ ہیں، کیا پرندے، کیا مویشی اَور کیا سَب جنگلی جانور جو تمہارے ساتھ جہاز سے باہر نکلے یعنی زمین پر مَوجُود ہر جاندار سے عہد کرتا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","مَیں تُم سے عہد کرتا ہُوں کہ پھر کبھی کویٔی جاندار سیلابی پانی سے ہلاک نہ ہوگا اَور نہ ہی زمین کو تباہ کرنے کے لیٔے پھر کبھی سیلاب آئے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","اَور خُدا نے فرمایا، ”اَورجو عہد مَیں اَپنے اَور تمہارے اَور ہر جاندار کے درمیان باندھتا ہُوں جو تمہارے ساتھ ہیں، اَورجو عہد آنے والی پُشتوں کے لیٔے ہے، اُس کا نِشان یہ ہے: ");
INSERT INTO urdoucv_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","مَیں نے بادلوں میں اَپنی قوسِ قُزح کو قائِم کیا ہے، اَور وہ میرے اَور زمین کے درمیان عہد کا نِشان ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","جَب کبھی مَیں زمین پر بادل لاؤں اَور اُن بادلوں میں قوسِ قُزح دِکھائی دے، ");
INSERT INTO urdoucv_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","تو مَیں اَپنے اِس عہد کو یاد کروں گا، جو میرے تمہارے اَور ہر قِسم کے جانداروں کے درمیان ہے، پانی پھر کبھی سیلاب کی شکل اِختیار نہ کرےگا کہ سَب جاندار ہلاک ہو جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","جَب کبھی بادلوں میں قوسِ قُزح نموُدار ہوگی، مَیں اُسے دیکھوں گا اَور اِس اَبدی عہد کو یاد کروں گا جو خُدا کے اَور زمین کے سَب طرح کے جانداروں کے درمیان ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","پس خُدا نے نوحؔا سے کہا، ”یہ اُس عہد کا نِشان ہے جو مَیں نے اَپنے اَور زمین پر مَوجُود سارے جانداروں کے درمیان قائِم کیا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","نوحؔا کے بیٹے جو جہاز سے باہر آئےتھے شِمؔ، حامؔ اَور یافیتؔ تھے۔ (حامؔ کنعانؔ کا باپ تھا۔) ");
INSERT INTO urdoucv_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","نوحؔا کے یہی تین بیٹے تھے اَور اُن کی نَسل ساری زمین پر پھیل گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","نوحؔا نے کاشتکاری شروع کی اَور انگور کا ایک باغ لگایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","جَب نوحؔا نے اُس کا کچھ انگوری شِیرہ پیا تو متوالے ہو گئے، اَور اَپنے خیمہ میں ننگے ہی جا پڑے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","کنعانؔ کے باپ حامؔ نے اَپنے باپ کو ننگا دیکھا اَور باہر آکر اَپنے دونوں بھائیوں کو بتایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","تَب شِمؔ اَور یافیتؔ نے ایک کپڑا لیا، اَور اُسے اَپنے کندھوں پر رکھ پچھلے پاؤں اَندر گیٔے اَور اَپنے باپ کے ننگے بَدن کو ڈھانک دیا۔ اُنہُوں نے اَپنے مُنہ دُوسری طرف کئے ہویٔے تھے اِس لیٔے وہ اَپنے باپ کی برہنگی کو نہ دیکھ سکے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","جَب انگوری شِیرے کا نشہ اُترا اَور نوحؔا ہوش میں آئے اَور اُن کو پتا چلا کہ اُن کے چُھوٹے بیٹے نے اُن کے ساتھ کیا کیا، ");
INSERT INTO urdoucv_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","تو نوحؔا نے فرمایا، ”کنعانؔ ملعُون ہو! اَور وہ اَپنے بھائیوں کے غُلاموں کا غُلام ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","اُنہُوں نے یہ بھی کہا، ”یَاہوِہ شِمؔ کا خُدا مُبارک ہو! اَور کنعانؔ شِمؔ کا غُلام ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","خُدا یافیتؔ کو وسعت دے؛ اَور یافیتؔ، شِمؔ کے خیموں میں بسے، اَور کنعانؔ اُس کا غُلام ہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","سیلاب کے بعد نوحؔا ساڑھے تین سَو بَرس تک اَور زندہ رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","نوحؔا کی کُل عمر ساڑھے نَو سَو بَرس کی ہویٔی، اَور تَب اُن کی وفات ہوئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","نوحؔا کے بیٹوں، شِمؔ، حامؔ اَور یافیتؔ جِن کے یہاں سیلاب کے بعد بیٹے پیدا ہویٔے، شجرہ نَسب یہ ہے: ");
INSERT INTO urdoucv_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","بنی یافیتؔ یہ ہیں: گومرؔ، ماگوگؔ، مِدائی، یاوانؔ، تُوبل، میشکؔ اَور تیِراسؔ تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","بنی گومرؔ یہ ہیں: اشکِنازؔ، ریفتؔ اَور توغرمہؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","بنی یاوانؔ یہ ہیں: اِلیشہؔ، ترشیشؔ، کِتّیمؔ اَور دودانیمؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(بحری جزیروں کے باشِندے اِن ہی کی نَسل سے ہیں، وہ اَپنی اَپنی قوموں کے درمیان مُختلف برادریوں میں تقسیم ہو گئے، اَور مُختلف مُلکوں میں پھیل گیٔے اَور ہر ایک اَپنی زبان بولتا تھا۔) ");
INSERT INTO urdoucv_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","بنی حامؔ یہ ہیں: کُوشؔ، مِصر، فُوطؔ اَور کنعانؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","بنی کُوشؔ یہ ہیں: سیبا، حَویلہؔ، سبتہؔ، رعماہؔ اَور سبتیکا۔ بنی رعماہؔ یہ ہیں: شیبا اَور دِدانؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","کُوشؔ نِمرودؔ کا باپ تھا، جو رُوئے زمین پر پہلا زبردست سُورما کے طور پر مشہُور ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","وہ خُدا کے سامنے ایک زبردست شِکاری تھا، اِسی لیٔے یہ مثل مشہُور ہو گئی، ”یَاہوِہ کے سامنے نِمرودؔ سا شِکاری سُورما!“ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","اُس کی بادشاہی کی اِبتدا مُلک شِنعاؔر سے ہُوئی جِن میں بابیل، اِریؔخ، اکّادؔ اَور کَلنہؔ واقع تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","اُس مُلک سے نکل کر وہ اشُور چلا گیا جہاں اُس نے کیٔی شہر بسائے مثلاً نینوہؔ، رحوبوتھؔ عیرؔ، کلحؔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","اَور رسنؔ جو نینوہؔ اَور کلحؔ کے درمیان بہت بڑا شہر ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","بنی مِصر لُودیؔم، عنامیمؔ، لہابیمؔ، نفتوحیؔم، ");
INSERT INTO urdoucv_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","فتروسیم، کسلوحیم (جِن سے فلسطینی نکلے) اَور کفتُوری پیدا ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","بنی کنعانؔ اُس کا پہلوٹھا صیدونؔ پیدا ہُوا اَور حِتّی، ");
INSERT INTO urdoucv_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","اَور یبُوسی، امُوری، گِرگاشی، ");
INSERT INTO urdoucv_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","اَور حِوّیؔ، عَرکی، سیِنی ");
INSERT INTO urdoucv_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","اَور اَروادیؔ، ضِماریؔ اَور حماتیؔ پیدا ہویٔے۔ (بعد میں کنعانی برادری بھی پھیل گئی ");
INSERT INTO urdoucv_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","اَور کنعانیوں کی حُدوُد صیدونؔ سے گِراؔر کی طرف غزّہؔ تک اَور پھر سدُومؔ، عمورہؔ، اَدمہؔ اَور ضبوئیمؔ کی طرف لشعؔ تک پہُنچ گئیں۔) ");
INSERT INTO urdoucv_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","بنی حامؔ یہی ہیں جو اَپنی برادریوں اَور زبانوں کے مُطابق اَپنے اَپنے مُلکوں اَور قوموں میں آباد ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","پھر شِمؔ کے ہاں جِس کا بڑا بھایٔی یافیتؔ تھا اَولاد ہُوئی۔ شِمؔ تمام بنی عِبرؔ کا باپ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","بنی شِمؔ یہ ہیں: عیلامؔ، اشُور، اَرفاکسَدؔ، لُودؔ اَور ارام۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","بنی ارام یہ ہیں: عُوضؔ، حُولؔ، گیتھرؔ اَور ماش۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","اَرفاکسَدؔ شِلحؔ کا باپ تھا اَور شِلحؔ عِبرؔ کا باپ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","عِبرؔ کے ہاں دو بیٹے پیدا ہویٔے: ایک کا نام پِلِگ یعنی تقسیم تھا کیونکہ اُس کے ایّام میں زمین تقسیم ہُوئی اَور اُس کے بھایٔی کا نام یُقطانؔ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","بنی یُقطانؔ سے اَلمُودادؔ، شِلفؔ، حَصارمِبیتؔھ، یِراحؔ، ");
INSERT INTO urdoucv_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ہَدورامؔ، اُوزالؔ، دِقلہؔ، ");
INSERT INTO urdoucv_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","عُبالؔ، اَبی ماایلؔ، شیبا، ");
INSERT INTO urdoucv_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","اوفیرؔ، حَویلہؔ اَور یُوبابؔ پیدا ہویٔے۔ یہ سَب یُقطانؔ کے بیٹے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","اَور جِس علاقہ میں وہ بستے تھے وہ میشاؔ سے لے کر مشرق میں پہاڑی علاقہ سِفارؔ تک پھیلا ہُوا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","بنی شِمؔ یہی ہیں جو اَپنی برادریوں اَور زبانوں کے مُطابق اَپنے اَپنے مُلکوں اَور قوموں میں آباد ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","نوحؔا کے بیٹوں کے خاندان اَپنی برادریوں اَور نَسلوں کے مُطابق یہی ہیں اَور سیلاب کے بعد یہی لوگ مُختلف قوموں میں تقسیم ہوکر زمین پر پھیل گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ساری زمین پر ایک ہی زبان اَور ایک ہی بولی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","جَب لوگ مشرق کی طرف بڑھے تو اُنہیں مُلک شِنعاؔر میں ایک میدان مِلا اَور وہ وہاں بس گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","اُنہُوں نے آپَس میں کہا، ”آؤ ہم اینٹیں بنائیں، اَور اُنہیں آگ میں خُوب تپائیں۔“ پس وہ پتّھر کی بجائے اینٹ اَور چُونے کی بجائے گارا اِستعمال کرنے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","پھر اُنہُوں نے کہا، ”آؤ، ہم اَپنے لیٔے ایک شہر بسائیں اَور اُس میں ایک اَیسا بُرج تعمیر کریں جِس کی چوٹی آسمان تک جا پہُنچے، تاکہ ہمارا نام مشہُور ہو اَور ہم تمام رُوئے زمین پر تِتّر بِتّر نہ ہوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","لیکن یَاہوِہ اُس شہر اَور بُرج کو دیکھنے کے لیٔے جسے لوگ بنا رہے تھے نیچے اُتر آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","یَاہوِہ نے فرمایا، ”اگر یہ لوگ ایک ہوتے ہویٔے اَور ایک ہی زبان بولتے ہویٔے یہ کام کرنے لگے ہیں، تو یہ جِس بات کا اِرادہ کریں گے اُسے پُورا ہی کرکے دَم لیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","آؤ، ہم نیچے جا کر اُن کی زبان میں اِختلاف پیدا کریں تاکہ وہ ایک دُوسرے کی بات ہی نہ سمجھ سکیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","لہٰذا یَاہوِہ نے اُنہیں وہاں سے تمام رُوئے زمین پر مُنتشر کر دیا اَور وہ شہر کی تعمیر سے باز آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","اِسی لیٔے اُس شہر کا نام بابیل پڑ گیا کیونکہ وہاں یَاہوِہ نے سارے جہاں کی زبان میں اِختلاف ڈالا تھا۔ وہاں سے یَاہوِہ نے اُنہیں تمام رُوئے زمین پر مُنتشر کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","شِمؔ کا شجرہ نَسب یہ ہے: سیلاب کے دو بَرس بعد جَب شِمؔ سَو بَرس کا تھا تو اُن کے یہاں اَرفاکسَدؔ پیدا ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","اَور اَرفاکسَدؔ کی پیدائش کے بعد شِمؔ مزید پانچ سَو بَرس جیتے رہے اَور اُن کے یہاں بیٹے اَور بیٹیاں پیدا ہویٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","جَب اَرفاکسَدؔ پینتیس بَرس کے ہویٔے تو اُن کے یہاں شِلحؔ پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","اَور شِلحؔ کی پیدائش کے بعد اَرفاکسَدؔ مزید چار سَو تین بَرس تک جیتے رہے اَور اُن کے یہاں بیٹے اَور بیٹیاں پیدا ہویٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","جَب شِلحؔ تیس بَرس کا ہُوا، تو اُن کے یہاں عِبرؔ پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","اَور عِبرؔ کی پیدائش کے بعد شِلحؔ مزید چار سَو تین بَرس تک جیتے رہے اَور اُن کے یہاں بیٹے اَور بیٹیاں پیدا ہویٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","جَب عِبرؔ چونتیس بَرس کے ہویٔے، تو اُن کے یہاں پِلِگ پیدا ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","اَور پِلِگ کی پیدائش کے بعد عِبرؔ مزید چار سِوتیس بَرس تک جیتے رہے اَور اُن کے یہاں بیٹے اَور بیٹیاں پیدا ہُوئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","جَب پِلِگ تیس بَرس کے ہویٔے تو اُن کے یہاں رِعوؔ پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","اَور رِعوؔ کی پیدائش کے بعد پِلِگ مزید دو سَو نَو بَرس تک جیتے رہے اَور اُن کے یہاں بیٹے اَور بیٹیاں پیدا ہُوئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","جَب رِعوؔ بتّیس بَرس کے ہویٔے، تو اُن کے یہاں سِروگ پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","اَور سِروگ کی پیدائش کے بعد رِعوؔ مزید دو سَو سات بَرس تک جیتے رہے اَور اُن کے یہاں بیٹے اَور بیٹیاں پیدا ہُوئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","جَب سِروگ تیس بَرس کے ہویٔے تو اُن کے یہاں ناحوؔر پیدا ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","اَور ناحوؔر کی پیدائش کے بعد سِروگ مزید دو سَو بَرس تک جیتے رہے، اَور اُن کے یہاں بیٹے اَور بیٹیاں پیدا ہُوئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","جَب ناحوؔر اُنتیس بَرس کے ہویٔے، تو آپ کے یہاں تیراحؔ پیدا ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","اَور تیراحؔ کی پیدائش کے بعد ناحوؔر مزید ایک سَو اُنّیس بَرس تک جیتے رہے اَور آپ کے یہاں بیٹے اَور بیٹیاں پیدا ہُوئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","جَب تیراحؔ ستّر بَرس کے ہویٔے، تو آپ کے یہاں اَبرامؔ، ناحوؔر اَور حارانؔ پیدا ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","تیراحؔ کا شجرہ نَسب یہ ہے: تیراحؔ سے اَبرامؔ، ناحوؔر اَور حارانؔ پیدا ہویٔے اَور حارانؔ سے لَوطؔ پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","حارانؔ اَپنے باپ تیراحؔ کے جیتے جی اَپنے وطن یعنی کَسدیوں کے اُورؔ میں مَر گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","اَبرامؔ اَور ناحوؔر نے اَپنی شادی کرلی۔ اَبرامؔ کی بیوی کا نام سارَیؔ اَور ناحوؔر کی بیوی کا نام مِلکاہؔ تھا۔ وہ حارانؔ کی بیٹی تھی جو مِلکاہؔ اَور اِسکہؔ دونوں کے باپ تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","اَور سارَیؔ بانجھ تھیں۔ اُن کے یہاں کویٔی اَولاد نہ تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","اَور تیراحؔ نے اَپنے بیٹے اَبرامؔ کو، اَپنے پوتے لَوطؔ کو جو حارانؔ کے بیٹے تھے اَور اَپنی بہُو سارَیؔ کو جو اُن کے بیٹے اَبرامؔ کی بیوی تھیں ساتھ لیا اَور وہ سَب کَسدیوں کے اُورؔ سے کنعانؔ جانے کے لیٔے نکل پڑے۔ لیکن جَب وہ حارانؔ پہُنچے تو وہیں بس گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","تیراحؔ کی عمر دو سَو پانچ بَرس کی ہُوئی اَور حارانؔ میں وفات پائی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","یَاہوِہ نے اَبرامؔ سے فرمایا، ”تُم اَپنے وطن اَور اَپنے رشتہ داروں اَور اَپنے باپ کے گھر سے روانہ ہو، اَور اُس مُلک میں جا بسو جو مَیں تُمہیں دِکھاؤں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","”مَیں تُمہیں ایک بڑی قوم بناؤں گا، اَور تُمہیں برکت دُوں گا؛ مَیں تمہارے نام کو سرفراز کروں گا، اَور تُم مُبارک ہوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","جو تُمہیں برکت دیں، مَیں اُنہیں برکت دُوں گا، جو تُم پر لعنت کرے مَیں اُن پر لعنت کروں گا؛ اَور زمین کے سَب لوگ، تمہارے ذریعہ برکت پائیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","لہٰذا اَبرامؔ یَاہوِہ کے کہنے کے مُطابق چل دئیے، اَور لَوطؔ اُن کے ساتھ گئے۔ جَب اَبرامؔ حارانؔ سے روانہ ہویٔے تو اَبرامؔ پچہتّر بَرس کے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","اَبرامؔ اَپنی بیوی سارَیؔ، اَپنے بھتیجے لَوطؔ، اَپنا سَب مال و متاع اَور اُن لوگوں کو جو اُنہُوں نے حارانؔ میں کمایا تھا ساتھ لے کر مُلکِ کنعانؔ کو روانہ ہو گئے اَور وہ سَب وہاں پہُنچ گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","اَبرامؔ اُس مُلک میں سے سفر کرتے ہویٔے شِکیمؔ میں اُس مقام پر پہُنچے جہاں مورہؔ کا شاہ بلُوط کا درخت تھا۔ اُن دِنوں اُس مُلک میں کنعانی لوگ رہتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","تَب یَاہوِہ اَبرامؔ کو دِکھائی دئیے اَور فرمایا، ”مَیں یہ مُلک تمہاری نَسل کو دُوں گا۔“ چنانچہ اَبرامؔ نے وہاں یَاہوِہ کے لئے جو اُن کو دِکھائی دئیے تھے ایک مذبح بنایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","پھر وہاں سے کوُچ کرکے وہ اُن پہاڑوں کی طرف گئے جو بیت ایل کے مشرق میں ہیں اَور اَیسی جگہ خیمہ زن ہویٔے جِس کے مغرب میں بیت ایل اَور مشرق میں عَیؔ ہے۔ وہاں اَبرامؔ نے یَاہوِہ کے لیٔے ایک مذبح بنایا اَور یَاہوِہ سے دعا کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","اَور اَبرامؔ وہاں سے کُوچ کرکے نِیگیوؔ کی طرف بڑھتے گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","اُن دِنوں اُس مُلک میں قحط پڑا، اَور اَبرامؔ مِصر چلےگئے تاکہ کچھ عرصہ تک وہاں رہیں کیونکہ قحط نہایت شدید تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","جَب وہ مِصر میں داخل ہونے کو تھے، تو اُنہُوں نے اَپنی بیوی سارَیؔ سے کہا، ”مَیں جانتا ہُوں کہ تُو کِس قدر خُوبصورت عورت ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","جَب مِصری تُمہیں دیکھیں گے تو کہیں گے، ’تُم میری بیوی ہو۔‘ سو وہ مُجھے تو مار ڈالیں گے لیکن تُمہیں زندہ رہنے دیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","لہٰذا تُم یہ کہنا کہ تُم میری بہن ہو، تاکہ وہ تمہاری خاطِر میرے ساتھ نیک سلُوک کریں اَور تمہاری وجہ سے میری جان بچی رہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","جَب اَبرامؔ مِصر میں پہُنچے تو مِصریوں نے سارَیؔ کو دیکھا کہ وہ عورت نہایت ہی خُوبصورت ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","اَور جَب فَرعوہؔ کے اہلکاروں نے اُسے دیکھا، تو اُنہُوں نے فَرعوہؔ سے سارَیؔ کی تعریف کی اَور سارَیؔ کو فَرعوہؔ کے محل میں پہُنچا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","فَرعوہؔ نے سارَیؔ کی خاطِر اَبرامؔ کے ساتھ نیک سلُوک کیا اَور اَبرامؔ کو بھیڑ بکریاں، گائے بَیل، گدھے گدھیاں، خادِم اَور خادِمائیں اَور اُونٹ حاصل ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","لیکن یَاہوِہ نے اَبرامؔ کی بیوی سارَیؔ کی وجہ سے فَرعوہؔ اَور اُس کے خاندان پر بڑی بڑی بَلائیں نازل کیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","تَب فَرعوہؔ نے اَبرامؔ کو بُلایا اَور کہا، ”تُم نے میرے ساتھ یہ کیا کیا؟ تُم نے مُجھے کیوں نہ بتایا کہ وہ تمہاری بیوی ہے؟ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","تُم نے یہ کیوں کہا، ’وہ میری بہن ہے،‘ اِسی لیٔے مَیں نے اُسے لے لیا تھا تاکہ اُسے اَپنی بیوی بنا لُوں۔ اَب یہ رہی تمہاری بیوی۔ اِسے لے کر چلے جاؤ!“ ");
INSERT INTO urdoucv_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","تَب فَرعوہؔ نے اَپنے آدمیوں کو اَبرامؔ کے حق میں ہدایات دیں اَور اُنہُوں نے اَبرامؔ، اُن کی بیوی اَور اُن کے مال و اَسباب سمیت رخصت کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","چنانچہ اَبرامؔ اَپنی بیوی اَور اَپنے سارے مال و اَسباب سمیت مِصر سے کنعانؔ کے نِیگیوؔ کی طرف روانہ ہویٔے، اَور لَوطؔ اَبرامؔ کے ساتھ گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","اَبرامؔ مویشی اَور سونا چاندی پا کر بہت مالدار ہو گئے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","پھر اَبرامؔ کنعانؔ کے نِیگیوؔ سے سفر کرتے ہویٔے بیت ایل میں اُس مقام پر پہُنچے، جہاں پہلے بیت ایل اَور عَیؔ کے درمیان اَبرامؔ کا خیمہ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","اَور جہاں اُنہُوں نے پہلے مذبح بنایا تھا۔ وہاں اَبرامؔ نے یَاہوِہ سے دعا کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","اَور لَوطؔ کے پاس بھی، جو اَبرامؔ کا ہم سفر تھے بھیڑ بکریاں، گائے بَیل اَور خیمے لگائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","لیکن زمین کی کمی کے باعث اُن دونوں کا اُس مُلک میں اِکٹھّے رہنا مُشکل تھا کیونکہ اُن کا مال و اَسباب اِس قدر زِیادہ تھا کہ وہ اِکٹھّے نہیں رہ سکتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","اَور اَبرامؔ کے اَور لَوطؔ کے چرواہوں میں جھگڑا ہُوا کرتا تھا۔ اُن دِنوں کنعانی اَور پَرزّی بھی اُس مُلک میں رہتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","چنانچہ اَبرامؔ نے لَوطؔ سے فرمایا، ”تمہارے اَور میرے درمیان اَور تمہارے چرواہوں اَور میرے چرواہوں کے درمیان جھگڑا نہیں ہونا چاہیے، کیونکہ ہم رشتہ دار ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","کیا یہ سارا مُلک تمہارے سامنے نہیں؟ سو تُم مُجھ سے الگ ہو جاؤ اگر تُم بائیں طرف جاؤگے تو مَیں داہنی طرف چلا جاؤں گا۔ اَور اگر تُم داہنی طرف جاؤگے تو مَیں بائیں طرف چلا جاؤں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","تَب لَوطؔ نے آنکھ اُٹھاکر یردنؔ ندی کے پاس کی ساری ترائی پر اَور اُس کے اطراف ضُعَرؔ تک نظر دَوڑائی کیونکہ وہ (اِس سے پیشتر کہ یَاہوِہ نے سدُومؔ اَور عمورہؔ کو تباہ کیا) یَاہوِہ کے باغ اَور مِصر کے مُلک کی مانند خُوب سیراب تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","سو لَوطؔ نے یردنؔ کی ساری ترائی کو اَپنے لیٔے چُن لیا اَور وہ مشرق کی طرف چلےگئے اَور وہ ایک دُوسرے سے جُدا ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","اَبرامؔ تو مُلکِ کنعانؔ میں جا بسے، جَب کہ لَوطؔ نے ترائی کے شہروں میں سکونت اِختیار کی اَور سدُومؔ تک اَپنے خیمے کھڑے کئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","سدُومؔ کے لوگ بدکار تھے اَور یَاہوِہ کے خِلاف سنگین گُناہ کیا کرتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","لَوطؔ کے جُدا ہو جانے کے بعد یَاہوِہ نے اَبرامؔ سے فرمایا، ”جِس جگہ تُم کھڑے ہو وہاں سے اَپنی نگاہ اُٹھاکر شمال و جُنوب اَور مشرق و مغرب کی طرف نظر کرو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","یہ سارا مُلک جو تُم دیکھ رہے ہو، اُسے میں تُمہیں اَور تمہاری نَسل کو ہمیشہ کے لیٔے دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","مَیں تمہاری نَسل کو خاک کے ذرّوں کی مانند بناؤں گا۔ اگر کویٔی شخص خاک کے ذرّوں کو گِن سکے تو تمہاری نَسل کو بھی گِنا جا سکےگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","جاؤ، اَور اُس مُلک کے طُول و عرض میں گھُومو، پھرو کیونکہ مَیں اُسے تُمہیں دینے جا رہا ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","چنانچہ اَبرامؔ نے اَپنے خیمے اُٹھائے اَور حِبرونؔ میں ممرےؔ کے شاہ بلُوط کے درختوں کے پاس جا کر رہنے لگے جہاں اَبرامؔ نے یَاہوِہ کے لیٔے ایک مذبح بنایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","اُن ہی دِنوں میں شِنعاؔر کے بادشاہ اَمرافِلؔ، اِلاسرؔ کے بادشاہ اریُوخ، عیلامؔ کے بادشاہ کِدرلاعُیمرؔ اَور گوئیِمؔ کے بادشاہ تِدعالؔ نے ");
INSERT INTO urdoucv_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","سدُومؔ کے بادشاہ بَرع، عمورہؔ کے بادشاہ بِرشعؔ، اَدمہؔ کے شِنابؔ، ضبوئیمؔ کے بادشاہ شِمیبؔر اَور بَیلعؔ (یعنی ضُعَرؔ) کے بادشاہ سے جنگ کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","یہ سَب بادشاہ سِدّیمؔ یعنی بحرمُردار کی وادی میں اِکٹھّے ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","بَارہ بَرس تک وہ کِدرلاعُیمرؔ کے مطیع رہے لیکن تیرہویں بَرس میں اُنہُوں نے بغاوت کر دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","چودھویں بَرس کِدرلاعُیمرؔ اَور اُس کے ساتھ کے بادشاہ آئے اَور رفائیمؔ کو عَستِروت قرنائم میں زُوزیم کو ہامؔ میں اَور ایمیمؔ کو شاوِہ قِریتائم میں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","اَور حَوریم کو سِعِیؔر کے پہاڑی مُلک میں مارتے مارتے بیابان کے نزدیک ایل پارانؔ تک پہُنچ گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","تَب وہ لَوٹ کر عینؔ مِشپاتؔ (یعنی قادِسؔ آئے) اَور عمالیقیوں کے تمام مُلک کو اَور امُوریوں کو جو حَصّونؔ تامارؔ میں رہتے تھے، تسخیر کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","تَب سدُومؔ کے بادشاہ، عمورہؔ کے بادشاہ، اَدمہؔ کے بادشاہ، ضبوئیمؔ کے بادشاہ اَور بَیلعؔ (یعنی ضُعَرؔ) کے بادشاہ نے کُوچ کیا اَور سِدّیمؔ کی وادی میں ");
INSERT INTO urdoucv_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","یہ چاروں بادشاہ عیلامؔ کے بادشاہ کِدرلاعُیمرؔ، گوئیِمؔ کے بادشاہ تِدعالؔ، شِنعاؔر کے بادشاہ اَمرافِلؔ اَور اِلاسرؔ کے بادشاہ اریُوخ اِن پانچ بادشاہوں کے خِلاف صف آرا ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","سِدّیمؔ کی وادی میں جابجا نفت کے بے شُمار گڑھے تھے اَور جَب سدُومؔ اَور عمورہؔ کے بادشاہ میدان چھوڑکر بھاگے تو کیٔی لوگ اُن گڑھوں میں گِر پڑے اَورجو بچے وہ پہاڑوں پر بھاگ گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","تَب اُن چار بادشاہوں نے سدُومؔ اَور عمورہؔ کا سارا مال و متاع اَور سَب اناج لُوٹ لیا اَور وہاں سے چلے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","اَور وہ اَبرامؔ کے بھتیجے، لَوطؔ کو بھی اُس کے مال و متاع سمیت پکڑ لے گیٔے کیونکہ وہ سدُومؔ میں رہتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","تَب ایک شخص نے جو بھاگ کر بچ نِکلا تھا آکر اَبرامؔ عِبرانی کو لَوطؔ کی خبر دی۔ اَبرامؔ، اِشکلؔ اَور عانیرؔ کے بھایٔی ممرےؔ امُوری کے بلُوط کے درختوں کے نزدیک رہتے تھے اَور اِن سَب لوگوں نے اَبرامؔ کے ساتھ عہد کیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","جَب اَبرامؔ نے سُنا کہ اُن کا رشتہ دار اسیر ہو چُکاہے تو آپ نے تین سَو اٹھّارہ تربّیت یافتہ خانہ زادوں کو ہمراہ لیا اَور لُٹیروں کا دانؔ تک پیچھا کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","رات کے وقت اَبرامؔ نے اَپنے آدمیوں کو الگ الگ دستوں میں تقسیم کرکے اُن پر حملہ کر دیا اَور اُنہیں پسپا کرکے دَمشق کے شمال میں حوبہؔ تک اُن کا تعاقب کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","آپ نے سارے مال و متاع پر قبضہ کر لیا اَور اَپنے رشتہ دار لَوطؔ کو اَور اُن کے مال کو عورتوں اَور دُوسرے لوگوں سمیت واپس لے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","جَب اَبرامؔ کِدرلاعُیمرؔ اَور اُن کے ساتھ کے بادشاہوں کو شِکست دے کر واپس آ رہے تھے تو سدُومؔ کا بادشاہ شاوِہ کی وادی (یعنی بادشاہ کی وادی) میں اَبرامؔ کے اِستِقبال کے لیٔے آیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","تَب شالمؔ کا بادشاہ ملکِ صِدقؔ، روٹی اَور انگوری شِیرہ لے کر آیا۔ وہ خُداتعالیٰ کا کاہِنؔ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ملکِ صِدقؔ نے اَبرامؔ کو یہ کہہ کر برکت دی، ”خُداتعالیٰ کی طرف سے جو آسمان اَور زمین کا خالق ہے، اَبرامؔ مُبارک ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","اَور مُبارک ہے خُداتعالیٰ جِس نے تمہارے دُشمنوں کو تمہارے ہاتھ میں کر دیا۔“ تَب اَبرامؔ نے سَب مالِ غنیمت کا دسواں حِصّہ ملکِ صِدقؔ کو نذر کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","سدُومؔ کے بادشاہ نے اَبرامؔ سے کہا، ”آدمیوں کو مُجھے دے دیجئے اَور مال و زَر اَپنے لیٔے رکھ لیجئے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","لیکن اَبرامؔ نے سدُومؔ کے بادشاہ سے فرمایا، ”مَیں نے یَاہوِہ، خُداتعالیٰ، آسمان اَور زمین کے خالق کی قَسم کھائی ہے، ");
INSERT INTO urdoucv_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","کہ مَیں تمہاری کویٔی چیز نہ لُوں گا خواہ وہ دھاگا ہو یا جُوتی کاتسمہ، تاکہ تُم کبھی یہ نہ کہہ سکو، ’مَیں نے اَبرامؔ کو دولتمند بنا دیا۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","سِوا اُس کے جو میرے جَوانوں نے کھایا اَور اُن لوگوں کے حِصّے کے جو میرے ساتھ گیٔے یعنی عانیرؔ، اِشکلؔ اَور ممرےؔ؛ وہ اَپنا اَپنا حِصّہ لے لیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","اُس کے بعد یَاہوِہ کا یہ کلام رُویا میں اَبرامؔ پر نازل ہُوا: ”اَے اَبرامؔ! خوف نہ کر، مَیں تمہاری سِپر ہُوں اَور تمہارا اجر بہت بڑا ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","لیکن اَبرامؔ نے فرمایا، ”اَے یَاہوِہ قادر آپ مُجھے کیا دیں گے؟ میں تو بے اَولاد ہُوں اَور الیعزرؔ دَمشقی میرے گھر کا وارِث ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","پھر اَبرامؔ نے فرمایا، ”آپ نے مُجھے کویٔی اَولاد نہیں دی؛ اِس لیٔے میرا ایک خانہ زاد خادِم ہی میرا وارِث ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","تَب یَاہوِہ کا یہ کلام اُس پر نازل ہُوا: ”یہ شخص تمہارا وارِث نہ ہوگا، بَلکہ تمہارے صُلب سے پیدا ہونے والا یعنی تمہارا اَپنا بیٹا ہی تمہارا وارِث ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","پھر وہ آپ کو باہر لے گئے اَور کہا، ”آسمان کی طرف نگاہ کرو اَور اگر تُم سِتاروں کو گِن سکتے ہو تو اُنہیں گنو۔“ پھر اَبرامؔ سے کہا، ”تمہاری اَولاد اَیسی ہی ہوگی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","اَبرامؔ یَاہوِہ پر ایمان لائے اَور یَاہوِہ نے اُن کے ایمان کو اَبرامؔ کے حق میں راستبازی شُمار کیا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","یَاہوِہ نے اَبرامؔ سے یہ بھی کہا، ”مَیں یَاہوِہ ہُوں جو تُمہیں کَسدیوں کے اُورؔ سے نکال لایا تاکہ تُجھے یہ مُلک مِیراث میں دُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","لیکن اَبرامؔ نے فرمایا، ”اَے یَاہوِہ قادر! میں کِس طرح جانوں کہ میں اِس کا وارِث ہُوں گا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","یَاہوِہ نے اَبرامؔ سے فرمایا، ”ایک بچھیا ایک بکری اَور ایک مینڈھا جو تین تین بَرس کے ہُوں اَور ایک قُمری اَور کبُوتر کا ایک بچّہ میرے پاس لاؤ۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","اَبرامؔ اُن سَب کو یَاہوِہ کے پاس لے آئے؛ اَور اُن سبھی کے دو دو ٹکڑے کئے اَور اُن ٹُکڑوں کو ایک دُوسرے کے مقابل رکھ دیا مگر، پرندوں کے ٹکڑے نہیں کئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","تَب شِکاری پرندے اُن لاشوں پر جھپٹنے لگے، لیکن اَبرامؔ اُنہیں ہنکاتے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","جَب سُورج ڈُوبنے لگا، تو اَبرامؔ پر گہری نیند طاری ہو گئی، اَور بڑی ہولناک تاریکی اُن پر چھاگئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","تَب یَاہوِہ نے اَبرامؔ سے فرمایا، ”یقین جانو کہ چار سَو بَرس تک تمہاری نَسل ایک بیگانے مُلک میں جو اُن کا نہیں ہے اُس میں پردیسیوں کی طرح رہے گی، اَور وہاں کے لوگ اُسے غُلامی میں رکھیں گے اَور اُس سے بدسلُوکی سے پیش آتے رہیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","لیکن مَیں اُس قوم کو جو اُسے غُلام بنائے گی سزا دُوں گا، اَور بعد میں تمہاری قوم کے لوگ بڑی دولت کے ساتھ وہاں سے نکلیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","اَور تُم سلامتی کے ساتھ اَپنے آباؤاَجداد سے جا مِلوگے اَور نہایت پیری میں دفن کئے جاؤگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","تمہاری نَسل، چوتھی پُشت میں یہاں لَوٹ آئے گی کیونکہ امُوریوں کے گُناہ کا پیالہ ابھی لبریز نہیں ہُوا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","جَب سُورج غروب ہُوا اَور اَندھیرا چھا گیا تو ایک تنور جِس میں سے دُھواں اُٹھ رہاتھا ایک جلتی ہُوئی مشعل کے ساتھ نموُدار ہُوا اَور اُن ٹُکڑوں کے درمیان سے ہوکر گزر گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","اُس روز یَاہوِہ نے اَبرامؔ کے ساتھ عہد باندھا اَور فرمایا، ”مَیں نے مِصر کی ندی سے لے کر بڑے ندی یعنی بڑی ندی فراتؔ تک کی زمین تمہاری نَسل کو عطا کی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","یعنی قینیوں، قنیزیوں، قدمونیوں، ");
INSERT INTO urdoucv_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","حِتّیوں، پَرزّیوں، رفائیّو ");
INSERT INTO urdoucv_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","اَور امُوریوں، کنعانیوں، گِرگاشیوں اَور یبُوسیوں اِن سبھوں کی زمین۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","اَبرامؔ کی بیوی سارَیؔ کے کویٔی اَولاد نہ ہُوئی لیکن اُن کی ایک مِصری لونڈی تھی جِن کا نام ہاگارؔ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","چنانچہ سارَیؔ نے اَبرامؔ سے کہا، ”یَاہوِہ نے مُجھے تو اَولاد سے محروم رکھا ہے لیکن آپ میری لونڈی کے پاس جائیے۔ شاید اُس سے میرا گھر آباد ہو جائے۔“ اَبرامؔ نے سارَیؔ کی بات مان لی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","اَبرامؔ کو مُلکِ کنعانؔ میں رہتے ہویٔے دس بَرس گزر چُکے تھے۔ تَب اَبرامؔ کی بیوی سارَیؔ نے اَپنی مِصری لونڈی ہاگارؔ کو اَپنے خَاوند کے سُپرد کر دیا تاکہ وہ اَبرامؔ کی بیوی بنے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","اَور اَبرامؔ ہاگارؔ کے پاس گئے اَور ہاگارؔ حاملہ ہُوئیں۔ جَب ہاگارؔ کو مَعلُوم ہُوا کہ وہ حاملہ ہیں تو وہ اَپنی مالکن کو حقیر جاننے لگیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","تَب سارَیؔ نے اَبرامؔ سے کہا، ”جو ظُلم مُجھ پر ہو رہاہے اُس غلطی کے لیٔے آپ ذمّہ دار ہیں۔ مَیں نے اَپنی لونڈی کو آپ کی آغوش میں دیا اَور اَب جَب کہ وہ جانتی ہے کہ وہ حاملہ ہے تو وہ مُجھے حقیر جاننے لگی ہے۔ اَب یَاہوِہ اِس مُعاملہ میں ہم دونوں کا اِنصاف کریں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","اَبرامؔ نے فرمایا، ”تمہاری لونڈی سارَیؔ تمہارے ہاتھ میں ہے۔ تُم جو چاہو ہاگارؔ کے ساتھ کرو!“ جَب سارَیؔ ہاگارؔ کے ساتھ سختی سے پیش آنے لگیں تو وہ سارَیؔ کے پاس سے فرار ہو گئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","یَاہوِہ کے فرشتہ نے ہاگارؔ کو بیابان میں شُورؔ کی راہ کے کنارے ایک چشمہ کے پاس پایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","اَور اُس نے کہا، ”اَے سارَیؔ کی لونڈی ہاگارؔ! تُم کہاں سے آئی ہو اَور کدھر جا رہی ہو؟“ ہاگارؔ نے جَواب دیا، ”میں اَپنی مالکن، سارَیؔ کے پاس سے فرار ہو گئی ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","تَب یَاہوِہ کے فرشتہ نے ہاگارؔ سے کہا، ”تُم اَپنی مالکن کے پاس لَوٹ جاؤ اَور اَپنے آپ کو سارَیؔ کے سُپرد کر دو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","یَاہوِہ کے فرشتہ نے مزید کہا، ”مَیں تمہاری اَولاد کو اِس قدر بڑھاؤں گا کہ اُن کی تعداد شُمار سے باہر ہو جائے گی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","یَاہوِہ کے فرشتہ نے ہاگارؔ سے یہ بھی کہا: ”تُم اَب حاملہ ہو اَور تمہارے ہاں بیٹا پیدا ہوگا۔ تُم اُس کا نام اِشمعیل رکھنا کیونکہ یَاہوِہ نے تمہاری دُکھ بھری فریاد سُن لی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","اَور وہ گورخر کی مانند آزاد مَرد ہوگا؛ اِشمعیل کا ہاتھ سَب کے خِلاف اُٹھے گا اَور ہر ایک کا ہاتھ اِشمعیل کے خِلاف، اَور اِشمعیل زندگی بھر اَپنے سَب بھائیوں کے ساتھ مُخالف ماحول میں زندگی گُزاریں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","اَور جِس یَاہوِہ نے ہاگارؔ سے باتیں کیں، اُس کا نام ہاگارؔ نے: اتاایلؔ روئی رکھا یعنی، ”تُو بصیر خُدا ہے کیونکہ اُس نے کہا کہ مَیں نے بھی یہاں اُس بصیر کو دیکھاہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","اِسی لیٔے اُس کنویں کا نام بیرلخیؔ روئی پڑا؛ وہ قادِسؔ، اَور بیردؔ کے درمیان واقع ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","اَور اَبرامؔ سے ہاگارؔ کے ہاں ایک بیٹا پیدا ہُوا اَور اَبرامؔ نے اُس بیٹے کا نام جو ہاگارؔ سے پیدا ہُوا تھا اِشمعیل رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","جَب اَبرامؔ سے ہاگارؔ کے ہاں اِشمعیل پیدا ہُوا تَب اَبرامؔ چھیاسی بَرس کے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","جَب اَبرامؔ نِنانوے بَرس کے ہویٔے تَب یَاہوِہ اُن پر ظاہر ہویٔے، اَور اَبراہامؔ سے فرمایا، ”میں قادرمُطلق خُدا ہُوں۔ تُو میرے سامنے وفادار رہے اَور بے عیب ٹھہرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","میں اَپنے اَور تمہارے درمیان عہد باندھوں گا اَور تمہاری نَسل کو بےحد بڑھاؤں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","تَب اَبرامؔ مُنہ کے بَل گِرے اَور خُدا نے اُن سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","”جہاں تک میرا تعلّق ہے، میرا تمہارے ساتھ یہ عہد ہے کہ تُم کیٔی قوموں کے باپ ہوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","اَب سے تُم اَبرامؔ نہ کہلاؤگے بَلکہ تمہارا نام اَبراہامؔ ہوگا کیونکہ مَیں نے تُمہیں بہت سِی قوموں کا باپ مُقرّر کیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","مَیں تُمہیں بہت برومند کروں گا اَور تمہاری نَسل سے کیٔی قومیں پیدا کروں گا اَور تمہاری اَولاد میں بادشاہ برپا ہوں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","میں اَپنے اَور تمہارے درمیان اَور تمہارے بعد تمہاری نَسل کے درمیان اُن کی آئندہ پُشتوں کے لیٔے اَپنا عہد باندھوں گا جو اَبدی عہد ہوگا کہ میں تمہارا اَور تمہارے بعد تمہاری نَسل کا خُدا رہُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","اَور مَیں تُمہیں اَور تمہارے بعد تمہاری نَسل کو کنعانؔ کا سارا مُلک جِس میں اَب تُم پردیسی ہو، ایک اَبدی مِیراث کے طور پر بخشوں گا اَور مَیں اُن کا خُدا ہُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","پھر خُدا نے اَبراہامؔ سے فرمایا، ”تُم میرے عہد کو ضروُر ماَننا اَور تمہارے بعد تمہاری نَسل پُشت در پُشت اُسے مانے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","اَور میرا عہد جو میرے اَور تمہارے درمیان اَور تمہارے بعد تمہاری نَسل کے درمیان ہے اَور جسے تُم مانوگے، یہ ہے کہ تُم میں سے ہر فرزندِ نرینہ کا ختنہ کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","تُم اَپنا اَپنا ختنہ کرا لو اَور یہ اُس عہد کا نِشان ہوگا جو میرے اَور تمہارے درمیان ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","پُشت در پُشت تُم میں سے ہر لڑکے کا جو آٹھ دِن کا ہو ختنہ کیا جائے خواہ وہ تمہارے گھر میں پیدا ہُوا ہو، خواہ کسی پردیسی سے قیمتاً خریدا گیا ہو اَورجو تمہاری اَولاد نہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","خواہ وہ تمہارے گھر میں پیدا ہویٔے ہُوں یا تمہارے زَر خرید ہُوں اُن کا ختنہ لازمی طور پر کیا جائے۔ میرا عہد تمہارے جِسم میں اَبدی عہد ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","اَور اگر کویٔی نامختون مَرد اَپنا ختنہ نہیں کرواتا تو وہ اَپنے لوگوں میں سے کاٹ ڈالا جائے گا کیونکہ اُس نے میرا عہد توڑا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","خُدا نے اَبراہامؔ سے یہ بھی فرمایا، ”سارَیؔ، جو تمہاری بیوی ہے اُسے اَب سارَیؔ کہہ کر مت پُکارنا؛ اُن کا نام سارہؔ ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","میں اُسے برکت دُوں گا۔ وہ قوموں کی ماں ہوگی اَور عواموں کے بادشاہ اُن سے پیدا ہوں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","تَب اَبراہامؔ مُنہ کے بَل گِر پڑے؛ اَور ہنس کر دِل ہی دِل میں کہنے لگے، ”کیا سَو سالہ مَرد کے ہاں بیٹا پیدا ہوگا؟ کیا سارہؔ کے ہاں، جو نوّے بَرس کی ہے، اَولاد ہوگی؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","اَور اَبراہامؔ نے خُدا سے کہا، ”کاش اِشمعیل تیری رحمت کے سایہ میں جیتا رہے!“ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","تَب خُدا نے فرمایا، ”بے شک، تمہاری بیوی سارہؔ کو تُم سے بیٹا ہوگا اَور تُم اُس کا نام اِصحاقؔ رکھنا۔ مَیں اُس کے ساتھ اَیسا عہد باندھوں گا جو اُس کے بعد اُس کی نَسل کے لیٔے اَبدی عہد ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","اَور اِشمعیل کے حق میں بھی مَیں نے تمہاری دعا سُنی ہے: مَیں یقیناً اُسے برکت دُوں گا؛ مَیں اُسے برومند کروں گا اَور اُسے تعداد میں بہت بڑھاؤں گا۔ اُس سے بَارہ سردار پیدا ہوں گے، اَور مَیں اُسے بڑی قوم بناؤں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","لیکن اَپنا عہد مَیں اِصحاقؔ ہی سے باندھوں گا جو اگلے سال اِسی وقت تمہارے ہاں سارہؔ سے پیدا ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","جَب خُدا اَبراہامؔ سے باتیں کر چُکے تَب خُدا اُن کے پاس سے اُوپر چلےگئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","تَب اَبراہامؔ نے اَپنے بیٹے اِشمعیل کو اَور اَپنے سَب خانہ زادوں کو اَور اُن کو جو قیمتاً خریدے گیٔے تھے اَور اَپنے گھر کے سَب مَردوں کو لے کر اُسی روز خُدا کے حُکم کے مُطابق اُن کا ختنہ کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","اَبراہامؔ نِنانوے بَرس کے تھے جَب اُن کا ختنہ ہُوا، ");
INSERT INTO urdoucv_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","اَور اُن کے بیٹے اِشمعیل کا ختنہ ہُوا وہ تیرہ بَرس کا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","اَبراہامؔ اَور اُن کے بیٹے اِشمعیل کا ختنہ اُسی دِن ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","اَور کے گھر کے ہر مَرد کا ختنہ اَبراہامؔ کے خانہ زادوں اَور پردیسیوں سے زَر خرید مَردوں سمیت، اُن کے ساتھ ہی ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","تَب یَاہوِہ اَبراہامؔ کو ممرےؔ کے بلُوط کے درختوں کے نزدیک نظر آئے۔ اُس وقت اَبراہامؔ دِن کی دھوپ میں اَپنے خیمہ کے دروازہ پر بیٹھے ہویٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","اَبراہامؔ نے نگاہ اُٹھاکر دیکھا کہ تین مَرد اُن کے قریب کھڑے ہیں۔ جَب آپ نے اُنہیں دیکھا تو اُن کے اِستِقبال کے لیٔے خیمہ کے دروازہ سے دَوڑے اَور زمین پر جھُک کر سَجدہ کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","اَبراہامؔ نے فرمایا، ”اَے میرے آقا! اگر مُجھ پر آپ کی نظرِکرم ہُوئی ہے تو خادِم کے پاس ٹھہرے بغیر نہ جانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","مَیں تھوڑا پانی لاتا ہُوں۔ آپ سَب اَپنے پاؤں دھوکر اِس درخت کے نیچے آرام کریں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","اَب جَب کہ آپ اَپنے خادِم کے ہاں تشریف لایٔے ہیں تو میں آپ کے واسطے کچھ کھانے کو لاتا ہُوں تاکہ آپ تازہ دَم ہو جایٔیں اَور تَب اَپنی راہ لیں۔ اُنہُوں نے جَواب دیا، ”بہت خُوب، وَیسا ہی کیجئے، جَیسا کہ آپ نے کہا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","تَب اَبراہامؔ جلدی سے خیمہ میں سارہؔ کے پاس گئے اَور کہا، ”جلدی سے تین پیمانہ نفیس آٹا لے کر اَور اُسے گُوندھ کر کُچھ پھُلکے بناؤ۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","پھر اَبراہامؔ گائے بَیل کے گلّہ کی طرف دَوڑے اَور ایک بہترین اَور کمسِن بچھڑا لے کر خادِم کو دیا جِس نے اُسے جلدی سے پکایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","تَب اَبراہامؔ نے کُچھ دہی اَور دُودھ اَور اُس بچھڑے کے سالن کو لے کر اُنہیں اُن کے سامنے رکھا۔ اَور جَب وہ کھا رہے تھے تو خُود اُن کے قریب درخت کے نیچے کھڑے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","اُنہُوں نے اَبراہامؔ سے پُوچھا، ”آپ کی بیوی سارہؔ کہاں ہے؟“ اَبراہامؔ نے کہا، ”وہ وہاں خیمہ میں ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","تَب اُن میں سے ایک نے کہا، ”مَیں اگلے بَرس مُقرّرہ وقت پر تمہارے پاس پھر واپس آؤں گا اَور آپ کی بیوی سارہؔ کے یہاں بیٹا پیدا ہوگا۔“ اَور سارہؔ خیمہ کے دروازہ میں سے جو اُن کے پیچھے تھا سُن رہی تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","اَبراہامؔ اَور سارہؔ دونوں ضعیف اَور عمر رسیدہ تھے اَور سارہؔ کی اَولاد ہونے کی عمر ڈھل چُکی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","چنانچہ سارہؔ یہ سوچ کر ہنس پڑیں، ”جَب میری قُوّت زچگی ختم ہو چُکی اَور میرا خَاوند ضعیف ہو چُکا تو کیا اَب مُجھے یہ خُوشی نصیب ہوگی؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","تَب یَاہوِہ نے اَبراہامؔ سے فرمایا، ”سارہؔ نے ہنس کر یہ کیوں کہا، ’کیا میرے ہاں واقعی بچّہ ہوگا جَب کہ مَیں ضعیف ہو چُکی ہُوں؟‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","کیا یَاہوِہ کے لیٔے کویٔی کام مُشکل ہے؟ مَیں اگلے بَرس مُقرّرہ وقت پر تمہارے پاس پھر واپس آؤں گا اَور سارہؔ کے یہاں بیٹا پیدا ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","سارہؔ خوفزدہ ہو گئیں۔ اِس لیٔے سارہؔ نے جھُوٹ بولا اَور اِنکار کیا، ”مَیں تو نہیں ہنسی۔“ لیکن یَاہوِہ نے فرمایا، ”ہاں تُم ہنسی تھیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","جَب وہ لوگ جانے کے لیٔے اُٹھے تو اُنہُوں نے نیچے سدُومؔ کی طرف نگاہ کی اَور اَبراہامؔ اُنہیں رخصت کرنے کے لیٔے اُن کے ساتھ ہو لئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","تَب یَاہوِہ نے فرمایا، ”مَیں اَب جو کچھ کرنے کو ہُوں، کیا اُسے اَبراہامؔ سے پوشیدہ رکھوں گا؟ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","اَبراہامؔ سے تو یقیناً ایک بڑی اَور زبردست قوم پیدا ہوگی اَور زمین کی سَب قومیں اُن کے ذریعہ برکت پائیں گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","کیونکہ مَیں نے اُنہیں اِس لیٔے چُن لیا ہے کہ وہ اَپنی اَولاد کو اَور اَپنے بعد اَپنے گھرانے کو ہدایت دیں کہ وہ راستی اَور اِنصاف سے کام لے کر یَاہوِہ کی راہ پر قائِم رہیں تاکہ یَاہوِہ اَبراہامؔ سے کئےگئے وعدہ کو پُورا کریں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","تَب یَاہوِہ نے فرمایا، ”سدُومؔ اَور عمورہؔ کے خِلاف شور بہت ہی بڑھ گیا ہے اَور اُن کا گُناہ اِس قدر سنگین ہو گیا ہے ");
INSERT INTO urdoucv_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","کہ مَیں نیچے جا کر دیکھوں گا کہ جو کچھ اُنہُوں نے کیا ہے کیا وہ واقعی اُسی قدر بُرا ہے جَیسا شور مُجھ تک پہُنچا ہے اَور اگر یہ سچ نہیں تو مُجھے پتہ چل جائے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","چنانچہ وہ لوگ اُٹھ کر سدُومؔ کی طرف چل دئیے لیکن اَبراہامؔ یَاہوِہ کے حُضُور کھڑے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","تَب اَبراہامؔ نے یَاہوِہ کے نزدیک جا کر کہا: ”کیا آپ راستبازوں کو بھی بدکاروں کے ساتھ نِیست و نابود کر دیں گے؟ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","اگر اُس شہر میں پچاس راستباز ہُوں تو کیا ہوگا؟ کیا آپ واقعی اُسے تباہ کر ڈالیں گے اَور اُن پچاس راستبازوں کی خاطِر، جو اُس میں ہوں گے اُسے نہیں بخشیں گے؟ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","آپ یہ ہرگز نہ ہونے دیں گے، راستبازوں کو بدکاروں کے ساتھ مار دیا جائے اَور راستبازوں اَور بدکاروں دونوں کے ساتھ یکساں سلُوک کیا جائے۔ آپ اَیسا ہرگز نہ ہونے دیں گے! کیا ساری دُنیا کا مُنصِف اِنصاف سے کام نہ لے گا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","یَاہوِہ نے فرمایا، ”اگر مَیں نے سدُومؔ کے شہر میں پچاس راستباز اِنسان بھی پایٔے تو مَیں اُن کی خاطِر اُس سارے مقام کو بخش دُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","تَب اَبراہامؔ نے پھر کہا: ”حالانکہ مَیں خاک اَور راکھ کے سِوا کچھ بھی نہیں ہُوں تو بھی مَیں نے اِتنی جُرأت کی کہ آقا سے بات کر سکوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","اگر راستبازوں کی تعداد پینتالیس نکلے تو کیا آپ پانچ لوگوں کی خاطِر سارے شہر کو تباہ کر دیں گے؟“ یَاہوِہ نے جَواب دیا، ”اگر مُجھے وہاں پینتالیس راستباز بھی مِل جایٔیں گے تو مَیں اُسے تباہ نہ کروں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","اَبراہامؔ نے ایک بار پھر کہا، ”اگر وہاں صرف چالیس ملیں تو؟“ یَاہوِہ نے جَواب دیا، ”چالیس کی خاطِر بھی مَیں شہر کو تباہ نہ کروں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","تَب اَبراہامؔ نے کہا، ”اَے آقا! اگر آپ خفا نہ ہو تو مَیں کچھ عرض کروں، اگر وہاں صِرف تیس راستباز ہی مِل سکے تو کیا ہوگا؟“ یَاہوِہ نے جَواب دیا، ”اگر مُجھے وہاں تیس بھی ملے، تَب بھی مَیں شہر کو تباہ نہ کروں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","اَبراہامؔ نے کہا، ”اَے آقا، اَب تو مَیں زبان کھولنے کی جُرأت کر ہی چُکا ہُوں لہٰذا پُوچھتا ہُوں کہ اگر وہاں صِرف بیس مِل جائیں تو کیا ہوگا؟“ اُنہُوں نے فرمایا، ”مَیں بیس کی خاطِر بھی اُسے تباہ نہ کروں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","تَب اَبراہامؔ نے کہا، ”اگر آقا، خفا نہ ہو تو مَیں صِرف آخِری مرتبہ پھر عرض کروں! اگر وہاں صِرف دس ہی مِل سکے تو؟“ اُنہُوں نے جَواب دیا، ”مَیں دس کی خاطِر بھی اُسے تباہ نہ کروں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","جَب یَاہوِہ اَبراہامؔ سے باتیں کرچکے تو وہ چلےگئے اَور اَبراہامؔ گھر لَوٹ آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","شام کے وقت وہ دونوں فرشتے سدُومؔ پہُنچے۔ لَوطؔ شہر کے پھاٹک پر بیٹھا ہُوا تھا۔ جَب اُس نے اُنہیں دیکھا تو اُن کے اِستِقبال کو اُٹھا اَور مُنہ کے بَل زمین پر جھُک کر اُنہیں سَجدہ کیا ");
INSERT INTO urdoucv_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","اَور کہا، ”اَے میرے آقاؤ! اَپنے خادِم کے گھر تشریف لے چلئے۔ اَپنے پاؤں دھولیجیے اَور رات بسر کرکے علی الصبح اَپنی راہ لیجئے۔“ اُنہُوں نے کہا، ”نہیں، ہم چَوک میں ہی رات گزار لیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","جَب اُس نے بہت ہی اِصرار کیا تو وہ اُس کے ساتھ گیٔے اَور اُس کے گھر میں داخل ہو گئے۔ اُس نے بے خمیری روٹی پکا کر اُن کے لیٔے کھانا تیّار کیا اَور اُنہُوں نے کھایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","اِس سے قبل کہ وہ لیٹتے، سدُومؔ شہر کے ہر حِصّہ کے سَب مَردوں نے کیا جَوان اَور کیا ضعیف اُس گھر کو گھیرلیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","اَور لَوطؔ کو پُکار کر کہا، ”وہ مَرد جو آج رات تمہارے پاس آئے، کہاں ہیں؟ اُنہیں ہمارے پاس باہر لے کر آ، تاکہ ہم اُن سے صحبت کریں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","لَوطؔ اُن سے مِلنے باہر نِکلا اَور اَپنے پیچھے دروازہ بند کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","اَور کہا، ”نہیں، میرے بھائیو! اَیسی بدی نہ کرو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","دیکھو، میری دو بیٹیاں ہیں جنہیں اَب تک کسی مَرد نے ہاتھ نہیں لگایا۔ اگر تُم چاہو تو مَیں اُنہیں تمہارے پاس لے آتا ہُوں، اَور تُم اُن کے ساتھ جو چاہو کر لو؛ لیکن اِن آدمیوں کے ساتھ کچھ نہ کرو کیونکہ وہ میری چھت کے سایہ میں پناہ گزیں ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","اُنہُوں نے کہا، ”ہمارے راستہ سے ہٹ جاؤ!“ اَور پھر کہنے لگے، ”یہ شخص ہمارے بیچ میں پردیسی بَن کر آیا اَور اَب حاکم بننا چاہتاہے۔ ہم تمہارے ساتھ اِس سے بھی بُرا سلُوک کریں گے۔“ وہ لَوطؔ کو دھمکانے لگے اَور دروازہ توڑنے کے لیٔے آگے بڑھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","لیکن اُن مَردوں نے جو اَندر تھے اَپنے ہاتھ بڑھا کر لَوطؔ کو گھر میں کھینچ لیا اَور دروازہ بند کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","تَب اُنہُوں نے سَب مَردوں کو جو گھر کے دروازہ پر کھڑے تھے کیا جَوان اَور کیا ضعیف، اَندھا کر دیا تاکہ وہ دروازہ نہ ڈھونڈ پائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","اُن مَردوں نے لَوطؔ سے کہا، ”تمہارے ساتھ یہاں کویٔی اَور ہے، داماد، بیٹے یا بیٹیاں یا تیرا کویٔی اَورجو اِس شہر میں ہو؟ سَب کو یہاں سے نکال لے جا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","کیونکہ ہم اِس مقام کو تباہ کرنے والے ہیں، اِس لیٔے کہ یَاہوِہ کے نزدیک اِس شہر کے لوگوں کے خِلاف شور بُلند ہو چُکاہے اَور اُنہُوں نے ہمیں اِسے تباہ کرنے کے لیٔے بھیجا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","تَب لَوطؔ باہر نکلے اَور اَپنے دامادوں سے جِن کے ساتھ اُن کی بیٹیوں کی منگنی ہو چُکی تھی، اُنہُوں نے کہا، ”جلدی کرو، اَور اِس مقام سے نکل چلو کیونکہ یَاہوِہ اِس شہر کو تباہ کرنے کو ہے!“ لیکن لَوطؔ کے دامادوں کو یہ سَب مذاق سا محسُوس ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","جَب پَو پھٹنے لگی تو فرشتوں نے لَوطؔ سے اِصرار کیا اَور کہا، ”جلدی کرو اَور اَپنی بیوی اَور اَپنی دونوں بیٹیوں کو جو یہاں ہیں، لے کر نکل جاؤ، ورنہ جَب اِس شہر پر عذاب نازل ہوگا تو تُم بھی ہلاک ہو جاؤگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ابھی وہ سوچ ہی رہے تھے کہ کیا کریں کہ اُن مَردوں نے اُس کا اَور اُس کی بیوی اَور اُس کی دونوں بیٹیوں کا ہاتھ پکڑا اَور وہ اُنہیں حِفاظت کے ساتھ شہر سے باہر لے گیٔے کیونکہ یَاہوِہ اُن پر مہربان ہویٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","جُوں ہی اُنہُوں نے اُنہیں باہر نکالا اُن میں سے ایک نے کہا، ”اَپنی جان بچا کر بھاگ جاؤ! اَور پیچھے مُڑ کر نہ دیکھنا نہ ہی میدان میں کہیں رُکنا! بَلکہ پہاڑوں پر بھاگ جاؤ ورنہ تُم تباہ ہو جاؤگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","لیکن لَوطؔ نے اُن سے کہا، ”اَے میرے آقاؤں! اَیسا نہ کرو! ");
INSERT INTO urdoucv_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","تُم نے اَپنے خادِم پر نظرِکرم کی ہے اَور مُجھ پر اِس قدر مہربان ہویٔے کہ میری جان بچائی۔ لیکن مَیں پہاڑوں تک بھاگ کر نہیں جا سَکتا۔ یہ آفت مُجھ کو آ لے گی اَور مَیں مَر جاؤں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","دیکھو یہاں ایک شہر ہے، یہ اِس قدر نزدیک ہے کہ مَیں وہاں بھاگ کر جا سَکتا ہُوں اَور وہ چھوٹا بھی ہے۔ مُجھے وہاں بھاگ جانے دیجئے۔ وہ کافی چھوٹا بھی ہے۔ ہے نا؟ تَب میری جان بچ جائے گی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","اُس نے اُس سے کہا، ”بہت خُوب۔ مَیں یہ اِلتجا بھی مان لیتا ہُوں۔ مَیں اُس شہر کو، جِس کا تُو ذِکر کر رہاہے، غارت نہیں کروں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","لیکن تُو جلد وہاں بھاگ جا کیونکہ تمہارے وہاں پہُنچ جانے تک مَیں کچھ نہیں کر سَکتا۔“ (اِسی لیٔے اُس شہر کا نام ضُعَرؔ پڑا)۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","لَوطؔ کے ضُعَرؔ پہُنچنے تک سُورج زمین پر طُلوع ہو چُکاتھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","تَب یَاہوِہ نے اَپنی طرف سے سدُومؔ اَور عمورہؔ پر آسمان سے جلتی ہُوئی گندھک برسائی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","اِس طرح اُنہُوں نے اُن شہروں کو اَور سارے میدان کو اُن شہروں کے باشِندوں اَور زمین کی ساری نباتات سمیت غارت کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","لیکن لَوطؔ کی بیوی نے پیچھے مُڑ کر دیکھا اَور وہ نمک کا سُتون بَن گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","دُوسرے دِن صُبح سویرے اَبراہامؔ اُٹھے اَور اُس مقام کو لَوٹے جہاں وہ یَاہوِہ کے حُضُور کھڑے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","اَبراہامؔ نے نیچے سدُومؔ اَور عمورہؔ اَور اُس میدان کے سارے علاقہ پر نظر دَوڑائی اَور دیکھا کہ اُس سرزمین سے کسی بھٹّی کے دھوئیں جَیسا گہرا دُھواں اُٹھ رہاہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","چنانچہ جَب خُدا اُس میدان کے شہروں کو نِیست و نابُود کر چُکا تو خُدا نے اَبراہامؔ کو یاد کرکے لَوطؔ کو اُس آفت سے بچا لیا جِس سے وہ شہر جہاں لَوطؔ رہتا تھا غارت کر دئیے گیٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","لَوطؔ اَور اُن کی دو بیٹیوں نے ضُعرؔ کو خیرباد کہا اَور وہ پہاڑوں پر جا بسے کیونکہ لَوطؔ، ضُعَرؔ میں رہنے سے ڈرتے تھے۔ وہ اَور اُن کی دو بیٹیاں ایک غار میں رہنے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ایک دِن بڑی بیٹی نے چُھوٹی سے کہا، ”ہمارے باپ ضعیف ہیں اَور یہاں اِردگرد کویٔی مَرد نہیں ہے جو ہمیں صاحبِ اَولاد بنا سکے جَیسا کہ ساری دُنیا کا دستور ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","آؤ، ہم اَپنے باپ کو انگوری شِیرہ پِلائیں اَور تَب اُس سے صحبت کریں اَور اَپنے باپ کے ذریعہ اَپنی نَسل بچائے رکھیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","چنانچہ اُسی رات اُنہُوں نے اَپنے باپ کو انگوری شِیرہ پِلایا اَور بڑی بیٹی اَندر جا کر اُس کے ساتھ لیٹ گئی لیکن لَوطؔ کو مَعلُوم نہ ہُوا کہ وہ کب لیٹی اَور کب اُٹھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","دُوسرے دِن بڑی بیٹی نے چُھوٹی سے کہا، ”گذشتہ رات میں اَپنے باپ کے ساتھ لیٹی تھی۔ چلو آج کی رات بھی ہم اُنہیں انگوری شِیرہ پِلائیں اَور تُو اَندر جا کر اُن کے ساتھ لیٹ جا تاکہ ہم اَپنے باپ کے ذریعہ اَپنی نَسل بچائے رکھیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","چنانچہ اُس رات کو بھی اُنہُوں نے اَپنے باپ کو انگوری شِیرہ پِلایا اَور چُھوٹی بیٹی جا کر اُن کے ساتھ لیٹی اَور اَب کی بار بھی لَوطؔ کو پتا نہ چلا کہ وہ کب لیٹی اَور کب اُٹھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","لہٰذا لَوطؔ کی دونوں بیٹیاں اَپنے باپ سے حاملہ ہُوئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","بڑی بیٹی کے ہاں بیٹا پیدا ہُوا اَور اُس نے اُس کا نام مُوآب رکھا۔ وہ مُوآبیوں کا باپ ہے جو آج تک مَوجُود ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","چُھوٹی بیٹی کے ہاں بھی بیٹا پیدا ہُوا اَور اُس نے اُس کا نام بِن عمّی رکھا۔ وہ عمُّونیوں کا باپ ہے جو آج تک مَوجُود ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","تَب اَبراہامؔ وہاں سے کُوچ کرکے نِیگیوؔ کے علاقہ میں آکر قادِسؔ اَور شُورؔ کے درمیان بس گئے۔ کچھ عرصہ تک وہ گِراؔر میں رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","اَور وہاں اَبراہامؔ نے اَپنی بیوی سارہؔ کے بارے میں فرمایا، ”وہ میری بہن ہے۔“ تَب گِراؔر کے بادشاہ اَبی ملیخ نے سارہؔ کو بُلاکر اَپنے پاس رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","لیکن ایک رات خُدا خواب میں اَبی ملیخ کے پاس آئے اَور اُن سے فرمایا، ”تُم اُس عورت کے سبب سے جسے تُم نے رکھ لیا ہے یہ سمجھ لو کہ تمہاری موت آ پہُنچی ہے کیونکہ وہ عورت شادی شُدہ ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","اَب تک اَبی ملیخ اُن کے پاس نہیں گیا تھا اِس لیٔے اُس نے کہا، ”اَے آقا، کیا آپ ایک بے قُصُور قوم کو بھی تباہ کر دیں گے؟ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","کیا اَبراہامؔ نے مُجھ سے یہ نہ کہاتھا، ’وہ میری بہن ہے،‘ اَور کیا وہ خُود بھی یہ نہ کہتی تھی، ’وہ میرا بھایٔی ہے؟‘ میری اِس حرکت کے باوُجُود میرا دِل صَاف ہے اَور میرے ہاتھ پاک ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","تَب خُدا نے اُسے خواب میں فرمایا، ”ہاں، مَیں جانتا ہُوں کہ تُونے یہ کام راست دِلی سے کیا ہے اَور اِسی لیٔے مَیں نے تُجھے اَپنے خِلاف گُناہ کرنے سے باز رکھا اَور سارہؔ کو چھُونے نہیں دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","اَب تُم اُس آدمی کی بیوی لَوٹا دو کیونکہ وہ نبی ہے اَور وہ تمہاری خاطِر دعا کرےگا اَور تُم جیتے رہوگے۔ لیکن اگر تُم نے اُسے نہ لَوٹایا تو یقین جانو کہ تُم اَور تمہارے سَب لوگ ہلاک ہو جایٔیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","اگلے دِن اَبی ملیخ نے صُبح سویرے اُٹھ کر اَپنے سَب اہلکاروں کو بُلایا اَور جَب اُس نے اُنہیں یہ سَب ماجرا سُنایا تو وہ بےحد خوفزدہ ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","تَب اَبی ملیخ نے اَبراہامؔ کو اَندر بُلاکر کہا، ”آپ نے ہمارے ساتھ یہ کیا کیا؟ مَیں نے آپ کی کیا خطا کی تھی کہ آپ نے مُجھ پر اَور میری بادشاہی پر اِتنا بڑا بارِ گُناہ ڈال دیا؟ آپ نے میرے ساتھ وہ سلُوک کیا ہے جو نہیں کرنا چاہئے تھا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","اَور اَبی ملیخ نے اَبراہامؔ سے پُوچھا، ”کیا وجہ تھی جو آپ نے اَیسا کیا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","اَبراہامؔ نے جَواب دیا، ”مَیں نے سوچا، ’اِس جگہ لوگوں کو بالکُل خُدا کا خوف نہیں ہے اَور وہ میری بیوی سارہؔ کو حاصل کرنے کے لیٔے مُجھے مار ڈالیں گے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","اُس کے علاوہ وہ واقعی میری بہن بھی ہے یعنی میرے باپ کی بیٹی ہے، میری ماں کی بیٹی نہیں ہے، پھر بعد کو وہ میری بیوی بنی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","اَور جَب خُدا نے مُجھے اَپنے باپ کا گھر چھوڑکر وہاں سے نکل جانے کا حُکم دیا تو مَیں نے سارہؔ سے کہا، ’آئندہ تُم مُجھ سے اَپنی مَحَبّت یُوں جتانا: جہاں کہیں ہم جایٔیں وہاں تُم میرے بارے میں یہی کہنا، ”یہ میرا بھایٔی ہے۔“ ‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","تَب اَبی ملیخ نے بھیڑیں اَور مویشی اَور غُلام اَور لونڈیاں لاکر اَبراہامؔ کو دیں اَور اُن کی بیوی سارہؔ کو بھی اُنہیں لَوٹا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","اَور اَبی ملیخ نے اَبراہامؔ سے کہا، ”میرا مُلک آپ کے سامنے ہے؛ جہاں جی چاہے، وہاں سکونت کرو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","اَور اُس نے سارہؔ سے کہا، ”مَیں آپ کے بھایٔی کو چاندی کے ہزار سِکّے دے رہا ہُوں۔ تاکہ اِن سَب کے سامنے جو آپ کے ساتھ ہیں، اُس نازیبا سلُوک کا جو آپ کے ساتھ ہُواہے ازالہ ہو جائے اَور آپ ہر ایک کی نظر میں پاک دامن ٹھہرو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","تَب اَبراہامؔ نے خُدا سے دعا کی اَور خُدا نے اَبی ملیخ، اُن کی بیوی اَور اُن کی خادِماؤں کو شفا بخشی اَور اُن کے اَولاد ہونے لگی ");
INSERT INTO urdoucv_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","کیونکہ یَاہوِہ نے اَبراہامؔ کی بیوی سارہؔ کے سبب سے اَبی ملیخ کے خاندان کی ہر عورت کا رِحم بند کر دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","اَور یَاہوِہ، جَیسا کہ اُنہُوں نے فرمایا تھا، سارہؔ پر مہربان ہویٔے اَور یَاہوِہ نے سارہؔ کے ساتھ جو وعدہ کیا تھا اُسے پُورا کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","سارہؔ حاملہ ہُوئی اَور اَبراہامؔ کے لیٔے اُن کے بُڑھاپے میں ٹھیک خُدا کے مُقرّرہ وقت پر اُن کے یہاں بیٹا پیدا ہُوا ");
INSERT INTO urdoucv_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","اَور اَبراہامؔ نے اَپنے اُس بیٹے کا نام جو سارہؔ سے پیدا ہُوا، اِصحاقؔ رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","اَور جَب اُن کا بیٹا اِصحاقؔ آٹھ دِن کا ہُوا تَب اَبراہامؔ نے خُدا کے حُکم کے مُطابق اُس کا ختنہ کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","جَب اِصحاقؔ پیدا ہُوا تَب اَبراہامؔ کی عمر سَو بَرس کی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","سارہؔ نے کہا، ”خُدا نے مُجھے ہنسایا اَورجو کویٔی اِس بارے میں سُنے گا وہ بھی میرے ساتھ ہنسے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","سارہؔ نے مزید کہا، ”اَبراہامؔ سے کون کہہ سَکتا تھا کہ کبھی سارہؔ بھی بچّوں کو دُودھ پلائے گی۔ پھر بھی مَیں نے اُن کے بُڑھاپے میں اُن کے لئے بیٹے کو پیدا کیا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","اَور وہ لڑکا بڑھا اَور اُس کا دُودھ چھُڑایا گیا اَور جِس دِن اِصحاقؔ کا دُودھ چھُڑایا گیا اُس دِن اَبراہامؔ نے ایک بڑی ضیافت کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","لیکن سارہؔ نے دیکھا کہ ہاگارؔ مِصری کے ہاں جو بیٹا اَبراہامؔ سے پیدا ہُوا تھا وہ اِصحاقؔ کا مضحکہ اُڑاتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","سارہؔ نے اَبراہامؔ سے کہا، ”اُس لونڈی اَور اُس کے بیٹے کو نکال دیجئے کیونکہ اُس لونڈی کا بیٹا میرے بیٹے اِصحاقؔ کے ساتھ مِیراث میں ہرگز وارِث نہ ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","اَبراہامؔ اِس بات سے بےحد پریشان ہویٔے کیونکہ آخِر اِشمعیل بھی تو اُن کا بیٹا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","لیکن خُدا نے اَبراہامؔ سے فرمایا، ”اُس لڑکے اَور اَپنی لونڈی کے بارے میں اِس قدر پریشان نہ ہو۔ جو کُچھ سارہؔ تُم سے کہتی ہے اُسے مان لو کیونکہ تمہاری نَسل کا نام اِصحاقؔ ہی سے آگے بڑھےگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","میں اُس لونڈی کے بیٹے سے بھی ایک قوم پیدا کروں گا کیونکہ وہ بھی تمہارا بیٹا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","دُوسرے دِن صُبح سویرے ہی اَبراہامؔ نے کچھ کھانا اَور پانی کی مشک لے کر ہاگارؔ کے کندھے پر رکھ دی اَور ہاگارؔ کو اُن کے لڑکے کے ساتھ وہاں سے رخصت کر دیا اَور وہ چلی گئیں اَور بیرشبعؔ کے بیابان میں بھٹکتی پھریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","جَب مشک کا پانی ختم ہو گیا تو ہاگارؔ نے لڑکے کو ایک جھاڑی کے سایہ میں چھوڑ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","اَور خُود وہاں سے تقریباً دس مِیٹر کے فاصلہ پر دُور جا کر اَپنے بیٹے کے سامنے بیٹھ گئیں اَور سوچنے لگیں، ”میں اِس بچّے کو مَرتے ہویٔے کیسے دیکھوں گی؟“ اَور وہ وہاں نزدیک بیٹھی ہویٔی زار زار رونے لگیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","خُدا نے لڑکے کے رونے کی آواز سُنی اَور خُدا کے فرشتہ نے آسمان سے ہاگارؔ کو پُکارا اَور اُن سے فرمایا، ”اَے ہاگارؔ! تُجھے کیا ہُوا؟ خوف نہ کرو! خُدا نے اُس جگہ سے جہاں لڑکا پڑا ہے، اُس کی آواز سُن لی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","لڑکے کو اُٹھالو اَور اُس کا ہاتھ تھام کیونکہ مَیں اُس سے ایک بڑی قوم پیدا کروں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","تَب خُدا نے ہاگارؔ کی آنکھیں کھولیں اَور ہاگارؔ نے پانی کا ایک کنواں دیکھا۔ چنانچہ وہ گئیں اَور مشک بھر کر لے آئیں اَور لڑکے کو پانی پِلایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","وہ لڑکا بڑا ہوتا گیا اَور خُدا اِشمعیل کے ساتھ تھے۔ وہ بیابان میں رہتا تھا اَور ایک تیر اَنداز بَن گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","جَب وہ پارانؔ کے بیابان میں رہتے تھے تو اُن کی ماں نے مِصر کی ایک لڑکی سے اِشمعیل کی شادی کر دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","اُس وقت اَبی ملیخ اَور اُس کے سپہ سالار فِیکُلؔ نے اَبراہامؔ سے کہا، ”خُدا آپ کے ہر کاموں میں آپ کی مدد کرتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","آپ خُدا کے حُضُور مُجھ سے قَسم کھا کر وعدہ کرو کہ آپ نہ مُجھ سے، اَور نہ میرے بچّوں سے اَور نہ ہی میری نَسل سے دغا کروگے، بَلکہ مُجھ پر اَور اِس مُلک پر جِس میں آپ پردیسی کی طرح رہتے ہو، وَیسی ہی مہربانی کرنا جَیسی مہربانی مَیں نے آپ پر کی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","اَبراہامؔ نے فرمایا، ”میں قَسم کھاتا ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","تَب اَبراہامؔ نے اَبی ملیخ سے پانی کے ایک کنوئیں کے متعلّق شکایت کی جسے اَبی ملیخ کے خادِموں نے زبردستی چھین لیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","لیکن اَبی ملیخ نے کہا، ”میں نہیں جانتا کہ یہ کِس کی حرکت ہے۔ آپ نے بھی مُجھے نہیں بتایا اَور مُجھے تو یہ بات آج ہی مَعلُوم ہویٔی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","تَب اَبراہامؔ بھیڑیں اَور مویشی لے کر آئے اَور اُنہیں اَبی ملیخ کے حوالہ کر دیا اَور اُن دونوں آدمیوں نے آپَس میں عہد کر لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","اَبراہامؔ نے گلّہ میں سے بھیڑ کے سات مادہ برّوں کو لے کر الگ رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","اَور اَبی ملیخ نے اَبراہامؔ سے پُوچھا، ”بھیڑ کے اِن سات مادہ برّوں کو الگ رکھنے سے آپ کا کیا مطلب ہے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","اَبراہامؔ نے جَواب دیا، ”تُم بھیڑ کے اِن سات مادہ برّوں کو میرے ہاتھ سے اِس اَمر کے بطور گواہ قبُول کرو کہ یہ کنواں مَیں نے کھودا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","اِس لیٔے وہ مقام بیرشبعؔ کہلایا کیونکہ اُن دو آدمیوں نے وہاں قَسم کھا کر عہد کیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","بیرشبعؔ کے مقام پر عہد ہو جانے کے بعد اَبی ملیخ اَور اُس کا سپہ سالار، فِیکُلؔ مُلکِ فلسطین لَوٹ گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","اَور اَبراہامؔ نے بیرشبعؔ میں ایک جھاؤ کا درخت لگایا اَور وہاں آپ نے یَاہوِہ، اَبدی خُدا سے دعا کی ");
INSERT INTO urdoucv_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","اَور اَبراہامؔ بہت عرصہ تک مُلکِ فلسطین میں رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","کچھ عرصہ بعد خُدا نے اَبراہامؔ کو آزمایا۔ خُدا نے اُن سے فرمایا، ”اَبراہامؔ!“ اُنہُوں نے جَواب دیا، ”مَیں حاضِر ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","تَب خُدا نے فرمایا، ”اَپنے اِکلوتے بیٹے اِصحاقؔ کو جِس سے تُم مَحَبّت کرتے ہو ساتھ لے کر موریاہؔ کے علاقہ میں جاؤ اَور وہاں کے ایک پہاڑ پرجو میں تُمہیں بتاؤں گا اُسے سوختنی نذر کی قُربانی کے طور پر نذر کرو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","دُوسرے دِن صُبح سویرے اَبراہامؔ نے اُٹھ کر اَپنے گدھے پر زین کسی اَور اَپنے خادِموں میں سے دو کو اَور اَپنے بیٹے اِصحاقؔ کو اَپنے ساتھ لیا۔ جَب اُس نے سوختنی نذر کی قُربانی کے لیٔے حسبِ ضروُرت لکڑیاں کاٹ لیں تو وہ اُس مقام کی طرف چل دئیے جو خُدا نے اُنہیں بتایا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","تیسرے دِن اَبراہامؔ نے اُوپر نگاہ کی اَور وہاں سے دُور اُنہیں وہ مقام دِکھائی دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","اَبراہامؔ نے اَپنے خادِموں سے فرمایا، ”تُم یہیں گدھے کے پاس ٹھہرو اَور مَیں اَور یہ لڑکا اُوپر جاتے ہیں۔ وہاں ہم عبادت کریں گے اَور پھر تمہارے پاس لَوٹ آئیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","اَبراہامؔ نے سوختنی نذر کی قُربانی کی لکڑیاں لے کر اَپنے بیٹے اِصحاقؔ کو دیں کہ وہ اُنہیں اُٹھالے اَور آگ اَور چھُری خُود سنبھالی۔ جَیسے ہی وہ دونوں ایک ساتھ روانہ ہویٔے، ");
INSERT INTO urdoucv_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","اِصحاقؔ نے اَپنے باپ اَبراہامؔ سے پُوچھا، ”اَبّا؟“ اَبراہامؔ نے جَواب دیا، ”ہاں، میرے بیٹے؟“ اِصحاقؔ نے کہا، ”آگ اَور لکڑیاں یہاں ہیں لیکن سوختنی نذر کی قُربانی کے لیٔے برّہ کہاں ہے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","اَبراہامؔ نے جَواب دیا، ”اَے میرے بیٹے! خُدا آپ ہی سوختنی نذر کی قُربانی کے لیٔے برّہ مہیا کرےگا۔“ اَور وہ دونوں ساتھ ساتھ آگے بڑھ گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","جَب وہ اُس مقام پر پہُنچے جو خُدا نے آپ کو بتایا تھا تو اَبراہامؔ نے وہاں مذبح اَور اُس پر لکڑیاں چُن دیں۔ پھر اَبراہامؔ نے اَپنے بیٹے اِصحاقؔ کو رسّی سے باندھ کر مذبح پر لکڑیوں کے اُوپر رکھ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","تَب اَبراہامؔ نے ہاتھ میں چھُری لی تاکہ اَپنے بیٹے کو ذبح کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","لیکن یَاہوِہ کے فرشتہ نے اَبراہامؔ کو آسمان سے پُکارا، ”اَے اَبراہامؔ، اَے اَبراہامؔ!“ اَبراہامؔ نے جَواب دیا، ”مَیں حاضِر ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","یَاہوِہ نے فرمایا، ”اِس لڑکے پر ہاتھ نہ بڑھاؤ؛ اَور اُسے کچھ نہ کرنا۔ اَب مَیں جان گیا کہ تُو خُدا سے ڈرنے والا اِنسان ہے کیونکہ تُونے مُجھ سے اَپنے بیٹے، بَلکہ اِکلوتے بیٹے کو بھی دریغ نہ کیا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","اَبراہامؔ نے نگاہ اُٹھائی اَور آپ نے وہاں ایک مینڈھا دیکھا جِس کے سینگ جھاڑیوں میں پھنسے ہویٔے تھے۔ اَبراہامؔ نے جا کر اُس مینڈھے کو پکڑا اَور اُسے اَپنے بیٹے کی بجائے سوختنی نذر کی قُربانی کے طور پر چڑھایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","اِس لیٔے اَبراہامؔ نے اُس مقام کا نام ”یَاہوِہ یِراِہ“ رکھا۔ آج کے دِن تک یہ مثال دی جاتی ہے، ”یَاہوِہ کے پہاڑ پر مُہیّا کیا جایٔےگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","یَاہوِہ کے فرشتہ نے آسمان سے دُوسری مرتبہ اَبراہامؔ کو پُکارا ");
INSERT INTO urdoucv_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","یَاہوِہ نے اَپنی ذات کی قَسم کھا کر فرمایا، ”چونکہ تُونے میرے حُکم پر عَمل کیا اَور اَپنے بیٹے یعنی اَپنے اِکلوتے بیٹے کو بھی دریغ نہ کیا، ");
INSERT INTO urdoucv_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","اِس لیٔے میں یقیناً تُمہیں برکت دُوں گا اَور تمہاری اَولاد کو آسمان کے سِتاروں اَور سمُندر کے کنارے کی ریت کی مانند بے شُمار بڑھاؤں گا اَور تمہاری اَولاد اَپنے دُشمنوں کے شہروں پر قابض ہوگی، ");
INSERT INTO urdoucv_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","اَور تمہاری نَسل کے ذریعہ زمین کی سَب قومیں برکت پائیں گی کیونکہ تُم نے میرا حُکم مانا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","تَب اَبراہامؔ اَپنے خادِموں کے پاس لَوٹ آئے اَور وہ سَب بیرشبعؔ کو روانہ ہویٔے اَور اَبراہامؔ نے بیرشبعؔ میں قِیام کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","چند دِنوں کے بعد اَبراہامؔ کو یہ خبر مِلی، ”مِلکاہؔ بھی ماں بَن چُکی ہے اَور آپ کے بھایٔی ناحوؔر سے بھی بیٹے پیدا ہویٔے ہیں، ");
INSERT INTO urdoucv_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","یعنی عُوضؔ جو اُس کا پہلوٹھا ہے اَور اُس کا بھایٔی بوز، قمُوایلؔ (جو ارام کا باپ ہے)، ");
INSERT INTO urdoucv_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","کسِدؔ، حَازو، پِلداشؔ، جِدلافؔ اَور بیتُھوایلؔ۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","اَور بیتُھوایلؔ سے رِبقہؔ پیدا ہُوئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ناحوؔر کی داشتہ کے ہاں بھی، جِس کا نام ریُومہ تھا بیٹے پیدا ہویٔے، جِن کے نام طیبحؔ، گاحمؔ، تحصؔ اَور معکہؔ ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","سارہؔ کی عمر ایک سَو ستّائیس بَرس کی ہُوئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","اَبراہامؔ نے مُلکِ کنعانؔ کے قِریت اربعؔ (یعنی حِبرونؔ میں) وفات پائی، اَور اَبراہامؔ سارہؔ کے لیٔے ماتم اَور نوحہ کرنے کے لیٔے وہاں گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","تَب اَبراہامؔ اَپنی بیوی کی میّت کے پاس سے اُٹھ کر حِتّیوں سے گُفتگو کرنے لگے۔ اُنہُوں نے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","”مَیں تمہارے درمیان پردیسی اَور اجنبی ہُوں۔ تُم مُجھے قبرستان کے لیٔے اَپنی کچھ زمین بیچ دو تاکہ میں اَپنے مُردہ کو دفن کر سکوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","حِتّیوں نے اَبراہامؔ کو جَواب دیا: ");
INSERT INTO urdoucv_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","”اَے آقا، ہماری سُنئے۔ آپ ہمارے درمیان ایک پُروقار سردار ہیں۔ ہماری قبروں میں سے جو بہترین ہو اُس میں سے آپ اَپنے مُردہ کو دفن کیجئے۔ ہم میں سے کویٔی بھی آپ کو اَپنا مُردہ دفن کرنے کے لیٔے اَپنی قبر دینے سے اِنکار نہ کرےگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","تَب اَبراہامؔ اُٹھے اَور حِتّیوں کے سامنے، جو اُس مُلک کے باشِندے تھے آداب بجا لائے ");
INSERT INTO urdoucv_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","اَور اُن سے فرمایا، ”اگر تمہاری یہ مرضی ہے کہ میں اَپنے مُردہ کو دفن کروں تو میری عرض سُنو اَور ضُحرؔ کے بیٹے عِفرونؔ سے میری سِفارش کرو ");
INSERT INTO urdoucv_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","کہ وہ مکفیلہؔ کا غار جو اُس کا ہے، اَور اُس کے کھیت کے آخِر میں ہے۔ اُس سے کہو کہ وہ اُسے پُوری قیمت پر قبرستان کے لیٔے مُجھے بیچ دے۔ تاکہ وہ تمہارے درمیان میری مِلکیّت شُمار کی جائے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","عِفرونؔ حِتّی وہاں اَپنے لوگوں کے درمیان بیٹھا ہُوا تھا۔ اَور اُس نے اُن سَب حِتّیوں کے رُوبرو جو اُس کے شہر کے پھاٹک پر جمع تھے اَبراہامؔ کو جَواب دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","عِفرونؔ نے حِتّی سے کہا، ”نہیں، اَے میرے آقا؛ میری بات سُنئے؛ میں آپ کو وہ کھیت دیئے دیتا ہُوں اَور وہ غار بھی جو اُس میں ہے۔ میں اَپنے لوگوں کے رُوبرو یہ جگہ آپ کے حوالہ کرتا ہُوں۔ جائیے اَور اَپنے مُردہ کو دفن کیجئے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","تَب اَبراہامؔ اُس مُلک کے لوگوں کے سامنے ایک بار پھر آداب بجا لائے ");
INSERT INTO urdoucv_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","اَور اُن کے رُوبرو سَب کو سُناتے ہُوئے عِفرونؔ سے فرمایا، ”اگر تمہاری مرضی ہو تو میں اُس کھیت کو خریدنا چاہتا ہُوں۔ مُجھ سے قیمت لے لو تاکہ میں اَپنے مُردہ کو وہاں دفن کر سکوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","عِفرونؔ نے اَبراہامؔ کو جَواب دیا، ");
INSERT INTO urdoucv_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","”میرے آقا! میری بات سُنئے۔ اُس زمین کی قیمت چاندی کے چار سَو ثاقل ہے، لیکن یہ رقم میرے اَور آپ کے درمیان کچھ معنی نہیں رکھتی ہے؟ جائیے! آپ اَپنے مُردہ کو دفن کیجئے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","اَبراہامؔ نے عِفرونؔ کی بات مان لی اَور سوداگروں میں رائج وزن کے مُطابق چار سَو ثاقل چاندی اُسے دے دی، جِس کا اعلان عِفرونؔ نے حِتّیوں کی مَوجُودگی میں کیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","لہٰذا عِفرونؔ کا وہ کھیت جو ممرےؔ کے سامنے مکفیلہؔ میں تھا، اَور وہ غار جو اُس میں تھا تمام درختوں سمیت جو اُس کھیت کے حُدوُد میں تھے، ");
INSERT INTO urdoucv_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","اُن سارے حِتّیوں کے سامنے جو شہر کے پھاٹک پر مَوجُود تھے باقاعدہ اَبراہامؔ کی مِلکیّت قرار دئیے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","اُس کے بعد اَبراہامؔ نے اَپنی بیوی سارہؔ کو مکفیلہؔ کے کھیت کے غار میں دفن کیا، جو مُلکِ کنعانؔ میں ممرےؔ (یعنی حِبرونؔ) کے نزدیک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","چنانچہ وہ کھیت اَور اُس میں کا غار حِتّیوں کی طرف سے قبرستان کے لیٔے اَبراہامؔ کی مِلکیّت قرار دیئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","اَبراہامؔ اَب ضعیف اَور عمر رسیدہ ہو چُکے تھے اَور یَاہوِہ نے آپ کو ہر پیمانے سے برکت دی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","اَبراہامؔ نے اَپنے گھر کے خاص خادِم سے جو اُن کی سَب چیزوں کا مختار تھا فرمایا، ”تُم اَپنا ہاتھ میری ران کے نیچے رکھو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","یَاہوِہ کی جو آسمان اَور زمین کا خُدا ہے، قَسم کھاؤ کہ تُم میرے بیٹے کو کنعانیوں کی بیٹیوں میں سے جِن کے درمیان مَیں رہتا ہُوں، کسی سے بھی شادی نہیں کرنے دوگے، ");
INSERT INTO urdoucv_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","بَلکہ میرے وطن میں میرے اَپنے رشتہ داروں کے پاس جا کر میرے بیٹے اِصحاقؔ کے لیٔے بیوی لاؤگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","خادِم نے اَبراہامؔ سے پُوچھا، ”اگر وہاں کی کویٔی عورت میرے ساتھ اِس مُلک میں آنے کو راضی نہ ہو تو کیا میں آپ کے بیٹے کو اُس مُلک میں واپس لے جاؤں جہاں سے آپ آئے ہیں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","اَبراہامؔ نے فرمایا، ”خبردار تُم میرے بیٹے کو وہاں ہرگز واپس نہ لے جانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","یَاہوِہ، آسمان کے خُدا ہیں، جو مُجھے اَپنے باپ کے گھر اَور میرے وطن سے نکال لائے اَور جنہوں نے مُجھ سے کلام کیا اَور قَسم کھا کر مُجھ سے یہ وعدہ کیا، ’میں یہ مُلک تمہاری نَسل کو دُوں گا۔‘ وُہی اَپنا فرشتہ تمہارے آگے آگے بھیجیں گے تاکہ تُم وہاں سے میرے بیٹے کے لیٔے بیوی لے آؤ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","اگر وہ عورت تمہارے ساتھ آنا نہ چاہے، تو تُم میری اِس قَسم سے بَری ہو جاؤگے۔ پر تُم میرے بیٹے کو وہاں نہ لے جانا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","چنانچہ اُس خادِم نے اَپنا ہاتھ اَپنے آقا اَبراہامؔ کی ران کے نیچے رکھا اَور قَسم کھائی کہ وہ اَیسا ہی کرےگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","تَب اُس خادِم نے اَپنے آقا کے اُونٹوں میں سے دس اُونٹ لیٔے اَور اُن پر ہر قِسم کی بہترین اَشیا لادیں جو اَبراہامؔ نے دی تھیں اَور وہ ارام نحرائیمؔ یعنی مسوپتامیہؔ کی طرف نکلے اَور ناحوؔر کے شہر کے پاس جاپہنچے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","اُس نے شہر کے باہر ایک کنوئیں کے پاس اُونٹوں کو بِٹھا دیا؛ یہ شام کا وقت تھا جَب عورتیں پانی بھرنے کے لیٔے نکلتی ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","تَب خادِم نے دعا کی، ”اَے یَاہوِہ، میرے آقا اَبراہامؔ کے خُدا، آج مُجھے کامیابی بخش اَور میرے آقا اَبراہامؔ پر مہربان ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","دیکھ میں اِس چشمہ کے پاس کھڑا ہُوں اَور اِس شہر کے لوگوں کی بیٹیاں پانی بھرنے کے لیٔے آ رہی ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","کاش اَیسا ہو کہ جَب مَیں کسی لڑکی سے کہُوں، ’ذرا اَپنا گھڑا جھُکا کر مُجھے پانی پِلا دے،‘ اَور وہ لڑکی کہے، ’پانی پی لیجئے اَور مَیں تمہارے اُونٹوں کو بھی پانی پِلا دُوں گی،‘ تو وہ وُہی لڑکی ہو جسے آپ نے اَپنے خادِم اِصحاقؔ کے لیٔے چُناہے اِس سے میں جان لُوں گا کہ آپ نے میرے آقا پر مہربانی کی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","اِس سے قبل کہ وہ اَپنی دعا ختم کرتا رِبقہؔ اَپنا گھڑا کندھے پر لیٔے ہویٔے آئی۔ وہ اَبراہامؔ کے بھایٔی ناحوؔر کی بیوی مِلکاہؔ کے بیٹے بیتُھوایلؔ کی بیٹی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","لڑکی نہایت خُوبصورت، کنواری؛ اَور مَرد سے ناواقِف تھی۔ وہ نیچے اُتر کر چشمے کے پاس گئی اَور پھر اَپنا گھڑا بھرکے اُوپر آ گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","تَب وہ خادِم دَوڑکر اُسے مِلنے گیا اَور کہنے لگا، ”اَپنے گھڑے میں سے تھوڑا پانی مُجھے پِلا دیجئے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","رِبقہؔ نے کہا، ”ضروُر میرے آقا، پانی پی لیجئے“ اَور وہ فوراً گھڑے کو نیچے اُتار کر ہاتھ سے اُسے پانی پِلانے لگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","جَب وہ خادِم کو پانی پِلا چُکی تو رِبقہؔ نے کہا، ”مَیں تمہارے اُونٹوں کے لئے بھی پانی بھر کر لاتی ہُوں جَب تک کہ وہ پی کر سیر نہ ہو جایٔیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","چنانچہ اُس نے جلدی سے اَپنے گھڑے کا پانی حوض میں اُنڈیل دیا اَور وہ دَوڑ دَوڑکر کنوئیں سے پانی لاتی رہی اَور اُس کے سَب اُونٹوں کے لیٔے کافی پانی بھر لائی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","وہ خادِم نہایت خاموشی سے اُسے دیکھتا رہا تاکہ یہ جان سکے کہ یَاہوِہ نے اُس کا سفر مُبارک کیا ہے یا نہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","جَب اُونٹ پانی پی چُکے تو اُس شخص نے ساڑے پانچ گرام سونے کی ایک نتھ اَور تقریباً ایک سوپندرہ گرام وزن کے سونے کے دو کنگن نکالے ");
INSERT INTO urdoucv_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","اَور لڑکی سے پُوچھا، ”تُم کِس کی بیٹی ہو؟ مُجھے بتاؤ کیا تمہارے باپ کے گھر میں ٹھہرنے کی کوئی جگہ ہے کہ ہم وہاں رات گزار سکیں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","رِبقہؔ نے جَواب دیا، ”میں بیتُھوایلؔ کی بیٹی ہُوں، وہ مِلکاہؔ کا بیٹا ہے جو ناحوؔر سے اُن کے یہاں پیدا ہُوا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","اَور اُس نے یہ بھی کہا، ”ہمارے ہاں کافی بھُوسا اَور چارا ہے اَور ٹھہرنے کے لئے جگہ بھی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","تَب اُس آدمی نے جھُک کر یَاہوِہ کو سَجدہ کیا، ");
INSERT INTO urdoucv_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","اَور کہا، ”یَاہوِہ، میرے آقا اَبراہامؔ کے خُدا کی تمجید ہو، جِس نے میرے آقا کو اَپنے رحم و کرم اَور راستی سے محروم نہ رکھا اَور یَاہوِہ نے مُجھے صحیح راہ پر چلا کر میرے آقا کے رشتہ داروں کے گھر پر پہُنچا دیا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","وہ لڑکی دَوڑتی ہُوئی گئی اَور اَپنی ماں کے گھر میں یہ ماجرا کہہ سُنایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","اَور رِبقہؔ کا ایک بھایٔی تھا جِس کا نام لابنؔ تھا۔ وہ اُس آدمی کے پاس جانے کے لیٔے تیزی سے باہر نِکلا جو چشمے کے پاس تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","اَور پھر جوں ہی اُس نے وہ نتھ اَور اَپنی بہن رِبقہؔ کے ہاتھوں میں وہ کنگن دیکھے اَور رِبقہؔ سے اُس آدمی کی باتیں سُنیں تو وہ اُس آدمی کے پاس گیا اَور اُسے چشمہ کے نزدیک اُونٹوں کے پاس کھڑا پایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","لابنؔ نے خادِم سے کہا، ”تُم جو یَاہوِہ کی طرف سے مُبارک ہو، میرے گھر چلو۔ تُم یہاں باہر کیوں کھڑے ہو؟ مَیں نے گھر کو، اَور اُونٹوں کے ٹھہرنے کے لیٔے بھی جگہ کو تیّار کر لیا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","تَب وہ آدمی گھر میں داخل ہُوا اَور اُونٹوں پر سے سامان اُتارا گیا۔ اُونٹوں کے لیٔے بھُوسا اَور چارا اَور اُس کے اَور اُس کے آدمیوں کے پاؤں دھونے کے لیٔے پانی لایا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","تَب اُس کے سامنے کھانا رکھا گیا۔ لیکن اُس نے کہا، ”میں اُس وقت تک نہ کھاؤں گا جَب تک تُم سے اَپنے آنے کا سبب نہ بَیان کر دُوں۔“ لابنؔ نے کہا، ”بہت خُوب، بَیان کریں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","تَب اُس نے کہا، ”مَیں اَبراہامؔ کا خادِم ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","یَاہوِہ نے میرے آقا کو بڑی برکت دی ہے اَور وہ بڑے دولتمند آدمی ہو گئے ہیں۔ یَاہوِہ نے اُنہیں بھیڑیں اَور مویشی، چاندی اَور سونا خادِم اَور خادِمائیں اَور اُونٹ اَور گدھے دئیے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","میرے آقا کی بیوی سارہؔ کے بُڑھاپے میں ایک بیٹا پیدا ہُوا اَور اَبراہامؔ نے اُسے اَپنا سَب کچھ دے دیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","میرے آقا نے مُجھ سے قَسم دے کر کہا ہے، ’تُم میرے بیٹے کے لیٔے کنعانیوں کی بیٹیوں میں سے جِن کے مُلک میں، مَیں رہتا ہُوں کسی کو اُس کے نکاح میں نہ دینا، ");
INSERT INTO urdoucv_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","بَلکہ میرے باپ کے خاندان، اَور میری برادری والوں میں جانا، اَور میرے بیٹے کے لیٔے بیوی لانا۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","”تَب مَیں نے اَپنے آقا سے پُوچھا، ’اگر وہ عورت میرے ساتھ آنا نہ چاہے تو کیا ہوگا؟‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","”میرے آقا نے جَواب دیا، ’یَاہوِہ، جِن کے حُضُوری میں چلتا رہا ہُوں، اَپنا فرشتہ تمہارے ساتھ بھیجے گا اَور تمہارے سفر کو مُبارک کرےگا تاکہ تُم میری برادری والوں اَور میرے باپ کے خاندان میں سے میرے بیٹے کے لیٔے بیوی لا سکو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","اَور جَب تُم میری برادری والوں میں پہُنچ جاؤ تَب میری اِس قَسم سے بَری ہو جاؤگے اَور اگر وہ تُمہیں لڑکی دینے سے اِنکار کریں، تَب بھی تُم میری قَسم سے بَری ہو جاؤگے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","”اَور آج جَب مَیں چشمہ پر پہُنچا تو مَیں نے کہا، ’اَے یَاہوِہ، میرے آقا اَبراہامؔ کے خُدا! اگر آپ کی مرضی ہو تو میرے اِس سفر کو مُبارک کیجئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","اَور دیکھو، مَیں اِس چشمہ کے پاس کھڑا ہُوں، اگر کویٔی لڑکی پانی بھرنے آئے اَور مَیں اُس سے کہُوں، ”مُجھے اَپنے گھڑے سے تھوڑا پانی پلا دو،“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","اَور اگر وہ مُجھ سے کہے، ”پانی پی لیجئے، اَور مَیں تمہارے اُونٹوں کے لیٔے بھی پانی بھر دُوں گی،“ تو وہ وُہی ہو جسے یَاہوِہ نے میرے آقا کے بیٹے کے لیٔے چُناہے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","”اِس سے قبل کہ میں اَپنے دِل میں یہ دعا پُوری کر پاتا، رِبقہؔ اَپنا گھڑا اَپنے کندھے پر لیٔے ہویٔے آ پہُنچی۔ وہ چشمہ کے پاس نیچے گئی، اَور پانی بھر لائی، اَور مَیں نے اُس سے کہا، ’برائے مہربانی مُجھے پانی پِلا دیجئے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","”اُس نے فوراً اَپنے کندھے پر سے اَپنا گھڑا اُتارا اَور کہا، ’پانی پی لیجئے اَور مَیں تمہارے اُونٹوں کو بھی پانی پِلا دُوں گی۔‘ چنانچہ مَیں نے پانی پی لیا اَور اُس نے اُونٹوں کو بھی پانی پِلایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","”تَب مَیں نے اُس سے پُوچھا، ’تُم کِس کی بیٹی ہو؟‘ ”اُس نے کہا، ’میں بیتُھوایلؔ بِن ناحوؔر کی بیٹی ہُوں، اَور اُس کی ماں کا نام مِلکاہؔ ہے۔‘ ”تَب مَیں نے اُس کی ناک میں نتھ اَور اُس کے ہاتھوں میں کنگن پہنائے، ");
INSERT INTO urdoucv_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","اَور مَیں نے جھُک کر یَاہوِہ کو سَجدہ کیا۔ مَیں نے یَاہوِہ اَپنے آقا اَبراہامؔ کے خُدا کی تمجید کی، جِس نے مُجھے صداقت کی راہ پر چلایا کہ اَپنے آقا کے بھایٔی کی پوتی کو اُن کے بیٹے کے لیٔے لے جاؤں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","لہٰذا اَب اگر تُم میرے آقا کے ساتھ رحم و کرم اَور راستی سے پیش آنا چاہتے ہو تو مُجھے بتاؤ؛ اَور اگر نہیں، تو بھی کہہ دو، تاکہ یہ مَعلُوم ہو جائے کہ اَب مُجھے کِس طرف پلٹنا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","لابنؔ اَور بیتُھوایلؔ نے جَواب دیا، ”یہ بات یَاہوِہ کی طرف سے ہویٔی ہے، اَب ہم تُمہیں بُرا یا بھلا بھی کیا کہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","یہ رہی رِبقہؔ۔ اِسے لے لیجئے اَور رخصت ہو جایئں اَور اِسے یَاہوِہ کے قول کے مُطابق اَپنے آقا کے بیٹے سے بیاہ دو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","جَب اَبراہامؔ کے خادِم نے اُن کی باتیں سُنیں تو اُس نے زمین پر جھُک کر یَاہوِہ کو سَجدہ کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","تَب اُس خادِم نے سونے اَور چاندی کے زیورات اَور لباس نکال کر رِبقہؔ کو دیئے اَور اُس کے بھایٔی اَور اُس کی ماں کو بھی قیمتی تحفے پیش کئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","تَب اُس نے اَور اُس کے ساتھ کے آدمیوں نے کھایا پیا اَور رات وہیں بسر کی۔ اگلے دِن صُبح جَب وہ اُٹھے تو خادِم نے کہا، ”مُجھے میرے آقا کے پاس روانہ کر دیجئے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","لیکن رِبقہؔ کے بھایٔی اَور اُس کی ماں نے جَواب دیا، ”لڑکی کو دس دِن اَور ہمارے پاس رہنے دیجئے؛ اُس کے بعد اُسے لے جانا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","لیکن خادِم نے اُن سے کہا، ”اَب جَب کہ یَاہوِہ نے میرا سفر مُبارک کیا ہے تو مُجھے مت روکئے؛ مُجھے رخصت کر دیجئے تاکہ میں اَپنے آقا کے پاس جاؤں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","تَب اُنہُوں نے کہا، ”ہم رِبقہؔ کو بُلاکر اِس بارے میں اُس سے پُوچھتے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","چنانچہ اُنہُوں نے رِبقہؔ کو بُلاکر پُوچھا، ”کیا تُم اِس شخص کے ساتھ جاؤگی؟“ رِبقہؔ نے کہا، ”ہاں، میں جاؤں گی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","تَب اُنہُوں نے اَپنی بہن رِبقہؔ اَور اُس کی دایہ کو اَبراہامؔ کے خادِم اَور اُن کے آدمیوں کے ساتھ رخصت کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","اَور اُنہُوں نے رِبقہؔ کو دعا دیتے ہُوئے کہا، ”اَے ہماری بہن! تُو لاکھوں کی ماں ہو؛ اَور تمہاری نَسل اَپنے دُشمنوں کے شہروں پر قابض ہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","تَب رِبقہؔ اَور اُس کی خادِمائیں تیّار ہو گئیں اَور اَپنے اُونٹوں پر سوار ہویٔیں اَور اُس آدمی کے ساتھ روانہ ہو گئیں اَور اِس طرح وہ خادِم رِبقہؔ کو ساتھ لے کر روانہ ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","اِس دَوران اِصحاقؔ بیرلخیؔ روئی سے آکر اَب نِیگیوؔ مُلک میں رہتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ایک شام کو اِصحاقؔ دعا کرنے کے لیٔے کھیت میں نکل پڑے اَور جوں ہی اُنہُوں نے نگاہ اُٹھائی تو دیکھا کہ سامنے سے اُونٹ آ رہے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","رِبقہؔ نے بھی نگاہ اُٹھائی اَور اِصحاقؔ کو دیکھا۔ تَب وہ اَپنے اُونٹ پر سے نیچے اُتری ");
INSERT INTO urdoucv_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","اَور خادِم سے پُوچھا، ”کھیت میں وہ آدمی کون ہے، جو ہم سے مِلنے آ رہاہے؟“ اُس خادِم نے جَواب دیا، ”وہ میرے آقا ہیں۔“ تَب رِبقہؔ نے اَپنا نقاب لے کر اَپنے آپ کو ڈھانپ لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","تَب خادِم نے سَب ماجرا اِصحاقؔ کو کہہ سُنایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","اِصحاقؔ رِبقہؔ کو اَپنی ماں سارہؔ کے خیمہ میں لے آئے اَور اُنہُوں نے رِبقہؔ سے شادی کی۔ اِس طرح وہ اُن کی بیوی بنی اَور اُنہُوں نے اُس سے مَحَبّت کی؛ اَور اِس طرح اِصحاقؔ نے اَپنی ماں کی موت کے بعد تسلّی پائی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","اَبراہامؔ نے ایک اَور عورت سے شادی کی جِس کا نام قِطورہؔ تھا ");
INSERT INTO urdoucv_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","اَور اُس سے زِمرانؔ، یُقشانؔ، مِدان، مِدیان، اِشبقؔ اَور شُوعؔح پیدا ہُوئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","یُقشانؔ سے شیبا اَور دِدانؔ پیدا ہویٔے اَور دِدانؔ کی نَسل سے اشُوریم، لطُوسی اَور لومی لوگ ہُوئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","اَور بنی مِدیان یہ ہیں: عیفاہؔ، عِفرؔ، حنوخؔ، اَبیداعؔ اَور اِلدعؔح تھے۔ یہ سَب قِطورہؔ کی اَولاد تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","اَبراہامؔ نے اَپنا سَب کچھ اِصحاقؔ کے لیٔے چھوڑ دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","لیکن اَپنے جیتے جی اَبراہامؔ نے اَپنی داشتاؤں کے بیٹوں کو انعامات دے کر اُنہیں اَپنے بیٹے اِصحاقؔ کے پاس سے مشرقی مُلک کو بھیج دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","اَبراہامؔ کی کُل عمر ایک سَو پچہتّر بَرس کی ہُوئی ");
INSERT INTO urdoucv_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","تَب اَبراہامؔ نے آخِری سانس لی اَور عَین بُڑھاپے میں نہایت ضعیف اَور پُوری عمر کا ہوکر وفات پائی اَور اَپنے لوگوں میں جا مِلے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","اَور اُن کے بیٹے اِصحاقؔ اَور اِشمعیل نے مکفیلہؔ کے غار میں جو ممرےؔ کے نزدیک حِتّی ضُحرؔ کے بیٹے عِفرونؔ کے کھیت میں ہے اَبراہامؔ کو دفن کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","اُس کھیت کو اَبراہامؔ نے حِتّیوں سے خریدا تھا۔ وہیں اَبراہامؔ کو اُن کی بیوی سارہؔ کے پاس دفن کیا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","اَبراہامؔ کی وفات کے بعد خُدا نے اُن کے بیٹے اِصحاقؔ کو برکت دی جو اُس وقت بیرلخیؔ روئی کے پاس رہتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","یہ اَبراہامؔ کے بیٹے اِشمعیل کا نَسب نامہ ہے جو سارہؔ کی لونڈی ہاگارؔ مِصری سے اَبراہامؔ کے یہاں پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","اِشمعیل کے بیٹوں کے ناموں کی ترتیب، اُن کی پیدائش کے مُطابق یہ ہے: نبایوتؔ جو اِشمعیل کا پہلوٹھا تھا، قیدارؔ، ادبیلؔ، مبسامؔ، ");
INSERT INTO urdoucv_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","مِشماعؔ، دُومہؔ، مَسّا، ");
INSERT INTO urdoucv_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","حددؔ، تیماؔ، یطُورؔ، نافیشؔ اَور قِدمہؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","یہ اِشمعیل کے بیٹے تھے، اَور بَارہ قبیلوں کے سردار اَپنی بستیوں اَور چھاؤنیوں کے مُطابق اِن ہی سے نامزد ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","اِشمعیل کی کُل عمر ایک سَو سینتیس بَرس کی ہو گئی۔ تَب آپ نے وفات پائی اَور اَپنے لوگوں سے جا مِلے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","اُن کی اَولاد مِصر کی مشرقی سرحد کے نزدیک اشُور کی سمت میں حَویلہؔ سے شُورؔ تک کے علاقے میں آباد ہوئی۔ یہ لوگ اَپنے سَب قبیلوں کے لوگوں سے بَیر رکھتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","اَبراہامؔ کے بیٹے اِصحاقؔ کا نَسب نامہ یہ ہے: اَبراہامؔ سے اِصحاقؔ پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","اَور اِصحاقؔ چالیس بَرس کے تھے جَب آپ نے رِبقہؔ سے بیاہ کیا جو فدّان ارام کے باشِندہ بیتُھوایلؔ ارامی کی بیٹی اَور لابنؔ ارامی کی بہن تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","اَور اِصحاقؔ نے اَپنی بیوی کے لیٔے یَاہوِہ سے دعا کی کیونکہ وہ بانجھ تھیں۔ یَاہوِہ نے اُن کی دعا سُنی اَور اُن کی بیوی رِبقہؔ حاملہ ہُوئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","اَور اُن کے رِحم میں دو بچّے آپَس میں زورآزمائی کرنے لگے۔ تَب رِبقہؔ نے کہا، ”میرے ساتھ اَیسا کیوں ہو رہاہے؟“ چنانچہ رِبقہؔ نے یَاہوِہ سے پُوچھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","یَاہوِہ نے رِبقہؔ سے فرمایا، ”تمہارے رِحم میں دو بیٹے گویا دو قومیں ہیں، اَور یہ قوموں کے لوگ جو تمہارے بطن سے ہُوں گی ایک دُوسری سے جُدا کر دی جایٔیں گی؛ ایک بیٹا دُوسرے بیٹے سے زورآور ہوگا، اَور بڑا چُھوٹے کی خدمت کرےگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","جَب اُن کی زچگی کا وقت آ گیا تَب پتہ چلا کہ اُن کے رِحم میں جُڑواں بچّے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","جو پہلے پیدا ہُوا وہ سُرخ تھا اَور اُس کا سارا جِسم بالوں سے بنے ہویٔے کپڑے کی طرح تھا۔ اِس لیٔے اُنہُوں نے اُس کا نام عیسَوؔ رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","اُس کے بعد اُس کا بھایٔی پیدا ہُوا جو اَپنے ہاتھ سے عیسَوؔ کی اِیڑی پکڑے ہویٔے تھا اِس لیٔے اُس کا نام یعقوب رکھا گیا۔ جَب رِبقہؔ نے اُن دونوں کو پیدا کیا تَب اِصحاقؔ کی عمر ساٹھ بَرس کی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","پھر لڑکے بڑے ہو گئے اَور عیسَوؔ ماہر شِکاری بَن گیا۔ اُسے کھُلی جگہ میں رہنا پسند تھا۔ اَور یعقوب خاموش طبیعت اِنسان تھا اَور اُسے خیموں ہی میں رہنا اَچھّا لگتا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","اِصحاقؔ جسے شِکار کا گوشت بہت پسند تھا عیسَوؔ سے پیار کرتا تھا لیکن رِبقہؔ یعقوب کو پیار کرتی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ایک دفعہ یعقوب دال پکا رہے تھے کہ عیسَوؔ جنگل سے لَوٹا اَور اُسے سخت بھُوک لگ رہی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","عیسَوؔ نے یعقوب سے کہا، ”جلدی کیجئے اَور مُجھے اِس لال لال شَے میں سے کچھ کھانے کو دیجئے کیونکہ مَیں بھُوک سے بےدم ہو رہا ہُوں۔“ (اِسی وجہ سے اُس کا نام اِدُوم پڑ گیا یعنی سُرخ۔) ");
INSERT INTO urdoucv_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","یعقوب نے کہا، ”اَچھّا پہلے اَپنا پہلوٹھا ہونے کا حق مُجھے دے دو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","عیسَوؔ نے کہا، ”دیکھو، مَیں تو بھُوک سے مَرا جا رہا ہُوں؛ پہلوٹھے ہونے کا حق میرے کِس کام کا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","لیکن یعقوب نے کہا، ”پہلے آپ مُجھ سے قَسم کھاؤ۔“ اِس لیٔے عیسَوؔ نے قَسم کھا کر اَپنا پہلوٹھا ہونے کا حق یعقوب کے ہاتھ بیچ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","لہٰذا یعقوب نے عیسَوؔ کو کچھ روٹی اَور مسور کی دال جو آپ نے پکائی تھی دے دی اَور عیسَوؔ کھا پی کر اُٹھا اَور چلا گیا۔ اِس طرح عیسَوؔ نے پہلوٹھے ہونے کے اَپنے حق کی بےقدری کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","پھر مُلک میں قحط پڑا جو اُس پہلے قحط کے علاوہ تھا جو اَبراہامؔ کے ایّام میں پڑا تھا۔ اِس لیٔے اِصحاقؔ گِراؔر میں فلسطینی بادشاہ اَبی ملیخ کے پاس چلےگئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","تَب یَاہوِہ اِصحاقؔ پر ظاہر ہویٔے اَور فرمایا، ”مِصر کو نہ جانا بَلکہ جہاں میں تُمہیں رہنے کو کہُوں وہیں رہنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","تُم اِس مُلک میں کچھ عرصہ کے لیٔے رہو اَور مَیں تمہارے ساتھ رہُوں گا اَور تُمہیں برکت دُوں گا۔ میں یہ تمام مُلک تُمہیں اَور تمہاری نَسل کو دے کر وہ قَسم پُوری کروں گا جو مَیں نے تمہارے باپ اَبراہامؔ سے کھائی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","مَیں تمہاری اَولاد کو آسمان کے تاروں کی طرح بڑھاؤں گا اَور اُنہیں یہ تمام مُلک دُوں گا اَور تمہاری نَسل کے وسیلہ سے دُنیا کی سَب قومیں برکت پائیں گی، ");
INSERT INTO urdoucv_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","کیونکہ اَبراہامؔ نے میری باتیں مانیں اَور میرے اَحکام میرے قوانین اَور میری ہدایات پر عَمل کیا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","چنانچہ اِصحاقؔ گِراؔر میں مُقیم ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","جَب وہاں کے باشِندوں نے اُن سے اُن کی بیوی کے متعلّق پُوچھا تَب آپ نے کہا، ”وہ میری بہن ہے،“ کیونکہ وہ یہ کہنے سے ڈرتے تھے، ”وہ میری بیوی ہے۔“ اِصحاقؔ نے سوچا، ”اِس جگہ کے لوگ رِبقہؔ کی وجہ سے مُجھے قتل نہ کر ڈالیں کیونکہ رِبقہؔ خُوبصورت ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","جَب اِصحاقؔ کو وہاں رہتے ہویٔے کافی عرصہ گزر گیا تَب فلسطینی بادشاہ اَبی ملیخ نے ایک کھڑکی سے نیچے جھانک کر دیکھا کہ اِصحاقؔ اَپنی بیوی رِبقہؔ سے لاڈ پیار کر رہاہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","تَب اَبی ملیخ نے اِصحاقؔ کو بُلوا کر کہا، ”دراصل وہ تمہاری بیوی ہے! پھر تُم نے یہ کیوں کہا، ’وہ تمہاری بہن ہے‘؟“ اِصحاقؔ نے اُسے جَواب دیا، ”کیونکہ مَیں نے سوچا کہ کہیں اَیسا نہ ہو کہ اُس کی وجہ سے مُجھے اَپنی جان سے ہاتھ دھونے پڑے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","تَب اَبی ملیخ نے کہا، ”یہ تُم نے ہمارے ساتھ کیا کیا؟ یہ ممکن تھا کہ اِن میں سے کوئی شخص تمہاری بیوی کے ساتھ مباشرت کر لیتا اَور تُم ہم پر اِلزام لگاتے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","تَب اَبی ملیخ نے سَب لوگوں میں اعلان کروایا: ”جو کویٔی اِس مَرد یا اِس کی بیوی پر ہاتھ ڈالے گا وہ یقیناً قتل کر دیا جائے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","اَور اِصحاقؔ نے اُس سال اُس مُلک میں جِتنی فصل بوئی اُس کا سَو گُنا پھل پایا کیونکہ یَاہوِہ نے اُنہیں برکت دی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","وہ بہت مالدار ہو گئے اَور اُن کی دولت بڑھتی چلی گئی یہاں تک کہ اَبراہامؔ بےحد اَمیر ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","اُن کے پاس اِس قدر زِیادہ بھیڑ بکریاں اَور جانور اَور نوکر چاکر تھے کہ فلسطینی اُن سے حَسد کرنے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","چناچہ فلسطینیوں نے وہ سَب کنوئیں جو اُن کے باپ اَبراہامؔ کے خادِموں نے اَبراہامؔ کے جیتے جی کھودے تھے مٹّی سے بھر کر بند کر دئیے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","تَب اَبی ملیخ نے اِصحاقؔ سے کہا، ”تُم ہمارے پاس سے چلے جاؤ کیونکہ تُم ہم سے زِیادہ زورآور ہو گئے ہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","چنانچہ اِصحاقؔ وہاں سے کُوچ کرکے گِراؔر کی وادی میں جا کر خیمہ زن ہو گئے اَور وہیں بس گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","اِصحاقؔ نے اُن کنوؤں کو جو اُن کے باپ اَبراہامؔ کے دِنوں میں کھودے گیٔے تھے اَور جنہیں فلسطینیوں نے اَبراہامؔ کی موت کے بعد بند کر دیا تھا پھر سے کھُلوا دیا اَور اُن کے وُہی نام رکھے جو اُن کے باپ نے رکھے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","جَب اِصحاقؔ کے خادِم وادی میں کھدائی کر رہے تھے تو اُنہیں تازہ پانی کا ایک کنواں مِلا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","تَب گِراؔر کے چرواہوں نے اِصحاقؔ کے چرواہوں سے جھگڑا کیا اَور کہا، ”یہ پانی ہمارا ہے!“ اِس لیٔے اِصحاقؔ نے اُس کنوئیں کا نام عِسقؔ رکھا کیونکہ وہ اُن سے جھگڑتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","پھر اُنہُوں نے دُوسرا کنواں کھودا لیکن وہ اُس کے لیٔے بھی جھگڑنے لگے۔ اِس لیٔے اِصحاقؔ نے اُس کا نام سِتنہؔ یعنی مُخالفت رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","پھر وہاں سے آگے جا کر آپ نے ایک اَور کنواں کھودا اَور اُس کے لیٔے کسی نے جھگڑا نہ کیا۔ اِصحاقؔ نے اُس کا نام یہ کہہ کر رحوبوتھؔ رکھا، ”اَب یَاہوِہ نے ہمیں جگہ دی ہے اَور اَب ہم اِس مُلک میں آسُودہ حال ہوں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","جَب وہ وہاں سے بیرشبعؔ کو چلےگئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","اُسی رات یَاہوِہ آپ پر ظاہر ہویٔے اَور فرمایا، ”مَیں تمہارے باپ اَبراہامؔ کا خُدا ہُوں۔ خوف نہ کرو۔ مَیں تمہارے ساتھ ہُوں۔ اَپنے خادِم اَبراہامؔ کی خاطِر میں تُمہیں برکت دُوں گا اَور تمہاری نَسل کو بڑھاؤں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","اِصحاقؔ نے وہاں ایک مذبح بنایا اَور یَاہوِہ سے دعا کی۔ وہاں آپ نے اَپنا خیمہ کھڑا کیا اَور وہیں اُن کے خادِموں نے ایک کنواں کھودا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","اِس اَثنا میں اَبی ملیخ اَپنے ذاتی مُشیر اخُوزتؔ اَور اَپنے فَوجی سپہ سالار فِیکُلؔ کے ہمراہ گِراؔر سے اِصحاقؔ کے پاس آیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","اِصحاقؔ نے پُوچھا، ”تُم میرے پاس کیوں آئے ہو؟ تُم تو مُجھ سے عداوت رکھتے تھے اَور مُجھے اَپنے علاقہ سے نکال چُکے تھے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","اُنہُوں نے جَواب دیا، ”ہم نے خُوب جان لیا ہے کہ یَاہوِہ تمہارے ساتھ ہے؛ اِس لیٔے ہم نے کہا، ’کیوں نہ ہم قَسم کھا کر آپَس میں عہد کر لیں۔‘ ہم تمہارے ساتھ یہ عہد کرنا چاہتے ہیں ");
INSERT INTO urdoucv_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","کہ جِس طرح ہم نے تمہارے ساتھ کویٔی ناجائز حرکت نہیں کی بَلکہ تمہارے ساتھ ہمیشہ نیک سلُوک کیا اَور تُمہیں سلامتی سے رخصت کیا اُسی طرح تُم بھی ہمیں کویٔی نُقصان نہ پہُنچاؤگے اَور اَب یَاہوِہ نے تُمہیں برکت بخشی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","تَب اِصحاقؔ نے اُن کے لیٔے ضیافت تیّار کی اَور اُنہُوں نے کھا پی کر خُوشی منائی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","دُوسرے دِن علی الصبح اُنہُوں نے قَسم کھا کر آپَس میں عہد کر لیا۔ تَب اِصحاقؔ نے اُنہیں رخصت کر دیا اَور وہ سلامتی کے ساتھ وہاں سے چلے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","اُس دِن اِصحاقؔ کے خادِموں نے آکر اُن سے اُس کنوئیں کا ذِکر کیا جسے اُنہُوں نے کھودا تھا۔ اُنہُوں نے کہا، ”ہمیں پانی مِل گیا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","اِصحاقؔ نے اُس کا نام شِباہ رکھا اَور آج تک وہ شہر بیرشبعؔ کہلاتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","جَب عیسَوؔ چالیس بَرس کے ہویٔے تو اُنہُوں نے بیؔری حِتّی کی بیٹی یُودِتھؔ اَور ایلون حِتّی کی بیٹی بسِماتھؔ سے بیاہ کر لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","وہ اِصحاقؔ اَور رِبقہؔ کے لیٔے وبالِ جان بَن گئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","جَب اِصحاقؔ ضعیف ہو گئے اَور اُن کی آنکھیں اِس قدر کمزور ہو گئیں کہ اُن کی بینائی جاتی رہی۔ تَب اُنہُوں نے اَپنے بڑے بیٹے عیسَوؔ کو بُلایا اَور فرمایا، ”اَے میرے بیٹے۔“ عیسَوؔ نے جَواب دیا، ”مَیں حاضِر ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","اِصحاقؔ نے فرمایا، ”دیکھو میں اَب ضعیف ہو چُکا ہُوں اَور کیا پتا کب مَر جاؤں! ");
INSERT INTO urdoucv_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","لہٰذا تُم اَپنے ہتھیار یعنی ترکش اَور کمان لے کر جنگل میں جاؤ اَور میرے لیٔے شِکار مار لاؤ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","اَور میری پسند کے مُطابق لذیذ کھانا تیّار کرکے میرے پاس لے آ تاکہ میں اُسے کھا کر اَپنے مرنے سے پہلے تُمہیں برکت دُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","جَب اِصحاقؔ اَپنے بیٹے عیسَوؔ سے باتیں کر ہی رہے تھے تَب رِبقہؔ اُن کی باتیں سُن رہی تھی۔ جَب عیسَوؔ شِکار مار کر لانے کے لیٔے جنگل کی طرف روانہ ہُوا، ");
INSERT INTO urdoucv_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","تو رِبقہؔ نے اَپنے بیٹے یعقوب سے کہا، ”دیکھو، مَیں نے تمہارے باپ کو اَپنے بیٹے عیسَوؔ سے یہ کہتے سُنا ہے، ");
INSERT INTO urdoucv_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","’میرے لیٔے شِکار مار لاؤ اَور نہایت لذیذ کھانا تیّار کرو تاکہ میں اَپنی موت سے پہلے یَاہوِہ کی حُضُوری میں تُمہیں برکت دُوں۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","اِس لئے، اَے میرے بیٹے! غور سے سُنو اَورجو کچھ میں تُم سے کہتی ہُوں وہ کرو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","گلّے میں جا کر بکری کے دو بہترین بچّے لاکر مُجھے دو تاکہ مَیں تمہارے باپ کے لیٔے اُن کی پسند کا لذیذ کھانا تیّار کر سکوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","تَب اُسے اَپنے اَبّا کے پاس لے جانا تاکہ وہ اُسے کھایٔیں اَور اَپنے مرنے سے پہلے تُمہیں برکت دیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","تَب یعقوب نے اَپنی ماں رِبقہؔ سے کہا، ”لیکن میرے بھایٔی عیسَوؔ کے جِسم پر گھنے بال ہیں اَور مَیں اَیسا آدمی ہُوں جِس کی جِلد ملائم ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","اگر میرے باپ مُجھے چھُوئیں گے تو میں دغاباز ٹھہروں گا اَور برکت کی بجائے لعنت پاؤں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","اُن کی ماں نے اُن سے کہا، ”میرے بیٹے، لعنت مُجھ پر آئے۔ جو میں کہتی ہُوں تُم بس وُہی کرو؛ جاؤ اَور بکری کے بچّے میرے لیٔے لے آؤ۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","تَب یعقوب گئے اَور اُنہیں لے کر اَپنی ماں کے پاس لے آئے اَور رِبقہؔ نے اُن کے باپ کی پسند کا نہایت لذیذ کھانا تیّار کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","پھر رِبقہؔ نے اَپنے بڑے بیٹے عیسَوؔ کا نہایت نفیس لباس جو گھر میں تھا اَور اُسے اَپنے چُھوٹے بیٹے یعقوب کو پہنایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","اَور رِبقہؔ نے اُن کے ہاتھوں اَور گردن کے چِکنے حِصّہ پر بکری کے بچّوں کی کھال لپیٹ دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","پھر اُس نے وہ لذیذ کھانا اَور روٹی جو اُس نے پکائی تھی اَپنے بیٹے یعقوب کے ہاتھ میں دے دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","وہ اَپنے باپ کے پاس گئے اَور کہا، ”اَے میرے باپ!“ اِصحاقؔ نے جَواب دیا، ”ہاں میرے بیٹے، تُم کون ہو؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","یعقوب نے اَپنے باپ کو جَواب دیا، ”میں تمہارا پہلوٹھا بیٹا عیسَوؔ ہُوں۔ مَیں نے تمہارے کہنے کے مُطابق کیا ہے۔ لہٰذا اُٹھئے اَور میرے شِکار میں سے کچھ کھالیجئے تاکہ آپ مُجھے برکت دے سکیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","اِصحاقؔ نے اَپنے بیٹے سے پُوچھا، ”میرے بیٹے، تُمہیں یہ شِکار اِس قدر جلدی کیسے مِل گیا؟“ یعقوب نے جَواب دیا، ”یَاہوِہ تمہارے خُدا نے مُجھے کامیابی بخشی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","تَب اِصحاقؔ نے یعقوب سے فرمایا، ”اَے میرے بیٹے، قریب آ تاکہ میں تُمہیں چھُو کر مَعلُوم کروں کہ واقعی تُو میرا بیٹا عیسَوؔ ہے یا نہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","یعقوب اَپنے باپ اِصحاقؔ کے نزدیک گئے اَور اُنہُوں نے اُنہیں چھُوا اَور کہا، ”آواز تو یعقوب کی سِی ہے لیکن ہاتھ عیسَوؔ کے سے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","اِصحاقؔ نے یعقوب کو نہیں پہچانا کیونکہ اُن کے ہاتھ اُس کے بھایٔی عیسَوؔ کی مانند بال والے تھے۔ لہٰذا اِصحاقؔ نے یعقوب کو برکت دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","اِصحاقؔ نے پُوچھا، ”کیا واقعی تُو میرا بیٹا عیسَوؔ ہی ہے؟“ یعقوب نے جَواب دیا، ”میں ہی ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","تَب اِصحاقؔ نے کہا، ”میرے بیٹے، اَپنے شِکار کا کچھ حِصّہ میرے سامنے لا تاکہ میں اُسے کھاؤں اَور تُمہیں اَپنی برکت بخشوں۔“ یعقوب اُسے اَپنے باپ کے پاس لے آئے اَور آپ نے کھایا اَور وہ کچھ انگوری شِیرہ بھی لے آئے اَور اِصحاقؔ نے پیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","تَب اُن کے باپ اِصحاقؔ نے اُن سے کہا، ”اَے میرے بیٹے یہاں میرے نزدیک آؤ اَور مُجھے چُومو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","چنانچہ یعقوب اُن کے پاس گئے اَور اُنہیں چُوما۔ جَب اِصحاقؔ نے عیسَوؔ کی پوشاک کی خُوشبو پائی تو اُنہیں برکت دی اَور فرمایا، ”میرے بیٹے کی خُوشبو اُس کھیت کی مہک کی مانند ہے جسے یَاہوِہ نے برکت دی ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","خُدا تُمہیں آسمان کی اوس اَور زمین کی زرخیزی یعنی اناج کی فراوانی اَور تازہ انگوری شِیرہ بخشے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","قومیں تمہاری خدمت کریں اَور سارے قبیلے تمہارے سامنے جھُکیں۔ تُم اَپنے بھائیوں کے آقا ٹھہرو، اَور تمہاری ماں کے بیٹے تمہارے سامنے جھُکیں۔ جو تُم پر لعنت بھیجیں وہ تُم پر لعنتی ہُوں اَورجو تُمہیں مُبارکباد دیں وہ برکت پائیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","اِصحاقؔ سے برکت پانے کے بعد یعقوب باہر نکلے ہی تھے کہ اُن کا بھایٔی عیسَوؔ شِکار لے کر لَوٹا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","عیسَوؔ نے بھی کچھ لذیذ کھانا تیّار کیا اَور اَپنے باپ کے پاس لے آیا۔ تَب اُنہُوں نے باپ سے کہا، ”اَے میرے باپ! اُٹھئے اَور میرے شِکار کا گوشت کھائیے تاکہ آپ مُجھے برکت دے سکیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","اُن کے باپ اِصحاقؔ نے پُوچھا، ”تُم کون ہو؟“ اُنہُوں نے جَواب دیا، ”میں تمہارا پہلوٹھا بیٹا عیسَوؔ ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","یہ سُن کر اِصحاقؔ پر لرزہ طاری ہو گیا اَور اُنہُوں نے کہا، ”پھر وہ کون تھا جو شِکار مار کر میرے پاس لایاتھا؟ مَیں نے شِکار کا وہ گوشت ابھی ابھی تمہارے آنے سے پہلے کھایا اَور اُسے برکت دی۔ اَور برکت اُسی کو ملے گی!“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","جَب عیسَوؔ نے اَپنے باپ کے الفاظ سُنے تو وہ نہایت بُلند اَور تلخی سے چِلّا اُٹھے اَور اَپنے باپ سے کہا، ”مُجھے برکت دیجئے، ہاں اَے میرے باپ مُجھے بھی برکت دیجئے!“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","مگر اِصحاقؔ نے فرمایا، ”تمہارے بھایٔی نے دغا کی اَور تمہاری برکت لے لی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","عیسَوؔ نے کہا، ”کیا اُس کا نام یعقوب ٹھیک نہیں رکھا گیا؟ اُس نے مُجھے دو دفعہ دھوکا دیا ہے: پہلے اُنہُوں نے میرا پیدائشی حق چھینا اَور اَب اُنہُوں نے میری برکت بھی چھین لی!“ تَب اُس نے پُوچھا، ”کیا میرے لیٔے آپ کے پاس کویٔی برکت باقی نہیں بچی؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","اِصحاقؔ نے عیسَوؔ کو جَواب دیا، ”مَیں نے اُسے تمہارا آقا مُقرّر کر دیا اَور اُس کے تمام رشتہ داروں کو اُس کا خادِم بنا دیا اَور مَیں نے اُسے اناج کی فراوانی اَور تازہ انگوری شِیرے کی برکت بخشی ہے۔ اَب اَے میرے بیٹے، مَیں تمہارے لیٔے کیا کر سکتا ہُوں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","عیسَوؔ نے اَپنے باپ سے پُوچھا، ”اَے میرے باپ، کیا آپ کے پاس صِرف ایک ہی برکت ہے؟ مُجھے بھی برکت دے دیجئے!“ اَے میرے باپ! تَب عیسَوؔ زور زور سے رونے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","اُس کے باپ اِصحاقؔ نے اُسے جَواب دیا، ”تمہارا قِیام زرخیز زمین سے اَور اُوپر کے آسمان کی اوس سے پرے ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","تُم تلوار کے بَل پر جیتے رہوگے اَور اَپنے بھایٔی کی خدمت کروگے۔ لیکن جَب تُم میں برداشت کی طاقت نہ رہے گی، تو تُم اُس کا جُوا اَپنی گردن پر سے اُتار پھینکوگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","عیسَوؔ یعقوب سے اُس برکت کے باعث جو اُن کے باپ اِصحاقؔ نے یعقوب کو بخشی کینہ رکھتا تھا۔ عیسَوؔ نے سوچا، ”میرے باپ کے ماتم کے دِن نزدیک ہیں۔ وہ گزر جایٔیں تو میں اَپنے بھایٔی یعقوب کو مار ڈالوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","جَب رِبقہؔ کو اَپنے بڑے بیٹے کی یہ باتیں بتایٔی گئیں تو اُنہُوں نے اَپنے چُھوٹے بیٹے یعقوب کو بُلایا اَور اُن سے کہا، ”تمہارا بھایٔی عیسَوؔ تُمہیں مار ڈالنے کے خیال سے اَپنے دِل کو تسلّی دے رہاہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","اِس لیٔے اَے میرے بیٹے مَیں جو کہتی ہُوں وہ کرو۔ فوراً حارانؔ میں میرے بھایٔی لابنؔ کے پاس چلے جاؤ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","جَب تک کہ تمہارے بھایٔی کا غُصّہ ٹھنڈا نہ ہو جائے تُم وہیں رہنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","جَب تمہارے بھایٔی کا غُصّہ جو تُم پر ہے اُتر جائے گا اَورجو تُم نے اُس کے ساتھ کیا ہے اُسے وہ بھُول جائے گا تو میں تُمہیں وہاں سے بُلوا بھیجوں گی۔ میں ایک ہی دِن میں تُم دونوں کو آخِر کیوں کھو بیٹھوں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","تَب رِبقہؔ نے اِصحاقؔ سے کہا، ”میں اِن حِتّی لڑکیوں کی وجہ سے زندگی سے بیزار آ چُکی ہُوں۔ اگر یعقوب اِس مُلک کی لڑکیوں میں سے جَیسا کہ یہ حِتّی لڑکیاں ہیں، کسی کے ساتھ بیاہ کرےگا تو میرا جینا دوبھر ہو جائے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","تَب اِصحاقؔ نے یعقوب کو بُلایا اَور اُنہیں برکت بخشی اَور حُکم دیا، ”تُم کسی کنعانی لڑکی سے بیاہ نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","فوراً فدّان ارام کو اَپنے نانا بیتُھوایلؔ کے گھر چلے جاؤ اَور وہاں اَپنے ماموں لابنؔ کی بیٹیوں میں سے کسی سے شادی کر لو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","قادرمُطلق خُدا تُمہیں برکت بخشے، تُمہیں برومند کرے اَور تُمہیں اِس قدر بڑھائے کہ تُم سے ایک قوم وُجُود میں آ جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","خُدا تُمہیں اَور تمہاری نَسل کو اَبراہامؔ کی سِی برکت بخشے تاکہ تُم اِس مُلک کو جہاں تُم اِس وقت بطور پردیسی رہتے ہو اَور جسے خُدا نے اَبراہامؔ کو بخشا تھا اَپنے قبضہ میں لے آئے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","تَب اِصحاقؔ نے یعقوب کو رخصت کیا اَور وہ فدّان ارام میں لابنؔ کے پاس چلےگئے جو بیتُھوایلؔ ارامی کا بیٹا اَور عیسَوؔ اَور یعقوب کی ماں رِبقہؔ کا بھایٔی تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","جَب عیسَوؔ کو پتا چلا کہ اِصحاقؔ نے یعقوب کو برکت دے کر فدّان ارام بھیجا تاکہ وہاں سے بیوی بیاہ لائیں اَور یہ بھی کہ اِصحاقؔ نے اُنہیں برکت دیتے وقت تاکید کی تھی، ”کہ وہ کسی کنعانی لڑکی سے شادی نہ کریں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","اَور یعقوب اَپنے ماں باپ کے حُکم کے مُطابق فدّان ارام چلےگئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","تو عیسَوؔ کو احساس ہُوا کہ اُن کے باپ اِصحاقؔ کو کنعانی لڑکیاں کِس قدر بُری لگتی ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","لہٰذا عیسَوؔ اِشمعیل کے پاس گیا اَور اَپنی پہلی بیویوں کے باوُجُود ماحلتھ کو بیاہ لایا جو نبایوتؔ کی بہن اَور اَبراہامؔ کے بیٹے اِشمعیل کی بیٹی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","یعقوب بیرشبعؔ سے نکل کر حارانؔ کی طرف چل دئیے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","جَب وہ ایک مقام پر پہُنچے تو شب گزاری کے لیٔے وہاں ٹھہر گئے کیونکہ سُورج غروب ہو چُکاتھا۔ اُنہُوں نے وہاں کے پتّھروں میں سے ایک پتّھر لے کر اَپنے سَر کے نیچے رکھا اَور سونے کے لیٔے لیٹ گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","اُنہُوں نے خواب میں دیکھا: ایک سیڑھی زمین پر کھڑی ہے اَور اُس کا دُوسرا سِرا آسمان تک پہُنچا ہُواہے اَور خُدا کے فرشتے اُس پر چڑھتے اَور اُترتے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","اَور یَاہوِہ اُس کے اُوپر کھڑے تھے اَور کہہ رہے تھے: ”مَیں یَاہوِہ تمہارے باپ اَبراہامؔ کا خُدا اَور اِصحاقؔ کا خُدا ہُوں۔ میں یہ زمین جِس پر تُم لیٹے ہو تُمہیں اَور تمہاری نَسل کو دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","تمہاری نَسل خاک کے ذرّوں کے مانند ہوگی اَور تُم مشرق و مغرب اَور شمال و جُنوب کی جانِب پھیل جاؤگے۔ زمین کے سَب قبیلے تمہارے اَور تمہاری نَسل کے وسیلہ سے برکت پائیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","مَیں تمہارے ساتھ ہُوں اَور تُم جہاں کہیں جاؤگے وہاں تمہاری حِفاظت کروں گا اَور مَیں تُمہیں اِس مُلک میں واپس لاؤں گا اَورجو وعدہ مَیں نے تُم سے کیا ہے اُسے پُورا کرنے تک میں تُمہیں اکیلا نہ چھوڑوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","جَب یعقوب نیند سے بیدار ہُوئے تو کہا، ”ہو نہ ہو یَاہوِہ اِس جگہ مَوجُود ہیں اَور مُجھے اِس کا علم نہ تھا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","یعقوب خوفزدہ ہوکر کہنے لگے، ”یہ جگہ کیسی پُرجلال ہے! یہ جگہ خُدا کے گھر کے سِوا اَور کیا ہو سکتی ہے؛ یہ تو ضروُر آسمان کا پھاٹک ہی ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","دُوسرے دِن علی الصبح یعقوب نے اُس پتّھر کو لے کر جسے اُنہُوں نے اَپنے سَر کے نیچے رکھا تھا سُتون کی طرح کھڑا کیا اَور اُس کے اُوپر زَیتُون کا تیل ڈالا، ");
INSERT INTO urdoucv_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","اَور یعقوب نے اُس مقام کا نام بیت ایل رکھا حالانکہ پہلے اُس شہر کا نام لُوزؔ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","تَب یعقوب نے یہ مَنّت مانی، ”اگر خُدا اِس سفر میں میرے ساتھ رہے میری حِفاظت کرے اَور مُجھے کھانے کے لیٔے روٹی اَور پہننے کے لیٔے کپڑے عطا کرے ");
INSERT INTO urdoucv_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","تاکہ میں اَپنے باپ کے گھر سلامت جا پہُنچوں تو یَاہوِہ میرا خُدا ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","اَور یہ پتّھر جسے مَیں نے سُتون کے طور پر کھڑا کیا ہے خُدا کا مَسکن ہوگا اَور اَے خُدا جو کچھ آپ مُجھے عطا کریں گے میں اُس کا دسواں حِصّہ آپ کو دُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","اَور یعقوب نے اَپنا سفر جاری رکھا اَور وہ مشرق میں رہنے والے لوگوں کے مُلک میں جاپہنچے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","وہاں اُنہُوں نے میدان میں ایک کنواں دیکھا جِس کے پاس بھیڑوں کے تین گلّے مَوجُود تھے۔ کیونکہ اُن گلّوں کو اُسی کنوئیں سے پانی پِلایا جاتا تھا۔ کنوئیں کے مُنہ پر ایک بڑا سا پتّھر رکھا ہُوا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","جَب سَب گلّے اِکٹھّے ہو جاتے تھے تو چرواہے اُس پتّھر کو کنوئیں کے مُنہ پر سے لُڑھکا کر بھیڑوں کو پانی پِلاتے تھے اَور پھر پتّھر کو واپس اَپنی جگہ کنوئیں کے مُنہ پر رکھ دیتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","یعقوب نے چرواہوں سے پُوچھا، ”بھائیو! تُم کہاں کے ہو؟“ اُنہُوں نے جَواب دیا، ”ہم حارانؔ کے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","تَب یعقوب نے چرواہوں سے پُوچھا، ”کیا تُم لابنؔ کو جانتے ہو جو ناحوؔر کا پوتا ہے؟“ اُنہُوں نے جَواب دیا، ”ہاں، ہم لابنؔ کو جانتے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","تَب یعقوب نے اُن سے پُوچھا، ”کیا وہ خیریت سے ہیں؟“ اُنہُوں نے کہا، ”ہاں، وہ خیریت سے ہیں اَور وہ دیکھو اُن کی بیٹی راخلؔ بھیڑوں کو لے کر آ رہی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","یعقوب نے کہا، ”دیکھو، ابھی تو دِن ہے اَور بھیڑ بکریوں کو جمع کرنے کا وقت بھی نہیں ہُوا لہٰذا بھیڑوں کو پانی پِلا کر واپس چراگاہ میں لے جاؤ۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","اُنہُوں نے جَواب دیا، ”ہم اَیسا نہیں کر سکتے۔ جَب سَب گلّے اِکٹھّے ہو جایٔیں گے اَور پتّھر کو کنوئیں کے مُنہ سے لُڑھکایا جائے گا تَب ہی ہم بھیڑوں کو پانی پلائیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","وہ ابھی اُن سے باتیں کر ہی رہے تھے کہ راخلؔ اَپنے باپ کی بھیڑوں کو لے کر آ پہُنچی کیونکہ وُہی اُن کی گلّہ بان تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","جَب یعقوب نے اَپنے ماموں لابنؔ کی بیٹی راخلؔ کو اَور لابنؔ کی بھیڑوں کو دیکھا تو اُنہُوں نے جا کر کنوئیں کے مُنہ پر سے پتّھر کو لُڑھکا دیا اَور اَپنے ماموں کی بھیڑوں کو پانی پِلانے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","تَب یعقوب نے راخلؔ کو چُوما اَور یعقوب زاروقطار رونے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","پھر یعقوب نے راخلؔ سے کہا، کہ وہ اُن کے باپ کا رشتہ دار اَور رِبقہؔ کا بیٹا ہے، راخلؔ نے یہ سُنا تو وہ دَوڑتی ہُوئی گئی اَور اَپنے باپ کو خبر دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","جُوں ہی لابنؔ کو اَپنے بھانجے یعقوب کی خبر مِلی وہ اُن سے مِلنے کو دَوڑے۔ لابنؔ نے یعقوب کو گلے سے لگایا اَور چُوما اَور اُنہیں اَپنے گھر لے آئے اَور وہاں یعقوب نے لابنؔ کو ساری داستان کہہ سُنائی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","تَب لابنؔ نے یعقوب سے کہا، ”تُم میرا اَپنا گوشت اَور خُون ہو۔“ یعقوب کو مامو کے ساتھ رہتے ہویٔے پُورا ایک ماہ گزر چُکاتھا ");
INSERT INTO urdoucv_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","کہ لابنؔ نے یعقوب سے کہا، ”میرا رشتہ دار ہونے کے باعث یہ ضروُری نہیں کہ تُم بِلا مُعاوضہ میری خدمت کرو! لہٰذا مُجھے بتاؤ کہ تمہاری اُجرت کیا ہوگی؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","لابنؔ کی دو بیٹیاں تھیں بڑی کا نام لِیاہؔ تھا اَور چُھوٹی کا راخلؔ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","لِیاہؔ کی آنکھیں کمزور تھیں لیکن راخلؔ سڈول اَور خُوبصورت تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","یعقوب راخلؔ سے مَحَبّت کرتے تھے۔ لہٰذا اُنہُوں نے کہا، ”مَیں تمہاری چُھوٹی بیٹی راخلؔ کے لیٔے سات بَرس تمہاری خدمت کروں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","لابنؔ نے کہا، ”راخلؔ کو کسی اَور آدمی کو دینے کی بجائے تُمہیں دینا بہتر ہے لہٰذا تُم میرے ساتھ یہاں رہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","چنانچہ یعقوب سات بَرس تک راخلؔ کی خاطِر خدمت کرتے رہے لیکن راخلؔ کی مَحَبّت میں وہ سات بَرس اُنہیں سات دِن کے برابر مَعلُوم ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","تَب یعقوب نے لابنؔ سے کہا، ”مُجھے میری بیوی دے دیجئے تاکہ میں اُس کے پاس جاؤں کیونکہ خدمت کی میعاد پُوری ہو چُکی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","چنانچہ لابنؔ نے اُس جگہ کے سَب لوگوں کو جمع کیا اَور اُن کی ضیافت کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","لیکن جَب شام ہویٔی تو لابنؔ نے اَپنی بیٹی لِیاہؔ کو لے جا کر یعقوب کے سُپرد کیا اَور یعقوب لِیاہؔ کے پاس گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","اَور لابنؔ نے اَپنی خادِمہ زِلفہؔ کو اَپنی بیٹی لِیاہؔ کے سُپرد کر دیا تاکہ وہ لِیاہؔ کی خادِمہ بَن کر رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","جَب صُبح ہُوئی تو لِیاہؔ کو اَپنے یہاں پا کر یعقوب نے لابنؔ سے پُوچھا، ”یہ آپ نے میرے ساتھ کیا کیا ہے؟ کیا مَیں نے راخلؔ کی خاطِر آپ کی خدمت نہیں کی تھی؟ پھر آپ نے میرے ساتھ دھوکا کیوں کیا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","لابنؔ نے جَواب دیا، ”ہمارے یہاں یہ رِواج نہیں کہ بڑی بیٹی سے پہلے چُھوٹی بیٹی کی شادی کر دی جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","اِس بیٹی کا ہفتہ عرُوسی پُورا کرو تَب ہم چُھوٹی بھی تُمہیں دے دیں گے لیکن تُمہیں اُس کے عِوض مزید سات بَرس اَور خدمت کرنی ہوگی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","اَور یعقوب نے اَیسا ہی کیا۔ آپ نے لِیاہؔ کے ساتھ ایک ہفتہ پُورا کیا تَب لابنؔ نے اَپنی بیٹی راخلؔ بھی یعقوب سے بیاہ دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","لابنؔ نے اَپنی خادِمہ بِلہاہؔ کو اَپنی بیٹی راخلؔ کے سُپرد کر دیا تاکہ وہ راخلؔ کی خادِمہ بَن کر رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","یعقوب راخلؔ کے پاس بھی گئے اَور وہ راخلؔ کو لِیاہؔ سے زِیادہ مَحَبّت کرتے تھے اَور آپ نے لابنؔ کی خدمت میں مزید سات بَرس گزارے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","جَب یَاہوِہ نے دیکھا کہ لِیاہؔ یعقوب کی مَحَبّت سے محروم ہے تو یَاہوِہ نے لِیاہؔ کا رِحم کھولا لیکن راخلؔ بانجھ رہی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","لِیاہؔ حاملہ ہُوئی اَور اُن کے یہاں بیٹا پیدا ہُوا۔ اُس نے اُس کا نام رُوبِنؔ رکھا کیونکہ اُس نے کہا، ”یہ اِس لیٔے ہُوا کہ یَاہوِہ نے میرا دُکھ دیکھ لیا ہے، اَور اَب یقیناً میرے خَاوند مُجھ سے مَحَبّت کرنے لگیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","وہ دوبارہ حاملہ ہُوئی اَور جَب اُس کے یہاں بیٹا پیدا ہُوا تو اُس نے کہا، ”چونکہ یَاہوِہ نے سُنا کہ مُجھ سے پیار نہیں کیا جا رہاہے اِس لیٔے اُنہُوں نے مُجھے یہ بیٹا بھی بخشا۔“ چنانچہ اُس نے اُس کا نام شمعُونؔ رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","وہ پھر حاملہ ہو گئی اَور جَب اُس کے یہاں بیٹا پیدا ہُوا تَب اُس نے کہا، ”آخِرکار اَب تو میرے خَاوند کو مُجھ سے اُنس ہوگا کیونکہ اُس سے میرے تین بیٹے پیدا ہویٔے۔“ چنانچہ اُس کا نام لیوی رکھا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","وہ پھر حاملہ ہو گئی اَور جَب اُس کے یہاں بیٹا پیدا ہُوا تَب اُس نے کہا، ”اَب کی بار مَیں یَاہوِہ کی تمجید کروں گی۔“ لہٰذا اُس نے اُس کا نام بنی یہُوداہؔ رکھا۔ اُس کے بعد اُس کے یہاں کویٔی اَولاد نہ ہُوئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","جَب راخلؔ نے دیکھا کہ یعقوب سے اُن کے یہاں کویٔی اَولاد نہیں ہو رہی ہے تو وہ اَپنی بہن پر حَسد کرنے لگی۔ چنانچہ اُس نے یعقوب سے کہا، ”مُجھے اَولاد دیجئے ورنہ میں مَر جاؤں گی!“ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","یعقوب راخلؔ پر خفا ہوکر چِلّائے اَور کہا، ”کیا میں خُدا کی جگہ ہُوں جِس نے تُمہیں اَولاد سے محروم رکھا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","تَب راخلؔ نے کہا، ”دیکھو، میری خادِمہ بِلہاہؔ حاضِر ہے، اُس کے پاس جاؤ تاکہ میرے لیٔے اُس سے اَولاد ہو اَور اُس کے ذریعہ میں بھی ایک خاندان قائِم کر سکوں گی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","چنانچہ اُس نے اَپنی خادِمہ بِلہاہؔ کو یعقوب کو دیا تاکہ وہ اُس کی بیوی بنے اَور یعقوب اُس کے پاس گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","اَور بِلہاہؔ حاملہ ہُوئی اَور یعقوب سے اُس کے یہاں بیٹا پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","تَب راخلؔ نے کہا، ”خُدا نے میری لاج رکھی اُس نے میری فریاد سُنی اَور مُجھے بیٹا بخشا۔“ لہٰذا اُس نے اُس کا نام دانؔ رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","راخلؔ کی خادِمہ بِلہاہؔ پھر حاملہ ہُوئی اَور یعقوب سے اُسے دُوسرا بیٹا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","تَب راخلؔ نے کہا، ”مُجھ میں اَور میری بہن میں بڑی کشمش جاری تھی لیکن مَیں نے فتح پائی۔“ لہٰذا اُس نے اُس بیٹے کا نام نفتالی رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","جَب لِیاہؔ نے دیکھا کہ آئندہ اُس کے اَولاد نہیں ہوگی تو اُس نے اَپنی خادِمہ زِلفہؔ کو یعقوب کو دے دیا کہ اُس کی بیوی بنے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","لِیاہؔ کی خادِمہ زِلفہؔ کے یعقوب سے بیٹا پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","تَب لِیاہؔ نے کہا، ”زہے قِسمت!“ لہٰذا اُس نے اُس بیٹے کا نام گادؔ رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","لِیاہؔ کی خادِمہ زِلفہؔ کو یعقوب سے دُوسرا بیٹا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","تَب لِیاہؔ نے کہا، ”میں کِس قدر مُبارک ہُوں! عورتیں مُجھے مُبارک کہیں گی۔“ لہٰذا اُس نے اُس بیٹے کا نام آشیر رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","گیہُوں کی فصل کی کٹائی کے دِن تھے۔ رُوبِنؔ کھیتوں میں نکل گیا جہاں اُس نے دُدائیم اُگی ہُوئی دیکھی۔ وہ اُس میں سے کچھ اَپنی ماں لِیاہؔ کے پاس لے آیا۔ راخلؔ نے لِیاہؔ سے کہا، ”اَپنے بیٹے کی دُدائیم میں سے کچھ مُجھے بھی دے دو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","لیکن لِیاہؔ نے اُس سے کہا، ”کیا یہ کافی نہیں کہ تُم نے میرے خَاوند کو لے لیا؟ اَب کیا میرے بیٹے کی دُدائیم بھی لینا چاہتی ہو؟“ راخلؔ نے کہا، ”بہت خُوب، تمہارے بیٹے کی دُدائیم کے عِوض وہ آج رات تمہارے پاس آسکتا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","اُس شام جَب یعقوب کھیتوں پر سے واپس لَوٹے تو لِیاہؔ اُن سے مِلنے کو نکل گئی اَور کہا، ”آج رات آپ کو میرے پاس آنا ہوگا کیونکہ مَیں نے اَپنے بیٹے کی دُدائیم کے عِوض آپ کو اُجرت پر لیا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","خُدا نے لِیاہؔ کی سُنی اَور وہ حاملہ ہُوئی اَور یعقوب سے اُس کے پانچواں بیٹا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","تَب لِیاہؔ نے کہا، ”خُدا نے مُجھے اَپنی خادِمہ اَپنے خَاوند کو دینے کے سبب سے اجر دیا۔“ اَور اُس نے اُس کا نام یِسَّکاؔر رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","لِیاہؔ پھر حاملہ ہُوئی اَور یعقوب سے اُسے چھٹا بیٹا پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","تَب لِیاہؔ نے کہا، ”خُدا نے مُجھے بیش بہا تحفہ عنایت کیا ہے۔ اَب کی بار میرا خَاوند میرے ساتھ عِزّت سے پیش آئے گا کیونکہ میرے یہاں اُس سے چھ بیٹے ہو چُکے ہیں۔“ اِس لیٔے اُس نے اُس کا نام زبُولُون رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","کچھ عرصہ کے بعد اُس کے یہاں ایک بیٹی پیدا ہُوئی اَور اُس نے اُس کا نام دینؔہ رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","تَب خُدا نے راخلؔ کو یاد کیا۔ اُس نے راخلؔ کی سُنی اَور اُس کا رِحم کھول دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","وہ حاملہ ہُوئی اَور اُس کے یہاں بیٹا پیدا ہُوا۔ وہ کہنے لگی، ”خُدا نے میری رُسوائی دُور کی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","اُس نے اُس کا نام یُوسیفؔ رکھا اَور کہا، ”یَاہوِہ میرے بیٹوں میں ایک اَور کا اِضافہ کرے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","جَب راخلؔ کے یہاں یُوسیفؔ پیدا ہُوا تو یعقوب نے لابنؔ سے کہا، ”مُجھے رخصت کر دیجئے تاکہ میں اَپنے وطن لَوٹ جاؤں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","مُجھے میری بیویاں اَور بچّے بھی دے دیجئے جِن کی خاطِر مَیں نے آپ کی خدمت کی اَور مَیں اَپنی راہ لُوں گا۔ آپ تو جانتے ہیں کہ مَیں نے آپ کے لیٔے کتنی زحمت اُٹھائی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","لیکن لابنؔ نے یعقوب سے کہا، ”اگر مُجھ پر تمہاری مہربانی ہو تو تُم یہیں رہو کیونکہ مَیں نے غیب سے جاناہے کہ یَاہوِہ نے تمہارے سبب سے مُجھے برکت بخشی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","لابنؔ نے مزید کہا، ”بتاؤ میری خدمت کے بدلے تمہاری اُجرت کیا ہوگی؟ مَیں تمہاری اُجرت بھی اَدا کرتا رہُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","یعقوب نے لابنؔ سے کہا، ”آپ خُود جانتے ہو کہ مَیں نے آپ کی کیسی خدمت کی اَور آپ کے مویشی میری نِگرانی میں کیسے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","میرے آنے سے پہلے جو تھوڑے سے تھے اَب کتنے بڑھ گیٔے ہیں اَور جہاں کہیں میرے قدم پہُنچے وہاں یَاہوِہ نے آپ کو برکت بخشی لیکن اَب مُجھے اَپنے گھر والوں کا بندوبست بھی تو کرنا چاہیے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","لابنؔ نے پُوچھا، ”تمہاری اُجرت کیا ہوگی؟“ یعقوب نے جَواب دیا، ”مُجھے کچھ نہیں چاہیے لیکن اگر آپ میری خاطِر صِرف ایک کام کر دیں تو میں آپ کی بھیڑ بکریاں، چَراتا رہُوں گا اَور آپ کے گلّوں کی نگہبانی بھی کروں گا: ");
INSERT INTO urdoucv_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","مُجھے آج اِجازت دیجئے کہ مَیں بھیڑ بکریوں کے سبھی گلّوں میں جا کر اُن میں سے چتلی بھیڑیں کالے رنگ کے برّے، اَور چتلی بکریاں الگ کرلُوں وُہی میری اُجرت ہوں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","آئندہ جَب کبھی آپ مُجھے دی ہُوئی اُجرت کا حِساب لینا چاہو تو میری ایمانداری میری گواہ ہوگی یعنی اگر میرے پاس کویٔی بے داغ یا سفید بکری یا کویٔی سفید برّہ پایا جائے تو وہ چُرایا ہُوا سمجھا جائے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","لابنؔ نے کہا، ”مُجھے منظُور ہے۔ تمہارے کہنے کے مُطابق ہی ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","لابنؔ نے اُسی روز سَب دھاری دار اَور داغ دار بکروں اَور بکریوں کے برّوں یعنی اُن سَب کو جِن میں کچھ سفید رنگ تھا اَور کالے رنگ کے سارے برّوں کو الگ کرکے اَپنے بیٹوں کی نِگرانی میں دے دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","تَب اُنہُوں نے اَپنے اَور یعقوب کے گلّوں کے درمیان تین دِن کے سفر کا فاصلہ مُقرّر کیا جَب کہ یعقوب لابنؔ کے بقیّہ گلّوں کی پاسبانی کرتے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","اَور یعقوب نے سفیدہ بادام اَور چُنار کے درختوں کی ہری ہری شاخیں لے کر اُن کی چھال کو اِس طرح چھیلا کہ اَندر کی سفید لکڑی دِکھائی دینے لگی اَور شاخوں پر سفید دھاریں بَن گئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","تَب یعقوب نے وہ چھیلی ہُوئی شاخیں پانی کے تمام حوضوں میں اِس طرح سے رکھ دیں کہ جَب بھیڑیں اَور بکریاں پانی پینے کو آئیں تو وہ اُن کی نگاہ کے ٹھیک سامنے ہُوں۔ جَب بھیڑ بکریاں، گابھن ہونے کی حالت میں ہوتیں اَور پانی پینے آتی تھیں ");
INSERT INTO urdoucv_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","تو وہ اُن شاخوں کے سامنے بکریاں گابھن ہو جاتیں اَور اَیسے بچّے دیتیں جو دھاری دار یا چتلے ہوتے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","یعقوب نے بھیڑ بکریوں کے بچّوں کو الگ کیا لیکن لابنؔ کے باقی بچے جانوروں کے مُنہ دھاری دار اَور کالے جانوروں کی طرف کر دئیے۔ اِس طرح یعقوب نے اَپنی بھیڑ بکریوں کو الگ کر دیا اَور اُنہیں لابنؔ کے گلّوں میں مِلنے نہ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","جَب بھی طاقتور بھیڑیں اَور بکریاں گابھن ہونے کی حالت میں ہوتیں تو یعقوب وہ دھاری دار شاخیں پانی کے حوضوں میں اُن کے سامنے رکھتے تاکہ وہ اُن شاخوں کے سامنے گابھن ہو جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","لیکن اگر بھیڑ بکریاں کمزور ہوتے تو وہ اُنہیں وہاں نہ رکھتے۔ اِس طرح کمزور جانور لابنؔ کے اَور طاقتور جانور یعقوب کے حِصّہ میں آتے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","اِس طرح سے یعقوب نہایت برومند ہویٔے اَور بہت سے گلّوں، خادِموں، خادِماؤں، اُونٹوں اَور گدھوں کے مالک بَن گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","یعقوب نے سُنا کہ لابنؔ کے بیٹے کہہ رہے ہیں، ”یعقوب نے ہمارے باپ کا سَب کچھ لے لیا ہے اَورجو کچھ ہمارے باپ کا تھا اُسی مِلکیّت میں سے لے لے کر یہ سَب شان و شوکت حاصل کی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","اَور یعقوب نے دیکھا کہ اَب لابنؔ کا رویّہ پہلے جَیسا نہ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","تَب یَاہوِہ نے یعقوب سے فرمایا، ”تُم اَپنے آباؤاَجداد کے مُلک کو اَور اَپنے رشتہ داروں کے پاس لَوٹ جاؤ اَور مَیں تمہارے ساتھ رہُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","تَب یعقوب نے راخلؔ اَور لِیاہؔ کو خبر بھیجی کہ وہ اُن کھیتوں میں چلی آئیں جہاں اُس کے گلّے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","اُنہُوں نے اُن سے کہا، ”میں دیکھ رہا ہُوں کہ تمہارے باپ کا رویّہ میرے ساتھ پہلے جَیسا نہیں رہا۔ لیکن میرے باپ کے خُدا نے میرا ساتھ دیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","تُم تو جانتی ہو کہ مَیں نے کتنی محنت سے تمہارے باپ کی خدمت کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","تو بھی تمہارے باپ نے دس بار میری مزدُوری بدل کر مُجھ سے فریب کیا لیکن خُدا نے اُن سے مُجھے نُقصان نہیں پہُنچنے دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","اگر اُنہُوں نے کہا، ’چتلے بچّے تمہاری اُجرت ہوں گے،‘ تو ساری بھیڑ بکریاں، چتلے بچّے دیتی تھیں؛ اَور اگر وہ کہتے، ’دھاری دار بچّے تمہاری اُجرت ہوں گے،‘ تو سَب بھیڑ بکریاں، دھاری دار بچّے جنتی تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","چنانچہ خُدا نے تمہارے باپ کی بھیڑ بکریاں، لے کر مُجھے دے دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","”ایک بار مَیں نے ریوڑ کے نر و مادہ کے مِلاپ کے دِنوں میں ایک خواب دیکھا کہ جو بکرے بکریوں سے مِل رہے ہیں وہ دھاری دار، چتلے یا داغ دار ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","خُدا کے فرشتہ نے خواب میں مُجھ سے کہا، ’اَے یعقوب،‘ مَیں نے جَواب دیا، ’مَیں حاضِر ہُوں؟‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","اَور فرشتہ نے کہا، ’یعقوب آنکھ اُٹھاکر دیکھو کہ جو بکرے بکریوں سے میل کر رہے ہیں وہ دھاری دار، چتلے اَور داغ دار ہیں کیونکہ لابنؔ نے جو کچھ تمہارے ساتھ کیا اُسے میں دیکھ چُکا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","میں اُسی بیت ایل کا خُدا ہُوں جہاں تُم نے سُتون پر تیل کا مَسح کیا تھا اَور میری مَنّت مانی تھی؛ اَب اِس مُلک کو فوراً چھوڑ دو اَور اَپنے وطن لَوٹ جاؤ۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","تَب راخلؔ اَور لِیاہؔ نے جَواب دیا، ”کیا اَب بھی ہمارے باپ کی جائداد میں ہمارا کویٔی حِصّہ یا مِیراث باقی ہے؟ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","کیا ہم اُن کی نظر میں پردیسی تو نہیں؟ اُنہُوں نے ہمیں نہ صِرف بیچ ہی دیا بَلکہ جو کچھ ہمارے عِوض قیمت اَدا کی گئی اُسے بھی اِستعمال کر لیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","سچ تو یہ ہے کہ جو دولت خُدا نے ہمارے باپ سے چھین لی وہ سَب ہماری اَور ہمارے بچّوں کی ہے۔ چنانچہ آپ وُہی کرو جو خُدا نے آپ سے فرمایاہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","تَب یعقوب نے بچّوں اَور اَپنی بیویوں کو اُونٹوں پر سوار کیا، ");
INSERT INTO urdoucv_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","اَور یعقوب نے اَپنے سَب مویشیوں اَور اُس مال و اَسباب سمیت جو یعقوب نے فدّان ارام میں جمع کیا تھا اَپنے آگے آگے روانہ کیا تاکہ مُلکِ کنعانؔ میں اَپنے باپ اِصحاقؔ کے پاس جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","جَب لابنؔ اَپنے بھیڑوں کی پشم کترنے گئے تو راخلؔ نے اَپنے باپ کے خانگی معبُود چُرا لیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","مزید یہ کہ یعقوب نے بھی لابنؔ ارامی کے ساتھ فریب کیا؛ یعقوب نے لابنؔ کو اَپنے فرار ہونے کی خبر تک نہ دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","چنانچہ وہ اَپنا سَب کچھ لے کر فرار ہو گئے اَور دریا فراتؔ کو عبور کرکے گِلعادؔ کے کوہستانی مُلک کی طرف چلےگئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","تیسرے دِن لابنؔ کو خبر ہُوئی کہ یعقوب فرار ہو گئے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","چنانچہ لابنؔ نے رشتہ داروں کو ساتھ لے کر اَور سات دِن کے تعاقب کے بعد گِلعادؔ کے پہاڑی مُلک میں اُن کو جا لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","تَب رات کو خُدا لابنؔ ارامی کے پاس خواب میں آئے اَور اُس سے کہا، ”خبردار تُم یعقوب کو بھلا یا بُرا کچھ مت کہنا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","یعقوب گِلعادؔ کے پہاڑی مُلک میں خیمہ زن تھے کہ لابنؔ وہاں پہُنچ گئے اَور لابنؔ اَور اُن کے رشتہ دار بھی وہیں خیمہ زن ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","تَب لابنؔ نے یعقوب سے کہا، ”یہ تُم نے کیا کیا؟ تُم نے مُجھ سے دھوکا کیا اَور میری بیٹیوں کو مالِ غنیمت سمجھ کر فرار ہو رہے ہو جَیسے جنگی قَیدی تلوار کی دہشت میں پکڑے جاتے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","تُم نے خُفیہ طریقے سے فرار ہوکر مُجھ سے فریب کیوں کیا؟ مُجھے کیوں نہیں بتایا؟ اگر بتایا ہوتا تو میں تُمہیں خُوشی خُوشی دف اَور سِتار جَیسے سازوں کے ساتھ گاتے بجاتے ہویٔے رخصت کرتا؟ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","تُم نے مُجھے میرے نواسوں اَور میری بیٹیوں کو اُن کی رخصت کے وقت چُومنے کا موقع بھی نہ دیا۔ تُم نے بڑی بیہودہ حرکت کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","مُجھ میں اِتنی قُدرت ہے کہ تُمہیں برباد کر ڈالوں لیکن رات کو تمہارے باپ کے خُدا نے مُجھ سے کہا، ’خبردار یعقوب کو بھلا یا بُرا کچھ مت کہنا۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","مانا کہ تُم اَپنے باپ کے گھر لَوٹنے کے مُشتاق تھے اِس لیٔے چلے آئے لیکن تُم نے میرے معبُود کیوں چُرا لیٔے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","یعقوب نے لابنؔ کو جَواب دیا، ”مُجھے ڈر تھا کہ تُم اَپنی بیٹیوں کو مُجھ سے زبردستی چھین نہ لو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","البتّہ جِس کسی کے پاس تمہارے معبُود نکلیں وہ زندہ نہ بچے گا۔ ہمارے رشتہ داروں کی مَوجُودگی میں تُم خُود دیکھ لوگے کہ میرے سامان مَیں تمہاری کویٔی چیز تو نہیں۔ اَور اگر ہو تو تُم اُسے لے لو۔“ یعقوب کو مَعلُوم نہ تھا کہ راخلؔ وہ معبُود چُرا لائی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","چنانچہ لابنؔ نے یعقوب اَور لِیاہؔ اَور دونوں خادِماؤں کے خیموں کی تلاشی لی لیکن اُنہیں کچھ نہ مِلا۔ لِیاہؔ کے خیمہ سے نکل کر وہ راخلؔ کے خیمہ میں داخل ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","راخلؔ نے پہلے ہی اُن خانگی معبُودوں کو لے کر اَپنے اُونٹ کی زین میں رکھ دیا تھا اَور اُن پر بیٹھ گئی تھی۔ لابنؔ نے خیمہ کا کونہ کونہ چھان مارا لیکن اُنہیں کچھ نہ مِلا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","راخلؔ نے اَپنے باپ سے کہا، ”میرے آقا، تُم اِس بات پر ناراض نہ ہونا کہ مَیں تمہارے سامنے اُٹھ نہیں سکتی کیونکہ مَیں حیض سے ہُوں۔“ چنانچہ تلاشی کے باوُجُود بھی لابنؔ کو اُس کے خانگی معبُود نہ ملے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","یعقوب کو بڑا غُصّہ آیا۔ یعقوب نے لابنؔ کو ملامت کی اَور اُن سے پُوچھا، ”میرا جُرم کیا ہے؟“ مَیں نے کون سا گُناہ کیا ہے جو تُم میرے تعاقب میں یہاں آ پہُنچے؟ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","اَب جَب آپ نے میرے سارے مال و اَسباب کی تلاشی لے لی تو آپ نے اَپنے گھر کی کون سِی چیز پائی؟ اگر کچھ مِلا ہو تو اُسے یہاں اَپنے اَور میرے رشتہ داروں کے سامنے رکھئے اَور ہم دونوں کے درمیان ہمارا اِنصاف کرنے دیجئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","”پچھلے بیس بَرس سے اَب تک میں آپ کے ساتھ رہا ہُوں اُس دَوران نہ تو کبھی آپ کی بھیڑوں اَور بکریوں کے بچّے ضائع ہویٔے اَور نہ ہی مَیں نے آپ کے گلّوں کے مینڈھوں کا گوشت کھایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","میں آپ کے پاس کبھی اَیسے جانور لے کر نہیں آیا جنہیں درندوں نے پھاڑ ڈالا ہو، وہ نُقصان مَیں نے ہی برداشت کیا۔ جو جانور دِن یا رات کو چوری جاتا تھا اُس کی قیمت بھی آپ نے مُجھ ہی سے طلب کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","میرا حال تو اَیسا تھا کہ دِن کو گرمی اَور رات کو سردی مُجھے نڈھال کردیتی تھی اَور میری راتوں کی نیند حرام ہو گئی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","بیس سال تک جَب کہ میں آپ کے گھر میں رہا میری یہی حالت رہی۔ مَیں نے چودہ بَرس تک آپ کی دو بیٹیوں کی خاطِر اَور چھ بَرس تک آپ کے گلّوں کی خاطِر آپ کی خدمت کی اَور اُس دَوران آپ نے دس بار میری مزدُوری بدلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","اگر میرے باپ اَبراہامؔ کے خُدا اَور میرے باپ اِصحاقؔ کا خوف میرے ساتھ نہ ہوتا تو آپ یقیناً مُجھے خالی ہاتھ روانہ کرتے۔ لیکن خُدا نے میری مُصیبت اَور میرے ہاتھوں کی محنت کو دیکھاہے اَور کل رات آپ پر ظاہر ہوکر آپ کو تنبیہ بھی کی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","لابنؔ نے یعقوب کو جَواب دیا، ”یہ عورتیں میری بیٹیاں ہیں اَور یہ بچّے میرے بچّے ہیں اَور یہ گلّے میرے گلّے ہیں۔ جو کچھ تُمہیں نظر آتا ہے سَب میرا ہے۔ پھر بھی آج مَیں اَپنی اِن بیٹیوں یا اِن بچّوں کے لیٔے جو اُن سے ہویٔے کیا کر سَکتا ہُوں؟ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","اَب آؤ تُم اَور مَیں آپَس میں ایک عہد کریں جِس کی حیثیت ہمارے درمیان گواہ کی سِی ہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","چنانچہ یعقوب نے ایک پتّھر لیا اَور اُسے سُتون کے طور پر کھڑا کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","اَور یعقوب نے رشتہ داروں سے کہا، ”چند پتّھر جمع کرو۔“ چنانچہ اُنہُوں نے پتّھر جمع کرکے ڈھیر لگا دیا اَور پھر اُس ڈھیر کے پاس ہی بیٹھ کر کھانا کھایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","لابنؔ نے اُس کا نام یگرساہدُو تھا اَور یعقوب نے گِلعادؔ رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","لابنؔ نے کہا، ”آج کے دِن یہ ڈھیر تمہارے اَور میرے درمیان گواہ ہے۔“ اِسی لیٔے اِس کا نام گِلعادؔ رکھا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","اِسے مِصفاہؔ بھی کہا گیا کیونکہ لابنؔ نے کہا، ”جَب ہم ایک دُوسرے سے دُور ہُوں تو یَاہوِہ تمہارا اَور میرا نگہبان ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","اگر تُم میری بیٹیوں کو دُکھ پہُنچاؤ یا اُن کے علاوہ اَور عورتوں سے بیاہ کرو تو اگرچہ کویٔی آدمی ہمارے ساتھ نہیں لیکن یاد رہے کہ خُدا تمہارے اَور میرے درمیان گواہ ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","لابنؔ نے یعقوب سے یہ بھی کہا، ”اِس ڈھیر کو دیکھو اَور اِس سُتون کو دیکھو جنہیں مَیں نے تمہارے اَور اَپنے درمیان کھڑا کیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","یہ ڈھیر گواہ ہے اَور یہ سُتون گواہ ہے کہ تُمہیں ضرر پہُنچانے کے لیٔے نہ تو میں اِس ڈھیر سے آگے تمہاری طرف قدم بڑھاؤں گا اَور نہ تُم مُجھے ضرر پہُنچانے کے لیٔے اِس ڈھیر اَور سُتون سے آگے میری طرف قدم بڑھاؤگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","اَبراہامؔ کا خُدا اَور ناحوؔر کا خُدا اَور اُن کے باپ کا خُدا ہمارے درمیان اِنصاف کرے۔“ اَور یعقوب نے اَپنے باپ اِصحاقؔ کے خوف سے قادرمُطلق خُدا کی قَسم کھائی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","اَور یعقوب نے اُس پہاڑی مقام پر قُربانی گزرانی اَور اَپنے رشتہ داروں کو کھانے پر مدعو کیا۔ اُنہُوں نے کھانا کھایا اَور رات وہیں گزاری۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","اگلے دِن صُبح سویرے لابنؔ نے اَپنے بیٹیوں کو نواسیوں اَور نواسوں کو چُوما اَور اُنہیں برکت دے کر روانہ ہو گئے اَور اَپنے گھر واپس ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","تَب یعقوب نے بھی اَپنی راہ لی اَور خُدا کے فرشتے اُن سے مِلنے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","جَب یعقوب نے اُنہیں دیکھا تو کہا، ”یہ خُدا کی چھاؤنی ہے!“ اَور اُس مقام کا نام محنایمؔ رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","تَب یعقوب نے اَپنے آگے اِدُوم کے مُلک میں جو سِعِیؔر کی سرزمین میں ہے اَپنے بھایٔی عیسَوؔ کے پاس قاصِد روانہ کئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","اُن کو ہدایات دیں: ”تُم میرے آقا عیسَوؔ سے یُوں کہنا، ’تمہارا خادِم یعقوب کہتاہے میں لابنؔ کے ہاں مُقیم تھا اَور اَب تک وہیں رہا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","میرے پاس مویشی اَور گدھے، بھیڑیں اَور بکریاں، خادِم اَور خادِمائیں ہیں۔ اَب اَے میرے آقا! یہ پیغام تمہارے پاس اِس لیٔے بھیج رہا ہُوں کہ مُجھ پر تمہاری نظرِکرم ہو۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","جَب وہ قاصِد لَوٹ کر یعقوب کے پاس آئے تو کہنے لگے، ”ہم آپ کے بھایٔی عیسَوؔ کے پاس گیٔے تھے اَور اَب وہ آپ سے مِلنے آ رہے ہیں اَور چار سَو آدمی اُن کے ساتھ ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","تَب یعقوب نہایت خوفزدہ اَور پریشان ہویٔے۔ اُنہُوں نے اَپنے ساتھ کے لوگوں، بھیڑ بکریوں، مویشیوں، گلّوں اَور اُونٹوں کو دو غولوں میں تقسیم کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","اَور یہ سوچا، ”کہ اگر عیسَوؔ آکر ایک غول پر حملہ کرےگا تو دُوسرا غول تو عیسَوؔ کے ہاتھ سے بچ نکلے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","تَب یعقوب نے دعا کی، ”اَے یَاہوِہ، میرے باپ اَبراہامؔ کے خُدا اَور میرے باپ اِصحاقؔ کے خُدا، آپ نے مُجھ سے کہا، ’اَپنے مُلک اَور اَپنے رشتہ داروں میں واپس چلا جاؤں اَور مَیں تُمہیں برومند کروں گا،‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","آپ نے اَپنے خادِم کے ساتھ جو مہربانی اَور وفاداری جتائی میں اُس کے لائق نہیں۔ جَب مَیں نے اِس یردنؔ کو عبور کیا تھا تَب میرے پاس صِرف میرا عصا تھا اَور اَب مَیں دو خیموں میں بٹ چُکا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","میری یہ اِلتجا ہے کہ مُجھے اَپنے بھایٔی عیسَوؔ کے ہاتھ سے بچا لیجئے کیونکہ مُجھے خوف ہے کہ وہ آکر مُجھے اَور اِن ماؤں کو اُن کے بچّوں سمیت مار ڈالے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","لیکن آپ نے کہا، ’میں یقیناً تُمہیں برومند کروں گا اَور مَیں تمہاری نَسل کو سمُندر کے کنارے کی ریت کی مانند بڑھاؤں گا جو شُمار سے باہر ہوگی۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","یعقوب نے رات وہیں گزاری، اَورجو کچھ اُن کے پاس تھا اُس میں سے اَپنے بھایٔی عیسَوؔ کے لیٔے یہ تحفہ مُنتخب کیا: ");
INSERT INTO urdoucv_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","دو سَو بکریاں اَور بیس بکرے، دو سَو بھیڑیں اَور بیس مینڈھے، ");
INSERT INTO urdoucv_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","تیس اُونٹنیاں اَور اُن کے بچّے، چالیس گائیں اَور دس بَیل اَور تیس گدھیاں اَور دس گدھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","یعقوب نے ہر گلّہ کو الگ الگ اَپنے خادِموں کے سُپرد کیا، اَور اُن سے کہا، ”مُجھ سے آگے نکل جاؤ اَور ایک گلّے کو دُوسرے سے جُدا رکھنا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","یعقوب نے سَب سے آگے والے خادِم کو ہدایت دی: ”جَب میرا بھایٔی عیسَوؔ تُم سے ملے اَور تُم سے پُوچھے، ’تُم کِس کے خادِم ہو اَور کہاں جا رہے ہو اَور یہ سَب جانور جو تمہارے آگے آگے ہیں کِس کے ہیں؟‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","تَب تُم عیسَوؔ سے کہنا، ’یہ تمہارے خادِم یعقوب کے ہیں اَور اُن کے آقا عیسَوؔ کو بطور تحفہ بھیجے گیٔے ہیں اَور وہ خُود بھی ہمارے پیچھے پیچھے آ رہے ہیں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","یعقوب نے دُوسرے، تیسرے اَور باقی سَب خادِموں کو بھی جو گلّوں کے پیچھے چل رہے تھے ہدایت کی: ”تُم بھی جَب عیسَوؔ سے مِلو تو یہی کہنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","اَور یہ ضروُر کہنا، ’آپ کے خادِم یعقوب بھی ہمارے پیچھے پیچھے آ رہے ہیں۔‘ “ کیونکہ یعقوب نے سوچا، ”اِن تحفوں سے جنہیں میں اَپنے آگے بھیج رہا ہُوں، عیسَوؔ کے غُصّہ کو ٹھنڈا کر دُوں گا تاکہ بعد میں جَب مَیں اُن کے سامنے آؤں تو شاید وہ مُجھے قبُول کر لیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","چنانچہ یعقوب کے تحفے لے کر آگے بڑھ گیٔے، لیکن یعقوب نے وہ رات اَپنے ہی خیمے میں گزاری۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","اُس رات یعقوب اُٹھے اَور اَپنی دو بیویوں اَپنی دو خادِماؤں اَور اَپنے گیارہ بیٹوں کو لے کر اُنہیں یبّوقؔ کے گھاٹ کے پار اُتارا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","اُنہیں یردنؔ کے اُس پار بھیجنے کے بعد اَپنا سَب مال و اَسباب بھی بھیج دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","تَب یعقوب تنہا رہ گئے اَور ایک آدمی پَو پھٹنے تک اُن سے کُشتی لڑتا رہا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","جَب اُس آدمی نے دیکھا کہ وہ یعقوب پر غالب نہیں آسکتا تو اُس نے یعقوب کی ران کے جوڑ کو اَیسا چھُوا کہ اُس آدمی سے کُشتی لڑتے لڑتے اُن کی نس چڑھ گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","تَب اُس آدمی نے کہا، ”مُجھے جانے دے کیونکہ اَب پَو پھٹنے کو ہے۔“ لیکن یعقوب نے جَواب دیا، ”جَب تک آپ مُجھے برکت نہ دیں مَیں آپ کو جانے نہیں دُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","تَب اُس آدمی نے پُوچھا، ”تمہارا نام کیا ہے؟“ اُنہُوں نے جَواب دیا، ”یعقوب۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","تَب اُس آدمی نے کہا، ”اَب سے تمہارا نام یعقوب نہیں بَلکہ اِسرائیل ہوگا کیونکہ تُم نے خُدا اَور آدمیوں کے ساتھ زورآزمائی کی اَور غالب ہُوئے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","تَب یعقوب نے کہا، ”براہِ کرم مُجھے اَپنا نام بتائیے۔“ لیکن اُس نے جَواب دیا، ”تُمہیں میرے نام سے کیا مطلب؟“ اَور اُس نے وہاں یعقوب کو برکت دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","چنانچہ یعقوب نے اُس مقام کا نام یہ کہتے ہویٔے پنی ایل رکھا، ”مَیں نے خُدا کو رُوبرو دیکھا، تو بھی میری جان سلامت رہی!“ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","جَب وہ پنی ایل یعنی پینو ایل سے چلے تو سُورج نکل چُکاتھا اَور وہ اَپنی ران کی وجہ سے لنگڑا کر چل رہے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","اِسی لیٔے بنی اِسرائیل اُس نس کو جو ران کے جوڑ سے جڑی ہوتی ہے آج تک نہیں کھاتے کیونکہ اُس آدمی نے یعقوب کی ران کے جوڑ کی اُسی نس کے پاس چھُوا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","یعقوب نے نگاہ اُٹھائی اَور دیکھا کہ عیسَوؔ اَپنے چار سَو آدمیوں کے ساتھ آ رہے ہیں۔ تَب یعقوب نے اَپنے بچّوں کو لِیاہؔ راخلؔ اَور دونوں خادِماؤں کے درمیان بانٹ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","اُنہُوں نے خادِماؤں اَور اُن کے بچّوں کو سَب سے آگے، لِیاہؔ اَور اُن کے بچّوں کو اُن کے پیچھے اَور راخلؔ اَور یُوسیفؔ کو سَب سے پیچھے رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","وہ خُود اُن کے آگے آگے چلے اَور اَپنے بھایٔی تک پہُنچتے پہُنچتے سات بار زمین پر سَجدہ کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","لیکن عیسَوؔ دَوڑکر اَپنے بھایٔی یعقوب سے مِلنے کو دَوڑے اَور اُن سے بغل گیر ہوکر یعقوب کو چُوما اَور وہ دونوں رو پڑے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","تَب عیسَوؔ نے نگاہ اُٹھاکر عورتوں اَور بچّوں کو دیکھا اَور پُوچھا، ”یہ تمہارے ساتھ کون ہیں؟“ یعقوب نے جَواب دیا، ”یہ وہ بچّے ہیں جو خُدا نے اَپنی مہربانی سے تمہارے خادِم کو عنایت کئے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","تَب خادِماؤں نے اَپنے بچّوں کے ساتھ آگے آکر عیسَوؔ کو جھُک کر سلام کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","اُن کے بعد لِیاہؔ اَور اُس کے بچّے آئے اَور اُنہُوں نے بھی جھُک کر سلام کیا۔ اَور سَب کے آخِر میں یُوسیفؔ اَور راخلؔ آئے اَور اُنہُوں نے بھی جھُک کر سلام کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","عیسَوؔ نے پُوچھا، ”اِن سَب گائے، بَیل سے جو مُجھے ملے، تمہارا کیا مطلب ہے؟“ یعقوب نے کہا، ”میرے آقا، وہ اِس لیٔے ہیں کہ آپ کی مہربانی مُجھ پر ہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","لیکن عیسَوؔ نے کہا، ”نہیں میرے بھایٔی میرے پاس تو پہلے ہی بہت کچھ ہے لہٰذا جو تمہارا ہے وہ تُم اَپنے پاس ہی رکھو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","یعقوب نے کہا، ”نہیں نہیں! اگر مُجھ پر آپ کی نظرِ عنایت ہے تو میری طرف سے یہ تحفہ قبُول کیجئے کیونکہ تمہارا چہرہ دیکھنا خُدا کا چہرہ دیکھنے کی مانند ہے خصوصاً اَب جَب کہ آپ نے مہربانی سے میرا اِستِقبال کیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","براہِ مہربانی جو تحفہ آپ کے سامنے لایا گیا اُسے قبُول کیجئے کیونکہ خُدا کے فضل و کرم سے میرے پاس ضروُرت کا سارا سامان مَوجُود ہے۔“ اَور یعقوب کے اِصرار کرنے پر عیسَوؔ نے اُسے قبُول کر لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","تَب عیسَوؔ نے کہا، ”آؤ، ہم آگے چلیں اَور مَیں تمہارے ہمراہ چلُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","لیکن یعقوب نے عیسَوؔ سے کہا، ”میرے آقا کو مَعلُوم ہے کہ میرے بال بچّے نازک ہیں اَور مُجھے دُودھ پِلانے والی بھیڑ بکریوں اَور گایوں کا بھی خیال رکھنا ضروُری ہے۔ اگر اُنہیں ایک دِن بھی حد سے زِیادہ ہانکا گیا تو سَب جانور مَر جایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","لہٰذا میری درخواست ہے کہ میرا آقا اَپنے خادِم سے پیشتر روانہ ہو جائے اَور مَیں اَپنے آگے چلنے والے چَوپایوں اَور بچّوں کی رفتار کے مُطابق آہستہ آہستہ چلتا ہُوا اَپنے آقا کے پاس سِعِیؔر میں آ جاؤں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","عیسَوؔ نے کہا، ”اَچھّا میں اَپنے لوگوں میں سے چند کو تمہارے پاس چھوڑے جاتا ہُوں۔“ یعقوب نے کہا، ”اِس کی کیا ضروُرت ہے؟ بس میرے آقا کی مہربانی مُجھ پر ہے یہی بہت ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","چنانچہ اُسی روز عیسَوؔ سِعِیؔر کے لیٔے روانہ ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","البتّہ یعقوب سُکّوتؔ چلےگئے اَور وہاں اُنہُوں نے اَپنے لیٔے ایک رہنے کے لئے ایک گھر اَور اَپنے مویشیوں کے لیٔے جھونپڑے بنائے۔ اِسی وجہ سے اُس مقام کا نام سُکّوتؔ پڑ گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","فدّان ارام سے آنے کے بعد یعقوب صحیح سلامت مُلکِ کنعانؔ میں شِکیمؔ کے شہر تک پہُنچے اَور شہر کے نزدیک ہی خیمہ زن ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","زمین کے جِس قَطعہ پر اُنہُوں نے اَپنا خیمہ نصب کیا، اُسے یعقوب نے شِکیمؔ کے باپ حمُورؔ کے بیٹوں سے چاندی کے سَو سِکّوں کے عِوض خرید لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","اَور وہاں یعقوب نے ایک مذبح بنا کر اُس کا نام ایل اِلُہِ اِسرائیل رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","اَور لِیاہؔ کی بیٹی دینؔہ جو یعقوب سے اُس کے یہاں پیدا ہوئی تھی اُس مُلک کی لڑکیوں کو دیکھنے نکلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","تَب اُس مُلک کے حاکم حِوّیؔ حمُورؔ کے بیٹے شِکیمؔ نے اُسے دیکھا اَور اُسے لے جا کر اُس کی عصمت دری کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","اُس کا دِل یعقوب کی بیٹی دینؔہ پر آ گیا اَور وہ اُس لڑکی سے مَحَبّت کرنے لگا اَور اُس سے میٹھی میٹھی باتیں کرنے لگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","اَور شِکیمؔ نے اَپنے باپ حمُورؔ سے کہا، ”میری شادی اِس لڑکی سے کرا دیجئے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","جَب یعقوب کو یہ بات مَعلُوم ہوئی کہ اُن کی بیٹی دینؔہ کو بےحُرمت کیا گیا ہے، جَب اُن کے بیٹے کھیتوں میں مویشیوں کے پاس تھے۔ لہٰذا وہ اُن کے گھر آنے تک خاموش رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","اَور شِکیمؔ کا باپ حمُورؔ یعقوب سے پاس مُلاقات کرنے کے لیٔے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","یعقوب کے بیٹوں نے جوں ہی یہ بات سُنی وہ اَپنے کھیتوں سے لَوٹے اَور سیدھے گھر پہُنچے۔ وہ نہایت رنجیدہ تھے اَور غُصّہ سے آگ بگُولہ ہو رہے تھے کیونکہ شِکیمؔ نے یعقوب کی بیٹی کی عصمت لُوٹ کر بنی اِسرائیل میں اَیسی شرمناک حرکت کی، جو نہ کی جانی چاہیے تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","لیکن حمُورؔ نے اُن سے کہا، ”میرا بیٹا شِکیمؔ تمہاری لڑکی کو دِل سے چاہتاہے لہٰذا براہِ کرم اُسے میرے بیٹے کے لئے بطور بیوی دے دیجئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ہمارے ساتھ آپَس میں شادی بیاہ کر لو۔ ہمیں اَپنی بیٹیاں دو اَور ہماری بیٹیاں اَپنے لیٔے لے لو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","تُم ہمارے درمیان بس جاؤ۔ یہ مُلک تمہارے لیٔے کھُلا ہے۔ اِس میں رہو تِجارت کرو اَور اُسی میں اَپنے لیٔے جائدادیں بناؤ۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","شِکیمؔ نے بھی دینؔہ کے باپ اَور بھائیوں سے کہا، ”اگر مُجھ پر تمہاری نظرِکرم ہو جائے تو جو کچھ تُم مانگوگے میں تُمہیں دے دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","دُلہن کا مَہر اَور جہیز جِس قدر بھی تُم چاہو طے کر لو اَورجو تُم کہو گے میں اَدا کروں گا۔ بس اُس لڑکی کو بطور دُلہن مُجھے دے دیجئے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","تَب یعقوب کے بیٹوں نے شِکیمؔ اَور اُس کے باپ حمُورؔ سے بات کرتے ہُوئے فریب سے جَواب دیا، چونکہ اُن کی بہن دینؔہ کو بےحُرمت کیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","اَور اُن سے کہا، ”ہم یہ نہیں کر سکتے ہم اَپنی بہن ایک نامختون آدمی کو نہیں دے سکتے۔ اِس میں ہماری رُسوائی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ہم صِرف ایک شرط پر راضی ہو سکتے ہیں: اَور وہ یہ ہے کہ تُم سَب مَردوں کا ختنہ کیا جائے، تاکہ تُم ہماری طرح ہو سکو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","تَب ہم اَپنی بیٹیاں تُمہیں دیں گے اَور تمہاری بیٹیاں اَپنے لیٔے لیں گے۔ اَور ہم تمہارے درمیان بسیں گے، اَور تمہارے ساتھ مِل کر ایک قوم بَن جایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","لیکن اگر تُم ختنہ کرانے پر راضی نہیں ہوتے، تو ہم اَپنی بہن کو لے کر چلے جایٔیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","اُن کی تجویز حمُورؔ اَور اُس کے بیٹے شِکیمؔ کو پسند آئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","اُس نوجوان نے، جو اَپنے باپ کے خاندان میں نہایت باعزّت سمجھا جاتا تھا اُن کے کہنے پر عَمل کرنے میں بالکُل تاخیر نہ کی، کیونکہ وہ یعقوب کی بیٹی کا بےحد مُشتاق تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","تَب حمُورؔ اَور اُس کا بیٹا شِکیمؔ اَپنے شہر کے پھاٹک پر اَپنے شہر والوں سے بات چیت کرنے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","اَور اُن سے کہنے لگے، ”یہ لوگ ہم سے دوستانہ تعلّقات رکھتے ہیں۔ اُنہیں اِس مُلک میں رہ کر تِجارت کرنے دو، اِس مُلک میں اُن کے لیٔے کافی جگہ ہے۔ ہم اُن کی بیٹیوں سے اَور وہ ہماری بیٹیوں سے بیاہ کر سکتے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","لیکن وہ لوگ صِرف اِس شرط پر ہم لوگوں کے ساتھ ایک قوم ہوکر رہنے پر راضی ہیں، ہمارے مَرد اَپنا ختنہ کروائیں، جَیسا اُن کا ہُواہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","کیا اُن کے مویشی، مال و اَسباب اَور سارے جانور ہمارے نہ ہو جایٔیں گے؟ اگر، ہم اَپنی رضامندی اُن پر ظاہر کر دیں تو وہ ہمارے درمیان بس جایٔیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","تَب سَب مَردوں نے جو شہر کے پھاٹک سے گزرا کرتے تھے، حمُورؔ اَور اُس کے بیٹے شِکیمؔ کی بات مان لی۔ اَور شہر کے پھاٹک سے گزرنے والے ہر مَرد کا ختنہ کیا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","تین دِن کے بعد، جَب وہ سَب ابھی درد میں مُبتلا تھے، یعقوب کے بیٹوں میں سے دینؔہ کے دو بھایٔی شمعُونؔ اَور لیوی اَپنی اَپنی تلوار لے کر، ناگہاں شہر پر ٹوٹ پڑے اَور ہر مَرد کو مار ڈالا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","اُنہُوں نے حمُورؔ اَور اُس کے بیٹے شِکیمؔ کو بھی تلوار سے قتل کر ڈالا اَور دینؔہ کو شِکیمؔ کے گھر سے نکال لے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","پھر یعقوب کے بیٹے مقتولوں پر جھپٹے اَور شہر کو لُوٹ لیا، کیونکہ اُنہُوں نے اُن کی بہن کو بےحُرمت کیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","اُنہُوں نے اُن کی بھیڑ بکریاں، مویشی، گدھے اَورجو کچھ شہر اَور کھیتوں میں تھا، لے لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","وہ اُن کی ساری دولت اَور اُن کے بچّوں اَور بیویوں کو، اَور اُن کے گھروں میں کی سَب چیزوں کو مالِ غنیمت کی طرح لے کر چلتے بنے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","تَب یعقوب نے شمعُونؔ اَور لیوی سے کہا، ”تُم نے اِس مُلک کے کنعانی اَور پَرزّی باشِندوں کے دِلوں میں میرے خِلاف نفرت پیدا کرکے، مُجھے مُصیبت میں ڈال دیا۔ ہم تو تعداد میں بہت کم ہیں اَور اگر وہ میرے خِلاف اِکٹھّے ہوکر مُجھ پر حملہ کر دیں تو میں اَور میرا خاندان تباہ ہو جایٔیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","لیکن اُنہُوں نے جَواب دیا، ”کیا اُسے ہماری ہی بہن کے ساتھ فاحِشہ کا سا سلُوک کرنا تھا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","تَب خُدا نے یعقوب سے فرمایا، ”بیت ایل لَوٹ جاؤ، اَور وہیں بس جاؤ۔ اَور وہاں خُدا کے لیٔے ایک مذبح بناؤ جو تُمہیں اُس وقت دِکھائی دیا تھا جَب تُم اَپنے بھایٔی عیسَوؔ کے خوف سے بھاگے جا رہے تھے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","تَب یعقوب نے اَپنے گھر والوں اَور اُن سَب سے جو اُن کے ساتھ تھے فرمایا، ”تمہارے پاس جو غَیر معبُود ہیں اُنہیں دُور کر دو اَور اَپنے آپ کو پاک کرکے اَپنا لباس تبدیل کرو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","تَب آؤ، ہم بیت ایل چلیں جہاں میں خُدا کے لیٔے ایک مذبح بناؤں گا، جنہوں نے میری تکلیف کے دِنوں میں میری دعا سُنی اَور جہاں کہیں میں گیا میرے ساتھ رہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","چنانچہ اُنہُوں نے سَب غَیر معبُود جو اُن کے پاس تھے۔ اَور اُن کے کانوں کی بالیاں یعقوب کو دے دیں اَور یعقوب نے اُنہیں شِکیمؔ میں بلُوط کے درخت کے نیچے دفن کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","تَب اُنہُوں نے کوُچ کیا، اَور اُن کے اِردگرد کے شہروں پر خُدا کا اِس قدر خوف طاری تھا کہ کسی نے یعقوب کے بیٹوں کا تعاقب نہ کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","یعقوب اَور اُن کے ساتھ کے سَب لوگ مُلکِ کنعانؔ کے لُوزؔ نام کے ایک مقام پر پہُنچے جِس کا نام بیت ایل بھی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","یعقوب نے وہاں ایک مذبح بنایا اَور اُس مقام کا نام ایل بیت ایل رکھا، کیونکہ جَب وہ اَپنے بھایٔی کے پاس سے دُور بھاگ رہے تھے، تَب خُدا نے اَپنے آپ کو وہاں پر ظاہر کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","اَور رِبقہؔ کی دایہ دبورہؔ مَر گئی اَور بیت ایل کے باہر بلُوط کے درخت کے نیچے دفن کی گئی۔ لہٰذا اُس کا نام اَلّون بکُوتؔ رکھا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","یعقوب کے فدّان ارام سے لَوٹنے کے بعد خُدا نے اَپنے آپ کو اُن پر دوبارہ ظاہر کیا، خُدا نے اُن کو برکت بخشی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","اَور خُدا نے اُن سے فرمایا، ”تمہارا نام یعقوب ہے، لیکن آئندہ تمہارا نام یعقوب نہ کہلائے گا، تمہارا نام اِسرائیل ہوگا۔“ اِس طرح خُدا نے اُن کا نام اِسرائیل رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","اَور خُدا نے آپ سے فرمایا، ”میں ایل شیدائی یعنی قادرمُطلق خُدا ہُوں۔ تُم برومند ہو اَور بڑھتے چلے جاؤ۔ تُم سے ایک قوم بَلکہ قوموں کا ایک گِروہ پیدا ہوگا اَور تمہاری نَسل سے بادشاہ پیدا ہوں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","جو مُلک مَیں نے اَبراہامؔ اَور اِصحاقؔ کو دیا وہ میں تُمہیں بھی دے رہا ہُوں اَور مَیں یہ مُلک تمہارے بعد تمہاری نَسل کو بھی دُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","تَب خُدا جِس جگہ یعقوب سے ہم کلام ہویٔے، وہیں سے اُن کے پاس سے اُوپر چلےگئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","جِس جگہ خُدا اُن سے ہم کلام ہویٔے تھے، وہاں یعقوب نے پتّھر کا ایک سُتون کھڑا کیا اَور اُس پر تپاون نذر کیا اَور زَیتُون کا تیل بھی ڈالا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","اَور یعقوب نے اُس مقام کا نام جہاں خُدا اُن سے ہم کلام ہُوا بیت ایل رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","تَب اُنہُوں نے بیت ایل سے کُوچ کیا۔ ابھی وہ اِفرات سے کچھ فاصلہ پر تھے، راخلؔ کو دردِزہ شروع ہو گیا اَور زچگی میں نہایت دِقّت ہُوئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","اَور چونکہ اُسے زچگی میں کافی تکلیف ہو رہی تھی اِس لیٔے دائی نے اُس سے کہا، ”خوف نہ کرو کیونکہ تمہارے یہاں بیٹا ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","وہ دَم توڑ رہی تھی لیکن مرنے سے پہلے اُس نے اُس بیٹے کا نام بِن اَونیؔ رکھا، لیکن اُس کے باپ نے اُس کا نام بِنیامین رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","یُوں راخلؔ نے وفات پائی اَور اِفرات یعنی بیت لحمؔ کی راہ میں دفن ہویٔی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","یعقوب نے اُس کی قبر پر ایک سُتون کھڑا کیا۔ راخلؔ کی قبر کا یہ سُتون آج تک مَوجُود ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","اِسرائیل نے پھر کُوچ کیا اَور مگدال عیدرؔ کے پرے خیمہ زن ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","جَب اِسرائیل اُس علاقہ میں رہتے تھے تَب رُوبِنؔ نے جا کر اَپنے باپ کی داشتہ بِلہاہؔ کے ساتھ رات گزاری اَور اِسرائیل کو اُس کا پتہ چل گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","اُن میں سے لِیاہؔ کے بیٹے یہ تھے: رُوبِنؔ یعقوب کا پہلوٹھا۔ شمعُونؔ، لیوی، یہُوداہؔ، یِسَّکاؔر اَور زبُولُون۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","اَور راخلؔ کے بیٹے یہ تھے: یُوسیفؔ اَور بِنیامین۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","راخلؔ کی خادِمہ بِلہاہؔ کے بیٹے یہ تھے: دانؔ اَور نفتالی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","اَور لِیاہؔ کی خادِمہ زِلفہؔ کے بیٹے یہ تھے: گادؔ اَور آشیر۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","یعقوب ممرےؔ میں جو قِریت اربعؔ یعنی حِبرونؔ کے نزدیک ہے اَور جہاں اَبراہامؔ اَور اِصحاقؔ بسے تھے اَپنے باپ اِصحاقؔ کے پاس آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","اِصحاقؔ ایک سَو اسّی بَرس کے ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","تَب اِصحاقؔ نے آخِری سانس لی اَور وفات پائی اَور ضعیف اَور پُوری عمر کا ہوکر اَپنے لوگوں میں جا مِلے اَور اُن کے بیٹے عیسَوؔ اَور یعقوب نے اُن کو دفنایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","عیسَوؔ یعنی اِدُوم کا نَسب نامہ یہ ہے: ");
INSERT INTO urdoucv_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","عیسَوؔ نے اِن کنعانی لڑکیوں سے بیاہ کیا، حِتّی ایلون کی بیٹی عدہؔ؛ حِوّیؔ ضِبعونؔ کی نواسی اَور عنہؔ کی بیٹی اُہلِیبامہؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","اِشمعیل کی بیٹی اَور نبایوتؔ کی بہن بسِماتھؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","عیسَوؔ سے عدہؔ کے ہاں اِلیفزؔ اَور بسِماتھؔ کے ہاں رِعوایلؔ پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","اَور اُہلِیبامہؔ کے ہاں یعُوسؔ، یعلامؔ اَور قورحؔ پیدا ہویٔے۔ یہ عیسَوؔ کے بیٹے تھے جو اُس کے یہاں مُلکِ کنعانؔ میں پیدا ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","عیسَوؔ اَپنی بیویوں، بیٹوں اَور بیٹیوں اَپنے گھر کے سَب لوگوں، اَپنے تمام مویشیوں اَور دُوسرے جانوروں اَور اُس مال و اَسباب کو جسے اُس نے مُلکِ کنعانؔ میں جمع کیا تھا ساتھ لے کر اَپنے بھایٔی یعقوب سے کچھ دُور کسی اَور مُلک میں چلےگئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","اُن کا مال و اَسباب اِس قدر بڑھ گیا تھا کہ وہ اِکٹھّے نہیں رہ سکتے تھے اَور اُن کے مویشیوں کی کثرت کے باعث اُس مُلک میں جہاں وہ رہتے تھے اُن دونوں کے لیٔے گنجائش نہ تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","چنانچہ عیسَوؔ، یعنی اِدُوم، سِعِیؔر کے پہاڑی مُلک میں جا بسے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","سِعِیؔر کے پہاڑی مُلک کے اِدُومیوں کے باپ عیسَوؔ کا نَسب نامہ یہ ہے: ");
INSERT INTO urdoucv_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","عیسَوؔ کے بیٹے یہ ہیں: اِلیفزؔ، عیسَوؔ کی بیوی عدہؔ کا بیٹا اَور رِعوایلؔ عیسَوؔ کی بیوی بسِماتھؔ کا بیٹا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","اِلیفزؔ کے بیٹے یہ ہیں: تیمانؔ، اومرؔ، ضیفوؔ، گعتامؔ اَور قِنٰز۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","عیسَوؔ کے بیٹے اِلیفزؔ کی ایک داشتہ بھی تھی جِس کا نام تِمنع تھا۔ اُس سے عمالیقؔ پیدا ہُوا۔ یہ عیسَوؔ کی بیوی عدہؔ کے پوتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","رِعوایلؔ کے بیٹے یہ ہیں: ناحات زیراحؔ شمّہ اَور مِزّہؔ۔ یہ عیسَوؔ کی بیوی بسِماتھؔ کے پوتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","عیسَوؔ کی بیوی اُہلِیبامہؔ کے ہاں جو ضِبعونؔ کی نواسی اَور عنہؔ کی بیٹی تھی عیسَوؔ سے یہ بیٹے پیدا ہویٔے: یعُوسؔ، یعلامؔ اَور قورحؔ تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","عیسَوؔ کی نَسل میں جو سردار بنے یہ تھے: جو عیسَوؔ کے بیٹے اِلیفزؔ کی اَولاد میں سے تھے یہ ہیں: تیمانؔ، اومرؔ، ضیفوؔ، قِنٰز، ");
INSERT INTO urdoucv_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","قورحؔ، گعتامؔ اَور عمالیقؔ۔ یہ سردار وہ ہیں جو مُلک اِدُوم میں اِلیفزؔ سے پیدا ہویٔے اَور وہ عدہؔ کے پوتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","عیسَوؔ کے بیٹے رِعوایلؔ کی اَولاد میں سے تھے یہ ہیں: ناحات، زیراحؔ، شمّہ اَور مِزّہؔ۔ یہ سردار وہ ہیں جو مُلک اِدُوم میں رِعوایلؔ سے پیدا ہویٔے اَور وہ عیسَوؔ کی بیوی بسِماتھؔ کے پوتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","جو عیسَوؔ کی بیوی اُہلِیبامہؔ کی اَولاد میں سے تھے یہ ہیں: یعُوسؔ، یعلامؔ اَور قورحؔ ہیں۔ یہ وہ سردار ہیں جو عنہؔ کی بیٹی اَور عیسَوؔ کی بیوی اُہلِیبامہؔ کے پوتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","یہ عیسَوؔ یعنی اِدُوم کی اَولاد اَور اُن کے سردار تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","اَور سِعِیؔر و حَوریؔ کے بیٹے جو اِس علاقہ میں بستے تھے یہ ہیں: لوطانؔ، شوبلؔ، ضِبعونؔ اَور عناہؔ، ");
INSERT INTO urdoucv_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","دیشونؔ، ایضرؔ اَور دیشانؔ، سِعِیؔر کی اَولاد میں سے مُلک اِدُوم میں جو حَوریؔ سردار ہویٔے یہی ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","بنی لوطانؔ یہ ہیں: حَوریؔ اَور ہیمان۔ لوطانؔ کی ایک بہن بھی تھی جِس کا نام تِمنؔا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","بنی شوبلؔ یہ ہیں: علوانؔ، مناحاتؔ، عیبالؔ، شِفوؔ اَور اونامؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","بنی ضِبعونؔ یہ ہیں: ایّہ اَور عنہؔ۔ (یہ وُہی عنہؔ ہے جسے اَپنے باپ ضِبعونؔ کے گدھے چراتے وقت بیابان میں گرم پانی کے چشموں کا سُراغ مِلا تھا۔) ");
INSERT INTO urdoucv_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","عناہؔ کی اَولاد یہ ہے: دیشونؔ اَور اُہلِیبامہؔ جو عنہؔ کی بیٹی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","دیشونؔ کے بیٹے یہ ہیں: حیمدانؔ، اِشبانؔ، اِترانؔ اَور کِرانؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","بنی ایضرؔ یہ ہیں: بِلہانؔ، زعوانؔ اَور عقانؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","دیشونؔ یا دیشانؔ کے بیٹے یہ ہیں: عُوضؔ اَور اَرانؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","سردار جو حَوریوں میں ہویٔے، یہ ہیں: لوطانؔ، شوبلؔ، ضِبعونؔ، عناہؔ، ");
INSERT INTO urdoucv_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","دیشونؔ، ایضرؔ اَور دیشانؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","یہ وہ بادشاہ ہیں جو اِسرائیلی بادشاہوں سے پیشتر مُلک اِدُوم میں حُکمرانی کی: ");
INSERT INTO urdoucv_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","بَیلعؔ بِن بعورؔ اِدُوم کا بادشاہ بنا اَور اُس کے شہر کا نام دِنہاباؔ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","بَیلعؔ کی وفات کے بعد اُس کی جگہ پر زیراحؔ بِن یُوبابؔ بادشاہ بنا۔ وہ بُضراؔہ کا باشِندہ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","یُوبابؔ کی وفات کے بعد حُشامؔ اُس کا جانشین ہُوا جو تیمانیوں کے مُلک کا باشِندہ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","حُشامؔ کی وفات کے بعد اُس کی جگہ پر ہددؔ بِن بِددؔ جِس نے مُوآب کے مُلک میں مِدیانیوں کو شِکست دی تھی بادشاہ بنا۔ اَور اُس کے شہر کا نام عَوِیتؔ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ہددؔ کی وفات کے بعد شَملہؔ اُس کی جگہ بادشاہ بنا جو مَشرِقہؔ کا باشِندہ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","شَملہؔ کی وفات کے بعد شاؤل اُس کا جانشین ہُوا جو دریائے فراتؔ کے کنارے کے رحوبوتھؔ کا باشِندہ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","شاؤل کی وفات کے بعد اُس کی جگہ پر بَعل حنانؔ بِن عکبورؔ بادشاہ بنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","بَعل حنانؔ بِن عکبورؔ کی وفات کے بعد اُس کی جگہ پر ہددؔ بادشاہ بنا۔ اُس کے شہر کا نام پؔاؤُ تھا اَور اُس کی بیوی کا نام مہیطبیلؔ تھا جو مطرِدؔ کی بیٹی اَور میضاہابؔ کی نواسی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","پس عیسَوؔ کی نَسل کے سردار کے نام اُن کی برادریوں اَور علاقوں کے ناموں کے مُطابق یہ ہیں: تِمنؔا، عَلوہؔ، یتیتؔ؛ ");
INSERT INTO urdoucv_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","اُہلِیبامہؔ، اَیلہ، پِنونؔ، ");
INSERT INTO urdoucv_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","قِنٰز، تیمانؔ، مِبضارؔ، ");
INSERT INTO urdoucv_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","مَگدِایلؔ اَور عِرامؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","یعقوب مُلکِ کنعانؔ میں یعنی اُس مُلک میں رہتے تھے۔ جہاں اُن کے باپ نے کچھ عرصہ گزارا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","یعقوب کی نَسل کا حال یہ ہے: یُوسیفؔ ایک سترہ سال کے نوجوان تھے جو اَپنے بھائیوں کے ساتھ جو اُن کے باپ کی بیویوں بِلہاہؔ اَور زِلفہؔ کے بیٹے تھے بھیڑ بکریاں، چُرایا کرتے تھے اَور اُن کی بدسلُوکیوں کی خبر باپ تک پہُنچایا کرتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","اِسرائیل کو یُوسیفؔ اَپنے دُوسرے بیٹوں سے زِیادہ عزیز تھے کیونکہ وہ اُن کے بُڑھاپے کا بیٹا تھا اَور یعقوب نے یُوسیفؔ کے لیٔے مُختلف رنگوں والی ایک قبا بنائی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","یُوسیفؔ کے بھائیوں نے جَب یہ دیکھا کہ اُن کے باپ یُوسیفؔ کو اُن سے زِیادہ مَحَبّت کرتے ہیں تو وہ یُوسیفؔ سے حَسد کرنے لگے اَور یُوسیفؔ کے ساتھ ڈھنگ سے بات بھی نہ کرتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","یُوسیفؔ نے ایک خواب دیکھا اَور جَب اُنہُوں نے وہ خواب اَپنے بھائیوں کو بتایا تو وہ یُوسیفؔ سے اَور بھی زِیادہ نفرت کرنے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","یُوسیفؔ نے اَپنے بھائیوں سے کہا، ”ذرا اِس خواب کو تو سُنو جو مَیں نے دیکھاہے: ");
INSERT INTO urdoucv_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ہم کھیت میں پُولے باندھ رہے تھے، اَچانک میرا پُولا کھڑا ہو گیا، اَور تمہارے پُولے میرے پُولے کے اِردگرد جمع ہو گئے اَور اُسے سَجدہ کرنے لگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","اُن کے بھائیوں نے یُوسیفؔ سے کہا، ”تو کیا تُم ہمارے بادشاہ بننا چاہتے ہو؟ کیا تُم واقعی ہم پر حُکومت کروگے؟“ اَور وہ اُن کے خواب اَور اُن کی باتوں کی وجہ سے یُوسیفؔ سے اَور بھی زِیادہ نفرت کرنے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","تَب یُوسیفؔ نے ایک اَور خواب دیکھا، اَور اَپنے بھائیوں کو بتایا۔ یُوسیفؔ نے کہا، ”سُنو، اِس دفعہ مَیں نے خواب میں دیکھا؛ سُورج چاند اَور گیارہ سِتارے مُجھے سَجدہ کر رہے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","جَب یُوسیفؔ نے اِس خواب کا ذِکر اَپنے باپ اَور اَپنے بھائیوں سے کیا تو اُن کے باپ نے اُسے ڈانٹا اَور کہا، ”یہ خواب کیا ہے جو تُم نے دیکھاہے؟ کیا تمہاری ماں اَور مَیں اَور تمہارے بھایٔی سچ مُچ تمہارے سامنے زمین پر جھُکیں گے اَور تُمہیں سَجدہ کریں گے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","یُوسیفؔ کے بھایٔی اُن سے اَور بھی حَسد کرنے لگے۔ لیکن یُوسیفؔ کے باپ نے یہ بات اَپنے دِل میں رکھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ایک دِن جَب یُوسیفؔ کے بھایٔی شِکیمؔ کے آس پاس اَپنے باپ کی بھیڑیں چرا رہے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","تو اِسرائیل نے یُوسیفؔ سے کہا، ”جَیسا کہ تُم جانتے ہو کہ تمہارے بھایٔی شِکیمؔ کے نزدیک بھیڑ بکریاں، چرا رہے ہیں، میں تُمہیں اُن کے پاس بھیجنا چاہتا ہُوں۔“ یُوسیفؔ نے جَواب دیا، ”بہت خُوب۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","چنانچہ یعقوب نے یُوسیفؔ سے کہا، ”جا کر دیکھو تمہارے بھایٔی اَور سارے گلّے خیریت سے تو ہیں اَور پھر آکر مُجھے خبر دو۔“ تَب یعقوب نے یُوسیفؔ کو حِبرونؔ کی وادی سے رخصت کیا۔ جَب یُوسیفؔ شِکیمؔ پہُنچے، ");
INSERT INTO urdoucv_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","تو ایک شخص نے اُنہیں کھیتوں میں اِدھر اُدھر گھُومتے پایا اَور اُن سے پُوچھا، ”تُم کیا ڈھونڈ رہے ہو؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","یُوسیفؔ نے جَواب دیا، ”میں اَپنے بھائیوں کو ڈھونڈ رہا ہُوں۔ کیا آپ مُجھے مہربانی کرکے بتا سکتے ہیں کہ وہ اَپنی بھیڑ بکریاں، کہاں چرا رہے ہیں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","اُس آدمی نے جَواب دیا، ”وہ یہاں سے چلے گیٔے، اَور مَیں نے اُنہیں یہ کہتے سُنا تھا، ’چلو، ہم دُتانؔ کی طرف نکل چلیں۔‘ “ چنانچہ یُوسیفؔ اَپنے بھائیوں کی تلاش میں روانہ ہویٔے اَور اُنہیں دُتانؔ کے پاس پایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","لیکن بھائیوں نے یُوسیفؔ کو دُور سے دیکھا، اَور اِس سے قبل کہ وہ اُن تک پہُنچتے اُنہُوں نے یُوسیفؔ کو قتل کرنے کا منصُوبہ بنا ڈالا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","اَور اُنہُوں نے آپَس میں کہا، ”دیکھو وہ آ رہاہے خواب دیکھنے والا! ");
INSERT INTO urdoucv_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","آؤ، ہم اُسے قتل کر ڈالیں اَور کسی گڑھے میں ڈال دیں، اَور کہیں گے کہ کویٔی خُونخوار جانور اُسے کھا گیا؛ پھر ہم دیکھیں گے کہ اُس کے خوابوں کا اَنجام کیا ہوتاہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","جَب رُوبِنؔ نے یہ سُنا تو اُس نے یُوسیفؔ کو اُن کے ہاتھوں سے بچانے کی کوشش کی۔ ”ہم یُوسیفؔ کو جان سے نہ ماریں،“ رُوبِنؔ نے کہا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","”بَلکہ اُس کا خُون بہانے کی بجائے اُسے بیابان کے کسی گڑھے میں ڈال دیں،“ تُم اُسے مارو مت۔ رُوبِنؔ نے یہ اِس لیٔے کہا کہ وہ اُسے اُن کے ہاتھ سے بچا کر اَپنے باپ کے پاس سلامت لے جانا چاہتا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","چنانچہ جَب یُوسیفؔ اَپنے بھائیوں کے پاس پہُنچے تو اُنہُوں نے یُوسیفؔ کی مُختلف رنگوں والی قبا کو جسے وہ پہنے ہویٔے تھے اُتار لیا، ");
INSERT INTO urdoucv_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","اَور یُوسیفؔ کو اُٹھاکر ایک گڑھے میں پھینک دیا، جو سُوکھا تھا؛ اُس میں ذرا بھی پانی نہ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","پھر جَب وہ کھانا کھانے بیٹھے تو اُنہُوں نے نظر اُٹھاکر دیکھا کہ اِشمعیلیوں کا ایک قافلہ گِلعادؔ سے آ رہاہے۔ اُن کے اُونٹ گرم مَسالوں روغن بلسان اَور مُر سے لدے ہویٔے تھے اَور وہ اُنہیں مِصر لے جا رہے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","یہُوداہؔ نے اَپنے بھائیوں سے کہا، ”اگر ہم اَپنے بھایٔی کو مار ڈالیں اَور اُس کے خُون کو چھُپا لیں تو کیا فائدہ ہوگا؟ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","کیوں نہ ہم اِسے اِشمعیلیوں کے ہاتھ بیچ ڈالیں۔ اُسے قتل نہ کریں؟ آخِرکار وہ ہمارا بھایٔی ہے اَور ہمارا ہی اَپنا گوشت اَور خُون ہے۔“ اُس کے بھائیوں نے اُس کی بات مان لی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","چنانچہ جَب وہ مِدیانی سوداگر نزدیک آئے تو اُن کے بھائیوں نے یُوسیفؔ کو گڑھے میں سے کھینچ کر باہر نکالا، اَور یُوسیفؔ کو چاندی کے بیسں ثاقل کے عِوض اِشمعیلیوں کے ہاتھ بیچ ڈالا جو اُسے مِصر لے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","جَب رُوبِنؔ لَوٹ کر گڑھے پر پہُنچا، اَور دیکھا کہ یُوسیفؔ وہاں نہیں ہیں، تو اُس نے اَپنے کپڑے پھاڑ ڈالے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","وہ لَوٹ کر اَپنے بھائیوں کے پاس گیا اَور کہنے لگا، ”لڑکا تو وہاں نہیں ہے! اَب مَیں کیا کروں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","تَب اُنہُوں نے ایک بکری کو ذبح کرکے یُوسیفؔ کی قبا کو اُس کے خُون میں تر کیا ");
INSERT INTO urdoucv_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","اَور اُس مُختلف رنگوں والی قبا کو لے کر اَپنے باپ کے پاس لَوٹے اَور کہنے لگے، ”ہمیں یہ قبا پڑا ہُوا مِلا؛ لہٰذا اُسے غور سے دیکھو کہ کہیں یہ تمہارے بیٹے کی قبا تو نہیں ہے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","یعقوب نے اُسے پہچان لیا اَور کہا، ”یہ تو میرے بیٹے کی قبا ہے۔ وہ کسی خُونخوار جانور کا لقمہ بَن گیا۔ سچ مُچ یُوسیفؔ پھاڑ ڈالا گیا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","چنانچہ تَب یعقوب نے اَپنے کپڑے پھاڑ ڈالے، اَور ٹاٹ پہن لیا اَور وہ کیٔی دِنوں تک اَپنے بیٹے کے لیٔے ماتم کرتے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","اَور اُن کے سَب بیٹے اَور بیٹیاں یعقوب کو تسلّی دیتے تھے لیکن یعقوب کو تسلّی نہ ہوتی تھی۔ وہ یہی کہتے تھے، ”نہیں، میں تو ماتم کرتا ہُوا ہی قبر میں پہُنچ جاؤں گا اَور اَپنے بیٹے سے جا ملوں گا۔“ چنانچہ یعقوب اَپنے بیٹے کے لیٔے آنسُو بہاتے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","اِس اَثنا میں مِدیانیوں نے یُوسیفؔ کو مِصر میں پُطیفؔار کے ہاتھ جو فَرعوہؔ کا ایک حاکم اَور پہرےداروں کا سردار تھا بیچ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","اُن ہی دِنوں میں یہُوداہؔ اَپنے بھائیوں کو چھوڑکر ایک عدولاّمی شخص کے پاس رہنے لگے جِس کا نام حیراہؔ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","وہاں یہُوداہؔ کی شُوعؔ نام کے کسی کنعانی کی بیٹی سے مُلاقات ہو گئی۔ اُنہُوں نے اُس سے شادی کرلی اَور اُس سے مَحَبّت کرنے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","وہ حاملہ ہُوئی اَور اُس کے یہاں بیٹا پیدا ہُوا جِس کا نام اُس نے عیرؔ رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","وہ پھر حاملہ ہُوئی اَور اُس کے یہاں بیٹا پیدا ہُوا۔ اُس نے اُس کا نام اَونانؔ رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","اُس کے یہاں ایک اَور بیٹا پیدا ہُوا اَور اُس نے اُس کا نام شِلحؔ رکھا۔ یہُوداہؔ کزیبؔ میں ہی تھے جَب اُن کے یہاں بیٹا پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","یہُوداہؔ نے اَپنے پہلوٹھے بیٹے عیرؔ کی شادی جِس عورت سے کی اُس کا نام تامارؔ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","لیکن یہُوداہؔ کا پہلوٹھا بیٹا عیرؔ یَاہوِہ کی نگاہ میں بدکار تھا؛ اِس لیٔے یَاہوِہ نے اُسے ہلاک کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","تَب یہُوداہؔ نے اَونانؔ سے کہا، ”اَپنے بھایٔی کی بیوی کے پاس جا اَور دیور کا حق اَدا کر تاکہ تمہارے بھایٔی کے نام سے نَسل چلے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","لیکن اَونانؔ جانتا تھا کہ وہ بچّے اُس کے نہ کہلایٔیں گے اِس لیٔے جَب کبھی وہ اَپنے بھایٔی کی بیوی کے پاس جاتا تھا تو اَپنا نطفہ زمین پر گرا دیتا تھا تاکہ کویٔی بچّہ نہ ہو جو اُس کے بھایٔی کی نَسل کہلا سکے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","اُس کا یہ فعل یَاہوِہ کی نظر میں بُرا تھا اِس لیٔے یَاہوِہ نے اُسے بھی زندہ نہ رہنے دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","تَب یہُوداہؔ نے اَپنی بہُو تامارؔ سے کہا، ”میرے بیٹے شِلحؔ کے بالغ ہونے تک تُو اَپنے باپ کے گھر میں بِیوہ کے طور پر بیٹھی رہ۔“ کیونکہ یہُوداہؔ نے سوچا، ”کہ کہیں شِلحؔ بھی اَپنے بھائیوں کی طرح مارا نہ جائے۔“ چنانچہ تامارؔ اَپنے باپ کے گھرجاکر رہنے لگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","کافی عرصہ کے بعد یہُوداہؔ کی بیوی جو شُوعؔ کی بیٹی تھی مَر گئی۔ جَب ماتم کے دِن پُورے ہو گئے تو یہُوداہؔ اَپنے عدولاّمی دوست حیراہؔ کے ساتھ اَپنی بھیڑوں کی اُون کترنے والوں کے پاس تِمنؔہ کو چلا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","جَب تامارؔ کو یہ خبر مِلی، ”اُس کا سسُر بھیڑوں کی پشم کترنے کے لیٔے تِمنؔہ آ رہاہے،“ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","تو اُس نے اَپنا بیوگی کا لباس اُتار کر بُرقع پہن لیا تاکہ اَپنا بھیس بدل لے۔ تَب وہ عینیمؔ کے پھاٹک پرجو تِمنؔہ کی راہ پر ہے جا بیٹھی۔ کیونکہ اُس نے دیکھا کہ شِلحؔ بالغ ہو چُکاہے پھر بھی وہ اُس سے بیاہی نہ گئی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","جَب یہُوداہؔ نے اُسے دیکھا تو اُسے کویٔی فاحِشہ سمجھا کیونکہ اُس نے اَپنا چہرہ چھُپا رکھا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","یہ نہ جانتے ہویٔے کہ وہ اَپنی ہی بہُو ہے وہ راستہ چھوڑکر اُس کے پاس گیا اَور کہا، ”مُجھے اَپنے ساتھ مباشرت کرنے دے۔“ اُس نے پُوچھا، ”تُو مُجھے اِس کے بدلے کیا دے گا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","اُس نے کہا، ”میں اَپنے گلّہ میں سے بکری کا ایک بچّہ تُجھے بھیج دُوں گا۔“ تامارؔ نے کہا، ”اُس کے بھیجنے تک کیا تُم کویٔی چیز میرے پاس رہن رکھوگے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","یہُوداہؔ نے جَواب دیا، ”مَیں تمہارے پاس کیا رہن رکھوں؟“ اُس نے جَواب دیا، ”اَپنی مُہر اَور بازوبند اَور اَپنا عصا۔“ چنانچہ یہُوداہؔ نے یہ چیزیں اُسے دیں اَور اُس سے مباشرت کی اَور وہ اُس سے حاملہ ہو گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","تَب تامارؔ گھر چلی گئی اَور اُس نے اَپنا بُرقع اُتار ڈالا اَور پھر سے بیوگی کے کپڑے پہن لیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","اِس اَثنا میں یہُوداہؔ نے اَپنے عدولاّمی دوست کے ساتھ بکری کا بچّہ بھیجا تاکہ اُس عورت کے پاس سے اَپنا رہن واپس منگائے، لیکن اُسے وہ عورت نہیں مِلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","اُس نے وہاں کے باشِندوں سے دریافت کیا، ”وہ فاحِشہ کہاں ہے جو عینیمؔ میں راہ کے کنارے بیٹھی تھی؟“ اُنہُوں نے کہا، ”یہاں تو کویٔی فاحِشہ نہ تھی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","چنانچہ وہ یہُوداہؔ کے پاس واپس آیا اَور بتایا، ”وہ مُجھے نہیں مِلی۔ اَور وہاں کے لوگوں نے بھی بتایا، ’یہاں پر کوئی فاحِشہ تھی ہی نہیں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","تَب یہُوداہؔ نے کہا، ”اُس رہن کو اُسی کے پاس رہنے دو ورنہ ہماری بڑی بدنامی ہوگی۔ مَیں نے تو اُسے بکری کا بچّہ بھیجا تھا پر وہ تُم کو نہ مِلی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","تقریباً تین ماہ کے بعد یہُوداہؔ کو یہ خبر مِلی، ”تمہاری بہُو تامارؔ نے زنا کیا جِس کی وجہ سے اَب وہ حاملہ ہے۔“ یہُوداہؔ نے کہا، ”اُسے باہر نکال لاؤ تاکہ اُسے جَلا کر مار ڈالیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","جَب اُسے باہر نکالا جا رہاتھا، تَب اُس نے اَپنے سسُر کو یہ پیغام بھیجا، ”میں جِس شخص سے حاملہ ہُوئی اُسی کی یہ چیزیں ہیں۔“ تامارؔ نے مزید کہا، ”تُم پہچانو، تو صحیح کہ یہ مُہر بازوبند اَور عصا کِس کا ہے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","یہُوداہؔ نے اُنہیں پہچان لیا اَور کہا، ”وہ مُجھ سے زِیادہ راستباز ہے کیونکہ مَیں نے اُسے اَپنے بیٹے شِلحؔ سے نہیں بیاہا۔“ اَور وہ پھر کبھی اُس کے پاس نہیں گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","جَب اُس کے جننے کا وقت نزدیک آیا تو مَعلُوم ہُوا کہ اُس کے رِحم میں جُڑواں بچّے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","جَب وہ جننے لگی تو اُن میں سے ایک نے اَپنا ہاتھ باہر نکالا اَور دایہ نے سُرخ دھاگا لے کر اُس کی کلائی میں باندھ دیا اَور کہا، ”یہ پہلے پیدا ہُوا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","لیکن جَب اُس نے اَپنا ہاتھ واپس کھینچ لیا تَب اُس کا بھایٔی پیدا ہُوا اَور اُس نے کہا، ”تُو زبردستی نکل پڑا!“ اَور اُس کا نام پیریزؔ رکھا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","تَب اُس کا بھایٔی جِس کی کلائی پر سُرخ دھاگا باندھا ہُوا تھا پیدا ہُوا اَور اُس کا نام زیراحؔ رکھا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","یُوسیفؔ کو مِصر لے جایا گیا اَور پُطیفؔار مِصری نے جو فَرعوہؔ کے حاکموں میں سے ایک تھا اَور پہرےداروں کا سردار تھا اُسے اِشمعیلیوں کے ہاتھ سے جو اُسے وہاں لے گیٔے تھے خرید لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","یَاہوِہ یُوسیفؔ کے ساتھ تھے اَور وہ برومند ہُوئے اَور اَپنے مِصری آقا کے گھر میں رہنے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","جَب یُوسیفؔ کے آقا نے دیکھا کہ یَاہوِہ یُوسیفؔ کے ساتھ ہے اَورجو کچھ وہ کرتے ہیں یَاہوِہ اُس میں اُن کو کامیابی عطا کرتے ہیں، ");
INSERT INTO urdoucv_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","تو یُوسیفؔ پر اُن کی مہربانی ہُوئی اَور پُطیفؔار نے یُوسیفؔ کو اَپنی خدمت گزاری میں لے لیا۔ پُطیفؔار نے اُنہیں اَپنے گھر کا مختار مُقرّر کیا اَور اَپنا سَب کچھ اُنہیں سونپ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","جَب سے اُس نے یُوسیفؔ کو اَپنے گھر کا مختار اَور اَپنے مال و متاع کا نِگراں مُقرّر کیا، تَب سے یَاہوِہ نے یُوسیفؔ کی وجہ سے اُس مِصری کے گھر کو برکت بخشی۔ پُطیفؔار کی ہر شَے پر خواہ وہ گھر کی تھی یا کھیت کی خُدا کی برکت مِلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","چنانچہ اُس نے اَپنی ہر شَے یُوسیفؔ کے حوالہ کر دی اَور یُوسیفؔ کی مَوجُودگی کے باعث اُسے سِوا اَپنے کھانے پینے کے کسی اَور بات کی فکر نہ تھی۔ یُوسیفؔ بڑے تنومند اَور خُوبصورت تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","اَور کچھ ہی عرصہ کے بعد یُوسیفؔ کے آقا کی بیوی کی نظر یُوسیفؔ پر پڑی اَور اُس نے یُوسیفؔ کو، ”مباشرت کرنے پر مجبُور کیا!“ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","لیکن یُوسیفؔ نے اِنکار کر دیا اَور اَپنی مالکن سے کہا، ”میں اِس گھر کا مختار ہُوں اَور اِس وجہ سے میرے آقا کو گھر کی فکر کرنے کی کوئی ضروُرت نہیں، اُنہُوں نے اَپنے گھر کا سَب کچھ میرے سُپرد کر رکھا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","اِس گھر میں مُجھ سے بڑا کویٔی نہیں اَور میرے آقا نے آپ کے سِوا کویٔی شَے میرے اِختیار سے باہر نہیں رکھی کیونکہ آپ اُن کی بیوی ہو۔ پھر بھلا میں اَیسی ذلیل حرکت کیوں کروں اَور خُدا کی نظر میں گُنہگار بنُوں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","اِس طرح اُس کا اِصرار روز بروز بڑھتا گیا لیکن یُوسیفؔ نے اُس سے ہم بِستر ہونے یا اُس کے ساتھ رہنے سے بھی اِنکار کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ایک دِن وہ کسی کام سے گھر میں داخل ہویٔے اَور گھر کے لوگوں میں سے کویٔی بھی اَندر مَوجُود نہ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","تو پُطیفؔار کی بیوی نے یُوسیفؔ کا پیراہن پکڑ لیا اَور کہا، ”میرے ساتھ ہم بِستری کرو۔“ لیکن وہ اَپنا پیراہن اُس کے ہاتھ میں چھوڑکر گھر سے باہر چلےگئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","جَب اُس عورت نے دیکھا کہ وہ اَپنا پیراہن اُس کے ہاتھ میں چھوڑکر گھر سے باہر بھاگ گئے، ");
INSERT INTO urdoucv_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","تو اُس نے اَپنے گھر کے خادِموں کو آواز دی اَور اُن سے کہا، ”دیکھو، کیا یہ عِبرانی غُلام ہمارے پاس اِس لیٔے بُلایا گیا ہے کہ وہ میرا مضحکہ اُڑائے۔ وہ یہاں میرے پاس ہم بِستری کرنے آیا، لیکن مَیں چِلّانے لگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","جَب اُس نے دیکھا کہ میں مدد کے لیٔے چِلّا رہی ہُوں تو وہ اَپنا پیراہن میرے پاس چھوڑکر گھر سے باہر بھاگ گیا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","اَور وہ یُوسیفؔ کا پیراہن اُس کے آقا کے گھر آنے تک اَپنے پاس رکھے رہی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","تَب اُس نے اُسے یہ ماجرا سُنایا: ”وہ عِبرانی غُلام جسے آپ ہمارے یہاں لائے ہیں میرے پاس اَندر آیا تاکہ میرا مضحکہ اُڑائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","لیکن جوں ہی میں مدد کے لیٔے چِلّائی وہ اَپنا پیراہن میرے پاس چھوڑکر گھر سے باہر بھاگ گیا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","جَب یُوسیفؔ کے آقا نے اَپنی بیوی کو یہ کہتے ہویٔے سُنا، ”آپ کے غُلام نے میرے ساتھ اَیسا سلُوک کیا،“ تو وہ غُصّہ سے آگ بگُولہ ہو گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","یُوسیفؔ کے آقا نے اُسے پکڑکر قَیدخانہ میں ڈال دیا، جہاں بادشاہ کے قَیدی رکھے جاتے تھے۔ جَب یُوسیفؔ قَیدخانہ میں تھے، ");
INSERT INTO urdoucv_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","لیکن یَاہوِہ اُن کے ساتھ تھے۔ وہ یُوسیفؔ پر مہربان ہُوئے اَور یَاہوِہ نے قَیدخانہ کے داروغہ کو بھی اُن کا شفیق بنا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","چنانچہ اُس داروغہ نے اُن سَب قَیدیوں کو جو قَیدخانہ میں تھے یُوسیفؔ کے ہاتھ میں سونپ دیا؛ اَور اُنہیں وہاں کے ہر کام کا ذمّہ دار قرار دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","جو چیز یُوسیفؔ کی زیرِ نِگرانی تھی اُس کی داروغہ بالکُل فکر نہ کرتا تھا کیونکہ یَاہوِہ یُوسیفؔ کے ساتھ تھے اَورجو کچھ وہ کرتے تھے اُس میں یَاہوِہ ہی اُنہیں کامیابی عطا کرتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","کچھ دِنوں کے بعد یُوں ہُوا کہ مِصر کے بادشاہ کا ساقی اَور نانبائی کسی جُرم میں پکڑے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","فَرعوہؔ اَپنے اِن دو حاکموں پرجو دُوسرے ساقیوں اَور نانبائی کے اہلکار تھے بہت خفا ہُوا، ");
INSERT INTO urdoucv_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","اَور بادشاہ نے اُن دونوں کو پہرےداروں کے سردار پُطیفؔار کے محل میں اُسی قَیدخانہ میں جہاں یُوسیفؔ حِراست میں تھے نظر بند کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","پہرےداروں کے سردار نے اُنہیں یُوسیفؔ کے سُپرد کر دیا۔ تاکہ وہ دونوں اَپنی نظر بندی کے دَوران اُن کی نِگرانی میں رہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","مِصر کے بادشاہ کے ساقی اَور نانبائی دونوں نے جو قَیدخانہ میں نظر بند تھے، ایک ہی رات ایک ایک خواب دیکھا اَور ہر خواب کی تعبیر جُدا جُدا تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","دُوسری صُبح جَب یُوسیفؔ اُن کے پاس آئے تو دیکھا کہ وہ بڑے اُداس ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","تَب یُوسیفؔ نے فَرعوہؔ کے اہلکاروں سے جو اُن کے ساتھ اُس کے آقا کے گھر میں قَید تھے پُوچھا، ”آج تمہارے چہروں پر اِس قدر اُداسی کیوں چھائی ہویٔی ہے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","اُنہُوں نے جَواب دیا، ”ہم دونوں نے خواب دیکھے ہیں لیکن اُن کی تعبیر بتانے والا کویٔی نہیں ہے۔“ تَب یُوسیفؔ نے اُن سے کہا، ”کیا تعبیریں بتانا خُدا کا کام نہیں؟ اَپنے خواب مُجھے بتاؤ۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","تَب ساقی سردار نے اَپنا خواب یُوسیفؔ سے بَیان کیا۔ اُس نے اُن سے کہا، ”مَیں نے اَپنے خواب میں اَپنے سامنے ایک انگور کی بیل دیکھی ");
INSERT INTO urdoucv_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","جِس میں تین شاخیں تھیں۔ جوں ہی اُس میں کلیاں لگیں اَور پھُول آئے اُس میں پکے ہویٔے انگوروں کے گُچّھے لگ گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","فَرعوہؔ کا پیالہ میرے ہاتھ میں تھا مَیں نے انگور لے کر اُنہیں فَرعوہؔ کے پیالہ میں نچُوڑا اَور وہ پیالہ فَرعوہؔ کے ہاتھ میں دے دیا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","یُوسیفؔ نے اُس سے خواب کی تعبیر بَیان کی، ”وہ تین شاخیں تین دِن ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","اَب سے تین دِن کے اَندر اَندر فَرعوہؔ تُمہیں سرفرازی بخشےگا اَور تُمہیں پھر سے اَپنے منصب پر بحال کرےگا اَور تُم پہلے کی طرح اُن کے ساقی کی حیثیت سے فَرعوہؔ کا پیالہ اُن کے ہاتھ میں دیا کروگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","لیکن اَپنی سرفرازی کے بعد مُجھے بھی یاد کرنا اَور مُجھ پر مہربانی کرکے فَرعوہؔ سے میرا ذِکر کرنا اَور مُجھے اِس قَیدخانہ سے رِہائی دِلوانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","کیونکہ مُجھے عِبرانیوں کے مُلک میں سے زبردستی لایا گیا ہے اَور یہاں بھی مَیں نے اَیسا کویٔی کام نہیں کیا جِس کے سبب سے مُجھے قَیدخانہ کی کوٹھری میں ڈالا گیا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","جَب نانبائیوں کے سردار نے دیکھا کہ یُوسیفؔ کی تعبیر ساقیوں کے سردار کے حق میں ہے تو اُس نے یُوسیفؔ سے کہا، ”مَیں نے بھی خواب دیکھا: میرے سَر پر روٹی کی تین ٹوکریاں ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","سَب سے اُوپر والی ٹوکری میں فَرعوہؔ کے لیٔے ہر قِسم کے کھانے رکھے ہویٔے ہیں لیکن پرندے اُس اُوپر والی ٹوکری کا کھانا کھا رہے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","یُوسیفؔ نے اُس کے خواب کی بھی تعبیر بَیان کی، ”وہ تین ٹوکریاں تین دِن ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","اَور اَب سے تین دِن کے اَندر اَندر فَرعوہؔ تمہارا سَر کٹوا کر تُمہیں ایک درخت پر ٹنگوا دے گا اَور پرندے تمہارا گوشت نوچ نوچ کر کھایٔیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","تیسرے دِن فَرعوہؔ کی سالگرہ کا دِن تھا اَور اُس نے اَپنے تمام افسروں کی ضیافت کی۔ اُس نے اَپنے افسروں کی مَوجُودگی میں حُکم دیا کہ ساقیوں کے سردار اَور نانبائیوں کے سردار کو حاضِر کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","اُس نے ساقیوں کے سردار کو اُس کے منصب پر بحال کیا اَور وہ پھر سے فَرعوہؔ کے ہاتھ میں پیالہ دینے لگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","لیکن اُس نے نانبائیوں کے سردار کو پھانسی دِلوائی۔ پس یُوسیفؔ کی تعبیر سچّی ثابت ہُوئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","لیکن ساقیوں کے سردار نے یُوسیفؔ کو یاد تک نہ کیا بَلکہ اُسے بھُلا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","پُورے دو بَرس بعد فَرعوہؔ نے ایک خواب دیکھا: وہ دریائے نیل کے کنارے کھڑا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","اَور دریائے نیل میں سے سات خُوبصورت موٹی تازہ گائیں نکل آئیں اَور کنارے کنارے سَرکنڈوں کے کھیت میں چرنے لگیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","اُن کے بعد سات بدشکل اَور دبلی پتلی گائیں دریائے نیل میں سے اَور نکلیں اَور اُن کے پاس جا کھڑی ہُوئیں جو دریا کے کنارے پر تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","اَور یہ بدشکل اَور دبلی پتلی گائیں اُن سات موٹی تازہ گایوں کو کھا گئیں۔ اِس پر فَرعوہؔ کی آنکھ کھُل گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","وہ پھر سو گیا اَور اُس نے دُوسرا خواب دیکھا: ایک ڈنٹھل میں دانوں سے بھری ہُوئی سات موٹی اَور اَچھّی اَچھّی بالیں نکلیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","اُس کے بعد سات اَور بالیں پھوٹ نکلیں جو پتلی اَور پُوربی ہَوا کی ماری ہُوئی تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","یہ سات پتلی بالیں اُن سات موٹی اَور دانوں سے بھری ہُوئی بالوں کو ہڑپ کر گئیں۔ اِس پر فَرعوہؔ کی آنکھ کھُل گئی اَور اُسے مَعلُوم ہُوا کہ یہ خواب تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","جَب صُبح ہُوئی تو وہ دماغ بڑا پریشان ہُوا اَور اُس نے مِصر کے سَب جادُوگروں اَور دانِشوروں کو بُلوا بھیجا۔ فَرعوہؔ نے اَپنے خواب اُنہیں بتائے لیکن کویٔی بھی اُسے اُن کی تعبیر نہ بتا سَکا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","تَب ساقیوں کے سردار نے فَرعوہؔ سے کہا، ”آج مُجھے اَپنی خامیاں یاد آئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ایک دفعہ فَرعوہؔ اَپنے خادِموں سے ناراض ہویٔے تھے تو اُنہُوں نے مُجھے اَور نانبائیوں کے سردار کو پہرےداروں کے سردار کے گھر میں نظر بند کروا دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ہم میں سے ہر ایک نے ایک ہی رات میں ایک ایک خواب دیکھا اَور ہر خواب کی اَپنی اَپنی الگ تعبیر تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","قَیدخانہ میں ایک عِبری جَوان ہمارے ساتھ تھا جو پہرےداروں کے سردار کا خادِم تھا۔ ہم نے اُسے اَپنے خواب بتائے اَور اُس نے ہمیں ہمارے اَپنے اَپنے خواب کی تعبیر بتا دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","اَورجو تعبیر اُس نے بتایٔی تھی وَیسا ہی ہُوا یعنی میں اَپنے منصب پر بحال کیا گیا اَور اُس دُوسرے شخص کو پھانسی دی گئی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","تَب فَرعوہؔ نے یُوسیفؔ کو بُلوایا۔ قَیدخانہ کی کوٹھری سے رِہائی پاتے ہی یُوسیفؔ نے حجامت بنوائی کپڑے بدلے اَور فَرعوہؔ کے سامنے پہُنچے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","فَرعوہؔ نے یُوسیفؔ سے کہا، ”مَیں نے ایک خواب دیکھاہے، جِس کی تعبیر کویٔی نہیں کر سَکتا لیکن مَیں نے تمہارے متعلّق سُنا ہے کہ تُم خواب کو سُن کر اُس کی تعبیر بتا سکتے ہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","یُوسیفؔ نے فَرعوہؔ کو جَواب دیا، ”میں تو تعبیر نہیں بتا سَکتا البتّہ خُدا ہی فَرعوہؔ کو تسلّی بخش جَواب دیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","تَب فَرعوہؔ نے یُوسیفؔ سے کہا، ”مَیں نے خواب میں دیکھا کہ میں دریائے نیل کے کنارے کھڑا ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","اَور دریائے نیل میں سے سات موٹی تازہ گائیں نکل آئیں اَور سَرکنڈوں کے کھیت میں چرنے لگیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","اُن کے بعد سات اَور گائیں نکل آئیں جو نہایت بدصورت، مریل اَور دبلی پتلی تھیں۔ مَیں نے اَیسی بدشکل گائیں مُلک مِصر میں کبھی نہیں دیکھی تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","وہ دبلی پتلی، مریل اَور بدصورت گائیں اُن سات موٹی تازہ گایوں کو کھا گئیں جو دریا سے پہلے نکلی تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","لیکن اُس کے بعد بھی کویٔی یہ نہ کہہ سَکتا تھا کہ اُنہُوں نے کچھ کھایا ہے؛ وہ وَیسی ہی بدصورت نظر آئیں جَیسی پہلے تھیں۔ تَب میری آنکھ کھُل گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","”مَیں نے ایک اَور خواب میں سات موٹی اَور دانوں سے بھری ہُوئی اَچھّی بالیں بھی دیکھیں، جو ایک ڈنٹھل پر لگی ہُوئی تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","اُن کے بعد سات اَور بالیں نکلیں جو مُرجھائی ہُوئی، پتلی اَور پُوربی ہَوا کی ماری ہُوئی تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","اناج کی پتلی بالوں نے سات اَچھّی بالوں کو ہڑپ کر لیا۔ اِسے مَیں نے جادُوگروں کو بتایا لیکن کویٔی مُجھے اِس کا مطلب نہ سمجھا سَکا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","تَب یُوسیفؔ نے فَرعوہؔ سے کہا، ”فَرعوہؔ کے دونوں خواب ایک جَیسے ہیں۔ جو کچھ خُدا کرنے کو ہے اُسے خُدا نے فَرعوہؔ پر ظاہر کیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","سات اَچھّی گائیں سات بَرس ہیں اَور اناج کے دانوں کی سات اَچھّی بالیں بھی سات بَرس ہیں۔ خواب ایک ہی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","سات دبلی اَور بدصورت گائیں جو بعد میں نکلیں وہ سات بَرس ہیں اَور اناج کے دانوں کی سات ناقص بالیں بھی جو پُوربی ہَوا کی ماری ہُوئی تھیں سات بَرس ہی ہیں؛ یہ قحط کے سات بَرس ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","”جَیسا کہ مَیں نے فَرعوہؔ سے کہا، جو کچھ خُدا کرنے پر ہے؛ اُسے خُدا نے آپ پر ظاہر کیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","سارے مُلک مِصر میں سات سال پیداوار کی فراوانی کے ہوں گے، ");
INSERT INTO urdoucv_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","لیکن اُن کے بعد سات سال قحط کے ہوں گے۔ جِن میں مِصر کی فراوانی والے سالوں کی یاد بھی باقی نہ رہے گی۔ اَور یہ قحط مُلک کو تباہ کر دے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","مُلک کی فراوانی یاد نہ رہے گی، کیونکہ بعد میں آنے والا قحط نہایت ہی شدید ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","فَرعوہؔ کو یہ خواب دو طرح سے دِکھایا گیا؛ اُس کی وجہ یہی ہے کہ خُدا نے اِس بات کا پُختہ فیصلہ کر دیا ہے اَور وہ جلد ہی اُسے عَمل میں لائیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","”اَور اَب فَرعوہؔ کو چاہیے کہ وہ کسی صاحبِ فہم اَور دانشمند شخص کو تلاش کرے اَور اُسے مُلک مِصر پر مختار بنائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","جسے فَرعوہؔ یہ اِختیار دے کہ وہ اَیسے حُکاّم مُقرّر کرے، جو فراوانی کے سات سالوں میں مِصر کی پیداوار کا پانچواں حِصّہ وصول کریں ");
INSERT INTO urdoucv_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","اَور اُن آنے والے اَچھّے سالوں میں تمام اناج کی اشیائے خوردنی جمع کریں اَور فَرعوہؔ کے اِختیار کے ماتحت شہروں میں ذخیرہ کرکے اُس کی حِفاظت کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","یہ اناج مِصر پر آنے والے قحط کے سات سالوں میں اِستعمال کیٔے جانے کے لیٔے حِفاظت سے رکھا جائے تاکہ مُلک کے لوگ قحط سے ہلاک نہ ہوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","یہ تجویز فَرعوہؔ اَور اُس کے افسروں کو پسند آئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","چنانچہ فَرعوہؔ نے اُن سے پُوچھا، ”کیا ہمیں اِس جَیسا آدمی مِل سَکتا ہے جو خُدا کی رُوح سے معموُر ہو؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","تَب فَرعوہؔ نے یُوسیفؔ سے کہا، ”چونکہ یہ سَب تُمہیں خُدا نے سمجھائی ہیں لہٰذا تُم سا صاحبِ فہم اَور دانِشور اَور کویٔی نہیں ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","تُم میرے محل کے مختار ہوگے اَور میری ساری رعایا تمہاری فرماں بردار ہوگی۔ فقط تختِ شاہی کا مالک ہونے کے اِعتبار سے میں تُم سے برتر ہُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","چنانچہ فَرعوہؔ نے یُوسیفؔ سے کہا، ”مَیں تُجھے سارے مُلک مِصر کا مختار مُقرّر کرتا ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","تَب فَرعوہؔ نے اَپنی اُنگلی سے اَپنی مُہر والی انگُوٹھی اُتار کر یُوسیفؔ کی اُنگلی میں پہنا دی۔ اُس نے یُوسیفؔ کو نہایت اعلیٰ درجہ کے نفیس کتانی لباس سے آراستہ کیا اَور اُن کے گلے میں سونے کا گلوبند پہنایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","فَرعوہؔ نے یُوسیفؔ کو حاکمِ سلطنت کی حیثیت سے اَپنے دُوسرے رتھ میں سوار کیا اَور اُن کے آگے آگے یہ مُنادی کروائی، ”سَب دو زانو ہو جاؤ!“ یُوں فَرعوہؔ نے یُوسیفؔ کو سارے مُلک مِصر کا مختار بنا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","اُس کے بعد فَرعوہؔ نے یُوسیفؔ سے کہا، ”میں فَرعوہؔ ہُوں، لیکن سارے مُلک مِصر میں کویٔی شخص تمہارے حُکم کے بغیر ہاتھ یا پاؤں نہ ہلا سکےگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","اَور فَرعوہؔ نے یُوسیفؔ کا نام ضَافنتھ پعنیحؔ رکھا اَور اُس نے اَونؔ کے کاہِنؔ پُطیفرعؔ کی بیٹی آسِناتھؔ کو اُس سے بیاہ دیا اَور یُوسیفؔ مِصر کے تمام مُلک میں دورہ کرنے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","جَب یُوسیفؔ مِصر کے بادشاہ فَرعوہؔ کی مُلازمت میں آئے تو آپ تیس بَرس کے تھے۔ اَور یُوسیفؔ فَرعوہؔ سے رخصت ہوکر سارے مُلک مِصر کا دورہ کرنے کے لیٔے روانہ ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","فراوانی کے سات سالوں میں مُلک میں کثرت سے پیداوار ہُوئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","یُوسیفؔ وہ تمام اشیائے خوردنی جو اِفراط کے اُن سات سالوں میں مُلک مِصر میں پیدا ہُوئیں جمع کرکے شہروں میں اُن کا ذخیرہ کرنے لگے اَور ہر شہر میں اُن کے اِردگرد کے کھیتوں میں اُگی ہُوئی اشیائے خوردنی بھی جمع کرتے گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","یُوسیفؔ نے اناج سمُندر کی ریت کی مانند نہایت کثرت سے ذخیرہ کیا جِس کی مقدار اِس قدر زِیادہ ہو گئی تھی کہ یُوسیفؔ نے اُس کا حِساب رکھنا بھی چھوڑ دیا۔ کیونکہ وہ بے حِساب تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","قحط کے سالوں کے آغاز سے قبل اَونؔ کے کاہِنؔ پُطیفرعؔ کی بیٹی آسِناتھؔ کے یہاں یُوسیفؔ سے دو بیٹے پیدا ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","یُوسیفؔ نے اَپنے پہلوٹھے کا نام منشّہ یہ کہہ کر رکھا، ”خُدا کی مہربانی سے مَیں نے اَپنی اَور اَپنے باپ کے گھرانے کی ساری مشقّت بھُلا دی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","اَور یُوسیفؔ نے اَپنے دُوسرے بیٹے کا نام اِفرائیمؔ یہ کہہ کر رکھا، ”خُدا نے مُجھے اُس مُلک میں برومند کیا جہاں مَیں نے مُصیبت اُٹھائی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","مُلک مِصر کے اِفراط کے سات سال ختم ہو گئے ");
INSERT INTO urdoucv_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","اَور یُوسیفؔ کے کہنے کے مُطابق قحط کے سات سالوں کا آغاز ہُوا۔ حالانکہ دُوسرے تمام مُلکوں میں قحط پڑا تھا لیکن مِصر کے سارے مُلک میں خُوراک مَوجُود تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","جَب مِصر کے سارے مُلک میں بھی قحط کی شِدّت محسُوس ہونے لگی تو لوگ روٹی کے لیٔے فَرعوہؔ کے آگے چِلّائے۔ تَب فَرعوہؔ نے مِصریوں سے کہا، ”یُوسیفؔ کے پاس جاؤ اَورجو کچھ وہ تُم سے کہے وہ کرو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","جَب قحط سارے مُلک میں پھیل گیا تو یُوسیفؔ نے گودام کھول کر مِصریوں کے ہاتھ اناج بیچنا شروع کر دیا کیونکہ تمام مُلک مِصر میں سخت قحط پڑا ہُوا تھا ");
INSERT INTO urdoucv_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","اَور سارے مُلکوں کے لوگ اناج خریدنے کے لیٔے یُوسیفؔ کے پاس مِصر میں آنے لگے کیونکہ ساری دُنیا شدید قحط کی لپیٹ میں تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","جَب یعقوب کو مَعلُوم ہُوا کہ مِصر میں اناج مِل رہاہے تو یعقوب نے اَپنے بیٹوں سے کہا، ”تُم کھڑے کھڑے ایک دُوسرے کا مُنہ کیوں تاک رہے ہو؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","اَور اُنہُوں نے گُفتگو جاری رکھتے ہویٔے کہا، ”مَیں نے سُنا ہے کہ مُلک مِصر میں اناج ہے۔ تُم وہاں جاؤ اَور اَپنے لیٔے کچھ خرید لاؤ، تاکہ ہم زندہ رہیں اَور ہلاک نہ ہوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","تَب یُوسیفؔ کے دس بھایٔی اناج خریدنے کے لیٔے مِصر روانہ ہویٔے ");
INSERT INTO urdoucv_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","لیکن یعقوب نے یُوسیفؔ کے بھایٔی بِنیامین کو اُن کے ساتھ نہ بھیجا کیونکہ یعقوب کو ڈر تھا کہ کہیں اَیسا نہ ہو کہ بِنیامین پر بھی کویٔی آفت نازل ہو جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","چنانچہ اِسرائیل کے بیٹے بھی اُن لوگوں میں شامل تھے جو اناج خریدنے کے لیٔے گیٔے کیونکہ مُلکِ کنعانؔ بھی قحط کا شِکار تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","یُوسیفؔ مُلک مِصر کے حاکم تھے اَور وُہی مُلک کے سَب لوگوں کے ہاتھ اناج بیچتے تھے۔ لہٰذا جَب یُوسیفؔ کے بھایٔی پہُنچے تو وہ زمین پر اَپنے سَر ٹیک کر اُن کے حُضُور آداب بجا لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","جوں ہی یُوسیفؔ نے اَپنے بھائیوں کو دیکھا اُنہیں پہچان لیا لیکن اَنجان بَن کر نہایت سخت لہجہ میں اُن سے پُوچھا، ”تُم لوگ کہاں سے آئے ہو؟“ اُنہُوں نے جَواب دیا، ”ہم مُلکِ کنعانؔ سے یہاں اناج خریدنے آئے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","حالانکہ یُوسیفؔ نے اَپنے بھائیوں کو پہچان لیا تھا لیکن بھائیوں نے یُوسیفؔ کو نہ پہچانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","تَب یُوسیفؔ نے اُن خوابوں کو جو اُنہُوں نے اُن کے بارے میں دیکھے تھے یاد کرکے اُن سے کہا، ”تُم جاسُوس ہو! تُم یہ دیکھنے آئے ہو کہ ہمارے مُلک کی سرحد کہاں غَیر محفوظ ہے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","اُنہُوں نے جَواب دیا، ”نہیں، ہمارے آقا! ہم تمہارے خادِم تو اناج خریدنے آئے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ہم سَب ایک ہی باپ کے بیٹے ہیں۔ آپ کے خادِم شریف لوگ ہیں جاسُوس نہیں ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","یُوسیفؔ نے اُن سے کہا، ”نہیں تُم یہ دیکھنے آئے ہو کہ ہمارے مُلک کی حالت کہاں غَیر محفوظ ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","لیکن اُنہُوں نے جَواب دیا، ”آپ کے خادِم بَارہ بھایٔی ہیں جو ایک ہی باپ کے بیٹے ہیں، وہ مُلکِ کنعانؔ میں رہتے ہیں۔ سَب سے چھوٹا اِس وقت ہمارے باپ کے پاس ہے اَور ایک مَر چُکاہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","یُوسیفؔ نے اُن سے کہا، ”مَیں نے پہلے ہی کہہ دیا کہ تُم جاسُوس ہو! ");
INSERT INTO urdoucv_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","اَب تمہاری آزمائش یُوں کی جائے گی کہ جَب تک تمہارا چھوٹا بھایٔی یہاں نہ آئے، فَرعوہؔ کی حیات کی قَسم، تُم یہاں سے جانے نہ پاؤگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","لہٰذا اَپنے میں سے کسی ایک کو بھیج دو تاکہ وہ تمہارے بھایٔی کو لے آئے؛ اَور باقی تُم قَیدخانہ میں رکھے جاؤگے تاکہ تمہاری باتوں کی تصدیق ہو کہ تُم سچ کہہ رہے ہو۔ اَور اگر نہیں تو فَرعوہؔ کی حیات کی قَسم، تُم جاسُوس ہی سمجھے جاؤگے!“ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","اَور یُوسیفؔ نے اُن سَب کو تین دِن تک حِراست میں رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","تیسرے دِن یُوسیفؔ نے اُن سے کہا، ”ایک کام کرو تاکہ زندہ رہو؛ کیونکہ مَیں خُدا سے ڈرنے والا آدمی ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","اگر تُم شریف ہو تو تُم سَب بھائیوں میں سے ایک یہاں قَیدخانہ میں بند رہے اَور باقی سَب اَپنے خاندان کے لیٔے جو فاقوں سے ہیں اناج لے جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","لیکن تُم اَپنے چُھوٹے بھایٔی کو میرے پاس ضروُر لے آنا تاکہ تمہاری باتوں کی تصدیق ہو سکے اَور تُم ہلاکت سے بچ جاؤ۔“ چنانچہ اُنہُوں نے وَیسا ہی کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","وہ آپَس میں کہنے لگے، ”یقیناً ہم اَپنے بھایٔی یُوسیفؔ کے سبب سے مُجرم ٹھہرے۔ ہمیں یاد ہے کہ جَب یُوسیفؔ نے ہم سے مِنّت کی تھی کہ مُجھے جان سے مت مارو تو وہ کِس قدر بےبس نظر آ رہاتھا۔ تَب بھی ہم نے اُس کی نہ سُنی۔ اِس لیٔے اَب یہ مُصیبت ہم پر آ پڑی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","رُوبِنؔ نے جَواب دیا، ”کیا مَیں نے تُم سے نہ کہاتھا کہ اِس بچّے پر ظُلم نہ کرو؟ لیکن تُم نے میری ایک نہ سُنی! اَب اُس کا خُون ہماری گردن پر ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","اُنہیں اِس بات کا احساس نہ تھا کہ یُوسیفؔ اُن کی باتیں سمجھ رہاہے کیونکہ یُوسیفؔ نے جو کچھ کہاتھا ایک ترجمان کی زبانی کہاتھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","تَب یُوسیفؔ اُن کے پاس سے ہٹ گئے اَور الگ جا کر رونے لگے؛ لیکن پھر واپس آئے اَور اُن سے باتیں کرنے لگے۔ یُوسیفؔ نے اُن میں سے شمعُونؔ کو لے کر اُسے اُن کی آنکھوں کے سامنے بندھوایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","تَب یُوسیفؔ نے حُکم دیا کہ اُن کے بوروں میں اناج بھر دیا جائے اَور ہر آدمی کی چاندی بھی اُسی کے بورے میں رکھ دی جائے، اَور اُنہیں توشہ سفر بھی دیا جائے۔ جَب یہ سَب کچھ ہو چُکا، ");
INSERT INTO urdoucv_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","تَب اُنہُوں نے اَپنا اناج اَپنے گدھوں پر لادا اَور روانہ ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","راستے میں اَپنے شب گزاری کے مقام پر اُن میں سے ایک نے اَپنے گدھے کو خُوراک دینے کی خاطِر اَپنا بورا کھولا تو اَپنی چاندی بھی اَپنے بورے کے مُنہ پر رکھی ہُوئی دیکھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","اُس نے اَپنے بھائیوں سے کہا، ”میری چاندی تو واپس کر دی گئی۔ دیکھو یہ میرے بورے میں رکھی ہے۔“ یہ دیکھ کر اُن کے حواس گُم ہو گئے۔ اُن پر لرزہ طاری ہو گیا اَور وہ ایک دُوسرے کی طرف دیکھ کر کہنے لگے، ”خُدا نے ہمارے ساتھ یہ کیا کر دیا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","جَب وہ مُلکِ کنعانؔ میں اَپنے باپ یعقوب کے پاس آئے تو اُنہُوں نے اَپنی آپ بیتی اُنہیں سُنایٔی۔ اُنہُوں نے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","”جو شخص اُس مُلک پر حاکم ہے وہ ہم سے نہایت سخت لہجہ میں مُخاطِب ہُوا اَور یُوں پیش آیا گویا ہم اُس مُلک میں جاسُوسی کرنے آئے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","لیکن ہم نے اُس سے کہا، ’ہم شریف لوگ ہیں ہم جاسُوس نہیں ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ہم بَارہ بھایٔی ایک ہی باپ کے بیٹے ہیں۔ ایک مَر چُکاہے اَور سَب سے چھوٹا اِس وقت مُلکِ کنعانؔ میں ہمارے باپ کے پاس ہے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","”تَب اُس شخص نے جو اُس مُلک کا حاکم ہے ہم سے کہا، ’ابھی مَعلُوم ہو جائے گا کہ تُم شریف ہو یا نہیں۔ اَپنے بھائیوں میں سے کسی ایک کو یہاں میرے پاس چھوڑ دو؛ اَور اَپنے فاقہ کش خاندان کے لیٔے اناج لے کر چلے جاؤ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","لیکن اَپنے چُھوٹے بھایٔی کو ساتھ لے کر میرے پاس آؤ تاکہ مُجھے مَعلُوم ہو کہ تُم جاسُوس نہیں ہو بَلکہ شریف آدمی ہو۔ تَب میں تمہارا بھایٔی تُمہیں لَوٹا دُوں گا اَور تُم اِس مُلک میں آزادی سے گھُوم پھر سکتے ہو۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","اَور جَب وہ اَپنے بورے خالی کرنے لگے تو ہر ایک کی چاندی کی تھیلی اُس کے بورے میں پائی گئی۔ جَب اُنہُوں نے اَور اُن کے باپ نے وہ تھیلیاں دیکھیں تو خوفزدہ ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","اُن کے باپ یعقوب نے اُن سے کہا، ”تُم نے مُجھے میرے بچّوں سے محروم کر دیا۔ یُوسیفؔ نہیں رہا اَور شمعُونؔ بھی نہیں رہا اَور اَب تُم بِنیامین کو بھی لے جانا چاہتے ہو۔ ہر چیز میرے مُخالف ہے!“ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","تَب رُوبِنؔ نے اَپنے باپ سے کہا، ”اگر مَیں اُسے تمہارے پاس واپس نہ لایا تو آپ میرے دونوں بیٹوں کو قتل کر ڈالنا۔ اُسے میری حِفاظت میں دے دیجئے۔ میں اُسے واپس لے آؤں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","لیکن یعقوب نے کہا، ”میرا بیٹا تمہارے ساتھ وہاں نہ جائے گا؛ اُس کا بھایٔی مَر چُکاہے اَور صِرف وُہی باقی رہ گیا ہے۔ جِس سفر پر تُم جا رہے ہو اگر اُس کے دَوران اُسے کچھ ہو گیا تو تُم اِس بُوڑھے باپ کو نہایت غم کے ساتھ قبر میں اتاروگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ابھی قحط مُلک میں زوروں پر تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","اَور جَب وہ مِصر سے لایا ہُوا سَب اناج کھا چُکے تو اُن کے باپ نے اُن سے کہا، ”جاؤ اَور مِصر سے ہمارے لیٔے کچھ اَور اناج خرید لاؤ۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","لیکن یہُوداہؔ نے اُس سے کہا، ”اُس شخص نے ہمیں سختی سے تاکید کی تھی، ’اَپنے بھایٔی کو ساتھ نہ لایٔے تو تُم میرا چہرہ پھر سے نہ دیکھوگے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","اگر آپ ہمارے بھایٔی کو ہمارے ساتھ بھیج دیں گے تو ہم جا کر تمہارے لیٔے اناج خرید لائیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","لیکن اگر آپ نے اُسے نہ بھیجا تو ہم نہیں جایٔیں گے کیونکہ اُس شخص نے ہم سے کہا ہے، ’جَب تک تمہارا بھایٔی تمہارے ساتھ نہ آئے تو تُم میرا چہرہ پھر سے نہ دیکھوگے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","اِسرائیل نے پُوچھا، ”تُم نے اُس شخص کو یہ بتا کر کہ تمہارا ایک اَور بھایٔی بھی ہے مُجھ پر یہ مُصیبت کیوں برپا کر دی؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","اُنہُوں نے جَواب دیا، ”اُس شخص نے ہم سے ہمارے اَور ہمارے رشتہ داروں کے بارے میں خُوب تفتیش کرکے پُوچھا، ’کیا تمہارا باپ اَب تک زندہ ہے اَور کیا تمہارا کویٔی اَور بھایٔی بھی ہے؟‘ ہم نے تو صِرف اُن کے سوالوں کے جَواب دئیے کہ بھلا ہم یہ کیسے جانتے کہ وہ کہے گا، ’اَپنے بھایٔی کو یہاں لے آؤ؟‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","تَب یہُوداہؔ نے اَپنے باپ اِسرائیل سے کہا، ”اِس لڑکے کو میرے ساتھ بھیج دیجئے اَور ہم فوراً چلے جایٔیں گے ورنہ ہم اَور آپ اَور ہمارے بال بچّے زندہ نہ بچ سکیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","میں خُود اُس کی سلامتی کا ضامن ہُوں؛ آپ مُجھے اُس کی حِفاظت کا ذمّہ دار سمجھئے! اگر مَیں اُسے واپس لاکر یہاں تمہارے سامنے کھڑا نہ کر دُوں تو میں عمر بھر آپ کا مُجرم ٹھہروں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","سچ تو یہ ہے کہ اگر ہم دیر نہ لگاتے تو دوبارہ جا کر کبھی کے لَوٹ آئے ہوتے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","تَب اُن کے باپ اِسرائیل نے اُن سے کہا، ”اگر یہی بات ہے تو اَیسا کرو، کہ اِس مُلک کی بہترین پیداوار میں سے چند چیزیں اَپنے بوروں میں رکھ لو اَور اُنہیں اُس شخص کے لیٔے تحفہ کے طور پر لے جاؤ۔ مثلاً تھوڑا سا روغن بلسان اَور تھوڑا سا شہد، کچھ گرم مَسالے اَور مُر پِستے اَور بادام ");
INSERT INTO urdoucv_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","اَور چاندی کی دوگنی مقدار اَپنے ساتھ لے جاؤ کیونکہ تُمہیں وہ چاندی بھی لَوٹانی ہوگی جو تمہارے بوروں میں رکھی گئی تھی۔ شاید غلطی سے اَیسا ہُوا ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","اَور اَپنے بھایٔی کو بھی ساتھ لے لو اَور فوراً اُس آدمی کے پاس چلے جاؤ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","اَور قادرمُطلق خُدا اُس شخص کو تُم پر مہربان کرے تاکہ وہ تمہارے دُوسرے بھایٔی اَور بِنیامین کو تمہارے ساتھ واپس آنے دے۔ جہاں تک میرا تعلّق ہے اگر مُجھے اُن کا ماتم کرنا پڑا تو کروں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","چنانچہ وہ تحفے اَور چاندی کی دوگنی مقدار اَور بِنیامین کو بھی ساتھ لے کر جلدی سے مِصر پہُنچے اَور یُوسیفؔ کے سامنے حاضِر ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","جَب یُوسیفؔ نے بِنیامین کو اُن کے ساتھ دیکھا تو یُوسیفؔ نے اَپنے گھر کے منتظم سے کہا، ”اِن آدمیوں کو میرے گھر لے جاؤ اَور ایک جانور ذبح کرکے کھانا تیّار کرو کیونکہ یہ لوگ دوپہر کو میرے ساتھ کھانا کھایٔیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","تَب اُس شخص نے یُوسیفؔ کے کہنے کے مُطابق کیا اَور اُن آدمیوں کو یُوسیفؔ کے محل میں لے گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","جَب وہ آدمی یُوسیفؔ کے محل میں پہُنچے تو اُن پر خوف طاری تھا۔ اُنہُوں نے سوچا، ”جو چاندی پہلی بار ہمارے بوروں میں واپس رکھ دی گئی تھی اُسی کی وجہ سے ہمیں یہاں لایا گیا ہے۔ وہ ہم پر حملہ کرنا چاہتے ہیں تاکہ ہم پر غالب آکر ہمیں غُلام بنا لیں اَور ہمارے گدھوں کو چھین لیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","چنانچہ وہ یُوسیفؔ کے منتظم کے پاس گیٔے اَور محل کے دروازہ پر اُن سے کہنے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","اُنہُوں نے عرض کیا، ”ہمیں مُعاف کریں میرے آقا، ہم پہلے بھی یہاں اناج خریدنے آئےتھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","لیکن واپس جاتے وقت جَب ہم نے رات کو اَپنی شب گزاری کے مقام پر اَپنے بورے کھولے تو ہم نے دیکھا کہ ہماری چاندی پُوری کی پُوری ہمارے بوروں کے اَندر رکھی ہُوئی ہے۔ اِس لئے اَب ہم اُسے اَپنے ساتھ لے کر واپس آئے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","اَور ہم مزید اناج خریدنے کے لیٔے اَور چاندی بھی اَپنے ساتھ لایٔے ہیں۔ ہم نہیں جانتے کہ پچھلی دفعہ ہماری چاندی ہمارے بوروں میں کیسے پہُنچ گئی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","خادِم نے اُن سے کہا، ”تُم اُس کی فکر مت کرو، ڈرو نہیں، تمہارے خُدا اَور تمہارے باپ کے خُدا نے تمہارے بوروں میں تُمہیں خزانہ دیا ہوگا۔ مُجھے تو تمہاری چاندی مِل چُکی۔“ تَب وہ شمعُونؔ کو اُن کے پاس باہر لے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","پھر یُوسیفؔ کے منتظم اُن آدمیوں کو اَندر محل میں لے گئے اَور اُنہیں پاؤں دھونے کے لیٔے پانی دیا اَور اُن کے گدھوں کے لیٔے چارے کا اِنتظام کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","اَور اُنہُوں نے دوپہر کو یُوسیفؔ کے آنے تک اَپنے اَپنے تحفے تیّار کر لیٔے کیونکہ اُنہیں بتایا گیا تھا کہ وہ لوگ بھی وہیں کھانا کھایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","جَب یُوسیفؔ گھر آئے تو اُنہُوں نے وہ تحفے اُسے پیش کئے جنہیں وہ محل میں لایٔے تھے اَور اُنہُوں نے زمین پر جھُک کر اُن کو سلام کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","یُوسیفؔ نے اُن کی خیریت دریافت کی اَور کہا، ”تمہارے ضعیف باپ جِن کا تُم نے ذِکر کیا تھا کیسے ہیں؟ کیا وہ اَب تک زندہ ہیں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","اُنہُوں نے جَواب دیا، ”آپ کا خادِم ہمارے باپ اَب تک زندہ ہیں اَور خیریت سے ہیں۔“ اَور اُنہُوں نے سَر جھُکا جھُکا کر اُن کو سلام کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","جَب یُوسیفؔ نے آنکھ اُٹھاکر اَپنے بھایٔی بِنیامین کو دیکھا جو اُن کی اَپنی ماں کا بیٹا تھا تو پُوچھا، ”کیا یہ تمہارا چھوٹا بھایٔی ہے جِس کا ذِکر تُم نے مُجھ سے کیا تھا؟“ پھر کہا، ”اَے میرے بیٹے خُدا تُم پر مہربان رہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","اَپنے بھایٔی کو دیکھ کر یُوسیفؔ کا دِل بھر آیا۔ لہٰذا وہ جلدی سے باہر نکلے تاکہ کسی جگہ جا کر روسکیں۔ تَب وہ اَپنے کمرے میں جا کر رونے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","پھر وہ اَپنا مُنہ دھوکر باہر آئے اَور ضَبط سے کام لیتے ہویٔے کہا، ”کھانا پیش کرو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","تَب یُوسیفؔ نے اُن کے لیٔے الگ، اُس کے بھائیوں کے لیٔے الگ اَورجو مِصری اُن کے ساتھ کھاتے تھے اُن کے لیٔے الگ کھانا پیش کیا کیونکہ مِصری عِبرانیوں کے ساتھ کھانا کھانے سے سخت نفرت کرتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","اُن آدمیوں کو یُوسیفؔ کے سامنے پہلوٹھے سے لے کر چُھوٹے تک اُن کی عمر کے مُطابق ترتیب وار بِٹھایا گیا تھا اَور وہ ایک دُوسرے کی طرف حیرت سے دیکھ رہے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","جَب یُوسیفؔ کی میز سے اُن کے لیٔے کھانا پیش کیا گیا تو بِنیامین کا حِصّہ دُوسروں کے حِصّوں سے پانچ گُنا زِیادہ تھا اَور اُنہُوں نے یُوسیفؔ کے ساتھ کھایا پیا اَور خُوشی منائی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","پھر یُوسیفؔ نے اَپنے گھر کے منتظم کو یہ ہدایات دیں: ”جِتنا اناج یہ لوگ لے جا سکیں اُن کے بوروں میں بھر دیا جائے اَور ہر ایک کی چاندی بھی اُس کے بورے کے مُنہ میں رکھ دی جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","اَور میرا چاندی کا پیالہ سَب سے چُھوٹے کے بورے میں اُس کے اناج کے مُعاوضہ کی چاندی کے ساتھ رکھ دینا۔“ چنانچہ منتظم نے یُوسیفؔ کے کہنے کے مُطابق عَمل کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","جَب صُبح ہُوئی تو اُن آدمیوں کو اُن کے گدھوں سمیت رخصت کیا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","وہ شہر سے زِیادہ دُور بھی نہ جانے پایٔے تھے کہ یُوسیفؔ نے اَپنے منتظم سے کہا، ”فوراً اُن آدمیوں کا پیچھا کرو اَور جَب تُم اُنہیں پا لو تو اُن سے کہنا، ’تُم نے نیکی کے عِوض بدی کیوں کی؟ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","کیا یہ وُہی پیالہ نہیں جِس سے میرے آقا پیتے ہیں اَور اِس سے فال بھی کھولتے ہیں؟ یہ تُم نے نہایت بُرا کام کیا ہے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","جَب منتظم نے اُنہیں جا لیا تو یہ باتیں اُن کے سامنے کہہ دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","لیکن اُنہُوں نے جَواب دیا، ”ہمارے آقا اَیسی باتیں کیوں کہتے ہیں؟ تمہارے خادِموں سے اَیسے فعل کا سرزد ہونا بعید رہے! ");
INSERT INTO urdoucv_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ہم مُلکِ کنعانؔ سے وہ چاندی بھی واپس لے آئے جو ہمارے بوروں کے مُنہ میں ہمیں مِلی تھی۔ پھر بھلا ہم آپ کے آقا کے گھر سے چاندی یا سونا کیوں چُراتے؟ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","لہٰذا آپ کے خادِموں میں سے جِس کسی کے پاس چاندی کا پیالہ ملے وہ مار ڈالا جائے اَور ہم میں سے باقی اَپنے آقا کے غُلام ہو جایٔیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","منتظم نے کہا، ”ٹھیک ہے، جو تُم کہتے ہو وُہی صحیح۔ جِس کسی کے پاس وہ پیالہ نکل آئے وہ میرا غُلام ہوگا اَور باقی بے قُصُور ٹھہروگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","تَب ہر ایک نے جلدی سے اَپنا اَپنا بورا زمین پر اُتارا اَور اُسے کھول دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","تَب منتظم نے بڑے سے لے کر چُھوٹے تک ہر ایک کے بورے کی تلاشی لی اَور پیالہ بِنیامین کے بورے میں سے برآمد ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","اِس پر اُنہُوں نے اَپنے کپڑے پھاڑ ڈالے اَور اَپنے اَپنے گدھوں کو لاد کر شہر کی طرف واپس چل دئیے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","یُوسیفؔ ابھی گھر میں ہی تھے کہ یہُوداہؔ اَور اُن کے بھایٔی آ گئے اَور وہ یُوسیفؔ کے سامنے زمین پر گِر پڑے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","یُوسیفؔ نے اُن سے کہا، ”یہ تُم نے کیا کیا؟ کیا تُم نہیں جانتے کہ میں وہ شخص ہُوں جو فال کے ذریعہ غیب کی باتیں بھی جان لیتا ہُوں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","یہُوداہؔ نے جَواب دیا، ”ہم اَپنے آقا سے کیا کہیں؟ ہم کہہ بھی کیا سکتے ہیں؟ ہم اَپنی بےگُناہی کیسے ثابت کریں؟ خُدا نے آپ کے خادِموں کا جُرم بے پردہ کر دیا۔ اَب ہم اَپنے آقا کے غُلام ہیں۔ ہم سَب اَور جِس کے پاس یہ پیالہ نِکلا وہ بھی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","لیکن یُوسیفؔ نے کہا، ”خُدا نہ کرے کہ میں اَیسا کروں! صِرف وُہی آدمی جِس کے پاس یہ پیالہ نِکلا میرا غُلام ہوگا۔ باقی سَب اَپنے باپ کے پاس سلامت جا سکتے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","تَب یہُوداہؔ نے یُوسیفؔ کے پاس جا کر مِنّت کی: ”اَے میرے آقا! آپ اَپنے خادِم کو اَپنے آقا سے ایک بات کہنے کی اِجازت دیجئے۔ اَپنے خادِم سے خفا نہ ہو کیونکہ آپ خُود فَرعوہؔ کے برابر ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","میرے آقا نے اَپنے خادِموں سے یہ پُوچھا تھا، ’کیا تمہارے باپ یا کویٔی بھایٔی ہیں؟‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","اَور ہم نے اَپنے آقا کو جَواب دیا تھا،‏‏ ’ہمارے ایک ضعیف باپ ہیں اَور اُن کے بُڑھاپے کا ایک چھوٹا بیٹا بھی ہے جِس کا بھایٔی مَر چُکاہے۔ اَور اَپنی ماں کی اَولاد میں سے وُہی اکیلا رہ گیا ہے۔ اَور اُس کا باپ اُس سے بےحد مَحَبّت رکھتا ہے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","”تَب آپ نے اَپنے خادِموں سے کہاتھا، ’اُسے میرے پاس لاؤ تاکہ میں بھی اُسے دیکھ لُوں۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","اَور ہم نے اَپنے آقا سے کہا، ’وہ لڑکا اَپنے باپ کو چھوڑ نہیں سَکتا کیونکہ اگر وہ اُس سے جُدا ہوگا تو اُس کا باپ زندہ نہ رہ سکےگا۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","لیکن آپ نے اَپنے خادِموں سے کہاتھا، ’جَب تک تمہارا چھوٹا بھایٔی تمہارے ساتھ نہیں آتا، تُم میرا چہرہ پھر سے نہ دیکھوگے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","جَب ہم اَپنے باپ کے پاس جو آپ کا خادِم ہے، لَوٹے تو ہم نے اُن سے اَپنے آقا کی باتیں کہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","”تَب ہمارے باپ نے کہا، ’دوبارہ جاؤ اَور مِصر سے ہمارے لیٔے کچھ اناج خرید لاؤ۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","لیکن ہم نے کہا، ’ہم نہیں جا سکتے اگر ہمارا سَب سے چھوٹا بھایٔی ہمارے ساتھ ہوگا تبھی ہم جایٔیں گے؛ اُس شخص نے ہمیں سختی سے تاکید کی تھی کہ جَب تک تمہارا چھوٹا بھایٔی تمہارے ساتھ نہ آئے تو تُم میرا چہرہ نہ دیکھوگے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","”اَور تمہارے خادِم ہمارے باپ نے ہم سے کہا، ’تُم جانتے ہو کہ میری بیوی کے مُجھ سے دو بیٹے پیدا ہویٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","اُن میں سے ایک مُجھ سے جُدا ہو گیا اَور مَیں نے کہا، ”اُسے ضروُر کسی درندہ نے پھاڑ کھایا ہے۔“ اَور تَب سے مَیں نے اُسے نہیں دیکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","اَور اگر تُم بِنیامین کو بھی میرے پاس سے لے گیٔے اَور اُسے کچھ ہو گیا تو تُم اَپنے بُوڑھے باپ کو بڑے غم کے ساتھ قبر میں اتاروگے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","”لہٰذا جَب مَیں تمہارے خادِم، اَپنے باپ کے پاس اِس لڑکے کے بغیر واپس جاؤں گا اَور اگر وہ، جِس کی جان اِس لڑکے کی جان سے وابستہ ہے، ");
INSERT INTO urdoucv_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","دیکھیں گے کہ اُن کا بیٹا واپس نہیں آیا تو اُن کی تو جان ہی نکل جائے گی اَور ہم تمہارے خادِم اَپنے غمزدہ بُوڑھے باپ کے قبر میں اُتارے جانے کا باعث ہوں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","آپ کے خادِم نے اِس لڑکے کی سلامتی کی اَپنے باپ کو ضمانت دے رکھی ہے۔ مَیں نے اَپنے باپ سے کہاتھا، ’اگر مَیں اِس لڑکے کو تمہارے پاس واپس نہ لایا تو عمر بھر آپ کا مُجرم ٹھہروں گا۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","”چنانچہ خادِم کو اَپنے آقا کا غُلام بَن کر یہاں رہنے کی اِجازت دیجئے اَور اِس لڑکے کو اَپنے بھائیوں کے ساتھ لَوٹ جانے دیجئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","کیونکہ اِس لڑکے کے بغیر میں اَپنے باپ کے پاس کیا مُنہ لے کر واپس جاؤں؟ اگر گیا تو مُجھ سے اَپنے باپ کی تکلیف نہ دیکھی جائے گی!“ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","تَب یُوسیفؔ اَپنے سارے خدمت گاروں کے سامنے خُود کو ضَبط نہ کر سکے اَور یُوسیفؔ نے چِلّاکر کہا، ”سَب کو یہاں سے نکال دو!“ تَب یُوسیفؔ نے اَپنے آپ کو اَپنے بھائیوں پر ظاہر کیا اَور اُس وقت اُن کے خدمت گاروں میں سے کویٔی یُوسیفؔ کے پاس نہ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","اَور وہ اِس قدر زور زور سے روئے کہ مِصریوں نے اُن کے رونے کی آواز سُنی اَور فَرعوہؔ کے گھر والوں کو بھی اِس بات کی خبر ہو گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","یُوسیفؔ نے اَپنے بھائیوں سے کہا، ”میں یُوسیفؔ ہُوں! کیا میرے باپ اَب تک زندہ ہیں؟“ لیکن اُن کے بھائیوں کے مُنہ سے جَواب میں ایک لفظ بھی نہ نِکلا کیونکہ وہ یُوسیفؔ کے سامنے خوفزدہ ہو گئے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","تَب یُوسیفؔ نے اَپنے بھائیوں سے کہا، ”میرے قریب آؤ۔“ اَور جَب وہ اُن کے قریب آئے تو یُوسیفؔ نے کہا، ”میں تمہارا بھایٔی یُوسیفؔ ہُوں، جسے تُم نے مِصریوں کے ہاتھ بیچا تھا! ");
INSERT INTO urdoucv_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","اَور میرے یہاں بیچے جانے کے باعث اَب تُم نہ تو اَپنے دِل میں پریشان ہو اَور نہ اَپنے آپ پر خفا ہو؛ کیونکہ خُدا نے مُجھے تُم سے آگے یہاں بھیجا تاکہ میں کیٔی لوگوں کی جانیں بچا سکوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","اِس لیٔے کہ اَب دو سال سے مُلک میں قحط پڑا ہُواہے اَور آئندہ پانچ سالوں تک نہ ہل چلیں گے اَور نہ فصل کٹے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","لیکن خُدا نے مُجھے تمہارے آگے بھیجا تاکہ تمہارے وہ لوگ جو باقی بچے ہیں زمین پر سلامت رہیں اَور ایک بڑی نَجات کے وسیلہ سے تمہاری جانیں بچی رہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","”چنانچہ وہ تُم نہ تھے، بَلکہ خُدا، جِس نے مُجھے یہاں بھیجا۔ اُن ہی نے مُجھے گویا فَرعوہؔ کا باپ، اُس کے سارے گھر کا مختار اَور سارے مُلک مِصر کا حاکم بنا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","اَب تُم جلد میرے باپ کے پاس جاؤ اَور اُن سے کہنا، ’تمہارا بیٹا یُوسیفؔ یُوں کہتاہے کہ خُدا نے مُجھے سارے مُلک مِصر کا مالک بنا دیا ہے؛ لہٰذا فوراً میرے پاس چلے آؤ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","آپ لوگ گوشینؔ کے علاقہ میں بس جانا تاکہ تُم اَپنے بیٹے پوتوں اَور اَپنی بھیڑ بکریوں کے گلّوں گائے بَیلوں اَور اَپنے تمام مال و متاع سمیت میرے نزدیک رہ سکو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","میں وہاں آپ کی پرورِش کا سارا اِنتظام کروں گا، تاکہ آپ اَور آپ کا گھرانہ اَور سارا مال و متاع جو آپ کا ہے غربت کا شِکار نہ ہو کیونکہ قحط کے ابھی پانچ سال اَور باقی ہیں۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","”آپ لوگ خُود اَور میرا بھایٔی بِنیامین بھی اَپنی آنکھوں سے دیکھ سکتے ہو کہ واقعی میں ہی تُم سے بات کر رہا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","مُلک مِصر میں مُجھے جِتنا اِعزاز و اِحترام بخشا گیا ہے اَورجو کچھ تُم نے دیکھاہے اُس کا تذکرہ میرے باپ سے کرنا اَور اُنہیں اَپنے ساتھ لے کر جلدی سے میرے پاس چلے آنا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","پھر وہ اَپنے بھایٔی بِنیامین کو اَپنی باہوں میں لے کر روئے اَور بِنیامین بھی اُن کے گلے لگ کر رو دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","یُوسیفؔ نے اَپنے سَب بھائیوں کو چُوما اَور اُن سے مِل کر روئے۔ اُس کے بعد اُن کے بھایٔی بھی یُوسیفؔ کے ساتھ بات چیت کرنے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","جَب یہ خبر فَرعوہؔ کے محل تک پہُنچی کہ یُوسیفؔ کے بھایٔی آئے ہیں تو فَرعوہؔ اَور اُس کے خدمت گار بہت خُوش ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","فَرعوہؔ نے یُوسیفؔ سے کہا، ”اَپنے بھائیوں سے کہو، ’اَب ایک کام کرو کہ اَپنے جانوروں پر اناج لاد کر مُلکِ کنعانؔ کو لَوٹ جاؤ، ");
INSERT INTO urdoucv_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","اَور اَپنے باپ اَور اَپنے اَپنے خاندانوں کو میرے پاس لے آؤ۔ میں تُمہیں مُلک مِصر کی بہترین نِعمتیں بخشوں گا اَور تُم اِس مُلک کی عُمدہ سے عُمدہ چیزوں سے لُطف اَندوز ہو سکوگے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","”اَور یُوسیفؔ تُمہیں حُکم دیا جاتا ہے، ’اُن سے یہ بھی کرنے کے لیٔے کہو: مِصر سے چند گاڑیاں بھی اَپنے ساتھ لیتے جاؤ اَور اُن میں اَپنے باپ، اَپنی بیویوں اَور اَپنے بچّوں کو سوار کرکے یہاں لے آؤ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","اَپنے مال و اَسباب کی پروا نہ کرو کیونکہ تمام مِصر کی بہترین اَشیا تمہاری ہُوں گی۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","چنانچہ اِسرائیل کے بیٹوں نے اَیسا ہی کیا۔ یُوسیفؔ نے فَرعوہؔ کے حُکم کے مُطابق اُنہیں گاڑیاں دیں اَور توشہ سفر بھی دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","اُن میں سے ہر ایک کو ایک ایک جوڑا کپڑا دیا لیکن بِنیامین کو تین سَو ثاقل چاندی کے سِکّے اَور پانچ جوڑے کپڑے دئیے ");
INSERT INTO urdoucv_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","اَور اَپنے باپ کے لیٔے یُوسیفؔ نے یہ چیزیں بھیجیں: دس گدھے جو مِصر کی بہترین چیزوں سے لدے ہویٔے تھے اَور دس گدھیاں جو اناج، روٹی اَور اُن کے سفر کے دَوران توشہ کے طور پر دُوسری اَشیا سے لدی ہُوئی تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","تَب یُوسیفؔ نے اَپنے بھائیوں کو رخصت کیا اَور جَب وہ روانہ ہویٔے تو اُن سے کہا، ”راستہ میں کہیں جھگڑا نہ کرنا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","چنانچہ وہ مِصر سے روانہ ہویٔے اَور مُلکِ کنعانؔ میں اَپنے باپ یعقوب کے پاس چلے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","اَور اُنہُوں نے باپ سے کہا، ”یُوسیفؔ اَب تک زندہ ہے۔ وہ واقعی سارے مُلک مِصر کا حاکم ہے۔“ یہ سُن کر یعقوب کا دِل دھک سے رہ گیا۔ اُنہُوں نے اَپنے بیٹوں کی باتوں کا یقین نہ کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","لیکن جَب اُنہُوں نے یعقوب کو وہ سَب باتیں بتائیں جو یُوسیفؔ نے اُن سے کہی تھیں اَور جَب یعقوب نے وہ گاڑیاں دیکھیں جو یُوسیفؔ نے اُن کو لے جانے کو بھیجی تھیں تَب اُن کے باپ یعقوب کی جان میں جان آئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","اَور اِسرائیل نے کہا، ”مُجھے یقین ہو گیا کہ میرا بیٹا یُوسیفؔ اَب تک زندہ ہے۔ اَب تو میں اَپنے مرنے سے پیشتر جا کر اُسے دیکھ لُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","تَب اِسرائیل اَپنا سَب کچھ لے کر روانہ ہُوئے اَور جَب وہ بیرشبعؔ پہُنچے تو اُنہُوں نے اَپنے باپ اِصحاقؔ کے خُدا کے لیٔے قُربانیاں گزرانیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","اَور خُدا نے رات کو رُویا میں اِسرائیل سے باتیں کیں اَور کہا، ”اَے یعقوب! اَے یعقوب!“ اُنہُوں نے جَواب دیا، ”مَیں حاضِر ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","اُنہُوں نے کہا، ”میں خُدا تمہارے باپ کا خُدا ہُوں؛ مِصر میں جانے سے نہ ڈر کیونکہ مَیں وہاں تُم سے ایک بڑی قوم پیدا کروں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","مَیں تمہارے ساتھ مِصر چلُوں گا اَور پھر وہاں سے میں تُمہیں واقعی واپس بھی لے آؤں گا اَور تمہاری موت پر یُوسیفؔ کے اَپنے ہاتھ تمہاری آنکھیں بند کریں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","تَب اِسرائیل بیرشبعؔ سے روانہ ہُوئے اَور اِسرائیل کے بیٹے اَپنے باپ یعقوب اَور اَپنے بال بچّوں اَور اَپنی بیویوں کو اُن گاڑیوں میں لے کر گیٔے جو فَرعوہؔ نے اُن کی سواری کے لیٔے بھیجی تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","اَور وہ اَپنے مویشیوں اَور سارے مال و اَسباب کو بھی ساتھ لے گیٔے جو اُنہُوں نے مُلکِ کنعانؔ میں جمع کیا تھا اَور یعقوب اَپنی ساری اَولاد سمیت مِصر چلےگئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","وہ اَپنے بیٹوں، پوتوں اَور اَپنی بیٹیوں اَور پوتیوں غرض اَپنی کُل نَسل کو اَپنے ساتھ مِصر لے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","اِسرائیل کے بیٹے اَور پوتے وغیرہ جو مِصر میں آئے اُن کے نام یہ ہیں: رُوبِنؔ جو یعقوب کا پہلوٹھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","رُوبِنؔ کے بیٹے: حنوخؔ، پلوّؔ، حِضرونؔ اَور کرمی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","شمعُونؔ کے بیٹے: یموایلؔ، یمینؔ، اُہدؔ، یاکِن، ضُحرؔ اَور شاؤل جو ایک کنعانی عورت سے پیدا ہُوا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","بنی لیوی یہ ہیں: گیرشون قُہات اَور مِراریؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","یہُوداہؔ کے بیٹے: عیرؔ، اَونانؔ، شِلحؔ، پیریزؔ اَور زیراحؔ (لیکن عیرؔ اَور اَونانؔ مُلکِ کنعانؔ میں وفات پا چُکے تھے)۔ پیریزؔ کے بیٹے: حِضرونؔ اَور حمُولؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","یِسَّکاؔر کے بیٹے: تولعؔ، پُوعہ یا پُوّہؔ، یَعشُوبؔ اَور شِمرون۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","زبُولُون کے بیٹے: سرد، ایلون اَور یحلی ایل۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","لِیاہؔ کے بیٹے جو یعقوب سے فدّان ارام میں اُس کی بیٹی دینؔہ کے علاوہ پیدا ہویٔے تھے یہی ہیں۔ اُس کے یہ بیٹے اَور بیٹیاں کُل تینتیس تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","گادؔ کے بیٹے: ضِفونؔ، حگّیؔ، شُونی، اِضبُنؔ، عیری، اَرودی اَور اَریلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","آشیر کے بیٹے: یِمنہؔ، اِشواہؔ، اِشویؔ اَور بریعہؔ اَور اُن کی بہن سراحؔ تھی۔ بریعہؔ کے بیٹے: حِبرؔ اَور مَلکی ایل۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","یہ سَب یعقوب کے اُن بیٹوں کی اَولاد ہیں جو زِلفہؔ سے پیدا ہویٔے جسے لابنؔ نے اَپنی بیٹی لِیاہؔ کو دیا تھا۔ وہ شُمار میں سولہ تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","یعقوب کی بیوی راخلؔ کے بیٹے: یُوسیفؔ اَور بِنیامین۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","یُوسیفؔ سے مُلک مِصر میں اَونؔ کے کاہِنؔ پُطیفرعؔ کی بیٹی آسِناتھؔ کے ہاں منشّہ اَور اِفرائیمؔ پیدا ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","بِنیامین کے بیٹے: بَیلعؔ، بِکیؔر، اَشبیلؔ، گیراؔ، نَعمانؔ، اِخیؔ، رَوشؔ، مُپّیم، حُفّیمؔ اَور اردؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","یہ سَب یعقوب کے اُن بیٹوں کی اَولاد ہیں جو راخلؔ سے پیدا ہویٔے جو شُمار میں چودہ تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","اَور دانؔ کے بیٹے کا نام: حُوشیمؔ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","نفتالی کے بیٹے: یحصیل گُونی، یصرؔ اَور شِلّیمؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","یہ سَب یعقوب کے اُن بیٹوں کی اَولاد ہیں جو بِلہاہؔ سے پیدا ہویٔے جسے لابنؔ نے اَپنی بیٹی راخلؔ کو دیا تھا۔ وہ شُمار میں سات تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","یعقوب کی اَپنی نَسل کے جو لوگ اُن کے ساتھ مِصر گیٔے جِن میں اُن کی بہوؤں کا شُمار نہیں ہے کُل چھیاسٹھ آدمی تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","اُن دو بیٹوں کے ساتھ جو یُوسیفؔ کے مِصر میں پیدا ہویٔے یعقوب کے خاندان کے اُن افراد کی کُل تعداد جو مِصر گیٔے ستّر تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","یعقوب نے یہُوداہؔ کو اَپنے آگے یُوسیفؔ کے پاس بھیجا تاکہ وہ مَعلُوم کرے کہ گوشینؔ جانے والا راستہ کون سا ہے۔ جَب وہ گوشینؔ کے علاقہ میں پہُنچے تو ");
INSERT INTO urdoucv_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","یُوسیفؔ نے اَپنا رتھ تیّار کروایا اَور اَپنے باپ اِسرائیل سے مِلنے کے لیٔے گوشینؔ کی طرف روانہ ہُوئے۔ جوں ہی یُوسیفؔ نے اَپنے باپ کو دیکھا وہ اُن سے بغل گیر ہوکر بڑی دیر تک روتے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","اِسرائیل نے یُوسیفؔ سے کہا، ”اَب موت بھی آ جائے تو مُجھے منظُور ہے کیونکہ مَیں نے اَپنی آنکھوں سے دیکھ لیا کہ تُم ابھی تک زندہ ہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","تَب یُوسیفؔ نے اَپنے بھائیوں اَور اَپنے باپ کے گھرانے کے لوگوں سے کہا، ”میں جا کر فَرعوہؔ سے بات کروں گا اَور کہُوں گا، ’میرے بھایٔی اَور میرے باپ کا خاندان جو مُلکِ کنعانؔ میں رہا کرتے تھے میرے پاس آ گئے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","وہ لوگ چرواہے ہیں اَور مویشی پالتے ہیں اَور وہ اَپنے ساتھ اَپنی بھیڑ بکریوں کے گلّے اَور مویشیوں کو اَورجو کچھ اُن کی مِلکیّت ہے سَب لے کر آ گئے ہیں۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","جَب فَرعوہؔ تُمہیں اَندر بُلائے اَور پُوچھے، ’تمہارا پیشہ کیا ہے؟‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","تو تُم جَواب دینا، ’تمہارا خادِم اَپنے آباؤاَجداد کی طرح لڑکپن ہی سے گلّہ بان ہیں۔‘ تَب تُمہیں گوشینؔ کے علاقہ میں بس جانے کی اِجازت دے دی جائے گی کیونکہ مِصری تمام گلّے بانوں کو نفرت کی نگاہ سے دیکھتے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","یُوسیفؔ نے جا کر فَرعوہؔ سے کہا، ”میرا باپ اَور بھایٔی اَپنی بھیڑ بکریوں کے گلّوں اَور مویشیوں کے ریوڑوں اَور اَپنے تمام مال و اَسباب کے ساتھ کنعانؔ کے مُلک سے آ گیٔے ہیں اَور اِس وقت گوشینؔ میں ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","اُس نے اَپنے بھائیوں میں سے پانچ کو چُن کر اُنہیں فَرعوہؔ کے سامنے پیش کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","فَرعوہؔ نے اُن بھائیوں سے پُوچھا، ”تمہارا پیشہ کیا ہے؟“ اُنہُوں نے فَرعوہؔ کو جَواب دیا، ”تمہارے خادِم گلّہ بان ہیں، جَیسے ہمارے آباؤاَجداد تھے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","اُنہُوں نے فَرعوہؔ سے یہ بھی کہا، ”ہم یہاں کچھ عرصہ کے لیٔے رہنے آئے ہیں کیونکہ مُلکِ کنعانؔ میں سخت قحط پڑا ہُواہے اَور تمہارے خادِموں کے پاس کویٔی مویشیوں کی چراگاہ نہیں ہے۔ لہٰذا براہِ کرم اَپنے خادِموں کو گوشینؔ میں بس جانے کی اِجازت دے دیجئے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","فَرعوہؔ نے یُوسیفؔ سے کہا، ”تمہارا باپ اَور تمہارے بھایٔی تمہارے پاس آ گیٔے ہیں ");
INSERT INTO urdoucv_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","اَور مِصر کا سارا مُلک تمہارے سامنے ہے۔ لہٰذا اَپنے باپ اَور بھائیوں کو مُلک کے بہترین علاقہ میں بسا دو۔ اُنہیں گوشینؔ میں بسنے دو اَور تمہاری دانست میں اُن میں جو لوگ قابلِ اِعتبار ہُوں اُنہیں میرے اَپنے مویشیوں کا نِگراں مُقرّر کر دو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","تَب یُوسیفؔ نے اَپنے باپ یعقوب کو اَندر لاکر اُنہیں فَرعوہؔ کی خدمت میں پیش کیا اَور یعقوب نے فَرعوہؔ کو برکت دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","فَرعوہؔ نے یعقوب سے پُوچھا، ”تیری عمر کیا ہے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","یعقوب نے فَرعوہؔ سے کہا، ”میری زندگی کے سفر کے ایک سَو تیس بَرس پُورے ہو چُکے ہیں۔ میری زندگی کے ایّام نہایت مُختصر اَور بےحد دُکھ بھرے ہیں۔ میں ابھی اَپنے آباؤاَجداد کی عمر کو نہیں پہُنچا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","تَب یعقوب نے فَرعوہؔ کو برکت دی اَور اُن کے سامنے سے باہر نکل گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","اِس طرح یُوسیفؔ نے اَپنے باپ اَور بھائیوں کو مِصر میں آباد کیا اَور فَرعوہؔ کی ہدایات کے مُطابق مُلک کے بہترین علاقہ رَعمسیسؔ میں اُنہیں زمین اَور مکانات عطا فرمائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","یُوسیفؔ نے اَپنے باپ اَور اَپنے بھائیوں اَور اَپنے باپ کے سَب گھر والوں کے لیٔے اُن کے بچّوں کی تعداد کے مُطابق اشیائے خوردنی کا اِنتظام بھی کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","چونکہ قحط نہایت شدید تھا اِس لیٔے اُس پُورے علاقہ میں کھانے پینے کی چیزیں نہ تھیں اَور مِصر اَور کنعانؔ دونوں مُلک قحط کی وجہ سے تباہ ہو گئے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","اَور یُوسیفؔ نے اناج بیچ بیچ کر مِصر اَور کنعانؔ کے لوگوں سے حاصل کی ہُوئی ساری دولت جمع کی اَور اُسے فَرعوہؔ کے محل میں لے آیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","جَب مِصر اَور کنعانؔ کے لوگوں کا سارا رُوپیہ خرچ ہو گیا تو مِصر کے تمام باشِندے یُوسیفؔ کے پاس آکر کہنے لگے، ”ہمیں کچھ کھانے کو دے دیجئے ورنہ ہم آپ کی نظروں کے سامنے بھُوکوں مَر جایٔیں گے۔ ہمارا سارا رُوپیہ خرچ ہو چُکاہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","تَب یُوسیفؔ نے کہا، ”اَپنے مویشی لے آؤ اَور مَیں تُمہیں مویشیوں کے عِوض اناج بیچوں گا کیونکہ تمہارا رُوپیہ خرچ ہو چُکاہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","چنانچہ وہ اَپنے مویشی لے کر یُوسیفؔ کے پاس آئے اَور اُس نے اُن کے گھوڑوں، اُن کی بھیڑوں اَور بکریوں، اُن کے گائے بَیلوں اَور گدھوں کے عِوض اُنہیں اناج دیا اَور اُس سال اُن کے تمام مویشیوں کے عِوض اُنہیں اناج دے کر اُس نے اُنہیں فاقوں سے بچائے رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","جَب وہ سال گزر گیا تو اُن کے بھایٔی اگلے بَرس یُوسیفؔ کے پاس آئے اَور کہنے لگے، ”ہم اَپنے آقا سے اِس حقیقت کو چھُپا نہیں سکتے کہ ہمارا سارا رُوپیہ خرچ ہو چُکاہے اَور ہمارے سارے مویشی بھی آپ کے ہو چُکے ہیں؛ لہٰذا اَب ہمارے پاس ہمارے جِسم اَور ہماری زمین کے سِوا کچھ بھی باقی نہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","تمہارے ہوتے ہویٔے ہم کیوں ہلاک ہُوں اَور ہماری زمینیں اُجڑ جایٔیں؟ لہٰذا ہمیں اَور ہماری زمینوں کو اناج کے عِوض خرید لیں تاکہ ہم اَپنی زمینوں سمیت فَرعوہؔ کے غُلامی میں آ جایٔیں۔ ہمیں اناج دے دیجئے تاکہ ہم ہلاک ہونے سے بچ جایٔیں اَور مُلک بھی ویران نہ ہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","چنانچہ یُوسیفؔ نے مِصر کی تمام زمین فَرعوہؔ کے لیٔے خرید لی۔ تمام مِصریوں نے قحط سے تنگ آکر اَپنے اَپنے کھیت بیچ ڈالے۔ اِس طرح ساری زمین فَرعوہؔ کی ہو گئی ");
INSERT INTO urdoucv_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","اَور یُوسیفؔ نے مِصر کے ایک سِرے سے دُوسرے سِرے تک رہنے والے شہر کے تمام لوگوں کو غُلامی کے درجہ تک پہُنچا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","لیکن وہ کاہِنوں کی زمین نہ خرید سَکا کیونکہ اُنہیں فَرعوہؔ کی طرف سے باقاعدہ رسد ملتی تھی اَور اُس رسد میں سے اُن کے پاس کافی مقدار میں اشیائے خوردنی مَوجُود تھیں۔ اِسی وجہ سے اُنہُوں نے اَپنی زمین نہیں بیچی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","تَب یُوسیفؔ نے لوگوں سے کہا، ”اَب جَب کہ آج کے دِن مَیں نے تُمہیں اَور تمہاری زمین کو فَرعوہؔ کے لیٔے خرید لیا ہے، اَب یہ بیج تمہارے لیٔے ہے تاکہ تُم اُسے زمین میں بو سکو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","لیکن جَب فصل اُگ آئے تو اُس کا پانچواں حِصّہ فَرعوہؔ کو دینا اَور باقی کے چار حِصّے تُم رکھ لینا تاکہ وہ کھیتوں میں بونے کے لیٔے بیج کے کام آئیں اَور تمہارے اَپنے اَور تمہارے گھرانے اَور تمہارے بچّوں کے لیٔے کھانے کو ہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","اُنہُوں نے کہا، ”آپ نے ہماری جانیں بچائیں۔ ہمارے آقا کی مہربانی ہم پر رہے۔ ہم فَرعوہؔ کے غُلام بنے رہیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","اَور یُوسیفؔ نے مِصر کی زمین کے لیٔے یہ آئین بنا دیا جو آج تک رائج ہے کہ پیداوار کا پانچواں حِصّہ فَرعوہؔ کا ہوگا۔ صِرف کاہِنوں کی زمین ہی فَرعوہؔ کی مِلکیّت نہ سَمجھی جائے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","اَور اِسرائیلی مِصر میں گوشینؔ کے علاقہ میں آباد ہو گئے۔ اُنہُوں نے وہاں جائدادیں کھڑی کر لیں اَور پھلے پھُولے اَور تعداد میں بہت ہی بڑھ گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","اَور یعقوب مُلک مِصر میں سترہ سال اَور زندہ رہے اَور اُن کی کُل عمر ایک سَو سینتالیس سال کی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","جَب اِسرائیل کے مرنے کا وقت قریب آیا تو اُنہُوں نے اَپنے بیٹے یُوسیفؔ کو بُلایا اَور اُن سے فرمایا، ”اگر مُجھ پر آپ کی نظرِکرم ہُوئی ہے تو اَپنا ہاتھ میری ران کے نیچے رکھو اَور وعدہ کرو کہ تُم میرے ساتھ مہربانی اَور وفاداری سے پیش آؤگے۔ مُجھے مِصر میں دفن نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","بَلکہ جَب مَیں اَپنے آباؤاَجداد کے ساتھ سو جاؤں تو مُجھے مِصر سے لے جا کر وہیں دفن کردینا جہاں وہ مدفون ہیں۔“ یُوسیفؔ نے کہا، ”جَیسا آپ نے کہا ہے، میں وَیسا ہی کروں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","یعقوب نے کہا، ”تُم مُجھ سے قَسم کھاؤ۔“ تَب یُوسیفؔ نے اُن سے قَسم کھائی اَور اِسرائیل نے اَپنے عصا کے سِرے کا سہارا لے کر سَجدہ کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","کچھ عرصہ کے بعد یُوسیفؔ کو خبر مِلی، ”آپ کے باپ بیمار ہیں۔“ چنانچہ وہ گئے اَور اَپنے دو بیٹوں منشّہ اَور اِفرائیمؔ کو بھی ساتھ لے گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","جَب یعقوب کو لوگوں نے بتایا، ”آپ کا بیٹا یُوسیفؔ آپ کے پاس آیا ہے۔“ تو اِسرائیل قُوّت پا کر اُٹھے اَور پلنگ پر بیٹھ گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","اَور یعقوب نے یُوسیفؔ سے فرمایا، ”قادرمُطلق خُدا مُلکِ کنعانؔ کے لُوزؔ میں مُجھے دِکھائی دئیے وہاں اُنہُوں نے مُجھے برکت دی ");
INSERT INTO urdoucv_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","اَور مُجھ سے کہا، ’میں تُمہیں سرفراز کروں گا اَور تمہاری تعداد کو بڑھاؤں گا۔ تمہاری قوم سے کیٔی اُمّتیں پیدا ہُوں گی اَور مَیں یہ مُلک تمہارے بعد تمہاری نَسل کو اَبدی مِیراث کے طور پر بخشوں گا۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","”اَور تمہارے دو بیٹے جو تُمہیں مِصر میں میرے یہاں آنے سے پہلے پیدا ہویٔے میرے ہی شُمار کئے جایٔیں گے۔ جِس طرح رُوبِنؔ اَور شمعُونؔ میرے ہیں اُسی طرح اِفرائیمؔ اَور منشّہ بھی میرے ہی ہوں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","اَورجو اَولاد اُن کے بعد تُمہیں ہوگی وہ تمہاری ہوگی اَورجو مِیراث وہ پائیں گے وہ اُن کے بھائیوں سے نامزد ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","جَب مَیں فدّان سے لَوٹ رہاتھا تَب میری بدقسمتی سے راخلؔ نے کنعانؔ کے مُلک میں جَب ہم اِفرات سے کچھ ہی فاصلہ پر تھے وفات پائی۔ چنانچہ مَیں نے اُسے وہیں اِفرات (یعنی بیت لحمؔ) کے راستہ میں دفن کیا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","جَب اِسرائیل نے یُوسیفؔ کے بیٹوں کو دیکھا تو پُوچھا، ”یہ کون ہیں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","یُوسیفؔ نے اَپنے باپ سے کہا، ”یہ میرے بیٹے ہیں جو خُدا نے مُجھے یہاں دیئے ہیں۔“ تَب اِسرائیل نے کہا، ”اُنہیں میرے پاس لاؤ تاکہ مَیں اُنہیں برکت دُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","اِسرائیل کی آنکھیں بُڑھاپے کی وجہ سے دھُندلا گئی تھیں اَور وہ بمشکل دیکھ پاتے تھے۔ چنانچہ یُوسیفؔ اَپنے بیٹوں کو اُن کے قریب لائے اَور اُن کے باپ نے اُنہیں چُوما اَور گلے لگایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","اِسرائیل نے یُوسیفؔ سے کہا، ”مُجھے اُمّید نہ تھی کہ تمہارا چہرہ پھر سے دیکھ پاؤں گا اَور اَب دیکھو خُدا نے مُجھے تمہاری اَولاد بھی دیکھنے دی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","تَب یُوسیفؔ نے اُنہیں اِسرائیل کے گھٹنوں پر سے نیچے اُتارا اَور مُنہ کے بَل زمین پر جھُک کر سَجدہ کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","جَب یُوسیفؔ اِفرائیمؔ کو اَپنے داہنے ہاتھ کے سہارے اَور منشّہ کو اَپنے بائیں ہاتھ کے سہارے اِسرائیل کے نزدیک لائے تو اِفرائیمؔ، اِسرائیل کی بائیں طرف اَور منشّہ اُن کی داہنی طرف تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","لیکن اِسرائیل نے اَپنا داہنا ہاتھ بڑھایا اَور اِفرائیمؔ کے سَر پر رکھ دیا حالانکہ وہ چھوٹا تھا اَور اَپنے بائیں ہاتھ کو کانٹے کے طور پر منشّہ کے سَر پر رکھا حالانکہ وہ پہلوٹھا تھا۔ یعقوب نے جان بوجھ کر اَیسا کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","تَب یعقوب نے یُوسیفؔ کو برکت دی اَور کہا، ”وہ خُدا جِس کے سامنے میرے آباؤاَجداد اَبراہامؔ اَور اِصحاقؔ نے اَپنی اَپنی زندگی کے دِن گزارے، وہ خُدا جو آج کے دِن تک عمر بھر میرا پاسبان رہا، ");
INSERT INTO urdoucv_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","اَور وہ فرشتہ جِس نے مُجھے ساری بَلاؤں سے بچایا، اِن لڑکوں کو برکت دیں، اَور وہ میرے، اَور میرے آباؤاَجداد اَبراہامؔ اَور اِصحاقؔ کے نام سے منسوب ہُوں، اَور وہ زمین پر کثرت سے بڑھیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","جَب یُوسیفؔ نے دیکھا کہ اُن کے باپ نے اَپنا داہنا ہاتھ اِفرائیمؔ کے سَر پر رکھا ہے تو ناخُوش ہُوئے اَور اُنہُوں نے اَپنے باپ کا داہنا ہاتھ تھام لیا تاکہ اُسے اِفرائیمؔ کے سَر پر سے ہٹا کر منشّہ کے سَر پر رکھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","یُوسیفؔ نے اُن سے کہا، ”اَے میرے باپ اَیسا نہ کریں کیونکہ پہلوٹھا یہ ہے۔ اِس لیٔے اَپنا داہنا ہاتھ اِس کے سَر پر رکھیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","لیکن اُن کے باپ راضی نہ ہُوئے اَور کہنے لگے، ”اَے میرے بیٹے میں بخُوبی جانتا ہُوں، وہ بھی ایک بڑی قوم بنے گا اَور وہ بھی برتر ہوگا۔ البتّہ اُس کا چھوٹا بھایٔی اُس سے بھی بڑا ہوگا اَور اُس کی نَسل سے بہت سِی قومیں پیدا ہُوں گی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","اُنہُوں نے اُنہیں اُس دِن برکت دی اَور کہا، ”بنی اِسرائیل تمہارا نام لے کر یُوں دعا دیا کریں گے: ’خُدا تمہارا اِفرائیمؔ اَور منشّہ کی مانند اِقبالمند کریں۔‘ “ یُوں اُنہُوں نے اِفرائیمؔ کو منشّہ پر فضیلت دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","تَب اِسرائیل نے یُوسیفؔ سے کہا، ”میں تو دُنیا سے رخصت ہونے والا ہُوں لیکن خُدا تمہارے ساتھ ہوگا اَور تُمہیں تمہارے آباؤاَجداد کے مُلک میں واپس لے جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","چونکہ اَب تُم اَپنے بھائیوں کے مُربیّ ہو اِس لیٔے میں تُمہیں مُلک کے اُوپر والا حِصّہ دیتا ہُوں جسے مَیں نے اَپنی تلوار اَور کمان سے امُوریوں کے ہاتھ سے لیا تھا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","تَب یعقوب نے اَپنے بیٹوں کو بُلایا اَور کہا: ”تُم سَب جمع ہو جاؤ تاکہ مَیں تُمہیں بتاؤں کہ آئندہ دِنوں میں تُم پر کیا کیا گزرے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","”اَے یعقوب کے بیٹو جمع ہوکر سُنو؛ اَپنے باپ اِسرائیل کی طرف کان لگاؤ۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","”اَے رُوبِنؔ تُم میرے پہلوٹھے ہو، میری قُوّت اَور میری ہمّت کا پہلا پھل ہو۔ تُمہیں اِعزاز اَور قُدرت میں سبقت حاصل ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","تُم پانی کی طرح سرکش ہو اِس لیٔے تُمہیں فضیلت نہیں ملے گی، کیونکہ تُم نے اَپنے باپ کے بِستر کو ناپاک کیا، میرے بچھونے پر چڑھ کر تُم نے اُسے ناپاک کر ڈالا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","”اَے شمعُونؔ اَور لیوی تُم بھایٔی بھایٔی ہو۔ اُن کی تلواریں تشدّد کے ہتھیار ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","مُجھے اُن کی جماعت میں داخل نہ ہونے دو، اَور نہ اُن کی محفل میں شریک ہونے دو۔ کیونکہ اُنہُوں نے اَپنے غضب میں لوگوں کو قتل کیا، اَور جَب جی چاہا بَیلوں کی کُونچیں کاٹ دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","لعنت ہو اُن کے غضب پرجو نہایت شدید تھا، اَور اُن کے قہر پر کیونکہ وہ نہایت سخت تھا! میں اُنہیں یعقوب میں مُنتشر اَور اِسرائیل میں پراگندہ کر دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","”اَے یہُوداہؔ! تمہارے بھایٔی تمہاری مدح کریں گے؛ اَور تمہارا ہاتھ تمہارے دُشمنوں کی گردن پر ہوگا؛ اَور تمہارے باپ کی اَولاد تمہارے آگے سرنِگوں ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","اَے یہُوداہؔ! تُم شیرببر کے بچّے ہو؛ میرے بیٹے! تُم شِکار کرکے لَوٹے ہو۔ وہ شیرببر بَلکہ شیرنی کی طرح دبک کر بیٹھ گئے، کون اُسے چھیڑنے کی جُرأت کرےگا؟ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","یہُوداہؔ کے قبیلہ سے عصائے شاہی نہیں چُھوٹے گی، اَور تمام قومیں اُس کی مطیع نہیں ہو جاتیں، تَب تک یہُوداہؔ کے ہاتھ سے نہ تو بادشاہی جائے گی، نہ ہی اُس کی نَسل سے شیلوہؔ یعنی عصائے شاہی موقُوف ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","وہ اَپنا گدھا انگور کی بیل سے، اَور اَپنی گدھی کا بچّہ اَپنی پسند ترین شاخ سے باندھے گا۔ وہ اَپنا لباس مَے میں، اَور اَپنا جامہ کو انگور کے رس میں دھویا کرےگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","اُس کی آنکھیں انگوری شِیرے سے زِیادہ سُرخ، اَور اُس کے دانت دُودھ سے زِیادہ سفید ہوں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","”زبُولُون سمُندر کے کنارے بسے گا، اَور جہازوں کے لیٔے بندرگاہ ہوگا؛ اُس کی حد صیدونؔ تک پھیلی ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","”یِسَّکاؔر ایک مضبُوط گدھا ہے جو دو بھیڑوں کے باڑوں کے درمیان بیٹھا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","وہ ایک اَچھّی آرامگاہ ہے اَور خُوشنما زمین دیکھ کر، وہ اَپنے کندھے کو بوجھ اُٹھانے کے لیٔے جھُکاتا ہے اَور بیگاری میں غُلام کی مانند کام کرنے لگتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","”دانؔ اِسرائیل کے قبیلوں میں سے ایک قبیلہ کی حیثیت سے اَپنے لوگوں کا اِنصاف کرےگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","دانؔ راستہ کا سانپ ہے، اَور راہ گزر کا افعی ہے، جو گھوڑے کی اِیڑی کو اَیسے ڈستا ہے کہ اُس کا سوار پچھاڑ کھا کر گِر پڑتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","”اَے یَاہوِہ! مَیں آپ کی نَجات کی راہ دیکھتا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","”گادؔ پر چھاپا ماروں کا ایک دستہ حملہ کرےگا، لیکن وہ اُن پر پیچھے سے ہلّا بول دے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","”آشیر کا اناج نفیس ہوگا اَور وہ بادشاہوں کے لائق لذیذ اَشیا مُہیّا کرےگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","”نفتالی ایک آزاد کی ہُوئی ہِرنی کی مانند ہے، اُس کے مُنہ سے میٹھی میٹھی باتیں نکلتی ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","”یُوسیفؔ پھلدار انگور کی بیل ہے، اَیسی پھلدار بیل جو پانی کے چشمہ کے پاس لگی ہے، جِس کی شاخیں دیوار پر چڑھی ہُوئی ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","تیر اَندازوں نے نہایت تیزی سے اُس پر حملہ کیا؛ عداوت سے اُنہُوں نے اُس پر تیر برسائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","لیکن یعقوب کے قادر کے ہاتھ سے، اَور اُس چرواہے کے سبب سے جو اِسرائیل کی چٹّان ہے، اُس کی کمان مضبُوط رہی، اَور اُس کے قوی بازوؤں کی قُوّت قائِم رہی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","تمہارے باپ کے خُدا کے سبب جو تمہاری مدد کرتے ہیں، اَور قادرمُطلق کے سبب جو تُمہیں اُوپر سے آسمان کی برکتوں سے، اَور نیچے سے گہرے سمُندر کی برکتوں سے، اَور چھاتِیوں اَور رِحموں کی برکتوں سے نوازتے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","تمہارے باپ کی برکتیں قدیم پہاڑوں کی برکتوں سے، اَور پرانی پہاڑیوں کی با اِفراط پیداوار سے بڑھ کر ہیں۔ یہ سَب یُوسیفؔ کے سَر پر، بَلکہ اُس کی پیشانی پر جو بھائیوں میں شہزادہ ہے نازل ہوتی رہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","”بِنیامین بھُوکا بھیڑیا ہے؛ جو صُبح کو شِکار کو پھاڑ کھاتا ہے، اَور شام کو لُوٹ کا مال بانٹتا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","یہ سَب اِسرائیل کے بَارہ قبیلے ہیں اَور یہی وہ باتیں ہیں جو اُن کے باپ نے اُنہیں برکت دیتے وقت کہیں اَور ہر ایک کو وُہی برکت دی جِس کے وہ لائق تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","تَب یعقوب نے اُنہیں یہ وصیّت کی، ”میں اَب جلد ہی اَپنے لوگوں میں جا ملوں گا۔ مُجھے اَپنے آباؤاَجداد کے ساتھ اُس غار میں دفن کرنا جو حِتّی عِفرونؔ کے کھیت میں ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","یعنی اُسی غار میں جو مُلکِ کنعانؔ میں ممرےؔ کے نزدیک مکفیلہؔ کے کھیت میں ہے جسے اَبراہامؔ نے حِتّی عِفرونؔ سے قبرستان کے لیٔے کھیت سمیت خرید لیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","جہاں اَبراہامؔ اَور اُن کی بیوی سارہؔ دفن کئے گیٔے جہاں اِصحاقؔ اَور اُن کی بیوی رِبقہؔ دفن ہویٔے اَور جہاں مَیں نے لِیاہؔ کو دفن کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","وہ کھیت اَور اُس میں واقع غار حِتّیوں سے خریدے گیٔے تھے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","جَب یعقوب اَپنے بیٹوں کو وصیّت کرچکے تو اُنہُوں نے اَپنے پاؤں بِستر پر سمیٹ لیٔے اَور آخِری سانس لی اَور اَپنے لوگوں میں جا مِلے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","یُوسیفؔ اَپنے باپ سے لپٹ کر رُوئے اَور اُنہیں چُوما۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","پھر یُوسیفؔ نے اَپنے طبیبوں کو حُکم دیا کہ وہ اُن کے باپ اِسرائیل کی لاش کو محفوظ رکھنے کے لیٔے اُس میں خُوشبودار مَسالے بھر دیں۔ چنانچہ طبیبوں نے اَیسا ہی کیا اَور لاش کو محفوظ کر دیا، ");
INSERT INTO urdoucv_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","جِس میں پُورے چالیس دِن لگے کیونکہ لاش کو محفوظ کرنے کے لیٔے اِتنا ہی وقت درکار ہوتاہے۔ اَور مِصریوں نے ستّر دِن تک یعقوب کے لیٔے ماتم کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","جَب ماتم کے دِن گزر گئے تَب یُوسیفؔ نے فَرعوہؔ کے درباریوں سے کہا، ”اگر مُجھ پر تمہاری مہربانی ہو تو میری ایک درخواست فَرعوہؔ تک پہُنچا دو، ");
INSERT INTO urdoucv_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","’میرے باپ نے مُجھ سے قَسم لے کر کہا ہے، ”مَیں اَب مرنے کو ہُوں؛ لہٰذا تُم مُجھے اُس قبر میں دفن کرنا جو مَیں نے مُلکِ کنعانؔ میں اَپنے لیٔے کھُدوائی ہے۔“ مُجھے اِجازت دیں کہ مَیں وہاں جا کر اَپنے باپ کو دفن کروں؛ اَور تَب میں لَوٹ کر آؤں گا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","فَرعوہؔ نے کہا، ”جاؤ اَور اَپنے باپ کو جَیسے اُنہُوں نے تُم سے قَسم لی ہے، اُنہیں دفن کرو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","چنانچہ یُوسیفؔ اَپنے باپ کو دفن کرنے کے لیٔے روانہ ہُوئے اَور فَرعوہؔ کے سَب حاکم اَور اُس کے بُزرگ درباری اَور مِصر کے سَب اُمرا ");
INSERT INTO urdoucv_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","اَور یُوسیفؔ کے گھر کے سَب افراد اُن کے بھایٔی اَور اُن کے باپ کے گھر کے سَب لوگ اُن کے ساتھ گیٔے۔ وہ صِرف اَپنے بچّے اَور اَپنی بھیڑ بکریوں کے گلّے اَور اَپنے مویشیوں کے ریوڑ گوشینؔ میں چھوڑ گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","رتھوں اَور گُھڑسواروں کی ایک بڑی تعداد بھی اُن کے ساتھ تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","جَب وہ یردنؔ کے نزدیک اَتدؔ کے کھلیان پر پہُنچے تو اُنہُوں نے وہاں نہایت بُلند اَور دِل سوز آواز سے نوحہ کیا اَور یُوسیفؔ نے اَپنے باپ کے لیٔے سات دِن تک ماتم کروایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","جَب وہاں کے کنعانی باشِندوں نے اَتدؔ کے کھلیان پر ماتم ہوتے دیکھا تو کہا، ”مِصریوں کا ماتم بڑا دردناک ہے۔“ اِس لیٔے یردنؔ کے قریب کی وہ جگہ ابیل مصرائیمؔ کہلاتی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","چنانچہ یعقوب کے بیٹوں نے وَیسا ہی کیا جَیسا اُس نے اُنہیں حُکم دیا تھا: ");
INSERT INTO urdoucv_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","وہ اُنہیں مُلکِ کنعانؔ لے گیٔے اَور اُنہیں ممرےؔ کے نزدیک مکفیلہؔ کے کھیت کے اُس غار میں دفن کیا جسے اَبراہامؔ نے حِتّی عِفرونؔ سے کھیت سمیت قبرستان کے لیٔے خریدا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","اَپنے باپ کو دفن کرنے کے بعد یُوسیفؔ اَپنے بھائیوں اَور اُن سَب لوگوں کے ساتھ جو اُن کے باپ کو دفن کرنے کے لیٔے اُن کے ساتھ آئےتھے مِصر واپس لَوٹ گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","جَب یُوسیفؔ کے بھائیوں نے دیکھا کہ اُن کے باپ وفات پا چُکے ہیں، تو اُنہُوں نے کہا، ”اگر یُوسیفؔ ہم سے دُشمنی رکھنے لگے اَور ساری بُرائی کا جو ہم نے اُس سے کی ہے پُورا بدلہ لینے لگے تو ہمارا کیا ہوگا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","تَب اُنہُوں نے یُوسیفؔ کو یہ کہلا بھیجا، ”تمہارے باپ نے اَپنی وفات سے پہلے یہ ہدایات دی تھیں کہ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","’تُم یُوسیفؔ سے کہنا کہ اَپنے بھائیوں کے گُناہوں اَور خطاؤں کو مُعاف کر دیں جنہوں نے آپ کے ساتھ اِتنی بدسلُوکیاں کیں،‘ چنانچہ براہِ کرم اَب آپ اَپنے باپ کے خُدا کے خادِموں کی خطاؤں کو مُعاف کر دیں۔“ جَب اُن کا پیغام یُوسیفؔ کے پاس پہُنچا تو وہ رو دئیے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","تَب اُن کے بھایٔی بھی آئے اَور اُن کے سامنے گِر کے کہنے لگے، ”ہم تو تمہارے غُلام ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","لیکن یُوسیفؔ نے اُن سے کہا، ”خوف نہ کرو۔ کیا میں خُدا کی جگہ ہُوں؟ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","تُم نے مُجھے نُقصان پہُنچانے کا اِرادہ کیا تھا لیکن خُدا نے اُس سے نیکی پیدا کر دی تاکہ بہت سِی جانیں سلامت بچ جایٔیں جَیسا تُم دیکھ رہے ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","چنانچہ ڈرو نہیں۔ مَیں تمہاری اَور تمہارے بال بچّوں کی ضروریات پُوری کرتا رہُوں گا۔“ یُوں یُوسیفؔ نے اُنہیں تسلّی دی اَور اُن کے ساتھ بڑی شفقت سے پیش آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","یُوسیفؔ اَپنے باپ کے تمام خاندان کے ساتھ مِصر میں رہے اَور وہ ایک سَو دس بَرس تک جیتے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","اَور یُوسیفؔ نے اِفرائیمؔ کی اَولاد تیسری پُشت تک دیکھی اَور منشّہ کے بیٹے مکیرؔ کی اَولاد کو بھی یُوسیفؔ نے اَپنے گھٹنوں پر کھِلایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","تَب یُوسیفؔ نے اَپنے بھائیوں سے کہا، ”میں اَب مرنے کو ہُوں لیکن خُدا یقیناً تمہاری خبرگیری کریں گے اَور تُمہیں اِس مُلک سے نکال کر اُس مُلک میں پہُنچائیں گے، جسے دینے کا وعدہ اَبراہامؔ، اِصحاقؔ اَور یعقوب سے قَسم کھا کر کیا تھا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","اَور یُوسیفؔ نے بنی اِسرائیل سے قَسم لے کر کہا، ”خُدا یقیناً تمہاری مدد کے لئے آئیں گے اَور تَب تُم ضروُر ہی میری ہڈّیوں کو یہاں سے لے جانا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","اَور یُوسیفؔ نے ایک سَو دس بَرس کا ہوکر وفات پائی اَور اُنہُوں نے اُن کی لاش میں خُوشبودار مَسالے بھر کر، اُنہیں مِصر ہی میں ایک تابُوت میں محفوظ کر دیا۔");
INSERT INTO urdoucv_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","اِسرائیل کے بیٹوں کے نام جو اَپنے اَپنے گھرانے سمیت یعقوب کے ساتھ مِصر میں آئے وہ یہ ہیں: ");
INSERT INTO urdoucv_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","رُوبِنؔ، شمعُونؔ، لیوی، یہُوداہؔ؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","یِسَّکاؔر، زبُولُون، بِنیامین؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","دانؔ اَور نفتالی؛ گادؔ اَور آشیر۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","اَور یعقوب کی نَسل کی کُل تعداد ستّر تھی، اَور یُوسیفؔ تو پہلے ہی مِصر میں تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","اَور یُوسیفؔ اَور اُن کے سَب بھایٔی اَور وہ ساری پُشت فنا ہو گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","لیکن بنی اِسرائیل سرفراز ہویٔے اَور افزائشِ نَسل کے باعث خُوب بڑھے اَور شُمار میں اِس قدر زِیادہ ہو گئے کہ وہ مُلک اُن سے بھر گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","اُس وقت ایک نیا بادشاہ، جو یُوسیفؔ کے بارے میں کچھ بھی نہیں جانتا تھا، مِصر پر حُکمراں ہو چُکاتھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","”دیکھو،“ اُس نے اَپنے لوگوں سے کہا، ”ہمارے مُقابلہ میں بنی اِسرائیل کی تعداد بہت زِیادہ ہو گئی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","پس آؤ ہم اُن کے ساتھ ہوشیاری سے کام لیں، ورنہ اگر جنگ چھڑ گئی، تو وہ ہمارے دُشمنوں کے ساتھ مِل جایٔیں گے، اَور ہمارے خِلاف لڑیں گے اَور مُلک سے نکل جایٔیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","لہٰذا اُنہُوں نے اُن پر بیگار لینے والے سرداروں کو مُقرّر کیا تاکہ اُن سے سخت کام لے کر اُن کو ستائیں اَور اُنہُوں نے فَرعوہؔ کے ذخیروں کے لیٔے شہر پِتومؔ اَور رَعمسیسؔ بنائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","لیکن اِسرائیلی جِس قدر زِیادہ ستائے گیٔے، اُسی قدر اُن کی تعداد اَور زِیادہ بڑھی اَور وہ پھیلتے چلے گیٔے۔ لہٰذا مِصری اُن سے خوف کھانے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","مِصری غُلام اِسرائیلیوں سے اَور بھی زِیادہ سختی سے کام لینے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","اَور اُنہُوں نے اُن سے اینٹیں اَور گارا بنوا بنوا کر اَور کھیتوں میں ہر قِسم کی خدمت لے کر اُن کی زندگیاں تلخ کر دیں، اَور اُن کی ساری محنت اَور مشقّت میں مِصری اُن پر تشدّد کرتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","اَور مِصر کے بادشاہ نے عِبرانی دائیوں، کو جِن کے نام شِفرہؔ اَور پُوعہؔ تھے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","”جَب تُم عِبرانی عورتوں کو بچّہ پیدا کرنے میں مدد کرو اَور اُنہیں وضعِ حَمل کی تِپائی پر بیٹھی دیکھو تو اگر لڑکا ہو تو اُسے مار ڈالنا؛ لیکن اگر لڑکی ہو تو، اُسے زندہ رہنے دینا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","مگر اُن دائیوں نے خُدا کا خوف کرتے ہویٔے، اَیسا کام نہ کیا جو مِصر کے بادشاہ نے اُنہیں کرنے کے لیٔے حُکم دیا تھا؛ بَلکہ اُنہُوں نے لڑکوں کو زندہ رہنے دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","تَب مِصر کے بادشاہ نے اُن دائیوں کو طلب کیا اَور اُن سے بازپُرس کی، ”تُم نے اَیسا کیوں کیا؟ تُم نے لڑکوں کو کیوں زندہ رہنے دیا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","اُن دائیوں نے فَرعوہؔ کو جَواب دیا، ”عِبرانی عورتیں مِصری عورتوں کی مانند نہیں ہیں؛ وہ اَیسی توانا ہوتی ہیں، دائیوں کے آنے سے پیشتر ہی بچّہ پیدا کر لیتی ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","پس خُدا اُن دائیوں پر مہربان تھا، اَور لوگ بڑھتے چلے گیٔے اَور تعداد میں اَور بھی زِیادہ ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","اَور چونکہ دائیوں نے خُدا کا خوف مانا، اِس لیٔے خُدا نے اُنہیں بھی بال بچّے والیاں بنا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","تَب فَرعوہؔ نے اَپنے تمام لوگوں کو یہ حُکم دیا: ”ہر اِسرائیلی لڑکا جو پیدا ہو وہ ضروُر دریائے نیل میں پھینک دیا جائے۔ لیکن ہر ایک لڑکی کو زندہ رہنے دیا جائے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","اَور لیوی کے قبیلہ کے ایک اِنسان نے لیوی نَسل کی ایک عورت سے شادی کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","اَور وہ حاملہ ہُوئی اَور اُس سے ایک بیٹا پیدا ہُوا۔ جَب اُس نے دیکھا کہ وہ ایک خُوبصورت بچّہ ہے، تو اُس نے تین مہینے تک اُسے چُھپائے رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","اَور جَب وہ آخِر اُسے زِیادہ دیر چھُپا نہ سکی، تو اُس نے اُس کے لیٔے سَرکنڈوں کا ایک ٹوکرا بنایا اَور اُس پر تارکول اَور رال کا پلستر کیا اَور پھر اُس بچّہ کو اُس میں رکھ کر دریائے نیل کے کنارے سَرکنڈوں میں رکھ آئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","اَور اُس کی بہن یہ دیکھنے کے لیٔے کہ اُس کے ساتھ کیا ہوتاہے، کُچھ دُور کھڑی رہی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","فَرعوہؔ کی بیٹی دریائے نیل میں غُسل کرنے واسطے آئی اَور اُس کی لونڈی سہیلیاں دریا کے کنارے کنارے ٹہل رہی تھیں۔ فَرعوہؔ کی بیٹی نے سَرکنڈوں میں ٹوکرے کو دیکھ کر اَپنی ایک خادِمہ کو بھیجا کہ اُسے اُٹھا لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","جَب اُس نے اُسے کھولا تو دیکھا کہ اُس میں بچّہ ہے۔ بچّہ رو رہاتھا اَور اُسے اُس پر رحم آیا اَور اُس نے کہا، ”یہ تو کویٔی عِبرانی بچّہ ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","تَب اُس بچّہ کی بہن نے فَرعوہؔ کی بیٹی سے پُوچھا، ”کیا میں جا کر کسی عِبرانی عورت کو لے آؤں جو آپ کے لیٔے اِس بچّہ کو دُودھ پِلایا کرے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","فَرعوہؔ کی بیٹی نے جَواب دیا، ”ہاں جاؤ!“ اَور وہ لڑکی جا کر اُس بچّہ کی ماں کو بُلا لائی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","تَب فَرعوہؔ کی بیٹی نے اُس سے کہا، ”اِس بچّہ کو لے جا اَور میرے لیٔے دُودھ پِلا اَور مَیں تُمہیں تمہاری اُجرت دیا کروں گی۔“ لہٰذا وہ عورت اُس بچّہ کو لے جا کر دُودھ پِلانے لگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","اَور جَب وہ بچّہ کچھ بڑا ہو گیا تو وہ اُسے فَرعوہؔ کی بیٹی کے پاس لے گئی اَور وہ اُس کا بیٹا بَن گیا اَور اُس نے اُس کا نام یہ کہتے ہویٔے مَوشہ رکھا، ”مَیں نے اُسے پانی سے نکالا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","اُس کے بعد جَب مَوشہ بڑے ہُوئے تو ایک دِن وہ باہر اَپنے لوگوں کے پاس گئے اَور اُنہیں سخت محنت کرتے دیکھا۔ اُنہُوں نے دیکھا کہ ایک مِصری ایک عِبرانی کو جو مَوشہ کی اَپنی قوم سے تھا مار رہاہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","اُنہُوں نے اِدھر اُدھر نگاہ کی اَور جَب دیکھا کہ کویٔی نہیں تو اُنہُوں نے اُس مِصری کو مار ڈالا اَور اُسے ریت میں چھُپا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","اَور دُوسرے دِن جَب وہ پھر باہر گیٔے تو اُنہُوں نے دو عِبرانیوں کو آپَس میں لڑتے دیکھا۔ تَب مَوشہ نے اُس قُصُوروار سے پُوچھا، ”تُم اَپنے عِبرانی بھایٔی کو کیوں مار رہے ہو؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","اُس اِنسان نے کہا، ”آپ کو کِس نے ہم پر حاکم اَور قاضی مُقرّر کیا ہے؟ جِس طرح آپ نے اُس مِصری کو قتل کر ڈالا تھا کیا مُجھے بھی اُسی طرح مار ڈالنا چاہتے ہیں؟“ تَب مَوشہ ڈر گئے اَور اُنہُوں نے سوچا، ”جو کُچھ مَیں نے کیا تھا یقیناً اُس کا راز کھُل گیا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","جَب فَرعوہؔ نے یہ سُنا تو اُس نے مَوشہ کو مار ڈالنے کی کوشش کی، لیکن مَوشہ فَرعوہؔ کی حُضُوری سے چلےگئے اَور مِدیان میں رہنے کے لیٔے فرار ہو گئے، اَور وہاں وہ ایک کنوئیں کے پاس جا کر بیٹھ گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","مِدیان کے ایک کاہِنؔ کی سات بیٹیاں تھیں۔ وہ اَپنے باپ کی بھیڑ بکریوں کو پانی پِلانے کے لیٔے آئیں تاکہ پانی کنوئیں سے نکال کر حوض میں بھر دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","اَور کچھ چرواہے بھی وہاں چلے آئے جنہوں نے اُن کو وہاں سے ہٹا دیا، لیکن مَوشہ اُٹھے اَور اُن کی مدد کو آ گئے اَور اُنہُوں نے اُن کے گلّہ کو پانی پِلایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","جَب وہ لڑکیاں اَپنے باپ رِعوایلؔ کے پاس واپس آئیں، ”تو اُس نے پُوچھا کہ آج تُم اِتنی جلدی کیسے آ گئیں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","اُنہُوں نے جَواب دیا، ”ایک مِصری نے ہمیں چرواہوں کے ہاتھ سے بچایا۔ اُس نے ہمارے لیٔے پانی بھر بھر کر نکالا اَور بھیڑ بکریوں کو بھی پِلایا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","رِعوایلؔ نے اَپنی لڑکیوں سے پُوچھا، ”وہ کہاں ہے؟ تُم اُسے چھوڑ کیوں آئیں؟ اُسے بُلا لاؤ کہ وہ کھانا کھالے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","اَور مَوشہ اُس اِنسان کے ساتھ رہنے پر رضامند ہو گئے اَور اُس اِنسان نے اَپنی بیٹی ضِفورہؔ کی شادی مَوشہ سے کر دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","اَور ضِفورہؔ کے ایک بیٹا ہُوا۔ مَوشہ نے اُس کا نام یہ کہتے ہویٔے گیرشوم رکھا، ”میں پردیس مُلک میں اجنبی ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","اَور اُس طویل عرصہ کے دَوران وہ مِصر کا بادشاہ مَر گیا اَور بنی اِسرائیل اَپنی غُلامی میں کراہنے اَور رونے لگے اَور غُلامی کے باعث مدد کے لیٔے اُن کی آہ و زاری خُدا تک جا پہُنچی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","اَور خُدا نے اُن کا کراہنا سُنا اَور خُدا نے اَپنے عہد کو جو اَبراہامؔ، اِصحاقؔ اَور یعقوب کے ساتھ باندھا تھا یاد کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","لہٰذا خُدا نے اِسرائیل کی طرف نگاہ کی اَور اُن کے حالات پر غور فرمایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ایک دفعہ اَیسا ہُوا کہ مَوشہ اَپنے سسُر، یتروؔ کی جو مِدیان کے کاہِنؔ تھے بھیڑ بکریاں چرا رہے تھے اَور وہ اُس گلّہ کو ہانک کر دُور بیابان کے دُوسری طرف خُدا کے پہاڑ حورِبؔ تک لے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","وہاں یَاہوِہ کا ایک فرشتہ جلتی ہویٔی جھاڑی کے درمیان آگ کے شُعلوں میں ظاہر ہُوا۔ مَوشہ نے دیکھا کہ وہ جھاڑی جَل رہی ہے لیکن راکھ نہیں ہوتی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","لہٰذا مَوشہ نے سوچا، ”میں اَچھّی طرح جائزہ لُوں گا اَور اِس عجِیب منظر کو دیکھوں گا کہ آخِر وہ جھاڑی بھسم کیوں نہیں ہوتی!“ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","جَب یَاہوِہ نے دیکھا کہ وہ بھیڑ بکریوں کو چھوڑکر جھاڑی کے پاس آ پہُنچا ہے کہ اُس کا جائزہ لے، تو خُدا نے جلتی ہویٔی جھاڑی میں سے اُسے پُکارا، ”مَوشہ! مَوشہ!“ اَور مَوشہ نے کہا، ”مَیں حاضِر ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","تَب خُدا نے کہا، ”بہت زِیادہ نزدیک ہرگز مت آنا اَور اَپنے جُوتے اُتارو، کیونکہ جِس جگہ تُم کھڑے ہو وہ پاک سرزمین ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","اَور پھر خُدا نے فرمایا، ”مَیں تمہارے باپ کا خُدا یعنی اَبراہامؔ، اِصحاقؔ اَور یعقوب کا، خُدا ہُوں۔“ اِس پر مَوشہ نے اَپنا مُنہ چھُپا لیا، کیونکہ وہ خُدا کی نظر کی تاب نہ لا سکنے سے ڈرتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","اَور یَاہوِہ نے فرمایا، ”مَیں نے واقعی مِصر میں اَپنے لوگوں کو سخت تکلیف میں دیکھاہے؛ اَور مَیں نے اُنہیں بیگار لینے والوں کے باعث روتے اَور فریاد کرتے سُنا ہے اَور مُجھے اُن کے دُکھوں کا خیال ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","اِس لیٔے میں اُنہیں مِصریوں کے ہاتھ سے چھُڑانے کے لیٔے اُترا ہُوں، تاکہ اُنہیں اُس مُلک سے نکال کر ایک اَچھّے اَور وسیع مُلک میں جہاں دُودھ اَور شہد بہتا ہے یعنی کنعانیوں، حِتّیوں، امُوریوں، پَرزّیوں، حِوّیوں اَور یبُوسیوں کے مُلک میں پہُنچاؤں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","اَور اَب بنی اِسرائیل کا رونا، چِلّانا اَور اُن کی فریاد مُجھ تک پہُنچ گئی ہے؛ اَور جِس طرح مِصری اُن پر ظُلم کرتے مَیں نے اُسے بھی دیکھاہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","لہٰذا اَب جاؤ میں تُمہیں فَرعوہؔ کے پاس بھیجتا ہُوں تاکہ تُم میری قوم بنی اِسرائیل کو مِصر سے نکال لاؤ۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","لیکن مَوشہ نے خُدا سے کہا، ”مَیں کون ہُوں جو فَرعوہؔ کے پاس جاؤں اَور بنی اِسرائیل کو مِصر سے باہر نکال لاؤں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","تَب خُدا نے فرمایا، ”مَیں تمہارے ساتھ ہُوں گا، اَور اِس بات کا کہ مَیں نے تُمہیں بھیجا ہے تمہارے لیٔے یہ نِشان ہوگا کہ جَب تُم اُن لوگوں کو مِصر سے باہر نکال کر لے آؤگے، تو تُم اِس پہاڑ پر خُدا کی عبادت کروگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","تَب مَوشہ نے خُدا سے کہا، ”اگر مَیں بنی اِسرائیل کے پاس جا کر اُنہیں کہُوں، ’تمہارے آباؤاَجداد کے خُدا نے مُجھے تمہارے پاس بھیجا ہے،‘ اَور وہ مُجھ سے پُوچھیں، ’اُس کا نام کیا ہے،‘ تو میں اُنہیں کیا بتاؤں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","خُدا نے مَوشہ سے فرمایا، ”میں جو ہُوں سو مَیں ہُوں۔ سو تُم بنی اِسرائیل سے یُوں کہنا، ’میں جو ہُوں نے مُجھے تمہارے پاس بھیجا ہے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","خُدا نے مَوشہ سے یہ بھی فرمایا، ”تُم بنی اِسرائیل سے کہنا، ’یَاہوِہ، تمہارے باپ کا خُدا یعنی اَبراہامؔ، اِصحاقؔ اَور یعقوب کا خُدا، نے مُجھے تمہارے پاس بھیجا ہے۔‘ ”اَبد تک میرا یہی نام ہے، اَور مَیں پُشت در پُشت اَور اِسی نام سے یاد کیا جاؤں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","”جاؤ، اَور بنی اِسرائیل کے بُزرگوں کو جمع کرکے اُن سے کہو، ’یَاہوِہ تمہارے آباؤاَجداد کے خُدا یعنی اَبراہامؔ اِصحاقؔ اَور یعقوب کے خُدا نے مُجھے دِکھائی دے کر کہا کہ مَیں نے تُم پر نظرِکرم کی ہے اَور مِصر میں جو سلُوک تمہارے ساتھ کیا گیا ہے اُسے بھی دیکھاہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","اَور مَیں نے وعدہ کیا ہے کہ میں تُمہیں مِصر میں تمہاری سخت تکلیف سے نکال کر کنعانیوں، حِتّیوں، امُوریوں، پَرزّیوں، حِوّیوں اَور یبُوسیوں کے مُلک میں پہُنچاؤں گا جہاں دُودھ اَور شہد بہتا ہے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","”اَور بنی اِسرائیل کے بُزرگ تمہاری بات سُنیں گے۔ تَب تُم اُن بُزرگوں کے ساتھ مِصر کے بادشاہ کے پاس جا کر کہنا، ’یَاہوِہ کی یعنی عِبرانیوں کے خُدا کی ہم سے مُلاقات ہُوئی۔ ہمیں تین دِن کے سفر تک بیابان میں جانے دو تاکہ ہم یَاہوِہ اَپنے خُدا کے لیٔے قُربانی پیش کریں۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","لیکن مَیں جانتا ہُوں کہ مِصر کا بادشاہ تُمہیں تَب تک نہ جانے دے گا جَب تک کہ کویٔی قوی ہاتھ اُسے مجبُور نہ کر دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","لہٰذا میں اَپنا ہاتھ بڑھاؤں گا اَور اُن مِصریوں کے درمیان اُن تمام عجائبات سے جو میں اُن کے درمیان کروں گا اُن کو ماروں گا۔ اُس کے بعد وہ تُمہیں جانے دے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","”اَور مَیں مِصریوں کو اِن لوگوں پر مہربان کر دُوں گا تاکہ جَب تُم مِصر سے جاؤ تو تُم خالی ہاتھ نہ جاؤ۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","تمہاری ہر ایک عورت کو چاہیے کہ وہ اَپنی پڑوسن سے یا کسی بھی عورت سے جو اُس کے گھر میں مہمان ہو سونے چاندی کے زیور اَور لباس مانگ لے جو تُم اَپنے بیٹوں اَور بیٹیوں کو پہناؤگے اَور اِس طرح تُم مِصریوں کو لُوٹ لوگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","مَوشہ نے جَواب دیا، ”لیکن اگر وہ میرا یقین نہ کریں یا میری بات نہ سُنیں، اَور کہیں، ’یَاہوِہ تُمہیں دِکھائی نہیں دئیے تو پھر میں کیا کروں گا؟‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","تَب یَاہوِہ نے کہا، ”تمہارے ہاتھ میں یہ کیا ہے؟“ مَوشہ نے جَواب دیا، ”عصا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","پھر یَاہوِہ نے کہا، ”اُسے زمین پر ڈال دو!“ تَب مَوشہ نے اُسے زمین پر ڈال دیا، اَور وہ عصا سانپ بَن گیا اَور مَوشہ اُس سے ڈر کر بھاگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","تَب یَاہوِہ نے مَوشہ سے فرمایا، ”اَپنا ہاتھ بڑھا کر اُسے دُم سے پکڑ لو!“ لہٰذا مَوشہ نے ہاتھ بڑھا کر سانپ کو پکڑ لیا اَور وہ اُن کے ہاتھ میں پھر سے عصا بَن گیا! ");
INSERT INTO urdoucv_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","یَاہوِہ نے فرمایا، ”یہ اِس لیٔے ہُوا،“ تاکہ، ”وہ یقین کریں کہ یَاہوِہ اُن کے آباؤاَجداد کا خُدا یعنی اَبراہامؔ کا خُدا اِصحاقؔ کا خُدا اَور یعقوب کا خُدا تُم پر ظاہر ہویٔے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","تَب یَاہوِہ نے فرمایا، ”اَپنا ہاتھ اَپنے چوغہ کے اَندر رکھو۔“ لہٰذا مَوشہ نے اَپنا ہاتھ اَپنے چوغہ کے اَندر رکھ لیا اَور جَب مَوشہ نے اُسے باہر نکالا، تو وہ کوڑھ سے برف کی مانند سفید تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","تَب یَاہوِہ نے فرمایا، ”اَب اِسے پھر سے واپس اَپنے چوغہ کے اَندر رکھو۔“ لہٰذا مَوشہ نے اَپنا ہاتھ پھر سے چوغہ کے اَندر رکھ لیا؛ اَور جَب مَوشہ نے اُسے باہر نکالا تو وہ پھر اُن کے باقی جِسم کی مانند پہلے جَیسا ہو گیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","تَب یَاہوِہ نے کہا، ”اگر وہ تمہارا یقین نہ کریں یا پہلے والے معجزانہ نِشان کی بھی پرواہ نہ کریں تو ہو سَکتا ہے کہ وہ دُوسرے معجزانہ نِشان کا یقین کر لیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","لیکن اگر وہ اِن دونوں حیرت اَنگیز نِشانوں کا یقین نہ کریں یا تمہاری بات نہ سُنیں تو تُم دریائے نیل سے کُچھ پانی لے کر اُسے خشک زمین پر اُنڈیل دینا۔ اَور وہ پانی جو تُم دریا سے لوگے زمین پر خُون ہو جائے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","تَب مَوشہ نے یَاہوِہ سے کہا، ”اَے خُداوؔند! مَیں کبھی بھی خُوش گُفتار نہیں رہا ہُوں۔ نہ ماضی میں اَور نہ ہی جَب سے آپ نے اَپنے خادِم سے کلام کیا ہے۔ میں روانی سے نہیں بول سَکتا اَور میری زبان میں لکنت ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","تَب یَاہوِہ نے اُن سے پُوچھا، ”اِنسان کو اُس کا مُنہ کِس نے دیا ہے؟ کون اُس کو بہرہ یا گُونگا بناتا ہے؟ کون اُس کو بینائی دیتاہے یا اَندھا بناتا ہے؟ کیا وہ مَیں یَاہوِہ ہی نہیں ہُوں؟ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","اِس لئے اَب تُم جاؤ۔ میں بولنے میں تمہاری مدد کروں گا اَورجو کُچھ تُمہیں کہنا ہوگا تُمہیں سِکھاؤں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","لیکن مَوشہ نے کہا، ”اَے خُداوؔند! مہربانی کرکے یہ کام کرنے کے لیٔے کسی اَور کو بھیج دیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","تَب یَاہوِہ کا غُصّہ مَوشہ کے خِلاف بھڑک اُٹھا اَور اُنہُوں نے کہا، ”بنی لیوی اَہرونؔ تمہارے بھایٔی کا کیا حال ہے؟ میں جانتا ہُوں کہ وہ روانی سے کلام کر سَکتا ہے۔ وہ تُم سے مُلاقات کرنے پہلے ہی چلا آ رہاہے اَور تُمہیں دیکھ کر اُسے دِلی مسرّت ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","اَور تُم کھُل کر اَپنی باتیں اُسے بتانا تاکہ وہ اُنہیں اَپنے مُنہ سے کہہ سکے اَور مَیں بولنے میں تُم دونوں کی مدد کروں گا۔ اَورجو کچھ کرنا ہوگا تُمہیں سِکھاؤں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","وہ تمہاری طرف سے لوگوں سے باتیں کرےگا گویا وہ تمہارا مُنہ ہے اَور تُم اُس کے لیٔے خُدا کی مانند ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","لیکن اِس عصا کو اَپنے ہاتھ میں رکھنا تاکہ تُم اِس کے ذریعہ حیرت اَنگیز نِشانات کو دِکھا سکو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","تَب مَوشہ اَپنے سسُر یتروؔ کے پاس واپس ہویٔے اَور کہا، ”مُجھے مِصر میں اَپنے لوگوں کے پاس واپس جانے کی اِجازت دیجئے تاکہ میں دیکھوں کہ آیا اُن میں سے کُچھ اَب بھی زندہ ہیں یا نہیں؟“ یتروؔ نے کہا، جاؤ، ”سلامتی کے ساتھ رخصت ہو!“ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","اَور یَاہوِہ نے مِدیان میں مَوشہ سے یہ کہاتھا، ”مِصر میں واپس جاؤ کیونکہ وہ سَب جو تمہارے خُون کے پیاسے تھے مَر چُکے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","لہٰذا مَوشہ نے اَپنی بیوی اَور بیٹوں کو ساتھ لیا اَور اُن کو ایک گدھے پر سوار کرکے مُلک مِصر واپس جانے کے لیٔے روانہ ہویٔے اَور مَوشہ نے خُدا کا وہ عصا بھی اَپنے ہاتھ میں لے لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","اَور یَاہوِہ نے مَوشہ سے کہا، ”جَب تُم مِصر میں واپس پہُنچو تو دیکھنا کہ تُم وہ سَب عجائب جِن کے کرنے کی مَیں نے تُمہیں طاقت بخشی ہے فَرعوہؔ کے سامنے ضروُر دِکھانا۔ لیکن مَیں فَرعوہؔ کا دِل سخت کر دُوں گا، لہٰذا وہ لوگوں کو جانے نہیں دے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","تَب فَرعوہؔ سے کہنا،‏ ’یَاہوِہ یُوں فرماتے ہیں‏: اِسرائیل میرا پہلوٹھا بیٹا ہے، ");
INSERT INTO urdoucv_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","اَور مَیں نے تُمہیں کہا، ”میرے بیٹے کو جانے دو تاکہ وہ میری عبادت کر سکے۔“ لیکن تُم نے اِنکار کیا اَور اُسے جانے نہ دیا؛ لہٰذا مَیں تمہارے پہلوٹھے بیٹے کو مار ڈالوں گا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","اَور راستہ میں ایک جگہ جہاں وہ رات بھرکے لیٔے رُکے تھے یَاہوِہ مَوشہ کو مِلے اَور اُس کو مار ڈالنے ہی والے تھے ");
INSERT INTO urdoucv_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","کہ ضِفورہؔ نے ایک تیز سا پتّھر لیا اَور اَپنے بیٹے کا ختنہ کر دیا اَور کٹی ہُوئی کھلڑی سے مَوشہ کے پیر کو چھُوا اَور کہا، ”یقیناً آپ میرے لیٔے خُون بہانے والے دُلہا ہیں،“ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","لہٰذا یَاہوِہ نے مَوشہ کو چھوڑ دیا (اُس وقت اُس کی، ”خُون بہانے والے دُلہا سے،“ مُراد ختنہ تھی)۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","اَور یَاہوِہ نے اَہرونؔ سے کہا، ”مَوشہ سے مُلاقات کرنے کے لیٔے بیابان میں جاؤ۔“ پس وہ خُدا کے پہاڑ پر مَوشہ سے مِلے اَور اَہرونؔ نے مَوشہ کو بوسہ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","تَب مَوشہ نے اَہرونؔ کو وہ سَب کُچھ بتا دیا جسے کہنے کے لیٔے یَاہوِہ نے اُنہیں بھیجا تھا۔ نیز اُن حیرت اَنگیز نِشانات کا بھی ذِکر کیا جِن کے دِکھانے کا یَاہوِہ نے اُنہیں حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","پھر مَوشہ اَور اَہرونؔ گیٔے اَور اُنہُوں نے بنی اِسرائیل کے سَب بُزرگوں کو ایک جگہ جمع کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","اَور اَہرونؔ نے اُنہیں ہر ایک بات بتایٔی جو یَاہوِہ نے مَوشہ سے کہی تھی اَور مَوشہ نے لوگوں کے سامنے معجزے بھی دِکھائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","تَب اُنہُوں نے یقین کیا اَور جَب اُنہُوں نے سُنا کہ یَاہوِہ کو اِسرائیلیوں کا خیال ہے اَور یَاہوِہ نے اُن کی تکالیف دیکھی ہیں تو اُنہُوں نے سَر جھُکا کر سَجدہ کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","بعدازاں مَوشہ اَور اَہرونؔ فَرعوہؔ کے پاس گیٔے اَور فرمایا، ”یَاہوِہ، بنی اِسرائیل کے خُدا کا یہ فرمان ہے: ’میرے لوگوں کو جانے دو تاکہ وہ بیابان میں میرے لیٔے عید منائیں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","فَرعوہؔ نے فرمایا، ”کون ہے یَاہوِہ جِس کی بات میں مَانوں اَور اِسرائیل کو یہاں سے جانے دُوں؟ مَیں یَاہوِہ کو نہیں جانتا اَور مَیں اِسرائیل کو یہاں سے جانے نہیں دُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","تَب اُنہُوں نے کہا، ”عِبرانیوں کے خُدا ہم سے ملے ہیں۔ لہٰذا ہمیں اِجازت دو کہ ہم بیابان میں تین دِن کی مَسافت طے کرکے جایٔیں، اَور یَاہوِہ اَپنے خُدا کے لیٔے قُربانی پیش کریں، ورنہ وہ ہمیں وَبا یا تلوار سے ہلاک کروا دیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","لیکن مِصر کے بادشاہ نے کہا، ”اَے مَوشہ اَور اَہرونؔ، تُم اُن لوگوں سے اُن کا کام کیوں چھُڑوا رہے ہو؟ جاؤ، اَپنا کام کرو!“ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","فَرعوہؔ نے مزید کہا، ”دیکھو، مُلک میں اُن لوگوں کی تعداد بہت بڑھ گئی ہے اَور تُم اُنہیں کام کرنے سے روک رہے ہو!“ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","اَور اُسی دِن فَرعوہؔ نے بیگار لینے والے غُلاموں اَور اُن لوگوں پر نِگرانوں کو یہ حُکم دیا: ");
INSERT INTO urdoucv_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","”آئندہ تُم اُن لوگوں کو اینٹیں بنانے کے لیٔے، بھُوسا مُہیّا نہ کرنا بَلکہ اُنہیں اَپنے لیٔے بھُوسا خُود ہی جا کر جمع کرنے دینا؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","لیکن اُن سے اُتنی ہی اینٹیں بنوانا جِتنی وہ پہلے بناتے تھے؛ اَور اُن کے لیٔے اینٹوں کی مُقرّر کی گئی تعداد کم نہ کرنا؛ وہ کاہل ہیں، اَور اِس لیٔے وہ چِلّا رہے ہیں، ’آؤ چلیں اَور اَپنے خُدا کے لیٔے قُربانی پیش کریں۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","اُن اِنسانوں سے سخت محنت لی جائے تاکہ وہ کام میں مشغُول رہیں، اَور جھُوٹی باتوں کی طرف مُتوجّہ نہ ہوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","تَب اُن بیگار لینے والے غُلاموں اَور اُن نِگراں سرداروں نے جو اُن پر مُقرّر تھے جا کر اُن لوگوں سے کہا، ”فَرعوہؔ یُوں فرماتا ہے، ’آئندہ تُمہیں بھُوسا نہیں دیا جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","بَلکہ تُم اَپنے لیٔے بھُوسا جہاں سے بھی ملے خُود لاؤ مگر تمہارے کام کو ہرگز کم نہیں کیا جائے گا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","لہٰذا وہ لوگ تمام مِصر میں مارے مارے پھرنے لگے، تاکہ ٹھُنٹھ جمع کرکے بھُوسے کی جگہ اِستعمال کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","اَور بیگار لینے والے غُلام اُن پر یہ کہتے ہویٔے دباؤ ڈالتے تھے، ”جِتنا کام تُم بھُوسا پا کر کرتے تھے اُتنا ہی کام اَب بھی کرو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","اَور اُن اِسرائیلی نِگرانوں کو جنہیں فَرعوہؔ کے بیگار لینے والے غُلاموں نے مُقرّر کیا ہُوا تھا مارا پِیٹا جاتا تھا اَور اُن سے پُوچھا جاتا تھا کہ، ”پہلے کی طرح تُم نے کل یا آج اینٹوں کی مُقرّرہ تعداد پُوری کیوں نہیں کی؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","تَب اِسرائیلی نِگراں کاروں نے جا کر فَرعوہؔ سے فریاد کی: ”آپ نے اَپنے خادِموں سے اَیسا سلُوک کیوں کیا ہے؟ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","تمہارے خادِموں کو بھُوسا تو دیانہیں جاتا اَور پھر بھی ہمیں کہا جاتا ہے، ’اینٹیں بناؤ!‘ تمہارے خادِموں کو مارا پِیٹا جاتا ہے؛ حالانکہ قُصُور تو تمہارے لوگوں کا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","فَرعوہؔ نے کہا، ”تُم کاہل ہو۔ کاہل! اِسی لیٔے تُم کہتے رہتے ہو، ’ہمیں جانے اَور یَاہوِہ کے لیٔے قُربانی پیش کرنے کی اِجازت دو۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","اَب جاؤ اَور کام کرو۔ تُمہیں بھُوسا ہرگز نہیں ملے گا، پھر بھی تُمہیں اینٹیں تو مُقرّرہ تعداد میں ہی بنانی پڑیں گی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","جَب اِسرائیلی نِگراں کاروں کو بتایا گیا کہ جِتنی تعداد میں روزانہ اینٹیں بنانے کا تُمہیں حُکم دیا گیا ہے، ”تُم اُنہیں گھٹا نہ پاؤگے تو اُنہیں احساس ہُوا کہ وہ تو بڑی مُشکل میں پھنس گیٔے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","اَور جَب وہ فَرعوہؔ کے پاس سے آئے، تو اُنہُوں نے مَوشہ اَور اَہرونؔ کو اُن سے مُلاقات کے لیٔے اِنتظار کرتے پایا، ");
INSERT INTO urdoucv_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","اَور اُنہُوں نے کہا، ”تُمہیں یَاہوِہ ہی دیکھیں گے اَور تمہارا اِنصاف کریں گے! کیونکہ تُم نے فَرعوہؔ اَور اُس کے اہلکاروں کی نظر میں ہمیں گھِنونا بنا دیا ہے اَور ہمیں قتل کرنے کے لیٔے اُن کے ہاتھ میں تلوار دے دی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","تَب مَوشہ نے یَاہوِہ سے رُجُوع کیا اَور کہا، ”اَے یَاہوِہ! آپ نے اِن لوگوں پر مُصیبت کیوں نازل کی ہے؟ کیا آپ نے مُجھے اِسی لیٔے بھیجا تھا؟ ");
INSERT INTO urdoucv_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","جَب سے مَیں آپ کے نام سے بات کرنے کے لیٔے فَرعوہؔ کے پاس گیا ہُوں وہ اِن لوگوں پر مُصیبت ڈھانے لگا ہے اَور آپ نے اَپنے لوگوں کو بالکُل نہیں بچایا!“ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","تَب یَاہوِہ نے مَوشہ سے کہا، ”اَب تُم دیکھوگے کہ میں فَرعوہؔ کے ساتھ کیا کرتا ہُوں؛ میرے قوی ہاتھ کے باعث وہ اُن کو جانے دے گا اَور میرے ہی قوی ہاتھ کے باعث وہ اُن کو اَپنے مُلک سے نکال دے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","اَور خُدا نے مَوشہ سے یہ بھی کہا، ”مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","میں اَبراہامؔ، اِصحاقؔ اَور یعقوب کو قادرمُطلق خُدا کے طور پر دِکھائی دیا لیکن مَیں اَپنے نام یَاہوِہ سے اُن پر پُوری طور سے ظاہر نہ ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","اَور مَیں نے اُن کے ساتھ اَپنا عہد بھی باندھا کہ مُلکِ کنعانؔ جہاں وہ پردیسیوں کی طرح رہے اُنہیں دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","علاوہ اَزیں مَیں نے بنی اِسرائیل کا کراہنا سُنا ہے جنہیں مِصری اَپنا غُلام بناتے جا رہے ہیں اَور اَب مَیں نے اَپنے عہد کو یاد کیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","”اِس لیٔے بنی اِسرائیل سے کہنا: ’مَیں یَاہوِہ ہُوں۔ میں تُمہیں مِصریوں کے جُوئے کے نیچے سے نکال لاؤں گا اَور مَیں اَپنے بازو پھیلا کر تُمہیں اُن کی غُلامی سے رِہائی بخشوں گا اَور اُن کا اِنصاف کروں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","اَور مَیں تُمہیں اَپنا کر اَپنی قوم بنا لُوں گا اَور مَیں تمہارا خُدا ہُوں گا۔ تَب تُم جانوگے کہ مَیں یَاہوِہ تمہارا خُدا ہُوں جو تُمہیں مِصریوں کے جُوئے کے نیچے سے نکال لایا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","اَور مَیں تُمہیں اُس مُلک میں لے جاؤں گا جسے اَبراہامؔ، اِصحاقؔ اَور یعقوب کو دینے کے لیٔے مَیں نے ہاتھ اُٹھاکر قَسم کھائی تھی۔ میں اُسے بطور مِیراث تُمہیں دے دُوں گا۔ مَیں یَاہوِہ ہُوں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","مَوشہ نے یہ باتیں بنی اِسرائیل کو سُنائیں لیکن اُنہُوں نے اُس پر کوئی توجّہ نہ کی کیونکہ غُلامی کی سختی کے باعث اُن کے حوصلے پست ہوکر رہ گیٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","تَب یَاہوِہ نے مَوشہ کو فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","”جا کر، مِصر کے بادشاہ فَرعوہؔ سے کہنا کہ بنی اِسرائیل کو اَپنے مُلک سے چلے جانے دو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","لیکن مَوشہ نے یَاہوِہ سے کہا، ”اگر بنی اِسرائیل نے میری نہ سُنی تو، فَرعوہؔ میری کیونکر سُنے گا جَب کہ میری زبان میں لکنت ہے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","تَب یَاہوِہ نے مَوشہ اَور اَہرونؔ سے بنی اِسرائیل اَور فَرعوہؔ مِصر کے بادشاہ کے بارے میں بات کی اَور اُنہیں حُکم دیا کہ بنی اِسرائیل کو مِصر سے نکال لے جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","اُن کے آبائی برادریوں کے سردار یہ تھے: رُوبِنؔ جو اِسرائیل کا پہلوٹھا بیٹا تھا، رُوبِنؔ کے بٹے حنوخؔ اَور پلوّؔ، حِضرونؔ اَور کرمی تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","شمعُونؔ کے بیٹے یہ تھے: یموایلؔ، یمینؔ، اُہدؔ، یاکِن، ضُحرؔ اَور شاؤل جو ایک کنعانی عورت سے پیدا ہُوئے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","اَور لیوی کے بیٹوں کے نام جِن سے اُن کی نَسل چلی یہ تھے: گیرشون قُہات اَور مِراریؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","اَور گیرشون کے بیٹے جِن سے اُن کی برادری چلی یہ تھے: لِبنیؔ اَور شِمعیؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","اَور بنی قُہات یہ تھے: عمرامؔ، اِضہاؔر، حِبرونؔ اَور عُزّی ايل۔ قُہات ایک سَو تینتیس بَرس زندہ رہا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","اَور بنی مِراریؔ یہ تھے: محلیؔ اَور مُوشیؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","اَور عمرامؔ نے اَپنے باپ کی بہن یوکبِدؔ سے شادی کی جِس سے اُس کے بیٹے اَہرونؔ اَور مَوشہ پیدا ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","بنی اِضہاؔر یہ تھے: قورحؔ نِفیگ اَور زکریؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","اَور بنی عُزّی ايل یہ تھے: میشاایلؔ، اِیلضافنؔ اَور سِتھریؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","اَور اَہرونؔ نے الیسبعؔ سے شادی کی جو عَمّیندابؔ کی بیٹی اَور نحشونؔ کی بہن تھی جِس سے اُس کے بیٹے نادابؔ، اَبِیہُو، الیعزرؔ اَور اِتمارؔ پیدا ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","اَور بنی قورحؔ یہ تھے: اَسّیر، اِلقانہؔ اَور ابیاسافؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","اَور اَہرونؔ کے بیٹے الیعزرؔ نے پُطی ایل کی بیٹیوں میں سے ایک کے ساتھ شادی کی اَور اُس سے اُس کا بیٹا فِنحاسؔ پیدا ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","اَور یہ وُہی اَہرونؔ اَور مَوشہ ہیں جنہیں یَاہوِہ نے فرمایا تھا، ”بنی اِسرائیل کو اُن کے لشکروں کے مُطابق مِصر سے نکال لے جاؤ۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","یہ وُہی مَوشہ اَور اَہرونؔ ہیں جنہوں نے بنی اِسرائیل کو مِصر سے باہر نکال لے جانے کے بارے میں مِصر کے بادشاہ فَرعوہؔ سے بات کی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","جَب یَاہوِہ نے مِصر میں مَوشہ سے کلام کیا تھا ");
INSERT INTO urdoucv_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","تو مَوشہ سے فرمایا تھا، ”مَیں یَاہوِہ ہُوں۔ جو کُچھ میں تُمہیں کہُوں تُم اُسے مِصر کے بادشاہ فَرعوہؔ سے کہنا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","لیکن مَوشہ نے یَاہوِہ سے کہا، ”چونکہ میری زبان میں لکنت ہے اِس لیٔے فَرعوہؔ میری بات کیوں سُنے گا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","تَب یَاہوِہ نے مَوشہ سے فرمایا، ”دیکھو، مَیں نے تُمہیں فَرعوہؔ کے لیٔے گویا خُدا ٹھہرایا ہے اَور تمہارا بھایٔی اَہرونؔ تمہارا نبی ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","اَور تُم ہر ایک بات جِس کا میں تُمہیں حُکم دُوں کہنا اَور تمہارا بھایٔی اَہرونؔ فَرعوہؔ سے کہے کہ بنی اِسرائیل کو فَرعوہؔ اَپنے مُلک سے جانے دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","لیکن مَیں فَرعوہؔ کے دِل کو سخت کر دُوں گا اَور خواہ میں اَپنے حیرت اَنگیز نِشانات اَور عجائب مِصر میں کثرت سے دِکھاؤں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","تو بھی فَرعوہؔ تمہاری نہ سُنے گا۔ تَب میں مِصر پر اَپنا ہاتھ ڈالوں گا اَور اُنہیں سخت ترین سزائیں دے کر اَپنے لوگوں یعنی بنی اِسرائیل کے لشکروں کو نکال لاؤں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","اَور جَب مَیں مِصریوں کے خِلاف اَپنا ہاتھ بڑھا کر بنی اِسرائیل کو نکال لاؤں گا تَب مِصری جانیں گے کہ مَیں یَاہوِہ ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","چنانچہ مَوشہ اَور اَہرونؔ نے بالکُل وَیسا ہی کیا جَیسا یَاہوِہ نے اُنہیں حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","مَوشہ اسّی بَرس کے اَور اَہرونؔ تراسی بَرس کے تھے جَب وہ فَرعوہؔ سے ہم کلام ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","اَور یَاہوِہ نے مَوشہ اَور اَہرونؔ سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","”جَب فَرعوہؔ تُم سے کہے کہ کویٔی معجزہ دِکھاؤ، تو اَہرونؔ سے کہنا، ’اَپنا عصا لے کر فَرعوہؔ کے سامنے ڈال دے،‘ اَور وہ سانپ بَن جائے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","سو مَوشہ اَور اَہرونؔ فَرعوہؔ کے پاس گیٔے اَور اُنہُوں نے وُہی کیا جِس کا یَاہوِہ نے حُکم دیا تھا۔ اَہرونؔ نے اَپنا عصا لیا اَور اُسے فَرعوہؔ اَور اُس کے اہلکاروں کے سامنے ڈال دیا اَور وہ سانپ بَن گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","تَب فَرعوہؔ نے اَپنے حکیموں اَور اوجھاؤں کو طلب کیا اَور مِصری جادُوگروں نے بھی اَپنے جادُو کے زور سے وَیسا ہی کر دِکھایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","اَور ہر ایک نے جَب اَپنا اَپنا عصا نیچے پھینکا تو وہ سانپ بَن گیٔے۔ لیکن اَہرونؔ کے عصا نے اُنہیں نگل لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","اِس کے باوُجُود فَرعوہؔ کا دِل سخت ہو گیا اَور جَیسا کہ یَاہوِہ نے کہاتھا اُس نے اُن کی نہ سُنی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","تَب یَاہوِہ نے مَوشہ سے کہا، ”فَرعوہؔ کا دِل پگھلنے والا نہیں ہے، اَور وہ اُن لوگوں کو جانے سے روکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","صُبح کو جَب فَرعوہؔ دریا پر جائے تو تُم اُس کے پاس جانا اَور اُس سے مُلاقات کے لیٔے دریائے نیل کے کنارے اِنتظار کرنا اَور اَپنے ہاتھ میں وہ عصا لے لینا جو سانپ بَن گیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","اَور پھر اُس سے کہنا، ’یَاہوِہ عِبرانیوں کے خُدا نے مُجھے یہ کہنے کے لیٔے تمہارے پاس بھیجا ہے کہ میرے لوگوں کو جانے دے تاکہ وہ بیابان میں میری عبادت کریں؛ لیکن اَب تک تُم نے اُن کی نہیں سُنی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","لہٰذا یَاہوِہ یُوں فرماتے ہیں کہ اِسی سے تُم جان لوگے کہ مَیں یَاہوِہ ہُوں۔ دیکھو میں اِس عصا کو جو میرے ہاتھ میں ہے دریائے نیل کے پانی پر ماروں گا اَور وہ پانی خُون میں بدل جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","اَور دریائے نیل کی مچھلیاں مَر جایٔیں گی اَور دریا میں سے بدبُو آنے لگے گی اَور مِصری اُس کا پانی نہ پی سکیں گے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","یَاہوِہ نے مَوشہ سے کہا، ”اَہرونؔ سے کہنا، ’اَپنا عصا لے اَور مِصر کے تمام دریاؤں نہروں جھیلوں اَور تالابوں کے پانی پر اَپنا ہاتھ بڑھا تاکہ وہ خُون بَن جایٔیں،‘ اَور مِصر میں ہر جگہ لکڑی اَور پتّھر کے برتنوں میں بھی خُون ہی خُون ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","اَور مَوشہ اَور اَہرونؔ نے وَیسا ہی کیا جَیسا کہ یَاہوِہ نے حُکم دیا تھا۔ اُنہُوں نے فَرعوہؔ اَور اُس کے اہلکاروں کی مَوجُودگی میں اَپنا عصا اُٹھاکر دریائے نیل کے پانی پر مارا اَور سارا پانی خُون میں بدل گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","دریائے نیل کی مچھلیاں مَر گئیں اَور دریا سے اِتنی بدبُو آنے لگی کہ مِصری اُس کا پانی نہ پی سکے۔ مِصر میں ہر جگہ خُون ہی خُون نظر آنے لگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","لیکن مِصری جادُوگروں نے بھی اَپنے جادُو کے زور سے وَیسا ہی کیا اَور فَرعوہؔ کا دِل سخت ہو گیا اَور جَیسا یَاہوِہ نے فرمایا تھا اُس نے مَوشہ اَور اَہرونؔ کی بات اَن سُنی کر دی ");
INSERT INTO urdoucv_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","بَلکہ فَرعوہؔ لَوٹ کر اَپنے محل میں چلا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","اَور تمام مِصریوں نے پینے کا پانی حاصل کرنے کے لیٔے دریائے نیل کے کنارے کنارے کھدائی کی کیونکہ وہ ندی کا پانی نہ پی سکے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","یَاہوِہ کے دریائے نیل پر مارنے کے بعد سات دِن گزر گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","تَب یَاہوِہ نے مَوشہ سے کہا، ”فَرعوہؔ کے پاس جاؤ اَور اُس سے کہو، ’یَاہوِہ یُوں فرماتے ہیں، میرے لوگوں کو جانے دو، تاکہ وہ میری عبادت کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","اگر تُم اُنہیں جانے نہ دوگے، تو مَیں تمہارے سارے مُلک کو مینڈکوں کی وَبا سے پریشان کر دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","اَور دریائے نیل مینڈکوں سے بھر جائے گا اَور وہ تمہارے محل کے اَندر، تمہاری خواب گاہ میں اَور تمہارے پلنگ پر، تمہارے اہلکاروں اَور تمہاری رعایا کے گھروں میں، تنوروں میں اَور آٹا گُوندھنے کے لگنوں میں گُھسنے لگیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","اَور مینڈک تُم پر، تمہارے لوگوں پر اَور تمہارے تمام اہلکاروں پر چڑھ آئیں گے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","پھر یَاہوِہ نے مَوشہ سے کہا، ”اَہرونؔ سے کہو، ’اَپنا عصا لے کر اَپنا ہاتھ دریاؤں، نہروں اَور جھیلوں پر بڑھا اَور مینڈکوں کو مِصر کی سرزمین پر چڑھا لا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","چنانچہ اَہرونؔ نے مِصر کے سارے پانی پر اَپنا ہاتھ بڑھایا اَور اِتنے مینڈک برپا ہو گئے کہ اُن سے مِصر کی ساری زمین چھُپ گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","لیکن مِصر کے جادُوگروں نے بھی اَپنے جادُو کے زور سے اَیسا ہی کیا اَور وہ بھی مینڈکوں کو مُلک مِصر پر چڑھا لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","تَب فَرعوہؔ نے مَوشہ اَور اَہرونؔ کو طلب کیا اَور کہا، ”یَاہوِہ سے دعا کرو کہ وہ اِن مینڈکوں کو مُجھ سے اَور میری رعایا سے دُور کرے، اَور مَیں تمہارے لوگوں کو جانے دُوں گا، تاکہ وہ یَاہوِہ کے لیٔے قُربانی پیش کریں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","مَوشہ نے فَرعوہؔ سے کہا، ”وہ وقت مُقرّر کرنے کا حق مَیں تمہارے لیٔے چھوڑتا ہُوں۔ مُجھے بتاؤ کہ تمہارے اہلکاروں اَور تمہارے لوگوں کے لیٔے کب دعا کروں تاکہ تُم اَور تمہارے گھر مینڈکوں سے چھُٹکارا پائیں سِوائے اُن مینڈکوں کے جو دریائے نیل میں رہتے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","فَرعوہؔ نے کہا، ”کل۔“ مَوشہ نے جَواب دیا، ”جَیسا تُم چاہتے ہو، وَیسا ہی ہوگا تاکہ تُم جان لو کہ ہمارے خُدا یَاہوِہ کی مانند کویٔی بھی نہیں ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","اَور مینڈک تُمہیں، تمہارے گھروں کو، تمہارے اہلکاروں اَور تمہاری رعایا کو چھوڑکر چلے جایٔیں گے اَور وہ صِرف دریائے نیل میں ہی رہیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","اَور جَب مَوشہ اَور اَہرونؔ فَرعوہؔ کے پاس سے چلے گیٔے تو مَوشہ نے اُن مینڈکوں کے بارے مَیں یَاہوِہ ہُوں سے فریاد کی جنہیں اُس نے فَرعوہؔ پر بھیجا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","اَور یَاہوِہ نے مَوشہ کی درخواست کے مُطابق کیا، اَورجو مینڈک گھروں، صحنوں اَور کھیتوں میں تھے مَر گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","اَور لوگوں نے اُنہیں جمع کرکے اُن کے ڈھیر لگا دئیے اَور اُن کے سَڑنے کی بدبُو چاروں طرف پھیل گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","لیکن جَب فَرعوہؔ نے دیکھا کہ مُصیبت ٹل گئی تو اُس نے اَپنا دِل سخت کر لیا اَور مَوشہ اَور اَہرونؔ کی نہ سُنی جَیسا کہ یَاہوِہ نے فرمایا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","تَب یَاہوِہ نے مَوشہ سے کہا، ”اَہرونؔ سے کہو، ’اَپنا عصا بڑھا کر زمین کی گَرد پر مار،‘ اَور وہ سارے مِصر میں جُوؤں میں تبدیل ہو جائے گی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","اُنہُوں نے اَیسا ہی کیا اَور جَب اَہرونؔ نے اَپنا عصا لے کر ہاتھ بڑھایا اَور زمین کی گَرد پر مارا تو وہ اِنسانوں اَور جانوروں پر جُوؤں میں تبدیل ہو گئی اَور مِصر کی زمین کی ساری گَرد جُوئیں بَن گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","لیکن جَب مِصر کے جادُوگروں نے اَپنے جادُو سے جُوئیں پیدا کرنے کی کوشش کی تو وہ ناکام رہے۔ اَور سَب جگہ اِنسانوں اَور جانوروں پر جُوئیں چڑھتی گئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","تَب جادُوگروں نے فَرعوہؔ سے کہا، ”یہ خُدا کا کام ہے!“ لیکن فَرعوہؔ کا دِل تو پہلے ہی سخت تھا، اَور جَیسا کہ یَاہوِہ نے کہہ دیا تھا، اُس نے اُن کی نہ سُنی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","پھر یَاہوِہ نے مَوشہ سے کہا، ”تُم صُبح سویرے اُٹھنا اَور جَب فَرعوہؔ دریا پر آئے تو اُس کے رُوبرو ہوکر اُس سے کہنا، ’یَاہوِہ یُوں فرماتے ہیں: میرے لوگوں کو جانے دو، تاکہ وہ میری عبادت کر سکیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","لیکن اگر تُم میرے لوگوں کو جانے نہ دوگے، تو میں مکھّیوں کے جھُنڈ کے جھُنڈ تُجھ پر، تمہارے اہلکاروں پر، تمہاری رعایا پر اَور تمہارے گھروں میں بھیج دُوں گا اَور مِصریوں کے گھر مکھّیوں سے بھر جایٔیں گے اَور ساری زمین بھی جہاں کہیں وہ ہوں گے مکھّیوں سے بھر جائے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","” ’لیکن اُس دِن میں گوشینؔ کے علاقہ سے، جہاں میرے لوگ رہتے ہیں؛ اَیسا برتاؤ نہ کروں گا، وہاں مکھّیوں کے جھُنڈ نہیں ہوں گے تاکہ تُم جان لو کہ مَیں یَاہوِہ اِس مُلک میں ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","اَور مَیں اَپنے لوگوں اَور تمہارے لوگوں میں اِمتیاز کروں گا اَور یہ معجزانہ علامت کل ظہُور میں آئے گی۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","اَور یَاہوِہ نے اَیسا ہی کیا اَور مکھّیوں کے جھُنڈ کے جھُنڈ فَرعوہؔ کے محل میں اَور اُس کے اہلکاروں کے گھروں میں آ گھُسے اَور سارے مِصر کی زمین مکھّیوں کی وجہ سے خَراب ہو گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","تَب فَرعوہؔ نے مَوشہ اَور اَہرونؔ کو طلب کیا اَور کہا، ”جاؤ اَور اَپنے خُدا کے لیٔے یہاں اِسی مُلک میں قُربانی پیش کرو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","لیکن مَوشہ نے کہا، ”یہ مُناسب نہ ہوگا کیونکہ وہ قُربانیاں جو مِصریوں کی نگاہ میں سخت مکرُوہ ہیں جَب ہم اُنہیں اَپنے یَاہوِہ خُدا کے حُضُور پیش کریں گے، تو کیا مِصری ہمیں سنگسار نہ کر ڈالیں گے؟ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","پس ہمیں یَاہوِہ اَپنے خُدا کے لیٔے قُربانیاں گزراننے کے لیٔے جَیسا کہ اُنہُوں نے حُکم دیا ہے لازماً بیابان میں تین دِن کا سفر اِختیار کرنا ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","فَرعوہؔ نے کہا، ”میں تُمہیں یَاہوِہ تمہارے خُدا کے لیٔے قُربانیاں پیش کرنے کے لیٔے بیابان میں جانے دُوں گا۔ لیکن تُم بہت دُور مت جانا۔ اَب میرے لیٔے خُدا سے دعا کرو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","مَوشہ نے جَواب دیا، ”جوں ہی مَیں تمہارے پاس سے جاؤں گا مَیں یَاہوِہ سے دعا کروں گا اَور ساری مکھّیاں فَرعوہؔ، اُس کے اہلکاروں اَور لوگوں کے پاس سے چلی جایٔیں گی۔ فقط اِتنا دھیان رکھنا کہ فَرعوہؔ اِس دفعہ پھر دھوکا بازی نہ کرے اَور لوگوں کو یَاہوِہ کے لیٔے قُربانی پیش کرنے کے لیٔے جانے کی اِجازت نہ دے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","تَب مَوشہ فَرعوہؔ کے پاس سے چلےگئے اَور اُنہُوں نے یَاہوِہ سے دعا کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","اَور یَاہوِہ نے مَوشہ کی درخواست کے مُطابق کیا۔ لہٰذا وہ ساری مکھّیاں فَرعوہؔ، اُس کے اہلکاروں اَور اُس کے لوگوں کے پاس سے چلی گئیں اَور ایک بھی باقی نہ رہی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","لیکن اِس دفعہ بھی فَرعوہؔ نے اَپنا دِل سخت کر لیا اَور اُن لوگوں کو جانے نہ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","تَب یَاہوِہ نے مَوشہ سے کہا، ”فَرعوہؔ کے پاس جا کر اُس سے کہو، ’یَاہوِہ عِبرانیوں کے خُدا یُوں فرماتے ہیں‏: ”میرے لوگوں کو جانے دے تاکہ وہ میری عبادت کریں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","لیکن اگر تُم اِنکار کرو اَور اُنہیں جانے نہ دوگے، ");
INSERT INTO urdoucv_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","تو یَاہوِہ کا ہاتھ تمہارے چَوپایوں پرجو کھیتوں میں ہیں یعنی گھوڑوں، گدھوں، اُونٹوں اَور گائے بَیلوں اَور بھیڑ بکریوں پر بڑی خوفناک وَبا لایٔے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","لیکن یَاہوِہ بنی اِسرائیل کے چَوپایوں اَور مِصریوں کے چَوپایوں میں اِمتیاز کریں گے تاکہ اِسرائیلیوں کا ایک چَوپایہ بھی ہلاک نہ ہو۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","اَور یَاہوِہ نے ایک وقت مُقرّر کر دیا اَور بتا دیا، ”کل یَاہوِہ اِس مُلک میں یہی کریں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","اَور اگلے دِن یَاہوِہ نے اَیسا ہی کیا اَور مِصریوں کے تمام چَوپائے مَر گیٔے لیکن اِسرائیلیوں کا ایک چَوپایہ بھی نہ مَرا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","چنانچہ فَرعوہؔ نے تحقیقات کرنے کے لیٔے اِنسان بھیجے اَور اُسے مَعلُوم ہُوا کہ اِسرائیلیوں کے چَوپایوں میں سے ایک بھی نہیں مَرا تھا۔ پھر بھی فَرعوہؔ کا دِل پگھلنے والا نہ تھا اَور اُس نے لوگوں کو جانے نہ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","تَب یَاہوِہ نے مَوشہ اَور اَہرونؔ سے کہا، ”کسی بھٹّی سے راکھ لے کر اَپنی مُٹھّیوں میں بھر لو اَور مَوشہ اُسے فَرعوہؔ کے سامنے ہَوا میں اُڑا دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","اَور یہ تمام مُلک مِصر میں مہین گَرد بَن کر سارے مُلک میں اِنسانوں اَور جانوروں کے جِسم پر پھوڑے اَور پھپھولے پیدا کر دے گی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","پس وہ ایک بھٹّی سے راکھ لے کر فَرعوہؔ کے سامنے جا کھڑے ہویٔے اَور مَوشہ نے اُسے ہَوا میں اُوپر اُڑا دیا جِس سے اِنسانوں اَور جانوروں کے جِسم پر پھوڑے اَور پھپھولے نکل آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","اَور مِصر کے جادُوگر اُن پھوڑوں اَور پھپھولوں کی وجہ سے جو اُنہیں اَور سَب مِصریوں کو نکلے ہویٔے تھے مَوشہ کے سامنے ٹھہر نہ سکے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","لیکن یَاہوِہ نے فَرعوہؔ کے دِل کو سخت کر دیا اَور اُس نے جَیسا کہ یَاہوِہ نے مَوشہ سے کہہ دیا تھا اُن کی نہ سُنی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","پھر یَاہوِہ نے مَوشہ سے کہا، ”صُبح سویرے اُٹھ کر فَرعوہؔ کے رُوبرو جاؤ اَور اُس سے کہو، ’یَاہوِہ عِبرانیوں کے خُدا یُوں فرماتے ہیں کہ میرے لوگوں کو جانے دے تاکہ وہ میری عبادت کریں ");
INSERT INTO urdoucv_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ورنہ اِس دفعہ میں اَپنی وَباؤں کو پُوری شِدّت سے تمہارے، تمہارے اہلکاروں اَور تمہاری رعایا کے خِلاف بھیجوں گا تاکہ تُم جان لو کہ تمام دُنیا میں میرا ہمسر کویٔی نہیں ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","کیونکہ اَب تک میں اَپنا ہاتھ بڑھا کر تُمہیں اَور تمہارے لوگوں کو کسی اَیسی وَبا سے مار سَکتا تھا جو رُوئے زمین سے تمہارا نام و نِشان مٹا دیتی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","لیکن مَیں نے تُمہیں اِس لیٔے برپا کیا ہے تاکہ میں تُم پر اَپنی قُدرت ظاہر کروں اَور ساری زمین میں میرا نام مشہُور ہو جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","تُم اَب بھی میرے لوگوں کی مُخالفت پر آمادہ ہو اَور اُنہیں جانے نہیں دیتے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","اِس لیٔے کل اِسی وقت میں اَیسی بدترین ژالہ باری کروں گا کہ جَب سے مِصر کی بُنیاد پڑی ہے وَیسی آج تک نہیں ہُوئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","پس اَپنے چَوپایوں کو اَورجو کچھ تمہارا مال کھیتوں میں ہے اُسے اَندر لے آؤ کیونکہ جتنے اِنسان اَور جانور میدان میں ہوں گے اَور اَندر نہیں پہُنچائے جایٔیں گے اُن پر اولے گریں گے اَور وہ ہلاک ہو جایٔیں گے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","اَور فَرعوہؔ کے وہ اہلکار جو یَاہوِہ کی اِس بات سے ڈرے وہ جلدی سے بھاگ دَوڑکر اَپنے غُلاموں اَور چَوپایوں کو گھروں میں لے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","لیکن جنہوں نے یَاہوِہ کی اِس بات کو نظرانداز کر دیا اُنہُوں نے اَپنے غُلاموں اَور چَوپایوں کو میدان میں ہی رہنے دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","تَب یَاہوِہ نے مَوشہ سے کہا، ”اَپنا ہاتھ آسمان کی طرف بڑھاؤ تاکہ سارے مِصر میں ژالہ باری ہو۔ یعنی اِنسانوں اَور جانوروں پر اَور ہر سبزی پرجو مِصر کے کھیتوں میں اُگتی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","اَور جَب مَوشہ نے اَپنا عصا آسمان کی طرف بڑھایا تو یَاہوِہ نے بجلی اَور اولے بھیجے اَور بجلی زمین تک کوندی اَور یَاہوِہ نے سارے مِصر پر اولے برسائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","پس اولوں کے ساتھ ساتھ اِدھر اُدھر بجلی بھی گری، جَب سے مُلک مِصر وُجُود میں آیا یہ مُلک مِصر کی بدترین ژالہ باری تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","اَور اولوں نے سارے مِصر میں اُن سَب اِنسانوں اَور جانوروں کو مارا جو کھیتوں یا میدان میں تھے اَور اِس ژالہ باری نے کھیتوں میں اُگی ہویٔی ہر چیز تباہ کر ڈالی اَور سَب درخت توڑ دئیے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","صِرف گوشینؔ کے علاقہ میں جہاں بنی اِسرائیل رہتے تھے اولے نہ گِرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","تَب فَرعوہؔ نے مَوشہ اَور اَہرونؔ کو طلب کیا۔ اَور اُن سے کہا، ”اِس دفعہ مَیں نے گُناہ کیا ہے،“ یَاہوِہ صادق ہیں، ”اَور مَیں اَور میرے لوگ خطاوار ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","یَاہوِہ سے دعا کرو کیونکہ ہم ژالہ باری اَور بجلی کی گھن گرج سے تنگ آ چُکے ہیں۔ میں تُمہیں جانے دُوں گا اَور تُمہیں مزید رُکنا نہیں پڑےگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","مَوشہ نے جَواب دیا، ”جَب مَیں شہر سے باہر چلا جاؤں گا تو میں دعا کے لیٔے اَپنے ہاتھ یَاہوِہ کی طرف پھیلاؤں گا؛ تَب گھن گرج بندہو جائے گی اَور اُس کے بعد اولے بھی نہ گریں گے تاکہ تُم جان لو کہ دُنیا یَاہوِہ ہی کی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","لیکن مَیں جانتا ہُوں کہ تُم اَور تمہارے اہلکار اَب بھی یَاہوِہ خُدا سے نہیں ڈرتے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(سَن اَور جَو اولوں سے برباد ہو گیٔے کیونکہ جَو کی بالیں نکل چُکی تھیں اَور سَن میں پھُول لگے ہویٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","لیکن ہر قِسم کے گیہُوں تباہی سے بچ گیٔے کیونکہ اُن کے پکنے کا موسم نہ آیاتھا۔) ");
INSERT INTO urdoucv_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","تَب مَوشہ فَرعوہؔ سے رخصت ہوکر شہر کے باہر گئے اَور اُنہُوں نے اَپنے ہاتھ یَاہوِہ کی طرف پھیلائے۔ لہٰذا بجلی کی گھن گرج اَور اولے گرنے بندہو گیٔے اَور زمین پر بارش بھی تھم گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","جَب فَرعوہؔ نے دیکھا کہ بارش، ژالہ باری اَور بجلی کی گھن گرج ختم ہو گئی تو اُس نے پھر گُناہ کیا اَور اُس کا اَور اُس کے اہلکاروں کا دِل نہ پسیجا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","چنانچہ فَرعوہؔ کا دِل سخت ہو گیا اَور اُس نے اِسرائیلیوں کو جانے نہ دیا جَیسا کہ یَاہوِہ نے مَوشہ کی مَعرفت کہہ دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","تَب یَاہوِہ نے مَوشہ سے کہا، ”فَرعوہؔ کے پاس جاؤ کیونکہ مَیں نے ہی اُن کے دِل اَور اُن کے سرداروں کے دِلوں کو سخت کیا ہے تاکہ میں اَپنے یہ نِشانات اُن کے درمیان دِکھاؤں، ");
INSERT INTO urdoucv_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","اَور تُم اَپنے بچّوں اَور بچّوں کے بچّوں کو بتا سکو کہ مَیں نے مِصریوں کے ساتھ کِس قدر سخت سلُوک کیا اَور اُن کے درمیان مَیں نے کِس طرح اَپنے نِشانات دِکھائے تاکہ تُم جان لو کہ میں ہی یَاہوِہ ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","پس مَوشہ اَور اَہرونؔ نے فَرعوہؔ کے پاس جا کر کہا، ”یَاہوِہ عِبرانیوں کے خُدا یُوں فرماتے ہیں، ’تُم کب تک میرے سامنے خاکسار نہ ہوگے؟ میرے لوگوں کو جانے دو تاکہ وہ میری عبادت کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","اَور اگر تُم اُنہیں جانے نہ دوگے تو کل مَیں تمہارے مُلک پر ٹِڈّیاں لے آؤں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","اَور وہ رُوئے زمین کو اَیسے ڈھانک دیں گی کہ وہ نظر نہ آسکے گی اَور اولوں کے بعد جو کچھ تھوڑا باقی بچا ہے اُسے اَور تمہارے کھیتوں میں اُگے ہویٔے ہر درخت کو ٹِڈّیاں چٹ کر جایٔیں گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","اَور وہ تُم، اَور تمہارے اہلکاروں اَور تمام مِصریوں کے گھروں میں بھر جایٔیں گی۔ اَیسی بات تمہارے آباؤاَجداد نے اِس مُلک میں آباد ہونے کے وقت سے لے کر آج تک کبھی نہیں دیکھی ہوگی۔‘ “ پھر مَوشہ نے مُنہ پھیرا اَور فَرعوہؔ کے پاس سے چلےگئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","تَب فَرعوہؔ کے حاکموں نے اُس سے کہا، ”یہ اِنسان کب تک ہمارے لیٔے پھندا بنا رہے گا؟ لوگوں کو جانے دے تاکہ وہ یَاہوِہ اَپنے خُدا کی عبادت کر سکیں۔ کیا تُمہیں خبر نہیں کہ مِصر اُجڑ چُکاہے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","تَب مَوشہ اَور اَہرونؔ کو پھر سے فَرعوہؔ کے پاس حاضِر کیا گیا اَور اُس نے کہا، ”جاؤ اَور یَاہوِہ اَپنے خُدا کی عبادت کرو لیکن جایٔیں گے کون کون؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","مَوشہ نے جَواب دیا، ”ہم اَپنے جَوانوں، بُوڑھوں، اَپنے بیٹوں اَور بیٹیوں، اَپنی بھیڑ بکریوں اَور گائے بَیلوں سمیت جایٔیں گے کیونکہ ہمیں اَپنے یَاہوِہ کی عید منانا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","تَب فَرعوہؔ نے کہا، ”اَچھّا، یَاہوِہ تمہارا مُحافظ ہو! میں تو تُمہیں تمہارے بال بچّوں سمیت جانے دُوں گا پر اَیسا لگتا ہے کہ تُم شرارت پر آمادہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","نہیں! صِرف مَردوں کو لے جا کر یَاہوِہ کی عبادت کرو کیونکہ اِسی بات کا تُم مطالبہ کرتے رہے ہو۔“ تَب مَوشہ اَور اَہرونؔ دونوں فَرعوہؔ کے دربار سے باہر نکال دئیے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","تَب یَاہوِہ نے مَوشہ سے کہا، ”اَپنا ہاتھ مِصر پر بڑھا تاکہ اُس سرزمین پر ٹِڈّیوں کا جھُنڈ آئے اَورجو کچھ کھیتوں میں اُگا ہُواہے اَور اولوں کی مار سے بچ گیا ہے اُسے چٹ کر جایٔیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","لہٰذا مَوشہ نے اَپنا عصا مِصر پر بڑھایا اَور یَاہوِہ نے دِن بھر اَور رات بھر اُس مُلک میں پُروا آندھی چلائی جو صُبح ہوتے ہی اَپنے ہمراہ ٹِڈّیاں لے آئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","اَور ٹِڈّیوں نے سارے مِصر پر حملہ کیا اَور اُن کے جھُنڈ کے جھُنڈ اُس مُلک کے ہر حِصّہ میں جا ٹِکے۔ ٹِڈّیوں کی اَیسی وَبا نہ پہلے کبھی آئی تھی اَور نہ آئے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","اُنہُوں نے وہاں کی تمام زمین کو ڈھانک دیا یہاں تک کہ وہ سیاہ نظر آنے لگی اَور کھیتوں میں جو کُچھ اُگا ہُوا تھا اُسے اَور درختوں کے پھلوں کو جو اولوں کی مار سے بچ گیٔے تھے چٹ کر گئیں اَور سارے مُلک مِصر میں درختوں اَور پَودوں پر کویٔی سبز پتّہ باقی نہ بچا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","تَب فَرعوہؔ نے مَوشہ اَور اَہرونؔ کو فوراً طلب کیا اَور کہا، ”مَیں نے تمہارے خُدا یَاہوِہ کے اَور تمہارے خِلاف گُناہ کیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","اَب ایک دفعہ پھر میرا گُناہ مُعاف کر دو اَور یَاہوِہ اَپنے خُدا سے دعا کرو کہ وہ اِس مہلِک وَبا کو مُجھ سے دُور کر دیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","اِس پر مَوشہ فَرعوہؔ کے پاس سے چلےگئے اَور اُنہُوں نے یَاہوِہ سے دعا کی، ");
INSERT INTO urdoucv_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","اَور یَاہوِہ نے مغرب کی جانِب سے شدید آندھی بھیجی جو ٹِڈّیوں کو اُڑا لے گئی اَور اُنہیں بحرِقُلزمؔ میں ڈال دیا اَور مِصر میں کہیں بھی کویٔی ٹِڈّی باقی نہ رہی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","لیکن یَاہوِہ نے فَرعوہؔ کے دِل کو سخت کر دیا اَور اُس نے بنی اِسرائیل کو جانے نہ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","تَب یَاہوِہ نے مَوشہ سے کہا، ”اَپنا ہاتھ آسمان کی طرف بڑھاؤ تاکہ مِصر میں تاریکی پھیل جائے۔ اَیسی گہری تاریکی جسے چھُو سکیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","لہٰذا مَوشہ نے اَپنا ہاتھ آسمان کی طرف بڑھایا اَور تین دِن تک سارے مِصر میں گہری تاریکی پھیلی رہی، ");
INSERT INTO urdoucv_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","اَور تین دِن تک نہ تو کویٔی کسی دُوسرے کو دیکھ سَکا اَور نہ اَپنی جگہ سے ہل سَکا لیکن اُن تمام مقامات میں جہاں تمام بنی اِسرائیل رہتے تھے رَوشنی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","تَب فَرعوہؔ نے مَوشہ کو طلب کیا اَور کہا، ”جاؤ یَاہوِہ کی عبادت کرو۔ تمہارے بال بچّے بھی تمہارے ساتھ جا سکتے ہیں۔ صِرف اَپنی بھیڑ بکریوں اَور گائے بَیلوں کو یہاں چھوڑ جاؤ۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","لیکن مَوشہ نے کہا، ”تُمہیں ہمیں قُربانی اَور سوختنی نذر کے جانور لے جانے کی اِجازت دینی ہوگی تاکہ ہم اُنہیں یَاہوِہ اَپنے خُدا کو پیش کر سکیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ہمارے چَوپائے بھی ہمارے ساتھ جایٔیں گے اَور اُن کا ایک کھُر تک بھی پیچھے نہیں چھوڑا جائے گا کیونکہ اُن میں سے بعض کو ہم یَاہوِہ اَپنے خُدا کی عبادت کے لیٔے کام میں لائیں گے اَور جَب تک ہم وہاں پہُنچ نہ جایٔیں ہم نہیں جان سکتے کہ یَاہوِہ کی عبادت کرنے کے لیٔے ہمیں کیا کیا اِستعمال کرنا ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","لیکن یَاہوِہ نے فَرعوہؔ کے دِل کو سخت کر دیا اَور وہ اُن کو جانے کی اِجازت دینے کے لیٔے رضامند نہ ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","اَور فَرعوہؔ نے مَوشہ سے کہا، ”میری نظروں کے سامنے سے ہٹ جاؤ اَور خبردار پھر میرے سامنے مت آنا کیونکہ جِس دِن تُم نے میرا مُنہ دیکھا تُم مار ڈالے جاؤگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","مَوشہ نے جَواب دیا، ”ٹھیک، جَیسے تُم نے کہا مَیں پھر کبھی تمہارے سامنے نہیں آؤں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","اَور یَاہوِہ نے مَوشہ سے کہاتھا، ”میں فَرعوہؔ اَور مِصر پر ایک اَور وَبا بھیجوں گا اَور اُس کے بعد وہ تُمہیں یہاں سے جانے دے گا بَلکہ دھکّے دے کر نکال دے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","لہٰذا، تُم لوگوں کو بتاؤ کہ مَرد اَور عورتیں سَب کے سَب اَپنے اَپنے پڑوسیوں اَور پڑوسنوں سے چاندی اَور سونے کے زیور مانگ لیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(اَور یَاہوِہ نے مِصریوں کو اُن لوگوں پر مہربان کر دیا تھا اَور مِصر میں فَرعوہؔ کے حاکم اَور لوگ خُود مَوشہ کا بھی بڑا اِحترام کرنے لگے تھے)۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","لہٰذا مَوشہ نے کہا، ”یَاہوِہ یُوں فرماتے ہیں، ’تقریباً آدھی رات کو میں سارے مِصر میں چکّر لگاؤں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","اَور مِصر میں ہر ایک پہلوٹھا مَر جائے گا۔ تخت کے وارِث فَرعوہؔ کے پہلوٹھے بیٹے سے لے کر چکّی پیسنے والی خادِمہ کے پہلوٹھے بیٹے تک اَور چَوپایوں کے پہلوٹھے سَب کے سَب مَر جایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","اَور سارے مِصر میں اِتنا بڑا ماتم ہوگا جِتنا نہ پہلے کبھی ہُوا نہ پھر کبھی ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","لیکن بنی اِسرائیل کے درمیان کسی اِنسان یا حَیوان پر کویٔی کُتّا بھی نہ بھونکے گا۔ تَب تُم جانوگے کہ یَاہوِہ مِصریوں اَور بنی اِسرائیل میں اِمتیاز کرتے ہیں۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","اَور تمہارے یہ سَب اہلکار سرنِگوں ہوکر میرے پاس آئیں گے اَور کہیں گے، ’تُم اَور وہ سَب لوگ جو تمہاری پیروی کرتے ہیں چلے جایٔیں!‘ اُس کے بعد میں چل دُوں گا۔“ تَب مَوشہ بڑے طیش میں فَرعوہؔ کے پاس سے نکلے اَور چلےگئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","اَور یَاہوِہ نے مَوشہ سے فرمایا ہُوا تھا، ”فَرعوہؔ تمہاری بات نہیں سُنے گا جَب تک مِصر میں میرے عجائب بہت نہ بڑھ جایٔیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","مَوشہ اَور اَہرونؔ نے یہ تمام حیرت اَنگیز کام فَرعوہؔ کو دِکھائے لیکن یَاہوِہ نے فَرعوہؔ کے دِل کو سخت کر دیا اَور وہ بنی اِسرائیل کو اَپنے مُلک سے باہر جانے کی اِجازت دینے پر راضی نہ ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","پھر یَاہوِہ نے مِصر میں مَوشہ اَور اَہرونؔ سے فرمایا کہ، ");
INSERT INTO urdoucv_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","”یہ مہینہ تمہارے لیٔے مہینوں کا شروع اَور سال کا پہلا مہینہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","لہٰذا سارے بنی اِسرائیل کی جماعت سے کہہ کہ اِس مہینے کے دسویں دِن ہر اِنسان اَپنے آبائی خاندان کے مُطابق ہر گھرانے کے لیٔے ایک برّہ لے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","اَور اگر کسی گھرانے میں لوگ اِتنے کم ہُوں کہ وہ سالِم برّہ نہ کھا سکتے ہُوں تو وہ اَپنے قریب ترین ہمسایہ کے ساتھ مِل کر دونوں گھرانوں کے لوگوں کی تعداد کے مُوافق ایک برّہ لیں اَور ہر اِنسان کے کھانے کی مقدار کے مُطابق برّہ کا حِساب لگانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","اَور بھیڑ یا بکری کا جو بچّہ تُم چُنو لازِم ہے کہ وہ نر ہو ایک سال کا ہو اَور بے عیب ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","اَور اِس مہینے کی چودھویں تاریخ تک اُس کی نِگرانی رکھنا پھر اِسرائیلی جماعت کے سَب لوگ اُسے شام کے وقت میں ذبح کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","اَور پھر اُس کا تھوڑا سا خُون لے کر اُن گھروں کے دروازوں کے دونوں بازوؤں پر اَور اُوپر کی چوکھٹ پر لگا دیں جِن میں وہ اُس برّہ کو کھایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","اَور وہ اُسی رات اُسے آگ پر بھونیں اَور اُس کے گوشت کو کڑوے ساگ پات اَور بے خمیری روٹی کے ساتھ کھا لیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","اُسے کچّا یا پانی میں اُبال کر ہرگز نہ کھانا بَلکہ برّہ کو سَر، پایٔے اَور اَندرونی اَعضا سمیت آگ پر بھُون کر کھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","اَور اُس میں سے کُچھ بھی صُبح تک باقی نہ چھوڑنا۔ اَور اگر کچھ صُبح تک باقی رہ جائے تو اُسے آگ میں جَلا دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","اَور تُم اُسے اِس طرح کھانا کہ تُم اَپنی کمر باندھے ہویٔے ہو اَور اَپنی جُوتیاں پاؤں میں پہنے ہویٔے اَور اَپنا عصا ہاتھ میں لیٔے ہویٔے ہو۔ تُم اُسے جلدی جلدی کھانا کیونکہ یہ فسح یَاہوِہ کی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","”اَور اُسی رات کو میں مِصر میں سے ہوکر گزروں گا اَور اِنسان اَور حَیوان دونوں کے سَب پہلوٹھوں کو مار گراؤں گا اَور مَیں مِصر کے سَب معبُودوں کو بھی سزا دُوں گا۔ مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","اَور جِن گھروں میں تُم ہوگے اُن پر وہ خُون تمہاری طرف سے نِشان ہوگا اَور مَیں اُس خُون کو دیکھ کر تُمہیں چھوڑتا جاؤں گا۔ اَور جَب مَیں مِصریوں کو ماروں گا تو اُس وقت کویٔی بھی مہلِک وَبا تمہارے قریب نہیں آئے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","”وہ دِن تمہارے لیٔے یادگار ہوگا اَور تُم اَور تمہاری آنے والی پُشت در پُشت اُسے ایک دائمی فرمان سمجھ کر یَاہوِہ کی عید کے طور پر منائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","سات دِن تک تُم بے خمیری روٹی کھانا اَور پہلے ہی دِن سے خمیر اَپنے اَپنے گھر سے باہر کردینا۔ اَورجو کویٔی پہلے دِن سے ساتویں دِن تک دَوران کویٔی بھی خمیری چیز کھائے وہ اِسرائیل میں سے ایمان سے خارج کر دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","اَور تُم اَپنا مُقدّس اِجتماع ایک تو پہلے دِن کرنا اَور دُوسرا ساتویں دِن اَور ہر ایک کے کھانے کے لیٔے کھانا بنانے کے سِوا اِن دِنوں میں اَور کویٔی کام بالکُل نہ کرنا۔ تُم صِرف کھانا بنانے کا ہی کام کر سکتے ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","”اَور تُم بے خمیری روٹی کی عید منایا کرنا کیونکہ یہی وہ دِن ہوگا جَب مَیں تُمہیں تمہارے لشکروں کے مُطابق مِصر سے نکال لاؤں گا اِس لیٔے تُم پُشت در پُشت اِس دِن کو ایک دائمی فرمان سمجھ کر مانتے رہنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","اَور پہلے مہینے کے چودھویں دِن کی شام سے لے کر اِکیّسویں دِن کی شام تک تُم بے خمیری روٹی کھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","اَور سات دِنوں تک کچھ بھی خمیر تمہارے گھروں میں نہ رہے اَور اِن سات دِنوں کے دَوران جو کویٔی کسی خمیری چیز کو کھائے خواہ وہ پردیسی ہو یا اُسی مُلک میں ہی پیدا ہُوا ہو اِسرائیل کی جماعت سے خارج کر دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","کویٔی بھی خمیری چیز نہ کھانا خواہ تمہارا مقام کہیں بھی ہو تُم بے خمیری روٹی ہی کھانا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","تَب مَوشہ نے اِسرائیل کے سَب بُزرگوں کو بُلوایا اَور اُن سے کہا، ”فوراً جا کر اَپنے اَپنے آبائی خاندانوں کے واسطے برّے چُنو اَور فسح کا برّہ ذبح کرو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","اَور زُوفے کا ایک گُچّھا لے کر اُس خُون میں جو لگن میں ہوگا ڈُبو کر اُس خُون میں سے کچھ دروازہ کی چوکھٹ کے اُوپر کے حِصّہ میں اَور کچھ اُس چوکھٹ کے دونوں بازوؤں پر لگادینا۔ اَور تُم میں سے کویٔی بھی صُبح تک اَپنے گھر کے دروازہ سے باہر نہ جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","اَور جَب یَاہوِہ اِس مُلک میں مِصریوں کو مارتے ہُوئے گزریں گے اَور وہ دروازہ کے چوکھٹ کے اُوپر اَور بازوؤں پر اُس خُون کو دیکھیں گے تو وہ اُس دروازہ کو چھوڑ جائیں گے اَور ہلاک کرنے والے کو گھر کے اَندر آنے اَور تُمہیں مارنے کی اِجازت نہ دیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","”اَور تُم اَور تمہاری نَسل اِن ہدایات کو ایک دائمی فرمان سمجھ کر ماَننا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","اَور جَب تُم اُس مُلک میں داخل ہو جو یَاہوِہ تُمہیں دیں گے جَیسا کہ اُنہُوں نے وعدہ کیا تُم اِس رسم کو جاری رکھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","اَور جَب تمہارے بچّے تُم سے پُوچھیں، ’اِس رسم سے تمہارا کیا مطلب ہے؟‘ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","تَب تُم اُنہیں بتانا، ’یہ یَاہوِہ کے لیٔے فسح کی قُربانی ہے جِس نے مِصریوں کو مارتے وقت بنی اِسرائیل کے گھروں کو چھوڑ دیا تھا اَور ہمارے گھروں کو بچا لیا تھا۔‘ “ تَب لوگوں نے سَر جھُکا کر سَجدہ کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","اَور بنی اِسرائیل نے بالکُل وَیسا ہی کیا جَیسا کہ یَاہوِہ نے مَوشہ اَور اَہرونؔ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","اَور آدھی رات کو یَاہوِہ نے مِصر میں تخت نشین فَرعوہؔ کے پہلوٹھے سے لے کر قَیدخانہ کی کوٹھری کے قَیدی کے پہلوٹھے تک بَلکہ تمام جانوروں کے پہلوٹھوں کو بھی ہلاک کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","اَور فَرعوہؔ اَور اُس کے تمام اہلکار اَور مِصری رات ہی کو اُٹھ بیٹھے اَور مِصر میں بڑا کہرام مچا کیونکہ کویٔی بھی گھر اَیسا نہ تھا جِس میں کویٔی مَرا نہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","تَب اُسی رات فَرعوہؔ نے مَوشہ اَور اَہرونؔ کو طلب کیا اَور کہا، ”تیّار ہو جاؤ! اَور تُم اَور بنی اِسرائیل میری قوم کے لوگوں میں سے نکل جاؤ اَور جا کر یَاہوِہ کی عبادت کرو جَیسا کہ تُم نے درخواست کی ہے ");
INSERT INTO urdoucv_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","اَور اَپنے کہنے کے مُطابق اَپنی بھیڑ بکریاں اَور گائے بَیل بھی لیتے جاؤ اَور میرے لیٔے بھی دعا کرنا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","اَور مِصریوں نے اُن لوگوں کو جلدی سے اُس مُلک کو چھوڑکر چلے جانے کی ترغِیب دی اَور کہا، ”جلدی کرو ورنہ ہم مارے جایٔیں گے!“ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","لہٰذا لوگوں نے اَپنے گُندھے گُندھائے آٹے کو خمیر دئیے بغیر ہی لگنوں سمیت کپڑوں میں لپیٹ کر کندھوں پر رکھ لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","اَور بنی اِسرائیل نے مَوشہ کی ہدایت کے مُوافق عَمل کیا اَور مِصریوں سے چاندی اَور سونے کے زیور اَور کپڑے مانگ لیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","اَور چونکہ یَاہوِہ نے مِصریوں کے دِل میں اُن لوگوں کے لیٔے اِحترام کا جذبہ پیدا کر دیا تھا اِس لیٔے جو کچھ بنی اِسرائیل نے مانگا اُنہُوں نے دے دیا۔ اِس طرح بنی اِسرائیل نے مِصریوں کو لُوٹ لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","اَور بنی اِسرائیل نے رَعمسیسؔ سے سُکّوتؔ تک پیدل سفر کیا۔ یہ سَب عورتوں اَور بچّوں کے علاوہ تقریباً چھ لاکھ مَردوں پر مُشتمل تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","اَور بھی بہت سے لوگ اُن کے ہمراہ ہو لئے۔ بھیڑ بکریاں، گائے بَیل اَور دُوسرے چَوپائے بھی بڑی تعداد میں اُن کے ساتھ تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","اَور اُنہُوں نے اُس گُندھے ہویٔے آٹے کی جسے وہ مِصر سے لایٔے تھے بے خمیری روٹیاں پکائیں۔ وہ اَپنے آٹے میں خمیر نہ مِلا پایٔے تھے کیونکہ اُن کو مِصر سے زبردستی نکال دیا گیا تھا اَور اُنہیں اِتنی فُرصت بھی نہ مِلی تھی کہ کھانا تیّار کر سکیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","اَور اِسرائیلی لوگوں کی مِصر میں رہائش کی مُدّت چار سَو تیس بَرس تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","اُن چار سَو تیس برسوں کے بعد ٹھیک اُسی روز یَاہوِہ کا سارا لشکر مِصر سے نکل گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","اَور چونکہ اُنہیں مِصر سے نکال لانے کے لیٔے یَاہوِہ نے اُس رات اُن کی نگہبانی کی تھی اِس لیٔے تمام بنی اِسرائیل اَور اُن کی آئندہ پُشتوں پر فرض ٹھہرا کہ وہ یَاہوِہ کی تمجید کرنے کے لیٔے رتجگا کیا کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","پھر یَاہوِہ نے مَوشہ اَور اَہرونؔ سے فرمایا، ”فسح کھانے کے ضوابط یہ ہیں: ”کویٔی بھی غَیراِسرائیلی اِسے کھانے نہ پایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","تمہارا زَر خرید غُلام اِسے کھا سَکتا ہے اگر تُم نے اُس کا ختنہ کر دیا ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","لیکن کویٔی پردیسی اَور اُجرت پر رکھا ہُوا مزدُور اُسے کھانے نہ پایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","”اَور لازماً اُسے ایک گھر کے اَندر ہی کھانا اَور اُس گوشت میں سے ذرا سا بھی گھر سے باہر نہ لے جانا۔ اَور اُس کی کوئی بھی ہڈّی نہ توڑی جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","اَور اِسرائیل کی ساری جماعت اِس عید کو منائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","”اَور اگر کویٔی پردیسی جو تمہارے درمیان رہتاہے یَاہوِہ کی فسح منانا چاہتاہے تو وہ اَپنے گھر کے تمام مَردوں کا ختنہ کرائے۔ تَب ہی وہ مُلک اِسرائیل کے ایک باشِندے کی طرح حِصّہ لے سَکتا ہے۔ لیکن کویٔی نامختون مَرد اُسے کھانے نہ پایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","یہ آئین ہر اُس مُلک اِسرائیل کے باشِندے کی طرح اَور تمہارے درمیان رہنے والے ہر غَیراِسرائیلی باشِندے کے لیٔے ہے۔ اُسی مُلک میں ہی پیدا ہُوئے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","اَور تمام بنی اِسرائیل نے بالکُل وَیسا ہی کیا جَیسا یَاہوِہ نے مَوشہ اَور اَہرونؔ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","اَور ٹھیک اُسی دِن یَاہوِہ بنی اِسرائیل کے سارے لشکروں کو مِصر سے نکال لے گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","اَور یَاہوِہ نے مَوشہ کو فرمایا: ");
INSERT INTO urdoucv_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","”ہر ایک نر پہلوٹھے کو یعنی اِسرائیل کے ہر پہلے بچّہ کو خواہ وہ اِنسان کا ہو، خواہ حَیوان کا، میرے لیٔے مخصُوص کرنا کیونکہ وہ میرا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","تَب مَوشہ نے لوگوں سے کہا، ”تُم اِس دِن کو جِس میں تُم غُلامی کی سرزمین مِصر سے نکل کر آئے بطور یادگار منایا کرنا کیونکہ یَاہوِہ تُمہیں اَپنے قوی ہاتھ سے وہاں سے نکال لائے۔ اُس دِن خمیر والی کویٔی چیز نہ کھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","آج ابیبؔ کے مہینے میں تُم مِصر سے نکل کر جا رہے ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","اَور جَب یَاہوِہ تُمہیں کنعانیوں، حِتّیوں، امُوریوں، حِوّیوں اَور یبُوسیوں کے مُلک میں پہُنچا دیں جسے تُمہیں دینے کی قَسم اُنہُوں نے تمہارے آباؤاَجداد سے کھائی تھی، اَور جِس میں دُودھ اَور شہد بہتا ہے تو تُم اِس مہینے میں یہ رسم اَدا کیا کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","سات دِن تک تُم بے خمیری روٹی کھانا اَور ساتویں دِن یَاہوِہ کے لیٔے عید منانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","اِن سات دِنوں میں بے خمیری روٹی کھانا اَور کویٔی خمیری چیز نہ تمہارے درمیان دِکھائی دے اَور نہ ہی تمہاری حُدوُد کے اَندر کہیں دِکھائی دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","اَور اُس روز تُم اَپنے بیٹے کو بتانا، ’جَب مَیں مِصر سے نکل آیا تو جو کچھ یَاہوِہ نے میرے لیٔے کیا اُس کی وجہ سے میں یہ دِن مناتا ہُوں۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","یہ عید منانا تمہارے لیٔے اَور تمہارے ہاتھ پر نِشان اَور پیشانی پر یاد دہانی کی علامت کی مانند ہوگا۔ تاکہ یَاہوِہ کے آئین تمہارے ہونٹوں پر رہے۔ کیونکہ یَاہوِہ نے اَپنے قوی ہاتھ سے تُمہیں مِصر سے نکالا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","تُم اِس رسم کو مُقرّرہ وقت پر سال بسال منایا کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","”اَور جَب یَاہوِہ تُمہیں کنعانیوں کے مُلک میں لے آئیں گے اَور اُسے تمہارے قبضہ میں دے دیں گے، جَیسا کہ اُنہُوں نے قَسم کھا کر تُم سے اَور تمہارے آباؤاَجداد سے وعدہ کیا، ");
INSERT INTO urdoucv_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","تو تُم ہر پہلوٹھے بچّہ کو یَاہوِہ کے لیٔے مخصُوص کرنا اَور تمہارے چَوپایوں کے سَب نر پہلوٹھے بچّے یَاہوِہ کے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","اَور گدھے کے ہر پہلے بچّے کے فدیہ میں ایک برّہ دینا اَور اگر تُم اُس کا فدیہ نہ دو تو اُس کی گردن توڑ ڈالنا اَور تمہارے بیٹوں میں جتنے پہلوٹھے ہوں اُن سَب کا فدیہ دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","”اَور آئندہ زمانہ میں جَب تمہارا بیٹا تُم سے پُوچھے، ’اِس کا مطلب کیا ہے؟‘ تو ’تُم اُسے بتانا کہ یَاہوِہ ہمیں غُلامی کے مُلک مِصر سے اَپنے قوی ہاتھ سے نکال کر لائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","اَور جَب فَرعوہؔ نے ہٹ دھرمی سے ہمیں جانے کی اِجازت دینے سے اِنکار کیا، تو یَاہوِہ نے مِصر میں اِنسان اَور حَیوان دونوں کے ہر ایک پہلوٹھے کو مار دیا۔ یہی وجہ ہے کہ میں ماں کے رِحم کو کھولنے والے ہر نر پہلوٹھے کو یَاہوِہ کے حُضُور قُربان کرتا ہُوں اَور اَپنے سَب فرزندوں کے پہلوٹھے بیٹوں کا فدیہ دیتا ہُوں۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","اَور یہ تمہارے ہاتھ پر ایک نِشان کی طرح اَور تمہاری پیشانی پر ایک علامت کی مانند ہوگا کہ یَاہوِہ اَپنے قوی ہاتھ سے ہمیں مِصر سے نکال لائے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","اَور جَب فَرعوہؔ نے اُن لوگوں کو جانے دیا تو خُدا اُنہیں فلسطینیوں کے مُلک کے راستہ سے نہیں لے گئے اگرچہ وہ چھوٹا تھا کیونکہ خُدا نے فرمایا، ”اگر اُنہیں جنگ کا سامنا کرنا پڑا تو اَیسا نہ ہو کہ وہ پچھتانے لگیں اَور مِصر لَوٹ جایٔیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","لہٰذا خُدا لوگوں کو گھُما کر بیابان کی راہ سے بحرِقُلزمؔ کی طرف لے گئے اَور بنی اِسرائیل مُلک مِصر سے مُسلّح ہوکر نکلے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","اَور مَوشہ یُوسیفؔ کی ہڈّیوں کو ساتھ لے گئے کیونکہ یُوسیفؔ نے بنی اِسرائیل سے قَسم لے لی تھی۔ یُوسیفؔ نے کہاتھا، ”خُدا یقیناً تمہاری مدد کریں گے اَور جَب تُم جاؤ تو میری ہڈّیوں کو یہاں سے اَپنے ساتھ لیتے جانا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","سُکّوتؔ سے روانہ ہوکر اُنہُوں نے بیابان کے کنارے ایتھامؔ میں پڑاؤ کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","اَور یَاہوِہ اُن کو دِن کو راستہ دِکھانے کے لیٔے بادل کے سُتون میں اَور رات کو رَوشنی دینے کے لیٔے آگ کے سُتون میں ہوکر اُن کے آگے آگے چلا کرتے تھے تاکہ اِسرائیلی دِن کو اَور رات کو بھی سفر کر سکیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","اَور نہ تو دِن کو بادل کا سُتون اَور نہ رات کو آگ کا سُتون لوگوں کے آگے سے ہٹتا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","”بنی اِسرائیل سے کہو، وہ واپس جایٔیں، اَور مِگدُلؔ اَور سمُندر کے درمیان پیہاخیروتؔ کے نزدیک ڈیرے لگائیں یعنی سمُندر کے کنارے کنارے بَعل ضِفونؔ کے بالکُل سامنے ڈیرے ڈالیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","اَور فَرعوہؔ خیال کرےگا، ’بنی اِسرائیل بیابان میں گھِر گیٔے ہیں اَور وہ گھبرا کر اِدھر اُدھر آوارہ پھر رہے ہیں۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","اَور مَیں فَرعوہؔ کے دِل کو سخت کر دُوں گا اَور وہ اُن کا تعاقب کرےگا۔ لیکن مَیں فَرعوہؔ اَور اُس کے سارے لشکر پر غالب آکر اَپنا جلال ظاہر کروں گا۔ تَب مِصری جان لیں گے کہ یَاہوِہ میں ہُوں۔ لہٰذا بنی اِسرائیل نے اَیسا ہی کیا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","جَب مِصر کے بادشاہ کو بتایا گیا کہ وہ لوگ فرار ہو گئے ہیں تو فَرعوہؔ اَور اُس کے اہلکاروں نے اُن کے متعلّق اَپنا اِرادہ بدل ڈالا اَور کہا، ”ہم نے یہ کیا کیا؟ ہم نے بنی اِسرائیل کو جانے کی اِجازت دے کر اَپنے آپ کو اُن کی خدمت سے محروم کر لیا!“ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","لہٰذا فَرعوہؔ نے اَپنا رتھ تیّار کروایا اَور اَپنے لشکر کو ساتھ لیا ");
INSERT INTO urdoucv_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","اَور اُس نے چھ سَو چُنے ہویٔے رتھ لیٔے اَور مِصر کے تمام دیگر رتھ بھی طلب کر لیٔے اَور اُن میں افسروں کو بِٹھا دیا ");
INSERT INTO urdoucv_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","اَور یَاہوِہ نے مِصر کے بادشاہ فَرعوہؔ کے دِل کو سخت کر دیا۔ پس اُس نے بنی اِسرائیل کا جو بڑے فخر سے مِصر سے نکلے تھے تعاقب کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","اَور مِصری لشکر نے فَرعوہؔ کے تمام گھوڑوں، رتھوں اَور سواروں سمیت بنی اِسرائیل کا تعاقب کرکے اُن کو اُس وقت جا لیا جَب وہ سمُندر کے کنارے پیہاخیروتؔ کے قریب بَعل ضِفونؔ کے سامنے ڈیرے لگا رہے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","اَور جَب فَرعوہؔ نزدیک پہُنچا تو بنی اِسرائیل نے آنکھ اُٹھاکر دیکھا کہ مِصری اُن کا پیچھا کرتے کرتے آ پہُنچے ہیں۔ تَب وہ خوفزدہ ہوکر یَاہوِہ سے فریاد کرنے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","اَور مَوشہ سے کہنے لگے، ”کیا مِصر میں قبریں نہ تھیں، جو تُم ہمیں مرنے کے لیٔے بیابان میں لے آئے ہو؟ تُم نے ہمارے ساتھ یہ کیا کیا کہ ہمیں مِصر سے نکال لائے؟ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","کیا ہم نے آپ سے مِصر میں ہی نہ کہاتھا، ’ہمارا پیچھا چھوڑ دیجئے، اَور ہمیں مِصریوں کی خدمت میں لگے رہنے دیجئے؟‘ یہاں بیابان میں مرنے کی بہ نِسبت ہمارے لیٔے مِصریوں کی خدمت کرتے رہنا ہی بہتر تھا!“ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","تَب مَوشہ نے لوگوں سے کہا، ”ڈرو مت! ہمّت سے کام لو اَور خاموشی سے کھڑے رہو! تُم اُس نَجات کے کام کو دیکھوگے، جو یَاہوِہ آج تُمہیں دِکھائیں گے، اَور جِن مِصریوں کو تُم آج دیکھ رہے ہو، اُنہیں پھر کبھی نہ دیکھوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","یَاہوِہ تمہاری طرف سے جنگ لڑیں گے۔ بس خاموش رہو اَور اِنتظار کرو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","تَب یَاہوِہ نے مَوشہ سے کہا، ”تُم مُجھ سے کیوں فریاد کر رہے ہو؟ بنی اِسرائیل سے کہو کہ وہ آگے بڑھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","اَور تُم اَپنا عصا اُٹھاکر اَپنا ہاتھ سمُندر کے اُوپر بڑھاؤ اَور اُس کے پانی کو دو حِصّوں میں بانٹ دو تاکہ بنی اِسرائیل سمُندر میں خشک زمین پر سے گزر کر پار جا سکیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","اَور مَیں مِصریوں کے دِل سخت کر دُوں گا اَور وہ اُن کا پیچھا کریں گے اَور مَیں فَرعوہؔ اَور اُس کی تمام فَوج اَور اُس کے رتھوں اَور سواروں پر غالب آؤں گا جِس سے میرا جلال ظاہر ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","اَور جَب مَیں فَرعوہؔ، اُس کے رتھوں اَور سواروں پر غالب آکر جلال پاؤں گا تَب مِصری جان لیں گے کہ یَاہوِہ میں ہی ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","تَب خُدا کا وہ فرشتہ جو اِسرائیلی فَوج کے آگے آگے چلتا تھا سامنے سے ہٹ کر اُن کے پیچھے چلا گیا اَور بادل کا سُتون بھی سامنے سے ہٹ کر اُن کے پیچھے چلا گیا ");
INSERT INTO urdoucv_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","اَور مِصری اَور اِسرائیلی فَوجوں کے مابین جا ٹھہرا اَور وہ بادل ساری رات ایک جانِب اَندھیرا اَور دُوسری جانِب رَوشنی دیتا رہا، لہٰذا رات بھر دونوں فَوجیں ایک دُوسرے کے نزدیک نہ آئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","اَور پھر مَوشہ نے اَپنا ہاتھ سمُندر کے اُوپر بڑھایا اَور ساری رات یَاہوِہ نے بڑی تیز مشرقی ہَوا چلا کر سمُندر کو پیچھے ہٹا کر اُسے خشک زمین بنا دیا اَور پانی دو حِصّے ہو گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","اَور بنی اِسرائیل سمُندر کے درمیان سے خشک زمین پر چل کر نکل گیٔے اَور سمُندر کا پانی اُن کی داہنی طرف اَور بائیں طرف دیوار کی طرح کھڑا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","اَور مِصریوں نے اُن کا تعاقب کیا اَور فَرعوہؔ کے گھوڑے اَور رتھ اَور سوار اُن کے پیچھے پیچھے سمُندر کے درمیان پہُنچ گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","اَور رات کے پچھلے پہر یَاہوِہ نے آگ اَور بادل کے سُتون پر سے نیچے مِصری فَوج پر نظر ڈالی اَور اُن میں ابتری پیدا کر دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","اَور اُن کے رتھوں کے پہیّے پھنسا ڈالے۔ لہٰذا اُن کا چلانا مُشکل ہو گیا۔ اَور مِصری کہنے لگے، ”آؤ ہم اِسرائیلیوں کے مُقابلہ سے ہٹ جایٔیں کیونکہ اُن کی طرف سے یَاہوِہ مِصر سے جنگ لڑ رہے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","اَور پھر یَاہوِہ نے مَوشہ سے کہا، ”اَپنا ہاتھ سمُندر کے اُوپر بڑھاؤ تاکہ پانی مِصریوں اُن کے رتھوں اَور سواروں پر پھر بہنے لگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","اَور مَوشہ نے اَپنا ہاتھ سمُندر کے اُوپر بڑھایا اَور صُبح ہونے پر سمُندر اَپنی جگہ پر پھر واپس آ گیا۔ اَور وہ مِصری جو اُس سے بھاگ رہے تھے یَاہوِہ نے اُن کو سمُندر کی لپیٹ میں جانے دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","اَور پانی پلٹ کر آیا اَور اُس نے رتھوں اَور سواروں اَور فَرعوہؔ کے تمام فَوج کو جو اِسرائیلیوں کا پیچھا کرتے ہُوئے سمُندر کے درمیان پہُنچ گیا تھا غرق کر دیا اَور اُن میں سے کویٔی بھی زندہ نہ بچا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","لیکن بنی اِسرائیل سمُندر میں سے خشک زمین پر چل کر نکل گیٔے اَور پانی دیوار کی طرح اُن کے داہنے اَور بائیں ہاتھ کھڑا رہا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","اَور یُوں اُس دِن یَاہوِہ نے بنی اِسرائیل کو مِصریوں کے ہاتھ سے بچا لیا اَور بنی اِسرائیل نے دیکھا کہ مِصری سمُندر کے کنارے مَرے پڑے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","اَور جَب اِسرائیلیوں نے اُس قوی ہاتھ کو دیکھا جو یَاہوِہ نے مِصریوں کے خِلاف اِستعمال کیا تھا تو وہ لوگ یَاہوِہ سے ڈرے اَور اُن پر اَور اُن کے خادِم مَوشہ پر ایمان لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","تَب مَوشہ اَور بنی اِسرائیل نے یَاہوِہ کی حَمد میں یہ نغمہ گایا: ”مَیں یَاہوِہ کی ثنا گاؤں گا، کیونکہ وہ بہت ہی بُلند و بالا ہیں۔ اُنہُوں نے گھوڑوں کو سوار سمیت سمُندر میں پھینک دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","”یَاہوِہ میری قُوّت اَور میرا نغمہ ہیں؛ وہ ہی میری نَجات ہیں۔ وہ میرے خُدا ہیں اَور مَیں اُن کی حَمد کروں گا، وہ میرے باپ کے خُدا ہیں مَیں اُن کی تمجید کروں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","یَاہوِہ جنگ میں فتح پاتے ہیں؛ اُن کا نام یَاہوِہ ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","اُنہُوں نے فَرعوہؔ کے رتھوں اَور فَوج کو سمُندر میں ڈال دیا۔ اَور فَرعوہؔ کے چُنے ہُوئے افسران بحرِقُلزمؔ میں غرق ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","گہرے پانی نے اُن کو چھُپا لیا؛ وہ پتّھر کی مانند گہرائیوں میں ڈُوب گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","اَے یَاہوِہ! آپ کا داہنا ہاتھ، قُوّت میں جلالی تھا۔ اَے یَاہوِہ! آپ کے ہاتھ نے، دُشمن کو چکنا چُور کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","”اَپنی عظمت کے جلال سے، آپ نے اَپنے مُخالفوں کو تہِ تیغ کر دیا۔ آپ کے آتِشیں قہر نے بھڑک کر؛ اُنہیں بھُوسے کی مانند بھسم کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","آپ کے نتھنوں کے پُرزور دَم سے پانی کا ڈھیر لگ گیا۔ اَور سیلاب کا پانی دیوار کی طرح سیدھے کھڑا ہو گیا؛ اَور گہرا پانی سمُندر کے درمیان جم گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","دُشمن نے بڑی شیخی بگھاری تھی، ’میں تعاقب کرکے اُنہیں تباہ کر دُوں گا۔ میں لُوٹ کا مال تقسیم کروں گا؛ میں اُن کو نگل جاؤں گا۔ میں اَپنی تلوار کھینچ کر اَپنے ہی ہاتھ سے اُنہیں ہلاک کروں گا۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","لیکن آپ نے اَپنی سانس کی آندھی بھیجی، اَور سمُندر نے اُن کو چھُپا لیا۔ اَور وہ زورآور پانی میں سیسے کی مانند ڈُوب گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","اَے یَاہوِہ! معبُودوں میں کون آپ کی مانند ہے؟ کون ہے جو آپ کی مانند، اَپنی پاکیزگی میں جلالی، اَور اَپنی مدح کے سبب سے، اَور عجائب کام کر سکتا ہے؟ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","”آپ نے اَپنا داہنا ہاتھ بڑھایا اَور زمین نے آپ کے دُشمنوں کو نگل لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","اَپنی لافانی مَحَبّت سے آپ اُن لوگوں کی رہنمائی کریں گے جِن کا آپ نے فدیہ دیا ہے۔ اَور اُنہیں اَپنی قُوّت سے اَپنے مُقدّس قِیام کی طرف لےچلیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","قومیں سُنیں گی اَور تھرتھرائیں گی؛ اَور فلسطین کے لوگ ذہنی کُوفت میں مُبتلا ہوں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","اَور اِدُوم کے سردار دہشت زدہ ہوں گے، اَور مُوآب کے سربراہوں پر کپکپی طاری ہو جائے گی، اَور کنعانؔ کے حُکاّم نابود ہو جایٔیں گے؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","اُن پر خوف و ہِراس طاری ہو جائے گا۔ اَور وہ آپ کے قوی ہاتھ سے پتّھر کی طرح بے حِس و حرکت رہیں گے۔ جَب تک اَے یَاہوِہ آپ کے لوگ سلامت نہ گزر جایٔیں، اَور جنہیں آپ نے خریدا ہے پار نہ ہو جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","آپ اُنہیں لاکر اَپنی مِیراث کے پہاڑ پر بساؤگے، یعنی اُس پاک مَقدِس مقام پر اَے یَاہوِہ جسے آپ نے اَپنے قِیام کے لیٔے بنایا ہے، وہ پاک مَقدِس اَے آقا جسے آپ کے ہاتھوں نے قائِم کیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","”یَاہوِہ ابدُالآباد سلطنت کریں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","جَب فَرعوہؔ کے گھوڑے، رتھ اَور سوار سمُندر کے درمیان پہُنچے تو یَاہوِہ سمُندر کے پانی کو اُن پر لَوٹا لائے۔ لیکن بنی اِسرائیل سمُندر کے درمیان سے خشک زمین پر چل کر نکل گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","تَب اَہرونؔ کی بہن مِریمؔ نے جو نبیّہ بھی تھی دف ہاتھ میں لیا اَور سَب عورتیں دف لیٔے رقص کرتے ہویٔے اُس کے پیچھے چلیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","اَور مِریمؔ نے اُن کے گانے کے جَواب میں یہ نغمہ گایا: ”یَاہوِہ کی حَمد و ثنا گاؤ، کیونکہ وہ بہت بُلند و بالا ہیں۔ اُنہُوں نے گھوڑے کو اَور اُس کے سوار کو سمُندر میں گھُما کر غرق کر دیا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","اَور پھر مَوشہ بنی اِسرائیل کو بحرِقُلزمؔ سے آگے لے گیٔے اَور وہ شُورؔ کے بیابان میں آئے اَور تین دِن تک چلتے رہے لیکن اُنہیں پانی نہ مِلا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","اَور جَب وہ مارہؔ میں آئے تو وہ مارہؔ کا پانی نہ پی سکے کیونکہ وہ کڑوا تھا۔ (یہی وجہ ہے کہ اُس جگہ کا نام مارہؔ پڑ گیا)۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","لہٰذا اُنہُوں نے مَوشہ کے خِلاف بُڑبُڑانا شروع کر دیا اَور کہنے لگے، ”ہم کیا پیئیں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","تَب مَوشہ نے یَاہوِہ سے فریاد کی اَور یَاہوِہ نے اُسے لکڑی کا ایک ٹکڑا دِکھایا۔ جَب اُس نے پانی میں ڈالا تو پانی میٹھا ہو گیا۔ وہیں یَاہوِہ نے اُن کے لیٔے ایک قوانین اَور ہدایت مرتّب کی اَور وہیں اُنہُوں نے اُن کی آزمائش کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","اُنہُوں نے کہا، ”اگر تُم دِل لگا کر یَاہوِہ اَپنے خُدا کا کلام سنوگے اَور وُہی کروگے جو اُن کی نظر میں بھلا ہے اَور اگر تُم اُن کے اَحکام بجا لاؤگے اَور اُن کے تمام قوانین پر عَمل کروگے تو میں اُن بیماریوں میں سے کویٔی بھی جو مَیں نے مِصریوں پر نازل کیں تُم پر نازل نہ کروں گا کیونکہ مَیں وہ یَاہوِہ ہُوں جو تُمہیں شفا بخشتا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","پھر وہ ایلِمؔ میں آئے جہاں پانی کے بَارہ چشمے اَور کھجور کے ستّر درخت تھے اَور وہ وہیں پانی کے قریب خیمہ زن ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","اَور مِصر سے نکل آنے کے دُوسرے مہینے کے پندرھویں دِن بنی اِسرائیل کی ساری جماعت ایلِمؔ سے روانہ ہوکر سِنؔ کے بیابان پہُنچی جو کہ ایلِمؔ اَور سِینؔائی کے درمیان ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","اَور اُس بیابان میں ساری اِسرائیلی جماعت مَوشہ اَور اَہرونؔ کے خِلاف بُڑبُڑانے لگی ");
INSERT INTO urdoucv_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","اَور بنی اِسرائیل نے اُن سے کہا، ”کاش ہم مِصر میں ہی یَاہوِہ کے ہاتھ سے مار دئیے جاتے! وہاں ہم گوشت کی ہانڈیوں کے پاس بیٹھ کر جِتنا چاہتے تھے کھاتے تھے لیکن تُم ہمیں وہاں سے نکال کر اِس بیابان میں اِس لیٔے لے آئے کہ اِس ساری جماعت کو بھُوکا مروایا جائے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","تَب یَاہوِہ نے مَوشہ سے فرمایا، ”مَیں تمہارے لیٔے آسمان سے روٹیاں برساؤں گا۔ یہ لوگ ہر روز باہر نکلیں اَور صِرف ایک ایک دِن کے لیٔے کافی بٹور لائیں۔ اِس طرح مَیں اُن کی آزمائش کروں گا اَور دیکھوں گا کہ کیا وہ میرے آئین پر عَمل کرتے ہیں یا نہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","اَور چھٹے دِن جِس قدر وہ لائیں گے اَور پکائیں گے وہ جِتنا ہر روز جمع کریں وہ اُس کا دُگنا ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","لہٰذا مَوشہ اَور اَہرونؔ نے تمام بنی اِسرائیل سے کہا، ”شام کو تُم جان لوگے کہ جو تُمہیں مُلک مِصر سے نکال کر لائے ہیں وہ یَاہوِہ ہیں ");
INSERT INTO urdoucv_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","اَور صُبح کو تُم یَاہوِہ کا جلال دیکھوگے کیونکہ تمہارا اُن کے خِلاف بُڑبُڑانا اُنہُوں نے سُن لیا ہے۔ بھلا ہم کون ہیں کہ تُم ہمارے خِلاف بُڑبُڑاتے ہو؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","مَوشہ نے مزید کہا، ”جَب وہ تُمہیں شام کو کھانے کے لیٔے گوشت اَور صُبح کو پیٹ بھرکے روٹی دیتے ہیں تو تُم جان لوگے کہ وہ یَاہوِہ ہی ہیں۔ کیونکہ اُن کے خِلاف تمہارا بُڑبُڑانا اُن تک جا پہُنچا ہے۔ بھلا ہم کون ہیں؟ تُم ہم پر نہیں بَلکہ یَاہوِہ کے خِلاف بُڑبُڑاتے ہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","پھر مَوشہ نے اَہرونؔ سے کہا، ”بنی اِسرائیل کی ساری جماعت سے کہو، ’یَاہوِہ کے سامنے حاضِر ہو، کیونکہ اُنہُوں نے تمہارا بُڑبُڑانا سُن لیا ہے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","اَور جَب اَہرونؔ بنی اِسرائیل کی ساری جماعت سے یہ باتیں کہہ رہے تھے تو اُنہُوں نے بیابان کی طرف نظر کی اَور وہاں یَاہوِہ کا جلال اُنہیں بادل میں دِکھائی دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","اَور یَاہوِہ نے مَوشہ سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","”مَیں نے بنی اِسرائیل کا بُڑبُڑانا سُن لیا ہے؛ لہٰذا اُنہیں بتا دو، ’شام کو تُم گوشت کھاؤگے اَور صُبح کو تُم روٹی سے سَیر ہوگے۔ پھر تُم جان لوگے کہ مَیں یَاہوِہ تمہارا خُدا ہُوں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","اَور اُس شام اِتنی بٹیریں آئیں کہ بنی اِسرائیل کی ساری چھاؤنی کو ڈھانک لیا اَور صُبح کو چھاؤنی کے آس پاس اوس پڑی ہویٔی تھی ");
INSERT INTO urdoucv_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","اَور جَب وہ اوس خشک ہو گئی تو بیابان میں زمین پر پڑے پالے کی مانند برف کے چُھوٹے چُھوٹے گول گول گالے نظر آنے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","جَب بنی اِسرائیل نے اُس چیز کو دیکھا تو وہ ایک دُوسرے سے کہنے لگے، ”یہ کیا ہے؟“ کیونکہ وہ نہیں جانتے تھے کہ وہ کیا چیز ہے۔ مَوشہ نے اُن سے کہا، ”یہ وہ روٹی ہے جو یَاہوِہ نے کھانے کے لیٔے تُمہیں دی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","اَور یَاہوِہ نے یُوں حُکم دیا ہے، ’ہر ایک اَپنی اَپنی ضروُرت کے مُطابق اُسے جمع کرے یعنی اَپنے خیمہ میں اِنسانوں کی تعداد کے مُطابق ایک اومر فی کس جمع کرنا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","چنانچہ بنی اِسرائیل نے اَیسا ہی کیا جَیسا کہ اُنہیں حُکم دیا گیا تھا۔ بعض نے زِیادہ جمع کیا اَور بعض نے کم۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","اَور جَب اُنہُوں نے اُسے ناپا تو جِس نے زِیادہ جمع کیا اُس کا کچھ زِیادہ نہ نِکلا، اَور جِس نے کم جمع کیا اُس کا کچھ کم نہ نِکلا۔ ہر ایک نے اَپنی اَپنی ضروُرت کے مُطابق ہی جمع کیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","پھر مَوشہ نے اُن سے کہا، ”کویٔی بھی اِس میں سے صُبح تک کچھ باقی نہ چھوڑے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","تاہم اُن میں سے بعض نے مَوشہ کی بات کی پروا نہ کی اَور اُس کا کچھ حِصّہ صُبح تک رکھ چھوڑا سو اُس میں کیڑے پڑ گیٔے اَور بدبُو پیدا ہو گئی اَور مَوشہ کو اُن پر بڑا غُصّہ آیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ہر صُبح ہر ایک اَپنی اَپنی ضروُرت کے مُطابق جمع کرتا تھا اَور دھوپ تیز ہوتے ہی وہ پگھل جاتا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","اَور چھٹے دِن اُنہُوں نے ہر دِن کی بہ نِسبت دُگنا جمع کیا یعنی دو اومر فی کس کے حِساب سے۔ اَور جماعت کے سردار مَوشہ کے پاس آئے اَور اُسے یہ بات بتایٔی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","اُس نے اُن سے کہا، ”یَاہوِہ کا حُکم یہ ہے، ’کل آرام کا دِن یعنی یَاہوِہ کا مُقدّس سَبت ہوگا لہٰذا جو کچھ تُم پکانا چاہو پکاؤ اَورجو کچھ اُبالنا چاہو اُبالو اَورجو بچ رہے اُسے اَپنے لیٔے صُبح تک محفوظ رکھو۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","لہٰذا اُنہُوں نے اُسے صُبح تک رہنے دیا جَیسا مَوشہ نے حُکم دیا تھا اَور اُس میں نہ تو بدبُو پیدا ہُوئی اَور نہ ہی کیڑے پڑے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","اَور مَوشہ نے کہا، ”آج اِسی کو کھاؤ کیونکہ آج یَاہوِہ کا سَبت ہے، اَور آج تُم اِسے میدان میں پڑا نہ پاؤگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","چھ دِن تُم اِسے جمع کرنا لیکن ساتویں دِن یعنی سَبت کو وہ نہیں ملے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","پھر بھی بعض لوگ ساتویں دِن بھی اُسے بٹورنے گیٔے لیکن اُنہیں کچھ بھی نہ مِلا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","تَب یَاہوِہ نے مَوشہ سے کہا، ”تُم کب تک میرے اَحکام اَور ہدایات کو ماننے سے اِنکار کرتے رہوگے؟ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","یاد رکھو کہ یَاہوِہ نے تُمہیں سَبت کا دِن دیا ہے اِسی لیٔے چھٹے دِن وہ تُمہیں دو دِن کا کھانا دیتاہے لہٰذا ساتویں دِن ہر کویٔی اَپنی اَپنی جگہ ہی رہے اَور باہر نہ جائے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","پس لوگوں نے ساتویں دِن آرام کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","اَور بنی اِسرائیل نے اُس روٹی کا نام منّا رکھا۔ یہ دھنیے کے بیج کی طرح سفید اَور اُس کا مزہ شہد سے بنی ہُوئی بوندی جَیسا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","اَور مَوشہ نے کہا، ”یَاہوِہ کا حُکم یہ ہے: ’ایک اومر منّا لے کر اُسے آنے والی پُشتوں کے لیٔے رکھ لو تاکہ وہ اُس روٹی کو دیکھ سکیں جو مَیں نے تُمہیں بیابان میں کھِلائی جَب مَیں تُمہیں مِصر سے نکال لایا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","لہٰذا مَوشہ نے اَہرونؔ سے کہا، ”ایک مرتبان لے اَور اُس میں ایک اومر منّا بھر لے اَور اُسے یَاہوِہ کے آگے رکھ دے تاکہ وہ آنے والی پُشتوں کے لیٔے محفوظ رہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","اَور جَیسا یَاہوِہ نے مَوشہ کو آئین دیا تھا اُس کے مُطابق اَہرونؔ نے اُس منّا کو شہادت کی تختیوں کے آگے رکھ دیا تاکہ وہ رکھا رہے ");
INSERT INTO urdoucv_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","اَور بنی اِسرائیل چالیس سال تک کسی آباد مُلک میں پہُنچنے تک منّا کھاتے رہے یعنی وہ مُلکِ کنعانؔ کے حُدوُد میں قدم رکھنے تک منّا کھا کر گزارہ کرتے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(اَور ایک اومر ایفہ کا دسواں حِصّہ ہے۔) ");
INSERT INTO urdoucv_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","پھر بنی اِسرائیل کی ساری جماعت سِنؔ کے بیابان سے روانہ ہویٔی اَور جَیسا یَاہوِہ نے حُکم دیا جگہ جگہ سفر کرتے ہویٔے رفیدیمؔ میں جا کر پڑاؤ کیا۔ لیکن وہاں لوگوں کے پینے کے لیٔے پانی نہ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","لہٰذا وہ مَوشہ سے جھگڑا کرکے کہنے لگے، ”ہمیں پینے کے لیٔے پانی دو۔“ مَوشہ نے جَواب دیا، ”تُم مُجھ سے کیوں جھگڑتے ہو اَور یَاہوِہ کو کیوں آزماتے ہو؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","لیکن وہاں وہ لوگ پیاس کے مارے بیتاب تھے اَور وہ مَوشہ کے خِلاف بُڑبُڑانے لگے اَور کہنے لگے، ”آپ ہمیں اَور ہمارے بچّوں اَور ہمارے چَوپایوں کو پیاسا مارنے کے لیٔے مِصر سے کیوں نکال لائے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","تَب مَوشہ نے یَاہوِہ سے مِنّت کی، ”میں اِن لوگوں کے ساتھ کیا کروں؟ وہ تو مُجھے سنگسار کرنے کے درپے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","یَاہوِہ نے مَوشہ کو جَواب دیا، ”لوگوں کے آگے آگے چلتے رہو اَور بنی اِسرائیل کے کچھ بُزرگوں کو اَپنے ساتھ لے لو اَور اَپنا وہ عصا بھی ہاتھ میں لیتے جانا جو تُم نے دریائے نیل پر مارا تھا، ");
INSERT INTO urdoucv_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","اَور دیکھو میں تُم سے پیشتر جا کر وہاں حورِبؔ کی چٹّان پر کھڑا ہُوں گا اَور تُم اُس چٹّان پر اَپنا عصا مارنا تو اُس میں سے لوگوں کے پینے کے لیٔے پانی نکلے گا۔“ لہٰذا مَوشہ نے بنی اِسرائیل کے بُزرگوں کے سامنے یہی کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","اَور اُنہُوں نے اُس جگہ کا نام مَسّہؔ اَور مریبہؔ رکھا کیونکہ بنی اِسرائیل نے وہاں جھگڑا کیا اَور یہ کہتے ہویٔے یَاہوِہ کو آزمایا، ”یَاہوِہ ہمارے درمیان ہیں یا نہیں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","اَور اَیسا ہُوا کہ عمالیقیوں نے رفیدیمؔ میں آکر بنی اِسرائیل پر حملہ کر دیا ");
INSERT INTO urdoucv_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","تَب مَوشہ نے یہوشُعؔ سے کہا، ”ہمارے اَپنے اِنسانوں میں سے کچھ کو چُن لو اَور عمالیقیوں سے لڑنے کے لیٔے جاؤ اَور کل میں خُدا کا عصا اَپنے ہاتھوں میں لے کر پہاڑی کی چوٹی پر کھڑا رہُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","لہٰذا یہوشُعؔ عمالیقیوں سے لڑنے لگے جَیسا مَوشہ نے حُکم دیا تھا اَور مَوشہ، اَہرونؔ اَور حُورؔ پہاڑ کی چوٹی پر چڑھ گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","اَور جَب تک مَوشہ اَپنے ہاتھ اُٹھائے رکھتے تھے بنی اِسرائیل غالب آتے لیکن جَب کبھی وہ اَپنے ہاتھ نیچے کرلیتے تو عمالیقی غالب آنے لگتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","اَور جَب مَوشہ کے ہاتھ تھک گیٔے تو اُنہُوں نے ایک پتّھر لے کر مَوشہ کے پاس رکھ دیا اَور وہ اُس پر بیٹھ گئے۔ اَور اَہرونؔ اَور حُورؔ دونوں ایک مَوشہ کی ایک طرف سے اَور دُوسرا دُوسری طرف سے مَوشہ کے ہاتھوں کو سنبھالے رہے اَور یُوں اُن کے ہاتھ آفتاب کے غروب ہونے تک اُوپر اُٹھے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","اَور یہوشُعؔ نے عمالیقیوں کو بزورِ تلوار مغلُوب کر لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","تَب یَاہوِہ نے مَوشہ سے کہا، ”اِس بات کو یادگاری کے لیٔے طُومار میں لِکھ دو اَور دیکھنا کہ یہوشُعؔ بھی اُسے سُن لے کیونکہ مَیں صفحۂ ہستی سے عمالیقؔ کا نام و نِشان تک مٹا دُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","اَور مَوشہ نے ایک مذبح بنایا اَور اُس کا نام یَاہوِہ میرا پرچم ہیں رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","اَور اُنہُوں نے کہا اِس لیٔے کہ میرے ہاتھ یَاہوِہ کے تخت کی طرف اُٹھائے گیٔے تھے، ”یَاہوِہ عمالیقیوں کے خِلاف پُشت در پُشت جنگ کرتے رہیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","اَور اَیسا ہُوا کہ مِدیان کے کاہِنؔ یتروؔ نے جو مَوشہ کا سسُر تھا وہ سَب کچھ سُنا جو خُدا نے مَوشہ کے لیٔے اَور اَپنی قوم اِسرائیل کے لیٔے کیا تھا اَور یہ بھی کہ یَاہوِہ بنی اِسرائیل کو مِصر سے کِس طرح نکال لائے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","اَور جَب مَوشہ نے اَپنی بیوی ضِفورہؔ کو مَیکے بھیجا تو اُن کے سسُر یتروؔ نے ضِفورہؔ، ");
INSERT INTO urdoucv_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","اَور اُن کے دونوں بیٹوں کو اَپنے گھر میں اُتارا۔ مَوشہ نے ایک بیٹے کا نام گیرشوم رکھا تھا اَور کہا، ”میں پردیس میں پردیسی کی طرح ہُوں!“ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","اَور دُوسرے کا نام الیعزرؔ رکھا تھا اَور کہاتھا، ”میرے باپ کا خُدا میرا مددگار ہُوا اَور اُنہُوں نے مُجھے فَرعوہؔ کی تلوار سے بچایا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","اَور مَوشہ کا سسُر یتروؔ، مَوشہ کی بیوی اَور اُن کے دونوں بیٹوں کو ساتھ لے کر بیابان میں آئے، جہاں مَوشہ نے خُدا کے پہاڑ کے نزدیک ڈیرہ ڈالا ہُوا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","یتروؔ نے مَوشہ کو پیغام بھیجا تھا، ”میں تمہارا سسُر یتروؔ تمہاری بیوی اَور اُس کے دونوں بیٹوں کو اَپنے ساتھ لے کر تمہارے پاس آ رہا ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","لہٰذا مَوشہ اَپنے سسُر کا اِستِقبال کرنے کے لیٔے باہر نکلے اَور آداب بجا لاکر اُنہیں چُوما۔ اُنہُوں نے ایک دُوسرے کی خیریت پُوچھی اَور پھر وہ خیمہ کے اَندر گیٔے ");
INSERT INTO urdoucv_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","اَور مَوشہ نے اَپنے سسُر کو بتایا کہ یَاہوِہ نے بنی اِسرائیل کی خاطِر فَرعوہؔ اَور مِصریوں کے ساتھ کیا کچھ کیا اَور راستہ میں کیا کیا مُصیبتیں آئیں اَور یَاہوِہ کِس طرح اُنہیں حِفاظت سے لے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","اَور یتروؔ اُن تمام احسانات کے بارے میں سُن کر بہت خُوش ہُوا جو یَاہوِہ نے بنی اِسرائیل کو مِصریوں کے ہاتھ سے چھُڑانے کی خاطِر اُن پر کئے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","یتروؔ نے کہا، ”یَاہوِہ کی سِتائش ہو جِس نے تُمہیں مِصریوں کے ہاتھ اَور فَرعوہؔ کے ہاتھ سے نَجات دی۔ اَور جِس نے اِس قوم کو مِصریوں کے پنجہ سے چھُڑایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","اَب مَیں جان گیا کہ یَاہوِہ سَب معبُودوں سے بڑے ہیں کیونکہ اُنہُوں نے یہ اُن کے ساتھ کیا جنہوں نے بنی اِسرائیل پر ظُلم ڈھائے تھے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","پھر مَوشہ کے سسُر یتروؔ نے خُدا کے لیٔے سوختنی نذر اَور ذبیحے چڑھائے اَور اَہرونؔ اَور بنی اِسرائیل کے سَب بُزرگ مَوشہ کے سسُر کے ساتھ خُدا کے حُضُور کھانا کھانے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","اَور اگلے دِن مَوشہ لوگوں کی عدالت کرنے بیٹھے اَور لوگ صُبح سے شام تک اُن کے اِردگرد کھڑے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","جَب اُن کے سسُر نے وہ سَب کچھ جو مَوشہ لوگوں کے لیٔے کر رہے تھے، دیکھا تو اُنہُوں نے کہا، ”یہ کیا ہے جو لوگوں کے لیٔے تُم کر رہے ہو؟ تمام لوگ صُبح سے شام تک تمہارے اِردگرد کھڑے رہتے ہیں تو کیا تُم اکیلے ہی اُن کا اِنصاف کرنے کو رہ گئے ہو؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","مَوشہ نے جَواب دیا، ”اِس کا سبب یہ ہے کہ لوگ میرے پاس خُدا کی مرضی مَعلُوم کرنے آتے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","اَور جَب کبھی اُن میں کویٔی جھگڑا ہوتاہے تو وہ اُسے لے کر میرے پاس آتے ہیں اَور مَیں فریقین کے درمیان اِنصاف کرتا ہُوں اَور اُنہیں خُدا کے قوانین اَور ہدایات کی باتیں بتاتا ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","مَوشہ کے سسُر نے جَواب دیا، ”جو کچھ تُم کر رہے ہو وہ ٹھیک نہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","کیونکہ وہ لوگ جو تمہارے پاس آتے ہیں وہ تُمہیں اَور اَپنے آپ کو تھکا دیں گے۔ یہ کام تمہارے لیٔے بہت بھاری ہے اَور تُم اکیلے اِسے سنبھال نہیں سکتے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","اَب تُم میری بات سُنو۔ میں تُمہیں صلاح دیتا ہُوں اَور خُدا تمہارے ساتھ رہے۔ تُمہیں چاہیے کہ تُم خُدا کے حُضُور لوگوں کی نُمائندگی کرو اَور اُن کے جھگڑے خُدا تک پہُنچا دو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","تُم اُنہیں قوانین اَور ہدایات کی باتیں ماننا سِکھایا کرو اَور اُنہیں زندگی بسر کرنے کا طریقہ اَور وہ فرائض جو اُنہیں پُورے کرنے ہیں بتایا کرو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","تُم اُن لوگوں میں سے حق پرست اِنسان چُن لو اَیسا اِنسان جو خُدا سے ڈرنے والا اَور مُعتبر ہُوں اَور رشوت کے دُشمن ہُوں اَور اُنہیں ہزار ہزار سَو سَو پچاس پچاس اَور دس دس افراد پر بطور حاکم مُقرّر کر دو ");
INSERT INTO urdoucv_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","تاکہ وہ ہر وقت لوگوں کا اِنصاف کریں لیکن ہر بڑا مُقدّمہ تمہارے پاس لائیں اَور صِرف آسان مُقدّموں کا فیصلہ وہ خُود کریں۔ اِس طرح تمہارا بوجھ ہلکا ہو جائے گا کیونکہ وہ بھی اِس بوجھ کو اُٹھانے مَیں تمہارے شریکِ کار ہوں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","اگر تُم اَیسا کرو اَور خُدا بھی تُمہیں اِس کا حُکم دیں تو تُم اِس بھاری بوجھ کو اُٹھا سکوگے اَور تمام لوگ بھی تسلّی کے ساتھ گھر چلے جایٔیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","مَوشہ نے اَپنے سسُر کی بات مان لی اَور وَیسا ہی کیا جَیسا اُنہُوں نے بتایا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","مَوشہ نے تمام بنی اِسرائیل میں سے لائق اِنسان چُن کر اُنہیں ہزار ہزار، سَو سَو، پچاس پچاس اَور دس دس لوگوں پر بطور حاکم مامُور کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","اَور وہ ہر وقت لوگوں کا اِنصاف کرنے لگے۔ وہ بڑے بڑے مُقدّمے تو مَوشہ کے پاس لاتے تھے لیکن چُھوٹے چُھوٹے مُقدّموں کا فیصلہ وہ خُود ہی کر دیتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","پھر مَوشہ نے اَپنے سسُر کو رخصت کیا اَور یتروؔ اَپنے وطن لَوٹ گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","جَب بنی اِسرائیل کے مِصر سے چلے آنے کے بعد تین مہینے پُورے ہو گئے تو عَین اُسی دِن وہ سِینؔائی کے بیابان میں آئے ");
INSERT INTO urdoucv_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","اَور جَب وہ رفیدیمؔ سے روانہ ہوکر سِینؔائی کے بیابان میں داخل ہویٔے تو بنی اِسرائیل وہیں بیابان میں کوہِ سِینؔائی کے سامنے خیمہ زن ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","اَور مَوشہ اُس پہاڑ پر چڑھے، اَور خُدا کی حُضُوری مَیں حاضِر ہویٔے، اَور یَاہوِہ نے اُسے پہاڑ پر سے پُکار کر کہا، ”تُمہیں یعقوب کی نَسل کو اَور بنی اِسرائیل کے لوگوں کو یہ بتانا: ");
INSERT INTO urdoucv_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","’تُم نے خُود دیکھ لیا کہ مَیں نے مِصر والوں کے ساتھ کیا کچھ کیا اَور کِس طرح میں تُمہیں گویا عُقاب کے پروں پر بِٹھا کر اَپنے پاس لے آیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","اَب اگر تُم پُوری طرح میری فرمانبرداری کرو اَور میرے عہد پر چلو تو تمام قوموں میں سے تُم ہی میری خاص مِلکیّت ٹھہروگے حالانکہ ساری زمین میری ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","تُم میرے لیٔے کاہِنوں کی ایک مملکت اَور ایک مُقدّس قوم ہوگے۔‘ یہ ساری باتیں تُم بنی اِسرائیل سے کہہ دینا!“ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","پس مَوشہ نے واپس جا کر اَپنی قوم کے بُزرگوں کو بُلوایا اَور وہ باتیں جو یَاہوِہ نے اُن کو فرمائیں بَیان کیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","اَور سارے لوگوں نے مِل کر جَواب دیا، ”جو کچھ یَاہوِہ نے فرمایاہے ہم اُس پر عَمل کریں گے!“ اَور مَوشہ اُن کا یہ جَواب یَاہوِہ کے پاس لے گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","اَور یَاہوِہ نے مَوشہ سے کہا، ”مَیں گھنے بادل میں تمہارے پاس آؤں گا تاکہ یہ لوگ مُجھے تمہارے ساتھ کلام کرتے سُنیں اَور سدا تمہارا یقین کریں۔“ تَب مَوشہ نے لوگوں کی ساری باتیں یَاہوِہ سے بَیان کیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","اَور یَاہوِہ نے مَوشہ سے فرمایا، ”لوگوں کے پاس جاؤ اَور آج اَور کل اُنہیں پاک کرو اَور دیکھو کہ وہ اَپنے کپڑے دھولیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","اَور تیسرے دِن تیّار رہیں کیونکہ اُس دِن یَاہوِہ سَب لوگوں کی نظر کے سامنے کوہِ سِینؔائی پر اُتریں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","اَور تُم پہاڑ کے اِردگرد لوگوں کے لیٔے حدّ باندھ کر اُنہیں بتا دینا، ’وہ خبرداررہیں۔ نہ تو وہ اُس پہاڑ پر چڑھیں اَور نہ اُس کی حد کو چھُوئیں۔ اَورجو کویٔی اُس پہاڑ کو چھُوئے وہ یقیناً جان سے مار ڈالا جائے ");
INSERT INTO urdoucv_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","خواہ وہ اِنسان ہو یا حَیوان اُسے یقیناً سنگسار کر دیا جائے یا تیروں سے چھید ڈالا جائے یعنی اُسے زندہ نہ رہنے دیا جائے اَور اُسے کویٔی ہاتھ نہ لگائے۔‘ ہاں جَب قَرنا دیر تک بجایا جائے تَب وہ اُس پہاڑ کے پاس جا سکتے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","اَور مَوشہ پہاڑ سے نیچے اُترے اَور لوگوں کے پاس جا کر اُنہیں پاک کیا اَور اُنہُوں نے اَپنے کپڑے دھو لیٔے ");
INSERT INTO urdoucv_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","پھر اُنہُوں نے لوگوں سے کہا، ”اَپنے آپ کو تیسرے دِن کے لیٔے تیّار کرو اَور عورت سے دُور رہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","اَور تیسرے دِن کی صُبح کو بادل گرجنے لگا اَور بجلی چمکنے لگی اَور پہاڑ کے اُوپر گھنا بادل چھا گیا اَور نرسنگا بہت زور سے بجا اَور چھاؤنیوں میں لوگوں پر لرزہ طاری ہو گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","تَب مَوشہ لوگوں کو چھاؤنی سے باہر لایٔے تاکہ اُنہیں خُدا سے مِلوائے۔ سَب لوگ پہاڑ کی حد میں کھڑے ہو گئے ");
INSERT INTO urdoucv_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","اَور کوہِ سِینؔائی اُوپر سے نیچے تک دھوئیں سے چھُپ گیا کیونکہ یَاہوِہ شُعلہ میں اُس پر اُترے تھے اَور دُھواں تنور کے دھوئیں کی مانند اُوپر اُٹھ رہاتھا اَور وہ سارا پہاڑ زور زور سے لرز رہاتھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","اَور جَب نرسنگے کی آواز اَور بھی زِیادہ بُلند ہونے لگی تو مَوشہ نے بولنا شروع کیا اَور خُدا نے گرج دار آواز سے اُنہیں جَواب دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","اَور یَاہوِہ کوہِ سِینؔائی کی چوٹی پر اُترے اَور اُنہُوں نے مَوشہ کو پہاڑ کی چوٹی پر بُلایا۔ اِس لئے مَوشہ اُوپر گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","اَور یَاہوِہ نے مَوشہ سے فرمایا، ”جا کر لوگوں کو تاکید کرو اَور سمجھاؤ کہ اَیسا نہ ہو کہ وہ یَاہوِہ کو دیکھنے کے لیٔے مُقرّرہ حدّوں کو پار کرکے اِتنے نزدیک آ جایٔیں کہ اُن میں بہت سے ہلاک ہو جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","اَور وہ کاہِنؔ بھی جو یَاہوِہ کے حُضُور آنے کے لیٔے مُقرّر ہیں اَپنے آپ کو ضروُر پاک کریں ورنہ میں اُن کے ساتھ سختی سے پیش آؤں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","مَوشہ نے یَاہوِہ سے کہا، ”لوگ کوہِ سِینؔائی پر نہیں آسکتے کیونکہ آپ نے ہمیں خُود ہی تاکیداً کہاتھا، ’پہاڑ کے اِردگرد حدّ باندھ کر اُسے ایک مُقدّس مقام کے طور پر مخصُوص کر دو۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","اَور یَاہوِہ نے جَواب دیا، ”نیچے جا کر اَہرونؔ کو اَپنے ساتھ اُوپر لے آؤ۔ لیکن کاہِنؔ اَور عوام یَاہوِہ کے پاس اُوپر آنے کے لیٔے مُقرّرہ حدّوں کو ہرگز نہ توڑیں ورنہ یَاہوِہ اُن کے ساتھ سختی سے پیش آئیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","چنانچہ مَوشہ لوگوں کے پاس نیچے گئے اَور یہ باتیں اُنہیں بتائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","اَور خُدا نے یہ سَب باتیں فرمائیں کہ: ");
INSERT INTO urdoucv_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","”یَاہوِہ تمہارا خُدا، جو تُمہیں مُلک مِصر کی غُلامی سے نکال لایا میں ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","”میرے حُضُور تُم غَیر معبُودوں کو نہ ماَننا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","تُم کسی بھی شَے کی صورت پر خواہ وہ اُوپر آسمان میں یا نیچے زمین پر یا نیچے پانیِوں میں ہو کویٔی بُت نہ بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","تُم اُن کے آگے سَجدہ نہ کرنا اَور نہ ہی اُن کی عبادت کرنا۔ کیونکہ مَیں یَاہوِہ تمہارا خُدا غیّور خُدا ہُوں، اَورجو مُجھ سے عداوت رکھتے ہیں مَیں اُن کی اَولاد کو تیسری اَور چوتھی پُشت تک اُن کے آباؤاَجداد کی بدکاری کی سزا دیتا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","لیکن ہزاروں پُشتیں جو مُجھ سے مَحَبّت رکھتی ہیں اَور میرے حُکموں کو مانتی ہیں میں اُن سے مَحَبّت رکھتا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","تُم یَاہوِہ اَپنے خُدا کا نام بے مقصد نہ لینا کیونکہ جو کویٔی اُن کا نام بے مقصد لے گا یَاہوِہ اُسے بے سزا نہیں چھوڑیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","سَبت کے دِن کو پاک رکھنے کے طور پر یاد رکھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","چھ دِن تک تُم محنت سے اَپنا سارا کام کاج کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","لیکن ساتواں دِن یَاہوِہ تمہارے خُدا کا سَبت ہے۔ اُس دِن نہ تُم کویٔی کام کرنا نہ تمہارا بیٹا یا بیٹی نہ تمہارا غُلام یا خادِمائیں نہ تمہارے چَوپائے اَور نہ کویٔی پردیسی جو تمہارے پھاٹکوں کے اَندر رہتا ہو، تاکہ تمہارے خادِم اَور خادِمائیں تمہاری طرح آرام کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","کیونکہ چھ دِن میں یَاہوِہ نے آسمانوں کو، اَور زمین اَور سمُندر کو اَورجو کچھ اُن میں مَوجُود ہر چیز کو پیدا کیا ہے۔ لیکن ساتویں دِن آرام کیا۔ پس یَاہوِہ نے سَبت کے دِن کو برکت دی اَور اُسے مُقدّس ٹھہرایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","اَپنے باپ اَور اَپنی ماں کی عزّت کرنا تاکہ اُس مُلک میں جو یَاہوِہ تمہارے خُدا تُمہیں دیتے ہیں، تمہاری عمر دراز ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","تُم اِنسان کا خُون نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","تُم زنا نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","تُم چوری نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","تُم اَپنے پڑوسی کے خِلاف جھُوٹی گواہی نہ دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","تُم اَپنے پڑوسی کے گھر کا لالچ نہ کرنا۔ تُم اَپنے پڑوسی کی بیوی کا لالچ نہ کرنا اَور نہ اُس کے غُلام یا اُس کی خادِمہ کا، نہ اُس کے بَیل یا گدھے کا، اَور نہ اَپنے پڑوسی کی کسی اَور چیز کا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","اَور جَب لوگوں نے بادل کا گرجنا اَور بجلی کا چمکنا دیکھا اَور نرسنگے کی آواز سُنی اَور اُس پہاڑ سے دُھواں اٹھتے دیکھا تو وہ خوف سے کانپنے لگے اَور دُور جا کھڑے ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","اَور اُنہُوں نے مَوشہ سے کہا، ”ہم سے تُم ہی باتیں کیا کرنا اَور ہم سُن لیا کریں گے لیکن خُدا ہم سے باتیں نہ کریں تاکہ ہم ہلاک نہ ہوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","مَوشہ نے لوگوں سے کہا، ”ڈرو مت خُدا اِس لیٔے آئے کہ تمہاری آزمائش کریں تاکہ تُمہیں خُدا کا خوف ہو اَور تُم گُناہ سے بچے رہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","تَب مَوشہ اُس گہری تاریکی کے نزدیک جہاں خُدا مَوجُود تھے پہُنچے لیکن وہ لوگ دُور ہی کھڑے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","اَور یَاہوِہ نے مَوشہ سے کہا، ”بنی اِسرائیل کو یہ بتاؤ کہ تُم نے خُود دیکھا کہ مَیں نے آسمان پر سے تمہارے ساتھ باتیں کی ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","تُم میرے ساتھ کسی کو شریک نہ کرنا اَور اَپنے لیٔے چاندی یا سونے کے معبُود نہ گڑھ لینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","” ’میرے لیٔے مٹّی کا ایک مذبح بنانا اَور اُس پر اَپنی بھیڑ بکریوں اَور گائے بَیلوں کی سوختنی نذر اَور سلامتی کی نذریں چڑھانا۔ جہاں کہیں میرے نام کی تمجید کی جائے گی مَیں تمہارے پاس آؤں گا اَور تُمہیں برکت دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","اَور اگر تُم میرے لیٔے ایک پتّھروں کا مذبح بناؤ تو اُسے تراشے ہویٔے پتّھروں سے نہ بنانا کیونکہ اگر تُم اُسے بنانے کے لیٔے کویٔی اوزار اِستعمال کروگے تو اُسے ناپاک کر دوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","اَور میرے مذبح تک سِیڑھیوں سے نہ جانا۔ اَیسا نہ ہو کہ تمہارا ننگا پن اُس پر ظاہر ہو جائے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","”وہ آئین جو تُمہیں لوگوں کو بتانا ہیں یہ ہیں: ");
INSERT INTO urdoucv_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","”اگر تُم عِبرانی غُلام خریدو تو وہ چھ سال تک تمہاری خدمت کرے لیکن ساتویں سال وہ قیمت اَدا کئے بغیر آزاد ہوکر چلا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","اگر خَاوند اکیلا خریدا جائے تو اکیلا ہی آزاد کیا جائے۔ اگر شادی شُدہ ہو تو اُس کی بیوی بھی اُس کے ساتھ آزاد کی جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","اگر اُس کی شادی اُس کے آقا نے کروائی ہو اَور اُس عورت کے اُس سے بیٹے اَور بیٹیاں ہُوئی ہُوں تو وہ عورت اَور اُس کے بچّے اُس کے آقا کے ہوں گے اَور صِرف اِنسان آزاد کیا جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","”لیکن اگر وہ غُلام یہ اعلان کرے ’میں اَپنے آقا سے اَور اَپنی بیوی اَور بچّوں سے مَحَبّت رکھتا ہُوں اَور مَیں آزاد ہوکر جانا نہیں چاہتا،‘ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","تو اُس کا آقا اُسے قاضیوں کے پاس لے جائے اَور اُسے دروازہ پر یا دروازہ کی چوکھٹ پر لاکر سُوئے سے اُس کا کان چھید دے۔ تَب وہ عمر بھر اُس کی خدمت کرتا رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","”اَور اگر کویٔی اِنسان اَپنی بیٹی کو بطور خادِمہ بیچ دے تو وہ خادِمہ غُلاموں کی طرح چھ بَرس کے بعد آزاد نہ کی جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","اگر وہ اَپنے آقا کو جِس نے اُسے اَپنے لیٔے مُنتخب کیا تھا خُوش نہ کرے تو وہ اُس کی چھڑوتی قیمت واپس لے کر اُسے اَپنے گھر جانے دے۔ اُسے اُس خادِمہ کو کسی پردیسی قوم کے ہاتھ بیچنے کا اِختیار نہیں کیونکہ وہ اُس خادِمہ کو اَپنے یہاں لانے کے بعد اُس سے کیا ہُوا وعدہ پُورا نہ کر سَکا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","اگر وہ اُسے اَپنے بیٹے کے لیٔے خریدتا ہے تو اُس کے ساتھ بیٹیوں کے جَیسا سلُوک اَور حق اَدا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","اَور اگر وہ کسی دُوسری عورت کو شادی کرکے لایٔے تو لازِم ہے کہ وہ اُس خادِمہ یعنی پہلی عورت کو کھانے کپڑوں اَور اِزدواجی حُقُوق سے محروم نہ کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","اگر وہ اُسے یہ تین چیزیں مُہیّا نہیں کرتا تو وہ خادِمہ اَپنے آزاد ہونے کی قیمت اَدا کئے بغیر واپس جا سکتی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","”اگر کویٔی کسی اِنسان پر اَیسا حملہ کرے کہ وہ مَر جائے تو وہ لازماً جان سے ماراجائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","تاہم اگر اُس نے قصداً اَیسا نہ کیا ہو بَلکہ خُدا نے اَیسا ہونے دیا ہو تو اُس صورت میں وہ اُس جگہ جسے میں مُقرّر کروں گا فرار ہو جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","لیکن اگر کویٔی دیدہ و دانستہ کسی دُوسرے اِنسان پر حملہ کرے تو اُسے میرے مذبح سے دُور لے جا کر مار دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","”اَورجو کویٔی اَپنے باپ یا اَپنی ماں پر حملہ کرے وہ لازماً مار ڈالا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","”اَورجو کویٔی کسی دُوسرے اِنسان کو اِغوا کرے خواہ اُسے بیچ دے خواہ اَپنے پاس رکھے اَور پکڑا جائے تو وہ ضروُر مار ڈالا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","”اَورجو کویٔی اَپنے باپ یا اَپنی ماں پر لعنت کرے وہ قطعی مار ڈالا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","”اَور اگر دو اِنسان جھگڑیں اَور ایک اِنسان دُوسرے اِنسان کو پتّھر یا مُکّا مارے اَور وہ نہ مَرے لیکن بِستر سے جا لگے، ");
INSERT INTO urdoucv_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","اَور اُس کے بعد اُٹھ کر اَپنی لاٹھی کے سہارے چلنے پھرنے لگے تو وہ جِس نے مارا تھا بَری سمجھا جائے لیکن ہرجانہ بھرے اَور زخمی ہونے والے کے علاج کا سارا خرچ مُکمّل شفا ہونے تک اَدا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","”اگر کویٔی اِنسان اَپنے غُلام یا اَپنی خادِمہ کو لاٹھی سے اَیسا مارے کہ وہ فوراً مَر جائے تو اُسے لازماً سزا دی جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","لیکن اگر وہ غُلام ایک دو دِن کے بعد اَچھّا ہو جائے تو اُسے سزا نہ دی جائے، اِس لیٔے کہ وہ غُلام اُس کی مِلکیّت ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","”اگر وہ لوگ جو باہم لڑ رہے ہُوں کسی حاملہ عورت کو اَیسی چوٹ پہُنچائیں جِس کے باعث اُس کا حَمل گِر جائے لیکن اُسے کویٔی اَور ضرر نہ پہُنچے تو جِتنا جُرمانہ اُس کا خَاوند مانگے اَور قاضی منظُور کریں اُس سے لیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","لیکن اگر اُسے کویٔی اَور ضرر پہُنچا ہو تو تُم جان کے بدلے جان ");
INSERT INTO urdoucv_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","آنکھ کے بدلے آنکھ، دانت کے بدلے دانت، ہاتھ کے بدلے ہاتھ اَور پاؤں کے بدلے پاؤں لے لینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","جَلانے کے بدلے جَلانا، زخم کے بدلے زخم اَور چوٹ کے بدلے چوٹ پہُنچانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","”اگر کویٔی مالک اَپنے غُلام یا لونڈی کی آنکھ پر اَیسا مارے کہ وہ پھوٹ جائے تو وہ اُس کی آنکھ کے بدلے اُس غُلام یا لونڈی کو آزاد کر دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","اَور اگر مالک کسی غُلام یا لونڈی کو مار کر اُس کا دانت توڑ ڈالے تو وہ اُس کے دانت کے بدلے اُس غُلام یا لونڈی کو آزاد کر دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","”اگر کویٔی بَیل کسی مَرد یا عورت کو سینگ مار کر مار ڈالے تو اُس بَیل کو ضروُر سنگسار کیا جائے اَور اُس کا گوشت ہرگز نہ کھایا جائے لیکن بَیل کا مالک بےگُناہ ٹھہرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","لیکن اگر اُس بَیل کے سینگ مارنے کی عادت ہے اَور مالک کو آگاہ کیا جا چُکاہے لیکن اُس نے اُسے باندھ کر نہیں رکھا اَور وہ کسی مَرد یا عورت کو مار ڈالے تو اُس بَیل کو سنگسار کر دیا جائے اَور اُس کے مالک کو بھی مار ڈالا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","تاہم اگر اُس سے خُون بہا تو اُس کی چھڑوتی مانگی جائے تو اُسے اَپنی جان کے فدیہ میں جِتنا اُس سے طلب کیا جائے اُتنا ہی دینا پڑےگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","اگر وہ بَیل کسی کے بیٹے یا بیٹی کو سینگ مار کر مار ڈالے تَب بھی اِسی آئین کے مُطابق عَمل کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","اگر وہ بَیل کسی غُلام یا لونڈی کو سینگ مار کر مار ڈالے تو اُس بَیل کا مالک اُس غُلام یا لونڈی کے مالک کو تیس ثاقل چاندی اَدا کرے اَور اُس بَیل کو ضروُر سنگسار کر دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","”اَور اگر کویٔی اِنسان کویٔی گڑھا کھول دے یا گڑھا کھود کر اُس کا مُنہ نہ ڈھانپے اَور کویٔی بَیل یا گدھا اُس میں گِر جائے ");
INSERT INTO urdoucv_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","تو گڑھے کا مالک اُس کا نُقصان بھر دے اَور جانور کے مالک کو قیمت اَدا کرے اَور مَرے ہویٔے جانور کو خُود لے لے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","”اگر کسی اِنسان کا بَیل کسی دُوسرے کے بَیل کو اَیسا زخمی کرے کہ وہ مَر جائے تو وہ اُس زندہ بَیل کو بیچ دے اَور اُس کا دام آپَس میں آدھا آدھا بانٹ لیں اَور اُس مَرے ہویٔے بَیل کو بھی اَیسے ہی بانٹ لے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","لیکن اگر یہ بات مَعلُوم ہو کہ بَیل کو سینگ مارنے کی عادت تھی اَور اُس کے مالک نے پھر بھی اُسے باندھ کر نہیں رکھا تو اُس کے مالک کو بَیل کے بدلے بَیل دینا لازمی ہوگا اَور مَرا ہُوا جانور اُس کا ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","”اگر کویٔی اِنسان ایک بَیل یا بھیڑ چُرا کر اُسے ذبح کرے یا بیچ دے تو وہ اُس بَیل کے بدلے پانچ بَیل اَور اُس بھیڑ کے بدلے چار بھیڑیں بطور مُعاوضہ دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","”اگر کویٔی چور نقب زنی کرتے ہویٔے پکڑا جائے اَور اُس کو اَیسی مار پڑے کہ وہ مَر جائے تو مارنے والا خُون کا مُجرم نہ سمجھا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","لیکن اگر یہ واقعہ دِن میں ہو تو وہ خُون کا مُجرم سمجھا جائے گا۔ ”چور کو لازِم ہے کہ وہ چوری کے مال کا مُعاوضہ واپس کرے۔ اگر اُس کے پاس کچھ نہ ہو تو وہ چوری کی سزا کے طور پر غُلام بنا کر بیچ دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","لیکن اگر چوری کیا ہُوا جانور اُس کے پاس جیتا مِل جائے خواہ وہ بَیل ہو یا گدھا یا بھیڑ تو وہ اُس کا دُگنا واپس کر دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","”اگر کویٔی اِنسان اَپنے مویشی کسی کھیت یا انگور کے باغ میں چَراتا ہو اَور وہ اُنہیں بھٹک جانے دے اَور وہ جا کر کسی دُوسرے کے کھیت میں چرنے لگیں تو وہ اَپنے کھیت یا انگور کے باغ کی اَچھّی سے اَچھّی پیداوار میں سے اُس کا مُعاوضہ دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","”اگر آگ بھڑک اُٹھے اَور کانٹے دار جھاڑیوں میں اَیسی پھیل جائے کہ اُس سے اناج کے پُولے یا کھڑی فصل یا سارا کھیت جَل جائے تو وہ جِس نے آگ جَلائی ہو ضروُر مُعاوضہ اَدا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","”اگر کویٔی اِنسان اَپنی چاندی یا دیگر سامان اَپنے پڑوسی کے پاس بطور اَمانت رکھے اَور وہ پڑوسی کے گھر سے چوری ہو جائے اَور چور پکڑا جائے تو وہ اُس کا دُگنا اَدا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","لیکن اگر چور پکڑا نہ جائے تو ضروُری ہے کہ اُس گھر کا مالک قاضی کے سامنے حاضِر ہو تاکہ مَعلُوم ہو سکے کہ کہیں اُس نے اَپنے پڑوسی کی اَمانت میں خیانت نہیں کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","خیانت والے سارے مُعاملات خواہ وہ بَیل، گدھے، بھیڑ یا کپڑے یا کسی گُم شُدہ مال کے بارے میں کہے، ’یہ میرا ہے،‘ فریقین کی طرف سے قاضیوں کے حُضُور پیش کئے جایٔیں اَور جِس کو قاضی مُجرم ٹھہرائے وہ اَپنے پڑوسی کو دُگنا اَدا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","”اگر کویٔی اِنسان اَپنے ہمسایہ کے پاس گدھا یا بَیل یا بھیڑ یا کویٔی اَور جانور بطور اَمانت رکھے اَور وہ مرجائے یا زخمی ہو جائے یا چوری چُھپے کہیں اَور بھیج دیا جائے ");
INSERT INTO urdoucv_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","تو اَیسے مُعاملہ کے تصفیہ کے لیٔے وہ دونوں یَاہوِہ کے سامنے حاضِر ہُوں اَور مُلزم قَسم کھا کر کہے کہ اُس نے اَپنے پڑوسی کی اَمانت میں خیانت نہیں کی اَور مالک اِسے سچ مانے تو کویٔی مُعاوضہ اَدا نہ کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","لیکن اگر وہ جانور پڑوسی کے یہاں سے چُرا لیا گیا ہو تو اُس کے مالک کو مُعاوضہ اَدا کرنا لازمی ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","اگر اُسے کسی درندہ نے پھاڑ ڈالا ہو تو وہ اُس کی لاش بطور ثبوت پیش کر دے تو اُس سے اُس پھاڑے ہویٔے جانور کا مُعاوضہ نہ لیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","”اگر کویٔی اِنسان اَپنے پڑوسی سے کویٔی جانور اُدھار لے اَور وہ مالک کی غَیر مَوجُودگی میں زخمی ہو جائے یا مَر جائے تو وہ ضروُر اُس کا مُعاوضہ اَدا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","لیکن اگر مالک اَپنے جانور کے ساتھ ہو تو اُسے اُدھار لینے والے کو مُعاوضہ نہیں دینا پڑےگا۔ اگر وہ جانور کرایہ پر لیا گیا تھا تو کرایہ کی رقم ہی نُقصان کی تلافی سَمجھی جائے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","”اگر کویٔی اِنسان کسی کنواری کو جِس کی نِسبت نہ ہُوئی ہو پھُسلا کر اُس سے مباشرت کرے تو وہ لازماً اُسے مَہر دے اَور اُس سے شادی کر لے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","اگر لڑکی کا باپ اُسے اَپنی لڑکی دینے سے قطعاً اِنکار کر دے تَب بھی وہ کنواریوں کے مَہر کے مُطابق اُسے نقد رُوپیہ اَدا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","”تُم جادُوگرنی کو زندہ نہ رہنے دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","”جو کویٔی جانور سے مباشرت کرے وہ قطعی جان سے ماراجائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","”جو کویٔی واحد یَاہوِہ کے سِوا کسی دُوسرے معبُود کے آگے قُربانی چڑھائے تو وہ بالکُل نابود کر دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","”کسی پردیسی سے بدسلُوکی نہ کرنا اَور نہ ہی اُس پر ستِم ڈھانا کیونکہ تُم بھی مِصر میں پردیسی تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","”تُم کسی بِیوہ یا یتیم کو دُکھ نہ دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","اگر تُم نے اَیسا کیا اَور اُنہُوں نے مُجھ سے فریاد کی تو میں یقیناً اُن کی فریاد سُنوں گا ");
INSERT INTO urdoucv_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","اَور میرا قہر بھڑکے گا اَور مَیں تُمہیں تلوار سے مار ڈالوں گا اَور تمہاری بیویاں بِیوہ اَور تمہارے بچّے یتیم ہو جایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","”اگر تُم میرے لوگوں میں سے کسی مُحتاج کو جو تمہارے پاس رہتاہے کچھ رُوپیہ قرض دو تو اُس سے ساہوکار کی طرح سلُوک نہ کرنا اَور نہ زِیادہ سُود لینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","اگر تُم اَپنے پڑوسی کی چادر بطور رہن رکھ لو تو سُورج کے ڈُوبنے تک اُسے لَوٹا دینا ");
INSERT INTO urdoucv_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","کیونکہ اُس کے پاس جِسم ڈھانپنے کے لیٔے صِرف وُہی چادر ہے۔ پھر وہ کیا اوڑھ کر سوئے گا؟ جَب وہ مُجھ سے فریاد کرےگا تو میں اُس کی فریاد سُنوں گا کیونکہ مَیں بڑا رحیم ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","”تُم خُدا پر لعنت نہ کرنا اَور اَپنی قوم کے رہنماؤں پر لعنت مت بھیجنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","”تُم گوداموں میں جمع کی ہُوئی پیداوار اَور اَپنے کولھو سے نکالے ہویٔے رس میں سے میرے لیٔے نذریں لانے میں تاخیر نہ کرنا۔ ”اَور تُمہیں اَپنے بیٹوں میں سے پہلوٹھے کو لازماً مُجھے دینا ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","اَور اَپنے مویشیوں اَور بھیڑوں کے پہلوٹھے کے ساتھ بھی اَیسا ہی کرنا۔ سات دِن تک تُم اُنہیں اَپنی ماؤں کے ساتھ رہنے دینا لیکن آٹھویں دِن تُم اُنہیں مُجھے دے دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","”تُم میرے مُقدّس لوگ ہوگے لہٰذا درندوں کے پھاڑے ہویٔے جانور کا گوشت نہ کھانا بَلکہ اُسے کُتّوں کے آگے پھینک دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","”تُم جھُوٹی خبریں نہ پھیلانا اَور نہ جھُوٹی گواہی دینے کے لیٔے کسی مُجرم کی مدد کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","”بُرائی کرنے کے لیٔے ہُجوم کی پیروی نہ کرنا اَور جَب تُم کسی مُقدّمہ میں گواہی دو تو محض ہُجوم کا ساتھ دینے کی خاطِر اِنصاف کا خُون نہ کردینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","اَور کسی غریب اِنسان کے مُقدّمہ میں بھی طرفداری سے کام نہ لینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","”اگر تُمہیں اَپنے دُشمن کا بھٹکا ہُوا بَیل یا گدھا کہیں مِل جائے تو اُسے ضروُر اُس کے پاس واپس لے جانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","اگر تُم اَپنے رقیب کے گدھے کو اُس کے بھاری بوجھ کے باعث گرا ہُوا دیکھو تو اُسے یُوں ہی نہ چھوڑ دینا بَلکہ اُسے کھڑا کرنے میں اُس کی مدد کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","”تُم اَپنے غریب لوگوں کے مُقدّمات میں اِنصاف کا خُون نہ ہونے دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","جھُوٹے اِلزام سے کویٔی واسطہ نہ رکھنا اَور نہ کسی بے قُصُور یا ایماندار اِنسان کو قتل کرنا کیونکہ مَیں کسی مُجرم کو نہ چھوڑوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","”تُم رشوت نہ لینا کیونکہ رشوت بیناؤں کو اَندھا کردیتی ہے اَور صادقوں کی باتوں کو بدل ڈالتی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","”کسی پردیسی پر ظُلم نہ کرنا کیونکہ تُم پردیسی کے دِل کو جانتے ہو اِس لیٔے کہ تُم خُود بھی مُلک مِصر میں پردیسی تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","”چھ سال تک تُم اَپنے کھیتوں میں بیج بونا اَور فصل کاٹنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","لیکن ساتویں سال اُس زمین میں نہ تو ہل چلانا اَور نہ اُسے اَپنے اِستعمال میں لانا تمہارے لوگوں میں جو ضروُرت مند ہُوں وہ اُس میں سے خُوراک حاصل کرنے کے لئے چھوڑیں۔ اَورجو اُن سے بچ رہے اُسے جنگلی جانور چَر لیں۔ اَپنے انگور کے باغ اَور اَپنے زَیتُون کے باغ سے بھی اَیسا ہی کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","”چھ دِن اَپنا کام کاج کرنا لیکن ساتویں دِن کویٔی کام نہ کرنا تاکہ تمہارے بَیل اَور تمہارے گدھے کو آرام ملے اَور تمہارا خانہ زاد غُلام اَور وہ پردیسی جو تمہارے یہاں ٹھہرا ہو، تازہ دَم ہو جایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","”اَور ہر ایک بات پرجو مَیں نے تُم سے کہی ہے احتیاط سے عَمل کرنا اَور دُوسرے معبُودوں کا نام تک نہ لینا بَلکہ وہ تمہارے مُنہ سے بھی سُنایٔی نہ دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","”تُم سال میں تین بار میرے لیٔے عید منانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","”عیدِ فطیر یعنی بے خمیری روٹی کی عید منانا اَور سات دِن تک جَیسا کہ مَیں نے تُمہیں حُکم دیا بے خمیری روٹیاں کھانا اَور اَیسا ابیبؔ کے مہینے میں مُقرّرہ وقت پر کرنا کیونکہ اُسی مہینے میں تُم مُلک مِصر سے نکلے تھے۔ ”اَور کویٔی بھی میرے سامنے خالی ہاتھ نہ آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","”اَور اَپنے کھیت میں جو فصل تُم بوؤ اُس کی پہلی پیداوار سے فصل کاٹنے کی عید منانا۔ ”اَور جَب تُم کھیت سے اَپنی فصل جمع کرو تو سال کے آخِر میں اناج جمع کرنے کی عید منانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","”سال میں تین بار تمام مَردوں کو یَاہوِہ قادر کے حُضُور حاضِر ہونا ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","”تُم قُربانی کا خُون کسی اَیسی چیز کے ساتھ نہ پیش کرنا جِس میں خمیر مِلا ہو مُجھے نہ چڑھانا۔ ”اَور میری عید کی قُربانیوں کی چربی میں سے کچھ صُبح تک باقی نہ رکھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","”اَور تُم اَپنی زمین کے پہلے پھلوں میں سے بہترین پھل یَاہوِہ اَپنے خُدا کے گھر میں لانا۔“ تُم بکری کے بچّہ کو اُس کی ماں کے دُودھ میں نہ پکانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","”سُنو، میں ایک فرشتہ تمہارے آگے بھیج رہا ہُوں تاکہ راستہ میں تمہارا نگہبان ہو اَور تُمہیں اُس جگہ پہُنچا دے جسے مَیں نے تیّار کیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","تُم اُس کی طرف متوجّہ ہونا اَور اُس کی بات ماَننا۔ اَور اُس سے سرکشی نہ کرنا کیونکہ وہ تمہاری سرکشی کو مُعاف نہیں کرےگا اِس لیٔے کہ میرا نام اُس میں رہتاہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","اگر تُم اُس کی بات مانوگے اَور وہ سَب جو مَیں کہتا ہُوں کروگے تو مَیں تمہارے دُشمنوں کا دُشمن اَور تمہاری مُخالفت کرنے والوں کا مُخالف ہُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","میرا فرشتہ تمہارے آگے آگے چلے گا اَور تُمہیں امُوریوں، حِتّیوں، پَرزّیوں، کنعانیوں، حِوّیوں اَور یبُوسیوں کے مُلک میں پہُنچا دے گا اَور مَیں اُنہیں ہلاک کر ڈالوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","تُم نہ تو اُن کے معبُودوں کو سَجدہ کرنا نہ اُن کی عبادت کرنا اَور نہ اُن کی پیروی کرنا۔ تُم اُنہیں مِسمار کردینا اَور اُن کے مُقدّس سُتونوں ٹکڑے ٹکڑے کردینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","تُم یَاہوِہ اَپنے خُدا کی عبادت کرنا تو تمہاری روٹی اَور تمہارے پانی پر اُس کی برکت ہوگی اَور مَیں تمہارے درمیان سے بیماری کو دُور کروں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","اَور تمہارے مُلک میں نہ تو کسی عورت کا حَمل گِرے گا اَور نہ کویٔی بانجھ ہوگی۔ اَور مَیں تُمہیں عمر کی درازی بخشوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","”میں اَپنی ہیبت کو تمہارے آگے آگے بھیجوں گا اَور مَیں ہر ایک قوم کو جو تمہارا مُقابلہ کرےگی شِکست دُوں گا۔ تمہارے سارے دُشمن میری وجہ سے پیٹھ پھیر کر بھاگ جایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","اَور تمہارے آگے تتیاؤں کو بھیجوں گا جو حِوّیوں، کنعانیوں اَور حِتّیوں کو تمہارے سامنے سے بھگا دیں گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","لیکن مَیں اُنہیں ایک ہی بَرس میں نہ بھگاؤں گا تاکہ زمین ویران نہ ہو اَور جنگلی جانوروں کی کثرت تمہارے لیٔے نُقصان دہ ثابت نہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","بَلکہ میں تھوڑا تھوڑا کرکے اُنہیں تمہارے سامنے سے اُس وقت تک دُور کرتا رہُوں گا جَب تک کہ تُم تعداد میں بڑھ کر اُس مُلک پر قابض نہ ہو جاؤ۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","”اَور مَیں تمہاری سرحدیں بحرِقُلزمؔ سے لے کر فلسطینیوں کے بہر تک اَور بیابان سے لے کر دریائے فراتؔ تک مُقرّر کروں گا اَور اُس مُلک میں رہنے والوں کو تمہارے قبضہ میں دے دُوں گا اَور تُم اُنہیں اَپنے سامنے سے نکال دوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","تُم اُن سے یا اُن کے معبُودوں سے کویٔی عہد نہ باندھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","اَور وہ تمہارے مُلک میں رہنے نہ پائے اَیسا نہ ہو کہ وہ تُم سے میرے خِلاف گُناہ کروائیں کیونکہ اُن کے معبُودوں کی عبادت تمہارے لیٔے یقیناً ایک پھندا بَن جائے گی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","تَب یَاہوِہ نے مَوشہ سے کہا، ”تُم اَور تمہارے ساتھ اَہرونؔ نادابؔ اَور اَبِیہُو اَور بنی اِسرائیل کی نَسل کے ستّر رہنما اُوپر یَاہوِہ کے پاس آئیں اَور تُم دُور ہی سے سَجدہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","صِرف مَوشہ ہی یَاہوِہ کے نزدیک آئے دُوسرے نزدیک نہ آئیں۔ نہ ہی اَور لوگ اُن کے ساتھ اُوپر چڑھیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","جَب مَوشہ نے جا کر اُن لوگوں کو یَاہوِہ کی سَب باتیں اَور اَحکام بتائے تو اُنہُوں نے ہم آواز ہوکر جَواب دیا، ”جو کچھ یَاہوِہ نے فرمایاہے ہم بجا لائیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","تَب مَوشہ نے ساری باتوں کو جو یَاہوِہ نے فرمائی تھیں لِکھ لیا۔ اَور اگلے دِن صُبح سویرے اُٹھ کر پہاڑ کے دامن میں ایک مذبح بنایا اَور بنی اِسرائیل کے بَارہ قبیلوں کے حِساب سے پتّھر کے بَارہ سُتون نصب کئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","تَب مَوشہ نے بنی اِسرائیل کے جَوانوں کو بھیجا اَور اُنہُوں نے سوختنی نذریں چڑھائیں اَور بچھڑوں کو ذبح کرکے سلامتی کی نذر کی قُربانی یَاہوِہ کے حُضُور گزرانی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","اَور مَوشہ نے آدھا خُون لے کر لگنوں میں رکھا اَور باقی کا آدھا مذبح پر چھڑک دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","پھر مَوشہ نے عہد کی کِتاب کو لیا اَور لوگوں کو پڑھ کر سُنایا اَور اُنہُوں نے جَواب دیا، ”جو کچھ یَاہوِہ نے فرمایاہے ہم بجا لائیں گے اَور تابع رہیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","تَب مَوشہ نے وہ خُون لیا اَور اُسے اُن لوگوں پر چھڑک دیا اَور کہا، ”یہ اُس عہد کا خُون ہے جو یَاہوِہ نے اِن سَب باتوں کی بابت تمہارے ساتھ باندھا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","پھر مَوشہ اَور اَہرونؔ نادابؔ اَور اَبِیہُو اَور بنی اِسرائیل کے وہ ستّر رہنما اُوپر گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","اَور اُنہُوں نے اِسرائیل کے خُدا کو دیکھا۔ اُن کے پاؤں کے نیچے نیلم کے پتّھر کی اینٹوں کا چبوترہ سا تھا جو نیلے آسمان کی مانند شفّاف تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","بنی اِسرائیل کے اِن سربراہوں نے خُدا کو دیکھا لیکن خُدا نے اُنہیں ہلاک نہیں کیا۔ تَب اُنہُوں نے کھایا اَور پیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","اَور یَاہوِہ نے مَوشہ سے کہا، ”پہاڑ پر میرے پاس آؤ اَور وہیں ٹھہرے رہو۔ میں تُمہیں پتّھر کی تختیاں دُوں گا جِن پر مَیں نے اُن کی تعلیم کے لیٔے آئین کے اَحکام لِکھ دئیے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","تَب مَوشہ اَپنے خادِم یہوشُعؔ کو لے کر روانہ ہُوئے اَور مَوشہ خُدا کے پہاڑ کے اُوپر چڑھ گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","اَور اُنہُوں نے اُن رہنماؤں سے کہا، ”جَب تک ہم لَوٹ کر تمہارے پاس واپس نہ آ جائیں تَب تک تُم ہمارا یہیں اِنتظار کرو۔ اَہرونؔ اَور حُورؔ تمہارے ساتھ ہیں اَور جِس کسی کا کویٔی مُقدّمہ ہو وہ اُن سے رُجُوع کرے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","جَب مَوشہ اُوپر پہُنچے تو پہاڑ پر گھٹا چھاگئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","اَور یَاہوِہ کا جلال کوہِ سِینؔائی پر آ ٹھہرا۔ اَور پہاڑ پر چھ دِن تک گھٹا چھائی رہی اَور ساتویں دِن یَاہوِہ نے اُس گھٹا میں سے مَوشہ کو پُکارا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","اَور بنی اِسرائیل کی نگاہ میں پہاڑ کی چوٹی پر یَاہوِہ کے جلال کا منظر بھسم کرنے والی آگ کی مانند تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","اَور مَوشہ اُس گھٹا میں داخل ہوکر اُوپر چڑھ گیٔے اَور چالیس دِن اَور چالیس رات پہاڑ ہی پر رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","اَور یَاہوِہ نے مَوشہ سے فرمایا: ");
INSERT INTO urdoucv_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","”بنی اِسرائیل سے کہو کہ میرے لیٔے نذر لائیں۔ اَورجو اِنسان دِل کی خُوشی سے نذر لایٔے تو اُسے میرے لیٔے قبُول کر لینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","”اَورجو نذریں تُم اُن سے لوگے وہ یہ ہیں: ”سونا، چاندی، کانسے؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","نیلا، اَرغوانی، سُرخ رنگ کا کپڑا، نفیس کتان؛ بکری کی پشم؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","اَور مینڈھوں کی سُرخ رنگی ہُوئی کھالیں اَور دریائی بچھڑوں کی کھالیں؛ اَور کیکر کی لکڑی؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","اَور چراغ کے لیٔے؛ زَیتُون کا تیل؛ مَسح کا تیل اَور خُوشبودار بخُور کے لیٔے مَسالے؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","افُود، سنگِ سُلیمانی اَور سینہ بند میں جڑنے کے لیٔے نگینے اَور دیگر جواہرات۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","”اَور پھر وہ میرے لیٔے ایک پاک مَقدِس بنائیں اَور مَیں اُن کے درمیان سکونت کروں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","اَور اُس مَسکن اَور اُس کے سارے سامان کا جو نمونہ میں تُمہیں دِکھاؤں ٹھیک اُسی کے مُطابق اُسے بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","”اَور وہ کیکر کی لکڑی کا ایک صندُوق بنائیں جِس کی لمبائی ڈھائی ہاتھ اَور چوڑائی ڈیڑھ ہاتھ اَور اُونچائی ڈیڑھ ہاتھ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","اَور اُس کے اَندر اَور باہر تُم خالص سونا منڈھنا اَور اُس کے اُوپر سجاوٹ کے لیٔے سونے کا بنا ہُوا کلس لگانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","اَور اُس کے لیٔے سونے کے چار کڑے ڈھال کر اُس کے چاروں پایوں میں لگانا، دو کڑے ایک طرف ہوں اَور دُوسری طرف بھی دو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","اَور پھر کیکر کی لکڑی کی بَلّیاں بنا کر اُن پر سونا منڈھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","اَور وہ بَلّیاں صندُوق کے اطراف کے کڑوں میں ڈالنا کہ اُن کے سہارے صندُوق کو اُٹھایا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","اَور وہ بَلّیاں اُس صندُوق کے کڑوں میں ہی رہیں۔ اُن کو الگ نہ کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","پھر تُم اُس شہادت نامہ کو جو میں تُمہیں دُوں گا اُس عہد کی تختیوں کو صندُوق میں رکھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","”اَور تُم کفّارہ کا سرپوش خالص سونے کا بنانا جو ڈھائی ہاتھ لمبا اَور ڈیڑھ ہاتھ چوڑا ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","اَور سرپوش کے دونوں کونوں پر سونے سے گڑھے ہویٔے دو کروبیم بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","اَور ایک کروب کو ایک سِرے پر اَور دُوسرے کروب کو دُوسرے پر لگانا اَور تُم دونوں سِروں کے کروبیم اَور سرپوش کو ایک ہی ٹکڑے سے بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","اَور کروبیم کے پر اُوپر کی طرف اِس طرح پھیلے ہویٔے ہُوں کہ وہ سرپوش کو ڈھانکے رہیں۔ اَور کروبیم کے چہرے ایک دُوسرے کے آمنے سامنے سرپوش کی طرف ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","اَور تُم اُس سرپوش کو اُس صندُوق کے اُوپر لگانا اَور وہ عہد کی تختیاں جو میں تُمہیں دُوں گا اُس صندُوق کے اَندر رکھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","وہاں عہد کے صندُوق پر سرپوش کے اُوپر دونوں کروبیم کے درمیان تُم سے مِلا کروں گا اَور بنی اِسرائیل کے لیٔے اَپنے تمام اَحکام تُمہیں دیا کروں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","”کیکر کی لکڑی کی ایک میز بنانا جو دو ہاتھ لمبی ایک ہاتھ چوڑی اَور ڈیڑھ ہاتھ اُونچی ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","اَور اُسے خالص سونے سے منڈھنا اَور اُس کے گِرد سونے کا ایک کلس بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","اَور اُس کے چَوگرد چار اُنگل چوڑی کنگنی لگانا اَور سونے کا ایک کلس اُس کنگنی پر رکھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","اَور اُس میز کے لیٔے سونے کے چار کڑے بنانا اَور اُنہیں اُس کے چاروں کونوں سے جہاں کہ اُس کے چاروں پایٔے ہیں جوڑ دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","اَور وہ کڑے اُس کنگنی کے نزدیک ہی ہُوں تاکہ وہ میز کو اُٹھانے کے لئے اِستعمال ہونے والی بَلّیوں کو تھامے رکھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","اَور وہ بَلّیاں کیکر کی لکڑی سے بنانا اَور اُنہیں سونے سے منڈھنا اَور میز کو اُن بَلّیوں کے سہارے ہی اُٹھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","اَور تُم اُس کے طباق اَور ڈونگے اَور صُراحیاں اَور نذریں اُنڈیلنے کے پیالے بھی خالص سونے کے بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","اَور تُم اُس میز پر نذر کی روٹی ہمیشہ میرے رُوبرو رکھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","”تُم خالص سونے کا ایک چراغدان بنانا۔ اُس کے پایٔے اَور ڈنڈی سَب گڑھ کر بنائے جایٔیں اَور اُس کے پیالے، کلیاں اَور پھُول سَب ایک ہی ٹکڑے کے بنے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","اَور اُس چراغدان کے دونوں طرف سے چھ شاخیں باہر کو نکلی ہُوں۔ تین ایک طرف اَور تین دُوسری طرف۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ایک شاخ پر بادام کے پھُول کی شکل کے تین پیالے، کلیاں اَور پھُول ہُوں اَور تین دُوسری شاخ پر۔ اَور اِسی طرح چراغدان سے باہر کو نکلی ہُوئی چھ شاخوں پر ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","اَور چراغدان کے اُوپر بادام کے پھُول کی شکل کے چار پیالے بنے ہویٔے ہُوں اَور اُن کے ساتھ کلیاں اَور پھُول بھی ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ایک کلی چراغدان سے باہر نکلی ہُوئی شاخوں کی پہلی جوڑی کے نیچے ہو۔ دُوسری کلی شاخوں کی دُوسری جوڑی کے نیچے اَور تیسری کلی تیسری جوڑی کے نیچے۔ یعنی ساری کلیاں چھ شاخوں کے نیچے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","وہ کلیاں اَور شاخیں اَور چراغدان ایک ہی ٹکڑے کے ہُوں اَور خالص سونے کے ٹکڑے سے گڑھ کر بنائے گیٔے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","”پھر تُم اُس کے لیٔے سات چراغ بنانا اَور اُنہیں اُس کے اُوپر رکھنا تاکہ وہ اُس کے سامنے کی جگہ کو رَوشن کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","اَور اُس کے گُلگیر اَور گلدان خالص سونے کے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","وہ چراغدان اَور اُس کے لوازمات ایک تالنت خالص سونے کے بنے ہویٔے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","اَور خیال رکھو کہ جو نمونہ تُمہیں پہاڑ پر دِکھایا گیا تھا اُسی کے مُطابق سَب چیزیں بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","”اَور تُم مَسکن کے لیٔے دس پردے بنانا جو نفیس بٹے ہویٔے کتان سے اَور نیلے آسمانی اَرغوانی اَور سُرخ رنگ کے دھاگوں سے بُنے ہُوں اَور جِن پر کسی ماہر کاریگر نے کشیدہ کاری سے کروبیم بنائے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","اَور وہ تمام پردے ایک ہی ناپ کے ہوں یعنی ہر ایک اٹّھائیس ہاتھ لمبا اَور چار ہاتھ چوڑا ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","اَور تُم پانچ پردوں کو باہم جوڑ دینا اَور باقی پانچ پردے بھی اِسی طرح جوڑے جایٔیں یعنی پانچ پانچ پردوں کے دو جوڑے بَن جایٔیں ");
INSERT INTO urdoucv_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","اَور ایک جوڑے کے آخِری پردہ کے کنارے کے ساتھ ساتھ نیلے آسمانی رنگ کے تُکمے بنانا۔ اَور دُوسرے جوڑے کے آخِری پردہ کے کنارے میں بھی اَیسے ہی تُکمے بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","پہلی جوڑی کے ایک پردہ پر پچاس تُکمے اَور دُوسری جوڑی کے آخِری پردہ پر بھی پچاس تُکمے ہوں گے۔ سَب تُکمے ایک دُوسرے کے آمنے سامنے ہوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","پھر سونے کی پچاس گھنڈیاں بنا کر اُنہیں اُن پردوں کے دونوں جوڑوں کو باہم مِلانے کے لیٔے اِستعمال کرنا تاکہ وہ ایک مَسکن بَن جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","”اَور اُس مَسکن کے اُوپر خیمہ مَسکن کے اُوپر کے خیمہ کے لیٔے بکری کی پشم سے پردے بنانا جِن کی تعداد گیارہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","اَور وہ گیارہ پردے ایک ہی ناپ کے ہُوں یعنی ہر پردہ تیس ہاتھ لمبا اَور چار ہاتھ چوڑا ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","اَور اُن پردوں میں سے پانچ کو باہم جوڑ کر ایک جوڑا بنانا اَور باقی چھ کو جوڑ کر دُوسرا جوڑا بنانا۔ اَور چھٹے پردہ کو خیمہ کے سامنے موڑکر دہرا کردینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","اَور ایک جوڑے کے آخِری پردہ کے کنارے کے ساتھ ساتھ پچاس تُکمے بنانا اَور دُوسرے جوڑے کے آخِری پردہ کے کنارے کے ساتھ ساتھ بھی پچاس تُکمے بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","پھر کانسے کی پچاس گھنڈیاں بنانا اَور اُس خیمہ کو باہم جوڑنے کے لیٔے اُن گھنڈیوں کو اُن تکموں میں ڈال دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","اَور مَسکن کے پردوں کو مزید پھیلانے کے لیٔے بچا ہُوا آدھا پردہ خیمہ کی پچھلی طرف لٹکا رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","اَور اُس خیمہ کے پردے دونوں اطراف ایک ایک ہاتھ زِیادہ لمبے ہُوں تاکہ مَسکن کو دونوں طرف سے ڈھانکنے کے لیٔے اِدھر اَور اُدھر لٹکے رہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","اَور اُس خیمہ کے اُوپر ڈالنے کے لیٔے ایک غلاف مینڈھوں کی سُرخ رنگی ہُوئی کھالوں کا بنانا اَور اُس کے اُوپر دریائی بچھڑوں کی کھالوں کا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","”اَور تُم مَسکن کے لیٔے کیکر کی لکڑی کے چوکھٹے بنانا جو کھڑے کئے جا سکیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ہر چوکھٹا دس ہاتھ لمبا اَور ڈیڑھ ہاتھ چوڑا ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","اُن کی دو دو چُولیں ہُوں جو ایک دُوسرے کے متوازی ہُوں۔ مَسکن کے تمام چوکھٹے اِسی طرح بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","مَسکن کے جُنوبی پہلو کے لیٔے بیس چوکھٹے بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","اَور اُن کے لیٔے چاندی کے چالیس پایٔے بنانا یعنی ہر چوکھٹے کے لیٔے دو دو پایٔے جو دونوں چُولوں کے نیچے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","دُوسری جانِب یعنی مَسکن کے شمالی پہلو میں بیس چوکھٹے بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","اَور چاندی کے چالیس پایٔے بنانا تاکہ ہر ایک چوکھٹے کے نیچے دو دو پایٔے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","اَور آخِری کونے پر یعنی مَسکن کی مغربی سمت میں چھ چوکھٹے بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","اَور اُسی طرف کونوں کے لیٔے دو چوکھٹے بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","اِن دونوں کونوں پر وہ نیچے سے لے کر اُوپر تک دوہرے ہُوں اَور ایک ہی حلقے میں برابر جُڑے ہُوں اَور دونوں ایک سے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","یُوں آٹھ چوکھٹے اَور چاندی کے سولہ پایٔے ہوں گے۔ یعنی ہر ایک چوکھٹے کے نیچے دو دو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","”اَور کیکر کی لکڑی سے بینڈے بھی بنانا۔ پانچ اُن چوکھٹوں کے لیٔے جو مَسکن کے ایک طرف ہوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","پانچ اُن چوکھٹوں کے لیٔے جو دُوسری طرف ہیں اَور پانچ مغربی سمت والے چوکھٹوں کے لیٔے جو مَسکن کے کونے پر ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","اَور وسطیٰ بینڈے کو اَیسا بنانا کہ وہ اُن چوکھٹوں کے درمیان سے ہوکر ایک سِرے سے دُوسرے سِرے تک پہُنچے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","اَور اُن چوکھٹوں پر سونا منڈھنا اَور اُن بینڈوں کو تھامنے کے لیٔے سونے کے حلقے بنانا۔ اَور اُن بینڈوں کو بھی سونے سے منڈھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","”اَور تُم مَسکن کو اُسی نمونہ کے مُطابق بنانا جو تُمہیں پہاڑ پر دِکھایا گیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","”اَور تُم نیلے اَرغوانی اَور سُرخ دھاگے اَور نفیس بٹے ہویٔے کتان سے ایک پردہ بنانا جِس پر کسی ماہر کاریگر نے کشیدہ کاری سے کروبیم بنائے ہوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","اَور اُسے سونے سے منڈھے ہویٔے کیکر کی لکڑی کے چار سُتونوں پرجو چاندی کے چار پایوں پر کھڑے ہُوں سونے کے حلقوں سے لٹکانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","اَور اُس پردہ کو چھلّوں سے نیچے لٹکانا اَور عہد کے صندُوق کے صندُوق کو اُس پردہ کے پیچھے رکھنا اَور وہ پردہ پاک مقام کو پاک ترین مقام سے الگ کرےگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","اَور تُم کفّارہ کے سرپوش کو پاک ترین مقام میں عہد کے صندُوق کے صندُوق کے اُوپر رکھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","اَور میز کو پردہ کے باہر مَسکن کی شمالی سمت میں رکھنا اَور چراغدان کو اُس کے سامنے جُنوبی سمت میں رکھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","”اَور اُس خیمہ میں دروازہ کے لیٔے تُم نیلے، اَرغوانی اَور سُرخ دھاگے اَور نفیس بٹے ہُوئے کتان سے ایک پردہ بنانا جِس پر کشیدہ کاری کی گئی ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","اِس پردہ کے لیٔے سونے کے حلقے اَور کیکر کی لکڑی کے پانچ سُتون بنانا جِن پر سونا منڈھا ہُوا ہو اَور اُن کے لیٔے کانسے کے پانچ پایٔے ڈھال کر بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","”اَور تُم کیکر کی لکڑی کا ایک مذبح بنانا جو تین ہاتھ اُونچا ہو اَور پانچ ہاتھ لمبا اَور پانچ ہاتھ چوڑا ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","اَور تُم اُس کے چاروں کونوں میں سے ہر ایک پر ایک ایک سینگ بنانا اَور وہ سینگ اَور وہ مذبح ایک ہی ٹکڑے کے ہُوں اَور اُس مذبح کو کانسے سے منڈھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","اَور اُس کے تمام ظروف کانسے کے بنانا یعنی راکھ اُٹھانے کے لیٔے راکھدان، بیلچے، چھڑکاؤ کرنے والے پیالے، گوشت کے لیٔے سیخیں اَور انگیٹھیاں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","تُم اُس کے لیٔے کانسے کی ایک جالی دار جنگلہ بنانا اَور اُس جالی کے چاروں کونوں پر کانسے کا ایک ایک کڑا بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","اَور اُسے مذبح کی کگر کے نیچے رکھنا تاکہ یہ مذبح کی آدھی اُونچائی تک پہُنچ سکے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","اَور تُم مذبح کے لیٔے کیکر کی لکڑی کی بَلّیاں بنا کر اُنہیں کانسے سے منڈھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","اَور اُن بَلّیوں کو اُن کڑوں میں ڈالنا۔ تاکہ جَب مذبح کو اُٹھایا جائے تو وہ بَلّیاں اُس کے دونوں طرف ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","اَور تُم اُس مذبح کو تختوں سے بنانا اَور وہ کھوکھلی ہو اَور تُم اُسے وَیسی ہی بنانا جَیسی تُمہیں پہاڑ پر دِکھائی گئی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","”اَور تُم مَسکن کے لیٔے ایک صحن بنانا جِس کی جُنوبی سمت ایک سَو ہاتھ لمبی ہو۔ اَور اُس کے لیٔے نفیس بٹے ہویٔے کتان کے پردے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","اَور جِن کے لیٔے بیس سُتون اَور کانسے کے بیس پایٔے اَور سُتونوں کے لیٔے چاندی کی کنڈیاں اَور پٹّیاں ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","اَور شمالی سمت بھی ایک سَو ہاتھ لمبی اَور اُس کے لیٔے بھی پردے ہُوں اَور پردوں کے لیٔے بیس سُتون اَور کانسے کے بیس پایٔے ہُوں اَور سُتونوں کے لیٔے چاندی کی کنڈیاں اَور پٹّیاں ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","”وہ صحن مغرب کی طرف سے پچاس ہاتھ چوڑا ہو اَور اُس کے لیٔے پردے ہُوں اَور دس سُتون اَور دس ہی پایٔے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","اَور مشرقی کنارا طُلوع آفتاب کی طرف بھی صحن پچاس ہاتھ چوڑا ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","اَور پندرہ ہاتھ لمبے پردے دروازہ کے ایک پہلو کے لیٔے ہُوں اَور اُن پردوں کے لیٔے تین سُتون اَور تین ہی پایٔے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","اَور دُوسری طرف کے لیٔے بھی پندرہ ہاتھ لمبے پردے تین سُتون اَور تین پایٔے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","”اَور صحن کے دروازہ کے لیٔے بیس ہاتھ لمبا پردہ بنانا جو نیلے، اَرغوانی اَور سُرخ دھاگے اَور نفیس بٹے ہویٔے کتان کا ہو جِس پر کشیدہ کاری کی گئی ہو۔ اَور اُس کے لیٔے چار سُتون اَور چار پایٔے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","اَور صحن کے اِردگرد تمام سُتونوں کے لیٔے ڈوریاں اَور کنڈیاں چاندی کی اَور پایٔے کانسے کے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","اَور وہ صحن ایک سَو ہاتھ لمبا اَور پچاس ہاتھ چوڑا ہو، اَور نفیس بٹے ہویٔے کتان کے پردے اُوپر سے نیچے تک پانچ ہاتھ لمبے ہُوں اَور سُتونوں کے پایٔے کانسے کے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","اَور مَسکن میں پرستش کے لیٔے اِستعمال میں لائی جانے والی دیگر تمام اَشیا خواہ وہ کسی کام کے لیٔے ہُوں مَسکن کے خیمہ کی میخیں اَور صحن کے لیٔے میخیں کانسے کی ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","”اَور تُم بنی اِسرائیل کو حُکم دینا کہ وہ تمہارے پاس کولہو کے ذریعہ نکالا ہُوا زَیتُون کا خالص تیل رَوشنی کے لیٔے لائیں تاکہ چراغ ہمیشہ جلتے رہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","اَور خیمہ اِجتماع میں اُس پردہ کے باہر جو عہد کے صندُوق کے سامنے ہوگا اَہرونؔ اَور اُس کے بیٹے چراغوں کو یَاہوِہ کے سامنے شام سے صُبح تک جَلائے رکھیں۔ یہ دستُور بنی اِسرائیل میں پُشت در پُشت دائمی فرمان سمجھ کر قائِم رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","”اَور تُم بنی اِسرائیل میں سے اَپنے بھایٔی اَہرونؔ کو اَور اُس کے بیٹوں نادابؔ، اَبِیہُو، الیعزرؔ اَور اِتمارؔ کو اَپنے پاس رکھنا تاکہ وہ میری بطور کاہِنؔ خدمت کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","اَور تُم اَپنے بھایٔی اَہرونؔ کی عزّت اَور زینت کی خاطِر اُسے مُقدّس لباس بنا کردینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","اَور تُم اُن تمام ماہر کاریگروں کو جنہیں مَیں نے اَیسے کاموں کے لیٔے عقل بخشی ہے کہنا کہ وہ اَہرونؔ کے لیٔے لباس بنائیں تاکہ وہ میری بطور کاہِنؔ خدمت کے لیٔے مخصُوص ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","اَورجو لباس اُنہیں بنانے ہیں وہ یہ ہیں: سینہ بند، افُود، جُبّہ، چار خانے کا کرتہ، عمامہ اَور کمرکاپٹکہ۔ وہ تمہارے بھایٔی اَہرونؔ اَور اُن کے بیٹوں کے لیٔے یہ مُقدّس لباس بنائیں تاکہ وہ میری بطور کاہِنؔ خدمت کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","اَور دیکھنا کہ وہ سونا اَور نیلے، اَرغوانی اَور قِرمزی رنگ کا کپڑا اَور نفیس کتان اِستعمال کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","”اَور وہ افُود سونے اَور نیلے، اَرغوانی اَور قِرمزی رنگ کے کپڑے اَور نفیس بٹے ہویٔے کتان کا بنائیں اَور وہ کسی ماہر کاریگر کے ہاتھ کا کام ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","اَور اُس کے کندھوں پر ڈالنے والی پٹّیاں اُس کے دونوں کونوں سے مِلا کرجوڑ دینا تاکہ اُسے باندھا جا سکے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","اَور اُس کا کمربند جو مہارت سے بُنا گیا ہو اِس طرح کا ہو: وہ اُسی کپڑے کا ٹکڑا ہو جِس کا افُود ہو اَور سونے اَور نیلے اَرغوانی اَور قِرمزی رنگ کے کپڑے اَور نفیس بٹے ہُوئے کتان کا ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","”اَور تُم دو سنگِ سُلیمانی لے کر اُن پر اِسرائیل کے بیٹوں کے نام کندہ کرنا ");
INSERT INTO urdoucv_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","اَور اُن کی پیدائش کی ترتیب کے مُطابق چھ نام ایک پتّھر پر اَور باقی چھ دُوسرے پتّھر پر ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","اَور جِس طرح ایک گوہر تراش کسی انگُشتری پر نقش کندہ کرتا ہے اُسی طرح تُم اُن دونوں پتّھروں پر اِسرائیل کے بیٹوں کے نام کندہ کرنا اَور پھر اُن پتّھروں کو کھدوا کر سونے کے چوکھٹوں میں جڑنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","اَور اُنہیں افُود کے کندھے والی پٹّیوں پر لگانا تاکہ یہ پتّھر اِسرائیل کے بیٹوں کی یادگاری کے لیٔے ہُوں اَور اَہرونؔ اُن کے نام یَاہوِہ کے رُوبرو اَپنے دونوں کندھوں پر یادگاری کے لیٔے لگائے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","اَور تُم طِلا کاری کئے ہویٔے سونے کے چوکھٹے بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","اَور خالص سونے کی ڈوری کی طرح بٹی ہُوئی دو زنجیروں کوبنانا اَور اُن زنجیروں کو اُن چوکھٹوں میں جڑ دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","”اَور فیصلے کرنے کے وقت اِستعمال کرنے کا سینہ بند کسی ماہر کاریگر سے بنوانا اَور اُسے بھی افُود کی طرح سونے اَور نیلے آسمانی، اَرغوانی اَور قِرمزی کپڑے اَور نفیس بٹے ہویٔے کتان کا بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","اَور یہ چوکور ہُوں یعنی ایک بالشت لمبا اَور ایک بالشت چوڑا ہو اَور دہرا تہہ کیا ہُوا ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","پھر اُس میں قیمتی جواہر چار قطاروں میں جڑنا۔ پہلی قطار میں یاقُوت سُرخ، یَشب سبز اَور فیروزہ ہو؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","دُوسری قطار میں نیلا فیروزہ، نیلم اَور ہیرا، ");
INSERT INTO urdoucv_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","تیسری قطار میں لشم، یَشب اَور زُمُرّد، ");
INSERT INTO urdoucv_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","چوتھی قطار میں پکھراج، سنگِ سُلیمانی اَور سنگِ یَشب۔ اِنہیں نقش کندہ کئے ہویٔے سونے کے خانوں میں جڑنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","یہ پتّھر تعداد میں اِسرائیل کے ہر ایک بیٹوں کے ناموں کے مُطابق بَارہ ہُوں جِن پر ایک انگُشتری کے نقش کی طرح ہر ایک پر بَارہ قبیلوں کے نام کندہ کئے جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","”اَور تُم سینہ بند کے لیٔے ڈوری کی طرح بٹی ہُوئی خالص سونے کی دو زنجیریں بنانا ");
INSERT INTO urdoucv_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","اَور تُم سونے کے دو کڑے بنا کر اُن کڑوں کو سینہ بند کے دونوں کونوں سے باندھ دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","اَور سونے کی اُن دونوں زنجیروں کو سینہ بند کے دونوں کونوں پر لگے دونوں کڑوں کے ساتھ باندھ دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","اَور اُن زنجیروں کے دونوں سِروں کو اُن دونوں چوکھٹوں کے ساتھ باندھ کر افُود کے دونوں کندھوں والی پٹّیوں سے جوڑ کر سامنے لٹکا دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","اَور تُم سونے کے دو اَور کڑے بنا کر اُنہیں سینہ بند کے نیچے کے دونوں کونوں کو اُس حاشیہ میں لگانا جو افُود کے اَندر کی طرف ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","اَور تُم سونے کے دو اَور کڑے بنا کر اُنہیں کندھے کی پٹّیوں کے نِچلے حِصّہ سے باندھنا جو کہ افُود کے سامنے ہے تاکہ وہ افُود کے کمربند کے بالکُل اُوپر رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","اَور سینہ بند کے کڑوں کو افُود کے اُن کڑوں کے ساتھ جو اُسے کمربند سے جوڑتے ہیں نیلے رنگ کی ڈوری سے باندھے جایٔیں تاکہ سینہ بند افُود سے اِدھر اُدھر کھسکنے نہ پایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","”اَور جَب بھی اَہرونؔ پاک مقام میں داخل ہوکر یَاہوِہ کے حُضُور میں جائے تو وہ فیصلے کرنے کے وقت اِستعمال کرنے کے سینہ بند کو جِس پر اِسرائیل کے بیٹوں کے نام ہیں اَپنے سینہ پر لگائے رکھے تاکہ ہمیشہ اُن کی یادگاری ہُوا کرے ");
INSERT INTO urdoucv_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","اَور تُم سینہ بند میں اُوریمؔ اَور تُمّیمؔ کو بھی رکھنا تاکہ جَب بھی اَہرونؔ یَاہوِہ کی حُضُوری میں جائے تو یہ اُس کے دِل کے اُوپر رہیں۔ یُوں بنی اِسرائیل کے لیٔے فیصلے کرنے کے وسائل ہمیشہ یَاہوِہ کے آگے اَہرونؔ کے دِل پر رہیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","”اَور تُم افُود کا جُبّہ بالکُل نیلے رنگ کے کپڑے کا بنانا، ");
INSERT INTO urdoucv_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","اَور اُس کا گریبان بیچ میں ہو اَور زرہ کے گریبان کی طرح اُس کے گریبان کے اطراف بُنی ہُوئی گوٹ لگی ہُوئی ہو تاکہ وہ پھٹنے نہ پائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","اَور تُم جُبّہ کے دامن کے گھیر میں چاروں طرف نیلے، اَرغوانی اَور قِرمزی دھاگے سے انار کڑھوانا جِن کے درمیان سونے کی گھنٹیاں ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","یعنی پہلے سونے کی ایک گھنٹی ہو اَور پھر ایک انار اَور آخِر تک یہی ترتیب جاری رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","اَور اَہرونؔ خدمت کرتے وقت یہ جُبّہ ضروُر پہنا کرے اَور جَب وہ اُس پاک مقام کے اَندر یَاہوِہ کے حُضُور جائے اَور جَب وہاں سے باہر آئے تو اُن گھنٹیوں کی آواز سُنایٔی دے کہیں اَیسا نہ ہو کہ وہ مرجائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","”اَور تُم خالص سونے کی ایک تختی بنا کر اُس پر انگُشتری کے نقش کی طرح یہ کندہ کرنا: یَاہوِہ کے لیٔے مُقدّس۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","اَور اُسے ایک نیلے رنگ کی ڈوری کے ذریعہ عمامہ پر اِس طرح باندھنا کہ وہ عمامہ کے سامنے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","یہ تختی اَہرونؔ کی پیشانی پر ہوگی اَور وہ اُن گُناہوں کو اَپنے اُوپر لے گا جِن کے لیٔے بنی اِسرائیل اَپنے پاک نذرانوں کو مخصُوص کریں گے خواہ وہ نذرانے کچھ بھی ہُوں۔ یہ تختی ہمیشہ اَہرونؔ کی پیشانی پر رہے تاکہ وہ یَاہوِہ کے حُضُور میں مقبُول ٹھہریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","”اَور تُم جُبّہ کو نفیس کتان سے بُننا اَور عمامہ بھی مہین کتان کا بنانا اَور کمر کے پٹکے پر کشیدہ کاری کی جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","اَور تُم اَہرونؔ کے بیٹوں کی عزّت اَور زینت کی خاطِر اُن کے لیٔے جُبّے، کمر کے پٹکے اَور عمامے بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","اَور تُم یہ کپڑے اَپنے بھایٔی اَہرونؔ اَور اُس کے بیٹوں کو پہنانا اَور اُنہیں مَسح کرنا اَور مخصُوص کرنا اَور اُن کی تقدیس کرنا تاکہ وہ میرے لیٔے بطور کاہِنؔ خدمت اَنجام دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","”اَور تُم اُن کے لیٔے کتان کے پاجَامے بنانا جو کمر سے لے کر رانوں تک لمبے ہُوں تاکہ اُن کا بَدن ڈھکا رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","اَہرونؔ اَور اُس کے بیٹے جَب بھی خیمہ اِجتماع میں داخل ہُوں یا پاک مقام کے اَندر خدمت کرنے کے لیٔے مذبح کے قریب جایٔیں تو اُن زیرِ جاموں کو ضروُر پہنیں کہیں اَیسا نہ ہو کہ وہ گُنہگار ٹھہریں اَور مَر جایٔیں۔ ”اَہرونؔ اَور اُس کی نَسل کے لیٔے ہمیشہ یہی دستور دائمی فرمان رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","”اَور اُنہیں پاک کرنے کے لیٔے تاکہ وہ بطور کاہِنؔ میری خدمت اَنجام دیں تُم یُوں کرنا کہ ایک بچھڑا اَور دو بے عیب مینڈھے لینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","اَور تُم نفیس گندُم کے آٹے کی بے خمیری روٹیاں اَور زَیتُون کے تیل سے بنے کُلچے اَور تیل سے چُپڑی ہُوئی بے خمیری ٹکیئے بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","اَور اُنہیں ایک ٹوکری میں رکھ کر اُنہیں بچھڑوں اَور مینڈھوں دونوں کے ہمراہ نذر کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","پھر اَہرونؔ اَور اُس کے بیٹوں کو خیمہ اِجتماع کے دروازہ پر لاکر اُن کو پانی سے نہلانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","اَور پھر وہ لباس لے کر اَہرونؔ کو کرتا، اَور افُود کا جُبّہ اَور افُود اَور سینہ بند پہنانا۔ اَور اُس پر افُود کو نفاست سے بنے ہویٔے کمربند سے باندھ دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","اَور اُس کے سَر پر عمامہ رکھنا اَور مُقدّس تاج اُس عمامہ پر لگادینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","اَور مَسح کا تیل اُس کے سَر پر ڈالنا اَور اُسے مَسح کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","اَور پھر اُس کے بیٹوں کو لانا اَور اُن کو چوغے پہنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","اَور اُن کے سَروں پر عمامے رکھنا۔ اَور پھر اَہرونؔ اَور اُس کے بیٹوں کو کمرکاپٹکہ باندھنا اَور دستور کی رو سے کہانت ہمیشہ تک اُن کی ہے۔ ”اِس طرح تُم اَہرونؔ اَور اُن کے بیٹوں کو بطور کاہِنؔ مخصُوص کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","”اَور تُم اُس بچھڑے کو خیمہ اِجتماع کے سامنے لانا اَور اَہرونؔ اَور اُس کے بیٹے اَپنے ہاتھ اُس کے سَر پر رکھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","اَور پھر اُس بچھڑے کو یَاہوِہ کی حُضُوری میں خیمہ اِجتماع کے دروازہ پر ذبح کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","اَور اُس بچھڑے کے خُون میں سے کچھ لے کر اُسے اَپنی اُنگلی سے مذبح کے سینگوں پر لگانا اَور باقی سارا خُون مذبح کے پایٔے پر اُنڈیل دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","اَور پھر تمام آنتوں کے اِردگرد کی چربی، جِگر کے اُوپر کی جھِلّی اَور دونوں گُردے اَور اُن کے اُوپر کی چربی لے کر مذبح پر جَلانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","لیکن بچھڑے کے گوشت، اُس کی کھال اَور اُس کے گوشت اَور گوبر سمیت چھاؤنی سے باہر آگ میں جَلا دینا۔ یہ گُناہ کی قُربانی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","”پھر مینڈھوں میں سے ایک کو لینا اَور اَہرونؔ اَور اُن کے بیٹے اُس کے سَر پر اَپنے ہاتھ رکھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","اَور تُم اُس مینڈھے کو ذبح کرنا اَور اُس کے خُون کو لے کر مذبح پر چاروں طرف چھڑکنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","اَور پھر تُم اُس مینڈھے کے ٹکڑے ٹکڑے کرنا اَور اُس کی آنتوں اَور پایوں کو دھوکر اُس کے سَر اَور دیگر ٹُکڑوں کے ساتھ رکھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","اَور پھر اُس پُورے مینڈھے کو مذبح پر جَلانا۔ یہ یَاہوِہ کے لیٔے سوختنی نذر ہے ایک فرحت بخش خُوشبو یعنی یَاہوِہ کے لیٔے غِذا کی آتِشی نذر کی قُربانی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","”اَور پھر دُوسرے مینڈھے کو لینا اَور اَہرونؔ اَور اُن کے بیٹے اُس کے سَر پر اَپنے ہاتھ رکھیں ");
INSERT INTO urdoucv_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","اَور تُم اُس مینڈھے کو ذبح کرنا اَور اُس کے خُون میں سے کچھ لے کر اَہرونؔ اَور اُن کے بیٹوں کے داہنے کان کی لو پر، داہنے ہاتھ اَور داہنے پاؤں کے انگُوٹھوں پر لگانا اَور خُون کو مذبح پر چاروں طرف چھڑک دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","اَور مذبح کے خُون اَور مَسح کرنے والے زَیتُون کے تیل میں سے تھوڑا تھوڑا اَہرونؔ اَور اُس کے لباس پر اَور اُس کے بیٹوں پر اَور اُن کے لباسوں پر چھڑکنا۔ تَب وہ اَور اُس کے بیٹے اَپنے اَپنے لباس سمیت مُقدّس ٹھہریں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","”اَور تُم مینڈھے کی چربی اُس کی دُم کی چربی اَور آنتوں کے اِردگرد کی چربی، جِگر کے اُوپر کی جھِلّی اَور دونوں گُردوں اَور اُن کے اُوپر کی چربی اَور داہنی ران کو لینا کیونکہ یہ تخصیص کا مینڈھا ہے ");
INSERT INTO urdoucv_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","اَور بے خمیری روٹی کی ٹوکری میں سے جو یَاہوِہ کے آگے ہوگی ایک روٹی، تیل سے بنا ہُوا ایک کُلچہ اَور زَیتُون کے تیل سے چُپڑی ہُوئی ایک ٹکیا لینا ");
INSERT INTO urdoucv_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","اَور مَوشہ نے اِن سَب کو اَہرونؔ اَور اُن کے بیٹوں کے ہاتھوں پر رکھ کر اُن کو ہلانے کی نذر کی قُربانی کے طور پر یَاہوِہ کے حُضُور ہلانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","پھر اُنہیں اُن کے ہاتھوں سے لے کر سوختنی نذر کے ساتھ مذبح پر جَلا دینا تاکہ وہ یَاہوِہ کے لیٔے فرحت بخش خُوشبو ہو۔ یہ یَاہوِہ کے لیٔے بطور غِذا کی آتِشی نذر ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","اَور پھر اَہرونؔ کی تخصیص کے لیٔے تخصیصی مینڈھے کا سینہ لے کر اُسے یَاہوِہ کے حُضُور ہلانے کی نذر کی قُربانی کے طور پر ہلانا اَور یہ تمہارا حِصّہ ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","”اَور تُم اَہرونؔ اَور اُن کے بیٹے کے تخصیصی مینڈھے کے ہلانے کی نذر کی قُربانی کے طور پر اُن حِصّوں کو یعنی اُس کے سینہ کو جو ہلایا گیا تھا اَور اُس ران کو جو چڑھائی گئی تھی پاک ٹھہرانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","اَور یہ بنی اِسرائیل کی طرف سے دائمی حِصّہ کے طور پر اَہرونؔ اَور اُس کے بیٹوں کا حق ہوگا۔ یہ وہ نذر ہے جو بنی اِسرائیل کی طرف سے اُن کی سلامتی کی نذر کی قُربانی میں سے یَاہوِہ کے لیٔے گزرانی جائے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","”اَور اَہرونؔ کے پاک لباس اُس کی اَولاد کے لیٔے ہوں گے تاکہ وہ اُن ہی میں مَسح اَور تخصیص کئے جا سکیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","اَور اُس کا وہ بیٹا جو بطور کاہِنؔ اُس کا جانشین ہو وہ جَب پاک مقام میں خدمت کرنے کے لیٔے خیمہ اِجتماع میں آئے تو وہ اُنہیں سات دِن پہنے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","”اَور تُم تخصیصی مینڈھے کے گوشت کو لے کر کسی پاک جگہ میں اُبالنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","اَور اَہرونؔ اَور اُس کے بیٹے مینڈھے کا گوشت اَور ٹوکری کی روٹیاں خیمہ اِجتماع کے دروازہ پر کھایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","جِن ہدیوں سے اُنہیں تخصیص اَور پاک کرنے کے لیٔے کفّارہ دیا گیا اُنہیں بھی وُہی کھایٔیں۔ اُنہیں دُوسرا کویٔی بھی نہ کھائے کیونکہ وہ پاک ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","اَور اگر تخصیصی مینڈھے کے گوشت یا روٹی میں سے کچھ صُبح تک باقی رہ جائے تو اُسے جَلا دینا۔ وہ ہرگز نہ کھایا جائے، اِس لیٔے کہ وہ پاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","”اَور تُم اَہرونؔ اَور اُس کے بیٹوں کے لیٔے وہ سَب کرنا جِس کا مَیں نے تُمہیں حُکم دیا ہے۔ اَور سات دِن تک اُن کی تخصیص کرتے رہنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","اَور گُناہ کی قُربانی کے طور پر کفّارہ دینے کے لیٔے ہر روز ایک بچھڑے کو ذبح کرنا اَور اُس کے لیٔے کفّارہ دیتے وقت مذبح کو صَاف کرنا اَور اُسے مَسح کرنا تاکہ وہ پاک ہو جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","اَور سات دِن تک مذبح کے لیٔے کفّارہ دے کر اُسے پاک کرنا۔ تَب وہ مذبح پاک ترین ہو جائے گا اَورجو کچھ اُس کے ساتھ چھُو جائے گا وہ بھی پاک ٹھہرے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","”اَور ہر روز مُتواتر جو کچھ تُمہیں مذبح پر گزراننا ہوگا یہ ہے: ایک ایک سال کے دو برّے، ");
INSERT INTO urdoucv_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ایک برّہ صُبح کو گزراننا اَور دُوسرا شام کو جھٹپٹے کے وقت ");
INSERT INTO urdoucv_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","پہلے برّہ کے ساتھ ایفہ کے دسویں حِصّہ کے برابر مَیدہ دینا جِس میں ہین کا چوتھا حِصّہ کولھو کے زَیتُون کا تیل مِلا ہو۔ اَور ہین کے چوتھے حِصّہ کے برابر انگوری شِیرہ بھی بطور انگوری شِیرہ کی نذر گزراننا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","اَور تُم شام کے جھٹپٹے کے وقت بھی مَیدہ کی اَور اناج کی نذر اَور ساتھ ہی انگوری شِیرے کی نذر کے ساتھ دُوسرے برّہ کی قُربانی گزراننا جَیسی صُبح کے لیٔے مُقرّر ہے تاکہ وہ یَاہوِہ کے لیٔے ایک فرحت بخش خُوشبو اَور غِذا کی آتِشی نذر ٹھہرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","”یہ سوختنی نذر خیمہ اِجتماع کے دروازہ پر یَاہوِہ کے آگے مسلسل نَسل در نَسل ہوتی رہے۔ وہاں میں تُم سے ملوں گا اَور باتیں کروں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","اَور وہیں میں بنی اِسرائیل سے بھی مُلاقات کروں گا اَور وہ مقام میرے جلال سے مُقدّس ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","”میں خیمہ اِجتماع کو اَور مذبح کو مُقدّس کروں گا اَور مَیں اَہرونؔ اَور اُس کے بیٹوں کو مُقدّس کروں گا تاکہ وہ بطور کاہِنؔ میرے لیٔے خدمت اَنجام دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","پھر میں اِسرائیلیوں کے درمیان سکونت کروں گا اَور اُن کا خُدا ہُوں گا ");
INSERT INTO urdoucv_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","اَور وہ جان لیں گے کہ مَیں یَاہوِہ اُن کا خُدا ہُوں جو اُن کو مِصر سے نکال کر لایا تاکہ میں اُن کے درمیان سکونت کروں، میں ہی یَاہوِہ اُن کا خُدا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","”اَور تُم بخُور جَلانے کے لیٔے کیکر کی لکڑی کا ایک مذبح بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","اَور وہ چوکور ہو یعنی ایک ہاتھ لمبا اَور ایک ہاتھ چوڑا اَور دو ہاتھ اُونچا ہو اَور اُس کے سینگ ایک ہی ٹکڑے سے بنائے جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","اَور تُم اُس کی اُوپر کی سطح اَور تمام اطراف اَور اُس کے سینگوں کو خالص سونے سے منڈھنا اَور اُس کے اِردگرد سونے کا ایک کلس بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","اَور تُم اُس کلس کے نیچے اُس کے دونوں پہلوؤں میں مذبح کے لیٔے سونے کے دو حلقے بنانا جو اُسے اُٹھانے کی بَلّیوں کو تھامے رکھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","اَور تُم وہ بَلّیاں کیکر کی لکڑی سے بنانا اَور اُنہیں سونے سے منڈھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","اَور تُم مذبح کو اُس پردہ کے آگے رکھنا جو عہد کے صندُوق کے صندُوق کے سامنے ہے یعنی کفّارہ کے سرپوش کے سامنے جو شہادت کے صندُوق کے اُوپر ہے جہاں میں تُمہیں مِلا کروں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","”اَور ہر صُبح جَب اَہرونؔ چراغوں کو ٹھیک کرے تو مذبح پر خُوشبو اَور بخُور ضروُر جَلایا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","اَور اَہرونؔ جَب شام کے جھٹپٹے میں چراغوں کو رَوشن کرے تَب بھی بخُور جَلائے۔ یہ بخُور یَاہوِہ کے آگے نَسل در نَسل مُتواتر جَلایا جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","اِس مذبح پر کویٔی اَور بخُور یا کویٔی سوختنی نذر یا اناج کی نذر نہ کویٔی انگوری شِیرے کی نذر گزرانا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","اَور سال میں ایک بار اَہرونؔ اُس کے سینگوں پر کفّارہ دیا کرے۔ یہ سالانہ کفّارہ گُناہ کی قُربانی کے خُون سے نَسل در نَسل دیا جائے۔ یہ یَاہوِہ کے لیٔے سَب سے زِیادہ پاک ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","پھر یَاہوِہ نے مَوشہ سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","”تُم بنی اِسرائیل کی تعداد مَعلُوم کرنے کے لیٔے اُن کی مردُم شماری کرو تو ہر ایک جَب وہ شُمار کیا جائے یَاہوِہ کو اَپنی جان کا فدیہ اَدا کرے۔ تَب مردُم شماری کے وقت اُن پر کویٔی وَبا نازل نہ ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ہر اِنسان جِس کی گِنتی ہو چُکے وہ پاک مَقدِس کے ثاقل کے حِساب سے نیم ثاقل دے۔ یہ نیم ثاقل یَاہوِہ کے لیٔے نذر ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","بیس بَرس یا اُس سے زِیادہ عمر کے وہ سَب جِن کی گِنتی ہو جائے یَاہوِہ کو نذر دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","اَور جَب تُم اَپنی جانوں کے کفّارہ کے لیٔے یَاہوِہ کو نذر دو تو دولتمند نیم ثاقل سے زِیادہ اَور غریب اُس سے کم نہ دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","اَور تُم بنی اِسرائیل سے کفّارہ کی نقدی لے کر اُسے خیمہ اِجتماع کے کاموں کے لیٔے خرچ کرنا۔ یہ یَاہوِہ کے حُضُور میں تمہاری جانوں کا کفّارہ اَور بنی اِسرائیل کے لیٔے ایک یادگار ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","پھر یَاہوِہ نے مَوشہ سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","”طہارت کے لیٔے کانسے کا ایک لگن بنانا لگن کی چوکی بھی کانسے کی ہو، اَور اُسے خیمہ اِجتماع کے دروازہ اَور مذبح کے درمیان رکھ کر اُس میں پانی بھر دینا ");
INSERT INTO urdoucv_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","تاکہ اَہرونؔ اَور اُس کے بیٹے اُس کے پانی سے اَپنے ہاتھ پاؤں دھویا کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","جَب بھی وہ خیمہ اِجتماع میں داخل ہُوں تو پانی سے خُود کو پاک صَاف کریں تاکہ وہ مَر نہ جایٔیں۔ نیز جَب وہ سوختنی نذر کی خدمت اَنجام دینے کے لیٔے یَاہوِہ کے غِذا کے مذبح کے پاس آئیں ");
INSERT INTO urdoucv_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","تو وہ اَپنے ہاتھ اَور پاؤں دھوکر آئیں تاکہ وہ مَر نہ جایٔیں۔ یہ دستور دائمی فرمان سمجھ کر اَہرونؔ اَور اُس کی نَسل کے لیٔے نَسل در نَسل قائِم رہے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","پھر یَاہوِہ نے مَوشہ سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","”مَقدِس کے ثاقل کے حِساب سے یہ خُوشبودار مَسالے لینا: پانچ سَو ثاقل آبِ مُر۔ اُس کا آدھا یعنی ڈھائی سَو ثاقل دارچینی اَور خُوشبودار اگر ڈھائی سَو ثاقل ");
INSERT INTO urdoucv_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","اَور پانچ سَو ثاقل تج اَور پاک مَقدِس کے حِساب سے زَیتُون کا تیل ایک ہین ");
INSERT INTO urdoucv_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","اَور تُم اُن سے مَسح کرنے کا پاک زَیتُون کا تیل بنانا یعنی اُنہیں ایک عطر ساز کی کاریگری کے مُطابق مِلا کر ایک خُوشبودار روغن تیّار کرنا۔ اَور یہ مَسح کرنے کا پاک تیل ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","اَور پھر اِسی تیل سے خیمہ اِجتماع، عہد کے صندُوق، ");
INSERT INTO urdoucv_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","میز اَور اُس کے تمام ظروف، بخُور کا مذبح بنانا، ");
INSERT INTO urdoucv_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","سوختنی نذر کی قُربانی کا مذبح اَور اُس کے تمام ظروف، لگن اَور اُس کی چوکی کو مَسح کرنے کے لیٔے یہ تیل اِستعمال کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","اَور تُم اُن کو پاک کرنا تاکہ وہ خُوب پاک ہو جایٔیں اَورجو کچھ بھی اُن سے چھُو جائے گا پاک ٹھہرے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","”اَور تُم اَہرونؔ اَور اُس کے بیٹوں کو مَسح کرنا اَور اُن کو پاک کرنا تاکہ وہ بطور کاہِنؔ میری خدمت اَنجام دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","اَور تُم بنی اِسرائیل سے کہہ دینا، ’یہ زَیتُون کا تیل تمہاری آنے والی نَسلوں کے لیٔے میرا مَسح کرنے والا مُقدّس تیل ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","اَور اِسے کسی اَور اِنسان کے جِسم پر مت لگانا اَور نہ ہی اِس ترکیب سے کویٔی اَور زَیتُون کا تیل بنانا کیونکہ یہ مُقدّس ہے اَور تمہارے نزدیک بھی مُقدّس ٹھہرے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","جو کویٔی اِس طرح کا عطر بنائے گا اَورجو کویٔی اُسے کاہِنؔ کے علاوہ کسی اَور پر لگائے گا اُس کا اَپنی قوم سے خارج کیاجانا لازمی ہوگا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","پھر یَاہوِہ نے مَوشہ سے کہا، ”تُم خُوشبودار مَسالے یعنی مُر، مصطکی اَور لَون اَور اُن کے ساتھ لوبان، سَب وزن میں برابر برابر لینا، ");
INSERT INTO urdoucv_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","اَور اُن سے عِطرساز کی کاریگری کے مُطابق بخُور کا ایک خُوشبودار مرکّب بنانا۔ اُس میں نمک مِلانا اَور وہ صَاف اَور پاک ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","اَور اُس میں سے کچھ مہین پیس کر خیمہ اِجتماع میں عہد کے صندُوق کے سامنے جہاں مَیں تُجھ سے مِلا کروں گا رکھنا۔ یہ تمہارے لیٔے نہایت ہی پاک ٹھہرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","اَور تُم اِس ترکیب سے اَپنے لیٔے کویٔی بخُور نہ بنانا، اِسے یَاہوِہ کے لیٔے پاک سمجھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","جو کویٔی اَپنے سونگھنے کے لیٔے اِس کی مانند کویٔی بخُور بنائے گا اُس کا اَپنی قوم سے خارج کیاجانا لازمی ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","پھر یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","”دیکھو، مَیں نے یہُوداہؔ کے قبیلہ میں سے بصل ایل بِن اوری بِن حُورؔ کو چُناہے، ");
INSERT INTO urdoucv_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","مَیں نے اُسے خُدا کی رُوح سے معموُر کیا ہے، اُسے فہم اَور حِکمت، اَور ہر قِسم کی دستکاری کا علم بخشا ہے، ");
INSERT INTO urdoucv_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","تاکہ وہ سونے، چاندی اَور کانسے سے خُوبصورت نقش و نگار والی چیزیں بنائے، ");
INSERT INTO urdoucv_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","جواہرات کو تراشے اَور جڑی، لکڑی کو تراشے اَور ایک ماہر کاریگر ثابت ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","علاوہ اَزیں مَیں نے دانؔ کے قبیلہ میں سے اُہلیابؔ بِن احیسمکؔ کو اُس کا مددگار مُقرّر کیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","”یعنی خیمہ اِجتماع، عہد کا صندُوق اَور اُس پر کفّارہ کا سرپوش، اَور خیمہ کا سارا سامان، ");
INSERT INTO urdoucv_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","یعنی میز اَور اُس کے ظروف، خالص سونے کا چراغدان اَور اُس کے تمام ظروف، اَور بخُور کا مذبح، ");
INSERT INTO urdoucv_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","سوختنی نذر کی قُربانی کا مذبح اَور اُس کے تمام ظروف، لگن اَور اُس کی چوکی، ");
INSERT INTO urdoucv_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","اَور بیل بُوٹے کڑھے ہویٔے لباس، یعنی مُقدّس لباس اَہرونؔ کاہِنؔ کے لیٔے، اَور اُس کے بیٹوں کے لیٔے لباس جنہیں پہن کر وہ بطور کاہِنؔ خدمت اَنجام دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","اَور مَسح کرنے کا زَیتُون کا تیل، اَور پاک مقام کے لیٔے خُوشبودار بخُور، ");
INSERT INTO urdoucv_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","پھر یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","”بنی اِسرائیل سے کہو، ’تُم میرے سَبتوں کو ضروُر ماَننا۔ یہ میرے اَور تمہارے درمیان نَسل در نَسل ایک نِشان ہوگا، تاکہ تُم جانو کہ تُمہیں پاک کرنے والا یَاہوِہ میں ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","” ’لہٰذا سَبت کو مانو کیونکہ یہ تمہارے لیٔے مُقدّس ہے، اَورجو کویٔی اُس کی بےحُرمتی کرے وہ ضروُر مار ڈالا جائے؛ اَورجو کویٔی اُس دِن کویٔی کام کرے اَپنی قوم سے خارج کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","چھ دِن کام کیا جائے، لیکن ساتواں دِن آرام کا سَبت ہے جو یَاہوِہ کے لیٔے مُقدّس ہے۔ جو اِنسان سَبت کے دِن کویٔی کام کرے وہ ضروُر مار ڈالا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","لہٰذا بنی اِسرائیل سَبت کو مانیں اَور اُسے دائمی عہد کے طور پر نَسل در نَسل مانتے رہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","یہ میرے اَور بنی اِسرائیل کے درمیان ہمیشہ کے لیٔے ایک نِشان ہوگا کیونکہ یَاہوِہ نے آسمانوں کو اَور زمین کو چھ دِنوں میں بنایا اَور ساتویں دِن کام چھوڑکر آرام کیا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","اَور جَب یَاہوِہ کوہِ سِینؔائی پر مَوشہ سے کلام کرچکے، تو اُنہُوں نے اُسے شہادت کی دو تختیاں دیں۔ وہ تختیاں پتّھر کی تھیں اَور خُدا کے ہاتھ کی لکھی ہُوئی تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","اَور جَب لوگوں نے دیکھا کہ مَوشہ نے پہاڑ سے اُترنے میں دیر لگائی تو وہ اَہرونؔ کے پاس جمع ہوکر کہنے لگے، ”آئیے ہمیں ایک معبُود بنا کر دیں جو ہمارے آگے آگے چلے، کیونکہ ہم نہیں جانتے کہ اُس اِنسان مَوشہ کو جو ہمیں مِصر سے نکال لائے کیا ہو گیا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","اَہرونؔ نے اُن سے کہا، ”تمہاری بیویوں اَور بیٹوں اَور بیٹیوں کے کانوں میں جو سونے کی بالیاں ہیں، اُنہیں اُتار کر میرے پاس لے آؤ۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","پس سارے لوگ اُن کے کانوں سے بالیاں اُتار کر اَہرونؔ کے پاس لے آئے ");
INSERT INTO urdoucv_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","اَورجو کچھ اُنہُوں نے اُسے دیا اُس نے اُسے لے کر ایک بُت بنایا جو بچھڑے کی صورت میں ڈھالا گیا تھا اَور اُسے چھینی سے ٹھیک کیا۔ تَب وہ کہنے لگے، ”اَے اِسرائیل یہی تمہارا وہ معبُود ہے جو تُمہیں مِصر سے نکال لایا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","جَب اَہرونؔ نے یہ دیکھا تو اُس نے اُس بچھڑے کے سامنے ایک مذبح بنا کر اعلان کیا، ”کل یَاہوِہ کے لیٔے عید ہوگی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","پس اگلے دِن لوگوں نے صُبح سویرے اُٹھ کر سوختنی نذریں چڑھائیں اَور سلامتی کی نذر کی قُربانیاں گزرانیں۔ لوگ کھانے پینے کے لیٔے بیٹھے اَور پھر اُٹھ کر رنگ رلیاں منانے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","تَب یَاہوِہ نے مَوشہ سے فرمایا، ”نیچے جاؤ کیونکہ تمہارے لوگ جنہیں تُم مِصر سے نکال کر لائے بگڑ گیٔے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","وہ اُس راہ سے جِس پر چلنے کا مَیں نے اُنہیں حُکم دیا تھا بہت جلد پھر گیٔے ہیں اَور اُنہُوں نے اَپنے لیٔے بچھڑے کی صورت میں ڈھالا ہُوا بُت بنا لیا ہے۔ اُنہُوں نے اُس کی پرستش کی ہے اَور اُس کے لیٔے قُربانی چڑھا کر یہ بھی کہا، ’اَے اِسرائیل! یہ تمہارا وہ معبُود ہے جو تُمہیں مِصر سے نکال کر لایا ہے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","”مَیں نے اِس قوم کو دیکھ لیا،“ یَاہوِہ نے مَوشہ سے فرمایا، ”اَور یہ ایک ضِدّی قوم ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","اَب تُم کچھ مت کہنا کیونکہ میرا غضب اُن کے خِلاف بھڑکنے کو ہے اَور مَیں اُنہیں نِیست و نابود کرنے والا ہُوں۔ پھر میں تُمہیں ایک بڑی قوم بناؤں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","لیکن مَوشہ نے یَاہوِہ اَپنے خُدا سے رحم کی درخواست کرتے ہویٔے کہا، ”اَے یَاہوِہ! آپ کا غضب اَپنے لوگوں کے خِلاف کیوں بھڑکے جنہیں آپ نے عظیم قُوّت اَور قوی ہاتھ سے مِصر سے نکال لائے؟ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","مِصریوں کو یہ کہنے کا موقع کیوں ملے، ’عِبرانیوں کا خُدا اُنہیں بُرے اِرادہ سے نکال لے گیا تاکہ اُنہیں پہاڑوں میں مار ڈالے، رُوئے زمین پر سے مٹا ڈالے؟‘ لہٰذا اَپنے شدید قہر سے باز رہو اَور اَپنے لوگوں پر آفت نازل نہ کرو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","اَپنے خادِم اَبراہامؔ، اِصحاقؔ اَور اِسرائیل کو یاد کرو جِن سے آپ نے اَپنی ہی قَسم کھا کر کہاتھا: ’مَیں تمہاری نَسل کو آسمان کے تاروں کی مانند بڑھاؤں گا اَور یہ سارا مُلک جِس کا مَیں نے اُن سے وعدہ کیا تمہاری نَسل کو دُوں گا اَور وہ ہمیشہ کے لیٔے اِس کے وارِث ہوں گے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","تَب یَاہوِہ اَپنے قہر و غضب سے باز آئے اَور اُنہُوں نے اَپنے لوگوں پر وہ آفت نازل نہ کی جِس کی اُنہُوں نے دھمکی دی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","اَور مَوشہ شہادت کی دونوں تختیاں ہاتھوں میں لیٔے ہویٔے پلٹ کر پہاڑ سے نیچے اُترے۔ وہ تختیاں آگے اَور پیچھے دونوں طرف سے لکھی ہُوئی تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","اَور وہ تختیاں خُدا ہی کی بنائی ہُوئی تھیں اَورجو تحریر اُن پر تھی وہ بھی خُدا ہی کی تحریر تھی اَور اُن پر کندہ کی ہُوئی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","اَور جَب یہوشُعؔ نے لوگوں کی چیخ پُکار سُنی تو اُس نے مَوشہ سے کہا، ”چھاؤنی میں لڑائی کا شور ہو رہاہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","مَوشہ نے جَواب دیا: ”یہ شور نہ تو فتح کا ہے، نہ شِکست کا؛ یہ تو گانے کی آواز ہے جو میں سُن رہا ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","جَب مَوشہ نے چھاؤنی کے قریب پہُنچ کر اُس بچھڑے کو دیکھا اَور یہ بھی کہ لوگ رقص کر رہے ہیں تو وہ غُصّہ سے آگ بگُولا ہو گئے اَور اُنہُوں نے وہ تختیاں اَپنے ہاتھوں میں سے پھینک دیں اَور وہ ٹکڑے ٹکڑے ہوکر پہاڑ کے دامن میں جا گریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","اَور اُنہُوں نے اُس بچھڑے کو جسے لوگوں نے بنایا تھا لے کر آگ میں جَلا دیا اَور پھر اُسے مہین پیس کر پانی میں مِلایا اَور بنی اِسرائیل کو پلوایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","اَور مَوشہ نے اَہرونؔ سے کہا، ”اِن لوگوں نے تمہارے ساتھ کیا کیا تھا جو تُم نے اُنہیں اِتنے بڑے گُناہ میں پھنسا دیا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","اَہرونؔ نے کہا، ”میرے آقا! ناراض نہ ہو تُم جانتے ہو کہ یہ لوگ کتنے شر پسند ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","اُنہُوں نے مُجھ سے کہا، ’ہمارے لیٔے معبُود بنادو جو ہمارے آگے آگے چلے کیونکہ ہم نہیں جانتے کہ اُس اِنسان مَوشہ کو جو ہمیں مِصر سے نکال کر لائے اُن کی کوئی خبر نہیں۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","تو مَیں نے اُن سے کہا، ’جِس کسی کے پاس سونے کا کویٔی زیور ہے وہ اُسے اُتار کر لے آئے۔‘ تَب اُنہُوں نے اُسے مُجھے دیا اَور جَب مَیں نے سارے سونے کو آگ میں ڈالا تو یہ بچھڑا نکل پڑا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","جَب مَوشہ نے دیکھا کہ لوگ بے قابُو ہو چُکے ہیں اَور اَہرونؔ نے اُنہیں بے لگام چھوڑ دیا ہے اَور دُشمن اُن پر ہنس رہے ہیں ");
INSERT INTO urdoucv_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","تو مَوشہ نے چھاؤنی کے دروازہ پر کھڑے ہوکر کہا، ”جو کویٔی یَاہوِہ کی طرف ہے وہ میرے پاس آ جائے۔“ تَب سَب بنی لیوی اُس کے پاس جمع ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","اَور مَوشہ نے اُن سے کہا، ”یَاہوِہ، بنی اِسرائیل کے خُدا کا یہ فرمان ہے: ’ہر اِنسان اَپنی تلوار سنبھال لے اَور چھاؤنی میں ایک سِرے سے دُوسرے سِرے تک ہر طرف جائے اَور اَپنے بھائیوں دوستوں اَور پڑوسیوں کو قتل کرتا پھرے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","اَور بنی لیوی نے وَیسا ہی کیا جَیسا مَوشہ نے حُکم دیا تھا اَور اُس دِن اُن لوگوں میں سے تقریباً تین ہزار اِنسان مارے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","تَب مَوشہ نے کہا، ”آج تُم یَاہوِہ کے لیٔے مخصُوص کئے گیٔے ہو کیونکہ تُم نے اَپنے بیٹوں اَور بھائیوں کا بھی لحاظ نہ کیا۔ لہٰذا آج ہی کے دِن اُس نے تُمہیں برکت بخشی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","اَور اگلے دِن مَوشہ نے لوگوں سے کہا، ”تُم نے بڑا بھاری گُناہ کیا ہے۔ لیکن اَب مَیں یَاہوِہ کے پاس اُوپر جاتا ہُوں تاکہ ممکن ہو تو تمہارے گُناہ کا کفّارہ دے سکوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","لہٰذا مَوشہ واپس یَاہوِہ کے پاس جا کر کہنے لگے، ”افسوس اِن لوگوں نے کتنا بڑا گُناہ کیا کہ اَپنے لیٔے سونے کا معبُود بنا لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","لیکن اَب مہربانی سے اُن کا گُناہ مُعاف کر دیں۔ اگر نہیں تو میرا نام اُس کِتاب میں سے جو آپ نے لکھی ہے مٹا دیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","اَور یَاہوِہ نے مَوشہ سے فرمایا، ”جِس کسی نے میرے خِلاف گُناہ کیا ہے میں اُس کے نام کو اَپنی کِتاب سے مٹا دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","اَب جاؤ اَور لوگوں کو اُس جگہ لے جاؤ جو مَیں نے تُمہیں بتایٔی ہے اَور میرا فرشتہ تمہارے آگے آگے چلے گا۔ تاہم جَب میرا سزا دینے کا وقت آئے گا تو میں اُنہیں اُن کے گُناہ کی سزا دُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","اَور یَاہوِہ نے اُن لوگوں پر مَری کی وَبا نازل کی کیونکہ اُنہُوں نے اَہرونؔ سے بچھڑا بنوا کر اُس کی پرستش کی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","پھر یَاہوِہ نے مَوشہ سے فرمایا، ”تُم اَور وہ لوگ جنہیں مِصر سے نکال لائے، یہ جگہ چھوڑکر اُس مُلک کی طرف روانہ ہو جِس کا مَیں نے قَسم کھا کر اَبراہامؔ، اِصحاقؔ اَور یعقوب سے یہ وعدہ کیا تھا، ’میں اُنہیں تمہاری نَسل کو دے دُوں گا۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","اَور مَیں اَپنے فرشتہ کو تمہارے آگے آگے بھیجوں گا اَور مَیں کنعانیوں، امُوریوں، حِتّیوں، پَرزّیوں، حِوّیوں اَور یبُوسیوں کو نکال دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","اُس مُلک میں جہاں دُودھ اَور شہد بہتا ہے داخل ہو۔ لیکن مَیں تمہارے ساتھ نہ جاؤں گا کیونکہ تُم ایک ضِدّی قوم ہو اَور کہیں اَیسا نہ ہو کہ میں تُمہیں راہ ہی میں فنا کر ڈالوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","جَب لوگوں نے یہ وحشتناک الفاظ سُنے تو غمزدہ ہو گئے اَور کسی نے بھی کویٔی زیور نہ پہنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","کیونکہ یَاہوِہ نے مَوشہ سے فرمایا تھا، ”بنی اِسرائیل کو کہہ دیں، ’تُم ایک ضِدّی قوم ہو اَور اگر مَیں ایک لمحہ کے لیٔے بھی تمہارے ساتھ چلُوں تو تُمہیں فنا کر سَکتا ہُوں۔ لہٰذا اَپنے زیورات اُتار ڈالو تَب میں فیصلہ کروں گا کہ تمہارے ساتھ کیا کرنا چاہیے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","چنانچہ بنی اِسرائیل نے حورِبؔ پہاڑ پر اَپنے زیورات اُتار ڈالے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","اَور مَوشہ ایک خیمہ اِجتماع لے کر اُسے چھاؤنی کے باہر کچھ دُور لگا لیا کرتے تھے جِس کا نام اُنہُوں نے ”خیمہ اِجتماع رکھا تھا۔“ اَورجو کویٔی یَاہوِہ کا طالب ہوتا وہ چھاؤنی کے باہر اُس خیمہ اِجتماع کی طرف چلا جاتا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","جَب کبھی مَوشہ باہر اُس خیمہ کی طرف جاتے تو تمام لوگ اُٹھ اُٹھ کر اَپنے خیموں کے دروازہ پر کھڑے ہو جاتے اَور جَب تک مَوشہ اُس خیمہ کے اَندر داخل نہ ہو جاتے اُنہیں دیکھتے رہتے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","اَور جَب مَوشہ خیمہ کے اَندر چلے جاتے تو بادل کا سُتون نیچے اُترتا اَور دروازہ پر جاتا اَور یَاہوِہ مَوشہ سے باتیں کرنے لگتے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","اَور جَب بھی لوگ بادل کے سُتون کو خیمہ کے دروازہ پر کھڑا دیکھتے تو سَب کے سَب کھڑے ہو جاتے اَور اَپنے اَپنے خیمہ کے دروازہ پر یَاہوِہ کو سَجدہ کرتے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","اَور یَاہوِہ مَوشہ سے رُوبرو باتیں کرتے تھے، جَیسے کویٔی اَپنے دوست سے باتیں کرتا ہے۔ پھر مَوشہ چھاؤنی کو واپس لَوٹ آتے مگر اُن کا خادِم یہوشُعؔ بِن نُونؔ جو جَوان اِنسان تھا خیمہ ہی میں رہتا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","مَوشہ نے یَاہوِہ سے کہا، ”آپ مُجھ سے کہتے رہے ہیں، ’اِن لوگوں کی رہبری کرو،‘ لیکن آپ نے یہ نہیں بتایا کہ میرے ساتھ کِس کو بھیجیں گے۔ آپ نے یہ بھی فرمایا، ’میں تُمہیں نام سے جانتا ہُوں اَور آپ نے مُجھ پر مہربانی کی ہے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","پس اگر آپ مُجھ سے خُوش ہیں تو مُجھے اَپنے طریقے سکھائیں، تاکہ مَیں آپ کو جان سکوں اَور آپ کی نظر میں افضل ٹھہروں۔ خیال رکھیں کہ یہ قوم آپ کی ہی اُمّت ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","یَاہوِہ نے جَواب دیا، ”میری حُضُوری تمہارے ساتھ جائے گی اَور مَیں تُمہیں اِطمینان بخشوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","تَب مَوشہ نے اُن سے کہا، ”اگر آپ کی حُضُوری ہمارے ساتھ نہ ہوگی تو آپ ہمیں یہاں سے آگے نہ بھیجیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","کیسے مَعلُوم ہوگا کہ آپ مُجھ سے اَور اَپنے لوگوں سے راضی ہیں جَب تک کہ آپ ہمارے ساتھ نہ جائیں؟ اِسی سے تو ظاہر ہوگا کہ میں اَور آپ کے لوگ رُوئے زمین کی ساری قوموں میں اِمتیازی حیثیّت رکھتے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","اَور یَاہوِہ نے مَوشہ سے کہا، ”جِس بات کے لیٔے آپ نے درخواست کی ہے میں اُسے ضروُر پُوری کروں گا کیونکہ مَیں آپ سے راضی ہُوں اَور مَیں تُمہیں تمہارے نام سے جانتا ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","تَب مَوشہ نے کہا، ”اَب مُجھے اَپنا جلال دِکھائیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","اَور یَاہوِہ نے فرمایا، ”میں اَپنا جلال تمہارے سامنے عیاں کروں گا اَور اَپنا نام خُداوؔند کا تمہاری مَوجُودگی میں اعلان کروں گا۔ جِس پر مُجھے رحم کرنا منظُور ہوگا اُس پر رحم کروں گا، اَور جِس پر ترس کھانا منظُور ہوگا اُس پر ترس کھاؤں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","اَور یہ بھی کہا، ”تُم میرا چہرہ نہیں دیکھ سکتے کیونکہ کویٔی بھی اِنسان مُجھے دیکھ کر زندہ نہیں رہ سَکتا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","پھر یَاہوِہ نے فرمایا، ”میرے قریب ہی ایک جگہ ہے وہاں تُم ایک چٹّان پر کھڑے ہو جاؤ۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","اَور جَب میرا جلال وہاں سے گزرے گا تو میں تُمہیں اُس چٹّان کے شگاف میں رکھوں گا اَور اَپنے ہاتھ سے تُمہیں اُس وقت تک ڈھانکے رہُوں گا جَب تک کہ میں گزر نہ جاؤں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","پھر میں اَپنا ہاتھ ہٹا لُوں گا اَور تمہاری نظر میرے چہرے پر پڑےگی لیکن تُمہیں میرا چہرہ ہرگز دِکھائی نہیں دے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","یَاہوِہ نے مَوشہ سے کہا، ”پہلی تختیوں کی مانند پتّھر کی دو تختیاں تراش اَور مَیں اُن پر وُہی الفاظ لِکھ دُوں گا جو اُن پہلی تختیوں پر جنہیں تُم نے توڑ ڈالا مرقوم تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","اَور صُبح کو تیّار ہو جانا اَور پھر کوہِ سِینؔائی پر آجانا اَور وہاں پہاڑ کی چوٹی پر میرے سامنے حاضِر ہونا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","تمہارے ساتھ کویٔی اَور نہ آئے اَور نہ ہی اُس پہاڑ پر کہیں دِکھائی دے اَور بھیڑ بکریاں اَور گائے بَیل بھی پہاڑ کے سامنے چرنے نہ پائیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","لہٰذا مَوشہ نے پہلی تختیوں کی مانند پتّھر کی دو تختیاں تراشیں اَور وہ صُبح سویرے کوہِ سِینؔائی پر چڑھا جَیسا کہ یَاہوِہ نے اُسے حُکم دیا تھا اَور وہ پتّھر کی دونوں تختیاں اَپنے ہاتھوں میں لیٔے ہویٔے تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","تَب یَاہوِہ بادل میں ہوکر نیچے اُترے اَور وہاں اُس کے ساتھ کھڑے ہوکر اَپنے نام ”یَاہوِہ“ کا اعلان کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","اَور وہ مَوشہ کے سامنے سے یہ اعلان کرتے ہُوئے گزرے، ”یَاہوِہ، جو یَاہوِہ، رحیم اَور مہربان خُدا، قہر کرنے میں دھیمے اَور شفقت اَور وفاداری میں غنی، ");
INSERT INTO urdoucv_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ہزاروں پر رحم کرنے والے اَور سرکشی اَور گُناہ کے بخشنے والے۔ لیکن وہ مُجرم کو بے سزا نہیں چھوڑتے بَلکہ اَولاد کو آباؤاَجداد کے گُناہ کی سزا اُن کے بیٹوں اَور پوتوں کو تیسری اَور چوتھی پُشت تک دیتے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","مَوشہ نے فوراً زمین تک جھُک کر سَجدہ کیا ");
INSERT INTO urdoucv_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","اَور کہا، ”اَے خُداوؔند! اگر مَیں آپ کا منظورِ نظر ہُوں تو اَے خُداوؔند، آپ ہمارے ساتھ ساتھ چلئے۔ اگرچہ یہ ایک ضِدّی قوم ہے تو بھی ہماری بدکاری اَور خطائیں مُعاف کر دیجئے اَور ہمیں بطور اَپنی مِیراث قبُول فرمائیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","تَب یَاہوِہ نے کہا: ”مَیں تمہارے ساتھ ایک عہد باندھ رہا ہُوں اَور تمہارے سَب لوگوں کے سامنے اَیسے عجائب کروں گا جو تمام دُنیا میں پہلے کبھی کسی بھی قوم میں نہیں کئے گیٔے۔ اَور وہ لوگ جِن کے درمیان تُم رہتے ہو دیکھیں گے کہ وہ کام جو مَیں یَاہوِہ تمہارے لیٔے کروں گا کتنا مُہیب ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","آج جو حُکم مَیں تُمہیں دیتا ہُوں اُس کی تعمیل کرو اَور مَیں تمہارے سامنے سے امُوری، کنعانی، حِتّی، پَرزّی، حِوّی اَور یبُوسی قوموں کو تمہارے آگے سے نکال دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","خبردار! جِس مُلک میں تُم جا رہے ہو وہاں کے رہنے والوں کے ساتھ کویٔی عہد نہ کرنا ورنہ وہ تمہارے لیٔے پھندا بَن جایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","تُم اُن کے مذبحوں کو ڈھا دینا اَور اُن کے مُقدّس سُتونوں کے ٹکڑے ٹکڑے کردینا اَور اُن کے اشیراہؔ کے سُتونوں کو کاٹ ڈالنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","اَور کسی دُوسرے معبُود کی عبادت نہ کرنا کیونکہ یَاہوِہ جِس کا نام غیّور ہے وہ ایک غیّور خُدا ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","”اُس مُلک کے باشِندوں کے ساتھ کویٔی عہد نہ کرنا کیونکہ جَب وہ اَپنے معبُودوں کی پیروی میں زناکار ٹھہریں اَور اُن کے لیٔے قُربانیاں کریں اَور تُمہیں دعوت دیں اَور تُم اُن کی قُربانیاں کھا لوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","اَور جَب تُم اُن کی بیٹیوں میں سے بعض کو اَپنے بیٹوں سے شادی کر دوگے اَور اُن کی وہ بیٹیاں اَپنے معبُودوں کی پیروی میں زناکار ٹھہریں گی تو وہ تمہارے بیٹوں کو بھی اَپنے معبُودوں کی پیروی میں زناکاری کی راہ پر لے جائیں گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","”تُم ڈھالے ہویٔے معبُود نہ بنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","”تُم بے خمیری روٹی کی عید منایا کرنا اَور جَیسے مَیں نے تُمہیں حُکم دیا سات دِن تک بے خمیری روٹی کھانا اَور یہ عید مُقرّرہ وقت پر ابیبؔ کے مہینے میں منایا کرنا کیونکہ اِسی مہینے میں تُم مِصر سے نکلے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","”سَب پہلوٹھے میرے ہیں اَور اِن میں تمہارے چَوپایوں کے نر پہلوٹھے بھی شامل ہیں خواہ وہ گلّے کے بچھڑے ہُوں یا برّے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","گدھے کے پہلے بچّہ کے فدیہ میں برّہ دیا جائے لیکن اگر تُم اُس کا فدیہ نہ دینا چاہو تو اُس کی گردن توڑ ڈالنا۔ اَپنے تمام پہلوٹھے بیٹوں کا فدیہ دینا۔ ”اَور کویٔی بھی میرے سامنے خالی ہاتھ نہ آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","”تُم چھ دِن کام کاج کرنا لیکن ساتویں دِن آرام کرنا ہل چلانے اَور فصل کاٹنے کے موسم کے دَوران بھی ضروُر آرام کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","”اَور گیہُوں کے پہلے پھل کے کاٹنے کے وقت ہفتوں کی عید اَور سال کے آخِر میں فصل جمع کرنے کی عید منانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","تمہارے تمام اِنسان سال میں تین بار یَاہوِہ قادر، اِسرائیل کے خُدا کے حُضُور حاضِر ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","میں قوموں کو تمہارے سامنے سے نکال دُوں گا اَور تمہاری سرحدوں کو وسعت دُوں گا اَور جَب تُم ہر سال تین بار یَاہوِہ اَپنے خُدا کے حُضُور حاضِر ہونے کے لیٔے جاؤگے تو کویٔی بھی تمہاری زمین کا لالچ نہ کرےگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","”اَور تُم مُجھے کسی قُربانی کا خُون کسی اَیسی چیز کے ساتھ نہ پیش کرنا جِس میں خمیر مِلا ہو اَور عیدِفسح کی قُربانی میں سے کچھ صُبح تک باقی نہ رکھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","”اَور تُم اَپنی زمین کے پہلے پھلوں میں سے بہترین پھل یَاہوِہ اَپنے خُدا کے گھر میں لانا۔ ”تُم بکری کے بچّہ کو اُس کی ماں کے دُودھ میں نہ پکانا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","پھر یَاہوِہ نے مَوشہ سے کہا، ”تُم اِن باتوں کو لِکھ لینا کیونکہ اِن ہی باتوں کے مُطابق مَیں نے تمہارے ساتھ اَور اِسرائیل کے ساتھ ایک عہد باندھا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","اَور مَوشہ چالیس دِن اَور چالیس رات بغیر کچھ کھائے پیئے وہیں یَاہوِہ کے ساتھ رہے اَور اُس نے اُن تختیوں پر عہد کی باتیں یعنی اُن دس اَحکام کو لِکھّا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","جَب مَوشہ دونوں شہادت کی تختیاں اَپنے ہاتھوں میں لئے ہویٔے کوہِ سِینؔائی سے نیچے آئے تو وہ اِس بات سے بے خبر تھے کہ یَاہوِہ کے ساتھ باتیں کرنے کے باعث اُن کا چہرہ چمک رہاہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","اَور جَب اَہرونؔ اَور تمام بنی اِسرائیل نے مَوشہ کو دیکھا کہ اُن کا چہرہ چمک رہاہے تو وہ اُن کے نزدیک آنے سے ڈرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","لیکن مَوشہ نے اُنہیں بُلایا اَور اَہرونؔ اَور جماعت کے سَب سردار اُن کے پاس واپس آ گیٔے اَور اُنہُوں نے اُن سے باتیں کیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","بعد میں تمام بنی اِسرائیل نزدیک آ گیٔے اَور اُنہُوں نے وہ تمام اَحکام جو یَاہوِہ نے اُنہیں کوہِ سِینؔائی پر دیئے تھے اُنہیں بتائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","اَور جَب مَوشہ اُن سے باتیں کرچکے تو اُنہُوں نے اَپنے چہرے پر نقاب ڈال لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","لیکن جَب مَوشہ یَاہوِہ سے باتیں کرنے کے لیٔے اُن کی بارگاہ میں داخل ہوتے تو باہر نکلنے کے وقت تک نقاب کو اُتارے رہتے تھے اَورجو حُکم اُنہیں ملتا اُسے باہر آکر بنی اِسرائیل کو بتا دیتے ");
INSERT INTO urdoucv_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","اَور اِسرائیلی دیکھتے کہ اُن کا چہرہ چمک رہاہے۔ تَب مَوشہ اُس نقاب کو اَپنے چہرے پر ڈال لیتے اَور اُس وقت تک ڈالے رہتے جَب تک وہ یَاہوِہ سے باتیں کرنے کے لیٔے اَندر نہ جاتے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","مَوشہ نے بنی اِسرائیل کی ساری جماعت کو جمع کیا اَور اُن سے کہا، ”وہ باتیں جنہیں کرنے کا یَاہوِہ نے تُمہیں حُکم دیا ہے یہ ہیں: ");
INSERT INTO urdoucv_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","چھ دِن کام کاج کیا جائے لیکن ساتواں دِن تمہارے لیٔے مُقدّس ہوگا یعنی یَاہوِہ کے آرام کا سَبت۔ اَورجو کویٔی اُس دِن کچھ کام کرے وہ مار ڈالا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","اَور سَبت کے دِن تُم اَپنی قِیام گاہوں میں کہیں بھی آگ نہ جَلانا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","مَوشہ نے بنی اِسرائیل کی ساری جماعت سے کہا، ”جو حُکم یَاہوِہ نے دیا ہے وہ یہ ہے کہ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","تُم اُس میں سے جو تمہارے پاس ہے یَاہوِہ کے لیٔے نذر لایا کرو۔ اَور ہر ایک خُوشی سے یَاہوِہ کے لیٔے نذر: ”سونا، چاندی، کانسے؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","نیلا، اَرغوانی، سُرخ رنگ کا کپڑا، نفیس کتان؛ بکری کی پشم؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","اَور مینڈھوں کی سُرخ رنگی ہُوئی کھالیں، دریائی بچھڑوں کی کھالیں؛ اَور کیکر کی لکڑی؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","اَور چراغ کے لیٔے زَیتُون کا تیل، مَسح کا زَیتُون کا تیل اَور خُوشبودار بخُور کے لیٔے مَسالے؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","افُود، سنگِ سُلیمانی اَور سینہ بند میں جڑنے کے لیٔے نگینے اَور دیگر جواہرات۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","”اَور تمہارے درمیان وہ تمام جو تربّیت یافتہ کاریگر ہیں آئیں اَور وہ تمام چیزیں بنائیں جِن کا یَاہوِہ نے حُکم دیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","”یعنی مَسکن کے ساتھ خیمہ اَور اُس کا غلاف، اَور اُس کے تُکمے، تختے، بینڈے اَور اُس کے سُتون اَور پایٔے، ");
INSERT INTO urdoucv_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","صندُوق اَور اُس کی بَلّیاں، کفّارہ کا سرپوش اَور اُس کے اِردگرد کا پردہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","میز اَور اُس کی بَلّیاں اَور اُس کے تمام ظروف اَور نذر کی روٹی؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","اَور چراغدان جو رَوشنی کے لیٔے ہے اَور اُس کے تمام اجزا۔ چراغ اَور جَلانے کے لیٔے زَیتُون کا تیل؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","بخُور جَلانے کا مذبح اَور اُس کی بَلّیاں۔ مَسح کرنے کا زَیتُون کا تیل اَور خُوشبودار بخُور۔ اَور مَسکن کے مدخل پر دروازہ کے لیٔے پردہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","اَور سوختنی نذر کی قُربانی کا مذبح اَور اُس کا کانسے کا جنگلہ، اُس کی بَلّیاں اَور اُس کے تمام ظروف، کانسے کا لگن اَور اُس کی چوکی؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","صحن کے پردے اَور اُن کی بَلّیاں اَور پایٔے اَور صحن کے مدخل کے لیٔے پردہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","مَسکن اَور صحن کے لیٔے میخیں اَور اُن کی رسّیاں؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","اَور پاک مَقدِس میں خدمت اَنجام دینے کے لیٔے بُنے ہویٔے مُقدّس لباس، اَہرونؔ کاہِنؔ کے لیٔے اَور اُس کے بیٹوں کے لیٔے لباس جَب وہ بطور کاہِنؔ خدمت کریں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","تَب بنی اِسرائیل کی ساری جماعت مَوشہ کے پاس سے رخصت ہو گئی ");
INSERT INTO urdoucv_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","اَور ہر کویٔی جِس کی نیّت نیک تھی اَور جِس کے دِل نے اُسے ترغِیب دی وہ آیا اَور خیمہ اِجتماع کے کام، وہاں کی پرستش اَور مُقدّس لباس کے لیٔے یَاہوِہ کے حُضُور نذر لایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","اَور مَرد اَور عورتیں سَب کے سَب خُوشی خُوشی آئے اَور سونے کے تمغے، سونے کی بالیاں، انگُشتریاں اَور آرائِش کی دیگر اَشیا لایٔے اَور اُن سَب نے ہلانے کی نذر کی قُربانی کے طور پر اَپنا سونا یَاہوِہ کو پیش کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","اَور ہر ایک جِس کے پاس نیلے آسمانی رنگ کا، اَرغوانی رنگ کا یا سُرخ رنگ کا کپڑا یا نفیس کتان یا بکریوں کی پشم، مینڈھوں کی سُرخ رنگی ہُوئی کھالیں یا دریائی بچھڑوں کی کھالیں تھیں لے آیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","اَور وہ جنہوں نے چاہا کہ چاندی یا کانسے کی نذر پیش کریں وہ اُسے یَاہوِہ کے لیٔے نذر کے طور پر لایٔے اَور جِس کے پاس کسی حِصّہ میں کام آنے والی کیکر کی لکڑی تھی وہ اُسی کو لے آیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","اَور ہُنرمند عورتوں نے نیلے آسمانی، اَرغوانی اَور سُرخ رنگ کا کپڑا یا نفیس کتان جو اُنہُوں نے اَپنے ہاتھوں سے کاتا اَور بُنا تھا لاکر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","اَورجو عورتیں سمجھدار اَور ہُنرمند تھیں اُنہُوں نے بکریوں کی پشم کاتی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","اَورجو سردار تھے وہ افُود اَور سینہ بند کے لیٔے سنگِ سُلیمانی اَور نگینے لایٔے ");
INSERT INTO urdoucv_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","اَور وہ جَلانے کے لیٔے، مَسح کرنے کے لیٔے اَور خُوشبودار بخُور کے لیٔے مَسالے اَور زَیتُون کا تیل بھی لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","اَور یُوں تمام بنی اِسرائیل مَرد اَور عورتیں اَپنی ہی خُوشی سے یَاہوِہ کے حُضُور اُس تمام کام کے لیٔے رضا کی قُربانی کے نذرانے لایٔے جسے کرنے کا یَاہوِہ نے اُنہیں مَوشہ کی مَعرفت حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","اَور پھر مَوشہ نے بنی اِسرائیل سے فرمایا، ”دیکھو، یَاہوِہ نے بصل ایل بِن اوری بِن حُورؔ کو چُنا جو بنی یہُوداہؔ کے قبیلہ میں سے ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","اَور اُس نے اُسے خُدا کی رُوح سے معموُر کیا ہے اَور اُسے فہم اَور حِکمت اَور ہر قِسم کی دستکاری کا علم بخشا ہے ");
INSERT INTO urdoucv_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","تاکہ وہ سونے چاندی اَور کانسے سے خُوبصورت نقش و نگار والی چیزیں بنائے ");
INSERT INTO urdoucv_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","اَور جواہرات کو تراشے اَور جڑے اَور لکڑی کو تراشے اَور ایک ماہر کاریگر ثابت ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","اَور یَاہوِہ نے اُسے اَور دانؔ کے قبیلہ سے اُہلیابؔ بِن احیسمکؔ دونوں کو دُوسروں کو ہُنر سِکھانے کی قابلیّت بخشی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","اَور یَاہوِہ نے اُنہیں بطور دستکار، صنعت کار اَور نیلے، اَرغوانی اَور سُرخ رنگ کے کپڑے اَور مہین کتان پر کشیدہ کاری کرنے اَور جولاہے کا کام کرنے کی مہارت بخشی ہے تاکہ وہ ماہر دستکار اَور صنعت کار بنیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","لہٰذا بصل ایل، اُہلیابؔ اَور ہر کاریگر جسے یَاہوِہ نے ہُنرمندی، اَور قابلیّت اَور پاک مَقدِس کو بنانے کے کُل کام کو سَر اَنجام دینے کا علم بخشا ہے تاکہ وہ یَاہوِہ کے حُکم کے مُطابق سارا کام اَنجام دیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","تَب مَوشہ نے بصل ایل، اَور اُہلیابؔ اَور ہر کاریگر کو جسے یَاہوِہ نے قابلیّت بخشی تھی اَورجو آکر کام کرنے کے لیٔے رضامند تھا طلب کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","اَور اُنہُوں نے وہ تمام نذریں جو بنی اِسرائیل نے پاک مَقدِس کو بنانے کے کام کو سَر اَنجام دینے کے لیٔے دئیے تھے، مَوشہ سے حاصل کئے اَور لوگ ہر صُبح رضا کی قُربانی کی نذر اَپنی خُوشی سے لاتے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","تَب تمام کاریگر جو پاک مَقدِس کو بنانے کے کام میں لگے ہویٔے تھے اَپنا کام چھوڑکر آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","اَور مَوشہ سے کہنے لگے، ”لوگ اُس کام کے لیٔے جِس کے کرنے کا حُکم یَاہوِہ نے دیا ہے ضروُرت سے بہت زِیادہ سامان لے آئے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","تَب مَوشہ نے حُکم دیا کہ تمام چھاؤنی میں اعلان کر دیا جائے: ”اَب کویٔی مَرد یا عورت پاک مَقدِس کی چیزیں بنانے کے لیٔے کویٔی نذرانے نہ لایٔے۔“ لہٰذا وہ لوگ اَور زِیادہ نذرانے لانے سے باز آئے ");
INSERT INTO urdoucv_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","کیونکہ جو سامان پہلے آ چُکاتھا وہ تمام کام کی تکمیل کے لیٔے ضروُرت سے کہیں زِیادہ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","اَور کام کرنے والوں میں سے اُن تمام نے جو تربّیت یافتہ اِنسان تھے اُس مَسکن کے لیٔے نیلے آسمانی، اَرغوانی اَور سُرخ رنگ کے کپڑے سے اَور نفیس بٹے ہویٔے کتان سے دس پردے بنائے جِن پر ایک ماہر کاریگر نے کشیدہ کاری سے کروبیم بنائے ہویٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","اَور وہ تمام پردے ایک ہی ناپ کے تھے یعنی ہر ایک اٹّھائیس ہاتھ لمبا اَور چار ہاتھ چوڑا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","اَور اُنہُوں نے اُن میں سے پانچ پردے باہم جوڑ دیئے اَور دُوسرے پانچ پردے بھی ایک دُوسرے کے ساتھ جوڑ دئیے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","پھر اُنہُوں نے پہلے جُڑے ہویٔے پردوں کے آخِری پردہ کے کنارے کے ساتھ ساتھ نیلے آسمانی رنگ کے تُکمے بنائے اَور دُوسرے پانچ پردوں کے آخِری پردہ کے کنارے کے ساتھ ساتھ بھی اَیسے ہی تُکمے بنائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","نیز اُنہُوں نے پہلی جوڑی کے ایک پردہ پر پچاس تُکمے اَور دُوسری جوڑی کے آخِری پردہ پر بھی پچاس تُکمے بنائے جو ایک دُوسرے کے سَب تُکمے ایک دُوسرے کے آمنے سامنے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","پھر اُنہُوں نے سونے کی پچاس گھنڈیاں بنائیں اَور اُنہیں پردوں کے دونوں حِصّوں کو باہم باندھنے کے لیٔے اِستعمال کیا جِس سے وہ مَسکن ایک ہو گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","اَور اُنہُوں نے بکری کی پشم سے خیمہ مَسکن کے اُوپر کے خیمہ کے لیٔے پردے بنائے جِن کی تعداد گیارہ تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","اَور تمام گیارہ پردے ایک ہی ناپ کے تھے یعنی تیس ہاتھ لمبے اَور چار ہاتھ چوڑے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","اَور اُنہُوں نے اُن پردوں میں سے پانچ کو باہم جوڑ کر ایک جوڑا بنا دیا اَور دُوسرے چھ پردوں کو جوڑ کر دُوسرا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","پھر اُنہُوں نے پہلے جوڑے کے آخِری پردہ کے کنارے کے ساتھ ساتھ پچاس تُکمے بنائے اَور دُوسرے جوڑے کے آخِری پردہ کے کنارے کے ساتھ ساتھ بھی پچاس تُکمے بنائے ");
INSERT INTO urdoucv_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","اَور اُنہُوں نے اُس خیمہ کو باہم جوڑنے کے لیٔے کانسے کی پچاس گھنڈیاں بنائیں تاکہ وہ ایک ہو جائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","پھر اُنہُوں نے اُس خیمہ کے لیٔے مینڈھوں کی سُرخ رنگی ہُوئی کھالوں کا ایک غلاف بنایا اَور اُس کے اُوپر دریائی بچھڑوں کی کھالوں کا غلاف بنایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","اَور اُنہُوں نے مَسکن کے لیٔے کیکر کی لکڑی کے بالکُل سیدھے کھڑے چوکھٹے بنائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","اَور ہر چوکھٹا دس ہاتھ لمبا اَور ڈیڑھ ہاتھ چوڑا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","اَور اُن کے ساتھ ایک دُوسرے کے متوازی دو دو چُولیں بنائیں اَور اُنہُوں نے مَسکن کے تمام چوکھٹے اِسی طرح بنائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","اَور اُنہُوں نے مَسکن کے جُنوبی پہلو کے لیٔے بیس چوکھٹے بنائے ");
INSERT INTO urdoucv_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","اَور اُن کے لیٔے نیچے چاندی کے چالیس پایٔے بنائے یعنی ہر ایک چوکھٹے کے لیٔے دو دو پایٔے تاکہ ہر چُول کے نیچے ایک ایک پایہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","اَور دُوسری جانِب یعنی مَسکن کے شمالی پہلو کے لیٔے اُنہُوں نے بیس چوکھٹے ");
INSERT INTO urdoucv_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","اَور چاندی کے چالیس پایٔے بنائے تاکہ ہر ایک چوکھٹے کے نیچے دو دو۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","اَور اُنہُوں نے آخِری کونے پر یعنی مَسکن کی مغربی سمت میں چھ چوکھٹے بنائے ");
INSERT INTO urdoucv_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","اَور مَسکن کے آخِری سِرے کے کونوں کے لیٔے دو چوکھٹے بنائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","اَور اِن دونوں کونوں کے چوکھٹے نیچے سے اُوپر تک دوہرے تھے اَور ایک ہی حلقے میں برابر جُڑے ہویٔے تھے اَور دونوں ایک جَیسے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","اِس لیٔے آٹھ چوکھٹے اَور چاندی کے سولہ پایٔے ہو گئے یعنی ہر ایک چوکھٹے کے نیچے دو دو پایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","اُنہُوں نے کیکر کی لکڑی کے بینڈے بھی بنائے۔ پانچ مَسکن کے ایک طرف کے چوکھٹوں کے لیٔے، ");
INSERT INTO urdoucv_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","پانچ دُوسری طرف کے چوکھٹوں کے لیٔے اَور پانچ مَسکن کے آخِری کنارے یعنی مغربی سمت کے چوکھٹوں کے لیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","اَور اُنہُوں نے وسطیٰ بینڈے کو اَیسا بنایا کہ وہ اُن چوکھٹوں کے درمیان سے ہوکر ایک سِرے سے دُوسرے سِرے تک پہُنچے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","اَور اُنہُوں نے چوکھٹوں کو سونے سے منڈھا اَور بینڈوں کو تھامنے کے لیٔے سونے کے حلقے بنائے اَور اُنہُوں نے بینڈوں کو بھی سونے سے منڈھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","اَور اُس خیمہ میں دروازہ کے لیٔے نیلے، اَرغوانی اَور سُرخ دھاگے اَور نفیس بٹے ہُوئے کتان سے ایک پردہ بنایا اَور جِس پر کسی ماہر کاریگر نے کشیدہ کاری سے کروبیم بنائے ہویٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","اَور اُنہُوں نے اُس کے لیٔے کیکر کی لکڑی کے چار سُتون بنائے اَور اُنہیں سونے سے منڈھا۔ اَور اُن کے لیٔے سونے کے حلقوں سے لٹکایا اَور اُن کے لیٔے چاندی کے چار پایوں کو ڈھال کر کھڑا کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","اَور اُس خیمہ میں دروازہ کے لیٔے نیلے، اَرغوانی اَور سُرخ دھاگے اَور نفیس بٹے ہُوئے کتان سے ایک پردہ بنایا جِس پر کشیدہ کاری کی ہُوئی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","اَور اُنہُوں نے پانچ سُتون کنڈوں سمیت بنائے اَور اُن کے سِروں اَور پٹّیوں کو سونے سے منڈھا اَور اُن کے لیٔے کانسے کے پانچ پایٔے بنائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","اَور بصل ایل نے وہ صندُوق کیکر کی لکڑی کا بنایا۔ اُس کی لمبائی ڈھائی ہاتھ اَور چوڑائی ڈیڑھ ہاتھ اَور اُونچائی ڈیڑھ ہاتھ تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","اَور اُس کے اَندر اَور باہر دونوں طرف خالص سونا منڈھا اَور اُس کے اطراف سونے کا کلس بنایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","اَور اُس کے لیٔے سونے کو ڈھال کر چار کڑے بنائے اَور اُس کے چاروں پایوں کے ساتھ لگا دئیے دو کڑے ایک طرف اَور دو کڑے دُوسری طرف۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","پھر اُس نے کیکر کی لکڑی کی بَلّیاں بنا کر اُن پر سونا منڈھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","اَور اُس نے اُس صندُوق کو اُٹھاکر لے جانے کے لیٔے اُن بَلّیوں کو اُن کڑوں میں ڈال دیا جو صندُوق کے دونوں طرف تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","اَور اُس نے کفّارہ کا سرپوش خالص سونے کا بنایا جو کہ ڈھائی ہاتھ لمبا اَور ڈیڑھ ہاتھ چوڑا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","پھر اُس نے سرپوش کے دونوں کونوں پر سونے سے گڑھے ہویٔے دو کروبیم بنائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","اُس نے ایک کروب کو ایک سِرے پر اَور دُوسرے کروب کو دُوسرے سِرے پر بنایا اَور دونوں سِروں کے کروبیم اَور سرپوش ایک ہی ٹکڑے سے بنے ہُوئے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","اَور وہ کروبیم اَپنے پر اُوپر کی طرف پھیلائے ہویٔے تھے اَور اُن سے سرپوش کو ڈھانکے ہویٔے تھے۔ اَور وہ کروبیم کے چہرے ایک دُوسرے کے آمنے سامنے تھے گویا سرپوش کی طرف دیکھ رہے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","اُنہُوں نے وہ میز کیکر کی لکڑی کی بنائی جو دو ہاتھ لمبی اَور ایک ہاتھ چوڑی اَور ڈیڑھ ہاتھ اُونچی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","پھر اُنہُوں نے اُس پر خالص سونا منڈھا اَور اُس کے اطراف سونے کا ایک کلس بنایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","اَور اُنہُوں نے اُس کے اطراف چار اُنگل چوڑی کنگنی بھی بنائی اَور اُس کنگنی پر سونے کا کلس رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","اَور اُنہُوں نے اُس میز کے لیٔے سونے کے چار کڑے بنا کر اُنہیں اُس کے چاروں کونوں سے جہاں پایٔے تھے جوڑ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","اَور وہ کڑے کنگنی کے نزدیک لگائے گیٔے تاکہ وہ میز کو اُٹھانے کے لئے اِستعمال ہونے والی بَلّیوں کو تھامے رکھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","اَور اُس میز کو اُٹھانے کے لیٔے بَلّیاں کیکر کی لکڑی کی بنی ہُوئی تھیں اَور اُن پر سونا منڈھا ہُوا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","اَور اُنہُوں نے اُس میز کے لیٔے ظروف یعنی طباق، ڈونگے اَور پیالے اَور انگوری شِیرے کی نذروں کو اُنڈیلنے کے لیٔے صُراحیاں خالص سونے کے بنائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","اُنہُوں نے خالص سونے کا ایک چراغدان بنایا اَور اُس کے پایٔے اَور ڈنڈی کو گڑھ کر بنایا۔ اَور اُس کے پیالے، کلیاں اَور پھُول سَب ایک ہی ٹکڑے کے بنے ہویٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","اَور اُس چراغدان کے دونوں طرف سے چھ شاخیں باہر کو نکلیں تین ایک طرف اَور تین دُوسری طرف۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","اَور بادام کے پھُول کی شکل کے تین پیالے، کلیاں اَور پھُول ایک شاخ پر تھے اَور تین اگلی شاخ پر اَور اِسی طرح چراغدان سے باہر کو نکلی ہُوئی ساری چھ شاخوں پر۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","اَور چراغدان کے اُوپر بادام کے پھُول کی شکل کے چار پیالے بنے ہویٔے ہیں، اَور اُن کے ساتھ کلیاں اَور پھُول تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ایک کلی چراغدان سے نکلی ہُوئی شاخوں کی پہلی جوڑی کے نیچے تھی۔ دُوسری کلی شاخوں کی دُوسری جوڑی کے نیچے اَور تیسری کلی تیسری جوڑی کے نیچے یعنی ساری کلیاں چھ شاخوں کے نیچے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","اَور وہ کلیاں، شاخیں اَور چراغدان خالص سونے کے ایک ہی ٹکڑے سے گڑھ کر بنائے گیٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","اُنہُوں نے اُس کے لیٔے سات چراغ نیز اُس کی گُلگیر اَور گلدان بھی خالص سونے کے بنائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","اَور اُنہُوں نے وہ چراغدان اَور اُس کے تمام لوازمات کو ایک تالنت خالص سونے سے بنایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","اُنہُوں نے کیکر کی لکڑی سے بخُور کا مذبح بنایا اَور وہ چوکور تھا اَور ایک ہاتھ لمبا ایک ہاتھ چوڑا اَور دو ہاتھ اُونچا تھا اَور اُس کے سینگ ایک ہی ٹکڑے کے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","اَور اُنہُوں نے اُس کی اُوپر کی سطح اَور تمام اطراف کو اَور سینگوں کو خالص سونے سے منڈھا اَور اُس کے اِردگرد سونے کا ایک کلس بنایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","اَور اُس کلس کے نیچے اُنہُوں نے سونے کے دو حلقے بنائے اَور وہ ایک دُوسرے کے مقابل دونوں جانِب تھے تاکہ اُسے اُٹھانے کے لیٔے اِستعمال ہونے والی بَلّیوں کو تھامے رکھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","اَور اُنہُوں نے اُن بَلّیوں کو کیکر کی لکڑی سے بنایا اَور اُن پر سونا منڈھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","اَور اُنہُوں نے مَسح کرنے کا پاک زَیتُون کا تیل اَور خالص خُوشبودار بخُور بھی بنائے جو کہ ایک ماہر عطر ساز ہی بنا سَکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","اَور اُنہُوں نے سوختنی نذر کی قُربانی کا مذبح کیکر کی لکڑی کا بنایا جو چوکور تھا اَور پانچ ہاتھ لمبا اَور پانچ ہاتھ چوڑا اَور تین ہاتھ اُونچا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","اَور اُنہُوں نے اُس کے چاروں کونوں پر ایک ایک سینگ بنایا اَور وہ سینگ اَور مذبح ایک ہی ٹکڑے کے تھے اَور اُنہُوں نے مذبح کو کانسے سے منڈھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","اَور اُنہُوں نے اُس کے تمام ظروف کانسے کے یعنی دیگیں، بیلچے، چھڑکاؤ کرنے والے پیالے، گوشت کے لیٔے سیخیں اَور انگیٹھیاں بنائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","اَور اُنہُوں نے مذبح کے لیٔے اُس کنارے کے نیچے کانسے کا جالی دار جنگلہ اِس طرح لگایا کہ وہ مذبح سے آدھی اُونچائی تک پہُنچتا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","اَور اُنہُوں نے کانسے کے کڑے گڑھ کر بنائے تاکہ کانسے کے جنگلہ کے چاروں کونوں کی بَلّیوں کو تھامے رکھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","اَور اُنہُوں نے کیکر کی لکڑی کی بَلّیاں بنائیں اَور اُنہیں کانسے سے منڈھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","اَور اُنہُوں نے اُن بَلّیوں کو اُن کڑوں میں ڈالا تاکہ وہ مذبح کو اُٹھانے کے لیٔے اُس کے دونوں طرف ہُوں۔ اُنہُوں نے مذبح کو تختوں سے بنایا تھا اَور وہ اَندر سے کھوکھلا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","اَور اُنہُوں نے اُن عورتوں کے فرمانوں سے جو خیمہ اِجتماع کے دروازہ پر خدمت کرتی تھیں کانسے کا ایک لگن اَور لگن کی چوکی کانسے کی بنائی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","پھر اُنہُوں نے مَسکن کے لیٔے ایک صحن بنایا جِس کی جُنوبی سمت ایک سَو ہاتھ لمبی تھی اَور جِس کے پردے نفیس بٹے ہویٔے کتان کے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","اَور اُن کے لیٔے بیس سُتون اَور کانسے کے بیس پایٔے تھے۔ اَور سُتونوں پر چاندی کی کنڈیاں اَور پٹّیاں تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","اَور شمالی سمت بھی ایک سَو ہاتھ لمبی اَور اُس کے پردوں کے لیٔے بھی بیس سُتون اَور کانسے کے بیس پایٔے تھے۔ اَور سُتونوں کے لیٔے چاندی کی کنڈیاں اَور پٹّیاں تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","اَور مغربی کنارا پچاس ہاتھ چوڑا تھا جِس کے پردوں کے لیٔے دس سُتون اَور دس پایٔے تھے اَور اُن سُتونوں پر چاندی کی کنڈیاں اَور پٹّیاں تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","اَور طُلوع آفتاب کی طرف مشرقی کنارا بھی پچاس ہاتھ چوڑا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","اَور پندرہ ہاتھ لمبے پردے دروازہ کے ایک طرف تھے جِن کے لیٔے تین سُتون اَور تین ہی پایٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","اَور پندرہ ہاتھ لمبے پردے صحن کے دروازہ کی دُوسری طرف تھے اَور اُن کے لیٔے بھی تین سُتون اَور تین پایٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","اَور صحن کے اِردگرد تمام پردے نفیس بٹے ہویٔے کتان کے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","اُن بَلّیوں کے لیٔے پایٔے کانسے کے تھے۔ بَلّیوں پر کنڈیاں اَور پٹّیاں چاندی کی تھیں۔ صحن کے تمام پایوں کی پٹّیاں چاندی کی تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","صحن کے دروازہ کے لیٔے پردے نیلے، اَرغوانی اَور سُرخ رنگ کے سُوت اَور نفیس بٹے ہویٔے کتان کا تھا جِس پر بیل بُوٹے کشیدہ کئے ہویٔے تھے اَور وہ بیس ہاتھ لمبا تھا اَور صحن کے پردوں کی طرح پانچ ہاتھ اُونچا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","اَور اُس کے لیٔے چار بَلّیاں اَور کانسے کے چار پایٔے تھے۔ اُن کی کنڈیاں اَور پٹّیاں چاندی کی تھیں اَور اُن کے سِروں پر چاندی منڈھی ہُوئی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","اَور مَسکن کے خیمہ اَور اُس کے اِردگرد صحن کی تمام میخیں کانسے کی تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","یہ ہیں اُس سامان کے اعدادوشمار جو مَسکن اَور شہادت کے خیمہ کے لیٔے اِستعمال کئےگئے ہیں اَور جسے مَوشہ کے حُکم سے اَہرونؔ کاہِنؔ کے بیٹے اِتمارؔ کی زیرِ ہدایت لیویوں نے قلم بند کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","(بصل ایل بِن اوری بِن حُورؔ نے جو یہُوداہؔ کے قبیلہ سے تھا سَب کچھ بنایا جِس کا یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","اَور اُس کے ساتھ دانؔ کے قبیلہ کا اُہلیابؔ بِن احیسمکؔ تھا جو ایک اعلیٰ درجہ کا صنعت کار اَور نقّاش تھا اَور نیلے اَرغوانی اَور سُرخ رنگ کے سُوت اَور نفیس کتان کی کشیدہ کاری میں ماہر تھا)۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","اَور ہلانے کی نذر کی قُربانی کے طور پر چڑھایا جانے والا جِتنا سونا پاک مَقدِس کے لیٔے اِستعمال ہُوا وہ اُنتیس قِنطار اَور پاک مَقدِس کی ثاقل کے حِساب سے سات سَو تیس ثاقل تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","اَور وہ چاندی جو جماعت کے اُن افراد سے حاصل کی گئی جو مردُم شماری میں گنے گیٔے ایک سَو تالنت اَور پاک مَقدِس کی ثاقل کے حِساب سے ایک ہزار سات سَو پچھتّر ثاقل تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","یعنی ایک بیکا فی کس جو پاک مَقدِس کی ثاقل کے حِساب سے نیم ثاقل تھی ہر ایک سے لی گئی جو بیس بَرس یا اُس سے زِیادہ عمر کا تھا اَورجو شُمار کئے ہوؤں میں شامل تھا۔ اِن مَردوں کی کُل تعداد چھ لاکھ تین ہزار پانچ سَو پچاس تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ایک سَو تالنت چاندی پاک مَقدِس اَور پردوں کے پایوں کے ڈھالنے کے لیٔے اِستعمال کی گئی یعنی ایک سَو تالنت سے ایک سَو پایٔے اَور ہر پایٔے کے لیٔے ایک تالنت۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","اَور اُنہُوں نے بَلّیوں کے لیٔے کنڈیاں اَور بَلّیوں کے سِروں کو منڈھنے اَور اُن کی پٹّیاں بنانے کے لیٔے ایک ہزار سات سَو پچھتّر ثاقل چاندی اِستعمال کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","اَور ہلانے کی نذر کی قُربانی کے طور پر چڑھائے جانے سے جو کانسے حاصل ہُوا وہ وزن میں ستّر تالنت اَور دو ہزار چار سَو ثاقل تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","اَور اُنہُوں نے اُسے خیمہ اِجتماع کے دروازہ کے پایوں اَور کانسے کے مذبح اُس کا جنگلہ اَور اُس کے تمام ظروف بنانے کے لیٔے ");
INSERT INTO urdoucv_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","اَور اِردگرد کے صحن کے پایوں کے لیٔے اَور دروازہ کے پایوں کے لیٔے اَور مَسکن کے خیمہ کی تمام میخوں کے لیٔے اَور اِردگرد کے صحن کی میخوں کے لیٔے اِستعمال کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","اَور اُنہُوں نے پاک مَقدِس میں خدمت کرتے وقت پہننے کے لیٔے نیلے، اَرغوانی اَور سُرخ رنگ کے بُنے ہویٔے کپڑے بنائے اَور اُنہُوں نے اَہرونؔ کے لیٔے بھی مُقدّس لباس بنائے جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","اَور اُنہُوں نے سونے اَور نیلے، اَرغوانی اَور سُرخ دھاگے اَور نفیس بٹے ہویٔے کتان کا افُود بنایا ");
INSERT INTO urdoucv_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","اَور اُنہُوں نے سونے کو کُوٹ کر پتلے پتلے پتّر بنائے اَور اُن پتروں کو کاٹ کر تار بنائے تاکہ نیلے اَرغوانی اَور سُرخ رنگ کے دھاگے اَور نفیس کتان پر اُن سے ایک ماہر دستکار کی طرح زردوزی کا کام کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","اُنہُوں نے افُود کو جوڑنے کے لیٔے دو مونڈھے بنائے اَور اُن کو دونوں کونوں سے مِلا کرجوڑ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","اَور اُس کا کمربند اُسی کی مانند ایک ٹکڑے سے مہارت سے بُنا گیا تھا۔ وہ سونے، نیلے، اَرغوانی اَور قِرمزی رنگ کے کپڑے اَور نفیس بٹے ہویٔے کتان کا بنا ہُوا تھا جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","اَور اُنہُوں نے سونے کے خانوں میں سُلیمانی پتّھر سنگِ سُلیمانی جڑے۔ اُن پر ایک انگُشتری کے نقش کی طرح اِسرائیل کے بیٹوں کے نام کندہ کئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","اَور اُنہیں افُود کے کندھے والی پٹّیوں پر لگا دیا تاکہ یہ پتّھر اِسرائیل کے بیٹوں کی یادگاری کے لیٔے ہُوں جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","اَور اُنہُوں نے ایک ماہر کاریگر سے سینہ بند بنوایا جو افُود کی طرح سونے، نیلے آسمانی، اَرغوانی اَور سُرخ رنگ کے کپڑے اَور نفیس بٹے ہویٔے کتان سے بنایا گیا تھا ");
INSERT INTO urdoucv_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","اَور وہ چوکور تھا یعنی ایک بالشت لمبا اَور ایک بالشت چوڑا جسے دہرا کیا جا سَکتا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","پھر اُنہُوں نے اُس پر چار قطاروں میں قیمتی جواہر جڑے۔ پہلی قطار میں یاقُوت سُرخ اَور یَشب سبز اَور فیروزہ تھے؛ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","دُوسری قطار میں نیلا فیروزہ، نیلم اَور ہیرا، ");
INSERT INTO urdoucv_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","اَور تیسری قطار میں لشم، یَشب اَور زُمُرّد ");
INSERT INTO urdoucv_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","اَور چوتھی قطار میں پکھراج اَور سنگِ سُلیمانی اَور سنگِ یَشب۔ یہ سَب نقش کندہ کئے ہویٔے سونے کے خانوں میں جڑے گیٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","یہ پتّھر تعداد میں اِسرائیل کے ہر ایک بیٹوں کے ناموں کے مُطابق بَارہ تھے جِن پر ایک انگُشتری کے نقش کی طرح ہر ایک پر بَارہ قبیلوں کے نام کندہ کئےگئے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","اَور اُنہُوں نے سینہ بند کے لیٔے بٹی ہُوئی ڈوری کی طرح خالص سونے کی دو زنجیریں بنائیں ");
INSERT INTO urdoucv_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","اَور اُنہُوں نے سونے کے دو خانے اَور سونے کے دو کڑے بنائے اَور اُن کڑوں کو سینہ بند کے دونوں کونوں پر لگا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","اَور اُنہُوں نے سونے کی اُن دونوں زنجیروں کو سینہ بند کے دونوں کونوں پر لگے اُن دونوں کڑوں کے ساتھ باندھ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","اَور اُن زنجیروں کے دونوں سِروں کو اُن دونوں چوکھٹوں کے ساتھ باندھ کر افُود کے دونوں کندھوں والی پٹّیوں سے جوڑ کر سامنے لٹکا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","اَور اُنہُوں نے سونے کے دو اَور کڑے بنائے اَور اُنہیں سینہ بند کے نیچے کے دونوں کونوں کو اُس حاشیہ میں لگایا جو افُود کے اَندر کی طرف تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","پھر اُنہُوں نے سونے کے دو اَور کڑے بنا کر اُنہیں کندھے کی پٹّیوں کے نِچلے حِصّہ سے باندھنا جو کہ افُود کے سامنے ہے اَور افُود کے کمربند کے بالکُل اُوپر لگا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","اُنہُوں نے سینہ بند کے کڑوں کو افُود کے کڑوں کے ساتھ نیلے رنگ کی ڈوری سے باندھ دیا اَور اُسے کمربند سے جوڑ دیا تاکہ سینہ بند افُود سے اِدھر اُدھر ہلنے نہ پایٔے جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","اَور اُنہُوں نے اُس افُود کا جُبّہ نیلے رنگ کے کپڑے سے بنایا جسے ایک ماہر جُلاہے نے بُنا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","اَور جُبّہ کا گریبان زرہ کے گریبان کی طرح بیچ میں تھا اَور اُس کے اطراف بُنی ہُوئی گوٹ لگی ہُوئی تھی تاکہ وہ پھٹ نہ جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","اَور اُنہُوں نے نیلے اَرغوانی اَور سُرخ رنگ کے دھاگے اَور نفیس بٹے ہویٔے کتان سے جُبّہ کے گھیر میں چاروں طرف انار بنائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","پھر اُنہُوں نے خالص سونے کی گھنٹیاں بنائیں اَور اُنہیں جُبّہ کے دامن کے گھیر میں چاروں طرف اناروں کے درمیان لگا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","اَور وہ ایک گھنٹی اَور ایک انار خدمت کے وقت پہنے جانے والے جُبّہ کے دامن کے گھیر میں سے چاروں طرف ایک گھنٹی اَور ایک انار کی ترتیب سے لگے ہویٔے تھے جَیسا یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","اَور اَہرونؔ اَور اُس کے بیٹوں کے لیٔے اُنہُوں نے نفیس کتان سے بُنے کُرتے بنائے ");
INSERT INTO urdoucv_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","اَور کتان کا عمامہ، سَر کا پٹکا اَور نفیس بٹے ہویٔے کتان کے پاجامے بنائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","اَور کمربند نفیس بٹے ہویٔے کتان اَور نیلے، اَرغوانی اَور سُرخ رنگ کے کپڑے کا تھا جِس پر بیل بُوٹے کشیدہ کئے گیٔے تھے جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","اُنہُوں نے تاج کی ایک تختی خالص سونے کا بنایا اَور اُس پر ایک انگُشتری کے نقش کی طرح یہ کندہ کیا: یَاہوِہ کے لیٔے مُقدّس۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","اَور پھر اُنہُوں نے اُسے ایک نیلے رنگ کی ڈوری سے عمامہ پر جوڑ دیا جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","اِس طرح مَسکن کے خیمہ اِجتماع کا سَب کام اَنجام تک پہُنچا اَور بنی اِسرائیل نے سَب کچھ وَیسے ہی کیا جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","پھر وہ اُس مَسکن کو مَوشہ کے پاس لایٔے: یعنی خیمہ اَور اُس کا سارا سامان، اُس کے تُکمے، تختے، بینڈے، سُتون اَور پایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","اَور مینڈھوں کی سُرخ رنگی ہُوئی کھالوں کا غلاف دریائی بچھڑوں کی کھالوں کا غلاف اَور بیچ کا پردہ، ");
INSERT INTO urdoucv_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","عہد کے صندُوق اَور اُس کی بَلّیاں اَور کفّارہ کا سرپوش، ");
INSERT INTO urdoucv_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","میز اَور اُس کے تمام ظروف اَور نذر کی روٹی، ");
INSERT INTO urdoucv_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","خالص سونے کا چراغدان مع چراغوں کے جو قطاروں میں رکھے تھے اَور اُس کے تمام لوازمات اَور جَلانے کے لیٔے زَیتُون کا تیل، ");
INSERT INTO urdoucv_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","سونے کا مذبح اَور مَسح کرنے کا زَیتُون کا تیل، خُوشبودار بخُور، خیمہ کے مدخل کا پردہ، ");
INSERT INTO urdoucv_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","کانسے کا مذبح اَور اُس کا کانسے کا جنگلہ، اُس کی بَلّیاں اَور اُس کے تمام ظروف۔ لگن اَور اُس کی چوکی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","صحن کے پردے اَور اُن کی بَلّیاں اَور پایٔے اَور صحن کے مدخل کے لیٔے پردہ، اُن کی رسّیاں اَور صحن کے لیٔے خیمہ کی میخیں اَور مَسکن کے خیمہ اِجتماع کے لیٔے سارا سامان۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","اَور پاک مَقدِس میں خدمت کرتے وقت پہننے کے لیٔے بُنے ہویٔے مُقدّس لباس۔ اَور اَہرونؔ کاہِنؔ اَور اُس کے بیٹوں کے لیٔے جَب وہ بطور کاہِنؔ کے طور پر خدمت اَنجام دیتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","بنی اِسرائیل نے سارا کام وَیسے ہی کیا تھا جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","مَوشہ نے اُس کام کا جائزہ لیا اَور دیکھا کہ اُنہُوں نے اُسے وَیسے ہی کیا تھا جَیسے یَاہوِہ نے حُکم دیا تھا۔ تَب مَوشہ نے اُنہیں برکت دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","اَور یَاہوِہ نے مَوشہ سے فرمایا: ");
INSERT INTO urdoucv_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","”پہلے مہینے کی پہلی تاریخ کو تُم مَسکن کا خیمہ اِجتماع کھڑا کردینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","اَور اُس میں عہد کا صندُوق رکھ دینا اَور اُس کی حِفاظت کے لیٔے بیچ کا پردہ کھینچ دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","اَور میز کو اَندر لاکر اُس کے لوازمات اُس پر ترتیب سے رکھ دینا۔ پھر چراغدان کو اَندر لاکر اُس کے چراغ رَوشن کردینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","اَور سونے کی بخُور کے مذبح کو عہد کے صندُوق کے سامنے رکھ دینا اَور مَسکن کے دروازہ پر پردہ لگادینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","”سوختنی نذر کی قُربانی کے مذبح کو مَسکن کے خیمہ اِجتماع کے سامنے رکھ دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","لگن کو خیمہ اِجتماع اَور مذبح کے درمیان رکھ کر اُس میں پانی بھر دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","اَور اُس کے صحن کو چاروں طرف سے گھیر کر اُس کے مدخل پر پردہ لگادینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","”مَسح کرنے والا زَیتُون کا تیل لینا اَور اُسے مَسکن کے خیمہ اِجتماع اَور اُس کے اَندر کے سَب ظروف پر چھڑک کر اُس کی اَور اُس کے سارے سامان کی تقدیس کرنا۔ تَب وہ مُقدّس ٹھہرے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","پھر سوختنی نذر کی قُربانی کے مذبح کو اَور اُس کے تمام ظروف کو مَسح کرکے مذبح کی تقدیس کرنا، اَور تَب وہ نہایت ہی مُقدّس ٹھہرے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","تَب لگن اَور اُس کی چوکی کو مَسح کرکے اُن کی تقدیس کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","”اَہرونؔ اَور اُس کے بیٹوں کو خیمہ اِجتماع کے دروازہ پر لاکر اُنہیں پانی سے غُسل دِلانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","تَب اَہرونؔ کو مُقدّس لباس پہناکر اُسے مَسح کرنا اَور اُس کی تقدیس کرنا تاکہ وہ بطور کاہِنؔ میری خدمت کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","اَور اُس کے بیٹوں کو لاکر اُنہیں کُرتے پہنانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","اَور جِس طرح تُم اُن کے باپ کو مَسح کروگے وَیسے ہی اُن کو مَسح کرنا تاکہ وہ بطور کاہِنؔ میرے لیٔے خدمت اَنجام دیں۔ اُن کا مَسح کیاجانا اَیسی کہانت کے لیٔے ہوگا جو آنے والی تمام نَسلوں میں اَبد تک جاری رہے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","مَوشہ نے سَب کچھ وَیسے ہی کیا، جَیسا کہ یَاہوِہ نے اُنہیں حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","پس دُوسرے سال کے پہلے مہینے کی پہلی تاریخ کو مَسکن کھڑا کیا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","اَور جَب مَوشہ نے مَسکن کو کھڑا کیا تو اُنہُوں نے پایوں کو اُن کی جگہ پر قائِم کیا چوکھٹے بنائے اَور اُن کے بینڈے لگا کر سُتون کھڑے کر دئیے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","پھر مَوشہ نے مَسکن پر خیمہ تان دیا اَور اُس کے اُوپر غلاف چڑھا دیا جَیسا کہ یَاہوِہ نے اُنہیں حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","اُنہُوں نے شہادت کی تختیوں کو لے کر صندُوق میں رکھ دیا اَور بَلّیوں کو صندُوق میں لگا دیا اَور کفّارے کے سرپوش کو اُس کے اُوپر ٹِکا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","اَور پھر مَوشہ اُس صندُوق کو مَسکن میں لائے اَور بیچ کے پردہ کو لگا کر عہد کے صندُوق کو محفوظ کر دیا جَیسا کہ یَاہوِہ نے اُنہیں حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","مَوشہ نے اُس میز کو خیمہ اِجتماع میں مَسکن کی شمالی جانِب پردہ کے باہر رکھ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","اَور مَوشہ پر یَاہوِہ کے رُوبرو روٹی سجا کر رکھ دی، جَیسا کہ یَاہوِہ نے اُنہیں حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","مَوشہ نے چراغدان کو خیمہ اِجتماع میں مَسکن کی جُنوبی سمت میں میز کے سامنے رکھ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","اَور چراغوں کو یَاہوِہ کے رُوبرو رَوشن کر دیا جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","مَوشہ نے سونے کے بنے ہُوئے مذبح کو خیمہ اِجتماع میں اُس پردہ کے سامنے رکھ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","اَور اُس پر خُوشبودار بخُور جَلائی جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","اَور پھر اُنہُوں نے مَسکن کے دروازہ پر پردہ لگا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","مَوشہ نے سوختنی نذر کی قُربانی کا مذبح مَسکن کے خیمہ اِجتماع کے دروازہ پر رکھ کر اُس پر سوختنی نذریں اَور اناج کی نذریں چڑھائیں جَیسا کہ یَاہوِہ نے اُنہیں حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","اُنہُوں نے لگن کو خیمہ اِجتماع اَور اُس مذبح کے درمیان رکھ کر اُس میں دھونے کے لیٔے پانی بھر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","اَور مَوشہ اَور اَہرونؔ اَور اُس کے بیٹوں نے اُسے اَپنے ہاتھ پاؤں دھونے کے لیٔے اِستعمال کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","اَور جَب بھی وہ خیمہ اِجتماع میں داخل ہوتے یا مذبح کے قریب جاتے تو وہ اَپنے ہاتھ پاؤں دھوکر جاتے جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","پھر مَوشہ نے مَسکن اَور مذبح کے اِردگرد صحن کو گھیر کر صحن کے دروازہ کا پردہ ڈال دیا اَور یُوں مَوشہ نے اُس کام کو ختم کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","تَب خیمہ اِجتماع پر بادل چھا گیا اَور پاک مَسکن یَاہوِہ کے جلال سے معموُر ہو گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","اَور مَوشہ خیمہ اِجتماع میں داخل نہ ہو سکے کیونکہ وہ بادل اُن پر ٹھہرا ہُوا تھا اَور مَسکن یَاہوِہ کے جلال سے معموُر تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","اَور بنی اِسرائیل کے سارے سفر میں جَب کبھی وہ بادل اُس مَسکن کے اُوپر سے چھٹ جاتا تو وہ آگے بڑھتے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","لیکن اگر وہ بادل سایہ ڈالے رہتا تو وہ اُس کے چھٹ جانے کے دِن تک سفر نہ کرتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","یَاہوِہ کا بادل تمام بنی اِسرائیل کے گھرانے کے سارے سفر کے دَوران اُن کی نظروں کے سامنے دِن کو مَسکن کے اُوپر چھایا رہتا تھا، اَور رات کو بادل میں آگ ہوتی تھی۔");
INSERT INTO urdoucv_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","یَاہوِہ نے خیمہ اِجتماع سے مَوشہ کو بُلایا۔ اَور اُن سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","”اِسرائیلیوں سے مُخاطِب ہو اَور اُن کو حُکم دو: ’جَب تُم میں سے کوئی اِنسان یَاہوِہ کے لیٔے کویٔی نذر لایٔے، تو وہ اَپنے گلّے میں سے گائے بَیل یا بھیڑ بکری کی قُربانی دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","” ’اگر وہ نذر گلّہ کا جانور ہو تو وہ بے عیب نر ہو اَور لازِم ہے کہ نذر لانے والا اُسے خیمہ اِجتماع کے مدخل پر سوختنی نذر کے طور پر نذر کرے تاکہ وہ یَاہوِہ کے حُضُور مقبُول ٹھہرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","اَور وہ سوختنی نذر کے جانور کے سَر پر اَپنا ہاتھ رکھے اَور وہ اُس کی جانِب سے اُس کے لیٔے بطور کفّارہ قبُول ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","اَور وہ اُس بچھڑے کو یَاہوِہ کے حُضُور ذبح کرے اَور پھر اَہرونؔ کے بیٹے جو کاہِنؔ ہیں اُس کا خُون لائیں اَور اُسے خیمہ اِجتماع کے مدخل پر مذبح کے چاروں طرف چھڑک دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","پھر وہ سوختنی نذر کے اُس جانور کی کھال اُتاریں اَور اُسے ٹُکڑوں میں کاٹیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","اَور اَہرونؔ کے بیٹے جو کاہِنؔ ہیں مذبح پر آگ رکھیں اَور اُس آگ پر ترتیب سے لکڑیاں سجا کر رکھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","پھر اَہرونؔ کے بیٹے جو کاہِنؔ ہیں اُن ٹُکڑوں کو سَر اَور چربی سمیت جلتی لکڑیوں پرجو مذبح پر ہیں ترتیب سے رکھ دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","اَور لیکن تُم اُس جانور کی آنتوں اَور پیروں کو پانی سے دھونا اَور پھر کاہِنؔ اِن سبھی کو مذبح پر جَلائے تاکہ یہ سوختنی نذر یہ یَاہوِہ کے حُضُور غِذا کی فرحت بخش خُوشبو والی آتِشی نذر ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","” ’اَور اگر اُس کی نذر گلّے کی ہو یعنی بھیڑ یا بکریوں میں سے سوختنی نذر ہو، تو وہ بے عیب نر کی قُربانی دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","وہ اُسے یَاہوِہ کے حُضُور میں مذبح کی شمالی سمت ذبح کرے اَور اَہرونؔ کے بیٹے جو کاہِنؔ ہیں، اُس کا خُون مذبح کے چاروں طرف چھڑک دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","پھر وہ اُسے کاٹ کر اُس کے ٹکڑے کریں اَور کاہِنؔ اُن ٹُکڑوں کو سَر اَور چربی سمیت مذبح پر جلتی لکڑیوں پر ترتیب سے رکھ دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","لیکن وہ آنتوں اَور پیروں کو پانی سے دھولیں۔ تَب کاہِنؔ سَب کو لے کر مذبح پر جَلا دے تاکہ یہ سوختنی نذر یَاہوِہ کے حُضُور غِذا کی فرحت بخش خُوشبو والی آتِشی قُربانی ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","” ’اگر اُس کی نذر یَاہوِہ کے لیٔے پرندوں کی سوختنی نذر ہے تو وہ قُمریوں یا کبُوتر کا بچّہ نذر کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","اَور کاہِنؔ اُسے مذبح پر لاکر اُس کا سَر مروڑ ڈالے، اَور اُسے مذبح پر جَلا دے لیکن اُس کے خُون کو مذبح کے پہلو پر ٹپک جانے دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","اَور اُس کے گلے کی تھیلی بال اَور پَر سمیت نکال لے اَور اُسے لے جا کر مذبح کی مشرقی جانِب کی طرف راکھ ڈالنے کی جگہ میں پھینک دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","پھر وہ اُس کے دونوں بازوؤں کو پکڑکر اُسے چیرے لیکن الگ الگ نہ کرے اَور کاہِنؔ اِن سبھی کو سوختنی نذر کے واسطے مذبح کی آگ پر جَلا دے۔ یہ سوختنی نذر، یَاہوِہ کے حُضُور غِذا کی فرحت بخش خُوشبو والی آتِشی قُربانی ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","” ’جَب کویٔی یَاہوِہ کے لیٔے اناج کی نذر پیش کرے تو وہ مَیدہ لاکر نذر کرے اَور اُس میں زَیتُون کا تیل ڈال کر اُس کے اُوپر لوبان رکھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","وہ اُسے اَہرونؔ کے بیٹوں کے پاس جو کاہِنؔ ہیں لایٔے۔ تَب کاہِنؔ زَیتُون کے تیل سے گُندھے ہویٔے مَیدہ میں سے مُٹّھی بھر مَیدہ لوبان سمیت لے کر اُسے نذر کی قُربانی کی یادگاری حِصّہ کے طور پر کے طور پر مذبح کے اُوپر جَلایٔے۔ یہ یَاہوِہ کے حُضُور غِذا کی فرحت بخش خُوشبو والی آتِشی قُربانی ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","اُس اناج کی نذر میں سے جو کچھ باقی رہ جائے وہ اَہرونؔ اَور اُس کے بیٹوں کا ہوگا۔ یہ یَاہوِہ کو پیش کی جانے والی غِذا کی آتِشی قُربانیوں کا پاک ترین حِصّہ ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","” ’اگر تُم تنور میں پکائے ہویٔے اناج کی نذر لایٔے تو وہ سَب سے بہترین مَیدہ کا بنا ہو اَور زَیتُون کے تیل میں گندھی ہویٔی، بے خمیری کُلچے یا زَیتُون کے تیل سے چُپڑی ہُوئی بے خمیری چپاتیاں ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","اَور اگر تیرے اناج کی نذر توے پر پکائی گئی ہو تو وہ زَیتُون کے تیل میں گوندھے ہویٔے بے خمیری مَیدہ کی ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","چونکہ وہ اناج کی نذر ہے اِس لیٔے تُم اُسے ٹکڑے ٹکڑے کرکے اُس پر زَیتُون کا تیل ڈالنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","اگر تیری قُربانی کڑاہی میں پکی ہُوئی اناج کی نذر ہو تو وہ بہترین مَیدہ اَور زَیتُون کے تیل سے بنائی جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","تُم اِن چیزوں کی بنی ہُوئی اناج کی نذر یَاہوِہ کے حُضُور لاکر کاہِنؔ کو پیش کرنا تاکہ وہ اُسے مذبح کے پاس لے کر آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","اَور کاہِنؔ اُس اناج کی نذر میں سے یادگاری حِصّہ لے کر اُسے بطور آتِشی قُربانی مذبح پر جَلایٔے جو یَاہوِہ کے حُضُور غِذا کی فرحت بخش خُوشبو والی آتِشی قُربانی ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","اُس اناج کی نذر میں سے جو کچھ باقی رہ جائے وہ اَہرونؔ اَور اُس کے بیٹوں کا ہوگا؛ یہ یَاہوِہ کو پیش کی جانے والی غِذا کی آتِشی قُربانیوں کا پاک ترین حِصّہ ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","” ’اَور کویٔی بھی اناج کی نذر جو یَاہوِہ کے حُضُور لائی جائے وہ خمیر کے بغیر ہو۔ کیونکہ تُم یَاہوِہ کو غِذا کی آتِشی قُربانی پیش کرتے وقت اُس میں خمیر اَور شہد مِلا کر کبھی مت جَلانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","تُم اِنہیں پہلے پھلوں کی نذر کے طور پر یَاہوِہ کے حُضُور لا سکتے ہو لیکن وہ بطور فرحت بخش خُوشبو مذبح پر نذر نہ کی جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","اَور تُم اَپنی سَب اناج کی نذر والی قُربانیوں میں نمک ڈالنا۔ کیونکہ نمک اُس عہد کی نُمائندگی کرتا ہے جو تمہارے خُدا نے تمہارے ساتھ باندھا ہے۔ اَپنی ساری نذریں نمک کے ساتھ ہی پیش کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","” ’اَور اگر تُم اناج کے پہلے پھلوں کی نذر یَاہوِہ کے حُضُور لاؤ تو اُن کی بالیں مسل کر دانے نکالنا اَور اُنہیں آگ میں بھُون کر نذر کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","اَور اُس پر زَیتُون کا تیل اَور لوبان ڈالنا؛ یہ اناج کی نذر ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","اَور کاہِنؔ یادگاری حِصّہ مسل کر نکالے ہویٔے اناج کے دانوں، زَیتُون کے تیل اَور سارے لوبان کے ساتھ جَلا دے تاکہ یہ یَاہوِہ کے لیٔے غِذا کی آتِشی قُربانی کی نذر ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","” ’اگر کسی کی سلامتی کی نذر ہو اَور وہ ریوڑ میں سے کسی جانور یعنی گائے یا بَیل کی قُربانی کرتا ہے، چاہے وہ نر ہو یا مادہ تو وہ ضروُر بے عیب جانور کو ہی یَاہوِہ کے حُضُور قُربان کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","اَور وہ اَپنا ہاتھ اَپنی نذر کے جانور کے سَر پر رکھے اَور خیمہ اِجتماع کے مدخل پر اُسے ذبح کرے۔ اَور پھر اَہرونؔ کے بیٹے جو کاہِنؔ ہیں، اُس کے خُون کو مذبح کے چاروں طرف چھڑک دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","اَور وہ سلامتی کی نذر کی قُربانی میں سے یَاہوِہ کے لیٔے غِذا کی آتِشی نذر کی قُربانی گذرانے یعنی وہ تمام چربی جو آنتوں کو ڈھانپتی ہے اَور وہ چربی جو آنتوں پر لپٹی ہُوئی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","اَور دونوں گُردوں کے ساتھ اُن کی چربی جو کمر کے قریب رہتی ہے اَور جگر کے اُوپر کی جھِلّی، اُنہیں وہ گُردوں کے ساتھ ہی الگ کر دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","پھر اَہرونؔ کے بیٹے اُنہیں مذبح پر سوختنی نذر کو جلتی ہوئی لکڑی کے اُوپر رکھ کر جَلائیں۔ یہ یَاہوِہ کے حُضُور غِذا کی فرحت بخش خُوشبو والی آتِشی قُربانی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","” ’اَور اگر تُم اَپنے گلّے کی بھیڑ بکریوں میں سے کویٔی جانور سلامتی کی نذر کی قُربانی کے طور پر یَاہوِہ کے حُضُور قُربان کرو تو وہ بے عیب نر یا مادہ کی قُربانی کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","اَور اگر وہ قُربانی کے لیٔے برّہ نذر کرنا چاہے تو وہ اُسے یَاہوِہ کے حُضُور لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","اَور وہ قُربانی والے جانور کے سَر پر اَپنا ہاتھ رکھے اَور اُسے خیمہ اِجتماع کے سامنے ذبح کرے۔ اَور پھر اَہرونؔ کے بیٹے اُس کے خُون کو مذبح کے چاروں طرف چھڑک دیں ");
INSERT INTO urdoucv_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","اَور وہ سلامتی کی نذر کی قُربانی میں سے یَاہوِہ کے لیٔے بطور غِذا آتِشی نذر پیش کرے یعنی اُس کی پُوری چربی بھری دُم کو ریڑھ کی ہڈّی سے الگ کرے اَور وہ تمام چربی جو آنتوں کو ڈھانپتی ہے اَور وہ چربی جو آنتوں پر لپٹی رہتی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","اَور دونوں گُردوں کے ساتھ اُن کی چربی جو کمر کے قریب رہتی ہے اَور جگر کے اُوپر کی جھِلّی، اُنہیں وہ گُردوں کے ساتھ ہی الگ کر دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","اَور کاہِنؔ اُن کو بطور غِذا مذبح پر جَلائے۔ یہ یَاہوِہ کے لیٔے ایک آتِشی قُربانی ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","” ’اگر اُس کی نذر بکرا یا بکری ہو تو وہ اُسے یَاہوِہ کے حُضُور لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","اَور اَپنا ہاتھ اُس کے سَر پر رکھے اَور اُسے خیمہ اِجتماع کے سامنے ذبح کرے۔ اَور اَہرونؔ کے بیٹے اُس کا خُون مذبح پر چاروں طرف چھڑک دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","اَورجو کچھ وہ نذر کرے اُس میں سے وہ یَاہوِہ کے لیٔے یہ بطور غِذا کی آتِشی قُربانی پیش کرے: وہ تمام چربی جو آنتوں کو ڈھانپتی ہے اَور وہ چربی جو آنتوں پر لپٹی رہتی ہے، ");
INSERT INTO urdoucv_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","اَور دونوں گُردوں کے ساتھ اُن کی چربی جو کمر کے قریب رہتی ہے اَور جگر کے اُوپر کی جھِلّی، اُنہیں وہ گُردوں کے ساتھ ہی الگ کر دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","اَور کاہِنؔ اُن کو مذبح پر ایک آتِشیں اَور فرحت بخش خُوشبو والی غِذا کی نذر کے طور پر جَلا دے۔ ساری چربی یَاہوِہ کے لیٔے ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","” ’اَور جہاں بھی تُم رہو تمہاری آئندہ نَسلوں کے لیٔے یہ ایک دائمی قانُون ہوگا کہ تُم چربی اَور خُون ہرگز نہ کھانا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","اَور یَاہوِہ نے مَوشہ سے فرمایا: ");
INSERT INTO urdoucv_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","”بنی اِسرائیل کو حُکم دے اگر کویٔی اِنسان غَیر اِرادی طور پر گُناہ کرتا ہے اَور اُن کاموں کو کرتا ہے جسے یَاہوِہ کے اَحکام میں منع کیا گیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","” ’اگر کویٔی ممسوح کاہِنؔ اَیسی خطا کرے جِس سے پُوری اُمّت مُجرم ٹھہرتی ہو تو، وہ اَپنی اُس خطا کے لیٔے جو اُس نے کی ہے، ایک بے عیب بچھڑا گُناہ کی قُربانی کے طور پر یَاہوِہ کے حُضُور گذرانے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","اَور وہ اُس بچھڑے کو خیمہ اِجتماع کے مدخل پر یَاہوِہ کے حُضُور لایٔے اَور اُس کے سَر پر اَپنا ہاتھ رکھے اَور اُسے یَاہوِہ کے حُضُور ذبح کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","اَور پھر وہ ممسوح کاہِنؔ اُس بچھڑے کے خُون میں سے کچھ خُون لے کر خیمہ اِجتماع کے اَندر لے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","اَور کاہِنؔ اُس خُون میں اَپنی اُنگلی ڈُبو ڈُبو کر اُس خُون میں سے کچھ پاک مَقدِس کے پردہ کے سامنے یَاہوِہ کے حُضُور سات بار چھڑکے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","پھر کاہِنؔ اُسی خُون میں سے کچھ خُون لے کر اُسے خُوشبودار بخُور جَلانے کی نذر کے مذبح کے سینگوں پر لگائے جو خیمہ اِجتماع میں یَاہوِہ کے حُضُور ہے اَور اُس بچھڑے کے باقی سَب خُون کو سوختنی نذر کی قُربانی کے اُس مذبح کے پایہ پرجو خیمہ اِجتماع کے مدخل پر ہے اُنڈیل دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","پھر وہ گُناہ کی قُربانی کے بچھڑے کی تمام چربی کو اُس سے الگ کرے یعنی وہ چربی جو آنتوں پر لپٹی رہتی ہے، ");
INSERT INTO urdoucv_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","اَور دونوں گُردوں کے ساتھ اُن کی چربی جو کمر کے قریب رہتی ہے اَور جگر کے اُوپر کی جھِلّی، اُنہیں وہ گُردوں کے ساتھ ہی الگ کر دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","بالکُل وَیسے ہی جَیسا کہ اُس بچھڑے کی چربی الگ کی جاتی ہے جو سلامتی کی نذر کی قُربانی کے طور پر قُربان کیا جاتا ہے۔ پھر کاہِنؔ اُن کو سوختنی نذر کو قُربانی کے مذبح پر جَلا دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","لیکن اُس بچھڑے کی کھال اَور اُس کا تمام گوشت، سَر اَور پایٔے، انتڑیاں اَور گوبر ");
INSERT INTO urdoucv_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","یعنی باقی کا سارا بچھڑا لازماً چھاؤنی سے باہر کسی رسماً پاک جگہ پر جہاں قُربانیوں کی راکھ پھینکی جاتی ہے، لے کر جائے اَور اُسے راکھ کے ڈھیر پر لکڑیوں کی آگ میں جَلا دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","” ’اَور اگر بنی اِسرائیل کی ساری جماعت غَیر اِرادی طور پر گُناہ کرے اَور اُس کام کو کرے جنہیں یَاہوِہ کے اَحکام میں منع کیا گیا ہے، اَور جماعت اُس بات سے بے خبر ہو تو بھی وہ لوگ خطاوار ہیں؛ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","اَور جَب وہ اُس گُناہ سے واقف ہو جایٔیں تو جماعت لازماً گُناہ کی قُربانی کے طور پر ایک بچھڑا خیمہ اِجتماع کے سامنے لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","اَور جماعت کے بُزرگ اَپنے اَپنے ہاتھ یَاہوِہ کے حُضُور اُس بچھڑے کے سَر پر رکھیں اَور وہ بچھڑا یَاہوِہ کے حُضُور ذبح کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","اَور پھر ممسوح کاہِنؔ اُس بچھڑے کے خُون میں سے کچھ خُون لے کر خیمہ اِجتماع میں لے جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","اَور کاہِنؔ اَپنی اُنگلی اُس خُون میں ڈُبو ڈُبو کر اُس خُون کو پاک مَقدِس کے پردہ کے سامنے یَاہوِہ کے حُضُور سات بار چھڑکے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","اَور وہ اُس خُون میں سے کچھ خُون اُس مذبح کے سینگوں پر لگائے جو خیمہ اِجتماع میں یَاہوِہ کے حُضُور ہے۔ اَور باقی کا خُون وہ سوختنی نذر کی قُربانی کے اُس مذبح کے پایہ پر اُنڈیل دے جو خیمہ اِجتماع کے مدخل پر ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","اَور اُس بچھڑے کی سَب چربی کو اُس سے الگ کرکے اُسے مذبح پر جَلا دے، ");
INSERT INTO urdoucv_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","اَور وہ اُس بچھڑے سے بالکُل وُہی کرے جَیسا اُس نے گُناہ کی قُربانی کے بچھڑے کے ساتھ کیا تھا۔ یُوں وہ کاہِنؔ جماعت کے لیٔے کفّارہ دے گا اَور وہ مُعاف کر دئیے جایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","پھر کاہِنؔ اُس بچھڑے کو چھاؤنی سے باہر لے جائے اَور اُسے جَلا دے جَیسا کہ اُس نے پہلے بچھڑے کو جَلایا تھا۔ اَور یہ جماعت کے لیٔے گُناہ کی قُربانی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","” ’اَور جَب کویٔی سربراہ غَیر اِرادی طور پر گُناہ کرے یعنی وہ کام کرے جو یَاہوِہ اُس کے خُدا کی اَحکام میں منع ہے، اَور جَب اُسے اَپنے مُجرم ہونے کا احساس ہو جائے، ");
INSERT INTO urdoucv_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","اَورجو گُناہ اُس نے کیا ہے ظاہر ہو جائے تو وہ لازماً قُربانی کے لیٔے بکریوں میں سے ایک بے عیب بکرا لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","اَور اَپنا ہاتھ اُس بکرے کے سَر پر رکھے اَور اُسے اُس جگہ ذبح کرے جہاں سوختنی نذر کے جانور یَاہوِہ کے حُضُور ذبح کئے جاتے ہیں۔ یہ گُناہ کی قُربانی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","اَور پھر کاہِنؔ گُناہ کی قُربانی کا کچھ خُون اَپنی اُنگلی پر لے کر اُسے سوختنی نذر کی قُربانی کے مذبح کے سینگوں پر لگائے اَور اُس کا باقی سَب خُون مذبح کے پایہ پر اُنڈیل دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","اَور تمام چربی کو مذبح پر جَلا دے جَیسے اُس نے سلامتی کی نذر کی چربی کو جَلایا تھا۔ اِس طرح کاہِنؔ اُس سربراہ کے گُناہ کا کفّارہ دے گا اَور اُسے مُعافی مِل جائے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","” ’اَور اگر جماعت کا کویٔی عام اِنسان غَیر اِرادی طور پر گُناہ کرے اَور اَیسا کام کرے جسے یَاہوِہ کے اَحکام میں منع کیا گیا ہے، اَور جَب اُسے اَپنے مُجرم ہونے کا احساس ہو جائے، ");
INSERT INTO urdoucv_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","اَورجو گُناہ اُس نے کیا ہے ظاہر ہو جائے تو وہ لازماً قُربانی کے لیٔے ایک بے عیب بکری لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","اَور وہ اَپنا ہاتھ گُناہ کی قُربانی کے جانور کے سَر پر رکھے اَور اُسے سوختنی نذر کی جگہ پر ذبح کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","اَور پھر کاہِنؔ اُس خُون میں سے کچھ خُون اَپنی اُنگلی پر لے کر اُسے سوختنی نذر کی قُربانی کے مذبح کے سینگوں پر لگائے اَور باقی کا خُون مذبح کے پایہ پر اُنڈیل دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","اَور کاہِنؔ اُس کی تمام چربی کو الگ کر دے بالکُل اُسی طرح جَیسا کہ سلامتی کی نذر کی چربی الگ کی جاتی ہے اَور اُسے مذبح پر رکھ کر یَاہوِہ کے لیٔے فرحت بخش خُوشبو کے طور پر جَلا دے۔ اِس طرح کاہِنؔ اُس اِنسان کے لیٔے کفّارہ دے گا اَور اُسے مُعافی مِل جائے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","” ’اَور اگر وہ اِنسان بطور گُناہ کی قُربانی کویٔی برّہ لایٔے تو وہ بے عیب مادہ لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","اَور وہ اَپنا ہاتھ اُس کے سَر پر رکھے اَور وہ اُسے گُناہ کی قُربانی کے طور پر اُس جگہ ذبح کرے جہاں سوختنی نذر ذبح کی جاتی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","اَور پھر کاہِنؔ گُناہ کی قُربانی کا کچھ خُون اَپنی اُنگلی پر لے کر اُسے سوختنی نذر کی قُربانی کے مذبح کے سینگوں پر لگائے اَور باقی سَب خُون مذبح کے پایہ پر اُنڈیل دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","اَور وہ اُس کی تمام چربی کو الگ کر دے بالکُل وَیسے ہی جَیسے سلامتی کی نذر کی قُربانی کے برّہ کی چربی الگ کی جاتی ہے۔ اَور کاہِنؔ اُسے مذبح پر یَاہوِہ کی غِذا کی آتِشی قُربانیوں کے اُوپر رکھ کر جَلا دے۔ اِس طرح کاہِنؔ اُس اِنسان کے گُناہ کے لیٔے کفّارہ دے گا اَور اُسے مُعافی مِل جائے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","” ’اَور اگر کویٔی اِس طرح گُناہ کرے کہ جو کچھ اُس نے دیکھا ہو یا جانتا ہو اُس کے متعلّق اُسے قَسم کھا کر گواہی دینے کے لیٔے کہا جائے اَور وہ گواہی نہ دے تو وہ اُس گُناہ کا ذمّہ وار ٹھہرایا جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","” ’یا اگر کویٔی اِنسان کسی اَیسی چیز کو چھُولے جو رسمی طور پر ناپاک سَمجھی جاتی ہو، خواہ وہ ناپاک جنگلی جانور، چَوپائے یا رینگنے والے ناپاک جاندار کی لاش ہو، اَور اگر وہ اُس سے بے خبر ہو کہ وہ ناپاک ہو گیا ہے، لیکن اِس کے بعد اُسے احساس ہو جاتا ہے تو وہ مُجرم ٹھہرے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","یا اگر وہ اِنسانی ناپاکی کی کسی اَیسی چیز کو نادانستہ چھُولے جو اُسے ناپاک کر دے لیکن اِس کے بعد اُسے اِس کا علم اَور احساس ہو جاتا ہے تو وہ مُجرم ٹھہرے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","یا اگر کویٔی اِنسان بغیر سوچے سمجھے، اَچھّا یا بُرا کچھ بھی کرنے کی قَسم کھالے یعنی کسی مُعاملہ میں لاپروائی سے قَسم کھالے خواہ وہ اُس سے بے خبر بھی ہو، تو بھی جَب اُسے اِس کا علم اَور احساس ہو جاتا ہے تو وہ مُجرم ٹھہرے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","جَب کویٔی اِنسان اِن باتوں میں سے کسی میں خطاوار ہونے کا احساس کرتا ہے، تو وہ لازماً اُس گُناہ کا اقرار کرے جو اُس نے کیا ہے، ");
INSERT INTO urdoucv_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","اَورجو گُناہ اُس سے سرزد ہُواہے اُس کی سزا کے طور پر وہ لازماً گلّہ میں سے ایک مادہ بھیڑ یا بکری گُناہ کی قُربانی کے طور پر یَاہوِہ کے حُضُور لایٔے اَور کاہِنؔ اُس کے گُناہ کا کفّارہ دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","” ’اَور اگر اُسے بھیڑ دینے کا مقدور نہ ہو تو وہ دو قُمریاں یا کبُوتر کے دو بچّے اَپنی گُناہ کی قُربانی کے طور پر یَاہوِہ کے حُضُور گذرانے یعنی ایک گُناہ کی قُربانی کے لیٔے اَور ایک سوختنی نذر کے لیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","وہ اُنہیں کاہِنؔ کے پاس لایٔے جو پہلے اُسے گُناہ کی قُربانی کے لیٔے گذرانے۔ وہ اُس کا سَر گردن کے پاس سے مروڑ ڈالے لیکن اُسے مُکمّل طور پر الگ نہ کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","اَور گُناہ کی قُربانی کا کچھ خُون مذبح کے اطراف کے مقابل چھڑک دے اَور باقی کا خُون مذبح کے پایہ پر بہہ جانے دے۔ یہ گُناہ کی قُربانی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","پھر کاہِنؔ دُوسرے پرندہ کو مُقرّرہ طریقہ کے مُطابق بطور سوختنی نذر گذرانے اَور اُس سے سرزد ہویٔے گُناہ کے لیٔے کفّارہ دے تو اُسے مُعافی مِل جائے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","” ’تاہم اگر اُسے دو قُمریاں یا کبُوتر کے دو بچّے لانے کا بھی مقدور نہ ہو تو وہ اَپنے گُناہ کے بدلے نذر کے طور پر ڈیڑھ کِلو مَیدہ گُناہ کی قُربانی کے لیٔے لایٔے اَور اُس پر تیل یا لوبان ہرگز نہ ڈالے کیونکہ یہ گُناہ کی قُربانی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","اَور وہ اُسے کاہِنؔ کے پاس لایٔے اَور کاہِنؔ اُس میں سے مُٹّھی بھر مَیدہ یادگاری حِصّہ کے طور پر لے کر اُسے یَاہوِہ کی باقی بطور غِذا آتِشی قُربانیوں کے ساتھ مذبح پر جَلایٔے۔ یہ گُناہ کی قُربانی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","اِس طرح کاہِنؔ اِن میں سے کسی بھی گُناہ کے لیٔے، جو اُس سے سرزد ہُواہے، اُس کا کفّارہ دے تو اُسے مُعافی ملے گی۔ اَور نذر کا باقی حِصّہ کاہِنؔ کا ہوگا جَیسا کہ اناج کی نذر کا ہوتاہے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","اَور یَاہوِہ نے مَوشہ سے فرمایا: ");
INSERT INTO urdoucv_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","”جَب کویٔی اِنسان یَاہوِہ کی پاک چیزوں میں سے کسی چیز کی بےحُرمتی کرکے غَیر اِرادی طور پر خطا کرے تو وہ بطور سزا گلّہ میں سے ایک بے عیب مینڈھا یَاہوِہ کے حُضُور گُناہ کی قُربانی کے طور پر لایٔے جِس کی مُناسب قیمت چاندی میں پاک مَقدِس کی ثاقل کے مُطابق ہو۔ یہ خطا کی قُربانی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","اَور اُس سے جِس پاک چیز کے بارے میں خطا ہُوئی ہو تو وہ لازماً اُس کا مُعاوضہ دے اَور اُس چیز کی قیمت کا پانچواں حِصّہ اَور بڑھا کر اُسے کاہِنؔ کو دے۔ اَور کاہِنؔ اُسے خطا کی قُربانی کے مینڈھے کے طور پر اُس کے لیٔے کفّارہ دے تو اُسے مُعافی ملے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","”اَور اگر کویٔی اِنسان گُناہ کرے اَور اُن کاموں میں سے کسی کام کو کرے جنہیں یَاہوِہ کے اَحکام میں منع کیا گیا ہے، خواہ وہ اُس سے بے خبر ہو تو بھی وہ مُجرم ٹھہرے گا اَور اَپنے گُناہ کا ذمّہ وار ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","پھر وہ خطا کی قُربانی کے لیٔے گلّہ میں سے مُناسب قیمت کا ایک بے عیب مینڈھا کاہِنؔ کے پاس لایٔے۔ یُوں کاہِنؔ اُس کی خاطِر اُس کی اُس خطا کے لیٔے جو غَیر اِرادی طور پر اُس سے سرزد ہُوئی کفّارہ دے تو اُسے مُعافی مِلے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","یہ خطا کی قُربانی ہے کیونکہ وہ یَاہوِہ کے قوانین کی خِلاف ورزی کے باعث مُجرم ٹھہرا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","”اگر کویٔی اَپنے پڑوسی کے خِلاف گُناہ کرے اَور یَاہوِہ سے دغا کرے اَور اَپنے پڑوسی کی اَمانت یا جو چیز اُس کے سُپرد کی گئی ہو، واپس نہ کرے، یا اَپنے پڑوسی کو لُوٹے یا اُس پر ظُلم کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","یا اگر اُسے کوئی کھوئی ہُوئی چیز مِل گئی ہو، لیکن وہ اُس کے متعلّق جھُوٹ بول کر لوگ جھُوٹی قَسم کھائے، یعنی اِن میں سے کسی بھی کام کو کرکے کویٔی گُناہ کرے؛ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","اَور اگر اُس سے اِس طرح کا کویٔی گُناہ ہُواہے اَور اِس کا احساس اُسے ہے تو وہ مُجرم ہے، تو جو کچھ اُس نے چُرایا ہے یا جبراً لے لیا ہے یا جو کچھ اُس کے پاس اَمانت کے طور پر رکھا گیا تھا یا جو کھوئی ہُوئی چیز اُسے مِل گئی تھی، ");
INSERT INTO urdoucv_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","یا جِس کسی بھی چیز کے بارے میں اُس نے جھُوٹی قَسم کھائی تھی، تو لازِم ہے کہ وہ اُسے پُورا واپس کرے اَور اصل کے ساتھ اُس کے مُعاوضہ کی قیمت کا بیس فیصد اِضافہ کے ساتھ اُس کے مالک کو اَپنی خطا کی قُربانی پیش کرنے کے دِن لَوٹا دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","تَب وہ بطور جُرمانہ گلّہ سے مُقرّرہ قیمت کا ایک بے عیب مینڈھا خطا کی قُربانی کے طور پر کاہِنؔ کے پاس یعنی یَاہوِہ کے حُضُور لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","اِس طرح کاہِنؔ یَاہوِہ کے حُضُور اُس کے لیٔے کفّارہ دے گا، اَور اِس طرح اُسے اُن تمام خطاؤں کی جو اُس نے کی ہیں جِن سے وہ مُجرم ٹھہرا ہے مُعافی مِل جائے گی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","”اَہرونؔ اَور اُس کے بیٹوں کو یہ حُکم دو، ’سوختنی نذر کے لیٔے ضوابط یہ ہیں: سوختنی نذر مذبح کے آتِشدان پر ساری رات صُبح ہونے تک رہے اَور مذبح پر آگ لازماً جلتی رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","اَور تَب کاہِنؔ اَپنا کتان کا لباس اَور اَپنے نیچے پاجامہ پہن کر مذبح پر آگ سے بھسم کی ہُوئی سوختنی نذر کی راکھ کو اُٹھاکر مذبح کے ایک طرف رکھ دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","اَور پھر اُن کپڑوں کو اُتار کر دُوسرا پہنے اَور اُس راکھ کو اُٹھاکر چھاؤنی سے باہر کسی رسماً پاک و صَاف جگہ لے جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","اَور مذبح پر آگ جلتی رہے اَور وہ کبھی بُجھنے نہ پایٔے۔ ہر صُبح کاہِنؔ مذبح پر لکڑیاں رکھے، اَور سوختنی نذر کو اُن پر رکھے، اَور اُس کے اُوپر سلامتی کی نذروں کی چربی رکھ کر جَلایا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","اَور مذبح پر آگ ہمیشہ جلتی رہے اَور کبھی بُجھنے نہ پایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","” ’اَور اناج کی نذر گذرانے کے ضوابط یہ ہیں: اَہرونؔ کے بیٹے اُسے مذبح کے سامنے یَاہوِہ کے حُضُور لائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","اَور کاہِنؔ اناج کی نذر میں سے مُٹّھی بھر مَیدہ اَور تیل اَور ساتھ ہی اُس پر رکھا ہُوا تمام لوبان لے کر اِس یادگاری حِصّہ کو یَاہوِہ کے لیٔے فرحت بخش خُوشبو کے طور پر مذبح پر جَلایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","اَور اُس میں سے جو باقی بچے اُسے اَہرونؔ اَور اُن کے بیٹے کھایٔیں۔ لیکن وہ بے خمیر کے پاک مَقدِس میں یعنی خیمہ اِجتماع کے صحن کے اَندر کھایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","اَور اُسے خمیر کے ساتھ پکایا نہ جایٔے۔ مَیں نے اِسے اَپنی بطور غِذا آتِشی قُربانیوں میں سے اُن کو حِصّہ کے طور پر دیا ہے۔ اَور یہ گُناہ کی قُربانی اَور خطا کی قُربانی کی مانند نہایت ہی پاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","اَور اَہرونؔ کی نَسل کے سارے مَرد اِسے کھا سکتے ہیں۔ اَور یَاہوِہ کو نذر کی گئی بطور غِذا آتِشی قُربانیوں میں سے پُشت در پُشت تمہاری پُشتوں کے لیٔے یہ اُن کے دائمی حِصّہ کے طور پر اَبد تک ملتا رہے گا۔ اَورجو کویٔی اِن قُربانیوں کو چھُوئے گا وہ پاک ہو جایٔےگا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","اَور یَاہوِہ نے مَوشہ سے یہ بھی فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","”جِس دِن اَہرونؔ کا مَسح کیا جائے اُس دِن وہ اَور اُن کے بیٹے یَاہوِہ کے حُضُور یہ نذر پیش کریں: ڈیڑھ کِلو مَیدہ اَور اُس کا آدھا صُبح اَور آدھا شام کو ہمیشہ اناج کی قُربانی کے طور پر لائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","اُسے تیل کے ساتھ مَل کر توے پر اَچھّی طرح پکانا اَور پھر تُم اُسے لاکر ٹکڑے ٹکڑے کرکے اُس اناج کی نذر کو یَاہوِہ کے حُضُور فرحت بخش خُوشبو کے طور پر نذر کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","اَور اَہرونؔ کے بیٹوں میں سے اُن کی جگہ پر جانشین کاہِنؔ کے طور پر جِس کا مَسح کیاجایٔے، وہ اُس نذر کو گزرانے۔ یہ یَاہوِہ کا دائمی حِصّہ ہے کہ اُسے بالکُل جَلا دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","اَور کاہِنؔ کی ہر ایک اناج کی قُربانی کو مُکمّل طور پر جَلا دیا جائے اَور اُسے کبھی کھایا نہ جائے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","”اَہرونؔ اَور اُن کے بیٹوں کو حُکم دے گُناہ کی قُربانی کے ضوابط یہ ہیں: گُناہ کی قُربانی کے جانور کو یَاہوِہ کے حُضُور اُسی جگہ ذبح کیا جائے جہاں سوختنی نذر کا جانور ذبح کیا جاتا ہے کیونکہ وہ نہایت ہی پاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","اَور اِس کو وُہی کاہِنؔ کھائے جو اِسے گُناہ کی قُربانی کے طور پر نذر گذرانے۔ اَور اِسے صرف پاک مَقدِس یعنی خیمہ اِجتماع کے صحن میں ہی کھایا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","جو بھی قُربانی کے اُس گوشت کو چھُوئے گا وہ پاک ٹھہرے گا۔ اَور اگر اُس کے خُون کی چھینٹیں کسی کپڑے پر پڑ جائے تو تُم اُسے لازماً اُسی پاک مَقدِس کی جگہ میں ہی دھونا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","اَور مٹّی کا وہ برتن جِس میں قُربانی کا گوشت پکایا جائے لازماً توڑ دیا جائے۔ لیکن اگر وہ کانسے کے برتن میں پکایا گیا ہو، تو اُس برتن کو مانج کر پانی سے دھو دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","اَور کاہِنؔ کے خاندان کا کویٔی بھی مَرد گُناہ کی قُربانی کا گوشت کھا سَکتا ہے۔ یہ نہایت ہی پاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","لیکن جِس گُناہ کی قُربانی کا خُون کفّارہ دینے کے لیٔے خیمہ اِجتماع کے پاک مقام میں لایا گیا ہو، اُس کا گوشت کبھی نہ کھایا جائے۔ بَلکہ اُسے آگ میں جَلا دیاجایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","” ’اَور خطا کی قُربانی کے لیٔے جو کہ نہایت مُقدّس ہے یہ ضوابط ہیں: ");
INSERT INTO urdoucv_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","خطا کی قُربانی کا جانور اُسی جگہ ذبح کیا جائے جہاں سوختنی نذر کا جانور ذبح کیا جاتا ہے اَور اُس کا خُون مذبح کے مقابل تمام اطراف میں چھڑک دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","اَور پھر اُس کی ساری چربی نذر گزرانی جائے یعنی اُس کی موٹی دُم اَور وہ چربی جو آنتوں کو ڈھانکتی ہے، ");
INSERT INTO urdoucv_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","اَور دونوں گُردوں کے ساتھ اُن کی چربی جو کمر کے قریب رہتی ہے اَور جگر کے اُوپر کی جھِلّی، اُنہیں وہ گُردوں کے ساتھ ہی الگ کر دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","اَور کاہِنؔ اُن کو یَاہوِہ کے لیٔے بطور غِذا آتِشی قُربانی مذبح پر جَلائے۔ یہ خطا کی قُربانی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","اَور کاہِنؔ کے گھرانے کا ہر مَرد اِسے کھا سَکتا ہے لیکن یہ کسی پاک مَقدِس کی جگہ میں ہی کھائی جائے؛ کیونکہ یہ نہایت ہی پاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","” ’اَور خطا کی قُربانی اَور گُناہ کی قُربانی دونوں کے لیٔے ایک ہی آئین عَمل میں لایا جائے اَور اُنہیں وُہی کاہِنؔ کھائے جو اِس کا کفّارہ دیتاہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","اَور وہ کاہِنؔ جو کسی اِنسان کے لیٔے سوختنی نذر پیش کرتا ہے وہ سوختنی نذر کے جانور کی کھال اَپنے لیٔے رکھ سَکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","اُسی طرح ہر ایک اناج کی قُربانی جو تنور یا کڑاہی میں یا توے پر پکائی گئی ہو، وہ سَب کُچھ اُسی کاہِنؔ کی ہوگی جو اُسے پیش کرتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","اَور ہر ایک اناج کی قُربانی خواہ اُس میں تیل مِلا ہو یا وہ خشک ہو اَہرونؔ کے سَب بیٹوں کو برابر حِصّہ ملے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","” ’اَور سلامتی کی نذر کی قُربانی کے لیٔے جسے کویٔی اِنسان یَاہوِہ کے حُضُور پیش کرے، یہ ضوابط ہیں: ");
INSERT INTO urdoucv_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","” ’اگر وہ اِسے شُکر گُزاری کے طور پر پیش کرے تَب وہ شُکر گزاری کی قُربانی کے ساتھ تیل سے گُندھے ہویٔے بے خمیری روٹی اَور تیل چُپڑی ہُوئی بے خمیری ٹکیاں اَور تیل سے اَچھّی طرح گُندھے ہویٔے مَیدے کی روٹیاں بھی گذرانے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","اَور شُکر گُزاری کی سلامتی کی نذر کی قُربانی کے ساتھ وہ خمیری ٹکیاں بھی نذر گزرانے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","اَور ہر قُربانی کی ایک ایک روٹی یَاہوِہ کے لیٔے نذرانہ کے طور پر لایٔے؛ اَور یہ اُسی کاہِنؔ کا ہوگا جو سلامتی کی نذر کا خُون مذبح پر چھڑکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","شُکر گُزاری کی سلامتی کی نذر کا گوشت کاہِنؔ کو اُسی دِن کھا لینا چاہیے جِس دِن وہ قُربانی پیش کرتا ہے اَور صُبح تک اُس میں سے کچھ بھی بچا کر نہ رکھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","” ’لیکن اگر اُس کی قُربانی کسی مَنّت کی یا رضا کی قُربانی ہو تو، وہ قُربانی اُسی دِن کھائی جائے جِس دِن وہ گذرانی جائے۔ اَور اگر کچھ بچ جایٔے تو اُسے اگلے دِن کھایا جا سَکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","لیکن جو کُچھ اُس قُربانی کے گوشت میں سے تیسرے دِن تک بچا رہ جایٔے تو وہ آگ میں جَلا دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","اِس لیٔے اگر وہ سلامتی کی نذر کا گوشت تیسرے دِن کھاتا ہے، تو وہ قُربانی قبُول نہ ہوگی اَور نہ ہی اُسے گذراننے والے کو اُس کا کویٔی اجر ملے گا کیونکہ وہ مکرُوہ ہے۔ اَورجو اِنسان اُس میں سے کچھ کھائے، تو اُس کا گُناہ اُسی کے سَر لگے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","” ’اَورجو گوشت کسی ناپاک چیز سے چھُو جائے، تو اُسے ہرگز نہ کھایا جائے۔ بَلکہ اُسے آگ میں جَلا دیا جائے اَور قُربانی کا دُوسرا گوشت، جو رسماً پاک ہے اُسے کھا سَکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","لیکن اگر کویٔی ناپاک اِنسان سلامتی کی نذر کی قُربانی کا کچھ گوشت کھائے جو یَاہوِہ کا حِصّہ ہے، تو اُس اِنسان کو لازماً اَپنے لوگوں میں سے خارج کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","اگر کویٔی اِنسان کسی ناپاک چیز کو چھُولے، چاہے وہ اِنسان کی ناپاکی ہو یا کویٔی ناپاک جانور کی یا کویٔی نجِس مکرُوہ شَے ہو، اَور سلامتی کی نذر کی قُربانی میں سے کچھ گوشت کھائے جو یَاہوِہ کا حِصّہ ہے، تو وہ اِنسان بھی لازماً اَپنے لوگوں میں سے خارج کیا جائے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","”بنی اِسرائیل سے کہو: ’تُم کسی بَیل، بھیڑ یا بکری کی چربی نہ کھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","جو جانور خُود بہ خُود مَرا ہُوا ہو یا اُسے جنگلی جانوروں نے پھاڑ ڈالا ہو، تُم اُس کی چربی کو دیگر کاموں کے لیٔے اِستعمال کر سکتے ہو لیکن تُم اُسے ہرگز نہ کھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","جو اِنسان اُس جانور کی چربی کھاتا ہے جسے یَاہوِہ کے لیٔے بطور غِذا آتِشی قُربانی پیش کی گئی ہو تو وہ اَپنے لوگوں میں سے خارج کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","اَور جہاں کہیں بھی تُم اَپنے گھر میں رہو وہاں تُم کسی پرندے یا جانور کا خُون ہرگز نہ کھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","اگر کویٔی اِنسان خُون کھائے تو وہ لازماً اَپنے لوگوں میں سے خارج کیا جائے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","”بنی اِسرائیل کو حُکم دو، ’جو کویٔی یَاہوِہ کے حُضُور سلامتی کی نذر گذرانے، وہ اُس کا ایک حِصّہ اَپنی قُربانی کے طور پر یَاہوِہ کے حُضُور گذرانے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","اَور وہ خُود اَپنے ہاتھوں میں یَاہوِہ کو بطور غِذا آتِشی قُربانی کے لیٔے چربی اَور سینہ ساتھ لایٔے اَور سینہ کو اُوپر اُٹھاکر یَاہوِہ کے حُضُور ہلانے کی نذر کی قُربانی کے طور پر پیش کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","کاہِنؔ اُس چربی کو مذبح پر جَلا دے لیکن وہ سینہ اَہرونؔ اَور اُس کے بیٹوں کا حِصّہ ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","اَور تُم اَپنی سلامتی کی نذروں کی قُربانی کی داہنی ران کاہِنؔ کو نذرانہ کے طور پر دے دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","اَور اَہرونؔ کے بیٹوں میں سے جو سلامتی کی نذر کا خُون اَور چربی گزرانے، تو قُربانی کی داہنی ران اُس کے حِصّہ کے طور پر اُسی کی ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","کیونکہ مَیں نے بنی اِسرائیل کی سلامتی کی نذروں میں سے ہلانے کی نذر کی قُربانی کا وہ سینہ اَور وہ ران جو نذر کی جاتی ہے، اُنہیں کاہِنؔ اَہرونؔ اَور اُن کے بیٹوں کو دے دیا ہے کہ وہ بنی اِسرائیل کی جانِب سے کاہِنؔ کا دائمی حِصّہ ہو۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","یہ یَاہوِہ کی بطور غِذا آتِشی قُربانیوں میں سے اَہرونؔ اَور اُن کے بیٹوں کے مَسح ہونے کا حِصّہ ہے جو اُس دِن مُقرّر کیا گیا جَب اُنہیں بطور کاہِنؔ یَاہوِہ کے حُضُور خدمت اَنجام دینے کے لیٔے حاضِر کیا گیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","جِس دِن اُنہیں مَسح کیا گیا، اُسی دِن یَاہوِہ نے بنی اِسرائیل کو حُکم دیا کہ کاہِنوں کو اُن کا یہ دائمی حِصّہ پُشت در پُشت دیتے رہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","لہٰذا سوختنی نذر، اناج کی نذر کی قُربانی، گُناہ کی قُربانی، خطا کی قُربانی، مَسح کی قُربانی اَور سلامتی کی نذر کے ضوابط یہ ہیں ");
INSERT INTO urdoucv_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","جو یَاہوِہ نے مَوشہ کو کوہِ سِینؔائی پر اُس دِن دئیے تھے، جِس دِن یَاہوِہ نے بنی اِسرائیل کو کوہِ سِینؔائی کے بیابان میں حُکم دیا کہ یَاہوِہ کے حُضُور اَپنی قُربانیاں گزرانے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","”اَہرونؔ اَور اُن کے بیٹوں کو اَور ساتھ میں اُن کے لباس، مَسح کا تیل، گُناہ کی قُربانی کے بچھڑے اَور دو بے عیب مینڈھے اَور ایک ٹوکری میں بے خمیری روٹیاں لے آؤ، ");
INSERT INTO urdoucv_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","اَور ساری جماعت کو خیمہ اِجتماع کے دروازہ پر جمع کرو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","اَور جَیسا یَاہوِہ نے مَوشہ کو حُکم دیا تھا اُنہُوں نے وَیسا ہی کیا اَور جماعت خیمہ اِجتماع کے دروازہ پر جمع ہو گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","تَب مَوشہ نے جماعت سے فرمایا، ”جِس کام کو پُورا کرنے کا حُکم یَاہوِہ نے دیا ہے وہ یہ ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","پھر مَوشہ نے اَہرونؔ اَور اُن کے بیٹوں کو سامنے پیش کیا اَور اُنہیں پانی سے غُسل دِلایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","اَور مَوشہ نے اَہرونؔ کو کرتا پہناکر اُن پر کمربند لپیٹا اَور اُن کو لباس پہناکر اُس پر افُود لگایا اَور افُود کے کمربند کو جسے کسی ماہر کاریگر نے بُنا تھا اُس پر کس کر لپیٹ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","اَور پھر اَہرونؔ کو سینہ بند پہنایا اَور اُس میں اُوریمؔ اَور تُمّیمؔ لگا دئیے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","پھر مَوشہ نے اَہرونؔ کے سَر پر عمامہ رکھ کر اُس پر سامنے کی طرف سونے کی تختی یعنی مُقدّس تاج لگا دیا جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","پھر مَوشہ نے مَسح کا تیل لیا اَور مَسکن کو اَور اُس کے اَندر کی ہر چیز کو مَسح کیا اَور یُوں اُن کو مُقدّس کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","اَور کُچھ مَسح کا تیل لے کر اُسے سات بار مذبح پر چھِڑکا، مذبح اَور اُس کے تمام ظروف، پانی کے حوض اَور اُس کی چوکی کو مَسح کرکے اُن کو مُقدّس کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","پھر اَہرونؔ کو مُقدّس کرنے کے لیٔے مَسح کے تیل میں سے کچھ لیا اَور اُسے اُن کے سَر پر ڈال کر اُن کا مَسح کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","پھر مَوشہ نے اَہرونؔ کے بیٹوں کو سامنے بُلایا اَور اُن کو چوغے پہنائے اَور اُن پر کمرکاپٹکہ لَپیٹا اَور اُن کے سَروں پر ٹوپیاں پہنا دیں؛ جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","پھر مَوشہ گُناہ کی قُربانی کے لیٔے بچھڑا لایٔے اَور اَہرونؔ اَور اُن کے بیٹوں نے اُس کے سَر پر ہاتھ رکھے ");
INSERT INTO urdoucv_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","اَور مَوشہ نے اُس بچھڑے کو ذبح کیا اَور اُس کا کچھ خُون لے کر اَپنی اُنگلی سے اُسے مذبح کے تمام سینگوں پر لگایا تاکہ مذبح پاک ہو جائے اَور باقی خُون کو اُس نے مذبح کے پایہ پر اُنڈیل دیا اَور اِس طرح اُس نے کفّارہ دے کر مذبح کو مُقدّس کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","اَور مَوشہ نے آنتوں کے اُوپر کی ساری چربی اَور جگر پر کی جھِلّی اَور دونوں گُردوں کو اُن کی چربی سمیت لے کر اُنہیں مذبح پر جَلا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","لیکن بچھڑے کو اُس کی کھال اَور اُس کے گوشت اَور گوبر سمیت چھاؤنی سے باہر آگ میں جَلا دیا جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","اَور پھر مَوشہ سوختنی نذر کے لیٔے مینڈھے کو سامنے لائے اَور اَہرونؔ اَور اُن کے بیٹوں نے اُس کے سَر پر اَپنے ہاتھ رکھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","پھر مَوشہ نے اُس مینڈھے کو ذبح کیا اَور اُس کا خُون مذبح کے چاروں طرف چھڑک دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","اَور مَوشہ نے اِس مینڈھے کو کاٹ کر اُس کے ٹکڑے کئے اَور اُس کے سَر، ٹُکڑوں اَور چربی کو جَلا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","اَور مَوشہ نے اُس مینڈھے کی آنتوں اَور پایوں کو پانی سے دھویا اَور پُورے مینڈھے کو مذبح پر جَلا دیا۔ یہ سوختنی نذر یَاہوِہ کے لیٔے فرحت بخش خُوشبو والی غِذا کی آتِشی قُربانی ہے جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","اَور پھر مَوشہ دُوسرے تخصیصی مینڈھے کو سامنے لائے اَور اَہرونؔ اَور اُن کے بیٹوں نے اُس کے سَر پر اَپنے ہاتھ رکھے ");
INSERT INTO urdoucv_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","اَور مَوشہ نے اُس مینڈھے کو ذبح کیا اَور اُس کا کچھ خُون لے کر اَہرونؔ کے داہنے کان کی لَو پر اَور داہنے ہاتھ اَور داہنے پاؤں کے انگُوٹھوں پر لگایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","اَور مَوشہ اَہرونؔ کے بیٹوں کو بھی سامنے لایٔے اَور اُس خُون میں سے کچھ اُن کے داہنے کانوں کی لَو پر اَور اُن کے داہنے ہاتھوں اَور داہنے پاؤں کے انگُوٹھوں پر لگایا۔ اَور پھر اُنہُوں نے باقی خُون مذبح کے چاروں طرف چھڑک دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","اَور مَوشہ نے چربی اَور موٹی دُم اَور آنتوں کے اُوپر کی ساری چربی اَور جِگر کے اُوپر کی جھِلّی اَور دونوں گُردوں، اَور اُن کی چربی اَور داہنی ران کو لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","اَور یَاہوِہ کے حُضُور رکھی بے خمیری روٹی کی ٹوکری میں سے اُس نے ایک بے خمیری روٹی اَور زَیتُون کے تیل سے سنی ہُوئی ایک روٹی اَور تیل سے بنا ہُوا ایک کُلچہ لے کر اُنہیں چربی اَور داہنی ران پر رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","اَور مَوشہ نے اِن سَب کو اَہرونؔ اَور اُن کے بیٹوں کے ہاتھوں پر رکھ کر اُن کو ہلانے کی نذر کی قُربانی کے طور پر یَاہوِہ کے حُضُور ہلایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","اَور پھر مَوشہ نے اُنہیں اُن کے ہاتھوں سے لے کر مذبح پر سوختنی نذر کے ساتھ بطور تخصیصی قُربانی جَلا دیا تاکہ جَیسا یَاہوِہ نے مَوشہ کو حُکم دیا یَاہوِہ کے لیٔے یہ ایک فرحت بخش خُوشبو والی غِذا کی آتِشی قُربانی ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","اَور مَوشہ نے مینڈھے کا سینہ بھی لیا جو کہ اُس تخصیصی مینڈھے میں سے مَوشہ کا حِصّہ تھا، اَور اُسے یَاہوِہ کے حُضُور ہلانے کی نذر کی قُربانی کے طور پر ہلایا؛ جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","اَور پھر مَوشہ نے مَسح کرنے کا کچھ تیل اَور مذبح سے کچھ خُون لے کر اَہرونؔ پر اَور اُن کے لباس پر اَور اُن کے بیٹوں پر اَور اُن کے لباسوں پر چھِڑکا۔ اِس طرح مَوشہ نے اَہرونؔ اَور اُن کے لباس کو اَور اُن کے بیٹوں اَور اُن کے لباسوں کو مُقدّس کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","اَور پھر مَوشہ نے اَہرونؔ اَور اُن کے بیٹوں سے فرمایا، ”اِس گوشت کو خیمہ اِجتماع کے دروازہ پر اُبالو اَور اُسے وہیں اُس روٹی کے ساتھ کھاؤ جو تخصیصی نذر کی ٹوکری میں ہے، جَیسا کہ مُجھے خُدا کی طرف سے حُکم دیا گیا تھا، ’اَہرونؔ اَور اُن کے بیٹے اُسے کھایٔیں۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","اَور پھر باقی بچے ہویٔے گوشت اَور روٹی کو جَلا دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","اَور سات دِن تک خیمہ اِجتماع کے دروازہ سے باہر نہ جانا، جَب تک تمہارے مَسح کی مُدّت پُوری نہ ہو جائے کیونکہ تمہاری مَسح کی مُدّت سات دِن کی ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","اَورجو کچھ آج کیا گیا ہے اُس کا حُکم یَاہوِہ نے دیا تھا تاکہ تمہارے لیٔے کفّارہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","اَور تُم لازماً سات دِن تک دِن اَور رات خیمہ اِجتماع کے دروازہ پر ہی ٹھہرے رہنا اَور یَاہوِہ کا حُکم ماَننا تاکہ تُم مرنے سے بچے رہو کیونکہ مُجھے اَیسا ہی حُکم دیا گیا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","لہٰذا اَہرونؔ اَور اُن کے بیٹوں نے وہ سَب کچھ یَاہوِہ کے حُکم کے مُطابق کیا جو یَاہوِہ نے مَوشہ کی مَعرفت دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","آٹھویں دِن مَوشہ نے اَہرونؔ اَور اُن کے بیٹوں اَور بنی اِسرائیل کے بُزرگوں کو بُلایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","اَور مَوشہ نے اَہرونؔ سے فرمایا، ”اَپنے گُناہ کی قُربانی کے لیٔے ایک بے عیب بچھڑا اَور اَپنی سوختنی نذر کے لیٔے ایک بے عیب مینڈھا لو اَور اُنہیں یَاہوِہ کے حُضُور پیش کرو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","اَور پھر بنی اِسرائیل کو حُکم دو، ’تُم گُناہ کی قُربانی کے لیٔے ایک بکرا لو اَور سوختنی نذر کے لیٔے ایک سال کا بے عیب بچھڑا اَور ایک سال کا بے عیب برّہ لو، ");
INSERT INTO urdoucv_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","اَور سلامتی کی نذر کے لیٔے یَاہوِہ کے حُضُور قُربانی پیش کرنے کے لیٔے ایک بَیل اَور ایک مینڈھا، اَور تیل سے سنی ہُوئی اناج کی نذر بھی لو، کیونکہ آج یَاہوِہ تُم پر ظاہر ہوں گے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","پھر وہ ساری چیزیں خیمہ اِجتماع کے سامنے لے آئے، جِن کا مَوشہ نے حُکم دیا تھا، اَور ساری جماعت نزدیک آکر یَاہوِہ کے حُضُور میں کھڑی ہو گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","پھر مَوشہ نے اُن سے فرمایا، ”یہ وہ کام ہے جِس کو کرنے کا یَاہوِہ نے تُمہیں حُکم دیا ہے تاکہ یَاہوِہ کا جلال تُم پر ظاہر ہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","اِس کے بعد مَوشہ نے اَہرونؔ سے فرمایا، ”مذبح کے نزدیک آ جاؤ، اَور اَپنے گُناہ کی قُربانی اَور سوختنی نذر پیش کرو تاکہ تُم خُود کے لیٔے اَور اُمّت کے لیٔے کفّارہ دو؛ اِس کے بعد اُمّت کے واسطے قُربانی پیش کرو اَور کفّارہ پُورا کر سکو، جَیسا کہ یَاہوِہ نے حُکم دیا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","لہٰذا اَہرونؔ نے مذبح کے پاس جا کر اُس بچھڑے کو اَپنے گُناہ کی قُربانی کے طور پر ذبح کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","اَہرونؔ اَور اُن کے بیٹے اُن کے پاس خُون لے آئے اَور اُنہُوں نے اُس خُون میں اَپنی اُنگلی ڈُبو ڈُبو کر اُس خُون کو مذبح کے سینگوں پر لگایا اَور باقی بچے خُون کو مذبح کے پایہ پر اُنڈیل دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","پھر اُنہُوں نے گُناہ کی قُربانی کی چربی، گُردے اَور جگر کے اُوپر کی جھِلّی کو مذبح پر جَلا دیا جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","لیکن گوشت اَور کھال کو چھاؤنی کے باہر جَلا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","اَور پھر اُس نے سوختنی نذر کے جانور کو ذبح کیا اَور اُس کے بیٹوں نے جانور کا خُون اُن کے ہاتھ میں دیا اَور اَہرونؔ نے اُسے مذبح کے چاروں طرف چھڑک دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","اَور اُنہُوں نے سوختنی نذر کے ٹکڑے کرکے سَر سمیت اُنہیں دئیے اَور اُنہُوں نے اُنہیں مذبح پر آگ میں جَلا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","اَور اَہرونؔ نے آنتوں اَور پایوں کو دھوکر اُنہیں مذبح پر سوختنی نذر کے اُوپر جَلا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","پھر اَہرونؔ نے اُس نذر کو پیش کیا جو اُمّت کے لیٔے تھی۔ پھر اُنہُوں نے اُس بکرے کو بطور اُمّت کے گُناہ کی قُربانی کے واسطے ذبح کیا اَور بطور گُناہ کی قُربانی پیش کیا جَیسا کہ اُس نے پہلی قُربانی گُناہ کی قُربانی کے طور پر پیش کی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","اَور اُنہُوں نے سوختنی نذر کے جانور کو بھی لیا اَور حُکم کے مُطابق اُس کی قُربانی دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","پھر وہ اناج کی نذر بھی لائے اَور اُس میں سے مُٹّھی بھر لے کر اُسے صُبح کی سوختنی نذر کے علاوہ مذبح پر جَلایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","اَور اُنہُوں نے بَیل اَور مینڈھے کو اُمّت کی سلامتی کی نذر کی قُربانی کے طور پر ذبح کیا اَور اَہرونؔ کے بیٹے جانور کا خُون اُن کے پاس لایٔے اَور اُنہُوں نے اُسے مذبح کے چاروں طرف چھڑک دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","لیکن بَیل اَور مینڈھے کے چربی والے حِصّے یعنی موٹی دُم کو، آنتوں کے اُوپر کی چربی کو، گُردوں اَور جگر کے اُوپر کی جھِلّی کو اُنہیں دے دیا؛ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","اَور اُنہُوں نے چربی والے حِصّہ کو سِینوں پر رکھا اَور پھر اَہرونؔ نے اُنہیں مذبح پر آگ میں جَلا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","مگر اَہرونؔ نے سینے اَور داہنی ران کو یَاہوِہ کے حُضُور ہلانے کی نذر کی قُربانی کے طور پر پیش کیا جَیسا مَوشہ نے اُنہیں حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","پھر اَہرونؔ نے اَپنے ہاتھ اُمّت کی طرف اُٹھاکر اُنہیں برکت دی اَور گُناہ کی قُربانی، سوختنی نذر اَور سلامتی کی نذر پیش کرنے کے بعد نیچے اُتر آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","اَور پھر مَوشہ اَور اَہرونؔ خیمہ اِجتماع کے اَندر چلے گیٔے اَور جَب وہ باہر آئے تو اُنہُوں نے اُمّت کو برکت دی تَب یَاہوِہ کا جلال پُوری اُمّت پر ظاہر ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","اَور یَاہوِہ کی حُضُوری سے آگ نکلی جِس نے مذبح پر سوختنی نذر اَور چربی کو بھسم کر دیا اَور جَب لوگوں نے اِسے دیکھا تو سَب کے سَب خُوشی سے نعرے مارنے لگے اَور مُنہ کے بَل گِر کر سَجدہ کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","اَور اَہرونؔ کے بیٹوں میں نادابؔ اَور اَبِیہُو نے اَپنے اَپنے بخُوردان لے کر اُن میں آگ بھری اَور اُس میں لوبان ڈالا۔ اُس پر اُنہُوں نے یَاہوِہ کے حُکم کے خِلاف یَاہوِہ کے حُضُور ناپاک آگ پیش کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","لہٰذا یَاہوِہ کی حُضُوری سے آگ نکلی اَور اُنہیں بھسم کر دیا، اَور وہ یَاہوِہ کے سامنے ہی مَر گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","تَب مَوشہ نے اَہرونؔ سے فرمایا، ”یہ یَاہوِہ کے اُس قول کے مُطابق ہے: ” ’لازِم ہے کہ جو میرے قریب آئیں وہ مُجھے مُقدّس جانیں؛ تَب سَب اُمّت کے سامنے میرا جلال ظاہر ہو۔‘ “ اِس پر اَہرونؔ خاموش ہی رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","اَور مَوشہ نے اَہرونؔ کے چچا عُزّی ايل کے بیٹوں میشاایلؔ اَور اِیلضافنؔ کو بُلاکر اُنہیں حُکم دیا، ”یہاں آؤ اَور اَپنے چچازاد بھائیوں کی لاش کو پاک مَقدِس کے سامنے سے دُور چھاؤنی کے باہر لے جاؤ۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","لہٰذا وہ آئے اَور اُن کی لاش کو جو ابھی تک اَپنے کُرتوں میں تھے اُٹھاکر چھاؤنی سے باہر لے گیٔے، جَیسا مَوشہ نے اُنہیں حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","تَب مَوشہ نے اَہرونؔ اَور اُن کے بیٹوں الیعزرؔ اَور اِتمارؔ سے فرمایا، ”نہ تو اَپنے سَر کے بال بکھرنے دینا اَور نہ ہی اَپنے کپڑے پھاڑنا ورنہ تُم مرجاؤگے اَور یَاہوِہ کا غضب ساری جماعت پر نازل ہو۔ لیکن تمہارے رشتہ دار اَور تمام بنی اِسرائیل اُن لوگوں کے لیٔے ماتم کرے جِن کو یَاہوِہ نے آگ سے ہلاک کیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","اَور تُم تو خیمہ اِجتماع کے مدخل سے ہرگز باہر نہ جانا، ورنہ تمہاری بھی موت ہو جایٔےگی کیونکہ یَاہوِہ کا مَسح کرنے کا تیل تُم پر ہے۔“ لہٰذا جَیسا مَوشہ نے کہا اُنہُوں نے وَیسا ہی کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","تَب یَاہوِہ نے اَہرونؔ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","”تُم اَور تمہارے بیٹے انگوری شِیرہ پی کر یا نشہ کرکے کبھی خیمہ اِجتماع کے اَندر داخل نہ ہونا ورنہ تمہاری موت ہو جایٔےگی۔ یہ دائمی فرمان پُشت در پُشت قائِم رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","اَور تُم لازماً مُقدّس اَور عام چیزوں میں اَور پاک اَور ناپاک چیزوں میں اِمتیاز کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","اَور تُم بنی اِسرائیل کو اُن تمام قوانین کی جو یَاہوِہ نے مَوشہ کی مَعرفت دئیے ہیں تعلیم دینا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","پھر مَوشہ نے اَہرونؔ اَور اُن کے دونوں بچے ہویٔے بیٹوں، الیعزرؔ اَور اِتمارؔ سے فرمایا، ”یَاہوِہ کو پیش کی گئی آتِشی قُربانیوں میں سے اناج کی نذر کو جو بچی رہے، اَورجو بے خمیری کا ہے اُسے لے کر مذبح کے پاس ہی کھاؤ، کیونکہ یہ نہایت ہی پاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","اَور تُم اِسے پاک مَقدِس کی جگہ میں ہی کھانا، کیونکہ یَاہوِہ کو پیش کی گئی آتِشی قُربانیوں میں سے یہ تمہارا اَور تمہارے بیٹوں کا دائمی حِصّہ ہے۔ کیونکہ مُجھے اَیسا ہی حُکم دیا گیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","لیکن تُم اَور تمہارے بیٹے اَور بیٹیاں اُس ہلانے کی نذر کی قُربانی کے سینہ اَور ران کو کسی رسماً پاک جگہ میں کھا سکتے ہو۔ کیونکہ یہ بنی اِسرائیل کی سلامتی کی نذروں میں سے تُمہیں اَور تمہارے بیٹوں اَور بیٹیوں کے لیٔے دائمی حِصّہ کے طور پر دئیے گیٔے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","وہ آتِشی قُربانی کی چربی کے ساتھ ران کو اُونچا اُٹھاتے اَور سینہ کو ہلاتے ہویٔے یَاہوِہ کے حُضُور بطور ہلانے کی نذر کی قُربانی کے طور پر لائیں گے۔ اَور جَیسا یَاہوِہ نے حُکم دیا ہے یہ تمہارا اَور تمہارے بچّوں کا باقاعدہ دائمی حِصّہ ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","جَب مَوشہ نے گُناہ کی قُربانی کے بکرے کے متعلّق پُوچھا تو اُسے مَعلُوم ہُوا کہ اُسے جَلایا جا چُکاہے، تَب وہ اَہرونؔ کے باقی بچے ہویٔے بیٹوں الیعزرؔ اَور اِتمارؔ پر غُصّہ ہو گیٔے اَور اُن سے پُوچھا، ");
INSERT INTO urdoucv_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","”تُم نے گُناہ کی قُربانی کے گوشت کو پاک مَقدِس کی جگہ میں کیوں نہ کھایا؟ کیونکہ یہ نہایت ہی پاک ہے۔ یہ تُمہیں اِس لیٔے دیا گیا تھا کہ تُم جماعت کے لیٔے یَاہوِہ کے حُضُور کفّارہ دے کر جماعت کے گُناہ کو اَپنے اُوپر اُٹھالو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","چونکہ اُس کا خُون پاک مقام میں لایا ہی نہیں گیا تھا، اِس لیٔے ضروُری تھا کہ تُم اُس بکرے کو پاک مَقدِس کی جگہ میں ہی کھا لیتے، جَیسا مَیں نے تُمہیں حُکم دیا تھا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","تَب اَہرونؔ نے مَوشہ کو جَواب دیا، ”دیکھ آج ہی اُنہُوں نے اَپنی گُناہ کی قُربانی اَور سوختنی نذر یَاہوِہ کے حُضُور پیش کی، اَور مُجھ پر اَیسی آفت گزری ہے۔ اگر مَیں آج سوختنی نذر کا گوشت کھاتا تو کیا یہ یَاہوِہ کی نظر میں اَچھّا ہوتا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","جَب مَوشہ نے یہ بات سُنی تو وہ مطمئن ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","اَور یَاہوِہ نے مَوشہ اَور اَہرونؔ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","”بنی اِسرائیل سے کہو، ’زمین کے سَب چَوپایوں میں سے جِن جِن کو تُم کھا سکتے ہو وہ یہ ہیں: ");
INSERT INTO urdoucv_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","جِن چَوپایوں کے کھُر چِرے ہویٔے ہُوں اَورجو جُگالی کرتے ہُوں اُسے تُم کھا سکتے ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","” ’کچھ جانور اَیسے بھی ہیں جو صِرف جُگالی کرتے ہیں یا جِن کے صِرف کھُر چِرے ہویٔے ہیں تُم اُنہیں ہرگز نہ کھانا۔ مثلاً اُونٹ جو جُگالی تو کرتا ہے لیکن اُس کے کھُر چِرے ہویٔے نہیں ہیں یہ تمہارے لیٔے ناپاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","اَور چٹّانی سافان اگرچہ وہ جُگالی تو کرتا ہے لیکن اُس کے کھُر چِرے ہویٔے نہیں ہیں لہٰذا وہ بھی تمہارے لیٔے ناپاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","اَور خرگوش بھی اگرچہ وہ جُگالی تو کرتا ہے لیکن اُس کے کھُر پھٹے ہویٔے نہیں ہیں لہٰذا وہ بھی تمہارے لیٔے ناپاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","اَور سُؤر بھی، اگرچہ اُس کے کھُر چِرے ہویٔے ہیں مگر وہ جُگالی نہیں کرتا، لہٰذا وہ بھی تمہارے لیٔے ناپاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","تُم اُن کا گوشت ہرگز نہ کھانا اَور نہ ہی اُن کی لاشوں کو بھی چھُونا کیونکہ وہ تمہارے لیٔے ناپاک ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","” ’اَور سمُندروں اَور دریاؤں میں رہنے والے تمام آبی جانداروں میں سے جِن کے پر اَور چھِلکے ہُوں تُم اُنہیں کھا سکتے ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","لیکن سمُندروں اَور دریاؤں کے وہ جاندار جِن کے پر اَور چھِلکے نہ ہوں خواہ وہ جھُنڈ بنا کر تیرتے ہُوں یا وہ پانی کی دیگر زندہ مخلُوقات میں سے ہُوں تُم اُنہیں مکرُوہ سمجھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","اَور چونکہ وہ تمہارے لیٔے ناپاک ہیں لہٰذا تُم اُن کا گوشت ہرگز نہ کھانا اَور نہ ہی اُن کی لاشوں کو چھُونا کیونکہ وہ ناپاک ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","پانی میں رہنے والی ہر ایک مخلُوقات جِس کے پر اَور چھِلکے نہ ہوں وہ تمہارے لیٔے مکرُوہ ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","” ’اَور پرندوں میں سے تمہارے لیٔے مکرُوہ پرندے یہ ہیں اَور جنہیں کھانا منع ہے مثلاً: عُقاب، گِدھ، کالا گِدھ، ");
INSERT INTO urdoucv_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","سُرخ چیل، ہر قِسم کی کالی چیل۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ہر قِسم کے کوّے، ");
INSERT INTO urdoucv_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","چیخنے والا اُلّو، سینگ والا اُلّو، سمُندری بگلا، اَور ہر قِسم کے باز۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","چھوٹا اُلّو، ماہی خور، سمُندری پرندہ، بڑا اُلّو، ");
INSERT INTO urdoucv_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","سفید اُلّو، جنگلی اُلّو، سمُندری عُقاب، ");
INSERT INTO urdoucv_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","لق لق، ہر قِسم کے بگلے، ہُدہُد اَور چمگادڑ۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","” ’اَور تمام پَردار کیڑے جو چاروں ٹانگوں پر چلتے ہیں تمہارے لیٔے ناپاک ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","تاہم کچھ پَردار کیڑے اَیسے ہیں جو چاروں ٹانگوں پر چلتے ہیں، جِن کے زمین پر کودنے اَور پھاندنے کے لیٔے پیر ہوتے ہیں اُنہیں تُم کھا سکتے ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","اِن جاندار کیڑوں کو تُم کھا سکتے ہو: یعنی ہر قِسم کی ٹِڈّی ہر قِسم کا سُلعام، جھینگر یا ٹِڈّا کھا سکتے ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","مگر باقی تمام پَردار کیڑے جو چاروں ٹانگوں پر چلتے ہیں وہ تمہارے لیٔے مکرُوہ ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","” ’اِن سبھی جانداروں کی وجہ سے تُم ناپاک ہو جاؤگے؛ اَورجو کویٔی اُن کی لاش کو چھُوئے گا وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","اَورجو کویٔی اُن کی لاشوں کو اُٹھائے، وہ اَپنے کپڑے دھوئے اَور شام تک وہ ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","” ’ہر ایک جانور جِس کا کھُر پھٹا ہو لیکن پُوری طرح دو حِصّہ میں الگ نہ ہو، مگر وہ جُگالی نہیں کرتا ہو، وہ تمہارے لیٔے ناپاک ہے؛ اَورجو کویٔی اُن کی لاش کو چھُوئے گا تو وہ ناپاک ہو جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","اَور چار پاؤں کے بَل چلنے والے تمام جانوروں میں سے جتنے اَپنے پنجوں کے بَل چلتے ہیں، وہ بھی تمہارے لیٔے ناپاک ہیں اَورجو کویٔی اُن کی لاشوں کو چھُوئے گا وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","اَورجو کویٔی اُن کی لاشیں اُٹھائے وہ اَپنے کپڑے دھوئے اَور شام تک وہ ناپاک رہے گا۔ کیونکہ یہ جانور تمہارے لیٔے ناپاک ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","” ’زمین پر رینگنے والے جانداروں میں سے یہ جاندار تمہارے لیٔے ناپاک ہیں: نیولا، چُوہا، اَور ہر قِسم کی بڑی چھپکلی، ");
INSERT INTO urdoucv_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","حِرذُون (ایک قِسم کی چھپکلی)، گوہ، دیوار پر رہنے والی چھپکلی، سانڈ اَور گِرگٹ۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","وہ جاندار جو زمین پر رینگ کر چلتے ہیں، یہ سَب تمہارے لیٔے ناپاک ہیں۔ جو کویٔی اُن مَرے ہویٔے جانداروں کو چھُوتا ہے وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","اِن میں سے اگر کسی چیز پر اُن کا مَرا ہُوا جِسم گِر پڑے تو وہ چیز ناپاک ہو جایٔےگی، چاہے وہ لکڑی کا برتن، کپڑا، کھال یا ٹاٹ کی بنی ہو، اَور کسی بھی کام میں اِستعمال کی جاتی ہو۔ لہٰذا اُسے پانی میں ڈال دو اَور شام تک وہ ناپاک رہے گی اَور اُس کے بعد وہ چیز پاک ٹھہرے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","اَور اگر کسی مٹّی کے برتن میں اِن جانداروں کا مَرا ہُوا جِسم گِر جائے تو اُس کے اَندر کی ہر چیز ناپاک ہو جائے گی۔ لہٰذا تُم اُس برتن کو توڑ ڈالنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","اَور اگر اِس برتن کا پانی کسی بھی کھانے کی چیز پر گِر جایٔے تو، وہ کھانا ناپاک ہو جایٔےگا۔ اَور اگر اَیسے برتن میں پینے کے لیٔے کچھ ہو تو وہ بھی ناپاک ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","اَور جِس چیز پر اُن جاندار کی لاش گِر جایٔے، وہ چیز ناپاک ہو جایٔےگی۔ چاہے وہ چیز تنور ہو یا آتِشدان ہو، اُسے ضروُر توڑ دیا جائے۔ وہ ناپاک ہیں اَور تمہارے لیٔے ناپاک ہی ٹھہریں گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","تاہم چشمہ یا تالاب جہاں پانی جما کیا جاتا ہے، وہ تو پاک ہی رہتاہے۔ لیکن جو کویٔی اُن کی لاشوں کو چھُوئے وہ ناپاک ٹھہرے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","اگر کویٔی لاش اَیسے بیجوں پر گِرے جو بونے کے لیٔے ہُوں تو وہ پاک رہیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","لیکن اگر بیج پر پانی ڈالا گیا ہو اَور اُس پر اِن کی کویٔی لاش گِر پڑے تو وہ تمہارے لیٔے ناپاک ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","” ’اگر کویٔی جانور جِس کے کھانے کی تُمہیں اِجازت ہے، مَر جائے تو جو کویٔی اُس کی لاش کو چھُوئے وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","اَورجو کویٔی اُس مَرے ہویٔے جانور کا گوشت کھائے تو، وہ اَپنے کپڑے ضروُر دھو ڈالے اَور وہ شام تک ناپاک رہے گا۔ اَورجو کویٔی اُس جانور کی لاش کو اُٹھائے وہ بھی اَپنے کپڑے دھو ڈالے اَور وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","” ’ہر ایک جاندار جو زمین پر رینگتا پھرتاہے مکرُوہ ہے اُسے ہرگز کھایا نہ جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","تُم کسی جاندار کو جو زمین پر رینگتا پھرتاہے خواہ وہ پیٹ کے بَل رینگتا ہو یا چاروں پاؤں کے بَل یا کثیر پاؤں کے بَل چلتا ہو، تُم اُن کو ہرگز نہ کھانا کیونکہ وہ مکرُوہ ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","اِن جانداروں میں سے کسی جاندار کے باعث تُم اَپنے آپ کو مکرُوہ نہ بنا لینا۔ اَور نہ ہی تُم اُن کے باعث خُود کو ناپاک کرنا تاکہ ناپاک نہ ہو جاؤ۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","کیونکہ مَیں یَاہوِہ تمہارا خُدا ہُوں۔ اِس لیٔے تُم اَپنے آپ کو صَاف کرو اَور پاک بنو کیونکہ مَیں پاک ہُوں۔ لہٰذا تُم زمین پر رینگنے والے کسی بھی جاندار کے باعث اَپنے آپ کو ناپاک نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","کیونکہ مَیں یَاہوِہ ہُوں جو تمہارا خُدا ہونے کے لیٔے تُمہیں مِصر سے نکال لایا۔ اِس لیٔے پاک بنو کیونکہ مَیں پاک ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","” ’حَیوانات، پرندوں، آبی جانداروں اَور زمین پر رینگنے والے سَب جانداروں کے بارے میں ضوابط یہی ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","اَور تُم پاک اَور ناپاک میں اَور کھائے جانے والے اَور نہ کھائے جانے والے زندہ جانوروں میں ضروُر اِمتیاز کرنا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","”بنی اِسرائیل کو حُکم دو: ’اگر کویٔی عورت حاملہ ہو اَور لڑکا پیدا کرے تو وہ سات دِن تک رسمی طور پر ناپاک سَمجھی جائے گی، جَیسا کہ وہ حَیض کے ایّام کے دَوران ناپاک رہتی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","اَور آٹھویں دِن اُس لڑکے کا ختنہ کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","اَور اِس کے بعد وہ عورت تینتیس دِن تک طہارت کے خُون میں رہے اَور پاک ہونے کے لیٔے اِنتظار کرے اَور لازماً وہ اَپنی طہارت کے دِن پُورے ہونے تک کسی مُقدّس چیز کو ہرگز نہ چھُوئے اَور نہ ہی پاک مَقدِس میں داخل ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","اَور اگر وہ ایک لڑکی کو پیدا کرے تو وہ عورت دو ہفتوں تک ناپاک سَمجھی جائے گی جَیسا کہ حَیض کے ایّام کے دَوران ناپاک رہتی ہے۔ اَور پھر وہ طہارت کے خُون سے پاک ہونے کے لیٔے چھیاسٹھ دِن تک اِنتظار کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","” ’اَور جَب لڑکے یا لڑکی کے لیٔے اُس کی طہارت کے دِن پُورے ہو جایٔیں، تو وہ سوختنی نذر کے لیٔے یک سالہ برّہ اَور گُناہ کی قُربانی کے لیٔے کبُوتر کا ایک بچّہ یا ایک قُمری خیمہ اِجتماع کے دروازہ پر کاہِنؔ کے پاس لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","اَور کاہِنؔ اُن کو اُس عورت کا کفّارہ دینے کے لیٔے یَاہوِہ کے حُضُور میں قُربانی کرے۔ تَب وہ اَپنے جریان خُون سے رسماً پاک ہو جایٔےگی۔ ” ’یہ طریقہ ہر ایک عورت کے لیٔے ہے، چاہے وہ لڑکے کو یا لڑکی کو پیدا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","اگر وہ عورت ایک برّہ خریدنے کا مقدور نہ رکھتی ہو، تو وہ قُمریوں کا ایک جوڑا یا کبُوتر کے دو بچّے لایٔے، ایک سوختنی نذر کے لیٔے اَور دُوسرا گُناہ کی قُربانی کے لیٔے۔ اِس طرح کاہِنؔ اُس کے لیٔے کفّارہ دے گا، تو وہ پاک ہو جایٔےگی۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","اَور یَاہوِہ نے مَوشہ اَور اَہرونؔ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","”اگر کسی کی جِلد پر سُوجن، سُرخ دانے یا سفید چمکیلا داغ ہو اَور اُس سے جِلدی بیماری بڑھنے کا خطرہ ہو، تو اَیسے اِنسان کو لازماً اَہرونؔ کاہِنؔ کے پاس یا اُن کے بیٹوں میں سے جو کاہِنؔ ہیں، کسی کے پاس لے جائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","اَور کاہِنؔ اُس جِلد کی متعدّی جگہ کا مُعائنہ کرے، اَور اگر اُس متعدّی جگہ کے بال سفید ہو گئے ہُوں اَور وَبا جِلد سے زِیادہ گہری دِکھائی دے تو، وہ یقیناً جِلد کی کویٔی بیماری ہے۔ اَور جَب کاہِنؔ اُس کا مُعائنہ کر چُکے تو وہ رسمی طور پر اُسے ناپاک ہونے کا اعلان کر دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","اَور اگر اُس کی جِلد پر سفید داغ تو ہو، لیکن وہ وَبا جِلد سے گہری نہ ہو، اَور اُس جگہ کے بال بھی سفید نہ ہویٔے ہُوں تو، کاہِنؔ اُس کوڑھ کی بیماری سے متاثر اِنسان کو سات دِن تک علیحدہ رکھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","اَور ساتویں دِن کاہِنؔ اُس کا مُعائنہ کرے اَور اگر وہ دیکھے کہ اُس زخم میں کویٔی تبدیلی نہیں ہُوئی اَور وہ جِلد پر نہیں پھیلا تو وہ اُس کو مزید سات دِن اَور علیحدگی میں رکھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","اَور ساتویں دِن کاہِنؔ پھر اُس کا مُعائنہ کرے اَور اگر اُس متعدّی جگہ کے داغ کا رنگ پھیکا پڑ گیا ہو اَور وہ جِلد کے اُوپر پھیلا بھی نہ ہو، تو کاہِنؔ اُسے پاک قرار دے کیونکہ وہ داغ محض سُرخ دانے ہیں۔ اِس لیٔے وہ اِنسان اَپنے کپڑے دھو ڈالے اَور پاک ہو جایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","لیکن اگر کاہِنؔ کے سامنے اُس مُعائنہ اَور اُسے پاک قرار دئیے جانے کے بعد بھی وہ سُرخ دانے جِلد پر پھیلنے لگے، تو وہ اِنسان خُود کو دوبارہ کاہِنؔ کو دِکھائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","اَور کاہِنؔ اُس کا مُعائنہ کرے اَور اگر وہ سُرخ دانے جِلد پر پھیل گئے ہُوں تو کاہِنؔ اُس اِنسان کو ناپاک قرار دے کیونکہ یہ ایک کوڑھ کی بیماری ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","”اگر کسی اِنسان کو کوڑھ کا مرض ہو تو وہ لازمی طور پر کاہِنؔ کے پاس لایا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","اَور کاہِنؔ اُس کا مُعائنہ کرے اَور اگر اُس کی جِلد میں سفید رنگ کی سُوجن ہو اَور اُس جگہ کے بال بھی سفید ہو گیٔے ہُوں اَور اُس سُوجن میں کھُلا زخم ہو، ");
INSERT INTO urdoucv_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","تو یہ اُس اِنسان کی جِلد پر ایک پُرانا کوڑھ کا مرض ہے، لہٰذا کاہِنؔ اُس کو علیحدگی میں بند کرکے نہ رکھے بَلکہ اُسے فوراً ناپاک قرار دے، کیونکہ وہ بہت پہلے ہی ناپاک ہو چُکاہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","”اَور اگر کوڑھ کی بیماری اُس کی تمام جِلد پر پھیل جائے اَور جہاں تک کاہِنؔ دیکھ سکے وہ متاثّرہ اِنسان کی ساری جِلد پر سَر سے لے کر پاؤں تک پھیلی ہو، ");
INSERT INTO urdoucv_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","تو کاہِنؔ اُس اِنسان کی باریکی سے جانچ کرے اَور اُس کے پاک ہونے کا اعلان کرے کیونکہ متعدّی بیماری اُس شخص کے پُورے بَدن میں پھیل گئی ہے اَور اُس کا پُورا بَدن سفید ہو گیا ہے لہٰذا وہ شخص پاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","لیکن اگر کاہِنؔ کو اُس کی جِلد پر کھُلا زخم دِکھائی دے، تو وہ ناپاک ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","اَور جَب کاہِنؔ اُس کے کھُلے زخم کو غور سے دیکھے تو وہ اُس شخص کو ناپاک قرار دے۔ کیونکہ کھُلا زخم ناپاک ہے اَور یہ کوڑھ کی بیماری ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","اَور اگر اُس کی جِلد کا کھُلا زخم دوبارہ سفید رنگ کا ہو جائے، تو وہ شخص کاہِنؔ کے پاس جائے، ");
INSERT INTO urdoucv_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","اَور کاہِنؔ اُس کا باریکی سے مُعائنہ کرے اَور اگر وہ زخم سفید رنگ کا ہو گیا ہو، تو کاہِنؔ متاثّرہ شخص کو پاک قرار دے تَب وہ پاک ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","”اگر کسی کی جِلد پر کویٔی پھوڑا ہو گیا ہو اَور وہ ٹھیک ہو جائے، ");
INSERT INTO urdoucv_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","اَور اُس پھوڑے کی جگہ پر سفید سُوجن یا سُرخی مائل چمکتا ہُوا سفید داغ دِکھائی دے تو وہ لازماً اَپنے آپ کو کاہِنؔ کے حُضُور پیش کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","کاہِنؔ اُس کا باریکی سے مُعائنہ کرے اَور اگر وہ داغ جِلد سے گہرا دِکھائی دے اَور اُس پر بال سفید ہو گئے ہُوں تو کاہِنؔ اُس شخص کو ناپاک قرار دے کیونکہ یہ کوڑھ کا ایک متعدّی مرض ہے جِس کی شروعات پھوڑے سے ہُوئی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","لیکن اگر کاہِنؔ کے باریکی سے اُس وقت مُعائنہ کرنے کے دَوران اُس کی جِلد پر کویٔی سفید بال نہ ہو اَور وہ دانے جِلد سے گہرے نہ ہوں اَور اُس کا رنگ ہلکا پڑ گیا ہو، تو کاہِنؔ اُسے دُوسروں سے سات دِن تک علیحدہ رکھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","اَور اگر وہ جِلد پر زِیادہ پھیل رہا ہو، تو کاہِنؔ اُس شخص کو ناپاک قرار دے کیونکہ یہ ایک متعدّی مرض ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","لیکن اگر اُس شخص کی جِلد پر سفید رنگ کا داغ تو ہے لیکن یہ جِلد میں پھیل نہیں رہاہے، تو یہ پھوڑے کے ٹھیک ہونے کا داغ ہے، تَب کاہِنؔ اُس شخص کو پاک قرار دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","”جَب کسی کی جِلد آگ سے جَل گئی ہو اَور جلنے سے جِلد پر ایک سفید یا سُرخی مائل رنگ کا کھُلا زخمی داغ نظر آنے لگے، ");
INSERT INTO urdoucv_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","تو کاہِنؔ اُس کا باریکی سے مُعائنہ کرے اَور اگر اُس داغ کے اَندر کے بال سفید ہو گئے ہُوں اَور وہ متعدّی مرض جِلد سے گہرا دِکھائی دے، تو یہ ایک قِسم کا کوڑھ ہے جو اُس جلنے کے داغ میں پھوٹ پڑا ہے لہٰذا کاہِنؔ اُس شخص کو ناپاک قرار دے کیونکہ اُسے کوڑھ کی بیماری ہو گئی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","لیکن اگر کاہِنؔ اُس کا باریکی سے مُعائنہ کرتا ہے اَور اُس داغ میں سفید بال نہیں پاتا اَور نہ وہ جِلد سے گہرا ہے اَور اُس کا رنگ بھی ہلکا پڑ گیا ہے، تو کاہِنؔ اُس شخص کو سات دِن کے لیٔے دُوسروں سے علیحدہ رکھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","اَور ساتویں دِن کاہِنؔ اُس کا دوبارہ مُعائنہ کرے اَور اگر اُس کا داغ جِلد پر پھیل رہا ہو تو کاہِنؔ اُس شخص کو ناپاک قرار دے۔ کیونکہ یہ کوڑھ کی بیماری ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","اَور اگر اُس جِلد کے داغ میں کویٔی تبدیلی نہ ہُوئی ہو اَور وہ جِلد میں نہ پھیلا ہو اَور اُس کا رنگ ہلکا ہو گیا ہو، تو یہ محض سُوجن ہے جو جَل جانے کے باعث پیدا ہو گئی ہے۔ لہٰذا کاہِنؔ اُس شخص کو پاک قرار دے کیونکہ وہ محض جَل جانے کا داغ ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","”اَور اگر کسی مَرد یا عورت کے سَر یا داڑھی پر متعدّی مرض ہو، ");
INSERT INTO urdoucv_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","تو کاہِنؔ اُس کا مُعائنہ کرے اَور اگر وہ داغ جِلد سے گہرا نظر آئے اَور اُس میں زرد اَور مہین رونگٹے دِکھائی دیں، تو کاہِنؔ اُس شخص کو ناپاک قرار دے۔ یہ کویٔی خارِش ہے اَور سَر اَور داڑھی کا کوڑھ ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","لیکن اگر مُعائنہ کے وقت کاہِنؔ کو پتا چلے کہ وہ داغ جِلد سے گہرا نہیں ہے اَور نہ ہی اُس جگہ پر کویٔی کالا بال ہے، تو کاہِنؔ متاثّرہ شخص کو سات دِن کے لیٔے دُوسروں سے علیحدہ رکھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ساتویں دِن کاہِنؔ اُس متعدّی مرض کا مُعائنہ کرے اَور اگر خارِش پھیلی نہ ہو اَور اُس جگہ پر کویٔی زرد بال نہ ہو اَور خارِش کے باعث متعدّی مرض جِلد سے گہرا نہیں ہے، ");
INSERT INTO urdoucv_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","تو بیماری سے متاثّرہ حِصّہ کو چھوڑکر اُس کے بال ضروُر گنجے کر دئیے جایٔیں، اَور کاہِنؔ اُسے سات دِن اَور علیحدہ رکھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","پھر ساتویں دِن کاہِنؔ اُس خارِش کا مُعائنہ کرے اَور اگر خارِش جِلد میں پھیلی نہ ہو اَور نہ ہی جِلد سے گہری مَعلُوم ہو، تو کاہِنؔ اُسے پاک قرار دے؛ وہ شخص اَپنے کپڑے دھوئے اَور پاک ہو جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","لیکن اگر پاک قرار دیئے جانے کے بعد اُس کی خارِش جِلد پر زِیادہ پھیل جائے، ");
INSERT INTO urdoucv_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","تو کاہِنؔ اُس کا پھر مُعائنہ کرے اَور اگر وہ خارِش جِلد پر پھیل چُکی ہو تو کاہِنؔ کو زرد بال دیکھنے کی ضروُرت نہیں وہ شخص ناپاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","اگر خارِش کا رنگ تبدیل نہیں ہُوا اَور اُس میں کالے بال اُگ آئے ہُوں تو وہ خارِش ٹھیک ہو گئی ہے۔ اَور وہ شخص پاک ہے اَور کاہِنؔ اُسے پاک قرار دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","”اگر کسی مَرد یا عورت کی جِلد پر سفید چمکدار داغ نموُدار ہو جایٔیں، ");
INSERT INTO urdoucv_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","تو کاہِنؔ اُن کا مُعائنہ کرے۔ اَور اگر جِلد پر وہ چمکدار داغ ہلکے سفید رنگ کے ہُوں تو وہ مَعمولی کھُجلی ہے جو جِلد پر پھوٹ پڑی ہے۔ وہ شخص پاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","”اگر کسی شخص کے سَر کے بال جھڑ گیٔے ہُوں اَور وہ گنجا ہو گیا ہو، تو وہ رسمی طور پر پاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","اَور اگر اُس کے سَر کے سامنے پیشانی کے اَور سَر کے دونوں طرف کے بال جھڑ چُکے ہُوں اَور اُس کی پیشانی گنجی ہو گئی ہو، تو وہ شخص پاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","لیکن اگر اُس کے گنجے سَر یا پیشانی پر سُرخی مائل سفید رنگ کا داغ ہو تو وہ جِلد کا ایک متعدّی مرض ہے، یہ کوڑھ ہے جو اُس کے سَر یا پیشانی پر پھیلنا شروع ہو گیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","لہٰذا کاہِنؔ اُس کا مُعائنہ کرے اَور اگر اُس کے سَر یا پیشانی کا داغ سُوجا ہُوا ہو اَور اُس کا رنگ کوڑھ کی طرح سُرخی مائل سفید ہو، ");
INSERT INTO urdoucv_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","تو وہ شخص کوڑھ کی بیماری میں مُبتلا ہے اَور ناپاک ہے۔ اِس لیٔے کاہِنؔ اُس شخص کو سَر کے داغ کی وجہ سے ناپاک قرار دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","”اِس قِسم کے متعدّی مرض مثلاً کوڑھ میں مُبتلا شخص کے لیٔے لازِم ہے کہ وہ پھٹے پرانے کپڑے پہنے اَور اُس کے بال بکھرے ہویٔے ہُوں اَور وہ اَپنے چہرے کے نِچلے حِصّہ کو ڈھانکے اَور چِلّا چِلّا‏‏‏‏کر کہے، ’ناپاک! ناپاک!‘ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","جَب تک وہ اَیسے متعدّی مرض میں مُبتلا رہے گا وہ ناپاک سمجھا جائے گا۔ اِس لیٔے لازِم ہے کہ وہ تنہا رہے اَور چھاؤنی کے باہر زندگی گزارے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","”اگر کسی کپڑے میں کوڑھ کی پَھپھُوندی لگ جائے، تو خواہ وہ اُونی ہو یا سُوتی، ");
INSERT INTO urdoucv_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","اَور خواہ وہ سُوت یا اُون سے بُنا ہُوا ہو یا وہ چمڑا ہو یا چمڑے سے بنایا گیا ہو، ");
INSERT INTO urdoucv_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","اَور اگر یہ متعدّی مرض کپڑے یا چمڑے سے بنی کسی چیز میں یا کپڑے کے تانے یا بانے میں ہو جِس کا رنگ ہرا یا سُرخی مائل ہو تو یہ پھیلنے والے کوڑھ کی پھپھُوندی ہے اَور یہ کاہِنؔ کو ضروُر دِکھائی جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","تَب کاہِنؔ اُس پھپھُوندی کا مُعائنہ کرے اَور اُس سے آلُودہ اَشیا کو سات دِن تک علیحدہ رکھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","اَور ساتویں دِن وہ اُس کا پھر سے مُعائنہ کرے اَور اگر وہ متعدّی پھپھُوندی کپڑے کے تانے بانے میں یا چمڑے کی بنی ہُوئی کسی چیز پر زِیادہ پھیل چُکی ہو، تو وہ کپڑا اَور چمڑے کی بنی ہُوئی چیز سَب نُقصان دہ پھپھُوندی سے مُبتلا ہے اَور ناپاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","لہٰذا وہ سُوتی یا اُونی یا بُنے ہویٔے کپڑے کو یا چمڑے کی چیز کو جِس پر وہ پھپھُوندی پھیلی ہُوئی ہو ضروُر جَلا دے اَور چونکہ وہ نُقصان دہ پھپھُوندی ہے اِس لیٔے اُس سے متاثّرہ تمام اَشیا ضروُر جَلا دی جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","”لیکن اگر کاہِنؔ کے مُعائنہ کرتے وقت وہ پھپھُوندی سُوت سے بُنے ہویٔے یا بُنے ہویٔے کپڑے میں یا چمڑے کی بنی ہُوئی کسی شَے میں پھیلی نہ ہو ");
INSERT INTO urdoucv_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","تو کاہِنؔ حُکم دے کہ اُس متعدّی کپڑے کو دھو لیا جائے۔ تَب وہ اُس کو اَور سات دِن تک علیحدہ رکھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","جَب متاثّرہ چیز دھوئی جا چُکی ہو تو کاہِنؔ اُس کا دوبارہ مُعائنہ کرے اَور چاہے پھپھُوندی کے رنگ میں تبدیلی نہ ہُوئی ہو اَور نہ ہی وہ زِیادہ پھیلی ہو، تو بھی وہ ناپاک ہی ہے۔ اُسے آگ میں جَلا دیا جائے چاہے پھپھُوندی کپڑے کے اَندر یا باہر کی طرف نُقصان پہُنچائی ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","اَور اگر کاہِنؔ اُس کا مُعائنہ کرے اَور اُسے یہ مَعلُوم چلے کہ کپڑے کو دھونے کے بعد پھپھُوندی کا رنگ ہلکا پڑ گیا ہے، تو وہ اُس کپڑے یا چمڑے کے یا اُس کے تانے بانے کے آلُودہ حِصّہ کو پھاڑ کر الگ کر دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","لیکن اگر وہ پھپھُوندی اُس کپڑے میں یا اُس سے بنی ہُوئی کسی بُنی ہُوئی چیز میں یا چمڑے کی کسی چیز میں پھر سے نموُدار ہو تو گویا وہ اُس میں پھیل رہی ہے لہٰذا لازِم ہے کہ اُس متعدّی پھپھُوندی سے متاثر چیز کو آگ میں جَلا دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","اَور اگر اُس کپڑے یا کپڑے سے بنی ہُوئی یا بُنی ہُوئی یا چمڑے کی بنی ہُوئی کسی چیز کو دھونے کے بعد اُس کی پھپھُوندی جاتی رہے تو اُسے پھر سے دھویا جائے اَور تَب وہ پاک سَمجھی جائے گی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","اُونی یا سُوتی کپڑے، سُوت یا اُون سے بُنے ہویٔے لباس یا چمڑے کی بنی ہُوئی کسی چیز میں کوڑھ کی متعدّی لگی ہو، تو اُسے پاک یا ناپاک قرار دینے کے ضوابط یہی ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","”کسی کوڑھی کے پاک قرار ٹھہرانے کی رسمی طہارت کے ضوابط یہ ہیں، جَب اُسے کاہِنؔ کے پاس لایا جائے: ");
INSERT INTO urdoucv_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","کاہِنؔ چھاؤنی کے باہر جا کر اُس کا مُعائنہ کرے۔ اَور اگر وہ شخص اَپنی کوڑھ کی بیماری سے شفایاب ہو چُکاہے، ");
INSERT INTO urdoucv_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","تو کاہِنؔ حُکم دے کہ پاک قرار دئیے جانے والے کے لیٔے دو زندہ پاک پرندے اَور دیودار کی لکڑی اَور قِرمزی رنگ کا سُوت اَور زُوفا لایا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","پھر کاہِنؔ بہتے ہویٔے پانی کے اُوپر مٹّی کے ایک برتن میں اُن دونوں پرندوں میں سے ایک پرندے کو ذبح کرنے کا حُکم دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","پھر وہ دُوسرے زندہ پرندہ کو دیودار کی لکڑی اَور قِرمزی سُوت اَور زُوفا ساتھ لے کر اُنہیں اَور اُس زندہ پرندہ کو اُس پرندہ کے خُون میں ڈُبو دے جسے بہتے ہویٔے پانی کے اُوپر ذبح کیا گیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","اَور کاہِنؔ اُس پرندہ کے خُون کو سات بار اُس شخص پر چھڑک دے، جو کوڑھ سے پاک و صَاف قرار دیا جا رہاہے، پھر کاہِنؔ اُس شخص کو پاک و صَاف قرار دے اَور اُس زندہ پرندہ کو کھُلے میدان میں چھوڑ دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","”پھر اُس پاک و صَاف قرار دئیے جانے والے شخص کے لیٔے لازِم ہے کہ وہ اَپنے کپڑے دھوئے اَپنے سارے بال مُنڈوائے اَور پانی سے غُسل کرے، تَب وہ رسماً پاک سمجھا جائے گا۔ اِس کے بعد ہی وہ چھاؤنی میں آسکتا ہے، لیکن ضروُری ہے کہ وہ سات دِن تک اَپنے خیمہ سے باہر ہی ٹھہرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","اَور ساتویں دِن وہ اَپنے سَر کے بال، داڑھی، اَبرو اَور سارے بال ضروُر مُنڈوا لے؛ لازِم ہے کہ وہ اَپنے کپڑے دھوئے اَور پانی سے غُسل کرے۔ تَب وہ پاک ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","”اَور آٹھویں دِن وہ دو بے عیب نر برّے اَور ایک ایک سالہ بے عیب مادہ برّہ اَور اناج کی نذر کے لیٔے پانچ کِلو کے برابر تیل مِلا ہُوا مَیدہ اَور ایک تہائی لیٹر تیل لے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","پھر جو کاہِنؔ اُس شخص کو پاک قرار ہونے کا اعلان کر رہاہے، وہ خیمہ اِجتماع کے مدخل پر اُس شخص کو اَور اِن چیزوں کو یَاہوِہ کے حُضُور پیش کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","”پھر کاہِنؔ ایک نر برّہ اَور ایک تہائی لیٹر تیل کو خطا کی قُربانی کے واسطے اَور ہلانے کی نذر کی قُربانی کے طور پر یَاہوِہ کے حُضُور پیش کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","اِس کے بعد کاہِنؔ اُس نر برّہ کو اُس پاک مَقدِس میں ذبح کرے، جہاں گُناہ کی قُربانی اَور سوختنی نذر کے جانوروں کو ذبح کیا جاتا ہے؛ کیونکہ گُناہ کی قُربانی، خطا کی قُربانی کے مانند کاہِنؔ کا مُقرّر حِصّہ ہے؛ اَور یہ نہایت ہی مُقدّس ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","اَور کاہِنؔ اُس خطا کی قُربانی کا کچھ خُون لے کر پاک قرار دئیے جانے والے شخص کے داہنے کان کی لَو پر، داہنے ہاتھ کے انگُوٹھے پر اَور داہنے پاؤں کے انگُوٹھے پر لگائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","اِس کے بعد کاہِنؔ اُس ایک تہائی لیٹر تیل میں سے کچھ تیل لے کر اَپنے بائیں ہاتھ کی ہتھیلی پر اُنڈیل دے، ");
INSERT INTO urdoucv_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","پھر کاہِنؔ اَپنے داہنی ہاتھ کی اُنگشتِ شہادت کو اَپنی بائیں ہتھیلی میں رکھے ہُوئے تیل میں ڈبوئے اَور اَپنی اُنگلی سے اُس تیل کو سات بار یَاہوِہ کے حُضُور چھڑکے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","اَور کاہِنؔ اَپنی ہتھیلی کے باقی بچے ہویٔے تیل میں سے کچھ پاک قرار دیئے جانے والے کے داہنے کان کی لَو پر، اُس کے داہنے ہاتھ کے انگُوٹھے پر اَور اُس کے داہنے پاؤں کے انگُوٹھے پر لگا دے، جِن پر خطا کی قُربانی کا خُون لگا ہُواہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","اَور کاہِنؔ اَپنی ہتھیلی کے باقی بچے ہویٔے تیل کو پاک قرار دئیے جانے والے شخص کے سَر پر بھی لگا دے اَور یَاہوِہ کے حُضُور اُس کے لیٔے کفّارہ دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","”اَور پھر کاہِنؔ گُناہ کی قُربانی پیش کرنے اَور ناپاکی سے پاک قرار دیئے جانے والے کے لیٔے کفّارہ دے۔ اُس کے بعد کاہِنؔ سوختنی نذر کے جانور کو ذبح کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","اَور کاہِنؔ اُسے سوختنی نذر اَور اناج کی نذر کی قُربانی کے ہمراہ مذبح پر چڑھا کر کفّارہ دے اَور وہ پاک ٹھہرے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","”لیکن اگر وہ شخص غریب ہو اَور اُسے اِتنا مقدور نہ ہو تو وہ اَپنا کفّارہ دینے کی خاطِر ہلانے کی نذر کی قُربانی کے طور پر خطا کی قُربانی کے واسطے ایک نر برّہ اَور اناج کی نذر کے واسطے تیل مِلا ہُوا ڈیڑھ کِلو مَیدہ اَور ایک تہائی لیٹر تیل، ");
INSERT INTO urdoucv_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","اَور اَپنے مقدور کے مُطابق دو قُمریاں یا کبُوتر کے دو بچّے، جِن میں سے ایک گُناہ کی قُربانی کے لیٔے اَور دُوسرا سوختنی نذر کے لیٔے لے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","”آٹھویں دِن وہ اُنہیں اَپنے پاک قرار دئیے جانے کے لیٔے خیمہ اِجتماع کے مدخل پر یَاہوِہ کے حُضُور کاہِنؔ کے پاس لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","اَور کاہِنؔ خطا کی قُربانی کے اُس برّہ کو اَور ایک تہائی لیٹر تیل کو لے کر یَاہوِہ کے حُضُور ہلانے کی نذر کی قُربانی کے طور پر گزرانے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","پھر کاہِنؔ خطا کی قُربانی کے لیٔے برّہ کو ذبح کرے اَور اُس کا کچھ خُون لے کر پاک قرار دئیے جانے والے شخص کے داہنے کان کی لَو پر، اُس کے داہنے ہاتھ کے انگُوٹھے پر اَور داہنے پاؤں کے انگُوٹھے پر لگائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","اَور کاہِنؔ اُس تیل میں سے کچھ تیل کو اَپنے بائیں ہاتھ کی ہتھیلی میں اُنڈیلے، ");
INSERT INTO urdoucv_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","اَور کاہِنؔ اَپنے داہنے ہاتھ کی اُنگشتِ شہادت سے اَپنی بائیں ہتھیلی میں رکھے تیل میں سے کچھ تیل کو سات بار یَاہوِہ کے حُضُور چھڑکے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","پھر کاہِنؔ اَپنی ہتھیلی کے تیل میں سے کچھ تیل وہ اُن جگہوں پر لگائے جہاں اُس نے خطا کی قُربانی کا خُون لگایا تھا یعنی پاک قرار دیئے جانے والے کے داہنے کان کی لَو پر، داہنے ہاتھ کے انگُوٹھے پر اَور داہنے پاؤں کے انگُوٹھے پر لگا دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","اَور کاہِنؔ اَپنی ہتھیلی کے باقی تیل کو پاک قرار دئیے جانے والے شخص کے سَر پر لگا دے تاکہ کاہِنؔ یَاہوِہ کے حُضُور اُس کے لیٔے کفّارہ دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","پھر وہ قُمریوں یا کبُوتر کے بچّوں میں سے ایک ایک جنہیں وہ لا سَکا ہو، اُن کی قُربانی پیش کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","یعنی جو کُچھ اُسے مُیسّر ہُوا ہو، اُس میں سے اناج کی نذر کے ساتھ، ایک گُناہ کی قُربانی کے طور پر اَور ایک سوختنی نذر کے طور پر پیش کرے۔ اِس طرح کاہِنؔ پاک قرار دئیے جانے والے شخص کے لیٔے یَاہوِہ کے حُضُور میں کفّارہ دے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","یہ اُس شخص کے لیٔے طریقہ ہے جو کوڑھ کی متعدّی بیماری میں مُبتلا ہے اَور اَپنے پاک ہونے کے لیٔے باقاعدہ نذر مُہیّا نہیں کر سَکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","اَور یَاہوِہ نے مَوشہ اَور اَہرونؔ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","”جَب تُم مُلکِ کنعانؔ میں داخل ہو، جسے میں تُمہیں تمہاری مِلکیّت کے طور پر دے رہا ہُوں، اَور مَیں اُس مُلک میں کسی گھر میں متعدّی پھپھُوندی پیدا کروں، ");
INSERT INTO urdoucv_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","تو لازِم ہوگا کہ اُس گھر کا مالک جا کر کاہِنؔ کو بتائے، ’مَیں نے اَپنے گھر میں متعدّی پھپھُوندی جَیسی کویٔی چیز دیکھی ہے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","تو کاہِنؔ اُس گھر کا مُعائنہ کرنے سے پیشتر حُکم دے کہ وہ اُس پھپھُوندی والے گھر کو خالی کر دیں تاکہ اُس گھر کی کویٔی چیز ناپاک نہ ٹھہرائی جائے۔ اِس کے بعد کاہِنؔ جا کر اُس گھر کا مُعائنہ کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","اَور کاہِنؔ دیواروں پر اُس پھپھُوندی کا مُعائنہ کرے، اَور اگر وہ ہری یا سُرخی مائل لکیروں کی طرح ہو، جو دیوار میں سطح کے اَندر گہری دِکھائی دے، ");
INSERT INTO urdoucv_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","تو کاہِنؔ اُس گھر کے دروازہ سے باہر جائے اَور سات دِن کے لیٔے اُسے بند کر دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","اَور ساتویں دِن کاہِنؔ اُس گھر کا دوبارہ مُعائنہ کرے۔ اَور اگر وہ پھپھُوندی دیواروں پر پھیل گئی ہو، ");
INSERT INTO urdoucv_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","تو کاہِنؔ حُکم دے کہ پھپھُوندی سے متاثّرہ پتّھروں کو نکال کر شہر سے باہر کسی ملبے کے ڈھیر میں پھینک دئیے جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","اَور اِس کے بعد کاہِنؔ حُکم دے کہ گھر کی تمام اَندرونی دیواریں کھُرچی جایٔیں اَور کھُرچن کو شہر سے باہر کسی ملبے کے ڈھیر پر پھینک دئیے جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","پھر وہ اُن پتّھروں کی جگہ دُوسرے پتّھر لگائیں اَور تازہ گارے سے اُس گھر کا پلستر کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","”اَور اگر وہ پھپھُوندی اُس گھر میں پتّھر نکالنے، کھُرچنے اَور پلستر کرنے کے بعد بھی دوبارہ نموُدار ہو جایٔے، ");
INSERT INTO urdoucv_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","تو کاہِنؔ اَندر جا کر اُس کا مُعائنہ کرے اَور اگر وہ پھپھُوندی اُس گھر میں پھیل گئی ہو تو وہ متعدّی پھپھُوندی ہے اَور وہ گھر ناپاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","چنانچہ اُس گھر کو ضروُر گرا دیاجایٔے، وہ اُس کے پتّھر، لکڑیاں اَور اُس کے پلستر کو شہر سے باہر کسی ملبے کے ڈھیر پر پھینک دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","”اَور اِس کے علاوہ، اگر کویٔی شخص اُس وقت بند کئے ہویٔے گھر میں داخل ہو، تو وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","اِسی طرح اگر کویٔی شخص اُس گھر میں سوئے یا کچھ کھائے تو وہ اَپنے کپڑے ضروُر دھولے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","”لیکن اگر کاہِنؔ اُس کا مُعائنہ کرے اَور دیکھے کہ اُس گھر کا پلستر کرنے کے بعد دوبارہ پھپھُوندی نہیں پھیلی ہے، تو وہ اُس گھر کو پاک ٹھہرائے کیونکہ پھپھُوندی ختم ہو چُکی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","تَب کاہِنؔ اُس گھر کو پاک کرنے کے لیٔے دو پرندے، دیودار کی لکڑی، سُرخ دھاگے اَور زُوفا لے کر، ");
INSERT INTO urdoucv_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","اُن پرندوں میں سے ایک کو بہتے پانی پر مٹّی کے کسی برتن میں ذبح کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","اِس کے بعد وہ دیودار کی اُس لکڑی، زُوفا، سُرخ دھاگے اَور اُس زندہ پرندہ کو لے کر اُن کو اُس مُردہ پرندہ کے خُون اَور بہتے پانی میں ڈُبو کر سات بار اُس گھر میں چھڑکے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","اِس طرح وہ اُس گھر کی طہارت اُس پرندہ کے خُون، اَور بہتے ہویٔے پانی، اُس زندہ پرندہ، دیودار کی لکڑی، زُوفا اَور اُس سُرخ دھاگے سے کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","پھر وہ اُس زندہ پرندہ کو شہر کے باہر کھُلے میدان میں چھوڑ دے۔ اِس طریقہ سے وہ اُس گھر کے لیٔے کفّارہ دے اَور وہ گھر پاک ٹھہرے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","جِلد کی ہر قِسم کی کوڑھ جَیسی بیماری کے لیٔے یہی ضوابط ہیں: خارِش کے لیٔے، ");
INSERT INTO urdoucv_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","کپڑوں یا گھر میں لگنے والی متعدّی پھپھُوندی کے لیٔے، ");
INSERT INTO urdoucv_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","سُوجن، دانے یا چمکیلے داغ کے لیٔے، ");
INSERT INTO urdoucv_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","اَور یہ فیصلہ کرنے کے لیٔے کہ کب کویٔی چیز پاک یا ناپاک ہے۔ جِلد کی متعدّی بیماریوں اَور متعدّی پھپھُوندی کے لیٔے یہی ضوابط ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","اَور یَاہوِہ نے مَوشہ اَور اَہرونؔ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","”بنی اِسرائیل سے کلام کرو اَور اُن سے کہو: ’اگر کویٔی شخص غَیر مَعمولی جِسمانی جریان میں مُبتلا ہو تو وہ جریان ناپاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","خواہ یہ اُس کے جِسم سے بہتا رہتا ہو یا بندہو گیا ہو، یہ اُس کی ناپاکی کا باعث ہوگا۔ اُس کا جریان ناپاکی کا باعث اِس طرح ہوگا: ");
INSERT INTO urdoucv_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","” ’جِس بِستر پر جریان کا مریض لیٹے گا وہ بِستر ناپاک ہوگا اَور جِس چیز پر وہ بیٹھے گا وہ چیز ناپاک ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","اَورجو کویٔی اُس کے بِستر کو چھُوئے اُسے لازِم ہے کہ وہ اَپنے کپڑے دھوکر پانی سے غُسل کرے اَور وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","اَورجو کویٔی اُس چیز پر بیٹھے جِس پر جریان کا مریض بیٹھا تھا، تو وہ ضروُر اَپنے کپڑے دھوکر پانی سے غُسل کرے اَور وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","” ’اَورجو کویٔی جریان کے مریض کو چھُوئے وہ اَپنے کپڑے دھوکر پانی سے غُسل کرے اَور وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","” ’اَور اگر جریان کا مریض کسی دُوسرے شخص پرجو پاک ہو تھُوک دے، تو وہ پاک شخص ضروُر اَپنے کپڑے دھوکر پانی سے غُسل کرے اَور وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","” ’ہر ایک زین، جِس پر جریان کا مریض سواری کرتا ہے، وہ زین ناپاک ہو جائے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","اگر کویٔی شخص اُن چیزوں میں سے کسی چیز کو چھُوئے گا، جِس پر جریان کا مریض بیٹھا ہو، تو وہ شام تک ناپاک رہے گا۔ اَورجو کویٔی اُن چیزوں کو اُٹھاتا ہے وہ ضروُر اَپنے کپڑے دھوکر پانی سے غُسل کرے، اَور وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","” ’اَور جریان کا مریض اَپنے ہاتھ دھوئے بغیر جِس کسی کو چھُوئے، تو وہ شخص ضروُر اَپنے کپڑے دھوکر پانی سے غُسل کرے اَور وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","” ’اَور اگر جریان کا مریض کسی مٹّی کے برتن کو چھُوئے، تو اُس برتن کو ضروُر توڑ دیا جائے لیکن اگر برتن لکڑی کا ہو، تو اُسے پانی سے دھو لیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","” ’اَور جَب کویٔی مریض جریان سے شفایاب ہو جائے، تو وہ رسماً پاک ٹھہرنے کے لیٔے سات دِن گنے؛ تَب وہ اَپنے کپڑے دھوئے اَور بہتے ہویٔے پانی میں غُسل کرے، تَب وہ پاک ہو جایٔےگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","اَور آٹھویں دِن وہ اَپنے لیٔے دو قُمریاں یا کبُوتر کے دو بچّے لے کر خیمہ اِجتماع کے مدخل پر یَاہوِہ کے حُضُور آئے اَور اُنہیں کاہِنؔ کے حوالہ کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","کاہِنؔ اُن میں سے ایک کو گُناہ کی قُربانی کے طور پر اَور دُوسرے کو سوختنی نذر کے طور پر گذرانے۔ یُوں کاہِنؔ یَاہوِہ کے حُضُور اُس شخص کے لیٔے اُس کے جریان کے سبب سے کفّارہ دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","” ’اگر کسی مَرد کا نطفہ خارج ہو جایٔے، تو اُسے لازِم ہے کہ وہ پانی سے غُسل کرے اَور شام تک وہ ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","اَور جِس کپڑے یا چمڑے پر نطفہ گِر جایٔے، لازماً اُسے پانی سے دھویا جائے اَور وہ چیز شام تک ناپاک رہے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","اَور جَب کویٔی مَرد عورت سے ہم بِستر ہو اَور اُس کا نطفہ خارج ہو جائے، تو وہ دونوں پانی سے غُسل کریں اَور شام تک ناپاک رہیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","” ’جَب کسی عورت کو حَیض کا خُون جاری ہو جائے، تو وہ عورت سات دِن تک ناپاک رہے گی اَورجو کویٔی اُسے چھُوئے گا، وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","” ’اَور حَیض کے دِنوں میں جِس چیز پر بھی وہ لیٹے گی اَور بیٹھے گی وہ ناپاک ہو جائے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","لہٰذا جو کویٔی اُس کے بِستر کو چھُوئے، وہ اَپنے کپڑے دھوکر پانی سے غُسل کرے۔ اَور وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","اَورجو کویٔی اُس چیز کو چھُولے جِس پر وہ بیٹھتی ہو، تو وہ اَپنے کپڑے دھوکر پانی سے غُسل کرے۔ اَور وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","اَور جِس چیز پر وہ بیٹھی ہو خواہ وہ اُس کا بِستر ہو یا کویٔی اَور چیز، اگر کویٔی اُسے چھُوئے گا، تو وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","” ’اگر کویٔی مَرد اُس کے ساتھ ہم بِستر ہو، اَور حَیض کا خُون اُسے لگ جائے تو وہ سات دِن تک ناپاک رہے گا، اَور جِس بِستر پر وہ لیٹے گا وہ بھی ناپاک ہو جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","” ’اَور اگر کسی عورت کو حَیض کے دِنوں کے علاوہ یا حَیض کی مُدّت کے بعد بھی بہت دِنوں تک خُون جاری رہے تو وہ خُون جاری رہنے تک ناپاک رہے گی جَیسی حَیض کے دِنوں میں رہتی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","اَور جریان خُون کے دَوران جِس بِستر پر وہ لیٹے گی تو وہ اُسی طرح ناپاک ہوگا جِس طرح اُس کا بِستر حَیض کے دِنوں میں ناپاک ہوتاہے۔ اَور جِس چیز پر وہ بیٹھے گی وہ بھی حَیض کے دِنوں کی ناپاکی کی طرح ناپاک ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","اَورجو کویٔی اُن چیزوں کو چھُوئے گا وہ ناپاک ہو جائے گی؛ لہٰذا وہ اَپنے کپڑے ضروُر دھوکر پانی سے غُسل کرے۔ اَور وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","” ’اَور جَب وہ عورت اَپنے جریان خُون سے شفایاب ہو جایٔے، تو وہ اَپنے پاک ہونے کے لیٔے سات دِن گنے، اَور اُس کے بعد وہ رسماً پاک ہو جایٔےگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","اَور آٹھویں دِن لازِم ہے کی وہ اَپنے لیٔے دو قُمریاں یا کبُوتر کے دو بچّے لے کر اُنہیں خیمہ اِجتماع کے مدخل پر کاہِنؔ کے پاس لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","اَور کاہِنؔ اُن میں سے ایک کو گُناہ کی قُربانی کے لیٔے اَور دُوسرے کو سوختنی نذر کے لیٔے گذرانے۔ اَور یُوں کاہِنؔ اُس کے ناپاک خُون کے جریان کے لیٔے یَاہوِہ کے حُضُور اُس کی طرف سے کفّارہ دے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","” ’اِس طرح تُم بنی اِسرائیل کو اُن کی ناپاکی سے ہمیشہ دُور رکھوگے، تاکہ وہ میری قِیام گاہ کو جو اُن کے درمیان ہے، ناپاک کرنے کی وجہ سے اَپنی ناپاکی میں ہلاک نہ ہوں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","یہ ضوابط اُس مَرد کے لیٔے ہیں جو نطفہ خارج ہونے کا مریض ہے اَور جِس کا نطفہ خارج ہو رہاہے جِس کی باعث وہ ناپاک ہو گیا ہے، ");
INSERT INTO urdoucv_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","اَور اُس عورت کے لیٔے بھی، جسے حَیض آ رہا ہو، اَور اُس مَرد یا عورت کے لیٔے بھی جو جریان میں مُبتلا ہُوں اَور اُس مَرد کے لیٔے بھی جو رسمی طور پر ناپاک عورت سے ہم بِستر ہو رہاہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","اَہرونؔ کے دونوں بیٹوں کی وفات کے بعد، یَاہوِہ مَوشہ سے ہم کلام ہُوئے، کیونکہ اُن کے دونوں بیٹے یَاہوِہ کی حُضُوری میں پاک ترین مقام میں داخل ہوکر مَر گیٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","اَور یَاہوِہ نے مَوشہ سے فرمایا: ”اَپنے بھایٔی اَہرونؔ کو حُکم دو جَب دِل چاہے تَب پردہ کے پیچھے پاک ترین مقام میں کفّارہ کے سرپوش کے سامنے جو عہد کے صندُوق پر ہے نہ آیا کرے ورنہ وہ مَر جائے گا۔ کیونکہ مَیں کفّارہ کے سرپوش کے اُوپر بادل میں ظاہر ہوتا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","”اِن قوانین پر عَمل کرنے کے بعد ہی اَہرونؔ پاک ترین مقام میں اِس طرح داخل ہُوں، وہ گُناہ کی قُربانی کے لیٔے ایک جَوان بچھڑا اَور سوختنی نذر کے لیٔے ایک مینڈھا ساتھ ضروُر لائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","وہ کتان کا مُقدّس کُرتہ پہنے اَور کتان کا لباس اَور اَپنے نیچے پاجامہ پہنے ہو؛ اَور کتان کے پٹکے سے اُس کی کمر بندھی ہو، اَور اُس کے سَر پر کتان کا عمامہ بندھا ہو؛ یہ مُقدّس لباس ہیں لہٰذا وہ اُنہیں پہننے سے پیشتر پانی سے غُسل کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","اَور وہ اِسرائیلی جماعت سے گُناہ کی قُربانی کے لیٔے دو بکرے اَور سوختنی نذر کے لیٔے ایک مینڈھا لے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","”اَور اَہرونؔ خُود اَپنی اَور اَپنے گھرانے کی خاطِر گُناہ کی قُربانی کے لیٔے اُس بچھڑے کو پیش کرے تاکہ اُس کے لیٔے اَور اُس کے گھرانے کے لیٔے کفّارہ اَدا ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","پھر وہ اُن دونوں بکروں کو لے کر خیمہ اِجتماع کے مدخل پر یَاہوِہ کے حُضُور میں کھڑا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","اَور اَہرونؔ اُن دونوں بکروں پر قُرعہ ڈالیں ایک قُرعہ یَاہوِہ کے لیٔے اَور دُوسرا قُرعہ عزازیلؔ کے لیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","اَور اَہرونؔ اُس بکرے کو جِس پر یَاہوِہ کے نام کا قُرعہ نِکلا تھا، اُسے گُناہ کی قُربانی کے لیٔے گذرانے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","لیکن جِس بکرے پر عزازیلؔ کے نام کا قُرعہ نِکلا تھا، اُسے زندہ ہی یَاہوِہ کے حُضُور میں کفّارہ اَدا کرنے کے لیٔے پیش کیا جا سکے اَور وہ بیابان میں عزازیلؔ کے لیٔے چھوڑ دیاجایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","”اَور اَہرونؔ خُود اَپنے گُناہ کی قُربانی کے لیٔے اُس بچھڑے کو لایٔے تاکہ اَپنے اَور اَپنے گھرانے کے لیٔے کفّارہ دے اَور وہ اَپنے گُناہ کی قُربانی کے لیٔے اُس بچھڑے کو ذبح کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","اَور وہ ایک بخُوردان لے جِس میں یَاہوِہ کے مذبح پر کے آگ کے اَنگارے بھرے ہُوں اَور اَپنی دونوں مُٹھّیوں میں مہین پِسا ہُوا خُوشبودار بخُور لے کر اُسے پردہ کے اَندر لائے، ");
INSERT INTO urdoucv_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","اَور وہ اُس بخُور کو یَاہوِہ کے حُضُور آگ میں ڈال دے تاکہ اُس بخُور کا دُھواں کفّارہ کے سرپوش کو جو شہادت کے صندُوق کے اُوپر ہے چھُپا لے کہ وہ ہلاک نہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","پھر وہ اُس بچھڑے کا کچھ خُون لے کر اُسے اَپنی اُنگلی سے اُسے مشرقی سمت کی طرف کفّارہ کے سرپوش کے سامنے چھڑکے اَور پھر اُس خُون میں سے کچھ وہ اَپنی اُنگلی سے سات بار کفّارہ کے سرپوش کے آگے چھڑکے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","”پھر وہ گُناہ کی قُربانی کے بکرے کو ذبح کرے جو اُمّت کے لیٔے ہے اَور اُس کے خُون کو پردہ کے اَندر لے جا کر اُس سے بھی وُہی کرے جو اُس نے بچھڑے کے خُون کے ساتھ کیا تھا؛ وہ اُسے کفّارہ کے سرپوش کے اُوپر اَور اُس کے سامنے چھڑک دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","اِس طرح وہ بنی اِسرائیل کی ساری ناپاکی، بغاوت اَور گُناہوں کے سبب سے پاک ترین مقام کے لیٔے کفّارہ دے؛ اَور اَیسا ہی وہ خیمہ اِجتماع کے لیٔے بھی کرے جو اُن کے ساتھ اُن کی ناپاکی کے درمیان رہتاہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","اَور جَب اَہرونؔ کفّارہ دینے کو پاک ترین مقام کے اَندر جایٔیں تو جَب تک وہ اَپنے اَور اَپنے گھرانے اَور بنی اِسرائیل کی ساری جماعت کے لیٔے کفّارہ دے کر باہر نہ آ جایٔیں اُس وقت تک کویٔی بھی شخص خیمہ اِجتماع کے اَندر مَوجُود نہ رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","”پھر وہ باہر نکل کر اُس مذبح کے پاس جائے جو یَاہوِہ کے حُضُور ہے اَور اُس کے لیٔے کفّارہ دے۔ اَور وہ اُس بچھڑے اَور اُس بکرے کا کچھ خُون لے کر مذبح کے سَب سینگوں پر لگائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","اَور کچھ خُون اَپنی اُنگلی سے سات بار اُس پر چھڑکے اَور اُسے بنی اِسرائیل کی ناپاکی کی حالتوں سے پاک کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","”اَور جَب اَہرونؔ پاک ترین مقام، اَور خیمہ اِجتماع اَور مذبح کے لیٔے کفّارہ دے چُکیں تو وہ زندہ بکرے کو سامنے لائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","اَور اَہرونؔ اَپنے دونوں ہاتھ اُس کے سَر پر رکھ کر اُس کے اُوپر بنی اِسرائیل کی ساری بدکاریوں، نافرمانیوں اَور اُن کے تمام گُناہوں کا اقرار کریں اَور اُنہیں اُس بکرے کے سَر پر ڈال کر، اُس بکرے کو کسی مُقرّر شخص کے ذریعے بیابان میں بھیج دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","اَور وہ بکرا اُن کے تمام گُناہوں کو اَپنے اُوپر اُٹھاکر اُنہیں کسی ویرانہ میں لے جائے گا چنانچہ وہ شخص اُس بکرے کو بیابان میں چھوڑ دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","”اِس کے بعد اَہرونؔ خیمہ اِجتماع میں جا کر کتان کے وہ کپڑے جو اُنہُوں نے پاک ترین مقام میں داخل ہونے سے پیشتر پہنے ہویٔے تھے، اُتار دیں اَور اُنہیں وہیں چھوڑ دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","پھر وہ پاک مَقدِس میں پانی سے غُسل کرے اَور اَپنے عام کپڑے پہن لے۔ اَور پھر باہر آکر اَپنے لیٔے اَور اُمّت کے لیٔے سوختنی نذر پیش کرے، اَور اَپنے لیٔے اَور اُمّت کے لیٔے کفّارہ دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","اَور وہ گُناہ کی قُربانی کی چربی کو مذبح پر آگ میں جَلا دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","”اَور وہ شخص جو اُس بکرے کو عزازیلؔ کے لیٔے چھوڑکر آئے، وہ اَپنے کپڑے ضروُر دھوئے اَور پانی سے غُسل کرے؛ اُس کے بعد ہی وہ شخص چھاؤنی میں داخل ہو سکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","اَور گُناہ کی قُربانیوں کے بَیل اَور بکرے کو جِن کا خُون کفّارہ دینے کے لیٔے پاک ترین مقام میں لایا گیا تھا؛ اُنہیں چھاؤنی سے باہر ضروُر لے جایا جائے اَور اُن کی کھال، گوشت اَور آنتوں وغیرہ کو آگ میں جَلا دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","اَور اُنہیں جَلانے والا شخص ضروُر اَپنے کپڑے دھوئے اَور پانی سے غُسل کرے۔ اِس کے بعد ہی وہ چھاؤنی میں داخل ہو سکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","”اَور تمہارے لیٔے یہ ایک دائمی فرمان ہوگا: تُم ساتویں مہینے کی دسویں تاریخ کو اَپنی اَپنی جان کو دُکھ دینا اَور کویٔی بھی خواہ وہ مُلک اِسرائیل کا باشِندہ ہو یا غَیراِسرائیلی جو تمہارے درمیان رہتا ہو کسی طرح کا کام نہ کرے؛ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","کیونکہ اِسی دِن تُمہیں پاک کرنے کے لیٔے تمہاری خاطِر کفّارہ دیا جائے گا۔ تَب تُم یَاہوِہ کے حُضُور اَپنے تمام گُناہوں سے پاک ٹھہروگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","یہ تمہارے لیٔے ایک خاص آرام کا سَبت ہے لہٰذا تُم اُس دِن اَپنی اَپنی جان کو دُکھ دینا۔ یہ ایک دائمی فرمان ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","اَور مُقدّس کتانی لباس پہن کر وُہی کاہِنؔ کفّارہ دے گا جو اَپنے باپ کی جگہ پر جانشین بطور اعلیٰ کاہِن ہونے کے لیٔے مَسح اَور مُقرّر کیا گیا ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","اَور وہ پاک ترین مقام، خیمہ اِجتماع، مذبح، کاہِنوں اَور جماعت کے تمام لوگوں کے لیٔے کفّارہ دے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","”یہ تمہارے لیٔے ایک دائمی فرمان ہوگا کہ سال میں ایک بار بنی اِسرائیل کے تمام گُناہوں کا کفّارہ دیا جائے۔“ اَور جَیسا یَاہوِہ نے مَوشہ کو حُکم دیا تھا اُس نے وَیسا ہی کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","پھر یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","”اَہرونؔ اَور اُس کے بیٹوں اَور تمام بنی اِسرائیلیوں کو حُکم دو: ’یَاہوِہ نے یہ حُکم دیا ہے: ");
INSERT INTO urdoucv_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","بنی اِسرائیل میں سے جو کویٔی شخص بَیل یا برّہ یا بکرے کو چھاؤنی کے اَندر یا باہر ذبح کرے ");
INSERT INTO urdoucv_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","اُسے خیمہ اِجتماع کے مدخل پر یَاہوِہ کے مَسکن کے آگے یَاہوِہ کے حُضُور میں بطور نذر پیش کرنے کے لیٔے نہ لایٔے، تو وہ شخص خُونی سمجھا جائے گا۔ اُس نے خُون بہایا ہے لہٰذا اُس شخص کو اَپنے لوگوں میں سے خارج کر دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","اَیسا اِس لیٔے ہے کہ بنی اِسرائیل اَپنی قُربانیاں جنہیں وہ اَب کُھلے میدانوں میں کر رہے ہیں، اُسے وہ کاہِنؔ کے پاس خیمہ اِجتماع کے مدخل پر یَاہوِہ کے حُضُور لاکر سلامتی کی نذر کے طور پر گزرانیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","اَور کاہِنؔ اُس خُون کو خیمہ اِجتماع کے مدخل پر یَاہوِہ کے مذبح کے مقابل چھڑکے اَور چربی کو یَاہوِہ کے لیٔے فرحت بخش خُوشبو کے طور پر جَلائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","اَور آئندہ کبھی بھی وہ اُن بکروں کے بُتوں کے لیٔے قُربانیاں نہ گزرانے جِس کی وجہ سے وہ زناکار ٹھہرے ہیں۔ یہ اُن کے لیٔے پُشت در پُشت دائمی فرمان ہوگا۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","”اَور اُن سے کہو: ’اگر بنی اِسرائیل کا کویٔی شخص یا کویٔی پردیسی جو اُن کے درمیان رہتاہے سوختنی نذر یا کویٔی اَور قُربانی گزرانے ");
INSERT INTO urdoucv_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","اَور اُسے خیمہ اِجتماع کے مدخل پر یَاہوِہ کے حُضُور میں پیش کرنے کو نہ لایٔے، تو وہ شخص اَپنے لوگوں میں سے خارج کر دیاجایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","” ’اگر بنی اِسرائیل کا کویٔی شخص یا اُن پردیسیوں میں سے کویٔی شخص جو اُن کے درمیان رہتاہے، اَور خُون کھائے تو میں اُس خُون کھانے والے کے خِلاف ہو جاؤں گا اَور اُسے اُس کے لوگوں سے خارج کر دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","کیونکہ جِسم کی جان خُون میں ہوتی ہے اَور اُسے مَیں نے تُمہیں اِس لیٔے دیا ہے کہ وہ مذبح پر تمہاری جانوں کے لیٔے کفّارہ ہو۔ کیونکہ خُون ہی ہے جو کسی جان کے بدلے میں کفّارہ دیتاہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","چنانچہ مَیں نے بنی اِسرائیل کو حُکم دیا ہے، ”تُم میں سے کویٔی بھی خُون نہ کھائے، اَور نہ ہی کویٔی غَیراِسرائیلی باشِندہ ہو جو تمہارے درمیان رہتاہے خُون کھائے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","” ’بنی اِسرائیل میں سے یا اُن غَیراِسرائیلی باشِندوں میں سے کویٔی شخص جو تمہارے درمیان رہتا ہو، اگر کسی جانور یا پرندہ کو جو کھانے کے لائق ہو شِکار کرے، تو وہ اُس کے خُون کو بہہ جانے دے اَور اُس کے خُون کو مٹّی سے ڈھانک دے، ");
INSERT INTO urdoucv_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","کیونکہ ہر جاندار کی جان اُس کے خُون میں ہوتی ہے۔ اِس لیٔے مَیں نے بنی اِسرائیل کو حُکم دیا ہے، ”تُم کسی جاندار کا خُون ہرگز نہ کھانا کیونکہ جاندار کا خُون ہی اُس کی جان ہے؛ اَورجو کویٔی اُسے کھائے اُسے اَپنے لوگوں میں سے خارج کر دیا جایٔےگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","” ’اَورجو شخص کسی مُردار یا جنگلی جانور کے پھاڑے ہویٔے جانور کو کھائے، خواہ وہ مُلک اِسرائیل کا باشِندہ ہو یا غَیراِسرائیلی اَپنے کپڑے دھوئے اَور پانی سے غُسل کرے، اَور وہ شام تک ناپاک رہے گا اَور اُس کے بعد رسماً پاک ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","لیکن اگر وہ اَپنے کپڑے نہ دھوئے اَور نہ ہی غُسل کرے، تو اُس کا گُناہ اُسی کے سَر پر ہوگا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","”بنی اِسرائیل سے مُخاطِب ہو اَور اُنہیں بتاؤ، ’مَیں یَاہوِہ تمہارا خُدا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","تُم وَیسے کام ہرگز نہ کرنا جَیسے مِصر میں لوگ کرتے تھے جہاں تُم رہا کرتے تھے، اَور وَیسے کام بھی نہ کرنا جَیسے لوگ مُلکِ کنعانؔ میں کرتے ہیں، جہاں میں تُمہیں لے جا رہا ہُوں؛ اَور نہ ہی اُن کی رسم و رِواج پر چلنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","تُم میرے آیٔین کی ضروُر تعمیل کرنا اَور میرے قوانین کو مان کر اُن پر چلنا۔ کیونکہ مَیں یَاہوِہ تمہارا خُدا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","تُم میرے قوانین اَور آئین پر عَمل کرنا کیونکہ جو شخص اُنہیں مانے گا وہ اُن ہی کی بدولت زندہ رہے گا؛ کیونکہ مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","” ’تُم میں سے کویٔی بھی جنسی تعلّقات قائِم کرنے کی غرض سے اَپنے کسی قریبی رشتہ دار کے پاس نہ جائے؛ کیونکہ مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","” ’تُم اَپنی ماں سے ہم بِستری کرکے اَپنے باپ کی بے عزّتی نہ کرنا کیونکہ وہ تمہاری ماں ہے؛ تُم اُس سے ہم بِستری نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","” ’تُم اَپنے باپ کی کسی بھی بیوی کے ساتھ ہم بِستری نہ کرنا کیونکہ اُس سے تمہارے باپ کی بےحُرمتی ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","” ’تُم اَپنی بہن سے ہم بِستری نہ کرنا خواہ وہ تمہارے باپ سے پیدا ہُوئی ہو یا تمہاری ماں سے پیدا ہُوئی ہو، اَور چاہے وہ تمہارے خاندان میں یا کسی اَور گھر میں پیدا ہُوئی ہو؛ تُم اُن سے ہم بِستری نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","” ’تُم اَپنی پوتی یا اَپنی نواسی سے ہم بِستری نہ کرنا کیونکہ اُس سے تمہاری اَپنی ہی بےحُرمتی ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","” ’تُم اَپنی سَوتیلی ماں کی بیٹی سے ہم بِستری نہ کرنا جو تمہارے باپ سے پیدا ہُوئی ہے، کیونکہ وہ تمہاری سَوتیلی بہن ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","” ’تُم اَپنی پھوپھی سے ہم بِستری نہ کرنا کیونکہ وہ تمہارے باپ کی قریبی رشتہ دار ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","” ’تُم اَپنی خالہ سے ہم بِستری نہ کرنا کیونکہ وہ تمہاری ماں کی قریبی رشتہ دار ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","” ’تُم اَپنے باپ کے بھایٔی کی بےحُرمتی اُس کی بیوی سے ہم بِستری کرکے نہ کرنا کیونکہ وہ تمہاری چچی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","” ’تُم اَپنی بہُو سے ہم بِستری نہ کرنا کیونکہ وہ تمہارے بیٹے کی بیوی ہے۔ اِس لیٔے تُم اُس سے جنسی تعلّقات قائِم نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","” ’تُم اَپنی بھاوج سے ہم بِستری نہ کرنا؛ کیونکہ اُس سے تمہارے بھایٔی کی بےحُرمتی ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","” ’تُم کسی عورت اَور اُس کی بیٹی دونوں سے ہم بِستری نہ کرنا اَور نہ ہی اُس عورت کی پوتی یا نواسی سے ہم بِستری کرنا کیونکہ وہ اُس کی قریبی رشتہ دار ہیں۔ یہ بڑی بدکاری ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","” ’جَب تک تمہاری بیوی زندہ ہے تُم اَپنی سالی کو اَپنی بیوی کی سوتن بنا کر اُس سے ہم بِستری نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","” ’تُم کسی عورت کے پاس اُس کے حَیض کے دِنوں میں اُس کی ناپاکی کی حالات میں ہم بِستری کے مقصد سے نہ جانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","” ’تُم اَپنے ہمسایہ کی بیوی سے ہم بِستری کرکے اُس کے ساتھ خُود کو بےحُرمت نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","” ’تُم اَپنی اَولاد میں سے کسی کو مولکؔ بُت کے لیٔے بطور آتِشی قُربانی ہرگز نہ گزراننا تاکہ تمہارے خُدا کے نام کی بےحُرمتی نہ ہو؛ کیونکہ مَیں ہی یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","” ’تُم مَرد کے ساتھ ہم بِستری نہ کرنا جَیسے عورت سے کی جاتی ہے؛ یہ نہایت ہی مکرُوہ کام ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","” ’تُم کسی جانور سے صحبت کرکے اَپنے آپ کو اُس کے باعث ناپاک نہ کرنا۔ اَور لازِم ہے کہ نہ ہی کویٔی عورت کسی جانور سے جنسی تعلّقات کرنے کو اُس کے سامنے آئے کیونکہ یہ مکرُوہ کام ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","” ’تُم اِن کاموں میں سے کسی بھی کام کو کرکے خُود کو ناپاک نہ کرنا کیونکہ جِن قوموں کو مَیں تمہارے سامنے بے دخل کرنے جا رہا ہُوں اُنہُوں نے اِسی طرح کے مکرُوہ کام کرکے خُود کو نجِس کیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","یہاں تک کہ اُن کا مُلک بھی اُن کی ناپاکی سے آلُودہ ہو چُکاہے۔ لہٰذا مَیں نے اُس کی بدکاری کی سزا اُسے دی ہے اَور اُس مُلک نے اَپنے باشِندوں کو اُگل دیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","چنانچہ تُم میرے قوانین اَور آئین کو ضروُر ماَننا۔ اَور تُم میں سے کویٔی بھی خواہ وہ مُلک اِسرائیل کا باشِندہ ہو یا غَیراِسرائیلی جو تمہارے درمیان قِیام کرتا ہو، اِن مکرُوہ کاموں میں سے کسی کام کو کبھی نہ کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","کیونکہ اُن لوگوں نے جو پہلے اُس مُلک میں رہتے تھے یہ سَب مکرُوہ کام کرکے مُلک کو آلُودہ کر دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","اَور اگر تُم بھی اُس مُلک کی ناپاکی کا باعث ہوگے تو وہ تُم کو بھی اُگل دے گا جَیسے اُس نے اُن قوموں کو جو تُم سے پہلے تھیں اُگل دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","” ’اَور اگر کویٔی شخص اِن مکرُوہ کاموں میں سے کویٔی بھی کام کرے، تو اُن تمام اَیسے اَشخاص کو ضروُر اَپنے لوگوں میں سے خارج کر دیاجایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","اِس لیٔے میرے تقاضوں کو ماَننا اَور وہ مکرُوہ رسمیں جو تُم سے پیشتر رائج تھیں، تُم اُن میں سے کسی مکرُوہ رسموں کو عَمل میں نہ لانا، اَور اُن میں پھنس کرکے خُود کو آلُودہ نہ کرنا۔ مَیں یَاہوِہ تمہارا خُدا ہُوں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","پھر یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","”بنی اِسرائیل کی ساری جماعت سے مُخاطِب ہو اَور اُن سے کہو، ’تُم پاک بنو، کیونکہ مَیں جو تمہارا یَاہوِہ خُدا ہُوں، پاک خُدا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","” ’اَور تُم میں سے ہر ایک اَپنی ماں اَور اَپنے باپ کا اِحترام کرے اَور تُم میرے سَبتوں کو ماَننا۔ مَیں یَاہوِہ تمہارا خُدا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","” ’تُم بُتوں کی طرف رُجُوع نہ ہونا اَور نہ ہی اَپنے لیٔے دھات سے ڈھالے ہویٔے معبُود بنانا۔ مَیں یَاہوِہ تمہارا خُدا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","” ’اَور جَب تُم یَاہوِہ کے حُضُور سلامتی کی نذر کی قُربانی پیش کرو، تو اُسے اِس طرح پیش کرنا کہ وہ تمہاری طرف سے مقبُول ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","اَور جِس دِن قُربانی پیش کی جائے وہ اُسی دِن یا اگلے دِن تک کھا لی جائے؛ اَور اگر اُس میں سے کچھ تیسرے دِن تک بچا رہ جائے تو اُسے ضروُر آگ میں جَلا دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","مگر تیسرے دِن اُس قُربانی کے گوشت میں سے کچھ بھی کھایا نہ جائے کیونکہ وہ آلُودہ ہو چُکاہے اَور قبُول نہ ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","اَورجو کویٔی اُسے کھائے گا اُس کا گُناہ اُسی کے سَر لگے گا کیونکہ اُس نے یَاہوِہ کی پاک چیز کو بےحُرمت کیا ہے؛ لہٰذا اُس شخص کو بھی جماعت سے ضروُر خارج کر دیاجایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","” ’اَور جَب تُم اَپنی زمین کی پیداوار کی فصل کاٹو، تو اَپنے کھیت کے اِنتہائی کناروں تک ساری کی ساری نہ کاٹنا اَور نہ ہی کٹائی کرتے وقت گری ہویٔی بالوں کو چُن لینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","اَور نہ ہی اَپنے انگوری باغ کے دانہ توڑنے دوبارہ جانا، اَور نہ اَپنے انگوری باغ کے گِرے ہویٔے دانوں کو جمع کرنا؛ بَلکہ اُنہیں غریبوں اَور پردیسیوں کے لیٔے چھوڑ دینا۔ مَیں یَاہوِہ تمہارا خُدا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","” ’تُم چوری نہ کرنا۔ ” ’تُم جھُوٹ مت بولنا۔ ” ’اَور نہ ایک دُوسرے کو دھوکا دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","” ’تُم میرا نام لے کر جھُوٹی قَسم نہ کھانا جِس سے تمہارے خُدا کے نام کی بےحُرمتی ہو۔ کیونکہ مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","” ’تُم اَپنے پڑوسی کو مت ٹھگنا اَور نہ ہی اُسے لُوٹنا۔ ” ’اَور نہ کسی مزدُور کی مزدُوری اَپنے پاس رات سے صُبح تک روکے رکھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","” ’تُم بہرے کو نہ بد دعا دینا، اَور نہ ہی اَندھے کے آگے کویٔی اَیسی شَے رکھنا جِس سے وہ ٹھوکر کھائے۔ بَلکہ اَپنے خُدا سے ڈرنا کیونکہ مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","” ’تُم فیصلہ کرتے وقت نااِنصافی مت کرنا؛ اَور نہ تو غریب کی طرفداری کرنا اَور نہ ہی بڑے شخص کی طرفداری، لہٰذا راستی سے اَپنے ہمسایہ کا اِنصاف کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","” ’تُم اَپنے لوگوں میں اِدھر اُدھر افواہیں پھیلاتے نہ پِھرنا۔ ” ’اَور نہ اَپنے پڑوسی کی زندگی کو خطرے میں ڈالنا کیونکہ مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","” ’اَور تُم اَپنے دِل میں اَپنے اِسرائیلی بھایٔی سے نفرت نہ رکھنا۔ تُم اَپنے ہمسایہ کو ضروُر ملامت کرنا، تاکہ تُم اُس کے خطا کے جُرم میں شریک نہ ہونے پاؤ۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","” ’اِنتقام نہ لینا اَور نہ اَپنی قوم کے کسی شخص سے کینہ رکھنا بَلکہ اَپنے پڑوسی سے اَپنی مانِند مَحَبّت رکھنا کیونکہ مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","” ’میرے قوانین کو ماَننا۔ ” ’اَپنے مویشیوں کو کسی مُختلف جنس کے مویشیوں سے جماع نہ کرنے دینا۔ ” ’اَپنے کھیت میں دو قِسم کے بیج ایک ساتھ نہ بونا۔ ” ’اَیسا کپڑا نہ پہننا جو دو مُختلف قِسم کے دھاگے سے تیّار کیا گیا ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","” ’اگر کویٔی شخص کسی اَیسی لونڈی سے ہم بِستری کر لے جو کسی اَور کی منگیتر ہو لیکن نہ تو اُس کا فدیہ دیا گیا ہو اَور نہ ہی وہ آزاد کی گئی ہو، چنانچہ اُن دونوں کو کویٔی مُناسب سزا ملے تاہم اُنہیں جان سے نہ ماراجائے کیونکہ وہ عورت آزاد نہیں تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","اَور وہ شخص اَپنے خطا کی قُربانی کے لیٔے خیمہ اِجتماع کے دروازہ پر یَاہوِہ کے حُضُور ایک مینڈھا لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","پھر کاہِنؔ خطا کی قُربانی کے مینڈھے سے یَاہوِہ کے حُضُور اُس شخص کے جُرم کا کفّارہ دے۔ تَب جو گُناہ اُس نے کیٔے ہیں اُسے مُعاف کر دیا جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","” ’اَور جَب تُم اُس مُلک میں داخل ہوکر وہاں تمام قِسم کے پھلدار درخت لگاؤ، تو اُن کا پھل تمہارے لیٔے ممنوع ہوگا اَور تین سال تک ممنوع ہوگا اَور تُم اُنہیں ہرگز نہ کھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","اَور چوتھے سال اُن کا تمام پھل خُوشی کے نذرانہ کے طور پر یَاہوِہ کے لیٔے پاک ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","لیکن پانچویں سال تُم اُن کا پھل کھا سکتے ہو۔ یُوں تمہاری فصل اِفراط کے ساتھ پیدا ہوگی۔ مَیں یَاہوِہ تمہارا خُدا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","” ’تُم اَیسا گوشت نہ کھانا جِس میں ابھی خُون ہو۔ ” ’اَور نہ ہی جادُو ٹونا کرنا، نہ فال دیکھنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","” ’تُم اَپنے کنپٹی کے بال مت کاٹنا اَور نہ اَپنی داڑھی کے بالوں کی کانٹ چھانٹ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","” ’تُم مُردوں کی خاطِر اَپنے جِسم کو زخمی نہ کرنا اَور نہ اَپنے اُوپر کچھ نقوش گُدوانا کیونکہ مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","” ’تُم اَپنی بیٹی کو فاحِشہ بنا کر ذلیل نہ کرنا۔ کہیں اَیسا نہ ہو کہ سارا مُلک جِسم فروشی کی طرف مائل ہوکر بدکاری سے بھر جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","” ’تُم میرے سَبتوں کو ماَننا اَور میرے پاک مَقدِس کی تعظیم کرنا کیونکہ مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","” ’تُم جادُوگروں اَور اَرواح پرستوں کے پاس نہ جانا اَور نہ ہی اُن کے طالب ہونا کیونکہ وہ تُمہیں نجِس بنا دیں گے۔ مَیں یَاہوِہ تمہارا خُدا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","” ’عُمر رسیدہ اَشخاص کے اِحترام میں اُٹھ کر کھڑے ہو جانا۔ بُوڑھوں کا اَدب کرنا اَور اَپنے خُدا سے ڈرنا کیونکہ مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","” ’اگر کویٔی پردیسی تمہارے ساتھ تمہارے مُلک میں قِیام کرتا ہو، تو اُس کے ساتھ بدسلُوکی نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","جو غَیراِسرائیلی باشِندہ تمہارے ساتھ رہتا ہو، تُم اُس سے وَیسا ہی سلُوک کرنا جَیسا تُم اَپنے ہم وطنوں کے ساتھ کرتے ہو۔ اَور جِس طرح تُم خُود سے مَحَبّت رکھتے ہو، اُسی طرح تُم اُس غَیراِسرائیلی باشِندے سے بھی مَحَبّت رکھنا کیونکہ تُم بھی مِصر میں پردیسی ہی تھے۔ مَیں یَاہوِہ تمہارا خُدا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","” ’تُم اِنصاف کرنے، پیمائش کرنے، اَور وزن کرنے میں، ناقص پیمانوں کو اِستعمال میں نہ لانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","اَور تمہارے ترازو، باٹ، کِلو، اَور لیٹر پُورے صحیح ہُوں۔ میں ہی تمہارا یَاہوِہ خُدا ہُوں جو تُمہیں مِصر سے نکال کر لایا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","” ’میرے سَب قوانین اَور سارے آئین کو ماَننا اَور اُن پر عَمل کرنا کیونکہ مَیں یَاہوِہ ہُوں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","پھر یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","”بنی اِسرائیل سے کہو: ’کویٔی اِسرائیلی یا اِسرائیل میں رہنے والا کویٔی پردیسی جو اَپنی اَولاد میں سے کسی کو مولکؔ بُت کے لیٔے قُربانی کرے، تو وہ ضروُر جان سے ماراجائے۔ جماعت کے لوگ اُسے سنگسار کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","اَور مَیں بھی اُس شخص کا مُخالف ہوؤں گا اَور اُسے اُس کے لوگوں میں سے فنا کر دُوں گا کیونکہ اُس نے اَپنے بچّوں کو مولکؔ کے لیٔے قُربانی کرکے میرے پاک مَقدِس کو ناپاک کیا ہے اَور میرے پاک نام کی بےحُرمتی کی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","اَور جِس وقت وہ شخص اَپنی اَولاد میں سے کسی کو مولکؔ کے لیٔے قُربانی کرے اَور جماعت کے لوگ چشم پوشی کرکے اُسے جان سے نہ ماریں، ");
INSERT INTO urdoucv_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","تو میں خُود اُس شخص اَور اُس کے گھرانے کا مُخالف ہو جاؤں گا، اَور اُسے اَور اُن سَب کو قوم میں سے فنا کر دُوں گا جو مولکؔ کی پیروی کرکے زناکاری کرتے ہیں اَور اُس شخص کا ساتھ دیتے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","” ’اَورجو شخص حاضراتیوں اَور اَرواح پرستوں سے بات کرنے والوں کے پاس جایٔے اَور اُن کی طرف رُجُوع کرکے زناکاری کرے، تو میں اُس کا مُخالف ہوؤں گا اَور اُسے اُس کے لوگوں میں سے خارج کر دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","” ’لہٰذا تُم اَپنی تقدیس کرکے پاک ہو جاؤ کیونکہ مَیں یَاہوِہ تمہارا خُدا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","اَور تُم میرے قوانین کو مانو اَور اُن پر عَمل کرو کیونکہ مَیں یَاہوِہ ہُوں جو تُمہیں پاک کرتا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","” ’اَور اگر کویٔی اَپنے باپ یا ماں پر لعنت کرے وہ ضروُر جان سے مار ڈالا جائے۔ کیونکہ اُس نے اَپنے باپ یا ماں پر لعنت کی ہے، چنانچہ اُن کا خُون اُس کی گردن پر ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","” ’اَور اگر کویٔی شخص کسی دُوسرے شخص کی بیوی سے یعنی اَپنے پڑوسی کی بیوی سے زنا کرے تو زانی اَور زانیہ دونوں کو جان سے ضروُر مار دیاجایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","” ’اگر کویٔی شخص اَپنی سَوتیلی ماں سے ہم بِستری کرتا ہے، تو اُس نے اَپنے باپ کی بےحُرمتی کی ہے؛ چنانچہ مَرد اَور عورت دونوں کو جان سے مار دیاجایٔے؛ اُن کا خُون اُن ہی کی گردن پر ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","” ’اَور اگر کویٔی شخص اَپنی بہُو سے ہم بِستر ہوتاہے تو اُن دونوں کو جان سے مار دیا جائے؛ کیونکہ اُنہُوں نے نہایت مکرُوہ کام کیا ہے اَور اُن کا خُون اُن ہی کی گردن پر ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","” ’اگر کویٔی شخص کسی مَرد سے صحبت کرے جَیسا کہ عورت سے کیا جاتا ہے تو اُن دونوں نے نہایت مکرُوہ کام کیا ہے۔ لہٰذا وہ دونوں ضروُر جان سے مار دئیے جایٔیں۔ اُن کا خُون اُن ہی کی گردن پر ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","” ’اَور اگر کویٔی شخص کسی عورت اَور اُس کی ماں دونوں سے شادی کرے تو یہ بڑی بدکاری ہے۔ چنانچہ اُن تینوں کو آگ میں جَلا دیاجایٔے تاکہ تمہارے درمیان بدکاری نہ رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","” ’اَور اگر کویٔی مَرد کسی جانور سے صحبت کرے تو وہ جان سے مار دیا جائے اَور اُس جانور کو بھی زندہ نہ چھوڑا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","” ’اگر کویٔی عورت کسی جانور سے صحبت کرے، تو اُس عورت اَور اُس جانور دونوں کو ضروُر مار ڈالنا۔ لہٰذا وہ دونوں ضروُر جان سے مار دئیے جایٔیں۔ اُن کا خُون اُن ہی کی گردن پر ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","” ’اگر کویٔی شخص اَپنی بہن سے شادی کر لے جو اُس کے باپ کی یا اُس کی سَوتیلی ماں کی بیٹی ہو اَور وہ مباشرت کرے تو یہ شرمناک بات ہے۔ لہٰذا وہ دونوں اَپنے لوگوں کی آنکھوں کے سامنے قتل کیا جائے۔ کیونکہ اُس نے اَپنی بہن کو بےحُرمت کیا۔ اُس کا گُناہ اُسی کے سَر لگے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","” ’اگر کویٔی شخص کسی عورت کے دَورانِ حَیض اُس سے ہم بِستر ہو اَور اُس سے مباشرت کرے تو اُس نے اُس کے خُون کے چشمہ کو کھولا ہے اَور اُس عورت نے بھی اَپنے چشمہ کو کھُلوایا ہے۔ لہٰذا وہ دونوں اَپنے لوگوں میں سے خارج کیٔے جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","” ’تُم اَپنی خالہ یا پھوپھی کے ساتھ ہم بِستری نہ کرنا کیونکہ جو اَیسا کرتا ہے وہ اَپنے ہی قریبی رشتہ دار کی بےحُرمتی کرتا ہے؛ لہٰذا وہ دونوں گُنہگار ہیں اَور اُن کا گُناہ اُن ہی کے سَر پر ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","” ’اَور اگر کویٔی شخص اَپنی چچی یا تائی سے ہم بِستری کرتا ہے، تو اُس نے اَپنے چچا یا تاؤ کی بےحُرمتی کی ہے۔ وہ دونوں اَپنے گُناہ کی سزا پائیں گے اَور وہ بے اَولاد مَریں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","” ’اگر کویٔی شخص اَپنے بھایٔی کی بیوی سے شادی کرے تو یہ ناپاک عَمل ہے۔ کیونکہ اُس نے اَپنے بھایٔی کی توہین کی ہے۔ چنانچہ وہ بے اَولاد رہ جایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","” ’لہٰذا تُم میرے سَب قوانین اَور آئین کو ماَننا اَور اُن پر عَمل کرنا تاکہ وہ مُلک جہاں میں تُمہیں بسانے کو لیٔے جا رہا ہُوں تُمہیں اُگل نہ دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","اَور تُم اُن قوموں کے رسم و رِواج پر عَمل نہ کرنا جنہیں تمہارے سامنے بے دخل کرنے جا رہا ہُوں۔ کیونکہ اُنہیں نے اِسی طرح کے مکرُوہ کام کیٔے ہیں۔ چنانچہ مُجھے اُن سے نفرت ہو گئی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","لیکن مَیں نے تُم سے فرمایا، ”تُم اُن کے مُلک پر قابض ہوگے؛ اَور مَیں تُمہیں وہ مُلک بطور مِیراث دُوں گا، جِس میں دُودھ اَور شہد کثرت سے پایا جاتا ہے۔“ مَیں یَاہوِہ تمہارا خُدا ہُوں، جِس نے تُمہیں دیگر قوموں سے الگ کیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","” ’چنانچہ تُم پاک اَور ناپاک جانوروں میں اَور پاک اَور ناپاک پرندوں میں اِمتیاز کرنا۔ اَور کسی جانور، پرندے یا زمین پر رینگنے والے کسی جاندار سے جنہیں مَیں نے تمہارے لیٔے ناپاک ٹھہرا کر الگ کیا ہے، اُن سے خُود کو نجِس نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","اَور تُم میرے لیٔے پاک بنے رہنا کیونکہ مَیں جو یَاہوِہ ہُوں پاک ہُوں؛ اَور مَیں نے تُمہیں دیگر قوموں سے الگ کیا ہے تاکہ تُم میری خاص قوم بنے رہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","” ’اگر تمہارے درمیان کویٔی عورت یا مَرد جادُوگر یا اَرواح سے بات کرانے والا ہو، تو وہ ضروُر جان سے مار دیا جائے۔ تُم اُنہیں سنگسار کرنا؛ اَور اُن کا خُون اُن ہی کی گردن پر ہوگا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","یَاہوِہ نے مَوشہ سے فرمایا، ”اَہرونؔ کے بیٹوں سے جو کاہِنؔ ہیں، مُخاطِب ہو اَور اُن سے فرما، ’کویٔی کاہِنؔ اَپنے لوگوں میں سے کسی مُردہ کے باعث خُود کو نجِس نہ کرے، ");
INSERT INTO urdoucv_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","سِوائے کسی قریبی رشتہ دار کے مثلاً ماں یا باپ، بیٹا یا بیٹی، بھایٔی، ");
INSERT INTO urdoucv_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","یا اُس کی کنواری بہن جِس کا شوہر نہ ہو جو دیکھ بھال کے لیٔے اُس کی ذمّہ داری میں ہو، اُن کی خاطِر وہ اَپنے آپ کو نجِس کر سَکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","لیکن گھر کا مالک ہونے کے باعث وہ شادی کے ذریعہ رشتہ میں آئے لوگوں کے لئے خُود کو اَیسا آلُودہ نہ کرے کہ ناپاک ہو جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","” ’کاہِنؔ نہ تو اَپنا سَر گنجا کرے نہ ہی اَپنی داڑھی کے بال کو مُنڈوائے اَور نہ ہی اَپنے بَدن میں چیرا لگائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","وہ اَپنے خُدا کے لیٔے پاک رہیں اَور کبھی اَپنے خُدا کے نام کی بےحُرمتی نہ کریں کیونکہ وہ یَاہوِہ کی آتِشی قُربانیاں پیش کرتے ہیں جو اُن کے خُدا کی غِذا کی قُربانی ہے۔ لہٰذا اُن کا پاک رہنا لازمی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","” ’کاہِنؔ جِسم فروشی کرنے والی نجِس عورت یا طلاق شُدہ عورت سے ہرگز شادی نہ کرے کیونکہ کاہِنؔ اَپنے خُدا کے لیٔے مُقدّس ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","لہٰذا تُم اُنہیں مُقدّس سمجھو، کیونکہ وہ تمہارے خُدا کے حُضُور میں غِذا کی قُربانی پیش کرتے ہیں۔ اُنہیں مُقدّس سمجھو کیونکہ مَیں یَاہوِہ جو تُمہیں پاک کرتا ہُوں پاک ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","” ’اگر کسی کاہِنؔ کی بیٹی فاحِشہ بَن کر اَپنے آپ کو ناپاک کرے، تو وہ اَپنے باپ کی بےحُرمتی کا باعث بنتی ہے۔ لازِم ہے کہ اُسے آگ میں جَلا دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","” ’وہ کاہِنؔ جو اَپنے بھائیوں کے درمیان اعلیٰ کاہِن ہو جِس کے سَر پر مَسح کرنے کا تیل ڈالا گیا ہو اَورجو پاک لباس پہننے کے لیٔے مخصُوص کیا گیا ہو وہ نہ تو اَپنے سَر اُوگھاڑے اَور نہ ہی اَپنے کپڑے پھاڑے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","اَور نہ ہی وہ کسی اَیسے مقام پر جائے جہاں لاش پائی جایٔے، اَور نہ ہی وہ اَپنے باپ یا ماں کی خاطِر خُود کو ناپاک کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","اَور نہ ہی وہ اُس کے خُدا کے پاک مَقدِس سے باہر جائے اَور نہ ہی اُس کی بےحُرمتی کرے کیونکہ خُدا کا مَسح کا تیل اُس پر ہے۔ میں ہی یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","” ’وہ جِس عورت سے شادی کرے وہ ضروُر کنواری ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","وہ کسی بِیوہ، طلاق شُدہ یا کسی فاحِشہ عورت سے ہرگز شادی نہ کرے بَلکہ اَپنی ہی قوم میں سے کسی کنواری سے شادی کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","اِس طرح اُس کی اَولاد اَپنی قوم میں بےحُرمت نہ ٹھہرے گی کیونکہ مَیں یَاہوِہ ہُوں جو اُسے مُقدّس کرتا ہُوں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","پھر یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","”اَہرونؔ کو حُکم دو، ’تمہارے فرزندوں میں سے اُن کی پُشت در پُشت میں کویٔی بھی شخص جِس میں عیب ہو تو وہ اَپنے خُدا کے حُضُور غِذا کی قُربانی پیش کرنے نہ آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","کویٔی بھی شخص جِس میں کویٔی عیب ہو، وہ خُدا کے حُضُوری میں نہ آئے خواہ وہ اَندھا، لنگڑا، بدصورت یا جِسمانی طور پر معذور ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","اَور نہ ہی وہ شخص جو پیر یا ہاتھ سے اَپاہج ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","یا جو کُبڑا، بَونا ہو، یا جِس کی آنکھ میں کویٔی نُقص ہو، یا جو کھُجلی سے پریشان ہو، جِس کی جلد پر دانے ہُوں، یا جِس کے خُصیے کُچلے ہویٔے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","اَور اَہرونؔ کاہِنؔ کی نَسل میں سے کویٔی بھی شخص جِس میں کویٔی عیب ہو، وہ یَاہوِہ کو آتِشی قُربانیاں گذراننے کو اُن کے حُضُور نہ آئے۔ کیونکہ اُس میں عیب ہے۔ وہ ہرگز اَپنے خُدا کو غِذا کی قُربانی پیش کرنے کی کوشش نہ کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","وہ اَپنے خُدا کی نہایت ہی مُقدّس غِذا کو اَور پاک روٹی کو بھی کھا سَکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","تاہم اَپنے عیب کی وجہ سے وہ پردہ کے اَندر یا مذبح کے پاس ہرگز نہ جائے۔ اَیسا نہ ہو کہ وہ میرے پاک مَقدِس کی بےحُرمتی کرے۔ کیونکہ مَیں یَاہوِہ ہُوں، جو اُن کو پاک کرتا ہُوں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","لہٰذا مَوشہ نے اَہرونؔ اَور اُن کے بیٹوں کو اَور تمام بنی اِسرائیل کو یہ سَب باتیں بتائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","”اَہرونؔ اَور اُس کے بیٹوں سے مُخاطِب ہو اَور اُنہیں حُکم دو کہ وہ اُن مُقدّس قُربانیوں کا جو بنی اِسرائیل میرے لیٔے مخصُوص کرتے ہیں اُن کا اِحترام کیا کریں، تاکہ وہ میرے پاک نام کی بےحُرمتی نہ کرنے پائیں کیونکہ مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","”اَور اُن سے فرما، ’تمہاری ساری پُشت در پُشت میں جو کویٔی ناپاکی کی حالت میں اُن مُقدّس قُربانیوں کے قریب آئے، جنہیں بنی اِسرائیل مُجھے نذر کرنے کو میرے حُضُور لائیں گے، تو یہ لازِم ہوگا کہ وہ شخص میرے حُضُور سے ہمیشہ کے لیٔے خارج کر دیاجایٔے۔ کیونکہ مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","” ’اگر اَہرونؔ کی نَسل میں سے کسی کو جِلدی کوڑھ کی بیماری ہو یا اُسے کسی جریان کا مرض ہو، تو وہ تَب تک مُقدّس قُربانیوں کو نہ کھائے جَب تک وہ پاک نہ ہو جائے۔ اَور اگر وہ کسی لاش کو چھُوئے یا نطفہ خارج ہونے کا مریض ہو، تَب بھی وہ ناپاک ہوگا، ");
INSERT INTO urdoucv_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","یا اگر وہ کسی رینگنے والے ناپاک جاندار کو چھُونے کی وجہ سے ناپاک ہو جایٔے، یا کسی اَیسے شخص کو چھُوئے جِس کے چھُونے سے وہ ناپاک ہو سَکتا ہو، خواہ اُس کی ناپاکی کسی بھی قِسم کی ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","جو کویٔی کسی اَیسی چیز کو چھُوئے تو وہ شام تک ناپاک رہے گا۔ اَور وہ مُقدّس قُربانیوں میں سے کسی چیز کو تَب تک نہ کھائے جَب تک وہ پانی سے غُسل نہ کر لے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","اَور جَب آفتاب غروب ہو جائے گا تَب وہ پاک ٹھہرے گا۔ اِس کے بعد پھر وہ اُن مُقدّس قُربانیوں کو کھا سَکتا ہے کیونکہ یہ اُس کی خُوراک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","اَور وہ کسی مُردار جانور یا جنگلی جانوروں کے پھاڑے ہویٔے جانور کو ہرگز نہ کھائے تاکہ اُن کے باعث وہ ناپاک ہو جائے کیونکہ مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","” ’کاہِنؔ میرے قوانین کو مانیں تاکہ وہ مُجرم نہ ٹھہریں اَور اُن کی بےحُرمتی کرنے کے باعث فنا نہ ہو جایٔیں۔ مَیں یَاہوِہ ہُوں جو اُنہیں مُقدّس کرتا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","” ’اَور کاہِنؔ کے خاندان سے باہر کا کویٔی بھی شخص اُس مُقدّس قُربانی کو نہ کھائے اَور نہ ہی کاہِنؔ کا مہمان یا اُس کا کویٔی مزدُور اُسے کھائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","لیکن اگر کویٔی کاہِنؔ قیمت دے کر کسی غُلام کو خریدے یا کویٔی غُلام اُس کے گھر میں پیدا ہُوا ہو، تو وہ اُس کے کھانے میں سے کھا سَکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","اگر کسی کاہِنؔ کی بیٹی کسی کاہِنؔ کے علاوہ کسی اَور سے شادی کر لے تو وہ مُقدّس قُربانیوں کی نذروں میں سے کسی کو نہ کھائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","لیکن اگر کسی کاہِنؔ کی بیٹی بِیوہ ہو جائے یا اُس کی طلاق ہو جایٔے اَور وہ جَوانی میں ہی بے اَولاد کی حالت میں اَپنے باپ کے گھر واپس آکر رہنے لگے، تو وہ اَپنے باپ کے کھانے میں سے کھا سکتی ہے۔ لیکن کویٔی شخص جو کاہِنؔ کے خاندان سے نہ ہو اُسے نہ کھائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","” ’اَور اگر کویٔی شخص نادانستہ کسی مُقدّس قُربانی میں سے کھائے تو وہ اُس کی قیمت کے پانچویں حِصّہ کے ساتھ اُس مُقدّس قُربانی کا مُعاوضہ کاہِنؔ کو لَوٹا دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","اَور کاہِنؔ اُن پاک قُربانیوں کو جو بنی اِسرائیل یَاہوِہ کے حُضُور پیش کرتے ہیں اُن کی بےحُرمتی نہ کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","اَور اِس طرح اُن کی مُقدّس قُربانیوں کو کھانے کے خطا کے باعث مُجرم نہ ٹھہرے۔ کیونکہ مَیں یَاہوِہ ہُوں جو اُن کو مُقدّس کرنے والا ہُوں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","”اَہرونؔ اَور اُس کے بیٹوں اَور تمام بنی اِسرائیل سے مُخاطِب ہو اَور اُنہیں حُکم دو، ’اگر تُم میں سے کویٔی خواہ وہ اِسرائیلی ہو یا کویٔی پردیسی جو اِسرائیل کا باشِندہ ہو، جَب وہ اَپنی قُربانی لایٔے، خواہ وہ مَنّت کی قُربانی ہو، یا رضا کی قُربانی ہو، تو وہ بطور سوختنی نذر یَاہوِہ کے لیٔے پیش کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","تو تُم بَیلوں یا برّوں یا بکریوں میں سے بے عیب نر بکرا نذر کرنا تاکہ وہ تمہاری طرف سے مقبُول ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","اَور اُس جانور کی قُربانی نہ دی جایٔے جِس میں کویٔی عیب ہو، کیونکہ وہ تمہاری طرف سے مقبُول نہ ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","جَب کویٔی شخص اَپنی کسی خاص مَنّت کی تکمیل کے لیٔے رضا کی قُربانی کے طور پر بَیلوں یا بھیڑ بکریوں میں سے سلامتی کی نذر یَاہوِہ کے حُضُور پیش کرے، تو قُربانی قبُول ہونے کے لیٔے ضروُری ہے کہ وہ جانور بے عیب ہو اَور اُس میں کویٔی نقش نہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","اَیسے جانوروں کو جو اَندھا یا اَعضا ٹوٹے ہویٔے، لُولا یا جِن کے رسَولی ہو یا جنہیں ناسور کی بیماری ہو، یَاہوِہ کے حُضُور میں ہرگز نہ لانا اَور مذبح پر اُن کی آتِشی قُربانی کے طور پر یَاہوِہ کے لئے نہ گذراننا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","تاہم تُم کسی بڑے یا چُھوٹے اَعضا والے بچھڑے یا برّے کو رضا کی قُربانی کے طور پر پیش کر سکتے ہو مگر کسی مَنّت کی تکمیل کی قُربانی کے لیٔے قبُول نہ ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","تُم کسی اَیسے جانور کو جِس کے خُصیے زخمی، کٹے پھٹے یا کُچلے ہویٔے ہُوں، یَاہوِہ کے لیٔے قُربان نہ کرنا، اَور نہ ہی اَپنے مُلک میں اُن کی قُربانی پیش کرنا، ");
INSERT INTO urdoucv_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","اَور نہ تُم اَیسے جانوروں کو کسی پردیسی کے ہاتھ سے اَپنے خُدا کے لئے غِذا کی قُربانی کے طور پر قبُول کرنا؛ وہ آپ کی طرف سے قبُول نہیں کئے جائیں گے، کیونکہ اُن میں خرابی اَور عیب ہے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","”جَب کویٔی بچھڑا یا بھیڑ یا بکری کا بچّہ پیدا ہو، تو وہ سات دِن تک اَپنی ماں کے ساتھ رہے۔ اَور آٹھویں دِن کے بعد سے، وہ یَاہوِہ کے لیٔے بطور آتِشی قُربانی پیش کیٔے جانے سے مقبُول ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","لیکن چاہے گائے ہو یا بھیڑ، تُم ماں اَور اُس کے بچّے دونوں کو ایک ہی دِن میں ذبح نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","”اَور جَب تُم یَاہوِہ کے حُضُور شُکر گزاری کی قُربانی پیش کرو، تو اُسے اِس طریقہ سے پیش کرو کہ وہ تمہاری طرف سے قبُول کی جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","اِس قُربانی کو اُسی دِن ضروُر کھا لینا اَور اگلے دِن تک اُس میں سے کچھ بھی باقی نہ چھوڑنا۔ مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","”چنانچہ تُم میرے اَحکام کو ماَننا اَور اُن پر عَمل کرنا۔ مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","اَور تُم میرے پاک نام کی بےحُرمتی نہ کرنا، اَور لازِم ہے کہ مُجھے بنی اِسرائیل کے درمیان قُدُّوس مانا جایٔے۔ مَیں یَاہوِہ ہُوں جو تُمہیں مُقدّس کرتا ہُوں، ");
INSERT INTO urdoucv_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","اَورجو تُمہیں مِصر سے نکال لایا ہُوں تاکہ تمہارا خُدا بَن جاؤں۔ مَیں یَاہوِہ ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","”بنی اِسرائیل سے مُخاطِب ہو اَور اُنہیں حُکم دو، ’یہ یَاہوِہ کی مُقرّرہ عیدیں ہیں، جنہیں تُم مُقدّس اِجتماعات کے طور پر اعلان کرنا؛ میری مُقرّرہ عیدیں یہ ہیں: ");
INSERT INTO urdoucv_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","” ’چھ دِن ہیں جِن میں تُم کام کاج کر سکتے ہو لیکن ساتواں دِن مُکمّل آرام کا سَبت اَور مُقدّس اِجتماع کا دِن ہے۔ لہٰذا جہاں کہیں بھی تمہاری رہائش ہو تُم اُس دِن کویٔی بھی کام نہ کرنا کیونکہ یہ یَاہوِہ کے لیٔے ایک سَبت ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","” ’یَاہوِہ کی مُقرّرہ عیدیں جِن کا اعلان تُمہیں مُقدّس اِجتماعات کے لیٔے مُقرّرہ وقت پر کرنا ہوگا، یہ ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","یَاہوِہ کا عیدِفسح پہلے مہینے کی چودھویں تاریخ کو شام کے وقت شروع ہوتاہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","اَور اُسی مہینے کے پندرھویں دِن کو یَاہوِہ کی بے خمیری روٹی کی عید شروع ہوتی ہے؛ سات دِن تک تُم بے خمیری روٹی کھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","پہلے دِن مُقدّس اِجتماع ہوگا اَور اِس دِن تُم عام دِنوں کی طرح کویٔی کام بالکُل نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","اَور ساتویں دِن تک تُم یَاہوِہ کو آتِشی قُربانیاں پیش کرنا۔ اَور پھر ساتویں دِن پھر تمہارا مُقدّس اِجتماع ہو اَور حسبِ معمول کویٔی کام نہ کرنا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","”بنی اِسرائیل سے مُخاطِب ہو اَور اُنہیں حُکم دو، ’جَب تُم اُس مُلک میں داخل ہو جاؤ، جسے میں تُمہیں دینے والا ہُوں اَور وہاں تُم اَپنی پہلی فصل کاٹو، تو تُم اَپنی پہلی فصل کے پُولوں کو کاہِنؔ کے پاس لانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","اَور کاہِنؔ اِن پُولوں کو یَاہوِہ کے حُضُور بطور لہرانے کی قُربانی گزرانے، تَب وہ تمہاری طرف سے یَاہوِہ کی نظر میں مقبُول ٹھہرے گی؛ اَور کاہِنؔ اُسے سَبت کے بعد اگلے دِن لہرائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","اَور جِس دِن تُم اُن پُولوں کو لہرانے کی قُربانی کے طور پر پیش کرو، اُسی دِن تُم ایک یک سالہ بے عیب برّہ بطور سوختنی نذر ضروُر یَاہوِہ کے لئے پیش کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","اَور اُس کے ساتھ گلّے کی قُربانی میں تیل اَور ایک ایفہ مَیدہ مِلا کر یَاہوِہ کے حُضُور فرحت بخش خُوشبو کے طور پر آتِشی قُربانی پیش کی جایٔے۔ اَور اِس کے علاوہ اُس کے ساتھ انگوری شِیرے کی نذر کے لیٔے ایک پاؤ ہین انگوری شِیرہ بھی نذر کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","اَور جَب تک تُم اَپنے خُدا کے لیٔے یہ قُربانی نہ لے آؤ، اُس دِن تک تُم نئی فصل کی روٹی، بھُنا ہُوا دانہ یا ہری بالیں ہرگز نہ کھانا۔ یہ تمہاری سَب سکونت گاہوں میں تمہارے سارے خاندان میں تمہاری ساری پُشتوں کے لیٔے ایک دائمی فرمان ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","” ’اَور تُم سَبت کے اگلے دِن سے، جَب ہلانے کی نذر کی قُربانی کے واسطے پُولے لاؤگے، تَب سے گننا شروع کرنا جَب تک پُورے سات ہفتے پُورے نہ ہو جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","اَور ساتویں سَبت کے اگلے دِن سے پچاس دِنوں کی گِنتی کرنا؛ پھر تُم یَاہوِہ کے حُضُور نئے اناج کی نذر کی قُربانی پیش کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","اَور جہاں کہیں تمہاری رہائش ہو وہاں سے تُم ہلانے کی نذر کی قُربانی کے واسطے دو دہائی ایفہ مَیدہ کی خمیری روٹیاں لانا؛ جو یَاہوِہ کو پہلے پھلوں کی ہلانے کی نذر کی قُربانی کے طور پر پیش کی جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","اَور روٹیوں کے ساتھ سات یک سالہ بے عیب نر برّہ، اَور ایک بچھڑا اَور دو مینڈھے بھی لانا تاکہ یہ سَب اناج کی نذریں اَور تپاون کی نذروں کے ساتھ یَاہوِہ کے حُضُور سوختنی نذر جو غِذا کی فرحت بخش خُوشبو والی آتِشی قُربانی ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","اَور پھر ایک بکرا گُناہ کی قُربانی کے لیٔے اَور دو یک سالہ برّے سلامتی کی نذر کے لیٔے ذبح کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","اَور کاہِنؔ دونوں برّے اَور پہلے پھل کے دونوں روٹیاں لے اَور اُنہیں ہلانے کی نذر کی قُربانی کے طور پر یَاہوِہ کے حُضُور ہلائے۔ یہ یَاہوِہ کے لیٔے مُقدّس قُربانیاں اَور کاہِنؔ کا مُقرّر حِصّہ ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","اُسی دِن تُم مُقدّس اِجتماع کا اعلان کرنا اَور اُس دِن روزمرّہ کا کویٔی کام نہ کرنا۔ یہ تمہاری ساری پُشتوں میں تمہارے لیٔے ایک دائمی فرمان ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","” ’اَور جَب تُم اَپنی زمین کی فصل کاٹو، تو اَپنے کھیت کو کونے کونے تک پُورا نہ کاٹنا اَور نہ ہی اَپنے کھیت کی گری پڑی بالیں جمع کرنا بَلکہ اُنہیں غریبوں اَور تمہارے درمیان رہنے والے پردیسیوں کے لیٔے چھوڑ دینا۔ مَیں یَاہوِہ تمہارا خُدا ہُوں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","”بنی اِسرائیل کو حُکم دو، ’ساتویں مہینے کی پہلی تاریخ کو تمہارا یَومِ آرام ہوگا۔ اِس مُقدّس موقع پر اِجتماع کیا جائے اَور یادگاری کے لیٔے زور زور سے نرسنگے پھُونکے جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","اُس دِن روزمرّہ کا کویٔی کام نہ کرنا، بَلکہ یَاہوِہ کے حُضُور آتِشی قُربانی پیش کرنا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","”اُسی ساتویں مہینے کے دسویں دِن کو یَومِ کفّارہ ہے۔ اُس روز تمہارا مُقدّس اِجتماع ہو۔ تُم روزہ رکھنا اَور یَاہوِہ کے حُضُور آتِشی قُربانی پیش کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","اُس دِن کویٔی کام نہ کرنا کیونکہ یہ یَومِ کفّارہ ہے، جِس دِن یَاہوِہ تمہارے خُدا کے حُضُور کفّارہ دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","جو کویٔی شخص اُس دِن روزہ نہیں رکھتا ہے، تو اُس شخص کو اُس کو اَپنے لوگوں میں سے خارج کر دیاجایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","اَورجو کویٔی اُس دِن کویٔی کام کرےگا اُسے، میں اُس کے لوگوں میں سے فنا کر دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","لہٰذا تُم اُس دِن کویٔی کام مت کرنا۔ یہ تمہاری ساری پُشتوں کے لیٔے ایک دائمی فرمان ہے جہاں بھی تُم رہوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","یہ تمہارے لیٔے مُکمّل آرام کا سَبت ہے، اَور اِس دِن تُم ضروُر روزہ رکھنا؛ یہ سَبت مہینے کی نویں تاریخ کو شام سے لے کر اگلے دِن کی شام تک مانا جائے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","”بنی اِسرائیل کو یہ حُکم دو، ’ساتویں مہینے کے پندرھویں دِن سے لے کر اگلے سات دِن تک یَاہوِہ کے خیموں کی عید شروع ہوتی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","پہلا دِن مُقدّس اِجتماع کا دِن ہے۔ تُم اُس دِن روزمرّہ کا کویٔی کام نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","اَور سات دِن تک یَاہوِہ کے حُضُور آتِشی قُربانیاں پیش کرنا اَور آٹھویں دِن مُقدّس اِجتماع کرنا اَور یَاہوِہ کے حُضُور آتِشی قُربانی پیش کرنا۔ وہ اِس عید کا آخِری اِجتماع ہوگا۔ لہٰذا اُس دِن روزمرّہ کا کویٔی کام نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","” ’یہ یَاہوِہ کی مُقرّرہ عیدیں ہیں جنہیں منانے کے لیٔے مُقدّس اِجتماعات منعقّد کئے جایٔیں تاکہ تُم یَاہوِہ کے حُضُور مُقرّرہ دِنوں پر سوختنی نذریں اَور اناج کی نذریں، قُربانیاں اَور تپاون کی نذر پیش کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","یہ قُربانیاں اُن قُربانیوں کے علاوہ ہیں جنہیں تُم یَاہوِہ کے سَبتوں کے لیٔے ہدیوں، مَنّتوں اَور رضا کی قُربانیوں کے طور پر یَاہوِہ کے حُضُور میں پیش کرتے ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","” ’لہٰذا زمین کی فصلوں کو جمع کرنے کے بعد ساتویں مہینے کی پندرھویں تاریخ سے شروع کرکے تُم اِس عید کو یَاہوِہ کے لیٔے سات دِن تک منانا۔ پہلا دِن اَور آٹھواں دِن دونوں مُکمّل سَبت کا آرام کا دِن ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","اَور پہلے دِن تُم درختوں کے چنندہ پھل کھجور کی ڈالیاں، گھنے درختوں کی شاخیں اَور دریاؤں کے کنارے کے بید مجنوں لینا اَور تُم سات دِن تک یَاہوِہ اَپنے خُدا کے حُضُور خُوشی منانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","اَور تُم ہر سال یہ عید یَاہوِہ کے لیٔے سات دِن تک منایا کرنا۔ تُم یہ عید ساتویں مہینے میں منانا۔ اَور یہ تمہاری آنے والی ساری پُشتوں کے لیٔے ایک دائمی فرمان ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","اَور سات دِن تک تُم جھونپڑیوں میں رہنا۔ تمام مقامی باشِندہ کے طور پر پیدا ہونے والے اِسرائیلی جھوپڑوں میں رہیں گے ");
INSERT INTO urdoucv_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","تاکہ تمہاری آنے والی نَسلوں کو مَعلُوم ہو کہ جَب مَیں بنی اِسرائیل کو مِصر سے نکال کر لایا، تو مَیں نے اُنہیں سائبانوں میں رکھّا تھا۔ میں ہی یَاہوِہ تمہارا خُدا ہُوں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","پس مَوشہ نے بنی اِسرائیل میں یَاہوِہ کی مُقرّرہ عیدوں کا بَیان کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","اَور یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","”تُم بنی اِسرائیل کو حُکم دینا کہ وہ تمہارے پاس کولہو کے ذریعہ نکالا ہُوا زَیتُون کا خالص تیل رَوشنی کے لیٔے لائیں تاکہ چراغ ہمیشہ جلتے رہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","اَور اَہرونؔ خیمہ اِجتماع میں عہد کے صندُوق کے پردہ کے باہر شام سے صُبح تک یَاہوِہ کے سامنے بلاناغہ اُن چراغوں کی دیکھ بھال کیا کرے۔ یہ تمہارے لیٔے اَور تمہاری ساری پُشتوں کے لیٔے ایک دائمی فرمان ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","اَور اُن چراغوں کو صَاف کرکے ہمیشہ یَاہوِہ کے حُضُور خالص سونے کے چراغدان پر ترتیب سے رکھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","”اَور تُم مَیدہ لے کر بَارہ روٹیاں پکانا، ہر ایک روٹی دو دہائی ایفہ مَیدہ سے بنائی جایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","اَور تُم اُنہیں یَاہوِہ کے حُضُور خالص سونے کی میز پر دو قطاروں میں رکھ دینا، ہر قطار میں چھ چھ روٹیاں ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","اَور ہر قطار کے ساتھ خالص لوبان رکھنا تاکہ یہ روٹیاں یَاہوِہ کے لیٔے یادگاری حِصّہ کے طور پر پیش کی گئی آتِشی قُربانی ہو جایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","اَور بنی اِسرائیل کی طرف سے یہ روٹیاں باقاعدہ ہر سَبت کو یَاہوِہ کے حُضُور ایک دائمی عہد کے طور پر رکھی جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","اَور یہ روٹیاں اَہرونؔ اَور اُن کے بیٹوں کے لیٔے ہوں گے اَور وہ اُنہیں پاک مَقدِس کی جگہ میں ہی کھایٔیں کیونکہ اناج کی قُربانی دائمی حِصّہ کے طور پر فرمان کے مُطابق یَاہوِہ کو گذرانی جانے والی آتِشی قُربانیوں میں سے یہ اُن کا پاک ترین حِصّہ ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","اَور یُوں ہُوا کہ ایک دِن ایک اِسرائیلی عورت کا بیٹا جِس کا باپ مِصری تھا، بنی اِسرائیل کے درمیان چلا گیا اَور چھاؤنی کے اَندر ہی اُس کی ایک اِسرائیلی شخص کے ساتھ آپَس میں مارپیٹ ہو گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","اُس اِسرائیلی عورت کے بیٹے نے خُدا کی توہین کی اَور اُس پر لعنت بھیجی؛ لہٰذا وہ اُسے مَوشہ کے پاس لایٔے۔ اُس کی والدہ کا نام شلُومیتؔ تھا جو دانؔ کے قبیلہ کے دِبریؔ کی بیٹی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","اَور اُنہُوں نے یَاہوِہ کی مرضی صَاف صَاف ظاہر ہونے تک اُسے اَپنی حِراست میں رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","تَب یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","”کُفر بکنے والے کو چھاؤنی سے باہر لے جاؤ، اَور وہ تمام لوگ جنہوں نے اُسے کُفر بکتے ہویٔے سُنا ہے، وہ سَب اُس کے سَر پر اَپنے ہاتھ رکھّیں؛ اِس کے بعد ساری جماعت اُسے سنگسار کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","اَور تُم بنی اِسرائیل کو حُکم دو، ’اگر کویٔی شخص اَپنے خُدا پر لعنت بھیجے، تو اُس کا گُناہ اُسی کے سَر پر ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","اَورجو کویٔی یَاہوِہ کے نام پر کُفر بکے وہ ضروُر جان سے ماراجائے۔ اَور پُوری جماعت اُسے ضروُر سنگسار کرے، خواہ کویٔی مُلک اِسرائیل کا باشِندہ ہو یا غَیراِسرائیلی؛ چنانچہ جَب کویٔی یَاہوِہ کے نام کی توہین کرے تو وہ ضروُر جان سے ماراجائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","” ’اَور اگر کویٔی شخص کسی اِنسان کو مار ڈالے تو وہ ضروُر جان سے ماراجائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","اَور اگر کویٔی شخص کسی چَوپائے کو مار ڈالے تو لازِم ہے کہ وہ اُس کا مُعاوضہ دے یعنی جان کے بدلے جان۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","اَور اگر کویٔی شخص اَپنے ہمسایہ کو زخمی کر دے تو جَیسا اُس نے کیا ہے ٹھیک وَیسا ہی اُس کے ساتھ کیا جائے: ");
INSERT INTO urdoucv_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","یعنی ہڈّی توڑنے کے بدلے ہڈّی توڑنا۔ آنکھ کے بدلے آنکھ، اَور دانت کے بدلے دانت۔ اَور جَیسے اُس شخص نے دُوسرے کو زخمی کیا ہے وَیسے ہی اُسے بھی زخمی کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","اِسی طرح جِس نے کسی جانور کو مار ڈالا ہو، وہ اُس کا مُعاوضہ دے لیکن جو کویٔی کسی شخص کو مار ڈالے وہ ضروُر جان سے مار ڈالا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","اَور تمہارے درمیان مُلک اِسرائیل کا باشِندہ ہو یا غَیراِسرائیلی دونوں کے لیٔے ایک ہی قانُون ہو۔ کیونکہ مَیں یَاہوِہ تمہارا خُدا ہُوں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","پھر مَوشہ نے بنی اِسرائیل سے بات کی اَور اُنہُوں نے اُس کُفر بکنے والے کو چھاؤنی سے باہر لے جا کر سنگسار کر دیا۔ اَور بنی اِسرائیل نے وَیسا ہی کیا جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","اَور یَاہوِہ نے کوہِ سِینؔائی پر مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","”بنی اِسرائیل کو یہ حُکم دو: ’جَب تُم اُس مُلک میں داخل ہو، جو میں تُمہیں دینے والا ہُوں، تو وہاں کی زمین بھی یَاہوِہ کے لیٔے سَبت منائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","تُم چھ سال تک اَپنے کھیتوں میں بیج بونا اَور چھ سال تک اَپنے انگوری باغ کو چھانٹنا اَور اُن کے پھل جمع کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","لیکن ساتویں سال زمین کے لیٔے آرام کا سَبت ہو؛ یعنی یَاہوِہ کے لیٔے سَبت۔ لہٰذا ساتویں سال تُم نہ تو اَپنے کھیتوں میں بیج بونا اَور نہ اَپنے انگوری باغ کو چھانٹنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","اَور نہ اَپنی خُودرَو فصل کو کاٹنا اَور نہ بے چھٹی تاکوں کے انگوروں کو توڑنا؛ چنانچہ یہ زمین کے لیٔے ایک خاص آرام کا سال ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","اَور سَبت سال کے دَوران جو کچھ زمین سے پیدا ہوگا، وہ تُم سَب کے لیٔے خُوراک ہوگی، یعنی تمہارے لیٔے، تمہارے خادِموں اَور خادِماؤں کے لیٔے، اَور مزدُوروں اَور تمہارے درمیان رہنے والے پردیسی باشِندوں کے لیٔے، ");
INSERT INTO urdoucv_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","تمہارے مویشیوں اَور تمہارے مُلک کے جنگلی جانوروں کے لیٔے بھی ہوگا۔ اَورجو کچھ زمین میں پیدا ہو اُسے سَب کھا سکتے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","” ’تُم سات سَبت سالوں کی بھی گِنتی کرنا؛ یعنی سات گُنا سات سال گِن لینا، یُوں تمہارے حِساب سے برسوں کے سات سَبتوں کی کُل مُدّت اُنچاس سال ہوں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","تَب تُم ساتویں مہینے کی دسویں تاریخ کو ہر جگہ نرسنگا پھنکوانا۔ تُم کفّارہ کے دِن اَپنے سارے مُلک میں نرسنگا پھنکوانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","تُم پچاسویں بَرس کو مُقدّس جاننا اَور مُلک بھر میں سَب باشِندوں کے لیٔے آزادی کا اعلان کرنا۔ یہ سال تمہارے لیٔے یوویلؔ سال کہلائے گا اَور اِس سال میں تُم میں سے ہر ایک اَپنی اَپنی خاندانی مِلکیّت کا پھر سے مالک ہو جایٔےگا اَور ہر شخص اَپنی اَپنی برادری والوں میں پھر سے شامل ہو جایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","پچاسواں بَرس تمہارے لیٔے یوویلؔ کا سال ہو؛ اِس سال تُم نہ تو کچھ بیج بونا، اَور نہ اَپنے آپ پیدا ہوئی فصل کاٹنا اَور نہ بِنا چھٹی تاکوں کے انگور جمع کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","کیونکہ یہ یوویلؔ کا سال ہے۔ یہ تمہارے لیٔے مُقدّس ٹھہرایا گیا ہے۔ تُم صِرف کھیتوں کی خُودرَو پیداوار پر گُزارا کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","” ’اِس یوویلؔ کے سال میں ہر ایک اَپنی اَپنی خاندانی مِلکیّت کو پھر سے لَوٹ جایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","” ’اگر تُم اَپنے پڑوسی کو زمین بیچو یا اُس سے خریدو تو، تُم ایک دُوسرے سے دھوکے سے کام نہ لینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","اَور جَب تُم اَپنے پڑوسی سے زمین خریدو، تو اُس کی قیمت پچھلے یوویلؔ کے بعد کے سالوں کے شُمار کے مُطابق ہونا ضروُری ہے، اَور بیچنے والا بھی اِس کی قیمت اگلے یوویلؔ کے بچے ہویٔے فصلوں کے برسوں کے شُمار کے مُطابق بیچے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","اَور جَب سالوں کی تعداد زِیادہ ہو تو دام بڑھا دینا اَور جَب کم ہو تو قیمت کو گھٹا دینا کیونکہ جو وہ تُم کو بیچ رہاہے وہ اُن سالوں کی فصلوں کی تعداد ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","لہٰذا تُم ایک دُوسرے کو دھوکا مت دینا بَلکہ اَپنے خُدا سے ڈرنا۔ مَیں یَاہوِہ تمہارا خُدا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","” ’پس تُم میرے قوانین پر عَمل کرنا اَور میرے فرمان کو پُوری طرح ماَننا تو تُم اُس مُلک میں سلامتی کے ساتھ بسے رہوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","تَب زمین اَپنی پیداوار دے گی اَور تُم پیٹ بھر کر کھاؤگے اَور وہاں سلامتی کے ساتھ بسے رہوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","اَور اگر تمہارے ذہن میں یہ سوال اُٹھے، ”جَب ہم نہ تو بوئیں گے اَور نہ ہی اَپنی فصلیں کاٹیں گے تو پھر ہم ساتویں بَرس کیا کھایٔیں گے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","تَب میں چھٹے بَرس میں تُمہیں اِس قدر برکت دُوں گا کہ آنے والے اگلے تین سال تک تمہارے کھانے واسطے زمین کافی پیداوار دے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","اَور آٹھویں سال کے دَوران بیج بوتے وقت تُم وُہی اناج اِستعمال کروگے بَلکہ نویں سال کی فصل جمع کرکے گھر لانے تک بھی اُسی میں سے کھاتے رہوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","” ’اَور زمین ہمیشہ کے لیٔے بیچی نہ جائے کیونکہ زمین میری ہے اَور تُم میری زمین میں محض پردیسی اَور مُسافر ہو جو اُس کی دیکھ بھال کے لیٔے مُقرّر کئے گیٔے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","اَور جَب بھی تُم زمین کو کسی شخص سے خریدو، تو بعد میں اگر بیچنے والا اَپنی زمین پھر سے خریدنا چاہے تو اُسے اَپنی زمین کو چھُڑانے کا اِختیار ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","” ’اَور اگر تمہارا کویٔی ہم وطن اِسرائیلی غربت کی وجہ سے اَپنی مِلکیّت کا کچھ حِصّہ بیچ دے تو اُس کا نزدیکی رشتہ دار آکر اُس ہم وطن کا بیچا ہُوا حِصّہ چھُڑا لے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","تاہم اگر اُس کا بیچا ہُوا حِصّہ چھُڑانے والا کویٔی نہ ہو اَور وہ خُود اِس قدر خُوشحال ہو جائے کہ اُس حِصّہ کو چھُڑانے کے لیٔے اُس کے پاس کافی وسائل ہُوں، ");
INSERT INTO urdoucv_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","تو وہ اُس حِصّہ کے بیچے جانے کے وقت سے اُس کی قیمت کا تعیُّن کرکے بقایا رقم خریدنے والے کو لَوٹا دے اَور یُوں وہ پھر سے اَپنی مِلکیّت کا مالک ہو سَکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","لیکن اگر اُس میں ادائیگی کا مقدور نہ ہو تو جو کچھ اُس نے بیچا وہ یوویلؔ کے سال تک خریدار کے قبضہ میں رہے گا لیکن یوویلؔ کے سال میں یہ خُود ہی چھُوٹ کر اَپنے اصلی مالک کے پاس لَوٹ جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","” ’اَور اگر کویٔی شخص کسی فصیلدار شہر میں اَپنے مکان کو بیچتا ہے، تو اُس کی فروخت کے بعد بھی اُسے حق حاصل ہے کہ وہ ایک سال کے پُورا ہونے سے پہلے اُسے چھُڑا سکےگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","اَور اگر پُورے ایک سال کی میعاد کے اَندر اِسے چھُڑایا نہ جایٔے تو اُس فصیلدار شہر کے مکان پر خریدار اَور اُس کی نَسل کا قبضہ ہمیشہ کے لیٔے قائِم ہو جایٔےگا۔ اَور وہ یوویلؔ والے سال میں بھی واپس نہیں کیا جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","لیکن جو دیہات والے مکان بغیر فصیلوں کے ہُوں اُنہیں کھیتوں کے برابر سمجھا جائے۔ اُنہیں چھُڑایا جا سَکتا ہے اَور وہ یوویلؔ والے سال میں واپس لَوٹا دئیے جایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","” ’لیکن لیویوں کو اَپنے شہروں میں اُن مکانات کو جِن کے وہ مالک ہیں چھُڑانے کا حق ہمیشہ ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","لہٰذا جو بھی مِلکیّت لیویوں کی ہے، اُنہیں چھُڑایا جا سکتا ہے اَور لیویوں کے کسی بھی شہر میں کویٔی مکان جو بیچ دیا گیا ہو اُسے یوویلؔ والے سال میں واپس لَوٹا دیا جائے گا کیونکہ بنی اِسرائیل کے درمیان وہ مکانات جو لیویوں کے شہروں میں ہیں اُن کی مِلکیّت ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","لیکن اُن کے شہروں کی چراگاہوں کو ہرگز نہ بیچا جائے کیونکہ وہ اُن کی دائمی مِلکیّت ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","” ’اَور اگر تمہارا کویٔی ہم وطن اِسرائیلی مُفلس ہو جائے اَور تمہارے درمیان رہتے ہویٔے بھی تنگ دست ہو تو اُس کی مدد کرنا جَیسا کہ تُم کسی پردیسی یا مُسافر کی کرتے ہو تاکہ وہ تمہارے درمیان بسا رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","اَور اُس سے کسی قِسم کا سُود یا فائدہ نہ لینا بَلکہ اَپنے خُدا سے ڈرنا تاکہ تمہارا ہم وطن بھایٔی تمہارے درمیان بسا رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","تُم اُسے نہ تو اَپنا رُوپیہ سُود پر دوگے اَور نہ ہی اناج نفع کے لالچ سے دوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","مَیں یَاہوِہ تمہارا خُدا ہُوں جو تُمہیں مِصر سے نکال کر لایا ہُوں تاکہ تُمہیں مُلکِ کنعانؔ دُوں اَور تمہارا خُدا ٹھہروں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","” ’اگر تمہارے درمیان تمہارا ایک اِسرائیلی ہم وطن مُفلس ہو جائے اَور خُود کو تمہارے ہاتھ میں بیچ دے تو اُس سے غُلام کی مانند خدمت نہ لینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","بَلکہ وہ تمہارے ساتھ ایک مزدُور یا مُسافر کی طرح تمہارے درمیان رہے۔ اَور وہ یوویلؔ کے سال تک تمہاری خدمت کرتا رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","پھر سالِ یوویلؔ کے بعد اُسے اَور اُس کے بچّوں کے ساتھ آزاد کردینا تاکہ وہ اَپنی برادری کے پاس اَور اَپنے آباؤاَجداد کی مِلکیّت کی جگہ واپس چلا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","کیونکہ بنی اِسرائیل میرے خادِم ہیں جنہیں میں مِصر سے نکال کر لایاتھا، لہٰذا اُن کو بطور غُلام ہرگز نہ بیچا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","اَور تُم اُن پر سختی سے حُکمرانی نہ کرنا بَلکہ اَپنے خُدا سے ڈرتے رہنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","” ’تمہارے غُلام اَور تمہاری لونڈیاں اُن قوموں میں سے ہُوں جو تمہارے چَوگرد رہتی ہیں؛ اُن ہی میں سے تُم غُلام اَور لونڈی خریدا کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","اِن کے سِوا تمہارے درمیان عارضی مُسافر اَور اُن کی برادریوں کے اُن افراد میں سے بھی جو تمہارے مُلک میں پیدا ہویٔے ہیں اَور تمہارے ساتھ رہتے ہیں اُن میں سے کچھ کو خرید سکتے ہو اَور وہ تمہاری مِلکیّت ہو سکتے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","اَور تُم اُنہیں مِیراث کے طور پر اَپنی اَولاد کے نام کر سکتے ہو؛ اَور یُوں اُنہیں عمر بھرکے لیٔے غُلام بنا سکتے ہو لیکن تُم اَپنے اِسرائیلی ہم وطنوں پر سختی سے حُکمرانی نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","” ’اَور اگر تمہارے درمیان کویٔی پردیسی یا عارضی باشِندہ دولتمند ہو جائے اَور تمہارا کویٔی اِسرائیلی بھایٔی مُفلس اَور خُود کو اُس پردیسی یا عارضی باشِندے یا اُس پردیسی کی برادری والوں کے ہاتھ بیچ دے، ");
INSERT INTO urdoucv_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","تو بیچے جانے کے بعد بھی وہ چھُڑایا جا سَکتا ہے اَور اُس کے رشتہ داروں میں سے کویٔی اُسے چھُڑا سَکتا ہے، ");
INSERT INTO urdoucv_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","اُس کا چچا یا چچیرا بھایٔی یا اُس کے گھرانے کا کویٔی قریبی برادری والا اُسے چھُڑا سَکتا ہے یا اگر وہ خُود مالدار ہو جائے تو وہ اَپنے آپ کو چھُڑا سَکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","وہ اَپنے خریدار کے ساتھ اَپنے کو فروخت کر دینے کے سال سے لے کر سالِ یوویلؔ تک کی مُدّت کا شُمار کرے؛ اُس کی رِہائی کی قیمت اُن سالوں کے لیٔے کسی مزدُور کو اَدا کی گئی مزدُوری کی شرح کے حِساب سے طے ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","اگر سالِ یوویلؔ تک ابھی بہت سال باقی ہُوں تو اَپنے چھُڑائے جانے کے لیٔے قیمت کا ایک بڑا حِصّہ اَدا کرنا ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","اَور اگر سالِ یوویلؔ کے آنے میں تھوڑے سال ہی باقی رہ گیٔے ہُوں تو وہ اَپنے مالک کے ساتھ اِن کی گِنتی کرے اَور اُن سالوں کے مُطابق اَپنے چھُڑانے کی قیمت اُسے لَوٹا دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","اَور وہ اَپنے مالک کے ساتھ کسی مزدُور کی طرح رہے جِس کی اُجرت سال بسال ٹھہرائی جاتی ہو، اَور تُم اِس بات کا ضروُر خیال رکھنا کہ اُس کا مالک اُس پر سختی سے حُکمرانی نہ کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","” ’اَور اگر وہ اِن طریقوں میں سے کسی طریقہ سے چھُڑایا نہیں گیا، تو بھی وہ اَور اُس کے بچّے سالِ یوویلؔ میں آزاد کر دئیے جایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","کیونکہ بنی اِسرائیل میرے خادِم ہیں۔ یہ میرے وہ خادِم ہیں جنہیں میں مِصر سے نکال کر لایا ہُوں۔ مَیں یَاہوِہ تمہارا خُدا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","” ’تُم اَپنے لیٔے بُت نہ بنانا اَور نہ کویٔی مُورت یا کویٔی مُقدّس پتّھر کھڑا کرنا اَور نہ اَپنے مُلک میں کویٔی شَبیہ دار پتّھر رکھنا کہ اُس کے آگے سَجدہ کرو۔ مَیں یَاہوِہ تمہارا خُدا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","” ’اَور تُم میرے سَبتوں کو ماَننا اَور میرے پاک مَقدِس کی تعظیم کرنا کیونکہ مَیں یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","” ’اگر تُم میرے قوانین پر عَمل کروگے اَور میرے اَحکام کو ماننے میں محتاط رہوگے، ");
INSERT INTO urdoucv_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","تو مَیں تمہارے لیٔے بروقت بارش کیا کروں گا، اَور زمین اَپنی پیداوار دے گی، اَور میدان کے درخت اَپنے پھل دیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","تمہاری کٹائی انگور کی فصل تک جاری رہے گی، اَور تمہاری انگور کی فصل، بیج کی بُوائی تک جاری رہے گی، چنانچہ تُم بھرپیٹ کھانا کھاؤگے اَور اَپنے مُلک میں سلامتی سے بسے رہوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","” ’اَور مَیں مُلک میں اَمن بخشوں گا، تاکہ تُم چَین سے سوؤ اَور کسی چیز کا تُمہیں خوف نہ ہو۔ اَور مَیں جنگلی حَیوانوں کو تمہارے مُلک سے بھگا دُوں گا، اَور تمہارے مُلک میں کویٔی بھی تلوار سے ہلاک نہ ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","لیکن تُم اَپنے دُشمنوں کا تعاقب کروگے اَور وہ تمہارے سامنے تلوار سے مارے جایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","تُم میں سے پانچ شخص سَو کو اَور سَو دس ہزار کو کھدیڑ دیں گے، اَور تمہارے دُشمن تمہارے سامنے تلوار سے مارے جایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","” ’اَور میری تُم پر نظرِکرم ہوگی اَور مَیں تُمہیں سرفراز کروں گا، اَور مَیں تمہاری تعداد کو بڑھاؤں گا اَور تمہارے ساتھ کئےگئے اَپنے عہد کو پُورا کروں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","تُم ابھی پچھلے سال کا ہی اناج کھا رہے ہوگے کہ تُمہیں اُسے باہر نکالنا پڑےگا تاکہ تُم نئے فصل کا ذخیرہ گودام میں رکھنے کے واسطے جگہ بنا سکو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","میں اَپنی قِیام گاہ تمہارے درمیان قائِم کروں گا، اَور مَیں تُم سے نفرت نہیں کروں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","مَیں تمہارے درمیان چلا پھرا کروں گا، اَور مَیں تمہارا خُدا ہُوں گا اَور تُم میری اُمّت ہوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","مَیں یَاہوِہ ہی تمہارا خُدا ہُوں جو تُمہیں مِصر سے نکال لایا تاکہ تُم مِصریوں کے غُلام نہ بنے رہو؛ مَیں نے تمہارے جُوئے کی سلاخیں توڑ ڈالی ہیں اَور تُمہیں سَر اُونچا کرکے چلنے کے لائق بنا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","” ’لیکن اگر تُم میری نہ سنوگے اَور اِن سَب اَحکام پر عَمل نہ کروگے، ");
INSERT INTO urdoucv_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","اَور اگر میرے قوانین کو مُسترد کروگے اَور میرے اَحکام سے نفرت کروگے، اَور میرے تمام اَحکام کی تعمیل کرنے میں ناکام رہوگے اَور یُوں میرے عہد کی خِلاف ورزی کروگے، ");
INSERT INTO urdoucv_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","تو میں تُم پر اَچانک دہشت، برباد کرنے والی بیماریاں اَور بُخار کو بھیجوں گا جو تمہاری بینائی کو تباہ کر دیں گی اَور تمہاری جان لے لیں گی۔ تمہارا بیج بونا بے فائدہ ہوگا کیونکہ وہ تمہارے دُشمنوں کا لقمہ بَن جائیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","اَور مَیں تمہارا مُخالف ہو جاؤں گا۔ لہٰذا تُم اَپنے دُشمنوں سے شِکست کھاؤگے اَور وہ جو تُم سے نفرت کرتے ہیں تُم پر حُکمرانی کریں گے اَور جَب کویٔی بھی تمہارا تعاقب نہ کر رہا ہوگا، تَب بھی تُم بھاگتے رہوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","” ’اَور اگر تُم یہ سَب ہونے کے باوُجُود بھی میری نہ سنوگے، تو میں تُمہیں تمہارے گُناہوں کے سبب سے سات گُنا سزا دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","اَور مَیں تمہاری شہزوری کے تکبُّر کو توڑ ڈالوں گا اَور تمہارے اُوپر آسمان کو لوہے کی مانند اَور نیچے زمین کو کانسے کی مانند بنا دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","اَور تمہاری تمام محنت بیکار ثابت ہوگی کیونکہ تمہاری زمین اَپنی پیداوار نہ دے گی اَور نہ ہی مُلک کے درخت اَپنے پھل دیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","” ’اَور اگر تُم یہ سَب ہونے کے باوُجُود بھی اَپنی فطرت میں تبدیلی نہیں لاؤگے اَور میری مُخالفت کرتے رہوگے اَور میری سُننے سے اِنکار کروگے تو مَیں تمہارے گُناہوں کے مُطابق تمہاری بَلاؤں کو سات گُنا بڑھا دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","مَیں تمہارے خِلاف جنگلی جانوروں کو بھیجوں گا، وہ تمہارے بچّوں کو اُٹھالے جایٔیں گے اَور تمہارے چَوپایوں کو تباہ کر دیں گے اَور تمہاری تعداد اِس قدر کم کر دیں گے کہ تمہاری شاہراہیں سُونی پڑ جایٔیں گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","” ’اگر اِن باتوں کے باوُجُود بھی تُم میری تربّیت قبُول نہ کرو اَور میری طرف رُجُوع نہ لاؤ بَلکہ تُم میرے خِلاف ہی چلتے رہو، ");
INSERT INTO urdoucv_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","تو میں بھی تمہارے خِلاف چلُوں گا اَور تمہارے گُناہوں کے سبب سے تُمہیں سات گُنا اَور رنجیدہ کروں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","اَور تمہاری عہد شکنی کا بدلہ لینے کے لیٔے تُم پر تلوار چلاؤں گا اَور جَب تُم اَپنی حِفاظت کے لیٔے شہروں کے اَندر بھاگ کر جمع ہوگے تو مَیں تمہارے درمیان وَبائی بیماریاں بھیجوں گا اَور تُم دُشمنوں کے ہاتھوں میں دئیے جاؤگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","اَور جَب مَیں تمہاری رسد مُہیّا کے سلسلہ کو برباد کر دُوں گا تو دس عورتیں ایک ہی تنور میں تمہاری روٹی پکائیں گی اَور تُمہیں وزن کے حِساب سے تھوڑی تھوڑی دیں گی۔ تُم کھاؤگے لیکن سیر نہ ہوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","” ’اَور اگر اِس کے باوُجُود بھی تُم نے میری نہ سُنی اَور میرے خِلاف ہی چلتے رہے، ");
INSERT INTO urdoucv_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","تَب میں اَپنے غضب میں تمہارے خِلاف ہوؤں گا، اَور تمہارے گُناہوں کے سبب میں خُود تُمہیں سات گُنی سزا دُوں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","تُم اَپنے بیٹوں اَور اَپنی بیٹیوں کا گوشت کھاؤگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","اَور مَیں تمہارے اُن اُونچے مقامات کو تباہ کر دُوں گا اَور تمہارے بخُوردان کے مذبحوں کو تباہ کر دُوں گا، اَور تمہارے بے جان بُتوں پر تمہاری لاشوں کا ڈھیر لگا دُوں گا اَور تُم سے نفرت کروں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","اَور مَیں تمہارے شہروں کو کھنڈرات میں تبدیل کر دُوں گا اَور تمہارے معبُودوں کے پاک مَقدِسوں کو برباد کر دُوں گا اَور تمہاری قُربانیوں کی فرحت بخش خُوشبو کو میں قبُول نہیں کروں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","مَیں تمہارے مُلک کو ویران کر دُوں گا تاکہ تمہارے دُشمن جو وہاں آباد ہونے آئیں گے، اِسے دیکھ کر خوفزدہ ہو جایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","میں تُمہیں تمام قوموں میں پراگندہ کر دُوں گا، اَور مَیں اَپنی تلوار کھینچ کر تمہارا تعاقب کروں گا اَور تمہارا مُلک ویران اَور تمہارے شہر کھنڈرات ہو جایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","جَب تک تُم اَپنے دُشمنوں کے مُلک میں رہوگے، تَب تک یہ زمین آرام کرےگی اَور اَپنے سَبت کے سال منائے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","جَب تک یہ زمین ویران رہے گی اُسے وہ آرام نصیب ہوگا جو اُسے اُن سَبتوں کے دَوران بھی نہ مِلا تھا جَب تُم اِس مُلک میں رہتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","” ’اَور تُم میں سے جو باقی بچیں گے میں اُن کے دُشمنوں کے ممالک میں اُن کے دِلوں کو اَیسا خوفزدہ کر دُوں گا کہ ہَوا سے اُڑتے ہُوئے پتّے کی آواز سُن کر بھی وہ بھاگ کھڑے ہوں گے۔ وہ اَیسے بھاگیں گے گویا کویٔی تلوار لیٔے ہویٔے اُن کا پیچھا کر رہا ہو، ہالانکہ کویٔی اُن کا پیچھا بھی نہیں کر رہا ہوگا تو بھی وہ گرتے پڑتے بھاگیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","اَور وہ ٹھوکر کھا کر ایک دُوسرے پر اَیسے گریں گے گویا تلوار سے بچنے کے لیٔے بھاگ رہے ہُوں، حالانکہ کویٔی بھی اُن کا پیچھا نہ کر رہا ہوگا۔ لہٰذا تُم میں اَپنے دُشمنوں کے مقابل کھڑا ہونے کی ہمّت بھی نہ ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","اَور تُم غَیر قوموں کے درمیان جَلاوطنی میں فنا ہو جاؤگے اَور تمہارے دُشمنوں کی زمین تُمہیں کھا جائے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","اَور تُم میں سے جو باقی بچے رہ جایٔیں گے، وہ اَپنے اَور اَپنے آباؤاَجداد کے گُناہوں کے باعث تمہارے دُشمنوں کے مُلک میں ہی فنا ہو جایٔیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","” ’لیکن اگر وہ اَپنے اَور اَپنے آباؤاَجداد کے گُناہوں کا اقرار کریں گے کہ اُنہُوں نے میرے ساتھ دغا اَور عداوت کی ہے، ");
INSERT INTO urdoucv_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","جِس کے باعث میں بھی اُن کا اَیسا مُخالف ہُوا کہ مَیں نے اُنہیں اُن کے دُشمنوں کے مُلک میں بھیج دیا؛ اَور جَب اُن کے نامختون دِل حلیم ہو جایٔیں اَور وہ اَپنے گُناہوں کا کفّارہ کر لیں، ");
INSERT INTO urdoucv_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","تو میں اَپنا عہد جو مَیں نے یعقوب، اِصحاقؔ اَور اَبراہامؔ کے ساتھ باندھا تھا یاد کروں گا اَور اُس مُلک کو بھی یاد کروں گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","لیکن اُن کے نکل جانے کی وجہ سے یہ مُلک ویران ہو جایٔےگا تاکہ یہ زمین اَپنے سَبتوں کے نُقصان کو پُورا کر لے۔ اِسی دَوران وہ اَپنے گُناہوں کا کفّارہ کریں گے؛ کیونکہ اُنہُوں نے میرے آئین کو مُسترد کیا اَور میرے قوانین سے نفرت کی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","تاہم جَب وہ اَپنے دُشمنوں کے مُلک میں ہوں گے، تَب بھی میں اُنہیں مُسترد نہ کروں گا اَور نہ ہی اُن سے اَیسی نفرت کروں گا کہ میں اُن کے ساتھ اَپنے عہد کو توڑ کر اُن کو بالکُل فنا کر دُوں۔ میں ہی یَاہوِہ اُن کا خُدا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","لیکن مَیں اُن کی خاطِر اُن کے آباؤاَجداد کے ساتھ باندھا ہُوا عہد یاد کروں گا، جنہیں میں غَیر قوموں کی آنکھوں کے سامنے مِصر سے نکال لایاتھا تاکہ میں اُن کا خُدا ٹھہروں۔ میں ہی یَاہوِہ ہُوں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","یہ وہ قوانین، آئین اَور ضوابط ہیں جنہیں یَاہوِہ نے کوہِ سِینؔائی پر مَوشہ کی مَعرفت اَپنے اَور بنی اِسرائیل کے مابین مُقرّر کئے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","”بنی اِسرائیل سے مُخاطِب ہو اَور اُنہیں حُکم دینا، ’اگر کویٔی شخص یَاہوِہ کو نذر کرنے کی کویٔی خاص مَنّت مانے تو اُس شخص کے فدیہ کی قیمت کو اِس طرح مُقرّر کرنا، ");
INSERT INTO urdoucv_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","بیس سال سے لے کر ساٹھ سال کی عمر تک کے مَرد کی قیمت پاک مَقدِس کی ثاقل کے حِساب سے چاندی کی پچاس ثاقل ہو؛ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","اَور اگر وہ عورت ہو تو اُس کی قیمت تیس ثاقل ہو؛ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","اَور اگر وہ شخص پانچ سال سے لے کر بیس سال کی عمر کا ہو تو مَرد کی قیمت بیس ثاقل اَور عورت کی قیمت دس ثاقل ہو؛ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","اَور ایک ماہ سے لے کر پانچ سال کی عمر کے لڑکے کے لیٔے چاندی کی پانچ ثاقل اَور لڑکی کے لیٔے چاندی کی تین ثاقل ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","اَور ساٹھ سال یا اِس سے زِیادہ کی عمر کے مَرد کی قیمت پندرہ ثاقل اَور عورت کی دس ثاقل ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","لیکن اگر کویٔی مَنّت ماننے والا اِس قدر غریب ہو کہ اُسے مُقرّرہ رقم اَدا کرنے کا مقدور نہ ہو، تو وہ اُس شخص کو کاہِنؔ کے سامنے پیش کرے اَور کاہِنؔ اُس شخص کے فدیہ کی قیمت اُس شخص کے حیثیت کے مُطابق اُس کی قیمت مُقرّر کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","” ’اگر اُس نے کسی اَیسے جانور کی مَنّت مانی ہے جو بطور نذر یَاہوِہ کے لیٔے مقبُول ٹھہرے تو یَاہوِہ کو نذر کیا ہُوا وہ جانور پاک ٹھہرے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","اَور مَنّت ماننے والا اُسے ہرگز نہ بدلے، نہ اَچھّے کے عِوض بُرا دے اَور نہ بُرے کے عِوض اَچھّا دے۔ لیکن اگر کویٔی اَیسا عدل بدل کر بھی لیتا ہے، تو وہ جانور اَور اُس کا بدل دُوسرا جانور دونوں ہی پاک ٹھہریں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","لیکن اگر مَنّت کا جانور ناپاک ہو اَور یَاہوِہ کو بطور قُربانی کرنے لائق نہ ہو، تو وہ اُس جانور کو لازماً کاہِنؔ کے سامنے پیش کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","کاہِنؔ اُس جانور کی اَچھّائی یا بُرائی کا مُعائنہ کرےگا اَور تَب اُس کی جو بھی قیمت کاہِنؔ مُقرّر کرے وُہی اُس کی قیمت ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","اَور اگر اُس کا مالک اُس جانور کا فدیہ دینا چاہے تو وہ اُس مُقرّرہ قیمت میں اُس کا پانچواں حِصّہ اِضافہ کرکے اُسے اَدا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","” ’اَور اگر کویٔی شخص اَپنے مکان کو یَاہوِہ کے لیٔے مخصُوص کرکے الگ کر دے، تو کاہِنؔ اُس کے اَچھّا یا بُرا ہونے کا مُعائنہ کرے اَور کاہِنؔ جو قیمت مُقرّر کرے وُہی اُس کی قیمت ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","اَور اگر وہ شخص جِس نے اَپنے مکان کو مخصُوص کر دیا ہے، مگر وہ اَپنے مکان کو فدیہ دے کر اُسے چھُڑانا چاہے، تو وہ مُقرّر قیمت کے علاوہ، اُس کا پانچواں حِصّہ اِضافہ کرکے اَدا کرے تاکہ وہ مکان پھر اُس کا ہو جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","” ’اگر کویٔی شخص اَپنی موروثی زمین کا کچھ حِصّہ یَاہوِہ کے لیٔے مخصُوص کرے تو اُس کی قیمت اُس کے لیٔے درکار بیج کی مقدار کے مُطابق مُقرّر ہوگی یعنی جَو کے بیج کے ایک حُومر کے لیٔے پچاس ثاقل۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","اَور اگر وہ یوویلؔ والے سال کے دَوران اَپنا کھیت مخصُوص کرے تو اُس کی جو قیمت مُقرّر ہو چُکی ہو وُہی رہے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","لیکن اگر وہ اَپنا کھیت یوویلؔ کے بعد مخصُوص کرے تو اگلی یوویلؔ تک جتنے سال باقی رہتے ہُوں اُن کے مُطابق کاہِنؔ اُس کی قیمت مُقرّر کرے اَور اُس کی پہلی قیمت کم کر دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","اگر وہ شخص جِس نے کھیت مخصُوص کیا ہو اُس کا فدیہ دے کر اُسے چھُڑانا چاہے تو وہ اُس کی قیمت میں اُس کا پانچواں حِصّہ اِضافہ کرکے اَدا کرے تو وہ کھیت پھر اُس کا ہو جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","تاہم اگر وہ اُس کھیت کو نہ چھُڑائے یا اگر اُس نے اُسے کسی دُوسرے کو بیچ دیا ہو تو پھر اُسے کبھی بھی چھُڑایا نہیں جا سَکتا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","اَور جَب کھیت یوویلؔ والے سال میں چھُڑایا جائے تو وہ یَاہوِہ کے لیٔے مخصُوص کئے ہویٔے کھیت کی طرح پاک ہوگا اَور وہ کاہِنؔ کی مِلکیّت ٹھہرے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","” ’اَور اگر کویٔی شخص کویٔی خریدا ہُوا کھیت جو اُس کی موروثی زمین کا حِصّہ نہیں، یَاہوِہ کے لیٔے مخصُوص کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","تو کاہِنؔ یوویلؔ کے سال تک اُس کی قیمت مُعیّن کرے اَور وہ شخص اُس دِن ضروُر اُس کی قیمت اَدا کرے جو یَاہوِہ کے لیٔے مُقدّس نذرانہ ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","اَور یوویلؔ کے سال میں وہ کھیت اُس شخص کو جِس سے اُس نے خریدا تھا واپس کر دیا جائے یعنی اُس شخص کو جِس کی وہ موروثی مِلکیّت تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","ہر ایک قیمت پاک مَقدِس کی ثاقل کے مُطابق مُقرّر کی جائے یعنی ایک ثاقل بیس گیراہ کا ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","” ’تاہم کویٔی بھی کسی جانور کے پہلوٹھے کو مخصُوص نہ کرے کیونکہ وہ پہلوٹھا پہلے ہی یَاہوِہ کا ہے خواہ وہ بَیل ہو یا بھیڑ، وہ یَاہوِہ ہی کا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","اَور اگر کویٔی ناپاک جانور ہو تو وہ اُس کی مُقرّرہ قیمت میں اُس کا پانچواں حِصّہ اِضافہ کرکے اُسے واپس خرید لے۔ اَور اگر وہ اُس کو نہ چھُڑائے تو اُسے اُس کی مُقرّرہ قیمت پر بیچ دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","” ’لیکن کویٔی شَے جو کسی کی مِلکیّت ہو اَور اُس نے اُسے یَاہوِہ کے لیٔے مخصُوص کر دیا ہو خواہ وہ شخص ہو یا جانور یا موروثی زمین تو اُسے بیچا ہی جا سَکتا ہے نہ چھُڑایا جا سَکتا ہے کیونکہ اِس طرح کی مخصُوص کی ہُوئی ہر چیز یَاہوِہ کے لیٔے نہایت پاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","” ’کویٔی بھی شخص جو ہلاکت کے لیٔے مخصُوص کیا گیا ہو چھُڑایا نہ جائے بَلکہ جان سے مار دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","” ’زمین سے پیدا ہونے والی ہر چیز کی دہ یکی خواہ وہ زمین سے اناج کی یا درختوں سے پھلوں کی پیداوار ہو یَاہوِہ کی ہے اَور وہ یَاہوِہ کے لیٔے پاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","اَور اگر کویٔی شخص اَپنی کسی دہ یکی کو چھُڑائے تو وہ اُس کی قیمت میں اُس کا پانچواں حِصّہ اِضافہ کرکے اَدا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","گلّے اَور ریوڑ کی دہ یکی یعنی ہر دسواں جانور جو چرواہے کے عصا کے نیچے سے گزرتا ہے یَاہوِہ کے لیٔے پاک ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","وہ بُروں میں سے اَچھّوں کا اِنتخاب ہرگز نہ کرے اَور نہ ہی اُنہیں بدلے۔ اَور اگر وہ بدلےگا تو وہ جانور اَور اُس کا بدل دونوں ہی پاک ہوں گے اَور چھُڑائے نہ جا سکیں گے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","یہ وہ اَحکام ہیں جو یَاہوِہ نے بنی اِسرائیل کے لیٔے مَوشہ کو کوہِ سِینؔائی پر دئیے۔");
INSERT INTO urdoucv_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","بنی اِسرائیل کے مُلک مِصر سے نکل آنے کے دُوسرے سال کے دُوسرے مہینے کے پہلے دِن سِینؔائی کے بیابان میں یَاہوِہ نے خیمہ اِجتماع میں مَوشہ سے باتیں کیں اَور یہ حُکم دیا: ");
INSERT INTO urdoucv_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","”تُم بنی اِسرائیل کی ساری جماعت کی اُن کی برادری اَور خاندانوں کے مُطابق ہر ایک مَرد کا یکے بعد دیگرے نام درج کرکے مردُم شُماری کرو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","تُم اَور اَہرونؔ تمام اِسرائیلی مَردوں کی اُن کہ دستوں کے مُطابق گِنتی کرنا جو بیس سال یا اُس سے زِیادہ عمر کے ہُوں اَورجو فَوج میں خدمت کرنے کے قابل ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","اَور ہر قبیلہ سے ایک آدمی جو اَپنے خاندان کا سردار ہو تمہاری مدد کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","”اَورجو آدمی تمہاری مدد کریں گے اُن کے نام یہ ہیں: ”رُوبِنؔ کے قبیلہ سے شدِیُورؔ کا بیٹا اِلیضُورؔ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","شمعُونؔ کے قبیلہ سے ضُوریشدّؔی کا بیٹا سلُومی ایل؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","یہُوداہؔ کے قبیلہ سے عَمّیندابؔ کا بیٹا نحشونؔ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","یِسَّکاؔر کے قبیلہ سے ضُعرؔ کا بیٹا نتنی ایل؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","زبُولُون کے قبیلہ سے حیلونؔ کا بیٹا اِلیابؔ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","یُوسیفؔ کے بیٹوں میں سے: اِفرائیمؔ کے قبیلہ سے عمّیہُوؔد کا بیٹا اِلیشمعؔ منشّہ کے قبیلہ سے پِداہضُورؔ کا بیٹا گَملی ایل؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","بِنیامین کے قبیلہ سے ابیدانؔ بِن گِدعونیؔ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","دانؔ کے قبیلہ سے احیعزر بِن عمّی شدّؔی؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","آشیر کے قبیلہ سے عُکرانؔ کا بیٹا پگعِیلؔ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","گادؔ کے قبیلہ سے دعُوایلؔ کا بیٹا اِلیاسفؔ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","نفتالی کے قبیلہ سے عینانؔ کا بیٹا اَخیرعؔ۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","جماعت میں سے اِن آدمیوں کا جو اَپنے قبیلوں کے سردار تھے تقرّر کیا گیا۔ وہ اِسرائیل کی برادریوں کے سربراہ تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","مَوشہ اَور اَہرونؔ نے اُن آدمیوں کو جِن کے نام اُنہیں بتائے گیٔے تھے اَپنے ساتھ لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","اَور دُوسرے مہینے کے پہلے دِن ساری جماعت کو جمع کیا۔ لوگوں نے اَپنی اَپنی برادری اَور خاندانوں کے مُطابق اَپنا حسب و نَسب ظاہر کیا اَورجو مَرد بیس سال یا اُس سے زِیادہ عمر کے تھے اُن کے نام یکے بعد دیگرے درج کئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا اُسی کے مُطابق اُس نے اُنہیں سِینؔائی کے بیابان میں گِنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","اِسرائیل کے پہلوٹھے رُوبِنؔ کی نَسل سے: بیس سال یا اُس سے زِیادہ عمر کے سبھی مَردوں کے نام جو فَوج میں خدمت کرنے کے قابل تھے اَپنی اَپنی برادری اَور خاندان کے مُطابق یکے بعد دیگرے درج کئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","اَور رُوبِنؔ کے قبیلہ سے جِن آدمیوں کے نام درج کئے گیٔے اُن کی تعداد 46,500 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","شمعُونؔ کی نَسل سے: بیس سال یا اُس سے زِیادہ عمر کے سبھی مَردوں کے نام جو فَوج میں خدمت کرنے کے قابل تھے اَپنی اَپنی برادری اَور خاندان کے مُطابق یکے بعد دیگرے درج کئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","اَور شمعُونؔ کے قبیلہ سے جِن آدمیوں کے نام درج کئے گیٔے اُن کی تعداد 59,300 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","گادؔ کی نَسل سے: بیس سال یا اُس سے زِیادہ عمر کے سبھی مَردوں کے نام جو فَوج میں خدمت کرنے کے قابل تھے اَپنی اَپنی برادری اَور خاندان کے مُطابق یکے بعد دیگرے درج کئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","اَور گادؔ کے قبیلہ سے جِن آدمیوں کے نام درج کئے گیٔے اُن کی تعداد 45,650 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","یہُوداہؔ کی نَسل سے: بیس سال یا اُس سے زِیادہ عمر کے سبھی مَردوں کے نام جو فَوج میں خدمت کرنے کے قابل تھے اَپنی اَپنی برادری اَور خاندان کے مُطابق یکے بعد دیگرے درج کئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","یہُوداہؔ کے قبیلہ سے جِن آدمیوں کے نام درج کئے گیٔے اُن کی تعداد 74,600 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","یِسَّکاؔر کی نَسل سے: بیس سال یا اُس سے زِیادہ عمر کے سبھی مَردوں کے نام جو فَوج میں خدمت کرنے کے قابل تھے اَپنی اَپنی برادری اَور خاندان کے مُطابق یکے بعد دیگرے درج کئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","یِسَّکاؔر کے قبیلہ سے جِن آدمیوں کے نام درج کئے گیٔے اُن کی تعداد 54,400 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","زبُولُون کی نَسل سے: بیس سال یا اُس سے زِیادہ عمر کے سبھی مَردوں کے نام جو فَوج میں خدمت کرنے کے قابل تھے اَپنی اَپنی برادری اَور خاندان کے مُطابق یکے بعد دیگرے درج کئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","زبُولُون کے قبیلہ سے جِن آدمیوں کے نام درج کئے گیٔے اُن کی تعداد 57,400 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","یُوسیفؔ کی اَولاد: یعنی اِفرائیمؔ کی نَسل سے: بیس سال یا اُس سے زِیادہ عمر کے سبھی مَردوں کے نام جو فَوج میں خدمت کرنے کے قابل تھے اَپنی اَپنی برادری اَور خاندان کے مُطابق یکے بعد دیگرے درج کئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","اِفرائیمؔ کے قبیلہ سے جِن آدمیوں کے نام درج کئے گیٔے اُن کی تعداد 40,500 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","منشّہ کی نَسل سے: بیس سال یا اُس سے زِیادہ عمر کے سبھی مَردوں کے نام جو فَوج میں خدمت کرنے کے قابل تھے اَپنی اَپنی برادری اَور خاندان کے مُطابق یکے بعد دیگرے درج کئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","منشّہ کے قبیلہ سے جِن آدمیوں کے نام درج کئے گیٔے اُن کی تعداد 32,200 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","بِنیامین کی نَسل سے: بیس سال یا اُس سے زِیادہ عمر کے سبھی مَردوں کے نام جو فَوج میں خدمت کرنے کے قابل تھے اَپنی اَپنی برادری اَور خاندان کے مُطابق یکے بعد دیگرے درج کئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","بِنیامین کے قبیلہ سے جِن آدمیوں کے نام درج کئے گیٔے اُن کی تعداد 35,400 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","دانؔ کی نَسل سے: بیس سال یا اُس سے زِیادہ عمر کے سبھی مَردوں کے نام جو فَوج میں خدمت کرنے کے قابل تھے اَپنی اَپنی برادری اَور خاندان کے مُطابق یکے بعد دیگرے درج کئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","دانؔ کے قبیلہ سے جِن آدمیوں کے نام درج کئے گیٔے اُن کی تعداد 62,700 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","آشیر کی نَسل سے: بیس سال یا اُس سے زِیادہ عمر کے سبھی مَردوں کے نام جو فَوج میں خدمت کرنے کے قابل تھے اَپنی اَپنی برادری اَور خاندان کے مُطابق یکے بعد دیگرے درج کئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","آشیر کے قبیلہ سے جِن آدمیوں کے نام درج کئے گیٔے اُن کی تعداد 41,500 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","نفتالی کی نَسل سے: بیس سال یا اُس سے زِیادہ عمر کے سبھی مَردوں کے نام جو فَوج میں خدمت کرنے کے قابل تھے اَپنی اَپنی برادری اَور خاندان کے مُطابق یکے بعد دیگرے درج کئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","نفتالی کے قبیلہ سے جِن آدمیوں کے نام درج کئے گیٔے اُن کی تعداد 53,400 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","مَوشہ اَور اَہرونؔ اَور بنی اِسرائیل کے بَارہ سرداروں نے جِس میں سے ہر ایک اَپنے اَپنے خاندان کا سردار تھا جِن مَردوں کو گِنا وہ یہی تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","چنانچہ تمام بنی اِسرائیل میں جتنے مَرد بیس سال یا اُس سے زِیادہ عمر کے تھے اَورجو اِسرائیل کی فَوج میں خدمت کرنے کے قابل تھے اَپنے اَپنے خاندانوں کے مُطابق شُمار کئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","اُن کی کُل تعداد 6,03,550 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","البتّہ لیوی کے قبیلہ کے خاندانوں کا اَوروں کے ساتھ شُمار نہ کیا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","کیونکہ یَاہوِہ نے مَوشہ سے فرمایا تھا، ");
INSERT INTO urdoucv_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","”تُم لیوی کے قبیلہ کا شُمار نہ کرنا اَور نہ ہی اُنہیں دُوسرے اِسرائیلیوں کی مردُم شماری میں شامل کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","بَلکہ تُم لیویوں کو مَسکن اَور اُس کی تمام آرائِش کی چیزوں اَور اُس سے متعلّقہ ہر شَے کا نِگراں مُقرّر کرنا۔ وہ مَسکن اَور اُس کی آرائِش کی چیزوں کو اُٹھائیں اُس کی حِفاظت کریں اَور اُس کے اطراف ڈیرے ڈالیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","جَب کبھی مَسکن کے خیمہ کو کہیں اَور لے جانے کا وقت آئے تو لیوی اُسے گرائیں اَور جَب کبھی اُسے کھڑا کرنے کا موقع آئے تو لیوی ہی یہ کام کریں۔ اَور اگر کویٔی اَور شخص اُس کے قریب آ جائے تو وہ جان سے ماراجائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","اَور بنی اِسرائیل اَپنے اَپنے دستوں کے مُطابق اَپنے خیمے کھڑے کریں یعنی ہر شخص اَپنی اَپنی چھاؤنی میں اَور اَپنے اَپنے پرچم کے نیچے خیمہ زن ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","البتّہ لیوی شہادت کے مَسکن کے اطراف اَپنے خیمے کھڑے کریں تاکہ بنی اِسرائیل کی جماعت پر غضب نازل نہ ہو۔ لیوی شہادت کے مَسکن کی حِفاظت کے ذمّہ دار ہوں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","چنانچہ بنی اِسرائیل نے وَیسا ہی کیا، جَیسا یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","یَاہوِہ نے مَوشہ اَور اَہرونؔ کو حُکم دیا: ");
INSERT INTO urdoucv_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","”بنی اِسرائیل خیمہ اِجتماع کے اِردگرد لیکن اُس سے کچھ فاصلہ پر اَپنے اَپنے پرچموں کے نیچے اَور اَپنے اَپنے آبائی خاندانوں کے پرچموں کے ساتھ اَپنی چھاؤنیاں قائِم کریں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","اَور مشرق کی جانِب جہاں سے آفتاب طُلوع ہوتاہے: یہُوداہؔ کی چھاؤنی کے دستے اَپنے جھنڈے کے نیچے اَپنے ڈیرے لگائیں اَور عَمّیندابؔ کا بیٹا نحشونؔ یہُوداہؔ کا سردار ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","اَور اُس کے دستے کے شُمار کَردہ مَردوں کی تعداد 74,600 ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","یِسَّکاؔر کا قبیلہ اُن کے مُتّصل خیمہ زن ہو اَور ضُعرؔ کا بیٹا نتنی ایل بنی یِسَّکاؔر کا سردار ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","اَور اُس کے دستوں کے شُمار کَردہ مَردوں کی تعداد 54,400 ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","زبُولُون کا قبیلہ اُن کے مُتّصل ہوگا اَور حیلونؔ کا بیٹا اِلیابؔ بنی زبُولُون کا سردار ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","اَور اُس کے دستے کے شُمار کئے ہویٔے مَردوں کی تعداد 57,400 ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","یہُوداہؔ کی چھاؤنی کے لیٔے نامزد کَردہ تمام مَردوں کی تعداد اُن کے اَپنے دستوں کے مُطابق 1,86,400 ہے۔ پہلے یہی کُوچ کریں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","جُنوب کی جانِب رُوبِنؔ کی چھاؤنی کے دستے اَپنے اَپنے جھنڈوں کے نیچے ہوں گے اَور شدِیُورؔ کا بیٹا اِلیضُورؔ بنی رُوبِنؔ کا سردار ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","اُس کے دستے کے شُمار کَردہ مَردوں کی تعداد 46,500 ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","شمعُونؔ کا قبیلہ اُن کے مُتّصل خیمہ زن ہوگا اَور ضُوریشدّؔی کا بیٹا سلُومی ایل بنی شمعُونؔ کا سردار ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","اُس کے دستے کے شُمار کَردہ مَردوں کی تعداد 59,300 ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","گادؔ کا قبیلہ اُن کے مُتّصل ہوگا اَور دعُوایلؔ کا بیٹا اِلیاسفؔ بنی گادؔ کا سردار ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","اُس کے دستے کے شُمار کَردہ مَردوں کی تعداد 45,650 ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","رُوبِنؔ کی چھاؤنی کے لیٔے نامزد کئے ہویٔے تمام مَردوں کی تعداد اُن کے اَپنے دستوں کے مُطابق 1,51,450 ہے۔ کُوچ کے وقت اِن کا دُوسرا مقام ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","تَب سَب چھاؤنیوں کے درمیان سے خیمہ اِجتماع اَور لیویوں کی چھاؤنی کے افراد کُوچ کریں گے اَور وہ اِسی ترتیب سے جَیسے کے اُن کے ڈیرے کھڑے ہوں گے اَپنی اَپنی جگہ پر اَور اَپنے اَپنے جھنڈے کے نیچے کُوچ کریں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","مغرب کی جانِب اِفرائیمؔ کی چھاؤنی کے دستے اَپنے اَپنے پرچم کے نیچے ہوں گے اَور عمّیہُوؔد کا بیٹا اِلیشمعؔ بنی اِفرائیمؔ کا سردار ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","اُس کے دستے کے شُمار کَردہ مَردوں کی تعداد 40,500 ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","منشّہ کا قبیلہ اُن کے مُتّصل ہوگا اَور پِداہضُورؔ کا بیٹا گَملی ایل بنی منشّہ کا سردار ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","اُس کے لشکر کے شُمار کَردہ مَردوں کی تعداد 32,200 ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","پھر بِنیامین کا قبیلہ ہوگا اَور ابیدانؔ بِن گِدعونیؔ بنی بِنیامین کا سردار ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","اُس کے دستے کے شُمار کَردہ مَردوں کی تعداد 35,400 ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","اِفرائیمؔ کی چھاؤنی کے لیٔے نامزد کئے ہویٔے تمام مَردوں کی تعداد اُن کے اَپنے دستوں کے مُطابق 1,08,100 ہے۔ کُوچ کے وقت اُن کا مقام تیسرا ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","شمال کی جانِب دانؔ کی چھاؤنی کے دستے اَپنے اَپنے پرچموں کے نیچے ہوں گے اَور احیعزر بِن عمّی شدّؔی بنی دانؔ کا سردار ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","اُس کے دستے کے شُمار کَردہ مَردوں کی تعداد 62,700 ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","آشیر کا قبیلہ اُن کے مُتّصل خیمہ زن ہوگا اَور عُکرانؔ کا بیٹا پگعِیلؔ بنی آشیر کا سردار ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","اُس کے دستے کے شُمار کَردہ مَردوں کی تعداد 41,500 ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","پھر نفتالی کا قبیلہ ہوگا اَور عینانؔ کا بیٹا اَخیرعؔ بنی نفتالی کا سردار ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","اُس کے دستوں کے شُمار کَردہ مَردوں کی تعداد 53,400 ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","دانؔ کی چھاؤنی کے لیٔے نامزد کَردہ تمام مَردوں کی تعداد 1,57,600 ہے۔ وہ اَپنے اَپنے پرچموں کے نیچے سَب سے پیچھے کُوچ کریں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","یہی وہ اِسرائیلی ہیں جو اَپنے اَپنے آبائی خاندانوں کے مُطابق شُمار کئے گیٔے۔ اَور چھاؤنیوں کے سَب لوگوں کی تعداد جو اَپنے اَپنے دستوں کے مُطابق شُمار کئے گیٔے 6,03,550 ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","البتّہ جَیسا یَاہوِہ نے مَوشہ کو حُکم دیا تھا اُس کے مُطابق لیوی دُوسرے اِسرائیلیوں کے ساتھ شُمار نہ کئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","چنانچہ جَیسا یَاہوِہ نے مَوشہ کو حُکم دیا تھا بنی اِسرائیل نے وَیسا ہی کیا اَور اِسی طریقہ سے وہ اَپنی اَپنی برادری والوں اَور خاندان کے ساتھ اَپنے اَپنے پرچموں کے نیچے قِیام کرتے اَور کُوچ کرتے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","جِس وقت یَاہوِہ نے کوہِ سِینؔائی پر مَوشہ سے باتیں کیں اُس وقت اَہرونؔ اَور مَوشہ کے خاندان کا نَسب نامہ یہ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","اَہرونؔ کے بیٹوں کے نام نادابؔ جو پہلوٹھا تھا اَبِیہُو الیعزرؔ اَور اِتمارؔ ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","اَہرونؔ کے اُن بیٹوں کے نام جو ممسوح کاہِنؔ تھے اَور کہانت کی خدمت کے لیٔے مُقرّر کئے گیٔے تھے یہی ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","البتّہ نادابؔ اَور اَبِیہُو یَاہوِہ کے حُضُور اُسی وقت مَر گیٔے تھے جَب اُنہُوں نے سِینؔائی کے بیابان میں اُن کے حُضُور ناجائز آگ کے ساتھ نذر گذرانی تھی۔ اُن کے کویٔی اَولاد نہ تھی اِس لیٔے صِرف الیعزرؔ اَور اِتمارؔ ہی اَپنے باپ اَہرونؔ کی زندگی میں کاہِنؔ کی خدمت اَنجام دیتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","پھر یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","”لیوی کے قبیلہ کو لاکر اَہرونؔ کاہِنؔ کے سامنے حاضِر کر تاکہ وہ اُس کی مدد کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","وہ خیمہ اِجتماع میں مُلاقات کے خیمہ کی نگہبانی کریں اَورجو فرائض اَہرونؔ اَور ساری جماعت کی طرف سے اُن پر عاید کام ہیں اُنہیں بجا لائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","وہ خیمہ اِجتماع کی تمام اشیائے آرائِش کی حِفاظت کریں اَور شہادت کے خیمہ میں خدمت اَنجام دیتے ہویٔے بنی اِسرائیل کے مَسکن کے فرائض کو پُورا کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","تُم لیویوں کو اَہرونؔ اَور اُس کے بیٹوں کے سُپرد کر دو۔ بنی اِسرائیل میں سے یہی لوگ اُن کی مدد کے لیٔے مُقرّر کئے گیٔے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","اَہرونؔ اَور اُس کے بیٹے ہی بطور کاہِنؔ کہانت کے لیٔے مُقرّر کئے جایٔیں۔ اگر کویٔی اَور شخص پاک مَقدِس کے قریب آئے تو وہ جان سے ماراجائے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","یَاہوِہ نے مَوشہ سے یہ بھی فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","”مَیں نے بنی اِسرائیل میں سے لیویوں کو ہر اِسرائیلی عورت کے پہلوٹھے کے عِوض لے لیا ہے۔ لہٰذا لیوی میرے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","کیونکہ سَب پہلوٹھے میرے ہیں۔ جَب مَیں نے مُلک مِصر میں سَب پہلوٹھوں کو مارا تھا تَب مَیں نے اِسرائیل کے ہر پہلوٹھے کو خواہ وہ اِنسان کا ہو یا حَیوان کا اَپنے لیٔے مخصُوص کر لیا تھا۔ وہ میرے ہیں۔ میں ہی یَاہوِہ ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","پھر یَاہوِہ نے سِینؔائی کے بیابان میں مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","”لیویوں کا اُن کے آبائی خاندانوں اَور برادری کے مُطابق شُمار کر۔ ایک ماہ یا اُس سے زِیادہ عمر کے ہر لڑکے کو شُمار کر۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","چنانچہ جَیسا یَاہوِہ نے اَپنے کلام کے ذریعہ حُکم دیا تھا مَوشہ نے اُس کے مُطابق اُن کا شُمار کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","لیوی کے بیٹوں کے نام یہ تھے: گیرشون، قُہات اَور مِراریؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","گیرشون کے گھرانوں کے نام یہ تھے: لِبنیؔ اَور شِمعیؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","قُہاتی کی برادری والے یہ ہیں: عمرامؔ، اِضہاؔر، حِبرونؔ اَور عُزّی ايل ");
INSERT INTO urdoucv_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","مِراریؔ کی برادری والے یہ ہیں: محلیؔ اَور مُوشیؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","لِبنیؔ اَور شِمعیؔ کی برادری کا گیرشون سے تعلّق تھا۔ یہ گیرشونیوں کی برادری والے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","اُن میں ایک ماہ یا اُس سے زِیادہ عمر کے لڑکوں کی تعداد جِن کا شُمار کیا گیا تھا 7,500 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","گیرشونیوں کی برادری والوں کو مُلاقات کے مَسکن کے پیچھے مغرب کی جانِب ڈیرے ڈالنے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","اَور لاایلؔ کا بیٹا اِلیاسفؔ گیرشونیوں کی برادری والوں کا سردار تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","اَور بنی گیرشون خیمہ اِجتماع میں اِن چیزوں کی دیکھ بھال کے ذمّہ دار تھے، مُلاقات کے خیمہ، اَور اُس کا غلاف، خیمہ اِجتماع کے دروازہ کا پردہ، ");
INSERT INTO urdoucv_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","مُلاقات کے مَسکن اَور مذبح کے گِرد کے صحن کے دروازہ کا پردہ اَور رسّیاں اَور اُن کے اِستعمال سے تعلّق رکھنے والے سارے کام بھی اُن کے ذمّہ تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","عمرامی، اِضہاری، حِبرونی اَور عُزّی ایلیوں کی برادری والے قُہات سے تعلّق رکھتے تھے۔ یہ نَسل قُہاتیوں کے خاندان تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","اِن میں ایک ماہ یا اُس سے زِیادہ عمر کے لڑکوں کی تعداد، جِن کا شُمار کیا گیا تھا 8,600 تھی۔ قُہاتی پاک مَقدِس کے مذبح کی دیکھ بھال کے ذمّہ دار تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","قُہاتی کی برادری والوں کو مُلاقات کے مَسکن کے جُنوب کی جانِب خیمہ زن ہونا تھا ");
INSERT INTO urdoucv_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","اَور عُزّی ايل کا بیٹا اِلیضفنؔ قُہاتی خاندان کی برادری اَور خاندان کا سردار تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","صندُوق، میز، چراغدان، مذبحوں، عبادت میں کام آنے والے پاک مَقدِس کے ظروف، پردہ اَور اُن کے لیٔے اِستعمال میں آنے والی ہر چیز کی دیکھ بھال اُن کے ذمّہ تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","اَور اَہرونؔ کاہِنؔ کا بیٹا الیعزرؔ لیویوں کا سردار اعلیٰ تھا۔ وہ اُن لوگوں کے اُوپر مُقرّر کیا گیا تھا جو پاک مَقدِس کی حِفاظت کے ذمّہ دار تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","محلیؔ اَور مُوشیؔ کی برادری والوں کا تعلّق مِراریؔ سے تھا۔ یہ مِراریؔ نَسل سے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","اُن میں ایک ماہ یا اُس سے زِیادہ عمر کے لڑکوں کی تعداد جِن کا شُمار کیا گیا تھا 6,200 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","اَور اَبی حائیل کا بیٹا ضُوری ایل، مِراریؔ کی برادری کے خاندان کا سردار تھا۔ اُنہیں مُلاقات کے مَسکن کے شمال کی جانِب خیمہ زن ہونا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","بنی مِراریؔ کو مُلاقات کے مَسکن کی چوکھٹوں، اُس کے بینڈوں، سُتونوں اَور خانوں، اُس کے تمام سازوسامان اَور اُن کے اِستعمال سے تعلّق رکھنے والی ہر چیز کی ذمّہ داری سونپی گئی ");
INSERT INTO urdoucv_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","اَور اِردگرد کے صحن کے سُتونوں اَور اُن کے خانوں، خیموں کی میخوں اَور رسّیوں کی دیکھ بھال کرنا بھی اُن کے ذمّہ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","مَوشہ اَور اَہرونؔ اَور اُس کے بیٹوں کو مُلاقات کے خیمہ کے مشرق کی جانِب جہاں سے آفتاب طُلوع ہوتاہے یعنی خیمہ اِجتماع کے سامنے خیمہ زن ہونا تھا۔ وہ بنی اِسرائیل کی خاطِر پاک مَقدِس کی حِفاظت کے ذمّہ دار تھے۔ اگر کویٔی اَور شخص پاک مَقدِس کے قریب جاتا تو وہ جان سے مار دیا جاتا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","مَوشہ اَور اَہرونؔ نے یَاہوِہ کے حُکم کے مُطابق ایک ماہ یا اُس سے زِیادہ عمر کے لڑکوں سمیت جتنے لیویوں کو اُن کے اَپنے اَپنے گھرانوں کے مُطابق شُمار کیا اُن کی تعداد 22,000 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","یَاہوِہ نے مَوشہ سے فرمایا، ”بنی اِسرائیل کے ایک ماہ یا اُس سے زِیادہ عمر کے تمام پہلوٹھے لڑکوں کا شُمار کر اَور اُن کے نام کی فہرست مُرتّب کر۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","اَور بنی اِسرائیل کے سَب پہلوٹھوں کے عِوض لیویوں کو، اَور بنی اِسرائیل کے مویشیوں کے سَب پہلوٹھوں کے عِوض لیویوں کے مویشیوں کو میرے لیٔے لے۔ میں ہی یَاہوِہ ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","چنانچہ مَوشہ نے یَاہوِہ کے حُکم کے مُطابق بنی اِسرائیل کے سَب پہلوٹھوں کا شُمار کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","اَور ایک ماہ یا اُس سے زِیادہ عمر کے نرینہ پہلوٹھوں کی تعداد اُن کے ناموں کی فہرست کے مُطابق 22,273 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","یَاہوِہ نے مَوشہ سے یہ بھی فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","”بنی اِسرائیل کے سَب پہلوٹھوں کے عِوض لیویوں کو اَور اُن کے مویشیوں کے عِوض لیویوں کے مویشیوں کو لیں اَور لیوی میرے ہُوں۔ میں ہی یَاہوِہ ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","اَور بنی اِسرائیل کے 273 پہلوٹھوں کے فدیہ کے لیٔے جو لیویوں کی تعداد سے زِیادہ ہیں ");
INSERT INTO urdoucv_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","پاک مَقدِس کے ثاقل کے حِساب سے جو وزن میں بیس گیراہ کے برابر ہوتاہے فی کس پانچ ثاقل لیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","اَور وہ رُوپیہ اُن زِیادہ اِسرائیلیوں کے فدیہ کے لیٔے اَہرونؔ اَور اُس کے بیٹوں کو دیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","چنانچہ مَوشہ نے اُن سے جو تعداد میں لیویوں کے چھُڑائے ہوؤں سے زِیادہ تھے فدیہ کا رُوپیہ لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","اَور بنی اِسرائیل کے پہلوٹھوں سے اُس نے پاک مَقدِس کے ثاقل کے حِساب سے 1,365 ثاقل چاندی وصول کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","اَور مَوشہ نے یَاہوِہ کے حُکم کے مُطابق فدیہ کی رقم اَہرونؔ اَور اُس کے بیٹوں کو دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","یَاہوِہ نے مَوشہ اَور اَہرونؔ سے فرمایا: ");
INSERT INTO urdoucv_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","”لیویوں کے خاندان میں سے قُہاتی طبقہ کی اُن کے گھرانوں اَور آبائی خاندانوں کے مُطابق مردُم شماری کرو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","تیس سے لے کر پچاس سال کی عمر کے سبھی مَردوں کو جو خیمہ اِجتماع کی خدمت میں ہاتھ بٹانے کے لیٔے آتے ہیں شُمار کرو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","”خیمہ اِجتماع میں بنی قُہات کا کام یہ ہوگا کہ وہ پاک ترین اَشیا کی حِفاظت کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","جَب لشکر کُوچ کرے تَب اَہرونؔ اَور اُس کے بیٹے اَندر جایٔیں اَور بیچ کے پردے کو اُتاریں اَور اُس سے عہد کے صندُوق کو ڈھانک دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","تَب وہ اُس پر دریائی بچھڑوں کی کھالوں کا غلاف چڑھائیں اَور اُس کے اُوپر بالکُل نیلے رنگ کا کپڑا بچھائیں اَور بَلّیاں اَپنی جگہ پر گاڑ دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","”پھر نذر کی روٹی کی میز پر نیلا کپڑا بچھا کر اُس پر طباق، ڈونگے، پیالے اَور تپاون کی نذروں کے مرتبان رکھیں اَور نذر کی روٹی بھی اُس پر لگاتار قائِم رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","اُن کے اُوپر وہ سُرخ رنگ کا کپڑا بچھائیں جسے دریائی بچھڑوں کی کھالوں سے ڈھانکیں اَور اُس کی بَلّیاں اَپنی جگہ پر گاڑ دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","”پھر وہ نیلے رنگ کا کپڑا لیں اَور اُس سے چراغدان کو جو رَوشنی کے لیٔے ہے اُس کے چراغوں، اُس کی بتّی کترنے کی قینچیوں اَور کشتیوں اَور اُس کے سَب مرتبانوں سمیت جِن میں زَیتُون کا تیل مہیا کیا جاتا ہے ڈھانک دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","تَب وہ اُسے اُس کے تمام سازوسامان کے ساتھ دریائی بچھڑوں کی کھالوں کے غلاف میں لپیٹیں اَور اُسے اُٹھانے والے چوکھٹے پر رکھ دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","”اَور زرّیں مذبح پر وہ نیلا کپڑا پھیلا دیں اَور اُسے دریائی بچھڑوں کی کھالوں سے ڈھانپ دیں اَور اُس کی بَلّیاں اَپنی اَپنی جگہ پر گاڑ دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","”تَب وہ اُن تمام برتنوں کو لے کرجو پاک مَقدِس کی خدمت میں کام آتے ہیں نیلے کپڑے میں لپیٹیں دریائی بچھڑوں کی کھالوں کے غلاف سے ڈھانکیں اَور چوکھٹے پر رکھ دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","”پھر وہ کانسے کے مذبح پر سے سَب راکھ اُٹھاکر اُس کے اُوپر اَرغوانی رنگ کا کپڑا بچھائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","پھر وہ اُس کے اُوپر وہ تمام برتن رکھیں جو مذبح پر خدمت کے لیٔے اِستعمال کئے جاتے ہیں جَیسے انگیٹھیاں، سیخیں، بیلچے اَور چھڑکاؤ کے پیالے۔ اُس کے اُوپر وہ دریائی بچھڑوں کی کھالوں کا غلاف بچھائیں اَور اُس کی بَلّیاں اَپنی جگہوں پر گاڑ دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","”جَب اَہرونؔ اَور اُس کے بیٹے آرائِش کے مُقدّس سازوسامان کو اَور تمام مُقدّس اَشیا کو ڈھانک چکیں اَور جَب چھاؤنی کُوچ کے لیٔے تیّار ہو تَب بنی قُہات اُٹھانے کے لیٔے آئیں۔ لیکن وہ مُقدّس اَشیا کو نہ چھُوئیں کہیں اَیسا نہ ہو کہ وہ مَر جایٔیں۔ بنی قُہات وُہی اَشیا اُٹھائیں جو خیمہ اِجتماع میں ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","”اَہرونؔ کاہِنؔ کا بیٹا الیعزرؔ رَوشنی کے تیل، خُوشبودار بخُور، دائمی نذر کی قُربانی اَور مَسح کرنے کے زَیتُون کے تیل کی حِفاظت کا نِگراں ہوگا۔ وہ سارے مَسکن اَور اُس کے اَندر کی آرائِش کے مُقدّس سازوسامان سمیت ہر چیز کا ذمّہ دار ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","پھر یَاہوِہ نے مَوشہ اَور اَہرونؔ سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","”خیال رہے کہ قُہاتیوں کے قبائلی خاندان لیویوں سے جُدا نہ ہونے پائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","تاکہ جَب وہ نہایت مُقدّس اَشیا کے قریب آئیں تو زندہ رہیں اَور مَر نہ جایٔیں۔ تُم اُن کی خاطِر اَیسا کرنا کہ اَہرونؔ اَور اُس کے بیٹے پاک مَقدِس کے اَندر جایٔیں اَور یہ طے کریں کہ اُن میں سے ہر ایک کیا کام کرے اَور کون سا بوجھ اُٹھائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","لیکن قوہاتی مُقدّس چیزوں کو دیکھنے کی خاطِر دَم بھرکے لیٔے بھی اَندر نہ آنے پائیں۔ کہیں اَیسا نہ ہو کہ وہ مَر جایٔیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","”بنی گیرشون کے آبائی خاندانون اَور اُن کے بھی گھرانوں کے مُطابق مردُم شماری کرو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","تیس سے لے کر پچاس سال کی عمر کے سبھی مَردوں کو جو خیمہ اِجتماع کی خدمت میں ہاتھ بٹانے کے لیٔے آتے ہیں شُمار کرو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","”کام کرنے اَور بوجھ اُٹھانے میں گیرشونیوں کے خاندان یہ خدمت بجا لائیں: ");
INSERT INTO urdoucv_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","وہ مَسکن کے پردے، خیمہ اِجتماع، اُس کے غلاف، دریائی بچھڑوں کی کھالوں کا اُوپری غلاف، خیمہ اِجتماع کے دروازہ کے پردے، ");
INSERT INTO urdoucv_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","مَسکن اَور مذبح کے اِردگرد صحن کے پردے، دروازہ کا پردہ اَور رسّیاں اَور وہ سَب آلات جو اُس کے کام میں اِستعمال ہوتے ہیں، اُٹھایا کریں۔ اَور اُن چیزوں کے ساتھ جو کچھ کیا جاتا ہے وہ سَب گیرشون ہی کیا کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","گیرشونیوں کی ساری خدمت خواہ وہ بوجھ اُٹھانا یا دیگر کام کرنا ہو اَہرونؔ اَور اُس کے بیٹوں کی ہدایات کے مُطابق اَنجام پایٔے۔ جو کچھ اُنہیں اُٹھانا ہے اُس کی ذمّہ داری تُم اُن کے سُپرد کر دو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","خیمہ اِجتماع میں گیرشونیوں کے گھرانوں کی یہی خدمت رہے گی اَور اُن کی خدمات اَہرونؔ کاہِنؔ کے بیٹے اِتمارؔ کی ہدایات کے مُطابق ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","”بنی مِراریؔ کو بھی اُن کے گھرانوں اَور آبائی خاندانوں کے مُطابق شُمار کر ");
INSERT INTO urdoucv_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","تیس سے لے کر پچاس سال کی عمر تک کے سبھی مَردوں کو جو خیمہ اِجتماع کی خدمت میں ہاتھ بٹانے کے لیٔے آتے ہیں شُمار کر۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","اَور خیمہ اِجتماع میں وہ یہ خدمت اَنجام دیں: مَسکن کے تختے، اُس کے بینڈے، سُتون اَور خانے ");
INSERT INTO urdoucv_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","اَور چاروں طرف کے صحن کے سُتون اَور اُن کے خانے، خیموں کی میخیں، رسّیاں، اُن کے تمام آلات اَور اُن کے اِستعمال میں آنے والی ہر چیز کو وہ اُٹھایا کریں۔ ہر شخص کو خاص خاص چیزیں اُٹھانے کی ذمّہ داری سونپی جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","بنی مِراریؔ کے خاندانوں کو خیمہ اِجتماع میں اَہرونؔ کاہِنؔ کے بیٹے اِتمارؔ کی زیرِ ہدایات جو خدمت اَنجام دینا ہے وہ یہی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","چنانچہ مَوشہ اَور اَہرونؔ اَور جماعت کے سرداروں نے قُہاتیوں کو اُن کے گھرانوں اَور آبائی خاندانوں کے مُطابق شُمار کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","تیس سے لے کر پچاس سال کی عمر کے سبھی مَردوں کو جو خیمہ اِجتماع کی خدمت میں ہاتھ بٹانے کے لیٔے آئےتھے ");
INSERT INTO urdoucv_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","جنہیں اُن کے گھرانوں کے مُطابق شُمار کیا گیا اُن کی تعداد 2,750 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","قُہاتی برادریوں کے جتنے لوگ خیمہ اِجتماع میں خدمت کرتے تھے اُن سَب کی تعداد یہی تھی جنہیں مَوشہ اَور اَہرونؔ نے یَاہوِہ کے مَوشہ کو دیئے ہویٔے حُکم کے مُطابق شُمار کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","بنی گیرشون کو اُن کے گھرانوں اَور آبائی خاندانوں کے مُطابق شُمار کیا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","تیس سے لے کر پچاس سال کی عمر تک کے سَب مَردوں کو جو خیمہ اِجتماع کی خدمت میں ہاتھ بٹانے کے لیٔے آئےتھے، ");
INSERT INTO urdoucv_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","اُنہیں اُن کے گھرانوں اَور آبائی خاندانوں کے مُطابق گِنا گیا اَور اُن کی تعداد 2,630 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","بنی گیرشون کے برادریوں کے جتنے لوگ خیمہ اِجتماع میں خدمت کرتے تھے اُن سَب کی تعداد اِتنی ہی تھی اَور یَاہوِہ کے حُکم کے مُطابق مَوشہ اَور اَہرونؔ نے اُنہیں شُمار کیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","بنی مِراریؔ کو اُن کے گھرانوں اَور خاندانوں کے مُطابق شُمار کیا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","تیس سے لے کر پچاس سال کی عمر تک کے سبھی مَردوں کو جو خیمہ اِجتماع کی خدمت میں ہاتھ بٹانے کے لیٔے آئےتھے، ");
INSERT INTO urdoucv_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","اُنہیں اُن کے گھرانوں کے مُطابق شُمار کیا گیا اَور اُن کی تعداد 3,200 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","بنی مِراریؔ کے گھرانوں کے لوگوں کی کُل تعداد یہی تھی جنہیں مَوشہ اَور اَہرونؔ نے یَاہوِہ کے مَوشہ کی مَعرفت دئیے ہویٔے حُکم کے مُطابق شُمار کیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","چنانچہ مَوشہ، اَہرونؔ اَور بنی اِسرائیل کے سرداروں نے سَب لیویوں کو اُن کے گھرانوں اَور خاندانوں کے مُطابق شُمار کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","اَور تیس سے لے کر پچاس سال کی عمر کے سبھی مَردوں کی تعداد جو خدمت کرنے اَور خیمہ اِجتماع کو اُٹھانے کا کام کرنے آئےتھے، ");
INSERT INTO urdoucv_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","اُن کی تعداد 8,580 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","یَاہوِہ کے حُکم کے مُطابق جو اُس نے مَوشہ کو دیا تھا ہر ایک کو اُس کا کام سونپا گیا اَور اُنہیں بتایا گیا کہ کون کیا کیا بوجھ اُٹھائے گا۔ چنانچہ اُسی حُکم کے مُطابق جو یَاہوِہ نے مَوشہ کو دیا تھا اُن کا شُمار کیا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","”بنی اِسرائیل کو حُکم دو کہ وہ ہر اُس شخص کو جسے جِلد کی کویٔی متعدّی بیماری ہو یا جریان کا مرض ہو یا جو کسی مُردہ کو چھُونے کے باعث ناپاک ہو چُکاہو، چھاؤنی سے خارج کر دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","خواہ وہ مَرد ہو یا عورت، اُنہیں چھاؤنی سے خارج کر دو تاکہ وہ اَپنی چھاؤنی کو ناپاک نہ کر دیں جہاں میں خُود اُن کے درمیان رہتا ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","بنی اِسرائیل نے اَیسا ہی کیا۔ اُنہُوں نے اُنہیں چھاؤنی سے خارج کر دیا۔ اُنہُوں نے ٹھیک وَیسا ہی کیا جَیسا یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","”بنی اِسرائیل سے کہو: ’اگر کویٔی مَرد یا عورت کسی شخص کے ساتھ کسی قِسم کی بدکاری کرے اَور اِس طرح سے یَاہوِہ سے دغا کرے تو وہ شخص مُجرم ٹھہرے گا، ");
INSERT INTO urdoucv_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","اَور اُس نے جو گُناہ کیا ہو وہ اُس کا اقرار کرے اَور کفّارہ کے طور پر اَپنی خطا کے پُورے مُعاوضہ میں اُس کا پانچواں حِصّہ اَور مِلا کر اُس شخص کو دے جِس کا اُس نے قُصُور کیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","لیکن اگر اُس شخص کا کویٔی قریبی رشتہ دار نہ ہو جسے اُس خطا کا مُعاوضہ دیا جائے تو وہ مُعاوضہ یَاہوِہ کا ہوگا، لہٰذا اُسے اَور کفّارہ کے مینڈھے کو کاہِنؔ کے سُپرد کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","بنی اِسرائیل جِتنی بھی مُقدّس نذریں کاہِنؔ کے پاس لائیں وہ سَب کاہِنؔ کی ہُوں گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ہر شخص کے مُقدّس نذرانے اُس کے اَپنے ہوں گے لیکن جو چیز وہ کاہِنؔ کو دے گا وہ کاہِنؔ کی ہوگی۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","پھر یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","”بنی اِسرائیل سے مُخاطِب ہو اَور اُن سے کہو: ’اگر کسی آدمی کی بیوی گُمراہ ہوکر اُس سے دغا کرے اَور ");
INSERT INTO urdoucv_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","کسی غَیر مَرد کے ساتھ ہم بِستر ہو، اَور یہ بات اُس کے خَاوند سے پوشیدہ رہے اَور اُس کی ناپاکی ظاہر بھی نہ ہونے پایٔے (کیونکہ اُس کے خِلاف کویٔی گواہ نہیں اَور نہ ہی وہ عَین فعل کے وقت پکڑی گئی ہے)، ");
INSERT INTO urdoucv_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","اَور اُس کے خَاوند کے دِل میں بدگُمانی پیدا ہو جائے کہ اُس کی بیوی ناپاک ہو چُکی ہے یا وہ بدظن ہوکر اَپنی بیوی کی پاک دامنی پر شک کرنے لگے حالانکہ وہ ناپاک نہ ہُوئی ہو ");
INSERT INTO urdoucv_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","تو وہ اَپنی بیوی کو کاہِنؔ کے سامنے حاضِر کرے، اَور اَپنے ساتھ ایفہ کا دسواں حِصّہ جَو کا آٹا اُس کی طرف سے نذرانے کے طور پر لے جائے۔ لیکن اُس پر تیل نہ ڈالے، نہ ہی لوبان رکھے کیونکہ یہ اناج کی قُربانی غیرت کی ہے یعنی یادگاری نذر کی قُربانی ہے جو بدی کو یاد دِلانے کے لیٔے ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","” ’تَب کاہِنؔ اُسے نزدیک لایٔے اَور اُسے یَاہوِہ کے حُضُور کھڑا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","اَور کاہِنؔ مٹّی کے برتن میں مُقدّس پانی لے اَور مَسکن کے فرش پر کی کچھ گَرد لے کر اُس پانی میں ڈال دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","جَب کاہِنؔ اُس عورت کو یَاہوِہ کے حُضُور میں کھڑا کر چُکے تو وہ اُس کے بال کھول دے، اَور اُس کے ہاتھوں میں یادگار کی قُربانی تھما دے جو غیرت کی اناج کی قُربانی ہے اَور خُود اَپنے ہاتھ میں اُس لعنت لانے والے کڑوے پانی کے برتن کو تھامے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","تَب کاہِنؔ عورت کو قَسم کھِلا کر اُس سے کہے، ”اگر کویٔی اَور آدمی تمہارے ساتھ ہم بِستر نہیں ہُواہے اَور تُو اَپنے خَاوند کی ہوتے ہویٔے گُمراہ ہوکر ناپاک نہیں ہُوئی تو یہ کڑوا پانی جو لعنت لاتا ہے تُمہیں ضرر نہ پہُنچائے ");
INSERT INTO urdoucv_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","لیکن اگر تُو اَپنے خَاوند کی ہوتے ہویٔے گُمراہ ہو چُکی ہے اَور اگر تُونے اَپنے خَاوند کے علاوہ کسی اَور شخص کے ساتھ ہم بِستر ہوکر اَپنے آپ کو ناپاک کر دیا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","یہاں کاہِنؔ اُس عورت کو اُس لعنت کی قَسم دِلائے تو، ”یَاہوِہ تمہاری ران کو سُکھا کر اَور تمہارے پیٹ کو پھُلا کر تمہاری قوم کے لوگوں سے تُجھ پر لعنت اَور ملامت کرائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","یہ پانی جو لعنت لاتا ہے تمہارے جِسم میں داخل ہو تاکہ تمہارا پیٹ پھُولے اَور تمہاری ران سڑائے۔“ ” ’تَب وہ عورت کہے، ”آمین! آمین۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","” ’تَب کاہِنؔ اُن لعنتوں کو ایک طُومار میں لِکھ کر اُنہیں اُس کڑوے پانی میں دھو ڈالے ");
INSERT INTO urdoucv_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","اَور وہ کڑوا پانی جو لعنت لاتا ہے اُس عورت کو پلائے اَور یہ پانی اُس میں داخل ہوگا اَور شدید کڑواہٹ پیدا کرےگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","پھر کاہِنؔ اُس کے ہاتھ میں سے غیرت کی اناج کی قُربانی کو لے کر اُسے یَاہوِہ کے حُضُور ہلائے اَور اُسے مذبح کے پاس لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","پھر کاہِنؔ اناج کی قُربانی میں سے یادگار کی قُربانی کے طور پر مُٹّھی بھر حِصّہ لے کر اُسے مذبح پر جَلائے۔ پھر وہ اُس عورت کو وہ پانی پلائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","اگر وہ ناپاک ہو چُکی ہو اَور اَپنے خَاوند سے دغا کر چُکی ہو تو جَب اُسے وہ پانی جو لعنت لاتا ہے پِلایا جائے گا وہ اُس کے پیٹ میں جا کر نہایت شدید کڑواہٹ پیدا کرےگا۔ اُس کا پیٹ پھُول جائے گا اَور اُس کی ران سڑ جائے گی اَور وہ اَپنی قوم میں لعنتی ٹھہرے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","البتّہ اگر اُس عورت نے اَپنے آپ کو ناپاک نہ کیا ہو بَلکہ پاک رہی ہو تو وہ بےگُناہ ٹھہرے گی اَور اُس سے اَولاد ہو سکے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","” ’غیرت کے بارے میں، یہی آئین ہے خواہ کویٔی عورت اَپنے خَاوند کی ہوتے ہویٔے گُمراہ ہوکر اَپنے آپ کو ناپاک کر لے، ");
INSERT INTO urdoucv_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","یا کسی آدمی کو اَپنی بیوی پر شک کرنے کی وجہ سے غیرت آئے تو کاہِنؔ اُسے یَاہوِہ کے حُضُور کھڑا کرے اَور اُس آئین پر پُوری طرح عَمل کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","خَاوند تو کسی بھی بدی سے بَری ٹھہرے گا البتّہ اُس عورت کو اَپنے گُناہ کا نتیجہ بھگتنا ہوگا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","”بنی اِسرائیل سے مُخاطِب ہو اَور اُن سے کہو: ’اگر کویٔی مَرد یا عورت نذیر کی مَنّت یعنی اَپنے آپ کو یَاہوِہ کے لیٔے الگ رکھنے کی خاص مَنّت مانے، ");
INSERT INTO urdoucv_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","تو وہ مَے اَور شراب سے دُور رہے اَور مَے یا شراب سے بنایا ہُوا سِرکہ نہ پیے۔ وہ انگور کا رس بھی نہ پیے اَور نہ تازہ انگور یا کشمش کھائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","جَب تک کہ وہ نذیر رہے تَب تک جو کچھ انگور کی بیل سے پیدا ہوتاہے، اُس میں سے کچھ بھی نہ کھائے، بیج اَور چھِلکے بھی نہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","” ’اُس کی نذارت کی مَنّت کی ساری میعاد کے دَوران اُس کے سَر پر اُسترا نہ پھیرا جائے اَور اُس کی یَاہوِہ کے لیٔے الگ رہنے کی مُدّت پُوری ہونے تک وہ پاک رہے اَور اَپنے سَر کے بالوں کو بڑھنے دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","” ’اَور یَاہوِہ اَپنی نذارت کی پُوری مُدّت تک وہ کسی لاش کے قریب نہ جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","خواہ اُس کا اَپنا باپ یا ماں یا بھایٔی یا بہن بھی مَر جائے تو بھی وہ اُن کو چھُو کر اَپنے آپ کو نجِس نہ کر لے کیونکہ اَپنے یَاہوِہ کے لیٔے الگ رہنے کی علامت اُس کے سَر پر ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","وہ اَپنی نذارت کی پُوری مُدّت تک یَاہوِہ کے لیٔے پاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","” ’اگر کویٔی اَچانک اُس کی مَوجُودگی میں مَر جائے جِس سے کہ اُس کے نذر کئے ہویٔے بال ناپاک ہو جایٔیں تو وہ اَپنے پاک ہونے کے دِن یعنی ساتویں دِن اَپنا سَر مُنڈائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","اَور آٹھویں دِن وہ دو قُمریاں یا کبُوتر کے دو بچّے خیمہ اِجتماع کے دروازہ پر کاہِنؔ کے پاس لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","اَور کاہِنؔ ایک کو گُناہ کی قُربانی اَور دُوسرے کو سوختنی نذر کے طور پر گذرانے اَور اُس کی خاطِر کفّارہ دے کیونکہ وہ لاش کے پاس مَوجُود رہ کر ناپاک ہو گیا اَور اُسی دِن وہ اُس کے سَر کو پاک کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","وہ اَپنے الگ رہنے کی مُدّت تک اَپنے آپ کو یَاہوِہ کے لیٔے نذر کرے اَور ایک سال بھر کا نر برّہ خطا کی قُربانی کے لیٔے لایٔے۔ لیکن گزرے ہویٔے دِن گنے نہیں جایٔیں گے کیونکہ وہ اَپنی نذارت کے ایّام میں ناپاک ہو گیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","” ’پھر جَب اُس کی نذرات کی میعاد پُوری ہو جائے تو نذیر کے لیٔے آئین یہ ہے: اُسے خیمہ اِجتماع کے دروازہ پر حاضِر کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","وہاں وہ یَاہوِہ کے لیٔے یہ قُربانیاں پیش کرے: سوختنی نذر کے لیٔے ایک بے عیب یک سالہ نر برّہ گُناہ کی قُربانی کے لیٔے ایک بے عیب یک سالہ مادہ برّہ اَور سلامتی کی نذر کے لیٔے ایک بے عیب مینڈھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","اَور ساتھ ہی ساتھ اناج کی نذریں اَور تپاون کی نذروں اَور بے خمیری روٹیوں کی ایک ٹوکری بھی لایٔے جِس میں زَیتُون کا تیل ملے ہویٔے مَیدے کے کُلچے اَور تیل سے چُپڑی ہُوئی بے خمیری ٹکیاں ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","” ’کاہِنؔ اُنہیں یَاہوِہ کے حُضُور پیش کرے اَور اُنہیں گُناہ کی قُربانی اَور سوختنی نذر کے طور پر پیش کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","کاہِنؔ بے خمیری روٹیوں کی ٹوکری کے ساتھ اُس مینڈھے کو یَاہوِہ کے حُضُور سلامتی کی نذر کی قُربانی کے طور پر گذرانے اَور اُن کی اناج کی قُربانی اَور اُن کے تپاون بھی لایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","” ’تَب خیمہ اِجتماع کے دروازہ پر نذیر اَپنے نذارت کے بال مُنڈوائے۔ پھر وہ اُن بالوں کو لے کر سلامتی کی نذر کی قُربانی کے نیچے والی آگ میں ڈال دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","” ’جَب نذیر اَپنی نذارت کے بال مُنڈوا چُکے تَب کاہِنؔ مینڈھے کا اُبالا ہُوا شانہ اَور اُس ٹوکری میں کا ایک کُلچہ اَور ایک ٹکیا جو دونوں بے خمیر کے بنائے گیٔے ہُوں اُس کے ہاتھوں میں دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","اَور کاہِنؔ اُنہیں ہلانے کی نذر کی قُربانی کے طور پر یَاہوِہ کے حُضُور ہلائے۔ وہ مُقدّس ہیں اَور ہلائے ہویٔے سینہ اَور پیش کی ہُوئی ران سمیت کاہِنؔ کے ہیں۔ اُس کے بعد نذیر مَے پی سَکتا ہے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","” ’نذیر اَپنی نذارت کے مُطابق یَاہوِہ کے لیٔے جِس چڑھاوے کی مَنّت مانے علاوہ اُس کے جِس کا اُسے مقدور ہو اُن سَب کے متعلّق یہی آئین ہے۔ اُس نے جو مَنّت مانی ہو اُسے نذارت کی آئین کے مُطابق پُورا کیا جائے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","”اَہرونؔ اَور اُس کے بیٹوں سے کہو، ’تُم بنی اِسرائیل کو اِس طرح برکت دو۔ تُم اُن سے کہو: ");
INSERT INTO urdoucv_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","” ’یَاہوِہ تُمہیں برکت دیں اَور تُمہیں محفوظ رکھے؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","یَاہوِہ اَپنا چہرہ تُجھ پر جلوہ گِر فرمائیں اَور تُجھ پر مہربان ہُوں؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","یَاہوِہ اَپنا چہرہ اُٹھائیں اَور تمہاری طرف متوجّہ ہُوں اَور تُمہیں سلامتی بخشیں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","”اِس طرح وہ میرے نام کو بنی اِسرائیل پر رکھیں اَور مَیں اُنہیں برکت بخشوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","جَب مَوشہ مَسکن کو کھڑا کر چُکا تو اُس نے اُسے مَسح کیا اَور اُسے اَور اُس کے سارے سازوسامان کو مُقدّس کیا۔ اُس نے مذبح اَور اُس کے تمام ظروف کو بھی مَسح اَور مُقدّس کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","تَب اِسرائیل کے سردار جو شُمار کئے ہوؤں کے اُوپر مُقرّر کئے ہویٔے اَپنے اَپنے خاندانوں کے سربراہ اَور قبیلوں کے نِگراں تھے نذرانے لے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","اَور وہ اَپنے نذرانوں کے طور پر چھ ڈھکی ہُوئی گاڑیاں اَور بَارہ بَیل یَاہوِہ کے پاس لایٔے یعنی ہر سردار کی طرف سے ایک ایک بَیل اَور دو دو سرداروں کی طرف سے ایک ایک گاڑی۔ اُنہیں اُنہُوں نے مَسکن کے سامنے پیش کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","”تُو اُنہیں قبُول کر تاکہ وہ خیمہ اِجتماع کے لیٔے اِستعمال ہُوں اَور تُو اُنہیں لیویوں میں ہر شخص کی خدمت کے مُطابق بانٹ دے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","چنانچہ مَوشہ نے وہ گاڑیاں اَور بَیل لے کر لیویوں کو دے دئیے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","گیرشون کے گھرانوں کو اُس نے اُن کی خدمت کے مُطابق دو گاڑیاں اَور چار بَیل دئیے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","اَور بنی مِراریؔ کو اُن کی خدمت کے مُطابق چار گاڑیاں اَور آٹھ بَیل دئیے۔ یہ سَب اَہرونؔ کاہِنؔ کے بیٹے اِتمارؔ کی قیادت میں تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","لیکن مَوشہ نے بنی قُہات کو کچھ نہ دیا کیونکہ وہ مُقدّس چیزوں کو اَپنے کندھوں پر اُٹھانے کے ذمّہ دار تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","پھر جَب مذبح کا مَسح کیا گیا تَب سارے سردار اُس کی تقدیس کے لیٔے اَپنے اَپنے نذرانے لایٔے اَور اُنہیں مذبح کے سامنے پیش کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","کیونکہ یَاہوِہ نے مَوشہ سے کہاتھا، ”ہر روز ایک ہی سردار مذبح کی تقدیس کے لیٔے اَپنا نذرانہ لایٔے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","لہٰذا جو شخص پہلے دِن اَپنا ہدیہ لایا وہ یہُوداہؔ کے قبیلہ کا نحشونؔ بِن عَمّیندابؔ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","اُس کا ہدیہ یہ تھا: ایک سَو تیس ثاقل وزن کا چاندی کا ایک طباق اَور ستّر ثاقل وزن کا چاندی کا چھڑکنے کا ایک پیالہ۔ اِن دونوں کا وزن پاک مَقدِس کے ثاقل کے پیمانہ کے مُطابق تھا اَور ہر ایک میں اناج کی قُربانی کے لیٔے تیل مِلا ہُوا مَیدہ بھرا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","دس ثاقل وزن کا سونے کا ایک ظرف جو لوبان سے بھرا ہُوا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","سوختنی نذر کے لیٔے ایک بچھڑا، ایک مینڈھا اَور ایک یک سالہ نر برّہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","گُناہ کی قُربانی کے لیٔے ایک بکرا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","اَور سلامتی کی نذر کی قُربانی کے طور پر پیش کرنے کے لیٔے دو بَیل، پانچ نر مینڈھے، پانچ بکرے اَور پانچ یک سالہ نر برّے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","دُوسرے دِن یِسَّکاؔر کے قبیلہ کا سردار نتنی ایل بِن ضُعرؔ اَپنا ہدیہ لایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","اَور اُس کا ہدیہ یہ تھا: ایک سَو تیس ثاقل وزن کا چاندی کا ایک طباق اَور ستّر ثاقل وزن کا چاندی کا چھڑکنے کا ایک پیالہ۔ اِن دونوں کا وزن پاک مَقدِس کے ثاقل کے پیمانہ کے مُطابق تھا اَور ہر ایک میں اناج کی قُربانی کے لیٔے تیل مِلا ہُوا مَیدہ بھرا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","دس ثاقل وزن کا سونے کا ایک ظرف جو لوبان سے بھرا ہُوا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","سوختنی نذر کے لیٔے ایک بچھڑا، ایک مینڈھا اَور ایک یک سالہ نر برّہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","گُناہ کی قُربانی کے لیٔے ایک بکرا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","اَور سلامتی کی نذر کی قُربانی کے طور پر پیش کرنے کے لیٔے دو بَیل، پانچ نر مینڈھے، پانچ بکرے اَور پانچ یک سالہ نر برّے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","تیسرے دِن اِلیابؔ بِن حیلونؔ نے جو زبُولُون کے قبیلہ کا سردار تھا اَپنا ہدیہ گذرانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","اُس کا ہدیہ یہ تھا: ایک سَو تیس ثاقل وزن کا چاندی کا ایک طباق اَور ستّر ثاقل وزن کا چاندی کا چھڑکنے کا ایک پیالہ۔ اِن دونوں کا وزن پاک مَقدِس کے ثاقل کے پیمانہ کے مُطابق تھا اَور ہر ایک میں اناج کی قُربانی کے لیٔے تیل مِلا ہُوا مَیدہ بھرا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","دس ثاقل وزن کا سونے کا ایک ظرف جو لوبان سے بھرا ہُوا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","سوختنی نذر کے لیٔے ایک بچھڑا، ایک مینڈھا، اَور ایک یک سالہ نر برّہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","گُناہ کی قُربانی کے لیٔے ایک بکرا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","سلامتی کی نذر کی قُربانی کے طور پر پیش کرنے کے لیٔے دو بَیل، پانچ نر مینڈھے، پانچ بکرے اَور پانچ یک سالہ نر برّے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","چوتھے دِن رُوبِنؔ کے قبیلہ کے سردار اِلیضُورؔ بِن شدِیُورؔ نے اَپنا ہدیہ پیش کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","اُس کا ہدیہ یہ تھا: ایک سَو تیس ثاقل وزن کا چاندی کا ایک طباق اَور ستّر ثاقل وزن کا چاندی کا چھڑکنے کا ایک پیالہ۔ اِن دونوں کا وزن پاک مَقدِس کے ثاقل کے پیمانہ کے مُطابق تھا اَور ہر ایک میں اناج کی قُربانی کے لیٔے تیل مِلا ہُوا مَیدہ بھرا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","دس ثاقل وزن کا سونے کا ایک ظرف جو لوبان سے بھرا ہُوا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","سوختنی نذر کے لیٔے ایک بچھڑا، ایک مینڈھا، اَور ایک یک سالہ نر برّہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","گُناہ کی قُربانی کے لیٔے ایک بکرا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","اَور سلامتی کی نذر کی قُربانی کے طور پر پیش کرنے کے لیٔے دو بَیل، پانچ نر مینڈھے، پانچ بکرے اَور پانچ یک سالہ نر برّے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","پانچویں دِن شمعُونؔ کے قبیلہ کے سردار سلُومی ایل بِن ضُوریشدّؔی نے اَپنا ہدیہ پیش کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","اُس کا ہدیہ یہ تھا: ایک سَو تیس ثاقل وزن کا چاندی کا ایک طباق اَور ستّر ثاقل وزن کا چاندی کا چھڑکنے کا ایک پیالہ۔ اِن دونوں کا وزن مَقدِس کے ثاقل کے پیمانہ کے مُطابق تھا اَور ہر ایک میں اناج کی قُربانی کے لیٔے تیل مِلا ہُوا مَیدہ بھرا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","دس ثاقل وزن کا سونے کا ایک ظرف جو لوبان سے بھرا ہُوا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","سوختنی نذر کے لیٔے ایک بچھڑا، ایک مینڈھا، اَور ایک یک سالہ نر برّہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","گُناہ کی قُربانی کے لیٔے ایک بکرا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","اَور سلامتی کی نذر کی قُربانی کے طور پر گذراننے کے لیٔے دو بَیل، پانچ نر مینڈھے، پانچ بکرے اَور پانچ یک سالہ نر برّے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","چھٹے دِن اِلیاسفؔ بِن دعُوایلؔ نے اَپنا ہدیہ پیش کیا جو گادؔ کے قبیلہ کا سردار تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","اُس کا ہدیہ یہ تھا: ایک سَو تیس ثاقل وزن کا چاندی کا ایک طباق اَور ستّر ثاقل وزن کا چاندی کا چھڑکنے کا ایک پیالہ۔ اِن دونوں کا وزن پاک مَقدِس کے ثاقل کے پیمانہ کے مُطابق تھا اَور ہر ایک میں اناج کی قُربانی کے لیٔے تیل مِلا ہُوا مَیدہ بھرا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","دس ثاقل وزن کا سونے کا ایک ظرف جو لوبان سے بھرا ہُوا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","سوختنی نذر کے لیٔے ایک بچھڑا، ایک مینڈھا، اَور ایک یک سالہ نر برّہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","گُناہ کی قُربانی کے لیٔے ایک بکرا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","اَور سلامتی کی نذر کی قُربانی کے طور پر پیش کرنے کے لیٔے دو بَیل، پانچ نر مینڈھے، پانچ بکرے اَور پانچ یک سالہ نر برّے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ساتویں دِن اِلیشمعؔ بِن عمّیہُوؔد نے اَپنا ہدیہ پیش کیا جو اِفرائیمؔ کے قبیلہ کا سردار تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","اُس کا ہدیہ یہ تھا: ایک سَو تیس ثاقل وزن کا چاندی کا ایک طباق اَور ستّر ثاقل وزن کا چاندی کا چھڑکنے کا ایک پیالہ۔ اِن دونوں کا وزن پاک مَقدِس کے ثاقل کے پیمانہ کے مُطابق تھا اَور ہر ایک میں اناج کی قُربانی کے لیٔے تیل مِلا ہُوا مَیدہ بھرا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","دس ثاقل وزن کا سونے کا ایک ظرف جو لوبان سے بھرا ہُوا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","سوختنی نذر کے لیٔے ایک بچھڑا، ایک مینڈھا، اَور ایک یک سالہ نر برّہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","گُناہ کی قُربانی کے لیٔے ایک بکرا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","اَور سلامتی کی نذر کی قُربانی کے طور پر گذراننے کے لیٔے دو بَیل، پانچ نر مینڈھے، پانچ بکرے اَور پانچ یک سالہ نر برّے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","آٹھویں دِن گَملی ایل بِن پِداہضُورؔ نے اَپنا ہدیہ پیش کیا جو منشّہ کے قبیلہ کا سردار تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","اُس کا ہدیہ یہ تھا: ایک سَو تیس ثاقل وزن کا چاندی کا ایک طباق اَور ستّر ثاقل وزن کا چاندی کا چھڑکنے کا ایک پیالہ۔ اِن دونوں کا وزن پاک مَقدِس کے ثاقل کے پیمانہ کے مُطابق تھا اَور ہر ایک میں اناج کی قُربانی کے لیٔے تیل مِلا ہُوا مَیدہ بھرا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","دس ثاقل وزن کا سونے کا ایک ظرف جو لوبان سے بھرا ہُوا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","سوختنی نذر کے لیٔے ایک بچھڑا، ایک مینڈھا، اَور ایک یک سالہ نر برّہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","گُناہ کی قُربانی کے لیٔے ایک بکرا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","اَور سلامتی کی نذر کی قُربانی کے طور پر پیش کرنے کے لیٔے دو بَیل، پانچ نر مینڈھے، پانچ بکرے اَور پانچ یک سالہ نر برّے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","نویں دِن بِنیامین کے قبیلہ کے سردار ابیدانؔ بِن گِدعونیؔ نے اَپنا ہدیہ پیش کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","اُس کا ہدیہ یہ تھا: ایک سَو تیس ثاقل وزن کا چاندی کا ایک طباق اَور ستّر ثاقل وزن کا چاندی کا چھڑکنے کا ایک پیالہ۔ اِن دونوں کا وزن پاک مَقدِس کے ثاقل کے پیمانہ کے مُطابق تھا اَور ہر ایک میں اناج کی قُربانی کے لیٔے تیل مِلا ہُوا مَیدہ بھرا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","دس ثاقل وزن کا سونے کا ایک ظرف جو لوبان سے بھرا ہُوا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","سوختنی نذر کے لیٔے ایک بچھڑا، ایک مینڈھا، اَور ایک یک سالہ نر برّہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","گُناہ کی قُربانی کے لیٔے ایک بکرا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","اَور سلامتی کی نذر کی قُربانی کے طور پر پیش کرنے کے لیٔے دو بَیل، پانچ نر مینڈھے، پانچ بکرے اَور پانچ یک سالہ نر برّے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","دسویں دِن دانؔ کے قبیلہ کا سردار احیعزر بِن عمّی شدّؔی اَپنا ہدیہ لایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","اُس کا ہدیہ یہ تھا: ایک سَو تیس ثاقل وزن کا چاندی کا ایک طباق اَور ستّر ثاقل وزن کا چاندی کا چھڑکنے کا ایک پیالہ۔ اِن دونوں کا وزن پاک مَقدِس کے ثاقل کے پیمانہ کے مُطابق تھا اَور ہر ایک میں اناج کی قُربانی کے لیٔے تیل مِلا ہُوا مَیدہ بھرا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","دس ثاقل وزن کا سونے کا ایک ظرف جو لوبان سے بھرا ہُوا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","سوختنی نذر کے لیٔے ایک بچھڑا، ایک مینڈھا، اَور ایک یک سالہ نر برّہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","گُناہ کی قُربانی کے لیٔے ایک بکرا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","اَور سلامتی کی نذر کی قُربانی کے طور پر گذراننے کے لیٔے دو بَیل، پانچ نر مینڈھے، پانچ بکرے اَور پانچ یک سالہ نر برّے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","گیارھویں دِن آشیر کے قبیلہ کا سردار پگعِیلؔ بِن عُکرانؔ اَپنا ہدیہ لایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","اُس کا ہدیہ یہ تھا: ایک سَو تیس ثاقل وزن کا چاندی کا ایک طباق اَور ستّر ثاقل وزن کا چاندی کا چھڑکنے کا ایک پیالہ۔ اِن دونوں کا وزن پاک مَقدِس کے ثاقل کے پیمانہ کے مُطابق تھا اَور ہر ایک میں اناج کی قُربانی کے لیٔے تیل مِلا ہُوا مَیدہ بھرا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","دس ثاقل وزن کا سونے کا ایک ظرف جو لوبان سے بھرا ہُوا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","سوختنی نذر کے لیٔے ایک بچھڑا، ایک مینڈھا، اَور ایک یک سالہ نر برّہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","گُناہ کی قُربانی کے لیٔے ایک بکرا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","اَور سلامتی کی نذر کی قُربانی کے طور پر پیش کرنے کے لیٔے دو بَیل، پانچ نر مینڈھے، پانچ بکرے اَور پانچ یک سالہ نر برّے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","بارہویں دِن اَخیرعؔ بِن عینانؔ نے جو نفتالی کے قبیلہ کا سردار تھا اَپنا ہدیہ پیش کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","اُس کا ہدیہ یہ تھا: ایک سَو تیس ثاقل وزن کا چاندی کا ایک طباق اَور ستّر ثاقل وزن کا چاندی کا چھڑکنے کا ایک پیالہ۔ اِن دونوں کا وزن پاک مَقدِس کے ثاقل کے پیمانہ کے مُطابق تھا اَور ہر ایک میں اناج کی قُربانی کے لیٔے تیل مِلا ہُوا مَیدہ بھرا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","دس ثاقل وزن کا سونے کا ایک ظرف جو لوبان سے بھرا ہُوا تھا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","سوختنی نذر کے لیٔے ایک بچھڑا، ایک مینڈھا، اَور ایک یک سالہ نر برّہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","گُناہ کی قُربانی کے لیٔے ایک بکرا؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","اَور سلامتی کی نذر کی قُربانی کے طور پر پیش کرنے کے لیٔے دو بَیل، پانچ نر مینڈھے، پانچ بکرے اَور پانچ یک سالہ نر برّے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","مذبح کے ممسوح ہونے کے وقت اُس کی تقدیس کے لیٔے بنی اِسرائیل کے سرداروں کے لایٔے ہویٔے عطیات یہی تھے۔ یعنی چاندی کے بَارہ طباق، چاندی کے چھڑکنے کے بَارہ پیالے اَور سونے کے بَارہ ظروف۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ہر چاندی کے طباق کا وزن ایک سَو تیس ثاقل تھا اَور ہر چھڑکنے کا پیالہ ستّر ثاقل کا تھا۔ مجموعی طور پر اُن چاندی کے ظروف کا وزن پاک مَقدِس کے ثاقل کے پیمانہ کے مُطابق دو ہزار چار سَو ثاقل تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","لوبان سے بھرے ہویٔے سونے کے بَارہ ظروف پاک مَقدِس کے ثاقل کے پیمانہ کے مُطابق دس دس ثاقل کے تھے۔ مجموعی طور پر اُن سونے کے ظروف کا وزن ایک سَو بیس ثاقل تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","سوختنی نذر کے لیٔے لایٔے ہویٔے جانوروں کی مجموعی تعداد اَپنی اَپنی اناج کی قُربانیوں سمیت یہ تھی: بَارہ بچھڑے، بَارہ مینڈھے، بَارہ یک سالہ نر برّے اَور گُناہ کی قُربانی کے لیٔے بَارہ بکرے اِستعمال کئے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","سلامتی کی نذر کی قُربانی کے طور پر پیش کرنے کے لیٔے جانوروں کی کُل تعداد یہ تھی: چوبیس بَیل، ساٹھ مینڈھے، ساٹھ بکرے، اَور ساٹھ یک سالہ نر برّے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","جَب مَوشہ یَاہوِہ سے باتیں کرنے کے لیٔے خیمہ اِجتماع میں داخل ہُوا تو اُس نے کفّارہ کے سرپوش پر سے جو عہد کے صندُوق کے اُوپر رکھا ہُوا تھا دونوں کروبیوں کے درمیان سے وہ آواز سُنی جو اُس سے مُخاطِب تھی اَور یَاہوِہ نے مَوشہ کے ساتھ باتیں کیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","”اَہرونؔ سے مُخاطِب ہو اَور اُس سے کہہ، ’جَب تُو سات چراغوں کو رَوشن کرے تو دیکھنا کہ اُن سے چراغدان کے سامنے کا احاطہ رَوشن ہو۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","چنانچہ اَہرونؔ نے اَیسا ہی کیا۔ اُس نے چراغوں کو اِس طرح جما دیا کہ اُن کے رُخ چراغدان کے سامنے کی طرف تھے جَیسا کہ یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","اَور چراغدان کی ساخت یُوں تھی: وہ اَپنے پیندے سے لے کر پھُولوں تک گڑھے ہویٔے سونے کا بنا تھا اَور چراغدان ٹھیک اُسی نمونہ کا بنا تھا جَیسا یَاہوِہ نے مَوشہ کو بتایا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","”لیویوں کو دُوسرے تمام بنی اِسرائیل سے الگ کرکے اُنہیں رسماً پاک کر۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","اُنہیں پاک کرنے کے لیٔے تُم یُوں کرنا: اُن پر پاک کرنے کا پانی چھڑک، پھر وہ اَپنے سارے جِسم پر اُسترا پھروائیں اَور اَپنے کپڑے دھوئیں اَور اِس طرح اَپنے آپ کو پاک کر لیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","تَب وہ ایک بچھڑا اَور اُس کے ساتھ کی اناج کی قُربانی کے لیٔے تیل مِلا ہُوا مَیدہ لیں اَور تُو گُناہ کی قُربانی کے لیٔے ایک دُوسرا بچھڑا لینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","تَب لیویوں کو خیمہ اِجتماع کے سامنے حاضِر کرنا اَور بنی اِسرائیل کی ساری جماعت کو جمع کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","تُم لیویوں کو یَاہوِہ کے حُضُور لانا، تَب بنی اِسرائیل اُن پر اَپنے ہاتھ رکھیں ");
INSERT INTO urdoucv_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","اَور اَہرونؔ لیویوں کو یَاہوِہ کے حُضُور بنی اِسرائیل کی طرف سے ہلانے کی نذر کی قُربانی کے طور پر پیش کرے تاکہ وہ یَاہوِہ کی خدمت کرنے کے لیٔے تیّار ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","”جَب لیوی اَپنے اَپنے ہاتھ بچھڑوں کے سَروں پر رکھ چکیں، تَب تُم ایک کو یَاہوِہ کے لیٔے گُناہ کی قُربانی کے طور پر اَور دُوسرے کو سوختنی نذر کے طور پر پیش کرنا تاکہ لیویوں کا کفّارہ دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","پھر تُم لیویوں کو اَہرونؔ اَور اُس کے بیٹوں کے آگے کھڑا کرنا اَور تَب اُن کو یَاہوِہ کے رُوبرو ہلانے کی نذر کی قُربانی کے طور پر پیش کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","اِس طرح سے تُم لیویوں کو دُوسرے بنی اِسرائیل سے الگ کرنا اَور لیوی میرے ہوں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","”جَب تُم لیویوں کو پاک کر چُکو اَور ہلانے کی نذر کی قُربانی کے طور پر پیش کر چُکو تَب وہ خیمہ اِجتماع میں اَپنی خدمت بجا لانے کے لیٔے آئیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","یہ وہ بنی اِسرائیل ہیں جو مُکمّل طور پر مُجھے سونپے جایٔیں۔ مَیں نے اُنہیں پہلوٹھے کے یعنی ہر اِسرائیلی عورت کے پہلے بیٹے کے عِوض اَپنا لیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","بنی اِسرائیل کا ہر پہلوٹھا خواہ اِنسان کا ہو یا حَیوان کا میرا ہے۔ جَب مَیں نے مُلک مِصر میں سَب پہلوٹھوں کو مار ڈالا تھا، اُسی وقت مَیں نے اُنہیں اَپنے لیٔے مخصُوص کر لیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","اَور مَیں نے بنی اِسرائیل کے سَب پہلوٹھوں کے عِوض لیویوں کو لے لیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","تمام بنی اِسرائیل میں سے مَیں نے لیویوں کو اَہرونؔ اَور اُس کے بیٹوں کو بنی اِسرائیل کی جانِب سے اِس لیٔے عطا کیا ہے کہ وہ خیمہ اِجتماع میں بنی اِسرائیل میں خدمت کریں اَور اُن کے لیٔے کفّارہ دیں تاکہ جَب بنی اِسرائیل پاک مَقدِس کے قریب جایٔیں تو اُن پر کویٔی وَبا نازل نہ ہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","چنانچہ مَوشہ، اَہرونؔ اَور بنی اِسرائیل کی ساری جماعت نے لیویوں کے ساتھ ٹھیک وَیسا ہی کیا جَیسا یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","لیویوں نے اَپنے آپ کو پاک کیا اَور اَپنے کپڑے دھو ڈالے۔ تَب اَہرونؔ نے اُنہیں یَاہوِہ کے رُوبرو ہلانے کی نذر کی قُربانی کے طور پر پیش کیا اَور اُنہیں پاک کرنے کے لیٔے اُن کی خاطِر کفّارہ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","اُس کے بعد لیوی اَہرونؔ اَور اُس کے بیٹوں کی قیادت میں خیمہ اِجتماع میں اَپنی خدمت بجا لانے کے لیٔے چلے آئے۔ اُنہُوں نے لیویوں کے ساتھ ٹھیک وَیسا ہی کیا جَیسا یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","پھر یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","”لیویوں پر لازِم ہوگا: پچّیس سال یا اُس سے زِیادہ عمر کے مَرد خیمہ اِجتماع میں خدمت کرنے آیا کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","لیکن پچاس سال کی عمر ہونے پر وہ اَپنی روزمرّہ کی خدمت سے مستعفی ہُوں اَور پھر کام نہ کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","وہ اگر چاہیں تو خیمہ اِجتماع کی خدمت میں اَپنے بھائیوں کا ہاتھ بٹائیں لیکن بذاتِ خُود کویٔی کام نہ کریں۔ تُم لیویوں کو اِسی قِسم کی ذمّہ داریاں سونپنا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","اُن کے مُلک مِصر سے نکل آنے کے دُوسرے سال کے پہلے مہینے میں یَاہوِہ سِینؔائی کے بیابان میں مَوشہ سے مُخاطِب ہُوا۔ اُنہُوں نے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","”بنی اِسرائیل مُقرّرہ وقت پر عیدِفسح منائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","اِسی ماہ کی چودھویں تاریخ کی شام کے وقت تُم اُسے مُقرّرہ وقت پر اُس ضوابط کے مُطابق منانا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","چنانچہ مَوشہ نے بنی اِسرائیل کو عیدِفسح منانے کے لیٔے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","اَور اُنہُوں نے پہلے مہینے کی چودھویں تاریخ کی شام کو سِینؔائی کے بیابان میں عیدِفسح منایا اَور بنی اِسرائیل نے وَیسا ہی کیا جَیسا یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","لیکن کچھ لوگ اُس روز عیدِفسح نہ منا سکے کیونکہ اُن میں سے کچھ لوگ اَیسے بھی تھے جو کسی لاش کو چھُونے کے سبب سے ناپاک ہو گئے تھے۔ چنانچہ وہ اُسی دِن مَوشہ اَور اَہرونؔ کے پاس آئے ");
INSERT INTO urdoucv_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","اَور مَوشہ سے کہنے لگے، ”ہم تو کسی لاش کو چھُونے کے سبب سے ناپاک ہو چُکے ہیں پھر ہم لوگ دُوسرے اِسرائیلیوں کے ساتھ مُقرّرہ وقت پر یَاہوِہ کی قُربانی پیش کرنے سے کیوں محروم رکھے جایٔیں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","مَوشہ نے اُنہیں جَواب دیا، ”جَب تک میں پتا نہ لگاؤں کہ یَاہوِہ تمہارے حق میں کیا حُکم دیتے ہیں تُم ٹھہرے رہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","تَب یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","”بنی اِسرائیل سے کہہ، ’تُم میں سے یا تمہاری نَسل میں سے جو لوگ کسی لاش کو چھُونے کی وجہ سے ناپاک ہو چُکے ہُوں یا کہیں دُور سفر میں ہُوں تو بھی وہ یَاہوِہ کے لیٔے عیدِفسح منائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","وہ اُسے دُوسرے مہینے کے چودھویں دِن کی شام کو منائیں اَور فسح کے گوشت کو بے خمیری روٹی اَور کڑوے ساگ پات کے ساتھ کھایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","اَور اُس میں سے کچھ بھی صُبح تک باقی نہ چھوڑا جائے، اُن کی کوئی بھی ہڈّی نہ توڑی جائے۔ اَور جَب وہ عیدِفسح منائیں تو اُس کی تمام شَریعت پر عَمل کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","لیکن جو شخص رسماً پاک ہو اَور سفر میں بھی نہ ہو اگر وہ عیدِفسح نہ منائے تو وہ اَپنی قوم میں سے کاٹ ڈالا جائے کیونکہ اُس نے مُقرّرہ وقت پر یَاہوِہ کی قُربانی پیش نہیں کی۔ اُس آدمی کا گُناہ اُسی کے سَر لگے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","” ’اگر کویٔی مُلک اِسرائیل کا باشِندہ ہو یا غَیراِسرائیلی جو تمہارے ساتھ بُودوباش کرتا ہو یَاہوِہ کے لیٔے فسح کرنا چاہے تو وہ اُسے اُس کے ضوابط کے مُطابق مانے۔ تُم مُلک اِسرائیل کے باشِندے اَور غَیراِسرائیلی باشِندے دونوں کے لیٔے ایک ہی ضوابط رکھنا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","جِس دِن پاک مَسکن یعنی عہد کا خیمہ نصب ہُوا، اُس دِن اُس پر بادل چھا گیا اَور شام سے لے کر صُبح تک وہ بادل پاک مَسکن کے اُوپر آگ کی مانند نظر آتا رہا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","اَور ہمیشہ اَیسا ہی ہوتا تھا، خیمہ پر بادل چھایا رہتا تھا اَور رات کو وہ آگ کی مانند نظر آتا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","اَور جَب وہ بادل خیمے کے اُوپر سے چھٹ جاتا تھا تو بنی اِسرائیل کُوچ کرتے تھے اَور جہاں وہ بادل جا کر ٹھہر جاتا تھا وہاں اِسرائیلی قِیام کرتے تھے اَور جَب تک وہ بادل ٹھہرا رہتا تھا اِسرائیلی بھی وہاں ڈیرے ڈالے رہتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","بنی اِسرائیل یَاہوِہ کے حُکم سے کُوچ کرتے اَور اُسی کے حُکم سے وہ ڈیرے بھی ڈالتے تھے، اَور جَب تک بادل مَسکن پر ٹھہرا رہے وہ چھاؤنی میں رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","جَب بادل کافی عرصہ تک مَسکن پر ٹھہرا رہتا تھا تو بنی اِسرائیل یَاہوِہ کے حُکم کے مُطابق کُوچ نہ کرتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","بعض اوقات وہ بادل چند ہی دِنوں تک مَسکن پر رہتا تھا اَور تَب بھی وہ یَاہوِہ کے حُکم سے ڈیرے ڈالے پڑے رہتے اَور جَب وہ حُکم دیتا تو وہ کُوچ کرتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","کبھی تو وہ بادل شام سے لے کر صُبح تک ہی ٹھہرا رہتا تھا اَور جَب وہ صُبح کو اُٹھ جاتا تھا تو وہ کُوچ کرتے تھے۔ لہٰذا دِن ہو یا رات جَب بھی وہ بادل اُٹھ جاتا تھا وہ روانہ ہو جاتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","چاہے بادل مَسکن پر دو دِن مہینے بھر یا پُورے سال ٹھہرا رہتا بنی اِسرائیل بھی چھاؤنی میں ٹھہرے رہتے اَور کُوچ نہ کرتے تھے۔ لیکن جَب وہ اُٹھ جاتا تو وہ بھی چل پڑتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","یَاہوِہ کے حُکم سے وہ خیمہ زن ہوتے اَور یَاہوِہ ہی کے حُکم سے وہ کُوچ کرتے۔ یُوں وہ یَاہوِہ کے حُکم کو بجا لاتے تھے جو اُنہیں مَوشہ کی مَعرفت دیا گیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","”گڑھی ہُوئی چاندی کے دو نرسنگے بنا لے اَور اُنہیں جماعت کو جمع کرنے اَور چھاؤنی کے کُوچ کرنے کے لیٔے کام میں لانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","اَور جَب دونوں نرسنگے پھُونکے جایٔیں تَب ساری جماعت خیمہ اِجتماع کے دروازہ پر تمہارے سامنے جمع ہو جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","لیکن اگر ایک نرسنگا ہی پھُونکا جائے تو صِرف وہ لوگ جو بنی اِسرائیل کے برادریوں کے رئیس یعنی سربراہ ہیں تمہارے سامنے اِکٹھّے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","جَب سانس باندھ کر زور سے نرسنگا پھُونکا جائے تو جو قبیلے مشرق کی جانِب مُقیم ہیں وہ کُوچ کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","جَب دوبارہ سانس باندھ کر زور سے نرسنگا پھُونکا جائے تو جُنوب کی جانِب والی چھاؤنیوں کو کُوچ کریں۔ لہٰذا سانس باندھ کر زور سے نرسنگا پھُونکا جانا کُوچ کا اِشارہ ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","جماعت کو جمع کرنے کے لیٔے بھی نرسنگے پھُونکے جایٔیں لیکن اُن کی آوازوں کو زِیادہ طُول دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","”اَہرونؔ کاہِنؔ کے بیٹے نرسنگے پھُونکیں۔ یہ فرمان تمہارے اَور تمہاری آئندہ پُشتوں کے لیٔے دائمی فرمان قائِم رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","جَب تُم اَپنے ہی مُلک میں کسی اَیسے دُشمن سے لڑنے کے لیٔے نکلو جو تُم پر ظُلم ڈھاتا ہے تَب سانس باندھ کر زور سے نرسنگے پھُونکنا۔ تَب تُم یَاہوِہ اَپنے خُدا کے حُضُور یاد کئے جاؤگے اَور اَپنے دُشمنوں سے رِہائی پاؤگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","اَور اَپنی خُوشی کے موقعوں جَیسے اَپنی مُقرّرہ عیدوں اَور نئے چاند کے جَشن اَور اَپنی سوختنی نذروں اَور سلامتی کی نذر کی قُربانیوں کے موقعوں پر تُم نرسنگے پھُونکو اَور وہ تمہارے خُدا کے حُضُور میں تمہاری یادگارہو جانے کا باعث ہوں گے۔ مَیں یَاہوِہ تمہارا خُدا ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","دُوسرے سال کے دُوسرے ماہ کے بیسویں دِن وہ بادل شہادت کے مَسکن پر سے اُٹھ گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","تَب بنی اِسرائیل نے سِینؔائی کے بیابان سے کُوچ کیا اَور جابجا سفر کرتے رہے یہاں تک کہ وہ بادل پارانؔ کے بیابان میں جا کر ٹھہرگیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","چنانچہ اُنہُوں نے مَوشہ کی مَعرفت دئیے ہویٔے یَاہوِہ کے حُکم کے مُطابق پہلا کُوچ کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","پہلے یہُوداہؔ کی چھاؤنی کے دستے اَپنے جھنڈے اُونچے کرکے روانہ ہویٔے اَور عَمّیندابؔ کا بیٹا نحشونؔ اُن کی قیادت کر رہاتھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ضُعرؔ کا بیٹا نتنی ایل یِسَّکاؔر کے قبیلہ کے دستوں کی قیادت کر رہاتھا ");
INSERT INTO urdoucv_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","اَور حیلونؔ کا بیٹا اِلیابؔ زبُولُون کے قبیلہ کے دستوں کی قیادت کر رہاتھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","تَب مَسکن اُتارا گیا اَور بنی گیرشون اَور بنی مِراریؔ نے جو اُسے اُٹھائے ہویٔے تھے کُوچ کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","پھر رُوبِنؔ کی چھاؤنی کے دستے اَپنے جھنڈے اُونچے کرکے روانہ ہویٔے اَور شدِیُورؔ کا بیٹا اِلیضُورؔ اُن کی قیادت کر رہاتھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ضُوریشدّؔی کا بیٹا سلُومی ایل شمعُونؔ کے قبیلہ کے دستوں کی قیادت کر رہاتھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","اَور دعُوایلؔ کا بیٹا اِلیاسفؔ، گادؔ کے قبیلہ کے دستوں کی قیادت کر رہاتھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","تَب قُہاتیوں نے مُقدّس چیزیں اُٹھائے ہویٔے کُوچ کیا۔ اُن کے پہُنچنے سے پہلے ضروُری تھا کہ مَسکن کھڑا کر دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","پھر اِفرائیمؔ کے قبیلہ کے دستے اَپنے جھنڈے اُونچے کرکے روانہ ہویٔے۔ عمّیہُوؔد کا بیٹا اِلیشمعؔ اُن کی قیادت کر رہاتھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","پِداہضُورؔ کا بیٹا گَملی ایل منشّہ کے قبیلہ کے دستوں کی قیادت کر رہاتھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","اَور ابیدانؔ بِن گِدعونیؔ بِنیامین کے قبیلہ کے دستوں کی قیادت کر رہاتھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","اَور آخِر میں دانؔ کی چھاؤنی کے دستے اَپنے جھنڈے کے ساتھ سارے دستوں کے پیچھے روانہ ہویٔے۔ احیعزر بِن عمّی شدّؔی اُن کی قیادت کر رہاتھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","عُکرانؔ کا بیٹا پگعِیلؔ آشیر کے قبیلہ کے دستوں کی قیادت کر رہاتھا، ");
INSERT INTO urdoucv_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","اَور عینانؔ کا بیٹا اَخیرعؔ نفتالی کے قبیلہ کے دستوں کی قیادت کر رہاتھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","چنانچہ جَب اِسرائیلی دستے کُوچ کرتے تھے تو اِسی ترتیب کے مُطابق آگے روانہ ہوتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","مَوشہ نے اَپنے سسُر رِعوایلؔ مِدیانی کے بیٹے حوبابؔ سے کہا، ”ہم اُس مقام کی طرف کُوچ کر رہے ہیں جِس کے متعلّق یَاہوِہ نے فرمایاہے، ’میں اُسے تُمہیں دُوں گا!‘ لہٰذا تُو بھی ہمارے ساتھ چل اَور ہم تمہارے ساتھ نیک سلُوک کریں گے کیونکہ یَاہوِہ نے بنی اِسرائیل سے نیکی کا وعدہ کیا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","اُس نے جَواب دیا، ”نہیں میں نہیں چلتا۔ میں تو اَپنے مُلک اَور اَپنے لوگوں میں لَوٹ جاؤں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","لیکن مَوشہ نے کہا، ”مہربانی سے ہمیں چھوڑکر نہ جاؤ کیونکہ تُم ہی بتا سکتے ہو کہ بیابان میں ہم کہاں قِیام کریں: اَور تُم ہمارے لیٔے آنکھوں کا کام دے سکتے ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","اگر تُم ہمارے ساتھ چلوگے تو ہر نیکی میں جو یَاہوِہ ہمارے ساتھ کریں گے تُم بھی برابر کے حِصّہ دار ہوگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","چنانچہ وہ یَاہوِہ کے پہاڑ سے چل پڑے اَور تین دِن تک سفر کرتے رہے اَور اُن تین دِنوں میں یَاہوِہ کے عہد کا صندُوق اُن کے قِیام کرنے کے لیٔے جگہ تلاش کرتا ہُوا اُن کے آگے آگے چلتا رہا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","اَور جَب وہ اَپنی چھاؤنی سے کُوچ کرتے تو یَاہوِہ کا بادل اُن کے اُوپر دِن بھر سایہ کئے رہتا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","جَب صندُوق کُوچ کرتا تھا تو مَوشہ کہتا تھا، ”اَے یَاہوِہ اُٹھیں! آپ کے دُشمن پراگندہ ہو جایٔیں؛ اَور آپ کے حریف آپ کے سامنے سے بھاگ جایٔیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","اَور جَب کبھی وہ ٹھہر جاتا تھا تو وہ کہتا تھا، ”اَے یَاہوِہ، ہزاروں ہزار اِسرائیلیوں میں لَوٹ کر آ جائیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","پھر لوگ یَاہوِہ سے اَپنی تکالیف کی شکایت کرنے لگے اَور جَب اُنہُوں نے اُنہیں سُنا تو اُن کا غضب بھڑک اُٹھا۔ تَب یَاہوِہ کی آتِش اُن کے درمیان بھڑکی جِس سے اُن کی چھاؤنی کے چاروں طرف کے علاقے بھسم ہونے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","تَب لوگوں نے مَوشہ سے آہ و زاری کی اَور اُس نے یَاہوِہ سے دعا کی اَور وہ آگ بُجھ گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","اِس لیٔے اُس جگہ کا نام تبعیرہؔ پڑا کیونکہ یَاہوِہ کی آگ اُن کے درمیان جَل اُٹھی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","بنی اِسرائیل میں شامل ہونے والے جمع لوگ کھانے کی دُوسری چیزوں کی خواہش کرنے لگے، اَور بنی اِسرائیل بھی آہ و زاری کرنے لگے، ”کاش کہ ہمیں کھانے کو گوشت مِل سَکتا! ");
INSERT INTO urdoucv_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ہمیں اُس مچھلی کی جسے ہم مِصر میں مُفت کھاتے تھے اَور اُن کھیروں، خربوزوں، گندنوں، ہری پیاز اَور لہسن کی بھی یاد آتی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","لیکن اَب ہماری بھُوک مَر چُکی ہے؛ اَور ہم اِس منّا کے علاوہ اَور کچھ دیکھ ہی نہیں پاتے!“ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","منّا دھنیے کی مانند تھا اَور وہ دال کی طرح دِکھائی دیتا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","لوگ اِدھر اُدھر جا کر اُسے جمع کرتے اَور اُسے چکّی میں پیستے یا اوکھلی میں کُوٹ لیتے تھے۔ پھر اُسے کسی برتن میں پکاتے تھے یا اُس کے پھُلکے بناتے تھے اَور اُس کا مزہ زَیتُون کے تیل کا سا ہوتا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","رات کو جَب چھاؤنی پر اوس پڑتی تھی تَب منّا بھی گِرتا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","مَوشہ نے ہر خاندان کے افراد کو اَپنے اَپنے خیمہ کے دروازہ پر واویلا کرتے ہویٔے سُنا۔ یَاہوِہ نہایت غضبناک ہُوئے اَور مَوشہ بھی پریشان ہو گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","مَوشہ نے یَاہوِہ سے پُوچھا، ”آپ اَپنے خادِم پر یہ مُصیبت کیوں لائے؟ آخِر مَیں نے اَیسا کون سا کام کیا تھا آپ کی نظرِکرم مُجھ پر سے اُٹھی جِس سے آپ ناراض ہُوئے اَور اِن سَب لوگوں کا بوجھ مُجھ پر ڈال دیا؟ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","کیا یہ سَب لوگ میرے پیٹ میں پڑے تھے؟ کیا یہ مُجھ ہی سے پیدا ہویٔے؟ پھر آپ مُجھے کیوں کہتے ہیں ’میں ایک دایہ کی مانند جو کسی نَوزائیدہ بچّے کو لیٔے پھرتی ہے اُنہیں اَپنی گود میں اُٹھاکر‘ اُس مُلک میں لے جاؤں جِس کے دینے کی قَسم آپ نے اُن کے آباؤاَجداد سے کھائی ہے؟ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","میں اِن سَب کے لیٔے گوشت کہاں سے لاؤں؟ وہ یہ کہہ کر میرے سامنے گڑگڑاتے ہیں، ’ہمیں گوشت کھانے کو دیں!‘ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","میں اکیلا اِن سَب کو کیسے سنبھالوں؟ یہ بوجھ میری طاقت سے باہر ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","اگر آپ میرے ساتھ اَیسا ہی سلُوک کرتے ہیں تو براہِ کرم مجھ سے ابھی میری جان لے لیں۔ اگر مَیں نے آپ سے نظرِکرم پائی ہے تو میں اَپنی تباہی سے دوچار نہ ہونے پاؤں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","یَاہوِہ نے مَوشہ سے فرمایا: ”بنی اِسرائیل کے بُزرگوں میں سے ستّر اَیسے لوگوں کو میرے حُضُور میں جمع کر جنہیں تُو جانتا ہے کہ وہ قوم کے سردار اَور منصبدار ہیں اَور اُنہیں خیمہ اِجتماع کے پاس لے آنا کہ وہ تمہارے ساتھ وہاں کھڑے ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","تَب مَیں نیچے اُتر آؤں گا اَور تُجھ سے وہاں باتیں کروں گا اَور مَیں اُس رُوح میں سے جو تُجھ پر ہے کچھ لے کر اُس رُوح کو اُن پر ڈال دُوں گا۔ وہ لوگوں کا بوجھ اُٹھانے میں تمہاری مدد کریں گے تاکہ تُمہیں اکیلے بوجھ اُٹھانا نہ پڑے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","”لوگوں سے کہو، ’کل گوشت کھانے کے لیٔے اَپنے آپ کو پاک کر لو۔ جَب تُم یہ کہہ کر آہ و زاری کر رہے تھے، ”کاش ہمیں گوشت کھانے کو ملتا! ہم مِصر ہی میں اَچھّے تھے!“ یَاہوِہ نے تمہاری فریاد سُن لی ہے۔ لہٰذا وہ تُمہیں گوشت دیں گے اَور تُم اُسے کھاؤگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","تُم صِرف ایک یا دو دِن یا پانچ، دس یا بیس دِن ہی نہیں، ");
INSERT INTO urdoucv_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","بَلکہ پُورے ایک ماہ تک اُسے کھاتے رہوگے یہاں تک کہ وہ تمہارے نتھنوں سے نکلنے لگے گا اَور تُمہیں اُس سے گھن آنے لگے گی کیونکہ تُم نے یَاہوِہ کو جو تمہارے درمیان ہے ترک کر دیا اَور اُن کے سامنے یہ کہہ کر آہ و زاری کی، ”ہم مِصر سے کیوں نکل آئے؟“ ‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","لیکن مَوشہ نے کہا، ”سَب لوگ جو میرے ساتھ ہیں اِن میں چھ لاکھ تو پیادے ہی ہیں اَور آپ کہتے ہیں، ’میں اِنہیں اِتنا گوشت دُوں گا کہ وہ مہینے بھر اُسے کھاتے رہیں گے!‘ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","اگر بھیڑ بکریوں کے گلّے اَور مویشیوں کے ریوڑ بھی اُن کے لیٔے ذبح کئے جایٔیں تو کیا اُن کے لیٔے بس ہوں گے؟ اَور اگر سمُندر کی ساری مچھلیاں لائی جایٔیں تو کیا وہ اُن کے لیٔے کافی ہُوں گی؟“ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","یَاہوِہ نے مَوشہ کو جَواب دیا، ”کیا یَاہوِہ کا ہاتھ اِس قدر چھوٹا ہو گیا ہے؟ اَب تُو دیکھ لے گا کہ میرا قول پُورا ہوتاہے یا نہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","تَب مَوشہ نے باہر جا کر لوگوں کو یَاہوِہ کی باتیں کہہ سُنائیں۔ اُس نے اُن میں سے ستّر سربراہ بُزرگوں کو جمع کیا اَور اُنہیں خیمہ کے اِردگرد کھڑا کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","تَب یَاہوِہ بادل میں ہوکر اُترے اَور اُنہُوں نے مَوشہ سے باتیں کیں اَور اُس رُوح میں سے جو مَوشہ پر تھا کچھ لے کر اُسے اُن ستّر سردار بُزرگوں پر ڈال دیا۔ اَور جَب وہ رُوح اُن پر اُترا تَب اُنہُوں نے نبُوّت کی لیکن بعد میں پھر کبھی نہ کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","البتّہ دو شخص جِن کے نام اِلدادؔ اَور میدادؔ تھے چھاؤنی میں رہ گیٔے تھے۔ اُن کے نام بُزرگوں کی فہرست میں درج تھے لیکن وہ خیمہ کے پاس نہیں آئےتھے۔ پھر بھی اُن پر رُوح اُتر آیا اَور وہ چھاؤنی میں نبُوّت کرنے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ایک نوجوان دَوڑتا ہُوا مَوشہ کے پاس گیا اَور کہا، ”اِلدادؔ اَور میدادؔ چھاؤنی میں نبُوّت کر رہے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","تَب یہوشُعؔ بِن نُونؔ نے، جو اَپنی جَوانی ہی سے مَوشہ کا مُعاوِن رہ چُکاتھا کہا، ”اَے میرے آقا مَوشہ! اُنہیں روک دیں!“ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","لیکن مَوشہ نے جَواب دیا، ”کیا تُمہیں میری خاطِر رشک آتا ہے؟ کاش کہ یَاہوِہ کے سَب لوگ نبی ہوتے اَور یَاہوِہ اَپنی رُوح اُن سَب پر ڈالتے!“ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","تَب مَوشہ اَور بنی اِسرائیل کے بُزرگ چھاؤنی میں لَوٹ آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","پھر یَاہوِہ کی طرف سے ایک آندھی چلی اَور سمُندر سے بٹیریں اُڑا لائی اَور اُنہیں چھاؤنی کے چاروں طرف زمین پر ڈال دیا۔ اَور اُن کی کثرت کا یہ حال تھا کہ ایک دِن کی مَسافت تک ہر طرف اُن کی دو دو ہاتھ اُونچی تہہ لگی ہُوئی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","پُورے دِن اَور پُوری رات اَور دُوسرے دِن بھی لوگوں نے باہر جا کر بٹیریں جمع کیں اَور کسی نے بھی دس حُومر سے کم نہ بٹوریں اَور اُنہیں چھاؤنی کے چاروں طرف پھیلا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","لیکن گوشت ابھی اُن کے دانتوں کے درمیان ہی تھا اَور وہ اُسے نگل بھی نہ پایٔے تھے کہ یَاہوِہ کا قہر اُن پر بھڑکا اَور وہ ایک نہایت شدید وَبا کے باعث مار ڈالے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","اِس لیٔے اُس جگہ کا نام قِبروتؔ ہتّاوہؔ رکھا گیا کیونکہ وہ لوگ جنہوں نے کسی دُوسری قِسم کی غِذا کی حِرص کی تھی وہاں دفن کئے گیٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","تَب وہ لوگ قِبروتؔ ہتّاوہؔ سے سفر کرکے حَضِیروتؔ کو گیٔے اَور وہاں خیمہ زن ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","مِریمؔ اَور اَہرونؔ مَوشہ کی کُوشی بیوی کے سبب سے اُس کی بُرائی کرنے لگے کیونکہ اُس نے ایک کُوشی عورت سے بیاہ کر لیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","اُنہُوں نے کہا، ”کیا یَاہوِہ نے محض مَوشہ ہی سے باتیں کی ہیں؟ کیا اُنہُوں نے ہم سے بھی باتیں نہیں کیں؟“ اَور یَاہوِہ نے اُن کی یہ باتیں سُن لیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(مَوشہ نہایت حلیم شخص تھا بَلکہ وہ رُوئے زمین کے ہر شخص سے زِیادہ حلیم تھا۔) ");
INSERT INTO urdoucv_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","یَاہوِہ نے فوراً مَوشہ، اَہرونؔ اَور مِریمؔ سے کہا، ”تُم تینوں نکل کر خیمہ اِجتماع کے پاس حاضِر ہو جاؤ۔“ چنانچہ وہ تینوں باہر نکل آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","تَب یَاہوِہ بادل کے ایک سُتون میں ہوکر اُتر آئے اَور خیمہ کے دروازہ پر کھڑے ہوکر اَہرونؔ اَور مِریمؔ کو بُلایا۔ جَب وہ دونوں آگے بڑھے ");
INSERT INTO urdoucv_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","تَب یَاہوِہ نے فرمایا، ”میری باتیں سُنو: ”جَب تمہارے درمیان یَاہوِہ کا کویٔی نبی برپا ہوتاہے، تو میں اَپنے آپ کو، اُس پر رُویا میں ظاہر کرتا ہُوں، اَور خواب میں اُس سے باتیں کرتا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","لیکن میرے خادِم مَوشہ کے حق میں اَیسا نہیں ہے؛ وہ میرے سارے خاندان میں قابلِ اِعتماد ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","اُس سے میں مُعمّوں میں نہیں بَلکہ کھُلے طور پر اَور رُوبرو باتیں کرتا ہُوں، اُسے یَاہوِہ کا دیدار بھی نصیب ہوتاہے۔ پھر تُمہیں میرے خادِم مَوشہ کی بُرائی کرتے ہویٔے خوف کیوں نہ آیا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","اَور یَاہوِہ کا غضب اُن پر بھڑکا اَور وہ اُنہیں چھوڑکر چلےگئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","جَب خیمہ کے اُوپر سے بادل اُٹھ گیا تو مِریمؔ وہاں کھڑی تھی اَور وہ کوڑھ سے برف کی مانند سفید ہو چُکی تھی۔ اَہرونؔ نے مُڑ کر اُس کی طرف دیکھا تو پتا چلا کہ اُسے کوڑھ کا مرض لاحق ہو گیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","اَور اَہرونؔ نے مَوشہ سے فرمایا، ”اَے میرے آقا براہِ کرم اِس گُناہ کو جو ہم سے نادانی میں سرزد ہُوا اُسے ہمارے خِلاف نہ ٹھہرائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","اَور مِریمؔ کو اُس مَرے ہویٔے بچّہ کی مانند نہ رہنے دیں جِس کا جِسم اَپنی ماں کے پیٹ سے نکلنے پر ہی ادھ گلا ہوتاہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","تَب مَوشہ نے یہ کہہ کر یَاہوِہ سے مِنّت کی، ”اَے خُدا! براہِ کرم آپ اُسے شفا دیں!“ ");
INSERT INTO urdoucv_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","یَاہوِہ نے مَوشہ کو جَواب دیا، ”اگر اِس کے باپ نے اِس کے مُنہ پر صِرف تھُوکا ہی ہوتا تو کیا وہ سات دِن تک پشیمان نہ رہتی؟ لہٰذا سات دِن تک اُسے چھاؤنی کے باہر بند رہنے دیں۔ اُس کے بعد وہ اَندر لائی جا سکتی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","چنانچہ مِریمؔ سات دِن تک چھاؤنی کے باہر بند رہی اَور اُس کے اَندر آنے تک لوگوں نے کُوچ نہیں کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","اُس کے بعد وہ لوگ حَضِیروتؔ سے روانہ ہویٔے اَور پارانؔ کے بیابان میں جا کر خیمہ زن ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","”چند آدمیوں کو روانہ کر کہ وہ مُلکِ کنعانؔ کا جسے میں بنی اِسرائیل کو دے رہا ہُوں جائزہ لیں۔ تُم ہر آبائی قبیلہ کے سرداروں میں سے ایک ایک شخص کو بھیجنا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","چنانچہ مَوشہ نے یَاہوِہ کے حُکم کے مُطابق پارانؔ کے بیابان سے اُنہیں روانہ کیا۔ وہ سَب اِسرائیلی سردار تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","اُن کے نام یہ ہیں: رُوبِنؔ کے قبیلہ سے، زکُورؔ کا بیٹا شَمّوعؔ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","شمعُونؔ کے قبیلہ سے حَوریؔ کا بیٹا شافاطؔ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","یہُوداہؔ کے قبیلہ سے یفُنّہؔ کا بیٹا کالبؔ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","یِسَّکاؔر کے قبیلہ سے یُوسیفؔ کا بیٹا اِگالؔ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","اِفرائیمؔ کے قبیلہ سے نُونؔ کا بیٹا ہوشِیعؔ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","بِنیامین کے قبیلہ سے رفُوؔ کا بیٹا پَلطیؔ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","زبُولُون کے قبیلہ سے سودیؔ کا بیٹا گدّی ایل؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","منشّہ کے قبیلہ سے (جو یُوسیفؔ کا قبیلہ تھا) سُوسیؔ کا بیٹا گدّی؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","دانؔ کے قبیلہ سے گمّلیؔ کا بیٹا عمّی ایل؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","آشیر کے قبیلہ سے مِیکاایلؔ کا بیٹا سَتُورؔ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","نفتالی کے قبیلہ سے وُفسیؔ کا بیٹا نَحّبِی؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","گادؔ کے قبیلہ سے ماکیؔ کا بیٹا گیُوایلؔ۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","یہ اُن لوگوں کے نام ہیں جنہیں مَوشہ نے اُس مُلک کا جائزہ لینے کے لیٔے بھیجا تھا۔ (مَوشہ نے نُونؔ کے بیٹے ہوشِیعؔ کا نام یہوشُعؔ رکھا۔) ");
INSERT INTO urdoucv_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","جَب مَوشہ نے اُنہیں مُلکِ کنعانؔ کا جائزہ لینے کے لیٔے بھیجا تو کہا، ”تُم نِیگیوؔ کی طرف سے ہوتے ہویٔے کوہستانی مُلک میں جانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","اَور دیکھنا کہ وہ مُلک کیسا ہے اَور وہاں کے باشِندے مضبُوط ہیں یا کمزور؛ تھوڑے ہیں یا بہت؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","وہ کِس قِسم کے مُلک میں بسے ہویٔے ہیں؟ وہ اَچھّا ہے یا بُرا؟ وہ کیسے شہروں میں رہتے ہیں؟ کیا وہ بغیر فصیلوں کے ہیں یا فصیلدار ہیں؟ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","وہاں کی زمین کیسی ہے؟ کیا وہ زرخیز ہے یا بنجر؟ اَور اُس میں درخت ہیں یا نہیں؟ ہمّت کرکے اَپنے ساتھ اُس مُلک کا کچھ پھل لے آنا۔“ (وہ انگور کی پہلی فصل کا موسم تھا۔) ");
INSERT INTO urdoucv_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","چنانچہ اُنہُوں نے جا کر صینؔ کے بیابان مدخل لیبو حماتؔ کی جانِب رحوبؔ تک اُس مُلک کا جائزہ لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","وہ نِیگیوؔ سے ہوتے ہویٔے حِبرونؔ تک آئے جہاں عناق کے بیٹے احیمانؔ، شیشائی اَور تلمی رہتے تھے۔ (حِبرونؔ مِصر کے ضعنؔ سے سات سال قبل بسایا گیا تھا۔) ");
INSERT INTO urdoucv_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","جَب وہ اِشکلؔ کی وادی میں پہُنچے تو اُنہُوں نے ایک شاخ کاٹ لی جِس میں انگور کا صِرف ایک گُچّھا تھا جسے اُن میں سے دو آدمی ایک لاٹھی پر لٹکایٔے ہویٔے تھے۔ اَور وہ کچھ انار اَور اَنجیر بھی لے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","انگور کے اُس گُچّھے کے سبب جسے اِسرائیلیوں نے وہاں سے کاٹا تھا اُس مقام کا نام وادی اِشکلؔ رکھا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","چالیس دِن کے بعد وہ اُس مُلک کی صورت حال کا جائزہ لے کر لَوٹے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","وہ پارانؔ کے بیابان میں قادِسؔ کے مقام پر مَوشہ، اَہرونؔ اَور بنی اِسرائیل کی ساری جماعت کے پاس لَوٹ آئے۔ وہاں اُنہُوں نے اُنہیں اَور تمام لوگوں کو سارا حال بتایا اَور اُنہیں اُس مُلک کے پھل بھی دِکھائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","اُنہُوں نے مَوشہ کو یہ احوال سُنایا: ”ہم اُس مُلک میں گیٔے جہاں تُم نے ہمیں بھیجا اَور وہاں واقعی دُودھ اَور شہد بہتا ہے اَور یہ پھل بھی وہاں کے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","لیکن جو لوگ وہاں بستے ہیں وہ بڑے مضبُوط ہیں اَور وہاں کے شہر فصیلدار اَور نہایت بڑے ہیں۔ ہم نے وہاں بنی عناق کو بھی دیکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","نِیگیوؔ میں تو عمالیقی آباد ہیں لیکن حِتّی، یبُوسی اَور امُوری کوہستانی علاقہ میں رہتے ہیں اَور کنعانی سمُندر کے پاس اَور یردنؔ کے ساحِل پر بسے ہویٔے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","تَب کالبؔ نے مَوشہ کے سامنے سَب لوگوں کو چُپ کرایا اَور کہا، ”ہم جا کر کیوں نہ اُس مُلک پر قبضہ کر لیں کیونکہ ہم یقیناً اَیسا کر سکتے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","لیکن جو لوگ اُس کے ساتھ گیٔے تھے وہ کہنے لگے، ”ہم اُن لوگوں پر حملہ نہیں کر سکتے کیونکہ وہ ہم سے زِیادہ زورآور ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","اَور اِس طرح اُنہُوں نے بنی اِسرائیل کے درمیان اُس مُلک کے بارے میں جِس کا اُنہُوں نے جائزہ لیا تھا غلط خبر پھیلا دی۔ اُنہُوں نے کہا، ”جِس مُلک کا ہم نے جائزہ لیا وہ اَپنے باشِندوں کو کھا جاتا ہے۔ ہم نے وہاں جتنے لوگ بھی دیکھے وہ سَب بڑے قدآور ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","اَور ہم نے وہاں بنی نفیل کو بھی دیکھا (جو عناقیوں کی نَسل کے نفیلی قوم سے تھے)۔ ہم اُن کے سامنے ٹِڈّوں کی مانند نظر آنے لگے اَور اُنہُوں نے بھی ہمیں ٹِڈّے ہی سمجھا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","اُس رات قوم کے سَب لوگ اَپنی آواز بُلند کرکے چِلّائے اَور زار زار رُوئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","تمام اِسرائیلی مَوشہ اَور اَہرونؔ کے خِلاف بُڑبُڑانے لگے اَور ساری جماعت نے اُن سے کہا، ”کاش کہ ہم مِصر ہی میں مَر جاتے یا بیابان ہی میں ڈھیر ہو جاتے! ");
INSERT INTO urdoucv_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","یَاہوِہ ہمیں اِس مُلک میں کیوں لائے ہیں؟ کیا صِرف اِس لیٔے کہ ہم تلواروں سے قتل کئے جایٔیں؟ ہماری بیویاں اَور بچّے لُوٹ کا مال بَن جایٔیں؟ کیا ہمارے لیٔے بہتر نہ ہوگا کہ ہم واپس مِصر چلے جایٔیں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","اَور وہ آپَس میں کہنے لگے، ”آؤ ہم کسی کو اَپنا سردار بنا لیں اَور مِصر لَوٹ چلیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","تَب مَوشہ اَور اَہرونؔ بنی اِسرائیل کی ساری جماعت کے سامنے جو وہاں جمع تھی مُنہ کے بَل گِرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","یہوشُعؔ بِن نُونؔ اَور یفُنّہؔ کے بیٹے کالبؔ نے جو اُس مُلک کا جائزہ لینے والوں میں سے تھے اَپنے اَپنے کپڑے پھاڑ ڈالے ");
INSERT INTO urdoucv_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","اَور بنی اِسرائیل کی ساری جماعت سے کہا، ”جِس مُلک میں سے گزر کر ہم نے اُس کا جائزہ لیا وہ نہایت اَچھّا مُلک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","اگر یَاہوِہ ہم سے راضی رہے تو وہ ہمیں اُس مُلک میں پہُنچا دیں گے جہاں دُودھ اَور شہد بہتا ہے اَور اُسے ہمیں دیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","صِرف اِتنا ہو کہ یَاہوِہ کے خِلاف بغاوت نہ کرو اَور نہ اُس مُلک کے لوگوں سے ڈرو کیونکہ ہم اُن کو نگل جایٔیں گے۔ اُنہیں کہیں پناہ نہیں ملے گی۔ یَاہوِہ ہمارے ساتھ ہیں۔ تُم اُن سے مت ڈرو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","لیکن ساری جماعت اُنہیں سنگسار کرنے کی باتیں کرنے لگی۔ تَب خیمہ اِجتماع میں تمام بنی اِسرائیل کے سامنے یَاہوِہ کا جلال ظاہر ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","یَاہوِہ نے مَوشہ سے کہا، ”یہ لوگ کب تک میری توہین کرتے رہیں گے؟ اَور باوُجُود اُن تمام معجزوں کے جو مَیں نے اُن کے درمیان کیٔے ہیں وہ کب تک مُجھ پر ایمان نہ لائیں گے؟ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","میں اُنہیں وَبا سے ماروں گا اَور اُنہیں تباہ کر دُوں گا۔ لیکن تُمہیں ایک اَیسی قوم بناؤں گا جو اِن سے بھی عظیم اَور زورآور ہوگی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","مَوشہ نے یَاہوِہ سے کہا، ”تَب تو مِصری اِس کے بارے میں سُن لیں گے! آپ تو اَپنی قُدرت سے اِن لوگوں کو اُن کے درمیان سے نکال لائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","اَور وہ اُس مُلک کے باشِندوں کو اِس کے بارے میں بتائیں گے۔ وہ تو سُن چُکے ہیں کہ آپ جو یَاہوِہ ہیں اِن لوگوں کے درمیان رہتے ہیں اَور یہ کہ آپ جو یَاہوِہ ہیں رُوبرو دِکھائی دیتے ہیں اَور آپ کا بادل اُن پر سایہ کئے رہتاہے اَور آپ دِن کے وقت بادل کے سُتون میں ہوکر اَور رات کو آگ کے سُتون میں ہوکر اُن کے آگے آگے چلا کرتے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","اگر آپ اِن لوگوں کو ایک ہی وقت جان سے مار ڈالیں تو جِن قوموں نے آپ کے بارے میں یہ حال سُنا ہے وہ کہیں گی: ");
INSERT INTO urdoucv_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","’چونکہ یَاہوِہ اِس قوم کو اُس مُلک میں نہ لا سکے جِس کا وعدہ اُنہُوں نے اُن سے قَسم کھا کر کیا تھا اِس لیٔے اُنہُوں نے اُنہیں بیابان میں مار ڈالا۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","”لہٰذا اَب یَاہوِہ کی قُدرت آپ کے اِس قول کے مُطابق عیاں ہو: ");
INSERT INTO urdoucv_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","’یَاہوِہ قہر کرنے میں دھیمے شفقت میں غنی اَور گُناہ اَور سرکشی کے بخشنے والے۔ پھر بھی وہ مُجرم کو بے سزا نہیں چھوڑتے اَور وہ اَولاد کو اُن کے آباؤاَجداد کے گُناہ کی سزا اُن کے بیٹوں اَور پوتوں کو تیسری اَور چوتھی پُشت تک دیتے ہیں۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","لہٰذا اَپنی لافانی مَحَبّت کے مُطابق جَیسے آپ اُنہیں مِصر سے نکلنے کے بعد سے آج تک مُعاف کرتے آئے ہیں وَیسے ہی اَب بھی اِن لوگوں کا گُناہ بخش دیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","یَاہوِہ نے جَواب دیا، ”مَیں نے تمہاری اِلتجا کے مُطابق اُنہیں مُعاف کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","البتّہ مُجھے اَپنی حیات کی قَسم کہ جَب تک یَاہوِہ کے جلال سے ساری زمین معموُر ہوتی رہے گی ");
INSERT INTO urdoucv_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","جِس کسی نے میرا جلال دیکھا اَور اُن معجزوں کو بھی دیکھا جو مَیں نے مِصر میں اَور اِس بیابان میں کئے لیکن میرا حُکم نہ مانا اَور دس بار مُجھے آزمایا ");
INSERT INTO urdoucv_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","اُن میں سے ایک شخص بھی اُس مُلک کو ہرگز نہ دیکھ پایٔےگا جِس کے دینے کا وعدہ مَیں نے قَسم کھا کر اُن کے آباؤاَجداد سے کیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","لیکن چونکہ میرے خادِم کالبؔ کی کچھ اَور ہی طبیعت تھی اَور وہ دِل و جان سے میری پیروی کرتا آیا ہے میں اُسے اُس مُلک میں جہاں وہ ہو آیا ہے پہُنچاؤں گا اَور اُس کی اَولاد اُس کی وارِث ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","چونکہ عمالیقی اَور کنعانی وادیوں میں بسے ہویٔے ہیں لہٰذا کل تُم پلٹ کر بحرِقُلزمؔ کو جانے والی راہ سے بیابان کی طرف کُوچ کرو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","پھر یَاہوِہ نے مَوشہ اَور اَہرونؔ سے کہا: ");
INSERT INTO urdoucv_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","”آخِر کب تک یہ بدکار قوم میرے خِلاف بُڑبُڑاتی رہے گی؟ مَیں نے اِن بُڑبُڑانے والے اِسرائیلیوں کی شکائتیں سُن لی ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","سو تُم اُن سے کہہ دو کہ یَاہوِہ فرماتے ہیں، ’مُجھے میری حیات کی قَسم میں تمہارے ساتھ وُہی سلُوک کروں گا، جِس پر تُم نے مُجھے مجبُور کر دیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","تمہاری لاشیں اِسی بیابان میں پڑی رہ جایٔیں گی۔ تُم میں سے جتنے افراد بیس سال یا اُس سے زِیادہ عمر کے ہیں جِن کی مردُم شماری ہو چُکی ہے اَورجو میرے خِلاف بُڑبُڑایا کرتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","اُن میں سے یفُنّہؔ کے بیٹے کالبؔ اَور یہوشُعؔ بِن نُونؔ کے سِوا کویٔی بھی اُس مُلک میں داخل نہ ہونے پایٔےگا جِس میں تُمہیں بسانے کی مَیں نے قَسم کھائی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","البتّہ تمہارے بال بچّوں کو جِن کے متعلّق تُم نے کہاتھا کہ وہ اِغوا کر لیٔے جایٔیں گے میں وہاں لے آؤں گا تاکہ وہ اُس مُلک کی قدر پہچانیں جسے تُم نے ٹھکرا دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","لیکن تمہارا یہ حال ہوگا کہ تمہاری لاشیں اِسی بیابان میں پڑی رہیں گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","تمہاری اَولاد چالیس سال تک یہاں گلّہ بانی کرتی رہے گی اَور تمہاری بدکاری کا پھل برداشت کرتی رہے گی جَب تک کہ تمہاری آخِری لاش بیابان میں پڑی پڑی گل نہ جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","اِن چالیس دِنوں کے حِساب سے جَب کہ تُم اُس مُلک کا جائزہ لیتے رہے فی دِن ایک سال کے مُطابق چالیس سال تک تُم اَپنے گُناہوں کا پھل پاتے رہوگے اَور تَب تُمہیں مَعلُوم ہوگا کہ میری مُخالفت کرنے کا اَنجام کیا ہوتاہے؟‘ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","میں یَاہوِہ یہ کہہ چُکا اَور مَیں اُس بدکار قوم کے ساتھ جو میری مُخالفت پر ایکا کر چُکی ہے یقیناً اَیسا ہی کروں گا۔ اُن کا خاتِمہ اِسی بیابان میں ہوگا اَور وہ یہیں مَریں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","لہٰذا جِن لوگوں کو مَوشہ نے مُلک کا جائزہ لینے کے لیٔے بھیجا تھا اَور جنہوں نے لَوٹ کر اُس کے متعلّق غلط اِطّلاع دے کر ساری جماعت کو مَوشہ کے خِلاف بُڑبُڑانے پر اُبھارا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","یہ لوگ جو اُس مُلک کے بارے میں غلط اِطّلاع دینے کے ذمّہ دار تھے یَاہوِہ کے حُضُور وَبا سے مَر گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","جو لوگ مُلک کا جائزہ لینے گیٔے تھے اُن میں سے صِرف یہوشُعؔ بِن نُونؔ اَور یفُنّہؔ کا بیٹا کالبؔ سلامت بچ گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","جَب مَوشہ نے تمام بنی اِسرائیل کو یہ ماجرا سُنایا تو وہ بہت دُکھ سے رونے لگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","دُوسرے دِن علی الصبح وہ یہ کہتے ہویٔے اُس مُلک کی پہاڑیوں پر چڑھنے لگے، ”ہم نے یَاہوِہ کے خِلاف گُناہ کیا ہے۔ البتّہ ہم اُس مقام تک جایٔیں گے جِس کا وعدہ یَاہوِہ نے کیا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","لیکن مَوشہ نے کہا، ”تُم یَاہوِہ کے حُکم کی خِلاف ورزی کیوں کر رہے ہو؟ تُم اُس میں کامیاب نہ ہوگے! ");
INSERT INTO urdoucv_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","تُم اُوپر نہ چڑھو کیونکہ یَاہوِہ تمہارے ساتھ نہیں ہیں اَور تُم اَپنے دُشمنوں سے شِکست کھاؤگے، ");
INSERT INTO urdoucv_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","کیونکہ وہاں عمالیقیوں اَور کنعانیوں سے تمہارا سامنا ہوگا اَور چونکہ تُم یَاہوِہ سے برگشتہ ہو گئے ہو وہ تمہارے ساتھ نہ ہوں گے اَور تُم تلوار سے مارے جاؤگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","تاہم وہ جَسارت کرکے کوہستانی مُلک کی پہاڑیوں پر چڑھنے لگے اَور مَوشہ اَور یَاہوِہ کے عہد کا صندُوق چھاؤنی میں ہی پڑا رہا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","تَب عمالیقی اَور کنعانی جو اُس کوہستانی مُلک میں رہتے تھے نیچے اُتر آئے اَور اُن پر ٹوٹ پڑے اَور حُرمہؔ تک اُن کو مارتے چلے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","”بنی اِسرائیل سے مُخاطِب ہو اَور اُن سے فرما، ’جَب تُم اُس مُلک میں داخل ہو جاؤ جو میں تُمہیں رہنے کے لیٔے دے رہا ہُوں ");
INSERT INTO urdoucv_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","اَور تُم یَاہوِہ کے لیٔے گائے بَیل یا بھیڑ بکریوں کی آتِشی قُربانیاں اَور اناج کی نذریں پیش کرو جو یَاہوِہ کے لیٔے فرحت بخش خُوشبو ہُوں۔ خواہ وہ سوختنی نذریں یا کسی خاص مَنّت کے ذبیحے، رضا کی قُربانیاں یا عیدوں کی قُربانیاں ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","تو جو شخص اَپنا نذرانہ لایٔے وہ یَاہوِہ کے حُضُور چوتھائی ہین تیل مِلا ہُوا ایفہ کا دسواں حِصّہ مَیدہ اناج کی قُربانی کے طور پر گذرانے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","اَور سوختنی نذر کے ہر برّہ یا ذبیحہ کے پیچھے چوتھائی ہین مَے تپاون کے طور پر تیّار کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","” ’ہر مینڈھے کے ساتھ تہائی ہین تیل مِلا ہُوا ایفہ کا پانچواں حِصّہ مَیدہ اناج کی قُربانی کے طور پر، ");
INSERT INTO urdoucv_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","اَور تہائی ہین مَے تپاون کے طور پر تیّار کرنا۔ اِسے یَاہوِہ کے حُضُور فرحت بخش خُوشبو کے طور پر پیش کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","” ’جَب تُو یَاہوِہ کے حُضُور سوختنی نذر یا خاص مَنّت کے ذبیحے یا سلامتی کی نذر کے ذبیحہ کے طور پر بچھڑا تیّار کرے ");
INSERT INTO urdoucv_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","تو اُس بچھڑے کے ساتھ نِصف ہین تیل مِلا ہُوا ایفہ کے تین دہائی حِصّہ کے برابر مَیدہ اناج کی قُربانی کے طور پر، ");
INSERT INTO urdoucv_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","اَور نِصف ہین مَے تپاون کے طور پر بھی لانا۔ یہ یَاہوِہ کے حُضُور غِذا کی فرحت بخش خُوشبو والی آتِشی قُربانی ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","ہر بَیل یا مینڈھا اَور ہر برّہ یا بکرا اِسی طرح تیّار کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","تُم جتنے بھی جانور تیّار کرو ہر ایک کے ساتھ اَیسا ہی کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","” ’ہر ایک اِسرائیلی باشِندہ جَب یَاہوِہ کے حُضُور فرحت بخش خُوشبو کے طور پر آتِشی قُربانی پیش کر دے تو وہ یہ سَب کام اِسی طریقہ سے کیا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","آنے والی پُشتوں میں جَب کبھی کویٔی پردیسی یا کسی اَور شخص جو تمہارے ساتھ بُودوباش کرتا ہو یَاہوِہ کے حُضُور فرحت بخش خُوشبو کے طور پر غِذا کی آتِشی قُربانی پیش کرے تو وہ بھی ہُوبہو وَیسا ہی کرے جَیسا تُم کرتے ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","جماعت میں تمہارے لیٔے اَور تمہارے ساتھ رہنے والے پردیسی کے لیٔے ایک سے فرمان ہُوں اَور پُشت در پُشت یہ دائمی فرمان ہمیشہ کے لیٔے رہے گا۔ یَاہوِہ کے آگے تُم اَور پردیسی برابر ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","تمہارے لیٔے اَور تمہارے درمیان رہنے والے پردیسیوں کے لیٔے ایک ہی آئین اَور طریقے ہوں گے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","یَاہوِہ نے مَوشہ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","”بنی اِسرائیل سے مُخاطِب ہو اَور اُن سے فرما: جَب تُم اُس مُلک میں داخل ہو جاؤ، جہاں میں تُمہیں لیٔے جاتا ہُوں ");
INSERT INTO urdoucv_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","اَور تُم اُس مُلک کی پیداوار میں سے کھاؤ تو اُس کا کچھ حِصّہ یَاہوِہ کے لیٔے نذر کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","اَپنے پہلے گوندھے ہویٔے آٹے کی ایک روٹی پیش کرنا اَور اُسے کھلیان کے نذرانہ کے طور پر گذراننا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","تمہاری آنے والی پُشتیں اَپنے پہلے گوندھے ہویٔے آٹے میں سے یَاہوِہ کے لیٔے یہ نذرانہ دیا کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","” ’اگر تُم غَیر اِرادتاً یَاہوِہ کے مَوشہ کو دئیے ہویٔے اِن اَحکام میں سے کسی پر عَمل نہ کرو، ");
INSERT INTO urdoucv_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","یعنی جِس دِن سے یَاہوِہ نے حُکم دینا شروع کیا تَب سے تمام اَحکام جو یَاہوِہ نے آنے والی پُشتوں کے لیٔے مَوشہ کی مَعرفت دئیے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","اَور اگر یہ غَیر اِرادتاً ہُوا ہو اَور جماعت کو اُس کا علم نہ ہو تو ساری جماعت ایک بچھڑا سوختنی نذر کے طور پر پیش کرے تاکہ وہ یَاہوِہ کے حُضُور فرحت بخش خُوشبو ہو اَور اُس کے ساتھ آئین کے مُطابق اُس کی اناج کی قُربانی اَور اُس کا تپاون بھی چڑھائے اَور گُناہ کی قُربانی کے طور پر ایک بکرا پیش کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","یُوں کاہِنؔ بنی اِسرائیل کی ساری جماعت کے لیٔے کفّارہ دے اَور وہ بخش دئیے جایٔیں گے کیونکہ یہ خطا دانستہ طور پر نہیں ہُوئی تھی اَور اُنہُوں نے اَپنی خطا کے عِوض یَاہوِہ کے حُضُور آتِشی قُربانی اَور گُناہ کی قُربانی پیش کر دی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","تَب بنی اِسرائیل کی ساری جماعت اَور اُن کے ساتھ رہنے والے پردیسی مُعاف کئے جایٔیں گے کیونکہ سبھی لوگ اِس نادانستہ خطا میں شریک تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","” ’لیکن اگر صِرف ایک ہی شخص غَیر اِرادتاً گُناہ کرے تو وہ یک سالہ بکری گُناہ کی قُربانی کے طور پر پیش کرے ");
INSERT INTO urdoucv_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","اَور کاہِنؔ غَیر اِرادتاً گُناہ کرنے والے کی خاطِر یَاہوِہ کے حُضُور میں کفّارہ دے اَور جَب اُس کے لیٔے کفّارہ دے دیا جائے گا تو وہ مُعافی پایٔےگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","غَیر اِرادتاً گُناہ کرنے والے ہر شخص کے لیٔے ایک ہی آئین ہو خواہ وہ مُلک اِسرائیل کا باشِندہ ہو یا غَیراِسرائیلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","” ’لیکن جو شخص جان بوجھ کر گُناہ کرے خواہ وہ مُلک اِسرائیل کا باشِندہ ہو یا غَیراِسرائیلی ہو وہ یَاہوِہ کی اہانت کرتا ہے اَور وہ شخص اَپنے لوگوں میں سے کاٹ ڈالا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","چونکہ اُس نے یَاہوِہ کے کلام کی تحقیر کی اَور اُن کی حُکم عُدولی کی اِس لیٔے وہ شخص ضروُر کاٹ ڈالا جائے۔ اُس کا گُناہ اُسی کے سَر لگے گا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","جَب بنی اِسرائیل بیابان میں رہتے تھے تَب ایک شخص سَبت کے دِن لکڑیاں جمع کرتا ہُوا پایا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","جنہوں نے اُسے لکڑیاں جمع کرتے ہویٔے پایاتھا وہ اُسے مَوشہ اَور اَہرونؔ اَور ساری جماعت کے پاس لے آئے ");
INSERT INTO urdoucv_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","اَور اُنہُوں نے اُسے حِراست میں رکھا کیونکہ یہ واضح نہ تھا کہ اُس کے ساتھ کیا سلُوک کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","تَب یَاہوِہ نے مَوشہ سے فرمایا، ”یہ آدمی مار ڈالا جائے۔ ساری جماعت چھاؤنی کے باہر اُسے سنگسار کرے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","چنانچہ جَیسا یَاہوِہ نے مَوشہ کو حُکم دیا تھا اُسی کے مُطابق جماعت نے اُسے چھاؤنی کے باہر لے جا کر سنگسار کیا اَور وہ مَر گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","یَاہوِہ نے مَوشہ سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","”بنی اِسرائیل سے مُخاطِب ہو اَور اُن سے کہہ کہ وہ پُشت در پُشت اَپنے کُرتوں کے کناروں پر جھالریں لگائیں اَور ہر جھالر پر ایک نیلا ڈورا ٹانکیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","یہ جھالریں اَیسی ہُوں کہ جَب اُن پر تمہاری نگاہ پڑے تو یَاہوِہ کے سَب اَحکام تُمہیں یاد آئیں تاکہ تُم اُن پر عَمل کرو اَور اَپنے دِل اَور آنکھوں کی خواہشوں کی پیروی میں کویٔی فاحِشہ حرکت نہ کر بیٹھو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","تَب تُم یاد کرکے میرے سَب حُکموں پر عَمل کروگے اَور اَپنے خُدا کے واسطے مُقدّس ہوگے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","مَیں یَاہوِہ تمہارا خُدا ہُوں جو تُمہیں مِصر سے نکال لایا تاکہ تمہارا خُدا ٹھہروں۔ مَیں یَاہوِہ تمہارا خُدا ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","قورحؔ جو لیوی کا پرپوتا قُہات کا پوتا اَور اِضہاؔر کا بیٹا تھا اِلیابؔ کے بیٹوں داتنؔ اَور ابیرامؔ اَور پِلیتھ کے بیٹے اَونؔ جَیسے چند بنی رُوبِنؔ کے ساتھ مِل کر گستاخی کر بیٹھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","وہ مَوشہ کے خِلاف اُٹھ کھڑے ہویٔے۔ بنی اِسرائیل میں سے ڈھائی سَو لوگ اُن کے ساتھ تھے جو جماعت کے نامور سردار اَور مجلس کے نامزد رُکن تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","وہ مَوشہ اَور اَہرونؔ کی مُخالفت کرنے کے لئے ایک گِروہ کی طور پر اِکٹھّے ہوکر اُن سے کہنے لگے، ”تُم حَد سے بڑھ چُکے ہو! ساری جماعت اَور اُس کا ہر ایک فرد مُقدّس ہے اَور یَاہوِہ اُن کے ساتھ ہیں۔ پھر تُم یَاہوِہ کی جماعت میں اَپنے آپ کو کیوں بالاتر رکھتے ہیں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","جَب مَوشہ نے یہ باتیں سُنی تو وہ اَپنے مُنہ کے بَل گرا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","تَب اُس نے قورحؔ اَور اُس کے تمام پیروکاروں سے کہا: ”کل صُبح کے وقت یَاہوِہ صَاف ظاہر کر دیں گے کہ کون اُن کا ہے اَور کون مُقدّس ہے اَور وہ اُس شخص کو اَپنے قریب آنے دیں گے۔ جسے وہ آپ نے آپ مُنتخب کریں گے اُسے وہ اَپنی قربت بھی بخشیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","لہٰذا اَے قورحؔ! تُم اَور تمہارے تمام پیروکار اَپنا اَپنا بخُوردان لیں ");
INSERT INTO urdoucv_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","اَور کل اُن میں آگ رکھ کر تُم یَاہوِہ کے حُضُور بخُور جَلاؤ۔ تَب جِس شخص کو یَاہوِہ مُنتخب کریں وُہی مُقدّس ٹھہرے گا۔ اَے لیویو! تُم حَد سے زِیادہ بڑھ گیٔے ہو!“ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","مَوشہ نے قورحؔ سے یہ بھی کہا، ”اَے لیویو سُنو! ");
INSERT INTO urdoucv_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","کیا تمہارے لیٔے یہ کافی نہیں کہ اِسرائیل کے خُدا نے تُمہیں بنی اِسرائیل کی جماعت سے الگ کرکے اَپنی قربت میں لیا ہے تاکہ تُم یَاہوِہ کے مَسکن کی خدمت کرو اَور جماعت کے سامنے کھڑے ہوکر اُس کی بھی خدمت بجا لاؤ۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","اِس طرح یَاہوِہ نے تُمہیں اَور تمہارے سَب لیوی بھائیوں کو بھی اَپنی قربت میں لے آئے، لیکن اَب تُم کہانت بھی حاصل کرنا چاہتے ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","دراصل وہ یَاہوِہ ہی ہیں جِس کے خِلاف تُم اَور تمہارے سَب پیروکار اِکٹھّے ہو گئے ہو۔ اَہرونؔ کون ہے، جو تُم اُس کے خِلاف بُڑبُڑاتے ہو؟“ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","تَب مَوشہ نے اِلیابؔ کے بیٹوں داتنؔ اَور ابیرامؔ کو بُلوا بھیجا لیکن اُنہُوں نے کہا، ”ہم نہیں آتے! ");
INSERT INTO urdoucv_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","کیا یہ کافی نہیں کہ تُم ہمیں ایک اَیسے مُلک سے جِس میں دُودھ اَور شہد بہتا ہے، اِس لیٔے نکال لائے ہو، ہمیں بیابان میں مار ڈالو؟ اَب تُم حاکم بَن کر ہم پر اِختیار بھی جتاتے ہو؟ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","اِس کے علاوہ تُم نے ہمیں اُس مُلک میں بھی نہیں پہُنچایا جہاں دُودھ اَور شہد بہتا ہے اَور نہ ہمیں کھیتوں اَور تاکستانوں کا وارِث بنایا۔ کیا تُم اُن لوگوں کے ساتھ غُلام جَیسا برتاؤ کرنا چاہتے ہو؟ نہیں، ہم نہیں آئیں گے!“ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","تَب مَوشہ بےحد غُصّہ ہُوا اَور یَاہوِہ سے کہنے لگے، ”اُن کا ہدیہ قبُول نہ کرنا۔ مَیں نے اُن سے ایک گدھا بھی نہیں لیا نہ اُن میں سے کسی کو کویٔی نُقصان پہُنچایا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","پھر مَوشہ نے قورحؔ سے کہا، ”کل تُم اَپنے سَب پیروکاروں کو ساتھ لے کر یَاہوِہ کے آگے حاضِر ہو۔ تُم، اَور تمہارے وہ لوگ اَور اَہرونؔ بھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","ہر شخص اَپنا اَپنا بخُوردان لے اَور اُس میں بخُور ڈالے اَور اُسے یَاہوِہ کے حُضُور پیش کرے۔ کُل ڈھائی سَو بخُوردان ہوں۔ تُم اَور اَہرونؔ بھی اَپنا اَپنا بخُوردان پیش کرنا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","چنانچہ سارے آدمی اَپنا اَپنا بخُوردان لے کر اُن میں آگ اَور بخُور ڈال کر مَوشہ اَور اَہرونؔ کے ساتھ خیمہ اِجتماع کے دروازہ پر آ کھڑے ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","جَب قورحؔ نے اَپنے سارے فریق والوں کو اُن کے خِلاف خیمہ اِجتماع کے دروازہ پر جمع کیا تو یَاہوِہ کا جلال ساری جماعت کے سامنے ظاہر ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","یَاہوِہ نے مَوشہ اَور اَہرونؔ سے کہا: ");
INSERT INTO urdoucv_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","”اَپنے آپ کو اِس جماعت سے الگ کر لو تاکہ میں پل بھر میں اُن کا خاتِمہ کر دُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","لیکن مَوشہ اَور اَہرونؔ مُنہ کے بَل گِر کر کہنے لگے، ”اَے خُدا! اَے بنی نَوع اِنسان کی رُوحوں کے خُدا! کیا آپ ساری جماعت پر اَپنا قہر نازل کریں گے جَب کہ صِرف ایک آدمی نے گُناہ کیا ہے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","تَب یَاہوِہ نے مَوشہ سے کہا: ");
INSERT INTO urdoucv_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","”اِس جماعت سے کہہ، ’وہ قورحؔ داتنؔ اَور ابیرامؔ کے خیموں کے آس پاس سے ہٹ جائے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","مَوشہ اُٹھ کر داتنؔ اَور ابیرامؔ کی طرف گیا اَور اِسرائیل کے بُزرگ اُس کے پیچھے پیچھے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","اُس نے جماعت کو آگاہ کیا، ”اِن بدکار آدمیوں کے خیموں کے پاس سے پیچھے ہٹ جاؤ اَور اُن کی کسی چیز کو نہ چھوؤ۔ کہیں اَیسا نہ ہو کہ تُم بھی اُن کے سَب گُناہوں کے باعث برباد ہو جاؤ۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","چنانچہ وہ قورحؔ، داتنؔ اَور ابیرامؔ کے خیموں کے آس پاس سے ہٹ گیٔے۔ لیکن داتنؔ اَور ابیرامؔ باہر نکل آئے اَور اَپنی بیویوں اَور چُھوٹے بچّوں کے ساتھ اَپنے اَپنے خیموں کے دروازوں پر کھڑے ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","تَب مَوشہ نے کہا، ”اِس سے تُم جان لوگے کہ یَاہوِہ نے مُجھے یہ سَب کام کرنے کے لیٔے بھیجا ہے اَور یہ بھی کہ یہ میرا اَپنا منصُوبہ نہیں تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","اگر یہ اِنسان قُدرتی موت مَریں اَور اُن کے ساتھ وُہی ہو جو سَب لوگوں کے ساتھ ہُوا کرتا ہے تو میں یَاہوِہ کا بھیجا ہُوا نہیں ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","لیکن اگر یَاہوِہ کویٔی انوکھا کرشمہ دِکھائیں اَور زمین اَپنا مُنہ کھول دے اَور اُنہیں اَور اُن کا سَب کچھ نگل جائے اَور وہ زندہ ہی قبر میں سما جایٔیں تَب تُم جان لوگے کہ اِن لوگوں نے خُدا کی تحقیر کی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","جوں ہی اُس نے یہ باتیں ختم کیں اُن کے قدموں کے نیچے کی زمین پھٹ گئی ");
INSERT INTO urdoucv_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","اَور زمین نے اَپنا مُنہ کھول دیا اَور اُنہیں، اُن کے گھر بار اَور قورحؔ کے یہاں کے سَب آدمیوں کو اَور اُن کے تمام مال و اَسباب کو ہڑپ کر لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","وہ اَپنے تمام مال و اَسباب کے ساتھ زندہ ہی قبر میں جا پڑے اَور زمین اُن کے اُوپر برابر ہو گئی اَور وہ جماعت میں سے نابود ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","اُن کا چِلّانا سُن کر تمام اِسرائیلی جو اُن کے آس پاس تھے وہ یہ کہتے ہویٔے بھاگ نکلے، ”زمین ہمیں بھی نگل لے گی!“ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","تَب یَاہوِہ کے پاس سے آگ نکلی اَور اُن ڈھائی سَو آدمیوں کو بھسم کر گئی جو بخُور چڑھا رہے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","یَاہوِہ نے مَوشہ سے کہا: ");
INSERT INTO urdoucv_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","”اَہرونؔ کاہِنؔ کے بیٹے الیعزرؔ سے کہہ کہ وہ بخُوردانوں کو جھلستے ہویٔے انبار میں سے نکال لے اَور اَنگاروں کو کچھ فاصلہ پر بِکھیر دے کیونکہ وہ بخُوردان مُقدّس ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","وہ اُن آدمیوں کے بخُوردان ہیں جنہوں نے اَپنی ہی جان سے دُشمنی کرکے گُناہ کیا تھا۔ اُن بخُوردانوں کو پِیٹ پِیٹ کر پترے بنالو تاکہ وہ مذبح پر منڈھے جایٔیں کیونکہ اُنہیں یَاہوِہ کے حُضُور رکھا گیا تھا۔ اِس لیٔے وہ پاک ہیں۔ وہ بنی اِسرائیل کے لیٔے ایک نِشان ٹھہریں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","چنانچہ الیعزرؔ کاہِنؔ نے وہ کانسے کے بخُوردان بٹور لئے جنہیں وہ لوگ لے کر آئےتھے جو بعد کو بھسم کر دیئے گیٔے تھے اَور اُس نے اُن بخُوردانوں کو پِٹوا کر اُن کے پترے بنوائے تاکہ اُن سے مذبح کو منڈھا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","جَیسا کہ یَاہوِہ نے مَوشہ کی مَعرفت حُکم دیا تھا یہ بنی اِسرائیل کو جتانے کے لیٔے تھا کہ اَہرونؔ کی نَسل کے علاوہ کویٔی غَیر شخص بخُور جَلانے کے لیٔے یَاہوِہ کے حُضُور نہ جائے تاکہ اَیسا نہ ہو کہ اُس کا اَنجام بھی قورحؔ اَور اُس کے فریق والوں کی طرح ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","دُوسرے دِن بنی اِسرائیل کی ساری جماعت یہ کہہ کر مَوشہ اَور اَہرونؔ کے خِلاف بُڑبُڑانے لگی، ”تُم نے یَاہوِہ کے لوگوں کو مار ڈالا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","لیکن جَب وہ جماعت مَوشہ اَور اَہرونؔ کے خِلاف جمع ہو رہی تھی تو اُنہُوں نے خیمہ اِجتماع کی طرف نگاہ کی کہ اَچانک ایک بادل اُن پر چھا گیا اَور یَاہوِہ کا جلال ظاہر ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","تَب مَوشہ اَور اَہرونؔ خیمہ اِجتماع کے سامنے آئے، ");
INSERT INTO urdoucv_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","اَور یَاہوِہ نے مَوشہ سے کہا: ");
INSERT INTO urdoucv_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","”اِس جماعت کے بیچ سے ہٹ جاؤ تاکہ میں فوراً اُن کا خاتِمہ کر دُوں۔“ تَب وہ مُنہ کے بَل گِرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","تَب مَوشہ نے اَہرونؔ سے کہا، ”اَپنا بخُوردان لے اُس میں مذبح پر سے آگ لے کر رکھ اَور اُس پر بخُور ڈال اَور جلدی سے جماعت کے پاس جا کر اُن کے لیٔے کفّارہ دے کیونکہ یَاہوِہ کی طرف سے قہر نازل ہُواہے اَور وَبا شروع ہو چُکی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","چنانچہ اَہرونؔ نے مَوشہ کے کہنے کے مُطابق کیا اَور وہ دَوڑتا ہُوا جماعت کے درمیان گیا۔ حالانکہ لوگوں میں وَبا پھیل چُکی تھی تو بھی اَہرونؔ نے بخُور جَلایا اَور اُن کے لیٔے کفّارہ دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","اَور وہ مُردوں اَور زندوں کے درمیان کھڑا ہُوا اَور وَبا رُک گئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","اَور قورحؔ کی وجہ سے مَرے ہویٔے لوگوں کے علاوہ مزید چودہ ہزار سات سَو لوگ وَبا سے مَر گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","تَب اَہرونؔ لَوٹ کر خیمہ اِجتماع کے دروازہ پر مَوشہ کے پاس آیا کیونکہ وَبا موقُوف ہو چُکی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","یَاہوِہ نے مَوشہ سے کہا: ");
INSERT INTO urdoucv_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","”بنی اِسرائیل سے مُخاطِب ہو اَور اُن کے آبائی قبیلوں کے سرداروں سے فی کس ایک عصا کے حِساب سے بَارہ عصے لیٔے جایٔیں اَور ہر آدمی کا نام اُس کے عصا پر لِکھّا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","لیوی کے عصا پر اَہرونؔ کا نام لِکھنا کیونکہ ہر آبائی قبیلہ کے سردار کے لیٔے ایک عصا ہوگا ");
INSERT INTO urdoucv_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","اَور اُنہیں خیمہ اِجتماع میں عہد کے صندُوق کے سامنے جہاں میں تُم سے مُلاقات کرتا ہُوں رکھ دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","اَور جِس شخص کو میں چُنوں گا اُس کے عصا میں سے کونپلیں پھوٹ نکلیں گی اَور مَیں بنی اِسرائیل کے تمہارے خِلاف مُتواتر بُڑبُڑانے سے چھُٹکارا پاؤں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","چنانچہ مَوشہ نے بنی اِسرائیل سے گُفتگو کی اَور اُن کے سرداروں نے ہر آبائی قبیلہ کے سردار کے پیچھے ایک عصا کے حِساب سے بَارہ عصے اُسے دئیے اَور اَہرونؔ کا عصا بھی اُن میں تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","مَوشہ نے سارے عصے لے کر عہد کا خیمہ میں یَاہوِہ کے حُضُور رکھ دئیے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","دُوسرے دِن جَب مَوشہ عہد کے خیمہ میں داخل ہُوا تو دیکھا کہ اَہرونؔ کے عصا میں جو لیویوں کے خاندان کی نُمائندگی کرتا تھا نہ صِرف کونپلیں پھوٹی ہُوئی تھیں بَلکہ پھُول بھی کھِلے ہویٔے تھے اَور بادام بھی لگے ہویٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","تَب مَوشہ وہ سارے عصے یَاہوِہ کے حُضُور سے نکال کر تمام بنی اِسرائیل کے پاس لے گئے۔ اُنہُوں نے اُنہیں دیکھا اَور ہر آدمی نے اَپنا اَپنا عصا لے لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","یَاہوِہ نے مَوشہ سے کہا، ”اَہرونؔ کے عصا کو عہد کے صندُوق کے آگے پھر رکھ دیں تاکہ وہ اُن باغیوں کے لیٔے ایک نِشان کے طور پر رکھا رہے۔ اِس سے اُن کا میرے خِلاف بُڑبُڑانا ختم ہو جائے گا تاکہ وہ مَر نہ جایٔیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","مَوشہ نے ٹھیک وَیسا ہی کیا جَیسا یَاہوِہ نے اُسے حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","بنی اِسرائیل نے مَوشہ سے کہا، ”ہم مَر جایٔیں گے۔ ہم کہیں کے نہ رہے۔ ہم سَب کہیں کے نہ رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","اگر کویٔی یَاہوِہ کے مَسکن کے قریب بھی جاتا ہے تو مارا جاتا ہے۔ تو کیا ہم سَب کے سَب مَر جایٔیں گے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","یَاہوِہ نے اَہرونؔ سے کہا، ”پاک مَقدِس کے خِلاف سرزد ہونے والے گُناہوں کا بار تُم پر، تمہارے بیٹوں اَور تمہارے آبائی خاندان پر ہوگا۔ اَور کہانت کے خِلاف سرزد ہونے والے گُناہوں کا بار صِرف تُم پر اَور تمہارے بیٹوں پر ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","جَب تُم اَور تمہارے بیٹے عہد کے خیمہ کے آگے خدمت کریں تو اَپنے آبائی قبیلہ سے اَپنے لیوی بھائیوں کو بھی اَپنے ساتھ لے آیا کریں تاکہ وہ تمہارے ساتھ مِل کر تمہاری مدد کریں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","وہ تُمہیں جَوابدہ ہوں گے اَور وہ خیمہ کی ساری خدمت اَنجام دیں لیکن وہ پاک مَقدِس کے سازوسامان یا مذبح کے نزدیک نہ جایٔیں۔ کہیں اَیسا نہ ہو کہ وہ اَور تُم دونوں مارے جاؤ۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","وہ تمہارے ساتھ مِل کر خیمہ اِجتماع کی حِفاظت کے ذمّہ دار ہوں گے جِس میں خیمہ کے سَب کام شامل ہیں۔ اَور جہاں تُم ہو وہاں کویٔی دُوسرا نہ آنے پایٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","”پاک مَقدِس اَور مذبح کی حِفاظت تُم ہی کرنا تاکہ آئندہ بنی اِسرائیل پر قہر نازل نہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","مَیں نے خُود تمہارے لیوی بھائیوں کو بنی اِسرائیل کے درمیان سے تمہاری مدد کے لیٔے مُنتخب کیا ہے اَور اُنہیں یَاہوِہ کے لیٔے وقف کیا ہے تاکہ وہ خیمہ اِجتماع میں خدمت بجا لائیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","لیکن مذبح سے تعلّق رکھنے والی ہر چیز کی اَور پردہ کے اَندر کی کہانت کی خدمات صِرف تُم اَور تمہارے بیٹے ہی اَنجام دیں۔ کہانت کی خدمت کا شرف میں تُمہیں بخشتا ہُوں۔ اگر کویٔی اَور پاک مَقدِس کے قریب آ جائے تو وہ جان سے مار ڈالا جائے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","تَب یَاہوِہ نے اَہرونؔ سے کہا، ”مَیں نے خُود تُمہیں اُن نذرانوں کی ذمّہ داری دی ہے جو مُجھے پیش کئے جاتے ہیں۔ جتنے پاک نذرانے بنی اِسرائیل میرے حُضُور پیش کرتے ہیں وہ سَب میں تُمہیں اَور تمہارے بیٹوں کو تمہارے حق میں دائمی حِصّہ کے طور پر دے رہا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","نہایت پاک نذرانوں میں سے جو حِصّہ آگ سے بچایا جائے وہ تمہارا ہوگا۔ وہ نذرانے جنہیں وہ نہایت پاک قُربانیوں کے طور پر مُجھے پیش کرتے ہیں خواہ وہ اناج کی نذر، گُناہ کی قُربانی یا خطا کی قُربانیاں ہُوں سَب تُم اَور تمہارے بیٹوں کے لیٔے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","تُم اُن کو نہایت مُقدّس جان کر کھانا۔ صِرف مَرد اُنہیں کھایٔیں۔ اَور تُم اُنہیں پاک ماَننا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","”اَور یہ بھی تمہارا ہوگا: جِتنا نذرانہ بنی اِسرائیل ہلانے کی نذروں کی قُربانی کے لیٔے دیں اُسے میں تُمہیں اَور تمہارے بیٹوں اَور بیٹیوں کو اُن کا حق دائمی حِصّہ کے طور پر دیتا ہُوں اُن کا اَبدی حق مُقرّر کر دے رہا ہُوں۔ تمہارے خاندان کا ہر شخص جو رسماً پاک ہو اُنہیں کھا سَکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","”بہترین زَیتُون کا تیل، بہترین نئے انگوری شِیرے اَور اناج جسے وہ اَپنی پہلی فصل کے پہلے پھل کے طور پر یَاہوِہ کو پیش کرتے ہیں وہ سَب میں تُمہیں دیتا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","اَپنے مُلک کا سارا پہلا پھل جسے وہ یَاہوِہ کے لیٔے لائیں تمہارا ہوگا۔ تمہارے خاندان کا ہر شخص جو رسماً پاک ہو اُنہیں کھا سَکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","”بنی اِسرائیل کی جو یَاہوِہ کے لیٔے مخصُوص کی ہُوئی ہر شَے تمہاری ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","ہر رِحم کا پہلا بچّہ خواہ وہ اِنسان ہو یا حَیوان جو یَاہوِہ کو نذر کیا گیا ہو تمہارا ہے۔ لیکن تُم اِنسان کے پہلوٹھے اَور ناپاک جانوروں کے پہلوٹھے نر بچّوں کو فدیہ لے کر چھوڑ دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","جَب وہ ایک مہینے کے ہُوں تَب تُم اُنہیں اُن کی فدیہ کی مُقرّرہ قیمت لے کر چھوڑا دینا جو پاک مَقدِس کے بیس گِیرہ کی ثاقل کے حِساب سے چاندی کی پانچ ثاقل ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","”لیکن گائے، بھیڑ اَور بکری کے پہلوٹھوں کا فدیہ نہ لینا۔ وہ مُقدّس ہیں۔ تُو اُن کا خُون مذبح پر چھڑکنا اَور اُن کی چربی آتِشی قُربانی کے طور پر جَلا دینا تاکہ وہ یہ یَاہوِہ کے حُضُور غِذا کی فرحت بخش خُوشبو ٹھہرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","جِس طرح ہلانے کی نذر کی قُربانی کا سینہ اَور داہنی ران تمہارے ہیں اُسی طرح اُن کا گوشت بھی تمہارا ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","بنی اِسرائیل کی یَاہوِہ کو پیش کی ہُوئی مُقدّس قُربانیوں کی نذروں میں سے جو کچھ الگ رکھا جائے اُسے میں تُمہیں اَور تمہارے بیٹوں اَور بیٹیوں کو تمہارے مُقرّرہ حِصّہ کے طور پر دے دیتا ہُوں۔ یہ یَاہوِہ کے حُضُور تمہارے اَور تمہاری نَسل کے لیٔے نمک کا دائمی عہد ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","یَاہوِہ نے اَہرونؔ سے کہا، ”اُن کے مُلک میں تمہاری کویٔی مِیراث نہ ہوگی اَور نہ اُن کے درمیان تمہارا کویٔی حِصّہ ہوگا۔ میں ہی بنی اِسرائیل میں تمہارا حِصّہ اَور تمہاری مِیراث ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","”اَور مَیں نے لیویوں کو اُس خدمت کے عِوض جو وہ خیمہ اِجتماع میں اَنجام دیتے ہیں اِسرائیل کی ساری دہ یکی مِیراث کے طور پر دی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","آئندہ بنی اِسرائیل خیمہ اِجتماع کے نزدیک ہرگز نہ آئیں۔ کہیں اَیسا نہ ہو کہ گُناہ اُن کے سَر لگے اَور وہ مَر جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","بَلکہ لیوی ہی خیمہ اِجتماع کی خدمت کریں اَور وُہی اُن کا بارِ گُناہ اُٹھایا کریں۔ یہ آئندہ پُشتوں کے لیٔے دائمی فرمان ہے۔ اَور بنی اِسرائیل کے درمیان اُنہیں کویٔی مِیراث نہ ملے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","اِس کے عِوض مَیں نے اُس دہ یکی کو جو اِسرائیلی نذر کے طور پر یَاہوِہ کے حُضُور پیش کرتے ہیں لیویوں کی مِیراث قرار دیا ہے۔ اِس لیٔے مَیں نے اُن کے حق میں کہا ہے: ’بنی اِسرائیل کے درمیان اُنہیں کویٔی مِیراث نہ ملے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","یَاہوِہ نے مَوشہ سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","”لیویوں سے مُخاطِب ہو اَور اُن سے کہہ: ’جَب تُم بنی اِسرائیل سے وہ دہ یکی لو جسے میں تُمہیں مِیراث میں دیتا ہُوں تَب تُم اُس دہ یکی کا دسواں حِصّہ یَاہوِہ کے حُضُور میں اُٹھانے کی قُربانی کے نذرانے کے طور پر گذراننا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","تمہارا یہ نذرانہ تمہارے حق میں کھلیان کے اناج یا مے کے حوض کی طرح سمجھا جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","اِس طریقہ سے تُم بھی اَپنی سَب دہ یکیوں میں سے جو تُم بنی اِسرائیل کی طرف سے پاؤگے یَاہوِہ کے حُضُور نذرانہ پیش کرنا۔ اُن دہ یکیوں میں سے یَاہوِہ کا حِصّہ اَہرونؔ کاہِنؔ کو دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","ہر نذرانہ جو تُمہیں دیا جائے اُس کا بہترین اَور مُقدّس حِصّہ یَاہوِہ کے لیٔے مخصُوص کرکے الگ طور پر پیش کیا جائے۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","”لیویوں سے کہہ: ’جَب تُم بہترین حِصّہ کی قُربانی کے طور پر پیش کروگے تو وہ تمہارے حق میں کھلیان کی پیداوار یا مے کے حوض کے طور پر گِنا جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","اَور بقیّہ حِصّہ کو تُم اَور تمہارے خاندان کے لوگ کہیں بھی کھا سکتے ہیں کیونکہ وہ خیمہ اِجتماع میں تمہاری خدمت کا مُعاوضہ ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","اَور تُم اُس میں کا بہترین حِصّہ کی قُربانی کے طور پر دینے سے اِس مُعاملہ میں مُجرم نہ ٹھہروگے۔ تُم بنی اِسرائیل کے مُقدّس نذرانوں کو ہرگز ناپاک نہ کرنا ورنہ مارے جاؤگے۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","یَاہوِہ نے مَوشہ اَور اَہرونؔ سے کہا: ");
INSERT INTO urdoucv_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","”یَاہوِہ نے جِس آئین کا حُکم دیا ہے اُس کا تَقاضا یہ ہے: بنی اِسرائیل سے کہہ دو کہ وہ تمہارے پاس لال رنگ کی ایک بے عیب اَور بے داغ بچھیا لائیں جِس پر کبھی جُوا نہ رکھا گیا ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","پھر تُم اُسے الیعزرؔ کاہِنؔ کو دے دو تاکہ اُسے چھاؤنی کے باہر لے جایا جائے اَور اُس کے سامنے ذبح کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","تَب الیعزرؔ کاہِنؔ اَپنی اُنگلی پر اُس کا کچھ خُون لے لیں اَور اُسے خیمہ اِجتماع کے سامنے کی طرف سات مرتبہ چھڑکنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","تَب اُس بچھیا کو اُس کی کھال، گوشت، خُون اَور انتڑیاں سمیت اُس کے سامنے جَلا دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","پھر کاہِنؔ دیودار کی کچھ لکڑی، زُوفا اَور سُرخ رنگ کا اُون لے کر اُس جلتی ہُوئی بچھیا کے اُوپر ڈال دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","اُس کے بعد کاہِنؔ اَپنے کپڑے دھوئے اَور پانی سے غُسل کر لے۔ پھر وہ چھاؤنی میں چلے آئے لیکن شام تک وہ ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","اَورجو شخص اُسے جَلائے وہ بھی اَپنے کپڑے دھوئے اَور پانی سے غُسل کر لے اَور وہ بھی شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","”پھر کویٔی پاک شخص اُس بچھیا کی راکھ بٹورے اَور اُسی چھاؤنی کے باہر کسی اَیسی جگہ رکھ چھوڑے جو رسماً پاک ہو۔ بنی اِسرائیل کی جماعت اُسے ناپاکی دُور کرنے کے پانی میں ڈالنے کے لیٔے رکھے۔ اِسے طہارت کے لیٔے اِستعمال کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","جو شخص اِس بچھیا کی راکھ کو بٹورے وہ بھی اَپنے کپڑے دھوئے۔ وہ بھی شام تک ناپاک رہے گا۔ یہ بنی اِسرائیل کے لیٔے اَور اُن کے درمیان رہنے والے پردیسیوں کے لیٔے بھی دائمی فرمان ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","”جو شخص کسی لاش کو چھُوئے وہ سات دِن تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","وہ شخص اَپنے آپ کو تیسرے دِن اَور ساتویں دِن پانی سے پاک کر لے۔ تَب وہ پاک ہو جائے گا۔ لیکن اگر وہ اَپنے آپ کو تیسرے اَور ساتویں دِن پاک نہ کرے تو وہ پاک نہ ہوگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","جو شخص کسی لاش کو چھُوتا ہے اَور اَپنے آپ کو پاک نہیں کر پاتا وہ یَاہوِہ کے خیمہ اِجتماع کو ناپاک کرتا ہے۔ وہ شخص اِسرائیل میں سے کاٹ ڈالا جائے۔ چونکہ ناپاکی دُور کرنے کا پانی اُس پر نہیں چھِڑکا گیا اِس لیٔے وہ ناپاک ہے۔ اُس کی ناپاکی قائِم رہے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","”جَب کویٔی شخص خیمہ میں مَر جائے تو اُس پر اِس آئین کا اِطلاق ہوگا: جو کویٔی اُس خیمہ میں داخل ہو یا جو کویٔی اُس میں رہتا ہو وہ سات دِن تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","اَور ہر ایک کھُلا برتن جِس پر کویٔی ڈھکنا نہ ہو ناپاک ٹھہرے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","”اَورجو کویٔی میدان میں کسی تلوار سے مارے گیٔے کو یا اُس شخص کو جو طبعی موت مَرا ہو یا اِنسان کی ہڈّی کو یا کسی قبر کو چھُوئے وہ سات دِن تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","”ناپاک شخص کے لیٔے اُس جلی ہُوئی گُناہ کی قُربانی کی کچھ راکھ کسی مرتبان میں لے کر اُس پر تازہ پانی ڈال دو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","تَب کویٔی آدمی جو رسماً پاک ہو زُوفا لے اَور اُسے اُس پانی میں ڈُبو کر اُس خیمہ پر اَور سَب سازوسامان پر اَور جتنے لوگ وہاں تھے اُن پر چھڑکے۔ اَور اُس شخص پر بھی چھڑکے جِس نے اِنسان کی ہڈّی کو یا قبر کو یا مقتول کو یا کسی اَیسے مُردے کو چھُوا ہو جو طبعی موت مَرا ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","وہ پاک آدمی تیسرے اَور ساتویں دِن اُس ناپاک شخص پر چھڑکے اَور ساتویں دِن وہ اُسے پاک کر دیں، جِس شخص کو پاک کیا جا رہا ہو وہ اَپنے کپڑے دھوئے اَور پانی سے غُسل کرے تو وہ شام کو پاک ہو جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","لیکن اگر کویٔی شخص ناپاک ہو اَور اَپنے آپ کو پاک نہ کر لے تو اُسے جماعت سے کاٹ ڈالا جائے کیونکہ اُس نے یَاہوِہ کے پاک مَقدِس کو ناپاک کیا ہے۔ طہارت کا پانی اُس پر چھِڑکا نہیں گیا اِس لیٔے وہ ناپاک ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","یہ اُن کے لیٔے ایک دائمی فرمان ہو۔ ”جو کویٔی طہارت کا پانی لے کر چھڑکے وہ بھی اَپنے کپڑے دھوئے اَورجو کویٔی طہارت کے پانی کو چھُوئے وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","ناپاک شخص جِس شَے کو بھی چھُوتا ہے وہ شَے ناپاک ہو جاتی ہے اَور وہ چھُونے والا بھی شام تک ناپاک رہے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","پہلے مہینے میں بنی اِسرائیل کی ساری جماعت صینؔ کے بیابان میں پہُنچی اَور وہ لوگ قادِسؔ میں رہنے لگے۔ اَور مِریمؔ نے وہاں وفات پائی اَور وہیں پر دفن ہُوئی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","وہاں اِسرائیل کے لوگوں کے لیٔے پانی نہ مِلا۔ لہٰذا وہ مَوشہ اَور اَہرونؔ کے خِلاف اِکھٹّے ہُوئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","مَوشہ سے جھگڑا کرکے کہنے لگے، ”کاش ہم بھی اُس وقت ہی مَر گیٔے ہوتے جَب ہمارے بھایٔی یَاہوِہ کے حُضُور مَر گیٔے! ");
INSERT INTO urdoucv_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","تُم یَاہوِہ کی جماعت کو اِس بیابان میں کیوں لے آئے ہو کہ ہم اَور ہمارے مویشی یہاں مَر جایٔیں؟ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","تُم نے ہمیں مِصر سے نکال کر اِس ہولناک جگہ میں کیوں پہُنچا دیا؟ یہاں نہ تو اناج ہے نہ اَنجیر، نہ انگوری باغ ہیں نہ انار۔ یہاں تک کہ پینے کے لیٔے پانی بھی مُیسّر نہیں ہے!“ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","تَب مَوشہ اَور اَہرونؔ جماعت کے پاس سے خیمہ اِجتماع کے دروازہ پر جا کر مُنہ کے بَل گِرے اَور یَاہوِہ کا جلال اُن پر ظاہر ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","اَور یَاہوِہ نے مَوشہ سے کہا: ");
INSERT INTO urdoucv_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","”اُس عصا کو لے لینا اَور تُم اَور تمہارا بھایٔی اَہرونؔ دونوں مِل کر جماعت کو جمع کرو اَور اُن کی آنکھوں کے سامنے اُس چٹّان سے کہو اَور وہ اَپنا پانی اُنڈیل دے گی۔ اِس طرح تُم جماعت کے لیٔے اُس چٹّان سے پانی نکالنا تاکہ وہ اَور اُن کے مویشی پی سکیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","چنانچہ مَوشہ نے یَاہوِہ کے حُضُور ٹھیک اُن کے حُکم کے مُطابق وہ عصا لیا ");
INSERT INTO urdoucv_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","اَور اُس نے اَور اَہرونؔ نے جماعت کو اُس چٹّان کے سامنے جمع کیا اَور مَوشہ نے اُن سے کہا، ”اَے باغیو! سُنو کیا ہم تمہارے لیٔے اِسی چٹّان سے پانی نکالیں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","تَب مَوشہ نے اَپنا ہاتھ اُٹھایا اَور اُس چٹّان پر دو بار عصا مارا اَور پانی بہہ نِکلا، جسے جماعت نے اَور اُن کے مویشیوں نے پیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","لیکن یَاہوِہ نے مَوشہ اَور اَہرونؔ سے کہا، ”چونکہ تُم نے مُجھ پر اِتنا بھروسا نہ رکھا کہ بنی اِسرائیل کے سامنے میری تقدیس اَور میرا اِحترام کرتے اِس لیٔے تُم اِس جماعت کو اُس مُلک میں نہیں پہُنچاؤگے جسے میں اُنہیں دے رہا ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","مریبہؔ کا چشمہ یہی ہے جہاں بنی اِسرائیل نے یَاہوِہ سے جھگڑا کیا تھا اَور وہ اُن کے درمیان پاک ثابت ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","پھر مَوشہ نے قادِسؔ سے اِدُوم کے بادشاہ کے پاس قاصِد روانہ کئے اَور یہ پیغام بھیجا: ”تمہارا بھایٔی اِسرائیل یہ عرض کرتا ہے کہ تُم اُن سَب مُصیبتوں سے واقف ہو جو ہم پر آن پڑی ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ہمارے آباؤاَجداد مِصر میں گیٔے اَور ہم کیٔی سال وہاں رہے۔ مِصریوں نے ہمارے اَور ہمارے آباؤاَجداد کے ساتھ بُرا سلُوک کیا، ");
INSERT INTO urdoucv_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","لیکن جَب ہم نے یَاہوِہ سے فریاد کی تو اُنہُوں نے ہماری سُنی اَور ایک فرشتہ بھیج کر ہمیں مِصر سے نکال لے آئے۔ ”اَب ہم یہاں قادِسؔ شہر میں ہیں جو تمہاری سلطنت کی سرحد پر واقع ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","اَے بادشاہ لہٰذا مہربانی فرما کر ہمیں اَپنے مُلک سے ہوکر جانے کی اِجازت دیں۔ ہم کسی کھیت یا انگوری باغ میں سے ہوکر نہیں گزریں گے اَور نہ کسی کنوئیں کا پانی پیئیں گے۔ ہم شاہراہ سے ہوتے ہویٔے سفر کریں گے اَور جَب تک تمہاری سلطنت سے باہر نہ نکل جایٔیں تَب تک داہنے یا بائیں ہاتھ نہیں مُڑیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","لیکن اِدُومیوں نے جَواب دیا: ”تُم یہاں سے ہوکر جانے نہ پاؤگے اَور اگر تُم نے کوشش کی تو ہم نکل کر تلوار سے تُم پر حملہ کریں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","اِسرائیلیوں نے پھر کہلا بھیجا: ”ہم بڑی شاہراہ سے ہوتے ہویٔے چلے جایٔیں گے اَور اگر ہم یا ہمارے مویشی تمہارا پانی پیئیں تو اُس کا دام دیں گے۔ ہم صِرف پیدل چلے جانا چاہتے ہیں اَور کچھ نہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","اُنہُوں نے پھر جَواب دیا: ”تُم جانے نہ پاؤگے۔“ تَب اِدُوم بڑی بھاری اَور طاقتور فَوج لے کر اُن کے مُقابلہ کے لیٔے نکل آیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","چونکہ اِدُوم نے بنی اِسرائیل کو اَپنی سلطنت کی حُدوُد میں سے ہوکر جانے کی اِجازت نہ دی، اِس لیٔے اِسرائیلی لوگ پیچھے مُڑ کر دُوسرے راستہ سے چلے گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","تَب بنی اِسرائیل کی ساری جماعت قادِسؔ سے کُوچ کرکے کوہِ ہُورؔ پہُنچی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","اَور اِدُوم کی سرحد کے نزدیک کوہِ ہُورؔ پر یَاہوِہ نے مَوشہ اَور اَہرونؔ سے فرمایا، ");
INSERT INTO urdoucv_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","”اَہرونؔ اَپنے لوگوں میں جا ملے گا۔ وہ اُس مُلک میں داخل نہ ہوں گے جسے میں بنی اِسرائیل کو دے رہا ہُوں کیونکہ تُم دونوں نے مریبہؔ کے چشمہ پر میرے حُکم کے خِلاف بغاوت کی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","لہٰذا تُم اَہرونؔ اَور اُس کے بیٹے الیعزرؔ کو اَپنے ساتھ لے کر کوہِ ہُورؔ کے اُوپر جانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","اَور اَہرونؔ کے کاہِنؔ لباس کو اُتار کر اُس کے بیٹے الیعزرؔ کو پہنا دینا کیونکہ اَہرونؔ اَپنے لوگوں میں جا ملے گا۔ وہ وہیں وفات پایٔےگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","مَوشہ نے یَاہوِہ کے حُکم کے مُطابق عَمل کیا اَور وہ ساری جماعت کی آنکھوں کے سامنے کوہِ ہُورؔ پر چڑھ گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","مَوشہ نے اَہرونؔ کے کپڑے اُتار کر اُس کے بیٹے الیعزرؔ کو پہنا دئیے اَور اَہرونؔ وہیں اُس پہاڑ کی چوٹی پر مَر گیا۔ تَب مَوشہ اَور الیعزرؔ پہاڑ پر سے اُتر آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","اَور جَب ساری جماعت کو خبر ہُوئی کہ اَہرونؔ وفات پا چُکے ہیں تو تمام بنی اِسرائیل کے خاندان کے لوگ تیس دِن تک اُن کے لیٔے ماتم کرتے رہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","جَب عَرادؔ کے کنعانی بادشاہ نے جو نِیگیوؔ میں رہتا تھا سُنا کہ اِسرائیل اتھارِمؔ کی راہ سے آ رہاہے تو اُس نے اِسرائیلیوں پر حملہ کیا اَور اُن میں سے کیٔی ایک کو اسیر کر لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","تَب اِسرائیل نے یَاہوِہ کے حُضُور یہ مَنّت مانی: ”اگر آپ اِن لوگوں کو ہمارے ہاتھ میں کر دیں تو ہم اُن کے شہروں کو تباہ کر دیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","یَاہوِہ نے اِسرائیل کی فریاد سُنی اَور کنعانیوں کو اُن کے حوالہ کر دیا۔ اُنہُوں نے اُنہیں اَور اُن کے شہروں کو مُکمّل طور پر تباہ کر دیا۔ اِس لیٔے اُس جگہ کا نام حُرمہؔ رکھا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","پھر اُنہُوں نے کوہِ ہُورؔ سے کُوچ کرکے بحرِقُلزمؔ کی راہ لی تاکہ مُلک اِدُوم کے باہر گھُوم کر جایٔیں لیکن وہ لوگ راستہ میں عاجز آ گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","وہ خُدا اَور مَوشہ کے خِلاف بکنے لگے اَور کہا، ”تُم ہمیں مِصر سے نکال کر بیابان میں مرنے کے لیٔے کیوں لے آئے؟ یہاں نہ تو روٹی ہے نہ پانی! اَور ہم اِس نکمّی خُوراک سے بھی عاجز آ چُکے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","تَب یَاہوِہ نے اُن لوگوں کے درمیان زہریلے سانپ بھیجے؛ سانپوں نے لوگوں کو کاٹا اَور بہت سے اِسرائیلی مَر گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","تَب وہ لوگ مَوشہ کے پاس آکر کہنے لگے، ”ہم نے گُناہ کیا ہے کہ ہم نے یَاہوِہ کے حُضُور اَور تمہارے خِلاف زبان درازی کی۔ دعا کرو، یَاہوِہ اِن سانپوں کو ہم سے دُور کر دیں۔“ چنانچہ مَوشہ نے اُن لوگوں کے لیٔے دعا کی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","یَاہوِہ نے مَوشہ سے کہا، ”ایک سانپ بنا لینا اَور اُسے کھمبے پر لٹکانا اَور سانپ کا ڈسا ہُوا جو کویٔی بھی فرد اُسے دیکھ لے گا وہ زندہ بچے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","چنانچہ مَوشہ نے کانسے کا ایک سانپ بنا کر اُسے کھمبے پر لٹکا دیا؛ تَب جَب کبھی کسی کو سانپ ڈس لیتا اَور وہ اُس کانسے کے سانپ کی طرف دیکھتا تو زندہ بچ جاتا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","پھر اِسرائیلیوں نے کُوچ کیا اَور اوبُوتؔ میں آکر خیمہ زن ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","اَور اوبُوتؔ سے کُوچ کیا اَور عیّے عباریمؔ میں خیمہ زن ہویٔے جو مشرق کی جانِب مُوآب کے سامنے بیابان میں ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","وہاں سے کُوچ کرکے وہ وادی زیِریؔد میں خیمہ زن ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","وہاں سے کُوچ کرکے وہ دریائے ارنُونؔ کے کنارے پر خیمہ زن ہویٔے جو اُس بیابان میں سے گزرتی ہے اَورجو امُوریوں کے علاقہ میں اَندر تک پھیلا ہُواہے۔ دریائے ارنُونؔ مُوآب اَور امُوریوں کے درمیان مُوآب کی سرحد ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","اِس لیٔے یَاہوِہ کے جنگ نامہ میں یُوں لِکھّا ہے: ”واہیبؔ جو سُوفہؔ میں ہے اَور ارنُونؔ کی وادیوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","اَور اُن وادیوں کے ڈھلان جو عاؔر کے مقام تک پھیلے ہویٔے ہیں اَور مُوآب کی سرحد سے مُتّصِل ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","پھر وہاں سے بیرؔ تک اُنہُوں نے اَپنا سفر جاری رکھا۔ یہ وُہی کنواں ہے جہاں یَاہوِہ نے مَوشہ سے کہاتھا، ”لوگوں کو جمع کرنا اَور مَیں اُنہیں پانی دُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","تَب اِسرائیل نے یہ نغمہ گایا: ”اَے کنوئیں تُو اُبل آ! اُس کے لیٔے گاؤ، ");
INSERT INTO urdoucv_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","اُس کنوئیں کے لیٔے جسے شہزادوں نے تعمیر کیا اَور قوم کے اُمرا نے اَپنے عصائے شاہی اَور عصاؤں سے کھودا۔“ تَب وہ اُس بیابان سے متنّہؔ کو گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","اَور متنّہؔ سے نحلی ایل کو اَور نحلی ایل سے باموت کو، ");
INSERT INTO urdoucv_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","اَور باموت سے مُوآب کی اُس وادی میں آئے جہاں پِسگہؔ کی چوٹی پر سے یشیمونؔ یعنی بنجر علاقہ نظر آتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","تَب اِسرائیل نے امُوریوں کے بادشاہ سیحونؔ کے پاس قاصِد روانہ کرکے یہ پیغام بھیجا: ");
INSERT INTO urdoucv_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","”بادشاہ ہمیں اَپنے مُلک میں سے ہوکر جانے دیں۔ ہم مُڑ کر کھیتوں یا تاکستانوں میں نہیں گھُسیں گے اَور نہ ہی کنوؤں کا پانی پیئیں گے۔ اَور جَب تک تمہارے مُلک سے گزر نہ جایٔیں سیدھے شاہراہ پر ہی چلتے رہیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","لیکن سیحونؔ نے اِسرائیل کو اَپنے مُلک میں سے ہوکر جانے نہ دیا بَلکہ اَپنے تمام فَوج کو جمع کرکے اِسرائیل کے مُقابلہ کے لیٔے بیابان میں نکل آئے اَور جَب وہ یاہضؔ کو پہُنچے تو اِسرائیل سے لڑے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","البتّہ اِسرائیل نے اُسے تلوار سے مار ڈالا اَور اُس کے مُلک پر ارنُونؔ سے لے کر یبّوقؔ تک جہاں بنی عمُّون کی سرحد ہے قبضہ کر لیا کیونکہ اُن کی سرحد مضبُوط تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","اِسرائیل نے حِشبونؔ اَور اُس کے اِردگرد کی بستیوں سمیت امُوریوں کے سَب شہروں پر قبضہ کر لیا اَور اُن میں بس گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","حِشبونؔ امُوریوں کے بادشاہ سیحونؔ کا شہر تھا جِس نے مُوآب کے پہلے بادشاہ سے لڑ کر ارنُونؔ تک اُس کا سارا مُلک اُس سے چھین لیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","اِس لیٔے شعرا کہتے ہیں: ”حِشبونؔ کو آؤ، ہم اِس کو مضبُوطی سے تعمیر کریں گے۔ سیحونؔ کا شہر مضبُوط بُنیادوں پر قائِم ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","”حِشبونؔ سے آگ نکلی یعنی سیحونؔ کے شہر سے شُعلہ بھڑکا جِس نے مُوآب کے عاؔر کو اَور ارنُونؔ کے اُونچے مقامات کے اُمرا کو بھسم کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","اَے مُوآب! تُجھ پر افسوس! اَے کموشؔ کے لوگو تُم تباہ ہو گئے! اُس نے اَپنے بیٹوں کو بھگوڑوں اَور اَپنی بیٹیوں کو اسیروں کی مانند امُوریوں کے بادشاہ سیحونؔ کے حوالہ کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","”لیکن ہم نے اُن کا تختہ اُلٹ دیا ہے؛ حِشبونؔ دیبونؔ سمیت تباہ ہو گیا ہے اَور ہم نے اُنہیں نُپاحؔ تک جو میدباؔ تک پھیلا ہُواہے اُجاڑ دیا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","اِس طرح بنی اِسرائیل امُوریوں کے مُلک میں بس گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","مَوشہ نے یعزیرؔ کا جائزہ لینے کے لیٔے جاسُوس بھیجے اَور پھر بنی اِسرائیل نے اُس کے اِردگرد کے قصبوں پر قبضہ کر لیا اَور امُوریوں کو وہاں سے نکال دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","پھر وہ باشانؔ کے راستہ سے آگے بڑھے اَور باشانؔ کا بادشاہ عوگؔ اَپنے سارے لشکر کے ساتھ نکل کر ادرعیؔ کے مقام پر اُن سے جنگ کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","یَاہوِہ نے مَوشہ سے فرمایا، ”اُس سے خوفزدہ مت ہو کیونکہ مَیں نے اُسے اُس کے سارے لشکر اَور اُس کے مُلک سمیت تمہارے حوالہ کر دیا ہے۔ لہٰذا جَیسا تُم نے امُوریوں کے بادشاہ سیحونؔ کے ساتھ کیا، جو حِشبونؔ میں حُکمراں تھا وَیسا ہی اُس کے ساتھ بھی کرنا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","چنانچہ اُنہُوں نے اُسے اُس کے بیٹوں اَور اُس کے سارے لشکر کو یہاں تک مارا کہ اُن میں سے کویٔی نہ بچا اَور اُنہُوں نے اُس کے مُلک پر قبضہ کر لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","تَب بنی اِسرائیل نے مُوآب کے میدانوں کی طرف کُوچ کیا اَور وہ یریحوؔ کے مقابل دریائے یردنؔ کے پار خیمہ زن ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","بنی اِسرائیل نے امُوریوں کے ساتھ جو کچھ کیا تھا وہ سَب بلقؔ بِن صِفُورؔ نے دیکھا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","اِس لیٔے مُوآب نہایت خوفزدہ ہُوا کیونکہ اُن لوگوں کی تعداد بہت زِیادہ تھی۔ سَو مُوآبی بنی اِسرائیل کی وجہ سے بےحد پریشان ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","چنانچہ مُوآبیوں نے مِدیانی بُزرگوں سے کہا، ”یہ گِروہ ہمارے آس پاس کی ہر شَے کو اَیسے چٹ کر جائے گا جَیسے کویٔی بَیل کھیت کی گھاس کو چٹ کر جاتا ہے۔“ چنانچہ بلقؔ بِن صِفُورؔ نے جو اُن دِنوں مُوآب کا بادشاہ تھا، ");
INSERT INTO urdoucv_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","بِلعاؔم بِن بعورؔ کو بُلانے کے لیٔے اُس کے پاس قاصِد بھیجے جو بڑے دریا کے کنارے واقع اَپنی جائے رہائش پتھورؔ میں تھا۔ بلقؔ نے کہلا بھیجا: ”ایک قوم مِصر سے نکل کر آئی ہے؛ جِس کے لوگوں سے مُلک کی سطح چھُپ گئی ہے اَور اَب وہ میرے مقابل جم گیٔے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","لہٰذا تُم آکر اُن لوگوں پر لعنت کرنا کیونکہ وہ مُجھ سے زِیادہ قوی ہیں۔ تَب شاید میں اُنہیں شِکست دے کر مُلک سے باہر نکال سکوں، کیونکہ مَیں جانتا ہُوں کہ جنہیں آپ برکت دیتے ہیں اُنہیں برکت ملتی ہے اَور جِن پر آپ لعنت کرتے ہیں وہ ملعُون ہوتے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","چنانچہ مُوآبی اَور مِدیانی بُزرگ اَپنے ساتھ فال کھولنے کی اُجرت لے کر روانہ ہویٔے۔ جَب وہ بِلعاؔم کے پاس پہُنچے تو اُسے بلقؔ کا پیغام دے دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","بِلعاؔم نے اُن سے کہا، ”تُم رات یہیں گُزارو اَور یَاہوِہ مُجھے جو جَواب دیں گے اُسے مَیں تمہارے پاس لے آؤں گا۔“ چنانچہ مُوآب کے حاکم بِلعاؔم کے ہاں ٹھہر گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","خُدا نے بِلعاؔم کے پاس آکر پُوچھا، ”تمہارے ساتھ یہ کون آدمی ہیں؟“ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","بِلعاؔم نے خُدا سے کہا، ”مُوآب کے بادشاہ بلقؔ بِن صِفُورؔ نے میرے پاس یہ پیغام بھیجا ہے: ");
INSERT INTO urdoucv_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","’جو قوم مِصر سے نکل آئی ہے اُس کے لوگوں سے مُلک کی سطح چھُپ گئی ہے۔ لہٰذا تُم آکر میری خاطِر اُن پر لعنت کرنا۔ تَب شاید میں اُن سے جنگ کرکے اُنہیں نکال سکوں۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","لیکن خُدا نے بِلعاؔم سے کہا، ”تُو اُن کے ساتھ مت جا اَور نہ ہی اُن لوگوں پر لعنت کر کیونکہ وہ مُبارک ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","بِلعاؔم نے صُبح کو اُٹھ کر بلقؔ کے حاکم سے کہا، ”تُم اَپنے مُلک کو لَوٹ جاؤ کیونکہ یَاہوِہ مُجھے تمہارے ساتھ جانے کی اِجازت نہیں دیتے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","چنانچہ مُوآبی حاکم بلقؔ کے پاس لَوٹ آئے اَور کہا، ”بِلعاؔم نے ہمارے ساتھ آنے سے اِنکار کر دیا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","تَب بلقؔ نے دُوسرے حاکم روانہ کئے جو تعداد میں زِیادہ اَور پہلوں سے زِیادہ مُعزّز تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","وہ بِلعاؔم کے پاس آئے اَور کہا: ”بلقؔ بِن صِفُورؔ نے یُوں کہا ہے، ’میرے پاس آنے سے مت جِھجک، ");
INSERT INTO urdoucv_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","کیونکہ مَیں تُمہیں نہایت فیّاضی سے صِلہ دُوں گا اَورجو کچھ آپ مُجھ سے کہیں گے میں وُہی کروں گا۔ لہٰذا تُم آؤ اَور میری خاطِر اُن لوگوں پر لعنت کرنا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","لیکن بِلعاؔم نے اُنہیں جَواب دیا، ”چاہے بلقؔ اَپنے محل میں جِتنا چاندی اَور سونا مُجھے دے تَب بھی میں اَپنے یَاہوِہ خُدا کے حُکم سے تجاوُز نہیں کر سَکتا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","لہٰذا تُم اُن لوگوں کی طرح آج کی رات یہیں قِیام کرو تَب میں دیکھوں گا کہ یَاہوِہ مُجھ سے اَور کیا کہتے ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","اُس رات خُدا بِلعاؔم کے پاس آئے اَور کہا، ”چونکہ یہ آدمی تُجھے بُلانے آئے ہیں لہٰذا تُو اُن کے ساتھ چلا جا لیکن جو مَیں تُجھ سے کہُوں وُہی کرنا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","چنانچہ بِلعاؔم صُبح کو اُٹھا اَور اَپنی گدھی پر زین کسا اَور مُوآبی حاکم کے ہمراہ چل دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","لیکن جَب وہ گیا تو خُدا کا قہر بھڑک اُٹھا اَور یَاہوِہ کا فرشتہ اُس کی مزاحمت کرنے کے لیٔے راستہ روک کر کھڑا ہو گیا۔ بِلعاؔم اَپنی گدھی پر سوار تھا اَور اُس کے دو خادِم اُس کے ہمراہ تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","جَب اُس گدھی نے یَاہوِہ کے فرشتہ کو اَپنے ہاتھ میں ننگی تلوار لیٔے راستہ روکے کھڑا دیکھا تو وہ راستہ سے ہٹ کر کھیت میں چلی گئی۔ تَب بِلعاؔم نے اُسے مارا تاکہ اُسے راستہ پر واپس لے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","تَب یَاہوِہ کا فرشتہ دو تاکستانوں کے درمیان ایک تنگ پگڈنڈی پر جا کر کھڑا ہو گیا جِس کے دونوں طرف دیواریں تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","جَب اُس گدھی نے یَاہوِہ کے فرشتہ کو دیکھا تو وہ دیوار سے اَیسی چپک گئی کہ بِلعاؔم کا پاؤں دیوار سے ٹکرا گیا۔ چنانچہ اُس نے اُسے پھر مارا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","تَب یَاہوِہ کا فرشتہ آگے بڑھ کر ایک اَیسے تنگ مقام میں کھڑا ہو گیا جہاں داہنی یا بائیں طرف مُڑنے تک کی جگہ نہ تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","جَب اُس گدھی نے یَاہوِہ کے فرشتہ کو دیکھا تو وہ بِلعاؔم کو لیٔے ہویٔے بیٹھ گئی۔ وہ اِس قدر خفا ہُوا کہ اُسے اَپنی لاٹھی سے مارا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","تَب یَاہوِہ نے گدھی کا مُنہ کھولا اَور اُس نے بِلعاؔم سے کہا، ”مَیں نے تیرے ساتھ کیا کیا ہے جو تُونے مُجھے تین بار مارا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","بِلعاؔم نے گدھی کو جَواب دیا، ”تُونے مُجھے بےوقُوف بنایا! اگر میرے ہاتھ میں تلوار ہوتی تو مَیں تُجھ کو اِسی وقت مار ڈالتا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","گدھی نے بِلعاؔم سے کہا، ”کیا میں تیری وُہی گدھی نہیں ہُوں جِس پر تُو آج تک سوار ہوتا آیا ہے؟ کیا مَیں نے تیرے ساتھ پہلے کبھی اَیسا کیا ہے؟“ اُس نے کہا، ”نہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","تَب یَاہوِہ نے بِلعاؔم کی آنکھیں کھولیں اَور اُس نے یَاہوِہ کے فرشتہ کو ہاتھ میں ننگی تلوار لیٔے ہویٔے راہ میں کھڑا دیکھا۔ چنانچہ وہ جھُک کر مُنہ کے بَل گرا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","یَاہوِہ کے فرشتہ نے اُس سے پُوچھا، ”تُونے اَپنی گدھی کو تین بار کیوں مارا؟ مَیں تُجھ سے مزاحمت کرنے اِس لیٔے یہاں آیا ہُوں کہ تیری چال میری نظر میں ٹیڑھی ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","اِس گدھی نے مُجھے دیکھا اَور تین بار میرے سامنے سے ہٹ گئی۔ اگر وہ نہ ہٹتی تو یقیناً تُجھ کو تو میں مار ہی ڈالتا لیکن اُسے جیتی چھوڑ دیتا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","بِلعاؔم نے یَاہوِہ کے فرشتہ سے کہا، ”مَیں نے گُناہ کیا ہے۔ میں نہیں جانتا تھا کہ تُو میرا راستہ روکے کھڑا ہے۔ لیکن اگر تُجھے ناگوار گزرتا ہو تو میں واپس چلا جاتا ہُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","یَاہوِہ کے فرشتہ نے بِلعاؔم سے کہا، ”تُو اِن آدمیوں کے ساتھ چلا جا لیکن وُہی بات کہنا جو مَیں تُجھ سے کہُوں۔“ لہٰذا بِلعاؔم بلقؔ کے حاکم کے ساتھ چلا گیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","جَب بلقؔ نے سُنا کہ بِلعاؔم آ رہاہے تو وہ اُس کے اِستِقبال کے لیٔے مُوآب کے اُس شہر تک گیا جو ارنُونؔ کی سرحد پر اُس کے مُلک کے آخِری کنارے پر ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","بلقؔ نے بِلعاؔم سے کہا، ”مَیں نے تُجھے فوراً بُلایا تھا۔ تُونے آنے میں اِتنی تاخیر کیوں کی؟ کیا مَیں تُجھے صِلہ دینے کے قابل نہ تھا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","بِلعاؔم نے بلقؔ سے کہا، ”اَب تو مَیں تمہارے پاس آ ہی چُکا ہُوں۔ لیکن اَپنی طرف سے کچھ نہیں کہہ سَکتا؟ جو بات خُدا میرے مُنہ میں ڈالیں گے میں وُہی کہُوں گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","تَب بِلعاؔم بلقؔ کے ساتھ ہو لیا اَور وہ قِریت حُصاتؔ پہُنچ گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","بلقؔ نے مویشی اَور بھیڑوں کی قُربانیاں پیش کیں اَور کچھ گوشت بِلعاؔم اَور اُن اہلکاروں کو دیا جو اُس کے ساتھ تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","دُوسرے دِن صُبح کو بلقؔ بِلعاؔم کو باموت بَعل کو عبادت کے مقام پر لے گیا اَور وہاں اُوپر سے اُس نے اِسرائیلی چھاؤنی کے بیرونی حِصّہ کو دُور دُور تک دیکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","بِلعاؔم نے بلقؔ سے کہا، ”میرے لیٔے یہاں سات مذبحے تعمیر کرو اَور میرے لیٔے سات بَیل اَور سات مینڈھے بھی تیّار رکھو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","بلقؔ نے بِلعاؔم کے کہنے کے مُطابق کیا اَور اُن دونوں نے ہر مذبح پر ایک ایک بَیل اَور ایک ایک مینڈھا قُربان کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","تَب بِلعاؔم نے بلقؔ سے کہا، ”تُم اَپنی سوختنی نذر کے پاس کھڑے رہو جَب تک میں جاتا ہُوں۔ شاید یَاہوِہ مُجھ سے مُلاقات کرنے آئیں۔ وہ جو کچھ مُجھ پر ظاہر کریں گے میں تُمہیں بتاؤں گا۔“ پھر وہ ایک برہنہ ٹیلے پر جا چڑھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","وہاں خُدا بِلعاؔم سے مِلے اَور بِلعاؔم نے کہا، ”مَیں نے سات مذبحے بنائے ہیں اَور ہر مذبح پر ایک ایک بَیل اَور ایک ایک مینڈھا چڑھایا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","تَب یَاہوِہ نے بِلعاؔم کے مُنہ میں اَپنا کلام ڈالا اَور کہا، ”بلقؔ کے پاس لَوٹ جا اَور اُسے میرا پیغام پہُنچا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","چنانچہ وہ اُس کے پاس لَوٹ کر آیا اَور اُسے مُوآب کے سَب حاکم سمیت اَپنی سوختنی نذر کے پاس کھڑا پایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","تَب بِلعاؔم نے اَپنا پیغام بَیان کیا: ”بلقؔ نے مُجھے ارام سے، یعنی شاہِ مُوآب نے، مُجھے مشرقی پہاڑوں سے بُلوایا۔ اَور فرمایا، ’آ جاؤ اَور میری طرف سے یعقوب پر لعنت بھیجو؛ آ جاؤ اَور اِسرائیل کو دھمکاؤ۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","میں اُن پر لعنت کیسے کروں، جِن پر خُدا نے لعنت نہیں کی؟ میں اُنہیں کیسے دھمکی دُوں، جنہیں یَاہوِہ نے دھمکی نہیں دی؟ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","چٹّانوں کی چوٹیوں پر سے وہ مُجھے نظر آتے ہیں، اَور پہاڑوں کی اُونچائی سے اُنہیں دیکھتا ہُوں۔ میں اَیسی قوم کو دیکھ رہا ہُوں جو الگ رہتی ہے اَور دُوسری قوموں میں اَپنا شُمار نہیں کرتی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","یعقوب کی خاک کے ذرّوں کو کون گِن سَکتا ہے یا اِسرائیل کے چوتھے حِصّہ کو کون شُمار کر سَکتا ہے؟ کاش میں راستبازوں کی موت مروں اَور میرا اَنجام بھی اُن ہی کی مانند ہو!“ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","بلقؔ نے بِلعاؔم سے کہا، ”تُونے میرے ساتھ یہ کیا کیا؟ مَیں نے تُجھے اَپنے دُشمنوں پر لعنت کرنے کے لیٔے بُلایا لیکن تُونے اُنہیں برکت دینے کے سِوا کچھ نہ کیا!“ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","اُس نے جَواب دیا، ”کیا میں وہ بات نہ کہُوں جو یَاہوِہ نے میرے مُنہ میں ڈالی ہے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","تَب بلقؔ نے بِلعاؔم سے کہا، ”اَب میرے ساتھ دُوسری جگہ چلو جہاں سے تُم اُن کو دیکھ سکوگے۔ تُم اُن سَب کو تو نہیں لیکن اُن چھاؤنی کے بیرونی حِصّہ کو دیکھ پاؤگے اَور وہاں سے تُم اُن پر میری خاطِر لعنت کرنا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","چنانچہ وہ اُسے پِسگہؔ کی چوٹی پر ضوفیمؔ کے میدان میں لے گیا اَور وہاں اُس نے سات مذبحے بنائے اَور ہر مذبح پر ایک ایک بَیل اَور ایک ایک مینڈھا چڑھایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","بِلعاؔم نے بلقؔ سے کہا، ”تُم یہاں اَپنی سوختنی نذر کے پاس ٹھہرے رہو جَب تک کہ میں وہاں یَاہوِہ سے مِل لُوں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","اَور یَاہوِہ بِلعاؔم سے ملے اَور اُنہُوں نے اُس کے مُنہ میں اَپنا کلام ڈالا اَور کہا، ”بلقؔ کے پاس لَوٹ جا اَور اُسے یہ پیغام پہُنچا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","چنانچہ وہ اُس کے پاس لَوٹ آیا اَور اُسے مُوآب کے حاکم سمیت اَپنی سوختنی نذر کے پاس کھڑا پایا۔ بلقؔ نے اُس سے پُوچھا، ”یَاہوِہ نے کیا کہا ہے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","تَب اُس نے اَپنا پیغام بَیان کیا: ”اُٹھ اَے بلقؔ اَور سُن؛ اَے اِبن صِفُورؔ! میری بات پر کان لگا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","خُدا اِنسان نہیں کہ جھُوٹ بولیں، اَور نہ وہ آدمؔ زاد ہے کہ اَپنا اِرادہ بدلے۔ کیا جو کچھ وہ کہتے ہیں اُس پر عَمل نہیں کرتے؟ اَورجو وعدہ کرتے ہیں اُسے پُورا نہیں کرتے؟ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","مُجھے تو برکت دینے کا حُکم مِلا ہے؛ وہ برکت دے چُکے ہیں اَور مَیں اُسے ردّ نہیں کر سَکتا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","”یعقوب میں کویٔی بدبختی نہیں پائی جاتی، اَور نہ اِسرائیل کی تباہی اُن کی نظر میں ہے۔ یَاہوِہ اُن کا خُدا اُن کے ساتھ ہے؛ اَور بادشاہ کی للکار اُن کے درمیان ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","خُدا اُنہیں مِصر سے نکال کر لائے ہیں؛ اَور اُن میں جنگلی سانڈ کی سِی طاقت ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","یعقوب کے خِلاف کویٔی سحر نہیں چلتا، اَور نہ اِسرائیل کے خِلاف فالگیری ہو سکتی ہے۔ بَلکہ یعقوب اَور اِسرائیل کے حق میں اَب یہ کہا جائے گا، ’دیکھو خُدا نے کیسے عجِیب کام کئے ہیں۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","یہ لوگ شیرنی کی مانند اُٹھتے ہیں، اَور اَپنے آپ کو اُس شیر کی مانند تن کر کھڑا رکھتے ہیں جو اُس وقت تک نہیں سُستاتا جَب تک کہ اَپنا شِکار نہ کھالے اَور اَپنے مقتولوں کا خُون نہ پی لے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","تَب بلقؔ نے بِلعاؔم سے کہا، ”تُم اُن پر نہ تو لعنت کرنا، نہ ہی اُنہیں برکت دینا!“ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","بِلعاؔم نے بلقؔ کو جَواب دیا، ”کیا مَیں نے تُمہیں نہیں بتایا کہ میں وُہی کروں گا جو یَاہوِہ فرمائیں گے؟“ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","تَب بلقؔ نے بِلعاؔم سے کہا، ”اَچھّا مَیں تُجھے ایک اَور جگہ لے چلتا ہُوں۔ شاید خُدا کو پسند آئے کہ تُو میری خاطِر وہاں سے اُن پر لعنت کرے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","اَور بلقؔ بِلعاؔم کو پعورؔ کی چوٹی پر لے گیا جہاں سے بنجر علاقہ نظر آتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","بِلعاؔم نے بلقؔ سے کہا، ”میرے لیٔے یہاں سات مذبحے بنا اَور سات بَیل اَور سات مینڈھے تیّار کر۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","بلقؔ نے بِلعاؔم کے کہنے کے مُطابق کیا اَور ہر مذبح پر ایک بَیل اَور ایک مینڈھا چڑھایا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","جَب بِلعاؔم نے دیکھا کہ یَاہوِہ کی رضا یہی ہے کہ وہ اِسرائیل کو برکت دے تو اُس نے فالگیری دیکھنے کی پرانی عادت چھوڑکر اَپنا مُنہ بیابان کی طرف موڑا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","جَب بِلعاؔم نے نگاہ کی اَور دیکھا کہ بنی اِسرائیل قبیلہ بہ قبیلہ چھاؤنی ہیں تو خُدا کی رُوح اُس پر نازل ہُوئی ");
INSERT INTO urdoucv_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","اَور اُس نے اَپنا پیغام بَیان کیا: ”بِلعاؔم بِن بعورؔ کی نبُوّت، اُس کی الہامی تقریر جِس کی آنکھ رَوشن ہے، ");
INSERT INTO urdoucv_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","بَلکہ یہ اُسی کی الہامی تقریر ہے جو خُدا کا کلام سُنتا ہے، جو سَجدہ میں گرا ہُوا اَپنی بینا آنکھوں سے قادرمُطلق کی رُویا دیکھتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","”اَے یعقوب تیرے خیمے اَور اَے بنی اِسرائیل تمہاری قِیام گاہیں کیا ہی خُوبصورت ہیں! ");
INSERT INTO urdoucv_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","”وہ وادیوں کی طرح پھیلے ہویٔے ہیں، گویا لبِ دریا کے باغیچے، جو یَاہوِہ کے لگائے ہویٔے عُود کے درخت، اَور دریاؤں کے کنارے کے دیودار۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","اُن کی نمدار شاخوں سے بوندیں ٹپکیں گی؛ اَور اُن کی جڑوں کو کثرت سے پانی ملے گا۔ ”اُن کا بادشاہ اَگاگؔ سے بھی عظیم تر ہوگا؛ اَور اُن کی سلطنت عروج پایٔے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","”خُدا اُنہیں مِصر سے نکال لایا؛ اُن میں جنگلی سانڈ کی سِی طاقت ہے۔ وہ مُخالف قوموں کو کھا جاتے ہیں اَور اُن کی ہڈّیوں کو چُورچُور کر دیتے ہیں؛ اَور اَپنے تیروں سے اُن کو چھید ڈالتے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","وہ شیر کی طرح تاک لگا کر بیٹھ جاتے ہیں، بَلکہ شیرنی کی طرح۔ اَب اُنہیں کون چھیڑے؟ ”جو تُمہیں برکت دیں وہ برکت پائیں اَورجو تُجھ پر لعنت کریں وہ ملعُون ہُوں!“ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","تَب بلقؔ کا غُصّہ بِلعاؔم پر بھڑکا۔ اُس نے اَپنے ہاتھ پر ہاتھ مارا اَور اُس سے کہا، ”مَیں نے تُجھے اَپنے دُشمنوں پر لعنت کرنے کے لیٔے بُلایا لیکن تینوں بار تُونے اُنہیں برکت پر برکت دی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","اَب تُو اِسی وقت رخصت ہو اَور اَپنے گھر چلا جا! مَیں نے کہاتھا کہ مَیں تُجھے فیّاضی سے صِلہ دُوں گا لیکن یَاہوِہ نے تُجھے اِس صِلہ سے محروم رکھا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","بِلعاؔم نے بلقؔ کو جَواب دیا، ”کیا مَیں نے اُن قاصِدوں سے جنہیں تُونے میرے پاس بھیجا تھا یہ نہ کہاتھا، ");
INSERT INTO urdoucv_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","’اگر بلقؔ اَپنے محل میں جِتنا چاندی اَور سونا مُجھے دے تَب بھی میں اَپنی طرف سے بھلا یا بُرا کچھ بھی نہیں کر سَکتا۔ جو یَاہوِہ کے حُکم کے خِلاف ہو، بَلکہ جو کچھ یَاہوِہ کہیں گے میں وُہی کہُوں گا‘؟ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","اَب مَیں اَپنی اُمّت کے پاس لَوٹ کر جاتا ہُوں لیکن دیکھ میں تُمہیں جتائے دیتا ہُوں کہ یہ لوگ آنے والے دِنوں میں تمہاری قوم کے ساتھ کیسا سلُوک کریں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","تَب اُس نے اَپنا پیغام بَیان کیا: ”بِلعاؔم بِن بعورؔ کی نبُوّت، اُس کی نبُوّت جِس کی آنکھ رَوشن ہے، ");
INSERT INTO urdoucv_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","بَلکہ یہ اُسی کی نبُوّت ہے جو خُدا کا کلام سُنتا ہے، اَور خُداتعالیٰ کا عِرفان رکھتا ہے، جو سَجدہ میں گرا ہُوا اَپنی بینا آنکھوں سے قادرمُطلق کی رُویا دیکھتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","”میں اُسے دیکھوں گا، پر ابھی نہیں؛ وہ مُجھے نظر بھی آئے گا، پر نزدیک سے نہیں۔ یعقوب سے ایک ستارہ نکلے گا؛ اَور اِسرائیل میں سے ایک عصائے شاہی بُلند ہوگا۔ وہ مُوآب کی پیشانیوں کو اَور شیتؔ کے سَب بیٹوں کی کھوپڑیوں کو کُچل دے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","اِدُوم مغلُوب ہوگا؛ اَور اُس کا دُشمن، سِعِیؔر بھی مغلُوب ہوگا، لیکن اِسرائیل تقویّت پاتا جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","یعقوب کی نَسل میں سے ایک شہزادہ برپا ہوگا جو شہر کے باقی بچے لوگوں کو تباہ کر ڈالے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","تَب بِلعاؔم نے عمالیقؔ کی طرف نگاہ کی اَور یہ پیغام بَیان کیا: ”عمالیقؔ قوموں میں اوّل تو تھا، لیکن آخِرکار اُس کا اَنجام تباہی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","تَب اُس نے قینیوں کی طرف دیکھا اَور یہ پیغام بَیان کیا: ”تمہاری قِیام گاہ محفوظ ہے، اَور تمہارا آشیانہ چٹّان میں بنا ہُواہے؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","پھر بھی اَے قینیو جَب اشُور تُمہیں اسیر کرےگا تَب تُم تباہ ہو جاؤگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","تَب اُس نے اَپنا پیغام جاری رکھا: ”ہائے افسوس! اگر خُدا کی مرضی نہ ہو تو کون زندہ بچے گا؟ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","کِتّیمؔ کے ساحِلوں سے جہاز آئیں گے؛ اَور وہ اشُور اَور عِبرؔ دونوں پر قبضہ کر لیں گے، لیکن وہ بھی تباہ ہو جایٔیں گے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","تَب بِلعاؔم اُٹھ کر گھر لَوٹا اَور بلقؔ نے اَپنی راہ لی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","اِسرائیلی شِطِّیمؔ میں رہتے تھے اَور لوگوں نے اُن مُوآبی عورتوں کے ساتھ حرام کاری شروع کر دی، ");
INSERT INTO urdoucv_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","جو اُنہیں اَپنے معبُودوں کی قُربانیوں میں آنے کی دعوت دیتی تھیں۔ یہ لوگ وہاں جا کر کھاتے اَور اُن معبُودوں کو سَجدہ کرتے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","اِس طرح بنی اِسرائیل نے پعورؔ کے بَعل کی عبادت میں شرکت کی اَور یَاہوِہ کا قہر اُن پر بھڑکا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","یَاہوِہ نے مَوشہ سے کہا: ”اِن لوگوں کے سَب سربراہوں اَور سرغنوں کو لے کر قتل کر اَور اُنہیں یَاہوِہ کے حُضُور دِن کی رَوشنی میں ٹانگ دینا تاکہ یَاہوِہ کا قہرِ شدید بنی اِسرائیل پر سے ٹل جائے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","چنانچہ مَوشہ نے اِسرائیل کے حاکموں سے کہا، ”تمہارے جِن جِن آدمیوں نے پعورؔ کے بَعل کی عبادت میں شرکت کی وہ سَب قتل کئے جایٔیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","اَور جَب بنی اِسرائیل کی ساری جماعت خیمہ اِجتماع کے دروازہ پر رو رہی تھی تَب ایک اِسرائیلی مَوشہ اَور سَب لوگوں کی آنکھوں کے سامنے ایک مِدیانی عورت کو اَپنے خاندان میں لے آیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","تَب الیعزرؔ کے بیٹے فِنحاسؔ نے جو اَہرونؔ کاہِنؔ کا پوتا تھا یہ دیکھا تو اُس نے جماعت میں سے اُٹھ کر ہاتھ میں ایک نیزہ لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","اَور اُس اِسرائیلی کے پیچھے پیچھے خیمہ میں داخل ہُوا اَور اُس نے اُس اِسرائیلی مَرد اَور اُس عورت دونوں کے پیٹ میں نیزہ بھونک دیا۔ تَب بنی اِسرائیل پر آئی ہُوئی وَبا جاتی رہی ");
INSERT INTO urdoucv_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","اَور جتنے لوگ وَبا سے مَرے تھے اُن کی تعداد چوبیس ہزار تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","یَاہوِہ نے مَوشہ سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","”الیعزرؔ کے بیٹے فِنحاسؔ نے جو اَہرونؔ کاہِنؔ کا پوتا ہے میرے قہر کو بنی اِسرائیل پر سے ہٹا دیا کیونکہ اُس نے اُن کے درمیان میرے لیٔے اَپنی غیرت کا اَیسا مظاہرہ کیا کہ مَیں نے اَپنی غیرت کے جوش میں اُنہیں نابود نہیں کیا ");
INSERT INTO urdoucv_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","اِس لیٔے اُس سے کہہ کہ میں اُس کے ساتھ اَپنا عہدِ اَمن باندھ رہا ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","وہ اُس کے اَور اُس کی اَولاد کے لیٔے دائمی کہانت کا عہد ہوگا کیونکہ وہ اَپنے خُدا کے واسطے غیرت مند ہُوا اَور اُس نے بنی اِسرائیل کے لیٔے کفّارہ دیا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","اُس اِسرائیلی مَرد کا نام جو اُس مِدیانی عورت کے ساتھ مارا گیا وہ زِمریؔ تھا جو شمعُونؔ کے خاندان کا سردار سالوؔ کا بیٹا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","اَور اُس مِدیانی عورت کا نام جو ماری گئی تھی کوزبیؔ تھا۔ وہ ضُورؔ کی بیٹی تھی جو ایک مِدیانی خاندان کا قبائلی سردار تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","یَاہوِہ نے مَوشہ سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","”مِدیانیوں کو حریف جان کر مار ڈالو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","کیونکہ اُنہُوں نے بھی جَب تُمہیں دھوکا دیا تو حریف ہی جانا جَیسا پعورؔ کے مُعاملہ میں اَور اُن کی بہن کوزبیؔ کے مُعاملہ میں ہُوا جو مِدیانی سردار کی بیٹی تھی اَور اُس وَبا میں جو پعورؔ کے سبب پھیلی تھی ماری گئی تھی۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","وَبا کے بعد یَاہوِہ نے مَوشہ اَور اَہرونؔ کاہِنؔ کے بیٹے الیعزرؔ سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","”بنی اِسرائیل کی ساری جماعت میں بیس سال یا اُس سے زِیادہ عمر کے جتنے لوگ اِسرائیلی لشکر میں خدمت کرنے کے قابل ہُوں اُن سَب کی اُن کے آبائی خاندانوں کے مُطابق مردُم شُماری کرنا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","چنانچہ مَوشہ اَور الیعزرؔ کاہِنؔ مُوآب کے میدانوں میں یردنؔ کے کنارے یریحوؔ کے مقابل اُن سے مُخاطِب ہویٔے اَور کہا: ");
INSERT INTO urdoucv_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","”بیس سال یا اُس سے زِیادہ عمر کے آدمیوں کی مردُم شُماری کرو جَیسا یَاہوِہ نے مَوشہ کو حُکم دیا ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","اِسرائیل کے پہلوٹھے رُوبِنؔ کے بیٹے یہ تھے: حنوخؔ جِس سے حنوخیوں کی برادری چلی؛ پلوّؔ جِس سے پلّویوں کی برادری چلی؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","حِضرونؔ جِس سے حضرونیوں کی برادری چلی؛ اَور کرمی جِس سے کرمیوں کی برادری چلی؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","یہ رُوبِنیوں کی برادری والے تھے اَور اُن میں سے جو شُمار کئے گیٔے اُن کی تعداد 43,730 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","پلوّؔ کا بیٹا اِلیابؔ تھا، ");
INSERT INTO urdoucv_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","اَور اِلیابؔ کے بیٹے نموایل داتنؔ اَور ابیرامؔ ہیں جو جماعت کے نُمائندے تھے جنہوں نے مَوشہ اَور اَہرونؔ کے خِلاف سرکشی کی تھی اَور قورحؔ کے پیروکاروں میں سے تھے جَب اُنہُوں نے یَاہوِہ کے خِلاف سرکشی کی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","زمین نے اَپنا مُنہ کھولا اَور اُنہیں قورحؔ سمیت نگل گئی اَور اُس کے پیروکار اُس وقت مَر گیٔے جَب آگ نے ڈھائی سَو لوگوں کو بھسم کیا اَور وہ ایک عِبرت کا نِشان ٹھہرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","البتّہ قورحؔ کے سارے بیٹے نہیں مَرے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","شمعُونؔ کے بیٹے اَپنی برادریوں کے مُطابق یہ تھے: نموایل جِس سے نموایلیوں کی برادری چلی؛ یمینؔ جِس سے یمینیوں کی برادری چلی؛ یاکِن جِس سے یکینیوں کی برادری چلی؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","زیراحؔ جِس سے زیراحیوں کی برادری چلی؛ اَور شاؤل جِس سے شاؤلیوں کی برادری چلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","یہ بنی شمعُونؔ کی برادری کے تھے۔ اِن میں آدمیوں کی تعداد 22,200 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","گادؔ کے بیٹے اَپنی برادری کے مُطابق یہ تھے: ضِفونؔ جِس سے ضِفونی کی برادری چلی؛ حگّیؔ جِس سے حگّیوں کی برادری چلی؛ شُونی، جِس سے شُونیوں کی برادری چلی؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","اُزنی جِس سے اُزنیوں کی برادری چلی؛ عیری، جِس سے عیریوں کی برادری چلی؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","اَرود، جِس سے اَرودیوں کی برادری چلی؛ اَور اَریلی جِس سے اَریلیوں کی برادری چلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","یہ بنی گادؔ کی برادری کے تھے اَور اُن میں سے جو شُمار کئے گیٔے اُن کی تعداد 40,500 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","عیرؔ اَور اَونانؔ یہُوداہؔ کے بیٹے تھے لیکن وہ مُلکِ کنعانؔ میں مَر گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","یہُوداہؔ کے بیٹے اَپنی برادریوں کے مُطابق یہ تھے: شِلحؔ جِس سے شیلانیوں کی برادری چلی؛ پیریزؔ جِس سے پیریزیوں کی برادری چلی؛ اَور زیراحؔ جِس سے زیراحیوں کی برادری چلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","پیریزؔ کے بیٹے یہ تھے: حِضرونؔ جِس سے حضرونیوں کی برادری چلی؛ حمُولؔ جِس سے حمُولیوں کی برادری چلی؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","یہ یہُوداہؔ کی برادری کے تھے اَور اُن میں سے جو شُمار کئے گیٔے اُن کی تعداد 76,500 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","یِسَّکاؔر کے بیٹے اَپنے برادریوں کے مُطابق یہ تھے: تولعؔ جِس سے تولعیوں کی برادری چلی؛ پُوّہؔ جِس سے پُوّہیوں کی برادری چلی؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","یَعشُوبؔ جِس سے یَعشُوبیوں کی برادری چلی؛ اَور شِمرون جِس سے شِمرونیوں کی برادری چلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","یہ یِسَّکاؔر کی برادری کے تھے۔ اِن میں سے جو شُمار کئے گیٔے اُن کی تعداد 64,300 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","زبُولُون کے بیٹے اَپنی برادریوں کے مُطابق یہ تھے: سرد جِس سے سردیوں کی برادری چلی؛ ایلون جِس سے ایلونیوں کی برادری چلی؛ اَور یحلی ایل جِس سے یحلی ایلی قبیلہ کی برادری چلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","یہ زبُولُونیوں کی برادری کے تھے۔ اِن میں سے جو شُمار کئے گیٔے اُن کی تعداد 60,500 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","یُوسیفؔ کے بیٹے اَپنی برادریوں کے مُطابق منشّہ اَور اِفرائیمؔ تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","منشّہ کے بیٹے یہ تھے: مکیرؔ جِس سے مکیریوں کی برادری چلی (مکیرؔ سے گِلعادؔ پیدا ہُوا تھا)؛ گِلعادؔ سے گِلعادیوں کی برادری چلی؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","گِلعادؔ کے بیٹے یہ ہیں: اِیعزرؔ جِس سے اِیعزریوں کی برادری چلی؛ حِلقؔ جِس سے حِلقیوں کی برادری چلی؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","اَسری ایل، جِس اَسری ایلیوں کی برادری چلی؛ شِکیمؔ جِس سے شِکیمؔی برادری چلی؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","شمیدعؔ جِس سے شمیدعیوں کی برادری چلی؛ اَور حِفرؔ جِس سے حِفریوں کی برادری چلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(ضلافحادؔ بِن حِفرؔ کے ہاں کویٔی بیٹا پیدا نہ ہُوا بَلکہ صِرف بیٹیاں ہی ہُوئیں جِن کے نام محلاہؔ، نوحؔا، حُگلاہؔ، مِلکاہؔ اَور تِرضاؔہ تھے۔) ");
INSERT INTO urdoucv_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","یہ منشّہیوں کی برادری کے تھے۔ اِن میں سے جو شُمار کئے گیٔے اُن کی تعداد 52,700 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","اِفرائیمؔ کے بیٹے اَپنی برادریوں کے مُطابق یہ تھے: شُوتلحؔ جِس سے شُوتلحیوں کی برادری چلی؛ بِکیؔر جِس سے بِکیریوں کی برادری چلی؛ اَور تحنؔ جِس سے تحنیوں کی برادری چلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","شُوتلحؔ کے بیٹے یہ تھے: عیرانؔ جِس سے عیرانیوں کی برادری چلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","یہ بنی اِفرائیمؔ کی برادری کے تھے۔ اِن میں سے جو شُمار کئے گیٔے اُن کی تعداد 32,500 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","بِنیامین کے بیٹے کی برادری کے مُطابق یہ تھے: بَیلعؔ، جِس سے بَیلعیوں کی برادری چلی؛ اَشبیلؔ، جِس سے اَشبیلیوں کی برادری چلی؛ اخِیرامؔ، جِس سے اخِیرامیوں کی برادری چلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","شُوفامؔ جِس سے شُوفامیوں کی برادری چلی؛ اَور حُوپامؔ جِس سے حُوپامیوں کی برادری چلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","بَیلعؔ کے دو بیٹے اردؔ اَور نَعمانؔ تھے۔ اردؔ سے اَردیوں کی برادری چلی اَور نَعمانؔ سے نَعمانیوں کی برادری چلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","یہ بنی بِنیامین کی برادری کے تھے۔ اِن میں سے جو شُمار کئے گیٔے اُن کی تعداد 45,600 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","دانؔ کے بیٹے کی برادری کے مُطابق یہ تھے: شُوحامؔ جِس سے شُوحامیوں کی برادری چلی؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","وہ سبھی شُوحامیوں کی برادری کے تھے اَور اُن میں سے جو شُمار کئے گیٔے اُن کی تعداد 64,400 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","آشیر کے بیٹے کی برادری کے مُطابق یہ تھے: یِمنہؔ جِس سے یمنیوں کی برادری چلی؛ اِشویؔ جِس سے اِشویوں کی برادری چلی؛ اَور بریعہؔ جِس سے بریعاہیوں کی برادری چلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","اَور بنی بریعہؔ یہ ہیں: حِبرؔ جِس سے حِبری کی برادری چلی؛ اَور مَلکی ایل جِس سے مَلکی ایلیوں کی برادری چلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","(آشیر کی ایک بیٹی تھی جِس کا نام سراحؔ تھا۔) ");
INSERT INTO urdoucv_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","یہ آشیریوں کی برادری کے تھے۔ اِن میں سے جو شُمار کئے گیٔے اُن کی تعداد 53,400 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","نفتالی کے بیٹے اَپنی برادری کے مُطابق یہ تھے: یحصیل جِس سے یحصیلیوں کی برادری چلی؛ گُونی جِس سے گُونیوں کی برادری چلی؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","یصر جِس سے یصریوں کی برادری چلی؛ اَور شِلّیمؔ جِس سے شِلّیمیوں کی برادری چلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","یہ بنی نفتالی کی برادری کے تھے۔ اِن میں سے جو شُمار کئے گیٔے اُن کی تعداد 45,400 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","بنی اِسرائیل کے جِن لوگوں کا شُمار کیا گیا اُن کی کُل تعداد 6,01,730 تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","یَاہوِہ نے مَوشہ سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","”اُنہیں اُن کے ناموں کے شُمار کے مُطابق وہ زمین مِیراث کے طور پر بانٹ دی جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","بڑے گِروہ کو زِیادہ حِصّہ دیا جائے اَور چُھوٹے گِروہ کو کم۔ ہر ایک کو اُن کے درج کئے ہویٔے ناموں کی تعداد کے مُطابق مِیراث ملے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","خیال رہے کہ زمین قُرعہ اَندازی کے ذریعہ تقسیم کی جائے۔ ہر قبیلہ جو بھی مِیراث پایٔے وہ اُس کے آبائی قبیلہ کے ناموں کے مُطابق ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","اَور ہر مِیراث بڑے اَور چُھوٹے گِروہوں میں قُرعہ اَندازی کے ذریعہ تقسیم کی جائے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","بنی لیوی جو اَپنی اَپنی برادریوں کے مُطابق شُمار کئے گیٔے یہ ہیں: گیرشون جِس سے گیرشونیوں کی برادری چلی؛ قُہات جِس سے قُہاتیوں کی برادری چلی؛ مِراریؔ جِس سے مِراریوں کی برادری چلی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","یہ بھی لیویوں ہی کی برادری کے تھے: لبنیوں کی برادری، حِبرونیوں کی برادری، محلیوں کی برادری، مُوشیوں کی برادری، قورحؔیوں کی برادری۔ (قُہات عمرامؔ کا آباؤاَجداد تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","عمرامؔ کی بیوی کا نام یوکبِدؔ تھا جو لیوی کی نَسل سے تھی اَور مِصر میں لیوی کے ہاں پیدا ہُوئی تھی۔ اُن کے ہاں اَہرونؔ، مَوشہ اَور اُن کی بہن مِریمؔ عمرام سے پیدا ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","اَور اَہرونؔ سے نادابؔ، اَبِیہُو، الیعزرؔ اَور اِتمارؔ پیدا ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","لیکن نادابؔ اَور اَبِیہُو تو اُس وقت مَر گیٔے جَب اُنہُوں نے یَاہوِہ کے حُضُور میں ناجائز آگ کا نذرانہ چڑھایا۔) ");
INSERT INTO urdoucv_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","لیویوں کے سبھی نرینہ فرزندوں کی تعداد جو ایک ماہ یا اُس سے زِیادہ عمر کے تھے 23,000 تھی۔ وہ بنی اِسرائیل کے ساتھ اِس لیٔے نہیں گنے گیٔے کیونکہ اُنہیں اُن کے ساتھ مِیراث نہ مِلی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","یہی وہ اِسرائیلی لوگ ہیں جنہیں مَوشہ اَور الیعزرؔ کاہِنؔ نے مُوآب کے میدانوں میں یردنؔ کے کنارے پر یریحوؔ کے مقابل گِنا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","لیکن اُن میں سے ایک بھی اُن اِسرائیلیوں میں شامل نہ تھا جنہیں مَوشہ اَور اَہرونؔ کاہِنؔ نے سِینؔائی کے بیابان میں شُمار کیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","کیونکہ یَاہوِہ نے اُن اِسرائیلیوں کو کہہ دیا تھا کہ وہ یقیناً بیابان میں مَر جایٔیں گے اَور یفُنّہؔ کے بیٹے کالبؔ اَور یہوشُعؔ بِن نُونؔ کے سِوا اُن میں ایک بھی باقی نہیں بچا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","ضلافحادؔ بِن حِفرؔ گِلعادؔ کا پوتا اَور منشّہ کے بیٹے مکیرؔ کا پرپوتا تھا۔ اُس کی بیٹیاں یُوسیفؔ کے بیٹے منشّہ کی برادری کی نَسل سے تھیں۔ اُن بیٹیوں کے نام محلاہؔ نوحؔا حُگلاہؔ مِلکاہؔ اَور تِرضاؔہ تھے۔ وہ آئیں اَور ");
INSERT INTO urdoucv_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","خیمہ اِجتماع کے دروازہ پر مَوشہ الیعزرؔ کاہِنؔ سربراہوں اَور ساری جماعت کے سامنے کھڑی ہوکر کہنے لگیں: ");
INSERT INTO urdoucv_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","”ہمارا باپ بیابان میں مَر گیا۔ وہ قورحؔ کے اُن پیروکاروں میں سے نہ تھا جنہوں نے یَاہوِہ کے خِلاف سرکشی کی تھی بَلکہ وہ اَپنے ہی گُناہ میں مَرا اَور اُس کے کویٔی بیٹا نہ تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","چنانچہ بیٹا نہ ہونے کے باعث ہمارے باپ کا نام اُس کی برادری سے کیوں مِٹ جائے؟ لہٰذا ہمیں بھی ہمارے باپ کے رشتہ داروں کے ساتھ مِیراث میں حِصّہ دو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","چنانچہ مَوشہ اُن کا مُعاملہ یَاہوِہ کے حُضُور لے گیا ");
INSERT INTO urdoucv_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","اَور یَاہوِہ نے مَوشہ سے کہا: ");
INSERT INTO urdoucv_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","”ضلافحادؔ کی بیٹیاں ٹھیک کہتی ہیں۔ تُو اُنہیں اُن کے باپ کے رشتہ داروں کے درمیان ضروُر ہی کچھ جائداد بطور مِیراث دینا۔ پس اُن کے باپ کی مِیراث اُن کے سُپرد کر دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","”اَور بنی اِسرائیل سے کہہ، ’اگر کویٔی آدمی مَر جائے اَور اُس کا کویٔی بیٹا نہ ہو تو اُس کی مِیراث اُس کی بیٹی کو دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","اگر اُس کی کویٔی بیٹی بھی نہ ہو تو اُس کی مِیراث اُس کے بھائیوں کو دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","اَور اگر اُس کے کویٔی بھایٔی بھی نہ ہوں تو اُس کی مِیراث اُس کے باپ کے بھائیوں کو دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","اگر اُس کے باپ کے بھایٔی بھی نہ ہوں تو اُس برادری میں جو بھی اُس کا سَب سے قریبی رشتہ دار ہو اُسے اُس کی مِیراث دینا تاکہ وہ اُس کی مِلکیّت بَن جائے اَور یہ بنی اِسرائیل کے لیٔے آئین یَاہوِہ کے مَوشہ کو دئیے ہویٔے حُکم کے مُطابق شَرعی فرض ہوگا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","تَب یَاہوِہ نے مَوشہ سے فرمایا، ”تُو اُس عباریمؔ پہاڑ پر چڑھ کر اُس مُلک کو دیکھ جو مَیں نے بنی اِسرائیل کو عطا کیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","اُسے دیکھ لینے کے بعد تُو بھی اَپنے بھایٔی اَہرونؔ کی طرح اَپنے لوگوں میں جا ملے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","کیونکہ جَب صینؔ کے بیابان میں پانی کے چشمہ کے پاس جماعت نے سرکشی کی تھی تَب تُم دونوں نے میرا حُکم نہ مانا اَور اُن کی آنکھوں کے سامنے میری تقدیس نہ کی۔“ (یہ وُہی مریبہؔ کا چشمہ ہے جو صینؔ کے بیابان قادِسؔ میں ہے۔) ");
INSERT INTO urdoucv_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","مَوشہ نے یَاہوِہ سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","”یَاہوِہ! تمام نَوع اِنسان کی رُوحوں کے خُدا کسی آدمی کو اِس جماعت پر ایک نِگراں مُقرّر کرنا ");
INSERT INTO urdoucv_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","جو اُن کے سامنے آیا جایا کرے اَورجو اُنہیں باہر لے جانے اَور اَندر لانے میں اُن کا رہبر ہو تاکہ یَاہوِہ کی جماعت اُن بھیڑوں کی طرح نہ ہو جِن کا کویٔی چرواہا نہیں ہوتا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","چنانچہ یَاہوِہ نے مَوشہ سے فرمایا، ”تُو یہوشُعؔ بِن نُونؔ کو جو رُوح سے معموُر ہے لے اَور اُس پر اَپنا ہاتھ رکھ۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","اُسے الیعزرؔ کاہِنؔ اَور ساری جماعت کے سامنے کھڑا کر اَور اُن کے سامنے اُسے اِختیار دے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","اَپنے کچھ اِختیارات اُس کے سُپرد کردینا تاکہ بنی اِسرائیل کی ساری جماعت اُس کی اِطاعت کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","وہ الیعزرؔ کاہِنؔ کے سامنے کھڑا ہُوا کرے جو یَاہوِہ کے حُضُور اُس کی خاطِر اُوریمؔ کا حُکم دریافت کیا کرےگا۔ اِسی کے حُکم سے وہ اَور بنی اِسرائیل کی ساری جماعت باہر جایا کریں اَور اُسی کے حُکم سے وہ اَندر آئیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","چنانچہ مَوشہ نے یَاہوِہ کے حُکم کے مُطابق عَمل کیا۔ اُس نے یہوشُعؔ کو لیا اَور الیعزرؔ کاہِنؔ اَور ساری جماعت کے سامنے کھڑا کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","تَب یَاہوِہ نے جو ہدایات مَوشہ کی مَعرفت دی تھیں اُن کے مُطابق اُس نے اَپنے ہاتھ یہوشُعؔ پر رکھے اَور اُسے اِختیار بخشا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","یَاہوِہ نے مَوشہ سے کہا: ");
INSERT INTO urdoucv_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","”بنی اِسرائیل کو یہ حُکم سُنانا اَور اُن سے کہنا، ’تُم میری نذر، یعنی میری وہ غِذا جو میرے لیٔے فرحت بخش خُوشبو والی آتِشی قُربانی ہے مُقرّرہ وقت پر یاد سے پیش کرتے رہنا۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","اُن سے کہہ کہ یَاہوِہ کے لیٔے تُم جو آتِشی قُربانی پیش کرو وہ یہ ہے: ہر روز حسبِ معمول دو بے عیب یک سالہ برّے سوختنی نذر کے طور پر چڑھایا کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ایک برّہ صُبح کو اَور دُوسرا شام کو چڑھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","اَور ساتھ ہی ایفہ کے دسویں حِصّہ کے برابر مَیدہ میں چوتھائی ہین کُوٹ کر نکالا ہُوا زَیتُون کا تیل مِلا کر اناج کی قُربانی کے طور پر پیش کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","یہ وُہی دائمی سوختنی نذر ہے جو کوہِ سِینؔائی پر مُقرّر کی گئی تھی تاکہ یَاہوِہ کے حُضُور فرحت بخش خُوشبو دینے والی آتِشی قُربانی ٹھہرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","اَور اُس کے ساتھ فی برّہ کے ساتھ ہین کا چوتھائی حِصّہ مَے انگوری شِیرہ کے طور پر لائی جائے۔ یہ انگوری شِیرہ یَاہوِہ کے لیٔے پاک مَقدِس میں چڑھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","دُوسرا برّہ شام کے جھٹپٹے کے وقت چڑھانا اَور اُس کے ساتھ بھی صُبح کی طرح اناج کی قُربانی اَور انگوری شِیرے کی نذر ہو۔ یہ یَاہوِہ کے حُضُور غِذا کی فرحت بخش خُوشبو والی آتِشی قُربانی ہوگی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","” ’اَور سَبت کے دِن دو بے عیب یک سالہ برّے اَور ایفہ کا پانچواں حِصّہ تیل مِلا ہُوا مَیدہ تپاون کے ساتھ اناج کی قُربانی کے طور پر پیش کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","حسبِ معمول پیش کی جانے والی سوختنی نذر اَور اُس کے تپاون کے علاوہ یہ ہر سَبت کی سوختنی نذر ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","” ’ہر مہینے کے پہلے دِن دو بچھڑے، ایک مینڈھا اَور سات یک سالہ نر برّے جو سَب کے سَب بے عیب ہُوں سوختنی نذر کے طور پر یَاہوِہ کے حُضُور میں چڑھایا کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ہر بچھڑے کے ساتھ ایفہ کا تین دہائی حِصّہ اناج کی نذر تیل مِلا ہُوا مَیدہ اَور ہر مینڈھے کے ساتھ ایفہ کا پانچواں حِصّہ اناج کی نذر تیل مِلا ہُوا مَیدہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","اَور ہر برّہ کے ساتھ ایفہ کا دسواں حِصّہ تیل مِلا ہُوا مَیدہ اناج کی قُربانی کے طور پر پیش کرنا۔ یہ سوختنی نذر یَاہوِہ کے لیٔے فرحت بخش خُوشبو دینے والی آتِشی قُربانی ٹھہرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ہر بچھڑے کے ساتھ نِصف ہین ہر مینڈھے کے ساتھ ایک تہائی ہین اَور ہر برّہ کے ساتھ پاؤ ہین مَے تپاون کے طور پر دی جائے۔ یہ ماہانہ سوختنی نذر ہے جو سال بھر ہر نئے چاند کے موقع پر پیش کی جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","حسبِ معمول پیش کی جانے والی سوختنی نذر اَور اُس کے ساتھ دئیے جانے والے تپاون کے علاوہ ایک بکرا یَاہوِہ کے لیٔے گُناہ کی قُربانی کے طور پر پیش کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","” ’پہلے مہینے کے چودھویں دِن یَاہوِہ کا فسح ہُوا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","اَور اُسی مہینے کے پندرھویں دِن عید منائی جائے اَور سات دِن تک بے خمیری روٹی کھائی جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","پہلے دِن مُقدّس اِجتماع ہو اَور عام دِنوں کی طرح کویٔی کام بالکُل نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","اَور یَاہوِہ کے لیٔے آتِشی قُربانی پیش کی جائے جو دو بچھڑوں، ایک مینڈھے اَور سات یک سالہ نر برّوں کی سوختنی نذر پر مُشتمل ہو جو سَب کے سَب بے عیب ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ہر بچھڑے کے ساتھ ایک ایفہ کا تین دہائی حِصّہ زَیتُون کا تیل اناج کی نذر مِلا ہُوا مَیدہ، ہر مینڈھے کے ساتھ ایفہ کا پانچواں حِصّہ زَیتُون کا تیل اناج کی نذر مِلا ہُوا مَیدہ؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","اَور ساتوں برّوں میں سے ہر ایک کے ساتھ دسواں حِصّہ نذر کی قُربانی کے طور پر پیش کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","گُناہ کی قُربانی کے طور پر ایک بکرے کا اِضافہ کرنا تاکہ اُس سے تمہارے لیٔے کفّارہ دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","اُنہیں صُبح کو حسبِ معمول دی جانے والی سوختنی نذر کے علاوہ پیش کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","اِسی طرح سات دِن تُم روزانہ آتِشی قُربانی کی یہ غِذا چڑھانا تاکہ وہ یَاہوِہ کے لیٔے فرحت بخش خُوشبو ٹھہرے۔ یہ حسبِ معمول دی جانے والی سوختنی نذر اَور اُس کے تپاون کے علاوہ پیش کی جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ساتویں دِن پھر تمہارا مُقدّس اِجتماع ہو اَور حسبِ معمول کویٔی کام نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","” ’پہلے پھلوں کے دِن جَب تُم ہفتوں کی عید کے موقع پر یَاہوِہ کے لیٔے نئی نذر کی قُربانی پیش کرو تَب بھی تمہارا مُقدّس اِجتماع ہو اَور اُس روز بھی کویٔی حسبِ معمول کام اَنجام نہ دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","اَور دو بچھڑے، ایک مینڈھا اَور سات یک سالہ نر برّے سوختنی نذر کے طور پر گذرانو جو یَاہوِہ کے لیٔے فرحت بخش خُوشبو ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ہر بچھڑے کے ساتھ اناج کی نذر کی قُربانی کے طور پر ایفہ کا تین دہائی حِصّہ زَیتُون کا تیل مِلا ہُوا مَیدہ ہو، مینڈھے کے ساتھ ایفہ کا پانچواں حِصّہ ہو؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","اَور سات برّوں میں سے ہر ایک برّے کے ساتھ ایفہ کا دسواں حِصّہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","اَور ایک بکرا بھی شامل کر لو تاکہ تمہارے لیٔے کفّارہ دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","حسبِ معمول دی جانے والی سوختنی نذر اَور اُس کی اناج کی نذر کی قُربانی کے علاوہ تُم اُنہیں بھی اُن کے تپاون کی نذروں کے ساتھ پیش کرنا۔ البتّہ خیال رہے کہ سَب جانور بے عیب ہُوں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","” ’ساتویں مہینے کے پہلے دِن تمہارا مُقدّس اِجتماع ہو اَور اُس دِن کویٔی حسبِ معمول کام نہ کیا جائے۔ یہ تمہارے لیٔے نرسنگے پھُونکنے کا دِن ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","تُم ایک بچھڑا، ایک مینڈھا اَور سات یک سالہ نر برّے جو سَب کے سَب بے عیب ہُوں سوختنی نذر کے طور پر پیش کرنا تاکہ یَاہوِہ کے لیٔے فرحت بخش خُوشبو ٹھہرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","بچھڑے کے ساتھ اناج کی نذر کی قُربانی کے طور پر ایفہ کا تین دہائی حِصّہ زَیتُون کا تیل مِلا ہُوا مَیدہ ہو؛ مینڈھے کے ساتھ پانچواں حِصّہ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","اَور سات برّوں میں سے ہر ایک برّے کے ساتھ دسواں حِصّہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","اَور ایک بکرا بھی شامل کر لو تاکہ تمہارے لیٔے گُناہ کی قُربانی کے طور پر کفّارہ دیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","یہ مُقرّرہ ماہانہ اَور روزمرّہ دی جانے والی سوختنی نذروں اَور اُن کے ساتھ کی اناج کی نذر اَور تپاون کی نذروں کی قُربانیوں کے علاوہ ہیں۔ یہ یَاہوِہ کے حُضُور فرحت بخش خُوشبو والی آتِشی قُربانیوں کے طور پر پیش کی جایٔیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","” ’اِسی ساتویں مہینے کے دسویں دِن تمہارا مُقدّس اِجتماع ہو۔ اُس دِن تُم اَپنی خُودی کا اِنکار کرنا اَور کویٔی کام نہ کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","اَور یَاہوِہ کے حُضُور فرحت بخش خُوشبو کے لیٔے ایک بچھڑا، ایک مینڈھا اَور سات یک سالہ نر برّے جو سَب کے سَب بے عیب ہُوں سوختنی نذر کے طور پر پیش کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","بچھڑے کے ساتھ اناج کی نذر کی قُربانی کے طور پر ایفہ کا تین دہائی حِصّہ زَیتُون کا تیل مِلا ہُوا مَیدہ ہو، مینڈھے کے ساتھ پانچواں حِصّہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","اَور سات برّوں میں سے ہر ایک برّہ کے ساتھ دسواں حِصّہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","اَور ایک بکرا گُناہ کی قُربانی کے طور پر بھی شامل کر لو جو کفّارہ کے لیٔے دی ہُوئی گُناہ کی قُربانی اَور حسبِ معمول دی جانے والی سوختنی نذر اَور اناج کی نذر کی قُربانی اَور تپاون کی نذروں کے علاوہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","” ’ساتویں مہینے کے پندرھویں دِن پھر تمہارا مُقدّس اِجتماع ہو۔ اُس دِن تُم کویٔی حسبِ معمول کام نہ کرنا اَور سات دِن تک یَاہوِہ کے لیٔے کی عید منانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","اَور سوختنی نذر کے طور پر تیرہ بچھڑے، دو مینڈھے اَور چودہ یک سالہ نر برّے جو سَب کے سَب بے عیب ہُوں گذراننا تاکہ وہ یَاہوِہ کے لیٔے فرحت بخش خُوشبو کی آتِشی قُربانی ٹھہرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","تیرہ بچھڑوں میں سے ہر بچھڑے کے ساتھ اناج کی نذر کی قُربانی کے طور پر ایفہ کا تین دہائی حِصّہ زَیتُون کا تیل مِلا ہُوا مَیدہ ہو اَور دونوں مینڈھوں میں سے ہر مینڈھے کے ساتھ پانچواں حِصّہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","اَور چودہ برّوں میں سے ہر برّہ کے ساتھ دسواں حِصّہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","اَور ایک بکرا گُناہ کی قُربانی کے طور پر بھی شامل کر لو جو حسبِ معمول دی جانے والی سوختنی نذر اَور اناج کی نذر کی قُربانی اَور تپاون کے علاوہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","” ’دُوسرے دِن بَارہ بچھڑے، دو مینڈھے اَور چودہ یک سالہ نر برّے جو سَب کے سَب بے عیب ہُوں چڑھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","بچھڑوں، مینڈھوں اَور برّوں کے ساتھ اُن کے اعداد شُمار کے مُطابق اناج کی نذر کی قُربانیاں اَور تپاون کی نذریں بھی گذراننا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","اَور ایک بکرا گُناہ کی قُربانی کے طور پر بھی شامل کر لو جو حسبِ معمول دی جانے والی سوختنی نذر اَور اناج کی نذر کی قُربانی اَور تپاون کی نذروں کے علاوہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","” ’تیسرے دِن گیارہ بچھڑے، دو مینڈھے اَور چودہ یک سالہ نر برّے جو سَب کے سَب بے عیب ہُوں چڑھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","بچھڑوں، مینڈھوں اَور برّوں کے ساتھ اُن کے اعداد شُمار کے مُطابق اناج کی نذر اَور تپاون کی نذروں کی قُربانیاں بھی گذراننا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","اَور ایک بکرا گُناہ کی قُربانی کے طور پر بھی شامل کر لو جو حسبِ معمول دی جانے والی سوختنی نذر اَور اناج کی نذر کی قُربانی اَور تپاون کے علاوہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","” ’چوتھے دِن دس بچھڑے، دو مینڈھے اَور چودہ یک سالہ نر برّے جو سَب کے سَب بے عیب ہُوں چڑھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","بچھڑوں، مینڈھوں اَور برّوں کے ساتھ اُن کے اعداد شُمار کے مُطابق اناج کی نذر اَور تپاون کی نذریں بھی گذراننا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","اَور ایک بکرا گُناہ کی قُربانی کے طور پر بھی شامل کر لو جو حسبِ معمول دی جانے والی سوختنی نذر اَور اناج کی نذر کی قُربانی اَور تپاون کے علاوہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","” ’پانچویں دِن نَو بچھڑے، دو مینڈھے اَور چودہ یک سالہ نر برّے جو سَب کے سَب بے عیب ہُوں چڑھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","بچھڑوں، مینڈھوں اَور برّوں کے ساتھ اُن کے اعداد شُمار کے مُطابق اناج کی نذر اَور تپاون کی نذریں کی قُربانیاں بھی گذراننا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","اَور ایک بکرا گُناہ کی قُربانی کے طور پر بھی شامل کر لو جو حسبِ معمول دی جانے والی سوختنی نذر اَور اناج کی نذر کی قُربانی اَور تپاون کے علاوہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","” ’چھٹے دِن آٹھ بچھڑے، دو مینڈھے اَور چودہ یک سالہ نر برّے جو سَب کے سَب بے عیب ہُوں چڑھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","بچھڑوں، مینڈھوں اَور برّوں کے ساتھ اُن کے اعداد شُمار کے مُطابق اناج کی نذر اَور تپاون کی نذروں کی قُربانیاں بھی گذراننا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","اَور ایک بکرا گُناہ کی قُربانی کے طور پر بھی شامل کر لو جو حسبِ معمول دی جانے والی سوختنی نذر اَور اناج کی نذر کی قُربانی اَور تپاون کے علاوہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","” ’ساتویں دِن سات بچھڑے، دو مینڈھے اَور چودہ یک سالہ نر برّے جو سَب کے سَب بے عیب ہُوں چڑھانا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","بچھڑوں، مینڈھوں اَور برّوں کے ساتھ اُن کے اعداد شُمار کے مُطابق اناج کی نذر اَور تپاون کی نذریں بھی گذراننا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","اَور ایک بکرا گُناہ کی قُربانی کے طور پر بھی شامل کر لو جو حسبِ معمول دی جانے والی سوختنی نذر اَور اناج کی نذر کی قُربانی اَور تپاون کے علاوہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","” ’آٹھویں دِن تمہارا اِجتماع ہو اَور کویٔی حسبِ معمول کام نہ کیا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","اَور سوختنی نذر کے طور پر ایک بچھڑا، ایک مینڈھا اَور سات یک سالہ نر برّے جو سَب کے سَب بے عیب ہُوں گذرانو تاکہ وہ یَاہوِہ کے لیٔے فرحت بخش خُوشبو کی آتِشی قُربانی ٹھہرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","بچھڑے، مینڈھے اَور برّوں کے ساتھ اُن کے اعداد شُمار کے مُطابق اناج کی نذر اَور تپاون کی نذریں بھی گذراننا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","اَور ایک بکرا گُناہ کی قُربانی کے طور پر بھی شامل کر لو جو حسبِ معمول دی جانے والی سوختنی نذر اَور اناج کی نذر کی قُربانی اَور تپاون کے علاوہ ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","” ’تُم اَپنی مُقرّرہ عیدوں کے موقعوں پر اُن کو یَاہوِہ کے حُضُور اَپنی مَنّتوں اَور رضا کی قُربانیوں کے علاوہ اَپنی سوختنی نذریں، اناج کی نذریں، تپاون کی نذریں اَور سلامتی کی نذریں گذراننا۔‘ “ ");
INSERT INTO urdoucv_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","مَوشہ نے بنی اِسرائیل کو وہ سَب کچھ بتا دیا جِس کا حُکم یَاہوِہ نے اُسے دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","مَوشہ نے اِسرائیل کے قبیلوں کے سربراہوں سے کہا: ”یَاہوِہ نے یہ حُکم دیا ہے: ");
INSERT INTO urdoucv_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","جَب کویٔی آدمی یَاہوِہ کی مَنّت مانے یا قَسم کھا کر کویٔی عہدوپیمان کر بیٹھے تو وہ اَپنا عہد نہ توڑے بَلکہ جو کچھ اُس نے کہا ہے اُسے پُورا کرے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","”جَب کویٔی عورت اَپنے باپ کے گھر میں رہتے ہویٔے یَاہوِہ سے مَنّت مانے یا کویٔی عہدوپیمان کر بیٹھے ");
INSERT INTO urdoucv_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","اَور اُس کا باپ اُس کی مَنّت یا عہد کے بارے میں سُن کر اُس سے کچھ نہ کہے تو اُس کی سَب مَنّتیں اَور عہدوپیمان جو اُس نے اَپنے اُوپر فرض کر لیا ہے برقرار رہیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","لیکن اگر اُس کا باپ جَب یہ سُن لے اَور اُسے منع کر دے تو اُس کی کویٔی مَنّت یا کویٔی عہدوپیمان جسے اُس نے اَپنے اُوپر فرض کر لیا ہو برقرار نہیں رہے گا۔ یَاہوِہ اُسے مُعاف کر دیں گے کیونکہ اُس کے باپ نے اُسے منع کیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","”اگر وہ مَنّت ماننے کے بعد بیاہ کر لے یا اُس کے ہونٹوں پر ناعاقبت اَندیشی کی وجہ سے کویٔی اَیسی بات آ جائے جو اُس نے اَپنے اُوپر فرض ٹھہرائی ہو ");
INSERT INTO urdoucv_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","اَور اُس کا خَاوند اُن کے بارے میں سُن کر اُس سے کچھ نہ کہے تو اُس کی مَنّتیں یا عہدوپیمان جو اُس نے اَپنے اُوپر فرض ٹھہرائے ہیں برقرار رہیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","لیکن اگر اُس کا خَاوند جَب یہ سُن لے اَور اُسے منع کر دے تو وہ اُس مَنّت کو اَور ناعاقبت اَندیشی کی وجہ سے کئے ہویٔے وعدے کو جو اُس نے اَپنے اُوپر فرض ٹھہرایا ہو منسُوخ کرتا ہے تو یَاہوِہ اُسے مُعاف کر دیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","”لیکن کویٔی بِیوہ یا مُطلّقہ عورت جو مَنّت مانے یا اَپنے اُوپر کویٔی پابندی عاید کر لے وہ برقرار رہے گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","”اگر کویٔی عورت اَپنے خَاوند کے ساتھ رہتے ہویٔے کویٔی مَنّت مانے یا قَسم کھا کر اَپنے اُوپر کویٔی پابندی عاید کر لیتی ہے ");
INSERT INTO urdoucv_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","اَور اُس کا خَاوند ہے سُن کر اُس سے کچھ نہ کہے اَور اُسے منع نہ کرے تو اُس کی ساری مَنّتیں اَور اُس کی اَپنے آپ پر عاید کی ہُوئی پابندیاں برقرار رہیں گی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","لیکن اگر اُس کا خَاوند اُنہیں سُننے کے بعد منسُوخ کر دیتاہے تو اُس کے مُنہ سے نکلی ہُوئی کویٔی مَنّت یا پابندی برقرار نہ رہے گی۔ اُس کے خَاوند نے اُنہیں منسُوخ کیا ہے اَور یَاہوِہ اُسے مُعاف کر دیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","اُس کا خَاوند اُس کی مانی ہُوئی کسی بھی مَنّت کو یا قَسم کھا کر پرہیزگاری کے لیٔے اَپنے اُوپر عاید کی ہُوئی کسی بھی پابندی کو قائِم رکھ سَکتا ہے یا منسُوخ کر سَکتا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","لیکن اگر اُس کا خَاوند اُس کے متعلّق کسی دِن بھی اُس سے کچھ نہ کہے تَب وہ اُس کی تمام مَنّتیں اَور خُود پر عاید کی ہُوئی پابندیاں برقرار رکھتا ہے۔ وہ اِس لیٔے برقرار رہتی ہیں کہ اُس نے اُن کے متعلّق سُن کر بھی اُس سے کچھ نہ کہا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","البتّہ اگر وہ اُن کے بارے میں سُننے کے کچھ عرصہ بعد اُنہیں منسُوخ کرتا ہے تو وہ اُس کے گُناہ کا ذمّہ دار ہوگا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","خَاوند اَور بیوی کے درمیان اَور باپ اَور اُس کے گھر میں رہتی ہُوئی اُس کی جَوان بیٹی کے درمیان آپَس کے تعلّقات کے متعلّق یَاہوِہ نے یہ ضوابط مَوشہ کو دئیے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","یَاہوِہ نے مَوشہ سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","”مِدیانیوں سے بنی اِسرائیل کا اِنتقام لے۔ اُس کے بعد تُو اَپنے لوگوں میں جا ملے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","چنانچہ مَوشہ نے لوگوں سے کہا، ”اَپنے میں سے چند آدمیوں کو مِدیانیوں کے خِلاف جنگ کرنے اَور اُن سے یَاہوِہ کا اِنتقام لینے کے لیٔے مُسلّح کر لو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","اِسرائیل کے ہر قبیلہ میں سے ایک ایک ہزار آدمی جنگ کے لیٔے بھیجنا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","چنانچہ اِسرائیل کی برادریوں میں سے فی قبیلہ ایک ہزار کے حِساب سے بَارہ ہزار آدمیوں نے جنگ کے لیٔے ہتھیار باندھ لیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","یُوں مَوشہ نے ہر قبیلہ میں سے ایک ہزار آدمیوں کو جنگ کے لیٔے الیعزرؔ کاہِنؔ کے بیٹے فِنحاسؔ کے ساتھ بھیجا جِس نے پاک مَقدِس کے ظروف اَور جنگ کا نعرہ بُلند کرنے کے لیٔے نرسنگے اَپنے ساتھ لیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","اُنہُوں نے یَاہوِہ کے ذریعہ مَوشہ کو دئیے ہویٔے حُکم کے مُطابق وہ مِدیانیوں سے لڑے اَور ہر آدمی کو مار ڈالا ");
INSERT INTO urdoucv_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","جِن لوگوں کو اُنہُوں نے موت کے گھاٹ اُتارا اُن میں عیویؔ، رِقمؔ، ضُورؔ، حُورؔ، رِبعؔ اَور یہ پانچ مِدیانی بادشاہ بھی تھے۔ اُنہُوں نے بِلعاؔم بِن بعورؔ کو بھی تلوار سے قتل کیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","اِسرائیلیوں نے مِدیانی عورتوں اَور بچّوں کو اسیر کیا اَور مِدیانیوں کے مویشیوں کے تمام ریوڑ بھیڑ اَور بکریوں کے تمام گلّے اَور سارا مال و اَسباب لُوٹ لیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","اُنہُوں نے اُن تمام شہروں کو جہاں مِدیانی آباد تھے اَور اُن کی سَب چھاؤنی کو نذرِ آتِش کر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","تَب اُنہُوں نے لوگوں اَور جانوروں سمیت تمام مالِ غنیمت کو جمع کیا ");
INSERT INTO urdoucv_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","اَور تمام اسیروں اَور مالِ غنیمت کو مَوشہ، الیعزرؔ کاہِنؔ اَور بنی اِسرائیل کی ساری جماعت کے پاس اَپنی چھاؤنی میں لے آئے جو یریحوؔ کے مقابل یردنؔ کے کنارے مُوآب کے میدانوں میں تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","مَوشہ اَور الیعزرؔ کاہِنؔ اَور جماعت کے سَب سردار اُن کے اِستِقبال کے لیٔے چھاؤنی کے باہر گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","مَوشہ جنگ سے لَوٹے ہویٔے اُن افسران پر جھلّایا جو ہزاروں اَور سینکڑوں فَوجی دستوں کی قیادت کر رہے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","مَوشہ نے اُن سے پُوچھا، ”کیا تُم نے سَب عورتوں کو زندہ رہنے دیا؟“ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","پعورؔ میں جو کچھ ہُوا اُس وقت یہی عورتیں بِلعاؔم کی صلاح سے اِسرائیلیوں کو یَاہوِہ سے برگشتہ کرنے کا ذریعہ بنی تھیں اَور یَاہوِہ کے لوگوں میں وَبا پھیلی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","لہٰذا سَب لڑکوں کو مار ڈالو اَور ہر اُس عورت کو بھی مار ڈالو جو کسی مَرد کے ساتھ ہم بِستر ہو چُکی ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","لیکن ہر اُس لڑکی کو اَپنے لیٔے بچائے رکھو جو کبھی کسی مَرد کے ساتھ ہم بِستر نہ ہُوئی ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","”تُم سَب جنہوں نے کسی کو قتل کیا ہو یا کسی مقتول کو چھُوا ہو سات دِن تک چھاؤنی کے باہر رہے۔ تیسرے اَور ساتویں دِن تُم اَپنے آپ کو اَور اَپنے اسیروں کو پاک کر لو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","تُم ہر کپڑے کو اَور چمڑے، بکری کے بالوں اَور لکڑی سے بنی ہُوئی ہر شَے کو پاک کر لو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","تَب الیعزرؔ کاہِنؔ نے اُن سپاہیوں سے جو جنگ کرنے گیٔے تھے کہا، ”یَاہوِہ کی مَوشہ کو دی ہُوئی آئین کا یہ تَقاضا ہے کہ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","سونا، چاندی، کانسا، لوہا، رانگا اَور سیسہ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","اَور دُوسری کویٔی شَے جو آگ کی تاب لا سکے اُسے آگ میں ڈالا جائے، تَب وہ صَاف ہوگی۔ لیکن اُسے طہارت کے پانی سے بھی پاک کیا جائے۔ اَورجو کچھ آگ کو برداشت نہ کر سکے اُسے اُس پانی میں ڈالا جائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ساتویں دِن تُم اَپنے کپڑے دھونا۔ اَور پاک و صَاف ہوکر چھاؤنی میں آجانا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","یَاہوِہ نے مَوشہ سے کہا، ");
INSERT INTO urdoucv_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","”تُو اَور الیعزرؔ کاہِنؔ اَور جماعت کے خاندانوں کے سردار مِل کر اُن لوگوں اَور جانوروں کو شُمار کرو جو اسیر کئے گیٔے تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","اَور مالِ غنیمت کو جنگ میں شریک ہونے والے سپاہیوں اَور بقیّہ جماعت کے درمیان تقسیم کرنا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","اُن سپاہیوں کے حِصّہ میں جو جنگ میں لڑے تھے یَاہوِہ کے لیٔے خراج کے طور پر ہر پانچ سَو لوگوں، مویشیوں، گدھوں، بھیڑوں میں سے ایک کے حِساب سے ایک حِصّہ لے لیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","اُن کے نِصف حِصّہ میں سے تُم یہ خراج لے کر اُسے الیعزرؔ کاہِنؔ کو یَاہوِہ کے نذرانہ کے طور پر دے دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","اَور بنی اِسرائیل کے نِصف حِصّہ میں سے ہر پچاس کے پیچھے ایک ایک لینا خواہ وہ اِنسان ہُوں یا مویشی، گدھے، بھیڑیں، یا کویٔی اَور جانور۔ اُنہیں لیویوں کو دینا جو یَاہوِہ کے خیمہ اِجتماع کی حِفاظت کے ذمّہ دار ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","مَوشہ اَور الیعزرؔ کاہِنؔ نے وُہی کیا۔ جو یَاہوِہ نے مَوشہ کو حُکم دیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","لُوٹ کا مال جو سپاہیوں کے ہاتھ لگا تھا اُس کے علاوہ بچا ہُوا مالِ غنیمت یہ تھا: 6,75,000 بکریاں، ");
INSERT INTO urdoucv_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72,000 مویشی، ");
INSERT INTO urdoucv_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61,000 گدھے، ");
INSERT INTO urdoucv_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","32,000 اَیسی عورتیں جو کسی مَرد کے ساتھ ہم بِستر نہ ہُوئی تھیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","جنگ میں لڑنے والوں کا نِصف حِصّہ یہ تھا: 3,37,500 بھیڑیں ");
INSERT INTO urdoucv_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","جِن میں سے 675 بھیڑیں یَاہوِہ کے لیٔے تھیں ");
INSERT INTO urdoucv_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","36,000 مویشی جِن میں یَاہوِہ کے لیٔے 72 تھے؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","گدھے 30,500 جِن میں یَاہوِہ کے لئے 61 تھے؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","16,000 مَرد جِن میں 32 یَاہوِہ کے لئے تھے، ");
INSERT INTO urdoucv_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","جَیسا یَاہوِہ نے مَوشہ کو حُکم دیا تھا اُسی کے مُطابق اُس نے وہ رسد الیعزرؔ کاہِنؔ کو یَاہوِہ کے حِصّہ کے طور پر دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","بنی اِسرائیل کا نِصف حِصّہ جسے مَوشہ نے جنگی مَردوں کے حِصّہ سے الگ کر لیا تھا: ");
INSERT INTO urdoucv_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","یعنی جماعت کا نِصف حِصّہ یہ 3,37,500 بھیڑیں، ");
INSERT INTO urdoucv_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36,000 مویشی، ");
INSERT INTO urdoucv_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30,500 گدھے، ");
INSERT INTO urdoucv_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","16,000 مَرد۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","اَور بنی اِسرائیل کے نِصف حِصّہ میں سے مَوشہ نے خُدا کے حُکم کے مُطابق ہر پچاس مَردوں اَور جانوروں کے پیچھے ایک ایک چُن کر لیویوں کو دیا جو یَاہوِہ کے مَسکن کی حِفاظت کے ذمّہ دار تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","تَب وہ افسران جو ہزاروں اَور سینکڑوں فَوجی دستوں کی قیادت کر رہے تھے مَوشہ کے پاس آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","اَور مَوشہ سے کہنے لگے، ”تمہارے خادِموں نے اُن سپاہیوں کا جو ہمارے ماتحت تھے شُمار کیا اَور اُن میں سے ایک بھی کم نہ ہُوا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","چنانچہ بازوبند، کنگن، انگُوٹھیاں، کان کی بالیاں اَور گلوبند جَیسی سونے کی چیزوں میں سے جو کچھ ہمارے ہاتھ لگا اُسے ہم یَاہوِہ کے حُضُور میں ہدیہ کے طور پر لایٔے ہیں تاکہ ہمارے لیٔے یَاہوِہ کے حُضُور کفّارہ دیا جائے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","تَب مَوشہ اَور الیعزرؔ کاہِنؔ نے اُن سے وہ سونا لے لیا جو گڑھے ہویٔے گہنوں کی شکل میں تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ہزاروں اَور سینکڑوں فَوجی دستوں کے سپہ سالاروں سے لیٔے ہویٔے سونے کا وزن جسے مَوشہ اَور الیعزرؔ نے یَاہوِہ کے حُضُور میں نذرانے کے طور پر پیش کیا تھا جو 16,750 ثاقل تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","ہر جنگی سپاہی نے اَپنے لیٔے کچھ نہ کچھ لے لیا تھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","مَوشہ اَور الیعزرؔ کاہِنؔ نے ہزاروں اَور سینکڑوں فَوجی دستوں کے سپہ سالاروں سے سونا لے لیا اَور وہ اُسے یَاہوِہ کے حُضُور میں بنی اِسرائیل کی یادگار کے طور پر خیمہ اِجتماع میں لے آئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","بنی رُوبِنؔ اَور بنی گادؔ نے جِن کے پاس جانوروں کے بڑے بڑے ریوڑ اَور گلّے تھے جَب یہ دیکھا کہ یعزیرؔ اَور گِلعادؔ کے مُلک مویشیوں کے لیٔے نہایت اَچھّے ہیں ");
INSERT INTO urdoucv_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","تو وہ رُوبِنؔ کے قبیلہ اَور مَوشہ اَور الیعزرؔ کاہِنؔ اَور گادؔ کی جماعت کے سربراہوں کے پاس آکر کہنے لگے، ");
INSERT INTO urdoucv_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","”عطاروتؔ دیبونؔ یعزیرؔ، نِمرہؔ، حِشبونؔ، الیعالہؔ سیبامؔ، نبوؔ اَور بعُونؔ، ");
INSERT INTO urdoucv_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","کا مُلک جِن پر یَاہوِہ نے بنی اِسرائیل کو فتح بخشی مویشیوں کے لیٔے نہایت مُناسب ہے اَور تمہارے خادِموں کے پاس مویشی ہیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","پھر اُنہُوں نے کہا، ”اگر ہم پر آپ کی نظرِکرم ہے تو یہ مُلک اَپنے خادِموں کو مِیراث کے طور پر عطا فرما اَور ہم پر یردنؔ پار کرنے کی نَوبَت نہ لا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","مَوشہ نے بنی گادؔ اَور بنی رُوبِنؔ سے کہا، ”کیا تمہارے بھایٔی جنگ کرنے جایٔیں اَور تُم یہیں بیٹھے رہو؟ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","تُم بنی اِسرائیل کا اُس مُلک میں جانے کا حوصلہ کیوں پست کر رہے ہو جسے یَاہوِہ نے اُنہیں دیا ہے؟ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","جَب مَیں نے تمہارے آباؤاَجداد کو قادِسؔ برنیع سے اُس مُلک کا مُعائنہ کرنے کے لیٔے بھیجا تھا تو اُنہُوں نے بھی اَیسا ہی کہاتھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","جَب وہ اِشکلؔ کی وادی تک پہُنچے تو اُس مُلک کو دیکھ کر اُنہُوں نے بنی اِسرائیل کے حوصلے پست کر دئیے کہ وہ اُس مُلک میں داخل نہ ہُوئے جسے یَاہوِہ نے اُنہیں دیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","اُس دِن یَاہوِہ کا غضب اُن پر بھڑکا اَور اُنہُوں نے یہ قَسم کھائی: ");
INSERT INTO urdoucv_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","’چونکہ اُنہُوں نے میری دِل و جان سے پیروی نہیں کی اِس لیٔے اُن میں سے بیس سال یا اُس سے زِیادہ عمر کا کویٔی بھی شخص جو مِصر سے نکل آیا ہے اُس مُلک کو نہیں دیکھ پایٔےگا جسے دینے کی قَسم مَیں نے اَبراہامؔ اَور اِصحاقؔ اَور یعقوب سے کھائی ہے؛ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","سِوا یفُنّہؔ قِنزّی کے بیٹے کالبؔ اَور یہوشُعؔ بِن نُونؔ کے جنہوں نے دِل و جان سے یَاہوِہ کی پیروی کی۔‘ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","یَاہوِہ کا قہر اِسرائیل کے خِلاف بھڑک اُٹھا اَور اُنہُوں نے اُنہیں چالیس سال تک بیابان میں مارے مارے پھرنے پر مجبُور کیا۔ یہاں تک کہ اُس پُشت کے سَب لوگ جنہوں نے یَاہوِہ کی نظر میں گُناہ کیا تھا نابود ہو گئے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","”اَور یہاں تُم ہو۔ اَے گُنہگاروں کی اَولاد جو اَپنے آباؤاَجداد کی جگہ پر کھڑے ہوکر یَاہوِہ کے قہر کو اِسرائیل پر اَور بھی زِیادہ شدید کر رہے ہو۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","اگر تُم اُس کی پیروی سے مُنہ موڑوگے تو وہ پھر اُن سَب لوگوں کو بیابان میں چھوڑ دے گا اَور تُم ہی اُن کی تباہی کا باعث ہوگے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","تَب وہ مَوشہ کے پاس آکر کہنے لگے، ”ہم یہاں اَپنے مویشیوں کے لیٔے بھیڑوں کے باڑے اَور اَپنی عورتوں اَور بچّوں کے لیٔے شہر بنانا چاہتے ہیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","لیکن ہم ہتھیار باندھ کر بنی اِسرائیل سے آگے آگے چلنے کے لیٔے تیّار ہیں جَب تک کہ اُن کو اُن کی جگہ تک نہ پہُنچائیں۔ اِس اَثنا میں ہماری عورتیں اَور بچّے اِس مُلک کے باشِندوں سے بچنے کے لیٔے فصیلدار شہروں میں رہیں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ہم اُس وقت تک اَپنے گھروں کو نہ لَوٹیں گے جَب تک کہ ہر اِسرائیلی اَپنی اَپنی مِیراث کا مالک نہیں ہو جاتا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ہم اُن کے ساتھ یردنؔ کے اُس پار کویٔی مِیراث نہ لیں گے کیونکہ ہمیں ہماری مِیراث یردنؔ کے مشرق میں ہی مِل چُکی ہے۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","تَب مَوشہ نے اُن سے کہا، ”اگر تُم یُوں کرو کہ لڑنے کے لیٔے یَاہوِہ کے حُضُور مُسلّح ہو جاؤ، ");
INSERT INTO urdoucv_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","اَور اگر تُم سَب مُسلّح ہوکر یَاہوِہ کے حُضُور یردنؔ پار جاؤ اَور جَب تک وہ اَپنے دُشمنوں کو اَپنے سامنے سے ہٹا نہ دے، ");
INSERT INTO urdoucv_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","اَور وہ مُلک یَاہوِہ کے حُضُور میں قبضہ میں نہ آ جائے تَب تک تُم واپس نہ آنا۔ تَب تُم یَاہوِہ اَور اِسرائیل کے نزدیک اَپنے فرض سے سبکدوش ہو جاؤگے اَور یہ مُلک یَاہوِہ کے حُضُور تمہاری مِلکیّت ہو جائے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","”لیکن اگر تُم اَیسا نہ کروگے تو یَاہوِہ کے گُنہگار ٹھہروگے اَور یقین جانو کہ تمہارا گُناہ تُمہیں پکڑ لے گا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","لہٰذا اَپنی عورتوں اَور بچّوں کے لیٔے شہر تعمیر کرو اَور اَپنے گلّوں کے لیٔے بھیڑوں کے باڑے بناؤ لیکن تُم نے جو وعدہ کیا ہے اُسے پُورا کرو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","تَب بنی گادؔ اَور بنی رُوبِنؔ نے مَوشہ سے کہا، ”تمہارے خادِم اَپنے آقا کے حُکم کے مُطابق ہی کریں گے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ہمارے بال بچّے، ہماری بھیڑ بکریوں کے گلّے اَور ہمارے مویشیوں کے ریوڑ یہاں گِلعادؔ کے شہروں میں رہیں گے ");
INSERT INTO urdoucv_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","لیکن تمہارے خادِموں میں سے ہر آدمی جَیسا کہ ہمارا آقا فرماتا ہے لڑائی کے لیٔے مُسلّح ہوکر یَاہوِہ کے حُضُور لڑنے کو یردنؔ پار جائے گا۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","تَب مَوشہ نے اُن کے بارے میں الیعزرؔ کاہِنؔ کو یہوشُعؔ بِن نُونؔ کو اَور اِسرائیلی قبیلوں کے خاندانوں کے سربراہوں کو ہدایات دیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","مَوشہ نے اُن سے کہا، ”اگر بنی گادؔ اَور بنی رُوبِنؔ کا ہر آدمی لڑائی کے لیٔے مُسلّح ہوکر یَاہوِہ کے حُضُور میں تمہارے ساتھ یردنؔ پار کر لے اَور جَب اُس مُلک پر تمہارا قبضہ ہو جائے تَب تُم گِلعادؔ کا مُلک اُنہیں مِیراث میں دینا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","لیکن اگر وہ مُسلّح ہوکر تمہارے ساتھ پار نہ جایٔیں تو وہ مُلکِ کنعانؔ میں تمہارے ساتھ اَپنی مِیراث قبُول کر لیں۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","تَب بنی گادؔ اَور بنی رُوبِنؔ نے جَواب دیا، ”تمہارے خادِم وَیسا ہی کریں گے جَیسا یَاہوِہ نے حُکم دیا ہے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ہم مُسلّح ہوکر یَاہوِہ کے حُضُور میں اُس پار مُلکِ کنعانؔ میں جایٔیں گے لیکن جو جائداد ہمیں مِیراث میں ملے وہ یردنؔ کے اِس پار ہی ہو۔“ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","تَب مَوشہ نے بنی گادؔ، بنی رُوبِنؔ اَور یُوسیفؔ کے بیٹے منشّہ کے نِصف قبیلہ کو امُوریوں کے بادشاہ سیحونؔ کی اَور باشانؔ کے بادشاہ عوگؔ کی مملکت یعنی اُن کا سارا مُلک دے دیا جِس میں اُن کے تمام شہر اَور اُن کے اِردگرد کے علاقے شامل تھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","بنی گادؔ نے دیبونؔ، عطاروتؔ، عروعؔر، ");
INSERT INTO urdoucv_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","عطروتؔ شوفانؔ، یعزیرؔ، یُگبِہؔا، ");
INSERT INTO urdoucv_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","بیت نِمرہؔ اَور بیت حارانؔ جَیسے فصیلدار شہر تعمیر کئے اَور اَپنے گلّوں کے لیٔے بھیڑوں کے باڑے بنائے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","اَور بنی رُوبِنؔ نے حِشبونؔ، الیعالہؔ اَور قِریتائم کو اَز سَر نَو تعمیر کیا، ");
INSERT INTO urdoucv_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","اَور نبوؔ اَور بَعل مِعُون (یہ نام تبدیل کئے گیٔے) اَور سِبماہؔ بھی تعمیر کئے۔ اُنہُوں نے اَپنے تعمیر کَردہ نئے شہروں کے دُوسرے نام رکھے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","منشّہ کے بیٹے مکیرؔ کی نَسل کے لوگوں نے گِلعادؔ جا کر اُس پر قبضہ کر لیا اَور وہاں جو امُوری تھے اُنہیں نکال دیا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","چنانچہ مَوشہ نے گِلعادؔ کا علاقہ مکیرؔ بِن منشّہ کو دے دیا اَور اُس کی نَسل کے لوگ وہاں بس گیٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","اَور منشّہ کے بیٹے یائیرؔ نے اِردگرد کی بستیوں پر قبضہ کر لیا اَور اُن کا نام حوّوت یائیرؔ رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","اَور نوبحؔ نے قناتؔ اَور اُس کے گرد و نواح کی بستیوں کو اَپنے قبضہ میں لے لیا اَور اُس علاقہ کا نام اَپنے ہی نام پر نوبحؔ رکھا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","جَب بنی اِسرائیل مَوشہ اَور اَہرونؔ کی قیادت میں دستے بنا کر مُلک مِصر سے نکلے تو اُنہُوں نے اَپنے سفر میں حسب ذیل منزلیں طے کیں۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","یَاہوِہ کے حُکم کے مُطابق مَوشہ نے اُن کے سفر کی یہ منزلیں درج کر لیں۔ لہٰذا اُن کا مَنزل بہ مَنزل سفر یُوں رہا: ");
INSERT INTO urdoucv_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","پہلے مہینے کے پندرھویں دِن یعنی فسح کے دُوسرے دِن بنی اِسرائیل نے رَعمسیسؔ سے کُوچ کیا۔ وہ سَب مِصریوں کی نظروں کے سامنے نہایت دِلیری سے نکل پڑے ");
INSERT INTO urdoucv_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","جو مِصری اَپنے پہلوٹھوں کو جنہیں یَاہوِہ نے مار ڈالا تھا دفن کرنے میں مصروف تھے کیونکہ یَاہوِہ نے اُن کے معبُودوں کو بھی سزا دی تھی۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","بنی اِسرائیل رَعمسیسؔ سے کُوچ کرکے سُکّوتؔ میں خیمہ زن ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","اَور سُکّوتؔ سے کُوچ کرکے ایتھامؔ میں جو بیابان کے سِرے پر ہے، خیمہ زن ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","پھر وہ ایتھامؔ سے کُوچ کرکے بَعل ضِفونؔ کے مشرق کی جانِب پیہاخیروتؔ کو مُڑے اَور مِگدُلؔ کے نزدیک خیمہ زن ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","تَب اُنہُوں نے پیہاخیروتؔ سے کُوچ کیا اَور سمُندر کے درمیان سے گزر کر بیابان میں داخل ہویٔے اَور ایتھامؔ کے بیابان میں تین دِن کی مَسافات طے کرکے مارہؔ میں خیمہ زن ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","مارہؔ سے کُوچ کرکے ایلِمؔ کو گیٔے جہاں پانی کے بَارہ چشمے اَور کھجور کے ستّر درخت تھے اَور وہاں خیمہ زن ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","پھر وہ ایلِمؔ سے کُوچ کرکے بحرِقُلزمؔ کے کنارے خیمہ زن ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","اَور بحرِقُلزمؔ سے کُوچ کرکے سِنؔ کے بیابان میں خیمہ زن ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","دشتِ سِنؔ کے بیابان سے کُوچ کرکے وہ دفقہؔ میں خیمہ زن ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","اَور دفقہؔ سے کُوچ کرکے الُوشؔ میں خیمہ زن ہویٔے۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","الُوشؔ سے کُوچ کرکے وہ رفیدیمؔ میں خیمہ زن ہویٔے جہاں لوگوں کو پینے کے لیٔے پانی نہ مِلا۔ ");
INSERT INTO urdoucv_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","رفیدیم