﻿USE sofia;
DROP TABLE IF EXISTS sofia.urdgvu_vpl;
CREATE TABLE urdgvu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES urdgvu_vpl WRITE;
INSERT INTO urdgvu_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ابتدا میں اللہ نے آسمان اور زمین کو بنایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ابھی تک زمین ویران اور خالی تھی۔ وہ گہرے پانی سے ڈھکی ہوئی تھی جس کے اوپر اندھیرا ہی اندھیرا تھا۔ اللہ کا روح پانی کے اوپر منڈلا رہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","پھر اللہ نے کہا، ”روشنی ہو جائے“ تو روشنی پیدا ہو گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","اللہ نے دیکھا کہ روشنی اچھی ہے، اور اُس نے روشنی کو تاریکی سے الگ کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","اللہ نے روشنی کو دن کا نام دیا اور تاریکی کو رات کا۔ شام ہوئی، پھر صبح۔ یوں پہلا دن گزر گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","اللہ نے کہا، ”پانی کے درمیان ایک ایسا گنبد پیدا ہو جائے جس سے نچلا پانی اوپر کے پانی سے الگ ہو جائے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ایسا ہی ہوا۔ اللہ نے ایک ایسا گنبد بنایا جس سے نچلا پانی اوپر کے پانی سے الگ ہو گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","اللہ نے گنبد کو آسمان کا نام دیا۔ شام ہوئی، پھر صبح۔ یوں دوسرا دن گزر گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","اللہ نے کہا، ”جو پانی آسمان کے نیچے ہے وہ ایک جگہ جمع ہو جائے تاکہ دوسری طرف خشک جگہ نظر آئے۔“ ایسا ہی ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","اللہ نے خشک جگہ کو زمین کا نام دیا اور جمع شدہ پانی کو سمندر کا۔ اور اللہ نے دیکھا کہ یہ اچھا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","پھر اُس نے کہا، ”زمین ہریاول پیدا کرے، ایسے پودے جو بیج رکھتے ہوں اور ایسے درخت جن کے پھل اپنی اپنی قسم کے بیج رکھتے ہوں۔“ ایسا ہی ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","زمین نے ہریاول پیدا کی، ایسے پودے جو اپنی اپنی قسم کے بیج رکھتے اور ایسے درخت جن کے پھل اپنی اپنی قسم کے بیج رکھتے تھے۔ اللہ نے دیکھا کہ یہ اچھا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","شام ہوئی، پھر صبح۔ یوں تیسرا دن گزر گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","اللہ نے کہا، ”آسمان پر روشنیاں پیدا ہو جائیں تاکہ دن اور رات میں امتیاز ہو اور اِسی طرح مختلف موسموں، دنوں اور سالوں میں بھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","آسمان کی یہ روشنیاں دنیا کو روشن کریں۔“ ایسا ہی ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","اللہ نے دو بڑی روشنیاں بنائیں، سورج جو بڑا تھا دن پر حکومت کرنے کو اور چاند جو چھوٹا تھا رات پر۔ اِن کے علاوہ اُس نے ستاروں کو بھی بنایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","اُس نے اُنہیں آسمان پر رکھا تاکہ وہ دنیا کو روشن کریں، ");
INSERT INTO urdgvu_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","دن اور رات پر حکومت کریں اور روشنی اور تاریکی میں امتیاز پیدا کریں۔ اللہ نے دیکھا کہ یہ اچھا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","شام ہوئی، پھر صبح۔ یوں چوتھا دن گزر گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","اللہ نے کہا، ”پانی آبی جانداروں سے بھر جائے اور فضا میں پرندے اُڑتے پھریں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","اللہ نے بڑے بڑے سمندری جانور بنائے، پانی کی تمام دیگر مخلوقات اور ہر قسم کے پَر رکھنے والے جاندار بھی بنائے۔ اللہ نے دیکھا کہ یہ اچھا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","اُس نے اُنہیں برکت دی اور کہا، ”پھلو پھولو اور تعداد میں بڑھتے جاؤ۔ سمندر تم سے بھر جائے۔ اِسی طرح پرندے زمین پر تعداد میں بڑھ جائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","شام ہوئی، پھر صبح۔ یوں پانچواں دن گزر گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","اللہ نے کہا، ”زمین ہر قسم کے جاندار پیدا کرے: مویشی، رینگنے والے اور جنگلی جانور۔“ ایسا ہی ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","اللہ نے ہر قسم کے مویشی، رینگنے والے اور جنگلی جانور بنائے۔ اُس نے دیکھا کہ یہ اچھا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","اللہ نے کہا، ”آؤ اب ہم انسان کو اپنی صورت پر بنائیں، وہ ہم سے مشابہت رکھے۔ وہ تمام جانوروں پر حکومت کرے، سمندر کی مچھلیوں پر، ہَوا کے پرندوں پر، مویشیوں پر، جنگلی جانوروں پر اور زمین پر کے تمام رینگنے والے جانداروں پر۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","یوں اللہ نے انسان کو اپنی صورت پر بنایا، اللہ کی صورت پر۔ اُس نے اُنہیں مرد اور عورت بنایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","اللہ نے اُنہیں برکت دی اور کہا، ”پھلو پھولو اور تعداد میں بڑھتے جاؤ۔ دنیا تم سے بھر جائے اور تم اُس پر اختیار رکھو۔ سمندر کی مچھلیوں، ہَوا کے پرندوں اور زمین پر کے تمام رینگنے والے جانداروں پر حکومت کرو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","اللہ نے اُن سے مزید کہا، ”تمام بیج دار پودے اور پھل دار درخت تمہارے ہی ہیں۔ مَیں اُنہیں تم کو کھانے کے لئے دیتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","اِس طرح مَیں تمام جانوروں کو کھانے کے لئے ہریالی دیتا ہوں۔ جس میں بھی جان ہے وہ یہ کھا سکتا ہے، خواہ وہ زمین پر چلنے پھرنے والا جانور، ہَوا کا پرندہ یا زمین پر رینگنے والا کیوں نہ ہو۔“ ایسا ہی ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","اللہ نے سب پر نظر کی تو دیکھا کہ وہ بہت اچھا بن گیا ہے۔ شام ہوئی، پھر صبح۔ چھٹا دن گزر گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","یوں آسمان و زمین اور اُن کی تمام چیزوں کی تخلیق مکمل ہوئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ساتویں دن اللہ کا سارا کام تکمیل کو پہنچا۔ اِس سے فارغ ہو کر اُس نے آرام کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","اللہ نے ساتویں دن کو برکت دی اور اُسے مخصوص و مُقدّس کیا۔ کیونکہ اُس دن اُس نے اپنے تمام تخلیقی کام سے فارغ ہو کر آرام کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","یہ آسمان و زمین کی تخلیق کا بیان ہے۔ جب رب خدا نے آسمان و زمین کو بنایا ");
INSERT INTO urdgvu_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","تو شروع میں جھاڑیاں اور پودے نہیں اُگتے تھے۔ وجہ یہ تھی کہ اللہ نے بارش کا انتظام نہیں کیا تھا۔ اور ابھی انسان بھی پیدا نہیں ہوا تھا کہ زمین کی کھیتی باڑی کرتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","اِس کی بجائے زمین میں سے دُھند اُٹھ کر اُس کی پوری سطح کو تر کرتی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","پھر رب خدا نے زمین سے مٹی لے کر انسان کو تشکیل دیا اور اُس کے نتھنوں میں زندگی کا دم پھونکا تو وہ جیتی جان ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","رب خدا نے مشرق میں ملکِ عدن میں ایک باغ لگایا۔ اُس میں اُس نے اُس آدمی کو رکھا جسے اُس نے بنایا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","رب خدا کے حکم پر زمین میں سے طرح طرح کے درخت پھوٹ نکلے، ایسے درخت جو دیکھنے میں دل کش اور کھانے کے لئے اچھے تھے۔ باغ کے بیچ میں دو درخت تھے۔ ایک کا پھل زندگی بخشتا تھا جبکہ دوسرے کا پھل اچھے اور بُرے کی پہچان دلاتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","عدن میں سے ایک دریا نکل کر باغ کی آب پاشی کرتا تھا۔ وہاں سے بہہ کر وہ چار شاخوں میں تقسیم ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_11‏","002_2_11‏","GEN","2","11‏","12","پہلی شاخ کا نام فیسون ہے۔ وہ ملکِ حویلہ کو گھیرے ہوئے بہتی ہے جہاں خالص سونا، گُوگل کا گوند اور عقیقِ احمر پائے جاتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","دوسری کا نام جیحون ہے جو کوش کو گھیرے ہوئے بہتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","تیسری کا نام دِجلہ ہے جو اسور کے مشرق کو جاتی ہے اور چوتھی کا نام فرات ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","رب خدا نے پہلے آدمی کو باغِ عدن میں رکھا تاکہ وہ اُس کی باغ بانی اور حفاظت کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","لیکن رب خدا نے اُسے آگاہ کیا، ”تجھے ہر درخت کا پھل کھانے کی اجازت ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","لیکن جس درخت کا پھل اچھے اور بُرے کی پہچان دلاتا ہے اُس کا پھل کھانا منع ہے۔ اگر اُسے کھائے تو یقیناً مرے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","رب خدا نے کہا، ”اچھا نہیں کہ آدمی اکیلا رہے۔ مَیں اُس کے لئے ایک مناسب مددگار بناتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","رب خدا نے مٹی سے زمین پر چلنے پھرنے والے جانور اور ہَوا کے پرندے بنائے تھے۔ اب وہ اُنہیں آدمی کے پاس لے آیا تاکہ معلوم ہو جائے کہ وہ اُن کے کیا کیا نام رکھے گا۔ یوں ہر جانور کو آدم کی طرف سے نام مل گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","آدمی نے تمام مویشیوں، پرندوں اور زمین پر پھرنے والے جانداروں کے نام رکھے۔ لیکن اُسے اپنے لئے کوئی مناسب مددگار نہ ملا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","تب رب خدا نے اُسے سُلا دیا۔ جب وہ گہری نیند سو رہا تھا تو اُس نے اُس کی پسلیوں میں سے ایک نکال کر اُس کی جگہ گوشت بھر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","پسلی سے اُس نے عورت بنائی اور اُسے آدمی کے پاس لے آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","اُسے دیکھ کر وہ پکار اُٹھا، ”واہ! یہ تو مجھ جیسی ہی ہے، میری ہڈیوں میں سے ہڈی اور میرے گوشت میں سے گوشت ہے۔ اِس کا نام ناری رکھا جائے کیونکہ وہ نر سے نکالی گئی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","اِس لئے مرد اپنے ماں باپ کو چھوڑ کر اپنی بیوی کے ساتھ پیوست ہو جاتا ہے، اور وہ دونوں ایک ہو جاتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","دونوں، آدمی اور عورت ننگے تھے، لیکن یہ اُن کے لئے شرم کا باعث نہیں تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","سانپ زمین پر چلنے پھرنے والے اُن تمام جانوروں سے زیادہ چالاک تھا جن کو رب خدا نے بنایا تھا۔ اُس نے عورت سے پوچھا، ”کیا اللہ نے واقعی کہا کہ باغ کے کسی بھی درخت کا پھل نہ کھانا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","عورت نے جواب دیا، ”ہرگز نہیں۔ ہم باغ کا ہر پھل کھا سکتے ہیں، ");
INSERT INTO urdgvu_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","صرف اُس درخت کے پھل سے گریز کرنا ہے جو باغ کے بیچ میں ہے۔ اللہ نے کہا کہ اُس کا پھل نہ کھاؤ بلکہ اُسے چھونا بھی نہیں، ورنہ تم یقیناً مر جاؤ گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","سانپ نے عورت سے کہا، ”تم ہرگز نہ مروگے، ");
INSERT INTO urdgvu_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","بلکہ اللہ جانتا ہے کہ جب تم اُس کا پھل کھاؤ گے تو تمہاری آنکھیں کھل جائیں گی اور تم اللہ کی مانند ہو جاؤ گے، تم جو بھی اچھا اور بُرا ہے اُسے جان لو گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","عورت نے درخت پر غور کیا کہ کھانے کے لئے اچھا اور دیکھنے میں بھی دل کش ہے۔ سب سے دل فریب بات یہ کہ اُس سے سمجھ حاصل ہو سکتی ہے! یہ سوچ کر اُس نے اُس کا پھل لے کر اُسے کھایا۔ پھر اُس نے اپنے شوہر کو بھی دے دیا، کیونکہ وہ اُس کے ساتھ تھا۔ اُس نے بھی کھا لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","لیکن کھاتے ہی اُن کی آنکھیں کھل گئیں اور اُن کو معلوم ہوا کہ ہم ننگے ہیں۔ چنانچہ اُنہوں نے انجیر کے پتے سی کر لنگیاں بنا لیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","شام کے وقت جب ٹھنڈی ہَوا چلنے لگی تو اُنہوں نے رب خدا کو باغ میں چلتے پھرتے سنا۔ وہ ڈر کے مارے درختوں کے پیچھے چھپ گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","رب خدا نے پکار کر کہا، ”آدم، تُو کہاں ہے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","آدم نے جواب دیا، ”مَیں نے تجھے باغ میں چلتے ہوئے سنا تو ڈر گیا، کیونکہ مَیں ننگا ہوں۔ اِس لئے مَیں چھپ گیا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","اُس نے پوچھا، ”کس نے تجھے بتایا کہ تُو ننگا ہے؟ کیا تُو نے اُس درخت کا پھل کھایا ہے جسے کھانے سے مَیں نے منع کیا تھا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","آدم نے کہا، ”جو عورت تُو نے میرے ساتھ رہنے کے لئے دی ہے اُس نے مجھے پھل دیا۔ اِس لئے مَیں نے کھا لیا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","اب رب خدا عورت سے مخاطب ہوا، ”تُو نے یہ کیوں کیا؟“ عورت نے جواب دیا، ”سانپ نے مجھے بہکایا تو مَیں نے کھایا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","رب خدا نے سانپ سے کہا، ”چونکہ تُو نے یہ کیا، اِس لئے تُو تمام مویشیوں اور جنگلی جانوروں میں لعنتی ہے۔ تُو عمر بھر پیٹ کے بل رینگے گا اور خاک چاٹے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","مَیں تیرے اور عورت کے درمیان دشمنی پیدا کروں گا۔ اُس کی اولاد تیری اولاد کی دشمن ہو گی۔ وہ تیرے سر کو کچل ڈالے گی جبکہ تُو اُس کی ایڑی پر کاٹے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","پھر رب خدا عورت سے مخاطب ہوا اور کہا، ”جب تُو اُمید سے ہو گی تو مَیں تیری تکلیف کو بہت بڑھاؤں گا۔ جب تیرے بچے ہوں گے تو تُو شدید درد کا شکار ہو گی۔ تُو اپنے شوہر کی تمنا کرے گی لیکن وہ تجھ پر حکومت کرے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","آدم سے اُس نے کہا، ”تُو نے اپنی بیوی کی بات مانی اور اُس درخت کا پھل کھایا جسے کھانے سے مَیں نے منع کیا تھا۔ اِس لئے تیرے سبب سے زمین پر لعنت ہے۔ اُس سے خوراک حاصل کرنے کے لئے تجھے عمر بھر محنت مشقت کرنی پڑے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","تیرے لئے وہ خاردار پودے اور اونٹ کٹارے پیدا کرے گی، حالانکہ تُو اُس سے اپنی خوراک بھی حاصل کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","پسینہ بہا بہا کر تجھے روٹی کمانے کے لئے بھاگ دوڑ کرنی پڑے گی۔ اور یہ سلسلہ موت تک جاری رہے گا۔ تُو محنت کرتے کرتے دوبارہ زمین میں لوٹ جائے گا، کیونکہ تُو اُسی سے لیا گیا ہے۔ تُو خاک ہے اور دوبارہ خاک میں مل جائے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","آدم نے اپنی بیوی کا نام حوا یعنی زندگی رکھا، کیونکہ بعد میں وہ تمام زندوں کی ماں بن گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","رب خدا نے آدم اور اُس کی بیوی کے لئے کھالوں سے لباس بنا کر اُنہیں پہنایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","اُس نے کہا، ”انسان ہماری مانند ہو گیا ہے، وہ اچھے اور بُرے کا علم رکھتا ہے۔ اب ایسا نہ ہو کہ وہ ہاتھ بڑھا کر زندگی بخشنے والے درخت کے پھل سے لے اور اُس سے کھا کر ہمیشہ تک زندہ رہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","اِس لئے رب خدا نے اُسے باغِ عدن سے نکال کر اُس زمین کی کھیتی باڑی کرنے کی ذمہ داری دی جس میں سے اُسے لیا گیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","انسان کو خارج کرنے کے بعد اُس نے باغِ عدن کے مشرق میں کروبی فرشتے کھڑے کئے اور ساتھ ساتھ ایک آتشی تلوار رکھی جو اِدھر اُدھر گھومتی تھی تاکہ اُس راستے کی حفاظت کرے جو زندگی بخشنے والے درخت تک پہنچاتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","آدم حوا سے ہم بستر ہوا تو اُن کا پہلا بیٹا قابیل پیدا ہوا۔ حوا نے کہا، ”رب کی مدد سے مَیں نے ایک مرد حاصل کیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","بعد میں قابیل کا بھائی ہابیل پیدا ہوا۔ ہابیل بھیڑبکریوں کا چرواہا بن گیا جبکہ قابیل کھیتی باڑی کرنے لگا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","کچھ دیر کے بعد قابیل نے رب کو اپنی فصلوں میں سے کچھ پیش کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ہابیل نے بھی نذرانہ پیش کیا، لیکن اُس نے اپنی بھیڑبکریوں کے کچھ پہلوٹھے اُن کی چربی سمیت چڑھائے۔ ہابیل کا نذرانہ رب کو پسند آیا، ");
INSERT INTO urdgvu_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","مگر قابیل کا نذرانہ منظور نہ ہوا۔ یہ دیکھ کر قابیل بڑے غصے میں آ گیا، اور اُس کا منہ بگڑ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","رب نے پوچھا، ”تُو غصے میں کیوں آ گیا ہے؟ تیرا منہ کیوں لٹکا ہوا ہے؟ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","کیا اگر تُو اچھی نیت رکھتا ہے تو اپنی نظر اُٹھا کر میری طرف نہیں دیکھ سکے گا؟ لیکن اگر اچھی نیت نہیں رکھتا تو خبردار! گناہ دروازے پر دبکا بیٹھا ہے اور تجھے چاہتا ہے۔ لیکن تیرا فرض ہے کہ اُس پر غالب آئے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ایک دن قابیل نے اپنے بھائی سے کہا، ”آؤ، ہم باہر کھلے میدان میں چلیں۔“ اور جب وہ کھلے میدان میں تھے تو قابیل نے اپنے بھائی ہابیل پر حملہ کر کے اُسے مار ڈالا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","تب رب نے قابیل سے پوچھا، ”تیرا بھائی ہابیل کہاں ہے؟“ قابیل نے جواب دیا، ”مجھے کیا پتا! کیا اپنے بھائی کی دیکھ بھال کرنا میری ذمہ داری ہے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","رب نے کہا، ”تُو نے کیا کِیا ہے؟ تیرے بھائی کا خون زمین میں سے پکار کر مجھ سے فریاد کر رہا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","اِس لئے تجھ پر لعنت ہے اور زمین نے تجھے رد کیا ہے، کیونکہ زمین کو منہ کھول کر تیرے ہاتھ سے قتل کئے ہوئے بھائی کا خون پینا پڑا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","اب سے جب تُو کھیتی باڑی کرے گا تو زمین اپنی پیداوار دینے سے انکار کرے گی۔ تُو مفرور ہو کر مارا مارا پھرے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","قابیل نے کہا، ”میری سزا نہایت سخت ہے۔ مَیں اِسے برداشت نہیں کر پاؤں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","آج تُو مجھے زمین کی سطح سے بھگا رہا ہے اور مجھے تیرے حضور سے بھی چھپ جانا ہے۔ مَیں مفرور کی حیثیت سے مارا مارا پھرتا رہوں گا، اِس لئے جس کو بھی پتا چلے گا کہ مَیں کہاں ہوں وہ مجھے قتل کر ڈالے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","لیکن رب نے اُس سے کہا، ”ہرگز نہیں۔ جو قابیل کو قتل کرے اُس سے سات گُنا بدلہ لیا جائے گا۔“ پھر رب نے اُس پر ایک نشان لگایا تاکہ جو بھی قابیل کو دیکھے وہ اُسے قتل نہ کر دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","اِس کے بعد قابیل رب کے حضور سے چلا گیا اور عدن کے مشرق کی طرف نود کے علاقے میں جا بسا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","قابیل کی بیوی حاملہ ہوئی۔ بیٹا پیدا ہوا جس کا نام حنوک رکھا گیا۔ قابیل نے ایک شہر تعمیر کیا اور اپنے بیٹے کی خوشی میں اُس کا نام حنوک رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","حنوک کا بیٹا عیراد تھا، عیراد کا بیٹا محویائیل، محویائیل کا بیٹا متوسائیل اور متوسائیل کا بیٹا لمک تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","لمک کی دو بیویاں تھیں، عدہ اورضِلّہ۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","عدہ کا بیٹا یابل تھا۔ اُس کی نسل کے لوگ خیموں میں رہتے اور مویشی پالتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","یابل کا بھائی یوبل تھا۔ اُس کی نسل کے لوگ سرود اور بانسری بجاتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ضِلّہ کے بھی بیٹا پیدا ہوا جس کا نام تُوبل قابیل تھا۔ وہ لوہار تھا۔ اُس کی نسل کے لوگ پیتل اور لوہے کی چیزیں بناتے تھے۔ تُوبل قابیل کی بہن کا نام نعمہ تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ایک دن لمک نے اپنی بیویوں سے کہا، ”عدہ اور ضِلّہ، میری بات سنو! لمک کی بیویو، میرے الفاظ پر غور کرو! ");
INSERT INTO urdgvu_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ایک آدمی نے مجھے زخمی کیا تو مَیں نے اُسے مار ڈالا۔ ایک لڑکے نے میرے چوٹ لگائی تو مَیں نے اُسے قتل کر دیا۔ جو قابیل کو قتل کرے اُس سے سات گُنا بدلہ لیا جائے گا، لیکن جو لمک کو قتل کرے اُس سے ستتر گُنا بدلہ لیا جائے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","آدم اور حوا کا ایک اَور بیٹا پیدا ہوا۔ حوا نے اُس کا نام سیت رکھ کر کہا، ”اللہ نے مجھے ہابیل کی جگہ جسے قابیل نے قتل کیا ایک اَور بیٹا بخشا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","سیت کے ہاں بھی بیٹا پیدا ہوا۔ اُس نے اُس کا نام انوس رکھا۔ اُن دنوں میں لوگ رب کا نام لے کر عبادت کرنے لگے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ذیل میں آدم کا نسب نامہ درج ہے۔ جب اللہ نے انسان کو خلق کیا تو اُس نے اُسے اپنی صورت پر بنایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","اُس نے اُنہیں مرد اور عورت پیدا کیا۔ اور جس دن اُس نے اُنہیں خلق کیا اُس نے اُنہیں برکت دے کر اُن کا نام آدم یعنی انسان رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","آدم کی عمر 130 سال تھی جب اُس کا بیٹا سیت پیدا ہوا۔ سیت صورت کے لحاظ سے اپنے باپ کی مانند تھا، وہ اُس سے مشابہت رکھتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","سیت کی پیدائش کے بعد آدم مزید 800 سال زندہ رہا۔ اُس کے اَور بیٹے بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","وہ 930 سال کی عمر میں فوت ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","سیت 105 سال کا تھا جب اُس کا بیٹا انوس پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","اِس کے بعد وہ مزید 807 سال زندہ رہا۔ اُس کے اَور بیٹے بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","وہ 912 سال کی عمر میں فوت ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","انوس 90 برس کا تھا جب اُس کا بیٹا قینان پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","اِس کے بعد وہ مزید 815 سال زندہ رہا۔ اُس کے اَور بیٹے بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","وہ 905 سال کی عمر میں فوت ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","قینان 70 سال کا تھا جب اُس کا بیٹا مہلل ایل پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","اِس کے بعد وہ مزید 840 سال زندہ رہا۔ اُس کے اَور بیٹے بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","وہ 910 سال کی عمر میں فوت ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","مہلل ایل 65 سال کا تھا جب اُس کا بیٹا یارد پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","اِس کے بعد وہ مزید 830 سال زندہ رہا۔ اُس کے اَور بیٹے بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","وہ 895 سال کی عمر میں فوت ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","یارد 162 سال کا تھا جب اُس کا بیٹا حنوک پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","اِس کے بعد وہ مزید 800 سال زندہ رہا۔ اُس کے اَور بیٹے بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","وہ 962 سال کی عمر میں فوت ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","حنوک 65 سال کا تھا جب اُس کا بیٹا متوسلح پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","اِس کے بعد وہ مزید 300 سال اللہ کے ساتھ چلتا رہا۔ اُس کے اَور بیٹے بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","وہ کُل 365 سال دنیا میں رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","حنوک اللہ کے ساتھ ساتھ چلتا تھا۔ 365 سال کی عمر میں وہ غائب ہوا، کیونکہ اللہ نے اُسے اُٹھا لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","متوسلح 187 سال کا تھا جب اُس کا بیٹا لمک پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","وہ مزید 782 سال زندہ رہا۔ اُس کے اَور بیٹے اور بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","وہ 969 سال کی عمر میں فوت ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","لمک 182 سال کا تھا جب اُس کا بیٹا پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","اُس نے اُس کا نام نوح یعنی تسلی رکھا، کیونکہ اُس نے اُس کے بارے میں کہا، ”ہمارا کھیتی باڑی کا کام نہایت تکلیف دہ ہے، اِس لئے کہ اللہ نے زمین پر لعنت بھیجی ہے۔ لیکن اب ہم بیٹے کی معرفت تسلی پائیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","اِس کے بعد وہ مزید 595 سال زندہ رہا۔ اُس کے اَور بیٹے بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","وہ 777 سال کی عمر میں فوت ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","نوح 500 سال کا تھا جب اُس کے بیٹے سِم، حام اور یافت پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","دنیا میں لوگوں کی تعداد بڑھنے لگی۔ اُن کے ہاں بیٹیاں پیدا ہوئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","تب آسمانی ہستیوں نے دیکھا کہ بنی نوع انسان کی بیٹیاں خوب صورت ہیں، اور اُنہوں نے اُن میں سے کچھ چن کر اُن سے شادی کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","پھر رب نے کہا، ”میری روح ہمیشہ کے لئے انسان میں نہ رہے کیونکہ وہ فانی مخلوق ہے۔ اب سے وہ 120 سال سے زیادہ زندہ نہیں رہے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","اُن دنوں میں اور بعد میں بھی دنیا میں دیو قامت افراد تھے جو انسانی عورتوں اور اُن آسمانی ہستیوں کی شادیوں سے پیدا ہوئے تھے۔ یہ دیو قامت افراد قدیم زمانے کے مشہور سورما تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","رب نے دیکھا کہ انسان نہایت بگڑ گیا ہے، کہ اُس کے تمام خیالات لگاتار بُرائی کی طرف مائل رہتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","وہ پچھتایا کہ مَیں نے انسان کو بنا کر دنیا میں رکھ دیا ہے، اور اُسے سخت دُکھ ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","اُس نے کہا، ”گو مَیں ہی نے انسان کو خلق کیا مَیں اُسے رُوئے زمین پر سے مٹا ڈالوں گا۔ مَیں نہ صرف لوگوں کو بلکہ زمین پر چلنے پھرنے اور رینگنے والے جانوروں اور ہَوا کے پرندوں کو بھی ہلاک کر دوں گا، کیونکہ مَیں پچھتاتا ہوں کہ مَیں نے اُن کو بنایا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","صرف نوح پر رب کی نظرِ کرم تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","یہ اُس کی زندگی کا بیان ہے۔ نوح راست باز تھا۔ اُس زمانے کے لوگوں میں صرف وہی بےقصور تھا۔ وہ اللہ کے ساتھ ساتھ چلتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","نوح کے تین بیٹے تھے، سِم، حام اور یافت۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","لیکن دنیا اللہ کی نظر میں بگڑی ہوئی اور ظلم و تشدد سے بھری ہوئی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","جہاں بھی اللہ دیکھتا دنیا خراب تھی، کیونکہ تمام جانداروں نے زمین پر اپنی روِش کو بگاڑ دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","تب اللہ نے نوح سے کہا، ”مَیں نے تمام جانداروں کو ختم کرنے کا فیصلہ کیا ہے، کیونکہ اُن کے سبب سے پوری دنیا ظلم و تشدد سے بھر گئی ہے۔ چنانچہ مَیں اُن کو زمین سمیت تباہ کر دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","اب اپنے لئے سرو کی لکڑی کی کشتی بنا لے۔ اُس میں کمرے ہوں اور اُسے اندر اور باہر تارکول لگا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","اُس کی لمبائی 450 فٹ، چوڑائی 75 فٹ اور اونچائی 45 فٹ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","کشتی کی چھت کو یوں بنانا کہ اُس کے نیچے 18 انچ کھلا رہے۔ ایک طرف دروازہ ہو، اور اُس کی تین منزلیں ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","مَیں پانی کا اِتنا بڑا سیلاب لاؤں گا کہ وہ زمین کے تمام جانداروں کو ہلاک کر ڈالے گا۔ زمین پر سب کچھ فنا ہو جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","لیکن تیرے ساتھ مَیں عہد باندھوں گا جس کے تحت تُو اپنے بیٹوں، اپنی بیوی اور بہوؤں کے ساتھ کشتی میں جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ہر قسم کے جانور کا ایک نر اور ایک مادہ بھی اپنے ساتھ کشتی میں لے جانا تاکہ وہ تیرے ساتھ جیتے بچیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ہر قسم کے پَر رکھنے والے جانور اور ہر قسم کے زمین پر پھرنے یا رینگنے والے جانور دو دو ہو کر تیرے پاس آئیں گے تاکہ جیتے بچ جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","جو بھی خوراک درکار ہے اُسے اپنے اور اُن کے لئے جمع کر کے کشتی میں محفوظ کر لینا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","نوح نے سب کچھ ویسا ہی کیا جیسا اللہ نے اُسے بتایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","پھر رب نے نوح سے کہا، ”اپنے گھرانے سمیت کشتی میں داخل ہو جا، کیونکہ اِس دور کے لوگوں میں سے مَیں نے صرف تجھے راست باز پایا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ہر قسم کے پاک جانوروں میں سے سات سات نر و مادہ کے جوڑے جبکہ ناپاک جانوروں میں سے نر و مادہ کا صرف ایک ایک جوڑا ساتھ لے جانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","اِسی طرح ہر قسم کے پَر رکھنے والوں میں سے سات سات نر و مادہ کے جوڑے بھی ساتھ لے جانا تاکہ اُن کی نسلیں بچی رہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ایک ہفتے کے بعد مَیں چالیس دن اور چالیس رات متواتر بارش برساؤں گا۔ اِس سے مَیں تمام جانداروں کو رُوئے زمین پر سے مٹا ڈالوں گا، اگرچہ مَیں ہی نے اُنہیں بنایا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","نوح نے ویسا ہی کیا جیسا رب نے حکم دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","وہ 600 سال کا تھا جب یہ طوفانی سیلاب زمین پر آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","طوفانی سیلاب سے بچنے کے لئے نوح اپنے بیٹوں، اپنی بیوی اور بہوؤں کے ساتھ کشتی میں سوار ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","زمین پر پھرنے والے پاک اور ناپاک جانور، پَر رکھنے والے اور تمام رینگنے والے جانور بھی آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","نر و مادہ کی صورت میں دو دو ہو کر وہ نوح کے پاس آ کر کشتی میں سوار ہوئے۔ سب کچھ ویسا ہی ہوا جیسا اللہ نے نوح کو حکم دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ایک ہفتے کے بعد طوفانی سیلاب زمین پر آ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","یہ سب کچھ اُس وقت ہوا جب نوح 600 سال کا تھا۔ دوسرے مہینے کے 17ویں دن زمین کی گہرائیوں میں سے تمام چشمے پھوٹ نکلے اور آسمان پر پانی کے دریچے کھل گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","چالیس دن اور چالیس رات تک موسلادھار بارش ہوتی رہی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","جب بارش شروع ہوئی تو نوح، اُس کے بیٹے سِم، حام اور یافت، اُس کی بیوی اور بہوئیں کشتی میں سوار ہو چکے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","اُن کے ساتھ ہر قسم کے جنگلی جانور، مویشی، رینگنے اور پَر رکھنے والے جانور تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ہر قسم کے جاندار دو دو ہو کر نوح کے پاس آ کر کشتی میں سوار ہو چکے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","نر و مادہ آئے تھے۔ سب کچھ ویسا ہی ہوا تھا جیسا اللہ نے نوح کو حکم دیا تھا۔ پھر رب نے دروازے کو بند کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","چالیس دن تک طوفانی سیلاب جاری رہا۔ پانی چڑھا تو اُس نے کشتی کو زمین پر سے اُٹھا لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","پانی زور پکڑ کر بہت بڑھ گیا، اور کشتی اُس پر تیرنے لگی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","آخرکار پانی اِتنا زیادہ ہو گیا کہ تمام اونچے پہاڑ بھی اُس میں چھپ گئے، ");
INSERT INTO urdgvu_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","بلکہ سب سے اونچی چوٹی پر پانی کی گہرائی 20 فٹ تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","زمین پر رہنے والی ہر مخلوق ہلاک ہوئی۔ پرندے، مویشی، جنگلی جانور، تمام جاندار جن سے زمین بھری ہوئی تھی اور انسان، سب کچھ مر گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","زمین پر ہر جاندار مخلوق ہلاک ہوئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","یوں ہر مخلوق کو رُوئے زمین پر سے مٹا دیا گیا۔ انسان، زمین پر پھرنے اور رینگنے والے جانور اور پرندے، سب کچھ ختم کر دیا گیا۔ صرف نوح اور کشتی میں سوار اُس کے ساتھی بچ گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","سیلاب ڈیڑھ سَو دن تک زمین پر غالب رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","لیکن اللہ کو نوح اور تمام جانور یاد رہے جو کشتی میں تھے۔ اُس نے ہَوا چلا دی جس سے پانی کم ہونے لگا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","زمین کے چشمے اور آسمان پر کے پانی کے دریچے بند ہو گئے، اور بارش رُک گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","پانی گھٹتا گیا۔ 150 دن کے بعد وہ کافی کم ہو گیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ساتویں مہینے کے 17 ویں دن کشتی اراراط کے ایک پہاڑ پر ٹک گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","دسویں مہینے کے پہلے دن پانی اِتنا کم ہو گیا تھا کہ پہاڑوں کی چوٹیاں نظر آنے لگی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_6‏","002_8_6‏","GEN","8","6‏","7","چالیس دن کے بعد نوح نے کشتی کی کھڑکی کھول کر ایک کوّا چھوڑ دیا، اور وہ اُڑ کر چلا گیا۔ لیکن جب تک زمین پر پانی تھا وہ آتا جاتا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","پھر نوح نے ایک کبوتر چھوڑ دیا تاکہ پتا چلے کہ زمین پانی سے نکل آئی ہے یا نہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","لیکن کبوتر کو کہیں بھی بیٹھنے کی جگہ نہ ملی، کیونکہ اب تک پوری زمین پر پانی ہی پانی تھا۔ وہ کشتی اور نوح کے پاس واپس آ گیا، اور نوح نے اپنا ہاتھ بڑھایا اور کبوتر کو پکڑ کر اپنے پاس کشتی میں رکھ لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","اُس نے ایک ہفتہ اَور انتظار کر کے کبوتر کو دوبارہ چھوڑ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","شام کے وقت وہ لوٹ آیا۔ اِس دفعہ اُس کی چونچ میں زیتون کا تازہ پتا تھا۔ تب نوح کو معلوم ہوا کہ زمین پانی سے نکل آئی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","اُس نے مزید ایک ہفتے کے بعد کبوتر کو چھوڑ دیا۔ اِس دفعہ وہ واپس نہ آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","جب نوح 601 سال کا تھا تو پہلے مہینے کے پہلے دن زمین کی سطح پر پانی ختم ہو گیا۔ تب نوح نے کشتی کی چھت کھول دی اور دیکھا کہ زمین کی سطح پر پانی نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","دوسرے مہینے کے 27ویں دن زمین بالکل خشک ہو گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","پھر اللہ نے نوح سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","”اپنی بیوی، بیٹوں اور بہوؤں کے ساتھ کشتی سے نکل آ۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","جتنے بھی جانور ساتھ ہیں اُنہیں نکال دے، خواہ پرندے ہوں، خواہ زمین پر پھرنے یا رینگنے والے جانور۔ وہ دنیا میں پھیل جائیں، نسل بڑھائیں اور تعداد میں بڑھتے جائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","چنانچہ نوح اپنے بیٹوں، اپنی بیوی اور بہوؤں سمیت نکل آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","تمام جانور اور پرندے بھی اپنی اپنی قسم کے گروہوں میں کشتی سے نکلے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","اُس وقت نوح نے رب کے لئے قربان گاہ بنائی۔ اُس نے تمام پھرنے اور اُڑنے والے پاک جانوروں میں سے کچھ چن کر اُنہیں ذبح کیا اور قربان گاہ پر پوری طرح جلا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","یہ قربانیاں دیکھ کر رب خوش ہوا اور اپنے دل میں کہا، ”اب سے مَیں کبھی زمین پر انسان کی وجہ سے لعنت نہیں بھیجوں گا، کیونکہ اُس کا دل بچپن ہی سے بُرائی کی طرف مائل ہے۔ اب سے مَیں کبھی اِس طرح تمام جان رکھنے والی مخلوقات کو رُوئے زمین پر سے نہیں مٹاؤں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","دنیا کے مقررہ اوقات جاری رہیں گے۔ بیج بونے اور فصل کاٹنے کا وقت، ٹھنڈ اور تپش، گرمیوں اور سردیوں کا موسم، دن اور رات، یہ سب کچھ دنیا کے اخیر تک قائم رہے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","پھر اللہ نے نوح اور اُس کے بیٹوں کو برکت دے کر کہا، ”پھلو پھولو اور تعداد میں بڑھتے جاؤ۔ دنیا تم سے بھر جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","زمین پر پھرنے اور رینگنے والے جانور، پرندے اور مچھلیاں سب تم سے ڈریں گے۔ اُنہیں تمہارے اختیار میں کر دیا گیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","جس طرح مَیں نے تمہارے کھانے کے لئے پودوں کی پیداوار مقرر کی ہے اُسی طرح اب سے تمہیں ہر قسم کے جانور کھانے کی اجازت بھی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","لیکن خبردار! ایسا گوشت نہ کھاناجس میں خون ہے، کیونکہ خون میں اُس کی جان ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","کسی کی جان لینا منع ہے۔ جو ایسا کرے گا اُسے اپنی جان دینی پڑے گی، خواہ وہ انسان ہو یا حیوان۔ مَیں خود اِس کا مطالبہ کروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","جو بھی کسی کا خون بہائے اُس کا خون بھی بہایا جائے گا۔ کیونکہ اللہ نے انسان کو اپنی صورت پر بنایا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","اب پھلو پھولو اور تعداد میں بڑھتے جاؤ۔ دنیا میں پھیل جاؤ۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","تب اللہ نے نوح اور اُس کے بیٹوں سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","”اب مَیں تمہارے اور تمہاری اولاد کے ساتھ عہد قائم کرتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","یہ عہد اُن تمام جانوروں کے ساتھ بھی ہو گا جو کشتی میں سے نکلے ہیں یعنی پرندوں، مویشیوں اور زمین پر کے تمام جانوروں کے ساتھ۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","مَیں تمہارے ساتھ عہد باندھ کر وعدہ کرتا ہوں کہ اب سے ایسا کبھی نہیں ہو گا کہ زمین کی تمام زندگی سیلاب سے ختم کر دی جائے گی۔ اب سے ایسا سیلاب کبھی نہیں آئے گا جو پوری زمین کو تباہ کر دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","اِس ابدی عہد کا نشان جو مَیں تمہارے اور تمام جانداروں کے ساتھ قائم کر رہا ہوں یہ ہے کہ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","مَیں اپنی کمان بادلوں میں رکھتا ہوں۔ وہ میرے دنیا کے ساتھ عہد کا نشان ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","جب کبھی میرے کہنے پر آسمان پر بادل چھا جائیں گے اور قوسِ قزح اُن میں سے نظر آئے گی ");
INSERT INTO urdgvu_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","تو مَیں یہ عہد یاد کروں گا جو تمہارے اور تمام جانداروں کے ساتھ کیا گیا ہے۔ اب کبھی بھی ایسا سیلاب نہیں آئے گا جو تمام زندگی کو ہلاک کر دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","قوسِ قزح نظر آئے گی تو مَیں اُسے دیکھ کر اُس دائمی عہد کو یاد کروں گا جو میرے اور دنیا کی تمام جاندار مخلوقات کے درمیان ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","یہ اُس عہد کا نشان ہے جو مَیں نے دنیا کے تمام جانداروں کے ساتھ کیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","نوح کے جو بیٹے اُس کے ساتھ کشتی سے نکلے سِم، حام اور یافت تھے۔ حام کنعان کا باپ تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","دنیا بھر کے تمام لوگ اِن تینوں کی اولاد ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","نوح کسان تھا۔ شروع میں اُس نے انگور کا باغ لگایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","انگور سے مَے بنا کر اُس نے اِتنی پی لی کہ وہ نشے میں دُھت اپنے ڈیرے میں ننگا پڑا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","کنعان کے باپ حام نے اُسے یوں پڑا ہوا دیکھا تو باہر جا کر اپنے دونوں بھائیوں کو اُس کے بارے میں بتایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","یہ سن کر سِم اور یافت نے اپنے کندھوں پر کپڑا رکھا۔ پھر وہ اُلٹے چلتے ہوئے ڈیرے میں داخل ہوئے اور کپڑا اپنے باپ پر ڈال دیا۔ اُن کے منہ دوسری طرف مُڑے رہے تاکہ باپ کی برہنگی نظر نہ آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","جب نوح ہوش میں آیا تو اُس کو پتا چلا کہ سب سے چھوٹے بیٹے نے کیا کِیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","اُس نے کہا، ”کنعان پر لعنت! وہ اپنے بھائیوں کا ذلیل ترین غلام ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","مبارک ہو رب جو سِم کا خدا ہے۔ کنعان سِم کا غلام ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","اللہ کرے کہ یافت کی حدود بڑھ جائیں۔ یافت سِم کے ڈیروں میں رہے اور کنعان اُس کا غلام ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","سیلاب کے بعد نوح مزید 350 سال زندہ رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","وہ 950 سال کی عمر میں فوت ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","یہ نوح کے بیٹوں سِم، حام اور یافت کا نسب نامہ ہے۔ اُن کے بیٹے سیلاب کے بعد پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","یافت کے بیٹے جُمر، ماجوج، مادی، یاوان، تُوبل، مسک اور تیراس تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","جُمرکے بیٹے اشکناز، ریفت اور تُجرمہ تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","یاوان کے بیٹے اِلیسہ اور ترسیس تھے۔ کِتّی اور دودانی بھی اُس کی اولاد ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","وہ اُن قوموں کے آبا و اجداد ہیں جو ساحلی علاقوں اور جزیروں میں پھیل گئیں۔ یہ یافت کی اولاد ہیں جو اپنے اپنے قبیلے اور ملک میں رہتے ہوئے اپنی اپنی زبان بولتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","حام کے بیٹے کوش، مصر، فوط اور کنعان تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","کوش کے بیٹے سِبا، حویلہ، سبتہ، رعمہ اور سبتکہ تھے۔ رعمہ کے بیٹے سبا اور ددان تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","کوش کا ایک اَور بیٹا بنام نمرود تھا۔ وہ دنیا میں پہلا زبردست حاکم تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","رب کے نزدیک وہ زبردست شکاری تھا۔ اِس لئے آج بھی کسی اچھے شکاری کے بارے میں کہا جاتا ہے، ”وہ نمرود کی مانند ہے جو رب کے نزدیک زبردست شکاری تھا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","اُس کی سلطنت کے پہلے مرکز ملکِ سِنعار میں بابل، ارک، اکاد اور کلنہ کے شہر تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","اُس ملک سے نکل کر وہ اسور چلا گیا جہاں اُس نے نینوہ، رحوبوت عیر، کلح ");
INSERT INTO urdgvu_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","اور رسن کے شہر تعمیر کئے۔ بڑا شہر رسن نینوہ اور کلح کے درمیان واقع ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","مصر اِن قوموں کا باپ تھا: لودی، عنامی، لِہابی، نفتوحی، ");
INSERT INTO urdgvu_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","فتروسی، کسلوحی (جن سے فلستی نکلے) اور کفتوری۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","کنعان کا پہلوٹھا صیدا تھا۔ کنعان ذیل کی قوموں کا باپ بھی تھا: حِتّی ");
INSERT INTO urdgvu_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","یبوسی، اموری، جرجاسی، ");
INSERT INTO urdgvu_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","حِوّی، عرقی، سینی، ");
INSERT INTO urdgvu_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","اروادی، صماری اور حماتی۔ بعد میں کنعانی قبیلے اِتنے پھیل گئے ");
INSERT INTO urdgvu_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","کہ اُن کی حدود شمال میں صیدا سے جنوب کی طرف جرار سے ہو کر غزہ تک اور وہاں سے مشرق کی طرف سدوم، عمورہ، ادمہ اور ضبوئیم سے ہو کر لَسَع تک تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","یہ سب حام کی اولاد ہیں، جو اُن کے اپنے اپنے قبیلے، اپنی اپنی زبان، اپنے اپنے ملک اور اپنی اپنی قوم کے مطابق درج ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","سِم یافت کا بڑا بھائی تھا۔ اُس کے بھی بیٹے پیدا ہوئے۔ سِم تمام بنی عِبر کا باپ ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","سِم کے بیٹے عیلام، اسور، ارفکسد، لُود اور اَرام تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","اَرام کے بیٹے عُوض، حول، جتر اور مس تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","ارفکسد کا بیٹا سلح اور سلح کا بیٹا عِبر تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","عِبر کے ہاں دو بیٹے پیدا ہوئے۔ ایک کا نام فلج یعنی تقسیم تھا، کیونکہ اُن ایام میں دنیا تقسیم ہوئی۔ فلج کے بھائی کا نام یُقطان تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","یُقطان کے بیٹے الموداد، سلف، حصرماوت، اِراخ، ");
INSERT INTO urdgvu_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ہدورام، اُوزال، دِقلہ، ");
INSERT INTO urdgvu_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","عوبال، ابی مائیل، سبا، ");
INSERT INTO urdgvu_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","اوفیر، حویلہ اور یوباب تھے۔ یہ سب یُقطان کے بیٹے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","وہ میسا سے لے کر سفار اور مشرقی پہاڑی علاقے تک آباد تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","یہ سب سِم کی اولاد ہیں، جو اپنے اپنے قبیلے، اپنی اپنی زبان، اپنے اپنے ملک اور اپنی اپنی قوم کے مطابق درج ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","یہ سب نوح کے بیٹوں کے قبیلے ہیں، جو اپنی نسلوں اور قوموں کے مطابق درج کئے گئے ہیں۔ سیلاب کے بعد تمام قومیں اِن ہی سے نکل کر رُوئے زمین پر پھیل گئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","اُس وقت تک پوری دنیا کے لوگ ایک ہی زبان بولتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","مشرق کی طرف بڑھتے بڑھتے وہ سِنعار کے ایک میدان میں پہنچ کر وہاں آباد ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","تب وہ ایک دوسرے سے کہنے لگے، ”آؤ، ہم مٹی سے اینٹیں بنا کر اُنہیں آگ میں خوب پکائیں۔“ اُنہوں نے تعمیری کام کے لئے پتھر کی جگہ اینٹیں اور مسالے کی جگہ تارکول استعمال کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","پھر وہ کہنے لگے، ”آؤ، ہم اپنے لئے شہر بنا لیں جس میں ایسا بُرج ہو جو آسمان تک پہنچ جائے۔ پھر ہمارا نام قائم رہے گا اور ہم رُوئے زمین پر بکھر جانے سے بچ جائیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","لیکن رب اُس شہر اور بُرج کو دیکھنے کے لئے اُتر آیا جسے لوگ بنا رہے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","رب نے کہا، ”یہ لوگ ایک ہی قوم ہیں اور ایک ہی زبان بولتے ہیں۔ اور یہ صرف اُس کا آغاز ہے جو وہ کرنا چاہتے ہیں۔ اب سے جو بھی وہ مل کر کرنا چاہیں گے اُس سے اُنہیں روکا نہیں جا سکے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","اِس لئے آؤ، ہم دنیا میں اُتر کر اُن کی زبان کو درہم برہم کر دیں تاکہ وہ ایک دوسرے کی بات سمجھ نہ پائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","اِس طریقے سے رب نے اُنہیں تمام رُوئے زمین پر منتشر کر دیا، اور شہر کی تعمیر رُک گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","اِس لئے شہر کا نام بابل یعنی ابتری ٹھہرا، کیونکہ رب نے وہاں تمام لوگوں کی زبان کو درہم برہم کر کے اُنہیں تمام رُوئے زمین پر منتشر کردیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","یہ سِم کا نسب نامہ ہے: سِم 100 سال کا تھا جب اُس کا بیٹا ارفکسد پیدا ہوا۔ یہ سیلاب کے دو سال بعد ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","اِس کے بعد وہ مزید 500 سال زندہ رہا۔ اُس کے اَور بیٹے بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","ارفکسد 35 سال کا تھا جب سلح پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","اِس کے بعد وہ مزید 403 سال زندہ رہا۔ اُس کے اَور بیٹے بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","سلح 30 سال کا تھا جب عِبر پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","اِس کے بعد وہ مزید 403 سال زندہ رہا۔ اُس کے اَور بیٹے بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","عِبر 34 سال کا تھا جب فلج پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","اِس کے بعد وہ مزید 430 سال زندہ رہا۔ اُس کے اَور بیٹے بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","فلج 30 سال کا تھا جب رعو پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","اِس کے بعد وہ مزید 209 سال زندہ رہا۔ اُس کے اَور بیٹے بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","رعو 32 سال کا تھا جب سروج پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","اِس کے بعد وہ مزید 207 سال زندہ رہا۔ اُس کے اَور بیٹے بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","سروج 30 سال کا تھا جب نحور پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","اِس کے بعد وہ مزید 200 سال زندہ رہا۔ اُس کے اَور بیٹے بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","نحور 29 سال کا تھا جب تارح پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","اِس کے بعد وہ مزید 119 سال زندہ رہا۔ اُس کے اَور بیٹے بیٹیاں بھی پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","تارح 70 سال کا تھا جب اُس کے بیٹے ابرام، نحور اور حاران پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","یہ تارح کا نسب نامہ ہے: ابرام، نحور اور حاران تارح کے بیٹے تھے۔ لوط حاران کا بیٹا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","اپنے باپ تارح کی زندگی میں ہی حاران کسدیوں کے اُور میں انتقال کر گیا جہاں وہ پیدا بھی ہوا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","باقی دونوں بیٹوں کی شادی ہوئی۔ ابرام کی بیوی کا نام سارئی تھا اور نحور کی بیوی کا نام مِلکاہ۔ مِلکاہ حاران کی بیٹی تھی، اور اُس کی ایک بہن بنام اِسکہ تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","سارئی بانجھ تھی، اِس لئے اُس کے بچے نہیں تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","تارح کسدیوں کے اُور سے روانہ ہو کر ملکِ کنعان کی طرف سفر کرنے لگا۔ اُس کے ساتھ اُس کا بیٹا ابرام، اُس کا پوتا لوط یعنی حاران کا بیٹا اور اُس کی بہو سارئی تھے۔ جب وہ حاران پہنچے تو وہاں آباد ہو گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","تارح 205 سال کا تھا جب اُس نے حاران میں وفات پائی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","رب نے ابرام سے کہا، ”اپنے وطن، اپنے رشتے داروں اور اپنے باپ کے گھر کو چھوڑکر اُس ملک میں چلا جا جو مَیں تجھے دکھاؤں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","مَیں تجھ سے ایک بڑی قوم بناؤں گا، تجھے برکت دوں گا اور تیرے نام کو بہت بڑھاؤں گا۔ تُو دوسروں کے لئے برکت کا باعث ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","جو تجھے برکت دیں گے اُنہیں مَیں بھی برکت دوں گا۔ جو تجھ پر لعنت کرے گا اُس پر مَیں بھی لعنت کروں گا۔ دنیا کی تمام قومیں تجھ سے برکت پائیں گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ابرام نے رب کی سنی اور حاران سے روانہ ہوا۔ لوط اُس کے ساتھ تھا۔ اُس وقت ابرام 75 سال کا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","اُس کے ساتھ اُس کی بیوی سارئی اور اُس کا بھتیجا لوط تھے۔ وہ اپنے نوکر چاکروں سمیت اپنی پوری ملکیت بھی ساتھ لے گیا جو اُس نے حاران میں حاصل کی تھی۔ چلتے چلتے وہ کنعان پہنچے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ابرام اُس ملک میں سے گزر کر سِکم کے مقام پر ٹھہر گیا جہاں مورِہ کے بلوط کا درخت تھا۔ اُس زمانے میں ملک میں کنعانی قومیں آباد تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","وہاں رب ابرام پر ظاہر ہوا اور اُس سے کہا، ”مَیں تیری اولاد کو یہ ملک دوں گا۔“ اِس لئے اُس نے وہاں رب کی تعظیم میں قربان گاہ بنائی جہاں وہ اُس پر ظاہر ہوا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","وہاں سے وہ اُس پہاڑی علاقے کی طرف گیا جو بیت ایل کے مشرق میں ہے۔ وہاں اُس نے اپنا خیمہ لگایا۔ مغرب میں بیت ایل تھا اور مشرق میں عَی۔ اِس جگہ پر بھی اُس نے رب کی تعظیم میں قربان گاہ بنائی اور رب کا نام لے کر عبادت کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","پھر ابرام دوبارہ روانہ ہو کر جنوب کے دشتِ نجب کی طرف چل پڑا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","اُن دنوں میں ملکِ کنعان میں کال پڑا۔ کال اِتنا سخت تھا کہ ابرام اُس سے بچنے کی خاطر کچھ دیر کے لئے مصر میں جا بسا، لیکن پردیسی کی حیثیت سے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","جب وہ مصر کی سرحد کے قریب آئے تو اُس نے اپنی بیوی سارئی سے کہا، ”مَیں جانتا ہوں کہ تُو کتنی خوب صورت ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","مصری تجھے دیکھیں گے، پھر کہیں گے، ’یہ اِس کا شوہر ہے۔‘ نتیجے میں وہ مجھے مار ڈالیں گے اور تجھے زندہ چھوڑیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","اِس لئے لوگوں سے یہ کہتے رہنا کہ مَیں ابرام کی بہن ہوں۔ پھر میرے ساتھ اچھا سلوک کیا جائے گا اور میری جان تیرے سبب سے بچ جائے گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","جب ابرام مصر پہنچا تو واقعی مصریوں نے دیکھا کہ سارئی نہایت ہی خوب صورت ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","اور جب فرعون کے افسران نے اُسے دیکھا تو اُنہوں نے فرعون کے سامنے سارئی کی تعریف کی۔ آخرکار اُسے محل میں پہنچایا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","فرعون نے سارئی کی خاطر ابرام پر احسان کر کے اُسے بھیڑبکریاں، گائےبَیل، گدھے گدھیاں، نوکر چاکر اور اونٹ دیئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","لیکن رب نے سارئی کے سبب سے فرعون اور اُس کے گھرانے میں سخت قسم کے امراض پھیلائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","آخرکار فرعون نے ابرام کو بُلا کر کہا، ”تُو نے میرے ساتھ کیا کِیا؟ تُو نے مجھے کیوں نہیں بتایا کہ سارئی تیری بیوی ہے؟ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","تُو نے کیوں کہا کہ وہ میری بہن ہے؟ اِس دھوکے کی بنا پر مَیں نے اُسے گھر میں رکھ لیا تاکہ اُس سے شادی کروں۔ دیکھ، تیری بیوی حاضر ہے۔ اِسے لے کر یہاں سے نکل جا!“ ");
INSERT INTO urdgvu_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","پھر فرعون نے اپنے سپاہیوں کو حکم دیا، اور اُنہوں نے ابرام، اُس کی بیوی اور پوری ملکیت کو رُخصت کر کے ملک سے روانہ کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ابرام اپنی بیوی، لوط اور تمام جائیداد کو ساتھ لے کر مصر سے نکلا اور کنعان کے جنوبی علاقے دشتِ نجب میں واپس آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ابرام نہایت دولت مند ہو گیا تھا۔ اُس کے پاس بہت سے مویشی اور سونا چاندی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","وہاں سے جگہ بہ جگہ چلتے ہوئے وہ آخرکار بیت ایل سے ہو کر اُس مقام تک پہنچ گیا جہاں اُس نے شروع میں اپنا ڈیرا لگایا تھا اور جو بیت ایل اور عَی کے درمیان تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","وہاں جہاں اُس نے قربان گاہ بنائی تھی اُس نے رب کا نام لے کر اُس کی عبادت کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","لوط کے پاس بھی بہت سی بھیڑبکریاں، گائےبَیل اور خیمے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","نتیجہ یہ نکلا کہ آخرکار وہ مل کر نہ رہ سکے، کیونکہ اِتنی جگہ نہیں تھی کہ دونوں کے ریوڑ ایک ہی جگہ پر چر سکیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ابرام اور لوط کے چرواہے آپس میں جھگڑنے لگے۔ (اُس زمانے میں کنعانی اور فرِزّی بھی ملک میں آباد تھے۔) ");
INSERT INTO urdgvu_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","تب ابرام نے لوط سے بات کی، ”ایسا نہیں ہونا چاہئے کہ تیرے اور میرے درمیان جھگڑا ہو یا تیرے چرواہوں اور میرے چرواہوں کے درمیان۔ ہم تو بھائی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","کیا ضرورت ہے کہ ہم مل کر رہیں جبکہ تُو آسانی سے اِس ملک کی کسی اَور جگہ رہ سکتا ہے۔ بہتر ہے کہ تُو مجھ سے الگ ہو کر کہیں اَور رہے۔ اگر تُو بائیں ہاتھ جائے تو مَیں دائیں ہاتھ جاؤں گا، اور اگر تُو دائیں ہاتھ جائے تو مَیں بائیں ہاتھ جاؤں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","لوط نے اپنی نظر اُٹھا کر دیکھا کہ دریائے یردن کے پورے علاقے میں ضُغر تک پانی کی کثرت ہے۔ وہ رب کے باغ یا ملکِ مصر کی مانند تھا، کیونکہ اُس وقت رب نے سدوم اور عمورہ کو تباہ نہیں کیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","چنانچہ لوط نے دریائے یردن کے پورے علاقے کو چن لیا اور مشرق کی طرف جا بسا۔ یوں دونوں رشتے دار ایک دوسرے سے جدا ہو گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ابرام ملکِ کنعان میں رہا جبکہ لوط یردن کے علاقے کے شہروں کے درمیان آباد ہو گیا۔ وہاں اُس نے اپنے خیمے سدوم کے قریب لگا دیئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","لیکن سدوم کے باشندے نہایت شریر تھے، اور اُن کے رب کے خلاف گناہ نہایت مکروہ تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","لوط ابرام سے جدا ہوا تو رب نے ابرام سے کہا، ”اپنی نظر اُٹھا کر چاروں طرف یعنی شمال، جنوب، مشرق اور مغرب کی طرف دیکھ۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","جو بھی زمین تجھے نظر آئے اُسے مَیں تجھے اور تیری اولاد کو ہمیشہ کے لئے دیتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","مَیں تیری اولاد کو خاک کی طرح بےشمار ہونے دوں گا۔ جس طرح خاک کے ذرے گنے نہیں جا سکتے اُسی طرح تیری اولاد بھی گنی نہیں جا سکے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","چنانچہ اُٹھ کر اِس ملک کی ہر جگہ چل پھر، کیونکہ مَیں اِسے تجھے دیتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ابرام روانہ ہوا۔ چلتے چلتے اُس نے اپنے ڈیرے حبرون کے قریب ممرے کے درختوں کے پاس لگائے۔ وہاں اُس نے رب کی تعظیم میں قربان گاہ بنائی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","کنعان میں جنگ ہوئی۔ بیرونِ ملک کے چار بادشاہوں نے کنعان کے پانچ بادشاہوں سے جنگ کی۔ بیرونِ ملک کے بادشاہ یہ تھے: سِنعار سے امرا فِل، اِلاسر سے اریوک، عیلام سے کدرلاعُمر اور جوئیم سے تِدعال۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","کنعان کے بادشاہ یہ تھے: سدوم سے بِرَع، عمورہ سے بِرشَع، ادمہ سے سِنیاب، ضبوئیم سے شِمیبر اور بالع یعنی ضُغرکا بادشاہ۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","کنعان کے اِن پانچ بادشاہوں کا اتحاد ہوا تھا اور وہ وادئ سِدّ یم میں جمع ہوئے تھے۔ (اب سِدّ یم نہیں ہے، کیونکہ اُس کی جگہ بحیرۂ مُردار آ گیا ہے)۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","کدرلاعُمر نے بارہ سال تک اُن پر حکومت کی تھی، لیکن تیرھویں سال وہ باغی ہو گئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","اب ایک سال کے بعد کدرلاعُمر اور اُس کے اتحادی اپنی فوجوں کے ساتھ آئے۔ پہلے اُنہوں نے عستارات قرنَیم میں رفائیوں کو، ہام میں زُوزیوں کو، سَوی قِریَتائم میں ایمیوں کو ");
INSERT INTO urdgvu_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","اور حوریوں کو اُن کے پہاڑی علاقے سعیر میں شکست دی۔ یوں وہ ایل فاران تک پہنچ گئے جو ریگستان کے کنارے پر ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","پھر وہ واپس آئے اور عین مِصفات یعنی قادس پہنچے۔ اُنہوں نے عمالیقیوں کے پورے علاقے کو تباہ کر دیا اور حصصون تمر میں آباد اموریوں کو بھی شکست دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","اُس وقت سدوم، عمورہ، ادمہ، ضبوئیم اور بالع یعنی ضُغر کے بادشاہ اُن سے لڑنے کے لئے سِدّیم کی وادی میں جمع ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","اِن پانچ بادشاہوں نے عیلام کے بادشاہ کدرلاعُمر، جوئیم کے بادشاہ تِدعال، سِنعار کے بادشاہ امرافِل اور اِلاسر کے بادشاہ اریوک کا مقابلہ کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","اِس وادی میں تارکول کے متعدد گڑھے تھے۔ جب باغی بادشاہ شکست کھا کر بھاگنے لگے تو سدوم اور عمورہ کے بادشاہ اِن گڑھوں میں گر گئے جبکہ باقی تین بادشاہ بچ کر پہاڑی علاقے میں فرار ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","فتح مند بادشاہ سدوم اور عمورہ کا تمام مال تمام کھانے والی چیزوں سمیت لُوٹ کر واپس چل دیئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ابرام کا بھتیجا لوط سدوم میں رہتا تھا، اِس لئے وہ اُسے بھی اُس کی ملکیت سمیت چھین کر ساتھ لے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","لیکن ایک آدمی نے جو بچ نکلا تھا عبرانی مرد ابرام کے پاس آ کر اُسے سب کچھ بتا دیا۔ اُس وقت وہ ممرے کے درختوں کے پاس آباد تھا۔ ممرے اموری تھا۔ وہ اور اُس کے بھائی اِسکال اور عانیر ابرام کے اتحادی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","جب ابرام کو پتا چلا کہ بھتیجے کو گرفتار کر لیا گیا ہے تو اُس نے اپنے گھر میں پیدا ہوئے تمام جنگ آزمودہ غلاموں کو جمع کر کے دان تک دشمن کا تعاقب کیا۔ اُس کے ساتھ 318 افراد تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","وہاں اُس نے اپنے بندوں کو گروہوں میں تقسیم کر کے رات کے وقت دشمن پر حملہ کیا۔ دشمن شکست کھا کر بھاگ گیا اور ابرام نے دمشق کے شمال میں واقع خوبہ تک اُس کا تعاقب کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","وہ اُن سے لُوٹا ہوا تمام مال واپس لے آیا۔ لوط، اُس کی جائیداد، عورتیں اور باقی قیدی بھی دشمن کے قبضے سے بچ نکلے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","جب ابرام کدرلاعُمر اور اُس کے اتحادیوں پر فتح پانے کے بعد واپس پہنچا تو سدوم کا بادشاہ اُس سے ملنے کے لئے وادیٔ سَوی میں آیا۔ (اِسے آج کل بادشاہ کی وادی کہا جاتا ہے۔) ");
INSERT INTO urdgvu_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","سالم کا بادشاہ مَلِک صدق بھی وہاں پہنچا۔ وہ اپنے ساتھ روٹی اور مَے لے آیا۔ مَلِک صدق اللہ تعالیٰ کا امام تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","اُس نے ابرام کو برکت دے کر کہا، ”ابرام پر اللہ تعالیٰ کی برکت ہو، جو آسمان و زمین کا خالق ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","اللہ تعالیٰ مبارک ہو جس نے تیرے دشمنوں کو تیرے ہاتھ میں کر دیا ہے۔“ ابرام نے اُسے تمام مال کا دسواں حصہ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","سدوم کے بادشاہ نے ابرام سے کہا، ”مجھے میرے لوگ واپس کر دیں اور باقی چیزیں اپنے پاس رکھ لیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","لیکن ابرام نے اُس سے کہا، ”مَیں نے رب سے قَسم کھائی ہے، اللہ تعالیٰ سے جو آسمان و زمین کا خالق ہے ");
INSERT INTO urdgvu_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","کہ مَیں اُس میں سے کچھ نہیں لوں گا جو آپ کا ہے، چاہے وہ دھاگا یا جوتی کا تسمہ ہی کیوں نہ ہو۔ ایسا نہ ہو کہ آپ کہیں، ’مَیں نے ابرام کو دولت مند بنا دیا ہے۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","سوائے اُس کھانے کے جو میرے آدمیوں نے راستے میں کھایا ہے مَیں کچھ قبول نہیں کروں گا۔ لیکن میرے اتحادی عانیر، اِسکال اور ممرے ضرور اپنا اپنا حصہ لیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","اِس کے بعد رب رویا میں ابرام سے ہم کلام ہوا، ”ابرام، مت ڈر۔ مَیں ہی تیری سپر ہوں، مَیں ہی تیرا بہت بڑا اجر ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","لیکن ابرام نے اعتراض کیا، ”اے رب قادرِ مطلق، تُو مجھے کیا دے گا جبکہ ابھی تک میرے ہاں کوئی بچہ نہیں ہے اور اِلی عزر دمشقی میری میراث پائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","تُو نے مجھے اولاد نہیں بخشی، اِس لئے میرے گھرانے کا نوکر میرا وارث ہو گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","تب ابرام کو اللہ سے ایک اَور کلام ملا۔ ”یہ آدمی اِلی عزر تیرا وارث نہیں ہو گا بلکہ تیرا اپنا ہی بیٹا تیرا وارث ہو گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","رب نے اُسے باہر لے جا کر کہا، ”آسمان کی طرف دیکھ اور ستاروں کو گننے کی کوشش کر۔ تیری اولاد اِتنی ہی بےشمار ہو گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ابرام نے رب پر بھروسا رکھا۔ اِس بنا پر اللہ نے اُسے راست باز قرار دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","پھر رب نے اُس سے کہا، ”مَیں رب ہوں جو تجھے کسدیوں کے اُور سے یہاں لے آیا تاکہ تجھے یہ ملک میراث میں دے دوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ابرام نے پوچھا، ”اے رب قادرِ مطلق، مَیں کس طرح جانوں کہ اِس ملک پر قبضہ کروں گا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","جواب میں رب نے کہا، ”میرے حضور ایک تین سالہ گائے، ایک تین سالہ بکری اور ایک تین سالہ مینڈھا لے آ۔ ایک قمری اور ایک کبوتر کا بچہ بھی لے آنا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ابرام نے ایسا ہی کیا اور پھر ہر ایک جانور کو دو حصوں میں کاٹ کر اُن کو ایک دوسرے کے آمنے سامنے رکھ دیا۔ لیکن پرندوں کو اُس نے سالم رہنے دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","شکاری پرندے اُن پر اُترنے لگے، لیکن ابرام اُنہیں بھگاتا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","جب سورج ڈوبنے لگا تو ابرام پر گہری نیند طاری ہوئی۔ اُس پر دہشت اور اندھیرا ہی اندھیرا چھا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","پھر رب نے اُس سے کہا، ”جان لے کہ تیری اولاد ایسے ملک میں رہے گی جو اُس کا نہیں ہو گا۔ وہاں وہ اجنبی اور غلام ہو گی، اور اُس پر 400 سال تک بہت ظلم کیا جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","لیکن مَیں اُس قوم کی عدالت کروں گا جس نے اُسے غلام بنایا ہو گا۔ اِس کے بعد وہ بڑی دولت پا کر اُس ملک سے نکلیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","تُو خود عمر رسیدہ ہو کر سلامتی کے ساتھ انتقال کر کے اپنے باپ دادا سے جا ملے گا اور دفنایا جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","تیری اولاد کی چوتھی پشت غیروطن سے واپس آئے گی، کیونکہ اُس وقت تک مَیں اموریوں کو برداشت کروں گا۔ لیکن آخرکار اُن کے گناہ اِتنے سنگین ہو جائیں گے کہ مَیں اُنہیں ملکِ کنعان سے نکال دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","سورج غروب ہوا۔ اندھیرا چھا گیا۔ اچانک ایک دھواں دار تنور اور ایک بھڑکتی ہوئی مشعل نظر آئی اور جانوروں کے دو دو ٹکڑوں کے بیچ میں سے گزرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","اُس وقت رب نے ابرام کے ساتھ عہد کیا۔ اُس نے کہا، ”مَیں یہ ملک مصر کی سرحد سے فرات تک تیری اولاد کو دوں گا، ");
INSERT INTO urdgvu_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","اگرچہ ابھی تک اِس میں قینی، قنِزّی، قدمونی، ");
INSERT INTO urdgvu_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","حِتّی، فرِزّی، رفائی، ");
INSERT INTO urdgvu_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","اموری، کنعانی، جرجاسی اور یبوسی آباد ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","اب تک ابرام کی بیوی سارئی کے کوئی بچہ نہیں ہوا تھا۔ لیکن اُنہوں نے ایک مصری لونڈی رکھی تھی جس کا نام ہاجرہ تھا، ");
INSERT INTO urdgvu_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","اور ایک دن سارئی نے ابرام سے کہا، ”رب نے مجھے بچے پیدا کرنے سے محروم رکھا ہے، اِس لئے میری لونڈی کے ساتھ ہم بستر ہوں۔ شاید مجھے اُس کی معرفت بچہ مل جائے۔“ ابرام نے سارئی کی بات مان لی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","چنانچہ سارئی نے اپنی مصری لونڈی ہاجرہ کو اپنے شوہر ابرام کو دے دیا تاکہ وہ اُس کی بیوی بن جائے۔ اُس وقت ابرام کو کنعان میں بستے ہوئے دس سال ہو گئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ابرام ہاجرہ سے ہم بستر ہوا تو وہ اُمید سے ہو گئی۔ جب ہاجرہ کو یہ معلوم ہوا تو وہ اپنی مالکن کو حقیر جاننے لگی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","تب سارئی نے ابرام سے کہا، ”جو ظلم مجھ پر کیا جا رہا ہے وہ آپ ہی پر آئے۔ مَیں نے خود اِسے آپ کے بازوؤں میں دے دیا تھا۔ اب جب اِسے معلوم ہوا ہے کہ اُمید سے ہے تو مجھے حقیر جاننے لگی ہے۔ رب میرے اور آپ کے درمیان فیصلہ کرے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ابرام نے جواب دیا، ”دیکھو، یہ تمہاری لونڈی ہے اور تمہارے اختیار میں ہے۔ جو تمہارا جی چاہے اُس کے ساتھ کرو۔“ اِس پر سارئی اُس سے اِتنا بُرا سلوک کرنے لگی کہ ہاجرہ فرار ہو گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","رب کے فرشتے کو ہاجرہ ریگستان کے اُس چشمے کے قریب ملی جو شُور کے راستے پر ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","اُس نے کہا، ”سارئی کی لونڈی ہاجرہ، تُو کہاں سے آ رہی ہے اور کہاں جا رہی ہے؟“ ہاجرہ نے جواب دیا، ”مَیں اپنی مالکن سارئی سے فرار ہو رہی ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","رب کے فرشتے نے اُس سے کہا، ”اپنی مالکن کے پاس واپس چلی جا اور اُس کے تابع رہ۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","مَیں تیری اولاد اِتنی بڑھاؤں گا کہ اُسے گنا نہیں جا سکے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","رب کے فرشتے نے مزید کہا، ”تُو اُمید سے ہے۔ ایک بیٹا پیدا ہو گا۔ اُس کا نام اسمٰعیل یعنی ’اللہ سنتا ہے‘ رکھ، کیونکہ رب نے مصیبت میں تیری آواز سنی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","وہ جنگلی گدھے کی مانند ہو گا۔ اُس کا ہاتھ ہر ایک کے خلاف اور ہر ایک کا ہاتھ اُس کے خلاف ہو گا۔ توبھی وہ اپنے تمام بھائیوں کے سامنے آباد رہے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","رب کے اُس کے ساتھ بات کرنے کے بعد ہاجرہ نے اُس کا نام ’اتا ایل روئی‘ یعنی ’تُو ایک معبود ہے جو مجھے دیکھتا ہے‘ رکھا۔ اُس نے کہا، ”کیا مَیں نے واقعی اُس کے پیچھے دیکھا ہے جس نے مجھے دیکھا ہے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","اِس لئے اُس جگہ کے کنوئیں کا نام بیر لحی روئی یعنی ’اُس زندہ ہستی کا کنواں جو مجھے دیکھتا ہے‘ پڑ گیا۔ وہ قادس اور برد کے درمیان واقع ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ہاجرہ واپس گئی، اور اُس کے بیٹا پیدا ہوا۔ ابرام نے اُس کا نام اسمٰعیل رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","اُس وقت ابرام 86 سال کا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","جب ابرام 99 سال کا تھا تو رب اُس پر ظاہر ہوا۔ اُس نے کہا، ”مَیں اللہ قادرِ مطلق ہوں۔ میرے حضور چلتا رہ اور بےالزام ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","مَیں تیرے ساتھ اپنا عہد باندھوں گا اور تیری اولاد کو بہت ہی زیادہ بڑھا دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ابرام منہ کے بل گر گیا، اور اللہ نے اُس سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","”میرا تیرے ساتھ عہد ہے کہ تُو بہت قوموں کا باپ ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","اب سے تُو ابرام یعنی ’عظیم باپ‘ نہیں کہلائے گا بلکہ تیرا نام ابراہیم یعنی ’بہت قوموں کا باپ‘ ہو گا۔ کیونکہ مَیں نے تجھے بہت قوموں کا باپ بنا دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","مَیں تجھے بہت ہی زیادہ اولاد بخش دوں گا، اِتنی کہ قومیں بنیں گی۔ تجھ سے بادشاہ بھی نکلیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","مَیں اپنا عہد تیرے اور تیری اولاد کے ساتھ نسل در نسل قائم کروں گا، ایک ابدی عہد جس کے مطابق مَیں تیرا اور تیری اولاد کا خدا ہوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","تُو اِس وقت ملکِ کنعان میں پردیسی ہے، لیکن مَیں اِس پورے ملک کو تجھے اور تیری اولاد کو دیتا ہوں۔ یہ ہمیشہ تک اُن کا ہی رہے گا، اور مَیں اُن کا خدا ہوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","اللہ نے ابراہیم سے یہ بھی کہا، ”تجھے اور تیری اولاد کو نسل در نسل میرے عہد کی شرائط پوری کرنی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","اِس کی ایک شرط یہ ہے کہ ہر ایک مرد کا ختنہ کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","اپنا ختنہ کراؤ۔ یہ ہمارے آپس کے عہد کا ظاہری نشان ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","لازم ہے کہ تُو اور تیری اولاد نسل در نسل اپنے ہر ایک بیٹے کا آٹھویں دن ختنہ کروائیں۔ یہ اصول اُس پر بھی لاگو ہے جو تیرے گھر میں رہتا ہے لیکن تجھ سے رشتہ نہیں رکھتا، چاہے وہ گھر میں پیدا ہوا ہو یا کسی اجنبی سے خریدا گیا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","گھر کے ہر ایک مرد کا ختنہ کرنا لازم ہے، خواہ وہ گھر میں پیدا ہوا ہو یا کسی اجنبی سے خریدا گیا ہو۔ یہ اِس بات کا نشان ہو گا کہ میرا تیرے ساتھ عہد ہمیشہ تک قائم رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","جس مرد کا ختنہ نہ کیا گیا اُسے اُس کی قوم میں سے مٹایا جائے گا، کیونکہ اُس نے میرے عہد کی شرائط پوری نہ کیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","اللہ نے ابراہیم سے یہ بھی کہا، ”اپنی بیوی سارئی کا نام بھی بدل دینا۔ اب سے اُس کا نام سارئی نہیں بلکہ سارہ یعنی شہزادی ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","مَیں اُسے برکت بخشوں گا اور تجھے اُس کی معرفت بیٹا دوں گا۔ مَیں اُسے یہاں تک برکت دوں گا کہ اُس سے قومیں بلکہ قوموں کے بادشاہ نکلیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ابراہیم منہ کے بل گر گیا۔ لیکن دل ہی دل میں وہ ہنس پڑا اور سوچا، ”یہ کس طرح ہو سکتا ہے؟ مَیں تو 100 سال کا ہوں۔ ایسے آدمی کے ہاں بچہ کس طرح پیدا ہو سکتا ہے؟ اور سارہ جیسی عمر رسیدہ عورت کے بچہ کس طرح پیدا ہو سکتا ہے؟ اُس کی عمر تو 90 سال ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","اُس نے اللہ سے کہا، ”ہاں، اسمٰعیل ہی تیرے سامنے جیتا رہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","اللہ نے کہا، ”نہیں، تیری بیوی سارہ کے ہاں بیٹا پیدا ہو گا۔ تُو اُس کا نام اسحاق یعنی ’وہ ہنستا ہے‘ رکھنا۔ مَیں اُس کے اور اُس کی اولاد کے ساتھ ابدی عہد باندھوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","مَیں اسمٰعیل کے سلسلے میں بھی تیری درخواست پوری کروں گا۔ مَیں اُسے بھی برکت دے کر پھلنے پھولنے دوں گا اور اُس کی اولاد بہت ہی زیادہ بڑھا دوں گا۔ وہ بارہ رئیسوں کا باپ ہو گا، اور مَیں اُس کی معرفت ایک بڑی قوم بناؤں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","لیکن میرا عہد اسحاق کے ساتھ ہو گا، جو عین ایک سال کے بعد سارہ کے ہاں پیدا ہو گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","اللہ کی ابراہیم کے ساتھ بات ختم ہوئی، اور وہ اُس کے پاس سے آسمان پر چلا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","اُسی دن ابراہیم نے اللہ کا حکم پورا کیا۔ اُس نے گھر کے ہر ایک مرد کا ختنہ کروایا، اپنے بیٹے اسمٰعیل کا بھی اور اُن کا بھی جو اُس کے گھر میں رہتے لیکن اُس سے رشتہ نہیں رکھتے تھے، چاہے وہ اُس کے گھر میں پیدا ہوئے تھے یا خریدے گئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ابراہیم 99 سال کا تھا جب اُس کا ختنہ ہوا، ");
INSERT INTO urdgvu_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","جبکہ اُس کا بیٹا اسمٰعیل 13 سال کا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","دونوں کا ختنہ اُسی دن ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ساتھ ساتھ گھرانے کے تمام باقی مردوں کا ختنہ بھی ہوا، بشمول اُن کے جن کا ابراہیم کے ساتھ رشتہ نہیں تھا، چاہے وہ گھر میں پیدا ہوئے یا کسی اجنبی سے خریدے گئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ایک دن رب ممرے کے درختوں کے پاس ابراہیم پر ظاہر ہوا۔ ابراہیم اپنے خیمے کے دروازے پر بیٹھا تھا۔ دن کی گرمی عروج پر تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","اچانک اُس نے دیکھا کہ تین مرد میرے سامنے کھڑے ہیں۔ اُنہیں دیکھتے ہی وہ خیمے سے اُن سے ملنے کے لئے دوڑا اور منہ کے بل گر کر سجدہ کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","اُس نے کہا، ”میرے آقا، اگر مجھ پر آپ کے کرم کی نظر ہے تو آگے نہ بڑھیں بلکہ کچھ دیر اپنے بندے کے گھر ٹھہریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","اگر اجازت ہو تو مَیں کچھ پانی لے آؤں تاکہ آپ اپنے پاؤں دھو کر درخت کے سائے میں آرام کر سکیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ساتھ ساتھ مَیں آپ کے لئے تھوڑا بہت کھانا بھی لے آؤں تاکہ آپ تقویت پا کر آگے بڑھ سکیں۔ مجھے یہ کرنے دیں، کیونکہ آپ اپنے خادم کے گھر آ گئے ہیں۔“ اُنہوں نے کہا، ”ٹھیک ہے۔ جو کچھ تُو نے کہا ہے وہ کر۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ابراہیم خیمے کی طرف دوڑ کر سارہ کے پاس آیا اور کہا، ”جلدی کرو! 16 کلو گرام بہترین میدہ لے اور اُسے گوندھ کر روٹیاں بنا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","پھر وہ بھاگ کر بَیلوں کے پاس پہنچا۔ اُن میں سے اُس نے ایک موٹا تازہ بچھڑا چن لیا جس کا گوشت نرم تھا اور اُسے اپنے نوکر کو دیا جس نے جلدی سے اُسے تیار کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","جب کھانا تیار تھا تو ابراہیم نے اُسے لے کر لسی اور دودھ کے ساتھ اپنے مہمانوں کے آگے رکھ دیا۔ وہ کھانے لگے اور ابراہیم اُن کے سامنے درخت کے سائے میں کھڑا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","اُنہوں نے پوچھا، ”تیری بیوی سارہ کہاں ہے؟“ اُس نے جواب دیا، ”خیمے میں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","رب نے کہا، ”عین ایک سال کے بعد مَیں واپس آؤں گا تو تیری بیوی سارہ کے بیٹا ہو گا۔“ سارہ یہ باتیں سن رہی تھی، کیونکہ وہ اُس کے پیچھے خیمے کے دروازے کے پاس تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","دونوں میاں بیوی بوڑھے ہو چکے تھے اور سارہ اُس عمر سے گزر چکی تھی جس میں عورتوں کے بچے پیدا ہوتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","اِس لئے سارہ اندر ہی اندر ہنس پڑی اور سوچا، ”یہ کیسے ہو سکتا ہے؟ کیا جب مَیں بُڑھاپے کے باعث گھسے پھٹے لباس کی مانند ہوں تو جوانی کے جوبن کا لطف اُٹھاؤں؟ اور میرا شوہر بھی بوڑھا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","رب نے ابراہیم سے پوچھا، ”سارہ کیوں ہنس رہی ہے؟ وہ کیوں کہہ رہی ہے، ’کیا واقعی میرے ہاں بچہ پیدا ہو گا جبکہ مَیں اِتنی عمر رسیدہ ہوں؟‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","کیا رب کے لئے کوئی کام ناممکن ہے؟ ایک سال کے بعد مقررہ وقت پر مَیں واپس آؤں گا تو سارہ کے بیٹا ہو گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","سارہ ڈر گئی۔ اُس نے جھوٹ بول کر انکار کیا، ”مَیں نہیں ہنس رہی تھی۔“ رب نے کہا، ”نہیں، تُو ضرور ہنس رہی تھی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","پھر مہمان اُٹھ کر روانہ ہوئے اور نیچے وادی میں سدوم کی طرف دیکھنے لگے۔ ابراہیم اُنہیں رُخصت کرنے کے لئے ساتھ ساتھ چل رہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","رب نے دل میں کہا، ”مَیں ابراہیم سے وہ کام کیوں چھپائے رکھوں جو مَیں کرنے کے لئے جا رہا ہوں؟ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","اِسی سے تو ایک بڑی اور طاقت ور قوم نکلے گی اور اِسی سے مَیں دنیا کی تمام قوموں کو برکت دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","اُسی کو مَیں نے چن لیا ہے تاکہ وہ اپنی اولاد اور اپنے بعد کے گھرانے کو حکم دے کہ وہ رب کی راہ پر چل کر راست اور منصفانہ کام کریں۔ کیونکہ اگر وہ ایسا کریں تو رب ابراہیم کے ساتھ اپنا وعدہ پورا کرے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","پھر رب نے کہا، ”سدوم اور عمورہ کی بدی کے باعث لوگوں کی آہیں بلند ہو رہی ہیں، کیونکہ اُن سے بہت سنگین گناہ سرزد ہو رہے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","مَیں اُتر کر اُن کے پاس جا رہا ہوں تاکہ دیکھوں کہ یہ الزام واقعی سچ ہیں جو مجھ تک پہنچے ہیں۔ اگر ایسا نہیں ہے تو مَیں یہ جاننا چاہتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","دوسرے دو آدمی سدوم کی طرف آگے نکلے جبکہ رب کچھ دیر کے لئے وہاں ٹھہرا رہا اور ابراہیم اُس کے سامنے کھڑا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","پھر اُس نے قریب آ کر اُس سے بات کی، ”کیا تُو راست بازوں کو بھی شریروں کے ساتھ تباہ کر دے گا؟ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ہو سکتا ہے کہ شہر میں 50 راست باز ہوں۔ کیا تُو پھر بھی شہر کو برباد کر دے گا اور اُسے اُن 50 کے سبب سے معاف نہیں کرے گا؟ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","یہ کیسے ہو سکتا ہے کہ تُو بےقصوروں کو شریروں کے ساتھ ہلاک کر دے؟ یہ تو ناممکن ہے کہ تُو نیک اور شریر لوگوں سے ایک جیسا سلوک کرے۔ کیا لازم نہیں کہ پوری دنیا کا منصف انصاف کرے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","رب نے جواب دیا، ”اگر مجھے شہر میں 50 راست باز مل جائیں تو اُن کے سبب سے تمام کو معاف کر دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ابراہیم نے کہا، ”مَیں معافی چاہتا ہوں کہ مَیں نے رب سے بات کرنے کی جرأت کی ہے اگرچہ مَیں خاک اور راکھ ہی ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","لیکن ہو سکتا ہے کہ صرف 45 راست باز اُس میں ہوں۔ کیا تُو پھر بھی اُن پانچ لوگوں کی کمی کے سبب سے پورے شہر کو تباہ کرے گا؟“ اُس نے کہا، ”اگر مجھے 45 بھی مل جائیں تو اُسے برباد نہیں کروں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ابراہیم نے اپنی بات جاری رکھی، ”اور اگر صرف 40 نیک لوگ ہوں تو؟“ رب نے کہا، ”مَیں اُن 40 کے سبب سے اُنہیں چھوڑ دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ابراہیم نے کہا، ”رب غصہ نہ کرے کہ مَیں ایک دفعہ اَور بات کروں۔ شاید وہاں صرف 30 ہوں۔“ اُس نے جواب دیا، ”پھر بھی اُنہیں چھوڑ دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ابراہیم نے کہا، ”مَیں معافی چاہتا ہوں کہ مَیں نے رب سے بات کرنے کی جرأت کی ہے۔ اگر صرف 20 پائے جائیں؟“ رب نے کہا، ”مَیں 20 کے سبب سے شہر کو برباد کرنے سے باز رہوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ابراہیم نے ایک آخری دفعہ بات کی، ”رب غصہ نہ کرے اگر مَیں ایک اَور بار بات کروں۔ شاید اُس میں صرف 10 پائے جائیں۔“ رب نے کہا، ”مَیں اُسے اُن 10 لوگوں کے سبب سے بھی برباد نہیں کروں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","اِن باتوں کے بعد رب چلا گیا اور ابراہیم اپنے گھر کو لوٹ آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","شام کے وقت یہ دو فرشتے سدوم پہنچے۔ لوط شہر کے دروازے پر بیٹھا تھا۔ جب اُس نے اُنہیں دیکھا تو کھڑے ہو کر اُن سے ملنے گیا اور منہ کے بل گر کر سجدہ کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","اُس نے کہا، ”صاحبو، اپنے بندے کے گھر تشریف لائیں تاکہ اپنے پاؤں دھو کر رات کو ٹھہریں اور پھر کل صبح سویرے اُٹھ کر اپنا سفر جاری رکھیں۔“ اُنہوں نے کہا، ”کوئی بات نہیں، ہم چوک میں رات گزاریں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","لیکن لوط نے اُنہیں بہت مجبور کیا، اور آخرکار وہ اُس کے ساتھ اُس کے گھر آئے۔ اُس نے اُن کے لئے کھانا پکایا اور بےخمیری روٹی بنائی۔ پھر اُنہوں نے کھانا کھایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","وہ ابھی سونے کے لئے لیٹے نہیں تھے کہ شہر کے جوانوں سے لے کر بوڑھوں تک تمام مردوں نے لوط کے گھر کو گھیر لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","اُنہوں نے آواز دے کر لوط سے کہا، ”وہ آدمی کہاں ہیں جو رات کے وقت تیرے پاس آئے؟ اُن کو باہر لے آ تاکہ ہم اُن کے ساتھ حرام کاری کریں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","لوط اُن سے ملنے باہر گیا۔ اُس نے اپنے پیچھے دروازہ بند کر لیا ");
INSERT INTO urdgvu_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","اور کہا، ”میرے بھائیو، ایسا مت کرو، ایسی بدکاری نہ کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","دیکھو، میری دو کنواری بیٹیاں ہیں۔ اُنہیں مَیں تمہارے پاس باہر لے آتا ہوں۔ پھر جو جی چاہے اُن کے ساتھ کرو۔ لیکن اِن آدمیوں کو چھوڑ دو، کیونکہ وہ میرے مہمان ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","اُنہوں نے کہا، ”راستے سے ہٹ جا! دیکھو، یہ شخص جب ہمارے پاس آیا تھا تو اجنبی تھا، اور اب یہ ہم پر حاکم بننا چاہتا ہے۔ اب تیرے ساتھ اُن سے زیادہ بُرا سلوک کریں گے۔“ وہ اُسے مجبور کرتے کرتے دروازے کو توڑنے کے لئے آگے بڑھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","لیکن عین وقت پر اندر کے آدمی لوط کو پکڑ کر اندر لے آئے، پھر دروازہ دوبارہ بند کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","اُنہوں نے چھوٹوں سے لے کر بڑوں تک باہر کے تمام آدمیوں کو اندھا کر دیا، اور وہ دروازے کو ڈھونڈتے ڈھونڈتے تھک گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","دونوں آدمیوں نے لوط سے کہا، ”کیا تیرا کوئی اَور رشتے دار اِس شہر میں رہتا ہے، مثلاً کوئی داماد یا بیٹا بیٹی؟ سب کو ساتھ لے کر یہاں سے چلا جا، ");
INSERT INTO urdgvu_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","کیونکہ ہم یہ مقام تباہ کرنے کو ہیں۔ اِس کے باشندوں کی بدی کے باعث لوگوں کی آہیں بلند ہو کر رب کے حضور پہنچ گئی ہیں، اِس لئے اُس نے ہمیں اِس کو تباہ کرنے کے لئے بھیجا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","لوط گھر سے نکلا اور اپنے دامادوں سے بات کی جن کا اُس کی بیٹیوں کے ساتھ رشتہ ہو چکا تھا۔ اُس نے کہا، ”جلدی کرو، اِس جگہ سے نکلو، کیونکہ رب اِس شہر کو تباہ کرنے کو ہے۔“ لیکن اُس کے دامادوں نے اِسے مذاق ہی سمجھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","جب پَو پھٹنے لگی تو دونوں آدمیوں نے لوط کو بہت سمجھایا اور کہا، ”جلدی کر! اپنی بیوی اور دونوں بیٹیوں کو ساتھ لے کر چلا جا، ورنہ جب شہر کو سزا دی جائے گی تو تُو بھی ہلاک ہو جائے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","توبھی وہ جھجکتا رہا۔ آخرکار دونوں نے لوط، اُس کی بیوی اور بیٹیوں کے ہاتھ پکڑ کر اُنہیں شہر کے باہر تک پہنچا دیا، کیونکہ رب کو لوط پر ترس آتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","جوں ہی وہ اُنہیں باہر لے آئے اُن میں سے ایک نے کہا، ”اپنی جان بچا کر چلا جا۔ پیچھے مُڑ کر نہ دیکھنا۔ میدان میں کہیں نہ ٹھہرنا بلکہ پہاڑوں میں پناہ لینا، ورنہ تُو ہلاک ہو جائے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","لیکن لوط نے اُن سے کہا، ”نہیں میرے آقا، ایسا نہ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","تیرے بندے کو تیری نظرِ کرم حاصل ہوئی ہے اور تُو نے میری جان بچانے میں بہت مہربانی کر دکھائی ہے۔ لیکن مَیں پہاڑوں میں پناہ نہیں لے سکتا۔ وہاں پہنچنے سے پہلے یہ مصیبت مجھ پر آن پڑے گی اور مَیں ہلاک ہو جاؤں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","دیکھ، قریب ہی ایک چھوٹا قصبہ ہے۔ وہ اِتنا نزدیک ہے کہ مَیں اُس طرف ہجرت کر سکتا ہوں۔ مجھے وہاں پناہ لینے دے۔ وہ چھوٹا ہی ہے، نا؟ پھر میری جان بچے گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","اُس نے کہا، ”چلو، ٹھیک ہے۔ تیری یہ درخواست بھی منظور ہے۔ مَیں یہ قصبہ تباہ نہیں کروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","لیکن بھاگ کر وہاں پناہ لے، کیونکہ جب تک تُو وہاں پہنچ نہ جائے مَیں کچھ نہیں کر سکتا۔“ اِس لئے قصبے کا نام ضُغر یعنی چھوٹا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","جب لوط ضُغر پہنچا تو سورج نکلا ہوا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","تب رب نے آسمان سے سدوم اور عمورہ پر گندھک اور آگ برسائی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","یوں اُس نے اُس پورے میدان کو اُس کے شہروں، باشندوں اور تمام ہریالی سمیت تباہ کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","لیکن فرار ہوتے وقت لوط کی بیوی نے پیچھے مُڑ کر دیکھا تو وہ فوراً نمک کا ستون بن گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ابراہیم صبح سویرے اُٹھ کر اُس جگہ واپس آیا جہاں وہ کل رب کے سامنے کھڑا ہوا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","جب اُس نے نیچے سدوم، عمورہ اور پوری وادی کی طرف نظر کی تو وہاں سے بھٹے کا سا دھواں اُٹھ رہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","یوں اللہ نے ابراہیم کو یاد کیا جب اُس نے اُس میدان کے شہر تباہ کئے۔ کیونکہ وہ اُنہیں تباہ کرنے سے پہلے لوط کو جو اُن میں آباد تھا وہاں سے نکال لایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","لوط اور اُس کی بیٹیاں زیادہ دیر تک ضُغر میں نہ ٹھہرے۔ وہ روانہ ہو کر پہاڑوں میں آباد ہوئے، کیونکہ لوط ضُغر میں رہنے سے ڈرتا تھا۔ وہاں اُنہوں نے ایک غار کو اپنا گھر بنا لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ایک دن بڑی بیٹی نے چھوٹی سے کہا، ”ابو بوڑھا ہے اور یہاں کوئی مرد ہے نہیں جس کے ذریعے ہمارے بچے پیدا ہو سکیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","آؤ، ہم ابو کو مَے پلائیں۔ جب وہ نشے میں دُھت ہو تو ہم اُس کے ساتھ ہم بستر ہو کر اپنے لئے اولاد پیدا کریں تاکہ ہماری نسل قائم رہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","اُس رات اُنہوں نے اپنے باپ کو مَے پلائی۔ جب وہ نشے میں تھا تو بڑی بیٹی اندر جا کر اُس کے ساتھ ہم بستر ہوئی۔ چونکہ لوط ہوش میں نہیں تھا اِس لئے اُسے کچھ بھی معلوم نہ ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","اگلے دن بڑی بہن نے چھوٹی بہن سے کہا، ”پچھلی رات مَیں ابو سے ہم بستر ہوئی۔ آؤ، آج رات کو ہم اُسے دوبارہ مَے پلائیں۔ جب وہ نشے میں دُھت ہو تو تم اُس کے ساتھ ہم بستر ہو کر اپنے لئے اولاد پیدا کرنا تاکہ ہماری نسل قائم رہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","چنانچہ اُنہوں نے اُس رات بھی اپنے باپ کو مَے پلائی۔ جب وہ نشے میں تھا تو چھوٹی بیٹی اُٹھ کر اُس کے ساتھ ہم بستر ہوئی۔ اِس بار بھی وہ ہوش میں نہیں تھا، اِس لئے اُسے کچھ بھی معلوم نہ ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","یوں لوط کی بیٹیاں اپنے باپ سے اُمید سے ہوئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","بڑی بیٹی کے ہاں بیٹا پیدا ہوا۔ اُس نے اُس کا نام موآب رکھا۔ اُس سے موآبی نکلے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","چھوٹی بیٹی کے ہاں بھی بیٹا پیدا ہوا۔ اُس نے اُس کا نام بن عمی رکھا۔ اُس سے عمونی نکلے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ابراہیم وہاں سے جنوب کی طرف دشتِ نجب میں چلا گیا اور قادس اور شُور کے درمیان جا بسا۔ کچھ دیر کے لئے وہ جرار میں ٹھہرا، لیکن اجنبی کی حیثیت سے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","وہاں اُس نے لوگوں کو بتایا، ”سارہ میری بہن ہے۔“ اِس لئے جرار کے بادشاہ ابی مَلِک نے کسی کو بھجوا دیا کہ اُسے محل میں لے آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","لیکن رات کے وقت اللہ خواب میں ابی مَلِک پر ظاہر ہوا اور کہا، ”موت تیرے سر پر کھڑی ہے، کیونکہ جو عورت تُو اپنے گھر لے آیا ہے وہ شادی شدہ ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","اصل میں ابی مَلِک ابھی تک سارہ کے قریب نہیں گیا تھا۔ اُس نے کہا، ”میرے آقا، کیا تُو ایک بےقصور قوم کو بھی ہلاک کرے گا؟ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","کیا ابراہیم نے مجھ سے نہیں کہا تھا کہ سارہ میری بہن ہے؟ اور سارہ نے اُس کی ہاں میں ہاں ملائی۔ میری نیت اچھی تھی اور مَیں نے غلط کام نہیں کیا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","اللہ نے کہا، ”ہاں، مَیں جانتا ہوں کہ اِس میں تیری نیت اچھی تھی۔ اِس لئے مَیں نے تجھے میرا گناہ کرنے اور اُسے چھونے سے روک دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","اب اُس عورت کو اُس کے شوہر کو واپس کر دے، کیونکہ وہ نبی ہے اور تیرے لئے دعا کرے گا۔ پھر تُو نہیں مرے گا۔ لیکن اگر تُو اُسے واپس نہیں کرے گا تو جان لے کہ تیری اور تیرے لوگوں کی موت یقینی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","ابی مَلِک نے صبح سویرے اُٹھ کر اپنے تمام کارندوں کو یہ سب کچھ بتایا۔ یہ سن کر اُن پر دہشت چھا گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","پھر ابی مَلِک نے ابراہیم کو بُلا کر کہا، ”آپ نے ہمارے ساتھ کیا کِیا ہے؟ مَیں نے آپ کے ساتھ کیا غلط کام کیا کہ آپ نے مجھے اور میری سلطنت کو اِتنے سنگین جرم میں پھنسا دیا ہے؟ جو سلوک آپ نے ہمارے ساتھ کر دکھایا ہے وہ کسی بھی شخص کے ساتھ نہیں کرنا چاہئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","آپ نے یہ کیوں کیا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ابراہیم نے جواب دیا، ”مَیں نے اپنے دل میں کہا کہ یہاں کے لوگ اللہ کا خوف نہیں رکھتے ہوں گے، اِس لئے وہ میری بیوی کو حاصل کرنے کے لئے مجھے قتل کر دیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","حقیقت میں وہ میری بہن بھی ہے۔ وہ میرے باپ کی بیٹی ہے اگرچہ اُس کی اور میری ماں فرق ہیں۔ یوں مَیں اُس سے شادی کر سکا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","پھر جب اللہ نے ہونے دیا کہ مَیں اپنے باپ کے گھرانے سے نکل کر اِدھر اُدھر پھروں تو مَیں نے اپنی بیوی سے کہا، ’مجھ پر یہ مہربانی کر کہ جہاں بھی ہم جائیں میرے بارے میں کہہ دینا کہ وہ میرا بھائی ہے‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","پھر ابی مَلِک نے ابراہیم کو بھیڑبکریاں، گائےبَیل، غلام اور لونڈیاں دے کر اُس کی بیوی سارہ کو اُسے واپس کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","اُس نے کہا، ”میرا ملک آپ کے لئے کھلا ہے۔ جہاں جی چاہے اُس میں جا بسیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","سارہ سے اُس نے کہا، ”مَیں آپ کے بھائی کو چاندی کے ہزار سِکے دیتا ہوں۔ اِس سے آپ اور آپ کے لوگوں کے سامنے آپ کے ساتھ کئے گئے ناروا سلوک کا ازالہ ہو اور آپ کو بےقصور قرار دیا جائے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN20_17‏","002_20_17‏","GEN","20","17‏","18","تب ابراہیم نے اللہ سے دعا کی اور اللہ نے ابی مَلِک، اُس کی بیوی اور اُس کی لونڈیوں کو شفا دی، کیونکہ رب نے ابی مَلِک کے گھرانے کی تمام عورتوں کو سارہ کے سبب سے بانجھ بنا دیا تھا۔ لیکن اب اُن کے ہاں دوبارہ بچے پیدا ہونے لگے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","تب رب نے سارہ کے ساتھ ویسا ہی کیا جیسا اُس نے فرمایا تھا۔ جو وعدہ اُس نے سارہ کے بارے میں کیا تھا اُسے اُس نے پورا کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","وہ حاملہ ہوئی اور بیٹا پیدا ہوا۔ عین اُس وقت بوڑھے ابراہیم کے ہاں بیٹا پیدا ہوا جو اللہ نے مقرر کر کے اُسے بتایا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ابراہیم نے اپنے اِس بیٹے کا نام اسحاق یعنی ’وہ ہنستا ہے‘ رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","جب اسحاق آٹھ دن کا تھا تو ابراہیم نے اُس کا ختنہ کرایا، جس طرح اللہ نے اُسے حکم دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","جب اسحاق پیدا ہوا اُس وقت ابراہیم 100 سال کا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","سارہ نے کہا، ”اللہ نے مجھے ہنسایا، اور ہر کوئی جو میرے بارے میں یہ سنے گا ہنسے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","اِس سے پہلے کون ابراہیم سے یہ کہنے کی جرأت کر سکتا تھا کہ سارہ اپنے بچوں کو دودھ پلائے گی؟ اور اب میرے ہاں بیٹا پیدا ہوا ہے، اگرچہ ابراہیم بوڑھا ہو گیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","اسحاق بڑا ہوتا گیا۔ جب اُس کا دودھ چھڑایا گیا تو ابراہیم نے اُس کے لئے بڑی ضیافت کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ایک دن سارہ نے دیکھا کہ مصری لونڈی ہاجرہ کا بیٹا اسمٰعیل اسحاق کا مذاق اُڑا رہا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","اُس نے ابراہیم سے کہا، ”اِس لونڈی اور اُس کے بیٹے کو گھر سے نکال دیں، کیونکہ وہ میرے بیٹے اسحاق کے ساتھ میراث نہیں پائے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ابراہیم کو یہ بات بہت بُری لگی۔ آخر اسمٰعیل بھی اُس کا بیٹا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","لیکن اللہ نے اُس سے کہا، ”جو بات سارہ نے اپنی لونڈی اور اُس کے بیٹے کے بارے میں کہی ہے وہ تجھے بُری نہ لگے۔ سارہ کی بات مان لے، کیونکہ تیری نسل اسحاق ہی سے قائم رہے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","لیکن مَیں اسمٰعیل سے بھی ایک قوم بناؤں گا، کیونکہ وہ تیرا بیٹا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ابراہیم صبح سویرے اُٹھا۔ اُس نے روٹی اور پانی کی مشک ہاجرہ کے کندھوں پر رکھ کر اُسے لڑکے کے ساتھ گھر سے نکال دیا۔ ہاجرہ چلتے چلتے بیرسبع کے ریگستان میں اِدھر اُدھر پھرنے لگی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","پھر پانی ختم ہو گیا۔ ہاجرہ لڑکے کو کسی جھاڑی کے نیچے چھوڑ کر ");
INSERT INTO urdgvu_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","کوئی 300 فٹ دُور بیٹھ گئی۔ کیونکہ اُس نے دل میں کہا، ”مَیں اُسے مرتے نہیں دیکھ سکتی۔“ وہ وہاں بیٹھ کر رونے لگی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","لیکن اللہ نے بیٹے کی روتی ہوئی آواز سن لی۔ اللہ کے فرشتے نے آسمان پر سے پکار کر ہاجرہ سے بات کی، ”ہاجرہ، کیا بات ہے؟ مت ڈر، کیونکہ اللہ نے لڑکے کا جو وہاں پڑا ہے رونا سن لیاہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","اُٹھ، لڑکے کو اُٹھا کر اُس کا ہاتھ تھام لے، کیونکہ مَیں اُس سے ایک بڑی قوم بناؤں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","پھر اللہ نے ہاجرہ کی آنکھیں کھول دیں، اور اُس کی نظر ایک کنوئیں پر پڑی۔ وہ وہاں گئی اور مشک کو پانی سے بھر کر لڑکے کو پلایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","اللہ لڑکے کے ساتھ تھا۔ وہ جوان ہوا اور تیرانداز بن کر بیابان میں رہنے لگا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","جب وہ فاران کے ریگستان میں رہتا تھا تو اُس کی ماں نے اُسے ایک مصری عورت سے بیاہ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","اُن دنوں میں ابی مَلِک اور اُس کے سپاہ سالار فیکل نے ابراہیم سے کہا، ”جو کچھ بھی آپ کرتے ہیں اللہ آپ کے ساتھ ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","اب مجھ سے اللہ کی قَسم کھائیں کہ آپ مجھے اور میری آل اولاد کو دھوکا نہیں دیں گے۔ مجھ پر اور اِس ملک پر جس میں آپ پردیسی ہیں وہی مہربانی کریں جو مَیں نے آپ پر کی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ابراہیم نے جواب دیا، ”مَیں قَسم کھاتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","پھر اُس نے ابی مَلِک سے شکایت کرتے ہوئے کہا، ”آپ کے بندوں نے ہمارے ایک کنوئیں پر قبضہ کر لیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ابی مَلِک نے کہا، ”مجھے نہیں معلوم کہ کس نے ایسا کیا ہے۔ آپ نے بھی مجھے نہیں بتایا۔ آج مَیں پہلی دفعہ یہ بات سن رہا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","تب ابراہیم نے ابی مَلِک کو بھیڑبکریاں اور گائےبَیل دیئے، اور دونوں نے ایک دوسرے کے ساتھ عہد باندھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","پھر ابراہیم نے بھیڑ کے سات مادہ بچوں کو الگ کر لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ابی مَلِک نے پوچھا، ”آپ نے یہ کیوں کیا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ابراہیم نے جواب دیا، ”بھیڑ کے اِن سات بچوں کو مجھ سے لے لیں۔ یہ اِس کے گواہ ہوں کہ مَیں نے اِس کنوئیں کو کھودا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","اِس لئے اُس جگہ کا نام بیرسبع یعنی ’قَسم کا کنواں‘ رکھا گیا، کیونکہ وہاں اُن دونوں مردوں نے قَسم کھائی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","یوں اُنہوں نے بیرسبع میں ایک دوسرے سے عہد باندھا۔ پھر ابی مَلِک اور فیکل فلستیوں کے ملک واپس چلے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","اِس کے بعد ابراہیم نے بیرسبع میں جھاؤ کا درخت لگایا۔ وہاں اُس نے رب کا نام لے کر اُس کی عبادت کی جو ابدی خدا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ابراہیم بہت عرصے تک فلستیوں کے ملک میں آباد رہا، لیکن اجنبی کی حیثیت سے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","کچھ عرصے کے بعد اللہ نے ابراہیم کو آزمایا۔ اُس نے اُس سے کہا، ”ابراہیم!“ اُس نے جواب دیا، ”جی، مَیں حاضر ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","اللہ نے کہا، ”اپنے اکلوتے بیٹے اسحاق کو جسے تُو پیار کرتا ہے ساتھ لے کر موریاہ کے علاقے میں چلا جا۔ وہاں مَیں تجھے ایک پہاڑ دکھاؤں گا۔ اُس پر اپنے بیٹے کو قربان کر دے۔ اُسے ذبح کر کے قربان گاہ پر جلا دینا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","صبح سویرے ابراہیم اُٹھا اور اپنے گدھے پر زِین کسا۔ اُس نے اپنے ساتھ دو نوکروں اور اپنے بیٹے اسحاق کو لیا۔ پھر وہ قربانی کو جلانے کے لئے لکڑی کاٹ کر اُس جگہ کی طرف روانہ ہوا جو اللہ نے اُسے بتائی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","سفر کرتے کرتے تیسرے دن قربانی کی جگہ ابراہیم کو دُور سے نظر آئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","اُس نے نوکروں سے کہا، ”یہاں گدھے کے پاس ٹھہرو۔ مَیں لڑکے کے ساتھ وہاں جا کر پرستش کروں گا۔ پھر ہم تمہارے پاس واپس آ جائیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ابراہیم نے قربانی کو جلانے کے لئے لکڑیاں اسحاق کے کندھوں پر رکھ دیں اور خود چھری اور آگ جلانے کے لئے انگاروں کا برتن اُٹھایا۔ دونوں چل دیئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","اسحاق بولا، ”ابو!“ ابراہیم نے کہا، ”جی بیٹا۔“ ”ابو، آگ اور لکڑیاں تو ہمارے پاس ہیں، لیکن قربانی کے لئے بھیڑ یا بکری کہاں ہے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ابراہیم نے جواب دیا، ”اللہ خود قربانی کے لئے جانور مہیا کرے گا، بیٹا۔“ وہ آگے بڑھ گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","چلتے چلتے وہ اُس مقام پر پہنچے جو اللہ نے اُس پر ظاہر کیا تھا۔ ابراہیم نے وہاں قربان گاہ بنائی اور اُس پر لکڑیاں ترتیب سے رکھ دیں۔ پھر اُس نے اسحاق کو باندھ کر لکڑیوں پر رکھ دیا ");
INSERT INTO urdgvu_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","اور چھری پکڑ لی تاکہ اپنے بیٹے کو ذبح کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","عین اُسی وقت رب کے فرشتے نے آسمان پر سے اُسے آواز دی، ”ابراہیم، ابراہیم!“ ابراہیم نے کہا، ”جی، مَیں حاضر ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","فرشتے نے کہا، ”اپنے بیٹے پر ہاتھ نہ چلا، نہ اُس کے ساتھ کچھ کر۔ اب مَیں نے جان لیا ہے کہ تُو اللہ کا خوف رکھتا ہے، کیونکہ تُو اپنے اکلوتے بیٹے کو بھی مجھے دینے کے لئے تیار ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","اچانک ابراہیم کو ایک مینڈھا نظر آیا جس کے سینگ گنجان جھاڑیوں میں پھنسے ہوئے تھے۔ ابراہیم نے اُسے ذبح کر کے اپنے بیٹے کی جگہ قربانی کے طور پر جلا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","اُس نے اُس مقام کا نام ”رب مہیا کرتا ہے“ رکھا۔ اِس لئے آج تک کہا جاتا ہے، ”رب کے پہاڑ پر مہیا کیا جاتا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","رب کے فرشتے نے ایک بار پھر آسمان پر سے پکار کر اُس سے بات کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","”رب کا فرمان ہے، میری ذات کی قَسم، چونکہ تُو نے یہ کیا اور اپنے اکلوتے بیٹے کو مجھے پیش کرنے کے لئے تیار تھا ");
INSERT INTO urdgvu_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","اِس لئے مَیں تجھے برکت دوں گا اور تیری اولاد کو آسمان کے ستاروں اور ساحل کی ریت کی طرح بےشمار ہونے دوں گا۔ تیری اولاد اپنے دشمنوں کے شہروں کے دروازوں پر قبضہ کرے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","چونکہ تُو نے میری سنی اِس لئے تیری اولاد سے دنیا کی تمام قومیں برکت پائیں گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","اِس کے بعد ابراہیم اپنے نوکروں کے پاس واپس آیا، اور وہ مل کر بیرسبع لوٹے۔ وہاں ابراہیم آباد رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","اِن واقعات کے بعد ابراہیم کو اطلاع ملی، ”آپ کے بھائی نحور کی بیوی مِلکاہ کے ہاں بھی بیٹے پیدا ہوئے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","اُس کے پہلوٹھے عُوض کے بعد بوز، قموایل (اَرام کا باپ)، ");
INSERT INTO urdgvu_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","کسد، حزو، فِلداس، اِدلاف اور بتوایل پیدا ہوئے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","مِلکاہ اور نحور کے ہاں یہ آٹھ بیٹے پیدا ہوئے۔ (بتوایل رِبقہ کا باپ تھا)۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","نحور کی حرم کا نام رُومہ تھا۔ اُس کے ہاں بھی بیٹے پیدا ہوئے جن کے نام طِبخ، جاحم، تخص اور معکہ ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","سارہ 127 سال کی عمر میں حبرون میں انتقال کر گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","اُس زمانے میں حبرون کا نام قِریَت اربع تھا، اور وہ ملکِ کنعان میں تھا۔ ابراہیم نے اُس کے پاس آ کر ماتم کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","پھر وہ جنازے کے پاس سے اُٹھا اور حِتّیوں سے بات کی۔ اُس نے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","”مَیں آپ کے درمیان پردیسی اور غیرشہری کی حیثیت سے رہتا ہوں۔ مجھے قبر کے لئے زمین بیچیں تاکہ اپنی بیوی کو اپنے گھر سے لے جا کر دفن کر سکوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN23_5‏","002_23_5‏","GEN","23","5‏","6","حِتّیوں نے جواب دیا، ”ہمارے آقا، ہماری بات سنیں! آپ ہمارے درمیان اللہ کے رئیس ہیں۔ اپنی بیوی کو ہماری بہترین قبر میں دفن کریں۔ ہم میں سے کوئی نہیں جو آپ سے اپنی قبر کا انکار کرے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ابراہیم اُٹھا اور ملک کے باشندوں یعنی حِتّیوں کے سامنے تعظیماً جھک گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","اُس نے کہا، ”اگر آپ اِس کے لئے تیار ہیں کہ مَیں اپنی بیوی کو اپنے گھر سے لے جا کر دفن کروں تو صُحر کے بیٹے عِفرون سے میری سفارش کریں ");
INSERT INTO urdgvu_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","کہ وہ مجھے مکفیلہ کا غار بیچ دے۔ وہ اُس کا ہے اور اُس کے کھیت کے کنارے پر ہے۔ مَیں اُس کی پوری قیمت دینے کے لئے تیار ہوں تاکہ آپ کے درمیان رہتے ہوئے میرے پاس قبر بھی ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","عِفرون حِتّیوں کی جماعت میں موجود تھا۔ ابراہیم کی درخواست پر اُس نے اُن تمام حِتّیوں کے سامنے جو شہر کے دروازے پر جمع تھے جواب دیا، ");
INSERT INTO urdgvu_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","”نہیں، میرے آقا! میری بات سنیں۔ مَیں آپ کو یہ کھیت اور اُس میں موجود غار دے دیتا ہوں۔ سب جو حاضر ہیں میرے گواہ ہیں، مَیں یہ آپ کو دیتا ہوں۔ اپنی بیوی کو وہاں دفن کر دیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ابراہیم دوبارہ ملک کے باشندوں کے سامنے ادباً جھک گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","اُس نے سب کے سامنے عِفرون سے کہا، ”مہربانی کر کے میری بات پر غور کریں۔ مَیں کھیت کی پوری قیمت ادا کروں گا۔ اُسے قبول کریں تاکہ وہاں اپنی بیوی کو دفن کر سکوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN23_14‏","002_23_14‏","GEN","23","14‏","15","عِفرون نے جواب دیا، ”میرے آقا، سنیں۔ اِس زمین کی قیمت صرف 400 چاندی کے سِکے ہے۔ آپ کے اور میرے درمیان یہ کیا ہے؟ اپنی بیوی کو دفن کر دیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ابراہیم نے عِفرون کی مطلوبہ قیمت مان لی اور سب کے سامنے چاندی کے 400 سِکے تول کر عِفرون کو دے دیئے۔ اِس کے لئے اُس نے اُس وقت کے رائج باٹ استعمال کئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","چنانچہ مکفیلہ میں عِفرون کی زمین ابراہیم کی ملکیت ہو گئی۔ یہ زمین ممرے کے مشرق میں تھی۔ اُس میں کھیت، کھیت کا غار اور کھیت کی حدود میں موجود تمام درخت شامل تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","حِتّیوں کی پوری جماعت نے جو شہر کے دروازے پر جمع تھی زمین کے انتقال کی تصدیق کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","پھر ابراہیم نے اپنی بیوی سارہ کو ملکِ کنعان کے اُس غار میں دفن کیا جو ممرے یعنی حبرون کے مشرق میں واقع مکفیلہ کے کھیت میں تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","اِس طریقے سے یہ کھیت اور اُس کا غار حِتّیوں سے ابراہیم کے نام پر منتقل کر دیا گیا تاکہ اُس کے پاس قبر ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ابراہیم اب بہت بوڑھا ہو گیا تھا۔ رب نے اُسے ہر لحاظ سے برکت دی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ایک دن اُس نے اپنے گھر کے سب سے بزرگ نوکر سے جو اُس کی جائیداد کا پورا انتظام چلاتا تھا بات کی۔ ”قَسم کے لئے اپنا ہاتھ میری ران کے نیچے رکھو۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","رب کی قَسم کھاؤ جو آسمان و زمین کا خدا ہے کہ تم اِن کنعانیوں میں سے جن کے درمیان مَیں رہتا ہوں میرے بیٹے کے لئے بیوی نہیں لاؤ گے ");
INSERT INTO urdgvu_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","بلکہ میرے وطن میں میرے رشتے داروں کے پاس جاؤ گے اور اُن ہی میں سے میرے بیٹے کے لئے بیوی لاؤ گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","اُس کے نوکر نے کہا، ”شاید وہ عورت میرے ساتھ یہاں آنا نہ چاہے۔ کیا مَیں اِس صورت میں آپ کے بیٹے کو اُس وطن میں واپس لے جاؤں جس سے آپ نکلے ہیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ابراہیم نے کہا، ”خبردار! اُسے ہرگز واپس نہ لے جانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","رب جو آسمان کا خدا ہے اپنا فرشتہ تمہارے آگے بھیجے گا، اِس لئے تم وہاں میرے بیٹے کے لئے بیوی چننے میں ضرور کامیاب ہو گے۔ کیونکہ وہی مجھے میرے باپ کے گھر اور میرے وطن سے یہاں لے آیا ہے، اور اُسی نے قَسم کھا کر مجھ سے وعدہ کیا ہے کہ مَیں کنعان کا یہ ملک تیری اولاد کو دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","اگر وہاں کی عورت یہاں آنا نہ چاہے تو پھر تم اپنی قَسم سے آزاد ہو گے۔ لیکن کسی صورت میں بھی میرے بیٹے کو وہاں واپس نہ لے جانا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ابراہیم کے نوکر نے اپنا ہاتھ اُس کی ران کے نیچے رکھ کر قَسم کھائی کہ مَیں سب کچھ ایسا ہی کروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","پھر وہ اپنے آقا کے دس اونٹوں پر قیمتی تحفے لاد کر مسوپتامیہ کی طرف روانہ ہوا۔ چلتے چلتے وہ نحور کے شہر پہنچ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","اُس نے اونٹوں کو شہر کے باہر کنوئیں کے پاس بٹھایا۔ شام کا وقت تھا جب عورتیں کنوئیں کے پاس آ کر پانی بھرتی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","پھر اُس نے دعا کی، ”اے رب میرے آقا ابراہیم کے خدا، مجھے آج کامیابی بخش اور میرے آقا ابراہیم پر مہربانی کر۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","اب مَیں اِس چشمے پر کھڑا ہوں، اور شہر کی بیٹیاں پانی بھرنے کے لئے آ رہی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","مَیں اُن میں سے کسی سے کہوں گا، ’ذرا اپنا گھڑا نیچے کر کے مجھے پانی پلائیں۔‘ اگر وہ جواب دے، ’پی لیں، مَیں آپ کے اونٹوں کو بھی پانی پلا دیتی ہوں،‘ تو وہ وہی ہو گی جسے تُو نے اپنے خادم اسحاق کے لئے چن رکھا ہے۔ اگر ایسا ہوا تو مَیں جان لوں گا کہ تُو نے میرے آقا پر مہربانی کی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","وہ ابھی دعا کر ہی رہا تھا کہ رِبقہ شہر سے نکل آئی۔ اُس کے کندھے پر گھڑا تھا۔ وہ بتوایل کی بیٹی تھی (بتوایل ابراہیم کے بھائی نحور کی بیوی مِلکاہ کا بیٹا تھا)۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","رِبقہ نہایت خوب صورت جوان لڑکی تھی، اور وہ کنواری بھی تھی۔ وہ چشمے تک اُتری، اپنا گھڑا بھرا اور پھر واپس اوپر آئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ابراہیم کا نوکر دوڑ کر اُس سے ملا۔ اُس نے کہا، ”ذرا مجھے اپنے گھڑے سے تھوڑا سا پانی پلائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","رِبقہ نے کہا، ”جناب، پی لیں۔“ جلدی سے اُس نے اپنے گھڑے کو کندھے پر سے اُتار کر ہاتھ میں پکڑا تاکہ وہ پی سکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","جب وہ پینے سے فارغ ہوا تو رِبقہ نے کہا، ”مَیں آپ کے اونٹوں کے لئے بھی پانی لے آتی ہوں۔ وہ بھی پورے طور پر اپنی پیاس بجھائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","جلدی سے اُس نے اپنے گھڑے کا پانی حوض میں اُنڈیل دیا اور پھر بھاگ کر کنوئیں سے اِتنا پانی لاتی رہی کہ تمام اونٹوں کی پیاس بجھ گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","اِتنے میں ابراہیم کا آدمی خاموشی سے اُسے دیکھتا رہا، کیونکہ وہ جاننا چاہتا تھا کہ کیا رب مجھے سفر کی کامیابی بخشے گا یا نہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","اونٹ پانی پینے سے فارغ ہوئے تو اُس نے رِبقہ کو سونے کی ایک نتھ اور دو کنگن دیئے۔ نتھ کا وزن تقریباً 6 گرام تھا اور کنگنوں کا 120 گرام۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","اُس نے پوچھا، ”آپ کس کی بیٹی ہیں؟ کیا اُس کے ہاں اِتنی جگہ ہے کہ ہم وہاں رات گزار سکیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","رِبقہ نے جواب دیا، ”میرا باپ بتوایل ہے۔ وہ نحور اور مِلکاہ کا بیٹا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ہمارے پاس بھوسا اور چارا ہے۔ رات گزارنے کے لئے بھی کافی جگہ ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","یہ سن کر ابراہیم کے نوکر نے رب کو سجدہ کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","اُس نے کہا، ”میرے آقا ابراہیم کے خدا کی تمجید ہو جس کے کرم اور وفاداری نے میرے آقا کو نہیں چھوڑا۔ رب نے مجھے سیدھا میرے مالک کے رشتے داروں تک پہنچایا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","لڑکی بھاگ کر اپنی ماں کے گھر چلی گئی۔ وہاں اُس نے سب کچھ بتا دیا جو ہوا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_29‏","002_24_29‏","GEN","24","29‏","30","جب رِبقہ کے بھائی لابن نے نتھ اور بہن کی کلائیوں میں کنگنوں کو دیکھا اور وہ سب کچھ سنا جو ابراہیم کے نوکر نے رِبقہ کو بتایا تھا تو وہ فوراً کنوئیں کی طرف دوڑا۔ ابراہیم کا نوکر اب تک اونٹوں سمیت وہاں کھڑا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","لابن نے کہا، ”رب کے مبارک بندے، میرے ساتھ آئیں۔ آپ یہاں شہر کے باہر کیوں کھڑے ہیں؟ مَیں نے اپنے گھر میں آپ کے لئے سب کچھ تیار کیا ہے۔ آپ کے اونٹوں کے لئے بھی کافی جگہ ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","وہ نوکر کو لے کر گھر پہنچا۔ اونٹوں سے سامان اُتارا گیا، اور اُن کو بھوسا اور چارا دیا گیا۔ پانی بھی لایا گیا تاکہ ابراہیم کا نوکر اور اُس کے آدمی اپنے پاؤں دھوئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","لیکن جب کھانا آ گیا تو ابراہیم کے نوکر نے کہا، ”اِس سے پہلے کہ مَیں کھانا کھاؤں لازم ہے کہ اپنا معاملہ پیش کروں۔“ لابن نے کہا، ”بتائیں اپنی بات۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","اُس نے کہا، ”مَیں ابراہیم کا نوکر ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","رب نے میرے آقا کو بہت برکت دی ہے۔ وہ بہت امیر بن گیا ہے۔ رب نے اُسے کثرت سے بھیڑبکریاں، گائےبَیل، سونا چاندی، غلام اور لونڈیاں، اونٹ اور گدھے دیئے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","جب میرے مالک کی بیوی بوڑھی ہو گئی تھی تو اُس کے بیٹا پیدا ہوا تھا۔ ابراہیم نے اُسے اپنی پوری ملکیت دے دی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","لیکن میرے آقا نے مجھ سے کہا، ’قَسم کھاؤ کہ تم اِن کنعانیوں میں سے جن کے درمیان مَیں رہتا ہوں میرے بیٹے کے لئے بیوی نہیں لاؤ گے ");
INSERT INTO urdgvu_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","بلکہ میرے باپ کے گھرانے اور میرے رشتے داروں کے پاس جا کر اُس کے لئے بیوی لاؤ گے۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","مَیں نے اپنے مالک سے کہا، ’شاید وہ عورت میرے ساتھ آنا نہ چاہے۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","اُس نے کہا، ’رب جس کے سامنے مَیں چلتا رہا ہوں اپنے فرشتے کو تمہارے ساتھ بھیجے گا اور تمہیں کامیابی بخشے گا۔ تمہیں ضرور میرے رشتے داروں اور میرے باپ کے گھرانے سے میرے بیٹے کے لئے بیوی ملے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","لیکن اگر تم میرے رشتے داروں کے پاس جاؤ اور وہ انکار کریں تو پھر تم اپنی قَسم سے آزاد ہو گے۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","آج جب مَیں کنوئیں کے پاس آیا تو مَیں نے دعا کی، ’اے رب، میرے آقا کے خدا، اگر تیری مرضی ہو تو مجھے اِس مشن میں کامیابی بخش جس کے لئے مَیں یہاں آیا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","اب مَیں اِس کنوئیں کے پاس کھڑا ہوں۔ جب کوئی جوان عورت شہر سے نکل کر یہاں آئے تو مَیں اُس سے کہوں گا، ”ذرا مجھے اپنے گھڑے سے تھوڑا سا پانی پلائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","اگر وہ کہے، ”پی لیں، مَیں آپ کے اونٹوں کے لئے بھی پانی لے آؤں گی“ تو اِس کا مطلب یہ ہو کہ تُو نے اُسے میرے آقا کے بیٹے کے لئے چن لیا ہے کہ اُس کی بیوی بن جائے۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","مَیں ابھی دل میں یہ دعا کر رہا تھا کہ رِبقہ شہر سے نکل آئی۔ اُس کے کندھے پر گھڑا تھا۔ وہ چشمے تک اُتری اور اپنا گھڑا بھر لیا۔ مَیں نے اُس سے کہا، ’ذرا مجھے پانی پلائیں۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","جواب میں اُس نے جلدی سے اپنے گھڑے کو کندھے پر سے اُتار کر کہا، ’پی لیں، مَیں آپ کے اونٹوں کو بھی پانی پلاتی ہوں۔‘ مَیں نے پانی پیا، اور اُس نے اونٹوں کو بھی پانی پلایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","پھر مَیں نے اُس سے پوچھا، ’آپ کس کی بیٹی ہیں؟‘ اُس نے جواب دیا، ’میرا باپ بتوایل ہے۔ وہ نحور اور مِلکاہ کا بیٹا ہے۔‘ پھر مَیں نے اُس کی ناک میں نتھ اور اُس کی کلائیوں میں کنگن پہنا دیئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","تب مَیں نے رب کو سجدہ کر کے اپنے آقا ابراہیم کے خدا کی تمجید کی جس نے مجھے سیدھا میرے مالک کی بھتیجی تک پہنچایا تاکہ وہ اسحاق کی بیوی بن جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","اب مجھے بتائیں، کیا آپ میرے آقا پر اپنی مہربانی اور وفاداری کا اظہار کرنا چاہتے ہیں؟ اگر ایسا ہے تو رِبقہ کی اسحاق کے ساتھ شادی قبول کریں۔ اگر آپ متفق نہیں ہیں تو مجھے بتائیں تاکہ مَیں کوئی اَور قدم اُٹھا سکوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","لابن اور بتوایل نے جواب دیا، ”یہ بات رب کی طرف سے ہے، اِس لئے ہم کسی طرح بھی انکار نہیں کر سکتے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","رِبقہ آپ کے سامنے ہے۔ اُسے لے جائیں۔ وہ آپ کے مالک کے بیٹے کی بیوی بن جائے جس طرح رب نے فرمایا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","یہ سن کر ابراہیم کے نوکر نے رب کو سجدہ کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","پھر اُس نے سونے اور چاندی کے زیورات اور مہنگے ملبوسات اپنے سامان میں سے نکال کر رِبقہ کو دیئے۔ رِبقہ کے بھائی اور ماں کو بھی قیمتی تحفے ملے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","اِس کے بعد اُس نے اپنے ہم سفروں کے ساتھ شام کا کھانا کھایا۔ وہ رات کو وہیں ٹھہرے۔ اگلے دن جب اُٹھے تو نوکر نے کہا، ”اب ہمیں اجازت دیں تاکہ اپنے آقا کے پاس لوٹ جائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","رِبقہ کے بھائی اور ماں نے کہا، ”رِبقہ کچھ دن اَور ہمارے ہاں ٹھہرے۔ پھر آپ جائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","لیکن اُس نے اُن سے کہا، ”اب دیر نہ کریں، کیونکہ رب نے مجھے میرے مشن میں کامیابی بخشی ہے۔ مجھے اجازت دیں تاکہ اپنے مالک کے پاس واپس جاؤں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","اُنہوں نے کہا، ”چلیں، ہم لڑکی کو بُلا کر اُسی سے پوچھ لیتے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","اُنہوں نے رِبقہ کو بُلا کر اُس سے پوچھا، ”کیا تُو ابھی اِس آدمی کے ساتھ جانا چاہتی ہے؟“ اُس نے کہا، ”جی، مَیں جانا چاہتی ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","چنانچہ اُنہوں نے اپنی بہن رِبقہ، اُس کی دایہ، ابراہیم کے نوکر اور اُس کے ہم سفروں کو رُخصت کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","پہلے اُنہوں نے رِبقہ کو برکت دے کر کہا، ”ہماری بہن، اللہ کرے کہ تُو کروڑوں کی ماں بنے۔ تیری اولاد اپنے دشمنوں کے شہروں کے دروازوں پر قبضہ کرے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","پھر رِبقہ اور اُس کی نوکرانیاں اُٹھ کر اونٹوں پر سوار ہوئیں اور ابراہیم کے نوکر کے پیچھے ہو لیں۔ چنانچہ نوکر اُنہیں ساتھ لے کر روانہ ہو گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","اُس وقت اسحاق ملک کے جنوبی حصے، دشتِ نجب میں رہتا تھا۔ وہ بیر لحی روئی سے آیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ایک شام وہ نکل کر کھلے میدان میں اپنی سوچوں میں مگن ٹہل رہا تھا کہ اچانک اونٹ اُس کی طرف آتے ہوئے نظر آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","جب رِبقہ نے اپنی نظر اُٹھا کر اسحاق کو دیکھا تو اُس نے اونٹ سے اُتر کر ");
INSERT INTO urdgvu_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","نوکر سے پوچھا، ”وہ آدمی کون ہے جو میدان میں ہم سے ملنے آ رہا ہے؟“ نوکر نے کہا، ”میرا مالک ہے۔“ یہ سن کر رِبقہ نے چادر لے کر اپنے چہرے کو ڈھانپ لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","نوکر نے اسحاق کو سب کچھ بتا دیا جو اُس نے کیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","پھر اسحاق رِبقہ کو اپنی ماں سارہ کے ڈیرے میں لے گیا۔ اُس نے اُس سے شادی کی، اور وہ اُس کی بیوی بن گئی۔ اسحاق کے دل میں اُس کے لئے بہت محبت پیدا ہوئی۔ یوں اُسے اپنی ماں کی موت کے بعد سکون ملا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ابراہیم نے ایک اَور شادی کی۔ نئی بیوی کا نام قطورہ تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","قطورہ کے چھ بیٹے پیدا ہوئے، زِمران، یُقسان، مِدان، مِدیان، اِسباق اور سوخ۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","یُقسان کے دو بیٹے تھے، سبا اور ددان۔ اسوری، لطُوسی اور لومی ددان کی اولاد ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","مِدیان کے بیٹے عیفہ، عِفر، حنوک، ابیداع اور اِلدعا تھے۔ یہ سب قطورہ کی اولاد تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ابراہیم نے اپنی ساری ملکیت اسحاق کو دے دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","اپنی موت سے پہلے اُس نے اپنی دوسری بیویوں کے بیٹوں کو تحفے دے کر اپنے بیٹے سے دُور مشرق کی طرف بھیج دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_7‏","002_25_7‏","GEN","25","7‏","8","ابراہیم 175 سال کی عمر میں فوت ہوا۔ غرض وہ بہت عمر رسیدہ اور زندگی سے آسودہ ہو کر انتقال کر کے اپنے باپ دادا سے جا ملا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_9‏","002_25_9‏","GEN","25","9‏","10","اُس کے بیٹوں اسحاق اور اسمٰعیل نے اُسے مکفیلہ کے غار میں دفن کیا جو ممرے کے مشرق میں ہے۔ یہ وہی غار تھا جسے کھیت سمیت حِتّی آدمی عِفرون بن صُحر سے خریدا گیا تھا۔ ابراہیم اور اُس کی بیوی سارہ دونوں کو اُس میں دفن کیا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ابراہیم کی وفات کے بعد اللہ نے اسحاق کو برکت دی۔ اُس وقت اسحاق بیر لحی روئی کے قریب آباد تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ابراہیم کا بیٹا اسمٰعیل جو سارہ کی مصری لونڈی ہاجرہ کے ہاں پیدا ہوا اُس کا نسب نامہ یہ ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","اسمٰعیل کے بیٹے بڑے سے لے کر چھوٹے تک یہ ہیں: نبایوت، قیدار، ادبئیل، مِبسام، ");
INSERT INTO urdgvu_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","مِشماع، دُومہ، مسّا، ");
INSERT INTO urdgvu_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","حدد، تیما، یطور، نفیس اور قِدمہ۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","یہ بیٹے بارہ قبیلوں کے بانی بن گئے، اور جہاں جہاں وہ آباد ہوئے اُن جگہوں کا وہی نام پڑ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","اسمٰعیل 137 سال کا تھا جب وہ کوچ کر کے اپنے باپ دادا سے جا ملا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","اُس کی اولاد اُس علاقے میں آباد تھی جو حویلہ اور شُور کے درمیان ہے اور جو مصر کے مشرق میں اسور کی طرف ہے۔ یوں اسمٰعیل اپنے تمام بھائیوں کے سامنے ہی آباد ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","یہ ابراہیم کے بیٹے اسحاق کا بیان ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","اسحاق 40 سال کا تھا جب اُس کی رِبقہ سے شادی ہوئی۔ رِبقہ لابن کی بہن اور اَرامی مرد بتوایل کی بیٹی تھی (بتوایل مسوپتامیہ کا تھا)۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","رِبقہ کے بچے پیدا نہ ہوئے۔ لیکن اسحاق نے اپنی بیوی کے لئے دعا کی تو رب نے اُس کی سنی، اور رِبقہ اُمید سے ہوئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","اُس کے پیٹ میں بچے ایک دوسرے سے زورآزمائی کرنے لگے تو وہ رب سے پوچھنے گئی، ”اگر یہ میری حالت رہے گی تو پھر مَیں یہاں تک کیوں پہنچ گئی ہوں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","رب نے اُس سے کہا، ”تیرے اندر دو قومیں ہیں۔ وہ تجھ سے نکل کر ایک دوسری سے الگ الگ ہو جائیں گی۔ اُن میں سے ایک زیادہ طاقت ور ہو گی، اور بڑا چھوٹے کی خدمت کرے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","پیدائش کا وقت آ گیا تو جُڑواں بیٹے پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","پہلا بچہ نکلا تو سرخ سا تھا، اور ایسا لگ رہا تھا کہ وہ گھنے بالوں کا کوٹ ہی پہنے ہوئے ہے۔ اِس لئے اُس کا نام عیسَو یعنی ’بالوں والا‘ رکھا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","اِس کے بعد دوسرا بچہ پیدا ہوا۔ وہ عیسَو کی ایڑی پکڑے ہوئے نکلا، اِس لئے اُس کا نام یعقوب یعنی ’ایڑی پکڑنے والا‘ رکھا گیا۔ اُس وقت اسحاق 60 سال کا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","لڑکے جوان ہوئے۔ عیسَو ماہر شکاری بن گیا اور کھلے میدان میں خوش رہتا تھا۔ اُس کے مقابلے میں یعقوب شائستہ تھا اور ڈیرے میں رہنا پسند کرتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","اسحاق عیسَو کو پیار کرتا تھا، کیونکہ وہ شکار کا گوشت پسند کرتا تھا۔ لیکن رِبقہ یعقوب کو پیار کرتی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ایک دن یعقوب سالن پکا رہا تھا کہ عیسَو تھکا ہارا جنگل سے آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","اُس نے کہا، ”مجھے جلدی سے لال سالن، ہاں اِسی لال سالن سے کچھ کھانے کو دو۔ مَیں تو بےدم ہو رہا ہوں۔“ (اِسی لئے بعد میں اُس کا نام ادوم یعنی سرخ پڑ گیا۔) ");
INSERT INTO urdgvu_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","یعقوب نے کہا، ”پہلے مجھے پہلوٹھے کا حق بیچ دو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","عیسَو نے کہا، ”مَیں تو بھوک سے مر رہا ہوں، پہلوٹھے کا حق میرے کس کام کا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","یعقوب نے کہا، ”پہلے قَسم کھا کر مجھے یہ حق بیچ دو۔“ عیسَو نے قَسم کھا کر اُسے پہلوٹھے کا حق منتقل کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","تب یعقوب نے اُسے کچھ روٹی اور دال دے دی، اور عیسَو نے کھایا اور پیا۔ پھر وہ اُٹھ کر چلا گیا۔ یوں اُس نے پہلوٹھے کے حق کو حقیر جانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","اُس ملک میں دوبارہ کال پڑا، جس طرح ابراہیم کے دنوں میں بھی پڑ گیا تھا۔ اسحاق جرار شہر گیا جس پر فلستیوں کے بادشاہ ابی مَلِک کی حکومت تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","رب نے اسحاق پر ظاہر ہو کر کہا، ”مصر نہ جا بلکہ اُس ملک میں بس جو مَیں تجھے دکھاتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","اُس ملک میں اجنبی رہ تو مَیں تیرے ساتھ ہوں گا اور تجھے برکت دوں گا۔ کیونکہ مَیں تجھے اور تیری اولاد کو یہ تمام علاقہ دوں گا اور وہ وعدہ پورا کروں گا جو مَیں نے قَسم کھا کر تیرے باپ ابراہیم سے کیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","مَیں تجھے اِتنی اولاد دوں گا جتنے آسمان پر ستارے ہیں۔ اور مَیں یہ تمام ملک اُنہیں دے دوں گا۔ تیری اولاد سے دنیا کی تمام قومیں برکت پائیں گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","مَیں تجھے اِس لئے برکت دوں گا کہ ابراہیم میرے تابع رہا اور میری ہدایات اور احکام پر چلتا رہا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","چنانچہ اسحاق جرار میں آباد ہو گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","جب وہاں کے مردوں نے رِبقہ کے بارے میں پوچھا تو اسحاق نے کہا، ”یہ میری بہن ہے۔“ وہ اُنہیں یہ بتانے سے ڈرتا تھا کہ یہ میری بیوی ہے، کیونکہ اُس نے سوچا، ”رِبقہ نہایت خوب صورت ہے۔ اگر اُنہیں معلوم ہو جائے کہ رِبقہ میری بیوی ہے تو وہ اُسے حاصل کرنے کی خاطر مجھے قتل کر دیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","کافی وقت گزر گیا۔ ایک دن فلستیوں کے بادشاہ نے اپنی کھڑکی میں سے جھانک کر دیکھا کہ اسحاق اپنی بیوی کو پیار کر رہا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","اُس نے اسحاق کو بُلا کر کہا، ”وہ تو آپ کی بیوی ہے! آپ نے کیوں کہا کہ میری بہن ہے؟“ اسحاق نے جواب دیا، ”مَیں نے سوچا کہ اگر مَیں بتاؤں کہ یہ میری بیوی ہے تو لوگ مجھے قتل کر دیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","ابی مَلِک نے کہا، ”آپ نے ہمارے ساتھ کیسا سلوک کر دکھایا! کتنی آسانی سے میرے آدمیوں میں سے کوئی آپ کی بیوی سے ہم بستر ہو جاتا۔ اِس طرح ہم آپ کے سبب سے ایک بڑے جرم کے قصوروار ٹھہرتے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","پھر ابی مَلِک نے تمام لوگوں کو حکم دیا، ”جو بھی اِس مرد یا اُس کی بیوی کو چھیڑے اُسے سزائے موت دی جائے گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","اسحاق نے اُس علاقے میں کاشت کاری کی، اور اُسی سال اُسے سَو گُنا پھل ملا۔ یوں رب نے اُسے برکت دی، ");
INSERT INTO urdgvu_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","اور وہ امیر ہو گیا۔ اُس کی دولت بڑھتی گئی، اور وہ نہایت دولت مند ہو گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","اُس کے پاس اِتنی بھیڑبکریاں، گائےبَیل اور غلام تھے کہ فلستی اُس سے حسد کرنے لگے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","اب ایسا ہوا کہ اُنہوں نے اُن تمام کنوؤں کو مٹی سے بھر کر بند کر دیا جو اُس کے باپ کے نوکروں نے کھودے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","آخرکار ابی مَلِک نے اسحاق سے کہا، ”کہیں اَور جا کر رہیں، کیونکہ آپ ہم سے زیادہ زورآور ہو گئے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","چنانچہ اسحاق نے وہاں سے جا کر جرار کی وادی میں اپنے ڈیرے لگائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","وہاں فلستیوں نے ابراہیم کی موت کے بعد تمام کنوؤں کو مٹی سے بھر دیا تھا۔ اسحاق نے اُن کو دوبارہ کھدوایا۔ اُس نے اُن کے وہی نام رکھے جو اُس کے باپ نے رکھے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","اسحاق کے نوکروں کو وادی میں کھودتے کھودتے تازہ پانی مل گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","لیکن جرار کے چرواہے آ کر اسحاق کے چرواہوں سے جھگڑنے لگے۔ اُنہوں نے کہا، ”یہ ہمارا کنواں ہے!“ اِس لئے اُس نے اُس کنوئیں کا نام عِسق یعنی جھگڑا رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","اسحاق کے نوکروں نے ایک اَور کنواں کھود لیا۔ لیکن اُس پر بھی جھگڑا ہوا، اِس لئے اُس نے اُس کا نام ستنہ یعنی مخالفت رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","وہاں سے جا کر اُس نے ایک تیسرا کنواں کھدوایا۔ اِس دفعہ کوئی جھگڑا نہ ہوا، اِس لئے اُس نے اُس کا نام رحوبوت یعنی ’کھلی جگہ‘ رکھا۔ کیونکہ اُس نے کہا، ”رب نے ہمیں کھلی جگہ دی ہے، اور اب ہم ملک میں پھلیں پھولیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","وہاں سے وہ بیرسبع چلا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","اُسی رات رب اُس پر ظاہر ہوا اور کہا، ”مَیں تیرے باپ ابراہیم کا خدا ہوں۔ مت ڈر، کیونکہ مَیں تیرے ساتھ ہوں۔ مَیں تجھے برکت دوں گا اور تجھے اپنے خادم ابراہیم کی خاطر بہت اولاد دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","وہاں اسحاق نے قربان گاہ بنائی اور رب کا نام لے کر عبادت کی۔ وہاں اُس نے اپنے خیمے لگائے اور اُس کے نوکروں نے کنواں کھود لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ایک دن ابی مَلِک، اُس کا ساتھی اخوزت اور اُس کا سپہ سالار فیکل جرار سے اُس کے پاس آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","اسحاق نے پوچھا، ”آپ کیوں میرے پاس آئے ہیں؟ آپ تو مجھ سے نفرت رکھتے ہیں۔ کیا آپ نے مجھے اپنے درمیان سے خارج نہیں کیا تھا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","اُنہوں نے جواب دیا، ”ہم نے جان لیا ہے کہ رب آپ کے ساتھ ہے۔ اِس لئے ہم نے کہا کہ ہمارا آپ کے ساتھ عہد ہونا چاہئے۔ آئیے ہم قَسم کھا کر ایک دوسرے سے عہد باندھیں ");
INSERT INTO urdgvu_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","کہ آپ ہمیں نقصان نہیں پہنچائیں گے، کیونکہ ہم نے بھی آپ کو نہیں چھیڑا بلکہ آپ سے صرف اچھا سلوک کیا اور آپ کو سلامتی کے ساتھ رُخصت کیا ہے۔ اور اب ظاہر ہے کہ رب نے آپ کو برکت دی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","اسحاق نے اُن کی ضیافت کی، اور اُنہوں نے کھایا اور پیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","پھر صبح سویرے اُٹھ کر اُنہوں نے ایک دوسرے کے سامنے قَسم کھائی۔ اِس کے بعد اسحاق نے اُنہیں رُخصت کیا اور وہ سلامتی سے روانہ ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","اُسی دن اسحاق کے نوکر آئے اور اُسے اُس کنوئیں کے بارے میں اطلاع دی جو اُنہوں نے کھودا تھا۔ اُنہوں نے کہا، ”ہمیں پانی مل گیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","اُس نے کنوئیں کا نام سبع یعنی ’قَسم‘ رکھا۔ آج تک ساتھ والے شہر کا نام بیرسبع ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","جب عیسَو 40 سال کا تھا تو اُس نے دو حِتّی عورتوں سے شادی کی، بیری کی بیٹی یہودِت سے اور ایلون کی بیٹی باسمت سے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","یہ عورتیں اسحاق اور رِبقہ کے لئے بڑے دُکھ کا باعث بنیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","اسحاق بوڑھا ہو گیا تو اُس کی نظر دُھندلا گئی۔ اُس نے اپنے بڑے بیٹے کو بُلا کر کہا، ”بیٹا۔“ عیسَو نے جواب دیا، ”جی، مَیں حاضر ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","اسحاق نے کہا، ”مَیں بوڑھا ہو گیا ہوں اور خدا جانے کب مر جاؤں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","اِس لئے اپنا تیر کمان لے کر جنگل میں نکل جا اور میرے لئے کسی جانور کا شکار کر۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","اُسے تیار کر کے ایسا لذیذ کھانا پکا جو مجھے پسند ہے۔ پھر اُسے میرے پاس لے آ۔ مرنے سے پہلے مَیں وہ کھانا کھا کر تجھے برکت دینا چاہتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","رِبقہ نے اسحاق کی عیسَو کے ساتھ بات چیت سن لی تھی۔ جب عیسَو شکار کرنے کے لئے چلا گیا تو اُس نے یعقوب سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","”ابھی ابھی مَیں نے تمہارے ابو کو عیسَو سے یہ بات کرتے ہوئے سنا کہ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","’میرے لئے کسی جانور کا شکار کر کے لے آ۔ اُسے تیار کر کے میرے لئے لذیذ کھانا پکا۔ مرنے سے پہلے مَیں یہ کھانا کھا کر تجھے رب کے سامنے برکت دینا چاہتا ہوں۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","اب سنو، میرے بیٹے! جو کچھ مَیں بتاتی ہوں وہ کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","جا کر ریوڑ میں سے بکریوں کے دو اچھے اچھے بچے چن لو۔ پھر مَیں وہی لذیذ کھانا پکاؤں گی جو تمہارے ابو کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","تم یہ کھانا اُس کے پاس لے جاؤ گے تو وہ اُسے کھا کر مرنے سے پہلے تمہیں برکت دے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","لیکن یعقوب نے اعتراض کیا، ”آپ جانتی ہیں کہ عیسَو کے جسم پر گھنے بال ہیں جبکہ میرے بال کم ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","کہیں مجھے چھونے سے میرے باپ کو پتا نہ چل جائے کہ مَیں اُسے فریب دے رہا ہوں۔ پھر مجھ پر برکت نہیں بلکہ لعنت آئے گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","اُس کی ماں نے کہا، ”تم پر آنے والی لعنت مجھ پر آئے، بیٹا۔ بس میری بات مان لو۔ جاؤ اور بکریوں کے وہ بچے لے آؤ۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","چنانچہ وہ گیا اور اُنہیں اپنی ماں کے پاس لے آیا۔ رِبقہ نے ایسا لذیذ کھانا پکایا جو یعقوب کے باپ کو پسند تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","عیسَو کے خاص موقعوں کے لئے اچھے لباس رِبقہ کے پاس گھر میں تھے۔ اُس نے اُن میں سے بہترین لباس چن کر اپنے چھوٹے بیٹے کو پہنا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ساتھ ساتھ اُس نے بکریوں کی کھالیں اُس کے ہاتھوں اور گردن پر جہاں بال نہ تھے لپیٹ دیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","پھر اُس نے اپنے بیٹے یعقوب کو روٹی اور وہ لذیذ کھانا دیا جو اُس نے پکایا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","یعقوب نے اپنے باپ کے پاس جا کر کہا، ”ابو جی۔“ اسحاق نے کہا، ”جی، بیٹا۔ تُو کون ہے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","اُس نے کہا، ”مَیں آپ کا پہلوٹھا عیسَو ہوں۔ مَیں نے وہ کیا ہے جو آپ نے مجھے کہا تھا۔ اب ذرا اُٹھیں اور بیٹھ کر میرے شکار کا کھانا کھائیں تاکہ آپ بعد میں مجھے برکت دیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","اسحاق نے پوچھا، ”بیٹا، تجھے یہ شکار اِتنی جلدی کس طرح مل گیا؟“ اُس نے جواب دیا، ”رب آپ کے خدا نے اُسے میرے سامنے سے گزرنے دیا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","اسحاق نے کہا، ”بیٹا، میرے قریب آ تاکہ مَیں تجھے چھو لوں کہ تُو واقعی میرا بیٹا عیسَو ہے کہ نہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","یعقوب اپنے باپ کے نزدیک آیا۔ اسحاق نے اُسے چھو کر کہا، ”تیری آواز تو یعقوب کی ہے لیکن تیرے ہاتھ عیسَو کے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","یوں اُس نے فریب کھایا۔ چونکہ یعقوب کے ہاتھ عیسَو کے ہاتھ کی مانند تھے اِس لئے اُس نے اُسے برکت دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","توبھی اُس نے دوبارہ پوچھا، ”کیا تُو واقعی میرا بیٹا عیسَو ہے؟“ یعقوب نے جواب دیا، ”جی، مَیں وہی ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","آخرکار اسحاق نے کہا، ”شکار کا کھانا میرے پاس لے آ، بیٹا۔ اُسے کھانے کے بعد مَیں تجھے برکت دوں گا۔“ یعقوب کھانا اور مَے لے آیا۔ اسحاق نے کھایا اور پیا، ");
INSERT INTO urdgvu_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","پھر کہا، ”بیٹا، میرے پاس آ اور مجھے بوسہ دے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","یعقوب نے پاس آ کر اُسے بوسہ دیا۔ اسحاق نے اُس کے لباس کو سونگھ کر اُسے برکت دی۔ اُس نے کہا، ”میرے بیٹے کی خوشبو اُس کھلے میدان کی خوشبو کی مانند ہے جسے رب نے برکت دی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","اللہ تجھے آسمان کی اوس اور زمین کی زرخیزی دے۔ وہ تجھے کثرت کا اناج اور انگور کا رس دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","قومیں تیری خدمت کریں، اور اُمّتیں تیرے سامنے جھک جائیں۔ اپنے بھائیوں کا حکمران بن، اور تیری ماں کی اولاد تیرے سامنے گھٹنے ٹیکے۔ جو تجھ پر لعنت کرے وہ خود لعنتی ہو اور جو تجھے برکت دے وہ خود برکت پائے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","اسحاق کی برکت کے بعد یعقوب ابھی رُخصت ہی ہوا تھا کہ اُس کا بھائی عیسَو شکار کر کے واپس آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","وہ بھی لذیذ کھانا پکا کر اُسے اپنے باپ کے پاس لے آیا۔ اُس نے کہا، ”ابو جی، اُٹھیں اور میرے شکار کا کھانا کھائیں تاکہ آپ مجھے برکت دیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","اسحاق نے پوچھا، ”تُو کون ہے؟“ اُس نے جواب دیا، ”مَیں آپ کا بڑا بیٹا عیسَو ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","اسحاق گھبرا کر شدت سے کانپنے لگا۔ اُس نے پوچھا، ”پھر وہ کون تھا جو کسی جانور کا شکار کر کے میرے پاس لے آیا؟ تیرے آنے سے ذرا پہلے مَیں نے اُس شکار کا کھانا کھا کر اُس شخص کو برکت دی۔ اب وہ برکت اُسی پر رہے گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","یہ سن کر عیسَو زوردار اور تلخ چیخیں مارنے لگا۔ ”ابو، مجھے بھی برکت دیں،“ اُس نے کہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","لیکن اسحاق نے جواب دیا، ”تیرے بھائی نے آ کر مجھے فریب دیا۔ اُس نے تیری برکت تجھ سے چھین لی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","عیسَو نے کہا، ”اُس کا نام یعقوب ٹھیک ہی رکھا گیا ہے، کیونکہ اب اُس نے مجھے دوسری بار دھوکا دیا ہے۔ پہلے اُس نے پہلوٹھے کا حق مجھ سے چھین لیا اور اب میری برکت بھی زبردستی لے لی۔ کیا آپ نے میرے لئے کوئی برکت محفوظ نہیں رکھی؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","لیکن اسحاق نے کہا، ”مَیں نے اُسے تیرا حکمران اور اُس کے تمام بھائیوں کو اُس کے خادم بنا دیا ہے۔ مَیں نے اُسے اناج اور انگور کا رس مہیا کیا ہے۔ اب مجھے بتا بیٹا، کیا کچھ رہ گیا ہے جو مَیں تجھے دوں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","لیکن عیسَو خاموش نہ ہوا بلکہ کہا، ”ابو، کیا آپ کے پاس واقعی صرف یہی برکت تھی؟ ابو، مجھے بھی برکت دیں۔“ وہ زار و قطار رونے لگا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","پھر اسحاق نے کہا، ”تُو زمین کی زرخیزی اور آسمان کی اوس سے محروم رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","تُو صرف اپنی تلوار کے سہارے زندہ رہے گا اور اپنے بھائی کی خدمت کرے گا۔ لیکن ایک دن تُو بےچین ہو کر اُس کا جوا اپنی گردن پر سے اُتار پھینکے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","باپ کی برکت کے سبب سے عیسَو یعقوب کا دشمن بن گیا۔ اُس نے دل میں کہا، ”وہ دن قریب آ گئے ہیں کہ ابو انتقال کر جائیں گے اور ہم اُن کا ماتم کریں گے۔ پھر مَیں اپنے بھائی کو مار ڈالوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","رِبقہ کو اپنے بڑے بیٹے عیسَو کا یہ ارادہ معلوم ہوا۔ اُس نے یعقوب کو بُلا کر کہا، ”تمہارا بھائی بدلہ لینا چاہتا ہے۔ وہ تمہیں قتل کرنے کا ارادہ رکھتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","بیٹا، اب میری سنو، یہاں سے ہجرت کر جاؤ۔ حاران شہر میں میرے بھائی لابن کے پاس چلے جاؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","وہاں کچھ دن ٹھہرے رہنا جب تک تمہارے بھائی کا غصہ ٹھنڈا نہ ہو جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","جب اُس کا غصہ ٹھنڈا ہو جائے گا اور وہ تمہارے اُس کے ساتھ کئے گئے سلوک کو بھول جائے گا، تب مَیں اطلاع دوں گی کہ تم وہاں سے واپس آ سکتے ہو۔ مَیں کیوں ایک ہی دن میں تم دونوں سے محروم ہو جاؤں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","پھر رِبقہ نے اسحاق سے بات کی، ”مَیں عیسَو کی بیویوں کے سبب سے اپنی زندگی سے تنگ ہوں۔ اگر یعقوب بھی اِس ملک کی عورتوں میں سے کسی سے شادی کرے تو بہتر ہے کہ مَیں پہلے ہی مر جاؤں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","اسحاق نے یعقوب کو بُلا کر اُسے برکت دی اور کہا، ”لازم ہے کہ تُو کسی کنعانی عورت سے شادی نہ کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","اب سیدھے مسوپتامیہ میں اپنے نانا بتوایل کے گھر جا اور وہاں اپنے ماموں لابن کی لڑکیوں میں سے کسی ایک سے شادی کر۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","اللہ قادرِ مطلق تجھے برکت دے کر پھلنے پھولنے دے اور تجھے اِتنی اولاد دے کہ تُو بہت ساری قوموں کا باپ بنے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","وہ تجھے اور تیری اولاد کو ابراہیم کی برکت دے جسے اُس نے یہ ملک دیا جس میں تُو مہمان کے طور پر رہتا ہے۔ یہ ملک تمہارے قبضے میں آئے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","یوں اسحاق نے یعقوب کو مسوپتامیہ میں لابن کے گھر بھیجا۔ لابن اَرامی مرد بتوایل کا بیٹا اور رِبقہ کا بھائی تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","عیسَو کو پتا چلا کہ اسحاق نے یعقوب کو برکت دے کر مسوپتامیہ بھیج دیا ہے تاکہ وہاں شادی کرے۔ اُسے یہ بھی معلوم ہوا کہ اسحاق نے اُسے کنعانی عورت سے شادی کرنے سے منع کیا ہے ");
INSERT INTO urdgvu_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","اور کہ یعقوب اپنے ماں باپ کی سن کر مسوپتامیہ چلا گیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","عیسَو سمجھ گیا کہ کنعانی عورتیں میرے باپ کو منظور نہیں ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","اِس لئے وہ ابراہیم کے بیٹے اسمٰعیل کے پاس گیا اور اُس کی بیٹی محلت سے شادی کی۔ وہ نبایوت کی بہن تھی۔ یوں اُس کی بیویوں میں اضافہ ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","یعقوب بیرسبع سے حاران کی طرف روانہ ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","جب سورج غروب ہوا تو وہ رات گزارنے کے لئے رُک گیا اور وہاں کے پتھروں میں سے ایک کو لے کر اُسے اپنے سرہانے رکھا اور سو گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","جب وہ سو رہا تھا تو خواب میں ایک سیڑھی دیکھی جو زمین سے آسمان تک پہنچتی تھی۔ فرشتے اُس پر چڑھتے اور اُترتے نظر آتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","رب اُس کے اوپر کھڑا تھا۔ اُس نے کہا، ”مَیں رب ابراہیم اور اسحاق کا خدا ہوں۔ مَیں تجھے اور تیری اولاد کو یہ زمین دوں گا جس پر تُو لیٹا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","تیری اولاد زمین پر خاک کی طرح بےشمار ہو گی، اور تُو چاروں طرف پھیل جائے گا۔ دنیا کی تمام قومیں تیرے اور تیری اولاد کے وسیلے سے برکت پائیں گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","مَیں تیرے ساتھ ہوں گا، تجھے محفوظ رکھوں گا اور آخرکار تجھے اِس ملک میں واپس لاؤں گا۔ ممکن ہی نہیں کہ مَیں تیرے ساتھ اپنا وعدہ پورا کرنے سے پہلے تجھے چھوڑ دوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","تب یعقوب جاگ اُٹھا۔ اُس نے کہا، ”یقیناً رب یہاں حاضر ہے، اور مجھے معلوم نہیں تھا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","وہ ڈر گیا اور کہا، ”یہ کتنا خوف ناک مقام ہے۔ یہ تو اللہ ہی کا گھر اور آسمان کا دروازہ ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","یعقوب صبح سویرے اُٹھا۔ اُس نے وہ پتھر لیا جو اُس نے اپنے سرہانے رکھا تھا اور اُسے ستون کی طرح کھڑا کیا۔ پھر اُس نے اُس پر زیتون کا تیل اُنڈیل دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","اُس نے مقام کا نام بیت ایل یعنی ’اللہ کا گھر‘ رکھا (پہلے ساتھ والے شہر کا نام لُوز تھا)۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","اُس نے قَسم کھا کر کہا، ”اگر رب میرے ساتھ ہو، سفر پر میری حفاظت کرے، مجھے کھانا اور کپڑا مہیا کرے ");
INSERT INTO urdgvu_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","اور مَیں سلامتی سے اپنے باپ کے گھر واپس پہنچوں تو پھر وہ میرا خدا ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","جہاں یہ پتھر ستون کے طور پر کھڑا ہے وہاں اللہ کا گھر ہو گا، اور جو بھی تُو مجھے دے گا اُس کا دسواں حصہ تجھے دیا کروں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","یعقوب نے اپنا سفر جاری رکھا اور چلتے چلتے مشرقی قوموں کے ملک میں پہنچ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","وہاں اُس نے کھیت میں کنواں دیکھا جس کے ارد گرد بھیڑبکریوں کے تین ریوڑ جمع تھے۔ ریوڑوں کو کنوئیں کا پانی پلایا جانا تھا، لیکن اُس کے منہ پر بڑا پتھر پڑا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","وہاں پانی پلانے کا یہ طریقہ تھا کہ پہلے چرواہے تمام ریوڑوں کا انتظار کرتے اور پھر پتھر کو لُڑھکا کر منہ سے ہٹا دیتے تھے۔ پانی پلانے کے بعد وہ پتھر کو دوبارہ منہ پر رکھ دیتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","یعقوب نے چرواہوں سے پوچھا، ”میرے بھائیو، آپ کہاں کے ہیں؟“ اُنہوں نے جواب دیا، ”حاران کے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","اُس نے پوچھا، ”کیا آپ نحور کے پوتے لابن کو جانتے ہیں؟“ اُنہوں نے کہا، ”جی ہاں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","اُس نے پوچھا، ”کیا وہ خیریت سے ہے؟“ اُنہوں نے کہا، ”جی، وہ خیریت سے ہے۔ دیکھو، اُدھر اُس کی بیٹی راخل ریوڑ لے کر آ رہی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","یعقوب نے کہا، ”ابھی تو شام تک بہت وقت باقی ہے۔ ریوڑوں کو جمع کرنے کا وقت تو نہیں ہے۔ آپ کیوں اُنہیں پانی پلا کر دوبارہ چرنے نہیں دیتے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","اُنہوں نے جواب دیا، ”پہلے ضروری ہے کہ تمام ریوڑ یہاں پہنچیں۔ تب ہی پتھر کو لُڑھکا کر ایک طرف ہٹایا جائے گا اور ہم ریوڑوں کو پانی پلائیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","یعقوب ابھی اُن سے بات کر ہی رہا تھا کہ راخل اپنے باپ کا ریوڑ لے کر آ پہنچی، کیونکہ بھیڑبکریوں کو چَرانا اُس کا کام تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","جب یعقوب نے راخل کو ماموں لابن کے ریوڑ کے ساتھ آتے دیکھا تو اُس نے کنوئیں کے پاس جا کر پتھر کو لُڑھکا کر منہ سے ہٹا دیا اور بھیڑبکریوں کو پانی پلایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","پھر اُس نے اُسے بوسہ دیا اور خوب رونے لگا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","اُس نے کہا، ”مَیں آپ کے ابو کی بہن رِبقہ کا بیٹا ہوں۔“ یہ سن کر راخل نے بھاگ کر اپنے ابو کو اطلاع دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","جب لابن نے سنا کہ میرا بھانجا یعقوب آیا ہے تو وہ دوڑ کر اُس سے ملنے گیا اور اُسے گلے لگا کر اپنے گھر لے آیا۔ یعقوب نے اُسے سب کچھ بتا دیا جو ہوا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","لابن نے کہا، ”آپ واقعی میرے رشتے دار ہیں۔“ یعقوب نے وہاں ایک پورا مہینہ گزارا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","پھر لابن یعقوب سے کہنے لگا، ”بےشک آپ میرے رشتے دار ہیں، لیکن آپ کو میرے لئے کام کرنے کے بدلے میں کچھ ملنا چاہئے۔ مَیں آپ کو کتنے پیسے دوں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","لابن کی دو بیٹیاں تھیں۔ بڑی کا نام لیاہ تھا اور چھوٹی کا راخل۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","لیاہ کی آنکھیں چُندھی تھیں جبکہ راخل ہر طرح سے خوب صورت تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","یعقوب کو راخل سے محبت تھی، اِس لئے اُس نے کہا، ”اگر مجھے آپ کی چھوٹی بیٹی راخل مل جائے تو آپ کے لئے سات سال کام کروں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","لابن نے کہا، ”کسی اَور آدمی کی نسبت مجھے یہ زیادہ پسند ہے کہ آپ ہی سے اُس کی شادی کراؤں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","پس یعقوب نے راخل کو پانے کے لئے سات سال تک کام کیا۔ لیکن اُسے ایسا لگا جیسا دو ایک دن ہی گزرے ہوں کیونکہ وہ راخل کو شدت سے پیار کرتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","اِس کے بعد اُس نے لابن سے کہا، ”مدت پوری ہو گئی ہے۔ اب مجھے اپنی بیٹی سے شادی کرنے دیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","لابن نے اُس مقام کے تمام لوگوں کو دعوت دے کر شادی کی ضیافت کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","لیکن اُس رات وہ راخل کی بجائے لیاہ کو یعقوب کے پاس لے آیا، اور یعقوب اُسی سے ہم بستر ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(لابن نے لیاہ کو اپنی لونڈی زِلفہ دے دی تھی تاکہ وہ اُس کی خدمت کرے۔) ");
INSERT INTO urdgvu_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","جب صبح ہوئی تو یعقوب نے دیکھا کہ لیاہ ہی میرے پاس ہے۔ اُس نے لابن کے پاس جا کر کہا، ”یہ آپ نے میرے ساتھ کیا کِیا ہے؟ کیا مَیں نے راخل کے لئے کام نہیں کیا؟ آپ نے مجھے دھوکا کیوں دیا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","لابن نے جواب دیا، ”یہاں دستور نہیں ہے کہ چھوٹی بیٹی کی شادی بڑی سے پہلے کر دی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ایک ہفتے کے بعد شادی کی رسومات پوری ہو جائیں گی۔ اُس وقت تک صبر کریں۔ پھر مَیں آپ کو راخل بھی دے دوں گا۔ شرط یہ ہے کہ آپ مزید سات سال میرے لئے کام کریں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","یعقوب مان گیا۔ چنانچہ جب ایک ہفتے کے بعد شادی کی رسومات پوری ہوئیں تو لابن نے اپنی بیٹی راخل کی شادی بھی اُس کے ساتھ کر دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(لابن نے راخل کو اپنی لونڈی بِلہاہ دے دی تاکہ وہ اُس کی خدمت کرے۔) ");
INSERT INTO urdgvu_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","یعقوب راخل سے بھی ہم بستر ہوا۔ وہ لیاہ کی نسبت اُسے زیادہ پیار کرتا تھا۔ پھر اُس نے راخل کے عوض سات سال اَور لابن کی خدمت کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","جب رب نے دیکھا کہ لیاہ سے نفرت کی جاتی ہے تو اُس نے اُسے اولاد دی جبکہ راخل کے ہاں بچے پیدا نہ ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","لیاہ حاملہ ہوئی اور اُس کے بیٹا پیدا ہوا۔ اُس نے کہا، ”رب نے میری مصیبت دیکھی ہے اور اب میرا شوہر مجھے پیار کرے گا۔“ اُس نے اُس کا نام روبن یعنی ’دیکھو ایک بیٹا‘ رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","وہ دوبارہ حاملہ ہوئی۔ ایک اَور بیٹا پیدا ہوا۔ اُس نے کہا، ”رب نے سنا کہ مجھ سے نفرت کی جاتی ہے، اِس لئے اُس نے مجھے یہ بھی دیا ہے۔“ اُس نے اُس کا نام شمعون یعنی ’رب نے سنا ہے‘ رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","وہ ایک اَور دفعہ حاملہ ہوئی۔ تیسرا بیٹا پیدا ہوا۔ اُس نے کہا، ”اب آخرکار شوہر کے ساتھ میرا بندھن مضبوط ہو جائے گا، کیونکہ مَیں نے اُس کے لئے تین بیٹوں کو جنم دیا ہے۔“ اُس نے اُس کا نام لاوی یعنی بندھن رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","وہ ایک بار پھر حاملہ ہوئی۔ چوتھا بیٹا پیدا ہوا۔ اُس نے کہا، ”اِس دفعہ مَیں رب کی تمجید کروں گی۔“ اُس نے اُس کا نام یہوداہ یعنی تمجید رکھا۔ اِس کے بعد اُس سے اَور بچے پیدا نہ ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","لیکن راخل بےاولاد ہی رہی، اِس لئے وہ اپنی بہن سے حسد کرنے لگی۔ اُس نے یعقوب سے کہا، ”مجھے بھی اولاد دیں ورنہ مَیں مر جاؤں گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","یعقوب کو غصہ آیا۔ اُس نے کہا، ”کیا مَیں اللہ ہوں جس نے تجھے اولاد سے محروم رکھاہے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","راخل نے کہا، ”یہاں میری لونڈی بِلہاہ ہے۔ اُس کے ساتھ ہم بستر ہوں تاکہ وہ میرے لئے بچے کو جنم دے اور مَیں اُس کی معرفت ماں بن جاؤں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","یوں اُس نے اپنے شوہر کو بِلہاہ دی، اور وہ اُس سے ہم بستر ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","بِلہاہ حاملہ ہوئی اور بیٹا پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","راخل نے کہا، ”اللہ نے میرے حق میں فیصلہ دیا ہے۔ اُس نے میری دعا سن کر مجھے بیٹا دے دیا ہے۔“ اُس نے اُس کا نام دان یعنی ’کسی کے حق میں فیصلہ کرنے والا‘ رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","بِلہاہ دوبارہ حاملہ ہوئی اور ایک اَور بیٹا پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","راخل نے کہا، ”مَیں نے اپنی بہن سے سخت کُشتی لڑی ہے، لیکن جیت گئی ہوں۔“ اُس نے اُس کا نام نفتالی یعنی ’کُشتی میں مجھ سے جیتا گیا‘ رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","جب لیاہ نے دیکھا کہ میرے اَور بچے پیدا نہیں ہو رہے تو اُس نے یعقوب کو اپنی لونڈی زِلفہ دے دی تاکہ وہ بھی اُس کی بیوی ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","زِلفہ کے بھی ایک بیٹا پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","لیاہ نے کہا، ”مَیں کتنی خوش قسمت ہوں!“ چنانچہ اُس نے اُس کا نام جد یعنی خوش قسمتی رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","پھر زِلفہ کے دوسرا بیٹا پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","لیاہ نے کہا، ”مَیں کتنی مبارک ہوں۔ اب خواتین مجھے مبارک کہیں گی۔“ اُس نے اُس کا نام آشر یعنی مبارک رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ایک دن اناج کی فصل کی کٹائی ہو رہی تھی کہ روبن باہر نکل کر کھیتوں میں چلا گیا۔ وہاں اُسے مردم گیاہ مل گئے۔ وہ اُنہیں اپنی ماں لیاہ کے پاس لے آیا۔ یہ دیکھ کر راخل نے لیاہ سے کہا، ”مجھے ذرا اپنے بیٹے کے مردم گیاہ میں سے کچھ دے دو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","لیاہ نے جواب دیا، ”کیا یہی کافی نہیں کہ تم نے میرے شوہر کو مجھ سے چھین لیا ہے؟ اب میرے بیٹے کے مردم گیاہ کو بھی چھیننا چاہتی ہو۔“ راخل نے کہا، ”اگر تم مجھے اپنے بیٹے کے مردم گیاہ میں سے دو تو آج رات یعقوب کے ساتھ سو سکتی ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","شام کو یعقوب کھیتوں سے واپس آ رہا تھا کہ لیاہ آگے سے اُس سے ملنے کو گئی اور کہا، ”آج رات آپ کو میرے ساتھ سونا ہے، کیونکہ مَیں نے اپنے بیٹے کے مردم گیاہ کے عوض آپ کو اُجرت پر لیا ہے۔“ چنانچہ یعقوب نے لیاہ کے پاس رات گزاری۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","اُس وقت اللہ نے لیاہ کی دعا سنی اور وہ حاملہ ہوئی۔ اُس کے پانچواں بیٹا پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","لیاہ نے کہا، ”اللہ نے مجھے اِس کا اجر دیا ہے کہ مَیں نے اپنے شوہر کو اپنی لونڈی دی۔“ اُس نے اُس کا نام اِشکار یعنی اجر رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","اِس کے بعد وہ ایک اَور دفعہ حاملہ ہوئی۔ اُس کے چھٹا بیٹا پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","اُس نے کہا، ”اللہ نے مجھے ایک اچھا خاصا تحفہ دیا ہے۔ اب میرا خاوند میرے ساتھ رہے گا، کیونکہ مجھ سے اُس کے چھ بیٹے پیدا ہوئے ہیں۔“ اُس نے اُس کا نام زبولون یعنی رہائش رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","اِس کے بعد بیٹی پیدا ہوئی۔ اُس نے اُس کا نام دینہ رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","پھر اللہ نے راخل کو بھی یاد کیا۔ اُس نے اُس کی دعا سن کر اُسے اولاد بخشی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","وہ حاملہ ہوئی اور ایک بیٹا پیدا ہوا۔ اُس نے کہا، ”مجھے بیٹا عطا کرنے سے اللہ نے میری عزت بحال کر دی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","رب مجھے ایک اَور بیٹا دے۔“ اُس نے اُس کا نام یوسف یعنی ’وہ اَور دے‘ رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","یوسف کی پیدائش کے بعد یعقوب نے لابن سے کہا، ”اب مجھے اجازت دیں کہ مَیں اپنے وطن اور گھر کو واپس جاؤں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","مجھے میرے بال بچے دیں جن کے عوض مَیں نے آپ کی خدمت کی ہے۔ پھر مَیں چلا جاؤں گا۔ آپ تو خود جانتے ہیں کہ مَیں نے کتنی محنت کے ساتھ آپ کے لئے کام کیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","لیکن لابن نے کہا، ”مجھ پر مہربانی کریں اور یہیں رہیں۔ مجھے غیب دانی سے پتا چلا ہے کہ رب نے مجھے آپ کے سبب سے برکت دی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","اپنی اُجرت خود مقرر کریں تو مَیں وہی دیا کروں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","یعقوب نے کہا، ”آپ جانتے ہیں کہ مَیں نے کس طرح آپ کے لئے کام کیا، کہ میرے وسیلے سے آپ کے مویشی کتنے بڑھ گئے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","جو تھوڑا بہت میرے آنے سے پہلے آپ کے پاس تھا وہ اب بہت زیادہ بڑھ گیا ہے۔ رب نے میرے کام سے آپ کو بہت برکت دی ہے۔ اب وہ وقت آ گیا ہے کہ مَیں اپنے گھر کے لئے کچھ کروں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","لابن نے کہا، ”مَیں آپ کو کیا دوں؟“ یعقوب نے کہا، ”مجھے کچھ نہ دیں۔ مَیں اِس شرط پر آپ کی بھیڑبکریوں کی دیکھ بھال جاری رکھوں گا کہ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","آج مَیں آپ کے ریوڑ میں سے گزر کر اُن تمام بھیڑوں کو الگ کر لوں گا جن کے جسم پر چھوٹے یا بڑے دھبے ہوں یا جو سفید نہ ہوں۔ اِسی طرح مَیں اُن تمام بکریوں کو بھی الگ کر لوں گا جن کے جسم پر چھوٹے یا بڑے دھبے ہوں۔ یہی میری اُجرت ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","آئندہ جن بکریوں کے جسم پر چھوٹے یا بڑے دھبے ہوں گے یا جن بھیڑوں کا رنگ سفید نہیں ہو گا وہ میرا اجر ہوں گی۔ جب کبھی آپ اُن کا معائنہ کریں گے تو آپ معلوم کر سکیں گے کہ مَیں دیانت دار رہا ہوں۔ کیونکہ میرے جانوروں کے رنگ سے ہی ظاہر ہو گا کہ مَیں نے آپ کا کچھ چُرایا نہیں ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","لابن نے کہا، ”ٹھیک ہے۔ ایسا ہی ہو جیسا آپ نے کہا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","اُسی دن لابن نے اُن بکروں کو الگ کر لیا جن کے جسم پر دھاریاں یا دھبے تھے اور اُن تمام بکریوں کو جن کے جسم پر چھوٹے یا بڑے دھبے تھے۔ جس کے بھی جسم پر سفید نشان تھا اُسے اُس نے الگ کر لیا۔ اِسی طرح اُس نے اُن تمام بھیڑوں کو بھی الگ کر لیا جو پورے طور پر سفید نہ تھے۔ پھر لابن نے اُنہیں اپنے بیٹوں کے سپرد کر دیا ");
INSERT INTO urdgvu_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","جو اُن کے ساتھ یعقوب سے اِتنا دُور چلے گئے کہ اُن کے درمیان تین دن کا فاصلہ تھا۔ تب یعقوب لابن کی باقی بھیڑبکریوں کی دیکھ بھال کرتا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","یعقوب نے سفیدہ، بادام اور چنار کی ہری ہری شاخیں لے کر اُن سے کچھ چھلکا یوں اُتار دیا کہ اُس پر سفید دھاریاں نظر آئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","اُس نے اُنہیں بھیڑبکریوں کے سامنے اُن حوضوں میں گاڑ دیا جہاں وہ پانی پیتے تھے، کیونکہ وہاں یہ جانور مست ہو کر ملاپ کرتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","جب وہ اِن شاخوں کے سامنے ملاپ کرتے تو جو بچے پیدا ہوتے اُن کے جسم پر چھوٹے اور بڑے دھبے اور دھاریاں ہوتی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","پھر یعقوب نے بھیڑ کے بچوں کو الگ کر کے اپنے ریوڑوں کو لابن کے اُن جانوروں کے سامنے چرنے دیا جن کے جسم پر دھاریاں تھیں اور جو سفید نہ تھے۔ یوں اُس نے اپنے ذاتی ریوڑوں کو الگ کر لیا اور اُنہیں لابن کے ریوڑ کے ساتھ چرنے نہ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","لیکن اُس نے یہ شاخیں صرف اُس وقت حوضوں میں کھڑی کیں جب طاقت ور جانور مست ہو کر ملاپ کرتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","کمزور جانوروں کے ساتھ اُس نے ایسا نہ کیا۔ اِسی طرح لابن کو کمزور جانور اور یعقوب کو طاقت ور جانور مل گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","یوں یعقوب بہت امیر بن گیا۔ اُس کے پاس بہت سے ریوڑ، غلام اور لونڈیاں، اونٹ اور گدھے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ایک دن یعقوب کو پتا چلا کہ لابن کے بیٹے میرے بارے میں کہہ رہے ہیں، ”یعقوب نے ہمارے ابو سے سب کچھ چھین لیا ہے۔ اُس نے یہ تمام دولت ہمارے باپ کی ملکیت سے حاصل کی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","یعقوب نے یہ بھی دیکھا کہ لابن کا میرے ساتھ رویہ پہلے کی نسبت بگڑ گیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","پھر رب نے اُس سے کہا، ”اپنے باپ کے ملک اور اپنے رشتے داروں کے پاس واپس چلا جا۔ مَیں تیرے ساتھ ہوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","اُس وقت یعقوب کھلے میدان میں اپنے ریوڑوں کے پاس تھا۔ اُس نے وہاں سے راخل اور لیاہ کو بُلا کر ");
INSERT INTO urdgvu_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","اُن سے کہا، ”مَیں نے دیکھ لیا ہے کہ آپ کے باپ کا میرے ساتھ رویہ پہلے کی نسبت بگڑ گیا ہے۔ لیکن میرے باپ کا خدا میرے ساتھ رہا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","آپ دونوں جانتی ہیں کہ مَیں نے آپ کے ابو کے لئے کتنی جاں فشانی سے کام کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","لیکن وہ مجھے فریب دیتا رہا اور میری اُجرت دس بار بدلی۔ تاہم اللہ نے اُسے مجھے نقصان پہنچانے نہ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","جب ماموں لابن کہتے تھے، ’جن جانوروں کے جسم پر دھبے ہوں وہی آپ کو اُجرت کے طور پر ملیں گے‘ تو تمام بھیڑبکریوں کے ایسے بچے پیدا ہوئے جن کے جسموں پر دھبے ہی تھے۔ جب اُنہوں نے کہا، ’جن جانوروں کے جسم پر دھاریاں ہوں گی وہی آپ کو اُجرت کے طور پر ملیں گے‘ تو تمام بھیڑبکریوں کے ایسے بچے پیدا ہوئے جن کے جسموں پر دھاریاں ہی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","یوں اللہ نے آپ کے ابو کے مویشی چھین کر مجھے دے دیئے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","اب ایسا ہوا کہ حیوانوں کی مستی کے موسم میں مَیں نے ایک خواب دیکھا۔ اُس میں جو مینڈھے اور بکرے بھیڑبکریوں سے ملاپ کر رہے تھے اُن کے جسم پر بڑے اور چھوٹے دھبے اور دھاریاں تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","اُس خواب میں اللہ کے فرشتے نے مجھ سے بات کی، ’یعقوب!‘ مَیں نے کہا، ’جی، مَیں حاضر ہوں۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","فرشتے نے کہا، ’اپنی نظر اُٹھا کر اُس پر غور کر جو ہو رہا ہے۔ وہ تمام مینڈھے اور بکرے جو بھیڑبکریوں سے ملاپ کر رہے ہیں اُن کے جسم پر بڑے اور چھوٹے دھبے اور دھاریاں ہیں۔ مَیں یہ خود کروا رہا ہوں، کیونکہ مَیں نے وہ سب کچھ دیکھ لیا ہے جو لابن نے تیرے ساتھ کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","مَیں وہ خدا ہوں جو بیت ایل میں تجھ پر ظاہر ہوا تھا، اُس جگہ جہاں تُو نے ستون پر تیل اُنڈیل کر اُسے میرے لئے مخصوص کیا اور میرے حضور قَسم کھائی تھی۔ اب اُٹھ اور روانہ ہو کر اپنے وطن واپس چلا جا‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","راخل اور لیاہ نے جواب میں یعقوب سے کہا، ”اب ہمیں اپنے باپ کی میراث سے کچھ ملنے کی اُمید نہیں رہی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","اُس کا ہمارے ساتھ اجنبی کا سا سلوک ہے۔ پہلے اُس نے ہمیں بیچ دیا، اور اب اُس نے وہ سارے پیسے کھا بھی لئے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","چنانچہ جو بھی دولت اللہ نے ہمارے باپ سے چھین لی ہے وہ ہماری اور ہمارے بچوں کی ہی ہے۔ اب جو کچھ بھی اللہ نے آپ کو بتایا ہے وہ کریں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","تب یعقوب نے اُٹھ کر اپنے بال بچوں کو اونٹوں پر بٹھایا ");
INSERT INTO urdgvu_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","اور اپنے تمام مویشی اور مسوپتامیہ سے حاصل کیا ہوا تمام سامان لے کر ملکِ کنعان میں اپنے باپ کے ہاں جانے کے لئے روانہ ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","اُس وقت لابن اپنی بھیڑبکریوں کی پشم کترنے کو گیا ہوا تھا۔ اُس کی غیرموجودگی میں راخل نے اپنے باپ کے بُت چُرا لئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","یعقوب نے لابن کو فریب دے کر اُسے اطلاع نہ دی کہ مَیں جا رہا ہوں ");
INSERT INTO urdgvu_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","بلکہ اپنی ساری ملکیت سمیٹ کر فرار ہوا۔ دریائے فرات کو پار کر کے وہ جِلعاد کے پہاڑی علاقے کی طرف سفر کرنے لگا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","تین دن گزر گئے۔ پھر لابن کو بتایا گیا کہ یعقوب بھاگ گیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","اپنے رشتے داروں کو ساتھ لے کر اُس نے اُس کا تعاقب کیا۔ سات دن چلتے چلتے اُس نے یعقوب کو آ لیا جب وہ جِلعاد کے پہاڑی علاقے میں پہنچ گیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","لیکن اُس رات اللہ نے خواب میں لابن کے پاس آ کر اُس سے کہا، ”خبردار! یعقوب کو بُرا بھلا نہ کہنا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","جب لابن اُس کے پاس پہنچا تو یعقوب نے جِلعاد کے پہاڑی علاقے میں اپنے خیمے لگائے ہوئے تھے۔ لابن نے بھی اپنے رشتے داروں کے ساتھ وہیں اپنے خیمے لگائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","اُس نے یعقوب سے کہا، ”یہ آپ نے کیا کِیا ہے؟ آپ مجھے دھوکا دے کر میری بیٹیوں کو کیوں جنگی قیدیوں کی طرح ہانک لائے ہیں؟ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","آپ کیوں مجھے فریب دے کر خاموشی سے بھاگ آئے ہیں؟ اگر آپ مجھے اطلاع دیتے تو مَیں آپ کو خوشی خوشی دف اور سرود کے ساتھ گاتے بجاتے رُخصت کرتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","آپ نے مجھے اپنے نواسے نواسیوں اور بیٹیوں کو بوسہ دینے کا موقع بھی نہ دیا۔ آپ کی یہ حرکت بڑی احمقانہ تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","مَیں آپ کو بہت نقصان پہنچا سکتا ہوں۔ لیکن پچھلی رات آپ کے ابو کے خدا نے مجھ سے کہا، ’خبردار! یعقوب کو بُرا بھلا نہ کہنا۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ٹھیک ہے، آپ اِس لئے چلے گئے کہ اپنے باپ کے گھر واپس جانے کے بڑے آرزومند تھے۔ لیکن یہ آپ نے کیا کِیا ہے کہ میرے بُت چُرا لائے ہیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","یعقوب نے جواب دیا، ”مجھے ڈر تھا کہ آپ اپنی بیٹیوں کو مجھ سے چھین لیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","لیکن اگر آپ کو یہاں کسی کے پاس اپنے بُت مل جائیں تو اُسے سزائے موت دی جائے۔ ہمارے رشتے داروں کی موجودگی میں معلوم کریں کہ میرے پاس آپ کی کوئی چیز ہے کہ نہیں۔ اگر ہے تو اُسے لے لیں۔“ یعقوب کو معلوم نہیں تھا کہ راخل نے بُتوں کو چُرایا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","لابن یعقوب کے خیمے میں داخل ہوا اور ڈھونڈنے لگا۔ وہاں سے نکل کر وہ لیاہ کے خیمے میں اور دونوں لونڈیوں کے خیمے میں گیا۔ لیکن اُس کے بُت کہیں نظر نہ آئے۔ آخر میں وہ راخل کے خیمے میں داخل ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","راخل بُتوں کو اونٹوں کی ایک کاٹھی کے نیچے چھپا کر اُس پر بیٹھ گئی تھی۔ لابن ٹٹول ٹٹول کر پورے خیمے میں سے گزرا لیکن بُت نہ ملے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","راخل نے اپنے باپ سے کہا، ”ابو، مجھ سے ناراض نہ ہونا کہ مَیں آپ کے سامنے کھڑی نہیں ہو سکتی۔ مَیں ایامِ ماہواری کے سبب سے اُٹھ نہیں سکتی۔“ لابن اُسے چھوڑ کر ڈھونڈتا رہا، لیکن کچھ نہ ملا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","پھر یعقوب کو غصہ آیا اور وہ لابن سے جھگڑنے لگا۔ اُس نے پوچھا، ”مجھ سے کیا جرم سرزد ہوا ہے؟ مَیں نے کیا گناہ کیا ہے کہ آپ اِتنی تُندی سے میرے تعاقب کے لئے نکلے ہیں؟ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","آپ نے ٹٹول ٹٹول کر میرے سارے سامان کی تلاشی لی ہے۔ تو آپ کا کیا نکلا ہے؟ اُسے یہاں اپنے اور میرے رشتے داروں کے سامنے رکھیں۔ پھر وہ فیصلہ کریں کہ ہم میں سے کون حق پر ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","مَیں بیس سال تک آپ کے ساتھ رہا ہوں۔ اُس دوران آپ کی بھیڑبکریاں بچوں سے محروم نہیں رہیں بلکہ مَیں نے آپ کا ایک مینڈھا بھی نہیں کھایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","جب بھی کوئی بھیڑ یا بکری کسی جنگلی جانور نے پھاڑ ڈالی تو مَیں اُسے آپ کے پاس نہ لایا بلکہ مجھے خود اُس کا نقصان بھرنا پڑا۔ آپ کا تقاضا تھا کہ مَیں خود چوری ہوئے مال کا عوضانہ دوں، خواہ وہ دن کے وقت چوری ہوا یا رات کو۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","مَیں دن کی شدید گرمی کے باعث پگھل گیا اور رات کی شدید سردی کے باعث جم گیا۔ کام اِتنا سخت تھا کہ مَیں نیند سے محروم رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","پورے بیس سال اِسی حالت میں گزر گئے۔ چودہ سال مَیں نے آپ کی بیٹیوں کے عوض کام کیا اور چھ سال آپ کی بھیڑبکریوں کے لئے۔ اُس دوران آپ نے دس بار میری تنخواہ بدل دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","اگر میرے باپ اسحاق کا خدا اور میرے دادا ابراہیم کا معبود میرے ساتھ نہ ہوتا تو آپ مجھے ضرور خالی ہاتھ رُخصت کرتے۔ لیکن اللہ نے میری مصیبت اور میری سخت محنت مشقت دیکھی ہے، اِس لئے اُس نے کل رات کو میرے حق میں فیصلہ دیا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","تب لابن نے یعقوب سے کہا، ”یہ بیٹیاں تو میری بیٹیاں ہیں، اور اِن کے بچے میرے بچے ہیں۔ یہ بھیڑبکریاں بھی میری ہی ہیں۔ لیکن اب مَیں اپنی بیٹیوں اور اُن کے بچوں کے لئے کچھ نہیں کر سکتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","اِس لئے آؤ، ہم ایک دوسرے کے ساتھ عہد باندھیں۔ اِس کے لئے ہم یہاں پتھروں کا ڈھیر لگائیں جو عہد کی گواہی دیتا رہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","چنانچہ یعقوب نے ایک پتھر لے کر اُسے ستون کے طور پر کھڑا کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","اُس نے اپنے رشتے داروں سے کہا، ”کچھ پتھر جمع کریں۔“ اُنہوں نے پتھر جمع کر کے ڈھیر لگا دیا۔ پھر اُنہوں نے اُس ڈھیر کے پاس بیٹھ کر کھانا کھایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","لابن نے اُس کا نام ’یجرشاہدوتھا‘ رکھا جبکہ یعقوب نے ’جلعید‘ رکھا۔ دونوں ناموں کا مطلب ’گواہی کا ڈھیر‘ ہے یعنی وہ ڈھیر جو گواہی دیتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","لابن نے کہا، ”آج ہم دونوں کے درمیان یہ ڈھیر عہد کی گواہی دیتا ہے۔“ اِس لئے اُس کا نام جلعید رکھا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","اُس کا ایک اَور نام مِصفاہ یعنی ’پہرے داروں کا مینار‘ بھی رکھا گیا۔ کیونکہ لابن نے کہا، ”رب ہم پر پہرا دے جب ہم ایک دوسرے سے الگ ہو جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","میری بیٹیوں سے بُرا سلوک نہ کرنا، نہ اُن کے علاوہ کسی اَور سے شادی کرنا۔ اگر مجھے پتا بھی نہ چلے لیکن ضرور یاد رکھیں کہ اللہ میرے اور آپ کے سامنے گواہ ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","یہاں یہ ڈھیر ہے جو مَیں نے لگا دیا ہے اور یہاں یہ ستون بھی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","یہ ڈھیر اور ستون دونوں اِس کے گواہ ہیں کہ نہ مَیں یہاں سے گزر کر آپ کو نقصان پہنچاؤں گا اور نہ آپ یہاں سے گزر کر مجھے نقصان پہنچائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ابراہیم، نحور اور اُن کے باپ کا خدا ہم دونوں کے درمیان فیصلہ کرے اگر ایسا کوئی معاملہ ہو۔“ جواب میں یعقوب نے اسحاق کے معبود کی قَسم کھائی کہ مَیں یہ عہد کبھی نہیں توڑوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","اُس نے پہاڑ پر ایک جانور قربانی کے طور پر چڑھایا اور اپنے رشتے داروں کو کھانا کھانے کی دعوت دی۔ اُنہوں نے کھانا کھا کر وہیں پہاڑ پر رات گزاری۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","اگلے دن صبح سویرے لابن نے اپنے نواسے نواسیوں اور بیٹیوں کو بوسہ دے کر اُنہیں برکت دی۔ پھر وہ اپنے گھر واپس چلا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","یعقوب نے بھی اپنا سفر جاری رکھا۔ راستے میں اللہ کے فرشتے اُس سے ملے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","اُنہیں دیکھ کر اُس نے کہا، ”یہ اللہ کی لشکرگاہ ہے۔“ اُس نے اُس مقام کا نام محنائم یعنی ’دو لشکرگاہیں‘ رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","یعقوب نے اپنے بھائی عیسَو کے پاس اپنے آگے آگے قاصد بھیجے۔ عیسَو سعیر یعنی ادوم کے ملک میں آباد تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","اُنہیں عیسَو کو بتانا تھا، ”آپ کا خادم یعقوب آپ کو اطلاع دیتا ہے کہ مَیں پردیس میں جا کر اب تک لابن کا مہمان رہا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","وہاں مجھے بَیل، گدھے، بھیڑبکریاں، غلام اور لونڈیاں حاصل ہوئے ہیں۔ اب مَیں اپنے مالک کو اطلاع دے رہا ہوں کہ واپس آ گیا ہوں اور آپ کی نظرِ کرم کا خواہش مند ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","جب قاصد واپس آئے تو اُنہوں نے کہا، ”ہم آپ کے بھائی عیسَو کے پاس گئے، اور وہ 400 آدمی ساتھ لے کر آپ سے ملنے آ رہا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","یعقوب گھبرا کر بہت پریشان ہوا۔ اُس نے اپنے ساتھ کے تمام لوگوں، بھیڑبکریوں، گائےبَیلوں اور اونٹوں کو دو گروہوں میں تقسیم کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","خیال یہ تھا کہ اگر عیسَو آ کر ایک گروہ پر حملہ کرے تو باقی گروہ شاید بچ جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","پھر یعقوب نے دعا کی، ”اے میرے دادا ابراہیم اور میرے باپ اسحاق کے خدا، میری دعا سن! اے رب، تُو نے خود مجھے بتایا، ’اپنے ملک اور رشتے داروں کے پاس واپس جا، اور مَیں تجھے کامیابی دوں گا۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","مَیں اُس تمام مہربانی اور وفاداری کے لائق نہیں جو تُو نے اپنے خادم کو دکھائی ہے۔ جب مَیں نے لابن کے پاس جاتے وقت دریائے یردن کو پار کیا تو میرے پاس صرف یہ لاٹھی تھی، اور اب میرے پاس یہ دو گروہ ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","مجھے اپنے بھائی عیسَو سے بچا، کیونکہ مجھے ڈر ہے کہ وہ مجھ پر حملہ کر کے بال بچوں سمیت سب کچھ تباہ کر دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","تُو نے خود کہا تھا، ’مَیں تجھے کامیابی دوں گا اور تیری اولاد اِتنی بڑھاؤں گا کہ وہ سمندر کی ریت کی مانند بےشمار ہو گی‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","یعقوب نے وہاں رات گزاری۔ پھر اُس نے اپنے مال میں سے عیسَو کے لئے تحفے چن لئے: ");
INSERT INTO urdgvu_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 بکریاں، 20 بکرے، 200 بھیڑیں، 20 مینڈھے، ");
INSERT INTO urdgvu_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 دودھ دینے والی اونٹنیاں بچوں سمیت، 40 گائیں، 10 بَیل، 20 گدھیاں اور 10 گدھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","اُس نے اُنہیں مختلف ریوڑوں میں تقسیم کر کے اپنے مختلف نوکروں کے سپرد کیا اور اُن سے کہا، ”میرے آگے آگے چلو لیکن ہر ریوڑ کے درمیان فاصلہ رکھو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","جو نوکر پہلے ریوڑ لے کر آگے نکلا اُس سے یعقوب نے کہا، ”میرا بھائی عیسَو تم سے ملے گا اور پوچھے گا، ’تمہارا مالک کون ہے؟ تم کہاں جا رہے ہو؟ تمہارے سامنے کے جانور کس کے ہیں؟‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","جواب میں تمہیں کہنا ہے، ’یہ آپ کے خادم یعقوب کے ہیں۔ یہ تحفہ ہیں جو وہ اپنے مالک عیسَو کو بھیج رہے ہیں۔ یعقوب ہمارے پیچھے پیچھے آ رہے ہیں‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","یعقوب نے یہی حکم ہر ایک نوکر کو دیا جسے ریوڑ لے کر اُس کے آگے آگے جانا تھا۔ اُس نے کہا، ”جب تم عیسَو سے ملو گے تو اُس سے یہی کہنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","تمہیں یہ بھی ضرور کہنا ہے، ’آپ کے خادم یعقوب ہمارے پیچھے آ رہے ہیں‘۔“ کیونکہ یعقوب نے سوچا، ’مَیں اِن تحفوں سے اُس کے ساتھ صلح کروں گا۔ پھر جب اُس سے ملاقات ہو گی تو شاید وہ مجھے قبول کر لے۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","یوں اُس نے یہ تحفے اپنے آگے آگے بھیج دیئے۔ لیکن اُس نے خود خیمہ گاہ میں رات گزاری۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","اُس رات وہ اُٹھا اور اپنی دو بیویوں، دو لونڈیوں اور گیارہ بیٹوں کو لے کر دریائے یبوق کو وہاں سے پار کیا جہاں کم گہرائی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","پھر اُس نے اپنا سارا سامان بھی وہاں بھیج دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","لیکن وہ خود اکیلا ہی پیچھے رہ گیا۔ اُس وقت ایک آدمی آیا اور پَو پھٹنے تک اُس سے کُشتی لڑتا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","جب اُس نے دیکھا کہ مَیں یعقوب پر غالب نہیں آ رہا تو اُس نے اُس کے کولھے کو چھوا، اور اُس کا جوڑ نکل گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","آدمی نے کہا، ”مجھے جانے دے، کیونکہ پَو پھٹنے والی ہے۔“ یعقوب نے کہا، ”پہلے مجھے برکت دیں، پھر ہی آپ کو جانے دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","آدمی نے پوچھا، ”تیرا کیا نام ہے؟“ اُس نے جواب دیا، ”یعقوب۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","آدمی نے کہا، ”اب سے تیرا نام یعقوب نہیں بلکہ اسرائیل یعنی ’وہ اللہ سے لڑتا ہے‘ ہو گا۔ کیونکہ تُو اللہ اور آدمیوں کے ساتھ لڑ کر غالب آیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","یعقوب نے کہا، ”مجھے اپنا نام بتائیں۔“ اُس نے کہا، ”تُو کیوں میرا نام جاننا چاہتا ہے؟“ پھر اُس نے یعقوب کو برکت دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","یعقوب نے کہا، ”مَیں نے اللہ کو رُوبرُو دیکھا توبھی بچ گیا ہوں۔“ اِس لئے اُس نے اُس مقام کا نام فنی ایل رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","یعقوب وہاں سے چلا تو سورج طلوع ہو رہا تھا۔ وہ کولھے کے سبب سے لنگڑاتا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","یہی وجہ ہے کہ آج بھی اسرائیل کی اولاد کولھے کے جوڑ پر کی نس کو نہیں کھاتے، کیونکہ یعقوب کی اِسی نس کو چھوا گیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","پھر عیسَو اُن کی طرف آتا ہوا نظر آیا۔ اُس کے ساتھ 400 آدمی تھے۔ اُنہیں دیکھ کر یعقوب نے بچوں کو بانٹ کر لیاہ، راخل اور دونوں لونڈیوں کے حوالے کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","اُس نے دونوں لونڈیوں کو اُن کے بچوں سمیت آگے چلنے دیا۔ پھر لیاہ اُس کے بچوں سمیت اور آخر میں راخل اور یوسف آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","یعقوب خود سب سے آگے عیسَو سے ملنے گیا۔ چلتے چلتے وہ سات دفعہ زمین تک جھکا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","لیکن عیسَو دوڑ کر اُس سے ملنے آیا اور اُسے گلے لگا کر بوسہ دیا۔ دونوں رو پڑے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","پھر عیسَو نے عورتوں اور بچوں کو دیکھا۔ اُس نے پوچھا، ”تمہارے ساتھ یہ لوگ کون ہیں؟“ یعقوب نے کہا، ”یہ آپ کے خادم کے بچے ہیں جو اللہ نے اپنے کرم سے نوازے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","دونوں لونڈیاں اپنے بچوں سمیت آ کر اُس کے سامنے جھک گئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","پھر لیاہ اپنے بچوں کے ساتھ آئی اور آخر میں یوسف اور راخل آ کر جھک گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","عیسَو نے پوچھا، ”جس جانوروں کے بڑے غول سے میری ملاقات ہوئی اُس سے کیا مراد ہے؟“ یعقوب نے جواب دیا، ”یہ تحفہ ہے تاکہ آپ کا خادم آپ کی نظر میں مقبول ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","لیکن عیسَو نے کہا، ”میرے بھائی، میرے پاس بہت کچھ ہے۔ یہ اپنے پاس ہی رکھو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","یعقوب نے کہا، ”نہیں جی، اگر مجھ پر آپ کے کرم کی نظر ہے تو میرے اِس تحفے کو ضرور قبول فرمائیں۔ کیونکہ جب مَیں نے آپ کا چہرہ دیکھا تو وہ میرے لئے اللہ کے چہرے کی مانند تھا، آپ نے میرے ساتھ اِس قدر اچھا سلوک کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","مہربانی کر کے یہ تحفہ قبول کریں جو مَیں آپ کے لئے لایا ہوں۔ کیونکہ اللہ نے مجھ پر اپنے کرم کا اظہار کیا ہے، اور میرے پاس بہت کچھ ہے۔“ یعقوب اصرار کرتا رہا تو آخرکار عیسَو نے اُسے قبول کر لیا۔ پھر عیسَو کہنے لگا، ");
INSERT INTO urdgvu_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","”آؤ، ہم روانہ ہو جائیں۔ مَیں تمہارے آگے آگے چلوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","یعقوب نے جواب دیا، ”میرے مالک، آپ جانتے ہیں کہ میرے بچے نازک ہیں۔ میرے پاس بھیڑبکریاں، گائےبَیل اور اُن کے دودھ پینے والے بچے بھی ہیں۔ اگر مَیں اُنہیں ایک دن کے لئے بھی حد سے زیادہ ہانکوں تو وہ مر جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","میرے مالک، مہربانی کر کے میرے آگے آگے جائیں۔ مَیں آرام سے اُسی رفتار سے آپ کے پیچھے پیچھے چلتا رہوں گا جس رفتار سے میرے مویشی اور میرے بچے چل سکیں گے۔ یوں ہم آہستہ چلتے ہوئے آپ کے پاس سعیر پہنچیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","عیسَو نے کہا، ”کیا مَیں اپنے آدمیوں میں سے کچھ آپ کے پاس چھوڑ دوں؟“ لیکن یعقوب نے کہا، ”کیا ضرورت ہے؟ سب سے اہم بات یہ ہے کہ آپ نے مجھے قبول کر لیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","اُس دن عیسَو سعیر کے لئے اور ");
INSERT INTO urdgvu_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","یعقوب سُکات کے لئے روانہ ہوا۔ وہاں اُس نے اپنے لئے مکان بنا لیا اور اپنے مویشیوں کے لئے جھونپڑیاں۔ اِس لئے اُس مقام کا نام سُکات یعنی جھونپڑیاں پڑ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","پھر یعقوب چلتے چلتے سلامتی سے سِکم شہر پہنچا۔ یوں اُس کا مسوپتامیہ سے ملکِ کنعان تک کا سفر اختتام تک پہنچ گیا۔ اُس نے اپنے خیمے شہر کے سامنے لگائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","اُس کے خیمے حمور کی اولاد کی زمین پر لگے تھے۔ اُس نے یہ زمین چاندی کے 100 سِکوں کے بدلے خرید لی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","وہاں اُس نے قربان گاہ بنائی جس کا نام اُس نے ’ایل خدائے اسرائیل‘ رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ایک دن یعقوب اور لیاہ کی بیٹی دینہ کنعانی عورتوں سے ملنے کے لئے گھر سے نکلی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","شہر میں ایک آدمی بنام سِکم رہتا تھا۔ اُس کا والد حمور اُس علاقے کا حکمران تھا اور حِوّی قوم سے تعلق رکھتا تھا۔ جب سِکم نے دینہ کو دیکھا تو اُس نے اُسے پکڑ کر اُس کی عصمت دری کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","لیکن اُس کا دل دینہ سے لگ گیا۔ وہ اُس سے محبت کرنے لگا اور پیار سے اُس سے باتیں کرتا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","اُس نے اپنے باپ سے کہا، ”اِس لڑکی کے ساتھ میری شادی کرا دیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","جب یعقوب نے اپنی بیٹی کی عصمت دری کی خبر سنی تو اُس کے بیٹے مویشیوں کے ساتھ کھلے میدان میں تھے۔ اِس لئے وہ اُن کے واپس آنے تک خاموش رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","سِکم کا باپ حمور شہر سے نکل کر یعقوب سے بات کرنے کے لئے آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","جب یعقوب کے بیٹوں کو دینہ کی عصمت دری کی خبر ملی تو اُن کے دل رنجش اور غصے سے بھر گئے کہ سِکم نے یعقوب کی بیٹی کی عصمت دری سے اسرائیل کی اِتنی بےعزتی کی ہے۔ وہ سیدھے کھلے میدان سے واپس آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","حمور نے یعقوب سے کہا، ”میرے بیٹے کا دل آپ کی بیٹی سے لگ گیا ہے۔ مہربانی کر کے اُس کی شادی میرے بیٹے کے ساتھ کر دیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ہمارے ساتھ رشتہ باندھیں، ہمارے بیٹے بیٹیوں کے ساتھ شادیاں کرائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","پھر آپ ہمارے ساتھ اِس ملک میں رہ سکیں گے اور پورا ملک آپ کے لئے کھلا ہو گا۔ آپ جہاں بھی چاہیں آباد ہو سکیں گے، تجارت کر سکیں گے اور زمین خرید سکیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","سِکم نے خود بھی دینہ کے باپ اور بھائیوں سے منت کی، ”اگر میری یہ درخواست منظور ہو تو مَیں جو کچھ آپ کہیں گے ادا کر دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","جتنا بھی مَہر اور تحفے آپ مقرر کریں مَیں دے دوں گا۔ صرف میری یہ خواہش پوری کریں کہ یہ لڑکی میرے عقد میں آ جائے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","لیکن دینہ کی عصمت دری کے سبب سے یعقوب کے بیٹوں نے سِکم اور اُس کے باپ حمور سے چالاکی کر کے ");
INSERT INTO urdgvu_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","کہا، ”ہم ایسا نہیں کر سکتے۔ ہم اپنی بہن کی شادی کسی ایسے آدمی سے نہیں کرا سکتے جس کا ختنہ نہیں ہوا۔ اِس سے ہماری بےعزتی ہوتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ہم صرف اِس شرط پر راضی ہوں گے کہ آپ اپنے تمام لڑکوں اور مردوں کا ختنہ کروانے سے ہماری مانند ہو جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","پھر آپ کے بیٹے بیٹیوں کے ساتھ ہماری شادیاں ہو سکیں گی اور ہم آپ کے ساتھ ایک قوم بن جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","لیکن اگر آپ ختنہ کرانے کے لئے تیار نہیں ہیں تو ہم اپنی بہن کو لے کر چلے جائیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","یہ باتیں حمور اور اُس کے بیٹے سِکم کو اچھی لگیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","نوجوان سِکم نے فوراً اُن پر عمل کیا، کیونکہ وہ دینہ کو بہت پسند کرتا تھا۔ سِکم اپنے خاندان میں سب سے معزز تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","حمور اپنے بیٹے سِکم کے ساتھ شہر کے دروازے پر گیا جہاں شہر کے فیصلے کئے جاتے تھے۔ وہاں اُنہوں نے باقی شہریوں سے بات کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","”یہ آدمی ہم سے جھگڑنے والے نہیں ہیں، اِس لئے کیوں نہ وہ اِس ملک میں ہمارے ساتھ رہیں اور ہمارے درمیان تجارت کریں؟ ہمارے ملک میں اُن کے لئے بھی کافی جگہ ہے۔ آؤ، ہم اُن کی بیٹیوں اور بیٹوں سے شادیاں کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","لیکن یہ آدمی صرف اِس شرط پر ہمارے درمیان رہنے اور ایک ہی قوم بننے کے لئے تیار ہیں کہ ہم اُن کی طرح اپنے تمام لڑکوں اور مردوں کا ختنہ کرائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","اگر ہم ایسا کریں تو اُن کے تمام مویشی اور سارا مال ہمارا ہی ہو گا۔ چنانچہ آؤ، ہم متفق ہو کر فیصلہ کر لیں تاکہ وہ ہمارے درمیان رہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","سِکم کے شہری حمور اور سِکم کے مشورے پر راضی ہوئے۔ تمام لڑکوں اور مردوں کا ختنہ کرایا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","تین دن کے بعد جب ختنے کے سبب سے لوگوں کی حالت بُری تھی تو دینہ کے دو بھائی شمعون اور لاوی اپنی تلواریں لے کر شہر میں داخل ہوئے۔ کسی کو شک تک نہیں تھا کہ کیا کچھ ہو گا۔ اندر جا کر اُنہوں نے بچوں سے لے کر بوڑھوں تک تمام مردوں کو قتل کر دیا ");
INSERT INTO urdgvu_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","جن میں حمور اور اُس کا بیٹا سِکم بھی شامل تھے۔ پھر وہ دینہ کو سِکم کے گھر سے لے کر چلے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","اِس قتلِ عام کے بعد یعقوب کے باقی بیٹے شہر پر ٹوٹ پڑے اور اُسے لُوٹ لیا۔ یوں اُنہوں نے اپنی بہن کی عصمت دری کا بدلہ لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","وہ بھیڑبکریاں، گائےبَیل، گدھے اور شہر کے اندر اور باہر کا سب کچھ لے کر چلتے بنے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","اُنہوں نے سارے مال پر قبضہ کیا، عورتوں اور بچوں کو قیدی بنا لیا اور تمام گھروں کا سامان بھی لے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","پھر یعقوب نے شمعون اور لاوی سے کہا، ”تم نے مجھے مصیبت میں ڈال دیا ہے۔ اب کنعانی، فرِزّی اور ملک کے باقی باشندوں میں میری بدنامی ہوئی ہے۔ میرے ساتھ کم آدمی ہیں۔ اگر دوسرے مل کر ہم پر حملہ کریں تو ہمارے پورے خاندان کا ستیاناس ہو جائے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","لیکن اُنہوں نے کہا، ”کیا یہ ٹھیک تھا کہ اُس نے ہماری بہن کے ساتھ کسبی کا سا سلوک کیا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","اللہ نے یعقوب سے کہا، ”اُٹھ، بیت ایل جا کر وہاں آباد ہو۔ وہیں اللہ کے لئے جو تجھ پر ظاہر ہوا جب تُو اپنے بھائی عیسَو سے بھاگ رہا تھا قربان گاہ بنا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","چنانچہ یعقوب نے اپنے گھر والوں اور باقی سارے ساتھیوں سے کہا، ”جو بھی اجنبی بُت آپ کے پاس ہیں اُنہیں پھینک دیں۔ اپنے آپ کو پاک صاف کر کے اپنے کپڑے بدلیں، ");
INSERT INTO urdgvu_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","کیونکہ ہمیں یہ جگہ چھوڑ کر بیت ایل جانا ہے۔ وہاں مَیں اُس خدا کے لئے قربان گاہ بناؤں گا جس نے مصیبت کے وقت میری دعا سنی۔ جہاں بھی مَیں گیا وہاں وہ میرے ساتھ رہا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","یہ سن کر اُنہوں نے یعقوب کو تمام بُت دے دیئے جو اُن کے پاس تھے اور تمام بالیاں جو اُنہوں نے تعویذ کے طور پر کانوں میں پہن رکھی تھیں۔ اُس نے سب کچھ سِکم کے قریب بلوط کے درخت کے نیچے زمین میں دبا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","پھر وہ روانہ ہوئے۔ ارد گرد کے شہروں پر اللہ کی طرف سے اِتنا شدید خوف چھا گیا کہ اُنہوں نے یعقوب اور اُس کے بیٹوں کا تعاقب نہ کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","چلتے چلتے یعقوب اپنے لوگوں سمیت لُوز پہنچ گیا جو ملکِ کنعان میں تھا۔ آج لُوز کا نام بیت ایل ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","یعقوب نے وہاں قربان گاہ بنا کر مقام کا نام بیت ایل یعنی ’اللہ کا گھر‘ رکھا۔ کیونکہ وہاں اللہ نے اپنے آپ کو اُس پر ظاہر کیا تھا جب وہ اپنے بھائی سے فرار ہو رہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","وہاں رِبقہ کی دایہ دبورہ مر گئی۔ وہ بیت ایل کے جنوب میں بلوط کے درخت کے نیچے دفن ہوئی، اِس لئے اُس کا نام الّون بکوت یعنی ’رونے کا بلوط کا درخت‘ رکھا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","اللہ یعقوب پر ایک دفعہ اَور ظاہر ہوا اور اُسے برکت دی۔ یہ مسوپتامیہ سے واپس آنے پر دوسری بار ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","اللہ نے اُس سے کہا، ”اب سے تیرا نام یعقوب نہیں بلکہ اسرائیل ہو گا۔“ یوں اُس نے اُس کا نیا نام اسرائیل رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","اللہ نے یہ بھی اُس سے کہا، ”مَیں اللہ قادرِ مطلق ہوں۔ پھل پھول اور تعداد میں بڑھتا جا۔ ایک قوم نہیں بلکہ بہت سی قومیں تجھ سے نکلیں گی۔ تیری اولاد میں بادشاہ بھی شامل ہوں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","مَیں تجھے وہی ملک دوں گا جو ابراہیم اور اسحاق کو دیا ہے۔ اور تیرے بعد اُسے تیری اولاد کو دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","پھر اللہ وہاں سے آسمان پر چلا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","جہاں اللہ یعقوب سے ہم کلام ہوا تھا وہاں اُس نے پتھر کا ستون کھڑا کیا اور اُس پر مَے اور تیل اُنڈیل کر اُسے مخصوص کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","اُس نے جگہ کا نام بیت ایل رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","پھر یعقوب اپنے گھر والوں کے ساتھ بیت ایل کو چھوڑ کر اِفراتہ کی طرف چل پڑا۔ راخل اُمید سے تھی، اور راستے میں بچے کی پیدائش کا وقت آ گیا۔ بچہ بڑی مشکل سے پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","جب دردِ زہ عروج کو پہنچ گیا تو دائی نے اُس سے کہا، ”مت ڈرو، کیونکہ ایک اَور بیٹا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","لیکن وہ دم توڑنے والی تھی، اور مرتے مرتے اُس نے اُس کا نام بن اونی یعنی ’میری مصیبت کا بیٹا‘ رکھا۔ لیکن اُس کے باپ نے اُس کا نام بن یمین یعنی ’دہنے ہاتھ یا خوش قسمتی کا بیٹا‘ رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","راخل فوت ہوئی، اور وہ اِفراتہ کے راستے میں دفن ہوئی۔ آج کل اِفراتہ کو بیت لحم کہا جاتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","یعقوب نے اُس کی قبر پر پتھر کا ستون کھڑا کیا۔ وہ آج تک راخل کی قبر کی نشان دہی کرتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","وہاں سے یعقوب نے اپنا سفر جاری رکھا اور مِجدل عِدر کی پرلی طرف اپنے خیمے لگائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","جب وہ وہاں ٹھہرے تھے تو روبن یعقوب کی حرم بِلہاہ سے ہم بستر ہوا۔ یعقوب کو معلوم ہو گیا۔ یعقوب کے بارہ بیٹے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","لیاہ کے بیٹے یہ تھے: اُس کا سب سے بڑا بیٹا روبن، پھر شمعون، لاوی، یہوداہ، اِشکار اور زبولون۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","راخل کے دو بیٹے تھے، یوسف اور بن یمین۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","راخل کی لونڈی بِلہاہ کے دو بیٹے تھے، دان اور نفتالی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","لیاہ کی لونڈی زِلفہ کے دو بیٹے تھے، جد اور آشر۔ یعقوب کے یہ بیٹے مسوپتامیہ میں پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","پھر یعقوب اپنے باپ اسحاق کے پاس پہنچ گیا جو حبرون کے قریب ممرے میں اجنبی کی حیثیت سے رہتا تھا (اُس وقت حبرون کا نام قِریَت اربع تھا)۔ وہاں اسحاق اور اُس سے پہلے ابراہیم رہا کرتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN35_28‏","002_35_28‏","GEN","35","28‏","29","اسحاق 180 سال کا تھا جب وہ عمر رسیدہ اور زندگی سے آسودہ ہو کر اپنے باپ دادا سے جا ملا۔ اُس کے بیٹے عیسَو اور یعقوب نے اُسے دفن کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","یہ عیسَو کی اولاد کا نسب نامہ ہے (عیسَو کو ادوم بھی کہا جاتا ہے): ");
INSERT INTO urdgvu_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","عیسَو نے تین کنعانی عورتوں سے شادی کی: حِتّی آدمی ایلون کی بیٹی عدہ سے، عنہ کی بیٹی اُہلی بامہ سے جو حِوّی آدمی صِبعون کی نواسی تھی ");
INSERT INTO urdgvu_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","اور اسمٰعیل کی بیٹی باسمت سے جو نبایوت کی بہن تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","عدہ کا ایک بیٹا اِلی فز اور باسمت کا ایک بیٹا رعوایل پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","اُہلی بامہ کے تین بیٹے پیدا ہوئے، یعوس، یعلام اور قورح۔ عیسَو کے یہ تمام بیٹے ملکِ کنعان میں پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","بعد میں عیسَو دوسرے ملک میں چلا گیا۔ اُس نے اپنی بیویوں، بیٹے بیٹیوں اور گھر کے رہنے والوں کو اپنے تمام مویشیوں اور ملکِ کنعان میں حاصل کئے ہوئے مال سمیت اپنے ساتھ لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","وہ اِس وجہ سے چلا گیا کہ دونوں بھائیوں کے پاس اِتنے ریوڑ تھے کہ چَرانے کی جگہ کم پڑ گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","چنانچہ عیسَو پہاڑی علاقے سعیر میں آباد ہوا۔ عیسَو کا دوسرا نام ادوم ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","یہ عیسَو یعنی سعیر کے پہاڑی علاقے میں آباد ادومیوں کا نسب نامہ ہے: ");
INSERT INTO urdgvu_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","عیسَو کی بیوی عدہ کا ایک بیٹا اِلی فز تھا جبکہ اُس کی بیوی باسمت کا ایک بیٹا رعوایل تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","اِلی فز کے بیٹے تیمان، اومر، صفو، جعتام، قنز ");
INSERT INTO urdgvu_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","اور عمالیق تھے۔ عمالیق اِلی فز کی حرم تِمنع کا بیٹا تھا۔ یہ سب عیسَو کی بیوی عدہ کی اولاد میں شامل تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","رعوایل کے بیٹے نحت، زارح، سمّہ اور مِزّہ تھے۔ یہ سب عیسَو کی بیوی باسمت کی اولاد میں شامل تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","عیسَو کی بیوی اُہلی بامہ جو عنہ کی بیٹی اور صِبعون کی نواسی تھی کے تین بیٹے یعوس، یعلام اور قورح تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","عیسَو سے مختلف قبیلوں کے سردار نکلے۔ اُس کے پہلوٹھے اِلی فز سے یہ قبائلی سردار نکلے: تیمان، اومر، صفو، قنز، ");
INSERT INTO urdgvu_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","قورح، جعتام اور عمالیق۔ یہ سب عیسَو کی بیوی عدہ کی اولاد تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","عیسَو کے بیٹے رعوایل سے یہ قبائلی سردار نکلے: نحت، زارح، سمّہ اور مِزّہ۔ یہ سب عیسَو کی بیوی باسمت کی اولاد تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","عیسَو کی بیوی اُہلی بامہ یعنی عنہ کی بیٹی سے یہ قبائلی سردار نکلے: یعوس، یعلام اور قورح۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","یہ تمام سردار عیسَو کی اولاد ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ملکِ ادوم کے کچھ باشندے حوری آدمی سعیر کی اولاد تھے۔ اُن کے نام لوطان، سوبل، صِبعون، عنہ، ");
INSERT INTO urdgvu_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","دیسون، ایصر اور دیسان تھے۔ سعیر کے یہ بیٹے ملکِ ادوم میں حوری قبیلوں کے سردار تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","لوطان حوری اور ہیمام کا باپ تھا۔ (تِمنع لوطان کی بہن تھی۔) ");
INSERT INTO urdgvu_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","سوبل کے بیٹے علوان، مانحت، عیبال، سفو اور اونام تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","صِبعون کے بیٹے ایّاہ اور عنہ تھے۔ اِسی عنہ کو گرم چشمے ملے جب وہ بیابان میں اپنے باپ کے گدھے چَرا رہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","عنہ کا ایک بیٹا دیسون اور ایک بیٹی اُہلی بامہ تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","دیسون کے چار بیٹے حمدان، اِشبان، یِتران اور کِران تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ایصر کے تین بیٹے بِلہان، زعوان اور عقان تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","دیسان کے دو بیٹے عُوض اور اران تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_29‏","002_36_29‏","GEN","36","29‏","30","یہی یعنی لوطان، سوبل، صِبعون، عنہ، دیسون، ایصر اور دیسان سعیر کے ملک میں حوری قبائل کے سردار تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","اِس سے پہلے کہ اسرائیلیوں کا کوئی بادشاہ تھا ذیل کے بادشاہ یکے بعد دیگرے ملکِ ادوم میں حکومت کرتے تھے: ");
INSERT INTO urdgvu_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","بالع بن بعور جو دنہابا شہر کا تھا ملکِ ادوم کا پہلا بادشاہ تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","اُس کی موت پر یوباب بن زارح جو بُصرہ شہر کا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","اُس کی موت پر حُشام جو تیمانیوں کے ملک کا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","اُس کی موت پر ہدد بن بِدد جس نے ملکِ موآب میں مِدیانیوں کو شکست دی۔ وہ عویت کا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","اُس کی موت پر سملہ جو مسرِقہ کا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","اُس کی موت پر ساؤل جو دریائے فرات پر رحوبوت شہر کا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","اُس کی موت پر بعل حنان بن عکبور۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","اُس کی موت پر ہدد جو فاعُو شہر کا تھا (بیوی کا نام مہیطب ایل بنت مطرِد بنت میزاہاب تھا)۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN36_40‏","002_36_40‏","GEN","36","40‏","43","عیسَو سے ادومی قبیلوں کے یہ سردار نکلے: تِمنع، علوَہ، یتیت، اُہلی بامہ، ایلہ، فینون، قنز، تیمان، مِبصار، مجدی ایل اور عِرام۔ ادوم کے سرداروں کی یہ فہرست اُن کی موروثی زمین کی آبادیوں اور قبیلوں کے مطابق ہی بیان کی گئی ہے۔ عیسَو اُن کا باپ ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","یعقوب ملکِ کنعان میں رہتا تھا جہاں پہلے اُس کا باپ بھی پردیسی تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","یہ یعقوب کے خاندان کا بیان ہے۔ اُس وقت یعقوب کا بیٹا یوسف 17 سال کا تھا۔ وہ اپنے بھائیوں یعنی بِلہاہ اور زِلفہ کے بیٹوں کے ساتھ بھیڑبکریوں کی دیکھ بھال کرتا تھا۔ یوسف اپنے باپ کو اپنے بھائیوں کی بُری حرکتوں کی اطلاع دیا کرتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","یعقوب یوسف کو اپنے تمام بیٹوں کی نسبت زیادہ پیار کرتا تھا۔ وجہ یہ تھی کہ وہ تب پیدا ہوا جب باپ بوڑھا تھا۔ اِس لئے یعقوب نے اُس کے لئے ایک خاص رنگ دار لباس بنوایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","جب اُس کے بھائیوں نے دیکھا کہ ہمارا باپ یوسف کو ہم سے زیادہ پیار کرتا ہے تو وہ اُس سے نفرت کرنے لگے اور ادب سے اُس سے بات نہیں کرتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ایک رات یوسف نے خواب دیکھا۔ جب اُس نے اپنے بھائیوں کو خواب سنایا تو وہ اُس سے اَور بھی نفرت کرنے لگے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","اُس نے کہا، ”سنو، مَیں نے خواب دیکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ہم سب کھیت میں پُولے باندھ رہے تھے کہ میرا پُولا کھڑا ہو گیا۔ آپ کے پُولے میرے پُولے کے ارد گرد جمع ہو کر اُس کے سامنے جھک گئے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","اُس کے بھائیوں نے کہا، ”اچھا، تُو بادشاہ بن کر ہم پر حکومت کرے گا؟“ اُس کے خوابوں اور اُس کی باتوں کے سبب سے اُن کی اُس سے نفرت مزید بڑھ گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","کچھ دیر کے بعد یوسف نے ایک اَور خواب دیکھا۔ اُس نے اپنے بھائیوں سے کہا، ”مَیں نے ایک اَور خواب دیکھا ہے۔ اُس میں سورج، چاند اور گیارہ ستارے میرے سامنے جھک گئے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","اُس نے یہ خواب اپنے باپ کو بھی سنایا تو اُس نے اُسے ڈانٹا۔ اُس نے کہا، ”یہ کیسا خواب ہے جو تُو نے دیکھا! یہ کیسی بات ہے کہ مَیں، تیری ماں اور تیرے بھائی آ کر تیرے سامنے زمین تک جھک جائیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","نتیجے میں اُس کے بھائی اُس سے بہت حسد کرنے لگے۔ لیکن اُس کے باپ نے دل میں یہ بات محفوظ رکھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ایک دن جب یوسف کے بھائی اپنے باپ کے ریوڑ چَرانے کے لئے سِکم تک پہنچ گئے تھے ");
INSERT INTO urdgvu_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","تو یعقوب نے یوسف سے کہا، ”تیرے بھائی سِکم میں ریوڑوں کو چَرا رہے ہیں۔ آ، مَیں تجھے اُن کے پاس بھیج دیتا ہوں۔“ یوسف نے جواب دیا، ”ٹھیک ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","یعقوب نے کہا، ”جا کر معلوم کر کہ تیرے بھائی اور اُن کے ساتھ کے ریوڑ خیریت سے ہیں کہ نہیں۔ پھر واپس آ کر مجھے بتا دینا۔“ چنانچہ اُس کے باپ نے اُسے وادیٔ حبرون سے بھیج دیا، اور یوسف سِکم پہنچ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","وہاں وہ اِدھر اُدھر پھرتا رہا۔ آخرکار ایک آدمی اُس سے ملا اور پوچھا، ”آپ کیا ڈھونڈ رہے ہیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","یوسف نے جواب دیا، ”مَیں اپنے بھائیوں کو تلاش کر رہا ہوں۔ مجھے بتائیں کہ وہ اپنے جانوروں کو کہاں چَرا رہے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","آدمی نے کہا، ”وہ یہاں سے چلے گئے ہیں۔ مَیں نے اُنہیں یہ کہتے سنا کہ آؤ، ہم دوتین جائیں۔“ یہ سن کر یوسف اپنے بھائیوں کے پیچھے دوتین چلا گیا۔ وہاں اُسے وہ مل گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","جب یوسف ابھی دُور سے نظر آیا تو اُس کے بھائیوں نے اُس کے پہنچنے سے پہلے اُسے قتل کرنے کا منصوبہ بنایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","اُنہوں نے کہا، ”دیکھو، خواب دیکھنے والا آ رہا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","آؤ، ہم اُسے مار ڈالیں اور اُس کی لاش کسی گڑھے میں پھینک دیں۔ ہم کہیں گے کہ کسی وحشی جانور نے اُسے پھاڑ کھایا ہے۔ پھر پتا چلے گا کہ اُس کے خوابوں کی کیا حقیقت ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","جب روبن نے اُن کی باتیں سنیں تو اُس نے یوسف کو بچانے کی کوشش کی۔ اُس نے کہا، ”نہیں، ہم اُسے قتل نہ کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","اُس کا خون نہ کرنا۔ بےشک اُسے اِس گڑھے میں پھینک دیں جو ریگستان میں ہے، لیکن اُسے ہاتھ نہ لگائیں۔“ اُس نے یہ اِس لئے کہا کہ وہ اُسے بچا کر باپ کے پاس واپس پہنچانا چاہتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","جوں ہی یوسف اپنے بھائیوں کے پاس پہنچا اُنہوں نے اُس کا رنگ دار لباس اُتار کر ");
INSERT INTO urdgvu_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","یوسف کو گڑھے میں پھینک دیا۔ گڑھا خالی تھا، اُس میں پانی نہیں تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","پھر وہ روٹی کھانے کے لئے بیٹھ گئے۔ اچانک اسمٰعیلیوں کا ایک قافلہ نظر آیا۔ وہ جِلعاد سے مصر جا رہے تھے، اور اُن کے اونٹ قیمتی مسالوں یعنی لادن، بلسان اور مُر سے لدے ہوئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","تب یہوداہ نے اپنے بھائیوں سے کہا، ”ہمیں کیا فائدہ ہے اگر اپنے بھائی کو قتل کر کے اُس کے خون کو چھپا دیں؟ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","آؤ، ہم اُسے اِن اسمٰعیلیوں کے ہاتھ فروخت کر دیں۔ پھر کوئی ضرورت نہیں ہو گی کہ ہم اُسے ہاتھ لگائیں۔ آخر وہ ہمارا بھائی ہے۔“ اُس کے بھائی راضی ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","چنانچہ جب مِدیانی تاجر وہاں سے گزرے تو بھائیوں نے یوسف کو کھینچ کر گڑھے سے نکالا اور چاندی کے 20 سِکوں کے عوض بیچ ڈالا۔ اسمٰعیلی اُسے لے کر مصر چلے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","اُس وقت روبن موجود نہیں تھا۔ جب وہ گڑھے کے پاس واپس آیا تو یوسف اُس میں نہیں تھا۔ یہ دیکھ کر اُس نے پریشانی میں اپنے کپڑے پھاڑ ڈالے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","وہ اپنے بھائیوں کے پاس واپس گیا اور کہا، ”لڑکا نہیں ہے۔ اب مَیں کس طرح ابو کے پاس جاؤں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","تب اُنہوں نے بکرا ذبح کر کے یوسف کا لباس اُس کے خون میں ڈبویا، ");
INSERT INTO urdgvu_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","پھر رنگ دار لباس اِس خبر کے ساتھ اپنے باپ کو بھجوا دیاکہ ”ہمیں یہ ملا ہے۔ اِسے غور سے دیکھیں۔ یہ آپ کے بیٹے کا لباس تو نہیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","یعقوب نے اُسے پہچان لیا اور کہا، ”بےشک اُسی کا ہے۔ کسی وحشی جانور نے اُسے پھاڑ کھایا ہے۔ یقیناً یوسف کو پھاڑ دیا گیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","یعقوب نے غم کے مارے اپنے کپڑے پھاڑے اور اپنی کمر سے ٹاٹ اوڑھ کر بڑی دیر تک اپنے بیٹے کے لئے ماتم کرتا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","اُس کے تمام بیٹے بیٹیاں اُسے تسلی دینے آئے، لیکن اُس نے تسلی پانے سے انکار کیا اور کہا، ”مَیں پاتال میں اُترتے ہوئے بھی اپنے بیٹے کے لئے ماتم کروں گا۔“ اِس حالت میں وہ اپنے بیٹے کے لئے روتا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","اِتنے میں مِدیانی مصر پہنچ کر یوسف کو بیچ چکے تھے۔ مصر کے بادشاہ فرعون کے ایک اعلیٰ افسر فوطی فار نے اُسے خرید لیا۔ فوطی فار بادشاہ کے محافظوں پر مقرر تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","اُن دنوں میں یہوداہ اپنے بھائیوں کو چھوڑ کر ایک آدمی کے پاس رہنے لگا جس کا نام حیرہ تھا اور جو عدُلام شہر سے تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","وہاں یہوداہ کی ملاقات ایک کنعانی عورت سے ہوئی جس کے باپ کا نام سوع تھا۔ اُس نے اُس سے شادی کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","بیٹا پیدا ہوا جس کا نام یہوداہ نے عیر رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ایک اَور بیٹا پیدا ہوا جس کا نام بیوی نے اونان رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","اُس کے تیسرا بیٹا بھی پیدا ہوا۔ اُس نے اُس کا نام سیلہ رکھا۔ یہوداہ کزیب میں تھا جب وہ پیدا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","یہوداہ نے اپنے بڑے بیٹے عیر کی شادی ایک لڑکی سے کرائی جس کا نام تمر تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","رب کے نزدیک عیر شریر تھا، اِس لئے اُس نے اُسے ہلاک کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","اِس پر یہوداہ نے عیر کے چھوٹے بھائی اونان سے کہا، ”اپنے بڑے بھائی کی بیوہ کے پاس جاؤ اور اُس سے شادی کرو تاکہ تمہارے بھائی کی نسل قائم رہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","اونان نے ایسا کیا، لیکن وہ جانتا تھا کہ جو بھی بچے پیدا ہوں گے وہ قانون کے مطابق میرے بڑے بھائی کے ہوں گے۔ اِس لئے جب بھی وہ تمر سے ہم بستر ہوتا تو نطفہ کو زمین پر گرا دیتا، کیونکہ وہ نہیں چاہتا تھا کہ میری معرفت میرے بھائی کے بچے پیدا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","یہ بات رب کو بُری لگی، اور اُس نے اُسے بھی سزائے موت دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","تب یہوداہ نے اپنی بہو تمر سے کہا، ”اپنے باپ کے گھر واپس چلی جاؤ اور اُس وقت تک بیوہ رہو جب تک میرا بیٹا سیلہ بڑا نہ ہو جائے۔“ اُس نے یہ اِس لئے کہا کہ اُسے ڈر تھا کہ کہیں سیلہ بھی اپنے بھائیوں کی طرح مر نہ جائے۔ چنانچہ تمر اپنے میکے چلی گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","کافی دنوں کے بعد یہوداہ کی بیوی جو سوع کی بیٹی تھی مر گئی۔ ماتم کا وقت گزر گیا تو یہوداہ اپنے عدُلامی دوست حیرہ کے ساتھ تِمنت گیا جہاں یہوداہ کی بھیڑوں کی پشم کتری جا رہی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","تمر کو بتایا گیا، ”آپ کا سُسر اپنی بھیڑوں کی پشم کترنے کے لئے تِمنت جا رہا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","یہ سن کر تمر نے بیوہ کے کپڑے اُتار کر عام کپڑے پہن لئے۔ پھر وہ اپنا منہ چادر سے لپیٹ کر عینیم شہر کے دروازے پر بیٹھ گئی جو تِمنت کے راستے میں تھا۔ تمر نے یہ حرکت اِس لئے کی کہ یہوداہ کا بیٹا سیلہ اب بالغ ہو چکا تھا توبھی اُس کی اُس کے ساتھ شادی نہیں کی گئی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","جب یہوداہ وہاں سے گزرا تو اُس نے اُسے دیکھ کر سوچا کہ یہ کسبی ہے، کیونکہ اُس نے اپنا منہ چھپایا ہوا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","وہ راستے سے ہٹ کر اُس کے پاس گیا اور کہا، ”ذرا مجھے اپنے ہاں آنے دیں۔“ (اُس نے نہیں پہچانا کہ یہ میری بہو ہے)۔ تمر نے کہا، ”آپ مجھے کیا دیں گے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","اُس نے جواب دیا، ”مَیں آپ کو بکری کا بچہ بھیج دوں گا۔“ تمر نے کہا، ”ٹھیک ہے، لیکن اُسے بھیجنے تک مجھے ضمانت دیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","اُس نے پوچھا، ”مَیں آپ کو کیا دوں؟“ تمر نے کہا، ”اپنی مُہر اور اُسے گلے میں لٹکانے کی ڈوری۔ وہ لاٹھی بھی دیں جو آپ پکڑے ہوئے ہیں۔“ چنانچہ یہوداہ اُسے یہ چیزیں دے کر اُس کے ساتھ ہم بستر ہوا۔ نتیجے میں تمر اُمید سے ہوئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","پھر تمر اُٹھ کر اپنے گھر واپس چلی گئی۔ اُس نے اپنی چادر اُتار کر دوبارہ بیوہ کے کپڑے پہن لئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","یہوداہ نے اپنے دوست حیرہ عدُلامی کے ہاتھ بکری کا بچہ بھیج دیا تاکہ وہ چیزیں واپس مل جائیں جو اُس نے ضمانت کے طور پر دی تھیں۔ لیکن حیرہ کو پتا نہ چلا کہ عورت کہاں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","اُس نے عینیم کے باشندوں سے پوچھا، ”وہ کسبی کہاں ہے جو یہاں سڑک پر بیٹھی تھی؟“ اُنہوں نے جواب دیا، ”یہاں ایسی کوئی کسبی نہیں تھی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","اُس نے یہوداہ کے پاس واپس جا کر کہا، ”وہ مجھے نہیں ملی بلکہ وہاں کے رہنے والوں نے کہا کہ یہاں کوئی ایسی کسبی تھی نہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","یہوداہ نے کہا، ”پھر وہ ضمانت کی چیزیں اپنے پاس ہی رکھے۔ اُسے چھوڑ دو ورنہ لوگ ہمارا مذاق اُڑائیں گے۔ ہم نے تو پوری کوشش کی کہ اُسے بکری کا بچہ مل جائے، لیکن کھوج لگانے کے باوجود آپ کو پتا نہ چلا کہ وہ کہاں ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","تین ماہ کے بعد یہوداہ کو اطلاع دی گئی، ”آپ کی بہو تمر نے زنا کیا ہے، اور اب وہ حاملہ ہے۔“ یہوداہ نے حکم دیا، ”اُسے باہر لا کر جلا دو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","تمر کو جلانے کے لئے باہر لایا گیا تو اُس نے اپنے سُسر کو خبر بھیج دی، ”یہ چیزیں دیکھیں۔ یہ اُس آدمی کی ہیں جس کی معرفت مَیں اُمید سے ہوں۔ پتا کریں کہ یہ مُہر، اُس کی ڈوری اور یہ لاٹھی کس کی ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","یہوداہ نے اُنہیں پہچان لیا۔ اُس نے کہا، ”مَیں نہیں بلکہ یہ عورت حق پر ہے، کیونکہ مَیں نے اُس کی اپنے بیٹے سیلہ سے شادی نہیں کرائی۔“ لیکن بعد میں یہوداہ کبھی بھی تمر سے ہم بستر نہ ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","جب جنم دینے کا وقت آیا تو معلوم ہوا کہ جُڑواں بچے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ایک بچے کا ہاتھ نکلا تو دائی نے اُسے پکڑ کر اُس میں سرخ دھاگا باندھ دیا اور کہا، ”یہ پہلے پیدا ہوا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","لیکن اُس نے اپنا ہاتھ واپس کھینچ لیا، اور اُس کا بھائی پہلے پیدا ہوا۔ یہ دیکھ کر دائی بول اُٹھی، ”تُو کس طرح پھوٹ نکلا ہے!“ اُس نے اُس کا نام فارص یعنی پھوٹ رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","پھر اُس کا بھائی پیدا ہوا جس کے ہاتھ میں سرخ دھاگا بندھا ہوا تھا۔ اُس کا نام زارح یعنی چمک رکھا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","اسمٰعیلیوں نے یوسف کو مصر لے جا کر بیچ دیا تھا۔ مصر کے بادشاہ کے ایک اعلیٰ افسر بنام فوطی فار نے اُسے خرید لیا۔ وہ شاہی محافظوں کا کپتان تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","رب یوسف کے ساتھ تھا۔ جو بھی کام وہ کرتا اُس میں کامیاب رہتا۔ وہ اپنے مصری مالک کے گھر میں رہتا تھا ");
INSERT INTO urdgvu_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","جس نے دیکھا کہ رب یوسف کے ساتھ ہے اور اُسے ہر کام میں کامیابی دیتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","چنانچہ یوسف کو مالک کی خاص مہربانی حاصل ہوئی، اور فوطی فار نے اُسے اپنا ذاتی نوکر بنا لیا۔ اُس نے اُسے اپنے گھرانے کے انتظام پر مقرر کیا اور اپنی پوری ملکیت اُس کے سپرد کر دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","جس وقت سے فوطی فار نے اپنے گھرانے کا انتظام اور پوری ملکیت یوسف کے سپرد کی اُس وقت سے رب نے فوطی فار کو یوسف کے سبب سے برکت دی۔ اُس کی برکت فوطی فار کی ہر چیز پر تھی، خواہ گھر میں تھی یا کھیت میں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","فوطی فار نے اپنی ہر چیز یوسف کے ہاتھ میں چھوڑ دی۔ اور چونکہ یوسف سب کچھ اچھی طرح چلاتا تھا اِس لئے فوطی فار کو کھانا کھانے کے سوا کسی بھی معاملے کی فکر نہیں تھی۔ یوسف نہایت خوب صورت آدمی تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","کچھ دیر کے بعد اُس کے مالک کی بیوی کی آنکھ اُس پر لگی۔ اُس نے اُس سے کہا، ”میرے ساتھ ہم بستر ہو!“ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","یوسف انکار کر کے کہنے لگا، ”میرے مالک کو میرے سبب سے کسی معاملے کی فکر نہیں ہے۔ اُنہوں نے سب کچھ میرے سپرد کر دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","گھر کے انتظام پر اُن کا اختیار میرے اختیار سے زیادہ نہیں ہے۔ آپ کے سوا اُنہوں نے کوئی بھی چیز مجھ سے باز نہیں رکھی۔ تو پھر مَیں کس طرح اِتنا غلط کام کروں؟ مَیں کس طرح اللہ کا گناہ کروں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","مالک کی بیوی روز بہ روز یوسف کے پیچھے پڑی رہی کہ میرے ساتھ ہم بستر ہو۔ لیکن وہ ہمیشہ انکار کرتا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ایک دن وہ کام کرنے کے لئے گھر میں گیا۔ گھر میں اَور کوئی نوکر نہیں تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","فوطی فار کی بیوی نے یوسف کا لباس پکڑ کر کہا، ”میرے ساتھ ہم بستر ہو!“ یوسف بھاگ کر باہر چلا گیا لیکن اُس کا لباس پیچھے عورت کے ہاتھ میں ہی رہ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","جب مالک کی بیوی نے دیکھا کہ وہ اپنا لباس چھوڑ کر بھاگ گیا ہے ");
INSERT INTO urdgvu_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","تو اُس نے گھر کے نوکروں کو بُلا کر کہا، ”یہ دیکھو! میرے مالک اِس عبرانی کو ہمارے پاس لے آئے ہیں تاکہ وہ ہمیں ذلیل کرے۔ وہ میری عصمت دری کرنے کے لئے میرے کمرے میں آ گیا، لیکن مَیں اونچی آواز سے چیخنے لگی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","جب مَیں مدد کے لئے اونچی آواز سے چیخنے لگی تو وہ اپنا لباس چھوڑ کر بھاگ گیا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","اُس نے مالک کے آنے تک یوسف کا لباس اپنے پاس رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","جب وہ گھر واپس آیا تو اُس نے اُسے یہی کہانی سنائی، ”یہ عبرانی غلام جو آپ لے آئے ہیں میری تذلیل کے لئے میرے پاس آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","لیکن جب مَیں مدد کے لئے چیخنے لگی تو وہ اپنا لباس چھوڑ کر بھاگ گیا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","یہ سن کر فوطی فار بڑے غصے میں آ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","اُس نے یوسف کو گرفتار کر کے اُس جیل میں ڈال دیا جہاں بادشاہ کے قیدی رکھے جاتے تھے۔ وہیں وہ رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","لیکن رب یوسف کے ساتھ تھا۔ اُس نے اُس پر مہربانی کی اور اُسے قیدخانے کے داروغے کی نظر میں مقبول کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","یوسف یہاں تک مقبول ہوا کہ داروغے نے تمام قیدیوں کو اُس کے سپرد کر کے اُسے پورا انتظام چلانے کی ذمہ داری دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","داروغے کو کسی بھی معاملے کی جسے اُس نے یوسف کے سپرد کیا تھا فکر نہ رہی، کیونکہ رب یوسف کے ساتھ تھا اور اُسے ہر کام میں کامیابی بخشی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","کچھ دیر کے بعد یوں ہوا کہ مصر کے بادشاہ کے سردار ساقی اور بیکری کے انچارج نے اپنے مالک کا گناہ کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","فرعون کو دونوں افسروں پر غصہ آ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","اُس نے اُنہیں اُس قیدخانے میں ڈال دیا جو شاہی محافظوں کے کپتان کے سپرد تھا اور جس میں یوسف تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","محافظوں کے کپتان نے اُنہیں یوسف کے حوالے کیا تاکہ وہ اُن کی خدمت کرے۔ وہاں وہ کافی دیر تک رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ایک رات بادشاہ کے سردار ساقی اور بیکری کے انچارج نے خواب دیکھا۔ دونوں کا خواب فرق فرق تھا، اور اُن کا مطلب بھی فرق فرق تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","جب یوسف صبح کے وقت اُن کے پاس آیا تو وہ دبے ہوئے نظر آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","اُس نے اُن سے پوچھا، ”آج آپ کیوں اِتنے پریشان ہیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","اُنہوں نے جواب دیا، ”ہم دونوں نے خواب دیکھا ہے، اور کوئی نہیں جو ہمیں اُن کا مطلب بتائے۔“ یوسف نے کہا، ”خوابوں کی تعبیر تو اللہ کا کام ہے۔ ذرا مجھے اپنے خواب تو سنائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","سردار ساقی نے شروع کیا، ”مَیں نے خواب میں اپنے سامنے انگور کی بیل دیکھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","اُس کی تین شاخیں تھیں۔ اُس کے پتے لگے، کونپلیں پھوٹ نکلیں اور انگور پک گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","میرے ہاتھ میں بادشاہ کا پیالہ تھا، اور مَیں نے انگوروں کو توڑ کر یوں بھینچ دیا کہ اُن کا رس بادشاہ کے پیالے میں آ گیا۔ پھر مَیں نے پیالہ بادشاہ کو پیش کیا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","یوسف نے کہا، ”تین شاخوں سے مراد تین دن ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","تین دن کے بعد فرعون آپ کو بحال کر لے گا۔ آپ کو پہلی ذمہ داری واپس مل جائے گی۔ آپ پہلے کی طرح سردار ساقی کی حیثیت سے بادشاہ کا پیالہ سنبھالیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","لیکن جب آپ بحال ہو جائیں تو میرا خیال کریں۔ مہربانی کر کے بادشاہ کے سامنے میرا ذکر کریں تاکہ مَیں یہاں سے رِہا ہو جاؤں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","کیونکہ مجھے عبرانیوں کے ملک سے اغوا کر کے یہاں لایا گیا ہے، اور یہاں بھی مجھ سے کوئی ایسی غلطی نہیں ہوئی کہ مجھے اِس گڑھے میں پھینکا جاتا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","جب شاہی بیکری کے انچارج نے دیکھا کہ سردار ساقی کے خواب کا اچھا مطلب نکلا تو اُس نے یوسف سے کہا، ”میرا خواب بھی سنیں۔ مَیں نے سر پر تین ٹوکریاں اُٹھا رکھی تھیں جو بیکری کی چیزوں سے بھری ہوئی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","سب سے اوپر والی ٹوکری میں وہ تمام چیزیں تھیں جو بادشاہ کی میز کے لئے بنائی جاتی ہیں۔ لیکن پرندے آ کر اُنہیں کھا رہے تھے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","یوسف نے کہا، ”تین ٹوکریوں سے مراد تین دن ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","تین دن کے بعد ہی فرعون آپ کو قیدخانے سے نکال کر درخت سے لٹکا دے گا۔ پرندے آپ کی لاش کو کھا جائیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","تین دن کے بعد بادشاہ کی سال گرہ تھی۔ اُس نے اپنے تمام افسروں کی ضیافت کی۔ اِس موقع پر اُس نے سردار ساقی اور بیکری کے انچارج کو جیل سے نکال کر اپنے حضور لانے کا حکم دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","سردار ساقی کو پہلے والی ذمہ داری سونپ دی گئی، ");
INSERT INTO urdgvu_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","لیکن بیکری کے انچارج کو سزائے موت دے کر درخت سے لٹکا دیا گیا۔ سب کچھ ویسا ہی ہوا جیسا یوسف نے کہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","لیکن سردار ساقی نے یوسف کا خیال نہ کیا بلکہ اُسے بھول ہی گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","دو سال گزر گئے کہ ایک رات بادشاہ نے خواب دیکھا۔ وہ دریائے نیل کے کنارے کھڑا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","اچانک دریا میں سے سات خوب صورت اور موٹی گائیں نکل کر سرکنڈوں میں چرنے لگیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","اُن کے بعد سات اَور گائیں نکل آئیں۔ لیکن وہ بدصورت اور دُبلی پتلی تھیں۔ وہ دریا کے کنارے دوسری گائیوں کے پاس کھڑی ہو کر ");
INSERT INTO urdgvu_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","پہلی سات خوب صورت اور موٹی موٹی گائیوں کو کھا گئیں۔ اِس کے بعد مصر کا بادشاہ جاگ اُٹھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","پھر وہ دوبارہ سو گیا۔ اِس دفعہ اُس نے ایک اَور خواب دیکھا۔ اناج کے ایک پودے پر سات موٹی موٹی اور اچھی اچھی بالیں لگی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","پھر سات اَور بالیں پھوٹ نکلیں جو دُبلی پتلی اور مشرقی ہَوا سے جُھلسی ہوئی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","اناج کی سات دُبلی پتلی بالوں نے سات موٹی اور خوب صورت بالوں کو نگل لیا۔ پھر فرعون جاگ اُٹھا تو معلوم ہوا کہ مَیں نے خواب ہی دیکھا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","صبح ہوئی تو وہ پریشان تھا، اِس لئے اُس نے مصر کے تمام جادوگروں اور عالِموں کو بُلایا۔ اُس نے اُنہیں اپنے خواب سنائے، لیکن کوئی بھی اُن کی تعبیر نہ کر سکا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","پھر سردار ساقی نے فرعون سے کہا، ”آج مجھے اپنی خطائیں یاد آتی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ایک دن فرعون اپنے خادموں سے ناراض ہوئے۔ حضور نے مجھے اور بیکری کے انچارج کو قیدخانے میں ڈلوا دیا جس پر شاہی محافظوں کا کپتان مقرر تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ایک ہی رات میں ہم دونوں نے مختلف خواب دیکھے جن کا مطلب فرق فرق تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","وہاں جیل میں ایک عبرانی نوجوان تھا۔ وہ محافظوں کے کپتان کا غلام تھا۔ ہم نے اُسے اپنے خواب سنائے تو اُس نے ہمیں اُن کا مطلب بتا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","اور جو کچھ بھی اُس نے بتایا سب کچھ ویسا ہی ہوا۔ مجھے اپنی ذمہ داری واپس مل گئی جبکہ بیکری کے انچارج کو سزائے موت دے کر درخت سے لٹکا دیا گیا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","یہ سن کر فرعون نے یوسف کو بُلایا، اور اُسے جلدی سے قیدخانے سے لایا گیا۔ اُس نے شیو کروا کر اپنے کپڑے بدلے اور سیدھے بادشاہ کے حضور پہنچا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","بادشاہ نے کہا، ”مَیں نے خواب دیکھا ہے، اور یہاں کوئی نہیں جو اُس کی تعبیر کر سکے۔ لیکن سنا ہے کہ تُو خواب کو سن کر اُس کا مطلب بتا سکتا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","یوسف نے جواب دیا، ”یہ میرے اختیار میں نہیں ہے۔ لیکن اللہ ہی بادشاہ کو سلامتی کا پیغام دے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","فرعون نے یوسف کو اپنے خواب سنائے، ”مَیں خواب میں دریائے نیل کے کنارے کھڑا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","اچانک دریا میں سے سات موٹی موٹی اور خوب صورت گائیں نکل کر سرکنڈوں میں چرنے لگیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","اِس کے بعد سات اَور گائیں نکلیں۔ وہ نہایت بدصورت اور دُبلی پتلی تھیں۔ مَیں نے اِتنی بدصورت گائیں مصر میں کہیں بھی نہیں دیکھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","دُبلی اور بدصورت گائیں پہلی موٹی گائیوں کو کھا گئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","اور نگلنے کے بعد بھی معلوم نہیں ہوتا تھا کہ اُنہوں نے موٹی گائیوں کو کھایا ہے۔ وہ پہلے کی طرح بدصورت ہی تھیں۔ اِس کے بعد مَیں جاگ اُٹھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","پھر مَیں نے ایک اَور خواب دیکھا۔ سات موٹی اور اچھی بالیں ایک ہی پودے پر لگی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","اِس کے بعد سات اَور بالیں نکلیں جو خراب، دُبلی پتلی اور مشرقی ہَوا سے جُھلسی ہوئی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","سات دُبلی پتلی بالیں سات اچھی بالوں کو نگل گئیں۔ مَیں نے یہ سب کچھ اپنے جادوگروں کو بتایا، لیکن وہ اِس کی تعبیر نہ کر سکے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","یوسف نے بادشاہ سے کہا، ”دونوں خوابوں کا ایک ہی مطلب ہے۔ اِن سے اللہ نے حضور پر ظاہر کیا ہے کہ وہ کیا کچھ کرنے کو ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","سات اچھی گائیوں سے مراد سات سال ہیں۔ اِسی طرح سات اچھی بالوں سے مراد بھی سات سال ہیں۔ دونوں خواب ایک ہی بات بیان کرتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","جو سات دُبلی اور بدصورت گائیں بعد میں نکلیں اُن سے مراد سات اَور سال ہیں۔ یہی سات دُبلی پتلی اور مشرقی ہَوا سے جُھلسی ہوئی بالوں کا مطلب بھی ہے۔ وہ ایک ہی بات بیان کرتی ہیں کہ سات سال تک کال پڑے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","یہ وہی بات ہے جو مَیں نے حضور سے کہی کہ اللہ نے حضور پر ظاہر کیا ہے کہ وہ کیا کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","سات سال آئیں گے جن کے دوران مصر کے پورے ملک میں کثرت سے پیداوار ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","اُس کے بعد سات سال کال پڑے گا۔ کال اِتنا شدید ہو گا کہ لوگ بھول جائیں گے کہ پہلے اِتنی کثرت تھی۔ کیونکہ کال ملک کو تباہ کر دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","کال کی شدت کے باعث اچھے سالوں کی کثرت یاد ہی نہیں رہے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","حضور کو اِس لئے ایک ہی پیغام دو مختلف خوابوں کی صورت میں ملا کہ اللہ اِس کا پکا ارادہ رکھتا ہے، اور وہ جلد ہی اِس پر عمل کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","اب بادشاہ کسی سمجھ دار اور دانش مند آدمی کو ملکِ مصر کا انتظام سونپیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","اِس کے علاوہ وہ ایسے آدمی مقرر کریں جو سات اچھے سالوں کے دوران ہر فصل کا پانچواں حصہ لیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","وہ اُن اچھے سالوں کے دوران خوراک جمع کریں۔ بادشاہ اُنہیں اختیار دیں کہ وہ شہروں میں گودام بنا کر اناج کو محفوظ کر لیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","یہ خوراک کال کے اُن سات سالوں کے لئے مخصوص کی جائے جو مصر میں آنے والے ہیں۔ یوں ملک تباہ نہیں ہو گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","یہ منصوبہ بادشاہ اور اُس کے افسران کو اچھا لگا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","اُس نے اُن سے کہا، ”ہمیں اِس کام کے لئے یوسف سے زیادہ لائق آدمی نہیں ملے گا۔ اُس میں اللہ کی روح ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","بادشاہ نے یوسف سے کہا، ”اللہ نے یہ سب کچھ تجھ پر ظاہر کیا ہے، اِس لئے کوئی بھی تجھ سے زیادہ سمجھ دار اور دانش مند نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","مَیں تجھے اپنے محل پر مقرر کرتا ہوں۔ میری تمام رعایا تیرے تابع رہے گی۔ تیرا اختیار صرف میرے اختیار سے کم ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","اب مَیں تجھے پورے ملکِ مصر پر حاکم مقرر کرتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","بادشاہ نے اپنی اُنگلی سے وہ انگوٹھی اُتاری جس سے مُہر لگاتا تھا اور اُسے یوسف کی اُنگلی میں پہنا دیا۔ اُس نے اُسے کتان کا باریک لباس پہنایا اور اُس کے گلے میں سونے کا گلوبند پہنا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","پھر اُس نے اُسے اپنے دوسرے رتھ میں سوار کیا اور لوگ اُس کے آگے آگے پکارتے رہے، ”گھٹنے ٹیکو! گھٹنے ٹیکو!“ یوں یوسف پورے مصر کا حاکم بنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","فرعون نے اُس سے کہا، ”مَیں تو بادشاہ ہوں، لیکن تیری اجازت کے بغیر پورے ملک میں کوئی بھی اپنا ہاتھ یا پاؤں نہیں ہلائے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_45‏","002_41_45‏","GEN","41","45‏","46","اُس نے یوسف کا مصری نام صافنَت فعنیح رکھا اور اون کے پجاری فوطی فرع کی بیٹی آسنَت کے ساتھ اُس کی شادی کرائی۔ یوسف 30 سال کا تھا جب وہ مصر کے بادشاہ فرعون کی خدمت کرنے لگا۔ اُس نے فرعون کے حضور سے نکل کر مصر کا دورہ کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","سات اچھے سالوں کے دوران ملک میں نہایت اچھی فصلیں اُگیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","یوسف نے تمام خوراک جمع کر کے شہروں میں محفوظ کر لی۔ ہر شہر میں اُس نے ارد گرد کے کھیتوں کی پیداوار محفوظ رکھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","جمع شدہ اناج سمندر کی ریت کی مانند بکثرت تھا۔ اِتنا اناج تھا کہ یوسف نے آخرکار اُس کی پیمائش کرنا چھوڑ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","کال سے پہلے یوسف اور آسنَت کے دو بیٹے پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","اُس نے پہلے کا نام منسّی یعنی ’جو بُھلا دیتا ہے‘ رکھا۔ کیونکہ اُس نے کہا، ”اللہ نے میری مصیبت اور میرے باپ کا گھرانا میری یادداشت سے نکال دیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","دوسرے کا نام اُس نے افرائیم یعنی ’دُگنا پھل دار‘ رکھا۔ کیونکہ اُس نے کہا، ”اللہ نے مجھے میری مصیبت کے ملک میں پھلنے پھولنے دیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","سات اچھے سال جن میں کثرت کی فصلیں اُگیں گزر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","پھر کال کے سات سال شروع ہوئے جس طرح یوسف نے کہا تھا۔ تمام دیگر ممالک میں بھی کال پڑ گیا، لیکن مصر میں وافر خوراک پائی جاتی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","جب کال نے تمام مصر میں زور پکڑا تو لوگ چیخ کر کھانے کے لئے بادشاہ سے منت کرنے لگے۔ تب فرعون نے اُن سے کہا، ”یوسف کے پاس جاؤ۔ جو کچھ وہ تمہیں بتائے گا وہی کرو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","جب کال پوری دنیا میں پھیل گیا تو یوسف نے اناج کے گودام کھول کر مصریوں کو اناج بیچ دیا۔ کیونکہ کال کے باعث ملک کے حالات بہت خراب ہو گئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","تمام ممالک سے بھی لوگ اناج خریدنے کے لئے یوسف کے پاس آئے، کیونکہ پوری دنیا سخت کال کی گرفت میں تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","جب یعقوب کو معلوم ہوا کہ مصر میں اناج ہے تو اُس نے اپنے بیٹوں سے کہا، ”تم کیوں ایک دوسرے کا منہ تکتے ہو؟ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","سنا ہے کہ مصر میں اناج ہے۔ وہاں جا کر ہمارے لئے کچھ خرید لاؤ تاکہ ہم بھوکے نہ مریں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","تب یوسف کے دس بھائی اناج خریدنے کے لئے مصر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","لیکن یعقوب نے یوسف کے سگے بھائی بن یمین کو ساتھ نہ بھیجا، کیونکہ اُس نے کہا، ”ایسا نہ ہو کہ اُسے جانی نقصان پہنچے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","یوں یعقوب کے بیٹے بہت سارے اَور لوگوں کے ساتھ مصر گئے، کیونکہ ملکِ کنعان بھی کال کی گرفت میں تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","یوسف مصر کے حاکم کی حیثیت سے لوگوں کو اناج بیچتا تھا، اِس لئے اُس کے بھائی آ کر اُس کے سامنے منہ کے بل جھک گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","جب یوسف نے اپنے بھائیوں کو دیکھا تو اُس نے اُنہیں پہچان لیا لیکن ایسا کیا جیسا اُن سے ناواقف ہو اور سختی سے اُن سے بات کی، ”تم کہاں سے آئے ہو؟“ اُنہوں نے جواب دیا، ”ہم ملکِ کنعان سے اناج خریدنے کے لئے آئے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","گو یوسف نے اپنے بھائیوں کو پہچان لیا، لیکن اُنہوں نے اُسے نہ پہچانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","اُسے وہ خواب یاد آئے جو اُس نے اُن کے بارے میں دیکھے تھے۔ اُس نے کہا، ”تم جاسوس ہو۔ تم یہ دیکھنے آئے ہو کہ ہمارا ملک کن کن جگہوں پر غیرمحفوظ ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","اُنہوں نے کہا، ”جناب، ہرگز نہیں۔ آپ کے غلام غلہ خریدنے آئے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ہم سب ایک ہی مرد کے بیٹے ہیں۔ آپ کے خادم شریف لوگ ہیں، جاسوس نہیں ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","لیکن یوسف نے اصرار کیا، ”نہیں، تم دیکھنے آئے ہو کہ ہمارا ملک کن کن جگہوں پر غیرمحفوظ ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","اُنہوں نے عرض کی، ”آپ کے خادم کُل بارہ بھائی ہیں۔ ہم ایک ہی آدمی کے بیٹے ہیں جو کنعان میں رہتا ہے۔ سب سے چھوٹا بھائی اِس وقت ہمارے باپ کے پاس ہے جبکہ ایک مر گیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","لیکن یوسف نے اپنا الزام دہرایا، ”ایسا ہی ہے جیسا مَیں نے کہا ہے کہ تم جاسوس ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","مَیں تمہاری باتیں جانچ لوں گا۔ فرعون کی حیات کی قَسم، پہلے تمہارا سب سے چھوٹا بھائی آئے، ورنہ تم اِس جگہ سے کبھی نہیں جا سکو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ایک بھائی کو اُسے لانے کے لئے بھیج دو۔ باقی سب یہاں گرفتار رہیں گے۔ پھر پتا چلے گا کہ تمہاری باتیں سچ ہیں کہ نہیں۔ اگر نہیں تو فرعون کی حیات کی قَسم، اِس کا مطلب یہ ہو گا کہ تم جاسوس ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","یہ کہہ کر یوسف نے اُنہیں تین دن کے لئے قیدخانے میں ڈال دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","تیسرے دن اُس نے اُن سے کہا، ”مَیں اللہ کا خوف مانتا ہوں، اِس لئے تم کو ایک شرط پر جیتا چھوڑوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","اگر تم واقعی شریف لوگ ہو تو ایسا کرو کہ تم میں سے ایک یہاں قیدخانے میں رہے جبکہ باقی سب اناج لے کر اپنے بھوکے گھر والوں کے پاس واپس جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","لیکن لازم ہے کہ تم اپنے سب سے چھوٹے بھائی کو میرے پاس لے آؤ۔ صرف اِس سے تمہاری باتیں سچ ثابت ہوں گی اور تم موت سے بچ جاؤ گے۔“ یوسف کے بھائی راضی ہو گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","وہ آپس میں کہنے لگے، ”بےشک یہ ہمارے اپنے بھائی پر ظلم کی سزا ہے۔ جب وہ التجا کر رہا تھا کہ مجھ پر رحم کریں تو ہم نے اُس کی بڑی مصیبت دیکھ کر بھی اُس کی نہ سنی۔ اِس لئے یہ مصیبت ہم پر آ گئی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","اور روبن نے کہا، ”کیا مَیں نے نہیں کہا تھا کہ لڑکے پر ظلم مت کرو، لیکن تم نے میری ایک نہ مانی۔ اب اُس کی موت کا حساب کتاب کیا جا رہا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","اُنہیں معلوم نہیں تھا کہ یوسف ہماری باتیں سمجھ سکتا ہے، کیونکہ وہ مترجم کی معرفت اُن سے بات کرتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","یہ باتیں سن کر وہ اُنہیں چھوڑ کر رونے لگا۔ پھر وہ سنبھل کر واپس آیا۔ اُس نے شمعون کو چن کر اُسے اُن کے سامنے ہی باندھ لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","یوسف نے حکم دیا کہ ملازم اُن کی بوریاں اناج سے بھر کر ہر ایک بھائی کے پیسے اُس کی بوری میں واپس رکھ دیں اور اُنہیں سفر کے لئے کھانا بھی دیں۔ اُنہوں نے ایسا ہی کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","پھر یوسف کے بھائی اپنے گدھوں پر اناج لاد کر روانہ ہو گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","جب وہ رات کے لئے کسی جگہ پر ٹھہرے تو ایک بھائی نے اپنے گدھے کے لئے چارا نکالنے کی غرض سے اپنی بوری کھولی تو دیکھا کہ بوری کے منہ میں اُس کے پیسے پڑے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","اُس نے اپنے بھائیوں سے کہا، ”میرے پیسے واپس کر دیئے گئے ہیں! وہ میری بوری میں ہیں۔“ یہ دیکھ کر اُن کے ہوش اُڑ گئے۔ کانپتے ہوئے وہ ایک دوسرے کو دیکھنے اور کہنے لگے، ”یہ کیا ہے جو اللہ نے ہمارے ساتھ کیا ہے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ملکِ کنعان میں اپنے باپ کے پاس پہنچ کر اُنہوں نے اُسے سب کچھ سنایا جو اُن کے ساتھ ہوا تھا۔ اُنہوں نے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","”اُس ملک کے مالک نے بڑی سختی سے ہمارے ساتھ بات کی۔ اُس نے ہمیں جاسوس قرار دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","لیکن ہم نے اُس سے کہا، ’ہم جاسوس نہیں بلکہ شریف لوگ ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ہم بارہ بھائی ہیں، ایک ہی باپ کے بیٹے۔ ایک تو مر گیا جبکہ سب سے چھوٹا بھائی اِس وقت کنعان میں باپ کے پاس ہے۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","پھر اُس ملک کے مالک نے ہم سے کہا، ’اِس سے مجھے پتا چلے گا کہ تم شریف لوگ ہو کہ ایک بھائی کو میرے پاس چھوڑ دو اور اپنے بھوکے گھر والوں کے لئے خوراک لے کر چلے جاؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","لیکن اپنے سب سے چھوٹے بھائی کو میرے پاس لے آؤ تاکہ مجھے معلوم ہو جائے کہ تم جاسوس نہیں بلکہ شریف لوگ ہو۔ پھر مَیں تم کو تمہارا بھائی واپس کر دوں گا اور تم اِس ملک میں آزادی سے تجارت کر سکو گے‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","اُنہوں نے اپنی بوریوں سے اناج نکال دیا تو دیکھا کہ ہر ایک کی بوری میں اُس کے پیسوں کی تھیلی رکھی ہوئی ہے۔ یہ پیسے دیکھ کر وہ خود اور اُن کا باپ ڈر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","اُن کے باپ نے اُن سے کہا، ”تم نے مجھے میرے بچوں سے محروم کر دیا ہے۔ یوسف نہیں رہا، شمعون بھی نہیں رہا اور اب تم بن یمین کو بھی مجھ سے چھیننا چاہتے ہو۔ سب کچھ میرے خلاف ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","پھر روبن بول اُٹھا، ”اگر مَیں اُسے سلامتی سے آپ کے پاس واپس نہ پہنچاؤں تو آپ میرے دو بیٹوں کو سزائے موت دے سکتے ہیں۔ اُسے میرے سپرد کریں تو مَیں اُسے واپس لے آؤں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","لیکن یعقوب نے کہا، ”میرا بیٹا تمہارے ساتھ جانے کا نہیں۔ کیونکہ اُس کا بھائی مر گیا ہے اور وہ اکیلا ہی رہ گیا ہے۔ اگر اُس کو راستے میں جانی نقصان پہنچے تو تم مجھ بوڑھے کو غم کے مارے پاتال میں پہنچاؤ گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","کال نے زور پکڑا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","جب مصر سے لایا گیا اناج ختم ہو گیا تو یعقوب نے کہا، ”اب واپس جا کر ہمارے لئے کچھ اَور غلہ خرید لاؤ۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","لیکن یہوداہ نے کہا، ”اُس مرد نے سختی سے کہا تھا، ’تم صرف اِس صورت میں میرے پاس آ سکتے ہو کہ تمہارا بھائی ساتھ ہو۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","اگر آپ ہمارے بھائی کو ساتھ بھیجیں تو پھر ہم جا کر آپ کے لئے غلہ خریدیں گے ");
INSERT INTO urdgvu_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ورنہ نہیں۔ کیونکہ اُس آدمی نے کہا تھا کہ ہم صرف اِس صورت میں اُس کے پاس آ سکتے ہیں کہ ہمارا بھائی ساتھ ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","یعقوب نے کہا، ”تم نے اُسے کیوں بتایا کہ ہمارا ایک اَور بھائی بھی ہے؟ اِس سے تم نے مجھے بڑی مصیبت میں ڈال دیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","اُنہوں نے جواب دیا، ”وہ آدمی ہمارے اور ہمارے خاندان کے بارے میں پوچھتا رہا، ’کیا تمہارا باپ اب تک زندہ ہے؟ کیا تمہارا کوئی اَور بھائی ہے؟‘ پھر ہمیں جواب دینا پڑا۔ ہمیں کیا پتا تھا کہ وہ ہمیں اپنے بھائی کو ساتھ لانے کو کہے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","پھر یہوداہ نے باپ سے کہا، ”لڑکے کو میرے ساتھ بھیج دیں تو ہم ابھی روانہ ہو جائیں گے۔ ورنہ آپ، ہمارے بچے بلکہ ہم سب بھوکے مر جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","مَیں خود اُس کا ضامن ہوں گا۔ آپ مجھے اُس کی جان کا ذمہ دار ٹھہرا سکتے ہیں۔ اگر مَیں اُسے سلامتی سے واپس نہ پہنچاؤں تو پھر مَیں زندگی کے آخر تک قصوروار ٹھہروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","جتنی دیر تک ہم جھجکتے رہے ہیں اُتنی دیر میں تو ہم دو دفعہ مصر جا کر واپس آ سکتے تھے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","تب اُن کے باپ اسرائیل نے کہا، ”اگر اَور کوئی صورت نہیں تو اِس ملک کی بہترین پیداوار میں سے کچھ تحفے کے طور پر لے کر اُس آدمی کو دے دو یعنی کچھ بلسان، شہد، لادن، مُر، پستہ اور بادام۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","اپنے ساتھ دُگنی رقم لے کر جاؤ، کیونکہ تمہیں وہ پیسے واپس کرنے ہیں جو تمہاری بوریوں میں رکھے گئے تھے۔ شاید کسی سے غلطی ہوئی ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","اپنے بھائی کو لے کر سیدھے واپس پہنچنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","اللہ قادرِ مطلق کرے کہ یہ آدمی تم پر رحم کر کے بن یمین اور تمہارے دوسرے بھائی کو واپس بھیجے۔ جہاں تک میرا تعلق ہے، اگر مجھے اپنے بچوں سے محروم ہونا ہے تو ایسا ہی ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","چنانچہ وہ تحفے، دُگنی رقم اور بن یمین کو ساتھ لے کر چل پڑے۔ مصر پہنچ کر وہ یوسف کے سامنے حاضر ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","جب یوسف نے بن یمین کو اُن کے ساتھ دیکھا تو اُس نے اپنے گھر پر مقرر ملازم سے کہا، ”اِن آدمیوں کو میرے گھر لے جاؤ تاکہ وہ دوپہر کا کھانا میرے ساتھ کھائیں۔ جانور کو ذبح کر کے کھانا تیار کرو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ملازم نے ایسا ہی کیا اور بھائیوں کو یوسف کے گھر لے گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","جب اُنہیں اُس کے گھر پہنچایا جا رہا تھا تو وہ ڈر کر سوچنے لگے، ”ہمیں اُن پیسوں کے سبب سے یہاں لایا جا رہا ہے جو پہلی دفعہ ہماری بوریوں میں واپس کئے گئے تھے۔ وہ ہم پر اچانک حملہ کر کے ہمارے گدھے چھین لیں گے اور ہمیں غلام بنا لیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","اِس لئے گھر کے دروازے پر پہنچ کر اُنہوں نے گھر پر مقرر ملازم سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","”جنابِ عالی، ہماری بات سن لیجئے۔ اِس سے پہلے ہم اناج خریدنے کے لئے یہاں آئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","لیکن جب ہم یہاں سے روانہ ہو کر راستے میں رات کے لئے ٹھہرے تو ہم نے اپنی بوریاں کھول کر دیکھا کہ ہر بوری کے منہ میں ہمارے پیسوں کی پوری رقم پڑی ہے۔ ہم یہ پیسے واپس لے آئے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","نیز، ہم مزید خوراک خریدنے کے لئے اَور پیسے لے آئے ہیں۔ خدا جانے کس نے ہمارے یہ پیسے ہماری بوریوں میں رکھ دیئے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ملازم نے کہا، ”فکر نہ کریں۔ مت ڈریں۔ آپ کے اور آپ کے باپ کے خدا نے آپ کے لئے آپ کی بوریوں میں یہ خزانہ رکھا ہو گا۔ بہرحال مجھے آپ کے پیسے مل گئے ہیں۔“ ملازم شمعون کو اُن کے پاس باہر لے آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","پھر اُس نے بھائیوں کو یوسف کے گھر میں لے جا کر اُنہیں پاؤں دھونے کے لئے پانی اور گدھوں کو چارا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","اُنہوں نے اپنے تحفے تیار رکھے، کیونکہ اُنہیں بتایا گیا، ”یوسف دوپہر کا کھانا آپ کے ساتھ ہی کھائے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","جب یوسف گھر پہنچا تو وہ اپنے تحفے لے کر اُس کے سامنے آئے اور منہ کے بل جھک گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","اُس نے اُن سے خیریت دریافت کی اور پھر کہا، ”تم نے اپنے بوڑھے باپ کا ذکر کیا۔ کیا وہ ٹھیک ہیں؟ کیا وہ اب تک زندہ ہیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","اُنہوں نے جواب دیا، ”جی، آپ کے خادم ہمارے باپ اب تک زندہ ہیں۔“ وہ دوبارہ منہ کے بل جھک گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","جب یوسف نے اپنے سگے بھائی بن یمین کو دیکھا تو اُس نے کہا، ”کیا یہ تمہارا سب سے چھوٹا بھائی ہے جس کا تم نے ذکر کیا تھا؟ بیٹا، اللہ کی نظرِ کرم تم پر ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","یوسف اپنے بھائی کو دیکھ کر اِتنا متاثر ہوا کہ وہ رونے کو تھا، اِس لئے وہ جلدی سے وہاں سے نکل کر اپنے سونے کے کمرے میں گیا اور رو پڑا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","پھر وہ اپنا منہ دھو کر واپس آیا۔ اپنے آپ پر قابو پا کر اُس نے حکم دیا کہ نوکر کھانا لے آئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","نوکروں نے یوسف کے لئے کھانے کا الگ انتظام کیا اور بھائیوں کے لئے الگ۔ مصریوں کے لئے بھی کھانے کا الگ انتظام تھا، کیونکہ عبرانیوں کے ساتھ کھانا کھانا اُن کی نظر میں قابلِ نفرت تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","بھائیوں کو اُن کی عمر کی ترتیب کے مطابق یوسف کے سامنے بٹھایا گیا۔ یہ دیکھ کر بھائی نہایت حیران ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","نوکروں نے اُنہیں یوسف کی میز پر سے کھانا لے کر کھلایا۔ لیکن بن یمین کو دوسروں کی نسبت پانچ گُنا زیادہ ملا۔ یوں اُنہوں نے یوسف کے ساتھ جی بھر کر کھایا اور پیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","یوسف نے گھر پر مقرر ملازم کو حکم دیا، ”اُن مردوں کی بوریاں خوراک سے اِتنی بھر دینا جتنی وہ اُٹھا کر لے جا سکیں۔ ہر ایک کے پیسے اُس کی اپنی بوری کے منہ میں رکھ دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","سب سے چھوٹے بھائی کی بوری میں نہ صرف پیسے بلکہ میرے چاندی کے پیالے کو بھی رکھ دینا۔“ ملازم نے ایسا ہی کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","اگلی صبح جب پَو پھٹنے لگی تو بھائیوں کو اُن کے گدھوں سمیت رُخصت کر دیا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","وہ ابھی شہر سے نکل کر دُور نہیں گئے تھے کہ یوسف نے اپنے گھر پر مقرر ملازم سے کہا، ”جلدی کرو۔ اُن آدمیوں کا تعاقب کرو۔ اُن کے پاس پہنچ کر یہ پوچھنا، ’آپ نے ہماری بھلائی کے جواب میں غلط کام کیوں کیا ہے؟ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","آپ نے میرے مالک کا چاندی کا پیالہ کیوں چُرایا ہے؟ اُس سے وہ نہ صرف پیتے ہیں بلکہ اُسے غیب دانی کے لئے بھی استعمال کرتے ہیں۔ آپ ایک نہایت سنگین جرم کے مرتکب ہوئے ہیں‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","جب ملازم بھائیوں کے پاس پہنچا تو اُس نے اُن سے یہی باتیں کیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","جواب میں اُنہوں نے کہا، ”ہمارے مالک ایسی باتیں کیوں کرتے ہیں؟ کبھی نہیں ہو سکتا کہ آپ کے خادم ایسا کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","آپ تو جانتے ہیں کہ ہم ملکِ کنعان سے وہ پیسے واپس لے آئے جو ہماری بوریوں میں تھے۔ تو پھر ہم کیوں آپ کے مالک کے گھر سے چاندی یا سونا چُرائیں گے؟ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","اگر وہ آپ کے خادموں میں سے کسی کے پاس مل جائے تو اُسے مار ڈالا جائے اور باقی سب آپ کے غلام بنیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ملازم نے کہا، ”ٹھیک ہے ایسا ہی ہو گا۔ لیکن صرف وہی میرا غلام بنے گا جس نے پیالہ چُرایا ہے۔ باقی سب آزاد ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","اُنہوں نے جلدی سے اپنی بوریاں اُتار کر زمین پر رکھ دیں۔ ہر ایک نے اپنی بوری کھول دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ملازم بوریوں کی تلاشی لینے لگا۔ وہ بڑے بھائی سے شروع کر کے آخرکار سب سے چھوٹے بھائی تک پہنچ گیا۔ اور وہاں بن یمین کی بوری میں سے پیالہ نکلا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","بھائیوں نے یہ دیکھ کر پریشانی میں اپنے لباس پھاڑ لئے۔ وہ اپنے گدھوں کو دوبارہ لاد کر شہر واپس آ گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","جب یہوداہ اور اُس کے بھائی یوسف کے گھر پہنچے تو وہ ابھی وہیں تھا۔ وہ اُس کے سامنے منہ کے بل گر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","یوسف نے کہا، ”یہ تم نے کیا کِیا ہے؟ کیا تم نہیں جانتے کہ مجھ جیسا آدمی غیب کا علم رکھتا ہے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","یہوداہ نے کہا، ”جنابِ عالی، ہم کیا کہیں؟ اب ہم اپنے دفاع میں کیا کہیں؟ اللہ ہی نے ہمیں قصوروار ٹھہرایا ہے۔ اب ہم سب آپ کے غلام ہیں، نہ صرف وہ جس کے پاس سے پیالہ مل گیا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","یوسف نے کہا، ”اللہ نہ کرے کہ مَیں ایسا کروں، بلکہ صرف وہی میرا غلام ہو گا جس کے پاس پیالہ تھا۔ باقی سب سلامتی سے اپنے باپ کے پاس واپس چلے جائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","لیکن یہوداہ نے یوسف کے قریب آ کر کہا، ”میرے مالک، مہربانی کر کے اپنے بندے کو ایک بات کرنے کی اجازت دیں۔ مجھ پر غصہ نہ کریں اگرچہ آپ مصر کے بادشاہ جیسے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","جنابِ عالی، آپ نے ہم سے پوچھا، ’کیا تمہارا باپ یا کوئی اَور بھائی ہے؟‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ہم نے جواب دیا، ’ہمارا باپ ہے۔ وہ بوڑھا ہے۔ ہمارا ایک چھوٹا بھائی بھی ہے جو اُس وقت پیدا ہوا جب ہمارا باپ عمر رسیدہ تھا۔ اُس لڑکے کا بھائی مر چکا ہے۔ اُس کی ماں کے صرف یہ دو بیٹے پیدا ہوئے۔ اب وہ اکیلا ہی رہ گیا ہے۔ اُس کا باپ اُسے شدت سے پیار کرتا ہے۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","جنابِ عالی، آپ نے ہمیں بتایا، ’اُسے یہاں لے آؤ تاکہ مَیں خود اُسے دیکھ سکوں۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ہم نے جواب دیا، ’یہ لڑکا اپنے باپ کو چھوڑ نہیں سکتا، ورنہ اُس کا باپ مر جائے گا۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","پھر آپ نے کہا، ’تم صرف اِس صورت میں میرے پاس آ سکو گے کہ تمہارا سب سے چھوٹا بھائی تمہارے ساتھ ہو۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","جب ہم اپنے باپ کے پاس واپس پہنچے تو ہم نے اُنہیں سب کچھ بتایا جو آپ نے کہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","پھر اُنہوں نے ہم سے کہا، ’مصر لوٹ کر کچھ غلہ خرید لاؤ۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ہم نے جواب دیا، ’ہم جا نہیں سکتے۔ ہم صرف اِس صورت میں اُس مرد کے پاس جا سکتے ہیں کہ ہمارا سب سے چھوٹا بھائی ساتھ ہو۔ ہم تب ہی جا سکتے ہیں جب وہ بھی ہمارے ساتھ چلے۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","ہمارے باپ نے ہم سے کہا، ’تم جانتے ہو کہ میری بیوی راخل سے میرے دو بیٹے پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","پہلا مجھے چھوڑ چکا ہے۔ کسی جنگلی جانور نے اُسے پھاڑ کھایا ہو گا، کیونکہ اُسی وقت سے مَیں نے اُسے نہیں دیکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","اگر اِس کو بھی مجھ سے لے جانے کی وجہ سے جانی نقصان پہنچے تو تم مجھ بوڑھے کو غم کے مارے پاتال میں پہنچاؤ گے‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_30‏","002_44_30‏","GEN","44","30‏","31","یہوداہ نے اپنی بات جاری رکھی، ”جنابِ عالی، اب اگر مَیں اپنے باپ کے پاس جاؤں اور وہ دیکھیں کہ لڑکا میرے ساتھ نہیں ہے تو وہ دم توڑ دیں گے۔ اُن کی زندگی اِس قدر لڑکے کی زندگی پر منحصر ہے اور وہ اِتنے بوڑھے ہیں کہ ہم ایسی حرکت سے اُنہیں قبر تک پہنچا دیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","نہ صرف یہ بلکہ مَیں نے باپ سے کہا، ’مَیں خود اِس کا ضامن ہوں گا۔ اگر مَیں اِسے سلامتی سے واپس نہ پہنچاؤں تو پھر مَیں زندگی کے آخر تک قصوروار ٹھہروں گا۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","اب اپنے خادم کی گزارش سنیں۔ مَیں یہاں رہ کر اِس لڑکے کی جگہ غلام بن جاتا ہوں، اور وہ دوسرے بھائیوں کے ساتھ واپس چلا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","اگر لڑکا میرے ساتھ نہ ہوا تو مَیں کس طرح اپنے باپ کو منہ دکھا سکتا ہوں؟ مَیں برداشت نہیں کر سکوں گا کہ وہ اِس مصیبت میں مبتلا ہو جائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","یہ سن کر یوسف اپنے آپ پر قابو نہ رکھ سکا۔ اُس نے اونچی آواز سے حکم دیا کہ تمام ملازم کمرے سے نکل جائیں۔ کوئی اَور شخص کمرے میں نہیں تھا جب یوسف نے اپنے بھائیوں کو بتایا کہ وہ کون ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","وہ اِتنے زور سے رو پڑا کہ مصریوں نے اُس کی آواز سنی اور فرعون کے گھرانے کو پتا چل گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","یوسف نے اپنے بھائیوں سے کہا، ”مَیں یوسف ہوں۔ کیا میرا باپ اب تک زندہ ہے؟“ لیکن اُس کے بھائی یہ سن کر اِتنے گھبرا گئے کہ وہ جواب نہ دے سکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","پھر یوسف نے کہا، ”میرے قریب آؤ۔“ وہ قریب آئے تو اُس نے کہا، ”مَیں تمہارا بھائی یوسف ہوں جسے تم نے بیچ کر مصر بھجوایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","اب میری بات سنو۔ نہ گھبراؤ اور نہ اپنے آپ کو الزام دو کہ ہم نے یوسف کو بیچ دیا۔ اصل میں اللہ نے خود مجھے تمہارے آگے یہاں بھیج دیا تاکہ ہم سب بچے رہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","یہ کال کا دوسرا سال ہے۔ پانچ اَور سال کے دوران نہ ہل چلے گا، نہ فصل کٹے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","اللہ نے مجھے تمہارے آگے بھیجا تاکہ دنیا میں تمہارا ایک بچا کھچا حصہ محفوظ رہے اور تمہاری جان ایک بڑی مخلصی کی معرفت چھوٹ جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","چنانچہ تم نے مجھے یہاں نہیں بھیجا بلکہ اللہ نے۔ اُس نے مجھے فرعون کا باپ، اُس کے پورے گھرانے کا مالک اور مصر کا حاکم بنا دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","اب جلدی سے میرے باپ کے پاس واپس جا کر اُن سے کہو، ’آپ کا بیٹا یوسف آپ کو اطلاع دیتا ہے کہ اللہ نے مجھے مصر کا مالک بنا دیا ہے۔ میرے پاس آ جائیں، دیر نہ کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","آپ جشن کے علاقے میں رہ سکتے ہیں۔ وہاں آپ میرے قریب ہوں گے، آپ، آپ کی آل اولاد، گائےبَیل، بھیڑبکریاں اور جو کچھ بھی آپ کا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","وہاں مَیں آپ کی ضروریات پوری کروں گا، کیونکہ کال کو ابھی پانچ سال اَور لگیں گے۔ ورنہ آپ، آپ کے گھر والے اور جو بھی آپ کے ہیں بدحال ہو جائیں گے۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","تم خود اور میرا بھائی بن یمین دیکھ سکتے ہو کہ مَیں یوسف ہی ہوں جو تمہارے ساتھ بات کر رہا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","میرے باپ کو مصر میں میرے اثر و رسوخ کے بارے میں اطلاع دو۔ اُنہیں سب کچھ بتاؤ جو تم نے دیکھا ہے۔ پھر جلد ہی میرے باپ کو یہاں لے آؤ۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","یہ کہہ کر وہ اپنے بھائی بن یمین کو گلے لگا کر رو پڑا۔ بن یمین بھی اُس کے گلے لگ کر رونے لگا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","پھر یوسف نے روتے ہوئے اپنے ہر ایک بھائی کو بوسہ دیا۔ اِس کے بعد اُس کے بھائی اُس کے ساتھ باتیں کرنے لگے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","جب یہ خبر بادشاہ کے محل تک پہنچی کہ یوسف کے بھائی آئے ہیں تو فرعون اور اُس کے تمام افسران خوش ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","اُس نے یوسف سے کہا، ”اپنے بھائیوں کو بتا کہ اپنے جانوروں پر غلہ لاد کر ملکِ کنعان واپس چلے جاؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","وہاں اپنے باپ اور خاندانوں کو لے کر میرے پاس آ جاؤ۔ مَیں تم کو مصر کی سب سے اچھی زمین دے دوں گا، اور تم اِس ملک کی بہترین پیداوار کھا سکو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","اُنہیں یہ ہدایت بھی دے کہ اپنے بال بچوں کے لئے مصر سے گاڑیاں لے جاؤ اور اپنے باپ کو بھی بٹھا کر یہاں لے آؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","اپنے مال کی زیادہ فکر نہ کرو، کیونکہ تمہیں ملکِ مصر کا بہترین مال ملے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","یوسف کے بھائیوں نے ایسا ہی کیا۔ یوسف نے اُنہیں بادشاہ کے حکم کے مطابق گاڑیاں اور سفر کے لئے خوراک دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","اُس نے ہر ایک بھائی کو کپڑوں کا ایک جوڑا بھی دیا۔ لیکن بن یمین کو اُس نے چاندی کے 300 سِکے اور پانچ جوڑے دیئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","اُس نے اپنے باپ کو دس گدھے بھجوا دیئے جو مصر کے بہترین مال سے لدے ہوئے تھے اور دس گدھیاں جو اناج، روٹی اور باپ کے سفر کے لئے کھانے سے لدی ہوئی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","یوں اُس نے اپنے بھائیوں کو رُخصت کر کے کہا، ”راستے میں جھگڑا نہ کرنا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","وہ مصر سے روانہ ہو کر ملکِ کنعان میں اپنے باپ کے پاس پہنچے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","اُنہوں نے اُس سے کہا، ”یوسف زندہ ہے! وہ پورے مصر کا حاکم ہے۔“ لیکن یعقوب ہکا بکا رہ گیا، کیونکہ اُسے یقین نہ آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","تاہم اُنہوں نے اُسے سب کچھ بتایا جو یوسف نے اُن سے کہا تھا، اور اُس نے خود وہ گاڑیاں دیکھیں جو یوسف نے اُسے مصر لے جانے کے لئے بھجوا دی تھیں۔ پھر یعقوب کی جان میں جان آ گئی، ");
INSERT INTO urdgvu_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","اور اُس نے کہا، ”میرا بیٹا یوسف زندہ ہے! یہی کافی ہے۔ مرنے سے پہلے مَیں جا کر اُس سے ملوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","یعقوب سب کچھ لے کر روانہ ہوا اور بیرسبع پہنچا۔ وہاں اُس نے اپنے باپ اسحاق کے خدا کے حضور قربانیاں چڑھائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","رات کو اللہ رویا میں اُس سے ہم کلام ہوا۔ اُس نے کہا، ”یعقوب، یعقوب!“ یعقوب نے جواب دیا، ”جی، مَیں حاضر ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","اللہ نے کہا، ”مَیں اللہ ہوں، تیرے باپ اسحاق کا خدا۔ مصر جانے سے مت ڈر، کیونکہ وہاں مَیں تجھ سے ایک بڑی قوم بناؤں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","مَیں تیرے ساتھ مصر جاؤں گا اور تجھے اِس ملک میں واپس بھی لے آؤں گا۔ جب تُو مرے گا تو یوسف خود تیری آنکھیں بند کرے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","اِس کے بعد یعقوب بیرسبع سے روانہ ہوا۔ اُس کے بیٹوں نے اُسے اور اپنے بال بچوں کو اُن گاڑیوں میں بٹھا دیا جو مصر کے بادشاہ نے بھجوائی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","یوں یعقوب اور اُس کی تمام اولاد اپنے مویشی اور کنعان میں حاصل کیا ہوا مال لے کر مصر چلے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","یعقوب کے بیٹے بیٹیاں، پوتے پوتیاں اور باقی اولاد سب ساتھ گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","اسرائیل کی اولاد کے نام جو مصر چلی گئی یہ ہیں: یعقوب کے پہلوٹھے روبن ");
INSERT INTO urdgvu_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","کے بیٹے حنوک، فلّو، حصرون اور کرمی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","شمعون کے بیٹے یموایل، یمین، اُہد، یکین، صُحر اور ساؤل تھے (ساؤل کنعانی عورت کا بچہ تھا)۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","لاوی کے بیٹے جَیرسون، قِہات اور مِراری تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","یہوداہ کے بیٹے عیر، اونان، سیلہ، فارص اور زارح تھے (عیر اور اونان کنعان میں مر چکے تھے)۔ فارص کے دو بیٹے حصرون اور حمول تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","اِشکار کے بیٹے تولع، فُوّہ، یوب اور سِمرون تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","زبولون کے بیٹے سرد، ایلون اور یحلئیل تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","اِن بیٹوں کی ماں لیاہ تھی، اور وہ مسوپتامیہ میں پیدا ہوئے۔ اِن کے علاوہ دینہ اُس کی بیٹی تھی۔ کُل 33 مرد لیاہ کی اولاد تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","جد کے بیٹے صفیان، حجی، سُونی، اِصبون، عیری، ارودی اور اریلی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","آشر کے بیٹے یِمنہ، اِسواہ، اِسوی اور بریعہ تھے۔ آشر کی بیٹی سِرح تھی، اور بریعہ کے دو بیٹے تھے، حِبر اور ملکی ایل۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","کُل 16 افراد زِلفہ کی اولاد تھے جسے لابن نے اپنی بیٹی لیاہ کو دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","راخل کے بیٹے یوسف اور بن یمین تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","یوسف کے دو بیٹے منسّی اور افرائیم مصر میں پیدا ہوئے۔ اُن کی ماں اون کے پجاری فوطی فرع کی بیٹی آسنَت تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","بن یمین کے بیٹے بالع، بکر، اشبیل، جیرا، نعمان، اِخی، روس، مُفیم، حُفیم اور ارد تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","کُل 14 مرد راخل کی اولاد تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","دان کا بیٹا حُشیم تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","نفتالی کے بیٹے یحصی ایل، جونی، یصر اور سِلیم تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","کُل 7 مرد بِلہاہ کی اولاد تھے جسے لابن نے اپنی بیٹی راخل کو دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","یعقوب کی اولاد کے 66 افراد اُس کے ساتھ مصر چلے گئے۔ اِس تعداد میں بیٹوں کی بیویاں شامل نہیں تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","جب ہم یعقوب، یوسف اور اُس کے دو بیٹے اِن میں شامل کرتے ہیں تو یعقوب کے گھرانے کے 70 افراد مصر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","یعقوب نے یہوداہ کو اپنے آگے یوسف کے پاس بھیجا تاکہ وہ جشن میں اُن سے ملے۔ جب وہ وہاں پہنچے ");
INSERT INTO urdgvu_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","تو یوسف اپنے رتھ پر سوار ہو کر اپنے باپ سے ملنے کے لئے جشن گیا۔ اُسے دیکھ کر وہ اُس کے گلے لگ کر کافی دیر روتا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","یعقوب نے یوسف سے کہا، ”اب مَیں مرنے کے لئے تیار ہوں، کیونکہ مَیں نے خود دیکھا ہے کہ تُو زندہ ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","پھر یوسف نے اپنے بھائیوں اور اپنے باپ کے خاندان کے باقی افراد سے کہا، ”ضروری ہے کہ مَیں جا کر بادشاہ کو اطلاع دوں کہ میرے بھائی اور میرے باپ کا پورا خاندان جو کنعان کے رہنے والے ہیں میرے پاس آ گئے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","مَیں اُس سے کہوں گا، ’یہ آدمی بھیڑبکریوں کے چرواہے ہیں۔ وہ مویشی پالتے ہیں، اِس لئے اپنی بھیڑبکریاں، گائےبَیل اور باقی سارا مال اپنے ساتھ لے آئے ہیں۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","بادشاہ تمہیں بُلا کر پوچھے گا کہ تم کیا کام کرتے ہو؟ ");
INSERT INTO urdgvu_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","پھر تم کو جواب دینا ہے، ’آپ کے خادم بچپن سے مویشی پالتے آئے ہیں۔ یہ ہمارے باپ دادا کا پیشہ تھا اور ہمارا بھی ہے۔‘ اگر تم یہ کہو تو تمہیں جشن میں رہنے کی اجازت ملے گی۔ کیونکہ بھیڑبکریوں کے چرواہے مصریوں کی نظر میں قابلِ نفرت ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","یوسف فرعون کے پاس گیا اور اُسے اطلاع دے کر کہا، ”میرا باپ اور بھائی اپنی بھیڑبکریوں، گائےبَیلوں اور سارے مال سمیت ملکِ کنعان سے آ کر جشن میں ٹھہرے ہوئے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","اُس نے اپنے بھائیوں میں سے پانچ کو چن کر فرعون کے سامنے پیش کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","فرعون نے بھائیوں سے پوچھا، ”تم کیا کام کرتے ہو؟“ اُنہوں نے جواب دیا، ”آپ کے خادم بھیڑبکریوں کے چرواہے ہیں۔ یہ ہمارے باپ دادا کا پیشہ تھا اور ہمارا بھی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ہم یہاں آئے ہیں تاکہ کچھ دیر اجنبی کی حیثیت سے آپ کے پاس ٹھہریں، کیونکہ کال نے کنعان میں بہت زور پکڑا ہے۔ وہاں آپ کے خادموں کے جانوروں کے لئے چراگاہیں ختم ہو گئی ہیں۔ اِس لئے ہمیں جشن میں رہنے کی اجازت دیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","بادشاہ نے یوسف سے کہا، ”تیرا باپ اور بھائی تیرے پاس آ گئے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ملکِ مصر تیرے سامنے کھلا ہے۔ اُنہیں بہترین جگہ پر آباد کر۔ وہ جشن میں رہیں۔ اور اگر اُن میں سے کچھ ہیں جو خاص قابلیت رکھتے ہیں تو اُنہیں میرے مویشیوں کی نگہداشت پر رکھ۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","پھر یوسف اپنے باپ یعقوب کو لے آیا اور فرعون کے سامنے پیش کیا۔ یعقوب نے بادشاہ کو برکت دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","بادشاہ نے اُس سے پوچھا، ”تمہاری عمر کیا ہے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","یعقوب نے جواب دیا، ”مَیں 130 سال سے اِس دنیا کا مہمان ہوں۔ میری زندگی مختصر اور تکلیف دہ تھی، اور میرے باپ دادا مجھ سے زیادہ عمر رسیدہ ہوئے تھے جب وہ اِس دنیا کے مہمان تھے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","یہ کہہ کر یعقوب فرعون کو دوبارہ برکت دے کر چلا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","پھر یوسف نے اپنے باپ اور بھائیوں کو مصر میں آباد کیا۔ اُس نے اُنہیں رعمسیس کے علاقے میں بہترین زمین دی جس طرح بادشاہ نے حکم دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","یوسف اپنے باپ کے پورے گھرانے کو خوراک مہیا کرتا رہا۔ ہر خاندان کو اُس کے بچوں کی تعداد کے مطابق خوراک ملتی رہی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","کال اِتنا سخت تھا کہ کہیں بھی روٹی نہیں ملتی تھی۔ مصر اور کنعان میں لوگ نڈھال ہو گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","مصر اور کنعان کے تمام پیسے اناج خریدنے کے لئے صَرف ہو گئے۔ یوسف اُنہیں جمع کر کے فرعون کے محل میں لے آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","جب مصر اور کنعان کے پیسے ختم ہو گئے تو مصریوں نے یوسف کے پاس آ کر کہا، ”ہمیں روٹی دیں! ہم آپ کے سامنے کیوں مریں؟ ہمارے پیسے ختم ہو گئے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","یوسف نے جواب دیا، ”اگر آپ کے پیسے ختم ہیں تو مجھے اپنے مویشی دیں۔ مَیں اُن کے عوض روٹی دیتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","چنانچہ وہ اپنے گھوڑے، بھیڑبکریاں، گائےبَیل اور گدھے یوسف کے پاس لے آئے۔ اِن کے عوض اُس نے اُنہیں خوراک دی۔ اُس سال اُس نے اُنہیں اُن کے تمام مویشیوں کے عوض خوراک مہیا کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","اگلے سال وہ دوبارہ اُس کے پاس آئے۔ اُنہوں نے کہا، ”جنابِ عالی، ہم یہ بات آپ سے نہیں چھپا سکتے کہ اب ہم صرف اپنے آپ اور اپنی زمین کو آپ کو دے سکتے ہیں۔ ہمارے پیسے تو ختم ہیں اور آپ ہمارے مویشی بھی لے چکے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ہم کیوں آپ کی آنکھوں کے سامنے مر جائیں؟ ہماری زمین کیوں تباہ ہو جائے؟ ہمیں روٹی دیں تو ہم اور ہماری زمین بادشاہ کی ہو گی۔ ہم فرعون کے غلام ہوں گے۔ ہمیں بیج دیں تاکہ ہم جیتے بچیں اور زمین تباہ نہ ہو جائے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","چنانچہ یوسف نے فرعون کے لئے مصر کی پوری زمین خرید لی۔ کال کی سختی کے سبب سے تمام مصریوں نے اپنے کھیت بیچ دیئے۔ اِس طریقے سے پورا ملک فرعون کی ملکیت میں آ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","یوسف نے مصر کے ایک سرے سے دوسرے سرے تک کے لوگوں کو شہروں میں منتقل کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","صرف پجاریوں کی زمین آزاد رہی۔ اُنہیں اپنی زمین بیچنے کی ضرورت ہی نہیں تھی، کیونکہ اُنہیں فرعون سے اِتنا وظیفہ ملتا تھا کہ گزارہ ہو جاتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","یوسف نے لوگوں سے کہا، ”غور سے سنیں۔ آج مَیں نے آپ کو اور آپ کی زمین کو بادشاہ کے لئے خرید لیا ہے۔ اب یہ بیج لے کر اپنے کھیتوں میں بونا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","آپ کو فرعون کو فصل کا پانچواں حصہ دینا ہے۔ باقی پیداوار آپ کی ہو گی۔ آپ اِس سے بیج بو سکتے ہیں، اور یہ آپ کے اور آپ کے گھرانوں اور بچوں کے کھانے کے لئے ہو گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","اُنہوں نے جواب دیا، ”آپ نے ہمیں بچایا ہے۔ ہمارے مالک ہم پر مہربانی کریں تو ہم فرعون کے غلام بنیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","اِس طرح یوسف نے مصر میں یہ قانون نافذ کیا کہ ہر فصل کا پانچواں حصہ بادشاہ کا ہے۔ یہ قانون آج تک جاری ہے۔ صرف پجاریوں کی زمین بادشاہ کی ملکیت میں نہ آئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","اسرائیلی مصر میں جشن کے علاقے میں آباد ہوئے۔ وہاں اُنہیں زمین ملی، اور وہ پھلے پھولے اور تعداد میں بہت بڑھ گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","یعقوب 17 سال مصر میں رہا۔ وہ 147 سال کا تھا جب فوت ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","جب مرنے کا وقت قریب آیا تو اُس نے یوسف کو بُلا کر کہا، ”مہربانی کر کے اپنا ہاتھ میری ران کے نیچے رکھ کر قَسم کھا کہ تُو مجھ پر شفقت اور وفاداری کا اِس طرح اظہار کرے گا کہ مجھے مصر میں دفن نہیں کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","جب مَیں مر کر اپنے باپ دادا سے جا ملوں گا تو مجھے مصر سے لے جا کر میرے باپ دادا کی قبر میں دفنانا۔“ یوسف نے جواب دیا، ”ٹھیک ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","یعقوب نے کہا، ”قَسم کھا کہ تُو ایسا ہی کرے گا۔“ یوسف نے قَسم کھائی۔ تب اسرائیل نے اپنے بستر کے سرہانے پر اللہ کو سجدہ کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","کچھ دیر کے بعدیوسف کو اطلاع دی گئی کہ آپ کا باپ بیمار ہے۔ وہ اپنے دو بیٹوں منسّی اور افرائیم کو ساتھ لے کر یعقوب سے ملنے گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","یعقوب کو بتایا گیا، ”آپ کا بیٹا آ گیا ہے“ تو وہ اپنے آپ کو سنبھال کر اپنے بستر پر بیٹھ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","اُس نے یوسف سے کہا، ”جب مَیں کنعانی شہر لُوز میں تھا تو اللہ قادرِ مطلق مجھ پر ظاہر ہوا۔ اُس نے مجھے برکت دے کر ");
INSERT INTO urdgvu_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","کہا، ’مَیں تجھے پھلنے پھولنے دوں گا اور تیری اولاد بڑھا دوں گا بلکہ تجھ سے بہت سی قومیں نکلنے دوں گا۔ اور مَیں تیری اولاد کو یہ ملک ہمیشہ کے لئے دے دوں گا۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","اب میری بات سن۔ مَیں چاہتا ہوں کہ تیرے بیٹے جو میرے آنے سے پہلے مصر میں پیدا ہوئے میرے بیٹے ہوں۔ افرائیم اور منسّی روبن اور شمعون کے برابر ہی میرے بیٹے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","اگر اِن کے بعد تیرے ہاں اَور بیٹے پیدا ہو جائیں تو وہ میرے بیٹے نہیں بلکہ تیرے ٹھہریں گے۔ جو میراث وہ پائیں گے وہ اُنہیں افرائیم اور منسّی کی میراث میں سے ملے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","مَیں یہ تیری ماں راخل کے سبب سے کر رہا ہوں جو مسوپتامیہ سے واپسی کے وقت کنعان میں اِفراتہ کے قریب مر گئی۔ مَیں نے اُسے وہیں راستے میں دفن کیا“ (آج اِفراتہ کو بیت لحم کہا جاتا ہے)۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","پھر یعقوب نے یوسف کے بیٹوں پر نظر ڈال کر پوچھا، ”یہ کون ہیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","یوسف نے جواب دیا، ”یہ میرے بیٹے ہیں جو اللہ نے مجھے یہاں مصر میں دیئے۔“ یعقوب نے کہا، ”اُنہیں میرے قریب لے آ تاکہ مَیں اُنہیں برکت دوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","بوڑھا ہونے کے سبب سے یعقوب کی آنکھیں کمزور تھیں۔ وہ اچھی طرح دیکھ نہیں سکتا تھا۔ یوسف اپنے بیٹوں کو یعقوب کے پاس لے آیا تو اُس نے اُنہیں بوسہ دے کر گلے لگایا ");
INSERT INTO urdgvu_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","اور یوسف سے کہا، ”مجھے توقع ہی نہیں تھی کہ مَیں کبھی تیرا چہرہ دیکھوں گا، اور اب اللہ نے مجھے تیرے بیٹوں کو دیکھنے کا موقع بھی دیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","پھر یوسف اُنہیں یعقوب کی گود میں سے لے کر خود اُس کے سامنے منہ کے بل جھک گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","یوسف نے افرائیم کو یعقوب کے بائیں ہاتھ رکھا اور منسّی کو اُس کے دائیں ہاتھ۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","لیکن یعقوب نے اپنا دہنا ہاتھ بائیں طرف بڑھا کر افرائیم کے سر پر رکھا اگرچہ وہ چھوٹا تھا۔ اِس طرح اُس نے اپنا بایاں ہاتھ دائیں طرف بڑھا کر منسّی کے سر پر رکھا جو بڑا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","پھر اُس نے یوسف کو اُس کے بیٹوں کی معرفت برکت دی، ”اللہ جس کے حضور میرے باپ دادا ابراہیم اور اسحاق چلتے رہے اور جو شروع سے آج تک میرا چرواہا رہا ہے اِنہیں برکت دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","جس فرشتے نے عوضانہ دے کر مجھے ہر نقصان سے بچایا ہے وہ اِنہیں برکت دے۔ اللہ کرے کہ اِن میں میرا نام اور میرے باپ دادا ابراہیم اور اسحاق کے نام جیتے رہیں۔ دنیا میں اِن کی اولاد کی تعداد بہت بڑھ جائے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","جب یوسف نے دیکھا کہ باپ نے اپنا دہنا ہاتھ چھوٹے بیٹے افرائیم کے سر پر رکھا ہے تو یہ اُسے بُرا لگا، اِس لئے اُس نے باپ کا ہاتھ پکڑا تاکہ اُسے افرائیم کے سر پر سے اُٹھا کر منسّی کے سر پر رکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","اُس نے کہا، ”ابو، ایسے نہیں۔ دوسرا لڑکا بڑا ہے۔ اُسی پر اپنا دہنا ہاتھ رکھیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","لیکن باپ نے انکار کر کے کہا، ”مجھے پتا ہے بیٹا، مجھے پتا ہے۔ وہ بھی ایک بڑی قوم بنے گا۔ پھر بھی اُس کا چھوٹا بھائی اُس سے بڑا ہو گا اور اُس سے قوموں کی بڑی تعداد نکلے گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","اُس دن اُس نے دونوں بیٹوں کو برکت دے کر کہا، ”اسرائیلی تمہارا نام لے کر برکت دیا کریں گے۔ جب وہ برکت دیں گے تو کہیں گے، ’اللہ آپ کے ساتھ ویسا کرے جیسا اُس نے افرائیم اور منسّی کے ساتھ کیا ہے‘۔“ اِس طرح یعقوب نے افرائیم کو منسّی سے بڑا بنا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","یوسف سے اُس نے کہا، ”مَیں تو مرنے والا ہوں، لیکن اللہ تمہارے ساتھ ہو گا اور تمہیں تمہارے باپ دادا کے ملک میں واپس لے جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ایک بات میں مَیں تجھے تیرے بھائیوں پر ترجیح دیتا ہوں، مَیں تجھے کنعان میں وہ قطعہ دیتا ہوں جو مَیں نے اپنی تلوار اور کمان سے اموریوں سے چھینا تھا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","یعقوب نے اپنے بیٹوں کو بُلا کر کہا، ”میرے پاس جمع ہو جاؤ تاکہ مَیں تمہیں بتاؤں کہ مستقبل میں تمہارے ساتھ کیاکیا ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","اے یعقوب کے بیٹو، اکٹھے ہو کر سنو، اپنے باپ اسرائیل کی باتوں پر غور کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","روبن، تم میرے پہلوٹھے ہو، میرے زور اور میری طاقت کا پہلا پھل۔ تم عزت اور قوت کے لحاظ سے برتر ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","لیکن چونکہ تم بےقابو سیلاب کی مانند ہو اِس لئے تمہاری اوّل حیثیت جاتی رہے۔ کیونکہ تم نے میری حرم سے ہم بستر ہو کر اپنے باپ کی بےحرمتی کی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","شمعون اور لاوی دونوں بھائیوں کی تلواریں ظلم و تشدد کے ہتھیار رہے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","میری جان نہ اُن کی مجلس میں شامل اور نہ اُن کی جماعت میں داخل ہو، کیونکہ اُنہوں نے غصے میں آ کر دوسروں کو قتل کیا ہے، اُنہوں نے اپنی مرضی سے بَیلوں کی کونچیں کاٹی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","اُن کے غصے پر لعنت ہو جو اِتنا زبردست ہے اور اُن کے طیش پر جو اِتنا سخت ہے۔ مَیں اُنہیں یعقوب کے ملک میں تتر بتر کروں گا، اُنہیں اسرائیل میں منتشر کر دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","یہوداہ، تمہارے بھائی تمہاری تعریف کریں گے۔ تم اپنے دشمنوں کی گردن پکڑے رہو گے، اور تمہارے باپ کے بیٹے تمہارے سامنے جھک جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","یہوداہ شیرببر کا بچہ ہے۔ میرے بیٹے، تم ابھی ابھی شکار مار کر واپس آئے ہو۔ یہوداہ شیرببر بلکہ شیرنی کی طرح دبک کر بیٹھ جاتا ہے۔ کون اُسے چھیڑنے کی جرأت کرے گا؟ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","شاہی عصا یہوداہ سے دُور نہیں ہو گا بلکہ شاہی اختیار اُس وقت تک اُس کی اولاد کے پاس رہے گا جب تک وہ حاکم نہ آئے جس کے تابع قومیں رہیں گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","وہ اپنا جوان گدھا انگور کی بیل سے اور اپنی گدھی کا بچہ بہترین انگور کی بیل سے باندھے گا۔ وہ اپنا لباس مَے میں اور اپنا کپڑا انگور کے خون میں دھوئے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","اُس کی آنکھیں مَے سے زیادہ گدلی اور اُس کے دانت دودھ سے زیادہ سفید ہوں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","زبولون ساحل پر آباد ہو گا جہاں بحری جہاز ہوں گے۔ اُس کی حد صیدا تک ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","اِشکار طاقت ور گدھا ہے جو اپنے زِین کے دو بوروں کے درمیان بیٹھا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","جب وہ دیکھے گا کہ اُس کی آرام گاہ اچھی اور اُس کا ملک خوش نما ہے تو وہ بوجھ اُٹھانے کے لئے تیار ہو جائے گا اور اُجرت کے بغیر کام کرنے کے لئے مجبور کیا جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","دان اپنی قوم کا انصاف کرے گا اگرچہ وہ اسرائیل کے قبیلوں میں سے ایک ہی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","دان سڑک کے سانپ اور راستے کے افعی کی مانند ہو گا۔ وہ گھوڑے کی ایڑیوں کو کاٹے گا تو اُس کا سوار پیچھے گر جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","اے رب، مَیں تیری ہی نجات کے انتظار میں ہوں! ");
INSERT INTO urdgvu_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","جد پر ڈاکوؤں کا جتھا حملہ کرے گا، لیکن وہ پلٹ کر اُسی پر حملہ کر دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","آشر کو غذائیت والی خوراک حاصل ہو گی۔ وہ لذیذ شاہی کھانا مہیا کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","نفتالی آزاد چھوڑی ہوئی ہرنی ہے۔ وہ خوب صورت باتیں کرتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","یوسف پھل دار بیل ہے۔ وہ چشمے پر لگی ہوئی پھل دار بیل ہے جس کی شاخیں دیوار پر چڑھ گئی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","تیراندازوں نے اُس پر تیر چلا کر اُسے تنگ کیا اور اُس کے پیچھے پڑ گئے، ");
INSERT INTO urdgvu_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","لیکن اُس کی کمان مضبوط رہی، اور اُس کے بازو یعقوب کے زورآور خدا کے سبب سے طاقت ور رہے، اُس چرواہے کے سبب سے جو اسرائیل کا زبردست سورما ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","کیونکہ تیرے باپ کا خدا تیری مدد کرتا ہے، اللہ قادرِ مطلق تجھے آسمان کی برکت، زمین کی گہرائیوں کی برکت اور اولاد کی برکت دیتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","تیرے باپ کی برکت قدیم پہاڑوں اور ابدی پہاڑیوں کی مرغوب چیزوں سے زیادہ عظیم ہے۔ یہ تمام برکت یوسف کے سر پر ہو، اُس شخص کے چاند پر جو اپنے بھائیوں پر شہزادہ ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","بن یمین پھاڑنے والا بھیڑیا ہے۔ صبح وہ اپنا شکار کھا جاتا اور رات کو اپنا لُوٹا ہوا مال تقسیم کر دیتا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","یہ اسرائیل کے کُل بارہ قبیلے ہیں۔ اور یہ وہ کچھ ہے جو اُن کے باپ نے اُن سے برکت دیتے وقت کہا۔ اُس نے ہر ایک کو اُس کی اپنی برکت دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","پھر یعقوب نے اپنے بیٹوں کو حکم دیا، ”اب مَیں کوچ کر کے اپنے باپ دادا سے جا ملوں گا۔ مجھے میرے باپ دادا کے ساتھ اُس غار میں دفنانا جو حِتّی آدمی عِفرون کے کھیت میں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","یعنی اُس غار میں جو ملکِ کنعان میں ممرے کے مشرق میں مکفیلہ کے کھیت میں ہے۔ ابراہیم نے اُسے کھیت سمیت اپنے لوگوں کو دفنانے کے لئے عِفرون حِتّی سے خرید لیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","وہاں ابراہیم اور اُس کی بیوی سارہ دفنائے گئے، وہاں اسحاق اور اُس کی بیوی رِبقہ دفنائے گئے اور وہاں مَیں نے لیاہ کو دفن کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","وہ کھیت اور اُس کا غار حِتّیوں سے خریدا گیا تھا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","اِن ہدایات کے بعد یعقوب نے اپنے پاؤں بستر پر سمیٹ لئے اور دم چھوڑ کر اپنے باپ دادا سے جا ملا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","یوسف اپنے باپ کے چہرے سے لپٹ گیا۔ اُس نے روتے ہوئے اُسے بوسہ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","اُس کے ملازموں میں سے کچھ ڈاکٹر تھے۔ اُس نے اُنہیں ہدایت دی کہ میرے باپ اسرائیل کی لاش کو حنوط کریں تاکہ وہ گل نہ جائے۔ اُنہوں نے ایسا ہی کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","اِس میں 40 دن لگ گئے۔ عام طور پر حنوط کرنے کے لئے اِتنے ہی دن لگتے ہیں۔ مصریوں نے 70 دن تک یعقوب کا ماتم کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","جب ماتم کا وقت ختم ہوا تو یوسف نے بادشاہ کے درباریوں سے کہا، ”مہربانی کر کے یہ خبر بادشاہ تک پہنچا دیں ");
INSERT INTO urdgvu_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","کہ میرے باپ نے مجھے قَسم دلا کر کہا تھا، ’مَیں مرنے والا ہوں۔ مجھے اُس قبر میں دفن کرنا جو مَیں نے ملکِ کنعان میں اپنے لئے بنوائی۔‘ اب مجھے اجازت دیں کہ مَیں وہاں جاؤں اور اپنے باپ کو دفن کر کے واپس آؤں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","فرعون نے جواب دیا، ”جا، اپنے باپ کو دفن کر جس طرح اُس نے تجھے قَسم دلائی تھی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","چنانچہ یوسف اپنے باپ کو دفنانے کے لئے کنعان روانہ ہوا۔ بادشاہ کے تمام ملازم، محل کے بزرگ اور پورے مصر کے بزرگ اُس کے ساتھ تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","یوسف کے گھرانے کے افراد، اُس کے بھائی اور اُس کے باپ کے گھرانے کے لوگ بھی ساتھ گئے۔ صرف اُن کے بچے، اُن کی بھیڑبکریاں اور گائےبَیل جشن میں رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","رتھ اور گھڑسوار بھی ساتھ گئے۔ سب مل کر بڑا لشکر بن گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","جب وہ یردن کے قریب اتد کے کھلیان پر پہنچے تو اُنہوں نے نہایت دلسوز نوحہ کیا۔ وہاں یوسف نے سات دن تک اپنے باپ کا ماتم کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","جب مقامی کنعانیوں نے اتد کے کھلیان پر ماتم کا یہ نظارہ دیکھا تو اُنہوں نے کہا، ”یہ تو ماتم کا بہت بڑا انتظام ہے جو مصری کروا رہے ہیں۔“ اِس لئے اُس جگہ کا نام ابیل مصریم یعنی ’مصریوں کا ماتم‘ پڑ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","یوں یعقوب کے بیٹوں نے اپنے باپ کا حکم پورا کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","اُنہوں نے اُسے ملکِ کنعان میں لے جا کر مکفیلہ کے کھیت کے غار میں دفن کیا جو ممرے کے مشرق میں ہے۔ یہ وہی کھیت ہے جو ابراہیم نے عِفرون حِتّی سے اپنے لوگوں کو دفنانے کے لئے خریدا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","اِس کے بعد یوسف، اُس کے بھائی اور باقی تمام لوگ جو جنازے کے لئے ساتھ گئے تھے مصر کو لوٹ آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","جب یعقوب انتقال کر گیا تو یوسف کے بھائی ڈر گئے۔ اُنہوں نے کہا، ”خطرہ ہے کہ اب یوسف ہمارا تعاقب کر کے اُس غلط کام کا بدلہ لے جو ہم نے اُس کے ساتھ کیا تھا۔ پھر کیا ہو گا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","یہ سوچ کر اُنہوں نے یوسف کو خبر بھیجی، ”آپ کے باپ نے مرنے سے پیشتر ہدایت دی ");
INSERT INTO urdgvu_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","کہ یوسف کو بتانا، ’اپنے بھائیوں کے اُس غلط کام کو معاف کر دینا جو اُنہوں نے تمہارے ساتھ کیا۔‘ اب ہمیں جو آپ کے باپ کے خدا کے پیروکار ہیں معاف کر دیں۔“ یہ خبر سن کر یوسف رو پڑا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","پھر اُس کے بھائی خود آئے اور اُس کے سامنے گر گئے۔ اُنہوں نے کہا، ”ہم آپ کے خادم ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","لیکن یوسف نے کہا، ”مت ڈرو۔ کیا مَیں اللہ کی جگہ ہوں؟ ہرگز نہیں! ");
INSERT INTO urdgvu_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","تم نے مجھے نقصان پہنچانے کا ارادہ کیا تھا، لیکن اللہ نے اُس سے بھلائی پیدا کی۔ اور اب اِس کا مقصد پورا ہو رہا ہے۔ بہت سے لوگ موت سے بچ رہے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","چنانچہ اب ڈرنے کی ضرورت نہیں ہے۔ مَیں تمہیں اور تمہارے بچوں کو خوراک مہیا کرتا رہوں گا۔“ یوں یوسف نے اُنہیں تسلی دی اور اُن سے نرمی سے بات کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","یوسف اپنے باپ کے خاندان سمیت مصر میں رہا۔ وہ 110 سال زندہ رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","موت سے پہلے اُس نے نہ صرف افرائیم کے بچوں کو بلکہ اُس کے پوتوں کو بھی دیکھا۔ منسّی کے بیٹے مکیر کے بچے بھی اُس کی موجودگی میں پیدا ہو کر اُس کی گود میں رکھے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","پھر ایک وقت آیا کہ یوسف نے اپنے بھائیوں سے کہا، ”مَیں مرنے والا ہوں۔ لیکن اللہ ضرور آپ کی دیکھ بھال کر کے آپ کو اِس ملک سے اُس ملک میں لے جائے گا جس کا اُس نے ابراہیم، اسحاق اور یعقوب سے قَسم کھا کر وعدہ کیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","پھر یوسف نے اسرائیلیوں کو قَسم دلا کر کہا، ”اللہ یقیناً تمہاری دیکھ بھال کر کے وہاں لے جائے گا۔ اُس وقت میری ہڈیوں کو بھی اُٹھا کر ساتھ لے جانا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","پھر یوسف فوت ہو گیا۔ وہ 110 سال کا تھا۔ اُسے حنوط کر کے مصر میں ایک تابوت میں رکھا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ذیل میں اُن بیٹوں کے نام ہیں جو اپنے باپ یعقوب اور اپنے خاندانوں سمیت مصر میں آئے تھے: ");
INSERT INTO urdgvu_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","روبن، شمعون، لاوی، یہوداہ، ");
INSERT INTO urdgvu_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","اِشکار، زبولون، بن یمین، ");
INSERT INTO urdgvu_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","دان، نفتالی، جد اور آشر۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","اُس وقت یعقوب کی اولاد کی تعداد 70 تھی۔ یوسف تو پہلے ہی مصر آ چکا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","مصر میں رہتے ہوئے بہت دن گزر گئے۔ اِتنے میں یوسف، اُس کے تمام بھائی اور اُس نسل کے تمام لوگ مر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","اسرائیلی پھلے پھولے اور تعداد میں بہت بڑھ گئے۔ نتیجے میں وہ نہایت ہی طاقت ور ہو گئے۔ پورا ملک اُن سے بھر گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ہوتے ہوتے ایک نیا بادشاہ تخت نشین ہوا جو یوسف سے ناواقف تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","اُس نے اپنے لوگوں سے کہا، ”اسرائیلیوں کو دیکھو۔ وہ تعداد اور طاقت میں ہم سے بڑھ گئے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","آؤ، ہم حکمت سے کام لیں، ورنہ وہ مزید بڑھ جائیں گے۔ ایسا نہ ہو کہ وہ کسی جنگ کے موقع پر دشمن کا ساتھ دے کر ہم سے لڑیں اور ملک کو چھوڑ جائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","چنانچہ مصریوں نے اسرائیلیوں پر نگران مقرر کئے تاکہ بیگار میں اُن سے کام کروا کر اُنہیں دباتے رہیں۔ اُس وقت اُنہوں نے پتوم اور رعمسیس کے شہر تعمیر کئے۔ اِن شہروں میں فرعون بادشاہ کے بڑے بڑے گودام تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","لیکن جتنا اسرائیلیوں کو دبایا گیا اُتنا ہی وہ تعداد میں بڑھتے اور پھیلتے گئے۔ آخرکار مصری اُن سے دہشت کھانے لگے، ");
INSERT INTO urdgvu_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","اور وہ بڑی بےرحمی سے اُن سے کام کرواتے رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","اسرائیلیوں کا گزارہ نہایت مشکل ہو گیا۔ اُنہیں گارا تیار کر کے اینٹیں بنانا اور کھیتوں میں مختلف قسم کے کام کرنا پڑے۔ اِس میں مصری اُن سے بڑی بےرحمی سے پیش آتے رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","اسرائیلیوں کی دو دائیاں تھیں جن کے نام سِفرہ اور فوعہ تھے۔ مصر کے بادشاہ نے اُن سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","”جب عبرانی عورتیں تمہیں مدد کے لئے بُلائیں تو خبردار رہو۔ اگر لڑکا پیدا ہو تو اُسے جان سے مار دو، اگر لڑکی ہو تو اُسے جیتا چھوڑ دو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","لیکن دائیاں اللہ کا خوف مانتی تھیں۔ اُنہوں نے مصر کے بادشاہ کا حکم نہ مانا بلکہ لڑکوں کو بھی جینے دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","تب مصر کے بادشاہ نے اُنہیں دوبارہ بُلا کر پوچھا، ”تم نے یہ کیوں کیا؟ تم لڑکوں کو کیوں جیتا چھوڑ دیتی ہو؟“ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","اُنہوں نے جواب دیا، ”عبرانی عورتیں مصری عورتوں سے زیادہ مضبوط ہیں۔ بچے ہمارے پہنچنے سے پہلے ہی پیدا ہو جاتے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","چنانچہ اللہ نے دائیوں کو برکت دی، اور اسرائیلی قوم تعداد میں بڑھ کر بہت طاقت ور ہو گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","اور چونکہ دائیاں اللہ کا خوف مانتی تھیں اِس لئے اُس نے اُنہیں اولاد دے کر اُن کے خاندانوں کو قائم رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","آخرکار بادشاہ نے اپنے تمام ہم وطنوں سے بات کی، ”جب بھی عبرانیوں کے لڑکے پیدا ہوں تو اُنہیں دریائے نیل میں پھینک دینا۔ صرف لڑکیوں کو زندہ رہنے دو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","اُن دنوں میں لاوی کے ایک آدمی نے اپنے ہی قبیلے کی ایک عورت سے شادی کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","عورت حاملہ ہوئی اور بچہ پیدا ہوا۔ ماں نے دیکھا کہ لڑکا خوب صورت ہے، اِس لئے اُس نے اُسے تین ماہ تک چھپائے رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","جب وہ اُسے اَور زیادہ نہ چھپا سکی تو اُس نے آبی نرسل سے ٹوکری بنا کر اُس پر تارکول چڑھایا۔ پھر اُس نے بچے کو ٹوکری میں رکھ کر ٹوکری کو دریائے نیل کے کنارے پر اُگے ہوئے سرکنڈوں میں رکھ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","بچے کی بہن کچھ فاصلے پر کھڑی دیکھتی رہی کہ اُس کا کیا بنے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","اُس وقت فرعون کی بیٹی نہانے کے لئے دریا پر آئی۔ اُس کی نوکرانیاں دریا کے کنارے ٹہلنے لگیں۔ تب اُس نے سرکنڈوں میں ٹوکری دیکھی اور اپنی لونڈی کو اُسے لانے بھیجا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","اُسے کھولا تو چھوٹا لڑکا دکھائی دیا جو رو رہا تھا۔ فرعون کی بیٹی کو اُس پر ترس آیا۔ اُس نے کہا، ”یہ کوئی عبرانی بچہ ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","اب بچے کی بہن فرعون کی بیٹی کے پاس گئی اور پوچھا، ”کیا مَیں بچے کو دودھ پلانے کے لئے کوئی عبرانی عورت ڈھونڈ لاؤں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","فرعون کی بیٹی نے کہا، ”ہاں، جاؤ۔“ لڑکی چلی گئی اور بچے کی سگی ماں کو لے کر واپس آئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","فرعون کی بیٹی نے ماں سے کہا، ”بچے کو لے جاؤ اور اُسے میرے لئے دودھ پلایا کرو۔ مَیں تمہیں اِس کا معاوضہ دوں گی۔“ چنانچہ بچے کی ماں نے اُسے دودھ پلانے کے لئے لے لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","جب بچہ بڑا ہوا تو اُس کی ماں اُسے فرعون کی بیٹی کے پاس لے گئی، اور وہ اُس کا بیٹا بن گیا۔ فرعون کی بیٹی نے اُس کا نام موسیٰ یعنی ’نکالا گیا‘ رکھ کر کہا، ”مَیں اُسے پانی سے نکال لائی ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","جب موسیٰ جوان ہوا تو ایک دن وہ گھر سے نکل کر اپنے لوگوں کے پاس گیا جو جبری کام میں مصروف تھے۔ موسیٰ نے دیکھا کہ ایک مصری میرے ایک عبرانی بھائی کو مار رہا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","موسیٰ نے چاروں طرف نظر دوڑائی۔ جب معلوم ہوا کہ کوئی نہیں دیکھ رہا تو اُس نے مصری کو جان سے مار دیا اور اُسے ریت میں چھپا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","اگلے دن بھی موسیٰ گھر سے نکلا۔ اِس دفعہ دو عبرانی مرد آپس میں لڑ رہے تھے۔ جو غلطی پر تھا اُس سے موسیٰ نے پوچھا، ”تم اپنے بھائی کو کیوں مار رہے ہو؟“ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","آدمی نے جواب دیا، ”کس نے آپ کو ہم پر حکمران اور قاضی مقرر کیا ہے؟ کیا آپ مجھے بھی قتل کرنا چاہتے ہیں جس طرح مصری کو مار ڈالا تھا؟“ تب موسیٰ ڈر گیا۔ اُس نے سوچا، ”ہائے، میرا بھید کھل گیا ہے!“ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","بادشاہ کو بھی پتا لگا تو اُس نے موسیٰ کو مروانے کی کوشش کی۔ لیکن موسیٰ مِدیان کے ملک کو بھاگ گیا۔ وہاں وہ ایک کنوئیں کے پاس بیٹھ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","مِدیان میں ایک امام تھا جس کی سات بیٹیاں تھیں۔ یہ لڑکیاں اپنی بھیڑبکریوں کو پانی پلانے کے لئے کنوئیں پر آئیں اور پانی نکال کر حوض بھرنے لگیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","لیکن کچھ چرواہوں نے آ کر اُنہیں بھگا دیا۔ یہ دیکھ کر موسیٰ اُٹھا اور لڑکیوں کو چرواہوں سے بچا کر اُن کے ریوڑ کو پانی پلایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","جب لڑکیاں اپنے باپ رعوایل کے پاس واپس آئیں تو باپ نے پوچھا، ”آج تم اِتنی جلدی سے کیوں واپس آ گئی ہو؟“ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","لڑکیوں نے جواب دیا، ”ایک مصری آدمی نے ہمیں چرواہوں سے بچایا۔ نہ صرف یہ بلکہ اُس نے ہمارے لئے پانی بھی نکال کر ریوڑ کو پلا دیا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","رعوایل نے کہا، ”وہ آدمی کہاں ہے؟ تم اُسے کیوں چھوڑ کر آئی ہو؟ اُسے بُلاؤ تاکہ وہ ہمارے ساتھ کھانا کھائے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","موسیٰ رعوایل کے گھر میں ٹھہرنے کے لئے راضی ہو گیا۔ بعد میں اُس کی شادی رعوایل کی بیٹی صفورہ سے ہوئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","صفورہ کے بیٹا پیدا ہوا تو موسیٰ نے کہا، ”اِس کا نام جَیرسوم یعنی ’اجنبی ملک میں پردیسی‘ ہو، کیونکہ مَیں اجنبی ملک میں پردیسی ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","کافی عرصہ گزر گیا۔ اِتنے میں مصر کا بادشاہ انتقال کر گیا۔ اسرائیلی اپنی غلامی تلے کراہتے اور مدد کے لئے پکارتے رہے، اور اُن کی چیخیں اللہ تک پہنچ گئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","اللہ نے اُن کی آہیں سنیں اور اُس عہد کو یاد کیا جو اُس نے ابراہیم، اسحاق اور یعقوب سے باندھا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","اللہ اسرائیلیوں کی حالت دیکھ کر اُن کا خیال کرنے لگا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","موسیٰ اپنے سُسر یترو کی بھیڑبکریوں کی نگہبانی کرتا تھا (مِدیان کا امام رعوایل یترو بھی کہلاتا تھا)۔ ایک دن موسیٰ ریوڑ کو ریگستان کی پرلی جانب لے گیا اور چلتے چلتے اللہ کے پہاڑ حورب یعنی سینا تک پہنچ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","وہاں رب کا فرشتہ آگ کے شعلے میں اُس پر ظاہر ہوا۔ یہ شعلہ ایک جھاڑی میں بھڑک رہا تھا۔ موسیٰ نے دیکھا کہ جھاڑی جل رہی ہے لیکن بھسم نہیں ہو رہی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","موسیٰ نے سوچا، ”یہ تو عجیب بات ہے۔ کیا وجہ ہے کہ جلتی ہوئی جھاڑی بھسم نہیں ہو رہی؟ مَیں ذرا وہاں جا کر یہ حیرت انگیز منظر دیکھوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","جب رب نے دیکھا کہ موسیٰ جھاڑی کو دیکھنے آ رہا ہے تو اُس نے اُسے جھاڑی میں سے پکارا، ”موسیٰ، موسیٰ!“ موسیٰ نے کہا، ”جی، مَیں حاضر ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","رب نے کہا، ”اِس سے زیادہ قریب نہ آنا۔ اپنی جوتیاں اُتار، کیونکہ تُو مُقدّس زمین پر کھڑا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","مَیں تیرے باپ کا خدا، ابراہیم کا خدا، اسحاق کا خدا اور یعقوب کا خدا ہوں۔“ یہ سن کر موسیٰ نے اپنا منہ ڈھانک لیا، کیونکہ وہ اللہ کو دیکھنے سے ڈرا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","رب نے کہا، ”مَیں نے مصر میں اپنی قوم کی بُری حالت دیکھی اور غلامی میں اُن کی چیخیں سنی ہیں، اور مَیں اُن کے دُکھوں کو خوب جانتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","اب مَیں اُنہیں مصریوں کے قابو سے بچانے کے لئے اُتر آیا ہوں۔ مَیں اُنہیں مصر سے نکال کر ایک اچھے وسیع ملک میں لے جاؤں گا، ایک ایسے ملک میں جہاں دودھ اور شہد کی کثرت ہے، گو اِس وقت کنعانی، حِتّی، اموری، فرِزّی، حِوّی اور یبوسی اُس میں رہتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","اسرائیلیوں کی چیخیں مجھ تک پہنچی ہیں۔ مَیں نے دیکھا ہے کہ مصری اُن پر کس طرح کا ظلم ڈھا رہے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","چنانچہ اب جا۔ مَیں تجھے فرعون کے پاس بھیجتا ہوں، کیونکہ تجھے میری قوم اسرائیل کو مصر سے نکال کر لانا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","لیکن موسیٰ نے اللہ سے کہا، ”مَیں کون ہوں کہ فرعون کے پاس جا کر اسرائیلیوں کو مصر سے نکال لاؤں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","اللہ نے کہا، ”مَیں تو تیرے ساتھ ہوں گا۔ اور اِس کا ثبوت کہ مَیں تجھے بھیج رہا ہوں یہ ہو گا کہ لوگوں کے مصر سے نکلنے کے بعد تم یہاں آ کر اِس پہاڑ پر میری عبادت کرو گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","لیکن موسیٰ نے اعتراض کیا، ”اگر مَیں اسرائیلیوں کے پاس جا کر اُنہیں بتاؤں کہ تمہارے باپ دادا کے خدا نے مجھے تمہارے پاس بھیجا ہے تو وہ پوچھیں گے، ’اُس کا نام کیا ہے؟‘ پھر مَیں اُن کو کیا جواب دوں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","اللہ نے کہا، ”مَیں جو ہوں سو مَیں ہوں۔ اُن سے کہنا، ’مَیں ہوں نے مجھے تمہارے پاس بھیجا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","رب جو تمہارے باپ دادا کا خدا، ابراہیم کا خدا، اسحاق کا خدا اور یعقوب کا خدا ہے اُسی نے مجھے تمہارے پاس بھیجا ہے۔‘ یہ ابد تک میرا نام رہے گا۔ لوگ یہی نام لے کر مجھے نسل در نسل یاد کریں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","اب جا اور اسرائیل کے بزرگوں کو جمع کر کے اُن کو بتا دے کہ رب تمہارے باپ دادا ابراہیم، اسحاق اور یعقوب کا خدا مجھ پر ظاہر ہوا ہے۔ وہ فرماتا ہے، ’مَیں نے خوب دیکھ لیا ہے کہ مصر میں تمہارے ساتھ کیا سلوک ہو رہا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","اِس لئے مَیں نے فیصلہ کیا ہے کہ تمہیں مصر کی مصیبت سے نکال کر کنعانیوں، حِتّیوں، اموریوں، فرِزّیوں، حِوّیوں اور یبوسیوں کے ملک میں لے جاؤں، ایسے ملک میں جہاں دودھ اور شہد کی کثرت ہے۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","بزرگ تیری سنیں گے۔ پھر اُن کے ساتھ مصر کے بادشاہ کے پاس جا کر اُس سے کہنا، ’رب عبرانیوں کا خدا ہم پر ظاہر ہوا ہے۔ اِس لئے ہمیں اجازت دیں کہ ہم تین دن کا سفر کر کے ریگستان میں رب اپنے خدا کے لئے قربانیاں چڑھائیں۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","لیکن مجھے معلوم ہے کہ مصر کا بادشاہ صرف اِس صورت میں تمہیں جانے دے گا کہ کوئی زبردستی تمہیں لے جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","اِس لئے مَیں اپنی قدرت ظاہر کر کے اپنے معجزوں کی معرفت مصریوں کو ماروں گا۔ پھر وہ تمہیں جانے دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","اُس وقت مَیں مصریوں کے دلوں کو تمہارے لئے نرم کر دوں گا۔ تمہیں خالی ہاتھ نہیں جانا پڑے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","تمام عبرانی عورتیں اپنی مصری پڑوسنوں اور اپنے گھر میں رہنے والی مصری عورتوں سے چاندی اور سونے کے زیورات اور نفیس کپڑے مانگ کر اپنے بچوں کو پہنائیں گی۔ یوں مصریوں کو لُوٹ لیا جائے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","موسیٰ نے اعتراض کیا، ”لیکن اسرائیلی نہ میری بات کا یقین کریں گے، نہ میری سنیں گے۔ وہ تو کہیں گے، ’رب تم پر ظاہر نہیں ہوا‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","جواب میں رب نے موسیٰ سے کہا، ”تُو نے ہاتھ میں کیا پکڑا ہوا ہے؟“ موسیٰ نے کہا، ”لاٹھی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","رب نے کہا، ”اُسے زمین پر ڈال دے۔“ موسیٰ نے ایسا کیا تو لاٹھی سانپ بن گئی، اور موسیٰ ڈر کر بھاگا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","رب نے کہا، ”اب سانپ کی دُم کو پکڑ لے۔“ موسیٰ نے ایسا کیا تو سانپ پھر لاٹھی بن گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","رب نے کہا، ”یہ دیکھ کر لوگوں کو یقین آئے گا کہ رب جو اُن کے باپ دادا کا خدا، ابراہیم کا خدا، اسحاق کا خدا اور یعقوب کا خدا ہے تجھ پر ظاہر ہوا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","اب اپنا ہاتھ اپنے لباس میں ڈال دے۔“ موسیٰ نے ایسا کیا۔ جب اُس نے اپنا ہاتھ نکالا تو وہ برف کی مانند سفید ہو گیا تھا۔ کوڑھ جیسی بیماری لگ گئی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","تب رب نے کہا، ”اب اپنا ہاتھ دوبارہ اپنے لباس میں ڈال۔“ موسیٰ نے ایسا کیا۔ جب اُس نے اپنا ہاتھ دوبارہ نکالا تو وہ پھر صحت مند تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","رب نے کہا، ”اگر لوگوں کو پہلا معجزہ دیکھ کر یقین نہ آئے اور وہ تیری نہ سنیں تو شاید اُنہیں دوسرا معجزہ دیکھ کر یقین آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","اگر اُنہیں پھر بھی یقین نہ آئے اور وہ تیری نہ سنیں تو دریائے نیل سے کچھ پانی نکال کر اُسے خشک زمین پر اُنڈیل دے۔ یہ پانی زمین پر گرتے ہی خون بن جائے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","لیکن موسیٰ نے کہا، ”میرے آقا، مَیں معذرت چاہتا ہوں، مَیں اچھی طرح بات نہیں کر سکتا بلکہ مَیں کبھی بھی یہ لیاقت نہیں رکھتا تھا۔ اِس وقت بھی جب مَیں تجھ سے بات کر رہا ہوں میری یہی حالت ہے۔ مَیں رُک رُک کر بولتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","رب نے کہا، ”کس نے انسان کا منہ بنایا؟ کون ایک کو گونگا اور دوسرے کو بہرا بنا دیتا ہے؟ کون ایک کو دیکھنے کی قابلیت دیتا ہے اور دوسرے کو اِس سے محروم رکھتا ہے؟ کیا مَیں جو رب ہوں یہ سب کچھ نہیں کرتا؟ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","اب جا! تیرے بولتے وقت مَیں خود تیرے ساتھ ہوں گا اور تجھے وہ کچھ سکھاؤں گا جو تجھے کہنا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","لیکن موسیٰ نے التجا کی، ”میرے آقا، مہربانی کر کے کسی اَور کو بھیج دے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","تب رب موسیٰ سے سخت خفا ہوا۔ اُس نے کہا، ”کیا تیرا لاوی بھائی ہارون ایسے کام کے لئے حاضر نہیں ہے؟ مَیں جانتا ہوں کہ وہ اچھی طرح بول سکتا ہے۔ دیکھ، وہ تجھ سے ملنے کے لئے نکل چکا ہے۔ تجھے دیکھ کر وہ نہایت خوش ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","اُسے وہ کچھ بتا جو اُسے کہنا ہے۔ تمہارے بولتے وقت مَیں تیرے اور اُس کے ساتھ ہوں گا اور تمہیں وہ کچھ سکھاؤں گا جو تمہیں کرنا ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ہارون تیری جگہ قوم سے بات کرے گا جبکہ تُو میری طرح اُسے وہ کچھ بتائے گا جو اُسے کہنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","لیکن یہ لاٹھی بھی ساتھ لے جانا، کیونکہ اِسی کے ذریعے تُو یہ معجزے کرے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","پھر موسیٰ اپنے سُسر یترو کے گھر واپس چلا گیا۔ اُس نے کہا، ”مجھے ذرا اپنے عزیزوں کے پاس واپس جانے دیں جو مصر میں ہیں۔ مَیں معلوم کرنا چاہتا ہوں کہ وہ ابھی تک زندہ ہیں کہ نہیں۔“ یترو نے جواب دیا، ”ٹھیک ہے، سلامتی سے جائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","موسیٰ ابھی مِدیان میں تھا کہ رب نے اُس سے کہا، ”مصر کو واپس چلا جا، کیونکہ جو آدمی تجھے قتل کرنا چاہتے تھے وہ مر گئے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","چنانچہ موسیٰ اپنی بیوی اور بیٹوں کو گدھے پر سوار کر کے مصر کو لوٹنے لگا۔ اللہ کی لاٹھی اُس کے ہاتھ میں تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","رب نے اُس سے یہ بھی کہا، ”مصر جا کر فرعون کے سامنے وہ تمام معجزے دکھا جن کا مَیں نے تجھے اختیار دیا ہے۔ لیکن میرے کہنے پر وہ اَڑا رہے گا۔ وہ اسرائیلیوں کو جانے کی اجازت نہیں دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","اُس وقت فرعون کو بتا دینا، ’رب فرماتا ہے کہ اسرائیل میرا پہلوٹھا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","مَیں تجھے بتا چکا ہوں کہ میرے بیٹے کو جانے دے تاکہ وہ میری عبادت کرے۔ اگر تُو میرے بیٹے کو جانے سے منع کرے تو مَیں تیرے پہلوٹھے کو جان سے مار دوں گا‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ایک دن جب موسیٰ اپنے خاندان کے ساتھ راستے میں کسی سرائے میں ٹھہرا ہوا تھا تو رب نے اُس پر حملہ کر کے اُسے مار دینے کی کوشش کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","یہ دیکھ کر صفورہ نے ایک تیز پتھر سے اپنے بیٹے کا ختنہ کیا اور کاٹے ہوئے حصے سے موسیٰ کے پیر چھوئے۔ اُس نے کہا، ”یقیناً تم میرے خونی دُولھا ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","تب اللہ نے موسیٰ کو چھوڑ دیا۔ صفورہ نے اُسے ختنے کے باعث ہی ’خونی دُولھا‘ کہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","رب نے ہارون سے بھی بات کی، ”ریگستان میں موسیٰ سے ملنے جا۔“ ہارون چل پڑا اور اللہ کے پہاڑ کے پاس موسیٰ سے ملا۔ اُس نے اُسے بوسہ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","موسیٰ نے ہارون کو سب کچھ سنا دیا جو رب نے اُسے کہنے کے لئے بھیجا تھا۔ اُس نے اُسے اُن معجزوں کے بارے میں بھی بتایا جو اُسے دکھانے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","پھر دونوں مل کر مصر گئے۔ وہاں پہنچ کر اُنہوں نے اسرائیل کے تمام بزرگوں کو جمع کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","ہارون نے اُنہیں وہ تمام باتیں سنائیں جو رب نے موسیٰ کو بتائی تھیں۔ اُس نے مذکورہ معجزے بھی لوگوں کے سامنے دکھائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","پھر اُنہیں یقین آیا۔ اور جب اُنہوں نے سنا کہ رب کو تمہارا خیال ہے اور وہ تمہاری مصیبت سے آگاہ ہے تو اُنہوں نے رب کو سجدہ کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","پھر موسیٰ اور ہارون فرعون کے پاس گئے۔ اُنہوں نے کہا، ”رب اسرائیل کا خدا فرماتا ہے، ’میری قوم کو ریگستان میں جانے دے تاکہ وہ میرے لئے عید منائیں‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","فرعون نے جواب دیا، ”یہ رب کون ہے؟ مَیں کیوں اُس کا حکم مان کر اسرائیلیوں کو جانے دوں؟ نہ مَیں رب کو جانتا ہوں، نہ اسرائیلیوں کو جانے دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ہارون اور موسیٰ نے کہا، ”عبرانیوں کا خدا ہم پر ظاہر ہوا ہے۔ اِس لئے مہربانی کر کے ہمیں اجازت دیں کہ ریگستان میں تین دن کا سفر کر کے رب اپنے خدا کے حضور قربانیاں پیش کریں۔ کہیں وہ ہمیں کسی بیماری یا تلوار سے نہ مارے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","لیکن مصر کے بادشاہ نے انکار کیا، ”موسیٰ اور ہارون، تم لوگوں کو کام سے کیوں روک رہے ہو؟ جاؤ، جو کام ہم نے تم کو دیا ہے اُس پر لگ جاؤ! ");
INSERT INTO urdgvu_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","اسرائیلی ویسے بھی تعداد میں بہت بڑھ گئے ہیں، اور تم اُنہیں کام کرنے سے روک رہے ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","اُسی دن فرعون نے مصری نگرانوں اور اُن کے تحت کے اسرائیلی نگرانوں کو حکم دیا، ");
INSERT INTO urdgvu_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","”اب سے اسرائیلیوں کو اینٹیں بنانے کے لئے بھوسا مت دینا، بلکہ وہ خود جا کر بھوسا جمع کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","توبھی وہ اُتنی ہی اینٹیں بنائیں جتنی پہلے بناتے تھے۔ وہ سُست ہو گئے ہیں اور اِسی لئے چیخ رہے ہیں کہ ہمیں جانے دیں تاکہ اپنے خدا کو قربانیاں پیش کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","اُن سے اَور زیادہ سخت کام کراؤ، اُنہیں کام میں لگائے رکھو۔ اُن کے پاس اِتنا وقت ہی نہ ہو کہ وہ جھوٹی باتوں پر دھیان دیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","مصری نگران اور اُن کے تحت کے اسرائیلی نگرانوں نے لوگوں کے پاس جا کر اُن سے کہا، ”فرعون کا حکم ہے کہ تمہیں بھوسا نہ دیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","اِس لئے خود جاؤ اور بھوسا ڈھونڈ کر جمع کرو۔ لیکن خبردار! اُتنی ہی اینٹیں بناؤ جتنی پہلے بناتے تھے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","یہ سن کر اسرائیلی بھوسا جمع کرنے کے لئے پورے ملک میں پھیل گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","مصری نگران یہ کہہ کر اُن پر دباؤ ڈالتے رہے کہ اُتنی اینٹیں بناؤ جتنی پہلے بناتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","جو اسرائیلی نگران اُنہوں نے مقرر کئے تھے اُنہیں وہ پیٹتے اور کہتے رہے، ”تم نے کل اور آج اُتنی اینٹیں کیوں نہیں بنوائیں جتنی پہلے بنواتے تھے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","پھر اسرائیلی نگران فرعون کے پاس گئے۔ اُنہوں نے شکایت کر کے کہا، ”آپ اپنے خادموں کے ساتھ ایسا سلوک کیوں کر رہے ہیں؟ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ہمیں بھوسا نہیں دیا جا رہا اور ساتھ ساتھ یہ کہا گیا ہے کہ اُتنی اینٹیں بناؤ جتنی پہلے بناتے تھے۔ نتیجے میں ہمیں مارا پیٹا بھی جا رہا ہے حالانکہ ایسا کرنے میں آپ کے اپنے لوگ غلطی پر ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","فرعون نے جواب دیا، ”تم لوگ سُست ہو، تم کام کرنا نہیں چاہتے۔ اِس لئے تم یہ جگہ چھوڑنا اور رب کو قربانیاں پیش کرنا چاہتے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","اب جاؤ، کام کرو۔ تمہیں بھوسا نہیں دیا جائے گا، لیکن خبردار! اُتنی ہی اینٹیں بناؤ جتنی پہلے بناتے تھے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","جب اسرائیلی نگرانوں کو بتایا گیا کہ اینٹوں کی مطلوبہ تعداد کم نہ کرو تو وہ سمجھ گئے کہ ہم پھنس گئے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","فرعون کے محل سے نکل کر اُن کی ملاقات موسیٰ اور ہارون سے ہوئی جو اُن کے انتظار میں تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","اُنہوں نے موسیٰ اور ہارون سے کہا، ”رب خود آپ کی عدالت کرے۔ کیونکہ آپ کے سبب سے فرعون اور اُس کے ملازموں کو ہم سے گھن آتی ہے۔ آپ نے اُنہیں ہمیں مار دینے کا موقع دے دیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","یہ سن کر موسیٰ رب کے پاس واپس آیا اور کہا، ”اے آقا، تُو نے اِس قوم سے ایسا بُرا سلوک کیوں کیا؟ کیا تُو نے اِسی مقصد سے مجھے یہاں بھیجا ہے؟ ");
INSERT INTO urdgvu_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","جب سے مَیں نے فرعون کے پاس جا کر اُسے تیری مرضی بتائی ہے وہ اسرائیلی قوم سے بُرا سلوک کر رہا ہے۔ اور تُو نے اب تک اُنہیں بچانے کا کوئی قدم نہیں اُٹھایا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","رب نے جواب دیا، ”اب تُو دیکھے گا کہ مَیں فرعون کے ساتھ کیا کچھ کرتا ہوں۔ میری عظیم قدرت کا تجربہ کر کے وہ میرے لوگوں کو جانے دے گا بلکہ اُنہیں جانے پر مجبور کرے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","اللہ نے موسیٰ سے یہ بھی کہا، ”مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","مَیں ابراہیم، اسحاق اور یعقوب پر ظاہر ہوا۔ وہ میرے نام اللہ قادرِ مطلق سے واقف ہوئے، لیکن مَیں نے اُن پر اپنے نام رب کا انکشاف نہیں کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","مَیں نے اُن سے عہد کر کے وعدہ کیا کہ اُنہیں ملکِ کنعان دوں گا جس میں وہ اجنبی کے طور پر رہتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","اب مَیں نے سنا ہے کہ اسرائیلی کس طرح مصریوں کی غلامی میں کراہ رہے ہیں، اور مَیں نے اپنا عہد یاد کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","چنانچہ اسرائیلیوں کو بتانا، ’مَیں رب ہوں۔ مَیں تمہیں مصریوں کے جوئے سے آزاد کروں گا اور اُن کی غلامی سے بچاؤں گا۔ مَیں بڑی قدرت کے ساتھ تمہیں چھڑاؤں گا اور اُن کی عدالت کروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","مَیں تمہیں اپنی قوم بناؤں گا اور تمہارا خدا ہوں گا۔ تب تم جان لو گے کہ مَیں رب تمہارا خدا ہوں جس نے تمہیں مصریوں کے جوئے سے آزاد کر دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","مَیں تمہیں اُس ملک میں لے جاؤں گا جس کا وعدہ مَیں نے قَسم کھا کر ابراہیم، اسحاق اور یعقوب سے کیا ہے۔ وہ ملک تمہاری اپنی ملکیت ہو گا۔ مَیں رب ہوں‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","موسیٰ نے یہ سب کچھ اسرائیلیوں کو بتا دیا، لیکن اُنہوں نے اُس کی بات نہ مانی، کیونکہ وہ سخت کام کے باعث ہمت ہار گئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","تب رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","”جا، مصر کے بادشاہ فرعون کو بتا دینا کہ اسرائیلیوں کو اپنے ملک سے جانے دے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","لیکن موسیٰ نے اعتراض کیا، ”اسرائیلی میری بات سننا نہیں چاہتے تو فرعون کیوں میری بات مانے جبکہ مَیں رُک رُک کر بولتا ہوں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","لیکن رب نے موسیٰ اور ہارون کو حکم دیا، ”اسرائیلیوں اور مصر کے بادشاہ فرعون سے بات کر کے اسرائیلیوں کو مصر سے نکالو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","اسرائیل کے آبائی گھرانوں کے سربراہ یہ تھے: اسرائیل کے پہلوٹھے روبن کے چار بیٹے حنوک، فلّو، حصرون اور کرمی تھے۔ اِن سے روبن کی چار شاخیں نکلیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","شمعون کے پانچ بیٹے یموایل، یمین، اُہد، یکین، صُحر اور ساؤل تھے۔ (ساؤل کنعانی عورت کا بچہ تھا)۔ اِن سے شمعون کی پانچ شاخیں نکلیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","لاوی کے تین بیٹے جَیرسون، قِہات اور مِراری تھے۔ (لاوی 137 سال کی عمر میں فوت ہوا)۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","جَیرسون کے دو بیٹے لِبنی اور سِمعی تھے۔ اِن سے جَیرسون کی دو شاخیں نکلیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","قِہات کے چار بیٹے عمرام، اِضہار، حبرون اور عُزی ایل تھے۔ (قِہات 133 سال کی عمر میں فوت ہوا)۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","مِراری کے دو بیٹے محلی اور مُوشی تھے۔ اِن سب سے لاوی کی مختلف شاخیں نکلیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","عمرام نے اپنی پھوپھی یوکبد سے شادی کی۔ اُن کے دو بیٹے ہارون اور موسیٰ پیدا ہوئے۔ (عمرام 137 سال کی عمر میں فوت ہوا)۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","اِضہار کے تین بیٹے قورح، نفج اور زِکری تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","عُزی ایل کے تین بیٹے میسائیل، اِلصَفن اور سِتری تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ہارون نے اِلیسَبع سے شادی کی۔ (اِلیسَبع عمی نداب کی بیٹی اور نحسون کی بہن تھی)۔ اُن کے چار بیٹے ندب، ابیہو، اِلی عزر اور اِتمر تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","قورح کے تین بیٹے اسّیر، اِلقانہ اور ابی آسف تھے۔ اُن سے قورحیوں کی تین شاخیں نکلیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ہارون کے بیٹے اِلی عزر نے فوطی ایل کی ایک بیٹی سے شادی کی۔ اُن کا ایک بیٹا فینحاس تھا۔ یہ سب لاوی کے آبائی گھرانوں کے سربراہ تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","رب نے عمرام کے دو بیٹوں ہارون اور موسیٰ کو حکم دیا کہ میری قوم کو اُس کے خاندانوں کی ترتیب کے مطابق مصر سے نکالو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","اِن ہی دو آدمیوں نے مصر کے بادشاہ فرعون سے بات کی کہ اسرائیلیوں کو مصر سے جانے دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","مصر میں رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","”مَیں رب ہوں۔ مصر کے بادشاہ کو وہ سب کچھ بتا دینا جو مَیں تجھے بتاتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","موسیٰ نے اعتراض کیا، ”مَیں تو رُک رُک کر بولتا ہوں۔ فرعون کس طرح میری بات مانے گا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","لیکن رب نے کہا، ”دیکھ، میرے کہنے پر تُو فرعون کے لئے اللہ کی حیثیت رکھے گا اور تیرا بھائی ہارون تیرا پیغمبر ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","جو بھی حکم مَیں تجھے دوں گا اُسے تُو ہارون کو بتا دے۔ پھر وہ سب کچھ فرعون کو بتائے تاکہ وہ اسرائیلیوں کو اپنے ملک سے جانے دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","لیکن مَیں فرعون کو اَڑ جانے دوں گا۔ اگرچہ مَیں مصر میں بہت سے نشانوں اور معجزوں سے اپنی قدرت کا مظاہرہ کروں گا ");
INSERT INTO urdgvu_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","توبھی فرعون تمہاری نہیں سنے گا۔ تب مصریوں پر میرا ہاتھ بھاری ہو جائے گا، اور مَیں اُن کو سخت سزا دے کر اپنی قوم اسرائیل کو خاندانوں کی ترتیب کے مطابق مصر سے نکال لاؤں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","جب مَیں مصر کے خلاف اپنی قدرت کا اظہار کر کے اسرائیلیوں کو وہاں سے نکالوں گا تو مصری جان لیں گے کہ مَیں رب ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","موسیٰ اور ہارون نے سب کچھ ویسا ہی کیا جیسا رب نے اُنہیں حکم دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","فرعون سے بات کرتے وقت موسیٰ 80 سال کا اور ہارون 83 سال کا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","رب نے موسیٰ اور ہارون سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","”جب فرعون تمہیں معجزہ دکھانے کو کہے گا تو موسیٰ ہارون سے کہے کہ اپنی لاٹھی زمین پر ڈال دے۔ اِس پر وہ سانپ بن جائے گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","موسیٰ اور ہارون نے فرعون کے پاس جا کر ایسا ہی کیا۔ ہارون نے اپنی لاٹھی فرعون اور اُس کے عہدیداروں کے سامنے ڈال دی تو وہ سانپ بن گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","یہ دیکھ کر فرعون نے اپنے عالِموں اور جادوگروں کو بُلایا۔ جادوگروں نے بھی اپنے جادو سے ایسا ہی کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ہر ایک نے اپنی لاٹھی زمین پر پھینکی تو وہ سانپ بن گئی۔ لیکن ہارون کی لاٹھی نے اُن کی لاٹھیوں کو نگل لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","تاہم فرعون اِس سے متاثر نہ ہوا۔ اُس نے موسیٰ اور ہارون کی بات سننے سے انکار کیا۔ ویسا ہی ہوا جیسا رب نے کہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","پھر رب نے موسیٰ سے کہا، ”فرعون اَڑ گیا ہے۔ وہ میری قوم کو مصر چھوڑنے سے روکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","کل صبح سویرے جب وہ دریائے نیل پر آئے گا تو اُس سے ملنے کے لئے دریا کے کنارے پر کھڑے ہو جانا۔ اُس لاٹھی کو تھامے رکھنا جو سانپ بن گئی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","جب وہ وہاں پہنچے تو اُس سے کہنا، ’رب عبرانیوں کے خدا نے مجھے آپ کو یہ بتانے کے لئے بھیجا ہے کہ میری قوم کو میری عبادت کرنے کے لئے ریگستان میں جانے دے۔ لیکن آپ نے ابھی تک اُس کی نہیں سنی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","چنانچہ اب آپ جان لیں گے کہ وہ رب ہے۔ مَیں اِس لاٹھی کو جو میرے ہاتھ میں ہے لے کر دریائے نیل کے پانی کو ماروں گا۔ پھر وہ خون میں بدل جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","دریائے نیل کی مچھلیاں مر جائیں گی، دریا سے بدبو اُٹھے گی اور مصری دریا کا پانی نہیں پی سکیں گے‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","رب نے موسیٰ سے کہا، ”ہارون کو بتا دینا کہ وہ اپنی لاٹھی لے کر اپنا ہاتھ اُن تمام جگہوں کی طرف بڑھائے جہاں پانی جمع ہوتا ہے۔ تب مصر کی تمام ندیوں، نہروں، جوہڑوں اور تالابوں کا پانی خون میں بدل جائے گا۔ پورے ملک میں خون ہی خون ہو گا، یہاں تک کہ لکڑی اور پتھر کے برتنوں کا پانی بھی خون میں بدل جائے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","چنانچہ موسیٰ اور ہارون نے فرعون اور اُس کے عہدیداروں کے سامنے اپنی لاٹھی اُٹھا کر دریائے نیل کے پانی پر ماری۔ اِس پر دریا کا سارا پانی خون میں بدل گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","دریا کی مچھلیاں مر گئیں، اور اُس سے اِتنی بدبو اُٹھنے لگی کہ مصری اُس کا پانی نہ پی سکے۔ مصر میں چاروں طرف خون ہی خون تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","لیکن جادوگروں نے بھی اپنے جادو کے ذریعے ایسا ہی کیا۔ اِس لئے فرعون اَڑ گیا اور موسیٰ اور ہارون کی بات نہ مانی۔ ویسا ہی ہوا جیسا رب نے کہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","فرعون پلٹ کر اپنے گھر واپس چلا گیا۔ اُسے اُس کی پروا نہیں تھی جو موسیٰ اور ہارون نے کیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","لیکن مصری دریا سے پانی نہ پی سکے، اور اُنہوں نے پینے کا پانی حاصل کرنے کے لئے دریا کے کنارے کنارے گڑھے کھودے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","پانی کے بدل جانے کے بعد سات دن گزر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","پھر رب نے موسیٰ سے کہا، ”فرعون کے پاس جا کر اُسے بتا دینا کہ رب فرماتا ہے، ’میری قوم کو میری عبادت کرنے کے لئے جانے دے، ");
INSERT INTO urdgvu_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ورنہ مَیں پورے مصر کو مینڈکوں سے سزا دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","دریائے نیل مینڈکوں سے اِتنا بھر جائے گا کہ وہ دریا سے نکل کر تیرے محل، تیرے سونے کے کمرے اور تیرے بستر میں جا گھسیں گے۔ وہ تیرے عہدیداروں اور تیری رعایا کے گھروں میں آئیں گے بلکہ تیرے تنوروں اور آٹا گوندھنے کے برتنوں میں بھی پُھدکتے پھریں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","مینڈک تجھ پر، تیری قوم پر اور تیرے عہدیداروں پر چڑھ جائیں گے‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","رب نے موسیٰ سے کہا، ”ہارون کو بتا دینا کہ وہ اپنی لاٹھی کو ہاتھ میں لے کر اُسے دریاؤں، نہروں اور جوہڑوں کے اوپر اُٹھائے تاکہ مینڈک باہر نکل کر مصر کے ملک میں پھیل جائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","ہارون نے ملکِ مصر کے پانی کے اوپر اپنی لاٹھی اُٹھائی تو مینڈکوں کے غول پانی سے نکل کر پورے ملک پر چھا گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","لیکن جادوگروں نے بھی اپنے جادو سے ایسا ہی کیا۔ وہ بھی دریا سے مینڈک نکال لائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","فرعون نے موسیٰ اور ہارون کو بُلا کر کہا، ”رب سے دعا کرو کہ وہ مجھ سے اور میری قوم سے مینڈکوں کو دُور کرے۔ پھر مَیں تمہاری قوم کو جانے دوں گا تاکہ وہ رب کو قربانیاں پیش کریں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","موسیٰ نے جواب دیا، ”وہ وقت مقرر کریں جب مَیں آپ کے عہدیداروں اور آپ کی قوم کے لئے دعا کروں۔ پھر جو مینڈک آپ کے پاس اور آپ کے گھروں میں ہیں اُسی وقت ختم ہو جائیں گے۔ مینڈک صرف دریا میں پائے جائیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","فرعون نے کہا، ”ٹھیک ہے، کل اُنہیں ختم کرو۔“ موسیٰ نے کہا، ”جیسا آپ کہتے ہیں ویسا ہی ہو گا۔ اِس طرح آپ کو معلوم ہو گا کہ ہمارے خدا کی مانند کوئی نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","مینڈک آپ، آپ کے گھروں، آپ کے عہدیداروں اور آپ کی قوم کو چھوڑ کر صرف دریا میں رہ جائیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","موسیٰ اور ہارون فرعون کے پاس سے چلے گئے، اور موسیٰ نے رب سے منت کی کہ وہ مینڈکوں کے وہ غول دُور کرے جو اُس نے فرعون کے خلاف بھیجے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","رب نے اُس کی دعا سنی۔ گھروں، صحنوں اور کھیتوں میں مینڈک مر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","لوگوں نے اُنہیں جمع کر کے اُن کے ڈھیر لگا دیئے۔ اُن کی بدبو پورے ملک میں پھیل گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","لیکن جب فرعون نے دیکھا کہ مسئلہ حل ہو گیا ہے تو وہ پھر اکڑ گیا اور اُن کی نہ سنی۔ یوں رب کی بات درست نکلی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","پھر رب نے موسیٰ سے کہا، ”ہارون سے کہنا کہ وہ اپنی لاٹھی سے زمین کی گرد کو مارے۔ جب وہ ایسا کرے گا تو پورے مصر کی گرد جوؤں میں بدل جائے گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","اُنہوں نے ایسا ہی کیا۔ ہارون نے اپنی لاٹھی سے زمین کی گرد کو مارا تو پورے ملک کی گرد جوؤں میں بدل گئی۔ اُن کے غول جانوروں اور آدمیوں پر چھا گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","جادوگروں نے بھی اپنے جادو سے ایسا کرنے کی کوشش کی، لیکن وہ گرد سے جوئیں نہ بنا سکے۔ جوئیں آدمیوں اور جانوروں پر چھا گئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","جادوگروں نے فرعون سے کہا، ”اللہ کی قدرت نے یہ کیا ہے۔“ لیکن فرعون نے اُن کی نہ سنی۔ یوں رب کی بات درست نکلی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","پھر رب نے موسیٰ سے کہا، ”جب فرعون صبح سویرے دریا پر جائے تو تُو اُس کے راستے میں کھڑا ہو جانا۔ اُسے کہنا کہ رب فرماتا ہے، ’میری قوم کو جانے دے تاکہ وہ میری عبادت کر سکیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ورنہ مَیں تیرے اور تیرے عہدیداروں کے پاس، تیری قوم کے پاس اور تیرے گھروں میں کاٹنے والی مکھیاں بھیج دوں گا۔ مصریوں کے گھر مکھیوں سے بھر جائیں گے بلکہ جس زمین پر وہ کھڑے ہیں وہ بھی مکھیوں سے ڈھانکی جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","لیکن اُس وقت مَیں اپنی قوم کے ساتھ جو جشن میں رہتی ہے فرق سلوک کروں گا۔ وہاں ایک بھی کاٹنے والی مکھی نہیں ہو گی۔ اِس طرح تجھے پتا لگے گا کہ اِس ملک میں مَیں ہی رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","مَیں اپنی قوم اور تیری قوم میں امتیاز کروں گا۔ کل ہی میری قدرت کا اظہار ہو گا‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","رب نے ایسا ہی کیا۔ کاٹنے والی مکھیوں کے غول فرعون کے محل، اُس کے عہدیداروں کے گھروں اور پورے مصر میں پھیل گئے۔ ملک کا ستیاناس ہو گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","پھر فرعون نے موسیٰ اور ہارون کو بُلا کر کہا، ”چلو، اِسی ملک میں اپنے خدا کو قربانیاں پیش کرو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","لیکن موسیٰ نے کہا، ”یہ مناسب نہیں ہے۔ جو قربانیاں ہم رب اپنے خدا کو پیش کریں گے وہ مصریوں کی نظر میں گھناؤنی ہیں۔ اگر ہم یہاں ایسا کریں تو کیا وہ ہمیں سنگسار نہیں کریں گے؟ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","اِس لئے لازم ہے کہ ہم تین دن کا سفر کر کے ریگستان میں ہی رب اپنے خدا کو قربانیاں پیش کریں جس طرح اُس نے ہمیں حکم بھی دیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","فرعون نے جواب دیا، ”ٹھیک ہے، مَیں تمہیں جانے دوں گا تاکہ تم ریگستان میں رب اپنے خدا کو قربانیاں پیش کرو۔ لیکن تمہیں زیادہ دُور نہیں جانا ہے۔ اور میرے لئے بھی دعا کرنا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","موسیٰ نے کہا، ”ٹھیک، مَیں جاتے ہی رب سے دعا کروں گا۔ کل ہی مکھیاں فرعون، اُس کے عہدیداروں اور اُس کی قوم سے دُور ہو جائیں گی۔ لیکن ہمیں دوبارہ فریب نہ دینا بلکہ ہمیں جانے دینا تاکہ ہم رب کو قربانیاں پیش کر سکیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","پھر موسیٰ فرعون کے پاس سے چلا گیا اور رب سے دعا کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","رب نے موسیٰ کی دعا سنی۔ کاٹنے والی مکھیاں فرعون، اُس کے عہدیداروں اور اُس کی قوم سے دُور ہو گئیں۔ ایک بھی مکھی نہ رہی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","لیکن فرعون پھر اکڑ گیا۔ اُس نے اسرائیلیوں کو جانے نہ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","پھر رب نے موسیٰ سے کہا، ”فرعون کے پاس جا کر اُسے بتا کہ رب عبرانیوں کا خدا فرماتا ہے، ’میری قوم کو جانے دے تاکہ وہ میری عبادت کر سکیں۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","اگر آپ انکار کریں اور اُنہیں روکتے رہیں ");
INSERT INTO urdgvu_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","تو رب اپنی قدرت کا اظہار کر کے آپ کے مویشیوں میں بھیانک وبا پھیلا دے گا جو آپ کے گھوڑوں، گدھوں، اونٹوں، گائےبَیلوں، بھیڑبکریوں اور مینڈھوں میں پھیل جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","لیکن رب اسرائیل اور مصر کے مویشیوں میں امتیاز کرے گا۔ اسرائیلیوں کا ایک بھی جانور نہیں مرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","رب نے فیصلہ کر لیا ہے کہ وہ کل ہی ایسا کرے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","اگلے دن رب نے ایسا ہی کیا۔ مصر کے تمام مویشی مر گئے، لیکن اسرائیلیوں کا ایک بھی جانور نہ مرا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","فرعون نے کچھ لوگوں کو اُن کے پاس بھیج دیا تو پتا چلا کہ ایک بھی جانور نہیں مرا۔ تاہم فرعون اَڑا رہا۔ اُس نے اسرائیلیوں کو جانے نہ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","پھر رب نے موسیٰ اور ہارون سے کہا، ”اپنی مٹھیاں کسی بھٹی کی راکھ سے بھر کر فرعون کے پاس جاؤ۔ پھر موسیٰ فرعون کے سامنے یہ راکھ ہَوا میں اُڑا دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","یہ راکھ باریک دُھول کا بادل بن جائے گی جو پورے ملک پر چھا جائے گا۔ اُس کے اثر سے لوگوں اور جانوروں کے جسموں پر پھوڑے پھنسیاں پھوٹ نکلیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","موسیٰ اور ہارون نے ایسا ہی کیا۔ وہ کسی بھٹی سے راکھ لے کر فرعون کے سامنے کھڑے ہو گئے۔ موسیٰ نے راکھ کو ہَوا میں اُڑا دیا تو انسانوں اور جانوروں کے جسموں پر پھوڑے پھنسیاں نکل آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","اِس مرتبہ جادوگر موسیٰ کے سامنے کھڑے بھی نہ ہو سکے کیونکہ اُن کے جسموں پر بھی پھوڑے نکل آئے تھے۔ تمام مصریوں کا یہی حال تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","لیکن رب نے فرعون کو ضدی بنائے رکھا، اِس لئے اُس نے موسیٰ اور ہارون کی نہ سنی۔ یوں ویسا ہی ہوا جیسا رب نے موسیٰ کو بتایا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","اِس کے بعد رب نے موسیٰ سے کہا، ”صبح سویرے اُٹھ اور فرعون کے سامنے کھڑے ہو کر اُسے بتا کہ رب عبرانیوں کا خدا فرماتا ہے، ’میری قوم کو جانے دے تاکہ وہ میری عبادت کر سکیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ورنہ مَیں اپنی تمام آفتیں تجھ پر، تیرے عہدیداروں پر اور تیری قوم پر آنے دوں گا۔ پھر تُو جان لے گا کہ تمام دنیا میں مجھ جیسا کوئی نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","اگر مَیں چاہتا تو اپنی قدرت سے ایسی وبا پھیلا سکتا کہ تجھے اور تیری قوم کو دنیا سے مٹا دیا جاتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","لیکن مَیں نے تجھے اِس لئے برپا کیا ہے کہ تجھ پر اپنی قدرت کا اظہار کروں اور یوں تمام دنیا میں میرے نام کا پرچار کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","تُو ابھی تک اپنے آپ کو سرفراز کر کے میری قوم کے خلاف ہے اور اُنہیں جانے نہیں دیتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","اِس لئے کل مَیں اِسی وقت بھیانک قسم کے اولوں کا طوفان بھیج دوں گا۔ مصری قوم کی ابتدا سے لے کر آج تک مصر میں اولوں کا ایسا طوفان کبھی نہیں آیا ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","اپنے بندوں کو ابھی بھیجنا تاکہ وہ تیرے مویشیوں کو اور کھیتوں میں پڑے تیرے مال کو لا کر محفوظ کر لیں۔ کیونکہ جو بھی کھلے میدان میں رہے گا وہ اولوں سے مر جائے گا، خواہ انسان ہو یا حیوان‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","فرعون کے کچھ عہدیدار رب کا پیغام سن کر ڈر گئے اور بھاگ کر اپنے جانوروں اور غلاموں کو گھروں میں لے آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","لیکن دوسروں نے رب کے پیغام کی پروا نہ کی۔ اُن کے جانور اور غلام باہر کھلے میدان میں رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","رب نے موسیٰ سے کہا، ”اپنا ہاتھ آسمان کی طرف بڑھا دے۔ پھر مصر کے تمام انسانوں، جانوروں اور کھیتوں کے پودوں پر اولے پڑیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","موسیٰ نے اپنی لاٹھی آسمان کی طرف اُٹھائی تو رب نے ایک زبردست طوفان بھیج دیا۔ اولے پڑے، بجلی گری اور بادل گرجتے رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","اولے پڑتے رہے اور بجلی چمکتی رہی۔ مصری قوم کی ابتدا سے لے کر اب تک ایسے خطرناک اولے کبھی نہیں پڑے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","انسانوں سے لے کر حیوانوں تک کھیتوں میں سب کچھ برباد ہو گیا۔ اولوں نے کھیتوں میں تمام پودے اور درخت بھی توڑ دیئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","وہ صرف جشن کے علاقے میں نہ پڑے جہاں اسرائیلی آباد تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","تب فرعون نے موسیٰ اور ہارون کو بُلایا۔ اُس نے کہا، ”اِس مرتبہ مَیں نے گناہ کیا ہے۔ رب حق پر ہے۔ مجھ سے اور میری قوم سے غلطی ہوئی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","اولے اور اللہ کی گرجتی آوازیں حد سے زیادہ ہیں۔ رب سے دعا کرو تاکہ اولے رُک جائیں۔ اب مَیں تمہیں جانے دوں گا۔ اب سے تمہیں یہاں رہنا نہیں پڑے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","موسیٰ نے فرعون سے کہا، ”مَیں شہر سے نکل کر دونوں ہاتھ رب کی طرف اُٹھا کر دعا کروں گا۔ پھر گرج اور اولے رُک جائیں گے اور آپ جان لیں گے کہ پوری دنیا رب کی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","لیکن مَیں جانتا ہوں کہ آپ اور آپ کے عہدیدار ابھی تک رب خدا کا خوف نہیں مانتے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","اُس وقت سَن کے پھول نکل چکے تھے اور جَو کی بالیں لگ گئی تھیں۔ اِس لئے یہ فصلیں تباہ ہو گئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","لیکن گیہوں اور ایک اَور قسم کی گندم جو بعد میں پکتی ہے برباد نہ ہوئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","موسیٰ فرعون کو چھوڑ کر شہر سے نکلا۔ اُس نے رب کی طرف اپنے ہاتھ اُٹھائے تو گرج، اولے اور بارش کا طوفان رُک گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","جب فرعون نے دیکھا کہ طوفان ختم ہو گیا ہے تو وہ اور اُس کے عہدیدار دوبارہ گناہ کر کے اکڑ گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","فرعون اَڑا رہا اور اسرائیلیوں کو جانے نہ دیا۔ ویسا ہی ہوا جیسا رب نے موسیٰ سے کہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","پھر رب نے موسیٰ سے کہا، ”فرعون کے پاس جا، کیونکہ مَیں نے اُس کا اور اُس کے درباریوں کا دل سخت کر دیا ہے تاکہ اُن کے درمیان اپنے معجزوں اور اپنی قدرت کا اظہار کر سکوں ");
INSERT INTO urdgvu_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","اور تم اپنے بیٹے بیٹیوں اور پوتے پوتیوں کو سنا سکو کہ مَیں نے مصریوں کے ساتھ کیا سلوک کیا ہے اور اُن کے درمیان کس طرح کے معجزے کر کے اپنی قدرت کا اظہار کیا ہے۔ یوں تم جان لو گے کہ مَیں رب ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","موسیٰ اور ہارون فرعون کے پاس گئے۔ اُنہوں نے اُس سے کہا، ”رب عبرانیوں کے خدا کا فرمان ہے، ’تُو کب تک میرے سامنے ہتھیار ڈالنے سے انکار کرے گا؟ میری قوم کو میری عبادت کرنے کے لئے جانے دے، ");
INSERT INTO urdgvu_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ورنہ مَیں کل تیرے ملک میں ٹڈیاں لاؤں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","اُن کے غول زمین پر یوں چھا جائیں گے کہ زمین نظر ہی نہیں آئے گی۔ جو کچھ اولوں نے تباہ نہیں کیا اُسے وہ چٹ کر جائیں گی۔ بچے ہوئے درختوں کے پتے بھی ختم ہو جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","تیرے محل، تیرے عہدیداروں اور باقی لوگوں کے گھر اُن سے بھر جائیں گے۔ جب سے مصری اِس ملک میں آباد ہوئے ہیں تم نے کبھی ٹڈیوں کا ایسا سخت حملہ نہیں دیکھا ہو گا‘۔“ یہ کہہ کر موسیٰ پلٹ کر وہاں سے چلا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","اِس پر درباریوں نے فرعون سے بات کی، ”ہم کب تک اِس مرد کے جال میں پھنسے رہیں؟ اسرائیلیوں کو رب اپنے خدا کی عبادت کرنے کے لئے جانے دیں۔ کیا آپ کو ابھی تک معلوم نہیں کہ مصر برباد ہو گیا ہے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","تب موسیٰ اور ہارون کو فرعون کے پاس بُلایا گیا۔ اُس نے اُن سے کہا، ”جاؤ، اپنے خدا کی عبادت کرو۔ لیکن یہ بتاؤ کہ کون کون ساتھ جائے گا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","موسیٰ نے جواب دیا، ”ہمارے جوان اور بوڑھے ساتھ جائیں گے۔ ہم اپنے بیٹے بیٹیوں، بھیڑبکریوں اور گائےبَیلوں کو بھی ساتھ لے کر جائیں گے۔ ہم سب کے سب جائیں گے، کیونکہ ہمیں رب کی عید منانی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","فرعون نے طنزاً کہا، ”ٹھیک ہے، جاؤ اور رب تمہارے ساتھ ہو۔ نہیں، مَیں کس طرح تم سب کو بال بچوں سمیت جانے دے سکتا ہوں؟ تم نے کوئی بُرا منصوبہ بنایا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","نہیں، صرف مرد جا کر رب کی عبادت کر سکتے ہیں۔ تم نے تو یہی درخواست کی تھی۔“ تب موسیٰ اور ہارون کو فرعون کے سامنے سے نکال دیا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","پھر رب نے موسیٰ سے کہا، ”مصر پر اپنا ہاتھ اُٹھا تاکہ ٹڈیاں آ کر مصر کی سرزمین پر پھیل جائیں۔ جو کچھ بھی کھیتوں میں اولوں سے بچ گیا ہے اُسے وہ کھا جائیں گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","موسیٰ نے اپنی لاٹھی مصر پر اُٹھائی تو رب نے مشرق سے آندھی چلائی جو سارا دن اور ساری رات چلتی رہی اور اگلی صبح تک مصر میں ٹڈیاں پہنچائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","بےشمار ٹڈیاں پورے ملک پر حملہ کر کے ہر جگہ بیٹھ گئیں۔ اِس سے پہلے یا بعد میں کبھی بھی ٹڈیوں کا اِتنا سخت حملہ نہ ہوا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","اُنہوں نے زمین کو یوں ڈھانک لیا کہ وہ کالی نظر آنے لگی۔ جو کچھ بھی اولوں سے بچ گیا تھا چاہے کھیتوں کے پودے یا درختوں کے پھل تھے اُنہوں نے کھا لیا۔ مصر میں ایک بھی درخت یا پودا نہ رہا جس کے پتے بچ گئے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","تب فرعون نے موسیٰ اور ہارون کو جلدی سے بُلوایا۔ اُس نے کہا، ”مَیں نے تمہارے خدا کا اور تمہارا گناہ کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","اب ایک اَور مرتبہ میرا گناہ معاف کرو اور رب اپنے خدا سے دعا کرو تاکہ موت کی یہ حالت مجھ سے دُور ہو جائے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","موسیٰ نے محل سے نکل کر رب سے دعا کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","جواب میں رب نے ہَوا کا رُخ بدل دیا۔ اُس نے مغرب سے تیز آندھی چلائی جس نے ٹڈیوں کو اُڑا کر بحرِ قُلزم میں ڈال دیا۔ مصر میں ایک بھی ٹڈی نہ رہی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","لیکن رب نے ہونے دیا کہ فرعون پھر اَڑ گیا۔ اُس نے اسرائیلیوں کو جانے نہ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","اِس کے بعد رب نے موسیٰ سے کہا، ”اپنا ہاتھ آسمان کی طرف اُٹھا تو مصر پر اندھیرا چھا جائے گا۔ اِتنا اندھیرا ہو گا کہ بندہ اُسے چھو سکے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","موسیٰ نے اپنا ہاتھ آسمان کی طرف اُٹھایا تو تین دن تک مصر پر گہرا اندھیرا چھایا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","تین دن تک لوگ نہ ایک دوسرے کو دیکھ سکے، نہ کہیں جا سکے۔ لیکن جہاں اسرائیلی رہتے تھے وہاں روشنی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","تب فرعون نے موسیٰ کو پھر بُلوایا اور کہا، ”جاؤ، رب کی عبادت کرو! تم اپنے ساتھ بال بچوں کو بھی لے جا سکتے ہو۔ صرف اپنی بھیڑبکریاں اور گائےبَیل پیچھے چھوڑ دینا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","موسیٰ نے جواب دیا، ”کیا آپ ہی ہمیں قربانیوں کے لئے جانور دیں گے تاکہ اُنہیں رب اپنے خدا کو پیش کریں؟ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","یقیناً نہیں۔ اِس لئے لازم ہے کہ ہم اپنے جانوروں کو ساتھ لے کر جائیں۔ ایک کُھر بھی پیچھے نہیں چھوڑا جائے گا، کیونکہ ابھی تک ہمیں معلوم نہیں کہ رب کی عبادت کے لئے کن کن جانوروں کی ضرورت ہو گی۔ یہ اُس وقت ہی پتا چلے گا جب ہم منزلِ مقصود پر پہنچیں گے۔ اِس لئے ضروری ہے کہ ہم سب کو اپنے ساتھ لے کر جائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","لیکن رب کی مرضی کے مطابق فرعون اَڑ گیا۔ اُس نے اُنہیں جانے نہ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","اُس نے موسیٰ سے کہا، ”دفع ہو جا۔ خبردار! پھر کبھی اپنی شکل نہ دکھانا، ورنہ تجھے موت کے حوالے کر دیا جائے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","موسیٰ نے کہا، ”ٹھیک ہے، آپ کی مرضی۔ مَیں پھر کبھی آپ کے سامنے نہیں آؤں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","تب رب نے موسیٰ سے کہا، ”اب مَیں فرعون اور مصر پر آخری آفت لانے کو ہوں۔ اِس کے بعد وہ تمہیں جانے دے گا بلکہ تمہیں زبردستی نکال دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","اسرائیلیوں کو بتا دینا کہ ہر مرد اپنے پڑوسی اور ہر عورت اپنی پڑوسن سے سونے چاندی کی چیزیں مانگ لے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(رب نے مصریوں کے دل اسرائیلیوں کی طرف مائل کر دیئے تھے۔ وہ فرعون کے عہدیداروں سمیت خاص کر موسیٰ کی بڑی عزت کرتے تھے)۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","موسیٰ نے کہا، ”رب فرماتا ہے، ’آج آدھی رات کے وقت مَیں مصر میں سے گزروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","تب بادشاہ کے پہلوٹھے سے لے کر چکّی پیسنے والی نوکرانی کے پہلوٹھے تک مصریوں کا ہر پہلوٹھا مر جائے گا۔ چوپایوں کے پہلوٹھے بھی مر جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","مصر کی سرزمین پر ایسا رونا پیٹنا ہو گا کہ نہ ماضی میں کبھی ہوا، نہ مستقبل میں کبھی ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","لیکن اسرائیلی اور اُن کے جانور بچے رہیں گے۔ کُتا بھی اُن پر نہیں بھونکے گا۔ اِس طرح تم جان لو گے کہ رب اسرائیلیوں کی نسبت مصریوں سے فرق سلوک کرتا ہے‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","موسیٰ نے یہ کچھ فرعون کو بتایا پھر کہا، ”اُس وقت آپ کے تمام عہدیدار آ کر میرے سامنے جھک جائیں گے اور منت کریں گے، ’اپنے پیروکاروں کے ساتھ چلے جائیں۔‘ تب مَیں چلا ہی جاؤں گا۔“ یہ کہہ کر موسیٰ فرعون کے پاس سے چلا گیا۔ وہ بڑے غصے میں تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","رب نے موسیٰ سے کہا تھا، ”فرعون تمہاری نہیں سنے گا۔ کیونکہ لازم ہے کہ مَیں مصر میں اپنی قدرت کا مزید اظہار کروں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","گو موسیٰ اور ہارون نے فرعون کے سامنے یہ تمام معجزے دکھائے، لیکن رب نے فرعون کو ضدی بنائے رکھا، اِس لئے اُس نے اسرائیلیوں کو ملک چھوڑنے نہ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","پھر رب نے مصر میں موسیٰ اور ہارون سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","”اب سے یہ مہینہ تمہارے لئے سال کا پہلا مہینہ ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","اسرائیل کی پوری جماعت کو بتانا کہ اِس مہینے کے دسویں دن ہر خاندان کا سرپرست اپنے گھرانے کے لئے لیلا یعنی بھیڑ یا بکری کا بچہ حاصل کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","اگر گھرانے کے افراد پورا جانور کھانے کے لئے کم ہوں تو وہ اپنے سب سے قریبی پڑوسی کے ساتھ مل کر لیلا حاصل کریں۔ اِتنے لوگ اُس میں سے کھائیں کہ سب کے لئے کافی ہو اور پورا جانور کھایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","اِس کے لئے ایک سال کا نر بچہ چن لینا جس میں نقص نہ ہو۔ وہ بھیڑ یا بکری کا بچہ ہو سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","مہینے کے 14ویں دن تک اُس کی دیکھ بھال کرو۔ اُس دن تمام اسرائیلی سورج کے غروب ہوتے وقت اپنے لیلے ذبح کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ہر خاندان اپنے جانور کا کچھ خون جمع کر کے اُسے اُس گھر کے دروازے کی چوکھٹ پر لگائے جہاں لیلا کھایا جائے گا۔ یہ خون چوکھٹ کے اوپر والے حصے اور دائیں بائیں کے بازوؤں پر لگایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","لازم ہے کہ لوگ جانور کو بھون کر اُسی رات کھائیں۔ ساتھ ہی وہ کڑوا ساگ پات اور بےخمیری روٹیاں بھی کھائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","لیلے کا گوشت کچا نہ کھانا، نہ اُسے پانی میں اُبالنا بلکہ پورے جانور کو سر، پیروں اور اندرونی حصوں سمیت آگ پر بھوننا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","لازم ہے کہ پورا گوشت اُسی رات کھایا جائے۔ اگر کچھ صبح تک بچ جائے تو اُسے جلانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","کھانا کھاتے وقت ایسا لباس پہننا جیسے تم سفر پر جا رہے ہو۔ اپنے جوتے پہنے رکھنا اور ہاتھ میں سفر کے لئے لاٹھی لئے ہوئے تم اُسے جلدی جلدی کھانا۔ رب کے فسح کی عید یوں منانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","مَیں آج رات مصر میں سے گزروں گا اور ہر پہلوٹھے کو جان سے مار دوں گا، خواہ انسان کا ہو یا حیوان کا۔ یوں مَیں جو رب ہوں مصر کے تمام دیوتاؤں کی عدالت کروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","لیکن تمہارے گھروں پر لگا ہوا خون تمہارا خاص نشان ہو گا۔ جس جس گھر کے دروازے پر مَیں وہ خون دیکھوں گا اُسے چھوڑتا جاؤں گا۔ جب مَیں مصر پر حملہ کروں گا تو مہلک وبا تم تک نہیں پہنچے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","آج کی رات کو ہمیشہ یاد رکھنا۔ اِسے نسل در نسل اور ہر سال رب کی خاص عید کے طور پر منانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","سات دن تک بےخمیری روٹی کھانا ہے۔ پہلے دن اپنے گھروں سے تمام خمیر نکال دینا۔ اگر کوئی اِن سات دنوں کے دوران خمیر کھائے تو اُسے قوم میں سے مٹایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","اِس عید کے پہلے اور آخری دن مُقدّس اجتماع منعقد کرنا۔ اِن تمام دنوں کے دوران کام نہ کرنا۔ صرف ایک کام کی اجازت ہے اور وہ ہے اپنا کھانا تیار کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","بےخمیری روٹی کی عید منانا لازم ہے، کیونکہ اُس دن مَیں تمہارے متعدد خاندانوں کو مصر سے نکال لایا۔ اِس لئے یہ دن نسل درنسل ہر سال یاد رکھنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","پہلے مہینے کے 14ویں دن کی شام سے لے کر 21ویں دن کی شام تک صرف بےخمیری روٹی کھانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","سات دن تک تمہارے گھروں میں خمیر نہ پایا جائے۔ جو بھی اِس دوران خمیر کھائے اُسے اسرائیل کی جماعت میں سے مٹایا جائے، خواہ وہ اسرائیلی شہری ہو یا اجنبی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","غرض، اِس عید کے دوران خمیر نہ کھانا۔ جہاں بھی تم رہتے ہو وہاں بےخمیری روٹی ہی کھانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","پھر موسیٰ نے تمام اسرائیلی بزرگوں کو بُلا کر اُن سے کہا، ”جاؤ، اپنے خاندانوں کے لئے بھیڑ یا بکری کے بچے چن کر اُنہیں فسح کی عید کے لئے ذبح کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","زوفے کا گُچھا لے کر اُسے خون سے بھرے ہوئے باسن میں ڈبو دینا۔ پھر اُسے لے کر خون کو چوکھٹ کے اوپر والے حصے اور دائیں بائیں کے بازوؤں پر لگا دینا۔ صبح تک کوئی اپنے گھر سے نہ نکلے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","جب رب مصریوں کو مار ڈالنے کے لئے ملک میں سے گزرے گا تو وہ چوکھٹ کے اوپر والے حصے اور دائیں بائیں کے بازوؤں پر لگا ہوا خون دیکھ کر اُن گھروں کو چھوڑ دے گا۔ وہ ہلاک کرنے والے فرشتے کو اجازت نہیں دے گا کہ وہ تمہارے گھروں میں جا کر تمہیں ہلاک کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","تم اپنی اولاد سمیت ہمیشہ اِن ہدایات پر عمل کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","یہ رسم اُس وقت بھی ادا کرنا جب تم اُس ملک میں پہنچو گے جو رب تمہیں دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","اور جب تمہارے بچے تم سے پوچھیں کہ ہم یہ عید کیوں مناتے ہیں ");
INSERT INTO urdgvu_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","تو اُن سے کہو، ’یہ فسح کی قربانی ہے جو ہم رب کو پیش کرتے ہیں۔ کیونکہ جب رب مصریوں کو ہلاک کر رہا تھا تو اُس نے ہمارے گھروں کو چھوڑ دیا تھا‘۔“ یہ سن کر اسرائیلیوں نے اللہ کو سجدہ کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","پھر اُنہوں نے سب کچھ ویسا ہی کیا جیسا رب نے موسیٰ اور ہارون کو بتایا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","آدھی رات کو رب نے بادشاہ کے پہلوٹھے سے لے کر جیل کے قیدی کے پہلوٹھے تک مصریوں کے تمام پہلوٹھوں کو جان سے مار دیا۔ چوپایوں کے پہلوٹھے بھی مر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","اُس رات مصر کے ہر گھر میں کوئی نہ کوئی مر گیا۔ فرعون، اُس کے عہدیدار اور مصر کے تمام لوگ جاگ اُٹھے اور زور زور سے رونے اور چیخنے لگے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ابھی رات تھی کہ فرعون نے موسیٰ اور ہارون کو بُلا کر کہا، ”اب تم اور باقی اسرائیلی میری قوم میں سے نکل جاؤ۔ اپنی درخواست کے مطابق رب کی عبادت کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","جس طرح تم چاہتے ہو اپنی بھیڑبکریوں کو بھی اپنے ساتھ لے جاؤ۔ اور مجھے بھی برکت دینا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","باقی مصریوں نے بھی اسرائیلیوں پر زور دے کر کہا، ”جلدی جلدی ملک سے نکل جاؤ، ورنہ ہم سب مر جائیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","اسرائیلیوں کے گوندھے ہوئے آٹے میں خمیر نہیں تھا۔ اُنہوں نے اُسے گوندھنے کے برتنوں میں رکھ کر اپنے کپڑوں میں لپیٹ لیا اور سفر کرتے وقت اپنے کندھوں پر رکھ لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","اسرائیلی موسیٰ کی ہدایت پر عمل کر کے اپنے مصری پڑوسیوں کے پاس گئے اور اُن سے کپڑے اور سونے چاندی کی چیزیں مانگیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","رب نے مصریوں کے دلوں کو اسرائیلیوں کی طرف مائل کر دیا تھا، اِس لئے اُنہوں نے اُن کی ہر درخواست پوری کی۔ یوں اسرائیلیوں نے مصریوں کو لُوٹ لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","اسرائیلی رعمسیس سے روانہ ہو کر سُکات پہنچ گئے۔ عورتوں اور بچوں کو چھوڑ کر اُن کے 6 لاکھ مرد تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","وہ اپنے بھیڑبکریوں اور گائےبَیلوں کے بڑے بڑے ریوڑ بھی ساتھ لے گئے۔ بہت سے ایسے لوگ بھی اُن کے ساتھ نکلے جو اسرائیلی نہیں تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","راستے میں اُنہوں نے اُس بےخمیری آٹے سے روٹیاں بنائیں جو وہ ساتھ لے کر نکلے تھے۔ آٹے میں اِس لئے خمیر نہیں تھا کہ اُنہیں اِتنی جلدی سے مصر سے نکال دیا گیا تھا کہ کھانا تیار کرنے کا وقت ہی نہ ملا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","اسرائیلی 430 سال تک مصر میں رہے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","430 سال کے عین بعد، اُسی دن رب کے یہ تمام خاندان مصر سے نکلے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","اُس خاص رات رب نے خود پہرا دیا تاکہ اسرائیلی مصر سے نکل سکیں۔ اِس لئے تمام اسرائیلیوں کے لئے لازم ہے کہ وہ نسل در نسل اِس رات رب کی تعظیم میں جاگتے رہیں، وہ بھی اور اُن کے بعد کی اولاد بھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","رب نے موسیٰ اور ہارون سے کہا، ”فسح کی عید کے یہ اصول ہیں: کسی بھی پردیسی کو فسح کی عید کا کھانا کھانے کی اجازت نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","اگر تم نے کسی غلام کو خرید کر اُس کا ختنہ کیا ہے تو وہ فسح کا کھانا کھا سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","لیکن غیرشہری یا مزدور کو فسح کا کھانا کھانے کی اجازت نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","یہ کھانا ایک ہی گھر کے اندر کھانا ہے۔ نہ گوشت گھر سے باہر لے جانا، نہ لیلے کی کسی ہڈی کو توڑنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","لازم ہے کہ اسرائیل کی پوری جماعت یہ عید منائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","اگر کوئی پردیسی تمہارے ساتھ رہتا ہے جو فسح کی عید میں شرکت کرنا چاہے تو لازم ہے کہ پہلے اُس کے گھرانے کے ہر مرد کا ختنہ کیا جائے۔ تب وہ اسرائیلی کی طرح کھانے میں شریک ہو سکتا ہے۔ لیکن جس کا ختنہ نہ ہوا اُسے فسح کا کھانا کھانے کی اجازت نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","یہی اصول ہر ایک پر لاگو ہو گا، خواہ وہ اسرائیلی ہو یا پردیسی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","تمام اسرائیلیوں نے ویسا ہی کیا جیسا رب نے موسیٰ اور ہارون سے کہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","اُسی دن رب تمام اسرائیلیوں کو خاندانوں کی ترتیب کے مطابق مصر سے نکال لایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","”اسرائیلیوں کے ہر پہلوٹھے کو میرے لئے مخصوص و مُقدّس کرنا ہے۔ ہر پہلا نر بچہ میرا ہی ہے، خواہ انسان کا ہو یا حیوان کا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","پھر موسیٰ نے لوگوں سے کہا، ”اِس دن کو یاد رکھو جب تم رب کی عظیم قدرت کے باعث مصر کی غلامی سے نکلے۔ اِس دن کوئی چیز نہ کھانا جس میں خمیر ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","آج ہی ابیب کے مہینے میں تم مصر سے روانہ ہو رہے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","رب نے تمہارے باپ دادا سے قَسم کھا کر وعدہ کیا ہے کہ وہ تم کو کنعانی، حِتّی، اموری، حِوّی اور یبوسی قوموں کا ملک دے گا، ایک ایسا ملک جس میں دودھ اور شہد کی کثرت ہے۔ جب رب تمہیں اُس ملک میں پہنچا دے گا تو لازم ہے کہ تم اِسی مہینے میں یہ رسم مناؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","سات دن بےخمیری روٹی کھاؤ۔ ساتویں دن رب کی تعظیم میں عید مناؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","سات دن خمیری روٹی نہ کھانا۔ کہیں بھی خمیر نہ پایا جائے۔ پورے ملک میں خمیر کا نام و نشان تک نہ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","اُس دن اپنے بیٹے سے یہ کہو، ’مَیں یہ عید اُس کام کی خوشی میں مناتا ہوں جو رب نے میرے لئے کیا جب مَیں مصر سے نکلا۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","یہ عید تمہارے ہاتھ یا پیشانی پر نشان کی مانند ہو جو تمہیں یاد دلائے کہ رب کی شریعت کو تمہارے ہونٹوں پر رہنا ہے۔ کیونکہ رب تمہیں اپنی عظیم قدرت سے مصر سے نکال لایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","اِس دن کی یاد ہر سال ٹھیک وقت پر منانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","رب تمہیں کنعانیوں کے اُس ملک میں لے جائے گا جس کا وعدہ اُس نے قَسم کھا کر تم اور تمہارے باپ دادا سے کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","لازم ہے کہ وہاں پہنچ کر تم اپنے تمام پہلوٹھوں کو رب کے لئے مخصوص کرو۔ تمہارے مویشیوں کے تمام پہلوٹھے بھی رب کی ملکیت ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","اگر تم اپنا پہلوٹھا گدھا خود رکھنا چاہو تو رب کو اُس کے بدلے بھیڑ یا بکری کا بچہ پیش کرو۔ لیکن اگر تم اُسے رکھنا نہیں چاہتے تو اُس کی گردن توڑ ڈالو۔ لیکن انسان کے پہلوٹھوں کے لئے ہر صورت میں عوضی دینا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","آنے والے دنوں میں جب تمہارا بیٹا پوچھے کہ اِس کا کیا مطلب ہے تو اُسے جواب دینا، ’رب اپنی عظیم قدرت سے ہمیں مصر کی غلامی سے نکال لایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","جب فرعون نے اکڑ کر ہمیں جانے نہ دیا تو رب نے مصر کے تمام انسانوں اور حیوانوں کے پہلوٹھوں کو مار ڈالا۔ اِس وجہ سے مَیں اپنے جانوروں کا ہر پہلا بچہ رب کو قربان کرتا اور اپنے ہر پہلوٹھے کے لئے عوضی دیتا ہوں۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","یہ دستور تمہارے ہاتھ اور پیشانی پر نشان کی مانند ہو جو تمہیں یاد دلائے کہ رب ہمیں اپنی قدرت سے مصر سے نکال لایا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","جب فرعون نے اسرائیلی قوم کو جانے دیا تو اللہ اُنہیں فلستیوں کے علاقے میں سے گزرنے والے راستے سے لے کر نہ گیا، اگرچہ اُس پر چلتے ہوئے وہ جلد ہی ملکِ کنعان پہنچ جاتے۔ بلکہ رب نے کہا، ”اگر اُس راستے پر چلیں گے تو اُنہیں دوسروں سے لڑنا پڑے گا۔ ایسا نہ ہو کہ وہ اِس وجہ سے اپنا ارادہ بدل کر مصر لوٹ جائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","اِس لئے اللہ اُنہیں دوسرے راستے سے لے کر گیا، اور وہ ریگستان کے راستے سے بحرِ قُلزم کی طرف بڑھے۔ مصر سے نکلتے وقت مرد مسلح تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","موسیٰ یوسف کا تابوت بھی اپنے ساتھ لے گیا، کیونکہ یوسف نے اسرائیلیوں کو قَسم دلا کر کہا تھا، ”اللہ یقیناً تمہاری دیکھ بھال کر کے وہاں لے جائے گا۔ اُس وقت میری ہڈیوں کو بھی اُٹھا کر ساتھ لے جانا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","اسرائیلیوں نے سُکات کو چھوڑ کر ایتام میں اپنے خیمے لگائے۔ ایتام ریگستان کے کنارے پر تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","رب اُن کے آگے آگے چلتا گیا، دن کے وقت بادل کے ستون میں تاکہ اُنہیں راستے کا پتا لگے اور رات کے وقت آگ کے ستون میں تاکہ اُنہیں روشنی ملے۔ یوں وہ دن اور رات سفر کر سکتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","دن کے وقت بادل کا ستون اور رات کے وقت آگ کا ستون اُن کے سامنے رہا۔ وہ کبھی بھی اپنی جگہ سے نہ ہٹا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","تب رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","”اسرائیلیوں کو کہہ دینا کہ وہ پیچھے مُڑ کر مجدال اور سمندر کے بیچ یعنی فی ہخیروت کے نزدیک رُک جائیں۔ وہ بعل صفون کے مقابل ساحل پر اپنے خیمے لگائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","یہ دیکھ کر فر عون سمجھے گا کہ اسرائیلی راستہ بھول کر آوارہ پھر رہے ہیں اور کہ ریگستان نے چاروں طرف اُنہیں گھیر رکھا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","پھر مَیں فرعون کو دوبارہ اَڑ جانے دوں گا، اور وہ اسرائیلیوں کا پیچھا کرے گا۔ لیکن مَیں فرعون اور اُس کی پوری فوج پر اپنا جلال ظاہر کروں گا۔ مصری جان لیں گے کہ مَیں ہی رب ہوں۔“ اسرائیلیوں نے ایسا ہی کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","جب مصر کے بادشاہ کو اطلاع دی گئی کہ اسرائیلی ہجرت کر گئے ہیں تو اُس نے اور اُس کے درباریوں نے اپنا خیال بدل کر کہا، ”ہم نے کیا کِیا ہے؟ ہم نے اُنہیں جانے دیا ہے، اور اب ہم اُن کی خدمت سے محروم ہو گئے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","چنانچہ بادشاہ نے اپنا جنگی رتھ تیار کروایا اور اپنی فوج کو لے کر نکلا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","وہ 600 بہترین قسم کے رتھ اور مصر کے باقی تمام رتھوں کو ساتھ لے گیا۔ تمام رتھوں پر افسران مقرر تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","رب نے مصر کے بادشاہ فرعون کو دوبارہ اَڑ جانے دیا تھا، اِس لئے جب اسرائیلی بڑے اختیار کے ساتھ نکل رہے تھے تو وہ اُن کا تعاقب کرنے لگا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","اسرائیلیوں کا پیچھا کرتے کرتے فرعون کے تمام گھوڑے، رتھ، سوار اور فوجی اُن کے قریب پہنچے۔ اسرائیلی بحرِ قُلزم کے ساحل پر بعل صفون کے مقابل فی ہخیروت کے نزدیک خیمے لگا چکے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","جب اسرائیلیوں نے فرعون اور اُس کی فوج کو اپنی طرف بڑھتے دیکھا تو وہ سخت گھبرا گئے اور مدد کے لئے رب کے سامنے چیخنے چلّانے لگے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","اُنہوں نے موسیٰ سے کہا، ”کیا مصر میں قبروں کی کمی تھی کہ آپ ہمیں ریگستان میں لے آئے ہیں؟ ہمیں مصر سے نکال کر آپ نے ہمارے ساتھ کیا کِیا ہے؟ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","کیا ہم نے مصر میں آپ سے درخواست نہیں کی تھی کہ مہربانی کر کے ہمیں چھوڑ دیں، ہمیں مصریوں کی خدمت کرنے دیں؟ یہاں آ کر ریگستان میں مر جانے کی نسبت بہتر ہوتا کہ ہم مصریوں کے غلام رہتے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","لیکن موسیٰ نے جواب دیا، ”مت گھبراؤ۔ آرام سے کھڑے رہو اور دیکھو کہ رب تمہیں آج کس طرح بچائے گا۔ آج کے بعد تم اِن مصریوں کو پھر کبھی نہیں دیکھو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","رب تمہارے لئے لڑے گا۔ تمہیں بس، چپ رہنا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","پھر رب نے موسیٰ سے کہا، ”تُو میرے سامنے کیوں چیخ رہا ہے؟ اسرائیلیوں کو آگے بڑھنے کا حکم دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","اپنی لاٹھی کو پکڑ کر اُسے سمندر کے اوپر اُٹھا تو وہ دو حصوں میں بٹ جائے گا۔ اسرائیلی خشک زمین پرسمندر میں سے گزریں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","مَیں مصریوں کو اَڑے رہنے دوں گا تاکہ وہ اسرائیلیوں کا پیچھا کریں۔ پھر مَیں فرعون، اُس کی ساری فوج، اُس کے رتھوں اور اُس کے سواروں پر اپنا جلال ظاہر کروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","جب مَیں فرعون، اُس کے رتھوں اور اُس کے سواروں پر اپنا جلال ظاہر کروں گا تو مصری جان لیں گے کہ مَیں ہی رب ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","اللہ کا فرشتہ اسرائیلی لشکر کے آگے آگے چل رہا تھا۔ اب وہ وہاں سے ہٹ کر اُن کے پیچھے کھڑا ہو گیا۔ بادل کا ستون بھی لوگوں کے آگے سے ہٹ کر اُن کے پیچھے جا کھڑا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","اِس طرح بادل مصریوں اور اسرائیلیوں کے لشکروں کے درمیان آ گیا۔ پوری رات مصریوں کی طرف اندھیرا ہی اندھیرا تھا جبکہ اسرائیلیوں کی طرف روشنی تھی۔ اِس لئے مصری پوری رات کے دوران اسرائیلیوں کے قریب نہ آ سکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","موسیٰ نے اپنا ہاتھ سمندر کے اوپر اُٹھایا تو رب نے مشرق سے تیز آندھی چلائی۔ آندھی تمام رات چلتی رہی۔ اُس نے سمندر کو پیچھے ہٹا کر اُس کی تہہ خشک کر دی۔ سمندر دو حصوں میں بٹ گیا ");
INSERT INTO urdgvu_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","تو اسرائیلی سمندر میں سے خشک زمین پر چلتے ہوئے گزر گئے۔ اُن کے دائیں اور بائیں طرف پانی دیوار کی طرح کھڑا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","جب مصریوں کو پتا چلا تو فرعون کے تمام گھوڑے، رتھ اور گھڑسوار بھی اُن کے پیچھے پیچھے سمندر میں چلے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","صبح سویرے ہی رب نے بادل اور آگ کے ستون سے مصر کی فوج پر نگاہ کی اور اُس میں ابتری پیدا کر دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","اُن کے رتھوں کے پہئے نکل گئے تو اُن پر قابو پانا مشکل ہو گیا۔ مصریوں نے کہا، ”آؤ، ہم اسرائیلیوں سے بھاگ جائیں، کیونکہ رب اُن کے ساتھ ہے۔ وہی مصر کا مقابلہ کر رہا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","تب رب نے موسیٰ سے کہا، ”اپنا ہاتھ سمندر کے اوپر اُٹھا۔ پھر پانی واپس آ کر مصریوں، اُن کے رتھوں اور گھڑسواروں کو ڈبو دے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","موسیٰ نے اپنا ہاتھ سمندر کے اوپر اُٹھایا تو دن نکلتے وقت پانی معمول کے مطابق بہنے لگا، اور جس طرف مصری بھاگ رہے تھے وہاں پانی ہی پانی تھا۔ یوں رب نے اُنہیں سمندر میں بہا کر غرق کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","پانی واپس آ گیا۔ اُس نے رتھوں اور گھڑسواروں کو ڈھانک لیا۔ فرعون کی پوری فوج جو اسرائیلیوں کا تعاقب کر رہی تھی ڈوب کر تباہ ہو گئی۔ اُن میں سے ایک بھی نہ بچا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","لیکن اسرائیلی خشک زمین پر سمندر میں سے گزرے۔ اُن کے دائیں اور بائیں طرف پانی دیوار کی طرح کھڑا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","اُس دن رب نے اسرائیلیوں کو مصریوں سے بچایا۔ مصریوں کی لاشیں اُنہیں ساحل پر نظر آئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","جب اسرائیلیوں نے رب کی یہ عظیم قدرت دیکھی جو اُس نے مصریوں پر ظاہر کی تھی تو رب کا خوف اُن پر چھا گیا۔ وہ اُس پر اور اُس کے خادم موسیٰ پر اعتماد کرنے لگے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","تب موسیٰ اور اسرائیلیوں نے رب کے لئے یہ گیت گایا، ”مَیں رب کی تمجید میں گیت گاؤں گا، کیونکہ وہ نہایت عظیم ہے۔ گھوڑے اور اُس کے سوار کو اُس نے سمندر میں پٹخ دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","رب میری قوت اور میرا گیت ہے، وہ میری نجات بن گیا ہے۔ وہی میرا خدا ہے، اور مَیں اُس کی تعریف کروں گا۔ وہی میرے باپ کا خدا ہے، اور مَیں اُس کی تعظیم کروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","رب سورما ہے، رب اُس کا نام ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","فرعون کے رتھوں اور فوج کو اُس نے سمندر میں پٹخ دیا تو بادشاہ کے بہترین افسران بحرِ قُلزم میں ڈوب گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","گہرے پانی نے اُنہیں ڈھانک لیا، اور وہ پتھر کی طرح سمندر کی تہہ تک اُتر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","اے رب، تیرے دہنے ہاتھ کا جلال بڑی قدرت سے ظاہر ہوتا ہے۔ اے رب، تیرا دہنا ہاتھ دشمن کو چِکنا چُور کر دیتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","جو تیرے خلاف اُٹھ کھڑے ہوتے ہیں اُنہیں تُو اپنی عظمت کا اظہار کر کے زمین پر پٹخ دیتا ہے۔ تیرا غضب اُن پر آن پڑتا ہے تو وہ آگ میں بھوسے کی طرح جل جاتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","تُو نے غصے میں آ کر پھونک ماری تو پانی ڈھیر کی صورت میں جمع ہو گیا۔ بہتا پانی ٹھوس دیوار بن گیا، سمندر گہرائی تک جم گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","دشمن نے ڈینگ مار کر کہا، ’مَیں اُن کا پیچھا کر کے اُنہیں پکڑ لوں گا، مَیں اُن کا لُوٹا ہوا مال تقسیم کروں گا۔ میری لالچی جان اُن سے سیر ہو جائے گی، مَیں اپنی تلوار کھینچ کر اُنہیں ہلاک کروں گا۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","لیکن تُو نے اُن پر پھونک ماری تو سمندر نے اُنہیں ڈھانک لیا، اور وہ سیسے کی طرح زوردار موجوں میں ڈوب گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","اے رب، کون سا معبود تیری مانند ہے؟ کون تیری طرح جلالی اور قدوس ہے؟ کون تیری طرح حیرت انگیز کام کرتا اور عظیم معجزے دکھاتا ہے؟ کوئی بھی نہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","تُو نے اپنا دہنا ہاتھ اُٹھایا تو زمین ہمارے دشمنوں کو نگل گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","اپنی شفقت سے تُو نے عوضانہ دے کر اپنی قوم کو چھٹکارا دیا اور اُس کی راہنمائی کی ہے، اپنی قدرت سے تُو نے اُسے اپنی مُقدّس سکونت گاہ تک پہنچایا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","یہ سن کر دیگر قومیں کانپ اُٹھیِں، فلستی ڈر کے مارے پیچ و تاب کھانے لگے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ادوم کے رئیس سہم گئے، موآب کے راہنماؤں پر کپکپی طاری ہو گئی، اور کنعان کے تمام باشندے ہمت ہار گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","دہشت اور خوف اُن پر چھا گیا۔ تیری عظیم قدرت کے باعث وہ پتھر کی طرح جم گئے۔ اے رب، وہ نہ ہلے جب تک تیری قوم گزر نہ گئی۔ وہ بےحس و حرکت رہے جب تک تیری خریدی ہوئی قوم گزر نہ گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","اے رب، تُو اپنے لوگوں کو لے کر پودوں کی طرح اپنے موروثی پہاڑ پر لگائے گا، اُس جگہ پر جو تُو نے اپنی سکونت کے لئے چن لی ہے، جہاں تُو نے اپنے ہاتھوں سے اپنا مقدِس تیار کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","رب ابد تک بادشاہ ہے!“ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","جب فرعون کے گھوڑے، رتھ اور گھڑسوار سمندر میں چلے گئے تو رب نے اُنہیں سمندر کے پانی سے ڈھانک لیا۔ لیکن اسرائیلی خشک زمین پر سمندر میں سے گزر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","تب ہارون کی بہن مریم جو نبیہ تھی نے دف لیا، اور باقی تمام عورتیں بھی دف لے کر اُس کے پیچھے ہو لیں۔ سب گانے اور ناچنے لگیں۔ مریم نے یہ گا کر اُن کی راہنمائی کی، ");
INSERT INTO urdgvu_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","”رب کی تمجید میں گیت گاؤ، کیونکہ وہ نہایت عظیم ہے۔ گھوڑے اور اُس کے سوار کو اُس نے سمندر میں پٹخ دیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","موسیٰ کے کہنے پر اسرائیلی بحرِ قُلزم سے روانہ ہو کر دشتِ شُور میں چلے گئے۔ وہاں وہ تین دن تک سفر کرتے رہے۔ اِس دوران اُنہیں پانی نہ ملا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","آخرکار وہ مارہ پہنچے جہاں پانی دست یاب تھا۔ لیکن وہ کڑوا تھا، اِس لئے مقام کا نام مارہ یعنی کڑواہٹ پڑ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","یہ دیکھ کر لوگ موسیٰ کے خلاف بڑبڑا کر کہنے لگے، ”ہم کیا پئیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","موسیٰ نے مدد کے لئے رب سے التجا کی تو اُس نے اُسے لکڑی کا ایک ٹکڑا دکھایا۔ جب موسیٰ نے یہ لکڑی پانی میں ڈالی تو پانی کی کڑواہٹ ختم ہو گئی۔ مارہ میں رب نے اپنی قوم کو قوانین دیئے۔ وہاں اُس نے اُنہیں آزمایا بھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","اُس نے کہا، ”غور سے رب اپنے خدا کی آواز سنو! جو کچھ اُس کی نظر میں درست ہے وہی کرو۔ اُس کے احکام پر دھیان دو اور اُس کی تمام ہدایات پر عمل کرو۔ پھر مَیں تم پر وہ بیماریاں نہیں لاؤں گا جو مصریوں پر لایا تھا، کیونکہ مَیں رب ہوں جو تجھے شفا دیتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","پھر اسرائیلی روانہ ہو کر ایلیم پہنچے جہاں 12 چشمے اور کھجور کے 70 درخت تھے۔ وہاں اُنہوں نے پانی کے قریب اپنے خیمے لگائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","اِس کے بعد اسرائیل کی پوری جماعت ایلیم سے سفر کر کے صین کے ریگستان میں پہنچی جو ایلیم اور سینا کے درمیان ہے۔ وہ مصر سے نکلنے کے بعد دوسرے مہینے کے 15ویں دن پہنچے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ریگستان میں تمام لوگ پھر موسیٰ اور ہارون کے خلاف بڑبڑانے لگے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","اُنہوں نے کہا، ”کاش رب ہمیں مصر میں ہی مار ڈالتا! وہاں ہم کم از کم جی بھر کر گوشت اور روٹی تو کھا سکتے تھے۔ آپ ہمیں صرف اِس لئے ریگستان میں لے آئے ہیں کہ ہم سب بھوکے مر جائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","تب رب نے موسیٰ سے کہا، ”مَیں آسمان سے تمہارے لئے روٹی برساؤں گا۔ ہر روز لوگ باہر جا کر اُسی دن کی ضرورت کے مطابق کھانا جمع کریں۔ اِس سے مَیں اُنہیں آزما کر دیکھوں گا کہ آیا وہ میری سنتے ہیں کہ نہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ہر روز وہ صرف اُتنا کھانا جمع کریں جتنا کہ ایک دن کے لئے کافی ہو۔ لیکن چھٹے دن جب وہ کھانا تیار کریں گے تو وہ اگلے دن کے لئے بھی کافی ہو گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","موسیٰ اور ہارون نے اسرائیلیوں سے کہا، ”آج شام کو تم جان لو گے کہ رب ہی تمہیں مصر سے نکال لایا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","اور کل صبح تم رب کا جلال دیکھو گے۔ اُس نے تمہاری شکایتیں سن لی ہیں، کیونکہ اصل میں تم ہمارے خلاف نہیں بلکہ رب کے خلاف بڑ بڑا رہے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","پھر بھی رب تم کو شام کے وقت گوشت اور صبح کے وقت وافر روٹی دے گا، کیونکہ اُس نے تمہاری شکایتیں سن لی ہیں۔ تمہاری شکایتیں ہمارے خلاف نہیں بلکہ رب کے خلاف ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","موسیٰ نے ہارون سے کہا، ”اسرائیلیوں کو بتانا، ’رب کے سامنے حاضر ہو جاؤ، کیونکہ اُس نے تمہاری شکایتیں سن لی ہیں‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","جب ہارون پوری جماعت کے سامنے بات کرنے لگا تو لوگوں نے پلٹ کر ریگستان کی طرف دیکھا۔ وہاں رب کا جلال بادل میں ظاہر ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","”مَیں نے اسرائیلیوں کی شکایت سن لی ہے۔ اُنہیں بتا، ’آج جب سورج غروب ہونے لگے گا تو تم گوشت کھاؤ گے اور کل صبح پیٹ بھر کر روٹی۔ پھر تم جان لو گے کہ مَیں رب تمہارا خدا ہوں‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","اُسی شام بٹیروں کے غول آئے جو پوری خیمہ گاہ پر چھا گئے۔ اور اگلی صبح خیمے کے چاروں طرف اوس پڑی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","جب اوس سوکھ گئی تو برف کے گالوں جیسے پتلے دانے پالے کی طرح زمین پر پڑے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","جب اسرائیلیوں نے اُسے دیکھا تو ایک دوسرے سے پوچھنے لگے، ”مَن ہُو؟“ یعنی ”یہ کیا ہے؟“ کیونکہ وہ نہیں جانتے تھے کہ یہ کیا چیز ہے۔ موسیٰ نے اُن کو سمجھایا، ”یہ وہ روٹی ہے جو رب نے تمہیں کھانے کے لئے دی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","رب کا حکم ہے کہ ہر ایک اُتنا جمع کرے جتنا اُس کے خاندان کو ضرورت ہو۔ اپنے خاندان کے ہر فرد کے لئے دو لٹر جمع کرو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","اسرائیلیوں نے ایسا ہی کیا۔ بعض نے زیادہ اور بعض نے کم جمع کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","لیکن جب اُسے ناپا گیا تو ہر ایک آدمی کے لئے کافی تھا۔ جس نے زیادہ جمع کیا تھا اُس کے پاس کچھ نہ بچا۔ لیکن جس نے کم جمع کیا تھا اُس کے پاس بھی کافی تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","موسیٰ نے حکم دیا، ”اگلے دن کے لئے کھانا نہ بچانا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","لیکن لوگوں نے موسیٰ کی بات نہ مانی بلکہ بعض نے کھانا بچا لیا۔ لیکن اگلی صبح معلوم ہوا کہ بچے ہوئے کھانے میں کیڑے پڑ گئے ہیں اور اُس سے بہت بدبو آ رہی ہے۔ یہ سن کر موسیٰ اُن سے ناراض ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ہر صبح ہر کوئی اُتنا جمع کر لیتا جتنی اُسے ضرورت ہوتی تھی۔ جب دھوپ تیز ہوتی تو جو کچھ زمین پر رہ جاتا وہ پگھل کر ختم ہو جاتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","چھٹے دن جب لوگ یہ خوراک جمع کرتے تو وہ مقدار میں دُگنی ہوتی تھی یعنی ہر فرد کے لئے چار لٹر۔ جب جماعت کے بزرگوں نے موسیٰ کے پاس آ کر اُسے اطلاع دی ");
INSERT INTO urdgvu_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","تو اُس نے اُن سے کہا، ”رب کا فرمان ہے کہ کل آرام کا دن ہے، مُقدّس سبت کا دن جو اللہ کی تعظیم میں منانا ہے۔ آج تم جو تنور میں پکانا چاہتے ہو پکا لو اور جو اُبالنا چاہتے ہو اُبال لو۔ جو بچ جائے اُسے کل کے لئے محفوظ رکھو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","لوگوں نے موسیٰ کے حکم کے مطابق اگلے دن کے لئے کھانا محفوظ کر لیا تو نہ کھانے سے بدبو آئی، نہ اُس میں کیڑے پڑے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","موسیٰ نے کہا، ”آج یہی بچا ہوا کھانا کھاؤ، کیونکہ آج سبت کا دن ہے، رب کی تعظیم میں آرام کا دن۔ آج تمہیں ریگستان میں کچھ نہیں ملے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","چھ دن کے دوران یہ خوراک جمع کرنا ہے، لیکن ساتواں دن آرام کا دن ہے۔ اُس دن زمین پر کھانے کے لئے کچھ نہیں ہو گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","توبھی کچھ لوگ ہفتے کو کھانا جمع کرنے کے لئے نکلے، لیکن اُنہیں کچھ نہ ملا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","تب رب نے موسیٰ سے کہا، ”تم لوگ کب تک میرے احکام اور ہدایات پر عمل کرنے سے انکار کرو گے؟ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","دیکھو، رب نے تمہارے لئے مقرر کیا ہے کہ سبت کا دن آرام کا دن ہے۔ اِس لئے وہ تمہیں جمعہ کو دو دن کے لئے خوراک دیتا ہے۔ ہفتے کو سب کو اپنے خیموں میں رہنا ہے۔ کوئی بھی اپنے گھر سے باہر نہ نکلے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","چنانچہ لوگ سبت کے دن آرام کرتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","اسرائیلیوں نے اِس خوراک کا نام ’مَن‘ رکھا۔ اُس کے دانے دھنئے کی مانند سفید تھے، اور اُس کا ذائقہ شہد سے بنے کیک کی مانند تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","موسیٰ نے کہا، ”رب فرماتا ہے، ’دو لٹر مَن ایک مرتبان میں رکھ کر اُسے آنے والی نسلوں کے لئے محفوظ رکھنا۔ پھر وہ دیکھ سکیں گے کہ مَیں تمہیں کیا کھانا کھلاتا رہا جب تمہیں مصر سے نکال لایا‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","موسیٰ نے ہارون سے کہا، ”ایک مرتبان لو اور اُسے دو لٹر مَن سے بھر کر رب کے سامنے رکھو تاکہ وہ آنے والی نسلوں کے لئے محفوظ رہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","ہارون نے ایسا ہی کیا۔ اُس نے مَن کے اِس مرتبان کو عہد کے صندوق کے سامنے رکھا تاکہ وہ محفوظ رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","اسرائیلیوں کو 40 سال تک مَن ملتا رہا۔ وہ اُس وقت تک مَن کھاتے رہے جب تک ریگستان سے نکل کر کنعان کی سرحد پر نہ پہنچے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(جو پیمانہ اسرائیلی مَن کے لئے استعمال کرتے تھے وہ دو لٹر کا ایک برتن تھا جس کا نام عومر تھا۔) ");
INSERT INTO urdgvu_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","پھر اسرائیل کی پوری جماعت صین کے ریگستان سے نکلی۔ رب جس طرح حکم دیتا رہا وہ ایک جگہ سے دوسری جگہ سفر کرتے رہے۔ رفیدیم میں اُنہوں نے خیمے لگائے۔ وہاں پینے کے لئے پانی نہ ملا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","اِس لئے وہ موسیٰ کے ساتھ یہ کہہ کر جھگڑنے لگے، ”ہمیں پینے کے لئے پانی دو۔“ موسیٰ نے جواب دیا، ”تم مجھ سے کیوں جھگڑ رہے ہو؟ رب کو کیوں آزما رہے ہو؟“ ");
INSERT INTO urdgvu_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","لیکن لوگ بہت پیاسے تھے۔ وہ موسیٰ کے خلاف بڑبڑانے سے باز نہ آئے بلکہ کہا، ”آپ ہمیں مصر سے کیوں لائے ہیں؟ کیا اِس لئے کہ ہم اپنے بچوں اور ریوڑوں سمیت پیاسے مر جائیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","تب موسیٰ نے رب کے حضور فریاد کی، ”مَیں اِن لوگوں کے ساتھ کیا کروں؟ حالات ذرا بھی اَور بگڑ جائیں تو وہ مجھے سنگسار کر دیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","رب نے موسیٰ سے کہا، ”کچھ بزرگ ساتھ لے کر لوگوں کے آگے آگے چل۔ وہ لاٹھی بھی ساتھ لے جا جس سے تُو نے دریائے نیل کو مارا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","مَیں حورب یعنی سینا پہاڑ کی ایک چٹان پر تیرے سامنے کھڑا ہوں گا۔ لاٹھی سے چٹان کو مارنا تو اُس سے پانی نکلے گا اور لوگ پی سکیں گے۔“ موسیٰ نے اسرائیل کے بزرگوں کے سامنے ایسا ہی کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","اُس نے اُس جگہ کا نام ’مسّہ اور مریبہ‘ یعنی ’آزمانا اور جھگڑنا‘ رکھا، کیونکہ وہاں اسرائیلی بڑبڑائے اور یہ پوچھ کر رب کو آزمایا کہ کیا رب ہمارے درمیان ہے کہ نہیں؟ ");
INSERT INTO urdgvu_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","رفیدیم وہ جگہ بھی تھی جہاں عمالیقی اسرائیلیوں سے لڑنے آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","موسیٰ نے یشوع سے کہا، ”لڑنے کے قابل آدمیوں کو چن لو اور نکل کر عمالیقیوں کا مقابلہ کرو۔ کل مَیں اللہ کی لاٹھی پکڑے ہوئے پہاڑ کی چوٹی پر کھڑا ہو جاؤں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","یشوع موسیٰ کی ہدایت کے مطابق عمالیقیوں سے لڑنے گیا جبکہ موسیٰ، ہارون اور حور پہاڑ کی چوٹی پر چڑھ گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","اور یوں ہوا کہ جب موسیٰ کے ہاتھ اُٹھائے ہوئے تھے تو اسرائیلی جیتتے رہے، اور جب وہ نیچے تھے تو عمالیقی جیتتے رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","کچھ دیر کے بعد موسیٰ کے بازو تھک گئے۔ اِس لئے ہارون اور حور ایک چٹان لے آئے تاکہ وہ اُس پر بیٹھ جائے۔ پھر اُنہوں نے اُس کے دائیں اور بائیں طرف کھڑے ہو کر اُس کے بازوؤں کو اوپر اُٹھائے رکھا۔ سورج کے غروب ہونے تک اُنہوں نے یوں موسیٰ کی مدد کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","اِس طرح یشوع نے عمالیقیوں سے لڑتے لڑتے اُنہیں شکست دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","تب رب نے موسیٰ سے کہا، ”یہ واقعہ یادگاری کے لئے کتاب میں لکھ لے۔ لازم ہے کہ یہ سب کچھ یشوع کی یاد میں رہے، کیونکہ مَیں دنیا سے عمالیقیوں کا نام و نشان مٹا دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","اُس وقت موسیٰ نے قربان گاہ بنا کر اُس کا نام ’رب میرا جھنڈا ہے‘ رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","اُس نے کہا، ”رب کے تخت کے خلاف ہاتھ اُٹھایا گیا ہے، اِس لئے رب کی عمالیقیوں سے ہمیشہ تک جنگ رہے گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","موسیٰ کا سُسر یترو اب تک مِدیان میں امام تھا۔ جب اُس نے سب کچھ سنا جو اللہ نے موسیٰ اور اپنی قوم کے لئے کیا ہے، کہ وہ اُنہیں مصر سے نکال لایا ہے ");
INSERT INTO urdgvu_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","تو وہ موسیٰ کے پاس آیا۔ وہ اُس کی بیوی صفورہ کو اپنے ساتھ لایا، کیونکہ موسیٰ نے اُسے اپنے بیٹوں سمیت میکے بھیج دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","یترو موسیٰ کے دونوں بیٹوں کو بھی ساتھ لایا۔ پہلے بیٹے کا نام جَیرسوم یعنی ’اجنبی ملک میں پردیسی‘ تھا، کیونکہ جب وہ پیدا ہوا تو موسیٰ نے کہا تھا، ”مَیں اجنبی ملک میں پردیسی ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","دوسرے بیٹے کا نام اِلی عزر یعنی ’میرا خدا مددگار ہے‘ تھا، کیونکہ جب وہ پیدا ہوا تو موسیٰ نے کہا تھا، ”میرے باپ کے خدا نے میری مدد کر کے مجھے فرعون کی تلوار سے بچایا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","یترو موسیٰ کی بیوی اور بیٹے ساتھ لے کر اُس وقت موسیٰ کے پاس پہنچا جب اُس نے ریگستان میں اللہ کے پہاڑ یعنی سینا کے قریب خیمہ لگایا ہوا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","اُس نے موسیٰ کو پیغام بھیجا تھا، ”مَیں، آپ کا سُسر یترو آپ کی بیوی اور دو بیٹوں کو ساتھ لے کر آپ کے پاس آ رہا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","موسیٰ اپنے سُسر کے استقبال کے لئے باہر نکلا، اُس کے سامنے جھکا اور اُسے بوسہ دیا۔ دونوں نے ایک دوسرے کا حال پوچھا، پھر خیمے میں چلے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","موسیٰ نے یترو کو تفصیل سے بتایا کہ رب نے اسرائیلیوں کی خاطر فرعون اور مصریوں کے ساتھ کیا کچھ کیا ہے۔ اُس نے راستے میں پیش آئی تمام مشکلات کا ذکر بھی کیا کہ رب نے ہمیں کس طرح اُن سے بچایا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","یترو اُن سارے اچھے کاموں کے بارے میں سن کر خوش ہوا جو رب نے اسرائیلیوں کے لئے کئے تھے جب اُس نے اُنہیں مصریوں کے ہاتھ سے بچایا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","اُس نے کہا، ”رب کی تمجید ہو جس نے آپ کو مصریوں اور فرعون کے قبضے سے نجات دلائی ہے۔ اُسی نے قوم کو غلامی سے چھڑایا ہے! ");
INSERT INTO urdgvu_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","اب مَیں نے جان لیا ہے کہ رب تمام معبودوں سے عظیم ہے، کیونکہ اُس نے یہ سب کچھ اُن لوگوں کے ساتھ کیا جنہوں نے اپنے غرور میں اسرائیلیوں کے ساتھ بُرا سلوک کیا تھا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","پھر یترو نے اللہ کو بھسم ہونے والی قربانی اور دیگر کئی قربانیاں پیش کیں۔ تب ہارون اور تمام بزرگ موسیٰ کے سُسر یترو کے ساتھ اللہ کے حضور کھانا کھانے بیٹھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","اگلے دن موسیٰ لوگوں کا انصاف کرنے کے لئے بیٹھ گیا۔ اُن کی تعداد اِتنی زیادہ تھی کہ وہ صبح سے لے کر شام تک موسیٰ کے سامنے کھڑے رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","جب یترو نے یہ سب کچھ دیکھا تو اُس نے پوچھا، ”یہ کیا ہے جو آپ لوگوں کے ساتھ کر رہے ہیں؟ سارا دن وہ آپ کو گھیرے رہتے اور آپ اُن کی عدالت کرتے رہتے ہیں۔ آپ یہ سب کچھ اکیلے ہی کیوں کر رہے ہیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","موسیٰ نے جواب دیا، ”لوگ میرے پاس آ کر اللہ کی مرضی معلوم کرتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","جب کبھی کوئی تنازع یا جھگڑا ہوتا ہے تو دونوں پارٹیاں میرے پاس آتی ہیں۔ مَیں فیصلہ کر کے اُنہیں اللہ کے احکام اور ہدایات بتاتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","موسیٰ کے سُسر نے اُس سے کہا، ”آپ کا طریقہ اچھا نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","کام اِتنا وسیع ہے کہ آپ اُسے اکیلے نہیں سنبھال سکتے۔ اِس سے آپ اور وہ لوگ جو آپ کے پاس آتے ہیں بُری طرح تھک جاتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","میری بات سنیں! مَیں آپ کو ایک مشورہ دیتا ہوں۔ اللہ اُس میں آپ کی مدد کرے۔ لازم ہے کہ آپ اللہ کے سامنے قوم کے نمائندہ رہیں اور اُن کے معاملات اُس کے سامنے پیش کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","یہ بھی ضروری ہے کہ آپ اُنہیں اللہ کے احکام اور ہدایات سکھائیں، کہ وہ کس طرح زندگی گزاریں اور کیا کیا کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","لیکن ساتھ ساتھ قوم میں سے قابلِ اعتماد آدمی چنیں۔ وہ ایسے لوگ ہوں جو اللہ کا خوف مانتے ہوں، راست دل ہوں اور رشوت سے نفرت کرتے ہوں۔ اُنہیں ہزار ہزار، سَو سَو، پچاس پچاس اور دس دس آدمیوں پر مقرر کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","اُن آدمیوں کی ذمہ داری یہ ہو گی کہ وہ ہر وقت لوگوں کا انصاف کریں۔ اگر کوئی بہت ہی پیچیدہ معاملہ ہو تو وہ فیصلے کے لئے آپ کے پاس آئیں، لیکن دیگر معاملوں کا فیصلہ وہ خود کریں۔ یوں وہ کام میں آپ کا ہاتھ بٹائیں گے اور آپ کا بوجھ ہلکا ہو جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","اگر میرا یہ مشورہ اللہ کی مرضی کے مطابق ہو اور آپ ایسا کریں تو آپ اپنی ذمہ داری نبھا سکیں گے اور یہ تمام لوگ انصاف کے ملنے پر سلامتی کے ساتھ اپنے اپنے گھر جا سکیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","موسیٰ نے اپنے سُسر کا مشورہ مان لیا اور ایسا ہی کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","اُس نے اسرائیلیوں میں سے قابلِ اعتماد آدمی چنے اور اُنہیں ہزار ہزار، سَو سَو، پچاس پچاس اور دس دس آدمیوں پر مقرر کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","یہ مرد قاضی بن کر مستقل طور پر لوگوں کا انصاف کرنے لگے۔ آسان مسئلوں کا فیصلہ وہ خود کرتے اور مشکل معاملوں کو موسیٰ کے پاس لے آتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","کچھ عرصے بعد موسیٰ نے اپنے سُسر کو رُخصت کیا تو یترو اپنے وطن واپس چلا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","اسرائیلیوں کو مصر سے سفر کرتے ہوئے دو مہینے ہو گئے تھے۔ تیسرے مہینے کے پہلے ہی دن وہ سینا کے ریگستان میں پہنچے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","اُس دن وہ رفیدیم کو چھوڑ کر دشتِ سینا میں آ پہنچے۔ وہاں اُنہوں نے ریگستان میں پہاڑ کے قریب ڈیرے ڈالے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","تب موسیٰ پہاڑ پر چڑھ کر اللہ کے پاس گیا۔ اللہ نے پہاڑ پر سے موسیٰ کو پکار کر کہا، ”یعقوب کے گھرانے بنی اسرائیل کو بتا، ");
INSERT INTO urdgvu_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","’تم نے دیکھا ہے کہ مَیں نے مصریوں کے ساتھ کیا کچھ کیا، اور کہ مَیں تم کو عقاب کے پَروں پر اُٹھا کر یہاں اپنے پاس لایا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","چنانچہ اگر تم میری سنو اور میرے عہد کے مطابق چلو تو پھر تمام قوموں میں سے میری خاص ملکیت ہو گے۔ گو پوری دنیا میری ہی ہے، ");
INSERT INTO urdgvu_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","لیکن تم میرے لئے مخصوص اماموں کی بادشاہی اور مُقدّس قوم ہو گے۔‘ اب جا کر یہ ساری باتیں اسرائیلیوں کو بتا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","موسیٰ نے پہاڑ سے اُتر کر اور قوم کے بزرگوں کو بُلا کر اُنہیں وہ تمام باتیں بتائیں جو کہنے کے لئے رب نے اُسے حکم دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","جواب میں پوری قوم نے مل کر کہا، ”ہم رب کی ہر بات پوری کریں گے جو اُس نے فرمائی ہے۔“ موسیٰ نے پہاڑ پر لوٹ کر رب کو قوم کا جواب بتایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","جب وہ پہنچا تو رب نے موسیٰ سے کہا، ”مَیں گھنے بادل میں تیرے پاس آؤں گا تاکہ لوگ مجھے تجھ سے ہم کلام ہوتے ہوئے سنیں۔ پھر وہ ہمیشہ تجھ پر بھروسا رکھیں گے۔“ تب موسیٰ نے رب کو وہ تمام باتیں بتائیں جو لوگوں نے کی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","رب نے موسیٰ سے کہا، ”اب لوگوں کے پاس لوٹ کر آج اور کل اُنہیں میرے لئے مخصوص و مُقدّس کر۔ وہ اپنے لباس دھو کر ");
INSERT INTO urdgvu_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","تیسرے دن کے لئے تیار ہو جائیں، کیونکہ اُس دن رب لوگوں کے دیکھتے دیکھتے کوہِ سینا پر اُترے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","لوگوں کی حفاظت کے لئے چاروں طرف پہاڑ کی حدیں مقرر کر۔ اُنہیں خبردار کر کہ حدود کو پار نہ کرو۔ نہ پہاڑ پر چڑھو، نہ اُس کے دامن کو چھوؤ۔ جو بھی اُسے چھوئے وہ ضرور مارا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","اور اُسے ہاتھ سے چھو کر نہیں مارنا ہے بلکہ پتھروں یا تیروں سے۔ خواہ انسان ہو یا حیوان، وہ زندہ نہیں رہ سکتا۔ جب تک نرسنگا دیر تک پھونکا نہ جائے اُس وقت تک لوگوں کو پہاڑ پر چڑھنے کی اجازت نہیں ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","موسیٰ نے پہاڑ سے اُتر کر لوگوں کو اللہ کے لئے مخصوص و مُقدّس کیا۔ اُنہوں نے اپنے لباس بھی دھوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","اُس نے اُن سے کہا، ”تیسرے دن کے لئے تیار ہو جاؤ۔ مرد عورتوں سے ہم بستر نہ ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","تیسرے دن صبح پہاڑ پر گھنا بادل چھا گیا۔ بجلی چمکنے لگی، بادل گرجنے لگا اور نرسنگے کی نہایت زوردار آواز سنائی دی۔ خیمہ گاہ میں لوگ لرز اُٹھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","تب موسیٰ لوگوں کو اللہ سے ملنے کے لئے خیمہ گاہ سے باہر پہاڑ کی طرف لے گیا، اور وہ پہاڑ کے دامن میں کھڑے ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","سینا پہاڑ دھوئیں سے ڈھکا ہوا تھا، کیونکہ رب آگ میں اُس پر اُتر آیا۔ پہاڑ سے دھواں اِس طرح اُٹھ رہا تھا جیسے کسی بھٹے سے اُٹھتا ہے۔ پورا پہاڑ شدت سے لرزنے لگا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","نرسنگے کی آواز تیز سے تیز تر ہوتی گئی۔ موسیٰ بولنے لگا اور اللہ اُسے اونچی آواز میں جواب دیتا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","رب سینا پہاڑ کی چوٹی پر اُترا اور موسیٰ کو اوپر آنے کے لئے کہا۔ موسیٰ اوپر چڑھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","رب نے موسیٰ سے کہا، ”فوراً نیچے اُتر کر لوگوں کو خبردار کر کہ وہ مجھے دیکھنے کے لئے پہاڑ کی حدود میں زبردستی داخل نہ ہوں۔ اگر وہ ایسا کریں تو بہت سے ہلاک ہو جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","امام بھی جو رب کے حضور آتے ہیں اپنے آپ کو مخصوص و مُقدّس کریں، ورنہ میرا غضب اُن پر ٹوٹ پڑے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","لیکن موسیٰ نے رب سے کہا، ”لوگ پہاڑ پر نہیں آ سکتے، کیونکہ تُو نے خود ہی ہمیں خبردار کیا کہ ہم پہاڑ کی حدیں مقرر کر کے اُسے مخصوص و مُقدّس کریں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","رب نے جواب دیا، ”توبھی اُتر جا اور ہارون کو ساتھ لے کر واپس آ۔ لیکن اماموں اور لوگوں کو مت آنے دے۔ اگر وہ زبردستی میرے پاس آئیں تو میرا غضب اُن پر ٹوٹ پڑے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","موسیٰ نے لوگوں کے پاس اُتر کر اُنہیں یہ باتیں بتا دیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","تب اللہ نے یہ تمام باتیں فرمائیں، ");
INSERT INTO urdgvu_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","”مَیں رب تیرا خدا ہوں جو تجھے ملکِ مصر کی غلامی سے نکال لایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","میرے سوا کسی اَور معبود کی پرستش نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","اپنے لئے بُت نہ بنانا۔ کسی بھی چیز کی مورت نہ بنانا، چاہے وہ آسمان میں، زمین پر یا سمندر میں ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","نہ بُتوں کی پرستش، نہ اُن کی خدمت کرنا، کیونکہ مَیں تیرا رب غیور خدا ہوں۔ جو مجھ سے نفرت کرتے ہیں اُنہیں مَیں تیسری اور چوتھی پشت تک سزا دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","لیکن جو مجھ سے محبت رکھتے اور میرے احکام پورے کرتے ہیں اُن پر مَیں ہزار پُشتوں تک مہربانی کروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","رب اپنے خدا کا نام بےمقصد یا غلط مقصد کے لئے استعمال نہ کرنا۔ جو بھی ایسا کرتا ہے اُسے رب سزا دیئے بغیر نہیں چھوڑے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","سبت کے دن کا خیال رکھنا۔ اُسے اِس طرح منانا کہ وہ مخصوص و مُقدّس ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ہفتے کے پہلے چھ دن اپنا کام کاج کر، ");
INSERT INTO urdgvu_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","لیکن ساتواں دن رب تیرے خدا کا آرام کا دن ہے۔ اُس دن کسی طرح کا کام نہ کرنا۔ نہ تُو، نہ تیرا بیٹا، نہ تیری بیٹی، نہ تیرا نوکر، نہ تیری نوکرانی اور نہ تیرے مویشی۔ جو پردیسی تیرے درمیان رہتا ہے وہ بھی کام نہ کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","کیونکہ رب نے پہلے چھ دن میں آسمان و زمین، سمندر اور جو کچھ اُن میں ہے بنایا لیکن ساتویں دن آرام کیا۔ اِس لئے رب نے سبت کے دن کو برکت دے کر مقرر کیا کہ وہ مخصوص اور مُقدّس ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","اپنے باپ اور اپنی ماں کی عزت کرنا۔ پھر تُو اُس ملک میں جو رب تیرا خدا تجھے دینے والا ہے دیر تک جیتا رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","قتل نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","زنا نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","چوری نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","اپنے پڑوسی کے بارے میں جھوٹی گواہی نہ دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","اپنے پڑوسی کے گھر کا لالچ نہ کرنا۔ نہ اُس کی بیوی کا، نہ اُس کے نوکر کا، نہ اُس کی نوکرانی کا، نہ اُس کے بَیل اور نہ اُس کے گدھے کا بلکہ اُس کی کسی بھی چیز کا لالچ نہ کرنا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","جب باقی تمام لوگوں نے بادل کی گرج اور نرسنگے کی آواز سنی اور بجلی کی چمک اور پہاڑ سے اُٹھتے ہوئے دھوئیں کو دیکھا تو وہ خوف کے مارے کانپنے لگے اور پہاڑ سے دُور کھڑے ہو گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","اُنہوں نے موسیٰ سے کہا، ”آپ ہی ہم سے بات کریں تو ہم سنیں گے۔ لیکن اللہ کو ہم سے بات نہ کرنے دیں ورنہ ہم مر جائیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","لیکن موسیٰ نے اُن سے کہا، ”مت ڈرو، کیونکہ رب تمہیں جانچنے کے لئے آیا ہے، تاکہ اُس کا خوف تمہاری آنکھوں کے سامنے رہے اور تم گناہ نہ کرو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","لوگ دُور ہی رہے جبکہ موسیٰ اُس گہری تاریکی کے قریب گیا جہاں اللہ تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","تب رب نے موسیٰ سے کہا، ”اسرائیلیوں کو بتا، ’تم نے خود دیکھا کہ مَیں نے آسمان پر سے تمہارے ساتھ باتیں کی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","چنانچہ میری پرستش کے ساتھ ساتھ اپنے لئے سونے یا چاندی کے بُت نہ بناؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","میرے لئے مٹی کی قربان گاہ بنا کر اُس پر اپنی بھیڑبکریوں اور گائےبَیلوں کی بھسم ہونے والی اور سلامتی کی قربانیاں چڑھانا۔ مَیں تجھے وہ جگہیں دکھاؤں گا جہاں میرے نام کی تعظیم میں قربانیاں پیش کرنی ہیں۔ ایسی تمام جگہوں پر مَیں تیرے پاس آ کر تجھے برکت دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","اگر تُو میرے لئے قربان گاہ بنانے کی خاطر پتھر استعمال کرنا چاہے تو تراشے ہوئے پتھر استعمال نہ کرنا۔ کیونکہ تُو تراشنے کے لئے استعمال ہونے والے اوزار سے اُس کی بےحرمتی کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","قربان گاہ کو سیڑھیوں کے بغیر بنانا ہے تاکہ اُس پر چڑھنے سے تیرے لباس کے نیچے سے تیرا ننگاپن نظر نہ آئے۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","اسرائیلیوں کو یہ احکام بتا، ");
INSERT INTO urdgvu_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","’اگر تُو عبرانی غلام خریدے تو وہ چھ سال تیرا غلام رہے۔ اِس کے بعد لازم ہے کہ اُسے آزاد کر دیا جائے۔ آزاد ہونے کے لئے اُسے پیسے دینے کی ضرورت نہیں ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","اگر غلام غیرشادی شدہ حالت میں مالک کے گھر آیا ہو تو وہ آزاد ہو کر اکیلا ہی چلا جائے۔ اگر وہ شادی شدہ حالت میں آیا ہو تو لازم ہے کہ وہ اپنی بیوی سمیت آزاد ہو کر جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","اگر مالک نے غلام کی شادی کرائی اور بچے پیدا ہوئے ہیں تو اُس کی بیوی اور بچے مالک کی ملکیت ہوں گے۔ چھ سال کے بعد جب غلام آزاد ہو کر جائے تو اُس کی بیوی اور بچے مالک ہی کے پاس رہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","اگر غلام کہے، ”مَیں اپنے مالک اور اپنے بیوی بچوں سے محبت رکھتا ہوں، مَیں آزاد نہیں ہونا چاہتا“ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","تو غلام کا مالک اُسے اللہ کے سامنے لائے۔ وہ اُسے دروازے یا اُس کی چوکھٹ کے پاس لے جائے اور سُتالی یعنی تیز اوزار سے اُس کے کان کی لَو چھید دے۔ تب وہ زندگی بھر اُس کا غلام بنا رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","اگر کوئی اپنی بیٹی کو غلامی میں بیچ ڈالے تو اُس کے لئے آزادی ملنے کی شرائط مرد سے فرق ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","اگر اُس کے مالک نے اُسے منتخب کیا کہ وہ اُس کی بیوی بن جائے، لیکن بعد میں وہ اُسے پسند نہ آئے تو لازم ہے کہ وہ مناسب معاوضہ لے کر اُسے اُس کے رشتے داروں کو واپس کر دے۔ اُسے عورت کو غیرملکیوں کے ہاتھ بیچنے کا اختیار نہیں ہے، کیونکہ اُس نے اُس کے ساتھ بےوفا سلوک کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","اگر لونڈی کا مالک اُس کی اپنے بیٹے کے ساتھ شادی کرائے تو عورت کو بیٹی کے حقوق حاصل ہوں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","اگر مالک نے اُس سے شادی کر کے بعد میں دوسری عورت سے بھی شادی کی تو لازم ہے کہ وہ پہلی کو بھی کھانا اور کپڑے دیتا رہے۔ اِس کے علاوہ اُس کے ساتھ ہم بستر ہونے کا فرض بھی ادا کرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","اگر وہ یہ تین فرائض ادا نہ کرے تو اُسے عورت کو آزاد کرنا پڑے گا۔ اِس صورت میں اُسے مفت آزاد کرنا ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","جو کسی کو جان بوجھ کر اِتنا سخت مارتا ہو کہ وہ مر جائے تو اُسے ضرور سزائے موت دینا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","لیکن اگر اُس نے اُسے جان بوجھ کر نہ مارا بلکہ یہ اتفاق سے ہوا اور اللہ نے یہ ہونے دیا، تو مارنے والا ایک ایسی جگہ پناہ لے سکتا ہے جو مَیں مقرر کروں گا۔ وہاں اُسے قتل کئے جانے کی اجازت نہیں ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","لیکن جو دیدہ دانستہ اور چالاکی سے کسی کو مار ڈالتا ہے اُسے میری قربان گاہ سے بھی چھین کر سزائے موت دینا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","جو اپنے باپ یا اپنی ماں کو مارتا پیٹتا ہے اُسے سزائے موت دی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","جس نے کسی کو اغوا کر لیا ہے اُسے سزائے موت دی جائے، چاہے وہ اُسے غلام بنا کر بیچ چکا ہو یا اُسے اب تک اپنے پاس رکھا ہوا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","جو اپنے باپ یا ماں پر لعنت کرے اُسے سزائے موت دی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","ہو سکتا ہے کہ آدمی جھگڑیں اور ایک شخص دوسرے کو پتھر یا مُکے سے اِتنا زخمی کر دے کہ گو وہ بچ جائے وہ بستر سے اُٹھ نہ سکتا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","اگر بعد میں مریض یہاں تک شفا پائے کہ دوبارہ اُٹھ کر لاٹھی کے سہارے چل پھر سکے تو چوٹ پہنچانے والے کو سزا نہیں ملے گی۔ اُسے صرف اُس وقت کے لئے معاوضہ دینا پڑے گا جب تک مریض پیسے نہ کما سکے۔ ساتھ ہی اُسے اُس کا پورا علاج کروانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","جو اپنے غلام یا لونڈی کو لاٹھی سے یوں مارے کہ وہ مر جائے اُسے سزا دی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","لیکن اگر غلام یا لونڈی پٹائی کے بعد ایک یا دو دن زندہ رہے تو مالک کو سزا نہ دی جائے۔ کیونکہ جو رقم اُس نے اُس کے لئے دی تھی اُس کا نقصان اُسے خود اُٹھانا پڑے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","ہو سکتا ہے کہ لوگ آپس میں لڑ رہے ہوں اور لڑتے لڑتے کسی حاملہ عورت سے یوں ٹکرا جائیں کہ اُس کا بچہ ضائع ہو جائے۔ اگر کوئی اَور نقصان نہ ہوا ہو تو ضرب پہنچانے والے کو جرمانہ دینا پڑے گا۔ عورت کا شوہر یہ جرمانہ مقرر کرے، اور عدالت میں اِس کی تصدیق ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","لیکن اگر اُس عورت کو اَور نقصان بھی پہنچا ہو تو پھر ضرب پہنچانے والے کو اِس اصول کے مطابق سزا دی جائے کہ جان کے بدلے جان، ");
INSERT INTO urdgvu_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","آنکھ کے بدلے آنکھ، دانت کے بدلے دانت، ہاتھ کے بدلے ہاتھ، پاؤں کے بدلے پاؤں، ");
INSERT INTO urdgvu_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","جلنے کے زخم کے بدلے جلنے کا زخم، مار کے بدلے مار، کاٹ کے بدلے کاٹ۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","اگر کوئی مالک اپنے غلام کی آنکھ پر یوں مارے کہ وہ ضائع ہو جائے تو اُسے غلام کو آنکھ کے بدلے آزاد کرنا پڑے گا، چاہے غلام مرد ہو یا عورت۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","اگر مالک کے پیٹنے سے غلام کا دانت ٹوٹ جائے تو اُسے غلام کو دانت کے بدلے آزاد کرنا پڑے گا، چاہے غلام مرد ہو یا عورت۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","اگر کوئی بَیل کسی مرد یا عورت کو ایسا مارے کہ وہ مر جائے تو اُس بَیل کو سنگسار کیا جائے۔ اُس کا گوشت کھانے کی اجازت نہیں ہے۔ اِس صورت میں بَیل کے مالک کو سزا نہ دی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","لیکن ہو سکتا ہے کہ مالک کو پہلے آگاہ کیا گیا تھا کہ بَیل لوگوں کو مارتا ہے، توبھی اُس نے بَیل کو کھلا چھوڑا تھا جس کے نتیجے میں اُس نے کسی کو مار ڈالا۔ ایسی صورت میں نہ صرف بَیل کو بلکہ اُس کے مالک کو بھی سنگسار کرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","لیکن اگر فیصلہ کیا جائے کہ وہ اپنی جان کا فدیہ دے تو جتنا معاوضہ بھی مقرر کیا جائے اُسے دینا پڑے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","سزا میں کوئی فرق نہیں ہے، چاہے بیٹے کو مارا جائے یا بیٹی کو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","لیکن اگر بَیل کسی غلام یا لونڈی کو مار دے تو اُس کا مالک غلام کے مالک کو چاندی کے 30 سِکے دے اور بَیل کو سنگسار کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","ہو سکتا ہے کہ کسی نے اپنے حوض کو کھلا رہنے دیا یا حوض بنانے کے لئے گڑھا کھود کر اُسے کھلا رہنے دیا اور کوئی بَیل یا گدھا اُس میں گر کر مر گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ایسی صورت میں حوض کا مالک مُردہ جانور کے لئے پیسے دے۔ وہ جانور کے مالک کو اُس کی پوری قیمت ادا کرے اور مُردہ جانور خود لے لے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","اگر کسی کا بَیل کسی دوسرے کے بَیل کو ایسے مارے کہ وہ مر جائے تو دونوں مالک زندہ بَیل کو بیچ کر اُس کے پیسے آپس میں برابر بانٹ لیں۔ اِسی طرح وہ مُردہ بَیل کو بھی برابر تقسیم کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","لیکن ہو سکتا ہے کہ مالک کو معلوم تھا کہ میرا بَیل دوسرے جانوروں پر حملہ کرتا ہے، اِس کے باوجود اُس نے اُسے آزاد چھوڑدیا تھا۔ ایسی صورت میں اُسے مُردہ بَیل کے عوض اُس کے مالک کو نیا بَیل دینا پڑے گا، اور وہ مُردہ بَیل خود لے لے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","جس نے کوئی بَیل یا بھیڑ چوری کر کے اُسے ذبح کیا یا بیچ ڈالا ہے اُسے ہر چوری کے بَیل کے عوض پانچ بَیل اور ہر چوری کی بھیڑ کے عوض چار بھیڑیں واپس کرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","ہو سکتا ہے کہ کوئی چور نقب لگا رہا ہو اور لوگ اُسے پکڑ کر یہاں تک مارتے پیٹتے رہیں کہ وہ مر جائے۔ اگر رات کے وقت ایسا ہوا ہو تو وہ اُس کے خون کے ذمہ دار نہیں ٹھہر سکتے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","لیکن اگر سورج کے طلوع ہونے کے بعد ایسا ہوا ہو تو جس نے اُسے مارا وہ قاتل ٹھہرے گا۔ چور کو ہر چُرائی ہوئی چیز کا عوضانہ دینا ہے۔ اگر اُس کے پاس دینے کے لئے کچھ نہ ہو تو اُسے غلام بنا کر بیچنا ہے۔ جو پیسے اُسے بیچنے کے عوض ملیں وہ چُرائی ہوئی چیزوں کے بدلے میں دیئے جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","اگر چوری کا جانور چور کے پاس زندہ پایا جائے تو اُسے ہر جانور کے عوض دو دینے پڑیں گے، چاہے وہ بَیل، بھیڑ، بکری یا گدھا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","ہو سکتا ہے کہ کوئی اپنے مویشی کو اپنے کھیت یا انگور کے باغ میں چھوڑ کر چرنے دے اور ہوتے ہوتے وہ کسی دوسرے کے کھیت یا انگور کے باغ میں جا کر چرنے لگے۔ ایسی صورت میں لازم ہے کہ مویشی کا مالک نقصان کے عوض اپنے انگور کے باغ اور کھیت کی بہترین پیداوار میں سے دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","ہو سکتا ہے کہ کسی نے آگ جلائی ہو اور وہ کانٹےدار جھاڑیوں کے ذریعے پڑوسی کے کھیت تک پھیل کر اُس کے اناج کے پُولوں کو، اُس کی پکی ہوئی فصل کو یا کھیت کی کسی اَور پیداوار کو برباد کر دے۔ ایسی صورت میں جس نے آگ جلائی ہو اُسے اُس کی پوری قیمت ادا کرنی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","ہو سکتا ہے کہ کسی نے کچھ پیسے یا کوئی اَور مال اپنے کسی واقف کار کے سپرد کر دیا ہو تاکہ وہ اُسے محفوظ رکھے۔ اگر یہ چیزیں اُس کے گھر سے چوری ہو جائیں اور بعد میں چور کو پکڑا جائے تو چور کو اُس کی دُگنی قیمت ادا کرنی پڑے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","لیکن اگر چور پکڑا نہ جائے تو لازم ہے کہ اُس گھر کا مالک جس کے سپرد یہ چیزیں کی گئی تھیں اللہ کے حضور کھڑا ہو تاکہ معلوم کیا جائے کہ اُس نے خود یہ مال چوری کیا ہے یا نہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","ہو سکتا ہے کہ دو لوگوں کا آپس میں جھگڑا ہو، اور دونوں کسی چیز کے بارے میں دعویٰ کرتے ہوں کہ یہ میری ہے۔ اگر کوئی قیمتی چیز ہو مثلاً بَیل، گدھا، بھیڑ، بکری، کپڑے یا کوئی کھوئی ہوئی چیز تو معاملہ اللہ کے حضور لایا جائے۔ جسے اللہ قصوروار قرار دے اُسے دوسرے کو زیرِبحث چیز کی دُگنی قیمت ادا کرنی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","ہو سکتا ہے کہ کسی نے اپنا کوئی گدھا، بَیل، بھیڑ، بکری یا کوئی اَور جانور کسی واقف کار کے سپرد کر دیا تاکہ وہ اُسے محفوظ رکھے۔ وہاں جانور مر جائے یا زخمی ہو جائے، یا کوئی اُس پر قبضہ کر کے اُسے اُس وقت لے جائے جب کوئی نہ دیکھ رہا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","یہ معاملہ یوں حل کیا جائے کہ جس کے سپرد جانور کیا گیا تھا وہ رب کے حضور قَسم کھا کر کہے کہ مَیں نے اپنے واقف کار کے جانور کے لالچ میں یہ کام نہیں کیا۔ جانور کے مالک کو یہ قبول کرنا پڑے گا، اور دوسرے کو اِس کے بدلے کچھ نہیں دینا ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","لیکن اگر واقعی جانور کو چوری کیا گیا ہے تو جس کے سپرد جانور کیا گیا تھا اُسے اُس کی قیمت ادا کرنی پڑے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","اگر کسی جنگلی جانور نے اُسے پھاڑ ڈالا ہو تو وہ ثبوت کے طور پر پھاڑی ہوئی لاش کو لے آئے۔ پھر اُسے اُس کی قیمت ادا نہیں کرنی پڑے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","ہو سکتا ہے کہ کوئی اپنے واقف کار سے اجازت لے کر اُس کا جانور استعمال کرے۔ اگر جانور کو مالک کی غیرموجودگی میں چوٹ لگے یا وہ مر جائے تو اُس شخص کو جس کے پاس جانور اُس وقت تھا اُس کا معاوضہ دینا پڑے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","لیکن اگر جانور کا مالک اُس وقت ساتھ تھا تو دوسرے کو معاوضہ دینے کی ضرورت نہیں ہو گی۔ اگر اُس نے جانور کو کرائے پر لیا ہو تو اُس کا نقصان کرائے سے پورا ہو جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","اگر کسی کنواری کی منگنی نہیں ہوئی اور کوئی مرد اُسے ورغلا کر اُس سے ہم بستر ہو جائے تو وہ مَہر دے کر اُس سے شادی کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","لیکن اگر لڑکی کا باپ اُس کی اُس مرد کے ساتھ شادی کرنے سے انکار کرے، اِس صورت میں بھی مرد کو کنواری کے لئے مقررہ رقم دینی پڑے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","جادوگرنی کو جینے نہ دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","جو شخص کسی جانور کے ساتھ جنسی تعلقات رکھتا ہو اُسے سزائے موت دی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","جو نہ صرف رب کو قربانیاں پیش کرے بلکہ دیگر معبودوں کو بھی اُسے قوم سے نکال کر ہلاک کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","جو پردیسی تیرے ملک میں مہمان ہے اُسے نہ دبانا اور نہ اُس سے بُرا سلوک کرنا، کیونکہ تم بھی مصر میں پردیسی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","کسی بیوہ یا یتیم سے بُرا سلوک نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","اگر تُو ایسا کرے اور وہ چلّا کر مجھ سے فریاد کریں تو مَیں ضرور اُن کی سنوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","مَیں بڑے غصے میں آ کر تمہیں تلوار سے مار ڈالوں گا۔ پھر تمہاری بیویاں خود بیوائیں اور تمہارے بچے خود یتیم بن جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","اگر تُو نے میری قوم کے کسی غریب کو قرض دیا ہے تو اُس سے سود نہ لینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","اگر تجھے کسی سے اُس کی چادر گروی کے طور پر ملی ہو تو اُسے سورج ڈوبنے سے پہلے ہی واپس کر دینا ہے، ");
INSERT INTO urdgvu_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","کیونکہ اِسی کو وہ سونے کے لئے استعمال کرتا ہے۔ ورنہ وہ کیا چیز اوڑھ کر سوئے گا؟ اگر تُو چادر واپس نہ کرے اور وہ شخص چلّا کر مجھ سے فریاد کرے تو مَیں اُس کی سنوں گا، کیونکہ مَیں مہربان ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","اللہ کو نہ کوسنا، نہ اپنی قوم کے کسی سردار پر لعنت کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","مجھے وقت پر اپنے کھیت اور کولھوؤں کی پیداوار میں سے نذرانے پیش کرنا۔ اپنے پہلوٹھے مجھے دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","اپنے بَیلوں، بھیڑوں اور بکریوں کے پہلوٹھوں کو بھی مجھے دینا۔ جانور کا پہلوٹھا پہلے سات دن اپنی ماں کے ساتھ رہے۔ آٹھویں دن وہ مجھے دیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","اپنے آپ کو میرے لئے مخصوص و مُقدّس رکھنا۔ اِس لئے ایسے جانور کا گوشت مت کھانا جسے کسی جنگلی جانور نے پھاڑ ڈالا ہے۔ ایسے گوشت کو کُتوں کو کھانے دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","غلط افواہیں نہ پھیلانا۔ کسی شریر آدمی کا ساتھ دے کر جھوٹی گواہی دینا منع ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","اگر اکثریت غلط کام کر رہی ہو تو اُس کے پیچھے نہ ہو لینا۔ عدالت میں گواہی دیتے وقت اکثریت کے ساتھ مل کر ایسی بات نہ کرنا جس سے غلط فیصلہ کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","لیکن عدالت میں کسی غریب کی طرف داری بھی نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","اگر تجھے تیرے دشمن کا بَیل یا گدھا آوارہ پھرتا ہوا نظر آئے تو اُسے ہر صورت میں واپس کر دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","اگر تجھ سے نفرت کرنے والے کا گدھا بوجھ تلے گر گیا ہو اور تجھے پتا لگے تو اُسے نہ چھوڑنا بلکہ ضرور اُس کی مدد کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","عدالت میں غریب کے حقوق نہ مارنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ایسے معاملے سے دُور رہنا جس میں لوگ جھوٹ بولتے ہیں۔ جو بےگناہ اور حق پر ہے اُسے سزائے موت نہ دینا، کیونکہ مَیں قصوروار کو حق بجانب نہیں ٹھہراؤں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","رشوت نہ لینا، کیونکہ رشوت دیکھنے والے کو اندھا کر دیتی ہے اور اُس کی بات بننے نہیں دیتی جو حق پر ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","جو پردیسی تیرے ملک میں مہمان ہے اُس پر دباؤ نہ ڈالنا۔ تم ایسے لوگوں کی حالت سے خوب واقف ہو، کیونکہ تم خود مصر میں پردیسی رہے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","چھ سال تک اپنی زمین میں بیج بو کر اُس کی پیداوار جمع کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","لیکن ساتویں سال زمین کو استعمال نہ کرنا بلکہ اُسے پڑے رہنے دینا۔ جو کچھ بھی اُگے وہ قوم کے غریب لوگ کھائیں۔ جو اُن سے بچ جائے اُسے جنگلی جانور کھائیں۔ اپنے انگور اور زیتون کے باغوں کے ساتھ بھی ایسا ہی کرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","چھ دن اپنا کام کاج کرنا، لیکن ساتویں دن آرام کرنا۔ پھر تیرا بَیل اور تیرا گدھا بھی آرام کر سکیں گے، تیری لونڈی کا بیٹا اور تیرے ساتھ رہنے والا پردیسی بھی تازہ دم ہو جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","جو بھی ہدایت مَیں نے دی ہے اُس پر عمل کر۔ دیگر معبودوں کی پرستش نہ کرنا۔ مَیں تیرے منہ سے اُن کے ناموں تک کا ذکر نہ سنوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","سال میں تین دفعہ میری تعظیم میں عید منانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","پہلے، بےخمیری روٹی کی عید منانا۔ ابیب کے مہینے میں سات دن تک تیری روٹی میں خمیر نہ ہو جس طرح مَیں نے حکم دیا ہے، کیونکہ اِس مہینے میں تُو مصر سے نکلا۔ اِن دنوں میں کوئی میرے حضور خالی ہاتھ نہ آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","دوسرے، فصل کٹائی کی عید اُس وقت منانا جب تُو اپنے کھیت میں بوئی ہوئی پہلی فصل کاٹے گا۔ تیسرے، جمع کرنے کی عید فصل کی کٹائی کے اختتام پر منانا ہے جب تُو نے انگور اور باقی باغوں کے پھل جمع کئے ہوں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","یوں تیرے تمام مرد تین مرتبہ رب قادرِ مطلق کے حضور حاضر ہوا کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","جب تُو کسی جانور کو ذبح کر کے قربانی کے طور پر پیش کرے تو اُس کے خون کے ساتھ ایسی روٹی پیش نہ کرنا جس میں خمیر ہو۔ اور جو جانور تُو میری عیدوں پر چڑھائے اُن کی چربی اگلی صبح تک باقی نہ رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","اپنی زمین کی پہلی پیداوار کا بہترین حصہ رب اپنے خدا کے گھر میں لانا۔ بھیڑ یا بکری کے بچے کو اُس کی ماں کے دودھ میں نہ پکانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","مَیں تیرے آگے آگے فرشتہ بھیجتا ہوں جو راستے میں تیری حفاظت کرے گا اور تجھے اُس جگہ تک لے جائے گا جو مَیں نے تیرے لئے تیار کی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","اُس کی موجودگی میں احتیاط برتنا۔ اُس کی سننا، اور اُس کی خلاف ورزی نہ کرنا۔ اگر تُو سرکش ہو جائے تو وہ تجھے معاف نہیں کرے گا، کیونکہ میرا نام اُس میں حاضر ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","لیکن اگر تُو اُس کی سنے اور سب کچھ کرے جو مَیں تجھے بتاتا ہوں تو مَیں تیرے دشمنوں کا دشمن اور تیرے مخالفوں کا مخالف ہوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","کیونکہ میرا فرشتہ تیرے آگے آگے چلے گا اور تجھے ملکِ کنعان تک پہنچا دے گا جہاں اموری، حِتّی، فرِزّی، کنعانی، حِوّی اور یبوسی آباد ہیں۔ تب مَیں اُنہیں رُوئے زمین پر سے مٹا دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","اُن کے معبودوں کو سجدہ نہ کرنا، نہ اُن کی خدمت کرنا۔ اُن کے رسم و رواج بھی نہ اپنانا بلکہ اُن کے بُتوں کو تباہ کر دینا۔ جن ستونوں کے سامنے وہ عبادت کرتے ہیں اُن کو بھی ٹکڑے ٹکڑے کر ڈالنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","رب اپنے خدا کی خدمت کرنا۔ پھر مَیں تیری خوراک اور پانی کو برکت دے کر تمام بیماریاں تجھ سے دُور کروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","پھر تیرے ملک میں نہ کسی کا بچہ ضائع ہو گا، نہ کوئی بانجھ ہو گی۔ ساتھ ہی مَیں تجھے طویل زندگی عطا کروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","مَیں تیرے آگے آگے دہشت پھیلاؤں گا۔ جہاں بھی تُو جائے گا وہاں مَیں تمام قوموں میں ابتری پیدا کروں گا۔ میرے سبب سے تیرے سارے دشمن پلٹ کر بھاگ جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","مَیں تیرے آگے زنبور بھیج دوں گا جو حِوّی، کنعانی اور حِتّی کو ملک چھوڑنے پر مجبور کریں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","لیکن جب تُو وہاں پہنچے گا تو مَیں اُنہیں ایک ہی سال میں ملک سے نہیں نکالوں گا۔ ورنہ پورا ملک ویران ہو جائے گا اور جنگلی جانور پھیل کر تیرے لئے نقصان کا باعث بن جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","اِس لئے مَیں تیرے پہنچنے پر ملک کے باشندوں کو تھوڑا تھوڑا کر کے نکالتا جاؤں گا۔ اِتنے میں تیری تعداد بڑھے گی اور تُو رفتہ رفتہ ملک پر قبضہ کر سکے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","مَیں تیری سرحدیں مقرر کروں گا۔ بحرِ قُلزم ایک حد ہو گی اور فلستیوں کا سمندر دوسری، جنوب کا ریگستان ایک ہو گی اور دریائے فرات دوسری۔ مَیں ملک کے باشندوں کو تیرے قبضے میں کر دوں گا، اور تُو اُنہیں اپنے آگے آگے ملک سے دُور کرتا جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","لازم ہے کہ تُو اُن کے ساتھ یا اُن کے معبودوں کے ساتھ عہد نہ باندھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","اُن کا تیرے ملک میں رہنا منع ہے، ورنہ تُو اُن کے سبب سے میرا گناہ کرے گا۔ اگر تُو اُن کے معبودوں کی عبادت کرے گا تو یہ تیرے لئے پھندا بن جائے گا‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","رب نے موسیٰ سے کہا، ”تُو، ہارون، ندب، ابیہو اور اسرائیل کے 70 بزرگ میرے پاس اوپر آئیں۔ کچھ فاصلے پر کھڑے ہو کر مجھے سجدہ کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","صرف تُو اکیلا ہی میرے قریب آ، دوسرے دُور رہیں۔ اور قوم کے باقی لوگ تیرے ساتھ پہاڑ پر نہ چڑھیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","تب موسیٰ نے قوم کے پاس جا کر رب کی تمام باتیں اور احکام پیش کئے۔ جواب میں سب نے مل کر کہا، ”ہم رب کی اِن تمام باتوں پر عمل کریں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","تب موسیٰ نے رب کی تمام باتیں لکھ لیں۔ اگلے دن وہ صبح سویرے اُٹھا اور پہاڑ کے پاس گیا۔ اُس کے دامن میں اُس نے قربان گاہ بنائی۔ ساتھ ہی اُس نے اسرائیل کے ہر ایک قبیلے کے لئے ایک ایک پتھر کا ستون کھڑا کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","پھر اُس نے کچھ اسرائیلی نوجوانوں کو قربانی پیش کرنے کے لئے بُلایا تاکہ وہ رب کی تعظیم میں بھسم ہونے والی قربانیاں چڑھائیں اور جوان بَیلوں کو سلامتی کی قربانی کے طور پر پیش کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","موسیٰ نے قربانیوں کاخون جمع کیا۔ اُس کا آدھا حصہ اُس نے باسنوں میں ڈال دیا اور آدھا حصہ قربان گاہ پر چھڑک دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","پھر اُس نے وہ کتاب لی جس میں رب کے ساتھ عہد کی تمام شرائط درج تھیں اور اُسے قوم کو پڑھ کر سنایا۔ جواب میں اُنہوں نے کہا، ”ہم رب کی اِن تمام باتوں پر عمل کریں گے۔ ہم اُس کی سنیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","اِس پر موسیٰ نے باسنوں میں سے خون لے کر اُسے لوگوں پر چھڑکا اور کہا، ”یہ خون اُس عہد کی تصدیق کرتا ہے جو رب نے تمہارے ساتھ کیا ہے اور جو اُس کی تمام باتوں پر مبنی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","اِس کے بعد موسیٰ، ہارون، ندب، ابیہو اور اسرائیل کے 70 بزرگ سینا پہاڑ پر چڑھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","وہاں اُنہوں نے اسرائیل کے خدا کو دیکھا۔ لگتا تھا کہ اُس کے پاؤں کے نیچے سنگِ لاجورد کا سا تختہ تھا۔ وہ آسمان کی مانند صاف و شفاف تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","اگرچہ اسرائیل کے راہنماؤں نے یہ سب کچھ دیکھا توبھی رب نے اُنہیں ہلاک نہ کیا، بلکہ وہ اللہ کو دیکھتے رہے اور اُس کے حضور عہد کا کھانا کھاتے اور پیتے رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","پہاڑ سے اُترنے کے بعد رب نے موسیٰ سے کہا، ”میرے پاس پہاڑ پر آ کر کچھ دیر کے لئے ٹھہرے رہنا۔ مَیں تجھے پتھر کی تختیاں دوں گا جن پر مَیں نے اپنی شریعت اور احکام لکھے ہیں اور جو اسرائیل کی تعلیم و تربیت کے لئے ضروری ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","موسیٰ اپنے مددگار یشوع کے ساتھ چل پڑا اور اللہ کے پہاڑ پر چڑھ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","پہلے اُس نے بزرگوں سے کہا، ”ہماری واپسی کے انتظار میں یہاں ٹھہرے رہو۔ ہارون اور حور تمہارے پاس رہیں گے۔ کوئی بھی معاملہ ہو تو لوگ اُن ہی کے پاس جائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","جب موسیٰ چڑھنے لگا تو پہاڑ پر بادل چھا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","رب کا جلال کوہِ سینا پر اُتر آیا۔ چھ دن تک بادل اُس پر چھایا رہا۔ ساتویں دن رب نے بادل میں سے موسیٰ کو بُلایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","رب کا جلال اسرائیلیوں کو بھی نظر آتا تھا۔ اُنہیں یوں لگا جیسا کہ پہاڑ کی چوٹی پر تیز آگ بھڑک رہی ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","چڑھتے چڑھتے موسیٰ بادل میں داخل ہوا۔ وہاں وہ چالیس دن اور چالیس رات رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","”اسرائیلیوں کو بتا کہ وہ ہدیئے لا کر مجھے اُٹھانے والی قربانی کے طور پر پیش کریں۔ لیکن صرف اُن سے ہدیئے قبول کرو جو دلی خوشی سے دیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","اُن سے یہ چیزیں ہدیئے کے طور پر قبول کرو: سونا، چاندی، پیتل؛ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","نیلے، ارغوانی اور قرمزی رنگ کا دھاگا، باریک کتان، بکری کے بال، ");
INSERT INTO urdgvu_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","مینڈھوں کی سرخ رنگی ہوئی کھالیں، تخس کی کھالیں، کیکر کی لکڑی، ");
INSERT INTO urdgvu_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","شمع دان کے لئے زیتون کا تیل، مسح کرنے کے لئے تیل اور خوشبودار بخور کے لئے مسالے، ");
INSERT INTO urdgvu_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","عقیقِ احمر اور دیگر جواہر جو امامِ اعظم کے بالاپوش اور سینے کے کیسے میں جڑے جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","اِن چیزوں سے لوگ میرے لئے مقدِس بنائیں تاکہ مَیں اُن کے درمیان رہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","مَیں تجھے مقدِس اور اُس کے تمام سامان کا نمونہ دکھاؤں گا، کیونکہ تمہیں سب کچھ عین اُسی کے مطابق بنانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_10‏","003_25_10‏","EXO","25","10‏","12","لوگ کیکر کی لکڑی کا صندوق بنائیں۔ اُس کی لمبائی پونے چار فٹ ہو جبکہ اُس کی چوڑائی اور اونچائی سوا دو دو فٹ ہو۔ پورے صندوق پر اندر اور باہر سے خالص سونا چڑھانا۔ اوپر کی سطح کے ارد گرد سونے کی جھالر لگانا۔ صندوق کو اُٹھانے کے لئے سونے کے چار کڑے ڈھال کر اُنہیں صندوق کے چارپائیوں پر لگانا۔ دونوں طرف دو دو کڑے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","پھر کیکر کی دو لکڑیاں صندوق کو اُٹھانے کے لئے تیار کرنا۔ اُن پر سونا چڑھا کر ");
INSERT INTO urdgvu_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","اُن کو دونوں طرف کے کڑوں میں ڈالنا تاکہ اُن سے صندوق کو اُٹھایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","یہ لکڑیاں صندوق کے اِن کڑوں میں پڑی رہیں۔ اُنہیں کبھی بھی دُور نہ کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","صندوق میں شریعت کی وہ دو تختیاں رکھنا جو مَیں تجھے دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","صندوق کا ڈھکنا خالص سونے کا بنانا۔ اُس کی لمبائی پونے چار فٹ اور چوڑائی سوا دو فٹ ہو۔ اُس کا نام کفارے کا ڈھکنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_18‏","003_25_18‏","EXO","25","18‏","19","سونے سے گھڑ کر دو کروبی فرشتے بنائے جائیں جو ڈھکنے کے دونوں سِروں پر کھڑے ہوں۔ یہ دو فرشتے اور ڈھکنا ایک ہی ٹکڑے سے بنانے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","فرشتوں کے پَر یوں اوپر کی طرف پھیلے ہوئے ہوں کہ وہ ڈھکنے کو پناہ دیں۔ اُن کے منہ ایک دوسرے کی طرف کئے ہوئے ہوں، اور وہ ڈھکنے کی طرف دیکھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ڈھکنے کو صندوق پر لگا، اور صندوق میں شریعت کی وہ دو تختیاں رکھ جو مَیں تجھے دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","وہاں ڈھکنے کے اوپر دونوں فرشتوں کے درمیان سے مَیں اپنے آپ کو تجھ پر ظاہر کر کے تجھ سے ہم کلام ہوں گا اور تجھے اسرائیلیوں کے لئے تمام احکام دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","کیکر کی لکڑی کی میز بنانا۔ اُس کی لمبائی تین فٹ، چوڑائی ڈیڑھ فٹ اور اونچائی سوا دو فٹ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","اُس پر خالص سونا چڑھانا، اور اُس کے ارد گرد سونے کی جھالر لگانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","میز کی اوپر کی سطح پر چوکھٹا لگانا جس کی اونچائی تین انچ ہو اور جس پر سونے کی جھالر لگی ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","سونے کے چار کڑے ڈھال کر اُنہیں چاروں کونوں پر لگانا جہاں میز کے پائے لگے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","یہ کڑے میز کی سطح پر لگے چوکھٹے کے نیچے لگائے جائیں۔ اُن میں وہ لکڑیاں ڈالنی ہیں جن سے میز کو اُٹھایا جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","یہ لکڑیاں بھی کیکر کی ہوں اور اُن پر سونا چڑھایا جائے۔ اُن سے میز کو اُٹھانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","اُس کے تھال، پیالے، مرتبان اور مَے کی نذریں پیش کرنے کے برتن خالص سونے سے بنانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","میز پر وہ روٹیاں ہر وقت میرے حضور پڑی رہیں جو میرے لئے مخصوص ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","خالص سونے کا شمع دان بھی بنانا۔ اُس کا پایہ اور ڈنڈی گھڑ کر بنانا ہے۔ اُس کی پیالیاں جو پھولوں اور کلیوں کی شکل کی ہوں گی پائے اور ڈنڈی کے ساتھ ایک ہی ٹکڑا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ڈنڈی سے دائیں اور بائیں طرف تین تین شاخیں نکلیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ہر شاخ پر تین پیالیاں لگی ہوں جو بادام کی کلیوں اور پھولوں کی شکل کی ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","شمع دان کی ڈنڈی پر بھی اِس قسم کی پیالیاں لگی ہوں، لیکن تعداد میں چار۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","اِن میں سے تین پیالیاں دائیں بائیں کی چھ شاخوں کے نیچے لگی ہوں۔ وہ یوں لگی ہوں کہ ہر پیالی سے دو شاخیں نکلیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","شاخیں اور پیالیاں بلکہ پورا شمع دان خالص سونے کے ایک ہی ٹکڑے سے گھڑ کر بنانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","شمع دان کے لئے سات چراغ بنا کر اُنہیں یوں شاخوں پر رکھنا کہ وہ سامنے کی جگہ روشن کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","بتی کترنے کی قینچیاں اور جلتے کوئلے کے لئے چھوٹے برتن بھی خالص سونے سے بنائے جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","شمع دان اور اُس سارے سامان کے لئے پورے 34 کلو گرام خالص سونا استعمال کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","غور کر کہ سب کچھ عین اُس نمونے کے مطابق بنایا جائے جو مَیں تجھے یہاں پہاڑ پر دکھاتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","مُقدّس خیمے کے لئے دس پردے بنانا۔ اُن کے لئے باریک کتان اور نیلے، ارغوانی اور قرمزی رنگ کا دھاگا استعمال کرنا۔ پردوں میں کسی ماہر کاری گر کے کڑھائی کے کام سے کروبی فرشتوں کا ڈیزائن بنوانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ہر پردے کی لمبائی 42 فٹ اور چوڑائی 6 فٹ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","پانچ پردوں کے لمبے حاشئے ایک دوسرے کے ساتھ جوڑے جائیں اور اِسی طرح باقی پانچ بھی۔ یوں دو بڑے ٹکڑے بن جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","دونوں ٹکڑوں کو ایک دوسرے کے ساتھ ملانے کے لئے نیلے دھاگے کے حلقے بنانا۔ یہ حلقے ہر ٹکڑے کے 42 فٹ والے ایک کنارے پر لگائے جائیں، ");
INSERT INTO urdgvu_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ایک ٹکڑے کے حاشئے پر 50 حلقے اور دوسرے پر بھی اُتنے ہی حلقے۔ اِن دو حاشیوں کے حلقے ایک دوسرے کے آمنے سامنے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","پھر سونے کی 50 ہکیں بنا کر اُن سے آمنے سامنے کے حلقے ایک دوسرے کے ساتھ ملانا۔ یوں دونوں ٹکڑے جُڑ کر خیمے کا کام دیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","بکری کے بالوں سے بھی 11 پردے بنانا جنہیں کپڑے والے خیمے کے اوپر رکھا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ہر پردے کی لمبائی 45 فٹ اور چوڑائی 6 فٹ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","پانچ پردوں کے لمبے حاشئے ایک دوسرے کے ساتھ جوڑے جائیں اور اِسی طرح باقی چھ بھی۔ اِن چھ پردوں کے چھٹے پردے کو ایک دفعہ تہہ کرنا۔ یہ سامنے والے حصے سے لٹکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","بکری کے بال کے اِن دونوں ٹکڑوں کو بھی ملانا ہے۔ اِس کے لئے ہر ٹکڑے کے 45 فٹ والے ایک کنارے پر پچاس پچاس حلقے لگانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","پھر پیتل کی 50 ہکیں بنا کر اُن سے دونوں حصے ملانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","جب بکریوں کے بالوں کا یہ خیمہ کپڑے کے خیمے کے اوپر لگایا جائے گا تو آدھا پردہ باقی رہے گا۔ وہ خیمے کی پچھلی طرف لٹکا رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","خیمے کے دائیں اور بائیں طرف بکری کے بالوں کا خیمہ کپڑے کے خیمے کی نسبت ڈیڑھ ڈیڑھ فٹ لمبا ہو گا۔ یوں وہ دونوں طرف لٹکے ہوئے کپڑے کے خیمے کو محفوظ رکھے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ایک دوسرے کے اوپر کے اِن دونوں خیموں کی حفاظت کے لئے دو غلاف بنانے ہیں۔ بکری کے بالوں کے خیمے پر مینڈھوں کی سرخ رنگی ہوئی کھالیں جوڑ کر رکھی جائیں اور اُن پر تخس کی کھالیں ملا کر رکھی جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","کیکر کی لکڑی کے تختے بنانا جو کھڑے کئے جائیں تاکہ خیمے کی دیواروں کا کام دیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ہر تختے کی اونچائی 15 فٹ ہو اور چوڑائی سوا دو فٹ۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ہر تختے کے نیچے دو دو چولیں ہوں۔ یہ چولیں ہر تختے کو اُس کے پائیوں کے ساتھ جوڑیں گی تاکہ تختہ کھڑا رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","خیمے کی جنوبی دیوار کے لئے 20 تختوں کی ضرورت ہے ");
INSERT INTO urdgvu_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","اور ساتھ ہی چاندی کے 40 پائیوں کی۔ اُن پر تختے کھڑے کئے جائیں گے۔ ہر تختے کے نیچے دو پائے ہوں گے، اور ہر پائے میں ایک چول لگے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","اِسی طرح خیمے کی شمالی دیوار کے لئے بھی 20 تختوں کی ضرورت ہے ");
INSERT INTO urdgvu_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","اور ساتھ ہی چاندی کے 40 پائیوں کی۔ وہ بھی تختوں کو کھڑا کرنے کے لئے ہیں۔ ہر تختے کے نیچے دو پائے ہوں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","خیمے کی پچھلی یعنی مغربی دیوار کے لئے چھ تختے بنانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","اِس دیوار کو شمالی اور جنوبی دیواروں کے ساتھ جوڑنے کے لئے کونے والے دو تختے بنانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","اِن دو تختوں میں نیچے سے لے کر اوپر تک کونا ہو تاکہ ایک سے شمالی دیوار مغربی دیوار کے ساتھ جُڑ جائے اور دوسرے سے جنوبی دیوار مغربی دیوار کے ساتھ۔ اِن کے اوپر کے سرے کڑوں سے مضبوط کئے جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","یوں پچھلے یعنی مغربی تختوں کی پوری تعداد 8 ہو گی اور اِن کے لئے چاندی کے پائیوں کی تعداد 16، ہر تختے کے نیچے دو دو پائے ہوں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_26‏","003_26_26‏","EXO","26","26‏","27","اِس کے علاوہ کیکر کی لکڑی کے شہتیر بنانا، تینوں دیواروں کے لئے پانچ پانچ شہتیر۔ وہ ہر دیوار کے تختوں پر یوں لگائے جائیں کہ وہ اُنہیں ایک دوسرے کے ساتھ ملائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","درمیانی شہتیر دیوار کی آدھی اونچائی پر دیوار کے ایک سرے سے دوسرے سرے تک لگایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","شہتیروں کو تختوں کے ساتھ لگانے کے لئے سونے کے کڑے بنا کر تختوں میں لگانا۔ تمام تختوں اور شہتیروں پر سونا چڑھانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","پورے مُقدّس خیمے کو اُسی نمونے کے مطابق بنانا جو مَیں تجھے پہاڑ پر دکھاتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","اب ایک اَور پردہ بنانا۔ اِس کے لئے بھی باریک کتان اور نیلے، ارغوانی اور قرمزی رنگ کا دھاگا استعمال کرنا۔ اُس پر بھی کسی ماہر کاری گر کے کڑھائی کے کام سے کروبی فرشتوں کا ڈیزائن بنوانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","اِسے سونے کی ہکوں سے کیکر کی لکڑی کے چار ستونوں سے لٹکانا۔ اِن ستونوں پر سونا چڑھایا جائے اور وہ چاندی کے پائیوں پر کھڑے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","یہ پردہ مُقدّس کمرے کو مُقدّس ترین کمرے سے الگ کرے گا جس میں عہد کا صندوق پڑا رہے گا۔ پردے کو لٹکانے کے بعد اُس کے پیچھے مُقدّس ترین کمرے میں عہد کا صندوق رکھنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","پھر عہد کے صندوق پر کفارے کا ڈھکنا رکھنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","جس میز پر میرے لئے مخصوص کی گئی روٹیاں پڑی رہتی ہیں وہ پردے کے باہر مُقدّس کمرے میں شمال کی طرف رکھی جائے۔ اُس کے مقابل جنوب کی طرف شمع دان رکھا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","پھر خیمے کے دروازے کے لئے بھی پردہ بنایا جائے۔ اِس کے لئے بھی باریک کتان اور نیلے، ارغوانی اور قرمزی رنگ کا دھاگا استعمال کیا جائے۔ اِس پر کڑھائی کا کام کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","اِس پردے کو سونے کی ہکوں سے کیکر کی لکڑی کے پانچ ستونوں سے لٹکانا۔ اِن ستونوں پر بھی سونا چڑھایا جائے، اور وہ پیتل کے پائیوں پر کھڑے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","کیکر کی لکڑی کی قربان گاہ بنانا۔ اُس کی اونچائی ساڑھے چار فٹ ہو جبکہ اُس کی لمبائی اور چوڑائی ساڑھے سات سات فٹ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","اُس کے اوپر چاروں کونوں میں سے ایک ایک سینگ نکلے۔ سینگ اور قربان گاہ ایک ہی ٹکڑے کے ہوں۔ سب پر پیتل چڑھانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","اُس کا تمام ساز و سامان اور برتن بھی پیتل کے ہوں یعنی راکھ کو اُٹھا کر لے جانے کی بالٹیاں، بیلچے، کانٹے، جلتے ہوئے کوئلے کے لئے برتن اور چھڑکاؤ کے کٹورے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","قربان گاہ کو اُٹھانے کے لئے پیتل کا جنگلا بنانا جو اوپر سے کھلا ہو۔ جنگلے کے چاروں کونوں پر کڑے لگائے جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","قربان گاہ کی آدھی اونچائی پر کنارہ لگانا، اور قربان گاہ کو جنگلے میں اِس کنارے تک رکھا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","اُسے اُٹھانے کے لئے کیکر کی دو لکڑیاں بنانا جن پر پیتل چڑھانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","اُن کو قربان گاہ کے دونوں طرف کے کڑوں میں ڈال دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","پوری قربان گاہ لکڑی کی ہو، لیکن اندر سے کھوکھلی ہو۔ اُسے عین اُس نمونے کے مطابق بنانا جو مَیں تجھے پہاڑ پر دکھاتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","مُقدّس خیمے کے لئے صحن بنانا۔ اُس کی چاردیواری باریک کتان کے کپڑے سے بنائی جائے۔ چاردیواری کی لمبائی جنوب کی طرف 150 فٹ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","کپڑے کو چاندی کی ہکوں اور پٹیوں سے لکڑی کے 20 کھمبوں کے ساتھ لگایا جائے۔ ہر کھمبا پیتل کے پائے پر کھڑا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","چاردیواری شمال کی طرف بھی اِسی کی مانند ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","خیمے کے پیچھے مغرب کی طرف چاردیواری کی چوڑائی 75 فٹ ہو اور کپڑا لکڑی کے 10 کھمبوں کے ساتھ لگایا جائے۔ یہ کھمبے بھی پیتل کے پائیوں پر کھڑے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","سامنے، مشرق کی طرف جہاں سے سورج طلوع ہوتا ہے چاردیواری کی چوڑائی بھی 75 فٹ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_14‏","003_27_14‏","EXO","27","14‏","15","یہاں چاردیواری کا دروازہ ہو۔ کپڑا دروازے کے دائیں طرف ساڑھے 22 فٹ چوڑا ہو اور اُس کے بائیں طرف بھی اُتنا ہی چوڑا۔ اُسے دونوں طرف تین تین لکڑی کے کھمبوں کے ساتھ لگایا جائے جو پیتل کے پائیوں پر کھڑے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","دروازے کا پردہ 30 فٹ چوڑا بنانا۔ وہ نیلے، ارغوانی اور قرمزی رنگ کے دھاگے اور باریک کتان سے بنایا جائے، اور اُس پر کڑھائی کا کام ہو۔ یہ کپڑا لکڑی کے چار کھمبوں کے ساتھ لگایا جائے۔ وہ بھی پیتل کے پائیوں پر کھڑے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","تمام کھمبے پیتل کے پائیوں پر کھڑے ہوں اور کپڑا چاندی کی ہکوں اور پٹیوں سے ہر کھمبے کے ساتھ لگایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","چاردیواری کی لمبائی 150 فٹ، چوڑائی 75 فٹ اور اونچائی ساڑھے 7 فٹ ہو۔ کھمبوں کے تمام پائے پیتل کے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","جو بھی ساز و سامان مُقدّس خیمے میں استعمال کیا جاتا ہے وہ سب پیتل کا ہو۔ خیمے اور چاردیواری کی میخیں بھی پیتل کی ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","اسرائیلیوں کو حکم دینا کہ وہ تیرے پاس کوٹے ہوئے زیتونوں کا خالص تیل لائیں تاکہ مُقدّس کمرے کے شمع دان کے چراغ متواتر جلتے رہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ہارون اور اُس کے بیٹے شمع دان کو ملاقات کے خیمے کے مُقدّس کمرے میں رکھیں، اُس پردے کے سامنے جس کے پیچھے عہد کا صندوق ہے۔ اُس میں وہ تیل ڈالتے رہیں تاکہ وہ رب کے سامنے شام سے لے کر صبح تک جلتا رہے۔ اسرائیلیوں کا یہ اصول ابد تک قائم رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","اپنے بھائی ہارون اور اُس کے بیٹوں ندب، ابیہو، اِلی عزر اور اِتمر کو بُلا۔ مَیں نے اُنہیں اسرائیلیوں میں سے چن لیا ہے تاکہ وہ اماموں کی حیثیت سے میری خدمت کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","اپنے بھائی ہارون کے لئے مُقدّس لباس بنوانا جو پُروقار اور شاندار ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","لباس بنانے کی ذمہ داری اُن تمام لوگوں کو دینا جو ایسے کاموں میں ماہر ہیں اور جن کو مَیں نے حکمت کی روح سے بھر دیا ہے۔ کیونکہ جب ہارون کو مخصوص کیا جائے گا اور وہ مُقدّس خیمے کی خدمت سرانجام دے گا تو اُسے اِن کپڑوں کی ضرورت ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","اُس کے لئے یہ لباس بنانے ہیں: سینے کا کیسہ، بالاپوش، چوغہ، بُنا ہوا زیرجامہ، پگڑی اور کمربند۔ یہ کپڑے اپنے بھائی ہارون اور اُس کے بیٹوں کے لئے بنوانے ہیں تاکہ وہ امام کے طور پر خدمت کر سکیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","اِن کپڑوں کے لئے سونا اور نیلے، ارغوانی اور قرمزی رنگ کا دھاگا اور باریک کتان استعمال کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","بالاپوش کو بھی سونے اور نیلے، ارغوانی اور قرمزی رنگ کے دھاگے اور باریک کتان سے بنانا ہے۔ اُس پر کسی ماہر کاری گر سے کڑھائی کا کام کروایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","اُس کی دو پٹیاں ہوں جو کندھوں پر رکھ کر سامنے اور پیچھے سے بالاپوش کے ساتھ لگی ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","اِس کے علاوہ ایک پٹکا بُننا ہے جس سے بالاپوش کو باندھا جائے اور جو بالاپوش کے ساتھ ایک ٹکڑا ہو۔ اُس کے لئے بھی سونا، نیلے، ارغوانی اور قرمزی رنگ کا دھاگا اور باریک کتان استعمال کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","پھر عقیقِ احمر کے دو پتھر چن کر اُن پر اسرائیل کے بارہ بیٹوں کے نام کندہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ہر جوہر پر چھ چھ نام اُن کی پیدائش کی ترتیب کے مطابق کندہ کئے جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","یہ نام اُس طرح جوہروں پر کندہ کئے جائیں جس طرح مُہر کندہ کی جاتی ہے۔ پھر دونوں جوہر سونے کے خانوں میں جڑ کر ");
INSERT INTO urdgvu_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","بالاپوش کی دو پٹیوں پر ایسے لگانا کہ کندھوں پر آ جائیں۔ جب ہارون میرے حضور آئے گا تو جوہروں پر کے یہ نام اُس کے کندھوں پر ہوں گے اور مجھے اسرائیلیوں کی یاد دلائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","سونے کے خانے بنانا ");
INSERT INTO urdgvu_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","اور خالص سونے کی دو زنجیریں جو ڈوری کی طرح گُندھی ہوئی ہوں۔ پھر اِن دو زنجیروں کو سونے کے خانوں کے ساتھ لگانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","سینے کے لئے کیسہ بنانا۔ اُس میں وہ قرعے پڑے رہیں جن کی معرفت میری مرضی معلوم کی جائے گی۔ ماہر کاری گر اُسے اُن ہی چیزوں سے بنائے جن سے ہارون کا بالاپوش بنایا گیا ہے یعنی سونے اور نیلے، ارغوانی اور قرمزی رنگ کے دھاگے اور باریک کتان سے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","جب کپڑے کو ایک دفعہ تہہ کیا گیا ہو تو کیسے کی لمبائی اور چوڑائی نو نو انچ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","اُس پر چار قطاروں میں جواہر جڑنا۔ ہر قطار میں تین تین جوہر ہوں۔ پہلی قطار میں لعل، زبرجد اور زمرد۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","دوسری میں فیروزہ، سنگِ لاجوردحجر القمر۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","تیسری میں زرقون، عقیق اور یاقوتِ ارغوانی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","چوتھی میں پکھراج، عقیقِ احمر اور یشب۔ ہر جوہر سونے کے خانے میں جڑا ہوا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","یہ بارہ جواہر اسرائیل کے بارہ قبیلوں کی نمائندگی کرتے ہیں۔ ایک ایک جوہر پر ایک قبیلے کا نام کندہ کیا جائے۔ یہ نام اُس طرح کندہ کئے جائیں جس طرح مُہر کندہ کی جاتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","سینے کے کیسے پر خالص سونے کی دو زنجیریں لگانا جو ڈوری کی طرح گُندھی ہوئی ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","اُنہیں لگانے کے لئے دو کڑے بنا کر کیسے کے اوپر کے دو کونوں پر لگانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","اب دونوں زنجیریں اُن دو کڑوں سے لگانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","اُن کے دوسرے سرے بالاپوش کی کندھوں والی پٹیوں کے دو خانوں کے ساتھ جوڑ دینا، پھر سامنے کی طرف لگانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","کیسے کے نچلے دو کونوں پر بھی سونے کے دو کڑے لگانا۔ وہ اندر، بالاپوش کی طرف لگے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","اب دو اَور کڑے بنا کر بالاپوش کی کندھوں والی پٹیوں پر لگانا۔ یہ بھی سامنے کی طرف لگے ہوں لیکن نیچے، بالاپوش کے پٹکے کے اوپر ہی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","سینے کے کیسے کے نچلے کڑے نیلی ڈوری سے بالاپوش کے اِن نچلے کڑوں کے ساتھ باندھے جائیں۔ یوں کیسہ پٹکے کے اوپر اچھی طرح سینے کے ساتھ لگا رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","جب بھی ہارون مقدِس میں داخل ہو کر رب کے حضور آئے گا وہ اسرائیلی قبیلوں کے نام اپنے دل پر سینے کے کیسے کی صورت میں ساتھ لے جائے گا۔ یوں وہ قوم کی یاد دلاتا رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","سینے کے کیسے میں دونوں قرعے بنام اُوریم اور تُمیم رکھے جائیں۔ وہ بھی مقدِس میں رب کے سامنے آتے وقت ہارون کے دل پر ہوں۔ یوں جب ہارون رب کے حضور ہو گا تو رب کی مرضی پوچھنے کا وسیلہ ہمیشہ اُس کے دل پر ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","چوغہ بھی بُننا۔ وہ پوری طرح نیلے دھاگے سے بنایا جائے۔ چوغے کو بالاپوش سے پہلے پہنا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","اُس کے گریبان کو بُنے ہوئے کالر سے مضبوط کیا جائے تاکہ وہ نہ پھٹے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","نیلے، ارغوانی اور قرمزی رنگ کے دھاگے سے انار بنا کر اُنہیں چوغے کے دامن میں لگا دینا۔ اُن کے درمیان سونے کی گھنٹیاں لگانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","دامن میں انار اور گھنٹیاں باری باری لگانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ہارون خدمت کرتے وقت ہمیشہ چوغہ پہنے۔ جب وہ مقدِس میں رب کے حضور آئے گا اور وہاں سے نکلے گا تو گھنٹیاں سنائی دیں گی۔ پھر وہ نہیں مرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","خالص سونے کی تختی بنا کر اُس پر یہ الفاظ کندہ کرنا، ’رب کے لئے مخصوص و مُقدّس۔‘ یہ الفاظ یوں کندہ کئے جائیں جس طرح مُہر کندہ کی جاتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","اُسے نیلی ڈوری سے پگڑی کے سامنے والے حصے سے لگایا جائے ");
INSERT INTO urdgvu_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","تاکہ وہ ہارون کے ماتھے پر پڑی رہے۔ جب بھی وہ مقدِس میں جائے تو یہ تختی ساتھ ہو۔ جب اسرائیلی اپنے نذرانے لا کر رب کے لئے مخصوص کریں لیکن کسی غلطی کے باعث قصوروار ہوں تو اُن کا یہ قصور ہارون پر منتقل ہو گا۔ اِس لئے یہ تختی ہر وقت اُس کے ماتھے پر ہو تاکہ رب اسرائیلیوں کو قبول کر لے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","زیر جامے کو باریک کتان سے بُننا اور اِس طرح پگڑی بھی۔ پھر کمربند بنانا۔ اُس پر کڑھائی کا کام کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","ہارون کے بیٹوں کے لئے بھی زیر جامے، کمربند اور پگڑیاں بنانا تاکہ وہ پُروقار اور شاندار نظر آئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","یہ سب اپنے بھائی ہارون اور اُس کے بیٹوں کو پہنانا۔ اُن کے سروں پر تیل اُنڈیل کر اُنہیں مسح کرنا۔ یوں اُنہیں اُن کے عُہدے پر مقرر کر کے میری خدمت کے لئے مخصوص کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","اُن کے لئے کتان کے پاجامے بھی بنانا تاکہ وہ زیر جامے کے نیچے ننگے نہ ہوں۔ اُن کی لمبائی کمر سے ران تک ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","جب بھی ہارون اور اُس کے بیٹے ملاقات کے خیمے میں داخل ہوں تو اُنہیں یہ پاجامے پہننے ہیں۔ اِسی طرح جب اُنہیں مُقدّس کمرے میں خدمت کرنے کے لئے قربان گاہ کے پاس آنا ہوتا ہے تو وہ یہ پہنیں، ورنہ وہ قصوروار ٹھہر کر مر جائیں گے۔ یہ ہارون اور اُس کی اولاد کے لئے ایک ابدی اصول ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","اماموں کو مقدِس میں میری خدمت کے لئے مخصوص کرنے کا یہ طریقہ ہے: ایک جوان بَیل اور دو بےعیب مینڈھے چن لینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","بہترین میدے سے تین قسم کی چیزیں پکانا جن میں خمیر نہ ہو۔ پہلے، سادہ روٹی۔ دوسرے، روٹی جس میں تیل ڈالا گیا ہو۔ تیسرے، روٹی جس پر تیل لگایا گیا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","یہ چیزیں ٹوکری میں رکھ کر جوان بَیل اور دو مینڈھوں کے ساتھ رب کو پیش کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","پھر ہارون اور اُس کے بیٹوں کو ملاقات کے خیمے کے دروازے پر لا کر غسل کرانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","اِس کے بعد زیرجامہ، چوغہ، بالاپوش اور سینے کا کیسہ لے کر ہارون کو پہنانا۔ بالاپوش کو اُس کے مہارت سے بُنے ہوئے پٹکے کے ذریعے باندھنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","اُس کے سر پر پگڑی باندھ کر اُس پر سونے کی مُقدّس تختی لگانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ہارون کے سر پر مسح کا تیل اُنڈیل کر اُسے مسح کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","پھر اُس کے بیٹوں کو آگے لا کر زیرجامہ پہنانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","اُن کے پگڑیاں اور کمربند باندھنا۔ یوں تُو ہارون اور اُس کے بیٹوں کو اُن کے منصب پر مقرر کرنا۔ صرف وہ اور اُن کی اولاد ہمیشہ تک مقدِس میں میری خدمت کرتے رہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","بَیل کو ملاقات کے خیمے کے سامنے لانا۔ ہارون اور اُس کے بیٹے اُس کے سر پر اپنے ہاتھ رکھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","اُسے خیمے کے دروازے کے سامنے رب کے حضور ذبح کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","بَیل کے خون میں سے کچھ لے کر اپنی اُنگلی سے قربان گاہ کے سینگوں پر لگانا اور باقی خون قربان گاہ کے پائے پر اُنڈیل دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","انتڑیوں پر کی تمام چربی، جوڑ کلیجی اور دونوں گُردے اُن کی چربی سمیت لے کر قربان گاہ پر جلا دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","لیکن بَیل کے گوشت، کھال اور انتڑیوں کے گوبر کو خیمہ گاہ کے باہر جلا دینا۔ یہ گناہ کی قربانی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","اِس کے بعد پہلے مینڈھے کو لے آنا۔ ہارون اور اُس کے بیٹے اپنے ہاتھ مینڈھے کے سر پر رکھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","اُسے ذبح کر کے اُس کا خون قربان گاہ کے چار پہلوؤں پر چھڑکنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","مینڈھے کو ٹکڑے ٹکڑے کر کے اُس کی انتڑیوں اور پنڈلیوں کو دھونا۔ پھر اُنہیں سر اور باقی ٹکڑوں کے ساتھ ملا کر ");
INSERT INTO urdgvu_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","پورے مینڈھے کو قربان گاہ پر جلا دینا۔ جلنے والی یہ قربانی رب کے لئے بھسم ہونے والی قربانی ہے، اور اُس کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","اب دوسرے مینڈھے کو لے آنا۔ ہارون اور اُس کے بیٹے اپنے ہاتھ مینڈھے کے سر پر رکھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","اُس کو ذبح کرنا۔ اُس کے خون میں سے کچھ لے کر ہارون اور اُس کے بیٹوں کے دہنے کان کی لَو پر لگانا۔ اِسی طرح خون کو اُن کے دہنے ہاتھ اور دہنے پاؤں کے انگوٹھوں پر بھی لگانا۔ باقی خون قربان گاہ کے چار پہلوؤں پر چھڑکنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","جو خون قربان گاہ پر پڑا ہے اُس میں سے کچھ لے کر اور مسح کے تیل کے ساتھ ملا کر ہارون اور اُس کے کپڑوں پر چھڑکنا۔ اِسی طرح اُس کے بیٹوں اور اُن کے کپڑوں پر بھی چھڑکنا۔ یوں وہ اور اُس کے بیٹے خدمت کے لئے مخصوص و مُقدّس ہو جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","اِس مینڈھے کا خاص مقصد یہ ہے کہ ہارون اور اُس کے بیٹوں کو مقدِس میں خدمت کرنے کا اختیار اور عُہدہ دیا جائے۔ مینڈھے کی چربی، دُم، انتڑیوں پر کی ساری چربی، جوڑ کلیجی، دونوں گُردے اُن کی چربی سمیت اور دہنی ران الگ کرنی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","اُس ٹوکری میں سے جو رب کے حضور یعنی خیمے کے دروازے پر پڑی ہے ایک سادہ روٹی، ایک روٹی جس میں تیل ڈالا گیا ہو اور ایک روٹی جس پر تیل لگایا گیا ہو نکالنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","مینڈھے سے الگ کی گئی چیزیں اور بےخمیری روٹی کی ٹوکری کی یہ چیزیں لے کر ہارون اور اُس کے بیٹوں کے ہاتھوں میں دینا، اور وہ اُنہیں ہلانے والی قربانی کے طور پر رب کے سامنے ہلائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","پھر یہ چیزیں اُن سے واپس لے کر بھسم ہونے والی قربانی کے ساتھ قربان گاہ پر جلا دینا۔ یہ رب کے لئے جلنے والی قربانی ہے، اور اُس کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","اب اُس مینڈھے کا سینہ لینا جس کی معرفت ہارون کو امامِ اعظم کا اختیار دیا جاتا ہے۔ سینے کو بھی ہلانے والی قربانی کے طور پر رب کے سامنے ہلانا۔ یہ سینہ قربانی کا تیرا حصہ ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","یوں تجھے ہارون اور اُس کے بیٹوں کی مخصوصیت کے لئے مستعمل مینڈھے کے ٹکڑے مخصوص و مُقدّس کرنے ہیں۔ اُس کے سینے کو رب کے سامنے ہلانے والی قربانی کے طور پر ہلایا جائے اور اُس کی ران کو اُٹھانے والی قربانی کے طور پر اُٹھایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ہارون اور اُس کی اولاد کو اسرائیلیوں کی طرف سے ہمیشہ تک یہ ملنے کا حق ہے۔ جب بھی اسرائیلی رب کو اپنی سلامتی کی قربانیاں پیش کریں تو اماموں کو یہ دو ٹکڑے ملیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","جب ہارون فوت ہو جائے گا تو اُس کے مُقدّس لباس اُس کی اولاد میں سے اُس مرد کو دینے ہیں جسے مسح کر کے ہارون کی جگہ مقرر کیا جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","جو بیٹا اُس کی جگہ مقرر کیا جائے گا اور مقدِس میں خدمت کرنے کے لئے ملاقات کے خیمے میں آئے گا وہ یہ لباس سات دن تک پہنے رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","جو مینڈھا ہارون اور اُس کے بیٹوں کی مخصوصیت کے لئے ذبح کیا گیا ہے اُسے مُقدّس جگہ پر اُبالنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","پھر ہارون اور اُس کے بیٹے ملاقات کے خیمے کے دروازے پر مینڈھے کا گوشت اور ٹوکری کی بےخمیری روٹیاں کھائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","وہ یہ چیزیں کھائیں جن سے اُنہیں گناہوں کا کفارہ اور امام کا عُہدہ ملا ہے۔ لیکن کوئی اَور یہ نہ کھائے، کیونکہ یہ مخصوص و مُقدّس ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","اور اگر اگلی صبح تک اِس گوشت یا روٹی میں سے کچھ بچ جائے تو اُسے جلایا جائے۔ اُسے کھانا منع ہے، کیونکہ وہ مُقدّس ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","جب تُو ہارون اور اُس کے بیٹوں کو امام مقرر کرے گا تو عین میری ہدایت پر عمل کرنا۔ یہ تقریب سات دن تک منائی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","اِس کے دوران گناہ کی قربانی کے طور پر روزانہ ایک جوان بَیل ذبح کرنا۔ اِس سے تُو قربان گاہ کا کفارہ دے کر اُسے ہر طرح کی ناپاکی سے پاک کرے گا۔ اِس کے علاوہ اُس پر مسح کا تیل اُنڈیلنا۔ اِس سے وہ میرے لئے مخصوص و مُقدّس ہو جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","سات دن تک قربان گاہ کا کفارہ دے کر اُسے پاک صاف کرنا اور اُسے تیل سے مخصوص و مُقدّس کرنا۔ پھر قربان گاہ نہایت مُقدّس ہو گی۔ جو بھی اُسے چھوئے گا وہ بھی مخصوص و مُقدّس ہو جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","روزانہ ایک ایک سال کے دو بھیڑ کے نر بچے قربان گاہ پر جلا دینا، ");
INSERT INTO urdgvu_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ایک کو صبح کے وقت، دوسرے کو سورج کے غروب ہونے کے عین بعد۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","پہلے جانور کے ساتھ ڈیڑھ کلو گرام بہترین میدہ پیش کیا جائے جو کوٹے ہوئے زیتونوں کے ایک لٹر تیل کے ساتھ ملایا گیا ہو۔ مَے کی نذر کے طور پر ایک لٹر مَے بھی قربان گاہ پر اُنڈیلنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","دوسرے جانور کے ساتھ بھی غلہ اور مَے کی یہ دو نذریں پیش کی جائیں۔ ایسی قربانی کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","لازم ہے کہ آنے والی تمام نسلیں بھسم ہونے والی یہ قربانی باقاعدگی سے مُقدّس خیمے کے دروازے پر رب کے حضور چڑھائیں۔ وہاں مَیں تم سے ملا کروں گا اور تم سے ہم کلام ہوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","وہاں مَیں اسرائیلیوں سے بھی ملا کروں گا، اور وہ جگہ میرے جلال سے مخصوص و مُقدّس ہو جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","یوں مَیں ملاقات کے خیمے اور قربان گاہ کو مخصوص کروں گا اور ہارون اور اُس کے بیٹوں کو مخصوص کروں گا تاکہ وہ اماموں کی حیثیت سے میری خدمت کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","تب مَیں اسرائیلیوں کے درمیان رہوں گا اور اُن کا خدا ہوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","وہ جان لیں گے کہ مَیں رب اُن کا خدا ہوں، کہ مَیں اُنہیں مصر سے نکال لایا تاکہ اُن کے درمیان سکونت کروں۔ مَیں رب اُن کا خدا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","کیکر کی لکڑی کی قربان گاہ بنانا جس پر بخور جلایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","وہ ڈیڑھ فٹ لمبی، اِتنی ہی چوڑی اور تین فٹ اونچی ہو۔ اُس کے چاروں کونوں میں سے سینگ نکلیں جو قربان گاہ کے ساتھ ایک ہی ٹکڑے سے بنائے گئے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","اُس کی اوپر کی سطح، اُس کے چار پہلوؤں اور اُس کے سینگوں پر خالص سونا چڑھانا۔ اوپر کی سطح کے ارد گرد سونے کی جھالر ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","سونے کے دو کڑے بنا کر اِنہیں اُس جھالر کے نیچے ایک دوسرے کے مقابل پہلوؤں پر لگانا۔ اِن کڑوں میں قربان گاہ کو اُٹھانے کی لکڑیاں ڈالی جائیں گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","یہ لکڑیاں کیکر کی ہوں، اور اُن پر بھی سونا چڑھانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","اِس قربان گاہ کو خیمے کے مُقدّس کمرے میں اُس پردے کے سامنے رکھنا جس کے پیچھے عہد کا صندوق اور اُس کا ڈھکنا ہوں گے، وہ ڈھکنا جہاں مَیں تجھ سے ملا کروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","جب ہارون ہر صبح شمع دان کے چراغ تیار کرے اُس وقت وہ اُس پر خوشبودار بخور جلائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","سورج کے غروب ہونے کے بعد بھی جب وہ دوبارہ چراغوں کی دیکھ بھال کرے گا تو وہ ساتھ ساتھ بخور جلائے۔ یوں رب کے سامنے بخور متواتر جلتا رہے۔ لازم ہے کہ بعد کی نسلیں بھی اِس اصول پر قائم رہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","اِس قربان گاہ پر صرف جائز بخور استعمال کیا جائے۔ اِس پر نہ تو جانوروں کی قربانیاں چڑھائی جائیں، نہ غلہ یا مَے کی نذریں پیش کی جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","ہارون سال میں ایک دفعہ اُس کا کفارہ دے کر اُسے پاک کرے۔ اِس کے لئے وہ کفارے کے دن اُس قربانی کا کچھ خون سینگوں پر لگائے۔ یہ اصول بھی ابد تک قائم رہے۔ یہ قربان گاہ رب کے لئے نہایت مُقدّس ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","”جب بھی تُو اسرائیلیوں کی مردم شماری کرے تو لازم ہے کہ جن کا شمار کیا گیا ہو وہ رب کو اپنی جان کا فدیہ دیں تاکہ اُن میں وبا نہ پھیلے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","جس جس کا شمار کیا گیا ہو وہ چاندی کے آدھے سِکے کے برابر رقم اُٹھانے والی قربانی کے طور پر دے۔ سِکے کا وزن مقدِس کے سِکوں کے برابر ہو۔ یعنی چاندی کے سِکے کا وزن 11 گرام ہو، اِس لئے چھ گرام چاندی دینی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","جس کی بھی عمر 20 سال یا اِس سے زائد ہو وہ رب کو یہ رقم اُٹھانے والی قربانی کے طور پر دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","امیر اور غریب دونوں اِتنا ہی دیں، کیونکہ یہی نذرانہ رب کو پیش کرنے سے تمہاری جان کا کفارہ دیا جاتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","کفارے کی یہ رقم ملاقات کے خیمے کی خدمت کے لئے استعمال کرنا۔ پھر یہ نذرانہ رب کو یاد دلاتا رہے گا کہ تمہاری جانوں کا کفارہ دیا گیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","”پیتل کا ڈھانچا بنانا جس پر پیتل کا حوض بنا کر رکھنا ہے۔ یہ حوض دھونے کے لئے ہے۔ اُسے صحن میں ملاقات کے خیمے اور جانوروں کو چڑھانے کی قربان گاہ کے درمیان رکھ کر پانی سے بھر دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ہارون اور اُس کے بیٹے اپنے ہاتھ پاؤں دھونے کے لئے اُس کا پانی استعمال کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ملاقات کے خیمے میں داخل ہونے سے پہلے ہی وہ اپنے آپ کو دھوئیں ورنہ وہ مر جائیں گے۔ اِسی طرح جب بھی وہ خیمے کے باہر کی قربان گاہ پر جانوروں کی قربانیاں چڑھائیں ");
INSERT INTO urdgvu_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","تو لازم ہے کہ پہلے ہاتھ پاؤں دھو لیں، ورنہ وہ مر جائیں گے۔ یہ اصول ہارون اور اُس کی اولاد کے لئے ہمیشہ تک قائم رہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","”مسح کے تیل کے لئے عمدہ قسم کے مسالے استعمال کرنا۔ 6 کلو گرام آبِ مُر، 3 کلو گرام خوشبودار دارچینی، 3 کلو گرام خوشبودار بید ");
INSERT INTO urdgvu_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","اور 6 کلو گرام تیج پات۔ یہ چیزیں مقدِس کے باٹوں کے حساب سے تول کر چار لٹر زیتون کے تیل میں ڈالنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","سب کچھ ملا کر خوشبودار تیل تیار کرنا۔ وہ مُقدّس ہے اور صرف اُس وقت استعمال کیا جائے جب کوئی چیز یا شخص میرے لئے مخصوص و مُقدّس کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","یہی تیل لے کر ملاقات کا خیمہ اور اُس کا سارا سامان مسح کرنا یعنی خیمہ، عہد کا صندوق، ");
INSERT INTO urdgvu_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","میز اور اُس کا سامان، شمع دان اور اُس کا سامان، بخور جلانے کی قربان گاہ، ");
INSERT INTO urdgvu_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","جانوروں کو چڑھانے کی قربان گاہ اور اُس کا سامان، دھونے کا حوض اور اُس کا ڈھانچا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","یوں تُو یہ تمام چیزیں مخصوص و مُقدّس کرے گا۔ اِس سے وہ نہایت مُقدّس ہو جائیں گی۔ جو بھی اُنہیں چھوئے گا وہ مُقدّس ہو جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","ہارون اور اُس کے بیٹوں کو بھی اِس تیل سے مسح کرنا تاکہ وہ مُقدّس ہو کر میرے لئے امام کا کام سرانجام دے سکیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","اسرائیلیوں کو کہہ دے کہ یہ تیل ہمیشہ تک میرے لئے مخصوص و مُقدّس ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","اِس لئے اِسے اپنے لئے استعمال نہ کرنا اور نہ اِس ترکیب سے اپنے لئے تیل بنانا۔ یہ تیل مخصوص و مُقدّس ہے اور تمہیں بھی اِسے یوں ٹھہرانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","جو اِس ترکیب سے عام استعمال کے لئے تیل بناتا ہے یا کسی عام شخص پر لگاتا ہے اُسے اُس کی قوم میں سے مٹا ڈالنا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","رب نے موسیٰ سے کہا، ”بخور اِس ترکیب سے بنانا ہے: مصطکی، اونِکا، بریجا اور خالص لُبان برابر کے حصوں میں ");
INSERT INTO urdgvu_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ملا کر خوشبودار بخور بنانا۔ عطرساز کا یہ کام نمکین، خالص اور مُقدّس ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","اِس میں سے کچھ پیس کر پاؤڈر بنانا اور ملاقات کے خیمے میں عہد کے صندوق کے سامنے ڈالنا جہاں مَیں تجھ سے ملا کروں گا۔ اِس بخور کو مُقدّس ترین ٹھہرانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","اِسی ترکیب کے مطابق اپنے لئے بخور نہ بنانا۔ اِسے رب کے لئے مخصوص و مُقدّس ٹھہرانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","جو بھی اپنے ذاتی استعمال کے لئے اِس قسم کا بخور بنائے اُسے اُس کی قوم میں سے مٹا ڈالنا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","پھر رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","”مَیں نے یہوداہ کے قبیلے کے بضلی ایل بن اُوری بن حور کو چن لیا ہے تاکہ وہ مُقدّس خیمے کی تعمیر میں راہنمائی کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","مَیں نے اُسے الٰہی روح سے معمور کر کے حکمت، سمجھ اور تعمیر کے ہر کام کے لئے درکار علم دے دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","وہ نقشے بنا کر اُن کے مطابق سونے، چاندی اور پیتل کی چیزیں بنا سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","وہ جواہر کو کاٹ کر جڑنے کی قابلیت رکھتا ہے۔ وہ لکڑی کو تراش کر اُس سے مختلف چیزیں بنا سکتا ہے۔ وہ بہت سارے اَور کاموں میں بھی مہارت رکھتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","ساتھ ہی مَیں نے دان کے قبیلے کے اُہلیاب بن اخی سمک کو مقرر کیا ہے تاکہ وہ ہر کام میں اُس کی مدد کرے۔ اِس کے علاوہ مَیں نے تمام سمجھ دار کاری گروں کو مہارت دی ہے تاکہ وہ سب کچھ اُن ہدایات کے مطابق بنا سکیں جو مَیں نے تجھے دی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","یعنی ملاقات کا خیمہ، کفارے کے ڈھکنے سمیت عہد کا صندوق اور خیمے کا سارا دوسرا سامان، ");
INSERT INTO urdgvu_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","میز اور اُس کا سامان، خالص سونے کا شمع دان اور اُس کا سامان، بخور جلانے کی قربان گاہ، ");
INSERT INTO urdgvu_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","جانوروں کو چڑھانے کی قربان گاہ اور اُس کا سامان، دھونے کا حوض اُس ڈھانچے سمیت جس پر وہ رکھا جاتا ہے، ");
INSERT INTO urdgvu_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","وہ لباس جو ہارون اور اُس کے بیٹے مقدِس میں خدمت کرنے کے لئے پہنتے ہیں، ");
INSERT INTO urdgvu_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","مسح کا تیل اور مقدِس کے لئے خوشبودار بخور۔ یہ سب کچھ وہ ویسے ہی بنائیں جیسے مَیں نے تجھے حکم دیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","”اسرائیلیوں کو بتا کہ ہر سبت کا دن ضرور مناؤ۔ کیونکہ سبت کا دن ایک نمایاں نشان ہے جس سے جان لیا جائے گا کہ مَیں رب ہوں جو تمہیں مخصوص و مُقدّس کرتا ہوں۔ اور یہ نشان میرے اور تمہارے درمیان نسل در نسل قائم رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","سبت کا دن ضرور منانا، کیونکہ وہ تمہارے لئے مخصوص و مُقدّس ہے۔ جو بھی اُس کی بےحرمتی کرے وہ ضرور جان سے مارا جائے۔ جو بھی اِس دن کام کرے اُسے اُس کی قوم میں سے مٹایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","چھ دن کام کرنا، لیکن ساتواں دن آرام کا دن ہے۔ وہ رب کے لئے مخصوص و مُقدّس ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","اسرائیلیوں کو حال میں اور مستقبل میں سبت کا دن ابدی عہد سمجھ کر منانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","وہ میرے اور اسرائیلیوں کے درمیان ابدی نشان ہو گا۔ کیونکہ رب نے چھ دن کے دوران آسمان و زمین کو بنایا جبکہ ساتویں دن اُس نے آرام کیا اور تازہ دم ہو گیا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","یہ سب کچھ موسیٰ کو بتانے کے بعد رب نے اُسے سینا پہاڑ پر شریعت کی دو تختیاں دیں۔ اللہ نے خود پتھر کی اِن تختیوں پر تمام باتیں لکھی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","پہاڑ کے دامن میں لوگ موسیٰ کے انتظار میں رہے، لیکن بہت دیر ہو گئی۔ ایک دن وہ ہارون کے گرد جمع ہو کر کہنے لگے، ”آئیں، ہمارے لئے دیوتا بنا دیں جو ہمارے آگے آگے چلتے ہوئے ہماری راہنمائی کریں۔ کیونکہ کیا معلوم کہ اُس بندے موسیٰ کو کیا ہوا ہے جو ہمیں مصر سے نکال لایا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","جواب میں ہارون نے کہا، ”آپ کی بیویاں، بیٹے اور بیٹیاں اپنی سونے کی بالیاں اُتار کر میرے پاس لے آئیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","سب لوگ اپنی بالیاں اُتار اُتار کر ہارون کے پاس لے آئے ");
INSERT INTO urdgvu_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","تو اُس نے یہ زیورات لے کر بچھڑا ڈھال دیا۔ بچھڑے کو دیکھ کر لوگ بول اُٹھے، ”اے اسرائیل، یہ تیرے دیوتا ہیں جو تجھے مصر سے نکال لائے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","جب ہارون نے یہ دیکھا تو اُس نے بچھڑے کے سامنے قربان گاہ بنا کر اعلان کیا، ”کل ہم رب کی تعظیم میں عید منائیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","اگلے دن لوگ صبح سویرے اُٹھے اور بھسم ہونے والی قربانیاں اور سلامتی کی قربانیاں چڑھائیں۔ وہ کھانے پینے کے لئے بیٹھ گئے اور پھر اُٹھ کر رنگ رلیوں میں اپنے دل بہلانے لگے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","اُس وقت رب نے موسیٰ سے کہا، ”پہاڑ سے اُتر جا۔ تیرے لوگ جنہیں تُو مصر سے نکال لایا بڑی شرارتیں کر رہے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","وہ کتنی جلدی سے اُس راستے سے ہٹ گئے ہیں جس پر چلنے کے لئے مَیں نے اُنہیں حکم دیا تھا۔ اُنہوں نے اپنے لئے ڈھالا ہوا بچھڑا بنا کر اُسے سجدہ کیا ہے۔ اُنہوں نے اُسے قربانیاں پیش کر کے کہا ہے، ’اے اسرائیل، یہ تیرے دیوتا ہیں۔ یہی تجھے مصر سے نکال لائے ہیں‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","اللہ نے موسیٰ سے کہا، ”مَیں نے دیکھا ہے کہ یہ قوم بڑی ہٹ دھرم ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","اب مجھے روکنے کی کوشش نہ کر۔ مَیں اُن پر اپنا غضب اُنڈیل کر اُن کو رُوئے زمین پر سے مٹا دوں گا۔ اُن کی جگہ مَیں تجھ سے ایک بڑی قوم بنا دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","لیکن موسیٰ نے کہا، ”اے رب، تُو اپنی قوم پر اپنا غصہ کیوں اُتارنا چاہتا ہے؟ تُو خود اپنی عظیم قدرت سے اُسے مصر سے نکال لایا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","مصری کیوں کہیں، ’رب اسرائیلیوں کو صرف اِس بُرے مقصد سے ہمارے ملک سے نکال لے گیا ہے کہ اُنہیں پہاڑی علاقے میں مار ڈالے اور یوں اُنہیں رُوئے زمین پر سے مٹائے‘؟ اپنا غصہ ٹھنڈا ہونے دے اور اپنی قوم کے ساتھ بُرا سلوک کرنے سے باز رہ۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","یاد رکھ کہ تُو نے اپنے خادموں ابراہیم، اسحاق اور یعقوب سے اپنی ہی قَسم کھا کر کہا تھا، ’مَیں تمہاری اولاد کی تعداد یوں بڑھاؤں گا کہ وہ آسمان کے ستاروں کے برابر ہو جائے گی۔ مَیں اُنہیں وہ ملک دوں گا جس کا وعدہ مَیں نے کیا ہے، اور وہ اُسے ہمیشہ کے لئے میراث میں پائیں گے‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","موسیٰ کے کہنے پر رب نے وہ نہیں کیا جس کا اعلان اُس نے کر دیا تھا بلکہ وہ اپنی قوم سے بُرا سلوک کرنے سے باز رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","موسیٰ مُڑ کر پہاڑ سے اُترا۔ اُس کے ہاتھوں میں شریعت کی دونوں تختیاں تھیں۔ اُن پر آگے پیچھے لکھا گیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","اللہ نے خود تختیوں کو بنا کر اُن پر اپنے احکام کندہ کئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","اُترتے اُترتے یشوع نے لوگوں کا شور سنا اور موسیٰ سے کہا، ”خیمہ گاہ میں جنگ کا شور مچ رہا ہے!“ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","موسیٰ نے جواب دیا، ”نہ تو یہ فتح مندوں کے نعرے ہیں، نہ شکست کھائے ہوؤں کی چیخ پکار۔ مجھے گانے والوں کی آواز سنائی دے رہی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","جب وہ خیمہ گاہ کے نزدیک پہنچا تو اُس نے لوگوں کو سونے کے بچھڑے کے سامنے ناچتے ہوئے دیکھا۔ بڑے غصے میں آ کر اُس نے تختیوں کو زمین پر پٹخ دیا، اور وہ ٹکڑے ٹکڑے ہو کر پہاڑ کے دامن میں گر گئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","موسیٰ نے اسرائیلیوں کے بنائے ہوئے بچھڑے کو جلا دیا۔ جو کچھ بچ گیا اُسے اُس نے پیس پیس کر پاؤڈر بنا ڈالا اور پاؤڈر پانی پر چھڑک کر اسرائیلیوں کو پلا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","اُس نے ہارون سے پوچھا، ”اِن لوگوں نے تمہارے ساتھ کیا کِیا کہ تم نے اُنہیں ایسے بڑے گناہ میں پھنسا دیا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","ہارون نے کہا، ”میرے آقا۔ غصے نہ ہوں۔ آپ خود جانتے ہیں کہ یہ لوگ بدی پر تُلے رہتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","اُنہوں نے مجھ سے کہا، ’ہمارے لئے دیوتا بنا دیں جو ہمارے آگے آگے چلتے ہوئے ہماری راہنمائی کریں۔ کیونکہ کیا معلوم کہ اُس بندے موسیٰ کو کیا ہوا ہے جو ہمیں مصر سے نکال لایا۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","اِس لئے مَیں نے اُن کو بتایا، ’جس کے پاس سونے کے زیورات ہیں وہ اُنہیں اُتار لائے۔‘ جو کچھ اُنہوں نے مجھے دیا اُسے مَیں نے آگ میں پھینک دیا تو ہوتے ہوتے سونے کا یہ بچھڑا نکل آیا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","موسیٰ نے دیکھا کہ لوگ بےقابو ہو گئے ہیں۔ کیونکہ ہارون نے اُنہیں بےلگام چھوڑ دیا تھا، اور یوں وہ اسرائیل کے دشمنوں کے لئے مذاق کا نشانہ بن گئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","موسیٰ خیمہ گاہ کے دروازے پر کھڑے ہو کر بولا، ”جو بھی رب کا بندہ ہے وہ میرے پاس آئے۔“ جواب میں لاوی کے قبیلے کے تمام لوگ اُس کے پاس جمع ہو گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","پھر موسیٰ نے اُن سے کہا، ”رب اسرائیل کا خدا فرماتا ہے، ’ہر ایک اپنی تلوار لے کر خیمہ گاہ میں سے گزرے۔ ایک سرے کے دروازے سے شروع کر کے دوسرے سرے کے دروازے تک چلتے چلتے ہر ملنے والے کو جان سے مار دو، چاہے وہ تمہارا بھائی، دوست یا رشتے دار ہی کیوں نہ ہو۔ پھر مُڑ کر مارتے مارتے پہلے دروازے پر واپس آ جاؤ‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","لاویوں نے موسیٰ کی ہدایت پر عمل کیا تو اُس دن تقریباً 3,000 مرد ہلاک ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","یہ دیکھ کر موسیٰ نے لاویوں سے کہا، ”آج اپنے آپ کو مقدِس میں رب کی خدمت کرنے کے لئے مخصوص و مُقدّس کرو، کیونکہ تم اپنے بیٹوں اور بھائیوں کے خلاف لڑنے کے لئے تیار تھے۔ اِس لئے رب تم کو آج برکت دے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","اگلے دن موسیٰ نے اسرائیلیوں سے بات کی، ”تم نے نہایت سنگین گناہ کیا ہے۔ توبھی مَیں اب رب کے پاس پہاڑ پر جا رہا ہوں۔ شاید مَیں تمہارے گناہ کا کفارہ دے سکوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","چنانچہ موسیٰ نے رب کے پاس واپس جا کر کہا، ”ہائے، اِس قوم نے نہایت سنگین گناہ کیا ہے۔ اُنہوں نے اپنے لئے سونے کا دیوتا بنا لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","مہربانی کر کے اُنہیں معاف کر۔ لیکن اگر تُو اُنہیں معاف نہ کرے تو پھر مجھے بھی اپنی اُس کتاب میں سے مٹا دے جس میں تُو نے اپنے لوگوں کے نام درج کئے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","رب نے جواب دیا، ”مَیں صرف اُس کو اپنی کتاب میں سے مٹاتا ہوں جو میرا گناہ کرتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","اب جا، لوگوں کو اُس جگہ لے چل جس کا ذکر مَیں نے کیا ہے۔ میرا فرشتہ تیرے آگے آگے چلے گا۔ لیکن جب سزا کا مقررہ دن آئے گا تب مَیں اُنہیں سزا دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","پھر رب نے اسرائیلیوں کے درمیان وبا پھیلنے دی، اِس لئے کہ اُنہوں نے اُس بچھڑے کی پوجا کی تھی جو ہارون نے بنایا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","رب نے موسیٰ سے کہا، ”اِس جگہ سے روانہ ہو جا۔ اُن لوگوں کو لے کر جن کو تُو مصر سے نکال لایا ہے اُس ملک کو جا جس کا وعدہ مَیں نے ابراہیم، اسحاق اور یعقوب سے کیا ہے۔ اُن ہی سے مَیں نے قَسم کھا کر کہا تھا، ’مَیں یہ ملک تمہاری اولاد کو دوں گا۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","مَیں تیرے آگے آگے فرشتہ بھیج کر کنعانی، اموری، حِتّی، فرِزّی، حِوّی اور یبوسی اقوام کو اُس ملک سے نکال دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","اُٹھ، اُس ملک کو جا جہاں دودھ اور شہد کی کثرت ہے۔ لیکن مَیں ساتھ نہیں جاؤں گا۔ تم اِتنے ہٹ دھرم ہو کہ اگر مَیں ساتھ جاؤں تو خطرہ ہے کہ تمہیں وہاں پہنچنے سے پہلے ہی برباد کر دوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","جب اسرائیلیوں نے یہ سخت الفاظ سنے تو وہ ماتم کرنے لگے۔ کسی نے بھی اپنے زیور نہ پہنے، ");
INSERT INTO urdgvu_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","کیونکہ رب نے موسیٰ سے کہا تھا، ”اسرائیلیوں کو بتا کہ تم ہٹ دھرم ہو۔ اگر مَیں ایک لمحہ بھی تمہارے ساتھ چلوں تو خطرہ ہے کہ مَیں تمہیں تباہ کر دوں۔ اب اپنے زیورات اُتار ڈالو۔ پھر مَیں فیصلہ کروں گا کہ تمہارے ساتھ کیا کِیا جائے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","اِن الفاظ پر اسرائیلیوں نے حورب یعنی سینا پہاڑ پر اپنے زیور اُتار دیئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","اُس وقت موسیٰ نے خیمہ لے کر اُسے کچھ فاصلے پر خیمہ گاہ کے باہر لگا دیا۔ اُس نے اُس کا نام ’ملاقات کا خیمہ‘ رکھا۔ جو بھی رب کی مرضی دریافت کرنا چاہتا وہ خیمہ گاہ سے نکل کر وہاں جاتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","جب بھی موسیٰ خیمہ گاہ سے نکل کر وہاں جاتا تو تمام لوگ اپنے خیموں کے دروازوں پر کھڑے ہو کر موسیٰ کے پیچھے دیکھنے لگتے۔ اُس کے ملاقات کے خیمے میں اوجھل ہونے تک وہ اُسے دیکھتے رہتے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","موسیٰ کے خیمے میں داخل ہونے پر بادل کا ستون اُتر کر خیمے کے دروازے پر ٹھہر جاتا۔ جتنی دیر تک رب موسیٰ سے باتیں کرتا اُتنی دیر تک وہ وہاں ٹھہرا رہتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","جب اسرائیلی ملاقات کے خیمے کے دروازے پر بادل کا ستون دیکھتے تو وہ اپنے اپنے خیمے کے دروازے پر کھڑے ہو کر سجدہ کرتے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","رب موسیٰ سے رُوبرُو باتیں کرتا تھا، ایسے شخص کی طرح جو اپنے دوست سے باتیں کرتا ہے۔ اِس کے بعد موسیٰ نکل کر خیمہ گاہ کو واپس چلا جاتا۔ لیکن اُس کا جوان مددگار یشوع بن نون خیمے کو نہیں چھوڑتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","موسیٰ نے رب سے کہا، ”دیکھ، تُو مجھ سے کہتا آیا ہے کہ اِس قوم کو کنعان لے چل۔ لیکن تُو میرے ساتھ کس کو بھیجے گا؟ تُو نے اب تک یہ بات مجھے نہیں بتائی حالانکہ تُو نے کہا ہے، ’مَیں تجھے بنام جانتا ہوں، تجھے میرا کرم حاصل ہوا ہے۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","اگر مجھے واقعی تیرا کرم حاصل ہے تو مجھے اپنے راستے دکھا تاکہ مَیں تجھے جان لوں اور تیرا کرم مجھے حاصل ہوتا رہے۔ اِس بات کا خیال رکھ کہ یہ قوم تیری ہی اُمّت ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","رب نے جواب دیا، ”مَیں خود تیرے ساتھ چلوں گا اور تجھے آرام دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","موسیٰ نے کہا، ”اگر تُو خود ساتھ نہیں چلے گا تو پھر ہمیں یہاں سے روانہ نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","اگر تُو ہمارے ساتھ نہ جائے تو کس طرح پتا چلے گا کہ مجھے اور تیری قوم کو تیرا کرم حاصل ہوا ہے؟ ہم صرف اِسی وجہ سے دنیا کی دیگر قوموں سے الگ اور ممتاز ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","رب نے موسیٰ سے کہا، ”مَیں تیری یہ درخواست بھی پوری کروں گا، کیونکہ تجھے میرا کرم حاصل ہوا ہے اور مَیں تجھے بنام جانتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","پھر موسیٰ بولا، ”براہِ کرم مجھے اپنا جلال دکھا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","رب نے جواب دیا، ”مَیں اپنی پوری بھلائی تیرے سامنے سے گزرنے دوں گا اور تیرے سامنے ہی اپنے نام رب کا اعلان کروں گا۔ مَیں جس پر مہربان ہونا چاہوں اُس پر مہربان ہوتا ہوں، اور جس پر رحم کرنا چاہوں اُس پر رحم کرتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","لیکن تُو میرا چہرہ نہیں دیکھ سکتا، کیونکہ جو بھی میرا چہرہ دیکھے وہ زندہ نہیں رہ سکتا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","پھر رب نے فرمایا، ”دیکھ، میرے پاس ایک جگہ ہے۔ وہاں کی چٹان پر کھڑا ہو جا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","جب میرا جلال وہاں سے گزرے گا تو مَیں تجھے چٹان کے ایک شگاف میں رکھوں گا اور اپنا ہاتھ تیرے اوپر پھیلاؤں گا تاکہ تُو میرے گزرنے کے دوران محفوظ رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","اِس کے بعد مَیں اپنا ہاتھ ہٹاؤں گا اور تُو میرے پیچھے دیکھ سکے گا۔ لیکن میرا چہرہ دیکھا نہیں جا سکتا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","رب نے موسیٰ سے کہا، ”اپنے لئے پتھر کی دو تختیاں تراش لے جو پہلی دو کی مانند ہوں۔ پھر مَیں اُن پر وہ الفاظ لکھوں گا جو پہلی تختیوں پر لکھے تھے جنہیں تُو نے پٹخ دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","صبح تک تیار ہو کر سینا پہاڑ پر چڑھنا۔ چوٹی پر میرے سامنے کھڑا ہو جا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","تیرے ساتھ کوئی بھی نہ آئے بلکہ پورے پہاڑ پر کوئی اَور شخص نظر نہ آئے، یہاں تک کہ بھیڑبکریاں اور گائےبَیل بھی پہاڑ کے دامن میں نہ چریں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","چنانچہ موسیٰ نے دو تختیاں تراش لیں جو پہلی کی مانند تھیں۔ پھر وہ صبح سویرے اُٹھ کر سینا پہاڑ پر چڑھ گیا جس طرح رب نے اُسے حکم دیا تھا۔ اُس کے ہاتھوں میں پتھر کی دونوں تختیاں تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","جب وہ چوٹی پر پہنچا تو رب بادل میں اُتر آیا اور اُس کے پاس کھڑے ہو کر اپنے نام رب کا اعلان کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","موسیٰ کے سامنے سے گزرتے ہوئے اُس نے پکارا، ”رب، رب، رحیم اور مہربان خدا۔ تحمل، شفقت اور وفا سے بھرپور۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","وہ ہزاروں پر اپنی شفقت قائم رکھتا اور لوگوں کا قصور، نافرمانی اور گناہ معاف کرتا ہے۔ لیکن وہ ہر ایک کو اُس کی مناسب سزا بھی دیتا ہے۔ جب والدین گناہ کریں تو اُن کی اولاد کو بھی تیسری اور چوتھی پشت تک سزا کے نتائج بھگتنے پڑیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","موسیٰ نے جلدی سے جھک کر سجدہ کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","اُس نے کہا، ”اے رب، اگر مجھ پر تیرا کرم ہو تو ہمارے ساتھ چل۔ بےشک یہ قوم ہٹ دھرم ہے، توبھی ہمارا قصور اور گناہ معاف کر اور بخش دے کہ ہم دوبارہ تیرے ہی بن جائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","تب رب نے کہا، ”مَیں تمہارے ساتھ عہد باندھوں گا۔ تیری قوم کے سامنے ہی مَیں ایسے معجزے کروں گا جو اب تک دنیا بھر کی کسی بھی قوم میں نہیں کئے گئے۔ پوری قوم جس کے درمیان تُو رہتا ہے رب کا کام دیکھے گی اور اُس سے ڈر جائے گی جو مَیں تیرے ساتھ کروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","جو احکام مَیں آج دیتا ہوں اُن پر عمل کرتا رہ۔ مَیں اموری، کنعانی، حِتّی، فرِزّی، حِوّی اور یبوسی اقوام کو تیرے آگے آگے ملک سے نکال دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","خبردار، جو اُس ملک میں رہتے ہیں جہاں تُو جا رہا ہے اُن سے عہد نہ باندھنا۔ ورنہ وہ تیرے درمیان رہتے ہوئے تجھے گناہوں میں پھنساتے رہیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","اُن کی قربان گاہیں ڈھا دینا، اُن کے بُتوں کے ستون ٹکڑے ٹکڑے کر دینا اور اُن کی دیوی یسیرت کے کھمبے کاٹ ڈالنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","کسی اَور معبود کی پرستش نہ کرنا، کیونکہ رب کا نام غیور ہے، اللہ غیرت مند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","خبردار، اُس ملک کے باشندوں سے عہد نہ کرنا، کیونکہ تیرے درمیان رہتے ہوئے بھی وہ اپنے معبودوں کی پیروی کر کے زنا کریں گے اور اُنہیں قربانیاں چڑھائیں گے۔ آخرکار وہ تجھے بھی اپنی قربانیوں میں شرکت کی دعوت دیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","خطرہ ہے کہ تُو اُن کی بیٹیوں کا اپنے بیٹوں کے ساتھ رشتہ باندھے۔ پھر جب یہ اپنے معبودوں کی پیروی کر کے زنا کریں گی تو اُن کے سبب سے تیرے بیٹے بھی اُن کی پیروی کرنے لگیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","اپنے لئے دیوتا نہ ڈھالنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","بےخمیری روٹی کی عید منانا۔ ابیب کے مہینے میں سات دن تک تیری روٹی میں خمیر نہ ہو جس طرح مَیں نے حکم دیا ہے۔ کیونکہ اِس مہینے میں تُو مصر سے نکلا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","ہر پہلوٹھا میرا ہے۔ تیرے مال مویشیوں کا ہر پہلوٹھا میرا ہے، چاہے بچھڑا ہو یا لیلا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","لیکن پہلوٹھے گدھے کے عوض بھیڑ دینا۔ اگر یہ ممکن نہ ہو تو اُس کی گردن توڑ ڈالنا۔ اپنے پہلوٹھے بیٹوں کے لئے بھی عوضی دینا۔ کوئی میرے پاس خالی ہاتھ نہ آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","چھ دن کام کاج کرنا، لیکن ساتویں دن آرام کرنا۔ خواہ ہل چلانا ہو یا فصل کاٹنی ہو توبھی ساتویں دن آرام کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","گندم کی فصل کی کٹائی کی عید اُس وقت منانا جب تُو گیہوں کی پہلی فصل کاٹے گا۔ انگور اور پھل جمع کرنے کی عید اسرائیلی سال کے اختتام پر منانی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","لازم ہے کہ تیرے تمام مرد سال میں تین مرتبہ رب قادرِ مطلق کے سامنے جو اسرائیل کا خدا ہے حاضر ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","مَیں تیرے آگے آگے قوموں کو ملک سے نکال دوں گا اور تیری سرحدیں بڑھاتا جاؤں گا۔ پھر جب تُو سال میں تین مرتبہ رب اپنے خدا کے حضور آئے گا تو کوئی بھی تیرے ملک کا لالچ نہیں کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","جب تُو کسی جانور کو ذبح کر کے قربانی کے طور پر پیش کرتا ہے تو اُس کے خون کے ساتھ ایسی روٹی پیش نہ کرنا جس میں خمیر ہو۔ عیدِ فسح کی قربانی سے اگلی صبح تک کچھ باقی نہ رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","اپنی زمین کی پہلی پیداوار میں سے بہترین حصہ رب اپنے خدا کے گھر میں لے آنا۔ بکری یا بھیڑ کے بچے کو اُس کی ماں کے دودھ میں نہ پکانا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","رب نے موسیٰ سے کہا، ”یہ تمام باتیں لکھ لے، کیونکہ یہ اُس عہد کی بنیاد ہیں جو مَیں نے تیرے اور اسرائیل کے ساتھ باندھا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","موسیٰ چالیس دن اور چالیس رات وہیں رب کے حضور رہا۔ اِس دوران نہ اُس نے کچھ کھایا نہ پیا۔ اُس نے پتھر کی تختیوں پر عہد کے دس احکام لکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","اِس کے بعد موسیٰ شریعت کی دونوں تختیوں کو ہاتھ میں لئے ہوئے سینا پہاڑ سے اُترا۔ اُس کے چہرے کی جِلد چمک رہی تھی، کیونکہ اُس نے رب سے بات کی تھی۔ لیکن اُسے خود اِس کا علم نہیں تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","جب ہارون اور تمام اسرائیلیوں نے دیکھا کہ موسیٰ کا چہرہ چمک رہا ہے تو وہ اُس کے پاس آنے سے ڈر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","لیکن اُس نے اُنہیں بُلایا تو ہارون اور جماعت کے تمام سردار اُس کے پاس آئے، اور اُس نے اُن سے بات کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","بعد میں باقی اسرائیلی بھی آئے، اور موسیٰ نے اُنہیں تمام احکام سنائے جو رب نے اُسے کوہِ سینا پر دیئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","یہ سب کچھ کہنے کے بعد موسیٰ نے اپنے چہرے پر نقاب ڈال لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","جب بھی وہ رب سے بات کرنے کے لئے ملاقات کے خیمے میں جاتا تو نقاب کو خیمے سے نکلتے وقت تک اُتار لیتا۔ اور جب وہ نکل کر اسرائیلیوں کو رب سے ملے ہوئے احکام سناتا ");
INSERT INTO urdgvu_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","تو وہ دیکھتے کہ اُس کے چہرے کی جِلد چمک رہی ہے۔ اِس کے بعد موسیٰ دوبارہ نقاب کو اپنے چہرے پر ڈال لیتا، اور وہ اُس وقت تک چہرے پر رہتا جب تک موسیٰ رب سے بات کرنے کے لئے ملاقات کے خیمے میں نہ جاتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","موسیٰ نے اسرائیل کی پوری جماعت کو اکٹھا کر کے کہا، ”رب نے تم کو یہ حکم دیئے ہیں: ");
INSERT INTO urdgvu_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","چھ دن کام کاج کیا جائے، لیکن ساتواں دن مخصوص و مُقدّس ہو۔ وہ رب کے لئے آرام کا سبت ہے۔ جو بھی اِس دن کام کرے اُسے سزائے موت دی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ہفتے کے دن اپنے تمام گھروں میں آگ تک نہ جلانا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","موسیٰ نے اسرائیل کی پوری جماعت سے کہا، ”رب نے ہدایت دی ہے ");
INSERT INTO urdgvu_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","کہ جو کچھ تمہارے پاس ہے اُس میں سے ہدیئے لا کر رب کو اُٹھانے والی قربانی کے طور پر پیش کرو۔ جو بھی دلی خوشی سے دینا چاہے وہ اِن چیزوں میں سے کچھ دے: سونا، چاندی، پیتل؛ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","نیلے، ارغوانی اور قرمزی رنگ کا دھاگا، باریک کتان، بکری کے بال، ");
INSERT INTO urdgvu_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","مینڈھوں کی سرخ رنگی ہوئی کھالیں، تخس کی کھالیں، کیکر کی لکڑی، ");
INSERT INTO urdgvu_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","شمع دان کے لئے زیتون کا تیل، مسح کرنے کے لئے تیل اور خوشبودار بخور کے لئے مسالے، ");
INSERT INTO urdgvu_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","عقیقِ احمر اور دیگر جواہر جو امامِ اعظم کے بالاپوش اور سینے کے کیسے میں جڑے جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","تم میں سے جتنے ماہر کاری گر ہیں وہ آ کر وہ کچھ بنائیں جو رب نے فرمایا ");
INSERT INTO urdgvu_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","یعنی خیمہ اور وہ غلاف جو اُس کے اوپر لگائے جائیں گے، ہکیں، دیواروں کے تختے، شہتیر، ستون اور پائے، ");
INSERT INTO urdgvu_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","عہد کا صندوق، اُسے اُٹھانے کی لکڑیاں، اُس کے کفارے کا ڈھکنا، مُقدّس ترین کمرے کے دروازے کا پردہ، ");
INSERT INTO urdgvu_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","مخصوص روٹیوں کی میز، اُسے اُٹھانے کی لکڑیاں، اُس کا سارا سامان اور روٹیاں، ");
INSERT INTO urdgvu_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","شمع دان اور اُس پر رکھنے کے چراغ اُس کے سامان سمیت، شمع دان کے لئے تیل، ");
INSERT INTO urdgvu_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","بخور جلانے کی قربان گاہ، اُسے اُٹھانے کی لکڑیاں، مسح کا تیل، خوشبودار بخور، مُقدّس خیمے کے دروازے کا پردہ، ");
INSERT INTO urdgvu_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","جانوروں کو چڑھانے کی قربان گاہ، اُس کا پیتل کا جنگلا، اُسے اُٹھانے کی لکڑیاں اور باقی سارا سامان، دھونے کا حوض اور وہ ڈھانچا جس پر حوض رکھا جاتا ہے، ");
INSERT INTO urdgvu_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","چاردیواری کے پردے اُن کے کھمبوں اور پائیوں سمیت، صحن کے دروازے کا پردہ، ");
INSERT INTO urdgvu_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","خیمے اور چاردیواری کی میخیں اور رسّے، ");
INSERT INTO urdgvu_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","اور وہ مُقدّس لباس جو ہارون اور اُس کے بیٹے مقدِس میں خدمت کرنے کے لئے پہنتے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","یہ سن کر اسرائیل کی پوری جماعت موسیٰ کے پاس سے چلی گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","اور جو جو دلی خوشی سے دینا چاہتا تھا وہ ملاقات کے خیمے، اُس کے سامان یا اماموں کے کپڑوں کے لئے کوئی ہدیہ لے کر واپس آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","رب کے ہدیئے کے لئے مرد اور خواتین دلی خوشی سے اپنے سونے کے زیورات مثلاً جڑاؤ پِنیں، بالیاں اور چھلے لے آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","جس جس کے پاس درکار چیزوں میں سے کچھ تھا وہ اُسے موسیٰ کے پاس لے آیا یعنی نیلے، قرمزی اور ارغوانی رنگ کا دھاگا، باریک کتان، بکری کے بال، مینڈھوں کی سرخ رنگی ہوئی کھالیں اور تخس کی کھالیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","چاندی، پیتل اور کیکر کی لکڑی بھی ہدیئے کے طور پر لائی گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","اور جتنی عورتیں کاتنے میں ماہر تھیں وہ اپنی کاتی ہوئی چیزیں لے آئیں یعنی نیلے، قرمزی اور ارغوانی رنگ کا دھاگا اور باریک کتان۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","اِسی طرح جو جو عورت بکری کے بال کاتنے میں ماہر تھی اور دلی خوشی سے مقدِس کے لئے کام کرنا چاہتی تھی وہ یہ کات کر لے آئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","سردار عقیقِ احمر اور دیگر جواہر لے آئے جو امامِ اعظم کے بالاپوش اور سینے کے کیسے کے لئے درکار تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","وہ شمع دان، مسح کے تیل اور خوشبودار بخور کے لئے مسالے اور زیتون کا تیل بھی لے آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","یوں اسرائیل کے تمام مرد اور خواتین جو دلی خوشی سے رب کو کچھ دینا چاہتے تھے اُس سارے کام کے لئے ہدیئے لے آئے جو رب نے موسیٰ کی معرفت کرنے کو کہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","پھر موسیٰ نے اسرائیلیوں سے کہا، ”رب نے یہوداہ کے قبیلے کے بضلی ایل بن اُوری بن حور کو چن لیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","اُس نے اُسے الٰہی روح سے معمور کر کے حکمت، سمجھ اور تعمیر کے ہر کام کے لئے درکار علم دے دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","وہ نقشے بنا کر اُن کے مطابق سونے، چاندی اور پیتل کی چیزیں بنا سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","وہ جواہر کو کاٹ کر جڑنے کی قابلیت رکھتا ہے۔ وہ لکڑی کو تراش کر اُس سے مختلف چیزیں بنا سکتا ہے۔ وہ بہت سارے اَور کاموں میں بھی مہارت رکھتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ساتھ ہی رب نے اُسے اور دان کے قبیلے کے اُہلیاب بن اخی سمک کو دوسروں کو سکھانے کی قابلیت بھی دی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","اُس نے اُنہیں وہ مہارت اور حکمت دی ہے جو ہر کام کے لئے درکار ہے یعنی کاری گری کے ہر کام کے لئے، کڑھائی کے کام کے لئے، نیلے، ارغوانی اور قرمزی رنگ کے دھاگے اور باریک کتان سے کپڑا بنانے کے لئے اور بُنائی کے کام کے لئے۔ وہ ماہر کاری گر ہیں اور نقشے بھی بنا سکتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","لازم ہے کہ بضلی ایل، اُہلیاب اور باقی کاری گر جن کو رب نے مقدِس کی تعمیر کے لئے حکمت اور سمجھ دی ہے سب کچھ عین اُن ہدایات کے مطابق بنائیں جو رب نے دی ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","موسیٰ نے بضلی ایل اور اُہلیاب کو بُلایا۔ ساتھ ہی اُس نے ہر اُس کاری گر کو بھی بُلایا جسے رب نے مقدِس کی تعمیر کے لئے حکمت اور مہارت دی تھی اور جو خوشی سے آنا اور یہ کام کرنا چاہتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","اُنہیں موسیٰ سے تمام ہدیئے ملے جو اسرائیلی مقدِس کی تعمیر کے لئے لائے تھے۔ اِس کے بعد بھی لوگ روز بہ روز صبح کے وقت ہدیئے لاتے رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","آخرکار تمام کاری گر جو مقدِس بنانے کے کام میں لگے تھے اپنا کام چھوڑ کر موسیٰ کے پاس آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","اُنہوں نے کہا، ”لوگ حد سے زیادہ لا رہے ہیں۔ جس کام کا حکم رب نے دیا ہے اُس کے لئے اِتنے سامان کی ضرورت نہیں ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","تب موسیٰ نے پوری خیمہ گاہ میں اعلان کروا دیا کہ کوئی مرد یا عورت مقدِس کی تعمیر کے لئے اب کچھ نہ لائے۔ یوں اُنہیں مزید چیزیں لانے سے روکا گیا، ");
INSERT INTO urdgvu_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","کیونکہ کام کے لئے سامان ضرورت سے زیادہ ہو گیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","جو کاری گر مہارت رکھتے تھے اُنہوں نے خیمے کو بنایا۔ اُنہوں نے باریک کتان اور نیلے، ارغوانی اور قرمزی دھاگے سے دس پردے بنائے۔ پردوں پر کسی ماہر کاری گر کے کڑھائی کے کام سے کروبی فرشتوں کا ڈیزائن بنایا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ہر پردے کی لمبائی 42 فٹ اور چوڑائی 6 فٹ تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","پانچ پردوں کے لمبے حاشئے ایک دوسرے کے ساتھ جوڑے گئے اور اِسی طرح باقی پانچ بھی۔ یوں دو بڑے ٹکڑے بن گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","دونوں ٹکڑوں کو ایک دوسرے کے ساتھ ملانے کے لئے اُنہوں نے نیلے دھاگے کے حلقے بنائے۔ یہ حلقے ہر ٹکڑے کے 42 فٹ والے ایک کنارے پر لگائے گئے، ");
INSERT INTO urdgvu_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ایک ٹکڑے کے حاشئے پر 50 حلقے اور دوسرے پر بھی اُتنے ہی حلقے۔ اِن دو حاشیوں کے حلقے ایک دوسرے کے آمنے سامنے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","پھر بضلی ایل نے سونے کی 50 ہکیں بنا کر اُن سے آمنے سامنے کے حلقوں کو ایک دوسرے کے ساتھ ملایا۔ یوں دونوں ٹکڑوں کے جوڑنے سے خیمہ بن گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","اُس نے بکری کے بالوں سے بھی 11 پردے بنائے جنہیں کپڑے والے خیمے کے اوپر رکھنا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ہر پردے کی لمبائی 45 فٹ اور چوڑائی 6 فٹ تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","پانچ پردوں کے لمبے حاشئے ایک دوسرے کے ساتھ جوڑے گئے اور اِس طرح باقی چھ بھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","اِن دونوں ٹکڑوں کو ملانے کے لئے اُس نے ہر ٹکڑے کے 45 فٹ والے ایک کنارے پر پچاس پچاس حلقے لگائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","پھر پیتل کی 50 ہکیں بنا کر اُس نے دونوں حصے ملائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ایک دوسرے کے اوپر کے دونوں خیموں کی حفاظت کے لئے بضلی ایل نے دو اَور غلاف بنائے۔ بکری کے بالوں کے خیمے پر رکھنے کے لئے اُس نے مینڈھوں کی سرخ رنگی ہوئی کھالیں جوڑ دیں اور اُس کے اوپر رکھنے کے لئے تخس کی کھالیں ملائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","اِس کے بعد اُس نے کیکر کی لکڑی کے تختے بنائے جو خیمے کی دیواروں کا کام دیتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ہر تختے کی اونچائی 15 فٹ تھی اور چوڑائی سوا دو فٹ۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ہر تختے کے نیچے دو دو چولیں تھیں۔ اِن چولوں سے ہر تختے کو اُس کے پائیوں کے ساتھ جوڑا جاتا تھا تاکہ تختہ کھڑا رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","خیمے کی جنوبی دیوار کے لئے 20 تختے بنائے گئے ");
INSERT INTO urdgvu_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","اور ساتھ ہی چاندی کے 40 پائے بھی جن پر تختے کھڑے کئے جاتے تھے۔ ہر تختے کے نیچے دو پائے تھے، اور ہر پائے میں ایک چول لگتی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","اِسی طرح خیمے کی شمالی دیوار کے لئے بھی 20 تختے بنائے گئے ");
INSERT INTO urdgvu_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","اور ساتھ ہی چاندی کے 40 پائے جو تختوں کو کھڑا کرنے کے لئے تھے۔ ہر تختے کے نیچے دو پائے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","خیمے کی پچھلی یعنی مغربی دیوار کے لئے چھ تختے بنائے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","اِس دیوار کو شمالی اور جنوبی دیواروں کے ساتھ جوڑنے کے لئے کونے والے دو تختے بنائے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","اِن دو تختوں میں نیچے سے لے کر اوپر تک کونا تھا تاکہ ایک سے شمالی دیوار مغربی دیوار کے ساتھ جُڑ جائے اور دوسرے سے جنوبی دیوار مغربی دیوار کے ساتھ۔ اِن کے اوپر کے سرے کڑوں سے مضبوط کئے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","یوں پچھلے یعنی مغربی تختوں کی پوری تعداد 8 تھی اور اِن کے لئے چاندی کے پائیوں کی تعداد 16، ہر تختے کے نیچے دو پائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_31‏","003_36_31‏","EXO","36","31‏","32","پھر بضلی ایل نے کیکر کی لکڑی کے شہتیر بنائے، تینوں دیواروں کے لئے پانچ پانچ شہتیر۔ وہ ہر دیوار کے تختوں پر یوں لگانے کے لئے تھے کہ اُن سے تختے ایک دوسرے کے ساتھ ملائے جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","درمیانی شہتیر یوں بنایا گیا کہ وہ دیوار کی آدھی اونچائی پر دیوار کے ایک سرے سے دوسرے سرے تک لگ سکتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","اُس نے تمام تختوں اور شہتیروں پر سونا چڑھایا۔ شہتیروں کو تختوں کے ساتھ لگانے کے لئے اُس نے سونے کے کڑے بنائے جو تختوں میں لگانے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","اب بضلی ایل نے ایک اَور پردہ بنایا۔ اُس کے لئے بھی باریک کتان اور نیلے، ارغوانی اور قرمزی رنگ کا دھاگا استعمال ہوا۔ اُس پر بھی کسی ماہر کاری گر کے کڑھائی کے کام سے کروبی فرشتوں کا ڈیزائن بنایا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","پھر اُس نے پردے کو لٹکانے کے لئے کیکر کی لکڑی کے چار ستون، سونے کی ہکیں اور چاندی کے چار پائے بنائے۔ ستونوں پر سونا چڑھایا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","بضلی ایل نے خیمے کے دروازے کے لئے بھی پردہ بنایا۔ وہ بھی باریک کتان اور نیلے، ارغوانی اور قرمزی رنگ کے دھاگے سے بنایا گیا، اور اُس پر کڑھائی کا کام کیا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","اِس پردے کو لٹکانے کے لئے اُس نے سونے کی ہکیں اور کیکر کی لکڑی کے پانچ ستون بنائے۔ ستونوں کے اوپر کے سِروں اور پٹیوں پر سونا چڑھایا گیا جبکہ اُن کے پائے پیتل کے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","بضلی ایل نے کیکر کی لکڑی کا صندوق بنایا۔ اُس کی لمبائی پونے چار فٹ تھی جبکہ اُس کی چوڑائی اور اونچائی سوا دو دو فٹ تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","اُس نے پورے صندوق پر اندر اور باہر سے خالص سونا چڑھایا۔ اوپر کی سطح کے ارد گرد اُس نے سونے کی جھالر لگائی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","صندوق کو اُٹھانے کے لئے اُس نے سونے کے چار کڑے ڈھال کر اُنہیں صندوق کے چارپائیوں پر لگایا۔ دونوں طرف دو دو کڑے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","پھر اُس نے کیکر کی دو لکڑیاں صندوق کو اُٹھانے کے لئے تیار کیں اور اُن پر سونا چڑھایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","اُس نے اِن لکڑیوں کو دونوں طرف کے کڑوں میں ڈال دیا تاکہ اُن سے صندوق کو اُٹھایا جا سکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","بضلی ایل نے صندوق کا ڈھکنا خالص سونے کا بنایا۔ اُس کی لمبائی پونے چار فٹ اور چوڑائی سوا دو فٹ تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_7‏","003_37_7‏","EXO","37","7‏","8","پھر اُس نے دو کروبی فرشتے سونے سے گھڑ کر بنائے جو ڈھکنے کے دونوں سِروں پر کھڑے تھے۔ یہ دو فرشتے اور ڈھکنا ایک ہی ٹکڑے سے بنائے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","فرشتوں کے پَر یوں اوپر کی طرف پھیلے ہوئے تھے کہ وہ ڈھکنے کو پناہ دیتے تھے۔ اُن کے منہ ایک دوسرے کی طرف کئے ہوئے تھے، اور وہ ڈھکنے کی طرف دیکھتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","اِس کے بعد بضلی ایل نے کیکر کی لکڑی کی میز بنائی۔ اُس کی لمبائی تین فٹ، چوڑائی ڈیڑھ فٹ اور اونچائی سوا دو فٹ تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","اُس نے اُس پر خالص سونا چڑھا کر اُس کے ارد گرد سونے کی جھالر لگائی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","میز کی اوپر کی سطح پر اُس نے چوکھٹا بھی لگایا جس کی اونچائی تین انچ تھی اور جس پر سونے کی جھالر لگی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","اب اُس نے سونے کے چار کڑے ڈھال کر اُنہیں چاروں کونوں پر لگایا جہاں میز کے پائے لگے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","یہ کڑے میز کی سطح پر لگے چوکھٹے کے نیچے لگائے گئے۔ اُن میں وہ لکڑیاں ڈالنی تھیں جن سے میز کو اُٹھانا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","بضلی ایل نے یہ لکڑیاں بھی کیکر سے بنائیں اور اُن پر سونا چڑھایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","آخرکار اُس نے خالص سونے کے وہ تھال، پیالے، مَے کی نذریں پیش کرنے کے برتن اور مرتبان بنائے جو اُس پر رکھے جاتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","پھر بضلی ایل نے خالص سونے کا شمع دان بنایا۔ اُس کا پایہ اور ڈنڈی گھڑ کر بنائے گئے۔ اُس کی پیالیاں جو پھولوں اور کلیوں کی شکل کی تھیں پائے اور ڈنڈی کے ساتھ ایک ہی ٹکڑا تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ڈنڈی سے دائیں اور بائیں طرف تین تین شاخیں نکلتی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ہر شاخ پر تین پیالیاں لگی تھیں جو بادام کی کلیوں اور پھولوں کی شکل کی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","شمع دان کی ڈنڈی پر بھی اِس قسم کی پیالیاں لگی تھیں، لیکن تعداد میں چار۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","اِن میں سے تین پیالیاں دائیں بائیں کی چھ شاخوں کے نیچے لگی تھیں۔ وہ یوں لگی تھیں کہ ہر پیالی سے دو شاخیں نکلتی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","شاخیں اور پیالیاں بلکہ پورا شمع دان خالص سونے کے ایک ہی ٹکڑے سے گھڑ کر بنایا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","بضلی ایل نے شمع دان کے لئے خالص سونے کے سات چراغ بنائے۔ اُس نے بتی کترنے کی قینچیاں اور جلتے کوئلے کے لئے چھوٹے برتن بھی خالص سونے سے بنائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","شمع دان اور اُس کے تمام سامان کے لئے پورے 34 کلو گرام خالص سونا استعمال ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","بضلی ایل نے کیکر کی لکڑی کی قربان گاہ بنائی جو بخور جلانے کے لئے تھی۔ وہ ڈیڑھ فٹ لمبی، اِتنی ہی چوڑی اور تین فٹ اونچی تھی۔ اُس کے چار کونوں میں سے سینگ نکلتے تھے جو قربان گاہ کے ساتھ ایک ہی ٹکڑے سے بنائے گئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","اُس کی اوپر کی سطح، اُس کے چار پہلوؤں اور اُس کے سینگوں پر خالص سونا چڑھایا گیا۔ اوپر کی سطح کے ارد گرد بضلی ایل نے سونے کی جھالر بنائی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","سونے کے دو کڑے بنا کر اُس نے اُنہیں اِس جھالر کے نیچے ایک دوسرے کے مقابل پہلوؤں پر لگایا۔ اِن کڑوں میں قربان گاہ کو اُٹھانے کی لکڑیاں ڈالی گئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","یہ لکڑیاں کیکر کی تھیں، اور اُن پر بھی سونا چڑھایا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","بضلی ایل نے مسح کرنے کا مُقدّس تیل اور خوشبودار خالص بخور بھی بنایا۔ یہ عطرساز کا کام تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","بضلی ایل نے کیکر کی لکڑی کی ایک اَور قربان گاہ بنائی جو بھسم ہونے والی قربانیوں کے لئے تھی۔ اُس کی اونچائی ساڑھے چار فٹ، اُس کی لمبائی اور چوڑائی ساڑھے سات سات فٹ تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","اُس کے اوپر چاروں کونوں میں سے سینگ نکلتے تھے۔ سینگ اور قربان گاہ ایک ہی ٹکڑے کے تھے، اور اُس پر پیتل چڑھایا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","اُس کا تمام ساز و سامان اور برتن بھی پیتل کے تھے یعنی راکھ کو اُٹھا کر لے جانے کی بالٹیاں، بیلچے، کانٹے، جلتے ہوئے کوئلے کے لئے برتن اور چھڑکاؤ کے کٹورے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","قربان گاہ کو اُٹھانے کے لئے اُس نے پیتل کا جنگلا بنایا۔ وہ اوپر سے کھلا تھا اور یوں بنایا گیا کہ جب قربان گاہ اُس میں رکھی جائے تو وہ اُس کنارے تک پہنچے جو قربان گاہ کی آدھی اونچائی پر لگی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","اُس نے قربان گاہ کو اُٹھانے کے لئے چار کڑے بنا کر اُنہیں جنگلے کے چار کونوں پر لگایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","پھر اُس نے کیکر کی دو لکڑیاں بنا کر اُن پر پیتل چڑھایا ");
INSERT INTO urdgvu_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","اور قربان گاہ کے دونوں طرف لگے اِن کڑوں میں ڈال دیں۔ یوں اُسے اُٹھایا جا سکتا تھا۔ قربان گاہ لکڑی کی تھی لیکن کھوکھلی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","بضلی ایل نے دھونے کا حوض اور اُس کا ڈھانچا بھی پیتل سے بنایا۔ اُس کا پیتل اُن عورتوں کے آئینوں سے ملا تھا جو ملاقات کے خیمے کے دروازے پر خدمت کرتی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","پھر بضلی ایل نے صحن بنایا۔ اُس کی چاردیواری باریک کتان کے کپڑے سے بنائی گئی۔ چاردیواری کی لمبائی جنوب کی طرف 150 فٹ تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","کپڑے کو لگانے کے لئے چاندی کی ہکیں، پٹیاں، لکڑی کے کھمبے اور اُن کے پائے بنائے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","چاردیواری شمال کی طرف بھی اِسی طرح بنائی گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","خیمے کے پیچھے مغرب کی طرف چاردیواری کی چوڑائی 75 فٹ تھی۔ کپڑے کے علاوہ اُس کے لئے 10 کھمبے، 10 پائے اور کپڑا لگانے کے لئے چاندی کی ہکیں اور پٹیاں بنائی گئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","سامنے، مشرق کی طرف جہاں سے سورج طلوع ہوتا ہے چاردیواری کی چوڑائی بھی 75 فٹ تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_14‏","003_38_14‏","EXO","38","14‏","15","کپڑا دروازے کے دائیں طرف ساڑھے 22 فٹ چوڑا تھا اور اُس کے بائیں طرف بھی اُتنا ہی چوڑا۔ اُسے دونوں طرف تین تین کھمبوں کے ساتھ لگایا گیا جو پیتل کے پائیوں پر کھڑے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","چاردیواری کے تمام پردوں کے لئے باریک کتان استعمال ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","کھمبے پیتل کے پائیوں پر کھڑے تھے، اور پردے چاندی کی ہکوں اور پٹیوں سے کھمبوں کے ساتھ لگے تھے۔ کھمبوں کے اوپر کے سِروں پر چاندی چڑھائی گئی تھی۔ صحن کے تمام کھمبوں پر چاندی کی پٹیاں لگی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","چاردیواری کے دروازے کا پردہ نیلے، ارغوانی اور قرمزی رنگ کے دھاگے اور باریک کتان سے بنایا گیا، اور اُس پر کڑھائی کا کام کیا گیا۔ وہ 30 فٹ چوڑا اور چاردیواری کے دوسرے پردوں کی طرح ساڑھے سات فٹ اونچا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","اُس کے چار کھمبے اور پیتل کے چار پائے تھے۔ اُس کی ہکیں اور پٹیاں چاندی کی تھیں، اور کھمبوں کے اوپر کے سِروں پر چاندی چڑھائی گئی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","خیمے اور چاردیواری کی تمام میخیں پیتل کی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ذیل میں اُس سامان کی فہرست ہے جو مقدِس کی تعمیر کے لئے استعمال ہوا۔ موسیٰ کے حکم پر امامِ اعظم ہارون کے بیٹے اِتمر نے لاویوں کی معرفت یہ فہرست تیار کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","(یہوداہ کے قبیلے کے بضلی ایل بن اُوری بن حور نے وہ سب کچھ بنایا جو رب نے موسیٰ کو بتایا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","اُس کے ساتھ دان کے قبیلے کا اُہلیاب بن اخی سمک تھا جو کاری گری کے ہر کام اور کڑھائی کے کام میں ماہر تھا۔ وہ نیلے، ارغوانی اور قرمزی رنگ کے دھاگے اور باریک کتان سے کپڑا بنانے میں بھی ماہر تھا۔) ");
INSERT INTO urdgvu_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","اُس سونے کا وزن جو لوگوں کے ہدئیوں سے جمع ہوا اور مقدِس کی تعمیر کے لئے استعمال ہوا تقریباً 1,000 کلو گرام تھا (اُسے مقدِس کے باٹوں کے حساب سے تولا گیا)۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","تعمیر کے لئے چاندی جو مردم شماری کے حساب سے وصول ہوئی، اُس کا وزن تقریباً 3,430 کلو گرام تھا (اُسے بھی مقدِس کے باٹوں کے حساب سے تولا گیا)۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","جن مردوں کی عمر 20 سال یا اِس سے زائد تھی اُنہیں چاندی کا آدھا آدھا سِکہ دینا پڑا۔ مردوں کی کُل تعداد 6,03,550 تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","چونکہ دیواروں کے تختوں کے پائے اور مُقدّس ترین کمرے کے دروازے کے ستونوں کے پائے چاندی کے تھے اِس لئے تقریباً پوری چاندی اِن 100 پائیوں کے لئے صَرف ہوئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","تقریباً 30 کلو گرام چاندی بچ گئی۔ اِس سے چاردیواری کے کھمبوں کی ہکیں اور پٹیاں بنائی گئیں، اور یہ کھمبوں کے اوپر کے سِروں پر بھی چڑھائی گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","جو پیتل ہدئیوں سے جمع ہوا اُس کا وزن تقریباً 2,425 کلو گرام تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","خیمے کے دروازے کے پائے، جانوروں کو چڑھانے کی قربان گاہ، اُس کا جنگلا، برتن اور ساز و سامان، ");
INSERT INTO urdgvu_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","چاردیواری کے پائے، صحن کے دروازے کے پائے اور خیمے اور چاردیواری کی تمام میخیں اِسی سے بنائی گئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","بضلی ایل کی ہدایت پر کاری گروں نے نیلے، ارغوانی اور قرمزی رنگ کا دھاگا لے کر مقدِس میں خدمت کے لئے لباس بنائے۔ اُنہوں نے ہارون کے مُقدّس کپڑے اُن ہدایات کے عین مطابق بنائے جو رب نے موسیٰ کو دی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","اُنہوں نے امامِ اعظم کا بالاپوش بنانے کے لئے سونا، نیلے، ارغوانی اور قرمزی رنگ کا دھاگا اور باریک کتان استعمال کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","اُنہوں نے سونے کو کوٹ کوٹ کر ورق بنایا اور پھر اُسے کاٹ کر دھاگے بنائے۔ جب نیلے، ارغوانی اور قرمزی رنگ کے دھاگے اور باریک کتان سے کپڑا بنایا گیا تو سونے کا یہ دھاگا مہارت سے کڑھائی کے کام میں استعمال ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","اُنہوں نے بالاپوش کے لئے دو پٹیاں بنائیں اور اُنہیں بالاپوش کے کندھوں پر رکھ کر سامنے اور پیچھے سے بالاپوش کے ساتھ لگائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","پٹکا بھی بنایا گیا جس سے بالاپوش کو باندھا جاتا تھا۔ اِس کے لئے بھی سونا، نیلے، ارغوانی اور قرمزی رنگ کا دھاگا اور باریک کتان استعمال ہوا۔ یہ اُن ہدایات کے عین مطابق ہوا جو رب نے موسیٰ کو دی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","پھر اُنہوں نے عقیقِ احمر کے دو پتھر چن لئے اور اُنہیں سونے کے خانوں میں جڑ کر اُن پر اسرائیل کے بارہ بیٹوں کے نام کندہ کئے۔ یہ نام جوہروں پر اُس طرح کندہ کئے گئے جس طرح مُہر کندہ کی جاتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","اُنہوں نے پتھروں کو بالاپوش کی دو پٹیوں پر یوں لگایا کہ وہ ہارون کے کندھوں پر رب کو اسرائیلیوں کی یاد دلاتے رہیں۔ یہ سب کچھ رب کی دی گئی ہدایات کے عین مطابق ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","اِس کے بعد اُنہوں نے سینے کا کیسہ بنایا۔ یہ ماہر کاری گر کا کام تھا اور اُن ہی چیزوں سے بنا جن سے ہارون کا بالاپوش بھی بنا تھا یعنی سونے اور نیلے، ارغوانی اور قرمزی رنگ کے دھاگے اور باریک کتان سے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","جب کپڑے کو ایک دفعہ تہہ کیا گیا تو کیسے کی لمبائی اور چوڑائی نو نو انچ تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","اُنہوں نے اُس پر چار قطاروں میں جواہر جڑے۔ ہر قطار میں تین تین جوہر تھے۔ پہلی قطار میں لعل، زبرجد اور زمرد۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","دوسری میں فیروزہ، سنگِ لاجورد اور حجر القمر۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","تیسری میں زرقون، عقیق اور یاقوتِ ارغوانی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","چوتھی میں پکھراج، عقیقِ احمر اور یشب۔ ہر جوہر سونے کے خانے میں جڑا ہوا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","یہ بارہ جواہر اسرائیل کے بارہ قبیلوں کی نمائندگی کرتے تھے۔ ایک ایک جوہر پر ایک قبیلے کا نام کندہ کیا گیا، اور یہ نام اُس طرح کندہ کئے گئے جس طرح مُہر کندہ کی جاتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","اب اُنہوں نے سینے کے کیسے کے لئے خالص سونے کی دو زنجیریں بنائیں جو ڈوری کی طرح گُندھی ہوئی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ساتھ ساتھ اُنہوں نے سونے کے دو خانے اور دو کڑے بھی بنائے۔ اُنہوں نے یہ کڑے کیسے کے اوپر کے دو کونوں پر لگائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","پھر دونوں زنجیریں اُن دو کڑوں کے ساتھ لگائی گئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","اُن کے دوسرے سرے بالاپوش کی کندھوں والی پٹیوں کے دو خانوں کے ساتھ جوڑ دیئے گئے، پھر سامنے کی طرف لگائے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","اُنہوں نے کیسے کے نچلے دو کونوں پر بھی سونے کے دو کڑے لگائے۔ وہ اندر، بالاپوش کی طرف لگے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","اب اُنہوں نے دو اَور کڑے بنا کر بالاپوش کی کندھوں والی پٹیوں پر لگائے۔ یہ بھی سامنے کی طرف لگے تھے لیکن نیچے، بالاپوش کے پٹکے کے اوپر ہی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","اُنہوں نے سینے کے کیسے کے نچلے کڑے نیلی ڈوری سے بالاپوش کے اِن نچلے کڑوں کے ساتھ باندھے۔ یوں کیسہ پٹکے کے اوپر اچھی طرح سینے کے ساتھ لگا رہا۔ یہ اُن ہدایات کے عین مطابق ہوا جو رب نے موسیٰ کو دی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","پھر کاری گروں نے چوغہ بُنا۔ وہ پوری طرح نیلے دھاگے سے بنایا گیا۔ چوغے کو بالاپوش سے پہلے پہننا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","اُس کے گریبان کو بُنے ہوئے کالر سے مضبوط کیا گیا تاکہ وہ نہ پھٹے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","اُنہوں نے نیلے، ارغوانی اور قرمزی رنگ کے دھاگے سے انار بنا کر اُنہیں چوغے کے دامن میں لگا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","اُن کے درمیان خالص سونے کی گھنٹیاں لگائی گئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","دامن میں انار اور گھنٹیاں باری باری لگائی گئیں۔ لازم تھا کہ ہارون خدمت کرنے کے لئے ہمیشہ یہ چوغہ پہنے۔ رب نے موسیٰ کو یہی حکم دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","کاری گروں نے ہارون اور اُس کے بیٹوں کے لئے باریک کتان کے زیرجامے بنائے۔ یہ بُننے والے کا کام تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ساتھ ساتھ اُنہوں نے باریک کتان کی پگڑیاں اور باریک کتان کے پاجامے بنائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","کمربند کو باریک کتان اور نیلے، ارغوانی اور قرمزی رنگ کے دھاگے سے بنایا گیا۔ کڑھائی کرنے والوں نے اِس پر کام کیا۔ سب کچھ اُن ہدایات کے مطابق بنایا گیا جو رب نے موسیٰ کو دی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","اُنہوں نے مُقدّس تاج یعنی خالص سونے کی تختی بنائی اور اُس پر یہ الفاظ کندہ کئے، ’رب کے لئے مخصوص و مُقدّس۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","پھر اُنہوں نے اِسے نیلی ڈوری سے پگڑی کے سامنے والے حصے سے لگا دیا۔ یہ بھی اُن ہدایات کے مطابق بنایا گیا جو رب نے موسیٰ کو دی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","آخرکار مقدِس کا کام مکمل ہوا۔ اسرائیلیوں نے سب کچھ اُن ہدایات کے مطابق بنایا تھا جو رب نے موسیٰ کو دی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","وہ مقدِس کی تمام چیزیں موسیٰ کے پاس لے آئے یعنی مُقدّس خیمہ اور اُس کا سارا سامان، اُس کی ہکیں، دیواروں کے تختے، شہتیر، ستون اور پائے، ");
INSERT INTO urdgvu_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","خیمے پر مینڈھوں کی سرخ رنگی ہوئی کھالوں کا غلاف اور تخس کی کھالوں کا غلاف، مُقدّس ترین کمرے کے دروازے کا پردہ، ");
INSERT INTO urdgvu_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","عہد کا صندوق جس میں شریعت کی تختیاں رکھنی تھیں، اُسے اُٹھانے کی لکڑیاں اور اُس کا ڈھکنا، ");
INSERT INTO urdgvu_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","مخصوص روٹیوں کی میز، اُس کا سارا سامان اور روٹیاں، ");
INSERT INTO urdgvu_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","خالص سونے کا شمع دان اور اُس پر رکھنے کے چراغ اُس کے سارے سامان سمیت، شمع دان کے لئے تیل، ");
INSERT INTO urdgvu_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","بخور جلانے کی سونے کی قربان گاہ، مسح کا تیل، خوشبودار بخور، مُقدّس خیمے کے دروازے کا پردہ، ");
INSERT INTO urdgvu_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","جانوروں کو چڑھانے کی پیتل کی قربان گاہ، اُس کا پیتل کا جنگلا، اُسے اُٹھانے کی لکڑیاں اور باقی سارا سامان، دھونے کا حوض اور وہ ڈھانچا جس پر حوض رکھنا تھا، ");
INSERT INTO urdgvu_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","چاردیواری کے پردے اُن کے کھمبوں اور پائیوں سمیت، صحن کے دروازے کا پردہ، چاردیواری کے رسّے اور میخیں، ملاقات کے خیمے میں خدمت کرنے کا باقی سارا سامان ");
INSERT INTO urdgvu_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","اور مقدِس میں خدمت کرنے کے وہ مُقدّس لباس جو ہارون اور اُس کے بیٹوں کو پہننے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","سب کچھ اُن ہدایات کے مطابق بنایا گیا تھا جو رب نے موسیٰ کو دی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","موسیٰ نے تمام چیزوں کا معائنہ کیا اور معلوم کیا کہ اُنہوں نے سب کچھ رب کی ہدایات کے مطابق بنایا تھا۔ تب اُس نے اُنہیں برکت دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","پھر رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","”پہلے مہینے کی پہلی تاریخ کو ملاقات کا خیمہ کھڑا کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","عہد کا صندوق جس میں شریعت کی تختیاں ہیں مُقدّس ترین کمرے میں رکھ کر اُس کے دروازے کا پردہ لگانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","اِس کے بعد مخصوص روٹیوں کی میز مُقدّس کمرے میں لا کر اُس پر تمام ضروری سامان رکھنا۔ اُس کمرے میں شمع دان بھی لے آنا اور اُس پر اُس کے چراغ رکھنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","بخور کی سونے کی قربان گاہ اُس پردے کے سامنے رکھنا جس کے پیچھے عہد کا صندوق ہے۔ پھر خیمے میں داخل ہونے کے دروازے پر پردہ لگانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","جانوروں کو چڑھانے کی قربان گاہ صحن میں خیمے کے دروازے کے سامنے رکھی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","خیمے اور اِس قربان گاہ کے درمیان دھونے کا حوض رکھ کر اُس میں پانی ڈالنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","صحن کی چاردیواری کھڑی کر کے اُس کے دروازے کا پردہ لگانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","پھر مسح کا تیل لے کر اُسے خیمے اور اُس کے سارے سامان پر چھڑک دینا۔ یوں تُو اُسے میرے لئے مخصوص کرے گا اور وہ مُقدّس ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","پھر جانوروں کو چڑھانے کی قربان گاہ اور اُس کے سامان پر مسح کا تیل چھڑکنا۔ یوں تُو اُسے میرے لئے مخصوص کرے گا اور وہ نہایت مُقدّس ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","اِسی طرح حوض اور اُس ڈھانچے کو بھی مخصوص کرنا جس پر حوض رکھا گیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","ہارون اور اُس کے بیٹوں کو ملاقات کے خیمے کے دروازے پر لا کر غسل کرانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","پھر ہارون کو مُقدّس لباس پہنانا اور اُسے مسح کر کے میرے لئے مخصوص و مُقدّس کرنا تاکہ امام کے طور پر میری خدمت کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","اُس کے بیٹوں کو لا کر اُنہیں زیر جامے پہنا دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","اُنہیں اُن کے والد کی طرح مسح کرنا تاکہ وہ بھی اماموں کے طور پر میری خدمت کریں۔ جب اُنہیں مسح کیا جائے گا تو وہ اور بعد میں اُن کی اولاد ہمیشہ تک مقدِس میں اِس خدمت کے لئے مخصوص ہوں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","موسیٰ نے سب کچھ رب کی ہدایات کے مطابق کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","پہلے مہینے کی پہلی تاریخ کو مُقدّس خیمہ کھڑا کیا گیا۔ اُنہیں مصر سے نکلے پورا ایک سال ہو گیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","موسیٰ نے دیوار کے تختوں کو اُن کے پائیوں پر کھڑا کر کے اُن کے ساتھ شہتیر لگائے۔ اِسی طرح اُس نے ستونوں کو بھی کھڑا کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","اُس نے رب کی ہدایات کے عین مطابق دیواروں پر کپڑے کا خیمہ لگایا اور اُس پر دوسرے غلاف رکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","اُس نے شریعت کی دونوں تختیاں لے کر عہد کے صندوق میں رکھ دیں، اُٹھانے کے لئے لکڑیاں صندوق کے کڑوں میں ڈال دیں اور کفارے کا ڈھکنا اُس پر لگا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","پھر اُس نے رب کی ہدایات کے عین مطابق صندوق کو مُقدّس ترین کمرے میں رکھ کر اُس کے دروازے کا پردہ لگا دیا۔ یوں عہد کے صندوق پر پردہ پڑا رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","موسیٰ نے مخصوص روٹیوں کی میز مُقدّس کمرے کے شمالی حصے میں اُس پردے کے سامنے رکھ دی جس کے پیچھے عہد کا صندوق تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","اُس نے رب کی ہدایت کے عین مطابق رب کے لئے مخصوص کی ہوئی روٹیاں میز پر رکھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","اُسی کمرے کے جنوبی حصے میں اُس نے شمع دان کو میز کے مقابل رکھ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","اُس پر اُس نے رب کی ہدایت کے عین مطابق رب کے سامنے چراغ رکھ دیئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","اُس نے بخور کی سونے کی قربان گاہ بھی اُسی کمرے میں رکھی، اُس پردے کے بالکل سامنے جس کے پیچھے عہد کا صندوق تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","اُس نے اُس پر رب کی ہدایت کے عین مطابق خوشبودار بخور جلایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","پھر اُس نے خیمے کا دروازہ لگا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","باہر جا کر اُس نے جانوروں کو چڑھانے کی قربان گاہ خیمے کے دروازے کے سامنے رکھ دی۔ اُس پر اُس نے رب کی ہدایت کے عین مطابق بھسم ہونے والی قربانیاں اور غلہ کی نذریں چڑھائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","اُس نے دھونے کے حوض کو خیمے اور اُس قربان گاہ کے درمیان رکھ کر اُس میں پانی ڈال دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","موسیٰ، ہارون اور اُس کے بیٹے اُسے اپنے ہاتھ پاؤں دھونے کے لئے استعمال کرتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","جب بھی وہ ملاقات کے خیمے میں داخل ہوتے یا جانوروں کو چڑھانے کی قربان گاہ کے پاس آتے تو رب کی ہدایت کے عین مطابق پہلے غسل کرتے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","آخر میں موسیٰ نے خیمہ، قربان گاہ اور چاردیواری کھڑی کر کے صحن کے دروازے کا پردہ لگا دیا۔ یوں موسیٰ نے مقدِس کی تعمیر مکمل کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","پھر ملاقات کے خیمے پر بادل چھا گیا اور مقدِس رب کے جلال سے بھر گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","موسیٰ خیمے میں داخل نہ ہو سکا، کیونکہ بادل اُس پر ٹھہرا ہوا تھا اور مقدِس رب کے جلال سے بھر گیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","تمام سفر کے دوران جب بھی مقدِس کے اوپر سے بادل اُٹھتا تو اسرائیلی سفر کے لئے تیار ہو جاتے۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","اگر وہ نہ اُٹھتا تو وہ اُس وقت تک ٹھہرے رہتے جب تک بادل اُٹھ نہ جاتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","دن کے وقت بادل مقدِس کے اوپر ٹھہرا رہتا اور رات کے وقت وہ تمام اسرائیلیوں کو آگ کی صورت میں نظر آتا تھا۔ یہ سلسلہ پورے سفر کے دوران جاری رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","رب نے ملاقات کے خیمے میں سے موسیٰ کو بُلا کر کہا ");
INSERT INTO urdgvu_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","کہ اسرائیلیوں کو اطلاع دے، ”اگر تم میں سے کوئی رب کو قربانی پیش کرنا چاہے تو وہ اپنے گائےبَیلوں یا بھیڑبکریوں میں سے جانور چن لے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","اگر وہ اپنے گائےبَیلوں میں سے بھسم ہونے والی قربانی چڑھانا چاہے تو وہ بےعیب بَیل چن کر اُسے ملاقات کے خیمے کے دروازے پر پیش کرے تاکہ رب اُسے قبول کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","قربانی پیش کرنے والا اپنا ہاتھ جانور کے سر پر رکھے تو یہ قربانی مقبول ہو کر اُس کا کفارہ دے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","قربانی پیش کرنے والا بَیل کو وہاں رب کے سامنے ذبح کرے۔ پھر ہارون کے بیٹے جو امام ہیں اُس کا خون رب کو پیش کر کے اُسے دروازے پر کی قربان گاہ کے چار پہلوؤں پر چھڑکیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","اِس کے بعد قربانی پیش کرنے والا کھال اُتار کر جانور کے ٹکڑے ٹکڑے کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","امام قربان گاہ پر آگ لگا کر اُس پر ترتیب سے لکڑیاں چنیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","اُس پر وہ جانور کے ٹکڑے سر اور چربی سمیت رکھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","لازم ہے کہ قربانی پیش کرنے والا پہلے جانور کی انتڑیاں اور پنڈلیاں دھوئے، پھر امام پورے جانور کو قربان گاہ پر جلا دے۔ اِس جلنے والی قربانی کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","اگر بھسم ہونے والی قربانی بھیڑبکریوں میں سے چنی جائے تو وہ بےعیب نر ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","پیش کرنے والا اُسے رب کے سامنے قربان گاہ کی شمالی سمت میں ذبح کرے۔ پھر ہارون کے بیٹے جو امام ہیں اُس کا خون قربان گاہ کے چار پہلوؤں پر چھڑکیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","اِس کے بعد پیش کرنے والا جانور کے ٹکڑے ٹکڑے کرے اور امام یہ ٹکڑے سر اور چربی سمیت قربان گاہ کی جلتی ہوئی لکڑیوں پر ترتیب سے رکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","لازم ہے کہ قربانی پیش کرنے والا پہلے جانور کی انتڑیاں اور پنڈلیاں دھوئے، پھر امام پورے جانور کو رب کو پیش کر کے قربان گاہ پر جلا دے۔ اِس جلنے والی قربانی کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","اگر بھسم ہونے والی قربانی پرندہ ہو تو وہ قمری یا جوان کبوتر ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","امام اُسے قربان گاہ کے پاس لے آئے اور اُس کا سر مروڑ کر قربان گاہ پر جلا دے۔ وہ اُس کا خون یوں نکلنے دے کہ وہ قربان گاہ کی ایک طرف سے نیچے ٹپکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","وہ اُس کا پوٹا اور جو اُس میں ہے دُور کر کے قربان گاہ کی مشرقی سمت میں پھینک دے، وہاں جہاں راکھ پھینکی جاتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","اُسے پیش کرتے وقت امام اُس کے پَر پکڑ کر پرندے کو پھاڑ ڈالے، لیکن یوں کہ وہ بالکل ٹکڑے ٹکڑے نہ ہو جائے۔ پھر امام اُسے قربان گاہ پر جلتی ہوئی لکڑیوں پر جلا دے۔ اِس جلنے والی قربانی کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","اگر کوئی رب کو غلہ کی نذر پیش کرنا چاہے تو وہ اِس کے لئے بہترین میدہ استعمال کرے۔ اُس پر وہ زیتون کا تیل اُنڈیلے اور لُبان رکھ کر ");
INSERT INTO urdgvu_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","اُسے ہارون کے بیٹوں کے پاس لے آئے جو امام ہیں۔ امام تیل سے ملایا گیا مٹھی بھر میدہ اور تمام لُبان لے کر قربان گاہ پر جلا دے۔ یہ یادگار کا حصہ ہے، اور اُس کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","باقی میدہ اور تیل ہارون اور اُس کے بیٹوں کا حصہ ہے۔ وہ رب کی جلنے والی قربانیوں میں سے ایک نہایت مُقدّس حصہ ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","اگر یہ قربانی تنور میں پکائی ہوئی روٹی ہو تو اُس میں خمیر نہ ہو۔ اِس کی دو قسمیں ہو سکتی ہیں، روٹیاں جو بہترین میدے اور تیل سے بنی ہوئی ہوں اور روٹیاں جن پر تیل لگایا گیا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","اگر یہ قربانی توے پر پکائی ہوئی روٹی ہو تو وہ بہترین میدے اور تیل کی ہو۔ اُس میں خمیر نہ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","چونکہ وہ غلہ کی نذر ہے اِس لئے روٹی کو ٹکڑے ٹکڑے کرنا اور اُس پر تیل ڈالنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","اگر یہ قربانی کڑاہی میں پکائی ہوئی روٹی ہو تو وہ بہترین میدے اور تیل کی ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","اگر تُو اِن چیزوں کی بنی ہوئی غلہ کی نذر رب کے حضور لانا چاہے تو اُسے امام کو پیش کرنا۔ وہی اُسے قربان گاہ کے پاس لے آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","پھر امام یادگار کا حصہ الگ کر کے اُسے قربان گاہ پر جلا دے۔ ایسی قربانی کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","قربانی کا باقی حصہ ہارون اور اُس کے بیٹوں کے لئے ہے۔ وہ رب کی جلنے والی قربانیوں میں سے ایک نہایت مُقدّس حصہ ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","غلہ کی جتنی نذریں تم رب کو پیش کرتے ہو اُن میں خمیر نہ ہو، کیونکہ لازم ہے کہ تم رب کو جلنے والی قربانی پیش کرتے وقت نہ خمیر، نہ شہد جلاؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","یہ چیزیں فصل کے پہلے پھلوں کے ساتھ رب کو پیش کی جا سکتی ہیں، لیکن اُنہیں قربان گاہ پر نہ جلایا جائے، کیونکہ وہاں رب کو اُن کی خوشبو پسند نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","غلہ کی ہر نذر میں نمک ہو، کیونکہ نمک اُس عہد کی نمائندگی کرتا ہے جو تیرے خدا نے تیرے ساتھ باندھا ہے۔ تجھے ہر قربانی میں نمک ڈالنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","اگر تُو غلہ کی نذر کے لئے فصل کے پہلے پھل پیش کرنا چاہے تو کچلی ہوئی کچی بالیاں بھون کر پیش کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","چونکہ وہ غلہ کی نذر ہے اِس لئے اُس پر تیل اُنڈیلنا اور لُبان رکھنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","کچلے ہوئے دانوں اور تیل کا جو حصہ رب کا ہے یعنی یادگار کا حصہ اُسے امام تمام لُبان کے ساتھ جلا دے۔ یہ نذر رب کے لئے جلنے والی قربانی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","اگر کوئی رب کو سلامتی کی قربانی پیش کرنے کے لئے گائے یا بَیل چڑھانا چاہے تو وہ جانور بےعیب ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","وہ اپنا ہاتھ جانور کے سر پر رکھ کر اُسے ملاقات کے خیمے کے دروازے پر ذبح کرے۔ ہارون کے بیٹے جو امام ہیں اُس کا خون قربان گاہ کے چار پہلوؤں پر چھڑکیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV3_3‏","004_3_3‏","LEV","3","3‏","4","پیش کرنے والا انتڑیوں پر کی ساری چربی، گُردے اُس چربی سمیت جو اُن پر اور کمر کے قریب ہوتی ہے اور جوڑ کلیجی جلنے والی قربانی کے طور پر رب کو پیش کرے۔ اِن چیزوں کو گُردوں کے ساتھ ہی الگ کرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","پھر ہارون کے بیٹے یہ سب کچھ بھسم ہونے والی قربانی کے ساتھ قربان گاہ کی لکڑیوں پر جلا دیں۔ یہ جلنے والی قربانی ہے، اور اِس کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","اگر سلامتی کی قربانی کے لئے بھیڑبکریوں میں سے جانور چنا جائے تو وہ بےعیب نر یا مادہ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","اگر وہ بھیڑ کا بچہ چڑھانا چاہے تو وہ اُسے رب کے سامنے لے آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","وہ اپنا ہاتھ اُس کے سر پر رکھ کر اُسے ملاقات کے خیمے کے سامنے ذبح کرے۔ ہارون کے بیٹے اُس کا خون قربان گاہ کے چار پہلوؤں پر چھڑکیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV3_9‏","004_3_9‏","LEV","3","9‏","10","پیش کرنے والا چربی، پوری دُم، انتڑیوں پر کی ساری چربی، گُردے اُس چربی سمیت جو اُن پر اور کمر کے قریب ہوتی ہے اور جوڑ کلیجی جلنے والی قربانی کے طور پر رب کو پیش کرے۔ اِن چیزوں کو گُردوں کے ساتھ ہی الگ کرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","امام یہ سب کچھ رب کو پیش کر کے قربان گاہ پر جلا دے۔ یہ خوراک جلنے والی قربانی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","اگر سلامتی کی قربانی بکری کی ہو ");
INSERT INTO urdgvu_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","تو پیش کرنے والا اُس پر ہاتھ رکھ کر اُسے ملاقات کے خیمے کے سامنے ذبح کرے۔ ہارون کے بیٹے جانور کا خون قربان گاہ کے چار پہلوؤں پر چھڑکیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV3_14‏","004_3_14‏","LEV","3","14‏","15","پیش کرنے والا انتڑیوں پر کی ساری چربی، گُردے اُس چربی سمیت جو اُن پر اور کمر کے قریب ہوتی ہے اور جوڑ کلیجی جلنے والی قربانی کے طور پر رب کو پیش کرے۔ اِن چیزوں کو گُردوں کے ساتھ ہی الگ کرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","امام یہ سب کچھ رب کو پیش کر کے قربان گاہ پر جلا دے۔ یہ خوراک جلنے والی قربانی ہے، اور اِس کی خوشبو رب کو پسند ہے۔ ساری چربی رب کی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","تمہارے لئے خون یا چربی کھانا منع ہے۔ یہ نہ صرف تمہارے لئے منع ہے بلکہ تمہاری اولاد کے لئے بھی، نہ صرف یہاں بلکہ ہر جگہ جہاں تم رہتے ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","”اسرائیلیوں کو بتانا کہ جو بھی غیرارادی طور پر گناہ کر کے رب کے کسی حکم کو توڑے وہ یہ کرے: ");
INSERT INTO urdgvu_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","اگر امامِ اعظم گناہ کرے اور نتیجے میں پوری قوم قصوروار ٹھہرے تو پھر وہ رب کو ایک بےعیب جوان بَیل لے کر گناہ کی قربانی کے طور پر پیش کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","وہ جوان بَیل کو ملاقات کے خیمے کے دروازے کے پاس لے آئے اور اپنا ہاتھ اُس کے سر پر رکھ کر اُسے رب کے سامنے ذبح کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","پھر وہ جانور کے خون میں سے کچھ لے کر خیمے میں جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","وہاں وہ اپنی اُنگلی اُس میں ڈال کر اُسے سات بار رب کے سامنے یعنی مُقدّس ترین کمرے کے پردے پر چھڑکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","پھر وہ خیمے کے اندر کی اُس قربان گاہ کے چاروں سینگوں پر خون لگائے جس پر بخور جلایا جاتا ہے۔ باقی خون وہ باہر خیمے کے دروازے پر کی اُس قربان گاہ کے پائے پر اُنڈیلے جس پر جانور جلائے جاتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","جوان بَیل کی ساری چربی، انتڑیوں پر کی ساری چربی، ");
INSERT INTO urdgvu_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","گُردے اُس چربی سمیت جو اُن پر اور کمر کے قریب ہوتی ہے اور جوڑ کلیجی کو گُردوں کے ساتھ ہی الگ کرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","یہ بالکل اُسی طرح کیا جائے جس طرح اُس بَیل کے ساتھ کیا گیا جو سلامتی کی قربانی کے لئے پیش کیا جاتا ہے۔ امام یہ سب کچھ اُس قربان گاہ پر جلا دے جس پر جانور جلائے جاتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","لیکن وہ اُس کی کھال، اُس کا سارا گوشت، سر اور پنڈلیاں، انتڑیاں اور اُن کا گوبر ");
INSERT INTO urdgvu_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","خیمہ گاہ کے باہر لے جائے۔ یہ چیزیں اُس پاک جگہ پر جہاں قربانیوں کی راکھ پھینکی جاتی ہے لکڑیوں پر رکھ کر جلا دینی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","اگر اسرائیل کی پوری جماعت نے غیرارادی طور پر گناہ کر کے رب کے کسی حکم سے تجاوز کیا ہے اور جماعت کو معلوم نہیں تھا توبھی وہ قصوروار ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","جب لوگوں کو پتا لگے کہ ہم نے گناہ کیا ہے تو جماعت ملاقات کے خیمے کے پاس ایک جوان بَیل لے آئے اور اُسے گناہ کی قربانی کے طور پر پیش کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","جماعت کے بزرگ رب کے سامنے اپنے ہاتھ اُس کے سر پر رکھیں، اور وہ وہیں ذبح کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","پھر امامِ اعظم جانور کے خون میں سے کچھ لے کر ملاقات کے خیمے میں جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","وہاں وہ اپنی اُنگلی اُس میں ڈال کر اُسے سات بار رب کے سامنے یعنی مُقدّس ترین کمرے کے پردے پر چھڑکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","پھر وہ خیمے کے اندر کی اُس قربان گاہ کے چاروں سینگوں پر خون لگائے جس پر بخور جلایا جاتا ہے۔ باقی خون وہ باہر خیمے کے دروازے کی اُس قربان گاہ کے پائے پر اُنڈیلے جس پر جانور جلائے جاتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","اِس کے بعد وہ اُس کی تمام چربی نکال کر قربان گاہ پر جلا دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","اُس بَیل کے ساتھ وہ سب کچھ کرے جو اُسے اپنے ذاتی غیرارادی گناہ کے لئے کرنا ہوتا ہے۔ یوں وہ لوگوں کا کفارہ دے گا اور اُنہیں معافی مل جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","آخر میں وہ بَیل کو خیمہ گاہ کے باہر لے جا کر اُس طرح جلا دے جس طرح اُسے اپنے لئے بَیل کو جلا دینا ہوتا ہے۔ یہ جماعت کا گناہ دُور کرنے کی قربانی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","اگر کوئی سردار غیرارادی طور پر گناہ کر کے رب کے کسی حکم سے تجاوز کرے اور یوں قصوروار ٹھہرے تو ");
INSERT INTO urdgvu_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","جب بھی اُسے پتا لگے کہ مجھ سے گناہ ہوا ہے تو وہ قربانی کے لئے ایک بےعیب بکرا لے آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","وہ اپنا ہاتھ بکرے کے سر پر رکھ کر اُسے وہاں ذبح کرے جہاں بھسم ہونے والی قربانیاں ذبح کی جاتی ہیں۔ یہ گناہ کی قربانی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","امام اپنی اُنگلی خون میں ڈال کر اُسے اُس قربان گاہ کے چاروں سینگوں پر لگائے جس پر جانور جلائے جاتے ہیں۔ باقی خون وہ قربان گاہ کے پائے پر اُنڈیلے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","پھر وہ اُس کی ساری چربی قربان گاہ پر اُس طرح جلا دے جس طرح وہ سلامتی کی قربانیوں کی چربی جلا دیتا ہے۔ یوں امام اُس آدمی کا کفارہ دے گا اور اُسے معافی حاصل ہو جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","اگر کوئی عام شخص غیرارادی طور پر گناہ کر کے رب کے کسی حکم سے تجاوز کرے اور یوں قصوروار ٹھہرے تو ");
INSERT INTO urdgvu_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","جب بھی اُسے پتا لگے کہ مجھ سے گناہ ہوا ہے تو وہ قربانی کے لئے ایک بےعیب بکری لے آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","وہ اپنا ہاتھ بکری کے سر پر رکھ کر اُسے وہاں ذبح کرے جہاں بھسم ہونے والی قربانیاں ذبح کی جاتی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","امام اپنی اُنگلی خون میں ڈال کر اُسے اُس قربان گاہ کے چاروں سینگوں پر لگائے جس پر جانور جلائے جاتے ہیں۔ باقی خون وہ قربان گاہ کے پائے پر اُنڈیلے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","پھر وہ اُس کی ساری چربی اُس طرح نکالے جس طرح وہ سلامتی کی قربانیوں کی چربی نکالتا ہے۔ اِس کے بعد وہ اُسے قربان گاہ پر جلا دے۔ ایسی قربانی کی خوشبو رب کو پسند ہے۔ یوں امام اُس آدمی کا کفارہ دے گا اور اُسے معافی حاصل ہو جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","اگر وہ گناہ کی قربانی کے لئے بھیڑ کا بچہ لانا چاہے تو وہ بےعیب مادہ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","وہ اپنا ہاتھ اُس کے سر پر رکھ کر اُسے وہاں ذبح کرے جہاں بھسم ہونے والی قربانیاں ذبح کی جاتی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","امام اپنی اُنگلی خون میں ڈال کر اُسے اُس قربان گاہ کے چاروں سینگوں پر لگائے جس پر جانور جلائے جاتے ہیں۔ باقی خون وہ قربان گاہ کے پائے پر اُنڈیلے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","پھر وہ اُس کی تمام چربی اُس طرح نکالے جس طرح سلامتی کی قربانی کے لئے ذبح کئے گئے جوان مینڈھے کی چربی نکالی جاتی ہے۔ اِس کے بعد امام چربی کو قربان گاہ پر اُن قربانیوں سمیت جلا دے جو رب کے لئے جلائی جاتی ہیں۔ یوں امام اُس آدمی کا کفارہ دے گا اور اُسے معافی مل جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","ہو سکتا ہے کہ کسی نے یوں گناہ کیا کہ اُس نے کوئی جرم دیکھا یا وہ اُس کے بارے میں کچھ جانتا ہے۔ توبھی جب گواہوں کو قَسم کے لئے بُلایا جاتا ہے تو وہ گواہی دینے کے لئے سامنے نہیں آتا۔ اِس صورت میں وہ قصوروار ٹھہرتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","ہو سکتا ہے کہ کسی نے غیرارادی طور پر کسی ناپاک چیز کو چھو لیا ہے، خواہ وہ کسی جنگلی جانور، مویشی یا رینگنے والے جانور کی لاش کیوں نہ ہو۔ اِس صورت میں وہ ناپاک ہے اور قصوروار ٹھہرتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","ہو سکتا ہے کہ کسی نے غیرارادی طور پر کسی شخص کی ناپاکی کو چھو لیا ہے یعنی اُس کی کوئی ایسی چیز جس سے وہ ناپاک ہو گیا ہے۔ جب اُسے معلوم ہو جاتا ہے تو وہ قصوروار ٹھہرتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","ہو سکتا ہے کہ کسی نے بےپروائی سے کچھ کرنے کی قَسم کھائی ہے، چاہے وہ اچھا کام تھا یا غلط۔ جب وہ جان لیتا ہے کہ اُس نے کیا کِیا ہے تو وہ قصوروار ٹھہرتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","جو اِس طرح کے کسی گناہ کی بنا پر قصوروار ہو، لازم ہے کہ وہ اپنا گناہ تسلیم کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","پھر وہ گناہ کی قربانی کے طور پر ایک بھیڑ یا بکری پیش کرے۔ یوں امام اُس کا کفارہ دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","اگر قصوروار شخص غربت کے باعث بھیڑ یا بکری نہ دے سکے تو وہ رب کو دو قمریاں یا دو جوان کبوتر پیش کرے، ایک گناہ کی قربانی کے لئے اور ایک بھسم ہونے والی قربانی کے لئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","وہ اُنہیں امام کے پاس لے آئے۔ امام پہلے گناہ کی قربانی کے لئے پرندہ پیش کرے۔ وہ اُس کی گردن مروڑ ڈالے لیکن ایسے کہ سر جدا نہ ہو جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","پھر وہ اُس کے خون میں سے کچھ قربان گاہ کے ایک پہلو پر چھڑکے۔ باقی خون وہ یوں نکلنے دے کہ وہ قربان گاہ کے پائے پر ٹپکے۔ یہ گناہ کی قربانی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","پھر امام دوسرے پرندے کو قواعد کے مطابق بھسم ہونے والی قربانی کے طور پر پیش کرے۔ یوں امام اُس آدمی کا کفارہ دے گا اور اُسے معافی مل جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","اگر وہ شخص غربت کے باعث دو قمریاں یا دو جوان کبوتر بھی نہ دے سکے تو پھر وہ گناہ کی قربانی کے لئے ڈیڑھ کلو گرام بہترین میدہ پیش کرے۔ وہ اُس پر نہ تیل اُنڈیلے، نہ لُبان رکھے، کیونکہ یہ غلہ کی نذر نہیں بلکہ گناہ کی قربانی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","وہ اُسے امام کے پاس لے آئے جو یادگار کا حصہ یعنی مٹھی بھر اُن قربانیوں کے ساتھ جلا دے جو رب کے لئے جلائی جاتی ہیں۔ یہ گناہ کی قربانی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","یوں امام اُس آدمی کا کفارہ دے گا اور اُسے معافی مل جائے گی۔ غلہ کی نذر کی طرح باقی میدہ امام کا حصہ ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","”اگر کسی نے بےایمانی کر کے غیرارادی طور پر رب کی مخصوص اور مُقدّس چیزوں کے سلسلے میں گناہ کیا ہو، ایسا شخص قصور کی قربانی کے طور پر رب کو بےعیب اور قیمت کے لحاظ سے مناسب مینڈھا یا بکرا پیش کرے۔ اُس کی قیمت مقدِس کی شرح کے مطابق مقرر کی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","جتنا نقصان مقدِس کو ہوا ہے اُتنا ہی وہ دے۔ اِس کے علاوہ وہ مزید 20 فیصد ادا کرے۔ وہ اُسے امام کو دے دے اور امام جانور کو قصور کی قربانی کے طور پر پیش کر کے اُس کا کفارہ دے۔ یوں اُسے معافی مل جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","اگر کوئی غیرارادی طور پر گناہ کر کے رب کے کسی حکم سے تجاوز کرے تو وہ قصوروار ہے، اور وہ اُس کا ذمہ دار ٹھہرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","وہ قصور کی قربانی کے طور پر امام کے پاس ایک بےعیب اور قیمت کے لحاظ سے مناسب مینڈھا لے آئے۔ اُس کی قیمت مقدِس کی شرح کے مطابق مقرر کی جائے۔ پھر امام یہ قربانی اُس گناہ کے لئے چڑھائے جو قصوروار شخص نے غیرارادی طور پر کیا ہے۔ یوں اُسے معافی مل جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","یہ قصور کی قربانی ہے، کیونکہ وہ رب کا گناہ کر کے قصوروار ٹھہرا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","”ہو سکتا ہے کسی نے گناہ کر کے بےایمانی کی ہے، مثلاً اُس نے اپنے پڑوسی کی کوئی چیز واپس نہیں کی جو اُس کے سپرد کی گئی تھی یا جو اُسے گروی کے طور پر ملی تھی، یا اُس نے اُس کی کوئی چیز چوری کی، یا اُس نے کسی سے کوئی چیز چھین لی، ");
INSERT INTO urdgvu_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","یا اُس نے کسی کی گم شدہ چیز کے بارے میں جھوٹ بولا جب اُسے مل گئی، یا اُس نے قَسم کھا کر جھوٹ بولا ہے، یا اِس طرح کا کوئی اَور گناہ کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","اگر وہ اِس طرح کا گناہ کر کے قصوروار ٹھہرے تو لازم ہے کہ وہ وہی چیز واپس کرے جو اُس نے چوری کی یا چھین لی یا جو اُس کے سپرد کی گئی یا جو گم شدہ ہو کر اُس کے پاس آ گئی ہے ");
INSERT INTO urdgvu_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","یا جس کے بارے میں اُس نے قَسم کھا کر جھوٹ بولا ہے۔ وہ اُس کا اُتنا ہی واپس کر کے 20 فیصد زیادہ دے۔ اور وہ یہ سب کچھ اُس دن واپس کرے جب وہ اپنی قصور کی قربانی پیش کرتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","قصور کی قربانی کے طور پر وہ ایک بےعیب اور قیمت کے لحاظ سے مناسب مینڈھا امام کے پاس لے آئے اور رب کو پیش کرے۔ اُس کی قیمت مقدِس کی شرح کے مطابق مقرر کی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","پھر امام رب کے سامنے اُس کا کفارہ دے گا تو اُسے معافی مل جائے گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","”ہارون اور اُس کے بیٹوں کو بھسم ہونے والی قربانیوں کے بارے میں ذیل کی ہدایات دینا: بھسم ہونے والی قربانی پوری رات صبح تک قربان گاہ کی اُس جگہ پر رہے جہاں آگ جلتی ہے۔ آگ کو بجھنے نہ دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","صبح کو امام کتان کا لباس اور کتان کا پاجامہ پہن کر قربانی سے بچی ہوئی راکھ قربان گاہ کے پاس زمین پر ڈالے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","پھر وہ اپنے کپڑے بدل کر راکھ کو خیمہ گاہ کے باہر کسی پاک جگہ پر چھوڑ آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","قربان گاہ پر آگ جلتی رہے۔ وہ کبھی بھی نہ بجھے۔ ہر صبح امام لکڑیاں چن کر اُس پر بھسم ہونے والی قربانی ترتیب سے رکھے اور اُس پر سلامتی کی قربانی کی چربی جلا دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","آگ ہمیشہ جلتی رہے۔ وہ کبھی نہ بجھنے پائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","غلہ کی نذر کے بارے میں ہدایات یہ ہیں: ہارون کے بیٹے اُسے قربان گاہ کے سامنے رب کو پیش کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","پھر امام یادگار کا حصہ یعنی تیل سے ملایا گیا مٹھی بھر بہترین میدہ اور قربانی کا تمام لُبان لے کر قربان گاہ پر جلا دے۔ اِس کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ہارون اور اُس کے بیٹے قربانی کا باقی حصہ کھا لیں۔ لیکن وہ اُسے مُقدّس جگہ پر یعنی ملاقات کے خیمے کی چاردیواری کے اندر کھائیں، اور اُس میں خمیر نہ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","اُسے پکانے کے لئے اُس میں خمیر نہ ڈالا جائے۔ مَیں نے جلنے والی قربانیوں میں سے یہ حصہ اُن کے لئے مقرر کیا ہے۔ یہ گناہ کی قربانی اور قصور کی قربانی کی طرح نہایت مُقدّس ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ہارون کی اولاد کے تمام مرد اُسے کھائیں۔ یہ اصول ابد تک قائم رہے۔ جو بھی اُسے چھوئے گا وہ مخصوص و مُقدّس ہو جائے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","”جب ہارون اور اُس کے بیٹوں کو امام کی ذمہ داری اُٹھانے کے لئے مخصوص کر کے تیل سے مسح کیا جائے گا تو وہ ڈیڑھ کلو گرام بہترین میدہ پیش کریں۔ اُس کا آدھا حصہ صبح کو اور آدھا حصہ شام کے وقت پیش کیا جائے۔ وہ غلہ کی یہ نذر روزانہ پیش کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","اُسے تیل کے ساتھ ملا کر توے پر پکانا ہے۔ پھر اُسے ٹکڑے ٹکڑے کر کے غلہ کی نذر کے طور پر پیش کرنا۔ اُس کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","یہ قربانی ہمیشہ ہارون کی نسل کا وہ آدمی پیش کرے جسے مسح کر کے امامِ اعظم کا عُہدہ دیا گیا ہے، اور وہ اُسے پورے طور پر رب کے لئے جلا دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","امام کی غلہ کی نذر ہمیشہ پورے طور پر جلانا۔ اُسے نہ کھانا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","”ہارون اور اُس کے بیٹوں کو گناہ کی قربانی کے بارے میں ذیل کی ہدایات دینا: گناہ کی قربانی کو رب کے سامنے وہیں ذبح کرنا ہے جہاں بھسم ہونے والی قربانی ذبح کی جاتی ہے۔ وہ نہایت مُقدّس ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","اُسے پیش کرنے والا امام اُسے مُقدّس جگہ پر یعنی ملاقات کے خیمے کی چاردیواری کے اندر کھائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","جو بھی اِس قربانی کے گوشت کو چھو لیتا ہے وہ مخصوص و مُقدّس ہو جاتا ہے۔ اگر قربانی کے خون کے چھینٹے کسی لباس پر پڑ جائیں تو اُسے مُقدّس جگہ پر دھونا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","اگر گوشت کو ہنڈیا میں پکایا گیا ہو تو اُس برتن کو بعد میں توڑ دینا ہے۔ اگر اُس کے لئے پیتل کا برتن استعمال کیا گیا ہو تو اُسے خوب مانجھ کر پانی سے صاف کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","اماموں کے خاندانوں میں سے تمام مرد اُسے کھا سکتے ہیں۔ یہ کھانا نہایت مُقدّس ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","لیکن گناہ کی ہر وہ قربانی کھائی نہ جائے جس کا خون ملاقات کے خیمے میں اِس لئے لایا گیا ہے کہ مقدِس میں کسی کا کفارہ دیا جائے۔ اُسے جلانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","قصور کی قربانی جو نہایت مُقدّس ہے اُس کے بارے میں ہدایات یہ ہیں: ");
INSERT INTO urdgvu_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","قصور کی قربانی وہیں ذبح کرنی ہے جہاں بھسم ہونے والی قربانی ذبح کی جاتی ہے۔ اُس کا خون قربان گاہ کے چار پہلوؤں پر چھڑکا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","اُس کی تمام چربی نکال کر قربان گاہ پر چڑھانی ہے یعنی اُس کی دُم، انتڑیوں پر کی چربی، ");
INSERT INTO urdgvu_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","گُردے اُس چربی سمیت جو اُن پر اور کمر کے قریب ہوتی ہے اور جوڑ کلیجی۔ اِن چیزوں کو گُردوں کے ساتھ ہی الگ کرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","امام یہ سب کچھ رب کو قربان گاہ پر جلنے والی قربانی کے طور پر پیش کرے۔ یہ قصور کی قربانی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","اماموں کے خاندانوں میں سے تمام مرد اُسے کھا سکتے ہیں۔ لیکن اُسے مُقدّس جگہ پر کھایا جائے۔ یہ نہایت مُقدّس ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","گناہ اور قصور کی قربانی کے لئے ایک ہی اصول ہے، جو امام قربانی کو پیش کر کے کفارہ دیتا ہے اُس کو اُس کا گوشت ملتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","اِس طرح جو امام کسی جانور کو بھسم ہونے والی قربانی کے طور پر چڑھاتا ہے اُسی کو جانور کی کھال ملتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","اور اِسی طرح تنور میں، کڑاہی میں یا توے پر پکائی گئی غلہ کی ہر نذر اُس امام کو ملتی ہے جس نے اُسے پیش کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","لیکن ہارون کے تمام بیٹوں کو غلہ کی باقی نذریں برابر برابر ملتی رہیں، خواہ اُن میں تیل ملایا گیا ہو یا وہ خشک ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","سلامتی کی قربانی جو رب کو پیش کی جاتی ہے اُس کے بارے میں ذیل کی ہدایات ہیں: ");
INSERT INTO urdgvu_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","اگر کوئی اِس قربانی سے اپنی شکرگزاری کا اظہار کرنا چاہے تو وہ جانور کے ساتھ بےخمیری روٹی جس میں تیل ڈالا گیا ہو، بےخمیری روٹی جس پر تیل لگایا گیا ہو اور روٹی جس میں بہترین میدہ اور تیل ملایا گیا ہو پیش کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","اِس کے علاوہ وہ خمیری روٹی بھی پیش کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","پیش کرنے والا قربانی کی ہر چیز کا ایک حصہ اُٹھا کر رب کے لئے مخصوص کرے۔ یہ اُس امام کا حصہ ہے جو جانور کا خون قربان گاہ پر چھڑکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","گوشت اُسی دن کھایا جائے جب جانور کو ذبح کیا گیا ہو۔ اگلی صبح تک کچھ نہیں بچنا چاہئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","اِس قربانی کا گوشت صرف اِس صورت میں اگلے دن کھایا جا سکتا ہے جب کسی نے مَنت مان کر یا اپنی خوشی سے اُسے پیش کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","اگر کچھ گوشت تیسرے دن تک بچ جائے تو اُسے جلانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","اگر اُسے تیسرے دن بھی کھایا جائے تو رب یہ قربانی قبول نہیں کرے گا۔ اُس کا کوئی فائدہ نہیں ہو گا بلکہ اُسے ناپاک قرار دیا جائے گا۔ جو بھی اُس سے کھائے گا وہ قصوروار ٹھہرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","اگر یہ گوشت کسی ناپاک چیز سے لگ جائے تو اُسے نہیں کھانا ہے بلکہ اُسے جلایا جائے۔ اگر گوشت پاک ہے تو ہر شخص جو خود پاک ہے اُسے کھا سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","لیکن اگر ناپاک شخص رب کو پیش کی گئی سلامتی کی قربانی کا یہ گوشت کھائے تو اُسے اُس کی قوم میں سے مٹا ڈالنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ہو سکتا ہے کہ کسی نے کسی ناپاک چیز کو چھو لیا ہے چاہے وہ ناپاک شخص، جانور یا کوئی اَور گھنونی اور ناپاک چیز ہو۔ اگر ایسا شخص رب کو پیش کی گئی سلامتی کی قربانی کا گوشت کھائے تو اُسے اُس کی قوم میں سے مٹا ڈالنا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","”اسرائیلیوں کو بتا دینا کہ گائےبَیل اور بھیڑبکریوں کی چربی کھانا تمہارے لئے منع ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","تم فطری طور پر مرے ہوئے جانوروں اور پھاڑے ہوئے جانوروں کی چربی دیگر کاموں کے لئے استعمال کر سکتے ہو، لیکن اُسے کھانا منع ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","جو بھی اُس چربی میں سے کھائے جو جلا کر رب کو پیش کی جاتی ہے اُسے اُس کی قوم میں سے مٹا ڈالنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","جہاں بھی تم رہتے ہو وہاں پرندوں یا دیگر جانوروں کا خون کھانا منع ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","جو بھی خون کھائے اُسے اُس کی قوم میں سے مٹایا جائے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","”اسرائیلیوں کو بتانا کہ جو رب کو سلامتی کی قربانی پیش کرے وہ رب کے لئے ایک حصہ مخصوص کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","وہ جلنے والی یہ قربانی اپنے ہاتھوں سے رب کو پیش کرے۔ اِس کے لئے وہ جانور کی چربی اور سینہ رب کے سامنے پیش کرے۔ سینہ ہلانے والی قربانی ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","امام چربی کو قربان گاہ پر جلا دے جبکہ سینہ ہارون اور اُس کے بیٹوں کا حصہ ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","قربانی کی دہنی ران امام کو اُٹھانے والی قربانی کے طور پر دی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","وہ اُس امام کا حصہ ہے جو سلامتی کی قربانی کا خون اور چربی چڑھاتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","اسرائیلیوں کی سلامتی کی قربانیوں میں سے مَیں نے ہلانے والا سینہ اور اُٹھانے والی ران اماموں کو دی ہے۔ یہ چیزیں ہمیشہ کے لئے اسرائیلیوں کی طرف سے اماموں کا حق ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","یہ اُس دن جلنے والی قربانیوں میں سے ہارون اور اُس کے بیٹوں کا حصہ بن گئیں جب اُنہیں مقدِس میں رب کی خدمت میں پیش کیا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","رب نے اُس دن جب اُنہیں تیل سے مسح کیا گیا حکم دیا تھا کہ اسرائیلی یہ حصہ ہمیشہ اماموں کو دیا کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","غرض یہ ہدایات تمام قربانیوں کے بارے میں ہیں یعنی بھسم ہونے والی قربانی، غلہ کی نذر، گناہ کی قربانی، قصور کی قربانی، امام کو مقدِس میں خدمت کے لئے مخصوص کرنے کی قربانی اور سلامتی کی قربانی کے بارے میں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","رب نے موسیٰ کو یہ ہدایات سینا پہاڑ پر دیں، اُس دن جب اُس نے اسرائیلیوں کو حکم دیا کہ وہ دشتِ سینا میں رب کو اپنی قربانیاں پیش کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","”ہارون اور اُس کے بیٹوں کو میرے حضور لے آنا۔ نیز اماموں کے لباس، مسح کا تیل، گناہ کی قربانی کے لئے جوان بَیل، دو مینڈھے اور بےخمیری روٹیوں کی ٹوکری لے آنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","پھر پوری جماعت کو خیمے کے دروازے پر جمع کرنا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","موسیٰ نے ایسا ہی کیا۔ جب پوری جماعت اکٹھی ہو گئی تو ");
INSERT INTO urdgvu_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","اُس نے اُن سے کہا، ”اب مَیں وہ کچھ کرتا ہوں جس کا حکم رب نے دیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","موسیٰ نے ہارون اور اُس کے بیٹوں کو سامنے لا کر غسل کرایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","اُس نے ہارون کو کتان کا زیرجامہ پہنا کر کمربند لپیٹا۔ پھر اُس نے چوغہ پہنایا جس پر اُس نے بالاپوش کو مہارت سے بُنے ہوئے پٹکے سے باندھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","اِس کے بعد اُس نے سینے کا کیسہ لگا کر اُس میں دونوں قرعے بنام اُوریم اور تُمیم رکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","پھر اُس نے ہارون کے سر پر پگڑی رکھی جس کے سامنے والے حصے پر اُس نے مُقدّس تاج یعنی سونے کی تختی لگا دی۔ سب کچھ اُس حکم کے عین مطابق ہوا جو رب نے موسیٰ کو دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","اِس کے بعد موسیٰ نے مسح کے تیل سے مقدِس کو اور جو کچھ اُس میں تھا مسح کر کے اُسے مخصوص و مُقدّس کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","اُس نے یہ تیل سات بار جانور چڑھانے کی قربان گاہ اور اُس کے سامان پر چھڑک دیا۔ اِسی طرح اُس نے سات بار دھونے کے حوض اور اُس ڈھانچے پر تیل چھڑک دیا جس پر حوض رکھا ہوا تھا۔ یوں یہ چیزیں مخصوص و مُقدّس ہوئیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","اُس نے ہارون کے سر پر مسح کا تیل اُنڈیل کر اُسے مسح کیا۔ یوں وہ مخصوص و مُقدّس ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","پھر موسیٰ نے ہارون کے بیٹوں کو سامنے لا کر اُنہیں زیر جامے پہنائے، کمربند لپیٹے اور اُن کے سروں پر پگڑیاں باندھیں۔ سب کچھ اُس حکم کے عین مطابق ہوا جو رب نے موسیٰ کو دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","اب موسیٰ نے گناہ کی قربانی کے لئے جوان بَیل کو پیش کیا۔ ہارون اور اُس کے بیٹوں نے اپنے ہاتھ اُس کے سر پر رکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","موسیٰ نے اُسے ذبح کر کے اُس کے خون میں سے کچھ لے کر اپنی اُنگلی سے قربان گاہ کے سینگوں پر لگا دیا تاکہ وہ گناہوں سے پاک ہو جائے۔ باقی خون اُس نے قربان گاہ کے پائے پر اُنڈیل دیا۔ یوں اُس نے اُسے مخصوص و مُقدّس کر کے اُس کا کفارہ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","موسیٰ نے انتڑیوں پر کی تمام چربی، جوڑ کلیجی اور دونوں گُردے اُن کی چربی سمیت لے کر قربان گاہ پر جلا دیئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","لیکن بَیل کی کھال، گوشت اور انتڑیوں کے گوبر کو اُس نے خیمہ گاہ کے باہر لے جا کر جلا دیا۔ سب کچھ اُس حکم کے مطابق ہوا جو رب نے موسیٰ کو دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","اِس کے بعد اُس نے بھسم ہونے والی قربانی کے لئے پہلا مینڈھا پیش کیا۔ ہارون اور اُس کے بیٹوں نے اپنے ہاتھ اُس کے سر پر رکھ دیئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","موسیٰ نے اُسے ذبح کر کے اُس کا خون قربان گاہ کے چار پہلوؤں پر چھڑک دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","اُس نے مینڈھے کو ٹکڑے ٹکڑے کر کے سر، ٹکڑے اور چربی جلا دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","اُس نے انتڑیاں اور پنڈلیاں پانی سے صاف کر کے پورے مینڈھے کو قربان گاہ پر جلا دیا۔ سب کچھ اُس حکم کے عین مطابق ہوا جو رب نے موسیٰ کو دیا تھا۔ رب کے لئے جلنے والی یہ قربانی بھسم ہونے والی قربانی تھی، اور اُس کی خوشبو رب کو پسند تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","اِس کے بعد موسیٰ نے دوسرے مینڈھے کو پیش کیا۔ اِس قربانی کا مقصد اماموں کو مقدِس میں خدمت کے لئے مخصوص کرنا تھا۔ ہارون اور اُس کے بیٹوں نے اپنے ہاتھ مینڈھے کے سر پر رکھ دیئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","موسیٰ نے اُسے ذبح کر کے اُس کے خون میں سے کچھ لے کر ہارون کے دہنے کان کی لَو پر اور اُس کے دہنے ہاتھ اور دہنے پاؤں کے انگوٹھوں پر لگایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","یہی اُس نے ہارون کے بیٹوں کے ساتھ بھی کیا۔ اُس نے اُنہیں سامنے لا کر اُن کے دہنے کان کی لَو پر اور اُن کے دہنے ہاتھ اور دہنے پاؤں کے انگوٹھوں پر خون لگایا۔ باقی خون اُس نے قربان گاہ کے چار پہلوؤں پر چھڑک دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","اُس نے مینڈھے کی چربی، دُم، انتڑیوں پر کی ساری چربی، جوڑ کلیجی، دونوں گُردے اُن کی چربی سمیت اور دہنی ران الگ کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","پھر وہ رب کے سامنے پڑی بےخمیری روٹیوں کی ٹوکری میں سے ایک سادہ روٹی، ایک روٹی جس میں تیل ڈالا گیا تھا اور ایک روٹی جس پر تیل لگایا گیا تھا لے کر چربی اور ران پر رکھ دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","اُس نے یہ سب کچھ ہارون اور اُس کے بیٹوں کے ہاتھوں پر رکھ کر اُسے ہلانے والی قربانی کے طور پر رب کو پیش کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","پھر اُس نے یہ چیزیں اُن سے واپس لے کر قربان گاہ پر جلا دیں جس پر پہلے بھسم ہونے والی قربانی رکھی گئی تھی۔ رب کے لئے جلنے والی یہ قربانی اماموں کو مخصوص کرنے کے لئے چڑھائی گئی، اور اُس کی خوشبو رب کو پسند تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","موسیٰ نے سینہ بھی لیا اور اُسے ہلانے والی قربانی کے طور پر رب کے سامنے ہلایا۔ یہ مخصوصیت کے مینڈھے میں سے موسیٰ کا حصہ تھا۔ موسیٰ نے اِس میں بھی سب کچھ رب کے حکم کے عین مطابق کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","پھر اُس نے مسح کے تیل اور قربان گاہ پر کے خون میں سے کچھ لے کر ہارون، اُس کے بیٹوں اور اُن کے کپڑوں پر چھڑک دیا۔ یوں اُس نے اُنہیں اور اُن کے کپڑوں کو مخصوص و مُقدّس کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","موسیٰ نے اُن سے کہا، ”گوشت کو ملاقات کے خیمے کے دروازے پر اُبال کر اُسے اُن روٹیوں کے ساتھ کھانا جو مخصوصیت کی قربانیوں کی ٹوکری میں پڑی ہیں۔ کیونکہ رب نے مجھے یہی حکم دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","گوشت اور روٹیوں کا بقایا جلا دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","سات دن تک ملاقات کے خیمے کے دروازے میں سے نہ نکلنا، کیونکہ مقدِس میں خدمت کے لئے تمہاری مخصوصیت کے اِتنے ہی دن ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","جو کچھ آج ہوا ہے وہ رب کے حکم کے مطابق ہوا تاکہ تمہارا کفارہ دیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","تمہیں سات رات اور دن تک خیمے کے دروازے کے اندر رہنا ہے۔ رب کی اِس ہدایت کو مانو ورنہ تم مر جاؤ گے، کیونکہ یہ حکم مجھے رب کی طرف سے دیا گیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","ہارون اور اُس کے بیٹوں نے اُن تمام ہدایات پر عمل کیا جو رب نے موسیٰ کی معرفت اُنہیں دی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","مخصوصیت کے سات دن کے بعد موسیٰ نے آٹھویں دن ہارون، اُس کے بیٹوں اور اسرائیل کے بزرگوں کو بُلایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","اُس نے ہارون سے کہا، ”ایک بےعیب بچھڑا اور ایک بےعیب مینڈھا چن کر رب کو پیش کر۔ بچھڑا گناہ کی قربانی کے لئے اور مینڈھا بھسم ہونے والی قربانی کے لئے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","پھر اسرائیلیوں کو کہہ دینا کہ گناہ کی قربانی کے لئے ایک بکرا جبکہ بھسم ہونے والی قربانی کے لئے ایک بےعیب یک سالہ بچھڑا اور ایک بےعیب یک سالہ بھیڑ کا بچہ پیش کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ساتھ ہی سلامتی کی قربانی کے لئے ایک بَیل اور ایک مینڈھا چنو۔ تیل کے ساتھ ملائی ہوئی غلہ کی نذر بھی لے کر سب کچھ رب کو پیش کرو۔ کیونکہ آج ہی رب تم پر ظاہر ہو گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","اسرائیلی موسیٰ کی مطلوبہ تمام چیزیں ملاقات کے خیمے کے سامنے لے آئے۔ پوری جماعت قریب آ کر رب کے سامنے کھڑی ہو گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","موسیٰ نے اُن سے کہا، ”تمہیں وہی کرنا ہے جس کا حکم رب نے تمہیں دیا ہے۔ کیونکہ آج ہی رب کا جلال تم پر ظاہر ہو گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","پھر اُس نے ہارون سے کہا، ”قربان گاہ کے پاس جا کر گناہ کی قربانی اور بھسم ہونے والی قربانی چڑھا کر اپنا اور اپنی قوم کا کفارہ دینا۔ رب کے حکم کے مطابق قوم کے لئے بھی قربانی پیش کرنا تاکہ اُس کا کفارہ دیا جائے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","ہارون قربان گاہ کے پاس آیا۔ اُس نے بچھڑے کو ذبح کیا۔ یہ اُس کے لئے گناہ کی قربانی تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","اُس کے بیٹے بچھڑے کا خون اُس کے پاس لے آئے۔ اُس نے اپنی اُنگلی خون میں ڈبو کر اُسے قربان گاہ کے سینگوں پر لگایا۔ باقی خون کو اُس نے قربان گاہ کے پائے پر اُنڈیل دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","پھر اُس نے اُس کی چربی، گُردوں اور جوڑ کلیجی کو قربان گاہ پر جلا دیا۔ جیسے رب نے موسیٰ کو حکم دیا تھا ویسے ہی ہارون نے کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","بچھڑے کا گوشت اور کھال اُس نے خیمہ گاہ کے باہر لے جا کر جلا دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","اِس کے بعد ہارون نے بھسم ہونے والی قربانی کو ذبح کیا۔ اُس کے بیٹوں نے اُسے اُس کا خون دیا، اور اُس نے اُسے قربان گاہ کے چار پہلوؤں پر چھڑک دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","اُنہوں نے اُسے قربانی کے مختلف ٹکڑے سر سمیت دیئے، اور اُس نے اُنہیں قربان گاہ پر جلا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","پھر اُس نے اُس کی انتڑیاں اور پنڈلیاں دھو کر بھسم ہونے والی قربانی کی باقی چیزوں پر رکھ کر جلا دیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","اب ہارون نے قوم کے لئے قربانی چڑھائی۔ اُس نے گناہ کی قربانی کے لئے بکرا ذبح کر کے اُسے پہلی قربانی کی طرح چڑھایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","اُس نے بھسم ہونے والی قربانی بھی قواعد کے مطابق چڑھائی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","اُس نے غلہ کی نذر پیش کی اور اُس میں سے مٹھی بھر قربان گاہ پر جلا دیا۔ یہ غلہ کی اُس نذر کے علاوہ تھی جو صبح کو بھسم ہونے والی قربانی کے ساتھ چڑھائی گئی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","پھر اُس نے سلامتی کی قربانی کے لئے بَیل اور مینڈھے کو ذبح کیا۔ یہ بھی قوم کے لئے تھی۔ اُس کے بیٹوں نے اُسے جانوروں کا خون دیا، اور اُس نے اُسے قربان گاہ کے چار پہلوؤں پر چھڑک دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","لیکن اُنہوں نے بَیل اور مینڈھے کو چربی، دُم، انتڑیوں پر کی چربی اور جوڑ کلیجی نکال کر ");
INSERT INTO urdgvu_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","سینے کے ٹکڑوں پر رکھ دیا۔ ہارون نے چربی کا حصہ قربان گاہ پر جلا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","سینے کے ٹکڑے اور دہنی رانیں اُس نے ہلانے والی قربانی کے طور پر رب کے سامنے ہلائیں۔ اُس نے سب کچھ موسیٰ کے حکم کے مطابق ہی کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","تمام قربانیاں پیش کرنے کے بعد ہارون نے اپنے ہاتھ اُٹھا کر قوم کو برکت دی۔ پھر وہ قربان گاہ سے اُتر کر ");
INSERT INTO urdgvu_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","موسیٰ کے ساتھ ملاقات کے خیمے میں داخل ہوا۔ جب دونوں باہر آئے تو اُنہوں نے قوم کو برکت دی۔ تب رب کا جلال پوری قوم پر ظاہر ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","رب کے حضور سے آگ نکل کر قربان گاہ پر اُتری اور بھسم ہونے والی قربانی اور چربی کے ٹکڑے بھسم کر دیئے۔ یہ دیکھ کر لوگ خوشی کے نعرے مارنے لگے اور منہ کے بل گر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","ہارون کے بیٹے ندب اور ابیہو نے اپنے اپنے بخوردان لے کر اُن میں جلتے ہوئے کوئلے ڈالے۔ اُن پر بخور ڈال کر وہ رب کے سامنے آئے تاکہ اُسے پیش کریں۔ لیکن یہ آگ ناجائز تھی۔ رب نے یہ پیش کرنے کا حکم نہیں دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","اچانک رب کے حضور سے آگ نکلی جس نے اُنہیں بھسم کر دیا۔ وہیں رب کے سامنے وہ مر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","موسیٰ نے ہارون سے کہا، ”اب وہی ہوا ہے جو رب نے فرمایا تھا کہ جو میرے قریب ہیں اُن سے مَیں اپنی قدوسیت ظاہر کروں گا، مَیں تمام قوم کے سامنے ہی اپنے جلال کا اظہار کروں گا۔“ ہارون خاموش رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","موسیٰ نے ہارون کے چچا عُزی ایل کے بیٹوں میسائیل اور اِلصَفن کو بُلا کر کہا، ”اِدھر آؤ اور اپنے رشتے داروں کو مقدِس کے سامنے سے اُٹھا کر خیمہ گاہ کے باہر لے جاؤ۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","وہ آئے اور موسیٰ کے حکم کے عین مطابق اُنہیں اُن کے زیر جاموں سمیت اُٹھا کر خیمہ گاہ کے باہر لے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","موسیٰ نے ہارون اور اُس کے دیگر بیٹوں اِلی عزر اور اِتمر سے کہا، ”ماتم کا اظہار نہ کرو۔ نہ اپنے بال بکھرنے دو، نہ اپنے کپڑے پھاڑو۔ ورنہ تم مر جاؤ گے اور رب پوری جماعت سے ناراض ہو جائے گا۔ لیکن تمہارے رشتے دار اور باقی تمام اسرائیلی ضرور اِن کا ماتم کریں جن کو رب نے آگ سے ہلاک کر دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ملاقات کے خیمے کے دروازے کے باہر نہ نکلو ورنہ تم مر جاؤ گے، کیونکہ تمہیں رب کے تیل سے مسح کیا گیا ہے۔“ چنانچہ اُنہوں نے ایسا ہی کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","رب نے ہارون سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","”جب بھی تجھے یا تیرے بیٹوں کو ملاقات کے خیمے میں داخل ہونا ہے تو مَے یا کوئی اَور نشہ آور چیز پینا منع ہے، ورنہ تم مر جاؤ گے۔ یہ اصول آنے والی نسلوں کے لئے بھی ابد تک اَن مٹ ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","یہ بھی لازم ہے کہ تم مُقدّس اور غیرمُقدّس چیزوں میں، پاک اور ناپاک چیزوں میں امتیاز کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","تمہیں اسرائیلیوں کو تمام پابندیاں سکھانی ہیں جو مَیں نے تمہیں موسیٰ کی معرفت بتائی ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","موسیٰ نے ہارون اور اُس کے بچے ہوئے بیٹوں اِلی عزر اور اِتمر سے کہا، ”غلہ کی نذر کا جو حصہ رب کے سامنے جلایا نہیں جاتا اُسے اپنے لئے لے کر بےخمیری روٹی پکانا اور قربان گاہ کے پاس ہی کھانا۔ کیونکہ وہ نہایت مُقدّس ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","اُسے مُقدّس جگہ پر کھانا، کیونکہ وہ رب کی جلنے والی قربانیوں میں سے تمہارے اور تمہارے بیٹوں کا حصہ ہے۔ کیونکہ مجھے اِس کا حکم دیا گیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","جو سینہ ہلانے والی قربانی اور دہنی ران اُٹھانے والی قربانی کے طور پر پیش کی گئی ہے، وہ تم اور تمہارے بیٹے بیٹیاں کھا سکتے ہیں۔ اُنہیں مُقدّس جگہ پر کھانا ہے۔ اسرائیلیوں کی سلامتی کی قربانیوں میں سے یہ ٹکڑے تمہارا حصہ ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","لیکن پہلے امام ران اور سینے کو جلنے والی قربانیوں کی چربی کے ساتھ پیش کریں۔ وہ اُنہیں ہلانے والی قربانی کے طور پر رب کے سامنے ہلائیں۔ رب فرماتا ہے کہ یہ ٹکڑے ابد تک تمہارے اور تمہارے بیٹوں کا حصہ ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","موسیٰ نے دریافت کیا کہ اُس بکرے کے گوشت کا کیا ہوا جو گناہ کی قربانی کے طور پر چڑھایا گیا تھا۔ اُسے پتا چلا کہ وہ بھی جل گیا تھا۔ یہ سن کر اُسے ہارون کے بیٹوں اِلی عزر اور اِتمر پر غصہ آیا۔ اُس نے پوچھا، ");
INSERT INTO urdgvu_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","”تم نے گناہ کی قربانی کا گوشت کیوں نہیں کھایا؟ تمہیں اُسے مُقدّس جگہ پر کھانا تھا۔ یہ ایک نہایت مُقدّس حصہ ہے جو رب نے تمہیں دیا تاکہ تم جماعت کا قصور دُور کر کے رب کے سامنے لوگوں کا کفارہ دو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","چونکہ اِس بکرے کا خون مقدِس میں نہ لایا گیا اِس لئے تمہیں اُس کا گوشت مقدِس میں کھانا تھا جس طرح مَیں نے تمہیں حکم دیا تھا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","ہارون نے موسیٰ کو جواب دے کر کہا، ”دیکھیں، آج لوگوں نے اپنے لئے گناہ کی قربانی اور بھسم ہونے والی قربانی رب کو پیش کی ہے جبکہ مجھ پر یہ آفت گزری ہے۔ اگر مَیں آج گناہ کی قربانی سے کھاتا تو کیا یہ رب کو اچھا لگتا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","یہ بات موسیٰ کو اچھی لگی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","رب نے موسیٰ اور ہارون سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","”اسرائیلیوں کو بتانا کہ تمہیں زمین پر رہنے والے جانوروں میں سے ذیل کے جانوروں کو کھانے کی اجازت ہے: ");
INSERT INTO urdgvu_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","جن کے کُھر یا پاؤں بالکل چِرے ہوئے ہیں اور جو جگالی کرتے ہیں اُنہیں کھانے کی اجازت ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_4‏","004_11_4‏","LEV","11","4‏","6","اونٹ، بِجُو یا خرگوش کھانا منع ہے۔ وہ تمہارے لئے ناپاک ہیں، کیونکہ وہ جگالی تو کرتے ہیں لیکن اُن کے کُھر یا پاؤں چِرے ہوئے نہیں ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","سؤر نہ کھانا۔ وہ تمہارے لئے ناپاک ہے، کیونکہ اُس کے کُھر تو چِرے ہوئے ہیں لیکن وہ جگالی نہیں کرتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","نہ اُن کا گوشت کھانا، نہ اُن کی لاشوں کو چھونا۔ وہ تمہارے لئے ناپاک ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","سمندری اور دریائی جانور کھانے کے لئے جائز ہیں اگر اُن کے پَر اور چھلکے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","لیکن جن کے پَر یا چھلکے نہیں ہیں وہ سب تمہارے لئے مکروہ ہیں، خواہ وہ بڑی تعداد میں مل کر رہتے ہیں یا نہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","اِس لئے اُن کا گوشت کھانا منع ہے، اور اُن کی لاشوں سے بھی گھن کھانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","پانی میں رہنے والے تمام جانور جن کے پَر یا چھلکے نہ ہوں تمہارے لئے مکروہ ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","ذیل کے پرندے تمہارے لئے قابلِ گھن ہوں۔ اِنہیں کھانا منع ہے، کیونکہ وہ مکروہ ہیں: عقاب، دڑھیَل گِدھ، کالا گِدھ، ");
INSERT INTO urdgvu_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","لال چیل، ہر قسم کی کالی چیل، ");
INSERT INTO urdgvu_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ہر قسم کا کوّا، ");
INSERT INTO urdgvu_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","عقابی اُلّو، چھوٹے کان والا اُلّو، بڑے کان والا اُلّو، ہر قسم کا باز، ");
INSERT INTO urdgvu_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","چھوٹا اُلّو، قوق، چنگھاڑنے والا اُلّو، ");
INSERT INTO urdgvu_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","سفید اُلّو، دشتی اُلّو، مصری گِدھ، ");
INSERT INTO urdgvu_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","لق لق، ہر قسم کا بُوتیمار، ہُد ہُد اور چمگادڑ۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","تمام پَر رکھنے والے کیڑے جو چار پاؤں پر چلتے ہیں تمہارے لئے مکروہ ہیں، ");
INSERT INTO urdgvu_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","سوائے اُن کے جن کی ٹانگوں کے دو حصے ہیں اور جو پُھدکتے ہیں۔ اُن کو تم کھا سکتے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","اِس ناتے سے تم مختلف قسم کے ٹڈے کھا سکتے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","باقی سب پَر رکھنے والے کیڑے جو چار پاؤں پر چلتے ہیں تمہارے لئے مکروہ ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_24‏","004_11_24‏","LEV","11","24‏","28","جو بھی ذیل کے جانوروں کی لاشیں چھوئے وہ شام تک ناپاک رہے گا: (الف) کُھر رکھنے والے تمام جانور سوائے اُن کے جن کے کُھر یا پاؤں پورے طور پر چِرے ہوئے ہیں اور جو جگالی کرتے ہیں، (ب) تمام جانور جو اپنے چار پنجوں پر چلتے ہیں۔ یہ جانور تمہارے لئے ناپاک ہیں، اور جو بھی اُن کی لاشیں اُٹھائے یا چھوئے لازم ہے کہ وہ اپنے کپڑے دھو لے۔ اِس کے باوجود بھی وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_29‏","004_11_29‏","LEV","11","29‏","30","زمین پر رینگنے والے جانوروں میں سے چھچھوندر، مختلف قسم کے چوہے اور مختلف قسم کی چھپکلیاں تمہارے لئے ناپاک ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","جو بھی اُنہیں اور اُن کی لاشیں چھو لیتا ہے وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","اگر اُن میں سے کسی کی لاش کسی چیز پر گر پڑے تو وہ بھی ناپاک ہو جائے گی۔ اِس سے کوئی فرق نہیں پڑتا کہ وہ لکڑی، کپڑے، چمڑے یا ٹاٹ کی بنی ہو، نہ اِس سے کوئی فرق پڑتا ہے کہ وہ کس کام کے لئے استعمال کی جاتی ہے۔ اُسے ہر صورت میں پانی میں ڈبونا ہے۔ توبھی وہ شام تک ناپاک رہے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","اگر ایسی لاش مٹی کے برتن میں گر جائے تو جو کچھ بھی اُس میں ہے ناپاک ہو جائے گا اور تمہیں اُس برتن کو توڑنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ہر کھانے والی چیز جس پر ایسے برتن کا پانی ڈالا گیا ہے ناپاک ہے۔ اِسی طرح اُس برتن سے نکلی ہوئی ہر پینے والی چیز ناپاک ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","جس پر بھی ایسی لاش گر پڑے وہ ناپاک ہو جاتا ہے۔ اگر وہ تنور یا چولھے پر گر پڑے تو اُن کو توڑ دینا ہے۔ وہ ناپاک ہیں اور تمہارے لئے ناپاک رہیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","لیکن جس چشمے یا حوض میں ایسی لاش گرے وہ پاک رہتا ہے۔ صرف وہ جو لاش کو چھو لیتا ہے ناپاک ہو جاتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","اگر ایسی لاش بیجوں پر گر پڑے جن کو ابھی بونا ہے تو وہ پاک رہتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","لیکن اگر بیجوں پر پانی ڈالا گیا ہو اور پھر لاش اُن پر گر پڑے تو وہ ناپاک ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","اگر ایسا جانور جسے کھانے کی اجازت ہے مر جائے تو جو بھی اُس کی لاش چھوئے شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","جو اُس میں سے کچھ کھائے یا اُسے اُٹھا کر لے جائے اُسے اپنے کپڑوں کو دھونا ہے۔ توبھی وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","ہر جانور جو زمین پر رینگتا ہے قابلِ گھن ہے۔ اُسے کھانا منع ہے، ");
INSERT INTO urdgvu_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","چاہے وہ اپنے پیٹ پر چاہے چار یا اِس سے زائد پاؤں پر چلتا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","اِن تمام رینگنے والوں سے اپنے آپ کو گھن کا باعث اور ناپاک نہ بنانا، ");
INSERT INTO urdgvu_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","کیونکہ مَیں رب تمہارا خدا ہوں۔ لازم ہے کہ تم اپنے آپ کو مخصوص و مُقدّس رکھو، کیونکہ مَیں قدوس ہوں۔ اپنے آپ کو زمین پر رینگنے والے تمام جانوروں سے ناپاک نہ بنانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","مَیں رب ہوں۔ مَیں تمہیں مصر سے نکال لایا ہوں تاکہ تمہارا خدا بنوں۔ لہٰذا مُقدّس رہو، کیونکہ مَیں قدوس ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","زمین پر چلنے والے جانوروں، پرندوں، آبی جانوروں اور زمین پر رینگنے والے جانوروں کے بارے میں شرع یہی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","لازم ہے کہ تم ناپاک اور پاک میں امتیاز کرو، ایسے جانوروں میں جو کھانے کے لئے جائز ہیں اور ایسوں میں جو ناجائز ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","”اسرائیلیوں کو بتا کہ جب کسی عورت کے لڑکا پیدا ہو تو وہ ماہواری کے ایام کی طرح سات دن تک ناپاک رہے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","آٹھویں دن لڑکے کا ختنہ کروانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","پھر ماں مزید 33 دن انتظار کرے۔ اِس کے بعد اُس کی وہ ناپاکی دُور ہو جائے گی جو خون بہنے سے پیدا ہوئی ہے۔ اِس دوران وہ کوئی مخصوص اور مُقدّس چیز نہ چھوئے، نہ مقدِس کے پاس جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","اگر اُس کے لڑکی پیدا ہو جائے تو وہ ماہواری کے ایام کی طرح ناپاک ہے۔ یہ ناپاکی 14 دن تک رہے گی۔ پھر وہ مزید 66 دن انتظار کرے۔ اِس کے بعد اُس کی وہ ناپاکی دُور ہو جائے گی جو خون بہنے سے پیدا ہوئی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","جب لڑکے یا لڑکی کے سلسلے میں یہ دن گزر جائیں تو وہ ملاقات کے خیمے کے دروازے پر امام کو ذیل کی چیزیں دے: بھسم ہونے والی قربانی کے لئے ایک یک سالہ بھیڑ کا بچہ اور گناہ کی قربانی کے لئے ایک جوان کبوتر یا قمری۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","امام یہ جانور رب کو پیش کر کے اُس کا کفارہ دے۔ پھر خون بہنے کے باعث پیدا ہونے والی ناپاکی دُور ہو جائے گی۔ اصول ایک ہی ہے، چاہے لڑکا ہو یا لڑکی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","اگر وہ غربت کے باعث بھیڑ کا بچہ نہ دے سکے تو پھر وہ دو قمریاں یا دو جوان کبوتر لے آئے، ایک بھسم ہونے والی قربانی کے لئے اور دوسرا گناہ کی قربانی کے لئے۔ یوں امام اُس کا کفارہ دے اور وہ پاک ہو جائے گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","رب نے موسیٰ اور ہارون سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","”اگر کسی کی جِلد میں سوجن یا پپڑی یا سفید داغ ہو اور خطرہ ہے کہ وبائی جِلدی بیماری ہو تو اُسے اماموں یعنی ہارون یا اُس کے بیٹوں کے پاس لے آنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","امام اُس جگہ کا معائنہ کرے۔ اگر اُس کے بال سفید ہو گئے ہوں اور وہ جِلد میں دھنسی ہوئی ہو تو وبائی بیماری ہے۔ جب امام کو یہ معلوم ہو تو وہ اُسے ناپاک قرار دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","لیکن ہو سکتا ہے کہ جِلد کی جگہ سفید تو ہے لیکن جِلد میں دھنسی ہوئی نہیں ہے، نہ اُس کے بال سفید ہوئے ہیں۔ اِس صورت میں امام اُس شخص کو سات دن کے لئے علیٰحدگی میں رکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ساتویں دن امام دوبارہ اُس کا معائنہ کرے۔ اگر وہ دیکھے کہ متاثرہ جگہ ویسی ہی ہے اور پھیلی نہیں تو وہ اُسے مزید سات دن علیٰحدگی میں رکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ساتویں دن وہ ایک اَور مرتبہ اُس کا معائنہ کرے۔ اگر اُس جگہ کا رنگ دوبارہ صحت مند جِلد کے رنگ کی مانند ہو رہا ہو اور پھیلی نہ ہو تو وہ اُسے پاک قرار دے۔ اِس کا مطلب ہے کہ یہ مرض عام پپڑی سے زیادہ نہیں ہے۔ مریض اپنے کپڑے دھو لے تو وہ پاک ہو جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","لیکن اگر اِس کے بعد متاثرہ جگہ پھیلنے لگے تو وہ دوبارہ اپنے آپ کو امام کو دکھائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","امام اُس کا معائنہ کرے۔ اگر جگہ واقعی پھیل گئی ہو تو امام اُسے ناپاک قرار دے، کیونکہ یہ وبائی جِلدی مرض ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","اگر کسی کے جسم پر وبائی جِلدی مرض نظر آئے تو اُسے امام کے پاس لایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","امام اُس کا معائنہ کرے۔ اگر متاثرہ جِلد میں سفید سوجن ہو، اُس کے بال بھی سفید ہو گئے ہوں، اور اُس میں کچا گوشت موجود ہو ");
INSERT INTO urdgvu_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","تو اِس کا مطلب ہے کہ وبائی جِلدی بیماری پرانی ہے۔ امام اُس شخص کو سات دن کے لئے علیٰحدگی میں رکھ کر انتظار نہ کرے بلکہ اُسے فوراً ناپاک قرار دے، کیونکہ یہ اُس کی ناپاکی کا ثبوت ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","لیکن اگر بیماری جلدی سے پھیل گئی ہو، یہاں تک کہ سر سے لے کر پاؤں تک پوری جِلد متاثر ہوئی ہو ");
INSERT INTO urdgvu_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","تو امام یہ دیکھ کر مریض کو پاک قرار دے۔ چونکہ پوری جِلد سفید ہو گئی ہے اِس لئے وہ پاک ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","لیکن جب بھی کہیں کچا گوشت نظر آئے اُس وقت وہ ناپاک ہو جاتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","امام یہ دیکھ کر مریض کو ناپاک قرار دے۔ کچا گوشت ہر صورت میں ناپاک ہے، کیونکہ اِس کا مطلب ہے کہ وبائی جِلدی بیماری لگ گئی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","اگر کچے گوشت کا یہ زخم بھر جائے اور متاثرہ جگہ کی جِلد سفید ہو جائے تو مریض امام کے پاس جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","اگر امام دیکھے کہ واقعی ایسا ہی ہوا ہے اور متاثرہ جِلد سفید ہو گئی ہے تو وہ اُسے پاک قرار دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","اگر کسی کی جِلد پر پھوڑا ہو لیکن وہ ٹھیک ہو جائے ");
INSERT INTO urdgvu_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","اور اُس کی جگہ سفید سوجن یا سرخی مائل سفید داغ نظر آئے تو مریض اپنے آپ کو امام کو دکھائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","اگر وہ اُس کا معائنہ کر کے دیکھے کہ متاثرہ جگہ جِلد کے اندر دھنسی ہوئی ہے اور اُس کے بال سفید ہو گئے ہیں تو وہ مریض کو ناپاک قرار دے۔ کیونکہ اِس کا مطلب ہے کہ جہاں پہلے پھوڑا تھا وہاں وبائی جِلدی بیماری پیدا ہو گئی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","لیکن اگر امام دیکھے کہ متاثرہ جگہ کے بال سفید نہیں ہیں، وہ جِلد میں دھنسی ہوئی نظر نہیں آتی اور اُس کا رنگ دوبارہ صحت مند جِلد کی مانند ہو رہا ہے تو وہ اُسے سات دن کے لئے علیٰحدگی میں رکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","اگر اِس دوران بیماری مزید پھیل جائے تو امام مریض کو ناپاک قرار دے، کیونکہ اِس کا مطلب ہے کہ وبائی جِلدی بیماری لگ گئی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","لیکن اگر داغ نہ پھیلے تو اِس کا مطلب ہے کہ یہ صرف اُس بھرے ہوئے زخم کا نشان ہے جو پھوڑے سے پیدا ہوا تھا۔ امام مریض کو پاک قرار دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","اگر کسی کی جِلد پر جلنے کا زخم لگ جائے اور متاثرہ جگہ پر سرخی مائل سفید داغ یا سفید داغ پیدا ہو جائے ");
INSERT INTO urdgvu_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","تو امام متاثرہ جگہ کا معائنہ کرے۔ اگر معلوم ہو جائے کہ متاثرہ جگہ کے بال سفید ہو گئے ہیں اور وہ جِلد میں دھنسی ہوئی ہے تو اِس کا مطلب ہے کہ چوٹ کی جگہ پر وبائی جِلدی مرض لگ گیا ہے۔ امام اُسے ناپاک قرار دے، کیونکہ وبائی جِلدی بیماری لگ گئی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","لیکن اگر امام نے معلوم کیا ہے کہ داغ میں بال سفید نہیں ہیں، وہ جِلد میں دھنسا ہوا نظر نہیں آتا اور اُس کا رنگ صحت مند جِلد کی مانند ہو رہا ہے تو وہ مریض کو سات دن تک علیٰحدگی میں رکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","اگر وہ ساتویں دن معلوم کرے کہ متاثرہ جگہ پھیل گئی ہے تو وہ اُسے ناپاک قرار دے۔ کیونکہ اِس کا مطلب ہے کہ وبائی جِلدی بیماری لگ گئی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","لیکن اگر داغ پھیلا ہوا نظر نہیں آتا اور متاثرہ جِلد کا رنگ صحت مند جِلد کے رنگ کی مانند ہو گیا ہے تو اِس کا مطلب ہے کہ یہ صرف اُس بھرے ہوئے زخم کا نشان ہے جو جلنے سے پیدا ہوا تھا۔ امام مریض کو پاک قرار دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","اگر کسی کے سر یا داڑھی کی جِلد میں نشان نظر آئے ");
INSERT INTO urdgvu_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","تو امام متاثرہ جگہ کا معائنہ کرے۔ اگر وہ دھنسی ہوئی نظر آئے اور اُس کے بال رنگ کے لحاظ سے چمکتے ہوئے سونے کی مانند اور باریک ہوں تو امام مریض کو ناپاک قرار دے۔ اِس کا مطلب ہے کہ ایسی وبائی جِلدی بیماری سر یا داڑھی کی جِلد پر لگ گئی ہے جو خارش پیدا کرتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","لیکن اگر امام نے معلوم کیا کہ متاثرہ جگہ جِلد میں دھنسی ہوئی نظر نہیں آتی اگرچہ اُس کے بالوں کا رنگ بدل گیا ہے تو وہ اُسے سات دن کے لئے علیٰحدگی میں رکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ساتویں دن امام جِلد کی متاثرہ جگہ کا معائنہ کرے۔ اگر وہ پھیلی ہوئی نظر نہیں آتی اور اُس کے بالوں کا رنگ چمک دار سونے کی مانند نہیں ہے، ساتھ ہی وہ جگہ جِلد میں دھنسی ہوئی بھی دکھائی نہیں دیتی، ");
INSERT INTO urdgvu_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","تو مریض اپنے بال منڈوائے۔ صرف وہ بال رہ جائیں جو متاثرہ جگہ سے نکلتے ہیں۔ امام مریض کو مزید سات دن علیٰحدگی میں رکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ساتویں دن وہ اُس کا معائنہ کرے۔ اگر متاثرہ جگہ نہیں پھیلی اور وہ جِلد میں دھنسی ہوئی نظر نہیں آتی تو امام اُسے پاک قرار دے۔ وہ اپنے کپڑے دھو لے تو وہ پاک ہو جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","لیکن اگر اِس کے بعد جِلد کی متاثرہ جگہ پھیلنا شروع ہو جائے ");
INSERT INTO urdgvu_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","تو امام دوبارہ اُس کا معائنہ کرے۔ اگر وہ جگہ واقعی پھیلی ہوئی نظر آئے تو مریض ناپاک ہے، چاہے متاثرہ جگہ کے بالوں کا رنگ چمکتے سونے کی مانند ہو یا نہ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","لیکن اگر اُس کے خیال میں متاثرہ جگہ پھیلی ہوئی نظر نہیں آتی بلکہ اُس میں سے کالے رنگ کے بال نکل رہے ہیں تو اِس کا مطلب ہے کہ مریض کی صحت بحال ہو گئی ہے۔ امام اُسے پاک قرار دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","اگر کسی مرد یا عورت کی جِلد پر سفید داغ پیدا ہو جائیں ");
INSERT INTO urdgvu_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","تو امام اُن کا معائنہ کرے۔ اگر اُن کا سفید رنگ ہلکا سا ہو تو یہ صرف بےضرر پپڑی ہے۔ مریض پاک ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_40‏","004_13_40‏","LEV","13","40‏","41","اگر کسی مرد کا سر ماتھے کی طرف یا پیچھے کی طرف گنجا ہے تو وہ پاک ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","لیکن اگر اُس جگہ جہاں وہ گنجا ہے سرخی مائل سفید داغ ہو تو اِس کا مطلب ہے کہ وہاں وبائی جِلدی بیماری لگ گئی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","امام اُس کا معائنہ کرے۔ اگر گنجی جگہ پر سرخی مائل سفید سوجن ہو جو وبائی جِلدی بیماری کی مانند نظر آئے ");
INSERT INTO urdgvu_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","تو مریض کو وبائی جِلدی بیماری لگ گئی ہے۔ امام اُسے ناپاک قرار دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","وبائی جِلدی بیماری کا مریض پھٹے کپڑے پہنے۔ اُس کے بال بکھرے رہیں۔ وہ اپنی مونچھوں کو کسی کپڑے سے چھپائے اور پکارتا رہے، ’ناپاک، ناپاک۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","جس وقت تک وبائی جِلدی بیماری لگی رہے وہ ناپاک ہے۔ وہ اِس دوران خیمہ گاہ کے باہر جا کر تنہائی میں رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","ہو سکتا ہے کہ اُون یا کتان کے کسی لباس پر پھپھوندی لگ گئی ہے، ");
INSERT INTO urdgvu_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","یا کہ پھپھوندی اُون یا کتان کے کسی کپڑے کے ٹکڑے یا کسی چمڑے یا چمڑے کی کسی چیز پر لگ گئی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","اگر پھپھوندی کا رنگ ہرا یا لال سا ہو تو وہ پھیلنے والی پھپھوندی ہے، اور لازم ہے کہ اُسے امام کو دکھایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","امام اُس کا معائنہ کر کے اُسے سات دن کے لئے علیٰحدگی میں رکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ساتویں دن وہ دوبارہ اُس کا معائنہ کرے۔ اگر پھپھوندی پھیل گئی ہو تو اِس کا مطلب ہے کہ وہ نقصان دہ ہے۔ متاثرہ چیز ناپاک ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","امام اُسے جلا دے، کیونکہ یہ پھپھوندی نقصان دہ ہے۔ لازم ہے کہ اُسے جلا دیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","لیکن اگر اِن سات دنوں کے بعد پھپھوندی پھیلی ہوئی نظر نہیں آتی ");
INSERT INTO urdgvu_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","تو امام حکم دے کہ متاثرہ چیز کو دُھلوایا جائے۔ پھر وہ اُسے مزید سات دن کے لئے علیٰحدگی میں رکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","اِس کے بعد وہ دوبارہ اُس کا معائنہ کرے۔ اگر وہ معلوم کرے کہ پھپھوندی تو پھیلی ہوئی نظر نہیں آتی لیکن اُس کا رنگ ویسے کا ویسا ہے تو وہ ناپاک ہے۔ اُسے جلا دینا، چاہے پھپھوندی متاثرہ چیز کے سامنے والے حصے یا پچھلے حصے میں لگی ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","لیکن اگر معلوم ہو جائے کہ پھپھوندی کا رنگ ماند پڑ گیا ہے تو امام کپڑے یا چمڑے میں سے متاثرہ جگہ پھاڑ کر نکال دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","توبھی ہو سکتا ہے کہ پھپھوندی دوبارہ اُسی کپڑے یا چمڑے پر نظر آئے۔ اِس کا مطلب ہے کہ وہ پھیل رہی ہے اور اُسے جلا دینا لازم ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","لیکن اگر پھپھوندی دھونے کے بعد غائب ہو جائے تو اُسے ایک اَور دفعہ دھونا ہے۔ پھر متاثرہ چیز پاک ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","اِسی طرح پھپھوندی سے نپٹنا ہے، چاہے وہ اُون یا کتان کے کسی لباس کو لگ گئی ہو، چاہے اُون یا کتان کے کسی ٹکڑے یا چمڑے کی کسی چیز کو لگ گئی ہو۔ اِن ہی اصولوں کے تحت فیصلہ کرنا ہے کہ متاثرہ چیز پاک ہے یا ناپاک۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","”اگر کوئی شخص جِلدی بیماری سے شفا پائے اور اُسے پاک صاف کرانا ہے تو اُسے امام کے پاس لایا جائے ");
INSERT INTO urdgvu_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","جو خیمہ گاہ کے باہر جا کر اُس کا معائنہ کرے۔ اگر وہ دیکھے کہ مریض کی صحت واقعی بحال ہو گئی ہے ");
INSERT INTO urdgvu_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","تو امام اُس کے لئے دو زندہ اور پاک پرندے، دیودار کی لکڑی، قرمزی رنگ کا دھاگا اور زوفا منگوائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","امام کے حکم پر پرندوں میں سے ایک کو تازہ پانی سے بھرے ہوئے مٹی کے برتن کے اوپر ذبح کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","امام زندہ پرندے کو دیودار کی لکڑی، قرمزی رنگ کے دھاگے اور زوفا کے ساتھ ذبح کئے گئے پرندے کے اُس خون میں ڈبو دے جو مٹی کے برتن کے پانی میں آ گیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","وہ پانی سے ملایا ہوا خون سات بار پاک ہونے والے شخص پر چھڑک کر اُسے پاک قرار دے، پھر زندہ پرندے کو کھلے میدان میں چھوڑ دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","جو اپنے آپ کو پاک صاف کرا رہا ہے وہ اپنے کپڑے دھوئے، اپنے تمام بال منڈوائے اور نہا لے۔ اِس کے بعد وہ پاک ہے۔ اب وہ خیمہ گاہ میں داخل ہو سکتا ہے اگرچہ وہ مزید سات دن اپنے ڈیرے میں نہیں جا سکتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ساتویں دن وہ دوبارہ اپنے سر کے بال، اپنی داڑھی، اپنے ابرو اور باقی تمام بال منڈوائے۔ وہ اپنے کپڑے دھوئے اور نہا لے۔ تب وہ پاک ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","آٹھویں دن وہ دو بھیڑ کے نر بچے اور ایک یک سالہ بھیڑ چن لے جو بےعیب ہوں۔ ساتھ ہی وہ غلہ کی نذر کے لئے تیل کے ساتھ ملایا گیا ساڑھے 4 کلو گرام بہترین میدہ اور 300 ملی لٹر تیل لے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","پھر جس امام نے اُسے پاک قرار دیا وہ اُسے اِن قربانیوں سمیت ملاقات کے خیمے کے دروازے پر رب کو پیش کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","بھیڑ کا ایک نر بچہ اور 300 ملی لٹر تیل قصور کی قربانی کے لئے ہے۔ امام اُنہیں ہلانے والی قربانی کے طور پر رب کے سامنے ہلائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","پھر وہ بھیڑ کے اِس بچے کو خیمے کے دروازے پر ذبح کرے جہاں گناہ کی قربانیاں اور بھسم ہونے والی قربانیاں ذبح کی جاتی ہیں۔ گناہ کی قربانیوں کی طرح قصور کی یہ قربانی امام کا حصہ ہے اور نہایت مُقدّس ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","امام خون میں سے کچھ لے کر پاک ہونے والے کے دہنے کان کی لَو پر اور اُس کے دہنے ہاتھ اور دہنے پاؤں کے انگوٹھوں پر لگائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","اب وہ 300 ملی لٹر تیل میں سے کچھ لے کر اپنے بائیں ہاتھ کی ہتھیلی پر ڈالے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","اپنے دہنے ہاتھ کے انگوٹھے کے ساتھ والی اُنگلی اِس تیل میں ڈبو کر وہ اُسے سات بار رب کے سامنے چھڑکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","وہ اپنی ہتھیلی پر کے تیل میں سے کچھ اَور لے کر پاک ہونے والے کے دہنے کان کی لَو پر اور اُس کے دہنے ہاتھ اور دہنے پاؤں کے انگوٹھوں پر لگا دے یعنی اُن جگہوں پر جہاں وہ قصور کی قربانی کا خون لگا چکا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","امام اپنی ہتھیلی پر کا باقی تیل پاک ہونے والے کے سر پر ڈال کر رب کے سامنے اُس کا کفارہ دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","اِس کے بعد امام گناہ کی قربانی چڑھا کر پاک ہونے والے کا کفارہ دے۔ آخر میں وہ بھسم ہونے والی قربانی کا جانور ذبح کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","وہ اُسے غلہ کی نذر کے ساتھ قربان گاہ پر چڑھا کر اُس کا کفارہ دے۔ تب وہ پاک ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","اگر شفایاب شخص غربت کے باعث یہ قربانیاں نہیں چڑھا سکتا تو پھر وہ قصور کی قربانی کے لئے بھیڑ کا صرف ایک نر بچہ لے آئے۔ کافی ہے کہ کفارہ دینے کے لئے یہی رب کے سامنے ہلایا جائے۔ ساتھ ساتھ غلہ کی نذر کے لئے ڈیڑھ کلو گرام بہترین میدہ تیل کے ساتھ ملا کر پیش کیا جائے اور 300 ملی لٹر تیل۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","اِس کے علاوہ وہ دو قمریاں یا دو جوان کبوتر پیش کرے، ایک کو گناہ کی قربانی کے لئے اور دوسرے کو بھسم ہونے والی قربانی کے لئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","آٹھویں دن وہ اُنہیں ملاقات کے خیمے کے دروازے پر امام کے پاس اور رب کے سامنے لے آئے تاکہ وہ پاک صاف ہو جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","امام بھیڑ کے بچے کو 300 ملی لٹر تیل سمیت لے کر ہلانے والی قربانی کے طور پر رب کے سامنے ہلائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","وہ قصور کی قربانی کے لئے بھیڑ کے بچے کو ذبح کرے اور اُس کے خون میں سے کچھ لے کر پاک ہونے والے کے دہنے کان کی لَو پر اور اُس کے دہنے ہاتھ اور دہنے پاؤں کے انگوٹھوں پر لگائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","اب وہ 300 ملی لٹر تیل میں سے کچھ اپنے بائیں ہاتھ کی ہتھیلی پر ڈالے ");
INSERT INTO urdgvu_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","اور اپنے دہنے ہاتھ کے انگوٹھے کے ساتھ والی اُنگلی اِس تیل میں ڈبو کر اُسے سات بار رب کے سامنے چھڑک دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","وہ اپنی ہتھیلی پر کے تیل میں سے کچھ اَور لے کر پاک ہونے والے کے دہنے کان کی لَو پر اور اُس کے دہنے ہاتھ اور دہنے پاؤں کے انگوٹھوں پر لگا دے یعنی اُن جگہوں پر جہاں وہ قصور کی قربانی کا خون لگا چکا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","اپنی ہتھیلی پر کا باقی تیل وہ پاک ہونے والے کے سر پر ڈال دے تاکہ رب کے سامنے اُس کا کفارہ دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","اِس کے بعد وہ شفایاب شخص کی گنجائش کے مطابق دو قمریاں یا دو جوان کبوتر چڑھائے، ");
INSERT INTO urdgvu_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ایک کو گناہ کی قربانی کے لئے اور دوسرے کو بھسم ہونے والی قربانی کے لئے۔ ساتھ ہی وہ غلہ کی نذر پیش کرے۔ یوں امام رب کے سامنے اُس کا کفارہ دیتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","یہ اصول ایسے شخص کے لئے ہے جو وبائی جِلدی بیماری سے شفا پا گیا ہے لیکن اپنی غربت کے باعث پاک ہو جانے کے لئے پوری قربانی پیش نہیں کر سکتا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","رب نے موسیٰ اور ہارون سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","”جب تم ملکِ کنعان میں داخل ہو گے جو مَیں تمہیں دوں گا تو وہاں ایسے مکان ہوں گے جن میں مَیں نے پھپھوندی پھیلنے دی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ایسے گھر کا مالک جا کر امام کو بتائے کہ مَیں نے اپنے گھر میں پھپھوندی جیسی کوئی چیز دیکھی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","تب امام حکم دے کہ گھر کا معائنہ کرنے سے پہلے گھر کا پورا سامان نکالا جائے۔ ورنہ اگر گھر کو ناپاک قرار دیا جائے تو سامان کو بھی ناپاک قرار دیا جائے گا۔ اِس کے بعد امام اندر جا کر مکان کا معائنہ کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","وہ دیواروں کے ساتھ لگی ہوئی پھپھوندی کا معائنہ کرے۔ اگر متاثرہ جگہیں ہری یا لال سی ہوں اور دیوار کے اندر دھنسی ہوئی نظر آئیں ");
INSERT INTO urdgvu_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","تو پھر امام گھر سے نکل کر سات دن کے لئے تالا لگائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ساتویں دن وہ واپس آ کر مکان کا معائنہ کرے۔ اگر پھپھوندی پھیلی ہوئی نظر آئے ");
INSERT INTO urdgvu_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","تو وہ حکم دے کہ متاثرہ پتھروں کو نکال کر آبادی کے باہر کسی ناپاک جگہ پر پھینکا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","نیز وہ حکم دے کہ اندر کی دیواروں کو کُریدا جائے اور کُریدی ہوئی مٹی کو آبادی کے باہر کسی ناپاک جگہ پر پھینکا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","پھر لوگ نئے پتھر لگا کر گھر کونئے گارے سے پلستر کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","لیکن اگر اِس کے باوجود پھپھوندی دوبارہ پیدا ہو جائے ");
INSERT INTO urdgvu_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","تو امام آ کر دوبارہ اُس کا معائنہ کرے۔ اگر وہ دیکھے کہ پھپھوندی گھر میں پھیل گئی ہے تو اِس کا مطلب ہے کہ پھپھوندی نقصان دہ ہے، اِس لئے گھر ناپاک ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","لازم ہے کہ اُسے پورے طور پر ڈھا دیا جائے اور سب کچھ یعنی اُس کے پتھر، لکڑی اور پلستر کو آبادی کے باہر کسی ناپاک جگہ پر پھینکا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","اگر امام نے کسی گھر کا معائنہ کر کے تالا لگا دیا ہے اور پھر بھی کوئی اُس گھر میں داخل ہو جائے تو وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","جو ایسے گھر میں سوئے یا کھانا کھائے لازم ہے کہ وہ اپنے کپڑے دھو لے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","لیکن اگر گھر کو نئے سرے سے پلستر کرنے کے بعد امام آ کر اُس کا دوبارہ معائنہ کرے اور دیکھے کہ پھپھوندی دوبارہ نہیں نکلی تو اِس کا مطلب ہے کہ پھپھوندی ختم ہو گئی ہے۔ وہ اُسے پاک قرار دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","اُسے گناہ سے پاک صاف کرانے کے لئے وہ دو پرندے، دیودار کی لکڑی، قرمزی رنگ کا دھاگا اور زوفا لے لے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","وہ پرندوں میں سے ایک کو تازہ پانی سے بھرے ہوئے مٹی کے برتن کے اوپر ذبح کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","اِس کے بعد وہ دیودار کی لکڑی، زوفا، قرمزی رنگ کا دھاگا اور زندہ پرندہ لے کر اُس تازہ پانی میں ڈبو دے جس کے ساتھ ذبح کئے ہوئے پرندے کا خون ملایا گیا ہے اور اِس پانی کو سات بار گھر پر چھڑک دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","اِن چیزوں سے وہ گھر کو گناہ سے پاک صاف کرتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","آخر میں وہ زندہ پرندے کو آبادی کے باہر کھلے میدان میں چھوڑ دے۔ یوں وہ گھر کا کفارہ دے گا، اور وہ پاک صاف ہو جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_54‏","004_14_54‏","LEV","14","54‏","56","لازم ہے کہ ہر قسم کی وبائی بیماری سے ایسے نپٹو جیسے بیان کیا گیا ہے، چاہے وہ وبائی جِلدی بیماریاں ہوں (مثلاً خارش، سوجن، پپڑی یا سفید داغ)، چاہے کپڑوں یا گھروں میں پھپھوندی ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","اِن اصولوں کے تحت فیصلہ کرنا ہے کہ کوئی شخص یا چیز پاک ہے یا ناپاک۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","رب نے موسیٰ اور ہارون سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","”اسرائیلیوں کو بتانا کہ اگر کسی مرد کو جریان کا مرض ہو تو وہ خارج ہونے والے مائع کے سبب سے ناپاک ہے، ");
INSERT INTO urdgvu_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","چاہے مائع بہتا رہتا ہو یا رُک گیا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","جس چیز پر بھی مریض لیٹتا یا بیٹھتا ہے وہ ناپاک ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_5‏","004_15_5‏","LEV","15","5‏","6","جو بھی اُس کے لیٹنے کی جگہ کو چھوئے یا اُس کے بیٹھنے کی جگہ پر بیٹھ جائے وہ اپنے کپڑے دھو کر نہا لے۔ وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","اِسی طرح جو بھی ایسے مریض کو چھوئے وہ اپنے کپڑے دھو کر نہا لے۔ وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","اگر مریض کسی پاک شخص پر تھوکے تو یہی کچھ کرنا ہے اور وہ شخص شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","جب ایسا مریض کسی جانور پر سوار ہوتا ہے تو ہر چیز جس پر وہ بیٹھ جاتا ہے ناپاک ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","جو بھی ایسی چیز چھوئے یا اُسے اُٹھا کر لے جائے وہ اپنے کپڑے دھو کر نہا لے۔ وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","جس کسی کو بھی مریض اپنے ہاتھ دھوئے بغیر چھوئے وہ اپنے کپڑے دھو کر نہا لے۔ وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","مٹی کا جو برتن ایسا مریض چھوئے اُسے توڑ دیا جائے۔ لکڑی کا جو برتن وہ چھوئے اُسے خوب دھویا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","جسے اِس مرض سے شفا ملی ہے وہ سات دن انتظار کرے۔ اِس کے بعد وہ تازہ پانی سے اپنے کپڑے دھو کر نہا لے۔ پھر وہ پاک ہو جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","آٹھویں دن وہ دو قمریاں یا دو جوان کبوتر لے کر ملاقات کے خیمے کے دروازے پر رب کے سامنے امام کو دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","امام اُن میں سے ایک کو گناہ کی قربانی کے طور پر اور دوسرے کو بھسم ہونے والی قربانی کے طور پر چڑھائے۔ یوں وہ رب کے سامنے اُس کا کفارہ دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","اگر کسی مرد کا نطفہ خارج ہو جائے تو وہ اپنے پورے جسم کو دھو لے۔ وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ہر کپڑا یا چمڑا جس سے نطفہ لگ گیا ہو اُسے دھونا ہے۔ وہ بھی شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","اگر مرد اور عورت کے ہم بستر ہونے پر نطفہ خارج ہو جائے تو لازم ہے کہ دونوں نہا لیں۔ وہ شام تک ناپاک رہیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","ماہواری کے وقت عورت سات دن تک ناپاک ہے۔ جو بھی اُسے چھوئے وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","اِس دوران جس چیز پر بھی وہ لیٹتی یا بیٹھتی ہے وہ ناپاک ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_21‏","004_15_21‏","LEV","15","21‏","23","جو بھی اُس کے لیٹنے کی جگہ کو چھوئے یا اُس کے بیٹھنے کی جگہ پر بیٹھ جائے وہ اپنے کپڑے دھو کر نہا لے۔ وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","اگر مرد عورت سے ہم بستر ہو اور اُسی وقت ماہواری کے دن شروع ہو جائیں تو مرد خون لگنے کے باعث سات دن تک ناپاک رہے گا۔ جس چیز پر بھی وہ لیٹتا ہے وہ ناپاک ہو جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","اگر کسی عورت کو ماہواری کے دن چھوڑ کر کسی اَور وقت کئی دنوں تک خون آئے یا خون ماہواری کے دنوں کے بعد بھی جاری رہے تو وہ ماہواری کے دنوں کی طرح اُس وقت تک ناپاک رہے گی جب تک خون رُک نہ جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","جس چیز پر بھی وہ لیٹتی یا بیٹھتی ہے وہ ناپاک ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","جو بھی ایسی چیز کو چھوئے وہ اپنے کپڑے دھو کر نہا لے۔ وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","خون کے رُک جانے پر عورت مزید سات دن انتظار کرے۔ پھر وہ پاک ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","آٹھویں دن وہ دو قمریاں یا دو جوان کبوتر لے کر ملاقات کے خیمے کے دروازے پر امام کے پاس آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","امام اُن میں سے ایک کو گناہ کی قربانی کے لئے اور دوسرے کو بھسم ہونے والی قربانی کے لئے چڑھائے۔ یوں وہ رب کے سامنے اُس کی ناپاکی کا کفارہ دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","لازم ہے کہ اسرائیلیوں کو ایسی چیزوں سے دُور رکھا جائے جن سے وہ ناپاک ہو جائیں۔ ورنہ میرا وہ مقدِس جو اُن کے درمیان ہے اُن سے ناپاک ہو جائے گا اور وہ ہلاک ہو جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","لازم ہے کہ اِس قسم کے معاملوں سے ایسے نپٹو جیسے بیان کیا گیا ہے۔ اِس میں وہ مرد شامل ہے جو جریان کا مریض ہے اور وہ جو نطفہ خارج ہونے کے باعث ناپاک ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","اِس میں وہ عورت بھی شامل ہے جس کے ماہواری کے ایام ہیں اور وہ مرد جو ناپاک عورت سے ہم بستر ہو جاتا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","جب ہارون کے دو بیٹے رب کے قریب آ کر ہلاک ہوئے تو اِس کے بعد رب موسیٰ سے ہم کلام ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","اُس نے کہا، ”اپنے بھائی ہارون کو بتانا کہ وہ صرف مقررہ وقت پر پردے کے پیچھے مُقدّس ترین کمرے میں داخل ہو کر عہد کے صندوق کے ڈھکنے کے سامنے کھڑا ہو جائے، ورنہ وہ مر جائے گا۔ کیونکہ مَیں خود اُس ڈھکنے کے اوپر بادل کی صورت میں ظاہر ہوتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","اور جب بھی وہ داخل ہو تو گناہ کی قربانی کے لئے ایک جوان بَیل اور بھسم ہونے والی قربانی کے لئے ایک مینڈھا پیش کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","پہلے وہ نہا کر امام کے کتان کے مُقدّس کپڑے پہن لے یعنی زیر جامہ، اُس کے نیچے پاجامہ، پھر کمربند اور پگڑی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","اسرائیل کی جماعت ہارون کو گناہ کی قربانی کے لئے دو بکرے اور بھسم ہونے والی قربانی کے لئے ایک مینڈھا دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","پہلے ہارون اپنے اور اپنے گھرانے کے لئے جوان بَیل کو گناہ کی قربانی کے طور پر چڑھائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","پھر وہ دونوں بکروں کو ملاقات کے خیمے کے دروازے پر رب کے سامنے لے آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","وہاں وہ قرعہ ڈال کر ایک کو رب کے لئے چنے اور دوسرے کو عزازیل کے لئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","جو بکرا رب کے لئے ہے اُسے وہ گناہ کی قربانی کے طور پر پیش کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","دوسرا بکرا جو قرعے کے ذریعے عزازیل کے لئے چنا گیا اُسے زندہ حالت میں رب کے سامنے کھڑا کیا جائے تاکہ وہ جماعت کا کفارہ دے۔ وہاں سے اُسے ریگستان میں عزازیل کے پاس بھیجا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","لیکن پہلے ہارون جوان بَیل کو گناہ کی قربانی کے طور پر چڑھا کر اپنا اور اپنے گھرانے کا کفارہ دے۔ اُسے ذبح کرنے کے بعد ");
INSERT INTO urdgvu_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","وہ بخور کی قربان گاہ سے جلتے ہوئے کوئلوں سے بھرا ہوا برتن لے کر اپنی دونوں مٹھیاں باریک خوشبودار بخور سے بھر لے اور مُقدّس ترین کمرے میں داخل ہو جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","وہاں وہ رب کے حضور بخور کو جلتے ہوئے کوئلوں پر ڈال دے۔ اِس سے پیدا ہونے والا دھواں عہد کے صندوق کا ڈھکنا چھپا دے گا تاکہ ہارون مر نہ جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","اب وہ جوان بَیل کے خون میں سے کچھ لے کر اپنی اُنگلی سے ڈھکنے کے سامنے والے حصے پر چھڑکے، پھر کچھ اپنی اُنگلی سے سات بار اُس کے سامنے زمین پر چھڑکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","اِس کے بعد وہ اُس بکرے کو ذبح کرے جو قوم کے لئے گناہ کی قربانی ہے۔ وہ اُس کا خون مُقدّس ترین کمرے میں لے آئے اور اُسے بَیل کے خون کی طرح عہد کے صندوق کے ڈھکنے پر اور سات بار اُس کے سامنے زمین پر چھڑکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","یوں وہ مُقدّس ترین کمرے کا کفارہ دے گا جو اسرائیلیوں کی ناپاکیوں اور تمام گناہوں سے متاثر ہوتا رہتا ہے۔ اِس سے وہ ملاقات کے پورے خیمے کا بھی کفارہ دے گا جو خیمہ گاہ کے درمیان ہونے کے باعث اسرائیلیوں کی ناپاکیوں سے متاثر ہوتا رہتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","جتنا وقت ہارون اپنا، اپنے گھرانے کا اور اسرائیل کی پوری جماعت کا کفارہ دینے کے لئے مُقدّس ترین کمرے میں رہے گا اِس دوران کسی دوسرے کو ملاقات کے خیمے میں ٹھہرنے کی اجازت نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","پھر وہ مُقدّس ترین کمرے سے نکل کر خیمے میں رب کے سامنے پڑی قربان گاہ کا کفارہ دے۔ وہ بَیل اور بکرے کے خون میں سے کچھ لے کر اُسے قربان گاہ کے چاروں سینگوں پر لگائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","کچھ خون وہ اپنی اُنگلی سے سات بار اُس پر چھڑک دے۔ یوں وہ اُسے اسرائیلیوں کی ناپاکیوں سے پاک کر کے مخصوص و مُقدّس کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","مُقدّس ترین کمرے، ملاقات کے خیمے اور قربان گاہ کا کفارہ دینے کے بعد ہارون زندہ بکرے کو سامنے لائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","وہ اپنے دونوں ہاتھ اُس کے سر پر رکھے اور اسرائیلیوں کے تمام قصور یعنی اُن کے تمام جرائم اور گناہوں کا اقرار کر کے اُنہیں بکرے کے سر پر ڈال دے۔ پھر وہ اُسے ریگستان میں بھیج دے۔ اِس کے لئے وہ بکرے کو ایک آدمی کے سپرد کرے جسے یہ ذمہ داری دی گئی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","بکرا اپنے آپ پر اُن کا تمام قصور اُٹھا کر کسی ویران جگہ میں لے جائے گا۔ وہاں ساتھ والا آدمی اُسے چھوڑ آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","اِس کے بعد ہارون ملاقات کے خیمے میں جائے اور کتان کے وہ کپڑے جو اُس نے مُقدّس ترین کمرے میں داخل ہونے سے پیشتر پہن لئے تھے اُتار کر وہیں چھوڑ دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","وہ مُقدّس جگہ پر نہا کر اپنی خدمت کے عام کپڑے پہن لے۔ پھر وہ باہر آ کر اپنے اور اپنی قوم کے لئے بھسم ہونے والی قربانی پیش کرے تاکہ اپنا اور اپنی قوم کا کفارہ دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","اِس کے علاوہ وہ گناہ کی قربانی کی چربی قربان گاہ پر جلا دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","جو آدمی عزازیل کے لئے بکرے کو ریگستان میں چھوڑ آیا ہے وہ اپنے کپڑے دھو کر نہا لے۔ اِس کے بعد وہ خیمہ گاہ میں آ سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","جس بَیل اور بکرے کو گناہ کی قربانی کے لئے پیش کیا گیا اور جن کا خون کفارہ دینے کے لئے مُقدّس ترین کمرے میں لایا گیا، لازم ہے کہ اُن کی کھالیں، گوشت اور گوبر خیمہ گاہ کے باہر جلا دیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","یہ چیزیں جلانے والا بعد میں اپنے کپڑے دھو کر نہا لے۔ پھر وہ خیمہ گاہ میں آ سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","لازم ہے کہ ساتویں مہینے کے دسویں دن اسرائیلی اور اُن کے درمیان رہنے والے پردیسی اپنی جان کو دُکھ دیں اور کام نہ کریں۔ یہ اصول تمہارے لئے ابد تک قائم رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","اِس دن تمہارا کفارہ دیا جائے گا تاکہ تمہیں پاک کیا جائے۔ تب تم رب کے سامنے اپنے تمام گناہوں سے پاک ٹھہرو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","پورا دن آرام کرو اور اپنی جان کو دُکھ دو۔ یہ اصول ابد تک قائم رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","اِس دن امامِ اعظم تمہارا کفارہ دے، وہ امام جسے اُس کے باپ کی جگہ مسح کیا گیا اور اختیار دیا گیا ہے۔ وہ کتان کے مُقدّس کپڑے پہن کر ");
INSERT INTO urdgvu_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","مُقدّس ترین کمرے، ملاقات کے خیمے، قربان گاہ، اماموں اور جماعت کے تمام لوگوں کا کفارہ دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","لازم ہے کہ سال میں ایک دفعہ اسرائیلیوں کے تمام گناہوں کا کفارہ دیا جائے۔ یہ اصول تمہارے لئے ابد تک قائم رہے۔“ سب کچھ ویسے ہی کیا گیا جیسا رب نے موسیٰ کو حکم دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","”ہارون، اُس کے بیٹوں اور تمام اسرائیلیوں کو ہدایت دینا ");
INSERT INTO urdgvu_vpl VALUES ("LV17_3‏","004_17_3‏","LEV","17","3‏","4","کہ جو بھی اسرائیلی اپنی گائے یا بھیڑبکری ملاقات کے خیمے کے دروازے پر رب کو قربانی کے طور پر پیش نہ کرے بلکہ خیمہ گاہ کے اندر یا باہر کسی اَور جگہ پر ذبح کرے وہ خون بہانے کا قصوروار ٹھہرے گا۔ اُس نے خون بہایا ہے، اور لازم ہے کہ اُسے اُس کی قوم میں سے مٹایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","اِس ہدایت کا مقصد یہ ہے کہ اسرائیلی اب سے اپنی قربانیاں کھلے میدان میں ذبح نہ کریں بلکہ رب کو پیش کریں۔ وہ اپنے جانوروں کو ملاقات کے خیمے کے دروازے پر امام کے پاس لا کر اُنہیں رب کو سلامتی کی قربانی کے طور پر پیش کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","امام اُن کا خون ملاقات کے خیمے کے دروازے پر کی قربان گاہ پر چھڑکے اور اُن کی چربی اُس پر جلا دے۔ ایسی قربانی کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","اب سے اسرائیلی اپنی قربانیاں اُن بکروں کے دیوتاؤں کو پیش نہ کریں جن کی پیروی کر کے اُنہوں نے زنا کیا ہے۔ یہ اُن کے لئے اور اُن کے بعد آنے والی نسلوں کے لئے ایک دائمی اصول ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","لازم ہے کہ ہر اسرائیلی اور تمہارے درمیان رہنے والا پردیسی اپنی بھسم ہونے والی قربانی یا کوئی اَور قربانی ");
INSERT INTO urdgvu_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ملاقات کے خیمے کے دروازے پر لا کر رب کو پیش کرے۔ ورنہ اُسے اُس کی قوم میں سے مٹایا جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","خون کھانا بالکل منع ہے۔ جو بھی اسرائیلی یا تمہارے درمیان رہنے والا پردیسی خون کھائے مَیں اُس کے خلاف ہو جاؤں گا اور اُسے اُس کی قوم میں سے مٹا ڈالوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","کیونکہ ہر مخلوق کے خون میں اُس کی جان ہے۔ مَیں نے اُسے تمہیں دے دیا ہے تاکہ وہ قربان گاہ پر تمہارا کفارہ دے۔ کیونکہ خون ہی اُس جان کے ذریعے جو اُس میں ہے تمہارا کفارہ دیتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","اِس لئے مَیں کہتا ہوں کہ نہ کوئی اسرائیلی نہ کوئی پردیسی خون کھائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","اگر کوئی بھی اسرائیلی یا پردیسی کسی جانور یا پرندے کا شکار کر کے پکڑے جسے کھانے کی اجازت ہے تو وہ اُسے ذبح کرنے کے بعد اُس کا پورا خون زمین پر بہنے دے اور خون پر مٹی ڈالے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","کیونکہ ہر مخلوق کا خون اُس کی جان ہے۔ اِس لئے مَیں نے اسرائیلیوں کو کہا ہے کہ کسی بھی مخلوق کا خون نہ کھاؤ۔ ہر مخلوق کا خون اُس کی جان ہے، اور جو بھی اُسے کھائے اُسے قوم میں سے مٹا دینا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","اگر کوئی بھی اسرائیلی یا پردیسی ایسے جانور کا گوشت کھائے جو فطری طور پر مر گیا یا جسے جنگلی جانوروں نے پھاڑ ڈالا ہو تو وہ اپنے کپڑے دھو کر نہا لے۔ وہ شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","جو ایسا نہیں کرتا اُسے اپنے قصور کی سزا بھگتنی پڑے گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","”اسرائیلیوں کو بتانا کہ مَیں رب تمہارا خدا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","مصریوں کی طرح زندگی نہ گزارنا جن میں تم رہتے تھے۔ ملکِ کنعان کے لوگوں کی طرح بھی زندگی نہ گزارنا جن کے پاس مَیں تمہیں لے جا رہا ہوں۔ اُن کے رسم و رواج نہ اپنانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","میرے ہی احکام پر عمل کرو اور میری ہدایات کے مطابق چلو۔ مَیں رب تمہارا خدا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","میری ہدایات اور احکام کے مطابق چلنا، کیونکہ جو یوں کرے گا وہ جیتا رہے گا۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","تم میں سے کوئی بھی اپنی قریبی رشتے دار سے ہم بستر نہ ہو۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","اپنی ماں سے ہم بستر نہ ہونا، ورنہ تیرے باپ کی بےحرمتی ہو جائے گی۔ وہ تیری ماں ہے، اِس لئے اُس سے ہم بستر نہ ہونا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","اپنے باپ کی کسی بھی بیوی سے ہم بستر نہ ہونا، ورنہ تیرے باپ کی بےحرمتی ہو جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","اپنی بہن سے ہم بستر نہ ہونا، چاہے وہ تیرے باپ یا تیری ماں کی بیٹی ہو، چاہے وہ تیرے ہی گھر میں یا کہیں اَور پیدا ہوئی ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","اپنی پوتی یا نواسی سے ہم بستر نہ ہونا، ورنہ تیری اپنی بےحرمتی ہو جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","اپنے باپ کی بیوی کی بیٹی سے ہم بستر نہ ہونا۔ وہ تیری بہن ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","اپنی پھوپھی سے ہم بستر نہ ہونا۔ وہ تیرے باپ کی قریبی رشتے دار ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","اپنی خالہ سے ہم بستر نہ ہونا۔ وہ تیری ماں کی قریبی رشتے دار ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","اپنے باپ کے بھائی کی بیوی سے ہم بستر نہ ہونا، ورنہ تیرے باپ کے بھائی کی بےحرمتی ہو جائے گی۔ اُس کی بیوی تیری چچی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","اپنی بہو سے ہم بستر نہ ہونا۔ وہ تیرے بیٹے کی بیوی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","اپنی بھابی سے ہم بستر نہ ہونا، ورنہ تیرے بھائی کی بےحرمتی ہو جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","اگر تیرا جنسی تعلق کسی عورت سے ہو تو اُس کی بیٹی، پوتی یا نواسی سے ہم بستر ہونا منع ہے، کیونکہ وہ اُس کی قریبی رشتے دار ہیں۔ ایسا کرنا بڑی شرم ناک حرکت ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","اپنی بیوی کے جیتے جی اُس کی بہن سے شادی نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","کسی عورت سے اُس کی ماہواری کے دنوں میں ہم بستر نہ ہونا۔ اِس دوران وہ ناپاک ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","کسی دوسرے مرد کی بیوی سے ہم بستر نہ ہونا، ورنہ تُو اپنے آپ کو ناپاک کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","اپنے کسی بھی بچے کو مَلِک دیوتا کو قربانی کے طور پر پیش کر کے جلا دینا منع ہے۔ ایسی حرکت سے تُو اپنے خدا کے نام کو داغ لگائے گا۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","مرد دوسرے مرد کے ساتھ جنسی تعلقات نہ رکھے۔ ایسی حرکت قابلِ گھن ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","کسی جانور سے جنسی تعلقات نہ رکھنا، ورنہ تُو ناپاک ہو جائے گا۔ عورتوں کے لئے بھی ایسا کرنا منع ہے۔ یہ بڑی شرم ناک حرکت ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","ایسی حرکتوں سے اپنے آپ کو ناپاک نہ کرنا۔ کیونکہ جو قومیں مَیں تمہارے آگے ملک سے نکالوں گا وہ اِسی طرح ناپاک ہوتی رہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ملک خود بھی ناپاک ہوا۔ اِس لئے مَیں نے اُسے اُس کے قصور کے سبب سے سزا دی، اور نتیجے میں اُس نے اپنے باشندوں کو اُگل دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","لیکن تم میری ہدایات اور احکام کے مطابق چلو۔ نہ دیسی اور نہ پردیسی ایسی کوئی گھناؤنی حرکت کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","کیونکہ یہ تمام قابلِ گھن باتیں اُن سے ہوئیں جو تم سے پہلے اِس ملک میں رہتے تھے۔ یوں ملک ناپاک ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","لہٰذا اگر تم بھی ملک کو ناپاک کرو گے تو وہ تمہیں اِسی طرح اُگل دے گا جس طرح اُس نے تم سے پہلے موجود قوموں کو اُگل دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","جو بھی مذکورہ گھناؤنی حرکتوں میں سے ایک کرے اُسے اُس کی قوم میں سے مٹایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","میرے احکام کے مطابق چلتے رہو اور ایسے قابلِ گھن رسم و رواج نہ اپنانا جو تمہارے آنے سے پہلے رائج تھے۔ اِن سے اپنے آپ کو ناپاک نہ کرنا۔ مَیں رب تمہارا خدا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","”اسرائیلیوں کی پوری جماعت کو بتانا کہ مُقدّس رہو، کیونکہ مَیں رب تمہارا خدا قدوس ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","تم میں سے ہر ایک اپنے ماں باپ کی عزت کرے۔ ہفتے کے دن کام نہ کرنا۔ مَیں رب تمہارا خدا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","نہ بُتوں کی طرف رجوع کرنا، نہ اپنے لئے دیوتا ڈھالنا۔ مَیں ہی رب تمہارا خدا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","جب تم رب کو سلامتی کی قربانی پیش کرتے ہو تو اُسے یوں چڑھاؤ کہ تم منظور ہو جاؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","اُس کا گوشت اُسی دن یا اگلے دن کھایا جائے۔ جو بھی تیسرے دن تک بچ جاتا ہے اُسے جلانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","اگر کوئی اُسے تیسرے دن کھائے تو اُسے علم ہونا چاہئے کہ یہ قربانی ناپاک ہے اور رب کو پسند نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ایسے شخص کو اپنے قصور کی سزا اُٹھانی پڑے گی، کیونکہ اُس نے اُس چیز کی مُقدّس حالت ختم کی ہے جو رب کے لئے مخصوص کی گئی تھی۔ اُسے اُس کی قوم میں سے مٹایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","کٹائی کے وقت اپنی فصل پورے طور پر نہ کاٹنا بلکہ کھیت کے کناروں پر کچھ چھوڑ دینا۔ اِس طرح جو کچھ کٹائی کرتے وقت کھیت میں بچ جائے اُسے چھوڑنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","انگور کے باغوں میں بھی جو کچھ انگور توڑتے وقت بچ جائے اُسے چھوڑ دینا۔ جو انگور زمین پر گر جائیں اُنہیں اُٹھا کر نہ لے جانا۔ اُنہیں غریبوں اور پردیسیوں کے لئے چھوڑ دینا۔ مَیں رب تمہارا خدا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","چوری نہ کرنا، جھوٹ نہ بولنا، ایک دوسرے کو دھوکا نہ دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","میرے نام کی قَسم کھا کر دھوکا نہ دینا، ورنہ تم میرے نام کو داغ لگاؤ گے۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","ایک دوسرے کو نہ دبانا اور نہ لُوٹنا۔ کسی کی مزدوری اُسی دن کی شام تک دے دینا اور اُسے اگلی صبح تک روکے نہ رکھنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","بہرے کو نہ کوسنا، نہ اندھے کے راستے میں کوئی چیز رکھنا جس سے وہ ٹھوکر کھائے۔ اِس میں بھی اپنے خدا کا خوف ماننا۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","عدالت میں کسی کی حق تلفی نہ کرنا۔ فیصلہ کرتے وقت کسی کی بھی جانب داری نہ کرنا، چاہے وہ غریب یا اثر و رسوخ والا ہو۔ انصاف سے اپنے پڑوسی کی عدالت کر۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","اپنی قوم میں اِدھر اُدھر پھرتے ہوئے کسی پر بہتان نہ لگانا۔ کوئی بھی ایسا کام نہ کرنا جس سے کسی کی جان خطرے میں پڑ جائے۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","دل میں اپنے بھائی سے نفرت نہ کرنا۔ اگر کسی کی سرزنش کرنی ہے تو رُوبرُو کرنا، ورنہ تُو اُس کے سبب سے قصوروار ٹھہرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","انتقام نہ لینا۔ اپنی قوم کے کسی شخص پر دیر تک تیرا غصہ نہ رہے بلکہ اپنے پڑوسی سے ویسی محبت رکھنا جیسی تُو اپنے آپ سے رکھتا ہے۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","میری ہدایات پر عمل کرو۔ دو مختلف قسم کے جانوروں کو ملاپ نہ کرنے دینا۔ اپنے کھیت میں دو قسم کے بیج نہ بونا۔ ایسا کپڑا نہ پہننا جو دو مختلف قسم کے دھاگوں کا بُنا ہوا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","اگر کوئی آدمی کسی لونڈی سے جس کی منگنی کسی اَور سے ہو چکی ہو ہم بستر ہو جائے اور لونڈی کو اب تک نہ پیسوں سے نہ ویسے ہی آزاد کیا گیا ہو تو مناسب سزا دی جائے۔ لیکن اُنہیں سزائے موت نہ دی جائے، کیونکہ اُسے اب تک آزاد نہیں کیا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","قصوروار آدمی ملاقات کے خیمے کے دروازے پر ایک مینڈھا لے آئے تاکہ وہ رب کو قصور کی قربانی کے طور پر پیش کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","امام اِس قربانی سے رب کے سامنے اُس کے گناہ کا کفارہ دے۔ یوں اُس کا گناہ معاف کیا جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","جب ملکِ کنعان میں داخل ہونے کے بعد تم پھل دار درخت لگاؤ گے تو پہلے تین سال اُن کا پھل نہ کھانا بلکہ اُسے ممنوع سمجھنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","چوتھے سال اُن کا تمام پھل خوشی کے مُقدّس نذرانے کے طور پر رب کے لئے مخصوص کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","پانچویں سال تم اُن کا پھل کھا سکتے ہو۔ یوں تمہاری فصل بڑھائی جائے گی۔ مَیں رب تمہارا خدا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","ایسا گوشت نہ کھانا جس میں خون ہو۔ فال یا شگون نہ نکالنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","اپنے سر کے بال گول شکل میں نہ کٹوانا، نہ اپنی داڑھی کو تراشنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","اپنے آپ کو مُردوں کے سبب سے کاٹ کر زخمی نہ کرنا، نہ اپنی جِلد پر نقوش گدوانا۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","اپنی بیٹی کو کسبی نہ بنانا، ورنہ اُس کی مُقدّس حالت جاتی رہے گی اور ملک زناکاری کے باعث حرام کاری سے بھر جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","ہفتے کے دن آرام کرنا اور میرے مقدِس کا احترام کرنا۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","ایسے لوگوں کے پاس نہ جانا جو مُردوں سے رابطہ کرتے ہیں، نہ غیب دانوں کی طرف رجوع کرنا، ورنہ تم اُن سے ناپاک ہو جاؤ گے۔ مَیں رب تمہارا خدا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","بوڑھے لوگوں کے سامنے اُٹھ کر کھڑا ہو جانا، بزرگوں کی عزت کرنا اور اپنے خدا کا احترام کرنا۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","جو پردیسی تمہارے ملک میں تمہارے درمیان رہتا ہے اُسے نہ دبانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","اُس کے ساتھ ایسا سلوک کر جیسا اپنے ہم وطنوں کے ساتھ کرتا ہے۔ جس طرح تُو اپنے آپ سے محبت رکھتا ہے اُسی طرح اُس سے بھی محبت رکھنا۔ یاد رہے کہ تم خود مصر میں پردیسی تھے۔ مَیں رب تمہارا خدا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","ناانصافی نہ کرنا۔ نہ عدالت میں، نہ لمبائی ناپتے وقت، نہ تولتے وقت اور نہ کسی چیز کی مقدار ناپتے وقت۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","صحیح ترازو، صحیح باٹ اور صحیح پیمانہ استعمال کرنا۔ مَیں رب تمہارا خدا ہوں جو تمہیں مصر سے نکال لایا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","میری تمام ہدایات اور تمام احکام مانو اور اُن پر عمل کرو۔ مَیں رب ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","”اسرائیلیوں کو بتانا کہ تم میں سے جو بھی اپنے بچے کو مَلِک دیوتا کو قربانی کے طور پر پیش کرے اُسے سزائے موت دینی ہے۔ اِس میں کوئی فرق نہیں کہ وہ اسرائیلی ہے یا پردیسی۔ جماعت کے لوگ اُسے سنگسار کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","مَیں خود ایسے شخص کے خلاف ہو جاؤں گا اور اُسے اُس کی قوم میں سے مٹا ڈالوں گا۔ کیونکہ اپنے بچوں کو مَلِک کو پیش کرنے سے اُس نے میرے مقدِس کو ناپاک کیا اور میرے نام کو داغ لگایا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","اگر جماعت کے لوگ اپنی آنکھیں بند کر کے ایسے شخص کی حرکتیں نظرانداز کریں اور اُسے سزائے موت نہ دیں ");
INSERT INTO urdgvu_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","تو پھر مَیں خود ایسے شخص اور اُس کے گھرانے کے خلاف کھڑا ہو جاؤں گا۔ مَیں اُسے اور اُن تمام لوگوں کو قوم میں سے مٹا ڈالوں گا جنہوں نے اُس کے پیچھے لگ کر مَلِک دیوتا کو سجدہ کرنے سے زنا کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","جو شخص مُردوں سے رابطہ کرنے اور غیب دانی کرنے والوں کی طرف رجوع کرتا ہے مَیں اُس کے خلاف ہو جاؤں گا۔ اُن کی پیروی کرنے سے وہ زنا کرتا ہے۔ مَیں اُسے اُس کی قوم میں سے مٹا ڈالوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","اپنے آپ کو میرے لئے مخصوص و مُقدّس رکھو، کیونکہ مَیں رب تمہارا خدا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","میری ہدایات مانو اور اُن پر عمل کرو۔ مَیں رب ہوں جو تمہیں مخصوص و مُقدّس کرتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","جس نے بھی اپنے باپ یا ماں پر لعنت بھیجی ہے اُسے سزائے موت دی جائے۔ اِس حرکت سے وہ اپنی موت کا خود ذمہ دار ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","اگر کسی مرد نے کسی کی بیوی کے ساتھ زنا کیا ہے تو دونوں کو سزائے موت دینی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","جو مرد اپنے باپ کی بیوی سے ہم بستر ہوا ہے اُس نے اپنے باپ کی بےحرمتی کی ہے۔ دونوں کو سزائے موت دینی ہے۔ وہ اپنی موت کے خود ذمہ دار ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","اگر کوئی مرد اپنی بہو سے ہم بستر ہوا ہے تو دونوں کو سزائے موت دینی ہے۔ جو کچھ اُنہوں نے کیا ہے وہ نہایت شرم ناک ہے۔ وہ اپنی موت کے خود ذمہ دار ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","اگر کوئی مرد کسی دوسرے مرد سے جنسی تعلقات رکھے تو دونوں کو اِس گھناؤنی حرکت کے باعث سزائے موت دینی ہے۔ وہ اپنی موت کے خود ذمہ دار ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","اگر کوئی آدمی اپنی بیوی کے علاوہ اُس کی ماں سے بھی شادی کرے تو یہ ایک نہایت شرم ناک بات ہے۔ دونوں کو جلا دینا ہے تاکہ تمہارے درمیان کوئی ایسی خبیث بات نہ رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","جو مرد کسی جانور سے جنسی تعلقات رکھے اُسے سزائے موت دینا ہے۔ اُس جانور کو بھی مار دیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","جو عورت کسی جانور سے جنسی تعلقات رکھے اُسے سزائے موت دینی ہے۔ اُس جانور کو بھی مار دیا جائے۔ وہ اپنی موت کے خود ذمہ دار ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","جس مرد نے اپنی بہن سے شادی کی ہے اُس نے شرم ناک حرکت کی ہے، چاہے وہ باپ کی بیٹی ہو یا ماں کی۔ اُنہیں اسرائیلی قوم کی نظروں سے مٹایا جائے۔ ایسے شخص نے اپنی بہن کی بےحرمتی کی ہے۔ اِس لئے اُسے خود اپنے قصور کے نتیجے برداشت کرنے پڑیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","اگر کوئی مرد ماہواری کے ایام میں کسی عورت سے ہم بستر ہوا ہے تو دونوں کو اُن کی قوم میں سے مٹانا ہے۔ کیونکہ دونوں نے عورت کے خون کے منبع سے پردہ اُٹھایا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","اپنی خالہ یا پھوپھی سے ہم بستر نہ ہونا۔ کیونکہ جو ایسا کرتا ہے وہ اپنی قریبی رشتے دار کی بےحرمتی کرتا ہے۔ دونوں کو اپنے قصور کے نتیجے برداشت کرنے پڑیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","جو اپنی چچی یا تائی سے ہم بستر ہوا ہے اُس نے اپنے چچا یا تایا کی بےحرمتی کی ہے۔ دونوں کو اپنے قصور کے نتیجے برداشت کرنے پڑیں گے۔ وہ بےاولاد مریں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","جس نے اپنی بھابی سے شادی کی ہے اُس نے ایک نجس حرکت کی ہے۔ اُس نے اپنے بھائی کی بےحرمتی کی ہے۔ وہ بےاولاد رہیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","میری تمام ہدایات اور احکام کو مانو اور اُن پر عمل کرو۔ ورنہ جس ملک میں مَیں تمہیں لے جا رہا ہوں وہ تمہیں اُگل دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","اُن قوموں کے رسم و رواج کے مطابق زندگی نہ گزارنا جنہیں مَیں تمہارے آگے سے نکال دوں گا۔ مجھے اِس سبب سے اُن سے گھن آنے لگی کہ وہ یہ سب کچھ کرتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","لیکن تم سے مَیں نے کہا، ’تم ہی اُن کی زمین پر قبضہ کرو گے۔ مَیں ہی اُسے تمہیں دے دوں گا، ایسا ملک جس میں کثرت کا دودھ اور شہد ہے۔‘ مَیں رب تمہارا خدا ہوں، جس نے تم کو دیگر قوموں میں سے چن کر الگ کر دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","اِس لئے لازم ہے کہ تم زمین پر چلنے والے جانوروں اور پرندوں میں پاک اور ناپاک کا امتیاز کرو۔ اپنے آپ کو ناپاک جانور کھانے سے قابلِ گھن نہ بنانا، چاہے وہ زمین پر چلتے یا رینگتے ہیں، چاہے ہَوا میں اُڑتے ہیں۔ مَیں ہی نے اُنہیں تمہارے لئے ناپاک قرار دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","تمہیں میرے لئے مخصوص و مُقدّس ہونا ہے، کیونکہ مَیں قدوس ہوں، اور مَیں نے تمہیں دیگر قوموں میں سے چن کر اپنے لئے الگ کر لیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","تم میں سے جو مُردوں سے رابطہ یا غیب دانی کرتا ہے اُسے سزائے موت دینی ہے، خواہ عورت ہو یا مرد۔ اُنہیں سنگسار کرنا۔ وہ اپنی موت کے خود ذمہ دار ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","رب نے موسیٰ سے کہا، ”ہارون کے بیٹوں کو جو امام ہیں بتا دینا کہ امام اپنے آپ کو کسی اسرائیلی کی لاش کے قریب جانے سے ناپاک نہ کرے ");
INSERT INTO urdgvu_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","سوائے اپنے قریبی رشتے داروں کے یعنی ماں، باپ، بیٹا، بیٹی، بھائی ");
INSERT INTO urdgvu_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","اور جو غیرشادی شدہ بہن اُس کے گھر میں رہتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","وہ اپنی قوم میں کسی اَور کے باعث اپنے آپ کو ناپاک نہ کرے، ورنہ اُس کی مُقدّس حالت جاتی رہے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","امام اپنے سر کو نہ منڈوائیں۔ وہ نہ اپنی داڑھی کو تراشیں اور نہ کاٹنے سے اپنے آپ کو زخمی کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","وہ اپنے خدا کے لئے مخصوص و مُقدّس رہیں اور اپنے خدا کے نام کو داغ نہ لگائیں۔ چونکہ وہ رب کو جلنے والی قربانیاں یعنی اپنے خدا کی روٹی پیش کرتے ہیں اِس لئے لازم ہے کہ وہ مُقدّس رہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","امام زناکار عورت، مندر کی کسبی یا طلاق یافتہ عورت سے شادی نہ کریں، کیونکہ وہ اپنے رب کے لئے مخصوص و مُقدّس ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","امام کو مُقدّس سمجھنا، کیونکہ وہ تیرے خدا کی روٹی کو قربان گاہ پر چڑھاتا ہے۔ وہ تیرے لئے مُقدّس ٹھہرے کیونکہ مَیں رب قدوس ہوں۔ مَیں ہی تمہیں مُقدّس کرتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","کسی امام کی جو بیٹی زناکاری سے اپنی مُقدّس حالت کو ختم کر دیتی ہے وہ اپنے باپ کی مُقدّس حالت کو بھی ختم کر دیتی ہے۔ اُسے جلا دیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","امامِ اعظم کے سر پر مسح کا تیل اُنڈیلا گیا ہے اور اُسے امامِ اعظم کے مُقدّس کپڑے پہننے کا اختیار دیا گیا ہے۔ اِس لئے وہ رنج کے عالم میں اپنے بالوں کو بکھرنے نہ دے، نہ کبھی اپنے کپڑوں کو پھاڑے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","وہ کسی لاش کے قریب نہ جائے، چاہے وہ اُس کے باپ یا ماں کی لاش کیوں نہ ہو، ورنہ وہ ناپاک ہو جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","جب تک کوئی لاش اُس کے گھر میں پڑی رہے وہ مقدِس کو چھوڑ کر اپنے گھر نہ جائے، ورنہ وہ مقدِس کو ناپاک کرے گا۔ کیونکہ اُسے اُس کے خدا کے تیل سے مخصوص کیا گیا ہے۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","امامِ اعظم کو صرف کنواری سے شادی کی اجازت ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","وہ بیوہ، طلاق یافتہ عورت، مندر کی کسبی یا زناکار عورت سے شادی نہ کرے بلکہ صرف اپنے قبیلے کی کنواری سے، ");
INSERT INTO urdgvu_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ورنہ اُس کی اولاد مخصوص و مُقدّس نہیں ہو گی۔ کیونکہ مَیں رب ہوں جو اُسے اپنے لئے مخصوص و مُقدّس کرتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","رب نے موسیٰ سے یہ بھی کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","”ہارون کو بتانا کہ تیری اولاد میں سے کوئی بھی جس کے جسم میں نقص ہو میرے حضور آ کر اپنے خدا کی روٹی نہ چڑھائے۔ یہ اصول آنے والی نسلوں کے لئے بھی اٹل ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","کیونکہ کوئی بھی معذور میرے حضور نہ آئے، نہ اندھا، نہ لنگڑا، نہ وہ جس کی ناک چِری ہوئی ہو یا جس کے کسی عضو میں کمی بیشی ہو، ");
INSERT INTO urdgvu_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","نہ وہ جس کا پاؤں یا ہاتھ ٹوٹا ہوا ہو، ");
INSERT INTO urdgvu_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","نہ کُبڑا، نہ بونا، نہ وہ جس کی آنکھ میں نقص ہو یا جسے وبائی جِلدی بیماری ہو یا جس کے خصیے کچلے ہوئے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ہارون امام کی کوئی بھی اولاد جس کے جسم میں نقص ہو میرے حضور آ کر رب کو جلنے والی قربانیاں پیش نہ کرے۔ چونکہ اُس میں نقص ہے اِس لئے وہ میرے حضور آ کر اپنے خدا کی روٹی نہ چڑھائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","اُسے اللہ کی مُقدّس بلکہ مُقدّس ترین قربانیوں میں سے بھی اماموں کا حصہ کھانے کی اجازت ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","لیکن چونکہ اُس میں نقص ہے اِس لئے وہ مُقدّس ترین کمرے کے دروازے کے پردے کے قریب نہ جائے، نہ قربان گاہ کے پاس آئے۔ ورنہ وہ میری مُقدّس چیزوں کو ناپاک کرے گا۔ کیونکہ مَیں رب ہوں جو اُنہیں اپنے لئے مخصوص و مُقدّس کرتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","موسیٰ نے یہ ہدایات ہارون، اُس کے بیٹوں اور تمام اسرائیلیوں کو دیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","”ہارون اور اُس کے بیٹوں کو بتانا کہ اسرائیلیوں کی اُن قربانیوں کا احترام کرو جو تم نے میرے لئے مخصوص و مُقدّس کی ہیں، ورنہ تم میرے نام کو داغ لگاؤ گے۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","جو امام ناپاک ہونے کے باوجود اُن قربانیوں کے پاس آ جائے جو اسرائیلیوں نے میرے لئے مخصوص و مُقدّس کی ہیں اُسے میرے سامنے سے مٹانا ہے۔ یہ اصول آنے والی نسلوں کے لئے بھی اٹل ہے۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","ہارون کی اولاد میں سے جو بھی وبائی جِلدی بیماری یا جریان کا مریض ہو اُسے مُقدّس قربانیوں میں سے اپنا حصہ کھانے کی اجازت نہیں ہے۔ پہلے وہ پاک ہو جائے۔ جو ایسی کوئی بھی چیز چھوئے جو لاش سے ناپاک ہو گئی ہو یا ایسے آدمی کو چھوئے جس کا نطفہ نکلا ہو وہ ناپاک ہو جاتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","وہ ناپاک رینگنے والے جانور یا ناپاک شخص کو چھونے سے بھی ناپاک ہو جاتا ہے، خواہ وہ کسی بھی سبب سے ناپاک کیوں نہ ہوا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","جو ایسی کوئی بھی چیز چھوئے وہ شام تک ناپاک رہے گا۔ اِس کے علاوہ لازم ہے کہ وہ مُقدّس قربانیوں میں سے اپنا حصہ کھانے سے پہلے نہا لے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","سورج کے غروب ہونے پر وہ پاک ہو گا اور مُقدّس قربانیوں میں سے اپنا حصہ کھا سکے گا۔ کیونکہ وہ اُس کی روزی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","امام ایسے جانوروں کا گوشت نہ کھائے جو فطری طور پر مر گئے یا جنہیں جنگلی جانوروں نے پھاڑ ڈالا ہو، ورنہ وہ ناپاک ہو جائے گا۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","امام میری ہدایات کے مطابق چلیں، ورنہ وہ قصوروار بن جائیں گے اور مُقدّس چیزوں کی بےحرمتی کرنے کے سبب سے مر جائیں گے۔ مَیں رب ہوں جو اُنہیں اپنے لئے مخصوص و مُقدّس کرتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","صرف امام کے خاندان کے افراد مُقدّس قربانیوں میں سے کھا سکتے ہیں۔ غیرشہری یا مزدور کو اجازت نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","لیکن امام کا غلام یا لونڈی اُس میں سے کھا سکتے ہیں، چاہے اُنہیں خریدا گیا ہو یا وہ اُس کے گھر میں پیدا ہوئے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","اگر امام کی بیٹی نے کسی ایسے شخص سے شادی کی ہے جو امام نہیں ہے تو اُسے مُقدّس قربانیوں میں سے کھانے کی اجازت نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","لیکن ہو سکتا ہے کہ وہ بیوہ یا طلاق یافتہ ہو اور اُس کے بچے نہ ہوں۔ جب وہ اپنے باپ کے گھر لوٹ کر وہاں ایسے رہے گی جیسے اپنی جوانی میں تو وہ اپنے باپ کے اُس کھانے میں سے کھا سکتی ہے جو قربانیوں میں سے باپ کا حصہ ہے۔ لیکن جو امام کے خاندان کا فرد نہیں ہے اُسے کھانے کی اجازت نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","جس شخص نے نادانستہ طور پر مُقدّس قربانیوں میں سے امام کے حصے سے کچھ کھایا ہے وہ امام کو سب کچھ واپس کرنے کے علاوہ 20 فیصد زیادہ دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","امام رب کو پیش کی ہوئی قربانیوں کی مُقدّس حالت یوں ختم نہ کریں ");
INSERT INTO urdgvu_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","کہ وہ دوسرے اسرائیلیوں کو یہ مُقدّس چیزیں کھانے دیں۔ ایسی حرکت سے وہ اُن کو بڑا قصوروار بنا دیں گے۔ مَیں رب ہوں جو اُنہیں اپنے لئے مخصوص و مُقدّس کرتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","”ہارون، اُس کے بیٹوں اور اسرائیلیوں کو بتانا کہ اگر تم میں سے کوئی اسرائیلی یا پردیسی رب کو بھسم ہونے والی قربانی پیش کرنا چاہے تو طریقِ کار میں کوئی فرق نہیں ہے، چاہے وہ یہ مَنت مان کر یا ویسے ہی دلی خوشی سے کر رہا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","اِس کے لئے لازم ہے کہ تم ایک بےعیب بَیل، مینڈھا یا بکرا پیش کرو۔ پھر ہی اُسے قبول کیا جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","قربانی کے لئے کبھی بھی ایسا جانور پیش نہ کرنا جس میں نقص ہو، ورنہ تم اُس کے باعث منظور نہیں ہو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","اگر کوئی رب کو سلامتی کی قربانی پیش کرنا چاہے تو طریقِ کار میں کوئی فرق نہیں ہے، چاہے وہ یہ مَنت مان کر یا ویسے ہی دلی خوشی سے کر رہا ہو۔ اِس کے لئے لازم ہے کہ وہ گائےبَیلوں یا بھیڑبکریوں میں سے بےعیب جانور چنے۔ پھر اُسے قبول کیا جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","رب کو ایسے جانور پیش نہ کرنا جو اندھے ہوں، جن کے اعضا ٹوٹے یا کٹے ہوئے ہوں، جن کو رسَولی ہو یا جنہیں وبائی جِلدی بیماری لگ گئی ہو۔ رب کو اُنہیں جلنے والی قربانی کے طور پر قربان گاہ پر پیش نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","لیکن جس گائےبَیل یا بھیڑبکری کے کسی عضو میں کمی بیشی ہو اُسے پیش کیا جا سکتا ہے۔ شرط یہ ہے کہ پیش کرنے والا اُسے ویسے ہی دلی خوشی سے چڑھائے۔ اگر وہ اُسے اپنی مَنت مان کر پیش کرے تو وہ قبول نہیں کیا جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","رب کو ایسا جانور پیش نہ کرنا جس کے خصیے کچلے، توڑے یا کٹے ہوئے ہوں۔ اپنے ملک میں جانوروں کو اِس طرح خصی نہ بنانا، ");
INSERT INTO urdgvu_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","نہ ایسے جانور کسی غیرملکی سے خرید کر اپنے خدا کی روٹی کے طور پر پیش کرنا۔ تم ایسے جانوروں کے باعث منظور نہیں ہو گے، کیونکہ اُن میں خرابی اور نقص ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","رب نے موسیٰ سے یہ بھی کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","”جب کسی گائے، بھیڑ یا بکری کا بچہ پیدا ہوتا ہے تو لازم ہے کہ وہ پہلے سات دن اپنی ماں کے پاس رہے۔ آٹھویں دن سے پہلے رب اُسے جلنے والی قربانی کے طور پر قبول نہیں کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","کسی گائے، بھیڑ یا بکری کے بچے کو اُس کی ماں سمیت ایک ہی دن ذبح نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","جب تم رب کو سلامتی کی کوئی قربانی چڑھانا چاہتے ہو تو اُسے یوں پیش کرنا کہ تم منظور ہو جاؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","اگلی صبح تک کچھ بچا نہ رہے بلکہ اُسے اُسی دن کھانا ہے۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","میرے احکام مانو اور اُن پر عمل کرو۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","میرے نام کو داغ نہ لگانا۔ لازم ہے کہ مجھے اسرائیلیوں کے درمیان قدوس مانا جائے۔ مَیں رب ہوں جو تمہیں اپنے لئے مخصوص و مُقدّس کرتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","مَیں تمہیں مصر سے نکال لایا ہوں تاکہ تمہارا خدا ہوں۔ مَیں رب ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","”اسرائیلیوں کو بتانا کہ یہ میری، رب کی عیدیں ہیں جن پر تمہیں لوگوں کو مُقدّس اجتماع کے لئے جمع کرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","ہفتے میں چھ دن کام کرنا، لیکن ساتواں دن ہر طرح سے آرام کا دن ہے۔ اُس دن مُقدّس اجتماع ہو۔ جہاں بھی تم رہتے ہو وہاں کام نہ کرنا۔ یہ دن رب کے لئے مخصوص سبت ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","یہ رب کی عیدیں ہیں جن پر تمہیں لوگوں کو مُقدّس اجتماع کے لئے جمع کرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","فسح کی عید پہلے مہینے کے چودھویں دن شروع ہوتی ہے۔ اُس دن سورج کے غروب ہونے پر رب کی خوشی منائی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","اگلے دن رب کی یاد میں بےخمیری روٹی کی عید شروع ہوتی ہے۔ سات دن تک تمہاری روٹی میں خمیر نہ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","اِن سات دنوں کے پہلے دن مُقدّس اجتماع ہو اور لوگ اپنا ہر کام چھوڑیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","اِن سات دنوں میں روزانہ رب کو جلنے والی قربانی پیش کرو۔ ساتویں دن بھی مُقدّس اجتماع ہو اور لوگ اپنا ہر کام چھوڑیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","”اسرائیلیوں کو بتانا کہ جب تم اُس ملک میں داخل ہو گے جو مَیں تمہیں دوں گا اور وہاں اناج کی فصل کاٹو گے تو تمہیں امام کو پہلا پُولا دینا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","اتوار کو امام یہ پُولا رب کے سامنے ہلائے تاکہ تم منظور ہو جاؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","اُس دن بھیڑ کا ایک یک سالہ بےعیب بچہ بھی رب کو پیش کرنا۔ اُسے قربان گاہ پر بھسم ہونے والی قربانی کے طور پر چڑھانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ساتھ ہی غلہ کی نذر کے لئے تیل سے ملایا گیا 3 کلو گرام بہترین میدہ بھی پیش کرنا۔ جلنے والی یہ قربانی رب کو پسند ہے۔ اِس کے علاوہ مَے کی نذر کے لئے ایک لٹر مَے بھی پیش کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","پہلے یہ سب کچھ کرو، پھر ہی تمہیں نئی فصل کے اناج سے کھانے کی اجازت ہو گی، خواہ وہ بُھنا ہوا ہو، خواہ کچا یا روٹی کی صورت میں پکایا گیا ہو۔ جہاں بھی تم رہتے ہو وہاں ایسا ہی کرنا ہے۔ یہ اصول ابد تک قائم رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","جس دن تم نے اناج کا پُولا پیش کیا اُس دن سے پورے سات ہفتے گنو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","پچاسویں دن یعنی ساتویں اتوار کو رب کو نئے اناج کی قربانی چڑھانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ہر گھرانے کی طرف سے رب کو ہلانے والی قربانی کے طور پر دو روٹیاں پیش کی جائیں۔ ہر روٹی کے لئے 3 کلو گرام بہترین میدہ استعمال کیا جائے۔ اُن میں خمیر ڈال کر پکانا ہے۔ یہ فصل کی پہلی پیداوار کی قربانی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","اِن روٹیوں کے ساتھ ایک جوان بَیل، دو مینڈھے اور بھیڑ کے سات بےعیب اور یک سالہ بچے پیش کرو۔ اُنہیں رب کے حضور بھسم ہونے والی قربانی کے طور پر چڑھانا۔ اِس کے علاوہ غلہ کی نذر اور مَے کی نذر بھی پیش کرنی ہے۔ جلنے والی اِس قربانی کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","پھر گناہ کی قربانی کے لئے ایک بکرا اور سلامتی کی قربانی کے لئے دو یک سالہ بھیڑ کے بچے چڑھاؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","امام بھیڑ کے یہ دو بچے مذکورہ روٹیوں سمیت ہلانے والی قربانی کے طور پر رب کے سامنے ہلائے۔ یہ رب کے لئے مخصوص و مُقدّس ہیں اور قربانیوں میں سے امام کا حصہ ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","اُسی دن لوگوں کو مُقدّس اجتماع کے لئے جمع کرو۔ کوئی بھی کام نہ کرنا۔ یہ اصول ابد تک قائم رہے، اور اِسے ہر جگہ ماننا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","کٹائی کے وقت اپنی فصل پورے طور پر نہ کاٹنا بلکہ کھیت کے کناروں پر کچھ چھوڑ دینا۔ اِس طرح جو کچھ کٹائی کرتے وقت کھیت میں بچ جائے اُسے چھوڑنا۔ بچا ہوا اناج غریبوں اور پردیسیوں کے لئے چھوڑ دینا۔ مَیں رب تمہارا خدا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","”اسرائیلیوں کو بتانا کہ ساتویں مہینے کا پہلا دن آرام کا دن ہے۔ اُس دن مُقدّس اجتماع ہو جس پر یاد دلانے کے لئے نرسنگا پھونکا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","کوئی بھی کام نہ کرنا۔ رب کو جلنے والی قربانی پیش کرنا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","”ساتویں مہینے کا دسواں دن کفارہ کا دن ہے۔ اُس دن مُقدّس اجتماع ہو۔ اپنی جان کو دُکھ دینا اور رب کو جلنے والی قربانی پیش کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","اُس دن کام نہ کرنا، کیونکہ یہ کفارہ کا دن ہے، جب رب تمہارے خدا کے سامنے تمہارا کفارہ دیا جاتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","جو اُس دن اپنی جان کو دُکھ نہیں دیتا اُسے اُس کی قوم میں سے مٹایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","جو اُس دن کام کرتا ہے اُسے مَیں اُس کی قوم میں سے نکال کر ہلاک کروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","کوئی بھی کام نہ کرنا۔ یہ اصول ابد تک قائم رہے، اور اِسے ہر جگہ ماننا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","یہ دن آرام کا خاص دن ہے جس میں تمہیں اپنی جان کو دُکھ دینا ہے۔ اِسے مہینے کے نویں دن کی شام سے لے کر اگلی شام تک منانا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","”اسرائیلیوں کو بتانا کہ ساتویں مہینے کے پندرھویں دن جھونپڑیوں کی عید شروع ہوتی ہے۔ اِس کا دورانیہ سات دن ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","پہلے دن مُقدّس اجتماع ہو۔ اِس دن کوئی کام نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","اِن سات دنوں کے دوران رب کو جلنے والی قربانیاں پیش کرنا۔ آٹھویں دن مُقدّس اجتماع ہو۔ رب کو جلنے والی قربانی پیش کرو۔ اِس خاص اجتماع کے دن بھی کام نہیں کرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","یہ رب کی عیدیں ہیں جن پر تمہیں مُقدّس اجتماع کرنا ہے تاکہ رب کو روزمرہ کی مطلوبہ جلنے والی قربانیاں اور مَے کی نذریں پیش کی جائیں یعنی بھسم ہونے والی قربانیاں، غلہ کی نذریں، ذبح کی قربانیاں اور مَے کی نذریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","یہ قربانیاں اُن قربانیوں کے علاوہ ہیں جو سبت کے دن چڑھائی جاتی ہیں اور جو تم نے ہدیئے کے طور پر یا مَنت مان کر یا اپنی دلی خوشی سے پیش کی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","چنانچہ ساتویں مہینے کے پندرھویں دن فصل کی کٹائی کے اختتام پر رب کی یہ عید یعنی جھونپڑیوں کی عید مناؤ۔ اِسے سات دن منانا۔ پہلا اور آخری دن آرام کے دن ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","پہلے دن اپنے لئے درختوں کے بہترین پھل، کھجور کی ڈالیاں اور گھنے درختوں اور سفیدہ کی شاخیں توڑنا۔ سات دن تک رب اپنے خدا کے سامنے خوشی مناؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ہر سال ساتویں مہینے میں رب کی خوشی میں یہ عید منانا۔ یہ اصول ابد تک قائم رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","عید کے ہفتے کے دوران جھونپڑیوں میں رہنا۔ تمام ملک میں آباد اسرائیلی ایسا کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","پھر تمہاری اولاد جانے گی کہ اسرائیلیوں کو مصر سے نکالتے وقت مَیں نے اُنہیں جھونپڑیوں میں بسایا۔ مَیں رب تمہارا خدا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","موسیٰ نے اسرائیلیوں کو رب کی عیدوں کے بارے میں یہ باتیں بتائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","”اسرائیلیوں کو حکم دے کہ وہ تیرے پاس کوٹے ہوئے زیتونوں کا خالص تیل لے آئیں تاکہ مُقدّس کمرے کے شمع دان کے چراغ متواتر جلتے رہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ہارون اُنہیں مسلسل، شام سے لے کر صبح تک رب کے حضور سنبھالے یعنی وہاں جہاں وہ مُقدّس ترین کمرے کے پردے کے سامنے پڑے ہیں، اُس پردے کے سامنے جس کے پیچھے عہد کا صندوق ہے۔ یہ اصول ابد تک قائم رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","وہ خالص سونے کے شمع دان پر لگے چراغوں کی دیکھ بھال یوں کرے کہ یہ ہمیشہ رب کے سامنے جلتے رہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","بارہ روٹیاں پکانا۔ ہر روٹی کے لئے 3 کلو گرام بہترین میدہ استعمال کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","اُنہیں دو قطاروں میں رب کے سامنے خالص سونے کی میز پر رکھنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ہر قطار پر خالص لُبان ڈالنا۔ یہ لُبان روٹی کے لئے یادگاری کی قربانی ہے جسے بعد میں رب کے لئے جلانا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ہر ہفتے کو رب کے سامنے تازہ روٹیاں اِسی ترتیب سے میز پر رکھنی ہیں۔ یہ اسرائیلیوں کے لئے ابدی عہد کی لازمی شرط ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","میز کی روٹیاں ہارون اور اُس کے بیٹوں کا حصہ ہیں، اور وہ اُنہیں مُقدّس جگہ پر کھائیں، کیونکہ وہ جلنے والی قربانیوں کا مُقدّس ترین حصہ ہیں۔ یہ ابد تک اُن کا حق رہے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_10‏","004_24_10‏","LEV","24","10‏","11","خیمہ گاہ میں ایک آدمی تھا جس کا باپ مصری اور ماں اسرائیلی تھی۔ ماں کا نام سلومیت تھا۔ وہ دِبری کی بیٹی اور دان کے قبیلے کی تھی۔ ایک دن یہ آدمی خیمہ گاہ میں کسی اسرائیلی سے جھگڑنے لگا۔ لڑتے لڑتے اُس نے رب کے نام پر کفر بک کر اُس پر لعنت بھیجی۔ یہ سن کر لوگ اُسے موسیٰ کے پاس لے آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","وہاں اُنہوں نے اُسے پہرے میں بٹھا کر رب کی ہدایت کا انتظار کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","تب رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","”لعنت کرنے والے کو خیمہ گاہ کے باہر لے جاؤ۔ جنہوں نے اُس کی یہ باتیں سنی ہیں وہ سب اپنے ہاتھ اُس کے سر پر رکھیں۔ پھر پوری جماعت اُسے سنگسار کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","اسرائیلیوں سے کہنا کہ جو بھی اپنے خدا پر لعنت بھیجے اُسے اپنے قصور کے نتیجے برداشت کرنے پڑیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","جو بھی رب کے نام پر کفر بکے اُسے سزائے موت دی جائے۔ پوری جماعت اُسے سنگسار کرے۔ جس نے رب کے نام پر کفر بکا ہو اُسے ضرور سزائے موت دینی ہے، خواہ دیسی ہو یا پردیسی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","جس نے کسی کو مار ڈالا ہے اُسے سزائے موت دی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","جس نے کسی کے جانور کو مار ڈالا ہے وہ اُس کا معاوضہ دے۔ جان کے بدلے جان دی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","اگر کسی نے کسی کو زخمی کر دیا ہے تو وہی کچھ اُس کے ساتھ کیا جائے جو اُس نے دوسرے کے ساتھ کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","اگر دوسرے کی کوئی ہڈی ٹوٹ جائے تو اُس کی وہی ہڈی توڑی جائے۔ اگر دوسرے کی آنکھ ضائع ہو جائے تو اُس کی آنکھ ضائع کر دی جائے۔ اگر دوسرے کا دانت ٹوٹ جائے تو اُس کا وہی دانت توڑا جائے۔ جو بھی زخم اُس نے دوسرے کو پہنچایا وہی زخم اُسے پہنچایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","جس نے کسی جانور کو مار ڈالا ہے وہ اُس کا معاوضہ دے، لیکن جس نے کسی انسان کو مار دیا ہے اُسے سزائے موت دینی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","دیسی اور پردیسی کے لئے تمہارا ایک ہی قانون ہو۔ مَیں رب تمہارا خدا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","پھر موسیٰ نے اسرائیلیوں سے بات کی، اور اُنہوں نے رب پر لعنت بھیجنے والے کو خیمہ گاہ سے باہر لے جا کر اُسے سنگسار کیا۔ اُنہوں نے ویسا ہی کیا جیسا رب نے موسیٰ کو حکم دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","رب نے سینا پہاڑ پر موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","”اسرائیلیوں کو بتانا کہ جب تم اُس ملک میں داخل ہو گے جو مَیں تمہیں دوں گا تو لازم ہے کہ رب کی تعظیم میں زمین ایک سال آرام کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","چھ سال کے دوران اپنے کھیتوں میں بیج بونا، اپنے انگور کے باغوں کی کانٹ چھانٹ کرنا اور اُن کی فصلیں جمع کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","لیکن ساتواں سال زمین کے لئے آرام کا سال ہے، رب کی تعظیم میں سبت کا سال۔ اُس سال نہ اپنے کھیتوں میں بیج بونا، نہ اپنے انگور کے باغوں کی کانٹ چھانٹ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","جو اناج خود بخود اُگتا ہے اُس کی کٹائی نہ کرنا اور جو انگور اُس سال لگتے ہیں اُن کو توڑ کر جمع نہ کرنا، کیونکہ زمین کو ایک سال کے لئے آرام کرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","البتہ جو بھی یہ زمین آرام کے سال میں پیدا کرے گی اُس سے تم اپنی روزانہ کی ضروریات پوری کر سکتے ہو یعنی تُو، تیرے غلام اور لونڈیاں، تیرے مزدور، تیرے غیرشہری، تیرے ساتھ رہنے والے پردیسی، ");
INSERT INTO urdgvu_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","تیرے مویشی اور تیری زمین پر رہنے والے جنگلی جانور۔ جو کچھ بھی یہ زمین پیدا کرتی ہے وہ کھایا جا سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","سات سبت کے سال یعنی 49 سال کے بعد ایک اَور کام کرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","پچاسویں سال کے ساتویں مہینے کے دسویں دن یعنی کفارہ کے دن اپنے ملک کی ہر جگہ نرسنگا بجانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","پچاسواں سال مخصوص و مُقدّس کرو اور پورے ملک میں اعلان کرو کہ تمام باشندوں کو آزاد کر دیا جائے۔ یہ بحالی کا سال ہو جس میں ہر شخص کو اُس کی ملکیت واپس کی جائے اور ہر غلام کو آزاد کیا جائے تاکہ وہ اپنے رشتے داروں کے پاس واپس جا سکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","یہ پچاسواں سال بحالی کا سال ہو، اِس لئے نہ اپنے کھیتوں میں بیج بونا، نہ خود بخود اُگنے والے اناج کی کٹائی کرنا، اور نہ انگور توڑ کر جمع کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","کیونکہ یہ بحالی کا سال ہے جو تمہارے لئے مخصوص و مُقدّس ہے۔ روزانہ اُتنی ہی پیداوار لینا کہ ایک دن کی ضروریات پوری ہو جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","بحالی کے سال میں ہر شخص کو اُس کی ملکیت واپس کی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","چنانچہ جب کبھی تم اپنے کسی ہم وطن بھائی کو زمین بیچتے یا اُس سے خریدتے ہو تو اُس سے ناجائز فائدہ نہ اُٹھانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","زمین کی قیمت اِس حساب سے مقرر کی جائے کہ وہ اگلے بحالی کے سال تک کتنے سال فصلیں پیدا کرے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","اگر بہت سال رہ گئے ہوں تو اُس کی قیمت زیادہ ہو گی، اور اگر کم سال رہ گئے ہوں تو اُس کی قیمت کم ہو گی۔ کیونکہ اُن فصلوں کی تعداد بِک رہی ہے جو زمین اگلے بحالی کے سال تک پیدا کر سکتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","اپنے ہم وطن سے ناجائز فائدہ نہ اُٹھانا بلکہ رب اپنے خدا کا خوف ماننا، کیونکہ مَیں رب تمہارا خدا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","میری ہدایات پر عمل کرنا اور میرے احکام کو مان کر اُن کے مطابق چلنا۔ تب تم اپنے ملک میں محفوظ رہو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","زمین اپنی پوری پیداوار دے گی، تم سیر ہو جاؤ گے اور محفوظ رہو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","ہو سکتا ہے کوئی پوچھے، ’ہم ساتویں سال میں کیا کھائیں گے جبکہ ہم بیج نہیں بوئیں گے اور فصل نہیں کاٹیں گے؟‘ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","جواب یہ ہے کہ مَیں چھٹے سال میں زمین کو اِتنی برکت دوں گا کہ اُس سال کی پیداوار تین سال کے لئے کافی ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","جب تم آٹھویں سال بیج بوؤ گے تو تمہارے پاس چھٹے سال کی اِتنی پیداوار باقی ہو گی کہ تم فصل کی کٹائی تک گزارہ کر سکو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","کوئی زمین بھی ہمیشہ کے لئے نہ بیچی جائے، کیونکہ ملک کی تمام زمین میری ہی ہے۔ تم میرے حضور صرف پردیسی اور غیرشہری ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ملک میں جہاں بھی زمین بِک جائے وہاں موروثی مالک کا یہ حق مانا جائے کہ وہ اپنی زمین واپس خرید سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","اگر تیرا کوئی ہم وطن بھائی غریب ہو کر اپنی کچھ زمین بیچنے پر مجبور ہو جائے تو لازم ہے کہ اُس کا سب سے قریبی رشتے دار اُسے واپس خرید لے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ہو سکتا ہے کہ ایسے شخص کا کوئی قریبی رشتے دار نہ ہو جو اُس کی زمین واپس خرید سکے، لیکن وہ خود کچھ دیر کے بعد اِتنے پیسے جمع کرتا ہے کہ وہ اپنی زمین واپس خرید سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","اِس صورت میں وہ حساب کرے کہ خریدنے والے کے لئے اگلے بحالی کے سال تک کتنے سال رہ گئے ہیں۔ جتنا نقصان خریدنے والے کو زمین کو بحالی کے سال سے پہلے واپس دینے سے پہنچے گا اُتنے ہی پیسے اُسے دینے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","لیکن اگر اُس کے پاس اِتنے پیسے نہ ہوں تو زمین اگلے بحالی کے سال تک خریدنے والے کے ہاتھ میں رہے گی۔ پھر اُسے موروثی مالک کو واپس دیا جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","اگر کسی کا گھر فصیل دار شہر میں ہے تو جب وہ اُسے بیچے گا تو اپنا گھر واپس خریدنے کا حق صرف ایک سال تک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","اگر پہلا مالک اُسے پہلے سال کے اندر اندر نہ خریدے تو وہ ہمیشہ کے لئے خریدنے والے کی موروثی ملکیت بن جائے گا۔ وہ بحالی کے سال میں بھی واپس نہیں کیا جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","لیکن جو گھر ایسی آبادی میں ہے جس کی فصیل نہ ہو وہ دیہات میں شمار کیا جاتا ہے۔ اُس کے موروثی مالک کو حق حاصل ہے کہ ہر وقت اپنا گھر واپس خرید سکے۔ بحالی کے سال میں اِس گھر کو لازماً واپس کر دینا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","لیکن لاویوں کو یہ حق حاصل ہے کہ وہ اپنے وہ گھر ہر وقت خرید سکتے ہیں جو اُن کے لئے مقرر کئے ہوئے شہروں میں ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","اگر ایسا گھر کسی لاوی کے ہاتھ فروخت کیا جائے اور واپس نہ خریدا جائے تو اُسے لازماً بحالی کے سال میں واپس کرنا ہے۔ کیونکہ لاوی کے جو گھر اُن کے مقررہ شہروں میں ہوتے ہیں وہ اسرائیلیوں میں اُن کی موروثی ملکیت ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","لیکن جو زمینیں شہروں کے ارد گرد مویشی چَرانے کے لئے مقرر ہیں اُنہیں بیچنے کی اجازت نہیں ہے۔ وہ اُن کی دائمی ملکیت ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","اگر تیرا کوئی ہم وطن بھائی غریب ہو جائے اور گزارہ نہ کر سکے تو اُس کی مدد کر۔ اُس طرح اُس کی مدد کرنا جس طرح پردیسی یا غیرشہری کی مدد کرنی ہوتی ہے تاکہ وہ تیرے ساتھ رہتے ہوئے زندگی گزار سکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","اُس سے کسی طرح کا سود نہ لینا بلکہ اپنے خدا کا خوف ماننا تاکہ تیرا بھائی تیرے ساتھ زندگی گزار سکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","اگر وہ تیرا قرض دار ہو تو اُس سے سود نہ لینا۔ اِسی طرح خوراک بیچتے وقت اُس سے نفع نہ لینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","مَیں رب تمہارا خدا ہوں۔ مَیں تمہیں اِس لئے مصر سے نکال لایا کہ تمہیں ملکِ کنعان دوں اور تمہارا خدا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","اگر تیرا کوئی اسرائیلی بھائی غریب ہو کر اپنے آپ کو تیرے ہاتھ بیچ ڈالے تو اُس سے غلام کا سا کام نہ کرانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","اُس کے ساتھ مزدور یا غیرشہری کا سا سلوک کرنا۔ وہ تیرے لئے بحالی کے سال تک کام کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","پھر وہ اور اُس کے بال بچے آزاد ہو کر اپنے رشتے داروں اور موروثی زمین کے پاس واپس جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","چونکہ اسرائیلی میرے خادم ہیں جنہیں مَیں مصر سے نکال لایا اِس لئے اُنہیں غلامی میں نہ بیچا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ایسے لوگوں پر سختی سے حکمرانی نہ کرنا بلکہ اپنے خدا کا خوف ماننا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","تم پڑوسی ممالک سے اپنے لئے غلام اور لونڈیاں حاصل کر سکتے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","جو پردیسی غیرشہری کے طور پر تمہارے ملک میں آباد ہیں اُنہیں بھی تم خرید سکتے ہو۔ اُن میں وہ بھی شامل ہیں جو تمہارے ملک میں پیدا ہوئے ہیں۔ وہی تمہاری ملکیت بن کر ");
INSERT INTO urdgvu_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","تمہارے بیٹوں کی میراث میں آ جائیں اور وہی ہمیشہ تمہارے غلام رہیں۔ لیکن اپنے ہم وطن بھائیوں پر سخت حکمرانی نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","اگر تیرے ملک میں رہنے والا کوئی پردیسی یا غیرشہری امیر ہو جائے جبکہ تیرا کوئی ہم وطن بھائی غریب ہو کر اپنے آپ کو اُس پردیسی یا غیرشہری یا اُس کے خاندان کے کسی فرد کو بیچ ڈالے ");
INSERT INTO urdgvu_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","تو بِک جانے کے بعد اُسے آزادی خریدنے کا حق حاصل ہے۔ کوئی بھائی، ");
INSERT INTO urdgvu_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","چچا، تایا، چچا یا تایا کا بیٹا یا کوئی اَور قریبی رشتے دار اُسے واپس خرید سکتا ہے۔ وہ خود بھی اپنی آزادی خرید سکتا ہے اگر اُس کے پاس پیسے کافی ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","اِس صورت میں وہ اپنے مالک سے مل کر وہ سال گنے جو اُس کے خریدنے سے لے کر اگلے بحالی کے سال تک باقی ہیں۔ اُس کی آزادی کے پیسے اُس قیمت پر مبنی ہوں جو مزدور کو اِتنے سالوں کے لئے دیئے جاتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_51‏","004_25_51‏","LEV","25","51‏","52","جتنے سال باقی رہ گئے ہیں اُن کے مطابق اُس کی بِک جانے کی قیمت میں سے پیسے واپس کر دیئے جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","اُس کے ساتھ سال بہ سال مزدور کا سا سلوک کیا جائے۔ اُس کا مالک اُس پر سخت حکمرانی نہ کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","اگر وہ اِس طرح کے کسی طریقے سے آزاد نہ ہو جائے تو اُسے اور اُس کے بچوں کو ہر حالت میں اگلے بحالی کے سال میں آزاد کر دینا ہے، ");
INSERT INTO urdgvu_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","کیونکہ اسرائیلی میرے ہی خادم ہیں۔ وہ میرے ہی خادم ہیں جنہیں مَیں مصر سے نکال لایا۔ مَیں رب تمہارا خدا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","اپنے لئے بُت نہ بنانا۔ نہ اپنے لئے دیوتا کے مجسمے یا پتھر کے مخصوص کئے ہوئے ستون کھڑے کرنا، نہ سجدہ کرنے کے لئے اپنے ملک میں ایسے پتھر رکھنا جن میں دیوتا کی تصویر کندہ کی گئی ہو۔ مَیں رب تمہارا خدا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","سبت کا دن منانا اور میرے مقدِس کی تعظیم کرنا۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","اگر تم میری ہدایات پر چلو اور میرے احکام مان کر اُن پر عمل کرو ");
INSERT INTO urdgvu_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","تو مَیں وقت پر بارش بھیجوں گا، زمین اپنی پیداوار دے گی اور درخت اپنے اپنے پھل لائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","کثرت کے باعث اناج کی فصل کی کٹائی انگور توڑتے وقت تک جاری رہے گی اور انگور کی فصل اُس وقت تک توڑی جائے گی جب تک بیج بونے کا موسم آئے گا۔ اِتنی خوراک ملے گی کہ تم کبھی بھوکے نہیں ہو گے۔ اور تم اپنے ملک میں محفوظ رہو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","مَیں ملک کو امن و امان بخشوں گا۔ تم آرام سے لیٹ جاؤ گے، کیونکہ کسی خطرے سے ڈرنے کی ضرورت نہیں ہو گی۔ مَیں وحشی جانور ملک سے دُور کر دوں گا، اور وہ تلوار کی قتل و غارت سے بچا رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","تم اپنے دشمنوں پر غالب آ کر اُن کا تعاقب کرو گے، اور وہ تمہاری تلوار سے مارے جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","تمہارے پانچ آدمی سَو دشمنوں کا پیچھا کریں گے، اور تمہارے سَو آدمی اُن کے دس ہزار آدمیوں کو بھگا دیں گے۔ تمہارے دشمن تمہاری تلوار سے مارے جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","میری نظرِ کرم تم پر ہو گی۔ مَیں تمہاری اولاد کی تعداد بڑھاؤں گا اور تمہارے ساتھ اپنا عہد قائم رکھوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","ایک سال اِتنی فصل ہو گی کہ جب اگلی فصل کی کٹائی ہو گی تو نئے اناج کے لئے جگہ بنانے کی خاطر پرانے اناج کو پھینک دینا پڑے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","مَیں تمہارے درمیان اپنا مسکن قائم کروں گا اور تم سے گھن نہیں کھاؤں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","مَیں تم میں پھروں گا، اور تم میری قوم ہو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","مَیں رب تمہارا خدا ہوں جو تمہیں مصر سے نکال لایا تاکہ تمہاری غلامی کی حالت ختم ہو جائے۔ مَیں نے تمہارے جوئے کو توڑ ڈالا، اور اب تم آزاد اور سیدھے ہو کر چل سکتے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","لیکن اگر تم میری نہیں سنو گے اور اِن تمام احکام پر نہیں چلو گے، ");
INSERT INTO urdgvu_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","اگر تم میری ہدایات کو رد کر کے میرے احکام سے گھن کھاؤ گے اور اُن پر عمل نہ کر کے میرا عہد توڑو گے ");
INSERT INTO urdgvu_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","تو مَیں جواب میں تم پر اچانک دہشت طاری کر دوں گا۔ جسم کو ختم کرنے والی بیماریوں اور بخار سے تمہاری آنکھیں ضائع ہو جائیں گی اور تمہاری جان چھن جائے گی۔ جب تم بیج بوؤ گے تو بےفائدہ، کیونکہ دشمن اُس کی فصل کھا جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","مَیں تمہارے خلاف ہو جاؤں گا، اِس لئے تم اپنے دشمنوں کے ہاتھ سے شکست کھاؤ گے۔ تم سے نفرت رکھنے والے تم پر حکومت کریں گے۔ اُس وقت بھی جب کوئی تمہارا تعاقب نہیں کرے گا تم بھاگ جاؤ گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","اگر تم اِس کے بعد بھی میری نہ سنو تو مَیں تمہارے گناہوں کے سبب سے تمہیں سات گُنا زیادہ سزا دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","مَیں تمہارا سخت غرور خاک میں ملا دوں گا۔ تمہارے اوپر آسمان لوہے جیسا اور تمہارے نیچے زمین پیتل جیسی ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","جتنی بھی محنت کرو گے وہ بےفائدہ ہو گی، کیونکہ تمہارے کھیتوں میں فصلیں نہیں پکیں گی اور تمہارے درخت پھل نہیں لائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","اگر تم پھر بھی میری مخالفت کرو گے اور میری نہیں سنو گے تو مَیں اِن گناہوں کے جواب میں تمہیں اِس سے بھی سات گُنا زیادہ سزا دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","مَیں تمہارے خلاف جنگلی جانور بھیج دوں گا جو تمہارے بچوں کو پھاڑ کھائیں گے اور تمہارے مویشی برباد کر دیں گے۔ آخر میں تمہاری تعداد اِتنی کم ہو جائے گی کہ تمہاری سڑکیں ویران ہو جائیں گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","اگر تم پھر بھی میری تربیت قبول نہ کرو بلکہ میرے مخالف رہو ");
INSERT INTO urdgvu_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","تو مَیں خود تمہارے خلاف ہو جاؤں گا۔ اِن گناہوں کے جواب میں مَیں تمہیں سات گُنا زیادہ سزا دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","مَیں تم پر تلوار چلا کر اِس کا بدلہ لوں گا کہ تم نے میرے عہد کو توڑا ہے۔ جب تم اپنی حفاظت کے لئے شہروں میں بھاگ کر جمع ہو گے تو مَیں تمہارے درمیان وبائی بیماریاں پھیلاؤں گا اور تمہیں دشمنوں کے ہاتھ میں دے دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","اناج کی اِتنی کمی ہو گی کہ دس عورتیں تمہاری پوری روٹی ایک ہی تنور میں پکا سکیں گی، اور وہ اُسے بڑی احتیاط سے تول تول کر تقسیم کریں گی۔ تم کھا کر بھی بھوکے رہو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","اگر تم پھر بھی میری نہیں سنو گے بلکہ میرے مخالف رہو گے ");
INSERT INTO urdgvu_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","تو میرا غصہ بھڑکے گا اور مَیں تمہارے خلاف ہو کر تمہارے گناہوں کے جواب میں تمہیں سات گُنا زیادہ سزا دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","تم مصیبت کے باعث اپنے بیٹے بیٹیوں کا گوشت کھاؤ گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","مَیں تمہاری اونچی جگہوں کی قربان گاہیں اور تمہاری بخور کی قربان گاہیں برباد کر دوں گا۔ مَیں تمہاری لاشوں کے ڈھیر تمہارے بےجان بُتوں پر لگاؤں گا اور تم سے گھن کھاؤں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","مَیں تمہارے شہروں کو کھنڈرات میں بدل کر تمہارے مندروں کو برباد کروں گا۔ تمہاری قربانیوں کی خوشبو مجھے پسند نہیں آئے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","مَیں تمہارے ملک کا ستیاناس یوں کروں گا کہ جو دشمن اُس میں آباد ہو جائیں گے اُن کے رونگٹے کھڑے ہو جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","مَیں تمہیں مختلف ممالک میں منتشر کر دوں گا، لیکن وہاں بھی اپنی تلوار کو ہاتھ میں لئے تمہارا پیچھا کروں گا۔ تمہاری زمین ویران ہو گی اور تمہارے شہر کھنڈرات بن جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","اُس وقت جب تم اپنے دشمنوں کے ملک میں رہو گے تمہاری زمین ویران حالت میں آرام کے وہ سال منا سکے گی جن سے وہ محروم رہی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","اُن تمام دنوں میں جب وہ برباد رہے گی اُسے وہ آرام ملے گا جو اُسے نہ ملا جب تم ملک میں رہتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","تم میں سے جو بچ کر اپنے دشمنوں کے ممالک میں رہیں گے اُن کے دلوں پر مَیں دہشت طاری کروں گا۔ وہ ہَوا کے جھونکوں سے گرنے والے پتے کی آواز سے چونک کر بھاگ جائیں گے۔ وہ فرار ہوں گے گویا کوئی ہاتھ میں تلوار لئے اُن کا تعاقب کر رہا ہو۔ اور وہ گر کر مر جائیں گے حالانکہ کوئی اُن کا پیچھا نہیں کر رہا ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","وہ ایک دوسرے سے ٹکرا کر لڑکھڑائیں گے گویا کوئی تلوار لے کر اُن کے پیچھے چل رہا ہو حالانکہ کوئی نہیں ہے۔ چنانچہ تم اپنے دشمنوں کا سامنا نہیں کر سکو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","تم دیگر قوموں میں منتشر ہو کر ہلاک ہو جاؤ گے، اور تمہارے دشمنوں کی زمین تمہیں ہڑپ کر لے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","تم میں سے باقی لوگ اپنے اور اپنے باپ دادا کے قصور کے باعث اپنے دشمنوں کے ممالک میں گل سڑ جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","لیکن ایک وقت آئے گا کہ وہ اپنے اور اپنے باپ دادا کا قصور مان لیں گے۔ وہ میرے ساتھ اپنی بےوفائی اور وہ مخالفت تسلیم کریں گے ");
INSERT INTO urdgvu_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","جس کے سبب سے مَیں اُن کے خلاف ہوا اور اُنہیں اُن کے دشمنوں کے ملک میں دھکیل دیا تھا۔ پہلے اُن کا ختنہ صرف ظاہری طور پر ہوا تھا، لیکن اب اُن کا دل عاجز ہو جائے گا اور وہ اپنے قصور کی قیمت ادا کریں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","پھر مَیں ابراہیم کے ساتھ اپنا عہد، اسحاق کے ساتھ اپنا عہد اور یعقوب کے ساتھ اپنا عہد یاد کروں گا۔ مَیں ملکِ کنعان بھی یاد کروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","لیکن پہلے وہ زمین کو چھوڑیں گے تاکہ وہ اُن کی غیرموجودگی میں ویران ہو کر آرام کے سال منائے۔ یوں اسرائیلی اپنے قصور کے نتیجے بھگتیں گے، اِس سبب سے کہ اُنہوں نے میرے احکام رد کئے اور میری ہدایات سے گھن کھائی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","اِس کے باوجود بھی مَیں اُنہیں دشمنوں کے ملک میں چھوڑ کر رد نہیں کروں گا، نہ یہاں تک اُن سے گھن کھاؤں گا کہ وہ بالکل تباہ ہو جائیں۔ کیونکہ مَیں اُن کے ساتھ اپنا عہد نہیں توڑنے کا۔ مَیں رب اُن کا خدا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","مَیں اُن کی خاطر اُن کے باپ دادا کے ساتھ بندھا ہوا عہد یاد کروں گا، اُن لوگوں کے ساتھ عہد جنہیں مَیں دوسری قوموں کے دیکھتے دیکھتے مصر سے نکال لایا تاکہ اُن کا خدا ہوں۔ مَیں رب ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","رب نے موسیٰ کو اسرائیلیوں کے لئے یہ تمام ہدایات اور احکام سینا پہاڑ پر دیئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","”اسرائیلیوں کو بتانا کہ اگر کسی نے مَنت مان کر کسی کو رب کے لئے مخصوص کیا ہو تو وہ اُسے ذیل کی رقم دے کر آزاد کر سکتا ہے (مستعمل سِکے مقدِس کے سِکوں کے برابر ہوں): ");
INSERT INTO urdgvu_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","اُس آدمی کے لئے جس کی عمر 20 اور 60 سال کے درمیان ہے چاندی کے 50 سِکے، ");
INSERT INTO urdgvu_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","اِسی عمر کی عورت کے لئے چاندی کے 30 سِکے، ");
INSERT INTO urdgvu_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","اُس لڑکے کے لئے جس کی عمر 5 اور 20 سال کے درمیان ہو چاندی کے 20 سِکے، اِسی عمر کی لڑکی کے لئے چاندی کے 10 سِکے، ");
INSERT INTO urdgvu_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ایک ماہ سے لے کر 5 سال تک کے لڑکے کے لئے چاندی کے 5 سِکے، اِسی عمر کی لڑکی کے لئے چاندی کے 3 سِکے، ");
INSERT INTO urdgvu_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ساٹھ سال سے بڑے آدمی کے لئے چاندی کے 15 سِکے اور اِسی عمر کی عورت کے لئے چاندی کے 10 سِکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","اگر مَنت ماننے والا مقررہ رقم ادا نہ کر سکے تو وہ مخصوص کئے ہوئے شخص کو امام کے پاس لے آئے۔ پھر امام ایسی رقم مقرر کرے جو مَنت ماننے والا ادا کر سکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","اگر کسی نے مَنت مان کر ایسا جانور مخصوص کیا جو رب کی قربانیوں کے لئے استعمال ہو سکتا ہے تو ایسا جانور مخصوص و مُقدّس ہو جاتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","وہ اُسے بدل نہیں سکتا۔ نہ وہ اچھے جانور کی جگہ ناقص، نہ ناقص جانور کی جگہ اچھا جانور دے۔ اگر وہ ایک جانور دوسرے کی جگہ دے تو دونوں مخصوص و مُقدّس ہو جاتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","اگر کسی نے مَنت مان کر کوئی ناپاک جانور مخصوص کیا جو رب کی قربانیوں کے لئے استعمال نہیں ہو سکتا تو وہ اُس کو امام کے پاس لے آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","امام اُس کی رقم اُس کی اچھی اور بُری صفتوں کا لحاظ کر کے مقرر کرے۔ اِس مقررہ قیمت میں کمی بیشی نہیں ہو سکتی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","اگر مَنت ماننے والا اُسے واپس خریدنا چاہے تو وہ مقررہ قیمت جمع 20 فیصد ادا کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","اگر کوئی اپنا گھر رب کے لئے مخصوص و مُقدّس کرے تو امام اُس کی اچھی اور بُری صفتوں کا لحاظ کر کے اُس کی رقم مقرر کرے۔ اِس مقررہ قیمت میں کمی بیشی نہیں ہو سکتی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","اگر گھر کو مخصوص کرنے والا اُسے واپس خریدنا چاہے تو وہ مقررہ رقم جمع 20 فیصد ادا کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","اگر کوئی اپنی موروثی زمین میں سے کچھ رب کے لئے مخصوص و مُقدّس کرے تو اُس کی قیمت اُس بیج کی مقدار کے مطابق مقرر کی جائے جو اُس میں بونا ہوتا ہے۔ جس کھیت میں 135 کلو گرام جَو کا بیج بویا جائے اُس کی قیمت چاندی کے 50 سِکے ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","شرط یہ ہے کہ وہ اپنی زمین بحالی کے سال کے عین بعد مخصوص کرے۔ پھر اُس کی یہی قیمت مقرر کی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","اگر زمین کا مالک اُسے بحالی کے سال کے کچھ دیر بعد مخصوص کرے تو امام اگلے بحالی کے سال تک رہنے والے سالوں کے مطابق زمین کی قیمت مقرر کرے۔ جتنے کم سال باقی ہیں اُتنی کم اُس کی قیمت ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","اگر مخصوص کرنے والا اپنی زمین واپس خریدنا چاہے تو وہ مقررہ قیمت جمع 20 فیصد ادا کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","اگر مخصوص کرنے والا اپنی زمین کو رب سے واپس خریدے بغیر اُسے کسی اَور کو بیچے تو اُسے واپس خریدنے کا حق ختم ہو جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","اگلے بحالی کے سال یہ زمین مخصوص و مُقدّس رہے گی اور رب کی دائمی ملکیت ہو جائے گی۔ چنانچہ وہ امام کی ملکیت ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","اگر کوئی اپنا موروثی کھیت نہیں بلکہ اپنا خریدا ہوا کھیت رب کے لئے مخصوص کرے ");
INSERT INTO urdgvu_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","تو امام اگلے بحالی کے سال تک رہنے والے سالوں کا لحاظ کر کے اُس کی قیمت مقرر کرے۔ کھیت کا مالک اُسی دن اُس کے پیسے ادا کرے۔ یہ پیسے رب کے لئے مخصوص و مُقدّس ہوں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","بحالی کے سال میں یہ کھیت اُس شخص کے پاس واپس آئے گا جس نے اُسے بیچا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","واپس خریدنے کے لئے مستعمل سِکے مقدِس کے سِکوں کے برابر ہوں۔ اُس کے چاندی کے سِکوں کا وزن 11 گرام ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","لیکن کوئی بھی کسی مویشی کا پہلوٹھا رب کے لئے مخصوص نہیں کر سکتا۔ وہ تو پہلے سے رب کے لئے مخصوص ہے۔ اِس میں کوئی فرق نہیں کہ وہ گائے، بَیل یا بھیڑ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","اگر اُس نے کوئی ناپاک جانور مخصوص کیا ہو تو وہ اُسے مقررہ قیمت جمع 20 فیصد کے لئے واپس خرید سکتا ہے۔ اگر وہ اُسے واپس نہ خریدے تو وہ مقررہ قیمت کے لئے بیچا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","لیکن اگر کسی نے اپنی ملکیت میں سے کچھ غیرمشروط طور پر رب کے لئے مخصوص کیا ہے تو اُسے بیچا یا واپس نہیں خریدا جا سکتا، خواہ وہ انسان، جانور یا زمین ہو۔ جو اِس طرح مخصوص کیا گیا ہو وہ رب کے لئے نہایت مُقدّس ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","اِسی طرح جس شخص کو تباہی کے لئے مخصوص کیا گیا ہے اُس کا فدیہ نہیں دیا جا سکتا۔ لازم ہے کہ اُسے سزائے موت دی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","ہر فصل کا دسواں حصہ رب کا ہے، چاہے وہ اناج ہو یا پھل۔ وہ رب کے لئے مخصوص و مُقدّس ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","اگر کوئی اپنی فصل کا دسواں حصہ چھڑانا چاہتا ہے تو وہ اِس کے لئے اُس کی مقررہ قیمت جمع 20 فیصد دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","اِسی طرح گائےبَیلوں اور بھیڑبکریوں کا دسواں حصہ بھی رب کے لئے مخصوص و مُقدّس ہے، ہر دسواں جانور جو گلہ بان کے ڈنڈے کے نیچے سے گزرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","یہ جانور چننے سے پہلے اُن کا معائنہ نہ کیا جائے کہ کون سے جانور اچھے یا کمزور ہیں۔ یہ بھی نہ کرنا کہ دسویں حصے کے کسی جانور کے بدلے کوئی اَور جانور دیا جائے۔ اگر پھر بھی اُسے بدلا جائے تو دونوں جانور رب کے لئے مخصوص و مُقدّس ہوں گے۔ اور اُنہیں واپس خریدا نہیں جا سکتا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","یہ وہ احکام ہیں جو رب نے سینا پہاڑ پر موسیٰ کو اسرائیلیوں کے لئے دیئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","اسرائیلیوں کو مصر سے نکلے ہوئے ایک سال سے زیادہ عرصہ گزر گیا تھا۔ اب تک وہ دشتِ سینا میں تھے۔ دوسرے سال کے دوسرے مہینے کے پہلے دن رب ملاقات کے خیمے میں موسیٰ سے ہم کلام ہوا۔ اُس نے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","”تُو اور ہارون تمام اسرائیلیوں کی مردم شماری کنبوں اور آبائی گھرانوں کے مطابق کرنا۔ اُن تمام مردوں کی فہرست بنانا ");
INSERT INTO urdgvu_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","جو کم از کم بیس سال کے اور جنگ لڑنے کے قابل ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","اِس میں ہر قبیلے کے ایک خاندان کا سرپرست تمہاری مدد کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","یہ اُن کے نام ہیں: روبن کے قبیلے سے اِلی صور بن شدیور، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","شمعون کے قبیلے سے سلومی ایل بن صوری شدی، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","یہوداہ کے قبیلے سے نحسون بن عمی نداب، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","اِشکار کے قبیلے سے نتنی ایل بن ضُغر، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","زبولون کے قبیلے سے اِلیاب بن حیلون، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","یوسف کے بیٹے افرائیم کے قبیلے سے اِلی سمع بن عمی ہود، یوسف کے بیٹے منسّی کے قبیلے سے جملی ایل بن فدا ہصور، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","بن یمین کے قبیلے سے ابدان بن جدعونی، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","دان کے قبیلے سے اخی عزر بن عمی شدی، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","آشر کے قبیلے سے فجعی ایل بن عکران، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","جد کے قبیلے سے اِلیاسف بن دعوایل، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","نفتالی کے قبیلے سے اخیرع بن عینان۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","یہی مرد جماعت سے اِس کام کے لئے بُلائے گئے۔ وہ اپنے قبیلوں کے راہنما اور کنبوں کے سرپرست تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","اِن کی مدد سے موسیٰ اور ہارون نے ");
INSERT INTO urdgvu_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","اُسی دن پوری جماعت کو اکٹھا کیا۔ ہر اسرائیلی مرد جو کم از کم 20 سال کا تھا رجسٹر میں درج کیا گیا۔ رجسٹر کی ترتیب اُن کے کنبوں اور آبائی گھرانوں کے مطابق تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","سب کچھ ویسا ہی کیا گیا جیسا رب نے حکم دیا تھا۔ موسیٰ نے سینا کے ریگستان میں لوگوں کی مردم شماری کی۔ نتیجہ یہ نکلا: ");
INSERT INTO urdgvu_vpl VALUES ("NU1_20‏","005_1_20‏","NUM","1","20‏","21","روبن کے قبیلے کے 46,500 مرد، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_22‏","005_1_22‏","NUM","1","22‏","23","شمعون کے قبیلے کے 59,300 مرد، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_24‏","005_1_24‏","NUM","1","24‏","25","جد کے قبیلے کے 45,650 مرد، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_26‏","005_1_26‏","NUM","1","26‏","27","یہوداہ کے قبیلے کے 74,600 مرد، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_28‏","005_1_28‏","NUM","1","28‏","29","اِشکار کے قبیلے کے 54,400 مرد، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_30‏","005_1_30‏","NUM","1","30‏","31","زبولون کے قبیلے کے 57,400 مرد، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_32‏","005_1_32‏","NUM","1","32‏","33","یوسف کے بیٹے افرائیم کے قبیلے کے 40,500 مرد، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_34‏","005_1_34‏","NUM","1","34‏","35","یوسف کے بیٹے منسّی کے قبیلے کے 32,200 مرد، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_36‏","005_1_36‏","NUM","1","36‏","37","بن یمین کے قبیلے کے 35,400 مرد، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_38‏","005_1_38‏","NUM","1","38‏","39","دان کے قبیلے کے 62,700 مرد، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_40‏","005_1_40‏","NUM","1","40‏","41","آشر کے قبیلے کے 41,500 مرد، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_42‏","005_1_42‏","NUM","1","42‏","43","نفتالی کے قبیلے کے 53,400 مرد۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","موسیٰ، ہارون اور قبیلوں کے بارہ راہنماؤں نے اِن تمام آدمیوں کو گنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU1_45‏","005_1_45‏","NUM","1","45‏","46","اُن کی پوری تعداد 6,03,550 تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","لیکن لاویوں کی مردم شماری نہ ہوئی، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","کیونکہ رب نے موسیٰ سے کہا تھا، ");
INSERT INTO urdgvu_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","”اسرائیلیوں کی مردم شماری میں لاویوں کو شامل نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","اِس کے بجائے اُنہیں شریعت کی سکونت گاہ اور اُس کا سارا سامان سنبھالنے کی ذمہ داری دینا۔ وہ سفر کرتے وقت یہ خیمہ اور اُس کا سارا سامان اُٹھا کر لے جائیں، اُس کی خدمت کے لئے حاضر رہیں اور رُکتے وقت اُسے اپنے خیموں سے گھیرے رکھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","روانہ ہوتے وقت وہی خیمے کو سمیٹیں اور رُکتے وقت وہی اُسے لگائیں۔ اگر کوئی اَور اُس کے قریب آئے تو اُسے سزائے موت دی جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","باقی اسرائیلی خیمہ گاہ میں اپنے اپنے دستے کے مطابق اور اپنے اپنے علَم کے ارد گرد اپنے خیمے لگائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","لیکن لاوی اپنے خیموں سے شریعت کی سکونت گاہ کو گھیر لیں تاکہ میرا غضب کسی غلط شخص کے نزدیک آنے سے اسرائیلیوں کی جماعت پر نازل نہ ہو جائے۔ یوں لاویوں کو شریعت کی سکونت گاہ کو سنبھالنا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","اسرائیلیوں نے ویسا ہی کیا جیسا رب نے موسیٰ کو حکم دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","رب نے موسیٰ اور ہارون سے کہا ");
INSERT INTO urdgvu_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","کہ اسرائیلی اپنے خیمے کچھ فاصلے پر ملاقات کے خیمے کے ارد گرد لگائیں۔ ہر ایک اپنے اپنے علَم اور اپنے اپنے آبائی گھرانے کے نشان کے ساتھ خیمہ زن ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","اِن ہدایات کے مطابق مقدِس کے مشرق میں یہوداہ کا علَم تھا جس کے ارد گرد تین دستے خیمہ زن تھے۔ پہلے، یہوداہ کا قبیلہ جس کا کمانڈر نحسون بن عمی نداب تھا، ");
INSERT INTO urdgvu_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","اور جس کے لشکر کے 74,600 فوجی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","دوسرے، اِشکار کا قبیلہ جس کا کمانڈر نتنی ایل بن ضُغر تھا، ");
INSERT INTO urdgvu_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","اور جس کے لشکر کے 54,400 فوجی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","تیسرے، زبولون کا قبیلہ جس کا کمانڈر اِلیاب بن حیلون تھا ");
INSERT INTO urdgvu_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","اور جس کے لشکر کے 57,400 فوجی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","تینوں قبیلوں کے فوجیوں کی کُل تعداد 1,86,400 تھی۔ روانہ ہوتے وقت یہ آگے چلتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","مقدِس کے جنوب میں روبن کا علَم تھا جس کے ارد گرد تین دستے خیمہ زن تھے۔ پہلے، روبن کا قبیلہ جس کا کمانڈر اِلی صور بن شدیور تھا، ");
INSERT INTO urdgvu_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","اور جس کے 46,500 فوجی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","دوسرے، شمعون کا قبیلہ جس کا کمانڈر سلومی ایل بن صوری شدی تھا، ");
INSERT INTO urdgvu_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","اور جس کے 59,300 فوجی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","تیسرے، جد کا قبیلہ جس کا کمانڈر اِلیاسف بن دعوایل تھا، ");
INSERT INTO urdgvu_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","اور جس کے 45,650 فوجی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","تینوں قبیلوں کے فوجیوں کی کُل تعداد 1,51,450 تھی۔ روانہ ہوتے وقت یہ مشرقی قبیلوں کے پیچھے چلتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","اِن جنوبی قبیلوں کے بعد لاوی ملاقات کا خیمہ اُٹھا کر قبیلوں کے عین بیچ میں چلتے تھے۔ قبیلے اُس ترتیب سے روانہ ہوتے تھے جس ترتیب سے وہ اپنے خیمے لگاتے تھے۔ ہر قبیلہ اپنے علَم کے پیچھے چلتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","مقدِس کے مغرب میں افرائیم کا علَم تھا جس کے ارد گرد تین دستے خیمہ زن تھے۔ پہلے، افرائیم کا قبیلہ جس کا کمانڈر اِلی سمع بن عمی ہود تھا، ");
INSERT INTO urdgvu_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","اور جس کے 40,500 فوجی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","دوسرے، منسّی کا قبیلہ جس کا کمانڈر جملی ایل بن فدا ہصور تھا، ");
INSERT INTO urdgvu_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","اور جس کے 32,200 فوجی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","تیسرے، بن یمین کا قبیلہ جس کا کمانڈر ابدان بن جدعونی تھا، ");
INSERT INTO urdgvu_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","اور جس کے 35,400 فوجی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","تینوں قبیلوں کے فوجیوں کی کُل تعداد 1,08,100 تھی۔ روانہ ہوتے وقت یہ جنوبی قبیلوں کے پیچھے چلتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","مقدِس کے شمال میں دان کا علَم تھا جس کے ارد گرد تین دستے خیمہ زن تھے۔ پہلے، دان کا قبیلہ جس کا کمانڈر اخی عزر بن عمی شدی تھا، ");
INSERT INTO urdgvu_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","اور جس کے 62,700 فوجی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","دوسرے، آشر کا قبیلہ جس کا کمانڈر فجعی ایل بن عکران تھا، ");
INSERT INTO urdgvu_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","اور جس کے 41,500 فوجی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","تیسرے، نفتالی کا قبیلہ جس کا کمانڈر اخیرع بن عینان تھا، ");
INSERT INTO urdgvu_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","اور جس کے 53,400 فوجی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","تینوں قبیلوں کی کُل تعداد 1,57,600 تھی۔ وہ آخر میں اپنا علَم اُٹھا کر روانہ ہوتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","پوری خیمہ گاہ کے فوجیوں کی کُل تعداد 6,03,550 تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","صرف لاوی اِس تعداد میں شامل نہیں تھے، کیونکہ رب نے موسیٰ کو حکم دیا تھا کہ اُن کی بھرتی نہ کی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","یوں اسرائیلیوں نے سب کچھ اُن ہدایات کے مطابق کیا جو رب نے موسیٰ کو دی تھیں۔ اُن کے مطابق ہی وہ اپنے جھنڈوں کے ارد گرد اپنے خیمے لگاتے تھے اور اُن کے مطابق ہی اپنے کنبوں اور آبائی گھرانوں کے ساتھ روانہ ہوتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","یہ ہارون اور موسیٰ کے خاندان کا بیان ہے۔ اُس وقت کا ذکر ہے جب رب نے سینا پہاڑ پر موسیٰ سے بات کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ہارون کے چار بیٹے تھے۔ بڑا بیٹا ندب تھا، پھر ابیہو، اِلی عزر اور اِتمر۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","یہ امام تھے جن کو مسح کر کے اِس خدمت کا اختیار دیا گیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","لیکن ندب اور ابیہو اُس وقت مر گئے جب اُنہوں نے دشتِ سینا میں رب کے حضور ناجائز آگ پیش کی۔ چونکہ وہ بےاولاد تھے اِس لئے ہارون کے جیتے جی صرف اِلی عزر اور اِتمر امام کی خدمت سرانجام دیتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","”لاوی کے قبیلے کو لا کر ہارون کی خدمت کرنے کی ذمہ داری دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","اُنہیں اُس کے لئے اور پوری جماعت کے لئے ملاقات کے خیمے کی خدمات سنبھالنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","وہ ملاقات کے خیمے کا سامان سنبھالیں اور تمام اسرائیلیوں کے لئے مقدِس کے فرائض ادا کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","تمام اسرائیلیوں میں سے صرف لاویوں کو ہارون اور اُس کے بیٹوں کی خدمت کے لئے مقرر کر۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","لیکن صرف ہارون اور اُس کے بیٹوں کو امام کی حیثیت حاصل ہے۔ جو بھی باقیوں میں سے اُن کی ذمہ داریاں اُٹھانے کی کوشش کرے گا اُسے سزائے موت دی جائے گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","رب نے موسیٰ سے یہ بھی کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","”مَیں نے اسرائیلیوں میں سے لاویوں کو چن لیا ہے۔ وہ تمام اسرائیلی پہلوٹھوں کے عوض میرے لئے مخصوص ہیں، ");
INSERT INTO urdgvu_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","کیونکہ تمام پہلوٹھے میرے ہی ہیں۔ جس دن مَیں نے مصر میں تمام پہلوٹھوں کو مار دیا اُس دن مَیں نے اسرائیل کے پہلوٹھوں کو اپنے لئے مخصوص کیا، خواہ وہ انسان کے تھے یا حیوان کے۔ وہ میرے ہی ہیں۔ مَیں رب ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","رب نے سینا کے ریگستان میں موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","”لاویوں کو گن کر اُن کے آبائی گھرانوں اور کنبوں کے مطابق رجسٹر میں درج کرنا۔ ہر بیٹے کو گننا ہے جو ایک ماہ یا اِس سے زائد کا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","موسیٰ نے ایسا ہی کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","لاوی کے تین بیٹے جَیرسون، قِہات اور مِراری تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","جَیرسون کے دو کنبے اُس کے بیٹوں لِبنی اور سِمعی کے نام رکھتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","قِہات کے چار کنبے اُس کے بیٹوں عمرام، اِضہار، حبرون اور عُزی ایل کے نام رکھتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","مِراری کے دو کنبے اُس کے بیٹوں محلی اور مُوشی کے نام رکھتے تھے۔ غرض لاوی کے قبیلے کے کنبے اُس کے پوتوں کے نام رکھتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","جَیرسون کے دو کنبوں بنام لِبنی اور سِمعی ");
INSERT INTO urdgvu_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","کے 7,500 مرد تھے جو ایک ماہ یا اِس سے زائد کے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","اُنہیں اپنے خیمے مغرب میں مقدِس کے پیچھے لگانے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","اُن کا راہنما اِلیاسف بن لائیل تھا، ");
INSERT INTO urdgvu_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","اور وہ خیمے کو سنبھالتے تھے یعنی اُس کی پوششیں، خیمے کے دروازے کا پردہ، ");
INSERT INTO urdgvu_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","خیمے اور قربان گاہ کی چاردیواری کے پردے، چاردیواری کے دروازے کا پردہ اور تمام رسّے۔ اِن چیزوں سے متعلق ساری خدمت اُن کی ذمہ داری تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","قِہات کے چار کنبوں بنام عمرام، اِضہار، حبرون اور عُزی ایل ");
INSERT INTO urdgvu_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","کے 8,600 مرد تھے جو ایک ماہ یا اِس سے زائد کے تھے اور جن کو مقدِس کی خدمت کرنی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","اُنہیں اپنے ڈیرے مقدِس کے جنوب میں ڈالنے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","اُن کا راہنما اِلی صفن بن عُزی ایل تھا، ");
INSERT INTO urdgvu_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","اور وہ یہ چیزیں سنبھالتے تھے: عہد کا صندوق، میز، شمع دان، قربان گاہیں، وہ برتن اور ساز و سامان جو مقدِس میں استعمال ہوتا تھا اور مُقدّس ترین کمرے کا پردہ۔ اِن چیزوں سے متعلق ساری خدمت اُن کی ذمہ داری تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ہارون امام کا بیٹا اِلی عزر لاویوں کے تمام راہنماؤں پر مقرر تھا۔ وہ اُن تمام لوگوں کا انچارج تھا جو مقدِس کی دیکھ بھال کرتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","مِراری کے دو کنبوں بنام محلی اور مُوشی ");
INSERT INTO urdgvu_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","کے 6,200 مرد تھے جو ایک ماہ یا اِس سے زائد کے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","اُن کا راہنما صوری ایل بن ابی خیل تھا۔ اُنہیں اپنے ڈیرے مقدِس کے شمال میں ڈالنے تھے، ");
INSERT INTO urdgvu_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","اور وہ یہ چیزیں سنبھالتے تھے: خیمے کے تختے، اُس کے شہتیر، کھمبے، پائے اور اِس طرح کا سارا سامان۔ اِن چیزوں سے متعلق ساری خدمت اُن کی ذمہ داری تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","وہ چاردیواری کے کھمبے، پائے، میخیں اور رسّے بھی سنبھالتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","موسیٰ، ہارون اور اُن کے بیٹوں کو اپنے ڈیرے مشرق میں مقدِس کے سامنے ڈالنے تھے۔ اُن کی ذمہ داری مقدِس میں بنی اسرائیل کے لئے خدمت کرنا تھی۔ اُن کے علاوہ جو بھی مقدِس میں داخل ہونے کی کوشش کرتا اُسے سزائے موت دینی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","اُن لاوی مردوں کی کُل تعداد جو ایک ماہ یا اِس سے زائد کے تھے 22,000 تھی۔ رب کے کہنے پر موسیٰ اور ہارون نے اُنہیں کنبوں کے مطابق گن کر رجسٹر میں درج کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","رب نے موسیٰ سے کہا، ”تمام اسرائیلی پہلوٹھوں کو گننا جو ایک ماہ یا اِس سے زائد کے ہیں اور اُن کے نام رجسٹر میں درج کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","اُن تمام پہلوٹھوں کی جگہ لاویوں کو میرے لئے مخصوص کرنا۔ اِسی طرح اسرائیلیوں کے مویشیوں کے پہلوٹھوں کی جگہ لاویوں کے مویشی میرے لئے مخصوص کرنا۔ مَیں رب ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","موسیٰ نے ایسا ہی کیا جیسا رب نے اُسے حکم دیا۔ اُس نے تمام اسرائیلی پہلوٹھے ");
INSERT INTO urdgvu_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","جو ایک ماہ یا اِس سے زائد کے تھے گن لئے۔ اُن کی کُل تعداد 22,273 تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","”مجھے تمام اسرائیلی پہلوٹھوں کی جگہ لاویوں کو پیش کرنا۔ اِسی طرح مجھے اسرائیلیوں کے مویشیوں کی جگہ لاویوں کے مویشی پیش کرنا۔ لاوی میرے ہی ہیں۔ مَیں رب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","لاویوں کی نسبت باقی اسرائیلیوں کے 273 پہلوٹھے زیادہ ہیں۔ اُن میں سے ");
INSERT INTO urdgvu_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ہر ایک کے عوض چاندی کے پانچ سِکے لے جو مقدِس کے وزن کے مطابق ہوں (فی سِکہ تقریباً 11 گرام)۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","یہ پیسے ہارون اور اُس کے بیٹوں کو دینا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","موسیٰ نے ایسا ہی کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","یوں اُس نے چاندی کے 1,365 سِکے (تقریباً 16 کلو گرام) جمع کر کے ");
INSERT INTO urdgvu_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ہارون اور اُس کے بیٹوں کو دیئے، جس طرح رب نے اُسے حکم دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","رب نے موسیٰ اور ہارون سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","”لاوی کے قبیلے میں سے قِہاتیوں کی مردم شماری اُن کے کنبوں اور آبائی گھرانوں کے مطابق کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","اُن تمام مردوں کو رجسٹر میں درج کرنا جو 30 سے لے کر 50 سال کے ہیں اور ملاقات کے خیمے میں خدمت کرنے کے لئے آ سکتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","قِہاتیوں کی خدمت مُقدّس ترین کمرے کی دیکھ بھال ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","جب خیمے کو سفر کے لئے سمیٹنا ہے تو ہارون اور اُس کے بیٹے داخل ہو کر مُقدّس ترین کمرے کا پردہ اُتاریں اور اُسے شریعت کے صندوق پر ڈال دیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","اِس پر وہ تخس کی کھالوں کا غلاف اور آخر میں پوری طرح نیلے رنگ کا کپڑا بچھائیں۔ اِس کے بعد وہ صندوق کو اُٹھانے کی لکڑیاں لگائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","وہ اُس میز پر بھی نیلے رنگ کا کپڑا بچھائیں جس پر رب کو روٹی پیش کی جاتی ہے۔ اُس پر تھال، پیالے، مَے کی نذریں پیش کرنے کے برتن اور مرتبان رکھے جائیں۔ جو روٹی ہمیشہ میز پر ہوتی ہے وہ بھی اُس پر رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ہارون اور اُس کے بیٹے اِن تمام چیزوں پر قرمزی رنگ کا کپڑا بچھا کر آخر میں اُن کے اوپر تخس کی کھالوں کا غلاف ڈالیں۔ اِس کے بعد وہ میز کو اُٹھانے کی لکڑیاں لگائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","وہ شمع دان اور اُس کے سامان پر یعنی اُس کے چراغ، بتی کترنے کی قینچیوں، جلتے کوئلے کے چھوٹے برتنوں اور تیل کے برتنوں پر نیلے رنگ کا کپڑا رکھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","یہ سب کچھ وہ تخس کی کھالوں کے غلاف میں لپیٹیں اور اُسے اُٹھا کر لے جانے کے لئے ایک چوکھٹے پر رکھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","وہ بخور جلانے کی سونے کی قربان گاہ پر بھی نیلے رنگ کا کپڑا بچھا کر اُس پر تخس کی کھالوں کا غلاف ڈالیں اور پھر اُسے اُٹھانے کی لکڑیاں لگائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","وہ سارا سامان جو مُقدّس کمرے میں استعمال ہوتا ہے لے کر نیلے رنگ کے کپڑے میں لپیٹیں، اُس پر تخس کی کھالوں کا غلاف ڈالیں اور اُسے اُٹھا کر لے جانے کے لئے ایک چوکھٹے پر رکھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","پھر وہ جانوروں کو جلانے کی قربان گاہ کو راکھ سے صاف کر کے اُس پر ارغوانی رنگ کا کپڑا بچھائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","اُس پر وہ قربان گاہ کی خدمت کے لئے سارا ضروری سامان رکھیں یعنی چھڑکاؤ کے کٹورے، جلتے ہوئے کوئلے کے برتن، بیلچے اور کانٹے۔ اِس سامان پر وہ تخس کی کھالوں کا غلاف ڈال کر قربان گاہ کو اُٹھانے کی لکڑیاں لگائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","سفر کے لئے روانہ ہوتے وقت یہ سب کچھ اُٹھا کر لے جانا قِہاتیوں کی ذمہ داری ہے۔ لیکن لازم ہے کہ پہلے ہارون اور اُس کے بیٹے یہ تمام مُقدّس چیزیں ڈھانپیں۔ قِہاتی اِن میں سے کوئی بھی چیز نہ چھوئیں ورنہ مر جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","ہارون امام کا بیٹا اِلی عزر پورے مُقدّس خیمے اور اُس کے سامان کا انچارج ہو۔ اِس میں چراغوں کا تیل، بخور، غلہ کی روزانہ نذر اور مسح کا تیل بھی شامل ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","رب نے موسیٰ اور ہارون سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","”خبردار رہو کہ قِہات کے کنبے لاوی کے قبیلے میں سے مٹنے نہ پائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","چنانچہ جب وہ مُقدّس ترین چیزوں کے پاس آئیں تو ہارون اور اُس کے بیٹے ہر ایک کو اُس سامان کے پاس لے جائیں جو اُسے اُٹھا کر لے جانا ہے تاکہ وہ نہ مریں بلکہ جیتے رہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","قِہاتی ایک لمحے کے لئے بھی مُقدّس چیزیں دیکھنے کے لئے اندر نہ جائیں، ورنہ وہ مر جائیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","پھر رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","”جَیرسون کی اولاد کی مردم شماری بھی اُن کے آبائی گھرانوں اور کنبوں کے مطابق کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","اُن تمام مردوں کو رجسٹر میں درج کرنا جو 30 سے لے کر 50 سال کے ہیں اور ملاقات کے خیمے میں خدمت کے لئے آ سکتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","وہ یہ چیزیں اُٹھا کر لے جانے کے ذمہ دار ہیں: ");
INSERT INTO urdgvu_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ملاقات کا خیمہ، اُس کی چھت، چھت پر رکھی ہوئی تخس کی کھال کی پوشش، خیمے کے دروازے کا پردہ، ");
INSERT INTO urdgvu_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","خیمے اور قربان گاہ کی چاردیواری کے پردے، چاردیواری کے دروازے کا پردہ، اُس کے رسّے اور اُسے لگانے کا باقی سامان۔ وہ اُن تمام کاموں کے ذمہ دار ہیں جو اِن چیزوں سے منسلک ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","جَیرسونیوں کی پوری خدمت ہارون اور اُس کے بیٹوں کی ہدایات کے مطابق ہو۔ خبردار رہو کہ وہ سب کچھ عین ہدایات کے مطابق اُٹھا کر لے جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","یہ سب ملاقات کے خیمے میں جَیرسونیوں کی ذمہ داریاں ہیں۔ اِس کام میں ہارون امام کا بیٹا اِتمر اُن پر مقرر ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","رب نے کہا، ”مِراری کی اولاد کی مردم شماری بھی اُن کے آبائی گھرانوں اور کنبوں کے مطابق کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","اُن تمام مردوں کو رجسٹر میں درج کرنا جو 30 سے لے کر 50 سال کے ہیں اور ملاقات کے خیمے میں خدمت کے لئے آ سکتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","وہ ملاقات کے خیمے کی یہ چیزیں اُٹھا کر لے جانے کے ذمہ دار ہیں: دیوار کے تختے، شہتیر، کھمبے اور پائے، ");
INSERT INTO urdgvu_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","پھر خیمے کی چاردیواری کے کھمبے، پائے، میخیں، رسّے اور یہ چیزیں لگانے کا سامان۔ ہر ایک کو تفصیل سے بتانا کہ وہ کیا کیا اُٹھا کر لے جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","یہ سب کچھ مِراریوں کی ملاقات کے خیمے میں ذمہ داریوں میں شامل ہے۔ اِس کام میں ہارون امام کا بیٹا اِتمر اُن پر مقرر ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","موسیٰ، ہارون اور جماعت کے راہنماؤں نے قِہاتیوں کی مردم شماری اُن کے کنبوں اور آبائی گھرانوں کے مطابق کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_35‏","005_4_35‏","NUM","4","35‏","37","اُنہوں نے اُن تمام مردوں کو رجسٹر میں درج کیا جو 30 سے لے کر 50 سال کے تھے اور جو ملاقات کے خیمے میں خدمت کر سکتے تھے۔ اُن کی کُل تعداد 2,750 تھی۔ موسیٰ اور ہارون نے سب کچھ ویسا ہی کیا جیسا رب نے موسیٰ کی معرفت فرمایا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_38‏","005_4_38‏","NUM","4","38‏","41","پھر جَیرسونیوں کی مردم شماری اُن کے کنبوں اور آبائی گھرانوں کے مطابق ہوئی۔ خدمت کے لائق مردوں کی کُل تعداد 2,630 تھی۔ موسیٰ اور ہارون نے سب کچھ ویسا ہی کیا جیسا رب نے موسیٰ کے ذریعے فرمایا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_42‏","005_4_42‏","NUM","4","42‏","45","پھر مِراریوں کی مردم شماری اُن کے کنبوں اور آبائی گھرانوں کے مطابق ہوئی۔ خدمت کے لائق مردوں کی کُل تعداد 3,200 تھی۔ موسیٰ اور ہارون نے سب کچھ ویسا ہی کیا جیسا رب نے موسیٰ کے ذریعے فرمایا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_46‏","005_4_46‏","NUM","4","46‏","48","لاویوں کے اُن مردوں کی کُل تعداد 8,580 تھی جنہیں ملاقات کے خیمے میں خدمت کرنا اور سفر کرتے وقت اُسے اُٹھا کر لے جانا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","موسیٰ نے رب کے حکم کے مطابق ہر ایک کو اُس کی اپنی اپنی ذمہ داری سونپی اور اُسے بتایا کہ اُسے کیا کیا اُٹھا کر لے جانا ہے۔ یوں اُن کی مردم شماری رب کے اُس حکم کے عین مطابق کی گئی جو اُس نے موسیٰ کی معرفت دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","”اسرائیلیوں کو حکم دے کہ ہر اُس شخص کو خیمہ گاہ سے باہر کر دو جس کو وبائی جِلدی بیماری ہے، جس کے زخموں سے مائع نکلتا رہتا ہے یا جو کسی لاش کو چھونے سے ناپاک ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","خواہ مرد ہو یا عورت، سب کو خیمہ گاہ کے باہر بھیج دینا تاکہ وہ خیمہ گاہ کو ناپاک نہ کریں جہاں مَیں تمہارے درمیان سکونت کرتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","اسرائیلیوں نے ویسا ہی کیا جیسا رب نے موسیٰ کو کہا تھا۔ اُنہوں نے رب کے حکم کے عین مطابق اِس طرح کے تمام لوگوں کو خیمہ گاہ سے باہر کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","”اسرائیلیوں کو ہدایت دینا کہ جو بھی کسی سے غلط سلوک کرے وہ میرے ساتھ بےوفائی کرتا ہے اور قصوروار ہے، خواہ مرد ہو یا عورت۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","لازم ہے کہ وہ اپنا گناہ تسلیم کرے اور اُس کا پورا معاوضہ دے بلکہ متاثرہ شخص کا نقصان پورا کرنے کے علاوہ 20 فیصد زیادہ دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","لیکن اگر وہ شخص جس کا قصور کیا گیا تھا مر چکا ہو اور اُس کا کوئی وارث نہ ہو جو یہ معاوضہ وصول کر سکے تو پھر اُسے رب کو دینا ہے۔ امام کو یہ معاوضہ اُس مینڈھے کے علاوہ ملے گا جو قصوروار اپنے کفارہ کے لئے دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_9‏","005_5_9‏","NUM","5","9‏","10","نیز امام کو اسرائیلیوں کی قربانیوں میں سے وہ کچھ ملنا ہے جو اُٹھانے والی قربانی کے طور پر اُسے دیا جاتا ہے۔ یہ حصہ صرف اماموں کو ہی ملنا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","”اسرائیلیوں کو بتانا، ہو سکتا ہے کہ کوئی شادی شدہ عورت بھٹک کر اپنے شوہر سے بےوفا ہو جائے اور ");
INSERT INTO urdgvu_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","کسی اَور سے ہم بستر ہو کر ناپاک ہو جائے۔ اُس کے شوہر نے اُسے نہیں دیکھا، کیونکہ یہ پوشیدگی میں ہوا ہے اور نہ کسی نے اُسے پکڑا، نہ اِس کا کوئی گواہ ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","اگر شوہر کو اپنی بیوی کی وفاداری پر شک ہو اور وہ غیرت کھانے لگے، لیکن یقین سے نہیں کہہ سکتا کہ میری بیوی قصوروار ہے کہ نہیں ");
INSERT INTO urdgvu_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","تو وہ اپنی بیوی کو امام کے پاس لے آئے۔ ساتھ ساتھ وہ اپنی بیوی کے لئے قربانی کے طور پر جَو کا ڈیڑھ کلو گرام بہترین میدہ لے آئے۔ اِس پر نہ تیل اُنڈیلا جائے، نہ بخور ڈالا جائے، کیونکہ غلہ کی یہ نذر غیرت کی نذر ہے جس کا مقصد ہے کہ پوشیدہ قصور ظاہر ہو جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","امام عورت کو قریب آنے دے اور رب کے سامنے کھڑا کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","وہ مٹی کا برتن مُقدّس پانی سے بھر کر اُس میں مقدِس کے فرش کی کچھ خاک ڈالے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","پھر وہ عورت کو رب کو پیش کر کے اُس کے بال کھلوائے اور اُس کے ہاتھوں پر میدے کی نذر رکھے۔ امام کے اپنے ہاتھ میں کڑوے پانی کا وہ برتن ہو جو لعنت کا باعث ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","پھر وہ عورت کو قَسم کھلا کر کہے، ’اگر کوئی اَور آدمی آپ سے ہم بستر نہیں ہوا ہے اور آپ ناپاک نہیں ہوئی ہیں تو اِس کڑوے پانی کی لعنت کا آپ پر کوئی اثر نہ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","لیکن اگر آپ بھٹک کر اپنے شوہر سے بےوفا ہو گئی ہیں اور کسی اَور سے ہم بستر ہو کر ناپاک ہو گئی ہیں ");
INSERT INTO urdgvu_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","تو رب آپ کو آپ کی قوم کے سامنے لعنتی بنائے۔ آپ بانجھ ہو جائیں اور آپ کا پیٹ پھول جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","جب لعنت کا یہ پانی آپ کے پیٹ میں اُترے تو آپ بانجھ ہو جائیں اور آپ کا پیٹ پھول جائے۔‘ اِس پر عورت کہے، ’آمین، ایسا ہی ہو۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","پھر امام یہ لعنت لکھ کر کاغذ کو برتن کے پانی میں یوں دھو دے کہ اُس پر لکھی ہوئی باتیں پانی میں گھل جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","بعد میں وہ عورت کو یہ پانی پلائے تاکہ وہ اُس کے جسم میں جا کر اُسے لعنت پہنچائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","لیکن پہلے امام اُس کے ہاتھوں میں سے غیرت کی قربانی لے کر اُسے غلہ کی نذر کے طور پر رب کے سامنے ہلائے اور پھر قربان گاہ کے پاس لے آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","اُس پر وہ مٹھی بھر یادگاری کی قربانی کے طور پر جلائے۔ اِس کے بعد وہ عورت کو پانی پلائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","اگر وہ اپنے شوہر سے بےوفا تھی اور ناپاک ہو گئی ہے تو وہ بانجھ ہو جائے گی، اُس کا پیٹ پھول جائے گا اور وہ اپنی قوم کے سامنے لعنتی ٹھہرے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","لیکن اگر وہ پاک صاف ہے تو اُسے سزا نہیں دی جائے گی اور وہ بچے جنم دینے کے قابل رہے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_29‏","005_5_29‏","NUM","5","29‏","30","چنانچہ ایسا ہی کرنا ہے جب شوہر غیرت کھائے اور اُسے اپنی بیوی پر زنا کا شک ہو۔ بیوی کو قربان گاہ کے سامنے کھڑا کیا جائے اور امام یہ سب کچھ کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","اِس صورت میں شوہر بےقصور ٹھہرے گا، لیکن اگر اُس کی بیوی نے واقعی زنا کیا ہو تو اُسے اپنے گناہ کے نتیجے برداشت کرنے پڑیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","”اسرائیلیوں کو ہدایت دینا کہ اگر کوئی آدمی یا عورت مَنت مان کر اپنے آپ کو ایک مقررہ وقت کے لئے رب کے لئے مخصوص کرے ");
INSERT INTO urdgvu_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","تو وہ مَے یا کوئی اَور نشہ آور چیز نہ پیئے۔ نہ وہ انگور یا کسی اَور چیز کا سرکہ پیئے، نہ انگور کا رس۔ وہ انگور یا کشمش نہ کھائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","جب تک وہ مخصوص ہے وہ انگور کی کوئی بھی پیداوار نہ کھائے، یہاں تک کہ انگور کے بیج یا چھلکے بھی نہ کھائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","جب تک وہ اپنی مَنت کے مطابق مخصوص ہے وہ اپنے بال نہ کٹوائے۔ جتنی دیر کے لئے اُس نے اپنے آپ کو رب کے لئے مخصوص کیا ہے اُتنی دیر تک وہ مُقدّس ہے۔ اِس لئے وہ اپنے بال بڑھنے دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","جب تک وہ مخصوص ہے وہ کسی لاش کے قریب نہ جائے، ");
INSERT INTO urdgvu_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","چاہے وہ اُس کے باپ، ماں، بھائی یا بہن کی لاش کیوں نہ ہو۔ کیونکہ اِس سے وہ ناپاک ہو جائے گا جبکہ ابھی تک اُس کی مخصوصیت لمبے بالوں کی صورت میں نظر آتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","وہ اپنی مخصوصیت کے دوران رب کے لئے مخصوص و مُقدّس ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","اگر کوئی اچانک مر جائے جب مخصوص شخص اُس کے قریب ہو تو اُس کے مخصوص بال ناپاک ہو جائیں گے۔ ایسی صورت میں لازم ہے کہ وہ اپنے آپ کو پاک صاف کر کے ساتویں دن اپنے سر کو منڈوائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","آٹھویں دن وہ دو قمریاں یا دو جوان کبوتر لے کر ملاقات کے خیمے کے دروازے پر آئے اور امام کو دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","امام اِن میں سے ایک کو گناہ کی قربانی کے طور پر چڑھائے اور دوسرے کو بھسم ہونے والی قربانی کے طور پر۔ یوں وہ اُس کے لئے کفارہ دے گا جو لاش کے قریب ہونے سے ناپاک ہو گیا ہے۔ اُسی دن وہ اپنے سر کو دوبارہ مخصوص کرے ");
INSERT INTO urdgvu_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","اور اپنے آپ کو مقررہ وقت کے لئے دوبارہ رب کے لئے مخصوص کرے۔ وہ قصور کی قربانی کے طور پر ایک سال کا بھیڑ کا بچہ پیش کرے۔ جتنے دن اُس نے پہلے مخصوصیت کی حالت میں گزارے ہیں وہ شمار نہیں کئے جا سکتے کیونکہ وہ مخصوصیت کی حالت میں ناپاک ہو گیا تھا۔ وہ دوبارہ پہلے دن سے شروع کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","شریعت کے مطابق جب مخصوص شخص کا مقررہ وقت گزر گیا ہو تو پہلے اُسے ملاقات کے خیمے کے دروازے پر لایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","وہاں وہ رب کو بھسم ہونے والی قربانی کے لئے بھیڑ کا ایک بےعیب یک سالہ نر بچہ، گناہ کی قربانی کے لئے ایک بےعیب یک سالہ بھیڑ اور سلامتی کی قربانی کے لئے ایک بےعیب مینڈھا پیش کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","اِس کے علاوہ وہ ایک ٹوکری میں بےخمیری روٹیاں جن میں بہترین میدہ اور تیل ملایا گیا ہو اور بےخمیری روٹیاں جن پر تیل لگایا گیا ہو متعلقہ غلہ کی نذر اور مَے کی نذر کے ساتھ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","رب کو پیش کرے۔ پہلے امام گناہ کی قربانی اور بھسم ہونے والی قربانی رب کے حضور چڑھائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","پھر وہ مینڈھے کو بےخمیری روٹیوں کے ساتھ سلامتی کی قربانی کے طور پر پیش کرے۔ امام غلہ کی نذر اور مَے کی نذر بھی چڑھائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","اِس دوران مخصوص شخص ملاقات کے خیمے پر اپنے مخصوص کئے گئے سر کو منڈوا کر تمام بال سلامتی کی قربانی کی آگ میں پھینکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","پھر امام مینڈھے کا ایک پکا ہوا شانہ اور ٹوکری میں سے دونوں قسموں کی ایک ایک روٹی لے کر مخصوص شخص کے ہاتھوں پر رکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","اِس کے بعد وہ یہ چیزیں واپس لے کر اُنہیں ہلانے کی قربانی کے طور پر رب کے سامنے ہلائے۔ یہ ایک مُقدّس قربانی ہے جو امام کا حصہ ہے۔ سلامتی کی قربانی کا ہلایا ہوا سینہ اور اُٹھائی ہوئی ران بھی امام کا حصہ ہیں۔ قربانی کے اختتام پر مخصوص کئے ہوئے شخص کو مَے پینے کی اجازت ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","جو اپنے آپ کو رب کے لئے مخصوص کرتا ہے وہ ایسا ہی کرے۔ لازم ہے کہ وہ اِن ہدایات کے مطابق تمام قربانیاں پیش کرے۔ اگر گنجائش ہو تو وہ اَور بھی پیش کر سکتا ہے۔ بہر حال لازم ہے کہ وہ اپنی مَنت اور یہ ہدایات پوری کرے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","”ہارون اور اُس کے بیٹوں کو بتا دینا کہ وہ اسرائیلیوں کو یوں برکت دیں، ");
INSERT INTO urdgvu_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","’رب تجھے برکت دے اور تیری حفاظت کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","رب اپنے چہرے کا مہربان نور تجھ پر چمکائے اور تجھ پر رحم کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","رب کی نظرِ کرم تجھ پر ہو، اور وہ تجھے سلامتی بخشے۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","یوں وہ میرا نام لے کر اسرائیلیوں کو برکت دیں۔ پھر مَیں اُنہیں برکت دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","جس دن مقدِس مکمل ہوا اُسی دن موسیٰ نے اُسے مخصوص و مُقدّس کیا۔ اِس کے لئے اُس نے خیمے، اُس کے تمام سامان، قربان گاہ اور اُس کے تمام سامان پر تیل چھڑکا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU7_2‏","005_7_2‏","NUM","7","2‏","3","پھر قبیلوں کے بارہ سردار مقدِس کے لئے ہدیئے لے کر آئے۔ یہ وہی راہنما تھے جنہوں نے مردم شماری کے وقت موسیٰ کی مدد کی تھی۔ اُنہوں نے چھت والی چھ بَیل گاڑیاں اور بارہ بَیل خیمے کے سامنے رب کو پیش کئے، دو دو سرداروں کی طرف سے ایک بَیل گاڑی اور ہر ایک سردار کی طرف سے ایک بَیل۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","”یہ تحفے قبول کر کے ملاقات کے خیمے کے کام کے لئے استعمال کر۔ اُنہیں لاویوں میں اُن کی خدمت کی ضرورت کے مطابق تقسیم کرنا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","چنانچہ موسیٰ نے بَیل گاڑیاں اور بَیل لاویوں کو دے دیئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","اُس نے دو بَیل گاڑیاں چار بَیلوں سمیت جَیرسونیوں کو ");
INSERT INTO urdgvu_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","اور چار بَیل گاڑیاں آٹھ بَیلوں سمیت مِراریوں کو دیں۔ مِراری ہارون امام کے بیٹے اِتمر کے تحت خدمت کرتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","لیکن موسیٰ نے قِہاتیوں کو نہ بَیل گاڑیاں اور نہ بَیل دیئے۔ وجہ یہ تھی کہ جو مُقدّس چیزیں اُن کے سپرد تھیں وہ اُن کو کندھوں پر اُٹھا کر لے جانی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","بارہ سردار قربان گاہ کی مخصوصیت کے موقع پر بھی ہدیئے لے آئے۔ اُنہوں نے اپنے ہدیئے قربان گاہ کے سامنے پیش کئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","رب نے موسیٰ سے کہا، ”سردار بارہ دن کے دوران باری باری اپنے ہدیئے پیش کریں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","پہلے دن یہوداہ کے سردار نحسون بن عمی نداب کی باری تھی۔ اُس کے ہدیئے یہ تھے: ");
INSERT INTO urdgvu_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","چاندی کا تھال جس کا وزن ڈیڑھ کلو گرام تھا اور چھڑکاؤ کا چاندی کا کٹوراجس کا وزن 800 گرام تھا۔ دونوں غلہ کی نذر کے لئے تیل کے ساتھ ملائے گئے بہترین میدے سے بھرے ہوئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","اِن کے علاوہ نحسون نے یہ چیزیں پیش کیں: سونے کا پیالہ جس کا وزن 110 گرام تھا اور جو بخور سے بھرا ہوا تھا، ");
INSERT INTO urdgvu_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ایک جوان بَیل، ایک مینڈھا، بھسم ہونے والی قربانی کے لئے بھیڑ کا ایک یک سالہ بچہ، ");
INSERT INTO urdgvu_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","گناہ کی قربانی کے لئے ایک بکرا ");
INSERT INTO urdgvu_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","اور سلامتی کی قربانی کے لئے دو بَیل، پانچ مینڈھے، پانچ بکرے اور بھیڑ کے پانچ یک سالہ بچے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU7_18‏","005_7_18‏","NUM","7","18‏","23","اگلے گیارہ دن باقی سردار بھی یہی ہدیئے مقدِس کے پاس لے آئے۔ دوسرے دن اِشکار کے سردار نتنی ایل بن ضُغر کی باری تھی، ");
INSERT INTO urdgvu_vpl VALUES ("NU7_24‏","005_7_24‏","NUM","7","24‏","29","تیسرے دن زبولون کے سردار اِلیاب بن حیلون کی، ");
INSERT INTO urdgvu_vpl VALUES ("NU7_30‏","005_7_30‏","NUM","7","30‏","47","چوتھے دن روبن کے سردار اِلی صور بن شدیور کی، پانچویں دن شمعون کے سردار سلومی ایل بن صوری شدی کی، چھٹے دن جد کے سردار اِلیاسف بن دعوایل کی، ");
INSERT INTO urdgvu_vpl VALUES ("NU7_48‏","005_7_48‏","NUM","7","48‏","53","ساتویں دن افرائیم کے سردار اِلی سمع بن عمی ہود کی، ");
INSERT INTO urdgvu_vpl VALUES ("NU7_54‏","005_7_54‏","NUM","7","54‏","71","آٹھویں دن منسّی کے سردار جملی ایل بن فدا ہصور کی، نویں دن بن یمین کے سردار ابدان بن جدعونی کی، دسویں دن دان کے سردار اخی عزر بن عمی شدی کی، ");
INSERT INTO urdgvu_vpl VALUES ("NU7_72‏","005_7_72‏","NUM","7","72‏","83","گیارھویں دن آشر کے سردار فجعی ایل بن عکران کی اور بارھویں دن نفتالی کے سردار اخیرع بن عینان کی باری تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","اسرائیل کے اِن سرداروں نے مل کر قربان گاہ کی مخصوصیت کے لئے چاندی کے 12 تھال، چھڑکاؤ کے چاندی کے 12 کٹورے اور سونے کے 12 پیالے پیش کئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ہر تھال کا وزن ڈیڑھ کلو گرام اور چھڑکاؤ کے ہر کٹورے کا وزن 800 گرام تھا۔ اِن چیزوں کا کُل وزن تقریباً 28 کلو گرام تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","بخور سے بھرے ہوئے سونے کے پیالوں کا کُل وزن تقریباً ڈیڑھ کلو گرام تھا (فی پیالہ 110 گرام)۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","سرداروں نے مل کر بھسم ہونے والی قربانی کے لئے 12 جوان بَیل، 12 مینڈھے اور بھیڑ کے 12 یک سالہ بچے اُن کی غلہ کی نذروں سمیت پیش کئے۔ گناہ کی قربانی کے لئے اُنہوں نے 12 بکرے پیش کئے ");
INSERT INTO urdgvu_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","اور سلامتی کی قربانی کے لئے 24 بَیل، 60 مینڈھے، 60 بکرے اور بھیڑ کے 60 یک سالہ بچے۔ اِن تمام جانوروں کو قربان گاہ کی مخصوصیت کے موقع پر چڑھایا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","جب موسیٰ ملاقات کے خیمے میں رب کے ساتھ بات کرنے کے لئے داخل ہوتا تھا تو وہ رب کی آواز عہد کے صندوق کے ڈھکنے پر سے یعنی دو کروبی فرشتوں کے درمیان سے سنتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","”ہارون کو بتانا، ’تجھے سات چراغوں کو شمع دان پر یوں رکھنا ہے کہ وہ شمع دان کا سامنے والا حصہ روشن کریں‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ہارون نے ایسا ہی کیا۔ جس طرح رب نے موسیٰ کو حکم دیا تھا اُسی طرح اُس نے چراغوں کو رکھ دیا تاکہ وہ سامنے والا حصہ روشن کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","شمع دان پائے سے لے کر اوپر کی کلیوں تک سونے کے ایک گھڑے ہوئے ٹکڑے کا بنا ہوا تھا۔ موسیٰ نے اُسے اُس نمونے کے عین مطابق بنوایا جو رب نے اُسے دکھایا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","”لاویوں کو دیگر اسرائیلیوں سے الگ کر کے پاک صاف کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","اِس کے لئے گناہ سے پاک کرنے والا پانی اُن پر چھڑک کر اُنہیں حکم دینا کہ اپنے جسم کے پورے بال منڈواؤ اور اپنے کپڑے دھوؤ۔ یوں وہ پاک صاف ہو جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","پھر وہ ایک جوان بَیل چنیں اور ساتھ کی غلہ کی نذر کے لئے تیل کے ساتھ ملایا گیا بہترین میدہ لیں۔ تُو خود بھی ایک جوان بَیل چن۔ وہ گناہ کی قربانی کے لئے ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","اِس کے بعد لاویوں کو ملاقات کے خیمے کے سامنے کھڑا کر کے اسرائیل کی پوری جماعت کو وہاں جمع کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","جب لاوی رب کے سامنے کھڑے ہوں تو باقی اسرائیلی اُن کے سروں پر اپنے ہاتھ رکھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","پھر ہارون لاویوں کو رب کے سامنے پیش کرے۔ اُنہیں اسرائیلیوں کی طرف سے ہلائی ہوئی قربانی کی حیثیت سے پیش کیا جائے تاکہ وہ رب کی خدمت کر سکیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","پھر لاوی اپنے ہاتھ دونوں بَیلوں کے سروں پر رکھیں۔ ایک بَیل کو گناہ کی قربانی کے طور پر اور دوسرے کو بھسم ہونے والی قربانی کے طور پر چڑھاؤ تاکہ لاویوں کا کفارہ دیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","لاویوں کو اِس طریقے سے ہارون اور اُس کے بیٹوں کے سامنے کھڑا کر کے رب کو ہلائی ہوئی قربانی کے طور پر پیش کرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","اُنہیں باقی اسرائیلیوں سے الگ کرنے سے وہ میرا حصہ بنیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","اِس کے بعد ہی وہ ملاقات کے خیمے میں آ کر خدمت کریں، کیونکہ اب وہ خدمت کرنے کے لائق ہیں۔ اُنہیں پاک صاف کر کے ہلائی ہوئی قربانی کے طور پر پیش کرنے کا سبب یہ ہے ");
INSERT INTO urdgvu_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","کہ لاوی اسرائیلیوں میں سے وہ ہیں جو مجھے پورے طور پر دیئے گئے ہیں۔ مَیں نے اُنہیں اسرائیلیوں کے تمام پہلوٹھوں کی جگہ لے لیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","کیونکہ اسرائیل میں ہر پہلوٹھا میرا ہے، خواہ وہ انسان کا ہو یا حیوان کا۔ اُس دن جب مَیں نے مصریوں کے پہلوٹھوں کو مار دیا مَیں نے اسرائیل کے پہلوٹھوں کو اپنے لئے مخصوص و مُقدّس کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","اِس سلسلے میں مَیں نے لاویوں کو اسرائیلیوں کے تمام پہلوٹھوں کی جگہ لے کر ");
INSERT INTO urdgvu_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","اُنہیں ہارون اور اُس کے بیٹوں کو دیا ہے۔ وہ ملاقات کے خیمے میں اسرائیلیوں کی خدمت کریں اور اُن کے لئے کفارہ کا انتظام قائم رکھیں تاکہ جب اسرائیلی مقدِس کے قریب آئیں تو اُن کو وبا سے مارا نہ جائے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","موسیٰ، ہارون اور اسرائیلیوں کی پوری جماعت نے احتیاط سے رب کی لاویوں کے بارے میں ہدایات پر عمل کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","لاویوں نے اپنے آپ کو گناہوں سے پاک صاف کر کے اپنے کپڑوں کو دھویا۔ پھر ہارون نے اُنہیں رب کے سامنے ہلائی ہوئی قربانی کے طور پر پیش کیا اور اُن کا کفارہ دیا تاکہ وہ پاک ہو جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","اِس کے بعد لاوی ملاقات کے خیمے میں آئے تاکہ ہارون اور اُس کے بیٹوں کے تحت خدمت کریں۔ یوں سب کچھ ویسا ہی کیا گیا جیسا رب نے موسیٰ کو حکم دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","رب نے موسیٰ سے یہ بھی کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","”لاوی 25 سال کی عمر میں ملاقات کے خیمے میں اپنی خدمت شروع کریں ");
INSERT INTO urdgvu_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","اور 50 سال کی عمر میں ریٹائر ہو جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","اِس کے بعد وہ ملاقات کے خیمے میں اپنے بھائیوں کی مدد کر سکتے ہیں، لیکن خود خدمت نہیں کر سکتے۔ تجھے لاویوں کو اِن ہدایات کے مطابق اُن کی اپنی اپنی ذمہ داریاں دینی ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","اسرائیلیوں کو مصر سے نکلے ایک سال ہو گیا تھا۔ دوسرے سال کے پہلے مہینے میں رب نے دشتِ سینا میں موسیٰ سے بات کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","”لازم ہے کہ اسرائیلی عیدِ فسح کو مقررہ وقت پر منائیں، ");
INSERT INTO urdgvu_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","یعنی اِس مہینے کے چودھویں دن، سورج کے غروب ہونے کے عین بعد۔ اُسے تمام قواعد کے مطابق منانا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","چنانچہ موسیٰ نے اسرائیلیوں سے کہا کہ وہ عیدِ فسح منائیں، ");
INSERT INTO urdgvu_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","اور اُنہوں نے ایسا ہی کیا۔ اُنہوں نے عیدِ فسح کو پہلے مہینے کے چودھویں دن سورج کے غروب ہونے کے عین بعد منایا۔ اُنہوں نے سب کچھ ویسا ہی کیا جیسا رب نے موسیٰ کو حکم دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","لیکن کچھ آدمی ناپاک تھے، کیونکہ اُنہوں نے لاش چھو لی تھی۔ اِس وجہ سے وہ اُس دن عیدِ فسح نہ منا سکے۔ وہ موسیٰ اور ہارون کے پاس آ کر ");
INSERT INTO urdgvu_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","کہنے لگے، ”ہم نے لاش چھو لی ہے، اِس لئے ناپاک ہیں۔ لیکن ہمیں اِس سبب سے عیدِ فسح کو منانے سے کیوں روکا جائے؟ ہم بھی مقررہ وقت پر باقی اسرائیلیوں کے ساتھ رب کی قربانی پیش کرنا چاہتے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","موسیٰ نے جواب دیا، ”یہاں میرے انتظار میں کھڑے رہو۔ مَیں معلوم کرتا ہوں کہ رب تمہارے بارے میں کیا حکم دیتا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","”اسرائیلیوں کو بتا دینا کہ اگر تم یا تمہاری اولاد میں سے کوئی عیدِ فسح کے دوران لاش چھونے سے ناپاک ہو یا کسی دُوردراز علاقے میں سفر کر رہا ہو، توبھی وہ عید منا سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ایسا شخص اُسے عین ایک ماہ کے بعد منا کر لیلے کے ساتھ بےخمیری روٹی اور کڑوا ساگ پات کھائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","کھانے میں سے کچھ بھی اگلی صبح تک باقی نہ رہے۔ جانور کی کوئی بھی ہڈی نہ توڑنا۔ منانے والا عیدِ فسح کے پورے فرائض ادا کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","لیکن جو پاک ہونے اور سفر نہ کرنے کے باوجود بھی عیدِ فسح کو نہ منائے اُسے اُس کی قوم میں سے مٹایا جائے، کیونکہ اُس نے مقررہ وقت پر رب کو قربانی پیش نہیں کی۔ اُس شخص کو اپنے گناہ کا نتیجہ بھگتنا پڑے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","اگر کوئی پردیسی تمہارے درمیان رہتے ہوئے رب کے سامنے عیدِ فسح منانا چاہے تو اُسے اجازت ہے۔ شرط یہ ہے کہ وہ پورے فرائض ادا کرے۔ پردیسی اور دیسی کے لئے عیدِ فسح منانے کے فرائض ایک جیسے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","جس دن شریعت کے مُقدّس خیمے کو کھڑا کیا گیا اُس دن بادل آ کر اُس پر چھا گیا۔ رات کے وقت بادل آگ کی صورت میں نظر آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","اِس کے بعد یہی صورتِ حال رہی کہ بادل اُس پر چھایا رہتا اور رات کے دوران آگ کی صورت میں نظر آتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","جب بھی بادل خیمے پر سے اُٹھتا اسرائیلی روانہ ہو جاتے۔ جہاں بھی بادل اُتر جاتا وہاں اسرائیلی اپنے ڈیرے ڈالتے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","اسرائیلی رب کے حکم پر روانہ ہوتے اور اُس کے حکم پر ڈیرے ڈالتے۔ جب تک بادل مقدِس پر چھایا رہتا اُس وقت تک وہ وہیں ٹھہرتے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","کبھی کبھی بادل بڑی دیر تک خیمے پر ٹھہرا رہتا۔ تب اسرائیلی رب کا حکم مان کر روانہ نہ ہوتے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","کبھی کبھی بادل صرف دو چار دن کے لئے خیمے پر ٹھہرتا۔ پھر وہ رب کے حکم کے مطابق ہی ٹھہرتے اور روانہ ہوتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","کبھی کبھی بادل صرف شام سے لے کر صبح تک خیمے پر ٹھہرتا۔ جب وہ صبح کے وقت اُٹھتا تو اسرائیلی بھی روانہ ہوتے تھے۔ جب بھی بادل اُٹھتا وہ بھی روانہ ہو جاتے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","جب تک بادل مُقدّس خیمے پر چھایا رہتا اُس وقت تک اسرائیلی روانہ نہ ہوتے، چاہے وہ دو دن، ایک ماہ، ایک سال یا اِس سے زیادہ عرصہ مقدِس پر چھایا رہتا۔ لیکن جب وہ اُٹھتا تو اسرائیلی بھی روانہ ہو جاتے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","وہ رب کے حکم پر خیمے لگاتے اور اُس کے حکم پر روانہ ہوتے تھے۔ وہ ویسا ہی کرتے تھے جیسا رب موسیٰ کی معرفت فرماتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","”چاندی کے دو بِگل گھڑ کر بنوا لے۔ اُنہیں جماعت کو جمع کرنے اور قبیلوں کو روانہ کرنے کے لئے استعمال کر۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","جب دونوں کو دیر تک بجایا جائے تو پوری جماعت ملاقات کے خیمے کے دروازے پر آ کر تیرے سامنے جمع ہو جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","لیکن اگر ایک ہی بجایا جائے تو صرف کنبوں کے بزرگ تیرے سامنے جمع ہو جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","اگر اُن کی آواز صرف تھوڑی دیر کے لئے سنائی دے تو مقدِس کے مشرق میں موجود قبیلے روانہ ہو جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","پھر جب اُن کی آواز دوسری بار تھوڑی دیر کے لئے سنائی دے تو مقدِس کے جنوب میں موجود قبیلے روانہ ہو جائیں۔ جب اُن کی آواز تھوڑی دیر کے لئے سنائی دے تو یہ روانہ ہونے کا اعلان ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","اِس کے مقابلے میں جب اُن کی آواز دیر تک سنائی دے تو یہ اِس بات کا اعلان ہو گا کہ جماعت جمع ہو جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","بِگل بجانے کی ذمہ داری ہارون کے بیٹوں یعنی اماموں کو دی جائے۔ یہ تمہارے اور آنے والی نسلوں کے لئے دائمی اصول ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","اُن کی آواز اُس وقت بھی تھوڑی دیر کے لئے سنا دو جب تم اپنے ملک میں کسی ظالم دشمن سے جنگ لڑنے کے لئے نکلو گے۔ تب رب تمہارا خدا تمہیں یاد کر کے دشمن سے بچائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","اِسی طرح اُن کی آواز مقدِس میں خوشی کے موقعوں پر سنائی دے یعنی مقررہ عیدوں اور نئے چاند کی عیدوں پر۔ اِن موقعوں پر وہ بھسم ہونے والی قربانیاں اور سلامتی کی قربانیاں چڑھاتے وقت بجائے جائیں۔ پھر تمہارا خدا تمہیں یاد کرے گا۔ مَیں رب تمہارا خدا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","اسرائیلیوں کو مصر سے نکلے ایک سال سے زائد عرصہ ہو چکا تھا۔ دوسرے مہینے کے بیسویں دن بادل ملاقات کے خیمے پر سے اُٹھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","پھر اسرائیلی مقررہ ترتیب کے مطابق دشتِ سینا سے روانہ ہوئے۔ چلتے چلتے بادل فاران کے ریگستان میں اُتر آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","اُس وقت وہ پہلی دفعہ اُس ترتیب سے روانہ ہوئے جو رب نے موسیٰ کی معرفت مقرر کی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","پہلے یہوداہ کے قبیلے کے تین دستے اپنے علَم کے تحت چل پڑے۔ تینوں کا کمانڈر نحسون بن عمی نداب تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ساتھ چلنے والے قبیلے اِشکار کا کمانڈر نتنی ایل بن ضُغر تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","زبولون کا قبیلہ بھی ساتھ چلا جس کا کمانڈر اِلیاب بن حیلون تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","اِس کے بعد ملاقات کا خیمہ اُتارا گیا۔ جَیرسونی اور مِراری اُسے اُٹھا کر چل دیئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","اِن لاویوں کے بعد روبن کے قبیلے کے تین دستے اپنے علَم کے تحت چلنے لگے۔ تینوں کا کمانڈر اِلی صور بن شدیور تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ساتھ چلنے والے قبیلے شمعون کا کمانڈر سلومی ایل بن صوری شدی تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","جد کا قبیلہ بھی ساتھ چلا جس کا کمانڈر اِلیاسف بن دعوایل تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","پھر لاویوں میں سے قِہاتی مقدِس کا سامان اُٹھا کر روانہ ہوئے۔ لازم تھا کہ اُن کے اگلی منزل پر پہنچنے تک ملاقات کا خیمہ لگا دیا گیا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","اِس کے بعد افرائیم کے قبیلے کے تین دستے اپنے علَم کے تحت چل دیئے۔ اُن کا کمانڈر اِلی سمع بن عمی ہود تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","افرائیم کے ساتھ چلنے والے قبیلے منسّی کا کمانڈر جملی ایل بن فدا ہصور تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","بن یمین کا قبیلہ بھی ساتھ چلا جس کا کمانڈر ابدان بن جدعونی تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","آخر میں دان کے تین دستے عقبی محافظ کے طور پر اپنے علَم کے تحت روانہ ہوئے۔ اُن کا کمانڈر اخی عزر بن عمی شدی تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","دان کے ساتھ چلنے والے قبیلے آشر کا کمانڈر فجعی ایل بن عکران تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","نفتالی کا قبیلہ بھی ساتھ چلا جس کا کمانڈر اخیرع بن عینان تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","اسرائیلی اِسی ترتیب سے روانہ ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","موسیٰ نے اپنے مِدیانی سُسر رعوایل یعنی یترو کے بیٹے حوباب سے کہا، ”ہم اُس جگہ کے لئے روانہ ہو رہے ہیں جس کا وعدہ رب نے ہم سے کیا ہے۔ ہمارے ساتھ چلیں! ہم آپ پر احسان کریں گے، کیونکہ رب نے اسرائیل پر احسان کرنے کا وعدہ کیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","لیکن حوباب نے جواب دیا، ”مَیں ساتھ نہیں جاؤں گا بلکہ اپنے ملک اور رشتے داروں کے پاس واپس چلا جاؤں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","موسیٰ نے کہا، ”مہربانی کر کے ہمیں نہ چھوڑیں۔ کیونکہ آپ ہی جانتے ہیں کہ ہم ریگستان میں کہاں کہاں اپنے ڈیرے ڈال سکتے ہیں۔ آپ ریگستان میں ہمیں راستہ دکھا سکتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","اگر آپ ہمارے ساتھ جائیں تو ہم آپ کو اُس احسان میں شریک کریں گے جو رب ہم پر کرے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","چنانچہ اُنہوں نے رب کے پہاڑ سے روانہ ہو کر تین دن سفر کیا۔ اِس دوران رب کا عہد کا صندوق اُن کے آگے آگے چلا تاکہ اُن کے لئے آرام کرنے کی جگہ معلوم کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","جب کبھی وہ روانہ ہوتے تو رب کا بادل دن کے وقت اُن کے اوپر رہتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","صندوق کے روانہ ہوتے وقت موسیٰ کہتا، ”اے رب، اُٹھ۔ تیرے دشمن تتر بتر ہو جائیں۔ تجھ سے نفرت کرنے والے تیرے سامنے سے فرار ہو جائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","اور جب بھی وہ رُک جاتا تو موسیٰ کہتا، ”اے رب، اسرائیل کے ہزاروں خاندانوں کے پاس واپس آ۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ایک دن لوگ خوب شکایت کرنے لگے۔ جب یہ شکایتیں رب تک پہنچیں تو اُسے غصہ آیا اور اُس کی آگ اُن کے درمیان بھڑک اُٹھی۔ جلتے جلتے اُس نے خیمہ گاہ کا ایک کنارہ بھسم کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","لوگ مدد کے لئے موسیٰ کے پاس آ کر چلّانے لگے تو اُس نے رب سے دعا کی، اور آگ بجھ گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","اُس مقام کا نام تبعیرہ یعنی جلنا پڑ گیا، کیونکہ رب کی آگ اُن کے درمیان جل اُٹھی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","اسرائیلیوں کے ساتھ جو اجنبی سفر کر رہے تھے وہ گوشت کھانے کی شدید آرزو کرنے لگے۔ تب اسرائیلی بھی رو پڑے اور کہنے لگے، ”کون ہمیں گوشت کھلائے گا؟ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","مصر میں ہم مچھلی مفت کھا سکتے تھے۔ ہائے، وہاں کے کھیرے، تربوز، گَندنے، پیاز اور لہسن کتنے اچھے تھے! ");
INSERT INTO urdgvu_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","لیکن اب تو ہماری جان سوکھ گئی ہے۔ یہاں بس مَن ہی مَن نظر آتا رہتا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","مَن دھنئے کے دانوں کی مانند تھا، اور اُس کا رنگ گُوگل کے گوند کی مانند تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_8‏","005_11_8‏","NUM","11","8‏","9","رات کے وقت وہ خیمہ گاہ میں اوس کے ساتھ زمین پر گرتا تھا۔ صبح کے وقت لوگ اِدھر اُدھر گھومتے پھرتے ہوئے اُسے جمع کرتے تھے۔ پھر وہ اُسے چکّی میں پیس کر یا اُکھلی میں کوٹ کر اُبالتے یا روٹی بناتے تھے۔ اُس کا ذائقہ ایسی روٹی کا سا تھا جس میں زیتون کا تیل ڈالا گیا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","تمام خاندان اپنے اپنے خیمے کے دروازے پر رونے لگے تو رب کو شدید غصہ آیا۔ اُن کا شور موسیٰ کو بھی بہت بُرا لگا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","اُس نے رب سے پوچھا، ”تُو نے اپنے خادم کے ساتھ اِتنا بُرا سلوک کیوں کیا؟ مَیں نے کس کام سے تجھے اِتنا ناراض کیا کہ تُو نے اِن تمام لوگوں کا بوجھ مجھ پر ڈال دیا؟ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","کیا مَیں نے حاملہ ہو کر اِس پوری قوم کو جنم دیا کہ تُو مجھ سے کہتا ہے، ’اِسے اُس طرح اُٹھا کر لے چلنا جس طرح آیا شیرخوار بچے کو اُٹھا کر ہر جگہ ساتھ لئے پھرتی ہے۔ اِسی طرح اِسے اُس ملک میں لے جانا جس کا وعدہ مَیں نے قَسم کھا کر اِن کے باپ دادا سے کیا ہے۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","اے اللہ، مَیں اِن تمام لوگوں کو کہاں سے گوشت مہیا کروں؟ وہ میرے سامنے روتے رہتے ہیں کہ ہمیں کھانے کے لئے گوشت دو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","مَیں اکیلا اِن تمام لوگوں کی ذمہ داری نہیں اُٹھا سکتا۔ یہ بوجھ میرے لئے حد سے زیادہ بھاری ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","اگر تُو اِس پر اصرار کرے تو پھر بہتر ہے کہ ابھی مجھے مار دے تاکہ مَیں اپنی تباہی نہ دیکھوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","جواب میں رب نے موسیٰ سے کہا، ”میرے پاس اسرائیل کے 70 بزرگ جمع کر۔ صرف ایسے لوگ چن جن کے بارے میں تجھے معلوم ہے کہ وہ لوگوں کے بزرگ اور نگہبان ہیں۔ اُنہیں ملاقات کے خیمے کے پاس لے آ۔ وہاں وہ تیرے ساتھ کھڑے ہو جائیں، ");
INSERT INTO urdgvu_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","تو مَیں اُتر کر تیرے ساتھ ہم کلام ہوں گا۔ اُس وقت مَیں اُس روح میں سے کچھ لوں گا جو مَیں نے تجھ پر نازل کیا تھا اور اُسے اُن پر نازل کروں گا۔ تب وہ قوم کا بوجھ اُٹھانے میں تیری مدد کریں گے اور تُو اِس میں اکیلا نہیں رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","لوگوں کو بتانا، ’اپنے آپ کو مخصوص و مُقدّس کرو، کیونکہ کل تم گوشت کھاؤ گے۔ رب نے تمہاری سنی جب تم رو پڑے کہ کون ہمیں گوشت کھلائے گا، مصر میں ہماری حالت بہتر تھی۔ اب رب تمہیں گوشت مہیا کرے گا اور تم اُسے کھاؤ گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","تم اُسے نہ صرف ایک، دو یا پانچ دن کھاؤ گے بلکہ 10 یا 20 دن سے بھی زیادہ عرصے تک۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","تم ایک پورا مہینہ خوب گوشت کھاؤ گے، یہاں تک کہ وہ تمہاری ناک سے نکلے گا اور تمہیں اُس سے گھن آئے گی۔ اور یہ اِس سبب سے ہو گا کہ تم نے رب کو جو تمہارے درمیان ہے رد کیا اور روتے روتے اُس کے سامنے کہا کہ ہم کیوں مصر سے نکلے‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","لیکن موسیٰ نے اعتراض کیا، ”اگر قوم کے پیدل چلنے والے گنے جائیں تو چھ لاکھ ہیں۔ تُو کس طرح ہمیں ایک ماہ تک گوشت مہیا کرے گا؟ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","کیا گائےبَیلوں یا بھیڑبکریوں کو اِتنی مقدار میں ذبح کیا جا سکتا ہے کہ کافی ہو؟ اگر سمندر کی تمام مچھلیاں اُن کے لئے پکڑی جائیں تو کیا کافی ہوں گی؟“ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","رب نے کہا، ”کیا رب کا اختیار کم ہے؟ اب تُو خود دیکھ لے گا کہ میری باتیں درست ہیں کہ نہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","چنانچہ موسیٰ نے وہاں سے نکل کر لوگوں کو رب کی یہ باتیں بتائیں۔ اُس نے اُن کے بزرگوں میں سے 70 کو چن کر اُنہیں ملاقات کے خیمے کے ارد گرد کھڑا کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","تب رب بادل میں اُتر کر موسیٰ سے ہم کلام ہوا۔ جو روح اُس نے موسیٰ پر نازل کیا تھا اُس میں سے اُس نے کچھ لے کر اُن 70 بزرگوں پر نازل کیا۔ جب روح اُن پر آیا تو وہ نبوّت کرنے لگے۔ لیکن ایسا پھر کبھی نہ ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","اب ایسا ہوا کہ اِن ستر بزرگوں میں سے دو خیمہ گاہ میں رہ گئے تھے۔ اُن کے نام اِلداد اور میداد تھے۔ اُنہیں چنا تو گیا تھا لیکن وہ ملاقات کے خیمے کے پاس نہیں آئے تھے۔ اِس کے باوجود روح اُن پر بھی نازل ہوا اور وہ خیمہ گاہ میں نبوّت کرنے لگے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ایک نوجوان بھاگ کر موسیٰ کے پاس آیا اور کہا، ”اِلداد اور میداد خیمہ گاہ میں ہی نبوّت کر رہے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","یشوع بن نون جو جوانی سے موسیٰ کا مددگار تھا بول اُٹھا، ”موسیٰ میرے آقا، اُنہیں روک دیں!“ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","لیکن موسیٰ نے جواب دیا، ”کیا تُو میری خاطر غیرت کھا رہا ہے؟ کاش رب کے تمام لوگ نبی ہوتے اور وہ اُن سب پر اپنا روح نازل کرتا!“ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","پھر موسیٰ اور اسرائیل کے بزرگ خیمہ گاہ میں واپس آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","تب رب کی طرف سے زوردار ہَوا چلنے لگی جس نے سمندر کو پار کرنے والے بٹیروں کے غول دھکیل کر خیمہ گاہ کے ارد گرد زمین پر پھینک دیئے۔ اُن کے غول تین فٹ اونچے اور خیمہ گاہ کے چاروں طرف 30 کلو میٹر تک پڑے رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","اُس پورے دن اور رات اور اگلے پورے دن لوگ نکل کر بٹیریں جمع کرتے رہے۔ ہر ایک نے کم از کم دس بڑی ٹوکریاں بھر لیں۔ پھر اُنہوں نے اُن کا گوشت خیمے کے ارد گرد زمین پر پھیلا دیا تاکہ وہ خشک ہو جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","لیکن گوشت کے پہلے ٹکڑے ابھی منہ میں تھے کہ رب کا غضب اُن پر آن پڑا، اور اُس نے اُن میں سخت وبا پھیلنے دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","چنانچہ مقام کا نام قبروت ہتاوہ یعنی ’لالچ کی قبریں‘ رکھا گیا، کیونکہ وہاں اُنہوں نے اُن لوگوں کو دفن کیا جو گوشت کے لالچ میں آ گئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","اِس کے بعد اسرائیلی قبروت ہتاوہ سے روانہ ہو کر حصیرات پہنچ گئے۔ وہاں وہ خیمہ زن ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","ایک دن مریم اور ہارون موسیٰ کے خلاف باتیں کرنے لگے۔ وجہ یہ تھی کہ اُس نے کوش کی ایک عورت سے شادی کی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","اُنہوں نے پوچھا، ”کیا رب صرف موسیٰ کی معرفت بات کرتا ہے؟ کیا اُس نے ہم سے بھی بات نہیں کی؟“ رب نے اُن کی یہ باتیں سنیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","لیکن موسیٰ نہایت حلیم تھا۔ دنیا میں اُس جیسا حلیم کوئی نہیں تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","اچانک رب موسیٰ، ہارون اور مریم سے مخاطب ہوا، ”تم تینوں باہر نکل کر ملاقات کے خیمے کے پاس آؤ۔“ تینوں وہاں پہنچے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","تب رب بادل کے ستون میں اُتر کر ملاقات کے خیمے کے دروازے پر کھڑا ہوا۔ اُس نے ہارون اور مریم کو بُلایا تو دونوں آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","اُس نے کہا، ”میری بات سنو۔ جب تمہارے درمیان نبی ہوتا ہے تو مَیں اپنے آپ کو رویا میں اُس پر ظاہر کرتا ہوں یا خواب میں اُس سے مخاطب ہوتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","لیکن میرے خادم موسیٰ کی اَور بات ہے۔ اُسے مَیں نے اپنے پورے گھرانے پر مقرر کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","اُس سے مَیں رُوبرُو ہم کلام ہوتا ہوں۔ اُس سے مَیں معموں کے ذریعے نہیں بلکہ صاف صاف بات کرتا ہوں۔ وہ رب کی صورت دیکھتا ہے۔ تو پھر تم میرے خادم کے خلاف باتیں کرنے سے کیوں نہ ڈرے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","رب کا غضب اُن پر آن پڑا، اور وہ چلا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","جب بادل کا ستون خیمے سے دُور ہوا تو مریم کی جِلد برف کی مانند سفید تھی۔ وہ کوڑھ کا شکار ہو گئی تھی۔ ہارون اُس کی طرف مُڑا تو اُس کی حالت دیکھی ");
INSERT INTO urdgvu_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","اور موسیٰ سے کہا، ”میرے آقا، مہربانی کر کے ہمیں اِس گناہ کی سزا نہ دیں جو ہماری حماقت کے باعث سرزد ہوا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","مریم کو اِس حالت میں نہ چھوڑیں۔ وہ تو ایسے بچے کی مانند ہے جو مُردہ پیدا ہوا ہو، جس کے جسم کا آدھا حصہ گل چکا ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","تب موسیٰ نے پکار کر رب سے کہا، ”اے اللہ، مہربانی کر کے اُسے شفا دے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","رب نے جواب میں موسیٰ سے کہا، ”اگر مریم کا باپ اُس کے منہ پر تھوکتا تو کیا وہ پورے ہفتے تک شرم محسوس نہ کرتی؟ اُسے ایک ہفتے کے لئے خیمہ گاہ کے باہر بند رکھ۔ اِس کے بعد اُسے واپس لایا جا سکتا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","چنانچہ مریم کو ایک ہفتے کے لئے خیمہ گاہ کے باہر بند رکھا گیا۔ لوگ اُس وقت تک سفر کے لئے روانہ نہ ہوئے جب تک اُسے واپس نہ لایا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","جب وہ واپس آئی تو اسرائیلی حصیرات سے روانہ ہو کر فاران کے ریگستان میں خیمہ زن ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","پھر رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","”کچھ آدمی ملکِ کنعان کا جائزہ لینے کے لئے بھیج دے، کیونکہ مَیں اُسے اسرائیلیوں کو دینے کو ہوں۔ ہر قبیلے میں سے ایک راہنما کو چن کر بھیج دے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","موسیٰ نے رب کے کہنے پر اُنہیں دشتِ فاران سے بھیجا۔ سب اسرائیلی راہنما تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","اُن کے نام یہ ہیں: روبن کے قبیلے سے سموع بن زکور، ");
INSERT INTO urdgvu_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","شمعون کے قبیلے سے سافط بن حوری، ");
INSERT INTO urdgvu_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","یہوداہ کے قبیلے سے کالب بن یفُنّہ، ");
INSERT INTO urdgvu_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","اِشکار کے قبیلے سے اِجال بن یوسف، ");
INSERT INTO urdgvu_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","افرائیم کے قبیلے سے ہوسیع بن نون، ");
INSERT INTO urdgvu_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","بن یمین کے قبیلے سے فلطی بن رفُو، ");
INSERT INTO urdgvu_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","زبولون کے قبیلے سے جدی ایل بن سودی، ");
INSERT INTO urdgvu_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","یوسف کے بیٹے منسّی کے قبیلے سے جَدی بن سُوسی، ");
INSERT INTO urdgvu_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","دان کے قبیلے سے عمی ایل بن جملّی، ");
INSERT INTO urdgvu_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","آشر کے قبیلے سے ستور بن میکائیل، ");
INSERT INTO urdgvu_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","نفتالی کے قبیلے سے نخبی بن وُفسی، ");
INSERT INTO urdgvu_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","جد کے قبیلے سے جیُوایل بن ماکی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","موسیٰ نے اِن ہی بارہ آدمیوں کو ملک کا جائزہ لینے کے لئے بھیجا۔ اُس نے ہوسیع کا نام یشوع یعنی ’رب نجات ہے‘ میں بدل دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","اُنہیں رُخصت کرنے سے پہلے اُس نے کہا، ”دشتِ نجب سے گزر کر پہاڑی علاقے تک پہنچو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","معلوم کرو کہ یہ کس طرح کا ملک ہے اور اُس کے باشندے کیسے ہیں۔ کیا وہ طاقت ور ہیں یا کمزور، تعداد میں کم ہیں یا زیادہ؟ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","جس ملک میں وہ بستے ہیں کیا وہ اچھا ہے کہ نہیں؟ وہ کس قسم کے شہروں میں رہتے ہیں؟ کیا اُن کی چاردیواریاں ہیں کہ نہیں؟ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ملک کی زمین زرخیز ہے یا بنجر؟ اُس میں درخت ہیں کہ نہیں؟ اور جرأت کر کے ملک کا کچھ پھل چن کر لے آؤ۔“ اُس وقت پہلے انگور پک گئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","چنانچہ اِن آدمیوں نے سفر کر کے دشتِ صین سے رحوب تک ملک کا جائزہ لیا۔ رحوب لبو حمات کے قریب ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","وہ دشتِ نجب سے گزر کر حبرون پہنچے جہاں عناق کے بیٹے اخی مان، سیسی اور تلمی رہتے تھے۔ (حبرون کو مصر کے شہر ضُعن سے سات سال پہلے تعمیر کیا گیا تھا)۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","جب وہ وادیٔ اِسکال تک پہنچے تو اُنہوں نے ایک ڈالی کاٹ لی جس پر انگور کا گُچھا لگا ہوا تھا۔ دو آدمیوں نے یہ انگور، کچھ انار اور کچھ انجیر لاٹھی پر لٹکائے اور اُسے اُٹھا کر چل پڑے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","اُس جگہ کا نام اُس گُچھے کے سبب سے جو اسرائیلیوں نے وہاں سے کاٹ لیا اِسکال یعنی گُچھا رکھا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","چالیس دن تک ملک کا کھوج لگاتے لگاتے وہ لوٹ آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","وہ موسیٰ، ہارون اور اسرائیل کی پوری جماعت کے پاس آئے جو دشتِ فاران میں قادس کی جگہ پر انتظار کر رہے تھے۔ وہاں اُنہوں نے سب کچھ بتایا جو اُنہوں نے معلوم کیا تھا اور اُنہیں وہ پھل دکھائے جو لے کر آئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","اُنہوں نے موسیٰ کو رپورٹ دی، ”ہم اُس ملک میں گئے جہاں آپ نے ہمیں بھیجا تھا۔ واقعی اُس ملک میں دودھ اور شہد کی کثرت ہے۔ یہاں ہمارے پاس اُس کے کچھ پھل بھی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","لیکن اُس کے باشندے طاقت ور ہیں۔ اُن کے شہروں کی فصیلیں ہیں، اور وہ نہایت بڑے ہیں۔ ہم نے وہاں عناق کی اولاد بھی دیکھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","عمالیقی دشتِ نجب میں رہتے ہیں جبکہ حِتّی، یبوسی اور اموری پہاڑی علاقے میں آباد ہیں۔ کنعانی ساحلی علاقے اور دریائے یردن کے کنارے کنارے بستے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","کالب نے موسیٰ کے سامنے جمع شدہ لوگوں کو اشارہ کیا کہ وہ خاموش ہو جائیں۔ پھر اُس نے کہا، ”آئیں، ہم ملک میں داخل ہو جائیں اور اُس پر قبضہ کر لیں، کیونکہ ہم یقیناً یہ کرنے کے قابل ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","لیکن دوسرے آدمیوں نے جو اُس کے ساتھ ملک کو دیکھنے گئے تھے کہا، ”ہم اُن لوگوں پر حملہ نہیں کر سکتے، کیونکہ وہ ہم سے طاقت ور ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","اُنہوں نے اسرائیلیوں کے درمیان اُس ملک کے بارے میں غلط افواہیں پھیلائیں جس کی تفتیش اُنہوں نے کی تھی۔ اُنہوں نے کہا، ”جس ملک میں سے ہم گزرے تاکہ اُس کا جائزہ لیں وہ اپنے باشندوں کو ہڑپ کر لیتا ہے۔ جو بھی اُس میں رہتا ہے نہایت درازقد ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ہم نے وہاں دیو قامت افراد بھی دیکھے۔ (عناق کے بیٹے دیو قامت افراد کی اولاد تھے)۔ اُن کے سامنے ہم اپنے آپ کو ٹڈی جیسا محسوس کر رہے تھے، اور ہم اُن کی نظر میں ایسے تھے بھی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","اُس رات تمام لوگ چیخیں مار مار کر روتے رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","سب موسیٰ اور ہارون کے خلاف بڑبڑانے لگے۔ پوری جماعت نے اُن سے کہا، ”کاش ہم مصر یا اِس ریگستان میں مر گئے ہوتے! ");
INSERT INTO urdgvu_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","رب ہمیں کیوں اُس ملک میں لے جا رہا ہے؟ کیا اِس لئے کہ دشمن ہمیں تلوار سے قتل کرے اور ہمارے بال بچوں کو لُوٹ لے؟ کیا بہتر نہیں ہو گا کہ ہم مصر واپس جائیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","اُنہوں نے ایک دوسرے سے کہا، ”آؤ، ہم راہنما چن کر مصر واپس چلے جائیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","تب موسیٰ اور ہارون پوری جماعت کے سامنے منہ کے بل گرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","لیکن یشوع بن نون اور کالب بن یفُنّہ باقی دس جاسوسوں سے فرق تھے۔ پریشانی کے عالم میں اُنہوں نے اپنے کپڑے پھاڑ کر ");
INSERT INTO urdgvu_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","پوری جماعت سے کہا، ”جس ملک میں سے ہم گزرے اور جس کی تفتیش ہم نے کی وہ نہایت ہی اچھا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","اگر رب ہم سے خوش ہے تو وہ ضرور ہمیں اُس ملک میں لے جائے گا جس میں دودھ اور شہد کی کثرت ہے۔ وہ ہمیں ضرور یہ ملک دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","رب سے بغاوت مت کرنا۔ اُس ملک کے رہنے والوں سے نہ ڈریں۔ ہم اُنہیں ہڑپ کر جائیں گے۔ اُن کی پناہ اُن سے جاتی رہی ہے جبکہ رب ہمارے ساتھ ہے۔ چنانچہ اُن سے مت ڈریں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","یہ سن کر پوری جماعت اُنہیں سنگسار کرنے کے لئے تیار ہوئی۔ لیکن اچانک رب کا جلال ملاقات کے خیمے پر ظاہر ہوا، اور تمام اسرائیلیوں نے اُسے دیکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","رب نے موسیٰ سے کہا، ”یہ لوگ مجھے کب تک حقیر جانیں گے؟ وہ کب تک مجھ پر ایمان رکھنے سے انکار کریں گے اگرچہ مَیں نے اُن کے درمیان اِتنے معجزے کئے ہیں؟ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","مَیں اُنہیں وبا سے مار ڈالوں گا اور اُنہیں رُوئے زمین پر سے مٹا دوں گا۔ اُن کی جگہ مَیں تجھ سے ایک قوم بناؤں گا جو اُن سے بڑی اور طاقت ور ہو گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","لیکن موسیٰ نے رب سے کہا، ”پھر مصری یہ سن لیں گے! کیونکہ تُو نے اپنی قدرت سے اِن لوگوں کو مصر سے نکال کر یہاں تک پہنچایا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","مصری یہ بات کنعان کے باشندوں کو بتائیں گے۔ یہ لوگ پہلے سے سن چکے ہیں کہ رب اِس قوم کے ساتھ ہے، کہ تجھے رُوبرُو دیکھا جاتا ہے، کہ تیرا بادل اُن کے اوپر ٹھہرا رہتا ہے، اور کہ تُو دن کے وقت بادل کے ستون میں اور رات کو آگ کے ستون میں اِن کے آگے آگے چلتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","اگر تُو ایک دم اِس پوری قوم کو تباہ کر ڈالے تو باقی قومیں یہ سن کر کہیں گی، ");
INSERT INTO urdgvu_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","’رب اِن لوگوں کو اُس ملک میں لے جانے کے قابل نہیں تھا جس کا وعدہ اُس نے اُن سے قَسم کھا کر کیا تھا۔ اِسی لئے اُس نے اُنہیں ریگستان میں ہلاک کر دیا۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","اے رب، اب اپنی قدرت یوں ظاہر کر جس طرح تُو نے فرمایا ہے۔ کیونکہ تُو نے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","’رب تحمل اور شفقت سے بھرپور ہے۔ وہ گناہ اور نافرمانی معاف کرتا ہے، لیکن ہر ایک کو اُس کی مناسب سزا بھی دیتا ہے۔ جب والدین گناہ کریں تو اُن کی اولاد کو بھی تیسری اور چوتھی پشت تک سزا کے نتائج بھگتنے پڑیں گے۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","اِن لوگوں کا قصور اپنی عظیم شفقت کے مطابق معاف کر۔ اُنہیں اُس طرح معاف کر جس طرح تُو اُنہیں مصر سے نکلتے وقت اب تک معاف کرتا رہا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","رب نے جواب دیا، ”تیرے کہنے پر مَیں نے اُنہیں معاف کر دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","اِس کے باوجود میری حیات کی قَسم اور میرے جلال کی قَسم جو پوری دنیا کو معمور کرتا ہے، ");
INSERT INTO urdgvu_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","اِن لوگوں میں سے کوئی بھی اُس ملک میں داخل نہیں ہو گا۔ اُنہوں نے میرا جلال اور میرے معجزے دیکھے ہیں جو مَیں نے مصر اور ریگستان میں کر دکھائے ہیں۔ توبھی اُنہوں نے دس دفعہ مجھے آزمایا اور میری نہ سنی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","اُن میں سے ایک بھی اُس ملک کو نہیں دیکھے گا جس کا وعدہ مَیں نے قَسم کھا کر اُن کے باپ دادا سے کیا تھا۔ جس نے بھی مجھے حقیر جانا ہے وہ کبھی اُسے نہیں دیکھے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","صرف میرا خادم کالب مختلف ہے۔ اُس کی روح فرق ہے۔ وہ پورے دل سے میری پیروی کرتا ہے، اِس لئے مَیں اُسے اُس ملک میں لے جاؤں گا جس میں اُس نے سفر کیا ہے۔ اُس کی اولاد ملک میراث میں پائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","لیکن فی الحال عمالیقی اور کنعانی اُس کی وادیوں میں آباد رہیں گے۔ چنانچہ کل مُڑ کر واپس چلو۔ ریگستان میں بحرِ قُلزم کی طرف روانہ ہو جاؤ۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","رب نے موسیٰ اور ہارون سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","”یہ شریر جماعت کب تک میرے خلاف بڑبڑاتی رہے گی؟ اُن کے گلے شکوے مجھ تک پہنچ گئے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","اِس لئے اُنہیں بتاؤ، ’رب فرماتا ہے کہ میری حیات کی قَسم، مَیں تمہارے ساتھ وہی کچھ کروں گا جو تم نے میرے سامنے کہا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","تم اِس ریگستان میں مر کر یہیں پڑے رہو گے، ہر ایک جو 20 سال یا اِس سے زائد کا ہے، جو مردم شماری میں گنا گیا اور جو میرے خلاف بڑبڑایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","گو مَیں نے ہاتھ اُٹھا کر قَسم کھائی تھی کہ مَیں تجھے اُس میں بساؤں گا تم میں سے کوئی بھی اُس ملک میں داخل نہیں ہو گا۔ صرف کالب بن یفُنّہ اور یشوع بن نون داخل ہوں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","تم نے کہا تھا کہ دشمن ہمارے بچوں کو لُوٹ لیں گے۔ لیکن اُن ہی کو مَیں اُس ملک میں لے جاؤں گا جسے تم نے رد کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","لیکن تم خود داخل نہیں ہو گے۔ تمہاری لاشیں اِس ریگستان میں پڑی رہیں گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","تمہارے بچے 40 سال تک یہاں ریگستان میں گلہ بان ہوں گے۔ اُنہیں تمہاری بےوفائی کے سبب سے اُس وقت تک تکلیف اُٹھانی پڑے گی جب تک تم میں سے آخری شخص مر نہ گیا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","تم نے چالیس دن کے دوران اُس ملک کا جائزہ لیا۔ اب تمہیں چالیس سال تک اپنے گناہوں کا نتیجہ بھگتنا پڑے گا۔ تب تمہیں پتا چلے گا کہ اِس کا کیا مطلب ہے کہ مَیں تمہاری مخالفت کرتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","مَیں، رب نے یہ بات فرمائی ہے۔ مَیں یقیناً یہ سب کچھ اُس ساری شریر جماعت کے ساتھ کروں گا جس نے مل کر میری مخالفت کی ہے۔ اِسی ریگستان میں وہ ختم ہو جائیں گے، یہیں مر جائیں گے‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_36‏","005_14_36‏","NUM","14","36‏","37","جن آدمیوں کو موسیٰ نے ملک کا جائزہ لینے کے لئے بھیجا تھا، رب نے اُنہیں فوراً مہلک وبا سے مار ڈالا، کیونکہ اُن کے غلط افواہیں پھیلانے سے پوری جماعت بڑبڑانے لگی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","صرف یشوع بن نون اور کالب بن یفُنّہ زندہ رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","جب موسیٰ نے رب کی یہ باتیں اسرائیلیوں کو بتائیں تو وہ خوب ماتم کرنے لگے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","اگلی صبح سویرے وہ اُٹھے اور یہ کہتے ہوئے اونچے پہاڑی علاقے کے لئے روانہ ہوئے کہ ہم سے غلطی ہوئی ہے، لیکن اب ہم حاضر ہیں اور اُس جگہ کی طرف جا رہے ہیں جس کا ذکر رب نے کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","لیکن موسیٰ نے کہا، ”تم کیوں رب کی خلاف ورزی کر رہے ہو؟ تم کامیاب نہیں ہو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","وہاں نہ جاؤ، کیونکہ رب تمہارے ساتھ نہیں ہے۔ تم دشمنوں کے ہاتھوں شکست کھاؤ گے، ");
INSERT INTO urdgvu_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","کیونکہ وہاں عمالیقی اور کنعانی تمہارا سامنا کریں گے۔ چونکہ تم نے اپنا منہ رب سے پھیر لیا ہے اِس لئے وہ تمہارے ساتھ نہیں ہو گا، اور دشمن تمہیں تلوار سے مار ڈالے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","توبھی وہ اپنے غرور میں جرأت کر کے اونچے پہاڑی علاقے کی طرف بڑھے، حالانکہ نہ موسیٰ اور نہ عہد کے صندوق ہی نے خیمہ گاہ کو چھوڑا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","پھر اُس پہاڑی علاقے میں رہنے والے عمالیقی اور کنعانی اُن پر آن پڑے اور اُنہیں مارتے مارتے حُرمہ تک تتر بتر کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","”اسرائیلیوں کو بتانا کہ جب تم اُس ملک میں داخل ہو گے جو مَیں تمہیں دوں گا ");
INSERT INTO urdgvu_vpl VALUES ("NU15_3‏","005_15_3‏","NUM","15","3‏","4","تو جلنے والی قربانیاں یوں پیش کرنا: اگر تم اپنے گائےبَیلوں یا بھیڑبکریوں میں سے ایسی قربانی پیش کرنا چاہو جس کی خوشبو رب کو پسند ہو تو ساتھ ساتھ ڈیڑھ کلو گرام بہترین میدہ بھی پیش کرو جو ایک لٹر زیتون کے تیل کے ساتھ ملایا گیا ہو۔ اِس میں کوئی فرق نہیں کہ یہ بھسم ہونے والی قربانی، مَنت کی قربانی، دلی خوشی کی قربانی یا کسی عید کی قربانی ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ہر بھیڑ کو پیش کرتے وقت ایک لٹر مَے بھی مَے کی نذر کے طور پر پیش کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","جب مینڈھا قربان کیا جائے تو 3 کلو گرام بہترین میدہ بھی ساتھ پیش کرنا جو سوا لٹر تیل کے ساتھ ملایا گیا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","سوا لٹر مَے بھی مَے کی نذر کے طور پر پیش کی جائے۔ ایسی قربانی کی خوشبو رب کو پسند آئے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","اگر تُو رب کو بھسم ہونے والی قربانی، مَنت کی قربانی یا سلامتی کی قربانی کے طور پر جوان بَیل پیش کرنا چاہے ");
INSERT INTO urdgvu_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","تو اُس کے ساتھ ساڑھے 4 کلو گرام بہترین میدہ بھی پیش کرنا جو دو لٹر تیل کے ساتھ ملایا گیا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","دو لٹر مَے بھی مَے کی نذر کے طور پر پیش کی جائے۔ ایسی قربانی کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","لازم ہے کہ جب بھی کسی گائے، بَیل، بھیڑ، مینڈھے، بکری یا بکرے کو چڑھایا جائے تو ایسا ہی کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","اگر ایک سے زائد جانوروں کو قربان کرنا ہے تو ہر ایک کے لئے مقررہ غلہ اور مَے کی نذریں بھی ساتھ ہی پیش کی جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","لازم ہے کہ ہر دیسی اسرائیلی جلنے والی قربانیاں پیش کرتے وقت ایسا ہی کرے۔ پھر اُن کی خوشبو رب کو پسند آئے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","یہ بھی لازم ہے کہ اسرائیل میں عارضی یا مستقل طور پر رہنے والے پردیسی اِن اصولوں کے مطابق اپنی قربانیاں چڑھائیں۔ پھر اُن کی خوشبو رب کو پسند آئے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ملکِ کنعان میں رہنے والے تمام لوگوں کے لئے پابندیاں ایک جیسی ہیں، خواہ وہ دیسی ہوں یا پردیسی، کیونکہ رب کی نظر میں پردیسی تمہارے برابر ہے۔ یہ تمہارے اور تمہاری اولاد کے لئے دائمی اصول ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","تمہارے اور تمہارے ساتھ رہنے والے پردیسی کے لئے ایک ہی شریعت ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","”اسرائیلیوں کو بتانا کہ جب تم اُس ملک میں داخل ہو گے جس میں مَیں تمہیں لے جا رہا ہوں ");
INSERT INTO urdgvu_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","اور وہاں کی پیداوار کھاؤ گے تو پہلے اُس کا ایک حصہ اُٹھانے والی قربانی کے طور پر رب کو پیش کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","فصل کے پہلے خالص آٹے میں سے میرے لئے ایک روٹی بنا کر اُٹھانے والی قربانی کے طور پر پیش کرو۔ وہ گاہنے کی جگہ کی طرف سے رب کے لئے اُٹھانے والی قربانی ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","اپنی فصل کے پہلے خالص آٹے میں سے یہ قربانی پیش کیا کرو۔ یہ اصول ہمیشہ تک لاگو رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","ہو سکتا ہے کہ غیرارادی طور پر تم سے غلطی ہوئی ہے اور تم نے اُن احکام پر پورے طور پر عمل نہیں کیا جو رب موسیٰ کو دے چکا ہے ");
INSERT INTO urdgvu_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","یا جو وہ آنے والی نسلوں کو دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","اگر جماعت اِس بات سے ناواقف تھی اور غیرارادی طور پر اُس سے غلطی ہوئی تو پھر پوری جماعت ایک جوان بَیل بھسم ہونے والی قربانی کے طور پر پیش کرے۔ ساتھ ہی وہ مقررہ غلہ اور مَے کی نذریں بھی پیش کرے۔ اِس کی خوشبو رب کو پسند ہو گی۔ اِس کے علاوہ جماعت گناہ کی قربانی کے لئے ایک بکرا پیش کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","امام اسرائیل کی پوری جماعت کا کفارہ دے تو اُنہیں معافی ملے گی، کیونکہ اُن کا گناہ غیرارادی تھا اور اُنہوں نے رب کو بھسم ہونے والی قربانی اور گناہ کی قربانی پیش کی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","اسرائیلیوں کی پوری جماعت کو پردیسیوں سمیت معافی ملے گی، کیونکہ گناہ غیرارادی تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","اگر صرف ایک شخص سے غیرارادی طور پر گناہ ہوا ہو تو گناہ کی قربانی کے لئے وہ ایک یک سالہ بکری پیش کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","امام رب کے سامنے اُس شخص کا کفارہ دے۔ جب کفارہ دے دیا گیا تو اُسے معافی حاصل ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","یہی اصول پردیسی پر بھی لاگو ہے۔ اگر اُس سے غیرارادی طور پر گناہ ہوا ہو تو وہ معافی حاصل کرنے کے لئے وہی کچھ کرے جو اسرائیلی کو کرنا ہوتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","لیکن اگر کوئی دیسی یا پردیسی جان بوجھ کر گناہ کرتا ہے تو ایسا شخص رب کی اہانت کرتا ہے، اِس لئے لازم ہے کہ اُسے اُس کی قوم میں سے مٹایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","اُس نے رب کا کلام حقیر جان کر اُس کے احکام توڑ ڈالے ہیں، اِس لئے اُسے ضرور قوم میں سے مٹایا جائے۔ وہ اپنے گناہ کا ذمہ دار ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","جب اسرائیلی ریگستان میں سے گزر رہے تھے تو ایک آدمی کو پکڑا گیا جو ہفتے کے دن لکڑیاں جمع کر رہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","جنہوں نے اُسے پکڑا تھا وہ اُسے موسیٰ، ہارون اور پوری جماعت کے پاس لے آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","چونکہ صاف معلوم نہیں تھا کہ اُس کے ساتھ کیا کِیا جائے اِس لئے اُنہوں نے اُسے گرفتار کر لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","پھر رب نے موسیٰ سے کہا، ”اِس آدمی کو ضرور سزائے موت دی جائے۔ پوری جماعت اُسے خیمہ گاہ کے باہر لے جا کر سنگسار کرے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","چنانچہ جماعت نے اُسے خیمہ گاہ کے باہر لے جا کر سنگسار کیا، جس طرح رب نے موسیٰ کو حکم دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","”اسرائیلیوں کو بتانا کہ تم اور تمہارے بعد کی نسلیں اپنے لباس کے کناروں پر پُھندنے لگائیں۔ ہر پُھندنا ایک قرمزی ڈوری سے لباس کے ساتھ لگا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","اِن پُھندنوں کو دیکھ کر تمہیں رب کے تمام احکام یاد رہیں گے اور تم اُن پر عمل کرو گے۔ پھر تم اپنے دلوں اور آنکھوں کی غلط خواہشوں کے پیچھے نہیں پڑو گے بلکہ زناکاری سے دُور رہو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","پھر تم میرے احکام کو یاد کر کے اُن پر عمل کرو گے اور اپنے خدا کے سامنے مخصوص و مُقدّس رہو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","مَیں رب تمہارا خدا ہوں جو تمہیں مصر سے نکال لایا تاکہ تمہارا خدا ہوں۔ مَیں رب تمہارا خدا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_1‏","005_16_1‏","NUM","16","1‏","2","ایک دن قورح بن اِضہار موسیٰ کے خلاف اُٹھا۔ وہ لاوی کے قبیلے کا قِہاتی تھا۔ اُس کے ساتھ روبن کے قبیلے کے تین آدمی تھے، اِلیاب کے بیٹے داتن اور ابیرام اور اون بن پلت۔ اُن کے ساتھ 250 اَور آدمی بھی تھے جو جماعت کے سردار اور اثر و رسوخ والے تھے، اور جو کونسل کے لئے چنے گئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","وہ مل کر موسیٰ اور ہارون کے پاس آ کر کہنے لگے، ”آپ ہم سے زیادتی کر رہے ہیں۔ پوری جماعت مخصوص و مُقدّس ہے، اور رب اُس کے درمیان ہے۔ تو پھر آپ اپنے آپ کو کیوں رب کی جماعت سے بڑھ کر سمجھتے ہیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","یہ سن کر موسیٰ منہ کے بل گرا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","پھر اُس نے قورح اور اُس کے تمام ساتھیوں سے کہا، ”کل صبح رب ظاہر کرے گا کہ کون اُس کا بندہ اور کون مخصوص و مُقدّس ہے۔ اُسی کو وہ اپنے پاس آنے دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","اے قورح، کل اپنے تمام ساتھیوں کے ساتھ بخوردان لے کر ");
INSERT INTO urdgvu_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","رب کے سامنے اُن میں انگارے اور بخور ڈالو۔ جس آدمی کو رب چنے گا وہ مخصوص و مُقدّس ہو گا۔ اب تم لاوی خود زیادتی کر رہے ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","موسیٰ نے قورح سے بات جاری رکھی، ”اے لاوی کی اولاد، سنو! ");
INSERT INTO urdgvu_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","کیا تمہاری نظر میں یہ کوئی چھوٹی بات ہے کہ رب تمہیں اسرائیلی جماعت کے باقی لوگوں سے الگ کر کے اپنے قریب لے آیا تاکہ تم رب کے مقدِس میں اور جماعت کے سامنے کھڑے ہو کر اُن کی خدمت کرو؟ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","وہ تجھے اور تیرے ساتھی لاویوں کو اپنے قریب لایا ہے۔ لیکن اب تم امام کا عُہدہ بھی اپنانا چاہتے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","اپنے ساتھیوں سے مل کر تُو نے ہارون کی نہیں بلکہ رب کی مخالفت کی ہے۔ کیونکہ ہارون کون ہے کہ تم اُس کے خلاف بڑبڑاؤ؟“ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","پھر موسیٰ نے اِلیاب کے بیٹوں داتن اور ابیرام کو بُلایا۔ لیکن اُنہوں نے کہا، ”ہم نہیں آئیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","آپ ہمیں ایک ایسے ملک سے نکال لائے ہیں جہاں دودھ اور شہد کی کثرت ہے تاکہ ہم ریگستان میں ہلاک ہو جائیں۔ کیا یہ کافی نہیں ہے؟ کیا اب آپ ہم پر حکومت بھی کرنا چاہتے ہیں؟ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","نہ آپ نے ہمیں ایسے ملک میں پہنچایا جس میں دودھ اور شہد کی کثرت ہے، نہ ہمیں کھیتوں اور انگور کے باغوں کے وارث بنایا ہے۔ کیا آپ اِن آدمیوں کی آنکھیں نکال ڈالیں گے؟ نہیں، ہم ہرگز نہیں آئیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","تب موسیٰ نہایت غصے ہوا۔ اُس نے رب سے کہا، ”اُن کی قربانی کو قبول نہ کر۔ مَیں نے ایک گدھا تک اُن سے نہیں لیا، نہ مَیں نے اُن میں سے کسی سے بُرا سلوک کیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","قورح سے اُس نے کہا، ”کل تم اور تمہارے ساتھی رب کے سامنے حاضر ہو جاؤ۔ ہارون بھی آئے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","ہر ایک اپنا بخوردان لے کر اُسے رب کو پیش کرے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","چنانچہ ہر آدمی نے اپنا بخوردان لے کر اُس میں انگارے اور بخور ڈال دیا۔ پھر سب موسیٰ اور ہارون کے ساتھ ملاقات کے خیمے کے دروازے پر کھڑے ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","قورح نے پوری جماعت کو دروازے پر موسیٰ اور ہارون کے مقابلے میں جمع کیا تھا۔ اچانک پوری جماعت پر رب کا جلال ظاہر ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","رب نے موسیٰ اور ہارون سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","”اِس جماعت سے الگ ہو جاؤ تاکہ مَیں اِسے فوراً ہلاک کر دوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","موسیٰ اور ہارون منہ کے بل گرے اور بول اُٹھے، ”اے اللہ، تُو تمام جانوں کا خدا ہے۔ کیا تیرا غضب ایک ہی آدمی کے گناہ کے سبب سے پوری جماعت پر آن پڑے گا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","تب رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","”جماعت کو بتا دے کہ قورح، داتن اور ابیرام کے ڈیروں سے دُور ہو جاؤ۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","موسیٰ اُٹھ کر داتن اور ابیرام کے پاس گیا، اور اسرائیل کے بزرگ اُس کے پیچھے چلے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","اُس نے جماعت کو آگاہ کیا، ”اِن شریروں کے خیموں سے دُور ہو جاؤ! جو کچھ بھی اُن کے پاس ہے اُسے نہ چھوؤ، ورنہ تم بھی اُن کے ساتھ تباہ ہو جاؤ گے جب وہ اپنے گناہوں کے باعث ہلاک ہوں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","تب باقی لوگ قورح، داتن اور ابیرام کے ڈیروں سے دُور ہو گئے۔ داتن اور ابیرام اپنے بال بچوں سمیت اپنے خیموں سے نکل کر باہر کھڑے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","موسیٰ نے کہا، ”اب تمہیں پتا چلے گا کہ رب نے مجھے یہ سب کچھ کرنے کے لئے بھیجا ہے۔ مَیں اپنی نہیں بلکہ اُس کی مرضی پوری کر رہا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","اگر یہ لوگ دوسروں کی طرح طبعی موت مریں تو پھر رب نے مجھے نہیں بھیجا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","لیکن اگر رب ایسا کام کرے جو پہلے کبھی نہیں ہوا اور زمین اپنا منہ کھول کر اُنہیں اور اُن کا پورا مال ہڑپ کر لے اور اُنہیں جیتے جی دفنا دے تو اِس کا مطلب ہو گا کہ اِن آدمیوں نے رب کو حقیر جانا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","یہ بات کہتے ہی اُن کے نیچے کی زمین پھٹ گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","اُس نے اپنا منہ کھول کر اُنہیں، اُن کے خاندانوں کو، قورح کے تمام لوگوں کو اور اُن کا سارا سامان ہڑپ کر لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","وہ اپنی پوری ملکیت سمیت جیتے جی دفن ہو گئے۔ زمین اُن کے اوپر واپس آ گئی۔ یوں اُنہیں جماعت سے نکالا گیا اور وہ ہلاک ہو گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","اُن کی چیخیں سن کر اُن کے ارد گرد کھڑے تمام اسرائیلی بھاگ اُٹھے، کیونکہ اُنہوں نے سوچا، ”ایسا نہ ہو کہ زمین ہمیں بھی نگل لے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","اُسی لمحے رب کی طرف سے آگ اُتر آئی اور اُن 250 آدمیوں کو بھسم کر دیا جو بخور پیش کر رہے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","”ہارون امام کے بیٹے اِلی عزر کو اطلاع دے کہ وہ بخوردانوں کو راکھ میں سے نکال کر رکھے۔ اُن کے انگارے وہ دُور پھینکے۔ بخوردانوں کو رکھنے کا سبب یہ ہے کہ اب وہ مخصوص و مُقدّس ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","لوگ اُن آدمیوں کے یہ بخوردان لے لیں جو اپنے گناہ کے باعث جاں بحق ہو گئے۔ وہ اُنہیں کوٹ کر اُن سے چادریں بنائیں اور اُنہیں جلنے والی قربانیوں کی قربان گاہ پر چڑھائیں۔ کیونکہ وہ رب کو پیش کئے گئے ہیں، اِس لئے وہ مخصوص و مُقدّس ہیں۔ یوں وہ اسرائیلیوں کے لئے ایک نشان رہیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","چنانچہ اِلی عزر امام نے پیتل کے یہ بخوردان جمع کئے جو بھسم کئے ہوئے آدمیوں نے رب کو پیش کئے تھے۔ پھر لوگوں نے اُنہیں کوٹ کر اُن سے چادریں بنائیں اور اُنہیں قربان گاہ پر چڑھا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ہارون نے سب کچھ ویسا ہی کیا جیسا رب نے موسیٰ کی معرفت بتایا تھا۔ مقصد یہ تھا کہ بخوردان اسرائیلیوں کو یاد دلاتے رہیں کہ صرف ہارون کی اولاد ہی کو رب کے سامنے آ کر بخور جلانے کی اجازت ہے۔ اگر کوئی اَور ایسا کرے تو اُس کا حال قورح اور اُس کے ساتھیوں کا سا ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","اگلے دن اسرائیل کی پوری جماعت موسیٰ اور ہارون کے خلاف بڑبڑانے لگی۔ اُنہوں نے کہا، ”آپ نے رب کی قوم کو مار ڈالا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","لیکن جب وہ موسیٰ اور ہارون کے مقابلے میں جمع ہوئے اور ملاقات کے خیمے کا رُخ کیا تو اچانک اُس پر بادل چھا گیا اور رب کا جلال ظاہر ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","پھر موسیٰ اور ہارون ملاقات کے خیمے کے سامنے آئے، ");
INSERT INTO urdgvu_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","اور رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","”اِس جماعت سے نکل جاؤ تاکہ مَیں اِسے فوراً ہلاک کر دوں۔“ یہ سن کر دونوں منہ کے بل گرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","موسیٰ نے ہارون سے کہا، ”اپنا بخوردان لے کر اُس میں قربان گاہ کے انگارے اور بخور ڈالیں۔ پھر بھاگ کر جماعت کے پاس چلے جائیں تاکہ اُن کا کفارہ دیں۔ جلدی کریں، کیونکہ رب کا غضب اُن پر ٹوٹ پڑا ہے۔ وبا پھیلنے لگی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","ہارون نے ایسا ہی کیا۔ وہ دوڑ کر جماعت کے بیچ میں گیا۔ لوگوں میں وبا شروع ہو چکی تھی، لیکن ہارون نے رب کو بخور پیش کر کے اُن کا کفارہ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","وہ زندوں اور مُردوں کے بیچ میں کھڑا ہوا تو وبا رُک گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","توبھی 14,700 افراد وبا سے مر گئے۔ اِس میں وہ شامل نہیں ہیں جو قورح کے سبب سے مر گئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","جب وبا رُک گئی تو ہارون موسیٰ کے پاس واپس آیا جو اب تک ملاقات کے خیمے کے دروازے پر کھڑا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","”اسرائیلیوں سے بات کر کے اُن سے 12 لاٹھیاں منگوا لے، ہر قبیلے کے سردار سے ایک لاٹھی۔ ہر لاٹھی پر اُس کے مالک کا نام لکھنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","لاوی کی لاٹھی پر ہارون کا نام لکھنا، کیونکہ ہر قبیلے کے سردار کے لئے ایک لاٹھی ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","پھر اُن کو ملاقات کے خیمے میں عہد کے صندوق کے سامنے رکھ جہاں میری تم سے ملاقات ہوتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","جس آدمی کو مَیں نے چن لیا ہے اُس کی لاٹھی سے کونپلیں پھوٹ نکلیں گی۔ اِس طرح مَیں تمہارے خلاف اسرائیلیوں کی بڑبڑاہٹ ختم کر دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","چنانچہ موسیٰ نے اسرائیلیوں سے بات کی، اور قبیلوں کے ہر سردار نے اُسے اپنی لاٹھی دی۔ اِن 12 لاٹھیوں میں ہارون کی لاٹھی بھی شامل تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","موسیٰ نے اُنہیں ملاقات کے خیمے میں عہد کے صندوق کے سامنے رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","اگلے دن جب وہ ملاقات کے خیمے میں داخل ہوا تو اُس نے دیکھا کہ لاوی کے قبیلے کے سردار ہارون کی لاٹھی سے نہ صرف کونپلیں پھوٹ نکلی ہیں بلکہ پھول اور پکے ہوئے بادام بھی لگے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","موسیٰ تمام لاٹھیاں رب کے سامنے سے باہر لا کر اسرائیلیوں کے پاس لے آیا، اور اُنہوں نے اُن کا معائنہ کیا۔ پھر ہر ایک نے اپنی اپنی لاٹھی واپس لے لی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","رب نے موسیٰ سے کہا، ”ہارون کی لاٹھی عہد کے صندوق کے سامنے رکھ دے۔ یہ باغی اسرائیلیوں کو یاد دلائے گی کہ وہ اپنا بڑبڑانا بند کریں، ورنہ ہلاک ہو جائیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","موسیٰ نے ایسا ہی کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","لیکن اسرائیلیوں نے موسیٰ سے کہا، ”ہائے، ہم مر جائیں گے۔ ہائے، ہم ہلاک ہو جائیں گے، ہم سب ہلاک ہو جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","جو بھی رب کے مقدِس کے قریب آئے وہ مر جائے گا۔ کیا ہم سب ہی ہلاک ہو جائیں گے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","رب نے ہارون سے کہا، ”مقدِس تیری، تیرے بیٹوں اور لاوی کے قبیلے کی ذمہ داری ہے۔ اگر اِس میں کوئی غلطی ہو جائے تو تم قصوروار ٹھہرو گے۔ اِسی طرح اماموں کی خدمت صرف تیری اور تیرے بیٹوں کی ذمہ داری ہے۔ اگر اِس میں کوئی غلطی ہو جائے تو تُو اور تیرے بیٹے قصوروار ٹھہریں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","اپنے قبیلے لاوی کے باقی آدمیوں کو بھی میرے قریب آنے دے۔ وہ تیرے ساتھ مل کر یوں حصہ لیں کہ وہ تیری اور تیرے بیٹوں کی خدمت کریں جب تم خیمے کے سامنے اپنی ذمہ داریاں نبھاؤ گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","تیری خدمت اور خیمے میں خدمت اُن کی ذمہ داری ہے۔ لیکن وہ خیمے کے مخصوص و مُقدّس سامان اور قربان گاہ کے قریب نہ جائیں، ورنہ نہ صرف وہ بلکہ تُو بھی ہلاک ہو جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","یوں وہ تیرے ساتھ مل کر ملاقات کے خیمے کے پورے کام میں حصہ لیں۔ لیکن کسی اَور کو ایسا کرنے کی اجازت نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","صرف تُو اور تیرے بیٹے مقدِس اور قربان گاہ کی دیکھ بھال کریں تاکہ میرا غضب دوبارہ اسرائیلیوں پر نہ بھڑکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","مَیں ہی نے اسرائیلیوں میں سے تیرے بھائیوں یعنی لاویوں کو چن کر تجھے تحفے کے طور پر دیا ہے۔ وہ رب کے لئے مخصوص ہیں تاکہ خیمے میں خدمت کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","لیکن صرف تُو اور تیرے بیٹے امام کی خدمت سرانجام دیں۔ مَیں تمہیں امام کا عُہدہ تحفے کے طور پر دیتا ہوں۔ کوئی اَور قربان گاہ اور مُقدّس چیزوں کے نزدیک نہ آئے، ورنہ اُسے سزائے موت دی جائے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","رب نے ہارون سے کہا، ”مَیں نے خود مقرر کیا ہے کہ تمام اُٹھانے والی قربانیاں تیرا حصہ ہوں۔ یہ ہمیشہ تک قربانیوں میں سے تیرا اور تیری اولاد کا حصہ ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","تمہیں مُقدّس ترین قربانیوں کا وہ حصہ ملنا ہے جو جلایا نہیں جاتا۔ ہاں، تجھے اور تیرے بیٹوں کو وہی حصہ ملنا ہے، خواہ وہ مجھے غلہ کی نذریں، گناہ کی قربانیاں یا قصور کی قربانیاں پیش کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","اُسے مُقدّس جگہ پر کھانا۔ ہر مرد اُسے کھا سکتا ہے۔ خیال رکھ کہ وہ مخصوص و مُقدّس ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","مَیں نے مقرر کیا ہے کہ تمام ہلانے والی قربانیوں کا اُٹھایا ہوا حصہ تیرا ہے۔ یہ ہمیشہ کے لئے تیرے اور تیرے بیٹے بیٹیوں کا حصہ ہے۔ تیرے گھرانے کا ہر فرد اُسے کھا سکتا ہے۔ شرط یہ ہے کہ وہ پاک ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","جب لوگ رب کو اپنی فصلوں کا پہلا پھل پیش کریں گے تو وہ تیرا ہی حصہ ہو گا۔ مَیں تجھے زیتون کے تیل، نئی مَے اور اناج کا بہترین حصہ دیتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","فصلوں کا جو بھی پہلا پھل وہ رب کو پیش کریں گے وہ تیرا ہی ہو گا۔ تیرے گھرانے کا ہر پاک فرد اُسے کھا سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","اسرائیل میں جو بھی چیز رب کے لئے مخصوص و مُقدّس کی گئی ہے وہ تیری ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","ہر انسان اور ہر حیوان کا جو پہلوٹھا رب کو پیش کیا جاتا ہے وہ تیرا ہی ہے۔ لیکن لازم ہے کہ تُو ہر انسان اور ہر ناپاک جانور کے پہلوٹھے کا فدیہ دے کر اُسے چھڑائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","جب وہ ایک ماہ کے ہیں تو اُن کے عوض چاندی کے پانچ سِکے دینا۔ (ہر سِکے کا وزن مقدِس کے باٹوں کے مطابق 11 گرام ہو)۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","لیکن گائےبَیلوں اور بھیڑبکریوں کے پہلے بچوں کا فدیہ یعنی معاوضہ نہ دینا۔ وہ مخصوص و مُقدّس ہیں۔ اُن کا خون قربان گاہ پر چھڑک دینا اور اُن کی چربی جلا دینا۔ ایسی قربانی رب کو پسند ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","اُن کا گوشت ویسے ہی تمہارے لئے ہو، جیسے ہلانے والی قربانی کا سینہ اور دہنی ران بھی تمہارے لئے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","مُقدّس قربانیوں میں سے تمام اُٹھانے والی قربانیاں تیرا اور تیرے بیٹے بیٹیوں کا حصہ ہیں۔ مَیں نے اُسے ہمیشہ کے لئے تجھے دیا ہے۔ یہ نمک کا دائمی عہد ہے جو مَیں نے تیرے اور تیری اولاد کے ساتھ قائم کیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","رب نے ہارون سے کہا، ”تُو میراث میں زمین نہیں پائے گا۔ اسرائیل میں تجھے کوئی حصہ نہیں دیا جائے گا، کیونکہ اسرائیلیوں کے درمیان مَیں ہی تیرا حصہ اور تیری میراث ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","اپنی پیداوار کا جو دسواں حصہ اسرائیلی مجھے دیتے ہیں وہ مَیں لاویوں کو دیتا ہوں۔ یہ اُن کی وراثت ہے، جو اُنہیں ملاقات کے خیمے میں خدمت کرنے کے بدلے میں ملتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","اب سے اسرائیلی ملاقات کے خیمے کے قریب نہ آئیں، ورنہ اُنہیں اپنی خطا کا نتیجہ برداشت کرنا پڑے گا اور وہ ہلاک ہو جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","صرف لاوی ملاقات کے خیمے میں خدمت کریں۔ اگر اِس میں کوئی غلطی ہو جائے تو وہی قصوروار ٹھہریں گے۔ یہ ایک دائمی اصول ہے۔ اُنہیں اسرائیل میں میراث میں زمین نہیں ملے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","کیونکہ مَیں نے اُنہیں وہی دسواں حصہ میراث کے طور پر دیا ہے جو اسرائیلی مجھے اُٹھانے والی قربانی کے طور پر پیش کرتے ہیں۔ اِس وجہ سے مَیں نے اُن کے بارے میں کہا کہ اُنہیں باقی اسرائیلیوں کے ساتھ میراث میں زمین نہیں ملے گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","”لاویوں کو بتانا کہ تمہیں اسرائیلیوں کی پیداوار کا دسواں حصہ ملے گا۔ یہ رب کی طرف سے تمہاری وراثت ہو گی۔ لازم ہے کہ تم اِس کا دسواں حصہ رب کو اُٹھانے والی قربانی کے طور پر پیش کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","تمہاری یہ قربانی نئے اناج یا نئے انگور کے رس کی قربانی کے برابر قرار دی جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","اِس طرح تم بھی رب کو اسرائیلیوں کی پیداوار کے دسویں حصے میں سے اُٹھانے والی قربانی پیش کرو گے۔ رب کے لئے یہ قربانی ہارون امام کو دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","جو بھی تمہیں ملا ہے اُس میں سے سب سے اچھا اور مُقدّس حصہ رب کو دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","جب تم اِس کا سب سے اچھا حصہ پیش کرو گے تو اُسے نئے اناج یا نئے انگور کے رس کی قربانی کے برابر قرار دیا جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","تم اپنے گھرانوں سمیت اِس کا باقی حصہ کہیں بھی کھا سکتے ہو، کیونکہ یہ ملاقات کے خیمے میں تمہاری خدمت کا اجر ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","اگر تم نے پہلے اِس کا بہترین حصہ پیش کیا ہو تو پھر اِسے کھانے میں تمہارا کوئی قصور نہیں ہو گا۔ پھر اسرائیلیوں کی مخصوص و مُقدّس قربانیاں تم سے ناپاک نہیں ہو جائیں گی اور تم نہیں مرو گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","رب نے موسیٰ اور ہارون سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","”اسرائیلیوں کو بتانا کہ وہ تمہارے پاس سرخ رنگ کی جوان گائے لے کر آئیں۔ اُس میں نقص نہ ہو اور اُس پر کبھی جوا نہ رکھا گیا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","تم اُسے اِلی عزر امام کو دینا جو اُسے خیمے کے باہر لے جائے۔ وہاں اُسے اُس کی موجودگی میں ذبح کیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","پھر اِلی عزر امام اپنی اُنگلی سے اُس کے خون سے کچھ لے کر ملاقات کے خیمے کے سامنے والے حصے کی طرف چھڑکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","اُس کی موجودگی میں پوری کی پوری گائے کو جلایا جائے۔ اُس کی کھال، گوشت، خون اور انتڑیوں کا گوبر بھی جلایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","پھر وہ دیودار کی لکڑی، زوفا اور قرمزی رنگ کا دھاگا لے کر اُسے جلتی ہوئی گائے پر پھینکے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","اِس کے بعد وہ اپنے کپڑوں کو دھو کر نہا لے۔ پھر وہ خیمہ گاہ میں آ سکتا ہے لیکن شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","جس آدمی نے گائے کو جلایا وہ بھی اپنے کپڑوں کو دھو کر نہا لے۔ وہ بھی شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","ایک دوسرا آدمی جو پاک ہے گائے کی راکھ اکٹھی کر کے خیمہ گاہ کے باہر کسی پاک جگہ پر ڈال دے۔ وہاں اسرائیل کی جماعت اُسے ناپاکی دُور کرنے کا پانی تیار کرنے کے لئے محفوظ رکھے۔ یہ گناہ سے پاک کرنے کے لئے استعمال ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","جس آدمی نے راکھ اکٹھی کی ہے وہ بھی اپنے کپڑوں کو دھو لے۔ وہ بھی شام تک ناپاک رہے گا۔ یہ اسرائیلیوں اور اُن کے درمیان رہنے والے پردیسیوں کے لئے دائمی اصول ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","جو بھی لاش چھوئے وہ سات دن تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","تیسرے اور ساتویں دن وہ اپنے آپ پر ناپاکی دُور کرنے کا پانی چھڑک کر پاک صاف ہو جائے۔ اِس کے بعد ہی وہ پاک ہو گا۔ لیکن اگر وہ اِن دونوں دنوں میں اپنے آپ کو یوں پاک نہ کرے تو ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","جو بھی لاش چھو کر اپنے آپ کو یوں پاک نہیں کرتا وہ رب کے مقدِس کو ناپاک کرتا ہے۔ لازم ہے کہ اُسے اسرائیل میں سے مٹایا جائے۔ چونکہ ناپاکی دُور کرنے کا پانی اُس پر چھڑکا نہیں گیا اِس لئے وہ ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","اگر کوئی ڈیرے میں مر جائے تو جو بھی اُس وقت اُس میں موجود ہو یا داخل ہو جائے وہ سات دن تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ہر کھلا برتن جو ڈھکنے سے بند نہ کیا گیا ہو وہ بھی ناپاک ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","اِسی طرح جو کھلے میدان میں لاش چھوئے وہ بھی سات دن تک ناپاک رہے گا، خواہ وہ تلوار سے یا طبعی موت مرا ہو۔ جو انسان کی کوئی ہڈی یا قبر چھوئے وہ بھی سات دن تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","ناپاکی دُور کرنے کے لئے اُس سرخ رنگ کی گائے کی راکھ میں سے کچھ لینا جو گناہ دُور کرنے کے لئے جلائی گئی تھی۔ اُسے برتن میں ڈال کر تازہ پانی میں ملانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","پھر کوئی پاک آدمی کچھ زوفا لے اور اُسے اِس پانی میں ڈبو کر مرے ہوئے شخص کے خیمے، اُس کے سامان اور اُن لوگوں پر چھڑکے جو اُس کے مرتے وقت وہاں تھے۔ اِسی طرح وہ پانی اُس شخص پر بھی چھڑکے جس نے طبعی یا غیرطبعی موت مرے ہوئے شخص کو، کسی انسان کی ہڈی کو یا کوئی قبر چھوئی ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","پاک آدمی یہ پانی تیسرے اور ساتویں دن ناپاک شخص پر چھڑکے۔ ساتویں دن وہ اُسے پاک کرے۔ جسے پاک کیا جا رہا ہے وہ اپنے کپڑے دھو کر نہا لے تو وہ اُسی شام پاک ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","لیکن جو ناپاک شخص اپنے آپ کو پاک نہیں کرتا اُسے جماعت میں سے مٹانا ہے، کیونکہ اُس نے رب کا مقدِس ناپاک کر دیا ہے۔ ناپاکی دُور کرنے کا پانی اُس پر نہیں چھڑکا گیا، اِس لئے وہ ناپاک رہا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","یہ اُن کے لئے دائمی اصول ہے۔ جس آدمی نے ناپاکی دُور کرنے کا پانی چھڑکا ہے وہ بھی اپنے کپڑے دھوئے۔ بلکہ جس نے بھی یہ پانی چھوا ہے شام تک ناپاک رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","اور ناپاک شخص جو بھی چیز چھوئے وہ ناپاک ہو جاتی ہے۔ نہ صرف یہ بلکہ جو بعد میں یہ ناپاک چیز چھوئے وہ بھی شام تک ناپاک رہے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","پہلے مہینے میں اسرائیل کی پوری جماعت دشتِ صین میں پہنچ کر قادس میں رہنے لگی۔ وہاں مریم نے وفات پائی اور وہیں اُسے دفنایا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","قادس میں پانی دست یاب نہیں تھا، اِس لئے لوگ موسیٰ اور ہارون کے مقابلے میں جمع ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","وہ موسیٰ سے یہ کہہ کر جھگڑنے لگے، ”کاش ہم اپنے بھائیوں کے ساتھ رب کے سامنے مر گئے ہوتے! ");
INSERT INTO urdgvu_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","آپ رب کی جماعت کو کیوں اِس ریگستان میں لے آئے؟ کیا اِس لئے کہ ہم یہاں اپنے مویشیوں سمیت مر جائیں؟ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","آپ ہمیں مصر سے نکال کر اِس ناخوش گوار جگہ پر کیوں لے آئے ہیں؟ یہاں نہ تو اناج، نہ انجیر، انگور یا انار دست یاب ہیں۔ پانی بھی نہیں ہے!“ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","موسیٰ اور ہارون لوگوں کو چھوڑ کر ملاقات کے خیمے کے دروازے پر گئے اور منہ کے بل گرے۔ تب رب کا جلال اُن پر ظاہر ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","”عہد کے صندوق کے سامنے پڑی لاٹھی پکڑ کر ہارون کے ساتھ جماعت کو اکٹھا کر۔ اُن کے سامنے چٹان سے بات کرو تو وہ اپنا پانی دے گی۔ یوں تُو چٹان میں سے جماعت کے لئے پانی نکال کر اُنہیں اُن کے مویشیوں سمیت پانی پلائے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","موسیٰ نے ایسا ہی کیا۔ اُس نے عہد کے صندوق کے سامنے پڑی لاٹھی اُٹھائی ");
INSERT INTO urdgvu_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","اور ہارون کے ساتھ جماعت کو چٹان کے سامنے اکٹھا کیا۔ موسیٰ نے اُن سے کہا، ”اے بغاوت کرنے والو، سنو! کیا ہم اِس چٹان میں سے تمہارے لئے پانی نکالیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","اُس نے لاٹھی کو اُٹھا کر چٹان کو دو مرتبہ مارا تو بہت سا پانی پھوٹ نکلا۔ جماعت اور اُن کے مویشیوں نے خوب پانی پیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","لیکن رب نے موسیٰ اور ہارون سے کہا، ”تمہارا مجھ پر اِتنا ایمان نہیں تھا کہ میری قدوسیت کو اسرائیلیوں کے سامنے قائم رکھتے۔ اِس لئے تم اِس جماعت کو اُس ملک میں نہیں لے جاؤ گے جو مَیں اُنہیں دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","یہ واقعہ مریبہ یعنی ’جھگڑنا‘ کے پانی پر ہوا۔ وہاں اسرائیلیوں نے رب سے جھگڑا کیا، اور وہاں اُس نے اُن پر ظاہر کیا کہ وہ قدوس ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","قادس سے موسیٰ نے ادوم کے بادشاہ کو اطلاع بھیجی، ”آپ کے بھائی اسرائیل کی طرف سے ایک گزارش ہے۔ آپ کو اُن تمام مصیبتوں کے بارے میں علم ہے جو ہم پر آن پڑی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ہمارے باپ دادا مصر گئے تھے اور وہاں ہم بہت عرصے تک رہے۔ مصریوں نے ہمارے باپ دادا اور ہم سے بُرا سلوک کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","لیکن جب ہم نے چلّا کر رب سے منت کی تو اُس نے ہماری سنی اور فرشتہ بھیج کر ہمیں مصر سے نکال لایا۔ اب ہم یہاں قادس شہر میں ہیں جو آپ کی سرحد پر ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","مہربانی کر کے ہمیں اپنے ملک میں سے گزرنے دیں۔ ہم کسی کھیت یا انگور کے باغ میں نہیں جائیں گے، نہ کسی کنوئیں کا پانی پئیں گے۔ ہم شاہراہ پر ہی رہیں گے۔ آپ کے ملک میں سے گزرتے ہوئے ہم اُس سے نہ دائیں اور نہ بائیں طرف ہٹیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","لیکن ادومیوں نے جواب دیا، ”یہاں سے نہ گزرنا، ورنہ ہم نکل کر آپ سے لڑیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","اسرائیل نے دوبارہ خبر بھیجی، ”ہم شاہراہ پر رہتے ہوئے گزریں گے۔ اگر ہمیں یا ہمارے جانوروں کو پانی کی ضرورت ہوئی تو پیسے دے کر خرید لیں گے۔ ہم پیدل ہی گزرنا چاہتے ہیں، اَور کچھ نہیں چاہتے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","لیکن ادومیوں نے دوبارہ انکار کیا۔ ساتھ ہی اُنہوں نے اُن کے ساتھ لڑنے کے لئے ایک بڑی اور طاقت ور فوج بھیجی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","چونکہ ادوم نے اُنہیں گزرنے کی اجازت نہ دی اِس لئے اسرائیلی مُڑ کر دوسرے راستے سے چلے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","اسرائیل کی پوری جماعت قادس سے روانہ ہو کر ہور پہاڑ کے پاس پہنچی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","یہ پہاڑ ادوم کی سرحد پر واقع تھا۔ وہاں رب نے موسیٰ اور ہارون سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","”ہارون اب کوچ کر کے اپنے باپ دادا سے جا ملے گا۔ وہ اُس ملک میں داخل نہیں ہو گا جو مَیں اسرائیلیوں کو دوں گا، کیونکہ تم دونوں نے مریبہ کے پانی پر میرے حکم کی خلاف ورزی کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","ہارون اور اُس کے بیٹے اِلی عزر کو لے کر ہور پہاڑ پر چڑھ جا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ہارون کے کپڑے اُتار کر اُس کے بیٹے اِلی عزر کو پہنا دینا۔ پھر ہارون کوچ کر کے اپنے باپ دادا سے جا ملے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","موسیٰ نے ایسا ہی کیا جیسا رب نے کہا۔ تینوں پوری جماعت کے دیکھتے دیکھتے ہور پہاڑ پر چڑھ گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","موسیٰ نے ہارون کے کپڑے اُتروا کر اُس کے بیٹے اِلی عزر کو پہنا دیئے۔ پھر ہارون وہاں پہاڑ کی چوٹی پر فوت ہوا، اور موسیٰ اور اِلی عزر نیچے اُتر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","جب پوری جماعت کو معلوم ہوا کہ ہارون انتقال کر گیا ہے تو سب نے 30 دن تک اُس کے لئے ماتم کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","دشتِ نجب کے کنعانی ملک عراد کے بادشاہ کو خبر ملی کہ اسرائیلی اتھارِم کی طرف بڑھ رہے ہیں۔ اُس نے اُن پر حملہ کیا اور کئی ایک کو پکڑ کر قید کر لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","تب اسرائیلیوں نے رب کے سامنے مَنت مان کر کہا، ”اگر تُو ہمیں اُن پر فتح دے گا تو ہم اُنہیں اُن کے شہروں سمیت تباہ کر دیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","رب نے اُن کی سنی اور کنعانیوں پر فتح بخشی۔ اسرائیلیوں نے اُنہیں اُن کے شہروں سمیت پوری طرح تباہ کر دیا۔ اِس لئے اُس جگہ کا نام حُرمہ یعنی تباہی پڑ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ہور پہاڑ سے روانہ ہو کر وہ بحرِ قُلزم کی طرف چل دیئے تاکہ ادوم کے ملک میں سے گزرنا نہ پڑے۔ لیکن چلتے چلتے لوگ بےصبر ہو گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","وہ رب اور موسیٰ کے خلاف باتیں کرنے لگے، ”آپ ہمیں مصر سے نکال کر ریگستان میں مرنے کے لئے کیوں لے آئے ہیں؟ یہاں نہ روٹی دست یاب ہے نہ پانی۔ ہمیں اِس گھٹیا قسم کی خوراک سے گھن آتی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","تب رب نے اُن کے درمیان زہریلے سانپ بھیج دیئے جن کے کاٹنے سے بہت سے لوگ مر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","پھر لوگ موسیٰ کے پاس آئے۔ اُنہوں نے کہا، ”ہم نے رب اور آپ کے خلاف باتیں کرتے ہوئے گناہ کیا۔ ہماری سفارش کریں کہ رب ہم سے سانپ دُور کر دے۔“ موسیٰ نے اُن کے لئے دعا کی ");
INSERT INTO urdgvu_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","تو رب نے موسیٰ سے کہا، ”ایک سانپ بنا کر اُسے کھمبے سے لٹکا دے۔ جو بھی ڈسا گیا ہو وہ اُسے دیکھ کر بچ جائے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","چنانچہ موسیٰ نے پیتل کا ایک سانپ بنایا اور کھمبا کھڑا کر کے سانپ کو اُس سے لٹکا دیا۔ اور ایسا ہوا کہ جسے بھی ڈسا گیا تھا وہ پیتل کے سانپ پر نظر کر کے بچ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","اسرائیلی روانہ ہوئے اور اوبوت میں اپنے خیمے لگائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","پھر وہاں سے کوچ کر کے عیّے عباریم میں ڈیرے ڈالے، اُس ریگستان میں جو مشرق کی طرف موآب کے سامنے ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","وہاں سے روانہ ہو کر وہ وادیٔ زِرد میں خیمہ زن ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","جب وادیٔ زِرد سے روانہ ہوئے تو دریائے ارنون کے پرلے یعنی جنوبی کنارے پر خیمہ زن ہوئے۔ یہ دریا ریگستان میں ہے اور اموریوں کے علاقے سے نکلتا ہے۔ یہ اموریوں اور موآبیوں کے درمیان کی سرحد ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","اِس کا ذکر کتاب ’رب کی جنگیں‘ میں بھی ہے، ”واہیب جو سُوفہ میں ہے، دریائے ارنون کی وادیاں ");
INSERT INTO urdgvu_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","اور وادیوں کا وہ ڈھلان جو عار شہر تک جاتا ہے اور موآب کی سرحد پر واقع ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","وہاں سے وہ بیر یعنی ’کنواں‘ پہنچے۔ یہ وہی بیر ہے جہاں رب نے موسیٰ سے کہا، ”لوگوں کو اکٹھا کر تو مَیں اُنہیں پانی دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","اُس وقت اسرائیلیوں نے یہ گیت گایا، ”اے کنوئیں، پھوٹ نکل! اُس کے بارے میں گیت گاؤ، ");
INSERT INTO urdgvu_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","اُس کنوئیں کے بارے میں جسے سرداروں نے کھودا، جسے قوم کے راہنماؤں نے عصائے شاہی اور اپنی لاٹھیوں سے کھودا۔“ پھر وہ ریگستان سے متّنہ کو گئے، ");
INSERT INTO urdgvu_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","متّنہ سے نحلی ایل کو اور نحلی ایل سے بامات کو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","بامات سے وہ موآبیوں کے علاقے کی اُس وادی میں پہنچے جو پِسگہ پہاڑ کے دامن میں ہے۔ اِس پہاڑ کی چوٹی سے وادیٔ یردن کا جنوبی حصہ یشیمون خوب نظر آتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","اسرائیل نے اموریوں کے بادشاہ سیحون کو اطلاع بھیجی، ");
INSERT INTO urdgvu_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","”ہمیں اپنے ملک میں سے گزرنے دیں۔ ہم سیدھے سیدھے گزر جائیں گے۔ نہ ہم کوئی کھیت یا انگور کا باغ چھیڑیں گے، نہ کسی کنوئیں کا پانی پئیں گے۔ ہم آپ کے ملک میں سے سیدھے گزرتے ہوئے شاہراہ پر ہی رہیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","لیکن سیحون نے اُنہیں گزرنے نہ دیا بلکہ اپنی فوج جمع کر کے اسرائیل سے لڑنے کے لئے ریگستان میں چل پڑا۔ یہض پہنچ کر اُس نے اسرائیلیوں سے جنگ کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","لیکن اسرائیلیوں نے اُسے قتل کیا اور دریائے ارنون سے لے کر دریائے یبوق تک یعنی عمونیوں کی سرحد تک اُس کے ملک پر قبضہ کر لیا۔ وہ اِس سے آگے نہ جا سکے کیونکہ عمونیوں نے اپنی سرحد کی حصار بندی کر رکھی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","اسرائیلی تمام اموری شہروں پر قبضہ کر کے اُن میں رہنے لگے۔ اُن میں حسبون اور اُس کے ارد گرد کی آبادیاں شامل تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","حسبون اموری بادشاہ سیحون کا دار الحکومت تھا۔ اُس نے موآب کے پچھلے بادشاہ سے لڑ کر اُس سے یہ علاقہ دریائے ارنون تک چھین لیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","اِس واقعے کا ذکر شاعری میں یوں کیا گیا ہے، ”حسبون کے پاس آ کر اُسے از سرِ نو تعمیر کرو، سیحون کے شہر کو از سرِ نو قائم کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","حسبون سے آگ نکلی، سیحون کے شہر سے شعلہ بھڑکا۔ اُس نے موآب کے شہر عار کو جلا دیا، ارنون کی بلندیوں کے مالکوں کو بھسم کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","اے موآب، تجھ پر افسوس! اے کموس دیوتا کی قوم، تُو ہلاک ہوئی ہے۔ کموس نے اپنے بیٹوں کو مفرور اور اپنی بیٹیوں کو اموری بادشاہ سیحون کی قیدی بنا دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","لیکن جب ہم نے اموریوں پر تیر چلائے تو حسبون کا علاقہ دیبون تک برباد ہوا۔ ہم نے نُفح تک سب کچھ تباہ کیا، وہ نُفح جس کا علاقہ میدبا تک ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","یوں اسرائیل اموریوں کے ملک میں آباد ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","وہاں سے موسیٰ نے اپنے جاسوس یعزیر شہر بھیجے۔ وہاں بھی اموری رہتے تھے۔ اسرائیلیوں نے یعزیر اور اُس کے ارد گرد کے شہروں پر بھی قبضہ کیا اور وہاں کے اموریوں کو نکال دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","اِس کے بعد وہ مُڑ کر بسن کی طرف بڑھے۔ تب بسن کا بادشاہ عوج اپنی تمام فوج لے کر اُن سے لڑنے کے لئے شہر اِدرعی آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","اُس وقت رب نے موسیٰ سے کہا، ”عوج سے نہ ڈرنا۔ مَیں اُسے، اُس کی تمام فوج اور اُس کا ملک تیرے حوالے کر چکا ہوں۔ اُس کے ساتھ وہی سلوک کر جو تُو نے اموریوں کے بادشاہ سیحون کے ساتھ کیا، جس کا دار الحکومت حسبون تھا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","اسرائیلیوں نے عوج، اُس کے بیٹوں اور تمام فوج کو ہلاک کر دیا۔ کوئی بھی نہ بچا۔ پھر اُنہوں نے بسن کے ملک پر قبضہ کر لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","اِس کے بعد اسرائیلی موآب کے میدانوں میں پہنچ کر دریائے یردن کے مشرقی کنارے پر یریحو کے آمنے سامنے خیمہ زن ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","موآب کے بادشاہ بلق بن صفور کو معلوم ہوا کہ اسرائیلیوں نے اموریوں کے ساتھ کیا کچھ کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","موآبیوں نے یہ بھی دیکھا کہ اسرائیلی بہت زیادہ ہیں، اِس لئے اُن پر دہشت چھا گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","اُنہوں نے مِدیانیوں کے بزرگوں سے بات کی، ”اب یہ ہجوم اِس طرح ہمارے ارد گرد کا علاقہ چٹ کر جائے گا جس طرح بَیل میدان کی گھاس چٹ کر جاتا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","تب بلق نے اپنے قاصد فتور شہر کو بھیجے جو دریائے فرات پر واقع تھا اور جہاں بلعام بن بعور اپنے وطن میں رہتا تھا۔ قاصد اُسے بُلانے کے لئے اُس کے پاس پہنچے اور اُسے بلق کا پیغام سنایا، ”ایک قوم مصر سے نکل آئی ہے جو رُوئے زمین پر چھا کر میرے قریب ہی آباد ہوئی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","اِس لئے آئیں اور اِن لوگوں پر لعنت بھیجیں، کیونکہ وہ مجھ سے زیادہ طاقت ور ہیں۔ پھر شاید مَیں اُنہیں شکست دے کر ملک سے بھگا سکوں۔ کیونکہ مَیں جانتا ہوں کہ جنہیں آپ برکت دیتے ہیں اُنہیں برکت ملتی ہے اور جن پر آپ لعنت بھیجتے ہیں اُن پر لعنت آتی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","یہ پیغام لے کر موآب اور مِدیان کے بزرگ روانہ ہوئے۔ اُن کے پاس انعام کے پیسے تھے۔ بلعام کے پاس پہنچ کر اُنہوں نے اُسے بلق کا پیغام سنایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","بلعام نے کہا، ”رات یہاں گزاریں۔ کل مَیں آپ کو بتا دوں گا کہ رب اِس کے بارے میں کیا فرماتا ہے۔“ چنانچہ موآبی سردار اُس کے پاس ٹھہر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","رات کے وقت اللہ بلعام پر ظاہر ہوا۔ اُس نے پوچھا، ”یہ آدمی کون ہیں جو تیرے پاس آئے ہیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","بلعام نے جواب دیا، ”موآب کے بادشاہ بلق بن صفور نے مجھے پیغام بھیجا ہے، ");
INSERT INTO urdgvu_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","’جو قوم مصر سے نکل آئی ہے وہ رُوئے زمین پر چھا گئی ہے۔ اِس لئے آئیں اور میرے لئے اُن پر لعنت بھیجیں۔ پھر شاید مَیں اُن سے لڑ کر اُنہیں بھگا دینے میں کامیاب ہو جاؤں‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","رب نے بلعام سے کہا، ”اُن کے ساتھ نہ جانا۔ تجھے اُن پر لعنت بھیجنے کی اجازت نہیں ہے، کیونکہ اُن پر میری برکت ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","اگلی صبح بلعام جاگ اُٹھا تو اُس نے بلق کے سرداروں سے کہا، ”اپنے وطن واپس چلے جائیں، کیونکہ رب نے مجھے آپ کے ساتھ جانے کی اجازت نہیں دی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","چنانچہ موآبی سردار خالی ہاتھ بلق کے پاس واپس آئے۔ اُنہوں نے کہا، ”بلعام ہمارے ساتھ آنے سے انکار کرتا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","تب بلق نے اَور سردار بھیجے جو پہلے والوں کی نسبت تعداد اور عُہدے کے لحاظ سے زیادہ تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","وہ بلعام کے پاس جا کر کہنے لگے، ”بلق بن صفور کہتے ہیں کہ کوئی بھی بات آپ کو میرے پاس آنے سے نہ روکے، ");
INSERT INTO urdgvu_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","کیونکہ مَیں آپ کو بڑا انعام دوں گا۔ آپ جو بھی کہیں گے مَیں کرنے کے لئے تیار ہوں۔ آئیں تو سہی اور میرے لئے اُن لوگوں پر لعنت بھیجیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","لیکن بلعام نے جواب دیا، ”اگر بلق اپنے محل کو چاندی اور سونے سے بھر کر بھی مجھے دے توبھی مَیں رب اپنے خدا کے فرمان کی خلاف ورزی نہیں کر سکتا، خواہ بات چھوٹی ہو یا بڑی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","آپ دوسرے سرداروں کی طرح رات یہاں گزاریں۔ اِتنے میں مَیں معلوم کروں گا کہ رب مجھے مزید کیا کچھ بتاتا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","اُس رات اللہ بلعام پر ظاہر ہوا اور کہا، ”چونکہ یہ آدمی تجھے بُلانے آئے ہیں اِس لئے اُن کے ساتھ چلا جا۔ لیکن صرف وہی کچھ کرنا جو مَیں تجھے بتاؤں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","صبح کو بلعام نے اُٹھ کر اپنی گدھی پر زِین کسا اور موآبی سرداروں کے ساتھ چل پڑا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","لیکن اللہ نہایت غصے ہوا کہ وہ جا رہا ہے، اِس لئے اُس کا فرشتہ اُس کا مقابلہ کرنے کے لئے راستے میں کھڑا ہو گیا۔ بلعام اپنی گدھی پر سوار تھا اور اُس کے دو نوکر اُس کے ساتھ چل رہے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","جب گدھی نے دیکھا کہ رب کا فرشتہ اپنے ہاتھ میں تلوار تھامے ہوئے راستے میں کھڑا ہے تو وہ راستے سے ہٹ کر کھیت میں چلنے لگی۔ بلعام اُسے مارتے مارتے راستے پر واپس لے آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","پھر وہ انگور کے دو باغوں کے درمیان سے گزرنے لگے۔ راستہ تنگ تھا، کیونکہ وہ دونوں طرف باغوں کی چاردیواری سے بند تھا۔ اب رب کا فرشتہ وہاں کھڑا ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","گدھی یہ دیکھ کر چاردیواری کے ساتھ ساتھ چلنے لگی، اور بلعام کا پاؤں کچلا گیا۔ اُس نے اُسے دوبارہ مارا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","رب کا فرشتہ آگے نکلا اور تیسری مرتبہ راستے میں کھڑا ہو گیا۔ اب راستے سے ہٹ جانے کی کوئی گنجائش نہیں تھی، نہ دائیں طرف اور نہ بائیں طرف۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","جب گدھی نے رب کا فرشتہ دیکھا تو وہ لیٹ گئی۔ بلعام کو غصہ آ گیا، اور اُس نے اُسے اپنی لاٹھی سے خوب مارا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","تب رب نے گدھی کو بولنے دیا، اور اُس نے بلعام سے کہا، ”مَیں نے آپ سے کیا غلط سلوک کیا ہے کہ آپ مجھے اب تیسری دفعہ پیٹ رہے ہیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","بلعام نے جواب دیا، ”تُو نے مجھے بےوقوف بنایا ہے! کاش میرے ہاتھ میں تلوار ہوتی تو مَیں ابھی تجھے ذبح کر دیتا!“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","گدھی نے بلعام سے کہا، ”کیا مَیں آپ کی گدھی نہیں ہوں جس پر آپ آج تک سوار ہوتے رہے ہیں؟ کیا مجھے کبھی ایسا کرنے کی عادت تھی؟“ اُس نے کہا، ”نہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","پھر رب نے بلعام کی آنکھیں کھولیں اور اُس نے رب کے فرشتے کو دیکھا جو اب تک ہاتھ میں تلوار تھامے ہوئے راستے میں کھڑا تھا۔ بلعام نے منہ کے بل گر کر سجدہ کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","رب کے فرشتے نے پوچھا، ”تُو نے تین بار اپنی گدھی کو کیوں پیٹا؟ مَیں تیرے مقابلے میں آیا ہوں، کیونکہ جس طرف تُو بڑھ رہا ہے اُس کا انجام بُرا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","گدھی تین مرتبہ مجھے دیکھ کر میری طرف سے ہٹ گئی۔ اگر وہ نہ ہٹتی تو تُو اِس وقت ہلاک ہو گیا ہوتا اگرچہ مَیں گدھی کو چھوڑ دیتا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","بلعام نے رب کے فرشتے سے کہا، ”مَیں نے گناہ کیا ہے۔ مجھے معلوم نہیں تھا کہ تُو میرے مقابلے میں راستے میں کھڑا ہے۔ لیکن اگر میرا سفر تجھے بُرا لگے تو مَیں اب واپس چلا جاؤں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","رب کے فرشتے نے کہا، ”اِن آدمیوں کے ساتھ اپنا سفر جاری رکھ۔ لیکن صرف وہی کچھ کہنا جو مَیں تجھے بتاؤں گا۔“ چنانچہ بلعام نے بلق کے سرداروں کے ساتھ اپنا سفر جاری رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","جب بلق کو خبر ملی کہ بلعام آ رہا ہے تو وہ اُس سے ملنے کے لئے موآب کے اُس شہر تک گیا جو موآب کی سرحد دریائے ارنون پر واقع ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","اُس نے بلعام سے کہا، ”کیا مَیں نے آپ کو اطلاع نہیں بھیجی تھی کہ آپ ضرور آئیں؟ آپ کیوں نہیں آئے؟ کیا آپ نے سوچا کہ مَیں آپ کو مناسب انعام نہیں دے پاؤں گا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","بلعام نے جواب دیا، ”بہر حال اب مَیں پہنچ گیا ہوں۔ لیکن مَیں صرف وہی کچھ کہہ سکتا ہوں جو اللہ نے پہلے ہی میرے منہ میں ڈال دیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","پھر بلعام بلق کے ساتھ قِریَت حصات گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","وہاں بلق نے گائےبَیل اور بھیڑبکریاں قربان کر کے اُن کے گوشت میں سے بلعام اور اُس کے ساتھ والے سرداروں کو دے دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","اگلی صبح بلق بلعام کو ساتھ لے کر ایک اونچی جگہ پر چڑھ گیا جس کا نام باموت بعل تھا۔ وہاں سے اسرائیلی خیمہ گاہ کا کنارہ نظر آتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","بلعام نے کہا، ”یہاں میرے لئے سات قربان گاہیں بنائیں۔ ساتھ ساتھ میرے لئے سات بَیل اور سات مینڈھے تیار کر رکھیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","بلق نے ایسا ہی کیا، اور دونوں نے مل کر ہر قربان گاہ پر ایک بَیل اور ایک مینڈھا چڑھایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","پھر بلعام نے بلق سے کہا، ”یہاں اپنی قربانی کے پاس کھڑے رہیں۔ مَیں کچھ فاصلے پر جاتا ہوں، شاید رب مجھ سے ملنے آئے۔ جو کچھ وہ مجھ پر ظاہر کرے مَیں آپ کو بتا دوں گا۔“ یہ کہہ کر وہ ایک اونچے مقام پر چلا گیا جو ہریالی سے بالکل محروم تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","وہاں اللہ بلعام سے ملا۔ بلعام نے کہا، ”مَیں نے سات قربان گاہیں تیار کر کے ہر قربان گاہ پر ایک بَیل اور ایک مینڈھا قربان کیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","تب رب نے اُسے بلق کے لئے پیغام دیا اور کہا، ”بلق کے پاس واپس جا اور اُسے یہ پیغام سنا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","بلعام بلق کے پاس واپس آیا جو اب تک موآبی سرداروں کے ساتھ اپنی قربانی کے پاس کھڑا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","بلعام بول اُٹھا، ”بلق مجھے اَرام سے یہاں لایا ہے، موآبی بادشاہ نے مجھے مشرقی پہاڑوں سے بُلا کر کہا، ’آؤ، یعقوب پر میرے لئے لعنت بھیجو۔ آؤ، اسرائیل کو بددعا دو۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","مَیں کس طرح اُن پر لعنت بھیجوں جن پر اللہ نے لعنت نہیں بھیجی؟ مَیں کس طرح اُنہیں بددعا دوں جنہیں رب نے بددعا نہیں دی؟ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","مَیں اُنہیں چٹانوں کی چوٹی سے دیکھتا ہوں، پہاڑیوں سے اُن کا مشاہدہ کرتا ہوں۔ واقعی یہ ایک ایسی قوم ہے جو دوسروں سے الگ رہتی ہے۔ یہ اپنے آپ کو دوسری قوموں سے ممتاز سمجھتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","کون یعقوب کی اولاد کو گن سکتا ہے جو گرد کی مانند بےشمار ہے۔ کون اسرائیلیوں کا چوتھا حصہ بھی گن سکتا ہے؟ رب کرے کہ مَیں راست بازوں کی موت مروں، کہ میرا انجام اُن کے انجام جیسا اچھا ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","بلق نے بلعام سے کہا، ”آپ نے میرے ساتھ کیا کِیا ہے؟ مَیں آپ کو اپنے دشمنوں پر لعنت بھیجنے کے لئے لایا اور آپ نے اُنہیں اچھی خاصی برکت دی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","بلعام نے جواب دیا، ”کیا لازم نہیں کہ مَیں وہی کچھ بولوں جو رب نے بتانے کو کہا ہے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","پھر بلق نے اُس سے کہا، ”آئیں، ہم ایک اَور جگہ جائیں جہاں سے آپ اسرائیلی قوم کو دیکھ سکیں گے، گو اُن کی خیمہ گاہ کا صرف کنارہ ہی نظر آئے گا۔ آپ سب کو نہیں دیکھ سکیں گے۔ وہیں سے اُن پر میرے لئے لعنت بھیجیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","یہ کہہ کر وہ اُس کے ساتھ پِسگہ کی چوٹی پر چڑھ کر پہرے داروں کے میدان تک پہنچ گیا۔ وہاں بھی اُس نے سات قربان گاہیں بنا کر ہر ایک پر ایک بَیل اور ایک مینڈھا قربان کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","بلعام نے بلق سے کہا، ”یہاں اپنی قربان گاہ کے پاس کھڑے رہیں۔ مَیں کچھ فاصلے پر جا کر رب سے ملوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","رب بلعام سے ملا۔ اُس نے اُسے بلق کے لئے پیغام دیا اور کہا، ”بلق کے پاس واپس جا اور اُسے یہ پیغام سنا دے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","وہ واپس چلا گیا۔ بلق اب تک اپنے سرداروں کے ساتھ اپنی قربانی کے پاس کھڑا تھا۔ اُس نے اُس سے پوچھا، ”رب نے کیا کہا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","بلعام نے کہا، ”اے بلق، اُٹھو اور سنو۔ اے صفور کے بیٹے، میری بات پر غور کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","اللہ آدمی نہیں جو جھوٹ بولتا ہے۔ وہ انسان نہیں جو کوئی فیصلہ کر کے بعد میں پچھتائے۔ کیا وہ کبھی اپنی بات پر عمل نہیں کرتا؟ کیا وہ کبھی اپنی بات پوری نہیں کرتا؟ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","مجھے برکت دینے کو کہا گیا ہے۔ اُس نے برکت دی ہے اور مَیں یہ برکت روک نہیں سکتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","یعقوب کے گھرانے میں خرابی نظر نہیں آتی، اسرائیل میں دُکھ دکھائی نہیں دیتا۔ رب اُس کا خدا اُس کے ساتھ ہے، اور قوم بادشاہ کی خوشی میں نعرے لگاتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","اللہ اُنہیں مصر سے نکال لایا، اور اُنہیں جنگلی بَیل کی طاقت حاصل ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","یعقوب کے گھرانے کے خلاف جادوگری ناکام ہے، اسرائیل کے خلاف غیب دانی بےفائدہ ہے۔ اب یعقوب کے گھرانے سے کہا جائے گا، ’اللہ نے کیسا کام کیا ہے!‘ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","اسرائیلی قوم شیرنی کی طرح اُٹھتی اور شیرببر کی طرح کھڑی ہو جاتی ہے۔ جب تک وہ اپنا شکار نہ کھا لے وہ آرام نہیں کرتا، جب تک وہ مارے ہوئے لوگوں کا خون نہ پی لے وہ نہیں لیٹتا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","یہ سن کر بلق نے کہا، ”اگر آپ اُن پر لعنت بھیجنے سے انکار کریں، کم از کم اُنہیں برکت تو نہ دیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","بلعام نے جواب دیا، ”کیا مَیں نے آپ کو نہیں بتایا تھا کہ جو کچھ بھی رب کہے گا مَیں وہی کروں گا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","تب بلق نے بلعام سے کہا، ”آئیں، مَیں آپ کو ایک اَور جگہ لے جاؤں۔ شاید اللہ راضی ہو جائے کہ آپ میرے لئے وہاں سے اُن پر لعنت بھیجیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","وہ اُس کے ساتھ فغور پہاڑ پر چڑھ گیا۔ اُس کی چوٹی سے یردن کی وادی کا جنوبی حصہ یشیمون دکھائی دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","بلعام نے اُس سے کہا، ”میرے لئے یہاں سات قربان گاہیں بنا کر سات بَیل اور سات مینڈھے تیار کر رکھیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","بلق نے ایسا ہی کیا۔ اُس نے ہر ایک قربان گاہ پر ایک بَیل اور ایک مینڈھا قربان کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","اب بلعام کو اِس بات کا پورا یقین ہو گیا کہ رب کو پسند ہے کہ مَیں اسرائیلیوں کو برکت دوں۔ اِس لئے اُس نے اِس مرتبہ پہلے کی طرح جادوگری کا طریقہ استعمال نہ کیا بلکہ سیدھا ریگستان کی طرف رُخ کیا ");
INSERT INTO urdgvu_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","جہاں اسرائیل اپنے اپنے قبیلوں کی ترتیب سے خیمہ زن تھا۔ یہ دیکھ کر اللہ کا روح اُس پر نازل ہوا، ");
INSERT INTO urdgvu_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","اور وہ بول اُٹھا، ”بلعام بن بعور کا پیغام سنو، اُس کے پیغام پر غور کرو جو صاف صاف دیکھتا ہے، ");
INSERT INTO urdgvu_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","اُس کا پیغام جو اللہ کی باتیں سن لیتا ہے، قادرِ مطلق کی رویا کو دیکھ لیتا ہے اور زمین پر گر کر پوشیدہ باتیں دیکھتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","اے یعقوب، تیرے خیمے کتنے شاندار ہیں! اے اسرائیل، تیرے گھر کتنے اچھے ہیں! ");
INSERT INTO urdgvu_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","وہ دُور تک پھیلی ہوئی وادیوں کی مانند، نہر کے کنارے لگے باغوں کی مانند، رب کے لگائے ہوئے عود کے درختوں کی مانند، پانی کے کنارے لگے دیودار کے درختوں کی مانند ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","اُن کی بالٹیوں سے پانی چھلکتا رہے گا، اُن کے بیج کو کثرت کا پانی ملے گا۔ اُن کا بادشاہ اجاج سے زیادہ طاقت ور ہو گا، اور اُن کی سلطنت سرفراز ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","اللہ اُنہیں مصر سے نکال لایا، اور اُنہیں جنگلی بَیل کی سی طاقت حاصل ہے۔ وہ مخالف قوموں کو ہڑپ کر کے اُن کی ہڈیاں چُور چُور کر دیتے ہیں، وہ اپنے تیر چلا کر اُنہیں مار ڈالتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","اسرائیل شیرببر یا شیرنی کی مانند ہے۔ جب وہ دبک کر بیٹھ جائے تو کوئی بھی اُسے چھیڑنے کی جرأت نہیں کرتا۔ جو تجھے برکت دے اُسے برکت ملے، اور جو تجھ پر لعنت بھیجے اُس پر لعنت آئے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","یہ سن کر بلق آپے سے باہر ہوا۔ اُس نے تالی بجا کر اپنی حقارت کا اظہار کیا اور کہا، ”مَیں نے تجھے اِس لئے بُلایا تھا کہ تُو میرے دشمنوں پر لعنت بھیجے۔ اب تُو نے اُنہیں تینوں بار برکت ہی دی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","اب دفع ہو جا! اپنے گھر واپس بھاگ جا! مَیں نے کہا تھا کہ بڑا انعام دوں گا۔ لیکن رب نے تجھے انعام پانے سے روک دیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","بلعام نے جواب دیا، ”کیا مَیں نے اُن لوگوں کو جنہیں آپ نے مجھے بُلانے کے لئے بھیجا تھا نہیں بتایا تھا ");
INSERT INTO urdgvu_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","کہ اگر بلق اپنے محل کو چاندی اور سونے سے بھر کر بھی مجھے دے دے توبھی مَیں رب کی کسی بات کی خلاف ورزی نہیں کر سکتا، خواہ میری نیت اچھی ہو یا بُری۔ مَیں صرف وہ کچھ کر سکتا ہوں جو اللہ فرماتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","اب مَیں اپنے وطن واپس چلا جاتا ہوں۔ لیکن پہلے مَیں آپ کو بتا دیتا ہوں کہ آخرکار یہ قوم آپ کی قوم کے ساتھ کیا کچھ کرے گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","وہ بول اُٹھا، ”بلعام بن بعور کا پیغام سنو، اُس کا پیغام جو صاف صاف دیکھتا ہے، ");
INSERT INTO urdgvu_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","اُس کا پیغام جو اللہ کی باتیں سن لیتا اور اللہ تعالیٰ کی مرضی کو جانتا ہے، جو قادرِ مطلق کی رویا کو دیکھ لیتا اور زمین پر گر کر پوشیدہ باتیں دیکھتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","جسے مَیں دیکھ رہا ہوں وہ اِس وقت نہیں ہے۔ جو مجھے نظر آ رہا ہے وہ قریب نہیں ہے۔ یعقوب کے گھرانے سے ستارہ نکلے گا، اور اسرائیل سے عصائے شاہی اُٹھے گا جو موآب کے ماتھوں اور سیت کے تمام بیٹوں کی کھوپڑیوں کو پاش پاش کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ادوم اُس کے قبضے میں آئے گا، اُس کا دشمن سعیر اُس کی ملکیت بنے گا جبکہ اسرائیل کی طاقت بڑھتی جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","یعقوب کے گھرانے سے ایک حکمران نکلے گا جو شہر کے بچے ہوؤں کو ہلاک کر دے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","پھر بلعام نے عمالیق کو دیکھا اور کہا، ”عمالیق قوموں میں اوّل تھا، لیکن آخرکار وہ ختم ہو جائے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","پھر اُس نے قینیوں کو دیکھا اور کہا، ”تیری سکونت گاہ مستحکم ہے، تیرا چٹان میں بنا گھونسلا مضبوط ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","لیکن تُو تباہ ہو جائے گا جب اسور تجھے گرفتار کرے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","ایک اَور دفعہ اُس نے بات کی، ”ہائے، کون زندہ رہ سکتا ہے جب اللہ یوں کرے گا؟ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","کِتّیم کے ساحل سے بحری جہاز آئیں گے جو اسور اور عِبر کو ذلیل کریں گے، لیکن وہ خود بھی ہلاک ہو جائیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","پھر بلعام اُٹھ کر اپنے گھر واپس چلا گیا۔ بلق بھی وہاں سے چلا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","جب اسرائیلی شِطّیم میں رہ رہے تھے تو اسرائیلی مرد موآبی عورتوں سے زناکاری کرنے لگے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","یہ ایسا ہوا کہ موآبی عورتیں اپنے دیوتاؤں کو قربانیاں پیش کرتے وقت اسرائیلیوں کو شریک ہونے کی دعوت دینے لگیں۔ اسرائیلی دعوت قبول کر کے قربانیوں سے کھانے اور دیوتاؤں کو سجدہ کرنے لگے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","اِس طریقے سے اسرائیلی موآبی دیوتا بنام بعل فغور کی پوجا کرنے لگے، اور رب کا غضب اُن پر آن پڑا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","اُس نے موسیٰ سے کہا، ”اِس قوم کے تمام راہنماؤں کو سزائے موت دے کر سورج کی روشنی میں رب کے سامنے لٹکا، ورنہ رب کا اسرائیلیوں پر سے غضب نہیں ٹلے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","چنانچہ موسیٰ نے اسرائیل کے قاضیوں سے کہا، ”لازم ہے کہ تم میں سے ہر ایک اپنے اُن آدمیوں کو جان سے مار دے جو بعل فغور دیوتا کی پوجا میں شریک ہوئے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","موسیٰ اور اسرائیل کی پوری جماعت ملاقات کے خیمے کے دروازے پر جمع ہو کر رونے لگے۔ اتفاق سے اُسی وقت ایک آدمی وہاں سے گزرا جو ایک مِدیانی عورت کو اپنے گھر لے جا رہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","یہ دیکھ کر ہارون کا پوتا فینحاس بن اِلی عزر جماعت سے نکلا اور نیزہ پکڑ کر ");
INSERT INTO urdgvu_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","اُس اسرائیلی کے پیچھے چل پڑا۔ وہ عورت سمیت اپنے خیمے میں داخل ہوا تو فینحاس نے اُن کے پیچھے پیچھے جا کر نیزہ اِتنے زور سے مارا کہ وہ دونوں میں سے گزر گیا۔ اُس وقت وبا پھیلنے لگی تھی، لیکن فینحاس کے اِس عمل سے وہ رُک گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","توبھی 24,000 افراد مر چکے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","”ہارون کے پوتے فینحاس بن اِلی عزر نے اسرائیلیوں پر میرا غصہ ٹھنڈا کر دیا ہے۔ میری غیرت اپنا کر وہ اسرائیل میں دیگر معبودوں کی پوجا کو برداشت نہ کر سکا۔ اِس لئے میری غیرت نے اسرائیلیوں کو نیست و نابود نہیں کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","لہٰذا اُسے بتا دینا کہ مَیں اُس کے ساتھ سلامتی کا عہد قائم کرتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","اِس عہد کے تحت اُسے اور اُس کی اولاد کو ابد تک امام کا عُہدہ حاصل رہے گا، کیونکہ اپنے خدا کی خاطر غیرت کھا کر اُس نے اسرائیلیوں کا کفارہ دیا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","جس آدمی کو مِدیانی عورت کے ساتھ مار دیا گیا اُس کا نام زِمری بن سلو تھا، اور وہ شمعون کے قبیلے کے ایک آبائی گھرانے کا سرپرست تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","مِدیانی عورت کا نام کزبی تھا، اور وہ صور کی بیٹی تھی جو مِدیانیوں کے ایک آبائی گھرانے کا سرپرست تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","”مِدیانیوں کو دشمن قرار دے کر اُنہیں مار ڈالنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","کیونکہ اُنہوں نے اپنی چالاکیوں سے تمہارے ساتھ دشمن کا سا سلوک کیا، اُنہوں نے تمہیں بعل فغور کی پوجا کرنے پر اُکسایا اور تمہیں اپنی بہن مِدیانی سردار کی بیٹی کزبی کے ذریعے جسے وبا پھیلتے وقت مار دیا گیا بہکایا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","وبا کے بعد رب نے موسیٰ اور ہارون کے بیٹے اِلی عزر سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","”پوری اسرائیلی جماعت کی مردم شماری اُن کے آبائی گھرانوں کے مطابق کرنا۔ اُن تمام مردوں کو گننا جو 20 سال یا اِس سے زائد کے ہیں اور جو جنگ لڑنے کے قابل ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_3‏","005_26_3‏","NUM","26","3‏","4","موسیٰ اور اِلی عزر نے اسرائیلیوں کو بتایا کہ رب نے اُنہیں کیا حکم دیا ہے۔ چنانچہ اُنہوں نے موآب کے میدانی علاقے میں یریحو کے سامنے، لیکن دریائے یردن کے مشرقی کنارے پر مردم شماری کی۔ یہ وہ اسرائیلی آدمی تھے جو مصر سے نکلے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_5‏","005_26_5‏","NUM","26","5‏","7","اسرائیل کے پہلوٹھے روبن کے قبیلے کے 43,730 مرد تھے۔ قبیلے کے چار کنبے حنوکی، فلُّوِی، حصرونی اور کرمی روبن کے بیٹوں حنوک، فلّو، حصرون اور کرمی سے نکلے ہوئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","روبن کا بیٹا فلّو اِلیاب کا باپ تھا ");
INSERT INTO urdgvu_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","جس کے بیٹے نموایل، داتن اور ابیرام تھے۔ داتن اور ابیرام وہی لوگ تھے جنہیں جماعت نے چنا تھا اور جنہوں نے قورح کے گروہ سمیت موسیٰ اور ہارون سے جھگڑتے ہوئے خود رب سے جھگڑا کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","اُس وقت زمین نے اپنا منہ کھول کر اُنہیں قورح سمیت ہڑپ کر لیا تھا۔ اُس کے 250 ساتھی بھی مر گئے تھے جب آگ نے اُنہیں بھسم کر دیا۔ یوں وہ سب اسرائیل کے لئے عبرت انگیز مثال بن گئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","لیکن قورح کی پوری نسل مٹائی نہیں گئی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_12‏","005_26_12‏","NUM","26","12‏","14","شمعون کے قبیلے کے 22,200 مرد تھے۔ قبیلے کے پانچ کنبے نموایلی، یمینی، یکینی، زارحی اور ساؤلی شمعون کے بیٹوں نموایل، یمین، یکین، زارح اور ساؤل سے نکلے ہوئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_15‏","005_26_15‏","NUM","26","15‏","18","جد کے قبیلے کے 40,500 مرد تھے۔ قبیلے کے سات کنبے صفونی، حجی، سُونی، اُزنی، عیری، ارودی اور اریلی جد کے بیٹوں صفون، حجی، سُونی، اُزنی، عیری، ارود اور اریلی سے نکلے ہوئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_19‏","005_26_19‏","NUM","26","19‏","22","یہوداہ کے قبیلے کے 76,500 مرد تھے۔ یہوداہ کے دو بیٹے عیر اور اونان مصر آنے سے پہلے کنعان میں مر گئے تھے۔ قبیلے کے تین کنبے سیلانی، فارصی اور زارحی یہوداہ کے بیٹوں سیلہ، فارص اور زارح سے نکلے ہوئے تھے۔ فارص کے دو بیٹوں حصرون اور حمول سے دو کنبے حصرونی اور حمولی نکلے ہوئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_23‏","005_26_23‏","NUM","26","23‏","25","اِشکار کے قبیلے کے 64,300 مرد تھے۔ قبیلے کے چار کنبے تولعی، فُوّی، یسوبی اور سِمرونی اِشکار کے بیٹوں تولع، فُوّہ، یسوب اور سِمرون سے نکلے ہوئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_26‏","005_26_26‏","NUM","26","26‏","27","زبولون کے قبیلے کے 60,500 مرد تھے۔ قبیلے کے تین کنبے سردی، ایلونی اور یہلی ایلی زبولون کے بیٹوں سرد، ایلون اور یحلئیل سے نکلے ہوئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","یوسف کے دو بیٹوں منسّی اور افرائیم کے الگ الگ قبیلے بنے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_29‏","005_26_29‏","NUM","26","29‏","34","منسّی کے قبیلے کے 52,700 مرد تھے۔ قبیلے کے آٹھ کنبے مکیری، جِلعادی، اِیعزری، خلقی، اسری ایلی، سِکمی، سمیدعی اور حِفری تھے۔ مکیری منسّی کے بیٹے مکیر سے جبکہ جِلعادی مکیر کے بیٹے جِلعاد سے نکلے ہوئے تھے۔ باقی کنبے جِلعاد کے چھ بیٹوں اِیعزر، خلق، اسری ایل، سِکم، سمیدع اور حِفر سے نکلے ہوئے تھے۔ حِفر صِلافِحاد کا باپ تھا۔ صِلافِحاد کا کوئی بیٹا نہیں بلکہ پانچ بیٹیاں محلاہ، نوعاہ، حُجلاہ، مِلکاہ اور تِرضہ تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_35‏","005_26_35‏","NUM","26","35‏","37","افرائیم کے قبیلے کے 32,500 مرد تھے۔ قبیلے کے چار کنبے سوتلحی، بکری، تحنی اور عیرانی تھے۔ پہلے تین کنبے افرائیم کے بیٹوں سوتلح، بکر اور تحن سے جبکہ عیرانی سوتلح کے بیٹے عیران سے نکلے ہوئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_38‏","005_26_38‏","NUM","26","38‏","41","بن یمین کے قبیلے کے 45,600 مرد تھے۔ قبیلے کے سات کنبے بالعی، اشبیلی، اخیرامی، سوفامی، حوفامی، اردی اور نعمانی تھے۔ پہلے پانچ کنبے بن یمین کے بیٹوں بالع، اشبیل، اخیرام، سُوفام اور حوفام سے جبکہ اردی اور نعمانی بالع کے بیٹوں سے نکلے ہوئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_42‏","005_26_42‏","NUM","26","42‏","43","دان کے قبیلے کے 64,400 مرد تھے۔ سب دان کے بیٹے سُوحام سے نکلے ہوئے تھے، اِس لئے سوحامی کہلاتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_44‏","005_26_44‏","NUM","26","44‏","47","آشر کے قبیلے کے 53,400 مرد تھے۔ قبیلے کے پانچ کنبے یِمنی، اِسوی، بریعی، حبری اور ملکی ایلی تھے۔ پہلے تین کنبے آشر کے بیٹوں یِمنہ، اِسوی اور بریعہ سے جبکہ باقی بریعہ کے بیٹوں حِبر اور ملکی ایل سے نکلے ہوئے تھے۔ آشر کی ایک بیٹی بنام سِرح بھی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_48‏","005_26_48‏","NUM","26","48‏","50","نفتالی کے قبیلے کے 45,400 مرد تھے۔ قبیلے کے چار کنبے یحصی ایلی، جونی، یصری اور سِلیمی نفتالی کے بیٹوں یحصی ایل، جونی، یصر اور سِلیم سے نکلے ہوئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","اسرائیلی مردوں کی کُل تعداد 6,01,730 تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","”جب ملکِ کنعان کو تقسیم کیا جائے گا تو زمین اِن کی تعداد کے مطابق دینا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","بڑے قبیلوں کو چھوٹے کی نسبت زیادہ زمین دی جائے۔ ہر قبیلے کا علاقہ اُس کی تعداد سے مطابقت رکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_55‏","005_26_55‏","NUM","26","55‏","56","قرعہ ڈالنے سے فیصلہ کیا جائے کہ ہر قبیلے کو کہاں زمین ملے گی۔ لیکن ہر قبیلے کے علاقے کا رقبہ اِس پر مبنی ہو کہ قبیلے کے کتنے افراد ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","لاوی کے قبیلے کے تین کنبے جَیرسونی، قِہاتی اور مِراری لاوی کے بیٹوں جَیرسون، قِہات اور مِراری سے نکلے ہوئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","اِس کے علاوہ لِبنی، حبرونی، محلی، مُوشی اور قورحی بھی لاوی کے کنبے تھے۔ قِہات عمرام کا باپ تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","عمرام نے لاوی عورت یوکبد سے شادی کی جو مصر میں پیدا ہوئی تھی۔ اُن کے دو بیٹے ہارون اور موسیٰ اور ایک بیٹی مریم پیدا ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","ہارون کے بیٹے ندب، ابیہو، اِلی عزر اور اِتمر تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","لیکن ندب اور ابیہو رب کو بخور کی ناجائز قربانی پیش کرنے کے باعث مر گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","لاویوں کے مردوں کی کُل تعداد 23,000 تھی۔ اِن میں وہ سب شامل تھے جو ایک ماہ یا اِس سے زائد کے تھے۔ اُنہیں دوسرے اسرائیلیوں سے الگ گنا گیا، کیونکہ اُنہیں اسرائیل میں میراث میں زمین نہیں ملنی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","یوں موسیٰ اور اِلی عزر نے موآب کے میدانی علاقے میں یریحو کے سامنے لیکن دریائے یردن کے مشرقی کنارے پر اسرائیلیوں کی مردم شماری کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","لوگوں کو گنتے گنتے اُنہیں معلوم ہوا کہ جو لوگ دشتِ صین میں موسیٰ اور ہارون کی پہلی مردم شماری میں گنے گئے تھے وہ سب مر چکے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","رب نے کہا تھا کہ وہ سب کے سب ریگستان میں مر جائیں گے، اور ایسا ہی ہوا تھا۔ صرف کالب بن یفُنّہ اور یشوع بن نون زندہ رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","صِلافِحاد کی پانچ بیٹیاں محلاہ، نوعاہ، حُجلاہ، مِلکاہ اور تِرضہ تھیں۔ صِلافِحاد یوسف کے بیٹے منسّی کے کنبے کا تھا۔ اُس کا پورا نام صِلافِحاد بن حِفر بن جِلعاد بن مکیر بن منسّی بن یوسف تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","صِلافِحاد کی بیٹیاں ملاقات کے خیمے کے دروازے پر آ کر موسیٰ، اِلی عزر امام اور پوری جماعت کے سامنے کھڑی ہوئیں۔ اُنہوں نے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","”ہمارا باپ ریگستان میں فوت ہوا۔ لیکن وہ قورح کے اُن ساتھیوں میں سے نہیں تھا جو رب کے خلاف متحد ہوئے تھے۔ وہ اِس سبب سے نہ مرا بلکہ اپنے ذاتی گناہ کے باعث۔ جب وہ مر گیا تو اُس کا کوئی بیٹا نہیں تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","کیا یہ ٹھیک ہے کہ ہمارے خاندان میں بیٹا نہ ہونے کے باعث ہمیں زمین نہ ملے اور ہمارے باپ کا نام و نشان مٹ جائے؟ ہمیں بھی ہمارے باپ کے دیگر رشتے داروں کے ساتھ زمین دیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","موسیٰ نے اُن کا معاملہ رب کے سامنے پیش کیا ");
INSERT INTO urdgvu_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","تو رب نے اُس سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","”جو بات صِلافِحاد کی بیٹیاں کر رہی ہیں وہ درست ہے۔ اُنہیں ضرور اُن کے باپ کے رشتے داروں کے ساتھ زمین ملنی چاہئے۔ اُنہیں باپ کا ورثہ مل جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","اسرائیلیوں کو بھی بتانا کہ جب بھی کوئی آدمی مر جائے جس کا بیٹا نہ ہو تو اُس کی بیٹی کو اُس کی میراث مل جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","اگر اُس کی بیٹی بھی نہ ہو تو اُس کے بھائیوں کو اُس کی میراث مل جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","اگر اُس کے بھائی بھی نہ ہوں تو اُس کے باپ کے بھائیوں کو اُس کی میراث مل جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","اگر یہ بھی نہ ہوں تو اُس کے سب سے قریبی رشتے دار کو اُس کی میراث مل جائے۔ وہ اُس کی ذاتی ملکیت ہو گی۔ یہ اصول اسرائیلیوں کے لئے قانونی حیثیت رکھتا ہے۔ وہ اِسے ویسا مانیں جیسا رب نے موسیٰ کو حکم دیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","پھر رب نے موسیٰ سے کہا، ”عباریم کے پہاڑی سلسلے کے اِس پہاڑ پر چڑھ کر اُس ملک پر نگاہ ڈال جو مَیں اسرائیلیوں کو دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","اُسے دیکھنے کے بعد تُو بھی اپنے بھائی ہارون کی طرح کوچ کر کے اپنے باپ دادا سے جا ملے گا، ");
INSERT INTO urdgvu_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","کیونکہ تم دونوں نے دشتِ صین میں میرے حکم کی خلاف ورزی کی۔ اُس وقت جب پوری جماعت نے مریبہ میں میرے خلاف گلہ شکوہ کیا تو تُو نے چٹان سے پانی نکالتے وقت لوگوں کے سامنے میری قدوسیت قائم نہ رکھی۔“ (مریبہ دشتِ صین کے قادس میں چشمہ ہے۔) ");
INSERT INTO urdgvu_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","موسیٰ نے رب سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","”اے رب، تمام جانوں کے خدا، جماعت پر کسی آدمی کو مقرر کر ");
INSERT INTO urdgvu_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","جو اُن کے آگے آگے جنگ کے لئے نکلے اور اُن کے آگے آگے واپس آ جائے، جو اُنہیں باہر لے جائے اور واپس لے آئے۔ ورنہ رب کی جماعت اُن بھیڑوں کی مانند ہو گی جن کا کوئی چرواہا نہ ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","جواب میں رب نے موسیٰ سے کہا، ”یشوع بن نون کو چن لے جس میں میرا روح ہے، اور اپنا ہاتھ اُس پر رکھ۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","اُسے اِلی عزر امام اور پوری جماعت کے سامنے کھڑا کر کے اُن کے رُوبرُو ہی اُسے راہنمائی کی ذمہ داری دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","اپنے اختیار میں سے کچھ اُسے دے تاکہ اسرائیل کی پوری جماعت اُس کی اطاعت کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","رب کی مرضی جاننے کے لئے وہ اِلی عزر امام کے سامنے کھڑا ہو گا تو اِلی عزر رب کے سامنے اُوریم اور تُمیم استعمال کر کے اُس کی مرضی دریافت کرے گا۔ اُسی کے حکم پر یشوع اور اسرائیل کی پوری جماعت خیمہ گاہ سے نکلیں گے اور واپس آئیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","موسیٰ نے ایسا ہی کیا۔ اُس نے یشوع کو چن کر اِلی عزر اور پوری جماعت کے سامنے کھڑا کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","پھر اُس نے اُس پر اپنے ہاتھ رکھ کر اُسے راہنمائی کی ذمہ داری سونپی جس طرح رب نے اُسے بتایا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","”اسرائیلیوں کو بتانا، خیال رکھو کہ تم مقررہ اوقات پر مجھے جلنے والی قربانیاں پیش کرو۔ یہ میری روٹی ہیں اور اِن کی خوشبو مجھے پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","رب کو جلنے والی یہ قربانی پیش کرنا: روزانہ بھیڑ کے دو یکسالہ بچے جو بےعیب ہوں پورے طور پر جلا دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ایک کو صبح کے وقت پیش کرنا اور دوسرے کو سورج کے ڈوبنے کے عین بعد۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","بھیڑ کے بچے کے ساتھ غلہ کی نذر بھی پیش کی جائے یعنی ڈیڑھ کلو گرام بہترین میدہ جو ایک لٹر زیتون کے کوٹ کر نکالے ہوئے تیل کے ساتھ ملایا گیا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","یہ روزمرہ کی قربانی ہے جو پورے طور پر جلائی جاتی ہے اور پہلی دفعہ سینا پہاڑ پر چڑھائی گئی۔ اِس جلنے والی قربانی کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_7‏","005_28_7‏","NUM","28","7‏","8","ساتھ ہی ایک لٹر شراب بھی نذر کے طور پر قربان گاہ پر ڈالی جائے۔ صبح اور شام کی یہ قربانیاں دونوں ہی اِس طریقے سے پیش کی جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","سبت کے دن بھیڑ کے دو اَور بچے چڑھانا۔ وہ بھی بےعیب اور ایک سال کے ہوں۔ ساتھ ہی مَے اور غلہ کی نذریں بھی پیش کی جائیں۔ غلہ کی نذر کے لئے 3 کلو گرام بہترین میدہ تیل کے ساتھ ملایا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","بھسم ہونے والی یہ قربانی ہر ہفتے کے دن پیش کرنی ہے۔ یہ روزمرہ کی قربانیوں کے علاوہ ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","ہر ماہ کے شروع میں رب کو بھسم ہونے والی قربانی کے طور پر دو جوان بَیل، ایک مینڈھا اور بھیڑ کے سات یک سالہ بچے پیش کرنا۔ سب بغیر نقص کے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ہر جانور کے ساتھ غلہ کی نذر پیش کرنا جس کے لئے تیل میں ملایا گیا بہترین میدہ استعمال کیا جائے۔ ہر بَیل کے ساتھ ساڑھے 4 کلو گرام، ہر مینڈھے کے ساتھ 3 کلو گرام ");
INSERT INTO urdgvu_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","اور بھیڑ کے ہر بچے کے ساتھ ڈیڑھ کلو گرام میدہ پیش کرنا۔ بھسم ہونے والی یہ قربانیاں رب کو پسند ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","اِن قربانیوں کے ساتھ مَے کی نذر بھی قربان گاہ پر ڈالنا یعنی ہر بَیل کے ساتھ دو لٹر، ہر مینڈھے کے ساتھ سوا لٹر اور بھیڑ کے ہر بچے کے ساتھ ایک لٹر مَے پیش کرنا۔ یہ قربانی سال میں ہر مہینے کے پہلے دن کے موقع پر پیش کرنی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","اِس قربانی اور روزمرہ کی قربانیوں کے علاوہ رب کو ایک بکرا گناہ کی قربانی کے طور پر پیش کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","پہلے مہینے کے چودھویں دن فسح کی عید منائی جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","اگلے دن پورے ہفتے کی وہ عید شروع ہوتی ہے جس کے دوران تمہیں صرف بےخمیری روٹی کھانی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","پہلے دن کام نہ کرنا بلکہ مُقدّس اجتماع کے لئے اکٹھے ہونا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","رب کے حضور بھسم ہونے والی قربانی کے طور پر دو جوان بَیل، ایک مینڈھا اور بھیڑ کے سات یکسالہ بچے پیش کرنا۔ سب بغیر نقص کے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ہر جانور کے ساتھ غلہ کی نذر بھی پیش کرنا جس کے لئے تیل کے ساتھ ملایا گیا بہترین میدہ استعمال کیا جائے۔ ہر بَیل کے ساتھ ساڑھے 4 کلو گرام، ہر مینڈھے کے ساتھ 3 کلو گرام ");
INSERT INTO urdgvu_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","اور بھیڑ کے ہر بچے کے ساتھ ڈیڑھ کلو گرام میدہ پیش کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","گناہ کی قربانی کے طور پر ایک بکرا بھی پیش کرنا تاکہ تمہارا کفارہ دیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_23‏","005_28_23‏","NUM","28","23‏","24","اِن تمام قربانیوں کو عید کے دوران ہر روز پیش کرنا۔ یہ روزمرہ کی بھسم ہونے والی قربانیوں کے علاوہ ہیں۔ اِس خوراک کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ساتویں دن کام نہ کرنا بلکہ مُقدّس اجتماع کے لئے اکٹھے ہونا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","فصل کی کٹائی کے پہلے دن کی عید پر جب تم رب کو اپنی فصل کی پہلی پیداوار پیش کرتے ہو تو کام نہ کرنا بلکہ مُقدّس اجتماع کے لئے اکٹھے ہونا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_27‏","005_28_27‏","NUM","28","27‏","29","اُس دن دو جوان بَیل، ایک مینڈھا اور بھیڑ کے سات یکسالہ بچے قربان گاہ پر پورے طور پر جلا دینا۔ اِس کے ساتھ غلہ اور مَے کی وہی نذریں پیش کرنا جو فسح کی عید پر بھی پیش کی جاتی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","اِس کے علاوہ رب کو ایک بکرا گناہ کی قربانی کے طور پر چڑھانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","یہ تمام قربانیاں روزمرہ کی بھسم ہونے والی قربانیوں اور اُن کے ساتھ والی غلہ اور مَے کی نذروں کے علاوہ ہیں۔ وہ بےعیب ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","ساتویں ماہ کے پندرھویں دن بھی کام نہ کرنا بلکہ مُقدّس اجتماع کے لئے اکٹھے ہونا۔ اِس دن نرسنگے پھونکے جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","رب کو بھسم ہونے والی قربانی پیش کی جائے جس کی خوشبو اُسے پسند ہو یعنی ایک جوان بَیل، ایک مینڈھا اور بھیڑ کے سات یکسالہ بچے۔ سب نقص کے بغیر ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ہر جانور کے ساتھ غلہ کی نذر بھی پیش کرنا جس کے لئے تیل کے ساتھ ملایا گیا بہترین میدہ استعمال کیا جائے۔ بَیل کے ساتھ ساڑھے 4 کلو گرام، مینڈھے کے ساتھ 3 کلو گرام ");
INSERT INTO urdgvu_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","اور بھیڑ کے ہر بچے کے ساتھ ڈیڑھ کلو گرام میدہ پیش کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ایک بکرا بھی گناہ کی قربانی کے طور پر پیش کرنا تاکہ تمہارا کفارہ دیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","یہ قربانیاں روزانہ اور ہر ماہ کے پہلے دن کی قربانیوں اور اُن کے ساتھ کی غلہ اور مَے کی نذروں کے علاوہ ہیں۔ اِن کی خوشبو رب کو پسند ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","ساتویں مہینے کے دسویں دن مُقدّس اجتماع کے لئے اکٹھے ہونا۔ اِس دن کام نہ کرنا اور اپنی جان کو دُکھ دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_8‏","005_29_8‏","NUM","29","8‏","11","رب کو وہی قربانیاں پیش کرنا جو اِسی مہینے کے پہلے دن پیش کی جاتی ہیں۔ صرف ایک فرق ہے، اِس دن ایک نہیں بلکہ دو بکرے گناہ کی قربانی کے طور پر پیش کئے جائیں تاکہ تمہارا کفارہ دیا جائے۔ ایسی قربانیاں رب کو پسند ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","ساتویں مہینے کے پندرھویں دن بھی کام نہ کرنا بلکہ مُقدّس اجتماع کے لئے اکٹھے ہونا۔ سات دن تک رب کی تعظیم میں عید منانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","عید کے پہلے دن رب کو 13 جوان بَیل، 2 مینڈھے اور 14 بھیڑ کے یکسالہ بچے بھسم ہونے والی قربانی کے طور پر پیش کرنا۔ اِن کی خوشبو اُسے پسند ہے۔ سب نقص کے بغیر ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","ہر جانور کے ساتھ غلہ کی نذر بھی پیش کرنا جس کے لئے تیل سے ملایا گیا بہترین میدہ استعمال کیا جائے۔ ہر بَیل کے ساتھ ساڑھے 4 کلو گرام، ہر مینڈھے کے ساتھ 3 کلو گرام ");
INSERT INTO urdgvu_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","اور بھیڑ کے ہر بچے کے ساتھ ڈیڑھ کلو گرام میدہ پیش کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","اِس کے علاوہ ایک بکرا بھی گناہ کی قربانی کے طور پر پیش کرنا۔ یہ قربانیاں روزانہ کی بھسم ہونے والی قربانیوں اور اُن کے ساتھ والی غلہ اور مَے کی نذروں کے علاوہ ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_17‏","005_29_17‏","NUM","29","17‏","34","عید کے باقی چھ دن یہی قربانیاں پیش کرنی ہیں۔ لیکن ہر دن ایک بَیل کم ہو یعنی دوسرے دن 12، تیسرے دن 11، چوتھے دن 10، پانچویں دن 9، چھٹے دن 8 اور ساتویں دن 7 بَیل۔ ہر دن گناہ کی قربانی کے لئے بکرا اور معمول کی روزانہ کی قربانیاں بھی پیش کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","عید کے آٹھویں دن کام نہ کرنا بلکہ مُقدّس اجتماع کے لئے اکٹھے ہونا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","رب کو ایک جوان بَیل، ایک مینڈھا اور بھیڑ کے سات یکسالہ بچے بھسم ہونے والی قربانی کے طور پر پیش کرنا۔ اِن کی خوشبو رب کو پسند ہے۔ سب نقص کے بغیر ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_37‏","005_29_37‏","NUM","29","37‏","38","ساتھ ہی وہ تمام قربانیاں بھی پیش کرنا جو پہلے دن پیش کی جاتی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","یہ سب وہی قربانیاں ہیں جو تمہیں رب کو اپنی عیدوں پر پیش کرنی ہیں۔ یہ اُن تمام قربانیوں کے علاوہ ہیں جو تم دلی خوشی سے یا مَنت مان کر دیتے ہو، چاہے وہ بھسم ہونے والی، غلہ کی، مَے کی یا سلامتی کی قربانیاں کیوں نہ ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","موسیٰ نے رب کی یہ تمام ہدایات اسرائیلیوں کو بتا دیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","پھر موسیٰ نے قبیلوں کے سرداروں سے کہا، ”رب فرماتا ہے، ");
INSERT INTO urdgvu_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","اگر کوئی آدمی رب کو کچھ دینے کی مَنت مانے یا کسی چیز سے پرہیز کرنے کی قَسم کھائے تو وہ اپنی بات پر قائم رہ کر اُسے پورا کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","اگر کوئی جوان عورت جو اب تک اپنے باپ کے گھر میں رہتی ہے رب کو کچھ دینے کی مَنت مانے یا کسی چیز سے پرہیز کرنے کی قَسم کھائے ");
INSERT INTO urdgvu_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","تو لازم ہے کہ وہ اپنی مَنت یا قَسم کی ہر بات پوری کرے۔ شرط یہ ہے کہ اُس کا باپ اِس کے بارے میں سن کر اعتراض نہ کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","لیکن اگر اُس کا باپ یہ سن کر اُسے ایسا کرنے سے منع کرے تو اُس کی مَنت یا قَسم منسوخ ہے، اور وہ اُسے پورا کرنے سے بَری ہے۔ رب اُسے معاف کرے گا، کیونکہ اُس کے باپ نے اُسے منع کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","ہو سکتا ہے کہ کسی غیرشادی شدہ عورت نے مَنت مانی یا کسی چیز سے پرہیز کرنے کی قَسم کھائی، چاہے اُس نے دانستہ طور پر یا بےسوچے سمجھے ایسا کیا۔ اِس کے بعد اُس عورت نے شادی کر لی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","شادی شدہ حالت میں بھی لازم ہے کہ وہ اپنی مَنت یا قَسم کی ہر بات پوری کرے۔ شرط یہ ہے کہ اُس کا شوہر اِس کے بارے میں سن کر اعتراض نہ کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","لیکن اگر اُس کا شوہر یہ سن کر اُسے ایسا کرنے سے منع کرے تو اُس کی مَنت یا قَسم منسوخ ہے، اور وہ اُسے پورا کرنے سے بَری ہے۔ رب اُسے معاف کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","اگر کسی بیوہ یا طلاق شدہ عورت نے مَنت مانی یا کسی چیز سے پرہیز کرنے کی قَسم کھائی تو لازم ہے کہ وہ اپنی ہر بات پوری کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","اگر کسی شادی شدہ عورت نے مَنت مانی یا کسی چیز سے پرہیز کرنے کی قَسم کھائی ");
INSERT INTO urdgvu_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","تو لازم ہے کہ وہ اپنی ہر بات پوری کرے۔ شرط یہ ہے کہ اُس کا شوہر اِس کے بارے میں سن کر اعتراض نہ کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","لیکن اگر اُس کا شوہر اُسے ایسا کرنے سے منع کرے تو اُس کی مَنت یا قَسم منسوخ ہے۔ وہ اُسے پورا کرنے سے بَری ہے۔ رب اُسے معاف کرے گا، کیونکہ اُس کے شوہر نے اُسے منع کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","چاہے بیوی نے کچھ دینے کی مَنت مانی ہو یا کسی چیز سے پرہیز کرنے کی قَسم کھائی ہو، اُس کے شوہر کو اُس کی تصدیق یا اُسے منسوخ کرنے کا اختیار ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","اگر اُس نے اپنی بیوی کی مَنت یا قَسم کے بارے میں سن لیا اور اگلے دن تک اعتراض نہ کیا تو لازم ہے کہ اُس کی بیوی اپنی ہر بات پوری کرے۔ شوہر نے اگلے دن تک اعتراض نہ کرنے سے اپنی بیوی کی بات کی تصدیق کی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","اگر وہ اِس کے بعد یہ مَنت یا قَسم منسوخ کرے تو اُسے اِس قصور کے نتائج بھگتنے پڑیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","رب نے موسیٰ کو یہ ہدایات دیں۔ یہ ایسی عورتوں کی مَنتوں یا قَسموں کے اصول ہیں جو غیرشادی شدہ حالت میں اپنے باپ کے گھر میں رہتی ہیں یا جو شادی شدہ ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","”مِدیانیوں سے اسرائیلیوں کا بدلہ لے۔ اِس کے بعد تُو کوچ کر کے اپنے باپ دادا سے جا ملے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","چنانچہ موسیٰ نے اسرائیلیوں سے کہا، ”ہتھیاروں سے اپنے کچھ آدمیوں کو لیس کرو تاکہ وہ مِدیان سے جنگ کر کے رب کا بدلہ لیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ہر قبیلے کے 1,000 مرد جنگ لڑنے کے لئے بھیجو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","چنانچہ ہر قبیلے کے 1,000 مسلح مرد یعنی کُل 12,000 آدمی چنے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","تب موسیٰ نے اُنہیں جنگ لڑنے کے لئے بھیج دیا۔ اُس نے اِلی عزر امام کے بیٹے فینحاس کو بھی اُن کے ساتھ بھیجا جس کے پاس مقدِس کی کچھ چیزیں اور اعلان کرنے کے بِگل تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","اُنہوں نے رب کے حکم کے مطابق مِدیانیوں سے جنگ کی اور تمام آدمیوں کو موت کے گھاٹ اُتار دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","اِن میں مِدیانیوں کے پانچ بادشاہ اِوی، رقم، صور، حور اور ربع تھے۔ بلعام بن بعور کو بھی جان سے مار دیا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","اسرائیلیوں نے مِدیانی عورتوں اور بچوں کو گرفتار کر کے اُن کے تمام گائےبَیل، بھیڑبکریاں اور مال لُوٹ لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","اُنہوں نے اُن کی تمام آبادیوں کو خیمہ گاہوں سمیت جلا کر راکھ کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_11‏","005_31_11‏","NUM","31","11‏","12","پھر وہ تمام لُوٹا ہوا مال قیدیوں اور جانوروں سمیت موسیٰ، اِلی عزر امام اور اسرائیل کی پوری جماعت کے پاس لے آئے جو خیمہ گاہ میں انتظار کر رہے تھے۔ ابھی تک وہ موآب کے میدانی علاقے میں دریائے یردن کے مشرقی کنارے پر یریحو کے سامنے ٹھہرے ہوئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","موسیٰ، اِلی عزر اور جماعت کے تمام سردار اُن کا استقبال کرنے کے لئے خیمہ گاہ سے نکلے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","اُنہیں دیکھ کر موسیٰ کو ہزار ہزار اور سَو سَو افراد پر مقرر افسران پر غصہ آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","اُس نے کہا، ”آپ نے تمام عورتوں کو کیوں بچائے رکھا؟ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","اُن ہی نے بلعام کے مشورے پر فغور میں اسرائیلیوں کو رب سے دُور کر دیا تھا۔ اُن ہی کے سبب سے رب کی وبا اُس کے لوگوں میں پھیل گئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","چنانچہ اب تمام لڑکوں کو جان سے مار دو۔ اُن تمام عورتوں کو بھی موت کے گھاٹ اُتارنا جو کنواریاں نہیں ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","لیکن تمام کنواریوں کو بچائے رکھنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","جس نے بھی کسی کو مار دیا یا کسی لاش کو چھوا ہے وہ سات دن تک خیمہ گاہ کے باہر رہے۔ تیسرے اور ساتویں دن اپنے آپ کو اپنے قیدیوں سمیت گناہ سے پاک صاف کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","ہر لباس اور ہر چیز کو پاک صاف کرنا جو چمڑے، بکریوں کے بالوں یا لکڑی کی ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","پھر اِلی عزر امام نے جنگ سے واپس آنے والے مردوں سے کہا، ”جو شریعت رب نے موسیٰ کو دی اُس کے مطابق ");
INSERT INTO urdgvu_vpl VALUES ("NU31_22‏","005_31_22‏","NUM","31","22‏","23","جو بھی چیز جل نہیں جاتی اُسے آگ میں سے گزار دینا تاکہ پاک صاف ہو جائے۔ اِس میں سونا، چاندی، پیتل، لوہا، ٹین اور سیسہ شامل ہے۔ پھر اُس پر ناپاکی دُور کرنے کا پانی چھڑکنا۔ باقی تمام چیزیں پانی میں سے گزار دینا تاکہ وہ پاک صاف ہو جائیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ساتویں دن اپنے لباس کو دھونا تو تم پاک صاف ہو کر خیمہ گاہ میں داخل ہو سکتے ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","”تمام قیدیوں اور لُوٹے ہوئے جانوروں کو گن۔ اِس میں اِلی عزر امام اور قبائلی کنبوں کے سرپرست تیری مدد کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","سارا مال دو برابر کے حصوں میں تقسیم کرنا، ایک حصہ فوجیوں کے لئے اور دوسرا باقی جماعت کے لئے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","فوجیوں کے حصے کے پانچ پانچ سَو قیدیوں میں سے ایک ایک نکال کر رب کو دینا۔ اِسی طرح پانچ پانچ سَو بَیلوں، گدھوں، بھیڑوں اور بکریوں میں سے ایک ایک نکال کر رب کو دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","اُنہیں اِلی عزر امام کو دینا تاکہ وہ اُنہیں رب کو اُٹھانے والی قربانی کے طور پر پیش کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","باقی جماعت کے حصے کے پچاس پچاس قیدیوں میں سے ایک ایک نکال کر رب کو دینا، اِسی طرح پچاس پچاس بَیلوں، گدھوں، بھیڑوں اور بکریوں یا دوسرے جانوروں میں سے بھی ایک ایک نکال کر رب کو دینا۔ اُنہیں اُن لاویوں کو دینا جو رب کے مقدِس کو سنبھالتے ہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","موسیٰ اور اِلی عزر نے ایسا ہی کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_32‏","005_31_32‏","NUM","31","32‏","34","اُنہوں نے 6,75,000 بھیڑبکریاں، 72,000 گائےبَیل اور 61,000 گدھے گنے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","اِن کے علاوہ 32,000 قیدی کنواریاں بھی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_36‏","005_31_36‏","NUM","31","36‏","40","فوجیوں کو تمام چیزوں کا آدھا حصہ مل گیا یعنی 3,37,500 بھیڑبکریاں، 36,000 گائےبَیل، 30,500 گدھے اور 16,000 قیدی کنواریاں۔ اِن میں سے اُنہوں نے 675 بھیڑبکریاں، 72 گائےبَیل، 61 گدھے اور 32 لڑکیاں رب کو دیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","موسیٰ نے رب کا یہ حصہ اِلی عزر امام کو اُٹھانے والی قربانی کے طور پر دے دیا، جس طرح رب نے حکم دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_42‏","005_31_42‏","NUM","31","42‏","47","باقی جماعت کو بھی لُوٹے ہوئے مال کا آدھا حصہ مل گیا۔ موسیٰ نے پچاس پچاس قیدیوں اور جانوروں میں سے ایک ایک نکال کر اُن لاویوں کو دے دیا جو رب کا مقدِس سنبھالتے تھے۔ اُس نے ویسا ہی کیا جیسا رب نے حکم دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","پھر وہ افسر موسیٰ کے پاس آئے جو لشکر کے ہزار ہزار اور سَو سَو آدمیوں پر مقرر تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","اُنہوں نے اُس سے کہا، ”آپ کے خادموں نے اُن فوجیوں کو گن لیا ہے جن پر وہ مقرر ہیں، اور ہمیں پتا چل گیا کہ ایک بھی کم نہیں ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","اِس لئے ہم رب کو سونے کا تمام زیور قربان کرنا چاہتے ہیں جو ہمیں فتح پانے پر ملا تھا مثلاً سونے کے بازوبند، کنگن، مُہر لگانے کی انگوٹھیاں، بالیاں اور ہار۔ یہ سب کچھ ہم رب کو پیش کرنا چاہتے ہیں تاکہ رب کے سامنے ہمارا کفارہ ہو جائے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","موسیٰ اور اِلی عزر امام نے سونے کی تمام چیزیں اُن سے لے لیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","جو چیزیں اُنہوں نے افسران کے لُوٹے ہوئے مال میں سے رب کو اُٹھانے والی قربانی کے طور پر پیش کیں اُن کا پورا وزن تقریباً 190 کلو گرام تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","صرف افسران نے ایسا کیا۔ باقی فوجیوں نے اپنا لُوٹ کا مال اپنے لئے رکھ لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","موسیٰ اور اِلی عزر افسران کا یہ سونا ملاقات کے خیمے میں لے آئے تاکہ وہ رب کو اُس کی قوم کی یاد دلاتا رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","روبن اور جد کے قبیلوں کے پاس بہت سے مویشی تھے۔ جب اُنہوں نے دیکھا کہ یعزیر اور جِلعاد کا علاقہ مویشی پالنے کے لئے اچھا ہے ");
INSERT INTO urdgvu_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","تو اُنہوں نے موسیٰ، اِلی عزر امام اور جماعت کے راہنماؤں کے پاس آ کر کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU32_3‏","005_32_3‏","NUM","32","3‏","4","”جس علاقے کو رب نے اسرائیل کی جماعت کے آگے آگے شکست دی ہے وہ مویشی پالنے کے لئے اچھا ہے۔ عطارات، دیبون، یعزیر، نِمرہ، حسبون، اِلی عالی، سبام، نبو اور بعون جو اِس میں شامل ہیں ہمارے کام آئیں گے، کیونکہ آپ کے خادموں کے پاس مویشی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","اگر آپ کی نظرِ کرم ہم پر ہو تو ہمیں یہ علاقہ دیا جائے۔ یہ ہماری ملکیت بن جائے اور ہمیں دریائے یردن کو پار کرنے پر مجبور نہ کیا جائے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","موسیٰ نے جد اور روبن کے افراد سے کہا، ”کیا تم یہاں پیچھے رہ کر اپنے بھائیوں کو چھوڑنا چاہتے ہو جب وہ جنگ لڑنے کے لئے آگے نکلیں گے؟ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","اِس وقت جب اسرائیلی دریائے یردن کو پار کر کے اُس ملک میں داخل ہونے والے ہیں جو رب نے اُنہیں دیا ہے تو تم کیوں اُن کی حوصلہ شکنی کر رہے ہو؟ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","تمہارے باپ دادا نے بھی یہی کچھ کیا جب مَیں نے اُنہیں قادس برنیع سے ملک کے بارے میں معلومات حاصل کرنے کے لئے بھیجا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","اِسکال کی وادی میں پہنچ کر ملک کی تفتیش کرنے کے بعد اُنہوں نے اسرائیلیوں کی حوصلہ شکنی کی تاکہ وہ اُس ملک میں داخل نہ ہوں جو رب نے اُنہیں دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","اُس دن رب نے غصے میں آ کر قَسم کھائی، ");
INSERT INTO urdgvu_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","’اُن آدمیوں میں سے جو مصر سے نکل آئے ہیں کوئی اُس ملک کو نہیں دیکھے گا جس کا وعدہ مَیں نے قَسم کھا کر ابراہیم، اسحاق اور یعقوب سے کیا تھا۔ کیونکہ اُنہوں نے پوری وفاداری سے میری پیروی نہ کی۔ صرف وہ جن کی عمر اِس وقت 20 سال سے کم ہے داخل ہوں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","بزرگوں میں سے صرف کالب بن یفُنّہ قنِزّی اور یشوع بن نون ملک میں داخل ہوں گے، اِس لئے کہ اُنہوں نے پوری وفاداری سے میری پیروی کی۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","اُس وقت رب کا غضب اُن پر آن پڑا، اور اُنہیں 40 سال تک ریگستان میں مارے مارے پھرنا پڑا، جب تک کہ وہ تمام نسل ختم نہ ہو گئی جس نے اُس کے نزدیک غلط کام کیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","اب تم گناہ گاروں کی اولاد اپنے باپ دادا کی جگہ کھڑے ہو کر رب کا اسرائیل پر غصہ مزید بڑھا رہے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","اگر تم اُس کی پیروی سے ہٹو گے تو وہ دوبارہ اِن لوگوں کو ریگستان میں رہنے دے گا، اور تم اِن کی ہلاکت کا باعث بنو گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","اِس کے بعد روبن اور جد کے افراد دوبارہ موسیٰ کے پاس آئے اور کہا، ”ہم یہاں فی الحال اپنے مویشی کے لئے باڑے اور اپنے بال بچوں کے لئے شہر بنانا چاہتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","اِس کے بعد ہم مسلح ہو کر اسرائیلیوں کے آگے آگے چلیں گے اور ہر ایک کو اُس کی اپنی جگہ تک پہنچائیں گے۔ اِتنے میں ہمارے بال بچے ہمارے شہروں کی فصیلوں کے اندر ملک کے مخالف باشندوں سے محفوظ رہیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ہم اُس وقت تک اپنے گھروں کو نہیں لوٹیں گے جب تک ہر اسرائیلی کو اُس کی موروثی زمین نہ مل جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","دوسرے، ہم خود اُن کے ساتھ دریائے یردن کے مغرب میں میراث میں کچھ نہیں پائیں گے، کیونکہ ہمیں اپنی موروثی زمین دریائے یردن کے مشرقی کنارے پر مل چکی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","یہ سن کر موسیٰ نے کہا، ”اگر تم ایسا ہی کرو گے تو ٹھیک ہے۔ پھر رب کے سامنے جنگ کے لئے تیار ہو جاؤ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","اور سب ہتھیار باندھ کر رب کے سامنے دریائے یردن کو پار کرو۔ اُس وقت تک نہ لوٹو جب تک رب نے اپنے تمام دشمنوں کو اپنے آگے سے نکال نہ دیا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","پھر جب ملک پر رب کا قبضہ ہو گیا ہو گا تو تم لوٹ سکو گے۔ تب تم نے رب اور اپنے ہم وطن بھائیوں کے لئے اپنے فرائض ادا کر دیئے ہوں گے، اور یہ علاقہ رب کے سامنے تمہارا موروثی حق ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","لیکن اگر تم ایسا نہ کرو تو پھر تم رب ہی کا گناہ کرو گے۔ یقین جانو تمہیں اپنے گناہ کی سزا ملے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","اب اپنے بال بچوں کے لئے شہر اور اپنے مویشیوں کے لئے باڑے بنا لو۔ لیکن اپنے وعدے کو ضرور پورا کرنا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","جد اور روبن کے افراد نے موسیٰ سے کہا، ”ہم آپ کے خادم ہیں، ہم اپنے آقا کے حکم کے مطابق ہی کریں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ہمارے بال بچے اور مویشی یہیں جِلعاد کے شہروں میں رہیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","لیکن آپ کے خادم مسلح ہو کر دریا کو پار کریں گے اور رب کے سامنے جنگ کریں گے۔ ہم سب کچھ ویسا ہی کریں گے جیسا ہمارے آقا نے ہمیں حکم دیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","تب موسیٰ نے اِلی عزر امام، یشوع بن نون اور قبائلی کنبوں کے سرپرستوں کو ہدایت دی، ");
INSERT INTO urdgvu_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","”لازم ہے کہ جد اور روبن کے مرد مسلح ہو کر تمہارے ساتھ ہی رب کے سامنے دریائے یردن کو پار کریں اور ملک پر قبضہ کریں۔ اگر وہ ایسا کریں تو اُنہیں میراث میں جِلعاد کا علاقہ دو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","لیکن اگر وہ ایسا نہ کریں تو پھر اُنہیں ملکِ کنعان ہی میں تمہارے ساتھ موروثی زمین ملے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","جد اور روبن کے افراد نے اصرار کیا، ”آپ کے خادم سب کچھ کریں گے جو رب نے کہا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ہم مسلح ہو کر رب کے سامنے دریائے یردن کو پار کریں گے اور کنعان کے ملک میں داخل ہوں گے، اگرچہ ہماری موروثی زمین یردن کے مشرقی کنارے پر ہو گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","تب موسیٰ نے جد، روبن اور منسّی کے آدھے قبیلے کو یہ علاقہ دیا۔ اُس میں وہ پورا ملک شامل تھا جس پر پہلے اموریوں کا بادشاہ سیحون اور بسن کا بادشاہ عوج حکومت کرتے تھے۔ اِن شکست خوردہ ممالک کے دیہاتوں سمیت تمام شہر اُن کے حوالے کئے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","جد کے قبیلے نے دیبون، عطارات، عروعیر، ");
INSERT INTO urdgvu_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","عطرات شوفان، یعزیر، یگبہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","بیت نِمرہ اور بیت ہاران کے شہروں کو دوبارہ تعمیر کیا۔ اُنہوں نے اُن کی فصیلیں بنائیں اور اپنے مویشیوں کے لئے باڑے بھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","روبن کے قبیلے نے حسبون، اِلی عالی، قِریَتائم، ");
INSERT INTO urdgvu_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","نبو، بعل معون اور سِبماہ دوبارہ تعمیر کئے۔ نبو اور بعل معون کے نام بدل گئے، کیونکہ اُنہوں نے اُن شہروں کو نئے نام دیئے جو اُنہوں نے دوبارہ تعمیر کئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","منسّی کے بیٹے مکیر کی اولاد نے جِلعاد جا کر اُس پر قبضہ کر لیا اور اُس کے تمام اموری باشندوں کو نکال دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","چنانچہ موسیٰ نے مکیریوں کو جِلعاد کی سرزمین دے دی، اور وہ وہاں آباد ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","منسّی کے ایک آدمی بنام یائیر نے اِس علاقے میں کچھ بستیوں پر قبضہ کر کے اُنہیں ’حووت یائیر‘ یعنی ’یائیر کی بستیاں‘ کا نام دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","اِسی طرح اُس قبیلے کے ایک اَور آدمی بنام نوبح نے جا کر قنات اور اُس کے دیہاتوں پر قبضہ کر لیا۔ اُس نے شہر کا نام نوبح رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ذیل میں اُن جگہوں کے نام ہیں جہاں جہاں اسرائیلی قبیلے اپنے دستوں کے مطابق موسیٰ اور ہارون کی راہنمائی میں مصر سے نکل کر خیمہ زن ہوئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","رب کے حکم پر موسیٰ نے ہر جگہ کا نام قلم بند کیا جہاں اُنہوں نے اپنے خیمے لگائے تھے۔ اُن جگہوں کے نام یہ ہیں: ");
INSERT INTO urdgvu_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","پہلے مہینے کے پندرھویں دن اسرائیلی رعمسیس سے روانہ ہوئے۔ یعنی فسح کے دن کے بعد کے دن وہ بڑے اختیار کے ساتھ تمام مصریوں کے دیکھتے دیکھتے چلے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","مصری اُس وقت اپنے پہلوٹھوں کو دفن کر رہے تھے، کیونکہ رب نے پہلوٹھوں کو مار کر اُن کے دیوتاؤں کی عدالت کی تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","رعمسیس سے اسرائیلی سُکات پہنچ گئے جہاں اُنہوں نے پہلی مرتبہ اپنے ڈیرے لگائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","وہاں سے وہ ایتام پہنچے جو ریگستان کے کنارے پر واقع ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ایتام سے وہ واپس مُڑ کر فی ہخیروت کی طرف بڑھے جو بعل صفون کے مشرق میں ہے۔ وہ مجدال کے قریب خیمہ زن ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","پھر وہ فی ہخیروت سے کوچ کر کے سمندر میں سے گزر گئے۔ اِس کے بعد وہ تین دن ایتام کے ریگستان میں سفر کرتے کرتے مارہ پہنچ گئے اور وہاں اپنے خیمے لگائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","مارہ سے وہ ایلیم چلے گئے جہاں 12 چشمے اور کھجور کے 70 درخت تھے۔ وہاں ٹھہرنے کے بعد ");
INSERT INTO urdgvu_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","وہ بحرِ قُلزم کے ساحل پر خیمہ زن ہوئے، ");
INSERT INTO urdgvu_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","پھر دشتِ صین میں پہنچ گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","اُن کے اگلے مرحلے یہ تھے: دُفقہ، ");
INSERT INTO urdgvu_vpl VALUES ("NU33_13‏","005_33_13‏","NUM","33","13‏","37","الوس، رفیدیم جہاں پینے کا پانی دست یاب نہ تھا، دشتِ سینا، قبروت ہتاوہ، حصیرات، رِتمہ، رِمّون فارص، لِبناہ، رِسّہ، قہیلاتہ، سافر پہاڑ، حرادہ، مقہیلوت، تحت، تارح، مِتقَہ، حشمونہ، موسیروت، بنی یعقان، حور ہَجِدجاد، یُطباتہ، عبرونہ، عصیون جابر، دشتِ صین میں واقع قادس اور ہور پہاڑ جو ادوم کی سرحد پر واقع ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","وہاں رب نے ہارون امام کو حکم دیا کہ وہ ہور پہاڑ پر چڑھ جائے۔ وہیں وہ پانچویں ماہ کے پہلے دن فوت ہوا۔ اسرائیلیوں کو مصر سے نکلے 40 سال گزر چکے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","اُس وقت ہارون 123 سال کا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","اُن دنوں میں عراد کے کنعانی بادشاہ نے سنا کہ اسرائیلی میرے ملک کی طرف بڑھ رہے ہیں۔ وہ کنعان کے جنوب میں حکومت کرتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_41‏","005_33_41‏","NUM","33","41‏","47","ہور پہاڑ سے روانہ ہو کر اسرائیلی ذیل کی جگہوں پر ٹھہرے: ضلمونہ، فُونون، اوبوت، عیّے عباریم جو موآب کے علاقے میں تھا، دیبون جد، علمون دِبلاتائم اور نبو کے قریب واقع عباریم کا پہاڑی علاقہ۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","وہاں سے اُنہوں نے یردن کی وادی میں اُتر کر موآب کے میدانی علاقے میں اپنے ڈیرے لگائے۔ اب وہ دریائے یردن کے مشرقی کنارے پر یریحو شہر کے سامنے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","اُن کے خیمے بیت یسیموت سے لے کر ابیل شِطّیم تک لگے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","وہاں رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","”اسرائیلیوں کو بتانا کہ جب تم دریائے یردن کو پار کر کے ملکِ کنعان میں داخل ہو گے ");
INSERT INTO urdgvu_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","تو لازم ہے کہ تم تمام باشندوں کو نکال دو۔ اُن کے تراشے اور ڈھالے ہوئے بُتوں کو توڑ ڈالو اور اُن کی اونچی جگہوں کے مندروں کو تباہ کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ملک پر قبضہ کر کے اُس میں آباد ہو جاؤ، کیونکہ مَیں نے یہ ملک تمہیں دے دیا ہے۔ یہ میری طرف سے تمہاری موروثی ملکیت ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","ملک کو مختلف قبیلوں اور خاندانوں میں قرعہ ڈال کر تقسیم کرنا۔ ہر خاندان کے افراد کی تعداد کا لحاظ رکھنا۔ بڑے خاندان کو نسبتاً زیادہ زمین دینا اور چھوٹے خاندان کو نسبتاً کم زمین۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","لیکن اگر تم ملک کے باشندوں کو نہیں نکالو گے تو بچے ہوئے تمہاری آنکھوں میں خار اور تمہارے پہلوؤں میں کانٹے بن کر تمہیں اُس ملک میں تنگ کریں گے جس میں تم آباد ہو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","پھر مَیں تمہارے ساتھ وہ کچھ کروں گا جو اُن کے ساتھ کرنا چاہتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","”اسرائیلیوں کو بتانا کہ جب تم اُس ملک میں داخل ہو گے جو مَیں تمہیں میراث میں دوں گا تو اُس کی سرحدیں یہ ہوں گی: ");
INSERT INTO urdgvu_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","اُس کی جنوبی سرحد دشتِ صین میں ادوم کی سرحد کے ساتھ ساتھ چلے گی۔ مشرق میں وہ بحیرۂ مُردار کے جنوبی ساحل سے شروع ہو گی، پھر اِن جگہوں سے ہو کر مغرب کی طرف گزرے گی: ");
INSERT INTO urdgvu_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","درۂ عقربیم کے جنوب میں سے، دشتِ صین میں سے، قادس برنیع کے جنوب میں سے حصر ادّار اور عضمون میں سے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","وہاں سے وہ مُڑ کر مصر کی سرحد پر واقع وادیٔ مصر کے ساتھ ساتھ بحیرۂ روم تک پہنچے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","اُس کی مغربی سرحد بحیرۂ روم کا ساحل ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","اُس کی شمالی سرحد بحیرۂ روم سے لے کر اِن جگہوں سے ہو کر مشرق کی طرف گزرے گی: ہور پہاڑ، ");
INSERT INTO urdgvu_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","لبو حمات، صداد، ");
INSERT INTO urdgvu_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","زِفرون اور حصر عینان۔ حصر عینان شمالی سرحد کا سب سے مشرقی مقام ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","اُس کی مشرقی سرحد شمال میں حصر عینان سے شروع ہو گی۔ پھر وہ اِن جگہوں سے ہو کر جنوب کی طرف گزرے گی: سِفام، ");
INSERT INTO urdgvu_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","رِبلہ جو عین کے مشرق میں ہے اور کِنّرت یعنی گلیل کی جھیل کے مشرق میں واقع پہاڑی علاقہ۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","اِس کے بعد وہ دریائے یردن کے کنارے کنارے گزرتی ہوئی بحیرۂ مُردار تک پہنچے گی۔ یہ تمہارے ملک کی سرحدیں ہوں گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","موسیٰ نے اسرائیلیوں سے کہا، ”یہ وہی ملک ہے جسے تمہیں قرعہ ڈال کر تقسیم کرنا ہے۔ رب نے حکم دیا ہے کہ اُسے باقی ساڑھے نو قبیلوں کو دینا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","کیونکہ اڑھائی قبیلوں کے خاندانوں کو اُن کی میراث مل چکی ہے یعنی روبن اور جد کے پورے قبیلے اور منسّی کے آدھے قبیلے کو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","اُنہیں یہاں، دریائے یردن کے مشرق میں یریحو کے سامنے زمین مل چکی ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","”اِلی عزر امام اور یشوع بن نون لوگوں کے لئے ملک تقسیم کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","ہر قبیلے کے ایک ایک راہنما کو بھی چننا تاکہ وہ تقسیم کرنے میں مدد کرے۔ جن کو تمہیں چننا ہے اُن کے نام یہ ہیں: ");
INSERT INTO urdgvu_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","یہوداہ کے قبیلے کا کالب بن یفُنّہ، ");
INSERT INTO urdgvu_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","شمعون کے قبیلے کا سموایل بن عمی ہود، ");
INSERT INTO urdgvu_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","بن یمین کے قبیلے کا اِلیداد بن کِسلون، ");
INSERT INTO urdgvu_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","دان کے قبیلے کا بُقی بن یُگلی، ");
INSERT INTO urdgvu_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","منسّی کے قبیلے کا حنی ایل بن افُود، ");
INSERT INTO urdgvu_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","افرائیم کے قبیلے کا قموایل بن سِفتان، ");
INSERT INTO urdgvu_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","زبولون کے قبیلے کا اِلی صفن بن فرناک، ");
INSERT INTO urdgvu_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","اِشکار کے قبیلے کا فلطی ایل بن عزان، ");
INSERT INTO urdgvu_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","آشر کے قبیلے کا اخی ہود بن شلومی، ");
INSERT INTO urdgvu_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","نفتالی کے قبیلے کا فداہیل بن عمی ہود۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","رب نے اِن ہی آدمیوں کو ملک کو اسرائیلیوں میں تقسیم کرنے کی ذمہ داری دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","اسرائیلی اب تک موآب کے میدانی علاقے میں دریائے یردن کے مشرقی کنارے پر یریحو کے سامنے تھے۔ وہاں رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","”اسرائیلیوں کو بتا دے کہ وہ لاویوں کو اپنی ملی ہوئی زمینوں میں سے رہنے کے لئے شہر دیں۔ اُنہیں شہروں کے ارد گرد مویشی چَرانے کی زمین بھی ملے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","پھر لاویوں کے پاس رہنے کے لئے شہر اور اپنے جانور چَرانے کے لئے زمین ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","چَرانے کے لئے زمین شہر کے ارد گرد ہو گی، اور چاروں طرف کا فاصلہ فصیلوں سے 1,500 فٹ ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","چَرانے کی یہ زمین مربع شکل کی ہو گی جس کے ہر پہلو کا فاصلہ 3,000 فٹ ہو۔ شہر اِس مربع شکل کے بیچ میں ہو۔ یہ رقبہ شہر کے باشندوں کے لئے ہو تاکہ وہ اپنے مویشی چَرا سکیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_6‏","005_35_6‏","NUM","35","6‏","7","لاویوں کو کُل 48 شہر دینا۔ اِن میں سے چھ پناہ کے شہر مقرر کرنا۔ اُن میں ایسے لوگ پناہ لے سکیں گے جن کے ہاتھوں غیرارادی طور پر کوئی ہلاک ہوا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","ہر قبیلہ لاویوں کو اپنے علاقے کے رقبے کے مطابق شہر دے۔ جس قبیلے کا علاقہ بڑا ہے اُسے لاویوں کو زیادہ شہر دینے ہیں جبکہ جس قبیلے کا علاقہ چھوٹا ہے وہ لاویوں کو کم شہر دے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","پھر رب نے موسیٰ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","”اسرائیلیوں کو بتانا کہ دریائے یردن کو پار کرنے کے بعد ");
INSERT INTO urdgvu_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","کچھ پناہ کے شہر مقرر کرنا۔ اُن میں وہ شخص پناہ لے سکے گا جس کے ہاتھوں غیرارادی طور پر کوئی ہلاک ہوا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","وہاں وہ انتقام لینے والے سے پناہ لے سکے گا اور جماعت کی عدالت کے سامنے کھڑے ہونے سے پہلے مارا نہیں جا سکے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","اِس کے لئے چھ شہر چن لو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","تین دریائے یردن کے مشرق میں اور تین ملکِ کنعان میں ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","یہ چھ شہر ہر کسی کو پناہ دیں گے، چاہے وہ اسرائیلی، پردیسی یا اُن کے درمیان رہنے والا غیرشہری ہو۔ جس سے بھی غیرارادی طور پر کوئی ہلاک ہوا ہو وہ وہاں پناہ لے سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_16‏","005_35_16‏","NUM","35","16‏","18","اگر کسی نے کسی کو جان بوجھ کر لوہے، پتھر یا لکڑی کی کسی چیز سے مار ڈالا ہو وہ قاتل ہے اور اُسے سزائے موت دینی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","مقتول کا سب سے قریبی رشتے دار اُسے تلاش کر کے مار دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_20‏","005_35_20‏","NUM","35","20‏","21","کیونکہ جو نفرت یا دشمنی کے باعث جان بوجھ کر کسی کو یوں دھکا دے، اُس پر کوئی چیزپھینک دے یا اُسے مُکا مارے کہ وہ مر جائے وہ قاتل ہے اور اُسے سزائے موت دینی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","لیکن وہ قاتل نہیں ہے جس سے دشمنی کے باعث نہیں بلکہ اتفاق سے اور غیرارادی طور پر کوئی ہلاک ہوا ہو، چاہے اُس نے اُسے دھکا دیا، کوئی چیز اُس پر پھینک دی ");
INSERT INTO urdgvu_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","یا کوئی پتھر اُس پر گرنے دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","اگر ایسا ہوا تو لازم ہے کہ جماعت اِن ہدایات کے مطابق اُس کے اور انتقام لینے والے کے درمیان فیصلہ کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","اگر ملزم بےقصور ہے تو جماعت اُس کی حفاظت کر کے اُسے پناہ کے اُس شہر میں واپس لے جائے جس میں اُس نے پناہ لی ہے۔ وہاں وہ مُقدّس تیل سے مسح کئے گئے امامِ اعظم کی موت تک رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","لیکن اگر یہ شخص اِس سے پہلے پناہ کے شہر سے نکلے تو وہ محفوظ نہیں ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","اگر اُس کا انتقام لینے والے سے سامنا ہو جائے تو انتقام لینے والے کو اُسے مار ڈالنے کی اجازت ہو گی۔ اگر وہ ایسا کرے تو بےقصور رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","پناہ لینے والا امامِ اعظم کی وفات تک پناہ کے شہر میں رہے۔ اِس کے بعد ہی وہ اپنے گھر واپس جا سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","یہ اصول دائمی ہیں۔ جہاں بھی تم رہتے ہو تمہیں ہمیشہ اِن پر عمل کرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","جس پر قتل کا الزام لگایا گیا ہو اُسے صرف اِس صورت میں سزائے موت دی جا سکتی ہے کہ کم از کم دو گواہ ہوں۔ ایک گواہ کافی نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","قاتل کو ضرور سزائے موت دینا۔ خواہ وہ اِس سے بچنے کے لئے کوئی بھی معاوضہ دے اُسے آزاد نہ چھوڑنا بلکہ سزائے موت دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","اُس شخص سے بھی پیسے قبول نہ کرنا جس سے غیرارادی طور پر کوئی ہلاک ہوا ہو اور جو اِس سبب سے پناہ کے شہر میں رہ رہا ہے۔ اُسے اجازت نہیں کہ وہ پیسے دے کر پناہ کا شہر چھوڑے اور اپنے گھر واپس چلا جائے۔ لازم ہے کہ وہ اِس کے لئے امامِ اعظم کی وفات کا انتظار کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","جس ملک میں تم رہتے ہو اُس کی مُقدّس حالت کو ناپاک نہ کرنا۔ جب کسی کو اُس میں قتل کیا جائے تو وہ ناپاک ہو جاتا ہے۔ جب اِس طرح خون بہتا ہے تو ملک کی مُقدّس حالت صرف اُس شخص کے خون بہنے سے بحال ہو جاتی ہے جس نے یہ خون بہایا ہے۔ یعنی ملک کا صرف قاتل کی موت سے ہی کفارہ دیا جا سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","اُس ملک کو ناپاک نہ کرنا جس میں تم آباد ہو اور جس میں مَیں سکونت کرتا ہوں۔ کیونکہ مَیں رب ہوں جو اسرائیلیوں کے درمیان سکونت کرتا ہوں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","ایک دن جِلعاد بن مکیر بن منسّی بن یوسف کے کنبے سے نکلے ہوئے آبائی گھرانوں کے سرپرست موسیٰ اور اُن سرداروں کے پاس آئے جو دیگر آبائی گھرانوں کے سرپرست تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","اُنہوں نے کہا، ”رب نے آپ کو حکم دیا تھا کہ آپ قرعہ ڈال کر ملک کو اسرائیلیوں میں تقسیم کریں۔ اُس وقت اُس نے یہ بھی کہا تھا کہ ہمارے بھائی صِلافِحاد کی بیٹیوں کو اُس کی موروثی زمین ملنی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","اگر وہ اسرائیل کے کسی اَور قبیلے کے مردوں سے شادی کریں تو پھر یہ زمین جو ہمارے قبیلے کا موروثی حصہ ہے اُس قبیلے کا موروثی حصہ بنے گی اور ہم اُس سے محروم ہو جائیں گے۔ پھر ہمارا قبائلی علاقہ چھوٹا ہو جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","اور اگر ہم یہ زمین واپس بھی خریدیں توبھی وہ اگلے بحالی کے سال میں دوسرے قبیلے کو واپس چلی جائے گی جس میں اِن عورتوں نے شادی کی ہے۔ اِس طرح وہ ہمیشہ کے لئے ہمارے ہاتھ سے نکل جائے گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","موسیٰ نے رب کے حکم پر اسرائیلیوں کو بتایا، ”جِلعاد کے مرد حق بجانب ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","اِس لئے رب کی ہدایت یہ ہے کہ صِلافِحاد کی بیٹیوں کو ہر آدمی سے شادی کرنے کی اجازت ہے، لیکن صرف اِس صورت میں کہ وہ اُن کے اپنے قبیلے کا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","اِس طرح ایک قبیلے کی موروثی زمین کسی دوسرے قبیلے میں منتقل نہیں ہو گی۔ لازم ہے کہ ہر قبیلے کا پورا علاقہ اُسی کے پاس رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","جو بھی بیٹی میراث میں زمین پاتی ہے اُس کے لئے لازم ہے کہ وہ اپنے ہی قبیلے کے کسی مرد سے شادی کرے تاکہ اُس کی زمین قبیلے کے پاس ہی رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","ایک قبیلے کی موروثی زمین کسی دوسرے قبیلے کو منتقل کرنے کی اجازت نہیں ہے۔ لازم ہے کہ ہر قبیلے کا پورا موروثی علاقہ اُسی کے پاس رہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("NU36_10‏","005_36_10‏","NUM","36","10‏","11","صِلافِحاد کی بیٹیوں محلاہ، تِرضہ، حُجلاہ، مِلکاہ اور نوعاہ نے ویسا ہی کیا جیسا رب نے موسیٰ کو بتایا تھا۔ اُنہوں نے اپنے چچا زاد بھائیوں سے شادی کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","چونکہ وہ بھی منسّی کے قبیلے کے تھے اِس لئے یہ موروثی زمین صِلافِحاد کے قبیلے کے پاس رہی۔ ");
INSERT INTO urdgvu_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","رب نے یہ احکام اور ہدایات اسرائیلیوں کو موسیٰ کی معرفت دیں جب وہ موآب کے میدانی علاقے میں دریائے یردن کے مشرقی کنارے پر یریحو کے سامنے خیمہ زن تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","اِس کتاب میں وہ باتیں درج ہیں جو موسیٰ نے تمام اسرائیلیوں سے کہیں جب وہ دریائے یردن کے مشرقی کنارے پر بیابان میں تھے۔ وہ یردن کی وادی میں سوف کے قریب تھے۔ ایک طرف فاران شہر تھا اور دوسری طرف طوفل، لابن، حصیرات اور دِیزہب کے شہر تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","اگر ادوم کے پہاڑی علاقے سے ہو کر جائیں تو حورب یعنی سینا پہاڑ سے قادس برنیع تک کا سفر 11 دن میں طے کیا جا سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","اسرائیلیوں کو مصر سے نکلے 40 سال ہو گئے تھے۔ اِس سال کے گیارھویں ماہ کے پہلے دن موسیٰ نے اُنہیں سب کچھ بتایا جو رب نے اُسے اُنہیں بتانے کو کہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","اُس وقت وہ اموریوں کے بادشاہ سیحون کو شکست دے چکا تھا جس کا دار الحکومت حسبون تھا۔ بسن کے بادشاہ عوج پر بھی فتح حاصل ہو چکی تھی جس کی حکومت کے مرکز عستارات اور اِدرعی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","وہاں، دریائے یردن کے مشرقی کنارے پر جو موآب کے علاقے میں تھا موسیٰ اللہ کی شریعت کی تشریح کرنے لگا۔ اُس نے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","جب تم حورب یعنی سینا پہاڑ کے پاس تھے تو رب ہمارے خدا نے ہم سے کہا، ”تم کافی دیر سے یہاں ٹھہرے ہوئے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","اب اِس جگہ کو چھوڑ کر آگے ملکِ کنعان کی طرف بڑھو۔ اموریوں کے پہاڑی علاقے اور اُن کے پڑوس کی قوموں کے پاس جاؤ جو یردن کے میدانی علاقے میں آباد ہیں۔ پہاڑی علاقے میں، مغرب کے نشیبی پہاڑی علاقے میں، جنوب کے دشتِ نجب میں، ساحلی علاقے میں، ملکِ کنعان میں اور لبنان میں دریائے فرات تک چلے جاؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","مَیں نے تمہیں یہ ملک دے دیا ہے۔ اب جا کر اُس پر قبضہ کر لو۔ کیونکہ رب نے قَسم کھا کر تمہارے باپ دادا ابراہیم، اسحاق اور یعقوب سے وعدہ کیا تھا کہ مَیں یہ ملک تمہیں اور تمہاری اولاد کو دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","اُس وقت مَیں نے تم سے کہا، ”مَیں اکیلا تمہاری راہنمائی کرنے کی ذمہ داری نہیں اُٹھا سکتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","رب تمہارے خدا نے تمہاری تعداد اِتنی بڑھا دی ہے کہ آج تم آسمان کے ستاروں کی مانند بےشمار ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","اور رب تمہارے باپ دادا کا خدا کرے کہ تمہاری تعداد مزید ہزار گُنا بڑھ جائے۔ وہ تمہیں وہ برکت دے جس کا وعدہ اُس نے کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","لیکن مَیں اکیلا ہی تمہارا بوجھ اُٹھانے اور جھگڑوں کو نپٹانے کی ذمہ داری نہیں اُٹھا سکتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","اِس لئے اپنے ہر قبیلے میں سے کچھ ایسے دانش مند اور سمجھ دار آدمی چن لو جن کی لیاقت کو لوگ مانتے ہیں۔ پھر مَیں اُنہیں تم پر مقرر کروں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","یہ بات تمہیں پسند آئی۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","تم نے اپنے میں سے ایسے راہنما چن لئے جو دانش مند تھے اور جن کی لیاقت کو لوگ مانتے تھے۔ پھر مَیں نے اُنہیں ہزار ہزار، سَو سَو اور پچاس پچاس مردوں پر مقرر کیا۔ یوں وہ قبیلوں کے نگہبان بن گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","اُس وقت مَیں نے اُن قاضیوں سے کہا، ”عدالت کرتے وقت ہر ایک کی بات غور سے سن کر غیرجانب دار فیصلے کرنا، چاہے دو اسرائیلی فریق ایک دوسرے سے جھگڑا کر رہے ہوں یا معاملہ کسی اسرائیلی اور پردیسی کے درمیان ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","عدالت کرتے وقت جانب داری نہ کرنا۔ چھوٹے اور بڑے کی بات سن کر دونوں کے ساتھ ایک جیسا سلوک کرنا۔ کسی سے مت ڈرنا، کیونکہ اللہ ہی نے تمہیں عدالت کرنے کی ذمہ داری دی ہے۔ اگر کسی معاملے میں فیصلہ کرنا تمہارے لئے مشکل ہو تو اُسے مجھے پیش کرو۔ پھر مَیں ہی اُس کا فیصلہ کروں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","اُس وقت مَیں نے تمہیں سب کچھ بتایا جو تمہیں کرنا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","ہم نے ویسا ہی کیا جیسا رب نے ہمیں کہا تھا۔ ہم حورب سے روانہ ہو کر اموریوں کے پہاڑی علاقے کی طرف بڑھے۔ سفر کرتے کرتے ہم اُس وسیع اور ہول ناک ریگستان میں سے گزر گئے جسے تم نے دیکھ لیا ہے۔ آخرکار ہم قادس برنیع پہنچ گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","وہاں مَیں نے تم سے کہا، ”تم اموریوں کے پہاڑی علاقے تک پہنچ گئے ہو جو رب ہمارا خدا ہمیں دینے والا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","دیکھ، رب تیرے خدا نے تجھے یہ ملک دے دیا ہے۔ اب جا کر اُس پر قبضہ کر لے جس طرح رب تیرے باپ دادا کے خدا نے تجھے بتایا ہے۔ مت ڈرنا اور بےدل نہ ہو جانا!“ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","لیکن تم سب میرے پاس آئے اور کہا، ”کیوں نہ ہم جانے سے پہلے کچھ آدمی بھیجیں جو ملک کے حالات دریافت کریں اور واپس آ کر ہمیں اُس راستے کے بارے میں بتائیں جس پر ہمیں جانا ہے اور اُن شہروں کے بارے میں اطلاع دیں جن کے پاس ہم پہنچیں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","یہ بات مجھے پسند آئی۔ مَیں نے اِس کام کے لئے ہر قبیلے کے ایک آدمی کو چن کر بھیج دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","جب یہ بارہ آدمی پہاڑی علاقے میں جا کر وادیٔ اِسکال میں پہنچے تو اُس کی تفتیش کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","پھر وہ ملک کا کچھ پھل لے کر لوٹ آئے اور ہمیں ملک کے بارے میں اطلاع دے کر کہا، ”جو ملک رب ہمارا خدا ہمیں دینے والا ہے وہ اچھا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","لیکن تم جانا نہیں چاہتے تھے بلکہ سرکشی کر کے رب اپنے خدا کا حکم نہ مانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","تم نے اپنے خیموں میں بڑبڑاتے ہوئے کہا، ”رب ہم سے نفرت رکھتا ہے۔ وہ ہمیں مصر سے نکال لایا ہے تاکہ ہمیں اموریوں کے ہاتھوں ہلاک کروائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","ہم کہاں جائیں؟ ہمارے بھائیوں نے ہمیں بےدل کر دیا ہے۔ وہ کہتے ہیں، ’وہاں کے لوگ ہم سے طاقت ور اور درازقد ہیں۔ اُن کے بڑے بڑے شہروں کی فصیلیں آسمان سے باتیں کرتی ہیں۔ وہاں ہم نے عناق کی اولاد بھی دیکھی جو دیو قامت ہیں‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","مَیں نے کہا، ”نہ گھبراؤ اور نہ اُن سے خوف کھاؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","رب تمہارا خدا تمہارے آگے آگے چلتا ہوا تمہارے لئے لڑے گا۔ تم خود دیکھ چکے ہو کہ وہ کس طرح مصر ");
INSERT INTO urdgvu_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","اور ریگستان میں تمہارے لئے لڑا۔ یہاں بھی وہ ایسا ہی کرے گا۔ تُو خود گواہ ہے کہ بیابان میں پورے سفر کے دوران رب تجھے یوں اُٹھائے پھرا جس طرح باپ اپنے بیٹے کو اُٹھائے پھرتا ہے۔ اِس طرح چلتے چلتے تم یہاں تک پہنچ گئے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","اِس کے باوجود تم نے رب اپنے خدا پر بھروسا نہ رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","تم نے یہ بات نظرانداز کی کہ وہ سفر کے دوران رات کے وقت آگ اور دن کے وقت بادل کی صورت میں تمہارے آگے آگے چلتا رہا تاکہ تمہارے لئے خیمے لگانے کی جگہیں معلوم کرے اور تمہیں راستہ دکھائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","جب رب نے تمہاری یہ باتیں سنیں تو اُسے غصہ آیا اور اُس نے قَسم کھا کر کہا، ");
INSERT INTO urdgvu_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","”اِس شریر نسل کا ایک مرد بھی اُس اچھے ملک کو نہیں دیکھے گا اگرچہ مَیں نے قَسم کھا کر تمہارے باپ دادا سے وعدہ کیا تھا کہ مَیں اُسے اُنہیں دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","صرف کالب بن یفُنّہ اُسے دیکھے گا۔ مَیں اُسے اور اُس کی اولاد کو وہ ملک دوں گا جس میں اُس نے سفر کیا ہے، کیونکہ اُس نے پورے طور پر رب کی پیروی کی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","تمہاری وجہ سے رب مجھ سے بھی ناراض ہوا اور کہا، ”تُو بھی اُس میں داخل نہیں ہو گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","لیکن تیرا مددگار یشوع بن نون داخل ہو گا۔ اُس کی حوصلہ افزائی کر، کیونکہ وہ ملک پر قبضہ کرنے میں اسرائیل کی راہنمائی کرے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","تم سے رب نے کہا، ”تمہارے بچے جو ابھی اچھے اور بُرے میں امتیاز نہیں کر سکتے، وہی ملک میں داخل ہوں گے، وہی بچے جن کے بارے میں تم نے کہا کہ دشمن اُنہیں ملکِ کنعان میں چھین لیں گے۔ اُنہیں مَیں ملک دوں گا، اور وہ اُس پر قبضہ کریں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","لیکن تم خود آگے نہ بڑھو۔ پیچھے مُڑ کر دوبارہ ریگستان میں بحرِ قُلزم کی طرف سفر کرو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","تب تم نے کہا، ”ہم نے رب کا گناہ کیا ہے۔ اب ہم ملک میں جا کر لڑیں گے، جس طرح رب ہمارے خدا نے ہمیں حکم دیا ہے۔“ چنانچہ یہ سوچتے ہوئے کہ اُس پہاڑی علاقے پر حملہ کرنا آسان ہو گا، ہر ایک مسلح ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","لیکن رب نے مجھ سے کہا، ”اُنہیں بتانا کہ وہاں جنگ کرنے کے لئے نہ جاؤ، کیونکہ مَیں تمہارے ساتھ نہیں ہوں گا۔ تم اپنے دشمنوں کے ہاتھوں شکست کھاؤ گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","مَیں نے تمہیں یہ بتایا، لیکن تم نے میری نہ سنی۔ تم نے سرکشی کر کے رب کا حکم نہ مانا بلکہ مغرور ہو کر پہاڑی علاقے میں داخل ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","وہاں کے اموری باشندے تمہارا سامنا کرنے نکلے۔ وہ شہد کی مکھیوں کے غول کی طرح تم پر ٹوٹ پڑے اور تمہارا تعاقب کر کے تمہیں سعیر سے حُرمہ تک مارتے گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","تب تم واپس آ کر رب کے سامنے زار و قطار رونے لگے۔ لیکن اُس نے توجہ نہ دی بلکہ تمہیں نظرانداز کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","اِس کے بعد تم بہت دنوں تک قادس برنیع میں رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","پھرجس طرح رب نے مجھے حکم دیا تھا ہم پیچھے مُڑ کر ریگستان میں بحرِ قُلزم کی طرف سفر کرنے لگے۔ کافی دیر تک ہم سعیر یعنی ادوم کے پہاڑی علاقے کے کنارے کنارے پھرتے رہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","ایک دن رب نے مجھ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","”تم بہت دیر سے اِس پہاڑی علاقے کے کنارے کنارے پھر رہے ہو۔ اب شمال کی طرف سفر کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","قوم کو بتانا، ’اگلے دنوں میں تم سعیر کے ملک میں سے گزرو گے جہاں تمہارے بھائی عیسَو کی اولاد آباد ہے۔ وہ تم سے ڈریں گے۔ توبھی بڑی احتیاط سے گزرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","اُن کے ساتھ جنگ نہ چھیڑنا، کیونکہ مَیں تمہیں اُن کے ملک کا ایک مربع فٹ بھی نہیں دوں گا۔ مَیں نے سعیر کا پہاڑی علاقہ عیسَو اور اُس کی اولاد کو دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","لازم ہے کہ تم کھانے اور پینے کی تمام ضروریات پیسے دے کر خریدو‘۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","جو بھی کام تُو نے کیا ہے رب نے اُس پر برکت دی ہے۔ اِس وسیع ریگستان میں پورے سفر کے دوران اُس نے تیری نگہبانی کی۔ اِن 40 سالوں کے دوران رب تیرا خدا تیرے ساتھ تھا، اور تیری تمام ضروریات پوری ہوتی رہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","چنانچہ ہم سعیر کو چھوڑ کر جہاں ہمارے بھائی عیسَو کی اولاد آباد تھی دوسرے راستے سے آگے نکلے۔ ہم نے وہ راستہ چھوڑ دیا جو ایلات اور عصیون جابر کے شہروں سے بحیرۂ مُردار تک پہنچاتا ہے اور موآب کے بیابان کی طرف بڑھنے لگے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","وہاں رب نے مجھ سے کہا، ”موآب کے باشندوں کی مخالفت نہ کرنا اور نہ اُن کے ساتھ جنگ چھیڑنا، کیونکہ مَیں اُن کے ملک کا کوئی بھی حصہ تجھے نہیں دوں گا۔ مَیں نے عار شہر کو لوط کی اولاد کو دیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","پہلے ایمی وہاں رہتے تھے جو عناق کی اولاد کی طرح طاقت ور، درازقد اور تعداد میں زیادہ تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","عناق کی اولاد کی طرح وہ رفائیوں میں شمار کئے جاتے تھے، لیکن موآبی اُنہیں ایمی کہتے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","اِسی طرح قدیم زمانے میں حوری سعیر میں آباد تھے، لیکن عیسَو کی اولاد نے اُنہیں وہاں سے نکال دیا تھا۔ جس طرح اسرائیلیوں نے بعد میں اُس ملک میں کیا جو رب نے اُنہیں دیا تھا اُسی طرح عیسَو کی اولاد بڑھتے بڑھتے حوریوں کو تباہ کر کے اُن کی جگہ آباد ہوئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","رب نے کہا، ”اب جا کر وادیٔ زِرد کو عبور کرو۔“ ہم نے ایسا ہی کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","ہمیں قادس برنیع سے روانہ ہوئے 38 سال ہو گئے تھے۔ اب وہ تمام آدمی مر چکے تھے جو اُس وقت جنگ کرنے کے قابل تھے۔ ویسا ہی ہوا تھا جیسا رب نے قَسم کھا کر کہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","رب کی مخالفت کے باعث آخرکار خیمہ گاہ میں اُس نسل کا ایک مرد بھی نہ رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","جب وہ سب مر گئے تھے ");
INSERT INTO urdgvu_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","تب رب نے مجھ سے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","”آج تمہیں عار شہر سے ہو کر موآب کے علاقے میں سے گزرنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","پھر تم عمونیوں کے علاقے تک پہنچو گے۔ اُن کی بھی مخالفت نہ کرنا، اور نہ اُن کے ساتھ جنگ چھیڑنا، کیونکہ مَیں اُن کے ملک کا کوئی بھی حصہ تمہیں نہیں دوں گا۔ مَیں نے یہ ملک لوط کی اولاد کو دیا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","حقیقت میں عمونیوں کا ملک بھی رفائیوں کا ملک سمجھا جاتا تھا جو قدیم زمانے میں وہاں آباد تھے۔ عمونی اُنہیں زمزمی کہتے تھے، ");
INSERT INTO urdgvu_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","اور وہ دیو قامت تھے، طاقت ور اور تعداد میں زیادہ۔ وہ عناق کی اولاد جیسے درازقد تھے۔ جب عمونی ملک میں آئے تو رب نے رفائیوں کو اُن کے آگے آگے تباہ کر دیا۔ چنانچہ عمونی بڑھتے بڑھتے اُنہیں نکالتے گئے اور اُن کی جگہ آباد ہوئے، ");
INSERT INTO urdgvu_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","بالکل اُسی طرح جس طرح رب نے عیسَو کی اولاد کے آگے آگے حوریوں کو تباہ کر دیا تھا جب وہ سعیر کے ملک میں آئے تھے۔ وہاں بھی وہ بڑھتے بڑھتے حوریوں کو نکالتے گئے اور اُن کی جگہ آباد ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","اِسی طرح ایک اَور قدیم قوم بنام عوی کو بھی اُس کے ملک سے نکالا گیا۔ عوی غزہ تک آباد تھے، لیکن جب کفتوری کفتور یعنی کریتے سے آئے تو اُنہوں نے اُنہیں تباہ کر دیا اور اُن کی جگہ آباد ہو گئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","رب نے موسیٰ سے کہا، ”اب جا کر وادیٔ ارنون کو عبور کرو۔ یوں سمجھو کہ مَیں حسبون کے اموری بادشاہ سیحون کو اُس کے ملک سمیت تمہارے حوالے کر چکا ہوں۔ اُس پر قبضہ کرنا شروع کرو اور اُس کے ساتھ جنگ کرنے کا موقع ڈھونڈو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","اِسی دن سے مَیں تمام قوموں میں تمہارے بارے میں دہشت اور خوف پیدا کروں گا۔ وہ تمہاری خبر سن کر خوف کے مارے تھرتھرائیں گی اور کانپیں گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","مَیں نے دشتِ قدیمات سے حسبون کے بادشاہ سیحون کے پاس قاصد بھیجے۔ میرا پیغام نفرت اور مخالفت سے خالی تھا۔ وہ یہ تھا، ");
INSERT INTO urdgvu_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","”ہمیں اپنے ملک میں سے گزرنے دیں۔ ہم شاہراہ پر ہی رہیں گے اور اُس سے نہ بائیں، نہ دائیں طرف ہٹیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","ہم کھانے اور پینے کی تمام ضروریات کے لئے مناسب پیسے دیں گے۔ ہمیں پیدل اپنے ملک میں سے گزرنے دیں، ");
INSERT INTO urdgvu_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","جس طرح سعیر کے باشندوں عیسَو کی اولاد اور عار کے رہنے والے موآبیوں نے ہمیں گزرنے دیا۔ کیونکہ ہماری منزل دریائے یردن کے مغرب میں ہے، وہ ملک جو رب ہمارا خدا ہمیں دینے والا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","لیکن حسبون کے بادشاہ سیحون نے ہمیں گزرنے نہ دیا، کیونکہ رب تمہارے خدا نے اُسے بےلچک اور ہماری بات سے انکار کرنے پر آمادہ کر دیا تھا تاکہ سیحون ہمارے قابو میں آ جائے۔ اور بعد میں ایسا ہی ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","رب نے مجھ سے کہا، ”یوں سمجھ لے کہ مَیں سیحون اور اُس کے ملک کو تیرے حوالے کرنے لگا ہوں۔ اب نکل کر اُس پر قبضہ کرنا شروع کرو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","جب سیحون اپنی ساری فوج لے کر ہمارا مقابلہ کرنے کے لئے یہض آیا ");
INSERT INTO urdgvu_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","تو رب ہمارے خدا نے ہمیں پوری فتح بخشی۔ ہم نے سیحون، اُس کے بیٹوں اور پوری قوم کو شکست دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","اُس وقت ہم نے اُس کے تمام شہروں پر قبضہ کر لیا اور اُن کے تمام مردوں، عورتوں اور بچوں کو مار ڈالا۔ کوئی بھی نہ بچا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","ہم نے صرف مویشی اور شہروں کا لُوٹا ہوا مال اپنے لئے بچائے رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","وادیٔ ارنون کے کنارے پر واقع عروعیر سے لے کر جِلعاد تک ہر شہر کو شکست ماننی پڑی۔ اِس میں وہ شہر بھی شامل تھا جو وادیٔ ارنون میں تھا۔ رب ہمارے خدا نے اُن سب کو ہمارے حوالے کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","لیکن تم نے عمونیوں کا ملک چھوڑ دیا اور نہ دریائے یبوق کے ارد گرد کے علاقے، نہ اُس کے پہاڑی علاقے کے شہروں کو چھیڑا، کیونکہ رب ہمارے خدا نے ایسا کرنے سے تمہیں منع کیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","اِس کے بعد ہم شمال میں بسن کی طرف بڑھ گئے۔ بسن کا بادشاہ عوج اپنی تمام فوج کے ساتھ نکل کر ہمارا مقابلہ کرنے کے لئے اِدرعی آیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","رب نے مجھ سے کہا، ”اُس سے مت ڈر۔ مَیں اُسے، اُس کی پوری فوج اور اُس کا ملک تیرے حوالے کر چکا ہوں۔ اُس کے ساتھ وہ کچھ کر جو تُو نے اموری بادشاہ سیحون کے ساتھ کیا جو حسبون میں حکومت کرتا تھا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","ایسا ہی ہوا۔ رب ہمارے خدا کی مدد سے ہم نے بسن کے بادشاہ عوج اور اُس کی تمام قوم کو شکست دی۔ ہم نے سب کوہلاک کر دیا۔ کوئی بھی نہ بچا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","اُسی وقت ہم نے اُس کے تمام شہروں پر قبضہ کر لیا۔ ہم نے کُل 60 شہروں پر یعنی ارجوب کے سارے علاقے پر قبضہ کیا جس پر عوج کی حکومت تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","اِن تمام شہروں کی حفاظت اونچی اونچی فصیلوں اور کنڈے والے دروازوں سے کی گئی تھی۔ دیہات میں بہت سی ایسی آبادیاں بھی مل گئیں جن کی فصیلیں نہیں تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","ہم نے اُن کے ساتھ وہ کچھ کیا جو ہم نے حسبون کے بادشاہ سیحون کے علاقے کے ساتھ کیا تھا۔ ہم نے سب کچھ رب کے حوالے کر کے ہر شہر کو اور تمام مردوں، عورتوں اور بچوں کو ہلاک کر ڈالا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","ہم نے صرف تمام مویشی اور شہروں کا لُوٹا ہوا مال اپنے لئے بچائے رکھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","یوں ہم نے اُس وقت اموریوں کے اِن دو بادشاہوں سے دریائے یردن کا مشرقی علاقہ وادیٔ ارنون سے لے کر حرمون پہاڑ تک چھین لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(صیدا کے باشندے حرمون کو سِریون کہتے ہیں جبکہ اموریوں نے اُس کا نام سنیر رکھا)۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","ہم نے عوج بادشاہ کے پورے علاقے پر قبضہ کر لیا۔ اِس میں میدانِ مرتفع کے تمام شہر شامل تھے، نیز سلکہ اور اِدرعی تک جِلعاد اور بسن کے پورے علاقے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","بادشاہ عوج دیو قامت قبیلے رفائی کا آخری مرد تھا۔ اُس کا لوہے کا تابوت 13 سے زائد فٹ لمبا اور چھ فٹ چوڑا تھا اور آج تک عمونیوں کے شہر ربّہ میں دیکھا جا سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","جب ہم نے دریائے یردن کے مشرقی علاقے پر قبضہ کیا تو مَیں نے روبن اور جد کے قبیلوں کو اُس کا جنوبی حصہ شہروں سمیت دیا۔ اِس علاقے کی جنوبی سرحد دریائے ارنون پر واقع شہر عروعیر ہے جبکہ شمال میں اِس میں جِلعاد کے پہاڑی علاقے کا آدھا حصہ بھی شامل ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","جِلعاد کا شمالی حصہ اور بسن کا ملک مَیں نے منسّی کے آدھے قبیلے کو دیا۔ (بسن میں ارجوب کا علاقہ ہے جہاں پہلے عوج بادشاہ کی حکومت تھی اور جو رفائیوں یعنی دیو قامت افراد کا ملک کہلاتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","منسّی کے قبیلے کے ایک آدمی بنام یائیر نے ارجوب پر جسوریوں اور معکاتیوں کی سرحد تک قبضہ کر لیا تھا۔ اُس نے اِس علاقے کی بستیوں کو اپنا نام دیا۔ آج تک یہی نام حووت یائیر یعنی یائیر کی بستیاں چلتا ہے۔) ");
INSERT INTO urdgvu_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","مَیں نے جِلعاد کا شمالی حصہ منسّی کے کنبے مکیر کو دیا ");
INSERT INTO urdgvu_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","لیکن جِلعاد کا جنوبی حصہ روبن اور جد کے قبیلوں کو دیا۔ اِس حصے کی ایک سرحد جنوب میں وادیٔ ارنون کے بیچ میں سے گزرتی ہے جبکہ دوسری سرحد دریائے یبوق ہے جس کے پار عمونیوں کی حکومت ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","اُس کی مغربی سرحد دریائے یردن ہے یعنی کِنّرت (گلیل) کی جھیل سے لے کر بحیرۂ مُردار تک جو پِسگہ کے پہاڑی سلسلے کے دامن میں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","اُس وقت مَیں نے روبن، جد اور منسّی کے قبیلوں سے کہا، ”رب تمہارے خدا نے تمہیں میراث میں یہ ملک دے دیا ہے۔ لیکن شرط یہ ہے کہ تمہارے تمام جنگ کرنے کے قابل مرد مسلح ہو کر تمہارے اسرائیلی بھائیوں کے آگے آگے دریائے یردن کو پار کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","صرف تمہاری عورتیں اور بچے پیچھے رہ کر اُن شہروں میں انتظار کر سکتے ہیں جو مَیں نے تمہارے لئے مقرر کئے ہیں۔ تم اپنے مویشیوں کو بھی پیچھے چھوڑ سکتے ہو، کیونکہ مجھے پتا ہے کہ تمہارے بہت زیادہ جانور ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","اپنے بھائیوں کے ساتھ چلتے ہوئے اُن کی مدد کرتے رہو۔ جب رب تمہارا خدا اُنہیں دریائے یردن کے مغرب میں واقع ملک دے گا اور وہ تمہاری طرح آرام اور سکون سے وہاں آباد ہو جائیں گے تب تم اپنے ملک میں واپس جا سکتے ہو۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","ساتھ ساتھ مَیں نے یشوع سے کہا، ”تُو نے اپنی آنکھوں سے سب کچھ دیکھ لیا ہے جو رب تمہارے خدا نے اِن دونوں بادشاہوں سیحون اور عوج سے کیا۔ وہ یہی کچھ ہر اُس بادشاہ کے ساتھ کرے گا جس کے ملک پر تُو دریا کو پار کر کے حملہ کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","اُن سے نہ ڈرو۔ تمہارا خدا خود تمہارے لئے جنگ کرے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","اُس وقت مَیں نے رب سے التجا کر کے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","”اے رب قادرِ مطلق، تُو اپنے خادم کو اپنی عظمت اور قدرت دکھانے لگا ہے۔ کیا آسمان یا زمین پر کوئی اَور خدا ہے جو تیری طرح کے عظیم کام کر سکتا ہے؟ ہرگز نہیں! ");
INSERT INTO urdgvu_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","مہربانی کر کے مجھے بھی دریائے یردن کو پار کر کے اُس اچھے ملک یعنی اُس بہترین پہاڑی علاقے کو لبنان تک دیکھنے کی اجازت دے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","لیکن تمہارے سبب سے رب مجھ سے ناراض تھا۔ اُس نے میری نہ سنی بلکہ کہا، ”بس کر! آئندہ میرے ساتھ اِس کا ذکر نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","پِسگہ کی چوٹی پر چڑھ کر چاروں طرف نظر دوڑا۔ وہاں سے غور سے دیکھ، کیونکہ تُو خود دریائے یردن کو عبور نہیں کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","اپنی جگہ یشوع کو مقرر کر۔ اُس کی حوصلہ افزائی کر اور اُسے مضبوط کر، کیونکہ وہی اِس قوم کو دریائے یردن کے مغرب میں لے جائے گا اور قبیلوں میں اُس ملک کو تقسیم کرے گا جسے تُو پہاڑ سے دیکھے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","چنانچہ ہم بیت فغور کے قریب وادی میں ٹھہرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","اے اسرائیل، اب وہ تمام احکام دھیان سے سن لے جو مَیں تمہیں سکھاتا ہوں۔ اُن پر عمل کرو تاکہ تم زندہ رہو اور جا کر اُس ملک پر قبضہ کرو جو رب تمہارے باپ دادا کا خدا تمہیں دینے والا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","جو احکام مَیں تمہیں سکھاتا ہوں اُن میں نہ کسی بات کا اضافہ کرو اور نہ اُن سے کوئی بات نکالو۔ رب اپنے خدا کے تمام احکام پر عمل کرو جو مَیں نے تمہیں دیئے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","تم نے خود دیکھا ہے کہ رب نے بعل فغور سے کیا کچھ کیا۔ وہاں رب تیرے خدا نے ہر ایک کو ہلاک کر ڈالا جس نے فغور کے بعل دیوتا کی پوجا کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","لیکن تم میں سے جتنے رب اپنے خدا کے ساتھ لپٹے رہے وہ سب آج تک زندہ ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","مَیں نے تمہیں تمام احکام یوں سکھا دیئے ہیں جس طرح رب میرے خدا نے مجھے بتایا۔ کیونکہ لازم ہے کہ تم اُس ملک میں اِن کے تابع رہو جس پر تم قبضہ کرنے والے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","اِنہیں مانو اور اِن پر عمل کرو تو دوسری قوموں کو تمہاری دانش مندی اور سمجھ نظر آئے گی۔ پھر وہ اِن تمام احکام کے بارے میں سن کر کہیں گی، ”واہ، یہ عظیم قوم کیسی دانش مند اور سمجھ دار ہے!“ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","کون سی عظیم قوم کے معبود اِتنے قریب ہیں جتنا ہمارا خدا ہمارے قریب ہے؟ جب بھی ہم مدد کے لئے پکارتے ہیں تو رب ہمارا خدا موجود ہوتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","کون سی عظیم قوم کے پاس ایسے منصفانہ احکام اور ہدایات ہیں جیسے مَیں آج تمہیں پوری شریعت سنا کر پیش کر رہا ہوں؟ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","لیکن خبردار، احتیاط کرنا اور وہ تمام باتیں نہ بھولنا جو تیری آنکھوں نے دیکھی ہیں۔ وہ عمر بھر تیرے دل میں سے مٹ نہ جائیں بلکہ اُنہیں اپنے بچوں اور پوتے پوتیوں کو بھی بتاتے رہنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","وہ دن یاد کر جب تُو حورب یعنی سینا پہاڑ پر رب اپنے خدا کے سامنے حاضر تھا اور اُس نے مجھے بتایا، ”قوم کو یہاں میرے پاس جمع کر تاکہ مَیں اُن سے بات کروں اور وہ عمر بھر میرا خوف مانیں اور اپنے بچوں کو میری باتیں سکھاتے رہیں۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","اُس وقت تم قریب آ کر پہاڑ کے دامن میں کھڑے ہوئے۔ وہ جل رہا تھا، اور اُس کی آگ آسمان تک بھڑک رہی تھی جبکہ کالے بادلوں اور گہرے اندھیرے نے اُسے نظروں سے چھپا دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","پھر رب آگ میں سے تم سے ہم کلام ہوا۔ تم نے اُس کی باتیں سنیں لیکن اُس کی کوئی شکل نہ دیکھی۔ صرف اُس کی آواز سنائی دی۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","اُس نے تمہارے لئے اپنے عہد یعنی اُن 10 احکام کا اعلان کیا اور حکم دیا کہ اِن پر عمل کرو۔ پھر اُس نے اُنہیں پتھر کی دو تختیوں پر لکھ دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","رب نے مجھے ہدایت کی، ”اُنہیں وہ تمام احکام سکھا جن کے مطابق اُنہیں چلنا ہو گا جب وہ دریائے یردن کو پار کر کے کنعان پر قبضہ کریں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","جب رب حورب یعنی سینا پہاڑ پر تم سے ہم کلام ہوا تو تم نے اُس کی کوئی شکل نہ دیکھی۔ چنانچہ خبردار رہو ");
INSERT INTO urdgvu_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","کہ تم غلط کام کر کے اپنے لئے کسی بھی شکل کا بُت نہ بناؤ۔ نہ مرد، عورت، ");
INSERT INTO urdgvu_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","زمین پر چلنے والے جانور، پرندے، ");
INSERT INTO urdgvu_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","رینگنے والے جانور یا مچھلی کا بُت بناؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","جب تُو آسمان کی طرف نظر اُٹھا کر آسمان کا پورا لشکر دیکھے تو سورج، چاند اور ستاروں کی پرستش اور خدمت کرنے کی آزمائش میں نہ پڑنا۔ رب تیرے خدا نے اِن چیزوں کو باقی تمام قوموں کو عطا کیا ہے، ");
INSERT INTO urdgvu_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","لیکن تمہیں اُس نے مصر کے بھڑکتے بھٹے سے نکالا ہے تاکہ تم اُس کی اپنی قوم اور اُس کی میراث بن جاؤ۔ اور آج ایسا ہی ہوا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","تمہارے سبب سے رب نے مجھ سے ناراض ہو کر قَسم کھائی کہ تُو دریائے یردن کو پار کر کے اُس اچھے ملک میں داخل نہیں ہو گا جو رب تیرا خدا تجھے میراث میں دینے والا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","مَیں یہیں اِسی ملک میں مر جاؤں گا اور دریائے یردن کو پار نہیں کروں گا۔ لیکن تم دریا کو پار کر کے اُس بہترین ملک پر قبضہ کرو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","ہر صورت میں وہ عہد یاد رکھنا جو رب تمہارے خدا نے تمہارے ساتھ باندھا ہے۔ اپنے لئے کسی بھی چیز کی مورت نہ بنانا۔ یہ رب کا حکم ہے، ");
INSERT INTO urdgvu_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","کیونکہ رب تیرا خدا بھسم کر دینے والی آگ ہے، وہ غیور خدا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","تم ملک میں جا کر وہاں رہو گے۔ تمہارے بچے اور پوتے نواسے اُس میں پیدا ہو جائیں گے۔ جب اِس طرح بہت وقت گزر جائے گا تو خطرہ ہے کہ تم غلط کام کر کے کسی چیز کی مورت بناؤ۔ ایسا کبھی نہ کرنا۔ یہ رب تمہارے خدا کی نظر میں بُرا ہے اور اُسے غصہ دلائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","آج آسمان اور زمین میرے گواہ ہیں کہ اگر تم ایسا کرو تو جلدی سے اُس ملک میں سے مٹ جاؤ گے جس پر تم دریائے یردن کو پار کر کے قبضہ کرو گے۔ تم دیر تک وہاں جیتے نہیں رہو گے بلکہ پورے طور پر ہلاک ہو جاؤ گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","رب تمہیں ملک سے نکال کر مختلف قوموں میں منتشر کر دے گا، اور وہاں صرف تھوڑے ہی افراد بچے رہیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","وہاں تم انسان کے ہاتھوں سے بنے ہوئے لکڑی اور پتھر کے بُتوں کی خدمت کرو گے، جو نہ دیکھ سکتے، نہ سن سکتے، نہ کھا سکتے اور نہ سونگھ سکتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","وہیں تُو رب اپنے خدا کو تلاش کرے گا، اور اگر اُسے پورے دل و جان سے ڈھونڈے تو وہ تجھے مل بھی جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","جب تُو اِس تکلیف میں مبتلا ہو گا اور یہ سارا کچھ تجھ پر سے گزرے گا پھر آخرکار رب اپنے خدا کی طرف رجوع کر کے اُس کی سنے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","کیونکہ رب تیرا خدا رحیم خدا ہے۔ وہ تجھے نہ ترک کرے گا اور نہ برباد کرے گا۔ وہ اُس عہد کو نہیں بھولے گا جو اُس نے قَسم کھا کر تیرے باپ دادا سے باندھا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","دنیا میں انسان کی تخلیق سے لے کر آج تک ماضی کی تفتیش کر۔ آسمان کے ایک سرے سے دوسرے سرے تک کھوج لگا۔ کیا اِس سے پہلے کبھی اِس طرح کا معجزانہ کام ہوا ہے؟ کیا کسی نے اِس سے پہلے اِس قسم کے عظیم کام کی خبر سنی ہے؟ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","تُو نے آگ میں سے بولتی ہوئی اللہ کی آواز سنی توبھی جیتا بچا! کیا کسی اَور قوم کے ساتھ ایسا ہوا ہے؟ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","کیا کسی اَور معبود نے کبھی جرأت کی ہے کہ رب کی طرح پوری قوم کو ایک ملک سے نکال کر اپنی ملکیت بنایا ہو؟ اُس نے ایسا ہی تمہارے ساتھ کیا۔ اُس نے تمہارے دیکھتے دیکھتے مصریوں کو آزمایا، اُنہیں بڑے معجزے دکھائے، اُن کے ساتھ جنگ کی، اپنی بڑی قدرت اور اختیار کا اظہار کیا اور ہول ناک کاموں سے اُن پر غالب آ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","تجھے یہ سب کچھ دکھایا گیا تاکہ تُو جان لے کہ رب خدا ہے۔ اُس کے سوا کوئی اَور نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","اُس نے تجھے نصیحت دینے کے لئے آسمان سے اپنی آواز سنائی۔ زمین پر اُس نے تجھے اپنی عظیم آگ دکھائی جس میں سے تُو نے اُس کی باتیں سنیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","اُسے تیرے باپ دادا سے پیار تھا، اور اُس نے تجھے جو اُن کی اولاد ہیں چن لیا۔ اِس لئے وہ خود حاضر ہو کر اپنی عظیم قدرت سے تجھے مصر سے نکال لایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","اُس نے تیرے آگے سے تجھ سے زیادہ بڑی اور طاقت ور قومیں نکال دیں تاکہ تجھے اُن کا ملک میراث میں مل جائے۔ آج ایسا ہی ہو رہا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","چنانچہ آج جان لے اور ذہن میں رکھ کہ رب آسمان اور زمین کا خدا ہے۔ کوئی اَور معبود نہیں ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","اُس کے احکام پر عمل کر جو مَیں تجھے آج سنا رہا ہوں۔ پھر تُو اور تیری اولاد کامیاب ہوں گے، اور تُو دیر تک اُس ملک میں جیتا رہے گا جو رب تجھے ہمیشہ کے لئے دے رہا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","یہ کہہ کر موسیٰ نے دریائے یردن کے مشرق میں پناہ کے تین شہر چن لئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","اُن میں وہ شخص پناہ لے سکتا تھا جس نے دشمنی کی بنا پر نہیں بلکہ غیرارادی طور پر کسی کو جان سے مار دیا تھا۔ ایسے شہر میں پناہ لینے کے سبب سے اُسے بدلے میں قتل نہیں کیا جا سکتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","اِس کے لئے روبن کے قبیلے کے لئے میدانِ مرتفع کا شہر بصر، جد کے قبیلے کے لئے جِلعاد کا شہر رامات اور منسّی کے قبیلے کے لئے بسن کا شہر جولان چنا گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","درجِ ذیل وہ شریعت ہے جو موسیٰ نے اسرائیلیوں کو پیش کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","موسیٰ نے یہ احکام اور ہدایات اُس وقت پیش کیں جب وہ مصر سے نکل کر ");
INSERT INTO urdgvu_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","دریائے یردن کے مشرقی کنارے پر تھے۔ بیت فغور اُن کے مقابل تھا، اور وہ اموری بادشاہ سیحون کے ملک میں خیمہ زن تھے۔ سیحون کی رہائش حسبون میں تھی اور اُسے اسرائیلیوں سے شکست ہوئی تھی جب وہ موسیٰ کی راہنمائی میں مصر سے نکل آئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","اُس کے ملک پر قبضہ کر کے اُنہوں نے بسن کے ملک پر بھی فتح پائی تھی جس کا بادشاہ عوج تھا۔ اِن دونوں اموری بادشاہوں کا یہ پورا علاقہ اُن کے ہاتھ میں آ گیا تھا۔ یہ علاقہ دریائے یردن کے مشرق میں تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","اُس کی جنوبی سرحد دریائے ارنون کے کنارے پر واقع شہر عروعیر تھی جبکہ اُس کی شمالی سرحد سِیُون یعنی حرمون پہاڑ تھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","دریائے یردن کا پورا مشرقی کنارہ پِسگہ کے پہاڑی سلسلے کے دامن میں واقع بحیرۂ مُردار تک اُس میں شامل تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","موسیٰ نے تمام اسرائیلیوں کو جمع کر کے کہا، اے اسرائیل، دھیان سے وہ ہدایات اور احکام سن جو مَیں تمہیں آج پیش کر رہا ہوں۔ اُنہیں سیکھو اور بڑی احتیاط سے اُن پر عمل کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","رب ہمارے خدا نے حورب یعنی سینا پہاڑ پر ہمارے ساتھ عہد باندھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","اُس نے یہ عہد ہمارے باپ دادا کے ساتھ نہیں بلکہ ہمارے ہی ساتھ باندھا ہے، جو آج اِس جگہ پر زندہ ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","رب پہاڑ پر آگ میں سے رُوبرُو ہو کر تم سے ہم کلام ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","اُس وقت مَیں تمہارے اور رب کے درمیان کھڑا ہوا تاکہ تمہیں رب کی باتیں سناؤں۔ کیونکہ تم آگ سے ڈرتے تھے اور اِس لئے پہاڑ پر نہ چڑھے۔ اُس وقت رب نے کہا، ");
INSERT INTO urdgvu_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","”مَیں رب تیرا خدا ہوں جو تجھے ملکِ مصر کی غلامی سے نکال لایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","میرے سوا کسی اَور معبود کی پرستش نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","اپنے لئے بُت نہ بنانا۔ کسی بھی چیز کی مورت نہ بنانا، چاہے وہ آسمان میں، زمین پر یا سمندر میں ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","نہ بُتوں کی پرستش، نہ اُن کی خدمت کرنا، کیونکہ مَیں تیرا رب غیور خدا ہوں۔ جو مجھ سے نفرت کرتے ہیں اُنہیں مَیں تیسری اور چوتھی پشت تک سزا دوں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","لیکن جو مجھ سے محبت رکھتے اور میرے احکام پورے کرتے ہیں اُن پر مَیں ہزار پُشتوں تک مہربانی کروں گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","رب اپنے خدا کا نام بےمقصد یا غلط مقصد کے لئے استعمال نہ کرنا۔ جو بھی ایسا کرتا ہے اُسے رب سزا دیئے بغیر نہیں چھوڑے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","سبت کے دن کا خیال رکھنا۔ اُسے اِس طرح منانا کہ وہ مخصوص و مُقدّس ہو، اُسی طرح جس طرح رب تیرے خدا نے تجھے حکم دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","ہفتے کے پہلے چھ دن اپنا کام کاج کر، ");
INSERT INTO urdgvu_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","لیکن ساتواں دن رب تیرے خدا کا آرام کا دن ہے۔ اُس دن کسی طرح کا کام نہ کرنا۔ نہ تُو، نہ تیرا بیٹا، نہ تیری بیٹی، نہ تیرا نوکر، نہ تیری نوکرانی، نہ تیرا بَیل، نہ تیرا گدھا، نہ تیرا کوئی اَور مویشی۔ جو پردیسی تیرے درمیان رہتا ہے وہ بھی کام نہ کرے۔ تیرے نوکر اور تیری نوکرانی کو تیری طرح آرام کا موقع ملنا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","یاد رکھنا کہ تُو مصر میں غلام تھا اور کہ رب تیرا خدا ہی تجھے بڑی قدرت اور اختیار سے وہاں سے نکال لایا۔ اِس لئے اُس نے تجھے حکم دیا ہے کہ سبت کا دن منانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","اپنے باپ اور اپنی ماں کی عزت کرنا جس طرح رب تیرے خدا نے تجھے حکم دیا ہے۔ پھر تُو اُس ملک میں جو رب تیرا خدا تجھے دینے والا ہے خوش حال ہو گا اور دیر تک جیتا رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","قتل نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","زنا نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","چوری نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","اپنے پڑوسی کے بارے میں جھوٹی گواہی نہ دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","اپنے پڑوسی کی بیوی کا لالچ نہ کرنا۔ نہ اُس کے گھر کا، نہ اُس کی زمین کا، نہ اُس کے نوکر کا، نہ اُس کی نوکرانی کا، نہ اُس کے بَیل اور نہ اُس کے گدھے کا بلکہ اُس کی کسی بھی چیز کا لالچ نہ کرنا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","رب نے تم سب کو یہ احکام دیئے جب تم سینا پہاڑ کے دامن میں جمع تھے۔ وہاں تم نے آگ، بادل اور گہرے اندھیرے میں سے اُس کی زوردار آواز سنی۔ یہی کچھ اُس نے کہا اور بس۔ پھر اُس نے اُنہیں پتھر کی دو تختیوں پر لکھ کر مجھے دے دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","جب تم نے تاریکی سے یہ آواز سنی اور پہاڑ کی جلتی ہوئی حالت دیکھی تو تمہارے قبیلوں کے راہنما اور بزرگ میرے پاس آئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","اُنہوں نے کہا، ”رب ہمارے خدا نے ہم پر اپنا جلال اور عظمت ظاہر کی ہے۔ آج ہم نے آگ میں سے اُس کی آواز سنی ہے۔ ہم نے دیکھ لیا ہے کہ جب اللہ انسان سے ہم کلام ہوتا ہے تو ضروری نہیں کہ وہ مر جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","لیکن اب ہم کیوں اپنی جان خطرے میں ڈالیں؟ اگر ہم مزید رب اپنے خدا کی آواز سنیں تو یہ بڑی آگ ہمیں بھسم کر دے گی اور ہم اپنی جان سے ہاتھ دھو بیٹھیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","کیونکہ فانی انسانوں میں سے کون ہماری طرح زندہ خدا کو آگ میں سے باتیں کرتے ہوئے سن کر زندہ رہا ہے؟ کوئی بھی نہیں! ");
INSERT INTO urdgvu_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","آپ ہی قریب جا کر اُن تمام باتوں کو سنیں جو رب ہمارا خدا ہمیں بتانا چاہتا ہے۔ پھر لوٹ کر ہمیں وہ باتیں سنائیں۔ ہم اُنہیں سنیں گے اور اُن پر عمل کریں گے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","جب رب نے یہ سنا تو اُس نے مجھ سے کہا، ”مَیں نے اِن لوگوں کی یہ باتیں سن لی ہیں۔ وہ ٹھیک کہتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","کاش اُن کی سوچ ہمیشہ ایسی ہی ہو! کاش وہ ہمیشہ اِسی طرح میرا خوف مانیں اور میرے احکام پر عمل کریں! اگر وہ ایسا کریں گے تو وہ اور اُن کی اولاد ہمیشہ کامیاب رہیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","جا، اُنہیں بتا دے کہ اپنے خیموں میں لوٹ جاؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","لیکن تُو یہاں میرے پاس رہ تاکہ مَیں تجھے تمام قوانین اور احکام دے دوں۔ اُن کو لوگوں کو سکھانا تاکہ وہ اُس ملک میں اُن کے مطابق چلیں جو مَیں اُنہیں دوں گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","چنانچہ احتیاط سے اُن احکام پر عمل کرو جو رب تمہارے خدا نے تمہیں دیئے ہیں۔ اُن سے نہ دائیں طرف ہٹو نہ بائیں طرف۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","ہمیشہ اُس راہ پر چلتے رہو جو رب تمہارے خدا نے تمہیں بتائی ہے۔ پھر تم کامیاب ہو گے اور اُس ملک میں دیر تک جیتے رہو گے جس پر تم قبضہ کرو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","یہ وہ تمام احکام ہیں جو رب تمہارے خدا نے مجھے تمہیں سکھانے کے لئے کہا۔ اُس ملک میں اِن پر عمل کرنا جس میں تم جانے والے ہو تاکہ اُس پر قبضہ کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","عمر بھر تُو، تیرے بچے اور پوتے نواسے رب اپنے خدا کا خوف مانیں اور اُس کے اُن تمام احکام پر چلیں جو مَیں تجھے دے رہا ہوں۔ تب تُو دیر تک جیتا رہے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","اے اسرائیل، یہ میری باتیں سن اور بڑی احتیاط سے اِن پر عمل کر! پھر رب تیرے خدا کا وعدہ پورا ہو جائے گا کہ تُو کامیاب رہے گا اور تیری تعداد اُس ملک میں خوب بڑھتی جائے گی جس میں دودھ اور شہد کی کثرت ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","سن اے اسرائیل! رب ہمارا خدا ایک ہی رب ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","رب اپنے خدا سے اپنے پورے دل، اپنی پوری جان اور اپنی پوری طاقت سے پیار کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","جو احکام مَیں تجھے آج بتا رہا ہوں اُنہیں اپنے دل پر نقش کر۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","اُنہیں اپنے بچوں کے ذہن نشین کرا۔ یہی باتیں ہر وقت اور ہر جگہ تیرے لبوں پر ہوں خواہ تُو گھر میں بیٹھا یا راستے پر چلتا ہو، لیٹا ہو یا کھڑا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","اُنہیں نشان کے طور پر اور یاددہانی کے لئے اپنے بازوؤں اور ماتھے پر لگا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","اُنہیں اپنے گھروں کی چوکھٹوں اور اپنے شہروں کے دروازوں پر لکھ۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","رب تیرے خدا کا وعدہ پورا ہو گا جو اُس نے قَسم کھا کر تیرے باپ دادا ابراہیم، اسحاق اور یعقوب کے ساتھ کیا کہ مَیں تجھے کنعان میں لے جاؤں گا۔ جو بڑے اور شاندار شہر اُس میں ہیں وہ تُو نے خود نہیں بنائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","جو مکان اُس میں ہیں وہ ایسی اچھی چیزوں سے بھرے ہوئے ہیں جو تُو نے اُن میں نہیں رکھیں۔ جو کنوئیں اُس میں ہیں اُن کو تُو نے نہیں کھودا۔ جو انگور اور زیتون کے باغ اُس میں ہیں اُنہیں تُو نے نہیں لگایا۔ یہ حقیقت یاد رکھ۔ جب تُو اُس ملک میں کثرت کا کھانا کھا کر سیر ہو جائے گا ");
INSERT INTO urdgvu_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","تو خبردار! رب کو نہ بھولنا جو تجھے مصر کی غلامی سے نکال لایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","رب اپنے خدا کا خوف ماننا۔ صرف اُسی کی عبادت کرنا اور اُسی کا نام لے کر قَسم کھانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","دیگر معبودوں کی پیروی نہ کرنا۔ اِس میں تمام پڑوسی اقوام کے دیوتا بھی شامل ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","ورنہ رب تیرے خدا کا غضب تجھ پر نازل ہو کر تجھے ملک میں سے مٹا ڈالے گا۔ کیونکہ وہ غیور خدا ہے اور تیرے درمیان ہی رہتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","رب اپنے خدا کو اُس طرح نہ آزمانا جس طرح تم نے مسّہ میں کیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","دھیان سے رب اپنے خدا کے احکام کے مطابق چلو، اُن تمام ہدایات اور قوانین پر جو اُس نے تجھے دیئے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","جو کچھ رب کی نظر میں درست اور اچھا ہے وہ کر۔ پھر تُو کامیاب رہے گا، تُو جا کر اُس اچھے ملک پر قبضہ کرے گا جس کا وعدہ رب نے تیرے باپ دادا سے قَسم کھا کر کیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","تب رب کی بات پوری ہو جائے گی کہ تُو اپنے دشمنوں کو اپنے آگے آگے نکال دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","آنے والے دنوں میں تیرے بچے پوچھیں گے، ”رب ہمارے خدا نے آپ کو اِن تمام احکام پر عمل کرنے کو کیوں کہا؟“ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","پھر اُنہیں جواب دینا، ”ہم مصر کے بادشاہ فرعون کے غلام تھے، لیکن رب ہمیں بڑی قدرت کا اظہار کر کے مصر سے نکال لایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","ہمارے دیکھتے دیکھتے اُس نے بڑے بڑے نشان اور معجزے کئے اور مصر، فرعون اور اُس کے پورے گھرانے پر ہول ناک مصیبتیں بھیجیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","اُس وقت وہ ہمیں وہاں سے نکال لایا تاکہ ہمیں لے کر وہ ملک دے جس کا وعدہ اُس نے قَسم کھا کر ہمارے باپ دادا کے ساتھ کیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","رب ہمارے خدا ہی نے ہمیں کہا کہ اِن تمام احکام کے مطابق چلو اور رب اپنے خدا کا خوف مانو۔ کیونکہ اگر ہم ایسا کریں تو پھر ہم ہمیشہ کامیاب اور زندہ رہیں گے۔ اور آج تک ایسا ہی رہا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","اگر ہم رب اپنے خدا کے حضور رہ کر احتیاط سے اُن تمام باتوں پر عمل کریں گے جو اُس نے ہمیں کرنے کو کہی ہیں تو وہ ہمیں راست باز قرار دے گا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","رب تیرا خدا تجھے اُس ملک میں لے جائے گا جس پر تُو جا کر قبضہ کرے گا۔ وہ تیرے سامنے سے بہت سی قومیں بھگا دے گا۔ گو یہ سات قومیں یعنی حِتّی، جرجاسی، اموری، کنعانی، فرِزّی، حِوّی اور یبوسی تعداد اور طاقت کے لحاظ سے تجھ سے بڑی ہوں گی ");
INSERT INTO urdgvu_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","توبھی رب تیرا خدا اُنہیں تیرے حوالے کرے گا۔ جب تُو اُنہیں شکست دے گا تو اُن سب کو اُس کے لئے مخصوص کر کے ہلاک کر دینا ہے۔ نہ اُن کے ساتھ عہد باندھنا اور نہ اُن پر رحم کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","اُن میں سے کسی سے شادی نہ کرنا۔ نہ اپنی بیٹیوں کا رشتہ اُن کے بیٹوں کو دینا، نہ اپنے بیٹوں کا رشتہ اُن کی بیٹیوں سے کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","ورنہ وہ تمہارے بچوں کو میری پیروی سے دُور کریں گے اور وہ میری نہیں بلکہ اُن کے دیوتاؤں کی خدمت کریں گے۔ تب رب کا غضب تم پر نازل ہو کر جلدی سے تمہیں ہلاک کر دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","اِس لئے اُن کی قربان گاہیں ڈھا دینا۔ جن پتھروں کی وہ پوجا کرتے ہیں اُنہیں چِکنا چُور کر دینا، اُن کے یسیرت دیوی کے کھمبے کاٹ ڈالنا اور اُن کے بُت جلا دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","کیونکہ تُو رب اپنے خدا کے لئے مخصوص و مُقدّس ہے۔ اُس نے دنیا کی تمام قوموں میں سے تجھے چن کر اپنی قوم اور خاص ملکیت بنایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","رب نے کیوں تمہارے ساتھ تعلق قائم کیا اور تمہیں چن لیا؟ کیا اِس وجہ سے کہ تم تعداد میں دیگر قوموں کی نسبت زیادہ تھے؟ ہرگز نہیں! تم تو بہت کم تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","بلکہ وجہ یہ تھی کہ رب نے تمہیں پیار کیا اور وہ وعدہ پورا کیا جو اُس نے قَسم کھا کر تمہارے باپ دادا کے ساتھ کیا تھا۔ اِسی لئے وہ فدیہ دے کر تمہیں بڑی قدرت سے مصر کی غلامی اور اُس ملک کے بادشاہ کے ہاتھ سے بچا لایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","چنانچہ جان لے کہ صرف رب تیرا خدا ہی خدا ہے۔ وہ وفادار خدا ہے۔ جو اُس سے محبت رکھتے اور اُس کے احکام پر عمل کرتے ہیں اُن کے ساتھ وہ اپنا عہد قائم رکھے گا اور اُن پر ہزار پُشتوں تک مہربانی کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","لیکن اُس سے نفرت کرنے والوں کو وہ اُن کے رُوبرُو مناسب سزا دے کر برباد کرے گا۔ ہاں، جو اُس سے نفرت کرتے ہیں، اُن کے رُوبرُو وہ مناسب سزا دے گا اور جھجکے گا نہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","چنانچہ دھیان سے اُن تمام احکام پر عمل کر جو مَیں آج تجھے دے رہا ہوں تاکہ تُو اُن کے مطابق زندگی گزارے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","اگر تُو اُن پر توجہ دے اور احتیاط سے اُن پر چلے تو پھر رب تیرا خدا تیرے ساتھ اپنا عہد قائم رکھے گا اور تجھ پر مہربانی کرے گا، بالکل اُس وعدے کے مطابق جو اُس نے قَسم کھا کر تیرے باپ دادا سے کیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","وہ تجھے پیار کرے گا اور تجھے اُس ملک میں برکت دے گا جو تجھے دینے کا وعدہ اُس نے قَسم کھا کر تیرے باپ دادا سے کیا تھا۔ تجھے بہت اولاد بخشنے کے علاوہ وہ تیرے کھیتوں کو برکت دے گا، اور تجھے کثرت کا اناج، انگور اور زیتون حاصل ہو گا۔ وہ تیرے ریوڑوں کو بھی برکت دے گا، اور تیرے گائےبَیلوں اور بھیڑبکریوں کی تعداد بڑھتی جائے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","تجھے دیگر تمام قوموں کی نسبت کہیں زیادہ برکت ملے گی۔ نہ تجھ میں اور نہ تیرے مویشیوں میں بانجھ پن پایا جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","رب ہر بیماری کو تجھ سے دُور رکھے گا۔ وہ تجھ میں وہ خطرناک وبائیں پھیلنے نہیں دے گا جن سے تُو مصر میں واقف ہوا بلکہ اُنہیں اُن میں پھیلائے گا جو تجھ سے نفرت رکھتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","جو بھی قومیں رب تیرا خدا تیرے ہاتھ میں کر دے گا اُنہیں تباہ کرنا لازم ہے۔ اُن پر رحم کی نگاہ سے نہ دیکھنا، نہ اُن کے دیوتاؤں کی خدمت کرنا، ورنہ تُو پھنس جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","گو تیرا دل کہے، ”یہ قومیں ہم سے طاقت ور ہیں۔ ہم کس طرح اِنہیں نکال سکتے ہیں؟“ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","توبھی اُن سے نہ ڈر۔ وہی کچھ ذہن میں رکھ جو رب تیرے خدا نے فرعون اور پورے مصر کے ساتھ کیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","کیونکہ تُو نے اپنی آنکھوں سے رب اپنے خدا کی وہ بڑی آزمانے والی مصیبتیں اور معجزے، اُس کا وہ عظیم اختیار اور قدرت دیکھی جس سے وہ تجھے وہاں سے نکال لایا۔ وہی کچھ رب تیرا خدا اُن قوموں کے ساتھ بھی کرے گا جن سے تُو اِس وقت ڈرتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","نہ صرف یہ بلکہ رب تیرا خدا اُن کے درمیان زنبور بھی بھیجے گا تاکہ وہ بھی تباہ ہو جائیں جو پہلے حملوں سے بچ کر چھپ گئے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","اُن سے دہشت نہ کھا، کیونکہ رب تیرا خدا تیرے درمیان ہے۔ وہ عظیم خدا ہے جس سے سب خوف کھاتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","وہ رفتہ رفتہ اُن قوموں کو تیرے آگے سے بھگا دے گا۔ تُو اُنہیں ایک دم ختم نہیں کر سکے گا، ورنہ جنگلی جانور تیزی سے بڑھ کر تجھے نقصان پہنچائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","رب تیرا خدا اُنہیں تیرے حوالے کر دے گا۔ وہ اُن میں اِتنی سخت افرا تفری پیدا کرے گا کہ وہ برباد ہو جائیں گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","وہ اُن کے بادشاہوں کو بھی تیرے قابو میں کر دے گا، اور تُو اُن کا نام و نشان مٹا دے گا۔ کوئی بھی تیرا سامنا نہیں کر سکے گا بلکہ تُو اُن سب کو برباد کر دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","اُن کے دیوتاؤں کے مجسمے جلا دینا۔ جو چاندی اور سونا اُن پر چڑھایا ہوا ہے اُس کا لالچ نہ کرنا۔ اُسے نہ لینا ورنہ تُو پھنس جائے گا۔ کیونکہ اِن چیزوں سے رب تیرے خدا کو گھن آتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","اِس طرح کی مکروہ چیز اپنے گھر میں نہ لانا، ورنہ تجھے بھی اُس کے ساتھ الگ کر کے برباد کیا جائے گا۔ تیرے دل میں اُس سے شدید نفرت اور گھن ہو، کیونکہ اُسے پورے طور پر برباد کرنے کے لئے مخصوص کیا گیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","احتیاط سے اُن تمام احکام پر عمل کرو جو مَیں آج تجھے دے رہا ہوں۔ کیونکہ ایسا کرنے سے تم جیتے رہو گے، تعداد میں بڑھو گے اور جا کر اُس ملک پر قبضہ کرو گے جس کا وعدہ رب نے تمہارے باپ دادا سے قَسم کھا کر کیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","وہ پورا وقت یاد رکھ جب رب تیرا خدا ریگستان میں 40 سال تک تیری راہنمائی کرتا رہا تاکہ تجھے عاجز کر کے آزمائے اور معلوم کرے کہ کیا تُو اُس کے احکام پر چلے گا کہ نہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","اُس نے تجھے عاجز کر کے بھوکے ہونے دیا، پھر تجھے مَن کھلایا جس سے نہ تُو اور نہ تیرے باپ دادا واقف تھے۔ کیونکہ وہ تجھے سکھانا چاہتا تھا کہ انسان کی زندگی صرف روٹی پر منحصر نہیں ہوتی بلکہ ہر اُس بات پر جو رب کے منہ سے نکلتی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","اِن 40 سالوں کے دوران تیرے کپڑے نہ گھسے نہ پھٹے، نہ تیرے پاؤں سوجے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","چنانچہ دل میں جان لے کہ جس طرح باپ اپنے بیٹے کی تربیت کرتا ہے اُسی طرح رب ہمارا خدا ہماری تربیت کرتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","رب اپنے خدا کے احکام پر عمل کر کے اُس کی راہوں پر چل اور اُس کا خوف مان۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","کیونکہ وہ تجھے ایک بہترین ملک میں لے جا رہا ہے جس میں نہریں اور ایسے چشمے ہیں جو پہاڑیوں اور وادیوں کی زمین سے پھوٹ نکلتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","اُس کی پیداوار اناج، جَو، انگور، انجیر، انار، زیتون اور شہد ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","اُس میں روٹی کی کمی نہیں ہو گی، اور تُو کسی چیز سے محروم نہیں رہے گا۔ اُس کے پتھروں میں لوہا پایا جاتا ہے، اور کھدائی سے تُو اُس کی پہاڑیوں سے تانبا حاصل کر سکے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","جب تُو کثرت کا کھانا کھا کر سیر ہو جائے گا تو پھر رب اپنے خدا کی تمجید کرنا جس نے تجھے یہ شاندار ملک دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","خبردار، رب اپنے خدا کو نہ بھول اور اُس کے اُن احکام پر عمل کرنے سے گریز نہ کر جو مَیں آج تجھے دے رہا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","کیونکہ جب تُو کثرت کا کھانا کھا کر سیر ہو جائے گا، تُو شاندار گھر بنا کر اُن میں رہے گا ");
INSERT INTO urdgvu_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","اور تیرے ریوڑ، سونے چاندی اور باقی تمام مال میں اضافہ ہو گا ");
INSERT INTO urdgvu_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","تو کہیں تُو مغرور ہو کر رب اپنے خدا کو بھول نہ جائے جو تجھے مصر کی غلامی سے نکال لایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","جب تُو اُس وسیع اور ہول ناک ریگستان میں سفر کر رہا تھا جس میں زہریلے سانپ اور بچھو تھے تو وہی تیری راہنمائی کرتا رہا۔ پانی سے محروم اُس علاقے میں وہی سخت پتھر میں سے پانی نکال لایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","ریگستان میں وہی تجھے مَن کھلاتا رہا، جس سے تیرے باپ دادا واقف نہ تھے۔ اِن مشکلات سے وہ تجھے عاجز کر کے آزماتا رہا تاکہ آخرکار تُو کامیاب ہو جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","جب تجھے کامیابی حاصل ہو گی تو یہ نہ کہنا کہ مَیں نے اپنی ہی قوت اور طاقت سے یہ سب کچھ حاصل کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","بلکہ رب اپنے خدا کو یاد کرنا جس نے تجھے دولت حاصل کرنے کی قابلیت دی ہے۔ کیونکہ وہ آج بھی اُسی عہد پر قائم ہے جو اُس نے تیرے باپ دادا سے کیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","رب اپنے خدا کو نہ بھولنا، اور نہ دیگر معبودوں کے پیچھے پڑ کر اُنہیں سجدہ اور اُن کی خدمت کرنا۔ ورنہ مَیں خود گواہ ہوں کہ تم یقیناً ہلاک ہو جاؤ گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","اگر تم رب اپنے خدا کی اطاعت نہیں کرو گے تو پھر وہ تمہیں اُن قوموں کی طرح تباہ کر دے گا جو تم سے پہلے اِس ملک میں رہتی تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","سن اے اسرائیل! آج تُو دریائے یردن کو پار کرنے والا ہے۔ دوسری طرف تُو ایسی قوموں کو بھگا دے گا جو تجھ سے بڑی اور طاقت ور ہیں اور جن کے شاندار شہروں کی فصیلیں آسمان سے باتیں کرتی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","وہاں عناقی بستے ہیں جو طاقت ور اور درازقد ہیں۔ تُو خود جانتا ہے کہ اُن کے بارے میں کہا جاتا ہے، ”کون عناقیوں کا سامنا کر سکتا ہے؟“ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","لیکن آج جان لے کہ رب تیرا خدا تیرے آگے آگے چلتے ہوئے اُنہیں بھسم کر دینے والی آگ کی طرح ہلاک کرے گا۔ وہ تیرے آگے آگے اُن پر قابو پائے گا، اور تُو اُنہیں نکال کر جلدی مٹا دے گا، جس طرح رب نے وعدہ کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","جب رب تیرا خدا اُنہیں تیرے سامنے سے نکال دے گا تو تُو یہ نہ کہنا، ”مَیں راست باز ہوں، اِسی لئے رب مجھے لائق سمجھ کر یہاں لایا اور یہ ملک میراث میں دے دیا ہے۔“ یہ بات ہرگز درست نہیں ہے۔ رب اُن قوموں کو اُن کی غلط حرکتوں کی وجہ سے تیرے سامنے سے نکال دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","تُو اپنی راست بازی اور دیانت داری کی بنا پر اُس ملک پر قبضہ نہیں کرے گا بلکہ رب اُنہیں اُن کی شریر حرکتوں کے باعث تیرے سامنے سے نکال دے گا۔ دوسرے، جو وعدہ اُس نے تیرے باپ دادا ابراہیم، اسحاق اور یعقوب کے ساتھ قَسم کھا کر کیا تھا اُسے پورا ہونا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","چنانچہ جان لے کہ رب تیرا خدا تجھے تیری راستی کے باعث یہ اچھا ملک نہیں دے رہا۔ حقیقت تو یہ ہے کہ تُو ہٹ دھرم قوم ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","یاد رکھ اور کبھی نہ بھول کہ تُو نے ریگستان میں رب اپنے خدا کو کس طرح ناراض کیا۔ مصر سے نکلتے وقت سے لے کر یہاں پہنچنے تک تم رب سے سرکش رہے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","خاص کر حورب یعنی سینا کے دامن میں تم نے رب کو اِتنا غصہ دلایا کہ وہ تمہیں ہلاک کرنے کو تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","اُس وقت مَیں پہاڑ پر چڑھ گیا تھا تاکہ پتھر کی تختیاں یعنی اُس عہد کی تختیاں مل جائیں جو رب نے تمہارے ساتھ باندھا تھا۔ کچھ کھائے پیئے بغیر مَیں 40 دن اور رات وہاں رہا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_10‏","006_9_10‏","DEU","9","10‏","11","جو کچھ رب نے آگ میں سے کہا تھا جب تم پہاڑ کے دامن میں جمع تھے وہی کچھ اُس نے اپنی اُنگلی سے دونوں تختیوں پر لکھ کر مجھے دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","اُس نے مجھ سے کہا، ”فوراً یہاں سے اُتر جا۔ تیری قوم جسے تُو مصر سے نکال لایا بگڑ گئی ہے۔ وہ کتنی جلدی سے میرے احکام سے ہٹ گئے ہیں۔ اُنہوں نے اپنے لئے بُت ڈھال لیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","مَیں نے جان لیا ہے کہ یہ قوم کتنی ضدی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","اب مجھے چھوڑ دے تاکہ مَیں اُنہیں تباہ کر کے اُن کا نام و نشان دنیا میں سے مٹا ڈالوں۔ اُن کی جگہ مَیں تجھ سے ایک قوم بنا لوں گا جو اُن سے بڑی اور طاقت ور ہو گی۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","مَیں مُڑ کر پہاڑ سے اُترا جو اب تک بھڑک رہا تھا۔ میرے ہاتھوں میں عہد کی دونوں تختیاں تھیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","تمہیں دیکھتے ہی مجھے معلوم ہوا کہ تم نے رب اپنے خدا کا گناہ کیا ہے۔ تم نے اپنے لئے بچھڑے کا بُت ڈھال لیا تھا۔ تم کتنی جلدی سے رب کی مقررہ راہ سے ہٹ گئے تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","تب مَیں نے تمہارے دیکھتے دیکھتے دونوں تختیوں کو زمین پر پٹخ کر ٹکڑے ٹکڑے کر دیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","ایک اَور بار مَیں رب کے سامنے منہ کے بل گرا۔ مَیں نے نہ کچھ کھایا، نہ کچھ پیا۔ 40 دن اور رات مَیں تمہارے تمام گناہوں کے باعث اِسی حالت میں رہا۔ کیونکہ جو کچھ تم نے کیا تھا وہ رب کو نہایت بُرا لگا، اِس لئے وہ غضب ناک ہو گیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","وہ تم سے اِتنا ناراض تھا کہ مَیں بہت ڈر گیا۔ یوں لگ رہا تھا کہ وہ تمہیں ہلاک کر دے گا۔ لیکن اِس بار بھی اُس نے میری سن لی۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","مَیں نے ہارون کے لئے بھی دعا کی، کیونکہ رب اُس سے بھی نہایت ناراض تھا اور اُسے ہلاک کر دینا چاہتا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","جو بچھڑا تم نے گناہ کر کے بنایا تھا اُسے مَیں نے جلا دیا، پھر جو کچھ باقی رہ گیا اُسے کچل دیا اور پیس پیس کر پاؤڈر بنا دیا۔ یہ پاؤڈر مَیں نے اُس چشمے میں پھینک دیا جو پہاڑ پر سے بہہ رہا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","تم نے رب کو تبعیرہ، مسّہ اور قبروت ہتاوہ میں بھی غصہ دلایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","قادس برنیع میں بھی ایسا ہی ہوا۔ وہاں سے رب نے تمہیں بھیج کر کہا تھا، ”جاؤ، اُس ملک پر قبضہ کرو جو مَیں نے تمہیں دے دیا ہے۔“ لیکن تم نے سرکش ہو کر رب اپنے خدا کے حکم کی خلاف ورزی کی۔ تم نے اُس پر اعتماد نہ کیا، نہ اُس کی سنی۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","جب سے مَیں تمہیں جانتا ہوں تمہارا رب کے ساتھ رویہ باغیانہ ہی رہا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","مَیں 40 دن اور رات رب کے سامنے زمین پر منہ کے بل رہا، کیونکہ رب نے کہا تھا کہ وہ تمہیں ہلاک کر دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","مَیں نے اُس سے منت کر کے کہا، ”اے رب قادرِ مطلق، اپنی قوم کو تباہ نہ کر۔ وہ تو تیری ہی ملکیت ہے جسے تُو نے فدیہ دے کر اپنی عظیم قدرت سے بچایا اور بڑے اختیار کے ساتھ مصر سے نکال لایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","اپنے خادموں ابراہیم، اسحاق اور یعقوب کو یاد کر، اور اِس قوم کی ضد، شریر حرکتوں اور گناہ پر توجہ نہ دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","ورنہ مصری کہیں گے، ’رب اُنہیں اُس ملک میں لانے کے قابل نہیں تھا جس کا وعدہ اُس نے کیا تھا، بلکہ وہ اُن سے نفرت کرتا تھا۔ ہاں، وہ اُنہیں ہلاک کرنے کے لئے ریگستان میں لے آیا۔‘ ");
INSERT INTO urdgvu_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","وہ تو تیری قوم ہیں، تیری ملکیت جسے تُو اپنی عظیم قدرت اور اختیار سے مصر سے نکال لایا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","اُس وقت رب نے مجھ سے کہا، ”پتھر کی دو اَور تختیاں تراشنا جو پہلی تختیوں کی مانند ہوں۔ اُنہیں لے کر میرے پاس پہاڑ پر چڑھ آ۔ لکڑی کا صندوق بھی بنانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","پھر مَیں اِن تختیوں پر دوبارہ وہی باتیں لکھوں گا جو مَیں اُن تختیوں پر لکھ چکا تھا جو تُو نے توڑ ڈالیں۔ تمہیں اُنہیں صندوق میں محفوظ رکھنا ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","مَیں نے کیکر کی لکڑی کا صندوق بنوایا اور دو تختیاں تراشیں جو پہلی تختیوں کی مانند تھیں۔ پھر مَیں دونوں تختیاں لے کر پہاڑ پر چڑھ گیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","رب نے اُن تختیوں پر دوبارہ وہ دس احکام لکھ دیئے جو وہ پہلی تختیوں پر لکھ چکا تھا۔ (اُن ہی احکام کا اعلان اُس نے پہاڑ پر آگ میں سے کیا تھا جب تم اُس کے دامن میں جمع تھے۔) پھر اُس نے یہ تختیاں میرے سپرد کیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","مَیں لوٹ کر اُترا اور تختیوں کو اُس صندوق میں رکھا جو مَیں نے بنایا تھا۔ وہاں وہ اب تک ہیں۔ سب کچھ ویسا ہی ہوا جیسا رب نے حکم دیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","(اِس کے بعد اسرائیلی بنی یعقان کے کنوؤں سے روانہ ہو کر موسیرہ پہنچے۔ وہاں ہارون فوت ہوا۔ اُسے دفن کرنے کے بعد اُس کا بیٹا اِلی عزر اُس کی جگہ امام بنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","پھر وہ آگے سفر کرتے کرتے جُدجودہ، پھر یُطباتہ پہنچے جہاں نہریں ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","اُن دنوں میں رب نے لاوی کے قبیلے کو الگ کر کے اُسے رب کے عہد کے صندوق کو اُٹھا کر لے جانے، رب کے حضور خدمت کرنے اور اُس کے نام سے برکت دینے کی ذمہ داری دی۔ آج تک یہ اُن کی ذمہ داری رہی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","اِس وجہ سے لاویوں کو دیگر قبیلوں کی طرح نہ حصہ نہ میراث ملی۔ رب تیرا خدا خود اُن کی میراث ہے۔ اُس نے خود اُنہیں یہ فرمایا ہے۔) ");
INSERT INTO urdgvu_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","جب مَیں نے دوسری مرتبہ 40 دن اور رات پہاڑ پر گزارے تو رب نے اِس دفعہ بھی میری سنی اور تجھے ہلاک نہ کرنے پر آمادہ ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","اُس نے کہا، ”جا، قوم کی راہنمائی کر تاکہ وہ جا کر اُس ملک پر قبضہ کریں جس کا وعدہ مَیں نے قَسم کھا کر اُن کے باپ دادا سے کیا تھا۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","اے اسرائیل، اب میری بات سن! رب تیرا خدا تجھ سے کیا تقاضا کرتا ہے؟ صرف یہ کہ تُو اُس کا خوف مانے، اُس کی تمام راہوں پر چلے، اُسے پیار کرے، اپنے پورے دل و جان سے اُس کی خدمت کرے ");
INSERT INTO urdgvu_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","اور اُس کے تمام احکام پر عمل کرے۔ آج مَیں اُنہیں تجھے تیری بہتری کے لئے دے رہا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","پورا آسمان، زمین اور جو کچھ اُس پر ہے، سب کا مالک رب تیرا خدا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","توبھی اُس نے تیرے باپ دادا پر ہی اپنی خاص شفقت کا اظہار کر کے اُن سے محبت کی۔ اور اُس نے تمہیں چن کر دوسری تمام قوموں پر ترجیح دی جیسا کہ آج ظاہر ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","ختنہ اُس کی قوم کا نشان ہے، لیکن دھیان رکھو کہ وہ نہ صرف ظاہری بلکہ باطنی بھی ہو۔ آئندہ اَڑ نہ جاؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","کیونکہ رب تمہارا خدا خداؤں کا خدا اور ربوں کا رب ہے۔ وہ عظیم اور زورآور خدا ہے جس سے سب خوف کھاتے ہیں۔ وہ جانب داری نہیں کرتا اور رشوت نہیں لیتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","وہ یتیموں اور بیواؤں کا انصاف کرتا ہے۔ وہ پردیسی سے پیار کرتا اور اُسے خوراک اور پوشاک مہیا کرتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","تم بھی اُن کے ساتھ محبت سے پیش آؤ، کیونکہ تم بھی مصر میں پردیسی تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","رب اپنے خدا کا خوف مان اور اُس کی خدمت کر۔ اُس سے لپٹا رہ اور اُسی کے نام کی قَسم کھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","وہی تیرا فخر ہے۔ وہ تیرا خدا ہے جس نے وہ تمام عظیم اور ڈراؤنے کام کئے جو تُو نے خود دیکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","جب تیرے باپ دادا مصر گئے تھے تو 70 افراد تھے۔ اور اب رب تیرے خدا نے تجھے ستاروں کی مانند بےشمار بنا دیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","رب اپنے خدا سے پیار کر اور ہمیشہ اُس کے احکام کے مطابق زندگی گزار۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","آج جان لو کہ تمہارے بچوں نے نہیں بلکہ تم ہی نے رب اپنے خدا سے تربیت پائی۔ تم نے اُس کی عظمت، بڑے اختیار اور قدرت کو دیکھا، ");
INSERT INTO urdgvu_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","اور تم اُن معجزوں کے گواہ ہو جو اُس نے مصر کے بادشاہ فرعون اور اُس کے پورے ملک کے سامنے کئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","تم نے دیکھا کہ رب نے کس طرح مصری فوج کو اُس کے گھوڑوں اور رتھوں سمیت بحرِ قُلزم میں غرق کر دیا جب وہ تمہارا تعاقب کر رہے تھے۔ اُس نے اُنہیں یوں تباہ کیا کہ وہ آج تک بحال نہیں ہوئے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","تمہارے بچے نہیں بلکہ تم ہی گواہ ہو کہ یہاں پہنچنے سے پہلے رب نے ریگستان میں تمہاری کس طرح دیکھ بھال کی۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","تم نے اُس کا اِلیاب کے بیٹوں داتن اور ابیرام کے ساتھ سلوک دیکھا جو روبن کے قبیلے کے تھے۔ اُس دن زمین نے خیمہ گاہ کے اندر منہ کھول کر اُنہیں اُن کے گھرانوں، ڈیروں اور تمام جانداروں سمیت ہڑپ کر لیا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","تم نے اپنی ہی آنکھوں سے رب کے یہ تمام عظیم کام دیکھے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","چنانچہ اُن تمام احکام پر عمل کرتے رہو جو مَیں آج تمہیں دے رہا ہوں تاکہ تمہیں وہ طاقت حاصل ہو جو درکار ہو گی جب تم دریائے یردن کو پار کر کے ملک پر قبضہ کرو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","اگر تم فرماں بردار رہو تو دیر تک اُس ملک میں جیتے رہو گے جس کا وعدہ رب نے قَسم کھا کر تمہارے باپ دادا سے کیا تھا اور جس میں دودھ اور شہد کی کثرت ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","کیونکہ یہ ملک مصر کی مانند نہیں ہے جہاں سے تم نکل آئے ہو۔ وہاں کے کھیتوں میں تجھے بیج بو کر بڑی محنت سے اُس کی آب پاشی کرنی پڑتی تھی ");
INSERT INTO urdgvu_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","جبکہ جس ملک پر تم قبضہ کرو گے اُس میں پہاڑ اور وادیاں ہیں جنہیں صرف بارش کا پانی سیراب کرتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","رب تیرا خدا خود اُس ملک کا خیال رکھتا ہے۔ رب تیرے خدا کی آنکھیں سال کے پہلے دن سے لے کر آخر تک متواتر اُس پر لگی رہتی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","چنانچہ اُن احکام کے تابع رہو جو مَیں آج تمہیں دے رہا ہوں۔ رب اپنے خدا سے پیار کرو اور اپنے پورے دل و جان سے اُس کی خدمت کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","پھر وہ خریف اور بہار کی سالانہ بارش وقت پر بھیجے گا۔ اناج، انگور اور زیتون کی فصلیں پکیں گی، اور تُو اُنہیں جمع کر لے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","نیز، اللہ تیری چراگاہوں میں تیرے ریوڑوں کے لئے گھاس مہیا کرے گا، اور تُو کھا کر سیر ہو جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","لیکن خبردار، کہیں تمہیں ورغلایا نہ جائے۔ ایسا نہ ہو کہ تم رب کی راہ سے ہٹ جاؤ اور دیگر معبودوں کو سجدہ کر کے اُن کی خدمت کرو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","ورنہ رب کا غضب تم پر آن پڑے گا، اور وہ ملک میں بارش ہونے نہیں دے گا۔ تمہاری فصلیں نہیں پکیں گی، اور تمہیں جلد ہی اُس اچھے ملک میں سے مٹا دیا جائے گا جو رب تمہیں دے رہا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","چنانچہ میری یہ باتیں اپنے دلوں پر نقش کر لو۔ اُنہیں نشان کے طور پر اور یاددہانی کے لئے اپنے ہاتھوں اور ماتھوں پر لگاؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","اُنہیں اپنے بچوں کو سکھاؤ۔ ہر جگہ اور ہمیشہ اُن کے بارے میں بات کرو، خواہ تُو گھر میں بیٹھا یا راستے پر چلتا ہو، لیٹا ہو یا کھڑا ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","اُنہیں اپنے گھروں کی چوکھٹوں اور اپنے شہروں کے دروازوں پر لکھ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","تاکہ جب تک زمین پر آسمان قائم ہے تم اور تمہاری اولاد اُس ملک میں جیتے رہیں جس کا وعدہ رب نے قَسم کھا کر تمہارے باپ دادا سے کیا تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","احتیاط سے اُن احکام کی پیروی کرو جو مَیں تمہیں دے رہا ہوں۔ رب اپنے خدا سے پیار کرو، اُس کے تمام احکام پر عمل کرو اور اُس کے ساتھ لپٹے رہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","پھر وہ تمہارے آگے آگے یہ تمام قومیں نکال دے گا اور تم ایسی قوموں کی زمینوں پر قبضہ کرو گے جو تم سے بڑی اور طاقت ور ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","تم جہاں بھی قدم رکھو گے وہ تمہارا ہی ہو گا، جنوبی ریگستان سے لے کر لبنان تک، دریائے فرات سے بحیرۂ روم تک۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","کوئی بھی تمہارا سامنا نہیں کر سکے گا۔ تم اُس ملک میں جہاں بھی جاؤ گے وہاں رب تمہارا خدا اپنے وعدے کے مطابق تمہاری دہشت اور خوف پیدا کر دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","آج تم خود فیصلہ کرو۔ کیا تم رب کی برکت یا اُس کی لعنت پانا چاہتے ہو؟ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","اگر تم رب اپنے خدا کے اُن احکام پر عمل کرو جو مَیں آج تمہیں دے رہا ہوں تو وہ تمہیں برکت دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","لیکن اگر تم اُن کے تابع نہ رہو بلکہ میری پیش کردہ راہ سے ہٹ کر دیگر معبودوں کی پیروی کرو تو وہ تم پر لعنت بھیجے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","جب رب تیرا خدا تجھے اُس ملک میں لے جائے گا جس پر تُو قبضہ کرے گا تو لازم ہے کہ گرزیم پہاڑ پر چڑھ کر برکت کا اعلان کرے اور عیبال پہاڑ پر لعنت کا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","یہ دو پہاڑ دریائے یردن کے مغرب میں اُن کنعانیوں کے علاقے میں واقع ہیں جو وادیٔ یردن میں آباد ہیں۔ وہ مغرب کی طرف جِلجال شہر کے سامنے مورِہ کے بلوط کے درختوں کے نزدیک ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","اب تم دریائے یردن کو پار کر کے اُس ملک پر قبضہ کرنے والے ہو جو رب تمہارا خدا تمہیں دے رہا ہے۔ جب تم اُسے اپنا کر اُس میں آباد ہو جاؤ گے ");
INSERT INTO urdgvu_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","تو احتیاط سے اُن تمام احکام پر عمل کرتے رہو جو مَیں آج تمہیں دے رہا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","ذیل میں وہ احکام اور قوانین ہیں جن پر تمہیں دھیان سے عمل کرنا ہو گا جب تم اُس ملک میں آباد ہو گے جو رب تیرے باپ دادا کا خدا تجھے دے رہا ہے تاکہ تُو اُس پر قبضہ کرے۔ ملک میں رہتے ہوئے عمر بھر اُن کے تابع رہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","اُن تمام جگہوں کو برباد کرو جہاں وہ قومیں جنہیں تمہیں نکالنا ہے اپنے دیوتاؤں کی پوجا کرتی ہیں، خواہ وہ اونچے پہاڑوں، پہاڑیوں یا گھنے درختوں کے سائے میں کیوں نہ ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","اُن کی قربان گاہوں کو ڈھا دینا۔ جن پتھروں کی پوجا وہ کرتے ہیں اُنہیں چِکنا چُور کر دینا۔ یسیرت دیوی کے کھمبے جلا دینا۔ اُن کے دیوتاؤں کے مجسمے کاٹ ڈالنا۔ غرض اِن جگہوں سے اُن کا نام و نشان مٹ جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","رب اپنے خدا کی پرستش کرنے کے لئے اُن کے طریقے نہ اپنانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","رب تمہارا خدا قبیلوں میں سے اپنے نام کی سکونت کے لئے ایک جگہ چن لے گا۔ عبادت کے لئے وہاں جایا کرو، ");
INSERT INTO urdgvu_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","اور وہاں اپنی تمام قربانیاں لا کر پیش کرو، خواہ وہ بھسم ہونے والی قربانیاں، ذبح کی قربانیاں، پیداوار کا دسواں حصہ، اُٹھانے والی قربانیاں، مَنت کے ہدیئے، خوشی سے پیش کی گئی قربانیاں یا مویشیوں کے پہلوٹھے کیوں نہ ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","وہاں رب اپنے خدا کے حضور اپنے گھرانوں سمیت کھانا کھا کر اُن کامیابیوں کی خوشی مناؤ جو تجھے رب تیرے خدا کی برکت کے باعث حاصل ہوئی ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","اُس وقت تمہیں وہ نہیں کرنا جو ہم کرتے آئے ہیں۔ آج تک ہر کوئی اپنی مرضی کے مطابق عبادت کرتا ہے، ");
INSERT INTO urdgvu_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","کیونکہ اب تک تم آرام کی اُس جگہ نہیں پہنچے جو تجھے رب تیرے خدا سے میراث میں ملنی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","لیکن جلد ہی تم دریائے یردن کو پار کر کے اُس ملک میں آباد ہو جاؤ گے جو رب تمہارا خدا تمہیں میراث میں دے رہا ہے۔ اُس وقت وہ تمہیں ارد گرد کے دشمنوں سے بچائے رکھے گا، اور تم آرام اور سکون سے زندگی گزار سکو گے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","تب رب تمہارا خدا اپنے نام کی سکونت کے لئے ایک جگہ چن لے گا، اور تمہیں سب کچھ جو مَیں بتاؤں گا وہاں لا کر پیش کرنا ہے، خواہ وہ بھسم ہونے والی قربانیاں، ذبح کی قربانیاں، پیداوار کا دسواں حصہ، اُٹھانے والی قربانیاں یا مَنت کے خاص ہدیئے کیوں نہ ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","وہاں رب کے سامنے تم، تمہارے بیٹے بیٹیاں، تمہارے غلام اور لونڈیاں خوشی منائیں۔ اپنے شہروں میں آباد لاویوں کو بھی اپنی خوشی میں شریک کرو، کیونکہ اُن کے پاس موروثی زمین نہیں ہو گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","خبردار، اپنی بھسم ہونے والی قربانیاں ہر جگہ پر پیش نہ کرنا ");
INSERT INTO urdgvu_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","بلکہ صرف اُس جگہ پر جو رب قبیلوں میں سے چنے گا۔ وہیں سب کچھ یوں منا جس طرح مَیں تجھے بتاتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","لیکن وہ جانور اِس میں شامل نہیں ہیں جو تُو قربانی کے طور پر پیش نہیں کرنا چاہتا بلکہ صرف کھانا چاہتا ہے۔ ایسے جانور تُو آزادی سے اپنے تمام شہروں میں ذبح کر کے اُس برکت کے مطابق کھا سکتا ہے جو رب تیرے خدا نے تجھے دی ہے۔ ایسا گوشت ہرن اور غزال کے گوشت کی مانند ہے یعنی پاک اور ناپاک دونوں ہی اُسے کھا سکتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","لیکن خون نہ کھانا۔ اُسے پانی کی طرح زمین پر اُنڈیل کر ضائع کر دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","جو بھی چیزیں رب کے لئے مخصوص کی گئی ہیں اُنہیں اپنے شہروں میں نہ کھانا مثلاً اناج، انگور کے رس اور زیتون کے تیل کا دسواں حصہ، مویشیوں کے پہلوٹھے، مَنت کے ہدیئے، خوشی سے پیش کی گئی قربانیاں اور اُٹھانے والی قربانیاں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","یہ چیزیں صرف رب کے حضور کھانا یعنی اُس جگہ پر جسے وہ مقدِس کے لئے چنے گا۔ وہیں تُو اپنے بیٹے بیٹیوں، غلاموں، لونڈیوں اور اپنے قبائلی علاقے کے لاویوں کے ساتھ جمع ہو کر خوشی منا کہ رب نے ہماری محنت کو برکت دی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","اپنے ملک میں لاویوں کی ضروریات عمر بھر پوری کرنے کی فکر رکھ۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","جب رب تیرا خدا اپنے وعدے کے مطابق تیری سرحدیں بڑھا دے گا اور تُو گوشت کھانے کی خواہش رکھے گا تو جس طرح جی چاہے گوشت کھا سکے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","اگر تیرا گھر اُس مقدِس سے دُور ہو جسے رب تیرا خدا اپنے نام کی سکونت کے لئے چنے گا تو تُو جس طرح جی چاہے اپنے شہروں میں رب سے ملے ہوئے مویشیوں کو ذبح کر کے کھا سکتا ہے۔ لیکن ایسا ہی کرنا جیسا مَیں نے حکم دیاہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","ایسا گوشت ہرن اور غزال کے گوشت کی مانند ہے یعنی پاک اور ناپاک دونوں ہی اُسے کھا سکتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","البتہ گوشت کے ساتھ خون نہ کھانا، کیونکہ خون جاندار کی جان ہے۔ اُس کی جان گوشت کے ساتھ نہ کھانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","خون نہ کھانا بلکہ اُسے زمین پر اُنڈیل کر ضائع کر دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","اُسے نہ کھانا تاکہ تجھے اور تیری اولاد کو کامیابی حاصل ہو، کیونکہ ایسا کرنے سے تُو رب کی نظر میں صحیح کام کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","لیکن جو چیزیں رب کے لئے مخصوص و مُقدّس ہیں یا جو تُو نے مَنت مان کر اُس کے لئے مخصوص کی ہیں لازم ہے کہ تُو اُنہیں اُس جگہ لے جائے جسے رب مقدِس کے لئے چنے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","وہیں، رب اپنے خدا کی قربان گاہ پر اپنی بھسم ہونے والی قربانیاں گوشت اور خون سمیت چڑھا۔ ذبح کی قربانیوں کا خون قربان گاہ پر اُنڈیل دینا، لیکن اُن کا گوشت تُو کھا سکتا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","جو بھی ہدایات مَیں تجھے دے رہا ہوں اُنہیں احتیاط سے پورا کر۔ پھر تُو اور تیری اولاد خوش حال رہیں گے، کیونکہ تُو وہ کچھ کرے گا جو رب تیرے خدا کی نظر میں اچھا اور درست ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","رب تیرا خدا اُن قوموں کو مٹا دے گا جن کی طرف تُو بڑھ رہا ہے۔ تُو اُنہیں اُن کے ملک سے نکالتا جائے گا اور خود اُس میں آباد ہو جائے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","لیکن خبردار، اُن کے ختم ہونے کے بعد بھی اُن کے دیوتاؤں کے بارے میں معلومات حاصل نہ کر، ورنہ تُو پھنس جائے گا۔ مت کہنا کہ یہ قومیں کس طریقے سے اپنے دیوتاؤں کی پوجا کرتی ہیں؟ ہم بھی ایسا ہی کریں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","ایسا مت کر! یہ قومیں ایسے گھنونے طریقے سے پوجا کرتی ہیں جن سے رب نفرت کرتا ہے۔ وہ اپنے بچوں کو بھی جلا کر اپنے دیوتاؤں کو پیش کرتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","کلام کی جو بھی بات مَیں تمہیں پیش کرتا ہوں اُس کے تابع رہ کر اُس پر عمل کرو۔ نہ کسی بات کا اضافہ کرنا، نہ کوئی بات نکالنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","تیرے درمیان ایسے لوگ اُٹھ کھڑے ہوں گے جو اپنے آپ کو نبی یا خواب دیکھنے والے کہیں گے۔ ہو سکتا ہے کہ وہ کسی الٰہی نشان یا معجزے کا اعلان کریں ");
INSERT INTO urdgvu_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","جو واقعی وجود میں آئے۔ ساتھ ساتھ وہ کہیں، ”آ، ہم دیگر معبودوں کی پوجا کریں، ہم اُن کی خدمت کریں جن سے تُو اب تک واقف نہیں ہے۔“ ");
INSERT INTO urdgvu_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","ایسے لوگوں کی نہ سن۔ اِس سے رب تمہارا خدا تمہیں آزما کر معلوم کر رہا ہے کہ کیا تم واقعی اپنے پورے دل و جان سے اُس سے پیار کرتے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","تمہیں رب اپنے خدا کی پیروی کرنا اور اُسی کا خوف ماننا ہے۔ اُس کے احکام کے مطابق زندگی گزارو، اُس کی سنو، اُس کی خدمت کرو، اُس کے ساتھ لپٹے رہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","ایسے نبیوں یا خواب دیکھنے والوں کو سزائے موت دینا، کیونکہ وہ تجھے رب تمہارے خدا سے بغاوت کرنے پر اُکسانا چاہتے ہیں، اُسی سے جس نے فدیہ دے کر تمہیں مصر کی غلامی سے بچایا اور وہاں سے نکال لایا۔ چونکہ وہ تجھے اُس راہ سے ہٹانا چاہتے ہیں جسے رب تیرے خدا نے تیرے لئے مقرر کیا ہے اِس لئے لازم ہے کہ اُنہیں سزائے موت دی جائے۔ ایسی بُرائی اپنے درمیان سے مٹا دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","ہو سکتا ہے کہ تیرا سگا بھائی، تیرا بیٹا یا بیٹی، تیری بیوی یا تیرا قریبی دوست تجھے چپکے سے ورغلانے کی کوشش کرے کہ آ، ہم جا کر دیگر معبودوں کی پوجا کریں، ایسے دیوتاؤں کی جن سے نہ تُو اور نہ تیرے باپ دادا واقف تھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","خواہ ارد گرد کی یا دُوردراز کی قوموں کے دیوتا ہوں، خواہ دنیا کے ایک سرے کے یا دوسرے سرے کے معبود ہوں، ");
INSERT INTO urdgvu_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","کسی صورت میں اپنی رضامندی کا اظہار نہ کر، نہ اُس کی سن۔ اُس پر رحم نہ کر۔ نہ اُسے بچائے رکھ، نہ اُسے پناہ دے ");
INSERT INTO urdgvu_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","بلکہ اُسے سزائے موت دے۔ اور اُسے سنگسار کرتے وقت پہلے تیرا ہاتھ اُس پر پتھر پھینکے، پھر ہی باقی تمام لوگ حصہ لیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","اُسے ضرور پتھروں سے سزائے موت دینا، کیونکہ اُس نے تجھے رب تیرے خدا سے دُور کرنے کی کوشش کی، اُسی سے جو تجھے مصر کی غلامی سے نکال لایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","پھر تمام اسرائیل یہ سن کر ڈر جائے گا اور آئندہ تیرے درمیان ایسی شریر حرکت کرنے کی جرأت نہیں کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","جب تُو اُن شہروں میں رہنے لگے گا جو رب تیرا خدا تجھے دے رہا ہے تو شاید تجھے خبر مل جائے ");
INSERT INTO urdgvu_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","کہ شریر لوگ تیرے درمیان سے اُبھر آئے ہیں جو اپنے شہر کے باشندوں کو یہ کہہ کر غلط راہ پر لائے ہیں کہ آؤ، ہم دیگر معبودوں کی پوجا کریں، ایسے معبودوں کی جن سے تم واقف نہیں ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","لازم ہے کہ تُو دریافت کر کے اِس کی تفتیش کرے اور خوب معلوم کرے کہ کیا ہوا ہے۔ اگر ثابت ہو جائے کہ یہ گھنونی بات واقعی ہوئی ہے ");
INSERT INTO urdgvu_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","تو پھر لازم ہے کہ تُو شہر کے تمام باشندوں کو ہلاک کرے۔ اُسے رب کے سپرد کر کے سراسر تباہ کرنا، نہ صرف اُس کے لوگ بلکہ اُس کے مویشی بھی۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","شہر کا پورا مالِ غنیمت چوک میں اکٹھا کر۔ پھر پورے شہر کو اُس کے مال سمیت رب کے لئے مخصوص کر کے جلا دینا۔ اُسے دوبارہ کبھی نہ تعمیر کیا جائے بلکہ اُس کے کھنڈرات ہمیشہ تک رہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","پورا شہر رب کے لئے مخصوص کیا گیا ہے، اِس لئے اُس کی کوئی بھی چیز تیرے پاس نہ پائی جائے۔ صرف اِس صورت میں رب کا غضب ٹھنڈا ہو جائے گا، اور وہ تجھ پر رحم کر کے اپنی مہربانی کا اظہار کرے گا اور تیری تعداد بڑھائے گا، جس طرح اُس نے قَسم کھا کر تیرے باپ دادا سے وعدہ کیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","لیکن یہ سب کچھ اِس پر مبنی ہے کہ تُو رب اپنے خدا کی سنے اور اُس کے اُن تمام احکام پر عمل کرے جو مَیں تجھے آج دے رہا ہوں۔ وہی کچھ کر جو اُس کی نظر میں درست ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","تم رب اپنے خدا کے فرزند ہو۔ اپنے آپ کو مُردوں کے سبب سے نہ زخمی کرو، نہ اپنے سر کے سامنے والے بال منڈواؤ۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","کیونکہ تُو رب اپنے خدا کے لئے مخصوص و مُقدّس قوم ہے۔ دنیا کی تمام قوموں میں سے رب نے تجھے ہی چن کر اپنی ملکیت بنا لیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","کوئی بھی مکروہ چیز نہ کھانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","تم بَیل، بھیڑبکری، ");
INSERT INTO urdgvu_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","ہرن، غزال، مِرگ، پہاڑی بکری، مہات، غزالِ افریقہ اور پہاڑی بکری کھا سکتے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","جن کے کُھریا پاؤں بالکل چِرے ہوئے ہیں اور جو جگالی کرتے ہیں اُنہیں کھانے کی اجازت ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","اونٹ، بِجُو یا خرگوش کھانا منع ہے۔ وہ تمہارے لئے ناپاک ہیں، کیونکہ وہ جگالی تو کرتے ہیں لیکن اُن کے کُھر یا پاؤں چِرے ہوئے نہیں ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","سؤر نہ کھانا۔ وہ تمہارے لئے ناپاک ہے، کیونکہ اُس کے کُھر تو چِرے ہوئے ہیں لیکن وہ جگالی نہیں کرتا۔ نہ اُن کا گوشت کھانا، نہ اُن کی لاشوں کو چھونا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","پانی میں رہنے والے جانور کھانے کے لئے جائز ہیں اگر اُن کے پَر اور چھلکے ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","لیکن جن کے پَر یا چھلکے نہیں ہیں وہ تمہارے لئے ناپاک ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","تم ہر پاک پرندہ کھا سکتے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","لیکن ذیل کے پرندے کھانا منع ہے: عقاب، دڑھیَل گِدھ، کالا گِدھ، ");
INSERT INTO urdgvu_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","لال چیل، کالی چیل، ہر قسم کا گِدھ، ");
INSERT INTO urdgvu_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","ہر قسم کا کوّا، ");
INSERT INTO urdgvu_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","عقابی اُلّو، چھوٹے کان والا اُلّو، بڑے کان والا اُلّو، ہر قسم کا باز، ");
INSERT INTO urdgvu_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","چھوٹا اُلّو، چنگھاڑنے والا اُلّو، سفید اُلّو، ");
INSERT INTO urdgvu_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","دشتی اُلّو، مصری گِدھ، قوق، ");
INSERT INTO urdgvu_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","لق لق، ہر قسم کا بُوتیمار، ہُد ہُد اور چمگادڑ۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","تمام پَر رکھنے والے کیڑے تمہارے لئے ناپاک ہیں۔ اُنہیں کھانا منع ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","لیکن تم ہر پاک پرندہ کھا سکتے ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","جو جانور خود بہ خود مر جائے اُسے نہ کھانا۔ تُو اُسے اپنی آبادی میں رہنے والے کسی پردیسی کو دے یا کسی اجنبی کو بیچ سکتا ہے اور وہ اُسے کھا سکتا ہے۔ لیکن تُو اُسے مت کھانا، کیونکہ تُو رب اپنے خدا کے لئے مخصوص و مُقدّس قوم ہے۔ بکری کے بچے کو اُس کی ماں کے دودھ میں پکانا منع ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","لازم ہے کہ تُو ہر سال اپنے کھیتوں کی پیداوار کا دسواں حصہ رب کے لئے الگ کرے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","اِس کے لئے اپنا اناج، انگور کا رس، زیتون کا تیل اور مویشی کے پہلوٹھے رب اپنے خدا کے حضور لے آنا یعنی اُس جگہ جو وہ اپنے نام کی سکونت کے لئے چنے گا۔ وہاں یہ چیزیں قربان کر کے کھا تاکہ تُو عمر بھر رب اپنے خدا کا خوف ماننا سیکھے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","لیکن ہو سکتا ہے کہ جو جگہ رب تیرا خدا اپنے نام کی سکونت کے لئے چنے گا وہ تیرے گھر سے حد سے زیادہ دُور ہو اور رب تیرے خدا کی برکت کے باعث مذکورہ دسواں حصہ اِتنا زیادہ ہو کہ تُو اُسے مقدِس تک نہیں پہنچا سکتا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","اِس صورت میں اُسے بیچ کر اُس کے پیسے اُس جگہ لے جا جو رب تیرا خدا اپنے نام کی سکونت کے لئے چنے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","وہاں پہنچ کر اُن پیسوں سے جو جی چاہے خریدنا، خواہ گائےبَیل، بھیڑبکری، مَے یا مَے جیسی کوئی اَور چیز کیوں نہ ہو۔ پھر اپنے گھرانے کے ساتھ مل کر رب اپنے خدا کے حضور یہ چیزیں کھانا اور خوشی منانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","ایسے موقعوں پر اُن لاویوں کا خیال رکھنا جو تیرے قبائلی علاقے میں رہتے ہیں، کیونکہ اُنہیں میراث میں زمین نہیں ملے گی۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","ہر تیسرے سال اپنی پیداوار کا دسواں حصہ اپنے شہروں میں جمع کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","اُسے لاویوں کو دینا جن کے پاس موروثی زمین نہیں ہے، نیز اپنے شہروں میں آباد پردیسیوں، یتیموں اور بیواؤں کو دینا۔ وہ آئیں اور کھانا کھا کر سیر ہو جائیں تاکہ رب تیرا خدا تیرے ہر کام میں برکت دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","ہر سات سال کے بعد ایک دوسرے کے قرضے معاف کر دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","اُس وقت جس نے بھی کسی اسرائیلی بھائی کو قرض دیا ہے وہ اُسے منسوخ کرے۔ وہ اپنے پڑوسی یا بھائی کو پیسے واپس کرنے پر مجبور نہ کرے، کیونکہ رب کی تعظیم میں قرض معاف کرنے کے سال کا اعلان کیا گیا ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","اِس سال میں تُو صرف غیرملکی قرض داروں کو پیسے واپس کرنے پر مجبور کر سکتا ہے۔ اپنے اسرائیلی بھائی کے تمام قرض معاف کر دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","تیرے درمیان کوئی بھی غریب نہیں ہونا چاہئے، کیونکہ جب تُو اُس ملک میں رہے گا جو رب تیرا خدا تجھے میراث میں دینے والا ہے تو وہ تجھے بہت برکت دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","لیکن شرط یہ ہے کہ تُو پورے طور پر اُس کی سنے اور احتیاط سے اُس کے اُن تمام احکام پر عمل کرے جو مَیں تجھے آج دے رہا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","پھر رب تمہارا خدا تجھے اپنے وعدے کے مطابق برکت دے گا۔ تُو کسی بھی قوم سے اُدھار نہیں لے گا بلکہ بہت سی قوموں کو اُدھار دے گا۔ کوئی بھی قوم تجھ پر حکومت نہیں کرے گی بلکہ تُو بہت سی قوموں پر حکومت کرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","جب تُو اُس ملک میں آباد ہو گا جو رب تیرا خدا تجھے دینے والا ہے تو اپنے درمیان رہنے والے غریب بھائی سے سخت سلوک نہ کرنا، نہ کنجوس ہونا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","کھلے دل سے اُس کی مدد کر۔ جتنی اُسے ضرورت ہے اُسے اُدھار کے طور پر دے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","خبردار، ایسا مت سوچ کہ قرض معاف کرنے کا سال قریب ہے، اِس لئے مَیں اُسے کچھ نہیں دوں گا۔ اگر تُو ایسی شریر بات اپنے دل میں سوچتے ہوئے ضرورت مند بھائی کو قرض دینے سے انکار کرے اور وہ رب کے سامنے تیری شکایت کرے تو تُو قصوروار ٹھہرے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","اُسے ضرور کچھ دے بلکہ خوشی سے دے۔ پھر رب تیرا خدا تیرے ہر کام میں برکت دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","ملک میں ہمیشہ غریب اور ضرورت مند لوگ پائے جائیں گے، اِس لئے مَیں تجھے حکم دیتا ہوں کہ کھلے دل سے اپنے غریب اور ضرورت مند بھائیوں کی مدد کر۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","اگر کوئی اسرائیلی بھائی یا بہن اپنے آپ کو بیچ کر تیرا غلام بن جائے تو وہ چھ سال تیری خدمت کرے۔ لیکن لازم ہے کہ ساتویں سال اُسے آزاد کر دیا جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","آزاد کرتے وقت اُسے خالی ہاتھ فارغ نہ کرنا ");
INSERT INTO urdgvu_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","بلکہ اپنی بھیڑبکریوں، اناج، تیل اور مَے سے اُسے فیاضی سے کچھ دے، یعنی اُن چیزوں میں سے جن سے رب تیرے خدا نے تجھے برکت دی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","یاد رکھ کہ تُو بھی مصر میں غلام تھا اور کہ رب تیرے خدا نے فدیہ دے کر تجھے چھڑایا۔ اِسی لئے مَیں آج تجھے یہ حکم دیتا ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","لیکن ممکن ہے کہ تیرا غلام تجھے چھوڑنا نہ چاہے، کیونکہ وہ تجھ سے اور تیرے خاندان سے محبت رکھتا ہے، اور وہ تیرے پاس رہ کر خوش حال ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","اِس صورت میں اُسے دروازے کے پاس لے جا اور اُس کے کان کی لَو چوکھٹ کے ساتھ لگا کر اُسے سُتالی یعنی تیز اوزار سے چھید دے۔ تب وہ زندگی بھر تیرا غلام بنا رہے گا۔ اپنی لونڈی کے ساتھ بھی ایسا ہی کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","اگر غلام تجھے چھ سال کے بعد چھوڑنا چاہے تو بُرا نہ ماننا۔ آخر اگر اُس کی جگہ کوئی اَور وہی کام تنخواہ کے لئے کرتا تو تیرے اخراجات دُگنے ہوتے۔ اُسے آزاد کرنا تو رب تیرا خدا تیرے ہر کام میں برکت دے گا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","اپنی گائیوں اور بھیڑبکریوں کے نرپہلوٹھے رب اپنے خدا کے لئے مخصوص کرنا۔ نہ گائے کے پہلوٹھے کو کام کے لئے استعمال کرنا، نہ بھیڑ کے پہلوٹھے کے بال کترنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","ہر سال ایسے بچے اُس جگہ لے جا جو رب اپنے مقدِس کے لئے چنے گا۔ وہاں اُنہیں رب اپنے خدا کے حضور اپنے پورے خاندان سمیت کھانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","اگر ایسے جانور میں کوئی خرابی ہو، وہ اندھا یا لنگڑا ہو یا اُس میں کوئی اَور نقص ہو تو اُسے رب اپنے خدا کے لئے قربان نہ کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","ایسے جانور تُو گھر میں ذبح کر کے کھا سکتا ہے۔ وہ ہرن اور غزال کی مانند ہیں جنہیں تُو کھا تو سکتا ہے لیکن قربانی کے طور پر پیش نہیں کر سکتا۔ پاک اور ناپاک شخص دونوں اُسے کھا سکتے ہیں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","لیکن خون نہ کھانا۔ اُسے پانی کی طرح زمین پر اُنڈیل کر ضائع کر دینا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","ابیب کے مہینے میں رب اپنے خدا کی تعظیم میں فسح کی عید منانا، کیونکہ اِس مہینے میں وہ تجھے رات کے وقت مصر سے نکال لایا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","اُس جگہ جمع ہو جا جو رب اپنے نام کی سکونت کے لئے چنے گا۔ اُسے قربانی کے لئے بھیڑبکریاں یا گائےبَیل پیش کرنا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","گوشت کے ساتھ بےخمیری روٹی کھانا۔ سات دن تک یہی روٹی کھا، بالکل اُسی طرح جس طرح تُو نے کیا جب جلدی جلدی مصر سے نکلا۔ مصیبت کی یہ روٹی اِس لئے کھا تاکہ وہ دن تیرے جیتے جی یاد رہے جب تُو مصر سے روانہ ہوا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","لازم ہے کہ عید کے ہفتے کے دوران تیرے پورے ملک میں خمیر نہ پایا جائے۔ جو قربانی تُو عید کے پہلے دن کی شام کو پیش کرے اُس کا گوشت اُسی وقت کھا لے۔ اگلی صبح تک کچھ باقی نہ رہ جائے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","فسح کی قربانی کسی بھی شہر میں جو رب تیرا خدا تجھے دے گا نہ چڑھانا ");
INSERT INTO urdgvu_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","بلکہ صرف اُس جگہ جو وہ اپنے نام کی سکونت کے لئے چنے گا۔ مصر سے نکلتے وقت کی طرح قربانی کے جانور کو سورج ڈوبتے وقت ذبح کر۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","پھر اُسے بھون کر اُس جگہ کھانا جو رب تیرا خدا چنے گا۔ اگلی صبح اپنے گھر واپس چلا جا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","عید کے پہلے چھ دن بےخمیری روٹی کھاتا رہ۔ ساتویں دن کام نہ کرنا بلکہ رب اپنے خدا کی عبادت کے لئے جمع ہو جانا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","جب اناج کی فصل کی کٹائی شروع ہو گی تو پہلے دن کے سات ہفتے بعد ");
INSERT INTO urdgvu_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","فصل کی کٹائی کی عید منانا۔ رب اپنے خدا کو اُتنا پیش کر جتنا جی چاہے۔ وہ اُس برکت کے مطابق ہو جو اُس نے تجھے دی ہے۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","اِس کے لئے بھی اُس جگہ جمع ہو جا جو رب اپنے نام کی سکونت کے لئے چنے گا۔ وہاں اُس کے حضور خوشی منا۔ تیرے بال بچے، تیرے غلام اور لونڈیاں اور تیرے شہروں میں رہنے والے لاوی، پردیسی، یتیم اور بیوائیں سب تیری خوشی میں شریک ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","اِن احکام پر ضرور عمل کرنا اور مت بھولنا کہ تُو مصر میں غلام تھا۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","اناج گاہنے اور انگور کا رس نکالنے کے بعد جھونپڑیوں کی عید منانا جس کا دورانیہ سات دن ہو۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","عید کے موقع پر خوشی منانا۔ تیرے بال بچے، تیرے غلام اور لونڈیاں اور تیرے شہروں میں بسنے والے لاوی، پردیسی، یتیم اور بیوائیں سب تیری خوشی میں شریک ہوں۔ ");
INSERT INTO urdgvu_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","جو جگہ رب تیرا خدا مقدِس کے لئے چنے گا وہاں اُس کی تعظیم میں سات دن تک یہ عید منانا۔ کیونکہ رب تیرا خدا تیری تمام فصلوں اور محنت کو برکت دے گا، اِس لئے خوب خوشی منانا۔ ");
INSERT INTO