﻿USE sofia;
DROP TABLE IF EXISTS sofia.urdgvr_vpl;
CREATE TABLE urdgvr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES urdgvr_vpl WRITE;
INSERT INTO urdgvr_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ibtidā meṅ Allāh ne āsmān aur zamīn ko banāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Abhī tak zamīn wīrān aur ḳhālī thī. Wuh gahre pānī se ḍhakī huī thī jis ke ūpar andherā hī andherā thā. Allāh kā Rūh pānī ke ūpar manḍlā rahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Phir Allāh ne kahā, “Raushnī ho jāe” to raushnī paidā ho gaī. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Allāh ne dekhā ki raushnī achchhī hai, aur us ne raushnī ko tārīkī se alag kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Allāh ne raushnī ko din kā nām diyā aur tārīkī ko rāt kā. Shām huī, phir subah. Yoṅ pahlā din guzar gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Allāh ne kahā, “Pānī ke darmiyān ek aisā gumbad paidā ho jāe jis se nichlā pānī ūpar ke pānī se alag ho jāe.” ");
INSERT INTO urdgvr_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Aisā hī huā. Allāh ne ek aisā gumbad banāyā jis se nichlā pānī ūpar ke pānī se alag ho gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Allāh ne gumbad ko āsmān kā nām diyā. Shām huī, phir subah. Yoṅ dūsrā din guzar gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Allāh ne kahā, “Jo pānī āsmān ke nīche hai wuh ek jagah jamā ho jāe tāki dūsrī taraf ḳhushk jagah nazar āe.” Aisā hī huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Allāh ne ḳhushk jagah ko zamīn kā nām diyā aur jamāshudā pānī ko samundar kā. Aur Allāh ne dekhā ki yih achchhā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Phir us ne kahā, “Zamīn hariyāwal paidā kare, aise paude jo bīj rakhte hoṅ aur aise daraḳht jin ke phal apnī apnī qism ke bīj rakhte hoṅ.” Aisā hī huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Zamīn ne hariyāwal paidā kī, aise paude jo apnī apnī qism ke bīj rakhte aur aise daraḳht jin ke phal apnī apnī qism ke bīj rakhte the. Allāh ne dekhā ki yih achchhā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Shām huī, phir subah. Yoṅ tīsrā din guzar gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Allāh ne kahā, “Āsmān par raushniyāṅ paidā ho jāeṅ tāki din aur rāt meṅ imtiyāz ho aur isī tarah muḳhtalif mausamoṅ, dinoṅ aur sāloṅ meṅ bhī. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Āsmān kī yih raushniyāṅ duniyā ko raushan kareṅ.” Aisā hī huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Allāh ne do baṛī raushniyāṅ banāīṅ, sūraj jo baṛā thā din par hukūmat karne ko aur chāṅd jo chhoṭā thā rāt par. In ke alāwā us ne sitāroṅ ko bhī banāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Us ne unheṅ āsmān par rakhā tāki wuh duniyā ko raushan kareṅ, ");
INSERT INTO urdgvr_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","din aur rāt par hukūmat kareṅ aur raushnī aur tārīkī meṅ imtiyāz paidā kareṅ. Allāh ne dekhā ki yih achchhā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Shām huī, phir subah. Yoṅ chauthā din guzar gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Allāh ne kahā, “Pānī ābī jāndāroṅ se bhar jāe aur fizā meṅ parinde uṛte phireṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Allāh ne baṛe baṛe samundarī jānwar banāe, pānī kī tamām dīgar maḳhlūqāt aur har qism ke par rakhne wāle jāndār bhī banāe. Allāh ne dekhā ki yih achchhā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Us ne unheṅ barkat dī aur kahā, “Phalo-phūlo aur tādād meṅ baṛhte jāo. Samundar tum se bhar jāe. Isī tarah parinde zamīn par tādād meṅ baṛh jāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Shām huī, phir subah. Yoṅ pāṅchwāṅ din guzar gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Allāh ne kahā, “Zamīn har qism ke jāndār paidā kare: maweshī, reṅgne wāle aur janglī jānwar.” Aisā hī huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Allāh ne har qism ke maweshī, reṅgne wāle aur janglī jānwar banāe. Us ne dekhā ki yih achchhā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Allāh ne kahā, “Āo ab ham insān ko apnī sūrat par banāeṅ, wuh ham se mushābahat rakhe. Wuh tamām jānwaroṅ par hukūmat kare, samundar kī machhliyoṅ par, hawā ke parindoṅ par, maweshiyoṅ par, janglī jānwaroṅ par aur zamīn par ke tamām reṅgne wāle jāndāroṅ par.” ");
INSERT INTO urdgvr_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Yoṅ Allāh ne insān ko apnī sūrat par banāyā, Allāh kī sūrat par. Us ne unheṅ mard aur aurat banāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Allāh ne unheṅ barkat dī aur kahā, “Phalo-phūlo aur tādād meṅ baṛhte jāo. Duniyā tum se bhar jāe aur tum us par iḳhtiyār rakho. Samundar kī machhliyoṅ, hawā ke parindoṅ aur zamīn par ke tamām reṅgne wāle jāndāroṅ par hukūmat karo.” ");
INSERT INTO urdgvr_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Allāh ne un se mazīd kahā, “Tamām bījdār paude aur phaldār daraḳht tumhāre hī haiṅ. Maiṅ unheṅ tum ko khāne ke lie detā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Is tarah maiṅ tamām jānwaroṅ ko khāne ke lie hariyālī detā hūṅ. Jis meṅ bhī jān hai wuh yih khā saktā hai, ḳhāh wuh zamīn par chalne-phirne wālā jānwar, hawā kā parindā yā zamīn par reṅgne wālā kyoṅ na ho.” Aisā hī huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Allāh ne sab par nazar kī to dekhā ki wuh bahut achchhā ban gayā hai. Shām huī, phir subah. Chhaṭā din guzar gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Yoṅ āsmān-o-zamīn aur un kī tamām chīzoṅ kī taḳhlīq mukammal huī. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Sātweṅ din Allāh kā sārā kām takmīl ko pahuṅchā. Is se fāriġh ho kar us ne ārām kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Allāh ne sātweṅ din ko barkat dī aur use maḳhsūs-o-muqaddas kiyā. Kyoṅki us din us ne apne tamām taḳhlīqī kām se fāriġh ho kar ārām kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Yih āsmān-o-zamīn kī taḳhlīq kā bayān hai. Jab Rab Ḳhudā ne āsmān-o-zamīn ko banāyā ");
INSERT INTO urdgvr_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","to shurū meṅ jhāṛiyāṅ aur paude nahīṅ ugte the. Wajah yih thī ki Allāh ne bārish kā intazām nahīṅ kiyā thā. Aur abhī insān bhī paidā nahīṅ huā thā ki zamīn kī khetībāṛī kartā. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Is kī bajāe zamīn meṅ se dhund uṭh kar us kī pūrī satah ko tar kartī thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Phir Rab Ḳhudā ne zamīn se miṭṭī le kar insān ko tashkīl diyā aur us ke nathnoṅ meṅ zindagī kā dam phūṅkā to wuh jītī jān huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Rab Ḳhudā ne mashriq meṅ Mulk-e-Adan meṅ ek bāġh lagāyā. Us meṅ us ne us ādmī ko rakhā jise us ne banāyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Rab Ḳhudā ke hukm par zamīn meṅ se tarah tarah ke daraḳht phūṭ nikle, aise daraḳht jo deḳhne meṅ dilkash aur khāne ke lie achchhe the. Bāġh ke bīch meṅ do daraḳht the. Ek kā phal zindagī baḳhshtā thā jabki dūsre kā phal achchhe aur bure kī pahchān dilātā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Adan meṅ se ek dariyā nikal kar bāġh kī ābpāshī kartā thā. Wahāṅ se bah kar wuh chār shāḳhoṅ meṅ taqsīm huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","Pahlī shāḳh kā nām Fīsūn hai. Wuh Mulk-e-Hawīlā ko ghere hue bahtī hai jahāṅ ḳhālis sonā, gūgal kā gūṅd aur aqīq-e-ahmar pāe jāte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Dūsrī kā nām Jaihūn hai jo Kūsh ko ghere hue bahtī hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Tīsrī kā nām Dijlā hai jo Asūr ke mashriq ko jātī hai aur chauthī kā nām Furāt hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Rab Ḳhudā ne pahle ādmī ko Bāġh-e-Adan meṅ rakhā tāki wuh us kī bāġhbānī aur hifāzat kare. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Lekin Rab Ḳhudā ne use āgāh kiyā, “Tujhe har daraḳht kā phal khāne kī ijāzat hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Lekin jis daraḳht kā phal achchhe aur bure kī pahchān dilātā hai us kā phal khānā manā hai. Agar use khāe to yaqīnan maregā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Rab Ḳhudā ne kahā, “Achchhā nahīṅ ki ādmī akelā rahe. Maiṅ us ke lie ek munāsib madadgār banātā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Rab Ḳhudā ne miṭṭī se zamīn par chalne-phirne wāle jānwar aur hawā ke parinde banāe the. Ab wuh unheṅ ādmī ke pās le āyā tāki mālūm ho jāe ki wuh un ke kyā kyā nām rakhegā. Yoṅ har jānwar ko Ādam kī taraf se nām mil gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ādmī ne tamām maweshiyoṅ, parindoṅ aur zamīn par phirne wāle jāndāroṅ ke nām rakhe. Lekin use apne lie koī munāsib madadgār na milā. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tab Rab Ḳhudā ne use sulā diyā. Jab wuh gahrī nīnd so rahā thā to us ne us kī pasliyoṅ meṅ se ek nikāl kar us kī jagah gosht bhar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Paslī se us ne aurat banāī aur use ādmī ke pās le āyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Use dekh kar wuh pukār uṭhā, “Wāh! Yih to mujh jaisī hī hai, merī haḍḍiyoṅ meṅ se haḍḍī aur mere gosht meṅ se gosht hai. Is kā nām Nārī rakhā jāe kyoṅki wuh nar se nikālī gaī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Is lie mard apne māṅ-bāp ko chhoṛ kar apnī bīwī ke sāth paiwast ho jātā hai, aur wuh donoṅ ek ho jāte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Donoṅ, ādmī aur aurat nange the, lekin yih un ke lie sharm kā bāis nahīṅ thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Sāṅp zamīn par chalne-phirne wāle un tamām jānwaroṅ se zyādā chālāk thā jin ko Rab Ḳhudā ne banāyā thā. Us ne aurat se pūchhā, “Kyā Allāh ne wāqaī kahā ki bāġh ke kisī bhī daraḳht kā phal na khānā?” ");
INSERT INTO urdgvr_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Aurat ne jawāb diyā, “Hargiz nahīṅ. Ham bāġh kā har phal khā sakte haiṅ, ");
INSERT INTO urdgvr_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","sirf us daraḳht ke phal se gurez karnā hai jo bāġh ke bīch meṅ hai. Allāh ne kahā ki us kā phal na khāo balki use chhūnā bhī nahīṅ, warnā tum yaqīnan mar jāoge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Sāṅp ne aurat se kahā, “Tum hargiz na maroge, ");
INSERT INTO urdgvr_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","balki Allāh jāntā hai ki jab tum us kā phal khāoge to tumhārī āṅkheṅ khul jāeṅgī aur tum Allāh kī mānind ho jāoge, tum jo bhī achchhā aur burā hai use jān loge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Aurat ne daraḳht par ġhaur kiyā ki khāne ke lie achchhā aur deḳhne meṅ bhī dilkash hai. Sab se dilfareb bāt yih ki us se samajh hāsil ho saktī hai! Yih soch kar us ne us kā phal le kar use khāyā. Phir us ne apne shauhar ko bhī de diyā, kyoṅki wuh us ke sāth thā. Us ne bhī khā liyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Lekin khāte hī un kī āṅkheṅ khul gaīṅ aur un ko mālūm huā ki ham nange haiṅ. Chunāṅche unhoṅ ne anjīr ke patte sī kar lungiyāṅ banā līṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Shām ke waqt jab ṭhanḍī hawā chalne lagī to unhoṅ ne Rab Ḳhudā ko bāġh meṅ chalte phirte sunā. Wuh ḍar ke māre daraḳhtoṅ ke pīchhe chhup gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Rab Ḳhudā ne pukār kar kahā, “Ādam, tū kahāṅ hai?” ");
INSERT INTO urdgvr_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ādam ne jawāb diyā, “Maiṅ ne tujhe bāġh meṅ chalte hue sunā to ḍar gayā, kyoṅki maiṅ nangā hūṅ. Is lie maiṅ chhup gayā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Us ne pūchhā, “Kis ne tujhe batāyā ki tū nangā hai? Kyā tū ne us daraḳht kā phal khāyā hai jise khāne se maiṅ ne manā kiyā thā?” ");
INSERT INTO urdgvr_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ādam ne kahā, “Jo aurat tū ne mere sāth rahne ke lie dī hai us ne mujhe phal diyā. Is lie maiṅ ne khā liyā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ab Rab Ḳhudā aurat se muḳhātib huā, “Tū ne yih kyoṅ kiyā?” Aurat ne jawāb diyā, “Sāṅp ne mujhe bahkāyā to maiṅ ne khāyā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Rab Ḳhudā ne sāṅp se kahā, “Chūṅki tū ne yih kiyā, is lie tū tamām maweshiyoṅ aur janglī jānwaroṅ meṅ lānatī hai. Tū umr-bhar peṭ ke bal reṅgegā aur ḳhāk chāṭegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Maiṅ tere aur aurat ke darmiyān dushmanī paidā karūṅga. Us kī aulād terī aulād kī dushman hogī. Wuh tere sar ko kuchal ḍālegī jabki tū us kī eṛī par kāṭegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Phir Rab Ḳhudā aurat se muḳhātib huā aur kahā, “Jab tū ummīd se hogī to maiṅ terī taklīf ko bahut baṛhāūṅgā. Jab tere bachche hoṅge to tū shadīd dard kā shikār hogī. Tū apne shauhar kī tamannā karegī lekin wuh tujh par hukūmat karegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ādam se us ne kahā, “Tū ne apnī bīwī kī bāt mānī aur us daraḳht kā phal khāyā jise khāne se maiṅ ne manā kiyā thā. Is lie tere sabab se zamīn par lānat hai. Us se ḳhurāk hāsil karne ke lie tujhe umr-bhar mehnat-mashaqqat karnī paṛegī. ");
INSERT INTO urdgvr_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tere lie wuh ḳhārdār paude aur ūṅṭkaṭāre paidā karegī, hālāṅki tū us se apnī ḳhurāk bhī hāsil karegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Pasīnā bahā bahā kar tujhe roṭī kamāne ke lie bhāg-dauṛ karnī paṛegī. Aur yih silsilā maut tak jārī rahegā. Tū mehnat karte karte dubārā zamīn meṅ lauṭ jāegā, kyoṅki tū usī se liyā gayā hai. Tū ḳhāk hai aur dubārā ḳhāk meṅ mil jāegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ādam ne apnī bīwī kā nām Hawwā yānī Zindagī rakhā, kyoṅki bād meṅ wuh tamām zindoṅ kī māṅ ban gaī. ");
INSERT INTO urdgvr_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Rab Ḳhudā ne Ādam aur us kī bīwī ke lie khāloṅ se libās banā kar unheṅ pahnāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Us ne kahā, “Insān hamārī mānind ho gayā hai, wuh achchhe aur bure kā ilm rakhtā hai. Ab aisā na ho ki wuh hāth baṛhā kar zindagī baḳhshne wāle daraḳht ke phal se le aur us se khā kar hameshā tak zindā rahe.” ");
INSERT INTO urdgvr_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Is lie Rab Ḳhudā ne use Bāġh-e-Adan se nikāl kar us zamīn kī khetībāṛī karne kī zimmedārī dī jis meṅ se use liyā gayā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Insān ko ḳhārij karne ke bād us ne Bāġh-e-Adan ke mashriq meṅ karūbī farishte khaṛe kie aur sāth sāth ek ātishī talwār rakhī jo idhar-udhar ghūmtī thī tāki us rāste kī hifāzat kare jo zindagī baḳhshne wāle daraḳht tak pahuṅchātā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ādam Hawwā se hambistar huā to un kā pahlā beṭā Qābīl paidā huā. Hawwā ne kahā, “Rab kī madad se maiṅ ne ek mard hāsil kiyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Bād meṅ Qābīl kā bhāī Hābīl paidā huā. Hābīl bheṛ-bakriyoṅ kā charwāhā ban gayā jabki Qābīl khetībāṛī karne lagā. ");
INSERT INTO urdgvr_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Kuchh der ke bād Qābīl ne Rab ko apnī fasloṅ meṅ se kuchh pesh kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Hābīl ne bhī nazarānā pesh kiyā, lekin us ne apnī bheṛ-bakriyoṅ ke kuchh pahlauṭhe un kī charbī samet chaṛhāe. Hābīl kā nazarānā Rab ko pasand āyā, ");
INSERT INTO urdgvr_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","magar Qābīl kā nazarānā manzūr na huā. Yih dekh kar Qābīl baṛe ġhusse meṅ ā gayā, aur us kā muṅh bigaṛ gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Rab ne pūchhā, “Tū ġhusse meṅ kyoṅ ā gayā hai? Terā muṅh kyoṅ laṭkā huā hai? ");
INSERT INTO urdgvr_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kyā agar tū achchhī nīyat rakhtā hai to apnī nazar uṭhā kar merī taraf nahīṅ dekh sakegā? Lekin agar achchhī nīyat nahīṅ rakhtā to ḳhabardār! Gunāh darwāze par dabkā baiṭhā hai aur tujhe chāhtā hai. Lekin terā farz hai ki us par ġhālib āe.” ");
INSERT INTO urdgvr_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ek din Qābīl ne apne bhāī se kahā, “Āo, ham bāhar khule maidān meṅ chaleṅ.” Aur jab wuh khule maidān meṅ the to Qābīl ne apne bhāī Hābīl par hamlā karke use mār ḍālā. ");
INSERT INTO urdgvr_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Tab Rab ne Qābīl se pūchhā, “Terā bhāī Hābīl kahāṅ hai?” Qābīl ne jawāb diyā, “Mujhe kyā patā! Kyā apne bhāī kī dekh-bhāl karnā merī zimmedārī hai?” ");
INSERT INTO urdgvr_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Rab ne kahā, “Tū ne kyā kiyā hai? Tere bhāī kā ḳhūn zamīn meṅ se pukār kar mujh se fariyād kar rahā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Is lie tujh par lānat hai aur zamīn ne tujhe radd kiyā hai, kyoṅki zamīn ko muṅh khol kar tere hāth se qatl kie hue bhāī kā ḳhūn pīnā paṛā. ");
INSERT INTO urdgvr_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ab se jab tū khetībāṛī karegā to zamīn apnī paidāwār dene se inkār karegī. Tū mafrūr ho kar mārā mārā phiregā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Qābīl ne kahā, “Merī sazā nihāyat saḳht hai. Maiṅ ise bardāsht nahīṅ kar pāūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Āj tū mujhe zamīn kī satah se bhagā rahā hai aur mujhe tere huzūr se bhī chhup jānā hai. Maiṅ mafrūr kī haisiyat se mārā mārā phirtā rahūṅgā, is lie jis ko bhī patā chalegā ki maiṅ kahāṅ hūṅ wuh mujhe qatl kar ḍālegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Lekin Rab ne us se kahā, “Hargiz nahīṅ. Jo Qābīl ko qatl kare us se sāt gunā badlā liyā jāegā.” Phir Rab ne us par ek nishān lagāyā tāki jo bhī Qābīl ko dekhe wuh use qatl na kar de. ");
INSERT INTO urdgvr_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Is ke bād Qābīl Rab ke huzūr se chalā gayā aur Adan ke mashriq kī taraf Nod ke ilāqe meṅ jā basā. ");
INSERT INTO urdgvr_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Qābīl kī bīwī hāmilā huī. Beṭā paidā huā jis kā nām Hanūk rakhā gayā. Qābīl ne ek shahr tāmīr kiyā aur apne beṭe kī ḳhushī meṅ us kā nām Hanūk rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Hanūk kā beṭā Īrād thā, Īrād kā beṭā Mahūyāel, Mahūyāel kā beṭā Matūsāel aur Matūsāel kā beṭā Lamak thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamak kī do bīwiyāṅ thīṅ, Adā aur Zillā. ");
INSERT INTO urdgvr_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adā kā beṭā Yābal thā. Us kī nasl ke log ḳhaimoṅ meṅ rahte aur maweshī pālte the. ");
INSERT INTO urdgvr_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yābal kā bhāī Yūbal thā. Us kī nasl ke log sarod aur bāṅsrī bajāte the. ");
INSERT INTO urdgvr_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zillā ke bhī beṭā paidā huā jis kā nām Tūbal-qābīl thā. Wuh lohār thā. Us kī nasl ke log pītal aur lohe kī chīzeṅ banāte the. Tūbal-qābīl kī bahan kā nām Nāmā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ek din Lamak ne apnī bīwiyoṅ se kahā, “Adā aur Zillā, merī bāt suno! Lamak kī bīwiyo, mere alfāz par ġhaur karo! ");
INSERT INTO urdgvr_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ek ādmī ne mujhe zaḳhmī kiyā to maiṅ ne use mār ḍālā. Ek laṛke ne mere choṭ lagāī to maiṅ ne use qatl kar diyā. Jo Qābīl ko qatl kare us se sāt gunā badlā liyā jāegā, lekin jo Lamak ko qatl kare us se satattar gunā badlā liyā jāegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ādam aur Hawwā kā ek aur beṭā paidā huā. Hawwā ne us kā nām Set rakh kar kahā, “Allāh ne mujhe Hābīl kī jagah jise Qābīl ne qatl kiyā ek aur beṭā baḳhshā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set ke hāṅ bhī beṭā paidā huā. Us ne us kā nām Anūs rakhā. Un dinoṅ meṅ log Rab kā nām le kar ibādat karne lage. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Zail meṅ Ādam kā nasabnāmā darj hai. Jab Allāh ne insān ko ḳhalaq kiyā to us ne use apnī sūrat par banāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Us ne unheṅ mard aur aurat paidā kiyā. Aur jis din us ne unheṅ ḳhalaq kiyā us ne unheṅ barkat de kar un kā nām Ādam yānī Insān rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ādam kī umr 130 sāl thī jab us kā beṭā Set paidā huā. Set sūrat ke lihāz se apne bāp kī mānind thā, wuh us se mushābahat rakhtā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Set kī paidāish ke bād Ādam mazīd 800 sāl zindā rahā. Us ke aur beṭe-beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Wuh 930 sāl kī umr meṅ faut huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set 105 sāl kā thā jab us kā beṭā Anūs paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Is ke bād wuh mazīd 807 sāl zindā rahā. Us ke aur beṭe-beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Wuh 912 sāl kī umr meṅ faut huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Anūs 90 baras kā thā jab us kā beṭā Qīnān paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Is ke bād wuh mazīd 815 sāl zindā rahā. Us ke aur beṭe-beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Wuh 905 sāl kī umr meṅ faut huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Qīnān 70 sāl kā thā jab us kā beṭā Mahalalel paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Is ke bād wuh mazīd 840 sāl zindā rahā. Us ke aur beṭe-beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Wuh 910 sāl kī umr meṅ faut huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel 65 sāl kā thā jab us kā beṭā Yārid paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Is ke bād wuh mazīd 830 sāl zindā rahā. Us ke aur beṭe-beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Wuh 895 sāl kī umr meṅ faut huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yārid 162 sāl kā thā jab us kā beṭā Hanūk paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Is ke bād wuh mazīd 800 sāl zindā rahā. Us ke aur beṭe-beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Wuh 962 sāl kī umr meṅ faut huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Hanūk 65 sāl kā thā jab us kā beṭā Matūsilah paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Is ke bād wuh mazīd 300 sāl Allāh ke sāth chaltā rahā. Us ke aur beṭe-beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Wuh kul 365 sāl duniyā meṅ rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Hanūk Allāh ke sāth sāth chaltā thā. 365 sāl kī umr meṅ wuh ġhāyb huā, kyoṅki Allāh ne use uṭhā liyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matūsilah 187 sāl kā thā jab us kā beṭā Lamak paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Wuh mazīd 782 sāl zindā rahā. Us ke aur beṭe aur beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Wuh 969 sāl kī umr meṅ faut huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamak 182 sāl kā thā jab us kā beṭā paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Us ne us kā nām Nūh yānī Tasallī rakhā, kyoṅki us ne us ke bāre meṅ kahā, “Hamārā khetībāṛī kā kām nihāyat taklīfdeh hai, is lie ki Allāh ne zamīn par lānat bhejī hai. Lekin ab ham beṭe kī mārifat tasallī pāeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Is ke bād wuh mazīd 595 sāl zindā rahā. Us ke aur beṭe-beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Wuh 777 sāl kī umr meṅ faut huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nūh 500 sāl kā thā jab us ke beṭe Sim, Hām aur Yāfat paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Duniyā meṅ logoṅ kī tādād baṛhne lagī. Un ke hāṅ beṭiyāṅ paidā huīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Tab āsmānī hastiyoṅ ne dekhā ki banī nau insān kī beṭiyāṅ ḳhūbsūrat haiṅ, aur unhoṅ ne un meṅ se kuchh chun kar un se shādī kī. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Phir Rab ne kahā, “Merī rūh hameshā ke lie insān meṅ na rahe kyoṅki wuh fānī maḳhlūq hai. Ab se wuh 120 sāl se zyādā zindā nahīṅ rahegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Un dinoṅ meṅ aur bād meṅ bhī duniyā meṅ dewqāmat afrād the jo insānī auratoṅ aur un āsmānī hastiyoṅ kī shādiyoṅ se paidā hue the. Yih dewqāmat afrād qadīm zamāne ke mashhūr sūrmā the. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Rab ne dekhā ki insān nihāyat bigaṛ gayā hai, ki us ke tamām ḳhayālāt lagātār burāī kī taraf māyl rahte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Wuh pachhtāyā ki maiṅ ne insān ko banā kar duniyā meṅ rakh diyā hai, aur use saḳht dukh huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Us ne kahā, “Go maiṅ hī ne insān ko ḳhalaq kiyā maiṅ use rū-e-zamīn par se miṭā ḍālūṅgā. Maiṅ na sirf logoṅ ko balki zamīn par chalne-phirne aur reṅgne wāle jānwaroṅ aur hawā ke parindoṅ ko bhī halāk kar dūṅgā, kyoṅki maiṅ pachhtātā hūṅ ki maiṅ ne un ko banāyā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Sirf Nūh par Rab kī nazar-e-karm thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Yih us kī zindagī kā bayān hai. Nūh rāstbāz thā. Us zamāne ke logoṅ meṅ sirf wuhī bequsūr thā. Wuh Allāh ke sāth sāth chaltā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nūh ke tīn beṭe the, Sim, Hām aur Yāfat. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Lekin duniyā Allāh kī nazar meṅ bigaṛī huī aur zulm-o-tashaddud se bharī huī thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Jahāṅ bhī Allāh deḳhtā duniyā ḳharāb thī, kyoṅki tamām jāndāroṅ ne zamīn par apnī rawish ko bigāṛ diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Tab Allāh ne Nūh se kahā, “Maiṅ ne tamām jāndāroṅ ko ḳhatm karne kā faislā kiyā hai, kyoṅki un ke sabab se pūrī duniyā zulm-o-tashaddud se bhar gaī hai. Chunāṅche maiṅ un ko zamīn samet tabāh kar dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ab apne lie saro kī lakaṛī kī kashtī banā le. Us meṅ kamre hoṅ aur use andar aur bāhar tārkol lagā. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Us kī lambāī 450 fuṭ, chauṛāī 75 fuṭ aur ūṅchāī 45 fuṭ ho. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Kashtī kī chhat ko yoṅ banānā ki us ke nīche 18 inch khulā rahe. Ek taraf darwāzā ho, aur us kī tīn manzileṅ hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Maiṅ pānī kā itnā baṛā sailāb lāūṅgā ki wuh zamīn ke tamām jāndāroṅ ko halāk kar ḍālegā. Zamīn par sab kuchh fanā ho jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Lekin tere sāth maiṅ ahd bāndhūṅgā jis ke taht tū apne beṭoṅ, apnī bīwī aur bahuoṅ ke sāth kashtī meṅ jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Har qism ke jānwar kā ek nar aur ek mādā bhī apne sāth kashtī meṅ le jānā tāki wuh tere sāth jīte bacheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Har qism ke par rakhne wāle jānwar aur har qism ke zamīn par phirne yā reṅgne wāle jānwar do do ho kar tere pās āeṅge tāki jīte bach jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Jo bhī ḳhurāk darkār hai use apne aur un ke lie jamā karke kashtī meṅ mahfūz kar lenā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nūh ne sab kuchh waisā hī kiyā jaisā Allāh ne use batāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Phir Rab ne Nūh se kahā, “Apne gharāne samet kashtī meṅ dāḳhil ho jā, kyoṅki is daur ke logoṅ meṅ se maiṅ ne sirf tujhe rāstbāz pāyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Har qism ke pāk jānwaroṅ meṅ se sāt sāt nar-o-mādā ke joṛe jabki nāpāk jānwaroṅ meṅ se nar-o-mādā kā sirf ek ek joṛā sāth le jānā. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Isī tarah har qism ke par rakhne wāloṅ meṅ se sāt sāt nar-o-mādā ke joṛe bhī sāth le jānā tāki un kī nasleṅ bachī raheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ek hafte ke bād maiṅ chālīs din aur chālīs rāt mutawātir bārish barsāūṅgā. Is se maiṅ tamām jāndāroṅ ko rū-e-zamīn par se miṭā ḍālūṅgā, agarche maiṅ hī ne unheṅ banāyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nūh ne waisā hī kiyā jaisā Rab ne hukm diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Wuh 600 sāl kā thā jab yih tūfānī sailāb zamīn par āyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Tūfānī sailāb se bachne ke lie Nūh apne beṭoṅ, apnī bīwī aur bahuoṅ ke sāth kashtī meṅ sawār huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Zamīn par phirne wāle pāk aur nāpāk jānwar, par rakhne wāle aur tamām reṅgne wāle jānwar bhī āe. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Nar-o-mādā kī sūrat meṅ do do ho kar wuh Nūh ke pās ā kar kashtī meṅ sawār hue. Sab kuchh waisā hī huā jaisā Allāh ne Nūh ko hukm diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ek hafte ke bād tūfānī sailāb zamīn par ā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Yih sab kuchh us waqt huā jab Nūh 600 sāl kā thā. Dūsre mahīne ke 17weṅ din zamīn kī gahrāiyoṅ meṅ se tamām chashme phūṭ nikle aur āsmān par pānī ke darīche khul gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Chālīs din aur chālīs rāt tak mūslādhār bārish hotī rahī. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Jab bārish shurū huī to Nūh, us ke beṭe Sim, Hām aur Yāfat, us kī bīwī aur bahueṅ kashtī meṅ sawār ho chuke the. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Un ke sāth har qism ke janglī jānwar, maweshī, reṅgne aur par rakhne wāle jānwar the. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Har qism ke jāndār do do ho kar Nūh ke pās ā kar kashtī meṅ sawār ho chuke the. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Nar-o-mādā āe the. Sab kuchh waisā hī huā thā jaisā Allāh ne Nūh ko hukm diyā thā. Phir Rab ne darwāze ko band kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Chālīs din tak tūfānī sailāb jārī rahā. Pānī chaṛhā to us ne kashtī ko zamīn par se uṭhā liyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Pānī zor pakaṛ kar bahut baṛh gayā, aur kashtī us par tairne lagī. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Āḳhirkār pānī itnā zyādā ho gayā ki tamām ūṅche pahāṛ bhī us meṅ chhup gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Balki sab se ūṅchī choṭī par pānī kī gahrāī 20 fuṭ thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Zamīn par rahne wālī har maḳhlūq halāk huī. Parinde, maweshī, janglī jānwar, tamām jāndār jin se zamīn bharī huī thī aur insān, sab kuchh mar gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Zamīn par har jāndār maḳhlūq halāk huī. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Yoṅ har maḳhlūq ko rū-e-zamīn par se miṭā diyā gayā. Insān, zamīn par phirne aur reṅgne wāle jānwar aur parinde, sab kuchh ḳhatm kar diyā gayā. Sirf Nūh aur kashtī meṅ sawār us ke sāthī bach gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Sailāb ḍeṛh sau din tak zamīn par ġhālib rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Lekin Allāh ko Nūh aur tamām jānwar yād rahe jo kashtī meṅ the. Us ne hawā chalā dī jis se pānī kam hone lagā. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Zamīn ke chashme aur āsmān par ke pānī ke darīche band ho gae. Aur bārish ruk gaī. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Pānī ghaṭtā gayā. 150 din ke bād wuh kāfī kam ho gayā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Sātweṅ mahīne ke 17weṅ din kashtī Arārāt ke ek pahāṛ par ṭik gaī. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Dasweṅ mahīne ke pahle din pānī itnā kam ho gayā thā ki pahāṛoṅ kī choṭiyāṅ nazar āne lagī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","Chālīs din ke bād Nūh ne kashtī kī khiṛkī khol kar ek kawwā chhoṛ diyā, aur wuh uṛ kar chalā gayā. Lekin jab tak zamīn par pānī thā wuh ātā jātā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Phir Nūh ne ek kabūtar chhoṛ diyā tāki patā chale ki zamīn pānī se nikal āī hai yā nahīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Lekin kabūtar ko kahīṅ bhī baiṭhne kī jagah na milī, kyoṅki ab tak pūrī zamīn par pānī hī pānī thā. Wuh kashtī aur Nūh ke pās wāpas ā gayā, aur Nūh ne apnā hāth baṛhāyā aur kabūtar ko pakaṛ kar apne pās kashtī meṅ rakh liyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Us ne ek haftā aur intazār karke kabūtar ko dubārā chhoṛ diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Shām ke waqt wuh lauṭ āyā. Is dafā us kī choṅch meṅ zaitūn kā tāzā pattā thā. Tab Nūh ko mālūm huā ki zamīn pānī se nikal āī hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Us ne mazīd ek hafte ke bād kabūtar ko chhoṛ diyā. Is dafā wuh wāpas na āyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Jab Nūh 601 sāl kā thā to pahle mahīne ke pahle din zamīn kī satah par pānī ḳhatm ho gayā. Tab Nūh ne kashtī kī chhat khol dī aur dekhā ki zamīn kī satah par pānī nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Dūsre mahīne ke 27weṅ din zamīn bilkul ḳhushk ho gaī. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Phir Allāh ne Nūh se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Apnī bīwī, beṭoṅ aur bahuoṅ ke sāth kashtī se nikal ā. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Jitne bhī jānwar sāth haiṅ unheṅ nikāl de, ḳhāh parinde hoṅ, ḳhāh zamīn par phirne yā reṅgne wāle jānwar. Wuh duniyā meṅ phail jāeṅ, nasl baṛhāeṅ aur tādād meṅ baṛhte jāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Chunāṅche Nūh apne beṭoṅ, apnī bīwī aur bahuoṅ samet nikal āyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tamām jānwar aur parinde bhī apnī apnī qism ke gurohoṅ meṅ kashtī se nikle. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Us waqt Nūh ne Rab ke lie qurbāngāh banāī. Us ne tamām phirne aur uṛne wāle pāk jānwaroṅ meṅ se kuchh chun kar unheṅ zabah kiyā aur qurbāngāh par pūrī tarah jalā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yih qurbāniyāṅ dekh kar Rab ḳhush huā aur apne dil meṅ kahā, “Ab se maiṅ kabhī zamīn par insān kī wajah se lānat nahīṅ bhejūṅgā, kyoṅki us kā dil bachpan hī se burāī kī taraf māyl hai. Ab se maiṅ kabhī is tarah tamām jān rakhne wālī maḳhlūqāt ko rū-e-zamīn par se nahīṅ miṭāūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Duniyā ke muqarrarā auqāt jārī raheṅge. Bīj bone aur fasal kāṭne kā waqt, ṭhanḍ aur tapish, garmiyoṅ aur sardiyoṅ kā mausam, din aur rāt, yih sab kuchh duniyā ke Aḳhīr tak qāym rahegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Phir Allāh ne Nūh aur us ke beṭoṅ ko barkat de kar kahā, “Phalo-phūlo aur tādād meṅ baṛhte jāo. Duniyā tum se bhar jāe ");
INSERT INTO urdgvr_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","zamīn par phirne aur reṅgne wāle jānwar, parinde aur machhliyāṅ sab tum se ḍareṅge. Unheṅ tumhāre iḳhtiyār meṅ kar diyā gayā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Jis tarah maiṅ ne tumhāre khāne ke lie paudoṅ kī paidāwār muqarrar kī hai usī tarah ab se tumheṅ har qism ke jānwar khāne kī ijāzat bhī hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Lekin ḳhabardār! Aisā gosht na khānā jis meṅ ḳhūn hai, kyoṅki ḳhūn meṅ us kī jān hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Kisī kī jān lenā manā hai. Jo aisā karegā use apnī jān denī paṛegī, ḳhāh wuh insān ho yā haiwān. Maiṅ ḳhud is kā mutālabā karūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Jo bhī kisī kā ḳhūn bahāe us kā ḳhūn bhī bahāyā jāegā. Kyoṅki Allāh ne insān ko apnī sūrat par banāyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ab phalo-phūlo aur tādād meṅ baṛhte jāo. Duniyā meṅ phail jāo.” ");
INSERT INTO urdgvr_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Tab Allāh ne Nūh aur us ke beṭoṅ se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ab maiṅ tumhāre aur tumhārī aulād ke sāth ahd qāym kartā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Yih ahd un tamām jānwaroṅ ke sāth bhī hogā jo kashtī meṅ se nikle haiṅ yānī parindoṅ, maweshiyoṅ aur zamīn par ke tamām jānwaroṅ ke sāth. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Maiṅ tumhāre sāth ahd bāndh kar wādā kartā hūṅ ki ab se aisā kabhī nahīṅ hogā ki zamīn kī tamām zindagī sailāb se ḳhatm kar dī jāegī. Ab se aisā sailāb kabhī nahīṅ āegā jo pūrī zamīn ko tabāh kar de. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Is abadī ahd kā nishān jo maiṅ tumhāre aur tamām jāndāroṅ ke sāth qāym kar rahā hūṅ yih hai ki ");
INSERT INTO urdgvr_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","maiṅ apnī kamān bādaloṅ meṅ rakhtā hūṅ. Wuh mere duniyā ke sāth ahd kā nishān hogā. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Jab kabhī mere kahne par āsmān par bādal chhā jāeṅge aur qaus-e-quzah un meṅ se nazar āegī ");
INSERT INTO urdgvr_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","to maiṅ yih ahd yād karūṅga jo tumhāre aur tamām jāndāroṅ ke sāth kiyā gayā hai. Ab kabhī bhī aisā sailāb nahīṅ āegā jo tamām zindagī ko halāk kar de. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Qaus-e-quzah nazar āegī to maiṅ use dekh kar us dāymī ahd ko yād karūṅga jo mere aur duniyā kī tamām jāndār maḳhlūqāt ke darmiyān hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Yih us ahd kā nishān hai jo maiṅ ne duniyā ke tamām jāndāroṅ ke sāth kiyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nūh ke jo beṭe us ke sāth kashtī se nikle Sim, Hām aur Yāfat the. Hām Kanān kā bāp thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Duniyā-bhar ke tamām log in tīnoṅ kī aulād haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nūh kisān thā. Shurū meṅ us ne angūr kā bāġh lagāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Angūr se mai banā kar us ne itnī pī lī ki wuh nashe meṅ dhut apne ḍere meṅ nangā paṛā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kanān ke bāp Hām ne use yoṅ paṛā huā dekhā to bāhar jā kar apne donoṅ bhāiyoṅ ko us ke bāre meṅ batāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Yih sun kar Sim aur Yāfat ne apne kandhoṅ par kapṛā rakhā. Phir wuh ulṭe chalte hue ḍere meṅ dāḳhil hue aur kapṛā apne bāp par ḍāl diyā. Un ke muṅh dūsrī taraf muṛe rahe tāki bāp kī barahnagī nazar na āe. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Jab Nūh hosh meṅ āyā to us ko patā chalā ki sab se chhoṭe beṭe ne kyā kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Us ne kahā, “Kanān par lānat! Wuh apne bhāiyoṅ kā zalīltarīn ġhulām hogā. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Mubārak ho Rab jo Sim kā Ḳhudā hai. Kanān Sim kā ġhulām ho. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Allāh kare ki Yāfat kī hudūd baṛh jāeṅ. Yāfat Sim ke ḍeroṅ meṅ rahe aur Kanān us kā ġhulām ho.” ");
INSERT INTO urdgvr_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Sailāb ke bād Nūh mazīd 350 sāl zindā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Wuh 950 sāl kī umr meṅ faut huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Yih Nūh ke beṭoṅ Sim, Hām aur Yāfat kā nasabnāmā hai. Un ke beṭe sailāb ke bād paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yāfat ke beṭe Jumar, Mājūj, Mādī, Yāwān, Tūbal, Masak aur Tīrās the. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Jumar ke beṭe Ashkanāz, Rīfat aur Tujarmā the. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yāwān ke beṭe Ilīsā aur Tarsīs the. Kittī aur Dodānī bhī us kī aulād haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Wuh un qaumoṅ ke ābā-o-ajdād haiṅ jo sāhilī ilāqoṅ aur jazīroṅ meṅ phail gaīṅ. Yih Yāfat kī aulād haiṅ jo apne apne qabīle aur mulk meṅ rahte hue apnī apnī zabān bolte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hām ke beṭe Kūsh, Misr, Fūt aur Kanān the. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kūsh ke beṭe Sibā, Hawīlā, Sabtā, Rāmā aur Sabtakā the. Rāmā ke beṭe Sabā aur Dadān the. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kūsh kā ek aur beṭā banām Namrūd thā. Wuh duniyā meṅ pahlā zabardast hākim thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Rab ke nazdīk wuh zabardast shikārī thā. Is lie āj bhī kisī achchhe shikārī ke bāre meṅ kahā jātā hai, “Wuh Namrūd kī mānind hai jo Rab ke nazdīk zabardast shikārī thā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Us kī saltanat ke pahle markaz Mulk-e-Sinār meṅ Bābal, Arak, Akkād aur Kalnā ke shahr the. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Us mulk se nikal kar wuh Asūr chalā gayā jahāṅ us ne Nīnwā, Rahobot-īr, Kalah ");
INSERT INTO urdgvr_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","aur Rasan ke shahr tāmīr kie. Baṛā shahr Rasan Nīnwā aur Kalah ke darmiyān wāqe hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misr in qaumoṅ kā bāp thā: Lūdī, Anāmī, Lihābī, Naftūhī, ");
INSERT INTO urdgvr_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Fatrūsī, Kaslūhī (jin se Filistī nikle) aur Kaftūrī. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanān kā pahlauṭhā Saidā thā. Kanān zail kī qaumoṅ kā bāp bhī thā: Hittī ");
INSERT INTO urdgvr_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yabūsī, Amorī, Jirjāsī, ");
INSERT INTO urdgvr_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiwwī, Arqī, Sīnī, ");
INSERT INTO urdgvr_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwādī, Samārī aur Hamātī. Bād meṅ Kanānī qabīle itne phail gae ");
INSERT INTO urdgvr_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ki un kī hudūd shimāl meṅ Saidā se junūb kī taraf Jirār se ho kar Ġhazzā tak aur wahāṅ se mashriq kī taraf Sadūm, Amūrā, Admā aur Zaboīm se ho kar lasā tak thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Yih sab Hām kī aulād haiṅ, jo un ke apne apne qabīle, apnī apnī zabān, apne apne mulk aur apnī apnī qaum ke mutābiq darj haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sim Yāfat kā baṛā bhāī thā. Us ke bhī beṭe paidā hue. Sim tamām banī Ibar kā bāp hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sim ke beṭe Ailām, Asūr, Arfaksad, Lūd aur Arām the. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arām ke beṭe Ūz, Hūl, Jatar aur Mas the. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaksad kā beṭā Silah aur Silah kā beṭā Ibar thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ibar ke hāṅ do beṭe paidā hue. Ek kā nām Falaj yānī Taqsīm thā, kyoṅki un aiyām meṅ duniyā taqsīm huī. Falaj ke bhāī kā nām Yuqtān thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yuqtān ke beṭe Almūdād, Salaf, Hasarmāwat, Irāḳh, ");
INSERT INTO urdgvr_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadūrām, Ūzāl, Diqlā, ");
INSERT INTO urdgvr_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Ūbāl, Abīmāel, Sabā, ");
INSERT INTO urdgvr_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofīr, Hawīlā aur Yūbāb the. Yih sab Yuqtān ke beṭe the. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Wuh Mesā se le kar Safār aur mashriqī pahāṛī ilāqe tak ābād the. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Yih sab Sim kī aulād haiṅ, jo apne apne qabīle, apnī apnī zabān, apne apne mulk aur apnī apnī qaum ke mutābiq darj haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Yih sab Nūh ke beṭoṅ ke qabīle haiṅ, jo apnī nasloṅ aur qaumoṅ ke mutābiq darj kie gae haiṅ. Sailāb ke bād tamām qaumeṅ inhīṅ se nikal kar rū-e-zamīn par phail gaīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Us waqt tak pūrī duniyā ke log ek hī zabān bolte the. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Mashriq kī taraf baṛhte baṛhte wuh Sinār ke ek maidān meṅ pahuṅch kar wahāṅ ābād hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Tab wuh ek dūsre se kahne lage, “Āo, ham miṭṭī se īṅṭeṅ banā kar unheṅ āg meṅ ḳhūb pakāeṅ.” Unhoṅ ne tāmīrī kām ke lie patthar kī jagah īṅṭeṅ aur masāle kī jagah tārkol istemāl kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Phir wuh kahne lage, “Āo, ham apne lie shahr banā leṅ jis meṅ aisā burj ho jo āsmān tak pahuṅch jāe phir hamārā nām qāym rahegā aur ham rū-e-zamīn par bikhar jāne se bach jāeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Lekin Rab us shahr aur burj ko deḳhne ke lie utar āyā jise log banā rahe the. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Rab ne kahā, “Yih log ek hī qaum haiṅ aur ek hī zabān bolte haiṅ. Aur yih sirf us kā āġhāz hai jo wuh karnā chāhte haiṅ. Ab se jo bhī wuh mil kar karnā chāheṅge us se unheṅ rokā nahīṅ jā sakegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Is lie āo, ham duniyā meṅ utar kar un kī zabān ko darham-barham kar deṅ tāki wuh ek dūsre kī bāt samajh na pāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Is tarīqe se Rab ne unheṅ tamām rū-e-zamīn par muntashir kar diyā, aur shahr kī tāmīr ruk gaī. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Is lie shahr kā nām Bābal yānī Abtarī ṭhahrā, kyoṅki Rab ne wahāṅ tamām logoṅ kī zabān ko darham-barham karke unheṅ tamām rū-e-zamīn par muntashir kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Yih Sim kā nasabnāmā hai: Sim 100 sāl kā thā jab us kā beṭā Arfaksad paidā huā. Yih sailāb ke do sāl bād huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Is ke bād wuh mazīd 500 sāl zindā rahā. Us ke aur beṭe-beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaksad 35 sāl kā thā jab Silah paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Is ke bād wuh mazīd 403 sāl zindā rahā. Us ke aur beṭe-beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Silah 30 sāl kā thā jab Ibar paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Is ke bād wuh mazīd 403 sāl zindā rahā. Us ke aur beṭe-beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ibar 34 sāl kā thā jab Falaj paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Is ke bād wuh mazīd 430 sāl zindā rahā. Us ke aur beṭe-beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Falaj 30 sāl kā thā jab Raū paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Is ke bād wuh mazīd 209 sāl zindā rahā. Us ke aur beṭe-beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Raū 32 sāl kā thā jab Sarūj paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Is ke bād wuh mazīd 207 sāl zindā rahā. Us ke aur beṭe-beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sarūj 30 sāl kā thā jab Nahūr paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Is ke bād wuh mazīd 200 sāl zindā rahā. Us ke aur beṭe-beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahūr 29 sāl kā thā jab Tārah paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Is ke bād wuh mazīd 119 sāl zindā rahā. Us ke aur beṭe-beṭiyāṅ bhī paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tārah 70 sāl kā thā jab us ke beṭe Abrām, Nahūr aur Hārān paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Yih Tārah kā nasabnāmā hai: Abrām, Nahūr aur Hārān Tārah ke beṭe the. Lūt Hārān kā beṭā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Apne bāp Tārah kī zindagī meṅ hī Hārān Kasdiyoṅ ke Ūr meṅ intaqāl kar gayā jahāṅ wuh paidā bhī huā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Bāqī donoṅ beṭoṅ kī shādī huī. Abrām kī bīwī kā nām Sāray thā aur Nahūr kī bīwī kā nām Milkāh. Milkāh Hārān kī beṭī thī, aur us kī ek bahan banām Iskā thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sāray bāṅjh thī, is lie us ke bachche nahīṅ the. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tārah Kasdiyoṅ ke Ūr se rawānā ho kar Mulk-e-Kanān kī taraf safr karne lagā. Us ke sāth us kā beṭā Abrām, us kā potā Lūt yānī Hārān kā beṭā aur us kī bahū Sāray the. Jab wuh Hārān pahuṅche to wahāṅ ābād ho gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tārah 205 sāl kā thā jab us ne Hārān meṅ wafāt pāī. ");
INSERT INTO urdgvr_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Rab ne Abrām se kahā, “Apne watan, apne rishtedāroṅ aur apne bāp ke ghar ko chhoṛ kar us mulk meṅ chalā jā jo maiṅ tujhe dikhāūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Maiṅ tujh se ek baṛī qaum banāūṅgā, tujhe barkat dūṅgā aur tere nām ko bahut baṛhāūṅgā. Tū dūsroṅ ke lie barkat kā bāis hogā. ");
INSERT INTO urdgvr_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Jo tujhe barkat deṅge unheṅ maiṅ bhī barkat dūṅgā. Jo tujh par lānat karegā us par maiṅ bhī lānat karūṅga. Duniyā kī tamām qaumeṅ tujh se barkat pāeṅgī.” ");
INSERT INTO urdgvr_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abrām ne Rab kī sunī aur Hārān se rawānā huā. Lūt us ke sāth thā. Us waqt Abrām 75 sāl kā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Us ke sāth us kī bīwī Sāray aur us kā bhatījā Lūt the. Wuh apne naukar-chākaroṅ samet apnī pūrī milkiyat bhī sāth le gayā jo us ne Hārān meṅ hāsil kī thī. Chalte chalte wuh Kanān pahuṅche. ");
INSERT INTO urdgvr_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abrām us mulk meṅ se guzar kar Sikam ke maqām par ṭhahar gayā jahāṅ Morih ke balūt kā daraḳht thā. Us zamāne meṅ mulk meṅ Kanānī qaumeṅ ābād thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Wahāṅ Rab Abrām par zāhir huā aur us se kahā, “Maiṅ terī aulād ko yih mulk dūṅgā.” Is lie us ne wahāṅ Rab kī tāzīm meṅ qurbāngāh banāī jahāṅ wuh us par zāhir huā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Wahāṅ se wuh us pahāṛī ilāqe kī taraf gayā jo Baitel ke mashriq meṅ hai. Wahāṅ us ne apnā ḳhaimā lagāyā. Maġhrib meṅ Baitel thā aur mashriq meṅ Aī. Is jagah par bhī us ne Rab kī tāzīm meṅ qurbāngāh banāī aur Rab kā nām le kar ibādat kī. ");
INSERT INTO urdgvr_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Phir Abrām dubārā rawānā ho kar junūb ke Dasht-e-Najab kī taraf chal paṛā. ");
INSERT INTO urdgvr_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Un dinoṅ meṅ Mulk-e-Kanān meṅ kāl paṛā. Kāl itnā saḳht thā ki Abrām us se bachne kī ḳhātir kuchh der ke lie Misr meṅ jā basā, lekin pardesī kī haisiyat se. ");
INSERT INTO urdgvr_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Jab wuh Misr kī sarhad ke qarīb āe to us ne apnī bīwī Sāray se kahā, “Maiṅ jāntā hūṅ ki tū kitnī ḳhūbsūrat hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Misrī tujhe dekheṅge, phir kaheṅge, ‘Yih is kā shauhar hai.’ Natīje meṅ wuh mujhe mār ḍāleṅge aur tujhe zindā chhoṛeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Is lie logoṅ se yih kahte rahnā ki maiṅ Abrām kī bahan hūṅ. Phir mere sāth achchhā sulūk kiyā jāegā aur merī jān tere sabab se bach jāegī.” ");
INSERT INTO urdgvr_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Jab Abrām Misr pahuṅchā to wāqaī Misriyoṅ ne dekhā ki Sāray nihāyat hī ḳhūbsūrat hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Aur jab Firaun ke afsarān ne use dekhā to unhoṅ ne Firaun ke sāmne Sāray kī tārīf kī. Āḳhirkār use mahal meṅ pahuṅchāyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Firaun ne Sāray kī ḳhātir Abrām par ehsān karke use bheṛ-bakriyāṅ, gāy-bail, gadhe-gadhiyāṅ, naukar-chākar aur ūṅṭ die. ");
INSERT INTO urdgvr_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Lekin Rab ne Sāray ke sabab se Firaun aur us ke gharāne meṅ saḳht qism ke amrāz phailāe. ");
INSERT INTO urdgvr_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Āḳhirkār Firaun ne Abrām ko bulā kar kahā, “Tū ne mere sāth kyā kiyā? Tū ne mujhe kyoṅ nahīṅ batāyā ki Sāray terī bīwī hai? ");
INSERT INTO urdgvr_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Tū ne kyoṅ kahā ki wuh merī bahan hai? Is dhoke kī binā par maiṅ ne use ghar meṅ rakh liyā tāki us se shādī karūṅ. Dekh, terī bīwī hāzir hai. Ise le kar yahāṅ se nikal jā!” ");
INSERT INTO urdgvr_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Phir Firaun ne apne sipāhiyoṅ ko hukm diyā, aur unhoṅ ne Abrām, us kī bīwī aur pūrī milkiyat ko ruḳhsat karke mulk se rawānā kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abrām apnī bīwī, Lūt aur tamām jāydād ko sāth le kar Misr se niklā aur Kanān ke junūbī ilāqe Dasht-e-Najab meṅ wāpas āyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abrām nihāyat daulatmand ho gayā thā. Us ke pās bahut-se maweshī aur sonā-chāṅdī thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Wahāṅ se jagah bajagah chalte hue wuh āḳhirkār Baitel se ho kar us maqām tak pahuṅch gayā jahāṅ us ne shurū meṅ apnā ḍerā lagāyā thā aur jo Baitel aur Aī ke darmiyān thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Wahāṅ jahāṅ us ne qurbāngāh banāī thī us ne Rab kā nām le kar us kī ibādat kī. ");
INSERT INTO urdgvr_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lūt ke pās bhī bahut-sī bheṛ-bakriyāṅ, gāy-bail aur ḳhaime the. ");
INSERT INTO urdgvr_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Natījā yih niklā ki āḳhirkār wuh mil kar na rah sake, kyoṅki itnī jagah nahīṅ thī ki donoṅ ke rewaṛ ek hī jagah par char sakeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Abrām aur Lūt ke charwāhe āpas meṅ jhagaṛne lage. (Us zamāne meṅ Kanānī aur Farizzī bhī mulk meṅ ābād the.) ");
INSERT INTO urdgvr_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Tab Abrām ne Lūt se bāt kī, “Aisā nahīṅ honā chāhie ki tere aur mere darmiyān jhagaṛā ho yā tere charwāhoṅ aur mere charwāhoṅ ke darmiyān. Ham to bhāī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Kyā zarūrat hai ki ham mil kar raheṅ jabki tū āsānī se is mulk kī kisī aur jagah rah saktā hai. Behtar hai ki tū mujh se alag ho kar kahīṅ aur rahe. Agar tū bāeṅ hāth jāe to maiṅ dāeṅ hāth jāūṅgā, aur agar tū dāeṅ hāth jāe to maiṅ bāeṅ hāth jāūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lūt ne apnī nazar uṭhā kar dekhā ki Dariyā-e-Yardan ke pūre ilāqe meṅ Zuġhar tak pānī kī kasrat hai. Wuh Rab ke bāġh yā Mulk-e-Misr kī mānind thā, kyoṅki us waqt Rab ne Sadūm aur Amūrā ko tabāh nahīṅ kiyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Chunāṅche Lūt ne Dariyā-e-Yardan ke pūre ilāqe ko chun liyā aur mashriq kī taraf jā basā. Yoṅ donoṅ rishtedār ek dūsre se judā ho gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abrām Mulk-e-Kanān meṅ rahā jabki Lūt Yardan ke ilāqe ke shahroṅ ke darmiyān ābād ho gayā. Wahāṅ us ne apne ḳhaime Sadūm ke qarīb lagā die. ");
INSERT INTO urdgvr_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Lekin Sadūm ke bāshinde nihāyat sharīr the, aur un ke Rab ke ḳhilāf gunāh nihāyat makrūh the. ");
INSERT INTO urdgvr_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lūt Abrām se judā huā to Rab ne Abrām se kahā, “Apnī nazar uṭhā kar chāroṅ taraf yānī shimāl, junūb, mashriq aur maġhrib kī taraf dekh. ");
INSERT INTO urdgvr_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Jo bhī zamīn tujhe nazar āe use maiṅ tujhe aur terī aulād ko hameshā ke lie detā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Maiṅ terī aulād ko ḳhāk kī tarah beshumār hone dūṅgā. Jis tarah ḳhāk ke zarre gine nahīṅ jā sakte usī tarah terī aulād bhī ginī nahīṅ jā sakegī. ");
INSERT INTO urdgvr_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Chunāṅche uṭh kar is mulk kī har jagah chal-phir, kyoṅki maiṅ ise tujhe detā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abrām rawānā huā. Chalte chalte us ne apne ḍere Habrūn ke qarīb Mamre ke daraḳhtoṅ ke pās lagāe. Wahāṅ us ne Rab kī tāzīm meṅ qurbāngāh banāī. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Kanān meṅ jang huī. Bairūn-e-mulk ke chār bādshāhoṅ ne Kanān ke pāṅch bādshāhoṅ se jang kī. Bairūn-e-mulk ke bādshāh yih the: Sinār se Amrāfil, Illāsar se Aryūk, Ailām se Kidarlāumar aur Joyim se Tidāl. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Kanān ke bādshāh yih the: Sadūm se Birā, Amūrā se Birshā, Admā se Siniyāb, Zaboīm se Shimebar aur Bālā yānī Zuġhar kā bādshāh. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Kanān ke in pāṅch bādshāhoṅ kā ittahād huā thā aur wuh Wādī-e-Siddīm meṅ jamā hue the. (Ab Siddīm nahīṅ hai, kyoṅki us kī jagah Bahīrā-e-Murdār ā gayā hai.) ");
INSERT INTO urdgvr_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kidarlāumar ne bārah sāl tak un par hukūmat kī thī, lekin terhweṅ sāl wuh bāġhī ho gae the. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ab ek sāl ke bād Kidarlāumar aur us ke ittahādī apnī faujoṅ ke sāth āe. Pahle unhoṅ ne Astārāt-qarnaim meṅ Rafāiyoṅ ko, Hām meṅ Zūziyoṅ ko, Sawī-qiriyatāym meṅ Aimiyoṅ ko ");
INSERT INTO urdgvr_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","aur Horiyoṅ ko un ke pahāṛī ilāqe Saīr meṅ shikast dī. Yoṅ wuh El-fārān tak pahuṅch gae jo registān ke kināre par hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Phir wuh wāpas āe aur Ain-misfāt yānī Qādis pahuṅche. Unhoṅ ne Amālīqiyoṅ ke pūre ilāqe ko tabāh kar diyā aur Hassūn-tamr meṅ ābād Amoriyoṅ ko bhī shikast dī. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Us waqt Sadūm, Amūrā, Admā, Zaboīm aur Bālā yānī Zuġhar ke bādshāh un se laṛne ke lie Siddīm kī Wādī meṅ jamā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","In pāṅch bādshāhoṅ ne Ailām ke bādshāh Kidarlāumar, Joyim ke bādshāh Tidāl, Sinār ke bādshāh Amrāfil aur Illāsar ke bādshāh Aryūk kā muqābalā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Is wādī meṅ tārkol ke muta'addid gaṛhe the. Jab bāġhī bādshāh shikast khā kar bhāgne lage to Sadūm aur Amūrā ke bādshāh in gaṛhoṅ meṅ gir gae jabki bāqī tīn bādshāh bach kar pahāṛī ilāqe meṅ farār hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Fathmand bādshāh Sadūm aur Amūrā kā tamām māl tamām khāne wālī chīzoṅ samet lūṭ kar wāpas chal die. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abrām kā bhatījā Lūt Sadūm meṅ rahtā thā, is lie wuh use bhī us kī milkiyat samet chhīn kar sāth le gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Lekin ek ādmī ne jo bach niklā thā Ibrānī mard Abrām ke pās ā kar use sab kuchh batā diyā. Us waqt wuh Mamre ke daraḳhtoṅ ke pās ābād thā. Mamre Amorī thā. Wuh aur us ke bhāī Iskāl aur Āner Abrām ke ittahādī the. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Jab Abrām ko patā chalā ki bhatīje ko giriftār kar liyā gayā hai to us ne apne ghar meṅ paidā hue tamām jangāzmūdā ġhulāmoṅ ko jamā karke Dān tak dushman kā tāqqub kiyā. Us ke sāth 318 afrād the. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Wahāṅ us ne apne bandoṅ ko gurohoṅ meṅ taqsīm karke rāt ke waqt dushman par hamlā kiyā. Dushman shikast khā kar bhāg gayā aur Abrām ne Damishq ke shimāl meṅ wāqe Ḳhūbā tak us kā tāqqub kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Wuh un se lūṭā huā tamām māl wāpas le āyā. Lūt, us kī jāydād, aurateṅ aur bāqī qaidī bhī dushman ke qabze se bach nikle. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Jab Abrām Kidarlāumar aur us ke ittahādiyoṅ par fatah pāne ke bād wāpas pahuṅchā to Sadūm kā bādshāh us se milne ke lie Wādī-e-Sawī meṅ āyā. (Ise ājkal Bādshāh kī Wādī kahā jātā hai.) ");
INSERT INTO urdgvr_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Sālim kā bādshāh Malik-e-sidq bhī wahāṅ pahuṅchā. Wuh apne sāth roṭī aur mai le āyā. Malik-e-sidq Allāh T'ālā kā imām thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Us ne Abrām ko barkat de kar kahā, “Abrām par Allāh T'ālā kī barkat ho, jo āsmān-o-zamīn kā Ḳhāliq hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Allāh T'ālā mubārak ho jis ne tere dushmanoṅ ko tere hāth meṅ kar diyā hai.” Abrām ne use tamām māl kā daswāṅ hissā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sadūm ke bādshāh ne Abrām se kahā, “Mujhe mere log wāpas kar deṅ aur bāqī chīzeṅ apne pās rakh leṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Lekin Abrām ne us se kahā, “Maiṅ ne Rab se qasam khāī hai, Allāh T'ālā se jo āsmān-o-zamīn kā Ḳhāliq hai ");
INSERT INTO urdgvr_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ki maiṅ us meṅ se kuchh nahīṅ lūṅgā jo āp kā hai, chāhe wuh dhāgā yā jūtī kā tasmā hī kyoṅ na ho. Aisā na ho ki āp kaheṅ, ‘Maiṅ ne Abrām ko daulatmand banā diyā hai.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Siwāe us khāne ke jo mere ādmiyoṅ ne rāste meṅ khāyā hai maiṅ kuchh qabūl nahīṅ karūṅga. Lekin mere ittahādī Āner, Iskāl aur Mamre zarūr apnā apnā hissā leṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Is ke bād Rab royā meṅ Abrām se hamkalām huā, “Abrām, mat ḍar. Maiṅ hī terī sipar hūṅ, maiṅ hī terā bahut baṛā ajr hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Lekin Abrām ne etarāz kiyā, “Ai Rab Qādir-e-mutlaq, tū mujhe kyā degā jabki abhī tak mere hāṅ koī bachchā nahīṅ hai aur Iliyazar Damishqī merī mīrās pāegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Tū ne mujhe aulād nahīṅ baḳhshī, is lie mere gharāne kā naukar merā wāris hogā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Tab Abrām ko Allāh se ek aur kalām milā. “Yih ādmī Iliyazar terā wāris nahīṅ hogā balki terā apnā hī beṭā terā wāris hogā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Rab ne use bāhar le jā kar kahā, “Āsmān kī taraf dekh aur sitāroṅ ko ginane kī koshish kar. Terī aulād itnī hī beshumār hogī.” ");
INSERT INTO urdgvr_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abrām ne Rab par bharosā rakhā. Is binā par Allāh ne use rāstbāz qarār diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Phir Rab ne us se kahā, “Maiṅ Rab hūṅ jo tujhe Kasdiyoṅ ke Ūr se yahāṅ le āyā tāki tujhe yih mulk mīrās meṅ de dūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abrām ne pūchhā, “Ai Rab Qādir-e-mutlaq, maiṅ kis tarah jānūṅ ki is mulk par qabzā karūṅga?” ");
INSERT INTO urdgvr_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Jawāb meṅ Rab ne kahā, “Mere huzūr ek tīnsālā gāy, ek tīnsālā bakrī aur ek tīnsālā menḍhā le ā. Ek qumrī aur ek kabūtar kā bachchā bhī le ānā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abrām ne aisā hī kiyā aur phir har ek jānwar ko do hissoṅ meṅ kāṭ kar un ko ek dūsre ke āmne-sāmne rakh diyā. Lekin parindoṅ ko us ne sālim rahne diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Shikārī parinde un par utarne lage, lekin Abrām unheṅ bhagātā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Jab sūraj ḍūbne lagā to Abrām par gahrī nīnd tārī huī. Us par dahshat aur andherā hī andherā chhā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Phir Rab ne us se kahā, “Jān le ki terī aulād aise mulk meṅ rahegī jo us kā nahīṅ hogā. Wahāṅ wuh ajnabī aur ġhulām hogī, aur us par 400 sāl tak bahut zulm kiyā jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Lekin maiṅ us qaum kī adālat karūṅga jis ne use ġhulām banāyā hogā. Is ke bād wuh baṛī daulat pā kar us mulk se nikleṅge. ");
INSERT INTO urdgvr_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Tū ḳhud umrrasīdā ho kar salāmatī ke sāth intaqāl karke apne bāpdādā se jā milegā aur dafnāyā jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Terī aulād kī chauthī pusht ġhairwatan se wāpas āegī, kyoṅki us waqt tak maiṅ Amoriyoṅ ko bardāsht karūṅga. Lekin āḳhirkār un ke gunāh itne sangīn ho jāeṅge ki maiṅ unheṅ Mulk-e-Kanān se nikāl dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Sūraj ġhurūb huā. Andherā chhā gayā. Achānak ek dhuāṅdār tanūr aur ek bhaṛaktī huī mashāl nazar āī aur jānwaroṅ ke do do ṭukṛoṅ ke bīch meṅ se guzare. ");
INSERT INTO urdgvr_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Us waqt Rab ne Abrām ke sāth ahd kiyā. Us ne kahā, “Maiṅ yih mulk Misr kī sarhad se Furāt tak terī aulād ko dūṅgā, ");
INSERT INTO urdgvr_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","agarche abhī tak is meṅ Qīnī, Qanizzī, Kadmūnī, ");
INSERT INTO urdgvr_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hittī, Farizzī, Rafāī, ");
INSERT INTO urdgvr_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorī, Kanānī, Jirjāsī aur Yabūsī ābād haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ab tak Abrām kī bīwī Sāray ke koī bachchā nahīṅ huā thā. Lekin unhoṅ ne ek Misrī launḍī rakhī thī jis kā nām Hājirā thā, ");
INSERT INTO urdgvr_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","aur ek din Sāray ne Abrām se kahā, “Rab ne mujhe bachche paidā karne se mahrūm rakhā hai, is lie merī launḍī ke sāth hambistar hoṅ. Shāyad mujhe us kī mārifat bachchā mil jāe.” Abrām ne Sāray kī bāt mān lī. ");
INSERT INTO urdgvr_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Chunāṅche Sāray ne apnī Misrī launḍī Hājirā ko apne shauhar Abrām ko de diyā tāki wuh us kī bīwī ban jāe us waqt Abrām ko Kanān meṅ baste hue das sāl ho gae the. ");
INSERT INTO urdgvr_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abrām Hājirā se hambistar huā to wuh ummīd se ho gaī. Jab Hājirā ko yih mālūm huā to wuh apnī mālikan ko haqīr jānane lagī. ");
INSERT INTO urdgvr_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Tab Sāray ne Abrām se kahā, “Jo zulm mujh par kiyā jā rahā hai wuh āp hī par āe. Maiṅ ne ḳhud ise āp ke bāzuoṅ meṅ de diyā thā. Ab jab ise mālūm huā hai ki ummīd se hai to mujhe haqīr jānane lagī hai. Rab mere aur āp ke darmiyān faislā kare.” ");
INSERT INTO urdgvr_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abrām ne jawāb diyā, “Dekho, yih tumhārī launḍī hai aur tumhāre iḳhtiyār meṅ hai. Jo tumhārā jī chāhe us ke sāth karo.” Is par Sāray us se itnā burā sulūk karne lagī ki Hājirā farār ho gaī. ");
INSERT INTO urdgvr_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Rab ke farishte ko Hājirā registān ke us chashme ke qarīb milī jo Shūr ke rāste par hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Us ne kahā, “Sāray kī launḍī Hājirā, tū kahāṅ se ā rahī hai aur kahāṅ jā rahī hai?” Hājirā ne jawāb diyā, “Maiṅ apnī mālikan Sāray se farār ho rahī hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Rab ke farishte ne us se kahā, “Apnī mālikan ke pās wāpas chalī jā aur us ke tābe rah. ");
INSERT INTO urdgvr_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Maiṅ terī aulād itnī baṛhāūṅgā ki use ginā nahīṅ jā sakegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Rab ke farishte ne mazīd kahā, “Tū ummīd se hai. Ek beṭā paidā hogā. Us kā nām Ismāīl yānī ‘Allāh Suntā Hai’ rakh, kyoṅki Rab ne musībat meṅ terī āwāz sunī. ");
INSERT INTO urdgvr_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Wuh janglī gadhe kī mānind hogā. Us kā hāth har ek ke ḳhilāf aur har ek kā hāth us ke ḳhilāf hogā. To bhī wuh apne tamām bhāiyoṅ ke sāmne ābād rahegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Rab ke us ke sāth bāt karne ke bād Hājirā ne us kā nām Attā-el-roī yānī ‘Tū Ek Mābūd Hai Jo Mujhe Deḳhtā Hai’ rakhā. Us ne kahā, “Kyā maiṅ ne wāqaī us ke pīchhe dekhā hai jis ne mujhe dekhā hai?” ");
INSERT INTO urdgvr_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Is lie us jagah ke kueṅ kā nām ‘Bair-lahī-roī’ yānī ‘Us Zindā Hastī kā Kuāṅ Jo Mujhe Deḳhtā Hai’ paṛ gayā. Wuh Qādis aur Barad ke darmiyān wāqe hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hājirā wāpas gaī, aur us ke beṭā paidā huā. Abrām ne us kā nām Ismāīl rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Us waqt Abrām 86 sāl kā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Jab Abrām 99 sāl kā thā to Rab us par zāhir huā. Us ne kahā, “Maiṅ Allāh Qādir-e-mutlaq hūṅ. Mere huzūr chaltā rah aur be'ilzām ho. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Maiṅ tere sāth apnā ahd bāndhūṅgā aur terī aulād ko bahut hī zyādā baṛhā dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abrām muṅh ke bal gir gayā, aur Allāh ne us se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Merā tere sāth ahd hai ki tū bahut qaumoṅ kā bāp hogā. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ab se tū Abrām yānī ‘Azīm Bāp’ nahīṅ kahlāegā balki terā nām Ibrāhīm yānī ‘Bahut Qaumoṅ kā Bāp’ hogā. Kyoṅki maiṅ ne tujhe bahut qaumoṅ kā bāp banā diyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Maiṅ tujhe bahut hī zyādā aulād baḳhsh dūṅgā, itnī ki qaumeṅ baneṅgī. Tujh se bādshāh bhī nikleṅge. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Maiṅ apnā ahd tere aur terī aulād ke sāth nasl-dar-nasl qāym karūṅga, ek abadī ahd jis ke mutābiq maiṅ terā aur terī aulād kā Ḳhudā hūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Tū is waqt Mulk-e-Kanān meṅ pardesī hai, lekin maiṅ is pūre mulk ko tujhe aur terī aulād ko detā hūṅ. Yih hameshā tak un kā hī rahegā, aur maiṅ un kā Ḳhudā hūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Allāh ne Ibrāhīm se yih bhī kahā, “Tujhe aur terī aulād ko nasl-dar-nasl mere ahd kī sharāyt pūrī karnī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Is kī ek shart yih hai ki har ek mard kā ḳhatnā kiyā jāe ");
INSERT INTO urdgvr_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","apnā ḳhatnā karāo. Yih hamāre āpas ke ahd kā zāhirī nishān hogā. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Lāzim hai ki tū aur terī aulād nasl-dar-nasl apne har ek beṭe kā āṭhweṅ din ḳhatnā karwāeṅ. Yih usūl us par bhī lāgū hai jo tere ghar meṅ rahtā hai lekin tujh se rishtā nahīṅ rakhtā, chāhe wuh ghar meṅ paidā huā ho yā kisī ajnabī se ḳharīdā gayā ho. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ghar ke har ek mard kā ḳhatnā karnā lāzim hai, ḳhāh wuh ghar meṅ paidā huā ho yā kisī ajnabī se ḳharīdā gayā ho. Yih is bāt kā nishān hogā ki merā tere sāth ahd hameshā tak qāym rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Jis mard kā ḳhatnā na kiyā gayā use us kī qaum meṅ se miṭāyā jāegā, kyoṅki us ne mere ahd kī sharāyt pūrī na kīṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Allāh ne Ibrāhīm se yih bhī kahā, “Apnī bīwī Sāray kā nām bhī badal denā. Ab se us kā nām Sāray nahīṅ balki Sārā yānī Shahzādī hogā. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Maiṅ use barkat baḳhshūṅgā aur tujhe us kī mārifat beṭā dūṅgā. Maiṅ use yahāṅ tak barkat dūṅgā ki us se qaumeṅ balki qaumoṅ ke bādshāh nikleṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ibrāhīm muṅh ke bal gir gayā. Lekin dil hī dil meṅ wuh haṅs paṛā aur sochā, “Yih kis tarah ho saktā hai? Maiṅ to 100 sāl kā hūṅ. Aise ādmī ke hāṅ bachchā kis tarah paidā ho saktā hai? Aur Sārā jaisī umrrasīdā aurat ke bachchā kis tarah paidā ho saktā hai? Us kī umr to 90 sāl hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Us ne Allāh se kahā, “Hāṅ, Ismāīl hī tere sāmne jītā rahe.” ");
INSERT INTO urdgvr_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Allāh ne kahā, “Nahīṅ, terī bīwī Sārā ke hāṅ beṭā paidā hogā. Tū us kā nām Is'hāq yānī ‘Wuh Haṅstā Hai’ rakhnā. Maiṅ us ke aur us kī aulād ke sāth abadī ahd bāndhūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Maiṅ Ismāīl ke silsile meṅ bhī terī darḳhāst pūrī karūṅga. Maiṅ use bhī barkat de kar phalne-phūlne dūṅgā aur us kī aulād bahut hī zyādā baṛhā dūṅgā. Wuh bārah ra'īsoṅ kā bāp hogā, aur maiṅ us kī mārifat ek baṛī qaum banāūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Lekin merā ahd Is'hāq ke sāth hogā, jo ain ek sāl ke bād Sārā ke hāṅ paidā hogā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Allāh kī Ibrāhīm ke sāth bāt ḳhatm huī, aur wuh us ke pās se āsmān par chalā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Usī din Ibrāhīm ne Allāh kā hukm pūrā kiyā. Us ne ghar ke har ek mard kā ḳhatnā karwāyā, apne beṭe Ismāīl kā bhī aur un kā bhī jo us ke ghar meṅ rahte lekin us se rishtā nahīṅ rakhte the, chāhe wuh us ke ghar meṅ paidā hue the yā ḳharīde gae the. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibrāhīm 99 sāl kā thā jab us kā ḳhatnā huā, ");
INSERT INTO urdgvr_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","jabki us kā beṭā Ismāīl 13 sāl kā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Donoṅ kā ḳhatnā usī din huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Sāth sāth gharāne ke tamām bāqī mardoṅ kā ḳhatnā bhī huā, bashamūl un ke jin kā Ibrāhīm ke sāth rishtā nahīṅ thā, chāhe wuh ghar meṅ paidā hue yā kisī ajnabī se ḳharīde gae the. ");
INSERT INTO urdgvr_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ek din Rab Mamre ke daraḳhtoṅ ke pās Ibrāhīm par zāhir huā. Ibrāhīm apne ḳhaime ke darwāze par baiṭhā thā. Din kī garmī urūj par thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Achānak us ne dekhā ki tīn mard mere sāmne khaṛe haiṅ. Unheṅ deḳhte hī wuh ḳhaime se un se milne ke lie dauṛā aur muṅh ke bal gir kar sijdā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Us ne kahā, “Mere āqā, agar mujh par āp ke karm kī nazar hai to āge na baṛheṅ balki kuchh der apne bande ke ghar ṭhahreṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Agar ijāzat ho to maiṅ kuchh pānī le āūṅ tāki āp apne pāṅw dho kar daraḳht ke sāye meṅ ārām kar sakeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Sāth sāth maiṅ āp ke lie thoṛā-bahut khānā bhī le āūṅ tāki āp taqwiyat pā kar āge baṛh sakeṅ. Mujhe yih karne deṅ, kyoṅki āp apne ḳhādim ke ghar ā gae haiṅ.” Unhoṅ ne kahā, “Ṭhīk hai. Jo kuchh tū ne kahā hai wuh kar.” ");
INSERT INTO urdgvr_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ibrāhīm ḳhaime kī taraf dauṛ kar Sārā ke pās āyā aur kahā, “Jaldī karo! 16 kilogrām behtarīn maidā le aur use gūṅdh kar roṭiyāṅ banā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Phir wuh bhāg kar bailoṅ ke pās pahuṅchā. Un meṅ se us ne ek moṭā-tāzā bachhṛā chun liyā jis kā gosht narm thā aur use apne naukar ko diyā jis ne jaldī se use taiyār kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Jab khānā taiyār thā to Ibrāhīm ne use le kar lassī aur dūdh ke sāth apne mehmānoṅ ke āge rakh diyā. Wuh khāne lage aur Ibrāhīm un ke sāmne daraḳht ke sāye meṅ khaṛā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Unhoṅ ne pūchhā, “Terī bīwī Sārā kahāṅ hai?” Us ne jawāb diyā, “Ḳhaime meṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Rab ne kahā, “Ain ek sāl ke bād maiṅ wāpas āūṅgā to terī bīwī Sārā ke beṭā hogā.” Sārā yih bāteṅ sun rahī thī, kyoṅki wuh us ke pīchhe ḳhaime ke darwāze ke pās thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Donoṅ miyāṅ-bīwī būṛhe ho chuke the aur Sārā us umr se guzar chukī thī jis meṅ auratoṅ ke bachche paidā hote haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Is lie Sārā andar hī andar haṅs paṛī aur sochā, “Yih kaise ho saktā hai? Kyā jab maiṅ buṛhāpe ke bāis ghise-phaṭe libās kī mānind hūṅ to jawānī ke joban kā lutf uṭhāūṅ? Aur merā shauhar bhī būṛhā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Rab ne Ibrāhīm se pūchhā, “Sārā kyoṅ haṅs rahī hai? Wuh kyoṅ kah rahī hai, ‘Kyā wāqaī mere hāṅ bachchā paidā hogā jabki maiṅ itnī umrrasīdā hūṅ?’ ");
INSERT INTO urdgvr_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Kyā Rab ke lie koī kām nāmumkin hai? Ek sāl ke bād muqarrarā waqt par maiṅ wāpas āūṅgā to Sārā ke beṭā hogā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sārā ḍar gaī. Us ne jhūṭ bol kar inkār kiyā, “Maiṅ nahīṅ haṅs rahī thī.” Rab ne kahā, “Nahīṅ, tū zarūr haṅs rahī thī.” ");
INSERT INTO urdgvr_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Phir mehmān uṭh kar rawānā hue aur nīche wādī meṅ Sadūm kī taraf deḳhne lage. Ibrāhīm unheṅ ruḳhsat karne ke lie sāth sāth chal rahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Rab ne dil meṅ kahā, “Maiṅ Ibrāhīm se wuh kām kyoṅ chhupāe rakhūṅ jo maiṅ karne ke lie jā rahā hūṅ? ");
INSERT INTO urdgvr_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Isī se to ek baṛī aur tāqatwar qaum niklegī aur isī se maiṅ duniyā kī tamām qaumoṅ ko barkat dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Usī ko maiṅ ne chun liyā hai tāki wuh apnī aulād aur apne bād ke gharāne ko hukm de ki wuh Rab kī rāh par chal kar rāst aur munsifānā kām kareṅ. Kyoṅki agar wuh aisā kareṅ to Rab Ibrāhīm ke sāth apnā wādā pūrā karegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Phir Rab ne kahā, “Sadūm aur Amūrā kī badī ke bāis logoṅ kī āheṅ buland ho rahī haiṅ, kyoṅki un se bahut sangīn gunāh sarzad ho rahe haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Maiṅ utar kar un ke pās jā rahā hūṅ tāki dekhūṅ ki yih ilzām wāqaī sach haiṅ jo mujh tak pahuṅche haiṅ. Agar aisā nahīṅ hai to maiṅ yih jānanā chāhtā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Dūsre do ādmī Sadūm kī taraf āge nikle jabki Rab kuchh der ke lie wahāṅ ṭhahrā rahā aur Ibrāhīm us ke sāmne khaṛā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Phir us ne qarīb ā kar us se bāt kī, “Kyā tū rāstbāzoṅ ko bhī sharīroṅ ke sāth tabāh kar degā? ");
INSERT INTO urdgvr_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ho saktā hai ki shahr meṅ 50 rāstbāz hoṅ. Kyā tū phir bhī shahr ko barbād kar degā aur use un 50 ke sabab se muāf nahīṅ karegā? ");
INSERT INTO urdgvr_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Yih kaise ho saktā hai ki tū bequsūroṅ ko sharīroṅ ke sāth halāk kar de? Yih to nāmumkin hai ki tū nek aur sharīr logoṅ se ek jaisā sulūk kare. Kyā lāzim nahīṅ ki pūrī duniyā kā munsif insāf kare?” ");
INSERT INTO urdgvr_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Rab ne jawāb diyā, “Agar mujhe shahr meṅ 50 rāstbāz mil jāeṅ to un ke sabab se tamām ko muāf kar dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ibrāhīm ne kahā, “Maiṅ muāfī chāhtā hūṅ ki maiṅ ne Rab se bāt karne kī jurrat kī hai agarche maiṅ ḳhāk aur rākh hī hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Lekin ho saktā hai ki sirf 45 rāstbāz us meṅ hoṅ. Kyā tū phir bhī un pāṅch logoṅ kī kamī ke sabab se pūre shahr ko tabāh karegā?” Us ne kahā, “Agar mujhe 45 bhī mil jāeṅ to use barbād nahīṅ karūṅga.” ");
INSERT INTO urdgvr_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ibrāhīm ne apnī bāt jārī rakhī, “Aur agar sirf 40 nek log hoṅ to?” Rab ne kahā, “Maiṅ un 40 ke sabab se unheṅ chhoṛ dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ibrāhīm ne kahā, “Rab ġhussā na kare ki maiṅ ek dafā aur bāt karūṅ. Shāyad wahāṅ sirf 30 hoṅ.” Us ne jawāb diyā, “Phir bhī unheṅ chhoṛ dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ibrāhīm ne kahā, “Maiṅ muāfī chāhtā hūṅ ki maiṅ ne Rab se bāt karne kī jurrat kī hai. Agar sirf 20 pāe jāeṅ?” Rab ne kahā, “Maiṅ 20 ke sabab se shahr ko barbād karne se bāz rahūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ibrāhīm ne ek āḳhirī dafā bāt kī, “Rab ġhussā na kare agar maiṅ ek aur bār bāt karūṅ. Shāyad us meṅ sirf 10 pāe jāeṅ.” Rab ne kahā, “Maiṅ use un 10 logoṅ ke sabab se bhī barbād nahīṅ karūṅga.” ");
INSERT INTO urdgvr_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","In bātoṅ ke bād Rab chalā gayā aur Ibrāhīm apne ghar ko lauṭ āyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Shām ke waqt yih do farishte Sadūm pahuṅche. Lūt shahr ke darwāze par baiṭhā thā. Jab us ne unheṅ dekhā to khaṛe ho kar un se milne gayā aur muṅh ke bal gir kar sijdā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Us ne kahā, “Sāhibo, apne bande ke ghar tashrīf lāeṅ tāki apne pāṅw dho kar rāt ko ṭhahreṅ aur phir kal subah-sawere uṭh kar apnā safr jārī rakheṅ.” Unhoṅ ne kahā, “Koī bāt nahīṅ, ham chauk meṅ rāt guzāreṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lekin Lūt ne unheṅ bahut majbūr kiyā, aur āḳhirkār wuh us ke sāth us ke ghar āe. Us ne un ke lie khānā pakāyā aur beḳhamīrī roṭī banāī. Phir unhoṅ ne khānā khāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Wuh abhī sone ke lie leṭe nahīṅ the ki shahr ke jawānoṅ se le kar būṛhoṅ tak tamām mardoṅ ne Lūt ke ghar ko gher liyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Unhoṅ ne āwāz de kar Lūt se kahā, “Wuh ādmī kahāṅ haiṅ jo rāt ke waqt tere pās āe? Un ko bāhar le ā tāki ham un ke sāth harāmkārī kareṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lūt un se milne bāhar gayā. Us ne apne pīchhe darwāzā band kar liyā ");
INSERT INTO urdgvr_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","aur kahā, “Mere bhāiyo, aisā mat karo, aisī badkārī na karo. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Dekho, merī do kuṅwārī beṭiyāṅ haiṅ. Unheṅ maiṅ tumhāre pās bāhar le ātā hūṅ. Phir jo jī chāhe un ke sāth karo. Lekin in ādmiyoṅ ko chhoṛ do, kyoṅki wuh mere mehmān haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Unhoṅ ne kahā, “Rāste se haṭ jā! Dekho, yih shaḳhs jab hamāre pās āyā thā to ajnabī thā, aur ab yih ham par hākim bananā chāhtā hai. Ab tere sāth un se zyādā burā sulūk kareṅge.” Wuh use majbūr karte karte darwāze ko toṛne ke lie āge baṛhe. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Lekin ain waqt par andar ke ādmī Lūt ko pakaṛ kar andar le āe, phir darwāzā dubārā band kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Unhoṅ ne chhoṭoṅ se le kar baṛoṅ tak bāhar ke tamām ādmiyoṅ ko andhā kar diyā, aur wuh darwāze ko ḍhūṅḍte ḍhūṅḍte thak gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Donoṅ ādmiyoṅ ne Lūt se kahā, “Kyā terā koī aur rishtedār is shahr meṅ rahtā hai, masalan koī dāmād yā beṭā-beṭī? Sab ko sāth le kar yahāṅ se chalā jā, ");
INSERT INTO urdgvr_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","kyoṅki ham yih maqām tabāh karne ko haiṅ. Is ke bāshindoṅ kī badī ke bāis logoṅ kī āheṅ buland ho kar Rab ke huzūr pahuṅch gaī haiṅ, is lie us ne hameṅ is ko tabāh karne ke lie bhejā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lūt ghar se niklā aur apne dāmādoṅ se bāt kī jin kā us kī beṭiyoṅ ke sāth rishtā ho chukā thā. Us ne kahā, “Jaldī karo, is jagah se niklo, kyoṅki Rab is shahr ko tabāh karne ko hai.” Lekin us ke dāmādoṅ ne ise mazāq hī samjhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Jab pau phaṭne lagī to donoṅ ādmiyoṅ ne Lūt ko bahut samjhāyā aur kahā, “Jaldī kar! Apnī bīwī aur donoṅ beṭiyoṅ ko sāth le kar chalā jā, warnā jab shahr ko sazā dī jāegī to tū bhī halāk ho jāegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","To bhī wuh jhijaktā rahā. Āḳhirkār donoṅ ne Lūt, us kī bīwī aur beṭiyoṅ ke hāth pakaṛ kar unheṅ shahr ke bāhar tak pahuṅchā diyā, kyoṅki Rab ko Lūt par tars ātā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Jyoṅ hī wuh unheṅ bāhar le āe un meṅ se ek ne kahā, “Apnī jān bachā kar chalā jā. Pīchhe muṛ kar na deḳhnā. Maidān meṅ kahīṅ na ṭhaharnā balki pahāṛoṅ meṅ panāh lenā, warnā tū halāk ho jāegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lekin Lūt ne un se kahā, “Nahīṅ mere āqā, aisā na ho. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Tere bande ko terī nazar-e-karm hāsil huī hai aur tū ne merī jān bachāne meṅ bahut mehrbānī kar dikhāī hai. Lekin maiṅ pahāṛoṅ meṅ panāh nahīṅ le saktā. Wahāṅ pahuṅchne se pahle yih musībat mujh par ān paṛegī aur maiṅ halāk ho jāūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Dekh, qarīb hī ek chhoṭā qasbā hai. Wuh itnā nazdīk hai ki maiṅ us taraf hijrat kar saktā hūṅ. Mujhe wahāṅ panāh lene de. Wuh chhoṭā hī hai, nā? Phir merī jān bachegī.” ");
INSERT INTO urdgvr_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Us ne kahā, “Chalo, ṭhīk hai. Terī yih darḳhāst bhī manzūr hai. Maiṅ yih qasbā tabāh nahīṅ karūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Lekin bhāg kar wahāṅ panāh le, kyoṅki jab tak tū wahāṅ pahuṅch na jāe maiṅ kuchh nahīṅ kar saktā.” Is lie qasbe kā nām Zuġhar yānī Chhoṭā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Jab Lūt Zuġhar pahuṅchā to sūraj niklā huā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tab Rab ne āsmān se Sadūm aur Amūrā par gandhak aur āg barsāī. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Yoṅ us ne us pūre maidān ko us ke shahroṅ, bāshindoṅ aur tamām hariyālī samet tabāh kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lekin farār hote waqt Lūt kī bīwī ne pīchhe muṛ kar dekhā to wuh fauran namak kā satūn ban gaī. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ibrāhīm subah-sawere uṭh kar us jagah wāpas āyā jahāṅ wuh kal Rab ke sāmne khaṛā huā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Jab us ne nīche Sadūm, Amūrā aur pūrī wādī kī taraf nazar kī to wahāṅ se bhaṭṭe kā-sā dhuāṅ uṭh rahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Yoṅ Allāh ne Ibrāhīm ko yād kiyā jab us ne us maidān ke shahr tabāh kie. Kyoṅki wuh unheṅ tabāh karne se pahle Lūt ko jo un meṅ ābād thā wahāṅ se nikāl lāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lūt aur us kī beṭiyāṅ zyādā der tak Zuġhar meṅ na ṭhahre. Wuh rawānā ho kar pahāṛoṅ meṅ ābād hue, kyoṅki Lūt Zuġhar meṅ rahne se ḍartā thā. Wahāṅ unhoṅ ne ek ġhār ko apnā ghar banā liyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ek din baṛī beṭī ne chhoṭī se kahā, “Abbū būṛhā hai aur yahāṅ koī mard hai nahīṅ jis ke zariye hamāre bachche paidā ho sakeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Āo, ham Abbū ko mai pilāeṅ. Jab wuh nashe meṅ dhut ho to ham us ke sāth hambistar ho kar apne lie aulād paidā kareṅ tāki hamārī nasl qāym rahe.” ");
INSERT INTO urdgvr_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Us rāt unhoṅ ne apne bāp ko mai pilāī. Jab wuh nashe meṅ thā to baṛī beṭī andar jā kar us ke sāth hambistar huī. Chūṅki Lūt hosh meṅ nahīṅ thā is lie use kuchh bhī mālūm na huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Agle din baṛī bahan ne chhoṭī bahan se kahā, “Pichhlī rāt maiṅ Abbū se hambistar huī. Āo, āj rāt ko ham use dubārā mai pilāeṅ. Jab wuh nashe meṅ dhut ho to tum us ke sāth hambistar ho kar apne lie aulād paidā karnā tāki hamārī nasl qāym rahe.” ");
INSERT INTO urdgvr_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Chunāṅche unhoṅ ne us rāt bhī apne bāp ko mai pilāī. Jab wuh nashe meṅ thā to chhoṭī beṭī uṭh kar us ke sāth hambistar huī. Is bār bhī wuh hosh meṅ nahīṅ thā, is lie use kuchh bhī mālūm na huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Yoṅ Lūt kī beṭiyāṅ apne bāp se ummīd se huīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Baṛī beṭī ke hāṅ beṭā paidā huā. Us ne us kā nām Moāb rakhā. Us se Moābī nikle haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Chhoṭī beṭī ke hāṅ bhī beṭā paidā huā. Us ne us kā nām Bin-ammī rakhā. Us se Ammonī nikle haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ibrāhīm wahāṅ se junūb kī taraf Dasht-e-Najab meṅ chalā gayā aur Qādis aur Shūr ke darmiyān jā basā. Kuchh der ke lie wuh Jirār meṅ ṭhahrā, lekin ajnabī kī haisiyat se. ");
INSERT INTO urdgvr_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Wahāṅ us ne logoṅ ko batāyā, “Sārā merī bahan hai.” Is lie Jirār ke bādshāh Abīmalik ne kisī ko bhijwā diyā ki use mahal meṅ le āe. ");
INSERT INTO urdgvr_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Lekin rāt ke waqt Allāh ḳhāb meṅ Abīmalik par zāhir huā aur kahā, “Maut tere sar par khaṛī hai, kyoṅki jo aurat tū apne ghar le āyā hai wuh shādīshudā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Asal meṅ Abīmalik abhī tak Sārā ke qarīb nahīṅ gayā thā. Us ne kahā, “Mere āqā, kyā tū ek bequsūr qaum ko bhī halāk karegā? ");
INSERT INTO urdgvr_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Kyā Ibrāhīm ne mujh se nahīṅ kahā thā ki Sārā merī bahan hai? Aur Sārā ne us kī hāṅ meṅ hāṅ milāī. Merī nīyat achchhī thī aur maiṅ ne ġhalat kām nahīṅ kiyā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Allāh ne kahā, “Hāṅ, maiṅ jāntā hūṅ ki is meṅ terī nīyat achchhī thī. Is lie maiṅ ne tujhe merā gunāh karne aur use chhūne se rok diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ab us aurat ko us ke shauhar ko wāpas kar de, kyoṅki wuh nabī hai aur tere lie duā karegā. Phir tū nahīṅ maregā. Lekin agar tū use wāpas nahīṅ karegā to jān le ki terī aur tere logoṅ kī maut yaqīnī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abīmalik ne subah-sawere uṭh kar apne tamām kārindoṅ ko yih sab kuchh batāyā. Yih sun kar un par dahshat chhā gaī. ");
INSERT INTO urdgvr_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Phir Abīmalik ne Ibrāhīm ko bulā kar kahā, “Āp ne hamāre sāth kyā kiyā hai? Maiṅ ne āp ke sāth kyā ġhalat kām kiyā ki āp ne mujhe aur merī saltanat ko itne sangīn jurm meṅ phaṅsā diyā hai? Jo sulūk āp ne hamāre sāth kar dikhāyā hai wuh kisī bhī shaḳhs ke sāth nahīṅ karnā chāhie. ");
INSERT INTO urdgvr_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Āp ne yih kyoṅ kiyā?” ");
INSERT INTO urdgvr_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibrāhīm ne jawāb diyā, “Maiṅ ne apne dil meṅ kahā ki yahāṅ ke log Allāh kā ḳhauf nahīṅ rakhte hoṅge, is lie wuh merī bīwī ko hāsil karne ke lie mujhe qatl kar deṅge. ");
INSERT INTO urdgvr_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Haqīqat meṅ wuh merī bahan bhī hai. Wuh mere bāp kī beṭī hai agarche us kī aur merī māṅ farq haiṅ. Yoṅ maiṅ us se shādī kar sakā. ");
INSERT INTO urdgvr_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Phir jab Allāh ne hone diyā ki maiṅ apne bāp ke gharāne se nikal kar idhar-udhar phirūṅ to maiṅ ne apnī bīwī se kahā, ‘Mujh par yih mehrbānī kar ki jahāṅ bhī ham jāeṅ mere bāre meṅ kah denā ki wuh merā bhāī hai.’” ");
INSERT INTO urdgvr_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Phir Abīmalik ne Ibrāhīm ko bheṛ-bakriyāṅ, gāy-bail, ġhulām aur launḍiyāṅ de kar us kī bīwī Sārā ko use wāpas kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Us ne kahā, “Merā mulk āp ke lie khulā hai. Jahāṅ jī chāhe us meṅ jā baseṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Sārā se us ne kahā, “Maiṅ āp ke bhāī ko chāṅdī ke hazār sikke detā hūṅ. Is se āp aur āp ke logoṅ ke sāmne āp ke sāth kie gae nārawā sulūk kā izālā ho aur āp ko bequsūr qarār diyā jāe.” ");
INSERT INTO urdgvr_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Tab Ibrāhīm ne Allāh se duā kī aur Allāh ne Abīmalik, us kī bīwī aur us kī launḍiyoṅ ko shafā dī, kyoṅki Rab ne Abīmalik ke gharāne kī tamām auratoṅ ko Sārā ke sabab se bāṅjh banā diyā thā. Lekin ab un ke hāṅ dubārā bachche paidā hone lage. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Tab Rab ne Sārā ke sāth waisā hī kiyā jaisā us ne farmāyā thā. Jo wādā us ne Sārā ke bāre meṅ kiyā thā use us ne pūrā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Wuh hāmilā huī aur beṭā paidā huā. Ain us waqt būṛhe Ibrāhīm ke hāṅ beṭā paidā huā jo Allāh ne muqarrar karke use batāyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibrāhīm ne apne is beṭe kā nām Is'hāq yānī ‘Wuh Haṅstā Hai’ rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Jab Is'hāq āṭh din kā thā to Ibrāhīm ne us kā ḳhatnā karāyā, jis tarah Allāh ne use hukm diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Jab Is'hāq paidā huā us waqt Ibrāhīm 100 sāl kā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sārā ne kahā, “Allāh ne mujhe haṅsāyā, aur har koī jo mere bāre meṅ yih sunegā haṅsegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Is se pahle kaun Ibrāhīm se yih kahne kī jurrat kar saktā thā ki Sārā apne bachchoṅ ko dūdh pilāegī? Aur ab mere hāṅ beṭā paidā huā hai, agarche Ibrāhīm būṛhā ho gayā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Is'hāq baṛā hotā gayā. Jab us kā dūdh chhuṛāyā gayā to Ibrāhīm ne us ke lie baṛī ziyāfat kī. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ek din Sārā ne dekhā ki Misrī launḍī Hājirā kā beṭā Ismāīl Is'hāq kā mazāq uṛā rahā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Us ne Ibrāhīm se kahā, “Is launḍī aur us ke beṭe ko ghar se nikāl deṅ, kyoṅki wuh mere beṭe Is'hāq ke sāth mīrās nahīṅ pāegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ibrāhīm ko yih bāt bahut burī lagī. Āḳhir Ismāīl bhī us kā beṭā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Lekin Allāh ne us se kahā, “Jo bāt Sārā ne apnī launḍī aur us ke beṭe ke bāre meṅ kahī hai wuh tujhe burī na lage. Sārā kī bāt mān le, kyoṅki terī nasl Is'hāq hī se qāym rahegī. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Lekin maiṅ Ismāīl se bhī ek qaum banāūṅgā, kyoṅki wuh terā beṭā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ibrāhīm subah-sawere uṭhā. Us ne roṭī aur pānī kī mashk Hājirā ke kandhoṅ par rakh kar use laṛke ke sāth ghar se nikāl diyā. Hājirā chalte chalte Bair-sabā ke registān meṅ idhar-udhar phirne lagī. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Phir pānī ḳhatm ho gayā. Hājirā laṛke ko kisī jhāṛī ke nīche chhoṛ kar ");
INSERT INTO urdgvr_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","koī 300 fuṭ dūr baiṭh gaī. Kyoṅki us ne dil meṅ kahā, “Maiṅ use marte nahīṅ dekh saktī.” Wuh wahāṅ baiṭh kar rone lagī. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Lekin Allāh ne beṭe kī rotī huī āwāz sun lī. Allāh ke farishte ne āsmān par se pukār kar Hājirā se bāt kī, “Hājirā, kyā bāt hai? Mat ḍar, kyoṅki Allāh ne laṛke kā jo wahāṅ paṛā hai ronā sun liyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Uṭh, laṛke ko uṭhā kar us kā hāth thām le, kyoṅki maiṅ us se ek baṛī qaum banāūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Phir Allāh ne Hājirā kī āṅkheṅ khol dīṅ, aur us kī nazar ek kueṅ par paṛī. Wuh wahāṅ gaī aur mashk ko pānī se bhar kar laṛke ko pilāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Allāh laṛke ke sāth thā. Wuh jawān huā aur tīrandāz ban kar bayābān meṅ rahne lagā. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Jab wuh Fārān ke registān meṅ rahtā thā to us kī māṅ ne use ek Misrī aurat se byāh diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Un dinoṅ meṅ Abīmalik aur us ke sipāhsālār Fīkul ne Ibrāhīm se kahā, “Jo kuchh bhī āp karte haiṅ Allāh āp ke sāth hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ab mujh se Allāh kī qasam khāeṅ ki āp mujhe aur merī āl-o-aulād ko dhokā nahīṅ deṅge. Mujh par aur is mulk par jis meṅ āp pardesī haiṅ wuhī mehrbānī kareṅ jo maiṅ ne āp par kī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ibrāhīm ne jawāb diyā, “Maiṅ qasam khātā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Phir us ne Abīmalik se shikāyat karte hue kahā, “Āp ke bandoṅ ne hamāre ek kueṅ par qabzā kar liyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abīmalik ne kahā, “Mujhe nahīṅ mālūm ki kis ne aisā kiyā hai. Āp ne bhī mujhe nahīṅ batāyā. Āj maiṅ pahlī dafā yih bāt sun rahā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Tab Ibrāhīm ne Abīmalik ko bheṛ-bakriyāṅ aur gāy-bail die, aur donoṅ ne ek dūsre ke sāth ahd bāndhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Phir Ibrāhīm ne bheṛ ke sāt mādā bachchoṅ ko alag kar liyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abīmalik ne pūchhā, “Āp ne yih kyoṅ kiyā?” ");
INSERT INTO urdgvr_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ibrāhīm ne jawāb diyā, “Bheṛ ke in sāt bachchoṅ ko mujh se le leṅ. Yih is ke gawāh hoṅ ki maiṅ ne is kueṅ ko khodā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Is lie us jagah kā nām Bair-sabā yānī ‘Qasam kā Kuāṅ’ rakhā gayā, kyoṅki wahāṅ un donoṅ mardoṅ ne qasam khāī. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Yoṅ unhoṅ ne Bair-sabā meṅ ek dūsre se ahd bāndhā. Phir Abīmalik aur Fīkul Filistiyoṅ ke mulk wāpas chale gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Is ke bād Ibrāhīm ne Bair-sabā meṅ jhāū kā daraḳht lagāyā. Wahāṅ us ne Rab kā nām le kar us kī ibādat kī jo abadī Ḳhudā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ibrāhīm bahut arse tak Filistiyoṅ ke mulk meṅ ābād rahā, lekin ajnabī kī haisiyat se. ");
INSERT INTO urdgvr_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Kuchh arse ke bād Allāh ne Ibrāhīm ko āzmāyā. Us ne us se kahā, “Ibrāhīm!” Us ne jawāb diyā, “Jī, maiṅ hāzir hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Allāh ne kahā, “Apne iklaute beṭe Is'hāq ko jise tū pyār kartā hai sāth le kar Moriyāh ke ilāqe meṅ chalā jā. Wahāṅ maiṅ tujhe ek pahāṛ dikhāūṅgā. Us par apne beṭe ko qurbān kar de. Use zabah karke qurbāngāh par jalā denā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Subah-sawere Ibrāhīm uṭhā aur apne gadhe par zīn kasā. Us ne apne sāth do naukaroṅ aur apne beṭe Is'hāq ko liyā. Phir wuh qurbānī ko jalāne ke lie lakaṛī kāṭ kar us jagah kī taraf rawānā huā jo Allāh ne use batāī thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Safr karte karte tīsre din qurbānī kī jagah Ibrāhīm ko dūr se nazar āī. ");
INSERT INTO urdgvr_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Us ne naukaroṅ se kahā, “Yahāṅ gadhe ke pās ṭhahro. Maiṅ laṛke ke sāth wahāṅ jā kar parastish karūṅga. Phir ham tumhāre pās wāpas ā jāeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ibrāhīm ne qurbānī ko jalāne ke lie lakaṛiyāṅ Is'hāq ke kandhoṅ par rakh dīṅ aur ḳhud chhurī aur āg jalāne ke lie angāroṅ kā bartan uṭhāyā. Donoṅ chal die. ");
INSERT INTO urdgvr_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Is'hāq bolā, “Abbū!” Ibrāhīm ne kahā, “Jī beṭā.” “Abbū, āg aur lakaṛiyāṅ to hamāre pās haiṅ, lekin qurbānī ke lie bheṛ yā bakrī kahāṅ hai?” ");
INSERT INTO urdgvr_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ibrāhīm ne jawāb diyā, “Allāh ḳhud qurbānī ke lie jānwar muhaiyā karegā, beṭā.” Wuh āge baṛh gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Chalte chalte wuh us maqām par pahuṅche jo Allāh ne us par zāhir kiyā thā. Ibrāhīm ne wahāṅ qurbāngāh banāī aur us par lakaṛiyāṅ tartīb se rakh dīṅ. Phir us ne Is'hāq ko bāndh kar lakaṛiyoṅ par rakh diyā ");
INSERT INTO urdgvr_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","aur chhurī pakaṛ lī tāki apne beṭe ko zabah kare. ");
INSERT INTO urdgvr_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ain usī waqt Rab ke farishte ne āsmān par se use āwāz dī, “Ibrāhīm, Ibrāhīm!” Ibrāhīm ne kahā, “Jī, maiṅ hāzir hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Farishte ne kahā, “Apne beṭe par hāth na chalā, na us ke sāth kuchh kar. Ab maiṅ ne jān liyā hai ki tū Allāh kā ḳhauf rakhtā hai, kyoṅki tū apne iklaute beṭe ko bhī mujhe dene ke lie taiyār hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Achānak Ibrāhīm ko ek menḍhā nazar āyā jis ke sīṅg gunjān jhāṛiyoṅ meṅ phaṅse hue the. Ibrāhīm ne use zabah karke apne beṭe kī jagah qurbānī ke taur par jalā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Us ne us maqām kā nām “Rab muhaiyā kartā hai” rakhā. Is lie āj tak kahā jātā hai, “Rab ke pahāṛ par muhaiyā kiyā jātā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Rab ke farishte ne ek bār phir āsmān par se pukār kar us se bāt kī. ");
INSERT INTO urdgvr_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Rab kā farmān hai, merī zāt kī qasam, chūṅki tū ne yih kiyā aur apne iklaute beṭe ko mujhe pesh karne ke lie taiyār thā ");
INSERT INTO urdgvr_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","is lie maiṅ tujhe barkat dūṅgā aur terī aulād ko āsmān ke sitāroṅ aur sāhil kī ret kī tarah beshumār hone dūṅgā. Terī aulād apne dushmanoṅ ke shahroṅ ke darwāzoṅ par qabzā karegī. ");
INSERT INTO urdgvr_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Chūṅki tū ne merī sunī is lie terī aulād se duniyā kī tamām qaumeṅ barkat pāeṅgī.” ");
INSERT INTO urdgvr_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Is ke bād Ibrāhīm apne naukaroṅ ke pās wāpas āyā, aur wuh mil kar Bair-sabā lauṭe. Wahāṅ Ibrāhīm ābād rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","In wāqiyāt ke bād Ibrāhīm ko ittalā milī, “Āp ke bhāī Nahūr kī bīwī Milkāh ke hāṅ bhī beṭe paidā hue haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Us ke pahlauṭhe Ūz ke bād Būz, Qamuel (Arām kā bāp), ");
INSERT INTO urdgvr_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kasad, Hazū, Fildās, Idlāf aur Batuel paidā hue haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Milkāh aur Nahūr ke hāṅ yih āṭh beṭe paidā hue. (Batuel Ribqā kā bāp thā.) ");
INSERT INTO urdgvr_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahūr kī haram kā nām Rūmā thā. Us ke hāṅ bhī beṭe paidā hue jin ke nām Tibaḳh, Jāham, Taḳhas aur Mākā haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sārā 127 sāl kī umr meṅ Habrūn meṅ intaqāl kar gaī. ");
INSERT INTO urdgvr_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Us zamāne meṅ Habrūn kā nām Qiriyat-arbā thā, aur wuh Mulk-e-Kanān meṅ thā. Ibrāhīm ne us ke pās ā kar mātam kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Phir wuh janāze ke pās se uṭhā aur Hittiyoṅ se bāt kī. Us ne kahā, ");
INSERT INTO urdgvr_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Maiṅ āp ke darmiyān pardesī aur ġhairshahrī kī haisiyat se rahtā hūṅ. Mujhe qabr ke lie zamīn becheṅ tāki apnī bīwī ko apne ghar se le jā kar dafn kar sakūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Hittiyoṅ ne jawāb diyā, “Hamāre āqā, hamārī bāt suneṅ! Āp hamāre darmiyān Allāh ke ra'īs haiṅ. Apnī bīwī ko hamārī behtarīn qabr meṅ dafn kareṅ. Ham meṅ se koī nahīṅ jo āp se apnī qabr kā inkār karegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ibrāhīm uṭhā aur mulk ke bāshindoṅ yānī Hittiyoṅ ke sāmne tāzīman jhuk gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Us ne kahā, “Agar āp is ke lie taiyār haiṅ ki maiṅ apnī bīwī ko apne ghar se le jā kar dafn karūṅ to Suhar ke beṭe Ifron se merī sifārish kareṅ ");
INSERT INTO urdgvr_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ki wuh mujhe Makfīlā kā ġhār bech de. Wuh us kā hai aur us ke khet ke kināre par hai. Maiṅ us kī pūrī qīmat dene ke lie taiyār hūṅ tāki āp ke darmiyān rahte hue mere pās qabr bhī ho.” ");
INSERT INTO urdgvr_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ifron Hittiyoṅ kī jamāt meṅ maujūd thā. Ibrāhīm kī darḳhāst par us ne un tamām Hittiyoṅ ke sāmne jo shahr ke darwāze par jamā the jawāb diyā, ");
INSERT INTO urdgvr_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Nahīṅ, mere āqā! Merī bāt suneṅ. Maiṅ āp ko yih khet aur us meṅ maujūd ġhār de detā hūṅ. Sab jo hāzir haiṅ mere gawāh haiṅ, maiṅ yih āp ko detā hūṅ. Apnī bīwī ko wahāṅ dafn kar deṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ibrāhīm dubārā mulk ke bāshindoṅ ke sāmne adaban jhuk gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Us ne sab ke sāmne Ifron se kahā, “Mehrbānī karke merī bāt par ġhaur kareṅ. Maiṅ khet kī pūrī qīmat adā karūṅga. Use qabūl kareṅ tāki wahāṅ apnī bīwī ko dafn kar sakūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Ifron ne jawāb diyā, “Mere āqā, suneṅ. Is zamīn kī qīmat sirf 400 chāṅdī ke sikke hai. Āp ke aur mere darmiyān yih kyā hai? Apnī bīwī ko dafn kar deṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibrāhīm ne Ifron kī matlūbā qīmat mān lī aur sab ke sāmne chāṅdī ke 400 sikke tol kar Ifron ko de die. Is ke lie us ne us waqt ke rāyj bāṭ istemāl kie. ");
INSERT INTO urdgvr_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Chunāṅche Makfīlā meṅ Ifron kī zamīn Ibrāhīm kī milkiyat ho gaī. Yih zamīn Mamre ke mashriq meṅ thī. Us meṅ khet, khet kā ġhār aur khet kī hudūd meṅ maujūd tamām daraḳht shāmil the. ");
INSERT INTO urdgvr_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Hittiyoṅ kī pūrī jamāt ne jo shahr ke darwāze par jamā thī zamīn ke intaqāl kī tasdīq kī. ");
INSERT INTO urdgvr_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Phir Ibrāhīm ne apnī bīwī Sārā ko Mulk-e-Kanān ke us ġhār meṅ dafn kiyā jo Mamre yānī Habrūn ke mashriq meṅ wāqe Makfīlā ke khet meṅ thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Is tarīqe se yih khet aur us kā ġhār Hittiyoṅ se Ibrāhīm ke nām par muntaqil kar diyā gayā tāki us ke pās qabr ho. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibrāhīm ab bahut būṛhā ho gayā thā. Rab ne use har lihāz se barkat dī thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ek din us ne apne ghar ke sab se buzurg naukar se jo us kī jāydād kā pūrā intazām chalātā thā bāt kī. “Qasam ke lie apnā hāth merī rān ke nīche rakho. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Rab kī qasam khāo jo āsmān-o-zamīn kā Ḳhudā hai ki tum in Kanāniyoṅ meṅ se jin ke darmiyān maiṅ rahtā hūṅ mere beṭe ke lie bīwī nahīṅ lāoge ");
INSERT INTO urdgvr_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","balki mere watan meṅ mere rishtedāroṅ ke pās jāoge aur unhīṅ meṅ se mere beṭe ke lie bīwī lāoge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Us ke naukar ne kahā, “Shāyad wuh aurat mere sāth yahāṅ ānā na chāhe. Kyā maiṅ is sūrat meṅ āp ke beṭe ko us watan meṅ wāpas le jāūṅ jis se āp nikle haiṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibrāhīm ne kahā, “Ḳhabardār! Use hargiz wāpas na le jānā. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Rab jo āsmān kā Ḳhudā hai apnā farishtā tumhāre āge bhejegā, is lie tum wahāṅ mere beṭe ke lie bīwī chunane meṅ zarūr kāmyāb hoge. Kyoṅki wuhī mujhe mere bāp ke ghar aur mere watan se yahāṅ le āyā hai, aur usī ne qasam khā kar mujh se wādā kiyā hai ki maiṅ Kanān kā yih mulk terī aulād ko dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Agar wahāṅ kī aurat yahāṅ ānā na chāhe to phir tum apnī qasam se āzād hoge. Lekin kisī sūrat meṅ bhī mere beṭe ko wahāṅ wāpas na le jānā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ibrāhīm ke naukar ne apnā hāth us kī rān ke nīche rakh kar qasam khāī ki maiṅ sab kuchh aisā hī karūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Phir wuh apne āqā ke das ūṅṭoṅ par qīmtī tohfe lād kar Masoputāmiyā kī taraf rawānā huā. Chalte chalte wuh Nahūr ke shahr pahuṅch gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Us ne ūṅṭoṅ ko shahr ke bāhar kueṅ ke pās biṭhāyā. Shām kā waqt thā jab aurateṅ kueṅ ke pās ā kar pānī bhartī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Phir us ne duā kī, “Ai Rab mere āqā Ibrāhīm ke Ḳhudā, mujhe āj kāmyābī baḳhsh aur mere āqā Ibrāhīm par mehrbānī kar. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ab maiṅ is chashme par khaṛā hūṅ, aur shahr kī beṭiyāṅ pānī bharne ke lie ā rahī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Maiṅ un meṅ se kisī se kahūṅgā, ‘Zarā apnā ghaṛā nīche karke mujhe pānī pilāeṅ.’ Agar wuh jawāb de, ‘Pī leṅ, maiṅ āp ke ūṅṭoṅ ko bhī pānī pilā detī hūṅ,’ to wuh wuhī hogī jise tū ne apne ḳhādim Is'hāq ke lie chun rakhā hai. Agar aisā huā to maiṅ jān lūṅgā ki tū ne mere āqā par mehrbānī kī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Wuh abhī duā kar hī rahā thā ki Ribqā shahr se nikal āī. Us ke kandhe par ghaṛā thā. Wuh Batuel kī beṭī thī. (Batuel Ibrāhīm ke bhāī Nahūr kī bīwī Milkāh kā beṭā thā.) ");
INSERT INTO urdgvr_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ribqā nihāyat ḳhūbsūrat jawān laṛkī thī, aur wuh kuṅwārī bhī thī. Wuh chashme tak utrī, apnā ghaṛā bharā aur phir wāpas ūpar āī. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ibrāhīm kā naukar dauṛ kar us se milā. Us ne kahā, “Zarā mujhe apne ghaṛe se thoṛā-sā pānī pilāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ribqā ne kahā, “Janāb, pī leṅ.” Jaldī se us ne apne ghaṛe ko kandhe par se utār kar hāth meṅ pakaṛā tāki wuh pī sake. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Jab wuh pīne se fāriġh huā to Ribqā ne kahā, “Maiṅ āp ke ūṅṭoṅ ke lie bhī pānī le ātī hūṅ. Wuh bhī pūre taur par apnī pyās bujhāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Jaldī se us ne apne ghaṛe kā pānī hauz meṅ unḍel diyā aur phir bhāg kar kueṅ se itnā pānī lātī rahī ki tamām ūṅṭoṅ kī pyās bujh gaī. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Itne meṅ Ibrāhīm kā ādmī ḳhāmoshī se use deḳhtā rahā, kyoṅki wuh jānanā chāhtā thā ki kyā Rab mujhe safr kī kāmyābī baḳhshegā yā nahīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ūṅṭ pānī pīne se fāriġh hue to us ne Ribqā ko sone kī ek nath aur do kangan die. Nath kā taqrīban 6 grām thā aur kanganoṅ kā 120 grām. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Us ne pūchhā, “Āp kis kī beṭī haiṅ? Kyā us ke hāṅ itnī jagah hai ki ham wahāṅ rāt guzār sakeṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ribqā ne jawāb diyā, “Merā bāp Batuel hai. Wuh Nahūr aur Milkāh kā beṭā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Hamāre pās bhūsā aur chārā hai. Rāt guzārne ke lie bhī kāfī jagah hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Yih sun kar Ibrāhīm ke naukar ne Rab ko sijdā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Us ne kahā, “Mere āqā Ibrāhīm ke Ḳhudā kī tamjīd ho jis ke karm aur wafādārī ne mere āqā ko nahīṅ chhoṛā. Rab ne mujhe sīdhā mere mālik ke rishtedāroṅ tak pahuṅchāyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Laṛkī bhāg kar apnī māṅ ke ghar chalī gaī. Wahāṅ us ne sab kuchh batā diyā jo huā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Jab Ribqā ke bhāī Lāban ne nath aur bahan kī kalāiyoṅ meṅ kanganoṅ ko dekhā aur wuh sab kuchh sunā jo Ibrāhīm ke naukar ne Ribqā ko batāyā thā to wuh fauran kueṅ kī taraf dauṛā. Ibrāhīm kā naukar ab tak ūṅṭoṅ samet wahāṅ khaṛā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Lāban ne kahā, “Rab ke mubārak bande, mere sāth āeṅ. Āp yahāṅ shahr ke bāhar kyoṅ khaṛe haiṅ? Maiṅ ne apne ghar meṅ āp ke lie sab kuchh taiyār kiyā hai. Āp ke ūṅṭoṅ ke lie bhī kāfī jagah hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Wuh naukar ko le kar ghar pahuṅchā. Ūṅṭoṅ se sāmān utārā gayā, aur un ko bhūsā aur chārā diyā gayā. Pānī bhī lāyā gayā tāki Ibrāhīm kā naukar aur us ke ādmī apne pāṅw dhoeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Lekin jab khānā ā gayā to Ibrāhīm ke naukar ne kahā, “Is se pahle ki maiṅ khānā khāūṅ lāzim hai ki apnā muāmalā pesh karūṅ.” Lāban ne kahā, “Batāeṅ apnī bāt.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Us ne kahā, “Maiṅ Ibrāhīm kā naukar hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Rab ne mere āqā ko bahut barkat dī hai. Wuh bahut amīr ban gayā hai. Rab ne use kasrat se bheṛ-bakriyāṅ, gāy-bail, sonā-chāṅdī, ġhulām aur launḍiyāṅ, ūṅṭ aur gadhe die haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Jab mere mālik kī bīwī būṛhī ho gaī thī to us ke beṭā paidā huā thā. Ibrāhīm ne use apnī pūrī milkiyat de dī hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Lekin mere āqā ne mujh se kahā, ‘Qasam khāo ki tum in Kanāniyoṅ meṅ se jin ke darmiyān maiṅ rahtā hūṅ mere beṭe ke lie bīwī nahīṅ lāoge ");
INSERT INTO urdgvr_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","balki mere bāp ke gharāne aur mere rishtedāroṅ ke pās jā kar us ke lie bīwī lāoge.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Maiṅ ne apne mālik se kahā, ‘Shāyad wuh aurat mere sāth ānā na chāhe.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Us ne kahā, ‘Rab jis ke sāmne maiṅ chaltā rahā hūṅ apne farishte ko tumhāre sāth bhejegā aur tumheṅ kāmyābī baḳhshegā. Tumheṅ zarūr mere rishtedāroṅ aur mere bāp ke gharāne se mere beṭe ke lie bīwī milegī. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Lekin agar tum mere rishtedāroṅ ke pās jāo aur wuh inkār kareṅ to phir tum apnī qasam se āzād hoge.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Āj jab maiṅ kueṅ ke pās āyā to maiṅ ne duā kī, ‘Ai Rab, mere āqā ke Ḳhudā, agar terī marzī ho to mujhe is mishan meṅ kāmyābī baḳhsh jis ke lie maiṅ yahāṅ āyā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ab maiṅ is kueṅ ke pās khaṛā hūṅ. Jab koī jawān aurat shahr se nikal kar yahāṅ āe to maiṅ us se kahūṅgā, “Zarā mujhe apne ghaṛe se thoṛā-sā pānī pilāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Agar wuh kahe, “Pī leṅ, maiṅ āp ke ūṅṭoṅ ke lie bhī pānī le āūṅgī” to is kā matlab yih ho ki tū ne use mere āqā ke beṭe ke lie chun liyā hai ki us kī bīwī ban jāe.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Maiṅ abhī dil meṅ yih duā kar rahā thā ki Ribqā shahr se nikal āī. Us ke kandhe par ghaṛā thā. Wuh chashme tak utrī aur apnā ghaṛā bhar liyā. Maiṅ ne us se kahā, ‘Zarā mujhe pānī pilāeṅ.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Jawāb meṅ us ne jaldī se apne ghaṛe ko kandhe par se utār kar kahā, ‘Pī leṅ, maiṅ āp ke ūṅṭoṅ ko bhī pānī pilātī hūṅ.’ Maiṅ ne pānī piyā, aur us ne ūṅṭoṅ ko bhī pānī pilāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Phir maiṅ ne us se pūchhā, ‘Āp kis kī beṭī haiṅ?’ Us ne jawāb diyā, ‘Merā bāp Batuel hai. Wuh Nahūr aur Milkāh kā beṭā hai.’ Phir maiṅ ne us kī nāk meṅ nath aur us kī kalāiyoṅ meṅ kangan pahnā die. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Tab maiṅ ne Rab ko sijdā karke apne āqā Ibrāhīm ke Ḳhudā kī tamjīd kī jis ne mujhe sīdhā mere mālik kī bhatījī tak pahuṅchāyā tāki wuh Is'hāq kī bīwī ban jāe. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ab mujhe batāeṅ, kyā āp mere āqā par apnī mehrbānī aur wafādārī kā izhār karnā chāhte haiṅ? Agar aisā hai to Ribqā kī Is'hāq ke sāth shādī qabūl kareṅ. Agar āp muttafiq nahīṅ haiṅ to mujhe batāeṅ tāki maiṅ koī aur qadam uṭhā sakūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Lāban aur Batuel ne jawāb diyā, “Yih bāt Rab kī taraf se hai, is lie ham kisī tarah bhī inkār nahīṅ kar sakte. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ribqā āp ke sāmne hai. Use le jāeṅ. Wuh āp ke mālik ke beṭe kī bīwī ban jāe jis tarah Rab ne farmāyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Yih sun kar Ibrāhīm ke naukar ne Rab ko sijdā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Phir us ne sone aur chāṅdī ke zewarāt aur mahange malbūsāt apne sāmān meṅ se nikāl kar Ribqā ko die. Ribqā ke bhāī aur māṅ ko bhī qīmtī tohfe mile. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Is ke bād us ne apne hamsafroṅ ke sāth shām kā khānā khāyā. Wuh rāt ko wahīṅ ṭhahre. Agle din jab uṭhe to naukar ne kahā, “Ab hameṅ ijāzat deṅ tāki apne āqā ke pās lauṭ jāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ribqā ke bhāī aur māṅ ne kahā, “Ribqā kuchh din aur hamāre hāṅ ṭhahre. Phir āp jāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Lekin us ne un se kahā, “Ab der na kareṅ, kyoṅki Rab ne mujhe mere mishan meṅ kāmyābī baḳhshī hai. Mujhe ijāzat deṅ tāki apne mālik ke pās wāpas jāūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Unhoṅ ne kahā, “Chaleṅ, ham laṛkī ko bulā kar usī se pūchh lete haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Unhoṅ ne Ribqā ko bulā kar us se pūchhā, “Kyā tū abhī is ādmī ke sāth jānā chāhtī hai?” Us ne kahā, “Jī, maiṅ jānā chāhtī hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Chunāṅche unhoṅ ne apnī bahan Ribqā, us kī dāyā, Ibrāhīm ke naukar aur us ke hamsafroṅ ko ruḳhsat kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Pahle unhoṅ ne Ribqā ko barkat de kar kahā, “Hamārī bahan, Allāh kare ki tū karoṛoṅ kī māṅ bane. Terī aulād apne dushmanoṅ ke shahroṅ ke darwāzoṅ par qabzā kare.” ");
INSERT INTO urdgvr_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Phir Ribqā aur us kī naukarāniyāṅ uṭh kar ūṅṭoṅ par sawār huīṅ aur Ibrāhīm ke naukar ke pīchhe ho līṅ. Chunāṅche naukar unheṅ sāth le kar rawānā ho gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Us waqt Is'hāq mulk ke junūbī hisse, Dasht-e-Najab meṅ rahtā thā. Wuh Bair-lahī-roī se āyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ek shām wuh nikal kar khule maidān meṅ apnī sochoṅ meṅ magan ṭahal rahā thā ki achānak ūṅṭ us kī taraf āte hue nazar āe. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Jab Ribqā ne apnī nazar uṭhā kar Is'hāq ko dekhā to us ne ūṅṭ se utar kar ");
INSERT INTO urdgvr_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","naukar se pūchhā, “Wuh ādmī kaun hai jo maidān meṅ ham se milne ā rahā hai?” Naukar ne kahā, “Merā mālik hai.” Yih sun kar Ribqā ne chādar le kar apne chehre ko ḍhāṅp liyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Naukar ne Is'hāq ko sab kuchh batā diyā jo us ne kiyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Phir Is'hāq Ribqā ko apnī māṅ Sārā ke ḍere meṅ le gayā. Us ne us se shādī kī, aur wuh us kī bīwī ban gaī. Is'hāq ke dil meṅ us ke lie bahut muhabbat paidā huī. Yoṅ use apnī māṅ kī maut ke bād sukūn milā. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibrāhīm ne ek aur shādī kī. Naī bīwī kā nām Qatūrā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Qatūrā ke chhih beṭe paidā hue, Zimrān, Yuqsān, Midān, Midiyān, Isbāq aur Sūḳh. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yuqsān ke do beṭe the, Sabā aur Dadān. Asūrī, Latūsī aur Lūmī Dadān kī aulād haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiyān ke beṭe Aifā, Ifar, Hanūk, Abīdā aur Ilda'ā the. Yih sab Qatūrā kī aulād the. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibrāhīm ne apnī sārī milkiyat Is'hāq ko de dī. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Apnī maut se pahle us ne apnī dūsrī bīwiyoṅ ke beṭoṅ ko tohfe de kar apne beṭe se dūr mashriq kī taraf bhej diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Ibrāhīm 175 sāl kī umr meṅ faut huā. Ġharz wuh bahut umrrasīdā aur zindagī se āsūdā ho kar intaqāl karke apne bāpdādā se jā milā. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Us ke beṭoṅ Is'hāq aur Ismāīl ne use Makfīlā ke ġhār meṅ dafn kiyā jo Mamre ke mashriq meṅ hai. Yih wuhī ġhār thā jise khet samet Hittī ādmī Ifron bin Suhar se ḳharīdā gayā thā. Ibrāhīm aur us kī bīwī Sārā donoṅ ko us meṅ dafn kiyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ibrāhīm kī wafāt ke bād Allāh ne Is'hāq ko barkat dī. Us waqt Is'hāq Bair-lahī-roī ke qarīb ābād thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ibrāhīm kā beṭā Ismāīl jo Sārā kī Misrī launḍī Hājirā ke hāṅ paidā huā us kā nasabnāmā yih hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismāīl ke beṭe baṛe se le kar chhoṭe tak yih haiṅ: Nabāyot, Qīdār, Adbiyel, Mibsām, ");
INSERT INTO urdgvr_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishmā, Dūmā, Massā, ");
INSERT INTO urdgvr_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Taimā, Yatūr, Nafīs aur Qidmā. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Yih beṭe bārah qabīloṅ ke bānī ban gae. Aur jahāṅ jahāṅ wuh ābād hue un jaghoṅ kā wuhī nām paṛ gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismāīl 137 sāl kā thā jab wuh kūch karke apne bāpdādā se jā milā. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Us kī aulād us ilāqe meṅ ābād thī jo Hawīlā aur Shūr ke darmiyān hai aur jo Misr ke mashriq meṅ Asūr kī taraf hai. Yoṅ Ismāīl apne tamām bhāiyoṅ ke sāmne hī ābād huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Yih Ibrāhīm ke beṭe Is'hāq kā bayān hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Is'hāq 40 sāl kā thā jab us kī Ribqā se shādī huī. Ribqā Lāban kī bahan aur Arāmī mard Batuel kī beṭī thī. (Batuel Masoputāmiyā kā thā.) ");
INSERT INTO urdgvr_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ribqā ke bachche paidā na hue. Lekin Is'hāq ne apnī bīwī ke lie duā kī to Rab ne us kī sunī, aur Ribqā ummīd se huī. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Us ke peṭ meṅ bachche ek dūsre se zorāzmāī karne lage to wuh Rab se pūchhne gaī, “Agar yih merī hālat rahegī to phir maiṅ yahāṅ tak kyoṅ pahuṅch gaī hūṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Rab ne us se kahā, “Tere andar do qaumeṅ haiṅ. Wuh tujh se nikal kar ek dūsrī se alag alag ho jāeṅgī. Un meṅ se ek zyādā tāqatwar hogī, aur baṛā chhoṭe kī ḳhidmat karegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Paidāish kā waqt ā gayā to juṛwāṅ beṭe paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Pahlā bachchā niklā to surḳh-sā thā, aur aisā lag rahā thā ki wuh ghane bāloṅ kā koṭ hī pahne hue hai. Is lie us kā nām Esau yānī ‘Bāloṅ Wālā’ rakhā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Is ke bād dūsrā bachchā paidā huā. Wuh Esau kī eṛī pakaṛe hue niklā, is lie us kā nām Yāqūb yānī ‘Eṛī Pakaṛne Wālā’ rakhā gayā. Us waqt Is'hāq 60 sāl kā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Laṛke jawān hue. Esau māhir shikārī ban gayā aur khule maidān meṅ ḳhush rahtā thā. Us ke muqābale meṅ Yāqūb shāystā thā aur ḍere meṅ rahnā pasand kartā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Is'hāq Esau ko pyār kartā thā, kyoṅki wuh shikār kā gosht pasand kartā thā. Lekin Ribqā Yāqūb ko pyār kartī thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ek din Yāqūb sālan pakā rahā thā ki Esau thakāhārā jangal se āyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Us ne kahā, “Mujhe jaldī se lāl sālan, hāṅ isī lāl sālan se kuchh khāne ko do. Maiṅ to bedam ho rahā hūṅ.” (Isī lie bād meṅ us kā nām Adom yānī Surḳh paṛ gayā.) ");
INSERT INTO urdgvr_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yāqūb ne kahā, “Pahle mujhe pahlauṭhe kā haq bech do.” ");
INSERT INTO urdgvr_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau ne kahā, “Maiṅ to bhūk se mar rahā hūṅ, pahlauṭhe kā haq mere kis kām kā?” ");
INSERT INTO urdgvr_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yāqūb ne kahā, “Pahle qasam khā kar mujhe yih haq bech do.” Esau ne qasam khā kar use pahlauṭhe kā haq muntaqil kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Tab Yāqūb ne use kuchh roṭī aur dāl de dī, aur Esau ne khāyā aur piyā. Phir wuh uṭh kar chalā gayā. Yoṅ us ne pahlauṭhe ke haq ko haqīr jānā. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Us mulk meṅ dubārā kāl paṛā, jis tarah Ibrāhīm ke dinoṅ meṅ bhī paṛ gayā thā. Is'hāq Jirār Shahr gayā jis par Filistiyoṅ ke bādshāh Abīmalik kī hukūmat thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Rab ne Is'hāq par zāhir ho kar kahā, “Misr na jā balki us mulk meṅ bas jo maiṅ tujhe dikhātā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Us mulk meṅ ajnabī rah to maiṅ tere sāth hūṅgā aur tujhe barkat dūṅgā. Kyoṅki maiṅ tujhe aur terī aulād ko yih tamām ilāqā dūṅgā aur wuh wādā pūrā karūṅga jo maiṅ ne qasam khā kar tere bāp Ibrāhīm se kiyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Maiṅ tujhe itnī aulād dūṅgā jitne āsmān par sitāre haiṅ. Aur maiṅ yih tamām mulk unheṅ de dūṅgā. Terī aulād se duniyā kī tamām qaumeṅ barkat pāeṅgī. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Maiṅ tujhe is lie barkat dūṅgā ki Ibrāhīm mere tābe rahā aur merī hidāyāt aur ahkām par chaltā rahā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Chunāṅche Is'hāq Jirār meṅ ābād ho gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Jab wahāṅ ke mardoṅ ne Ribqā ke bāre meṅ pūchhā to Is'hāq ne kahā, “Yih merī bahan hai.” Wuh unheṅ yih batāne se ḍartā thā ki yih merī bīwī hai, kyoṅki us ne sochā, “Ribqā nihāyat ḳhūbsūrat hai. Agar unheṅ mālūm ho jāe ki Ribqā merī bīwī hai to wuh use hāsil karne kī ḳhātir mujhe qatl kar deṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Kāfī waqt guzar gayā. Ek din Filistiyoṅ ke bādshāh ne apnī khiṛkī meṅ se jhāṅk kar dekhā ki Is'hāq apnī bīwī ko pyār kar rahā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Us ne Is'hāq ko bulā kar kahā, “Wuh to āp kī bīwī hai! Āp ne kyoṅ kahā ki merī bahan hai?” Is'hāq ne jawāb diyā, “Maiṅ ne sochā ki agar maiṅ batāūṅ ki yih merī bīwī hai to log mujhe qatl kar deṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abīmalik ne kahā, “Āp ne hamāre sāth kaisā sulūk kar dikhāyā! Kitnī āsānī se mere ādmiyoṅ meṅ se koī āp kī bīwī se hambistar ho jātā. Is tarah ham āp ke sabab se ek baṛe jurm ke qusūrwār ṭhaharte.” ");
INSERT INTO urdgvr_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Phir Abīmalik ne tamām logoṅ ko hukm diyā, “Jo bhī is mard yā us kī bīwī ko chheṛe use sazā-e-maut dī jāegī.” ");
INSERT INTO urdgvr_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Is'hāq ne us ilāqe meṅ kāshtkārī kī, aur usī sāl use sau gunā phal milā. Yoṅ Rab ne use barkat dī, ");
INSERT INTO urdgvr_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","aur wuh amīr ho gayā. Us kī daulat baṛhtī gaī, aur wuh nihāyat daulatmand ho gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Us ke pās itnī bheṛ-bakriyāṅ, gāy-bail aur ġhulām the ki Filistī us se hasad karne lage. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ab aisā huā ki unhoṅ ne un tamām kuoṅ ko miṭṭī se bhar kar band kar diyā jo us ke bāp ke naukaroṅ ne khode the. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Āḳhirkār Abīmalik ne Is'hāq se kahā, “Kahīṅ aur jā kar raheṅ, kyoṅki āp ham se zyādā zorāwar ho gae haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Chunāṅche Is'hāq ne wahāṅ se jā kar Jirār kī Wādī meṅ apne ḍere lagāe. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Wahāṅ Filistiyoṅ ne Ibrāhīm kī maut ke bād tamām kuoṅ ko miṭṭī se bhar diyā thā. Is'hāq ne un ko dubārā khudwāyā. Us ne un ke wuhī nām rakhe jo us ke bāp ne rakhe the. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Is'hāq ke naukaroṅ ko wādī meṅ khodte khodte tāzā pānī mil gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Lekin Jirār ke charwāhe ā kar Is'hāq ke charwāhoṅ se jhagaṛne lage. Unhoṅ ne kahā, “Yih hamārā kuāṅ hai!” Is lie us ne us kueṅ kā nām Isak yānī Jhagaṛā rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Is'hāq ke naukaroṅ ne ek aur kuāṅ khod liyā. Lekin us par bhī jhagaṛā huā, is lie us ne us kā nām Sitnā yānī Muḳhālafat rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Wahāṅ se jā kar us ne ek tīsrā kuāṅ khudwāyā. Is dafā koī jhagaṛā na huā, is lie us ne us kā nām Rahobot yānī ‘Khulī Jagah’ rakhā. Kyoṅki us ne kahā, “Rab ne hameṅ khulī jagah dī hai, aur ab ham mulk meṅ phaleṅ-phūleṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Wahāṅ se wuh Bair-sabā chalā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Usī rāt Rab us par zāhir huā aur kahā, “Maiṅ tere bāp Ibrāhīm kā Ḳhudā hūṅ. Mat ḍar, kyoṅki maiṅ tere sāth hūṅ. Maiṅ tujhe barkat dūṅgā aur tujhe apne ḳhādim Ibrāhīm kī ḳhātir bahut aulād dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Wahāṅ Is'hāq ne qurbāngāh banāī aur Rab kā nām le kar ibādat kī. Wahāṅ us ne apne ḳhaime lagāe aur us ke naukaroṅ ne kuāṅ khod liyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ek din Abīmalik, us kā sāthī Aḳhūzat aur us kā sipahsālār Fīkul Jirār se us ke pās āe. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Is'hāq ne pūchhā, “Āp kyoṅ mere pās āe haiṅ? Āp to mujh se nafrat rakhte haiṅ. Kyā āp ne mujhe apne darmiyān se ḳhārij nahīṅ kiyā thā?” ");
INSERT INTO urdgvr_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Unhoṅ ne jawāb diyā, “Ham ne jān liyā hai ki Rab āp ke sāth hai. Is lie ham ne kahā ki hamārā āp ke sāth ahd honā chāhie. Āie ham qasam khā kar ek dūsre se ahd bāndheṅ ");
INSERT INTO urdgvr_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ki āp hameṅ nuqsān nahīṅ pahuṅchāeṅge, kyoṅki ham ne bhī āp ko nahīṅ chheṛā balki āp se sirf achchhā sulūk kiyā aur āp ko salāmatī ke sāth ruḳhsat kiyā hai. Aur ab zāhir hai ki Rab ne āp ko barkat dī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Is'hāq ne un kī ziyāfat kī, aur unhoṅ ne khāyā aur piyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Phir subah-sawere uṭh kar unhoṅ ne ek dūsre ke sāmne qasam khāī. Is ke bād Is'hāq ne unheṅ ruḳhsat kiyā aur wuh salāmatī se rawānā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Usī din Is'hāq ke naukar āe aur use us kueṅ ke bāre meṅ ittalā dī jo unhoṅ ne khodā thā. Unhoṅ ne kahā, “Hameṅ pānī mil gayā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Us ne kueṅ kā nām Sabā yānī ‘Qasam’ rakhā. Āj tak sāth wāle shahr kā nām Bair-sabā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Jab Esau 40 sāl kā thā to us ne do Hittī auratoṅ se shādī kī, Bairī kī beṭī Yahūdit se aur Ailon kī beṭī Bāsamat se. ");
INSERT INTO urdgvr_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Yih aurateṅ Is'hāq aur Ribqā ke lie baṛe dukh kā bāis banīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Is'hāq būṛhā ho gayā to us kī nazar dhundlā gaī. Us ne apne baṛe beṭe ko bulā kar kahā, “Beṭā.” Esau ne jawāb diyā, “Jī, maiṅ hāzir hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Is'hāq ne kahā, “Maiṅ būṛhā ho gayā hūṅ aur Ḳhudā jāne kab mar jāūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Is lie apnā tīr kamān le kar jangal meṅ nikal jā aur mere lie kisī jānwar kā shikār kar. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Use taiyār karke aisā lazīz khānā pakā jo mujhe pasand hai. Phir use mere pās le ā. Marne se pahle maiṅ wuh khānā khā kar tujhe barkat denā chāhtā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ribqā ne Is'hāq kī Esau ke sāth bātchīt sun lī thī. Jab Esau shikār karne ke lie chalā gayā to us ne Yāqūb se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","“Abhī abhī maiṅ ne tumhāre abbū ko Esau se yih bāt karte hue sunā ki ");
INSERT INTO urdgvr_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Mere lie kisī jānwar kā shikār karke le ā. Use taiyār karke mere lie lazīz khānā pakā. Marne se pahle maiṅ yih khānā khā kar tujhe Rab ke sāmne barkat denā chāhtā hūṅ.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ab suno, mere beṭe! Jo kuchh maiṅ batātī hūṅ wuh karo. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Jā kar rewaṛ meṅ se bakriyoṅ ke do achchhe achchhe bachche chun lo. Phir maiṅ wuhī lazīz khānā pakāūṅgī jo tumhāre abbū ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Tum yih khānā us ke pās le jāoge to wuh use khā kar marne se pahle tumheṅ barkat degā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Lekin Yāqūb ne etarāz kiyā, “Āp jāntī haiṅ ki Esau ke jism par ghane bāl haiṅ jabki mere bāl kam haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kahīṅ mujhe chhūne se mere bāp ko patā na chal jāe ki maiṅ use fareb de rahā hūṅ. Phir mujh par barkat nahīṅ balki lānat āegī.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Us kī māṅ ne kahā, “Tum par āne wālī lānat mujh par āe, beṭā. Bas merī bāt mān lo. Jāo aur bakriyoṅ ke wuh bachche le āo.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Chunāṅche wuh gayā aur unheṅ apnī māṅ ke pās le āyā. Ribqā ne aisā lazīz khānā pakāyā jo Yāqūb ke bāp ko pasand thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Esau ke ḳhās mauqoṅ ke lie achchhe libās Ribqā ke pās ghar meṅ the. Us ne un meṅ se behtarīn libās chun kar apne chhoṭe beṭe ko pahnā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Sāth sāth us ne bakriyoṅ kī khāleṅ us ke hāthoṅ aur gardan par jahāṅ bāl na the lapeṭ dīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Phir us ne apne beṭe Yāqūb ko roṭī aur wuh lazīz khānā diyā jo us ne pakāyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yāqūb ne apne bāp ke pās jā kar kahā, “Abbū jī.” Is'hāq ne kahā, “Jī, beṭā. Tū kaun hai?” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Us ne kahā, “Maiṅ āp kā pahlauṭhā Esau hūṅ. Maiṅ ne wuh kiyā hai jo āp ne mujhe kahā thā. Ab zarā uṭheṅ aur baiṭh kar mere shikār kā khānā khāeṅ tāki āp bād meṅ mujhe barkat deṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Is'hāq ne pūchhā, “Beṭā, tujhe yih shikār itnī jaldī kis tarah mil gayā?” Us ne jawāb diyā, “Rab āp ke Ḳhudā ne use mere sāmne se guzarne diyā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Is'hāq ne kahā, “Beṭā, mere qarīb ā tāki maiṅ tujhe chhū lūṅ ki tū wāqaī merā beṭā Esau hai ki nahīṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yāqūb apne bāp ke nazdīk āyā. Is'hāq ne use chhū kar kahā, “Terī āwāz to Yāqūb kī hai lekin tere hāth Esau ke haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Yoṅ us ne fareb khāyā. Chūṅki Yāqūb ke hāth Esau ke hāth kī mānind the is lie us ne use barkat dī. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","To bhī us ne dubārā pūchhā, “Kyā tū wāqaī merā beṭā Esau hai?” Yāqūb ne jawāb diyā, “Jī, maiṅ wuhī hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Āḳhirkār Is'hāq ne kahā, “Shikār kā khānā mere pās le ā, beṭā. Use khāne ke bād maiṅ tujhe barkat dūṅgā.” Yāqūb khānā aur mai le āyā. Is'hāq ne khāyā aur piyā, ");
INSERT INTO urdgvr_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","phir kahā, “Beṭā, mere pās ā aur mujhe bosā de.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yāqūb ne pās ā kar use bosā diyā. Is'hāq ne us ke libās ko sūṅgh kar use barkat dī. Us ne kahā, “Mere beṭe kī ḳhushbū us khule maidān kī ḳhushbū kī mānind hai jise Rab ne barkat dī hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Allāh tujhe āsmān kī os aur zamīn kī zarḳhezī de. Wuh tujhe kasrat kā anāj aur angūr kā ras de. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Qaumeṅ terī ḳhidmat kareṅ, aur ummateṅ tere sāmne jhuk jāeṅ. Apne bhāiyoṅ kā hukmrān ban, aur terī māṅ kī aulād tere sāmne ghuṭne ṭeke. Jo tujh par lānat kare wuh ḳhud lānatī ho aur jo tujhe barkat de wuh ḳhud barkat pāe.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Is'hāq kī barkat ke bād Yāqūb abhī ruḳhsat hī huā thā ki us kā bhāī Esau shikār karke wāpas āyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Wuh bhī lazīz khānā pakā kar use apne bāp ke pās le āyā. Us ne kahā, “Abbū jī, uṭheṅ aur mere shikār kā khānā khāeṅ tāki āp mujhe barkat deṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Is'hāq ne pūchhā, “Tū kaun hai?” Us ne jawāb diyā, “Maiṅ āp kā baṛā beṭā Esau hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Is'hāq ghabrā kar shiddat se kāṅpne lagā. Us ne pūchhā, “Phir wuh kaun thā jo kisī jānwar kā shikār karke mere pās le āyā? Tere āne se zarā pahle maiṅ ne us shikār kā khānā khā kar us shaḳhs ko barkat dī. Ab wuh barkat usī par rahegī.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Yih sun kar Esau zordār aur talḳh chīḳheṅ mārne lagā. “Abbū, mujhe bhī barkat deṅ,” us ne kahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Lekin Is'hāq ne jawāb diyā, “Tere bhāī ne ā kar mujhe fareb diyā. Us ne terī barkat tujh se chhīn lī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau ne kahā, “Us kā nām Yāqūb ṭhīk hī rakhā gayā hai, kyoṅki ab us ne mujhe dūsrī bār dhokā diyā hai. Pahle us ne pahlauṭhe kā haq mujh se chhīn liyā aur ab merī barkat bhī zabardastī le lī. Kyā āp ne mere lie koī barkat mahfūz nahīṅ rakhī?” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Lekin Is'hāq ne kahā, “Maiṅ ne use terā hukmrān aur us ke tamām bhāiyoṅ ko us ke ḳhādim banā diyā hai. Maiṅ ne use anāj aur angūr kā ras muhaiyā kiyā hai. Ab mujhe batā beṭā, kyā kuchh rah gayā hai jo maiṅ tujhe dūṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Lekin Esau ḳhāmosh na huā balki kahā, “Abbū, kyā āp ke pās wāqaī sirf yihī barkat thī? Abbū, mujhe bhī barkat deṅ.” Wuh zār-o-qatār rone lagā. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Phir Is'hāq ne kahā, “Tū zamīn kī zarḳhezī aur āsmān kī os se mahrūm rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Tū sirf apnī talwār ke sahāre zindā rahegā aur apne bhāī kī ḳhidmat karegā. Lekin ek din tū bechain ho kar us kā juā apnī gardan par se utār phaiṅkegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Bāp kī barkat ke sabab se Esau Yāqūb kā dushman ban gayā. Us ne dil meṅ kahā, “Wuh din qarīb ā gae haiṅ ki Abbū intaqāl kar jāeṅge aur ham un kā mātam kareṅge. Phir maiṅ apne bhāī ko mār ḍālūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ribqā ko apne baṛe beṭe Esau kā yih irādā mālūm huā. Us ne Yāqūb ko bulā kar kahā, “Tumhārā bhāī badlā lenā chāhtā hai. Wuh tumheṅ qatl karne kā irādā rakhtā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Beṭā, ab merī suno, yahāṅ se hijrat kar jāo. Hārān Shahr meṅ mere bhāī Lāban ke pās chale jāo. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Wahāṅ kuchh din ṭhahre rahnā jab tak tumhāre bhāī kā ġhussā ṭhanḍā na ho jāe. ");
INSERT INTO urdgvr_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Jab us kā ġhussā ṭhanḍā ho jāegā aur wuh tumhāre us ke sāth kie gae sulūk ko bhūl jāegā, tab maiṅ ittalā dūṅgī ki tum wahāṅ se wāpas ā sakte ho. Maiṅ kyoṅ ek hī din meṅ tum donoṅ se mahrūm ho jāūṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Phir Ribqā ne Is'hāq se bāt kī, “Maiṅ Esau kī bīwiyoṅ ke sabab se apnī zindagī se tang hūṅ. Agar Yāqūb bhī is mulk kī auratoṅ meṅ se kisī se shādī kare to behtar hai ki maiṅ pahle hī mar jāūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Is'hāq ne Yāqūb ko bulā kar use barkat dī aur kahā, “Lāzim hai ki tū kisī Kanānī aurat se shādī na kare. ");
INSERT INTO urdgvr_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ab sīdhe Masoputāmiyā meṅ apne nānā Batuel ke ghar jā aur wahāṅ apne māmūṅ Lāban kī laṛkiyoṅ meṅ se kisī ek se shādī kar. ");
INSERT INTO urdgvr_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Allāh Qādir-e-mutlaq tujhe barkat de kar phalne-phūlne de aur tujhe itnī aulād de ki tū bahut sārī qaumoṅ kā bāp bane. ");
INSERT INTO urdgvr_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Wuh tujhe aur terī aulād ko Ibrāhīm kī barkat de jise us ne yih mulk diyā jis meṅ tū mehmān ke taur par rahtā hai. Yih mulk tumhāre qabze meṅ āe.” ");
INSERT INTO urdgvr_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Yoṅ Is'hāq ne Yāqūb ko Masoputāmiyā meṅ Lāban ke ghar bhejā. Lāban Arāmī mard Batuel kā beṭā aur Ribqā kā bhāī thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau ko patā chalā ki Is'hāq ne Yāqūb ko barkat de kar Masoputāmiyā bhej diyā hai tāki wahāṅ shādī kare. Use yih bhī mālūm huā ki Is'hāq ne use Kanānī aurat se shādī karne se manā kiyā hai ");
INSERT INTO urdgvr_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","aur ki Yāqūb apne māṅ-bāp kī sun kar Masoputāmiyā chalā gayā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau samajh gayā ki Kanānī aurateṅ mere bāp ko manzūr nahīṅ haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Is lie wuh Ibrāhīm ke beṭe Ismāīl ke pās gayā aur us kī beṭī Mahalat se shādī kī. Wuh Nabāyot kī bahan thī. Yoṅ us kī bīwiyoṅ meṅ izāfā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yāqūb Bair-sabā se Hārān kī taraf rawānā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Jab sūraj ġhurūb huā to wuh rāt guzārne ke lie ruk gayā aur wahāṅ ke pattharoṅ meṅ se ek ko le kar use apne sirhāne rakhā aur so gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Jab wuh so rahā thā to ḳhāb meṅ ek sīṛhī dekhī jo zamīn se āsmān tak pahuṅchtī thī. Farishte us par chaṛhte aur utarte nazar āte the. ");
INSERT INTO urdgvr_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Rab us ke ūpar khaṛā thā. Us ne kahā, “Maiṅ Rab Ibrāhīm aur Is'hāq kā Ḳhudā hūṅ. Maiṅ tujhe aur terī aulād ko yih zamīn dūṅgā jis par tū leṭā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Terī aulād zamīn par ḳhāk kī tarah beshumār hogī, aur tū chāroṅ taraf phail jāegā. Duniyā kī tamām qaumeṅ tere aur terī aulād ke wasīle se barkat pāeṅgī. ");
INSERT INTO urdgvr_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Maiṅ tere sāth hūṅgā, tujhe mahfūz rakhūṅgā aur āḳhirkār tujhe is mulk meṅ wāpas lāūṅgā. Mumkin hī nahīṅ ki maiṅ tere sāth apnā wādā pūrā karne se pahle tujhe chhoṛ dūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Tab Yāqūb jāg uṭhā. Us ne kahā, “Yaqīnan Rab yahāṅ hāzir hai, aur mujhe mālūm nahīṅ thā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Wuh ḍar gayā aur kahā, “Yih kitnā ḳhaufnāk maqām hai. Yih to Allāh hī kā ghar aur āsmān kā darwāzā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yāqūb subah-sawere uṭhā. Us ne wuh patthar liyā jo us ne apne sirhāne rakhā thā aur use satūn kī tarah khaṛā kiyā. Phir us ne us par zaitūn kā tel unḍel diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Us ne maqām kā nām Baitel yānī ‘Allāh kā Ghar’ rakhā. (Pahle sāth wāle shahr kā nām Lūz thā.) ");
INSERT INTO urdgvr_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Us ne qasam khā kar kahā, “Agar Rab mere sāth ho, safr par merī hifāzat kare, mujhe khānā aur kapṛā muhaiyā kare ");
INSERT INTO urdgvr_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","aur maiṅ salāmatī se apne bāp ke ghar wāpas pahuṅchūṅ to phir wuh merā Ḳhudā hogā. ");
INSERT INTO urdgvr_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Jahāṅ yih patthar satūn ke taur par khaṛā hai wahāṅ Allāh kā ghar hogā, aur jo bhī tū mujhe degā us kā daswāṅ hissā tujhe diyā karūṅga.” ");
INSERT INTO urdgvr_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yāqūb ne apnā safr jārī rakhā aur chalte chalte mashriqī qaumoṅ ke mulk meṅ pahuṅch gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Wahāṅ us ne khet meṅ kuāṅ dekhā jis ke irdgird bheṛ-bakriyoṅ ke tīn rewaṛ jamā the. Rewaṛoṅ ko kueṅ kā pānī pilāyā jānā thā, lekin us ke muṅh par baṛā patthar paṛā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Wahāṅ pānī pilāne kā yih tarīqā thā ki pahle charwāhe tamām rewaṛoṅ kā intazār karte aur phir patthar ko luṛhkā kar muṅh se haṭā dete the. Pānī pilāne ke bād wuh patthar ko dubārā muṅh par rakh dete the. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yāqūb ne charwāhoṅ se pūchhā, “Mere bhāiyo, āp kahāṅ ke haiṅ?” Unhoṅ ne jawāb diyā, “Hārān ke.” ");
INSERT INTO urdgvr_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Us ne pūchhā, “Kyā āp Nahūr ke pote Lāban ko jānte haiṅ?” Unhoṅ ne kahā, “Jī hāṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Us ne pūchhā, “Kyā wuh ḳhairiyat se hai?” Unhoṅ ne kahā, “Jī, wuh ḳhairiyat se hai. Dekho, udhar us kī beṭī Rāḳhil rewaṛ le kar ā rahī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yāqūb ne kahā, “Abhī to shām tak bahut waqt bāqī hai. Rewaṛoṅ ko jamā karne kā waqt to nahīṅ hai. Āp kyoṅ unheṅ pānī pilā kar dubārā charne nahīṅ dete?” ");
INSERT INTO urdgvr_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Unhoṅ ne jawāb diyā, “Pahle zarūrī hai ki tamām rewaṛ yahāṅ pahuṅcheṅ. Tab hī patthar ko luṛhkā kar ek taraf haṭāyā jāegā aur ham rewaṛoṅ ko pānī pilāeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yāqūb abhī un se bāt kar hī rahā thā ki Rāḳhil apne bāp kā rewaṛ le kar ā pahuṅchī, kyoṅki bheṛ-bakriyoṅ ko charānā us kā kām thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Jab Yāqūb ne Rāḳhil ko māmūṅ Lāban ke rewaṛ ke sāth āte dekhā to us ne kueṅ ke pās jā kar patthar ko luṛhkā kar muṅh se haṭā diyā aur bheṛ-bakriyoṅ ko pānī pilāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Phir us ne use bosā diyā aur ḳhūb rone lagā. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Us ne kahā, “Maiṅ āp ke abbū kī bahan Ribqā kā beṭā hūṅ.” Yih sun kar Rāḳhil ne bhāg kar apne abbū ko ittalā dī. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Jab Lāban ne sunā ki merā bhānjā Yāqūb āyā hai to wuh dauṛ kar us se milne gayā aur use gale lagā kar apne ghar le āyā. Yāqūb ne use sab kuchh batā diyā jo huā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lāban ne kahā, “Āp wāqaī mere rishtedār haiṅ.” Yāqūb ne wahāṅ ek pūrā mahīnā guzārā. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Phir Lāban Yāqūb se kahne lagā, “Beshak āp mere rishtedār haiṅ, lekin āp ko mere lie kām karne ke badle meṅ kuchh milnā chāhie. Maiṅ āp ko kitne paise dūṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Lāban kī do beṭiyāṅ thīṅ. Baṛī kā nām Liyāh thā aur chhoṭī kā Rāḳhil. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Liyāh kī āṅkheṅ chundhī thīṅ jabki Rāḳhil har tarah se ḳhūbsūrat thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yāqūb ko Rāḳhil se muhabbat thī, is lie us ne kahā, “Agar mujhe āp kī chhoṭī beṭī Rāḳhil mil jāe to āp ke lie sāt sāl kām karūṅga.” ");
INSERT INTO urdgvr_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lāban ne kahā, “Kisī aur ādmī kī nisbat mujhe yih zyādā pasand hai ki āp hī se us kī shādī karāūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Pas Yāqūb ne Rāḳhil ko pāne ke lie sāt sāl tak kām kiyā. Lekin use aisā lagā jaisā do ek din hī guzare hoṅ kyoṅki wuh Rāḳhil ko shiddat se pyār kartā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Is ke bād us ne Lāban se kahā, “Muddat pūrī ho gaī hai. Ab mujhe apnī beṭī se shādī karne deṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Lāban ne us maqām ke tamām logoṅ ko dāwat de kar shādī kī ziyāfat kī. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Lekin us rāt wuh Rāḳhil kī bajāe Liyāh ko Yāqūb ke pās le āyā, aur Yāqūb usī se hambistar huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Lāban ne Liyāh ko apnī launḍī Zilfā de dī thī tāki wuh us kī ḳhidmat kare.) ");
INSERT INTO urdgvr_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Jab subah huī to Yāqūb ne dekhā ki Liyāh hī mere pās hai. Us ne Lāban ke pās jā kar kahā, “Yih āp ne mere sāth kyā kiyā hai? Kyā maiṅ ne Rāḳhil ke lie kām nahīṅ kiyā? Āp ne mujhe dhokā kyoṅ diyā?” ");
INSERT INTO urdgvr_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lāban ne jawāb diyā, “Yahāṅ dastūr nahīṅ hai ki chhoṭī beṭī kī shādī baṛī se pahle kar dī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ek hafte ke bād shādī kī rusūmāt pūrī ho jāeṅgī. Us waqt tak sabar kareṅ. Phir maiṅ āp ko Rāḳhil bhī de dūṅgā. Shart yih hai ki āp mazīd sāt sāl mere lie kām kareṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yāqūb mān gayā. Chunāṅche jab ek hafte ke bād shādī kī rusūmāt pūrī huīṅ to Lāban ne apnī beṭī Rāḳhil kī shādī bhī us ke sāth kar dī. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Lāban ne Rāḳhil ko apnī launḍī Bilhāh de dī tāki wuh us kī ḳhidmat kare.) ");
INSERT INTO urdgvr_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yāqūb Rāḳhil se bhī hambistar huā. Wuh Liyāh kī nisbat use zyādā pyār kartā thā. Phir us ne Rāḳhil ke ewaz sāt sāl aur Lāban kī ḳhidmat kī. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Jab Rab ne dekhā ki Liyāh se nafrat kī jātī hai to us ne use aulād dī jabki Rāḳhil ke hāṅ bachche paidā na hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Liyāh hāmilā huī aur us ke beṭā paidā huā. Us ne kahā, “Rab ne merī musībat dekhī hai aur ab merā shauhar mujhe pyār karegā.” Us ne us kā nām Rūbin yānī ‘Dekho Ek Beṭā’ rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Wuh dubārā hāmilā huī. Ek aur beṭā paidā huā. Us ne kahā, “Rab ne sunā ki mujh se nafrat kī jātī hai, is lie us ne mujhe yih bhī diyā hai.” Us ne us kā nām Shamāūn yānī ‘Rab ne Sunā Hai’ rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Wuh ek aur dafā hāmilā huī. Tīsrā beṭā paidā huā. Us ne kahā, “Ab āḳhirkār shauhar ke sāth merā bandhan mazbūt ho jāegā, kyoṅki maiṅ ne us ke lie tīn beṭoṅ ko janm diyā hai.” Us ne us kā nām Lāwī yānī Bandhan rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Wuh ek bār phir hāmilā huī. Chauthā beṭā paidā huā. Us ne kahā, “Is dafā maiṅ Rab kī tamjīd karūṅgī.” Us ne us kā nām Yahūdāh yānī Tamjīd rakhā. Is ke bād us se aur bachche paidā na hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Lekin Rāḳhil beaulād hī rahī, is lie wuh apnī bahan se hasad karne lagī. Us ne Yāqūb se kahā, “Mujhe bhī aulād deṅ warnā maiṅ mar jāūṅgī.” ");
INSERT INTO urdgvr_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yāqūb ko ġhussā āyā. Us ne kahā, “Kyā maiṅ Allāh hūṅ jis ne tujhe aulād se mahrūm rakhā hai?” ");
INSERT INTO urdgvr_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rāḳhil ne kahā, “Yahāṅ merī launḍī Bilhāh hai. Us ke sāth hambistar hoṅ tāki wuh mere lie bachche ko janm de aur maiṅ us kī mārifat māṅ ban jāūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Yoṅ us ne apne shauhar ko Bilhāh dī, aur wuh us se hambistar huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhāh hāmilā huī aur beṭā paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rāḳhil ne kahā, “Allāh ne mere haq meṅ faislā diyā hai. Us ne merī duā sun kar mujhe beṭā de diyā hai.” Us ne us kā nām Dān yānī ‘Kisī ke Haq meṅ Faislā Karne Wālā’ rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilhāh dubārā hāmilā huī aur ek aur beṭā paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rāḳhil ne kahā, “Maiṅ ne apnī bahan se saḳht kushtī laṛī hai, lekin jīt gaī hūṅ.” Us ne us kā nām Naftālī yānī ‘Kushtī meṅ Mujh se Jītā Gayā’ rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Jab Liyāh ne dekhā ki mere aur bachche paidā nahīṅ ho rahe to us ne Yāqūb ko apnī launḍī Zilfā de dī tāki wuh bhī us kī bīwī ho. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilfā ke bhī ek beṭā paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Liyāh ne kahā, “Maiṅ kitnī ḳhushqismat hūṅ!” Chunāṅche us ne us kā nām Jad yānī Ḳhushqismatī rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Phir Zilfā ke dūsrā beṭā paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Liyāh ne kahā, “Maiṅ kitnī mubārak hūṅ. Ab ḳhawātīn mujhe mubārak kaheṅgī.” Us ne us kā nām Āshar yānī Mubārak rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ek din anāj kī fasal kī kaṭāī ho rahī thī ki Rūbin bāhar nikal kar khetoṅ meṅ chalā gayā. Wahāṅ use mardumgayāh mil gae. Wuh unheṅ apnī māṅ Liyāh ke pās le āyā. Yih dekh kar Rāḳhil ne Liyāh se kahā, “Mujhe zarā apne beṭe ke mardumgayāh meṅ se kuchh de do.” ");
INSERT INTO urdgvr_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Liyāh ne jawāb diyā, “Kyā yihī kāfī nahīṅ ki tum ne mere shauhar ko mujh se chhīn liyā hai? Ab mere beṭe ke mardumgayāh ko bhī chhīnanā chāhtī ho.” Rāḳhil ne kahā, “Agar tum mujhe apne beṭe ke mardumgayāh meṅ se do to āj rāt Yāqūb ke sāth so saktī ho.” ");
INSERT INTO urdgvr_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Shām ko Yāqūb khetoṅ se wāpas ā rahā thā ki Liyāh āge se us se milne ko gaī aur kahā, “Āj rāt āp ko mere sāth sonā hai, kyoṅki maiṅ ne apne beṭe ke mardumgayāh ke ewaz āp ko ujrat par liyā hai.” Chunāṅche Yāqūb ne Liyāh ke pās rāt guzārī. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Us waqt Allāh ne Liyāh kī duā sunī aur wuh hāmilā huī. Us ke pāṅchwāṅ beṭā paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Liyāh ne kahā, “Allāh ne mujhe is kā ajr diyā hai ki maiṅ ne apne shauhar ko apnī launḍī dī.” Us ne us kā nām Ishkār yānī Ajr rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Is ke bād wuh ek aur dafā hāmilā huī. Us ke chhaṭā beṭā paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Us ne kahā, “Allāh ne mujhe ek achchhā-ḳhāsā tohfā diyā hai. Ab merā ḳhāwind mere sāth rahegā, kyoṅki mujh se us ke chhih beṭe paidā hue haiṅ.” Us ne us kā nām Zabūlūn yānī Rihāish rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Is ke bād beṭī paidā huī. Us ne us kā nām Dīnā rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Phir Allāh ne Rāḳhil ko bhī yād kiyā. Us ne us kī duā sun kar use aulād baḳhshī. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Wuh hāmilā huī aur ek beṭā paidā huā. Us ne kahā, “Mujhe beṭā atā karne se Allāh ne merī izzat bahāl kar dī hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Rab mujhe ek aur beṭā de.” Us ne us kā nām Yūsuf yānī ‘Wuh Aur De’ rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Yūsuf kī paidāish ke bād Yāqūb ne Lāban se kahā, “Ab mujhe ijāzat deṅ ki maiṅ apne watan aur ghar ko wāpas jāūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Mujhe mere bāl-bachche deṅ jin ke ewaz maiṅ ne āp kī ḳhidmat kī hai. Phir maiṅ chalā jāūṅgā. Āp to ḳhud jānte haiṅ ki maiṅ ne kitnī mehnat ke sāth āp ke lie kām kiyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Lekin Lāban ne kahā, “Mujh par mehrbānī kareṅ aur yihīṅ raheṅ. Mujhe ġhaibdānī se patā chalā hai ki Rab ne mujhe āp ke sabab se barkat dī hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Apnī ujrat ḳhud muqarrar kareṅ to maiṅ wuhī diyā karūṅga.” ");
INSERT INTO urdgvr_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yāqūb ne kahā, “Āp jānte haiṅ ki maiṅ ne kis tarah āp ke lie kām kiyā, ki mere wasīle se āp ke maweshī kitne baṛh gae haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Jo thoṛā-bahut mere āne se pahle āp ke pās thā wuh ab bahut zyādā baṛh gayā hai. Rab ne mere kām se āp ko bahut barkat dī hai. Ab wuh waqt ā gayā hai ki maiṅ apne ghar ke lie kuchh karūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Lāban ne kahā, “Maiṅ āp ko kyā dūṅ?” Yāqūb ne kahā, “Mujhe kuchh na deṅ. Maiṅ is shart par āp kī bheṛ-bakriyoṅ kī dekh-bhāl jārī rakhūṅgā ki ");
INSERT INTO urdgvr_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","āj maiṅ āp ke rewaṛ meṅ se guzar kar un tamām bheṛoṅ ko alag kar lūṅgā jin ke jism par chhoṭe yā baṛe dhabbe hoṅ yā jo safed na hoṅ. Isī tarah maiṅ un tamām bakriyoṅ ko bhī alag kar lūṅgā jin ke jism par chhoṭe yā baṛe dhabbe hoṅ. Yihī merī ujrat hogī. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Āindā jin bakriyoṅ ke jism par chhoṭe yā baṛe dhabbe hoṅge yā jin bheṛoṅ kā rang safed nahīṅ hogā wuh merā ajr hoṅgī. Jab kabhī āp un kā muāynā kareṅge to āp mālūm kar sakeṅge ki maiṅ diyānatdār rahā hūṅ. Kyoṅki mere jānwaroṅ ke rang se hī zāhir hogā ki maiṅ ne āp kā kuchh churāyā nahīṅ hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lāban ne kahā, “Ṭhīk hai. Aisā hī ho jaisā āp ne kahā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Usī din Lāban ne un bakroṅ ko alag kar liyā jin ke jism par dhāriyāṅ yā dhabbe the aur un tamām bakriyoṅ ko jin ke jism par chhoṭe yā baṛe dhabbe the. Jis ke bhī jism par safed nishān thā use us ne alag kar liyā. Isī tarah us ne un tamām bheṛoṅ ko bhī alag kar liyā jo pūre taur par safed na the. Phir Lāban ne unheṅ apne beṭoṅ ke sapurd kar diyā ");
INSERT INTO urdgvr_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","jo un ke sāth Yāqūb se itnā dūr chale gae ki un ke darmiyān tīn din kā fāsilā thā. Tab Yāqūb Lāban kī bāqī bheṛ-bakriyoṅ kī dekh-bhāl kartā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yāqūb ne safedā, bādām aur chanār kī harī harī shāḳheṅ le kar un se kuchh chhilkā yoṅ utār diyā ki us par safed dhāriyāṅ nazar āīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Us ne unheṅ bheṛ-bakriyoṅ ke sāmne un hauzoṅ meṅ gāṛ diyā jahāṅ wuh pānī pīte the, kyoṅki wahāṅ yih jānwar mast ho kar milāp karte the. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Jab wuh in shāḳhoṅ ke sāmne milāp karte to jo bachche paidā hote un ke jism par chhoṭe aur baṛe dhabbe aur dhāriyāṅ hotī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Phir Yāqūb ne bheṛ ke bachchoṅ ko alag karke apne rewaṛoṅ ko Lāban ke un jānwaroṅ ke sāmne charne diyā jin ke jism par dhāriyāṅ thīṅ aur jo safed na the. Yoṅ us ne apne zātī rewaṛoṅ ko alag kar liyā aur unheṅ Lāban ke rewaṛ ke sāth charne na diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Lekin us ne yih shāḳheṅ sirf us waqt hauzoṅ meṅ khaṛī kīṅ jab tāqatwar jānwar mast ho kar milāp karte the. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Kamzor jānwaroṅ ke sāth us ne aisā na kiyā. Isī tarah Lāban ko kamzor jānwar aur Yāqūb ko tāqatwar jānwar mil gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Yoṅ Yāqūb bahut amīr ban gayā. Us ke pās bahut-se rewaṛ, ġhulām aur launḍiyāṅ, ūṅṭ aur gadhe the. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ek din Yāqūb ko patā chalā ki Lāban ke beṭe mere bāre meṅ kah rahe haiṅ, “Yāqūb ne hamāre abbū se sab kuchh chhīn liyā hai. Us ne yih tamām daulat hamāre bāp kī milkiyat se hāsil kī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yāqūb ne yih bhī dekhā ki Lāban kā mere sāth rawaiyā pahle kī nisbat bigaṛ gayā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Phir Rab ne us se kahā, “Apne bāp ke mulk aur apne rishtedāroṅ ke pās wāpas chalā jā. Maiṅ tere sāth hūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Us waqt Yāqūb khule maidān meṅ apne rewaṛoṅ ke pās thā. Us ne wahāṅ se Rāḳhil aur Liyāh ko bulā kar ");
INSERT INTO urdgvr_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","un se kahā, “Maiṅ ne dekh liyā hai ki āp ke bāp kā mere sāth rawaiyā pahle kī nisbat bigaṛ gayā hai. Lekin mere bāp kā Ḳhudā mere sāth rahā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Āp donoṅ jāntī haiṅ ki maiṅ ne āp ke abbū ke lie kitnī jāṅfishānī se kām kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Lekin wuh mujhe fareb detā rahā aur merī ujrat das bār badlī. Tāham Allāh ne use mujhe nuqsān pahuṅchāne na diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Jab māmūṅ Lāban kahte the, ‘Jin jānwaroṅ ke jism par dhabbe hoṅ wuhī āp ko ujrat ke taur par mileṅge’ to tamām bheṛ-bakriyoṅ ke aise bachche paidā hue jin ke jismoṅ par dhabbe hī the. Jab unhoṅ ne kahā, ‘Jin jānwaroṅ ke jism par dhāriyāṅ hoṅgī wuhī āp ko ujrat ke taur par mileṅge’ to tamām bheṛ-bakriyoṅ ke aise bachche paidā hue jin ke jismoṅ par dhāriyāṅ hī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Yoṅ Allāh ne āp ke abbū ke maweshī chhīn kar mujhe de die haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ab aisā huā ki haiwānoṅ kī mastī ke mausam meṅ maiṅ ne ek ḳhāb dekhā. Us meṅ jo menḍhe aur bakre bheṛ-bakriyoṅ se milāp kar rahe the un ke jism par baṛe aur chhoṭe dhabbe aur dhāriyāṅ thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Us ḳhāb meṅ Allāh ke farishte ne mujh se bāt kī, ‘Yāqūb!’ Maiṅ ne kahā, ‘Jī, maiṅ hāzir hūṅ.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Farishte ne kahā, ‘Apnī nazar uṭhā kar us par ġhaur kar jo ho rahā hai. Wuh tamām menḍhe aur bakre jo bheṛ-bakriyoṅ se milāp kar rahe haiṅ un ke jism par baṛe aur chhoṭe dhabbe aur dhāriyāṅ haiṅ. Maiṅ yih ḳhud karwā rahā hūṅ, kyoṅki maiṅ ne wuh sab kuchh dekh liyā hai jo Lāban ne tere sāth kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Maiṅ wuh Ḳhudā hūṅ jo Baitel meṅ tujh par zāhir huā thā, us jagah jahāṅ tū ne satūn par tel unḍel kar use mere lie maḳhsūs kiyā aur mere huzūr qasam khāī thī. Ab uṭh aur rawānā ho kar apne watan wāpas chalā jā.’” ");
INSERT INTO urdgvr_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rāḳhil aur Liyāh ne jawāb meṅ Yāqūb se kahā, “Ab hameṅ apne bāp kī mīrās se kuchh milne kī ummīd nahīṅ rahī. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Us kā hamāre sāth ajnabī kā-sā sulūk hai. Pahle us ne hameṅ bech diyā, aur ab us ne wuh sāre paise khā bhī lie haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Chunāṅche jo bhī daulat Allāh ne hamāre bāp se chhīn lī hai wuh hamārī aur hamāre bachchoṅ kī hī hai. Ab jo kuchh bhī Allāh ne āp ko batāyā hai wuh kareṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Tab Yāqūb ne uṭh kar apne bāl-bachchoṅ ko ūṅṭoṅ par biṭhāyā ");
INSERT INTO urdgvr_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","aur apne tamām maweshī aur Masoputāmiyā se hāsil kiyā huā tamām sāmān le kar Mulk-e-Kanān meṅ apne bāp ke hāṅ jāne ke lie rawānā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Us waqt Lāban apnī bheṛ-bakriyoṅ kī pashm katarne ko gayā huā thā. Us kī ġhairmaujūdagī meṅ Rāḳhil ne apne bāp ke but churā lie. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yāqūb ne Lāban ko fareb de kar use ittalā na dī ki maiṅ jā rahā hūṅ ");
INSERT INTO urdgvr_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","balki apnī sārī milkiyat sameṭ kar farār huā. Dariyā-e-Furāt ko pār karke wuh Jiliyād ke pahāṛī ilāqe kī taraf safr karne lagā. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Tīn din guzar gae. Phir Lāban ko batāyā gayā ki Yāqūb bhāg gayā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Apne rishtedāroṅ ko sāth le kar us ne us kā tāqqub kiyā. Sāt din chalte chalte us ne Yāqūb ko ā liyā jab wuh Jiliyād ke pahāṛī ilāqe meṅ pahuṅch gayā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Lekin us rāt Allāh ne ḳhāb meṅ Lāban ke pās ā kar us se kahā, “Ḳhabardār! Yāqūb ko burā-bhalā na kahnā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jab Lāban us ke pās pahuṅchā to Yāqūb ne Jiliyād ke pahāṛī ilāqe meṅ apne ḳhaime lagāe hue the. Lāban ne bhī apne rishtedāroṅ ke sāth wahīṅ apne ḳhaime lagāe. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Us ne Yāqūb se kahā, “Yih āp ne kyā kiyā hai? Āp mujhe dhokā de kar merī beṭiyoṅ ko kyoṅ jangī qaidiyoṅ kī tarah hāṅk lāe haiṅ? ");
INSERT INTO urdgvr_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Āp kyoṅ mujhe fareb de kar ḳhāmoshī se bhāg āe haiṅ? Agar āp mujhe ittalā dete to maiṅ āp ko ḳhushī ḳhushī daf aur sarod ke sāth gāte bajāte ruḳhsat kartā. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Āp ne mujhe apne nawāse-nawāsiyoṅ aur beṭiyoṅ ko bosā dene kā mauqā bhī na diyā. Āp kī yih harkat baṛī ahmaqānā thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Maiṅ āp ko bahut nuqsān pahuṅchā saktā hūṅ. Lekin pichhlī rāt āp ke abbū ke Ḳhudā ne mujh se kahā, ‘Ḳhabardār! Yāqūb ko burā-bhalā na kahnā.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ṭhīk hai, āp is lie chale gae ki apne bāp ke ghar wāpas jāne ke baṛe ārzūmand the. Lekin yih āp ne kyā kiyā hai ki mere but churā lāe haiṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yāqūb ne jawāb diyā, “Mujhe ḍar thā ki āp apnī beṭiyoṅ ko mujh se chhīn leṅge. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Lekin agar āp ko yahāṅ kisī ke pās apne but mil jāeṅ to use sazā-e-maut dī jāe hamāre rishtedāroṅ kī maujūdagī meṅ mālūm kareṅ ki mere pās āp kī koī chīz hai ki nahīṅ. Agar hai to use le leṅ.” Yāqūb ko mālūm nahīṅ thā ki Rāḳhil ne butoṅ ko churāyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Lāban Yāqūb ke ḳhaime meṅ dāḳhil huā aur ḍhūṅḍne lagā. Wahāṅ se nikal kar wuh Liyāh ke ḳhaime meṅ aur donoṅ launḍiyoṅ ke ḳhaime meṅ gayā. Lekin us ke but kahīṅ nazar na āe. Āḳhir meṅ wuh Rāḳhil ke ḳhaime meṅ dāḳhil huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rāḳhil butoṅ ko ūṅṭoṅ kī ek kāṭhī ke nīche chhupā kar us par baiṭh gaī thī. Lāban ṭaṭol ṭaṭol kar pūre ḳhaime meṅ se guzarā lekin but na mile. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rāḳhil ne apne bāp se kahā, “Abbū, mujh se nārāz na honā ki maiṅ āp ke sāmne khaṛī nahīṅ ho saktī. Maiṅ aiyām-e-māhwārī ke sabab se uṭh nahīṅ saktī.” Lāban use chhoṛ kar ḍhūṅḍtā rahā, lekin kuchh na milā. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Phir Yāqūb ko ġhussā āyā aur wuh Lāban se jhagaṛne lagā. Us ne pūchhā, “Mujh se kyā jurm sarzad huā hai? Maiṅ ne kyā gunāh kiyā hai ki āp itnī tundī se mere tāqqub ke lie nikle haiṅ? ");
INSERT INTO urdgvr_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Āp ne ṭaṭol ṭaṭol kar mere sāre sāmān kī talāshī lī hai. To āp kā kyā niklā hai? Use yahāṅ apne aur mere rishtedāroṅ ke sāmne rakheṅ. Phir wuh faislā kareṅ ki ham meṅ se kaun haq par hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Maiṅ bīs sāl tak āp ke sāth rahā hūṅ. Us daurān āp kī bheṛ-bakriyāṅ bachchoṅ se mahrūm nahīṅ rahīṅ balki maiṅ ne āp kā ek menḍhā bhī nahīṅ khāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Jab bhī koī bheṛ yā bakrī kisī janglī jānwar ne phāṛ ḍālī to maiṅ use āp ke pās na lāyā balki mujhe ḳhud us kā nuqsān bharnā paṛā. Āp kā taqāzā thā ki maiṅ ḳhud chorī hue māl kā ewazānā dūṅ, ḳhāh wuh din ke waqt chorī huā yā rāt ko. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Maiṅ din kī shadīd garmī ke bāis pighal gayā aur rāt kī shadīd sardī ke bāis jam gayā. Kām itnā saḳht thā ki maiṅ nīnd se mahrūm rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Pūre bīs sāl isī hālat meṅ guzar gae. Chaudah sāl maiṅ ne āp kī beṭiyoṅ ke ewaz kām kiyā aur chhih sāl āp kī bheṛ-bakriyoṅ ke lie. Us daurān āp ne das bār merī tanḳhāh badal dī. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Agar mere bāp Is'hāq kā Ḳhudā aur mere dādā Ibrāhīm kā mābūd mere sāth na hotā to āp mujhe zarūr ḳhālī hāth ruḳhsat karte. Lekin Allāh ne merī musībat aur merī saḳht mehnat-mashaqqat dekhī hai, is lie us ne kal rāt ko mere haq meṅ faislā diyā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Tab Lāban ne Yāqūb se kahā, “Yih beṭiyāṅ to merī beṭiyāṅ haiṅ, aur in ke bachche mere bachche haiṅ. Yih bheṛ-bakriyāṅ bhī merī hī haiṅ. Lekin ab maiṅ apnī beṭiyoṅ aur un ke bachchoṅ ke lie kuchh nahīṅ kar saktā. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Is lie āo, ham ek dūsre ke sāth ahd bāndheṅ. Is ke lie ham yahāṅ pattharoṅ kā ḍher lagāeṅ jo ahd kī gawāhī detā rahe.” ");
INSERT INTO urdgvr_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Chunāṅche Yāqūb ne ek patthar le kar use satūn ke taur par khaṛā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Us ne apne rishtedāroṅ se kahā, “Kuchh patthar jamā kareṅ.” Unhoṅ ne patthar jamā karke ḍher lagā diyā. Phir unhoṅ ne us ḍher ke pās baiṭh kar khānā khāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lāban ne us kā nām Yajr-shāhdūthā rakhā jabki Yāqūb ne Jal-ed rakhā. Donoṅ nāmoṅ kā matlab ‘Gawāhī kā Ḍher’ hai yānī wuh ḍher jo gawāhī detā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Lāban ne kahā, “Āj ham donoṅ ke darmiyān yih ḍher ahd kī gawāhī detā hai.” Is lie us kā nām Jal-ed rakhā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Us kā ek aur nām Misfāh yānī ‘Pahredāroṅ kā Mīnār’ bhī rakhā gayā. Kyoṅki Lāban ne kahā, “Rab ham par pahrā de jab ham ek dūsre se alag ho jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Merī beṭiyoṅ se burā sulūk na karnā, na un ke alāwā kisī aur se shādī karnā. Agar mujhe patā bhī na chale lekin zarūr yād rakheṅ ki Allāh mere aur āp ke sāmne gawāh hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Yahāṅ yih ḍher hai jo maiṅ ne lagā diyā hai aur yahāṅ yih satūn bhī hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Yih ḍher aur satūn donoṅ is ke gawāh haiṅ ki na maiṅ yahāṅ se guzar kar āp ko nuqsān pahuṅchāūṅgā aur na āp yahāṅ se guzar kar mujhe nuqsān pahuṅchāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ibrāhīm, Nahūr aur un ke bāp kā Ḳhudā ham donoṅ ke darmiyān faislā kare agar aisā koī muāmalā ho.” Jawāb meṅ Yāqūb ne Is'hāq ke mābūd kī qasam khāī ki maiṅ yih ahd kabhī nahīṅ toṛūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Us ne pahāṛ par ek jānwar qurbānī ke taur par chaṛhāyā aur apne rishtedāroṅ ko khānā khāne kī dāwat dī. Unhoṅ ne khānā khā kar wahīṅ pahāṛ par rāt guzārī. ");
INSERT INTO urdgvr_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Agle din subah-sawere Lāban ne apne nawāse-nawāsiyoṅ aur beṭiyoṅ ko bosā de kar unheṅ barkat dī. Phir wuh apne ghar wāpas chalā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yāqūb ne bhī apnā safr jārī rakhā. Rāste meṅ Allāh ke farishte us se mile. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Unheṅ dekh kar us ne kahā, “Yih Allāh kī lashkargāh hai.” Us ne us maqām kā nām Mahanāym yānī ‘Do Lashkargāheṅ’ rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yāqūb ne apne bhāī Esau ke pās apne āge āge qāsid bheje. Esau Saīr yānī Adom ke mulk meṅ ābād thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Unheṅ Esau ko batānā thā, “Āp kā ḳhādim Yāqūb āp ko ittalā detā hai ki maiṅ pardes meṅ jā kar ab tak Lāban kā mehmān rahā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Wahāṅ mujhe bail, gadhe, bheṛ-bakriyāṅ, ġhulām aur launḍiyāṅ hāsil hue haiṅ. Ab maiṅ apne mālik ko ittalā de rahā hūṅ ki wāpas ā gayā hūṅ aur āp kī nazar-e-karm kā ḳhāhishmand hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Jab qāsid wāpas āe to unhoṅ ne kahā, “Ham āp ke bhāī Esau ke pās gae. Aur wuh 400 ādmī sāth le kar āp se milne ā rahā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yāqūb ghabrā kar bahut pareshān huā. Us ne apne sāth ke tamām logoṅ, bheṛ-bakriyoṅ, gāy-bailoṅ aur ūṅṭoṅ ko do gurohoṅ meṅ taqsīm kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ḳhayāl yih thā ki agar Esau ā kar ek guroh par hamlā kare to bāqī guroh shāyad bach jāe ");
INSERT INTO urdgvr_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","phir Yāqūb ne duā kī, “Ai mere dādā Ibrāhīm aur mere bāp Is'hāq ke Ḳhudā, merī duā sun! Ai Rab, tū ne ḳhud mujhe batāyā, ‘Apne mulk aur rishtedāroṅ ke pās wāpas jā, aur maiṅ tujhe kāmyābī dūṅgā.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Maiṅ us tamām mehrbānī aur wafādārī ke lāyq nahīṅ jo tū ne apne ḳhādim ko dikhāī hai. Jab maiṅ ne Lāban ke pās jāte waqt Dariyā-e-Yardan ko pār kiyā to mere pās sirf yih lāṭhī thī, aur ab mere pās yih do guroh haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Mujhe apne bhāī Esau se bachā, kyoṅki mujhe ḍar hai ki wuh mujh par hamlā karke bāl-bachchoṅ samet sab kuchh tabāh kar degā. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Tū ne ḳhud kahā thā, ‘Maiṅ tujhe kāmyābī dūṅgā aur terī aulād itnī baṛhāūṅgā ki wuh samundar kī ret kī mānind beshumār hogī.’” ");
INSERT INTO urdgvr_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yāqūb ne wahāṅ rāt guzārī. Phir us ne apne māl meṅ se Esau ke lie tohfe chun lie: ");
INSERT INTO urdgvr_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 bakriyāṅ, 20 bakre, 200 bheṛeṅ, 20 menḍhe, ");
INSERT INTO urdgvr_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 dūdh dene wālī ūṅṭniyāṅ bachchoṅ samet, 40 gāeṅ, 10 bail, 20 gadhiyāṅ aur 10 gadhe. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Us ne unheṅ muḳhtalif rewaṛoṅ meṅ taqsīm karke apne muḳhtalif naukaroṅ ke sapurd kiyā aur un se kahā, “Mere āge āge chalo lekin har rewaṛ ke darmiyān fāsilā rakho.” ");
INSERT INTO urdgvr_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Jo naukar pahle rewaṛ le kar āge niklā us se Yāqūb ne kahā, “Merā bhāī Esau tum se milegā aur pūchhegā, ‘Tumhārā mālik kaun hai? Tum kahāṅ jā rahe ho? Tumhāre sāmne ke jānwar kis ke haiṅ?’ ");
INSERT INTO urdgvr_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Jawāb meṅ tumheṅ kahnā hai, ‘Yih āp ke ḳhādim Yāqūb ke haiṅ. Yih tohfā haiṅ jo wuh apne mālik Esau ko bhej rahe haiṅ. Yāqūb hamāre pīchhe pīchhe ā rahe haiṅ.’” ");
INSERT INTO urdgvr_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yāqūb ne yihī hukm har ek naukar ko diyā jise rewaṛ le kar us ke āge āge jānā thā. Us ne kahā, “Jab tum Esau se miloge to us se yihī kahnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Tumheṅ yih bhī zarūr kahnā hai, āp ke ḳhādim Yāqūb hamāre pīchhe ā rahe haiṅ.” Kyoṅki Yāqūb ne sochā, maiṅ in tohfoṅ se us ke sāth sulah karūṅga. Phir jab us se mulāqāt hogī to shāyad wuh mujhe qabūl kar le. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Yoṅ us ne yih tohfe apne āge āge bhej die. Lekin us ne ḳhud ḳhaimāgāh meṅ rāt guzārī. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Us rāt wuh uṭhā aur apnī do bīwiyoṅ, do launḍiyoṅ aur gyārah beṭoṅ ko le kar Dariyā-e-Yabboq ko wahāṅ se pār kiyā jahāṅ kam gahrāī thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Phir us ne apnā sārā sāmān bhī wahāṅ bhej diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Lekin wuh ḳhud akelā hī pīchhe rah gayā. Us waqt ek ādmī āyā aur pau phaṭne tak us se kushtī laṛtā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Jab us ne dekhā ki maiṅ Yāqūb par ġhālib nahīṅ ā rahā to us ne us ke kūlhe ko chhuā, aur us kā joṛ nikal gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ādmī ne kahā, “Mujhe jāne de, kyoṅki pau phaṭne wālī hai.” Yāqūb ne kahā, “Pahle mujhe barkat deṅ, phir hī āp ko jāne dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ādmī ne pūchhā, “Terā kyā nām hai?” Us ne jawāb diyā, “Yāqūb.” ");
INSERT INTO urdgvr_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ādmī ne kahā, “Ab se terā nām Yāqūb nahīṅ balki Isrāīl yānī ‘Wuh Allāh se Laṛtā Hai’ hogā. Kyoṅki tū Allāh aur ādmiyoṅ ke sāth laṛ kar ġhālib āyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yāqūb ne kahā, “Mujhe apnā nām batāeṅ.” Us ne kahā, “Tū kyoṅ merā nām jānanā chāhtā hai?” Phir us ne Yāqūb ko barkat dī. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yāqūb ne kahā, “Maiṅ ne Allāh ko rūbarū dekhā to bhī bach gayā hūṅ.” Is lie us ne us maqām kā nām Faniyel rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yāqūb wahāṅ se chalā to sūraj tulū ho rahā thā. Wuh kūlhe ke sabab se langaṛātā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Yihī wajah hai ki āj bhī Isrāīl kī aulād kūlhe ke joṛ par kī nas ko nahīṅ khāte, kyoṅki Yāqūb kī isī nas ko chhuā gayā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Phir Esau un kī taraf ātā huā nazar āyā. Us ke sāth 400 ādmī the. Unheṅ dekh kar Yāqūb ne bachchoṅ ko bāṅṭ kar Liyāh, Rāḳhil aur donoṅ launḍiyoṅ ke hawāle kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Us ne donoṅ launḍiyoṅ ko un ke bachchoṅ samet āge chalne diyā. Phir Liyāh us ke bachchoṅ samet aur āḳhir meṅ Rāḳhil aur Yūsuf āe. ");
INSERT INTO urdgvr_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yāqūb ḳhud sab se āge Esau se milne gayā. Chalte chalte wuh sāt dafā zamīn tak jhukā. ");
INSERT INTO urdgvr_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Lekin Esau dauṛ kar us se milne āyā aur use gale lagā kar bosā diyā. Donoṅ ro paṛe. ");
INSERT INTO urdgvr_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Phir Esau ne auratoṅ aur bachchoṅ ko dekhā. Us ne pūchhā, “Tumhāre sāth yih log kaun haiṅ?” Yāqūb ne kahā, “Yih āp ke ḳhādim ke bachche haiṅ jo Allāh ne apne karm se nawāze haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Donoṅ launḍiyāṅ apne bachchoṅ samet ā kar us ke sāmne jhuk gaīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Phir Liyāh apne bachchoṅ ke sāth āī aur āḳhir meṅ Yūsuf aur Rāḳhil ā kar jhuk gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau ne pūchhā, “Jis jānwaroṅ ke baṛe ġhol se merī mulāqāt huī us se kyā murād hai?” Yāqūb ne jawāb diyā, “Yih tohfā hai tāki āp kā ḳhādim āp kī nazar meṅ maqbūl ho.” ");
INSERT INTO urdgvr_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Lekin Esau ne kahā, “Mere bhāī, mere pās bahut kuchh hai. Yih apne pās hī rakho.” ");
INSERT INTO urdgvr_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yāqūb ne kahā, “Nahīṅ jī, agar mujh par āp ke karm kī nazar hai to mere is tohfe ko zarūr qabūl farmāeṅ. Kyoṅki jab maiṅ ne āp kā chehrā dekhā to wuh mere lie Allāh ke chehre kī mānind thā, āp ne mere sāth is qadar achchhā sulūk kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Mehrbānī karke yih tohfā qabūl kareṅ jo maiṅ āp ke lie lāyā hūṅ. Kyoṅki Allāh ne mujh par apne karm kā izhār kiyā hai, aur mere pās bahut kuchh hai.” Yāqūb isrār kartā rahā to āḳhirkār Esau ne use qabūl kar liyā. Phir Esau kahne lagā, ");
INSERT INTO urdgvr_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","“Āo, ham rawānā ho jāeṅ. Maiṅ tumhāre āge āge chalūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yāqūb ne jawāb diyā, “Mere mālik, āp jānte haiṅ ki mere bachche nāzuk haiṅ. Mere pās bheṛ-bakriyāṅ, gāy-bail aur un ke dūdh pīne wāle bachche bhī haiṅ. Agar maiṅ unheṅ ek din ke lie bhī had se zyādā hāṅkūṅ to wuh mar jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mere mālik, mehrbānī karke mere āge āge jāeṅ. Maiṅ ārām se usī raftār se āp ke pīchhe pīchhe chaltā rahūṅgā jis raftār se mere maweshī aur mere bachche chal sakeṅge. Yoṅ ham āhistā chalte hue āp ke pās Saīr pahuṅcheṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau ne kahā, “Kyā maiṅ apne ādmiyoṅ meṅ se kuchh āp ke pās chhoṛ dūṅ?” Lekin Yāqūb ne kahā, “Kyā zarūrat hai? Sab se aham bāt yih hai ki āp ne mujhe qabūl kar liyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Us din Esau Saīr ke lie aur ");
INSERT INTO urdgvr_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yāqūb Sukkāt ke lie rawānā huā. Wahāṅ us ne apne lie makān banā liyā aur apne maweshiyoṅ ke lie jhoṅpṛiyāṅ. Is lie us maqām kā nām Sukkāt yānī Jhoṅpṛiyāṅ paṛ gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Phir Yāqūb chalte chalte salāmatī se Sikam Shahr pahuṅchā. Yoṅ us kā Masoputāmiyā se Mulk-e-Kanān tak kā safr iḳhtitām tak pahuṅch gayā. Us ne apne ḳhaime shahr ke sāmne lagāe. ");
INSERT INTO urdgvr_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Us ke ḳhaime Hamor kī aulād kī zamīn par lage the. Us ne yih zamīn chāṅdī ke 100 sikkoṅ ke badle ḳharīd lī. ");
INSERT INTO urdgvr_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Wahāṅ us ne qurbāngāh banāī jis kā nām us ne ‘El Ḳhudā-e-Isrāīl’ rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ek din Yāqūb aur Liyāh kī beṭī Dīnā Kanānī auratoṅ se milne ke lie ghar se niklī. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Shahr meṅ ek ādmī banām Sikam rahtā thā. Us kā wālid Hamor us ilāqe kā hukmrān thā aur Hiwwī qaum se tālluq rakhtā thā. Jab Sikam ne Dīnā ko dekhā to us ne use pakaṛ kar us kī ismatdarī kī. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Lekin us kā dil Dīnā se lag gayā. Wuh us se muhabbat karne lagā aur pyār se us se bāteṅ kartā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Us ne apne bāp se kahā, “Is laṛkī ke sāth merī shādī karā deṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jab Yāqūb ne apnī beṭī kī ismatdarī kī ḳhabar sunī to us ke beṭe maweshiyoṅ ke sāth khule maidān meṅ the. Is lie wuh un ke wāpas āne tak ḳhāmosh rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Sikam kā bāp Hamor shahr se nikal kar Yāqūb se bāt karne ke lie āyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Jab Yāqūb ke beṭoṅ ko Dīnā kī ismatdarī kī ḳhabar milī to un ke dil ranjish aur ġhusse se bhar gae ki Sikam ne Yāqūb kī beṭī kī ismatdarī se Isrāīl kī itnī be'izzatī kī hai. Wuh sīdhe khule maidān se wāpas āe. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor ne Yāqūb se kahā, “Mere beṭe kā dil āp kī beṭī se lag gayā hai. Mehrbānī karke us kī shādī mere beṭe ke sāth kar deṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Hamāre sāth rishtā bāndheṅ, hamāre beṭe-beṭiyoṅ ke sāth shādiyāṅ karāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Phir āp hamāre sāth is mulk meṅ rah sakeṅge aur pūrā mulk āp ke lie khulā hogā. Āp jahāṅ bhī chāheṅ ābād ho sakeṅge, tijārat kar sakeṅge aur zamīn ḳharīd sakeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sikam ne ḳhud bhī Dīnā ke bāp aur bhāiyoṅ se minnat kī, “Agar merī yih darḳhāst manzūr ho to maiṅ jo kuchh āp kaheṅge adā kar dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Jitnā bhī mahr aur tohfe āp muqarrar kareṅ maiṅ de dūṅgā. Sirf merī yih ḳhāhish pūrī kareṅ ki yih laṛkī mere aqd meṅ ā jāe.” ");
INSERT INTO urdgvr_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Lekin Dīnā kī ismatdarī ke sabab se Yāqūb ke beṭoṅ ne Sikam aur us ke bāp Hamor se chālākī karke ");
INSERT INTO urdgvr_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","kahā, “Ham aisā nahīṅ kar sakte. Ham apnī bahan kī shādī kisī aise ādmī se nahīṅ karā sakte jis kā ḳhatnā nahīṅ huā. Is se hamārī be'izzatī hotī hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ham sirf is shart par rāzī hoṅge ki āp apne tamām laṛkoṅ aur mardoṅ kā ḳhatnā karwāne se hamārī mānind ho jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Phir āp ke beṭe-beṭiyoṅ ke sāth hamārī shādiyāṅ ho sakeṅgī aur ham āp ke sāth ek qaum ban jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Lekin agar āp ḳhatnā karāne ke lie taiyār nahīṅ haiṅ to ham apnī bahan ko le kar chale jāeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Yih bāteṅ Hamor aur us ke beṭe Sikam ko achchhī lagīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Naujawān Sikam ne fauran un par amal kiyā, kyoṅki wuh Dīnā ko bahut pasand kartā thā. Sikam apne ḳhāndān meṅ sab se muazzaz thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor apne beṭe Sikam ke sāth shahr ke darwāze par gayā jahāṅ shahr ke faisle kie jāte the. Wahāṅ unhoṅ ne bāqī shahriyoṅ se bāt kī. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Yih ādmī ham se jhagaṛne wāle nahīṅ haiṅ, is lie kyoṅ na wuh is mulk meṅ hamāre sāth raheṅ aur hamāre darmiyān tijārat kareṅ? Hamāre mulk meṅ un ke lie bhī kāfī jagah hai. Āo, ham un kī beṭiyoṅ aur beṭoṅ se shādiyāṅ kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Lekin yih ādmī sirf is shart par hamāre darmiyān rahne aur ek hī qaum banane ke lie taiyār haiṅ ki ham un kī tarah apne tamām laṛkoṅ aur mardoṅ kā ḳhatnā karāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Agar ham aisā kareṅ to un ke tamām maweshī aur sārā māl hamārā hī hogā. Chunāṅche āo, ham muttafiq ho kar faislā kar leṅ tāki wuh hamāre darmiyān raheṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Sikam ke shahrī Hamor aur Sikam ke mashware par rāzī hue. Tamām laṛkoṅ aur mardoṅ kā ḳhatnā karāyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Tīn din ke bād jab ḳhatne ke sabab se logoṅ kī hālat burī thī to Dīnā ke do bhāī Shamāūn aur Lāwī apnī talwāreṅ le kar shahr meṅ dāḳhil hue. Kisī ko shak tak nahīṅ thā ki kyā kuchh hogā. Andar jā kar unhoṅ ne bachchoṅ se le kar būṛhoṅ tak tamām mardoṅ ko qatl kar diyā ");
INSERT INTO urdgvr_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","jin meṅ Hamor aur us kā beṭā Sikam bhī shāmil the. Phir wuh Dīnā ko Sikam ke ghar se le kar chale gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Is qatl-e-ām ke bād Yāqūb ke bāqī beṭe shahr par ṭūṭ paṛe aur use lūṭ liyā. Yoṅ unhoṅ ne apnī bahan kī ismatdarī kā badlā liyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Wuh bheṛ-bakriyāṅ, gāy-bail, gadhe aur shahr ke andar aur bāhar kā sab kuchh le kar chalte bane. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Unhoṅ ne sāre māl par qabzā kiyā, auratoṅ aur bachchoṅ ko qaidī banā liyā aur tamām gharoṅ kā sāmān bhī le gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Phir Yāqūb ne Shamāūn aur Lāwī se kahā, “Tum ne mujhe musībat meṅ ḍāl diyā hai. Ab Kanānī, Farizzī aur mulk ke bāqī bāshindoṅ meṅ merī badnāmī huī hai. Mere sāth kam ādmī haiṅ. Agar dūsre mil kar ham par hamlā kareṅ to hamāre pūre ḳhāndān kā satyānās ho jāegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Lekin unhoṅ ne kahā, “Kyā yih ṭhīk thā ki us ne hamārī bahan ke sāth kasbī kā-sā sulūk kiyā?” ");
INSERT INTO urdgvr_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Allāh ne Yāqūb se kahā, “Uṭh, Baitel jā kar wahāṅ ābād ho. Wahīṅ Allāh ke lie jo tujh par zāhir huā jab tū apne bhāī Esau se bhāg rahā thā qurbāngāh banā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Chunāṅche Yāqūb ne apne ghar wāloṅ aur bāqī sāre sāthiyoṅ se kahā, “Jo bhī ajnabī but āp ke pās haiṅ unheṅ phaiṅk deṅ. Apne āp ko pāk-sāf karke apne kapṛe badleṅ, ");
INSERT INTO urdgvr_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","kyoṅki hameṅ yih jagah chhoṛ kar Baitel jānā hai. Wahāṅ maiṅ us Ḳhudā ke lie qurbāngāh banāūṅgā jis ne musībat ke waqt merī duā sunī. Jahāṅ bhī maiṅ gayā wahāṅ wuh mere sāth rahā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Yih sun kar unhoṅ ne Yāqūb ko tamām but de die jo un ke pās the aur tamām bāliyāṅ jo unhoṅ ne tāwīz ke taur par kānoṅ meṅ pahan rakhī thīṅ. Us ne sab kuchh Sikam ke qarīb balūt ke daraḳht ke nīche zamīn meṅ dabā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Phir wuh rawānā hue. Irdgird ke shahroṅ par Allāh kī taraf se itnā shadīd ḳhauf chhā gayā ki unhoṅ ne Yāqūb aur us ke beṭoṅ kā tāqqub na kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Chalte chalte Yāqūb apne logoṅ samet Lūz pahuṅch gayā jo Mulk-e-Kanān meṅ thā. Āj Lūz kā nām Baitel hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yāqūb ne wahāṅ qurbāngāh banā kar maqām kā nām Baitel yānī ‘Allāh kā Ghar’ rakhā. Kyoṅki wahāṅ Allāh ne apne āp ko us par zāhir kiyā thā jab wuh apne bhāī se farār ho rahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Wahāṅ Ribqā kī dāyā Daborā mar gaī. Wuh Baitel ke junūb meṅ balūt ke daraḳht ke nīche dafn huī, is lie us kā nām Allon-bakūt yānī ‘Rone kā Balūt kā Daraḳht’ rakhā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Allāh Yāqūb par ek dafā aur zāhir huā aur use barkat dī. Yih Masoputāmiyā se wāpas āne par dūsrī bār huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Allāh ne us se kahā, “Ab se terā nām Yāqūb nahīṅ balki Isrāīl hogā.” Yoṅ us ne us kā nayā nām Isrāīl rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Allāh ne yih bhī us se kahā, “Maiṅ Allāh Qādir-e-mutlaq hūṅ. Phal-phūl aur tādād meṅ baṛhtā jā. Ek qaum nahīṅ balki bahut-sī qaumeṅ tujh se nikleṅgī. Terī aulād meṅ bādshāh bhī shāmil hoṅge. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Maiṅ tujhe wuhī mulk dūṅgā jo Ibrāhīm aur Is'hāq ko diyā hai. Aur tere bād use terī aulād ko dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Phir Allāh wahāṅ se āsmān par chalā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jahāṅ Allāh Yāqūb se hamkalām huā thā wahāṅ us ne patthar kā satūn khaṛā kiyā aur us par mai aur tel unḍel kar use maḳhsūs kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Us ne jagah kā nām Baitel rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Phir Yāqūb apne ghar wāloṅ ke sāth Baitel ko chhoṛ kar Ifrātā kī taraf chal paṛā. Rāḳhil ummīd se thī, aur rāste meṅ bachche kī paidāish kā waqt ā gayā. Bachchā baṛī mushkil se paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Jab dard-e-zah urūj ko pahuṅch gayā to dāī ne us se kahā, “Mat ḍaro, kyoṅki ek aur beṭā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Lekin wuh dam toṛne wālī thī, aur marte marte us ne us kā nām Bin-ūnī yānī ‘Merī Musībat kā Beṭā’ rakhā. Lekin us ke bāp ne us kā nām Binyamīn yānī ‘Dahne Hāth yā Ḳhushqismatī kā Beṭā’ rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rāḳhil faut huī, aur wuh Ifrātā ke rāste meṅ dafn huī. Ājkal Ifrātā ko Bait-laham kahā jātā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yāqūb ne us kī qabr par patthar kā satūn khaṛā kiyā. Wuh āj tak Rāḳhil kī qabr kī nishāndihī kartā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Wahāṅ se Yāqūb ne apnā safr jārī rakhā aur Mijdal-idar kī parlī taraf apne ḳhaime lagāe. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Jab wuh wahāṅ ṭhahre the to Rūbin Yāqūb kī haram Bilhāh se hambistar huā. Yāqūb ko mālūm ho gayā. Yāqūb ke bārah beṭe the. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Liyāh ke beṭe yih the: us kā sab se baṛā beṭā Rūbin, phir Shamāūn, Lāwī, Yahūdāh, Ishkār aur Zabūlūn. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rāḳhil ke do beṭe the, Yūsuf aur Binyamīn. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rāḳhil kī launḍī Bilhāh ke do beṭe the, Dān aur Naftālī. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Liyāh kī launḍī Zilfā ke do beṭe the, Jad aur Āshar. Yāqūb ke yih beṭe Masoputāmiyā meṅ paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Phir Yāqūb apne bāp Is'hāq ke pās pahuṅch gayā jo Habrūn ke qarīb Mamre meṅ ajnabī kī haisiyat se rahtā thā. (Us waqt Habrūn kā nām Qiriyat-arbā thā.) Wahāṅ Is'hāq aur us se pahle Ibrāhīm rahā karte the. ");
INSERT INTO urdgvr_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Is'hāq 180 sāl kā thā jab wuh umrrasīdā aur zindagī se āsūdā ho kar apne bāpdādā se jā milā. Us ke beṭe Esau aur Yāqūb ne use dafn kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Yih Esau kī aulād kā nasabnāmā hai (Esau ko Adom bhī kahā jātā hai): ");
INSERT INTO urdgvr_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau ne tīn Kanānī auratoṅ se shādī kī: Hittī ādmī Ailon kī beṭī Adā se, Anā kī beṭī Uhlībāmā se jo Hiwwī ādmī Sibaon kī nawāsī thī ");
INSERT INTO urdgvr_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","aur Ismāīl kī beṭī Bāsamat se jo Nabāyot kī bahan thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adā kā ek beṭā Ilīfaz aur Bāsamat kā ek beṭā Raūel paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Uhlībāmā ke tīn beṭe paidā hue, Yaūs, Yālām aur Qorah. Esau ke yih tamām beṭe Mulk-e-Kanān meṅ paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Bād meṅ Esau dūsre mulk meṅ chalā gayā. Us ne apnī bīwiyoṅ, beṭe-beṭiyoṅ aur ghar ke rahne wāloṅ ko apne tamām maweshiyoṅ aur Mulk-e-Kanān meṅ hāsil kie hue māl samet apne sāth liyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Wuh is wajah se chalā gayā ki donoṅ bhāiyoṅ ke pās itne rewaṛ the ki charāne kī jagah kam paṛ gaī. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Chunāṅche Esau pahāṛī ilāqe Saīr meṅ ābād huā. Esau kā dūsrā nām Adom hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Yih Esau yānī Saīr ke pahāṛī ilāqe meṅ ābād Adomiyoṅ kā nasabnāmā hai: ");
INSERT INTO urdgvr_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau kī bīwī Adā kā ek beṭā Ilīfaz thā jabki us kī bīwī Bāsamat kā ek beṭā Raūel thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ilīfaz ke beṭe Temān, Omar, Safo, Jātām, Qanaz ");
INSERT INTO urdgvr_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","aur Amālīq the. Amālīq Ilīfaz kī haram Timnā kā beṭā thā. Yih sab Esau kī bīwī Adā kī aulād meṅ shāmil the. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Raūel ke beṭe Nahat, Zārah, Sammā aur Mizzā the. Yih sab Esau kī bīwī Bāsamat kī aulād meṅ shāmil the. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau kī bīwī Uhlībāmā jo Anā kī beṭī aur Sibaon kī nawāsī thī ke tīn beṭe Yaūs, Yālām aur Qorah the. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esau se muḳhtalif qabīloṅ ke sardār nikle. Us ke pahlauṭhe Ilīfaz se yih qabāylī sardār nikle: Temān, Omar, Safo, Qanaz, ");
INSERT INTO urdgvr_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Qorah, Jātām aur Amālīq. Yih sab Esau kī bīwī Adā kī aulād the. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau ke beṭe Raūel se yih qabāylī sardār nikle: Nahat, Zārah, Sammā aur Mizzā. Yih sab Esau kī bīwī Bāsamat kī aulād the. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau kī bīwī Uhlībāmā yānī Anā kī beṭī se yih qabāylī sardār nikle: Yaūs, Yālām aur Qorah. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Yih tamām sardār Esau kī aulād haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Mulk-e-Adom ke kuchh bāshinde Horī ādmī Saīr kī aulād the. Un ke nām Lotān, Sobal, Sibaon, Anā, ");
INSERT INTO urdgvr_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dīson, Esar aur Dīsān the. Saīr ke yih beṭe Mulk-e-Adom meṅ Horī qabīloṅ ke sardār the. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotān Horī aur Hemām kā bāp thā. (Timnā Lotān kī bahan thī.) ");
INSERT INTO urdgvr_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal ke beṭe Alwān, Mānahat, Aibāl, Safo aur Onām the. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibaon ke beṭe Aiyāh aur Anā the. Isī Anā ko garm chashme mile jab wuh bayābān meṅ apne bāp ke gadhe charā rahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anā kā ek beṭā Dīson aur ek beṭī Uhlībāmā thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dīson ke chār beṭe Hamdān, Ishbān, Yitrān aur Kirān the. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esar ke tīn beṭe Bilhān, Zāwān aur Aqān the. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dīsān ke do beṭe Ūz aur Arān the. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Yihī yānī Lotān, Sobal, Sibaon, Anā, Dīson, Esar aur Dīsān Saīr ke mulk meṅ Horī qabāyl ke sardār the. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Is se pahle ki Isrāīliyoṅ kā koī bādshāh thā zail ke bādshāh yake bād dīgare Mulk-e-Adom meṅ hukūmat karte the: ");
INSERT INTO urdgvr_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bālā bin Bor jo Dinhābā Shahr kā thā Mulk-e-Adom kā pahlā bādshāh thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Us kī maut par Yūbāb bin Zārah jo Busrā Shahr kā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Us kī maut par Hushām jo Temāniyoṅ ke mulk kā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Us kī maut par Hadad bin Bidad jis ne Mulk-e-Moāb meṅ Midiyāniyoṅ ko shikast dī. Wuh Awīt kā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Us kī maut par Samlā jo Masriqā kā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Us kī maut par Sāūl jo Dariyā-e-Furāt par Rahobot Shahr kā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Us kī maut par Bāl-hanān bin Akbor. ");
INSERT INTO urdgvr_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Us kī maut par Hadad jo Fāū Shahr kā thā. (Bīwī kā nām Mahetabel bint Matrid bint Mezāhāb thā.) ");
INSERT INTO urdgvr_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Esau se Adomī qabīloṅ ke yih sardār nikle: Timnā, Alwah, Yatet, Uhlībāmā, Ailā, Fīnon, Qanaz, Temān, Mibsār, Majdiyel aur Irām. Adom ke sardāroṅ kī yih fahrist un kī maurūsī zamīn kī ābādiyoṅ aur qabīloṅ ke mutābiq hī bayān kī gaī hai. Esau un kā bāp hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yāqūb Mulk-e-Kanān meṅ rahtā thā jahāṅ pahle us kā bāp bhī pardesī thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yih Yāqūb ke ḳhāndān kā bayān hai. Us waqt Yāqūb kā beṭā Yūsuf 17 sāl kā thā. Wuh apne bhāiyoṅ yānī Bilhāh aur Zilfā ke beṭoṅ ke sāth bheṛ-bakriyoṅ kī dekh-bhāl kartā thā. Yūsuf apne bāp ko apne bhāiyoṅ kī burī harkatoṅ kī ittalā diyā kartā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yāqūb Yūsuf ko apne tamām beṭoṅ kī nisbat zyādā pyār kartā thā. Wajah yih thī ki wuh tab paidā huā jab bāp būṛhā thā. Is lie Yāqūb ne us ke lie ek ḳhās rangdār libās banwāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Jab us ke bhāiyoṅ ne dekhā ki hamārā bāp Yūsuf ko ham se zyādā pyār kartā hai to wuh us se nafrat karne lage aur adab se us se bāt nahīṅ karte the. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ek rāt Yūsuf ne ḳhāb dekhā. Jab us ne apne bhāiyoṅ ko ḳhāb sunāyā to wuh us se aur bhī nafrat karne lage. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Us ne kahā, “Suno, maiṅ ne ḳhāb dekhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ham sab khet meṅ pūle bāndh rahe the ki merā pūlā khaṛā ho gayā. Āp ke pūle mere pūle ke irdgird jamā ho kar us ke sāmne jhuk gae.” ");
INSERT INTO urdgvr_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Us ke bhāiyoṅ ne kahā, “Achchhā, tū bādshāh ban kar ham par hukūmat karegā?” Us ke ḳhāboṅ aur us kī bātoṅ ke sabab se un kī us se nafrat mazīd baṛh gaī. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Kuchh der ke bād Yūsuf ne ek aur ḳhāb dekhā. Us ne apne bhāiyoṅ se kahā, “Maiṅ ne ek aur ḳhāb dekhā hai. Us meṅ sūraj, chāṅd aur gyārah sitāre mere sāmne jhuk gae.” ");
INSERT INTO urdgvr_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Us ne yih ḳhāb apne bāp ko bhī sunāyā to us ne use ḍānṭā. Us ne kahā, “Yih kaisā ḳhāb hai jo tū ne dekhā! Yih kaisī bāt hai ki maiṅ, terī māṅ aur tere bhāī ā kar tere sāmne zamīn tak jhuk jāeṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Natīje meṅ us ke bhāī us se bahut hasad karne lage. Lekin us ke bāp ne dil meṅ yih bāt mahfūz rakhī. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ek din jab Yūsuf ke bhāī apne bāp ke rewaṛ charāne ke lie Sikam tak pahuṅch gae the ");
INSERT INTO urdgvr_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","to Yāqūb ne Yūsuf se kahā, “Tere bhāī Sikam meṅ rewaṛoṅ ko charā rahe haiṅ. Ā, maiṅ tujhe un ke pās bhej detā hūṅ.” Yūsuf ne jawāb diyā, “Ṭhīk hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yāqūb ne kahā, “Jā kar mālūm kar ki tere bhāī aur un ke sāth ke rewaṛ ḳhairiyat se haiṅ ki nahīṅ. Phir wāpas ā kar mujhe batā denā.” Chunāṅche us ke bāp ne use Wādī-e-Habrūn se bhej diyā, aur Yūsuf Sikam pahuṅch gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Wahāṅ wuh idhar-udhar phirtā rahā. Āḳhirkār ek ādmī us se milā aur pūchhā, “Āp kyā ḍhūnḍ rahe haiṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yūsuf ne jawāb diyā, “Maiṅ apne bhāiyoṅ ko talāsh kar rahā hūṅ. Mujhe batāeṅ ki wuh apne jānwaroṅ ko kahāṅ charā rahe haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ādmī ne kahā, “Wuh yahāṅ se chale gae haiṅ. Maiṅ ne unheṅ yih kahte sunā ki āo, ham Dūtain jāeṅ.” Yih sun kar Yūsuf apne bhāiyoṅ ke pīchhe Dūtain chalā gayā. Wahāṅ use wuh mil gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Jab Yūsuf abhī dūr se nazar āyā to us ke bhāiyoṅ ne us ke pahuṅchne se pahle use qatl karne kā mansūbā banāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Unhoṅ ne kahā, “Dekho, ḳhāb deḳhne wālā ā rahā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Āo, ham use mār ḍāleṅ aur us kī lāsh kisī gaṛhe meṅ phaiṅk deṅ. Ham kaheṅge ki kisī wahshī jānwar ne use phāṛ khāyā hai. Phir patā chalegā ki us ke ḳhāboṅ kī kyā haqīqat hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Jab Rūbin ne un kī bāteṅ sunīṅ to us ne Yūsuf ko bachāne kī koshish kī. Us ne kahā, “Nahīṅ, ham use qatl na kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Us kā ḳhūn na karnā. Beshak use is gaṛhe meṅ phaiṅk deṅ jo registān meṅ hai, lekin use hāth na lagāeṅ.” Us ne yih is lie kahā ki wuh use bachā kar bāp ke pās wāpas pahuṅchānā chāhtā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Jyoṅ hī Yūsuf apne bhāiyoṅ ke pās pahuṅchā unhoṅ ne us kā rangdār libās utār kar ");
INSERT INTO urdgvr_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Yūsuf ko gaṛhe meṅ phaiṅk diyā. Gaṛhā ḳhālī thā, us meṅ pānī nahīṅ thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Phir wuh roṭī khāne ke lie baiṭh gae. Achānak Ismāīliyoṅ kā ek qāfilā nazar āyā. Wuh Jiliyād se Misr jā rahe the, aur un ke ūṅṭ qīmtī masāloṅ yānī lādan, balsān aur mur se lade hue the. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Tab Yahūdāh ne apne bhāiyoṅ se kahā, “Hameṅ kyā fāydā hai agar apne bhāī ko qatl karke us ke ḳhūn ko chhupā deṅ? ");
INSERT INTO urdgvr_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Āo, ham use in Ismāīliyoṅ ke hāth faroḳht kar deṅ. Phir koī zarūrat nahīṅ hogī ki ham use hāth lagāeṅ. Āḳhir wuh hamārā bhāī hai.” Us ke bhāī rāzī hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Chunāṅche jab Midiyānī tājir wahāṅ se guzare to bhāiyoṅ ne Yūsuf ko khīṅch kar gaṛhe se nikālā aur chāṅdī ke 20 sikkoṅ ke ewaz bech ḍālā. Ismāīlī use le kar Misr chale gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Us waqt Rūbin maujūd nahīṅ thā. Jab wuh gaṛhe ke pās wāpas āyā to Yūsuf us meṅ nahīṅ thā. Yih dekh kar us ne pareshānī meṅ apne kapṛe phāṛ ḍāle. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Wuh apne bhāiyoṅ ke pās wāpas gayā aur kahā, “Laṛkā nahīṅ hai. Ab maiṅ kis tarah Abbū ke pās jāūṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Tab unhoṅ ne bakrā zabah karke Yūsuf kā libās us ke ḳhūn meṅ ḍuboyā, ");
INSERT INTO urdgvr_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","phir rangdār libās is ḳhabar ke sāth apne bāp ko bhijwā diyā ki “Hameṅ yih milā hai. Ise ġhaur se dekheṅ. Yih āp ke beṭe kā libās to nahīṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yāqūb ne use pahchān liyā aur kahā, “Beshak usī kā hai. Kisī wahshī jānwar ne use phāṛ khāyā hai. Yaqīnan Yūsuf ko phāṛ diyā gayā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yāqūb ne ġham ke māre apne kapṛe phāṛe aur apnī kamr se ṭāṭ oṛh kar baṛī der tak apne beṭe ke lie mātam kartā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Us ke tamām beṭe-beṭiyāṅ use tasallī dene āe, lekin us ne tasallī pāne se inkār kiyā aur kahā, “Maiṅ Pātāl meṅ utarte hue bhī apne beṭe ke lie mātam karūṅga.” Is hālat meṅ wuh apne beṭe ke lie rotā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Itne meṅ Midiyānī Misr pahuṅch kar Yūsuf ko bech chuke the. Misr ke bādshāh Firaun ke ek ālā afsar Fūtīfār ne use ḳharīd liyā. Fūtīfār bādshāh ke muhāfizoṅ par muqarrar thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Un dinoṅ meṅ Yahūdāh apne bhāiyoṅ ko chhoṛ kar ek ādmī ke pās rahne lagā jis kā nām Hīrā thā aur jo Adullām Shahr se thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Wahāṅ Yahūdāh kī mulāqāt ek Kanānī aurat se huī jis ke bāp kā nām Sua thā. Us ne us se shādī kī. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Beṭā paidā huā jis kā nām Yahūdāh ne Er rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ek aur beṭā paidā huā jis kā nām bīwī ne Onān rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Us ke tīsrā beṭā bhī paidā huā. Us ne us kā nām Selā rakhā. Yahūdāh qazīb meṅ thā jab wuh paidā huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yahūdāh ne apne baṛe beṭe Er kī shādī ek laṛkī se karāī jis kā nām Tamr thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Rab ke nazdīk Er sharīr thā, is lie us ne use halāk kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Is par Yahūdāh ne Er ke chhoṭe bhāī Onān se kahā, “Apne baṛe bhāī kī bewā ke pās jāo aur us se shādī karo tāki tumhāre bhāī kī nasl qāym rahe.” ");
INSERT INTO urdgvr_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onān ne aisā kiyā, lekin wuh jāntā thā ki jo bhī bachche paidā hoṅge wuh qānūn ke mutābiq mere baṛe bhāī ke hoṅge. Is lie jab bhī wuh Tamr se hambistar hotā to nutfā ko zamīn par girā detā, kyoṅki wuh nahīṅ chāhtā thā ki merī mārifat mere bhāī ke bachche paidā hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Yih bāt Rab ko burī lagī, aur us ne use bhī sazā-e-maut dī. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Tab Yahūdāh ne apnī bahū Tamr se kahā, “Apne bāp ke ghar wāpas chalī jāo aur us waqt tak bewā raho jab tak merā beṭā Selā baṛā na ho jāe.” Us ne yih is lie kahā ki use ḍar thā ki kahīṅ Selā bhī apne bhāiyoṅ kī tarah mar na jāe chunāṅche Tamr apne maike chalī gaī. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Kāfī dinoṅ ke bād Yahūdāh kī bīwī jo Sua kī beṭī thī mar gaī. Mātam kā waqt guzar gayā to Yahūdāh apne Adullāmī dost Hīrā ke sāth Timnat gayā jahāṅ Yahūdāh kī bheṛoṅ kī pashm katrī jā rahī thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamr ko batāyā gayā, “Āp kā susar apnī bheṛoṅ kī pashm katarne ke lie Timnat jā rahā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Yih sun kar Tamr ne bewā ke kapṛe utār kar ām kapṛe pahan lie. Phir wuh apnā muṅh chādar se lapeṭ kar Ainīm Shahr ke darwāze par baiṭh gaī jo Timnat ke rāste meṅ thā. Tamr ne yih harkat is lie kī ki Yahūdāh kā beṭā Selā ab bāliġh ho chukā thā to bhī us kī us ke sāth shādī nahīṅ kī gaī thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Jab Yahūdāh wahāṅ se guzarā to us ne use dekh kar sochā ki yih kasbī hai, kyoṅki us ne apnā muṅh chhupāyā huā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Wuh rāste se haṭ kar us ke pās gayā aur kahā, “Zarā mujhe apne hāṅ āne deṅ.” (Us ne nahīṅ pahchānā ki yih merī bahū hai.) Tamr ne kahā, “Āp mujhe kyā deṅge?” ");
INSERT INTO urdgvr_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Us ne jawāb diyā, “Maiṅ āp ko bakrī kā bachchā bhej dūṅgā.” Tamr ne kahā, “Ṭhīk hai, lekin use bhejne tak mujhe zamānat deṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Us ne pūchhā, “Maiṅ āp ko kyā dūṅ?” Tamr ne kahā, “Apnī muhr aur use gale meṅ laṭkāne kī ḍorī. Wuh lāṭhī bhī deṅ jo āp pakaṛe hue haiṅ.” Chunāṅche Yahūdāh use yih chīzeṅ de kar us ke sāth hambistar huā. Natīje meṅ Tamr ummīd se huī. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Phir Tamr uṭh kar apne ghar wāpas chalī gaī. Us ne apnī chādar utār kar dubārā bewā ke kapṛe pahan lie. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yahūdāh ne apne dost Hīrā Adullāmī ke hāth bakrī kā bachchā bhej diyā tāki wuh chīzeṅ wāpas mil jāeṅ jo us ne zamānat ke taur par dī thīṅ. Lekin Hīrā ko patā na chalā ki aurat kahāṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Us ne Ainīm ke bāshindoṅ se pūchhā, “Wuh kasbī kahāṅ hai jo yahāṅ saṛak par baiṭhī thī?” Unhoṅ ne jawāb diyā, “Yahāṅ aisī koī kasbī nahīṅ thī.” ");
INSERT INTO urdgvr_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Us ne Yahūdāh ke pās wāpas jā kar kahā, “Wuh mujhe nahīṅ milī balki wahāṅ ke rahne wāloṅ ne kahā ki yahāṅ koī aisī kasbī thī nahīṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yahūdāh ne kahā, “Phir wuh zamānat kī chīzeṅ apne pās hī rakhe. Use chhoṛ do warnā log hamārā mazāq uṛāeṅge. Ham ne to pūrī koshish kī ki use bakrī kā bachchā mil jāe, lekin khoj lagāne ke bāwujūd āp ko patā na chalā ki wuh kahāṅ hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Tīn māh ke bād Yahūdāh ko ittalā dī gaī, “Āp kī bahū Tamr ne zinā kiyā hai, aur ab wuh hāmilā hai.” Yahūdāh ne hukm diyā, “Use bāhar lā kar jalā do.” ");
INSERT INTO urdgvr_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Tamr ko jalāne ke lie bāhar lāyā gayā to us ne apne susar ko ḳhabar bhej dī, “Yih chīzeṅ dekheṅ. Yih us ādmī kī haiṅ jis kī mārifat maiṅ ummīd se hūṅ. Patā kareṅ ki yih muhr, us kī ḍorī aur yih lāṭhī kis kī haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yahūdāh ne unheṅ pahchān liyā. Us ne kahā, “Maiṅ nahīṅ balki yih aurat haq par hai, kyoṅki maiṅ ne us kī apne beṭe Selā se shādī nahīṅ karāī.” Lekin bād meṅ Yahūdāh kabhī bhī Tamr se hambistar na huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Jab janm dene kā waqt āyā to mālūm huā ki juṛwāṅ bachche haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ek bachche kā hāth niklā to dāī ne use pakaṛ kar us meṅ surḳh dhāgā bāndh diyā aur kahā, “Yih pahle paidā huā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Lekin us ne apnā hāth wāpas khīṅch liyā, aur us kā bhāī pahle paidā huā. Yih dekh kar dāī bol uṭhī, “Tū kis tarah phūṭ niklā hai!” Us ne us kā nām Fāras yānī Phūṭ rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Phir us kā bhāī paidā huā jis ke hāth meṅ surḳh dhāgā bandhā huā thā. Us kā nām Zārah yānī Chamak rakhā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ismāīliyoṅ ne Yūsuf ko Misr le jā kar bech diyā thā. Misr ke bādshāh ke ek ālā afsar banām Fūtīfār ne use ḳharīd liyā. Wuh shāhī muhāfizoṅ kā kaptān thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Rab Yūsuf ke sāth thā. Jo bhī kām wuh kartā us meṅ kāmyāb rahtā. Wuh apne Misrī mālik ke ghar meṅ rahtā thā ");
INSERT INTO urdgvr_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","jis ne dekhā ki Rab Yūsuf ke sāth hai aur use har kām meṅ kāmyābī detā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Chunāṅche Yūsuf ko mālik kī ḳhās mehrbānī hāsil huī, aur Fūtīfār ne use apnā zātī naukar banā liyā. Us ne use apne gharāne ke intazām par muqarrar kiyā aur apnī pūrī milkiyat us ke sapurd kar dī. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Jis waqt se Fūtīfār ne apne gharāne kā intazām aur pūrī milkiyat Yūsuf ke sapurd kī us waqt se Rab ne Fūtīfār ko Yūsuf ke sabab se barkat dī. Us kī barkat Fūtīfār kī har chīz par thī, ḳhāh ghar meṅ thī yā khet meṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Fūtīfār ne apnī har chīz Yūsuf ke hāth meṅ chhoṛ dī. Aur chūṅki Yūsuf sab kuchh achchhī tarah chalātā thā is lie Fūtīfār ko khānā khāne ke siwā kisī bhī muāmale kī fikr nahīṅ thī. Yūsuf nihāyat ḳhūbsūrat ādmī thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Kuchh der ke bād us ke mālik kī bīwī kī āṅkh us par lagī. Us ne us se kahā, “Mere sāth hambistar ho!” ");
INSERT INTO urdgvr_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yūsuf inkār karke kahne lagā, “Mere mālik ko mere sabab se kisī muāmale kī fikr nahīṅ hai. Unhoṅ ne sab kuchh mere sapurd kar diyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ghar ke intazām par un kā iḳhtiyār mere iḳhtiyār se zyādā nahīṅ hai. Āp ke siwā unhoṅ ne koī bhī chīz mujh se bāz nahīṅ rakhī. To phir maiṅ kis tarah itnā ġhalat kām karūṅ? Maiṅ kis tarah Allāh kā gunāh karūṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Mālik kī bīwī roz baroz Yūsuf ke pīchhe paṛī rahī ki mere sāth hambistar ho. Lekin wuh hameshā inkār kartā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ek din wuh kām karne ke lie ghar meṅ gayā. Ghar meṅ aur koī naukar nahīṅ thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Fūtīfār kī bīwī ne Yūsuf kā libās pakaṛ kar kahā, “Mere sāth hambistar ho!” Yūsuf bhāg kar bāhar chalā gayā lekin us kā libās pīchhe aurat ke hāth meṅ hī rah gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Jab mālik kī bīwī ne dekhā ki wuh apnā libās chhoṛ kar bhāg gayā hai ");
INSERT INTO urdgvr_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","to us ne ghar ke naukaroṅ ko bulā kar kahā, “Yih dekho! Mere mālik is Ibrānī ko hamāre pās le āe haiṅ tāki wuh hameṅ zalīl kare. Wuh merī ismatdarī karne ke lie mere kamre meṅ ā gayā, lekin maiṅ ūṅchī āwāz se chīḳhne lagī. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Jab maiṅ madad ke lie ūṅchī āwāz se chīḳhne lagī to wuh apnā libās chhoṛ kar bhāg gayā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Us ne mālik ke āne tak Yūsuf kā libās apne pās rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Jab wuh ghar wāpas āyā to us ne use yihī kahānī sunāī, “Yih Ibrānī ġhulām jo āp le āe haiṅ merī tazlīl ke lie mere pās āyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Lekin jab maiṅ madad ke lie chīḳhne lagī to wuh apnā libās chhoṛ kar bhāg gayā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Yih sun kar Fūtīfār baṛe ġhusse meṅ ā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Us ne Yūsuf ko giriftār karke us jel meṅ ḍāl diyā jahāṅ bādshāh ke qaidī rakhe jāte the. Wahīṅ wuh rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Lekin Rab Yūsuf ke sāth thā. Us ne us par mehrbānī kī aur use qaidḳhāne ke dāroġhe kī nazar meṅ maqbūl kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Yūsuf yahāṅ tak maqbūl huā ki dāroġhe ne tamām qaidiyoṅ ko us ke sapurd karke use pūrā intazām chalāne kī zimmedārī dī. ");
INSERT INTO urdgvr_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Dāroġhe ko kisī bhī muāmale kī jise us ne Yūsuf ke sapurd kiyā thā fikr na rahī, kyoṅki Rab Yūsuf ke sāth thā aur use har kām meṅ kāmyābī baḳhshī. ");
INSERT INTO urdgvr_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Kuchh der ke bād yoṅ huā ki Misr ke bādshāh ke sardār sāqī aur bekarī ke inchārj ne apne mālik kā gunāh kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Firaun ko donoṅ afsaroṅ par ġhussā ā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Us ne unheṅ us qaidḳhāne meṅ ḍāl diyā jo shāhī muhāfizoṅ ke kaptān ke sapurd thā aur jis meṅ Yūsuf thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Muhāfizoṅ ke kaptān ne unheṅ Yūsuf ke hawāle kiyā tāki wuh un kī ḳhidmat kare. Wahāṅ wuh kāfī der tak rahe. ");
INSERT INTO urdgvr_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ek rāt bādshāh ke sardār sāqī aur bekarī ke inchārj ne ḳhāb dekhā. Donoṅ kā ḳhāb farq farq thā, aur un kā matlab bhī farq farq thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Jab Yūsuf subah ke waqt un ke pās āyā to wuh dabe hue nazar āe. ");
INSERT INTO urdgvr_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Us ne un se pūchhā, “Āj āp kyoṅ itne pareshān haiṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Unhoṅ ne jawāb diyā, “Ham donoṅ ne ḳhāb dekhā hai, aur koī nahīṅ jo hameṅ un kā matlab batāe.” Yūsuf ne kahā, “Ḳhāboṅ kī tābīr to Allāh kā kām hai. Zarā mujhe apne ḳhāb to sunāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Sardār sāqī ne shurū kiyā, “Maiṅ ne ḳhāb meṅ apne sāmne angūr kī bel dekhī. ");
INSERT INTO urdgvr_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Us kī tīn shāḳheṅ thīṅ. Us ke patte lage, koṅpleṅ phūṭ niklīṅ aur angūr pak gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Mere hāth meṅ bādshāh kā pyālā thā, aur maiṅ ne angūroṅ ko toṛ kar yoṅ bhīṅch diyā ki un kā ras bādshāh ke pyāle meṅ ā gayā. Phir maiṅ ne pyālā bādshāh ko pesh kiyā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yūsuf ne kahā, “Tīn shāḳhoṅ se murād tīn din haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Tīn din ke bād Firaun āp ko bahāl kar legā. Āp ko pahlī zimmedārī wāpas mil jāegī. Āp pahle kī tarah sardār sāqī kī haisiyat se bādshāh kā pyālā saṅbhāleṅge. ");
INSERT INTO urdgvr_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Lekin jab āp bahāl ho jāeṅ to merā ḳhayāl kareṅ. Mehrbānī karke bādshāh ke sāmne merā zikr kareṅ tāki maiṅ yahāṅ se rihā ho jāūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kyoṅki mujhe Ibrāniyoṅ ke mulk se aġhwā karke yahāṅ lāyā gayā hai, aur yahāṅ bhī mujh se koī aisī ġhaltī nahīṅ huī ki mujhe is gaṛhe meṅ phaiṅkā jātā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Jab shāhī bekarī ke inchārj ne dekhā ki sardār sāqī ke ḳhāb kā achchhā matlab niklā to us ne Yūsuf se kahā, “Merā ḳhāb bhī suneṅ. Maiṅ ne sar par tīn ṭokriyāṅ uṭhā rakhī thīṅ jo bekarī kī chīzoṅ se bharī huī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Sab se ūpar wālī ṭokrī meṅ wuh tamām chīzeṅ thīṅ jo bādshāh kī mez ke lie banāī jātī haiṅ. Lekin parinde ā kar unheṅ khā rahe the.” ");
INSERT INTO urdgvr_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yūsuf ne kahā, “Tīn ṭokriyoṅ se murād tīn din haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Tīn din ke bād hī Firaun āp ko qaidḳhāne se nikāl kar daraḳht se laṭkā degā. Parinde āp kī lāsh ko khā jāeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tīn din ke bād bādshāh kī sālgirah thī. Us ne apne tamām afsaroṅ kī ziyāfat kī. Is mauqe par us ne sardār sāqī aur bekarī ke inchārj ko jel se nikāl kar apne huzūr lāne kā hukm diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Sardār sāqī ko pahle wālī zimmedārī sauṅp dī gaī, ");
INSERT INTO urdgvr_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","lekin bekarī ke inchārj ko sazā-e-maut de kar daraḳht se laṭkā diyā gayā. Sab kuchh waisā hī huā jaisā Yūsuf ne kahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Lekin sardār sāqī ne Yūsuf kā ḳhayāl na kiyā balki use bhūl hī gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Do sāl guzar gae ki ek rāt bādshāh ne ḳhāb dekhā. Wuh Dariyā-e-Nīl ke kināre khaṛā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Achānak dariyā meṅ se sāt ḳhūbsūrat aur moṭī gāeṅ nikal kar sarkanḍoṅ meṅ charne lagīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Un ke bād sāt aur gāeṅ nikal āīṅ. Lekin wuh badsūrat aur dublī-patlī thīṅ. Wuh dariyā ke kināre dūsrī gāyoṅ ke pās khaṛī ho kar ");
INSERT INTO urdgvr_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","pahlī sāt ḳhūbsūrat aur moṭī moṭī gāyoṅ ko khā gaīṅ. Is ke bād Misr kā bādshāh jāg uṭhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Phir wuh dubārā so gayā. Is dafā us ne ek aur ḳhāb dekhā. Anāj ke ek paude par sāt moṭī moṭī aur achchhī achchhī bāleṅ lagī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Phir sāt aur bāleṅ phūṭ niklīṅ jo dublī-patlī aur mashriqī hawā se jhulsī huī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Anāj kī sāt dublī-patlī bāloṅ ne sāt moṭī aur ḳhūbsūrat bāloṅ ko nigal liyā. Phir Firaun jāg uṭhā to mālūm huā ki maiṅ ne ḳhāb hī dekhā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Subah huī to wuh pareshān thā, is lie us ne Misr ke tamām jādūgaroṅ aur ālimoṅ ko bulāyā. Us ne unheṅ apne ḳhāb sunāe, lekin koī bhī un kī tābīr na kar sakā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Phir sardār sāqī ne Firaun se kahā, “Āj mujhe apnī ḳhatāeṅ yād ātī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ek din Firaun apne ḳhādimoṅ se nārāz hue. Huzūr ne mujhe aur bekarī ke inchārj ko qaidḳhāne meṅ ḍalwā diyā jis par shāhī muhāfizoṅ kā kaptān muqarrar thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ek hī rāt meṅ ham donoṅ ne muḳhtalif ḳhāb dekhe jin kā matlab farq farq thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Wahāṅ jel meṅ ek Ibrānī naujawān thā. Wuh muhāfizoṅ ke kaptān kā ġhulām thā. Ham ne use apne ḳhāb sunāe to us ne hameṅ un kā matlab batā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Aur jo kuchh bhī us ne batāyā sab kuchh waisā hī huā. Mujhe apnī zimmedārī wāpas mil gaī jabki bekarī ke inchārj ko sazā-e-maut de kar daraḳht se laṭkā diyā gayā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Yih sun kar Firaun ne Yūsuf ko bulāyā, aur use jaldī se qaidḳhāne se lāyā gayā. Us ne shew karwā kar apne kapṛe badle aur sīdhe bādshāh ke huzūr pahuṅchā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Bādshāh ne kahā, “Maiṅ ne ḳhāb dekhā hai, aur yahāṅ koī nahīṅ jo us kī tābīr kar sake. Lekin sunā hai ki tū ḳhāb ko sun kar us kā matlab batā saktā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yūsuf ne jawāb diyā, “Yih mere iḳhtiyār meṅ nahīṅ hai. Lekin Allāh hī bādshāh ko salāmatī kā paiġhām degā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Firaun ne Yūsuf ko apne ḳhāb sunāe, “Maiṅ ḳhāb meṅ Dariyā-e-Nīl ke kināre khaṛā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Achānak dariyā meṅ se sāt moṭī moṭī aur ḳhūbsūrat gāeṅ nikal kar sarkanḍoṅ meṅ charne lagīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Is ke bād sāt aur gāeṅ niklīṅ. Wuh nihāyat badsūrat aur dublī-patlī thīṅ. Maiṅ ne itnī badsūrat gāeṅ Misr meṅ kahīṅ bhī nahīṅ dekhīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Dublī aur badsūrat gāeṅ pahlī moṭī gāyoṅ ko khā gaīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Aur nigalne ke bād bhī mālūm nahīṅ hotā thā ki unhoṅ ne moṭī gāyoṅ ko khāyā hai. Wuh pahle kī tarah badsūrat hī thīṅ. Is ke bād maiṅ jāg uṭhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Phir maiṅ ne ek aur ḳhāb dekhā. Sāt moṭī aur achchhī bāleṅ ek hī paude par lagī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Is ke bād sāt aur bāleṅ niklīṅ jo ḳharāb, dublī-patlī aur mashriqī hawā se jhulsī huī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Sāt dublī-patlī bāleṅ sāt achchhī bāloṅ ko nigal gaīṅ. Maiṅ ne yih sab kuchh apne jādūgaroṅ ko batāyā, lekin wuh is kī tābīr na kar sake.” ");
INSERT INTO urdgvr_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yūsuf ne bādshāh se kahā, “Donoṅ ḳhāboṅ kā ek hī matlab hai. In se Allāh ne huzūr par zāhir kiyā hai ki wuh kyā kuchh karne ko hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Sāt achchhī gāyoṅ se murād sāt sāl haiṅ. Isī tarah sāt achchhī bāloṅ se murād bhī sāt sāl haiṅ. Donoṅ ḳhāb ek hī bāt bayān karte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Jo sāt dublī aur badsūrat gāeṅ bād meṅ nikleṅ un se murād sāt aur sāl haiṅ. Yihī sāt dublī-patlī aur mashriqī hawā se jhulsī huī bāloṅ kā matlab bhī hai. Wuh ek hī bāt bayān kartī haiṅ ki sāt sāl tak kāl paṛegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Yih wuhī bāt hai jo maiṅ ne huzūr se kahī ki Allāh ne huzūr par zāhir kiyā hai ki wuh kyā karegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Sāt sāl āeṅge jin ke daurān Misr ke pūre mulk meṅ kasrat se paidāwār hogī. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Us ke bād sāt sāl kāl paṛegā. Kāl itnā shadīd hogā ki log bhūl jāeṅge ki pahle itnī kasrat thī. Kyoṅki kāl mulk ko tabāh kar degā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Kāl kī shiddat ke bāis achchhe sāloṅ kī kasrat yād hī nahīṅ rahegī. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Huzūr ko is lie ek hī paiġhām do muḳhtalif ḳhāboṅ kī sūrat meṅ milā ki Allāh is kā pakkā irādā rakhtā hai, aur wuh jald hī is par amal karegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ab bādshāh kisī samajhdār aur dānishmand ādmī ko Mulk-e-Misr kā intazām sauṅpeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Is ke alāwā wuh aise ādmī muqarrar kareṅ jo sāt achchhe sāloṅ ke daurān har fasal kā pāṅchwāṅ hissā leṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Wuh un achchhe sāloṅ ke daurān ḳhurāk jamā kareṅ. Bādshāh unheṅ iḳhtiyār deṅ ki wuh shahroṅ meṅ godām banā kar anāj ko mahfūz kar leṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Yih ḳhurāk kāl ke un sāt sāloṅ ke lie maḳhsūs kī jāe jo Misr meṅ āne wāle haiṅ. Yoṅ mulk tabāh nahīṅ hogā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Yih mansūbā bādshāh aur us ke afsarān ko achchhā lagā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Us ne un se kahā, “Hameṅ is kām ke lie Yūsuf se zyādā lāyq ādmī nahīṅ milegā. Us meṅ Allāh kī rūh hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Bādshāh ne Yūsuf se kahā, “Allāh ne yih sab kuchh tujh par zāhir kiyā hai, is lie koī bhī tujh se zyādā samajhdār aur dānishmand nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Maiṅ tujhe apne mahal par muqarrar kartā hūṅ. Merī tamām riāyā tere tābe rahegī. Terā iḳhtiyār sirf mere iḳhtiyār se kam hogā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ab maiṅ tujhe pūre Mulk-e-Misr par hākim muqarrar kartā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Bādshāh ne apnī unglī se wuh angūṭhī utārī jis se muhr lagātā thā aur use Yūsuf kī unglī meṅ pahnā diyā. Us ne use katān kā bārīk libās pahnāyā aur us ke gale meṅ sone kā gulūband pahnā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Phir us ne use apne dūsre rath meṅ sawār kiyā aur log us ke āge āge pukārte rahe, “Ghuṭne ṭeko! Ghuṭne ṭeko!” Yoṅ Yūsuf pūre Misr kā hākim banā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Firaun ne us se kahā, “Maiṅ to bādshāh hūṅ, lekin terī ijāzat ke baġhair pūre mulk meṅ koī bhī apnā hāth yā pāṅw nahīṅ hilāegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Us ne Yūsuf kā Misrī nām Sāfanat-fāneh rakhā aur On ke pujārī Fotīfirā kī beṭī Āsanat ke sāth us kī shādī karāī. Yūsuf 30 sāl kā thā jab wuh Misr ke bādshāh Firaun kī ḳhidmat karne lagā. Us ne Firaun ke huzūr se nikal kar Misr kā daurā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Sāt achchhe sāloṅ ke daurān mulk meṅ nihāyat achchhī fasleṅ ugīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yūsuf ne tamām ḳhurāk jamā karke shahroṅ meṅ mahfūz kar lī. Har shahr meṅ us ne irdgird ke khetoṅ kī paidāwār mahfūz rakhī. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Jamāshudā anāj samundar kī ret kī mānind bakasrat thā. Itnā anāj thā ki Yūsuf ne āḳhirkār us kī paimāish karnā chhoṛ diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kāl se pahle Yūsuf aur Āsanat ke do beṭe paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Us ne pahle kā nām Manassī yānī ‘Jo Bhulā Detā Hai’ rakhā. Kyoṅki us ne kahā, “Allāh ne merī musībat aur mere bāp kā gharānā merī yāddāsht se nikāl diyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Dūsre kā nām us ne Ifrāīm yānī ‘Dugnā Phaldār’ rakhā. Kyoṅki us ne kahā, “Allāh ne mujhe merī musībat ke mulk meṅ phalne-phūlne diyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Sāt achchhe sāl jin meṅ kasrat kī fasleṅ ugīṅ guzar gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Phir kāl ke sāt sāl shurū hue jis tarah Yūsuf ne kahā thā. Tamām dīgar mamālik meṅ bhī kāl paṛ gayā, lekin Misr meṅ wāfir ḳhurāk pāī jātī thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Jab kāl ne tamām Misr meṅ zor pakaṛā to log chīḳh kar khāne ke lie bādshāh se minnat karne lage. Tab Firaun ne un se kahā, “Yūsuf ke pās jāo. Jo kuchh wuh tumheṅ batāegā wuhī karo.” ");
INSERT INTO urdgvr_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Jab kāl pūrī duniyā meṅ phail gayā to Yūsuf ne anāj ke godām khol kar Misriyoṅ ko anāj bech diyā. Kyoṅki kāl ke bāis mulk ke hālāt bahut ḳharāb ho gae the. ");
INSERT INTO urdgvr_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Tamām mamālik se bhī log anāj ḳharīdne ke lie Yūsuf ke pās āe, kyoṅki pūrī duniyā saḳht kāl kī girift meṅ thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jab Yāqūb ko mālūm huā ki Misr meṅ anāj hai to us ne apne beṭoṅ se kahā, “Tum kyoṅ ek dūsre kā muṅh takte ho? ");
INSERT INTO urdgvr_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Sunā hai ki Misr meṅ anāj hai. Wahāṅ jā kar hamāre lie kuchh ḳharīd lāo tāki ham bhūke na mareṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tab Yūsuf ke das bhāī anāj ḳharīdne ke lie Misr gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Lekin Yāqūb ne Yūsuf ke sage bhāī Binyamīn ko sāth na bhejā, kyoṅki us ne kahā, “Aisā na ho ki use jānī nuqsān pahuṅche.” ");
INSERT INTO urdgvr_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Yoṅ Yāqūb ke beṭe bahut sāre aur logoṅ ke sāth Misr gae. Kyoṅki Mulk-e-Kanān bhī kāl kī girift meṅ thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yūsuf Misr ke hākim kī haisiyat se logoṅ ko anāj bechtā thā, is lie us ke bhāī ā kar us ke sāmne muṅh ke bal jhuk gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Jab Yūsuf ne apne bhāiyoṅ ko dekhā to us ne unheṅ pahchān liyā lekin aisā kiyā jaisā un se nāwāqif ho aur saḳhtī se un se bāt kī, “Tum kahāṅ se āe ho?” Unhoṅ ne jawāb diyā, “Ham Mulk-e-Kanān se anāj ḳharīdne ke lie āe haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Go Yūsuf ne apne bhāiyoṅ ko pahchān liyā, lekin unhoṅ ne use na pahchānā. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Use wuh ḳhāb yād āe jo us ne un ke bāre meṅ dekhe the. Us ne kahā, “Tum jāsūs ho. Tum yih deḳhne āe ho ki hamārā mulk kin kin jaghoṅ par ġhairmahfūz hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Unhoṅ ne kahā, “Janāb, hargiz nahīṅ. Āp ke ġhulām ġhallā ḳharīdne āe haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ham sab ek hī mard ke beṭe haiṅ. Āp ke ḳhādim sharīf log haiṅ, jāsūs nahīṅ haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Lekin Yūsuf ne isrār kiyā, “Nahīṅ, tum deḳhne āe ho ki hamārā mulk kin kin jaghoṅ par ġhairmahfūz hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Unhoṅ ne arz kī, “Āp ke ḳhādim kul bārah bhāī haiṅ. Ham ek hī ādmī ke beṭe haiṅ jo Kanān meṅ rahtā hai. Sab se chhoṭā bhāī is waqt hamāre bāp ke pās hai jabki ek mar gayā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Lekin Yūsuf ne apnā ilzām dohrāyā, “Aisā hī hai jaisā maiṅ ne kahā hai ki tum jāsūs ho. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Maiṅ tumhārī bāteṅ jāṅch lūṅgā. Firaun kī hayāt kī qasam, pahle tumhārā sab se chhoṭā bhāī āe, warnā tum is jagah se kabhī nahīṅ jā sakoge. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ek bhāī ko use lāne ke lie bhej do. Bāqī sab yahāṅ giriftār raheṅge. Phir patā chalegā ki tumhārī bāteṅ sach haiṅ ki nahīṅ. Agar nahīṅ to Firaun kī hayāt kī qasam, is kā matlab yih hogā ki tum jāsūs ho.” ");
INSERT INTO urdgvr_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yih kah kar Yūsuf ne unheṅ tīn din ke lie qaidḳhāne meṅ ḍāl diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Tīsre din us ne un se kahā, “Maiṅ Allāh kā ḳhauf māntā hūṅ, is lie tum ko ek shart par jītā chhoṛūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Agar tum wāqaī sharīf log ho to aisā karo ki tum meṅ se ek yahāṅ qaidḳhāne meṅ rahe jabki bāqī sab anāj le kar apne bhūke ghar wāloṅ ke pās wāpas jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Lekin lāzim hai ki tum apne sab se chhoṭe bhāī ko mere pās le āo. Sirf is se tumhārī bāteṅ sach sābit hoṅgī aur tum maut se bach jāoge.” Yūsuf ke bhāī rāzī ho gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Wuh āpas meṅ kahne lage, “Beshak yih hamāre apne bhāī par zulm kī sazā hai. Jab wuh iltijā kar rahā thā ki mujh par rahm kareṅ to ham ne us kī baṛī musībat dekh kar bhī us kī na sunī. Is lie yih musībat ham par ā gaī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Aur Rūbin ne kahā, “Kyā maiṅ ne nahīṅ kahā thā ki laṛke par zulm mat karo, lekin tum ne merī ek na mānī. Ab us kī maut kā hisāb-kitāb kiyā jā rahā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Unheṅ mālūm nahīṅ thā ki Yūsuf hamārī bāteṅ samajh saktā hai, kyoṅki wuh mutarjim kī mārifat un se bāt kartā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yih bāteṅ sun kar wuh unheṅ chhoṛ kar rone lagā. Phir wuh saṅbhal kar wāpas āyā. Us ne Shamāūn ko chun kar use un ke sāmne hī bāndh liyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yūsuf ne hukm diyā ki mulāzim un kī boriyāṅ anāj se bhar kar har ek bhāī ke paise us kī borī meṅ wāpas rakh deṅ aur unheṅ safr ke lie khānā bhī deṅ. Unhoṅ ne aisā hī kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Phir Yūsuf ke bhāī apne gadhoṅ par anāj lād kar rawānā ho gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Jab wuh rāt ke lie kisī jagah par ṭhahre to ek bhāī ne apne gadhe ke lie chārā nikālne kī ġharz se apnī borī kholī to dekhā ki borī ke muṅh meṅ us ke paise paṛe haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Us ne apne bhāiyoṅ se kahā, “Mere paise wāpas kar die gae haiṅ! Wuh merī borī meṅ haiṅ.” Yih dekh kar un ke hosh uṛ gae. Kāṅpte hue wuh ek dūsre ko deḳhne aur kahne lage, “Yih kyā hai jo Allāh ne hamāre sāth kiyā hai?” ");
INSERT INTO urdgvr_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Mulk-e-Kanān meṅ apne bāp ke pās pahuṅch kar unhoṅ ne use sab kuchh sunāyā jo un ke sāth huā thā. Unhoṅ ne kahā, ");
INSERT INTO urdgvr_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Us mulk ke mālik ne baṛī saḳhtī se hamāre sāth bāt kī. Us ne hameṅ jāsūs qarār diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Lekin ham ne us se kahā, ‘Ham jāsūs nahīṅ balki sharīf log haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ham bārah bhāī haiṅ, ek hī bāp ke beṭe. Ek to mar gayā jabki sab se chhoṭā bhāī is waqt Kanān meṅ bāp ke pās hai.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Phir us mulk ke mālik ne ham se kahā, ‘Is se mujhe patā chalegā ki tum sharīf log ho ki ek bhāī ko mere pās chhoṛ do aur apne bhūke ghar wāloṅ ke lie ḳhurāk le kar chale jāo. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Lekin apne sab se chhoṭe bhāī ko mere pās le āo tāki mujhe mālūm ho jāe ki tum jāsūs nahīṅ balki sharīf log ho. Phir maiṅ tum ko tumhārā bhāī wāpas kar dūṅgā aur tum is mulk meṅ āzādī se tijārat kar sakoge.’” ");
INSERT INTO urdgvr_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Unhoṅ ne apnī boriyoṅ se anāj nikāl diyā to dekhā ki har ek kī borī meṅ us ke paisoṅ kī thailī rakhī huī hai. Yih paise dekh kar wuh ḳhud aur un kā bāp ḍar gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Un ke bāp ne un se kahā, “Tum ne mujhe mere bachchoṅ se mahrūm kar diyā hai. Yūsuf nahīṅ rahā, Shamāūn bhī nahīṅ rahā aur ab tum Binyamīn ko bhī mujh se chhīnanā chāhte ho. Sab kuchh mere ḳhilāf hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Phir Rūbin bol uṭhā, “Agar maiṅ use salāmatī se āp ke pās wāpas na pahuṅchāūṅ to āp mere do beṭoṅ ko sazā-e-maut de sakte haiṅ. Use mere sapurd kareṅ to maiṅ use wāpas le āūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Lekin Yāqūb ne kahā, “Merā beṭā tumhāre sāth jāne kā nahīṅ. Kyoṅki us kā bhāī mar gayā hai aur wuh akelā hī rah gayā hai. Agar us ko rāste meṅ jānī nuqsān pahuṅche to tum mujh būṛhe ko ġham ke māre Pātāl meṅ pahuṅchāoge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kāl ne zor pakaṛā. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Jab Misr se lāyā gayā anāj ḳhatm ho gayā to Yāqūb ne kahā, “Ab wāpas jā kar hamāre lie kuchh aur ġhallā ḳharīd lāo.” ");
INSERT INTO urdgvr_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Lekin Yahūdāh ne kahā, “Us mard ne saḳhtī se kahā thā, ‘Tum sirf is sūrat meṅ mere pās ā sakte ho ki tumhārā bhāī sāth ho.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Agar āp hamāre bhāī ko sāth bhejeṅ to phir ham jā kar āp ke lie ġhallā ḳharīdeṅge ");
INSERT INTO urdgvr_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","warnā nahīṅ. Kyoṅki us ādmī ne kahā thā ki ham sirf is sūrat meṅ us ke pās ā sakte haiṅ ki hamārā bhāī sāth ho.” ");
INSERT INTO urdgvr_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yāqūb ne kahā, “Tum ne use kyoṅ batāyā ki hamārā ek aur bhāī bhī hai? Is se tum ne mujhe baṛī musībat meṅ ḍāl diyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Unhoṅ ne jawāb diyā, “Wuh ādmī hamāre aur hamāre ḳhāndān ke bāre meṅ pūchhtā rahā, ‘Kyā tumhārā bāp ab tak zindā hai? Kyā tumhārā koī aur bhāī hai?’ Phir hameṅ jawāb denā paṛā. Hameṅ kyā patā thā ki wuh hameṅ apne bhāī ko sāth lāne ko kahegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Phir Yahūdāh ne bāp se kahā, “Laṛke ko mere sāth bhej deṅ to ham abhī rawānā ho jāeṅge. Warnā āp, hamāre bachche balki ham sab bhūkoṅ mar jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Maiṅ ḳhud us kā zāmin hūṅgā. Āp mujhe us kī jān kā zimmedār ṭhahrā sakte haiṅ. Agar maiṅ use salāmatī se wāpas na pahuṅchāūṅ to phir maiṅ zindagī ke āḳhir tak qusūrwār ṭhahrūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Jitnī der tak ham jhijakte rahe haiṅ utnī der meṅ to ham do dafā Misr jā kar wāpas ā sakte the.” ");
INSERT INTO urdgvr_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tab un ke bāp Isrāīl ne kahā, “Agar aur koī sūrat nahīṅ to is mulk kī behtarīn paidāwār meṅ se kuchh tohfe ke taur par le kar us ādmī ko de do yānī kuchh balsān, shahd, lādan, mur, pistā aur bādām. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Apne sāth dugnī raqam le kar jāo, kyoṅki tumheṅ wuh paise wāpas karne haiṅ jo tumhārī boriyoṅ meṅ rakhe gae the. Shāyad kisī se ġhaltī huī ho. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Apne bhāī ko le kar sīdhe wāpas pahuṅchnā. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Allāh Qādir-e-mutlaq kare ki yih ādmī tum par rahm karke Binyamīn aur tumhāre dūsre bhāī ko wāpas bheje. Jahāṅ tak merā tālluq hai, agar mujhe apne bachchoṅ se mahrūm honā hai to aisā hī ho.” ");
INSERT INTO urdgvr_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Chunāṅche wuh tohfe, dugnī raqam aur Binyamīn ko sāth le kar chal paṛe. Misr pahuṅch kar wuh Yūsuf ke sāmne hāzir hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Jab Yūsuf ne Binyamīn ko un ke sāth dekhā to us ne apne ghar par muqarrar mulāzim se kahā, “In ādmiyoṅ ko mere ghar le jāo tāki wuh dopahar kā khānā mere sāth khāeṅ. Jānwar ko zabah karke khānā taiyār karo.” ");
INSERT INTO urdgvr_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mulāzim ne aisā hī kiyā aur bhāiyoṅ ko Yūsuf ke ghar le gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Jab unheṅ us ke ghar pahuṅchāyā jā rahā thā to wuh ḍar kar sochne lage, “Hameṅ un paisoṅ ke sabab se yahāṅ lāyā jā rahā hai jo pahlī dafā hamārī boriyoṅ meṅ wāpas kie gae the. Wuh ham par achānak hamlā karke hamāre gadhe chhīn leṅge aur hameṅ ġhulām banā leṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Is lie ghar ke darwāze par pahuṅch kar unhoṅ ne ghar par muqarrar mulāzim se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Janāb-e-ālī, hamārī bāt sun lījie. Is se pahle ham anāj ḳharīdne ke lie yahāṅ āe the. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Lekin jab ham yahāṅ se rawānā ho kar rāste meṅ rāt ke lie ṭhahre to ham ne apnī boriyāṅ khol kar dekhā ki har borī ke muṅh meṅ hamāre paisoṅ kī pūrī raqam paṛī hai. Ham yih paise wāpas le āe haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Nīz, ham mazīd ḳhurāk ḳharīdne ke lie aur paise le āe haiṅ. Ḳhudā jāne kis ne hamāre yih paise hamārī boriyoṅ meṅ rakh die.” ");
INSERT INTO urdgvr_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mulāzim ne kahā, “Fikr na kareṅ. Mat ḍareṅ. Āp ke aur āp ke bāp ke Ḳhudā ne āp ke lie āp kī boriyoṅ meṅ yih ḳhazānā rakhā hogā. Baharhāl mujhe āp ke paise mil gae haiṅ.” Mulāzim Shamāūn ko un ke pās bāhar le āyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Phir us ne bhāiyoṅ ko Yūsuf ke ghar meṅ le jā kar unheṅ pāṅw dhone ke lie pānī aur gadhoṅ ko chārā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Unhoṅ ne apne tohfe taiyār rakhe, kyoṅki unheṅ batāyā gayā, “Yūsuf dopahar kā khānā āp ke sāth hī khāegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Jab Yūsuf ghar pahuṅchā to wuh apne tohfe le kar us ke sāmne āe aur muṅh ke bal jhuk gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Us ne un se ḳhairiyat dariyāft kī aur phir kahā, “Tum ne apne būṛhe bāp kā zikr kiyā. Kyā wuh ṭhīk haiṅ? Kyā wuh ab tak zindā haiṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Unhoṅ ne jawāb diyā, “Jī, āp ke ḳhādim hamāre bāp ab tak zindā haiṅ.” Wuh dubārā muṅh ke bal jhuk gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Jab Yūsuf ne apne sage bhāī Binyamīn ko dekhā to us ne kahā, “Kyā yih tumhārā sab se chhoṭā bhāī hai jis kā tum ne zikr kiyā thā? Beṭā, Allāh kī nazar-e-karm tum par ho.” ");
INSERT INTO urdgvr_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yūsuf apne bhāī ko dekh kar itnā muta'assir huā ki wuh rone ko thā, is lie wuh jaldī se wahāṅ se nikal kar apne sone ke kamre meṅ gayā aur ro paṛā. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Phir wuh apnā muṅh dho kar wāpas āyā. Apne āp par qābū pā kar us ne hukm diyā ki naukar khānā le āeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Naukaroṅ ne Yūsuf ke lie khāne kā alag intazām kiyā aur bhāiyoṅ ke lie alag. Misriyoṅ ke lie bhī khāne kā alag intazām thā, kyoṅki Ibrāniyoṅ ke sāth khānā khānā un kī nazar meṅ qābil-e-nafrat thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Bhāiyoṅ ko un kī umr kī tartīb ke mutābiq Yūsuf ke sāmne biṭhāyā gayā. Yih dekh kar bhāī nihāyat hairān hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Naukaroṅ ne unheṅ Yūsuf kī mez par se khānā le kar khilāyā. Lekin Binyamīn ko dūsroṅ kī nisbat pāṅch gunā zyādā milā. Yoṅ unhoṅ ne Yūsuf ke sāth jī bhar kar khāyā aur piyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yūsuf ne ghar par muqarrar mulāzim ko hukm diyā, “Un mardoṅ kī boriyāṅ ḳhurāk se itnī bhar denā jitnī wuh uṭhā kar le jā sakeṅ. Har ek ke paise us kī apnī borī ke muṅh meṅ rakh denā. ");
INSERT INTO urdgvr_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Sab se chhoṭe bhāī kī borī meṅ na sirf paise balki mere chāṅdī ke pyāle ko bhī rakh denā.” Mulāzim ne aisā hī kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Aglī subah jab pau phaṭne lagī to bhāiyoṅ ko un ke gadhoṅ samet ruḳhsat kar diyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Wuh abhī shahr se nikal kar dūr nahīṅ gae the ki Yūsuf ne apne ghar par muqarrar mulāzim se kahā, “Jaldī karo. Un ādmiyoṅ kā tāqqub karo. Un ke pās pahuṅch kar yih pūchhnā, ‘Āp ne hamārī bhalāī ke jawāb meṅ ġhalat kām kyoṅ kiyā hai? ");
INSERT INTO urdgvr_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Āp ne mere mālik kā chāṅdī kā pyālā kyoṅ churāyā hai? Us se wuh na sirf pīte haiṅ balki use ġhaibdānī ke lie bhī istemāl karte haiṅ. Āp ek nihāyat sangīn jurm ke murtakib hue haiṅ.’” ");
INSERT INTO urdgvr_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Jab mulāzim bhāiyoṅ ke pās pahuṅchā to us ne un se yihī bāteṅ kīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Jawāb meṅ unhoṅ ne kahā, “Hamāre mālik aisī bāteṅ kyoṅ karte haiṅ? Kabhī nahīṅ ho saktā ki āp ke ḳhādim aisā kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Āp to jānte haiṅ ki ham Mulk-e-Kanān se wuh paise wāpas le āe jo hamārī boriyoṅ meṅ the. To phir ham kyoṅ āp ke mālik ke ghar se chāṅdī yā sonā churāeṅge? ");
INSERT INTO urdgvr_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Agar wuh āp ke ḳhādimoṅ meṅ se kisī ke pās mil jāe to use mār ḍālā jāe aur bāqī sab āp ke ġhulām baneṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Mulāzim ne kahā, “Ṭhīk hai aisā hī hogā. Lekin sirf wuhī merā ġhulām banegā jis ne pyālā churāyā hai. Bāqī sab āzād haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Unhoṅ ne jaldī se apnī boriyāṅ utār kar zamīn par rakh dīṅ. Har ek ne apnī borī khol dī. ");
INSERT INTO urdgvr_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Mulāzim boriyoṅ kī talāshī lene lagā. Wuh baṛe bhāī se shurū karke āḳhirkār sab se chhoṭe bhāī tak pahuṅch gayā. Aur wahāṅ Binyamīn kī borī meṅ se pyālā niklā. ");
INSERT INTO urdgvr_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Bhāiyoṅ ne yih dekh kar pareshānī meṅ apne libās phāṛ lie. Wuh apne gadhoṅ ko dubārā lād kar shahr wāpas ā gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Jab Yahūdāh aur us ke bhāī Yūsuf ke ghar pahuṅche to wuh abhī wahīṅ thā. Wuh us ke sāmne muṅh ke bal gir gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yūsuf ne kahā, “Yih tum ne kyā kiyā hai? Kyā tum nahīṅ jānte ki mujh jaisā ādmī ġhaib kā ilm rakhtā hai?” ");
INSERT INTO urdgvr_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yahūdāh ne kahā, “Janāb-e-ālī, ham kyā kaheṅ? Ab ham apne difā meṅ kyā kaheṅ? Allāh hī ne hameṅ qusūrwār ṭhahrāyā hai. Ab ham sab āp ke ġhulām haiṅ, na sirf wuh jis ke pās se pyālā mil gayā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yūsuf ne kahā, “Allāh na kare ki maiṅ aisā karūṅ, balki sirf wuhī merā ġhulām hogā jis ke pās pyālā thā. Bāqī sab salāmatī se apne bāp ke pās wāpas chale jāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Lekin Yahūdāh ne Yūsuf ke qarīb ā kar kahā, “Mere mālik, mehrbānī karke apne bande ko ek bāt karne kī ijāzat deṅ. Mujh par ġhussā na kareṅ agarche āp Misr ke bādshāh jaise haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Janāb-e-ālī, āp ne ham se pūchhā, ‘Kyā tumhārā bāp yā koī aur bhāī hai?’ ");
INSERT INTO urdgvr_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ham ne jawāb diyā, ‘Hamārā bāp hai. Wuh būṛhā hai. Hamārā ek chhoṭā bhāī bhī hai jo us waqt paidā huā jab hamārā bāp umrrasīdā thā. Us laṛke kā bhāī mar chukā hai. Us kī māṅ ke sirf yih do beṭe paidā hue. Ab wuh akelā hī rah gayā hai. Us kā bāp use shiddat se pyār kartā hai.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Janāb-e-ālī, āp ne hameṅ batāyā, ‘Use yahāṅ le āo tāki maiṅ ḳhud use dekh sakūṅ.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ham ne jawāb diyā, ‘Yih laṛkā apne bāp ko chhoṛ nahīṅ saktā, warnā us kā bāp mar jāegā.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Phir āp ne kahā, ‘Tum sirf is sūrat meṅ mere pās ā sakoge ki tumhārā sab se chhoṭā bhāī tumhāre sāth ho.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Jab ham apne bāp ke pās wāpas pahuṅche to ham ne unheṅ sab kuchh batāyā jo āp ne kahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Phir unhoṅ ne ham se kahā, ‘Misr lauṭ kar kuchh ġhallā ḳharīd lāo.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ham ne jawāb diyā, ‘Ham jā nahīṅ sakte. Ham sirf is sūrat meṅ us mard ke pās jā sakte haiṅ ki hamārā sab se chhoṭā bhāī sāth ho. Ham tab hī jā sakte haiṅ jab wuh bhī hamāre sāth chale.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Hamāre bāp ne ham se kahā, ‘Tum jānte ho ki merī bīwī Rāḳhil se mere do beṭe paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Pahlā mujhe chhoṛ chukā hai. Kisī janglī jānwar ne use phāṛ khāyā hogā, kyoṅki usī waqt se maiṅ ne use nahīṅ dekhā. ");
INSERT INTO urdgvr_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Agar is ko bhī mujh se le jāne kī wajah se jānī nuqsān pahuṅche to tum mujh būṛhe ko ġham ke māre Pātāl meṅ pahuṅchāoge.’” ");
INSERT INTO urdgvr_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Yahūdāh ne apnī bāt jārī rakhī, “Janāb-e-ālī, ab agar maiṅ apne bāp ke pās jāūṅ aur wuh dekheṅ ki laṛkā mere sāth nahīṅ hai to wuh dam toṛ deṅge. Un kī zindagī is qadar laṛke kī zindagī par munhasir hai aur wuh itne būṛhe haiṅ ki ham aisī harkat se unheṅ qabr tak pahuṅchā deṅge. ");
INSERT INTO urdgvr_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Na sirf yih balki maiṅ ne bāp se kahā, ‘Maiṅ ḳhud is kā zāmin hūṅgā. Agar maiṅ ise salāmatī se wāpas na pahuṅchāūṅ to phir maiṅ zindagī ke āḳhir tak qusūrwār ṭhahrūṅga.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ab apne ḳhādim kī guzārish suneṅ. Maiṅ yahāṅ rah kar is laṛke kī jagah ġhulām ban jātā hūṅ, aur wuh dūsre bhāiyoṅ ke sāth wāpas chalā jāe ");
INSERT INTO urdgvr_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","agar laṛkā mere sāth na huā to maiṅ kis tarah apne bāp ko muṅh dikhā saktā hūṅ? Maiṅ bardāsht nahīṅ kar sakūṅgā ki wuh is musībat meṅ mubtalā ho jāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yih sun kar Yūsuf apne āp par qābū na rakh sakā. Us ne ūṅchī āwāz se hukm diyā ki tamām mulāzim kamre se nikal jāeṅ. Koī aur shaḳhs kamre meṅ nahīṅ thā jab Yūsuf ne apne bhāiyoṅ ko batāyā ki wuh kaun hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Wuh itne zor se ro paṛā ki Misriyoṅ ne us kī āwāz sunī aur Firaun ke gharāne ko patā chal gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yūsuf ne apne bhāiyoṅ se kahā, “Maiṅ Yūsuf hūṅ. Kyā merā bāp ab tak zindā hai?” Lekin us ke bhāī yih sun kar itne ghabrā gae ki wuh jawāb na de sake. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Phir Yūsuf ne kahā, “Mere qarīb āo.” Wuh qarīb āe to us ne kahā, “Maiṅ tumhārā bhāī Yūsuf hūṅ jise tum ne bech kar Misr bhijwāyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ab merī bāt suno. Na ghabrāo aur na apne āp ko ilzām do ki ham ne Yūsuf ko bech diyā. Asal meṅ Allāh ne ḳhud mujhe tumhāre āge yahāṅ bhej diyā tāki ham sab bache raheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Yih kāl kā dūsrā sāl hai. Pāṅch aur sāl ke daurān na hal chalegā, na fasal kaṭegī. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Allāh ne mujhe tumhāre āge bhejā tāki duniyā meṅ tumhārā ek bachā-khuchā hissā mahfūz rahe aur tumhārī jān ek baṛī maḳhlasī kī mārifat chhūṭ jāe ");
INSERT INTO urdgvr_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","chunāṅche tum ne mujhe yahāṅ nahīṅ bhejā balki Allāh ne. Us ne mujhe Firaun kā bāp, us ke pūre gharāne kā mālik aur Misr kā hākim banā diyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ab jaldī se mere bāp ke pās wāpas jā kar un se kaho, ‘Āp kā beṭā Yūsuf āp ko ittalā detā hai ki Allāh ne mujhe Misr kā mālik banā diyā hai. Mere pās ā jāeṅ, der na kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Āp Jushan ke ilāqe meṅ rah sakte haiṅ. Wahāṅ āp mere qarīb hoṅge, āp, āp kī āl-o-aulād, gāy-bail, bheṛ-bakriyāṅ aur jo kuchh bhī āp kā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Wahāṅ maiṅ āp kī zarūriyāt pūrī karūṅga, kyoṅki kāl ko abhī pāṅch sāl aur lageṅge. Warnā āp, āp ke ghar wāle aur jo bhī āp ke haiṅ bad-hāl ho jāeṅge.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Tum ḳhud aur merā bhāī Binyamīn dekh sakte ho ki maiṅ Yūsuf hī hūṅ jo tumhāre sāth bāt kar rahā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mere bāp ko Misr meṅ mere asar-o-rasūḳh ke bāre meṅ ittalā do. Unheṅ sab kuchh batāo jo tum ne dekhā hai. Phir jald hī mere bāp ko yahāṅ le āo.” ");
INSERT INTO urdgvr_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yih kah kar wuh apne bhāī Binyamīn ko gale lagā kar ro paṛā. Binyamīn bhī us ke gale lag kar rone lagā. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Phir Yūsuf ne rote hue apne har ek bhāī ko bosā diyā. Is ke bād us ke bhāī us ke sāth bāteṅ karne lage. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Jab yih ḳhabar bādshāh ke mahal tak pahuṅchī ki Yūsuf ke bhāī āe haiṅ to Firaun aur us ke tamām afsarān ḳhush hue. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Us ne Yūsuf se kahā, “Apne bhāiyoṅ ko batā ki apne jānwaroṅ par ġhallā lād kar Mulk-e-Kanān wāpas chale jāo. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Wahāṅ apne bāp aur ḳhāndānoṅ ko le kar mere pās ā jāo. Maiṅ tum ko Misr kī sab se achchhī zamīn de dūṅgā, aur tum is mulk kī behtarīn paidāwār khā sakoge. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Unheṅ yih hidāyat bhī de ki apne bāl-bachchoṅ ke lie Misr se gāṛiyāṅ le jāo aur apne bāp ko bhī biṭhā kar yahāṅ le āo. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Apne māl kī zyādā fikr na karo, kyoṅki tumheṅ Mulk-e-Misr kā behtarīn māl milegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yūsuf ke bhāiyoṅ ne aisā hī kiyā. Yūsuf ne unheṅ bādshāh ke hukm ke mutābiq gāṛiyāṅ aur safr ke lie ḳhurāk dī. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Us ne har ek bhāī ko kapṛoṅ kā ek joṛā bhī diyā. Lekin Binyamīn ko us ne chāṅdī ke 300 sikke aur pāṅch joṛe die. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Us ne apne bāp ko das gadhe bhijwā die jo Misr ke behtarīn māl se lade hue the aur das gadhiyāṅ jo anāj, roṭī aur bāp ke safr ke lie khāne se ladī huī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Yoṅ us ne apne bhāiyoṅ ko ruḳhsat karke kahā, “Rāste meṅ jhagaṛā na karnā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Wuh Misr se rawānā ho kar Mulk-e-Kanān meṅ apne bāp ke pās pahuṅche. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Unhoṅ ne us se kahā, “Yūsuf zindā hai! Wuh pūre Misr kā hākim hai.” Lekin Yāqūb hakkā-bakkā rah gayā, kyoṅki use yaqīn na āyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Tāham unhoṅ ne use sab kuchh batāyā jo Yūsuf ne un se kahā thā, aur us ne ḳhud wuh gāṛiyāṅ dekhīṅ jo Yūsuf ne use Misr le jāne ke lie bhijwā dī thīṅ. Phir Yāqūb kī jān meṅ jān ā gaī, ");
INSERT INTO urdgvr_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","aur us ne kahā, “Merā beṭā Yūsuf zindā hai! Yihī kāfī hai. Marne se pahle maiṅ jā kar us se milūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yāqūb sab kuchh le kar rawānā huā aur Bair-sabā pahuṅchā. Wahāṅ us ne apne bāp Is'hāq ke Ḳhudā ke huzūr qurbāniyāṅ chaṛhāīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Rāt ko Allāh royā meṅ us se hamkalām huā. Us ne kahā, “Yāqūb, Yāqūb!” Yāqūb ne jawāb diyā, “Jī, maiṅ hāzir hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Allāh ne kahā, “Maiṅ Allāh hūṅ, tere bāp Is'hāq kā Ḳhudā. Misr jāne se mat ḍar, kyoṅki wahāṅ maiṅ tujh se ek baṛī qaum banāūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Maiṅ tere sāth Misr jāūṅgā aur tujhe is mulk meṅ wāpas bhī le āūṅgā. Jab tū maregā to Yūsuf ḳhud terī āṅkheṅ band karegā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Is ke bād Yāqūb Bair-sabā se rawānā huā. Us ke beṭoṅ ne use aur apne bāl-bachchoṅ ko un gāṛiyoṅ meṅ biṭhā diyā jo Misr ke bādshāh ne bhijwāī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Yoṅ Yāqūb aur us kī tamām aulād apne maweshī aur Kanān meṅ hāsil kiyā huā māl le kar Misr chale gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yāqūb ke beṭe-beṭiyāṅ, pote-potiyāṅ aur bāqī aulād sab sāth gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Isrāīl kī aulād ke nām jo Misr chalī gaī yih haiṅ: Yāqūb ke pahlauṭhe Rūbin ");
INSERT INTO urdgvr_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ke beṭe Hanūk, Fallū, Hasron aur Karmī the. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Shamāūn ke beṭe āshruel, Yamīn, Uhad, Yakīn, Suhar aur Sāūl the. (Sāūl Kanānī aurat kā bachchā thā.) ");
INSERT INTO urdgvr_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lāwī ke beṭe Jairson, Qihāt aur Mirārī the. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yahūdāh ke beṭe Er, Onān, Selā, Fāras aur Zārah the. (Er aur Onān Kanān meṅ mar chuke the.) Fāras ke do beṭe Hasron aur Hamūl the. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ishkār ke beṭe Tolā, Fuwwā, Yob aur Simron the. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabūlūn ke beṭe sard, Ailon aur Yahliyel the. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","In beṭoṅ kī māṅ Liyāh thī, aur wuh Masoputāmiyā meṅ paidā hue. In ke alāwā Dīnā us kī beṭī thī. Kul 33 mard Liyāh kī aulād the. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Jad ke beṭe Sifyān, Hajjī, Sūnī, Isbūn, Erī, Arūdī aur Arelī the. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Āshar ke beṭe Yimnā, Iswāh, Iswī aur Bariyā the. Āshar kī beṭī Sirah thī, aur Bariyā ke do beṭe the, Hibar aur Malkiyel. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Kul 16 afrād Zilfā kī aulād the jise Lāban ne apnī beṭī Liyāh ko diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Rāḳhil ke beṭe Yūsuf aur Binyamīn the. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yūsuf ke do beṭe Manassī aur Ifrāīm Misr meṅ paidā hue. Un kī māṅ On ke pujārī Fotīfirā kī beṭī Āsanat thī. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Binyamīn ke beṭe Bālā, Bakar, Ashbel, Jīrā, Nāmān, Iḳhī, Ros, Muffīm, Huffīm aur Ard the. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Kul 14 mard Rāḳhil kī aulād the. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dān kā beṭā Hushīm thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftālī ke beṭe Yahsiyel, Jūnī, Yisar aur Sillīm the. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Kul 7 mard Bilhāh kī aulād the jise Lāban ne apnī beṭī Rāḳhil ko diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yāqūb kī aulād ke 66 afrād us ke sāth Misr chale gae. Is tādād meṅ beṭoṅ kī bīwiyāṅ shāmil nahīṅ thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Jab ham Yāqūb, Yūsuf aur us ke do beṭe in meṅ shāmil karte haiṅ to Yāqūb ke gharāne ke 70 afrād Misr gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yāqūb ne Yahūdāh ko apne āge Yūsuf ke pās bhejā tāki wuh Jushan meṅ un se mile. Jab wuh wahāṅ pahuṅche ");
INSERT INTO urdgvr_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","to Yūsuf apne rath par sawār ho kar apne bāp se milne ke lie Jushan gayā. Use dekh kar wuh us ke gale lag kar kāfī der rotā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yāqūb ne Yūsuf se kahā, “Ab maiṅ marne ke lie taiyār hūṅ, kyoṅki maiṅ ne ḳhud dekhā hai ki tū zindā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Phir Yūsuf ne apne bhāiyoṅ aur apne bāp ke ḳhāndān ke bāqī afrād se kahā, “Zarūrī hai ki maiṅ jā kar bādshāh ko ittalā dūṅ ki mere bhāī aur mere bāp kā pūrā ḳhāndān jo Kanān ke rahne wāle haiṅ mere pās ā gae haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Maiṅ us se kahūṅgā, ‘Yih ādmī bheṛ-bakriyoṅ ke charwāhe haiṅ. Wuh maweshī pālte haiṅ, is lie apnī bheṛ-bakriyāṅ, gāy-bail aur bāqī sārā māl apne sāth le āe haiṅ.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Bādshāh tumheṅ bulā kar pūchhegā ki tum kyā kām karte ho? ");
INSERT INTO urdgvr_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Phir tum ko jawāb denā hai, ‘Āp ke ḳhādim bachpan se maweshī pālte āe haiṅ. Yih hamāre bāpdādā kā peshā thā aur hamārā bhī hai.’ Agar tum yih kaho to tumheṅ Jushan meṅ rahne kī ijāzat milegī. Kyoṅki bheṛ-bakriyoṅ ke charwāhe Misriyoṅ kī nazar meṅ qābil-e-nafrat haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yūsuf Firaun ke pās gayā aur use ittalā de kar kahā, “Merā bāp aur bhāī apnī bheṛ-bakriyoṅ, gāy-bailoṅ aur sāre māl samet Mulk-e-Kanān se ā kar Jushan meṅ ṭhahre hue haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Us ne apne bhāiyoṅ meṅ se pāṅch ko chun kar Firaun ke sāmne pesh kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Firaun ne bhāiyoṅ se pūchhā, “Tum kyā kām karte ho?” Unhoṅ ne jawāb diyā, “Āp ke ḳhādim bheṛ-bakriyoṅ ke charwāhe haiṅ. Yih hamāre bāpdādā kā peshā thā aur hamārā bhī hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ham yahāṅ āe haiṅ tāki kuchh der ajnabī kī haisiyat se āp ke pās ṭhahreṅ, kyoṅki kāl ne Kanān meṅ bahut zor pakaṛā hai. Wahāṅ āp ke ḳhādimoṅ ke jānwaroṅ ke lie charāgāheṅ ḳhatm ho gaī haiṅ. Is lie hameṅ Jushan meṅ rahne kī ijāzat deṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Bādshāh ne Yūsuf se kahā, “Terā bāp aur bhāī tere pās ā gae haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Mulk-e-Misr tere sāmne khulā hai. Unheṅ behtarīn jagah par ābād kar. Wuh Jushan meṅ raheṅ. Aur agar un meṅ se kuchh haiṅ jo ḳhās qābiliyat rakhte haiṅ to unheṅ mere maweshiyoṅ kī nigahdāsht par rakh.” ");
INSERT INTO urdgvr_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Phir Yūsuf apne bāp Yāqūb ko le āyā aur Firaun ke sāmne pesh kiyā. Yāqūb ne bādshāh ko barkat dī. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Bādshāh ne us se pūchhā, “Tumhārī umr kyā hai?” ");
INSERT INTO urdgvr_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yāqūb ne jawāb diyā, “Maiṅ 130 sāl se is duniyā kā mehmān hūṅ. Merī zindagī muḳhtasar aur taklīfdeh thī, aur mere bāpdādā mujh se zyādā umrrasīdā hue the jab wuh is duniyā ke mehmān the.” ");
INSERT INTO urdgvr_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yih kah kar Yāqūb Firaun ko dubārā barkat de kar chalā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Phir Yūsuf ne apne bāp aur bhāiyoṅ ko Misr meṅ ābād kiyā. Us ne unheṅ Rāmsīs ke ilāqe meṅ behtarīn zamīn dī jis tarah bādshāh ne hukm diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yūsuf apne bāp ke pūre gharāne ko ḳhurāk muhaiyā kartā rahā. Har ḳhāndān ko us ke bachchoṅ kī tādād ke mutābiq ḳhurāk miltī rahī. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Kāl itnā saḳht thā ki kahīṅ bhī roṭī nahīṅ miltī thī. Misr aur Kanān meṅ log niḍhāl ho gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Misr aur Kanān ke tamām paise anāj ḳharīdne ke lie sarf ho gae. Yūsuf unheṅ jamā karke Firaun ke mahal meṅ le āyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Jab Misr aur Kanān ke paise ḳhatm ho gae to Misriyoṅ ne Yūsuf ke pās ā kar kahā, “Hameṅ roṭī deṅ! Ham āp ke sāmne kyoṅ mareṅ? Hamāre paise ḳhatm ho gae haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yūsuf ne jawāb diyā, “Agar āp ke paise ḳhatm haiṅ to mujhe apne maweshī deṅ. Maiṅ un ke ewaz roṭī detā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Chunāṅche wuh apne ghoṛe, bheṛ-bakriyāṅ, gāy-bail aur gadhe Yūsuf ke pās le āe. In ke ewaz us ne unheṅ ḳhurāk dī. Us sāl us ne unheṅ un ke tamām maweshiyoṅ ke ewaz ḳhurāk muhaiyā kī. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Agle sāl wuh dubārā us ke pās āe. Unhoṅ ne kahā, “Janāb-e-ālī, ham yih bāt āp se nahīṅ chhupā sakte ki ab ham sirf apne āp aur apnī zamīn ko āp ko de sakte haiṅ. Hamāre paise to ḳhatm haiṅ aur āp hamāre maweshī bhī le chuke haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ham kyoṅ āp kī āṅkhoṅ ke sāmne mar jāeṅ? Hamārī zamīn kyoṅ tabāh ho jāe? Hameṅ roṭī deṅ to ham aur hamārī zamīn bādshāh kī hogī. Ham Firaun ke ġhulām hoṅge. Hameṅ bīj deṅ tāki ham jīte bacheṅ aur zamīn tabāh na ho jāe.” ");
INSERT INTO urdgvr_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Chunāṅche Yūsuf ne Firaun ke lie Misr kī pūrī zamīn ḳharīd lī. Kāl kī saḳhtī ke sabab se tamām Misriyoṅ ne apne khet bech die. Is tarīqe se pūrā mulk Firaun kī milkiyat meṅ ā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yūsuf ne Misr ke ek sire se dūsre sire tak ke logoṅ ko shahroṅ meṅ muntaqil kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Sirf pujāriyoṅ kī zamīn āzād rahī. Unheṅ apnī zamīn bechne kī zarūrat hī nahīṅ thī, kyoṅki unheṅ Firaun se itnā wazīfā miltā thā ki guzārā ho jātā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yūsuf ne logoṅ se kahā, “Ġhaur se suneṅ. Āj maiṅ ne āp ko aur āp kī zamīn ko bādshāh ke lie ḳharīd liyā hai. Ab yih bīj le kar apne khetoṅ meṅ bonā. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Āp ko Firaun ko fasal kā pāṅchwāṅ hissā denā hai. Bāqī paidāwār āp kī hogī. Āp is se bīj bo sakte haiṅ, aur yih āp ke aur āp ke gharānoṅ aur bachchoṅ ke khāne ke lie hogā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Unhoṅ ne jawāb diyā, “Āp ne hameṅ bachāyā hai. Hamāre mālik ham par mehrbānī kareṅ to ham Firaun ke ġhulām baneṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Is tarah Yūsuf ne Misr meṅ yih qānūn nāfiz kiyā ki har fasal kā pāṅchwāṅ hissā bādshāh kā hai. Yih qānūn āj tak jārī hai. Sirf pujāriyoṅ kī zamīn bādshāh kī milkiyat meṅ na āī. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isrāīlī Misr meṅ Jushan ke ilāqe meṅ ābād hue. Wahāṅ unheṅ zamīn milī, aur wuh phale-phūle aur tādād meṅ bahut baṛh gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yāqūb 17 sāl Misr meṅ rahā. Wuh 147 sāl kā thā jab faut huā. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Jab marne kā waqt qarīb āyā to us ne Yūsuf ko bulā kar kahā, “Mehrbānī karke apnā hāth merī rān ke nīche rakh kar qasam khā ki tū mujh par shafqat aur wafādārī kā is tarah izhār karegā ki mujhe Misr meṅ dafn nahīṅ karegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Jab maiṅ mar kar apne bāpdādā se jā milūṅgā to mujhe Misr se le jā kar mere bāpdādā kī qabr meṅ dafnānā.” Yūsuf ne jawāb diyā, “Ṭhīk hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yāqūb ne kahā, “Qasam khā ki tū aisā hī karegā.” Yūsuf ne qasam khāī. Tab Isrāīl ne apne bistar ke sirhāne par Allāh ko sijdā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Kuchh der ke bād Yūsuf ko ittalā dī gaī ki āp kā bāp bīmār hai. Wuh apne do beṭoṅ Manassī aur Ifrāīm ko sāth le kar Yāqūb se milne gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yāqūb ko batāyā gayā, “Āp kā beṭā ā gayā hai” to wuh apne āp ko saṅbhāl kar apne bistar par baiṭh gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Us ne Yūsuf se kahā, “Jab maiṅ Kanānī shahr Lūz meṅ thā to Allāh Qādir-e-mutlaq mujh par zāhir huā. Us ne mujhe barkat de kar ");
INSERT INTO urdgvr_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","kahā, ‘Maiṅ tujhe phalne-phūlne dūṅgā aur terī aulād baṛhā dūṅgā balki tujh se bahut-sī qaumeṅ nikalne dūṅgā. Aur maiṅ terī aulād ko yih mulk hameshā ke lie de dūṅgā.’ ");
INSERT INTO urdgvr_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ab merī bāt sun. Maiṅ chāhtā hūṅ ki tere beṭe jo mere āne se pahle Misr meṅ paidā hue mere beṭe hoṅ. Ifrāīm aur Manassī Rūbin aur Shamāūn ke barābar hī mere beṭe hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Agar in ke bād tere hāṅ aur beṭe paidā ho jāeṅ to wuh mere beṭe nahīṅ balki tere ṭhahreṅge. Jo mīrās wuh pāeṅge wuh unheṅ Ifrāīm aur Manassī kī mīrās meṅ se milegī. ");
INSERT INTO urdgvr_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Maiṅ yih terī māṅ Rāḳhil ke sabab se kar rahā hūṅ jo Masoputāmiyā se wāpasī ke waqt Kanān meṅ Ifrātā ke qarīb mar gaī. Maiṅ ne use wahīṅ rāste meṅ dafn kiyā.” (Āj Ifrātā ko Bait-laham kahā jātā hai.) ");
INSERT INTO urdgvr_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Phir Yāqūb ne Yūsuf ke beṭoṅ par nazar ḍāl kar pūchhā, “Yih kaun haiṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yūsuf ne jawāb diyā, “Yih mere beṭe haiṅ jo Allāh ne mujhe yahāṅ Misr meṅ die.” Yāqūb ne kahā, “Unheṅ mere qarīb le ā tāki maiṅ unheṅ barkat dūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Būṛhā hone ke sabab se Yāqūb kī āṅkheṅ kamzor thīṅ. Wuh achchhī tarah dekh nahīṅ saktā thā. Yūsuf apne beṭoṅ ko Yāqūb ke pās le āyā to us ne unheṅ bosā de kar gale lagāyā ");
INSERT INTO urdgvr_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","aur Yūsuf se kahā, “Mujhe tawaqqo hī nahīṅ thī ki maiṅ kabhī terā chehrā dekhūṅgā, aur ab Allāh ne mujhe tere beṭoṅ ko deḳhne kā mauqā bhī diyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Phir Yūsuf unheṅ Yāqūb kī god meṅ se le kar ḳhud us ke sāmne muṅh ke bal jhuk gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yūsuf ne Ifrāīm ko Yāqūb ke bāeṅ hāth rakhā aur Manassī ko us ke dāeṅ hāth. ");
INSERT INTO urdgvr_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Lekin Yāqūb ne apnā dahnā hāth bāīṅ taraf baṛhā kar Ifrāīm ke sar par rakhā agarche wuh chhoṭā thā. Is tarah us ne apnā bāyāṅ hāth dāīṅ taraf baṛhā kar Manassī ke sar par rakhā jo baṛā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Phir us ne Yūsuf ko us ke beṭoṅ kī mārifat barkat dī, “Allāh jis ke huzūr mere bāpdādā Ibrāhīm aur Is'hāq chalte rahe aur jo shurū se āj tak merā charwāhā rahā hai inheṅ barkat de. ");
INSERT INTO urdgvr_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Jis farishte ne ewazānā de kar mujhe har nuqsān se bachāyā hai wuh inheṅ barkat de. Allāh kare ki in meṅ merā nām aur mere bāpdādā Ibrāhīm aur Is'hāq ke nām jīte raheṅ. Duniyā meṅ in kī aulād kī tādād bahut baṛh jāe.” ");
INSERT INTO urdgvr_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Jab Yūsuf ne dekhā ki bāp ne apnā dahnā hāth chhoṭe beṭe Ifrāīm ke sar par rakhā hai to yih use burā lagā, is lie us ne bāp kā hāth pakaṛā tāki use Ifrāīm ke sar par se uṭhā kar Manassī ke sar par rakhe. ");
INSERT INTO urdgvr_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Us ne kahā, “Abbū, aise nahīṅ. Dūsrā laṛkā baṛā hai. Usī par apnā dahnā hāth rakheṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Lekin bāp ne inkār karke kahā, “Mujhe patā hai beṭā, mujhe patā hai. Wuh bhī ek baṛī qaum banegā. Phir bhī us kā chhoṭā bhāī us se baṛā hogā aur us se qaumoṅ kī baṛī tādād niklegī.” ");
INSERT INTO urdgvr_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Us din us ne donoṅ beṭoṅ ko barkat de kar kahā, “Isrāīlī tumhārā nām le kar barkat diyā kareṅge. Jab wuh barkat deṅge to kaheṅge, ‘Allāh āp ke sāth waisā kare jaisā us ne Ifrāīm aur Manassī ke sāth kiyā hai.’” Is tarah Yāqūb ne Ifrāīm ko Manassī se baṛā banā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Yūsuf se us ne kahā, “Maiṅ to marne wālā hūṅ, lekin Allāh tumhāre sāth hogā aur tumheṅ tumhāre bāpdādā ke mulk meṅ wāpas le jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ek bāt meṅ maiṅ tujhe tere bhāiyoṅ par tarjīh detā hūṅ, maiṅ tujhe Kanān meṅ wuh qit'ā detā hūṅ jo maiṅ ne apnī talwār aur kamān se Amoriyoṅ se chhīnā thā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yāqūb ne apne beṭoṅ ko bulā kar kahā, “Mere pās jamā ho jāo tāki maiṅ tumheṅ batāūṅ ki mustaqbil meṅ tumhāre sāth kyā kyā hogā. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ai Yāqūb ke beṭo, ikaṭṭhe ho kar suno, apne bāp Isrāīl kī bātoṅ par ġhaur karo. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rūbin, tum mere pahlauṭhe ho, mere zor aur merī tāqat kā pahlā phal. Tum izzat aur quwwat ke lihāz se bartar ho. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Lekin chūṅki tum beqābū sailāb kī mānind ho is lie tumhārī awwal haisiyat jātī rahe. Kyoṅki tum ne merī haram se hambistar ho kar apne bāp kī behurmatī kī hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Shamāūn aur Lāwī donoṅ bhāiyoṅ kī talwāreṅ zulm-o-tashaddud ke hathiyār rahe haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Merī jān na un kī majlis meṅ shāmil aur na un kī jamāt meṅ dāḳhil ho, kyoṅki unhoṅ ne ġhusse meṅ ā kar dūsroṅ ko qatl kiyā hai, unhoṅ ne apnī marzī se bailoṅ kī koṅcheṅ kāṭī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Un ke ġhusse par lānat ho jo itnā zabardast hai aur un ke taish par jo itnā saḳht hai. Maiṅ unheṅ Yāqūb ke mulk meṅ titar-bitar karūṅga, unheṅ Isrāīl meṅ muntashir kar dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yahūdāh, tumhāre bhāī tumhārī tārīf kareṅge. Tum apne dushmanoṅ kī gardan pakaṛe rahoge, aur tumhāre bāp ke beṭe tumhāre sāmne jhuk jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yahūdāh sherbabar kā bachchā hai. Mere beṭe, tum abhī abhī shikār mār kar wāpas āe ho. Yahūdāh sherbabar balki shernī kī tarah dabak kar baiṭh jātā hai. Kaun use chheṛne kī jurrat karegā? ");
INSERT INTO urdgvr_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Shāhī asā Yahūdāh se dūr nahīṅ hogā balki shāhī iḳhtiyār us waqt tak us kī aulād ke pās rahegā jab tak wuh hākim na āe jis ke tābe qaumeṅ raheṅgī. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Wuh apnā jawān gadhā angūr kī bel se aur apnī gadhī kā bachchā behtarīn angūr kī bel se bāndhegā. Wuh apnā libās mai meṅ aur apnā kapṛā angūr ke ḳhūn meṅ dhoegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Us kī āṅkheṅ mai se zyādā gadlī aur us ke dāṅt dūdh se zyādā safed hoṅge. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabūlūn sāhil par ābād hogā jahāṅ bahrī jahāz hoṅge. Us kī had Saidā tak hogī. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ishkār tāqatwar gadhā hai jo apne zīn ke do boroṅ ke darmiyān baiṭhā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Jab wuh dekhegā ki us kī ārāmgāh achchhī aur us kā mulk ḳhushnumā hai to wuh bojh uṭhāne ke lie taiyār ho jāegā aur ujrat ke baġhair kām karne ke lie majbūr kiyā jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dān apnī qaum kā insāf karegā agarche wuh Isrāīl ke qabīloṅ meṅ se ek hī hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dān saṛak ke sāṅp aur rāste ke afaī kī mānind hogā. Wuh ghoṛe kī eṛiyoṅ ko kāṭegā to us kā sawār pīchhe gir jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ai Rab, maiṅ terī hī najāt ke intazār meṅ hūṅ! ");
INSERT INTO urdgvr_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Jad par ḍākuoṅ kā jatthā hamlā karegā, lekin wuh palaṭ kar usī par hamlā kar degā. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Āshar ko ġhizāiyat wālī ḳhurāk hāsil hogī. Wuh lazīz shāhī khānā muhaiyā karegā. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftālī āzād chhoṛī huī hirnī hai. Wuh ḳhūbsūrat bāteṅ kartā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yūsuf phaldār bel hai. Wuh chashme par lagī huī phaldār bel hai jis kī shāḳheṅ dīwār par chaṛh gaī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Tīrandāzoṅ ne us par tīr chalā kar use tang kiyā aur us ke pīchhe paṛ gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Lekin us kī kamān mazbūt rahī, aur us ke bāzū Yāqūb ke zorāwar Ḳhudā ke sabab se tāqatwar rahe, us charwāhe ke sabab se jo Isrāīl kā Zabardast Sūrmā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Kyoṅki tere bāp kā Ḳhudā terī madad kartā hai, Allāh Qādir-e-mutlaq tujhe āsmān kī barkat, zamīn kī gahrāiyoṅ kī barkat aur aulād kī barkat detā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Tere bāp kī barkat qadīm pahāṛoṅ aur abadī pahāṛiyoṅ kī marġhūb chīzoṅ se zyādā azīm hai. Yih tamām barkat Yūsuf ke sar par ho, us shaḳhs ke chāṅd par jo apne bhāiyoṅ par shahzādā hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Binyamīn phāṛne wālā bheṛiyā hai. Subah wuh apnā shikār khā jātā aur rāt ko apnā lūṭā huā māl taqsīm kar detā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Yih Isrāīl ke kul bārah qabīle haiṅ. Aur yih wuh kuchh hai jo un ke bāp ne un se barkat dete waqt kahā. Us ne har ek ko us kī apnī barkat dī. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Phir Yāqūb ne apne beṭoṅ ko hukm diyā, “Ab maiṅ kūch karke apne bāpdādā se jā milūṅgā. Mujhe mere bāpdādā ke sāth us ġhār meṅ dafnānā jo Hittī ādmī Ifron ke khet meṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Yānī us ġhār meṅ jo Mulk-e-Kanān meṅ Mamre ke mashriq meṅ Makfīlā ke khet meṅ hai. Ibrāhīm ne use khet samet apne logoṅ ko dafnāne ke lie Ifron Hittī se ḳharīd liyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Wahāṅ Ibrāhīm aur us kī bīwī Sārā dafnāe gae. Wahāṅ Is'hāq aur us kī bīwī Ribqā dafnāe gae aur wahāṅ maiṅ ne Liyāh ko dafn kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Wuh khet aur us kā ġhār Hittiyoṅ se ḳharīdā gayā thā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","In hidāyāt ke bād Yāqūb ne apne pāṅw bistar par sameṭ lie aur dam chhoṛ kar apne bāpdādā se jā milā. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yūsuf apne bāp ke chehre se lipaṭ gayā. Us ne rote hue use bosā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Us ke mulāzimoṅ meṅ se kuchh ḍākṭar the. Us ne unheṅ hidāyat dī ki mere bāp Isrāīl kī lāsh ko hanūt kareṅ tāki wuh gal na jāe. Unhoṅ ne aisā hī kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Is meṅ 40 din lag gae. Ām taur par hanūt karne ke lie itne hī din lagte haiṅ. Misriyoṅ ne 70 din tak Yāqūb kā mātam kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Jab mātam kā waqt ḳhatm huā to Yūsuf ne bādshāh ke darbāriyoṅ se kahā, “Mehrbānī karke yih ḳhabar bādshāh tak pahuṅchā deṅ ");
INSERT INTO urdgvr_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","ki mere bāp ne mujhe qasam dilā kar kahā thā, ‘Maiṅ marne wālā hūṅ. Mujhe us qabr meṅ dafn karnā jo maiṅ ne Mulk-e-Kanān meṅ apne lie banwāī.’ Ab mujhe ijāzat deṅ ki maiṅ wahāṅ jāūṅ aur apne bāp ko dafn karke wāpas āūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Firaun ne jawāb diyā, “Jā, apne bāp ko dafn kar jis tarah us ne tujhe qasam dilāī thī.” ");
INSERT INTO urdgvr_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Chunāṅche Yūsuf apne bāp ko dafnāne ke lie Kanān rawānā huā. Bādshāh ke tamām mulāzim, mahal ke buzurg aur pūre Misr ke buzurg us ke sāth the. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yūsuf ke gharāne ke afrād, us ke bhāī aur us ke bāp ke gharāne ke log bhī sāth gae. Sirf un ke bachche, un kī bheṛ-bakriyāṅ aur gāy-bail Jushan meṅ rahe. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Rath aur ghuṛsawār bhī sāth gae. Sab mil kar baṛā lashkar ban gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Jab wuh Yardan ke qarīb Atad ke khaliyān par pahuṅche to unhoṅ ne nihāyat dilsoz nohā kiyā. Wahāṅ Yūsuf ne sāt din tak apne bāp kā mātam kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Jab maqāmī Kanāniyoṅ ne Atad ke khaliyān par mātam kā yih nazārā dekhā to unhoṅ ne kahā, “Yih to mātam kā bahut baṛā intazām hai jo Misrī karwā rahe haiṅ.” Is lie us jagah kā nām Abīl-misrīm yānī ‘Misriyoṅ kā Mātam’ paṛ gayā. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yoṅ Yāqūb ke beṭoṅ ne apne bāp kā hukm pūrā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Unhoṅ ne use Mulk-e-Kanān meṅ le jā kar Makfīlā ke khet ke ġhār meṅ dafn kiyā jo Mamre ke mashriq meṅ hai. Yih wuhī khet hai jo Ibrāhīm ne Ifron Hittī se apne logoṅ ko dafnāne ke lie ḳharīdā thā. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Is ke bād Yūsuf, us ke bhāī aur bāqī tamām log jo janāze ke lie sāth gae the Misr ko lauṭ āe. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Jab Yāqūb intaqāl kar gayā to Yūsuf ke bhāī ḍar gae. Unhoṅ ne kahā, “Ḳhatrā hai ki ab Yūsuf hamārā tāqqub karke us ġhalat kām kā badlā le jo ham ne us ke sāth kiyā thā. Phir kyā hogā?” ");
INSERT INTO urdgvr_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Yih soch kar unhoṅ ne Yūsuf ko ḳhabar bhejī, “Āp ke bāp ne marne se peshtar hidāyat dī ");
INSERT INTO urdgvr_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ki Yūsuf ko batānā, ‘Apne bhāiyoṅ ke us ġhalat kām ko muāf kar denā jo unhoṅ ne tumhāre sāth kiyā.’ Ab hameṅ jo āp ke bāp ke Ḳhudā ke pairokār haiṅ muāf kar deṅ.” Yih ḳhabar sun kar Yūsuf ro paṛā. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Phir us ke bhāī ḳhud āe aur us ke sāmne gir gae. Unhoṅ ne kahā, “Ham āp ke ḳhādim haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Lekin Yūsuf ne kahā, “Mat ḍaro. Kyā maiṅ Allāh kī jagah hūṅ? Hargiz nahīṅ! ");
INSERT INTO urdgvr_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Tum ne mujhe nuqsān pahuṅchāne kā irādā kiyā thā, lekin Allāh ne us se bhalāī paidā kī. Aur ab is kā maqsad pūrā ho rahā hai. Bahut-se log maut se bach rahe haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Chunāṅche ab ḍarne kī zarūrat nahīṅ hai. Maiṅ tumheṅ aur tumhāre bachchoṅ ko ḳhurāk muhaiyā kartā rahūṅgā.” Yoṅ Yūsuf ne unheṅ tasallī dī aur un se narmī se bāt kī. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yūsuf apne bāp ke ḳhāndān samet Misr meṅ rahā. Wuh 110 sāl zindā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Maut se pahle us ne na sirf Ifrāīm ke bachchoṅ ko balki us ke potoṅ ko bhī dekhā. Manassī ke beṭe Makīr ke bachche bhī us kī maujūdagī meṅ paidā ho kar us kī god meṅ rakhe gae. ");
INSERT INTO urdgvr_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Phir ek waqt āyā ki Yūsuf ne apne bhāiyoṅ se kahā, “Maiṅ marne wālā hūṅ. Lekin Allāh zarūr āp kī dekh-bhāl karke āp ko is mulk se us mulk meṅ le jāegā jis kā us ne Ibrāhīm, Is'hāq aur Yāqūb se qasam khā kar wādā kiyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Phir Yūsuf ne Isrāīliyoṅ ko qasam dilā kar kahā, “Allāh yaqīnan tumhārī dekh-bhāl karke wahāṅ le jāegā. Us waqt merī haḍḍiyoṅ ko bhī uṭhā kar sāth le jānā.” ");
INSERT INTO urdgvr_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Phir Yūsuf faut ho gayā. Wuh 110 sāl kā thā. Use hanūt karke Misr meṅ ek tābūt meṅ rakhā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Zail meṅ un beṭoṅ ke nām haiṅ jo apne bāp Yāqūb aur apne ḳhāndānoṅ samet Misr meṅ āe the: ");
INSERT INTO urdgvr_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rūbin, Shamāūn, Lāwī, Yahūdāh, ");
INSERT INTO urdgvr_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Ishkār, Zabūlūn, Binyamīn, ");
INSERT INTO urdgvr_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dān, Naftālī, Jad aur Āshar. ");
INSERT INTO urdgvr_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Us waqt Yāqūb kī aulād kī tādād 70 thī. Yūsuf to pahle hī Misr ā chukā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Misr meṅ rahte hue bahut din guzar gae. Itne meṅ Yūsuf, us ke tamām bhāī aur us nasl ke tamām log mar gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Isrāīlī phale-phūle aur tādād meṅ bahut baṛh gae. Natīje meṅ wuh nihāyat hī tāqatwar ho gae. Pūrā mulk un se bhar gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Hote hote ek nayā bādshāh taḳhtnashīn huā jo Yūsuf se nāwāqif thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Us ne apne logoṅ se kahā, “Isrāīliyoṅ ko dekho. Wuh tādād aur tāqat meṅ ham se baṛh gae haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Āo, ham hikmat se kām leṅ, warnā wuh mazīd baṛh jāeṅge. Aisā na ho ki wuh kisī jang ke mauqe par dushman kā sāth de kar ham se laṛeṅ aur mulk ko chhoṛ jāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Chunāṅche Misriyoṅ ne Isrāīliyoṅ par nigarān muqarrar kie tāki begār meṅ un se kām karwā kar unheṅ dabāte raheṅ. Us waqt unhoṅ ne pitom aur Rāmsīs ke shahr tāmīr kie. In shahroṅ meṅ Firaun Bādshāh ke baṛe baṛe godām the. ");
INSERT INTO urdgvr_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Lekin jitnā Isrāīliyoṅ ko dabāyā gayā utnā hī wuh tādād meṅ baṛhte aur phailte gae. Āḳhirkār Misrī un se dahshat khāne lage, ");
INSERT INTO urdgvr_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","aur wuh baṛī berahmī se un se kām karwāte rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Isrāīliyoṅ kā guzārā nihāyat mushkil ho gayā. Unheṅ gārā taiyār karke īṅṭeṅ banānā aur khetoṅ meṅ muḳhtalif qism ke kām karnā paṛe. Is meṅ Misrī un se baṛī berahmī se pesh āte rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Isrāīliyoṅ kī do dāiyāṅ thīṅ jin ke nām Sifrā aur Fuā the. Misr ke bādshāh ne un se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Jab Ibrānī aurateṅ tumheṅ madad ke lie bulāeṅ to ḳhabardār raho. Agar laṛkā paidā ho to use jān se mār do, agar laṛkī ho to use jītā chhoṛ do.” ");
INSERT INTO urdgvr_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Lekin dāiyāṅ Allāh kā ḳhauf māntī thīṅ. Unhoṅ ne Misr ke bādshāh kā hukm na mānā balki laṛkoṅ ko bhī jīne diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Tab Misr ke bādshāh ne unheṅ dubārā bulā kar pūchhā, “Tum ne yih kyoṅ kiyā? Tum laṛkoṅ ko kyoṅ jītā chhoṛ detī ho?” ");
INSERT INTO urdgvr_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Unhoṅ ne jawāb diyā, “Ibrānī aurateṅ Misrī auratoṅ se zyādā mazbūt haiṅ. Bachche hamāre pahuṅchne se pahle hī paidā ho jāte haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Chunāṅche Allāh ne dāiyoṅ ko barkat dī, aur Isrāīlī qaum tādād meṅ baṛh kar bahut tāqatwar ho gaī. ");
INSERT INTO urdgvr_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Aur chūṅki dāiyāṅ Allāh kā ḳhauf māntī thīṅ is lie us ne unheṅ aulād de kar un ke ḳhāndānoṅ ko qāym rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Āḳhirkār bādshāh ne apne tamām hamwatanoṅ se bāt kī, “Jab bhī Ibrāniyoṅ ke laṛke paidā hoṅ to unheṅ Dariyā-e-Nīl meṅ phaiṅk denā. Sirf laṛkiyoṅ ko zindā rahne do.” ");
INSERT INTO urdgvr_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Un dinoṅ meṅ Lāwī ke ek ādmī ne apne hī qabīle kī ek aurat se shādī kī. ");
INSERT INTO urdgvr_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Aurat hāmilā huī aur bachchā paidā huā. Māṅ ne dekhā ki laṛkā ḳhūbsūrat hai, is lie us ne use tīn māh tak chhupāe rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Jab wuh use aur zyādā na chhupā sakī to us ne ābī narsal se ṭokrī banā kar us par tārkol chaṛhāyā. Phir us ne bachche ko ṭokrī meṅ rakh kar ṭokrī ko Dariyā-e-Nīl ke kināre par uge hue sarkanḍoṅ meṅ rakh diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Bachche kī bahan kuchh fāsile par khaṛī deḳhtī rahī ki us kā kyā banegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Us waqt Firaun kī beṭī nahāne ke lie dariyā par āī. Us kī naukarāniyāṅ dariyā ke kināre ṭahalne lagīṅ. Tab us ne sarkanḍoṅ meṅ ṭokrī dekhī aur apnī launḍī ko use lāne bhejā. ");
INSERT INTO urdgvr_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Use kholā to chhoṭā laṛkā dikhāī diyā jo ro rahā thā. Firaun kī beṭī ko us par tars āyā. Us ne kahā, “Yih koī Ibrānī bachchā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ab bachche kī bahan Firaun kī beṭī ke pās gaī aur pūchhā, “Kyā maiṅ bachche ko dūdh pilāne ke lie koī Ibrānī aurat ḍhūnḍ lāūṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Firaun kī beṭī ne kahā, “Hāṅ, jāo.” Laṛkī chalī gaī aur bachche kī sagī māṅ ko le kar wāpas āī. ");
INSERT INTO urdgvr_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Firaun kī beṭī ne māṅ se kahā, “Bachche ko le jāo aur use mere lie dūdh pilāyā karo. Maiṅ tumheṅ is kā muāwazā dūṅgī.” Chunāṅche bachche kī māṅ ne use dūdh pilāne ke lie le liyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Jab bachchā baṛā huā to us kī māṅ use Firaun kī beṭī ke pās le gaī, aur wuh us kā beṭā ban gayā. Firaun kī beṭī ne us kā nām Mūsā yānī ‘Nikālā Gayā’ rakh kar kahā, “Maiṅ use pānī se nikāl lāī hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Jab Mūsā jawān huā to ek din wuh ghar se nikal kar apne logoṅ ke pās gayā jo jabrī kām meṅ masrūf the. Mūsā ne dekhā ki ek Misrī mere ek Ibrānī bhāī ko mār rahā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mūsā ne chāroṅ taraf nazar dauṛāī. Jab mālūm huā ki koī nahīṅ dekh rahā to us ne Misrī ko jān se mār diyā aur use ret meṅ chhupā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Agle din bhī Mūsā ghar se niklā. Is dafā do Ibrānī mard āpas meṅ laṛ rahe the. Jo ġhaltī par thā us se Mūsā ne pūchhā, “Tum apne bhāī ko kyoṅ mār rahe ho?” ");
INSERT INTO urdgvr_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ādmī ne jawāb diyā, “Kis ne āp ko ham par hukmrān aur qāzī muqarrar kiyā hai? Kyā āp mujhe bhī qatl karnā chāhte haiṅ jis tarah Misrī ko mār ḍālā thā?” Tab Mūsā ḍar gayā. Us ne sochā, “Hāy, merā bhed khul gayā hai!” ");
INSERT INTO urdgvr_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Bādshāh ko bhī patā lagā to us ne Mūsā ko marwāne kī koshish kī. Lekin Mūsā Midiyān ke mulk ko bhāg gayā. Wahāṅ wuh ek kueṅ ke pās baiṭh gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midiyān meṅ ek imām thā jis kī sāt beṭiyāṅ thīṅ. Yih laṛkiyāṅ apnī bheṛ-bakriyoṅ ko pānī pilāne ke lie kueṅ par āīṅ aur pānī nikāl kar hauz bharne lagīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Lekin kuchh charwāhoṅ ne ā kar unheṅ bhagā diyā. Yih dekh kar Mūsā uṭhā aur laṛkiyoṅ ko charwāhoṅ se bachā kar un ke rewaṛ ko pānī pilāyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Jab laṛkiyāṅ apne bāp Raūel ke pās wāpas āīṅ to bāp ne pūchhā, “Āj tum itnī jaldī se kyoṅ wāpas ā gaī ho?” ");
INSERT INTO urdgvr_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Laṛkiyoṅ ne jawāb diyā, “Ek Misrī ādmī ne hameṅ charwāhoṅ se bachāyā. Na sirf yih balki us ne hamāre lie pānī bhī nikāl kar rewaṛ ko pilā diyā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Raūel ne kahā, “Wuh ādmī kahāṅ hai? Tum use kyoṅ chhoṛ kar āī ho? Use bulāo tāki wuh hamāre sāth khānā khāe.” ");
INSERT INTO urdgvr_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mūsā Raūel ke ghar meṅ ṭhaharne ke lie rāzī ho gayā. Bād meṅ us kī shādī Raūel kī beṭī Saffūrā se huī. ");
INSERT INTO urdgvr_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Saffūrā ke beṭā paidā huā to Mūsā ne kahā, “Is kā nām Jairsom yānī ‘Ajnabī Mulk meṅ Pardesī’ ho, kyoṅki maiṅ ajnabī mulk meṅ pardesī hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Kāfī arsā guzar gayā. Itne meṅ Misr kā bādshāh intaqāl kar gayā. Isrāīlī apnī ġhulāmī tale karāhte aur madad ke lie pukārte rahe, aur un kī chīḳheṅ Allāh tak pahuṅch gaīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Allāh ne un kī āheṅ sunīṅ aur us ahd ko yād kiyā jo us ne Ibrāhīm, Is'hāq aur Yāqūb se bāndhā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Allāh Isrāīliyoṅ kī hālat dekh kar un kā ḳhayāl karne lagā. ");
INSERT INTO urdgvr_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mūsā apne susar Yitro kī bheṛ-bakriyoṅ kī nigahbānī kartā thā. (Midiyān kā imām Raūel Yitro bhī kahlātā thā.) Ek din Mūsā rewaṛ ko registān kī parlī jānib le gayā aur chalte chalte Allāh ke pahāṛ Horib yānī Sīnā tak pahuṅch gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Wahāṅ Rab kā farishtā āg ke shole meṅ us par zāhir huā. Yih sholā ek jhāṛī meṅ bhaṛak rahā thā. Mūsā ne dekhā ki jhāṛī jal rahī hai lekin bhasm nahīṅ ho rahī. ");
INSERT INTO urdgvr_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Mūsā ne sochā, “Yih to ajīb bāt hai. Kyā wajah hai ki jaltī huī jhāṛī bhasm nahīṅ ho rahī? Maiṅ zarā wahāṅ jā kar yih hairatangez manzar dekhūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Jab Rab ne dekhā ki Mūsā jhāṛī ko deḳhne ā rahā hai to us ne use jhāṛī meṅ se pukārā, “Mūsā, Mūsā!” Mūsā ne kahā, “Jī, maiṅ hāzir hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Rab ne kahā, “Is se zyādā qarīb na ānā. Apnī jūtiyāṅ utār, kyoṅki tū muqaddas zamīn par khaṛā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Maiṅ tere bāp kā Ḳhudā, Ibrāhīm kā Ḳhudā, Is'hāq kā Ḳhudā aur Yāqūb kā Ḳhudā hūṅ.” Yih sun kar Mūsā ne apnā muṅh ḍhāṅk liyā, kyoṅki wuh Allāh ko deḳhne se ḍarā. ");
INSERT INTO urdgvr_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Rab ne kahā, “Maiṅ ne Misr meṅ apnī qaum kī burī hālat dekhī aur ġhulāmī meṅ un kī chīḳheṅ sunī haiṅ, aur maiṅ un ke dukhoṅ ko ḳhūb jāntā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ab maiṅ unheṅ Misriyoṅ ke qābū se bachāne ke lie utar āyā hūṅ. Maiṅ unheṅ Misr se nikāl kar ek achchhe wasī mulk meṅ le jāūṅgā, ek aise mulk meṅ jahāṅ dūdh aur shahd kī kasrat hai, go is waqt Kanānī, Hittī, Amorī, Farizzī, Hiwwī aur Yabūsī us meṅ rahte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Isrāīliyoṅ kī chīḳheṅ mujh tak pahuṅchī haiṅ. Maiṅ ne dekhā hai ki Misrī un par kis tarah kā zulm ḍhā rahe haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Chunāṅche ab jā. Maiṅ tujhe Firaun ke pās bhejtā hūṅ, kyoṅki tujhe merī qaum Isrāīl ko Misr se nikāl kar lānā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Lekin Mūsā ne Allāh se kahā, “Maiṅ kaun hūṅ ki Firaun ke pās jā kar Isrāīliyoṅ ko Misr se nikāl lāūṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Allāh ne kahā, “Maiṅ to tere sāth hūṅgā. Aur is kā sabūt ki maiṅ tujhe bhej rahā hūṅ yih hogā ki logoṅ ke Misr se nikalne ke bād tum yahāṅ ā kar is pahāṛ par merī ibādat karoge.” ");
INSERT INTO urdgvr_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Lekin Mūsā ne etarāz kiyā, “Agar maiṅ Isrāīliyoṅ ke pās jā kar unheṅ batāūṅ ki tumhāre bāpdādā ke Ḳhudā ne mujhe tumhāre pās bhejā hai to wuh pūchheṅge, ‘Us kā nām kyā hai?’ Phir maiṅ un ko kyā jawāb dūṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Allāh ne kahā, “Maiṅ jo hūṅ so maiṅ hūṅ. Un se kahnā, ‘Maiṅ hūṅ ne mujhe tumhāre pās bhejā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Rab jo tumhāre bāpdādā kā Ḳhudā, Ibrāhīm kā Ḳhudā, Is'hāq kā Ḳhudā aur Yāqūb kā Ḳhudā hai usī ne mujhe tumhāre pās bhejā hai.’ Yih abad tak merā nām rahegā. Log yihī nām le kar mujhe nasl-dar-nasl yād kareṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ab jā aur Isrāīl ke buzurgoṅ ko jamā karke un ko batā de ki Rab tumhāre bāpdādā Ibrāhīm, Is'hāq aur Yāqūb kā Ḳhudā mujh par zāhir huā hai. Wuh farmātā hai, ‘Maiṅ ne ḳhūb dekh liyā hai ki Misr meṅ tumhāre sāth kyā sulūk ho rahā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Is lie maiṅ ne faislā kiyā hai ki tumheṅ Misr kī musībat se nikāl kar Kanāniyoṅ, Hittiyoṅ, Amoriyoṅ, Farizziyoṅ, Hiwwiyoṅ aur Yabūsiyoṅ ke mulk meṅ le jāūṅ, aise mulk meṅ jahāṅ dūdh aur shahd kī kasrat hai.’ ");
INSERT INTO urdgvr_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Buzurg terī suneṅge. Phir un ke sāth Misr ke bādshāh ke pās jā kar us se kahnā, ‘Rab Ibrāniyoṅ kā Ḳhudā ham par zāhir huā hai. Is lie hameṅ ijāzat deṅ ki ham tīn din kā safr karke registān meṅ Rab apne Ḳhudā ke lie qurbāniyāṅ chaṛhāeṅ.’ ");
INSERT INTO urdgvr_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Lekin mujhe mālūm hai ki Misr kā bādshāh sirf is sūrat meṅ tumheṅ jāne degā ki koī zabardastī tumheṅ le jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Is lie maiṅ apnī qudrat zāhir karke apne mojizoṅ kī mārifat Misriyoṅ ko mārūṅga. Phir wuh tumheṅ jāne degā. ");
INSERT INTO urdgvr_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Us waqt maiṅ Misriyoṅ ke diloṅ ko tumhāre lie narm kar dūṅgā. Tumheṅ ḳhālī hāth nahīṅ jānā paṛegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Tamām Ibrānī aurateṅ apnī Misrī paṛosanoṅ aur apne ghar meṅ rahne wālī Misrī auratoṅ se chāṅdī aur sone ke zewarāt aur nafīs kapṛe māṅg kar apne bachchoṅ ko pahnāeṅgī. Yoṅ Misriyoṅ ko lūṭ liyā jāegā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mūsā ne etarāz kiyā, “Lekin Isrāīlī na merī bāt kā yaqīn kareṅge, na merī suneṅge. Wuh to kaheṅge, ‘Rab tum par zāhir nahīṅ huā.’” ");
INSERT INTO urdgvr_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Jawāb meṅ Rab ne Mūsā se kahā, “Tū ne hāth meṅ kyā pakaṛā huā hai?” Mūsā ne kahā, “Lāṭhī.” ");
INSERT INTO urdgvr_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Rab ne kahā, “Use zamīn par ḍāl de.” Mūsā ne aisā kiyā to lāṭhī sāṅp ban gaī, aur Mūsā ḍar kar bhāgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Rab ne kahā, “Ab sāṅp kī dum ko pakaṛ le.” Mūsā ne aisā kiyā to sāṅp phir lāṭhī ban gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Rab ne kahā, “Yih dekh kar logoṅ ko yaqīn āegā ki Rab jo un ke bāpdādā kā Ḳhudā, Ibrāhīm kā Ḳhudā, Is'hāq kā Ḳhudā aur Yāqūb kā Ḳhudā hai tujh par zāhir huā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ab apnā hāth apne libās meṅ ḍāl de.” Mūsā ne aisā kiyā. Jab us ne apnā hāth nikālā to wuh barf kī mānind safed ho gayā thā. Koṛh jaisī bīmārī lag gaī thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Tab Rab ne kahā, “Ab apnā hāth dubārā apne libās meṅ ḍāl.” Mūsā ne aisā kiyā. Jab us ne apnā hāth dubārā nikālā to wuh phir sehhatmand thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Rab ne kahā, “Agar logoṅ ko pahlā mojizā dekh kar yaqīn na āe aur wuh terī na suneṅ to shāyad unheṅ dūsrā mojizā dekh kar yaqīn āe. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Agar unheṅ phir bhī yaqīn na āe aur wuh terī na suneṅ to Dariyā-e-Nīl se kuchh pānī nikāl kar use ḳhushk zamīn par unḍel de. Yih pānī zamīn par girte hī ḳhūn ban jāegā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Lekin Mūsā ne kahā, “Mere āqā, maiṅ māzarat chāhtā hūṅ, maiṅ achchhī tarah bāt nahīṅ kar saktā balki maiṅ kabhī bhī yih liyāqat nahīṅ rakhtā thā. Is waqt bhī jab maiṅ tujh se bāt kar rahā hūṅ merī yihī hālat hai. Maiṅ ruk ruk kar boltā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Rab ne kahā, “Kis ne insān kā muṅh banāyā? Kaun ek ko gūṅgā aur dūsre ko bahrā banā detā hai? Kaun ek ko deḳhne kī qābiliyat detā hai aur dūsre ko is se mahrūm rakhtā hai? Kyā maiṅ jo Rab hūṅ yih sab kuchh nahīṅ kartā? ");
INSERT INTO urdgvr_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ab jā! Tere bolte waqt maiṅ ḳhud tere sāth hūṅgā aur tujhe wuh kuchh sikhāūṅgā jo tujhe kahnā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Lekin Mūsā ne iltijā kī, “Mere āqā, mehrbānī karke kisī aur ko bhej de.” ");
INSERT INTO urdgvr_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Tab Rab Mūsā se saḳht ḳhafā huā. Us ne kahā, “Kyā terā Lāwī bhāī Hārūn aise kām ke lie hāzir nahīṅ hai? Maiṅ jāntā hūṅ ki wuh achchhī tarah bol saktā hai. Dekh, wuh tujh se milne ke lie nikal chukā hai. Tujhe dekh kar wuh nihāyat ḳhush hogā. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Use wuh kuchh batā jo use kahnā hai. Tumhāre bolte waqt maiṅ tere aur us ke sāth hūṅgā aur tumheṅ wuh kuchh sikhāūṅgā jo tumheṅ karnā hogā. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Hārūn terī jagah qaum se bāt karegā jabki tū merī tarah use wuh kuchh batāegā jo use kahnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Lekin yih lāṭhī bhī sāth le jānā, kyoṅki isī ke zariye tū yih mojize karegā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Phir Mūsā apne susar Yitro ke ghar wāpas chalā gayā. Us ne kahā, “Mujhe zarā apne azīzoṅ ke pās wāpas jāne deṅ jo Misr meṅ haiṅ. Maiṅ mālūm karnā chāhtā hūṅ ki wuh abhī tak zindā haiṅ ki nahīṅ.” Yitro ne jawāb diyā, “Ṭhīk hai, salāmatī se jāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Mūsā abhī Midiyān meṅ thā ki Rab ne us se kahā, “Misr ko wāpas chalā jā, kyoṅki jo ādmī tujhe qatl karnā chāhte the wuh mar gae haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Chunāṅche Mūsā apnī bīwī aur beṭoṅ ko gadhe par sawār karke Misr ko lauṭne lagā. Allāh kī lāṭhī us ke hāth meṅ thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Rab ne us se yih bhī kahā, “Misr jā kar Firaun ke sāmne wuh tamām mojize dikhā jin kā maiṅ ne tujhe iḳhtiyār diyā hai. Lekin mere kahne par wuh aṛā rahegā. Wuh Isrāīliyoṅ ko jāne kī ijāzat nahīṅ degā. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Us waqt Firaun ko batā denā, ‘Rab farmātā hai ki Isrāīl merā pahlauṭhā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Maiṅ tujhe batā chukā hūṅ ki mere beṭe ko jāne de tāki wuh merī ibādat kare. Agar tū mere beṭe ko jāne se manā kare to maiṅ tere pahlauṭhe ko jān se mār dūṅgā.’” ");
INSERT INTO urdgvr_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ek din jab Mūsā apne ḳhāndān ke sāth rāste meṅ kisī sarāy meṅ ṭhahrā huā thā to Rab ne us par hamlā karke use mār dene kī koshish kī. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Yih dekh kar Saffūrā ne ek tez patthar se apne beṭe kā ḳhatnā kiyā aur kāṭe hue hisse se Mūsā ke pair chhue. Us ne kahā, “Yaqīnan tum mere ḳhūnī dūlhā ho.” ");
INSERT INTO urdgvr_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Tab Allāh ne Mūsā ko chhoṛ diyā. Saffūrā ne use ḳhatne ke bāis hī ‘Ḳhūnī Dūlhā’ kahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Rab ne Hārūn se bhī bāt kī, “Registān meṅ Mūsā se milne jā.” Hārūn chal paṛā aur Allāh ke pahāṛ ke pās Mūsā se milā. Us ne use bosā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mūsā ne Hārūn ko sab kuchh sunā diyā jo Rab ne use kahne ke lie bhejā thā. Us ne use un mojizoṅ ke bāre meṅ bhī batāyā jo use dikhāne the. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Phir donoṅ mil kar Misr gae. Wahāṅ pahuṅch kar unhoṅ ne Isrāīl ke tamām buzurgoṅ ko jamā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Hārūn ne unheṅ wuh tamām bāteṅ sunāīṅ jo Rab ne Mūsā ko batāī thīṅ. Us ne mazkūrā mojize bhī logoṅ ke sāmne dikhāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Phir unheṅ yaqīn āyā. Aur jab unhoṅ ne sunā ki Rab ko tumhārā ḳhayāl hai aur wuh tumhārī musībat se āgāh hai to unhoṅ ne Rab ko sijdā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Phir Mūsā aur Hārūn Firaun ke pās gae. Unhoṅ ne kahā, “Rab Isrāīl kā Ḳhudā farmātā hai, ‘Merī qaum ko registān meṅ jāne de tāki wuh mere lie īd manāeṅ.’” ");
INSERT INTO urdgvr_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Firaun ne jawāb diyā, “Yih Rab kaun hai? Maiṅ kyoṅ us kā hukm mān kar Isrāīliyoṅ ko jāne dūṅ? Na maiṅ Rab ko jāntā hūṅ, na Isrāīliyoṅ ko jāne dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Hārūn aur Mūsā ne kahā, “Ibrāniyoṅ kā Ḳhudā ham par zāhir huā hai. Is lie mehrbānī karke hameṅ ijāzat deṅ ki registān meṅ tīn din kā safr karke Rab apne Ḳhudā ke huzūr qurbāniyāṅ pesh kareṅ. Kahīṅ wuh hameṅ kisī bīmārī yā talwār se na māre.” ");
INSERT INTO urdgvr_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Lekin Misr ke bādshāh ne inkār kiyā, “Mūsā aur Hārūn, tum logoṅ ko kām se kyoṅ rok rahe ho? Jāo, jo kām ham ne tum ko diyā hai us par lag jāo! ");
INSERT INTO urdgvr_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Isrāīlī waise bhī tādād meṅ bahut baṛh gae haiṅ, aur tum unheṅ kām karne se rok rahe ho.” ");
INSERT INTO urdgvr_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Usī din Firaun ne Misrī nigarānoṅ aur un ke taht ke Isrāīlī nigarānoṅ ko hukm diyā, ");
INSERT INTO urdgvr_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Ab se Isrāīliyoṅ ko īṅṭeṅ banāne ke lie bhūsā mat denā, balki wuh ḳhud jā kar bhūsā jamā kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","To bhī wuh utnī hī īṅṭeṅ banāeṅ jitnī pahle banāte the. Wuh sust ho gae haiṅ aur isī lie chīḳh rahe haiṅ ki hameṅ jāne deṅ tāki apne Ḳhudā ko qurbāniyāṅ pesh kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Un se aur zyādā saḳht kām karāo, unheṅ kām meṅ lagāe rakho. Un ke pās itnā waqt hī na ho ki wuh jhūṭī bātoṅ par dhyān deṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Misrī nigarān aur un ke taht ke Isrāīlī nigarānoṅ ne logoṅ ke pās jā kar un se kahā, “Firaun kā hukm hai ki tumheṅ bhūsā na diyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Is lie ḳhud jāo aur bhūsā ḍhūnḍ kar jamā karo. Lekin ḳhabardār! Utnī hī īṅṭeṅ banāo jitnī pahle banāte the.” ");
INSERT INTO urdgvr_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Yih sun kar Isrāīlī bhūsā jamā karne ke lie pūre mulk meṅ phail gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Misrī nigarān yih kah kar un par dabāw ḍālte rahe ki utnī īṅṭeṅ banāo jitnī pahle banāte the. ");
INSERT INTO urdgvr_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Jo Isrāīlī nigarān unhoṅ ne muqarrar kie the unheṅ wuh pīṭte aur kahte rahe, “Tum ne kal aur āj utnī īṅṭeṅ kyoṅ nahīṅ banwāīṅ jitnī pahle banwāte the?” ");
INSERT INTO urdgvr_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Phir Isrāīlī nigarān Firaun ke pās gae. Unhoṅ ne shikāyat karke kahā, “Āp apne ḳhādimoṅ ke sāth aisā sulūk kyoṅ kar rahe haiṅ? ");
INSERT INTO urdgvr_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Hameṅ bhūsā nahīṅ diyā jā rahā aur sāth sāth yih kahā gayā hai ki utnī īṅṭeṅ banāo jitnī pahle banāte the. Natīje meṅ hameṅ mārā-pīṭā bhī jā rahā hai hālāṅki aisā karne meṅ āp ke apne log ġhaltī par haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Firaun ne jawāb diyā, “Tum log sust ho, tum kām karnā nahīṅ chāhte. Is lie tum yih jagah chhoṛnā aur Rab ko qurbāniyāṅ pesh karnā chāhte ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ab jāo, kām karo. Tumheṅ bhūsā nahīṅ diyā jāegā, lekin ḳhabardār! Utnī hī īṅṭeṅ banāo jitnī pahle banāte the.” ");
INSERT INTO urdgvr_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Jab Isrāīlī nigarānoṅ ko batāyā gayā ki īṅṭoṅ kī matlūbā tādād kam na karo to wuh samajh gae ki ham phaṅs gae haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Firaun ke mahal se nikal kar un kī mulāqāt Mūsā aur Hārūn se huī jo un ke intazār meṅ the. ");
INSERT INTO urdgvr_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Unhoṅ ne Mūsā aur Hārūn se kahā, “Rab ḳhud āp kī adālat kare. Kyoṅki āp ke sabab se Firaun aur us ke mulāzimoṅ ko ham se ghin ātī hai. Āp ne unheṅ hameṅ mār dene kā mauqā de diyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Yih sun kar Mūsā Rab ke pās wāpas āyā aur kahā, “Ai āqā, tū ne is qaum se aisā burā sulūk kyoṅ kiyā? Kyā tū ne isī maqsad se mujhe yahāṅ bhejā hai? ");
INSERT INTO urdgvr_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Jab se maiṅ ne Firaun ke pās jā kar use terī marzī batāī hai wuh Isrāīlī qaum se burā sulūk kar rahā hai. Aur tū ne ab tak unheṅ bachāne kā koī qadam nahīṅ uṭhāyā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Rab ne jawāb diyā, “Ab tū dekhegā ki maiṅ Firaun ke sāth kyā kuchh kartā hūṅ. Merī azīm qudrat kā tajrabā karke wuh mere logoṅ ko jāne degā balki unheṅ jāne par majbūr karegā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Allāh ne Mūsā se yih bhī kahā, “Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Maiṅ Ibrāhīm, Is'hāq aur Yāqūb par zāhir huā. Wuh mere nām Allāh Qādir-e-mutlaq se wāqif hue, lekin maiṅ ne un par apne nām Rab kā inkishāf nahīṅ kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Maiṅ ne un se ahd karke wādā kiyā ki unheṅ Mulk-e-Kanān dūṅgā jis meṅ wuh ajnabī ke taur par rahte the. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ab maiṅ ne sunā hai ki Isrāīlī kis tarah Misriyoṅ kī ġhulāmī meṅ karāh rahe haiṅ, aur maiṅ ne apnā ahd yād kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Chunāṅche Isrāīliyoṅ ko batānā, ‘Maiṅ Rab hūṅ. Maiṅ tumheṅ Misriyoṅ ke jue se āzād karūṅga aur un kī ġhulāmī se bachāūṅgā. Maiṅ baṛī qudrat ke sāth tumheṅ chhuṛāūṅgā aur un kī adālat karūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Maiṅ tumheṅ apnī qaum banāūṅgā aur tumhārā Ḳhudā hūṅgā. Tab tum jān loge ki maiṅ Rab tumhārā Ḳhudā hūṅ jis ne tumheṅ Misriyoṅ ke jue se āzād kar diyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Maiṅ tumheṅ us mulk meṅ le jāūṅgā jis kā wādā maiṅ ne qasam khā kar Ibrāhīm, Is'hāq aur Yāqūb se kiyā hai. Wuh mulk tumhārī apnī milkiyat hogā. Maiṅ Rab hūṅ.’” ");
INSERT INTO urdgvr_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mūsā ne yih sab kuchh Isrāīliyoṅ ko batā diyā, lekin unhoṅ ne us kī bāt na mānī, kyoṅki wuh saḳht kām ke bāis himmat hār gae the. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Tab Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Jā, Misr ke bādshāh Firaun ko batā denā ki Isrāīliyoṅ ko apne mulk se jāne de.” ");
INSERT INTO urdgvr_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Lekin Mūsā ne etarāz kiyā, “Isrāīlī merī bāt sunanā nahīṅ chāhte to Firaun kyoṅ merī bāt māne jabki maiṅ ruk ruk kar boltā hūṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Lekin Rab ne Mūsā aur Hārūn ko hukm diyā, “Isrāīliyoṅ aur Misr ke bādshāh Firaun se bāt karke Isrāīliyoṅ ko Misr se nikālo.” ");
INSERT INTO urdgvr_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Isrāīl ke ābāī gharānoṅ ke sarbarāh yih the: Isrāīl ke pahlauṭhe Rūbin ke chār beṭe Hanūk, Fallū, Hasron aur Karmī the. In se Rūbin kī chār shāḳheṅ niklīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Shamāūn ke pāṅch beṭe Yamuel, Yamīn, Uhad, Yakīn, Suhar aur Sāūl the. (Sāūl Kanānī aurat kā bachchā thā.) In se Shamāūn kī pāṅch shāḳheṅ niklīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Lāwī ke tīn beṭe Jairson, Qihāt aur Mirārī the. (Lāwī 137 sāl kī umr meṅ faut huā.) ");
INSERT INTO urdgvr_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Jairson ke do beṭe Libnī aur Simaī the. In se Jairson kī do shāḳheṅ niklīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Qihāt ke chār beṭe Amrām, Izhār, Habrūn aur Uzziyel the. (Qihāt 133 sāl kī umr meṅ faut huā.) ");
INSERT INTO urdgvr_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Mirārī ke do beṭe Mahlī aur Mūshī the. In sab se Lāwī kī muḳhtalif shāḳheṅ niklīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amrām ne apnī phūphī Yūkabid se shādī kī. Un ke do beṭe Hārūn aur Mūsā paidā hue. (Amrām 137 sāl kī umr meṅ faut huā.) ");
INSERT INTO urdgvr_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izhār ke tīn beṭe Qorah, Nafaj aur Zikrī the. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzziyel ke tīn beṭe Mīsāel, Ilsafan aur Sitrī the. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Hārūn ne Ilīsibā se shādī kī. (Ilīsibā Ammīnadāb kī beṭī aur Nahson kī bahan thī.) Un ke chār beṭe Nadab, Abīhū, Iliyazar aur Itamar the. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Qorah ke tīn beṭe Assīr, Ilqānā aur Abiyāsaf the. Un se Qorahiyoṅ kī tīn shāḳheṅ niklīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Hārūn ke beṭe Iliyazar ne Fūtiyel kī ek beṭī se shādī kī. Un kā ek beṭā Fīnhās thā. Yih sab Lāwī ke ābāī gharānoṅ ke sarbarāh the. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Rab ne Amrām ke do beṭoṅ Hārūn aur Mūsā ko hukm diyā ki merī qaum ko us ke ḳhāndānoṅ kī tartīb ke mutābiq Misr se nikālo. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Inhīṅ do ādmiyoṅ ne Misr ke bādshāh Firaun se bāt kī ki Isrāīliyoṅ ko Misr se jāne de. ");
INSERT INTO urdgvr_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Misr meṅ Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“Maiṅ Rab hūṅ. Misr ke bādshāh ko wuh sab kuchh batā denā jo maiṅ tujhe batātā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mūsā ne etarāz kiyā, “Maiṅ to ruk ruk kar boltā hūṅ. Firaun kis tarah merī bāt mānegā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Lekin Rab ne kahā, “Dekh, mere kahne par tū Firaun ke lie Allāh kī haisiyat rakhegā aur terā bhāī Hārūn terā paiġhambar hogā. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Jo bhī hukm maiṅ tujhe dūṅgā use tū Hārūn ko batā de. Phir wuh sab kuchh Firaun ko batāe tāki wuh Isrāīliyoṅ ko apne mulk se jāne de. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Lekin maiṅ Firaun ko aṛ jāne dūṅgā. Agarche maiṅ Misr meṅ bahut-se nishānoṅ aur mojizoṅ se apnī qudrat kā muzāharā karūṅga ");
INSERT INTO urdgvr_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","to bhī Firaun tumhārī nahīṅ sunegā. Tab Misriyoṅ par merā hāth bhārī ho jāegā, aur maiṅ un ko saḳht sazā de kar apnī qaum Isrāīl ko ḳhāndānoṅ kī tartīb ke mutābiq Misr se nikāl lāūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Jab maiṅ Misr ke ḳhilāf apnī qudrat kā izhār karke Isrāīliyoṅ ko wahāṅ se nikālūṅgā to Misrī jān leṅge ki maiṅ Rab hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mūsā aur Hārūn ne sab kuchh waisā hī kiyā jaisā Rab ne unheṅ hukm diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Firaun se bāt karte waqt Mūsā 80 sāl kā aur Hārūn 83 sāl kā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Rab ne Mūsā aur Hārūn se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Jab Firaun tumheṅ mojizā dikhāne ko kahegā to Mūsā Hārūn se kahe ki apnī lāṭhī zamīn par ḍāl de. Is par wuh sāṅp ban jāegī.” ");
INSERT INTO urdgvr_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mūsā aur Hārūn ne Firaun ke pās jā kar aisā hī kiyā. Hārūn ne apnī lāṭhī Firaun aur us ke ohdedāroṅ ke sāmne ḍāl dī to wuh sāṅp ban gaī. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Yih dekh kar Firaun ne apne ālimoṅ aur jādūgaroṅ ko bulāyā. Jādūgaroṅ ne bhī apne jādū se aisā hī kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Har ek ne apnī lāṭhī zamīn par phaiṅkī to wuh sāṅp ban gaī. Lekin Hārūn kī lāṭhī ne un kī lāṭhiyoṅ ko nigal liyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Tāham Firaun is se muta'assir na huā. Us ne Mūsā aur Hārūn kī bāt sunane se inkār kiyā. Waisā hī huā jaisā Rab ne kahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Phir Rab ne Mūsā se kahā, “Firaun aṛ gayā hai. Wuh merī qaum ko Misr chhoṛne se roktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Kal subah-sawere jab wuh Dariyā-e-Nīl par āegā to us se milne ke lie dariyā ke kināre par khaṛe ho jānā. Us lāṭhī ko thāme rakhnā jo sāṅp ban gaī thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Jab wuh wahāṅ pahuṅche to us se kahnā, ‘Rab Ibrāniyoṅ ke Ḳhudā ne mujhe āp ko yih batāne ke lie bhejā hai ki merī qaum ko merī ibādat karne ke lie registān meṅ jāne de. Lekin āp ne abhī tak us kī nahīṅ sunī. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Chunāṅche ab āp jān leṅge ki wuh Rab hai. Maiṅ is lāṭhī ko jo mere hāth meṅ hai le kar Dariyā-e-Nīl ke pānī ko mārūṅga. Phir wuh ḳhūn meṅ badal jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Dariyā-e-Nīl kī machhliyāṅ mar jāeṅgī, dariyā se badbū uṭhegī aur Misrī dariyā kā pānī nahīṅ pī sakeṅge.’” ");
INSERT INTO urdgvr_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Rab ne Mūsā se kahā, “Hārūn ko batā denā ki wuh apnī lāṭhī le kar apnā hāth un tamām jaghoṅ kī taraf baṛhāe jahāṅ pānī jamā hotā hai. Tab Misr kī tamām nadiyoṅ, nahroṅ, johaṛoṅ aur tālāboṅ kā pānī ḳhūn meṅ badal jāegā. Pūre mulk meṅ ḳhūn hī ḳhūn hogā, yahāṅ tak ki lakaṛī aur patthar ke bartanoṅ kā pānī bhī ḳhūn meṅ badal jāegā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Chunāṅche Mūsā aur Hārūn ne Firaun aur us ke ohdedāroṅ ke sāmne apnī lāṭhī uṭhā kar Dariyā-e-Nīl ke pānī par mārī. Is par dariyā kā sārā pānī ḳhūn meṅ badal gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Dariyā kī machhliyāṅ mar gaīṅ, aur us se itnī badbū uṭhne lagī ki Misrī us kā pānī na pī sake. Misr meṅ chāroṅ taraf ḳhūn hī ḳhūn thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Lekin jādūgaroṅ ne bhī apne jādū ke zariye aisā hī kiyā. Is lie Firaun aṛ gayā aur Mūsā aur Hārūn kī bāt na mānī. Waisā hī huā jaisā Rab ne kahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Firaun palaṭ kar apne ghar wāpas chalā gayā. Use us kī parwā nahīṅ thī jo Mūsā aur Hārūn ne kiyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Lekin Misrī dariyā se pānī na pī sake, aur unhoṅ ne pīne kā pānī hāsil karne ke lie dariyā ke kināre kināre gaṛhe khode. ");
INSERT INTO urdgvr_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Pānī ke badal jāne ke bād sāt din guzar gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Phir Rab ne Mūsā se kahā, “Firaun ke pās jā kar use batā denā ki Rab farmātā hai, ‘Merī qaum ko merī ibādat karne ke lie jāne de, ");
INSERT INTO urdgvr_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","warnā maiṅ pūre Misr ko meṅḍakoṅ se sazā dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Dariyā-e-Nīl meṅḍakoṅ se itnā bhar jāegā ki wuh dariyā se nikal kar tere mahal, tere sone ke kamre aur tere bistar meṅ jā ghuseṅge. Wuh tere ohdedāroṅ aur terī riāyā ke gharoṅ meṅ āeṅge balki tere tanūroṅ aur āṭā gūṅdhne ke bartanoṅ meṅ bhī phudakte phireṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Meṅḍak tujh par, terī qaum par aur tere ohdedāroṅ par chaṛh jāeṅge.’” ");
INSERT INTO urdgvr_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Rab ne Mūsā se kahā, “Hārūn ko batā denā ki wuh apnī lāṭhī ko hāth meṅ le kar use dariyāoṅ, nahroṅ aur johaṛoṅ ke ūpar uṭhāe tāki meṅḍak bāhar nikal kar Misr ke mulk meṅ phail jāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Hārūn ne Mulk-e-Misr ke pānī ke ūpar apnī lāṭhī uṭhāī to meṅḍakoṅ ke ġhol pānī se nikal kar pūre mulk par chhā gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Lekin jādūgaroṅ ne bhī apne jādū se aisā hī kiyā. Wuh bhī dariyā se meṅḍak nikāl lāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Firaun ne Mūsā aur Hārūn ko bulā kar kahā, “Rab se duā karo ki wuh mujh se aur merī qaum se meṅḍakoṅ ko dūr kare. Phir maiṅ tumhārī qaum ko jāne dūṅgā tāki wuh Rab ko qurbāniyāṅ pesh kareṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mūsā ne jawāb diyā, “Wuh waqt muqarrar kareṅ jab maiṅ āp ke ohdedāroṅ aur āp kī qaum ke lie duā karūṅ. Phir jo meṅḍak āp ke pās aur āp ke gharoṅ meṅ haiṅ usī waqt ḳhatm ho jāeṅge. Meṅḍak sirf dariyā meṅ pāe jāeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Firaun ne kahā, “Ṭhīk hai, kal unheṅ ḳhatm karo.” Mūsā ne kahā, “Jaisā āp kahte haiṅ waisā hī hogā. Is tarah āp ko mālūm hogā ki hamāre Ḳhudā kī mānind koī nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Meṅḍak āp, āp ke gharoṅ, āp ke ohdedāroṅ aur āp kī qaum ko chhoṛ kar sirf dariyā meṅ rah jāeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mūsā aur Hārūn Firaun ke pās se chale gae. Aur Mūsā ne Rab se minnat kī ki wuh meṅḍakoṅ ke wuh ġhol dūr kare jo us ne Firaun ke ḳhilāf bheje the. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Rab ne us kī duā sunī. Gharoṅ, sahnoṅ aur khetoṅ meṅ meṅḍak mar gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Logoṅ ne unheṅ jamā karke un ke ḍher lagā die. Un kī badbū pūre mulk meṅ phail gaī. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Lekin jab Firaun ne dekhā ki maslā hal ho gayā hai to wuh phir akaṛ gayā aur un kī na sunī. Yoṅ Rab kī bāt durust niklī. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Phir Rab ne Mūsā se kahā, “Hārūn se kahnā ki wuh apnī lāṭhī se zamīn kī gard ko māre. Jab wuh aisā karegā to pūre Misr kī gard juoṅ meṅ badal jāegī.” ");
INSERT INTO urdgvr_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Unhoṅ ne aisā hī kiyā. Hārūn ne apnī lāṭhī se zamīn kī gard ko mārā to pūre mulk kī gard juoṅ meṅ badal gaī. Un ke ġhol jānwaroṅ aur ādmiyoṅ par chhā gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Jādūgaroṅ ne bhī apne jādū se aisā karne kī koshish kī, lekin wuh gard se jueṅ na banā sake. Jueṅ ādmiyoṅ aur jānwaroṅ par chhā gaīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Jādūgaroṅ ne Firaun se kahā, “Allāh kī qudrat ne yih kiyā hai.” Lekin Firaun ne un kī na sunī. Yoṅ Rab kī bāt durust niklī. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Phir Rab ne Mūsā se kahā, “Jab Firaun subah-sawere dariyā par jāe to tū us ke rāste meṅ khaṛā ho jānā. Use kahnā ki Rab farmātā hai, ‘Merī qaum ko jāne de tāki wuh merī ibādat kar sakeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Warnā maiṅ tere aur tere ohdedāroṅ ke pās, terī qaum ke pās aur tere gharoṅ meṅ kāṭne wālī makkhiyāṅ bhej dūṅgā. Misriyoṅ ke ghar makkhiyoṅ se bhar jāeṅge balki jis zamīn par wuh khaṛe haiṅ wuh bhī makkhiyoṅ se ḍhāṅkī jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Lekin us waqt maiṅ apnī qaum ke sāth jo Jushan meṅ rahtī hai farq sulūk karūṅga. Wahāṅ ek bhī kāṭne wālī makkhī nahīṅ hogī. Is tarah tujhe patā lagegā ki is mulk meṅ maiṅ hī Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Maiṅ apnī qaum aur terī qaum meṅ imtiyāz karūṅga. Kal hī merī qudrat kā izhār hogā.’” ");
INSERT INTO urdgvr_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Rab ne aisā hī kiyā. Kāṭne wālī makkhiyoṅ ke ġhol Firaun ke mahal, us ke ohdedāroṅ ke gharoṅ aur pūre Misr meṅ phail gae. Mulk kā satyānās ho gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Phir Firaun ne Mūsā aur Hārūn ko bulā kar kahā, “Chalo, isī mulk meṅ apne Ḳhudā ko qurbāniyāṅ pesh karo.” ");
INSERT INTO urdgvr_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Lekin Mūsā ne kahā, “Yih munāsib nahīṅ hai. Jo qurbāniyāṅ ham Rab apne Ḳhudā ko pesh kareṅge wuh Misriyoṅ kī nazar meṅ ghinaunī haiṅ. Agar ham yahāṅ aisā kareṅ to kyā wuh hameṅ sangsār nahīṅ kareṅge? ");
INSERT INTO urdgvr_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Is lie lāzim hai ki ham tīn din kā safr karke registān meṅ hī Rab apne Ḳhudā ko qurbāniyāṅ pesh kareṅ jis tarah us ne hameṅ hukm bhī diyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Firaun ne jawāb diyā, “Ṭhīk hai, maiṅ tumheṅ jāne dūṅgā tāki tum registān meṅ Rab apne Ḳhudā ko qurbāniyāṅ pesh karo. Lekin tumheṅ zyādā dūr nahīṅ jānā hai. Aur mere lie bhī duā karnā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mūsā ne kahā, “Ṭhīk, maiṅ jāte hī Rab se duā karūṅga. Kal hī makkhiyāṅ Firaun, us ke ohdedāroṅ aur us kī qaum se dūr ho jāeṅgī. Lekin hameṅ dubārā fareb na denā balki hameṅ jāne denā tāki ham Rab ko qurbāniyāṅ pesh kar sakeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Phir Mūsā Firaun ke pās se chalā gayā aur Rab se duā kī. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Rab ne Mūsā kī duā sunī. Kāṭne wālī makkhiyāṅ Firaun, us ke ohdedāroṅ aur us kī qaum se dūr ho gaīṅ. Ek bhī makkhī na rahī. ");
INSERT INTO urdgvr_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Lekin Firaun phir akaṛ gayā. Us ne Isrāīliyoṅ ko jāne na diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Phir Rab ne Mūsā se kahā, “Firaun ke pās jā kar use batā ki Rab Ibrāniyoṅ kā Ḳhudā farmātā hai, ‘Merī qaum ko jāne de tāki wuh merī ibādat kar sakeṅ.’ ");
INSERT INTO urdgvr_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Agar āp inkār kareṅ aur unheṅ rokte raheṅ ");
INSERT INTO urdgvr_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","to Rab apnī qudrat kā izhār karke āp ke maweshiyoṅ meṅ bhayānak wabā phailā degā jo āp ke ghoṛoṅ, gadhoṅ, ūṅṭoṅ, gāy-bailoṅ, bheṛ-bakriyoṅ aur menḍhoṅ meṅ phail jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Lekin Rab Isrāīl aur Misr ke maweshiyoṅ meṅ imtiyāz karegā. Isrāīliyoṅ kā ek bhī jānwar nahīṅ maregā. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Rab ne faislā kar liyā hai ki wuh kal hī aisā karegā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Agle din Rab ne aisā hī kiyā. Misr ke tamām maweshī mar gae. Lekin Isrāīliyoṅ kā ek bhī jānwar na marā. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Firaun ne kuchh logoṅ ko un ke pās bhej diyā to patā chalā ki ek bhī jānwar nahīṅ marā. Tāham Firaun aṛā rahā. Us ne Isrāīliyoṅ ko jāne na diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Phir Rab ne Mūsā aur Hārūn se kahā, “Apnī muṭṭhiyāṅ kisī bhaṭṭī kī rākh se bhar kar Firaun ke pās jāo. Phir Mūsā Firaun ke sāmne yih rākh hawā meṅ uṛā de. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Yih rākh bārīk dhūl kā bādal ban jāegī jo pūre mulk par chhā jāegā. Us ke asar se logoṅ aur jānwaroṅ ke jismoṅ par phoṛe-phuṅsiyāṅ phūṭ nikleṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Mūsā aur Hārūn ne aisā hī kiyā. Wuh kisī bhaṭṭī se rākh le kar Firaun ke sāmne khaṛe ho gae. Mūsā ne rākh ko hawā meṅ uṛā diyā to insānoṅ aur jānwaroṅ ke jismoṅ par phoṛe-phuṅsiyāṅ nikal āe. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Is martabā jādūgar Mūsā ke sāmne khaṛe bhī na ho sake kyoṅki un ke jismoṅ par bhī phoṛe nikal āe the. Tamām Misriyoṅ kā yihī hāl thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Lekin Rab ne Firaun ko ziddī banāe rakhā, is lie us ne Mūsā aur Hārūn kī na sunī. Yoṅ waisā hī huā jaisā Rab ne Mūsā ko batāyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Is ke bād Rab ne Mūsā se kahā, “Subah-sawere uṭh aur Firaun ke sāmne khaṛe ho kar use batā ki Rab Ibrāniyoṅ kā Ḳhudā farmātā hai, ‘Merī qaum ko jāne de tāki wuh merī ibādat kar sakeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Warnā maiṅ apnī tamām āfateṅ tujh par, tere ohdedāroṅ par aur terī qaum par āne dūṅgā. Phir tū jān legā ki tamām duniyā meṅ mujh jaisā koī nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Agar maiṅ chāhtā to apnī qudrat se aisī wabā phailā saktā ki tujhe aur terī qaum ko duniyā se miṭā diyā jātā. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Lekin maiṅ ne tujhe is lie barpā kiyā hai ki tujh par apnī qudrat kā izhār karūṅ aur yoṅ tamām duniyā meṅ mere nām kā prachār kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Tū abhī tak apne āp ko sarfarāz karke merī qaum ke ḳhilāf hai aur unheṅ jāne nahīṅ detā. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Is lie kal maiṅ isī waqt bhayānak qism ke oloṅ kā tūfān bhej dūṅgā. Misrī qaum kī ibtidā se le kar āj tak Misr meṅ oloṅ kā aisā tūfān kabhī nahīṅ āyā hogā. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Apne bandoṅ ko abhī bhejnā tāki wuh tere maweshiyoṅ ko aur khetoṅ meṅ paṛe tere māl ko lā kar mahfūz kar leṅ. Kyoṅki jo bhī khule maidān meṅ rahegā wuh oloṅ se mar jāegā, ḳhāh insān ho yā haiwān.’” ");
INSERT INTO urdgvr_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Firaun ke kuchh ohdedār Rab kā paiġhām sun kar ḍar gae aur bhāg kar apne jānwaroṅ aur ġhulāmoṅ ko gharoṅ meṅ le āe. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Lekin dūsroṅ ne Rab ke paiġhām kī parwā na kī. Un ke jānwar aur ġhulām bāhar khule maidān meṅ rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Rab ne Mūsā se kahā, “Apnā hāth āsmān kī taraf baṛhā de. Phir Misr ke tamām insānoṅ, jānwaroṅ aur khetoṅ ke paudoṅ par ole paṛeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mūsā ne apnī lāṭhī āsmān kī taraf uṭhāī to Rab ne ek zabardast tūfān bhej diyā. Ole paṛe, bijlī girī aur bādal garajte rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Ole paṛte rahe aur bijlī chamaktī rahī. Misrī qaum kī ibtidā se le kar ab tak aise ḳhatarnāk ole kabhī nahīṅ paṛe the. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Insānoṅ se le kar haiwānoṅ tak khetoṅ meṅ sab kuchh barbād ho gayā. Oloṅ ne khetoṅ meṅ tamām paude aur daraḳht bhī toṛ die. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Wuh sirf Jushan ke ilāqe meṅ na paṛe jahāṅ Isrāīlī ābād the. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Tab Firaun ne Mūsā aur Hārūn ko bulāyā. Us ne kahā, “Is martabā maiṅ ne gunāh kiyā hai. Rab haq par hai. Mujh se aur merī qaum se ġhaltī huī hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ole aur Allāh kī garajtī āwāzeṅ had se zyādā haiṅ. Rab se duā karo tāki ole ruk jāeṅ. Ab maiṅ tumheṅ jāne dūṅgā. Ab se tumheṅ yahāṅ rahnā nahīṅ paṛegā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mūsā ne Firaun se kahā, “Maiṅ shahr se nikal kar donoṅ hāth Rab kī taraf uṭhā kar duā karūṅga. Phir garaj aur ole ruk jāeṅge aur āp jān leṅge ki pūrī duniyā Rab kī hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Lekin maiṅ jāntā hūṅ ki āp aur āp ke ohdedār abhī tak Rab Ḳhudā kā ḳhauf nahīṅ mānte.” ");
INSERT INTO urdgvr_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Us waqt san ke phūl nikal chuke the aur jau kī bāleṅ lag gaī thīṅ. Is lie yih fasleṅ tabāh ho gaīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Lekin gehūṅ aur ek aur qism kī gandum jo bād meṅ paktī hai barbād na huī. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mūsā Firaun ko chhoṛ kar shahr se niklā. Us ne Rab kī taraf apne hāth uṭhāe to garaj, ole aur bārish kā tūfān ruk gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Jab Firaun ne dekhā ki tūfān ḳhatm ho gayā hai to wuh aur us ke ohdedār dubārā gunāh karke akaṛ gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Firaun aṛā rahā aur Isrāīliyoṅ ko jāne na diyā. Waisā hī huā jaisā Rab ne Mūsā se kahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Phir Rab ne Mūsā se kahā, “Firaun ke pās jā, kyoṅki maiṅ ne us kā aur us ke darbāriyoṅ kā dil saḳht kar diyā hai tāki un ke darmiyān apne mojizoṅ aur apnī qudrat kā izhār kar sakūṅ ");
INSERT INTO urdgvr_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","aur tum apne beṭe-beṭiyoṅ aur pote-potiyoṅ ko sunā sako ki maiṅ ne Misriyoṅ ke sāth kyā sulūk kiyā hai aur un ke darmiyān kis tarah ke mojize karke apnī qudrat kā izhār kiyā hai. Yoṅ tum jān loge ki maiṅ Rab hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mūsā aur Hārūn Firaun ke pās gae. Unhoṅ ne us se kahā, “Rab Ibrāniyoṅ ke Ḳhudā kā farmān hai, ‘Tū kab tak mere sāmne hathiyār ḍālne se inkār karegā? Merī qaum ko merī ibādat karne ke lie jāne de, ");
INSERT INTO urdgvr_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","warnā maiṅ kal tere mulk meṅ ṭiḍḍiyāṅ lāūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Un ke ġhol zamīn par yoṅ chhā jāeṅge ki zamīn nazar hī nahīṅ āegī. Jo kuchh oloṅ ne tabāh nahīṅ kiyā use wuh chaṭ kar jāeṅgī. Bache hue daraḳhtoṅ ke patte bhī ḳhatm ho jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Tere mahal, tere ohdedāroṅ aur bāqī logoṅ ke ghar un se bhar jāeṅge. Jab se Misrī is mulk meṅ ābād hue haiṅ tum ne kabhī ṭiḍḍiyoṅ kā aisā saḳht hamlā nahīṅ dekhā hogā.’” Yih kah kar Mūsā palaṭ kar wahāṅ se chalā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Is par darbāriyoṅ ne Firaun se bāt kī, “Ham kab tak is mard ke jāl meṅ phaṅse raheṅ? Isrāīliyoṅ ko Rab apne Ḳhudā kī ibādat karne ke lie jāne deṅ. Kyā āp ko abhī tak mālūm nahīṅ ki Misr barbād ho gayā hai?” ");
INSERT INTO urdgvr_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Tab Mūsā aur Hārūn ko Firaun ke pās bulāyā gayā. Us ne un se kahā, “Jāo, apne Ḳhudā kī ibādat karo. Lekin yih batāo ki kaun kaun sāth jāegā?” ");
INSERT INTO urdgvr_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mūsā ne jawāb diyā, “Hamāre jawān aur būṛhe sāth jāeṅge. Ham apne beṭe-beṭiyoṅ, bheṛ-bakriyoṅ aur gāy-bailoṅ ko bhī sāth le kar jāeṅge. Ham sab ke sab jāeṅge, kyoṅki hameṅ Rab kī Īd manānī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Firaun ne tanzan kahā, “Ṭhīk hai, jāo aur Rab tumhāre sāth ho. Nahīṅ, maiṅ kis tarah tum sab ko bāl-bachchoṅ samet jāne de saktā hūṅ? Tum ne koī burā mansūbā banāyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Nahīṅ, sirf mard jā kar Rab kī ibādat kar sakte haiṅ. Tum ne to yihī darḳhāst kī thī.” Tab Mūsā aur Hārūn ko Firaun ke sāmne se nikāl diyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Phir Rab ne Mūsā se kahā, “Misr par apnā hāth uṭhā tāki ṭiḍḍiyāṅ ā kar Misr kī sarzamīn par phail jāeṅ. Jo kuchh bhī khetoṅ meṅ oloṅ se bach gayā hai use wuh khā jāeṅgī.” ");
INSERT INTO urdgvr_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Mūsā ne apnī lāṭhī Misr par uṭhāī to Rab ne mashriq se āṅdhī chalāī jo sārā din aur sārī rāt chaltī rahī aur aglī subah tak Misr meṅ ṭiḍḍiyāṅ pahuṅchāīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Beshumār ṭiḍḍiyāṅ pūre mulk par hamlā karke har jagah baiṭh gaīṅ. Is se pahle yā bād meṅ kabhī bhī ṭiḍḍiyoṅ kā itnā saḳht hamlā na huā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Unhoṅ ne zamīn ko yoṅ ḍhāṅk liyā ki wuh kālī nazar āne lagī. Jo kuchh bhī oloṅ se bach gayā thā chāhe khetoṅ ke paude yā daraḳhtoṅ ke phal the unhoṅ ne khā liyā. Misr meṅ ek bhī daraḳht yā paudā na rahā jis ke patte bach gae hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Tab Firaun ne Mūsā aur Hārūn ko jaldī se bulwāyā. Us ne kahā, “Maiṅ ne tumhāre Ḳhudā kā aur tumhārā gunāh kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ab ek aur martabā merā gunāh muāf karo aur Rab apne Ḳhudā se duā karo tāki maut kī yih hālat mujh se dūr ho jāe.” ");
INSERT INTO urdgvr_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mūsā ne mahal se nikal kar Rab se duā kī. ");
INSERT INTO urdgvr_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Jawāb meṅ Rab ne hawā kā ruḳh badal diyā. Us ne maġhrib se tez āṅdhī chalāī jis ne ṭiḍḍiyoṅ ko uṛā kar Bahr-e-Qulzum meṅ ḍāl diyā. Misr meṅ ek bhī ṭiḍḍī na rahī. ");
INSERT INTO urdgvr_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Lekin Rab ne hone diyā ki Firaun phir aṛ gayā. Us ne Isrāīliyoṅ ko jāne na diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Is ke bād Rab ne Mūsā se kahā, “Apnā hāth āsmān kī taraf uṭhā to Misr par andherā chhā jāegā. Itnā andherā hogā ki bandā use chhū sakegā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mūsā ne apnā hāth āsmān kī taraf uṭhāyā to tīn din tak Misr par gahrā andherā chhāyā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Tīn din tak log na ek dūsre ko dekh sake, na kahīṅ jā sake. Lekin jahāṅ Isrāīlī rahte the wahāṅ raushnī thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Tab Firaun ne Mūsā ko phir bulwāyā aur kahā, “Jāo, Rab kī ibādat karo! Tum apne sāth bāl-bachchoṅ ko bhī le jā sakte ho. Sirf apnī bheṛ-bakriyāṅ aur gāy-bail pīchhe chhoṛ denā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mūsā ne jawāb diyā, “Kyā āp hī hameṅ qurbāniyoṅ ke lie jānwar deṅge tāki unheṅ Rab apne Ḳhudā ko pesh kareṅ? ");
INSERT INTO urdgvr_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Yaqīnan nahīṅ. Is lie lāzim hai ki ham apne jānwaroṅ ko sāth le kar jāeṅ. Ek khur bhī pīchhe nahīṅ chhoṛā jāegā, kyoṅki abhī tak hameṅ mālūm nahīṅ ki Rab kī ibādat ke lie kin kin jānwaroṅ kī zarūrat hogī. Yih us waqt hī patā chalegā jab ham manzil-e-maqsūd par pahuṅcheṅge. Is lie zarūrī hai ki ham sab ko apne sāth le kar jāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Lekin Rab kī marzī ke mutābiq Firaun aṛ gayā. Us ne unheṅ jāne na diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Us ne Mūsā se kahā, “Dafā ho jā. Ḳhabardār! Phir kabhī apnī shakl na dikhānā, warnā tujhe maut ke hawāle kar diyā jāegā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mūsā ne kahā, “Ṭhīk hai, āp kī marzī. Maiṅ phir kabhī āp ke sāmne nahīṅ āūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Tab Rab ne Mūsā se kahā, “Ab maiṅ Firaun aur Misr par āḳhirī āfat lāne ko hūṅ. Is ke bād wuh tumheṅ jāne degā balki tumheṅ zabardastī nikāl degā. ");
INSERT INTO urdgvr_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Isrāīliyoṅ ko batā denā ki har mard apne paṛosī aur har aurat apnī paṛosan se sone-chāṅdī kī chīzeṅ māṅg le.” ");
INSERT INTO urdgvr_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Rab ne Misriyoṅ ke dil Isrāīliyoṅ kī taraf māyl kar die the. Wuh Firaun ke ohdedāroṅ samet ḳhāskar Mūsā kī baṛī izzat karte the.) ");
INSERT INTO urdgvr_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Mūsā ne kahā, “Rab farmātā hai, ‘Āj ādhī rāt ke waqt maiṅ Misr meṅ se guzarūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Tab bādshāh ke pahlauṭhe se le kar chakkī pīsne wālī naukarānī ke pahlauṭhe tak Misriyoṅ kā har pahlauṭhā mar jāegā. Chaupāiyoṅ ke pahlauṭhe bhī mar jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Misr kī sarzamīn par aisā ronā pīṭnā hogā ki na māzī meṅ kabhī huā, na mustaqbil meṅ kabhī hogā. ");
INSERT INTO urdgvr_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Lekin Isrāīlī aur un ke jānwar bache raheṅge. Kuttā bhī un par nahīṅ bhaunkegā. Is tarah tum jān loge ki Rab Isrāīliyoṅ kī nisbat Misriyoṅ se farq sulūk kartā hai.’” ");
INSERT INTO urdgvr_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Mūsā ne yih kuchh Firaun ko batāyā phir kahā, “Us waqt āp ke tamām ohdedār ā kar mere sāmne jhuk jāeṅge aur minnat kareṅge, ‘Apne pairokāroṅ ke sāth chale jāeṅ.’ Tab maiṅ chalā hī jāūṅgā.” Yih kah kar Mūsā Firaun ke pās se chalā gayā. Wuh baṛe ġhusse meṅ thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Rab ne Mūsā se kahā thā, “Firaun tumhārī nahīṅ sunegā. Kyoṅki lāzim hai ki maiṅ Misr meṅ apnī qudrat kā mazīd izhār karūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Go Mūsā aur Hārūn ne Firaun ke sāmne yih tamām mojize dikhāe, lekin Rab ne Firaun ko ziddī banāe rakhā, is lie us ne Isrāīliyoṅ ko mulk chhoṛne na diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Phir Rab ne Misr meṅ Mūsā aur Hārūn se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ab se yih mahīnā tumhāre lie sāl kā pahlā mahīnā ho.” ");
INSERT INTO urdgvr_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Isrāīl kī pūrī jamāt ko batānā ki is mahīne ke dasweṅ din har ḳhāndān kā sarparast apne gharāne ke lie lelā yānī bheṛ yā bakrī kā bachchā hāsil kare. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Agar gharāne ke afrād pūrā jānwar khāne ke lie kam hoṅ to wuh apne sab se qarībī paṛosī ke sāth mil kar lelā hāsil kareṅ. Itne log us meṅ se khāeṅ ki sab ke lie kāfī ho aur pūrā jānwar khāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Is ke lie ek sāl kā nar bachchā chun lenā jis meṅ nuqs na ho. Wuh bheṛ yā bakrī kā bachchā ho saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Mahīne ke 14weṅ din tak us kī dekh-bhāl karo. Us din tamām Isrāīlī sūraj ke ġhurūb hote waqt apne lele zabah kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Har ḳhāndān apne jānwar kā kuchh ḳhūn jamā karke use us ghar ke darwāze kī chaukhaṭ par lagāe jahāṅ lelā khāyā jāegā. Yih ḳhūn chaukhaṭ ke ūpar wāle hisse aur dāeṅ bāeṅ ke bāzuoṅ par lagāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Lāzim hai ki log jānwar ko bhūn kar usī rāt khāeṅ. Sāth hī wuh kaṛwā sāg-pāt aur beḳhamīrī roṭiyāṅ bhī khāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Lele kā gosht kachchā na khānā, na use pānī meṅ ubālnā balki pūre jānwar ko sar, pairoṅ aur andarūnī hissoṅ samet āg par bhūnanā. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Lāzim hai ki pūrā gosht usī rāt khāyā jāe. Agar kuchh subah tak bach jāe to use jalānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Khānā khāte waqt aisā libās pahnanā jaise tum safr par jā rahe ho. Apne jūte pahne rakhnā aur hāth meṅ safr ke lie lāṭhī lie hue tum use jaldī jaldī khānā. Rab ke Fasah kī Īd yoṅ manānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Maiṅ āj rāt Misr meṅ se guzarūṅga aur har pahlauṭhe ko jān se mār dūṅgā, ḳhāh insān kā ho yā haiwān kā. Yoṅ maiṅ jo Rab hūṅ Misr ke tamām dewatāoṅ kī adālat karūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Lekin tumhāre gharoṅ par lagā huā ḳhūn tumhārā ḳhās nishān hogā. Jis jis ghar ke darwāze par maiṅ wuh ḳhūn dekhūṅgā use chhoṛtā jāūṅgā. Jab maiṅ Misr par hamlā karūṅga to mohlak wabā tum tak nahīṅ pahuṅchegī. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Āj kī rāt ko hameshā yād rakhnā. Ise nasl-dar-nasl aur har sāl Rab kī ḳhās īd ke taur par manānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Sāt din tak beḳhamīrī roṭī khānā hai. Pahle din apne gharoṅ se tamām ḳhamīr nikāl denā. Agar koī in sāt dinoṅ ke daurān ḳhamīr khāe to use qaum meṅ se miṭāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Is īd ke pahle aur āḳhirī din muqaddas ijtimā mun'aqid karnā. In tamām dinoṅ ke daurān kām na karnā. Sirf ek kām kī ijāzat hai aur wuh hai apnā khānā taiyār karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Beḳhamīrī Roṭī kī Īd manānā lāzim hai, kyoṅki us din maiṅ tumhāre muta'addid ḳhāndānoṅ ko Misr se nikāl lāyā. Is lie yih din nasl-dar-nasl har sāl yād rakhnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Pahle mahīne ke 14weṅ din kī shām se le kar 21weṅ din kī shām tak sirf beḳhamīrī roṭī khānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Sāt din tak tumhāre gharoṅ meṅ ḳhamīr na pāyā jāe. Jo bhī is daurān ḳhamīr khāe use Isrāīl kī jamāt meṅ se miṭāyā jāe, ḳhāh wuh Isrāīlī shahrī ho yā ajnabī. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ġharz, is īd ke daurān ḳhamīr na khānā. Jahāṅ bhī tum rahte ho wahāṅ beḳhamīrī roṭī hī khānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Phir Mūsā ne tamām Isrāīlī buzurgoṅ ko bulā kar un se kahā, “Jāo, apne ḳhāndānoṅ ke lie bheṛ yā bakrī ke bachche chun kar unheṅ Fasah kī Īd ke lie zabah karo. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Zūfe kā guchchhā le kar use ḳhūn se bhare hue bāsan meṅ ḍubo denā. Phir use le kar ḳhūn ko chaukhaṭ ke ūpar wāle hisse aur dāeṅ bāeṅ ke bāzuoṅ par lagā denā. Subah tak koī apne ghar se na nikle. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Jab Rab Misriyoṅ ko mār ḍālne ke lie mulk meṅ se guzaregā to wuh chaukhaṭ ke ūpar wāle hisse aur dāeṅ bāeṅ ke bāzuoṅ par lagā huā ḳhūn dekh kar un gharoṅ ko chhoṛ degā. Wuh halāk karne wāle farishte ko ijāzat nahīṅ degā ki wuh tumhāre gharoṅ meṅ jā kar tumheṅ halāk kare. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Tum apnī aulād samet hameshā in hidāyāt par amal karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Yih rasm us waqt bhī adā karnā jab tum us mulk meṅ pahuṅchoge jo Rab tumheṅ degā. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Aur jab tumhāre bachche tum se pūchheṅ ki ham yih īd kyoṅ manāte haiṅ ");
INSERT INTO urdgvr_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","to un se kaho, ‘Yih Fasah kī qurbānī hai jo ham Rab ko pesh karte haiṅ. Kyoṅki jab Rab Misriyoṅ ko halāk kar rahā thā to us ne hamāre gharoṅ ko chhoṛ diyā thā.’” Yih sun kar Isrāīliyoṅ ne Allāh ko sijdā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Phir unhoṅ ne sab kuchh waisā hī kiyā jaisā Rab ne Mūsā aur Hārūn ko batāyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ādhī rāt ko Rab ne bādshāh ke pahlauṭhe se le kar jel ke qaidī ke pahlauṭhe tak Misriyoṅ ke tamām pahlauṭhoṅ ko jān se mār diyā. Chaupāiyoṅ ke pahlauṭhe bhī mar gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Us rāt Misr ke har ghar meṅ koī na koī mar gayā. Firaun, us ke ohdedār aur Misr ke tamām log jāg uṭhe aur zor zor se rone aur chīḳhne lage. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Abhī rāt thī ki Firaun ne Mūsā aur Hārūn ko bulā kar kahā, “Ab tum aur bāqī Isrāīlī merī qaum meṅ se nikal jāo. Apnī darḳhāst ke mutābiq Rab kī ibādat karo. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Jis tarah tum chāhte ho apnī bheṛ-bakriyoṅ ko bhī apne sāth le jāo. Aur mujhe bhī barkat denā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Bāqī Misriyoṅ ne bhī Isrāīliyoṅ par zor de kar kahā, “Jaldī jaldī mulk se nikal jāo, warnā ham sab mar jāeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Isrāīliyoṅ ke gūṅdhe hue āṭe meṅ ḳhamīr nahīṅ thā. Unhoṅ ne use gūṅdhne ke bartanoṅ meṅ rakh kar apne kapṛoṅ meṅ lapeṭ liyā aur safr karte waqt apne kandhoṅ par rakh liyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Isrāīlī Mūsā kī hidāyat par amal karke apne Misrī paṛosiyoṅ ke pās gae aur un se kapṛe aur sone-chāṅdī kī chīzeṅ māṅgīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Rab ne Misriyoṅ ke diloṅ ko Isrāīliyoṅ kī taraf māyl kar diyā thā, is lie unhoṅ ne un kī har darḳhāst pūrī kī. Yoṅ Isrāīliyoṅ ne Misriyoṅ ko lūṭ liyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Isrāīlī Rāmsīs se rawānā ho kar Sukkāt pahuṅch gae. Auratoṅ aur bachchoṅ ko chhoṛ kar un ke 6 lākh mard the. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Wuh apne bheṛ-bakriyoṅ aur gāy-bailoṅ ke baṛe baṛe rewaṛ bhī sāth le gae. Bahut-se aise log bhī un ke sāth nikle jo Isrāīlī nahīṅ the. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Rāste meṅ unhoṅ ne us beḳhamīrī āṭe se roṭiyāṅ banāīṅ jo wuh sāth le kar nikle the. Āṭe meṅ is lie ḳhamīr nahīṅ thā ki unheṅ itnī jaldī se Misr se nikāl diyā gayā thā ki khānā taiyār karne kā waqt hī na milā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isrāīlī 430 sāl tak Misr meṅ rahe the. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","430 sāl ke ain bād, usī din Rab ke yih tamām ḳhāndān Misr se nikle. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Us ḳhās rāt Rab ne ḳhud pahrā diyā tāki Isrāīlī Misr se nikal sakeṅ. Is lie tamām Isrāīliyoṅ ke lie lāzim hai ki wuh nasl-dar-nasl is rāt Rab kī tāzīm meṅ jāgte raheṅ, wuh bhī aur un ke bād kī aulād bhī. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Rab ne Mūsā aur Hārūn se kahā, “Fasah kī Īd ke yih usūl haiṅ: Kisī bhī pardesī ko Fasah kī Īd kā khānā khāne kī ijāzat nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Agar tum ne kisī ġhulām ko ḳharīd kar us kā ḳhatnā kiyā hai to wuh Fasah kā khānā khā saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Lekin ġhairshahrī yā mazdūr ko Fasah kā khānā khāne kī ijāzat nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Yih khānā ek hī ghar ke andar khānā hai. Na gosht ghar se bāhar le jānā, na lele kī kisī haḍḍī ko toṛnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Lāzim hai ki Isrāīl kī pūrī jamāt yih īd manāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Agar koī pardesī tumhāre sāth rahtā hai jo Fasah kī Īd meṅ shirkat karnā chāhe to lāzim hai ki pahle us ke gharāne ke har mard kā ḳhatnā kiyā jāe. Tab wuh Isrāīlī kī tarah khāne meṅ sharīk ho saktā hai. Lekin jis kā ḳhatnā na huā use Fasah kā khānā khāne kī ijāzat nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Yihī usūl har ek par lāgū hogā, ḳhāh wuh Isrāīlī ho yā pardesī.” ");
INSERT INTO urdgvr_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Tamām Isrāīliyoṅ ne waisā hī kiyā jaisā Rab ne Mūsā aur Hārūn se kahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Usī din Rab tamām Isrāīliyoṅ ko ḳhāndānoṅ kī tartīb ke mutābiq Misr se nikāl lāyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Isrāīliyoṅ ke har pahlauṭhe ko mere lie maḳhsūs-o-muqaddas karnā hai. Har pahlā nar bachchā merā hī hai, ḳhāh insān kā ho yā haiwān kā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Phir Mūsā ne logoṅ se kahā, “Is din ko yād rakho jab tum Rab kī azīm qudrat ke bāis Misr kī ġhulāmī se nikle. Is din koī chīz na khānā jis meṅ ḳhamīr ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Āj hī abīb ke mahīne meṅ tum Misr se rawānā ho rahe ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Rab ne tumhāre bāpdādā se qasam khā kar wādā kiyā hai ki wuh tum ko Kanānī, Hittī, Amorī, Hiwwī aur Yabūsī qaumoṅ kā mulk degā, ek aisā mulk jis meṅ dūdh aur shahd kī kasrat hai. Jab Rab tumheṅ us mulk meṅ pahuṅchā degā to lāzim hai ki tum isī mahīne meṅ yih rasm manāo. ");
INSERT INTO urdgvr_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Sāt din beḳhamīrī roṭī khāo. Sātweṅ din Rab kī tāzīm meṅ īd manāo. ");
INSERT INTO urdgvr_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Sāt din ḳhamīrī roṭī na khānā. Kahīṅ bhī ḳhamīr na pāyā jāe. Pūre mulk meṅ ḳhamīr kā nām-o-nishān tak na ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Us din apne beṭe se yih kaho, ‘Maiṅ yih īd us kām kī ḳhushī meṅ manātā hūṅ jo Rab ne mere lie kiyā jab maiṅ Misr se niklā.’ ");
INSERT INTO urdgvr_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Yih īd tumhāre hāth yā peshānī par nishān kī mānind ho jo tumheṅ yād dilāe ki Rab kī sharīat ko tumhāre hoṅṭoṅ par rahnā hai. Kyoṅki Rab tumheṅ apnī azīm qudrat se Misr se nikāl lāyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Is din kī yād har sāl ṭhīk waqt par manānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Rab tumheṅ Kanāniyoṅ ke us mulk meṅ le jāegā jis kā wādā us ne qasam khā kar tum aur tumhāre bāpdādā se kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Lāzim hai ki wahāṅ pahuṅch kar tum apne tamām pahlauṭhoṅ ko Rab ke lie maḳhsūs karo. Tumhāre maweshiyoṅ ke tamām pahlauṭhe bhī Rab kī milkiyat haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Agar tum apnā pahlauṭhā gadhā ḳhud rakhnā chāho to Rab ko us ke badle bheṛ yā bakrī kā bachchā pesh karo. Lekin agar tum use rakhnā nahīṅ chāhte to us kī gardan toṛ ḍālo. Lekin insān ke pahlauṭhoṅ ke lie har sūrat meṅ ewazī denā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Āne wāle dinoṅ meṅ jab tumhārā beṭā pūchhe ki is kā kyā matlab hai to use jawāb denā, ‘Rab apnī azīm qudrat se hameṅ Misr kī ġhulāmī se nikāl lāyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Jab Firaun ne akaṛ kar hameṅ jāne na diyā to Rab ne Misr ke tamām insānoṅ aur haiwānoṅ ke pahlauṭhoṅ ko mār ḍālā. Is wajah se maiṅ apne jānwaroṅ kā har pahlā bachchā Rab ko qurbān kartā aur apne har pahlauṭhe ke lie ewazī detā hūṅ’. ");
INSERT INTO urdgvr_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Yih dastūr tumhāre hāth aur peshānī par nishān kī mānind ho jo tumheṅ yād dilāe ki Rab hameṅ apnī qudrat se Misr se nikāl lāyā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Jab Firaun ne Isrāīlī qaum ko jāne diyā to Allāh unheṅ Filistiyoṅ ke ilāqe meṅ se guzarne wāle rāste se le kar na gayā, agarche us par chalte hue wuh jald hī Mulk-e-Kanān pahuṅch jāte. Balki Rab ne kahā, “Agar us rāste par chaleṅge to unheṅ dūsroṅ se laṛnā paṛegā. Aisā na ho ki wuh is wajah se apnā irādā badal kar Misr lauṭ jāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Is lie Allāh unheṅ dūsre rāste se le kar gayā, aur wuh registān ke rāste se Bahr-e-Qulzum kī taraf baṛhe. Misr se nikalte waqt mard musallah the. ");
INSERT INTO urdgvr_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mūsā Yūsuf kā tābūt bhī apne sāth le gayā, kyoṅki Yūsuf ne Isrāīliyoṅ ko qasam dilā kar kahā thā, “Allāh yaqīnan tumhārī dekh-bhāl karke wahāṅ le jāegā. Us waqt merī haḍḍiyoṅ ko bhī uṭhā kar sāth le jānā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Isrāīliyoṅ ne Sukkāt ko chhoṛ kar Etām meṅ apne ḳhaime lagāe. Etām registān ke kināre par thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Rab un ke āge āge chaltā gayā, din ke waqt bādal ke satūn meṅ tāki unheṅ rāste kā patā lage aur rāt ke waqt āg ke satūn meṅ tāki unheṅ raushnī mile. Yoṅ wuh din aur rāt safr kar sakte the. ");
INSERT INTO urdgvr_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Din ke waqt bādal kā satūn aur rāt ke waqt āg kā satūn un ke sāmne rahā. Wuh kabhī bhī apnī jagah se na haṭā. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Tab Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Isrāīliyoṅ ko kah denā ki wuh pīchhe muṛ kar Mijdāl aur samundar ke bīch yānī Fī-haḳhīrot ke nazdīk ruk jāeṅ. Wuh Bāl-safon ke muqābil sāhil par apne ḳhaime lagāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Yih dekh kar Firaun samjhegā ki Isrāīlī rāstā bhūl kar āwārā phir rahe haiṅ aur ki registān ne chāroṅ taraf unheṅ gher rakhā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Phir maiṅ Firaun ko dubārā aṛ jāne dūṅgā, aur wuh Isrāīliyoṅ kā pīchhā karegā. Lekin maiṅ Firaun aur us kī pūrī fauj par apnā jalāl zāhir karūṅga. Misrī jān leṅge ki maiṅ hī Rab hūṅ.” Isrāīliyoṅ ne aisā hī kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Jab Misr ke bādshāh ko ittalā dī gaī ki Isrāīlī hijrat kar gae haiṅ to us ne aur us ke darbāriyoṅ ne apnā ḳhayāl badal kar kahā, “Ham ne kyā kiyā hai? Ham ne unheṅ jāne diyā hai, aur ab ham un kī ḳhidmat se mahrūm ho gae haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Chunāṅche bādshāh ne apnā jangī rath taiyār karwāyā aur apnī fauj ko le kar niklā. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Wuh 600 behtarīn qism ke rath aur Misr ke bāqī tamām rathoṅ ko sāth le gayā. Tamām rathoṅ par afsarān muqarrar the. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Rab ne Misr ke bādshāh Firaun ko dubārā aṛ jāne diyā thā, is lie jab Isrāīlī baṛe iḳhtiyār ke sāth nikal rahe the to wuh un kā tāqqub karne lagā. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Isrāīliyoṅ kā pīchhā karte karte Firaun ke tamām ghoṛe, rath, sawār aur faujī un ke qarīb pahuṅche. Isrāīlī Bahr-e-Qulzum ke sāhil par Bāl-safon ke muqābil Fī-haḳhīrot ke nazdīk ḳhaime lagā chuke the. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Jab Isrāīliyoṅ ne Firaun aur us kī fauj ko apnī taraf baṛhte dekhā to wuh saḳht ghabrā gae aur madad ke lie Rab ke sāmne chīḳhne-chillāne lage. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Unhoṅ ne Mūsā se kahā, “Kyā Misr meṅ qabroṅ kī kamī thī ki āp hameṅ registān meṅ le āe haiṅ? Hameṅ Misr se nikāl kar āp ne hamāre sāth kyā kiyā hai? ");
INSERT INTO urdgvr_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Kyā ham ne Misr meṅ āp se darḳhāst nahīṅ kī thī ki mehrbānī karke hameṅ chhoṛ deṅ, hameṅ Misriyoṅ kī ḳhidmat karne deṅ? Yahāṅ ā kar registān meṅ mar jāne kī nisbat behtar hotā ki ham Misriyoṅ ke ġhulām rahte.” ");
INSERT INTO urdgvr_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Lekin Mūsā ne jawāb diyā, “Mat ghabrāo. Ārām se khaṛe raho aur dekho ki Rab tumheṅ āj kis tarah bachāegā. Āj ke bād tum in Misriyoṅ ko phir kabhī nahīṅ dekhoge. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Rab tumhāre lie laṛegā. Tumheṅ bas, chup rahnā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Phir Rab ne Mūsā se kahā, “Tū mere sāmne kyoṅ chīḳh rahā hai? Isrāīliyoṅ ko āge baṛhne kā hukm de. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Apnī lāṭhī ko pakaṛ kar use samundar ke ūpar uṭhā to wuh do hissoṅ meṅ baṭ jāegā. Isrāīlī ḳhushk zamīn par samundar meṅ se guzareṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Maiṅ Misriyoṅ ko aṛe rahne dūṅgā tāki wuh Isrāīliyoṅ kā pīchhā kareṅ. Phir maiṅ Firaun, us kī sārī fauj, us ke rathoṅ aur us ke sawāroṅ par apnā jalāl zāhir karūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Jab maiṅ Firaun, us ke rathoṅ aur us ke sawāroṅ par apnā jalāl zāhir karūṅga to Misrī jān leṅge ki maiṅ hī Rab hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Allāh kā farishtā Isrāīlī lashkar ke āge āge chal rahā thā. Ab wuh wahāṅ se haṭ kar un ke pīchhe khaṛā ho gayā. Bādal kā satūn bhī logoṅ ke āge se haṭ kar un ke pīchhe jā khaṛā huā. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Is tarah bādal Misriyoṅ aur Isrāīliyoṅ ke lashkaroṅ ke darmiyān ā gayā. Pūrī rāt Misriyoṅ kī taraf andherā hī andherā thā jabki Isrāīliyoṅ kī taraf raushnī thī. Is lie Misrī pūrī rāt ke daurān Isrāīliyoṅ ke qarīb na ā sake. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mūsā ne apnā hāth samundar ke ūpar uṭhāyā to Rab ne mashriq se tez āṅdhī chalāī. Āṅdhī tamām rāt chaltī rahī. Us ne samundar ko pīchhe haṭā kar us kī tah ḳhushk kar dī. Samundar do hissoṅ meṅ baṭ gayā ");
INSERT INTO urdgvr_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","to Isrāīlī samundar meṅ se ḳhushk zamīn par chalte hue guzar gae. Un ke dāīṅ aur bāīṅ taraf pānī dīwār kī tarah khaṛā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Jab Misriyoṅ ko patā chalā to Firaun ke tamām ghoṛe, rath aur ghuṛsawār bhī un ke pīchhe pīchhe samundar meṅ chale gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Subah-sawere hī Rab ne bādal aur āg ke satūn se Misr kī fauj par nigāh kī aur us meṅ abtarī paidā kar dī. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Un ke rathoṅ ke pahie nikal gae to un par qābū pānā mushkil ho gayā. Misriyoṅ ne kahā, “Āo, ham Isrāīliyoṅ se bhāg jāeṅ, kyoṅki Rab un ke sāth hai. Wuhī Misr kā muqābalā kar rahā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Tab Rab ne Mūsā se kahā, “Apnā hāth samundar ke ūpar uṭhā. Phir pānī wāpas ā kar Misriyoṅ, un ke rathoṅ aur ghuṛsawāroṅ ko ḍubo degā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mūsā ne apnā hāth samundar ke ūpar uṭhāyā to din nikalte waqt pānī māmūl ke mutābiq bahne lagā, aur jis taraf Misrī bhāg rahe the wahāṅ pānī hī pānī thā. Yoṅ Rab ne unheṅ samundar meṅ bahā kar ġharq kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Pānī wāpas ā gayā. Us ne rathoṅ aur ghuṛsawāroṅ ko ḍhāṅk liyā. Firaun kī pūrī fauj jo Isrāīliyoṅ kā tāqqub kar rahī thī ḍūb kar tabāh ho gaī. Un meṅ se ek bhī na bachā. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Lekin Isrāīlī ḳhushk zamīn par samundar meṅ se guzare. Un ke dāīṅ aur bāīṅ taraf pānī dīwār kī tarah khaṛā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Us din Rab ne Isrāīliyoṅ ko Misriyoṅ se bachāyā. Misriyoṅ kī lāsheṅ unheṅ sāhil par nazar āīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Jab Isrāīliyoṅ ne Rab kī yih azīm qudrat dekhī jo us ne Misriyoṅ par zāhir kī thī to Rab kā ḳhauf un par chhā gayā. Wuh us par aur us ke ḳhādim Mūsā par etamād karne lage. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Tab Mūsā aur Isrāīliyoṅ ne Rab ke lie yih gīt gāyā, “Maiṅ Rab kī tamjīd meṅ gīt gāūṅgā, kyoṅki wuh nihāyat azīm hai. Ghoṛe aur us ke sawār ko us ne samundar meṅ paṭaḳh diyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Rab merī quwwat aur merā gīt hai, wuh merī najāt ban gayā hai. Wuhī merā Ḳhudā hai, aur maiṅ us kī tārīf karūṅga. Wuhī mere bāp kā Ḳhudā hai, aur maiṅ us kī tāzīm karūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Rab sūrmā hai, Rab us kā nām hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Firaun ke rathoṅ aur fauj ko us ne samundar meṅ paṭaḳh diyā to bādshāh ke behtarīn afsarān Bahr-e-Qulzum meṅ ḍūb gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Gahre pānī ne unheṅ ḍhāṅk liyā, aur wuh patthar kī tarah samundar kī tah tak utar gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ai Rab, tere dahne hāth kā jalāl baṛī qudrat se zāhir hotā hai. Ai Rab, terā dahnā hāth dushman ko chaknāchūr kar detā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Jo tere ḳhilāf uṭh khaṛe hote haiṅ unheṅ tū apnī azmat kā izhār karke zamīn par paṭaḳh detā hai. Terā ġhazab un par ān paṛtā hai to wuh āg meṅ bhūse kī tarah jal jāte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Tū ne ġhusse meṅ ā kar phūṅk mārī to pānī ḍher kī sūrat meṅ jamā ho gayā. Bahtā pānī ṭhos dīwār ban gayā, samundar gahrāī tak jam gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Dushman ne ḍīṅg mār kar kahā, ‘Maiṅ un kā pīchhā karke unheṅ pakaṛ lūṅgā, maiṅ un kā lūṭā huā māl taqsīm karūṅga. Merī lālchī jān un se ser ho jāegī, maiṅ apnī talwār khīṅch kar unheṅ halāk karūṅga.’ ");
INSERT INTO urdgvr_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Lekin tū ne un par phūṅk mārī to samundar ne unheṅ ḍhāṅk liyā, aur wuh sīse kī tarah zordār maujoṅ meṅ ḍūb gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ai Rab, kaun-sā mābūd terī mānind hai? Kaun terī tarah jalālī aur quddūs hai? Kaun terī tarah hairatangez kām kartā aur azīm mojize dikhātā hai? Koī bhī nahīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Tū ne apnā dahnā hāth uṭhāyā to zamīn hamāre dushmanoṅ ko nigal gaī. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Apnī shafqat se tū ne ewazānā de kar apnī qaum ko chhuṭkārā diyā aur us kī rāhnumāī kī hai, apnī qudrat se tū ne use apnī muqaddas sukūnatgāh tak pahuṅchāyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Yih sun kar dīgar qaumeṅ kāṅp uṭhīṅ, Filistī ḍar ke māre pech-o-tāb khāne lage. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Adom ke ra'īs saham gae. Moāb ke rāhnumāoṅ par kapkapī tārī ho gaī, aur Kanān ke tamām bāshinde himmat hār gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Dahshat aur ḳhauf un par chhā gayā. Terī azīm qudrat ke bāis wuh patthar kī tarah jam gae. Ai Rab, wuh na hile jab tak terī qaum guzar na gaī. Wuh behis-o-harkat rahe jab tak terī ḳharīdī huī qaum guzar na gaī. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ai Rab, tū apne logoṅ ko le kar paudoṅ kī tarah apne maurūsī pahāṛ par lagāegā, us jagah par jo tū ne apnī sukūnat ke lie chun lī hai, jahāṅ tū ne apne hāthoṅ se apnā maqdis taiyār kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Rab abad tak Bādshāh hai!” ");
INSERT INTO urdgvr_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Jab Firaun ke ghoṛe, rath aur ghuṛsawār samundar meṅ chale gae to Rab ne unheṅ samundar ke pānī se ḍhāṅk liyā. Lekin Isrāīlī ḳhushk zamīn par samundar meṅ se guzar gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Tab Hārūn kī bahan Mariyam jo nabiyā thī ne daf liyā, aur bāqī tamām aurateṅ bhī daf le kar us ke pīchhe ho līṅ. Sab gāne aur nāchne lagīṅ. Mariyam ne yih gā kar un kī rāhnumāī kī, ");
INSERT INTO urdgvr_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","“Rab kī tamjīd meṅ gīt gāo, kyoṅki wuh nihāyat azīm hai. Ghoṛe aur us ke sawār ko us ne samundar meṅ paṭaḳh diyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Mūsā ke kahne par Isrāīlī Bahr-e-Qulzum se rawānā ho kar Dasht-e-Shūr meṅ chale gae. Wahāṅ wuh tīn din tak safr karte rahe. Is daurān unheṅ pānī na milā. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Āḳhirkār wuh Mārā pahuṅche jahāṅ pānī dastyāb thā. Lekin wuh kaṛwā thā, is lie maqām kā nām Mārā yānī Kaṛwāhaṭ paṛ gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Yih dekh kar log Mūsā ke ḳhilāf buṛbuṛā kar kahne lage, “Ham kyā pieṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mūsā ne madad ke lie Rab se iltijā kī to us ne use lakaṛī kā ek ṭukṛā dikhāyā. Jab Mūsā ne yih lakaṛī pānī meṅ ḍālī to pānī kī kaṛwāhaṭ ḳhatm ho gaī. Mārā meṅ Rab ne apnī qaum ko qawānīn die. Wahāṅ us ne unheṅ āzmāyā bhī. ");
INSERT INTO urdgvr_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Us ne kahā, “Ġhaur se Rab apne Ḳhudā kī āwāz suno! Jo kuchh us kī nazar meṅ durust hai wuhī karo. Us ke ahkām par dhyān do aur us kī tamām hidāyāt par amal karo. Phir maiṅ tum par wuh bīmāriyāṅ nahīṅ lāūṅgā jo Misriyoṅ par lāyā thā, kyoṅki maiṅ Rab hūṅ jo tujhe shafā detā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Phir Isrāīlī rawānā ho kar Elīm pahuṅche jahāṅ 12 chashme aur khajūr ke 70 daraḳht the. Wahāṅ unhoṅ ne pānī ke qarīb apne ḳhaime lagāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Is ke bād Isrāīl kī pūrī jamāt Elīm se safr karke Sīn ke registān meṅ pahuṅchī jo Elīm aur Sīnā ke darmiyān hai. Wuh Misr se nikalne ke bād dūsre mahīne ke 15weṅ din pahuṅche. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Registān meṅ tamām log phir Mūsā aur Hārūn ke ḳhilāf buṛbuṛāne lage. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Unhoṅ ne kahā, “Kāsh Rab hameṅ Misr meṅ hī mār ḍāltā! Wahāṅ ham kam az kam jī bhar kar gosht aur roṭī to khā sakte the. Āp hameṅ sirf is lie registān meṅ le āe haiṅ ki ham sab bhūke mar jāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Tab Rab ne Mūsā se kahā, “Maiṅ āsmān se tumhāre lie roṭī barsāūṅgā. Har roz log bāhar jā kar usī din kī zarūrat ke mutābiq khānā jamā kareṅ. Is se maiṅ unheṅ āzmā kar dekhūṅgā ki āyā wuh merī sunte haiṅ ki nahīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Har roz wuh sirf utnā khānā jamā kareṅ jitnā ki ek din ke lie kāfī ho. Lekin chhaṭe din jab wuh khānā taiyār kareṅge to wuh agle din ke lie bhī kāfī hogā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mūsā aur Hārūn ne Isrāīliyoṅ se kahā, “Āj shām ko tum jān loge ki Rab hī tumheṅ Misr se nikāl lāyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Aur kal subah tum Rab kā jalāl dekhoge. Us ne tumhārī shikāyateṅ sun lī haiṅ, kyoṅki asal meṅ tum hamāre ḳhilāf nahīṅ balki Rab ke ḳhilāf buṛbuṛā rahe ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Phir bhī Rab tum ko shām ke waqt gosht aur subah ke waqt wāfir roṭī degā, kyoṅki us ne tumhārī shikāyateṅ sun lī haiṅ. Tumhārī shikāyateṅ hamāre ḳhilāf nahīṅ balki Rab ke ḳhilāf haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mūsā ne Hārūn se kahā, “Isrāīliyoṅ ko batānā, ‘Rab ke sāmne hāzir ho jāo, kyoṅki us ne tumhārī shikāyateṅ sun lī haiṅ.’” ");
INSERT INTO urdgvr_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Jab Hārūn pūrī jamāt ke sāmne bāt karne lagā to logoṅ ne palaṭ kar registān kī taraf dekhā. Wahāṅ Rab kā jalāl bādal meṅ zāhir huā. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Maiṅ ne Isrāīliyoṅ kī shikāyat sun lī hai. Unheṅ batā, ‘Āj jab sūraj ġhurūb hone lagegā to tum gosht khāoge aur kal subah peṭ bhar kar roṭī. Phir tum jān loge ki maiṅ Rab tumhārā Ḳhudā hūṅ.’” ");
INSERT INTO urdgvr_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Usī shām baṭeroṅ ke ġhol āe jo pūrī ḳhaimāgāh par chhā gae. Aur aglī subah ḳhaime ke chāroṅ taraf os paṛī thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Jab os sūkh gaī to barf ke gāloṅ jaise patle dāne pāle kī tarah zamīn par paṛe the. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Jab Isrāīliyoṅ ne use dekhā to ek dūsre se pūchhne lage, “Man hū?” Yānī “Yih kyā hai?” Kyoṅki wuh nahīṅ jānte the ki yih kyā chīz hai. Mūsā ne un ko samjhāyā, “Yih wuh roṭī hai jo Rab ne tumheṅ khāne ke lie dī hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Rab kā hukm hai ki har ek utnā jamā kare jitnā us ke ḳhāndān ko zarūrat ho. Apne ḳhāndān ke har fard ke lie do liṭar jamā karo.” ");
INSERT INTO urdgvr_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Isrāīliyoṅ ne aisā hī kiyā. Bāz ne zyādā aur bāz ne kam jamā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Lekin jab use nāpā gayā to har ek ādmī ke lie kāfī thā. Jis ne zyādā jamā kiyā thā us ke pās kuchh na bachā. Lekin jis ne kam jamā kiyā thā us ke pās bhī kāfī thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mūsā ne hukm diyā, “Agle din ke lie khānā na bachānā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Lekin logoṅ ne Mūsā kī bāt na mānī balki bāz ne khānā bachā liyā. Lekin aglī subah mālūm huā ki bache hue khāne meṅ kīṛe paṛ gae haiṅ aur us se bahut badbū ā rahī hai. Yih sun kar Mūsā un se nārāz huā. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Har subah har koī utnā jamā kar letā jitnī use zarūrat hotī thī. Jab dhūp tez hotī to jo kuchh zamīn par rah jātā wuh pighal kar ḳhatm ho jātā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Chhaṭe din jab log yih ḳhurāk jamā karte to wuh miqdār meṅ dugnī hotī thī yānī har fard ke lie chār liṭar. Jab jamāt ke buzurgoṅ ne Mūsā ke pās ā kar use ittalā dī ");
INSERT INTO urdgvr_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","to us ne un se kahā, “Rab kā farmān hai ki kal ārām kā din hai, muqaddas Sabat kā din jo Allāh kī tāzīm meṅ manānā hai. Āj tum jo tanūr meṅ pakānā chāhte ho pakā lo aur jo ubālnā chāhte ho ubāl lo. Jo bach jāe use kal ke lie mahfūz rakho.” ");
INSERT INTO urdgvr_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Logoṅ ne Mūsā ke hukm ke mutābiq agle din ke lie khānā mahfūz kar liyā to na khāne se badbū āī, na us meṅ kīṛe paṛe. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mūsā ne kahā, “Āj yihī bachā huā khānā khāo, kyoṅki āj Sabat kā din hai, Rab kī tāzīm meṅ ārām kā din. Āj tumheṅ registān meṅ kuchh nahīṅ milegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Chhih din ke daurān yih ḳhurāk jamā karnā hai, lekin sātwāṅ din ārām kā din hai. Us din zamīn par khāne ke lie kuchh nahīṅ hogā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","To bhī kuchh log hafte ko khānā jamā karne ke lie nikle, lekin unheṅ kuchh na milā. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Tab Rab ne Mūsā se kahā, “Tum log kab tak mere ahkām aur hidāyāt par amal karne se inkār karoge? ");
INSERT INTO urdgvr_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Dekho, Rab ne tumhāre lie muqarrar kiyā hai ki Sabat kā din ārām kā din hai. Is lie wuh tumheṅ jume ko do din ke lie ḳhurāk detā hai. Hafte ko sab ko apne ḳhaimoṅ meṅ rahnā hai. Koī bhī apne ghar se bāhar na nikle.” ");
INSERT INTO urdgvr_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Chunāṅche log Sabat ke din ārām karte the. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isrāīliyoṅ ne is ḳhurāk kā nām ‘man’ rakhā. Us ke dāne dhanie kī mānind safed the, aur us kā zāyqā shahd se bane kek kī mānind thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mūsā ne kahā, “Rab farmātā hai, ‘Do liṭar man ek martabān meṅ rakh kar use āne wālī nasloṅ ke lie mahfūz rakhnā. Phir wuh dekh sakeṅge ki maiṅ tumheṅ kyā khānā khilātā rahā jab tumheṅ Misr se nikāl lāyā.’” ");
INSERT INTO urdgvr_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mūsā ne Hārūn se kahā, “Ek martabān lo aur use do liṭar man se bhar kar Rab ke sāmne rakho tāki wuh āne wālī nasloṅ ke lie mahfūz rahe.” ");
INSERT INTO urdgvr_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Hārūn ne aisā hī kiyā. Us ne man ke is martabān ko ahd ke sandūq ke sāmne rakhā tāki wuh mahfūz rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isrāīliyoṅ ko 40 sāl tak man miltā rahā. Wuh us waqt tak man khāte rahe jab tak registān se nikal kar Kanān kī sarhad par na pahuṅche. ");
INSERT INTO urdgvr_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Jo paimānā Isrāīlī man ke lie istemāl karte the wuh do liṭar kā ek bartan thā jis kā nām Omar thā.) ");
INSERT INTO urdgvr_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Phir Isrāīl kī pūrī jamāt Sīn ke registān se niklī. Rab jis tarah hukm detā rahā wuh ek jagah se dūsrī jagah safr karte rahe. Rafīdīm meṅ unhoṅ ne ḳhaime lagāe. Wahāṅ pīne ke lie pānī na milā. ");
INSERT INTO urdgvr_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Is lie wuh Mūsā ke sāth yih kah kar jhagaṛne lage, “Hameṅ pīne ke lie pānī do.” Mūsā ne jawāb diyā, “Tum mujh se kyoṅ jhagaṛ rahe ho? Rab ko kyoṅ āzmā rahe ho?” ");
INSERT INTO urdgvr_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Lekin log bahut pyāse the. Wuh Mūsā ke ḳhilāf buṛbuṛāne se bāz na āe balki kahā, “Āp hameṅ Misr se kyoṅ lāe haiṅ? Kyā is lie ki ham apne bachchoṅ aur rewaṛoṅ samet pyāse mar jāeṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Tab Mūsā ne Rab ke huzūr fariyād kī, “Maiṅ in logoṅ ke sāth kyā karūṅ? Hālāt zarā bhī aur bigaṛ jāeṅ to wuh mujhe sangsār kar deṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Rab ne Mūsā se kahā, “Kuchh buzurg sāth le kar logoṅ ke āge āge chal. Wuh lāṭhī bhī sāth le jā jis se tū ne Dariyā-e-Nīl ko mārā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Maiṅ Horib yānī Sīnā Pahāṛ kī ek chaṭṭān par tere sāmne khaṛā hūṅgā. Lāṭhī se chaṭṭān ko mārnā to us se pānī niklegā aur log pī sakeṅge.” Mūsā ne Isrāīl ke buzurgoṅ ke sāmne aisā hī kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Us ne us jagah kā nām Massā aur Marībā yānī ‘Āzmānā aur Jhagaṛnā’ rakhā, kyoṅki wahāṅ Isrāīlī buṛbuṛāe aur yih pūchh kar Rab ko āzmāyā ki kyā Rab hamāre darmiyān hai ki nahīṅ? ");
INSERT INTO urdgvr_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Rafīdīm wuh jagah bhī thī jahāṅ Amālīqī Isrāīliyoṅ se laṛne āe. ");
INSERT INTO urdgvr_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mūsā ne Yashua se kahā, “Laṛne ke qābil ādmiyoṅ ko chun lo aur nikal kar Amālīqiyoṅ kā muqābalā karo. Kal maiṅ Allāh kī lāṭhī pakaṛe hue pahāṛ kī choṭī par khaṛā ho jāūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yashua Mūsā kī hidāyat ke mutābiq Amālīqiyoṅ se laṛne gayā jabki Mūsā, Hārūn aur Hūr pahāṛ kī choṭī par chaṛh gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Aur yoṅ huā ki jab Mūsā ke hāth uṭhāe hue the to Isrāīlī jītte rahe, aur jab wuh nīche the to Amālīqī jītte rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Kuchh der ke bād Mūsā ke bāzū thak gae. Is lie Hārūn aur Hūr ek chaṭṭān le āe tāki wuh us par baiṭh jāe. Phir unhoṅ ne us ke dāīṅ aur bāīṅ taraf khaṛe ho kar us ke bāzuoṅ ko ūpar uṭhāe rakhā. Sūraj ke ġhurūb hone tak unhoṅ ne yoṅ Mūsā kī madad kī. ");
INSERT INTO urdgvr_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Is tarah Yashua ne Amālīqiyoṅ se laṛte laṛte unheṅ shikast dī. ");
INSERT INTO urdgvr_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Tab Rab ne Mūsā se kahā, “Yih wāqiyā yādgārī ke lie kitāb meṅ likh le. Lāzim hai ki yih sab kuchh Yashua kī yād meṅ rahe, kyoṅki maiṅ duniyā se Amālīqiyoṅ kā nām-o-nishān miṭā dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Us waqt Mūsā ne qurbāngāh banā kar us kā nām ‘Rab Merā Jhanḍā Hai’ rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Us ne kahā, “Rab ke taḳht ke ḳhilāf hāth uṭhāyā gayā hai, is lie Rab kī Amālīqiyoṅ se hameshā tak jang rahegī.” ");
INSERT INTO urdgvr_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Mūsā kā susar Yitro ab tak Midiyān meṅ imām thā. Jab us ne sab kuchh sunā jo Allāh ne Mūsā aur apnī qaum ke lie kiyā hai, ki wuh unheṅ Misr se nikāl lāyā hai ");
INSERT INTO urdgvr_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","to wuh Mūsā ke pās āyā. Wuh us kī bīwī Saffūrā ko apne sāth lāyā, kyoṅki Mūsā ne use apne beṭoṅ samet maike bhej diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Yitro Mūsā ke donoṅ beṭoṅ ko bhī sāth lāyā. Pahle beṭe kā nām Jairsom yānī ‘Ajnabī Mulk meṅ Pardesī’ thā, kyoṅki jab wuh paidā huā to Mūsā ne kahā thā, “Maiṅ ajnabī mulk meṅ pardesī hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Dūsre beṭe kā nām Iliyazar yānī ‘Merā Ḳhudā Madadgār Hai’ thā, kyoṅki jab wuh paidā huā to Mūsā ne kahā thā, “Mere bāp ke Ḳhudā ne merī madad karke mujhe Firaun kī talwār se bachāyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yitro Mūsā kī bīwī aur beṭe sāth le kar us waqt Mūsā ke pās pahuṅchā jab us ne registān meṅ Allāh ke pahāṛ yānī Sīnā ke qarīb ḳhaimā lagāyā huā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Us ne Mūsā ko paiġhām bhejā thā, “Maiṅ, āp kā susar Yitro āp kī bīwī aur do beṭoṅ ko sāth le kar āp ke pās ā rahā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mūsā apne susar ke istiqbāl ke lie bāhar niklā, us ke sāmne jhukā aur use bosā diyā. Donoṅ ne ek dūsre kā hāl pūchhā, phir ḳhaime meṅ chale gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mūsā ne Yitro ko tafsīl se batāyā ki Rab ne Isrāīliyoṅ kī ḳhātir Firaun aur Misriyoṅ ke sāth kyā kuchh kiyā hai. Us ne rāste meṅ pesh āī tamām mushkilāt kā zikr bhī kiyā ki Rab ne hameṅ kis tarah un se bachāyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yitro un sāre achchhe kāmoṅ ke bāre meṅ sun kar ḳhush huā jo Rab ne Isrāīliyoṅ ke lie kie the jab us ne unheṅ Misriyoṅ ke hāth se bachāyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Us ne kahā, “Rab kī tamjīd ho jis ne āp ko Misriyoṅ aur Firaun ke qabze se najāt dilāī hai. Usī ne qaum ko ġhulāmī se chhuṛāyā hai! ");
INSERT INTO urdgvr_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ab maiṅ ne jān liyā hai ki Rab tamām mābūdoṅ se azīm hai, kyoṅki us ne yih sab kuchh un logoṅ ke sāth kiyā jinhoṅ ne apne ġhurūr meṅ Isrāīliyoṅ ke sāth burā sulūk kiyā thā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Phir Yitro ne Allāh ko bhasm hone wālī qurbānī aur dīgar kaī qurbāniyāṅ pesh kīṅ. Tab Hārūn aur tamām buzurg Mūsā ke susar Yitro ke sāth Allāh ke huzūr khānā khāne baiṭhe. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Agle din Mūsā logoṅ kā insāf karne ke lie baiṭh gayā. Un kī tādād itnī zyādā thī ki wuh subah se le kar shām tak Mūsā ke sāmne khaṛe rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Jab Yitro ne yih sab kuchh dekhā to us ne pūchhā, “Yih kyā hai jo āp logoṅ ke sāth kar rahe haiṅ? Sārā din wuh āp ko ghere rahte aur āp un kī adālat karte rahte haiṅ. Āp yih sab kuchh akele hī kyoṅ kar rahe haiṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mūsā ne jawāb diyā, “Log mere pās ā kar Allāh kī marzī mālūm karte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Jab kabhī koī tanāzā yā jhagaṛā hotā hai to donoṅ pārṭiyāṅ mere pās ātī haiṅ. Maiṅ faislā karke unheṅ Allāh ke ahkām aur hidāyāt batātā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Mūsā ke susar ne us se kahā, “Āp kā tarīqā achchhā nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Kām itnā wasī hai ki āp use akele nahīṅ saṅbhāl sakte. Is se āp aur wuh log jo āp ke pās āte haiṅ burī tarah thak jāte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Merī bāt suneṅ! Maiṅ āp ko ek mashwarā detā hūṅ. Allāh us meṅ āp kī madad kare. Lāzim hai ki āp Allāh ke sāmne qaum ke numāindā raheṅ aur un ke muāmalāt us ke sāmne pesh kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Yih bhī zarūrī hai ki āp unheṅ Allāh ke ahkām aur hidāyāt sikhāeṅ, ki wuh kis tarah zindagī guzāreṅ aur kyā kyā kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Lekin sāth sāth qaum meṅ se qābil-e-etamād ādmī chuneṅ. Wuh aise log hoṅ jo Allāh kā ḳhauf mānte hoṅ, rāstdil hoṅ aur rishwat se nafrat karte hoṅ. Unheṅ hazār hazār, sau sau, pachās pachās aur das das ādmiyoṅ par muqarrar kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Un ādmiyoṅ kī zimmedārī yih hogī ki wuh har waqt logoṅ kā insāf kareṅ. Agar koī bahut hī pechīdā muāmalā ho to wuh faisle ke lie āp ke pās āeṅ, lekin dīgar muāmaloṅ kā faislā wuh ḳhud kareṅ. Yoṅ wuh kām meṅ āp kā hāth baṭāeṅge aur āp kā bojh halkā ho jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Agar merā yih mashwarā Allāh kī marzī ke mutābiq ho aur āp aisā kareṅ to āp apnī zimmedārī nibhā sakeṅge aur yih tamām log insāf ke milne par salāmatī ke sāth apne apne ghar jā sakeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mūsā ne apne susar kā mashwarā mān liyā aur aisā hī kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Us ne Isrāīliyoṅ meṅ se qābil-e-etamād ādmī chune aur unheṅ hazār hazār, sau sau, pachās pachās aur das das ādmiyoṅ par muqarrar kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Yih mard qāzī ban kar mustaqil taur par logoṅ kā insāf karne lage. Āsān masloṅ kā faislā wuh ḳhud karte aur mushkil muāmaloṅ ko Mūsā ke pās le āte the. ");
INSERT INTO urdgvr_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Kuchh arse bād Mūsā ne apne susar ko ruḳhsat kiyā to Yitro apne watan wāpas chalā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Isrāīliyoṅ ko Misr se safr karte hue do mahīne ho gae the. Tīsre mahīne ke pahle hī din wuh Sīnā ke registān meṅ pahuṅche. ");
INSERT INTO urdgvr_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Us din wuh Rafīdīm ko chhoṛ kar Dasht-e-Sīnā meṅ ā pahuṅche. Wahāṅ unhoṅ ne registān meṅ pahāṛ ke qarīb ḍere ḍāle. ");
INSERT INTO urdgvr_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Tab Mūsā pahāṛ par chaṛh kar Allāh ke pās gayā. Allāh ne pahāṛ par se Mūsā ko pukār kar kahā, “Yāqūb ke gharāne banī Isrāīl ko batā, ");
INSERT INTO urdgvr_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Tum ne dekhā hai ki maiṅ ne Misriyoṅ ke sāth kyā kuchh kiyā, aur ki maiṅ tum ko uqāb ke paroṅ par uṭhā kar yahāṅ apne pās lāyā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Chunāṅche agar tum merī suno aur mere ahd ke mutābiq chalo to phir tamām qaumoṅ meṅ se merī ḳhās milkiyat hoge. Go pūrī duniyā merī hī hai, ");
INSERT INTO urdgvr_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","lekin tum mere lie maḳhsūs imāmoṅ kī bādshāhī aur muqaddas qaum hoge.’ Ab jā kar yih sārī bāteṅ Isrāīliyoṅ ko batā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mūsā ne pahāṛ se utar kar aur qaum ke buzurgoṅ ko bulā kar unheṅ wuh tamām bāteṅ batāīṅ jo kahne ke lie Rab ne use hukm diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Jawāb meṅ pūrī qaum ne mil kar kahā, “Ham Rab kī har bāt pūrī kareṅge jo us ne farmāī hai.” Mūsā ne pahāṛ par lauṭ kar Rab ko qaum kā jawāb batāyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Jab wuh pahuṅchā to Rab ne Mūsā se kahā, “Maiṅ ghane bādal meṅ tere pās āūṅgā tāki log mujhe tujh se hamkalām hote hue suneṅ. Phir wuh hameshā tujh par bharosā rakheṅge.” Tab Mūsā ne Rab ko wuh tamām bāteṅ batāīṅ jo logoṅ ne kī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Rab ne Mūsā se kahā, “Ab logoṅ ke pās lauṭ kar āj aur kal unheṅ mere lie maḳhsūs-o-muqaddas kar. Wuh apne libās dho kar ");
INSERT INTO urdgvr_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","tīsre din ke lie taiyār ho jāeṅ, kyoṅki us din Rab logoṅ ke deḳhte deḳhte Koh-e-Sīnā par utregā. ");
INSERT INTO urdgvr_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Logoṅ kī hifāzat ke lie chāroṅ taraf pahāṛ kī haddeṅ muqarrar kar. Unheṅ ḳhabardār kar ki hudūd ko pār na karo. Na pahāṛ par chaṛho, na us ke dāman ko chhuo. Jo bhī use chhue wuh zarūr mārā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Aur use hāth se chhū kar nahīṅ mārnā hai balki pattharoṅ yā tīroṅ se. Ḳhāh insān ho yā haiwān, wuh zindā nahīṅ rah saktā. Jab tak narsingā der tak phūṅkā na jāe us waqt tak logoṅ ko pahāṛ par chaṛhne kī ijāzat nahīṅ hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mūsā ne pahāṛ se utar kar logoṅ ko Allāh ke lie maḳhsūs-o-muqaddas kiyā. Unhoṅ ne apne libās bhī dhoe. ");
INSERT INTO urdgvr_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Us ne un se kahā, “Tīsre din ke lie taiyār ho jāo. Mard auratoṅ se hambistar na hoṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Tīsre din subah pahāṛ par ghanā bādal chhā gayā. Bijlī chamakne lagī, bādal garajne lagā aur narsinge kī nihāyat zordār āwāz sunāī dī. Ḳhaimāgāh meṅ log laraz uṭhe. ");
INSERT INTO urdgvr_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Tab Mūsā logoṅ ko Allāh se milne ke lie ḳhaimāgāh se bāhar pahāṛ kī taraf le gayā, aur wuh pahāṛ ke dāman meṅ khaṛe hue. ");
INSERT INTO urdgvr_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Sīnā Pahāṛ dhueṅ se ḍhakā huā thā, kyoṅki Rab āg meṅ us par utar āyā. Pahāṛ se dhuāṅ is tarah uṭh rahā thā jaise kisī bhaṭṭe se uṭhtā hai. Pūrā pahāṛ shiddat se larazne lagā. ");
INSERT INTO urdgvr_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Narsinge kī āwāz tez se teztar hotī gaī. Mūsā bolne lagā aur Allāh use ūṅchī āwāz meṅ jawāb detā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Rab Sīnā Pahāṛ kī choṭī par utrā aur Mūsā ko ūpar āne ke lie kahā. Mūsā ūpar chaṛhā. ");
INSERT INTO urdgvr_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Rab ne Mūsā se kahā, “Fauran nīche utar kar logoṅ ko ḳhabardār kar ki wuh mujhe deḳhne ke lie pahāṛ kī hudūd meṅ zabardastī dāḳhil na hoṅ. Agar wuh aisā kareṅ to bahut-se halāk ho jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Imām bhī jo Rab ke huzūr āte haiṅ apne āp ko maḳhsūs-o-muqaddas kareṅ, warnā merā ġhazab un par ṭūṭ paṛegā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Lekin Mūsā ne Rab se kahā, “Log pahāṛ par nahīṅ ā sakte, kyoṅki tū ne ḳhud hī hameṅ ḳhabardār kiyā ki ham pahāṛ kī haddeṅ muqarrar karke use maḳhsūs-o-muqaddas kareṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Rab ne jawāb diyā, “To bhī utar jā aur Hārūn ko sāth le kar wāpas ā. Lekin imāmoṅ aur logoṅ ko mat āne de. Agar wuh zabardastī mere pās āeṅ to merā ġhazab un par ṭūṭ paṛegā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mūsā ne logoṅ ke pās utar kar unheṅ yih bāteṅ batā dīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Tab Allāh ne yih tamām bāteṅ farmāīṅ, ");
INSERT INTO urdgvr_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Maiṅ Rab terā Ḳhudā hūṅ jo tujhe Mulk-e-Misr kī ġhulāmī se nikāl lāyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Mere siwā kisī aur mābūd kī parastish na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Apne lie but na banānā. Kisī bhī chīz kī mūrat na banānā, chāhe wuh āsmān meṅ, zamīn par yā samundar meṅ ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Na butoṅ kī parastish, na un kī ḳhidmat karnā, kyoṅki maiṅ terā Rab ġhayūr Ḳhudā hūṅ. Jo mujh se nafrat karte haiṅ unheṅ maiṅ tīsrī aur chauthī pusht tak sazā dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Lekin jo mujh se muhabbat rakhte aur mere ahkām pūre karte haiṅ un par maiṅ hazār pushtoṅ tak mehrbānī karūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Rab apne Ḳhudā kā nām bemaqsad yā ġhalat maqsad ke lie istemāl na karnā. Jo bhī aisā kartā hai use Rab sazā die baġhair nahīṅ chhoṛegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Sabat ke din kā ḳhayāl rakhnā. Use is tarah manānā ki wuh maḳhsūs-o-muqaddas ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Hafte ke pahle chhih din apnā kām-kāj kar, ");
INSERT INTO urdgvr_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","lekin sātwāṅ din Rab tere Ḳhudā kā ārām kā din hai. Us din kisī tarah kā kām na karnā. Na tū, na terā beṭā, na terī beṭī, na terā naukar, na terī naukarānī aur na tere maweshī. Jo pardesī tere darmiyān rahtā hai wuh bhī kām na kare. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Kyoṅki Rab ne pahle chhih din meṅ āsmān-o-zamīn, samundar aur jo kuchh un meṅ hai banāyā lekin sātweṅ din ārām kiyā. Is lie Rab ne Sabat ke din ko barkat de kar muqarrar kiyā ki wuh maḳhsūs aur muqaddas ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Apne bāp aur apnī māṅ kī izzat karnā. Phir tū us mulk meṅ jo Rab terā Ḳhudā tujhe dene wālā hai der tak jītā rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Qatl na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Zinā na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Chorī na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Apne paṛosī ke bāre meṅ jhūṭī gawāhī na denā. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Apne paṛosī ke ghar kā lālach na karnā. Na us kī bīwī kā, na us ke naukar kā, na us kī naukarānī kā, na us ke bail aur na us ke gadhe kā balki us kī kisī bhī chīz kā lālach na karnā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Jab bāqī tamām logoṅ ne bādal kī garaj aur narsinge kī āwāz sunī aur bijlī kī chamak aur pahāṛ se uṭhte hue dhueṅ ko dekhā to wuh ḳhauf ke māre kāṅpne lage aur pahāṛ se dūr khaṛe ho gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Unhoṅ ne Mūsā se kahā, “Āp hī ham se bāt kareṅ to ham suneṅge. Lekin Allāh ko ham se bāt na karne deṅ warnā ham mar jāeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Lekin Mūsā ne un se kahā, “Mat ḍaro, kyoṅki Rab tumheṅ jāṅchne ke lie āyā hai, tāki us kā ḳhauf tumhārī āṅkhoṅ ke sāmne rahe aur tum gunāh na karo.” ");
INSERT INTO urdgvr_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Log dūr hī rahe jabki Mūsā us gahrī tārīkī ke qarīb gayā jahāṅ Allāh thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Tab Rab ne Mūsā se kahā, “Isrāīliyoṅ ko batā, ‘Tum ne ḳhud dekhā ki maiṅ ne āsmān par se tumhāre sāth bāteṅ kī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Chunāṅche merī parastish ke sāth sāth apne lie sone yā chāṅdī ke but na banāo. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Mere lie miṭṭī kī qurbāngāh banā kar us par apnī bheṛ-bakriyoṅ aur gāy-bailoṅ kī bhasm hone wālī aur salāmatī kī qurbāniyāṅ chaṛhānā. Maiṅ tujhe wuh jagheṅ dikhāūṅgā jahāṅ mere nām kī tāzīm meṅ qurbāniyāṅ pesh karnī haiṅ. Aisī tamām jaghoṅ par maiṅ tere pās ā kar tujhe barkat dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Agar tū mere lie qurbāngāh banāne kī ḳhātir patthar istemāl karnā chāhe to tarāshe hue patthar istemāl na karnā. Kyoṅki tū tarāshne ke lie istemāl hone wāle auzār se us kī behurmatī karegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Qurbāngāh ko sīṛhiyoṅ ke baġhair banānā hai tāki us par chaṛhne se tere libās ke nīche se terā nangāpan nazar na āe.’ ");
INSERT INTO urdgvr_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Isrāīliyoṅ ko yih ahkām batā, ");
INSERT INTO urdgvr_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","‘Agar tū Ibrānī ġhulām ḳharīde to wuh chhih sāl terā ġhulām rahe. Is ke bād lāzim hai ki use āzād kar diyā jāe. Āzād hone ke lie use paise dene kī zarūrat nahīṅ hogī. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Agar ġhulām ġhairshādīshudā hālat meṅ mālik ke ghar āyā ho to wuh āzād ho kar akelā hī chalā jāe. Agar wuh shādīshudā hālat meṅ āyā ho to lāzim hai ki wuh apnī bīwī samet āzād ho kar jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Agar mālik ne ġhulām kī shādī karāī aur bachche paidā hue haiṅ to us kī bīwī aur bachche mālik kī milkiyat hoṅge. Chhih sāl ke bād jab ġhulām āzād ho kar jāe to us kī bīwī aur bachche mālik hī ke pās raheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Agar ġhulām kahe, “Maiṅ apne mālik aur apne bīwī bachchoṅ se muhabbat rakhtā hūṅ, maiṅ āzād nahīṅ honā chāhtā” ");
INSERT INTO urdgvr_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","to ġhulām kā mālik use Allāh ke sāmne lāe. Wuh use darwāze yā us kī chaukhaṭ ke pās le jāe aur sutālī yānī tez auzār se us ke kān kī lau chhed de. Tab wuh zindagī-bhar us kā ġhulām banā rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Agar koī apnī beṭī ko ġhulāmī meṅ bech ḍāle to us ke lie āzādī milne kī sharāyt mard se farq haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Agar us ke mālik ne use muntaḳhab kiyā ki wuh us kī bīwī ban jāe, lekin bād meṅ wuh use pasand na āe to lāzim hai ki wuh munāsib muāwazā le kar use us ke rishtedāroṅ ko wāpas kar de. Use aurat ko ġhairmulkiyoṅ ke hāth bechne kā iḳhtiyār nahīṅ hai, kyoṅki us ne us ke sāth bewafā sulūk kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Agar launḍī kā mālik us kī apne beṭe ke sāth shādī karāe to aurat ko beṭī ke huqūq hāsil hoṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Agar mālik ne us se shādī karke bād meṅ dūsrī aurat se bhī shādī kī to lāzim hai ki wuh pahlī ko bhī khānā aur kapṛe detā rahe. Is ke alāwā us ke sāth hambistar hone kā farz bhī adā karnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Agar wuh yih tīn farāyz adā na kare to use aurat ko āzād karnā paṛegā. Is sūrat meṅ use muft āzād karnā hogā. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Jo kisī ko jān-būjh kar itnā saḳht mārtā ho ki wuh mar jāe to use zarūr sazā-e-maut denā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Lekin agar us ne use jān-būjh kar na mārā balki yih ittafāq se huā aur Allāh ne yih hone diyā, to mārne wālā ek aisī jagah panāh le saktā hai jo maiṅ muqarrar karūṅga. Wahāṅ use qatl kie jāne kī ijāzat nahīṅ hogī. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Lekin jo dīdā-dānistā aur chālākī se kisī ko mār ḍāltā hai use merī qurbāngāh se bhī chhīn kar sazā-e-maut denā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Jo apne bāp yā apnī māṅ ko mārtā pīṭtā hai use sazā-e-maut dī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Jis ne kisī ko aġhwā kar liyā hai use sazā-e-maut dī jāe, chāhe wuh use ġhulām banā kar bech chukā ho yā use ab tak apne pās rakhā huā ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Jo apne bāp yā māṅ par lānat kare use sazā-e-maut dī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Ho saktā hai ki ādmī jhagaṛeṅ aur ek shaḳhs dūsre ko patthar yā mukke se itnā zaḳhmī kar de ki go wuh bach jāe wuh bistar se uṭh na saktā ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Agar bād meṅ marīz yahāṅ tak shafā pāe ki dubārā uṭh kar lāṭhī ke sahāre chal-phir sake to choṭ pahuṅchāne wāle ko sazā nahīṅ milegī. Use sirf us waqt ke lie muāwazā denā paṛegā jab tak marīz paise na kamā sake. Sāth hī use us kā pūrā ilāj karwānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Jo apne ġhulām yā launḍī ko lāṭhī se yoṅ māre ki wuh mar jāe use sazā dī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Lekin agar ġhulām yā launḍī piṭāī ke bād ek yā do din zindā rahe to mālik ko sazā na dī jāe. Kyoṅki jo raqam us ne us ke lie dī thī us kā nuqsān use ḳhud uṭhānā paṛegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Ho saktā hai ki log āpas meṅ laṛ rahe hoṅ aur laṛte laṛte kisī hāmilā aurat se yoṅ ṭakrā jāeṅ ki us kā bachchā zāe ho jāe. Agar koī aur nuqsān na huā ho to zarb pahuṅchāne wāle ko jurmānā denā paṛegā. Aurat kā shauhar yih jurmānā muqarrar kare, aur adālat meṅ is kī tasdīq ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Lekin agar us aurat ko aur nuqsān bhī pahuṅchā ho to phir zarb pahuṅchāne wāle ko is usūl ke mutābiq sazā dī jāe ki jān ke badle jān, ");
INSERT INTO urdgvr_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","āṅkh ke badle āṅkh, dāṅt ke badle dāṅt, hāth ke badle hāth, pāṅw ke badle pāṅw, ");
INSERT INTO urdgvr_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","jalne ke zaḳhm ke badle jalne kā zaḳhm, mār ke badle mār, kāṭ ke badle kāṭ. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Agar koī mālik apne ġhulām kī āṅkh par yoṅ māre ki wuh zāe ho jāe to use ġhulām ko āṅkh ke badle āzād karnā paṛegā, chāhe ġhulām mard ho yā aurat. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Agar mālik ke pīṭne se ġhulām kā dāṅt ṭūṭ jāe to use ġhulām ko dāṅt ke badle āzād karnā paṛegā, chāhe ġhulām mard ho yā aurat. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Agar koī bail kisī mard yā aurat ko aisā māre ki wuh mar jāe to us bail ko sangsār kiyā jāe. Us kā gosht khāne kī ijāzat nahīṅ hai. Is sūrat meṅ bail ke mālik ko sazā na dī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Lekin ho saktā hai ki mālik ko pahle āgāh kiyā gayā thā ki bail logoṅ ko mārtā hai, to bhī us ne bail ko khulā chhoṛā thā jis ke natīje meṅ us ne kisī ko mār ḍālā. Aisī sūrat meṅ na sirf bail ko balki us ke mālik ko bhī sangsār karnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Lekin agar faislā kiyā jāe ki wuh apnī jān kā fidyā de to jitnā muāwazā bhī muqarrar kiyā jāe use denā paṛegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Sazā meṅ koī farq nahīṅ hai, chāhe beṭe ko mārā jāe yā beṭī ko. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Lekin agar bail kisī ġhulām yā launḍī ko mār de to us kā mālik ġhulām ke mālik ko chāṅdī ke 30 sikke de aur bail ko sangsār kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Ho saktā hai ki kisī ne apne hauz ko khulā rahne diyā yā hauz banāne ke lie gaṛhā khod kar use khulā rahne diyā aur koī bail yā gadhā us meṅ gir kar mar gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Aisī sūrat meṅ hauz kā mālik murdā jānwar ke lie paise de. Wuh jānwar ke mālik ko us kī pūrī qīmat adā kare aur murdā jānwar ḳhud le le. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Agar kisī kā bail kisī dūsre ke bail ko aise māre ki wuh mar jāe to donoṅ mālik zindā bail ko bech kar us ke paise āpas meṅ barābar bāṅṭ leṅ. Isī tarah wuh murdā bail ko bhī barābar taqsīm kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Lekin ho saktā hai ki mālik ko mālūm thā ki merā bail dūsre jānwaroṅ par hamlā kartā hai, is ke bāwujūd us ne use āzād chhoṛ diyā thā. Aisī sūrat meṅ use murdā bail ke ewaz us ke mālik ko nayā bail denā paṛegā, aur wuh murdā bail ḳhud le le. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Jis ne koī bail yā bheṛ chorī karke use zabah kiyā yā bech ḍālā hai use har chorī ke bail ke ewaz pāṅch bail aur har chorī kī bheṛ ke ewaz chār bheṛeṅ wāpas karnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Ho saktā hai ki koī chor naqb lagā rahā ho aur log use pakaṛ kar yahāṅ tak mārte pīṭte raheṅ ki wuh mar jāe. Agar rāt ke waqt aisā huā ho to wuh us ke ḳhūn ke zimmedār nahīṅ ṭhahar sakte. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Lekin agar sūraj ke tulū hone ke bād aisā huā ho to jis ne use mārā wuh qātil ṭhahregā. Chor ko har churāī huī chīz kā ewazānā denā hai. Agar us ke pās dene ke lie kuchh na ho to use ġhulām banā kar bechnā hai. Jo paise use bechne ke ewaz mileṅ wuh churāī huī chīzoṅ ke badle meṅ die jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Agar chorī kā jānwar chor ke pās zindā pāyā jāe to use har jānwar ke ewaz do dene paṛeṅge, chāhe wuh bail, bheṛ, bakrī yā gadhā ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ho saktā hai ki koī apne maweshī ko apne khet yā angūr ke bāġh meṅ chhoṛ kar charne de aur hote hote wuh kisī dūsre ke khet yā angūr ke bāġh meṅ jā kar charne lage. Aisī sūrat meṅ lāzim hai ki maweshī kā mālik nuqsān ke ewaz apne angūr ke bāġh aur khet kī behtarīn paidāwār meṅ se de. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ho saktā hai ki kisī ne āg jalāī ho aur wuh kāṅṭedār jhāṛiyoṅ ke zariye paṛosī ke khet tak phail kar us ke anāj ke pūloṅ ko, us kī pakī huī fasal ko yā khet kī kisī aur paidāwār ko barbād kar de. Aisī sūrat meṅ jis ne āg jalāī ho use us kī pūrī qīmat adā karnī hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ho saktā hai ki kisī ne kuchh paise yā koī aur māl apne kisī wāqifkār ke sapurd kar diyā ho tāki wuh use mahfūz rakhe. Agar yih chīzeṅ us ke ghar se chorī ho jāeṅ aur bād meṅ chor ko pakaṛā jāe to chor ko us kī dugnī qīmat adā karnī paṛegī. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Lekin agar chor pakaṛā na jāe to lāzim hai ki us ghar kā mālik jis ke sapurd yih chīzeṅ kī gaī thīṅ Allāh ke huzūr khaṛā ho tāki mālūm kiyā jāe ki us ne ḳhud yih māl chorī kiyā hai yā nahīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ho saktā hai ki do logoṅ kā āpas meṅ jhagaṛā ho, aur donoṅ kisī chīz ke bāre meṅ dāwā karte hoṅ ki yih merī hai. Agar koī qīmtī chīz ho masalan bail, gadhā, bheṛ, bakrī, kapṛe yā koī khoī huī chīz to muāmalā Allāh ke huzūr lāyā jāe. Jise Allāh qusūrwār qarār de use dūsre ko zer-e-bahs chīz kī dugnī qīmat adā karnī hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Ho saktā hai ki kisī ne apnā koī gadhā, bail, bheṛ, bakrī yā koī aur jānwar kisī wāqifkār ke sapurd kar diyā tāki wuh use mahfūz rakhe. Wahāṅ jānwar mar jāe yā zaḳhmī ho jāe, yā koī us par qabzā karke use us waqt le jāe jab koī na dekh rahā ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Yih muāmalā yoṅ hal kiyā jāe ki jis ke sapurd jānwar kiyā gayā thā wuh Rab ke huzūr qasam khā kar kahe ki maiṅ ne apne wāqifkār ke jānwar ke lālach meṅ yih kām nahīṅ kiyā. Jānwar ke mālik ko yih qabūl karnā paṛegā, aur dūsre ko is ke badle kuchh nahīṅ denā hogā. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Lekin agar wāqaī jānwar ko chorī kiyā gayā hai to jis ke sapurd jānwar kiyā gayā thā use us kī qīmat adā karnī paṛegī. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Agar kisī janglī jānwar ne use phāṛ ḍālā ho to wuh sabūt ke taur par phāṛī huī lāsh ko le āe. Phir use us kī qīmat adā nahīṅ karnī paṛegī. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Ho saktā hai ki koī apne wāqifkār se ijāzat le kar us kā jānwar istemāl kare. Agar jānwar ko mālik kī ġhairmaujūdagī meṅ choṭ lage yā wuh mar jāe to us shaḳhs ko jis ke pās jānwar us waqt thā us kā muāwazā denā paṛegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Lekin agar jānwar kā mālik us waqt sāth thā to dūsre ko muāwazā dene kī zarūrat nahīṅ hogī. Agar us ne jānwar ko kirāe par liyā ho to us kā nuqsān kirāe se pūrā ho jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Agar kisī kuṅwārī kī mangnī nahīṅ huī aur koī mard use warġhalā kar us se hambistar ho jāe to wuh mahr de kar us se shādī kare. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Lekin agar laṛkī kā bāp us kī us mard ke sāth shādī karne se inkār kare, is sūrat meṅ bhī mard ko kuṅwārī ke lie muqarrarā raqam denī paṛegī. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Jādūgarnī ko jīne na denā. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Jo shaḳhs kisī jānwar ke sāth jinsī tālluqāt rakhtā ho use sazā-e-maut dī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Jo na sirf Rab ko qurbāniyāṅ pesh kare balki dīgar mābūdoṅ ko bhī use qaum se nikāl kar halāk kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Jo pardesī tere mulk meṅ mehmān hai use na dabānā aur na us se burā sulūk karnā, kyoṅki tum bhī Misr meṅ pardesī the. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Kisī bewā yā yatīm se burā sulūk na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Agar tū aisā kare aur wuh chillā kar mujh se fariyād kareṅ to maiṅ zarūr un kī sunūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Maiṅ baṛe ġhusse meṅ ā kar tumheṅ talwār se mār ḍālūṅgā. Phir tumhārī bīwiyāṅ ḳhud bewāeṅ aur tumhāre bachche ḳhud yatīm ban jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Agar tū ne merī qaum ke kisī ġharīb ko qarz diyā hai to us se sūd na lenā. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Agar tujhe kisī se us kī chādar girwī ke taur par milī ho to use sūraj ḍūbne se pahle hī wāpas kar denā hai, ");
INSERT INTO urdgvr_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","kyoṅki isī ko wuh sone ke lie istemāl kartā hai. Warnā wuh kyā chīz oṛh kar soegā? Agar tū chādar wāpas na kare aur wuh shaḳhs chillā kar mujh se fariyād kare to maiṅ us kī sunūṅgā, kyoṅki maiṅ mehrbān hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Allāh ko na kosnā, na apnī qaum ke kisī sardār par lānat karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Mujhe waqt par apne khet aur kolhuoṅ kī paidāwār meṅ se nazarāne pesh karnā. Apne pahlauṭhe mujhe denā. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Apne bailoṅ, bheṛoṅ aur bakriyoṅ ke pahlauṭhoṅ ko bhī mujhe denā. Jānwar kā pahlauṭhā pahle sāt din apnī māṅ ke sāth rahe. Āṭhweṅ din wuh mujhe diyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Apne āp ko mere lie maḳhsūs-o-muqaddas rakhnā. Is lie aise jānwar kā gosht mat khānā jise kisī janglī jānwar ne phāṛ ḍālā hai. Aise gosht ko kuttoṅ ko khāne denā. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Ġhalat afwāheṅ na phailānā. Kisī sharīr ādmī kā sāth de kar jhūṭī gawāhī denā manā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Agar aksariyat ġhalat kām kar rahī ho to us ke pīchhe na ho lenā. Adālat meṅ gawāhī dete waqt aksariyat ke sāth mil kar aisī bāt na karnā jis se ġhalat faislā kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Lekin adālat meṅ kisī ġharīb kī tarafdārī bhī na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Agar tujhe tere dushman kā bail yā gadhā āwārā phirtā huā nazar āe to use har sūrat meṅ wāpas kar denā. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Agar tujh se nafrat karne wāle kā gadhā bojh tale gir gayā ho aur tujhe patā lage to use na chhoṛnā balki zarūr us kī madad karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Adālat meṅ ġharīb ke huqūq na mārnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Aise muāmale se dūr rahnā jis meṅ log jhūṭ bolte haiṅ. Jo begunāh aur haq par hai use sazā-e-maut na denā, kyoṅki maiṅ qusūrwār ko haq bajānib nahīṅ ṭhahrāūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Rishwat na lenā, kyoṅki rishwat deḳhne wāle ko andhā kar detī hai aur us kī bāt banane nahīṅ detī jo haq par hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Jo pardesī tere mulk meṅ mehmān hai us par dabāw na ḍālnā. Tum aise logoṅ kī hālat se ḳhūb wāqif ho, kyoṅki tum ḳhud Misr meṅ pardesī rahe ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Chhih sāl tak apnī zamīn meṅ bīj bo kar us kī paidāwār jamā karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Lekin sātweṅ sāl zamīn ko istemāl na karnā balki use paṛe rahne denā. Jo kuchh bhī uge wuh qaum ke ġharīb log khāeṅ. Jo un se bach jāe use janglī jānwar khāeṅ. Apne angūr aur zaitūn ke bāġhoṅ ke sāth bhī aisā hī karnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Chhih din apnā kām-kāj karnā, lekin sātweṅ din ārām karnā. Phir terā bail aur terā gadhā bhī ārām kar sakeṅge, terī launḍī kā beṭā aur tere sāth rahne wālā pardesī bhī tāzādam ho jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Jo bhī hidāyat maiṅ ne dī hai us par amal kar. Dīgar mābūdoṅ kī parastish na karnā. Maiṅ tere muṅh se un ke nāmoṅ tak kā zikr na sunūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Sāl meṅ tīn dafā merī tāzīm meṅ īd manānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Pahle, Beḳhamīrī Roṭī kī Īd manānā. Abīb ke mahīne meṅ sāt din tak terī roṭī meṅ ḳhamīr na ho jis tarah maiṅ ne hukm diyā hai, kyoṅki is mahīne meṅ tū Misr se niklā. In dinoṅ meṅ koī mere huzūr ḳhālī hāth na āe. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Dūsre, Faslkaṭāī kī Īd us waqt manānā jab tū apne khet meṅ boī huī pahlī fasal kāṭegā. Tīsre, Jamā Karne kī Īd fasal kī kaṭāī ke iḳhtitām par manānā hai jab tū ne angūr aur bāqī bāġhoṅ ke phal jamā kie hoṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Yoṅ tere tamām mard tīn martabā Rab Qādir-e-mutlaq ke huzūr hāzir huā kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Jab tū kisī jānwar ko zabah karke qurbānī ke taur par pesh kare to us ke ḳhūn ke sāth aisī roṭī pesh na karnā jis meṅ ḳhamīr ho. Aur jo jānwar tū merī īdoṅ par chaṛhāe un kī charbī aglī subah tak bāqī na rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Apnī zamīn kī pahlī paidāwār kā behtarīn hissā Rab apne Ḳhudā ke ghar meṅ lānā. Bheṛ yā bakrī ke bachche ko us kī māṅ ke dūdh meṅ na pakānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Maiṅ tere āge āge farishtā bhejtā hūṅ jo rāste meṅ terī hifāzat karegā aur tujhe us jagah tak le jāegā jo maiṅ ne tere lie taiyār kī hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Us kī maujūdagī meṅ ehtiyāt baratnā. Us kī sunanā, aur us kī ḳhilāfwarzī na karnā. Agar tū sarkash ho jāe to wuh tujhe muāf nahīṅ karegā, kyoṅki merā nām us meṅ hāzir hogā. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Lekin agar tū us kī sune aur sab kuchh kare jo maiṅ tujhe batātā hūṅ to maiṅ tere dushmanoṅ kā dushman aur tere muḳhālifoṅ kā muḳhālif hūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Kyoṅki merā farishtā tere āge āge chalegā aur tujhe Mulk-e-Kanān tak pahuṅchā degā jahāṅ Amorī, Hittī, Farizzī, Kanānī, Hiwwī aur Yabūsī ābād haiṅ. Tab maiṅ unheṅ rū-e-zamīn par se miṭā dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Un ke mābūdoṅ ko sijdā na karnā, na un kī ḳhidmat karnā. Un ke rasm-o-riwāj bhī na apnānā balki un ke butoṅ ko tabāh kar denā. Jin satūnoṅ ke sāmne wuh ibādat karte haiṅ un ko bhī ṭukṛe ṭukṛe kar ḍālnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Rab apne Ḳhudā kī ḳhidmat karnā. Phir maiṅ terī ḳhurāk aur pānī ko barkat de kar tamām bīmāriyāṅ tujh se dūr karūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Phir tere mulk meṅ na kisī kā bachchā zāe hogā, na koī bāṅjh hogī. Sāth hī maiṅ tujhe tawīl zindagī atā karūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Maiṅ tere āge āge dahshat phailāūṅgā. Jahāṅ bhī tū jāegā wahāṅ maiṅ tamām qaumoṅ meṅ abtarī paidā karūṅga. Mere sabab se tere sāre dushman palaṭ kar bhāg jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Maiṅ tere āge zambūr bhej dūṅgā jo Hiwwī, Kanānī aur Hittī ko mulk chhoṛne par majbūr kareṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Lekin jab tū wahāṅ pahuṅchegā to maiṅ unheṅ ek hī sāl meṅ mulk se nahīṅ nikālūṅgā. Warnā pūrā mulk wīrān ho jāegā aur janglī jānwar phail kar tere lie nuqsān kā bāis ban jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Is lie maiṅ tere pahuṅchne par mulk ke bāshindoṅ ko thoṛā thoṛā karke nikāltā jāūṅgā. Itne meṅ terī tādād baṛhegī aur tū raftā raftā mulk par qabzā kar sakegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Maiṅ terī sarhaddeṅ muqarrar karūṅga. Bahr-e-Qulzum ek had hogī aur Filistiyoṅ kā samundar dūsrī, junūb kā registān ek hogī aur Dariyā-e-Furāt dūsrī. Maiṅ mulk ke bāshindoṅ ko tere qabze meṅ kar dūṅgā, aur tū unheṅ apne āge āge mulk se dūr kartā jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Lāzim hai ki tū un ke sāth yā un ke mābūdoṅ ke sāth ahd na bāndhe. ");
INSERT INTO urdgvr_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Un kā tere mulk meṅ rahnā manā hai, warnā tū un ke sabab se merā gunāh karegā. Agar tū un ke mābūdoṅ kī ibādat karegā to yih tere lie phandā ban jāegā.’” ");
INSERT INTO urdgvr_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Rab ne Mūsā se kahā, “Tū, Hārūn, Nadab, Abīhū aur Isrāīl ke 70 buzurg mere pās ūpar āeṅ. Kuchh fāsile par khaṛe ho kar mujhe sijdā karo. ");
INSERT INTO urdgvr_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Sirf tū akelā hī mere qarīb ā, dūsre dūr raheṅ. Aur qaum ke bāqī log tere sāth pahāṛ par na chaṛheṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Tab Mūsā ne qaum ke pās jā kar Rab kī tamām bāteṅ aur ahkām pesh kie. Jawāb meṅ sab ne mil kar kahā, “Ham Rab kī in tamām bātoṅ par amal kareṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Tab Mūsā ne Rab kī tamām bāteṅ likh līṅ. Agle din wuh subah-sawere uṭhā aur pahāṛ ke pās gayā. Us ke dāman meṅ us ne qurbāngāh banāī. Sāth hī us ne Isrāīl ke har ek qabīle ke lie ek ek patthar kā satūn khaṛā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Phir us ne kuchh Isrāīlī naujawānoṅ ko qurbānī pesh karne ke lie bulāyā tāki wuh Rab kī tāzīm meṅ bhasm hone wālī qurbāniyāṅ chaṛhāeṅ aur jawān bailoṅ ko salāmatī kī qurbānī ke taur par pesh kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mūsā ne qurbāniyoṅ kā ḳhūn jamā kiyā. Us kā ādhā hissā us ne bāsanoṅ meṅ ḍāl diyā aur ādhā hissā qurbāngāh par chhiṛak diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Phir us ne wuh kitāb lī jis meṅ Rab ke sāth ahd kī tamām sharāyt darj thīṅ aur use qaum ko paṛh kar sunāyā. Jawāb meṅ unhoṅ ne kahā, “Ham Rab kī in tamām bātoṅ par amal kareṅge. Ham us kī suneṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Is par Mūsā ne bāsanoṅ meṅ se ḳhūn le kar use logoṅ par chhiṛkā aur kahā, “Yih ḳhūn us ahd kī tasdīq kartā hai jo Rab ne tumhāre sāth kiyā hai aur jo us kī tamām bātoṅ par mabnī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Is ke bād Mūsā, Hārūn, Nadab, Abīhū aur Isrāīl ke 70 buzurg Sīnā Pahāṛ par chaṛhe. ");
INSERT INTO urdgvr_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Wahāṅ unhoṅ ne Isrāīl ke Ḳhudā ko dekhā. Lagtā thā ki us ke pāṅwoṅ ke nīche sang-e-lājaward kā-sā taḳhtā thā. Wuh āsmān kī mānind sāf-o-shaffāf thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Agarche Isrāīl ke rāhnumāoṅ ne yih sab kuchh dekhā to bhī Rab ne unheṅ halāk na kiyā, balki wuh Allāh ko deḳhte rahe aur us ke huzūr ahd kā khānā khāte aur pīte rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Pahāṛ se utarne ke bād Rab ne Mūsā se kahā, “Mere pās pahāṛ par ā kar kuchh der ke lie ṭhahre rahnā. Maiṅ tujhe patthar kī taḳhtiyāṅ dūṅgā jin par maiṅ ne apnī sharīat aur ahkām likhe haiṅ aur jo Isrāīl kī tālīm-o-tarbiyat ke lie zarūrī haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mūsā apne madadgār Yashua ke sāth chal paṛā aur Allāh ke pahāṛ par chaṛh gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Pahle us ne buzurgoṅ se kahā, “Hamārī wāpasī ke intazār meṅ yahāṅ ṭhahre raho. Hārūn aur Hūr tumhāre pās raheṅge. Koī bhī muāmalā ho to log unhīṅ ke pās jāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Jab Mūsā chaṛhne lagā to pahāṛ par bādal chhā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Rab kā jalāl Koh-e-Sīnā par utar āyā. Chhih din tak bādal us par chhāyā rahā. Sātweṅ din Rab ne bādal meṅ se Mūsā ko bulāyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Rab kā jalāl Isrāīliyoṅ ko bhī nazar ātā thā. Unheṅ yoṅ lagā jaisā ki pahāṛ kī choṭī par tez āg bhaṛak rahī ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Chaṛhte chaṛhte Mūsā bādal meṅ dāḳhil huā. Wahāṅ wuh chālīs din aur chālīs rāt rahā. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Isrāīliyoṅ ko batā ki wuh hadiye lā kar mujhe uṭhāne wālī qurbānī ke taur par pesh kareṅ. Lekin sirf un se hadiye qabūl karo jo dilī ḳhushī se deṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Un se yih chīzeṅ hadiye ke taur par qabūl karo: sonā, chāṅdī, pītal; ");
INSERT INTO urdgvr_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","nīle, arġhawānī aur qirmizī rang kā dhāgā, bārīk katān, bakrī ke bāl, ");
INSERT INTO urdgvr_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","menḍhoṅ kī surḳh rangī huī khāleṅ, taḳhas kī khāleṅ, kīkar kī lakaṛī, ");
INSERT INTO urdgvr_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","shamādān ke lie zaitūn kā tel, masah karne ke lie tel aur ḳhushbūdār baḳhūr ke lie masāle, ");
INSERT INTO urdgvr_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","aqīq-e-ahmar aur dīgar jawāhar jo imām-e-āzam ke bālāposh aur sīne ke kīse meṅ jaṛe jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","In chīzoṅ se log mere lie maqdis banāeṅ tāki maiṅ un ke darmiyān rahūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Maiṅ tujhe maqdis aur us ke tamām sāmān kā namūnā dikhāūṅgā, kyoṅki tumheṅ sab kuchh ain usī ke mutābiq banānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","12","Log kīkar kī lakaṛī kā sandūq banāeṅ. Us kī lambāī paune chār fuṭ ho jabki us kī chauṛāī aur ūṅchāī sawā do do fuṭ ho. Pūre sandūq par andar aur bāhar se ḳhālis sonā chaṛhānā. Ūpar kī satah ke irdgird sone kī jhālar lagānā. Sandūq ko uṭhāne ke lie sone ke chār kaṛe ḍhāl kar unheṅ sandūq ke chārpāiyoṅ par lagānā. Donoṅ taraf do do kaṛe hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Phir kīkar kī do lakaṛiyāṅ sandūq ko uṭhāne ke lie taiyār karnā. Un par sonā chaṛhā kar ");
INSERT INTO urdgvr_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","un ko donoṅ taraf ke kaṛoṅ meṅ ḍālnā tāki un se sandūq ko uṭhāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Yih lakaṛiyāṅ sandūq ke in kaṛoṅ meṅ paṛī raheṅ. Unheṅ kabhī bhī dūr na kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Sandūq meṅ sharīat kī wuh do taḳhtiyāṅ rakhnā jo maiṅ tujhe dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Sandūq kā ḍhaknā ḳhālis sone kā banānā. Us kī lambāī paune chār fuṭ aur chauṛāī sawā do fuṭ ho. Us kā nām kaffāre kā ḍhaknā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","Sone se ghaṛ kar do karūbī farishte banāe jāeṅ jo ḍhakne ke donoṅ siroṅ par khaṛe hoṅ. Yih do farishte aur ḍhaknā ek hī ṭukṛe se banāne haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Farishtoṅ ke par yoṅ ūpar kī taraf phaile hue hoṅ ki wuh ḍhakne ko panāh deṅ. Un ke muṅh ek dūsre kī taraf kie hue hoṅ, aur wuh ḍhakne kī taraf dekheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ḍhakne ko sandūq par lagā, aur sandūq meṅ sharīat kī wuh do taḳhtiyāṅ rakh jo maiṅ tujhe dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Wahāṅ ḍhakne ke ūpar donoṅ farishtoṅ ke darmiyān se maiṅ apne āp ko tujh par zāhir karke tujh se hamkalām hūṅgā aur tujhe Isrāīliyoṅ ke lie tamām ahkām dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Kīkar kī lakaṛī kī mez banānā. Us kī lambāī tīn fuṭ, chauṛāī ḍeṛh fuṭ aur ūṅchāī sawā do fuṭ ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Us par ḳhālis sonā chaṛhānā, aur us ke irdgird sone kī jhālar lagānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Mez kī ūpar kī satah par chaukhaṭā lagānā jis kī ūṅchāī tīn inch ho aur jis par sone kī jhālar lagī ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Sone ke chār kaṛe ḍhāl kar unheṅ chāroṅ konoṅ par lagānā jahāṅ mez ke pāe lage haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Yih kaṛe mez kī satah par lage chaukhaṭe ke nīche lagāe jāeṅ. Un meṅ wuh lakaṛiyāṅ ḍālnī haiṅ jin se mez ko uṭhāyā jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Yih lakaṛiyāṅ bhī kīkar kī hoṅ aur un par sonā chaṛhāyā jāe. Un se mez ko uṭhānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Us ke thāl, pyāle, martabān aur mai kī nazareṅ pesh karne ke bartan ḳhālis sone se banānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Mez par wuh roṭiyāṅ har waqt mere huzūr paṛī raheṅ jo mere lie maḳhsūs haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Ḳhālis sone kā shamādān bhī banānā. Us kā pāyā aur ḍanḍī ghaṛ kar banānā hai. Us kī pyāliyāṅ jo phūloṅ aur kaliyoṅ kī shakl kī hoṅgī pāe aur ḍanḍī ke sāth ek hī ṭukṛā hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Ḍanḍī se dāīṅ aur bāīṅ taraf tīn tīn shāḳheṅ nikleṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Har shāḳh par tīn pyāliyāṅ lagī hoṅ jo bādām kī kaliyoṅ aur phūloṅ kī shakl kī hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Shamādān kī ḍanḍī par bhī is qism kī pyāliyāṅ lagī hoṅ, lekin tādād meṅ chār. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","In meṅ se tīn pyāliyāṅ dāeṅ bāeṅ kī chhih shāḳhoṅ ke nīche lagī hoṅ. Wuh yoṅ lagī hoṅ ki har pyālī se do shāḳheṅ nikleṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Shāḳheṅ aur pyāliyāṅ balki pūrā shamādān ḳhālis sone ke ek hī ṭukṛe se ghaṛ kar banānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Shamādān ke lie sāt charāġh banā kar unheṅ yoṅ shāḳhoṅ par rakhnā ki wuh sāmne kī jagah raushan kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Battī katarne kī qainchiyāṅ aur jalte koele ke lie chhoṭe bartan bhī ḳhālis sone se banāe jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Shamādān aur us sāre sāmān ke lie pūre 34 kilogrām ḳhālis sonā istemāl kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ġhaur kar ki sab kuchh ain us namūne ke mutābiq banāyā jāe jo maiṅ tujhe yahāṅ pahāṛ par dikhātā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Muqaddas ḳhaime ke lie das parde banānā. Un ke lie bārīk katān aur nīle, arġhawānī aur qirmizī rang kā dhāgā istemāl karnā. Pardoṅ meṅ kisī māhir kārīgar ke kaṛhāī ke kām se karūbī farishtoṅ kā ḍizāyn banwānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Har parde kī lambāī 42 fuṭ aur chauṛāī 6 fuṭ ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Pāṅch pardoṅ ke lambe hāshie ek dūsre ke sāth joṛe jāeṅ aur isī tarah bāqī pāṅch bhī. Yoṅ do baṛe ṭukṛe ban jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Donoṅ ṭukṛoṅ ko ek dūsre ke sāth milāne ke lie nīle dhāge ke halqe banānā. Yih halqe har ṭukṛe ke 42 fuṭ wāle ek kināre par lagāe jāeṅ, ");
INSERT INTO urdgvr_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ek ṭukṛe ke hāshie par 50 halqe aur dūsre par bhī utne hī halqe. In do hāshiyoṅ ke halqe ek dūsre ke āmne-sāmne hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Phir sone kī 50 hukeṅ banā kar un se āmne-sāmne ke halqe ek dūsre ke sāth milānā. Yoṅ donoṅ ṭukṛe juṛ kar ḳhaime kā kām deṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Bakrī ke bāloṅ se bhī 11 parde banānā jinheṅ kapṛe wāle ḳhaime ke ūpar rakhā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Har parde kī lambāī 45 fuṭ aur chauṛāī 6 fuṭ ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Pāṅch pardoṅ ke lambe hāshie ek dūsre ke sāth joṛe jāeṅ aur isī tarah bāqī chhih bhī. In chhih pardoṅ ke chhaṭe parde ko ek dafā tah karnā. Yih sāmne wāle hisse se laṭke. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Bakrī ke bāl ke in donoṅ ṭukṛoṅ ko bhī milānā hai. Is ke lie har ṭukṛe ke 45 fuṭ wāle ek kināre par pachās pachās halqe lagānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Phir pītal kī 50 hukeṅ banā kar un se donoṅ hisse milānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Jab bakriyoṅ ke bāloṅ kā yih ḳhaimā kapṛe ke ḳhaime ke ūpar lagāyā jāegā to ādhā pardā bāqī rahegā. Wuh ḳhaime kī pichhlī taraf laṭkā rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ḳhaime ke dāīṅ aur bāīṅ taraf bakrī ke bāloṅ kā ḳhaimā kapṛe ke ḳhaime kī nisbat ḍeṛh ḍeṛh fuṭ lambā hogā. Yoṅ wuh donoṅ taraf laṭke hue kapṛe ke ḳhaime ko mahfūz rakhegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ek dūsre ke ūpar ke in donoṅ ḳhaimoṅ kī hifāzat ke lie do ġhilāf banāne haiṅ. Bakrī ke bāloṅ ke ḳhaime par menḍhoṅ kī surḳh rangī huī khāleṅ joṛ kar rakhī jāeṅ aur un par taḳhas kī khāleṅ milā kar rakhī jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Kīkar kī lakaṛī ke taḳhte banānā jo khaṛe kie jāeṅ tāki ḳhaime kī dīwāroṅ kā kām deṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Har taḳhte kī ūṅchāī 15 fuṭ ho aur chauṛāī sawā do fuṭ. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Har taḳhte ke nīche do do chūleṅ hoṅ. Yih chūleṅ har taḳhte ko us ke pāiyoṅ ke sāth joṛeṅgī tāki taḳhtā khaṛā rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ḳhaime kī junūbī dīwār ke lie 20 taḳhtoṅ kī zarūrat hai ");
INSERT INTO urdgvr_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","aur sāth hī chāṅdī ke 40 pāiyoṅ kī. Un par taḳhte khaṛe kie jāeṅge. Har taḳhte ke nīche do pāe hoṅge, aur har pāe meṅ ek chūl lagegī. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Isī tarah ḳhaime kī shimālī dīwār ke lie bhī 20 taḳhtoṅ kī zarūrat hai ");
INSERT INTO urdgvr_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","aur sāth hī chāṅdī ke 40 pāiyoṅ kī. Wuh bhī taḳhtoṅ ko khaṛā karne ke lie haiṅ. Har taḳhte ke nīche do pāe hoṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ḳhaime kī pichhlī yānī maġhribī dīwār ke lie chhih taḳhte banānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Is dīwār ko shimālī aur junūbī dīwāroṅ ke sāth joṛne ke lie kone wāle do taḳhte banānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","In do taḳhtoṅ meṅ nīche se le kar ūpar tak konā ho tāki ek se shimālī dīwār maġhribī dīwār ke sāth juṛ jāe aur dūsre se junūbī dīwār maġhribī dīwār ke sāth. In ke ūpar ke sire kaṛoṅ se mazbūt kie jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Yoṅ pichhle yānī maġhribī taḳhtoṅ kī pūrī tādād 8 hogī aur in ke lie chāṅdī ke pāiyoṅ kī tādād 16, har taḳhte ke nīche do do pāe hoṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","27","Is ke alāwā kīkar kī lakaṛī ke shahtīr banānā, tīnoṅ dīwāroṅ ke lie pāṅch pāṅch shahtīr. Wuh har dīwār ke taḳhtoṅ par yoṅ lagāe jāeṅ ki wuh unheṅ ek dūsre ke sāth milāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Darmiyānī shahtīr dīwār kī ādhī ūṅchāī par dīwār ke ek sire se dūsre sire tak lagāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Shahtīroṅ ko taḳhtoṅ ke sāth lagāne ke lie sone ke kaṛe banā kar taḳhtoṅ meṅ lagānā. Tamām taḳhtoṅ aur shahtīroṅ par sonā chaṛhānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Pūre muqaddas ḳhaime ko usī namūne ke mutābiq banānā jo maiṅ tujhe pahāṛ par dikhātā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Ab ek aur pardā banānā. Is ke lie bhī bārīk katān aur nīle, arġhawānī aur qirmizī rang kā dhāgā istemāl karnā. Us par bhī kisī māhir kārīgar ke kaṛhāī ke kām se karūbī farishtoṅ kā ḍizāyn banwānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ise sone kī hukoṅ se kīkar kī lakaṛī ke chār satūnoṅ se laṭkānā. In satūnoṅ par sonā chaṛhāyā jāe aur wuh chāṅdī ke pāiyoṅ par khaṛe hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Yih pardā Muqaddas Kamre ko Muqaddastarīn Kamre se alag karegā jis meṅ ahd kā sandūq paṛā rahegā. Parde ko laṭkāne ke bād us ke pīchhe Muqaddastarīn Kamre meṅ ahd kā sandūq rakhnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Phir ahd ke sandūq par kaffāre kā ḍhaknā rakhnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Jis mez par mere lie maḳhsūs kī gaī roṭiyāṅ paṛī rahtī haiṅ wuh parde ke bāhar Muqaddas Kamre meṅ shimāl kī taraf rakhī jāe. Us ke muqābil junūb kī taraf shamādān rakhā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Phir ḳhaime ke darwāze ke lie bhī pardā banāyā jāe. Is ke lie bhī bārīk katān aur nīle, arġhawānī aur qirmizī rang kā dhāgā istemāl kiyā jāe. Is par kaṛhāī kā kām kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Is parde ko sone kī hukoṅ se kīkar kī lakaṛī ke pāṅch satūnoṅ se laṭkānā. In satūnoṅ par bhī sonā chaṛhāyā jāe, aur wuh pītal ke pāiyoṅ par khaṛe hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Kīkar kī lakaṛī kī qurbāngāh banānā. Us kī ūṅchāī sāṛhe chār fuṭ ho jabki us kī lambāī aur chauṛāī sāṛhe sāt sāt fuṭ ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Us ke ūpar chāroṅ konoṅ meṅ se ek ek sīṅg nikle. Sīṅg aur qurbāngāh ek hī ṭukṛe ke hoṅ. Sab par pītal chaṛhānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Us kā tamām sāz-o-sāmān aur bartan bhī pītal ke hoṅ yānī rākh ko uṭhā kar le jāne kī bālṭiyāṅ, belche, kāṅṭe, jalte hue koele ke lie bartan aur chhiṛkāw ke kaṭore. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Qurbāngāh ko uṭhāne ke lie pītal kā janglā banānā jo ūpar se khulā ho. Jangle ke chāroṅ konoṅ par kaṛe lagāe jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Qurbāngāh kī ādhī ūṅchāī par kinārā lagānā, aur qurbāngāh ko jangle meṅ is kināre tak rakhā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Use uṭhāne ke lie kīkar kī do lakaṛiyāṅ banānā jin par pītal chaṛhānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Un ko qurbāngāh ke donoṅ taraf ke kaṛoṅ meṅ ḍāl denā. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Pūrī qurbāngāh lakaṛī kī ho, lekin andar se khokhlī ho. Use ain us namūne ke mutābiq banānā jo maiṅ tujhe pahāṛ par dikhātā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Muqaddas ḳhaime ke lie sahan banānā. Us kī chārdīwārī bārīk katān ke kapṛe se banāī jāe. Chārdīwārī kī lambāī junūb kī taraf 150 fuṭ ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Kapṛe ko chāṅdī kī hukoṅ aur paṭṭiyoṅ se lakaṛī ke 20 khamboṅ ke sāth lagāyā jāe. Har khambā pītal ke pāe par khaṛā ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Chārdīwārī shimāl kī taraf bhī isī kī mānind ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ḳhaime ke pīchhe maġhrib kī taraf chārdīwārī kī chauṛāī 75 fuṭ ho aur kapṛā lakaṛī ke 10 khamboṅ ke sāth lagāyā jāe. Yih khambe bhī pītal ke pāiyoṅ par khaṛe hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Sāmne, mashriq kī taraf jahāṅ se sūraj tulū hotā hai chārdīwārī kī chauṛāī bhī 75 fuṭ ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Yahāṅ chārdīwārī kā darwāzā ho. Kapṛā darwāze ke dāīṅ taraf sāṛhe 22 fuṭ chauṛā ho aur us ke bāīṅ taraf bhī utnā hī chauṛā. Use donoṅ taraf tīn tīn lakaṛī ke khamboṅ ke sāth lagāyā jāe jo pītal ke pāiyoṅ par khaṛe hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Darwāze kā pardā 30 fuṭ chauṛā banānā. Wuh nīle, arġhawānī aur qirmizī rang ke dhāge aur bārīk katān se banāyā jāe, aur us par kaṛhāī kā kām ho. Yih kapṛā lakaṛī ke chār khamboṅ ke sāth lagāyā jāe. Wuh bhī pītal ke pāiyoṅ par khaṛe hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Tamām khambe pītal ke pāiyoṅ par khaṛe hoṅ aur kapṛā chāṅdī kī hukoṅ aur paṭṭiyoṅ se har khambe ke sāth lagāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Chārdīwārī kī lambāī 150 fuṭ, chauṛāī 75 fuṭ aur ūṅchāī sāṛhe 7 fuṭ ho. Khamboṅ ke tamām pāe pītal ke hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Jo bhī sāz-o-sāmān muqaddas ḳhaime meṅ istemāl kiyā jātā hai wuh sab pītal kā ho. Ḳhaime aur chārdīwārī kī meḳheṅ bhī pītal kī hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Isrāīliyoṅ ko hukm denā ki wuh tere pās kūṭe hue zaitūnoṅ kā ḳhālis tel lāeṅ tāki Muqaddas Kamre ke shamādān ke charāġh mutawātir jalte raheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Hārūn aur us ke beṭe shamādān ko mulāqāt ke ḳhaime ke Muqaddas Kamre meṅ rakheṅ, us parde ke sāmne jis ke pīchhe ahd kā sandūq hai. Us meṅ wuh tel ḍālte raheṅ tāki wuh Rab ke sāmne shām se le kar subah tak jaltā rahe. Isrāīliyoṅ kā yih usūl abad tak qāym rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Apne bhāī Hārūn aur us ke beṭoṅ Nadab, Abīhū, Iliyazar aur Itamar ko bulā. Maiṅ ne unheṅ Isrāīliyoṅ meṅ se chun liyā hai tāki wuh imāmoṅ kī haisiyat se merī ḳhidmat kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Apne bhāī Hārūn ke lie muqaddas libās banwānā jo purwaqār aur shāndār hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Libās banāne kī zimmedārī un tamām logoṅ ko denā jo aise kāmoṅ meṅ māhir haiṅ aur jin ko maiṅ ne hikmat kī rūh se bhar diyā hai. Kyoṅki jab Hārūn ko maḳhsūs kiyā jāegā aur wuh muqaddas ḳhaime kī ḳhidmat saranjām degā to use in kapṛoṅ kī zarūrat hogī. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Us ke lie yih libās banāne haiṅ: sīne kā kīsā, bālāposh, choġhā, bunā huā zerjāmā, pagaṛī aur kamarband. Yih kapṛe apne bhāī Hārūn aur us ke beṭoṅ ke lie banwāne haiṅ tāki wuh imām ke taur par ḳhidmat kar sakeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","In kapṛoṅ ke lie sonā aur nīle, arġhawānī aur qirmizī rang kā dhāgā aur bārīk katān istemāl kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Bālāposh ko bhī sone aur nīle, arġhawānī aur qirmizī rang ke dhāge aur bārīk katān se banānā hai. Us par kisī māhir kārīgar se kaṛhāī kā kām karwāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Us kī do paṭṭiyāṅ hoṅ jo kandhoṅ par rakh kar sāmne aur pīchhe se bālāposh ke sāth lagī hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Is ke alāwā ek paṭkā bunanā hai jis se bālāposh ko bāndhā jāe aur jo bālāposh ke sāth ek ṭukṛā ho. Us ke lie bhī sonā, nīle, arġhawānī aur qirmizī rang kā dhāgā aur bārīk katān istemāl kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Phir aqīq-e-ahmar ke do patthar chun kar un par Isrāīl ke bārah beṭoṅ ke nām kandā karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Har jauhar par chhih chhih nām un kī paidāish kī tartīb ke mutābiq kandā kie jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Yih nām us tarah jauharoṅ par kandā kie jāeṅ jis tarah muhr kandā kī jātī hai. Phir donoṅ jauhar sone ke ḳhānoṅ meṅ jaṛ kar ");
INSERT INTO urdgvr_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","bālāposh kī do paṭṭiyoṅ par aise lagānā ki kandhoṅ par ā jāeṅ. Jab Hārūn mere huzūr āegā to jauharoṅ par ke yih nām us ke kandhoṅ par hoṅge aur mujhe Isrāīliyoṅ kī yād dilāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Sone ke ḳhāne banānā ");
INSERT INTO urdgvr_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","aur ḳhālis sone kī do zanjīreṅ jo ḍorī kī tarah gundhī huī hoṅ. Phir in do zanjīroṅ ko sone ke ḳhānoṅ ke sāth lagānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Sīne ke lie kīsā banānā. Us meṅ wuh qur'e paṛe raheṅ jin kī mārifat merī marzī mālūm kī jāegī. Māhir kārīgar use unhīṅ chīzoṅ se banāe jin se Hārūn kā bālāposh banāyā gayā hai yānī sone aur nīle, arġhawānī aur qirmizī rang ke dhāge aur bārīk katān se. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Jab kapṛe ko ek dafā tah kiyā gayā ho to kīse kī lambāī aur chauṛāī nau nau inch ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Us par chār qatāroṅ meṅ jawāhar jaṛnā. Har qatār meṅ tīn tīn jauhar hoṅ. Pahlī qatār meṅ lāl, zabarjad aur zumurrad. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Dūsrī meṅ fīrozā, sang-e-lājaward aur hajrul-qamar. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","tīsrī meṅ zarqon, aqīq aur yāqūt-e-arġhawānī. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","chauthī meṅ pukhrāj, aqīq-e-ahmar aur yashab. har jauhar sone ke ḳhāne meṅ jaṛā huā ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Yih bārah jawāhar Isrāīl ke bārah qabīloṅ kī numāindagī karte haiṅ. Ek ek jauhar par ek qabīle kā nām kandā kiyā jāe. Yih nām us tarah kandā kie jāeṅ jis tarah muhr kandā kī jātī hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Sīne ke kīse par ḳhālis sone kī do zanjīreṅ lagānā jo ḍorī kī tarah gundhī huī hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Unheṅ lagāne ke lie do kaṛe banā kar kīse ke ūpar ke do konoṅ par lagānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ab donoṅ zanjīreṅ un do kaṛoṅ se lagānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Un ke dūsre sire bālāposh kī kandhoṅ wālī paṭṭiyoṅ ke do ḳhānoṅ ke sāth joṛ denā, phir sāmne kī taraf lagānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Kīse ke nichle do konoṅ par bhī sone ke do kaṛe lagānā. Wuh andar, bālāposh kī taraf lage hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ab do aur kaṛe banā kar bālāposh kī kandhoṅ wālī paṭṭiyoṅ par lagānā. Yih bhī sāmne kī taraf lage hoṅ lekin nīche, bālāposh ke paṭke ke ūpar hī. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Sīne ke kīse ke nichle kaṛe nīlī ḍorī se bālāposh ke in nichle kaṛoṅ ke sāth bāndhe jāeṅ. Yoṅ kīsā paṭke ke ūpar achchhī tarah sīne ke sāth lagā rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Jab bhī Hārūn maqdis meṅ dāḳhil ho kar Rab ke huzūr āegā wuh Isrāīlī qabīloṅ ke nām apne dil par sīne ke kīse kī sūrat meṅ sāth le jāegā. Yoṅ wuh qaum kī yād dilātā rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Sīne ke kīse meṅ donoṅ qur'e banām Ūrīm aur Tummīm rakhe jāeṅ. Wuh bhī maqdis meṅ Rab ke sāmne āte waqt Hārūn ke dil par hoṅ. Yoṅ jab Hārūn Rab ke huzūr hogā to Rab kī marzī pūchhne kā wasīlā hameshā us ke dil par hogā. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Choġhā bhī bunanā. Wuh pūrī tarah nīle dhāge se banāyā jāe. Choġhe ko bālāposh se pahle pahnā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Us ke garebān ko bune hue kālar se mazbūt kiyā jāe tāki wuh na phaṭe. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Nīle, arġhawānī aur qirmizī rang ke dhāge se anār banā kar unheṅ choġhe ke dāman meṅ lagā denā. Un ke darmiyān sone kī ghanṭiyāṅ lagānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Dāman meṅ anār aur ghanṭiyāṅ bārī bārī lagānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Hārūn ḳhidmat karte waqt hameshā choġhā pahne. Jab wuh maqdis meṅ Rab ke huzūr āegā aur wahāṅ se niklegā to ghanṭiyāṅ sunāī deṅgī. Phir wuh nahīṅ maregā. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Ḳhālis sone kī taḳhtī banā kar us par yih alfāz kandā karnā, ‘Rab ke lie Maḳhsūs-o-Muqaddas.’ Yih alfāz yoṅ kandā kie jāeṅ jis tarah muhr kandā kī jātī hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Use nīlī ḍorī se pagaṛī ke sāmne wāle hisse se lagāyā jāe ");
INSERT INTO urdgvr_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","tāki wuh Hārūn ke māthe par paṛī rahe. Jab bhī wuh maqdis meṅ jāe to yih taḳhtī sāth ho. Jab Isrāīlī apne nazarāne lā kar Rab ke lie maḳhsūs kareṅ lekin kisī ġhaltī ke bāis qusūrwār hoṅ to un kā yih qusūr Hārūn par muntaqil hogā. Is lie yih taḳhtī har waqt us ke māthe par ho tāki Rab Isrāīliyoṅ ko qabūl kar le. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Zerjāme ko bārīk katān se bunanā aur is tarah pagaṛī bhī. Phir kamarband banānā. Us par kaṛhāī kā kām kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Hārūn ke beṭoṅ ke lie bhī zerjāme, kamarband aur pagaṛiyāṅ banānā tāki wuh purwaqār aur shāndār nazar āeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Yih sab apne bhāī Hārūn aur us ke beṭoṅ ko pahnānā. Un ke saroṅ par tel unḍel kar unheṅ masah karnā. Yoṅ unheṅ un ke ohde par muqarrar karke merī ḳhidmat ke lie maḳhsūs karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Un ke lie katān ke pājāme bhī banānā tāki wuh zerjāme ke nīche nange na hoṅ. Un kī lambāī kamr se rān tak ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Jab bhī Hārūn aur us ke beṭe mulāqāt ke ḳhaime meṅ dāḳhil hoṅ to unheṅ yih pājāme pahnane haiṅ. Isī tarah jab unheṅ Muqaddas Kamre meṅ ḳhidmat karne ke lie qurbāngāh ke pās ānā hotā hai to wuh yih pahneṅ, warnā wuh qusūrwār ṭhahar kar mar jāeṅge. Yih Hārūn aur us kī aulād ke lie ek abadī usūl hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Imāmoṅ ko maqdis meṅ merī ḳhidmat ke lie maḳhsūs karne kā yih tarīqā hai: Ek jawān bail aur do beaib menḍhe chun lenā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Behtarīn maide se tīn qism kī chīzeṅ pakānā jin meṅ ḳhamīr na ho. Pahle, sādā roṭī. Dūsre, roṭī jis meṅ tel ḍālā gayā ho. Tīsre, roṭī jis par tel lagāyā gayā ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Yih chīzeṅ ṭokrī meṅ rakh kar jawān bail aur do menḍhoṅ ke sāth Rab ko pesh karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Phir Hārūn aur us ke beṭoṅ ko mulāqāt ke ḳhaime ke darwāze par lā kar ġhusl karānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Is ke bād zerjāmā, choġhā, bālāposh aur sīne kā kīsā le kar Hārūn ko pahnānā. Bālāposh ko us ke mahārat se bune hue paṭke ke zariye bāndhnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Us ke sar par pagaṛī bāndh kar us par sone kī muqaddas taḳhtī lagānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Hārūn ke sar par masah kā tel unḍel kar use masah karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Phir us ke beṭoṅ ko āge lā kar zerjāmā pahnānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Un ke pagaṛiyāṅ aur kamarband bāndhnā. Yoṅ tū Hārūn aur us ke beṭoṅ ko un ke mansab par muqarrar karnā. Sirf wuh aur un kī aulād hameshā tak maqdis meṅ merī ḳhidmat karte raheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Bail ko mulāqāt ke ḳhaime ke sāmne lānā. Hārūn aur us ke beṭe us ke sar par apne hāth rakheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Use ḳhaime ke darwāze ke sāmne Rab ke huzūr zabah karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Bail ke ḳhūn meṅ se kuchh le kar apnī unglī se qurbāngāh ke sīṅgoṅ par lagānā aur bāqī ḳhūn qurbāngāh ke pāe par unḍel denā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Antaṛiyoṅ par kī tamām charbī, joṛkalejī aur donoṅ gurde un kī charbī samet le kar qurbāngāh par jalā denā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Lekin bail ke gosht, khāl aur antaṛiyoṅ ke gobar ko ḳhaimāgāh ke bāhar jalā denā. Yih gunāh kī qurbānī hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Is ke bād pahle menḍhe ko le ānā. Hārūn aur us ke beṭe apne hāth menḍhe ke sar par rakheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Use zabah karke us kā ḳhūn qurbāngāh ke chār pahluoṅ par chhiṛaknā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Menḍhe ko ṭukṛe ṭukṛe karke us kī antaṛiyoṅ aur pinḍliyoṅ ko dhonā. Phir unheṅ sar aur bāqī ṭukṛoṅ ke sāth milā kar ");
INSERT INTO urdgvr_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","pūre menḍhe ko qurbāngāh par jalā denā. Jalne wālī yih qurbānī Rab ke lie bhasm hone wālī qurbānī hai, aur us kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Ab dūsre menḍhe ko le ānā. Hārūn aur us ke beṭe apne hāth menḍhe ke sar par rakheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Us ko zabah karnā. Us ke ḳhūn meṅ se kuchh le kar Hārūn aur us ke beṭoṅ ke dahne kān kī lau par lagānā. Isī tarah ḳhūn ko un ke dahne hāth aur dahne pāṅw ke angūṭhoṅ par bhī lagānā. Bāqī ḳhūn qurbāngāh ke chār pahluoṅ par chhiṛaknā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Jo ḳhūn qurbāngāh par paṛā hai us meṅ se kuchh le kar aur masah ke tel ke sāth milā kar Hārūn aur us ke kapṛoṅ par chhiṛaknā. Isī tarah us ke beṭoṅ aur un ke kapṛoṅ par bhī chhiṛaknā. Yoṅ wuh aur us ke beṭe ḳhidmat ke lie maḳhsūs-o-muqaddas ho jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Is menḍhe kā ḳhās maqsad yih hai ki Hārūn aur us ke beṭoṅ ko maqdis meṅ ḳhidmat karne kā iḳhtiyār aur ohdā diyā jāe. Menḍhe kī charbī, dum, antaṛiyoṅ par kī sārī charbī, joṛkalejī, donoṅ gurde un kī charbī samet aur dahnī rān alag karnī hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Us ṭokrī meṅ se jo Rab ke huzūr yānī ḳhaime ke darwāze par paṛī hai ek sādā roṭī, ek roṭī jis meṅ tel ḍālā gayā ho aur ek roṭī jis par tel lagāyā gayā ho nikālnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Menḍhe se alag kī gaī chīzeṅ aur beḳhamīrī roṭī kī ṭokrī kī yih chīzeṅ le kar Hārūn aur us ke beṭoṅ ke hāthoṅ meṅ denā, aur wuh unheṅ hilāne wālī qurbānī ke taur par Rab ke sāmne hilāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Phir yih chīzeṅ un se wāpas le kar bhasm hone wālī qurbānī ke sāth qurbāngāh par jalā denā. Yih Rab ke lie jalne wālī qurbānī hai, aur us kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ab us menḍhe kā Sīnā lenā jis kī mārifat Hārūn ko imām-e-āzam kā iḳhtiyār diyā jātā hai. Sīne ko bhī hilāne wālī qurbānī ke taur par Rab ke sāmne hilānā. Yih Sīnā qurbānī kā terā hissā hogā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Yoṅ tujhe Hārūn aur us ke beṭoṅ kī maḳhsūsiyat ke lie mustāmal menḍhe ke ṭukṛe maḳhsūs-o-muqaddas karne haiṅ. Us ke sīne ko Rab ke sāmne hilāne wālī qurbānī ke taur par hilāyā jāe aur us kī rān ko uṭhāne wālī qurbānī ke taur par uṭhāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Hārūn aur us kī aulād ko Isrāīliyoṅ kī taraf se hameshā tak yih milne kā haq hai. Jab bhī Isrāīlī Rab ko apnī salāmatī kī qurbāniyāṅ pesh kareṅ to imāmoṅ ko yih do ṭukṛe mileṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Jab Hārūn faut ho jāegā to us ke muqaddas libās us kī aulād meṅ se us mard ko dene haiṅ jise masah karke Hārūn kī jagah muqarrar kiyā jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Jo beṭā us kī jagah muqarrar kiyā jāegā aur maqdis meṅ ḳhidmat karne ke lie mulāqāt ke ḳhaime meṅ āegā wuh yih libās sāt din tak pahne rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Jo menḍhā Hārūn aur us ke beṭoṅ kī maḳhsūsiyat ke lie zabah kiyā gayā hai use muqaddas jagah par ubālnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Phir Hārūn aur us ke beṭe mulāqāt ke ḳhaime ke darwāze par menḍhe kā gosht aur ṭokrī kī beḳhamīrī roṭiyāṅ khāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Wuh yih chīzeṅ khāeṅ jin se unheṅ gunāhoṅ kā kaffārā aur imām kā ohdā milā hai. Lekin koī aur yih na khāe, kyoṅki yih maḳhsūs-o-muqaddas haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Aur agar aglī subah tak is gosht yā roṭī meṅ se kuchh bach jāe to use jalāyā jāe. Use khānā manā hai, kyoṅki wuh muqaddas hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Jab tū Hārūn aur us ke beṭoṅ ko imām muqarrar karegā to ain merī hidāyat par amal karnā. Yih taqrīb sāt din tak manāī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Is ke daurān gunāh kī qurbānī ke taur par rozānā ek jawān bail zabah karnā. Is se tū qurbāngāh kā kaffārā de kar use har tarah kī nāpākī se pāk karegā. Is ke alāwā us par masah kā tel unḍelnā. Is se wuh mere lie maḳhsūs-o-muqaddas ho jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Sāt din tak qurbāngāh kā kaffārā de kar use pāk-sāf karnā aur use tel se maḳhsūs-o-muqaddas karnā. Phir qurbāngāh nihāyat muqaddas hogī. Jo bhī use chhuegā wuh bhī maḳhsūs-o-muqaddas ho jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Rozānā ek ek sāl ke do bheṛ ke nar bachche qurbāngāh par jalā denā, ");
INSERT INTO urdgvr_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ek ko subah ke waqt, dūsre ko sūraj ke ġhurūb hone ke ain bād. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Pahle jānwar ke sāth ḍeṛh kilogrām behtarīn maidā pesh kiyā jāe jo kūṭe hue zaitūnoṅ ke ek liṭar tel ke sāth milāyā gayā ho. Mai kī nazar ke taur par ek liṭar mai bhī qurbāngāh par unḍelnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Dūsre jānwar ke sāth bhī ġhallā aur mai kī yih do nazareṅ pesh kī jāeṅ. Aisī qurbānī kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Lāzim hai ki āne wālī tamām nasleṅ bhasm hone wālī yih qurbānī bāqāydagī se muqaddas ḳhaime ke darwāze par Rab ke huzūr chaṛhāeṅ. Wahāṅ maiṅ tum se milā karūṅga aur tum se hamkalām hūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Wahāṅ maiṅ Isrāīliyoṅ se bhī milā karūṅga, aur wuh jagah mere jalāl se maḳhsūs-o-muqaddas ho jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Yoṅ maiṅ mulāqāt ke ḳhaime aur qurbāngāh ko maḳhsūs karūṅga aur Hārūn aur us ke beṭoṅ ko maḳhsūs karūṅga tāki wuh imāmoṅ kī haisiyat se merī ḳhidmat kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Tab maiṅ Isrāīliyoṅ ke darmiyān rahūṅgā aur un kā Ḳhudā hūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Wuh jān leṅge ki maiṅ Rab un kā Ḳhudā hūṅ, ki maiṅ unheṅ Misr se nikāl lāyā tāki un ke darmiyān sukūnat karūṅ. Maiṅ Rab un kā Ḳhudā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Kīkar kī lakaṛī kī qurbāngāh banānā jis par baḳhūr jalāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Wuh ḍeṛh fuṭ lambī, itnī hī chauṛī aur tīn fuṭ ūṅchī ho. Us ke chāroṅ konoṅ meṅ se sīṅg nikleṅ jo qurbāngāh ke sāth ek hī ṭukṛe se banāe gae hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Us kī ūpar kī satah, us ke chār pahluoṅ aur us ke sīṅgoṅ par ḳhālis sonā chaṛhānā. Ūpar kī satah ke irdgird sone kī jhālar ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Sone ke do kaṛe banā kar inheṅ us jhālar ke nīche ek dūsre ke muqābil pahluoṅ par lagānā. In kaṛoṅ meṅ qurbāngāh ko uṭhāne kī lakaṛiyāṅ ḍālī jāeṅgī. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Yih lakaṛiyāṅ kīkar kī hoṅ, aur un par bhī sonā chaṛhānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Is qurbāngāh ko ḳhaime ke Muqaddas Kamre meṅ us parde ke sāmne rakhnā jis ke pīchhe ahd kā sandūq aur us kā ḍhaknā hoṅge, wuh ḍhaknā jahāṅ maiṅ tujh se milā karūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Jab Hārūn har subah shamādān ke charāġh taiyār kare us waqt wuh us par ḳhushbūdār baḳhūr jalāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Sūraj ke ġhurūb hone ke bād bhī jab wuh dubārā charāġhoṅ kī dekh-bhāl karegā to wuh sāth sāth baḳhūr jalāe. Yoṅ Rab ke sāmne baḳhūr mutawātir jaltā rahe. Lāzim hai ki bād kī nasleṅ bhī is usūl par qāym raheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Is qurbāngāh par sirf jāyz baḳhūr istemāl kiyā jāe. Is par na to jānwaroṅ kī qurbāniyāṅ chaṛhāī jāeṅ, na ġhallā yā mai kī nazareṅ pesh kī jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Hārūn sāl meṅ ek dafā us kā kaffārā de kar use pāk kare. Is ke lie wuh kaffāre ke din us qurbānī kā kuchh ḳhūn sīṅgoṅ par lagāe. Yih usūl bhī abad tak qāym rahe. Yih qurbāngāh Rab ke lie nihāyat muqaddas hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Jab bhī tū Isrāīliyoṅ kī mardumshumārī kare to lāzim hai ki jin kā shumār kiyā gayā ho wuh Rab ko apnī jān kā fidyā deṅ tāki un meṅ wabā na phaile. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Jis jis kā shumār kiyā gayā ho wuh chāṅdī ke ādhe sikke ke barābar raqam uṭhāne wālī qurbānī ke taur par de. Sikke kā wazn maqdis ke sikkoṅ ke barābar ho. Yānī chāṅdī ke sikke kā wazn 11 grām ho, is lie chhih grām chāṅdī denī hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Jis kī bhī umr 20 sāl yā is se zāyd ho wuh Rab ko yih raqam uṭhāne wālī qurbānī ke taur par de. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Amīr aur ġharīb donoṅ itnā hī deṅ, kyoṅki yihī nazarānā Rab ko pesh karne se tumhārī jān kā kaffārā diyā jātā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Kaffāre kī yih raqam mulāqāt ke ḳhaime kī ḳhidmat ke lie istemāl karnā. Phir yih nazarānā Rab ko yād dilātā rahegā ki tumhārī jānoṅ kā kaffārā diyā gayā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Pītal kā ḍhāṅchā banānā jis par pītal kā hauz banā kar rakhnā hai. Yih hauz dhone ke lie hai. Use sahan meṅ mulāqāt ke ḳhaime aur jānwaroṅ ko chaṛhāne kī qurbāngāh ke darmiyān rakh kar pānī se bhar denā. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Hārūn aur us ke beṭe apne hāth-pāṅw dhone ke lie us kā pānī istemāl kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Mulāqāt ke ḳhaime meṅ dāḳhil hone se pahle hī wuh apne āp ko dhoeṅ warnā wuh mar jāeṅge. Isī tarah jab bhī wuh ḳhaime ke bāhar kī qurbāngāh par jānwaroṅ kī qurbāniyāṅ chaṛhāeṅ ");
INSERT INTO urdgvr_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","to lāzim hai ki pahle hāth-pāṅw dho leṅ, warnā wuh mar jāeṅge. Yih usūl Hārūn aur us kī aulād ke lie hameshā tak qāym rahe.” ");
INSERT INTO urdgvr_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Masah ke tel ke lie umdā qism ke masāle istemāl karnā. 6 kilogrām āb-e-mur, 3 kilogrām ḳhushbūdār dārchīnī, 3 kilogrām ḳhushbūdār bed ");
INSERT INTO urdgvr_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","aur 6 kilogrām tejpāt. Yih chīzeṅ maqdis ke bāṭoṅ ke hisāb se tol kar chār liṭar zaitūn ke tel meṅ ḍālnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Sab kuchh milā kar ḳhushbūdār tel taiyār karnā. Wuh muqaddas hai aur sirf us waqt istemāl kiyā jāe jab koī chīz yā shaḳhs mere lie maḳhsūs-o-muqaddas kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Yihī tel le kar mulāqāt kā ḳhaimā aur us kā sārā sāmān masah karnā yānī ḳhaimā, ahd kā sandūq, ");
INSERT INTO urdgvr_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","mez aur us kā sāmān, shamādān aur us kā sāmān, baḳhūr jalāne kī qurbāngāh, ");
INSERT INTO urdgvr_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","jānwaroṅ ko chaṛhāne kī qurbāngāh aur us kā sāmān, dhone kā hauz aur us kā ḍhāṅchā. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Yoṅ tū yih tamām chīzeṅ maḳhsūs-o-muqaddas karegā. Is se wuh nihāyat muqaddas ho jāeṅgī. Jo bhī unheṅ chhuegā wuh muqaddas ho jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Hārūn aur us ke beṭoṅ ko bhī is tel se masah karnā tāki wuh muqaddas ho kar mere lie imām kā kām saranjām de sakeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Isrāīliyoṅ ko kah de ki yih tel hameshā tak mere lie maḳhsūs-o-muqaddas hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Is lie ise apne lie istemāl na karnā aur na is tarkīb se apne lie tel banānā. Yih tel maḳhsūs-o-muqaddas hai aur tumheṅ bhī ise yoṅ ṭhahrānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Jo is tarkīb se ām istemāl ke lie tel banātā hai yā kisī ām shaḳhs par lagātā hai use us kī qaum meṅ se miṭā ḍālnā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Rab ne Mūsā se kahā, “Baḳhūr is tarkīb se banānā hai: mastakī, onikā, birījā aur ḳhālis lubān barābar ke hissoṅ meṅ ");
INSERT INTO urdgvr_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","milā kar ḳhushbūdār baḳhūr banānā. Itarsāz kā yih kām namkīn, ḳhālis aur muqaddas ho. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Is meṅ se kuchh pīs kar pauḍar banānā aur mulāqāt ke ḳhaime meṅ ahd ke sandūq ke sāmne ḍālnā jahāṅ maiṅ tujh se milā karūṅga. Is baḳhūr ko muqaddastarīn ṭhahrānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Isī tarkīb ke mutābiq apne lie baḳhūr na banānā. Ise Rab ke lie maḳhsūs-o-muqaddas ṭhahrānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Jo bhī apne zātī istemāl ke lie is qism kā baḳhūr banāe use us kī qaum meṅ se miṭā ḍālnā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Phir Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Maiṅ ne Yahūdāh ke qabīle ke Bazliyel bin Ūrī bin Hūr ko chun liyā hai tāki wuh muqaddas ḳhaime kī tāmīr meṅ rāhnumāī kare. ");
INSERT INTO urdgvr_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Maiṅ ne use ilāhī Rūh se māmūr karke hikmat, samajh aur tāmīr ke har kām ke lie darkār ilm de diyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Wuh naqshe banā kar un ke mutābiq sone, chāṅdī aur pītal kī chīzeṅ banā saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Wuh jawāhar ko kāṭ kar jaṛne kī qābiliyat rakhtā hai. Wuh lakaṛī ko tarāsh kar us se muḳhtalif chīzeṅ banā saktā hai. Wuh bahut sāre aur kāmoṅ meṅ bhī mahārat rakhtā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Sāth hī maiṅ ne Dān ke qabīle ke Uhliyāb bin Aḳhīsamak ko muqarrar kiyā hai tāki wuh har kām meṅ us kī madad kare. Is ke alāwā maiṅ ne tamām samajhdār kārīgaroṅ ko mahārat dī hai tāki wuh sab kuchh un hidāyāt ke mutābiq banā sakeṅ jo maiṅ ne tujhe dī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Yānī mulāqāt kā ḳhaimā, kaffāre ke ḍhakne samet ahd kā sandūq aur ḳhaime kā sārā dūsrā sāmān, ");
INSERT INTO urdgvr_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","mez aur us kā sāmān, ḳhālis sone kā shamādān aur us kā sāmān, baḳhūr jalāne kī qurbāngāh, ");
INSERT INTO urdgvr_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","jānwaroṅ ko chaṛhāne kī qurbāngāh aur us kā sāmān, dhone kā hauz us ḍhāṅche samet jis par wuh rakhā jātā hai, ");
INSERT INTO urdgvr_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","wuh libās jo Hārūn aur us ke beṭe maqdis meṅ ḳhidmat karne ke lie pahante haiṅ, ");
INSERT INTO urdgvr_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","masah kā tel aur maqdis ke lie ḳhushbūdār baḳhūr. Yih sab kuchh wuh waise hī banāeṅ jaise maiṅ ne tujhe hukm diyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Isrāīliyoṅ ko batā ki har Sabat kā din zarūr manāo. Kyoṅki Sabat kā din ek numāyāṅ nishān hai jis se jān liyā jāegā ki maiṅ Rab hūṅ jo tumheṅ maḳhsūs-o-muqaddas kartā hūṅ. Aur yih nishān mere aur tumhāre darmiyān nasl-dar-nasl qāym rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Sabat kā din zarūr manānā, kyoṅki wuh tumhāre lie maḳhsūs-o-muqaddas hai. Jo bhī us kī behurmatī kare wuh zarūr jān se mārā jāe. Jo bhī is din kām kare use us kī qaum meṅ se miṭāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Chhih din kām karnā, lekin sātwāṅ din ārām kā din hai. Wuh Rab ke lie maḳhsūs-o-muqaddas hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Isrāīliyoṅ ko hāl meṅ aur mustaqbil meṅ Sabat kā din abadī ahd samajh kar manānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Wuh mere aur Isrāīliyoṅ ke darmiyān abadī nishān hogā. Kyoṅki Rab ne chhih din ke daurān āsmān-o-zamīn ko banāyā jabki sātweṅ din us ne ārām kiyā aur tāzādam ho gayā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Yih sab kuchh Mūsā ko batāne ke bād Rab ne use Sīnā Pahāṛ par sharīat kī do taḳhtiyāṅ dīṅ. Allāh ne ḳhud patthar kī in taḳhtiyoṅ par tamām bāteṅ likhī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Pahāṛ ke dāman meṅ log Mūsā ke intazār meṅ rahe, lekin bahut der ho gaī. Ek din wuh Hārūn ke gird jamā ho kar kahne lage, “Āeṅ, hamāre lie dewatā banā deṅ jo hamāre āge āge chalte hue hamārī rāhnumāī kareṅ. Kyoṅki kyā mālūm ki us bande Mūsā ko kyā huā hai jo hameṅ Misr se nikāl lāyā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Jawāb meṅ Hārūn ne kahā, “Āp kī bīwiyāṅ, beṭe aur beṭiyāṅ apnī sone kī bāliyāṅ utār kar mere pās le āeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Sab log apnī bāliyāṅ utār utār kar Hārūn ke pās le āe ");
INSERT INTO urdgvr_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","to us ne yih zewarāt le kar bachhṛā ḍhāl diyā. Bachhṛe ko dekh kar log bol uṭhe, “Ai Isrāīl, yih tere dewatā haiṅ jo tujhe Misr se nikāl lāe.” ");
INSERT INTO urdgvr_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Jab Hārūn ne yih dekhā to us ne bachhṛe ke sāmne qurbāngāh banā kar elān kiyā, “Kal ham Rab kī tāzīm meṅ īd manāeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Agle din log subah-sawere uṭhe aur bhasm hone wālī qurbāniyāṅ aur salāmatī kī qurbāniyāṅ chaṛhāīṅ. Wuh khāne-pīne ke lie baiṭh gae aur phir uṭh kar rangraliyoṅ meṅ apne dil bahlāne lage. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Us waqt Rab ne Mūsā se kahā, “Pahāṛ se utar jā. Tere log jinheṅ tū Misr se nikāl lāyā baṛī sharārateṅ kar rahe haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Wuh kitnī jaldī se us rāste se haṭ gae haiṅ jis par chalne ke lie maiṅ ne unheṅ hukm diyā thā. Unhoṅ ne apne lie ḍhālā huā bachhṛā banā kar use sijdā kiyā hai. Unhoṅ ne use qurbāniyāṅ pesh karke kahā hai, ‘Ai Isrāīl, yih tere dewatā haiṅ. Yihī tujhe Misr se nikāl lāe haiṅ.’” ");
INSERT INTO urdgvr_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Allāh ne Mūsā se kahā, “Maiṅ ne dekhā hai ki yih qaum baṛī haṭdharm hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ab mujhe rokne kī koshish na kar. Maiṅ un par apnā ġhazab unḍel kar un ko rū-e-zamīn par se miṭā dūṅgā. Un kī jagah maiṅ tujh se ek baṛī qaum banā dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Lekin Mūsā ne kahā, “Ai Rab, tū apnī qaum par apnā ġhussā kyoṅ utārnā chāhtā hai? Tū ḳhud apnī azīm qudrat se use Misr se nikāl lāyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Misrī kyoṅ kaheṅ, ‘Rab Isrāīliyoṅ ko sirf is bure maqsad se hamāre mulk se nikāl le gayā hai ki unheṅ pahāṛī ilāqe meṅ mār ḍāle aur yoṅ unheṅ rū-e-zamīn par se miṭāe’? Apnā ġhussā ṭhanḍā hone de aur apnī qaum ke sāth burā sulūk karne se bāz rah. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Yād rakh ki tū ne apne ḳhādimoṅ Ibrāhīm, Is'hāq aur Yāqūb se apnī hī qasam khā kar kahā thā, ‘Maiṅ tumhārī aulād kī tādād yoṅ baṛhāūṅgā ki wuh āsmān ke sitāroṅ ke barābar ho jāegī. Maiṅ unheṅ wuh mulk dūṅgā jis kā wādā maiṅ ne kiyā hai, aur wuh use hameshā ke lie mīrās meṅ pāeṅge.’” ");
INSERT INTO urdgvr_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Mūsā ke kahne par Rab ne wuh nahīṅ kiyā jis kā elān us ne kar diyā thā balki wuh apnī qaum se burā sulūk karne se bāz rahā. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mūsā muṛ kar pahāṛ se utrā. Us ke hāthoṅ meṅ sharīat kī donoṅ taḳhtiyāṅ thīṅ. Un par āge pīchhe likhā gayā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Allāh ne ḳhud taḳhtiyoṅ ko banā kar un par apne ahkām kandā kie the. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Utarte utarte Yashua ne logoṅ kā shor sunā aur Mūsā se kahā, “Ḳhaimāgāh meṅ jang kā shor mach rahā hai!” ");
INSERT INTO urdgvr_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mūsā ne jawāb diyā, “Na to yih fathmandoṅ ke nāre haiṅ, na shikast khāe huoṅ kī chīḳh-pukār. Mujhe gāne wāloṅ kī āwāz sunāī de rahī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Jab wuh ḳhaimāgāh ke nazdīk pahuṅchā to us ne logoṅ ko sone ke bachhṛe ke sāmne nāchte hue dekhā. Baṛe ġhusse meṅ ā kar us ne taḳhtiyoṅ ko zamīn par paṭaḳh diyā, aur wuh ṭukṛe ṭukṛe ho kar pahāṛ ke dāman meṅ gir gaīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Mūsā ne Isrāīliyoṅ ke banāe hue bachhṛe ko jalā diyā. Jo kuchh bach gayā use us ne pīs pīs kar pauḍar banā ḍālā aur pauḍar pānī par chhiṛak kar Isrāīliyoṅ ko pilā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Us ne Hārūn se pūchhā, “In logoṅ ne tumhāre sāth kyā kiyā ki tum ne unheṅ aise baṛe gunāh meṅ phaṅsā diyā?” ");
INSERT INTO urdgvr_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Hārūn ne kahā, “Mere āqā. Ġhusse na hoṅ. Āp ḳhud jānte haiṅ ki yih log badī par tule rahte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Unhoṅ ne mujh se kahā, ‘Hamāre lie dewatā banā deṅ jo hamāre āge āge chalte hue hamārī rāhnumāī kareṅ. Kyoṅki kyā mālūm ki us bande Mūsā ko kyā huā hai jo hameṅ Misr se nikāl lāyā.’ ");
INSERT INTO urdgvr_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Is lie maiṅ ne un ko batāyā, ‘Jis ke pās sone ke zewarāt haiṅ wuh unheṅ utār lāe.’ Jo kuchh unhoṅ ne mujhe diyā use maiṅ ne āg meṅ phaiṅk diyā to hote hote sone kā yih bachhṛā nikal āyā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mūsā ne dekhā ki log beqābū ho gae haiṅ. Kyoṅki Hārūn ne unheṅ belagām chhoṛ diyā thā, aur yoṅ wuh Isrāīl ke dushmanoṅ ke lie mazāq kā nishānā ban gae the. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Mūsā ḳhaimāgāh ke darwāze par khaṛe ho kar bolā, “Jo bhī Rab kā bandā hai wuh mere pās āe.” Jawāb meṅ Lāwī ke qabīle ke tamām log us ke pās jamā ho gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Phir Mūsā ne un se kahā, “Rab Isrāīl kā Ḳhudā farmātā hai, ‘Har ek apnī talwār le kar ḳhaimāgāh meṅ se guzare. Ek sire ke darwāze se shurū karke dūsre sire ke darwāze tak chalte chalte har milne wāle ko jān se mār do, chāhe wuh tumhārā bhāī, dost yā rishtedār hī kyoṅ na ho. Phir muṛ kar mārte mārte pahle darwāze par wāpas ā jāo.’” ");
INSERT INTO urdgvr_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Lāwiyoṅ ne Mūsā kī hidāyat par amal kiyā to us din taqrīban 3,000 mard halāk hue. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Yih dekh kar Mūsā ne Lāwiyoṅ se kahā, “Āj apne āp ko maqdis meṅ Rab kī ḳhidmat karne ke lie maḳhsūs-o-muqaddas karo, kyoṅki tum apne beṭoṅ aur bhāiyoṅ ke ḳhilāf laṛne ke lie taiyār the. Is lie Rab tum ko āj barkat degā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Agle din Mūsā ne Isrāīliyoṅ se bāt kī, “Tum ne nihāyat sangīn gunāh kiyā hai. To bhī maiṅ ab Rab ke pās pahāṛ par jā rahā hūṅ. Shāyad maiṅ tumhāre gunāh kā kaffārā de sakūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Chunāṅche Mūsā ne Rab ke pās wāpas jā kar kahā, “Hāy, is qaum ne nihāyat sangīn gunāh kiyā hai. Unhoṅ ne apne lie sone kā dewatā banā liyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Mehrbānī karke unheṅ muāf kar. Lekin agar tū unheṅ muāf na kare to phir mujhe bhī apnī us kitāb meṅ se miṭā de jis meṅ tū ne apne logoṅ ke nām darj kie haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Rab ne jawāb diyā, “Maiṅ sirf us ko apnī kitāb meṅ se miṭātā hūṅ jo merā gunāh kartā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ab jā, logoṅ ko us jagah le chal jis kā zikr maiṅ ne kiyā hai. Merā farishtā tere āge āge chalegā. Lekin jab sazā kā muqarrarā din āegā tab maiṅ unheṅ sazā dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Phir Rab ne Isrāīliyoṅ ke darmiyān wabā phailne dī, is lie ki unhoṅ ne us bachhṛe kī pūjā kī thī jo Hārūn ne banāyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Rab ne Mūsā se kahā, “Is jagah se rawānā ho jā. Un logoṅ ko le kar jin ko tū Misr se nikāl lāyā hai us mulk ko jā jis kā wādā maiṅ ne Ibrāhīm, Is'hāq aur Yāqūb se kiyā hai. Unhīṅ se maiṅ ne qasam khā kar kahā thā, ‘Maiṅ yih mulk tumhārī aulād ko dūṅgā.’ ");
INSERT INTO urdgvr_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Maiṅ tere āge āge farishtā bhej kar Kanānī, Amorī, Hittī, Farizzī, Hiwwī aur Yabūsī aqwām ko us mulk se nikāl dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Uṭh, us mulk ko jā jahāṅ dūdh aur shahd kī kasrat hai. Lekin maiṅ sāth nahīṅ jāūṅgā. Tum itne haṭdharm ho ki agar maiṅ sāth jāūṅ to ḳhatrā hai ki tumheṅ wahāṅ pahuṅchne se pahle hī barbād kar dūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Jab Isrāīliyoṅ ne yih saḳht alfāz sune to wuh mātam karne lage. Kisī ne bhī apne zewar na pahne, ");
INSERT INTO urdgvr_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","kyoṅki Rab ne Mūsā se kahā thā, “Isrāīliyoṅ ko batā ki tum haṭdharm ho. Agar maiṅ ek lamhā bhī tumhāre sāth chalūṅ to ḳhatrā hai ki maiṅ tumheṅ tabāh kar dūṅ. Ab apne zewarāt utār ḍālo. Phir maiṅ faislā karūṅga ki tumhāre sāth kyā kiyā jāe.” ");
INSERT INTO urdgvr_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","In alfāz par Isrāīliyoṅ ne Horib yānī Sīnā Pahāṛ par apne zewar utār die. ");
INSERT INTO urdgvr_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Us waqt Mūsā ne ḳhaimā le kar use kuchh fāsile par ḳhaimāgāh ke bāhar lagā diyā. Us ne us kā nām ‘mulāqāt kā ḳhaimā’ rakhā. Jo bhī Rab kī marzī dariyāft karnā chāhtā wuh ḳhaimāgāh se nikal kar wahāṅ jātā. ");
INSERT INTO urdgvr_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Jab bhī Mūsā ḳhaimāgāh se nikal kar wahāṅ jātā to tamām log apne ḳhaimoṅ ke darwāzoṅ par khaṛe ho kar Mūsā ke pīchhe deḳhne lagte. Us ke mulāqāt ke ḳhaime meṅ ojhal hone tak wuh use deḳhte rahte. ");
INSERT INTO urdgvr_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mūsā ke ḳhaime meṅ dāḳhil hone par bādal kā satūn utar kar ḳhaime ke darwāze par ṭhahar jātā. Jitnī der tak Rab Mūsā se bāteṅ kartā utnī der tak wuh wahāṅ ṭhahrā rahtā. ");
INSERT INTO urdgvr_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Jab Isrāīlī mulāqāt ke ḳhaime ke darwāze par bādal kā satūn deḳhte to wuh apne apne ḳhaime ke darwāze par khaṛe ho kar sijdā karte. ");
INSERT INTO urdgvr_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Rab Mūsā se rūbarū bāteṅ kartā thā, aise shaḳhs kī tarah jo apne dost se bāteṅ kartā hai. Is ke bād Mūsā nikal kar ḳhaimāgāh ko wāpas chalā jātā. Lekin us kā jawān madadgār Yashua bin Nūn ḳhaime ko nahīṅ chhoṛtā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mūsā ne Rab se kahā, “Dekh, tū mujh se kahtā āyā hai ki is qaum ko Kanān le chal. Lekin tū mere sāth kis ko bhejegā? Tū ne ab tak yih bāt mujhe nahīṅ batāī hālāṅki tū ne kahā hai, ‘Maiṅ tujhe banām jāntā hūṅ, tujhe merā karm hāsil huā hai.’ ");
INSERT INTO urdgvr_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Agar mujhe wāqaī terā karm hāsil hai to mujhe apne rāste dikhā tāki maiṅ tujhe jān lūṅ aur terā karm mujhe hāsil hotā rahe. Is bāt kā ḳhayāl rakh ki yih qaum terī hī ummat hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Rab ne jawāb diyā, “Maiṅ ḳhud tere sāth chalūṅgā aur tujhe ārām dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mūsā ne kahā, “Agar tū ḳhud sāth nahīṅ chalegā to phir hameṅ yahāṅ se rawānā na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Agar tū hamāre sāth na jāe to kis tarah patā chalegā ki mujhe aur terī qaum ko terā karm hāsil huā hai? Ham sirf isī wajah se duniyā kī dīgar qaumoṅ se alag aur mumtāz haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Rab ne Mūsā se kahā, “Maiṅ terī yih darḳhāst bhī pūrī karūṅga, kyoṅki tujhe merā karm hāsil huā hai aur maiṅ tujhe banām jāntā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Phir Mūsā bolā, “Barāh-e-karm mujhe apnā jalāl dikhā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Rab ne jawāb diyā, “Maiṅ apnī pūrī bhalāī tere sāmne se guzarne dūṅgā aur tere sāmne hī apne nām Rab kā elān karūṅga. Maiṅ jis par mehrbān honā chāhūṅ us par mehrbān hotā hūṅ, aur jis par rahm karnā chāhūṅ us par rahm kartā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Lekin tū merā chehrā nahīṅ dekh saktā, kyoṅki jo bhī merā chehrā dekhe wuh zindā nahīṅ rah saktā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Phir Rab ne farmāyā, “Dekh, mere pās ek jagah hai. Wahāṅ kī chaṭṭān par khaṛā ho jā. ");
INSERT INTO urdgvr_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Jab merā jalāl wahāṅ se guzaregā to maiṅ tujhe chaṭṭān ke ek shigāf meṅ rakhūṅgā aur apnā hāth tere ūpar phailāūṅgā tāki tū mere guzarne ke daurān mahfūz rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Is ke bād maiṅ apnā hāth haṭāūṅgā aur tū mere pīchhe dekh sakegā. Lekin merā chehrā dekhā nahīṅ jā saktā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Rab ne Mūsā se kahā, “Apne lie patthar kī do taḳhtiyāṅ tarāsh le jo pahlī do kī mānind hoṅ. Phir maiṅ un par wuh alfāz likhūṅgā jo pahlī taḳhtiyoṅ par likhe the jinheṅ tū ne paṭaḳh diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Subah tak taiyār ho kar Sīnā Pahāṛ par chaṛhnā. Choṭī par mere sāmne khaṛā ho jā. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Tere sāth koī bhī na āe balki pūre pahāṛ par koī aur shaḳhs nazar na āe, yahāṅ tak ki bheṛ-bakriyāṅ aur gāy-bail bhī pahāṛ ke dāman meṅ na chareṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Chunāṅche Mūsā ne do taḳhtiyāṅ tarāsh līṅ jo pahlī kī mānind thīṅ. Phir wuh subah-sawere uṭh kar Sīnā Pahāṛ par chaṛh gayā jis tarah Rab ne use hukm diyā thā. Us ke hāthoṅ meṅ patthar kī donoṅ taḳhtiyāṅ thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Jab wuh choṭī par pahuṅchā to Rab bādal meṅ utar āyā aur us ke pās khaṛe ho kar apne nām Rab kā elān kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Mūsā ke sāmne se guzarte hue us ne pukārā, “Rab, Rab, rahīm aur mehrbān Ḳhudā. Tahammul, shafqat aur wafā se bharpūr. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Wuh hazāroṅ par apnī shafqat qāym rakhtā aur logoṅ kā qusūr, nāfarmānī aur gunāh muāf kartā hai. Lekin wuh har ek ko us kī munāsib sazā bhī detā hai. Jab wālidain gunāh kareṅ to un kī aulād ko bhī tīsrī aur chauthī pusht tak sazā ke natāyj bhugatne paṛeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mūsā ne jaldī se jhuk kar sijdā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Us ne kahā, “Ai Rab, agar mujh par terā karm ho to hamāre sāth chal. Beshak yih qaum haṭdharm hai, to bhī hamārā qusūr aur gunāh muāf kar aur baḳhsh de ki ham dubārā tere hī ban jāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Tab Rab ne kahā, “Maiṅ tumhāre sāth ahd bāndhūṅgā. Terī qaum ke sāmne hī maiṅ aise mojize karūṅga jo ab tak duniyā-bhar kī kisī bhī qaum meṅ nahīṅ kie gae. Pūrī qaum jis ke darmiyān tū rahtā hai Rab kā kām dekhegī aur us se ḍar jāegī jo maiṅ tere sāth karūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Jo ahkām maiṅ āj detā hūṅ un par amal kartā rah. Maiṅ Amorī, Kanānī, Hittī, Farizzī, Hiwwī aur Yabūsī aqwām ko tere āge āge mulk se nikāl dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ḳhabardār, jo us mulk meṅ rahte haiṅ jahāṅ tū jā rahā hai un se ahd na bāndhnā. Warnā wuh tere darmiyān rahte hue tujhe gunāhoṅ meṅ phaṅsāte raheṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Un kī qurbāngāheṅ ḍhā denā, un ke butoṅ ke satūn ṭukṛe ṭukṛe kar denā aur un kī dewī Yasīrat ke khambe kāṭ ḍālnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Kisī aur mābūd kī parastish na karnā, kyoṅki Rab kā nām ġhayūr hai, Allāh ġhairatmand hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ḳhabardār, us mulk ke bāshindoṅ se ahd na karnā, kyoṅki tere darmiyān rahte hue bhī wuh apne mābūdoṅ kī pairawī karke zinā kareṅge aur unheṅ qurbāniyāṅ chaṛhāeṅge. Āḳhirkār wuh tujhe bhī apnī qurbāniyoṅ meṅ shirkat kī dāwat deṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ḳhatrā hai ki tū un kī beṭiyoṅ kā apne beṭoṅ ke sāth rishtā bāndhe. Phir jab yih apne mābūdoṅ kī pairawī karke zinā kareṅgī to un ke sabab se tere beṭe bhī un kī pairawī karne lageṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Apne lie dewatā na ḍhālnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Beḳhamīrī Roṭī kī Īd manānā. Abīb ke mahīne meṅ sāt din tak terī roṭī meṅ ḳhamīr na ho jis tarah maiṅ ne hukm diyā hai. Kyoṅki is mahīne meṅ tū Misr se niklā. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Har pahlauṭhā merā hai. Tere māl maweshiyoṅ kā har pahlauṭhā merā hai, chāhe bachhṛā ho yā lelā. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Lekin pahlauṭhe gadhe ke ewaz bheṛ denā. Agar yih mumkin na ho to us kī gardan toṛ ḍālnā. Apne pahlauṭhe beṭoṅ ke lie bhī ewazī denā. Koī mere pās ḳhālī hāth na āe. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Chhih din kām-kāj karnā, lekin sātweṅ din ārām karnā. Ḳhāh hal chalānā ho yā fasal kāṭnī ho to bhī sātweṅ din ārām karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Gandum kī Fasal kī Kaṭāī kī Īd us waqt manānā jab tū gehūṅ kī pahlī fasal kāṭegā. Angūr aur Phal Jamā Karne kī Īd Isrāīlī sāl ke iḳhtitām par manānī hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Lāzim hai ki tere tamām mard sāl meṅ tīn martabā Rab Qādir-e-mutlaq ke sāmne jo Isrāīl kā Ḳhudā hai hāzir hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Maiṅ tere āge āge qaumoṅ ko mulk se nikāl dūṅgā aur terī sarhaddeṅ baṛhātā jāūṅgā. Phir jab tū sāl meṅ tīn martabā Rab apne Ḳhudā ke huzūr āegā to koī bhī tere mulk kā lālach nahīṅ karegā. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Jab tū kisī jānwar ko zabah karke qurbānī ke taur par pesh kartā hai to us ke ḳhūn ke sāth aisī roṭī pesh na karnā jis meṅ ḳhamīr ho. Īd-e-Fasah kī qurbānī se aglī subah tak kuchh bāqī na rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Apnī zamīn kī pahlī paidāwār meṅ se behtarīn hissā Rab apne Ḳhudā ke ghar meṅ le ānā. Bakrī yā bheṛ ke bachche ko us kī māṅ ke dūdh meṅ na pakānā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Rab ne Mūsā se kahā, “Yih tamām bāteṅ likh le, kyoṅki yih us ahd kī buniyād haiṅ jo maiṅ ne tere aur Isrāīl ke sāth bāndhā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mūsā chālīs din aur chālīs rāt wahīṅ Rab ke huzūr rahā. Is daurān na us ne kuchh khāyā na piyā. Us ne patthar kī taḳhtiyoṅ par ahd ke das ahkām likhe. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Is ke bād Mūsā sharīat kī donoṅ taḳhtiyoṅ ko hāth meṅ lie hue Sīnā Pahāṛ se utrā. Us ke chehre kī jild chamak rahī thī, kyoṅki us ne Rab se bāt kī thī. Lekin use ḳhud is kā ilm nahīṅ thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Jab Hārūn aur tamām Isrāīliyoṅ ne dekhā ki Mūsā kā chehrā chamak rahā hai to wuh us ke pās āne se ḍar gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Lekin us ne unheṅ bulāyā to Hārūn aur jamāt ke tamām sardār us ke pās āe, aur us ne un se bāt kī. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Bād meṅ bāqī Isrāīlī bhī āe, aur Mūsā ne unheṅ tamām ahkām sunāe jo Rab ne use Koh-e-Sīnā par die the. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Yih sab kuchh kahne ke bād Mūsā ne apne chehre par niqāb ḍāl liyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Jab bhī wuh Rab se bāt karne ke lie mulāqāt ke ḳhaime meṅ jātā to niqāb ko ḳhaime se nikalte waqt tak utār letā. Aur jab wuh nikal kar Isrāīliyoṅ ko Rab se mile hue ahkām sunātā ");
INSERT INTO urdgvr_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","to wuh deḳhte ki us ke chehre kī jild chamak rahī hai. Is ke bād Mūsā dubārā niqāb ko apne chehre par ḍāl letā, aur wuh us waqt tak chehre par rahtā jab tak Mūsā Rab se bāt karne ke lie mulāqāt ke ḳhaime meṅ na jātā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mūsā ne Isrāīl kī pūrī jamāt ko ikaṭṭhā karke kahā, “Rab ne tum ko yih hukm die haiṅ: ");
INSERT INTO urdgvr_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Chhih din kām-kāj kiyā jāe, lekin sātwāṅ din maḳhsūs-o-muqaddas ho. Wuh Rab ke lie ārām kā Sabat hai. Jo bhī is din kām kare use sazā-e-maut dī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Hafte ke din apne tamām gharoṅ meṅ āg tak na jalānā.” ");
INSERT INTO urdgvr_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mūsā ne Isrāīl kī pūrī jamāt se kahā, “Rab ne hidāyat dī hai ");
INSERT INTO urdgvr_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ki jo kuchh tumhāre pās hai us meṅ se hadiye lā kar Rab ko uṭhāne wālī qurbānī ke taur par pesh karo. Jo bhī dilī ḳhushī se denā chāhe wuh in chīzoṅ meṅ se kuchh de: sonā, chāṅdī, pītal; ");
INSERT INTO urdgvr_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","nīle, arġhawānī aur qirmizī rang kā dhāgā, bārīk katān, bakrī ke bāl, ");
INSERT INTO urdgvr_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","menḍhoṅ kī surḳh rangī huī khāleṅ, taḳhas kī khāleṅ, kīkar kī lakaṛī, ");
INSERT INTO urdgvr_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","shamādān ke lie zaitūn kā tel, masah karne ke lie tel aur ḳhushbūdār baḳhūr ke lie masāle, ");
INSERT INTO urdgvr_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","aqīq-e-ahmar aur dīgar jawāhar jo imām-e-āzam ke bālāposh aur sīne ke kīse meṅ jaṛe jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Tum meṅ se jitne māhir kārīgar haiṅ wuh ā kar wuh kuchh banāeṅ jo Rab ne farmāyā ");
INSERT INTO urdgvr_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","yānī ḳhaimā aur wuh ġhilāf jo us ke ūpar lagāe jāeṅge, hukeṅ, dīwāroṅ ke taḳhte, shahtīr, satūn aur pāe, ");
INSERT INTO urdgvr_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ahd kā sandūq, use uṭhāne kī lakaṛiyāṅ, us ke kaffāre kā ḍhaknā, Muqaddastarīn Kamre ke darwāze kā pardā, ");
INSERT INTO urdgvr_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","maḳhsūs roṭiyoṅ kī mez, use uṭhāne kī lakaṛiyāṅ, us kā sārā sāmān aur roṭiyāṅ, ");
INSERT INTO urdgvr_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","shamādān aur us par rakhne ke charāġh us ke sāmān samet, shamādān ke lie tel, ");
INSERT INTO urdgvr_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","baḳhūr jalāne kī qurbāngāh, use uṭhāne kī lakaṛiyāṅ, masah kā tel, ḳhushbūdār baḳhūr, muqaddas ḳhaime ke darwāze kā pardā, ");
INSERT INTO urdgvr_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","jānwaroṅ ko chaṛhāne kī qurbāngāh, us kā pītal kā janglā, use uṭhāne kī lakaṛiyāṅ aur bāqī sārā sāmān, dhone kā hauz aur wuh ḍhāṅchā jis par hauz rakhā jātā hai, ");
INSERT INTO urdgvr_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","chārdīwārī ke parde un ke khamboṅ aur pāiyoṅ samet, sahan ke darwāze kā pardā, ");
INSERT INTO urdgvr_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ḳhaime aur chārdīwārī kī meḳheṅ aur rasse, ");
INSERT INTO urdgvr_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","aur wuh muqaddas libās jo Hārūn aur us ke beṭe maqdis meṅ ḳhidmat karne ke lie pahante haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Yih sun kar Isrāīl kī pūrī jamāt Mūsā ke pās se chalī gaī. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Aur jo jo dilī ḳhushī se denā chāhtā thā wuh mulāqāt ke ḳhaime, us ke sāmān yā imāmoṅ ke kapṛoṅ ke lie koī hadiyā le kar wāpas āyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Rab ke hadiye ke lie mard aur ḳhawātīn dilī ḳhushī se apne sone ke zewarāt masalan jaṛāū pineṅ, bāliyāṅ aur chhalle le āe. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Jis jis ke pās darkār chīzoṅ meṅ se kuchh thā wuh use Mūsā ke pās le āyā yānī nīle, qirmizī aur arġhawānī rang kā dhāgā, bārīk katān, bakrī ke bāl, menḍhoṅ kī surḳh rangī huī khāleṅ aur taḳhas kī khāleṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Chāṅdī, pītal aur kīkar kī lakaṛī bhī hadiye ke taur par lāī gaī. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Aur jitnī aurateṅ kātne meṅ māhir thīṅ wuh apnī kātī huī chīzeṅ le āīṅ yānī nīle, qirmizī aur arġhawānī rang kā dhāgā aur bārīk katān. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Isī tarah jo jo aurat bakrī ke bāl kātne meṅ māhir thī aur dilī ḳhushī se maqdis ke lie kām karnā chāhtī thī wuh yih kāt kar le āī. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Sardār aqīq-e-ahmar aur dīgar jawāhar le āe jo imām-e-āzam ke bālāposh aur sīne ke kīse ke lie darkār the. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Wuh shamādān, masah ke tel aur ḳhushbūdār baḳhūr ke lie masāle aur zaitūn kā tel bhī le āe. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Yoṅ Isrāīl ke tamām mard aur ḳhawātīn jo dilī ḳhushī se Rab ko kuchh denā chāhte the us sāre kām ke lie hadiye le āe jo Rab ne Mūsā kī mārifat karne ko kahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Phir Mūsā ne Isrāīliyoṅ se kahā, “Rab ne Yahūdāh ke qabīle ke Bazliyel bin Ūrī bin Hūr ko chun liyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Us ne use ilāhī Rūh se māmūr karke hikmat, samajh aur tāmīr ke har kām ke lie darkār ilm de diyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Wuh naqshe banā kar un ke mutābiq sone, chāṅdī aur pītal kī chīzeṅ banā saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Wuh jawāhar ko kāṭ kar jaṛne kī qābiliyat rakhtā hai. Wuh lakaṛī ko tarāsh kar us se muḳhtalif chīzeṅ banā saktā hai. Wuh bahut sāre aur kāmoṅ meṅ bhī mahārat rakhtā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Sāth hī Rab ne use aur Dān ke qabīle ke Uhliyāb bin Aḳhīsamak ko dūsroṅ ko sikhāne kī qābiliyat bhī dī hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Us ne unheṅ wuh mahārat aur hikmat dī hai jo har kām ke lie darkār hai yānī kārīgarī ke har kām ke lie, kaṛhāī ke kām ke lie, nīle, arġhawānī aur qirmizī rang ke dhāge aur bārīk katān se kapṛā banāne ke lie aur bunāī ke kām ke lie. Wuh māhir kārīgar haiṅ aur naqshe bhī banā sakte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Lāzim hai ki Bazliyel, Uhliyāb aur bāqī kārīgar jin ko Rab ne maqdis kī tāmīr ke lie hikmat aur samajh dī hai sab kuchh ain un hidāyāt ke mutābiq banāeṅ jo Rab ne dī haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mūsā ne Bazliyel aur Uhliyāb ko bulāyā. Sāth hī us ne har us kārīgar ko bhī bulāyā jise Rab ne maqdis kī tāmīr ke lie hikmat aur mahārat dī thī aur jo ḳhushī se ānā aur yih kām karnā chāhtā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Unheṅ Mūsā se tamām hadiye mile jo Isrāīlī maqdis kī tāmīr ke lie lāe the. Is ke bād bhī log roz baroz subah ke waqt hadiye lāte rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Āḳhirkār tamām kārīgar jo maqdis banāne ke kām meṅ lage the apnā kām chhoṛ kar Mūsā ke pās āe. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Unhoṅ ne kahā, “Log had se zyādā lā rahe haiṅ. Jis kām kā hukm Rab ne diyā hai us ke lie itne sāmān kī zarūrat nahīṅ hai.” ");
INSERT INTO urdgvr_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Tab Mūsā ne pūrī ḳhaimāgāh meṅ elān karwā diyā ki koī mard yā aurat maqdis kī tāmīr ke lie ab kuchh na lāe. Yoṅ unheṅ mazīd chīzeṅ lāne se rokā gayā, ");
INSERT INTO urdgvr_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","kyoṅki kām ke lie sāmān zarūrat se zyādā ho gayā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Jo kārīgar mahārat rakhte the unhoṅ ne ḳhaime ko banāyā. Unhoṅ ne bārīk katān aur nīle, arġhawānī aur qirmizī dhāge se das parde banāe. Pardoṅ par kisī māhir kārīgar ke kaṛhāī ke kām se karūbī farishtoṅ kā ḍizāyn banāyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Har parde kī lambāī 42 fuṭ aur chauṛāī 6 fuṭ thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Pāṅch pardoṅ ke lambe hāshie ek dūsre ke sāth joṛe gae aur isī tarah bāqī pāṅch bhī. Yoṅ do baṛe ṭukṛe ban gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Donoṅ ṭukṛoṅ ko ek dūsre ke sāth milāne ke lie unhoṅ ne nīle dhāge ke halqe banāe. Yih halqe har ṭukṛe ke 42 fuṭ wāle ek kināre par lagāe gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ek ṭukṛe ke hāshie par 50 halqe aur dūsre par bhī utne hī halqe. In do hāshiyoṅ ke halqe ek dūsre ke āmne-sāmne the. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Phir Bazliyel ne sone kī 50 hukeṅ banā kar un se āmne-sāmne ke halqoṅ ko ek dūsre ke sāth milāyā. Yoṅ donoṅ ṭukṛoṅ ke joṛne se ḳhaimā ban gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Us ne bakrī ke bāloṅ se bhī 11 parde banāe jinheṅ kapṛe wāle ḳhaime ke ūpar rakhnā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Har parde kī lambāī 45 fuṭ aur chauṛāī 6 fuṭ thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Pāṅch pardoṅ ke lambe hāshie ek dūsre ke sāth joṛe gae aur is tarah bāqī chhih bhī. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","In donoṅ ṭukṛoṅ ko milāne ke lie us ne har ṭukṛe ke 45 fuṭ wāle ek kināre par pachās pachās halqe lagāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Phir pītal kī 50 hukeṅ banā kar us ne donoṅ hisse milāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ek dūsre ke ūpar ke donoṅ ḳhaimoṅ kī hifāzat ke lie Bazliyel ne do aur ġhilāf banāe. Bakrī ke bāloṅ ke ḳhaime par rakhne ke lie us ne menḍhoṅ kī surḳh rangī huī khāleṅ joṛ dīṅ aur us ke ūpar rakhne ke lie taḳhas kī khāleṅ milāīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Is ke bād us ne kīkar kī lakaṛī ke taḳhte banāe jo ḳhaime kī dīwāroṅ kā kām dete the. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Har taḳhte kī ūṅchāī 15 fuṭ thī aur chauṛāī sawā do fuṭ. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Har taḳhte ke nīche do do chūleṅ thīṅ. In chūloṅ se har taḳhte ko us ke pāiyoṅ ke sāth joṛā jātā thā tāki taḳhtā khaṛā rahe. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ḳhaime kī junūbī dīwār ke lie 20 taḳhte banāe gae ");
INSERT INTO urdgvr_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","aur sāth hī chāṅdī ke 40 pāe bhī jin par taḳhte khaṛe kie jāte the. Har taḳhte ke nīche do pāe the, aur har pāe meṅ ek chūl lagtī thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Isī tarah ḳhaime kī shimālī dīwār ke lie bhī 20 taḳhte banāe gae ");
INSERT INTO urdgvr_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","aur sāth hī chāṅdī ke 40 pāe jo taḳhtoṅ ko khaṛā karne ke lie the. Har taḳhte ke nīche do pāe the. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ḳhaime kī pichhlī yānī maġhribī dīwār ke lie chhih taḳhte banāe gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Is dīwār ko shimālī aur junūbī dīwāroṅ ke sāth joṛne ke lie kone wāle do taḳhte banāe gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","In do taḳhtoṅ meṅ nīche se le kar ūpar tak konā thā tāki ek se shimālī dīwār maġhribī dīwār ke sāth juṛ jāe aur dūsre se junūbī dīwār maġhribī dīwār ke sāth. In ke ūpar ke sire kaṛoṅ se mazbūt kie gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Yoṅ pichhle yānī maġhribī taḳhtoṅ kī pūrī tādād 8 thī aur in ke lie chāṅdī ke pāiyoṅ kī tādād 16, har taḳhte ke nīche do pāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","Phir Bazliyel ne kīkar kī lakaṛī ke shahtīr banāe, tīnoṅ dīwāroṅ ke lie pāṅch pāṅch shahtīr. Wuh har dīwār ke taḳhtoṅ par yoṅ lagāne ke lie the ki un se taḳhte ek dūsre ke sāth milāe jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Darmiyānī shahtīr yoṅ banāyā gayā ki wuh dīwār kī ādhī ūṅchāī par dīwār ke ek sire se dūsre sire tak lag saktā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Us ne tamām taḳhtoṅ aur shahtīroṅ par sonā chaṛhāyā. Shahtīroṅ ko taḳhtoṅ ke sāth lagāne ke lie us ne sone ke kaṛe banāe jo taḳhtoṅ meṅ lagāne the. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ab Bazliyel ne ek aur pardā banāyā. Us ke lie bhī bārīk katān aur nīle, arġhawānī aur qirmizī rang kā dhāgā istemāl huā. Us par bhī kisī māhir kārīgar ke kaṛhāī ke kām se karūbī farishtoṅ kā ḍizāyn banāyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Phir us ne parde ko laṭkāne ke lie kīkar kī lakaṛī ke chār satūn, sone kī hukeṅ aur chāṅdī ke chār pāe banāe. Satūnoṅ par sonā chaṛhāyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Bazliyel ne ḳhaime ke darwāze ke lie bhī pardā banāyā. Wuh bhī bārīk katān aur nīle, arġhawānī aur qirmizī rang ke dhāge se banāyā gayā, aur us par kaṛhāī kā kām kiyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Is parde ko laṭkāne ke lie us ne sone kī hukeṅ aur kīkar kī lakaṛī ke pāṅch satūn banāe. Satūnoṅ ke ūpar ke siroṅ aur paṭṭiyoṅ par sonā chaṛhāyā gayā jabki un ke pāe pītal ke the. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bazliyel ne kīkar kī lakaṛī kā sandūq banāyā. Us kī lambāī paune chār fuṭ thī jabki us kī chauṛāī aur ūṅchāī sawā do do fuṭ thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Us ne pūre sandūq par andar aur bāhar se ḳhālis sonā chaṛhāyā. Ūpar kī satah ke irdgird us ne sone kī jhālar lagāī. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Sandūq ko uṭhāne ke lie us ne sone ke chār kaṛe ḍhāl kar unheṅ sandūq ke chārpāiyoṅ par lagāyā. Donoṅ taraf do do kaṛe the. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Phir us ne kīkar kī do lakaṛiyāṅ sandūq ko uṭhāne ke lie taiyār kīṅ aur un par sonā chaṛhāyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Us ne in lakaṛiyoṅ ko donoṅ taraf ke kaṛoṅ meṅ ḍāl diyā tāki un se sandūq ko uṭhāyā jā sake. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Bazliyel ne sandūq kā ḍhaknā ḳhālis sone kā banāyā. Us kī lambāī paune chār fuṭ aur chauṛāī sawā do fuṭ thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","8","Phir us ne do karūbī farishte sone se ghaṛ kar banāe jo ḍhakne ke donoṅ siroṅ par khaṛe the. Yih do farishte aur ḍhaknā ek hī ṭukṛe se banāe gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Farishtoṅ ke par yoṅ ūpar kī taraf phaile hue the ki wuh ḍhakne ko panāh dete the. Un ke muṅh ek dūsre kī taraf kie hue the, aur wuh ḍhakne kī taraf deḳhte the. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Is ke bād Bazliyel ne kīkar kī lakaṛī kī mez banāī. Us kī lambāī tīn fuṭ, chauṛāī ḍeṛh fuṭ aur ūṅchāī sawā do fuṭ thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Us ne us par ḳhālis sonā chaṛhā kar us ke irdgird sone kī jhālar lagāī. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Mez kī ūpar kī satah par us ne chaukhaṭā bhī lagāyā jis kī ūṅchāī tīn inch thī aur jis par sone kī jhālar lagī thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ab us ne sone ke chār kaṛe ḍhāl kar unheṅ chāroṅ konoṅ par lagāyā jahāṅ mez ke pāe lage the. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Yih kaṛe mez kī satah par lage chaukhaṭe ke nīche lagāe gae. Un meṅ wuh lakaṛiyāṅ ḍālnī thīṅ jin se mez ko uṭhānā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Bazliyel ne yih lakaṛiyāṅ bhī kīkar se banāīṅ aur un par sonā chaṛhāyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Āḳhirkār us ne ḳhālis sone ke wuh thāl, pyāle, mai kī nazareṅ pesh karne ke bartan aur martabān banāe jo us par rakhe jāte the. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Phir Bazliyel ne ḳhālis sone kā shamādān banāyā. Us kā pāyā aur ḍanḍī ghaṛ kar banāe gae. Us kī pyāliyāṅ jo phūloṅ aur kaliyoṅ kī shakl kī thīṅ pāe aur ḍanḍī ke sāth ek hī ṭukṛā thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Ḍanḍī se dāīṅ aur bāīṅ taraf tīn tīn shāḳheṅ nikaltī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Har shāḳh par tīn pyāliyāṅ lagī thīṅ jo bādām kī kaliyoṅ aur phūloṅ kī shakl kī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Shamādān kī ḍanḍī par bhī is qism kī pyāliyāṅ lagī thīṅ, lekin tādād meṅ chār. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","In meṅ se tīn pyāliyāṅ dāeṅ bāeṅ kī chhih shāḳhoṅ ke nīche lagī thīṅ. Wuh yoṅ lagī thīṅ ki har pyālī se do shāḳheṅ nikaltī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Shāḳheṅ aur pyāliyāṅ balki pūrā shamādān ḳhālis sone ke ek hī ṭukṛe se ghaṛ kar banāyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Bazliyel ne shamādān ke lie ḳhālis sone ke sāt charāġh banāe. Us ne battī katarne kī qainchiyāṅ aur jalte koele ke lie chhoṭe bartan bhī ḳhālis sone se banāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Shamādān aur us ke tamām sāmān ke lie pūre 34 kilogrām ḳhālis sonā istemāl huā. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Bazliyel ne kīkar kī lakaṛī kī qurbāngāh banāī jo baḳhūr jalāne ke lie thī. Wuh ḍeṛh fuṭ lambī, itnī hī chauṛī aur tīn fuṭ ūṅchī thī. Us ke chār konoṅ meṅ se sīṅg nikalte the jo qurbāngāh ke sāth ek hī ṭukṛe se banāe gae the. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Us kī ūpar kī satah, us ke chār pahluoṅ aur us ke sīṅgoṅ par ḳhālis sonā chaṛhāyā gayā. Ūpar kī satah ke irdgird Bazliyel ne sone kī jhālar banāī. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Sone ke do kaṛe banā kar us ne unheṅ is jhālar ke nīche ek dūsre ke muqābil pahluoṅ par lagāyā. In kaṛoṅ meṅ qurbāngāh ko uṭhāne kī lakaṛiyāṅ ḍālī gaīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Yih lakaṛiyāṅ kīkar kī thīṅ, aur un par bhī sonā chaṛhāyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Bazliyel ne masah karne kā muqaddas tel aur ḳhushbūdār ḳhālis baḳhūr bhī banāyā. Yih itarsāz kā kām thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bazliyel ne kīkar kī lakaṛī kī ek aur qurbāngāh banāī jo bhasm hone wālī qurbāniyoṅ ke lie thī. Us kī ūṅchāī sāṛhe chār fuṭ, us kī lambāī aur chauṛāī sāṛhe sāt sāt fuṭ thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Us ke ūpar chāroṅ konoṅ meṅ se sīṅg nikalte the. Sīṅg aur qurbāngāh ek hī ṭukṛe ke the, aur us par pītal chaṛhāyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Us kā tamām sāz-o-sāmān aur bartan bhī pītal ke the yānī rākh ko uṭhā kar le jāne kī bālṭiyāṅ, belche, kāṅṭe, jalte hue koele ke lie bartan aur chhiṛkāw ke kaṭore. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Qurbāngāh ko uṭhāne ke lie us ne pītal kā janglā banāyā. Wuh ūpar se khulā thā aur yoṅ banāyā gayā ki jab qurbāngāh us meṅ rakhī jāe to wuh us kināre tak pahuṅche jo qurbāngāh kī ādhī ūṅchāī par lagī thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Us ne qurbāngāh ko uṭhāne ke lie chār kaṛe banā kar unheṅ jangle ke chār konoṅ par lagāyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Phir us ne kīkar kī do lakaṛiyāṅ banā kar un par pītal chaṛhāyā ");
INSERT INTO urdgvr_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","aur qurbāngāh ke donoṅ taraf lage in kaṛoṅ meṅ ḍāl dīṅ. Yoṅ use uṭhāyā jā saktā thā. Qurbāngāh lakaṛī kī thī lekin khokhlī thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Bazliyel ne dhone kā hauz aur us kā ḍhāṅchā bhī pītal se banāyā. Us kā pītal un auratoṅ ke āīnoṅ se milā thā jo mulāqāt ke ḳhaime ke darwāze par ḳhidmat kartī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Phir Bazliyel ne sahan banāyā. Us kī chārdīwārī bārīk katān ke kapṛe se banāī gaī. Chārdīwārī kī lambāī junūb kī taraf 150 fuṭ thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Kapṛe ko lagāne ke lie chāṅdī kī hukeṅ, paṭṭiyāṅ, lakaṛī ke khambe aur un ke pāe banāe gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Chārdīwārī shimāl kī taraf bhī isī tarah banāī gaī. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ḳhaime ke pīchhe maġhrib kī taraf chārdīwārī kī chauṛāī 75 fuṭ thī. Kapṛe ke alāwā us ke lie 10 khambe, 10 pāe aur kapṛā lagāne ke lie chāṅdī kī hukeṅ aur paṭṭiyāṅ banāī gaīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Sāmne, mashriq kī taraf jahāṅ se sūraj tulū hotā hai chārdīwārī kī chauṛāī bhī 75 fuṭ thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Kapṛā darwāze ke dāīṅ taraf sāṛhe 22 fuṭ chauṛā thā aur us ke bāīṅ taraf bhī utnā hī chauṛā. Use donoṅ taraf tīn tīn khamboṅ ke sāth lagāyā gayā jo pītal ke pāiyoṅ par khaṛe the. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Chārdīwārī ke tamām pardoṅ ke lie bārīk katān istemāl huā. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Khambe pītal ke pāiyoṅ par khaṛe the, aur parde chāṅdī kī hukoṅ aur paṭṭiyoṅ se khamboṅ ke sāth lage the. Khamboṅ ke ūpar ke siroṅ par chāṅdī chaṛhāī gaī thī. Sahan ke tamām khamboṅ par chāṅdī kī paṭṭiyāṅ lagī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Chārdīwārī ke darwāze kā pardā nīle, arġhawānī aur qirmizī rang ke dhāge aur bārīk katān se banāyā gayā, aur us par kaṛhāī kā kām kiyā gayā. Wuh 30 fuṭ chauṛā aur chārdīwārī ke dūsre pardoṅ kī tarah sāṛhe sāt fuṭ ūṅchā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Us ke chār khambe aur pītal ke chār pāe the. Us kī hukeṅ aur paṭṭiyāṅ chāṅdī kī thīṅ, aur khamboṅ ke ūpar ke siroṅ par chāṅdī chaṛhāī gaī thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Ḳhaime aur chārdīwārī kī tamām meḳheṅ pītal kī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Zail meṅ us sāmān kī fahrist hai jo maqdis kī tāmīr ke lie istemāl huā. Mūsā ke hukm par imām-e-āzam Hārūn ke beṭe Itamar ne Lāwiyoṅ kī mārifat yih fahrist taiyār kī. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","(Yahūdāh ke qabīle ke Bazliyel bin Ūrī bin Hūr ne wuh sab kuchh banāyā jo Rab ne Mūsā ko batāyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Us ke sāth Dān ke qabīle kā Uhliyāb bin Aḳhīsamak thā jo kārīgarī ke har kām aur kaṛhāī ke kām meṅ māhir thā. Wuh nīle, arġhawānī aur qirmizī rang ke dhāge aur bārīk katān se kapṛā banāne meṅ bhī māhir thā.) ");
INSERT INTO urdgvr_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Us sone kā wazn jo logoṅ ke hadiyoṅ se jamā huā aur maqdis kī tāmīr ke lie istemāl huā taqrīban 1,000 kilogrām thā. (Use maqdis ke bāṭoṅ ke hisāb se tolā gayā.) ");
INSERT INTO urdgvr_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Tāmīr ke lie chāṅdī jo mardumshumārī ke hisāb se wasūl huī, us kā wazn taqrīban 3,430 kilogrām thā. (Use bhī maqdis ke bāṭoṅ ke hisāb se tolā gayā.) ");
INSERT INTO urdgvr_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Jin mardoṅ kī umr 20 sāl yā is se zāyd thī unheṅ chāṅdī kā ādhā ādhā sikkā denā paṛā. Mardoṅ kī kul tādād 6,03,550 thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Chūṅki dīwāroṅ ke taḳhtoṅ ke pāe aur Muqaddastarīn Kamre ke darwāze ke satūnoṅ ke pāe chāṅdī ke the is lie taqrīban pūrī chāṅdī in 100 pāiyoṅ ke lie sarf huī. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Taqrīban 30 kilogrām chāṅdī bach gaī. Is se chārdīwārī ke khamboṅ kī hukeṅ aur paṭṭiyāṅ banāī gaīṅ, aur yih khamboṅ ke ūpar ke siroṅ par bhī chaṛhāī gaī. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Jo pītal hadiyoṅ se jamā huā us kā wazn taqrīban 2,425 kilogrām thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ḳhaime ke darwāze ke pāe, jānwaroṅ ko chaṛhāne kī qurbāngāh, us kā janglā, bartan aur sāz-o-sāmān, ");
INSERT INTO urdgvr_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","chārdīwārī ke pāe, sahan ke darwāze ke pāe aur ḳhaime aur chārdīwārī kī tamām meḳheṅ isī se banāī gaīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Bazliyel kī hidāyat par kārīgaroṅ ne nīle, arġhawānī aur qirmizī rang kā dhāgā le kar maqdis meṅ ḳhidmat ke lie libās banāe. Unhoṅ ne Hārūn ke muqaddas kapṛe un hidāyāt ke ain mutābiq banāe jo Rab ne Mūsā ko dī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Unhoṅ ne imām-e-āzam kā bālāposh banāne ke lie sonā, nīle, arġhawānī aur qirmizī rang kā dhāgā aur bārīk katān istemāl kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Unhoṅ ne sone ko kūṭ kūṭ kar warq banāyā aur phir use kāṭ kar dhāge banāe. Jab nīle, arġhawānī aur qirmizī rang ke dhāge aur bārīk katān se kapṛā banāyā gayā to sone kā yih dhāgā mahārat se kaṛhāī ke kām meṅ istemāl huā. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Unhoṅ ne bālāposh ke lie do paṭṭiyāṅ banāīṅ aur unheṅ bālāposh ke kandhoṅ par rakh kar sāmne aur pīchhe se bālāposh ke sāth lagāīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Paṭkā bhī banāyā gayā jis se bālāposh ko bāndhā jātā thā. Is ke lie bhī sonā, nīle, arġhawānī aur qirmizī rang kā dhāgā aur bārīk katān istemāl huā. Yih un hidāyāt ke ain mutābiq huā jo Rab ne Mūsā ko dī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Phir unhoṅ ne aqīq-e-ahmar ke do patthar chun lie aur unheṅ sone ke ḳhānoṅ meṅ jaṛ kar un par Isrāīl ke bārah beṭoṅ ke nām kandā kie. Yih nām jauharoṅ par us tarah kandā kie gae jis tarah muhr kandā kī jātī hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Unhoṅ ne pattharoṅ ko bālāposh kī do paṭṭiyoṅ par yoṅ lagāyā ki wuh Hārūn ke kandhoṅ par Rab ko Isrāīliyoṅ kī yād dilāte raheṅ. Yih sab kuchh Rab kī dī gaī hidāyāt ke ain mutābiq huā. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Is ke bād unhoṅ ne sīne kā kīsā banāyā. Yih māhir kārīgar kā kām thā aur unhīṅ chīzoṅ se banā jin se Hārūn kā bālāposh bhī banā thā yānī sone aur nīle, arġhawānī aur qirmizī rang ke dhāge aur bārīk katān se. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Jab kapṛe ko ek dafā tah kiyā gayā to kīse kī lambāī aur chauṛāī nau nau inch thī. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Unhoṅ ne us par chār qatāroṅ meṅ jawāhar jaṛe. Har qatār meṅ tīn tīn jauhar the. Pahlī qatār meṅ lāl, zabarjad aur zumurrad. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Dūsrī meṅ fīrozā, sang-e-lājaward aur hajrul-qamar. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Tīsrī meṅ zarqon, aqīq aur yāqūt-e-arġhawānī. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Chauthī meṅ pukhrāj, aqīq-e-ahmar aur yashab. Har jauhar sone ke ḳhāne meṅ jaṛā huā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Yih bārah jawāhar Isrāīl ke bārah qabīloṅ kī numāindagī karte the. Ek ek jauhar par ek qabīle kā nām kandā kiyā gayā, aur yih nām us tarah kandā kie gae jis tarah muhr kandā kī jātī hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ab unhoṅ ne sīne ke kīse ke lie ḳhālis sone kī do zanjīreṅ banāīṅ jo ḍorī kī tarah gundhī huī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Sāth sāth unhoṅ ne sone ke do ḳhāne aur do kaṛe bhī banāe. Unhoṅ ne yih kaṛe kīse ke ūpar ke do konoṅ par lagāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Phir donoṅ zanjīreṅ un do kaṛoṅ ke sāth lagāī gaīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Un ke dūsre sire bālāposh kī kandhoṅ wālī paṭṭiyoṅ ke do ḳhānoṅ ke sāth joṛ die gae. Phir sāmne kī taraf lagāe gae. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Unhoṅ ne kīse ke nichle do konoṅ par bhī sone ke do kaṛe lagāe. Wuh andar, bālāposh kī taraf lage the. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ab unhoṅ ne do aur kaṛe banā kar bālāposh kī kandhoṅ wālī paṭṭiyoṅ par lagāe. Yih bhī sāmne kī taraf lage the lekin nīche, bālāposh ke paṭke ke ūpar hī. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Unhoṅ ne sīne ke kīse ke nichle kaṛe nīlī ḍorī se bālāposh ke in nichle kaṛoṅ ke sāth bāndhe. Yoṅ kīsā paṭke ke ūpar achchhī tarah sīne ke sāth lagā rahā. Yih un hidāyāt ke ain mutābiq huā jo Rab ne Mūsā ko dī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Phir kārīgaroṅ ne choġhā bunā. Wuh pūrī tarah nīle dhāge se banāyā gayā. Choġhe ko bālāposh se pahle pahnanā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Us ke garebān ko bune hue kālar se mazbūt kiyā gayā tāki wuh na phaṭe. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Unhoṅ ne nīle, arġhawānī aur qirmizī rang ke dhāge se anār banā kar unheṅ choġhe ke dāman meṅ lagā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Un ke darmiyān ḳhālis sone kī ghanṭiyāṅ lagāī gaīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Dāman meṅ anār aur ghanṭiyāṅ bārī bārī lagāī gaīṅ. Lāzim thā ki Hārūn ḳhidmat karne ke lie hameshā yih choġhā pahne. Rab ne Mūsā ko yihī hukm diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Kārīgaroṅ ne Hārūn aur us ke beṭoṅ ke lie bārīk katān ke zerjāme banāe. Yih bunane wāle kā kām thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Sāth sāth unhoṅ ne bārīk katān kī pagaṛiyāṅ aur bārīk katān ke pājāme banāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Kamarband ko bārīk katān aur nīle, arġhawānī aur qirmizī rang ke dhāge se banāyā gayā. Kaṛhāī karne wāloṅ ne is par kām kiyā. Sab kuchh un hidāyāt ke mutābiq banāyā gayā jo Rab ne Mūsā ko dī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Unhoṅ ne muqaddas tāj yānī ḳhālis sone kī taḳhtī banāī aur us par yih alfāz kandā kie, ‘Rab ke lie Maḳhsūs-o-Muqaddas.’ ");
INSERT INTO urdgvr_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Phir unhoṅ ne ise nīlī ḍorī se pagaṛī ke sāmne wāle hisse se lagā diyā. Yih bhī un hidāyāt ke mutābiq banāyā gayā jo Rab ne Mūsā ko dī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Āḳhirkār maqdis kā kām mukammal huā. Isrāīliyoṅ ne sab kuchh un hidāyāt ke mutābiq banāyā thā jo Rab ne Mūsā ko dī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Wuh maqdis kī tamām chīzeṅ Mūsā ke pās le āe yānī muqaddas ḳhaimā aur us kā sārā sāmān, us kī hukeṅ, dīwāroṅ ke taḳhte, shahtīr, satūn aur pāe, ");
INSERT INTO urdgvr_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ḳhaime par menḍhoṅ kī surḳh rangī huī khāloṅ kā ġhilāf aur taḳhas kī khāloṅ kā ġhilāf, Muqaddastarīn Kamre ke darwāze kā pardā, ");
INSERT INTO urdgvr_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ahd kā sandūq jis meṅ sharīat kī taḳhtiyāṅ rakhnī thīṅ, use uṭhāne kī lakaṛiyāṅ aur us kā ḍhaknā, ");
INSERT INTO urdgvr_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","maḳhsūs roṭiyoṅ kī mez, us kā sārā sāmān aur roṭiyāṅ, ");
INSERT INTO urdgvr_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ḳhālis sone kā shamādān aur us par rakhne ke charāġh us ke sāre sāmān samet, shamādān ke lie tel, ");
INSERT INTO urdgvr_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","baḳhūr jalāne kī sone kī qurbāngāh, masah kā tel, ḳhushbūdār baḳhūr, muqaddas ḳhaime ke darwāze kā pardā, ");
INSERT INTO urdgvr_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","jānwaroṅ ko chaṛhāne kī pītal kī qurbāngāh, us kā pītal kā janglā, use uṭhāne kī lakaṛiyāṅ aur bāqī sārā sāmān, dhone kā hauz aur wuh ḍhāṅchā jis par hauz rakhnā thā, ");
INSERT INTO urdgvr_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","chārdīwārī ke parde un ke khamboṅ aur pāiyoṅ samet, sahan ke darwāze kā pardā, chārdīwārī ke rasse aur meḳheṅ, mulāqāt ke ḳhaime meṅ ḳhidmat karne kā bāqī sārā sāmān ");
INSERT INTO urdgvr_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","aur maqdis meṅ ḳhidmat karne ke wuh muqaddas libās jo Hārūn aur us ke beṭoṅ ko pahnane the. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Sab kuchh un hidāyāt ke mutābiq banāyā gayā thā jo Rab ne Mūsā ko dī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mūsā ne tamām chīzoṅ kā muāynā kiyā aur mālūm kiyā ki unhoṅ ne sab kuchh Rab kī hidāyāt ke mutābiq banāyā thā. Tab us ne unheṅ barkat dī. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Phir Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Pahle mahīne kī pahlī tārīḳh ko mulāqāt kā ḳhaimā khaṛā karnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ahd kā sandūq jis meṅ sharīat kī taḳhtiyāṅ haiṅ Muqaddastarīn Kamre meṅ rakh kar us ke darwāze kā pardā lagānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Is ke bād maḳhsūs roṭiyoṅ kī mez Muqaddas Kamre meṅ lā kar us par tamām zarūrī sāmān rakhnā. Us kamre meṅ shamādān bhī le ānā aur us par us ke charāġh rakhnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Baḳhūr kī sone kī qurbāngāh us parde ke sāmne rakhnā jis ke pīchhe ahd kā sandūq hai. Phir ḳhaime meṅ dāḳhil hone ke darwāze par pardā lagānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Jānwaroṅ ko chaṛhāne kī qurbāngāh sahan meṅ ḳhaime ke darwāze ke sāmne rakhī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ḳhaime aur is qurbāngāh ke darmiyān dhone kā hauz rakh kar us meṅ pānī ḍālnā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Sahan kī chārdīwārī khaṛī karke us ke darwāze kā pardā lagānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Phir masah kā tel le kar use ḳhaime aur us ke sāre sāmān par chhiṛak denā. Yoṅ tū use mere lie maḳhsūs karegā aur wuh muqaddas hogā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Phir jānwaroṅ ko chaṛhāne kī qurbāngāh aur us ke sāmān par masah kā tel chhiṛaknā. Yoṅ tū use mere lie maḳhsūs karegā aur wuh nihāyat muqaddas hogā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Isī tarah hauz aur us ḍhāṅche ko bhī maḳhsūs karnā jis par hauz rakhā gayā hai. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Hārūn aur us ke beṭoṅ ko mulāqāt ke ḳhaime ke darwāze par lā kar ġhusl karānā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Phir Hārūn ko muqaddas libās pahnānā aur use masah karke mere lie maḳhsūs-o-muqaddas karnā tāki imām ke taur par merī ḳhidmat kare. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Us ke beṭoṅ ko lā kar unheṅ zerjāme pahnā denā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Unheṅ un ke wālid kī tarah masah karnā tāki wuh bhī imāmoṅ ke taur par merī ḳhidmat kareṅ. Jab unheṅ masah kiyā jāegā to wuh aur bād meṅ un kī aulād hameshā tak maqdis meṅ is ḳhidmat ke lie maḳhsūs hoṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mūsā ne sab kuchh Rab kī hidāyāt ke mutābiq kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Pahle mahīne kī pahlī tārīḳh ko muqaddas ḳhaimā khaṛā kiyā gayā. Unheṅ Misr se nikle pūrā ek sāl ho gayā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mūsā ne dīwār ke taḳhtoṅ ko un ke pāiyoṅ par khaṛā karke un ke sāth shahtīr lagāe. Isī tarah us ne satūnoṅ ko bhī khaṛā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Us ne Rab kī hidāyāt ke ain mutābiq dīwāroṅ par kapṛe kā ḳhaimā lagāyā aur us par dūsre ġhilāf rakhe. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Us ne sharīat kī donoṅ taḳhtiyāṅ le kar ahd ke sandūq meṅ rakh dīṅ, uṭhāne ke lie lakaṛiyāṅ sandūq ke kaṛoṅ meṅ ḍāl dīṅ aur kaffāre kā ḍhaknā us par lagā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Phir us ne Rab kī hidāyāt ke ain mutābiq sandūq ko Muqaddastarīn Kamre meṅ rakh kar us ke darwāze kā pardā lagā diyā. Yoṅ ahd ke sandūq par pardā paṛā rahā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Mūsā ne maḳhsūs roṭiyoṅ kī mez Muqaddas Kamre ke shimālī hisse meṅ us parde ke sāmne rakh dī jis ke pīchhe ahd kā sandūq thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Us ne Rab kī hidāyat ke ain mutābiq Rab ke lie maḳhsūs kī huī roṭiyāṅ mez par rakhīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Usī kamre ke junūbī hisse meṅ us ne shamādān ko mez ke muqābil rakh diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Us par us ne Rab kī hidāyat ke ain mutābiq Rab ke sāmne charāġh rakh die. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Us ne baḳhūr kī sone kī qurbāngāh bhī usī kamre meṅ rakhī, us parde ke bilkul sāmne jis ke pīchhe ahd kā sandūq thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Us ne us par Rab kī hidāyat ke ain mutābiq ḳhushbūdār baḳhūr jalāyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Phir us ne ḳhaime kā darwāzā lagā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Bāhar jā kar us ne jānwaroṅ ko chaṛhāne kī qurbāngāh ḳhaime ke darwāze ke sāmne rakh dī. Us par us ne Rab kī hidāyat ke ain mutābiq bhasm hone wālī qurbāniyāṅ aur ġhallā kī nazareṅ chaṛhāīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Us ne dhone ke hauz ko ḳhaime aur us qurbāngāh ke darmiyān rakh kar us meṅ pānī ḍāl diyā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mūsā, Hārūn aur us ke beṭe use apne hāth-pāṅw dhone ke lie istemāl karte the. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Jab bhī wuh mulāqāt ke ḳhaime meṅ dāḳhil hote yā jānwaroṅ ko chaṛhāne kī qurbāngāh ke pās āte to Rab kī hidāyat ke ain mutābiq pahle ġhusl karte. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Āḳhir meṅ Mūsā ne ḳhaimā, qurbāngāh aur chārdīwārī khaṛī karke sahan ke darwāze kā pardā lagā diyā. Yoṅ Mūsā ne maqdis kī tāmīr mukammal kī. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Phir mulāqāt ke ḳhaime par bādal chhā gayā aur maqdis Rab ke jalāl se bhar gayā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mūsā ḳhaime meṅ dāḳhil na ho sakā, kyoṅki bādal us par ṭhahrā huā thā aur maqdis Rab ke jalāl se bhar gayā thā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Tamām safr ke daurān jab bhī maqdis ke ūpar se bādal uṭhtā to Isrāīlī safr ke lie taiyār ho jāte. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Agar wuh na uṭhtā to wuh us waqt tak ṭhahre rahte jab tak bādal uṭh na jātā. ");
INSERT INTO urdgvr_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Din ke waqt bādal maqdis ke ūpar ṭhahrā rahtā aur rāt ke waqt wuh tamām Isrāīliyoṅ ko āg kī sūrat meṅ nazar ātā thā. Yih silsilā pūre safr ke daurān jārī rahā. ");
INSERT INTO urdgvr_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Rab ne mulāqāt ke ḳhaime meṅ se Mūsā ko bulā kar kahā ");
INSERT INTO urdgvr_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","ki Isrāīliyoṅ ko ittalā de, “Agar tum meṅ se koī Rab ko qurbānī pesh karnā chāhe to wuh apne gāy-bailoṅ yā bheṛ-bakriyoṅ meṅ se jānwar chun le. ");
INSERT INTO urdgvr_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Agar wuh apne gāy-bailoṅ meṅ se bhasm hone wālī qurbānī chaṛhānā chāhe to wuh beaib bail chun kar use mulāqāt ke ḳhaime ke darwāze par pesh kare tāki Rab use qabūl kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Qurbānī pesh karne wālā apnā hāth jānwar ke sar par rakhe to yih qurbānī maqbūl ho kar us kā kaffārā degī. ");
INSERT INTO urdgvr_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Qurbānī pesh karne wālā bail ko wahāṅ Rab ke sāmne zabah kare. Phir Hārūn ke beṭe jo imām haiṅ us kā ḳhūn Rab ko pesh karke use darwāze par kī qurbāngāh ke chār pahluoṅ par chhiṛkeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Is ke bād qurbānī pesh karne wālā khāl utār kar jānwar ke ṭukṛe ṭukṛe kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Imām qurbāngāh par āg lagā kar us par tartīb se lakaṛiyāṅ chuneṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Us par wuh jānwar ke ṭukṛe sar aur charbī samet rakheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Lāzim hai ki qurbānī pesh karne wālā pahle jānwar kī antaṛiyāṅ aur pinḍliyāṅ dhoe, phir imām pūre jānwar ko qurbāngāh par jalā de. Is jalne wālī qurbānī kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Agar bhasm hone wālī qurbānī bheṛ-bakriyoṅ meṅ se chunī jāe to wuh beaib nar ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Pesh karne wālā use Rab ke sāmne qurbāngāh kī shimālī simt meṅ zabah kare. Phir Hārūn ke beṭe jo imām haiṅ us kā ḳhūn qurbāngāh ke chār pahluoṅ par chhiṛkeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Is ke bād pesh karne wālā jānwar ke ṭukṛe ṭukṛe kare aur imām yih ṭukṛe sar aur charbī samet qurbāngāh kī jaltī huī lakaṛiyoṅ par tartīb se rakhe. ");
INSERT INTO urdgvr_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Lāzim hai ki qurbānī pesh karne wālā pahle jānwar kī antaṛiyāṅ aur pinḍliyāṅ dhoe, phir imām pūre jānwar ko Rab ko pesh karke qurbāngāh par jalā de. Is jalne wālī qurbānī kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Agar bhasm hone wālī qurbānī parindā ho to wuh qumrī yā jawān kabūtar ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Imām use qurbāngāh ke pās le āe aur us kā sar maroṛ kar qurbāngāh par jalā de. Wuh us kā ḳhūn yoṅ nikalne de ki wuh qurbāngāh kī ek taraf se nīche ṭapke. ");
INSERT INTO urdgvr_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Wuh us kā poṭā aur jo us meṅ hai dūr karke qurbāngāh kī mashriqī simt meṅ phaiṅk de, wahāṅ jahāṅ rākh phaiṅkī jātī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Use pesh karte waqt imām us ke par pakaṛ kar parinde ko phāṛ ḍāle, lekin yoṅ ki wuh bilkul ṭukṛe ṭukṛe na ho jāe. Phir imām use qurbāngāh par jaltī huī lakaṛiyoṅ par jalā de. Is jalne wālī qurbānī kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Agar koī Rab ko ġhallā kī nazar pesh karnā chāhe to wuh is ke lie behtarīn maidā istemāl kare. Us par wuh zaitūn kā tel unḍele aur lubān rakh kar ");
INSERT INTO urdgvr_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","use Hārūn ke beṭoṅ ke pās le āe jo imām haiṅ. Imām tel se milāyā gayā muṭṭhī-bhar maidā aur tamām lubān le kar qurbāngāh par jalā de. Yih yādgār kā hissā hai, aur us kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Bāqī maidā aur tel Hārūn aur us ke beṭoṅ kā hissā hai. Wuh Rab kī jalne wālī qurbāniyoṅ meṅ se ek nihāyat muqaddas hissā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Agar yih qurbānī tanūr meṅ pakāī huī roṭī ho to us meṅ ḳhamīr na ho. Is kī do qismeṅ ho saktī haiṅ, roṭiyāṅ jo behtarīn maide aur tel se banī huī hoṅ aur roṭiyāṅ jin par tel lagāyā gayā ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Agar yih qurbānī tawe par pakāī huī roṭī ho to wuh behtarīn maide aur tel kī ho. Us meṅ ḳhamīr na ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Chūṅki wuh ġhallā kī nazar hai is lie roṭī ko ṭukṛe ṭukṛe karnā aur us par tel ḍālnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Agar yih qurbānī kaṛāhī meṅ pakāī huī roṭī ho to wuh behtarīn maide aur tel kī ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Agar tū in chīzoṅ kī banī huī ġhallā kī nazar Rab ke huzūr lānā chāhe to use imām ko pesh karnā. Wuhī use qurbāngāh ke pās le āe. ");
INSERT INTO urdgvr_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Phir imām yādgār kā hissā alag karke use qurbāngāh par jalā de. Aisī qurbānī kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Qurbānī kā bāqī hissā Hārūn aur us ke beṭoṅ ke lie hai. Wuh Rab kī jalne wālī qurbāniyoṅ meṅ se ek nihāyat muqaddas hissā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Ġhallā kī jitnī nazareṅ tum Rab ko pesh karte ho un meṅ ḳhamīr na ho, kyoṅki lāzim hai ki tum Rab ko jalne wālī qurbānī pesh karte waqt na ḳhamīr, na shahd jalāo. ");
INSERT INTO urdgvr_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Yih chīzeṅ fasal ke pahle phaloṅ ke sāth Rab ko pesh kī jā saktī haiṅ, lekin unheṅ qurbāngāh par na jalāyā jāe, kyoṅki wahāṅ Rab ko un kī ḳhushbū pasand nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Ġhallā kī har nazar meṅ namak ho, kyoṅki namak us ahd kī numāindagī kartā hai jo tere Ḳhudā ne tere sāth bāndhā hai. Tujhe har qurbānī meṅ namak ḍālnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Agar tū ġhallā kī nazar ke lie fasal ke pahle phal pesh karnā chāhe to kuchlī huī kachchī bāliyāṅ bhūn kar pesh karnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Chūṅki wuh ġhallā kī nazar hai is lie us par tel unḍelnā aur lubān rakhnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Kuchle hue dānoṅ aur tel kā jo hissā Rab kā hai yānī yādgār kā hissā use imām tamām lubān ke sāth jalā de. Yih nazar Rab ke lie jalne wālī qurbānī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Agar koī Rab ko salāmatī kī qurbānī pesh karne ke lie gāy yā bail chaṛhānā chāhe to wuh jānwar beaib ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Wuh apnā hāth jānwar ke sar par rakh kar use mulāqāt ke ḳhaime ke darwāze par zabah kare. Hārūn ke beṭe jo imām haiṅ us kā ḳhūn qurbāngāh ke chār pahluoṅ par chhiṛkeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","4","Pesh karne wālā antaṛiyoṅ par kī sārī charbī, gurde us charbī samet jo un par aur kamr ke qarīb hotī hai aur joṛkalejī jalne wālī qurbānī ke taur par Rab ko pesh kare. In chīzoṅ ko gurdoṅ ke sāth hī alag karnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Phir Hārūn ke beṭe yih sab kuchh bhasm hone wālī qurbānī ke sāth qurbāngāh kī lakaṛiyoṅ par jalā deṅ. Yih jalne wālī qurbānī hai, aur is kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Agar salāmatī kī qurbānī ke lie bheṛ-bakriyoṅ meṅ se jānwar chunā jāe to wuh beaib nar yā mādā ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Agar wuh bheṛ kā bachchā chaṛhānā chāhe to wuh use Rab ke sāmne le āe. ");
INSERT INTO urdgvr_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Wuh apnā hāth us ke sar par rakh kar use mulāqāt ke ḳhaime ke sāmne zabah kare. Hārūn ke beṭe us kā ḳhūn qurbāngāh ke chār pahluoṅ par chhiṛkeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","10","Pesh karne wālā charbī, pūrī dum, antaṛiyoṅ par kī sārī charbī, gurde us charbī samet jo un par aur kamr ke qarīb hotī hai aur joṛkalejī jalne wālī qurbānī ke taur par Rab ko pesh kare. In chīzoṅ ko gurdoṅ ke sāth hī alag karnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Imām yih sab kuchh Rab ko pesh karke qurbāngāh par jalā de. Yih ḳhurāk jalne wālī qurbānī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Agar salāmatī kī qurbānī bakrī kī ho ");
INSERT INTO urdgvr_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","to pesh karne wālā us par hāth rakh kar use mulāqāt ke ḳhaime ke sāmne zabah kare. Hārūn ke beṭe jānwar kā ḳhūn qurbāngāh ke chār pahluoṅ par chhiṛkeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","15","Pesh karne wālā antaṛiyoṅ par kī sārī charbī, gurde us charbī samet jo un par aur kamr ke qarīb hotī hai aur joṛkalejī jalne wālī qurbānī ke taur par Rab ko pesh kare. In chīzoṅ ko gurdoṅ ke sāth hī alag karnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Imām yih sab kuchh Rab ko pesh karke qurbāngāh par jalā de. Yih ḳhurāk jalne wālī qurbānī hai, aur is kī ḳhushbū Rab ko pasand hai. Sārī charbī Rab kī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Tumhāre lie ḳhūn yā charbī khānā manā hai. Yih na sirf tumhāre lie manā hai balki tumhārī aulād ke lie bhī, na sirf yahāṅ balki har jagah jahāṅ tum rahte ho.” ");
INSERT INTO urdgvr_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Isrāīliyoṅ ko batānā ki jo bhī ġhairirādī taur par gunāh karke Rab ke kisī hukm ko toṛe wuh yih kare: ");
INSERT INTO urdgvr_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Agar imām-e-āzam gunāh kare aur natīje meṅ pūrī qaum qusūrwār ṭhahre to phir wuh Rab ko ek beaib jawān bail le kar gunāh kī qurbānī ke taur par pesh kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Wuh jawān bail ko mulāqāt ke ḳhaime ke darwāze ke pās le āe aur apnā hāth us ke sar par rakh kar use Rab ke sāmne zabah kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Phir wuh jānwar ke ḳhūn meṅ se kuchh le kar ḳhaime meṅ jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Wahāṅ wuh apnī unglī us meṅ ḍāl kar use sāt bār Rab ke sāmne yānī Muqaddastarīn Kamre ke parde par chhiṛke. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Phir wuh ḳhaime ke andar kī us qurbāngāh ke chāroṅ sīṅgoṅ par ḳhūn lagāe jis par baḳhūr jalāyā jātā hai. Bāqī ḳhūn wuh bāhar ḳhaime ke darwāze par kī us qurbāngāh ke pāe par unḍele jis par jānwar jalāe jāte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Jawān bail kī sārī charbī, antaṛiyoṅ par kī sārī charbī, ");
INSERT INTO urdgvr_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","gurde us charbī samet jo un par aur kamr ke qarīb hotī hai aur joṛkalejī ko gurdoṅ ke sāth hī alag karnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Yih bilkul usī tarah kiyā jāe jis tarah us bail ke sāth kiyā gayā jo salāmatī kī qurbānī ke lie pesh kiyā jātā hai. Imām yih sab kuchh us qurbāngāh par jalā de jis par jānwar jalāe jāte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Lekin wuh us kī khāl, us kā sārā gosht, sar aur pinḍliyāṅ, antaṛiyāṅ aur un kā gobar ");
INSERT INTO urdgvr_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ḳhaimāgāh ke bāhar le jāe. Yih chīzeṅ us pāk jagah par jahāṅ qurbāniyoṅ kī rākh phaiṅkī jātī hai lakaṛiyoṅ par rakh kar jalā denī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Agar Isrāīl kī pūrī jamāt ne ġhairirādī taur par gunāh karke Rab ke kisī hukm se tajāwuz kiyā hai aur jamāt ko mālūm nahīṅ thā to bhī wuh qusūrwār hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Jab logoṅ ko patā lage ki ham ne gunāh kiyā hai to jamāt mulāqāt ke ḳhaime ke pās ek jawān bail le āe aur use gunāh kī qurbānī ke taur par pesh kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Jamāt ke buzurg Rab ke sāmne apne hāth us ke sar par rakheṅ, aur wuh wahīṅ zabah kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Phir imām-e-āzam jānwar ke ḳhūn meṅ se kuchh le kar mulāqāt ke ḳhaime meṅ jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Wahāṅ wuh apnī unglī us meṅ ḍāl kar use sāt bār Rab ke sāmne yānī Muqaddastarīn Kamre ke parde par chhiṛke. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Phir wuh ḳhaime ke andar kī us qurbāngāh ke chāroṅ sīṅgoṅ par ḳhūn lagāe jis par baḳhūr jalāyā jātā hai. Bāqī ḳhūn wuh bāhar ḳhaime ke darwāze kī us qurbāngāh ke pāe par unḍele jis par jānwar jalāe jāte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Is ke bād wuh us kī tamām charbī nikāl kar qurbāngāh par jalā de. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Us bail ke sāth wuh sab kuchh kare jo use apne zātī ġhairirādī gunāh ke lie karnā hotā hai. Yoṅ wuh logoṅ kā kaffārā degā aur unheṅ muāfī mil jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Āḳhir meṅ wuh bail ko ḳhaimāgāh ke bāhar le jā kar us tarah jalā de jis tarah use apne lie bail ko jalā denā hotā hai. Yih jamāt kā gunāh dūr karne kī qurbānī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Agar koī sardār ġhairirādī taur par gunāh karke Rab ke kisī hukm se tajāwuz kare aur yoṅ qusūrwār ṭhahre to ");
INSERT INTO urdgvr_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","jab bhī use patā lage ki mujh se gunāh huā hai to wuh qurbānī ke lie ek beaib bakrā le āe. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Wuh apnā hāth bakre ke sar par rakh kar use wahāṅ zabah kare jahāṅ bhasm hone wālī qurbāniyāṅ zabah kī jātī haiṅ. Yih gunāh kī qurbānī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Imām apnī unglī ḳhūn meṅ ḍāl kar use us qurbāngāh ke chāroṅ sīṅgoṅ par lagāe jis par jānwar jalāe jāte haiṅ. Bāqī ḳhūn wuh qurbāngāh ke pāe par unḍele. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Phir wuh us kī sārī charbī qurbāngāh par us tarah jalā de jis tarah wuh salāmatī kī qurbāniyoṅ kī charbī jalā detā hai. Yoṅ imām us ādmī kā kaffārā degā aur use muāfī hāsil ho jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Agar koī ām shaḳhs ġhairirādī taur par gunāh karke Rab ke kisī hukm se tajāwuz kare aur yoṅ qusūrwār ṭhahre to ");
INSERT INTO urdgvr_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","jab bhī use patā lage ki mujh se gunāh huā hai to wuh qurbānī ke lie ek beaib bakrī le āe. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Wuh apnā hāth bakrī ke sar par rakh kar use wahāṅ zabah kare jahāṅ bhasm hone wālī qurbāniyāṅ zabah kī jātī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Imām apnī unglī ḳhūn meṅ ḍāl kar use us qurbāngāh ke chāroṅ sīṅgoṅ par lagāe jis par jānwar jalāe jāte haiṅ. Bāqī ḳhūn wuh qurbāngāh ke pāe par unḍele. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Phir wuh us kī sārī charbī us tarah nikāle jis tarah wuh salāmatī kī qurbāniyoṅ kī charbī nikāltā hai. Is ke bād wuh use qurbāngāh par jalā de. Aisī qurbānī kī ḳhushbū Rab ko pasand hai. Yoṅ imām us ādmī kā kaffārā degā aur use muāfī hāsil ho jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Agar wuh gunāh kī qurbānī ke lie bheṛ kā bachchā lānā chāhe to wuh beaib mādā ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Wuh apnā hāth us ke sar par rakh kar use wahāṅ zabah kare jahāṅ bhasm hone wālī qurbāniyāṅ zabah kī jātī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Imām apnī unglī ḳhūn meṅ ḍāl kar use us qurbāngāh ke chāroṅ sīṅgoṅ par lagāe jis par jānwar jalāe jāte haiṅ. Bāqī ḳhūn wuh qurbāngāh ke pāe par unḍele. ");
INSERT INTO urdgvr_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Phir wuh us kī tamām charbī us tarah nikāle jis tarah salāmatī kī qurbānī ke lie zabah kie gae jawān menḍhe kī charbī nikālī jātī hai. Is ke bād imām charbī ko qurbāngāh par un qurbāniyoṅ samet jalā de jo Rab ke lie jalāī jātī haiṅ. Yoṅ imām us ādmī kā kaffārā degā aur use muāfī mil jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Ho saktā hai ki kisī ne yoṅ gunāh kiyā ki us ne koī jurm dekhā yā wuh us ke bāre meṅ kuchh jāntā hai. To bhī jab gawāhoṅ ko qasam ke lie bulāyā jātā hai to wuh gawāhī dene ke lie sāmne nahīṅ ātā. Is sūrat meṅ wuh qusūrwār ṭhahartā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Ho saktā hai ki kisī ne ġhairirādī taur par kisī nāpāk chīz ko chhū liyā hai, ḳhāh wuh kisī janglī jānwar, maweshī yā reṅgne wāle jānwar kī lāsh kyoṅ na ho. Is sūrat meṅ wuh nāpāk hai aur qusūrwār ṭhahartā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ho saktā hai ki kisī ne ġhairirādī taur par kisī shaḳhs kī nāpākī ko chhū liyā hai yānī us kī koī aisī chīz jis se wuh nāpāk ho gayā hai. Jab use mālūm ho jātā hai to wuh qusūrwār ṭhahartā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ho saktā hai ki kisī ne beparwāī se kuchh karne kī qasam khāī hai, chāhe wuh achchhā kām thā yā ġhalat. Jab wuh jān letā hai ki us ne kyā kiyā hai to wuh qusūrwār ṭhahartā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Jo is tarah ke kisī gunāh kī binā par qusūrwār ho, lāzim hai ki wuh apnā gunāh taslīm kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Phir wuh gunāh kī qurbānī ke taur par ek bheṛ yā bakrī pesh kare. Yoṅ imām us kā kaffārā degā. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Agar qusūrwār shaḳhs ġhurbat ke bāis bheṛ yā bakrī na de sake to wuh Rab ko do qumriyāṅ yā do jawān kabūtar pesh kare, ek gunāh kī qurbānī ke lie aur ek bhasm hone wālī qurbānī ke lie. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Wuh unheṅ imām ke pās le āe. Imām pahle gunāh kī qurbānī ke lie parindā pesh kare. Wuh us kī gardan maroṛ ḍāle lekin aise ki sar judā na ho jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Phir wuh us ke ḳhūn meṅ se kuchh qurbāngāh ke ek pahlū par chhiṛke. Bāqī ḳhūn wuh yoṅ nikalne de ki wuh qurbāngāh ke pāe par ṭapke. Yih gunāh kī qurbānī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Phir imām dūsre parinde ko qawāyd ke mutābiq bhasm hone wālī qurbānī ke taur par pesh kare. Yoṅ imām us ādmī kā kaffārā degā aur use muāfī mil jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Agar wuh shaḳhs ġhurbat ke bāis do qumriyāṅ yā do jawān kabūtar bhī na de sake to phir wuh gunāh kī qurbānī ke lie ḍeṛh kilogrām behtarīn maidā pesh kare. Wuh us par na tel unḍele, na lubān rakhe, kyoṅki yih ġhallā kī nazar nahīṅ balki gunāh kī qurbānī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Wuh use imām ke pās le āe jo yādgār kā hissā yānī muṭṭhī-bhar un qurbāniyoṅ ke sāth jalā de jo Rab ke lie jalāī jātī haiṅ. Yih gunāh kī qurbānī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Yoṅ imām us ādmī kā kaffārā degā aur use muāfī mil jāegī. Ġhallā kī nazar kī tarah bāqī maidā imām kā hissā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Agar kisī ne be'īmānī karke ġhairirādī taur par Rab kī maḳhsūs aur muqaddas chīzoṅ ke silsile meṅ gunāh kiyā ho, aisā shaḳhs qusūr kī qurbānī ke taur par Rab ko beaib aur qīmat ke lihāz se munāsib menḍhā yā bakrā pesh kare. Us kī qīmat maqdis kī sharh ke mutābiq muqarrar kī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Jitnā nuqsān maqdis ko huā hai utnā hī wuh de. Is ke alāwā wuh mazīd 20 fīsad adā kare. Wuh use imām ko de de aur imām jānwar ko qusūr kī qurbānī ke taur par pesh karke us kā kaffārā de. Yoṅ use muāfī mil jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Agar koī ġhairirādī taur par gunāh karke Rab ke kisī hukm se tajāwuz kare to wuh qusūrwār hai, aur wuh us kā zimmedār ṭhahregā. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Wuh qusūr kī qurbānī ke taur par imām ke pās ek beaib aur qīmat ke lihāz se munāsib menḍhā le āe. Us kī qīmat maqdis kī sharh ke mutābiq muqarrar kī jāe. Phir imām yih qurbānī us gunāh ke lie chaṛhāe jo qusūrwār shaḳhs ne ġhairirādī taur par kiyā hai. Yoṅ use muāfī mil jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Yih qusūr kī qurbānī hai, kyoṅki wuh Rab kā gunāh karke qusūrwār ṭhahrā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Ho saktā hai kisī ne gunāh karke be'īmānī kī hai, masalan us ne apne paṛosī kī koī chīz wāpas nahīṅ kī jo us ke sapurd kī gaī thī yā jo use girwī ke taur par milī thī, yā us ne us kī koī chīz chorī kī, yā us ne kisī se koī chīz chhīn lī, ");
INSERT INTO urdgvr_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","yā us ne kisī kī gumshudā chīz ke bāre meṅ jhūṭ bolā jab use mil gaī, yā us ne qasam khā kar jhūṭ bolā hai, yā is tarah kā koī aur gunāh kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Agar wuh is tarah kā gunāh karke qusūrwār ṭhahre to lāzim hai ki wuh wuhī chīz wāpas kare jo us ne chorī kī yā chhīn lī yā jo us ke sapurd kī gaī yā jo gumshudā ho kar us ke pās ā gaī hai ");
INSERT INTO urdgvr_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","yā jis ke bāre meṅ us ne qasam khā kar jhūṭ bolā hai. Wuh us kā utnā hī wāpas karke 20 fīsad zyādā de. Aur wuh yih sab kuchh us din wāpas kare jab wuh apnī qusūr kī qurbānī pesh kartā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Qusūr kī qurbānī ke taur par wuh ek beaib aur qīmat ke lihāz se munāsib menḍhā imām ke pās le āe aur Rab ko pesh kare. Us kī qīmat maqdis kī sharh ke mutābiq muqarrar kī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Phir imām Rab ke sāmne us kā kaffārā degā to use muāfī mil jāegī.” ");
INSERT INTO urdgvr_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Hārūn aur us ke beṭoṅ ko bhasm hone wālī qurbāniyoṅ ke bāre meṅ zail kī hidāyāt denā: Bhasm hone wālī qurbānī pūrī rāt subah tak qurbāngāh kī us jagah par rahe jahāṅ āg jaltī hai. Āg ko bujhne na denā. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Subah ko imām katān kā libās aur katān kā pājāmā pahan kar qurbānī se bachī huī rākh qurbāngāh ke pās zamīn par ḍāle. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Phir wuh apne kapṛe badal kar rākh ko ḳhaimāgāh ke bāhar kisī pāk jagah par chhoṛ āe. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Qurbāngāh par āg jaltī rahe. Wuh kabhī bhī na bujhe. Har subah imām lakaṛiyāṅ chun kar us par bhasm hone wālī qurbānī tartīb se rakhe aur us par salāmatī kī qurbānī kī charbī jalā de. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Āg hameshā jaltī rahe. Wuh kabhī na bujhne pāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Ġhallā kī nazar ke bāre meṅ hidāyāt yih haiṅ: Hārūn ke beṭe use qurbāngāh ke sāmne Rab ko pesh kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Phir imām yādgār kā hissā yānī tel se milāyā gayā muṭṭhī-bhar behtarīn maidā aur qurbānī kā tamām lubān le kar qurbāngāh par jalā de. Is kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Hārūn aur us ke beṭe qurbānī kā bāqī hissā khā leṅ. Lekin wuh use muqaddas jagah par yānī mulāqāt ke ḳhaime kī chārdīwārī ke andar khāeṅ, aur us meṅ ḳhamīr na ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Use pakāne ke lie us meṅ ḳhamīr na ḍālā jāe. Maiṅ ne jalne wālī qurbāniyoṅ meṅ se yih hissā un ke lie muqarrar kiyā hai. Yih gunāh kī qurbānī aur qusūr kī qurbānī kī tarah nihāyat muqaddas hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Hārūn kī aulād ke tamām mard use khāeṅ. Yih usūl abad tak qāym rahe. Jo bhī use chhuegā wuh maḳhsūs-o-muqaddas ho jāegā.” ");
INSERT INTO urdgvr_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Jab Hārūn aur us ke beṭoṅ ko imām kī zimmedārī uṭhāne ke lie maḳhsūs karke tel se masah kiyā jāegā to wuh ḍeṛh kilogrām behtarīn maidā pesh kareṅ. Us kā ādhā hissā subah ko aur ādhā hissā shām ke waqt pesh kiyā jāe. Wuh ġhallā kī yih nazar rozānā pesh kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Use tel ke sāth milā kar tawe par pakānā hai. Phir use ṭukṛe ṭukṛe karke ġhallā kī nazar ke taur par pesh karnā. Us kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Yih qurbānī hameshā Hārūn kī nasl kā wuh ādmī pesh kare jise masah karke imām-e-āzam kā ohdā diyā gayā hai, aur wuh use pūre taur par Rab ke lie jalā de. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Imām kī ġhallā kī nazar hameshā pūre taur par jalānā. Use na khānā.” ");
INSERT INTO urdgvr_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Hārūn aur us ke beṭoṅ ko gunāh kī qurbānī ke bāre meṅ zail kī hidāyāt denā: Gunāh kī qurbānī ko Rab ke sāmne wahīṅ zabah karnā hai jahāṅ bhasm hone wālī qurbānī zabah kī jātī hai. Wuh nihāyat muqaddas hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Use pesh karne wālā imām use muqaddas jagah par yānī mulāqāt ke ḳhaime kī chārdīwārī ke andar khāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Jo bhī is qurbānī ke gosht ko chhū letā hai wuh maḳhsūs-o-muqaddas ho jātā hai. Agar qurbānī ke ḳhūn ke chhīṅṭe kisī libās par paṛ jāeṅ to use muqaddas jagah par dhonā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Agar gosht ko hanḍiyā meṅ pakāyā gayā ho to us bartan ko bād meṅ toṛ denā hai. Agar us ke lie pītal kā bartan istemāl kiyā gayā ho to use ḳhūb māṅjh kar pānī se sāf karnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Imāmoṅ ke ḳhāndānoṅ meṅ se tamām mard use khā sakte haiṅ. Yih khānā nihāyat muqaddas hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Lekin gunāh kī har wuh qurbānī khāī na jāe jis kā ḳhūn mulāqāt ke ḳhaime meṅ is lie lāyā gayā hai ki maqdis meṅ kisī kā kaffārā diyā jāe. Use jalānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Qusūr kī qurbānī jo nihāyat muqaddas hai us ke bāre meṅ hidāyāt yih haiṅ: ");
INSERT INTO urdgvr_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Qusūr kī qurbānī wahīṅ zabah karnī hai jahāṅ bhasm hone wālī qurbānī zabah kī jātī hai. Us kā ḳhūn qurbāngāh ke chār pahluoṅ par chhiṛkā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Us kī tamām charbī nikāl kar qurbāngāh par chaṛhānī hai yānī us kī dum, antaṛiyoṅ par kī charbī, ");
INSERT INTO urdgvr_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","gurde us charbī samet jo un par aur kamr ke qarīb hotī hai aur joṛkalejī. In chīzoṅ ko gurdoṅ ke sāth hī alag karnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Imām yih sab kuchh Rab ko qurbāngāh par jalne wālī qurbānī ke taur par pesh kare. Yih qusūr kī qurbānī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Imāmoṅ ke ḳhāndānoṅ meṅ se tamām mard use khā sakte haiṅ. Lekin use muqaddas jagah par khāyā jāe. Yih nihāyat muqaddas hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Gunāh aur qusūr kī qurbānī ke lie ek hī usūl hai, jo imām qurbānī ko pesh karke kaffārā detā hai us ko us kā gosht miltā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Is tarah jo imām kisī jānwar ko bhasm hone wālī qurbānī ke taur par chaṛhātā hai usī ko jānwar kī khāl miltī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Aur isī tarah tanūr meṅ, kaṛāhī meṅ yā tawe par pakāī gaī ġhallā kī har nazar us imām ko miltī hai jis ne use pesh kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Lekin Hārūn ke tamām beṭoṅ ko ġhallā kī bāqī nazareṅ barābar barābar miltī raheṅ, ḳhāh un meṅ tel milāyā gayā ho yā wuh ḳhushk hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Salāmatī kī qurbānī jo Rab ko pesh kī jātī hai us ke bāre meṅ zail kī hidāyāt haiṅ: ");
INSERT INTO urdgvr_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Agar koī is qurbānī se apnī shukrguzārī kā izhār karnā chāhe to wuh jānwar ke sāth beḳhamīrī roṭī jis meṅ tel ḍālā gayā ho, beḳhamīrī roṭī jis par tel lagāyā gayā ho aur roṭī jis meṅ behtarīn maidā aur tel milāyā gayā ho pesh kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Is ke alāwā wuh ḳhamīrī roṭī bhī pesh kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Pesh karne wālā qurbānī kī har chīz kā ek hissā uṭhā kar Rab ke lie maḳhsūs kare. Yih us imām kā hissā hai jo jānwar kā ḳhūn qurbāngāh par chhiṛaktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Gosht usī din khāyā jāe jab jānwar ko zabah kiyā gayā ho. Aglī subah tak kuchh nahīṅ bachnā chāhie. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Is qurbānī kā gosht sirf is sūrat meṅ agle din khāyā jā saktā hai jab kisī ne mannat mān kar yā apnī ḳhushī se use pesh kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Agar kuchh gosht tīsre din tak bach jāe to use jalānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Agar use tīsre din bhī khāyā jāe to Rab yih qurbānī qabūl nahīṅ karegā. Us kā koī fāydā nahīṅ hogā balki use nāpāk qarār diyā jāegā. Jo bhī us se khāegā wuh qusūrwār ṭhahregā. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Agar yih gosht kisī nāpāk chīz se lag jāe to use nahīṅ khānā hai balki use jalāyā jāe. Agar gosht pāk hai to har shaḳhs jo ḳhud pāk hai use khā saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Lekin agar nāpāk shaḳhs Rab ko pesh kī gaī salāmatī kī qurbānī kā yih gosht khāe to use us kī qaum meṅ se miṭā ḍālnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ho saktā hai ki kisī ne kisī nāpāk chīz ko chhū liyā hai chāhe wuh nāpāk shaḳhs, jānwar yā koī aur ghinaunī aur nāpāk chīz ho. Agar aisā shaḳhs Rab ko pesh kī gaī salāmatī kī qurbānī kā gosht khāe to use us kī qaum meṅ se miṭā ḍālnā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Isrāīliyoṅ ko batā denā ki gāy-bail aur bheṛ-bakriyoṅ kī charbī khānā tumhāre lie manā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Tum fitrī taur par mare hue jānwaroṅ aur phāṛe hue jānwaroṅ kī charbī dīgar kāmoṅ ke lie istemāl kar sakte ho, lekin use khānā manā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Jo bhī us charbī meṅ se khāe jo jalā kar Rab ko pesh kī jātī hai use us kī qaum meṅ se miṭā ḍālnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Jahāṅ bhī tum rahte ho wahāṅ parindoṅ yā dīgar jānwaroṅ kā ḳhūn khānā manā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Jo bhī ḳhūn khāe use us kī qaum meṅ se miṭāyā jāe.” ");
INSERT INTO urdgvr_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Isrāīliyoṅ ko batānā ki jo Rab ko salāmatī kī qurbānī pesh kare wuh Rab ke lie ek hissā maḳhsūs kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Wuh jalne wālī yih qurbānī apne hāthoṅ se Rab ko pesh kare. Is ke lie wuh jānwar kī charbī aur Sīnā Rab ke sāmne pesh kare. Sīnā hilāne wālī qurbānī ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Imām charbī ko qurbāngāh par jalā de jabki Sīnā Hārūn aur us ke beṭoṅ kā hissā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Qurbānī kī dahnī rān imām ko uṭhāne wālī qurbānī ke taur par dī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Wuh us imām kā hissā hai jo salāmatī kī qurbānī kā ḳhūn aur charbī chaṛhātā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Isrāīliyoṅ kī salāmatī kī qurbāniyoṅ meṅ se maiṅ ne hilāne wālā Sīnā aur uṭhāne wālī rān imāmoṅ ko dī hai. Yih chīzeṅ hameshā ke lie Isrāīliyoṅ kī taraf se imāmoṅ kā haq haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Yih us din jalne wālī qurbāniyoṅ meṅ se Hārūn aur us ke beṭoṅ kā hissā ban gaīṅ jab unheṅ maqdis meṅ Rab kī ḳhidmat meṅ pesh kiyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Rab ne us din jab unheṅ tel se masah kiyā gayā hukm diyā thā ki Isrāīlī yih hissā hameshā imāmoṅ ko diyā kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ġharz yih hidāyāt tamām qurbāniyoṅ ke bāre meṅ haiṅ yānī bhasm hone wālī qurbānī, ġhallā kī nazar, gunāh kī qurbānī, qusūr kī qurbānī, imām ko maqdis meṅ ḳhidmat ke lie maḳhsūs karne kī qurbānī aur salāmatī kī qurbānī ke bāre meṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Rab ne Mūsā ko yih hidāyāt Sīnā Pahāṛ par dīṅ, us din jab us ne Isrāīliyoṅ ko hukm diyā ki wuh Dasht-e-Sīnā meṅ Rab ko apnī qurbāniyāṅ pesh kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Hārūn aur us ke beṭoṅ ko mere huzūr le ānā. Nīz imāmoṅ ke libās, masah kā tel, gunāh kī qurbānī ke lie jawān bail, do menḍhe aur beḳhamīrī roṭiyoṅ kī ṭokrī le ānā. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Phir pūrī jamāt ko ḳhaime ke darwāze par jamā karnā.” ");
INSERT INTO urdgvr_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mūsā ne aisā hī kiyā. Jab pūrī jamāt ikaṭṭhī ho gaī to ");
INSERT INTO urdgvr_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","us ne un se kahā, “Ab maiṅ wuh kuchh kartā hūṅ jis kā hukm Rab ne diyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Mūsā ne Hārūn aur us ke beṭoṅ ko sāmne lā kar ġhusl karāyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Us ne Hārūn ko katān kā zerjāmā pahnā kar kamarband lapeṭā. Phir us ne choġhā pahnāyā jis par us ne bālāposh ko mahārat se bune hue paṭke se bāndhā. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Is ke bād us ne sīne kā kīsā lagā kar us meṅ donoṅ qur'e banām Ūrīm aur Tummīm rakhe. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Phir us ne Hārūn ke sar par pagaṛī rakhī jis ke sāmne wāle hisse par us ne muqaddas tāj yānī sone kī taḳhtī lagā dī. Sab kuchh us hukm ke ain mutābiq huā jo Rab ne Mūsā ko diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Is ke bād Mūsā ne masah ke tel se maqdis ko aur jo kuchh us meṅ thā masah karke use maḳhsūs-o-muqaddas kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Us ne yih tel sāt bār jānwar chaṛhāne kī qurbāngāh aur us ke sāmān par chhiṛak diyā. Isī tarah us ne sāt bār dhone ke hauz aur us ḍhāṅche par tel chhiṛak diyā jis par hauz rakhā huā thā. Yoṅ yih chīzeṅ maḳhsūs-o-muqaddas huīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Us ne Hārūn ke sar par masah kā tel unḍel kar use masah kiyā. Yoṅ wuh maḳhsūs-o-muqaddas huā. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Phir Mūsā ne Hārūn ke beṭoṅ ko sāmne lā kar unheṅ zerjāme pahnāe, kamarband lapeṭe aur un ke saroṅ par pagaṛiyāṅ bāndhīṅ. Sab kuchh us hukm ke ain mutābiq huā jo Rab ne Mūsā ko diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ab Mūsā ne gunāh kī qurbānī ke lie jawān bail ko pesh kiyā. Hārūn aur us ke beṭoṅ ne apne hāth us ke sar par rakhe. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mūsā ne use zabah karke us ke ḳhūn meṅ se kuchh le kar apnī unglī se qurbāngāh ke sīṅgoṅ par lagā diyā tāki wuh gunāhoṅ se pāk ho jāe. Bāqī ḳhūn us ne qurbāngāh ke pāe par unḍel diyā. Yoṅ us ne use maḳhsūs-o-muqaddas karke us kā kaffārā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Mūsā ne antaṛiyoṅ par kī tamām charbī, joṛkalejī aur donoṅ gurde un kī charbī samet le kar qurbāngāh par jalā die. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Lekin bail kī khāl, gosht aur antaṛiyoṅ ke gobar ko us ne ḳhaimāgāh ke bāhar le jā kar jalā diyā. Sab kuchh us hukm ke mutābiq huā jo Rab ne Mūsā ko diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Is ke bād us ne bhasm hone wālī qurbānī ke lie pahlā menḍhā pesh kiyā. Hārūn aur us ke beṭoṅ ne apne hāth us ke sar par rakh die. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Mūsā ne use zabah karke us kā ḳhūn qurbāngāh ke chār pahluoṅ par chhiṛak diyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Us ne menḍhe ko ṭukṛe ṭukṛe karke sar, ṭukṛe aur charbī jalā dī. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Us ne antaṛiyāṅ aur pinḍliyāṅ pānī se sāf karke pūre menḍhe ko qurbāngāh par jalā diyā. Sab kuchh us hukm ke ain mutābiq huā jo Rab ne Mūsā ko diyā thā. Rab ke lie jalne wālī yih qurbānī bhasm hone wālī qurbānī thī, aur us kī ḳhushbū Rab ko pasand thī. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Is ke bād Mūsā ne dūsre menḍhe ko pesh kiyā. Is qurbānī kā maqsad imāmoṅ ko maqdis meṅ ḳhidmat ke lie maḳhsūs karnā thā. Hārūn aur us ke beṭoṅ ne apne hāth menḍhe ke sar par rakh die. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mūsā ne use zabah karke us ke ḳhūn meṅ se kuchh le kar Hārūn ke dahne kān kī lau par aur us ke dahne hāth aur dahne pāṅw ke angūṭhoṅ par lagāyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Yihī us ne Hārūn ke beṭoṅ ke sāth bhī kiyā. Us ne unheṅ sāmne lā kar un ke dahne kān kī lau par aur un ke dahne hāth aur dahne pāṅw ke angūṭhoṅ par ḳhūn lagāyā. Bāqī ḳhūn us ne qurbāngāh ke chār pahluoṅ par chhiṛak diyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Us ne menḍhe kī charbī, dum, antaṛiyoṅ par kī sārī charbī, joṛkalejī, donoṅ gurde un kī charbī samet aur dahnī rān alag kī. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Phir wuh Rab ke sāmne paṛī beḳhamīrī roṭiyoṅ kī ṭokrī meṅ se ek sādā roṭī, ek roṭī jis meṅ tel ḍālā gayā thā aur ek roṭī jis par tel lagāyā gayā thā le kar charbī aur rān par rakh dī. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Us ne yih sab kuchh Hārūn aur us ke beṭoṅ ke hāthoṅ par rakh kar use hilāne wālī qurbānī ke taur par Rab ko pesh kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Phir us ne yih chīzeṅ un se wāpas le kar qurbāngāh par jalā dīṅ jis par pahle bhasm hone wālī qurbānī rakhī gaī thī. Rab ke lie jalne wālī yih qurbānī imāmoṅ ko maḳhsūs karne ke lie chaṛhāī gaī, aur us kī ḳhushbū Rab ko pasand thī. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Mūsā ne Sīnā bhī liyā aur use hilāne wālī qurbānī ke taur par Rab ke sāmne hilāyā. Yih maḳhsūsiyat ke menḍhe meṅ se Mūsā kā hissā thā. Mūsā ne is meṅ bhī sab kuchh Rab ke hukm ke ain mutābiq kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Phir us ne masah ke tel aur qurbāngāh par ke ḳhūn meṅ se kuchh le kar Hārūn, us ke beṭoṅ aur un ke kapṛoṅ par chhiṛak diyā. Yoṅ us ne unheṅ aur un ke kapṛoṅ ko maḳhsūs-o-muqaddas kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Mūsā ne un se kahā, “Gosht ko mulāqāt ke ḳhaime ke darwāze par ubāl kar use un roṭiyoṅ ke sāth khānā jo maḳhsūsiyat kī qurbāniyoṅ kī ṭokrī meṅ paṛī haiṅ. Kyoṅki Rab ne mujhe yihī hukm diyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Gosht aur roṭiyoṅ kā baqāyā jalā denā. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Sāt din tak mulāqāt ke ḳhaime ke darwāze meṅ se na nikalnā, kyoṅki maqdis meṅ ḳhidmat ke lie tumhārī maḳhsūsiyat ke itne hī din haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Jo kuchh āj huā hai wuh Rab ke hukm ke mutābiq huā tāki tumhārā kaffārā diyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Tumheṅ sāt rāt aur din tak ḳhaime ke darwāze ke andar rahnā hai. Rab kī is hidāyat ko māno warnā tum mar jāoge, kyoṅki yih hukm mujhe Rab kī taraf se diyā gayā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Hārūn aur us ke beṭoṅ ne un tamām hidāyāt par amal kiyā jo Rab ne Mūsā kī mārifat unheṅ dī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Maḳhsūsiyat ke sāt din ke bād Mūsā ne āṭhweṅ din Hārūn, us ke beṭoṅ aur Isrāīl ke buzurgoṅ ko bulāyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Us ne Hārūn se kahā, “Ek beaib bachhṛā aur ek beaib menḍhā chun kar Rab ko pesh kar. Bachhṛā gunāh kī qurbānī ke lie aur menḍhā bhasm hone wālī qurbānī ke lie ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Phir Isrāīliyoṅ ko kah denā ki gunāh kī qurbānī ke lie ek bakrā jabki bhasm hone wālī qurbānī ke lie ek beaib yaksālā bachhṛā aur ek beaib yaksālā bheṛ kā bachchā pesh karo. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Sāth hī salāmatī kī qurbānī ke lie ek bail aur ek menḍhā chuno. Tel ke sāth milāī huī ġhallā kī nazar bhī le kar sab kuchh Rab ko pesh karo. Kyoṅki āj hī Rab tum par zāhir hogā.” ");
INSERT INTO urdgvr_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Isrāīlī Mūsā kī matlūbā tamām chīzeṅ mulāqāt ke ḳhaime ke sāmne le āe. Pūrī jamāt qarīb ā kar Rab ke sāmne khaṛī ho gaī. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Mūsā ne un se kahā, “Tumheṅ wuhī karnā hai jis kā hukm Rab ne tumheṅ diyā hai. Kyoṅki āj hī Rab kā jalāl tum par zāhir hogā.” ");
INSERT INTO urdgvr_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Phir us ne Hārūn se kahā, “Qurbāngāh ke pās jā kar gunāh kī qurbānī aur bhasm hone wālī qurbānī chaṛhā kar apnā aur apnī qaum kā kaffārā denā. Rab ke hukm ke mutābiq qaum ke lie bhī qurbānī pesh karnā tāki us kā kaffārā diyā jāe.” ");
INSERT INTO urdgvr_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Hārūn qurbāngāh ke pās āyā. Us ne bachhṛe ko zabah kiyā. Yih us ke lie gunāh kī qurbānī thā. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Us ke beṭe bachhṛe kā ḳhūn us ke pās le āe. Us ne apnī unglī ḳhūn meṅ ḍubo kar use qurbāngāh ke sīṅgoṅ par lagāyā. Bāqī ḳhūn ko us ne qurbāngāh ke pāe par unḍel diyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Phir us ne us kī charbī, gurdoṅ aur joṛkalejī ko qurbāngāh par jalā diyā. Jaise Rab ne Mūsā ko hukm diyā thā waise hī Hārūn ne kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Bachhṛe kā gosht aur khāl us ne ḳhaimāgāh ke bāhar le jā kar jalā dī. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Is ke bād Hārūn ne bhasm hone wālī qurbānī ko zabah kiyā. Us ke beṭoṅ ne use us kā ḳhūn diyā, aur us ne use qurbāngāh ke chār pahluoṅ par chhiṛak diyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Unhoṅ ne use qurbānī ke muḳhtalif ṭukṛe sar samet die, aur us ne unheṅ qurbāngāh par jalā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Phir us ne us kī antaṛiyāṅ aur pinḍliyāṅ dho kar bhasm hone wālī qurbānī kī bāqī chīzoṅ par rakh kar jalā dīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Ab Hārūn ne qaum ke lie qurbānī chaṛhāī. Us ne gunāh kī qurbānī ke lie bakrā zabah karke use pahlī qurbānī kī tarah chaṛhāyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Us ne bhasm hone wālī qurbānī bhī qawāyd ke mutābiq chaṛhāī. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Us ne ġhallā kī nazar pesh kī aur us meṅ se muṭṭhī-bhar qurbāngāh par jalā diyā. Yih ġhallā kī us nazar ke alāwā thī jo subah ko bhasm hone wālī qurbānī ke sāth chaṛhāī gaī thī. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Phir us ne salāmatī kī qurbānī ke lie bail aur menḍhe ko zabah kiyā. Yih bhī qaum ke lie thī. Us ke beṭoṅ ne use jānwaroṅ kā ḳhūn diyā, aur us ne use qurbāngāh ke chār pahluoṅ par chhiṛak diyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Lekin unhoṅ ne bail aur menḍhe ko charbī, dum, antaṛiyoṅ par kī charbī aur joṛkalejī nikāl kar ");
INSERT INTO urdgvr_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","sīne ke ṭukṛoṅ par rakh diyā. Hārūn ne charbī kā hissā qurbāngāh par jalā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Sīne ke ṭukṛe aur dahnī rāneṅ us ne hilāne wālī qurbānī ke taur par Rab ke sāmne hilāīṅ. Us ne sab kuchh Mūsā ke hukm ke mutābiq hī kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Tamām qurbāniyāṅ pesh karne ke bād Hārūn ne apne hāth uṭhā kar qaum ko barkat dī. Phir wuh qurbāngāh se utar kar ");
INSERT INTO urdgvr_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mūsā ke sāth mulāqāt ke ḳhaime meṅ dāḳhil huā. Jab donoṅ bāhar āe to unhoṅ ne qaum ko barkat dī. Tab Rab kā jalāl pūrī qaum par zāhir huā. ");
INSERT INTO urdgvr_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Rab ke huzūr se āg nikal kar qurbāngāh par utrī aur bhasm hone wālī qurbānī aur charbī ke ṭukṛe bhasm kar die. Yih dekh kar log ḳhushī ke nāre mārne lage aur muṅh ke bal gir gae. ");
INSERT INTO urdgvr_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Hārūn ke beṭe Nadab aur Abīhū ne apne apne baḳhūrdān le kar un meṅ jalte hue koele ḍāle. Un par baḳhūr ḍāl kar wuh Rab ke sāmne āe tāki use pesh kareṅ. Lekin yih āg nājāyz thī. Rab ne yih pesh karne kā hukm nahīṅ diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Achānak Rab ke huzūr se āg niklī jis ne unheṅ bhasm kar diyā. Wahīṅ Rab ke sāmne wuh mar gae. ");
INSERT INTO urdgvr_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Mūsā ne Hārūn se kahā, “Ab wuhī huā hai jo Rab ne farmāyā thā ki jo mere qarīb haiṅ un se maiṅ apnī quddūsiyat zāhir karūṅga, maiṅ tamām qaum ke sāmne hī apne jalāl kā izhār karūṅga.” Hārūn ḳhāmosh rahā. ");
INSERT INTO urdgvr_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mūsā ne Hārūn ke chachā Uzziyel ke beṭoṅ Mīsāel aur Ilsafan ko bulā kar kahā, “Idhar āo aur apne rishtedāroṅ ko maqdis ke sāmne se uṭhā kar ḳhaimāgāh ke bāhar le jāo.” ");
INSERT INTO urdgvr_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Wuh āe aur Mūsā ke hukm ke ain mutābiq unheṅ un ke zerjāmoṅ samet uṭhā kar ḳhaimāgāh ke bāhar le gae. ");
INSERT INTO urdgvr_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mūsā ne Hārūn aur us ke dīgar beṭoṅ Iliyazar aur Itamar se kahā, “Mātam kā izhār na karo. Na apne bāl bikharne do, na apne kapṛe phāṛo. Warnā tum mar jāoge aur Rab pūrī jamāt se nārāz ho jāegā. Lekin tumhāre rishtedār aur bāqī tamām Isrāīlī zarūr in kā mātam kareṅ jin ko Rab ne āg se halāk kar diyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Mulāqāt ke ḳhaime ke darwāze ke bāhar na niklo warnā tum mar jāoge, kyoṅki tumheṅ Rab ke tel se masah kiyā gayā hai.” Chunāṅche unhoṅ ne aisā hī kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Rab ne Hārūn se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Jab bhī tujhe yā tere beṭoṅ ko mulāqāt ke ḳhaime meṅ dāḳhil honā hai to mai yā koī aur nashā-āwar chīz pīnā manā hai, warnā tum mar jāoge. Yih usūl āne wālī nasloṅ ke lie bhī abad tak anmiṭ hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Yih bhī lāzim hai ki tum muqaddas aur ġhairmuqaddas chīzoṅ meṅ, pāk aur nāpāk chīzoṅ meṅ imtiyāz karo. ");
INSERT INTO urdgvr_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Tumheṅ Isrāīliyoṅ ko tamām pābandiyāṅ sikhānī haiṅ jo maiṅ ne tumheṅ Mūsā kī mārifat batāī haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mūsā ne Hārūn aur us ke bache hue beṭoṅ Iliyazar aur Itamar se kahā, “Ġhallā kī nazar kā jo hissā Rab ke sāmne jalāyā nahīṅ jātā use apne lie le kar beḳhamīrī roṭī pakānā aur qurbāngāh ke pās hī khānā. Kyoṅki wuh nihāyat muqaddas hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Use muqaddas jagah par khānā, kyoṅki wuh Rab kī jalne wālī qurbāniyoṅ meṅ se tumhāre aur tumhāre beṭoṅ kā hissā hai. Kyoṅki mujhe is kā hukm diyā gayā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Jo Sīnā hilāne wālī qurbānī aur dahnī rān uṭhāne wālī qurbānī ke taur par pesh kī gaī hai, wuh tum aur tumhāre beṭe-beṭiyāṅ khā sakte haiṅ. Unheṅ muqaddas jagah par khānā hai. Isrāīliyoṅ kī salāmatī kī qurbāniyoṅ meṅ se yih ṭukṛe tumhārā hissā haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Lekin pahle imām rān aur sīne ko jalne wālī qurbāniyoṅ kī charbī ke sāth pesh kareṅ. Wuh unheṅ hilāne wālī qurbānī ke taur par Rab ke sāmne hilāeṅ. Rab farmātā hai ki yih ṭukṛe abad tak tumhāre aur tumhāre beṭoṅ kā hissā haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Mūsā ne dariyāft kiyā ki us bakre ke gosht kā kyā huā jo gunāh kī qurbānī ke taur par chaṛhāyā gayā thā. Use patā chalā ki wuh bhī jal gayā thā. Yih sun kar use Hārūn ke beṭoṅ Iliyazar aur Itamar par ġhussā āyā. Us ne pūchhā, ");
INSERT INTO urdgvr_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Tum ne gunāh kī qurbānī kā gosht kyoṅ nahīṅ khāyā? Tumheṅ use muqaddas jagah par khānā thā. Yih ek nihāyat muqaddas hissā hai jo Rab ne tumheṅ diyā tāki tum jamāt kā qusūr dūr karke Rab ke sāmne logoṅ kā kaffārā do. ");
INSERT INTO urdgvr_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Chūṅki is bakre kā ḳhūn maqdis meṅ na lāyā gayā is lie tumheṅ us kā gosht maqdis meṅ khānā thā jis tarah maiṅ ne tumheṅ hukm diyā thā.” ");
INSERT INTO urdgvr_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Hārūn ne Mūsā ko jawāb de kar kahā, “Dekheṅ, āj logoṅ ne apne lie gunāh kī qurbānī aur bhasm hone wālī qurbānī Rab ko pesh kī hai jabki mujh par yih āfat guzarī hai. Agar maiṅ āj gunāh kī qurbānī se khātā to kyā yih Rab ko achchhā lagtā?” ");
INSERT INTO urdgvr_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Yih bāt Mūsā ko achchhī lagī. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Rab ne Mūsā aur Hārūn se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Isrāīliyoṅ ko batānā ki tumheṅ zamīn par rahne wāle jānwaroṅ meṅ se zail ke jānwaroṅ ko khāne kī ijāzat hai: ");
INSERT INTO urdgvr_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Jin ke khur yā pāṅw bilkul chire hue haiṅ aur jo jugālī karte haiṅ unheṅ khāne kī ijāzat hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","Ūṅṭ, bijjū yā ḳhargosh khānā manā hai. Wuh tumhāre lie nāpāk haiṅ, kyoṅki wuh jugālī to karte haiṅ lekin un ke khur yā pāṅw chire hue nahīṅ haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Suar na khānā. Wuh tumhāre lie nāpāk hai, kyoṅki us ke khur to chire hue haiṅ lekin wuh jugālī nahīṅ kartā. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Na un kā gosht khānā, na un kī lāshoṅ ko chhūnā. Wuh tumhāre lie nāpāk haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Samundarī aur dariyāī jānwar khāne ke lie jāyz haiṅ agar un ke par aur chhilke hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Lekin jin ke par yā chhilke nahīṅ haiṅ wuh sab tumhāre lie makrūh haiṅ, ḳhāh wuh baṛī tādād meṅ mil kar rahte haiṅ yā nahīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Is lie un kā gosht khānā manā hai, aur un kī lāshoṅ se bhī ghin khānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Pānī meṅ rahne wāle tamām jānwar jin ke par yā chhilke na hoṅ tumhāre lie makrūh haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Zail ke parinde tumhāre lie qābil-e-ghin hoṅ. Inheṅ khānā manā hai, kyoṅki wuh makrūh haiṅ: uqāb, daṛhiyal giddh, kālā giddh, ");
INSERT INTO urdgvr_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","lāl chīl, har qism kī kālī chīl, ");
INSERT INTO urdgvr_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","har qism kā kawwā, ");
INSERT INTO urdgvr_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","uqābī ullū, chhoṭe kān wālā ullū, baṛe kān wālā ullū, har qism kā bāz, ");
INSERT INTO urdgvr_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","chhoṭā ullū, qūq, chinghāṛne wālā ullū, ");
INSERT INTO urdgvr_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","safed ullū, dashtī ullū, Misrī giddh, ");
INSERT INTO urdgvr_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","laqlaq, har qism kā būtīmār, hudhud aur chamgādaṛ. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Tamām par rakhne wāle kīṛe jo chār pāṅwoṅ par chalte haiṅ tumhāre lie makrūh haiṅ, ");
INSERT INTO urdgvr_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","siwāe un ke jin kī ṭāṅgoṅ ke do hisse haiṅ aur jo phudakte haiṅ. Un ko tum khā sakte ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Is nāte se tum muḳhtalif qism ke ṭiḍḍe khā sakte ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Bāqī sab par rakhne wāle kīṛe jo chār pāṅwoṅ par chalte haiṅ tumhāre lie makrūh haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","28","Jo bhī zail ke jānwaroṅ kī lāsheṅ chhue wuh shām tak nāpāk rahegā: (a) khur rakhne wāle tamām jānwar siwāe un ke jin ke khur yā pāṅw pūre taur par chire hue haiṅ aur jo jugālī karte haiṅ, (b) tamām jānwar jo apne chār panjoṅ par chalte haiṅ. Yih jānwar tumhāre lie nāpāk haiṅ, aur jo bhī un kī lāsheṅ uṭhāe yā chhue lāzim hai ki wuh apne kapṛe dho le. Is ke bāwujūd bhī wuh shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","Zamīn par reṅgne wāle jānwaroṅ meṅ se chhachhūṅdar, muḳhtalif qism ke chūhe aur muḳhtalif qism kī chhipkliyāṅ tumhāre lie nāpāk haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Jo bhī unheṅ aur un kī lāsheṅ chhū letā hai wuh shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Agar un meṅ se kisī kī lāsh kisī chīz par gir paṛe to wuh bhī nāpāk ho jāegī. Is se koī farq nahīṅ paṛtā ki wuh lakaṛī, kapṛe, chamṛe yā ṭāṭ kī banī ho, na is se koī farq paṛtā hai ki wuh kis kām ke lie istemāl kī jātī hai. Use har sūrat meṅ pānī meṅ ḍubonā hai. To bhī wuh shām tak nāpāk rahegī. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Agar aisī lāsh miṭṭī ke bartan meṅ gir jāe to jo kuchh bhī us meṅ hai nāpāk ho jāegā aur tumheṅ us bartan ko toṛnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Har khāne wālī chīz jis par aise bartan kā pānī ḍālā gayā hai nāpāk hai. Isī tarah us bartan se niklī huī har pīne wālī chīz nāpāk hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Jis par bhī aisī lāsh gir paṛe wuh nāpāk ho jātā hai. Agar wuh tanūr yā chūlhe par gir paṛe to un ko toṛ denā hai. Wuh nāpāk haiṅ aur tumhāre lie nāpāk raheṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Lekin jis chashme yā hauz meṅ aisī lāsh gire wuh pāk rahtā hai. Sirf wuh jo lāsh ko chhū letā hai nāpāk ho jātā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Agar aisī lāsh bījoṅ par gir paṛe jin ko abhī bonā hai to wuh pāk rahte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Lekin agar bījoṅ par pānī ḍālā gayā ho aur phir lāsh un par gir paṛe to wuh nāpāk haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Agar aisā jānwar jise khāne kī ijāzat hai mar jāe to jo bhī us kī lāsh chhue shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Jo us meṅ se kuchh khāe yā use uṭhā kar le jāe use apne kapṛoṅ ko dhonā hai. To bhī wuh shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Har jānwar jo zamīn par reṅgtā hai qābil-e-ghin hai. Use khānā manā hai, ");
INSERT INTO urdgvr_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","chāhe wuh apne peṭ par chāhe chār yā is se zāyd pāṅwoṅ par chaltā ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","In tamām reṅgne wāloṅ se apne āp ko ghin kā bāis aur nāpāk na banānā, ");
INSERT INTO urdgvr_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","kyoṅki maiṅ Rab tumhārā Ḳhudā hūṅ. Lāzim hai ki tum apne āp ko maḳhsūs-o-muqaddas rakho, kyoṅki maiṅ quddūs hūṅ. Apne āp ko zamīn par reṅgne wāle tamām jānwaroṅ se nāpāk na banānā. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Maiṅ Rab hūṅ. Maiṅ tumheṅ Misr se nikāl lāyā hūṅ tāki tumhārā Ḳhudā banūṅ. Lihāzā muqaddas raho, kyoṅki maiṅ quddūs hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Zamīn par chalne wāle jānwaroṅ, parindoṅ, ābī jānwaroṅ aur zamīn par reṅgne wāle jānwaroṅ ke bāre meṅ shar'a yihī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Lāzim hai ki tum nāpāk aur pāk meṅ imtiyāz karo, aise jānwaroṅ meṅ jo khāne ke lie jāyz haiṅ aur aisoṅ meṅ jo nājāyz haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Isrāīliyoṅ ko batā ki jab kisī aurat ke laṛkā paidā ho to wuh māhwārī ke aiyām kī tarah sāt din tak nāpāk rahegī. ");
INSERT INTO urdgvr_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Āṭhweṅ din laṛke kā ḳhatnā karwānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Phir māṅ mazīd 33 din intazār kare. Is ke bād us kī wuh nāpākī dūr ho jāegī jo ḳhūn bahne se paidā huī hai. Is daurān wuh koī maḳhsūs aur muqaddas chīz na chhue, na maqdis ke pās jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Agar us ke laṛkī paidā ho jāe to wuh māhwārī ke aiyām kī tarah nāpāk hai. Yih nāpākī 14 din tak rahegī. Phir wuh mazīd 66 din intazār kare. Is ke bād us kī wuh nāpākī dūr ho jāegī jo ḳhūn bahne se paidā huī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Jab laṛke yā laṛkī ke silsile meṅ yih din guzar jāeṅ to wuh mulāqāt ke ḳhaime ke darwāze par imām ko zail kī chīzeṅ de: bhasm hone wālī qurbānī ke lie ek yaksālā bheṛ kā bachchā aur gunāh kī qurbānī ke lie ek jawān kabūtar yā qumrī. ");
INSERT INTO urdgvr_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Imām yih jānwar Rab ko pesh karke us kā kaffārā de. Phir ḳhūn bahne ke bāis paidā hone wālī nāpākī dūr ho jāegī. Usūl ek hī hai, chāhe laṛkā ho yā laṛkī. ");
INSERT INTO urdgvr_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Agar wuh ġhurbat ke bāis bheṛ kā bachchā na de sake to phir wuh do qumriyāṅ yā do jawān kabūtar le āe, ek bhasm hone wālī qurbānī ke lie aur dūsrā gunāh kī qurbānī ke lie. Yoṅ imām us kā kaffārā de aur wuh pāk ho jāegī.” ");
INSERT INTO urdgvr_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Rab ne Mūsā aur Hārūn se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Agar kisī kī jild meṅ sūjan yā papaṛī yā safed dāġh ho aur ḳhatrā hai ki wabāī jildī bīmārī ho to use imāmoṅ yānī Hārūn yā us ke beṭoṅ ke pās le ānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Imām us jagah kā muāynā kare. Agar us ke bāl safed ho gae hoṅ aur wuh jild meṅ dhaṅsī huī ho to wabāī bīmārī hai. Jab imām ko yih mālūm ho to wuh use nāpāk qarār de. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Lekin ho saktā hai ki jild kī jagah safed to hai lekin jild meṅ dhaṅsī huī nahīṅ hai, na us ke bāl safed hue haiṅ. Is sūrat meṅ imām us shaḳhs ko sāt din ke lie alahdagī meṅ rakhe. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Sātweṅ din imām dubārā us kā muāynā kare. Agar wuh dekhe ki muta'assirā jagah waisī hī hai aur phailī nahīṅ to wuh use mazīd sāt din alahdagī meṅ rakhe. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Sātweṅ din wuh ek aur martabā us kā muāynā kare. Agar us jagah kā rang dubārā sehhatmand jild ke rang kī mānind ho rahā ho aur phailī na ho to wuh use pāk qarār de. Is kā matlab hai ki yih marz ām papaṛī se zyādā nahīṅ hai. Marīz apne kapṛe dho le to wuh pāk ho jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Lekin agar is ke bād muta'assirā jagah phailne lage to wuh dubārā apne āp ko imām ko dikhāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Imām us kā muāynā kare. Agar jagah wāqaī phail gaī ho to imām use nāpāk qarār de, kyoṅki yih wabāī jildī marz hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Agar kisī ke jism par wabāī jildī marz nazar āe to use imām ke pās lāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Imām us kā muāynā kare. Agar muta'assirā jild meṅ safed sūjan ho, us ke bāl bhī safed ho gae hoṅ, aur us meṅ kachchā gosht maujūd ho ");
INSERT INTO urdgvr_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","to is kā matlab hai ki wabāī jildī bīmārī purānī hai. Imām us shaḳhs ko sāt din ke lie alahdagī meṅ rakh kar intazār na kare balki use fauran nāpāk qarār de, kyoṅki yih us kī nāpākī kā sabūt hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Lekin agar bīmārī jaldī se phail gaī ho, yahāṅ tak ki sar se le kar pāṅwoṅ tak pūrī jild muta'assir huī ho ");
INSERT INTO urdgvr_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","to imām yih dekh kar marīz ko pāk qarār de. Chūṅki pūrī jild safed ho gaī hai is lie wuh pāk hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Lekin jab bhī kahīṅ kachchā gosht nazar āe us waqt wuh nāpāk ho jātā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Imām yih dekh kar marīz ko nāpāk qarār de. Kachchā gosht har sūrat meṅ nāpāk hai, kyoṅki is kā matlab hai ki wabāī jildī bīmārī lag gaī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Agar kachche gosht kā yih zaḳhm bhar jāe aur muta'assirā jagah kī jild safed ho jāe to marīz imām ke pās jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Agar imām dekhe ki wāqaī aisā hī huā hai aur muta'assirā jild safed ho gaī hai to wuh use pāk qarār de. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Agar kisī kī jild par phoṛā ho lekin wuh ṭhīk ho jāe ");
INSERT INTO urdgvr_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","aur us kī jagah safed sūjan yā surḳhī-māyl safed dāġh nazar āe to marīz apne āp ko imām ko dikhāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Agar wuh us kā muāynā karke dekhe ki muta'assirā jagah jild ke andar dhaṅsī huī hai aur us ke bāl safed ho gae haiṅ to wuh marīz ko nāpāk qarār de. Kyoṅki is kā matlab hai ki jahāṅ pahle phoṛā thā wahāṅ wabāī jildī bīmārī paidā ho gaī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Lekin agar imām dekhe ki muta'assirā jagah ke bāl safed nahīṅ haiṅ, wuh jild meṅ dhaṅsī huī nazar nahīṅ ātī aur us kā rang dubārā sehhatmand jild kī mānind ho rahā hai to wuh use sāt din ke lie alahdagī meṅ rakhe. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Agar is daurān bīmārī mazīd phail jāe to imām marīz ko nāpāk qarār de, kyoṅki is kā matlab hai ki wabāī jildī bīmārī lag gaī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Lekin agar dāġh na phaile to is kā matlab hai ki yih sirf us bhare hue zaḳhm kā nishān hai jo phoṛe se paidā huā thā. Imām marīz ko pāk qarār de. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Agar kisī kī jild par jalne kā zaḳhm lag jāe aur muta'assirā jagah par surḳhī-māyl safed dāġh yā safed dāġh paidā ho jāe ");
INSERT INTO urdgvr_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","to imām muta'assirā jagah kā muāynā kare. Agar mālūm ho jāe ki muta'assirā jagah ke bāl safed ho gae haiṅ aur wuh jild meṅ dhaṅsī huī hai to is kā matlab hai ki choṭ kī jagah par wabāī jildī marz lag gayā hai. Imām use nāpāk qarār de, kyoṅki wabāī jildī bīmārī lag gaī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Lekin agar imām ne mālūm kiyā hai ki dāġh meṅ bāl safed nahīṅ haiṅ, wuh jild meṅ dhaṅsā huā nazar nahīṅ ātā aur us kā rang sehhatmand jild kī mānind ho rahā hai to wuh marīz ko sāt din tak alahdagī meṅ rakhe. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Agar wuh sātweṅ din mālūm kare ki muta'assirā jagah phail gaī hai to wuh use nāpāk qarār de. Kyoṅki is kā matlab hai ki wabāī jildī bīmārī lag gaī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Lekin agar dāġh phailā huā nazar nahīṅ ātā aur muta'assirā jild kā rang sehhatmand jild ke rang kī mānind ho gayā hai to is kā matlab hai ki yih sirf us bhare hue zaḳhm kā nishān hai jo jalne se paidā huā thā. Imām marīz ko pāk qarār de. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Agar kisī ke sar yā dāṛhī kī jild meṅ nishān nazar āe ");
INSERT INTO urdgvr_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","to imām muta'assirā jagah kā muāynā kare. Agar wuh dhaṅsī huī nazar āe aur us ke bāl rang ke lihāz se chamakte hue sone kī mānind aur bārīk hoṅ to imām marīz ko nāpāk qarār de. Is kā matlab hai ki aisī wabāī jildī bīmārī sar yā dāṛhī kī jild par lag gaī hai jo ḳhārish paidā kartī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Lekin agar imām ne mālūm kiyā ki muta'assirā jagah jild meṅ dhaṅsī huī nazar nahīṅ ātī agarche us ke bāloṅ kā rang badal gayā hai to wuh use sāt din ke lie alahdagī meṅ rakhe. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Sātweṅ din imām jild kī muta'assirā jagah kā muāynā kare. Agar wuh phailī huī nazar nahīṅ ātī aur us ke bāloṅ kā rang chamakdār sone kī mānind nahīṅ hai, sāth hī wuh jagah jild meṅ dhaṅsī huī bhī dikhāī nahīṅ detī, ");
INSERT INTO urdgvr_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","to marīz apne bāl munḍwāe. Sirf wuh bāl rah jāeṅ jo muta'assirā jagah se nikalte haiṅ. Imām marīz ko mazīd sāt din alahdagī meṅ rakhe. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Sātweṅ din wuh us kā muāynā kare. Agar muta'assirā jagah nahīṅ phailī aur wuh jild meṅ dhaṅsī huī nazar nahīṅ ātī to imām use pāk qarār de. Wuh apne kapṛe dho le to wuh pāk ho jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Lekin agar is ke bād jild kī muta'assirā jagah phailnā shurū ho jāe ");
INSERT INTO urdgvr_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","to imām dubārā us kā muāynā kare. Agar wuh jagah wāqaī phailī huī nazar āe to marīz nāpāk hai, chāhe muta'assirā jagah ke bāloṅ kā rang chamakte sone kī mānind ho yā na ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Lekin agar us ke ḳhayāl meṅ muta'assirā jagah phailī huī nazar nahīṅ ātī balki us meṅ se kāle rang ke bāl nikal rahe haiṅ to is kā matlab hai ki marīz kī sehhat bahāl ho gaī hai. Imām use pāk qarār de. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Agar kisī mard yā aurat kī jild par safed dāġh paidā ho jāeṅ ");
INSERT INTO urdgvr_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","to imām un kā muāynā kare. Agar un kā safed rang halkā-sā ho to yih sirf bezarar papaṛī hai. Marīz pāk hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","Agar kisī mard kā sar māthe kī taraf yā pīchhe kī taraf ganjā hai to wuh pāk hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Lekin agar us jagah jahāṅ wuh ganjā hai surḳhī-māyl safed dāġh ho to is kā matlab hai ki wahāṅ wabāī jildī bīmārī lag gaī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Imām us kā muāynā kare. Agar ganjī jagah par surḳhī-māyl safed sūjan ho jo wabāī jildī bīmārī kī mānind nazar āe ");
INSERT INTO urdgvr_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","to marīz ko wabāī jildī bīmārī lag gaī hai. Imām use nāpāk qarār de. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Wabāī jildī bīmārī kā marīz phaṭe kapṛe pahne. Us ke bāl bikhre raheṅ. Wuh apnī mūṅchhoṅ ko kisī kapṛe se chhupāe aur pukārtā rahe, ‘Nāpāk, nāpāk.’ ");
INSERT INTO urdgvr_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Jis waqt tak wabāī jildī bīmārī lagī rahe wuh nāpāk hai. Wuh is daurān ḳhaimāgāh ke bāhar jā kar tanhāī meṅ rahe. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Ho saktā hai ki ūn yā katān ke kisī libās par phaphūṅdī lag gaī hai, ");
INSERT INTO urdgvr_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","yā ki phaphūṅdī ūn yā katān ke kisī kapṛe ke ṭukṛe yā kisī chamṛe yā chamṛe kī kisī chīz par lag gaī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Agar phaphūṅdī kā rang harā yā lāl-sā ho to wuh phailne wālī phaphūṅdī hai, aur lāzim hai ki use imām ko dikhāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Imām us kā muāynā karke use sāt din ke lie alahdagī meṅ rakhe. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Sātweṅ din wuh dubārā us kā muāynā kare. Agar phaphūṅdī phail gaī ho to is kā matlab hai ki wuh nuqsāndeh hai. Muta'assirā chīz nāpāk hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Imām use jalā de, kyoṅki yih phaphūṅdī nuqsāndeh hai. Lāzim hai ki use jalā diyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Lekin agar in sāt dinoṅ ke bād phaphūṅdī phailī huī nazar nahīṅ ātī ");
INSERT INTO urdgvr_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","to imām hukm de ki muta'assirā chīz ko dhulwāyā jāe. Phir wuh use mazīd sāt din ke lie alahdagī meṅ rakhe. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Is ke bād wuh dubārā us kā muāynā kare. Agar wuh mālūm kare ki phaphūṅdī to phailī huī nazar nahīṅ ātī lekin us kā rang waise kā waisā hai to wuh nāpāk hai. Use jalā denā, chāhe phaphūṅdī muta'assirā chīz ke sāmne wāle hisse yā pichhle hisse meṅ lagī ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Lekin agar mālūm ho jāe ki phaphūṅdī kā rang māṅd paṛ gayā hai to imām kapṛe yā chamṛe meṅ se muta'assirā jagah phāṛ kar nikāl de. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","To bhī ho saktā hai ki phaphūṅdī dubārā usī kapṛe yā chamṛe par nazar āe. Is kā matlab hai ki wuh phail rahī hai aur use jalā denā lāzim hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Lekin agar phaphūṅdī dhone ke bād ġhāyb ho jāe to use ek aur dafā dhonā hai. Phir muta'assirā chīz pāk hogī. ");
INSERT INTO urdgvr_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Isī tarah phaphūṅdī se nipaṭnā hai, chāhe wuh ūn yā katān ke kisī libās ko lag gaī ho, chāhe ūn yā katān ke kisī ṭukṛe yā chamṛe kī kisī chīz ko lag gaī ho. Inhīṅ usūloṅ ke taht faislā karnā hai ki muta'assirā chīz pāk hai yā nāpāk.” ");
INSERT INTO urdgvr_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Agar koī shaḳhs jildī bīmārī se shafā pāe aur use pāk-sāf karānā hai to use imām ke pās lāyā jāe ");
INSERT INTO urdgvr_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","jo ḳhaimāgāh ke bāhar jā kar us kā muāynā kare. Agar wuh dekhe ki marīz kī sehhat wāqaī bahāl ho gaī hai ");
INSERT INTO urdgvr_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","to imām us ke lie do zindā aur pāk parinde, deodār kī lakaṛī, qirmizī rang kā dhāgā aur zūfā mangwāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Imām ke hukm par parindoṅ meṅ se ek ko tāzā pānī se bhare hue miṭṭī ke bartan ke ūpar zabah kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Imām zindā parinde ko deodār kī lakaṛī, qirmizī rang ke dhāge aur zūfā ke sāth zabah kie gae parinde ke us ḳhūn meṅ ḍubo de jo miṭṭī ke bartan ke pānī meṅ ā gayā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Wuh pānī se milāyā huā ḳhūn sāt bār pāk hone wāle shaḳhs par chhiṛak kar use pāk qarār de, phir zindā parinde ko khule maidān meṅ chhoṛ de. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Jo apne āp ko pāk-sāf karā rahā hai wuh apne kapṛe dhoe, apne tamām bāl munḍwāe aur nahā le. Is ke bād wuh pāk hai. Ab wuh ḳhaimāgāh meṅ dāḳhil ho saktā hai agarche wuh mazīd sāt din apne ḍere meṅ nahīṅ jā saktā. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Sātweṅ din wuh dubārā apne sar ke bāl, apnī dāṛhī, apne abrū aur bāqī tamām bāl munḍwāe. Wuh apne kapṛe dhoe aur nahā le. Tab wuh pāk hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Āṭhweṅ din wuh do bheṛ ke nar bachche aur ek yaksālā bheṛ chun le jo beaib hoṅ. Sāth hī wuh ġhallā kī nazar ke lie tel ke sāth milāyā gayā sāṛhe 4 kilogrām behtarīn maidā aur 300 milīliṭar tel le. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Phir jis imām ne use pāk qarār diyā wuh use in qurbāniyoṅ samet mulāqāt ke ḳhaime ke darwāze par Rab ko pesh kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Bheṛ kā ek nar bachchā aur 300 milīliṭar tel qusūr kī qurbānī ke lie hai. Imām unheṅ hilāne wālī qurbānī ke taur par Rab ke sāmne hilāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Phir wuh bheṛ ke is bachche ko ḳhaime ke darwāze par zabah kare jahāṅ gunāh kī qurbāniyāṅ aur bhasm hone wālī qurbāniyāṅ zabah kī jātī haiṅ. Gunāh kī qurbāniyoṅ kī tarah qusūr kī yih qurbānī imām kā hissā hai aur nihāyat muqaddas hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Imām ḳhūn meṅ se kuchh le kar pāk hone wāle ke dahne kān kī lau par aur us ke dahne hāth aur dahne pāṅw ke angūṭhoṅ par lagāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Ab wuh 300 milīliṭar tel meṅ se kuchh le kar apne bāeṅ hāth kī hathelī par ḍāle. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Apne dahne hāth ke angūṭhe ke sāth wālī unglī is tel meṅ ḍubo kar wuh use sāt bār Rab ke sāmne chhiṛke. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Wuh apnī hathelī par ke tel meṅ se kuchh aur le kar pāk hone wāle ke dahne kān kī lau par aur us ke dahne hāth aur dahne pāṅw ke angūṭhoṅ par lagā de yānī un jaghoṅ par jahāṅ wuh qusūr kī qurbānī kā ḳhūn lagā chukā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Imām apnī hathelī par kā bāqī tel pāk hone wāle ke sar par ḍāl kar Rab ke sāmne us kā kaffārā de. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Is ke bād imām gunāh kī qurbānī chaṛhā kar pāk hone wāle kā kaffārā de. Āḳhir meṅ wuh bhasm hone wālī qurbānī kā jānwar zabah kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Wuh use ġhallā kī nazar ke sāth qurbāngāh par chaṛhā kar us kā kaffārā de. Tab wuh pāk hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Agar shafāyāb shaḳhs ġhurbat ke bāis yih qurbāniyāṅ nahīṅ chaṛhā saktā to phir wuh qusūr kī qurbānī ke lie bheṛ kā sirf ek nar bachchā le āe. Kāfī hai ki kaffārā dene ke lie yihī Rab ke sāmne hilāyā jāe. Sāth sāth ġhallā kī nazar ke lie ḍeṛh kilogrām behtarīn maidā tel ke sāth milā kar pesh kiyā jāe aur 300 milīliṭar tel. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Is ke alāwā wuh do qumriyāṅ yā do jawān kabūtar pesh kare, ek ko gunāh kī qurbānī ke lie aur dūsre ko bhasm hone wālī qurbānī ke lie. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Āṭhweṅ din wuh unheṅ mulāqāt ke ḳhaime ke darwāze par imām ke pās aur Rab ke sāmne le āe tāki wuh pāk-sāf ho jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Imām bheṛ ke bachche ko 300 milīliṭar tel samet le kar hilāne wālī qurbānī ke taur par Rab ke sāmne hilāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Wuh qusūr kī qurbānī ke lie bheṛ ke bachche ko zabah kare aur us ke ḳhūn meṅ se kuchh le kar pāk hone wāle ke dahne kān kī lau par aur us ke dahne hāth aur dahne pāṅw ke angūṭhoṅ par lagāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Ab wuh 300 milīliṭar tel meṅ se kuchh apne bāeṅ hāth kī hathelī par ḍāle ");
INSERT INTO urdgvr_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","aur apne dahne hāth ke angūṭhe ke sāth wālī unglī is tel meṅ ḍubo kar use sāt bār Rab ke sāmne chhiṛak de. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Wuh apnī hathelī par ke tel meṅ se kuchh aur le kar pāk hone wāle ke dahne kān kī lau par aur us ke dahne hāth aur dahne pāṅw ke angūṭhoṅ par lagā de yānī un jaghoṅ par jahāṅ wuh qusūr kī qurbānī kā ḳhūn lagā chukā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Apnī hathelī par kā bāqī tel wuh pāk hone wāle ke sar par ḍāl de tāki Rab ke sāmne us kā kaffārā de. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Is ke bād wuh shafāyāb shaḳhs kī gunjāish ke mutābiq do qumriyāṅ yā do jawān kabūtar chaṛhāe, ");
INSERT INTO urdgvr_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ek ko gunāh kī qurbānī ke lie aur dūsre ko bhasm hone wālī qurbānī ke lie. Sāth hī wuh ġhallā kī nazar pesh kare. Yoṅ imām Rab ke sāmne us kā kaffārā detā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Yih usūl aise shaḳhs ke lie hai jo wabāī jildī bīmārī se shafā pā gayā hai lekin apnī ġhurbat ke bāis pāk ho jāne ke lie pūrī qurbānī pesh nahīṅ kar saktā.” ");
INSERT INTO urdgvr_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Rab ne Mūsā aur Hārūn se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Jab tum Mulk-e-Kanān meṅ dāḳhil hoge jo maiṅ tumheṅ dūṅgā to wahāṅ aise makān hoṅge jin meṅ maiṅ ne phaphūṅdī phailne dī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Aise ghar kā mālik jā kar imām ko batāe ki maiṅ ne apne ghar meṅ phaphūṅdī jaisī koī chīz dekhī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Tab imām hukm de ki ghar kā muāynā karne se pahle ghar kā pūrā sāmān nikālā jāe. Warnā agar ghar ko nāpāk qarār diyā jāe to sāmān ko bhī nāpāk qarār diyā jāegā. Is ke bād imām andar jā kar makān kā muāynā kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Wuh dīwāroṅ ke sāth lagī huī phaphūṅdī kā muāynā kare. Agar muta'assirā jagheṅ harī yā lāl-sī hoṅ aur dīwār ke andar dhaṅsī huī nazar āeṅ ");
INSERT INTO urdgvr_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","to phir imām ghar se nikal kar sāt din ke lie tālā lagāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Sātweṅ din wuh wāpas ā kar makān kā muāynā kare. Agar phaphūṅdī phailī huī nazar āe ");
INSERT INTO urdgvr_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","to wuh hukm de ki muta'assirā pattharoṅ ko nikāl kar ābādī ke bāhar kisī nāpāk jagah par phaiṅkā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Nīz wuh hukm de ki andar kī dīwāroṅ ko kuredā jāe aur kuredī huī miṭṭī ko ābādī ke bāhar kisī nāpāk jagah par phaiṅkā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Phir log nae patthar lagā kar ghar ko nae gāre se plastar kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Lekin agar is ke bāwujūd phaphūṅdī dubārā paidā ho jāe ");
INSERT INTO urdgvr_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","to imām ā kar dubārā us kā muāynā kare. Agar wuh dekhe ki phaphūṅdī ghar meṅ phail gaī hai to is kā matlab hai ki phaphūṅdī nuqsāndeh hai, is lie ghar nāpāk hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Lāzim hai ki use pūre taur par ḍhā diyā jāe aur sab kuchh yānī us ke patthar, lakaṛī aur plastar ko ābādī ke bāhar kisī nāpāk jagah par phaiṅkā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Agar imām ne kisī ghar kā muāynā karke tālā lagā diyā hai aur phir bhī koī us ghar meṅ dāḳhil ho jāe to wuh shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Jo aise ghar meṅ soe yā khānā khāe lāzim hai ki wuh apne kapṛe dho le. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Lekin agar ghar ko nae sire se plastar karne ke bād imām ā kar us kā dubārā muāynā kare aur dekhe ki phaphūṅdī dubārā nahīṅ niklī to is kā matlab hai ki phaphūṅdī ḳhatm ho gaī hai. Wuh use pāk qarār de. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Use gunāh se pāk-sāf karāne ke lie wuh do parinde, deodār kī lakaṛī, qirmizī rang kā dhāgā aur zūfā le le. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Wuh parindoṅ meṅ se ek ko tāzā pānī se bhare hue miṭṭī ke bartan ke ūpar zabah kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Is ke bād wuh deodār kī lakaṛī, zūfā, qirmizī rang kā dhāgā aur zindā parindā le kar us tāzā pānī meṅ ḍubo de jis ke sāth zabah kie hue parinde kā ḳhūn milāyā gayā hai aur is pānī ko sāt bār ghar par chhiṛak de. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","In chīzoṅ se wuh ghar ko gunāh se pāk-sāf kartā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Āḳhir meṅ wuh zindā parinde ko ābādī ke bāhar khule maidān meṅ chhoṛ de. Yoṅ wuh ghar kā kaffārā degā, aur wuh pāk-sāf ho jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","56","Lāzim hai ki har qism kī wabāī bīmārī se aise nipṭo jaise bayān kiyā gayā hai, chāhe wuh wabāī jildī bīmāriyāṅ hoṅ (masalan ḳhārish, sūjan, papaṛī yā safed daġh), chāhe kapṛoṅ yā gharoṅ meṅ phaphūṅdī ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","In usūloṅ ke taht faislā karnā hai ki koī shaḳhs yā chīz pāk hai yā nāpāk.” ");
INSERT INTO urdgvr_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Rab ne Mūsā aur Hārūn se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Isrāīliyoṅ ko batānā ki agar kisī mard ko jaryān kā marz ho to wuh ḳhārij hone wāle māe ke sabab se nāpāk hai, ");
INSERT INTO urdgvr_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","chāhe māe bahtā rahtā ho yā ruk gayā ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Jis chīz par bhī marīz leṭtā yā baiṭhtā hai wuh nāpāk hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","6","Jo bhī us ke leṭne kī jagah ko chhue yā us ke baiṭhne kī jagah par baiṭh jāe wuh apne kapṛe dho kar nahā le. Wuh shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Isī tarah jo bhī aise marīz ko chhue wuh apne kapṛe dho kar nahā le. Wuh shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Agar marīz kisī pāk shaḳhs par thūke to yihī kuchh karnā hai aur wuh shaḳhs shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Jab aisā marīz kisī jānwar par sawār hotā hai to har chīz jis par wuh baiṭh jātā hai nāpāk hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Jo bhī aisī chīz chhue yā use uṭhā kar le jāe wuh apne kapṛe dho kar nahā le. Wuh shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Jis kisī ko bhī marīz apne hāth dhoe baġhair chhue wuh apne kapṛe dho kar nahā le. Wuh shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Miṭṭī kā jo bartan aisā marīz chhue use toṛ diyā jāe. Lakaṛī kā jo bartan wuh chhue use ḳhūb dhoyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Jise is marz se shafā milī hai wuh sāt din intazār kare. Is ke bād wuh tāzā pānī se apne kapṛe dho kar nahā le. Phir wuh pāk ho jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Āṭhweṅ din wuh do qumriyāṅ yā do jawān kabūtar le kar mulāqāt ke ḳhaime ke darwāze par Rab ke sāmne imām ko de. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Imām un meṅ se ek ko gunāh kī qurbānī ke taur par aur dūsre ko bhasm hone wālī qurbānī ke taur par chaṛhāe. Yoṅ wuh Rab ke sāmne us kā kaffārā degā. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Agar kisī mard kā nutfā ḳhārij ho jāe to wuh apne pūre jism ko dho le. Wuh shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Har kapṛā yā chamṛā jis se nutfā lag gayā ho use dhonā hai. Wuh bhī shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Agar mard aur aurat ke hambistar hone par nutfā ḳhārij ho jāe to lāzim hai ki donoṅ nahā leṅ. Wuh shām tak nāpāk raheṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Māhwārī ke waqt aurat sāt din tak nāpāk hai. Jo bhī use chhue wuh shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Is daurān jis chīz par bhī wuh leṭtī yā baiṭhtī hai wuh nāpāk hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","Jo bhī us ke leṭne kī jagah ko chhue yā us ke baiṭhne kī jagah par baiṭh jāe wuh apne kapṛe dho kar nahā le. Wuh shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Agar mard aurat se hambistar ho aur usī waqt māhwārī ke din shurū ho jāeṅ to mard ḳhūn lagne ke bāis sāt din tak nāpāk rahegā. Jis chīz par bhī wuh leṭtā hai wuh nāpāk ho jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Agar kisī aurat ko māhwārī ke din chhoṛ kar kisī aur waqt kaī dinoṅ tak ḳhūn āe yā ḳhūn māhwārī ke dinoṅ ke bād bhī jārī rahe to wuh māhwārī ke dinoṅ kī tarah us waqt tak nāpāk rahegī jab tak ḳhūn ruk na jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Jis chīz par bhī wuh leṭtī yā baiṭhtī hai wuh nāpāk hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Jo bhī aisī chīz ko chhue wuh apne kapṛe dho kar nahā le. Wuh shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Ḳhūn ke ruk jāne par aurat mazīd sāt din intazār kare. Phir wuh pāk hogī. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Āṭhweṅ din wuh do qumriyāṅ yā do jawān kabūtar le kar mulāqāt ke ḳhaime ke darwāze par imām ke pās āe. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Imām un meṅ se ek ko gunāh kī qurbānī ke lie aur dūsre ko bhasm hone wālī qurbānī ke lie chaṛhāe. Yoṅ wuh Rab ke sāmne us kī nāpākī kā kaffārā degā. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Lāzim hai ki Isrāīliyoṅ ko aisī chīzoṅ se dūr rakhā jāe jin se wuh nāpāk ho jāeṅ. Warnā merā wuh maqdis jo un ke darmiyān hai un se nāpāk ho jāegā aur wuh halāk ho jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Lāzim hai ki is qism ke muāmaloṅ se aise nipṭo jaise bayān kiyā gayā hai. Is meṅ wuh mard shāmil hai jo jaryān kā marīz hai aur wuh jo nutfā ḳhārij hone ke bāis nāpāk hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Is meṅ wuh aurat bhī shāmil hai jis ke māhwārī ke aiyām haiṅ aur wuh mard jo nāpāk aurat se hambistar ho jātā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Jab Hārūn ke do beṭe Rab ke qarīb ā kar halāk hue to is ke bād Rab Mūsā se hamkalām huā. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Us ne kahā, “Apne bhāī Hārūn ko batānā ki wuh sirf muqarrarā waqt par parde ke pīchhe Muqaddastarīn Kamre meṅ dāḳhil ho kar ahd ke sandūq ke ḍhakne ke sāmne khaṛā ho jāe, warnā wuh mar jāegā. Kyoṅki maiṅ ḳhud us ḍhakne ke ūpar bādal kī sūrat meṅ zāhir hotā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Aur jab bhī wuh dāḳhil ho to gunāh kī qurbānī ke lie ek jawān bail aur bhasm hone wālī qurbānī ke lie ek menḍhā pesh kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Pahle wuh nahā kar imām ke katān ke muqaddas kapṛe pahan le yānī zerjāmā, us ke nīche pājāmā, phir kamarband aur pagaṛī. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Isrāīl kī jamāt Hārūn ko gunāh kī qurbānī ke lie do bakre aur bhasm hone wālī qurbānī ke lie ek menḍhā de. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Pahle Hārūn apne aur apne gharāne ke lie jawān bail ko gunāh kī qurbānī ke taur par chaṛhāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Phir wuh donoṅ bakroṅ ko mulāqāt ke ḳhaime ke darwāze par Rab ke sāmne le āe. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Wahāṅ wuh qurā ḍāl kar ek ko Rab ke lie chune aur dūsre ko azāzel ke lie. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Jo bakrā Rab ke lie hai use wuh gunāh kī qurbānī ke taur par pesh kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Dūsrā bakrā jo qur'e ke zariye azāzel ke lie chunā gayā use zindā hālat meṅ Rab ke sāmne khaṛā kiyā jāe tāki wuh jamāt kā kaffārā de. Wahāṅ se use registān meṅ azāzel ke pās bhejā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Lekin pahle Hārūn jawān bail ko gunāh kī qurbānī ke taur par chaṛhā kar apnā aur apne gharāne kā kaffārā de. Use zabah karne ke bād ");
INSERT INTO urdgvr_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","wuh baḳhūr kī qurbāngāh se jalte hue koeloṅ se bharā huā bartan le kar apnī donoṅ muṭṭhiyāṅ bārīk ḳhushbūdār baḳhūr se bhar le aur Muqaddastarīn Kamre meṅ dāḳhil ho jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Wahāṅ wuh Rab ke huzūr baḳhūr ko jalte hue koeloṅ par ḍāl de. Is se paidā hone wālā dhuāṅ ahd ke sandūq kā ḍhaknā chhupā degā tāki Hārūn mar na jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Ab wuh jawān bail ke ḳhūn meṅ se kuchh le kar apnī unglī se ḍhakne ke sāmne wāle hisse par chhiṛke, phir kuchh apnī unglī se sāt bār us ke sāmne zamīn par chhiṛke. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Is ke bād wuh us bakre ko zabah kare jo qaum ke lie gunāh kī qurbānī hai. Wuh us kā ḳhūn Muqaddastarīn Kamre meṅ le āe aur use bail ke ḳhūn kī tarah ahd ke sandūq ke ḍhakne par aur sāt bār us ke sāmne zamīn par chhiṛke. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Yoṅ wuh Muqaddastarīn Kamre kā kaffārā degā jo Isrāīliyoṅ kī nāpākiyoṅ aur tamām gunāhoṅ se muta'assir hotā rahtā hai. Is se wuh mulāqāt ke pūre ḳhaime kā bhī kaffārā degā jo ḳhaimāgāh ke darmiyān hone ke bāis Isrāīliyoṅ kī nāpākiyoṅ se muta'assir hotā rahtā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Jitnā waqt Hārūn apnā, apne gharāne kā aur Isrāīl kī pūrī jamāt kā kaffārā dene ke lie Muqaddastarīn Kamre meṅ rahegā is daurān kisī dūsre ko mulāqāt ke ḳhaime meṅ ṭhaharne kī ijāzat nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Phir wuh Muqaddastarīn Kamre se nikal kar ḳhaime meṅ Rab ke sāmne paṛī qurbāngāh kā kaffārā de. Wuh bail aur bakre ke ḳhūn meṅ se kuchh le kar use qurbāngāh ke chāroṅ sīṅgoṅ par lagāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Kuchh ḳhūn wuh apnī unglī se sāt bār us par chhiṛak de. Yoṅ wuh use Isrāīliyoṅ kī nāpākiyoṅ se pāk karke maḳhsūs-o-muqaddas karegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Muqaddastarīn Kamre, mulāqāt ke ḳhaime aur qurbāngāh kā kaffārā dene ke bād Hārūn zindā bakre ko sāmne lāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Wuh apne donoṅ hāth us ke sar par rakhe aur Isrāīliyoṅ ke tamām qusūr yānī un ke tamām jarāym aur gunāhoṅ kā iqrār karke unheṅ bakre ke sar par ḍāl de. Phir wuh use registān meṅ bhej de. Is ke lie wuh bakre ko ek ādmī ke sapurd kare jise yih zimmedārī dī gaī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Bakrā apne āp par un kā tamām qusūr uṭhā kar kisī wīrān jagah meṅ le jāegā. Wahāṅ sāth wālā ādmī use chhoṛ āe. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Is ke bād Hārūn mulāqāt ke ḳhaime meṅ jāe aur katān ke wuh kapṛe jo us ne Muqaddastarīn Kamre meṅ dāḳhil hone se peshtar pahan lie the utār kar wahīṅ chhoṛ de. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Wuh muqaddas jagah par nahā kar apnī ḳhidmat ke ām kapṛe pahan le. Phir wuh bāhar ā kar apne aur apnī qaum ke lie bhasm hone wālī qurbānī pesh kare tāki apnā aur apnī qaum kā kaffārā de. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Is ke alāwā wuh gunāh kī qurbānī kī charbī qurbāngāh par jalā de. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Jo ādmī azāzel ke lie bakre ko registān meṅ chhoṛ āyā hai wuh apne kapṛe dho kar nahā le. Is ke bād wuh ḳhaimāgāh meṅ ā saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Jis bail aur bakre ko gunāh kī qurbānī ke lie pesh kiyā gayā aur jin kā ḳhūn kaffārā dene ke lie Muqaddastarīn Kamre meṅ lāyā gayā, lāzim hai ki un kī khāleṅ, gosht aur gobar ḳhaimāgāh ke bāhar jalā diyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Yih chīzeṅ jalāne wālā bād meṅ apne kapṛe dho kar nahā le. Phir wuh ḳhaimāgāh meṅ ā saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Lāzim hai ki sātweṅ mahīne ke dasweṅ din Isrāīlī aur un ke darmiyān rahne wāle pardesī apnī jān ko dukh deṅ aur kām na kareṅ. Yih usūl tumhāre lie abad tak qāym rahe. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Is din tumhārā kaffārā diyā jāegā tāki tumheṅ pāk kiyā jāe. Tab tum Rab ke sāmne apne tamām gunāhoṅ se pāk ṭhahroge. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Pūrā din ārām karo aur apnī jān ko dukh do. Yih usūl abad tak qāym rahe. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Is din imām-e-āzam tumhārā kaffārā de, wuh imām jise us ke bāp kī jagah masah kiyā gayā aur iḳhtiyār diyā gayā hai. Wuh katān ke muqaddas kapṛe pahan kar ");
INSERT INTO urdgvr_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Muqaddastarīn Kamre, mulāqāt ke ḳhaime, qurbāngāh, imāmoṅ aur jamāt ke tamām logoṅ kā kaffārā de. ");
INSERT INTO urdgvr_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Lāzim hai ki sāl meṅ ek dafā Isrāīliyoṅ ke tamām gunāhoṅ kā kaffārā diyā jāe. Yih usūl tumhāre lie abad tak qāym rahe.” Sab kuchh waise hī kiyā gayā jaisā Rab ne Mūsā ko hukm diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Hārūn, us ke beṭoṅ aur tamām Isrāīliyoṅ ko hidāyat denā ");
INSERT INTO urdgvr_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","ki jo bhī Isrāīlī apnī gāy yā bheṛ-bakrī mulāqāt ke ḳhaime ke darwāze par Rab ko qurbānī ke taur par pesh na kare balki ḳhaimāgāh ke andar yā bāhar kisī aur jagah par zabah kare wuh ḳhūn bahāne kā qusūrwār ṭhahregā. Us ne ḳhūn bahāyā hai, aur lāzim hai ki use us kī qaum meṅ se miṭāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Is hidāyat kā maqsad yih hai ki Isrāīlī ab se apnī qurbāniyāṅ khule maidān meṅ zabah na kareṅ balki Rab ko pesh kareṅ. Wuh apne jānwaroṅ ko mulāqāt ke ḳhaime ke darwāze par imām ke pās lā kar unheṅ Rab ko salāmatī kī qurbānī ke taur par pesh kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Imām un kā ḳhūn mulāqāt ke ḳhaime ke darwāze par kī qurbāngāh par chhiṛke aur un kī charbī us par jalā de. Aisī qurbānī kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ab se Isrāīlī apnī qurbāniyāṅ un bakroṅ ke dewatāoṅ ko pesh na kareṅ jin kī pairawī karke unhoṅ ne zinā kiyā hai. Yih un ke lie aur un ke bād āne wālī nasloṅ ke lie ek dāymī usūl hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Lāzim hai ki har Isrāīlī aur tumhāre darmiyān rahne wālā pardesī apnī bhasm hone wālī qurbānī yā koī aur qurbānī ");
INSERT INTO urdgvr_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","mulāqāt ke ḳhaime ke darwāze par lā kar Rab ko pesh kare. Warnā use us kī qaum meṅ se miṭāyā jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Ḳhūn khānā bilkul manā hai. Jo bhī Isrāīlī yā tumhāre darmiyān rahne wālā pardesī ḳhūn khāe maiṅ us ke ḳhilāf ho jāūṅgā aur use us kī qaum meṅ se miṭā ḍālūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Kyoṅki har maḳhlūq ke ḳhūn meṅ us kī jān hai. Maiṅ ne use tumheṅ de diyā hai tāki wuh qurbāngāh par tumhārā kaffārā de. Kyoṅki ḳhūn hī us jān ke zariye jo us meṅ hai tumhārā kaffārā detā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Is lie maiṅ kahtā hūṅ ki na koī Isrāīlī na koī pardesī ḳhūn khāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Agar koī bhī Isrāīlī yā pardesī kisī jānwar yā parinde kā shikār karke pakaṛe jise khāne kī ijāzat hai to wuh use zabah karne ke bād us kā pūrā ḳhūn zamīn par bahne de aur ḳhūn par miṭṭī ḍāle. ");
INSERT INTO urdgvr_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Kyoṅki har maḳhlūq kā ḳhūn us kī jān hai. Is lie maiṅ ne Isrāīliyoṅ ko kahā hai ki kisī bhī maḳhlūq kā ḳhūn na khāo. Har maḳhlūq kā ḳhūn us kī jān hai, aur jo bhī use khāe use qaum meṅ se miṭā denā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Agar koī bhī Isrāīlī yā pardesī aise jānwar kā gosht khāe jo fitrī taur par mar gayā yā jise janglī jānwaroṅ ne phāṛ ḍālā ho to wuh apne kapṛe dho kar nahā le. Wuh shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Jo aisā nahīṅ kartā use apne qusūr kī sazā bhugatnī paṛegī.” ");
INSERT INTO urdgvr_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Isrāīliyoṅ ko batānā ki maiṅ Rab tumhārā Ḳhudā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Misriyoṅ kī tarah zindagī na guzārnā jin meṅ tum rahte the. Mulk-e-Kanān ke logoṅ kī tarah bhī zindagī na guzārnā jin ke pās maiṅ tumheṅ le jā rahā hūṅ. Un ke rasm-o-riwāj na apnānā. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Mere hī ahkām par amal karo aur merī hidāyāt ke mutābiq chalo. Maiṅ Rab tumhārā Ḳhudā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Merī hidāyāt aur ahkām ke mutābiq chalnā, kyoṅki jo yoṅ karegā wuh jītā rahegā. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Tum meṅ se koī bhī apnī qarībī rishtedār se hambistar na ho. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Apnī māṅ se hambistar na honā, warnā tere bāp kī behurmatī ho jāegī. Wuh terī māṅ hai, is lie us se hambistar na honā. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Apne bāp kī kisī bhī bīwī se hambistar na honā, warnā tere bāp kī behurmatī ho jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Apnī bahan se hambistar na honā, chāhe wuh tere bāp yā terī māṅ kī beṭī ho, chāhe wuh tere hī ghar meṅ yā kahīṅ aur paidā huī ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Apnī potī yā nawāsī se hambistar na honā, warnā terī apnī behurmatī ho jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Apne bāp kī bīwī kī beṭī se hambistar na honā. Wuh terī bahan hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Apnī phūphī se hambistar na honā. Wuh tere bāp kī qarībī rishtedār hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Apnī ḳhālā se hambistar na honā. Wuh terī māṅ kī qarībī rishtedār hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Apne bāp ke bhāī kī bīwī se hambistar na honā, warnā tere bāp ke bhāī kī behurmatī ho jāegī. Us kī bīwī terī chachī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Apnī bahū se hambistar na honā. Wuh tere beṭe kī bīwī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Apnī bhābī se hambistar na honā, warnā tere bhāī kī behurmatī ho jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Agar terā jinsī tālluq kisī aurat se ho to us kī beṭī, potī yā nawāsī se hambistar honā manā hai, kyoṅki wuh us kī qarībī rishtedār haiṅ. Aisā karnā baṛī sharmnāk harkat hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Apnī bīwī ke jīte-jī us kī bahan se shādī na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Kisī aurat se us kī māhwārī ke dinoṅ meṅ hambistar na honā. Is daurān wuh nāpāk hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Kisī dūsre mard kī bīwī se hambistar na honā, warnā tū apne āp ko nāpāk karegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Apne kisī bhī bachche ko Malik Dewatā ko qurbānī ke taur par pesh karke jalā denā manā hai. Aisī harkat se tū apne Ḳhudā ke nām ko dāġh lagāegā. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Mard dūsre mard ke sāth jinsī tālluqāt na rakhe. Aisī harkat qābil-e-ghin hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Kisī jānwar se jinsī tālluqāt na rakhnā, warnā tū nāpāk ho jāegā. Auratoṅ ke lie bhī aisā karnā manā hai. Yih baṛī sharmnāk harkat hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Aisī harkatoṅ se apne āp ko nāpāk na karnā. Kyoṅki jo qaumeṅ maiṅ tumhāre āge mulk se nikālūṅgā wuh isī tarah nāpāk hotī rahīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Mulk ḳhud bhī nāpāk huā. Is lie maiṅ ne use us ke qusūr ke sabab se sazā dī, aur natīje meṅ us ne apne bāshindoṅ ko ugal diyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Lekin tum merī hidāyāt aur ahkām ke mutābiq chalo. Na desī aur na pardesī aisī koī ghinaunī harkat kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Kyoṅki yih tamām qābil-e-ghin bāteṅ un se huīṅ jo tum se pahle is mulk meṅ rahte the. Yoṅ mulk nāpāk huā. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Lihāzā agar tum bhī mulk ko nāpāk karoge to wuh tumheṅ isī tarah ugal degā jis tarah us ne tum se pahle maujūd qaumoṅ ko ugal diyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Jo bhī mazkūrā ghinaunī harkatoṅ meṅ se ek kare use us kī qaum meṅ se miṭāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Mere ahkām ke mutābiq chalte raho aur aise qābil-e-ghin rasm-o-riwāj na apnānā jo tumhāre āne se pahle rāyj the. In se apne āp ko nāpāk na karnā. Maiṅ Rab tumhārā Ḳhudā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Isrāīliyoṅ kī pūrī jamāt ko batānā ki muqaddas raho, kyoṅki maiṅ Rab tumhārā Ḳhudā quddūs hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Tum meṅ se har ek apne māṅ-bāp kī izzat kare. Hafte ke din kām na karnā. Maiṅ Rab tumhārā Ḳhudā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Na butoṅ kī taraf rujū karnā, na apne lie dewatā ḍhālnā. Maiṅ hī Rab tumhārā Ḳhudā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Jab tum Rab ko salāmatī kī qurbānī pesh karte ho to use yoṅ chaṛhāo ki tum manzūr ho jāo. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Us kā gosht usī din yā agle din khāyā jāe. Jo bhī tīsre din tak bach jātā hai use jalānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Agar koī use tīsre din khāe to use ilm honā chāhie ki yih qurbānī nāpāk hai aur Rab ko pasand nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Aise shaḳhs ko apne qusūr kī sazā uṭhānī paṛegī, kyoṅki us ne us chīz kī muqaddas hālat ḳhatm kī hai jo Rab ke lie maḳhsūs kī gaī thī. Use us kī qaum meṅ se miṭāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Kaṭāī ke waqt apnī fasal pūre taur par na kāṭnā balki khet ke kināroṅ par kuchh chhoṛ denā. Is tarah jo kuchh kaṭāī karte waqt khet meṅ bach jāe use chhoṛnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Angūr ke bāġhoṅ meṅ bhī jo kuchh angūr toṛte waqt bach jāe use chhoṛ denā. Jo angūr zamīn par gir jāeṅ unheṅ uṭhā kar na le jānā. Unheṅ ġharīboṅ aur pardesiyoṅ ke lie chhoṛ denā. Maiṅ Rab tumhārā Ḳhudā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Chorī na karnā, jhūṭ na bolnā, ek dūsre ko dhokā na denā. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Mere nām kī qasam khā kar dhokā na denā, warnā tum mere nām ko dāġh lagāoge. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Ek dūsre ko na dabānā aur na lūṭnā. Kisī kī mazdūrī usī din kī shām tak de denā aur use aglī subah tak roke na rakhnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Bahre ko na kosnā, na andhe ke rāste meṅ koī chīz rakhnā jis se wuh ṭhokar khāe. Is meṅ bhī apne Ḳhudā kā ḳhauf mānanā. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Adālat meṅ kisī kī haqtalfī na karnā. Faislā karte waqt kisī kī bhī jānibdārī na karnā, chāhe wuh ġharīb yā asar-o-rasūḳh wālā ho. Insāf se apne paṛosī kī adālat kar. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Apnī qaum meṅ idhar-udhar phirte hue kisī par buhtān na lagānā. Koī bhī aisā kām na karnā jis se kisī kī jān ḳhatre meṅ paṛ jāe. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Dil meṅ apne bhāī se nafrat na karnā. Agar kisī kī sarzanish karnī hai to rūbarū karnā, warnā tū us ke sabab se qusūrwār ṭhahregā. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Intaqām na lenā. Apnī qaum ke kisī shaḳhs par der tak terā ġhussā na rahe balki apne paṛosī se waisī muhabbat rakhnā jaisī tū apne āp se rakhtā hai. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Merī hidāyāt par amal karo. Do muḳhtalif qism ke jānwaroṅ ko milāp na karne denā. Apne khet meṅ do qism ke bīj na bonā. Aisā kapṛā na pahnanā jo do muḳhtalif qism ke dhāgoṅ kā bunā huā ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Agar koī ādmī kisī launḍī se jis kī mangnī kisī aur se ho chukī ho hambistar ho jāe aur launḍī ko ab tak na paisoṅ se na waise hī āzād kiyā gayā ho to munāsib sazā dī jāe. Lekin unheṅ sazā-e-maut na dī jāe, kyoṅki use ab tak āzād nahīṅ kiyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Qusūrwār ādmī mulāqāt ke ḳhaime ke darwāze par ek menḍhā le āe tāki wuh Rab ko qusūr kī qurbānī ke taur par pesh kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Imām is qurbānī se Rab ke sāmne us ke gunāh kā kaffārā de. Yoṅ us kā gunāh muāf kiyā jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Jab Mulk-e-Kanān meṅ dāḳhil hone ke bād tum phaldār daraḳht lagāoge to pahle tīn sāl un kā phal na khānā balki use mamnū samajhnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Chauthe sāl un kā tamām phal ḳhushī ke muqaddas nazarāne ke taur par Rab ke lie maḳhsūs kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Pāṅchweṅ sāl tum un kā phal khā sakte ho. Yoṅ tumhārī fasal baṛhāī jāegī. Maiṅ Rab tumhārā Ḳhudā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Aisā gosht na khānā jis meṅ ḳhūn ho. Fāl yā shugūn na nikālnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Apne sar ke bāl gol shakl meṅ na kaṭwānā, na apnī dāṛhī ko tarāshnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Apne āp ko murdoṅ ke sabab se kāṭ kar zaḳhmī na karnā, na apnī jild par nuqūsh gudwānā. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Apnī beṭī ko kasbī na banānā, warnā us kī muqaddas hālat jātī rahegī aur mulk zinākārī ke bāis harāmkārī se bhar jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Hafte ke din ārām karnā aur mere maqdis kā ehtirām karnā. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Aise logoṅ ke pās na jānā jo murdoṅ se rābitā karte haiṅ, na ġhaibdānoṅ kī taraf rujū karnā, warnā tum un se nāpāk ho jāoge. Maiṅ Rab tumhārā Ḳhudā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Būṛhe logoṅ ke sāmne uṭh kar khaṛā ho jānā, buzurgoṅ kī izzat karnā aur apne Ḳhudā kā ehtirām karnā. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Jo pardesī tumhāre mulk meṅ tumhāre darmiyān rahtā hai use na dabānā. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Us ke sāth aisā sulūk kar jaisā apne hamwatanoṅ ke sāth kartā hai. Jis tarah tū apne āp se muhabbat rakhtā hai usī tarah us se bhī muhabbat rakhnā. Yād rahe ki tum ḳhud Misr meṅ pardesī the. Maiṅ Rab tumhārā Ḳhudā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Nāinsāfī na karnā. Na adālat meṅ, na lambāī nāpte waqt, na tolte waqt aur na kisī chīz kī miqdār nāpte waqt. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Sahīh tarāzū, sahīh bāṭ aur sahīh paimānā istemāl karnā. Maiṅ Rab tumhārā Ḳhudā hūṅ jo tumheṅ Misr se nikāl lāyā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Merī tamām hidāyāt aur tamām ahkām māno aur un par amal karo. Maiṅ Rab hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Isrāīliyoṅ ko batānā ki tum meṅ se jo bhī apne bachche ko Malik Dewatā ko qurbānī ke taur par pesh kare use sazā-e-maut denī hai. Is meṅ koī farq nahīṅ ki wuh Isrāīlī hai yā pardesī. Jamāt ke log use sangsār kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Maiṅ ḳhud aise shaḳhs ke ḳhilāf ho jāūṅgā aur use us kī qaum meṅ se miṭā ḍālūṅgā. Kyoṅki apne bachchoṅ ko Malik ko pesh karne se us ne mere maqdis ko nāpāk kiyā aur mere nām ko dāġh lagāyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Agar jamāt ke log apnī āṅkheṅ band karke aise shaḳhs kī harkateṅ nazarandāz kareṅ aur use sazā-e-maut na deṅ ");
INSERT INTO urdgvr_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","to phir maiṅ ḳhud aise shaḳhs aur us ke gharāne ke ḳhilāf khaṛā ho jāūṅgā. Maiṅ use aur un tamām logoṅ ko qaum meṅ se miṭā ḍālūṅgā jinhoṅ ne us ke pīchhe lag kar Malik Dewatā ko sijdā karne se zinā kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Jo shaḳhs murdoṅ se rābitā karne aur ġhaibdānī karne wāloṅ kī taraf rujū kartā hai maiṅ us ke ḳhilāf ho jāūṅgā. Un kī pairawī karne se wuh zinā kartā hai. Maiṅ use us kī qaum meṅ se miṭā ḍālūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Apne āp ko mere lie maḳhsūs-o-muqaddas rakho, kyoṅki maiṅ Rab tumhārā Ḳhudā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Merī hidāyāt māno aur un par amal karo. Maiṅ Rab hūṅ jo tumheṅ maḳhsūs-o-muqaddas kartā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Jis ne bhī apne bāp yā māṅ par lānat bhejī hai use sazā-e-maut dī jāe. Is harkat se wuh apnī maut kā ḳhud zimmedār hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Agar kisī mard ne kisī kī bīwī ke sāth zinā kiyā hai to donoṅ ko sazā-e-maut denī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Jo mard apne bāp kī bīwī se hambistar huā hai us ne apne bāp kī behurmatī kī hai. Donoṅ ko sazā-e-maut denī hai. Wuh apnī maut ke ḳhud zimmedār haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Agar koī mard apnī bahū se hambistar huā hai to donoṅ ko sazā-e-maut denī hai. Jo kuchh unhoṅ ne kiyā hai wuh nihāyat sharmnāk hai. Wuh apnī maut ke ḳhud zimmedār haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Agar koī mard kisī dūsre mard se jinsī tālluqāt rakhe to donoṅ ko is ghinaunī harkat ke bāis sazā-e-maut denī hai. Wuh apnī maut ke ḳhud zimmedār haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Agar koī ādmī apnī bīwī ke alāwā us kī māṅ se bhī shādī kare to yih ek nihāyat sharmnāk bāt hai. Donoṅ ko jalā denā hai tāki tumhāre darmiyān koī aisī ḳhabīs bāt na rahe. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Jo mard kisī jānwar se jinsī tālluqāt rakhe use sazā-e-maut denā hai. Us jānwar ko bhī mār diyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Jo aurat kisī jānwar se jinsī tālluqāt rakhe use sazā-e-maut denī hai. Us jānwar ko bhī mār diyā jāe. Wuh apnī maut ke ḳhud zimmedār haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Jis mard ne apnī bahan se shādī kī hai us ne sharmnāk harkat kī hai, chāhe wuh bāp kī beṭī ho yā māṅ kī. Unheṅ Isrāīlī qaum kī nazaroṅ se miṭāyā jāe. Aise shaḳhs ne apnī bahan kī behurmatī kī hai. Is lie use ḳhud apne qusūr ke natīje bardāsht karne paṛeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Agar koī mard māhwārī ke aiyām meṅ kisī aurat se hambistar huā hai to donoṅ ko un kī qaum meṅ se miṭānā hai. Kyoṅki donoṅ ne aurat ke ḳhūn ke mambā se pardā uṭhāyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Apnī ḳhālā yā phūphī se hambistar na honā. Kyoṅki jo aisā kartā hai wuh apnī qarībī rishtedār kī behurmatī kartā hai. Donoṅ ko apne qusūr ke natīje bardāsht karne paṛeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Jo apnī chachī yā tāī se hambistar huā hai us ne apne chachā yā tāyā kī behurmatī kī hai. Donoṅ ko apne qusūr ke natīje bardāsht karne paṛeṅge. Wuh beaulād mareṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Jis ne apnī bhābī se shādī kī hai us ne ek najis harkat kī hai. Us ne apne bhāī kī behurmatī kī hai. Wuh beaulād raheṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Merī tamām hidāyāt aur ahkām ko māno aur un par amal karo. Warnā jis mulk meṅ maiṅ tumheṅ le jā rahā hūṅ wuh tumheṅ ugal degā. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Un qaumoṅ ke rasm-o-riwāj ke mutābiq zindagī na guzārnā jinheṅ maiṅ tumhāre āge se nikāl dūṅgā. Mujhe is sabab se un se ghin āne lagī ki wuh yih sab kuchh karte the. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Lekin tum se maiṅ ne kahā, ‘Tum hī un kī zamīn par qabzā karoge. Maiṅ hī use tumheṅ de dūṅgā, aisā mulk jis meṅ kasrat kā dūdh aur shahd hai.’ Maiṅ Rab tumhārā Ḳhudā hūṅ, jis ne tum ko dīgar qaumoṅ meṅ se chun kar alag kar diyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Is lie lāzim hai ki tum zamīn par chalne wāle jānwaroṅ aur parindoṅ meṅ pāk aur nāpāk kā imtiyāz karo. Apne āp ko nāpāk jānwar khāne se qābil-e-ghin na banānā, chāhe wuh zamīn par chalte yā reṅgte haiṅ, chāhe hawā meṅ uṛte haiṅ. Maiṅ hī ne unheṅ tumhāre lie nāpāk qarār diyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Tumheṅ mere lie maḳhsūs-o-muqaddas honā hai, kyoṅki maiṅ quddūs hūṅ, aur maiṅ ne tumheṅ dīgar qaumoṅ meṅ se chun kar apne lie alag kar liyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Tum meṅ se jo murdoṅ se rābitā yā ġhaibdānī kartā hai use sazā-e-maut denī hai, ḳhāh aurat ho yā mard. Unheṅ sangsār karnā. Wuh apnī maut ke ḳhud zimmedār haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Rab ne Mūsā se kahā, “Hārūn ke beṭoṅ ko jo imām haiṅ batā denā ki imām apne āp ko kisī Isrāīlī kī lāsh ke qarīb jāne se nāpāk na kare ");
INSERT INTO urdgvr_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","siwāe apne qarībī rishtedāroṅ ke yānī māṅ, bāp, beṭā, beṭī, bhāī ");
INSERT INTO urdgvr_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","aur jo ġhairshādīshudā bahan us ke ghar meṅ rahtī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Wuh apnī qaum meṅ kisī aur ke bāis apne āp ko nāpāk na kare, warnā us kī muqaddas hālat jātī rahegī. ");
INSERT INTO urdgvr_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Imām apne sar ko na munḍwāeṅ. Wuh na apnī dāṛhī ko tarāsheṅ aur na kāṭne se apne āp ko zaḳhmī kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Wuh apne Ḳhudā ke lie maḳhsūs-o-muqaddas raheṅ aur apne Ḳhudā ke nām ko dāġh na lagāeṅ. Chūṅki wuh Rab ko jalne wālī qurbāniyāṅ yānī apne Ḳhudā kī roṭī pesh karte haiṅ is lie lāzim hai ki wuh muqaddas raheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Imām zinākār aurat, mandir kī kasbī yā talāqyāftā aurat se shādī na kareṅ, kyoṅki wuh apne Rab ke lie maḳhsūs-o-muqaddas haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Imām ko muqaddas samajhnā, kyoṅki wuh tere Ḳhudā kī roṭī ko qurbāngāh par chaṛhātā hai. Wuh tere lie muqaddas ṭhahre kyoṅki maiṅ Rab quddūs hūṅ. Maiṅ hī tumheṅ muqaddas kartā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Kisī imām kī jo beṭī zinākārī se apnī muqaddas hālat ko ḳhatm kar detī hai wuh apne bāp kī muqaddas hālat ko bhī ḳhatm kar detī hai. Use jalā diyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Imām-e-āzam ke sar par masah kā tel unḍelā gayā hai aur use imām-e-āzam ke muqaddas kapṛe pahnane kā iḳhtiyār diyā gayā hai. Is lie wuh ranj ke ālam meṅ apne bāloṅ ko bikharne na de, na kabhī apne kapṛoṅ ko phāṛe. ");
INSERT INTO urdgvr_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Wuh kisī lāsh ke qarīb na jāe, chāhe wuh us ke bāp yā māṅ kī lāsh kyoṅ na ho, warnā wuh nāpāk ho jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Jab tak koī lāsh us ke ghar meṅ paṛī rahe wuh maqdis ko chhoṛ kar apne ghar na jāe, warnā wuh maqdis ko nāpāk karegā. Kyoṅki use us ke Ḳhudā ke tel se maḳhsūs kiyā gayā hai. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Imām-e-āzam ko sirf kuṅwārī se shādī kī ijāzat hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Wuh bewā, talāqyāftā aurat, mandir kī kasbī yā zinākār aurat se shādī na kare balki sirf apne qabīle kī kuṅwārī se, ");
INSERT INTO urdgvr_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","warnā us kī aulād maḳhsūs-o-muqaddas nahīṅ hogī. Kyoṅki maiṅ Rab hūṅ jo use apne lie maḳhsūs-o-muqaddas kartā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Rab ne Mūsā se yih bhī kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Hārūn ko batānā ki terī aulād meṅ se koī bhī jis ke jism meṅ nuqs ho mere huzūr ā kar apne Ḳhudā kī roṭī na chaṛhāe. Yih usūl āne wālī nasloṅ ke lie bhī aṭal hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Kyoṅki koī bhī māzūr mere huzūr na āe, na andhā, na langaṛā, na wuh jis kī nāk chirī huī ho yā jis ke kisī azu meṅ kamī beshī ho, ");
INSERT INTO urdgvr_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","na wuh jis kā pāṅw yā hāth ṭūṭā huā ho, ");
INSERT INTO urdgvr_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","na kubaṛā, na baunā, na wuh jis kī āṅkh meṅ nuqs ho yā jise wabāī jildī bīmārī ho yā jis ke ḳhusye kuchle hue hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Hārūn Imām kī koī bhī aulād jis ke jism meṅ nuqs ho mere huzūr ā kar Rab ko jalne wālī qurbāniyāṅ pesh na kare. Chūṅki us meṅ nuqs hai is lie wuh mere huzūr ā kar apne Ḳhudā kī roṭī na chaṛhāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Use Allāh kī muqaddas balki muqaddastarīn qurbāniyoṅ meṅ se bhī imāmoṅ kā hissā khāne kī ijāzat hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Lekin chūṅki us meṅ nuqs hai is lie wuh Muqaddastarīn Kamre ke darwāze ke parde ke qarīb na jāe, na qurbāngāh ke pās āe. Warnā wuh merī muqaddas chīzoṅ ko nāpāk karegā. Kyoṅki maiṅ Rab hūṅ jo unheṅ apne lie maḳhsūs-o-muqaddas kartā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Mūsā ne yih hidāyāt Hārūn, us ke beṭoṅ aur tamām Isrāīliyoṅ ko dīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Hārūn aur us ke beṭoṅ ko batānā ki Isrāīliyoṅ kī un qurbāniyoṅ kā ehtirām karo jo tum ne mere lie maḳhsūs-o-muqaddas kī haiṅ, warnā tum mere nām ko dāġh lagāoge. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Jo imām nāpāk hone ke bāwujūd un qurbāniyoṅ ke pās ā jāe jo Isrāīliyoṅ ne mere lie maḳhsūs-o-muqaddas kī haiṅ use mere sāmne se miṭānā hai. Yih usūl āne wālī nasloṅ ke lie bhī aṭal hai. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Hārūn kī aulād meṅ se jo bhī wabāī jildī bīmārī yā jaryān kā marīz ho use muqaddas qurbāniyoṅ meṅ se apnā hissā khāne kī ijāzat nahīṅ hai. Pahle wuh pāk ho jāe. Jo aisī koī bhī chīz chhue jo lāsh se nāpāk ho gaī ho yā aise ādmī ko chhue jis kā nutfā niklā ho wuh nāpāk ho jātā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Wuh nāpāk reṅgne wāle jānwar yā nāpāk shaḳhs ko chhūne se bhī nāpāk ho jātā hai, ḳhāh wuh kisī bhī sabab se nāpāk kyoṅ na huā ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Jo aisī koī bhī chīz chhue wuh shām tak nāpāk rahegā. Is ke alāwā lāzim hai ki wuh muqaddas qurbāniyoṅ meṅ se apnā hissā khāne se pahle nahā le. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Sūraj ke ġhurūb hone par wuh pāk hogā aur muqaddas qurbāniyoṅ meṅ se apnā hissā khā sakegā. Kyoṅki wuh us kī rozī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Imām aise jānwaroṅ kā gosht na khāe jo fitrī taur par mar gae yā jinheṅ janglī jānwaroṅ ne phāṛ ḍālā ho, warnā wuh nāpāk ho jāegā. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Imām merī hidāyāt ke mutābiq chaleṅ, warnā wuh qusūrwār ban jāeṅge aur muqaddas chīzoṅ kī behurmatī karne ke sabab se mar jāeṅge. Maiṅ Rab hūṅ jo unheṅ apne lie maḳhsūs-o-muqaddas kartā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Sirf imām ke ḳhāndān ke afrād muqaddas qurbāniyoṅ meṅ se khā sakte haiṅ. Ġhairshahrī yā mazdūr ko ijāzat nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Lekin imām kā ġhulām yā launḍī us meṅ se khā sakte haiṅ, chāhe unheṅ ḳharīdā gayā ho yā wuh us ke ghar meṅ paidā hue hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Agar imām kī beṭī ne kisī aise shaḳhs se shādī kī hai jo imām nahīṅ hai to use muqaddas qurbāniyoṅ meṅ se khāne kī ijāzat nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Lekin ho saktā hai ki wuh bewā yā talāqyāftā ho aur us ke bachche na hoṅ. Jab wuh apne bāp ke ghar lauṭ kar wahāṅ aise rahegī jaise apnī jawānī meṅ to wuh apne bāp ke us khāne meṅ se khā saktī hai jo qurbāniyoṅ meṅ se bāp kā hissā hai. Lekin jo imām ke ḳhāndān kā fard nahīṅ hai use khāne kī ijāzat nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Jis shaḳhs ne nādānistā taur par muqaddas qurbāniyoṅ meṅ se imām ke hisse se kuchh khāyā hai wuh imām ko sab kuchh wāpas karne ke alāwā 20 fīsad zyādā de. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Imām Rab ko pesh kī huī qurbāniyoṅ kī muqaddas hālat yoṅ ḳhatm na kareṅ ");
INSERT INTO urdgvr_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ki wuh dūsre Isrāīliyoṅ ko yih muqaddas chīzeṅ khāne deṅ. Aisī harkat se wuh un ko baṛā qusūrwār banā deṅge. Maiṅ Rab hūṅ jo unheṅ apne lie maḳhsūs-o-muqaddas kartā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Hārūn, us ke beṭoṅ aur Isrāīliyoṅ ko batānā ki agar tum meṅ se koī Isrāīlī yā pardesī Rab ko bhasm hone wālī qurbānī pesh karnā chāhe to tarīq-e-kār meṅ koī farq nahīṅ hai, chāhe wuh yih mannat mān kar yā waise hī dilī ḳhushī se kar rahā ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Is ke lie lāzim hai ki tum ek beaib bail, menḍhā yā bakrā pesh karo. Phir hī use qabūl kiyā jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Qurbānī ke lie kabhī bhī aisā jānwar pesh na karnā jis meṅ nuqs ho, warnā tum us ke bāis manzūr nahīṅ hoge. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Agar koī Rab ko salāmatī kī qurbānī pesh karnā chāhe to tarīq-e-kār meṅ koī farq nahīṅ hai, chāhe wuh yih mannat mān kar yā waise hī dilī ḳhushī se kar rahā ho. Is ke lie lāzim hai ki wuh gāy-bailoṅ yā bheṛ-bakriyoṅ meṅ se beaib jānwar chune. Phir use qabūl kiyā jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Rab ko aise jānwar pesh na karnā jo andhe hoṅ, jin ke āzā ṭūṭe yā kaṭe hue hoṅ, jin ko rasaulī ho yā jinheṅ wabāī jildī bīmārī lag gaī ho. Rab ko unheṅ jalne wālī qurbānī ke taur par qurbāngāh par pesh na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Lekin jis gāy-bail yā bheṛ-bakrī ke kisī azu meṅ kamī beshī ho use pesh kiyā jā saktā hai. Shart yih hai ki pesh karne wālā use waise hī dilī ḳhushī se chaṛhāe. Agar wuh use apnī mannat mān kar pesh kare to wuh qabūl nahīṅ kiyā jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Rab ko aisā jānwar pesh na karnā jis ke ḳhusye kuchle, toṛe yā kaṭe hue hoṅ. Apne mulk meṅ jānwaroṅ ko is tarah ḳhasī na banānā, ");
INSERT INTO urdgvr_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","na aise jānwar kisī ġhairmulkī se ḳharīd kar apne Ḳhudā kī roṭī ke taur par pesh karnā. Tum aise jānwaroṅ ke bāis manzūr nahīṅ hoge, kyoṅki un meṅ ḳharābī aur nuqs hai.” ");
INSERT INTO urdgvr_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Rab ne Mūsā se yih bhī kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Jab kisī gāy, bheṛ yā bakrī kā bachchā paidā hotā hai to lāzim hai ki wuh pahle sāt din apnī māṅ ke pās rahe. Āṭhweṅ din se pahle Rab use jalne wālī qurbānī ke taur par qabūl nahīṅ karegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Kisī gāy, bheṛ yā bakrī ke bachche ko us kī māṅ samet ek hī din zabah na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Jab tum Rab ko salāmatī kī koī qurbānī chaṛhānā chāhte ho to use yoṅ pesh karnā ki tum manzūr ho jāo. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Aglī subah tak kuchh bachā na rahe balki use usī din khānā hai. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Mere ahkām māno aur un par amal karo. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Mere nām ko dāġh na lagānā. Lāzim hai ki mujhe Isrāīliyoṅ ke darmiyān quddūs mānā jāe. Maiṅ Rab hūṅ jo tumheṅ apne lie maḳhsūs-o-muqaddas kartā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Maiṅ tumheṅ Misr se nikāl lāyā hūṅ tāki tumhārā Ḳhudā hūṅ. Maiṅ Rab hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Isrāīliyoṅ ko batānā ki yih merī, Rab kī īdeṅ haiṅ jin par tumheṅ logoṅ ko muqaddas ijtimā ke lie jamā karnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Hafte meṅ chhih din kām karnā, lekin sātwāṅ din har tarah se ārām kā din hai. Us din muqaddas ijtimā ho. Jahāṅ bhī tum rahte ho wahāṅ kām na karnā. Yih din Rab ke lie maḳhsūs Sabat hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Yih Rab kī īdeṅ haiṅ jin par tumheṅ logoṅ ko muqaddas ijtimā ke lie jamā karnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Fasah kī Īd pahle mahīne ke chaudhweṅ din shurū hotī hai. Us din sūraj ke ġhurūb hone par Rab kī ḳhushī manāī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Agle din Rab kī yād meṅ Beḳhamīrī Roṭī kī Īd shurū hotī hai. Sāt din tak tumhārī roṭī meṅ ḳhamīr na ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","In sāt dinoṅ ke pahle din muqaddas ijtimā ho aur log apnā har kām chhoṛeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","In sāt dinoṅ meṅ rozānā Rab ko jalne wālī qurbānī pesh karo. Sātweṅ din bhī muqaddas ijtimā ho aur log apnā har kām chhoṛeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Isrāīliyoṅ ko batānā ki jab tum us mulk meṅ dāḳhil hoge jo maiṅ tumheṅ dūṅgā aur wahāṅ anāj kī fasal kāṭoge to tumheṅ imām ko pahlā pūlā denā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Itwār ko imām yih pūlā Rab ke sāmne hilāe tāki tum manzūr ho jāo. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Us din bheṛ kā ek yaksālā beaib bachchā bhī Rab ko pesh karnā. Use qurbāngāh par bhasm hone wālī qurbānī ke taur par chaṛhānā. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Sāth hī ġhallā kī nazar ke lie tel se milāyā gayā 3 kilogrām behtarīn maidā bhī pesh karnā. Jalne wālī yih qurbānī Rab ko pasand hai. Is ke alāwā mai kī nazar ke lie ek liṭar mai bhī pesh karnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Pahle yih sab kuchh karo, phir hī tumheṅ naī fasal ke anāj se khāne kī ijāzat hogī, ḳhāh wuh bhunā huā ho, ḳhāh kachchā yā roṭī kī sūrat meṅ pakāyā gayā ho. Jahāṅ bhī tum rahte ho wahāṅ aisā hī karnā hai. Yih usūl abad tak qāym rahe. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Jis din tum ne anāj kā pūlā pesh kiyā us din se pūre sāt hafte gino. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Pachāsweṅ din yānī sātweṅ Itwār ko Rab ko nae anāj kī qurbānī chaṛhānā. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Har gharāne kī taraf se Rab ko hilāne wālī qurbānī ke taur par do roṭiyāṅ pesh kī jāeṅ. Har roṭī ke lie 3 kilogrām behtarīn maidā istemāl kiyā jāe. Un meṅ ḳhamīr ḍāl kar pakānā hai. Yih fasal kī pahlī paidāwār kī qurbānī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","In roṭiyoṅ ke sāth ek jawān bail, do menḍhe aur bheṛ ke sāt beaib aur yaksālā bachche pesh karo. Unheṅ Rab ke huzūr bhasm hone wālī qurbānī ke taur par chaṛhānā. Is ke alāwā ġhallā kī nazar aur mai kī nazar bhī pesh karnī hai. Jalne wālī is qurbānī kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Phir gunāh kī qurbānī ke lie ek bakrā aur salāmatī kī qurbānī ke lie do yaksālā bheṛ ke bachche chaṛhāo. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Imām bheṛ ke yih do bachche mazkūrā roṭiyoṅ samet hilāne wālī qurbānī ke taur par Rab ke sāmne hilāe. Yih Rab ke lie maḳhsūs-o-muqaddas haiṅ aur qurbāniyoṅ meṅ se imām kā hissā haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Usī din logoṅ ko muqaddas ijtimā ke lie jamā karo. Koī bhī kām na karnā. Yih usūl abad tak qāym rahe, aur ise har jagah mānanā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Kaṭāī ke waqt apnī fasal pūre taur par na kāṭnā balki khet ke kināroṅ par kuchh chhoṛ denā. Is tarah jo kuchh kaṭāī karte waqt khet meṅ bach jāe use chhoṛnā. Bachā huā anāj ġharīboṅ aur pardesiyoṅ ke lie chhoṛ denā. Maiṅ Rab tumhārā Ḳhudā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Isrāīliyoṅ ko batānā ki sātweṅ mahīne kā pahlā din ārām kā din hai. Us din muqaddas ijtimā ho jis par yād dilāne ke lie narsingā phūṅkā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Koī bhī kām na karnā. Rab ko jalne wālī qurbānī pesh karnā.” ");
INSERT INTO urdgvr_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Sātweṅ mahīne kā daswāṅ din Kaffārā kā din hai. Us din muqaddas ijtimā ho. Apnī jān ko dukh denā aur Rab ko jalne wālī qurbānī pesh karnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Us din kām na karnā, kyoṅki yih Kaffārā kā din hai, jab Rab tumhāre Ḳhudā ke sāmne tumhārā kaffārā diyā jātā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Jo us din apnī jān ko dukh nahīṅ detā use us kī qaum meṅ se miṭāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Jo us din kām kartā hai use maiṅ us kī qaum meṅ se nikāl kar halāk karūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Koī bhī kām na karnā. Yih usūl abad tak qāym rahe, aur ise har jagah mānanā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Yih din ārām kā ḳhās din hai jis meṅ tumheṅ apnī jān ko dukh denā hai. Ise mahīne ke naweṅ din kī shām se le kar aglī shām tak manānā.” ");
INSERT INTO urdgvr_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Isrāīliyoṅ ko batānā ki sātweṅ mahīne ke pandrahweṅ din Jhoṅpṛiyoṅ kī Īd shurū hotī hai. Is kā daurāniyā sāt din hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Pahle din muqaddas ijtimā ho. Is din koī kām na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","In sāt dinoṅ ke daurān Rab ko jalne wālī qurbāniyāṅ pesh karnā. Āṭhweṅ din muqaddas ijtimā ho. Rab ko jalne wālī qurbānī pesh karo. Is ḳhās ijtimā ke din bhī kām nahīṅ karnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Yih Rab kī īdeṅ haiṅ jin par tumheṅ muqaddas ijtimā karnā hai tāki Rab ko rozmarrā kī matlūbā jalne wālī qurbāniyāṅ aur mai kī nazareṅ pesh kī jāeṅ yānī bhasm hone wālī qurbāniyāṅ, ġhallā kī nazareṅ, zabah kī qurbāniyāṅ aur mai kī nazareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Yih qurbāniyāṅ un qurbāniyoṅ ke alāwā haiṅ jo Sabat ke din chaṛhāī jātī haiṅ aur jo tum ne hadiye ke taur par yā mannat mān kar yā apnī dilī ḳhushī se pesh kī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Chunāṅche sātweṅ mahīne ke pandrahweṅ din fasal kī kaṭāī ke iḳhtitām par Rab kī yih īd yānī Jhoṅpṛiyoṅ kī Īd manāo. Ise sāt din manānā. Pahlā aur āḳhirī din ārām ke din haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Pahle din apne lie daraḳhtoṅ ke behtarīn phal, khajūr kī ḍāliyāṅ aur ghane daraḳhtoṅ aur safedā kī shāḳheṅ toṛnā. Sāt din tak Rab apne Ḳhudā ke sāmne ḳhushī manāo. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Har sāl sātweṅ mahīne meṅ Rab kī ḳhushī meṅ yih īd manānā. Yih usūl abad tak qāym rahe. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Īd ke hafte ke daurān jhoṅpṛiyoṅ meṅ rahnā. Tamām mulk meṅ ābād Isrāīlī aisā kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Phir tumhārī aulād jānegī ki Isrāīliyoṅ ko Misr se nikālte waqt maiṅ ne unheṅ jhoṅpṛiyoṅ meṅ basāyā. Maiṅ Rab tumhārā Ḳhudā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Mūsā ne Isrāīliyoṅ ko Rab kī īdoṅ ke bāre meṅ yih bāteṅ batāīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Isrāīliyoṅ ko hukm de ki wuh tere pās kūṭe hue zaitūnoṅ kā ḳhālis tel le āeṅ tāki Muqaddas Kamre ke shamādān ke charāġh mutawātir jalte raheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Hārūn unheṅ musalsal, shām se le kar subah tak Rab ke huzūr saṅbhāle yānī wahāṅ jahāṅ wuh Muqaddastarīn Kamre ke parde ke sāmne paṛe haiṅ, us parde ke sāmne jis ke pīchhe ahd kā sandūq hai. Yih usūl abad tak qāym rahe. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Wuh ḳhālis sone ke shamādān par lage charāġhoṅ kī dekh-bhāl yoṅ kare ki yih hameshā Rab ke sāmne jalte raheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Bārah roṭiyāṅ pakānā. Har roṭī ke lie 3 kilogrām behtarīn maidā istemāl kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Unheṅ do qatāroṅ meṅ Rab ke sāmne ḳhālis sone kī mez par rakhnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Har qatār par ḳhālis lubān ḍālnā. Yih lubān roṭī ke lie yādgārī kī qurbānī hai jise bād meṅ Rab ke lie jalānā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Har hafte ko Rab ke sāmne tāzā roṭiyāṅ isī tartīb se mez par rakhnī haiṅ. Yih Isrāīliyoṅ ke lie abadī ahd kī lāzimī shart hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Mez kī roṭiyāṅ Hārūn aur us ke beṭoṅ kā hissā haiṅ, aur wuh unheṅ muqaddas jagah par khāeṅ, kyoṅki wuh jalne wālī qurbāniyoṅ kā muqaddastarīn hissā haiṅ. Yih abad tak un kā haq rahegā.” ");
INSERT INTO urdgvr_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Ḳhaimāgāh meṅ ek ādmī thā jis kā bāp Misrī aur māṅ Isrāīlī thī. Māṅ kā nām Salūmīt thā. Wuh dibrī kī beṭī aur Dān ke qabīle kī thī. Ek din yih ādmī ḳhaimāgāh meṅ kisī Isrāīlī se jhagaṛne lagā. Laṛte laṛte us ne Rab ke nām par kufr bak kar us par lānat bhejī. Yih sun kar log use Mūsā ke pās le āe. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Wahāṅ unhoṅ ne use pahre meṅ biṭhā kar Rab kī hidāyat kā intazār kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Tab Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Lānat karne wāle ko ḳhaimāgāh ke bāhar le jāo. Jinhoṅ ne us kī yih bāteṅ sunī haiṅ wuh sab apne hāth us ke sar par rakheṅ. Phir pūrī jamāt use sangsār kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Isrāīliyoṅ se kahnā ki jo bhī apne Ḳhudā par lānat bheje use apne qusūr ke natīje bardāsht karne paṛeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Jo bhī Rab ke nām par kufr bake use sazā-e-maut dī jāe. Pūrī jamāt use sangsār kare. Jis ne Rab ke nām par kufr bakā ho use zarūr sazā-e-maut denī hai, ḳhāh desī ho yā pardesī. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Jis ne kisī ko mār ḍālā hai use sazā-e-maut dī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Jis ne kisī ke jānwar ko mār ḍālā hai wuh us kā muāwazā de. Jān ke badle jān dī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Agar kisī ne kisī ko zaḳhmī kar diyā hai to wuhī kuchh us ke sāth kiyā jāe jo us ne dūsre ke sāth kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Agar dūsre kī koī haḍḍī ṭūṭ jāe to us kī wuhī haḍḍī toṛī jāe. Agar dūsre kī āṅkh zāe ho jāe to us kī āṅkh zāe kar dī jāe. Agar dūsre kā dāṅt ṭūṭ jāe to us kā wuhī dāṅt toṛā jāe. Jo bhī zaḳhm us ne dūsre ko pahuṅchāyā wuhī zaḳhm use pahuṅchāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Jis ne kisī jānwar ko mār ḍālā hai wuh us kā muāwazā de, lekin jis ne kisī insān ko mār diyā hai use sazā-e-maut denī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Desī aur pardesī ke lie tumhārā ek hī qānūn ho. Maiṅ Rab tumhārā Ḳhudā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Phir Mūsā ne Isrāīliyoṅ se bāt kī, aur unhoṅ ne Rab par lānat bhejne wāle ko ḳhaimāgāh se bāhar le jā kar use sangsār kiyā. Unhoṅ ne waisā hī kiyā jaisā Rab ne Mūsā ko hukm diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Rab ne Sīnā Pahāṛ par Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Isrāīliyoṅ ko batānā ki jab tum us mulk meṅ dāḳhil hoge jo maiṅ tumheṅ dūṅgā to lāzim hai ki Rab kī tāzīm meṅ zamīn ek sāl ārām kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Chhih sāl ke daurān apne khetoṅ meṅ bīj bonā, apne angūr ke bāġhoṅ kī kāṅṭ-chhāṅṭ karnā aur un kī fasleṅ jamā karnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Lekin sātwāṅ sāl zamīn ke lie ārām kā sāl hai, Rab kī tāzīm meṅ Sabat kā sāl. Us sāl na apne khetoṅ meṅ bīj bonā, na apne angūr ke bāġhoṅ kī kāṅṭ-chhāṅṭ karnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Jo anāj ḳhud baḳhud ugtā hai us kī kaṭāī na karnā aur jo angūr us sāl lagte haiṅ un ko toṛ kar jamā na karnā, kyoṅki zamīn ko ek sāl ke lie ārām karnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Albattā jo bhī yih zamīn ārām ke sāl meṅ paidā karegī us se tum apnī rozānā kī zarūriyāt pūrī kar sakte ho yānī tū, tere ġhulām aur launḍiyāṅ, tere mazdūr, tere ġhairshahrī, tere sāth rahne wāle pardesī, ");
INSERT INTO urdgvr_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","tere maweshī aur terī zamīn par rahne wāle janglī jānwar. Jo kuchh bhī yih zamīn paidā kartī hai wuh khāyā jā saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Sāt Sabat ke sāl yānī 49 sāl ke bād ek aur kām karnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Pachāsweṅ sāl ke sātweṅ mahīne ke dasweṅ din yānī Kaffārā ke din apne mulk kī har jagah narsingā bajānā. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Pachāswāṅ sāl maḳhsūs-o-muqaddas karo aur pūre mulk meṅ elān karo ki tamām bāshindoṅ ko āzād kar diyā jāe. Yih bahālī kā sāl ho jis meṅ har shaḳhs ko us kī milkiyat wāpas kī jāe aur har ġhulām ko āzād kiyā jāe tāki wuh apne rishtedāroṅ ke pās wāpas jā sake. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Yih pachāswāṅ sāl bahālī kā sāl ho, is lie na apne khetoṅ meṅ bīj bonā, na ḳhud baḳhud ugne wāle anāj kī kaṭāī karnā, aur na angūr toṛ kar jamā karnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Kyoṅki yih bahālī kā sāl hai jo tumhāre lie maḳhsūs-o-muqaddas hai. Rozānā utnī hī paidāwār lenā ki ek din kī zarūriyāt pūrī ho jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Bahālī ke sāl meṅ har shaḳhs ko us kī milkiyat wāpas kī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Chunāṅche jab kabhī tum apne kisī hamwatan bhāī ko zamīn bechte yā us se ḳharīdte ho to us se nājāyz fāydā na uṭhānā. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Zamīn kī qīmat is hisāb se muqarrar kī jāe ki wuh agle bahālī ke sāl tak kitne sāl fasleṅ paidā karegī. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Agar bahut sāl rah gae hoṅ to us kī qīmat zyādā hogī, aur agar kam sāl rah gae hoṅ to us kī qīmat kam hogī. Kyoṅki un fasloṅ kī tādād bik rahī hai jo zamīn agle bahālī ke sāl tak paidā kar saktī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Apne hamwatan se nājāyz fāydā na uṭhānā balki Rab apne Ḳhudā kā ḳhauf mānanā, kyoṅki maiṅ Rab tumhārā Ḳhudā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Merī hidāyāt par amal karnā aur mere ahkām ko mān kar un ke mutābiq chalnā. Tab tum apne mulk meṅ mahfūz rahoge. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Zamīn apnī pūrī paidāwār degī, tum ser ho jāoge aur mahfūz rahoge. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ho saktā hai koī pūchhe, ‘Ham sātweṅ sāl meṅ kyā khāeṅge jabki ham bīj nahīṅ boeṅge aur fasal nahīṅ kāṭeṅge?’ ");
INSERT INTO urdgvr_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Jawāb yih hai ki maiṅ chhaṭe sāl meṅ zamīn ko itnī barkat dūṅgā ki us sāl kī paidāwār tīn sāl ke lie kāfī hogī. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Jab tum āṭhweṅ sāl bīj bo'oge to tumhāre pās chhaṭe sāl kī itnī paidāwār bāqī hogī ki tum fasal kī kaṭāī tak guzārā kar sakoge. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Koī zamīn bhī hameshā ke lie na bechī jāe, kyoṅki mulk kī tamām zamīn merī hī hai. Tum mere huzūr sirf pardesī aur ġhairshahrī ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Mulk meṅ jahāṅ bhī zamīn bik jāe wahāṅ maurūsī mālik kā yih haq mānā jāe ki wuh apnī zamīn wāpas ḳharīd saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Agar terā koī hamwatan bhāī ġharīb ho kar apnī kuchh zamīn bechne par majbūr ho jāe to lāzim hai ki us kā sab se qarībī rishtedār use wāpas ḳharīd le. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ho saktā hai ki aise shaḳhs kā koī qarībī rishtedār na ho jo us kī zamīn wāpas ḳharīd sake, lekin wuh ḳhud kuchh der ke bād itne paise jamā kartā hai ki wuh apnī zamīn wāpas ḳharīd saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Is sūrat meṅ wuh hisāb kare ki ḳharīdne wāle ke lie agle bahālī ke sāl tak kitne sāl rah gae haiṅ. Jitnā nuqsān ḳharīdne wāle ko zamīn ko bahālī ke sāl se pahle wāpas dene se pahuṅchegā utne hī paise use dene haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Lekin agar us ke pās itne paise na hoṅ to zamīn agle bahālī ke sāl tak ḳharīdne wāle ke hāth meṅ rahegī. Phir use maurūsī mālik ko wāpas diyā jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Agar kisī kā ghar fasīldār shahr meṅ hai to jab wuh use bechegā to apnā ghar wāpas ḳharīdne kā haq sirf ek sāl tak rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Agar pahlā mālik use pahle sāl ke andar andar na ḳharīde to wuh hameshā ke lie ḳharīdne wāle kī maurūsī milkiyat ban jāegā. Wuh bahālī ke sāl meṅ bhī wāpas nahīṅ kiyā jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Lekin jo ghar aisī ābādī meṅ hai jis kī fasīl na ho wuh dehāt meṅ shumār kiyā jātā hai. Us ke maurūsī mālik ko haq hāsil hai ki har waqt apnā ghar wāpas ḳharīd sake. Bahālī ke sāl meṅ is ghar ko lāziman wāpas kar denā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Lekin Lāwiyoṅ ko yih haq hāsil hai ki wuh apne wuh ghar har waqt ḳharīd sakte haiṅ jo un ke lie muqarrar kie hue shahroṅ meṅ haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Agar aisā ghar kisī Lāwī ke hāth faroḳht kiyā jāe aur wāpas na ḳharīdā jāe to use lāziman bahālī ke sāl meṅ wāpas karnā hai. Kyoṅki Lāwī ke jo ghar un ke muqarrarā shahroṅ meṅ hote haiṅ wuh Isrāīliyoṅ meṅ un kī maurūsī milkiyat haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Lekin jo zamīneṅ shahroṅ ke irdgird maweshī charāne ke lie muqarrar haiṅ unheṅ bechne kī ijāzat nahīṅ hai. Wuh un kī dāymī milkiyat haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Agar terā koī hamwatan bhāī ġharīb ho jāe aur guzārā na kar sake to us kī madad kar. Us tarah us kī madad karnā jis tarah pardesī yā ġhairshahrī kī madad karnī hotī hai tāki wuh tere sāth rahte hue zindagī guzār sake. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Us se kisī tarah kā sūd na lenā balki apne Ḳhudā kā ḳhauf mānanā tāki terā bhāī tere sāth zindagī guzār sake. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Agar wuh terā qarzdār ho to us se sūd na lenā. Isī tarah ḳhurāk bechte waqt us se nafā na lenā. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Maiṅ Rab tumhārā Ḳhudā hūṅ. Maiṅ tumheṅ is lie Misr se nikāl lāyā ki tumheṅ Mulk-e-Kanān dūṅ aur tumhārā Ḳhudā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Agar terā koī Isrāīlī bhāī ġharīb ho kar apne āp ko tere hāth bech ḍāle to us se ġhulām kā-sā kām na karānā. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Us ke sāth mazdūr yā ġhairshahrī kā-sā sulūk karnā. Wuh tere lie bahālī ke sāl tak kām kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Phir wuh aur us ke bāl-bachche āzād ho kar apne rishtedāroṅ aur maurūsī zamīn ke pās wāpas jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Chūṅki Isrāīlī mere ḳhādim haiṅ jinheṅ maiṅ Misr se nikāl lāyā is lie unheṅ ġhulāmī meṅ na bechā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Aise logoṅ par saḳhtī se hukmrānī na karnā balki apne Ḳhudā kā ḳhauf mānanā. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Tum paṛosī mamālik se apne lie ġhulām aur launḍiyāṅ hāsil kar sakte ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Jo pardesī ġhairshahrī ke taur par tumhāre mulk meṅ ābād haiṅ unheṅ bhī tum ḳharīd sakte ho. Un meṅ wuh bhī shāmil haiṅ jo tumhāre mulk meṅ paidā hue haiṅ. Wuhī tumhārī milkiyat ban kar ");
INSERT INTO urdgvr_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","tumhāre beṭoṅ kī mīrās meṅ ā jāeṅ aur wuhī hameshā tumhāre ġhulām raheṅ. Lekin apne hamwatan bhāiyoṅ par saḳht hukmrānī na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Agar tere mulk meṅ rahne wālā koī pardesī yā ġhairshahrī amīr ho jāe jabki terā koī hamwatan bhāī ġharīb ho kar apne āp ko us pardesī yā ġhairshahrī yā us ke ḳhāndān ke kisī fard ko bech ḍāle ");
INSERT INTO urdgvr_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","to bik jāne ke bād use āzādī ḳharīdne kā haq hāsil hai. Koī bhāī, ");
INSERT INTO urdgvr_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","chachā, tāyā, chachā yā tāyā kā beṭā yā koī aur qarībī rishtedār use wāpas ḳharīd saktā hai. Wuh ḳhud bhī apnī āzādī ḳharīd saktā hai agar us ke pās paise kāfī hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Is sūrat meṅ wuh apne mālik se mil kar wuh sāl gine jo us ke ḳharīdne se le kar agle bahālī ke sāl tak bāqī haiṅ. Us kī āzādī ke paise us qīmat par mabnī hoṅ jo mazdūr ko itne sāloṅ ke lie die jāte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","52","Jitne sāl bāqī rah gae haiṅ un ke mutābiq us kī bik jāne kī qīmat meṅ se paise wāpas kar die jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Us ke sāth sāl basāl mazdūr kā-sā sulūk kiyā jāe. Us kā mālik us par saḳht hukmrānī na kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Agar wuh is tarah ke kisī tarīqe se āzād na ho jāe to use aur us ke bachchoṅ ko har hālat meṅ agle bahālī ke sāl meṅ āzād kar denā hai, ");
INSERT INTO urdgvr_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","kyoṅki Isrāīlī mere hī ḳhādim haiṅ. Wuh mere hī ḳhādim haiṅ jinheṅ maiṅ Misr se nikāl lāyā. Maiṅ Rab tumhārā Ḳhudā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Apne lie but na banānā. Na apne lie dewatā ke mujassame yā patthar ke maḳhsūs kie hue satūn khaṛe karnā, na sijdā karne ke lie apne mulk meṅ aise patthar rakhnā jin meṅ dewatā kī taswīr kandā kī gaī ho. Maiṅ Rab tumhārā Ḳhudā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Sabat kā din manānā aur mere maqdis kī tāzīm karnā. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Agar tum merī hidāyāt par chalo aur mere ahkām mān kar un par amal karo ");
INSERT INTO urdgvr_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","to maiṅ waqt par bārish bhejūṅgā, zamīn apnī paidāwār degī aur daraḳht apne apne phal lāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Kasrat ke bāis anāj kī fasal kī kaṭāī angūr toṛte waqt tak jārī rahegī aur angūr kī fasal us waqt tak toṛī jāegī jab tak bīj bone kā mausam āegā. Itnī ḳhurāk milegī ki tum kabhī bhūke nahīṅ hoge. Aur tum apne mulk meṅ mahfūz rahoge. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Maiṅ mulk ko amn-o-amān baḳhshūṅgā. Tum ārām se leṭ jāoge, kyoṅki kisī ḳhatre se ḍarne kī zarūrat nahīṅ hogī. Maiṅ wahshī jānwar mulk se dūr kar dūṅgā, aur wuh talwār kī qatl-o-ġhārat se bachā rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Tum apne dushmanoṅ par ġhālib ā kar un kā tāqqub karoge, aur wuh tumhārī talwār se māre jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Tumhāre pāṅch ādmī sau dushmanoṅ kā pīchhā kareṅge, aur tumhāre sau ādmī un ke das hazār ādmiyoṅ ko bhagā deṅge. Tumhāre dushman tumhārī talwār se māre jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Merī nazar-e-karm tum par hogī. Maiṅ tumhārī aulād kī tādād baṛhāūṅgā aur tumhāre sāth apnā ahd qāym rakhūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Ek sāl itnī fasal hogī ki jab aglī fasal kī kaṭāī hogī to nae anāj ke lie jagah banāne kī ḳhātir purāne anāj ko phaiṅk denā paṛegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Maiṅ tumhāre darmiyān apnā maskan qāym karūṅga aur tum se ghin nahīṅ khāūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Maiṅ tum meṅ phirūṅga, aur tum merī qaum hoge. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Maiṅ Rab tumhārā Ḳhudā hūṅ jo tumheṅ Misr se nikāl lāyā tāki tumhārī ġhulāmī kī hālat ḳhatm ho jāe. Maiṅ ne tumhāre jue ko toṛ ḍālā, aur ab tum āzād aur sīdhe ho kar chal sakte ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Lekin agar tum merī nahīṅ sunoge aur in tamām ahkām par nahīṅ chaloge, ");
INSERT INTO urdgvr_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","agar tum merī hidāyāt ko radd karke mere ahkām se ghin khāoge aur un par amal na karke merā ahd toṛoge ");
INSERT INTO urdgvr_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","to maiṅ jawāb meṅ tum par achānak dahshat tārī kar dūṅgā. Jism ko ḳhatm karne wālī bīmāriyoṅ aur buḳhār se tumhārī āṅkheṅ zāe ho jāeṅgī aur tumhārī jān chhin jāegī. Jab tum bīj bo'oge to befāydā, kyoṅki dushman us kī fasal khā jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Maiṅ tumhāre ḳhilāf ho jāūṅgā, is lie tum apne dushmanoṅ ke hāth se shikast khāoge. Tum se nafrat rakhne wāle tum par hukūmat kareṅge. Us waqt bhī jab koī tumhārā tāqqub nahīṅ karegā tum bhāg jāoge. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Agar tum is ke bād bhī merī na suno to maiṅ tumhāre gunāhoṅ ke sabab se tumheṅ sāt gunā zyādā sazā dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Maiṅ tumhārā saḳht ġhurūr ḳhāk meṅ milā dūṅgā. Tumhāre ūpar āsmān lohe jaisā aur tumhāre nīche zamīn pītal jaisī hogī. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Jitnī bhī mehnat karoge wuh befāydā hogī, kyoṅki tumhāre khetoṅ meṅ fasleṅ nahīṅ pakeṅgī aur tumhāre daraḳht phal nahīṅ lāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Agar tum phir bhī merī muḳhālafat karoge aur merī nahīṅ sunoge to maiṅ in gunāhoṅ ke jawāb meṅ tumheṅ is se bhī sāt gunā zyādā sazā dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Maiṅ tumhāre ḳhilāf janglī jānwar bhej dūṅgā jo tumhāre bachchoṅ ko phāṛ khāeṅge aur tumhāre maweshī barbād kar deṅge. Āḳhir meṅ tumhārī tādād itnī kam ho jāegī ki tumhārī saṛakeṅ wīrān ho jāeṅgī. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Agar tum phir bhī merī tarbiyat qabūl na karo balki mere muḳhālif raho ");
INSERT INTO urdgvr_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","to maiṅ ḳhud tumhāre ḳhilāf ho jāūṅgā. In gunāhoṅ ke jawāb meṅ maiṅ tumheṅ sāt gunā zyādā sazā dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Maiṅ tum par talwār chalā kar is kā badlā lūṅgā ki tum ne mere ahd ko toṛā hai. Jab tum apnī hifāzat ke lie shahroṅ meṅ bhāg kar jamā hoge to maiṅ tumhāre darmiyān wabāī bīmāriyāṅ phailāūṅgā aur tumheṅ dushmanoṅ ke hāth meṅ de dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Anāj kī itnī kamī hogī ki das aurateṅ tumhārī pūrī roṭī ek hī tanūr meṅ pakā sakeṅgī, aur wuh use baṛī ehtiyāt se tol tol kar taqsīm kareṅgī. Tum khā kar bhī bhūke rahoge. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Agar tum phir bhī merī nahīṅ sunoge balki mere muḳhālif rahoge ");
INSERT INTO urdgvr_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","to merā ġhussā bhaṛkegā aur maiṅ tumhāre ḳhilāf ho kar tumhāre gunāhoṅ ke jawāb meṅ tumheṅ sāt gunā zyādā sazā dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Tum musībat ke bāis apne beṭe-beṭiyoṅ kā gosht khāoge. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Maiṅ tumhārī ūṅchī jaghoṅ kī qurbāngāheṅ aur tumhārī baḳhūr kī qurbāngāheṅ barbād kar dūṅgā. Maiṅ tumhārī lāshoṅ ke ḍher tumhāre bejān butoṅ par lagāūṅgā aur tum se ghin khāūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Maiṅ tumhāre shahroṅ ko khanḍarāt meṅ badal kar tumhāre mandiroṅ ko barbād karūṅga. Tumhārī qurbāniyoṅ kī ḳhushbū mujhe pasand nahīṅ āegī. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Maiṅ tumhāre mulk kā satyānās yoṅ karūṅga ki jo dushman us meṅ ābād ho jāeṅge un ke roṅgṭe khaṛe ho jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Maiṅ tumheṅ muḳhtalif mamālik meṅ muntashir kar dūṅgā, lekin wahāṅ bhī apnī talwār ko hāth meṅ lie tumhārā pīchhā karūṅga. Tumhārī zamīn wīrān hogī aur tumhāre shahr khanḍarāt ban jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Us waqt jab tum apne dushmanoṅ ke mulk meṅ rahoge tumhārī zamīn wīrān hālat meṅ ārām ke wuh sāl manā sakegī jin se wuh mahrūm rahī hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Un tamām dinoṅ meṅ jab wuh barbād rahegī use wuh ārām milegā jo use na milā jab tum mulk meṅ rahte the. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Tum meṅ se jo bach kar apne dushmanoṅ ke mamālik meṅ raheṅge un ke diloṅ par maiṅ dahshat tārī karūṅga. Wuh hawā ke jhoṅkoṅ se girne wāle patte kī āwāz se chaunk kar bhāg jāeṅge. Wuh farār hoṅge goyā koī hāth meṅ talwār lie un kā tāqqub kar rahā ho. Aur wuh gir kar mar jāeṅge hālāṅki koī un kā pīchhā nahīṅ kar rahā hogā. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Wuh ek dūsre se ṭakrā kar laṛkhaṛāeṅge goyā koī talwār le kar un ke pīchhe chal rahā ho hālāṅki koī nahīṅ hai. Chunāṅche tum apne dushmanoṅ kā sāmnā nahīṅ kar sakoge. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Tum dīgar qaumoṅ meṅ muntashir ho kar halāk ho jāoge, aur tumhāre dushmanoṅ kī zamīn tumheṅ haṛap kar legī. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Tum meṅ se bāqī log apne aur apne bāpdādā ke qusūr ke bāis apne dushmanoṅ ke mamālik meṅ gal saṛ jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Lekin ek waqt āegā ki wuh apne aur apne bāpdādā kā qusūr mān leṅge. Wuh mere sāth apnī bewafāī aur wuh muḳhālafat taslīm kareṅge ");
INSERT INTO urdgvr_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","jis ke sabab se maiṅ un ke ḳhilāf huā aur unheṅ un ke dushmanoṅ ke mulk meṅ dhakel diyā thā. Pahle un kā ḳhatnā sirf zāhirī taur par huā thā, lekin ab un kā dil ājiz ho jāegā aur wuh apne qusūr kī qīmat adā kareṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Phir maiṅ Ibrāhīm ke sāth apnā ahd, Is'hāq ke sāth apnā ahd aur Yāqūb ke sāth apnā ahd yād karūṅga. Maiṅ Mulk-e-Kanān bhī yād karūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Lekin pahle wuh zamīn ko chhoṛeṅge tāki wuh un kī ġhairmaujūdagī meṅ wīrān ho kar ārām ke sāl manāe. Yoṅ Isrāīlī apne qusūr ke natīje bhugteṅge, is sabab se ki unhoṅ ne mere ahkām radd kie aur merī hidāyāt se ghin khāī. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Is ke bāwujūd bhī maiṅ unheṅ dushmanoṅ ke mulk meṅ chhoṛ kar radd nahīṅ karūṅga, na yahāṅ tak un se ghin khāūṅgā ki wuh bilkul tabāh ho jāeṅ. Kyoṅki maiṅ un ke sāth apnā ahd nahīṅ toṛne kā. Maiṅ Rab un kā Ḳhudā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Maiṅ un kī ḳhātir un ke bāpdādā ke sāth bandhā huā ahd yād karūṅga, un logoṅ ke sāth ahd jinheṅ maiṅ dūsrī qaumoṅ ke deḳhte deḳhte Misr se nikāl lāyā tāki un kā Ḳhudā hūṅ. Maiṅ Rab hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Rab ne Mūsā ko Isrāīliyoṅ ke lie yih tamām hidāyāt aur ahkām Sīnā Pahāṛ par die. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Isrāīliyoṅ ko batānā ki agar kisī ne mannat mān kar kisī ko Rab ke lie maḳhsūs kiyā ho to wuh use zail kī raqam de kar āzād kar saktā hai (mustāmal sikke maqdis ke sikkoṅ ke barābar hoṅ): ");
INSERT INTO urdgvr_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","us ādmī ke lie jis kī umr 20 aur 60 sāl ke darmiyān hai chāṅdī ke 50 sikke, ");
INSERT INTO urdgvr_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","isī umr kī aurat ke lie chāṅdī ke 30 sikke, ");
INSERT INTO urdgvr_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","us laṛke ke lie jis kī umr 5 aur 20 sāl ke darmiyān ho chāṅdī ke 20 sikke, isī umr kī laṛkī ke lie chāṅdī ke 10 sikke, ");
INSERT INTO urdgvr_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ek māh se le kar 5 sāl tak ke laṛke ke lie chāṅdī ke 5 sikke, isī umr kī laṛkī ke lie chāṅdī ke 3 sikke, ");
INSERT INTO urdgvr_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","sāṭh sāl se baṛe ādmī ke lie chāṅdī ke 15 sikke aur isī umr kī aurat ke lie chāṅdī ke 10 sikke. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Agar mannat mānane wālā muqarrarā raqam adā na kar sake to wuh maḳhsūs kie hue shaḳhs ko imām ke pās le āe. Phir imām aisī raqam muqarrar kare jo mannat mānane wālā adā kar sake. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Agar kisī ne mannat mān kar aisā jānwar maḳhsūs kiyā jo Rab kī qurbāniyoṅ ke lie istemāl ho saktā hai to aisā jānwar maḳhsūs-o-muqaddas ho jātā hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Wuh use badal nahīṅ saktā. Na wuh achchhe jānwar kī jagah nāqis, na nāqis jānwar kī jagah achchhā jānwar de. Agar wuh ek jānwar dūsre kī jagah de to donoṅ maḳhsūs-o-muqaddas ho jāte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Agar kisī ne mannat mān kar koī nāpāk jānwar maḳhsūs kiyā jo Rab kī qurbāniyoṅ ke lie istemāl nahīṅ ho saktā to wuh us ko imām ke pās le āe. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Imām us kī raqam us kī achchhī aur burī siftoṅ kā lihāz karke muqarrar kare. Is muqarrarā qīmat meṅ kamī beshī nahīṅ ho saktī. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Agar mannat mānane wālā use wāpas ḳharīdnā chāhe to wuh muqarrarā qīmat jamā 20 fīsad adā kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Agar koī apnā ghar Rab ke lie maḳhsūs-o-muqaddas kare to imām us kī achchhī aur burī siftoṅ kā lihāz karke us kī raqam muqarrar kare. Is muqarrarā qīmat meṅ kamī beshī nahīṅ ho saktī. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Agar ghar ko maḳhsūs karne wālā use wāpas ḳharīdnā chāhe to wuh muqarrarā raqam jamā 20 fīsad adā kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Agar koī apnī maurūsī zamīn meṅ se kuchh Rab ke lie maḳhsūs-o-muqaddas kare to us kī qīmat us bīj kī miqdār ke mutābiq muqarrar kī jāe jo us meṅ bonā hotā hai. Jis khet meṅ 135 kilogrām jau kā bīj boyā jāe us kī qīmat chāṅdī ke 50 sikke hogī. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Shart yih hai ki wuh apnī zamīn bahālī ke sāl ke ain bād maḳhsūs kare. Phir us kī yihī qīmat muqarrar kī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Agar zamīn kā mālik use bahālī ke sāl ke kuchh der bād maḳhsūs kare to imām agle bahālī ke sāl tak rahne wāle sāloṅ ke mutābiq zamīn kī qīmat muqarrar kare. Jitne kam sāl bāqī haiṅ utnī kam us kī qīmat hogī. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Agar maḳhsūs karne wālā apnī zamīn wāpas ḳharīdnā chāhe to wuh muqarrarā qīmat jamā 20 fīsad adā kare. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Agar maḳhsūs karne wālā apnī zamīn ko Rab se wāpas ḳharīde baġhair use kisī aur ko beche to use wāpas ḳharīdne kā haq ḳhatm ho jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Agle bahālī ke sāl yih zamīn maḳhsūs-o-muqaddas rahegī aur Rab kī dāymī milkiyat ho jāegī. Chunāṅche wuh imām kī milkiyat hogī. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Agar koī apnā maurūsī khet nahīṅ balki apnā ḳharīdā huā khet Rab ke lie maḳhsūs kare ");
INSERT INTO urdgvr_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","to imām agle bahālī ke sāl tak rahne wāle sāloṅ kā lihāz karke us kī qīmat muqarrar kare. Khet kā mālik usī din us ke paise adā kare. Yih paise Rab ke lie maḳhsūs-o-muqaddas hoṅge. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Bahālī ke sāl meṅ yih khet us shaḳhs ke pās wāpas āegā jis ne use bechā thā. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Wāpas ḳharīdne ke lie mustāmal sikke maqdis ke sikkoṅ ke barābar hoṅ. Us ke chāṅdī ke sikkoṅ kā wazn 11 grām hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Lekin koī bhī kisī maweshī kā pahlauṭhā Rab ke lie maḳhsūs nahīṅ kar saktā. Wuh to pahle se Rab ke lie maḳhsūs hai. Is meṅ koī farq nahīṅ ki wuh gāy, bail yā bheṛ ho. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Agar us ne koī nāpāk jānwar maḳhsūs kiyā ho to wuh use muqarrarā qīmat jamā 20 fīsad ke lie wāpas ḳharīd saktā hai. Agar wuh use wāpas na ḳharīde to wuh muqarrarā qīmat ke lie bechā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Lekin agar kisī ne apnī milkiyat meṅ se kuchh ġhairmashrūt taur par Rab ke lie maḳhsūs kiyā hai to use bechā yā wāpas nahīṅ ḳharīdā jā saktā, ḳhāh wuh insān, jānwar yā zamīn ho. Jo is tarah maḳhsūs kiyā gayā ho wuh Rab ke lie nihāyat muqaddas hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Isī tarah jis shaḳhs ko tabāhī ke lie maḳhsūs kiyā gayā hai us kā fidyā nahīṅ diyā jā saktā. Lāzim hai ki use sazā-e-maut dī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Har fasal kā daswāṅ hissā Rab kā hai, chāhe wuh anāj ho yā phal. Wuh Rab ke lie maḳhsūs-o-muqaddas hai. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Agar koī apnī fasal kā daswāṅ hissā chhuṛānā chāhtā hai to wuh is ke lie us kī muqarrarā qīmat jamā 20 fīsad de. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Isī tarah gāy-bailoṅ aur bheṛ-bakriyoṅ kā daswāṅ hissā bhī Rab ke lie maḳhsūs-o-muqaddas hai, har daswāṅ jānwar jo gallābān ke ḍanḍe ke nīche se guzaregā. ");
INSERT INTO urdgvr_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Yih jānwar chunane se pahle un kā muāynā na kiyā jāe ki kaun-se jānwar achchhe yā kamzor haiṅ. Yih bhī na karnā ki dasweṅ hisse ke kisī jānwar ke badle koī aur jānwar diyā jāe. Agar phir bhī use badlā jāe to donoṅ jānwar Rab ke lie maḳhsūs-o-muqaddas hoṅge. Aur unheṅ wāpas ḳharīdā nahīṅ jā saktā.” ");
INSERT INTO urdgvr_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Yih wuh ahkām haiṅ jo Rab ne Sīnā Pahāṛ par Mūsā ko Isrāīliyoṅ ke lie die. ");
INSERT INTO urdgvr_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Isrāīliyoṅ ko Misr se nikle hue ek sāl se zyādā arsā guzar gayā thā. Ab tak wuh Dasht-e-Sīnā meṅ the. Dūsre sāl ke dūsre mahīne ke pahle din Rab mulāqāt ke ḳhaime meṅ Mūsā se hamkalām huā. Us ne kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Tū aur Hārūn tamām Isrāīliyoṅ kī mardumshumārī kunboṅ aur ābāī gharānoṅ ke mutābiq karnā. Un tamām mardoṅ kī fahrist banānā ");
INSERT INTO urdgvr_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","jo kam az kam bīs sāl ke aur jang laṛne ke qābil hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Is meṅ har qabīle ke ek ḳhāndān kā sarparast tumhārī madad kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Yih un ke nām haiṅ: Rūbin ke qabīle se Ilīsūr bin Shadiyūr, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Shamāūn ke qabīle se Salūmiyel bin Sūrīshaddī, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Yahūdāh ke qabīle se Nahson bin Ammīnadāb, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Ishkār ke qabīle se Nataniyel bin Zuġhar, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zabūlūn ke qabīle se Iliyāb bin Helon, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Yūsuf ke beṭe Ifrāīm ke qabīle se Ilīsamā bin Ammīhūd, Yūsuf ke beṭe Manassī ke qabīle se Jamliyel bin Fadāhsūr, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Binyamīn ke qabīle se Abidān bin Jidāūnī, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dān ke qabīle se Aḳhiyazar bin Ammīshaddī, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Āshar ke qabīle se Fajiyel bin Akrān, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Jad ke qabīle se Iliyāsaf bin Daūel, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Naftālī ke qabīle se Aḳhīrā bin Enān.” ");
INSERT INTO urdgvr_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Yihī mard jamāt se is kām ke lie bulāe gae. Wuh apne qabīloṅ ke rāhnumā aur kunboṅ ke sarparast the. ");
INSERT INTO urdgvr_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","In kī madad se Mūsā aur Hārūn ne ");
INSERT INTO urdgvr_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","usī din pūrī jamāt ko ikaṭṭhā kiyā. Har Isrāīlī mard jo kam az kam 20 sāl kā thā rajisṭar meṅ darj kiyā gayā. Rajisṭar kī tartīb un ke kunboṅ aur ābāī gharānoṅ ke mutābiq thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Sab kuchh waisā hī kiyā gayā jaisā Rab ne hukm diyā thā. Mūsā ne Sīnā ke registān meṅ logoṅ kī mardumshumārī kī. Natījā yih niklā: ");
INSERT INTO urdgvr_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","21","Rūbin ke qabīle ke 46,500 mard, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","Shamāūn ke qabīle ke 59,300 mard, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","Jad ke qabīle ke 45,650 mard, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","Yahūdāh ke qabīle ke 74,600 mard, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","Ishkār ke qabīle ke 54,400 mard, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","Zabūlūn ke qabīle ke 57,400 mard, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","33","Yūsuf ke beṭe Ifrāīm ke qabīle ke 40,500 mard, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","35","Yūsuf ke beṭe Manassī ke qabīle ke 32,200 mard, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","Binyamīn ke qabīle ke 35,400 mard, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","Dān ke qabīle ke 62,700 mard, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","Āshar ke qabīle ke 41,500 mard, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","Naftālī ke qabīle ke 53,400 mard. ");
INSERT INTO urdgvr_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Mūsā, Hārūn aur qabīloṅ ke bārah rāhnumāoṅ ne in tamām ādmiyoṅ ko ginā. ");
INSERT INTO urdgvr_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","46","Un kī pūrī tādād 6,03,550 thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Lekin Lāwiyoṅ kī mardumshumārī na huī, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","kyoṅki Rab ne Mūsā se kahā thā, ");
INSERT INTO urdgvr_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Isrāīliyoṅ kī mardumshumārī meṅ Lāwiyoṅ ko shāmil na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Is ke bajāe unheṅ sharīat kī sukūnatgāh aur us kā sārā sāmān saṅbhālne kī zimmedārī denā. Wuh safr karte waqt yih ḳhaimā aur us kā sārā sāmān uṭhā kar le jāeṅ, us kī ḳhidmat ke lie hāzir raheṅ aur rukte waqt use apne ḳhaimoṅ se ghere rakheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Rawānā hote waqt wuhī ḳhaime ko sameṭeṅ aur rukte waqt wuhī use lagāeṅ. Agar koī aur us ke qarīb āe to use sazā-e-maut dī jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Bāqī Isrāīlī ḳhaimāgāh meṅ apne apne daste ke mutābiq aur apne apne alam ke irdgird apne ḳhaime lagāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Lekin Lāwī apne ḳhaimoṅ se sharīat kī sukūnatgāh ko gher leṅ tāki merā ġhazab kisī ġhalat shaḳhs ke nazdīk āne se Isrāīliyoṅ kī jamāt par nāzil na ho jāe. Yoṅ Lāwiyoṅ ko sharīat kī sukūnatgāh ko saṅbhālnā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Isrāīliyoṅ ne waisā hī kiyā jaisā Rab ne Mūsā ko hukm diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Rab ne Mūsā aur Hārūn se kahā ");
INSERT INTO urdgvr_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","ki Isrāīlī apne ḳhaime kuchh fāsile par mulāqāt ke ḳhaime ke irdgird lagāeṅ. Har ek apne apne alam aur apne apne ābāī gharāne ke nishān ke sāth ḳhaimāzan ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","In hidāyāt ke mutābiq maqdis ke mashriq meṅ Yahūdāh kā alam thā jis ke irdgird tīn daste ḳhaimāzan the. Pahle, Yahūdāh kā qabīlā jis kā kamānḍar Nahson bin Ammīnadāb thā, ");
INSERT INTO urdgvr_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","aur jis ke lashkar ke 74,600 faujī the. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Dūsre, Ishkār kā qabīlā jis kā kamānḍar Nataniyel bin Zuġhar thā, ");
INSERT INTO urdgvr_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","aur jis ke lashkar ke 54,400 faujī the. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Tīsre, Zabūlūn kā qabīlā jis kā kamānḍar Iliyāb bin Helon thā ");
INSERT INTO urdgvr_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","aur jis ke lashkar ke 57,400 faujī the. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Tīnoṅ qabīloṅ ke faujiyoṅ kī kul tādād 1,86,400 thī. Rawānā hote waqt yih āge chalte the. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Maqdis ke junūb meṅ Rūbin kā alam thā jis ke irdgird tīn daste ḳhaimāzan the. Pahle, Rūbin kā qabīlā jis kā kamānḍar Ilīsūr bin Shadiyūr thā, ");
INSERT INTO urdgvr_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","aur jis ke 46,500 faujī the. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Dūsre, Shamāūn kā qabīlā jis kā kamānḍar Salūmiyel bin Sūrīshaddī thā, ");
INSERT INTO urdgvr_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","aur jis ke 59,300 faujī the. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Tīsre, Jad kā qabīlā jis kā kamānḍar Iliyāsaf bin Daūel thā, ");
INSERT INTO urdgvr_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","aur jis ke 45,650 faujī the. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Tīnoṅ qabīloṅ ke faujiyoṅ kī kul tādād 1,51,450 thī. Rawānā hote waqt yih mashriqī qabīloṅ ke pīchhe chalte the. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","In junūbī qabīloṅ ke bād Lāwī mulāqāt kā ḳhaimā uṭhā kar qabīloṅ ke ain bīch meṅ chalte the. Qabīle us tartīb se rawānā hote the jis tartīb se wuh apne ḳhaime lagāte the. Har qabīlā apne alam ke pīchhe chaltā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Maqdis ke maġhrib meṅ Ifrāīm kā alam thā jis ke irdgird tīn daste ḳhaimāzan the. Pahle, Ifrāīm kā qabīlā jis kā kamānḍar Ilīsamā bin Ammīhūd thā, ");
INSERT INTO urdgvr_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","aur jis ke 40,500 faujī the. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Dūsre, Manassī kā qabīlā jis kā kamānḍar Jamliyel bin Fadāhsūr thā, ");
INSERT INTO urdgvr_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","aur jis ke 32,200 faujī the. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Tīsre, Binyamīn kā qabīlā jis kā kamānḍar Abidān bin Jidāūnī thā, ");
INSERT INTO urdgvr_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","aur jis ke 35,400 faujī the. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Tīnoṅ qabīloṅ ke faujiyoṅ kī kul tādād 1,08,100 thī. Rawānā hote waqt yih junūbī qabīloṅ ke pīchhe chalte the. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Maqdis ke shimāl meṅ Dān kā alam thā jis ke irdgird tīn daste ḳhaimāzan the. Pahle, Dān kā qabīlā jis kā kamānḍar Aḳhiyazar bin Ammīshaddī thā, ");
INSERT INTO urdgvr_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","aur jis ke 62,700 faujī the. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Dūsre, Āshar kā qabīlā jis kā kamānḍar Fajiyel bin Akrān thā, ");
INSERT INTO urdgvr_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","aur jis ke 41,500 faujī the. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Tīsre, Naftālī kā qabīlā jis kā kamānḍar Aḳhīrā bin Enān thā, ");
INSERT INTO urdgvr_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","aur jis ke 53,400 faujī the. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Tīnoṅ qabīloṅ kī kul tādād 1,57,600 thī. Wuh āḳhir meṅ apnā alam uṭhā kar rawānā hote the. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Pūrī ḳhaimāgāh ke faujiyoṅ kī kul tādād 6,03,550 thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Sirf Lāwī is tādād meṅ shāmil nahīṅ the, kyoṅki Rab ne Mūsā ko hukm diyā thā ki un kī bhartī na kī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Yoṅ Isrāīliyoṅ ne sab kuchh un hidāyāt ke mutābiq kiyā jo Rab ne Mūsā ko dī thīṅ. Un ke mutābiq hī wuh apne jhanḍoṅ ke irdgird apne ḳhaime lagāte the aur un ke mutābiq hī apne kunboṅ aur ābāī gharānoṅ ke sāth rawānā hote the. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Yih Hārūn aur Mūsā ke ḳhāndān kā bayān hai. Us waqt kā zikr hai jab Rab ne Sīnā Pahāṛ par Mūsā se bāt kī. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Hārūn ke chār beṭe the. Baṛā beṭā Nadab thā, phir Abīhū, Iliyazar aur Itamar. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Yih imām the jin ko masah karke is ḳhidmat kā iḳhtiyār diyā gayā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Lekin Nadab aur Abīhū us waqt mar gae jab unhoṅ ne Dasht-e-Sīnā meṅ Rab ke huzūr nājāyz āg pesh kī. Chūṅki wuh beaulād the is lie Hārūn ke jīte-jī sirf Iliyazar aur Itamar imām kī ḳhidmat saranjām dete the. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Lāwī ke qabīle ko lā kar Hārūn kī ḳhidmat karne kī zimmedārī de. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Unheṅ us ke lie aur pūrī jamāt ke lie mulāqāt ke ḳhaime kī ḳhidmāt saṅbhālnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Wuh mulāqāt ke ḳhaime kā sāmān saṅbhāleṅ aur tamām Isrāīliyoṅ ke lie maqdis ke farāyz adā kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Tamām Isrāīliyoṅ meṅ se sirf Lāwiyoṅ ko Hārūn aur us ke beṭoṅ kī ḳhidmat ke lie muqarrar kar. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Lekin sirf Hārūn aur us ke beṭoṅ ko imām kī haisiyat hāsil hai. Jo bhī bāqiyoṅ meṅ se un kī zimmedāriyāṅ uṭhāne kī koshish karegā use sazā-e-maut dī jāegī.” ");
INSERT INTO urdgvr_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Rab ne Mūsā se yih bhī kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Maiṅ ne Isrāīliyoṅ meṅ se Lāwiyoṅ ko chun liyā hai. Wuh tamām Isrāīlī pahlauṭhoṅ ke ewaz mere lie maḳhsūs haiṅ, ");
INSERT INTO urdgvr_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","kyoṅki tamām pahlauṭhe mere hī haiṅ. Jis din maiṅ ne Misr meṅ tamām pahlauṭhoṅ ko mār diyā us din maiṅ ne Isrāīl ke pahlauṭhoṅ ko apne lie maḳhsūs kiyā, ḳhāh wuh insān ke the yā haiwān ke. Wuh mere hī haiṅ. Maiṅ Rab hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Rab ne Sīnā ke registān meṅ Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Lāwiyoṅ ko gin kar un ke ābāī gharānoṅ aur kunboṅ ke mutābiq rajisṭar meṅ darj karnā. Har beṭe ko ginanā hai jo ek māh yā is se zāyd kā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Mūsā ne aisā hī kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Lāwī ke tīn beṭe Jairson, Qihāt aur Mirārī the. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Jairson ke do kunbe us ke beṭoṅ Libnī aur Simaī ke nām rakhte the. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Qihāt ke chār kunbe us ke beṭoṅ Amrām, Izhār, Habrūn aur Uzziyel ke nām rakhte the. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Mirārī ke do kunbe us ke beṭoṅ Mahlī aur Mūshī ke nām rakhte the. Ġharz Lāwī ke qabīle ke kunbe us ke potoṅ ke nām rakhte the. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Jairson ke do kunboṅ banām Libnī aur Simaī ");
INSERT INTO urdgvr_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ke 7,500 mard the jo ek māh yā is se zāyd ke the. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Unheṅ apne ḳhaime maġhrib meṅ maqdis ke pīchhe lagāne the. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Un kā rāhnumā Iliyāsaf bin Lāel thā, ");
INSERT INTO urdgvr_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","aur wuh ḳhaime ko saṅbhālte the yānī us kī poshisheṅ, ḳhaime ke darwāze kā pardā, ");
INSERT INTO urdgvr_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ḳhaime aur qurbāngāh kī chārdīwārī ke parde, chārdīwārī ke darwāze kā pardā aur tamām rasse. In chīzoṅ se mutālliq sārī ḳhidmat un kī zimmedārī thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Qihāt ke chār kunboṅ banām Amrām, Izhār, Habrūn aur Uzziyel ");
INSERT INTO urdgvr_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ke 8,600 mard the jo ek māh yā is se zāyd ke the aur jin ko maqdis kī ḳhidmat karnī thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Unheṅ apne ḍere maqdis ke junūb meṅ ḍālne the. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Un kā rāhnumā Ilīsafan bin Uzziyel thā, ");
INSERT INTO urdgvr_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","aur wuh yih chīzeṅ saṅbhālte the: ahd kā sandūq, mez, shamādān, qurbāngāheṅ, wuh bartan aur sāz-o-sāmān jo maqdis meṅ istemāl hotā thā aur Muqaddastarīn Kamre kā pardā. In chīzoṅ se mutālliq sārī ḳhidmat un kī zimmedārī thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Hārūn Imām kā beṭā Iliyazar Lāwiyoṅ ke tamām rāhnumāoṅ par muqarrar thā. Wuh un tamām logoṅ kā inchārj thā jo maqdis kī dekh-bhāl karte the. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Mirārī ke do kunboṅ banām Mahlī aur Mūshī ");
INSERT INTO urdgvr_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ke 6,200 mard the jo ek māh yā is se zāyd ke the. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Un kā rāhnumā Sūriyel bin Abīḳhail thā. Unheṅ apne ḍere maqdis ke shimāl meṅ ḍālne the, ");
INSERT INTO urdgvr_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","aur wuh yih chīzeṅ saṅbhālte the: ḳhaime ke taḳhte, us ke shahtīr, khambe, pāe aur is tarah kā sārā sāmān. In chīzoṅ se mutālliq sārī ḳhidmat un kī zimmedārī thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Wuh chārdīwārī ke khambe, pāe, meḳheṅ aur rasse bhī saṅbhālte the. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Mūsā, Hārūn aur un ke beṭoṅ ko apne ḍere mashriq meṅ maqdis ke sāmne ḍālne the. Un kī zimmedārī maqdis meṅ banī Isrāīl ke lie ḳhidmat karnā thī. Un ke alāwā jo bhī maqdis meṅ dāḳhil hone kī koshish kartā use sazā-e-maut denī thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Un Lāwī mardoṅ kī kul tādād jo ek māh yā is se zāyd ke the 22,000 thī. Rab ke kahne par Mūsā aur Hārūn ne unheṅ kunboṅ ke mutābiq gin kar rajisṭar meṅ darj kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Rab ne Mūsā se kahā, “Tamām Isrāīlī pahlauṭhoṅ ko ginanā jo ek māh yā is se zāyd ke haiṅ aur un ke nām rajisṭar meṅ darj karnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Un tamām pahlauṭhoṅ kī jagah Lāwiyoṅ ko mere lie maḳhsūs karnā. Isī tarah Isrāīliyoṅ ke maweshiyoṅ ke pahlauṭhoṅ kī jagah Lāwiyoṅ ke maweshī mere lie maḳhsūs karnā. Maiṅ Rab hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Mūsā ne aisā hī kiyā jaisā Rab ne use hukm diyā. Us ne tamām Isrāīlī pahlauṭhe ");
INSERT INTO urdgvr_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","jo ek māh yā is se zāyd ke the gin lie. Un kī kul tādād 22,273 thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Mujhe tamām Isrāīlī pahlauṭhoṅ kī jagah Lāwiyoṅ ko pesh karnā. Isī tarah mujhe Isrāīliyoṅ ke maweshiyoṅ kī jagah Lāwiyoṅ ke maweshī pesh karnā. Lāwī mere hī haiṅ. Maiṅ Rab hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Lāwiyoṅ kī nisbat bāqī Isrāīliyoṅ ke 273 pahlauṭhe zyādā haiṅ. Un meṅ se ");
INSERT INTO urdgvr_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","har ek ke ewaz chāṅdī ke pāṅch sikke le jo maqdis ke wazn ke mutābiq hoṅ (fī sikkā taqrīban 11 grām). ");
INSERT INTO urdgvr_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Yih paise Hārūn aur us ke beṭoṅ ko denā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Mūsā ne aisā hī kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Yoṅ us ne chāṅdī ke 1,365 sikke (taqrīban 16 kilogrām) jamā karke ");
INSERT INTO urdgvr_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Hārūn aur us ke beṭoṅ ko die, jis tarah Rab ne use hukm diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Rab ne Mūsā aur Hārūn se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Lāwī ke qabīle meṅ se Qihātiyoṅ kī mardumshumārī un ke kunboṅ aur ābāī gharānoṅ ke mutābiq karnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Un tamām mardoṅ ko rajisṭar meṅ darj karnā jo 30 se le kar 50 sāl ke haiṅ aur mulāqāt ke ḳhaime meṅ ḳhidmat karne ke lie ā sakte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Qihātiyoṅ kī ḳhidmat Muqaddastarīn Kamre kī dekh-bhāl hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Jab ḳhaime ko safr ke lie sameṭnā hai to Hārūn aur us ke beṭe dāḳhil ho kar Muqaddastarīn Kamre kā pardā utāreṅ aur use sharīat ke sandūq par ḍāl deṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Is par wuh taḳhas kī khāloṅ kā ġhilāf aur āḳhir meṅ pūrī tarah nīle rang kā kapṛā bichhāeṅ. Is ke bād wuh sandūq ko uṭhāne kī lakaṛiyāṅ lagāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Wuh us mez par bhī nīle rang kā kapṛā bichhāeṅ jis par Rab ko roṭī pesh kī jātī hai. Us par thāl, pyāle, mai kī nazareṅ pesh karne ke bartan aur martabān rakhe jāeṅ. Jo roṭī hameshā mez par hotī hai wuh bhī us par rahe. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Hārūn aur us ke beṭe in tamām chīzoṅ par qirmizī rang kā kapṛā bichhā kar āḳhir meṅ un ke ūpar taḳhas kī khāloṅ kā ġhilāf ḍāleṅ. Is ke bād wuh mez ko uṭhāne kī lakaṛiyāṅ lagāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Wuh shamādān aur us ke sāmān par yānī us ke charaġh, battī katarne kī qainchiyoṅ, jalte koele ke chhoṭe bartanoṅ aur tel ke bartanoṅ par nīle rang kā kapṛā rakheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Yih sab kuchh wuh taḳhas kī khāloṅ ke ġhilāf meṅ lapeṭeṅ aur use uṭhā kar le jāne ke lie ek chaukhaṭe par rakheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Wuh baḳhūr jalāne kī sone kī qurbāngāh par bhī nīle rang kā kapṛā bichhā kar us par taḳhas kī khāloṅ kā ġhilāf ḍāleṅ aur phir use uṭhāne kī lakaṛiyāṅ lagāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Wuh sārā sāmān jo Muqaddas Kamre meṅ istemāl hotā hai le kar nīle rang ke kapṛe meṅ lapeṭeṅ, us par taḳhas kī khāloṅ kā ġhilāf ḍāleṅ aur use uṭhā kar le jāne ke lie ek chaukhaṭe par rakheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Phir wuh jānwaroṅ ko jalāne kī qurbāngāh ko rākh se sāf karke us par arġhawānī rang kā kapṛā bichhāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Us par wuh qurbāngāh kī ḳhidmat ke lie sārā zarūrī sāmān rakheṅ yānī chhiṛkāw ke kaṭore, jalte hue koele ke bartan, belche aur kāṅṭe. Is sāmān par wuh taḳhas kī khāloṅ kā ġhilāf ḍāl kar qurbāngāh ko uṭhāne kī lakaṛiyāṅ lagāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Safr ke lie rawānā hote waqt yih sab kuchh uṭhā kar le jānā Qihātiyoṅ kī zimmedārī hai. Lekin lāzim hai ki pahle Hārūn aur us ke beṭe yih tamām muqaddas chīzeṅ ḍhāṅpeṅ. Qihātī in meṅ se koī bhī chīz na chhueṅ warnā mar jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Hārūn Imām kā beṭā Iliyazar pūre muqaddas ḳhaime aur us ke sāmān kā inchārj ho. Is meṅ charāġhoṅ kā tel, baḳhūr, ġhallā kī rozānā nazar aur masah kā tel bhī shāmil hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Rab ne Mūsā aur Hārūn se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Ḳhabardār raho ki Qihāt ke kunbe Lāwī ke qabīle meṅ se miṭne na pāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Chunāṅche jab wuh muqaddastarīn chīzoṅ ke pās āeṅ to Hārūn aur us ke beṭe har ek ko us sāmān ke pās le jāeṅ jo use uṭhā kar le jānā hai tāki wuh na mareṅ balki jīte raheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Qihātī ek lamhe ke lie bhī muqaddas chīzeṅ deḳhne ke lie andar na jāeṅ, warnā wuh mar jāeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Phir Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Jairson kī aulād kī mardumshumārī bhī un ke ābāī gharānoṅ aur kunboṅ ke mutābiq karnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Un tamām mardoṅ ko rajisṭar meṅ darj karnā jo 30 se le kar 50 sāl ke haiṅ aur mulāqāt ke ḳhaime meṅ ḳhidmat ke lie ā sakte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Wuh yih chīzeṅ uṭhā kar le jāne ke zimmedār haiṅ: ");
INSERT INTO urdgvr_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","mulāqāt kā ḳhaimā, us kī chhat, chhat par rakhī huī taḳhas kī khāl kī poshish, ḳhaime ke darwāze kā pardā, ");
INSERT INTO urdgvr_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ḳhaime aur qurbāngāh kī chārdīwārī ke parde, chārdīwārī ke darwāze kā pardā, us ke rasse aur use lagāne kā bāqī sāmān. Wuh un tamām kāmoṅ ke zimmedār haiṅ jo in chīzoṅ se munsalik haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Jairsoniyoṅ kī pūrī ḳhidmat Hārūn aur us ke beṭoṅ kī hidāyāt ke mutābiq ho. Ḳhabardār raho ki wuh sab kuchh ain hidāyāt ke mutābiq uṭhā kar le jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Yih sab mulāqāt ke ḳhaime meṅ Jairsoniyoṅ kī zimmedāriyāṅ haiṅ. Is kām meṅ Hārūn Imām kā beṭā Itamar un par muqarrar hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Rab ne kahā, “Mirārī kī aulād kī mardumshumārī bhī un ke ābāī gharānoṅ aur kunboṅ ke mutābiq karnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Un tamām mardoṅ ko rajisṭar meṅ darj karnā jo 30 se le kar 50 sāl ke haiṅ aur mulāqāt ke ḳhaime meṅ ḳhidmat ke lie ā sakte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Wuh mulāqāt ke ḳhaime kī yih chīzeṅ uṭhā kar le jāne ke zimmedār haiṅ: dīwār ke taḳhte, shahtīr, khambe aur pāe, ");
INSERT INTO urdgvr_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","phir ḳhaime kī chārdīwārī ke khambe, pāe, meḳheṅ, rasse aur yih chīzeṅ lagāne kā sāmān. Har ek ko tafsīl se batānā ki wuh kyā kyā uṭhā kar le jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Yih sab kuchh Mirāriyoṅ kī mulāqāt ke ḳhaime meṅ zimmedāriyoṅ meṅ shāmil hai. Is kām meṅ Hārūn Imām kā beṭā Itamar un par muqarrar ho.” ");
INSERT INTO urdgvr_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Mūsā, Hārūn aur jamāt ke rāhnumāoṅ ne Qihātiyoṅ kī mardumshumārī un ke kunboṅ aur ābāī gharānoṅ ke mutābiq kī. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","37","Unhoṅ ne un tamām mardoṅ ko rajisṭar meṅ darj kiyā jo 30 se le kar 50 sāl ke the aur jo mulāqāt ke ḳhaime meṅ ḳhidmat kar sakte the. Un kī kul tādād 2,750 thī. Mūsā aur Hārūn ne sab kuchh waisā hī kiyā jaisā Rab ne Mūsā kī mārifat farmāyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","41","Phir Jairsoniyoṅ kī mardumshumārī un ke kunboṅ aur ābāī gharānoṅ ke mutābiq huī. Ḳhidmat ke lāyq mardoṅ kī kul tādād 2,630 thī. Mūsā aur Hārūn ne sab kuchh waisā hī kiyā jaisā Rab ne Mūsā ke zariye farmāyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","45","Phir Mirāriyoṅ kī mardumshumārī un ke kunboṅ aur ābāī gharānoṅ ke mutābiq huī. Ḳhidmat ke lāyq mardoṅ kī kul tādād 3,200 thī. Mūsā aur Hārūn ne sab kuchh waisā hī kiyā jaisā Rab ne Mūsā ke zariye farmāyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","48","Lāwiyoṅ ke un mardoṅ kī kul tādād 8,580 thī jinheṅ mulāqāt ke ḳhaime meṅ ḳhidmat karnā aur safr karte waqt use uṭhā kar le jānā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Mūsā ne Rab ke hukm ke mutābiq har ek ko us kī apnī apnī zimmedārī sauṅpī aur use batāyā ki use kyā kyā uṭhā kar le jānā hai. Yoṅ un kī mardumshumārī Rab ke us hukm ke ain mutābiq kī gaī jo us ne Mūsā kī mārifat diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Isrāīliyoṅ ko hukm de ki har us shaḳhs ko ḳhaimāgāh se bāhar kar do jis ko wabāī jildī bīmārī hai, jis ke zaḳhmoṅ se māe nikaltā rahtā hai yā jo kisī lāsh ko chhūne se nāpāk hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ḳhāh mard ho yā aurat, sab ko ḳhaimāgāh ke bāhar bhej denā tāki wuh ḳhaimāgāh ko nāpāk na kareṅ jahāṅ maiṅ tumhāre darmiyān sukūnat kartā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Isrāīliyoṅ ne waisā hī kiyā jaisā Rab ne Mūsā ko kahā thā. Unhoṅ ne Rab ke hukm ke ain mutābiq is tarah ke tamām logoṅ ko ḳhaimāgāh se bāhar kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Isrāīliyoṅ ko hidāyat denā ki jo bhī kisī se ġhalat sulūk kare wuh mere sāth bewafāī kartā hai aur qusūrwār hai, ḳhāh mard ho yā aurat. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Lāzim hai ki wuh apnā gunāh taslīm kare aur us kā pūrā muāwazā de balki muta'assirā shaḳhs kā nuqsān pūrā karne ke alāwā 20 fīsad zyādā de. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Lekin agar wuh shaḳhs jis kā qusūr kiyā gayā thā mar chukā ho aur us kā koī wāris na ho jo yih muāwazā wasūl kar sake to phir use Rab ko denā hai. Imām ko yih muāwazā us menḍhe ke alāwā milegā jo qusūrwār apne kaffārā ke lie degā. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","10","Nīz imām ko Isrāīliyoṅ kī qurbāniyoṅ meṅ se wuh kuchh milnā hai jo uṭhāne wālī qurbānī ke taur par use diyā jātā hai. Yih hissā sirf imāmoṅ ko hī milnā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Isrāīliyoṅ ko batānā, ho saktā hai ki koī shādīshudā aurat bhaṭak kar apne shauhar se bewafā ho jāe aur ");
INSERT INTO urdgvr_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","kisī aur se hambistar ho kar nāpāk ho jāe. Us ke shauhar ne use nahīṅ dekhā, kyoṅki yih poshīdagī meṅ huā hai aur na kisī ne use pakaṛā, na is kā koī gawāh hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Agar shauhar ko apnī bīwī kī wafādārī par shak ho aur wuh ġhairat khāne lage, lekin yaqīn se nahīṅ kah saktā ki merī bīwī qusūrwār hai ki nahīṅ ");
INSERT INTO urdgvr_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","to wuh apnī bīwī ko imām ke pās le āe. Sāth sāth wuh apnī bīwī ke lie qurbānī ke taur par jau kā ḍeṛh kilogrām behtarīn maidā le āe. Is par na tel unḍelā jāe, na baḳhūr ḍālā jāe, kyoṅki ġhallā kī yih nazar ġhairat kī nazar hai jis kā maqsad hai ki poshīdā qusūr zāhir ho jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Imām aurat ko qarīb āne de aur Rab ke sāmne khaṛā kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Wuh miṭṭī kā bartan muqaddas pānī se bhar kar us meṅ maqdis ke farsh kī kuchh ḳhāk ḍāle. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Phir wuh aurat ko Rab ko pesh karke us ke bāl khulwāe aur us ke hāthoṅ par maide kī nazar rakhe. Imām ke apne hāth meṅ kaṛwe pānī kā wuh bartan ho jo lānat kā bāis hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Phir wuh aurat ko qasam khilā kar kahe, ‘Agar koī aur ādmī āp se hambistar nahīṅ huā hai aur āp nāpāk nahīṅ huī haiṅ to is kaṛwe pānī kī lānat kā āp par koī asar na ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Lekin agar āp bhaṭak kar apne shauhar se bewafā ho gaī haiṅ aur kisī aur se hambistar ho kar nāpāk ho gaī haiṅ ");
INSERT INTO urdgvr_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","to Rab āp ko āp kī qaum ke sāmne lānatī banāe. Āp bāṅjh ho jāeṅ aur āp kā peṭ phūl jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Jab lānat kā yih pānī āp ke peṭ meṅ utre to āp bāṅjh ho jāeṅ aur āp kā peṭ phūl jāe.’ Is par aurat kahe, ‘Āmīn, aisā hī ho.’ ");
INSERT INTO urdgvr_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Phir imām yih lānat likh kar kāġhaz ko bartan ke pānī meṅ yoṅ dho de ki us par likhī huī bāteṅ pānī meṅ ghul jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Bād meṅ wuh aurat ko yih pānī pilāe tāki wuh us ke jism meṅ jā kar use lānat pahuṅchāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Lekin pahle imām us ke hāthoṅ meṅ se ġhairat kī qurbānī le kar use ġhallā kī nazar ke taur par Rab ke sāmne hilāe aur phir qurbāngāh ke pās le āe. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Us par wuh muṭṭhī-bhar yādgārī kī qurbānī ke taur par jalāe. Is ke bād wuh aurat ko pānī pilāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Agar wuh apne shauhar se bewafā thī aur nāpāk ho gaī hai to wuh bāṅjh ho jāegī, us kā peṭ phūl jāegā aur wuh apnī qaum ke sāmne lānatī ṭhahregī. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Lekin agar wuh pāk-sāf hai to use sazā nahīṅ dī jāegī aur wuh bachche janm dene ke qābil rahegī. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","30","Chunāṅche aisā hī karnā hai jab shauhar ġhairat khāe aur use apnī bīwī par zinā kā shak ho. Bīwī ko qurbāngāh ke sāmne khaṛā kiyā jāe aur imām yih sab kuchh kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Is sūrat meṅ shauhar bequsūr ṭhahregā, lekin agar us kī bīwī ne wāqaī zinā kiyā ho to use apne gunāh ke natīje bardāsht karne paṛeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Isrāīliyoṅ ko hidāyat denā ki agar koī ādmī yā aurat mannat mān kar apne āp ko ek muqarrarā waqt ke lie Rab ke lie maḳhsūs kare ");
INSERT INTO urdgvr_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","to wuh mai yā koī aur nashā-āwar chīz na pie. Na wuh angūr yā kisī aur chīz kā sirkā pie, na angūr kā ras. Wuh angūr yā kishmish na khāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Jab tak wuh maḳhsūs hai wuh angūr kī koī bhī paidāwār na khāe, yahāṅ tak ki angūr ke bīj yā chhilke bhī na khāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Jab tak wuh apnī mannat ke mutābiq maḳhsūs hai wuh apne bāl na kaṭwāe. Jitnī der ke lie us ne apne āp ko Rab ke lie maḳhsūs kiyā hai utnī der tak wuh muqaddas hai. Is lie wuh apne bāl baṛhne de. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Jab tak wuh maḳhsūs hai wuh kisī lāsh ke qarīb na jāe, ");
INSERT INTO urdgvr_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","chāhe wuh us ke bāp, māṅ, bhāī yā bahan kī lāsh kyoṅ na ho. Kyoṅki is se wuh nāpāk ho jāegā jabki abhī tak us kī maḳhsūsiyat lambe bāloṅ kī sūrat meṅ nazar ātī hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Wuh apnī maḳhsūsiyat ke daurān Rab ke lie maḳhsūs-o-muqaddas hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Agar koī achānak mar jāe jab maḳhsūs shaḳhs us ke qarīb ho to us ke maḳhsūs bāl nāpāk ho jāeṅge. Aisī sūrat meṅ lāzim hai ki wuh apne āp ko pāk-sāf karke sātweṅ din apne sar ko munḍwāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Āṭhweṅ din wuh do qumriyāṅ yā do jawān kabūtar le kar mulāqāt ke ḳhaime ke darwāze par āe aur imām ko de. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Imām in meṅ se ek ko gunāh kī qurbānī ke taur par chaṛhāe aur dūsre ko bhasm hone wālī qurbānī ke taur par. Yoṅ wuh us ke lie kaffārā degā jo lāsh ke qarīb hone se nāpāk ho gayā hai. Usī din wuh apne sar ko dubārā maḳhsūs kare ");
INSERT INTO urdgvr_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","aur apne āp ko muqarrarā waqt ke lie dubārā Rab ke lie maḳhsūs kare. Wuh qusūr kī qurbānī ke taur par ek sāl kā bheṛ kā bachchā pesh kare. Jitne din us ne pahle maḳhsūsiyat kī hālat meṅ guzāre haiṅ wuh shumār nahīṅ kie jā sakte kyoṅki wuh maḳhsūsiyat kī hālat meṅ nāpāk ho gayā thā. Wuh dubārā pahle din se shurū kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Sharīat ke mutābiq jab maḳhsūs shaḳhs kā muqarrarā waqt guzar gayā ho to pahle use mulāqāt ke ḳhaime ke darwāze par lāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Wahāṅ wuh Rab ko bhasm hone wālī qurbānī ke lie bheṛ kā ek beaib yaksālā nar bachchā, gunāh kī qurbānī ke lie ek beaib yaksālā bheṛ aur salāmatī kī qurbānī ke lie ek beaib menḍhā pesh kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Is ke alāwā wuh ek ṭokrī meṅ beḳhamīrī roṭiyāṅ jin meṅ behtarīn maidā aur tel milāyā gayā ho aur beḳhamīrī roṭiyāṅ jin par tel lagāyā gayā ho mutālliqā ġhallā kī nazar aur mai kī nazar ke sāth ");
INSERT INTO urdgvr_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Rab ko pesh kare. Pahle imām gunāh kī qurbānī aur bhasm hone wālī qurbānī Rab ke huzūr chaṛhāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Phir wuh menḍhe ko beḳhamīrī roṭiyoṅ ke sāth salāmatī kī qurbānī ke taur par pesh kare. Imām ġhallā kī nazar aur mai kī nazar bhī chaṛhāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Is daurān maḳhsūs shaḳhs mulāqāt ke ḳhaime par apne maḳhsūs kie gae sar ko munḍwā kar tamām bāl salāmatī kī qurbānī kī āg meṅ phaiṅke. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Phir imām menḍhe kā ek pakā huā shānā aur ṭokrī meṅ se donoṅ qismoṅ kī ek ek roṭī le kar maḳhsūs shaḳhs ke hāthoṅ par rakhe. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Is ke bād wuh yih chīzeṅ wāpas le kar unheṅ hilāne kī qurbānī ke taur par Rab ke sāmne hilāe. Yih ek muqaddas qurbānī hai jo imām kā hissā hai. Salāmatī kī qurbānī kā hilāyā huā Sīnā aur uṭhāī huī rān bhī imām kā hissā haiṅ. Qurbānī ke iḳhtitām par maḳhsūs kie hue shaḳhs ko mai pīne kī ijāzat hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Jo apne āp ko Rab ke lie maḳhsūs kartā hai wuh aisā hī kare. Lāzim hai ki wuh in hidāyāt ke mutābiq tamām qurbāniyāṅ pesh kare. Agar gunjāish ho to wuh aur bhī pesh kar saktā hai. Baharhāl lāzim hai ki wuh apnī mannat aur yih hidāyāt pūrī kare.” ");
INSERT INTO urdgvr_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Hārūn aur us ke beṭoṅ ko batā denā ki wuh Isrāīliyoṅ ko yoṅ barkat deṅ, ");
INSERT INTO urdgvr_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Rab tujhe barkat de aur terī hifāzat kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Rab apne chehre kā mehrbān nūr tujh par chamkāe aur tujh par rahm kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Rab kī nazar-e-karm tujh par ho, aur wuh tujhe salāmatī baḳhshe.’ ");
INSERT INTO urdgvr_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Yoṅ wuh merā nām le kar Isrāīliyoṅ ko barkat deṅ. Phir maiṅ unheṅ barkat dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Jis din maqdis mukammal huā usī din Mūsā ne use maḳhsūs-o-muqaddas kiyā. Is ke lie us ne ḳhaime, us ke tamām sāmān, qurbāngāh aur us ke tamām sāmān par tel chhiṛkā. ");
INSERT INTO urdgvr_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","3","Phir qabīloṅ ke bārah sardār maqdis ke lie hadiye le kar āe. Yih wuhī rāhnumā the jinhoṅ ne mardumshumārī ke waqt Mūsā kī madad kī thī. Unhoṅ ne chhat wālī chhih bail gāṛiyāṅ aur bārah bail ḳhaime ke sāmne Rab ko pesh kie, do do sardāroṅ kī taraf se ek bailgāṛī aur har ek sardār kī taraf se ek bail. ");
INSERT INTO urdgvr_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Yih tohfe qabūl karke mulāqāt ke ḳhaime ke kām ke lie istemāl kar. Unheṅ Lāwiyoṅ meṅ un kī ḳhidmat kī zarūrat ke mutābiq taqsīm karnā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Chunāṅche Mūsā ne bail gāṛiyāṅ aur bail Lāwiyoṅ ko de die. ");
INSERT INTO urdgvr_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Us ne do bail gāṛiyāṅ chār bailoṅ samet Jairsoniyoṅ ko ");
INSERT INTO urdgvr_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","aur chār bail gāṛiyāṅ āṭh bailoṅ samet Mirāriyoṅ ko dīṅ. Mirārī Hārūn Imām ke beṭe Itamar ke taht ḳhidmat karte the. ");
INSERT INTO urdgvr_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Lekin Mūsā ne Qihātiyoṅ ko na bail gāṛiyāṅ aur na bail die. Wajah yih thī ki jo muqaddas chīzeṅ un ke sapurd thīṅ wuh un ko kandhoṅ par uṭhā kar le jānī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Bārah sardār qurbāngāh kī maḳhsūsiyat ke mauqe par bhī hadiye le āe. Unhoṅ ne apne hadiye qurbāngāh ke sāmne pesh kie. ");
INSERT INTO urdgvr_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Rab ne Mūsā se kahā, “Sardār bārah din ke daurān bārī bārī apne hadiye pesh kareṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Pahle din Yahūdāh ke sardār Nahson bin Ammīnadāb kī bārī thī. Us ke hadiye yih the: ");
INSERT INTO urdgvr_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","chāṅdī kā thāl jis kā wazn ḍeṛh kilogrām thā aur chhiṛkāw kā chāṅdī kā kaṭorā jis kā wazn 800 grām thā. Donoṅ ġhallā kī nazar ke lie tel ke sāth milāe gae behtarīn maide se bhare hue the. ");
INSERT INTO urdgvr_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","In ke alāwā Nahson ne yih chīzeṅ pesh kīṅ: sone kā pyālā jis kā wazn 110 grām thā aur jo baḳhūr se bharā huā thā, ");
INSERT INTO urdgvr_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ek jawān bail, ek menḍhā, bhasm hone wālī qurbānī ke lie bheṛ kā ek yaksālā bachchā, ");
INSERT INTO urdgvr_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","gunāh kī qurbānī ke lie ek bakrā ");
INSERT INTO urdgvr_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","aur salāmatī kī qurbānī ke lie do bail, pāṅch menḍhe, pāṅch bakre aur bheṛ ke pāṅch yaksālā bachche. ");
INSERT INTO urdgvr_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","23","Agle gyārah din bāqī sardār bhī yihī hadiye maqdis ke pās le āe. Dūsre din Ishkār ke sardār Nataniyel bin Zuġhar kī bārī thī, ");
INSERT INTO urdgvr_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","29","tīsre din Zabūlūn ke sardār Iliyāb bin Helon kī, ");
INSERT INTO urdgvr_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","47","chauthe din Rūbin ke sardār Ilīsūr bin Shadiyūr kī, pāṅchweṅ din Shamāūn ke sardār Salūmiyel bin Sūrīshaddī kī, chhaṭe din Jad ke sardār Iliyāsaf bin Daūel kī, ");
INSERT INTO urdgvr_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","53","sātweṅ din Ifrāīm ke sardār Ilīsamā bin Ammīhūd kī, ");
INSERT INTO urdgvr_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","71","āṭhweṅ din Manassī ke sardār Jamliyel bin Fadāhsūr kī, naweṅ din Binyamīn ke sardār Abidān bin Jidāūnī kī, dasweṅ din Dān ke sardār Aḳhiyazar bin Ammīshaddī kī, ");
INSERT INTO urdgvr_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","83","gyārhweṅ din Āshar ke sardār Fajiyel bin Akrān kī aur bārhweṅ din Naftālī ke sardār Aḳhīrā bin Enān kī bārī thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Isrāīl ke in sardāroṅ ne mil kar qurbāngāh kī maḳhsūsiyat ke lie chāṅdī ke 12 thāl, chhiṛkāw ke chāṅdī ke 12 kaṭore aur sone ke 12 pyāle pesh kie. ");
INSERT INTO urdgvr_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Har thāl kā wazn ḍeṛh kilogrām aur chhiṛkāw ke har kaṭore kā wazn 800 grām thā. In chīzoṅ kā kul wazn taqrīban 28 kilogrām thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Baḳhūr se bhare hue sone ke pyāloṅ kā kul wazn taqrīban ḍeṛh kilogrām thā (fī pyālā 110 grām). ");
INSERT INTO urdgvr_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Sardāroṅ ne mil kar bhasm hone wālī qurbānī ke lie 12 jawān bail, 12 menḍhe aur bheṛ ke 12 yaksālā bachche un kī ġhallā kī nazaroṅ samet pesh kie. Gunāh kī qurbānī ke lie unhoṅ ne 12 bakre pesh kie ");
INSERT INTO urdgvr_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","aur salāmatī kī qurbānī ke lie 24 bail, 60 menḍhe, 60 bakre aur bheṛ ke 60 yaksālā bachche. In tamām jānwaroṅ ko qurbāngāh kī maḳhsūsiyat ke mauqe par chaṛhāyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Jab Mūsā mulāqāt ke ḳhaime meṅ Rab ke sāth bāt karne ke lie dāḳhil hotā thā to wuh Rab kī āwāz ahd ke sandūq ke ḍhakne par se yānī do karūbī farishtoṅ ke darmiyān se suntā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Hārūn ko batānā, ‘Tujhe sāt charāġhoṅ ko shamādān par yoṅ rakhnā hai ki wuh shamādān kā sāmne wālā hissā raushan kareṅ.’” ");
INSERT INTO urdgvr_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Hārūn ne aisā hī kiyā. Jis tarah Rab ne Mūsā ko hukm diyā thā usī tarah us ne charāġhoṅ ko rakh diyā tāki wuh sāmne wālā hissā raushan kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Shamādān pāe se le kar ūpar kī kaliyoṅ tak sone ke ek ghaṛe hue ṭukṛe kā banā huā thā. Mūsā ne use us namūne ke ain mutābiq banwāyā jo Rab ne use dikhāyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Lāwiyoṅ ko dīgar Isrāīliyoṅ se alag karke pāk-sāf karnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Is ke lie gunāh se pāk karne wālā pānī un par chhiṛak kar unheṅ hukm denā ki apne jism ke pūre bāl munḍwāo aur apne kapṛe dho'o. Yoṅ wuh pāk-sāf ho jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Phir wuh ek jawān bail chuneṅ aur sāth kī ġhallā kī nazar ke lie tel ke sāth milāyā gayā behtarīn maidā leṅ. Tū ḳhud bhī ek jawān bail chun. Wuh gunāh kī qurbānī ke lie hogā. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Is ke bād Lāwiyoṅ ko mulāqāt ke ḳhaime ke sāmne khaṛā karke Isrāīl kī pūrī jamāt ko wahāṅ jamā karnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Jab Lāwī Rab ke sāmne khaṛe hoṅ to bāqī Isrāīlī un ke saroṅ par apne hāth rakheṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Phir Hārūn Lāwiyoṅ ko Rab ke sāmne pesh kare. Unheṅ Isrāīliyoṅ kī taraf se hilāī huī qurbānī kī haisiyat se pesh kiyā jāe tāki wuh Rab kī ḳhidmat kar sakeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Phir Lāwī apne hāth donoṅ bailoṅ ke saroṅ par rakheṅ. Ek bail ko gunāh kī qurbānī ke taur par aur dūsre ko bhasm hone wālī qurbānī ke taur par chaṛhāo tāki Lāwiyoṅ kā kaffārā diyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Lāwiyoṅ ko is tarīqe se Hārūn aur us ke beṭoṅ ke sāmne khaṛā karke Rab ko hilāī huī qurbānī ke taur par pesh karnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Unheṅ bāqī Isrāīliyoṅ se alag karne se wuh merā hissā baneṅge. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Is ke bād hī wuh mulāqāt ke ḳhaime meṅ ā kar ḳhidmat kareṅ, kyoṅki ab wuh ḳhidmat karne ke lāyq haiṅ. Unheṅ pāk-sāf karke hilāī huī qurbānī ke taur par pesh karne kā sabab yih hai ");
INSERT INTO urdgvr_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ki Lāwī Isrāīliyoṅ meṅ se wuh haiṅ jo mujhe pūre taur par die gae haiṅ. Maiṅ ne unheṅ Isrāīliyoṅ ke tamām pahlauṭhoṅ kī jagah le liyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Kyoṅki Isrāīl meṅ har pahlauṭhā merā hai, ḳhāh wuh insān kā ho yā haiwān kā. Us din jab maiṅ ne Misriyoṅ ke pahlauṭhoṅ ko mār diyā maiṅ ne Isrāīl ke pahlauṭhoṅ ko apne lie maḳhsūs-o-muqaddas kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Is silsile meṅ maiṅ ne Lāwiyoṅ ko Isrāīliyoṅ ke tamām pahlauṭhoṅ kī jagah le kar ");
INSERT INTO urdgvr_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","unheṅ Hārūn aur us ke beṭoṅ ko diyā hai. Wuh mulāqāt ke ḳhaime meṅ Isrāīliyoṅ kī ḳhidmat kareṅ aur un ke lie kaffārā kā intazām qāym rakheṅ tāki jab Isrāīlī maqdis ke qarīb āeṅ to un ko wabā se mārā na jāe.” ");
INSERT INTO urdgvr_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mūsā, Hārūn aur Isrāīliyoṅ kī pūrī jamāt ne ehtiyāt se Rab kī Lāwiyoṅ ke bāre meṅ hidāyāt par amal kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Lāwiyoṅ ne apne āp ko gunāhoṅ se pāk-sāf karke apne kapṛoṅ ko dhoyā. Phir Hārūn ne unheṅ Rab ke sāmne hilāī huī qurbānī ke taur par pesh kiyā aur un kā kaffārā diyā tāki wuh pāk ho jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Is ke bād Lāwī mulāqāt ke ḳhaime meṅ āe tāki Hārūn aur us ke beṭoṅ ke taht ḳhidmat kareṅ. Yoṅ sab kuchh waisā hī kiyā gayā jaisā Rab ne Mūsā ko hukm diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Rab ne Mūsā se yih bhī kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Lāwī 25 sāl kī umr meṅ mulāqāt ke ḳhaime meṅ apnī ḳhidmat shurū kareṅ ");
INSERT INTO urdgvr_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","aur 50 sāl kī umr meṅ riṭāyar ho jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Is ke bād wuh mulāqāt ke ḳhaime meṅ apne bhāiyoṅ kī madad kar sakte haiṅ, lekin ḳhud ḳhidmat nahīṅ kar sakte. Tujhe Lāwiyoṅ ko in hidāyāt ke mutābiq un kī apnī apnī zimmedāriyāṅ denī haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Isrāīliyoṅ ko Misr se nikle ek sāl ho gayā thā. Dūsre sāl ke pahle mahīne meṅ Rab ne Dasht-e-Sīnā meṅ Mūsā se bāt kī. ");
INSERT INTO urdgvr_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Lāzim hai ki Isrāīlī Īd-e-Fasah ko muqarrarā waqt par manāeṅ, ");
INSERT INTO urdgvr_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","yānī is mahīne ke chaudhweṅ din, sūraj ke ġhurūb hone ke ain bād. Use tamām qawāyd ke mutābiq manānā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Chunāṅche Mūsā ne Isrāīliyoṅ se kahā ki wuh Īd-e-Fasah manāeṅ, ");
INSERT INTO urdgvr_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","aur unhoṅ ne aisā hī kiyā. Unhoṅ ne Īd-e-Fasah ko pahle mahīne ke chaudhweṅ din sūraj ke ġhurūb hone ke ain bād manāyā. Unhoṅ ne sab kuchh waisā hī kiyā jaisā Rab ne Mūsā ko hukm diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Lekin kuchh ādmī nāpāk the, kyoṅki unhoṅ ne lāsh chhū lī thī. Is wajah se wuh us din Īd-e-Fasah na manā sake. Wuh Mūsā aur Hārūn ke pās ā kar ");
INSERT INTO urdgvr_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","kahne lage, “Ham ne lāsh chhū lī hai, is lie nāpāk haiṅ. Lekin hameṅ is sabab se Īd-e-Fasah ko manāne se kyoṅ rokā jāe? Ham bhī muqarrarā waqt par bāqī Isrāīliyoṅ ke sāth Rab kī qurbānī pesh karnā chāhte haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mūsā ne jawāb diyā, “Yahāṅ mere intazār meṅ khaṛe raho. Maiṅ mālūm kartā hūṅ ki Rab tumhāre bāre meṅ kyā hukm detā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Isrāīliyoṅ ko batā denā ki agar tum yā tumhārī aulād meṅ se koī Īd-e-Fasah ke daurān lāsh chhūne se nāpāk ho yā kisī dūr-darāz ilāqe meṅ safr kar rahā ho, to bhī wuh īd manā saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Aisā shaḳhs use ain ek māh ke bād manā kar lele ke sāth beḳhamīrī roṭī aur kaṛwā sāg-pāt khāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Khāne meṅ se kuchh bhī aglī subah tak bāqī na rahe. Jānwar kī koī bhī haḍḍī na toṛnā. Manāne wālā Īd-e-Fasah ke pūre farāyz adā kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Lekin jo pāk hone aur safr na karne ke bāwujūd bhī Īd-e-Fasah ko na manāe use us kī qaum meṅ se miṭāyā jāe, kyoṅki us ne muqarrarā waqt par Rab ko qurbānī pesh nahīṅ kī. Us shaḳhs ko apne gunāh kā natījā bhugatnā paṛegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Agar koī pardesī tumhāre darmiyān rahte hue Rab ke sāmne Īd-e-Fasah manānā chāhe to use ijāzat hai. Shart yih hai ki wuh pūre farāyz adā kare. Pardesī aur desī ke lie Īd-e-Fasah manāne ke farāyz ek jaise haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Jis din sharīat ke muqaddas ḳhaime ko khaṛā kiyā gayā us din bādal ā kar us par chhā gayā. Rāt ke waqt bādal āg kī sūrat meṅ nazar āyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Is ke bād yihī sūrat-e-hāl rahī ki bādal us par chhāyā rahtā aur rāt ke daurān āg kī sūrat meṅ nazar ātā. ");
INSERT INTO urdgvr_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Jab bhī bādal ḳhaime par se uṭhtā Isrāīlī rawānā ho jāte. Jahāṅ bhī bādal utar jātā wahāṅ Isrāīlī apne ḍere ḍālte. ");
INSERT INTO urdgvr_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Isrāīlī Rab ke hukm par rawānā hote aur us ke hukm par ḍere ḍālte. Jab tak bādal maqdis par chhāyā rahtā us waqt tak wuh wahīṅ ṭhaharte. ");
INSERT INTO urdgvr_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Kabhī kabhī bādal baṛī der tak ḳhaime par ṭhahrā rahtā. Tab Isrāīlī Rab kā hukm mān kar rawānā na hote. ");
INSERT INTO urdgvr_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Kabhī kabhī bādal sirf do chār din ke lie ḳhaime par ṭhahartā. Phir wuh Rab ke hukm ke mutābiq hī ṭhaharte aur rawānā hote the. ");
INSERT INTO urdgvr_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Kabhī kabhī bādal sirf shām se le kar subah tak ḳhaime par ṭhahartā. Jab wuh subah ke waqt uṭhtā to Isrāīlī bhī rawānā hote the. Jab bhī bādal uṭhtā wuh bhī rawānā ho jāte. ");
INSERT INTO urdgvr_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Jab tak bādal muqaddas ḳhaime par chhāyā rahtā us waqt tak Isrāīlī rawānā na hote, chāhe wuh do din, ek māh, ek sāl yā is se zyādā arsā maqdis par chhāyā rahtā. Lekin jab wuh uṭhtā to Isrāīlī bhī rawānā ho jāte. ");
INSERT INTO urdgvr_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Wuh Rab ke hukm par ḳhaime lagāte aur us ke hukm par rawānā hote the. Wuh waisā hī karte the jaisā Rab Mūsā kī mārifat farmātā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Chāṅdī ke do bigul ghaṛ kar banwā le. Unheṅ jamāt ko jamā karne aur qabīloṅ ko rawānā karne ke lie istemāl kar. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Jab donoṅ ko der tak bajāyā jāe to pūrī jamāt mulāqāt ke ḳhaime ke darwāze par ā kar tere sāmne jamā ho jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Lekin agar ek hī bajāyā jāe to sirf kunboṅ ke buzurg tere sāmne jamā ho jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Agar un kī āwāz sirf thoṛī der ke lie sunāī de to maqdis ke mashriq meṅ maujūd qabīle rawānā ho jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Phir jab un kī āwāz dūsrī bār thoṛī der ke lie sunāī de to maqdis ke junūb meṅ maujūd qabīle rawānā ho jāeṅ. Jab un kī āwāz thoṛī der ke lie sunāī de to yih rawānā hone kā elān hogā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Is ke muqābale meṅ jab un kī āwāz der tak sunāī de to yih is bāt kā elān hogā ki jamāt jamā ho jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Bigul bajāne kī zimmedārī Hārūn ke beṭoṅ yānī imāmoṅ ko dī jāe. Yih tumhāre aur āne wālī nasloṅ ke lie dāymī usūl ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Un kī āwāz us waqt bhī thoṛī der ke lie sunā do jab tum apne mulk meṅ kisī zālim dushman se jang laṛne ke lie nikloge. Tab Rab tumhārā Ḳhudā tumheṅ yād karke dushman se bachāegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Isī tarah un kī āwāz maqdis meṅ ḳhushī ke mauqoṅ par sunāī de yānī muqarrarā īdoṅ aur Nae Chāṅd kī Īdoṅ par. In mauqoṅ par wuh bhasm hone wālī qurbāniyāṅ aur salāmatī kī qurbāniyāṅ chaṛhāte waqt bajāe jāeṅ. Phir tumhārā Ḳhudā tumheṅ yād karegā. Maiṅ Rab tumhārā Ḳhudā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Isrāīliyoṅ ko Misr se nikle ek sāl se zāyd arsā ho chukā thā. Dūsre mahīne ke bīsweṅ din bādal mulāqāt ke ḳhaime par se uṭhā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Phir Isrāīlī muqarrarā tartīb ke mutābiq Dasht-e-Sīnā se rawānā hue. Chalte chalte bādal Fārān ke registān meṅ utar āyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Us waqt wuh pahlī dafā us tartīb se rawānā hue jo Rab ne Mūsā kī mārifat muqarrar kī thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Pahle Yahūdāh ke qabīle ke tīn daste apne alam ke taht chal paṛe. Tīnoṅ kā kamānḍar Nahson bin Ammīnadāb thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Sāth chalne wāle qabīle Ishkār kā kamānḍar Nataniyel bin Zuġhar thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Zabūlūn kā qabīlā bhī sāth chalā jis kā kamānḍar Iliyāb bin Helon thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Is ke bād mulāqāt kā ḳhaimā utārā gayā. Jairsonī aur Mirārī use uṭhā kar chal die. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","In Lāwiyoṅ ke bād Rūbin ke qabīle ke tīn daste apne alam ke taht chalne lage. Tīnoṅ kā kamānḍar Ilīsūr bin Shadiyūr thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Sāth chalne wāle qabīle Shamāūn kā kamānḍar Salūmiyel bin Sūrīshaddī thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Jad kā qabīlā bhī sāth chalā jis kā kamānḍar Iliyāsaf bin Daūel thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Phir Lāwiyoṅ meṅ se Qihātī maqdis kā sāmān uṭhā kar rawānā hue. Lāzim thā ki un ke aglī manzil par pahuṅchne tak mulāqāt kā ḳhaimā lagā diyā gayā ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Is ke bād Ifrāīm ke qabīle ke tīn daste apne alam ke taht chal die. Un kā kamānḍar Ilīsamā bin Ammīhūd thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Ifrāīm ke sāth chalne wāle qabīle Manassī kā kamānḍar Jamliyel bin Fadāhsūr thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Binyamīn kā qabīlā bhī sāth chalā jis kā kamānḍar Abidān bin Jidāūnī thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Āḳhir meṅ Dān ke tīn daste aqbī muhāfiz ke taur par apne alam ke taht rawānā hue. Un kā kamānḍar Aḳhiyazar bin Ammīshaddī thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Dān ke sāth chalne wāle qabīle Āshar kā kamānḍar Fajiyel bin Akrān thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Naftālī kā qabīlā bhī sāth chalā jis kā kamānḍar Aḳhīrā bin Enān thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Isrāīlī isī tartīb se rawānā hue. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mūsā ne apne Midiyānī susar Raūel yānī Yitro ke beṭe Hobāb se kahā, “Ham us jagah ke lie rawānā ho rahe haiṅ jis kā wādā Rab ne ham se kiyā hai. Hamāre sāth chaleṅ! Ham āp par ehsān kareṅge, kyoṅki Rab ne Isrāīl par ehsān karne kā wādā kiyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Lekin Hobāb ne jawāb diyā, “Maiṅ sāth nahīṅ jāūṅgā balki apne mulk aur rishtedāroṅ ke pās wāpas chalā jāūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mūsā ne kahā, “Mehrbānī karke hameṅ na chhoṛeṅ. Kyoṅki āp hī jānte haiṅ ki ham registān meṅ kahāṅ kahāṅ apne ḍere ḍāl sakte haiṅ. Āp registān meṅ hameṅ rāstā dikhā sakte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Agar āp hamāre sāth jāeṅ to ham āp ko us ehsān meṅ sharīk kareṅge jo Rab ham par karegā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Chunāṅche unhoṅ ne Rab ke pahāṛ se rawānā ho kar tīn din safr kiyā. Is daurān Rab kā ahd kā sandūq un ke āge āge chalā tāki un ke lie ārām karne kī jagah mālūm kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Jab kabhī wuh rawānā hote to Rab kā bādal din ke waqt un ke ūpar rahtā. ");
INSERT INTO urdgvr_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Sandūq ke rawānā hote waqt Mūsā kahtā, “Ai Rab, uṭh. Tere dushman titar-bitar ho jāeṅ. Tujh se nafrat karne wāle tere sāmne se farār ho jāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Aur jab bhī wuh ruk jātā to Mūsā kahtā, “Ai Rab, Isrāīl ke hazāroṅ ḳhāndānoṅ ke pās wāpas ā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ek din log ḳhūb shikāyat karne lage. Jab yih shikāyateṅ Rab tak pahuṅchīṅ to use ġhussā āyā aur us kī āg un ke darmiyān bhaṛak uṭhī. Jalte jalte us ne ḳhaimāgāh kā ek kinārā bhasm kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Log madad ke lie Mūsā ke pās ā kar chillāne lage to us ne Rab se duā kī, aur āg bujh gaī. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Us maqām kā nām Taberā yānī Jalnā paṛ gayā, kyoṅki Rab kī āg un ke darmiyān jal uṭhī thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Isrāīliyoṅ ke sāth jo ajnabī safr kar rahe the wuh gosht khāne kī shadīd ārzū karne lage. Tab Isrāīlī bhī ro paṛe aur kahne lage, “Kaun hameṅ gosht khilāegā? ");
INSERT INTO urdgvr_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Misr meṅ ham machhlī muft khā sakte the. Hāy, wahāṅ ke khīre, tarbūz, gandane, pyāz aur lahsan kitne achchhe the! ");
INSERT INTO urdgvr_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Lekin ab to hamārī jān sūkh gaī hai. Yahāṅ bas man hī man nazar ātā rahtā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Man dhanie ke dānoṅ kī mānind thā, aur us kā rang gūgal ke gūṅd kī mānind thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Rāt ke waqt wuh ḳhaimāgāh meṅ os ke sāth zamīn par girtā thā. Subah ke waqt log idhar-udhar ghūmte-phirte hue use jamā karte the. Phir wuh use chakkī meṅ pīs kar yā ukhlī meṅ kūṭ kar ubālte yā roṭī banāte the. Us kā zāyqā aisī roṭī kā-sā thā jis meṅ zaitūn kā tel ḍālā gayā ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Tamām ḳhāndān apne apne ḳhaime ke darwāze par rone lage to Rab ko shadīd ġhussā āyā. Un kā shor Mūsā ko bhī bahut burā lagā. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Us ne Rab se pūchhā, “Tū ne apne ḳhādim ke sāth itnā burā sulūk kyoṅ kiyā? Maiṅ ne kis kām se tujhe itnā nārāz kiyā ki tū ne in tamām logoṅ kā bojh mujh par ḍāl diyā? ");
INSERT INTO urdgvr_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Kyā maiṅ ne hāmilā ho kar is pūrī qaum ko janm diyā ki tū mujh se kahtā hai, ‘Ise us tarah uṭhā kar le chalnā jis tarah āyā shīrḳhār bachche ko uṭhā kar har jagah sāth lie phirtī hai. Isī tarah ise us mulk meṅ le jānā jis kā wādā maiṅ ne qasam khā kar in ke bāpdādā se kiyā hai.’ ");
INSERT INTO urdgvr_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ai Allāh, maiṅ in tamām logoṅ ko kahāṅ se gosht muhaiyā karūṅ? Wuh mere sāmne rote rahte haiṅ ki hameṅ khāne ke lie gosht do. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Maiṅ akelā in tamām logoṅ kī zimmedārī nahīṅ uṭhā saktā. Yih bojh mere lie had se zyādā bhārī hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Agar tū is par isrār kare to phir behtar hai ki abhī mujhe mār de tāki maiṅ apnī tabāhī na dekhūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Jawāb meṅ Rab ne Mūsā se kahā, “Mere pās Isrāīl ke 70 buzurg jamā kar. Sirf aise log chun jin ke bāre meṅ tujhe mālūm hai ki wuh logoṅ ke buzurg aur nigahbān haiṅ. Unheṅ mulāqāt ke ḳhaime ke pās le ā. Wahāṅ wuh tere sāth khaṛe ho jāeṅ, ");
INSERT INTO urdgvr_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","to maiṅ utar kar tere sāth hamkalām hūṅgā. Us waqt maiṅ us Rūh meṅ se kuchh lūṅgā jo maiṅ ne tujh par nāzil kiyā thā aur use un par nāzil karūṅga. Tab wuh qaum kā bojh uṭhāne meṅ terī madad kareṅge aur tū is meṅ akelā nahīṅ rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Logoṅ ko batānā, ‘Apne āp ko maḳhsūs-o-muqaddas karo, kyoṅki kal tum gosht khāoge. Rab ne tumhārī sunī jab tum ro paṛe ki kaun hameṅ gosht khilāegā, Misr meṅ hamārī hālat behtar thī. Ab Rab tumheṅ gosht muhaiyā karegā aur tum use khāoge. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Tum use na sirf ek, do yā pāṅch din khāoge balki 10 yā 20 din se bhī zyādā arse tak. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Tum ek pūrā mahīnā ḳhūb gosht khāoge, yahāṅ tak ki wuh tumhārī nāk se niklegā aur tumheṅ us se ghin āegī. Aur yih is sabab se hogā ki tum ne Rab ko jo tumhāre darmiyān hai radd kiyā aur rote rote us ke sāmne kahā ki ham kyoṅ Misr se nikle.’” ");
INSERT INTO urdgvr_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Lekin Mūsā ne etarāz kiyā, “Agar qaum ke paidal chalne wāle gine jāeṅ to chhih lākh haiṅ. Tū kis tarah hameṅ ek māh tak gosht muhaiyā karegā? ");
INSERT INTO urdgvr_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Kyā gāy-bailoṅ yā bheṛ-bakriyoṅ ko itnī miqdār meṅ zabah kiyā jā saktā hai ki kāfī ho? Agar samundar kī tamām machhliyāṅ un ke lie pakaṛī jāeṅ to kyā kāfī hoṅgī?” ");
INSERT INTO urdgvr_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Rab ne kahā, “Kyā Rab kā iḳhtiyār kam hai? Ab tū ḳhud dekh legā ki merī bāteṅ durust haiṅ ki nahīṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Chunāṅche Mūsā ne wahāṅ se nikal kar logoṅ ko Rab kī yih bāteṅ batāīṅ. Us ne un ke buzurgoṅ meṅ se 70 ko chun kar unheṅ mulāqāt ke ḳhaime ke irdgird khaṛā kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Tab Rab bādal meṅ utar kar Mūsā se hamkalām huā. Jo Rūh us ne Mūsā par nāzil kiyā thā us meṅ se us ne kuchh le kar un 70 buzurgoṅ par nāzil kiyā. Jab Rūh un par āyā to wuh nabuwwat karne lage. Lekin aisā phir kabhī na huā. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ab aisā huā ki in sattar buzurgoṅ meṅ se do ḳhaimāgāh meṅ rah gae the. Un ke nām Ildād aur medād the. Unheṅ chunā to gayā thā lekin wuh mulāqāt ke ḳhaime ke pās nahīṅ āe the. Is ke bāwujūd Rūh un par bhī nāzil huā aur wuh ḳhaimāgāh meṅ nabuwwat karne lage. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ek naujawān bhāg kar Mūsā ke pās āyā aur kahā, “Ildād aur medād ḳhaimāgāh meṅ hī nabuwwat kar rahe haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Yashua bin Nūn jo jawānī se Mūsā kā madadgār thā bol uṭhā, “Mūsā mere āqā, unheṅ rok deṅ!” ");
INSERT INTO urdgvr_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Lekin Mūsā ne jawāb diyā, “Kyā tū merī ḳhātir ġhairat khā rahā hai? Kāsh Rab ke tamām log nabī hote aur wuh un sab par apnā Rūh nāzil kartā!” ");
INSERT INTO urdgvr_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Phir Mūsā aur Isrāīl ke buzurg ḳhaimāgāh meṅ wāpas āe. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Tab Rab kī taraf se zordār hawā chalne lagī jis ne samundar ko pār karne wāle baṭeroṅ ke ġhol dhakel kar ḳhaimāgāh ke irdgird zamīn par phaiṅk die. Un ke ġhol tīn fuṭ ūṅche aur ḳhaimāgāh ke chāroṅ taraf 30 kilomīṭar tak paṛe rahe. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Us pūre din aur rāt aur agle pūre din log nikal kar baṭereṅ jamā karte rahe. Har ek ne kam az kam das baṛī ṭokriyāṅ bhar līṅ. Phir unhoṅ ne un kā gosht ḳhaime ke irdgird zamīn par phailā diyā tāki wuh ḳhushk ho jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Lekin gosht ke pahle ṭukṛe abhī muṅh meṅ the ki Rab kā ġhazab un par ān paṛā, aur us ne un meṅ saḳht wabā phailne dī. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Chunāṅche maqām kā nām Qabrot-hattāwā yānī ‘Lālach kī Qabreṅ’ rakhā gayā, kyoṅki wahāṅ unhoṅ ne un logoṅ ko dafn kiyā jo gosht ke lālach meṅ ā gae the. ");
INSERT INTO urdgvr_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Is ke bād Isrāīlī Qabrot-hattāwā se rawānā ho kar Hasīrāt pahuṅch gae. Wahāṅ wuh ḳhaimāzan hue. ");
INSERT INTO urdgvr_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Ek din Mariyam aur Hārūn Mūsā ke ḳhilāf bāteṅ karne lage. Wajah yih thī ki us ne Kūsh kī ek aurat se shādī kī thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Unhoṅ ne pūchhā, “Kyā Rab sirf Mūsā kī mārifat bāt kartā hai? Kyā us ne ham se bhī bāt nahīṅ kī?” Rab ne un kī yih bāteṅ sunīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Lekin Mūsā nihāyat halīm thā. Duniyā meṅ us jaisā halīm koī nahīṅ thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Achānak Rab Mūsā, Hārūn aur Mariyam se muḳhātib huā, “Tum tīnoṅ bāhar nikal kar mulāqāt ke ḳhaime ke pās āo.” Tīnoṅ wahāṅ pahuṅche. ");
INSERT INTO urdgvr_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Tab Rab bādal ke satūn meṅ utar kar mulāqāt ke ḳhaime ke darwāze par khaṛā huā. Us ne Hārūn aur Mariyam ko bulāyā to donoṅ āe. ");
INSERT INTO urdgvr_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Us ne kahā, “Merī bāt suno. Jab tumhāre darmiyān nabī hotā hai to maiṅ apne āp ko royā meṅ us par zāhir kartā hūṅ yā ḳhāb meṅ us se muḳhātib hotā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Lekin mere ḳhādim Mūsā kī aur bāt hai. Use maiṅ ne apne pūre gharāne par muqarrar kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Us se maiṅ rūbarū hamkalām hotā hūṅ. Us se maiṅ muammoṅ ke zariye nahīṅ balki sāf sāf bāt kartā hūṅ. Wuh Rab kī sūrat deḳhtā hai. To phir tum mere ḳhādim ke ḳhilāf bāteṅ karne se kyoṅ na ḍare?” ");
INSERT INTO urdgvr_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Rab kā ġhazab un par ān paṛā, aur wuh chalā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Jab bādal kā satūn ḳhaime se dūr huā to Mariyam kī jild barf kī mānind safed thī. Wuh koṛh kā shikār ho gaī thī. Hārūn us kī taraf muṛā to us kī hālat dekhī ");
INSERT INTO urdgvr_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","aur Mūsā se kahā, “Mere āqā, mehrbānī karke hameṅ is gunāh kī sazā na deṅ jo hamārī hamāqat ke bāis sarzad huā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Mariyam ko is hālat meṅ na chhoṛeṅ. Wuh to aise bachche kī mānind hai jo murdā paidā huā ho, jis ke jism kā ādhā hissā gal chukā ho.” ");
INSERT INTO urdgvr_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Tab Mūsā ne pukār kar Rab se kahā, “Ai Allāh, mehrbānī karke use shafā de.” ");
INSERT INTO urdgvr_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Rab ne jawāb meṅ Mūsā se kahā, “Agar Mariyam kā bāp us ke muṅh par thūktā to kyā wuh pūre hafte tak sharm mahsūs na kartī? Use ek hafte ke lie ḳhaimāgāh ke bāhar band rakh. Is ke bād use wāpas lāyā jā saktā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Chunāṅche Mariyam ko ek hafte ke lie ḳhaimāgāh ke bāhar band rakhā gayā. Log us waqt tak safr ke lie rawānā na hue jab tak use wāpas na lāyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Jab wuh wāpas āī to Isrāīlī Hasīrāt se rawānā ho kar Fārān ke registān meṅ ḳhaimāzan hue. ");
INSERT INTO urdgvr_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Phir Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Kuchh ādmī Mulk-e-Kanān kā jāyzā lene ke lie bhej de, kyoṅki maiṅ use Isrāīliyoṅ ko dene ko hūṅ. Har qabīle meṅ se ek rāhnumā ko chun kar bhej de.” ");
INSERT INTO urdgvr_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Mūsā ne Rab ke kahne par unheṅ Dasht-e-Fārān se bhejā. Sab Isrāīlī rāhnumā the. ");
INSERT INTO urdgvr_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Un ke nām yih haiṅ: Rūbin ke qabīle se Sammua bin Zakkūr, ");
INSERT INTO urdgvr_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Shamāūn ke qabīle se Sāfat bin Horī, ");
INSERT INTO urdgvr_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yahūdāh ke qabīle se Kālib bin Yafunnā, ");
INSERT INTO urdgvr_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Ishkār ke qabīle se Ijāl bin Yūsuf, ");
INSERT INTO urdgvr_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Ifrāīm ke qabīle se Hosea bin Nūn, ");
INSERT INTO urdgvr_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Binyamīn ke qabīle se Faltī bin Rafū, ");
INSERT INTO urdgvr_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zabūlūn ke qabīle se Jaddiyel bin Sodī, ");
INSERT INTO urdgvr_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Yūsuf ke beṭe Manassī ke qabīle se Jiddī bin Sūsī, ");
INSERT INTO urdgvr_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dān ke qabīle se Ammiyel bin Jamallī, ");
INSERT INTO urdgvr_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Āshar ke qabīle se Satūr bin Mīkāel, ");
INSERT INTO urdgvr_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Naftālī ke qabīle se Naḳhbī bin Wufsī, ");
INSERT INTO urdgvr_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Jad ke qabīle se Jiyuel bin Mākī. ");
INSERT INTO urdgvr_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Mūsā ne inhīṅ bārah ādmiyoṅ ko mulk kā jāyzā lene ke lie bhejā. Us ne Hosea kā nām Yashua yānī ‘Rab Najāt Hai’ meṅ badal diyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Unheṅ ruḳhsat karne se pahle us ne kahā, “Dasht-e-Najab se guzar kar pahāṛī ilāqe tak pahuṅcho. ");
INSERT INTO urdgvr_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Mālūm karo ki yih kis tarah kā mulk hai aur us ke bāshinde kaise haiṅ. Kyā wuh tāqatwar haiṅ yā kamzor, tādād meṅ kam haiṅ yā zyādā? ");
INSERT INTO urdgvr_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Jis mulk meṅ wuh baste haiṅ kyā wuh achchhā hai ki nahīṅ? Wuh kis qism ke shahroṅ meṅ rahte haiṅ? Kyā un kī chārdīwāriyāṅ haiṅ ki nahīṅ? ");
INSERT INTO urdgvr_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Mulk kī zamīn zarḳhez hai yā banjar? Us meṅ daraḳht haiṅ ki nahīṅ? Aur jurrat karke mulk kā kuchh phal chun kar le āo.” Us waqt pahle angūr pak gae the. ");
INSERT INTO urdgvr_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Chunāṅche in ādmiyoṅ ne safr karke Dasht-e-Sīn se Rahob tak mulk kā jāyzā liyā. Rahob Labo-hamāt ke qarīb hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Wuh Dasht-e-Najab se guzar kar Habrūn pahuṅche jahāṅ Anāq ke beṭe Aḳhīmān, Sīsī aur Talmī rahte the. (Habrūn ko Misr ke shahr Zuan se sāt sāl pahle tāmīr kiyā gayā thā.) ");
INSERT INTO urdgvr_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Jab wuh Wādī-e-Iskāl tak pahuṅche to unhoṅ ne ek ḍālī kāṭ lī jis par angūr kā guchchhā lagā huā thā. Do ādmiyoṅ ne yih angūr, kuchh anār aur kuchh anjīr lāṭhī par laṭkāe aur use uṭhā kar chal paṛe. ");
INSERT INTO urdgvr_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Us jagah kā nām us guchchhe ke sabab se jo Isrāīliyoṅ ne wahāṅ se kāṭ liyā Iskāl yānī Guchchhā rakhā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Chālīs din tak mulk kā khoj lagāte lagāte wuh lauṭ āe. ");
INSERT INTO urdgvr_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Wuh Mūsā, Hārūn aur Isrāīl kī pūrī jamāt ke pās āe jo Dasht-e-Fārān meṅ Qādis kī jagah par intazār kar rahe the. Wahāṅ unhoṅ ne sab kuchh batāyā jo unhoṅ ne mālūm kiyā thā aur unheṅ wuh phal dikhāe jo le kar āe the. ");
INSERT INTO urdgvr_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Unhoṅ ne Mūsā ko riporṭ dī, “Ham us mulk meṅ gae jahāṅ āp ne hameṅ bhejā thā. Wāqaī us mulk meṅ dūdh aur shahd kī kasrat hai. Yahāṅ hamāre pās us ke kuchh phal bhī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Lekin us ke bāshinde tāqatwar haiṅ. Un ke shahroṅ kī fasīleṅ haiṅ, aur wuh nihāyat baṛe haiṅ. Ham ne wahāṅ Anāq kī aulād bhī dekhī. ");
INSERT INTO urdgvr_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amālīqī Dasht-e-Najab meṅ rahte haiṅ jabki Hittī, Yabūsī aur Amorī pahāṛī ilāqe meṅ ābād haiṅ. Kanānī sāhilī ilāqe aur Dariyā-e-Yardan ke kināre kināre baste haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kālib ne Mūsā ke sāmne jamāshudā logoṅ ko ishārā kiyā ki wuh ḳhāmosh ho jāeṅ. Phir us ne kahā, “Āeṅ, ham mulk meṅ dāḳhil ho jāeṅ aur us par qabzā kar leṅ, kyoṅki ham yaqīnan yih karne ke qābil haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Lekin dūsre ādmiyoṅ ne jo us ke sāth mulk ko deḳhne gae the kahā, “Ham un logoṅ par hamlā nahīṅ kar sakte, kyoṅki wuh ham se tāqatwar haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Unhoṅ ne Isrāīliyoṅ ke darmiyān us mulk ke bāre meṅ ġhalat afwāheṅ phailāīṅ jis kī taftīsh unhoṅ ne kī thī. Unhoṅ ne kahā, “Jis mulk meṅ se ham guzare tāki us kā jāyzā leṅ wuh apne bāshindoṅ ko haṛap kar letā hai. Jo bhī us meṅ rahtā hai nihāyat darāzqad hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ham ne wahāṅ dewqāmat afrād bhī dekhe. (Anāq ke beṭe dewqāmat ke afrād kī aulād the.) Un ke sāmne ham apne āp ko ṭiḍḍī jaisā mahsūs kar rahe the, aur ham un kī nazar meṅ aise the bhī.” ");
INSERT INTO urdgvr_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Us rāt tamām log chīḳheṅ mār mār kar rote rahe. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Sab Mūsā aur Hārūn ke ḳhilāf buṛbuṛāne lage. Pūrī jamāt ne un se kahā, “Kāsh ham Misr yā is registān meṅ mar gae hote! ");
INSERT INTO urdgvr_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Rab hameṅ kyoṅ us mulk meṅ le jā rahā hai? Kyā is lie ki dushman hameṅ talwār se qatl kare aur hamāre bāl-bachchoṅ ko lūṭ le? Kyā behtar nahīṅ hogā ki ham Misr wāpas jāeṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Unhoṅ ne ek dūsre se kahā, “Āo, ham rāhnumā chun kar Misr wāpas chale jāeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Tab Mūsā aur Hārūn pūrī jamāt ke sāmne muṅh ke bal gire. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Lekin Yashua bin Nūn aur Kālib bin Yafunnā bāqī das jāsūsoṅ se farq the. Pareshānī ke ālam meṅ unhoṅ ne apne kapṛe phāṛ kar ");
INSERT INTO urdgvr_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","pūrī jamāt se kahā, “Jis mulk meṅ se ham guzare aur jis kī taftīsh ham ne kī wuh nihāyat hī achchhā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Agar Rab ham se ḳhush hai to wuh zarūr hameṅ us mulk meṅ le jāegā jis meṅ dūdh aur shahd kī kasrat hai. Wuh hameṅ zarūr yih mulk degā. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Rab se baġhāwat mat karnā. Us mulk ke rahne wāloṅ se na ḍareṅ. Ham unheṅ haṛap kar jāeṅge. Un kī panāh un se jātī rahī hai jabki Rab hamāre sāth hai. Chunāṅche un se mat ḍareṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Yih sun kar pūrī jamāt unheṅ sangsār karne ke lie taiyār huī. Lekin achānak Rab kā jalāl mulāqāt ke ḳhaime par zāhir huā, aur tamām Isrāīliyoṅ ne use dekhā. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Rab ne Mūsā se kahā, “Yih log mujhe kab tak haqīr jāneṅge? Wuh kab tak mujh par īmān rakhne se inkār kareṅge agarche maiṅ ne un ke darmiyān itne mojize kie haiṅ? ");
INSERT INTO urdgvr_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Maiṅ unheṅ wabā se mār ḍālūṅgā aur unheṅ rū-e-zamīn par se miṭā dūṅgā. Un kī jagah maiṅ tujh se ek qaum banāūṅgā jo un se baṛī aur tāqatwar hogī.” ");
INSERT INTO urdgvr_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Lekin Mūsā ne Rab se kahā, “Phir Misrī yih sun leṅge! Kyoṅki tū ne apnī qudrat se in logoṅ ko Misr se nikāl kar yahāṅ tak pahuṅchāyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Misrī yih bāt Kanān ke bāshindoṅ ko batāeṅge. Yih log pahle se sun chuke haiṅ ki Rab is qaum ke sāth hai, ki tujhe rūbarū dekhā jātā hai, ki terā bādal un ke ūpar ṭhahrā rahtā hai, aur ki tū din ke waqt bādal ke satūn meṅ aur rāt ko āg ke satūn meṅ in ke āge āge chaltā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Agar tū ek dam is pūrī qaum ko tabāh kar ḍāle to bāqī qaumeṅ yih sun kar kaheṅgī, ");
INSERT INTO urdgvr_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Rab in logoṅ ko us mulk meṅ le jāne ke qābil nahīṅ thā jis kā wādā us ne un se qasam khā kar kiyā thā. Isī lie us ne unheṅ registān meṅ halāk kar diyā.’ ");
INSERT INTO urdgvr_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ai Rab, ab apnī qudrat yoṅ zāhir kar jis tarah tū ne farmāyā hai. Kyoṅki tū ne kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Rab tahammul aur shafqat se bharpūr hai. Wuh gunāh aur nāfarmānī muāf kartā hai, lekin har ek ko us kī munāsib sazā bhī detā hai. Jab wālidain gunāh kareṅ to un kī aulād ko bhī tīsrī aur chauthī pusht tak sazā ke natāyj bhugatne paṛeṅge.’ ");
INSERT INTO urdgvr_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","In logoṅ kā qusūr apnī azīm shafqat ke mutābiq muāf kar. Unheṅ us tarah muāf kar jis tarah tū unheṅ Misr se nikalte waqt ab tak muāf kartā rahā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Rab ne jawāb diyā, “Tere kahne par maiṅ ne unheṅ muāf kar diyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Is ke bāwujūd merī hayāt kī qasam aur mere jalāl kī qasam jo pūrī duniyā ko māmūr kartā hai, ");
INSERT INTO urdgvr_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","in logoṅ meṅ se koī bhī us mulk meṅ dāḳhil nahīṅ hogā. Unhoṅ ne merā jalāl aur mere mojize dekhe haiṅ jo maiṅ ne Misr aur registān meṅ kar dikhāe haiṅ. To bhī unhoṅ ne das dafā mujhe āzmāyā aur merī na sunī. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Un meṅ se ek bhī us mulk ko nahīṅ dekhegā jis kā wādā maiṅ ne qasam khā kar un ke bāpdādā se kiyā thā. Jis ne bhī mujhe haqīr jānā hai wuh kabhī use nahīṅ dekhegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Sirf merā ḳhādim Kālib muḳhtalif hai. Us kī rūh farq hai. Wuh pūre dil se merī pairawī kartā hai, is lie maiṅ use us mulk meṅ le jāūṅgā jis meṅ us ne safr kiyā hai. Us kī aulād mulk mīrās meṅ pāegī. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Lekin filhāl Amālīqī aur Kanānī us kī wādiyoṅ meṅ ābād raheṅge. Chunāṅche kal muṛ kar wāpas chalo. Registān meṅ Bahr-e-Qulzum kī taraf rawānā ho jāo.” ");
INSERT INTO urdgvr_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Rab ne Mūsā aur Hārūn se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Yih sharīr jamāt kab tak mere ḳhilāf buṛbuṛātī rahegī? Un ke gile-shikwe mujh tak pahuṅch gae haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Is lie unheṅ batāo, ‘Rab farmātā hai ki merī hayāt kī qasam, maiṅ tumhāre sāth wuhī kuchh karūṅga jo tum ne mere sāmne kahā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Tum is registān meṅ mar kar yihīṅ paṛe rahoge, har ek jo 20 sāl yā is se zāyd kā hai, jo mardumshumārī meṅ ginā gayā aur jo mere ḳhilāf buṛbuṛāyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Go maiṅ ne hāth uṭhā kar qasam khāī thī ki maiṅ tujhe us meṅ basāūṅgā tum meṅ se koī bhī us mulk meṅ dāḳhil nahīṅ hogā. Sirf Kālib bin Yafunnā aur Yashua bin Nūn dāḳhil hoṅge. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Tum ne kahā thā ki dushman hamāre bachchoṅ ko lūṭ leṅge. Lekin unhīṅ ko maiṅ us mulk meṅ le jāūṅgā jise tum ne radd kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Lekin tum ḳhud dāḳhil nahīṅ hoge. Tumhārī lāsheṅ is registān meṅ paṛī raheṅgī. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Tumhāre bachche 40 sāl tak yahāṅ registān meṅ gallābān hoṅge. Unheṅ tumhārī bewafāī ke sabab se us waqt tak taklīf uṭhānī paṛegī jab tak tum meṅ se āḳhirī shaḳhs mar na gayā ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Tum ne chālīs din ke daurān us mulk kā jāyzā liyā. Ab tumheṅ chālīs sāl tak apne gunāhoṅ kā natījā bhugatnā paṛegā. Tab tumheṅ patā chalegā ki is kā kyā matlab hai ki maiṅ tumhārī muḳhālafat kartā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Maiṅ, Rab ne yih bāt farmāī hai. Maiṅ yaqīnan yih sab kuchh us sārī sharīr jamāt ke sāth karūṅga jis ne mil kar merī muḳhālafat kī hai. Isī registān meṅ wuh ḳhatm ho jāeṅge, yihīṅ mar jāeṅge.’” ");
INSERT INTO urdgvr_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Jin ādmiyoṅ ko Mūsā ne mulk kā jāyzā lene ke lie bhejā thā, Rab ne unheṅ fauran mohlak wabā se mār ḍālā, kyoṅki un ke ġhalat afwāheṅ phailāne se pūrī jamāt buṛbuṛāne lagī thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Sirf Yashua bin Nūn aur Kālib bin Yafunnā zindā rahe. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Jab Mūsā ne Rab kī yih bāteṅ Isrāīliyoṅ ko batāīṅ to wuh ḳhūb mātam karne lage. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Aglī subah-sawere wuh uṭhe aur yih kahte hue ūṅche pahāṛī ilāqe ke lie rawānā hue ki ham se ġhaltī huī hai, lekin ab ham hāzir haiṅ aur us jagah kī taraf jā rahe haiṅ jis kā zikr Rab ne kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Lekin Mūsā ne kahā, “Tum kyoṅ Rab kī ḳhilāfwarzī kar rahe ho? Tum kāmyāb nahīṅ hoge. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Wahāṅ na jāo, kyoṅki Rab tumhāre sāth nahīṅ hai. Tum dushmanoṅ ke hāthoṅ shikast khāoge, ");
INSERT INTO urdgvr_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","kyoṅki wahāṅ Amālīqī aur Kanānī tumhārā sāmnā kareṅge. Chūṅki tum ne apnā muṅh Rab se pher liyā hai is lie wuh tumhāre sāth nahīṅ hogā, aur dushman tumheṅ talwār se mār ḍālegā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","To bhī wuh apne ġhurūr meṅ jurrat karke ūṅche pahāṛī ilāqe kī taraf baṛhe, hālāṅki na Mūsā aur na ahd ke sandūq hī ne ḳhaimāgāh ko chhoṛā. ");
INSERT INTO urdgvr_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Phir us pahāṛī ilāqe meṅ rahne wāle Amālīqī aur Kanānī un par ān paṛe aur unheṅ mārte mārte Hurmā tak titar-bitar kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Isrāīliyoṅ ko batānā ki jab tum us mulk meṅ dāḳhil hoge jo maiṅ tumheṅ dūṅgā ");
INSERT INTO urdgvr_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","4","to jalne wālī qurbāniyāṅ yoṅ pesh karnā: Agar tum apne gāy-bailoṅ yā bheṛ-bakriyoṅ meṅ se aisī qurbānī pesh karnā chāho jis kī ḳhushbū Rab ko pasand ho to sāth sāth ḍeṛh kilogrām behtarīn maidā bhī pesh karo jo ek liṭar zaitūn ke tel ke sāth milāyā gayā ho. Is meṅ koī farq nahīṅ ki yih bhasm hone wālī qurbānī, mannat kī qurbānī, dilī ḳhushī kī qurbānī yā kisī īd kī qurbānī ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Har bheṛ ko pesh karte waqt ek liṭar mai bhī mai kī nazar ke taur par pesh karnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Jab menḍhā qurbān kiyā jāe to 3 kilogrām behtarīn maidā bhī sāth pesh karnā jo sawā liṭar tel ke sāth milāyā gayā ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Sawā liṭar mai bhī mai kī nazar ke taur par pesh kī jāe. Aisī qurbānī kī ḳhushbū Rab ko pasand āegī. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Agar tū Rab ko bhasm hone wālī qurbānī, mannat kī qurbānī yā salāmatī kī qurbānī ke taur par jawān bail pesh karnā chāhe ");
INSERT INTO urdgvr_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","to us ke sāth sāṛhe 4 kilogrām behtarīn maidā bhī pesh karnā jo do liṭar tel ke sāth milāyā gayā ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Do liṭar mai bhī mai kī nazar ke taur par pesh kī jāe. Aisī qurbānī kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Lāzim hai ki jab bhī kisī gāy, bail, bheṛ, menḍhe, bakrī yā bakre ko chaṛhāyā jāe to aisā hī kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Agar ek se zāyd jānwaroṅ ko qurbān karnā hai to har ek ke lie muqarrarā ġhallā aur mai kī nazareṅ bhī sāth hī pesh kī jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Lāzim hai ki har desī Isrāīlī jalne wālī qurbāniyāṅ pesh karte waqt aisā hī kare. Phir un kī ḳhushbū Rab ko pasand āegī. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Yih bhī lāzim hai ki Isrāīl meṅ ārizī yā mustaqil taur par rahne wāle pardesī in usūloṅ ke mutābiq apnī qurbāniyāṅ chaṛhāeṅ. Phir un kī ḳhushbū Rab ko pasand āegī. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Mulk-e-Kanān meṅ rahne wāle tamām logoṅ ke lie pābandiyāṅ ek jaisī haiṅ, ḳhāh wuh desī hoṅ yā pardesī, kyoṅki Rab kī nazar meṅ pardesī tumhāre barābar hai. Yih tumhāre aur tumhārī aulād ke lie dāymī usūl hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Tumhāre aur tumhāre sāth rahne wāle pardesī ke lie ek hī sharīat hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Isrāīliyoṅ ko batānā ki jab tum us mulk meṅ dāḳhil hoge jis meṅ maiṅ tumheṅ le jā rahā hūṅ ");
INSERT INTO urdgvr_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","aur wahāṅ kī paidāwār khāoge to pahle us kā ek hissā uṭhāne wālī qurbānī ke taur par Rab ko pesh karnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Fasal ke pahle ḳhālis āṭe meṅ se mere lie ek roṭī banā kar uṭhāne wālī qurbānī ke taur par pesh karo. Wuh gāhne kī jagah kī taraf se Rab ke lie uṭhāne wālī qurbānī hogī. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Apnī fasal ke pahle ḳhālis āṭe meṅ se yih qurbānī pesh kiyā karo. Yih usūl hameshā tak lāgū rahe. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Ho saktā hai ki ġhairirādī taur par tum se ġhaltī huī hai aur tum ne un ahkām par pūre taur par amal nahīṅ kiyā jo Rab Mūsā ko de chukā hai ");
INSERT INTO urdgvr_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","yā jo wuh āne wālī nasloṅ ko degā. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Agar jamāt is bāt se nāwāqif thī aur ġhairirādī taur par us se ġhaltī huī to phir pūrī jamāt ek jawān bail bhasm hone wālī qurbānī ke taur par pesh kare. Sāth hī wuh muqarrarā ġhallā aur mai kī nazareṅ bhī pesh kare. Is kī ḳhushbū Rab ko pasand hogī. Is ke alāwā jamāt gunāh kī qurbānī ke lie ek bakrā pesh kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Imām Isrāīl kī pūrī jamāt kā kaffārā de to unheṅ muāfī milegī, kyoṅki un kā gunāh ġhairirādī thā aur unhoṅ ne Rab ko bhasm hone wālī qurbānī aur gunāh kī qurbānī pesh kī hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Isrāīliyoṅ kī pūrī jamāt ko pardesiyoṅ samet muāfī milegī, kyoṅki gunāh ġhairirādī thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Agar sirf ek shaḳhs se ġhairirādī taur par gunāh huā ho to gunāh kī qurbānī ke lie wuh ek yaksālā bakrī pesh kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Imām Rab ke sāmne us shaḳhs kā kaffārā de. Jab kaffārā de diyā gayā to use muāfī hāsil hogī. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Yihī usūl pardesī par bhī lāgū hai. Agar us se ġhairirādī taur par gunāh huā ho to wuh muāfī hāsil karne ke lie wuhī kuchh kare jo Isrāīlī ko karnā hotā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Lekin agar koī desī yā pardesī jān-būjh kar gunāh kartā hai to aisā shaḳhs Rab kī ihānat kartā hai, is lie lāzim hai ki use us kī qaum meṅ se miṭāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Us ne Rab kā kalām haqīr jān kar us ke ahkām toṛ ḍāle haiṅ, is lie use zarūr qaum meṅ se miṭāyā jāe. Wuh apne gunāh kā zimmedār hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Jab Isrāīlī registān meṅ se guzar rahe the to ek ādmī ko pakaṛā gayā jo hafte ke din lakaṛiyāṅ jamā kar rahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Jinhoṅ ne use pakaṛā thā wuh use Mūsā, Hārūn aur pūrī jamāt ke pās le āe. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Chūṅki sāf mālūm nahīṅ thā ki us ke sāth kyā kiyā jāe is lie unhoṅ ne use giriftār kar liyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Phir Rab ne Mūsā se kahā, “Is ādmī ko zarūr sazā-e-maut dī jāe. Pūrī jamāt use ḳhaimāgāh ke bāhar le jā kar sangsār kare.” ");
INSERT INTO urdgvr_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Chunāṅche jamāt ne use ḳhaimāgāh ke bāhar le jā kar sangsār kiyā, jis tarah Rab ne Mūsā ko hukm diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Isrāīliyoṅ ko batānā ki tum aur tumhāre bād kī nasleṅ apne libās ke kināroṅ par phundne lagāeṅ. Har phundnā ek qirmizī ḍorī se libās ke sāth lagā ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","In phundnoṅ ko dekh kar tumheṅ Rab ke tamām ahkām yād raheṅge aur tum un par amal karoge. Phir tum apne diloṅ aur āṅkhoṅ kī ġhalat ḳhāhishoṅ ke pīchhe nahīṅ paṛoge balki zinākārī se dūr rahoge. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Phir tum mere ahkām ko yād karke un par amal karoge aur apne Ḳhudā ke sāmne maḳhsūs-o-muqaddas rahoge. ");
INSERT INTO urdgvr_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Maiṅ Rab tumhārā Ḳhudā hūṅ jo tumheṅ Misr se nikāl lāyā tāki tumhārā Ḳhudā hūṅ. Maiṅ Rab tumhārā Ḳhudā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","Ek din Qorah bin Izhār Mūsā ke ḳhilāf uṭhā. Wuh Lāwī ke qabīle kā Qihātī thā. Us ke sāth Rūbin ke qabīle ke tīn ādmī the, Iliyāb ke beṭe Dātan aur Abīrām aur On bin Palat. Un ke sāth 250 aur ādmī bhī the jo jamāt ke sardār aur asar-o-rasūḳh wāle the, aur jo kaunsal ke lie chune gae the. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Wuh mil kar Mūsā aur Hārūn ke pās ā kar kahne lage, “Āp ham se ziyādatī kar rahe haiṅ. Pūrī jamāt maḳhsūs-o-muqaddas hai, aur Rab us ke darmiyān hai. To phir āp apne āp ko kyoṅ Rab kī jamāt se baṛh kar samajhte haiṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Yih sun kar Mūsā muṅh ke bal girā. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Phir us ne Qorah aur us ke tamām sāthiyoṅ se kahā, “Kal subah Rab zāhir karegā ki kaun us kā bandā aur kaun maḳhsūs-o-muqaddas hai. Usī ko wuh apne pās āne degā. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ai Qorah, kal apne tamām sāthiyoṅ ke sāth baḳhūrdān le kar ");
INSERT INTO urdgvr_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Rab ke sāmne un meṅ angāre aur baḳhūr ḍālo. Jis ādmī ko Rab chunegā wuh maḳhsūs-o-muqaddas hogā. Ab tum Lāwī ḳhud ziyādatī kar rahe ho.” ");
INSERT INTO urdgvr_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mūsā ne Qorah se bāt jārī rakhī, “Ai Lāwī kī aulād, suno! ");
INSERT INTO urdgvr_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Kyā tumhārī nazar meṅ yih koī chhoṭī bāt hai ki Rab tumheṅ Isrāīlī jamāt ke bāqī logoṅ se alag karke apne qarīb le āyā tāki tum Rab ke maqdis meṅ aur jamāt ke sāmne khaṛe ho kar un kī ḳhidmat karo? ");
INSERT INTO urdgvr_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Wuh tujhe aur tere sāthī Lāwiyoṅ ko apne qarīb lāyā hai. Lekin ab tum imām kā ohdā bhī apnānā chāhte ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Apne sāthiyoṅ se mil kar tū ne Hārūn kī nahīṅ balki Rab kī muḳhālafat kī hai. Kyoṅki Hārūn kaun hai ki tum us ke ḳhilāf buṛbuṛāo?” ");
INSERT INTO urdgvr_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Phir Mūsā ne Iliyāb ke beṭoṅ Dātan aur Abīrām ko bulāyā. Lekin unhoṅ ne kahā, “Ham nahīṅ āeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Āp hameṅ ek aise mulk se nikāl lāe haiṅ jahāṅ dūdh aur shahd kī kasrat hai tāki ham registān meṅ halāk ho jāeṅ. Kyā yih kāfī nahīṅ hai? Kyā ab āp ham par hukūmat bhī karnā chāhte haiṅ? ");
INSERT INTO urdgvr_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Na āp ne hameṅ aise mulk meṅ pahuṅchāyā jis meṅ dūdh aur shahd kī kasrat hai, na hameṅ khetoṅ aur angūr ke bāġhoṅ ke wāris banāyā hai. Kyā āp in ādmiyoṅ kī āṅkheṅ nikāl ḍāleṅge? Nahīṅ, ham hargiz nahīṅ āeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Tab Mūsā nihāyat ġhusse huā. Us ne Rab se kahā, “Un kī qurbānī ko qabūl na kar. Maiṅ ne ek gadhā tak un se nahīṅ liyā, na maiṅ ne un meṅ se kisī se burā sulūk kiyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Qorah se us ne kahā, “Kal tum aur tumhāre sāthī Rab ke sāmne hāzir ho jāo. Hārūn bhī āegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Har ek apnā baḳhūrdān le kar use Rab ko pesh kare.” ");
INSERT INTO urdgvr_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Chunāṅche har ādmī ne apnā baḳhūrdān le kar us meṅ angāre aur baḳhūr ḍāl diyā. Phir sab Mūsā aur Hārūn ke sāth mulāqāt ke ḳhaime ke darwāze par khaṛe hue. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Qorah ne pūrī jamāt ko darwāze par Mūsā aur Hārūn ke muqābale meṅ jamā kiyā thā. Achānak pūrī jamāt par Rab kā jalāl zāhir huā. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Rab ne Mūsā aur Hārūn se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Is jamāt se alag ho jāo tāki maiṅ ise fauran halāk kar dūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Mūsā aur Hārūn muṅh ke bal gire aur bol uṭhe, “Ai Allāh, tū tamām jānoṅ kā Ḳhudā hai. Kyā terā ġhazab ek hī ādmī ke gunāh ke sabab se pūrī jamāt par ān paṛegā?” ");
INSERT INTO urdgvr_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Tab Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Jamāt ko batā de ki Qorah, Dātan aur Abīrām ke ḍeroṅ se dūr ho jāo.” ");
INSERT INTO urdgvr_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mūsā uṭh kar Dātan aur Abīrām ke pās gayā, aur Isrāīl ke buzurg us ke pīchhe chale. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Us ne jamāt ko āgāh kiyā, “In sharīroṅ ke ḳhaimoṅ se dūr ho jāo! Jo kuchh bhī un ke pās hai use na chhuo, warnā tum bhī un ke sāth tabāh ho jāoge jab wuh apne gunāhoṅ ke bāis halāk hoṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Tab bāqī log Qorah, Dātan aur Abīrām ke ḍeroṅ se dūr ho gae. Dātan aur Abīrām apne bāl-bachchoṅ samet apne ḳhaimoṅ se nikal kar bāhar khaṛe the. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Mūsā ne kahā, “Ab tumheṅ patā chalegā ki Rab ne mujhe yih sab kuchh karne ke lie bhejā hai. Maiṅ apnī nahīṅ balki us kī marzī pūrī kar rahā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Agar yih log dūsroṅ kī tarah tabaī maut mareṅ to phir Rab ne mujhe nahīṅ bhejā. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Lekin agar Rab aisā kām kare jo pahle kabhī nahīṅ huā aur zamīn apnā muṅh khol kar unheṅ aur un kā pūrā māl haṛap kar le aur unheṅ jīte-jī dafnā de to is kā matlab hogā ki in ādmiyoṅ ne Rab ko haqīr jānā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Yih bāt kahte hī un ke nīche kī zamīn phaṭ gaī. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Us ne apnā muṅh khol kar unheṅ, un ke ḳhāndānoṅ ko, Qorah ke tamām logoṅ ko aur un kā sārā sāmān haṛap kar liyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Wuh apnī pūrī milkiyat samet jīte-jī dafn ho gae. Zamīn un ke ūpar wāpas ā gaī. Yoṅ unheṅ jamāt se nikālā gayā aur wuh halāk ho gae. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Un kī chīḳheṅ sun kar un ke irdgird khaṛe tamām Isrāīlī bhāg uṭhe, kyoṅki unhoṅ ne sochā, “Aisā na ho ki zamīn hameṅ bhī nigal le.” ");
INSERT INTO urdgvr_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Usī lamhe Rab kī taraf se āg utar āī aur un 250 ādmiyoṅ ko bhasm kar diyā jo baḳhūr pesh kar rahe the. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Hārūn Imām ke beṭe Iliyazar ko ittalā de ki wuh baḳhūrdānoṅ ko rākh meṅ se nikāl kar rakhe. Un ke angāre wuh dūr phaiṅke. Baḳhūrdānoṅ ko rakhne kā sabab yih hai ki ab wuh maḳhsūs-o-muqaddas haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Log un ādmiyoṅ ke yih baḳhūrdān le leṅ jo apne gunāh ke bāis jāṅ bahaq ho gae. Wuh unheṅ kūṭ kar un se chādareṅ banāeṅ aur unheṅ jalne wālī qurbāniyoṅ kī qurbāngāh par chaṛhāeṅ. Kyoṅki wuh Rab ko pesh kie gae haiṅ, is lie wuh maḳhsūs-o-muqaddas haiṅ. Yoṅ wuh Isrāīliyoṅ ke lie ek nishān raheṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Chunāṅche Iliyazar Imām ne pītal ke yih baḳhūrdān jamā kie jo bhasm kie hue ādmiyoṅ ne Rab ko pesh kie the. Phir logoṅ ne unheṅ kūṭ kar un se chādareṅ banāīṅ aur unheṅ qurbāngāh par chaṛhā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Hārūn ne sab kuchh waisā hī kiyā jaisā Rab ne Mūsā kī mārifat batāyā thā. Maqsad yih thā ki baḳhūrdān Isrāīliyoṅ ko yād dilāte raheṅ ki sirf Hārūn kī aulād hī ko Rab ke sāmne ā kar baḳhūr jalāne kī ijāzat hai. Agar koī aur aisā kare to us kā hāl Qorah aur us ke sāthiyoṅ kā-sā hogā. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Agle din Isrāīl kī pūrī jamāt Mūsā aur Hārūn ke ḳhilāf buṛbuṛāne lagī. Unhoṅ ne kahā, “Āp ne Rab kī qaum ko mār ḍālā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Lekin jab wuh Mūsā aur Hārūn ke muqābale meṅ jamā hue aur mulāqāt ke ḳhaime kā ruḳh kiyā to achānak us par bādal chhā gayā aur Rab kā jalāl zāhir huā. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Phir Mūsā aur Hārūn mulāqāt ke ḳhaime ke sāmne āe, ");
INSERT INTO urdgvr_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","aur Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Is jamāt se nikal jāo tāki maiṅ ise fauran halāk kar dūṅ.” Yih sun kar donoṅ muṅh ke bal gire. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Mūsā ne Hārūn se kahā, “Apnā baḳhūrdān le kar us meṅ qurbāngāh ke angāre aur baḳhūr ḍāleṅ. Phir bhāg kar jamāt ke pās chale jāeṅ tāki un kā kaffārā deṅ. Jaldī kareṅ, kyoṅki Rab kā ġhazab un par ṭūṭ paṛā hai. Wabā phailne lagī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Hārūn ne aisā hī kiyā. Wuh dauṛ kar jamāt ke bīch meṅ gayā. Logoṅ meṅ wabā shurū ho chukī thī, lekin Hārūn ne Rab ko baḳhūr pesh karke un kā kaffārā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Wuh zindoṅ aur murdoṅ ke bīch meṅ khaṛā huā to wabā ruk gaī. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","To bhī 14,700 afrād wabā se mar gae. Is meṅ wuh shāmil nahīṅ haiṅ jo Qorah ke sabab se mar gae the. ");
INSERT INTO urdgvr_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Jab wabā ruk gaī to Hārūn Mūsā ke pās wāpas āyā jo ab tak mulāqāt ke ḳhaime ke darwāze par khaṛā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Isrāīliyoṅ se bāt karke un se 12 lāṭhiyāṅ mangwā le, har qabīle ke sardār se ek lāṭhī. Har lāṭhī par us ke mālik kā nām likhnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Lāwī kī lāṭhī par Hārūn kā nām likhnā, kyoṅki har qabīle ke sardār ke lie ek lāṭhī hogī. ");
INSERT INTO urdgvr_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Phir un ko mulāqāt ke ḳhaime meṅ ahd ke sandūq ke sāmne rakh jahāṅ merī tum se mulāqāt hotī hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Jis ādmī ko maiṅ ne chun liyā hai us kī lāṭhī se koṅpleṅ phūṭ nikleṅgī. Is tarah maiṅ tumhāre ḳhilāf Isrāīliyoṅ kī buṛbuṛāhaṭ ḳhatm kar dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Chunāṅche Mūsā ne Isrāīliyoṅ se bāt kī, aur qabīloṅ ke har sardār ne use apnī lāṭhī dī. In 12 lāṭhiyoṅ meṅ Hārūn kī lāṭhī bhī shāmil thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mūsā ne unheṅ mulāqāt ke ḳhaime meṅ ahd ke sandūq ke sāmne rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Agle din jab wuh mulāqāt ke ḳhaime meṅ dāḳhil huā to us ne dekhā ki Lāwī ke qabīle ke sardār Hārūn kī lāṭhī se na sirf koṅpleṅ phūṭ niklī haiṅ balki phūl aur pake hue bādām bhī lage haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Mūsā tamām lāṭhiyāṅ Rab ke sāmne se bāhar lā kar Isrāīliyoṅ ke pās le āyā, aur unhoṅ ne un kā muāynā kiyā. Phir har ek ne apnī apnī lāṭhī wāpas le lī. ");
INSERT INTO urdgvr_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Rab ne Mūsā se kahā, “Hārūn kī lāṭhī ahd ke sandūq ke sāmne rakh de. Yih bāġhī Isrāīliyoṅ ko yād dilāegī ki wuh apnā buṛbuṛānā band kareṅ, warnā halāk ho jāeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mūsā ne aisā hī kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Lekin Isrāīliyoṅ ne Mūsā se kahā, “Hāy, ham mar jāeṅge. Hāy, ham halāk ho jāeṅge, ham sab halāk ho jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Jo bhī Rab ke maqdis ke qarīb āe wuh mar jāegā. Kyā ham sab hī halāk ho jāeṅge?” ");
INSERT INTO urdgvr_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Rab ne Hārūn se kahā, “Maqdis terī, tere beṭoṅ aur Lāwī ke qabīle kī zimmedārī hai. Agar is meṅ koī ġhaltī ho jāe to tum qusūrwār ṭhahroge. Isī tarah imāmoṅ kī ḳhidmat sirf terī aur tere beṭoṅ kī zimmedārī hai. Agar is meṅ koī ġhaltī ho jāe to tū aur tere beṭe qusūrwār ṭhahreṅge. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Apne qabīle Lāwī ke bāqī ādmiyoṅ ko bhī mere qarīb āne de. Wuh tere sāth mil kar yoṅ hissā leṅ ki wuh terī aur tere beṭoṅ kī ḳhidmat kareṅ jab tum ḳhaime ke sāmne apnī zimmedāriyāṅ nibhāoge. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Terī ḳhidmat aur ḳhaime meṅ ḳhidmat un kī zimmedārī hai. Lekin wuh ḳhaime ke maḳhsūs-o-muqaddas sāmān aur qurbāngāh ke qarīb na jāeṅ, warnā na sirf wuh balki tū bhī halāk ho jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Yoṅ wuh tere sāth mil kar mulāqāt ke ḳhaime ke pūre kām meṅ hissā leṅ. Lekin kisī aur ko aisā karne kī ijāzat nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Sirf tū aur tere beṭe maqdis aur qurbāngāh kī dekh-bhāl kareṅ tāki merā ġhazab dubārā Isrāīliyoṅ par na bhaṛke. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Maiṅ hī ne Isrāīliyoṅ meṅ se tere bhāiyoṅ yānī Lāwiyoṅ ko chun kar tujhe tohfe ke taur par diyā hai. Wuh Rab ke lie maḳhsūs haiṅ tāki ḳhaime meṅ ḳhidmat kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Lekin sirf tū aur tere beṭe imām kī ḳhidmat saranjām deṅ. Maiṅ tumheṅ imām kā ohdā tohfe ke taur par detā hūṅ. Koī aur qurbāngāh aur muqaddas chīzoṅ ke nazdīk na āe, warnā use sazā-e-maut dī jāe.” ");
INSERT INTO urdgvr_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Rab ne Hārūn se kahā, “Maiṅ ne ḳhud muqarrar kiyā hai ki tamām uṭhāne wālī qurbāniyāṅ terā hissā hoṅ. Yih hameshā tak qurbāniyoṅ meṅ se terā aur terī aulād kā hissā haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Tumheṅ muqaddastarīn qurbāniyoṅ kā wuh hissā milnā hai jo jalāyā nahīṅ jātā. Hāṅ, tujhe aur tere beṭoṅ ko wuhī hissā milnā hai, ḳhāh wuh mujhe ġhallā kī nazareṅ, gunāh kī qurbāniyāṅ yā qusūr kī qurbāniyāṅ pesh kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Use muqaddas jagah par khānā. Har mard use khā saktā hai. Ḳhayāl rakh ki wuh maḳhsūs-o-muqaddas hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Maiṅ ne muqarrar kiyā hai ki tamām hilāne wālī qurbāniyoṅ kā uṭhāyā huā hissā terā hai. Yih hameshā ke lie tere aur tere beṭe-beṭiyoṅ kā hissā hai. Tere gharāne kā har fard use khā saktā hai. Shart yih hai ki wuh pāk ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Jab log Rab ko apnī fasloṅ kā pahlā phal pesh kareṅge to wuh terā hī hissā hogā. Maiṅ tujhe zaitūn ke tel, naī mai aur anāj kā behtarīn hissā detā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Fasloṅ kā jo bhī pahlā phal wuh Rab ko pesh kareṅge wuh terā hī hogā. Tere gharāne kā har pāk fard use khā saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Isrāīl meṅ jo bhī chīz Rab ke lie maḳhsūs-o-muqaddas kī gaī hai wuh terī hogī. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Har insān aur har haiwān kā jo pahlauṭhā Rab ko pesh kiyā jātā hai wuh terā hī hai. Lekin lāzim hai ki tū har insān aur har nāpāk jānwar ke pahlauṭhe kā fidyā de kar use chhuṛāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Jab wuh ek māh ke haiṅ to un ke ewaz chāṅdī ke pāṅch sikke denā. (Har sikke kā wazn maqdis ke bāṭoṅ ke mutābiq 11 grām ho.) ");
INSERT INTO urdgvr_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Lekin gāy-bailoṅ aur bheṛ-bakriyoṅ ke pahle bachchoṅ kā fidyā yānī muāwazā na denā. Wuh maḳhsūs-o-muqaddas haiṅ. Un kā ḳhūn qurbāngāh par chhiṛak denā aur un kī charbī jalā denā. Aisī qurbānī Rab ko pasand hogī. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Un kā gosht waise hī tumhāre lie ho, jaise hilāne wālī qurbānī kā Sīnā aur dahnī rān bhī tumhāre lie haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Muqaddas qurbāniyoṅ meṅ se tamām uṭhāne wālī qurbāniyāṅ terā aur tere beṭe-beṭiyoṅ kā hissā haiṅ. Maiṅ ne use hameshā ke lie tujhe diyā hai. Yih namak kā dāymī ahd hai jo maiṅ ne tere aur terī aulād ke sāth qāym kiyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Rab ne Hārūn se kahā, “Tū mīrās meṅ zamīn nahīṅ pāegā. Isrāīl meṅ tujhe koī hissā nahīṅ diyā jāegā, kyoṅki Isrāīliyoṅ ke darmiyān maiṅ hī terā hissā aur terī mīrās hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Apnī paidāwār kā jo daswāṅ hissā Isrāīlī mujhe dete haiṅ wuh maiṅ Lāwiyoṅ ko detā hūṅ. Yih un kī wirāsat hai, jo unheṅ mulāqāt ke ḳhaime meṅ ḳhidmat karne ke badle meṅ miltī hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Ab se Isrāīlī mulāqāt ke ḳhaime ke qarīb na āeṅ, warnā unheṅ apnī ḳhatā kā natījā bardāsht karnā paṛegā aur wuh halāk ho jāeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Sirf Lāwī mulāqāt ke ḳhaime meṅ ḳhidmat kareṅ. Agar is meṅ koī ġhaltī ho jāe to wuhī qusūrwār ṭhahreṅge. Yih ek dāymī usūl hai. Unheṅ Isrāīl meṅ mīrās meṅ zamīn nahīṅ milegī. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Kyoṅki maiṅ ne unheṅ wuhī daswāṅ hissā mīrās ke taur par diyā hai jo Isrāīlī mujhe uṭhāne wālī qurbānī ke taur par pesh karte haiṅ. Is wajah se maiṅ ne un ke bāre meṅ kahā ki unheṅ bāqī Isrāīliyoṅ ke sāth mīrās meṅ zamīn nahīṅ milegī.” ");
INSERT INTO urdgvr_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Lāwiyoṅ ko batānā ki tumheṅ Isrāīliyoṅ kī paidāwār kā daswāṅ hissā milegā. Yih Rab kī taraf se tumhārī wirāsat hogī. Lāzim hai ki tum is kā daswāṅ hissā Rab ko uṭhāne wālī qurbānī ke taur par pesh karo. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Tumhārī yih qurbānī nae anāj yā nae angūr ke ras kī qurbānī ke barābar qarār dī jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Is tarah tum bhī Rab ko Isrāīliyoṅ kī paidāwār ke dasweṅ hisse meṅ se uṭhāne wālī qurbānī pesh karoge. Rab ke lie yih qurbānī Hārūn Imām ko denā. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Jo bhī tumheṅ milā hai us meṅ se sab se achchhā aur muqaddas hissā Rab ko denā. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Jab tum is kā sab se achchhā hissā pesh karoge to use nae anāj yā nae angūr ke ras kī qurbānī ke barābar qarār diyā jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Tum apne gharānoṅ samet is kā bāqī hissā kahīṅ bhī khā sakte ho, kyoṅki yih mulāqāt ke ḳhaime meṅ tumhārī ḳhidmat kā ajr hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Agar tum ne pahle is kā behtarīn hissā pesh kiyā ho to phir ise khāne meṅ tumhārā koī qusūr nahīṅ hogā. Phir Isrāīliyoṅ kī maḳhsūs-o-muqaddas qurbāniyāṅ tum se nāpāk nahīṅ ho jāeṅgī aur tum nahīṅ maroge.” ");
INSERT INTO urdgvr_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Rab ne Mūsā aur Hārūn se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Isrāīliyoṅ ko batānā ki wuh tumhāre pās surḳh rang kī jawān gāy le kar āeṅ. Us meṅ nuqs na ho aur us par kabhī juā na rakhā gayā ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Tum use Iliyazar Imām ko denā jo use ḳhaime ke bāhar le jāe. Wahāṅ use us kī maujūdagī meṅ zabah kiyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Phir Iliyazar Imām apnī unglī se us ke ḳhūn se kuchh le kar mulāqāt ke ḳhaime ke sāmne wāle hisse kī taraf chhiṛke. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Us kī maujūdagī meṅ pūrī kī pūrī gāy ko jalāyā jāe. Us kī khāl, gosht, ḳhūn aur antaṛiyoṅ kā gobar bhī jalāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Phir wuh deodār kī lakaṛī, zūfā aur qirmizī rang kā dhāgā le kar use jaltī huī gāy par phaiṅke. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Is ke bād wuh apne kapṛoṅ ko dho kar nahā le. Phir wuh ḳhaimāgāh meṅ ā saktā hai lekin shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Jis ādmī ne gāy ko jalāyā wuh bhī apne kapṛoṅ ko dho kar nahā le. Wuh bhī shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Ek dūsrā ādmī jo pāk hai gāy kī rākh ikaṭṭhī karke ḳhaimāgāh ke bāhar kisī pāk jagah par ḍāl de. Wahāṅ Isrāīl kī jamāt use nāpākī dūr karne kā pānī taiyār karne ke lie mahfūz rakhe. Yih gunāh se pāk karne ke lie istemāl hogā. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Jis ādmī ne rākh ikaṭṭhī kī hai wuh bhī apne kapṛoṅ ko dho le. Wuh bhī shām tak nāpāk rahegā. Yih Isrāīliyoṅ aur un ke darmiyān rahne wāle pardesiyoṅ ke lie dāymī usūl ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Jo bhī lāsh chhue wuh sāt din tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Tīsre aur sātweṅ din wuh apne āp par nāpākī dūr karne kā pānī chhiṛak kar pāk-sāf ho jāe. Is ke bād hī wuh pāk hogā. Lekin agar wuh in donoṅ dinoṅ meṅ apne āp ko yoṅ pāk na kare to nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Jo bhī lāsh chhū kar apne āp ko yoṅ pāk nahīṅ kartā wuh Rab ke maqdis ko nāpāk kartā hai. Lāzim hai ki use Isrāīl meṅ se miṭāyā jāe. Chūṅki nāpākī dūr karne kā pānī us par chhiṛkā nahīṅ gayā is lie wuh nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Agar koī ḍere meṅ mar jāe to jo bhī us waqt us meṅ maujūd ho yā dāḳhil ho jāe wuh sāt din tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Har khulā bartan jo ḍhakne se band na kiyā gayā ho wuh bhī nāpāk hogā. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Isī tarah jo khule maidān meṅ lāsh chhue wuh bhī sāt din tak nāpāk rahegā, ḳhāh wuh talwār se yā tabaī maut marā ho. Jo insān kī koī haḍḍī yā qabr chhue wuh bhī sāt din tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Nāpākī dūr karne ke lie us surḳh rang kī gāy kī rākh meṅ se kuchh lenā jo gunāh dūr karne ke lie jalāī gaī thī. Use bartan meṅ ḍāl kar tāzā pānī meṅ milānā. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Phir koī pāk ādmī kuchh zūfā le aur use us pānī meṅ ḍubo kar mare hue shaḳhs ke ḳhaime, us ke sāmān aur un logoṅ par chhiṛke jo us ke marte waqt wahāṅ the. Isī tarah wuh pānī us shaḳhs par bhī chhiṛke jis ne tabaī yā ġhairtabaī maut mare hue shaḳhs ko, kisī insān kī haḍḍī ko yā koī qabr chhūī ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Pāk ādmī yih pānī tīsre aur sātweṅ din nāpāk shaḳhs par chhiṛke. Sātweṅ din wuh use pāk kare. Jise pāk kiyā jā rahā hai wuh apne kapṛe dho kar nahā le to wuh usī shām pāk hogā. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Lekin jo nāpāk shaḳhs apne āp ko pāk nahīṅ kartā use jamāt meṅ se miṭānā hai, kyoṅki us ne Rab kā maqdis nāpāk kar diyā hai. Nāpākī dūr karne kā pānī us par nahīṅ chhiṛkā gayā, is lie wuh nāpāk rahā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Yih un ke lie dāymī usūl hai. Jis ādmī ne nāpākī dūr karne kā pānī chhiṛkā hai wuh bhī apne kapṛe dhoe. Balki jis ne bhī yih pānī chhuā hai shām tak nāpāk rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Aur nāpāk shaḳhs jo bhī chīz chhue wuh nāpāk ho jātī hai. Na sirf yih balki jo bād meṅ yih nāpāk chīz chhue wuh bhī shām tak nāpāk rahegā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Pahle mahīne meṅ Isrāīl kī pūrī jamāt Dasht-e-Sīn meṅ pahuṅch kar Qādis meṅ rahne lagī. Wahāṅ Mariyam ne wafāt pāī aur wahīṅ use dafnāyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Qādis meṅ pānī dastyāb nahīṅ thā, is lie log Mūsā aur Hārūn ke muqābale meṅ jamā hue. ");
INSERT INTO urdgvr_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Wuh Mūsā se yih kah kar jhagaṛne lage, “Kāsh ham apne bhāiyoṅ ke sāth Rab ke sāmne mar gae hote! ");
INSERT INTO urdgvr_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Āp Rab kī jamāt ko kyoṅ is registān meṅ le āe? Kyā is lie ki ham yahāṅ apne maweshiyoṅ samet mar jāeṅ? ");
INSERT INTO urdgvr_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Āp hameṅ Misr se nikāl kar us nāḳhushgawār jagah par kyoṅ le āe haiṅ? Yahāṅ na to anāj, na anjīr, angūr yā anār dastyāb haiṅ. Pānī bhī nahīṅ hai!” ");
INSERT INTO urdgvr_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mūsā aur Hārūn logoṅ ko chhoṛ kar mulāqāt ke ḳhaime ke darwāze par gae aur muṅh ke bal gire. Tab Rab kā jalāl un par zāhir huā. ");
INSERT INTO urdgvr_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Ahd ke sandūq ke sāmne paṛī lāṭhī pakaṛ kar Hārūn ke sāth jamāt ko ikaṭṭhā kar. Un ke sāmne chaṭṭān se bāt karo to wuh apnā pānī degī. Yoṅ tū chaṭṭān meṅ se jamāt ke lie pānī nikāl kar unheṅ un ke maweshiyoṅ samet pānī pilāegā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Mūsā ne aisā hī kiyā. Us ne ahd ke sandūq ke sāmne paṛī lāṭhī uṭhāī ");
INSERT INTO urdgvr_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","aur Hārūn ke sāth jamāt ko chaṭṭān ke sāmne ikaṭṭhā kiyā. Mūsā ne un se kahā, “Ai baġhāwat karne wālo, suno! Kyā ham is chaṭṭān meṅ se tumhāre lie pānī nikāleṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Us ne lāṭhī ko uṭhā kar chaṭṭān ko do martabā mārā to bahut-sā pānī phūṭ niklā. Jamāt aur un ke maweshiyoṅ ne ḳhūb pānī piyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Lekin Rab ne Mūsā aur Hārūn se kahā, “Tumhārā mujh par itnā īmān nahīṅ thā ki merī quddūsiyat ko Isrāīliyoṅ ke sāmne qāym rakhte. Is lie tum us jamāt ko us mulk meṅ nahīṅ le jāoge jo maiṅ unheṅ dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Yih wāqiyā Marībā yānī ‘Jhagaṛnā’ ke pānī par huā. Wahāṅ Isrāīliyoṅ ne Rab se jhagaṛā kiyā, aur wahāṅ us ne un par zāhir kiyā ki wuh quddūs hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Qādis se Mūsā ne Adom ke bādshāh ko ittalā bhejī, “Āp ke bhāī Isrāīl kī taraf se ek guzārish hai. Āp ko un tamām musībatoṅ ke bāre meṅ ilm hai jo ham par ān paṛī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Hamāre bāpdādā Misr gae the aur wahāṅ ham bahut arse tak rahe. Misriyoṅ ne hamāre bāpdādā aur ham se burā sulūk kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Lekin jab ham ne chillā kar Rab se minnat kī to us ne hamārī sunī aur farishtā bhej kar hameṅ Misr se nikāl lāyā. Ab ham yahāṅ Qādis Shahr meṅ haiṅ jo āp kī sarhad par hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Mehrbānī karke hameṅ apne mulk meṅ se guzarne deṅ. Ham kisī khet yā angūr ke bāġh meṅ nahīṅ jāeṅge, na kisī kueṅ kā pānī pieṅge. Ham shāhrāh par hī raheṅge. Āp ke mulk meṅ se guzarte hue ham us se na dāīṅ aur na bāīṅ taraf haṭeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Lekin Adomiyoṅ ne jawāb diyā, “Yahāṅ se na guzarnā, warnā ham nikal kar āp se laṛeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Isrāīl ne dubārā ḳhabar bhejī, “Ham shāhrāh par rahte hue guzareṅge. Agar hameṅ yā hamāre jānwaroṅ ko pānī kī zarūrat huī to paise de kar ḳharīd leṅge. Ham paidal hī guzarnā chāhte haiṅ, aur kuchh nahīṅ chāhte.” ");
INSERT INTO urdgvr_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Lekin Adomiyoṅ ne dubārā inkār kiyā. Sāth hī unhoṅ ne un ke sāth laṛne ke lie ek baṛī aur tāqatwar fauj bhejī. ");
INSERT INTO urdgvr_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Chūṅki Adom ne unheṅ guzarne kī ijāzat na dī is lie Isrāīlī muṛ kar dūsre rāste se chale gae. ");
INSERT INTO urdgvr_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Isrāīl kī pūrī jamāt Qādis se rawānā ho kar Hor Pahāṛ ke pās pahuṅchī. ");
INSERT INTO urdgvr_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Yih pahāṛ Adom kī sarhad par wāqe thā. Wahāṅ Rab ne Mūsā aur Hārūn se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Hārūn ab kūch karke apne bāpdādā se jā milegā. Wuh us mulk meṅ dāḳhil nahīṅ hogā jo maiṅ Isrāīliyoṅ ko dūṅgā, kyoṅki tum donoṅ ne Marībā ke pānī par mere hukm kī ḳhilāfwarzī kī. ");
INSERT INTO urdgvr_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Hārūn aur us ke beṭe Iliyazar ko le kar Hor Pahāṛ par chaṛh jā. ");
INSERT INTO urdgvr_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Hārūn ke kapṛe utār kar us ke beṭe Iliyazar ko pahnā denā. Phir Hārūn kūch karke apne bāpdādā se jā milegā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mūsā ne aisā hī kiyā jaisā Rab ne kahā. Tīnoṅ pūrī jamāt ke deḳhte deḳhte Hor Pahāṛ par chaṛh gae. ");
INSERT INTO urdgvr_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mūsā ne Hārūn ke kapṛe utarwā kar us ke beṭe Iliyazar ko pahnā die. Phir Hārūn wahāṅ pahāṛ kī choṭī par faut huā, aur Mūsā aur Iliyazar nīche utar gae. ");
INSERT INTO urdgvr_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Jab pūrī jamāt ko mālūm huā ki Hārūn intaqāl kar gayā hai to sab ne 30 din tak us ke lie mātam kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Dasht-e-Najab ke Kanānī mulk Arād ke bādshāh ko ḳhabar milī ki Isrāīlī Athārim kī taraf baṛh rahe haiṅ. Us ne un par hamlā kiyā aur kaī ek ko pakaṛ kar qaid kar liyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Tab Isrāīliyoṅ ne Rab ke sāmne mannat mān kar kahā, “Agar tū hameṅ un par fatah degā to ham unheṅ un ke shahroṅ samet tabāh kar deṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Rab ne un kī sunī aur Kanāniyoṅ par fatah baḳhshī. Isrāīliyoṅ ne unheṅ un ke shahroṅ samet pūrī tarah tabāh kar diyā. Is lie us jagah kā nām Hurmā yānī Tabāhī paṛ gayā. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Hor Pahāṛ se rawānā ho kar wuh Bahr-e-Qulzum kī taraf chal die tāki Adom ke mulk meṅ se guzarnā na paṛe. Lekin chalte chalte log besabar ho gae. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Wuh Rab aur Mūsā ke ḳhilāf bāteṅ karne lage, “Āp hameṅ Misr se nikāl kar registān meṅ marne ke lie kyoṅ le āe haiṅ? Yahāṅ na roṭī dastyāb hai na pānī. Hameṅ is ghaṭiyā qism kī ḳhurāk se ghin ātī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Tab Rab ne un ke darmiyān zahrīle sāṅp bhej die jin ke kāṭne se bahut-se log mar gae. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Phir log Mūsā ke pās āe. Unhoṅ ne kahā, “Ham ne Rab aur āp ke ḳhilāf bāteṅ karte hue gunāh kiyā. Hamārī sifārish kareṅ ki Rab ham se sāṅp dūr kar de.” Mūsā ne un ke lie duā kī ");
INSERT INTO urdgvr_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","to Rab ne Mūsā se kahā, “Ek sāṅp banā kar use khambe se laṭkā de. Jo bhī ḍasā gayā ho wuh use dekh kar bach jāegā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Chunāṅche Mūsā ne pītal kā ek sāṅp banāyā aur khambā khaṛā karke sāṅp ko us se laṭkā diyā. Aur aisā huā ki jise bhī ḍasā gayā thā wuh pītal ke sāṅp par nazar karke bach gayā. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Isrāīlī rawānā hue aur Obot meṅ apne ḳhaime lagāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Phir wahāṅ se kūch karke Aiye-abārīm meṅ ḍere ḍāle, us registān meṅ jo mashriq kī taraf Moāb ke sāmne hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Wahāṅ se rawānā ho kar wuh Wādī-e-Zirad meṅ ḳhaimāzan hue. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Jab Wādī-e-Zirad se rawānā hue to Dariyā-e-Arnon ke parle yānī junūbī kināre par ḳhaimāzan hue. Yih dariyā registān meṅ hai aur Amoriyoṅ ke ilāqe se nikaltā hai. Yih Amoriyoṅ aur Moābiyoṅ ke darmiyān kī sarhad hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Is kā zikr kitāb ‘Rab kī Jangeṅ’ meṅ bhī hai, “Wāheb jo Sūfā meṅ hai, Dariyā-e-Arnon kī wādiyāṅ ");
INSERT INTO urdgvr_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","aur wādiyoṅ kā wuh ḍhalān jo Ār Shahr tak jātā hai aur Moāb kī sarhad par wāqe hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Wahāṅ se wuh Bair yānī ‘Kuāṅ’ pahuṅche. Yih wuhī bair hai jahāṅ Rab ne Mūsā se kahā, “Logoṅ ko ikaṭṭhā kar to maiṅ unheṅ pānī dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Us waqt Isrāīliyoṅ ne yih gīt gāyā, “Ai kueṅ, phūṭ nikal! Us ke bāre meṅ gīt gāo, ");
INSERT INTO urdgvr_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","us kueṅ ke bāre meṅ jise sardāroṅ ne khodā, jise qaum ke rāhnumāoṅ ne asā-e-shāhī aur apnī lāṭhiyoṅ se khodā.” Phir wuh registān se Mattanā ko gae. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Mattanā se Nahliyel ko aur Nahliyel se Bāmāt ko. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bāmāt se wuh Moābiyoṅ ke ilāqe kī us wādī meṅ pahuṅche jo Pisgā Pahāṛ ke dāman meṅ hai. Is pahāṛ kī choṭī se Wādī-e-Yardan kā junūbī hissā Yashīmon ḳhūb nazar ātā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Isrāīl ne Amoriyoṅ ke bādshāh Sīhon ko ittalā bhejī, ");
INSERT INTO urdgvr_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Hameṅ apne mulk meṅ se guzarne deṅ. Ham sīdhe sīdhe guzar jāeṅge. Na ham koī khet yā angūr kā bāġh chheṛeṅge, na kisī kueṅ kā pānī pieṅge. Ham āp ke mulk meṅ se sīdhe guzarte hue shāhrāh par hī raheṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Lekin Sīhon ne unheṅ guzarne na diyā balki apnī fauj jamā karke Isrāīl se laṛne ke lie registān meṅ chal paṛā. Yahaz pahuṅch kar us ne Isrāīliyoṅ se jang kī. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Lekin Isrāīliyoṅ ne use qatl kiyā aur Dariyā-e-Arnon se le kar Dariyā-e-Yabboq tak yānī Ammoniyoṅ kī sarhad tak us ke mulk par qabzā kar liyā. Wuh is se āge na jā sake kyoṅki Ammoniyoṅ ne apnī sarhad kī hisārbandī kar rakhī thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Isrāīlī tamām Amorī shahroṅ par qabzā karke un meṅ rahne lage. Un meṅ Hasbon aur us ke irdgird kī ābādiyāṅ shāmil thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hasbon Amorī bādshāh Sīhon kā dārul-hukūmat thā. Us ne Moāb ke pichhle bādshāh se laṛ kar us se yih ilāqā Dariyā-e-Arnon tak chhīn liyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Us wāqiye kā zikr shāyrī meṅ yoṅ kiyā gayā hai, “Hasbon ke pās ā kar use az sar-e-nau tāmīr karo, Sīhon ke shahr ko az sar-e-nau qāym karo. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Hasbon se āg niklī, Sīhon ke shahr se sholā bhaṛkā. Us ne Moāb ke shahr Ār ko jalā diyā, Arnon kī bulandiyoṅ ke mālikoṅ ko bhasm kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ai Moāb, tujh par afsos! Ai Kamos Dewatā kī qaum, tū halāk huī hai. Kamos ne apne beṭoṅ ko mafrūr aur apnī beṭiyoṅ ko Amorī bādshāh Sīhon kī qaidī banā diyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Lekin jab ham ne Amoriyoṅ par tīr chalāe to Hasbon kā ilāqā Dībon tak barbād huā. Ham ne Nufah tak sab kuchh tabāh kiyā, wuh Nufah jis kā ilāqā Mīdabā tak hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Yoṅ Isrāīl Amoriyoṅ ke mulk meṅ ābād huā. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Wahāṅ se Mūsā ne apne jāsūs Yāzer Shahr bheje. Wahāṅ bhī Amorī rahte the. Isrāīliyoṅ ne Yāzer aur us ke irdgird ke shahroṅ par bhī qabzā kiyā aur wahāṅ ke Amoriyoṅ ko nikāl diyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Is ke bād wuh muṛ kar Basan kī taraf baṛhe. Tab Basan kā bādshāh Oj apnī tamām fauj le kar un se laṛne ke lie shahr Idraī āyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Us waqt Rab ne Mūsā se kahā, “Oj se na ḍarnā. Maiṅ use, us kī tamām fauj aur us kā mulk tere hawāle kar chukā hūṅ. Us ke sāth wuhī sulūk kar jo tū ne Amoriyoṅ ke bādshāh Sīhon ke sāth kiyā, jis kā dārul-hukūmat Hasbon thā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Isrāīliyoṅ ne Oj, us ke beṭoṅ aur tamām fauj ko halāk kar diyā. Koī bhī na bachā. Phir unhoṅ ne Basan ke mulk par qabzā kar liyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Is ke bād Isrāīlī Moāb ke maidānoṅ meṅ pahuṅch kar Dariyā-e-Yardan ke mashriqī kināre par Yarīhū ke āmne-sāmne ḳhaimāzan hue. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Moāb ke bādshāh Balaq bin Safor ko mālūm huā ki Isrāīliyoṅ ne Amoriyoṅ ke sāth kyā kuchh kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moābiyoṅ ne yih bhī dekhā ki Isrāīlī bahut zyādā haiṅ, is lie un par dahshat chhā gaī. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Unhoṅ ne Midiyāniyoṅ ke buzurgoṅ se bāt kī, “Ab yih hujūm us tarah hamāre irdgird kā ilāqā chaṭ kar jāegā jis tarah bail maidān kī ghās chaṭ kar jātā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Tab Balaq ne apne qāsid Fator Shahr ko bheje jo Dariyā-e-Furāt par wāqe thā aur jahāṅ Bilām bin Baor apne watan meṅ rahtā thā. Qāsid use bulāne ke lie us ke pās pahuṅche aur use Balaq kā paiġhām sunāyā, “Ek qaum Misr se nikal āī hai jo rū-e-zamīn par chhā kar mere qarīb hī ābād huī hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Is lie āeṅ aur in logoṅ par lānat bhejeṅ, kyoṅki wuh mujh se zyādā tāqatwar haiṅ. Phir shāyad maiṅ unheṅ shikast de kar mulk se bhagā sakūṅ. Kyoṅki maiṅ jāntā hūṅ ki jinheṅ āp barkat dete haiṅ unheṅ barkat miltī hai aur jin par āp lānat bhejte haiṅ un par lānat ātī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Yih paiġhām le kar Moāb aur Midiyān ke buzurg rawānā hue. Un ke pās inām ke paise the. Bilām ke pās pahuṅch kar unhoṅ ne use Balaq kā paiġhām sunāyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Bilām ne kahā, “Rāt yahāṅ guzāreṅ. Kal maiṅ āp ko batā dūṅgā ki Rab is ke bāre meṅ kyā farmātā hai.” Chunāṅche Moābī sardār us ke pās ṭhahar gae. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Rāt ke waqt Allāh Bilām par zāhir huā. Us ne pūchhā, “Yih ādmī kaun haiṅ jo tere pās āe haiṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Bilām ne jawāb diyā, “Moāb ke bādshāh Balaq bin Safor ne mujhe paiġhām bhejā hai, ");
INSERT INTO urdgvr_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Jo qaum Misr se nikal āī hai wuh rū-e-zamīn par chhā gaī hai. Is lie āeṅ aur mere lie un par lānat bhejeṅ. Phir shāyad maiṅ un se laṛ kar unheṅ bhagā dene meṅ kāmyāb ho jāūṅ.’” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Rab ne Bilām se kahā, “Un ke sāth na jānā. Tujhe un par lānat bhejne kī ijāzat nahīṅ hai, kyoṅki un par merī barkat hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Aglī subah Bilām jāg uṭhā to us ne Balaq ke sardāroṅ se kahā, “Apne watan wāpas chale jāeṅ, kyoṅki Rab ne mujhe āp ke sāth jāne kī ijāzat nahīṅ dī.” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Chunāṅche Moābī sardār ḳhālī hāth Balaq ke pās wāpas āe. Unhoṅ ne kahā, “Bilām hamāre sāth āne se inkār kartā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Tab Balaq ne aur sardār bheje jo pahle wāloṅ kī nisbat tādād aur ohde ke lihāz se zyādā the. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Wuh Bilām ke pās jā kar kahne lage, “Balaq bin Safor kahte haiṅ ki koī bhī bāt āp ko mere pās āne se na roke, ");
INSERT INTO urdgvr_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","kyoṅki maiṅ āp ko baṛā inām dūṅgā. Āp jo bhī kaheṅge maiṅ karne ke lie taiyār hūṅ. Āeṅ to sahī aur mere lie un logoṅ par lānat bhejeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Lekin Bilām ne jawāb diyā, “Agar Balaq apne mahal ko chāṅdī aur sone se bhar kar bhī mujhe de to bhī maiṅ Rab apne Ḳhudā ke farmān kī ḳhilāfwarzī nahīṅ kar saktā, ḳhāh bāt chhoṭī ho yā baṛī. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Āp dūsre sardāroṅ kī tarah rāt yahāṅ guzāreṅ. Itne meṅ maiṅ mālūm karūṅga ki Rab mujhe mazīd kyā kuchh batātā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Us rāt Allāh Bilām par zāhir huā aur kahā, “Chūṅki yih ādmī tujhe bulāne āe haiṅ is lie un ke sāth chalā jā. Lekin sirf wuhī kuchh karnā jo maiṅ tujhe batāūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Subah ko Bilām ne uṭh kar apnī gadhī par zīn kasā aur Moābī sardāroṅ ke sāth chal paṛā. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Lekin Allāh nihāyat ġhusse huā ki wuh jā rahā hai, is lie us kā farishtā us kā muqābalā karne ke lie rāste meṅ khaṛā ho gayā. Bilām apnī gadhī par sawār thā aur us ke do naukar us ke sāth chal rahe the. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Jab gadhī ne dekhā ki Rab kā farishtā apne hāth meṅ talwār thāme hue rāste meṅ khaṛā hai to wuh rāste se haṭ kar khet meṅ chalne lagī. Bilām use mārte mārte rāste par wāpas le āyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Phir wuh angūr ke do bāġhoṅ ke darmiyān se guzarne lage. Rāstā tang thā, kyoṅki wuh donoṅ taraf bāġhoṅ kī chārdīwārī se band thā. Ab Rab kā farishtā wahāṅ khaṛā huā. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Gadhī yih dekh kar chārdīwārī ke sāth sāth chalne lagī, aur Bilām kā pāṅw kuchlā gayā. Us ne use dubārā mārā. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Rab kā farishtā āge niklā aur tīsrī martabā rāste meṅ khaṛā ho gayā. Ab rāste se haṭ jāne kī koī gunjāish nahīṅ thī, na dāīṅ taraf aur na bāīṅ taraf. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Jab gadhī ne Rab kā farishtā dekhā to wuh leṭ gaī. Bilām ko ġhussā ā gayā, aur us ne use apnī lāṭhī se ḳhūb mārā. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Tab Rab ne gadhī ko bolne diyā, aur us ne Bilām se kahā, “Maiṅ ne āp se kyā ġhalat sulūk kiyā hai ki āp mujhe ab tīsrī dafā pīṭ rahe haiṅ?” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bilām ne jawāb diyā, “Tū ne mujhe bewuqūf banāyā hai! Kāsh mere hāth meṅ talwār hotī to maiṅ abhī tujhe zabah kar detā!” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Gadhī ne Bilām se kahā, “Kyā maiṅ āp kī gadhī nahīṅ hūṅ jis par āp āj tak sawār hote rahe haiṅ? Kyā mujhe kabhī aisā karne kī ādat thī?” Us ne kahā, “Nahīṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Phir Rab ne Bilām kī āṅkheṅ kholīṅ aur us ne Rab ke farishte ko dekhā jo ab tak hāth meṅ talwār thāme hue rāste meṅ khaṛā thā. Bilām ne muṅh ke bal gir kar sijdā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Rab ke farishte ne pūchhā, “Tū ne tīn bār apnī gadhī ko kyoṅ pīṭā? Maiṅ tere muqābale meṅ āyā hūṅ, kyoṅki jis taraf tū baṛh rahā hai us kā anjām burā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Gadhī tīn martabā mujhe dekh kar merī taraf se haṭ gaī. Agar wuh na haṭtī to tū us waqt halāk ho gayā hotā agarche maiṅ gadhī ko chhoṛ detā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Bilām ne Rab ke farishte se kahā, “Maiṅ ne gunāh kiyā hai. Mujhe mālūm nahīṅ thā ki tū mere muqābale meṅ rāste meṅ khaṛā hai. Lekin agar merā safr tujhe burā lage to maiṅ ab wāpas chalā jāūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Rab ke farishte ne kahā, “In ādmiyoṅ ke sāth apnā safr jārī rakh. Lekin sirf wuhī kuchh kahnā jo maiṅ tujhe batāūṅgā.” Chunāṅche Bilām ne Balaq ke sardāroṅ ke sāth apnā safr jārī rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Jab Balaq ko ḳhabar milī ki Bilām ā rahā hai to wuh us se milne ke lie Moāb ke us shahr tak gayā jo Moāb kī sarhad Dariyā-e-Arnon par wāqe hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Us ne Bilām se kahā, “Kyā maiṅ ne āp ko ittalā nahīṅ bhejī thī ki āp zarūr āeṅ? Āp kyoṅ nahīṅ āe? Kyā āp ne sochā ki maiṅ āp ko munāsib inām nahīṅ de pāūṅgā?” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Bilām ne jawāb diyā, “Baharhāl ab maiṅ pahuṅch gayā hūṅ. Lekin maiṅ sirf wuhī kuchh kah saktā hūṅ jo Allāh ne pahle hī mere muṅh meṅ ḍāl diyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Phir Bilām Balaq ke sāth Qiriyat-husāt gayā. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Wahāṅ Balaq ne gāy-bail aur bheṛ-bakriyāṅ qurbān karke un ke gosht meṅ se Bilām aur us ke sāth wāle sardāroṅ ko de diyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Aglī subah Balaq Bilām ko sāth le kar ek ūṅchī jagah par chaṛh gayā jis kā nām Bāmot-bāl thā. Wahāṅ se Isrāīlī ḳhaimāgāh kā kinārā nazar ātā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Bilām ne kahā, “Yahāṅ mere lie sāt qurbāngāheṅ banāeṅ. Sāth sāth mere lie sāt bail aur sāt menḍhe taiyār kar rakheṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaq ne aisā hī kiyā, aur donoṅ ne mil kar har qurbāngāh par ek bail aur ek menḍhā chaṛhāyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Phir Bilām ne Balaq se kahā, “Yahāṅ apnī qurbānī ke pās khaṛe raheṅ. Maiṅ kuchh fāsile par jātā hūṅ, shāyad Rab mujh se milne āe. Jo kuchh wuh mujh par zāhir kare maiṅ āp ko batā dūṅgā.” Yih kah kar wuh ek ūṅche maqām par chalā gayā jo hariyālī se bilkul mahrūm thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Wahāṅ Allāh Bilām se milā. Bilām ne kahā, “Maiṅ ne sāt qurbāngāheṅ taiyār karke har qurbāngāh par ek bail aur ek menḍhā qurbān kiyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Tab Rab ne use Balaq ke lie paiġhām diyā aur kahā, “Balaq ke pās wāpas jā aur use yih paiġhām sunā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Bilām Balaq ke pās wāpas āyā jo ab tak Moābī sardāroṅ ke sāth apnī qurbānī ke pās khaṛā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Bilām bol uṭhā, “Balaq mujhe Arām se yahāṅ lāyā hai, Moābī bādshāh ne mujhe mashriqī pahāṛoṅ se bulā kar kahā, ‘Āo, Yāqūb par mere lie lānat bhejo. Āo, Isrāīl ko badduā do.’ ");
INSERT INTO urdgvr_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Maiṅ kis tarah un par lānat bhejūṅ jin par Allāh ne lānat nahīṅ bhejī? Maiṅ kis tarah unheṅ badduā dūṅ jinheṅ Rab ne badduā nahīṅ dī? ");
INSERT INTO urdgvr_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Maiṅ unheṅ chaṭṭānoṅ kī choṭī se deḳhtā hūṅ, pahāṛiyoṅ se un kā mushāhadā kartā hūṅ. Wāqaī yih ek aisī qaum hai jo dūsroṅ se alag rahtī hai. Yih apne āp ko dūsrī qaumoṅ se mumtāz samajhtī hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Kaun Yāqūb kī aulād ko gin saktā hai jo gard kī mānind beshumār hai. Kaun Isrāīliyoṅ kā chauthā hissā bhī gin saktā hai? Rab kare ki maiṅ rāstbāzoṅ kī maut marūṅ, ki merā anjām un ke anjām jaisā achchhā ho.” ");
INSERT INTO urdgvr_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaq ne Bilām se kahā, “Āp ne mere sāth kyā kiyā hai? Maiṅ āp ko apne dushmanoṅ par lānat bhejne ke lie lāyā aur āp ne unheṅ achchhī-ḳhāsī barkat dī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Bilām ne jawāb diyā, “Kyā lāzim nahīṅ ki maiṅ wuhī kuchh bolūṅ jo Rab ne batāne ko kahā hai?” ");
INSERT INTO urdgvr_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Phir Balaq ne us se kahā, “Āeṅ, ham ek aur jagah jāeṅ jahāṅ se āp Isrāīlī qaum ko dekh sakeṅge, go un kī ḳhaimāgāh kā sirf kinārā hī nazar āegā. Āp sab ko nahīṅ dekh sakeṅge. Wahīṅ se un par mere lie lānat bhejeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Yih kah kar wuh us ke sāth Pisgā kī choṭī par chaṛh kar Pahredāroṅ ke Maidān tak pahuṅch gayā. Wahāṅ bhī us ne sāt qurbāngāheṅ banā kar har ek par ek bail aur ek menḍhā qurbān kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Bilām ne Balaq se kahā, “Yahāṅ apnī qurbāngāh ke pās khaṛe raheṅ. Maiṅ kuchh fāsile par jā kar Rab se milūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Rab Bilām se milā. Us ne use Balaq ke lie paiġhām diyā aur kahā, “Balaq ke pās wāpas jā aur use yih paiġhām sunā de.” ");
INSERT INTO urdgvr_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Wuh wāpas chalā gayā. Balaq ab tak apne sardāroṅ ke sāth apnī qurbānī ke pās khaṛā thā. Us ne us se pūchhā, “Rab ne kyā kahā?” ");
INSERT INTO urdgvr_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Bilām ne kahā, “Ai Balaq, uṭho aur suno. Ai Safor ke beṭe, merī bāt par ġhaur karo. ");
INSERT INTO urdgvr_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Allāh ādmī nahīṅ jo jhūṭ boltā hai. Wuh insān nahīṅ jo koī faislā karke bād meṅ pachhtāe. Kyā wuh kabhī apnī bāt par amal nahīṅ kartā? Kyā wuh kabhī apnī bāt pūrī nahīṅ kartā? ");
INSERT INTO urdgvr_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Mujhe barkat dene ko kahā gayā hai. Us ne barkat dī hai aur maiṅ yih barkat rok nahīṅ saktā. ");
INSERT INTO urdgvr_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Yāqūb ke gharāne meṅ ḳharābī nazar nahīṅ ātī, Isrāīl meṅ dukh dikhāī nahīṅ detā. Rab us kā Ḳhudā us ke sāth hai, aur qaum bādshāh kī ḳhushī meṅ nāre lagātī hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Allāh unheṅ Misr se nikāl lāyā, aur unheṅ janglī bail kī tāqat hāsil hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Yāqūb ke gharāne ke ḳhilāf jādūgarī nākām hai, Isrāīl ke ḳhilāf ġhaibdānī befāydā hai. Ab Yāqūb ke gharāne se kahā jāegā, ‘Allāh ne kaisā kām kiyā hai!’ ");
INSERT INTO urdgvr_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Isrāīlī qaum shernī kī tarah uṭhtī aur sherbabar kī tarah khaṛī ho jātī hai. Jab tak wuh apnā shikār na khā le wuh ārām nahīṅ kartā, jab tak wuh māre hue logoṅ kā ḳhūn na pī le wuh nahīṅ leṭtā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Yih sun kar Balaq ne kahā, “Agar āp un par lānat bhejne se inkār kareṅ, kam az kam unheṅ barkat to na deṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Bilām ne jawāb diyā, “Kyā maiṅ ne āp ko nahīṅ batāyā thā ki jo kuchh bhī Rab kahegā maiṅ wuhī karūṅga?” ");
INSERT INTO urdgvr_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Tab Balaq ne Bilām se kahā, “Āeṅ, maiṅ āp ko ek aur jagah le jāūṅ. Shāyad Allāh rāzī ho jāe ki āp mere lie wahāṅ se un par lānat bhejeṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Wuh us ke sāth Faġhūr Pahāṛ par chaṛh gayā. Us kī choṭī se Yardan kī Wādī kā junūbī hissā Yashīmon dikhāī diyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Bilām ne us se kahā, “Mere lie yahāṅ sāt qurbāngāheṅ banā kar sāt bail aur sāt menḍhe taiyār kar rakheṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaq ne aisā hī kiyā. Us ne har ek qurbāngāh par ek bail aur ek menḍhā qurbān kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Ab Bilām ko us bāt kā pūrā yaqīn ho gayā ki Rab ko pasand hai ki maiṅ Isrāīliyoṅ ko barkat dūṅ. Is lie us ne is martabā pahle kī tarah jādūgarī kā tarīqā istemāl na kiyā balki sīdhā registān kī taraf ruḳh kiyā ");
INSERT INTO urdgvr_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","jahāṅ Isrāīl apne apne qabīloṅ kī tartīb se ḳhaimāzan thā. Yih dekh kar Allāh kā Rūh us par nāzil huā, ");
INSERT INTO urdgvr_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","aur wuh bol uṭhā, “Bilām bin Baor kā paiġhām suno, us ke paiġhām par ġhaur karo jo sāf sāf deḳhtā hai, ");
INSERT INTO urdgvr_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","us kā paiġhām jo Allāh kī bāteṅ sun letā hai, Qādir-e-mutlaq kī royā ko dekh letā hai aur zamīn par gir kar poshīdā bāteṅ deḳhtā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Ai Yāqūb, tere ḳhaime kitne shāndār haiṅ! Ai Isrāīl, tere ghar kitne achchhe haiṅ! ");
INSERT INTO urdgvr_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Wuh dūr tak phailī huī wādiyoṅ kī mānind, nahar ke kināre lage bāġhoṅ kī mānind, Rab ke lagāe hue ūd ke daraḳhtoṅ kī mānind, pānī ke kināre lage deodār ke daraḳhtoṅ kī mānind haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Un kī bālṭiyoṅ se pānī chhalaktā rahegā, un ke bīj ko kasrat kā pānī milegā. Un kā bādshāh Ajāj se zyādā tāqatwar hogā, aur un kī saltanat sarfarāz hogī. ");
INSERT INTO urdgvr_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Allāh unheṅ Misr se nikāl lāyā, aur unheṅ janglī bail kī-sī tāqat hāsil hai. Wuh muḳhālif qaumoṅ ko haṛap karke un kī haḍḍiyāṅ chūr chūr kar dete haiṅ, wuh apne tīr chalā kar unheṅ mār ḍālte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Isrāīl sherbabar yā shernī kī mānind hai. Jab wuh dabak kar baiṭh jāe to koī bhī use chheṛne kī jurrat nahīṅ kartā. Jo tujhe barkat de use barkat mile, aur jo tujh par lānat bheje us par lānat āe.” ");
INSERT INTO urdgvr_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Yih sun kar Balaq āpe se bāhar huā. Us ne tālī bajā kar apnī hiqārat kā izhār kiyā aur kahā, “Maiṅ ne tujhe is lie bulāyā thā ki tū mere dushmanoṅ par lānat bheje. Ab tū ne unheṅ tīnoṅ bār barkat hī dī hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Ab dafā ho jā! Apne ghar wāpas bhāg jā! Maiṅ ne kahā thā ki baṛā inām dūṅgā. Lekin Rab ne tujhe inām pāne se rok diyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Bilām ne jawāb diyā, “Kyā maiṅ ne un logoṅ ko jinheṅ āp ne mujhe bulāne ke lie bhejā thā nahīṅ batāyā thā ");
INSERT INTO urdgvr_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","ki agar Balaq apne mahal ko chāṅdī aur sone se bhar kar bhī mujhe de de to bhī maiṅ Rab kī kisī bāt kī ḳhilāfwarzī nahīṅ kar saktā, ḳhāh merī nīyat achchhī ho yā burī. Maiṅ sirf wuh kuchh kar saktā hūṅ jo Allāh farmātā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ab maiṅ apne watan wāpas chalā jātā hūṅ. Lekin pahle maiṅ āp ko batā detā hūṅ ki āḳhirkār yih qaum āp kī qaum ke sāth kyā kuchh karegī.” ");
INSERT INTO urdgvr_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Wuh bol uṭhā, “Bilām bin Baor kā paiġhām suno, us kā paiġhām jo sāf sāf deḳhtā hai, ");
INSERT INTO urdgvr_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","us kā paiġhām jo Allāh kī bāteṅ sun letā aur Allāh T'ālā kī marzī ko jāntā hai, jo Qādir-e-mutlaq kī royā ko dekh letā aur zamīn par gir kar poshīdā bāteṅ deḳhtā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Jise maiṅ dekh rahā hūṅ wuh is waqt nahīṅ hai. Jo mujhe nazar ā rahā hai wuh qarīb nahīṅ hai. Yāqūb ke gharāne se sitārā niklegā, aur Isrāīl se asā-e-shāhī uṭhegā jo Moāb ke māthoṅ aur Set ke tamām beṭoṅ kī khopaṛiyoṅ ko pāsh pāsh karegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Adom us ke qabze meṅ āegā, us kā dushman Saīr us kī milkiyat banegā jabki Isrāīl kī tāqat baṛhtī jāegī. ");
INSERT INTO urdgvr_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Yāqūb ke gharāne se ek hukmrān niklegā jo shahr ke bache huoṅ ko halāk kar degā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Phir Bilām ne Amālīq ko dekhā aur kahā, “Amālīq qaumoṅ meṅ awwal thā, lekin āḳhirkār wuh ḳhatm ho jāegā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Phir us ne Qīniyoṅ ko dekhā aur kahā, “Terī sukūnatgāh mustahkam hai, terā chaṭṭān meṅ banā ghoṅslā mazbūt hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Lekin tū tabāh ho jāegā jab Asūr tujhe giriftār karegā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ek aur dafā us ne bāt kī, “Hāy, kaun zindā rah saktā hai jab Allāh yoṅ karegā? ");
INSERT INTO urdgvr_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Kittīm ke sāhil se bahrī jahāz āeṅge jo Asūr aur Ibar ko zalīl kareṅge, lekin wuh ḳhud bhī halāk ho jāeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Phir Bilām uṭh kar apne ghar wāpas chalā gayā. Balaq bhī wahāṅ se chalā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Jab Isrāīlī Shittīm meṅ rah rahe the to Isrāīlī mard Moābī auratoṅ se zinākārī karne lage. ");
INSERT INTO urdgvr_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Yih aisā huā ki Moābī aurateṅ apne dewatāoṅ ko qurbāniyāṅ pesh karte waqt Isrāīliyoṅ ko sharīk hone kī dāwat dene lagīṅ. Isrāīlī dāwat qabūl karke qurbāniyoṅ se khāne aur dewatāoṅ ko sijdā karne lage. ");
INSERT INTO urdgvr_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Is tarīqe se Isrāīlī Moābī dewatā banām Bāl-faġhūr kī pūjā karne lage, aur Rab kā ġhazab un par ān paṛā. ");
INSERT INTO urdgvr_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Us ne Mūsā se kahā, “Is qaum ke tamām rāhnumāoṅ ko sazā-e-maut de kar sūraj kī raushnī meṅ Rab ke sāmne laṭkā, warnā Rab kā Isrāīliyoṅ par se ġhazab nahīṅ ṭalegā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Chunāṅche Mūsā ne Isrāīl ke qāziyoṅ se kahā, “Lāzim hai ki tum meṅ se har ek apne un ādmiyoṅ ko jān se mār de jo Bāl-faġhūr Dewatā kī pūjā meṅ sharīk hue haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Mūsā aur Isrāīl kī pūrī jamāt mulāqāt ke ḳhaime ke darwāze par jamā ho kar rone lage. Ittifāq se usī waqt ek ādmī wahāṅ se guzarā jo ek Midiyānī aurat ko apne ghar le jā rahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Yih dekh kar Hārūn kā potā Fīnhās bin Iliyazar jamāt se niklā aur nezā pakaṛ kar ");
INSERT INTO urdgvr_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","us Isrāīlī ke pīchhe chal paṛā. Wuh aurat samet apne ḳhaime meṅ dāḳhil huā to Fīnhās ne un ke pīchhe pīchhe jā kar nezā itne zor se mārā ki wuh donoṅ meṅ se guzar gayā. Us waqt wabā phailne lagī thī, lekin Fīnhās ke is amal se wuh ruk gaī. ");
INSERT INTO urdgvr_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","To bhī 24,000 afrād mar chuke the. ");
INSERT INTO urdgvr_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Hārūn ke pote Fīnhās bin Iliyazar ne Isrāīliyoṅ par merā ġhussā ṭhanḍā kar diyā hai. Merī ġhairat apnā kar wuh Isrāīl meṅ dīgar mābūdoṅ kī pūjā ko bardāsht na kar sakā. Is lie merī ġhairat ne Isrāīliyoṅ ko nest-o-nābūd nahīṅ kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Lihāzā use batā denā ki maiṅ us ke sāth salāmatī kā ahd qāym kartā hūṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Is ahd ke taht use aur us kī aulād ko abad tak imām kā ohdā hāsil rahegā, kyoṅki apne Ḳhudā kī ḳhātir ġhairat khā kar us ne Isrāīliyoṅ kā kaffārā diyā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Jis ādmī ko Midiyānī aurat ke sāth mār diyā gayā us kā nām Zimrī bin Salū thā, aur wuh Shamāūn ke qabīle ke ek ābāī gharāne kā sarparast thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Midiyānī aurat kā nām Kazbī thā, aur wuh Sūr kī beṭī thī jo Midiyāniyoṅ ke ek ābāī gharāne kā sarparast thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Midiyāniyoṅ ko dushman qarār de kar unheṅ mār ḍālnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Kyoṅki unhoṅ ne apnī chālākiyoṅ se tumhāre sāth dushman kā-sā sulūk kiyā, unhoṅ ne tumheṅ Bāl-faġhūr kī pūjā karne par uksāyā aur tumheṅ apnī bahan Midiyānī sardār kī beṭī Kazbī ke zariye jise wabā phailte waqt mār diyā gayā bahkāyā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Wabā ke bād Rab ne Mūsā aur Hārūn ke beṭe Iliyazar se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Pūrī Isrāīlī jamāt kī mardumshumārī un ke ābāī gharānoṅ ke mutābiq karnā. Un tamām mardoṅ ko ginanā jo 20 sāl yā is se zāyd ke haiṅ aur jo jang laṛne ke qābil haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","4","Mūsā aur Iliyazar ne Isrāīliyoṅ ko batāyā ki Rab ne unheṅ kyā hukm diyā hai. Chunāṅche unhoṅ ne Moāb ke maidānī ilāqe meṅ Yarīhū ke sāmne, lekin Dariyā-e-Yardan ke mashriqī kināre par mardumshumārī kī. Yih wuh Isrāīlī ādmī the jo Misr se nikle the. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","7","Isrāīl ke pahlauṭhe Rūbin ke qabīle ke 43,730 mard the. Qabīle ke chār kunbe Hanūkī, Falluwī, Hasronī aur Karmī Rūbin ke beṭoṅ Hanūk, Fallū, Hasron aur Karmī se nikle hue the. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Rūbin kā beṭā Fallū Iliyāb kā bāp thā ");
INSERT INTO urdgvr_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","jis ke beṭe Namuel, Dātan aur Abīrām the. Dātan aur Abīrām wuhī log the jinheṅ jamāt ne chunā thā aur jinhoṅ ne Qorah ke guroh samet Mūsā aur Hārūn se jhagaṛte hue ḳhud Rab se jhagaṛā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Us waqt zamīn ne apnā muṅh khol kar unheṅ Qorah samet haṛap kar liyā thā. Us ke 250 sāthī bhī mar gae the jab āg ne unheṅ bhasm kar diyā. Yoṅ wuh sab Isrāīl ke lie ibratangez misāl ban gae the. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Lekin Qorah kī pūrī nasl miṭāī nahīṅ gaī thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","14","Shamāūn ke qabīle ke 22,200 mard the. Qabīle ke pāṅch kunbe Namuelī, Yamīnī, Yakīnī, Zārhī aur Sāūlī Shamāūn ke beṭoṅ Namuel, Yamīn, Yakīn, Zārah aur Sāūl se nikle hue the. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","18","Jad ke qabīle ke 40,500 mard the. Qabīle ke sāt kunbe Safonī, Hajjī, Sūnī, Uznī, Erī, Arūdī aur Arelī Jad ke beṭoṅ Safon, Hajjī, Sūnī, Uznī, Erī, Arūd aur Arelī se nikle hue the. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","22","Yahūdāh ke qabīle ke 76,500 mard the. Yahūdāh ke do beṭe Er aur Onān Misr āne se pahle Kanān meṅ mar gae the. Qabīle ke tīn kunbe Selānī, Fārsī aur Zārhī Yahūdāh ke beṭoṅ Selā, Fāras aur Zārah se nikle hue the. Fāras ke do beṭoṅ Hasron aur Hamūl se do kunbe Hasronī aur hamūlī nikle hue the. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","25","Ishkār ke qabīle ke 64,300 mard the. Qabīle ke chār kunbe Tolaī, Fuwwī, Yasūbī aur Simronī Ishkār ke beṭoṅ Tolā, Fuwwā, Yasūb aur Simron se nikle hue the. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","27","Zabūlūn ke qabīle ke 60,500 mard the. Qabīle ke tīn kunbe Sardī, Ailonī aur Yahliyelī Zabūlūn ke beṭoṅ sard, Ailon aur Yahliyel se nikle hue the. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Yūsuf ke do beṭoṅ Manassī aur Ifrāīm ke alag alag qabīle bane. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","34","Manassī ke qabīle ke 52,700 mard the. Qabīle ke āṭh kunbe Makīrī, Jiliyādī, Iyazrī, Ḳhalqī, Asriyelī, Sikmī, Samīdāī aur Hifrī the. Makīrī Manassī ke beṭe Makīr se jabki Jiliyādī Makīr ke beṭe Jiliyād se nikle hue the. Bāqī kunbe Jiliyād ke chhih beṭoṅ Iyazar, Ḳhalaq, Asriyel, Sikam, Samīdā aur Hifar se nikle hue the. Hifar Silāfihād kā bāp thā. Silāfihād kā koī beṭā nahīṅ balki pāṅch beṭiyāṅ Mahlāh, Nūsāh, Hujlāh, Milkāh aur Tirzā thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","37","Ifrāīm ke qabīle ke 32,500 mard the. Qabīle ke chār kunbe Sūtalhī, Bakrī, Tahnī aur Īrānī the. Pahle tīn kunbe Ifrāīm ke beṭoṅ Sūtalah, Bakar aur Tahan se jabki Īrānī Sūtalah ke beṭe Īrān se nikle hue the. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","41","Binyamīn ke qabīle ke 45,600 mard the. Qabīle ke sāt kunbe Bālāī, Ashbelī, Aḳhīrāmī, Sūfāmī, Hūfāmī, Ardī aur Nāmānī the. Pahle pāṅch kunbe Binyamīn ke beṭoṅ Bālā, Ashbel, Aḳhīrām, Sūfām aur Hūfām se jabki Ardī aur Nāmānī Bālā ke beṭoṅ se nikle hue the. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","43","Dān ke qabīle ke 64,400 mard the. Sab Dān ke beṭe Sūhām se nikle hue the, is lie Sūhāmī kahlāte the. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","47","Āshar ke qabīle ke 53,400 mard the. Qabīle ke pāṅch kunbe Yimnī, Iswī, Barī'ī, Hibarī aur Malkiyelī the. Pahle tīn kunbe Āshar ke beṭoṅ Yimnā, Iswī aur Bariyā se jabki bāqī Bariyā ke beṭoṅ Hibar aur Malkiyel se nikle hue the. Āshar kī ek beṭī banām Sirah bhī thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","50","Naftālī ke qabīle ke 45,400 mard the. Qabīle ke chār kunbe Yahsiyelī, Jūnī, Yisrī aur Sillīmī Naftālī ke beṭoṅ Yahsiyel, Jūnī, Yisar aur Sillīm se nikle hue the. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Isrāīlī mardoṅ kī kul tādād 6,01,730 thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Jab Mulk-e-Kanān ko taqsīm kiyā jāegā to zamīn in kī tādād ke mutābiq denā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Baṛe qabīloṅ ko chhoṭe kī nisbat zyādā zamīn dī jāe. Har qabīle kā ilāqā us kī tādād se mutābiqat rakhe. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","56","Qurā ḍālne se faislā kiyā jāe ki har qabīle ko kahāṅ zamīn milegī. Lekin har qabīle ke ilāqe kā raqbā is par mabnī ho ki qabīle ke kitne afrād haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Lāwī ke qabīle ke tīn kunbe Jairsonī, Qihātī aur Mirārī Lāwī ke beṭoṅ Jairson, Qihāt aur Mirārī se nikle hue the. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Is ke alāwā Libnī, Hibrūnī, Mahlī, Mūshī aur Korhī bhī Lāwī ke kunbe the. Qihāt Amrām kā bāp thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amrām ne Lāwī aurat Yūkabid se shādī kī jo Misr meṅ paidā huī thī. Un ke do beṭe Hārūn aur Mūsā aur ek beṭī Mariyam paidā hue. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Hārūn ke beṭe Nadab, Abīhū, Iliyazar aur Itamar the. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Lekin Nadab aur Abīhū Rab ko baḳhūr kī nājāyz qurbānī pesh karne ke bāis mar gae. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Lāwiyoṅ ke mardoṅ kī kul tādād 23,000 thī. In meṅ wuh sab shāmil the jo ek māh yā is se zāyd ke the. Unheṅ dūsre Isrāīliyoṅ se alag ginā gayā, kyoṅki unheṅ Isrāīl meṅ mīrās meṅ zamīn nahīṅ milnī thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Yoṅ Mūsā aur Iliyazar ne Moāb ke maidānī ilāqe meṅ Yarīhū ke sāmne lekin Dariyā-e-Yardan ke mashriqī kināre par Isrāīliyoṅ kī mardumshumārī kī. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Logoṅ ko ginte ginte unheṅ mālūm huā ki jo log Dasht-e-Sīn meṅ Mūsā aur Hārūn kī pahlī mardumshumārī meṅ gine gae the wuh sab mar chuke haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Rab ne kahā thā ki wuh sab ke sab registān meṅ mar jāeṅge, aur aisā hī huā thā. Sirf Kālib bin Yafunnā aur Yashua bin Nūn zindā rahe. ");
INSERT INTO urdgvr_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Silāfihād kī pāṅch beṭiyāṅ Mahlāh, Nūsāh, Hujlāh, Milkāh aur Tirzā thīṅ. Silāfihād Yūsuf ke beṭe Manassī ke kunbe kā thā. Us kā pūrā nām Silāfihād bin Hifar bin Jiliyād bin Makīr bin Manassī bin Yūsuf thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Silāfihād kī beṭiyāṅ mulāqāt ke ḳhaime ke darwāze par ā kar Mūsā, Iliyazar Imām aur pūrī jamāt ke sāmne khaṛī huīṅ. Unhoṅ ne kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Hamārā bāp registān meṅ faut huā. Lekin wuh Qorah ke un sāthiyoṅ meṅ se nahīṅ thā jo Rab ke ḳhilāf muttahid hue the. Wuh is sabab se na marā balki apne zātī gunāh ke bāis. Jab wuh mar gayā to us kā koī beṭā nahīṅ thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Kyā yih ṭhīk hai ki hamāre ḳhāndān meṅ beṭā na hone ke bāis hameṅ zamīn na mile aur hamāre bāp kā nām-o-nishān miṭ jāe? Hameṅ bhī hamāre bāp ke dīgar rishtedāroṅ ke sāth zamīn deṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Mūsā ne un kā muāmalā Rab ke sāmne pesh kiyā ");
INSERT INTO urdgvr_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","to Rab ne us se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Jo bāt Silāfihād kī beṭiyāṅ kar rahī haiṅ wuh durust hai. Unheṅ zarūr un ke bāp ke rishtedāroṅ ke sāth zamīn milnī chāhie. Unheṅ bāp kā wirsā mil jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Isrāīliyoṅ ko bhī batānā ki jab bhī koī ādmī mar jāe jis kā beṭā na ho to us kī beṭī ko us kī mīrās mil jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Agar us kī beṭī bhī na ho to us ke bhāiyoṅ ko us kī mīrās mil jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Agar us ke bhāī bhī na hoṅ to us ke bāp ke bhāiyoṅ ko us kī mīrās mil jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Agar yih bhī na hoṅ to us ke sab se qarībī rishtedār ko us kī mīrās mil jāe. Wuh us kī zātī milkiyat hogī. Yih usūl Isrāīliyoṅ ke lie qānūnī haisiyat rakhtā hai. Wuh ise waisā māneṅ jaisā Rab ne Mūsā ko hukm diyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Phir Rab ne Mūsā se kahā, “Abārīm ke pahāṛī silsile ke is pahāṛ par chaṛh kar us mulk par nigāh ḍāl jo maiṅ Isrāīliyoṅ ko dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Use deḳhne ke bād tū bhī apne bhāī Hārūn kī tarah kūch karke apne bāpdādā se jā milegā, ");
INSERT INTO urdgvr_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","kyoṅki tum donoṅ ne Dasht-e-Sīn meṅ mere hukm kī ḳhilāfwarzī kī. Us waqt jab pūrī jamāt ne Marībā meṅ mere ḳhilāf gilā-shikwā kiyā to tū ne chaṭṭān se pānī nikālte waqt logoṅ ke sāmne merī quddūsiyat qāym na rakhī.” (Marībā Dasht-e-Sīn ke Qādis meṅ chashmā hai.) ");
INSERT INTO urdgvr_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mūsā ne Rab se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Ai Rab, tamām jānoṅ ke Ḳhudā, jamāt par kisī ādmī ko muqarrar kar ");
INSERT INTO urdgvr_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","jo un ke āge āge jang ke lie nikle aur un ke āge āge wāpas ā jāe, jo unheṅ bāhar le jāe aur wāpas le āe. Warnā Rab kī jamāt un bheṛoṅ kī mānind hogī jin kā koī charwāhā na ho.” ");
INSERT INTO urdgvr_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Jawāb meṅ Rab ne Mūsā se kahā, “Yashua bin Nūn ko chun le jis meṅ merā Rūh hai, aur apnā hāth us par rakh. ");
INSERT INTO urdgvr_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Use Iliyazar Imām aur pūrī jamāt ke sāmne khaṛā karke un ke rūbarū hī use rāhnumāī kī zimmedārī de. ");
INSERT INTO urdgvr_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Apne iḳhtiyār meṅ se kuchh use de tāki Isrāīl kī pūrī jamāt us kī itā'at kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Rab kī marzī jānane ke lie wuh Iliyazar Imām ke sāmne khaṛā hogā to Iliyazar Rab ke sāmne Ūrīm aur Tummīm istemāl karke us kī marzī dariyāft karegā. Usī ke hukm par Yashua aur Isrāīl kī pūrī jamāt ḳhaimāgāh se nikleṅge aur wāpas āeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mūsā ne aisā hī kiyā. Us ne Yashua ko chun kar Iliyazar aur pūrī jamāt ke sāmne khaṛā kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Phir us ne us par apne hāth rakh kar use rāhnumāī kī zimmedārī sauṅpī jis tarah Rab ne use batāyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Isrāīliyoṅ ko batānā, ḳhayāl rakho ki tum muqarrarā auqāt par mujhe jalne wālī qurbāniyāṅ pesh karo. Yih merī roṭī haiṅ aur in kī ḳhushbū mujhe pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Rab ko jalne wālī yih qurbānī pesh karnā: Rozānā bheṛ ke do yaksālā bachche jo beaib hoṅ pūre taur par jalā denā. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ek ko subah ke waqt pesh karnā aur dūsre ko sūraj ke ḍūbne ke ain bād. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Bheṛ ke bachche ke sāth ġhallā kī nazar bhī pesh kī jāe yānī ḍeṛh kilogrām behtarīn maidā jo ek liṭar zaitūn ke kūṭ kar nikāle hue tel ke sāth milāyā gayā ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Yih rozmarrā kī qurbānī hai jo pūre taur par jalāī jātī hai aur pahlī dafā Sīnā Pahāṛ par chaṛhāī gaī. Is jalne wālī qurbānī kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","8","Sāth hī ek liṭar sharāb bhī nazar ke taur par qurbāngāh par ḍālī jāe. Subah aur shām kī yih qurbāniyāṅ donoṅ hī is tarīqe se pesh kī jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Sabat ke din bheṛ ke do aur bachche chaṛhānā. Wuh bhī beaib aur ek sāl ke hoṅ. Sāth hī mai aur ġhallā kī nazareṅ bhī pesh kī jāeṅ. Ġhallā kī nazar ke lie 3 kilogrām behtarīn maidā tel ke sāth milāyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Bhasm hone wālī yih qurbānī har hafte ke din pesh karnī hai. Yih rozmarrā kī qurbāniyoṅ ke alāwā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Har māh ke shurū meṅ Rab ko bhasm hone wālī qurbānī ke taur par do jawān bail, ek menḍhā aur bheṛ ke sāt yaksālā bachche pesh karnā. Sab baġhair nuqs ke hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Har jānwar ke sāth ġhallā kī nazar pesh karnā jis ke lie tel meṅ milāyā gayā behtarīn maidā istemāl kiyā jāe. Har bail ke sāth sāṛhe 4 kilogrām, har menḍhe ke sāth 3 kilogrām ");
INSERT INTO urdgvr_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","aur bheṛ ke har bachche ke sāth ḍeṛh kilogrām maidā pesh karnā. Bhasm hone wālī yih qurbāniyāṅ Rab ko pasand haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","In qurbāniyoṅ ke sāth mai kī nazar bhī qurbāngāh par ḍālnā yānī har bail ke sāth do liṭar, har menḍhe ke sāth sawā liṭar aur bheṛ ke har bachche ke sāth ek liṭar mai pesh karnā. Yih qurbānī sāl meṅ har mahīne ke pahle din ke mauqe par pesh karnī hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Is qurbānī aur rozmarrā kī qurbāniyoṅ ke alāwā Rab ko ek bakrā gunāh kī qurbānī ke taur par pesh karnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Pahle mahīne ke chaudhweṅ din Fasah kī Īd manāī jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Agle din pūre hafte kī wuh īd shurū hotī hai jis ke daurān tumheṅ sirf beḳhamīrī roṭī khānī hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Pahle din kām na karnā balki muqaddas ijtimā ke lie ikaṭṭhe honā. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Rab ke huzūr bhasm hone wālī qurbānī ke taur par do jawān bail, ek menḍhā aur bheṛ ke sāt yaksālā bachche pesh karnā. Sab baġhair nuqs ke hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Har jānwar ke sāth ġhallā kī nazar bhī pesh karnā jis ke lie tel ke sāth milāyā gayā behtarīn maidā istemāl kiyā jāe. Har bail ke sāth sāṛhe 4 kilogrām, har menḍhe ke sāth 3 kilogrām ");
INSERT INTO urdgvr_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","aur bheṛ ke har bachche ke sāth ḍeṛh kilogrām maidā pesh karnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Gunāh kī qurbānī ke taur par ek bakrā bhī pesh karnā tāki tumhārā kaffārā diyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","24","In tamām qurbāniyoṅ ko īd ke daurān har roz pesh karnā. Yih rozmarrā kī bhasm hone wālī qurbāniyoṅ ke alāwā haiṅ. Is ḳhurāk kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Sātweṅ din kām na karnā balki muqaddas ijtimā ke lie ikaṭṭhe honā. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Fasal kī Kaṭāī ke Pahle Din kī Īd par jab tum Rab ko apnī fasal kī pahlī paidāwār pesh karte ho to kām na karnā balki muqaddas ijtimā ke lie ikaṭṭhe honā. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","29","Us din do jawān bail, ek menḍhā aur bheṛ ke sāt yaksālā bachche qurbāngāh par pūre taur par jalā denā. Is ke sāth ġhallā aur mai kī wuhī nazareṅ pesh karnā jo Fasah kī Īd par bhī pesh kī jātī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Is ke alāwā Rab ko ek bakrā gunāh kī qurbānī ke taur par chaṛhānā. ");
INSERT INTO urdgvr_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Yih tamām qurbāniyāṅ rozmarrā kī bhasm hone wālī qurbāniyoṅ aur un ke sāth wālī ġhallā aur mai kī nazaroṅ ke alāwā haiṅ. Wuh beaib hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Sātweṅ māh ke pandrahweṅ din bhī kām na karnā balki muqaddas ijtimā ke lie ikaṭṭhe honā. Us din narsinge phūṅke jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Rab ko bhasm hone wālī qurbānī pesh kī jāe jis kī ḳhushbū use pasand ho yānī ek jawān bail, ek menḍhā aur bheṛ ke sāt yaksālā bachche. Sab nuqs ke baġhair hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Har jānwar ke sāth ġhallā kī nazar bhī pesh karnā jis ke lie tel ke sāth milāyā gayā behtarīn maidā istemāl kiyā jāe. Bail ke sāth sāṛhe 4 kilogrām, menḍhe ke sāth 3 kilogrām ");
INSERT INTO urdgvr_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","aur bheṛ ke har bachche ke sāth ḍeṛh kilogrām maidā pesh karnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Ek bakrā bhī gunāh kī qurbānī ke taur par pesh karnā tāki tumhārā kaffārā diyā jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Yih qurbāniyāṅ rozānā aur har māh ke pahle din kī qurbāniyoṅ aur un ke sāth kī ġhallā aur mai kī nazaroṅ ke alāwā haiṅ. In kī ḳhushbū Rab ko pasand hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Sātweṅ mahīne ke dasweṅ din muqaddas ijtimā ke lie ikaṭṭhe honā. Us din kām na karnā aur apnī jān ko dukh denā. ");
INSERT INTO urdgvr_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","11","Rab ko wuhī qurbāniyāṅ pesh karnā jo isī mahīne ke pahle din pesh kī jātī haiṅ. Sirf ek farq hai, us din ek nahīṅ balki do bakre gunāh kī qurbānī ke taur par pesh kie jāeṅ tāki tumhārā kaffārā diyā jāe. Aisī qurbāniyāṅ Rab ko pasand haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Sātweṅ mahīne ke pandrahweṅ din bhī kām na karnā balki muqaddas ijtimā ke lie ikaṭṭhe honā. Sāt din tak Rab kī tāzīm meṅ īd manānā. ");
INSERT INTO urdgvr_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Īd ke pahle din Rab ko 13 jawān bail, 2 menḍhe aur 14 bheṛ ke yaksālā bachche bhasm hone wālī qurbānī ke taur par pesh karnā. In kī ḳhushbū use pasand hai. Sab nuqs ke baġhair hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Har jānwar ke sāth ġhallā kī nazar bhī pesh karnā jis ke lie tel se milāyā gayā behtarīn maidā istemāl kiyā jāe. Har bail ke sāth sāṛhe 4 kilogrām, har menḍhe ke sāth 3 kilogrām ");
INSERT INTO urdgvr_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","aur bheṛ ke har bachche ke sāth ḍeṛh kilogrām maidā pesh karnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Is ke alāwā ek bakrā bhī gunāh kī qurbānī ke taur par pesh karnā. Yih qurbāniyāṅ rozānā kī bhasm hone wālī qurbāniyoṅ aur un ke sāth wālī ġhallā aur mai kī nazaroṅ ke alāwā haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","34","Īd ke bāqī chhih din yihī qurbāniyāṅ pesh karnī haiṅ. Lekin har din ek bail kam ho yānī dūsre din 12, tīsre din 11, chauthe din 10, pāṅchweṅ din 9, chhaṭe din 8 aur sātweṅ din 7 bail. Har din gunāh kī qurbānī ke lie bakrā aur māmūl kī rozānā kī qurbāniyāṅ bhī pesh karnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Īd ke āṭhweṅ din kām na karnā balki muqaddas ijtimā ke lie ikaṭṭhe honā. ");
INSERT INTO urdgvr_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Rab ko ek jawān bail, ek menḍhā aur bheṛ ke sāt yaksālā bachche bhasm hone wālī qurbānī ke taur par pesh karnā. In kī ḳhushbū Rab ko pasand hai. Sab nuqs ke baġhair hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","38","Sāth hī wuh tamām qurbāniyāṅ bhī pesh karnā jo pahle din pesh kī jātī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Yih sab wuhī qurbāniyāṅ haiṅ jo tumheṅ Rab ko apnī īdoṅ par pesh karnī haiṅ. Yih un tamām qurbāniyoṅ ke alāwā haiṅ jo tum dilī ḳhushī se yā mannat mān kar dete ho, chāhe wuh bhasm hone wālī, ġhallā kī, mai kī yā salāmatī kī qurbāniyāṅ kyoṅ na hoṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Mūsā ne Rab kī yih tamām hidāyāt Isrāīliyoṅ ko batā dīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Phir Mūsā ne qabīloṅ ke sardāroṅ se kahā, “Rab farmātā hai, ");
INSERT INTO urdgvr_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","agar koī ādmī Rab ko kuchh dene kī mannat māne yā kisī chīz se parhez karne kī qasam khāe to wuh apnī bāt par qāym rah kar use pūrā kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Agar koī jawān aurat jo ab tak apne bāp ke ghar meṅ rahtī hai Rab ko kuchh dene kī mannat māne yā kisī chīz se parhez karne kī qasam khāe ");
INSERT INTO urdgvr_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","to lāzim hai ki wuh apnī mannat yā qasam kī har bāt pūrī kare. Shart yih hai ki us kā bāp us ke bāre meṅ sun kar etarāz na kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Lekin agar us kā bāp yih sun kar use aisā karne se manā kare to us kī mannat yā qasam mansūḳh hai, aur wuh use pūrā karne se barī hai. Rab use muāf karegā, kyoṅki us ke bāp ne use manā kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Ho saktā hai ki kisī ġhairshādīshudā aurat ne mannat mānī yā kisī chīz se parhez karne kī qasam khāī, chāhe us ne dānistā taur par yā besoche-samjhe aisā kiyā. Is ke bād us aurat ne shādī kar lī. ");
INSERT INTO urdgvr_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Shādīshudā hālat meṅ bhī lāzim hai ki wuh apnī mannat yā qasam kī har bāt pūrī kare. Shart yih hai ki us kā shauhar is ke bāre meṅ sun kar etarāz na kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Lekin agar us kā shauhar yih sun kar use aisā karne se manā kare to us kī mannat yā qasam mansūḳh hai, aur wuh use pūrā karne se barī hai. Rab use muāf karegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Agar kisī bewā yā talāqshudā aurat ne mannat mānī yā kisī chīz se parhez karne kī qasam khāī to lāzim hai ki wuh apnī har bāt pūrī kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Agar kisī shādīshudā aurat ne mannat mānī yā kisī chīz se parhez karne kī qasam khāī ");
INSERT INTO urdgvr_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","to lāzim hai ki wuh apnī har bāt pūrī kare. Shart yih hai ki us kā shauhar us ke bāre meṅ sun kar etarāz na kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Lekin agar us kā shauhar use aisā karne se manā kare to us kī mannat yā qasam mansūḳh hai. Wuh use pūrā karne se barī hai. Rab use muāf karegā, kyoṅki us ke shauhar ne use manā kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Chāhe bīwī ne kuchh dene kī mannat mānī ho yā kisī chīz se parhez karne kī qasam khāī ho, us ke shauhar ko us kī tasdīq yā use mansūḳh karne kā iḳhtiyār hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Agar us ne apnī bīwī kī mannat yā qasam ke bāre meṅ sun liyā aur agle din tak etarāz na kiyā to lāzim hai ki us kī bīwī apnī har bāt pūrī kare. Shauhar ne agle din tak etarāz na karne se apnī bīwī kī bāt kī tasdīq kī hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Agar wuh is ke bād yih mannat yā qasam mansūḳh kare to use is qusūr ke natāyj bhugatne paṛeṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Rab ne Mūsā ko yih hidāyāt dīṅ. Yih aisī auratoṅ kī mannatoṅ yā qasmoṅ ke usūl haiṅ jo ġhairshādīshudā hālat meṅ apne bāp ke ghar meṅ rahtī haiṅ yā jo shādīshudā haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Midiyāniyoṅ se Isrāīliyoṅ kā badlā le. Is ke bād tū kūch karke apne bāpdādā se jā milegā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Chunāṅche Mūsā ne Isrāīliyoṅ se kahā, “Hathiyāroṅ se apne kuchh ādmiyoṅ ko les karo tāki wuh Midiyān se jang karke Rab kā badlā leṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Har qabīle ke 1,000 mard jang laṛne ke lie bhejo.” ");
INSERT INTO urdgvr_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Chunāṅche har qabīle ke 1,000 musallah mard yānī kul 12,000 ādmī chune gae. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Tab Mūsā ne unheṅ jang laṛne ke lie bhej diyā. Us ne Iliyazar Imām ke beṭe Fīnhās ko bhī un ke sāth bhejā jis ke pās maqdis kī kuchh chīzeṅ aur elān karne ke bigul the. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Unhoṅ ne Rab ke hukm ke mutābiq Midiyāniyoṅ se jang kī aur tamām ādmiyoṅ ko maut ke ghāṭ utār diyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","In meṅ Midiyāniyoṅ ke pāṅch bādshāh Iwī, Raqam, Sūr, Hūr aur Rabā the. Bilām bin Baor ko bhī jān se mār diyā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Isrāīliyoṅ ne Midiyānī auratoṅ aur bachchoṅ ko giriftār karke un ke tamām gāy-bail, bheṛ-bakriyāṅ aur māl lūṭ liyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Unhoṅ ne un kī tamām ābādiyoṅ ko ḳhaimāgāhoṅ samet jalā kar rākh kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","12","Phir wuh tamām lūṭā huā māl qaidiyoṅ aur jānwaroṅ samet Mūsā, Iliyazar Imām aur Isrāīl kī pūrī jamāt ke pās le āe jo ḳhaimāgāh meṅ intazār kar rahe the. Abhī tak wuh Moāb ke maidānī ilāqe meṅ Dariyā-e-Yardan ke mashriqī kināre par Yarīhū ke sāmne ṭhahre hue the. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mūsā, Iliyazar aur jamāt ke tamām sardār un kā istiqbāl karne ke lie ḳhaimāgāh se nikle. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Unheṅ dekh kar Mūsā ko hazār hazār aur sau sau afrād par muqarrar afsarān par ġhussā āyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Us ne kahā, “Āp ne tamām auratoṅ ko kyoṅ bachāe rakhā? ");
INSERT INTO urdgvr_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Unhīṅ ne Bilām ke mashware par Faġhūr meṅ Isrāīliyoṅ ko Rab se dūr kar diyā thā. Unhīṅ ke sabab se Rab kī wabā us ke logoṅ meṅ phail gaī. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Chunāṅche ab tamām laṛkoṅ ko jān se mār do. Un tamām auratoṅ ko bhī maut ke ghāṭ utārnā jo kuṅwāriyāṅ nahīṅ haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Lekin tamām kuṅwāriyoṅ ko bachāe rakhnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Jis ne bhī kisī ko mār diyā yā kisī lāsh ko chhuā hai wuh sāt din tak ḳhaimāgāh ke bāhar rahe. Tīsre aur sātweṅ din apne āp ko apne qaidiyoṅ samet gunāh se pāk-sāf karnā. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Har libās aur har chīz ko pāk-sāf karnā jo chamṛe, bakriyoṅ ke bāloṅ yā lakaṛī kī ho.” ");
INSERT INTO urdgvr_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Phir Iliyazar Imām ne jang se wāpas āne wāle mardoṅ se kahā, “Jo sharīat Rab ne Mūsā ko dī us ke mutābiq ");
INSERT INTO urdgvr_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","jo bhī chīz jal nahīṅ jātī use āg meṅ se guzār denā tāki pāk-sāf ho jāe. Us meṅ sonā, chāṅdī, pītal, lohā, ṭīn aur sīsā shāmil hai. Phir us par nāpākī dūr karne kā pānī chhiṛaknā. Bāqī tamām chīzeṅ pānī meṅ se guzār denā tāki wuh pāk-sāf ho jāeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Sātweṅ din apne libās ko dhonā to tum pāk-sāf ho kar ḳhaimāgāh meṅ dāḳhil ho sakte ho.” ");
INSERT INTO urdgvr_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Tamām qaidiyoṅ aur lūṭe hue jānwaroṅ ko gin. Is meṅ Iliyazar Imām aur qabāylī kunboṅ ke sarparast terī madad kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Sārā māl do barābar ke hissoṅ meṅ taqsīm karnā, ek hissā faujiyoṅ ke lie aur dūsrā bāqī jamāt ke lie ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Faujiyoṅ ke hisse ke pāṅch pāṅch sau qaidiyoṅ meṅ se ek ek nikāl kar Rab ko denā. Isī tarah pāṅch pāṅch sau bailoṅ, gadhoṅ, bheṛoṅ aur bakriyoṅ meṅ se ek ek nikāl kar Rab ko denā. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Unheṅ Iliyazar Imām ko denā tāki wuh unheṅ Rab ko uṭhāne wālī qurbānī ke taur par pesh kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Bāqī jamāt ke hisse ke pachās pachās qaidiyoṅ meṅ se ek ek nikāl kar Rab ko denā, isī tarah pachās pachās bailoṅ, gadhoṅ, bheṛoṅ aur bakriyoṅ yā dūsre jānwaroṅ meṅ se bhī ek ek nikāl kar Rab ko denā. Unheṅ un Lāwiyoṅ ko denā jo Rab ke maqdis ko saṅbhālte haiṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Mūsā aur Iliyazar ne aisā hī kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","34","Unhoṅ ne 6,75,000 bheṛ-bakriyāṅ, 72,000 gāy-bail aur 61,000 gadhe gine. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","In ke alāwā 32,000 qaidī kuṅwāriyāṅ bhī thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","40","Faujiyoṅ ko tamām chīzoṅ kā ādhā hissā mil gayā yānī 3,37,500 bheṛ-bakriyāṅ, 36,000 gāy-bail, 30,500 gadhe aur 16,000 qaidī kuṅwāriyāṅ. In meṅ se unhoṅ ne 675 bheṛ-bakriyāṅ, 72 gāy-bail, 61 gadhe aur 32 laṛkiyāṅ Rab ko dīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Mūsā ne Rab kā yih hissā Iliyazar Imām ko uṭhāne wālī qurbānī ke taur par de diyā, jis tarah Rab ne hukm diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","47","Bāqī jamāt ko bhī lūṭe hue māl kā ādhā hissā mil gayā. Mūsā ne pachās pachās qaidiyoṅ aur jānwaroṅ meṅ se ek ek nikāl kar un Lāwiyoṅ ko de diyā jo Rab kā maqdis saṅbhālte the. Us ne waisā hī kiyā jaisā Rab ne hukm diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Phir wuh afsar Mūsā ke pās āe jo lashkar ke hazār hazār aur sau sau ādmiyoṅ par muqarrar the. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Unhoṅ ne us se kahā, “Āp ke ḳhādimoṅ ne un faujiyoṅ ko gin liyā hai jin par wuh muqarrar haiṅ, aur hameṅ patā chal gayā ki ek bhī kam nahīṅ huā. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Is lie ham Rab ko sone kā tamām zewar qurbān karnā chāhte haiṅ jo hameṅ fatah pāne par milā thā masalan sone ke bāzūband, kangan, muhr lagāne kī angūṭhiyāṅ, bāliyāṅ aur hār. Yih sab kuchh ham Rab ko pesh karnā chāhte haiṅ tāki Rab ke sāmne hamārā kaffārā ho jāe.” ");
INSERT INTO urdgvr_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Mūsā aur Iliyazar Imām ne sone kī tamām chīzeṅ un se le līṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Jo chīzeṅ unhoṅ ne afsarān ke lūṭe hue māl meṅ se Rab ko uṭhāne wālī qurbānī ke taur par pesh kīṅ un kā pūrā wazn taqrīban 190 kilogrām thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Sirf afsarān ne aisā kiyā. Bāqī faujiyoṅ ne apnā lūṭ kā māl apne lie rakh liyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Mūsā aur Iliyazar afsarān kā yih sonā mulāqāt ke ḳhaime meṅ le āe tāki wuh Rab ko us kī qaum kī yād dilātā rahe. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Rūbin aur Jad ke qabīloṅ ke pās bahut-se maweshī the. Jab unhoṅ ne dekhā ki Yāzer aur Jiliyād kā ilāqā maweshī pālne ke lie achchhā hai ");
INSERT INTO urdgvr_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","to unhoṅ ne Mūsā, Iliyazar Imām aur jamāt ke rāhnumāoṅ ke pās ā kar kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","“Jis ilāqe ko Rab ne Isrāīl kī jamāt ke āge āge shikast dī hai wuh maweshī pālne ke lie achchhā hai. Atārāt, Dībon, Yāzer, Nimrā, Hasbon, Iliyālī, Sabām, Nabū aur Baūn jo is meṅ shāmil haiṅ hamāre kām āeṅge, kyoṅki āp ke ḳhādimoṅ ke pās maweshī haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Agar āp kī nazar-e-karm ham par ho to hameṅ yih ilāqā diyā jāe. Yih hamārī milkiyat ban jāe aur hameṅ Dariyā-e-Yardan ko pār karne par majbūr na kiyā jāe.” ");
INSERT INTO urdgvr_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Mūsā ne Jad aur Rūbin ke afrād se kahā, “Kyā tum yahāṅ pīchhe rah kar apne bhāiyoṅ ko chhoṛnā chāhte ho jab wuh jang laṛne ke lie āge nikleṅge? ");
INSERT INTO urdgvr_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Us waqt jab Isrāīlī Dariyā-e-Yardan ko pār karke us mulk meṅ dāḳhil hone wāle haiṅ jo Rab ne unheṅ diyā hai to tum kyoṅ un kī hauslāshiknī kar rahe ho? ");
INSERT INTO urdgvr_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Tumhāre bāpdādā ne bhī yihī kuchh kiyā jab maiṅ ne unheṅ Qādis-barnīa se mulk ke bāre meṅ mālūmāt hāsil karne ke lie bhejā. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Iskāl kī Wādī meṅ pahuṅch kar mulk kī taftīsh karne ke bād unhoṅ ne Isrāīliyoṅ kī hauslāshiknī kī tāki wuh us mulk meṅ dāḳhil na hoṅ jo Rab ne unheṅ diyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Us din Rab ne ġhusse meṅ ā kar qasam khāī, ");
INSERT INTO urdgvr_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Un ādmiyoṅ meṅ se jo Misr se nikal āe haiṅ koī us mulk ko nahīṅ dekhegā jis kā wādā maiṅ ne qasam khā kar Ibrāhīm, Is'hāq aur Yāqūb se kiyā thā. Kyoṅki unhoṅ ne pūrī wafādārī se merī pairawī na kī. Sirf wuh jin kī umr us waqt 20 sāl se kam hai dāḳhil hoṅge. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Buzurgoṅ meṅ se sirf Kālib bin Yafunnā Qanizzī aur Yashua bin Nūn mulk meṅ dāḳhil hoṅge, is lie ki unhoṅ ne pūrī wafādārī se merī pairawī kī.’ ");
INSERT INTO urdgvr_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Us waqt Rab kā ġhazab un par ān paṛā, aur unheṅ 40 sāl tak registān meṅ māre māre phirnā paṛā, jab tak ki wuh tamām nasl ḳhatm na ho gaī jis ne us ke nazdīk ġhalat kām kiyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Ab tum gunāhgāroṅ kī aulād apne bāpdādā kī jagah khaṛe ho kar Rab kā Isrāīl par ġhussā mazīd baṛhā rahe ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Agar tum us kī pairawī se haṭoge to wuh dubārā in logoṅ ko registān meṅ rahne degā, aur tum in kī halākat kā bāis banoge.” ");
INSERT INTO urdgvr_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Is ke bād Rūbin aur Jad ke afrād dubārā Mūsā ke pās āe aur kahā, “Ham yahāṅ filhāl apne maweshī ke lie bāṛe aur apne bāl-bachchoṅ ke lie shahr banānā chāhte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Is ke bād ham musallah ho kar Isrāīliyoṅ ke āge āge chaleṅge aur har ek ko us kī apnī jagah tak pahuṅchāeṅge. Itne meṅ hamāre bāl-bachche hamāre shahroṅ kī fasīloṅ ke andar mulk ke muḳhālif bāshindoṅ se mahfūz raheṅge. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Ham us waqt tak apne gharoṅ ko nahīṅ lauṭeṅge jab tak har Isrāīlī ko us kī maurūsī zamīn na mil jāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Dūsre, ham ḳhud un ke sāth Dariyā-e-Yardan ke maġhrib meṅ mīrās meṅ kuchh nahīṅ pāeṅge, kyoṅki hameṅ apnī maurūsī zamīn Dariyā-e-Yardan ke mashriqī kināre par mil chukī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Yih sun kar Mūsā ne kahā, “Agar tum aisā hī karoge to ṭhīk hai. Phir Rab ke sāmne jang ke lie taiyār ho jāo ");
INSERT INTO urdgvr_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","aur sab hathiyār bāndh kar Rab ke sāmne Dariyā-e-Yardan ko pār karo. Us waqt tak na lauṭo jab tak Rab ne apne tamām dushmanoṅ ko apne āge se nikāl na diyā ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","Phir jab mulk par Rab kā qabzā ho gayā hogā to tum lauṭ sakoge. Tab tum ne Rab aur apne hamwatan bhāiyoṅ ke lie apne farāyz adā kar die hoṅge, aur yih ilāqā Rab ke sāmne tumhārā maurūsī haq hogā. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Lekin agar tum aisā na karo to phir tum Rab hī kā gunāh karoge. Yaqīn jāno tumheṅ apne gunāh kī sazā milegī. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Ab apne bāl-bachchoṅ ke lie shahr aur apne maweshiyoṅ ke lie bāṛe banā lo. Lekin apne wāde ko zarūr pūrā karnā.” ");
INSERT INTO urdgvr_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Jad aur Rūbin ke afrād ne Mūsā se kahā, “Ham āp ke ḳhādim haiṅ, ham apne āqā ke hukm ke mutābiq hī kareṅge. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Hamāre bāl-bachche aur maweshī yihīṅ Jiliyād ke shahroṅ meṅ raheṅge. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Lekin āp ke ḳhādim musallah ho kar dariyā ko pār kareṅge aur Rab ke sāmne jang kareṅge. Ham sab kuchh waisā hī kareṅge jaisā hamāre āqā ne hameṅ hukm diyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Tab Mūsā ne Iliyazar Imām, Yashua bin Nūn aur qabāylī kunboṅ ke sarparastoṅ ko hidāyat dī, ");
INSERT INTO urdgvr_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“Lāzim hai ki Jad aur Rūbin ke mard musallah ho kar tumhāre sāth hī Rab ke sāmne Dariyā-e-Yardan ko pār kareṅ aur mulk par qabzā kareṅ. Agar wuh aisā kareṅ to unheṅ mīrās meṅ Jiliyād kā ilāqā do. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Lekin agar wuh aisā na kareṅ to phir unheṅ Mulk-e-Kanān hī meṅ tumhāre sāth maurūsī zamīn mile.” ");
INSERT INTO urdgvr_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Jad aur Rūbin ke afrād ne isrār kiyā, “Āp ke ḳhādim sab kuchh kareṅge jo Rab ne kahā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Ham musallah ho kar Rab ke sāmne Dariyā-e-Yardan ko pār kareṅge aur Kanān ke mulk meṅ dāḳhil hoṅge, agarche hamārī maurūsī zamīn Yardan ke mashriqī kināre par hogī.” ");
INSERT INTO urdgvr_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Tab Mūsā ne Jad, Rūbin aur Manassī ke ādhe qabīle ko yih ilāqā diyā. Us meṅ wuh pūrā mulk shāmil thā jis par pahle Amoriyoṅ kā bādshāh Sīhon aur Basan kā bādshāh Oj hukūmat karte the. In shikastḳhurdā mamālik ke dehātoṅ samet tamām shahr un ke hawāle kie gae. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Jad ke qabīle ne Dībon, Atārāt, Aroīr, ");
INSERT INTO urdgvr_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atarāt-shofān, Yāzer, Yugbahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bait-nimrā aur Bait-hārān ke shahroṅ ko dubārā tāmīr kiyā. Unhoṅ ne un kī fasīleṅ banāīṅ aur apne maweshiyoṅ ke lie bāṛe bhī. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Rūbin ke qabīle ne Hasbon, Iliyālī, Qiriyatāym, ");
INSERT INTO urdgvr_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nabū, Bāl-maūn aur Sibmāh dubārā tāmīr kie. Nabū aur Bāl-maūn ke nām badal gae. Kyoṅki unhoṅ ne un shahroṅ ko nae nām die jo unhoṅ ne dubārā tāmīr kie. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Manassī ke beṭe Makīr kī aulād ne Jiliyād jā kar us par qabzā kar liyā aur us ke tamām Amorī bāshindoṅ ko nikāl diyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Chunāṅche Mūsā ne makīriyoṅ ko Jiliyād kī sarzamīn de dī, aur wuh wahāṅ ābād hue. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Manassī ke ek ādmī banām Yāīr ne us ilāqe meṅ kuchh bastiyoṅ par qabzā karke unheṅ Hawwot-yāīr yānī ‘Yāīr kī Bastiyāṅ’ kā nām diyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Isī tarah us qabīle ke ek aur ādmī banām Nūbah ne jā kar Qanāt aur us ke dehātoṅ par qabzā kar liyā. Us ne shahr kā nām Nūbah rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Zail meṅ un jaghoṅ ke nām haiṅ jahāṅ jahāṅ Isrāīlī qabīle apne dastoṅ ke mutābiq Mūsā aur Hārūn kī rāhnumāī meṅ Misr se nikal kar ḳhaimāzan hue the. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Rab ke hukm par Mūsā ne har jagah kā nām qalamband kiyā jahāṅ unhoṅ ne apne ḳhaime lagāe the. Un jaghoṅ ke nām yih haiṅ: ");
INSERT INTO urdgvr_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Pahle mahīne ke pandrahweṅ din Isrāīlī Rāmsīs se rawānā hue. Yānī Fasah ke din ke bād ke din wuh baṛe iḳhtiyār ke sāth tamām Misriyoṅ ke deḳhte deḳhte chale gae. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Misrī us waqt apne pahlauṭhoṅ ko dafn kar rahe the, kyoṅki Rab ne pahlauṭhoṅ ko mār kar un ke dewatāoṅ kī adālat kī thī. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Rāmsīs se Isrāīlī Sukkāt pahuṅch gae jahāṅ unhoṅ ne pahlī martabā apne ḍere lagāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Wahāṅ se wuh Etām pahuṅche jo registān ke kināre par wāqe hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Etām se wuh wāpas muṛ kar Fī-haḳhīrot kī taraf baṛhe jo Bāl-safon ke mashriq meṅ hai. Wuh Mijdāl ke qarīb ḳhaimāzan hue. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Phir wuh Fī-haḳhīrot se kūch karke samundar meṅ se guzar gae. Is ke bād wuh tīn din Etām ke registān meṅ safr karte karte Mārā pahuṅch gae aur wahāṅ apne ḳhaime lagāe. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Mārā se wuh Elīm chale gae jahāṅ 12 chashme aur khajūr ke 70 daraḳht the. Wahāṅ ṭhaharne ke bād ");
INSERT INTO urdgvr_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","wuh Bahr-e-Qulzum ke sāhil par ḳhaimāzan hue, ");
INSERT INTO urdgvr_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","phir Dasht-e-Sīn meṅ pahuṅch gae. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Un ke agle marhale yih the: Dufqā, ");
INSERT INTO urdgvr_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","37","Alūs, Rafīdīm jahāṅ pīne kā pānī dastyāb na thā, Dasht-e-Sīnā, Qabrot-hattāwā, Hasīrāt, Ritmā, Rimmon-fāras, Libnā, Rissā, Qahīlātā, Sāfar Pahāṛ, Harādā, Maqhīlot, Tahat, Tārah, Mitaqā, Hashmūnā, Mausīrot, Banī-yāqān, Hor-hajjidjād, Yutbātā, Abrūnā, Asyūn-jābar, Dasht-e-Sīn meṅ wāqe Qādis aur Hor Pahāṛ jo Adom kī sarhad par wāqe hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Wahāṅ Rab ne Hārūn Imām ko hukm diyā ki wuh Hor Pahāṛ par chaṛh jāe. Wahīṅ wuh pāṅchweṅ māh ke pahle din faut huā. Isrāīliyoṅ ko Misr se nikle 40 sāl guzar chuke the. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Us waqt Hārūn 123 sāl kā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Un dinoṅ meṅ Arād ke Kanānī bādshāh ne sunā ki Isrāīlī mere mulk kī taraf baṛh rahe haiṅ. Wuh Kanān ke junūb meṅ hukūmat kartā thā. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","47","Hor Pahāṛ se rawānā ho kar Isrāīlī zail kī jaghoṅ par ṭhahre: Zalmūnā, Fūnon, Obot, Aiye-abārīm jo Moāb ke ilāqe meṅ thā, Dībon-jad, Almūn-diblātāym aur Nabū ke qarīb wāqe Abārīm kā pahāṛī ilāqā. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Wahāṅ se unhoṅ ne Yardan kī Wādī meṅ utar kar Moāb ke maidānī ilāqe meṅ apne ḍere lagāe. Ab wuh Dariyā-e-Yardan ke mashriqī kināre par Yarīhū Shahr ke sāmne the. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Un ke ḳhaime Bait-yasīmot se le kar Abīl-shittīm tak lage the. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Wahāṅ Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Isrāīliyoṅ ko batānā ki jab tum Dariyā-e-Yardan ko pār karke Mulk-e-Kanān meṅ dāḳhil hoge ");
INSERT INTO urdgvr_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","to lāzim hai ki tum tamām bāshindoṅ ko nikāl do. Un ke tarāshe aur ḍhāle hue butoṅ ko toṛ ḍālo aur un kī ūṅchī jaghoṅ ke mandiroṅ ko tabāh karo. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Mulk par qabzā karke us meṅ ābād ho jāo, kyoṅki maiṅ ne yih mulk tumheṅ de diyā hai. Yih merī taraf se tumhārī maurūsī milkiyat hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Mulk ko muḳhtalif qabīloṅ aur ḳhāndānoṅ meṅ qurā ḍāl kar taqsīm karnā. Har ḳhāndān ke afrād kī tādād kā lihāz rakhnā. Baṛe ḳhāndān ko nisbatan zyādā zamīn denā aur chhoṭe ḳhāndān ko nisbatan kam zamīn. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Lekin agar tum mulk ke bāshindoṅ ko nahīṅ nikāloge to bache hue tumhārī āṅkhoṅ meṅ ḳhār aur tumhāre pahluoṅ meṅ kāṅṭe ban kar tumheṅ us mulk meṅ tang kareṅge jis meṅ tum ābād hoge. ");
INSERT INTO urdgvr_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Phir maiṅ tumhāre sāth wuh kuchh karūṅga jo un ke sāth karnā chāhtā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Isrāīliyoṅ ko batānā ki jab tum us mulk meṅ dāḳhil hoge jo maiṅ tumheṅ mīrās meṅ dūṅgā to us kī sarhaddeṅ yih hoṅgī: ");
INSERT INTO urdgvr_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Us kī junūbī sarhad Dasht-e-Sīn meṅ Adom kī sarhad ke sāth sāth chalegī. Mashriq meṅ wuh Bahīrā-e-Murdār ke junūbī sāhil se shurū hogī, phir in jaghoṅ se ho kar maġhrib kī taraf guzaregī: ");
INSERT INTO urdgvr_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Darrā-e-Aqrabbīm ke junūb meṅ se, Dasht-e-Sīn meṅ se, Qādis-barnīa ke junūb meṅ se Hasar-addār aur Azmūn meṅ se. ");
INSERT INTO urdgvr_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Wahāṅ se wuh muṛ kar Misr kī sarhad par wāqe Wādī-e-Misr ke sāth sāth Bahīrā-e-Rūm tak pahuṅchegī. ");
INSERT INTO urdgvr_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Us kī maġhribī sarhad Bahīrā-e-Rūm kā sāhil hogā. ");
INSERT INTO urdgvr_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Us kī shimālī sarhad Bahīrā-e-Rūm se le kar in jaghoṅ se ho kar mashriq kī taraf guzaregī: Hor Pahāṛ, ");
INSERT INTO urdgvr_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Labo-hamāt, Sidād, ");
INSERT INTO urdgvr_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Zifrūn aur Hasar-enān. Hasar-enān shimālī sarhad kā sab se mashriqī maqām hogā. ");
INSERT INTO urdgvr_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Us kī mashriqī sarhad shimāl meṅ Hasar-enān se shurū hogī. Phir wuh in jaghoṅ se ho kar junūb kī taraf guzaregī: Sifām, ");
INSERT INTO urdgvr_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Riblā jo Ain ke mashriq meṅ hai aur Kinnarat yānī Galīl kī Jhīl ke mashriq meṅ wāqe pahāṛī ilāqā. ");
INSERT INTO urdgvr_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Is ke bād wuh Dariyā-e-Yardan ke kināre kināre guzartī huī Bahīrā-e-Murdār tak pahuṅchegī. Yih tumhāre mulk kī sarhaddeṅ hoṅgī.” ");
INSERT INTO urdgvr_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Mūsā ne Isrāīliyoṅ se kahā, “Yih wuhī mulk hai jise tumheṅ qurā ḍāl kar taqsīm karnā hai. Rab ne hukm diyā hai ki use bāqī sāṛhe nau qabīloṅ ko denā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Kyoṅki aṛhāī qabīloṅ ke ḳhāndānoṅ ko un kī mīrās mil chukī hai yānī Rūbin aur Jad ke pūre qabīle aur Manassī ke ādhe qabīle ko. ");
INSERT INTO urdgvr_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Unheṅ yahāṅ, Dariyā-e-Yardan ke mashriq meṅ Yarīhū ke sāmne zamīn mil chukī hai.” ");
INSERT INTO urdgvr_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Iliyazar Imām aur Yashua bin Nūn logoṅ ke lie mulk taqsīm kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Har qabīle ke ek ek rāhnumā ko bhī chunanā tāki wuh taqsīm karne meṅ madad kare. Jin ko tumheṅ chunanā hai un ke nām yih haiṅ: ");
INSERT INTO urdgvr_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Yahūdāh ke qabīle kā Kālib bin Yafunnā, ");
INSERT INTO urdgvr_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Shamāūn ke qabīle kā Samuel bin Ammīhūd, ");
INSERT INTO urdgvr_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Binyamīn ke qabīle kā Ilīdād bin Kislon, ");
INSERT INTO urdgvr_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Dān ke qabīle kā Buqqī bin Yuglī, ");
INSERT INTO urdgvr_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Manassī ke qabīle kā Hanniyel bin Afūd, ");
INSERT INTO urdgvr_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Ifrāīm ke qabīle kā Qamuel bin Siftān, ");
INSERT INTO urdgvr_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Zabūlūn ke qabīle kā Ilīsafan bin Farnāk, ");
INSERT INTO urdgvr_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Ishkār ke qabīle kā Faltiyel bin Azzān, ");
INSERT INTO urdgvr_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Āshar ke qabīle kā Aḳhīhūd bin Shalūmī, ");
INSERT INTO urdgvr_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Naftālī ke qabīle kā Fidāhel bin Ammīhūd.” ");
INSERT INTO urdgvr_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Rab ne inhīṅ ādmiyoṅ ko mulk ko Isrāīliyoṅ meṅ taqsīm karne kī zimmedārī dī. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Isrāīlī ab tak Moāb ke maidānī ilāqe meṅ Dariyā-e-Yardan ke mashriqī kināre par Yarīhū ke sāmne the. Wahāṅ Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Isrāīliyoṅ ko batā de ki wuh Lāwiyoṅ ko apnī milī huī zamīnoṅ meṅ se rahne ke lie shahr deṅ. Unheṅ shahroṅ ke irdgird maweshī charāne kī zamīn bhī mile. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Phir Lāwiyoṅ ke pās rahne ke lie shahr aur apne jānwar charāne ke lie zamīn hogī. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Charāne ke lie zamīn shahr ke irdgird hogī, aur chāroṅ taraf kā fāsilā fasīloṅ se 1,500 fuṭ ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Charāne kī yih zamīn murabbā shakl kī hogī jis ke har pahlū kā fāsilā 3,000 fuṭ ho. Shahr is murabbā shakl ke bīch meṅ ho. Yih raqbā shahr ke bāshindoṅ ke lie ho tāki wuh apne maweshī charā sakeṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","7","Lāwiyoṅ ko kul 48 shahr denā. In meṅ se chhih panāh ke shahr muqarrar karnā. Un meṅ aise log panāh le sakeṅge jin ke hāthoṅ ġhairirādī taur par koī halāk huā ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Har qabīlā Lāwiyoṅ ko apne ilāqe ke raqbe ke mutābiq shahr de. Jis qabīle kā ilāqā baṛā hai use Lāwiyoṅ ko zyādā shahr dene haiṅ jabki jis qabīle kā ilāqā chhoṭā hai wuh Lāwiyoṅ ko kam shahr de.” ");
INSERT INTO urdgvr_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Phir Rab ne Mūsā se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Isrāīliyoṅ ko batānā ki Dariyā-e-Yardan ko pār karne ke bād ");
INSERT INTO urdgvr_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","kuchh panāh ke shahr muqarrar karnā. Un meṅ wuh shaḳhs panāh le sakegā jis ke hāthoṅ ġhairirādī taur par koī halāk huā ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Wahāṅ wuh intaqām lene wāle se panāh le sakegā aur jamāt kī adālat ke sāmne khaṛe hone se pahle mārā nahīṅ jā sakegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Is ke lie chhih shahr chun lo. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Tīn Dariyā-e-Yardan ke mashriq meṅ aur tīn Mulk-e-Kanān meṅ hoṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Yih chhih shahr har kisī ko panāh deṅge, chāhe wuh Isrāīlī, pardesī yā un ke darmiyān rahne wālā ġhairshahrī ho. Jis se bhī ġhairirādī taur par koī halāk huā ho wuh wahāṅ panāh le saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","18","Agar kisī ne kisī ko jān-būjh kar lohe, patthar yā lakaṛī kī kisī chīz se mār ḍālā ho wuh qātil hai aur use sazā-e-maut denī hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Maqtūl kā sab se qarībī rishtedār use talāsh karke mār de. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","21","Kyoṅki jo nafrat yā dushmanī ke bāis jān-būjh kar kisī ko yoṅ dhakkā de, us par koī chīz phaiṅk de yā use mukkā māre ki wuh mar jāe wuh qātil hai aur use sazā-e-maut denī hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Lekin wuh qātil nahīṅ hai jis se dushmanī ke bāis nahīṅ balki ittafāq se aur ġhairirādī taur par koī halāk huā ho, chāhe us ne use dhakkā diyā, koī chīz us par phaiṅk dī ");
INSERT INTO urdgvr_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","yā koī patthar us par girne diyā. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","Agar aisā huā to lāzim hai ki jamāt in hidāyāt ke mutābiq us ke aur intaqām lene wāle ke darmiyān faislā kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Agar mulzim bequsūr hai to jamāt us kī hifāzat karke use panāh ke us shahr meṅ wāpas le jāe jis meṅ us ne panāh lī hai. Wahāṅ wuh muqaddas tel se masah kie gae imām-e-āzam kī maut tak rahe. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Lekin agar yih shaḳhs is se pahle panāh ke shahr se nikle to wuh mahfūz nahīṅ hogā. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","Agar us kā intaqām lene wāle se sāmnā ho jāe to intaqām lene wāle ko use mār ḍālne kī ijāzat hogī. Agar wuh aisā kare to bequsūr rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Panāh lene wālā imām-e-āzam kī wafāt tak panāh ke shahr meṅ rahe. Is ke bād hī wuh apne ghar wāpas jā saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Yih usūl dāymī haiṅ. Jahāṅ bhī tum rahte ho tumheṅ hameshā in par amal karnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Jis par qatl kā ilzām lagāyā gayā ho use sirf is sūrat meṅ sazā-e-maut dī jā saktī hai ki kam az kam do gawāh hoṅ. Ek gawāh kāfī nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Qātil ko zarūr sazā-e-maut denā. Ḳhāh wuh is se bachne ke lie koī bhī muāwazā de use āzād na chhoṛnā balki sazā-e-maut denā. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Us shaḳhs se bhī paise qabūl na karnā jis se ġhairirādī taur par koī halāk huā ho aur jo is sabab se panāh ke shahr meṅ rah rahā hai. Use ijāzat nahīṅ ki wuh paise de kar panāh kā shahr chhoṛe aur apne ghar wāpas chalā jāe. Lāzim hai ki wuh is ke lie imām-e-āzam kī wafāt kā intazār kare. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Jis mulk meṅ tum rahte ho us kī muqaddas hālat ko nāpāk na karnā. Jab kisī ko us meṅ qatl kiyā jāe to wuh nāpāk ho jātā hai. Jab is tarah ḳhūn bahtā hai to mulk kī muqaddas hālat sirf us shaḳhs ke ḳhūn bahne se bahāl ho jātī hai jis ne yih ḳhūn bahāyā hai. Yānī mulk kā sirf qātil kī maut se hī kaffārā diyā jā saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Us mulk ko nāpāk na karnā jis meṅ tum ābād ho aur jis meṅ maiṅ sukūnat kartā hūṅ. Kyoṅki maiṅ Rab hūṅ jo Isrāīliyoṅ ke darmiyān sukūnat kartā hūṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Ek din Jiliyād bin Makīr bin Manassī bin Yūsuf ke kunbe se nikle hue ābāī gharānoṅ ke sarparast Mūsā aur un sardāroṅ ke pās āe jo dīgar ābāī gharānoṅ ke sarparast the. ");
INSERT INTO urdgvr_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Unhoṅ ne kahā, “Rab ne āp ko hukm diyā thā ki āp qurā ḍāl kar mulk ko Isrāīliyoṅ meṅ taqsīm kareṅ. Us waqt us ne yih bhī kahā thā ki hamāre bhāī Silāfihād kī beṭiyoṅ ko us kī maurūsī zamīn milnī hai. ");
INSERT INTO urdgvr_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Agar wuh Isrāīl ke kisī aur qabīle ke mardoṅ se shādī kareṅ to phir yih zamīn jo hamāre qabīle kā maurūsī hissā hai us qabīle kā maurūsī hissā banegī aur ham us se mahrūm ho jāeṅge. Phir hamārā qabāylī ilāqā chhoṭā ho jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Aur agar ham yih zamīn wāpas bhī ḳharīdeṅ to bhī wuh agle bahālī ke sāl meṅ dūsre qabīle ko wāpas chalī jāegī jis meṅ in auratoṅ ne shādī kī hai. Is tarah wuh hameshā ke lie hamāre hāth se nikal jāegī.” ");
INSERT INTO urdgvr_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Mūsā ne Rab ke hukm par Isrāīliyoṅ ko batāyā, “Jiliyād ke mard haq bajānib haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Is lie Rab kī hidāyat yih hai ki Silāfihād kī beṭiyoṅ ko har ādmī se shādī karne kī ijāzat hai, lekin sirf is sūrat meṅ ki wuh un ke apne qabīle kā ho. ");
INSERT INTO urdgvr_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Is tarah ek qabīle kī maurūsī zamīn kisī dūsre qabīle meṅ muntaqil nahīṅ hogī. Lāzim hai ki har qabīle kā pūrā ilāqā usī ke pās rahe. ");
INSERT INTO urdgvr_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Jo bhī beṭī mīrās meṅ zamīn pātī hai us ke lie lāzim hai ki wuh apne hī qabīle ke kisī mard se shādī kare tāki us kī zamīn qabīle ke pās hī rahe. ");
INSERT INTO urdgvr_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Ek qabīle kī maurūsī zamīn kisī dūsre qabīle ko muntaqil karne kī ijāzat nahīṅ hai. Lāzim hai ki har qabīle kā pūrā maurūsī ilāqā usī ke pās rahe.” ");
INSERT INTO urdgvr_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","11","Silāfihād kī beṭiyoṅ Mahlāh, Tirzā, Hujlāh, Milkāh aur Nūsāh ne waisā hī kiyā jaisā Rab ne Mūsā ko batāyā thā. Unhoṅ ne apne chachāzād bhāiyoṅ se shādī kī. ");
INSERT INTO urdgvr_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Chūṅki wuh bhī Manassī ke qabīle ke the is lie yih maurūsī zamīn Silāfihād ke qabīle ke pās rahī. ");
INSERT INTO urdgvr_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Rab ne yih ahkām aur hidāyāt Isrāīliyoṅ ko Mūsā kī mārifat dīṅ jab wuh Moāb ke maidānī ilāqe meṅ Dariyā-e-Yardan ke mashriqī kināre par Yarīhū ke sāmne ḳhaimāzan the. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Is kitāb meṅ wuh bāteṅ darj haiṅ jo Mūsā ne tamām Isrāīliyoṅ se kahīṅ jab wuh Dariyā-e-Yardan ke mashriqī kināre par bayābān meṅ the. Wuh Yardan kī Wādī meṅ Sūf ke qarīb the. Ek taraf Fārān Shahr thā aur dūsrī taraf Tofal, Lāban, Hasīrāt aur Dīzahab ke shahr the. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Agar Adom ke pahāṛī ilāqe se ho kar jāeṅ to Horib yānī Sīnā Pahāṛ se Qādis-barnīa tak kā safr 11 din meṅ tay kiyā jā saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Isrāīliyoṅ ko Misr se nikle 40 sāl ho gae the. Is sāl ke gyārhweṅ māh ke pahle din Mūsā ne unheṅ sab kuchh batāyā jo Rab ne use unheṅ batāne ko kahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Us waqt wuh Amoriyoṅ ke bādshāh Sīhon ko shikast de chukā thā jis kā dārul-hukūmat Hasbon thā. Basan ke bādshāh Oj par bhī fatah hāsil ho chukī thī jis kī hukūmat ke markaz Astārāt aur Idraī the. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Wahāṅ, Dariyā-e-Yardan ke mashriqī kināre par jo Moāb ke ilāqe meṅ thā Mūsā Allāh kī sharīat kī tashrīh karne lagā. Us ne kahā, ");
INSERT INTO urdgvr_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","jab tum Horib yānī Sīnā Pahāṛ ke pās the to Rab hamāre Ḳhudā ne ham se kahā, “Tum kāfī der se yahāṅ ṭhahre hue ho. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Ab is jagah ko chhoṛ kar āge Mulk-e-Kanān kī taraf baṛho. Amoriyoṅ ke pahāṛī ilāqe aur un ke paṛos kī qaumoṅ ke pās jāo jo Yardan ke maidānī ilāqe meṅ ābād haiṅ. Pahāṛī ilāqe meṅ, maġhrib ke nashebī pahāṛī ilāqe meṅ, junūb ke Dasht-e-Najab meṅ, sāhilī ilāqe meṅ, Mulk-e-Kanān meṅ aur Lubnān meṅ Dariyā-e-Furāt tak chale jāo. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Maiṅ ne tumheṅ yih mulk de diyā hai. Ab jā kar us par qabzā kar lo. Kyoṅki Rab ne qasam khā kar tumhāre bāpdādā Ibrāhīm, Is'hāq aur Yāqūb se wādā kiyā thā ki maiṅ yih mulk tumheṅ aur tumhārī aulād ko dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Us waqt maiṅ ne tum se kahā, “Maiṅ akelā tumhārī rāhnumāī karne kī zimmedārī nahīṅ uṭhā saktā. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Rab tumhāre Ḳhudā ne tumhārī tādād itnī baṛhā dī hai ki āj tum āsmān ke sitāroṅ kī mānind beshumār ho. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Aur Rab tumhāre bāpdādā kā Ḳhudā kare ki tumhārī tādād mazīd hazār gunā baṛh jāe. Wuh tumheṅ wuh barkat de jis kā wādā us ne kiyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Lekin maiṅ akelā hī tumhārā bojh uṭhāne aur jhagaṛoṅ ko nipṭāne kī zimmedārī nahīṅ uṭhā saktā. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Is lie apne har qabīle meṅ se kuchh aise dānishmand aur samajhdār ādmī chun lo jin kī liyāqat ko log mānte haiṅ. Phir maiṅ unheṅ tum par muqarrar karūṅga.” ");
INSERT INTO urdgvr_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Yih bāt tumheṅ pasand āī. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Tum ne apne meṅ se aise rāhnumā chun lie jo dānishmand the aur jin kī liyāqat ko log mānte the. Phir maiṅ ne unheṅ hazār hazār, sau sau aur pachās pachās mardoṅ par muqarrar kiyā. Yoṅ wuh qabīloṅ ke nigahbān ban gae. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Us waqt maiṅ ne un qāziyoṅ se kahā, “Adālat karte waqt har ek kī bāt ġhaur se sun kar ġhairjānibdār faisle karnā, chāhe do Isrāīlī farīq ek dūsre se jhagaṛā kar rahe hoṅ yā muāmalā kisī Isrāīlī aur pardesī ke darmiyān ho. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Adālat karte waqt jānibdārī na karnā. Chhoṭe aur baṛe kī bāt sun kar donoṅ ke sāth ek jaisā sulūk karnā. Kisī se mat ḍarnā, kyoṅki Allāh hī ne tumheṅ adālat karne kī zimmedārī dī hai. Agar kisī muāmale meṅ faislā karnā tumhāre lie mushkil ho to use mujhe pesh karo. Phir maiṅ hī us kā faislā karūṅga.” ");
INSERT INTO urdgvr_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Us waqt maiṅ ne tumheṅ sab kuchh batāyā jo tumheṅ karnā thā. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Ham ne waisā hī kiyā jaisā Rab ne hameṅ kahā thā. Ham Horib se rawānā ho kar Amoriyoṅ ke pahāṛī ilāqe kī taraf baṛhe. Safr karte karte ham us wasī aur haulnāk registān meṅ se guzar gae jise tum ne dekh liyā hai. Āḳhirkār ham Qādis-barnīa pahuṅch gae. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Wahāṅ maiṅ ne tum se kahā, “Tum Amoriyoṅ ke pahāṛī ilāqe tak pahuṅch gae ho jo Rab hamārā Ḳhudā hameṅ dene wālā hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Dekh, Rab tere Ḳhudā ne tujhe yih mulk de diyā hai. Ab jā kar us par qabzā kar le jis tarah Rab tere bāpdādā ke Ḳhudā ne tujhe batāyā hai. Mat ḍarnā aur bedil na ho jānā!” ");
INSERT INTO urdgvr_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Lekin tum sab mere pās āe aur kahā, “Kyoṅ na ham jāne se pahle kuchh ādmī bhejeṅ jo mulk ke hālāt dariyāft kareṅ aur wāpas ā kar hameṅ us rāste ke bāre meṅ batāeṅ jis par hameṅ jānā hai aur un shahroṅ ke bāre meṅ ittalā deṅ jin ke pās ham pahuṅcheṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Yih bāt mujhe pasand āī. Maiṅ ne is kām ke lie har qabīle ke ek ādmī ko chun kar bhej diyā. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Jab yih bārah ādmī pahāṛī ilāqe meṅ jā kar Wādī-e-Iskāl meṅ pahuṅche to us kī taftīsh kī. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Phir wuh mulk kā kuchh phal le kar lauṭ āe aur hameṅ mulk ke bāre meṅ ittalā de kar kahā, “Jo mulk Rab hamārā Ḳhudā hameṅ dene wālā hai wuh achchhā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Lekin tum jānā nahīṅ chāhte the balki sarkashī karke Rab apne Ḳhudā kā hukm na mānā. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Tum ne apne ḳhaimoṅ meṅ buṛbuṛāte hue kahā, “Rab ham se nafrat rakhtā hai. Wuh hameṅ Misr se nikāl lāyā hai tāki hameṅ Amoriyoṅ ke hāthoṅ halāk karwāe. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Ham kahāṅ jāeṅ? Hamāre bhāiyoṅ ne hameṅ bedil kar diyā hai. Wuh kahte haiṅ, ‘Wahāṅ ke log ham se tāqatwar aur darāzqad haiṅ. Un ke baṛe baṛe shahroṅ kī fasīleṅ āsmān se bāteṅ kartī haiṅ. Wahāṅ ham ne Anāq kī aulād bhī dekhī jo dewqāmat haiṅ.’” ");
INSERT INTO urdgvr_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Maiṅ ne kahā, “Na ghabrāo aur na un se ḳhauf khāo. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Rab tumhārā Ḳhudā tumhāre āge āge chaltā huā tumhāre lie laṛegā. Tum ḳhud dekh chuke ho ki wuh kis tarah Misr ");
INSERT INTO urdgvr_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","aur registān meṅ tumhāre lie laṛā. Yahāṅ bhī wuh aisā hī karegā. Tū ḳhud gawāh hai ki bayābān meṅ pūre safr ke daurān Rab tujhe yoṅ uṭhāe phirā jis tarah bāp apne beṭe ko uṭhāe phirtā hai. Is tarah chalte chalte tum yahāṅ tak pahuṅch gae.” ");
INSERT INTO urdgvr_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Is ke bāwujūd tum ne Rab apne Ḳhudā par bharosā na rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","Tum ne yih bāt nazarandāz kī ki wuh safr ke daurān rāt ke waqt āg aur din ke waqt bādal kī sūrat meṅ tumhāre āge āge chaltā rahā tāki tumhāre lie ḳhaime lagāne kī jagheṅ mālūm kare aur tumheṅ rāstā dikhāe. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Jab Rab ne tumhārī yih bāteṅ sunīṅ to use ġhussā āyā aur us ne qasam khā kar kahā, ");
INSERT INTO urdgvr_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Is sharīr nasl kā ek mard bhī us achchhe mulk ko nahīṅ dekhegā agarche maiṅ ne qasam khā kar tumhāre bāpdādā se wādā kiyā thā ki maiṅ use unheṅ dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Sirf Kālib bin Yafunnā use dekhegā. Maiṅ use aur us kī aulād ko wuh mulk dūṅgā jis meṅ us ne safr kiyā hai, kyoṅki us ne pūre taur par Rab kī pairawī kī.” ");
INSERT INTO urdgvr_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Tumhārī wajah se Rab mujh se bhī nārāz huā aur kahā, “Tū bhī us meṅ dāḳhil nahīṅ hogā. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Lekin terā madadgār Yashua bin Nūn dāḳhil hogā. Us kī hauslā-afzāī kar, kyoṅki wuh mulk par qabzā karne meṅ Isrāīl kī rāhnumāī karegā.” ");
INSERT INTO urdgvr_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Tum se Rab ne kahā, “Tumhāre bachche jo abhī achchhe aur bure meṅ imtiyāz nahīṅ kar sakte, wuhī mulk meṅ dāḳhil hoṅge, wuhī bachche jin ke bāre meṅ tum ne kahā ki dushman unheṅ Mulk-e-Kanān meṅ chhīn leṅge. Unheṅ maiṅ mulk dūṅgā, aur wuh us par qabzā kareṅge. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Lekin tum ḳhud āge na baṛho. Pīchhe muṛ kar dubārā registān meṅ Bahr-e-Qulzum kī taraf safr karo.” ");
INSERT INTO urdgvr_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Tab tum ne kahā, “Ham ne Rab kā gunāh kiyā hai. Ab ham mulk meṅ jā kar laṛeṅge, jis tarah Rab hamāre Ḳhudā ne hameṅ hukm diyā hai.” Chunāṅche yih sochte hue ki us pahāṛī ilāqe par hamlā karnā āsān hogā, har ek musallah huā. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Lekin Rab ne mujh se kahā, “Unheṅ batānā ki wahāṅ jang karne ke lie na jāo, kyoṅki maiṅ tumhāre sāth nahīṅ hūṅgā. Tum apne dushmanoṅ ke hāthoṅ shikast khāoge.” ");
INSERT INTO urdgvr_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Maiṅ ne tumheṅ yih batāyā, lekin tum ne merī na sunī. Tum ne sarkashī karke Rab kā hukm na mānā balki maġhrūr ho kar pahāṛī ilāqe meṅ dāḳhil hue. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Wahāṅ ke Amorī bāshinde tumhārā sāmnā karne nikle. Wuh shahd kī makkhiyoṅ ke ġhol kī tarah tum par ṭūṭ paṛe aur tumhārā tāqqub karke tumheṅ Saīr se Hurmā tak mārte gae. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Tab tum wāpas ā kar Rab ke sāmne zār-o-qatār rone lage. Lekin us ne tawajjuh na dī balki tumheṅ nazarandāz kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Is ke bād tum bahut dinoṅ tak Qādis-barnīa meṅ rahe. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Phir jis tarah Rab ne mujhe hukm diyā thā ham pīchhe muṛ kar registān meṅ Bahr-e-Qulzum kī taraf safr karne lage. Kāfī der tak ham Saīr yānī Adom ke pahāṛī ilāqe ke kināre kināre phirte rahe. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Ek din Rab ne mujh se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Tum bahut der se is pahāṛī ilāqe ke kināre kināre phir rahe ho. Ab shimāl kī taraf safr karo. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Qaum ko batānā, agle dinoṅ meṅ tum Saīr ke mulk meṅ se guzaroge jahāṅ tumhāre bhāī Esau kī aulād ābād hai. Wuh tum se ḍareṅge. To bhī baṛī ehtiyāt se guzarnā. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Un ke sāth jang na chheṛnā, kyoṅki maiṅ tumheṅ un ke mulk kā ek murabbā fuṭ bhī nahīṅ dūṅgā. Maiṅ ne Saīr kā pahāṛī ilāqā Esau aur us kī aulād ko diyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Lāzim hai ki tum khāne aur pīne kī tamām zarūriyāt paise de kar ḳharīdo.” ");
INSERT INTO urdgvr_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Jo bhī kām tū ne kiyā hai Rab ne us par barkat dī hai. Is wasī registān meṅ pūre safr ke daurān us ne terī nigahbānī kī. In 40 sāloṅ ke daurān Rab terā Ḳhudā tere sāth thā, aur terī tamām zarūriyāt pūrī hotī rahīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Chunāṅche ham Saīr ko chhoṛ kar jahāṅ hamāre bhāī Esau kī aulād ābād thī dūsre rāste se āge nikle. Ham ne wuh rāstā chhoṛ diyā jo Ailāt aur Asyūn-jābar ke shahroṅ se Bahīrā-e-Murdār tak pahuṅchātā hai aur Moāb ke bayābān kī taraf baṛhne lage. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Wahāṅ Rab ne mujh se kahā, “Moāb ke bāshindoṅ kī muḳhālafat na karnā aur na un ke sāth jang chheṛnā, kyoṅki maiṅ un ke mulk kā koī bhī hissā tujhe nahīṅ dūṅgā. Maiṅ ne Ār Shahr ko Lūt kī aulād ko diyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Pahle Aimī wahāṅ rahte the jo Anāq kī aulād kī tarah tāqatwar, darāzqad aur tādād meṅ zyādā the. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Anāq kī aulād kī tarah wuh Rafāiyoṅ meṅ shumār kie jāte the, lekin Moābī unheṅ Aimī kahte the. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Isī tarah qadīm zamāne meṅ Horī Saīr meṅ ābād the, lekin Esau kī aulād ne unheṅ wahāṅ se nikāl diyā thā. Jis tarah Isrāīliyoṅ ne bād meṅ us mulk meṅ kiyā jo Rab ne unheṅ diyā thā usī tarah Esau kī aulād baṛhte baṛhte Horiyoṅ ko tabāh karke un kī jagah ābād hue the. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Rab ne kahā, “Ab jā kar Wādī-e-Zirad ko ubūr karo.” Ham ne aisā hī kiyā. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Hameṅ Qādis-barnīa se rawānā hue 38 sāl ho gae the. Ab wuh tamām ādmī mar chuke the jo us waqt jang karne ke qābil the. Waisā hī huā thā jaisā Rab ne qasam khā kar kahā thā. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Rab kī muḳhālafat ke bāis āḳhirkār ḳhaimāgāh meṅ us nasl kā ek mard bhī na rahā. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Jab wuh sab mar gae the ");
INSERT INTO urdgvr_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","tab Rab ne mujh se kahā, ");
INSERT INTO urdgvr_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Āj tumheṅ Ār Shahr se ho kar Moāb ke ilāqe meṅ se guzarnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Phir tum Ammoniyoṅ ke ilāqe tak pahuṅchoge. Un kī bhī muḳhālafat na karnā, aur na un ke sāth jang chheṛnā, kyoṅki maiṅ un ke mulk kā koī bhī hissā tumheṅ nahīṅ dūṅgā. Maiṅ ne yih mulk Lūt kī aulād ko diyā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Haqīqat meṅ Ammoniyoṅ kā mulk bhī Rafāiyoṅ kā mulk samjhā jātā thā jo qadīm zamāne meṅ wahāṅ ābād the. Ammonī unheṅ zamzumī kahte the, ");
INSERT INTO urdgvr_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","aur wuh dewqāmat the, tāqatwar aur tādād meṅ zyādā. Wuh Anāq kī aulād jaise darāzqad the. Jab Ammonī mulk meṅ āe to Rab ne Rafāiyoṅ ko un ke āge āge tabāh kar diyā. Chunāṅche Ammonī baṛhte baṛhte unheṅ nikālte gae aur un kī jagah ābād hue, ");
INSERT INTO urdgvr_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","bilkul usī tarah jis tarah Rab ne Esau kī aulād ke āge āge Horiyoṅ ko tabāh kar diyā thā jab wuh Saīr ke mulk meṅ āe the. Wahāṅ bhī wuh baṛhte baṛhte Horiyoṅ ko nikālte gae aur un kī jagah ābād hue. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Isī tarah ek aur qadīm qaum banām Awwī ko bhī us ke mulk se nikālā gayā. Awwī Ġhazzā tak ābād the, lekin jab Kaftūrī Kaftūr yānī Krete se āe to unhoṅ ne unheṅ tabāh kar diyā aur un kī jagah ābād ho gae. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Rab ne Mūsā se kahā, “Ab jā kar Wādī-e-Arnon ko ubūr karo. Yoṅ samjho ki maiṅ Hasbon ke Amorī bādshāh Sīhon ko us ke mulk samet tumhāre hawāle kar chukā hūṅ. Us par qabzā karnā shurū karo aur us ke sāth jang karne kā mauqā ḍhūnḍo. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Isī din se maiṅ tamām qaumoṅ meṅ tumhāre bāre meṅ dahshat aur ḳhauf paidā karūṅga. Wuh tumhārī ḳhabar sun kar ḳhauf ke māre thartharāeṅgī aur kāṅpeṅgī.” ");
INSERT INTO urdgvr_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Maiṅ ne Dasht-e-Qadīmāt se Hasbon ke bādshāh Sīhon ke pās qāsid bheje. Merā paiġhām nafrat aur muḳhālafat se ḳhālī thā. Wuh yih thā, ");
INSERT INTO urdgvr_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“Hameṅ apne mulk meṅ se guzarne deṅ. Ham shāhrāh par hī raheṅge aur us se na bāīṅ, na dāīṅ taraf haṭeṅge. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Ham khāne aur pīne kī tamām zarūriyāt ke lie munāsib paise deṅge. Hameṅ paidal apne mulk meṅ se guzarne deṅ, ");
INSERT INTO urdgvr_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","jis tarah Saīr ke bāshindoṅ Esau kī aulād aur Ār ke rahne wāle Moābiyoṅ ne hameṅ guzarne diyā. Kyoṅki hamārī manzil Dariyā-e-Yardan ke maġhrib meṅ hai, wuh mulk jo Rab hamārā Ḳhudā hameṅ dene wālā hai.” ");
INSERT INTO urdgvr_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Lekin Hasbon ke bādshāh Sīhon ne hameṅ guzarne na diyā, kyoṅki Rab tumhāre Ḳhudā ne use belachak aur hamārī bāt se inkār karne par āmādā kar diyā thā tāki Sīhon hamāre qābū meṅ ā jāe. Aur bād meṅ aisā hī huā. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Rab ne mujh se kahā, “Yoṅ samajh le ki maiṅ Sīhon aur us ke mulk ko tere hawāle karne lagā hūṅ. Ab nikal kar us par qabzā karnā shurū karo.” ");
INSERT INTO urdgvr_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Jab Sīhon apnī sārī fauj le kar hamārā muqābalā karne ke lie Yahaz āyā ");
INSERT INTO urdgvr_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","to Rab hamāre Ḳhudā ne hameṅ pūrī fatah baḳhshī. Ham ne Sīhon, us ke beṭoṅ aur pūrī qaum ko shikast dī. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Us waqt ham ne us ke tamām shahroṅ par qabzā kar liyā aur un ke tamām mardoṅ, auratoṅ aur bachchoṅ ko mār ḍālā. Koī bhī na bachā. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Ham ne sirf maweshī aur shahroṅ kā lūṭā huā māl apne lie bachāe rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Wādī-e-Arnon ke kināre par wāqe Aroīr se le kar Jiliyād tak har shahr ko shikast mānanī paṛī. Is meṅ wuh shahr bhī shāmil thā jo Wādī-e-Arnon meṅ thā. Rab hamāre Ḳhudā ne un sab ko hamāre hawāle kar diyā. ");
INSERT INTO urdgvr_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Lekin tum ne Ammoniyoṅ kā mulk chhoṛ diyā aur na Dariyā-e-Yabboq ke irdgird ke ilāqe, na us ke pahāṛī ilāqe ke shahroṅ ko chheṛā, kyoṅki Rab hamāre Ḳhudā ne aisā karne se tumheṅ manā kiyā thā. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Is ke bād ham shimāl meṅ Basan kī taraf baṛh gae. Basan kā bādshāh Oj apnī tamām fauj ke sāth nikal kar hamārā muqābalā karne ke lie Idraī āyā. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Rab ne mujh se kahā, “Us se mat ḍar. Maiṅ use, us kī pūrī fauj aur us kā mulk tere hawāle kar chukā hūṅ. Us ke sāth wuh kuchh kar jo tū ne Amorī bādshāh Sīhon ke sāth kiyā jo Hasbon meṅ hukūmat kartā thā.” ");
INSERT INTO urdgvr_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Aisā hī huā. Rab hamāre Ḳhudā kī madad se ham ne Basan ke bādshāh Oj aur us kī tamām qaum ko shikast dī. Ham ne sab ko halāk kar diyā. Koī bhī na bachā. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Usī waqt ham ne us ke tamām shahroṅ par qabzā kar liyā. Ham ne kul 60 shahroṅ par yānī Arjūb ke sāre ilāqe par qabzā kiyā jis par Oj kī hukūmat thī. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","In tamām shahroṅ kī hifāzat ūṅchī ūṅchī fasīloṅ aur kunḍe wāle darwāzoṅ se kī gaī thī. Dehāt meṅ bahut-sī aisī ābādiyāṅ bhī mil gaīṅ jin kī fasīleṅ nahīṅ thīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Ham ne un ke sāth wuh kuchh kiyā jo ham ne Hasbon ke bādshāh Sīhon ke ilāqe ke sāth kiyā thā. Ham ne sab kuchh Rab ke hawāle karke har shahr ko aur tamām mardoṅ, auratoṅ aur bachchoṅ ko halāk kar ḍālā. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Ham ne sirf tamām maweshī aur shahroṅ kā lūṭā huā māl apne lie bachāe rakhā. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Yoṅ ham ne us waqt Amoriyoṅ ke in do bādshāhoṅ se Dariyā-e-Yardan kā mashriqī ilāqā Wādī-e-Arnon se le kar Harmūn Pahāṛ tak chhīn liyā. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Saidā ke bāshinde Harmūn ko Siryūn kahte haiṅ jabki Amoriyoṅ ne us kā nām Sanīr rakhā.) ");
INSERT INTO urdgvr_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Ham ne Oj Bādshāh ke pūre ilāqe par qabzā kar liyā. Is meṅ maidān-e-murtafā ke tamām shahr shāmil the, nīz Salkā aur Idraī tak Jiliyād aur Basan ke pūre ilāqe. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Bādshāh Oj dewqāmat qabīle Rafāī kā āḳhirī mard thā. Us kā lohe kā tābūt 13 se zāyd fuṭ lambā aur chhih fuṭ chauṛā thā aur āj tak Ammoniyoṅ ke shahr Rabbā meṅ dekhā jā saktā hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Jab ham ne Dariyā-e-Yardan ke mashriqī ilāqe par qabzā kiyā to maiṅ ne Rūbin aur Jad ke qabīloṅ ko us kā junūbī hissā shahroṅ samet diyā. Is ilāqe kī junūbī sarhad Dariyā-e-Arnon par wāqe shahr Aroīr hai jabki shimāl meṅ is meṅ Jiliyād ke pahāṛī ilāqe kā ādhā hissā bhī shāmil hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Jiliyād kā shimālī hissā aur Basan kā mulk maiṅ ne Manassī ke ādhe qabīle ko diyā. (Basan meṅ Arjūb kā ilāqā hai jahāṅ pahle Oj Bādshāh kī hukūmat thī aur jo Rafāiyoṅ yānī Dewqāmat Afrād kā Mulk kahlātā thā. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Manassī ke qabīle ke ek ādmī banām Yāīr ne Arjūb par Jasūriyoṅ aur Mākātiyoṅ kī sarhad tak qabzā kar liyā thā. Us ne is ilāqe kī bastiyoṅ ko apnā nām diyā. Āj tak yihī nām Hawwot-yāīr yānī Yāīr kī Bastiyāṅ chaltā hai.) ");
INSERT INTO urdgvr_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Maiṅ ne Jiliyād kā shimālī hissā Manassī ke kunbe Makīr ko diyā ");
INSERT INTO urdgvr_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","lekin Jiliyād kā junūbī hissā Rūbin aur Jad ke qabīloṅ ko diyā. Is hisse kī ek sarhad junūb meṅ Wādī-e-Arnon ke bīch meṅ se guzartī hai jabki dūsrī sarhad Dariyā-e-Yabboq hai jis ke pār Ammoniyoṅ kī hukūmat hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Us kī maġhribī sarhad Dariyā-e-Yardan hai yānī Kinnarat (Galīl) kī Jhīl se le kar Bahīrā-e-Murdār tak jo Pisgā ke pahāṛī silsile ke dāman meṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Us waqt maiṅ ne Rūbin, Jad aur Manassī ke qabīloṅ se kahā, “Rab tumhāre Ḳhudā ne tumheṅ mīrās meṅ yih mulk de diyā hai. Lekin shart yih hai ki tumhāre tamām jang karne ke qābil mard musallah ho kar tumhāre Isrāīlī bhāiyoṅ ke āge āge Dariyā-e-Yardan ko pār kareṅ. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Sirf tumhārī aurateṅ aur bachche pīchhe rah kar un shahroṅ meṅ intazār kar sakte haiṅ jo maiṅ ne tumhāre lie muqarrar kie haiṅ. Tum apne maweshiyoṅ ko bhī pīchhe chhoṛ sakte ho, kyoṅki mujhe patā hai ki tumhāre bahut zyādā jānwar haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Apne bhāiyoṅ ke sāth chalte hue un kī madad karte raho. Jab Rab tumhārā Ḳhudā unheṅ Dariyā-e-Yardan ke maġhrib meṅ wāqe mulk degā aur wuh tumhārī tarah ārām aur sukūn se wahāṅ ābād ho jāeṅge tab tum apne mulk meṅ wāpas jā sakte ho.” ");
INSERT INTO urdgvr_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Sāth sāth maiṅ ne Yashua se kahā, “Tū ne apnī āṅkhoṅ se sab kuchh dekh liyā hai jo Rab tumhāre Ḳhudā ne in donoṅ bādshāhoṅ Sīhon aur Oj se kiyā. Wuh yihī kuchh har us bādshāh ke sāth karegā jis ke mulk par tū dariyā ko pār karke hamlā karegā. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Un se na ḍaro. Tumhārā Ḳhudā ḳhud tumhāre lie jang karegā.” ");
INSERT INTO urdgvr_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Us waqt maiṅ ne Rab se iltijā karke kahā, ");
INSERT INTO urdgvr_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“Ai Rab Qādir-e-mutlaq, tū apne ḳhādim ko apnī azmat aur qudrat dikhāne lagā hai. Kyā āsmān yā zamīn par koī aur Ḳhudā hai jo terī tarah ke azīm kām kar saktā hai? Hargiz nahīṅ! ");
INSERT INTO urdgvr_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Mehrbānī karke mujhe bhī Dariyā-e-Yardan ko pār karke us achchhe mulk yānī us behtarīn pahāṛī ilāqe ko Lubnān tak deḳhne kī ijāzat de.” ");
INSERT INTO urdgvr_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Lekin tumhāre sabab se Rab mujh se nārāz thā. Us ne merī na sunī balki kahā, “Bas kar! Āindā mere sāth is kā zikr na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Pisgā kī choṭī par chaṛh kar chāroṅ taraf nazar dauṛā. Wahāṅ se ġhaur se dekh, kyoṅki tū ḳhud Dariyā-e-Yardan ko ubūr nahīṅ karegā. ");
INSERT INTO urdgvr_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Apnī jagah Yashua ko muqarrar kar. Us kī hauslā-afzāī kar aur use mazbūt kar, kyoṅki wuhī is qaum ko Dariyā-e-Yardan ke maġhrib meṅ le jāegā aur qabīloṅ meṅ us mulk ko taqsīm karegā jise tū pahāṛ se dekhegā.” ");
INSERT INTO urdgvr_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Chunāṅche ham Bait-faġhūr ke qarīb wādī meṅ ṭhahre. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Ai Isrāīl, ab wuh tamām ahkām dhyān se sun le jo maiṅ tumheṅ sikhātā hūṅ. Un par amal karo tāki tum zindā raho aur jā kar us mulk par qabzā karo jo Rab tumhāre bāpdādā kā Ḳhudā tumheṅ dene wālā hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Jo ahkām maiṅ tumheṅ sikhātā hūṅ un meṅ na kisī bāt kā izāfā karo aur na un se koī bāt nikālo. Rab apne Ḳhudā ke tamām ahkām par amal karo jo maiṅ ne tumheṅ die haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Tum ne ḳhud dekhā hai ki Rab ne Bāl-faġhūr se kyā kuchh kiyā. Wahāṅ Rab tere Ḳhudā ne har ek ko halāk kar ḍālā jis ne Faġhūr ke Bāl Dewatā kī pūjā kī. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Lekin tum meṅ se jitne Rab apne Ḳhudā ke sāth lipṭe rahe wuh sab āj tak zindā haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Maiṅ ne tumheṅ tamām ahkām yoṅ sikhā die haiṅ jis tarah Rab mere Ḳhudā ne mujhe batāyā. Kyoṅki lāzim hai ki tum us mulk meṅ in ke tābe raho jis par tum qabzā karne wāle ho. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Inheṅ māno aur in par amal karo to dūsrī qaumoṅ ko tumhārī dānishmandī aur samajh nazar āegī. Phir wuh in tamām ahkām ke bāre meṅ sun kar kaheṅgī, “Wāh, yih azīm qaum kaisī dānishmand aur samajhdār hai!” ");
INSERT INTO urdgvr_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Kaun-sī azīm qaum ke mābūd itne qarīb haiṅ jitnā hamārā Ḳhudā hamāre qarīb hai? Jab bhī ham madad ke lie pukārte haiṅ to Rab hamārā Ḳhudā maujūd hotā hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Kaun-sī azīm qaum ke pās aise munsifānā ahkām aur hidāyāt haiṅ jaise maiṅ āj tumheṅ pūrī sharīat sunā kar pesh kar rahā hūṅ? ");
INSERT INTO urdgvr_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Lekin ḳhabardār, ehtiyāt karnā aur wuh tamām bāteṅ na bhūlnā jo terī āṅkhoṅ ne dekhī haiṅ. Wuh umr-bhar tere dil meṅ se miṭ na jāeṅ balki unheṅ apne bachchoṅ aur pote-potiyoṅ ko bhī batāte rahnā. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Wuh din yād kar jab tū Horib yānī Sīnā Pahāṛ par Rab apne Ḳhudā ke sāmne hāzir thā aur us ne mujhe batāyā, “Qaum ko yahāṅ mere pās jamā kar tāki maiṅ un se bāt karūṅ aur wuh umr-bhar merā ḳhauf māneṅ aur apne bachchoṅ ko merī bāteṅ sikhāte raheṅ.” ");
INSERT INTO urdgvr_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Us waqt tum qarīb ā kar pahāṛ ke dāman meṅ khaṛe hue. Wuh jal rahā thā, aur us kī āg āsmān tak bhaṛak rahī thī jabki kāle bādaloṅ aur gahre andhere ne use nazaroṅ se chhupā diyā. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Phir Rab āg meṅ se tum se hamkalām huā. Tum ne us kī bāteṅ sunīṅ lekin us kī koī shakl na dekhī. Sirf us kī āwāz sunāī dī. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Us ne tumhāre lie apne ahd yānī un 10 ahkām kā elān kiyā aur hukm diyā ki in par amal karo. Phir us ne unheṅ patthar kī do taḳhtiyoṅ par likh diyā. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Rab ne mujhe hidāyat kī, “Unheṅ wuh tamām ahkām sikhā jin ke mutābiq unheṅ chalnā hogā jab wuh Dariyā-e-Yardan ko pār karke Kanān par qabzā kareṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Jab Rab Horib yānī Sīnā Pahāṛ par tum se hamkalām huā to tum ne us kī koī shakl na dekhī. Chunāṅche ḳhabardār raho ");
INSERT INTO urdgvr_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","ki tum ġhalat kām karke apne lie kisī bhī shakl kā but na banāo. Na mard, aurat, ");
INSERT INTO urdgvr_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","zamīn par chalne wāle jānwar, parinde, ");
INSERT INTO urdgvr_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","reṅgne wāle jānwar yā machhlī kā but banāo. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Jab tū āsmān kī taraf nazar uṭhā kar āsmān kā pūrā lashkar dekhe to sūraj, chāṅd aur sitāroṅ kī parastish aur ḳhidmat karne kī āzmāish meṅ na paṛnā. Rab tere Ḳhudā ne in chīzoṅ ko bāqī tamām qaumoṅ ko atā kiyā hai, ");
INSERT INTO urdgvr_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","lekin tumheṅ us ne Misr ke bhaṛakte bhaṭṭe se nikālā hai tāki tum us kī apnī qaum aur us kī mīrās ban jāo. Aur āj aisā hī huā hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Tumhāre sabab se Rab ne mujh se nārāz ho kar qasam khāī ki tū Dariyā-e-Yardan ko pār karke us achchhe mulk meṅ dāḳhil nahīṅ hogā jo Rab terā Ḳhudā tujhe mīrās meṅ dene wālā hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Maiṅ yihīṅ isī mulk meṅ mar jāūṅgā aur Dariyā-e-Yardan ko pār nahīṅ karūṅga. Lekin tum dariyā ko pār karke us behtarīn mulk par qabzā karoge. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Har sūrat meṅ wuh ahd yād rakhnā jo Rab tumhāre Ḳhudā ne tumhāre sāth bāndhā hai. Apne lie kisī bhī chīz kī mūrat na banānā. Yih Rab kā hukm hai, ");
INSERT INTO urdgvr_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","kyoṅki Rab terā Ḳhudā bhasm kar dene wālī āg hai, wuh ġhayūr Ḳhudā hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Tum mulk meṅ jā kar wahāṅ rahoge. Tumhāre bachche aur pote-nawāse us meṅ paidā ho jāeṅge. Jab is tarah bahut waqt guzar jāegā to ḳhatrā hai ki tum ġhalat kām karke kisī chīz kī mūrat banāo. Aisā kabhī na karnā. Yih Rab tumhāre Ḳhudā kī nazar meṅ burā hai aur use ġhussā dilāegā. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Āj āsmān aur zamīn mere gawāh haiṅ ki agar tum aisā karo to jaldī se us mulk meṅ se miṭ jāoge jis par tum Dariyā-e-Yardan ko pār karke qabzā karoge. Tum der tak wahāṅ jīte nahīṅ rahoge balki pūre taur par halāk ho jāoge. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Rab tumheṅ mulk se nikāl kar muḳhtalif qaumoṅ meṅ muntashir kar degā, aur wahāṅ sirf thoṛe hī afrād bache raheṅge. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Wahāṅ tum insān ke hāthoṅ se bane hue lakaṛī aur patthar ke butoṅ kī ḳhidmat karoge, jo na dekh sakte, na sun sakte, na khā sakte aur na sūṅgh sakte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Wahīṅ tū Rab apne Ḳhudā ko talāsh karegā, aur agar use pūre dil-o-jān se ḍhūnḍe to wuh tujhe mil bhī jāegā. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Jab tū is taklīf meṅ mubtalā hogā aur yih sārā kuchh tujh par se guzaregā phir āḳhirkār Rab apne Ḳhudā kī taraf rujū karke us kī sunegā. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Kyoṅki Rab terā Ḳhudā rahīm Ḳhudā hai. Wuh tujhe na tark karegā aur na barbād karegā. Wuh us ahd ko nahīṅ bhūlegā jo us ne qasam khā kar tere bāpdādā se bāndhā thā. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Duniyā meṅ insān kī taḳhlīq se le kar āj tak māzī kī taftīsh kar. Āsmān ke ek sire se dūsre sire tak khoj lagā. Kyā is se pahle kabhī is tarah kā mojizānā kām huā hai? Kyā kisī ne is se pahle is qism ke azīm kām kī ḳhabar sunī hai? ");
INSERT INTO urdgvr_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Tū ne āg meṅ se boltī huī Allāh kī āwāz sunī to bhī jītā bachā! Kyā kisī aur qaum ke sāth aisā huā hai? ");
INSERT INTO urdgvr_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Kyā kisī aur mābūd ne kabhī jurrat kī hai ki Rab kī tarah pūrī qaum ko ek mulk se nikāl kar apnī milkiyat banāyā ho? Us ne aisā hī tumhāre sāth kiyā. Us ne tumhāre deḳhte deḳhte Misriyoṅ ko āzmāyā, unheṅ baṛe mojize dikhāe, un ke sāth jang kī, apnī baṛī qudrat aur iḳhtiyār kā izhār kiyā aur haulnāk kāmoṅ se un par ġhālib ā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Tujhe yih sab kuchh dikhāyā gayā tāki tū jān le ki Rab Ḳhudā hai. Us ke siwā koī aur nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Us ne tujhe nasīhat dene ke lie āsmān se apnī āwāz sunāī. Zamīn par us ne tujhe apnī azīm āg dikhāī jis meṅ se tū ne us kī bāteṅ sunīṅ. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Use tere bāpdādā se pyār thā, aur us ne tujhe jo un kī aulād haiṅ chun liyā. Is lie wuh ḳhud hāzir ho kar apnī azīm qudrat se tujhe Misr se nikāl lāyā. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Us ne tere āge se tujh se zyādā baṛī aur tāqatwar qaumeṅ nikāl dīṅ tāki tujhe un kā mulk mīrās meṅ mil jāe. Āj aisā hī ho rahā hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Chunāṅche āj jān le aur zahan meṅ rakh ki Rab āsmān aur zamīn kā Ḳhudā hai. Koī aur mābūd nahīṅ hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Us ke ahkām par amal kar jo maiṅ tujhe āj sunā rahā hūṅ. Phir tū aur terī aulād kāmyāb hoṅge, aur tū der tak us mulk meṅ jītā rahegā jo Rab tujhe hameshā ke lie de rahā hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Yih kah kar Mūsā ne Dariyā-e-Yardan ke mashriq meṅ panāh ke tīn shahr chun lie. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","Un meṅ wuh shaḳhs panāh le saktā thā jis ne dushmanī kī binā par nahīṅ balki ġhairirādī taur par kisī ko jān se mār diyā thā. Aise shahr meṅ panāh lene ke sabab se use badle meṅ qatl nahīṅ kiyā jā saktā thā. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Is ke lie Rūbin ke qabīle ke lie maidān-e-murtafā kā shahr Basar, Jad ke qabīle ke lie Jiliyād kā shahr Rāmāt aur Manassī ke qabīle ke lie Basan kā shahr Jaulān chunā gayā. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Darj-e-zail wuh sharīat hai jo Mūsā ne Isrāīliyoṅ ko pesh kī. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Mūsā ne yih ahkām aur hidāyāt us waqt pesh kīṅ jab wuh Misr se nikal kar ");
INSERT INTO urdgvr_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Dariyā-e-Yardan ke mashriqī kināre par the. Bait-faġhūr un ke muqābil thā, aur wuh Amorī bādshāh Sīhon ke mulk meṅ ḳhaimāzan the. Sīhon kī rihāish Hasbon meṅ thī aur use Isrāīliyoṅ se shikast huī thī jab wuh Mūsā kī rāhnumāī meṅ Misr se nikal āe the. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Us ke mulk par qabzā karke unhoṅ ne Basan ke mulk par bhī fatah pāī thī jis kā bādshāh Oj thā. In donoṅ Amorī bādshāhoṅ kā yih pūrā ilāqā un ke hāth meṅ ā gayā thā. Yih ilāqā Dariyā-e-Yardan ke mashriq meṅ thā. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Us kī junūbī sarhad Dariyā-e-Arnon ke kināre par wāqe shahr Aroīr thī jabki us kī shimālī sarhad Siryūn yānī Harmūn Pahāṛ thī. ");
INSERT INTO urdgvr_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","Dariyā-e-Yardan kā pūrā mashriqī kinārā Pisgā ke pahāṛī silsile ke dāman meṅ wāqe Bahīrā-e-Murdār tak us meṅ shāmil thā. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Mūsā ne tamām Isrāīliyoṅ ko jamā karke kahā, Ai Isrāīl, dhyān se wuh hidāyāt aur ahkām sun jo maiṅ tumheṅ āj pesh kar rahā hūṅ. Unheṅ sīkho aur baṛī ehtiyāt se un par amal karo. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Rab hamāre Ḳhudā ne Horib yānī Sīnā Pahāṛ par hamāre sāth ahd bāndhā. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Us ne yih ahd hamāre bāpdādā ke sāth nahīṅ balki hamāre hī sāth bāndhā hai, jo āj is jagah par zindā haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Rab pahāṛ par āg meṅ se rūbarū ho kar tum se hamkalām huā. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Us waqt maiṅ tumhāre aur Rab ke darmiyān khaṛā huā tāki tumheṅ Rab kī bāteṅ sunāūṅ. Kyoṅki tum āg se ḍarte the aur is lie pahāṛ par na chaṛhe. Us waqt Rab ne kahā, ");
INSERT INTO urdgvr_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“Maiṅ Rab terā Ḳhudā hūṅ jo tujhe Mulk-e-Misr kī ġhulāmī se nikāl lāyā. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Mere siwā kisī aur mābūd kī parastish na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Apne lie but na banānā. Kisī bhī chīz kī mūrat na banānā, chāhe wuh āsmān meṅ, zamīn par yā samundar meṅ ho. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Na butoṅ kī parastish, na un kī ḳhidmat karnā, kyoṅki maiṅ terā Rab ġhayūr Ḳhudā hūṅ. Jo mujh se nafrat karte haiṅ unheṅ maiṅ tīsrī aur chauthī pusht tak sazā dūṅgā. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Lekin jo mujh se muhabbat rakhte aur mere ahkām pūre karte haiṅ un par maiṅ hazār pushtoṅ tak mehrbānī karūṅga. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Rab apne Ḳhudā kā nām bemaqsad yā ġhalat maqsad ke lie istemāl na karnā. Jo bhī aisā kartā hai use Rab sazā die baġhair nahīṅ chhoṛegā. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Sabat ke din kā ḳhayāl rakhnā. Use is tarah manānā ki wuh maḳhsūs-o-muqaddas ho, usī tarah jis tarah Rab tere Ḳhudā ne tujhe hukm diyā hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Hafte ke pahle chhih din apnā kām-kāj kar, ");
INSERT INTO urdgvr_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","lekin sātwāṅ din Rab tere Ḳhudā kā ārām kā din hai. Us din kisī tarah kā kām na karnā. Na tū, na terā beṭā, na terī beṭī, na terā naukar, na terī naukarānī, na terā bail, na terā gadhā, na terā koī aur maweshī. Jo pardesī tere darmiyān rahtā hai wuh bhī kām na kare. Tere naukar aur terī naukarānī ko terī tarah ārām kā mauqā milnā hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Yād rakhnā ki tū Misr meṅ ġhulām thā aur ki Rab terā Ḳhudā hī tujhe baṛī qudrat aur iḳhtiyār se wahāṅ se nikāl lāyā. Is lie us ne tujhe hukm diyā hai ki Sabat kā din manānā. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Apne bāp aur apnī māṅ kī izzat karnā jis tarah Rab tere Ḳhudā ne tujhe hukm diyā hai. Phir tū us mulk meṅ jo Rab terā Ḳhudā tujhe dene wālā hai ḳhushhāl hogā aur der tak jītā rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Qatl na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Zinā na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Chorī na karnā. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Apne paṛosī ke bāre meṅ jhūṭī gawāhī na denā. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Apne paṛosī kī bīwī kā lālach na karnā. Na us ke ghar kā, na us kī zamīn kā, na us ke naukar kā, na us kī naukarānī kā, na us ke bail aur na us ke gadhe kā balki us kī kisī bhī chīz kā lālach na karnā.” ");
INSERT INTO urdgvr_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Rab ne tum sab ko yih ahkām die jab tum Sīnā Pahāṛ ke dāman meṅ jamā the. Wahāṅ tum ne āg, bādal aur gahre andhere meṅ se us kī zordār āwāz sunī. Yihī kuchh us ne kahā aur bas. Phir us ne unheṅ patthar kī do taḳhtiyoṅ par likh kar mujhe de diyā. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Jab tum ne tārīkī se yih āwāz sunī aur pahāṛ kī jaltī huī hālat dekhī to tumhāre qabīloṅ ke rāhnumā aur buzurg mere pās āe. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Unhoṅ ne kahā, “Rab hamāre Ḳhudā ne ham par apnā jalāl aur azmat zāhir kī hai. Āj ham ne āg meṅ se us kī āwāz sunī hai. Ham ne dekh liyā hai ki jab Allāh insān se hamkalām hotā hai to zarūrī nahīṅ ki wuh mar jāe. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Lekin ab ham kyoṅ apnī jān ḳhatre meṅ ḍāleṅ? Agar ham mazīd Rab apne Ḳhudā kī āwāz suneṅ to yih baṛī āg hameṅ bhasm kar degī aur ham apnī jān se hāth dho baiṭheṅge. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Kyoṅki fānī insānoṅ meṅ se kaun hamārī tarah zindā Ḳhudā ko āg meṅ se bāteṅ karte hue sun kar zindā rahā hai? Koī bhī nahīṅ! ");
INSERT INTO urdgvr_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Āp hī qarīb jā kar un tamām bātoṅ ko suneṅ jo Rab hamārā Ḳhudā hameṅ batānā chāhtā hai. Phir lauṭ kar hameṅ wuh bāteṅ sunāeṅ. Ham unheṅ suneṅge aur un par amal kareṅge.” ");
INSERT INTO urdgvr_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Jab Rab ne yih sunā to us ne mujh se kahā, “Maiṅ ne in logoṅ kī yih bāteṅ sun lī haiṅ. Wuh ṭhīk kahte haiṅ. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Kāsh un kī soch hameshā aisī hī ho! Kāsh wuh hameshā isī tarah merā ḳhauf māneṅ aur mere ahkām par amal kareṅ! Agar wuh aisā kareṅge to wuh aur un kī aulād hameshā kāmyāb raheṅge. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Jā, unheṅ batā de ki apne ḳhaimoṅ meṅ lauṭ jāo. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Lekin tū yahāṅ mere pās rah tāki maiṅ tujhe tamām qawānīn aur ahkām de dūṅ. Un ko logoṅ ko sikhānā tāki wuh us mulk meṅ un ke mutābiq chaleṅ jo maiṅ unheṅ dūṅgā.” ");
INSERT INTO urdgvr_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Chunāṅche ehtiyāt se un ahkām par amal karo jo Rab tumhāre Ḳhudā ne tumheṅ die haiṅ. Un se na dāīṅ taraf haṭo na bāīṅ taraf. ");
INSERT INTO urdgvr_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Hameshā us rāh par chalte raho jo Rab tumhāre Ḳhudā ne tumheṅ batāī hai. Phir tum kāmyāb hoge aur us mulk meṅ der tak jīte rahoge jis par tum qabzā karoge. ");
INSERT INTO urdgvr_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Yih wuh tamām ahkām haiṅ jo Rab tumhāre Ḳhudā ne mujhe tumheṅ sikhāne ke lie kahā. Us mulk meṅ in par amal karnā jis meṅ tum jāne wāle ho tāki us par qabzā karo. ");
INSERT INTO urdgvr_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Umr-bhar tū, tere bachche aur pote-nawāse Rab apne Ḳhudā kā ḳhauf māneṅ aur us ke un tamām ahkām par chaleṅ jo maiṅ tujhe de rahā hūṅ. Tab tū der tak jītā rahegā. ");
INSERT INTO urdgvr_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Ai Isrāīl, yih merī bāteṅ sun aur baṛī ehtiyāt se in par amal kar! Phir Rab tere Ḳhudā kā wādā pūrā ho jāegā ki tū kāmyāb rahegā aur terī tādād us mulk meṅ ḳhūb baṛhtī jāegī jis meṅ dūdh aur shahd kī kasrat hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Sun ai Isrāīl! Rab hamārā Ḳhudā ek hī Rab hai. ");
INSERT INTO urdgvr_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Rab apne Ḳhudā se apne pūre dil, apnī pūrī jān aur apnī pūrī tāqat se pyār karnā. ");
INSERT INTO urdgvr_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Jo ahkām maiṅ 