﻿USE sofia;
DROP TABLE IF EXISTS sofia.urdgvh_vpl;
CREATE TABLE urdgvh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES urdgvh_vpl WRITE;
INSERT INTO urdgvh_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","इब्तिदा में अल्लाह ने आसमान और ज़मीन को बनाया। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","अभी तक ज़मीन वीरान और ख़ाली थी। वह गहरे पानी से ढकी हुई थी जिसके ऊपर अंधेरा ही अंधेरा था। अल्लाह का रूह पानी के ऊपर मँडला रहा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","फिर अल्लाह ने कहा, “रौशनी हो जाए” तो रौशनी पैदा हो गई। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","अल्लाह ने देखा कि रौशनी अच्छी है, और उसने रौशनी को तारीकी से अलग कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","अल्लाह ने रौशनी को दिन का नाम दिया और तारीकी को रात का। शाम हुई, फिर सुबह। यों पहला दिन गुज़र गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","अल्लाह ने कहा, “पानी के दरमियान एक ऐसा गुंबद पैदा हो जाए जिससे निचला पानी ऊपर के पानी से अलग हो जाए।” ");
INSERT INTO urdgvh_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ऐसा ही हुआ। अल्लाह ने एक ऐसा गुंबद बनाया जिससे निचला पानी ऊपर के पानी से अलग हो गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","अल्लाह ने गुंबद को आसमान का नाम दिया। शाम हुई, फिर सुबह। यों दूसरा दिन गुज़र गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","अल्लाह ने कहा, “जो पानी आसमान के नीचे है वह एक जगह जमा हो जाए ताकि दूसरी तरफ़ ख़ुश्क जगह नज़र आए।” ऐसा ही हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","अल्लाह ने ख़ुश्क जगह को ज़मीन का नाम दिया और जमाशुदा पानी को समुंदर का। और अल्लाह ने देखा कि यह अच्छा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","फिर उसने कहा, “ज़मीन हरियावल पैदा करे, ऐसे पौदे जो बीज रखते हों और ऐसे दरख़्त जिनके फल अपनी अपनी क़िस्म के बीज रखते हों।” ऐसा ही हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ज़मीन ने हरियावल पैदा की, ऐसे पौदे जो अपनी अपनी क़िस्म के बीज रखते और ऐसे दरख़्त जिनके फल अपनी अपनी क़िस्म के बीज रखते थे। अल्लाह ने देखा कि यह अच्छा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","शाम हुई, फिर सुबह। यों तीसरा दिन गुज़र गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","अल्लाह ने कहा, “आसमान पर रौशनियाँ पैदा हो जाएँ ताकि दिन और रात में इम्तियाज़ हो और इसी तरह मुख़्तलिफ़ मौसमों, दिनों और सालों में भी। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","आसमान की यह रौशनियाँ दुनिया को रौशन करें।” ऐसा ही हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","अल्लाह ने दो बड़ी रौशनियाँ बनाईं, सूरज जो बड़ा था दिन पर हुकूमत करने को और चाँद जो छोटा था रात पर। इनके अलावा उसने सितारों को भी बनाया। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","उसने उन्हें आसमान पर रखा ताकि वह दुनिया को रौशन करें, ");
INSERT INTO urdgvh_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","दिन और रात पर हुकूमत करें और रौशनी और तारीकी में इम्तियाज़ पैदा करें। अल्लाह ने देखा कि यह अच्छा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","शाम हुई, फिर सुबह। यों चौथा दिन गुज़र गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","अल्लाह ने कहा, “पानी आबी जानदारों से भर जाए और फ़िज़ा में परिंदे उड़ते फिरें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","अल्लाह ने बड़े बड़े समुंदरी जानवर बनाए, पानी की तमाम दीगर मख़लूक़ात और हर क़िस्म के पर रखनेवाले जानदार भी बनाए। अल्लाह ने देखा कि यह अच्छा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","उसने उन्हें बरकत दी और कहा, “फलो-फूलो और तादाद में बढ़ते जाओ। समुंदर तुमसे भर जाए। इसी तरह परिंदे ज़मीन पर तादाद में बढ़ जाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","शाम हुई, फिर सुबह। यों पाँचवाँ दिन गुज़र गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","अल्लाह ने कहा, “ज़मीन हर क़िस्म के जानदार पैदा करे : मवेशी, रेंगनेवाले और जंगली जानवर।” ऐसा ही हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","अल्लाह ने हर क़िस्म के मवेशी, रेंगनेवाले और जंगली जानवर बनाए। उसने देखा कि यह अच्छा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","अल्लाह ने कहा, “आओ अब हम इनसान को अपनी सूरत पर बनाएँ, वह हमसे मुशाबहत रखे। वह तमाम जानवरों पर हुकूमत करे, समुंदर की मछलियों पर, हवा के परिंदों पर, मवेशियों पर, जंगली जानवरों पर और ज़मीन पर के तमाम रेंगनेवाले जानदारों पर।” ");
INSERT INTO urdgvh_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","यों अल्लाह ने इनसान को अपनी सूरत पर बनाया, अल्लाह की सूरत पर। उसने उन्हें मर्द और औरत बनाया। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","अल्लाह ने उन्हें बरकत दी और कहा, “फलो-फूलो और तादाद में बढ़ते जाओ। दुनिया तुमसे भर जाए और तुम उस पर इख़्तियार रखो। समुंदर की मछलियों, हवा के परिंदों और ज़मीन पर के तमाम रेंगनेवाले जानदारों पर हुकूमत करो।” ");
INSERT INTO urdgvh_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","अल्लाह ने उनसे मज़ीद कहा, “तमाम बीजदार पौदे और फलदार दरख़्त तुम्हारे ही हैं। मैं उन्हें तुमको खाने के लिए देता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","इस तरह मैं तमाम जानवरों को खाने के लिए हरियाली देता हूँ। जिसमें भी जान है वह यह खा सकता है, ख़ाह वह ज़मीन पर चलने-फिरनेवाला जानवर, हवा का परिंदा या ज़मीन पर रेंगनेवाला क्यों न हो।” ऐसा ही हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","अल्लाह ने सब पर नज़र की तो देखा कि वह बहुत अच्छा बन गया है। शाम हुई, फिर सुबह। छटा दिन गुज़र गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","यों आसमानो-ज़मीन और उनकी तमाम चीज़ों की तख़लीक़ मुकम्मल हुई। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","सातवें दिन अल्लाह का सारा काम तकमील को पहुँचा। इससे फ़ारिग़ होकर उसने आराम किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","अल्लाह ने सातवें दिन को बरकत दी और उसे मख़सूसो-मुक़द्दस किया। क्योंकि उस दिन उसने अपने तमाम तख़लीक़ी काम से फ़ारिग़ होकर आराम किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","यह आसमानो-ज़मीन की तख़लीक़ का बयान है। जब रब ख़ुदा ने आसमानो-ज़मीन को बनाया ");
INSERT INTO urdgvh_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","तो शुरू में झाड़ियाँ और पौदे नहीं उगते थे। वजह यह थी कि अल्लाह ने बारिश का इंतज़ाम नहीं किया था। और अभी इनसान भी पैदा नहीं हुआ था कि ज़मीन की खेतीबाड़ी करता। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","इसकी बजाए ज़मीन में से धुंध उठकर उस की पूरी सतह को तर करती थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","फिर रब ख़ुदा ने ज़मीन से मिट्टी लेकर इनसान को तश्कील दिया और उसके नथनों में ज़िंदगी का दम फूँका तो वह जीती जान हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","रब ख़ुदा ने मशरिक़ में मुल्के-अदन में एक बाग़ लगाया। उसमें उसने उस आदमी को रखा जिसे उसने बनाया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","रब ख़ुदा के हुक्म पर ज़मीन में से तरह तरह के दरख़्त फूट निकले, ऐसे दरख़्त जो देखने में दिलकश और खाने के लिए अच्छे थे। बाग़ के बीच में दो दरख़्त थे। एक का फल ज़िंदगी बख़्शता था जबकि दूसरे का फल अच्छे और बुरे की पहचान दिलाता था। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","अदन में से एक दरिया निकलकर बाग़ की आबपाशी करता था। वहाँ से बहकर वह चार शाख़ों में तक़सीम हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","पहली शाख़ का नाम फ़ीसून है। वह मुल्के-हवीला को घेरे हुए बहती है जहाँ ख़ालिस सोना, गूगल का गूँद और अक़ीक़े-अहमर पाए जाते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","दूसरी का नाम जैहून है जो कूश को घेरे हुए बहती है। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","तीसरी का नाम दिजला है जो असूर के मशरिक़ को जाती है और चौथी का नाम फ़ुरात है। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","रब ख़ुदा ने पहले आदमी को बाग़े-अदन में रखा ताकि वह उस की बाग़बानी और हिफ़ाज़त करे। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","लेकिन रब ख़ुदा ने उसे आगाह किया, “तुझे हर दरख़्त का फल खाने की इजाज़त है। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","लेकिन जिस दरख़्त का फल अच्छे और बुरे की पहचान दिलाता है उसका फल खाना मना है। अगर उसे खाए तो यक़ीनन मरेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","रब ख़ुदा ने कहा, “अच्छा नहीं कि आदमी अकेला रहे। मैं उसके लिए एक मुनासिब मददगार बनाता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","रब ख़ुदा ने मिट्टी से ज़मीन पर चलने-फिरनेवाले जानवर और हवा के परिंदे बनाए थे। अब वह उन्हें आदमी के पास ले आया ताकि मालूम हो जाए कि वह उनके क्या क्या नाम रखेगा। यों हर जानवर को आदम की तरफ़ से नाम मिल गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","आदमी ने तमाम मवेशियों, परिंदों और ज़मीन पर फिरनेवाले जानदारों के नाम रखे। लेकिन उसे अपने लिए कोई मुनासिब मददगार न मिला। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","तब रब ख़ुदा ने उसे सुला दिया। जब वह गहरी नींद सो रहा था तो उसने उस की पसलियों में से एक निकालकर उस की जगह गोश्त भर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","पसली से उसने औरत बनाई और उसे आदमी के पास ले आया। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","उसे देखकर वह पुकार उठा, “वाह! यह तो मुझ जैसी ही है, मेरी हड्डियों में से हड्डी और मेरे गोश्त में से गोश्त है। इसका नाम नारी रखा जाए क्योंकि वह नर से निकाली गई है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","इसलिए मर्द अपने माँ-बाप को छोड़कर अपनी बीवी के साथ पैवस्त हो जाता है, और वह दोनों एक हो जाते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","दोनों, आदमी और औरत नंगे थे, लेकिन यह उनके लिए शर्म का बाइस नहीं था। ");
INSERT INTO urdgvh_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","साँप ज़मीन पर चलने-फिरनेवाले उन तमाम जानवरों से ज़्यादा चालाक था जिनको रब ख़ुदा ने बनाया था। उसने औरत से पूछा, “क्या अल्लाह ने वाक़ई कहा कि बाग़ के किसी भी दरख़्त का फल न खाना?” ");
INSERT INTO urdgvh_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","औरत ने जवाब दिया, “हरगिज़ नहीं। हम बाग़ का हर फल खा सकते हैं, ");
INSERT INTO urdgvh_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","सिर्फ़ उस दरख़्त के फल से गुरेज़ करना है जो बाग़ के बीच में है। अल्लाह ने कहा कि उसका फल न खाओ बल्कि उसे छूना भी नहीं, वरना तुम यक़ीनन मर जाओगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","साँप ने औरत से कहा, “तुम हरगिज़ न मरोगे, ");
INSERT INTO urdgvh_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","बल्कि अल्लाह जानता है कि जब तुम उसका फल खाओगे तो तुम्हारी आँखें खुल जाएँगी और तुम अल्लाह की मानिंद हो जाओगे, तुम जो भी अच्छा और बुरा है उसे जान लोगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","औरत ने दरख़्त पर ग़ौर किया कि खाने के लिए अच्छा और देखने में भी दिलकश है। सबसे दिलफ़रेब बात यह कि उससे समझ हासिल हो सकती है! यह सोचकर उसने उसका फल लेकर उसे खाया। फिर उसने अपने शौहर को भी दे दिया, क्योंकि वह उसके साथ था। उसने भी खा लिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","लेकिन खाते ही उनकी आँखें खुल गईं और उनको मालूम हुआ कि हम नंगे हैं। चुनाँचे उन्होंने अंजीर के पत्ते सीकर लुंगियाँ बना लीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","शाम के वक़्त जब ठंडी हवा चलने लगी तो उन्होंने रब ख़ुदा को बाग़ में चलते-फिरते सुना। वह डर के मारे दरख़्तों के पीछे छुप गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","रब ख़ुदा ने पुकारकर कहा, “आदम, तू कहाँ है?” ");
INSERT INTO urdgvh_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","आदम ने जवाब दिया, “मैंने तुझे बाग़ में चलते हुए सुना तो डर गया, क्योंकि मैं नंगा हूँ। इसलिए मैं छुप गया।” ");
INSERT INTO urdgvh_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","उसने पूछा, “किसने तुझे बताया कि तू नंगा है? क्या तूने उस दरख़्त का फल खाया है जिसे खाने से मैंने मना किया था?” ");
INSERT INTO urdgvh_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","आदम ने कहा, “जो औरत तूने मेरे साथ रहने के लिए दी है उसने मुझे फल दिया। इसलिए मैंने खा लिया।” ");
INSERT INTO urdgvh_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","अब रब ख़ुदा औरत से मुख़ातिब हुआ, “तूने यह क्यों किया?” औरत ने जवाब दिया, “साँप ने मुझे बहकाया तो मैंने खाया।” ");
INSERT INTO urdgvh_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","रब ख़ुदा ने साँप से कहा, “चूँकि तूने यह किया, इसलिए तू तमाम मवेशियों और जंगली जानवरों में लानती है। तू उम्र-भर पेट के बल रेंगेगा और ख़ाक चाटेगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","मैं तेरे और औरत के दरमियान दुश्मनी पैदा करूँगा। उस की औलाद तेरी औलाद की दुश्मन होगी। वह तेरे सर को कुचल डालेगी जबकि तू उस की एड़ी पर काटेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","फिर रब ख़ुदा औरत से मुख़ातिब हुआ और कहा, “जब तू उम्मीद से होगी तो मैं तेरी तकलीफ़ को बहुत बढ़ाऊँगा। जब तेरे बच्चे होंगे तो तू शदीद दर्द का शिकार होगी। तू अपने शौहर की तमन्ना करेगी लेकिन वह तुझ पर हुकूमत करेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","आदम से उसने कहा, “तूने अपनी बीवी की बात मानी और उस दरख़्त का फल खाया जिसे खाने से मैंने मना किया था। इसलिए तेरे सबब से ज़मीन पर लानत है। उससे ख़ुराक हासिल करने के लिए तुझे उम्र-भर मेहनत-मशक़्क़त करनी पड़ेगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","तेरे लिए वह ख़ारदार पौदे और ऊँटकटारे पैदा करेगी, हालाँकि तू उससे अपनी ख़ुराक भी हासिल करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","पसीना बहा बहाकर तुझे रोटी कमाने के लिए भाग-दौड़ करनी पड़ेगी। और यह सिलसिला मौत तक जारी रहेगा। तू मेहनत करते करते दुबारा ज़मीन में लौट जाएगा, क्योंकि तू उसी से लिया गया है। तू ख़ाक है और दुबारा ख़ाक में मिल जाएगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","आदम ने अपनी बीवी का नाम हव्वा यानी ज़िंदगी रखा, क्योंकि बाद में वह तमाम ज़िंदों की माँ बन गई। ");
INSERT INTO urdgvh_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","रब ख़ुदा ने आदम और उस की बीवी के लिए खालों से लिबास बनाकर उन्हें पहनाया। ");
INSERT INTO urdgvh_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","उसने कहा, “इनसान हमारी मानिंद हो गया है, वह अच्छे और बुरे का इल्म रखता है। अब ऐसा न हो कि वह हाथ बढ़ाकर ज़िंदगी बख़्शनेवाले दरख़्त के फल से ले और उससे खाकर हमेशा तक ज़िंदा रहे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","इसलिए रब ख़ुदा ने उसे बाग़े-अदन से निकालकर उस ज़मीन की खेतीबाड़ी करने की ज़िम्मादारी दी जिसमें से उसे लिया गया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","इनसान को ख़ारिज करने के बाद उसने बाग़े-अदन के मशरिक़ में करूबी फ़रिश्ते खड़े किए और साथ साथ एक आतिशी तलवार रखी जो इधर-उधर घूमती थी ताकि उस रास्ते की हिफ़ाज़त करे जो ज़िंदगी बख़्शनेवाले दरख़्त तक पहुँचाता था। ");
INSERT INTO urdgvh_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","आदम हव्वा से हमबिसतर हुआ तो उनका पहला बेटा क़ाबील पैदा हुआ। हव्वा ने कहा, “रब की मदद से मैंने एक मर्द हासिल किया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","बाद में क़ाबील का भाई हाबील पैदा हुआ। हाबील भेड़-बकरियों का चरवाहा बन गया जबकि क़ाबील खेतीबाड़ी करने लगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","कुछ देर के बाद क़ाबील ने रब को अपनी फ़सलों में से कुछ पेश किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","हाबील ने भी नज़राना पेश किया, लेकिन उसने अपनी भेड़-बकरियों के कुछ पहलौठे उनकी चरबी समेत चढ़ाए। हाबील का नज़राना रब को पसंद आया, ");
INSERT INTO urdgvh_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","मगर क़ाबील का नज़राना मंज़ूर न हुआ। यह देखकर क़ाबील बड़े ग़ुस्से में आ गया, और उसका मुँह बिगड़ गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","रब ने पूछा, “तू ग़ुस्से में क्यों आ गया है? तेरा मुँह क्यों लटका हुआ है? ");
INSERT INTO urdgvh_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","क्या अगर तू अच्छी नीयत रखता है तो अपनी नज़र उठाकर मेरी तरफ़ नहीं देख सकेगा? लेकिन अगर अच्छी नीयत नहीं रखता तो ख़बरदार! गुनाह दरवाज़े पर दबका बैठा है और तुझे चाहता है। लेकिन तेरा फ़र्ज़ है कि उस पर ग़ालिब आए।” ");
INSERT INTO urdgvh_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","एक दिन क़ाबील ने अपने भाई से कहा, “आओ, हम बाहर खुले मैदान में चलें।” और जब वह खुले मैदान में थे तो क़ाबील ने अपने भाई हाबील पर हमला करके उसे मार डाला। ");
INSERT INTO urdgvh_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","तब रब ने क़ाबील से पूछा, “तेरा भाई हाबील कहाँ है?” क़ाबील ने जवाब दिया, “मुझे क्या पता! क्या अपने भाई की देख-भाल करना मेरी ज़िम्मादारी है?” ");
INSERT INTO urdgvh_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","रब ने कहा, “तूने क्या किया है? तेरे भाई का ख़ून ज़मीन में से पुकारकर मुझसे फ़रियाद कर रहा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","इसलिए तुझ पर लानत है और ज़मीन ने तुझे रद्द किया है, क्योंकि ज़मीन को मुँह खोलकर तेरे हाथ से क़त्ल किए हुए भाई का ख़ून पीना पड़ा। ");
INSERT INTO urdgvh_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","अब से जब तू खेतीबाड़ी करेगा तो ज़मीन अपनी पैदावार देने से इनकार करेगी। तू मफ़रूर होकर मारा मारा फिरेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","क़ाबील ने कहा, “मेरी सज़ा निहायत सख़्त है। मैं इसे बरदाश्त नहीं कर पाऊँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","आज तू मुझे ज़मीन की सतह से भगा रहा है और मुझे तेरे हुज़ूर से भी छुप जाना है। मैं मफ़रूर की हैसियत से मारा मारा फिरता रहूँगा, इसलिए जिसको भी पता चलेगा कि मैं कहाँ हूँ वह मुझे क़त्ल कर डालेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","लेकिन रब ने उससे कहा, “हरगिज़ नहीं। जो क़ाबील को क़त्ल करे उससे सात गुना बदला लिया जाएगा।” फिर रब ने उस पर एक निशान लगाया ताकि जो भी क़ाबील को देखे वह उसे क़त्ल न कर दे। ");
INSERT INTO urdgvh_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","इसके बाद क़ाबील रब के हुज़ूर से चला गया और अदन के मशरिक़ की तरफ़ नोद के इलाक़े में जा बसा। ");
INSERT INTO urdgvh_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","क़ाबील की बीवी हामिला हुई। बेटा पैदा हुआ जिसका नाम हनूक रखा गया। क़ाबील ने एक शहर तामीर किया और अपने बेटे की ख़ुशी में उसका नाम हनूक रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","हनूक का बेटा ईराद था, ईराद का बेटा महूयाएल, महूयाएल का बेटा मतूसाएल और मतूसाएल का बेटा लमक था। ");
INSERT INTO urdgvh_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","लमक की दो बीवियाँ थीं, अदा और ज़िल्ला। ");
INSERT INTO urdgvh_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","अदा का बेटा याबल था। उस की नसल के लोग ख़ैमों में रहते और मवेशी पालते थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","याबल का भाई यूबल था। उस की नसल के लोग सरोद और बाँसरी बजाते थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ज़िल्ला के भी बेटा पैदा हुआ जिसका नाम तूबल-क़ाबील था। वह लोहार था। उस की नसल के लोग पीतल और लोहे की चीज़ें बनाते थे। तूबल-क़ाबील की बहन का नाम नामा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","एक दिन लमक ने अपनी बीवियों से कहा, “अदा और ज़िल्ला, मेरी बात सुनो! लमक की बीवियो, मेरे अलफ़ाज़ पर ग़ौर करो! ");
INSERT INTO urdgvh_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","एक आदमी ने मुझे ज़ख़मी किया तो मैंने उसे मार डाला। एक लड़के ने मेरे चोट लगाई तो मैंने उसे क़त्ल कर दिया। जो क़ाबील को क़त्ल करे उससे सात गुना बदला लिया जाएगा, लेकिन जो लमक को क़त्ल करे उससे सतत्तर गुना बदला लिया जाएगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","आदम और हव्वा का एक और बेटा पैदा हुआ। हव्वा ने उसका नाम सेत रखकर कहा, “अल्लाह ने मुझे हाबील की जगह जिसे क़ाबील ने क़त्ल किया एक और बेटा बख़्शा है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","सेत के हाँ भी बेटा पैदा हुआ। उसने उसका नाम अनूस रखा। उन दिनों में लोग रब का नाम लेकर इबादत करने लगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ज़ैल में आदम का नसबनामा दर्ज है। जब अल्लाह ने इनसान को ख़लक़ किया तो उसने उसे अपनी सूरत पर बनाया। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","उसने उन्हें मर्द और औरत पैदा किया। और जिस दिन उसने उन्हें ख़लक़ किया उसने उन्हें बरकत देकर उनका नाम आदम यानी इनसान रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","आदम की उम्र 130 साल थी जब उसका बेटा सेत पैदा हुआ। सेत सूरत के लिहाज़ से अपने बाप की मानिंद था, वह उससे मुशाबहत रखता था। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","सेत की पैदाइश के बाद आदम मज़ीद 800 साल ज़िंदा रहा। उसके और बेटे-बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","वह 930 साल की उम्र में फ़ौत हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","सेत 105 साल का था जब उसका बेटा अनूस पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","इसके बाद वह मज़ीद 807 साल ज़िंदा रहा। उसके और बेटे-बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","वह 912 साल की उम्र में फ़ौत हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","अनूस 90 बरस का था जब उसका बेटा क़ीनान पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","इसके बाद वह मज़ीद 815 साल ज़िंदा रहा। उसके और बेटे-बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","वह 905 साल की उम्र में फ़ौत हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","क़ीनान 70 साल का था जब उसका बेटा महललेल पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","इसके बाद वह मज़ीद 840 साल ज़िंदा रहा। उसके और बेटे-बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","वह 910 साल की उम्र में फ़ौत हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","महललेल 65 साल का था जब उसका बेटा यारिद पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","इसके बाद वह मज़ीद 830 साल ज़िंदा रहा। उसके और बेटे-बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","वह 895 साल की उम्र में फ़ौत हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","यारिद 162 साल का था जब उसका बेटा हनूक पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","इसके बाद वह मज़ीद 800 साल ज़िंदा रहा। उसके और बेटे-बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","वह 962 साल की उम्र में फ़ौत हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","हनूक 65 साल का था जब उसका बेटा मतूसिलह पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","इसके बाद वह मज़ीद 300 साल अल्लाह के साथ चलता रहा। उसके और बेटे-बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","वह कुल 365 साल दुनिया में रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","हनूक अल्लाह के साथ साथ चलता था। 365 साल की उम्र में वह ग़ायब हुआ, क्योंकि अल्लाह ने उसे उठा लिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","मतूसिलह 187 साल का था जब उसका बेटा लमक पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","वह मज़ीद 782 साल ज़िंदा रहा। उसके और बेटे और बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","वह 969 साल की उम्र में फ़ौत हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","लमक 182 साल का था जब उसका बेटा पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","उसने उसका नाम नूह यानी तसल्ली रखा, क्योंकि उसने उसके बारे में कहा, “हमारा खेतीबाड़ी का काम निहायत तकलीफ़देह है, इसलिए कि अल्लाह ने ज़मीन पर लानत भेजी है। लेकिन अब हम बेटे की मारिफ़त तसल्ली पाएँगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","इसके बाद वह मज़ीद 595 साल ज़िंदा रहा। उसके और बेटे-बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","वह 777 साल की उम्र में फ़ौत हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","नूह 500 साल का था जब उसके बेटे सिम, हाम और याफ़त पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","दुनिया में लोगों की तादाद बढ़ने लगी। उनके हाँ बेटियाँ पैदा हुईं। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","तब आसमानी हस्तियों ने देखा कि बनी नौ इनसान की बेटियाँ ख़ूबसूरत हैं, और उन्होंने उनमें से कुछ चुनकर उनसे शादी की। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","फिर रब ने कहा, “मेरी रूह हमेशा के लिए इनसान में न रहे क्योंकि वह फ़ानी मख़लूक़ है। अब से वह 120 साल से ज़्यादा ज़िंदा नहीं रहेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","उन दिनों में और बाद में भी दुनिया में देवक़ामत अफ़राद थे जो इनसानी औरतों और उन आसमानी हस्तियों की शादियों से पैदा हुए थे। यह देवक़ामत अफ़राद क़दीम ज़माने के मशहूर सूरमा थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","रब ने देखा कि इनसान निहायत बिगड़ गया है, कि उसके तमाम ख़यालात लगातार बुराई की तरफ़ मायल रहते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","वह पछताया कि मैंने इनसान को बनाकर दुनिया में रख दिया है, और उसे सख़्त दुख हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","उसने कहा, “गो मैं ही ने इनसान को ख़लक़ किया मैं उसे रूए-ज़मीन पर से मिटा डालूँगा। मैं न सिर्फ़ लोगों को बल्कि ज़मीन पर चलने-फिरने और रेंगनेवाले जानवरों और हवा के परिंदों को भी हलाक कर दूँगा, क्योंकि मैं पछताता हूँ कि मैंने उनको बनाया।” ");
INSERT INTO urdgvh_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","सिर्फ़ नूह पर रब की नज़रे-करम थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","यह उस की ज़िंदगी का बयान है। नूह रास्तबाज़ था। उस ज़माने के लोगों में सिर्फ़ वही बेक़ुसूर था। वह अल्लाह के साथ साथ चलता था। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","नूह के तीन बेटे थे, सिम, हाम और याफ़त। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","लेकिन दुनिया अल्लाह की नज़र में बिगड़ी हुई और ज़ुल्मो-तशद्दुद से भरी हुई थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","जहाँ भी अल्लाह देखता दुनिया ख़राब थी, क्योंकि तमाम जानदारों ने ज़मीन पर अपनी रविश को बिगाड़ दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","तब अल्लाह ने नूह से कहा, “मैंने तमाम जानदारों को ख़त्म करने का फ़ैसला किया है, क्योंकि उनके सबब से पूरी दुनिया ज़ुल्मो-तशद्दुद से भर गई है। चुनाँचे मैं उनको ज़मीन समेत तबाह कर दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","अब अपने लिए सरो की लकड़ी की कश्ती बना ले। उसमें कमरे हों और उसे अंदर और बाहर तारकोल लगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","उस की लंबाई 450 फ़ुट, चौड़ाई 75 फ़ुट और ऊँचाई 45 फ़ुट हो। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","कश्ती की छत को यों बनाना कि उसके नीचे 18 इंच खुला रहे। एक तरफ़ दरवाज़ा हो, और उस की तीन मनज़िलें हों। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","मैं पानी का इतना बड़ा सैलाब लाऊँगा कि वह ज़मीन के तमाम जानदारों को हलाक कर डालेगा। ज़मीन पर सब कुछ फ़ना हो जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","लेकिन तेरे साथ मैं अहद बाँधूँगा जिसके तहत तू अपने बेटों, अपनी बीवी और बहुओं के साथ कश्ती में जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","हर क़िस्म के जानवर का एक नर और एक मादा भी अपने साथ कश्ती में ले जाना ताकि वह तेरे साथ जीते बचें। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","हर क़िस्म के पर रखनेवाले जानवर और हर क़िस्म के ज़मीन पर फिरने या रेंगनेवाले जानवर दो दो होकर तेरे पास आएँगे ताकि जीते बच जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","जो भी ख़ुराक दरकार है उसे अपने और उनके लिए जमा करके कश्ती में महफ़ूज़ कर लेना।” ");
INSERT INTO urdgvh_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","नूह ने सब कुछ वैसा ही किया जैसा अल्लाह ने उसे बताया। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","फिर रब ने नूह से कहा, “अपने घराने समेत कश्ती में दाख़िल हो जा, क्योंकि इस दौर के लोगों में से मैंने सिर्फ़ तुझे रास्तबाज़ पाया है। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","हर क़िस्म के पाक जानवरों में से सात सात नरो-मादा के जोड़े जबकि नापाक जानवरों में से नरो-मादा का सिर्फ़ एक एक जोड़ा साथ ले जाना। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","इसी तरह हर क़िस्म के पर रखनेवालों में से सात सात नरो-मादा के जोड़े भी साथ ले जाना ताकि उनकी नसलें बची रहें। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","एक हफ़ते के बाद मैं चालीस दिन और चालीस रात मुतवातिर बारिश बरसाऊँगा। इससे मैं तमाम जानदारों को रूए-ज़मीन पर से मिटा डालूँगा, अगरचे मैं ही ने उन्हें बनाया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","नूह ने वैसा ही किया जैसा रब ने हुक्म दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","वह 600 साल का था जब यह तूफ़ानी सैलाब ज़मीन पर आया। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","तूफ़ानी सैलाब से बचने के लिए नूह अपने बेटों, अपनी बीवी और बहुओं के साथ कश्ती में सवार हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ज़मीन पर फिरनेवाले पाक और नापाक जानवर, पर रखनेवाले और तमाम रेंगनेवाले जानवर भी आए। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","नरो-मादा की सूरत में दो दो होकर वह नूह के पास आकर कश्ती में सवार हुए। सब कुछ वैसा ही हुआ जैसा अल्लाह ने नूह को हुक्म दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","एक हफ़ते के बाद तूफ़ानी सैलाब ज़मीन पर आ गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","यह सब कुछ उस वक़्त हुआ जब नूह 600 साल का था। दूसरे महीने के 17वें दिन ज़मीन की गहराइयों में से तमाम चश्मे फूट निकले और आसमान पर पानी के दरीचे खुल गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","चालीस दिन और चालीस रात तक मूसलाधार बारिश होती रही। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","जब बारिश शुरू हुई तो नूह, उसके बेटे सिम, हाम और याफ़त, उस की बीवी और बहुएँ कश्ती में सवार हो चुके थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","उनके साथ हर क़िस्म के जंगली जानवर, मवेशी, रेंगने और पर रखनेवाले जानवर थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","हर क़िस्म के जानदार दो दो होकर नूह के पास आकर कश्ती में सवार हो चुके थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","नरो-मादा आए थे। सब कुछ वैसा ही हुआ था जैसा अल्लाह ने नूह को हुक्म दिया था। फिर रब ने दरवाज़े को बंद कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","चालीस दिन तक तूफ़ानी सैलाब जारी रहा। पानी चढ़ा तो उसने कश्ती को ज़मीन पर से उठा लिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","पानी ज़ोर पकड़कर बहुत बढ़ गया, और कश्ती उस पर तैरने लगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","आख़िरकार पानी इतना ज़्यादा हो गया कि तमाम ऊँचे पहाड़ भी उसमें छुप गए, ");
INSERT INTO urdgvh_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","बल्कि सबसे ऊँची चोटी पर पानी की गहराई 20 फ़ुट थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ज़मीन पर रहनेवाली हर मख़लूक़ हलाक हुई। परिंदे, मवेशी, जंगली जानवर, तमाम जानदार जिनसे ज़मीन भरी हुई थी और इनसान, सब कुछ मर गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ज़मीन पर हर जानदार मख़लूक़ हलाक हुई। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","यों हर मख़लूक़ को रूए-ज़मीन पर से मिटा दिया गया। इनसान, ज़मीन पर फिरने और रेंगनेवाले जानवर और परिंदे, सब कुछ ख़त्म कर दिया गया। सिर्फ़ नूह और कश्ती में सवार उसके साथी बच गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","सैलाब डेढ़ सौ दिन तक ज़मीन पर ग़ालिब रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","लेकिन अल्लाह को नूह और तमाम जानवर याद रहे जो कश्ती में थे। उसने हवा चला दी जिससे पानी कम होने लगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ज़मीन के चश्मे और आसमान पर के पानी के दरीचे बंद हो गए, और बारिश रुक गई। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","पानी घटता गया। 150 दिन के बाद वह काफ़ी कम हो गया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","सातवें महीने के 17वें दिन कश्ती अरारात के एक पहाड़ पर टिक गई। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","दसवें महीने के पहले दिन पानी इतना कम हो गया था कि पहाड़ों की चोटियाँ नज़र आने लगी थीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","चालीस दिन के बाद नूह ने कश्ती की खिड़की खोलकर एक कौवा छोड़ दिया, और वह उड़कर चला गया। लेकिन जब तक ज़मीन पर पानी था वह आता जाता रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","फिर नूह ने एक कबूतर छोड़ दिया ताकि पता चले कि ज़मीन पानी से निकल आई है या नहीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","लेकिन कबूतर को कहीं भी बैठने की जगह न मिली, क्योंकि अब तक पूरी ज़मीन पर पानी ही पानी था। वह कश्ती और नूह के पास वापस आ गया, और नूह ने अपना हाथ बढ़ाया और कबूतर को पकड़कर अपने पास कश्ती में रख लिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","उसने एक हफ़ता और इंतज़ार करके कबूतर को दुबारा छोड़ दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","शाम के वक़्त वह लौट आया। इस दफ़ा उस की चोंच में ज़ैतून का ताज़ा पत्ता था। तब नूह को मालूम हुआ कि ज़मीन पानी से निकल आई है। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","उसने मज़ीद एक हफ़ते के बाद कबूतर को छोड़ दिया। इस दफ़ा वह वापस न आया। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","जब नूह 601 साल का था तो पहले महीने के पहले दिन ज़मीन की सतह पर पानी ख़त्म हो गया। तब नूह ने कश्ती की छत खोल दी और देखा कि ज़मीन की सतह पर पानी नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","दूसरे महीने के 27वें दिन ज़मीन बिलकुल ख़ुश्क हो गई। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","फिर अल्लाह ने नूह से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“अपनी बीवी, बेटों और बहुओं के साथ कश्ती से निकल आ। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","जितने भी जानवर साथ हैं उन्हें निकाल दे, ख़ाह परिंदे हों, ख़ाह ज़मीन पर फिरने या रेंगनेवाले जानवर। वह दुनिया में फैल जाएँ, नसल बढ़ाएँ और तादाद में बढ़ते जाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","चुनाँचे नूह अपने बेटों, अपनी बीवी और बहुओं समेत निकल आया। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","तमाम जानवर और परिंदे भी अपनी अपनी क़िस्म के गुरोहों में कश्ती से निकले। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","उस वक़्त नूह ने रब के लिए क़ुरबानगाह बनाई। उसने तमाम फिरने और उड़नेवाले पाक जानवरों में से कुछ चुनकर उन्हें ज़बह किया और क़ुरबानगाह पर पूरी तरह जला दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","यह क़ुरबानियाँ देखकर रब ख़ुश हुआ और अपने दिल में कहा, “अब से मैं कभी ज़मीन पर इनसान की वजह से लानत नहीं भेजूँगा, क्योंकि उसका दिल बचपन ही से बुराई की तरफ़ मायल है। अब से मैं कभी इस तरह तमाम जान रखनेवाली मख़लूक़ात को रूए-ज़मीन पर से नहीं मिटाऊँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","दुनिया के मुक़र्ररा औक़ात जारी रहेंगे। बीज बोने और फ़सल काटने का वक़्त, ठंड और तपिश, गरमियों और सर्दियों का मौसम, दिन और रात, यह सब कुछ दुनिया के अख़ीर तक क़ायम रहेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","फिर अल्लाह ने नूह और उसके बेटों को बरकत देकर कहा, “फलो-फूलो और तादाद में बढ़ते जाओ। दुनिया तुमसे भर जाए। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ज़मीन पर फिरने और रेंगनेवाले जानवर, परिंदे और मछलियाँ सब तुमसे डरेंगे। उन्हें तुम्हारे इख़्तियार में कर दिया गया है। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","जिस तरह मैंने तुम्हारे खाने के लिए पौदों की पैदावार मुक़र्रर की है उसी तरह अब से तुम्हें हर क़िस्म के जानवर खाने की इजाज़त भी है। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","लेकिन ख़बरदार! ऐसा गोश्त न खाना जिसमें ख़ून है, क्योंकि ख़ून में उस की जान है। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","किसी की जान लेना मना है। जो ऐसा करेगा उसे अपनी जान देनी पड़ेगी, ख़ाह वह इनसान हो या हैवान। मैं ख़ुद इसका मुतालबा करूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","जो भी किसी का ख़ून बहाए उसका ख़ून भी बहाया जाएगा। क्योंकि अल्लाह ने इनसान को अपनी सूरत पर बनाया है। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","अब फलो-फूलो और तादाद में बढ़ते जाओ। दुनिया में फैल जाओ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","तब अल्लाह ने नूह और उसके बेटों से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“अब मैं तुम्हारे और तुम्हारी औलाद के साथ अहद क़ायम करता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","यह अहद उन तमाम जानवरों के साथ भी होगा जो कश्ती में से निकले हैं यानी परिंदों, मवेशियों और ज़मीन पर के तमाम जानवरों के साथ। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","मैं तुम्हारे साथ अहद बाँधकर वादा करता हूँ कि अब से ऐसा कभी नहीं होगा कि ज़मीन की तमाम ज़िंदगी सैलाब से ख़त्म कर दी जाएगी। अब से ऐसा सैलाब कभी नहीं आएगा जो पूरी ज़मीन को तबाह कर दे। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","इस अबदी अहद का निशान जो मैं तुम्हारे और तमाम जानदारों के साथ क़ायम कर रहा हूँ यह है कि ");
INSERT INTO urdgvh_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","मैं अपनी कमान बादलों में रखता हूँ। वह मेरे दुनिया के साथ अहद का निशान होगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","जब कभी मेरे कहने पर आसमान पर बादल छा जाएंगे और क़ौसे-क़ुज़ह उनमें से नज़र आएगी ");
INSERT INTO urdgvh_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","तो मैं यह अहद याद करूँगा जो तुम्हारे और तमाम जानदारों के साथ किया गया है। अब कभी भी ऐसा सैलाब नहीं आएगा जो तमाम ज़िंदगी को हलाक कर दे। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","क़ौसे-क़ुज़ह नज़र आएगी तो मैं उसे देखकर उस दायमी अहद को याद करूँगा जो मेरे और दुनिया की तमाम जानदार मख़लूक़ात के दरमियान है। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","यह उस अहद का निशान है जो मैंने दुनिया के तमाम जानदारों के साथ किया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","नूह के जो बेटे उसके साथ कश्ती से निकले सिम, हाम और याफ़त थे। हाम कनान का बाप था। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","दुनिया-भर के तमाम लोग इन तीनों की औलाद हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","नूह किसान था। शुरू में उसने अंगूर का बाग़ लगाया। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","अंगूर से मै बनाकर उसने इतनी पी ली कि वह नशे में धुत अपने डेरे में नंगा पड़ा रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","कनान के बाप हाम ने उसे यों पड़ा हुआ देखा तो बाहर जाकर अपने दोनों भाइयों को उसके बारे में बताया। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","यह सुनकर सिम और याफ़त ने अपने कंधों पर कपड़ा रखा। फिर वह उलटे चलते हुए डेरे में दाख़िल हुए और कपड़ा अपने बाप पर डाल दिया। उनके मुँह दूसरी तरफ़ मुड़े रहे ताकि बाप की बरहनगी नज़र न आए। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","जब नूह होश में आया तो उसको पता चला कि सबसे छोटे बेटे ने क्या किया है। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","उसने कहा, “कनान पर लानत! वह अपने भाइयों का ज़लीलतरीन ग़ुलाम होगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","मुबारक हो रब जो सिम का ख़ुदा है। कनान सिम का ग़ुलाम हो। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","अल्लाह करे कि याफ़त की हुदूद बढ़ जाएँ। याफ़त सिम के डेरों में रहे और कनान उसका ग़ुलाम हो।” ");
INSERT INTO urdgvh_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","सैलाब के बाद नूह मज़ीद 350 साल ज़िंदा रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","वह 950 साल की उम्र में फ़ौत हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","यह नूह के बेटों सिम, हाम और याफ़त का नसबनामा है। उनके बेटे सैलाब के बाद पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","याफ़त के बेटे जुमर, माजूज, मादी, यावान, तूबल, मसक और तीरास थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","जुमर के बेटे अश्कनाज़, रीफ़त और तुजरमा थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","यावान के बेटे इलीसा और तरसीस थे। कित्ती और दोदानी भी उस की औलाद हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","वह उन क़ौमों के आबा-ओ-अजदाद हैं जो साहिली इलाक़ों और जज़ीरों में फैल गईं। यह याफ़त की औलाद हैं जो अपने अपने क़बीले और मुल्क में रहते हुए अपनी अपनी ज़बान बोलते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","हाम के बेटे कूश, मिसर, फ़ूत और कनान थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","कूश के बेटे सिबा, हवीला, सबता, रामा और सब्तका थे। रामा के बेटे सबा और ददान थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","कूश का एक और बेटा बनाम नमरूद था। वह दुनिया में पहला ज़बरदस्त हाकिम था। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","रब के नज़दीक वह ज़बरदस्त शिकारी था। इसलिए आज भी किसी अच्छे शिकारी के बारे में कहा जाता है, “वह नमरूद की मानिंद है जो रब के नज़दीक ज़बरदस्त शिकारी था।” ");
INSERT INTO urdgvh_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","उस की सलतनत के पहले मरकज़ मुल्के-सिनार में बाबल, अरक, अक्काद और कलना के शहर थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","उस मुल्क से निकलकर वह असूर चला गया जहाँ उसने नीनवा, रहोबोत-ईर, कलह ");
INSERT INTO urdgvh_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","और रसन के शहर तामीर किए। बड़ा शहर रसन नीनवा और कलह के दरमियान वाक़े है। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","मिसर इन क़ौमों का बाप था : लूदी, अनामी, लिहाबी, नफ़तूही, ");
INSERT INTO urdgvh_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","फ़तरूसी, कसलूही (जिनसे फ़िलिस्ती निकले) और कफ़तूरी। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","कनान का पहलौठा सैदा था। कनान ज़ैल की क़ौमों का बाप भी था : हित्ती ");
INSERT INTO urdgvh_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","यबूसी, अमोरी, जिरजासी, ");
INSERT INTO urdgvh_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","हिव्वी, अरक़ी, सीनी, ");
INSERT INTO urdgvh_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अरवादी, समारी और हमाती। बाद में कनानी क़बीले इतने फैल गए ");
INSERT INTO urdgvh_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","कि उनकी हुदूद शिमाल में सैदा से जुनूब की तरफ़ जिरार से होकर ग़ज़्ज़ा तक और वहाँ से मशरिक़ की तरफ़ सदूम, अमूरा, अदमा और ज़बोईम से होकर लसा तक थीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","यह सब हाम की औलाद हैं, जो उनके अपने अपने क़बीले, अपनी अपनी ज़बान, अपने अपने मुल्क और अपनी अपनी क़ौम के मुताबिक़ दर्ज हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","सिम याफ़त का बड़ा भाई था। उसके भी बेटे पैदा हुए। सिम तमाम बनी इबर का बाप है। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","सिम के बेटे ऐलाम, असूर, अरफ़क्सद, लूद और अराम थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","अराम के बेटे ऊज़, हूल, जतर और मस थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","अरफ़क्सद का बेटा सिलह और सिलह का बेटा इबर था। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","इबर के हाँ दो बेटे पैदा हुए। एक का नाम फ़लज यानी तक़सीम था, क्योंकि उन ऐयाम में दुनिया तक़सीम हुई। फ़लज के भाई का नाम युक़तान था। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","युक़तान के बेटे अलमूदाद, सलफ़, हसरमावत, इराख़, ");
INSERT INTO urdgvh_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","हदूराम, ऊज़ाल, दिक़ला, ");
INSERT INTO urdgvh_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ऊबाल, अबीमाएल, सबा, ");
INSERT INTO urdgvh_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओफ़ीर, हवीला और यूबाब थे। यह सब युक़तान के बेटे थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","वह मेसा से लेकर सफ़ार और मशरिक़ी पहाड़ी इलाक़े तक आबाद थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","यह सब सिम की औलाद हैं, जो अपने अपने क़बीले, अपनी अपनी ज़बान, अपने अपने मुल्क और अपनी अपनी क़ौम के मुताबिक़ दर्ज हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","यह सब नूह के बेटों के क़बीले हैं, जो अपनी नसलों और क़ौमों के मुताबिक़ दर्ज किए गए हैं। सैलाब के बाद तमाम क़ौमें इन्हीं से निकलकर रूए-ज़मीन पर फैल गईं। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","उस वक़्त तक पूरी दुनिया के लोग एक ही ज़बान बोलते थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","मशरिक़ की तरफ़ बढ़ते बढ़ते वह सिनार के एक मैदान में पहुँचकर वहाँ आबाद हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","तब वह एक दूसरे से कहने लगे, “आओ, हम मिट्टी से ईंटें बनाकर उन्हें आग में ख़ूब पकाएँ।” उन्होंने तामीरी काम के लिए पत्थर की जगह ईंटें और मसाले की जगह तारकोल इस्तेमाल किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","फिर वह कहने लगे, “आओ, हम अपने लिए शहर बना लें जिसमें ऐसा बुर्ज हो जो आसमान तक पहुँच जाए फिर हमारा नाम क़ायम रहेगा और हम रूए-ज़मीन पर बिखर जाने से बच जाएंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","लेकिन रब उस शहर और बुर्ज को देखने के लिए उतर आया जिसे लोग बना रहे थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","रब ने कहा, “यह लोग एक ही क़ौम हैं और एक ही ज़बान बोलते हैं। और यह सिर्फ़ उसका आग़ाज़ है जो वह करना चाहते हैं। अब से जो भी वह मिलकर करना चाहेंगे उससे उन्हें रोका नहीं जा सकेगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","इसलिए आओ, हम दुनिया में उतरकर उनकी ज़बान को दरहम-बरहम कर दें ताकि वह एक दूसरे की बात समझ न पाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","इस तरीक़े से रब ने उन्हें तमाम रूए-ज़मीन पर मुंतशिर कर दिया, और शहर की तामीर रुक गई। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","इसलिए शहर का नाम बाबल यानी अबतरी ठहरा, क्योंकि रब ने वहाँ तमाम लोगों की ज़बान को दरहम-बरहम करके उन्हें तमाम रूए-ज़मीन पर मुंतशिर कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","यह सिम का नसबनामा है : सिम 100 साल का था जब उसका बेटा अरफ़क्सद पैदा हुआ। यह सैलाब के दो साल बाद हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","इसके बाद वह मज़ीद 500 साल ज़िंदा रहा। उसके और बेटे-बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","अरफ़क्सद 35 साल का था जब सिलह पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","इसके बाद वह मज़ीद 403 साल ज़िंदा रहा। उसके और बेटे-बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","सिलह 30 साल का था जब इबर पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","इसके बाद वह मज़ीद 403 साल ज़िंदा रहा। उसके और बेटे-बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","इबर 34 साल का था जब फ़लज पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","इसके बाद वह मज़ीद 430 साल ज़िंदा रहा। उसके और बेटे-बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","फ़लज 30 साल का था जब रऊ पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","इसके बाद वह मज़ीद 209 साल ज़िंदा रहा। उसके और बेटे-बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","रऊ 32 साल का था जब सरूज पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","इसके बाद वह मज़ीद 207 साल ज़िंदा रहा। उसके और बेटे-बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","सरूज 30 साल का था जब नहूर पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","इसके बाद वह मज़ीद 200 साल ज़िंदा रहा। उसके और बेटे-बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","नहूर 29 साल का था जब तारह पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","इसके बाद वह मज़ीद 119 साल ज़िंदा रहा। उसके और बेटे-बेटियाँ भी पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","तारह 70 साल का था जब उसके बेटे अब्राम, नहूर और हारान पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","यह तारह का नसबनामा है : अब्राम, नहूर और हारान तारह के बेटे थे। लूत हारान का बेटा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","अपने बाप तारह की ज़िंदगी में ही हारान कसदियों के ऊर में इंतक़ाल कर गया जहाँ वह पैदा भी हुआ था। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","बाक़ी दोनों बेटों की शादी हुई। अब्राम की बीवी का नाम सारय था और नहूर की बीवी का नाम मिलकाह। मिलकाह हारान की बेटी थी, और उस की एक बहन बनाम इस्का थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","सारय बाँझ थी, इसलिए उसके बच्चे नहीं थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","तारह कसदियों के ऊर से रवाना होकर मुल्के-कनान की तरफ़ सफ़र करने लगा। उसके साथ उसका बेटा अब्राम, उसका पोता लूत यानी हारान का बेटा और उस की बहू सारय थे। जब वह हारान पहुँचे तो वहाँ आबाद हो गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","तारह 205 साल का था जब उसने हारान में वफ़ात पाई। ");
INSERT INTO urdgvh_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","रब ने अब्राम से कहा, “अपने वतन, अपने रिश्तेदारों और अपने बाप के घर को छोड़कर उस मुल्क में चला जा जो मैं तुझे दिखाऊँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","मैं तुझसे एक बड़ी क़ौम बनाऊँगा, तुझे बरकत दूँगा और तेरे नाम को बहुत बढ़ाऊँगा। तू दूसरों के लिए बरकत का बाइस होगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","जो तुझे बरकत देंगे उन्हें मैं भी बरकत दूँगा। जो तुझ पर लानत करेगा उस पर मैं भी लानत करूँगा। दुनिया की तमाम क़ौमें तुझसे बरकत पाएँगी।” ");
INSERT INTO urdgvh_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","अब्राम ने रब की सुनी और हारान से रवाना हुआ। लूत उसके साथ था। उस वक़्त अब्राम 75 साल का था। ");
INSERT INTO urdgvh_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","उसके साथ उस की बीवी सारय और उसका भतीजा लूत थे। वह अपने नौकर-चाकरों समेत अपनी पूरी मिलकियत भी साथ ले गया जो उसने हारान में हासिल की थी। चलते चलते वह कनान पहुँचे। ");
INSERT INTO urdgvh_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","अब्राम उस मुल्क में से गुज़रकर सिकम के मक़ाम पर ठहर गया जहाँ मोरिह के बलूत का दरख़्त था। उस ज़माने में मुल्क में कनानी क़ौमें आबाद थीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","वहाँ रब अब्राम पर ज़ाहिर हुआ और उससे कहा, “मैं तेरी औलाद को यह मुल्क दूँगा।” इसलिए उसने वहाँ रब की ताज़ीम में क़ुरबानगाह बनाई जहाँ वह उस पर ज़ाहिर हुआ था। ");
INSERT INTO urdgvh_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","वहाँ से वह उस पहाड़ी इलाक़े की तरफ़ गया जो बैतेल के मशरिक़ में है। वहाँ उसने अपना ख़ैमा लगाया। मग़रिब में बैतेल था और मशरिक़ में अई। इस जगह पर भी उसने रब की ताज़ीम में क़ुरबानगाह बनाई और रब का नाम लेकर इबादत की। ");
INSERT INTO urdgvh_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","फिर अब्राम दुबारा रवाना होकर जुनूब के दश्ते-नजब की तरफ़ चल पड़ा। ");
INSERT INTO urdgvh_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","उन दिनों में मुल्के-कनान में काल पड़ा। काल इतना सख़्त था कि अब्राम उससे बचने की ख़ातिर कुछ देर के लिए मिसर में जा बसा, लेकिन परदेसी की हैसियत से। ");
INSERT INTO urdgvh_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","जब वह मिसर की सरहद के क़रीब आए तो उसने अपनी बीवी सारय से कहा, “मैं जानता हूँ कि तू कितनी ख़ूबसूरत है। ");
INSERT INTO urdgvh_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","मिसरी तुझे देखेंगे, फिर कहेंगे, ‘यह इसका शौहर है।’ नतीजे में वह मुझे मार डालेंगे और तुझे ज़िंदा छोड़ेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","इसलिए लोगों से यह कहते रहना कि मैं अब्राम की बहन हूँ। फिर मेरे साथ अच्छा सुलूक किया जाएगा और मेरी जान तेरे सबब से बच जाएगी।” ");
INSERT INTO urdgvh_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","जब अब्राम मिसर पहुँचा तो वाक़ई मिसरियों ने देखा कि सारय निहायत ही ख़ूबसूरत है। ");
INSERT INTO urdgvh_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","और जब फ़िरौन के अफ़सरान ने उसे देखा तो उन्होंने फ़िरौन के सामने सारय की तारीफ़ की। आख़िरकार उसे महल में पहुँचाया गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","फ़िरौन ने सारय की ख़ातिर अब्राम पर एहसान करके उसे भेड़-बकरियाँ, गाय-बैल, गधे-गधियाँ, नौकर-चाकर और ऊँट दिए। ");
INSERT INTO urdgvh_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","लेकिन रब ने सारय के सबब से फ़िरौन और उसके घराने में सख़्त क़िस्म के अमराज़ फैलाए। ");
INSERT INTO urdgvh_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","आख़िरकार फ़िरौन ने अब्राम को बुलाकर कहा, “तूने मेरे साथ क्या किया? तूने मुझे क्यों नहीं बताया कि सारय तेरी बीवी है? ");
INSERT INTO urdgvh_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","तूने क्यों कहा कि वह मेरी बहन है? इस धोके की बिना पर मैंने उसे घर में रख लिया ताकि उससे शादी करूँ। देख, तेरी बीवी हाज़िर है। इसे लेकर यहाँ से निकल जा!” ");
INSERT INTO urdgvh_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","फिर फ़िरौन ने अपने सिपाहियों को हुक्म दिया, और उन्होंने अब्राम, उस की बीवी और पूरी मिलकियत को रुख़सत करके मुल्क से रवाना कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","अब्राम अपनी बीवी, लूत और तमाम जायदाद को साथ लेकर मिसर से निकला और कनान के जुनूबी इलाक़े दश्ते-नजब में वापस आया। ");
INSERT INTO urdgvh_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","अब्राम निहायत दौलतमंद हो गया था। उसके पास बहुत-से मवेशी और सोना-चाँदी थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","वहाँ से जगह बजगह चलते हुए वह आख़िरकार बैतेल से होकर उस मक़ाम तक पहुँच गया जहाँ उसने शुरू में अपना डेरा लगाया था और जो बैतेल और अई के दरमियान था। ");
INSERT INTO urdgvh_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","वहाँ जहाँ उसने क़ुरबानगाह बनाई थी उसने रब का नाम लेकर उस की इबादत की। ");
INSERT INTO urdgvh_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","लूत के पास भी बहुत-सी भेड़-बकरियाँ, गाय-बैल और ख़ैमे थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","नतीजा यह निकला कि आख़िरकार वह मिलकर न रह सके, क्योंकि इतनी जगह नहीं थी कि दोनों के रेवड़ एक ही जगह पर चर सकें। ");
INSERT INTO urdgvh_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","अब्राम और लूत के चरवाहे आपस में झगड़ने लगे। (उस ज़माने में कनानी और फ़रिज़्ज़ी भी मुल्क में आबाद थे।) ");
INSERT INTO urdgvh_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","तब अब्राम ने लूत से बात की, “ऐसा नहीं होना चाहिए कि तेरे और मेरे दरमियान झगड़ा हो या तेरे चरवाहों और मेरे चरवाहों के दरमियान। हम तो भाई हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","क्या ज़रूरत है कि हम मिलकर रहें जबकि तू आसानी से इस मुल्क की किसी और जगह रह सकता है। बेहतर है कि तू मुझसे अलग होकर कहीं और रहे। अगर तू बाएँ हाथ जाए तो मैं दाएँ हाथ जाऊँगा, और अगर तू दाएँ हाथ जाए तो मैं बाएँ हाथ जाऊँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","लूत ने अपनी नज़र उठाकर देखा कि दरियाए-यरदन के पूरे इलाक़े में ज़ुग़र तक पानी की कसरत है। वह रब के बाग़ या मुल्के-मिसर की मानिंद था, क्योंकि उस वक़्त रब ने सदूम और अमूरा को तबाह नहीं किया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","चुनाँचे लूत ने दरियाए-यरदन के पूरे इलाक़े को चुन लिया और मशरिक़ की तरफ़ जा बसा। यों दोनों रिश्तेदार एक दूसरे से जुदा हो गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","अब्राम मुल्के-कनान में रहा जबकि लूत यरदन के इलाक़े के शहरों के दरमियान आबाद हो गया। वहाँ उसने अपने ख़ैमे सदूम के क़रीब लगा दिए। ");
INSERT INTO urdgvh_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","लेकिन सदूम के बाशिंदे निहायत शरीर थे, और उनके रब के ख़िलाफ़ गुनाह निहायत मकरूह थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","लूत अब्राम से जुदा हुआ तो रब ने अब्राम से कहा, “अपनी नज़र उठाकर चारों तरफ़ यानी शिमाल, जुनूब, मशरिक़ और मग़रिब की तरफ़ देख। ");
INSERT INTO urdgvh_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","जो भी ज़मीन तुझे नज़र आए उसे मैं तुझे और तेरी औलाद को हमेशा के लिए देता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","मैं तेरी औलाद को ख़ाक की तरह बेशुमार होने दूँगा। जिस तरह ख़ाक के ज़र्रे गिने नहीं जा सकते उसी तरह तेरी औलाद भी गिनी नहीं जा सकेगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","चुनाँचे उठकर इस मुल्क की हर जगह चल-फिर, क्योंकि मैं इसे तुझे देता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","अब्राम रवाना हुआ। चलते चलते उसने अपने डेरे हबरून के क़रीब ममरे के दरख़्तों के पास लगाए। वहाँ उसने रब की ताज़ीम में क़ुरबानगाह बनाई। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","कनान में जंग हुई। बैरूने-मुल्क के चार बादशाहों ने कनान के पाँच बादशाहों से जंग की। बैरूने-मुल्क के बादशाह यह थे : सिनार से अमराफ़िल, इल्लासर से अरयूक, ऐलाम से किदरलाउमर और जोयम से तिदाल। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","कनान के बादशाह यह थे : सदूम से बिरा, अमूरा से बिरशा, अदमा से सिनियाब, ज़बोईम से शिमेबर और बाला यानी ज़ुग़र का बादशाह। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","कनान के इन पाँच बादशाहों का इत्तहाद हुआ था और वह वादीए-सिद्दीम में जमा हुए थे। (अब सिद्दीम नहीं है, क्योंकि उस की जगह बहीराए-मुरदार आ गया है)। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","किदरलाउमर ने बारह साल तक उन पर हुकूमत की थी, लेकिन तेरहवें साल वह बाग़ी हो गए थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","अब एक साल के बाद किदरलाउमर और उसके इत्तहादी अपनी फ़ौजों के साथ आए। पहले उन्होंने अस्तारात-क़रनैम में रफ़ाइयों को, हाम में ज़ूज़ियों को, सवी-क़िरियतायम में ऐमियों को ");
INSERT INTO urdgvh_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","और होरियों को उनके पहाड़ी इलाक़े सईर में शिकस्त दी। यों वह एल-फ़ारान तक पहुँच गए जो रेगिस्तान के किनारे पर है। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","फिर वह वापस आए और ऐन-मिसफ़ात यानी क़ादिस पहुँचे। उन्होंने अमालीक़ियों के पूरे इलाक़े को तबाह कर दिया और हससून-तमर में आबाद अमोरियों को भी शिकस्त दी। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","उस वक़्त सदूम, अमूरा, अदमा, ज़बोईम और बाला यानी ज़ुग़र के बादशाह उनसे लड़ने के लिए सिद्दीम की वादी में जमा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","इन पाँच बादशाहों ने ऐलाम के बादशाह किदरलाउमर, जोयम के बादशाह तिदाल, सिनार के बादशाह अमराफ़िल और इल्लासर के बादशाह अरयूक का मुक़ाबला किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","इस वादी में तारकोल के मुतअद्दिद गढ़े थे। जब बाग़ी बादशाह शिकस्त खाकर भागने लगे तो सदूम और अमूरा के बादशाह इन गढ़ों में गिर गए जबकि बाक़ी तीन बादशाह बचकर पहाड़ी इलाक़े में फ़रार हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","फ़तहमंद बादशाह सदूम और अमूरा का तमाम माल तमाम खानेवाली चीज़ों समेत लूटकर वापस चल दिए। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","अब्राम का भतीजा लूत सदूम में रहता था, इसलिए वह उसे भी उस की मिलकियत समेत छीनकर साथ ले गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","लेकिन एक आदमी ने जो बच निकला था इबरानी मर्द अब्राम के पास आकर उसे सब कुछ बता दिया। उस वक़्त वह ममरे के दरख़्तों के पास आबाद था। ममरे अमोरी था। वह और उसके भाई इसकाल और आनेर अब्राम के इत्तहादी थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","जब अब्राम को पता चला कि भतीजे को गिरिफ़्तार कर लिया गया है तो उसने अपने घर में पैदा हुए तमाम जंगआज़मूदा ग़ुलामों को जमा करके दान तक दुश्मन का ताक़्क़ुब किया। उसके साथ 318 अफ़राद थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","वहाँ उसने अपने बंदों को गुरोहों में तक़सीम करके रात के वक़्त दुश्मन पर हमला किया। दुश्मन शिकस्त खाकर भाग गया और अब्राम ने दमिश्क़ के शिमाल में वाक़े ख़ूबा तक उसका ताक़्क़ुब किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","वह उनसे लूटा हुआ तमाम माल वापस ले आया। लूत, उस की जायदाद, औरतें और बाक़ी क़ैदी भी दुश्मन के क़ब्ज़े से बच निकले। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","जब अब्राम किदरलाउमर और उसके इत्तहादियों पर फ़तह पाने के बाद वापस पहुँचा तो सदूम का बादशाह उससे मिलने के लिए वादीए-सवी में आया। (इसे आजकल बादशाह की वादी कहा जाता है।) ");
INSERT INTO urdgvh_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","सालिम का बादशाह मलिके-सिद्क़ भी वहाँ पहुँचा। वह अपने साथ रोटी और मै ले आया। मलिके-सिद्क़ अल्लाह तआला का इमाम था। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","उसने अब्राम को बरकत देकर कहा, “अब्राम पर अल्लाह तआला की बरकत हो, जो आसमानो-ज़मीन का ख़ालिक़ है। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","अल्लाह तआला मुबारक हो जिसने तेरे दुश्मनों को तेरे हाथ में कर दिया है।” अब्राम ने उसे तमाम माल का दसवाँ हिस्सा दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","सदूम के बादशाह ने अब्राम से कहा, “मुझे मेरे लोग वापस कर दें और बाक़ी चीज़ें अपने पास रख लें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","लेकिन अब्राम ने उससे कहा, “मैंने रब से क़सम खाई है, अल्लाह तआला से जो आसमानो-ज़मीन का ख़ालिक़ है ");
INSERT INTO urdgvh_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","कि मैं उसमें से कुछ नहीं लूँगा जो आपका है, चाहे वह धागा या जूती का तसमा ही क्यों न हो। ऐसा न हो कि आप कहें, ‘मैंने अब्राम को दौलतमंद बना दिया है।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","सिवाए उस खाने के जो मेरे आदमियों ने रास्ते में खाया है मैं कुछ क़बूल नहीं करूँगा। लेकिन मेरे इत्तहादी आनेर, इसकाल और ममरे ज़रूर अपना अपना हिस्सा लें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","इसके बाद रब रोया में अब्राम से हमकलाम हुआ, “अब्राम, मत डर। मैं ही तेरी सिपर हूँ, मैं ही तेरा बहुत बड़ा अज्र हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","लेकिन अब्राम ने एतराज़ किया, “ऐ रब क़ादिरे-मुतलक़, तू मुझे क्या देगा जबकि अभी तक मेरे हाँ कोई बच्चा नहीं है और इलियज़र दमिश्क़ी मेरी मीरास पाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","तूने मुझे औलाद नहीं बख़्शी, इसलिए मेरे घराने का नौकर मेरा वारिस होगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","तब अब्राम को अल्लाह से एक और कलाम मिला। “यह आदमी इलियज़र तेरा वारिस नहीं होगा बल्कि तेरा अपना ही बेटा तेरा वारिस होगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","रब ने उसे बाहर ले जाकर कहा, “आसमान की तरफ़ देख और सितारों को गिनने की कोशिश कर। तेरी औलाद इतनी ही बेशुमार होगी।” ");
INSERT INTO urdgvh_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","अब्राम ने रब पर भरोसा रखा। इस बिना पर अल्लाह ने उसे रास्तबाज़ क़रार दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","फिर रब ने उससे कहा, “मैं रब हूँ जो तुझे कसदियों के ऊर से यहाँ ले आया ताकि तुझे यह मुल्क मीरास में दे दूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","अब्राम ने पूछा, “ऐ रब क़ादिरे-मुतलक़, मैं किस तरह जानूँ कि इस मुल्क पर क़ब्ज़ा करूँगा?” ");
INSERT INTO urdgvh_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","जवाब में रब ने कहा, “मेरे हुज़ूर एक तीन-साला गाय, एक तीन-साला बकरी और एक तीन-साला मेंढा ले आ। एक क़ुम्री और एक कबूतर का बच्चा भी ले आना।” ");
INSERT INTO urdgvh_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","अब्राम ने ऐसा ही किया और फिर हर एक जानवर को दो हिस्सों में काटकर उनको एक दूसरे के आमने-सामने रख दिया। लेकिन परिंदों को उसने सालिम रहने दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","शिकारी परिंदे उन पर उतरने लगे, लेकिन अब्राम उन्हें भगाता रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","जब सूरज डूबने लगा तो अब्राम पर गहरी नींद तारी हुई। उस पर दहशत और अंधेरा ही अंधेरा छा गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","फिर रब ने उससे कहा, “जान ले कि तेरी औलाद ऐसे मुल्क में रहेगी जो उसका नहीं होगा। वहाँ वह अजनबी और ग़ुलाम होगी, और उस पर 400 साल तक बहुत ज़ुल्म किया जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","लेकिन मैं उस क़ौम की अदालत करूँगा जिसने उसे ग़ुलाम बनाया होगा। इसके बाद वह बड़ी दौलत पाकर उस मुल्क से निकलेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","तू ख़ुद उम्ररसीदा होकर सलामती के साथ इंतक़ाल करके अपने बापदादा से जा मिलेगा और दफ़नाया जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","तेरी औलाद की चौथी पुश्त ग़ैरवतन से वापस आएगी, क्योंकि उस वक़्त तक मैं अमोरियों को बरदाश्त करूँगा। लेकिन आख़िरकार उनके गुनाह इतने संगीन हो जाएंगे कि मैं उन्हें मुल्के-कनान से निकाल दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","सूरज ग़ुरूब हुआ। अंधेरा छा गया। अचानक एक धुआँदार तनूर और एक भड़कती हुई मशाल नज़र आई और जानवरों के दो दो टुकड़ों के बीच में से गुज़रे। ");
INSERT INTO urdgvh_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","उस वक़्त रब ने अब्राम के साथ अहद किया। उसने कहा, “मैं यह मुल्क मिसर की सरहद से फ़ुरात तक तेरी औलाद को दूँगा, ");
INSERT INTO urdgvh_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","अगरचे अभी तक इसमें क़ीनी, क़निज़्ज़ी, कदमूनी, ");
INSERT INTO urdgvh_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हित्ती, फ़रिज़्ज़ी, रफ़ाई, ");
INSERT INTO urdgvh_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","अमोरी, कनानी, जिरजासी और यबूसी आबाद हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","अब तक अब्राम की बीवी सारय के कोई बच्चा नहीं हुआ था। लेकिन उन्होंने एक मिसरी लौंडी रखी थी जिसका नाम हाजिरा था, ");
INSERT INTO urdgvh_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","और एक दिन सारय ने अब्राम से कहा, “रब ने मुझे बच्चे पैदा करने से महरूम रखा है, इसलिए मेरी लौंडी के साथ हमबिसतर हों। शायद मुझे उस की मारिफ़त बच्चा मिल जाए।” अब्राम ने सारय की बात मान ली। ");
INSERT INTO urdgvh_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","चुनाँचे सारय ने अपनी मिसरी लौंडी हाजिरा को अपने शौहर अब्राम को दे दिया ताकि वह उस की बीवी बन जाए उस वक़्त अब्राम को कनान में बसते हुए दस साल हो गए थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","अब्राम हाजिरा से हमबिसतर हुआ तो वह उम्मीद से हो गई। जब हाजिरा को यह मालूम हुआ तो वह अपनी मालिकन को हक़ीर जानने लगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","तब सारय ने अब्राम से कहा, “जो ज़ुल्म मुझ पर किया जा रहा है वह आप ही पर आए। मैंने ख़ुद इसे आपके बाज़ुओं में दे दिया था। अब जब इसे मालूम हुआ है कि उम्मीद से है तो मुझे हक़ीर जानने लगी है। रब मेरे और आपके दरमियान फ़ैसला करे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","अब्राम ने जवाब दिया, “देखो, यह तुम्हारी लौंडी है और तुम्हारे इख़्तियार में है। जो तुम्हारा जी चाहे उसके साथ करो।” इस पर सारय उससे इतना बुरा सुलूक करने लगी कि हाजिरा फ़रार हो गई। ");
INSERT INTO urdgvh_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","रब के फ़रिश्ते को हाजिरा रेगिस्तान के उस चश्मे के क़रीब मिली जो शूर के रास्ते पर है। ");
INSERT INTO urdgvh_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","उसने कहा, “सारय की लौंडी हाजिरा, तू कहाँ से आ रही है और कहाँ जा रही है?” हाजिरा ने जवाब दिया, “मैं अपनी मालिकन सारय से फ़रार हो रही हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","रब के फ़रिश्ते ने उससे कहा, “अपनी मालिकन के पास वापस चली जा और उसके ताबे रह। ");
INSERT INTO urdgvh_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","मैं तेरी औलाद इतनी बढ़ाऊँगा कि उसे गिना नहीं जा सकेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","रब के फ़रिश्ते ने मज़ीद कहा, “तू उम्मीद से है। एक बेटा पैदा होगा। उसका नाम इसमाईल यानी ‘अल्लाह सुनता है’ रख, क्योंकि रब ने मुसीबत में तेरी आवाज़ सुनी। ");
INSERT INTO urdgvh_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","वह जंगली गधे की मानिंद होगा। उसका हाथ हर एक के ख़िलाफ़ और हर एक का हाथ उसके ख़िलाफ़ होगा। तो भी वह अपने तमाम भाइयों के सामने आबाद रहेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","रब के उसके साथ बात करने के बाद हाजिरा ने उसका नाम अत्ताएल-रोई यानी ‘तू एक माबूद है जो मुझे देखता है’ रखा। उसने कहा, “क्या मैंने वाक़ई उसके पीछे देखा है जिसने मुझे देखा है?” ");
INSERT INTO urdgvh_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","इसलिए उस जगह के कुएँ का नाम ‘बैर-लही-रोई’ यानी ‘उस ज़िंदा हस्ती का कुआँ जो मुझे देखता है’ पड़ गया। वह क़ादिस और बरद के दरमियान वाक़े है। ");
INSERT INTO urdgvh_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","हाजिरा वापस गई, और उसके बेटा पैदा हुआ। अब्राम ने उसका नाम इसमाईल रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","उस वक़्त अब्राम 86 साल का था। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","जब अब्राम 99 साल का था तो रब उस पर ज़ाहिर हुआ। उसने कहा, “मैं अल्लाह क़ादिरे-मुतलक़ हूँ। मेरे हुज़ूर चलता रह और बेइलज़ाम हो। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","मैं तेरे साथ अपना अहद बाँधूँगा और तेरी औलाद को बहुत ही ज़्यादा बढ़ा दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","अब्राम मुँह के बल गिर गया, और अल्लाह ने उससे कहा, ");
INSERT INTO urdgvh_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“मेरा तेरे साथ अहद है कि तू बहुत क़ौमों का बाप होगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","अब से तू अब्राम यानी ‘अज़ीम बाप’ नहीं कहलाएगा बल्कि तेरा नाम इब्राहीम यानी ‘बहुत क़ौमों का बाप’ होगा। क्योंकि मैंने तुझे बहुत क़ौमों का बाप बना दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","मैं तुझे बहुत ही ज़्यादा औलाद बख़्श दूँगा, इतनी कि क़ौमें बनेंगी। तुझसे बादशाह भी निकलेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","मैं अपना अहद तेरे और तेरी औलाद के साथ नसल-दर-नसल क़ायम करूँगा, एक अबदी अहद जिसके मुताबिक़ मैं तेरा और तेरी औलाद का ख़ुदा हूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","तू इस वक़्त मुल्के-कनान में परदेसी है, लेकिन मैं इस पूरे मुल्क को तुझे और तेरी औलाद को देता हूँ। यह हमेशा तक उनका ही रहेगा, और मैं उनका ख़ुदा हूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","अल्लाह ने इब्राहीम से यह भी कहा, “तुझे और तेरी औलाद को नसल-दर-नसल मेरे अहद की शरायत पूरी करनी हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","इसकी एक शर्त यह है कि हर एक मर्द का ख़तना किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","अपना ख़तना कराओ। यह हमारे आपस के अहद का ज़ाहिरी निशान होगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","लाज़िम है कि तू और तेरी औलाद नसल-दर-नसल अपने हर एक बेटे का आठवें दिन ख़तना करवाएँ। यह उसूल उस पर भी लागू है जो तेरे घर में रहता है लेकिन तुझसे रिश्ता नहीं रखता, चाहे वह घर में पैदा हुआ हो या किसी अजनबी से ख़रीदा गया हो। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","घर के हर एक मर्द का ख़तना करना लाज़िम है, ख़ाह वह घर में पैदा हुआ हो या किसी अजनबी से ख़रीदा गया हो। यह इस बात का निशान होगा कि मेरा तेरे साथ अहद हमेशा तक क़ायम रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","जिस मर्द का ख़तना न किया गया उसे उस की क़ौम में से मिटाया जाएगा, क्योंकि उसने मेरे अहद की शरायत पूरी न कीं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","अल्लाह ने इब्राहीम से यह भी कहा, “अपनी बीवी सारय का नाम भी बदल देना। अब से उसका नाम सारय नहीं बल्कि सारा यानी शहज़ादी होगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","मैं उसे बरकत बख़्शूँगा और तुझे उस की मारिफ़त बेटा दूँगा। मैं उसे यहाँ तक बरकत दूँगा कि उससे क़ौमें बल्कि क़ौमों के बादशाह निकलेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","इब्राहीम मुँह के बल गिर गया। लेकिन दिल ही दिल में वह हँस पड़ा और सोचा, “यह किस तरह हो सकता है? मैं तो 100 साल का हूँ। ऐसे आदमी के हाँ बच्चा किस तरह पैदा हो सकता है? और सारा जैसी उम्ररसीदा औरत के बच्चा किस तरह पैदा हो सकता है? उस की उम्र तो 90 साल है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","उसने अल्लाह से कहा, “हाँ, इसमाईल ही तेरे सामने जीता रहे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","अल्लाह ने कहा, “नहीं, तेरी बीवी सारा के हाँ बेटा पैदा होगा। तू उसका नाम इसहाक़ यानी ‘वह हँसता है’ रखना। मैं उसके और उस की औलाद के साथ अबदी अहद बाँधूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","मैं इसमाईल के सिलसिले में भी तेरी दरख़ास्त पूरी करूँगा। मैं उसे भी बरकत देकर फलने फूलने दूँगा और उस की औलाद बहुत ही ज़्यादा बढ़ा दूँगा। वह बारह रईसों का बाप होगा, और मैं उस की मारिफ़त एक बड़ी क़ौम बनाऊँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","लेकिन मेरा अहद इसहाक़ के साथ होगा, जो ऐन एक साल के बाद सारा के हाँ पैदा होगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","अल्लाह की इब्राहीम के साथ बात ख़त्म हुई, और वह उसके पास से आसमान पर चला गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","उसी दिन इब्राहीम ने अल्लाह का हुक्म पूरा किया। उसने घर के हर एक मर्द का ख़तना करवाया, अपने बेटे इसमाईल का भी और उनका भी जो उसके घर में रहते लेकिन उससे रिश्ता नहीं रखते थे, चाहे वह उसके घर में पैदा हुए थे या ख़रीदे गए थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","इब्राहीम 99 साल का था जब उसका ख़तना हुआ, ");
INSERT INTO urdgvh_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","जबकि उसका बेटा इसमाईल 13 साल का था। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","दोनों का ख़तना उसी दिन हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","साथ साथ घराने के तमाम बाक़ी मर्दों का ख़तना भी हुआ, बशमूल उनके जिनका इब्राहीम के साथ रिश्ता नहीं था, चाहे वह घर में पैदा हुए या किसी अजनबी से ख़रीदे गए थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","एक दिन रब ममरे के दरख़्तों के पास इब्राहीम पर ज़ाहिर हुआ। इब्राहीम अपने ख़ैमे के दरवाज़े पर बैठा था। दिन की गरमी उरूज पर थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","अचानक उसने देखा कि तीन मर्द मेरे सामने खड़े हैं। उन्हें देखते ही वह ख़ैमे से उनसे मिलने के लिए दौड़ा और मुँह के बल गिरकर सिजदा किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","उसने कहा, “मेरे आक़ा, अगर मुझ पर आपके करम की नज़र है तो आगे न बढ़ें बल्कि कुछ देर अपने बंदे के घर ठहरें। ");
INSERT INTO urdgvh_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","अगर इजाज़त हो तो मैं कुछ पानी ले आऊँ ताकि आप अपने पाँव धोकर दरख़्त के साये में आराम कर सकें। ");
INSERT INTO urdgvh_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","साथ साथ मैं आपके लिए थोड़ा-बहुत खाना भी ले आऊँ ताकि आप तक़वियत पाकर आगे बढ़ सकें। मुझे यह करने दें, क्योंकि आप अपने ख़ादिम के घर आ गए हैं।” उन्होंने कहा, “ठीक है। जो कुछ तूने कहा है वह कर।” ");
INSERT INTO urdgvh_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","इब्राहीम ख़ैमे की तरफ़ दौड़कर सारा के पास आया और कहा, “जल्दी करो! 16 किलोग्राम बेहतरीन मैदा ले और उसे गूँधकर रोटियाँ बना।” ");
INSERT INTO urdgvh_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","फिर वह भागकर बैलों के पास पहुँचा। उनमें से उसने एक मोटा-ताज़ा बछड़ा चुन लिया जिसका गोश्त नरम था और उसे अपने नौकर को दिया जिसने जल्दी से उसे तैयार किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","जब खाना तैयार था तो इब्राहीम ने उसे लेकर लस्सी और दूध के साथ अपने मेहमानों के आगे रख दिया। वह खाने लगे और इब्राहीम उनके सामने दरख़्त के साये में खड़ा रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","उन्होंने पूछा, “तेरी बीवी सारा कहाँ है?” उसने जवाब दिया, “ख़ैमे में।” ");
INSERT INTO urdgvh_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","रब ने कहा, “ऐन एक साल के बाद मैं वापस आऊँगा तो तेरी बीवी सारा के बेटा होगा।” सारा यह बातें सुन रही थी, क्योंकि वह उसके पीछे ख़ैमे के दरवाज़े के पास थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","दोनों मियाँ-बीवी बूढ़े हो चुके थे और सारा उस उम्र से गुज़र चुकी थी जिसमें औरतों के बच्चे पैदा होते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","इसलिए सारा अंदर ही अंदर हँस पड़ी और सोचा, “यह कैसे हो सकता है? क्या जब मैं बुढ़ापे के बाइस घिसे-फटे लिबास की मानिंद हूँ तो जवानी के जोबन का लुत्फ़ उठाऊँ? और मेरा शौहर भी बूढ़ा है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","रब ने इब्राहीम से पूछा, “सारा क्यों हँस रही है? वह क्यों कह रही है, ‘क्या वाक़ई मेरे हाँ बच्चा पैदा होगा जबकि मैं इतनी उम्ररसीदा हूँ?’ ");
INSERT INTO urdgvh_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","क्या रब के लिए कोई काम नामुमकिन है? एक साल के बाद मुक़र्ररा वक़्त पर मैं वापस आऊँगा तो सारा के बेटा होगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","सारा डर गई। उसने झूट बोलकर इनकार किया, “मैं नहीं हँस रही थी।” रब ने कहा, “नहीं, तू ज़रूर हँस रही थी।” ");
INSERT INTO urdgvh_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","फिर मेहमान उठकर रवाना हुए और नीचे वादी में सदूम की तरफ़ देखने लगे। इब्राहीम उन्हें रुख़सत करने के लिए साथ साथ चल रहा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","रब ने दिल में कहा, “मैं इब्राहीम से वह काम क्यों छुपाए रखूँ जो मैं करने के लिए जा रहा हूँ? ");
INSERT INTO urdgvh_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","इसी से तो एक बड़ी और ताक़तवर क़ौम निकलेगी और इसी से मैं दुनिया की तमाम क़ौमों को बरकत दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","उसी को मैंने चुन लिया है ताकि वह अपनी औलाद और अपने बाद के घराने को हुक्म दे कि वह रब की राह पर चलकर रास्त और मुंसिफ़ाना काम करें। क्योंकि अगर वह ऐसा करें तो रब इब्राहीम के साथ अपना वादा पूरा करेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","फिर रब ने कहा, “सदूम और अमूरा की बदी के बाइस लोगों की आहें बुलंद हो रही हैं, क्योंकि उनसे बहुत संगीन गुनाह सरज़द हो रहे हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","मैं उतरकर उनके पास जा रहा हूँ ताकि देखूँ कि यह इलज़ाम वाक़ई सच हैं जो मुझ तक पहुँचे हैं। अगर ऐसा नहीं है तो मैं यह जानना चाहता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","दूसरे दो आदमी सदूम की तरफ़ आगे निकले जबकि रब कुछ देर के लिए वहाँ ठहरा रहा और इब्राहीम उसके सामने खड़ा रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","फिर उसने क़रीब आकर उससे बात की, “क्या तू रास्तबाज़ों को भी शरीरों के साथ तबाह कर देगा? ");
INSERT INTO urdgvh_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","हो सकता है कि शहर में 50 रास्तबाज़ हों। क्या तू फिर भी शहर को बरबाद कर देगा और उसे उन 50 के सबब से मुआफ़ नहीं करेगा? ");
INSERT INTO urdgvh_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","यह कैसे हो सकता है कि तू बेक़ुसूरों को शरीरों के साथ हलाक कर दे? यह तो नामुमकिन है कि तू नेक और शरीर लोगों से एक जैसा सुलूक करे। क्या लाज़िम नहीं कि पूरी दुनिया का मुंसिफ़ इनसाफ़ करे?” ");
INSERT INTO urdgvh_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","रब ने जवाब दिया, “अगर मुझे शहर में 50 रास्तबाज़ मिल जाएँ तो उनके सबब से तमाम को मुआफ़ कर दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","इब्राहीम ने कहा, “मैं मुआफ़ी चाहता हूँ कि मैंने रब से बात करने की जुर्रत की है अगरचे मैं ख़ाक और राख ही हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","लेकिन हो सकता है कि सिर्फ़ 45 रास्तबाज़ उसमें हों। क्या तू फिर भी उन पाँच लोगों की कमी के सबब से पूरे शहर को तबाह करेगा?” उसने कहा, “अगर मुझे 45 भी मिल जाएँ तो उसे बरबाद नहीं करूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","इब्राहीम ने अपनी बात जारी रखी, “और अगर सिर्फ़ 40 नेक लोग हों तो?” रब ने कहा, “मैं उन 40 के सबब से उन्हें छोड़ दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","इब्राहीम ने कहा, “रब ग़ुस्सा न करे कि मैं एक दफ़ा और बात करूँ। शायद वहाँ सिर्फ़ 30 हों।” उसने जवाब दिया, “फिर भी उन्हें छोड़ दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","इब्राहीम ने कहा, “मैं मुआफ़ी चाहता हूँ कि मैंने रब से बात करने की जुर्रत की है। अगर सिर्फ़ 20 पाए जाएँ?” रब ने कहा, “मैं 20 के सबब से शहर को बरबाद करने से बाज़ रहूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","इब्राहीम ने एक आख़िरी दफ़ा बात की, “रब ग़ुस्सा न करे अगर मैं एक और बार बात करूँ। शायद उसमें सिर्फ़ 10 पाए जाएँ।” रब ने कहा, “मैं उसे उन 10 लोगों के सबब से भी बरबाद नहीं करूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","इन बातों के बाद रब चला गया और इब्राहीम अपने घर को लौट आया। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","शाम के वक़्त यह दो फ़रिश्ते सदूम पहुँचे। लूत शहर के दरवाज़े पर बैठा था। जब उसने उन्हें देखा तो खड़े होकर उनसे मिलने गया और मुँह के बल गिरकर सिजदा किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","उसने कहा, “साहबो, अपने बंदे के घर तशरीफ़ लाएँ ताकि अपने पाँव धोकर रात को ठहरें और फिर कल सुबह-सवेरे उठकर अपना सफ़र जारी रखें।” उन्होंने कहा, “कोई बात नहीं, हम चौक में रात गुज़ारेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","लेकिन लूत ने उन्हें बहुत मजबूर किया, और आख़िरकार वह उसके साथ उसके घर आए। उसने उनके लिए खाना पकाया और बेख़मीरी रोटी बनाई। फिर उन्होंने खाना खाया। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","वह अभी सोने के लिए लेटे नहीं थे कि शहर के जवानों से लेकर बूढ़ों तक तमाम मर्दों ने लूत के घर को घेर लिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","उन्होंने आवाज़ देकर लूत से कहा, “वह आदमी कहाँ हैं जो रात के वक़्त तेरे पास आए? उनको बाहर ले आ ताकि हम उनके साथ हरामकारी करें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","लूत उनसे मिलने बाहर गया। उसने अपने पीछे दरवाज़ा बंद कर लिया ");
INSERT INTO urdgvh_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","और कहा, “मेरे भाइयो, ऐसा मत करो, ऐसी बदकारी न करो। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","देखो, मेरी दो कुँवारी बेटियाँ हैं। उन्हें मैं तुम्हारे पास बाहर ले आता हूँ। फिर जो जी चाहे उनके साथ करो। लेकिन इन आदमियों को छोड़ दो, क्योंकि वह मेरे मेहमान हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","उन्होंने कहा, “रास्ते से हट जा! देखो, यह शख़्स जब हमारे पास आया था तो अजनबी था, और अब यह हम पर हाकिम बनना चाहता है। अब तेरे साथ उनसे ज़्यादा बुरा सुलूक करेंगे।” वह उसे मजबूर करते करते दरवाज़े को तोड़ने के लिए आगे बढ़े। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","लेकिन ऐन वक़्त पर अंदर के आदमी लूत को पकड़कर अंदर ले आए, फिर दरवाज़ा दुबारा बंद कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","उन्होंने छोटों से लेकर बड़ों तक बाहर के तमाम आदमियों को अंधा कर दिया, और वह दरवाज़े को ढूँडते ढूँडते थक गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","दोनों आदमियों ने लूत से कहा, “क्या तेरा कोई और रिश्तेदार इस शहर में रहता है, मसलन कोई दामाद या बेटा-बेटी? सबको साथ लेकर यहाँ से चला जा, ");
INSERT INTO urdgvh_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","क्योंकि हम यह मक़ाम तबाह करने को हैं। इसके बाशिंदों की बदी के बाइस लोगों की आहें बुलंद होकर रब के हुज़ूर पहुँच गई हैं, इसलिए उसने हमें इसको तबाह करने के लिए भेजा है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","लूत घर से निकला और अपने दामादों से बात की जिनका उस की बेटियों के साथ रिश्ता हो चुका था। उसने कहा, “जल्दी करो, इस जगह से निकलो, क्योंकि रब इस शहर को तबाह करने को है।” लेकिन उसके दामादों ने इसे मज़ाक़ ही समझा। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","जब पौ फटने लगी तो दोनों आदमियों ने लूत को बहुत समझाया और कहा, “जल्दी कर! अपनी बीवी और दोनों बेटियों को साथ लेकर चला जा, वरना जब शहर को सज़ा दी जाएगी तो तू भी हलाक हो जाएगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","तो भी वह झिजकता रहा। आख़िरकार दोनों ने लूत, उस की बीवी और बेटियों के हाथ पकड़कर उन्हें शहर के बाहर तक पहुँचा दिया, क्योंकि रब को लूत पर तरस आता था। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ज्योंही वह उन्हें बाहर ले आए उनमें से एक ने कहा, “अपनी जान बचाकर चला जा। पीछे मुड़कर न देखना। मैदान में कहीं न ठहरना बल्कि पहाड़ों में पनाह लेना, वरना तू हलाक हो जाएगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","लेकिन लूत ने उनसे कहा, “नहीं मेरे आक़ा, ऐसा न हो। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","तेरे बंदे को तेरी नज़रे-करम हासिल हुई है और तूने मेरी जान बचाने में बहुत मेहरबानी कर दिखाई है। लेकिन मैं पहाड़ों में पनाह नहीं ले सकता। वहाँ पहुँचने से पहले यह मुसीबत मुझ पर आन पड़ेगी और मैं हलाक हो जाऊँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","देख, क़रीब ही एक छोटा क़सबा है। वह इतना नज़दीक है कि मैं उस तरफ़ हिजरत कर सकता हूँ। मुझे वहाँ पनाह लेने दे। वह छोटा ही है, ना? फिर मेरी जान बचेगी।” ");
INSERT INTO urdgvh_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","उसने कहा, “चलो, ठीक है। तेरी यह दरख़ास्त भी मंज़ूर है। मैं यह क़सबा तबाह नहीं करूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","लेकिन भागकर वहाँ पनाह ले, क्योंकि जब तक तू वहाँ पहुँच न जाए मैं कुछ नहीं कर सकता।” इसलिए क़सबे का नाम ज़ुग़र यानी छोटा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","जब लूत ज़ुग़र पहुँचा तो सूरज निकला हुआ था। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","तब रब ने आसमान से सदूम और अमूरा पर गंधक और आग बरसाई। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","यों उसने उस पूरे मैदान को उसके शहरों, बाशिंदों और तमाम हरियाली समेत तबाह कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","लेकिन फ़रार होते वक़्त लूत की बीवी ने पीछे मुड़कर देखा तो वह फ़ौरन नमक का सतून बन गई। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","इब्राहीम सुबह-सवेरे उठकर उस जगह वापस आया जहाँ वह कल रब के सामने खड़ा हुआ था। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","जब उसने नीचे सदूम, अमूरा और पूरी वादी की तरफ़ नज़र की तो वहाँ से भट्टे का-सा धुआँ उठ रहा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","यों अल्लाह ने इब्राहीम को याद किया जब उसने उस मैदान के शहर तबाह किए। क्योंकि वह उन्हें तबाह करने से पहले लूत को जो उनमें आबाद था वहाँ से निकाल लाया। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","लूत और उस की बेटियाँ ज़्यादा देर तक ज़ुग़र में न ठहरे। वह रवाना होकर पहाड़ों में आबाद हुए, क्योंकि लूत ज़ुग़र में रहने से डरता था। वहाँ उन्होंने एक ग़ार को अपना घर बना लिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","एक दिन बड़ी बेटी ने छोटी से कहा, “अब्बू बूढ़ा है और यहाँ कोई मर्द है नहीं जिसके ज़रीए हमारे बच्चे पैदा हो सकें। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","आओ, हम अब्बू को मै पिलाएँ। जब वह नशे में धुत हो तो हम उसके साथ हमबिसतर होकर अपने लिए औलाद पैदा करें ताकि हमारी नसल क़ायम रहे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","उस रात उन्होंने अपने बाप को मै पिलाई। जब वह नशे में था तो बड़ी बेटी अंदर जाकर उसके साथ हमबिसतर हुई। चूँकि लूत होश में नहीं था इसलिए उसे कुछ भी मालूम न हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","अगले दिन बड़ी बहन ने छोटी बहन से कहा, “पिछली रात मैं अब्बू से हमबिसतर हुई। आओ, आज रात को हम उसे दुबारा मै पिलाएँ। जब वह नशे में धुत हो तो तुम उसके साथ हमबिसतर होकर अपने लिए औलाद पैदा करना ताकि हमारी नसल क़ायम रहे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","चुनाँचे उन्होंने उस रात भी अपने बाप को मै पिलाई। जब वह नशे में था तो छोटी बेटी उठकर उसके साथ हमबिसतर हुई। इस बार भी वह होश में नहीं था, इसलिए उसे कुछ भी मालूम न हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","यों लूत की बेटियाँ अपने बाप से उम्मीद से हुईं। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","बड़ी बेटी के हाँ बेटा पैदा हुआ। उसने उसका नाम मोआब रखा। उससे मोआबी निकले हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","छोटी बेटी के हाँ भी बेटा पैदा हुआ। उसने उसका नाम बिन-अम्मी रखा। उससे अम्मोनी निकले हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","इब्राहीम वहाँ से जुनूब की तरफ़ दश्ते-नजब में चला गया और क़ादिस और शूर के दरमियान जा बसा। कुछ देर के लिए वह जिरार में ठहरा, लेकिन अजनबी की हैसियत से। ");
INSERT INTO urdgvh_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","वहाँ उसने लोगों को बताया, “सारा मेरी बहन है।” इसलिए जिरार के बादशाह अबीमलिक ने किसी को भिजवा दिया कि उसे महल में ले आए। ");
INSERT INTO urdgvh_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","लेकिन रात के वक़्त अल्लाह ख़ाब में अबीमलिक पर ज़ाहिर हुआ और कहा, “मौत तेरे सर पर खड़ी है, क्योंकि जो औरत तू अपने घर ले आया है वह शादीशुदा है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","असल में अबीमलिक अभी तक सारा के क़रीब नहीं गया था। उसने कहा, “मेरे आक़ा, क्या तू एक बेक़ुसूर क़ौम को भी हलाक करेगा? ");
INSERT INTO urdgvh_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","क्या इब्राहीम ने मुझसे नहीं कहा था कि सारा मेरी बहन है? और सारा ने उस की हाँ में हाँ मिलाई। मेरी नीयत अच्छी थी और मैंने ग़लत काम नहीं किया।” ");
INSERT INTO urdgvh_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","अल्लाह ने कहा, “हाँ, मैं जानता हूँ कि इसमें तेरी नीयत अच्छी थी। इसलिए मैंने तुझे मेरा गुनाह करने और उसे छूने से रोक दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","अब उस औरत को उसके शौहर को वापस कर दे, क्योंकि वह नबी है और तेरे लिए दुआ करेगा। फिर तू नहीं मरेगा। लेकिन अगर तू उसे वापस नहीं करेगा तो जान ले कि तेरी और तेरे लोगों की मौत यक़ीनी है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","अबीमलिक ने सुबह-सवेरे उठकर अपने तमाम कारिंदों को यह सब कुछ बताया। यह सुनकर उन पर दहशत छा गई। ");
INSERT INTO urdgvh_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","फिर अबीमलिक ने इब्राहीम को बुलाकर कहा, “आपने हमारे साथ क्या किया है? मैंने आपके साथ क्या ग़लत काम किया कि आपने मुझे और मेरी सलतनत को इतने संगीन जुर्म में फँसा दिया है? जो सुलूक आपने हमारे साथ कर दिखाया है वह किसी भी शख़्स के साथ नहीं करना चाहिए। ");
INSERT INTO urdgvh_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","आपने यह क्यों किया?” ");
INSERT INTO urdgvh_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","इब्राहीम ने जवाब दिया, “मैंने अपने दिल में कहा कि यहाँ के लोग अल्लाह का ख़ौफ़ नहीं रखते होंगे, इसलिए वह मेरी बीवी को हासिल करने के लिए मुझे क़त्ल कर देंगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","हक़ीक़त में वह मेरी बहन भी है। वह मेरे बाप की बेटी है अगरचे उस की और मेरी माँ फ़रक़ हैं। यों मैं उससे शादी कर सका। ");
INSERT INTO urdgvh_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","फिर जब अल्लाह ने होने दिया कि मैं अपने बाप के घराने से निकलकर इधर-उधर फिरूँ तो मैंने अपनी बीवी से कहा, ‘मुझ पर यह मेहरबानी कर कि जहाँ भी हम जाएँ मेरे बारे में कह देना कि वह मेरा भाई है’।” ");
INSERT INTO urdgvh_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","फिर अबीमलिक ने इब्राहीम को भेड़-बकरियाँ, गाय-बैल, ग़ुलाम और लौंडियाँ देकर उस की बीवी सारा को उसे वापस कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","उसने कहा, “मेरा मुल्क आपके लिए खुला है। जहाँ जी चाहे उसमें जा बसें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","सारा से उसने कहा, “मैं आपके भाई को चाँदी के हज़ार सिक्के देता हूँ। इससे आप और आपके लोगों के सामने आपके साथ किए गए नारवा सुलूक का इज़ाला हो और आपको बेक़ुसूर क़रार दिया जाए।” ");
INSERT INTO urdgvh_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","तब इब्राहीम ने अल्लाह से दुआ की और अल्लाह ने अबीमलिक, उस की बीवी और उस की लौंडियों को शफ़ा दी, क्योंकि रब ने अबीमलिक के घराने की तमाम औरतों को सारा के सबब से बाँझ बना दिया था। लेकिन अब उनके हाँ दुबारा बच्चे पैदा होने लगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","तब रब ने सारा के साथ वैसा ही किया जैसा उसने फ़रमाया था। जो वादा उसने सारा के बारे में किया था उसे उसने पूरा किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","वह हामिला हुई और बेटा पैदा हुआ। ऐन उस वक़्त बूढ़े इब्राहीम के हाँ बेटा पैदा हुआ जो अल्लाह ने मुक़र्रर करके उसे बताया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","इब्राहीम ने अपने इस बेटे का नाम इसहाक़ यानी ‘वह हँसता है’ रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","जब इसहाक़ आठ दिन का था तो इब्राहीम ने उसका ख़तना कराया, जिस तरह अल्लाह ने उसे हुक्म दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","जब इसहाक़ पैदा हुआ उस वक़्त इब्राहीम 100 साल का था। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","सारा ने कहा, “अल्लाह ने मुझे हँसाया, और हर कोई जो मेरे बारे में यह सुनेगा हँसेगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","इससे पहले कौन इब्राहीम से यह कहने की जुर्रत कर सकता था कि सारा अपने बच्चों को दूध पिलाएगी? और अब मेरे हाँ बेटा पैदा हुआ है, अगरचे इब्राहीम बूढ़ा हो गया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","इसहाक़ बड़ा होता गया। जब उसका दूध छुड़ाया गया तो इब्राहीम ने उसके लिए बड़ी ज़ियाफ़त की। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","एक दिन सारा ने देखा कि मिसरी लौंडी हाजिरा का बेटा इसमाईल इसहाक़ का मज़ाक़ उड़ा रहा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","उसने इब्राहीम से कहा, “इस लौंडी और उसके बेटे को घर से निकाल दें, क्योंकि वह मेरे बेटे इसहाक़ के साथ मीरास नहीं पाएगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","इब्राहीम को यह बात बहुत बुरी लगी। आख़िर इसमाईल भी उसका बेटा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","लेकिन अल्लाह ने उससे कहा, “जो बात सारा ने अपनी लौंडी और उसके बेटे के बारे में कही है वह तुझे बुरी न लगे। सारा की बात मान ले, क्योंकि तेरी नसल इसहाक़ ही से क़ायम रहेगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","लेकिन मैं इसमाईल से भी एक क़ौम बनाऊँगा, क्योंकि वह तेरा बेटा है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","इब्राहीम सुबह-सवेरे उठा। उसने रोटी और पानी की मशक हाजिरा के कंधों पर रखकर उसे लड़के के साथ घर से निकाल दिया। हाजिरा चलते चलते बैर-सबा के रेगिस्तान में इधर-उधर फिरने लगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","फिर पानी ख़त्म हो गया। हाजिरा लड़के को किसी झाड़ी के नीचे छोड़कर ");
INSERT INTO urdgvh_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","कोई 300 फ़ुट दूर बैठ गई। क्योंकि उसने दिल में कहा, “मैं उसे मरते नहीं देख सकती।” वह वहाँ बैठकर रोने लगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","लेकिन अल्लाह ने बेटे की रोती हुई आवाज़ सुन ली। अल्लाह के फ़रिश्ते ने आसमान पर से पुकारकर हाजिरा से बात की, “हाजिरा, क्या बात है? मत डर, क्योंकि अल्लाह ने लड़के का जो वहाँ पड़ा है रोना सुन लिया है। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","उठ, लड़के को उठाकर उसका हाथ थाम ले, क्योंकि मैं उससे एक बड़ी क़ौम बनाऊँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","फिर अल्लाह ने हाजिरा की आँखें खोल दीं, और उस की नज़र एक कुएँ पर पड़ी। वह वहाँ गई और मशक को पानी से भरकर लड़के को पिलाया। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","अल्लाह लड़के के साथ था। वह जवान हुआ और तीरअंदाज़ बनकर बयाबान में रहने लगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","जब वह फ़ारान के रेगिस्तान में रहता था तो उस की माँ ने उसे एक मिसरी औरत से ब्याह दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","उन दिनों में अबीमलिक और उसके सिपाहसालार फ़ीकुल ने इब्राहीम से कहा, “जो कुछ भी आप करते हैं अल्लाह आपके साथ है। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","अब मुझसे अल्लाह की क़सम खाएँ कि आप मुझे और मेरी आलो-औलाद को धोका नहीं देंगे। मुझ पर और इस मुल्क पर जिसमें आप परदेसी हैं वही मेहरबानी करें जो मैंने आप पर की है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","इब्राहीम ने जवाब दिया, “मैं क़सम खाता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","फिर उसने अबीमलिक से शिकायत करते हुए कहा, “आपके बंदों ने हमारे एक कुएँ पर क़ब्ज़ा कर लिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","अबीमलिक ने कहा, “मुझे नहीं मालूम कि किसने ऐसा किया है। आपने भी मुझे नहीं बताया। आज मैं पहली दफ़ा यह बात सुन रहा हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","तब इब्राहीम ने अबीमलिक को भेड़-बकरियाँ और गाय-बैल दिए, और दोनों ने एक दूसरे के साथ अहद बाँधा। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","फिर इब्राहीम ने भेड़ के सात मादा बच्चों को अलग कर लिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","अबीमलिक ने पूछा, “आपने यह क्यों किया?” ");
INSERT INTO urdgvh_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","इब्राहीम ने जवाब दिया, “भेड़ के इन सात बच्चों को मुझसे ले लें। यह इसके गवाह हों कि मैंने इस कुएँ को खोदा है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","इसलिए उस जगह का नाम बैर-सबा यानी ‘क़सम का कुआँ’ रखा गया, क्योंकि वहाँ उन दोनों मर्दों ने क़सम खाई। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","यों उन्होंने बैर-सबा में एक दूसरे से अहद बाँधा। फिर अबीमलिक और फ़ीकुल फ़िलिस्तियों के मुल्क वापस चले गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","इसके बाद इब्राहीम ने बैर-सबा में झाऊ का दरख़्त लगाया। वहाँ उसने रब का नाम लेकर उस की इबादत की जो अबदी ख़ुदा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","इब्राहीम बहुत अरसे तक फ़िलिस्तियों के मुल्क में आबाद रहा, लेकिन अजनबी की हैसियत से। ");
INSERT INTO urdgvh_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","कुछ अरसे के बाद अल्लाह ने इब्राहीम को आज़माया। उसने उससे कहा, “इब्राहीम!” उसने जवाब दिया, “जी, मैं हाज़िर हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","अल्लाह ने कहा, “अपने इकलौते बेटे इसहाक़ को जिसे तू प्यार करता है साथ लेकर मोरियाह के इलाक़े में चला जा। वहाँ मैं तुझे एक पहाड़ दिखाऊँगा। उस पर अपने बेटे को क़ुरबान कर दे। उसे ज़बह करके क़ुरबानगाह पर जला देना।” ");
INSERT INTO urdgvh_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","सुबह-सवेरे इब्राहीम उठा और अपने गधे पर ज़ीन कसा। उसने अपने साथ दो नौकरों और अपने बेटे इसहाक़ को लिया। फिर वह क़ुरबानी को जलाने के लिए लकड़ी काटकर उस जगह की तरफ़ रवाना हुआ जो अल्लाह ने उसे बताई थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","सफ़र करते करते तीसरे दिन क़ुरबानी की जगह इब्राहीम को दूर से नज़र आई। ");
INSERT INTO urdgvh_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","उसने नौकरों से कहा, “यहाँ गधे के पास ठहरो। मैं लड़के के साथ वहाँ जाकर परस्तिश करूँगा। फिर हम तुम्हारे पास वापस आ जाएंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","इब्राहीम ने क़ुरबानी को जलाने के लिए लकड़ियाँ इसहाक़ के कंधों पर रख दीं और ख़ुद छुरी और आग जलाने के लिए अंगारों का बरतन उठाया। दोनों चल दिए। ");
INSERT INTO urdgvh_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","इसहाक़ बोला, “अब्बू!” इब्राहीम ने कहा, “जी बेटा।” “अब्बू, आग और लकड़ियाँ तो हमारे पास हैं, लेकिन क़ुरबानी के लिए भेड़ या बकरी कहाँ है?” ");
INSERT INTO urdgvh_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","इब्राहीम ने जवाब दिया, “अल्लाह ख़ुद क़ुरबानी के लिए जानवर मुहैया करेगा, बेटा।” वह आगे बढ़ गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","चलते चलते वह उस मक़ाम पर पहुँचे जो अल्लाह ने उस पर ज़ाहिर किया था। इब्राहीम ने वहाँ क़ुरबानगाह बनाई और उस पर लकड़ियाँ तरतीब से रख दीं। फिर उसने इसहाक़ को बाँधकर लकड़ियों पर रख दिया ");
INSERT INTO urdgvh_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","और छुरी पकड़ ली ताकि अपने बेटे को ज़बह करे। ");
INSERT INTO urdgvh_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ऐन उसी वक़्त रब के फ़रिश्ते ने आसमान पर से उसे आवाज़ दी, “इब्राहीम, इब्राहीम!” इब्राहीम ने कहा, “जी, मैं हाज़िर हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","फ़रिश्ते ने कहा, “अपने बेटे पर हाथ न चला, न उसके साथ कुछ कर। अब मैंने जान लिया है कि तू अल्लाह का ख़ौफ़ रखता है, क्योंकि तू अपने इकलौते बेटे को भी मुझे देने के लिए तैयार है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","अचानक इब्राहीम को एक मेंढा नज़र आया जिसके सींग गुंजान झाड़ियों में फँसे हुए थे। इब्राहीम ने उसे ज़बह करके अपने बेटे की जगह क़ुरबानी के तौर पर जला दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","उसने उस मक़ाम का नाम “रब मुहैया करता है” रखा। इसलिए आज तक कहा जाता है, “रब के पहाड़ पर मुहैया किया जाता है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","रब के फ़रिश्ते ने एक बार फिर आसमान पर से पुकारकर उससे बात की। ");
INSERT INTO urdgvh_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“रब का फ़रमान है, मेरी ज़ात की क़सम, चूँकि तूने यह किया और अपने इकलौते बेटे को मुझे पेश करने के लिए तैयार था ");
INSERT INTO urdgvh_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","इसलिए मैं तुझे बरकत दूँगा और तेरी औलाद को आसमान के सितारों और साहिल की रेत की तरह बेशुमार होने दूँगा। तेरी औलाद अपने दुश्मनों के शहरों के दरवाज़ों पर क़ब्ज़ा करेगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","चूँकि तूने मेरी सुनी इसलिए तेरी औलाद से दुनिया की तमाम क़ौमें बरकत पाएँगी।” ");
INSERT INTO urdgvh_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","इसके बाद इब्राहीम अपने नौकरों के पास वापस आया, और वह मिलकर बैर-सबा लौटे। वहाँ इब्राहीम आबाद रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","इन वाक़ियात के बाद इब्राहीम को इत्तला मिली, “आपके भाई नहूर की बीवी मिलकाह के हाँ भी बेटे पैदा हुए हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","उसके पहलौठे ऊज़ के बाद बूज़, क़मुएल (अराम का बाप), ");
INSERT INTO urdgvh_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","कसद, हज़ू, फ़िलदास, इदलाफ़ और बतुएल पैदा हुए हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","मिलकाह और नहूर के हाँ यह आठ बेटे पैदा हुए। (बतुएल रिबक़ा का बाप था)। ");
INSERT INTO urdgvh_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","नहूर की हरम का नाम रूमा था। उसके हाँ भी बेटे पैदा हुए जिनके नाम तिबख़, जाहम, तख़स और माका हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","सारा 127 साल की उम्र में हबरून में इंतक़ाल कर गई। ");
INSERT INTO urdgvh_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","उस ज़माने में हबरून का नाम क़िरियत-अरबा था, और वह मुल्के-कनान में था। इब्राहीम ने उसके पास आकर मातम किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","फिर वह जनाज़े के पास से उठा और हित्तियों से बात की। उसने कहा, ");
INSERT INTO urdgvh_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“मैं आपके दरमियान परदेसी और ग़ैरशहरी की हैसियत से रहता हूँ। मुझे क़ब्र के लिए ज़मीन बेचें ताकि अपनी बीवी को अपने घर से ले जाकर दफ़न कर सकूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","हित्तियों ने जवाब दिया, “हमारे आक़ा, हमारी बात सुनें! आप हमारे दरमियान अल्लाह के रईस हैं। अपनी बीवी को हमारी बेहतरीन क़ब्र में दफ़न करें। हममें से कोई नहीं जो आपसे अपनी क़ब्र का इनकार करेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","इब्राहीम उठा और मुल्क के बाशिंदों यानी हित्तियों के सामने ताज़ीमन झुक गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","उसने कहा, “अगर आप इसके लिए तैयार हैं कि मैं अपनी बीवी को अपने घर से ले जाकर दफ़न करूँतो सुहर के बेटे इफ़रोन से मेरी सिफ़ारिश करें ");
INSERT INTO urdgvh_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","कि वह मुझे मकफ़ीला का ग़ार बेच दे। वह उसका है और उसके खेत के किनारे पर है। मैं उस की पूरी क़ीमत देने के लिए तैयार हूँ ताकि आपके दरमियान रहते हुए मेरे पास क़ब्र भी हो।” ");
INSERT INTO urdgvh_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","इफ़रोन हित्तियों की जमात में मौजूद था। इब्राहीम की दरख़ास्त पर उसने उन तमाम हित्तियों के सामने जो शहर के दरवाज़े पर जमा थे जवाब दिया, ");
INSERT INTO urdgvh_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“नहीं, मेरे आक़ा! मेरी बात सुनें। मैं आपको यह खेत और उसमें मौजूद ग़ार दे देता हूँ। सब जो हाज़िर हैं मेरे गवाह हैं, मैं यह आपको देता हूँ। अपनी बीवी को वहाँ दफ़न कर दें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","इब्राहीम दुबारा मुल्क के बाशिंदों के सामने अदबन झुक गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","उसने सबके सामने इफ़रोन से कहा, “मेहरबानी करके मेरी बात पर ग़ौर करें। मैं खेत की पूरी क़ीमत अदा करूँगा। उसे क़बूल करें ताकि वहाँ अपनी बीवी को दफ़न कर सकूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","इफ़रोन ने जवाब दिया, “मेरे आक़ा, सुनें। इस ज़मीन की क़ीमत सिर्फ़ 400 चाँदी के सिक्के है। आपके और मेरे दरमियान यह क्या है? अपनी बीवी को दफ़न कर दें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","इब्राहीम ने इफ़रोन की मतलूबा क़ीमत मान ली और सबके सामने चाँदी के 400 सिक्के तोलकर इफ़रोन को दे दिए। इसके लिए उसने उस वक़्त के रायज बाट इस्तेमाल किए। ");
INSERT INTO urdgvh_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","चुनाँचे मकफ़ीला में इफ़रोन की ज़मीन इब्राहीम की मिलकियत हो गई। यह ज़मीन ममरे के मशरिक़ में थी। उसमें खेत, खेत का ग़ार और खेत की हुदूद में मौजूद तमाम दरख़्त शामिल थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","हित्तियों की पूरी जमात ने जो शहर के दरवाज़े पर जमा थी ज़मीन के इंतक़ाल की तसदीक़ की। ");
INSERT INTO urdgvh_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","फिर इब्राहीम ने अपनी बीवी सारा को मुल्के-कनान के उस ग़ार में दफ़न किया जो ममरे यानी हबरून के मशरिक़ में वाक़े मकफ़ीला के खेत में था। ");
INSERT INTO urdgvh_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","इस तरीक़े से यह खेत और उसका ग़ार हित्तियों से इब्राहीम के नाम पर मुंतक़िल कर दिया गया ताकि उसके पास क़ब्र हो। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","इब्राहीम अब बहुत बूढ़ा हो गया था। रब ने उसे हर लिहाज़ से बरकत दी थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","एक दिन उसने अपने घर के सबसे बुज़ुर्ग नौकर से जो उस की जायदाद का पूरा इंतज़ाम चलाता था बात की। “क़सम के लिए अपना हाथ मेरी रान के नीचे रखो। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","रब की क़सम खाओ जो आसमानो-ज़मीन का ख़ुदा है कि तुम इन कनानियों में से जिनके दरमियान मैं रहता हूँ मेरे बेटे के लिए बीवी नहीं लाओगे ");
INSERT INTO urdgvh_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","बल्कि मेरे वतन में मेरे रिश्तेदारों के पास जाओगे और उन्हीं में से मेरे बेटे के लिए बीवी लाओगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","उसके नौकर ने कहा, “शायद वह औरत मेरे साथ यहाँ आना न चाहे। क्या मैं इस सूरत में आपके बेटे को उस वतन में वापस ले जाऊँ जिससे आप निकले हैं?” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","इब्राहीम ने कहा, “ख़बरदार! उसे हरगिज़ वापस न ले जाना। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","रब जो आसमान का ख़ुदा है अपना फ़रिश्ता तुम्हारे आगे भेजेगा, इसलिए तुम वहाँ मेरे बेटे के लिए बीवी चुनने में ज़रूर कामयाब होगे। क्योंकि वही मुझे मेरे बाप के घर और मेरे वतन से यहाँ ले आया है, और उसी ने क़सम खाकर मुझसे वादा किया है कि मैं कनान का यह मुल्क तेरी औलाद को दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","अगर वहाँ की औरत यहाँ आना न चाहे तो फिर तुम अपनी क़सम से आज़ाद होगे। लेकिन किसी सूरत में भी मेरे बेटे को वहाँ वापस न ले जाना।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","इब्राहीम के नौकर ने अपना हाथ उस की रान के नीचे रखकर क़सम खाई कि मैं सब कुछ ऐसा ही करूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","फिर वह अपने आक़ा के दस ऊँटों पर क़ीमती तोह्फ़े लादकर मसोपुतामिया की तरफ़ रवाना हुआ। चलते चलते वह नहूर के शहर पहुँच गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","उसने ऊँटों को शहर के बाहर कुएँ के पास बिठाया। शाम का वक़्त था जब औरतें कुएँ के पास आकर पानी भरती थीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","फिर उसने दुआ की, “ऐ रब मेरे आक़ा इब्राहीम के ख़ुदा, मुझे आज कामयाबी बख़्श और मेरे आक़ा इब्राहीम पर मेहरबानी कर। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","अब मैं इस चश्मे पर खड़ा हूँ, और शहर की बेटियाँ पानी भरने के लिए आ रही हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","मैं उनमें से किसी से कहूँगा, ‘ज़रा अपना घड़ा नीचे करके मुझे पानी पिलाएँ।’ अगर वह जवाब दे, ‘पी लें, मैं आपके ऊँटों को भी पानी पिला देती हूँ,’ तो वह वही होगी जिसे तूने अपने ख़ादिम इसहाक़ के लिए चुन रखा है। अगर ऐसा हुआ तो मैं जान लूँगा कि तूने मेरे आक़ा पर मेहरबानी की है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","वह अभी दुआ कर ही रहा था कि रिबक़ा शहर से निकल आई। उसके कंधे पर घड़ा था। वह बतुएल की बेटी थी (बतुएल इब्राहीम के भाई नहूर की बीवी मिलकाह का बेटा था)। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","रिबक़ा निहायत ख़ूबसूरत जवान लड़की थी, और वह कुँवारी भी थी। वह चश्मे तक उतरी, अपना घड़ा भरा और फिर वापस ऊपर आई। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","इब्राहीम का नौकर दौड़कर उससे मिला। उसने कहा, “ज़रा मुझे अपने घड़े से थोड़ा-सा पानी पिलाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","रिबक़ा ने कहा, “जनाब, पी लें।” जल्दी से उसने अपने घड़े को कंधे पर से उतारकर हाथ में पकड़ा ताकि वह पी सके। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","जब वह पीने से फ़ारिग़ हुआ तो रिबक़ा ने कहा, “मैं आपके ऊँटों के लिए भी पानी ले आती हूँ। वह भी पूरे तौर पर अपनी प्यास बुझाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","जल्दी से उसने अपने घड़े का पानी हौज़ में उंडेल दिया और फिर भागकर कुएँ से इतना पानी लाती रही कि तमाम ऊँटों की प्यास बुझ गई। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","इतने में इब्राहीम का आदमी ख़ामोशी से उसे देखता रहा, क्योंकि वह जानना चाहता था कि क्या रब मुझे सफ़र की कामयाबी बख़्शेगा या नहीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ऊँट पानी पीने से फ़ारिग़ हुए तो उसने रिबक़ा को सोने की एक नथ और दो कंगन दिए। नथ का वज़न तक़रीबन 6 ग्राम था और कंगनों का 120 ग्राम। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","उसने पूछा, “आप किसकी बेटी हैं? क्या उसके हाँ इतनी जगह है कि हम वहाँ रात गुज़ार सकें?” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","रिबक़ा ने जवाब दिया, “मेरा बाप बतुएल है। वह नहूर और मिलकाह का बेटा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","हमारे पास भूसा और चारा है। रात गुज़ारने के लिए भी काफ़ी जगह है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","यह सुनकर इब्राहीम के नौकर ने रब को सिजदा किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","उसने कहा, “मेरे आक़ा इब्राहीम के ख़ुदा की तमजीद हो जिसके करम और वफ़ादारी ने मेरे आक़ा को नहीं छोड़ा। रब ने मुझे सीधा मेरे मालिक के रिश्तेदारों तक पहुँचाया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","लड़की भागकर अपनी माँ के घर चली गई। वहाँ उसने सब कुछ बता दिया जो हुआ था। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","जब रिबक़ा के भाई लाबन ने नथ और बहन की कलाइयों में कंगनों को देखा और वह सब कुछ सुना जो इब्राहीम के नौकर ने रिबक़ा को बताया था तो वह फ़ौरन कुएँ की तरफ़ दौड़ा। इब्राहीम का नौकर अब तक ऊँटों समेत वहाँ खड़ा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","लाबन ने कहा, “रब के मुबारक बंदे, मेरे साथ आएँ। आप यहाँ शहर के बाहर क्यों खड़े हैं? मैंने अपने घर में आपके लिए सब कुछ तैयार किया है। आपके ऊँटों के लिए भी काफ़ी जगह है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","वह नौकर को लेकर घर पहुँचा। ऊँटों से सामान उतारा गया, और उनको भूसा और चारा दिया गया। पानी भी लाया गया ताकि इब्राहीम का नौकर और उसके आदमी अपने पाँव धोएँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","लेकिन जब खाना आ गया तो इब्राहीम के नौकर ने कहा, “इससे पहले कि मैं खाना खाऊँ लाज़िम है कि अपना मामला पेश करूँ।” लाबन ने कहा, “बताएँ अपनी बात।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","उसने कहा, “मैं इब्राहीम का नौकर हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","रब ने मेरे आक़ा को बहुत बरकत दी है। वह बहुत अमीर बन गया है। रब ने उसे कसरत से भेड़-बकरियाँ, गाय-बैल, सोना-चाँदी, ग़ुलाम और लौंडियाँ, ऊँट और गधे दिए हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","जब मेरे मालिक की बीवी बूढ़ी हो गई थी तो उसके बेटा पैदा हुआ था। इब्राहीम ने उसे अपनी पूरी मिलकियत दे दी है। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","लेकिन मेरे आक़ा ने मुझसे कहा, ‘क़सम खाओ कि तुम इन कनानियों में से जिनके दरमियान मैं रहता हूँ मेरे बेटे के लिए बीवी नहीं लाओगे ");
INSERT INTO urdgvh_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","बल्कि मेरे बाप के घराने और मेरे रिश्तेदारों के पास जाकर उसके लिए बीवी लाओगे।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","मैंने अपने मालिक से कहा, ‘शायद वह औरत मेरे साथ आना न चाहे।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","उसने कहा, ‘रब जिसके सामने मैं चलता रहा हूँ अपने फ़रिश्ते को तुम्हारे साथ भेजेगा और तुम्हें कामयाबी बख़्शेगा। तुम्हें ज़रूर मेरे रिश्तेदारों और मेरे बाप के घराने से मेरे बेटे के लिए बीवी मिलेगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","लेकिन अगर तुम मेरे रिश्तेदारों के पास जाओ और वह इनकार करें तो फिर तुम अपनी क़सम से आज़ाद होगे।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","आज जब मैं कुएँ के पास आया तो मैंने दुआ की, ‘ऐ रब, मेरे आक़ा के ख़ुदा, अगर तेरी मरज़ी हो तो मुझे इस मिशन में कामयाबी बख़्श जिसके लिए मैं यहाँ आया हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","अब मैं इस कुएँ के पास खड़ा हूँ। जब कोई जवान औरत शहर से निकलकर यहाँ आए तो मैं उससे कहूँगा, “ज़रा मुझे अपने घड़े से थोड़ा-सा पानी पिलाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","अगर वह कहे, “पी लें, मैं आपके ऊँटों के लिए भी पानी ले आऊँगी” तो इसका मतलब यह हो कि तूने उसे मेरे आक़ा के बेटे के लिए चुन लिया है कि उस की बीवी बन जाए।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","मैं अभी दिल में यह दुआ कर रहा था कि रिबक़ा शहर से निकल आई। उसके कंधे पर घड़ा था। वह चश्मे तक उतरी और अपना घड़ा भर लिया। मैंने उससे कहा, ‘ज़रा मुझे पानी पिलाएँ।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","जवाब में उसने जल्दी से अपने घड़े को कंधे पर से उतारकर कहा, ‘पी लें, मैं आपके ऊँटों को भी पानी पिलाती हूँ।’ मैंने पानी पिया, और उसने ऊँटों को भी पानी पिलाया। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","फिर मैंने उससे पूछा, ‘आप किसकी बेटी हैं?’ उसने जवाब दिया, ‘मेरा बाप बतुएल है। वह नहूर और मिलकाह का बेटा है।’ फिर मैंने उस की नाक में नथ और उस की कलाइयों में कंगन पहना दिए। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","तब मैंने रब को सिजदा करके अपने आक़ा इब्राहीम के ख़ुदा की तमजीद की जिसने मुझे सीधा मेरे मालिक की भतीजी तक पहुँचाया ताकि वह इसहाक़ की बीवी बन जाए। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","अब मुझे बताएँ, क्या आप मेरे आक़ा पर अपनी मेहरबानी और वफ़ादारी का इज़हार करना चाहते हैं? अगर ऐसा है तो रिबक़ा की इसहाक़ के साथ शादी क़बूल करें। अगर आप मुत्तफ़िक़ नहीं हैं तो मुझे बताएँ ताकि मैं कोई और क़दम उठा सकूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","लाबन और बतुएल ने जवाब दिया, “यह बात रब की तरफ़ से है, इसलिए हम किसी तरह भी इनकार नहीं कर सकते। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","रिबक़ा आपके सामने है। उसे ले जाएँ। वह आपके मालिक के बेटे की बीवी बन जाए जिस तरह रब ने फ़रमाया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","यह सुनकर इब्राहीम के नौकर ने रब को सिजदा किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","फिर उसने सोने और चाँदी के ज़ेवरात और महँगे मलबूसात अपने सामान में से निकालकर रिबक़ा को दिए। रिबक़ा के भाई और माँ को भी क़ीमती तोह्फ़े मिले। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","इसके बाद उसने अपने हमसफ़रों के साथ शाम का खाना खाया। वह रात को वहीं ठहरे। अगले दिन जब उठे तो नौकर ने कहा, “अब हमें इजाज़त दें ताकि अपने आक़ा के पास लौट जाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","रिबक़ा के भाई और माँ ने कहा, “रिबक़ा कुछ दिन और हमारे हाँ ठहरे। फिर आप जाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","लेकिन उसने उनसे कहा, “अब देर न करें, क्योंकि रब ने मुझे मेरे मिशन में कामयाबी बख़्शी है। मुझे इजाज़त दें ताकि अपने मालिक के पास वापस जाऊँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","उन्होंने कहा, “चलें, हम लड़की को बुलाकर उसी से पूछ लेते हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","उन्होंने रिबक़ा को बुलाकर उससे पूछा, “क्या तू अभी इस आदमी के साथ जाना चाहती है?” उसने कहा, “जी, मैं जाना चाहती हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","चुनाँचे उन्होंने अपनी बहन रिबक़ा, उस की दाया, इब्राहीम के नौकर और उसके हमसफ़रों को रुख़सत कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","पहले उन्होंने रिबक़ा को बरकत देकर कहा, “हमारी बहन, अल्लाह करे कि तू करोड़ों की माँ बने। तेरी औलाद अपने दुश्मनों के शहरों के दरवाज़ों पर क़ब्ज़ा करे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","फिर रिबक़ा और उस की नौकरानियाँ उठकर ऊँटों पर सवार हुईं और इब्राहीम के नौकर के पीछे हो लीं। चुनाँचे नौकर उन्हें साथ लेकर रवाना हो गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","उस वक़्त इसहाक़ मुल्क के जुनूबी हिस्से, दश्ते-नजब में रहता था। वह बैर-लही-रोई से आया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","एक शाम वह निकलकर खुले मैदान में अपनी सोचों में मगन टहल रहा था कि अचानक ऊँट उस की तरफ़ आते हुए नज़र आए। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","जब रिबक़ा ने अपनी नज़र उठाकर इसहाक़ को देखा तो उसने ऊँट से उतरकर ");
INSERT INTO urdgvh_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","नौकर से पूछा, “वह आदमी कौन है जो मैदान में हमसे मिलने आ रहा है?” नौकर ने कहा, “मेरा मालिक है।” यह सुनकर रिबक़ा ने चादर लेकर अपने चेहरे को ढाँप लिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","नौकर ने इसहाक़ को सब कुछ बता दिया जो उसने किया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","फिर इसहाक़ रिबक़ा को अपनी माँ सारा के डेरे में ले गया। उसने उससे शादी की, और वह उस की बीवी बन गई। इसहाक़ के दिल में उसके लिए बहुत मुहब्बत पैदा हुई। यों उसे अपनी माँ की मौत के बाद सुकून मिला। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","इब्राहीम ने एक और शादी की। नई बीवी का नाम क़तूरा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","क़तूरा के छः बेटे पैदा हुए, ज़िमरान, युक़सान, मिदान, मिदियान, इसबाक़ और सूख़। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","युक़सान के दो बेटे थे, सबा और ददान। असूरी, लतूसी और लूमी ददान की औलाद हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","मिदियान के बेटे ऐफ़ा, इफ़र, हनूक, अबीदा और इल्दआ थे। यह सब क़तूरा की औलाद थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","इब्राहीम ने अपनी सारी मिलकियत इसहाक़ को दे दी। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","अपनी मौत से पहले उसने अपनी दूसरी बीवियों के बेटों को तोह्फ़े देकर अपने बेटे से दूर मशरिक़ की तरफ़ भेज दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","इब्राहीम 175 साल की उम्र में फ़ौत हुआ। ग़रज़ वह बहुत उम्ररसीदा और ज़िंदगी से आसूदा होकर इंतक़ाल करके अपने बापदादा से जा मिला। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","उसके बेटों इसहाक़ और इसमाईल ने उसे मकफ़ीला के ग़ार में दफ़न किया जो ममरे के मशरिक़ में है। यह वही ग़ार था जिसे खेत समेत हित्ती आदमी इफ़रोन बिन सुहर से ख़रीदा गया था। इब्राहीम और उस की बीवी सारा दोनों को उसमें दफ़न किया गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","इब्राहीम की वफ़ात के बाद अल्लाह ने इसहाक़ को बरकत दी। उस वक़्त इसहाक़ बैर-लही-रोई के क़रीब आबाद था। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","इब्राहीम का बेटा इसमाईल जो सारा की मिसरी लौंडी हाजिरा के हाँ पैदा हुआ उसका नसबनामा यह है। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","इसमाईल के बेटे बड़े से लेकर छोटे तक यह हैं : नबायोत, क़ीदार, अदबियेल, मिबसाम, ");
INSERT INTO urdgvh_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिशमा, दूमा, मस्सा, ");
INSERT INTO urdgvh_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदद, तैमा, यतूर, नफ़ीस और क़िदमा। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","यह बेटे बारह क़बीलों के बानी बन गए, और जहाँ जहाँ वह आबाद हुए उन जगहों का वही नाम पड़ गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","इसमाईल 137 साल का था जब वह कूच करके अपने बापदादा से जा मिला। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","उस की औलाद उस इलाक़े में आबाद थी जो हवीला और शूर के दरमियान है और जो मिसर के मशरिक़ में असूर की तरफ़ है। यों इसमाईल अपने तमाम भाइयों के सामने ही आबाद हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","यह इब्राहीम के बेटे इसहाक़ का बयान है। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","इसहाक़ 40 साल का था जब उस की रिबक़ा से शादी हुई। रिबक़ा लाबन की बहन और अरामी मर्द बतुएल की बेटी थी (बतुएल मसोपुतामिया का था)। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","रिबक़ा के बच्चे पैदा न हुए। लेकिन इसहाक़ ने अपनी बीवी के लिए दुआ की तो रब ने उस की सुनी, और रिबक़ा उम्मीद से हुई। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","उसके पेट में बच्चे एक दूसरे से ज़ोर-आज़माई करने लगे तो वह रब से पूछने गई, “अगर यह मेरी हालत रहेगी तो फिर मैं यहाँ तक क्यों पहुँच गई हूँ?” ");
INSERT INTO urdgvh_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","रब ने उससे कहा, “तेरे अंदर दो क़ौमें हैं। वह तुझसे निकलकर एक दूसरी से अलग अलग हो जाएँगी। उनमें से एक ज़्यादा ताक़तवर होगी, और बड़ा छोटे की ख़िदमत करेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","पैदाइश का वक़्त आ गया तो जुड़वाँ बेटे पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","पहला बच्चा निकला तो सुर्ख़-सा था, और ऐसा लग रहा था कि वह घने बालों का कोट ही पहने हुए है। इसलिए उसका नाम एसौ यानी ‘बालोंवाला’ रखा गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","इसके बाद दूसरा बच्चा पैदा हुआ। वह एसौ की एड़ी पकड़े हुए निकला, इसलिए उसका नाम याक़ूब यानी ‘एड़ी पकड़नेवाला’ रखा गया। उस वक़्त इसहाक़ 60 साल का था। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","लड़के जवान हुए। एसौ माहिर शिकारी बन गया और खुले मैदान में ख़ुश रहता था। उसके मुक़ाबले में याक़ूब शायस्ता था और डेरे में रहना पसंद करता था। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","इसहाक़ एसौ को प्यार करता था, क्योंकि वह शिकार का गोश्त पसंद करता था। लेकिन रिबक़ा याक़ूब को प्यार करती थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","एक दिन याक़ूब सालन पका रहा था कि एसौ थकाहारा जंगल से आया। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","उसने कहा, “मुझे जल्दी से लाल सालन, हाँ इसी लाल सालन से कुछ खाने को दो। मैं तो बेदम हो रहा हूँ।” (इसी लिए बाद में उसका नाम अदोम यानी सुर्ख़ पड़ गया।) ");
INSERT INTO urdgvh_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","याक़ूब ने कहा, “पहले मुझे पहलौठे का हक़ बेच दो।” ");
INSERT INTO urdgvh_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","एसौ ने कहा, “मैं तो भूक से मर रहा हूँ, पहलौठे का हक़ मेरे किस काम का?” ");
INSERT INTO urdgvh_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","याक़ूब ने कहा, “पहले क़सम खाकर मुझे यह हक़ बेच दो।” एसौ ने क़सम खाकर उसे पहलौठे का हक़ मुंतक़िल कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","तब याक़ूब ने उसे कुछ रोटी और दाल दे दी, और एसौ ने खाया और पिया। फिर वह उठकर चला गया। यों उसने पहलौठे के हक़ को हक़ीर जाना। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","उस मुल्क में दुबारा काल पड़ा, जिस तरह इब्राहीम के दिनों में भी पड़ गया था। इसहाक़ जिरार शहर गया जिस पर फ़िलिस्तियों के बादशाह अबीमलिक की हुकूमत थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","रब ने इसहाक़ पर ज़ाहिर होकर कहा, “मिसर न जा बल्कि उस मुल्क में बस जो मैं तुझे दिखाता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","उस मुल्क में अजनबी रह तो मैं तेरे साथ हूँगा और तुझे बरकत दूँगा। क्योंकि मैं तुझे और तेरी औलाद को यह तमाम इलाक़ा दूँगा और वह वादा पूरा करूँगा जो मैंने क़सम खाकर तेरे बाप इब्राहीम से किया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","मैं तुझे इतनी औलाद दूँगा जितने आसमान पर सितारे हैं। और मैं यह तमाम मुल्क उन्हें दे दूँगा। तेरी औलाद से दुनिया की तमाम क़ौमें बरकत पाएँगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","मैं तुझे इसलिए बरकत दूँगा कि इब्राहीम मेरे ताबे रहा और मेरी हिदायात और अहकाम पर चलता रहा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","चुनाँचे इसहाक़ जिरार में आबाद हो गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","जब वहाँ के मर्दों ने रिबक़ा के बारे में पूछा तो इसहाक़ ने कहा, “यह मेरी बहन है।” वह उन्हें यह बताने से डरता था कि यह मेरी बीवी है, क्योंकि उसने सोचा, “रिबक़ा निहायत ख़ूबसूरत है। अगर उन्हें मालूम हो जाए कि रिबक़ा मेरी बीवी है तो वह उसे हासिल करने की ख़ातिर मुझे क़त्ल कर देंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","काफ़ी वक़्त गुज़र गया। एक दिन फ़िलिस्तियों के बादशाह ने अपनी खिड़की में से झाँककर देखा कि इसहाक़ अपनी बीवी को प्यार कर रहा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","उसने इसहाक़ को बुलाकर कहा, “वह तो आपकी बीवी है! आपने क्यों कहा कि मेरी बहन है?” इसहाक़ ने जवाब दिया, “मैंने सोचा कि अगर मैं बताऊँ कि यह मेरी बीवी है तो लोग मुझे क़त्ल कर देंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","अबीमलिक ने कहा, “आपने हमारे साथ कैसा सुलूक कर दिखाया! कितनी आसानी से मेरे आदमियों में से कोई आपकी बीवी से हमबिसतर हो जाता। इस तरह हम आपके सबब से एक बड़े जुर्म के क़ुसूरवार ठहरते।” ");
INSERT INTO urdgvh_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","फिर अबीमलिक ने तमाम लोगों को हुक्म दिया, “जो भी इस मर्द या उस की बीवी को छेड़े उसे सज़ाए-मौत दी जाएगी।” ");
INSERT INTO urdgvh_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","इसहाक़ ने उस इलाक़े में काश्तकारी की, और उसी साल उसे सौ गुना फल मिला। यों रब ने उसे बरकत दी, ");
INSERT INTO urdgvh_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","और वह अमीर हो गया। उस की दौलत बढ़ती गई, और वह निहायत दौलतमंद हो गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","उसके पास इतनी भेड़-बकरियाँ, गाय-बैल और ग़ुलाम थे कि फ़िलिस्ती उससे हसद करने लगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","अब ऐसा हुआ कि उन्होंने उन तमाम कुओं को मिट्टी से भरकर बंद कर दिया जो उसके बाप के नौकरों ने खोदे थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","आख़िरकार अबीमलिक ने इसहाक़ से कहा, “कहीं और जाकर रहें, क्योंकि आप हमसे ज़्यादा ज़ोरावर हो गए हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","चुनाँचे इसहाक़ ने वहाँ से जाकर जिरार की वादी में अपने डेरे लगाए। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","वहाँ फ़िलिस्तियों ने इब्राहीम की मौत के बाद तमाम कुओं को मिट्टी से भर दिया था। इसहाक़ ने उनको दुबारा खुदवाया। उसने उनके वही नाम रखे जो उसके बाप ने रखे थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","इसहाक़ के नौकरों को वादी में खोदते खोदते ताज़ा पानी मिल गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","लेकिन जिरार के चरवाहे आकर इसहाक़ के चरवाहों से झगड़ने लगे। उन्होंने कहा, “यह हमारा कुआँ है!” इसलिए उसने उस कुएँ का नाम इसक यानी झगड़ा रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","इसहाक़ के नौकरों ने एक और कुआँ खोद लिया। लेकिन उस पर भी झगड़ा हुआ, इसलिए उसने उसका नाम सितना यानी मुख़ालफ़त रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","वहाँ से जाकर उसने एक तीसरा कुआँ खुदवाया। इस दफ़ा कोई झगड़ा न हुआ, इसलिए उसने उसका नाम रहोबोत यानी ‘खुली जगह’ रखा। क्योंकि उसने कहा, “रब ने हमें खुली जगह दी है, और अब हम मुल्क में फलें-फूलेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","वहाँ से वह बैर-सबा चला गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","उसी रात रब उस पर ज़ाहिर हुआ और कहा, “मैं तेरे बाप इब्राहीम का ख़ुदा हूँ। मत डर, क्योंकि मैं तेरे साथ हूँ। मैं तुझे बरकत दूँगा और तुझे अपने ख़ादिम इब्राहीम की ख़ातिर बहुत औलाद दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","वहाँ इसहाक़ ने क़ुरबानगाह बनाई और रब का नाम लेकर इबादत की। वहाँ उसने अपने ख़ैमे लगाए और उसके नौकरों ने कुआँ खोद लिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","एक दिन अबीमलिक, उसका साथी अख़ूज़त और उसका सिपहसालार फ़ीकुल जिरार से उसके पास आए। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","इसहाक़ ने पूछा, “आप क्यों मेरे पास आए हैं? आप तो मुझसे नफ़रत रखते हैं। क्या आपने मुझे अपने दरमियान से ख़ारिज नहीं किया था?” ");
INSERT INTO urdgvh_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","उन्होंने जवाब दिया, “हमने जान लिया है कि रब आपके साथ है। इसलिए हमने कहा कि हमारा आपके साथ अहद होना चाहिए। आइए हम क़सम खाकर एक दूसरे से अहद बाँधें ");
INSERT INTO urdgvh_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","कि आप हमें नुक़सान नहीं पहुँचाएँगे, क्योंकि हमने भी आपको नहीं छेड़ा बल्कि आपसे सिर्फ़ अच्छा सुलूक किया और आपको सलामती के साथ रुख़सत किया है। और अब ज़ाहिर है कि रब ने आपको बरकत दी है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","इसहाक़ ने उनकी ज़ियाफ़त की, और उन्होंने खाया और पिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","फिर सुबह-सवेरे उठकर उन्होंने एक दूसरे के सामने क़सम खाई। इसके बाद इसहाक़ ने उन्हें रुख़सत किया और वह सलामती से रवाना हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","उसी दिन इसहाक़ के नौकर आए और उसे उस कुएँ के बारे में इत्तला दी जो उन्होंने खोदा था। उन्होंने कहा, “हमें पानी मिल गया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","उसने कुएँ का नाम सबा यानी ‘क़सम’ रखा। आज तक साथवाले शहर का नाम बैर-सबा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","जब एसौ 40 साल का था तो उसने दो हित्ती औरतों से शादी की, बैरी की बेटी यहूदित से और ऐलोन की बेटी बासमत से। ");
INSERT INTO urdgvh_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","यह औरतें इसहाक़ और रिबक़ा के लिए बड़े दुख का बाइस बनीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","इसहाक़ बूढ़ा हो गया तो उस की नज़र धुँधला गई। उसने अपने बड़े बेटे को बुलाकर कहा, “बेटा।” एसौ ने जवाब दिया, “जी, मैं हाज़िर हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","इसहाक़ ने कहा, “मैं बूढ़ा हो गया हूँ और ख़ुदा जाने कब मर जाऊँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","इसलिए अपना तीर कमान लेकर जंगल में निकल जा और मेरे लिए किसी जानवर का शिकार कर। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","उसे तैयार करके ऐसा लज़ीज़ खाना पका जो मुझे पसंद है। फिर उसे मेरे पास ले आ। मरने से पहले मैं वह खाना खाकर तुझे बरकत देना चाहता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","रिबक़ा ने इसहाक़ की एसौ के साथ बातचीत सुन ली थी। जब एसौ शिकार करने के लिए चला गया तो उसने याक़ूब से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","“अभी अभी मैंने तुम्हारे अब्बू को एसौ से यह बात करते हुए सुना कि ");
INSERT INTO urdgvh_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘मेरे लिए किसी जानवर का शिकार करके ले आ। उसे तैयार करके मेरे लिए लज़ीज़ खाना पका। मरने से पहले मैं यह खाना खाकर तुझे रब के सामने बरकत देना चाहता हूँ।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","अब सुनो, मेरे बेटे! जो कुछ मैं बताती हूँ वह करो। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","जाकर रेवड़ में से बकरियों के दो अच्छे अच्छे बच्चे चुन लो। फिर मैं वही लज़ीज़ खाना पकाऊँगी जो तुम्हारे अब्बू को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","तुम यह खाना उसके पास ले जाओगे तो वह उसे खाकर मरने से पहले तुम्हें बरकत देगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","लेकिन याक़ूब ने एतराज़ किया, “आप जानती हैं कि एसौ के जिस्म पर घने बाल हैं जबकि मेरे बाल कम हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","कहीं मुझे छूने से मेरे बाप को पता न चल जाए कि मैं उसे फ़रेब दे रहा हूँ। फिर मुझ पर बरकत नहीं बल्कि लानत आएगी।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","उस की माँ ने कहा, “तुम पर आनेवाली लानत मुझ पर आए, बेटा। बस मेरी बात मान लो। जाओ और बकरियों के वह बच्चे ले आओ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","चुनाँचे वह गया और उन्हें अपनी माँ के पास ले आया। रिबक़ा ने ऐसा लज़ीज़ खाना पकाया जो याक़ूब के बाप को पसंद था। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","एसौ के ख़ास मौक़ों के लिए अच्छे लिबास रिबक़ा के पास घर में थे। उसने उनमें से बेहतरीन लिबास चुनकर अपने छोटे बेटे को पहना दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","साथ साथ उसने बकरियों की खालें उसके हाथों और गरदन पर जहाँ बाल न थे लपेट दीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","फिर उसने अपने बेटे याक़ूब को रोटी और वह लज़ीज़ खाना दिया जो उसने पकाया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","याक़ूब ने अपने बाप के पास जाकर कहा, “अब्बू जी।” इसहाक़ ने कहा, “जी, बेटा। तू कौन है?” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","उसने कहा, “मैं आपका पहलौठा एसौ हूँ। मैंने वह किया है जो आपने मुझे कहा था। अब ज़रा उठें और बैठकर मेरे शिकार का खाना खाएँ ताकि आप बाद में मुझे बरकत दें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","इसहाक़ ने पूछा, “बेटा, तुझे यह शिकार इतनी जल्दी किस तरह मिल गया?” उसने जवाब दिया, “रब आपके ख़ुदा ने उसे मेरे सामने से गुज़रने दिया।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","इसहाक़ ने कहा, “बेटा, मेरे क़रीब आ ताकि मैं तुझे छू लूँ कि तू वाक़ई मेरा बेटा एसौ है कि नहीं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","याक़ूब अपने बाप के नज़दीक आया। इसहाक़ ने उसे छूकर कहा, “तेरी आवाज़ तो याक़ूब की है लेकिन तेरे हाथ एसौ के हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","यों उसने फ़रेब खाया। चूँकि याक़ूब के हाथ एसौ के हाथ की मानिंद थे इसलिए उसने उसे बरकत दी। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","तो भी उसने दुबारा पूछा, “क्या तू वाक़ई मेरा बेटा एसौ है?” याक़ूब ने जवाब दिया, “जी, मैं वही हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","आख़िरकार इसहाक़ ने कहा, “शिकार का खाना मेरे पास ले आ, बेटा। उसे खाने के बाद मैं तुझे बरकत दूँगा।” याक़ूब खाना और मै ले आया। इसहाक़ ने खाया और पिया, ");
INSERT INTO urdgvh_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","फिर कहा, “बेटा, मेरे पास आ और मुझे बोसा दे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","याक़ूब ने पास आकर उसे बोसा दिया। इसहाक़ ने उसके लिबास को सूँघकर उसे बरकत दी। उसने कहा, “मेरे बेटे की ख़ुशबू उस खुले मैदान की ख़ुशबू की मानिंद है जिसे रब ने बरकत दी है। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","अल्लाह तुझे आसमान की ओस और ज़मीन की ज़रख़ेज़ी दे। वह तुझे कसरत का अनाज और अंगूर का रस दे। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","क़ौमें तेरी ख़िदमत करें, और उम्मतें तेरे सामने झुक जाएँ। अपने भाइयों का हुक्मरान बन, और तेरी माँ की औलाद तेरे सामने घुटने टेके। जो तुझ पर लानत करे वह ख़ुद लानती हो और जो तुझे बरकत दे वह ख़ुद बरकत पाए।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","इसहाक़ की बरकत के बाद याक़ूब अभी रुख़सत ही हुआ था कि उसका भाई एसौ शिकार करके वापस आया। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","वह भी लज़ीज़ खाना पकाकर उसे अपने बाप के पास ले आया। उसने कहा, “अब्बू जी, उठें और मेरे शिकार का खाना खाएँ ताकि आप मुझे बरकत दें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","इसहाक़ ने पूछा, “तू कौन है?” उसने जवाब दिया, “मैं आपका बड़ा बेटा एसौ हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","इसहाक़ घबराकर शिद्दत से काँपने लगा। उसने पूछा, “फिर वह कौन था जो किसी जानवर का शिकार करके मेरे पास ले आया? तेरे आने से ज़रा पहले मैंने उस शिकार का खाना खाकर उस शख़्स को बरकत दी। अब वह बरकत उसी पर रहेगी।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","यह सुनकर एसौ ज़ोरदार और तलख़ चीख़ें मारने लगा। “अब्बू, मुझे भी बरकत दें,” उसने कहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","लेकिन इसहाक़ ने जवाब दिया, “तेरे भाई ने आकर मुझे फ़रेब दिया। उसने तेरी बरकत तुझसे छीन ली है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","एसौ ने कहा, “उसका नाम याक़ूब ठीक ही रखा गया है, क्योंकि अब उसने मुझे दूसरी बार धोका दिया है। पहले उसने पहलौठे का हक़ मुझसे छीन लिया और अब मेरी बरकत भी ज़बरदस्ती ले ली। क्या आपने मेरे लिए कोई बरकत महफ़ूज़ नहीं रखी?” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","लेकिन इसहाक़ ने कहा, “मैंने उसे तेरा हुक्मरान और उसके तमाम भाइयों को उसके ख़ादिम बना दिया है। मैंने उसे अनाज और अंगूर का रस मुहैया किया है। अब मुझे बता बेटा, क्या कुछ रह गया है जो मैं तुझे दूँ?” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","लेकिन एसौ ख़ामोश न हुआ बल्कि कहा, “अब्बू, क्या आपके पास वाक़ई सिर्फ़ यही बरकत थी? अब्बू, मुझे भी बरकत दें।” वह ज़ारो-क़तार रोने लगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","फिर इसहाक़ ने कहा, “तू ज़मीन की ज़रख़ेज़ी और आसमान की ओस से महरूम रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","तू सिर्फ़ अपनी तलवार के सहारे ज़िंदा रहेगा और अपने भाई की ख़िदमत करेगा। लेकिन एक दिन तू बेचैन होकर उसका जुआ अपनी गरदन पर से उतार फेंकेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","बाप की बरकत के सबब से एसौ याक़ूब का दुश्मन बन गया। उसने दिल में कहा, “वह दिन क़रीब आ गए हैं कि अब्बू इंतक़ाल कर जाएंगे और हम उनका मातम करेंगे। फिर मैं अपने भाई को मार डालूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","रिबक़ा को अपने बड़े बेटे एसौ का यह इरादा मालूम हुआ। उसने याक़ूब को बुलाकर कहा, “तुम्हारा भाई बदला लेना चाहता है। वह तुम्हें क़त्ल करने का इरादा रखता है। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","बेटा, अब मेरी सुनो, यहाँ से हिजरत कर जाओ। हारान शहर में मेरे भाई लाबन के पास चले जाओ। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","वहाँ कुछ दिन ठहरे रहना जब तक तुम्हारे भाई का ग़ुस्सा ठंडा न हो जाए। ");
INSERT INTO urdgvh_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","जब उसका ग़ुस्सा ठंडा हो जाएगा और वह तुम्हारे उसके साथ किए गए सुलूक को भूल जाएगा, तब मैं इत्तला दूँगी कि तुम वहाँ से वापस आ सकते हो। मैं क्यों एक ही दिन में तुम दोनों से महरूम हो जाऊँ?” ");
INSERT INTO urdgvh_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","फिर रिबक़ा ने इसहाक़ से बात की, “मैं एसौ की बीवियों के सबब से अपनी ज़िंदगी से तंग हूँ। अगर याक़ूब भी इस मुल्क की औरतों में से किसी से शादी करे तो बेहतर है कि मैं पहले ही मर जाऊँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","इसहाक़ ने याक़ूब को बुलाकर उसे बरकत दी और कहा, “लाज़िम है कि तू किसी कनानी औरत से शादी न करे। ");
INSERT INTO urdgvh_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","अब सीधे मसोपुतामिया में अपने नाना बतुएल के घर जा और वहाँ अपने मामूँ लाबन की लड़कियों में से किसी एक से शादी कर। ");
INSERT INTO urdgvh_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","अल्लाह क़ादिरे-मुतलक़ तुझे बरकत देकर फलने फूलने दे और तुझे इतनी औलाद दे कि तू बहुत सारी क़ौमों का बाप बने। ");
INSERT INTO urdgvh_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","वह तुझे और तेरी औलाद को इब्राहीम की बरकत दे जिसे उसने यह मुल्क दिया जिसमें तू मेहमान के तौर पर रहता है। यह मुल्क तुम्हारे क़ब्ज़े में आए।” ");
INSERT INTO urdgvh_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","यों इसहाक़ ने याक़ूब को मसोपुतामिया में लाबन के घर भेजा। लाबन अरामी मर्द बतुएल का बेटा और रिबक़ा का भाई था। ");
INSERT INTO urdgvh_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","एसौ को पता चला कि इसहाक़ ने याक़ूब को बरकत देकर मसोपुतामिया भेज दिया है ताकि वहाँ शादी करे। उसे यह भी मालूम हुआ कि इसहाक़ ने उसे कनानी औरत से शादी करने से मना किया है ");
INSERT INTO urdgvh_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","और कि याक़ूब अपने माँ-बाप की सुनकर मसोपुतामिया चला गया है। ");
INSERT INTO urdgvh_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","एसौ समझ गया कि कनानी औरतें मेरे बाप को मंज़ूर नहीं हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","इसलिए वह इब्राहीम के बेटे इसमाईल के पास गया और उस की बेटी महलत से शादी की। वह नबायोत की बहन थी। यों उस की बीवियों में इज़ाफ़ा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","याक़ूब बैर-सबा से हारान की तरफ़ रवाना हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","जब सूरज ग़ुरूब हुआ तो वह रात गुज़ारने के लिए रुक गया और वहाँ के पत्थरों में से एक को लेकर उसे अपने सिरहाने रखा और सो गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","जब वह सो रहा था तो ख़ाब में एक सीढ़ी देखी जो ज़मीन से आसमान तक पहुँचती थी। फ़रिश्ते उस पर चढ़ते और उतरते नज़र आते थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","रब उसके ऊपर खड़ा था। उसने कहा, “मैं रब इब्राहीम और इसहाक़ का ख़ुदा हूँ। मैं तुझे और तेरी औलाद को यह ज़मीन दूँगा जिस पर तू लेटा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","तेरी औलाद ज़मीन पर ख़ाक की तरह बेशुमार होगी, और तू चारों तरफ़ फैल जाएगा। दुनिया की तमाम क़ौमें तेरे और तेरी औलाद के वसीले से बरकत पाएँगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","मैं तेरे साथ हूँगा, तुझे महफ़ूज़ रखूँगा और आख़िरकार तुझे इस मुल्क में वापस लाऊँगा। मुमकिन ही नहीं कि मैं तेरे साथ अपना वादा पूरा करने से पहले तुझे छोड़ दूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","तब याक़ूब जाग उठा। उसने कहा, “यक़ीनन रब यहाँ हाज़िर है, और मुझे मालूम नहीं था।” ");
INSERT INTO urdgvh_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","वह डर गया और कहा, “यह कितना ख़ौफ़नाक मक़ाम है। यह तो अल्लाह ही का घर और आसमान का दरवाज़ा है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","याक़ूब सुबह-सवेरे उठा। उसने वह पत्थर लिया जो उसने अपने सिरहाने रखा था और उसे सतून की तरह खड़ा किया। फिर उसने उस पर ज़ैतून का तेल उंडेल दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","उसने मक़ाम का नाम बैतेल यानी ‘अल्लाह का घर’ रखा (पहले साथवाले शहर का नाम लूज़ था)। ");
INSERT INTO urdgvh_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","उसने क़सम खाकर कहा, “अगर रब मेरे साथ हो, सफ़र पर मेरी हिफ़ाज़त करे, मुझे खाना और कपड़ा मुहैया करे ");
INSERT INTO urdgvh_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","और मैं सलामती से अपने बाप के घर वापस पहुँचूँ तो फिर वह मेरा ख़ुदा होगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","जहाँ यह पत्थर सतून के तौर पर खड़ा है वहाँ अल्लाह का घर होगा, और जो भी तू मुझे देगा उसका दसवाँ हिस्सा तुझे दिया करूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","याक़ूब ने अपना सफ़र जारी रखा और चलते चलते मशरिक़ी क़ौमों के मुल्क में पहुँच गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","वहाँ उसने खेत में कुआँ देखा जिसके इर्दगिर्द भेड़-बकरियों के तीन रेवड़ जमा थे। रेवड़ों को कुएँ का पानी पिलाया जाना था, लेकिन उसके मुँह पर बड़ा पत्थर पड़ा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","वहाँ पानी पिलाने का यह तरीक़ा था कि पहले चरवाहे तमाम रेवड़ों का इंतज़ार करते और फिर पत्थर को लुढ़काकर मुँह से हटा देते थे। पानी पिलाने के बाद वह पत्थर को दुबारा मुँह पर रख देते थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","याक़ूब ने चरवाहों से पूछा, “मेरे भाइयो, आप कहाँ के हैं?” उन्होंने जवाब दिया, “हारान के।” ");
INSERT INTO urdgvh_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","उसने पूछा, “क्या आप नहूर के पोते लाबन को जानते हैं?” उन्होंने कहा, “जी हाँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","उसने पूछा, “क्या वह ख़ैरियत से है?” उन्होंने कहा, “जी, वह ख़ैरियत से है। देखो, उधर उस की बेटी राख़िल रेवड़ लेकर आ रही है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","याक़ूब ने कहा, “अभी तो शाम तक बहुत वक़्त बाक़ी है। रेवड़ों को जमा करने का वक़्त तो नहीं है। आप क्यों उन्हें पानी पिलाकर दुबारा चरने नहीं देते?” ");
INSERT INTO urdgvh_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","उन्होंने जवाब दिया, “पहले ज़रूरी है कि तमाम रेवड़ यहाँ पहुँचें। तब ही पत्थर को लुढ़काकर एक तरफ़ हटाया जाएगा और हम रेवड़ों को पानी पिलाएँगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","याक़ूब अभी उनसे बात कर ही रहा था कि राख़िल अपने बाप का रेवड़ लेकर आ पहुँची, क्योंकि भेड़-बकरियों को चराना उसका काम था। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","जब याक़ूब ने राख़िल को मामूँ लाबन के रेवड़ के साथ आते देखा तो उसने कुएँ के पास जाकर पत्थर को लुढ़काकर मुँह से हटा दिया और भेड़-बकरियों को पानी पिलाया। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","फिर उसने उसे बोसा दिया और ख़ूब रोने लगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","उसने कहा, “मैं आपके अब्बू की बहन रिबक़ा का बेटा हूँ।” यह सुनकर राख़िल ने भागकर अपने अब्बू को इत्तला दी। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","जब लाबन ने सुना कि मेरा भानजा याक़ूब आया है तो वह दौड़कर उससे मिलने गया और उसे गले लगाकर अपने घर ले आया। याक़ूब ने उसे सब कुछ बता दिया जो हुआ था। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","लाबन ने कहा, “आप वाक़ई मेरे रिश्तेदार हैं।” याक़ूब ने वहाँ एक पूरा महीना गुज़ारा। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","फिर लाबन याक़ूब से कहने लगा, “बेशक आप मेरे रिश्तेदार हैं, लेकिन आपको मेरे लिए काम करने के बदले में कुछ मिलना चाहिए। मैं आपको कितने पैसे दूँ?” ");
INSERT INTO urdgvh_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबन की दो बेटियाँ थीं। बड़ी का नाम लियाह था और छोटी का राख़िल। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लियाह की आँखें चुंधी थीं जबकि राख़िल हर तरह से ख़ूबसूरत थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","याक़ूब को राख़िल से मुहब्बत थी, इसलिए उसने कहा, “अगर मुझे आपकी छोटी बेटी राख़िल मिल जाए तो आपके लिए सात साल काम करूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","लाबन ने कहा, “किसी और आदमी की निसबत मुझे यह ज़्यादा पसंद है कि आप ही से उस की शादी कराऊँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","पस याक़ूब ने राख़िल को पाने के लिए सात साल तक काम किया। लेकिन उसे ऐसा लगा जैसा दो एक दिन ही गुज़रे हों क्योंकि वह राख़िल को शिद्दत से प्यार करता था। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","इसके बाद उसने लाबन से कहा, “मुद्दत पूरी हो गई है। अब मुझे अपनी बेटी से शादी करने दें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","लाबन ने उस मक़ाम के तमाम लोगों को दावत देकर शादी की ज़ियाफ़त की। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","लेकिन उस रात वह राख़िल की बजाए लियाह को याक़ूब के पास ले आया, और याक़ूब उसी से हमबिसतर हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(लाबन ने लियाह को अपनी लौंडी ज़िलफ़ा दे दी थी ताकि वह उस की ख़िदमत करे।) ");
INSERT INTO urdgvh_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","जब सुबह हुई तो याक़ूब ने देखा कि लियाह ही मेरे पास है। उसने लाबन के पास जाकर कहा, “यह आपने मेरे साथ क्या किया है? क्या मैंने राख़िल के लिए काम नहीं किया? आपने मुझे धोका क्यों दिया?” ");
INSERT INTO urdgvh_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","लाबन ने जवाब दिया, “यहाँ दस्तूर नहीं है कि छोटी बेटी की शादी बड़ी से पहले कर दी जाए। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","एक हफ़ते के बाद शादी की रुसूमात पूरी हो जाएँगी। उस वक़्त तक सब्र करें। फिर मैं आपको राख़िल भी दे दूँगा। शर्त यह है कि आप मज़ीद सात साल मेरे लिए काम करें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","याक़ूब मान गया। चुनाँचे जब एक हफ़ते के बाद शादी की रुसूमात पूरी हुईं तो लाबन ने अपनी बेटी राख़िल की शादी भी उसके साथ कर दी। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(लाबन ने राख़िल को अपनी लौंडी बिलहाह दे दी ताकि वह उस की ख़िदमत करे।) ");
INSERT INTO urdgvh_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","याक़ूब राख़िल से भी हमबिसतर हुआ। वह लियाह की निसबत उसे ज़्यादा प्यार करता था। फिर उसने राख़िल के एवज़ सात साल और लाबन की ख़िदमत की। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","जब रब ने देखा कि लियाह से नफ़रत की जाती है तो उसने उसे औलाद दी जबकि राख़िल के हाँ बच्चे पैदा न हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","लियाह हामिला हुई और उसके बेटा पैदा हुआ। उसने कहा, “रब ने मेरी मुसीबत देखी है और अब मेरा शौहर मुझे प्यार करेगा।” उसने उसका नाम रूबिन यानी ‘देखो एक बेटा’ रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","वह दुबारा हामिला हुई। एक और बेटा पैदा हुआ। उसने कहा, “रब ने सुना कि मुझसे नफ़रत की जाती है, इसलिए उसने मुझे यह भी दिया है।” उसने उसका नाम शमौन यानी ‘रब ने सुना है’ रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","वह एक और दफ़ा हामिला हुई। तीसरा बेटा पैदा हुआ। उसने कहा, “अब आख़िरकार शौहर के साथ मेरा बंधन मज़बूत हो जाएगा, क्योंकि मैंने उसके लिए तीन बेटों को जन्म दिया है।” उसने उसका नाम लावी यानी बंधन रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","वह एक बार फिर हामिला हुई। चौथा बेटा पैदा हुआ। उसने कहा, “इस दफ़ा मैं रब की तमजीद करूँगी।” उसने उसका नाम यहूदाह यानी तमजीद रखा। इसके बाद उससे और बच्चे पैदा न हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","लेकिन राख़िल बेऔलाद ही रही, इसलिए वह अपनी बहन से हसद करने लगी। उसने याक़ूब से कहा, “मुझे भी औलाद दें वरना मैं मर जाऊँगी।” ");
INSERT INTO urdgvh_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","याक़ूब को ग़ुस्सा आया। उसने कहा, “क्या मैं अल्लाह हूँ जिसने तुझे औलाद से महरूम रखा है?” ");
INSERT INTO urdgvh_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","राख़िल ने कहा, “यहाँ मेरी लौंडी बिलहाह है। उसके साथ हमबिसतर हों ताकि वह मेरे लिए बच्चे को जन्म दे और मैं उस की मारिफ़त माँ बन जाऊँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","यों उसने अपने शौहर को बिलहाह दी, और वह उससे हमबिसतर हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","बिलहाह हामिला हुई और बेटा पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","राख़िल ने कहा, “अल्लाह ने मेरे हक़ में फ़ैसला दिया है। उसने मेरी दुआ सुनकर मुझे बेटा दे दिया है।” उसने उसका नाम दान यानी ‘किसी के हक़ में फ़ैसला करनेवाला’ रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","बिलहाह दुबारा हामिला हुई और एक और बेटा पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","राख़िल ने कहा, “मैंने अपनी बहन से सख़्त कुश्ती लड़ी है, लेकिन जीत गई हूँ।” उसने उसका नाम नफ़ताली यानी ‘कुश्ती में मुझसे जीता गया’ रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","जब लियाह ने देखा कि मेरे और बच्चे पैदा नहीं हो रहे तो उसने याक़ूब को अपनी लौंडी ज़िलफ़ा दे दी ताकि वह भी उस की बीवी हो। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ज़िलफ़ा के भी एक बेटा पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","लियाह ने कहा, “मैं कितनी ख़ुशक़िसमत हूँ!” चुनाँचे उसने उसका नाम जद यानी ख़ुशक़िसमती रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","फिर ज़िलफ़ा के दूसरा बेटा पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","लियाह ने कहा, “मैं कितनी मुबारक हूँ। अब ख़वातीन मुझे मुबारक कहेंगी।” उसने उसका नाम आशर यानी मुबारक रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","एक दिन अनाज की फ़सल की कटाई हो रही थी कि रूबिन बाहर निकलकर खेतों में चला गया। वहाँ उसे मर्दुमगयाह मिल गए। वह उन्हें अपनी माँ लियाह के पास ले आया। यह देखकर राख़िल ने लियाह से कहा, “मुझे ज़रा अपने बेटे के मर्दुमगयाह में से कुछ दे दो।” ");
INSERT INTO urdgvh_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","लियाह ने जवाब दिया, “क्या यही काफ़ी नहीं कि तुमने मेरे शौहर को मुझसे छीन लिया है? अब मेरे बेटे के मर्दुमगयाह को भी छीनना चाहती हो।” राख़िल ने कहा, “अगर तुम मुझे अपने बेटे के मर्दुमगयाह में से दो तो आज रात याक़ूब के साथ सो सकती हो।” ");
INSERT INTO urdgvh_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","शाम को याक़ूब खेतों से वापस आ रहा था कि लियाह आगे से उससे मिलने को गई और कहा, “आज रात आपको मेरे साथ सोना है, क्योंकि मैंने अपने बेटे के मर्दुमगयाह के एवज़ आपको उजरत पर लिया है।” चुनाँचे याक़ूब ने लियाह के पास रात गुज़ारी। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","उस वक़्त अल्लाह ने लियाह की दुआ सुनी और वह हामिला हुई। उसके पाँचवाँ बेटा पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","लियाह ने कहा, “अल्लाह ने मुझे इसका अज्र दिया है कि मैंने अपने शौहर को अपनी लौंडी दी।” उसने उसका नाम इशकार यानी अज्र रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","इसके बाद वह एक और दफ़ा हामिला हुई। उसके छटा बेटा पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","उसने कहा, “अल्लाह ने मुझे एक अच्छा-ख़ासा तोह्फ़ा दिया है। अब मेरा ख़ाविंद मेरे साथ रहेगा, क्योंकि मुझसे उसके छः बेटे पैदा हुए हैं।” उसने उसका नाम ज़बूलून यानी रिहाइश रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","इसके बाद बेटी पैदा हुई। उसने उसका नाम दीना रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","फिर अल्लाह ने राख़िल को भी याद किया। उसने उस की दुआ सुनकर उसे औलाद बख़्शी। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","वह हामिला हुई और एक बेटा पैदा हुआ। उसने कहा, “मुझे बेटा अता करने से अल्लाह ने मेरी इज़्ज़त बहाल कर दी है। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","रब मुझे एक और बेटा दे।” उसने उसका नाम यूसुफ़ यानी ‘वह और दे’ रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","यूसुफ़ की पैदाइश के बाद याक़ूब ने लाबन से कहा, “अब मुझे इजाज़त दें कि मैं अपने वतन और घर को वापस जाऊँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","मुझे मेरे बाल-बच्चे दें जिनके एवज़ मैंने आपकी ख़िदमत की है। फिर मैं चला जाऊँगा। आप तो ख़ुद जानते हैं कि मैंने कितनी मेहनत के साथ आपके लिए काम किया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","लेकिन लाबन ने कहा, “मुझ पर मेहरबानी करें और यहीं रहें। मुझे ग़ैबदानी से पता चला है कि रब ने मुझे आपके सबब से बरकत दी है। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","अपनी उजरत ख़ुद मुक़र्रर करें तो मैं वही दिया करूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","याक़ूब ने कहा, “आप जानते हैं कि मैंने किस तरह आपके लिए काम किया, कि मेरे वसीले से आपके मवेशी कितने बढ़ गए हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","जो थोड़ा-बहुत मेरे आने से पहले आपके पास था वह अब बहुत ज़्यादा बढ़ गया है। रब ने मेरे काम से आपको बहुत बरकत दी है। अब वह वक़्त आ गया है कि मैं अपने घर के लिए कुछ करूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","लाबन ने कहा, “मैं आपको क्या दूँ?” याक़ूब ने कहा, “मुझे कुछ न दें। मैं इस शर्त पर आपकी भेड़-बकरियों की देख-भाल जारी रखूँगा कि ");
INSERT INTO urdgvh_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","आज मैं आपके रेवड़ में से गुज़रकर उन तमाम भेड़ों को अलग कर लूँगा जिनके जिस्म पर छोटे या बड़े धब्बे हों या जो सफ़ेद न हों। इसी तरह मैं उन तमाम बकरियों को भी अलग कर लूँगा जिनके जिस्म पर छोटे या बड़े धब्बे हों। यही मेरी उजरत होगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","आइंदा जिन बकरियों के जिस्म पर छोटे या बड़े धब्बे होंगे या जिन भेड़ों का रंग सफ़ेद नहीं होगा वह मेरा अज्र होंगी। जब कभी आप उनका मुआयना करेंगे तो आप मालूम कर सकेंगे कि मैं दियानतदार रहा हूँ। क्योंकि मेरे जानवरों के रंग से ही ज़ाहिर होगा कि मैंने आपका कुछ चुराया नहीं है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","लाबन ने कहा, “ठीक है। ऐसा ही हो जैसा आपने कहा है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","उसी दिन लाबन ने उन बकरों को अलग कर लिया जिनके जिस्म पर धारियाँ या धब्बे थे और उन तमाम बकरियों को जिनके जिस्म पर छोटे या बड़े धब्बे थे। जिसके भी जिस्म पर सफ़ेद निशान था उसे उसने अलग कर लिया। इसी तरह उसने उन तमाम भेड़ों को भी अलग कर लिया जो पूरे तौर पर सफ़ेद न थे। फिर लाबन ने उन्हें अपने बेटों के सुपुर्द कर दिया ");
INSERT INTO urdgvh_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","जो उनके साथ याक़ूब से इतना दूर चले गए कि उनके दरमियान तीन दिन का फ़ासला था। तब याक़ूब लाबन की बाक़ी भेड़-बकरियों की देख-भाल करता गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","याक़ूब ने सफ़ेदा, बादाम और चनार की हरी हरी शाख़ें लेकर उनसे कुछ छिलका यों उतार दिया कि उस पर सफ़ेद धारियाँ नज़र आईं। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","उसने उन्हें भेड़-बकरियों के सामने उन हौज़ों में गाड़ दिया जहाँ वह पानी पीते थे, क्योंकि वहाँ यह जानवर मस्त होकर मिलाप करते थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","जब वह इन शाख़ों के सामने मिलाप करते तो जो बच्चे पैदा होते उनके जिस्म पर छोटे और बड़े धब्बे और धारियाँ होती थीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","फिर याक़ूब ने भेड़ के बच्चों को अलग करके अपने रेवड़ों को लाबन के उन जानवरों के सामने चरने दिया जिनके जिस्म पर धारियाँ थीं और जो सफ़ेद न थे। यों उसने अपने ज़ाती रेवड़ों को अलग कर लिया और उन्हें लाबन के रेवड़ के साथ चरने न दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","लेकिन उसने यह शाख़ें सिर्फ़ उस वक़्त हौज़ों में खड़ी कीं जब ताक़तवर जानवर मस्त होकर मिलाप करते थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","कमज़ोर जानवरों के साथ उसने ऐसा न किया। इसी तरह लाबन को कमज़ोर जानवर और याक़ूब को ताक़तवर जानवर मिल गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","यों याक़ूब बहुत अमीर बन गया। उसके पास बहुत-से रेवड़, ग़ुलाम और लौंडियाँ, ऊँट और गधे थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","एक दिन याक़ूब को पता चला कि लाबन के बेटे मेरे बारे में कह रहे हैं, “याक़ूब ने हमारे अब्बू से सब कुछ छीन लिया है। उसने यह तमाम दौलत हमारे बाप की मिलकियत से हासिल की है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","याक़ूब ने यह भी देखा कि लाबन का मेरे साथ रवैया पहले की निसबत बिगड़ गया है। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","फिर रब ने उससे कहा, “अपने बाप के मुल्क और अपने रिश्तेदारों के पास वापस चला जा। मैं तेरे साथ हूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","उस वक़्त याक़ूब खुले मैदान में अपने रेवड़ों के पास था। उसने वहाँ से राख़िल और लियाह को बुलाकर ");
INSERT INTO urdgvh_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","उनसे कहा, “मैंने देख लिया है कि आपके बाप का मेरे साथ रवैया पहले की निसबत बिगड़ गया है। लेकिन मेरे बाप का ख़ुदा मेरे साथ रहा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","आप दोनों जानती हैं कि मैंने आपके अब्बू के लिए कितनी जाँफ़िशानी से काम किया है। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","लेकिन वह मुझे फ़रेब देता रहा और मेरी उजरत दस बार बदली। ताहम अल्लाह ने उसे मुझे नुक़सान पहुँचाने न दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","जब मामूँ लाबन कहते थे, ‘जिन जानवरों के जिस्म पर धब्बे हों वही आपको उजरत के तौर पर मिलेंगे’ तो तमाम भेड़-बकरियों के ऐसे बच्चे पैदा हुए जिनके जिस्मों पर धब्बे ही थे। जब उन्होंने कहा, ‘जिन जानवरों के जिस्म पर धारियाँ होंगी वही आपको उजरत के तौर पर मिलेंगे’ तो तमाम भेड़-बकरियों के ऐसे बच्चे पैदा हुए जिनके जिस्मों पर धारियाँ ही थीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","यों अल्लाह ने आपके अब्बू के मवेशी छीनकर मुझे दे दिए हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","अब ऐसा हुआ कि हैवानों की मस्ती के मौसम में मैंने एक ख़ाब देखा। उसमें जो मेंढे और बकरे भेड़-बकरियों से मिलाप कर रहे थे उनके जिस्म पर बड़े और छोटे धब्बे और धारियाँ थीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","उस ख़ाब में अल्लाह के फ़रिश्ते ने मुझसे बात की, ‘याक़ूब!’ मैंने कहा, ‘जी, मैं हाज़िर हूँ।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","फ़रिश्ते ने कहा, ‘अपनी नज़र उठाकर उस पर ग़ौर कर जो हो रहा है। वह तमाम मेंढे और बकरे जो भेड़-बकरियों से मिलाप कर रहे हैं उनके जिस्म पर बड़े और छोटे धब्बे और धारियाँ हैं। मैं यह ख़ुद करवा रहा हूँ, क्योंकि मैंने वह सब कुछ देख लिया है जो लाबन ने तेरे साथ किया है। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","मैं वह ख़ुदा हूँ जो बैतेल में तुझ पर ज़ाहिर हुआ था, उस जगह जहाँ तूने सतून पर तेल उंडेलकर उसे मेरे लिए मख़सूस किया और मेरे हुज़ूर क़सम खाई थी। अब उठ और रवाना होकर अपने वतन वापस चला जा’।” ");
INSERT INTO urdgvh_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","राख़िल और लियाह ने जवाब में याक़ूब से कहा, “अब हमें अपने बाप की मीरास से कुछ मिलने की उम्मीद नहीं रही। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","उसका हमारे साथ अजनबी का-सा सुलूक है। पहले उसने हमें बेच दिया, और अब उसने वह सारे पैसे खा भी लिए हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","चुनाँचे जो भी दौलत अल्लाह ने हमारे बाप से छीन ली है वह हमारी और हमारे बच्चों की ही है। अब जो कुछ भी अल्लाह ने आपको बताया है वह करें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","तब याक़ूब ने उठकर अपने बाल-बच्चों को ऊँटों पर बिठाया ");
INSERT INTO urdgvh_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","और अपने तमाम मवेशी और मसोपुतामिया से हासिल किया हुआ तमाम सामान लेकर मुल्के-कनान में अपने बाप के हाँ जाने के लिए रवाना हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","उस वक़्त लाबन अपनी भेड़-बकरियों की पशम कतरने को गया हुआ था। उस की ग़ैरमौजूदगी में राख़िल ने अपने बाप के बुत चुरा लिए। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","याक़ूब ने लाबन को फ़रेब देकर उसे इत्तला न दी कि मैं जा रहा हूँ ");
INSERT INTO urdgvh_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","बल्कि अपनी सारी मिलकियत समेटकर फ़रार हुआ। दरियाए-फ़ुरात को पार करके वह जिलियाद के पहाड़ी इलाक़े की तरफ़ सफ़र करने लगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","तीन दिन गुज़र गए। फिर लाबन को बताया गया कि याक़ूब भाग गया है। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","अपने रिश्तेदारों को साथ लेकर उसने उसका ताक़्क़ुब किया। सात दिन चलते चलते उसने याक़ूब को आ लिया जब वह जिलियाद के पहाड़ी इलाक़े में पहुँच गया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","लेकिन उस रात अल्लाह ने ख़ाब में लाबन के पास आकर उससे कहा, “ख़बरदार! याक़ूब को बुरा-भला न कहना।” ");
INSERT INTO urdgvh_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","जब लाबन उसके पास पहुँचा तो याक़ूब ने जिलियाद के पहाड़ी इलाक़े में अपने ख़ैमे लगाए हुए थे। लाबन ने भी अपने रिश्तेदारों के साथ वहीं अपने ख़ैमे लगाए। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","उसने याक़ूब से कहा, “यह आपने क्या किया है? आप मुझे धोका देकर मेरी बेटियों को क्यों जंगी क़ैदियों की तरह हाँक लाए हैं? ");
INSERT INTO urdgvh_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","आप क्यों मुझे फ़रेब देकर ख़ामोशी से भाग आए हैं? अगर आप मुझे इत्तला देते तो मैं आपको ख़ुशी ख़ुशी दफ़ और सरोद के साथ गाते बजाते रुख़सत करता। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","आपने मुझे अपने नवासे-नवासियों और बेटियों को बोसा देने का मौक़ा भी न दिया। आपकी यह हरकत बड़ी अहमक़ाना थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","मैं आपको बहुत नुक़सान पहुँचा सकता हूँ। लेकिन पिछली रात आपके अब्बू के ख़ुदा ने मुझसे कहा, ‘ख़बरदार! याक़ूब को बुरा-भला न कहना।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ठीक है, आप इसलिए चले गए कि अपने बाप के घर वापस जाने के बड़े आरज़ूमंद थे। लेकिन यह आपने क्या किया है कि मेरे बुत चुरा लाए हैं?” ");
INSERT INTO urdgvh_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","याक़ूब ने जवाब दिया, “मुझे डर था कि आप अपनी बेटियों को मुझसे छीन लेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","लेकिन अगर आपको यहाँ किसी के पास अपने बुत मिल जाएँ तो उसे सज़ाए-मौत दी जाए हमारे रिश्तेदारों की मौजूदगी में मालूम करें कि मेरे पास आपकी कोई चीज़ है कि नहीं। अगर है तो उसे ले लें।” याक़ूब को मालूम नहीं था कि राख़िल ने बुतों को चुराया है। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","लाबन याक़ूब के ख़ैमे में दाख़िल हुआ और ढूँडने लगा। वहाँ से निकलकर वह लियाह के ख़ैमे में और दोनों लौंडियों के ख़ैमे में गया। लेकिन उसके बुत कहीं नज़र न आए। आख़िर में वह राख़िल के ख़ैमे में दाख़िल हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","राख़िल बुतों को ऊँटों की एक काठी के नीचे छुपाकर उस पर बैठ गई थी। लाबन टटोल टटोलकर पूरे ख़ैमे में से गुज़रा लेकिन बुत न मिले। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","राख़िल ने अपने बाप से कहा, “अब्बू, मुझसे नाराज़ न होना कि मैं आपके सामने खड़ी नहीं हो सकती। मैं ऐयामे-माहवारी के सबब से उठ नहीं सकती।” लाबन उसे छोड़कर ढूँडता रहा, लेकिन कुछ न मिला। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","फिर याक़ूब को ग़ुस्सा आया और वह लाबन से झगड़ने लगा। उसने पूछा, “मुझसे क्या जुर्म सरज़द हुआ है? मैंने क्या गुनाह किया है कि आप इतनी तुंदी से मेरे ताक़्क़ुब के लिए निकले हैं? ");
INSERT INTO urdgvh_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","आपने टटोल टटोलकर मेरे सारे सामान की तलाशी ली है। तो आपका क्या निकला है? उसे यहाँ अपने और मेरे रिश्तेदारों के सामने रखें। फिर वह फ़ैसला करें कि हममें से कौन हक़ पर है। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","मैं बीस साल तक आपके साथ रहा हूँ। उस दौरान आपकी भेड़-बकरियाँ बच्चों से महरूम नहीं रहीं बल्कि मैंने आपका एक मेंढा भी नहीं खाया। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","जब भी कोई भेड़ या बकरी किसी जंगली जानवर ने फाड़ डाली तो मैं उसे आपके पास न लाया बल्कि मुझे ख़ुद उसका नुक़सान भरना पड़ा। आपका तक़ाज़ा था कि मैं ख़ुद चोरी हुए माल का एवज़ाना दूँ, ख़ाह वह दिन के वक़्त चोरी हुआ या रात को। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","मैं दिन की शदीद गरमी के बाइस पिघल गया और रात की शदीद सर्दी के बाइस जम गया। काम इतना सख़्त था कि मैं नींद से महरूम रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","पूरे बीस साल इसी हालत में गुज़र गए। चौदह साल मैंने आपकी बेटियों के एवज़ काम किया और छः साल आपकी भेड़-बकरियों के लिए। उस दौरान आपने दस बार मेरी तनख़ाह बदल दी। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","अगर मेरे बाप इसहाक़ का ख़ुदा और मेरे दादा इब्राहीम का माबूद मेरे साथ न होता तो आप मुझे ज़रूर ख़ाली हाथ रुख़सत करते। लेकिन अल्लाह ने मेरी मुसीबत और मेरी सख़्त मेहनत-मशक़्क़त देखी है, इसलिए उसने कल रात को मेरे हक़ में फ़ैसला दिया।” ");
INSERT INTO urdgvh_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","तब लाबन ने याक़ूब से कहा, “यह बेटियाँ तो मेरी बेटियाँ हैं, और इनके बच्चे मेरे बच्चे हैं। यह भेड़-बकरियाँ भी मेरी ही हैं। लेकिन अब मैं अपनी बेटियों और उनके बच्चों के लिए कुछ नहीं कर सकता। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","इसलिए आओ, हम एक दूसरे के साथ अहद बाँधें। इसके लिए हम यहाँ पत्थरों का ढेर लगाएँ जो अहद की गवाही देता रहे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","चुनाँचे याक़ूब ने एक पत्थर लेकर उसे सतून के तौर पर खड़ा किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","उसने अपने रिश्तेदारों से कहा, “कुछ पत्थर जमा करें।” उन्होंने पत्थर जमा करके ढेर लगा दिया। फिर उन्होंने उस ढेर के पास बैठकर खाना खाया। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","लाबन ने उसका नाम यजर-शाहदूथा रखा जबकि याक़ूब ने जल-एद रखा। दोनों नामों का मतलब ‘गवाही का ढेर’ है यानी वह ढेर जो गवाही देता है। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","लाबन ने कहा, “आज हम दोनों के दरमियान यह ढेर अहद की गवाही देता है।” इसलिए उसका नाम जल-एद रखा गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","उसका एक और नाम मिसफ़ाह यानी ‘पहरेदारों का मीनार’ भी रखा गया। क्योंकि लाबन ने कहा, “रब हम पर पहरा दे जब हम एक दूसरे से अलग हो जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","मेरी बेटियों से बुरा सुलूक न करना, न उनके अलावा किसी और से शादी करना। अगर मुझे पता भी न चले लेकिन ज़रूर याद रखें कि अल्लाह मेरे और आपके सामने गवाह है। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","यहाँ यह ढेर है जो मैंने लगा दिया है और यहाँ यह सतून भी है। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","यह ढेर और सतून दोनों इसके गवाह हैं कि न मैं यहाँ से गुज़रकर आपको नुक़सान पहुँचाऊँगा और न आप यहाँ से गुज़रकर मुझे नुक़सान पहुँचाएँगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","इब्राहीम, नहूर और उनके बाप का ख़ुदा हम दोनों के दरमियान फ़ैसला करे अगर ऐसा कोई मामला हो।” जवाब में याक़ूब ने इसहाक़ के माबूद की क़सम खाई कि मैं यह अहद कभी नहीं तोड़ूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","उसने पहाड़ पर एक जानवर क़ुरबानी के तौर पर चढ़ाया और अपने रिश्तेदारों को खाना खाने की दावत दी। उन्होंने खाना खाकर वहीं पहाड़ पर रात गुज़ारी। ");
INSERT INTO urdgvh_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","अगले दिन सुबह-सवेरे लाबन ने अपने नवासे-नवासियों और बेटियों को बोसा देकर उन्हें बरकत दी। फिर वह अपने घर वापस चला गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","याक़ूब ने भी अपना सफ़र जारी रखा। रास्ते में अल्लाह के फ़रिश्ते उससे मिले। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","उन्हें देखकर उसने कहा, “यह अल्लाह की लशकरगाह है।” उसने उस मक़ाम का नाम महनायम यानी ‘दो लशकरगाहें’ रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","याक़ूब ने अपने भाई एसौ के पास अपने आगे आगे क़ासिद भेजे। एसौ सईर यानी अदोम के मुल्क में आबाद था। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","उन्हें एसौ को बताना था, “आपका ख़ादिम याक़ूब आपको इत्तला देता है कि मैं परदेस में जाकर अब तक लाबन का मेहमान रहा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","वहाँ मुझे बैल, गधे, भेड़-बकरियाँ, ग़ुलाम और लौंडियाँ हासिल हुए हैं। अब मैं अपने मालिक को इत्तला दे रहा हूँ कि वापस आ गया हूँ और आपकी नज़रे-करम का ख़ाहिशमंद हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","जब क़ासिद वापस आए तो उन्होंने कहा, “हम आपके भाई एसौ के पास गए, और वह 400 आदमी साथ लेकर आपसे मिलने आ रहा है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","याक़ूब घबराकर बहुत परेशान हुआ। उसने अपने साथ के तमाम लोगों, भेड़-बकरियों, गाय-बैलों और ऊँटों को दो गुरोहों में तक़सीम किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ख़याल यह था कि अगर एसौ आकर एक गुरोह पर हमला करे तो बाक़ी गुरोह शायद बच जाए। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","फिर याक़ूब ने दुआ की, “ऐ मेरे दादा इब्राहीम और मेरे बाप इसहाक़ के ख़ुदा, मेरी दुआ सुन! ऐ रब, तूने ख़ुद मुझे बताया, ‘अपने मुल्क और रिश्तेदारों के पास वापस जा, और मैं तुझे कामयाबी दूँगा।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","मैं उस तमाम मेहरबानी और वफ़ादारी के लायक़ नहीं जो तूने अपने ख़ादिम को दिखाई है। जब मैंने लाबन के पास जाते वक़्त दरियाए-यरदन को पार किया तो मेरे पास सिर्फ़ यह लाठी थी, और अब मेरे पास यह दो गुरोह हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","मुझे अपने भाई एसौ से बचा, क्योंकि मुझे डर है कि वह मुझ पर हमला करके बाल-बच्चों समेत सब कुछ तबाह कर देगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","तूने ख़ुद कहा था, ‘मैं तुझे कामयाबी दूँगा और तेरी औलाद इतनी बढ़ाऊँगा कि वह समुंदर की रेत की मानिंद बेशुमार होगी’।” ");
INSERT INTO urdgvh_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","याक़ूब ने वहाँ रात गुज़ारी। फिर उसने अपने माल में से एसौ के लिए तोह्फ़े चुन लिए : ");
INSERT INTO urdgvh_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 बकरियाँ, 20 बकरे, 200 भेड़ें, 20 मेंढे, ");
INSERT INTO urdgvh_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 दूध देनेवाली ऊँटनियाँ बच्चों समेत, 40 गाएँ, 10 बैल, 20 गधियाँ और 10 गधे। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","उसने उन्हें मुख़्तलिफ़ रेवड़ों में तक़सीम करके अपने मुख़्तलिफ़ नौकरों के सुपुर्द किया और उनसे कहा, “मेरे आगे आगे चलो लेकिन हर रेवड़ के दरमियान फ़ासला रखो।” ");
INSERT INTO urdgvh_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","जो नौकर पहले रेवड़ लेकर आगे निकला उससे याक़ूब ने कहा, “मेरा भाई एसौ तुमसे मिलेगा और पूछेगा, ‘तुम्हारा मालिक कौन है? तुम कहाँ जा रहे हो? तुम्हारे सामने के जानवर किसके हैं?’ ");
INSERT INTO urdgvh_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","जवाब में तुम्हें कहना है, ‘यह आपके ख़ादिम याक़ूब के हैं। यह तोह्फ़ा हैं जो वह अपने मालिक एसौ को भेज रहे हैं। याक़ूब हमारे पीछे पीछे आ रहे हैं’।” ");
INSERT INTO urdgvh_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","याक़ूब ने यही हुक्म हर एक नौकर को दिया जिसे रेवड़ लेकर उसके आगे आगे जाना था। उसने कहा, “जब तुम एसौ से मिलोगे तो उससे यही कहना है। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","तुम्हें यह भी ज़रूर कहना है, आपके ख़ादिम याक़ूब हमारे पीछे आ रहे हैं।” क्योंकि याक़ूब ने सोचा, ‘मैं इन तोह्फ़ों से उसके साथ सुलह करूँगा। फिर जब उससे मुलाक़ात होगी तो शायद वह मुझे क़बूल कर ले।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","यों उसने यह तोह्फ़े अपने आगे आगे भेज दिए। लेकिन उसने ख़ुद ख़ैमागाह में रात गुज़ारी। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","उस रात वह उठा और अपनी दो बीवियों, दो लौंडियों और ग्यारह बेटों को लेकर दरियाए-यब्बोक़ को वहाँ से पार किया जहाँ कम गहराई थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","फिर उसने अपना सारा सामान भी वहाँ भेज दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","लेकिन वह ख़ुद अकेला ही पीछे रह गया। उस वक़्त एक आदमी आया और पौ फटने तक उससे कुश्ती लड़ता रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","जब उसने देखा कि मैं याक़ूब पर ग़ालिब नहीं आ रहा तो उसने उसके कूल्हे को छुआ, और उसका जोड़ निकल गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","आदमी ने कहा, “मुझे जाने दे, क्योंकि पौ फटनेवाली है।” याक़ूब ने कहा, “पहले मुझे बरकत दें, फिर ही आपको जाने दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","आदमी ने पूछा, “तेरा क्या नाम है?” उसने जवाब दिया, “याक़ूब।” ");
INSERT INTO urdgvh_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","आदमी ने कहा, “अब से तेरा नाम याक़ूब नहीं बल्कि इसराईल यानी ‘वह अल्लाह से लड़ता है’ होगा। क्योंकि तू अल्लाह और आदमियों के साथ लड़कर ग़ालिब आया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","याक़ूब ने कहा, “मुझे अपना नाम बताएँ।” उसने कहा, “तू क्यों मेरा नाम जानना चाहता है?” फिर उसने याक़ूब को बरकत दी। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","याक़ूब ने कहा, “मैंने अल्लाह को रूबरू देखा तो भी बच गया हूँ।” इसलिए उसने उस मक़ाम का नाम फ़नियेल रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","याक़ूब वहाँ से चला तो सूरज तुलू हो रहा था। वह कूल्हे के सबब से लँगड़ाता रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","यही वजह है कि आज भी इसराईल की औलाद कूल्हे के जोड़ पर की नस को नहीं खाते, क्योंकि याक़ूब की इसी नस को छुआ गया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","फिर एसौ उनकी तरफ़ आता हुआ नज़र आया। उसके साथ 400 आदमी थे। उन्हें देखकर याक़ूब ने बच्चों को बाँटकर लियाह, राख़िल और दोनों लौंडियों के हवाले कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","उसने दोनों लौंडियों को उनके बच्चों समेत आगे चलने दिया। फिर लियाह उसके बच्चों समेत और आख़िर में राख़िल और यूसुफ़ आए। ");
INSERT INTO urdgvh_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","याक़ूब ख़ुद सबसे आगे एसौ से मिलने गया। चलते चलते वह सात दफ़ा ज़मीन तक झुका। ");
INSERT INTO urdgvh_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","लेकिन एसौ दौड़कर उससे मिलने आया और उसे गले लगाकर बोसा दिया। दोनों रो पड़े। ");
INSERT INTO urdgvh_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","फिर एसौ ने औरतों और बच्चों को देखा। उसने पूछा, “तुम्हारे साथ यह लोग कौन हैं?” याक़ूब ने कहा, “यह आपके ख़ादिम के बच्चे हैं जो अल्लाह ने अपने करम से नवाज़े हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","दोनों लौंडियाँ अपने बच्चों समेत आकर उसके सामने झुक गईं। ");
INSERT INTO urdgvh_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","फिर लियाह अपने बच्चों के साथ आई और आख़िर में यूसुफ़ और राख़िल आकर झुक गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","एसौ ने पूछा, “जिस जानवरों के बड़े ग़ोल से मेरी मुलाक़ात हुई उससे क्या मुराद है?” याक़ूब ने जवाब दिया, “यह तोह्फ़ा है ताकि आपका ख़ादिम आपकी नज़र में मक़बूल हो।” ");
INSERT INTO urdgvh_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","लेकिन एसौ ने कहा, “मेरे भाई, मेरे पास बहुत कुछ है। यह अपने पास ही रखो।” ");
INSERT INTO urdgvh_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","याक़ूब ने कहा, “नहीं जी, अगर मुझ पर आपके करम की नज़र है तो मेरे इस तोह्फ़े को ज़रूर क़बूल फ़रमाएँ। क्योंकि जब मैंने आपका चेहरा देखा तो वह मेरे लिए अल्लाह के चेहरे की मानिंद था, आपने मेरे साथ इस क़दर अच्छा सुलूक किया है। ");
INSERT INTO urdgvh_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","मेहरबानी करके यह तोह्फ़ा क़बूल करें जो मैं आपके लिए लाया हूँ। क्योंकि अल्लाह ने मुझ पर अपने करम का इज़हार किया है, और मेरे पास बहुत कुछ है।” याक़ूब इसरार करता रहा तो आख़िरकार एसौ ने उसे क़बूल कर लिया। फिर एसौ कहने लगा, ");
INSERT INTO urdgvh_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","“आओ, हम रवाना हो जाएँ। मैं तुम्हारे आगे आगे चलूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","याक़ूब ने जवाब दिया, “मेरे मालिक, आप जानते हैं कि मेरे बच्चे नाज़ुक हैं। मेरे पास भेड़-बकरियाँ, गाय-बैल और उनके दूध पीनेवाले बच्चे भी हैं। अगर मैं उन्हें एक दिन के लिए भी हद से ज़्यादा हाँकूँ तो वह मर जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","मेरे मालिक, मेहरबानी करके मेरे आगे आगे जाएँ। मैं आराम से उसी रफ़्तार से आपके पीछे पीछे चलता रहूँगा जिस रफ़्तार से मेरे मवेशी और मेरे बच्चे चल सकेंगे। यों हम आहिस्ता चलते हुए आपके पास सईर पहुँचेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","एसौ ने कहा, “क्या मैं अपने आदमियों में से कुछ आपके पास छोड़ दूँ?” लेकिन याक़ूब ने कहा, “क्या ज़रूरत है? सबसे अहम बात यह है कि आपने मुझे क़बूल कर लिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","उस दिन एसौ सईर के लिए और ");
INSERT INTO urdgvh_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","याक़ूब सुक्कात के लिए रवाना हुआ। वहाँ उसने अपने लिए मकान बना लिया और अपने मवेशियों के लिए झोंपड़ियाँ। इसलिए उस मक़ाम का नाम सुक्कात यानी झोंपड़ियाँ पड़ गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","फिर याक़ूब चलते चलते सलामती से सिकम शहर पहुँचा। यों उसका मसोपुतामिया से मुल्के-कनान तक का सफ़र इख़्तिताम तक पहुँच गया। उसने अपने ख़ैमे शहर के सामने लगाए। ");
INSERT INTO urdgvh_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","उसके ख़ैमे हमोर की औलाद की ज़मीन पर लगे थे। उसने यह ज़मीन चाँदी के 100 सिक्कों के बदले ख़रीद ली। ");
INSERT INTO urdgvh_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","वहाँ उसने क़ुरबानगाह बनाई जिसका नाम उसने ‘एल ख़ुदाए-इसराईल’ रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","एक दिन याक़ूब और लियाह की बेटी दीना कनानी औरतों से मिलने के लिए घर से निकली। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","शहर में एक आदमी बनाम सिकम रहता था। उसका वालिद हमोर उस इलाक़े का हुक्मरान था और हिव्वी क़ौम से ताल्लुक़ रखता था। जब सिकम ने दीना को देखा तो उसने उसे पकड़कर उस की इसमतदरी की। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","लेकिन उसका दिल दीना से लग गया। वह उससे मुहब्बत करने लगा और प्यार से उससे बातें करता रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","उसने अपने बाप से कहा, “इस लड़की के साथ मेरी शादी करा दें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","जब याक़ूब ने अपनी बेटी की इसमतदरी की ख़बर सुनी तो उसके बेटे मवेशियों के साथ खुले मैदान में थे। इसलिए वह उनके वापस आने तक ख़ामोश रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","सिकम का बाप हमोर शहर से निकलकर याक़ूब से बात करने के लिए आया। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","जब याक़ूब के बेटों को दीना की इसमतदरी की ख़बर मिली तो उनके दिल रंजिश और ग़ुस्से से भर गए कि सिकम ने याक़ूब की बेटी की इसमतदरी से इसराईल की इतनी बेइज़्ज़ती की है। वह सीधे खुले मैदान से वापस आए। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","हमोर ने याक़ूब से कहा, “मेरे बेटे का दिल आपकी बेटी से लग गया है। मेहरबानी करके उस की शादी मेरे बेटे के साथ कर दें। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","हमारे साथ रिश्ता बाँधें, हमारे बेटे-बेटियों के साथ शादियाँ कराएँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","फिर आप हमारे साथ इस मुल्क में रह सकेंगे और पूरा मुल्क आपके लिए खुला होगा। आप जहाँ भी चाहें आबाद हो सकेंगे, तिजारत कर सकेंगे और ज़मीन ख़रीद सकेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","सिकम ने ख़ुद भी दीना के बाप और भाइयों से मिन्नत की, “अगर मेरी यह दरख़ास्त मंज़ूर हो तो मैं जो कुछ आप कहेंगे अदा कर दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","जितना भी महर और तोह्फ़े आप मुक़र्रर करें मैं दे दूँगा। सिर्फ़ मेरी यह ख़ाहिश पूरी करें कि यह लड़की मेरे अक़द में आ जाए।” ");
INSERT INTO urdgvh_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","लेकिन दीना की इसमतदरी के सबब से याक़ूब के बेटों ने सिकम और उसके बाप हमोर से चालाकी करके ");
INSERT INTO urdgvh_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","कहा, “हम ऐसा नहीं कर सकते। हम अपनी बहन की शादी किसी ऐसे आदमी से नहीं करा सकते जिसका ख़तना नहीं हुआ। इससे हमारी बेइज़्ज़ती होती है। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","हम सिर्फ़ इस शर्त पर राज़ी होंगे कि आप अपने तमाम लड़कों और मर्दों का ख़तना करवाने से हमारी मानिंद हो जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","फिर आपके बेटे-बेटियों के साथ हमारी शादियाँ हो सकेंगी और हम आपके साथ एक क़ौम बन जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","लेकिन अगर आप ख़तना कराने के लिए तैयार नहीं हैं तो हम अपनी बहन को लेकर चले जाएंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","यह बातें हमोर और उसके बेटे सिकम को अच्छी लगीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","नौजवान सिकम ने फ़ौरन उन पर अमल किया, क्योंकि वह दीना को बहुत पसंद करता था। सिकम अपने ख़ानदान में सबसे मुअज़्ज़ज़ था। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","हमोर अपने बेटे सिकम के साथ शहर के दरवाज़े पर गया जहाँ शहर के फ़ैसले किए जाते थे। वहाँ उन्होंने बाक़ी शहरियों से बात की। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“यह आदमी हमसे झगड़नेवाले नहीं हैं, इसलिए क्यों न वह इस मुल्क में हमारे साथ रहें और हमारे दरमियान तिजारत करें? हमारे मुल्क में उनके लिए भी काफ़ी जगह है। आओ, हम उनकी बेटियों और बेटों से शादियाँ करें। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","लेकिन यह आदमी सिर्फ़ इस शर्त पर हमारे दरमियान रहने और एक ही क़ौम बनने के लिए तैयार हैं कि हम उनकी तरह अपने तमाम लड़कों और मर्दों का ख़तना कराएँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","अगर हम ऐसा करें तो उनके तमाम मवेशी और सारा माल हमारा ही होगा। चुनाँचे आओ, हम मुत्तफ़िक़ होकर फ़ैसला कर लें ताकि वह हमारे दरमियान रहें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","सिकम के शहरी हमोर और सिकम के मशवरे पर राज़ी हुए। तमाम लड़कों और मर्दों का ख़तना कराया गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","तीन दिन के बाद जब ख़तने के सबब से लोगों की हालत बुरी थी तो दीना के दो भाई शमौन और लावी अपनी तलवारें लेकर शहर में दाख़िल हुए। किसी को शक तक नहीं था कि क्या कुछ होगा। अंदर जाकर उन्होंने बच्चों से लेकर बूढ़ों तक तमाम मर्दों को क़त्ल कर दिया ");
INSERT INTO urdgvh_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","जिनमें हमोर और उसका बेटा सिकम भी शामिल थे। फिर वह दीना को सिकम के घर से लेकर चले गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","इस क़त्ले-आम के बाद याक़ूब के बाक़ी बेटे शहर पर टूट पड़े और उसे लूट लिया। यों उन्होंने अपनी बहन की इसमतदरी का बदला लिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","वह भेड़-बकरियाँ, गाय-बैल, गधे और शहर के अंदर और बाहर का सब कुछ लेकर चलते बने। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","उन्होंने सारे माल पर क़ब्ज़ा किया, औरतों और बच्चों को क़ैदी बना लिया और तमाम घरों का सामान भी ले गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","फिर याक़ूब ने शमौन और लावी से कहा, “तुमने मुझे मुसीबत में डाल दिया है। अब कनानी, फ़रिज़्ज़ी और मुल्क के बाक़ी बाशिंदों में मेरी बदनामी हुई है। मेरे साथ कम आदमी हैं। अगर दूसरे मिलकर हम पर हमला करें तो हमारे पूरे ख़ानदान का सत्यानास हो जाएगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","लेकिन उन्होंने कहा, “क्या यह ठीक था कि उसने हमारी बहन के साथ कसबी का-सा सुलूक किया?” ");
INSERT INTO urdgvh_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","अल्लाह ने याक़ूब से कहा, “उठ, बैतेल जाकर वहाँ आबाद हो। वहीं अल्लाह के लिए जो तुझ पर ज़ाहिर हुआ जब तू अपने भाई एसौ से भाग रहा था क़ुरबानगाह बना।” ");
INSERT INTO urdgvh_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","चुनाँचे याक़ूब ने अपने घरवालों और बाक़ी सारे साथियों से कहा, “जो भी अजनबी बुत आपके पास हैं उन्हें फेंक दें। अपने आपको पाक-साफ़ करके अपने कपड़े बदलें, ");
INSERT INTO urdgvh_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","क्योंकि हमें यह जगह छोड़कर बैतेल जाना है। वहाँ मैं उस ख़ुदा के लिए क़ुरबानगाह बनाऊँगा जिसने मुसीबत के वक़्त मेरी दुआ सुनी। जहाँ भी मैं गया वहाँ वह मेरे साथ रहा है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","यह सुनकर उन्होंने याक़ूब को तमाम बुत दे दिए जो उनके पास थे और तमाम बालियाँ जो उन्होंने तावीज़ के तौर पर कानों में पहन रखी थीं। उसने सब कुछ सिकम के क़रीब बलूत के दरख़्त के नीचे ज़मीन में दबा दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","फिर वह रवाना हुए। इर्दगिर्द के शहरों पर अल्लाह की तरफ़ से इतना शदीद ख़ौफ़ छा गया कि उन्होंने याक़ूब और उसके बेटों का ताक़्क़ुब न किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","चलते चलते याक़ूब अपने लोगों समेत लूज़ पहुँच गया जो मुल्के-कनान में था। आज लूज़ का नाम बैतेल है। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","याक़ूब ने वहाँ क़ुरबानगाह बनाकर मक़ाम का नाम बैतेल यानी ‘अल्लाह का घर’ रखा। क्योंकि वहाँ अल्लाह ने अपने आपको उस पर ज़ाहिर किया था जब वह अपने भाई से फ़रार हो रहा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","वहाँ रिबक़ा की दाया दबोरा मर गई। वह बैतेल के जुनूब में बलूत के दरख़्त के नीचे दफ़न हुई, इसलिए उसका नाम अल्लोन-बकूत यानी ‘रोने का बलूत का दरख़्त’ रखा गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","अल्लाह याक़ूब पर एक दफ़ा और ज़ाहिर हुआ और उसे बरकत दी। यह मसोपुतामिया से वापस आने पर दूसरी बार हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","अल्लाह ने उससे कहा, “अब से तेरा नाम याक़ूब नहीं बल्कि इसराईल होगा।” यों उसने उसका नया नाम इसराईल रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","अल्लाह ने यह भी उससे कहा, “मैं अल्लाह क़ादिरे-मुतलक़ हूँ। फल-फूल और तादाद में बढ़ता जा। एक क़ौम नहीं बल्कि बहुत-सी क़ौमें तुझसे निकलेंगी। तेरी औलाद में बादशाह भी शामिल होंगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","मैं तुझे वही मुल्क दूँगा जो इब्राहीम और इसहाक़ को दिया है। और तेरे बाद उसे तेरी औलाद को दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","फिर अल्लाह वहाँ से आसमान पर चला गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","जहाँ अल्लाह याक़ूब से हमकलाम हुआ था वहाँ उसने पत्थर का सतून खड़ा किया और उस पर मै और तेल उंडेलकर उसे मख़सूस किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","उसने जगह का नाम बैतेल रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","फिर याक़ूब अपने घरवालों के साथ बैतेल को छोड़कर इफ़राता की तरफ़ चल पड़ा। राख़िल उम्मीद से थी, और रास्ते में बच्चे की पैदाइश का वक़्त आ गया। बच्चा बड़ी मुश्किल से पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","जब दर्दे-ज़ह उरूज को पहुँच गया तो दाई ने उससे कहा, “मत डरो, क्योंकि एक और बेटा है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","लेकिन वह दम तोड़नेवाली थी, और मरते मरते उसने उसका नाम बिन-ऊनी यानी ‘मेरी मुसीबत का बेटा’ रखा। लेकिन उसके बाप ने उसका नाम बिनयमीन यानी ‘दहने हाथ या ख़ुशक़िसमती का बेटा’ रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","राख़िल फ़ौत हुई, और वह इफ़राता के रास्ते में दफ़न हुई। आजकल इफ़राता को बैत-लहम कहा जाता है। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","याक़ूब ने उस की क़ब्र पर पत्थर का सतून खड़ा किया। वह आज तक राख़िल की क़ब्र की निशानदेही करता है। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","वहाँ से याक़ूब ने अपना सफ़र जारी रखा और मिजदल-इदर की परली तरफ़ अपने ख़ैमे लगाए। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","जब वह वहाँ ठहरे थे तो रूबिन याक़ूब की हरम बिलहाह से हमबिसतर हुआ। याक़ूब को मालूम हो गया। याक़ूब के बारह बेटे थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","लियाह के बेटे यह थे : उसका सबसे बड़ा बेटा रूबिन, फिर शमौन, लावी, यहूदाह, इशकार और ज़बूलून। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","राख़िल के दो बेटे थे, यूसुफ़ और बिनयमीन। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","राख़िल की लौंडी बिलहाह के दो बेटे थे, दान और नफ़ताली। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","लियाह की लौंडी ज़िलफ़ा के दो बेटे थे, जद और आशर। याक़ूब के यह बेटे मसोपुतामिया में पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","फिर याक़ूब अपने बाप इसहाक़ के पास पहुँच गया जो हबरून के क़रीब ममरे में अजनबी की हैसियत से रहता था (उस वक़्त हबरून का नाम क़िरियत-अरबा था)। वहाँ इसहाक़ और उससे पहले इब्राहीम रहा करते थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","इसहाक़ 180 साल का था जब वह उम्ररसीदा और ज़िंदगी से आसूदा होकर अपने बापदादा से जा मिला। उसके बेटे एसौ और याक़ूब ने उसे दफ़न किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","यह एसौ की औलाद का नसबनामा है (एसौ को अदोम भी कहा जाता है) : ");
INSERT INTO urdgvh_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसौ ने तीन कनानी औरतों से शादी की : हित्ती आदमी ऐलोन की बेटी अदा से, अना की बेटी उहलीबामा से जो हिव्वी आदमी सिबोन की नवासी थी ");
INSERT INTO urdgvh_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","और इसमाईल की बेटी बासमत से जो नबायोत की बहन थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","अदा का एक बेटा इलीफ़ज़ और बासमत का एक बेटा रऊएल पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","उहलीबामा के तीन बेटे पैदा हुए, यऊस, यालाम और क़ोरह। एसौ के यह तमाम बेटे मुल्के-कनान में पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","बाद में एसौ दूसरे मुल्क में चला गया। उसने अपनी बीवियों, बेटे-बेटियों और घर के रहनेवालों को अपने तमाम मवेशियों और मुल्के-कनान में हासिल किए हुए माल समेत अपने साथ लिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","वह इस वजह से चला गया कि दोनों भाइयों के पास इतने रेवड़ थे कि चराने की जगह कम पड़ गई। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","चुनाँचे एसौ पहाड़ी इलाक़े सईर में आबाद हुआ। एसौ का दूसरा नाम अदोम है। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","यह एसौ यानी सईर के पहाड़ी इलाक़े में आबाद अदोमियों का नसबनामा है : ");
INSERT INTO urdgvh_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसौ की बीवी अदा का एक बेटा इलीफ़ज़ था जबकि उस की बीवी बासमत का एक बेटा रऊएल था। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","इलीफ़ज़ के बेटे तेमान, ओमर, सफ़ो, जाताम, क़नज़ ");
INSERT INTO urdgvh_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","और अमालीक़ थे। अमालीक़ इलीफ़ज़ की हरम तिमना का बेटा था। यह सब एसौ की बीवी अदा की औलाद में शामिल थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","रऊएल के बेटे नहत, ज़ारह, सम्मा और मिज़्ज़ा थे। यह सब एसौ की बीवी बासमत की औलाद में शामिल थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","एसौ की बीवी उहलीबामा जो अना की बेटी और सिबोन की नवासी थी के तीन बेटे यऊस, यालाम और क़ोरह थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","एसौ से मुख़्तलिफ़ क़बीलों के सरदार निकले। उसके पहलौठे इलीफ़ज़ से यह क़बायली सरदार निकले : तेमान, ओमर, सफ़ो, क़नज़, ");
INSERT INTO urdgvh_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","क़ोरह, जाताम और अमालीक़। यह सब एसौ की बीवी अदा की औलाद थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","एसौ के बेटे रऊएल से यह क़बायली सरदार निकले : नहत, ज़ारह, सम्मा और मिज़्ज़ा। यह सब एसौ की बीवी बासमत की औलाद थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","एसौ की बीवी उहलीबामा यानी अना की बेटी से यह क़बायली सरदार निकले : यऊस, यालाम और क़ोरह। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","यह तमाम सरदार एसौ की औलाद हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","मुल्के-अदोम के कुछ बाशिंदे होरी आदमी सईर की औलाद थे। उनके नाम लोतान, सोबल, सिबोन, अना, ");
INSERT INTO urdgvh_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दीसोन, एसर और दीसान थे। सईर के यह बेटे मुल्के-अदोम में होरी क़बीलों के सरदार थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोतान होरी और हेमाम का बाप था। (तिमना लोतान की बहन थी।) ");
INSERT INTO urdgvh_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","सोबल के बेटे अलवान, मानहत, ऐबाल, सफ़ो और ओनाम थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","सिबोन के बेटे ऐयाह और अना थे। इसी अना को गरम चश्मे मिले जब वह बयाबान में अपने बाप के गधे चरा रहा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","अना का एक बेटा दीसोन और एक बेटी उहलीबामा थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","दीसोन के चार बेटे हमदान, इशबान, यितरान और किरान थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एसर के तीन बेटे बिलहान, ज़ावान और अक़ान थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दीसान के दो बेटे ऊज़ और अरान थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","यही यानी लोतान, सोबल, सिबोन, अना, दीसोन, एसर और दीसान सईर के मुल्क में होरी क़बायल के सरदार थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","इससे पहले कि इसराईलियों का कोई बादशाह था ज़ैल के बादशाह यके बाद दीगरे मुल्के-अदोम में हुकूमत करते थे : ");
INSERT INTO urdgvh_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बाला बिन बओर जो दिनहाबा शहर का था मुल्के-अदोम का पहला बादशाह था। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","उस की मौत पर यूबाब बिन ज़ारह जो बुसरा शहर का था। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","उस की मौत पर हुशाम जो तेमानियों के मुल्क का था। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","उस की मौत पर हदद बिन बिदद जिसने मुल्के-मोआब में मिदियानियों को शिकस्त दी। वह अवीत का था। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","उस की मौत पर समला जो मसरिक़ा का था। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","उस की मौत पर साऊल जो दरियाए-फ़ुरात पर रहोबोत शहर का था। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","उस की मौत पर बाल-हनान बिन अकबोर। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","उस की मौत पर हदद जो फ़ाऊ शहर का था (बीवी का नाम महेतबेल बिंत मतरिद बिंत मेज़ाहाब था)। ");
INSERT INTO urdgvh_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","एसौ से अदोमी क़बीलों के यह सरदार निकले : तिमना, अलवह, यतेत, उहलीबामा, ऐला, फ़ीनोन, क़नज़, तेमान, मिबसार, मजदियेल और इराम। अदोम के सरदारों की यह फ़हरिस्त उनकी मौरूसी ज़मीन की आबादियों और क़बीलों के मुताबिक़ ही बयान की गई है। एसौ उनका बाप है। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","याक़ूब मुल्के-कनान में रहता था जहाँ पहले उसका बाप भी परदेसी था। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","यह याक़ूब के ख़ानदान का बयान है। उस वक़्त याक़ूब का बेटा यूसुफ़ 17 साल का था। वह अपने भाइयों यानी बिलहाह और ज़िलफ़ा के बेटों के साथ भेड़-बकरियों की देख-भाल करता था। यूसुफ़ अपने बाप को अपने भाइयों की बुरी हरकतों की इत्तला दिया करता था। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","याक़ूब यूसुफ़ को अपने तमाम बेटों की निसबत ज़्यादा प्यार करता था। वजह यह थी कि वह तब पैदा हुआ जब बाप बूढ़ा था। इसलिए याक़ूब ने उसके लिए एक ख़ास रंगदार लिबास बनवाया। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","जब उसके भाइयों ने देखा कि हमारा बाप यूसुफ़ को हमसे ज़्यादा प्यार करता है तो वह उससे नफ़रत करने लगे और अदब से उससे बात नहीं करते थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","एक रात यूसुफ़ ने ख़ाब देखा। जब उसने अपने भाइयों को ख़ाब सुनाया तो वह उससे और भी नफ़रत करने लगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","उसने कहा, “सुनो, मैंने ख़ाब देखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","हम सब खेत में पूले बाँध रहे थे कि मेरा पूला खड़ा हो गया। आपके पूले मेरे पूले के इर्दगिर्द जमा होकर उसके सामने झुक गए।” ");
INSERT INTO urdgvh_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","उसके भाइयों ने कहा, “अच्छा, तू बादशाह बनकर हम पर हुकूमत करेगा?” उसके ख़ाबों और उस की बातों के सबब से उनकी उससे नफ़रत मज़ीद बढ़ गई। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","कुछ देर के बाद यूसुफ़ ने एक और ख़ाब देखा। उसने अपने भाइयों से कहा, “मैंने एक और ख़ाब देखा है। उसमें सूरज, चाँद और ग्यारह सितारे मेरे सामने झुक गए।” ");
INSERT INTO urdgvh_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","उसने यह ख़ाब अपने बाप को भी सुनाया तो उसने उसे डाँटा। उसने कहा, “यह कैसा ख़ाब है जो तूने देखा! यह कैसी बात है कि मैं, तेरी माँ और तेरे भाई आकर तेरे सामने ज़मीन तक झुक जाएँ?” ");
INSERT INTO urdgvh_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","नतीजे में उसके भाई उससे बहुत हसद करने लगे। लेकिन उसके बाप ने दिल में यह बात महफ़ूज़ रखी। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","एक दिन जब यूसुफ़ के भाई अपने बाप के रेवड़ चराने के लिए सिकम तक पहुँच गए थे ");
INSERT INTO urdgvh_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","तो याक़ूब ने यूसुफ़ से कहा, “तेरे भाई सिकम में रेवड़ों को चरा रहे हैं। आ, मैं तुझे उनके पास भेज देता हूँ।” यूसुफ़ ने जवाब दिया, “ठीक है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","याक़ूब ने कहा, “जाकर मालूम कर कि तेरे भाई और उनके साथ के रेवड़ ख़ैरियत से हैं कि नहीं। फिर वापस आकर मुझे बता देना।” चुनाँचे उसके बाप ने उसे वादीए-हबरून से भेज दिया, और यूसुफ़ सिकम पहुँच गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","वहाँ वह इधर-उधर फिरता रहा। आख़िरकार एक आदमी उससे मिला और पूछा, “आप क्या ढूँड रहे हैं?” ");
INSERT INTO urdgvh_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","यूसुफ़ ने जवाब दिया, “मैं अपने भाइयों को तलाश कर रहा हूँ। मुझे बताएँ कि वह अपने जानवरों को कहाँ चरा रहे हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","आदमी ने कहा, “वह यहाँ से चले गए हैं। मैंने उन्हें यह कहते सुना कि आओ, हम दूतैन जाएँ।” यह सुनकर यूसुफ़ अपने भाइयों के पीछे दूतैन चला गया। वहाँ उसे वह मिल गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","जब यूसुफ़ अभी दूर से नज़र आया तो उसके भाइयों ने उसके पहुँचने से पहले उसे क़त्ल करने का मनसूबा बनाया। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","उन्होंने कहा, “देखो, ख़ाब देखनेवाला आ रहा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","आओ, हम उसे मार डालें और उस की लाश किसी गढ़े में फेंक दें। हम कहेंगे कि किसी वहशी जानवर ने उसे फाड़ खाया है। फिर पता चलेगा कि उसके ख़ाबों की क्या हक़ीक़त है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","जब रूबिन ने उनकी बातें सुनीं तो उसने यूसुफ़ को बचाने की कोशिश की। उसने कहा, “नहीं, हम उसे क़त्ल न करें। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","उसका ख़ून न करना। बेशक उसे इस गढ़े में फेंक दें जो रेगिस्तान में है, लेकिन उसे हाथ न लगाएँ।” उसने यह इसलिए कहा कि वह उसे बचाकर बाप के पास वापस पहुँचाना चाहता था। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ज्योंही यूसुफ़ अपने भाइयों के पास पहुँचा उन्होंने उसका रंगदार लिबास उतारकर ");
INSERT INTO urdgvh_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","यूसुफ़ को गढ़े में फेंक दिया। गढ़ा ख़ाली था, उसमें पानी नहीं था। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","फिर वह रोटी खाने के लिए बैठ गए। अचानक इसमाईलियों का एक क़ाफ़िला नज़र आया। वह जिलियाद से मिसर जा रहे थे, और उनके ऊँट क़ीमती मसालों यानी लादन, बलसान और मुर से लदे हुए थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","तब यहूदाह ने अपने भाइयों से कहा, “हमें क्या फ़ायदा है अगर अपने भाई को क़त्ल करके उसके ख़ून को छुपा दें? ");
INSERT INTO urdgvh_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","आओ, हम उसे इन इसमाईलियों के हाथ फ़रोख़्त कर दें। फिर कोई ज़रूरत नहीं होगी कि हम उसे हाथ लगाएँ। आख़िर वह हमारा भाई है।” उसके भाई राज़ी हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","चुनाँचे जब मिदियानी ताजिर वहाँ से गुज़रे तो भाइयों ने यूसुफ़ को खींचकर गढ़े से निकाला और चाँदी के 20 सिक्कों के एवज़ बेच डाला। इसमाईली उसे लेकर मिसर चले गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","उस वक़्त रूबिन मौजूद नहीं था। जब वह गढ़े के पास वापस आया तो यूसुफ़ उसमें नहीं था। यह देखकर उसने परेशानी में अपने कपड़े फाड़ डाले। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","वह अपने भाइयों के पास वापस गया और कहा, “लड़का नहीं है। अब मैं किस तरह अब्बू के पास जाऊँ?” ");
INSERT INTO urdgvh_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","तब उन्होंने बकरा ज़बह करके यूसुफ़ का लिबास उसके ख़ून में डुबोया, ");
INSERT INTO urdgvh_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","फिर रंगदार लिबास इस ख़बर के साथ अपने बाप को भिजवा दिया कि “हमें यह मिला है। इसे ग़ौर से देखें। यह आपके बेटे का लिबास तो नहीं?” ");
INSERT INTO urdgvh_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","याक़ूब ने उसे पहचान लिया और कहा, “बेशक उसी का है। किसी वहशी जानवर ने उसे फाड़ खाया है। यक़ीनन यूसुफ़ को फाड़ दिया गया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","याक़ूब ने ग़म के मारे अपने कपड़े फाड़े और अपनी कमर से टाट ओढ़कर बड़ी देर तक अपने बेटे के लिए मातम करता रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","उसके तमाम बेटे-बेटियाँ उसे तसल्ली देने आए, लेकिन उसने तसल्ली पाने से इनकार किया और कहा, “मैं पाताल में उतरते हुए भी अपने बेटे के लिए मातम करूँगा।” इस हालत में वह अपने बेटे के लिए रोता रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","इतने में मिदियानी मिसर पहुँचकर यूसुफ़ को बेच चुके थे। मिसर के बादशाह फ़िरौन के एक आला अफ़सर फ़ूतीफ़ार ने उसे ख़रीद लिया। फ़ूतीफ़ार बादशाह के मुहाफ़िज़ों पर मुक़र्रर था। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","उन दिनों में यहूदाह अपने भाइयों को छोड़कर एक आदमी के पास रहने लगा जिसका नाम हीरा था और जो अदुल्लाम शहर से था। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","वहाँ यहूदाह की मुलाक़ात एक कनानी औरत से हुई जिसके बाप का नाम सुअ था। उसने उससे शादी की। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","बेटा पैदा हुआ जिसका नाम यहूदाह ने एर रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","एक और बेटा पैदा हुआ जिसका नाम बीवी ने ओनान रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","उसके तीसरा बेटा भी पैदा हुआ। उसने उसका नाम सेला रखा। यहूदाह क़ज़ीब में था जब वह पैदा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","यहूदाह ने अपने बड़े बेटे एर की शादी एक लड़की से कराई जिसका नाम तमर था। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","रब के नज़दीक एर शरीर था, इसलिए उसने उसे हलाक कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","इस पर यहूदाह ने एर के छोटे भाई ओनान से कहा, “अपने बड़े भाई की बेवा के पास जाओ और उससे शादी करो ताकि तुम्हारे भाई की नसल क़ायम रहे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ओनान ने ऐसा किया, लेकिन वह जानता था कि जो भी बच्चे पैदा होंगे वह क़ानून के मुताबिक़ मेरे बड़े भाई के होंगे। इसलिए जब भी वह तमर से हमबिसतर होता तो नुतफ़ा को ज़मीन पर गिरा देता, क्योंकि वह नहीं चाहता था कि मेरी मारिफ़त मेरे भाई के बच्चे पैदा हों। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","यह बात रब को बुरी लगी, और उसने उसे भी सज़ाए-मौत दी। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","तब यहूदाह ने अपनी बहू तमर से कहा, “अपने बाप के घर वापस चली जाओ और उस वक़्त तक बेवा रहो जब तक मेरा बेटा सेला बड़ा न हो जाए।” उसने यह इसलिए कहा कि उसे डर था कि कहीं सेला भी अपने भाइयों की तरह मर न जाए चुनाँचे तमर अपने मैके चली गई। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","काफ़ी दिनों के बाद यहूदाह की बीवी जो सुअ की बेटी थी मर गई। मातम का वक़्त गुज़र गया तो यहूदाह अपने अदुल्लामी दोस्त हीरा के साथ तिमनत गया जहाँ यहूदाह की भेड़ों की पशम कतरी जा रही थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","तमर को बताया गया, “आपका सुसर अपनी भेड़ों की पशम कतरने के लिए तिमनत जा रहा है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","यह सुनकर तमर ने बेवा के कपड़े उतारकर आम कपड़े पहन लिए। फिर वह अपना मुँह चादर से लपेटकर ऐनीम शहर के दरवाज़े पर बैठ गई जो तिमनत के रास्ते में था। तमर ने यह हरकत इसलिए की कि यहूदाह का बेटा सेला अब बालिग़ हो चुका था तो भी उस की उसके साथ शादी नहीं की गई थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","जब यहूदाह वहाँ से गुज़रा तो उसने उसे देखकर सोचा कि यह कसबी है, क्योंकि उसने अपना मुँह छुपाया हुआ था। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","वह रास्ते से हटकर उसके पास गया और कहा, “ज़रा मुझे अपने हाँ आने दें।” (उसने नहीं पहचाना कि यह मेरी बहू है)। तमर ने कहा, “आप मुझे क्या देंगे?” ");
INSERT INTO urdgvh_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","उसने जवाब दिया, “मैं आपको बकरी का बच्चा भेज दूँगा।” तमर ने कहा, “ठीक है, लेकिन उसे भेजने तक मुझे ज़मानत दें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","उसने पूछा, “मैं आपको क्या दूँ?” तमर ने कहा, “अपनी मुहर और उसे गले में लटकाने की डोरी। वह लाठी भी दें जो आप पकड़े हुए हैं।” चुनाँचे यहूदाह उसे यह चीज़ें देकर उसके साथ हमबिसतर हुआ। नतीजे में तमर उम्मीद से हुई। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","फिर तमर उठकर अपने घर वापस चली गई। उसने अपनी चादर उतारकर दुबारा बेवा के कपड़े पहन लिए। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","यहूदाह ने अपने दोस्त हीरा अदुल्लामी के हाथ बकरी का बच्चा भेज दिया ताकि वह चीज़ें वापस मिल जाएँ जो उसने ज़मानत के तौर पर दी थीं। लेकिन हीरा को पता न चला कि औरत कहाँ है। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","उसने ऐनीम के बाशिंदों से पूछा, “वह कसबी कहाँ है जो यहाँ सड़क पर बैठी थी?” उन्होंने जवाब दिया, “यहाँ ऐसी कोई कसबी नहीं थी।” ");
INSERT INTO urdgvh_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","उसने यहूदाह के पास वापस जाकर कहा, “वह मुझे नहीं मिली बल्कि वहाँ के रहनेवालों ने कहा कि यहाँ कोई ऐसी कसबी थी नहीं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","यहूदाह ने कहा, “फिर वह ज़मानत की चीज़ें अपने पास ही रखे। उसे छोड़ दो वरना लोग हमारा मज़ाक़ उड़ाएँगे। हमने तो पूरी कोशिश की कि उसे बकरी का बच्चा मिल जाए, लेकिन खोज लगाने के बावुजूद आपको पता न चला कि वह कहाँ है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","तीन माह के बाद यहूदाह को इत्तला दी गई, “आपकी बहू तमर ने ज़िना किया है, और अब वह हामिला है।” यहूदाह ने हुक्म दिया, “उसे बाहर लाकर जला दो।” ");
INSERT INTO urdgvh_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","तमर को जलाने के लिए बाहर लाया गया तो उसने अपने सुसर को ख़बर भेज दी, “यह चीज़ें देखें। यह उस आदमी की हैं जिसकी मारिफ़त मैं उम्मीद से हूँ। पता करें कि यह मुहर, उस की डोरी और यह लाठी किसकी हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","यहूदाह ने उन्हें पहचान लिया। उसने कहा, “मैं नहीं बल्कि यह औरत हक़ पर है, क्योंकि मैंने उस की अपने बेटे सेला से शादी नहीं कराई।” लेकिन बाद में यहूदाह कभी भी तमर से हमबिसतर न हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","जब जन्म देने का वक़्त आया तो मालूम हुआ कि जुड़वाँ बच्चे हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","एक बच्चे का हाथ निकला तो दाई ने उसे पकड़कर उसमें सुर्ख़ धागा बाँध दिया और कहा, “यह पहले पैदा हुआ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","लेकिन उसने अपना हाथ वापस खींच लिया, और उसका भाई पहले पैदा हुआ। यह देखकर दाई बोल उठी, “तू किस तरह फूट निकला है!” उसने उसका नाम फ़ारस यानी फूट रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","फिर उसका भाई पैदा हुआ जिसके हाथ में सुर्ख़ धागा बँधा हुआ था। उसका नाम ज़ारह यानी चमक रखा गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","इसमाईलियों ने यूसुफ़ को मिसर ले जाकर बेच दिया था। मिसर के बादशाह के एक आला अफ़सर बनाम फ़ूतीफ़ार ने उसे ख़रीद लिया। वह शाही मुहाफ़िज़ों का कप्तान था। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","रब यूसुफ़ के साथ था। जो भी काम वह करता उसमें कामयाब रहता। वह अपने मिसरी मालिक के घर में रहता था ");
INSERT INTO urdgvh_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","जिसने देखा कि रब यूसुफ़ के साथ है और उसे हर काम में कामयाबी देता है। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","चुनाँचे यूसुफ़ को मालिक की ख़ास मेहरबानी हासिल हुई, और फ़ूतीफ़ार ने उसे अपना ज़ाती नौकर बना लिया। उसने उसे अपने घराने के इंतज़ाम पर मुक़र्रर किया और अपनी पूरी मिलकियत उसके सुपुर्द कर दी। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","जिस वक़्त से फ़ूतीफ़ार ने अपने घराने का इंतज़ाम और पूरी मिलकियत यूसुफ़ के सुपुर्द की उस वक़्त से रब ने फ़ूतीफ़ार को यूसुफ़ के सबब से बरकत दी। उस की बरकत फ़ूतीफ़ार की हर चीज़ पर थी, ख़ाह घर में थी या खेत में। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","फ़ूतीफ़ार ने अपनी हर चीज़ यूसुफ़ के हाथ में छोड़ दी। और चूँकि यूसुफ़ सब कुछ अच्छी तरह चलाता था इसलिए फ़ूतीफ़ार को खाना खाने के सिवा किसी भी मामले की फ़िकर नहीं थी। यूसुफ़ निहायत ख़ूबसूरत आदमी था। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","कुछ देर के बाद उसके मालिक की बीवी की आँख उस पर लगी। उसने उससे कहा, “मेरे साथ हमबिसतर हो!” ");
INSERT INTO urdgvh_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","यूसुफ़ इनकार करके कहने लगा, “मेरे मालिक को मेरे सबब से किसी मामले की फ़िकर नहीं है। उन्होंने सब कुछ मेरे सुपुर्द कर दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","घर के इंतज़ाम पर उनका इख़्तियार मेरे इख़्तियार से ज़्यादा नहीं है। आपके सिवा उन्होंने कोई भी चीज़ मुझसे बाज़ नहीं रखी। तो फिर मैं किस तरह इतना ग़लत काम करूँ? मैं किस तरह अल्लाह का गुनाह करूँ?” ");
INSERT INTO urdgvh_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","मालिक की बीवी रोज़ बरोज़ यूसुफ़ के पीछे पड़ी रही कि मेरे साथ हमबिसतर हो। लेकिन वह हमेशा इनकार करता रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","एक दिन वह काम करने के लिए घर में गया। घर में और कोई नौकर नहीं था। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","फ़ूतीफ़ार की बीवी ने यूसुफ़ का लिबास पकड़कर कहा, “मेरे साथ हमबिसतर हो!” यूसुफ़ भागकर बाहर चला गया लेकिन उसका लिबास पीछे औरत के हाथ में ही रह गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","जब मालिक की बीवी ने देखा कि वह अपना लिबास छोड़कर भाग गया है ");
INSERT INTO urdgvh_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","तो उसने घर के नौकरों को बुलाकर कहा, “यह देखो! मेरे मालिक इस इबरानी को हमारे पास ले आए हैं ताकि वह हमें ज़लील करे। वह मेरी इसमतदरी करने के लिए मेरे कमरे में आ गया, लेकिन मैं ऊँची आवाज़ से चीख़ने लगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","जब मैं मदद के लिए ऊँची आवाज़ से चीख़ने लगी तो वह अपना लिबास छोड़कर भाग गया।” ");
INSERT INTO urdgvh_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","उसने मालिक के आने तक यूसुफ़ का लिबास अपने पास रखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","जब वह घर वापस आया तो उसने उसे यही कहानी सुनाई, “यह इबरानी ग़ुलाम जो आप ले आए हैं मेरी तज़लील के लिए मेरे पास आया। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","लेकिन जब मैं मदद के लिए चीख़ने लगी तो वह अपना लिबास छोड़कर भाग गया।” ");
INSERT INTO urdgvh_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","यह सुनकर फ़ूतीफ़ार बड़े ग़ुस्से में आ गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","उसने यूसुफ़ को गिरिफ़्तार करके उस जेल में डाल दिया जहाँ बादशाह के क़ैदी रखे जाते थे। वहीं वह रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","लेकिन रब यूसुफ़ के साथ था। उसने उस पर मेहरबानी की और उसे क़ैदख़ाने के दारोग़े की नज़र में मक़बूल किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","यूसुफ़ यहाँ तक मक़बूल हुआ कि दारोग़े ने तमाम क़ैदियों को उसके सुपुर्द करके उसे पूरा इंतज़ाम चलाने की ज़िम्मादारी दी। ");
INSERT INTO urdgvh_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","दारोग़े को किसी भी मामले की जिसे उसने यूसुफ़ के सुपुर्द किया था फ़िकर न रही, क्योंकि रब यूसुफ़ के साथ था और उसे हर काम में कामयाबी बख़्शी। ");
INSERT INTO urdgvh_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","कुछ देर के बाद यों हुआ कि मिसर के बादशाह के सरदार साक़ी और बेकरी के इंचार्ज ने अपने मालिक का गुनाह किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","फ़िरौन को दोनों अफ़सरों पर ग़ुस्सा आ गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","उसने उन्हें उस क़ैदख़ाने में डाल दिया जो शाही मुहाफ़िज़ों के कप्तान के सुपुर्द था और जिसमें यूसुफ़ था। ");
INSERT INTO urdgvh_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","मुहाफ़िज़ों के कप्तान ने उन्हें यूसुफ़ के हवाले किया ताकि वह उनकी ख़िदमत करे। वहाँ वह काफ़ी देर तक रहे। ");
INSERT INTO urdgvh_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","एक रात बादशाह के सरदार साक़ी और बेकरी के इंचार्ज ने ख़ाब देखा। दोनों का ख़ाब फ़रक़ फ़रक़ था, और उनका मतलब भी फ़रक़ फ़रक़ था। ");
INSERT INTO urdgvh_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","जब यूसुफ़ सुबह के वक़्त उनके पास आया तो वह दबे हुए नज़र आए। ");
INSERT INTO urdgvh_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","उसने उनसे पूछा, “आज आप क्यों इतने परेशान हैं?” ");
INSERT INTO urdgvh_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","उन्होंने जवाब दिया, “हम दोनों ने ख़ाब देखा है, और कोई नहीं जो हमें उनका मतलब बताए।” यूसुफ़ ने कहा, “ख़ाबों की ताबीर तो अल्लाह का काम है। ज़रा मुझे अपने ख़ाब तो सुनाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","सरदार साक़ी ने शुरू किया, “मैंने ख़ाब में अपने सामने अंगूर की बेल देखी। ");
INSERT INTO urdgvh_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","उस की तीन शाख़ें थीं। उसके पत्ते लगे, कोंपलें फूट निकलीं और अंगूर पक गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","मेरे हाथ में बादशाह का प्याला था, और मैंने अंगूरों को तोड़कर यों भींच दिया कि उनका रस बादशाह के प्याले में आ गया। फिर मैंने प्याला बादशाह को पेश किया।” ");
INSERT INTO urdgvh_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","यूसुफ़ ने कहा, “तीन शाख़ों से मुराद तीन दिन हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","तीन दिन के बाद फ़िरौन आपको बहाल कर लेगा। आपको पहली ज़िम्मादारी वापस मिल जाएगी। आप पहले की तरह सरदार साक़ी की हैसियत से बादशाह का प्याला सँभालेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","लेकिन जब आप बहाल हो जाएँ तो मेरा ख़याल करें। मेहरबानी करके बादशाह के सामने मेरा ज़िक्र करें ताकि मैं यहाँ से रिहा हो जाऊँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","क्योंकि मुझे इबरानियों के मुल्क से इग़वा करके यहाँ लाया गया है, और यहाँ भी मुझसे कोई ऐसी ग़लती नहीं हुई कि मुझे इस गढ़े में फेंका जाता।” ");
INSERT INTO urdgvh_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","जब शाही बेकरी के इंचार्ज ने देखा कि सरदार साक़ी के ख़ाब का अच्छा मतलब निकला तो उसने यूसुफ़ से कहा, “मेरा ख़ाब भी सुनें। मैंने सर पर तीन टोकरियाँ उठा रखी थीं जो बेकरी की चीज़ों से भरी हुई थीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","सबसे ऊपरवाली टोकरी में वह तमाम चीज़ें थीं जो बादशाह की मेज़ के लिए बनाई जाती हैं। लेकिन परिंदे आकर उन्हें खा रहे थे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","यूसुफ़ ने कहा, “तीन टोकरियों से मुराद तीन दिन हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","तीन दिन के बाद ही फ़िरौन आपको क़ैदख़ाने से निकालकर दरख़्त से लटका देगा। परिंदे आपकी लाश को खा जाएंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","तीन दिन के बाद बादशाह की सालगिरह थी। उसने अपने तमाम अफ़सरों की ज़ियाफ़त की। इस मौक़े पर उसने सरदार साक़ी और बेकरी के इंचार्ज को जेल से निकालकर अपने हुज़ूर लाने का हुक्म दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","सरदार साक़ी को पहलेवाली ज़िम्मादारी सौंप दी गई, ");
INSERT INTO urdgvh_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","लेकिन बेकरी के इंचार्ज को सज़ाए-मौत देकर दरख़्त से लटका दिया गया। सब कुछ वैसा ही हुआ जैसा यूसुफ़ ने कहा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","लेकिन सरदार साक़ी ने यूसुफ़ का ख़याल न किया बल्कि उसे भूल ही गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","दो साल गुज़र गए कि एक रात बादशाह ने ख़ाब देखा। वह दरियाए-नील के किनारे खड़ा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","अचानक दरिया में से सात ख़ूबसूरत और मोटी गाएँ निकलकर सरकंडों में चरने लगीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","उनके बाद सात और गाएँ निकल आईं। लेकिन वह बदसूरत और दुबली-पतली थीं। वह दरिया के किनारे दूसरी गायों के पास खड़ी होकर ");
INSERT INTO urdgvh_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","पहली सात ख़ूबसूरत और मोटी मोटी गायों को खा गईं। इसके बाद मिसर का बादशाह जाग उठा। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","फिर वह दुबारा सो गया। इस दफ़ा उसने एक और ख़ाब देखा। अनाज के एक पौदे पर सात मोटी मोटी और अच्छी अच्छी बालें लगी थीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","फिर सात और बालें फूट निकलीं जो दुबली-पतली और मशरिक़ी हवा से झुलसी हुई थीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","अनाज की सात दुबली-पतली बालों ने सात मोटी और ख़ूबसूरत बालों को निगल लिया। फिर फ़िरौन जाग उठा तो मालूम हुआ कि मैंने ख़ाब ही देखा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","सुबह हुई तो वह परेशान था, इसलिए उसने मिसर के तमाम जादूगरों और आलिमों को बुलाया। उसने उन्हें अपने ख़ाब सुनाए, लेकिन कोई भी उनकी ताबीर न कर सका। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","फिर सरदार साक़ी ने फ़िरौन से कहा, “आज मुझे अपनी ख़ताएँ याद आती हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","एक दिन फ़िरौन अपने ख़ादिमों से नाराज़ हुए। हुज़ूर ने मुझे और बेकरी के इंचार्ज को क़ैदख़ाने में डलवा दिया जिस पर शाही मुहाफ़िज़ों का कप्तान मुक़र्रर था। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","एक ही रात में हम दोनों ने मुख़्तलिफ़ ख़ाब देखे जिनका मतलब फ़रक़ फ़रक़ था। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","वहाँ जेल में एक इबरानी नौजवान था। वह मुहाफ़िज़ों के कप्तान का ग़ुलाम था। हमने उसे अपने ख़ाब सुनाए तो उसने हमें उनका मतलब बता दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","और जो कुछ भी उसने बताया सब कुछ वैसा ही हुआ। मुझे अपनी ज़िम्मादारी वापस मिल गई जबकि बेकरी के इंचार्ज को सज़ाए-मौत देकर दरख़्त से लटका दिया गया।” ");
INSERT INTO urdgvh_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","यह सुनकर फ़िरौन ने यूसुफ़ को बुलाया, और उसे जल्दी से क़ैदख़ाने से लाया गया। उसने शेव करवाकर अपने कपड़े बदले और सीधे बादशाह के हुज़ूर पहुँचा। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","बादशाह ने कहा, “मैंने ख़ाब देखा है, और यहाँ कोई नहीं जो उस की ताबीर कर सके। लेकिन सुना है कि तू ख़ाब को सुनकर उसका मतलब बता सकता है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","यूसुफ़ ने जवाब दिया, “यह मेरे इख़्तियार में नहीं है। लेकिन अल्लाह ही बादशाह को सलामती का पैग़ाम देगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","फ़िरौन ने यूसुफ़ को अपने ख़ाब सुनाए, “मैं ख़ाब में दरियाए-नील के किनारे खड़ा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","अचानक दरिया में से सात मोटी मोटी और ख़ूबसूरत गाएँ निकलकर सरकंडों में चरने लगीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","इसके बाद सात और गाएँ निकलीं। वह निहायत बदसूरत और दुबली-पतली थीं। मैंने इतनी बदसूरत गाएँ मिसर में कहीं भी नहीं देखीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","दुबली और बदसूरत गाएँ पहली मोटी गायों को खा गईं। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","और निगलने के बाद भी मालूम नहीं होता था कि उन्होंने मोटी गायों को खाया है। वह पहले की तरह बदसूरत ही थीं। इसके बाद मैं जाग उठा। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","फिर मैंने एक और ख़ाब देखा। सात मोटी और अच्छी बालें एक ही पौदे पर लगी थीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","इसके बाद सात और बालें निकलीं जो ख़राब, दुबली-पतली और मशरिक़ी हवा से झुलसी हुई थीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","सात दुबली-पतली बालें सात अच्छी बालों को निगल गईं। मैंने यह सब कुछ अपने जादूगरों को बताया, लेकिन वह इसकी ताबीर न कर सके।” ");
INSERT INTO urdgvh_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","यूसुफ़ ने बादशाह से कहा, “दोनों ख़ाबों का एक ही मतलब है। इनसे अल्लाह ने हुज़ूर पर ज़ाहिर किया है कि वह क्या कुछ करने को है। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","सात अच्छी गायों से मुराद सात साल हैं। इसी तरह सात अच्छी बालों से मुराद भी सात साल हैं। दोनों ख़ाब एक ही बात बयान करते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","जो सात दुबली और बदसूरत गाएँ बाद में निकलें उनसे मुराद सात और साल हैं। यही सात दुबली-पतली और मशरिक़ी हवा से झुलसी हुई बालों का मतलब भी है। वह एक ही बात बयान करती हैं कि सात साल तक काल पड़ेगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","यह वही बात है जो मैंने हुज़ूर से कही कि अल्लाह ने हुज़ूर पर ज़ाहिर किया है कि वह क्या करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","सात साल आएँगे जिनके दौरान मिसर के पूरे मुल्क में कसरत से पैदावार होगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","उसके बाद सात साल काल पड़ेगा। काल इतना शदीद होगा कि लोग भूल जाएंगे कि पहले इतनी कसरत थी। क्योंकि काल मुल्क को तबाह कर देगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","काल की शिद्दत के बाइस अच्छे सालों की कसरत याद ही नहीं रहेगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","हुज़ूर को इसलिए एक ही पैग़ाम दो मुख़्तलिफ़ ख़ाबों की सूरत में मिला कि अल्लाह इसका पक्का इरादा रखता है, और वह जल्द ही इस पर अमल करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","अब बादशाह किसी समझदार और दानिशमंद आदमी को मुल्के-मिसर का इंतज़ाम सौंपें। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","इसके अलावा वह ऐसे आदमी मुक़र्रर करें जो सात अच्छे सालों के दौरान हर फ़सल का पाँचवाँ हिस्सा लें। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","वह उन अच्छे सालों के दौरान ख़ुराक जमा करें। बादशाह उन्हें इख़्तियार दें कि वह शहरों में गोदाम बनाकर अनाज को महफ़ूज़ कर लें। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","यह ख़ुराक काल के उन सात सालों के लिए मख़सूस की जाए जो मिसर में आनेवाले हैं। यों मुल्क तबाह नहीं होगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","यह मनसूबा बादशाह और उसके अफ़सरान को अच्छा लगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","उसने उनसे कहा, “हमें इस काम के लिए यूसुफ़ से ज़्यादा लायक़ आदमी नहीं मिलेगा। उसमें अल्लाह की रूह है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","बादशाह ने यूसुफ़ से कहा, “अल्लाह ने यह सब कुछ तुझ पर ज़ाहिर किया है, इसलिए कोई भी तुझसे ज़्यादा समझदार और दानिशमंद नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","मैं तुझे अपने महल पर मुक़र्रर करता हूँ। मेरी तमाम रिआया तेरे ताबे रहेगी। तेरा इख़्तियार सिर्फ़ मेरे इख़्तियार से कम होगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","अब मैं तुझे पूरे मुल्के-मिसर पर हाकिम मुक़र्रर करता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","बादशाह ने अपनी उँगली से वह अंगूठी उतारी जिससे मुहर लगाता था और उसे यूसुफ़ की उँगली में पहना दिया। उसने उसे कतान का बारीक लिबास पहनाया और उसके गले में सोने का गुलूबंद पहना दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","फिर उसने उसे अपने दूसरे रथ में सवार किया और लोग उसके आगे आगे पुकारते रहे, “घुटने टेको! घुटने टेको!” यों यूसुफ़ पूरे मिसर का हाकिम बना। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","फ़िरौन ने उससे कहा, “मैं तो बादशाह हूँ, लेकिन तेरी इजाज़त के बग़ैर पूरे मुल्क में कोई भी अपना हाथ या पाँव नहीं हिलाएगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","उसने यूसुफ़ का मिसरी नाम साफ़नत-फ़ानेह रखा और ओन के पुजारी फ़ोतीफ़िरा की बेटी आसनत के साथ उस की शादी कराई। यूसुफ़ 30 साल का था जब वह मिसर के बादशाह फ़िरौन की ख़िदमत करने लगा। उसने फ़िरौन के हुज़ूर से निकलकर मिसर का दौरा किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","सात अच्छे सालों के दौरान मुल्क में निहायत अच्छी फ़सलें उगीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","यूसुफ़ ने तमाम ख़ुराक जमा करके शहरों में महफ़ूज़ कर ली। हर शहर में उसने इर्दगिर्द के खेतों की पैदावार महफ़ूज़ रखी। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","जमाशुदा अनाज समुंदर की रेत की मानिंद बकसरत था। इतना अनाज था कि यूसुफ़ ने आख़िरकार उस की पैमाइश करना छोड़ दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","काल से पहले यूसुफ़ और आसनत के दो बेटे पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","उसने पहले का नाम मनस्सी यानी ‘जो भुला देता है’ रखा। क्योंकि उसने कहा, “अल्लाह ने मेरी मुसीबत और मेरे बाप का घराना मेरी याददाश्त से निकाल दिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","दूसरे का नाम उसने इफ़राईम यानी ‘दुगना फलदार’ रखा। क्योंकि उसने कहा, “अल्लाह ने मुझे मेरी मुसीबत के मुल्क में फलने फूलने दिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","सात अच्छे साल जिनमें कसरत की फ़सलें उगीं गुज़र गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","फिर काल के सात साल शुरू हुए जिस तरह यूसुफ़ ने कहा था। तमाम दीगर ममालिक में भी काल पड़ गया, लेकिन मिसर में वाफ़िर ख़ुराक पाई जाती थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","जब काल ने तमाम मिसर में ज़ोर पकड़ा तो लोग चीख़कर खाने के लिए बादशाह से मिन्नत करने लगे। तब फ़िरौन ने उनसे कहा, “यूसुफ़ के पास जाओ। जो कुछ वह तुम्हें बताएगा वही करो।” ");
INSERT INTO urdgvh_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","जब काल पूरी दुनिया में फैल गया तो यूसुफ़ ने अनाज के गोदाम खोलकर मिसरियों को अनाज बेच दिया। क्योंकि काल के बाइस मुल्क के हालात बहुत ख़राब हो गए थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","तमाम ममालिक से भी लोग अनाज ख़रीदने के लिए यूसुफ़ के पास आए, क्योंकि पूरी दुनिया सख़्त काल की गिरिफ़्त में थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","जब याक़ूब को मालूम हुआ कि मिसर में अनाज है तो उसने अपने बेटों से कहा, “तुम क्यों एक दूसरे का मुँह तकते हो? ");
INSERT INTO urdgvh_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","सुना है कि मिसर में अनाज है। वहाँ जाकर हमारे लिए कुछ ख़रीद लाओ ताकि हम भूके न मरें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","तब यूसुफ़ के दस भाई अनाज ख़रीदने के लिए मिसर गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","लेकिन याक़ूब ने यूसुफ़ के सगे भाई बिनयमीन को साथ न भेजा, क्योंकि उसने कहा, “ऐसा न हो कि उसे जानी नुक़सान पहुँचे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","यों याक़ूब के बेटे बहुत सारे और लोगों के साथ मिसर गए, क्योंकि मुल्के-कनान भी काल की गिरिफ़्त में था। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","यूसुफ़ मिसर के हाकिम की हैसियत से लोगों को अनाज बेचता था, इसलिए उसके भाई आकर उसके सामने मुँह के बल झुक गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","जब यूसुफ़ ने अपने भाइयों को देखा तो उसने उन्हें पहचान लिया लेकिन ऐसा किया जैसा उनसे नावाक़िफ़ हो और सख़्ती से उनसे बात की, “तुम कहाँ से आए हो?” उन्होंने जवाब दिया, “हम मुल्के-कनान से अनाज ख़रीदने के लिए आए हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","गो यूसुफ़ ने अपने भाइयों को पहचान लिया, लेकिन उन्होंने उसे न पहचाना। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","उसे वह ख़ाब याद आए जो उसने उनके बारे में देखे थे। उसने कहा, “तुम जासूस हो। तुम यह देखने आए हो कि हमारा मुल्क किन किन जगहों पर ग़ैरमहफ़ूज़ है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","उन्होंने कहा, “जनाब, हरगिज़ नहीं। आपके ग़ुलाम ग़ल्ला ख़रीदने आए हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","हम सब एक ही मर्द के बेटे हैं। आपके ख़ादिम शरीफ़ लोग हैं, जासूस नहीं हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","लेकिन यूसुफ़ ने इसरार किया, “नहीं, तुम देखने आए हो कि हमारा मुल्क किन किन जगहों पर ग़ैरमहफ़ूज़ है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","उन्होंने अर्ज़ की, “आपके ख़ादिम कुल बारह भाई हैं। हम एक ही आदमी के बेटे हैं जो कनान में रहता है। सबसे छोटा भाई इस वक़्त हमारे बाप के पास है जबकि एक मर गया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","लेकिन यूसुफ़ ने अपना इलज़ाम दोहराया, “ऐसा ही है जैसा मैंने कहा है कि तुम जासूस हो। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","मैं तुम्हारी बातें जाँच लूँगा। फ़िरौन की हयात की क़सम, पहले तुम्हारा सबसे छोटा भाई आए, वरना तुम इस जगह से कभी नहीं जा सकोगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","एक भाई को उसे लाने के लिए भेज दो। बाक़ी सब यहाँ गिरिफ़्तार रहेंगे। फिर पता चलेगा कि तुम्हारी बातें सच हैं कि नहीं। अगर नहीं तो फ़िरौन की हयात की क़सम, इसका मतलब यह होगा कि तुम जासूस हो।” ");
INSERT INTO urdgvh_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","यह कहकर यूसुफ़ ने उन्हें तीन दिन के लिए क़ैदख़ाने में डाल दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","तीसरे दिन उसने उनसे कहा, “मैं अल्लाह का ख़ौफ़ मानता हूँ, इसलिए तुमको एक शर्त पर जीता छोड़ूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","अगर तुम वाक़ई शरीफ़ लोग हो तो ऐसा करो कि तुममें से एक यहाँ क़ैदख़ाने में रहे जबकि बाक़ी सब अनाज लेकर अपने भूके घरवालों के पास वापस जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","लेकिन लाज़िम है कि तुम अपने सबसे छोटे भाई को मेरे पास ले आओ। सिर्फ़ इससे तुम्हारी बातें सच साबित होंगी और तुम मौत से बच जाओगे।” यूसुफ़ के भाई राज़ी हो गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","वह आपस में कहने लगे, “बेशक यह हमारे अपने भाई पर ज़ुल्म की सज़ा है। जब वह इल्तिजा कर रहा था कि मुझ पर रहम करें तो हमने उस की बड़ी मुसीबत देखकर भी उस की न सुनी। इसलिए यह मुसीबत हम पर आ गई है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","और रूबिन ने कहा, “क्या मैंने नहीं कहा था कि लड़के पर ज़ुल्म मत करो, लेकिन तुमने मेरी एक न मानी। अब उस की मौत का हिसाब-किताब किया जा रहा है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","उन्हें मालूम नहीं था कि यूसुफ़ हमारी बातें समझ सकता है, क्योंकि वह मुतरजिम की मारिफ़त उनसे बात करता था। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","यह बातें सुनकर वह उन्हें छोड़कर रोने लगा। फिर वह सँभलकर वापस आया। उसने शमौन को चुनकर उसे उनके सामने ही बाँध लिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","यूसुफ़ ने हुक्म दिया कि मुलाज़िम उनकी बोरियाँ अनाज से भरकर हर एक भाई के पैसे उस की बोरी में वापस रख दें और उन्हें सफ़र के लिए खाना भी दें। उन्होंने ऐसा ही किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","फिर यूसुफ़ के भाई अपने गधों पर अनाज लादकर रवाना हो गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","जब वह रात के लिए किसी जगह पर ठहरे तो एक भाई ने अपने गधे के लिए चारा निकालने की ग़रज़ से अपनी बोरी खोली तो देखा कि बोरी के मुँह में उसके पैसे पड़े हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","उसने अपने भाइयों से कहा, “मेरे पैसे वापस कर दिए गए हैं! वह मेरी बोरी में हैं।” यह देखकर उनके होश उड़ गए। काँपते हुए वह एक दूसरे को देखने और कहने लगे, “यह क्या है जो अल्लाह ने हमारे साथ किया है?” ");
INSERT INTO urdgvh_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","मुल्के-कनान में अपने बाप के पास पहुँचकर उन्होंने उसे सब कुछ सुनाया जो उनके साथ हुआ था। उन्होंने कहा, ");
INSERT INTO urdgvh_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“उस मुल्क के मालिक ने बड़ी सख़्ती से हमारे साथ बात की। उसने हमें जासूस क़रार दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","लेकिन हमने उससे कहा, ‘हम जासूस नहीं बल्कि शरीफ़ लोग हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","हम बारह भाई हैं, एक ही बाप के बेटे। एक तो मर गया जबकि सबसे छोटा भाई इस वक़्त कनान में बाप के पास है।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","फिर उस मुल्क के मालिक ने हमसे कहा, ‘इससे मुझे पता चलेगा कि तुम शरीफ़ लोग हो कि एक भाई को मेरे पास छोड़ दो और अपने भूके घरवालों के लिए ख़ुराक लेकर चले जाओ। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","लेकिन अपने सबसे छोटे भाई को मेरे पास ले आओ ताकि मुझे मालूम हो जाए कि तुम जासूस नहीं बल्कि शरीफ़ लोग हो। फिर मैं तुमको तुम्हारा भाई वापस कर दूँगा और तुम इस मुल्क में आज़ादी से तिजारत कर सकोगे’।” ");
INSERT INTO urdgvh_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","उन्होंने अपनी बोरियों से अनाज निकाल दिया तो देखा कि हर एक की बोरी में उसके पैसों की थैली रखी हुई है। यह पैसे देखकर वह ख़ुद और उनका बाप डर गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","उनके बाप ने उनसे कहा, “तुमने मुझे मेरे बच्चों से महरूम कर दिया है। यूसुफ़ नहीं रहा, शमौन भी नहीं रहा और अब तुम बिनयमीन को भी मुझसे छीनना चाहते हो। सब कुछ मेरे ख़िलाफ़ है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","फिर रूबिन बोल उठा, “अगर मैं उसे सलामती से आपके पास वापस न पहुँचाऊँ तो आप मेरे दो बेटों को सज़ाए-मौत दे सकते हैं। उसे मेरे सुपुर्द करें तो मैं उसे वापस ले आऊँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","लेकिन याक़ूब ने कहा, “मेरा बेटा तुम्हारे साथ जाने का नहीं। क्योंकि उसका भाई मर गया है और वह अकेला ही रह गया है। अगर उसको रास्ते में जानी नुक़सान पहुँचे तो तुम मुझ बूढ़े को ग़म के मारे पाताल में पहुँचाओगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","काल ने ज़ोर पकड़ा। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","जब मिसर से लाया गया अनाज ख़त्म हो गया तो याक़ूब ने कहा, “अब वापस जाकर हमारे लिए कुछ और ग़ल्ला ख़रीद लाओ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","लेकिन यहूदाह ने कहा, “उस मर्द ने सख़्ती से कहा था, ‘तुम सिर्फ़ इस सूरत में मेरे पास आ सकते हो कि तुम्हारा भाई साथ हो।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","अगर आप हमारे भाई को साथ भेजें तो फिर हम जाकर आपके लिए ग़ल्ला ख़रीदेंगे ");
INSERT INTO urdgvh_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","वरना नहीं। क्योंकि उस आदमी ने कहा था कि हम सिर्फ़ इस सूरत में उसके पास आ सकते हैं कि हमारा भाई साथ हो।” ");
INSERT INTO urdgvh_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","याक़ूब ने कहा, “तुमने उसे क्यों बताया कि हमारा एक और भाई भी है? इससे तुमने मुझे बड़ी मुसीबत में डाल दिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","उन्होंने जवाब दिया, “वह आदमी हमारे और हमारे ख़ानदान के बारे में पूछता रहा, ‘क्या तुम्हारा बाप अब तक ज़िंदा है? क्या तुम्हारा कोई और भाई है?’ फिर हमें जवाब देना पड़ा। हमें क्या पता था कि वह हमें अपने भाई को साथ लाने को कहेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","फिर यहूदाह ने बाप से कहा, “लड़के को मेरे साथ भेज दें तो हम अभी रवाना हो जाएंगे। वरना आप, हमारे बच्चे बल्कि हम सब भूकों मर जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","मैं ख़ुद उसका ज़ामिन हूँगा। आप मुझे उस की जान का ज़िम्मादार ठहरा सकते हैं। अगर मैं उसे सलामती से वापस न पहुँचाऊँ तो फिर मैं ज़िंदगी के आख़िर तक क़ुसूरवार ठहरूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","जितनी देर तक हम झिजकते रहे हैं उतनी देर में तो हम दो दफ़ा मिसर जाकर वापस आ सकते थे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","तब उनके बाप इसराईल ने कहा, “अगर और कोई सूरत नहीं तो इस मुल्क की बेहतरीन पैदावार में से कुछ तोह्फ़े के तौर पर लेकर उस आदमी को दे दो यानी कुछ बलसान, शहद, लादन, मुर, पिस्ता और बादाम। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","अपने साथ दुगनी रक़म लेकर जाओ, क्योंकि तुम्हें वह पैसे वापस करने हैं जो तुम्हारी बोरियों में रखे गए थे। शायद किसी से ग़लती हुई हो। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","अपने भाई को लेकर सीधे वापस पहुँचना। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","अल्लाह क़ादिरे-मुतलक़ करे कि यह आदमी तुम पर रहम करके बिनयमीन और तुम्हारे दूसरे भाई को वापस भेजे। जहाँ तक मेरा ताल्लुक़ है, अगर मुझे अपने बच्चों से महरूम होना है तो ऐसा ही हो।” ");
INSERT INTO urdgvh_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","चुनाँचे वह तोह्फ़े, दुगनी रक़म और बिनयमीन को साथ लेकर चल पड़े। मिसर पहुँचकर वह यूसुफ़ के सामने हाज़िर हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","जब यूसुफ़ ने बिनयमीन को उनके साथ देखा तो उसने अपने घर पर मुक़र्रर मुलाज़िम से कहा, “इन आदमियों को मेरे घर ले जाओ ताकि वह दोपहर का खाना मेरे साथ खाएँ। जानवर को ज़बह करके खाना तैयार करो।” ");
INSERT INTO urdgvh_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","मुलाज़िम ने ऐसा ही किया और भाइयों को यूसुफ़ के घर ले गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","जब उन्हें उसके घर पहुँचाया जा रहा था तो वह डरकर सोचने लगे, “हमें उन पैसों के सबब से यहाँ लाया जा रहा है जो पहली दफ़ा हमारी बोरियों में वापस किए गए थे। वह हम पर अचानक हमला करके हमारे गधे छीन लेंगे और हमें ग़ुलाम बना लेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","इसलिए घर के दरवाज़े पर पहुँचकर उन्होंने घर पर मुक़र्रर मुलाज़िम से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“जनाबे-आली, हमारी बात सुन लीजिए। इससे पहले हम अनाज ख़रीदने के लिए यहाँ आए थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","लेकिन जब हम यहाँ से रवाना होकर रास्ते में रात के लिए ठहरे तो हमने अपनी बोरियाँ खोलकर देखा कि हर बोरी के मुँह में हमारे पैसों की पूरी रक़म पड़ी है। हम यह पैसे वापस ले आए हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","नीज़, हम मज़ीद ख़ुराक ख़रीदने के लिए और पैसे ले आए हैं। ख़ुदा जाने किसने हमारे यह पैसे हमारी बोरियों में रख दिए।” ");
INSERT INTO urdgvh_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","मुलाज़िम ने कहा, “फ़िकर न करें। मत डरें। आपके और आपके बाप के ख़ुदा ने आपके लिए आपकी बोरियों में यह ख़ज़ाना रखा होगा। बहरहाल मुझे आपके पैसे मिल गए हैं।” मुलाज़िम शमौन को उनके पास बाहर ले आया। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","फिर उसने भाइयों को यूसुफ़ के घर में ले जाकर उन्हें पाँव धोने के लिए पानी और गधों को चारा दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","उन्होंने अपने तोह्फ़े तैयार रखे, क्योंकि उन्हें बताया गया, “यूसुफ़ दोपहर का खाना आपके साथ ही खाएगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","जब यूसुफ़ घर पहुँचा तो वह अपने तोह्फ़े लेकर उसके सामने आए और मुँह के बल झुक गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","उसने उनसे ख़ैरियत दरियाफ़्त की और फिर कहा, “तुमने अपने बूढ़े बाप का ज़िक्र किया। क्या वह ठीक हैं? क्या वह अब तक ज़िंदा हैं?” ");
INSERT INTO urdgvh_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","उन्होंने जवाब दिया, “जी, आपके ख़ादिम हमारे बाप अब तक ज़िंदा हैं।” वह दुबारा मुँह के बल झुक गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","जब यूसुफ़ ने अपने सगे भाई बिनयमीन को देखा तो उसने कहा, “क्या यह तुम्हारा सबसे छोटा भाई है जिसका तुमने ज़िक्र किया था? बेटा, अल्लाह की नज़रे-करम तुम पर हो।” ");
INSERT INTO urdgvh_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","यूसुफ़ अपने भाई को देखकर इतना मुतअस्सिर हुआ कि वह रोने को था, इसलिए वह जल्दी से वहाँ से निकलकर अपने सोने के कमरे में गया और रो पड़ा। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","फिर वह अपना मुँह धोकर वापस आया। अपने आप पर क़ाबू पाकर उसने हुक्म दिया कि नौकर खाना ले आएँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","नौकरों ने यूसुफ़ के लिए खाने का अलग इंतज़ाम किया और भाइयों के लिए अलग। मिसरियों के लिए भी खाने का अलग इंतज़ाम था, क्योंकि इबरानियों के साथ खाना खाना उनकी नज़र में क़ाबिले-नफ़रत था। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","भाइयों को उनकी उम्र की तरतीब के मुताबिक़ यूसुफ़ के सामने बिठाया गया। यह देखकर भाई निहायत हैरान हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","नौकरों ने उन्हें यूसुफ़ की मेज़ पर से खाना लेकर खिलाया। लेकिन बिनयमीन को दूसरों की निसबत पाँच गुना ज़्यादा मिला। यों उन्होंने यूसुफ़ के साथ जी भरकर खाया और पिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","यूसुफ़ ने घर पर मुक़र्रर मुलाज़िम को हुक्म दिया, “उन मर्दों की बोरियाँ ख़ुराक से इतनी भर देना जितनी वह उठाकर ले जा सकें। हर एक के पैसे उस की अपनी बोरी के मुँह में रख देना। ");
INSERT INTO urdgvh_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","सबसे छोटे भाई की बोरी में न सिर्फ़ पैसे बल्कि मेरे चाँदी के प्याले को भी रख देना।” मुलाज़िम ने ऐसा ही किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","अगली सुबह जब पौ फटने लगी तो भाइयों को उनके गधों समेत रुख़सत कर दिया गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","वह अभी शहर से निकलकर दूर नहीं गए थे कि यूसुफ़ ने अपने घर पर मुक़र्रर मुलाज़िम से कहा, “जल्दी करो। उन आदमियों का ताक़्क़ुब करो। उनके पास पहुँचकर यह पूछना, ‘आपने हमारी भलाई के जवाब में ग़लत काम क्यों किया है? ");
INSERT INTO urdgvh_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","आपने मेरे मालिक का चाँदी का प्याला क्यों चुराया है? उससे वह न सिर्फ़ पीते हैं बल्कि उसे ग़ैबदानी के लिए भी इस्तेमाल करते हैं। आप एक निहायत संगीन जुर्म के मुरतकिब हुए हैं’।” ");
INSERT INTO urdgvh_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","जब मुलाज़िम भाइयों के पास पहुँचा तो उसने उनसे यही बातें कीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","जवाब में उन्होंने कहा, “हमारे मालिक ऐसी बातें क्यों करते हैं? कभी नहीं हो सकता कि आपके ख़ादिम ऐसा करें। ");
INSERT INTO urdgvh_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","आप तो जानते हैं कि हम मुल्के-कनान से वह पैसे वापस ले आए जो हमारी बोरियों में थे। तो फिर हम क्यों आपके मालिक के घर से चाँदी या सोना चुराएँगे? ");
INSERT INTO urdgvh_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","अगर वह आपके ख़ादिमों में से किसी के पास मिल जाए तो उसे मार डाला जाए और बाक़ी सब आपके ग़ुलाम बनें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","मुलाज़िम ने कहा, “ठीक है ऐसा ही होगा। लेकिन सिर्फ़ वही मेरा ग़ुलाम बनेगा जिसने प्याला चुराया है। बाक़ी सब आज़ाद हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","उन्होंने जल्दी से अपनी बोरियाँ उतारकर ज़मीन पर रख दीं। हर एक ने अपनी बोरी खोल दी। ");
INSERT INTO urdgvh_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","मुलाज़िम बोरियों की तलाशी लेने लगा। वह बड़े भाई से शुरू करके आख़िरकार सबसे छोटे भाई तक पहुँच गया। और वहाँ बिनयमीन की बोरी में से प्याला निकला। ");
INSERT INTO urdgvh_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","भाइयों ने यह देखकर परेशानी में अपने लिबास फाड़ लिए। वह अपने गधों को दुबारा लादकर शहर वापस आ गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","जब यहूदाह और उसके भाई यूसुफ़ के घर पहुँचे तो वह अभी वहीं था। वह उसके सामने मुँह के बल गिर गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","यूसुफ़ ने कहा, “यह तुमने क्या किया है? क्या तुम नहीं जानते कि मुझ जैसा आदमी ग़ैब का इल्म रखता है?” ");
INSERT INTO urdgvh_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","यहूदाह ने कहा, “जनाबे-आली, हम क्या कहें? अब हम अपने दिफ़ा में क्या कहें? अल्लाह ही ने हमें क़ुसूरवार ठहराया है। अब हम सब आपके ग़ुलाम हैं, न सिर्फ़ वह जिसके पास से प्याला मिल गया।” ");
INSERT INTO urdgvh_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","यूसुफ़ ने कहा, “अल्लाह न करे कि मैं ऐसा करूँ, बल्कि सिर्फ़ वही मेरा ग़ुलाम होगा जिसके पास प्याला था। बाक़ी सब सलामती से अपने बाप के पास वापस चले जाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","लेकिन यहूदाह ने यूसुफ़ के क़रीब आकर कहा, “मेरे मालिक, मेहरबानी करके अपने बंदे को एक बात करने की इजाज़त दें। मुझ पर ग़ुस्सा न करें अगरचे आप मिसर के बादशाह जैसे हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","जनाबे-आली, आपने हमसे पूछा, ‘क्या तुम्हारा बाप या कोई और भाई है?’ ");
INSERT INTO urdgvh_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","हमने जवाब दिया, ‘हमारा बाप है। वह बूढ़ा है। हमारा एक छोटा भाई भी है जो उस वक़्त पैदा हुआ जब हमारा बाप उम्ररसीदा था। उस लड़के का भाई मर चुका है। उस की माँ के सिर्फ़ यह दो बेटे पैदा हुए। अब वह अकेला ही रह गया है। उसका बाप उसे शिद्दत से प्यार करता है।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","जनाबे-आली, आपने हमें बताया, ‘उसे यहाँ ले आओ ताकि मैं ख़ुद उसे देख सकूँ।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","हमने जवाब दिया, ‘यह लड़का अपने बाप को छोड़ नहीं सकता, वरना उसका बाप मर जाएगा।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","फिर आपने कहा, ‘तुम सिर्फ़ इस सूरत में मेरे पास आ सकोगे कि तुम्हारा सबसे छोटा भाई तुम्हारे साथ हो।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","जब हम अपने बाप के पास वापस पहुँचे तो हमने उन्हें सब कुछ बताया जो आपने कहा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","फिर उन्होंने हमसे कहा, ‘मिसर लौटकर कुछ ग़ल्ला ख़रीद लाओ।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","हमने जवाब दिया, ‘हम जा नहीं सकते। हम सिर्फ़ इस सूरत में उस मर्द के पास जा सकते हैं कि हमारा सबसे छोटा भाई साथ हो। हम तब ही जा सकते हैं जब वह भी हमारे साथ चले।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","हमारे बाप ने हमसे कहा, ‘तुम जानते हो कि मेरी बीवी राख़िल से मेरे दो बेटे पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","पहला मुझे छोड़ चुका है। किसी जंगली जानवर ने उसे फाड़ खाया होगा, क्योंकि उसी वक़्त से मैंने उसे नहीं देखा। ");
INSERT INTO urdgvh_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","अगर इसको भी मुझसे ले जाने की वजह से जानी नुक़सान पहुँचे तो तुम मुझ बूढ़े को ग़म के मारे पाताल में पहुँचाओगे’।” ");
INSERT INTO urdgvh_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","यहूदाह ने अपनी बात जारी रखी, “जनाबे-आली, अब अगर मैं अपने बाप के पास जाऊँ और वह देखें कि लड़का मेरे साथ नहीं है तो वह दम तोड़ देंगे। उनकी ज़िंदगी इस क़दर लड़के की ज़िंदगी पर मुनहसिर है और वह इतने बूढ़े हैं कि हम ऐसी हरकत से उन्हें क़ब्र तक पहुँचा देंगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","न सिर्फ़ यह बल्कि मैंने बाप से कहा, ‘मैं ख़ुद इसका ज़ामिन हूँगा। अगर मैं इसे सलामती से वापस न पहुँचाऊँ तो फिर मैं ज़िंदगी के आख़िर तक क़ुसूरवार ठहरूँगा।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","अब अपने ख़ादिम की गुज़ारिश सुनें। मैं यहाँ रहकर इस लड़के की जगह ग़ुलाम बन जाता हूँ, और वह दूसरे भाइयों के साथ वापस चला जाए। ");
INSERT INTO urdgvh_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","अगर लड़का मेरे साथ न हुआ तो मैं किस तरह अपने बाप को मुँह दिखा सकता हूँ? मैं बरदाश्त नहीं कर सकूँगा कि वह इस मुसीबत में मुब्तला हो जाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","यह सुनकर यूसुफ़ अपने आप पर क़ाबू न रख सका। उसने ऊँची आवाज़ से हुक्म दिया कि तमाम मुलाज़िम कमरे से निकल जाएँ। कोई और शख़्स कमरे में नहीं था जब यूसुफ़ ने अपने भाइयों को बताया कि वह कौन है। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","वह इतने ज़ोर से रो पड़ा कि मिसरियों ने उस की आवाज़ सुनी और फ़िरौन के घराने को पता चल गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","यूसुफ़ ने अपने भाइयों से कहा, “मैं यूसुफ़ हूँ। क्या मेरा बाप अब तक ज़िंदा है?” लेकिन उसके भाई यह सुनकर इतने घबरा गए कि वह जवाब न दे सके। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","फिर यूसुफ़ ने कहा, “मेरे क़रीब आओ।” वह क़रीब आए तो उसने कहा, “मैं तुम्हारा भाई यूसुफ़ हूँ जिसे तुमने बोलकर मिसर भिजवाया। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","अब मेरी बात सुनो। न घबराओ और न अपने आपको इलज़ाम दो कि हमने यूसुफ़ को बेच दिया। असल में अल्लाह ने ख़ुद मुझे तुम्हारे आगे यहाँ भेज दिया ताकि हम सब बचे रहें। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","यह काल का दूसरा साल है। पाँच और साल के दौरान न हल चलेगा, न फ़सल कटेगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","अल्लाह ने मुझे तुम्हारे आगे भेजा ताकि दुनिया में तुम्हारा एक बचा-खुचा हिस्सा महफ़ूज़ रहे और तुम्हारी जान एक बड़ी मख़लसी की मारिफ़त छूट जाए। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","चुनाँचे तुमने मुझे यहाँ नहीं भेजा बल्कि अल्लाह ने। उसने मुझे फ़िरौन का बाप, उसके पूरे घराने का मालिक और मिसर का हाकिम बना दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","अब जल्दी से मेरे बाप के पास वापस जाकर उनसे कहो, ‘आपका बेटा यूसुफ़ आपको इत्तला देता है कि अल्लाह ने मुझे मिसर का मालिक बना दिया है। मेरे पास आ जाएँ, देर न करें। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","आप जुशन के इलाक़े में रह सकते हैं। वहाँ आप मेरे क़रीब होंगे, आप, आपकी आलो-औलाद, गाय-बैल, भेड़-बकरियाँ और जो कुछ भी आपका है। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","वहाँ मैं आपकी ज़रूरियात पूरी करूँगा, क्योंकि काल को अभी पाँच साल और लगेंगे। वरना आप, आपके घरवाले और जो भी आपके हैं बदहाल हो जाएंगे।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","तुम ख़ुद और मेरा भाई बिनयमीन देख सकते हो कि मैं यूसुफ़ ही हूँ जो तुम्हारे साथ बात कर रहा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","मेरे बाप को मिसर में मेरे असरो-रसूख़ के बारे में इत्तला दो। उन्हें सब कुछ बताओ जो तुमने देखा है। फिर जल्द ही मेरे बाप को यहाँ ले आओ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","यह कहकर वह अपने भाई बिनयमीन को गले लगाकर रो पड़ा। बिनयमीन भी उसके गले लगकर रोने लगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","फिर यूसुफ़ ने रोते हुए अपने हर एक भाई को बोसा दिया। इसके बाद उसके भाई उसके साथ बातें करने लगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","जब यह ख़बर बादशाह के महल तक पहुँची कि यूसुफ़ के भाई आए हैं तो फ़िरौन और उसके तमाम अफ़सरान ख़ुश हुए। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","उसने यूसुफ़ से कहा, “अपने भाइयों को बता कि अपने जानवरों पर ग़ल्ला लादकर मुल्के-कनान वापस चले जाओ। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","वहाँ अपने बाप और ख़ानदानों को लेकर मेरे पास आ जाओ। मैं तुमको मिसर की सबसे अच्छी ज़मीन दे दूँगा, और तुम इस मुल्क की बेहतरीन पैदावार खा सकोगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","उन्हें यह हिदायत भी दे कि अपने बाल-बच्चों के लिए मिसर से गाड़ियाँ ले जाओ और अपने बाप को भी बिठाकर यहाँ ले आओ। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","अपने माल की ज़्यादा फ़िकर न करो, क्योंकि तुम्हें मुल्के-मिसर का बेहतरीन माल मिलेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","यूसुफ़ के भाइयों ने ऐसा ही किया। यूसुफ़ ने उन्हें बादशाह के हुक्म के मुताबिक़ गाड़ियाँ और सफ़र के लिए ख़ुराक दी। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","उसने हर एक भाई को कपड़ों का एक जोड़ा भी दिया। लेकिन बिनयमीन को उसने चाँदी के 300 सिक्के और पाँच जोड़े दिए। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","उसने अपने बाप को दस गधे भिजवा दिए जो मिसर के बेहतरीन माल से लदे हुए थे और दस गधियाँ जो अनाज, रोटी और बाप के सफ़र के लिए खाने से लदी हुई थीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","यों उसने अपने भाइयों को रुख़सत करके कहा, “रास्ते में झगड़ा न करना।” ");
INSERT INTO urdgvh_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","वह मिसर से रवाना होकर मुल्के-कनान में अपने बाप के पास पहुँचे। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","उन्होंने उससे कहा, “यूसुफ़ ज़िंदा है! वह पूरे मिसर का हाकिम है।” लेकिन याक़ूब हक्का-बक्का रह गया, क्योंकि उसे यक़ीन न आया। ");
INSERT INTO urdgvh_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ताहम उन्होंने उसे सब कुछ बताया जो यूसुफ़ ने उनसे कहा था, और उसने ख़ुद वह गाड़ियाँ देखीं जो यूसुफ़ ने उसे मिसर ले जाने के लिए भिजवा दी थीं। फिर याक़ूब की जान में जान आ गई, ");
INSERT INTO urdgvh_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","और उसने कहा, “मेरा बेटा यूसुफ़ ज़िंदा है! यही काफ़ी है। मरने से पहले मैं जाकर उससे मिलूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","याक़ूब सब कुछ लेकर रवाना हुआ और बैर-सबा पहुँचा। वहाँ उसने अपने बाप इसहाक़ के ख़ुदा के हुज़ूर क़ुरबानियाँ चढ़ाईं। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","रात को अल्लाह रोया में उससे हमकलाम हुआ। उसने कहा, “याक़ूब, याक़ूब!” याक़ूब ने जवाब दिया, “जी, मैं हाज़िर हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","अल्लाह ने कहा, “मैं अल्लाह हूँ, तेरे बाप इसहाक़ का ख़ुदा। मिसर जाने से मत डर, क्योंकि वहाँ मैं तुझसे एक बड़ी क़ौम बनाऊँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","मैं तेरे साथ मिसर जाऊँगा और तुझे इस मुल्क में वापस भी ले आऊँगा। जब तू मरेगा तो यूसुफ़ ख़ुद तेरी आँखें बंद करेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","इसके बाद याक़ूब बैर-सबा से रवाना हुआ। उसके बेटों ने उसे और अपने बाल-बच्चों को उन गाड़ियों में बिठा दिया जो मिसर के बादशाह ने भिजवाई थीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","यों याक़ूब और उस की तमाम औलाद अपने मवेशी और कनान में हासिल किया हुआ माल लेकर मिसर चले गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","याक़ूब के बेटे-बेटियाँ, पोते-पोतियाँ और बाक़ी औलाद सब साथ गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","इसराईल की औलाद के नाम जो मिसर चली गई यह हैं : याक़ूब के पहलौठे रूबिन ");
INSERT INTO urdgvh_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","के बेटे हनूक, फ़ल्लू, हसरोन और करमी थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","शमौन के बेटे यमुएल, यमीन, उहद, यकीन, सुहर और साऊल थे (साऊल कनानी औरत का बच्चा था)। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लावी के बेटे जैरसोन, क़िहात और मिरारी थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहूदाह के बेटे एर, ओनान, सेला, फ़ारस और ज़ारह थे (एर और ओनान कनान में मर चुके थे)। फ़ारस के दो बेटे हसरोन और हमूल थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इशकार के बेटे तोला, फ़ुव्वा, योब और सिमरोन थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ज़बूलून के बेटे सरद, ऐलोन और यहलियेल थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","इन बेटों की माँ लियाह थी, और वह मसोपुतामिया में पैदा हुए। इनके अलावा दीना उस की बेटी थी। कुल 33 मर्द लियाह की औलाद थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","जद के बेटे सिफ़ियान, हज्जी, सूनी, इसबून, एरी, अरूदी और अरेली थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","आशर के बेटे यिमना, इसवाह, इसवी और बरिया थे। आशर की बेटी सिरह थी, और बरिया के दो बेटे थे, हिबर और मलकियेल। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","कुल 16 अफ़राद ज़िलफ़ा की औलाद थे जिसे लाबन ने अपनी बेटी लियाह को दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","राख़िल के बेटे यूसुफ़ और बिनयमीन थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","यूसुफ़ के दो बेटे मनस्सी और इफ़राईम मिसर में पैदा हुए। उनकी माँ ओन के पुजारी फ़ोतीफ़िरा की बेटी आसनत थी। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","बिनयमीन के बेटे बाला, बकर, अशबेल, जीरा, नामान, इख़ी, रोस, मुफ़्फ़ीम, हुफ़्फ़ीम और अर्द थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","कुल 14 मर्द राख़िल की औलाद थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","दान का बेटा हुशीम था। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नफ़ताली के बेटे यहसियेल, जूनी, यिसर और सिल्लीम थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","कुल 7 मर्द बिलहाह की औलाद थे जिसे लाबन ने अपनी बेटी राख़िल को दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","याक़ूब की औलाद के 66 अफ़राद उसके साथ मिसर चले गए। इस तादाद में बेटों की बीवियाँ शामिल नहीं थीं। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","जब हम याक़ूब, यूसुफ़ और उसके दो बेटे इनमें शामिल करते हैं तो याक़ूब के घराने के 70 अफ़राद मिसर गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","याक़ूब ने यहूदाह को अपने आगे यूसुफ़ के पास भेजा ताकि वह जुशन में उनसे मिले। जब वह वहाँ पहुँचे ");
INSERT INTO urdgvh_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","तो यूसुफ़ अपने रथ पर सवार होकर अपने बाप से मिलने के लिए जुशन गया। उसे देखकर वह उसके गले लगकर काफ़ी देर रोता रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","याक़ूब ने यूसुफ़ से कहा, “अब मैं मरने के लिए तैयार हूँ, क्योंकि मैंने ख़ुद देखा है कि तू ज़िंदा है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","फिर यूसुफ़ ने अपने भाइयों और अपने बाप के ख़ानदान के बाक़ी अफ़राद से कहा, “ज़रूरी है कि मैं जाकर बादशाह को इत्तला दूँ कि मेरे भाई और मेरे बाप का पूरा ख़ानदान जो कनान के रहनेवाले हैं मेरे पास आ गए हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","मैं उससे कहूँगा, ‘यह आदमी भेड़-बकरियों के चरवाहे हैं। वह मवेशी पालते हैं, इसलिए अपनी भेड़-बकरियाँ, गाय-बैल और बाक़ी सारा माल अपने साथ ले आए हैं।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","बादशाह तुम्हें बुलाकर पूछेगा कि तुम क्या काम करते हो? ");
INSERT INTO urdgvh_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","फिर तुमको जवाब देना है, ‘आपके ख़ादिम बचपन से मवेशी पालते आए हैं। यह हमारे बापदादा का पेशा था और हमारा भी है।’ अगर तुम यह कहो तो तुम्हें जुशन में रहने की इजाज़त मिलेगी। क्योंकि भेड़-बकरियों के चरवाहे मिसरियों की नज़र में क़ाबिले-नफ़रत हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","यूसुफ़ फ़िरौन के पास गया और उसे इत्तला देकर कहा, “मेरा बाप और भाई अपनी भेड़-बकरियों, गाय-बैलों और सारे माल समेत मुल्के-कनान से आकर जुशन में ठहरे हुए हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","उसने अपने भाइयों में से पाँच को चुनकर फ़िरौन के सामने पेश किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","फ़िरौन ने भाइयों से पूछा, “तुम क्या काम करते हो?” उन्होंने जवाब दिया, “आपके ख़ादिम भेड़-बकरियों के चरवाहे हैं। यह हमारे बापदादा का पेशा था और हमारा भी है। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","हम यहाँ आए हैं ताकि कुछ देर अजनबी की हैसियत से आपके पास ठहरें, क्योंकि काल ने कनान में बहुत ज़ोर पकड़ा है। वहाँ आपके ख़ादिमों के जानवरों के लिए चरागाहें ख़त्म हो गई हैं। इसलिए हमें जुशन में रहने की इजाज़त दें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","बादशाह ने यूसुफ़ से कहा, “तेरा बाप और भाई तेरे पास आ गए हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","मुल्के-मिसर तेरे सामने खुला है। उन्हें बेहतरीन जगह पर आबाद कर। वह जुशन में रहें। और अगर उनमें से कुछ हैं जो ख़ास क़ाबिलियत रखते हैं तो उन्हें मेरे मवेशियों की निगहदाशत पर रख।” ");
INSERT INTO urdgvh_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","फिर यूसुफ़ अपने बाप याक़ूब को ले आया और फ़िरौन के सामने पेश किया। याक़ूब ने बादशाह को बरकत दी। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","बादशाह ने उससे पूछा, “तुम्हारी उम्र क्या है?” ");
INSERT INTO urdgvh_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","याक़ूब ने जवाब दिया, “मैं 130 साल से इस दुनिया का मेहमान हूँ। मेरी ज़िंदगी मुख़तसर और तकलीफ़देह थी, और मेरे बापदादा मुझसे ज़्यादा उम्ररसीदा हुए थे जब वह इस दुनिया के मेहमान थे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","यह कहकर याक़ूब फ़िरौन को दुबारा बरकत देकर चला गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","फिर यूसुफ़ ने अपने बाप और भाइयों को मिसर में आबाद किया। उसने उन्हें रामसीस के इलाक़े में बेहतरीन ज़मीन दी जिस तरह बादशाह ने हुक्म दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","यूसुफ़ अपने बाप के पूरे घराने को ख़ुराक मुहैया करता रहा। हर ख़ानदान को उसके बच्चों की तादाद के मुताबिक़ ख़ुराक मिलती रही। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","काल इतना सख़्त था कि कहीं भी रोटी नहीं मिलती थी। मिसर और कनान में लोग निढाल हो गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","मिसर और कनान के तमाम पैसे अनाज ख़रीदने के लिए सर्फ़ हो गए। यूसुफ़ उन्हें जमा करके फ़िरौन के महल में ले आया। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","जब मिसर और कनान के पैसे ख़त्म हो गए तो मिसरियों ने यूसुफ़ के पास आकर कहा, “हमें रोटी दें! हम आपके सामने क्यों मरें? हमारे पैसे ख़त्म हो गए हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","यूसुफ़ ने जवाब दिया, “अगर आपके पैसे ख़त्म हैं तो मुझे अपने मवेशी दें। मैं उनके एवज़ रोटी देता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","चुनाँचे वह अपने घोड़े, भेड़-बकरियाँ, गाय-बैल और गधे यूसुफ़ के पास ले आए। इनके एवज़ उसने उन्हें ख़ुराक दी। उस साल उसने उन्हें उनके तमाम मवेशियों के एवज़ ख़ुराक मुहैया की। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","अगले साल वह दुबारा उसके पास आए। उन्होंने कहा, “जनाबे-आली, हम यह बात आपसे नहीं छुपा सकते कि अब हम सिर्फ़ अपने आप और अपनी ज़मीन को आपको दे सकते हैं। हमारे पैसे तो ख़त्म हैं और आप हमारे मवेशी भी ले चुके हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","हम क्यों आपकी आँखों के सामने मर जाएँ? हमारी ज़मीन क्यों तबाह हो जाए? हमें रोटी दें तो हम और हमारी ज़मीन बादशाह की होगी। हम फ़िरौन के ग़ुलाम होंगे। हमें बीज दें ताकि हम जीते बचें और ज़मीन तबाह न हो जाए।” ");
INSERT INTO urdgvh_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","चुनाँचे यूसुफ़ ने फ़िरौन के लिए मिसर की पूरी ज़मीन ख़रीद ली। काल की सख़्ती के सबब से तमाम मिसरियों ने अपने खेत बेच दिए। इस तरीक़े से पूरा मुल्क फ़िरौन की मिलकियत में आ गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","यूसुफ़ ने मिसर के एक सिरे से दूसरे सिरे तक के लोगों को शहरों में मुंतक़िल कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","सिर्फ़ पुजारियों की ज़मीन आज़ाद रही। उन्हें अपनी ज़मीन बेचने की ज़रूरत ही नहीं थी, क्योंकि उन्हें फ़िरौन से इतना वज़ीफ़ा मिलता था कि गुज़ारा हो जाता था। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","यूसुफ़ ने लोगों से कहा, “ग़ौर से सुनें। आज मैंने आपको और आपकी ज़मीन को बादशाह के लिए ख़रीद लिया है। अब यह बीज लेकर अपने खेतों में बोना। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","आपको फ़िरौन को फ़सल का पाँचवाँ हिस्सा देना है। बाक़ी पैदावार आपकी होगी। आप इससे बीज बो सकते हैं, और यह आपके और आपके घरानों और बच्चों के खाने के लिए होगा।” ");
INSERT INTO urdgvh_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","उन्होंने जवाब दिया, “आपने हमें बचाया है। हमारे मालिक हम पर मेहरबानी करें तो हम फ़िरौन के ग़ुलाम बनेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","इस तरह यूसुफ़ ने मिसर में यह क़ानून नाफ़िज़ किया कि हर फ़सल का पाँचवाँ हिस्सा बादशाह का है। यह क़ानून आज तक जारी है। सिर्फ़ पुजारियों की ज़मीन बादशाह की मिलकियत में न आई। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","इसराईली मिसर में जुशन के इलाक़े में आबाद हुए। वहाँ उन्हें ज़मीन मिली, और वह फले-फूले और तादाद में बहुत बढ़ गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","याक़ूब 17 साल मिसर में रहा। वह 147 साल का था जब फ़ौत हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","जब मरने का वक़्त क़रीब आया तो उसने यूसुफ़ को बुलाकर कहा, “मेहरबानी करके अपना हाथ मेरी रान के नीचे रखकर क़सम खा कि तू मुझ पर शफ़क़त और वफ़ादारी का इस तरह इज़हार करेगा कि मुझे मिसर में दफ़न नहीं करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","जब मैं मरकर अपने बापदादा से जा मिलूँगा तो मुझे मिसर से ले जाकर मेरे बापदादा की क़ब्र में दफ़नाना।” यूसुफ़ ने जवाब दिया, “ठीक है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","याक़ूब ने कहा, “क़सम खा कि तू ऐसा ही करेगा।” यूसुफ़ ने क़सम खाई। तब इसराईल ने अपने बिस्तर के सिरहाने पर अल्लाह को सिजदा किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","कुछ देर के बाद यूसुफ़ को इत्तला दी गई कि आपका बाप बीमार है। वह अपने दो बेटों मनस्सी और इफ़राईम को साथ लेकर याक़ूब से मिलने गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","याक़ूब को बताया गया, “आपका बेटा आ गया है” तो वह अपने आपको सँभालकर अपने बिस्तर पर बैठ गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","उसने यूसुफ़ से कहा, “जब मैं कनानी शहर लूज़ में था तो अल्लाह क़ादिरे-मुतलक़ मुझ पर ज़ाहिर हुआ। उसने मुझे बरकत देकर ");
INSERT INTO urdgvh_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","कहा, ‘मैं तुझे फलने फूलने दूँगा और तेरी औलाद बढ़ा दूँगा बल्कि तुझसे बहुत-सी क़ौमें निकलने दूँगा। और मैं तेरी औलाद को यह मुल्क हमेशा के लिए दे दूँगा।’ ");
INSERT INTO urdgvh_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","अब मेरी बात सुन। मैं चाहता हूँ कि तेरे बेटे जो मेरे आने से पहले मिसर में पैदा हुए मेरे बेटे हों। इफ़राईम और मनस्सी रूबिन और शमौन के बराबर ही मेरे बेटे हों। ");
INSERT INTO urdgvh_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","अगर इनके बाद तेरे हाँ और बेटे पैदा हो जाएँ तो वह मेरे बेटे नहीं बल्कि तेरे ठहरेंगे। जो मीरास वह पाएँगे वह उन्हें इफ़राईम और मनस्सी की मीरास में से मिलेगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","मैं यह तेरी माँ राख़िल के सबब से कर रहा हूँ जो मसोपुतामिया से वापसी के वक़्त कनान में इफ़राता के क़रीब मर गई। मैंने उसे वहीं रास्ते में दफ़न किया” (आज इफ़राता को बैत-लहम कहा जाता है)। ");
INSERT INTO urdgvh_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","फिर याक़ूब ने यूसुफ़ के बेटों पर नज़र डालकर पूछा, “यह कौन हैं?” ");
INSERT INTO urdgvh_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","यूसुफ़ ने जवाब दिया, “यह मेरे बेटे हैं जो अल्लाह ने मुझे यहाँ मिसर में दिए।” याक़ूब ने कहा, “उन्हें मेरे क़रीब ले आ ताकि मैं उन्हें बरकत दूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","बूढ़ा होने के सबब से याक़ूब की आँखें कमज़ोर थीं। वह अच्छी तरह देख नहीं सकता था। यूसुफ़ अपने बेटों को याक़ूब के पास ले आया तो उसने उन्हें बोसा देकर गले लगाया ");
INSERT INTO urdgvh_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","और यूसुफ़ से कहा, “मुझे तवक़्क़ो ही नहीं थी कि मैं कभी तेरा चेहरा देखूँगा, और अब अल्लाह ने मुझे तेरे बेटों को देखने का मौक़ा भी दिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","फिर यूसुफ़ उन्हें याक़ूब की गोद में से लेकर ख़ुद उसके सामने मुँह के बल झुक गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","यूसुफ़ ने इफ़राईम को याक़ूब के बाएँ हाथ रखा और मनस्सी को उसके दाएँ हाथ। ");
INSERT INTO urdgvh_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","लेकिन याक़ूब ने अपना दहना हाथ बाईं तरफ़ बढ़ाकर इफ़राईम के सर पर रखा अगरचे वह छोटा था। इस तरह उसने अपना बायाँ हाथ दाईं तरफ़ बढ़ाकर मनस्सी के सर पर रखा जो बड़ा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","फिर उसने यूसुफ़ को उसके बेटों की मारिफ़त बरकत दी, “अल्लाह जिसके हुज़ूर मेरे बापदादा इब्राहीम और इसहाक़ चलते रहे और जो शुरू से आज तक मेरा चरवाहा रहा है इन्हें बरकत दे। ");
INSERT INTO urdgvh_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","जिस फ़रिश्ते ने एवज़ाना देकर मुझे हर नुक़सान से बचाया है वह इन्हें बरकत दे। अल्लाह करे कि इनमें मेरा नाम और मेरे बापदादा इब्राहीम और इसहाक़ के नाम जीते रहें। दुनिया में इनकी औलाद की तादाद बहुत बढ़ जाए।” ");
INSERT INTO urdgvh_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","जब यूसुफ़ ने देखा कि बाप ने अपना दहना हाथ छोटे बेटे इफ़राईम के सर पर रखा है तो यह उसे बुरा लगा, इसलिए उसने बाप का हाथ पकड़ा ताकि उसे इफ़राईम के सर पर से उठाकर मनस्सी के सर पर रखे। ");
INSERT INTO urdgvh_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","उसने कहा, “अब्बू, ऐसे नहीं। दूसरा लड़का बड़ा है। उसी पर अपना दहना हाथ रखें।” ");
INSERT INTO urdgvh_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","लेकिन बाप ने इनकार करके कहा, “मुझे पता है बेटा, मुझे पता है। वह भी एक बड़ी क़ौम बनेगा। फिर भी उसका छोटा भाई उससे बड़ा होगा और उससे क़ौमों की बड़ी तादाद निकलेगी।” ");
INSERT INTO urdgvh_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","उस दिन उसने दोनों बेटों को बरकत देकर कहा, “इसराईली तुम्हारा नाम लेकर बरकत दिया करेंगे। जब वह बरकत देंगे तो कहेंगे, ‘अल्लाह आपके साथ वैसा करे जैसा उसने इफ़राईम और मनस्सी के साथ किया है’।” इस तरह याक़ूब ने इफ़राईम को मनस्सी से बड़ा बना दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","यूसुफ़ से उसने कहा, “मैं तो मरनेवाला हूँ, लेकिन अल्लाह तुम्हारे साथ होगा और तुम्हें तुम्हारे बापदादा के मुल्क में वापस ले जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","एक बात में मैं तुझे तेरे भाइयों पर तरजीह देता हूँ, मैं तुझे कनान में वह क़ितआ देता हूँ जो मैंने अपनी तलवार और कमान से अमोरियों से छीना था।” ");
INSERT INTO urdgvh_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","याक़ूब ने अपने बेटों को बुलाकर कहा, “मेरे पास जमा हो जाओ ताकि मैं तुम्हें बताऊँ कि मुस्तक़बिल में तुम्हारे साथ क्या क्या होगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","ऐ याक़ूब के बेटो, इकट्ठे होकर सुनो, अपने बाप इसराईल की बातों पर ग़ौर करो। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","रूबिन, तुम मेरे पहलौठे हो, मेरे ज़ोर और मेरी ताक़त का पहला फल। तुम इज़्ज़त और क़ुव्वत के लिहाज़ से बरतर हो। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","लेकिन चूँकि तुम बेकाबू सैलाब की मानिंद हो इसलिए तुम्हारी अव्वल हैसियत जाती रहे। क्योंकि तुमने मेरी हरम से हमबिसतर होकर अपने बाप की बेहुरमती की है। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","शमौन और लावी दोनों भाइयों की तलवारें ज़ुल्मो-तशद्दुद के हथियार रहे हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","मेरी जान न उनकी मजलिस में शामिल और न उनकी जमात में दाख़िल हो, क्योंकि उन्होंने ग़ुस्से में आकर दूसरों को क़त्ल किया है, उन्होंने अपनी मरज़ी से बैलों की कोंचें काटी हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","उनके ग़ुस्से पर लानत हो जो इतना ज़बरदस्त है और उनके तैश पर जो इतना सख़्त है। मैं उन्हें याक़ूब के मुल्क में तित्तर-बित्तर करूँगा, उन्हें इसराईल में मुंतशिर कर दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","यहूदाह, तुम्हारे भाई तुम्हारी तारीफ़ करेंगे। तुम अपने दुश्मनों की गरदन पकड़े रहोगे, और तुम्हारे बाप के बेटे तुम्हारे सामने झुक जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","यहूदाह शेरबबर का बच्चा है। मेरे बेटे, तुम अभी अभी शिकार मारकर वापस आए हो। यहूदाह शेरबबर बल्कि शेरनी की तरह दबककर बैठ जाता है। कौन उसे छेड़ने की जुर्रत करेगा? ");
INSERT INTO urdgvh_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","शाही असा यहूदाह से दूर नहीं होगा बल्कि शाही इख़्तियार उस वक़्त तक उस की औलाद के पास रहेगा जब तक वह हाकिम न आए जिसके ताबे क़ौमें रहेंगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","वह अपना जवान गधा अंगूर की बेल से और अपनी गधी का बच्चा बेहतरीन अंगूर की बेल से बाँधेगा। वह अपना लिबास मै में और अपना कपड़ा अंगूर के ख़ून में धोएगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","उस की आँखें मै से ज़्यादा गदली और उसके दाँत दूध से ज़्यादा सफ़ेद होंगे। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","ज़बूलून साहिल पर आबाद होगा जहाँ बहरी जहाज़ होंगे। उस की हद सैदा तक होगी। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","इशकार ताक़तवर गधा है जो अपने ज़ीन के दो बोरों के दरमियान बैठा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","जब वह देखेगा कि उस की आरामगाह अच्छी और उसका मुल्क ख़ुशनुमा है तो वह बोझ उठाने के लिए तैयार हो जाएगा और उजरत के बग़ैर काम करने के लिए मजबूर किया जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","दान अपनी क़ौम का इनसाफ़ करेगा अगरचे वह इसराईल के क़बीलों में से एक ही है। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान सड़क के साँप और रास्ते के अफ़ई की मानिंद होगा। वह घोड़े की एड़ियों को काटेगा तो उसका सवार पीछे गिर जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","ऐ रब, मैं तेरी ही नजात के इंतज़ार में हूँ! ");
INSERT INTO urdgvh_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","जद पर डाकुओं का जत्था हमला करेगा, लेकिन वह पलटकर उसी पर हमला कर देगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","आशर को ग़िज़ाइयतवाली ख़ुराक हासिल होगी। वह लज़ीज़ शाही खाना मुहैया करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","नफ़ताली आज़ाद छोड़ी हुई हिरनी है। वह ख़ूबसूरत बातें करता है। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","यूसुफ़ फलदार बेल है। वह चश्मे पर लगी हुई फलदार बेल है जिसकी शाख़ें दीवार पर चढ़ गई हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","तीरअंदाज़ों ने उस पर तीर चलाकर उसे तंग किया और उसके पीछे पड़ गए, ");
INSERT INTO urdgvh_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","लेकिन उस की कमान मज़बूत रही, और उसके बाज़ू याक़ूब के ज़ोरावर ख़ुदा के सबब से ताक़तवर रहे, उस चरवाहे के सबब से जो इसराईल का ज़बरदस्त सूरमा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","क्योंकि तेरे बाप का ख़ुदा तेरी मदद करता है, अल्लाह क़ादिरे-मुतलक़ तुझे आसमान की बरकत, ज़मीन की गहराइयों की बरकत और औलाद की बरकत देता है। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","तेरे बाप की बरकत क़दीम पहाड़ों और अबदी पहाड़ियों की मरग़ूब चीज़ों से ज़्यादा अज़ीम है। यह तमाम बरकत यूसुफ़ के सर पर हो, उस शख़्स के चाँद पर जो अपने भाइयों पर शहज़ादा है। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","बिनयमीन फाड़नेवाला भेड़िया है। सुबह वह अपना शिकार खा जाता और रात को अपना लूटा हुआ माल तक़सीम कर देता है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","यह इसराईल के कुल बारह क़बीले हैं। और यह वह कुछ है जो उनके बाप ने उनसे बरकत देते वक़्त कहा। उसने हर एक को उस की अपनी बरकत दी। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","फिर याक़ूब ने अपने बेटों को हुक्म दिया, “अब मैं कूच करके अपने बापदादा से जा मिलूँगा। मुझे मेरे बापदादा के साथ उस ग़ार में दफ़नाना जो हित्ती आदमी इफ़रोन के खेत में है। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","यानी उस ग़ार में जो मुल्के-कनान में ममरे के मशरिक़ में मकफ़ीला के खेत में है। इब्राहीम ने उसे खेत समेत अपने लोगों को दफ़नाने के लिए इफ़रोन हित्ती से ख़रीद लिया था। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","वहाँ इब्राहीम और उस की बीवी सारा दफ़नाए गए, वहाँ इसहाक़ और उस की बीवी रिबक़ा दफ़नाए गए और वहाँ मैंने लियाह को दफ़न किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","वह खेत और उसका ग़ार हित्तियों से ख़रीदा गया था।” ");
INSERT INTO urdgvh_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","इन हिदायात के बाद याक़ूब ने अपने पाँव बिस्तर पर समेट लिए और दम छोड़कर अपने बापदादा से जा मिला। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","यूसुफ़ अपने बाप के चेहरे से लिपट गया। उसने रोते हुए उसे बोसा दिया। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","उसके मुलाज़िमों में से कुछ डाक्टर थे। उसने उन्हें हिदायत दी कि मेरे बाप इसराईल की लाश को हनूत करें ताकि वह गल न जाए। उन्होंने ऐसा ही किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","इसमें 40 दिन लग गए। आम तौर पर हनूत करने के लिए इतने ही दिन लगते हैं। मिसरियों ने 70 दिन तक याक़ूब का मातम किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","जब मातम का वक़्त ख़त्म हुआ तो यूसुफ़ ने बादशाह के दरबारियों से कहा, “मेहरबानी करके यह ख़बर बादशाह तक पहुँचा दें ");
INSERT INTO urdgvh_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","कि मेरे बाप ने मुझे क़सम दिलाकर कहा था, ‘मैं मरनेवाला हूँ। मुझे उस क़ब्र में दफ़न करना जो मैंने मुल्के-कनान में अपने लिए बनवाई।’ अब मुझे इजाज़त दें कि मैं वहाँ जाऊँ और अपने बाप को दफ़न करके वापस आऊँ।” ");
INSERT INTO urdgvh_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","फ़िरौन ने जवाब दिया, “जा, अपने बाप को दफ़न कर जिस तरह उसने तुझे क़सम दिलाई थी।” ");
INSERT INTO urdgvh_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","चुनाँचे यूसुफ़ अपने बाप को दफ़नाने के लिए कनान रवाना हुआ। बादशाह के तमाम मुलाज़िम, महल के बुज़ुर्ग और पूरे मिसर के बुज़ुर्ग उसके साथ थे। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","यूसुफ़ के घराने के अफ़राद, उसके भाई और उसके बाप के घराने के लोग भी साथ गए। सिर्फ़ उनके बच्चे, उनकी भेड़-बकरियाँ और गाय-बैल जुशन में रहे। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","रथ और घुड़सवार भी साथ गए। सब मिलकर बड़ा लशकर बन गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","जब वह यरदन के क़रीब अतद के खलियान पर पहुँचे तो उन्होंने निहायत दिलसोज़ नोहा किया। वहाँ यूसुफ़ ने सात दिन तक अपने बाप का मातम किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","जब मक़ामी कनानियों ने अतद के खलियान पर मातम का यह नज़ारा देखा तो उन्होंने कहा, “यह तो मातम का बहुत बड़ा इंतज़ाम है जो मिसरी करवा रहे हैं।” इसलिए उस जगह का नाम अबील-मिसरीम यानी ‘मिसरियों का मातम’ पड़ गया। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","यों याक़ूब के बेटों ने अपने बाप का हुक्म पूरा किया। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","उन्होंने उसे मुल्के-कनान में ले जाकर मकफ़ीला के खेत के ग़ार में दफ़न किया जो ममरे के मशरिक़ में है। यह वही खेत है जो इब्राहीम ने इफ़रोन हित्ती से अपने लोगों को दफ़नाने के लिए ख़रीदा था। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","इसके बाद यूसुफ़, उसके भाई और बाक़ी तमाम लोग जो जनाज़े के लिए साथ गए थे मिसर को लौट आए। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","जब याक़ूब इंतक़ाल कर गया तो यूसुफ़ के भाई डर गए। उन्होंने कहा, “ख़तरा है कि अब यूसुफ़ हमारा ताक़्क़ुब करके उस ग़लत काम का बदला ले जो हमने उसके साथ किया था। फिर क्या होगा?” ");
INSERT INTO urdgvh_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","यह सोचकर उन्होंने यूसुफ़ को ख़बर भेजी, “आपके बाप ने मरने से पेशतर हिदायत दी ");
INSERT INTO urdgvh_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","कि यूसुफ़ को बताना, ‘अपने भाइयों के उस ग़लत काम को मुआफ़ कर देना जो उन्होंने तुम्हारे साथ किया।’ अब हमें जो आपके बाप के ख़ुदा के पैरोकार हैं मुआफ़ कर दें।” यह ख़बर सुनकर यूसुफ़ रो पड़ा। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","फिर उसके भाई ख़ुद आए और उसके सामने गिर गए। उन्होंने कहा, “हम आपके ख़ादिम हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","लेकिन यूसुफ़ ने कहा, “मत डरो। क्या मैं अल्लाह की जगह हूँ? हरगिज़ नहीं! ");
INSERT INTO urdgvh_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","तुमने मुझे नुक़सान पहुँचाने का इरादा किया था, लेकिन अल्लाह ने उससे भलाई पैदा की। और अब इसका मक़सद पूरा हो रहा है। बहुत-से लोग मौत से बच रहे हैं। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","चुनाँचे अब डरने की ज़रूरत नहीं है। मैं तुम्हें और तुम्हारे बच्चों को ख़ुराक मुहैया करता रहूँगा।” यों यूसुफ़ ने उन्हें तसल्ली दी और उनसे नरमी से बात की। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","यूसुफ़ अपने बाप के ख़ानदान समेत मिसर में रहा। वह 110 साल ज़िंदा रहा। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","मौत से पहले उसने न सिर्फ़ इफ़राईम के बच्चों को बल्कि उसके पोतों को भी देखा। मनस्सी के बेटे मकीर के बच्चे भी उस की मौजूदगी में पैदा होकर उस की गोद में रखे गए। ");
INSERT INTO urdgvh_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","फिर एक वक़्त आया कि यूसुफ़ ने अपने भाइयों से कहा, “मैं मरनेवाला हूँ। लेकिन अल्लाह ज़रूर आपकी देख-भाल करके आपको इस मुल्क से उस मुल्क में ले जाएगा जिसका उसने इब्राहीम, इसहाक़ और याक़ूब से क़सम खाकर वादा किया है।” ");
INSERT INTO urdgvh_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","फिर यूसुफ़ ने इसराईलियों को क़सम दिलाकर कहा, “अल्लाह यक़ीनन तुम्हारी देख-भाल करके वहाँ ले जाएगा। उस वक़्त मेरी हड्डियों को भी उठाकर साथ ले जाना।” ");
INSERT INTO urdgvh_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","फिर यूसुफ़ फ़ौत हो गया। वह 110 साल का था। उसे हनूत करके मिसर में एक ताबूत में रखा गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ज़ैल में उन बेटों के नाम हैं जो अपने बाप याक़ूब और अपने ख़ानदानों समेत मिसर में आए थे : ");
INSERT INTO urdgvh_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रूबिन, शमौन, लावी, यहूदाह, ");
INSERT INTO urdgvh_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इशकार, ज़बूलून, बिनयमीन, ");
INSERT INTO urdgvh_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान, नफ़ताली, जद और आशर। ");
INSERT INTO urdgvh_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","उस वक़्त याक़ूब की औलाद की तादाद 70 थी। यूसुफ़ तो पहले ही मिसर आ चुका था। ");
INSERT INTO urdgvh_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","मिसर में रहते हुए बहुत दिन गुज़र गए। इतने में यूसुफ़, उसके तमाम भाई और उस नसल के तमाम लोग मर गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","इसराईली फले-फूले और तादाद में बहुत बढ़ गए। नतीजे में वह निहायत ही ताक़तवर हो गए। पूरा मुल्क उनसे भर गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","होते होते एक नया बादशाह तख़्तनशीन हुआ जो यूसुफ़ से नावाक़िफ़ था। ");
INSERT INTO urdgvh_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","उसने अपने लोगों से कहा, “इसराईलियों को देखो। वह तादाद और ताक़त में हमसे बढ़ गए हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","आओ, हम हिकमत से काम लें, वरना वह मज़ीद बढ़ जाएंगे। ऐसा न हो कि वह किसी जंग के मौक़े पर दुश्मन का साथ देकर हमसे लड़ें और मुल्क को छोड़ जाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","चुनाँचे मिसरियों ने इसराईलियों पर निगरान मुक़र्रर किए ताकि बेगार में उनसे काम करवाकर उन्हें दबाते रहें। उस वक़्त उन्होंने पितोम और रामसीस के शहर तामीर किए। इन शहरों में फ़िरौन बादशाह के बड़े बड़े गोदाम थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","लेकिन जितना इसराईलियों को दबाया गया उतना ही वह तादाद में बढ़ते और फैलते गए। आख़िरकार मिसरी उनसे दहशत खाने लगे, ");
INSERT INTO urdgvh_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","और वह बड़ी बेरहमी से उनसे काम करवाते रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","इसराईलियों का गुज़ारा निहायत मुश्किल हो गया। उन्हें गारा तैयार करके ईंटें बनाना और खेतों में मुख़्तलिफ़ क़िस्म के काम करना पड़े। इसमें मिसरी उनसे बड़ी बेरहमी से पेश आते रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","इसराईलियों की दो दाइयाँ थीं जिनके नाम सिफ़रा और फ़ुआ थे। मिसर के बादशाह ने उनसे कहा, ");
INSERT INTO urdgvh_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“जब इबरानी औरतें तुम्हें मदद के लिए बुलाएँ तो ख़बरदार रहो। अगर लड़का पैदा हो तो उसे जान से मार दो, अगर लड़की हो तो उसे जीता छोड़ दो।” ");
INSERT INTO urdgvh_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","लेकिन दाइयाँ अल्लाह का ख़ौफ़ मानती थीं। उन्होंने मिसर के बादशाह का हुक्म न माना बल्कि लड़कों को भी जीने दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","तब मिसर के बादशाह ने उन्हें दुबारा बुलाकर पूछा, “तुमने यह क्यों किया? तुम लड़कों को क्यों जीता छोड़ देती हो?” ");
INSERT INTO urdgvh_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","उन्होंने जवाब दिया, “इबरानी औरतें मिसरी औरतों से ज़्यादा मज़बूत हैं। बच्चे हमारे पहुँचने से पहले ही पैदा हो जाते हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","चुनाँचे अल्लाह ने दाइयों को बरकत दी, और इसराईली क़ौम तादाद में बढ़कर बहुत ताक़तवर हो गई। ");
INSERT INTO urdgvh_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","और चूँकि दाइयाँ अल्लाह का ख़ौफ़ मानती थीं इसलिए उसने उन्हें औलाद देकर उनके ख़ानदानों को क़ायम रखा। ");
INSERT INTO urdgvh_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","आख़िरकार बादशाह ने अपने तमाम हमवतनों से बात की, “जब भी इबरानियों के लड़के पैदा हों तो उन्हें दरियाए-नील में फेंक देना। सिर्फ़ लड़कियों को ज़िंदा रहने दो।” ");
INSERT INTO urdgvh_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","उन दिनों में लावी के एक आदमी ने अपने ही क़बीले की एक औरत से शादी की। ");
INSERT INTO urdgvh_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","औरत हामिला हुई और बच्चा पैदा हुआ। माँ ने देखा कि लड़का ख़ूबसूरत है, इसलिए उसने उसे तीन माह तक छुपाए रखा। ");
INSERT INTO urdgvh_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","जब वह उसे और ज़्यादा न छुपा सकी तो उसने आबी नरसल से टोकरी बनाकर उस पर तारकोल चढ़ाया। फिर उसने बच्चे को टोकरी में रखकर टोकरी को दरियाए-नील के किनारे पर उगे हुए सरकंडों में रख दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","बच्चे की बहन कुछ फ़ासले पर खड़ी देखती रही कि उसका क्या बनेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","उस वक़्त फ़िरौन की बेटी नहाने के लिए दरिया पर आई। उस की नौकरानियाँ दरिया के किनारे टहलने लगीं। तब उसने सरकंडों में टोकरी देखी और अपनी लौंडी को उसे लाने भेजा। ");
INSERT INTO urdgvh_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","उसे खोला तो छोटा लड़का दिखाई दिया जो रो रहा था। फ़िरौन की बेटी को उस पर तरस आया। उसने कहा, “यह कोई इबरानी बच्चा है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","अब बच्चे की बहन फ़िरौन की बेटी के पास गई और पूछा, “क्या मैं बच्चे को दूध पिलाने के लिए कोई इबरानी औरत ढूँड लाऊँ?” ");
INSERT INTO urdgvh_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","फ़िरौन की बेटी ने कहा, “हाँ, जाओ।” लड़की चली गई और बच्चे की सगी माँ को लेकर वापस आई। ");
INSERT INTO urdgvh_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","फ़िरौन की बेटी ने माँ से कहा, “बच्चे को ले जाओ और उसे मेरे लिए दूध पिलाया करो। मैं तुम्हें इसका मुआवज़ा दूँगी।” चुनाँचे बच्चे की माँ ने उसे दूध पिलाने के लिए ले लिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","जब बच्चा बड़ा हुआ तो उस की माँ उसे फ़िरौन की बेटी के पास ले गई, और वह उसका बेटा बन गया। फ़िरौन की बेटी ने उसका नाम मूसा यानी ‘निकाला गया’ रखकर कहा, “मैं उसे पानी से निकाल लाई हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","जब मूसा जवान हुआ तो एक दिन वह घर से निकलकर अपने लोगों के पास गया जो जबरी काम में मसरूफ़ थे। मूसा ने देखा कि एक मिसरी मेरे एक इबरानी भाई को मार रहा है। ");
INSERT INTO urdgvh_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","मूसा ने चारों तरफ़ नज़र दौड़ाई। जब मालूम हुआ कि कोई नहीं देख रहा तो उसने मिसरी को जान से मार दिया और उसे रेत में छुपा दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","अगले दिन भी मूसा घर से निकला। इस दफ़ा दो इबरानी मर्द आपस में लड़ रहे थे। जो ग़लती पर था उससे मूसा ने पूछा, “तुम अपने भाई को क्यों मार रहे हो?” ");
INSERT INTO urdgvh_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","आदमी ने जवाब दिया, “किसने आपको हम पर हुक्मरान और क़ाज़ी मुक़र्रर किया है? क्या आप मुझे भी क़त्ल करना चाहते हैं जिस तरह मिसरी को मार डाला था?” तब मूसा डर गया। उसने सोचा, “हाय, मेरा भेद खुल गया है!” ");
INSERT INTO urdgvh_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","बादशाह को भी पता लगा तो उसने मूसा को मरवाने की कोशिश की। लेकिन मूसा मिदियान के मुल्क को भाग गया। वहाँ वह एक कुएँ के पास बैठ गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","मिदियान में एक इमाम था जिसकी सात बेटियाँ थीं। यह लड़कियाँ अपनी भेड़-बकरियों को पानी पिलाने के लिए कुएँ पर आईं और पानी निकालकर हौज़ भरने लगीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","लेकिन कुछ चरवाहों ने आकर उन्हें भगा दिया। यह देखकर मूसा उठा और लड़कियों को चरवाहों से बचाकर उनके रेवड़ को पानी पिलाया। ");
INSERT INTO urdgvh_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","जब लड़कियाँ अपने बाप रऊएल के पास वापस आईं तो बाप ने पूछा, “आज तुम इतनी जल्दी से क्यों वापस आ गई हो?” ");
INSERT INTO urdgvh_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","लड़कियों ने जवाब दिया, “एक मिसरी आदमी ने हमें चरवाहों से बचाया। न सिर्फ़ यह बल्कि उसने हमारे लिए पानी भी निकालकर रेवड़ को पिला दिया।” ");
INSERT INTO urdgvh_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","रऊएल ने कहा, “वह आदमी कहाँ है? तुम उसे क्यों छोड़कर आई हो? उसे बुलाओ ताकि वह हमारे साथ खाना खाए।” ");
INSERT INTO urdgvh_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","मूसा रऊएल के घर में ठहरने के लिए राज़ी हो गया। बाद में उस की शादी रऊएल की बेटी सफ़्फ़ूरा से हुई। ");
INSERT INTO urdgvh_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","सफ़्फ़ूरा के बेटा पैदा हुआ तो मूसा ने कहा, “इसका नाम जैरसोम यानी ‘अजनबी मुल्क में परदेसी’ हो, क्योंकि मैं अजनबी मुल्क में परदेसी हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","काफ़ी अरसा गुज़र गया। इतने में मिसर का बादशाह इंतक़ाल कर गया। इसराईली अपनी ग़ुलामी तले कराहते और मदद के लिए पुकारते रहे, और उनकी चीख़ें अल्लाह तक पहुँच गईं। ");
INSERT INTO urdgvh_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","अल्लाह ने उनकी आहें सुनीं और उस अहद को याद किया जो उसने इब्राहीम, इसहाक़ और याक़ूब से बाँधा था। ");
INSERT INTO urdgvh_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","अल्लाह इसराईलियों की हालत देखकर उनका ख़याल करने लगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","मूसा अपने सुसर यितरो की भेड़-बकरियों की निगहबानी करता था (मिदियान का इमाम रऊएल यितरो भी कहलाता था)। एक दिन मूसा रेवड़ को रेगिस्तान की परली जानिब ले गया और चलते चलते अल्लाह के पहाड़ होरिब यानी सीना तक पहुँच गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","वहाँ रब का फ़रिश्ता आग के शोले में उस पर ज़ाहिर हुआ। यह शोला एक झाड़ी में भड़क रहा था। मूसा ने देखा कि झाड़ी जल रही है लेकिन भस्म नहीं हो रही। ");
INSERT INTO urdgvh_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","मूसा ने सोचा, “यह तो अजीब बात है। क्या वजह है कि जलती हुई झाड़ी भस्म नहीं हो रही? मैं ज़रा वहाँ जाकर यह हैरतअंगेज़ मंज़र देखूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","जब रब ने देखा कि मूसा झाड़ी को देखने आ रहा है तो उसने उसे झाड़ी में से पुकारा, “मूसा, मूसा!” मूसा ने कहा, “जी, मैं हाज़िर हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","रब ने कहा, “इससे ज़्यादा क़रीब न आना। अपनी जूतियाँ उतार, क्योंकि तू मुक़द्दस ज़मीन पर खड़ा है। ");
INSERT INTO urdgvh_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","मैं तेरे बाप का ख़ुदा, इब्राहीम का ख़ुदा, इसहाक़ का ख़ुदा और याक़ूब का ख़ुदा हूँ।” यह सुनकर मूसा ने अपना मुँह ढाँक लिया, क्योंकि वह अल्लाह को देखने से डरा। ");
INSERT INTO urdgvh_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","रब ने कहा, “मैंने मिसर में अपनी क़ौम की बुरी हालत देखी और ग़ुलामी में उनकी चीख़ें सुनी हैं, और मैं उनके दुखों को ख़ूब जानता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","अब मैं उन्हें मिसरियों के क़ाबू से बचाने के लिए उतर आया हूँ। मैं उन्हें मिसर से निकालकर एक अच्छे वसी मुल्क में ले जाऊँगा, एक ऐसे मुल्क में जहाँ दूध और शहद की कसरत है, गो इस वक़्त कनानी, हित्ती, अमोरी, फ़रिज़्ज़ी, हिव्वी और यबूसी उसमें रहते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","इसराईलियों की चीख़ें मुझ तक पहुँची हैं। मैंने देखा है कि मिसरी उन पर किस तरह का ज़ुल्म ढा रहे हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","चुनाँचे अब जा। मैं तुझे फ़िरौन के पास भेजता हूँ, क्योंकि तुझे मेरी क़ौम इसराईल को मिसर से निकालकर लाना है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","लेकिन मूसा ने अल्लाह से कहा, “मैं कौन हूँ कि फ़िरौन के पास जाकर इसराईलियों को मिसर से निकाल लाऊँ?” ");
INSERT INTO urdgvh_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","अल्लाह ने कहा, “मैं तो तेरे साथ हूँगा। और इसका सबूत कि मैं तुझे भेज रहा हूँ यह होगा कि लोगों के मिसर से निकलने के बाद तुम यहाँ आकर इस पहाड़ पर मेरी इबादत करोगे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","लेकिन मूसा ने एतराज़ किया, “अगर मैं इसराईलियों के पास जाकर उन्हें बताऊँ कि तुम्हारे बापदादा के ख़ुदा ने मुझे तुम्हारे पास भेजा है तो वह पूछेंगे, ‘उसका नाम क्या है?’ फिर मैं उनको क्या जवाब दूँ?” ");
INSERT INTO urdgvh_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","अल्लाह ने कहा, “मैं जो हूँ सो मैं हूँ। उनसे कहना, ‘मैं हूँ ने मुझे तुम्हारे पास भेजा है। ");
INSERT INTO urdgvh_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","रब जो तुम्हारे बापदादा का ख़ुदा, इब्राहीम का ख़ुदा, इसहाक़ का ख़ुदा और याक़ूब का ख़ुदा है उसी ने मुझे तुम्हारे पास भेजा है।’ यह अबद तक मेरा नाम रहेगा। लोग यही नाम लेकर मुझे नसल-दर-नसल याद करेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","अब जा और इसराईल के बुज़ुर्गों को जमा करके उनको बता दे कि रब तुम्हारे बापदादा इब्राहीम, इसहाक़ और याक़ूब का ख़ुदा मुझ पर ज़ाहिर हुआ है। वह फ़रमाता है, ‘मैंने ख़ूब देख लिया है कि मिसर में तुम्हारे साथ क्या सुलूक हो रहा है। ");
INSERT INTO urdgvh_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","इसलिए मैंने फ़ैसला किया है कि तुम्हें मिसर की मुसीबत से निकालकर कनानियों, हित्तियों, अमोरियों, फ़रिज़्ज़ियों, हिव्वियों और यबूसियों के मुल्क में ले जाऊँ, ऐसे मुल्क में जहाँ दूध और शहद की कसरत है।’ ");
INSERT INTO urdgvh_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","बुज़ुर्ग तेरी सुनेंगे। फिर उनके साथ मिसर के बादशाह के पास जाकर उससे कहना, ‘रब इबरानियों का ख़ुदा हम पर ज़ाहिर हुआ है। इसलिए हमें इजाज़त दें कि हम तीन दिन का सफ़र करके रेगिस्तान में रब अपने ख़ुदा के लिए क़ुरबानियाँ चढ़ाएँ।’ ");
INSERT INTO urdgvh_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","लेकिन मुझे मालूम है कि मिसर का बादशाह सिर्फ़ इस सूरत में तुम्हें जाने देगा कि कोई ज़बरदस्ती तुम्हें ले जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","इसलिए मैं अपनी क़ुदरत ज़ाहिर करके अपने मोजिज़ों की मारिफ़त मिसरियों को मारूँगा। फिर वह तुम्हें जाने देगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","उस वक़्त मैं मिसरियों के दिलों को तुम्हारे लिए नरम कर दूँगा। तुम्हें ख़ाली हाथ नहीं जाना पड़ेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","तमाम इबरानी औरतें अपनी मिसरी पड़ोसनों और अपने घर में रहनेवाली मिसरी औरतों से चाँदी और सोने के ज़ेवरात और नफ़ीस कपड़े माँगकर अपने बच्चों को पहनाएँगी। यों मिसरियों को लूट लिया जाएगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","मूसा ने एतराज़ किया, “लेकिन इसराईली न मेरी बात का यक़ीन करेंगे, न मेरी सुनेंगे। वह तो कहेंगे, ‘रब तुम पर ज़ाहिर नहीं हुआ’।” ");
INSERT INTO urdgvh_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","जवाब में रब ने मूसा से कहा, “तूने हाथ में क्या पकड़ा हुआ है?” मूसा ने कहा, “लाठी।” ");
INSERT INTO urdgvh_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","रब ने कहा, “उसे ज़मीन पर डाल दे।” मूसा ने ऐसा किया तो लाठी साँप बन गई, और मूसा डरकर भागा। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","रब ने कहा, “अब साँप की दुम को पकड़ ले।” मूसा ने ऐसा किया तो साँप फिर लाठी बन गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","रब ने कहा, “यह देखकर लोगों को यक़ीन आएगा कि रब जो उनके बापदादा का ख़ुदा, इब्राहीम का ख़ुदा, इसहाक़ का ख़ुदा और याक़ूब का ख़ुदा है तुझ पर ज़ाहिर हुआ है। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","अब अपना हाथ अपने लिबास में डाल दे।” मूसा ने ऐसा किया। जब उसने अपना हाथ निकाला तो वह बर्फ़ की मानिंद सफ़ेद हो गया था। कोढ़ जैसी बीमारी लग गई थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","तब रब ने कहा, “अब अपना हाथ दुबारा अपने लिबास में डाल।” मूसा ने ऐसा किया। जब उसने अपना हाथ दुबारा निकाला तो वह फिर सेहतमंद था। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","रब ने कहा, “अगर लोगों को पहला मोजिज़ा देखकर यक़ीन न आए और वह तेरी न सुनें तो शायद उन्हें दूसरा मोजिज़ा देखकर यक़ीन आए। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","अगर उन्हें फिर भी यक़ीन न आए और वह तेरी न सुनें तो दरियाए-नील से कुछ पानी निकालकर उसे ख़ुश्क ज़मीन पर उंडेल दे। यह पानी ज़मीन पर गिरते ही ख़ून बन जाएगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","लेकिन मूसा ने कहा, “मेरे आक़ा, मैं माज़रत चाहता हूँ, मैं अच्छी तरह बात नहीं कर सकता बल्कि मैं कभी भी यह लियाक़त नहीं रखता था। इस वक़्त भी जब मैं तुझसे बात कर रहा हूँ मेरी यही हालत है। मैं रुक रुककर बोलता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","रब ने कहा, “किसने इनसान का मुँह बनाया? कौन एक को गूँगा और दूसरे को बहरा बना देता है? कौन एक को देखने की क़ाबिलियत देता है और दूसरे को इससे महरूम रखता है? क्या मैं जो रब हूँ यह सब कुछ नहीं करता? ");
INSERT INTO urdgvh_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","अब जा! तेरे बोलते वक़्त मैं ख़ुद तेरे साथ हूँगा और तुझे वह कुछ सिखाऊँगा जो तुझे कहना है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","लेकिन मूसा ने इल्तिजा की, “मेरे आक़ा, मेहरबानी करके किसी और को भेज दे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","तब रब मूसा से सख़्त ख़फ़ा हुआ। उसने कहा, “क्या तेरा लावी भाई हारून ऐसे काम के लिए हाज़िर नहीं है? मैं जानता हूँ कि वह अच्छी तरह बोल सकता है। देख, वह तुझसे मिलने के लिए निकल चुका है। तुझे देखकर वह निहायत ख़ुश होगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","उसे वह कुछ बता जो उसे कहना है। तुम्हारे बोलते वक़्त मैं तेरे और उसके साथ हूँगा और तुम्हें वह कुछ सिखाऊँगा जो तुम्हें करना होगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","हारून तेरी जगह क़ौम से बात करेगा जबकि तू मेरी तरह उसे वह कुछ बताएगा जो उसे कहना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","लेकिन यह लाठी भी साथ ले जाना, क्योंकि इसी के ज़रीए तू यह मोजिज़े करेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","फिर मूसा अपने सुसर यितरो के घर वापस चला गया। उसने कहा, “मुझे ज़रा अपने अज़ीज़ों के पास वापस जाने दें जो मिसर में हैं। मैं मालूम करना चाहता हूँ कि वह अभी तक ज़िंदा हैं कि नहीं।” यितरो ने जवाब दिया, “ठीक है, सलामती से जाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","मूसा अभी मिदियान में था कि रब ने उससे कहा, “मिसर को वापस चला जा, क्योंकि जो आदमी तुझे क़त्ल करना चाहते थे वह मर गए हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","चुनाँचे मूसा अपनी बीवी और बेटों को गधे पर सवार करके मिसर को लौटने लगा। अल्लाह की लाठी उसके हाथ में थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","रब ने उससे यह भी कहा, “मिसर जाकर फ़िरौन के सामने वह तमाम मोजिज़े दिखा जिनका मैंने तुझे इख़्तियार दिया है। लेकिन मेरे कहने पर वह अड़ा रहेगा। वह इसराईलियों को जाने की इजाज़त नहीं देगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","उस वक़्त फ़िरौन को बता देना, ‘रब फ़रमाता है कि इसराईल मेरा पहलौठा है। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","मैं तुझे बता चुका हूँ कि मेरे बेटे को जाने दे ताकि वह मेरी इबादत करे। अगर तू मेरे बेटे को जाने से मना करे तो मैं तेरे पहलौठे को जान से मार दूँगा’।” ");
INSERT INTO urdgvh_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","एक दिन जब मूसा अपने ख़ानदान के साथ रास्ते में किसी सराय में ठहरा हुआ था तो रब ने उस पर हमला करके उसे मार देने की कोशिश की। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","यह देखकर सफ़्फ़ूरा ने एक तेज़ पत्थर से अपने बेटे का ख़तना किया और काटे हुए हिस्से से मूसा के पैर छुए। उसने कहा, “यक़ीनन तुम मेरे ख़ूनी दूल्हा हो।” ");
INSERT INTO urdgvh_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","तब अल्लाह ने मूसा को छोड़ दिया। सफ़्फ़ूरा ने उसे ख़तने के बाइस ही ‘ख़ूनी दूल्हा’ कहा था। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","रब ने हारून से भी बात की, “रेगिस्तान में मूसा से मिलने जा।” हारून चल पड़ा और अल्लाह के पहाड़ के पास मूसा से मिला। उसने उसे बोसा दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","मूसा ने हारून को सब कुछ सुना दिया जो रब ने उसे कहने के लिए भेजा था। उसने उसे उन मोजिज़ों के बारे में भी बताया जो उसे दिखाने थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","फिर दोनों मिलकर मिसर गए। वहाँ पहुँचकर उन्होंने इसराईल के तमाम बुज़ुर्गों को जमा किया। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","हारून ने उन्हें वह तमाम बातें सुनाईं जो रब ने मूसा को बताई थीं। उसने मज़कूरा मोजिज़े भी लोगों के सामने दिखाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","फिर उन्हें यक़ीन आया। और जब उन्होंने सुना कि रब को तुम्हारा ख़याल है और वह तुम्हारी मुसीबत से आगाह है तो उन्होंने रब को सिजदा किया। ");
INSERT INTO urdgvh_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","फिर मूसा और हारून फ़िरौन के पास गए। उन्होंने कहा, “रब इसराईल का ख़ुदा फ़रमाता है, ‘मेरी क़ौम को रेगिस्तान में जाने दे ताकि वह मेरे लिए ईद मनाएँ’।” ");
INSERT INTO urdgvh_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","फ़िरौन ने जवाब दिया, “यह रब कौन है? मैं क्यों उसका हुक्म मानकर इसराईलियों को जाने दूँ? न मैं रब को जानता हूँ, न इसराईलियों को जाने दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","हारून और मूसा ने कहा, “इबरानियों का ख़ुदा हम पर ज़ाहिर हुआ है। इसलिए मेहरबानी करके हमें इजाज़त दें कि रेगिस्तान में तीन दिन का सफ़र करके रब अपने ख़ुदा के हुज़ूर क़ुरबानियाँ पेश करें। कहीं वह हमें किसी बीमारी या तलवार से न मारे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","लेकिन मिसर के बादशाह ने इनकार किया, “मूसा और हारून, तुम लोगों को काम से क्यों रोक रहे हो? जाओ, जो काम हमने तुमको दिया है उस पर लग जाओ! ");
INSERT INTO urdgvh_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","इसराईली वैसे भी तादाद में बहुत बढ़ गए हैं, और तुम उन्हें काम करने से रोक रहे हो।” ");
INSERT INTO urdgvh_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","उसी दिन फ़िरौन ने मिसरी निगरानों और उनके तहत के इसराईली निगरानों को हुक्म दिया, ");
INSERT INTO urdgvh_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“अब से इसराईलियों को ईंटें बनाने के लिए भूसा मत देना, बल्कि वह ख़ुद जाकर भूसा जमा करें। ");
INSERT INTO urdgvh_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","तो भी वह उतनी ही ईंटें बनाएँ जितनी पहले बनाते थे। वह सुस्त हो गए हैं और इसी लिए चीख़ रहे हैं कि हमें जाने दें ताकि अपने ख़ुदा को क़ुरबानियाँ पेश करें। ");
INSERT INTO urdgvh_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","उनसे और ज़्यादा सख़्त काम कराओ, उन्हें काम में लगाए रखो। उनके पास इतना वक़्त ही न हो कि वह झूटी बातों पर ध्यान दें।” ");
INSERT INTO urdgvh_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","मिसरी निगरान और उनके तहत के इसराईली निगरानों ने लोगों के पास जाकर उनसे कहा, “फ़िरौन का हुक्म है कि तुम्हें भूसा न दिया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","इसलिए ख़ुद जाओ और भूसा ढूँडकर जमा करो। लेकिन ख़बरदार! उतनी ही ईंटें बनाओ जितनी पहले बनाते थे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","यह सुनकर इसराईली भूसा जमा करने के लिए पूरे मुल्क में फैल गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","मिसरी निगरान यह कहकर उन पर दबाव डालते रहे कि उतनी ईंटें बनाओ जितनी पहले बनाते थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","जो इसराईली निगरान उन्होंने मुक़र्रर किए थे उन्हें वह पीटते और कहते रहे, “तुमने कल और आज उतनी ईंटें क्यों नहीं बनवाईं जितनी पहले बनवाते थे?” ");
INSERT INTO urdgvh_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","फिर इसराईली निगरान फ़िरौन के पास गए। उन्होंने शिकायत करके कहा, “आप अपने ख़ादिमों के साथ ऐसा सुलूक क्यों कर रहे हैं? ");
INSERT INTO urdgvh_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","हमें भूसा नहीं दिया जा रहा और साथ साथ यह कहा गया है कि उतनी ईंटें बनाओ जितनी पहले बनाते थे। नतीजे में हमें मारा पीटा भी जा रहा है हालाँकि ऐसा करने में आपके अपने लोग ग़लती पर हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","फ़िरौन ने जवाब दिया, “तुम लोग सुस्त हो, तुम काम करना नहीं चाहते। इसलिए तुम यह जगह छोड़ना और रब को क़ुरबानियाँ पेश करना चाहते हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","अब जाओ, काम करो। तुम्हें भूसा नहीं दिया जाएगा, लेकिन ख़बरदार! उतनी ही ईंटें बनाओ जितनी पहले बनाते थे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","जब इसराईली निगरानों को बताया गया कि ईंटों की मतलूबा तादाद कम न करो तो वह समझ गए कि हम फँस गए हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","फ़िरौन के महल से निकलकर उनकी मुलाक़ात मूसा और हारून से हुई जो उनके इंतज़ार में थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","उन्होंने मूसा और हारून से कहा, “रब ख़ुद आपकी अदालत करे। क्योंकि आपके सबब से फ़िरौन और उसके मुलाज़िमों को हमसे घिन आती है। आपने उन्हें हमें मार देने का मौक़ा दे दिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","यह सुनकर मूसा रब के पास वापस आया और कहा, “ऐ आक़ा, तूने इस क़ौम से ऐसा बुरा सुलूक क्यों किया? क्या तूने इसी मक़सद से मुझे यहाँ भेजा है? ");
INSERT INTO urdgvh_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","जब से मैंने फ़िरौन के पास जाकर उसे तेरी मरज़ी बताई है वह इसराईली क़ौम से बुरा सुलूक कर रहा है। और तूने अब तक उन्हें बचाने का कोई क़दम नहीं उठाया।” ");
INSERT INTO urdgvh_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","रब ने जवाब दिया, “अब तू देखेगा कि मैं फ़िरौन के साथ क्या कुछ करता हूँ। मेरी अज़ीम क़ुदरत का तजरबा करके वह मेरे लोगों को जाने देगा बल्कि उन्हें जाने पर मजबूर करेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","अल्लाह ने मूसा से यह भी कहा, “मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","मैं इब्राहीम, इसहाक़ और याक़ूब पर ज़ाहिर हुआ। वह मेरे नाम अल्लाह क़ादिरे-मुतलक़ से वाक़िफ़ हुए, लेकिन मैंने उन पर अपने नाम रब का इनकिशाफ़ नहीं किया। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","मैंने उनसे अहद करके वादा किया कि उन्हें मुल्के-कनान दूँगा जिसमें वह अजनबी के तौर पर रहते थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","अब मैंने सुना है कि इसराईली किस तरह मिसरियों की ग़ुलामी में कराह रहे हैं, और मैंने अपना अहद याद किया है। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","चुनाँचे इसराईलियों को बताना, ‘मैं रब हूँ। मैं तुम्हें मिसरियों के जुए से आज़ाद करूँगा और उनकी ग़ुलामी से बचाऊँगा। मैं बड़ी क़ुदरत के साथ तुम्हें छुड़ाऊँगा और उनकी अदालत करूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","मैं तुम्हें अपनी क़ौम बनाऊँगा और तुम्हारा ख़ुदा हूँगा। तब तुम जान लोगे कि मैं रब तुम्हारा ख़ुदा हूँ जिसने तुम्हें मिसरियों के जुए से आज़ाद कर दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","मैं तुम्हें उस मुल्क में ले जाऊँगा जिसका वादा मैंने क़सम खाकर इब्राहीम, इसहाक़ और याक़ूब से किया है। वह मुल्क तुम्हारी अपनी मिलकियत होगा। मैं रब हूँ’।” ");
INSERT INTO urdgvh_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","मूसा ने यह सब कुछ इसराईलियों को बता दिया, लेकिन उन्होंने उस की बात न मानी, क्योंकि वह सख़्त काम के बाइस हिम्मत हार गए थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","तब रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“जा, मिसर के बादशाह फ़िरौन को बता देना कि इसराईलियों को अपने मुल्क से जाने दे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","लेकिन मूसा ने एतराज़ किया, “इसराईली मेरी बात सुनना नहीं चाहते तो फ़िरौन क्यों मेरी बात माने जबकि मैं रुक रुककर बोलता हूँ?” ");
INSERT INTO urdgvh_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","लेकिन रब ने मूसा और हारून को हुक्म दिया, “इसराईलियों और मिसर के बादशाह फ़िरौन से बात करके इसराईलियों को मिसर से निकालो।” ");
INSERT INTO urdgvh_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","इसराईल के आबाई घरानों के सरबराह यह थे : इसराईल के पहलौठे रूबिन के चार बेटे हनूक, फ़ल्लू, हसरोन और करमी थे। इनसे रूबिन की चार शाख़ें निकलीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","शमौन के पाँच बेटे यमुएल, यमीन, उहद, यकीन, सुहर और साऊल थे। (साऊल कनानी औरत का बच्चा था)। इनसे शमौन की पाँच शाख़ें निकलीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","लावी के तीन बेटे जैरसोन, क़िहात और मिरारी थे। (लावी 137 साल की उम्र में फ़ौत हुआ)। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","जैरसोन के दो बेटे लिबनी और सिमई थे। इनसे जैरसोन की दो शाख़ें निकलीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","क़िहात के चार बेटे अमराम, इज़हार, हबरून और उज़्ज़ियेल थे। (क़िहात 133 साल की उम्र में फ़ौत हुआ)। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","मिरारी के दो बेटे महली और मूशी थे। इन सबसे लावी की मुख़्तलिफ़ शाख़ें निकलीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","अमराम ने अपनी फूफी यूकबिद से शादी की। उनके दो बेटे हारून और मूसा पैदा हुए। (अमराम 137 साल की उम्र में फ़ौत हुआ)। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","इज़हार के तीन बेटे क़ोरह, नफ़ज और ज़िकरी थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","उज़्ज़ियेल के तीन बेटे मीसाएल, इल्सफ़न और सितरी थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","हारून ने इलीसिबा से शादी की। (इलीसिबा अम्मीनदाब की बेटी और नहसोन की बहन थी)। उनके चार बेटे नदब, अबीहू, इलियज़र और इतमर थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","क़ोरह के तीन बेटे अस्सीर, इलक़ाना और अबियासफ़ थे। उनसे क़ोरहियों की तीन शाख़ें निकलीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","हारून के बेटे इलियज़र ने फ़ूतियेल की एक बेटी से शादी की। उनका एक बेटा फ़ीनहास था। यह सब लावी के आबाई घरानों के सरबराह थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","रब ने अमराम के दो बेटों हारून और मूसा को हुक्म दिया कि मेरी क़ौम को उसके ख़ानदानों की तरतीब के मुताबिक़ मिसर से निकालो। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","इन्हीं दो आदमियों ने मिसर के बादशाह फ़िरौन से बात की कि इसराईलियों को मिसर से जाने दे। ");
INSERT INTO urdgvh_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","मिसर में रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“मैं रब हूँ। मिसर के बादशाह को वह सब कुछ बता देना जो मैं तुझे बताता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","मूसा ने एतराज़ किया, “मैं तो रुक रुककर बोलता हूँ। फ़िरौन किस तरह मेरी बात मानेगा?” ");
INSERT INTO urdgvh_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","लेकिन रब ने कहा, “देख, मेरे कहने पर तू फ़िरौन के लिए अल्लाह की हैसियत रखेगा और तेरा भाई हारून तेरा पैग़ंबर होगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","जो भी हुक्म मैं तुझे दूँगा उसे तू हारून को बता दे। फिर वह सब कुछ फ़िरौन को बताए ताकि वह इसराईलियों को अपने मुल्क से जाने दे। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","लेकिन मैं फ़िरौन को अड़ जाने दूँगा। अगरचे मैं मिसर में बहुत-से निशानों और मोजिज़ों से अपनी क़ुदरत का मुज़ाहरा करूँगा ");
INSERT INTO urdgvh_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","तो भी फ़िरौन तुम्हारी नहीं सुनेगा। तब मिसरियों पर मेरा हाथ भारी हो जाएगा, और मैं उनको सख़्त सज़ा देकर अपनी क़ौम इसराईल को ख़ानदानों की तरतीब के मुताबिक़ मिसर से निकाल लाऊँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","जब मैं मिसर के ख़िलाफ़ अपनी क़ुदरत का इज़हार करके इसराईलियों को वहाँ से निकालूँगा तो मिसरी जान लेंगे कि मैं रब हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","मूसा और हारून ने सब कुछ वैसा ही किया जैसा रब ने उन्हें हुक्म दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","फ़िरौन से बात करते वक़्त मूसा 80 साल का और हारून 83 साल का था। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","रब ने मूसा और हारून से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“जब फ़िरौन तुम्हें मोजिज़ा दिखाने को कहेगा तो मूसा हारून से कहे कि अपनी लाठी ज़मीन पर डाल दे। इस पर वह साँप बन जाएगी।” ");
INSERT INTO urdgvh_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","मूसा और हारून ने फ़िरौन के पास जाकर ऐसा ही किया। हारून ने अपनी लाठी फ़िरौन और उसके ओहदेदारों के सामने डाल दी तो वह साँप बन गई। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","यह देखकर फ़िरौन ने अपने आलिमों और जादूगरों को बुलाया। जादूगरों ने भी अपने जादू से ऐसा ही किया। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","हर एक ने अपनी लाठी ज़मीन पर फेंकी तो वह साँप बन गई। लेकिन हारून की लाठी ने उनकी लाठियों को निगल लिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ताहम फ़िरौन इससे मुतअस्सिर न हुआ। उसने मूसा और हारून की बात सुनने से इनकार किया। वैसा ही हुआ जैसा रब ने कहा था। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","फिर रब ने मूसा से कहा, “फ़िरौन अड़ गया है। वह मेरी क़ौम को मिसर छोड़ने से रोकता है। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","कल सुबह-सवेरे जब वह दरियाए-नील पर आएगा तो उससे मिलने के लिए दरिया के किनारे पर खड़े हो जाना। उस लाठी को थामे रखना जो साँप बन गई थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","जब वह वहाँ पहुँचे तो उससे कहना, ‘रब इबरानियों के ख़ुदा ने मुझे आपको यह बताने के लिए भेजा है कि मेरी क़ौम को मेरी इबादत करने के लिए रेगिस्तान में जाने दे। लेकिन आपने अभी तक उस की नहीं सुनी। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","चुनाँचे अब आप जान लेंगे कि वह रब है। मैं इस लाठी को जो मेरे हाथ में है लेकर दरियाए-नील के पानी को मारूँगा। फिर वह ख़ून में बदल जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","दरियाए-नील की मछलियाँ मर जाएँगी, दरिया से बदबू उठेगी और मिसरी दरिया का पानी नहीं पी सकेंगे’।” ");
INSERT INTO urdgvh_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","रब ने मूसा से कहा, “हारून को बता देना कि वह अपनी लाठी लेकर अपना हाथ उन तमाम जगहों की तरफ़ बढ़ाए जहाँ पानी जमा होता है। तब मिसर की तमाम नदियों, नहरों, जोहड़ों और तालाबों का पानी ख़ून में बदल जाएगा। पूरे मुल्क में ख़ून ही ख़ून होगा, यहाँ तक कि लकड़ी और पत्थर के बरतनों का पानी भी ख़ून में बदल जाएगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","चुनाँचे मूसा और हारून ने फ़िरौन और उसके ओहदेदारों के सामने अपनी लाठी उठाकर दरियाए-नील के पानी पर मारी। इस पर दरिया का सारा पानी ख़ून में बदल गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","दरिया की मछलियाँ मर गईं, और उससे इतनी बदबू उठने लगी कि मिसरी उसका पानी न पी सके। मिसर में चारों तरफ़ ख़ून ही ख़ून था। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","लेकिन जादूगरों ने भी अपने जादू के ज़रीए ऐसा ही किया। इसलिए फ़िरौन अड़ गया और मूसा और हारून की बात न मानी। वैसा ही हुआ जैसा रब ने कहा था। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","फ़िरौन पलटकर अपने घर वापस चला गया। उसे उस की परवा नहीं थी जो मूसा और हारून ने किया था। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","लेकिन मिसरी दरिया से पानी न पी सके, और उन्होंने पीने का पानी हासिल करने के लिए दरिया के किनारे किनारे गढ़े खोदे। ");
INSERT INTO urdgvh_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","पानी के बदल जाने के बाद सात दिन गुज़र गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","फिर रब ने मूसा से कहा, “फ़िरौन के पास जाकर उसे बता देना कि रब फ़रमाता है, ‘मेरी क़ौम को मेरी इबादत करने के लिए जाने दे, ");
INSERT INTO urdgvh_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","वरना मैं पूरे मिसर को मेंढकों से सज़ा दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","दरियाए-नील मेंढकों से इतना भर जाएगा कि वह दरिया से निकलकर तेरे महल, तेरे सोने के कमरे और तेरे बिस्तर में जा घुसेंगे। वह तेरे ओहदेदारों और तेरी रिआया के घरों में आएँगे बल्कि तेरे तनूरों और आटा गूँधने के बरतनों में भी फुदकते फिरेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","मेंढक तुझ पर, तेरी क़ौम पर और तेरे ओहदेदारों पर चढ़ जाएंगे’।” ");
INSERT INTO urdgvh_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","रब ने मूसा से कहा, “हारून को बता देना कि वह अपनी लाठी को हाथ में लेकर उसे दरियाओं, नहरों और जोहड़ों के ऊपर उठाए ताकि मेंढक बाहर निकलकर मिसर के मुल्क में फैल जाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","हारून ने मुल्के-मिसर के पानी के ऊपर अपनी लाठी उठाई तो मेंढकों के ग़ोल पानी से निकलकर पूरे मुल्क पर छा गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","लेकिन जादूगरों ने भी अपने जादू से ऐसा ही किया। वह भी दरिया से मेंढक निकाल लाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","फ़िरौन ने मूसा और हारून को बुलाकर कहा, “रब से दुआ करो कि वह मुझसे और मेरी क़ौम से मेंढकों को दूर करे। फिर मैं तुम्हारी क़ौम को जाने दूँगा ताकि वह रब को क़ुरबानियाँ पेश करें।” ");
INSERT INTO urdgvh_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","मूसा ने जवाब दिया, “वह वक़्त मुक़र्रर करें जब मैं आपके ओहदेदारों और आपकी क़ौम के लिए दुआ करूँ। फिर जो मेंढक आपके पास और आपके घरों में हैं उसी वक़्त ख़त्म हो जाएंगे। मेंढक सिर्फ़ दरिया में पाए जाएंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","फ़िरौन ने कहा, “ठीक है, कल उन्हें ख़त्म करो।” मूसा ने कहा, “जैसा आप कहते हैं वैसा ही होगा। इस तरह आपको मालूम होगा कि हमारे ख़ुदा की मानिंद कोई नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","मेंढक आप, आपके घरों, आपके ओहदेदारों और आपकी क़ौम को छोड़कर सिर्फ़ दरिया में रह जाएंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","मूसा और हारून फ़िरौन के पास से चले गए, और मूसा ने रब से मिन्नत की कि वह मेंढकों के वह ग़ोल दूर करे जो उसने फ़िरौन के ख़िलाफ़ भेजे थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","रब ने उस की दुआ सुनी। घरों, सहनों और खेतों में मेंढक मर गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","लोगों ने उन्हें जमा करके उनके ढेर लगा दिए। उनकी बदबू पूरे मुल्क में फैल गई। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","लेकिन जब फ़िरौन ने देखा कि मसला हल हो गया है तो वह फिर अकड़ गया और उनकी न सुनी। यों रब की बात दुरुस्त निकली। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","फिर रब ने मूसा से कहा, “हारून से कहना कि वह अपनी लाठी से ज़मीन की गर्द को मारे। जब वह ऐसा करेगा तो पूरे मिसर की गर्द जुओं में बदल जाएगी।” ");
INSERT INTO urdgvh_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","उन्होंने ऐसा ही किया। हारून ने अपनी लाठी से ज़मीन की गर्द को मारा तो पूरे मुल्क की गर्द जुओं में बदल गई। उनके ग़ोल जानवरों और आदमियों पर छा गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","जादूगरों ने भी अपने जादू से ऐसा करने की कोशिश की, लेकिन वह गर्द से जुएँ न बना सके। जुएँ आदमियों और जानवरों पर छा गईं। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","जादूगरों ने फ़िरौन से कहा, “अल्लाह की क़ुदरत ने यह किया है।” लेकिन फ़िरौन ने उनकी न सुनी। यों रब की बात दुरुस्त निकली। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","फिर रब ने मूसा से कहा, “जब फ़िरौन सुबह-सवेरे दरिया पर जाए तो तू उसके रास्ते में खड़ा हो जाना। उसे कहना कि रब फ़रमाता है, ‘मेरी क़ौम को जाने दे ताकि वह मेरी इबादत कर सकें। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","वरना मैं तेरे और तेरे ओहदेदारों के पास, तेरी क़ौम के पास और तेरे घरों में काटनेवाली मक्खियाँ भेज दूँगा। मिसरियों के घर मक्खियों से भर जाएंगे बल्कि जिस ज़मीन पर वह खड़े हैं वह भी मक्खियों से ढाँकी जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","लेकिन उस वक़्त मैं अपनी क़ौम के साथ जो जुशन में रहती है फ़रक़ सुलूक करूँगा। वहाँ एक भी काटनेवाली मक्खी नहीं होगी। इस तरह तुझे पता लगेगा कि इस मुल्क में मैं ही रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","मैं अपनी क़ौम और तेरी क़ौम में इम्तियाज़ करूँगा। कल ही मेरी क़ुदरत का इज़हार होगा’।” ");
INSERT INTO urdgvh_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","रब ने ऐसा ही किया। काटनेवाली मक्खियों के ग़ोल फ़िरौन के महल, उसके ओहदेदारों के घरों और पूरे मिसर में फैल गए। मुल्क का सत्यानास हो गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","फिर फ़िरौन ने मूसा और हारून को बुलाकर कहा, “चलो, इसी मुल्क में अपने ख़ुदा को क़ुरबानियाँ पेश करो।” ");
INSERT INTO urdgvh_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","लेकिन मूसा ने कहा, “यह मुनासिब नहीं है। जो क़ुरबानियाँ हम रब अपने ख़ुदा को पेश करेंगे वह मिसरियों की नज़र में घिनौनी हैं। अगर हम यहाँ ऐसा करें तो क्या वह हमें संगसार नहीं करेंगे? ");
INSERT INTO urdgvh_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","इसलिए लाज़िम है कि हम तीन दिन का सफ़र करके रेगिस्तान में ही रब अपने ख़ुदा को क़ुरबानियाँ पेश करें जिस तरह उसने हमें हुक्म भी दिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","फ़िरौन ने जवाब दिया, “ठीक है, मैं तुम्हें जाने दूँगा ताकि तुम रेगिस्तान में रब अपने ख़ुदा को क़ुरबानियाँ पेश करो। लेकिन तुम्हें ज़्यादा दूर नहीं जाना है। और मेरे लिए भी दुआ करना।” ");
INSERT INTO urdgvh_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","मूसा ने कहा, “ठीक, मैं जाते ही रब से दुआ करूँगा। कल ही मक्खियाँ फ़िरौन, उसके ओहदेदारों और उस की क़ौम से दूर हो जाएँगी। लेकिन हमें दुबारा फ़रेब न देना बल्कि हमें जाने देना ताकि हम रब को क़ुरबानियाँ पेश कर सकें।” ");
INSERT INTO urdgvh_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","फिर मूसा फ़िरौन के पास से चला गया और रब से दुआ की। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","रब ने मूसा की दुआ सुनी। काटनेवाली मक्खियाँ फ़िरौन, उसके ओहदेदारों और उस की क़ौम से दूर हो गईं। एक भी मक्खी न रही। ");
INSERT INTO urdgvh_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","लेकिन फ़िरौन फिर अकड़ गया। उसने इसराईलियों को जाने न दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","फिर रब ने मूसा से कहा, “फ़िरौन के पास जाकर उसे बता कि रब इबरानियों का ख़ुदा फ़रमाता है, ‘मेरी क़ौम को जाने दे ताकि वह मेरी इबादत कर सकें।’ ");
INSERT INTO urdgvh_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","अगर आप इनकार करें और उन्हें रोकते रहें ");
INSERT INTO urdgvh_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","तो रब अपनी क़ुदरत का इज़हार करके आपके मवेशियों में भयानक वबा फैला देगा जो आपके घोड़ों, गधों, ऊँटों, गाय-बैलों, भेड़-बकरियों और मेंढों में फैल जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","लेकिन रब इसराईल और मिसर के मवेशियों में इम्तियाज़ करेगा। इसराईलियों का एक भी जानवर नहीं मरेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","रब ने फ़ैसला कर लिया है कि वह कल ही ऐसा करेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","अगले दिन रब ने ऐसा ही किया। मिसर के तमाम मवेशी मर गए, लेकिन इसराईलियों का एक भी जानवर न मरा। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","फ़िरौन ने कुछ लोगों को उनके पास भेज दिया तो पता चला कि एक भी जानवर नहीं मरा। ताहम फ़िरौन अड़ा रहा। उसने इसराईलियों को जाने न दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","फिर रब ने मूसा और हारून से कहा, “अपनी मुट्ठियाँ किसी भट्टी की राख से भरकर फ़िरौन के पास जाओ। फिर मूसा फ़िरौन के सामने यह राख हवा में उड़ा दे। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","यह राख बारीक धूल का बादल बन जाएगी जो पूरे मुल्क पर छा जाएगा। उसके असर से लोगों और जानवरों के जिस्मों पर फोड़े-फुंसियाँ फूट निकलेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","मूसा और हारून ने ऐसा ही किया। वह किसी भट्टी से राख लेकर फ़िरौन के सामने खड़े हो गए। मूसा ने राख को हवा में उड़ा दिया तो इनसानों और जानवरों के जिस्मों पर फोड़े-फुंसियाँ निकल आए। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","इस मरतबा जादूगर मूसा के सामने खड़े भी न हो सके क्योंकि उनके जिस्मों पर भी फोड़े निकल आए थे। तमाम मिसरियों का यही हाल था। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","लेकिन रब ने फ़िरौन को ज़िद्दी बनाए रखा, इसलिए उसने मूसा और हारून की न सुनी। यों वैसा ही हुआ जैसा रब ने मूसा को बताया था। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","इसके बाद रब ने मूसा से कहा, “सुबह-सवेरे उठ और फ़िरौन के सामने खड़े होकर उसे बता कि रब इबरानियों का ख़ुदा फ़रमाता है, ‘मेरी क़ौम को जाने दे ताकि वह मेरी इबादत कर सकें। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","वरना मैं अपनी तमाम आफ़तें तुझ पर, तेरे ओहदेदारों पर और तेरी क़ौम पर आने दूँगा। फिर तू जान लेगा कि तमाम दुनिया में मुझ जैसा कोई नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","अगर मैं चाहता तो अपनी क़ुदरत से ऐसी वबा फैला सकता कि तुझे और तेरी क़ौम को दुनिया से मिटा दिया जाता। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","लेकिन मैंने तुझे इसलिए बरपा किया है कि तुझ पर अपनी क़ुदरत का इज़हार करूँ और यों तमाम दुनिया में मेरे नाम का प्रचार किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","तू अभी तक अपने आपको सरफ़राज़ करके मेरी क़ौम के ख़िलाफ़ है और उन्हें जाने नहीं देता। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","इसलिए कल मैं इसी वक़्त भयानक क़िस्म के ओलों का तूफ़ान भेज दूँगा। मिसरी क़ौम की इब्तिदा से लेकर आज तक मिसर में ओलों का ऐसा तूफ़ान कभी नहीं आया होगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","अपने बंदों को अभी भेजना ताकि वह तेरे मवेशियों को और खेतों में पड़े तेरे माल को लाकर महफ़ूज़ कर लें। क्योंकि जो भी खुले मैदान में रहेगा वह ओलों से मर जाएगा, ख़ाह इनसान हो या हैवान’।” ");
INSERT INTO urdgvh_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","फ़िरौन के कुछ ओहदेदार रब का पैग़ाम सुनकर डर गए और भागकर अपने जानवरों और ग़ुलामों को घरों में ले आए। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","लेकिन दूसरों ने रब के पैग़ाम की परवा न की। उनके जानवर और ग़ुलाम बाहर खुले मैदान में रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","रब ने मूसा से कहा, “अपना हाथ आसमान की तरफ़ बढ़ा दे। फिर मिसर के तमाम इनसानों, जानवरों और खेतों के पौदों पर ओले पड़ेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","मूसा ने अपनी लाठी आसमान की तरफ़ उठाई तो रब ने एक ज़बरदस्त तूफ़ान भेज दिया। ओले पड़े, बिजली गिरी और बादल गरजते रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ओले पड़ते रहे और बिजली चमकती रही। मिसरी क़ौम की इब्तिदा से लेकर अब तक ऐसे ख़तरनाक ओले कभी नहीं पड़े थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","इनसानों से लेकर हैवानों तक खेतों में सब कुछ बरबाद हो गया। ओलों ने खेतों में तमाम पौदे और दरख़्त भी तोड़ दिए। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","वह सिर्फ़ जुशन के इलाक़े में न पड़े जहाँ इसराईली आबाद थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","तब फ़िरौन ने मूसा और हारून को बुलाया। उसने कहा, “इस मरतबा मैंने गुनाह किया है। रब हक़ पर है। मुझसे और मेरी क़ौम से ग़लती हुई है। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ओले और अल्लाह की गरजती आवाज़ें हद से ज़्यादा हैं। रब से दुआ करो ताकि ओले रुक जाएँ। अब मैं तुम्हें जाने दूँगा। अब से तुम्हें यहाँ रहना नहीं पड़ेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मूसा ने फ़िरौन से कहा, “मैं शहर से निकलकर दोनों हाथ रब की तरफ़ उठाकर दुआ करूँगा। फिर गरज और ओले रुक जाएंगे और आप जान लेंगे कि पूरी दुनिया रब की है। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","लेकिन मैं जानता हूँ कि आप और आपके ओहदेदार अभी तक रब ख़ुदा का ख़ौफ़ नहीं मानते।” ");
INSERT INTO urdgvh_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","उस वक़्त सन के फूल निकल चुके थे और जौ की बालें लग गई थीं। इसलिए यह फ़सलें तबाह हो गईं। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","लेकिन गेहूँ और एक और क़िस्म की गंदुम जो बाद में पकती है बरबाद न हुई। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","मूसा फ़िरौन को छोड़कर शहर से निकला। उसने रब की तरफ़ अपने हाथ उठाए तो गरज, ओले और बारिश का तूफ़ान रुक गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","जब फ़िरौन ने देखा कि तूफ़ान ख़त्म हो गया है तो वह और उसके ओहदेदार दुबारा गुनाह करके अकड़ गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","फ़िरौन अड़ा रहा और इसराईलियों को जाने न दिया। वैसा ही हुआ जैसा रब ने मूसा से कहा था। ");
INSERT INTO urdgvh_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","फिर रब ने मूसा से कहा, “फ़िरौन के पास जा, क्योंकि मैंने उसका और उसके दरबारियों का दिल सख़्त कर दिया है ताकि उनके दरमियान अपने मोजिज़ों और अपनी क़ुदरत का इज़हार कर सकूँ ");
INSERT INTO urdgvh_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","और तुम अपने बेटे-बेटियों और पोते-पोतियों को सुना सको कि मैंने मिसरियों के साथ क्या सुलूक किया है और उनके दरमियान किस तरह के मोजिज़े करके अपनी क़ुदरत का इज़हार किया है। यों तुम जान लोगे कि मैं रब हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","मूसा और हारून फ़िरौन के पास गए। उन्होंने उससे कहा, “रब इबरानियों के ख़ुदा का फ़रमान है, ‘तू कब तक मेरे सामने हथियार डालने से इनकार करेगा? मेरी क़ौम को मेरी इबादत करने के लिए जाने दे, ");
INSERT INTO urdgvh_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","वरना मैं कल तेरे मुल्क में टिड्डियाँ लाऊँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","उनके ग़ोल ज़मीन पर यों छा जाएंगे कि ज़मीन नज़र ही नहीं आएगी। जो कुछ ओलों ने तबाह नहीं किया उसे वह चट कर जाएँगी। बचे हुए दरख़्तों के पत्ते भी ख़त्म हो जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","तेरे महल, तेरे ओहदेदारों और बाक़ी लोगों के घर उनसे भर जाएंगे। जब से मिसरी इस मुल्क में आबाद हुए हैं तुमने कभी टिड्डियों का ऐसा सख़्त हमला नहीं देखा होगा’।” यह कहकर मूसा पलटकर वहाँ से चला गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","इस पर दरबारियों ने फ़िरौन से बात की, “हम कब तक इस मर्द के जाल में फँसे रहें? इसराईलियों को रब अपने ख़ुदा की इबादत करने के लिए जाने दें। क्या आपको अभी तक मालूम नहीं कि मिसर बरबाद हो गया है?” ");
INSERT INTO urdgvh_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","तब मूसा और हारून को फ़िरौन के पास बुलाया गया। उसने उनसे कहा, “जाओ, अपने ख़ुदा की इबादत करो। लेकिन यह बताओ कि कौन कौन साथ जाएगा?” ");
INSERT INTO urdgvh_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मूसा ने जवाब दिया, “हमारे जवान और बूढ़े साथ जाएंगे। हम अपने बेटे-बेटियों, भेड़-बकरियों और गाय-बैलों को भी साथ लेकर जाएंगे। हम सबके सब जाएंगे, क्योंकि हमें रब की ईद मनानी है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","फ़िरौन ने तंज़न कहा, “ठीक है, जाओ और रब तुम्हारे साथ हो। नहीं, मैं किस तरह तुम सबको बाल-बच्चों समेत जाने दे सकता हूँ? तुमने कोई बुरा मनसूबा बनाया है। ");
INSERT INTO urdgvh_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","नहीं, सिर्फ़ मर्द जाकर रब की इबादत कर सकते हैं। तुमने तो यही दरख़ास्त की थी।” तब मूसा और हारून को फ़िरौन के सामने से निकाल दिया गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","फिर रब ने मूसा से कहा, “मिसर पर अपना हाथ उठा ताकि टिड्डियाँ आकर मिसर की सरज़मीन पर फैल जाएँ। जो कुछ भी खेतों में ओलों से बच गया है उसे वह खा जाएँगी।” ");
INSERT INTO urdgvh_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","मूसा ने अपनी लाठी मिसर पर उठाई तो रब ने मशरिक़ से आँधी चलाई जो सारा दिन और सारी रात चलती रही और अगली सुबह तक मिसर में टिड्डियाँ पहुँचाईं। ");
INSERT INTO urdgvh_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","बेशुमार टिड्डियाँ पूरे मुल्क पर हमला करके हर जगह बैठ गईं। इससे पहले या बाद में कभी भी टिड्डियों का इतना सख़्त हमला न हुआ था। ");
INSERT INTO urdgvh_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","उन्होंने ज़मीन को यों ढाँक लिया कि वह काली नज़र आने लगी। जो कुछ भी ओलों से बच गया था चाहे खेतों के पौदे या दरख़्तों के फल थे उन्होंने खा लिया। मिसर में एक भी दरख़्त या पौदा न रहा जिसके पत्ते बच गए हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","तब फ़िरौन ने मूसा और हारून को जल्दी से बुलवाया। उसने कहा, “मैंने तुम्हारे ख़ुदा का और तुम्हारा गुनाह किया है। ");
INSERT INTO urdgvh_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","अब एक और मरतबा मेरा गुनाह मुआफ़ करो और रब अपने ख़ुदा से दुआ करो ताकि मौत की यह हालत मुझसे दूर हो जाए।” ");
INSERT INTO urdgvh_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","मूसा ने महल से निकलकर रब से दुआ की। ");
INSERT INTO urdgvh_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","जवाब में रब ने हवा का रुख़ बदल दिया। उसने मग़रिब से तेज़ आँधी चलाई जिसने टिड्डियों को उड़ाकर बहरे-क़ुलज़ुम में डाल दिया। मिसर में एक भी टिड्डी न रही। ");
INSERT INTO urdgvh_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","लेकिन रब ने होने दिया कि फ़िरौन फिर अड़ गया। उसने इसराईलियों को जाने न दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","इसके बाद रब ने मूसा से कहा, “अपना हाथ आसमान की तरफ़ उठा तो मिसर पर अंधेरा छा जाएगा। इतना अंधेरा होगा कि बंदा उसे छू सकेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","मूसा ने अपना हाथ आसमान की तरफ़ उठाया तो तीन दिन तक मिसर पर गहरा अंधेरा छाया रहा। ");
INSERT INTO urdgvh_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","तीन दिन तक लोग न एक दूसरे को देख सके, न कहीं जा सके। लेकिन जहाँ इसराईली रहते थे वहाँ रौशनी थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","तब फ़िरौन ने मूसा को फिर बुलवाया और कहा, “जाओ, रब की इबादत करो! तुम अपने साथ बाल-बच्चों को भी ले जा सकते हो। सिर्फ़ अपनी भेड़-बकरियाँ और गाय-बैल पीछे छोड़ देना।” ");
INSERT INTO urdgvh_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","मूसा ने जवाब दिया, “क्या आप ही हमें क़ुरबानियों के लिए जानवर देंगे ताकि उन्हें रब अपने ख़ुदा को पेश करें? ");
INSERT INTO urdgvh_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","यक़ीनन नहीं। इसलिए लाज़िम है कि हम अपने जानवरों को साथ लेकर जाएँ। एक खुर भी पीछे नहीं छोड़ा जाएगा, क्योंकि अभी तक हमें मालूम नहीं कि रब की इबादत के लिए किन किन जानवरों की ज़रूरत होगी। यह उस वक़्त ही पता चलेगा जब हम मनज़िले-मक़सूद पर पहुँचेंगे। इसलिए ज़रूरी है कि हम सबको अपने साथ लेकर जाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","लेकिन रब की मरज़ी के मुताबिक़ फ़िरौन अड़ गया। उसने उन्हें जाने न दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","उसने मूसा से कहा, “दफ़ा हो जा। ख़बरदार! फिर कभी अपनी शक्ल न दिखाना, वरना तुझे मौत के हवाले कर दिया जाएगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","मूसा ने कहा, “ठीक है, आपकी मरज़ी। मैं फिर कभी आपके सामने नहीं आऊँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","तब रब ने मूसा से कहा, “अब मैं फ़िरौन और मिसर पर आख़िरी आफ़त लाने को हूँ। इसके बाद वह तुम्हें जाने देगा बल्कि तुम्हें ज़बरदस्ती निकाल देगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","इसराईलियों को बता देना कि हर मर्द अपने पड़ोसी और हर औरत अपनी पड़ोसन से सोने-चाँदी की चीज़ें माँग ले।” ");
INSERT INTO urdgvh_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(रब ने मिसरियों के दिल इसराईलियों की तरफ़ मायल कर दिए थे। वह फ़िरौन के ओहदेदारों समेत ख़ासकर मूसा की बड़ी इज़्ज़त करते थे)। ");
INSERT INTO urdgvh_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","मूसा ने कहा, “रब फ़रमाता है, ‘आज आधी रात के वक़्त मैं मिसर में से गुज़रूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","तब बादशाह के पहलौठे से लेकर चक्की पीसनेवाली नौकरानी के पहलौठे तक मिसरियों का हर पहलौठा मर जाएगा। चौपाइयों के पहलौठे भी मर जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","मिसर की सरज़मीन पर ऐसा रोना पीटना होगा कि न माज़ी में कभी हुआ, न मुस्तक़बिल में कभी होगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","लेकिन इसराईली और उनके जानवर बचे रहेंगे। कुत्ता भी उन पर नहीं भौंकेगा। इस तरह तुम जान लोगे कि रब इसराईलियों की निसबत मिसरियों से फ़रक़ सुलूक करता है’।” ");
INSERT INTO urdgvh_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","मूसा ने यह कुछ फ़िरौन को बताया फिर कहा, “उस वक़्त आपके तमाम ओहदेदार आकर मेरे सामने झुक जाएंगे और मिन्नत करेंगे, ‘अपने पैरोकारों के साथ चले जाएँ।’ तब मैं चला ही जाऊँगा।” यह कहकर मूसा फ़िरौन के पास से चला गया। वह बड़े ग़ुस्से में था। ");
INSERT INTO urdgvh_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","रब ने मूसा से कहा था, “फ़िरौन तुम्हारी नहीं सुनेगा। क्योंकि लाज़िम है कि मैं मिसर में अपनी क़ुदरत का मज़ीद इज़हार करूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","गो मूसा और हारून ने फ़िरौन के सामने यह तमाम मोजिज़े दिखाए, लेकिन रब ने फ़िरौन को ज़िद्दी बनाए रखा, इसलिए उसने इसराईलियों को मुल्क छोड़ने न दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","फिर रब ने मिसर में मूसा और हारून से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“अब से यह महीना तुम्हारे लिए साल का पहला महीना हो।” ");
INSERT INTO urdgvh_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","इसराईल की पूरी जमात को बताना कि इस महीने के दसवें दिन हर ख़ानदान का सरपरस्त अपने घराने के लिए लेला यानी भेड़ या बकरी का बच्चा हासिल करे। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","अगर घराने के अफ़राद पूरा जानवर खाने के लिए कम हों तो वह अपने सबसे क़रीबी पड़ोसी के साथ मिलकर लेला हासिल करें। इतने लोग उसमें से खाएँ कि सबके लिए काफ़ी हो और पूरा जानवर खाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","इसके लिए एक साल का नर बच्चा चुन लेना जिसमें नुक़्स न हो। वह भेड़ या बकरी का बच्चा हो सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","महीने के 14वें दिन तक उस की देख-भाल करो। उस दिन तमाम इसराईली सूरज के ग़ुरूब होते वक़्त अपने लेले ज़बह करें। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","हर ख़ानदान अपने जानवर का कुछ ख़ून जमा करके उसे उस घर के दरवाज़े की चौखट पर लगाए जहाँ लेला खाया जाएगा। यह ख़ून चौखट के ऊपरवाले हिस्से और दाएँ बाएँ के बाज़ुओं पर लगाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","लाज़िम है कि लोग जानवर को भूनकर उसी रात खाएँ। साथ ही वह कड़वा साग-पात और बेख़मीरी रोटियाँ भी खाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","लेले का गोश्त कच्चा न खाना, न उसे पानी में उबालना बल्कि पूरे जानवर को सर, पैरों और अंदरूनी हिस्सों समेत आग पर भूनना। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","लाज़िम है कि पूरा गोश्त उसी रात खाया जाए। अगर कुछ सुबह तक बच जाए तो उसे जलाना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","खाना खाते वक़्त ऐसा लिबास पहनना जैसे तुम सफ़र पर जा रहे हो। अपने जूते पहने रखना और हाथ में सफ़र के लिए लाठी लिए हुए तुम उसे जल्दी जल्दी खाना। रब के फ़सह की ईद यों मनाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","मैं आज रात मिसर में से गुज़रूँगा और हर पहलौठे को जान से मार दूँगा, ख़ाह इनसान का हो या हैवान का। यों मैं जो रब हूँ मिसर के तमाम देवताओं की अदालत करूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","लेकिन तुम्हारे घरों पर लगा हुआ ख़ून तुम्हारा ख़ास निशान होगा। जिस जिस घर के दरवाज़े पर मैं वह ख़ून देखूँगा उसे छोड़ता जाऊँगा। जब मैं मिसर पर हमला करूँगा तो मोहलक वबा तुम तक नहीं पहुँचेगी। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","आज की रात को हमेशा याद रखना। इसे नसल-दर-नसल और हर साल रब की ख़ास ईद के तौर पर मनाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","सात दिन तक बेख़मीरी रोटी खाना है। पहले दिन अपने घरों से तमाम ख़मीर निकाल देना। अगर कोई इन सात दिनों के दौरान ख़मीर खाए तो उसे क़ौम में से मिटाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","इस ईद के पहले और आख़िरी दिन मुक़द्दस इजतिमा मुनअक़िद करना। इन तमाम दिनों के दौरान काम न करना। सिर्फ़ एक काम की इजाज़त है और वह है अपना खाना तैयार करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","बेख़मीरी रोटी की ईद मनाना लाज़िम है, क्योंकि उस दिन मैं तुम्हारे मुतअद्दिद ख़ानदानों को मिसर से निकाल लाया। इसलिए यह दिन नसल-दर-नसल हर साल याद रखना। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","पहले महीने के 14वें दिन की शाम से लेकर 21वें दिन की शाम तक सिर्फ़ बेख़मीरी रोटी खाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","सात दिन तक तुम्हारे घरों में ख़मीर न पाया जाए। जो भी इस दौरान ख़मीर खाए उसे इसराईल की जमात में से मिटाया जाए, ख़ाह वह इसराईली शहरी हो या अजनबी। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ग़रज़, इस ईद के दौरान ख़मीर न खाना। जहाँ भी तुम रहते हो वहाँ बेख़मीरी रोटी ही खाना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","फिर मूसा ने तमाम इसराईली बुज़ुर्गों को बुलाकर उनसे कहा, “जाओ, अपने ख़ानदानों के लिए भेड़ या बकरी के बच्चे चुनकर उन्हें फ़सह की ईद के लिए ज़बह करो। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ज़ूफ़े का गुच्छा लेकर उसे ख़ून से भरे हुए बासन में डुबो देना। फिर उसे लेकर ख़ून को चौखट के ऊपरवाले हिस्से और दाएँ बाएँ के बाज़ुओं पर लगा देना। सुबह तक कोई अपने घर से न निकले। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","जब रब मिसरियों को मार डालने के लिए मुल्क में से गुज़रेगा तो वह चौखट के ऊपरवाले हिस्से और दाएँ बाएँ के बाज़ुओं पर लगा हुआ ख़ून देखकर उन घरों को छोड़ देगा। वह हलाक करनेवाले फ़रिश्ते को इजाज़त नहीं देगा कि वह तुम्हारे घरों में जाकर तुम्हें हलाक करे। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","तुम अपनी औलाद समेत हमेशा इन हिदायात पर अमल करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","यह रस्म उस वक़्त भी अदा करना जब तुम उस मुल्क में पहुँचोगे जो रब तुम्हें देगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","और जब तुम्हारे बच्चे तुमसे पूछें कि हम यह ईद क्यों मनाते हैं ");
INSERT INTO urdgvh_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","तो उनसे कहो, ‘यह फ़सह की क़ुरबानी है जो हम रब को पेश करते हैं। क्योंकि जब रब मिसरियों को हलाक कर रहा था तो उसने हमारे घरों को छोड़ दिया था’।” यह सुनकर इसराईलियों ने अल्लाह को सिजदा किया। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","फिर उन्होंने सब कुछ वैसा ही किया जैसा रब ने मूसा और हारून को बताया था। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","आधी रात को रब ने बादशाह के पहलौठे से लेकर जेल के क़ैदी के पहलौठे तक मिसरियों के तमाम पहलौठों को जान से मार दिया। चौपाइयों के पहलौठे भी मर गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","उस रात मिसर के हर घर में कोई न कोई मर गया। फ़िरौन, उसके ओहदेदार और मिसर के तमाम लोग जाग उठे और ज़ोर ज़ोर से रोने और चीख़ने लगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","अभी रात थी कि फ़िरौन ने मूसा और हारून को बुलाकर कहा, “अब तुम और बाक़ी इसराईली मेरी क़ौम में से निकल जाओ। अपनी दरख़ास्त के मुताबिक़ रब की इबादत करो। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","जिस तरह तुम चाहते हो अपनी भेड़-बकरियों को भी अपने साथ ले जाओ। और मुझे भी बरकत देना।” ");
INSERT INTO urdgvh_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","बाक़ी मिसरियों ने भी इसराईलियों पर ज़ोर देकर कहा, “जल्दी जल्दी मुल्क से निकल जाओ, वरना हम सब मर जाएंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","इसराईलियों के गूँधे हुए आटे में ख़मीर नहीं था। उन्होंने उसे गूँधने के बरतनों में रखकर अपने कपड़ों में लपेट लिया और सफ़र करते वक़्त अपने कंधों पर रख लिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","इसराईली मूसा की हिदायत पर अमल करके अपने मिसरी पड़ोसियों के पास गए और उनसे कपड़े और सोने-चाँदी की चीज़ें माँगीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","रब ने मिसरियों के दिलों को इसराईलियों की तरफ़ मायल कर दिया था, इसलिए उन्होंने उनकी हर दरख़ास्त पूरी की। यों इसराईलियों ने मिसरियों को लूट लिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","इसराईली रामसीस से रवाना होकर सुक्कात पहुँच गए। औरतों और बच्चों को छोड़कर उनके 6 लाख मर्द थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","वह अपने भेड़-बकरियों और गाय-बैलों के बड़े बड़े रेवड़ भी साथ ले गए। बहुत-से ऐसे लोग भी उनके साथ निकले जो इसराईली नहीं थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","रास्ते में उन्होंने उस बेख़मीरी आटे से रोटियाँ बनाईं जो वह साथ लेकर निकले थे। आटे में इसलिए ख़मीर नहीं था कि उन्हें इतनी जल्दी से मिसर से निकाल दिया गया था कि खाना तैयार करने का वक़्त ही न मिला था। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","इसराईली 430 साल तक मिसर में रहे थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","430 साल के ऐन बाद, उसी दिन रब के यह तमाम ख़ानदान मिसर से निकले। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","उस ख़ास रात रब ने ख़ुद पहरा दिया ताकि इसराईली मिसर से निकल सकें। इसलिए तमाम इसराईलियों के लिए लाज़िम है कि वह नसल-दर-नसल इस रात रब की ताज़ीम में जागते रहें, वह भी और उनके बाद की औलाद भी। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","रब ने मूसा और हारून से कहा, “फ़सह की ईद के यह उसूल हैं : किसी भी परदेसी को फ़सह की ईद का खाना खाने की इजाज़त नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","अगर तुमने किसी ग़ुलाम को ख़रीदकर उसका ख़तना किया है तो वह फ़सह का खाना खा सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","लेकिन ग़ैरशहरी या मज़दूर को फ़सह का खाना खाने की इजाज़त नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","यह खाना एक ही घर के अंदर खाना है। न गोश्त घर से बाहर ले जाना, न लेले की किसी हड्डी को तोड़ना। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","लाज़िम है कि इसराईल की पूरी जमात यह ईद मनाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","अगर कोई परदेसी तुम्हारे साथ रहता है जो फ़सह की ईद में शिरकत करना चाहे तो लाज़िम है कि पहले उसके घराने के हर मर्द का ख़तना किया जाए। तब वह इसराईली की तरह खाने में शरीक हो सकता है। लेकिन जिसका ख़तना न हुआ उसे फ़सह का खाना खाने की इजाज़त नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","यही उसूल हर एक पर लागू होगा, ख़ाह वह इसराईली हो या परदेसी।” ");
INSERT INTO urdgvh_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","तमाम इसराईलियों ने वैसा ही किया जैसा रब ने मूसा और हारून से कहा था। ");
INSERT INTO urdgvh_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","उसी दिन रब तमाम इसराईलियों को ख़ानदानों की तरतीब के मुताबिक़ मिसर से निकाल लाया। ");
INSERT INTO urdgvh_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“इसराईलियों के हर पहलौठे को मेरे लिए मख़सूसो-मुक़द्दस करना है। हर पहला नर बच्चा मेरा ही है, ख़ाह इनसान का हो या हैवान का।” ");
INSERT INTO urdgvh_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","फिर मूसा ने लोगों से कहा, “इस दिन को याद रखो जब तुम रब की अज़ीम क़ुदरत के बाइस मिसर की ग़ुलामी से निकले। इस दिन कोई चीज़ न खाना जिसमें ख़मीर हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","आज ही अबीब के महीने में तुम मिसर से रवाना हो रहे हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","रब ने तुम्हारे बापदादा से क़सम खाकर वादा किया है कि वह तुमको कनानी, हित्ती, अमोरी, हिव्वी और यबूसी क़ौमों का मुल्क देगा, एक ऐसा मुल्क जिसमें दूध और शहद की कसरत है। जब रब तुम्हें उस मुल्क में पहुँचा देगा तो लाज़िम है कि तुम इसी महीने में यह रस्म मनाओ। ");
INSERT INTO urdgvh_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","सात दिन बेख़मीरी रोटी खाओ। सातवें दिन रब की ताज़ीम में ईद मनाओ। ");
INSERT INTO urdgvh_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","सात दिन ख़मीरी रोटी न खाना। कहीं भी ख़मीर न पाया जाए। पूरे मुल्क में ख़मीर का नामो-निशान तक न हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","उस दिन अपने बेटे से यह कहो, ‘मैं यह ईद उस काम की ख़ुशी में मनाता हूँ जो रब ने मेरे लिए किया जब मैं मिसर से निकला।’ ");
INSERT INTO urdgvh_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","यह ईद तुम्हारे हाथ या पेशानी पर निशान की मानिंद हो जो तुम्हें याद दिलाए कि रब की शरीअत को तुम्हारे होंटों पर रहना है। क्योंकि रब तुम्हें अपनी अज़ीम क़ुदरत से मिसर से निकाल लाया। ");
INSERT INTO urdgvh_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","इस दिन की याद हर साल ठीक वक़्त पर मनाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","रब तुम्हें कनानियों के उस मुल्क में ले जाएगा जिसका वादा उसने क़सम खाकर तुम और तुम्हारे बापदादा से किया है। ");
INSERT INTO urdgvh_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","लाज़िम है कि वहाँ पहुँचकर तुम अपने तमाम पहलौठों को रब के लिए मख़सूस करो। तुम्हारे मवेशियों के तमाम पहलौठे भी रब की मिलकियत हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","अगर तुम अपना पहलौठा गधा ख़ुद रखना चाहो तो रब को उसके बदले भेड़ या बकरी का बच्चा पेश करो। लेकिन अगर तुम उसे रखना नहीं चाहते तो उस की गरदन तोड़ डालो। लेकिन इनसान के पहलौठों के लिए हर सूरत में एवज़ी देना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","आनेवाले दिनों में जब तुम्हारा बेटा पूछे कि इसका क्या मतलब है तो उसे जवाब देना, ‘रब अपनी अज़ीम क़ुदरत से हमें मिसर की ग़ुलामी से निकाल लाया। ");
INSERT INTO urdgvh_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","जब फ़िरौन ने अकड़कर हमें जाने न दिया तो रब ने मिसर के तमाम इनसानों और हैवानों के पहलौठों को मार डाला। इस वजह से मैं अपने जानवरों का हर पहला बच्चा रब को क़ुरबान करता और अपने हर पहलौठे के लिए एवज़ी देता हूँ’। ");
INSERT INTO urdgvh_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","यह दस्तूर तुम्हारे हाथ और पेशानी पर निशान की मानिंद हो जो तुम्हें याद दिलाए कि रब हमें अपनी क़ुदरत से मिसर से निकाल लाया।” ");
INSERT INTO urdgvh_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","जब फ़िरौन ने इसराईली क़ौम को जाने दिया तो अल्लाह उन्हें फ़िलिस्तियों के इलाक़े में से गुज़रनेवाले रास्ते से लेकर न गया, अगरचे उस पर चलते हुए वह जल्द ही मुल्के-कनान पहुँच जाते। बल्कि रब ने कहा, “अगर उस रास्ते पर चलेंगे तो उन्हें दूसरों से लड़ना पड़ेगा। ऐसा न हो कि वह इस वजह से अपना इरादा बदलकर मिसर लौट जाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","इसलिए अल्लाह उन्हें दूसरे रास्ते से लेकर गया, और वह रेगिस्तान के रास्ते से बहरे-क़ुलज़ुम की तरफ़ बढ़े। मिसर से निकलते वक़्त मर्द मुसल्लह थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","मूसा यूसुफ़ का ताबूत भी अपने साथ ले गया, क्योंकि यूसुफ़ ने इसराईलियों को क़सम दिलाकर कहा था, “अल्लाह यक़ीनन तुम्हारी देख-भाल करके वहाँ ले जाएगा। उस वक़्त मेरी हड्डियों को भी उठाकर साथ ले जाना।” ");
INSERT INTO urdgvh_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","इसराईलियों ने सुक्कात को छोड़कर एताम में अपने ख़ैमे लगाए। एताम रेगिस्तान के किनारे पर था। ");
INSERT INTO urdgvh_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","रब उनके आगे आगे चलता गया, दिन के वक़्त बादल के सतून में ताकि उन्हें रास्ते का पता लगे और रात के वक़्त आग के सतून में ताकि उन्हें रौशनी मिले। यों वह दिन और रात सफ़र कर सकते थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","दिन के वक़्त बादल का सतून और रात के वक़्त आग का सतून उनके सामने रहा। वह कभी भी अपनी जगह से न हटा। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","तब रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“इसराईलियों को कह देना कि वह पीछे मुड़कर मिजदाल और समुंदर के बीच यानी फ़ी-हख़ीरोत के नज़दीक रुक जाएँ। वह बाल-सफ़ोन के मुक़ाबिल साहिल पर अपने ख़ैमे लगाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","यह देखकर फ़िरौन समझेगा कि इसराईली रास्ता भूलकर आवारा फिर रहे हैं और कि रेगिस्तान ने चारों तरफ़ उन्हें घेर रखा है। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","फिर मैं फ़िरौन को दुबारा अड़ जाने दूँगा, और वह इसराईलियों का पीछा करेगा। लेकिन मैं फ़िरौन और उस की पूरी फ़ौज पर अपना जलाल ज़ाहिर करूँगा। मिसरी जान लेंगे कि मैं ही रब हूँ।” इसराईलियों ने ऐसा ही किया। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","जब मिसर के बादशाह को इत्तला दी गई कि इसराईली हिजरत कर गए हैं तो उसने और उसके दरबारियों ने अपना ख़याल बदलकर कहा, “हमने क्या किया है? हमने उन्हें जाने दिया है, और अब हम उनकी ख़िदमत से महरूम हो गए हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","चुनाँचे बादशाह ने अपना जंगी रथ तैयार करवाया और अपनी फ़ौज को लेकर निकला। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","वह 600 बेहतरीन क़िस्म के रथ और मिसर के बाक़ी तमाम रथों को साथ ले गया। तमाम रथों पर अफ़सरान मुक़र्रर थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","रब ने मिसर के बादशाह फ़िरौन को दुबारा अड़ जाने दिया था, इसलिए जब इसराईली बड़े इख़्तियार के साथ निकल रहे थे तो वह उनका ताक़्क़ुब करने लगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","इसराईलियों का पीछा करते करते फ़िरौन के तमाम घोड़े, रथ, सवार और फ़ौजी उनके क़रीब पहुँचे। इसराईली बहरे-क़ुलज़ुम के साहिल पर बाल-सफ़ोन के मुक़ाबिल फ़ी-हख़ीरोत के नज़दीक ख़ैमे लगा चुके थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","जब इसराईलियों ने फ़िरौन और उस की फ़ौज को अपनी तरफ़ बढ़ते देखा तो वह सख़्त घबरा गए और मदद के लिए रब के सामने चीख़ने-चिल्लाने लगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","उन्होंने मूसा से कहा, “क्या मिसर में क़ब्रों की कमी थी कि आप हमें रेगिस्तान में ले आए हैं? हमें मिसर से निकालकर आपने हमारे साथ क्या किया है? ");
INSERT INTO urdgvh_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","क्या हमने मिसर में आपसे दरख़ास्त नहीं की थी कि मेहरबानी करके हमें छोड़ दें, हमें मिसरियों की ख़िदमत करने दें? यहाँ आकर रेगिस्तान में मर जाने की निसबत बेहतर होता कि हम मिसरियों के ग़ुलाम रहते।” ");
INSERT INTO urdgvh_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","लेकिन मूसा ने जवाब दिया, “मत घबराओ। आराम से खड़े रहो और देखो कि रब तुम्हें आज किस तरह बचाएगा। आज के बाद तुम इन मिसरियों को फिर कभी नहीं देखोगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","रब तुम्हारे लिए लड़ेगा। तुम्हें बस, चुप रहना है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","फिर रब ने मूसा से कहा, “तू मेरे सामने क्यों चीख़ रहा है? इसराईलियों को आगे बढ़ने का हुक्म दे। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","अपनी लाठी को पकड़कर उसे समुंदर के ऊपर उठा तो वह दो हिस्सों में बट जाएगा। इसराईली ख़ुश्क ज़मीन पर समुंदर में से गुज़रेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","मैं मिसरियों को अड़े रहने दूँगा ताकि वह इसराईलियों का पीछा करें। फिर मैं फ़िरौन, उस की सारी फ़ौज, उसके रथों और उसके सवारों पर अपना जलाल ज़ाहिर करूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","जब मैं फ़िरौन, उसके रथों और उसके सवारों पर अपना जलाल ज़ाहिर करूँगा तो मिसरी जान लेंगे कि मैं ही रब हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","अल्लाह का फ़रिश्ता इसराईली लशकर के आगे आगे चल रहा था। अब वह वहाँ से हटकर उनके पीछे खड़ा हो गया। बादल का सतून भी लोगों के आगे से हटकर उनके पीछे जा खड़ा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","इस तरह बादल मिसरियों और इसराईलियों के लशकरों के दरमियान आ गया। पूरी रात मिसरियों की तरफ़ अंधेरा ही अंधेरा था जबकि इसराईलियों की तरफ़ रौशनी थी। इसलिए मिसरी पूरी रात के दौरान इसराईलियों के क़रीब न आ सके। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","मूसा ने अपना हाथ समुंदर के ऊपर उठाया तो रब ने मशरिक़ से तेज़ आँधी चलाई। आँधी तमाम रात चलती रही। उसने समुंदर को पीछे हटाकर उस की तह ख़ुश्क कर दी। समुंदर दो हिस्सों में बट गया ");
INSERT INTO urdgvh_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","तो इसराईली समुंदर में से ख़ुश्क ज़मीन पर चलते हुए गुज़र गए। उनके दाईं और बाईं तरफ़ पानी दीवार की तरह खड़ा रहा। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","जब मिसरियों को पता चला तो फ़िरौन के तमाम घोड़े, रथ और घुड़सवार भी उनके पीछे पीछे समुंदर में चले गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","सुबह-सवेरे ही रब ने बादल और आग के सतून से मिसर की फ़ौज पर निगाह की और उसमें अबतरी पैदा कर दी। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","उनके रथों के पहिये निकल गए तो उन पर क़ाबू पाना मुश्किल हो गया। मिसरियों ने कहा, “आओ, हम इसराईलियों से भाग जाएँ, क्योंकि रब उनके साथ है। वही मिसर का मुक़ाबला कर रहा है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","तब रब ने मूसा से कहा, “अपना हाथ समुंदर के ऊपर उठा। फिर पानी वापस आकर मिसरियों, उनके रथों और घुड़सवारों को डुबो देगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","मूसा ने अपना हाथ समुंदर के ऊपर उठाया तो दिन निकलते वक़्त पानी मामूल के मुताबिक़ बहने लगा, और जिस तरफ़ मिसरी भाग रहे थे वहाँ पानी ही पानी था। यों रब ने उन्हें समुंदर में बहाकर ग़रक़ कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","पानी वापस आ गया। उसने रथों और घुड़सवारों को ढाँक लिया। फ़िरौन की पूरी फ़ौज जो इसराईलियों का ताक़्क़ुब कर रही थी डूबकर तबाह हो गई। उनमें से एक भी न बचा। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","लेकिन इसराईली ख़ुश्क ज़मीन पर समुंदर में से गुज़रे। उनके दाईं और बाईं तरफ़ पानी दीवार की तरह खड़ा रहा। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","उस दिन रब ने इसराईलियों को मिसरियों से बचाया। मिसरियों की लाशें उन्हें साहिल पर नज़र आईं। ");
INSERT INTO urdgvh_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","जब इसराईलियों ने रब की यह अज़ीम क़ुदरत देखी जो उसने मिसरियों पर ज़ाहिर की थी तो रब का ख़ौफ़ उन पर छा गया। वह उस पर और उसके ख़ादिम मूसा पर एतमाद करने लगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","तब मूसा और इसराईलियों ने रब के लिए यह गीत गाया, “मैं रब की तमजीद में गीत गाऊँगा, क्योंकि वह निहायत अज़ीम है। घोड़े और उसके सवार को उसने समुंदर में पटख़ दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","रब मेरी क़ुव्वत और मेरा गीत है, वह मेरी नजात बन गया है। वही मेरा ख़ुदा है, और मैं उस की तारीफ़ करूँगा। वही मेरे बाप का ख़ुदा है, और मैं उस की ताज़ीम करूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","रब सूरमा है, रब उसका नाम है। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","फ़िरौन के रथों और फ़ौज को उसने समुंदर में पटख़ दिया तो बादशाह के बेहतरीन अफ़सरान बहरे-क़ुलज़ुम में डूब गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","गहरे पानी ने उन्हें ढाँक लिया, और वह पत्थर की तरह समुंदर की तह तक उतर गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","ऐ रब, तेरे दहने हाथ का जलाल बड़ी क़ुदरत से ज़ाहिर होता है। ऐ रब, तेरा दहना हाथ दुश्मन को चकनाचूर कर देता है। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","जो तेरे ख़िलाफ़ उठ खड़े होते हैं उन्हें तू अपनी अज़मत का इज़हार करके ज़मीन पर पटख़ देता है। तेरा ग़ज़ब उन पर आन पड़ता है तो वह आग में भूसे की तरह जल जाते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","तूने ग़ुस्से में आकर फूँक मारी तो पानी ढेर की सूरत में जमा हो गया। बहता पानी ठोस दीवार बन गया, समुंदर गहराई तक जम गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","दुश्मन ने डींग मारकर कहा, ‘मैं उनका पीछा करके उन्हें पकड़ लूँगा, मैं उनका लूटा हुआ माल तक़सीम करूँगा। मेरी लालची जान उनसे सेर हो जाएगी, मैं अपनी तलवार खींचकर उन्हें हलाक करूँगा।’ ");
INSERT INTO urdgvh_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","लेकिन तूने उन पर फूँक मारी तो समुंदर ने उन्हें ढाँक लिया, और वह सीसे की तरह ज़ोरदार मौजों में डूब गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","ऐ रब, कौन-सा माबूद तेरी मानिंद है? कौन तेरी तरह जलाली और क़ुद्दूस है? कौन तेरी तरह हैरतअंगेज़ काम करता और अज़ीम मोजिज़े दिखाता है? कोई भी नहीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","तूने अपना दहना हाथ उठाया तो ज़मीन हमारे दुश्मनों को निगल गई। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","अपनी शफ़क़त से तूने एवज़ाना देकर अपनी क़ौम को छुटकारा दिया और उस की राहनुमाई की है, अपनी क़ुदरत से तूने उसे अपनी मुक़द्दस सुकूनतगाह तक पहुँचाया है। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","यह सुनकर दीगर क़ौमें काँप उठीं, फ़िलिस्ती डर के मारे पेचो-ताब खाने लगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","अदोम के रईस सहम गए, मोआब के राहनुमाओं पर कपकपी तारी हो गई, और कनान के तमाम बाशिंदे हिम्मत हार गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","दहशत और ख़ौफ़ उन पर छा गया। तेरी अज़ीम क़ुदरत के बाइस वह पत्थर की तरह जम गए। ऐ रब, वह न हिले जब तक तेरी क़ौम गुज़र न गई। वह बेहिसो-हरकत रहे जब तक तेरी ख़रीदी हुई क़ौम गुज़र न गई। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ऐ रब, तू अपने लोगों को लेकर पौदों की तरह अपने मौरूसी पहाड़ पर लगाएगा, उस जगह पर जो तूने अपनी सुकूनत के लिए चुन ली है, जहाँ तूने अपने हाथों से अपना मक़दिस तैयार किया है। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","रब अबद तक बादशाह है!” ");
INSERT INTO urdgvh_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","जब फ़िरौन के घोड़े, रथ और घुड़सवार समुंदर में चले गए तो रब ने उन्हें समुंदर के पानी से ढाँक लिया। लेकिन इसराईली ख़ुश्क ज़मीन पर समुंदर में से गुज़र गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","तब हारून की बहन मरियम जो नबिया थी ने दफ़ लिया, और बाक़ी तमाम औरतें भी दफ़ लेकर उसके पीछे हो लीं। सब गाने और नाचने लगीं। मरियम ने यह गाकर उनकी राहनुमाई की, ");
INSERT INTO urdgvh_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","“रब की तमजीद में गीत गाओ, क्योंकि वह निहायत अज़ीम है। घोड़े और उसके सवार को उसने समुंदर में पटख़ दिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","मूसा के कहने पर इसराईली बहरे-क़ुलज़ुम से रवाना होकर दश्ते-शूर में चले गए। वहाँ वह तीन दिन तक सफ़र करते रहे। इस दौरान उन्हें पानी न मिला। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","आख़िरकार वह मारा पहुँचे जहाँ पानी दस्तयाब था। लेकिन वह कड़वा था, इसलिए मक़ाम का नाम मारा यानी कड़वाहट पड़ गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","यह देखकर लोग मूसा के ख़िलाफ़ बुड़बुड़ाकर कहने लगे, “हम क्या पिएँ?” ");
INSERT INTO urdgvh_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","मूसा ने मदद के लिए रब से इल्तिजा की तो उसने उसे लकड़ी का एक टुकड़ा दिखाया। जब मूसा ने यह लकड़ी पानी में डाली तो पानी की कड़वाहट ख़त्म हो गई। मारा में रब ने अपनी क़ौम को क़वानीन दिए। वहाँ उसने उन्हें आज़माया भी। ");
INSERT INTO urdgvh_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","उसने कहा, “ग़ौर से रब अपने ख़ुदा की आवाज़ सुनो! जो कुछ उस की नज़र में दुरुस्त है वही करो। उसके अहकाम पर ध्यान दो और उस की तमाम हिदायात पर अमल करो। फिर मैं तुम पर वह बीमारियाँ नहीं लाऊँगा जो मिसरियों पर लाया था, क्योंकि मैं रब हूँ जो तुझे शफ़ा देता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","फिर इसराईली रवाना होकर एलीम पहुँचे जहाँ 12 चश्मे और खजूर के 70 दरख़्त थे। वहाँ उन्होंने पानी के क़रीब अपने ख़ैमे लगाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","इसके बाद इसराईल की पूरी जमात एलीम से सफ़र करके सीन के रेगिस्तान में पहुँची जो एलीम और सीना के दरमियान है। वह मिसर से निकलने के बाद दूसरे महीने के 15वें दिन पहुँचे। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","रेगिस्तान में तमाम लोग फिर मूसा और हारून के ख़िलाफ़ बुड़बुड़ाने लगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","उन्होंने कहा, “काश रब हमें मिसर में ही मार डालता! वहाँ हम कम अज़ कम जी भरकर गोश्त और रोटी तो खा सकते थे। आप हमें सिर्फ़ इसलिए रेगिस्तान में ले आए हैं कि हम सब भूके मर जाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","तब रब ने मूसा से कहा, “मैं आसमान से तुम्हारे लिए रोटी बरसाऊँगा। हर रोज़ लोग बाहर जाकर उसी दिन की ज़रूरत के मुताबिक़ खाना जमा करें। इससे मैं उन्हें आज़माकर देखूँगा कि आया वह मेरी सुनते हैं कि नहीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","हर रोज़ वह सिर्फ़ उतना खाना जमा करें जितना कि एक दिन के लिए काफ़ी हो। लेकिन छटे दिन जब वह खाना तैयार करेंगे तो वह अगले दिन के लिए भी काफ़ी होगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","मूसा और हारून ने इसराईलियों से कहा, “आज शाम को तुम जान लोगे कि रब ही तुम्हें मिसर से निकाल लाया है। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","और कल सुबह तुम रब का जलाल देखोगे। उसने तुम्हारी शिकायतें सुन ली हैं, क्योंकि असल में तुम हमारे ख़िलाफ़ नहीं बल्कि रब के ख़िलाफ़ बुड़बुड़ा रहे हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","फिर भी रब तुमको शाम के वक़्त गोश्त और सुबह के वक़्त वाफ़िर रोटी देगा, क्योंकि उसने तुम्हारी शिकायतें सुन ली हैं। तुम्हारी शिकायतें हमारे ख़िलाफ़ नहीं बल्कि रब के ख़िलाफ़ हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","मूसा ने हारून से कहा, “इसराईलियों को बताना, ‘रब के सामने हाज़िर हो जाओ, क्योंकि उसने तुम्हारी शिकायतें सुन ली हैं’।” ");
INSERT INTO urdgvh_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","जब हारून पूरी जमात के सामने बात करने लगा तो लोगों ने पलटकर रेगिस्तान की तरफ़ देखा। वहाँ रब का जलाल बादल में ज़ाहिर हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“मैंने इसराईलियों की शिकायत सुन ली है। उन्हें बता, ‘आज जब सूरज ग़ुरूब होने लगेगा तो तुम गोश्त खाओगे और कल सुबह पेट भरकर रोटी। फिर तुम जान लोगे कि मैं रब तुम्हारा ख़ुदा हूँ’।” ");
INSERT INTO urdgvh_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","उसी शाम बटेरों के ग़ोल आए जो पूरी ख़ैमागाह पर छा गए। और अगली सुबह ख़ैमे के चारों तरफ़ ओस पड़ी थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","जब ओस सूख गई तो बर्फ़ के गालों जैसे पतले दाने पाले की तरह ज़मीन पर पड़े थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","जब इसराईलियों ने उसे देखा तो एक दूसरे से पूछने लगे, “मन हू?” यानी “यह क्या है?” क्योंकि वह नहीं जानते थे कि यह क्या चीज़ है। मूसा ने उनको समझाया, “यह वह रोटी है जो रब ने तुम्हें खाने के लिए दी है। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","रब का हुक्म है कि हर एक उतना जमा करे जितना उसके ख़ानदान को ज़रूरत हो। अपने ख़ानदान के हर फ़रद के लिए दो लिटर जमा करो।” ");
INSERT INTO urdgvh_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","इसराईलियों ने ऐसा ही किया। बाज़ ने ज़्यादा और बाज़ ने कम जमा किया। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","लेकिन जब उसे नापा गया तो हर एक आदमी के लिए काफ़ी था। जिसने ज़्यादा जमा किया था उसके पास कुछ न बचा। लेकिन जिसने कम जमा किया था उसके पास भी काफ़ी था। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","मूसा ने हुक्म दिया, “अगले दिन के लिए खाना न बचाना।” ");
INSERT INTO urdgvh_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","लेकिन लोगों ने मूसा की बात न मानी बल्कि बाज़ ने खाना बचा लिया। लेकिन अगली सुबह मालूम हुआ कि बचे हुए खाने में कीड़े पड़ गए हैं और उससे बहुत बदबू आ रही है। यह सुनकर मूसा उनसे नाराज़ हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","हर सुबह हर कोई उतना जमा कर लेता जितनी उसे ज़रूरत होती थी। जब धूप तेज़ होती तो जो कुछ ज़मीन पर रह जाता वह पिघलकर ख़त्म हो जाता था। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","छटे दिन जब लोग यह ख़ुराक जमा करते तो वह मिक़दार में दुगनी होती थी यानी हर फ़रद के लिए चार लिटर। जब जमात के बुज़ुर्गों ने मूसा के पास आकर उसे इत्तला दी ");
INSERT INTO urdgvh_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","तो उसने उनसे कहा, “रब का फ़रमान है कि कल आराम का दिन है, मुक़द्दस सबत का दिन जो अल्लाह की ताज़ीम में मनाना है। आज तुम जो तनूर में पकाना चाहते हो पका लो और जो उबालना चाहते हो उबाल लो। जो बच जाए उसे कल के लिए महफ़ूज़ रखो।” ");
INSERT INTO urdgvh_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","लोगों ने मूसा के हुक्म के मुताबिक़ अगले दिन के लिए खाना महफ़ूज़ कर लिया तो न खाने से बदबू आई, न उसमें कीड़े पड़े। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","मूसा ने कहा, “आज यही बचा हुआ खाना खाओ, क्योंकि आज सबत का दिन है, रब की ताज़ीम में आराम का दिन। आज तुम्हें रेगिस्तान में कुछ नहीं मिलेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","छः दिन के दौरान यह ख़ुराक जमा करना है, लेकिन सातवाँ दिन आराम का दिन है। उस दिन ज़मीन पर खाने के लिए कुछ नहीं होगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","तो भी कुछ लोग हफ़ते को खाना जमा करने के लिए निकले, लेकिन उन्हें कुछ न मिला। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","तब रब ने मूसा से कहा, “तुम लोग कब तक मेरे अहकाम और हिदायात पर अमल करने से इनकार करोगे? ");
INSERT INTO urdgvh_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","देखो, रब ने तुम्हारे लिए मुक़र्रर किया है कि सबत का दिन आराम का दिन है। इसलिए वह तुम्हें जुमे को दो दिन के लिए ख़ुराक देता है। हफ़ते को सबको अपने ख़ैमों में रहना है। कोई भी अपने घर से बाहर न निकले।” ");
INSERT INTO urdgvh_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","चुनाँचे लोग सबत के दिन आराम करते थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","इसराईलियों ने इस ख़ुराक का नाम ‘मन’ रखा। उसके दाने धनिये की मानिंद सफ़ेद थे, और उसका ज़ायक़ा शहद से बने केक की मानिंद था। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","मूसा ने कहा, “रब फ़रमाता है, ‘दो लिटर मन एक मरतबान में रखकर उसे आनेवाली नसलों के लिए महफ़ूज़ रखना। फिर वह देख सकेंगे कि मैं तुम्हें क्या खाना खिलाता रहा जब तुम्हें मिसर से निकाल लाया’।” ");
INSERT INTO urdgvh_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","मूसा ने हारून से कहा, “एक मरतबान लो और उसे दो लिटर मन से भरकर रब के सामने रखो ताकि वह आनेवाली नसलों के लिए महफ़ूज़ रहे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","हारून ने ऐसा ही किया। उसने मन के इस मरतबान को अहद के संदूक़ के सामने रखा ताकि वह महफ़ूज़ रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","इसराईलियों को 40 साल तक मन मिलता रहा। वह उस वक़्त तक मन खाते रहे जब तक रेगिस्तान से निकलकर कनान की सरहद पर न पहुँचे। ");
INSERT INTO urdgvh_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(जो पैमाना इसराईली मन के लिए इस्तेमाल करते थे वह दो लिटर का एक बरतन था जिसका नाम ओमर था।) ");
INSERT INTO urdgvh_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","फिर इसराईल की पूरी जमात सीन के रेगिस्तान से निकली। रब जिस तरह हुक्म देता रहा वह एक जगह से दूसरी जगह सफ़र करते रहे। रफ़ीदीम में उन्होंने ख़ैमे लगाए। वहाँ पीने के लिए पानी न मिला। ");
INSERT INTO urdgvh_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","इसलिए वह मूसा के साथ यह कहकर झगड़ने लगे, “हमें पीने के लिए पानी दो।” मूसा ने जवाब दिया, “तुम मुझसे क्यों झगड़ रहे हो? रब को क्यों आज़मा रहे हो?” ");
INSERT INTO urdgvh_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","लेकिन लोग बहुत प्यासे थे। वह मूसा के ख़िलाफ़ बुड़बुड़ाने से बाज़ न आए बल्कि कहा, “आप हमें मिसर से क्यों लाए हैं? क्या इसलिए कि हम अपने बच्चों और रेवड़ों समेत प्यासे मर जाएँ?” ");
INSERT INTO urdgvh_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","तब मूसा ने रब के हुज़ूर फ़रियाद की, “मैं इन लोगों के साथ क्या करूँ? हालात ज़रा भी और बिगड़ जाएँ तो वह मुझे संगसार कर देंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","रब ने मूसा से कहा, “कुछ बुज़ुर्ग साथ लेकर लोगों के आगे आगे चल। वह लाठी भी साथ ले जा जिससे तूने दरियाए-नील को मारा था। ");
INSERT INTO urdgvh_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","मैं होरिब यानी सीना पहाड़ की एक चट्टान पर तेरे सामने खड़ा हूँगा। लाठी से चट्टान को मारना तो उससे पानी निकलेगा और लोग पी सकेंगे।” मूसा ने इसराईल के बुज़ुर्गों के सामने ऐसा ही किया। ");
INSERT INTO urdgvh_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","उसने उस जगह का नाम मस्सा और मरीबा यानी ‘आज़माना और झगड़ना’ रखा, क्योंकि वहाँ इसराईली बुड़बुड़ाए और यह पूछकर रब को आज़माया कि क्या रब हमारे दरमियान है कि नहीं? ");
INSERT INTO urdgvh_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","रफ़ीदीम वह जगह भी थी जहाँ अमालीक़ी इसराईलियों से लड़ने आए। ");
INSERT INTO urdgvh_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","मूसा ने यशुअ से कहा, “लड़ने के क़ाबिल आदमियों को चुन लो और निकलकर अमालीक़ियों का मुक़ाबला करो। कल मैं अल्लाह की लाठी पकड़े हुए पहाड़ की चोटी पर खड़ा हो जाऊँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","यशुअ मूसा की हिदायत के मुताबिक़ अमालीक़ियों से लड़ने गया जबकि मूसा, हारून और हूर पहाड़ की चोटी पर चढ़ गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","और यों हुआ कि जब मूसा के हाथ उठाए हुए थे तो इसराईली जीतते रहे, और जब वह नीचे थे तो अमालीक़ी जीतते रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","कुछ देर के बाद मूसा के बाज़ू थक गए। इसलिए हारून और हूर एक चट्टान ले आए ताकि वह उस पर बैठ जाए। फिर उन्होंने उसके दाईं और बाईं तरफ़ खड़े होकर उसके बाज़ुओं को ऊपर उठाए रखा। सूरज के ग़ुरूब होने तक उन्होंने यों मूसा की मदद की। ");
INSERT INTO urdgvh_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","इस तरह यशुअ ने अमालीक़ियों से लड़ते लड़ते उन्हें शिकस्त दी। ");
INSERT INTO urdgvh_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","तब रब ने मूसा से कहा, “यह वाक़िया यादगारी के लिए किताब में लिख ले। लाज़िम है कि यह सब कुछ यशुअ की याद में रहे, क्योंकि मैं दुनिया से अमालीक़ियों का नामो-निशान मिटा दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","उस वक़्त मूसा ने क़ुरबानगाह बनाकर उसका नाम ‘रब मेरा झंडा है’ रखा। ");
INSERT INTO urdgvh_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","उसने कहा, “रब के तख़्त के ख़िलाफ़ हाथ उठाया गया है, इसलिए रब की अमालीक़ियों से हमेशा तक जंग रहेगी।” ");
INSERT INTO urdgvh_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","मूसा का सुसर यितरो अब तक मिदियान में इमाम था। जब उसने सब कुछ सुना जो अल्लाह ने मूसा और अपनी क़ौम के लिए किया है, कि वह उन्हें मिसर से निकाल लाया है ");
INSERT INTO urdgvh_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","तो वह मूसा के पास आया। वह उस की बीवी सफ़्फ़ूरा को अपने साथ लाया, क्योंकि मूसा ने उसे अपने बेटों समेत मैके भेज दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","यितरो मूसा के दोनों बेटों को भी साथ लाया। पहले बेटे का नाम जैरसोम यानी ‘अजनबी मुल्क में परदेसी’ था, क्योंकि जब वह पैदा हुआ तो मूसा ने कहा था, “मैं अजनबी मुल्क में परदेसी हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","दूसरे बेटे का नाम इलियज़र यानी ‘मेरा ख़ुदा मददगार है’ था, क्योंकि जब वह पैदा हुआ तो मूसा ने कहा था, “मेरे बाप के ख़ुदा ने मेरी मदद करके मुझे फ़िरौन की तलवार से बचाया है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","यितरो मूसा की बीवी और बेटे साथ लेकर उस वक़्त मूसा के पास पहुँचा जब उसने रेगिस्तान में अल्लाह के पहाड़ यानी सीना के क़रीब ख़ैमा लगाया हुआ था। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","उसने मूसा को पैग़ाम भेजा था, “मैं, आपका सुसर यितरो आपकी बीवी और दो बेटों को साथ लेकर आपके पास आ रहा हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","मूसा अपने सुसर के इस्तक़बाल के लिए बाहर निकला, उसके सामने झुका और उसे बोसा दिया। दोनों ने एक दूसरे का हाल पूछा, फिर ख़ैमे में चले गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","मूसा ने यितरो को तफ़सील से बताया कि रब ने इसराईलियों की ख़ातिर फ़िरौन और मिसरियों के साथ क्या कुछ किया है। उसने रास्ते में पेश आई तमाम मुश्किलात का ज़िक्र भी किया कि रब ने हमें किस तरह उनसे बचाया है। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","यितरो उन सारे अच्छे कामों के बारे में सुनकर ख़ुश हुआ जो रब ने इसराईलियों के लिए किए थे जब उसने उन्हें मिसरियों के हाथ से बचाया था। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","उसने कहा, “रब की तमजीद हो जिसने आपको मिसरियों और फ़िरौन के क़ब्ज़े से नजात दिलाई है। उसी ने क़ौम को ग़ुलामी से छुड़ाया है! ");
INSERT INTO urdgvh_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","अब मैंने जान लिया है कि रब तमाम माबूदों से अज़ीम है, क्योंकि उसने यह सब कुछ उन लोगों के साथ किया जिन्होंने अपने ग़ुरूर में इसराईलियों के साथ बुरा सुलूक किया था।” ");
INSERT INTO urdgvh_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","फिर यितरो ने अल्लाह को भस्म होनेवाली क़ुरबानी और दीगर कई क़ुरबानियाँ पेश कीं। तब हारून और तमाम बुज़ुर्ग मूसा के सुसर यितरो के साथ अल्लाह के हुज़ूर खाना खाने बैठे। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","अगले दिन मूसा लोगों का इनसाफ़ करने के लिए बैठ गया। उनकी तादाद इतनी ज़्यादा थी कि वह सुबह से लेकर शाम तक मूसा के सामने खड़े रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","जब यितरो ने यह सब कुछ देखा तो उसने पूछा, “यह क्या है जो आप लोगों के साथ कर रहे हैं? सारा दिन वह आपको घेरे रहते और आप उनकी अदालत करते रहते हैं। आप यह सब कुछ अकेले ही क्यों कर रहे हैं?” ");
INSERT INTO urdgvh_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","मूसा ने जवाब दिया, “लोग मेरे पास आकर अल्लाह की मरज़ी मालूम करते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","जब कभी कोई तनाज़ा या झगड़ा होता है तो दोनों पार्टियाँ मेरे पास आती हैं। मैं फ़ैसला करके उन्हें अल्लाह के अहकाम और हिदायात बताता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","मूसा के सुसर ने उससे कहा, “आपका तरीक़ा अच्छा नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","काम इतना वसी है कि आप उसे अकेले नहीं सँभाल सकते। इससे आप और वह लोग जो आपके पास आते हैं बुरी तरह थक जाते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","मेरी बात सुनें! मैं आपको एक मशवरा देता हूँ। अल्लाह उसमें आपकी मदद करे। लाज़िम है कि आप अल्लाह के सामने क़ौम के नुमाइंदे रहें और उनके मामलात उसके सामने पेश करें। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","यह भी ज़रूरी है कि आप उन्हें अल्लाह के अहकाम और हिदायात सिखाएँ, कि वह किस तरह ज़िंदगी गुज़ारें और क्या क्या करें। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","लेकिन साथ साथ क़ौम में से क़ाबिले-एतमाद आदमी चुनें। वह ऐसे लोग हों जो अल्लाह का ख़ौफ़ मानते हों, रास्तदिल हों और रिश्वत से नफ़रत करते हों। उन्हें हज़ार हज़ार, सौ सौ, पचास पचास और दस दस आदमियों पर मुक़र्रर करें। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","उन आदमियों की ज़िम्मादारी यह होगी कि वह हर वक़्त लोगों का इनसाफ़ करें। अगर कोई बहुत ही पेचीदा मामला हो तो वह फ़ैसले के लिए आपके पास आएँ, लेकिन दीगर मामलों का फ़ैसला वह ख़ुद करें। यों वह काम में आपका हाथ बटाएँगे और आपका बोझ हलका हो जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","अगर मेरा यह मशवरा अल्लाह की मरज़ी के मुताबिक़ हो और आप ऐसा करें तो आप अपनी ज़िम्मादारी निभा सकेंगे और यह तमाम लोग इनसाफ़ के मिलने पर सलामती के साथ अपने अपने घर जा सकेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","मूसा ने अपने सुसर का मशवरा मान लिया और ऐसा ही किया। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","उसने इसराईलियों में से क़ाबिले-एतमाद आदमी चुने और उन्हें हज़ार हज़ार, सौ सौ, पचास पचास और दस दस आदमियों पर मुक़र्रर किया। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","यह मर्द क़ाज़ी बनकर मुस्तक़िल तौर पर लोगों का इनसाफ़ करने लगे। आसान मसलों का फ़ैसला वह ख़ुद करते और मुश्किल मामलों को मूसा के पास ले आते थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","कुछ अरसे बाद मूसा ने अपने सुसर को रुख़सत किया तो यितरो अपने वतन वापस चला गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","इसराईलियों को मिसर से सफ़र करते हुए दो महीने हो गए थे। तीसरे महीने के पहले ही दिन वह सीना के रेगिस्तान में पहुँचे। ");
INSERT INTO urdgvh_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","उस दिन वह रफ़ीदीम को छोड़कर दश्ते-सीना में आ पहुँचे। वहाँ उन्होंने रेगिस्तान में पहाड़ के क़रीब डेरे डाले। ");
INSERT INTO urdgvh_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","तब मूसा पहाड़ पर चढ़कर अल्लाह के पास गया। अल्लाह ने पहाड़ पर से मूसा को पुकारकर कहा, “याक़ूब के घराने बनी इसराईल को बता, ");
INSERT INTO urdgvh_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘तुमने देखा है कि मैंने मिसरियों के साथ क्या कुछ किया, और कि मैं तुमको उक़ाब के परों पर उठाकर यहाँ अपने पास लाया हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","चुनाँचे अगर तुम मेरी सुनो और मेरे अहद के मुताबिक़ चलो तो फिर तमाम क़ौमों में से मेरी ख़ास मिलकियत होगे। गो पूरी दुनिया मेरी ही है, ");
INSERT INTO urdgvh_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","लेकिन तुम मेरे लिए मख़सूस इमामों की बादशाही और मुक़द्दस क़ौम होगे।’ अब जाकर यह सारी बातें इसराईलियों को बता।” ");
INSERT INTO urdgvh_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","मूसा ने पहाड़ से उतरकर और क़ौम के बुज़ुर्गों को बुलाकर उन्हें वह तमाम बातें बताईं जो कहने के लिए रब ने उसे हुक्म दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","जवाब में पूरी क़ौम ने मिलकर कहा, “हम रब की हर बात पूरी करेंगे जो उसने फ़रमाई है।” मूसा ने पहाड़ पर लौटकर रब को क़ौम का जवाब बताया। ");
INSERT INTO urdgvh_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","जब वह पहुँचा तो रब ने मूसा से कहा, “मैं घने बादल में तेरे पास आऊँगा ताकि लोग मुझे तुझसे हमकलाम होते हुए सुनें। फिर वह हमेशा तुझ पर भरोसा रखेंगे।” तब मूसा ने रब को वह तमाम बातें बताईं जो लोगों ने की थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","रब ने मूसा से कहा, “अब लोगों के पास लौटकर आज और कल उन्हें मेरे लिए मख़सूसो-मुक़द्दस कर। वह अपने लिबास धोकर ");
INSERT INTO urdgvh_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","तीसरे दिन के लिए तैयार हो जाएँ, क्योंकि उस दिन रब लोगों के देखते देखते कोहे-सीना पर उतरेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","लोगों की हिफ़ाज़त के लिए चारों तरफ़ पहाड़ की हद्दें मुक़र्रर कर। उन्हें ख़बरदार कर कि हुदूद को पार न करो। न पहाड़ पर चढ़ो, न उसके दामन को छुओ। जो भी उसे छुए वह ज़रूर मारा जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","और उसे हाथ से छूकर नहीं मारना है बल्कि पत्थरों या तीरों से। ख़ाह इनसान हो या हैवान, वह ज़िंदा नहीं रह सकता। जब तक नरसिंगा देर तक फूँका न जाए उस वक़्त तक लोगों को पहाड़ पर चढ़ने की इजाज़त नहीं है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","मूसा ने पहाड़ से उतरकर लोगों को अल्लाह के लिए मख़सूसो-मुक़द्दस किया। उन्होंने अपने लिबास भी धोए। ");
INSERT INTO urdgvh_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","उसने उनसे कहा, “तीसरे दिन के लिए तैयार हो जाओ। मर्द औरतों से हमबिसतर न हों।” ");
INSERT INTO urdgvh_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","तीसरे दिन सुबह पहाड़ पर घना बादल छा गया। बिजली चमकने लगी, बादल गरजने लगा और नरसिंगे की निहायत ज़ोरदार आवाज़ सुनाई दी। ख़ैमागाह में लोग लरज़ उठे। ");
INSERT INTO urdgvh_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","तब मूसा लोगों को अल्लाह से मिलने के लिए ख़ैमागाह से बाहर पहाड़ की तरफ़ ले गया, और वह पहाड़ के दामन में खड़े हुए। ");
INSERT INTO urdgvh_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","सीना पहाड़ धुएँ से ढका हुआ था, क्योंकि रब आग में उस पर उतर आया। पहाड़ से धुआँ इस तरह उठ रहा था जैसे किसी भट्टे से उठता है। पूरा पहाड़ शिद्दत से लरज़ने लगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","नरसिंगे की आवाज़ तेज़ से तेज़तर होती गई। मूसा बोलने लगा और अल्लाह उसे ऊँची आवाज़ में जवाब देता रहा। ");
INSERT INTO urdgvh_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","रब सीना पहाड़ की चोटी पर उतरा और मूसा को ऊपर आने के लिए कहा। मूसा ऊपर चढ़ा। ");
INSERT INTO urdgvh_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","रब ने मूसा से कहा, “फ़ौरन नीचे उतरकर लोगों को ख़बरदार कर कि वह मुझे देखने के लिए पहाड़ की हुदूद में ज़बरदस्ती दाख़िल न हों। अगर वह ऐसा करें तो बहुत-से हलाक हो जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","इमाम भी जो रब के हुज़ूर आते हैं अपने आपको मख़सूसो-मुक़द्दस करें, वरना मेरा ग़ज़ब उन पर टूट पड़ेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","लेकिन मूसा ने रब से कहा, “लोग पहाड़ पर नहीं आ सकते, क्योंकि तूने ख़ुद ही हमें ख़बरदार किया कि हम पहाड़ की हद्दें मुक़र्रर करके उसे मख़सूसो-मुक़द्दस करें।” ");
INSERT INTO urdgvh_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","रब ने जवाब दिया, “तो भी उतर जा और हारून को साथ लेकर वापस आ। लेकिन इमामों और लोगों को मत आने दे। अगर वह ज़बरदस्ती मेरे पास आएँ तो मेरा ग़ज़ब उन पर टूट पड़ेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","मूसा ने लोगों के पास उतरकर उन्हें यह बातें बता दीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","तब अल्लाह ने यह तमाम बातें फ़रमाईं, ");
INSERT INTO urdgvh_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“मैं रब तेरा ख़ुदा हूँ जो तुझे मुल्के-मिसर की ग़ुलामी से निकाल लाया। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","मेरे सिवा किसी और माबूद की परस्तिश न करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","अपने लिए बुत न बनाना। किसी भी चीज़ की मूरत न बनाना, चाहे वह आसमान में, ज़मीन पर या समुंदर में हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","न बुतों की परस्तिश, न उनकी ख़िदमत करना, क्योंकि मैं तेरा रब ग़यूर ख़ुदा हूँ। जो मुझसे नफ़रत करते हैं उन्हें मैं तीसरी और चौथी पुश्त तक सज़ा दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","लेकिन जो मुझसे मुहब्बत रखते और मेरे अहकाम पूरे करते हैं उन पर मैं हज़ार पुश्तों तक मेहरबानी करूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","रब अपने ख़ुदा का नाम बेमक़सद या ग़लत मक़सद के लिए इस्तेमाल न करना। जो भी ऐसा करता है उसे रब सज़ा दिए बग़ैर नहीं छोड़ेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","सबत के दिन का ख़याल रखना। उसे इस तरह मनाना कि वह मख़सूसो-मुक़द्दस हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","हफ़ते के पहले छः दिन अपना काम-काज कर, ");
INSERT INTO urdgvh_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","लेकिन सातवाँ दिन रब तेरे ख़ुदा का आराम का दिन है। उस दिन किसी तरह का काम न करना। न तू, न तेरा बेटा, न तेरी बेटी, न तेरा नौकर, न तेरी नौकरानी और न तेरे मवेशी। जो परदेसी तेरे दरमियान रहता है वह भी काम न करे। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","क्योंकि रब ने पहले छः दिन में आसमानो-ज़मीन, समुंदर और जो कुछ उनमें है बनाया लेकिन सातवें दिन आराम किया। इसलिए रब ने सबत के दिन को बरकत देकर मुक़र्रर किया कि वह मख़सूस और मुक़द्दस हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","अपने बाप और अपनी माँ की इज़्ज़त करना। फिर तू उस मुल्क में जो रब तेरा ख़ुदा तुझे देनेवाला है देर तक जीता रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","क़त्ल न करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","ज़िना न करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","चोरी न करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","अपने पड़ोसी के बारे में झूटी गवाही न देना। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","अपने पड़ोसी के घर का लालच न करना। न उस की बीवी का, न उसके नौकर का, न उस की नौकरानी का, न उसके बैल और न उसके गधे का बल्कि उस की किसी भी चीज़ का लालच न करना।” ");
INSERT INTO urdgvh_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","जब बाक़ी तमाम लोगों ने बादल की गरज और नरसिंगे की आवाज़ सुनी और बिजली की चमक और पहाड़ से उठते हुए धुएँ को देखा तो वह ख़ौफ़ के मारे काँपने लगे और पहाड़ से दूर खड़े हो गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","उन्होंने मूसा से कहा, “आप ही हमसे बात करें तो हम सुनेंगे। लेकिन अल्लाह को हमसे बात न करने दें वरना हम मर जाएंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","लेकिन मूसा ने उनसे कहा, “मत डरो, क्योंकि रब तुम्हें जाँचने के लिए आया है, ताकि उसका ख़ौफ़ तुम्हारी आँखों के सामने रहे और तुम गुनाह न करो।” ");
INSERT INTO urdgvh_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","लोग दूर ही रहे जबकि मूसा उस गहरी तारीकी के क़रीब गया जहाँ अल्लाह था। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","तब रब ने मूसा से कहा, “इसराईलियों को बता, ‘तुमने ख़ुद देखा कि मैंने आसमान पर से तुम्हारे साथ बातें की हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","चुनाँचे मेरी परस्तिश के साथ साथ अपने लिए सोने या चाँदी के बुत न बनाओ। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","मेरे लिए मिट्टी की क़ुरबानगाह बनाकर उस पर अपनी भेड़-बकरियों और गाय-बैलों की भस्म होनेवाली और सलामती की क़ुरबानियाँ चढ़ाना। मैं तुझे वह जगहें दिखाऊँगा जहाँ मेरे नाम की ताज़ीम में क़ुरबानियाँ पेश करनी हैं। ऐसी तमाम जगहों पर मैं तेरे पास आकर तुझे बरकत दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","अगर तू मेरे लिए क़ुरबानगाह बनाने की ख़ातिर पत्थर इस्तेमाल करना चाहे तो तराशे हुए पत्थर इस्तेमाल न करना। क्योंकि तू तराशने के लिए इस्तेमाल होनेवाले औज़ार से उस की बेहुरमती करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","क़ुरबानगाह को सीढ़ियों के बग़ैर बनाना है ताकि उस पर चढ़ने से तेरे लिबास के नीचे से तेरा नंगापन नज़र न आए।’ ");
INSERT INTO urdgvh_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","इसराईलियों को यह अहकाम बता, ");
INSERT INTO urdgvh_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","‘अगर तू इबरानी ग़ुलाम ख़रीदे तो वह छः साल तेरा ग़ुलाम रहे। इसके बाद लाज़िम है कि उसे आज़ाद कर दिया जाए। आज़ाद होने के लिए उसे पैसे देने की ज़रूरत नहीं होगी। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","अगर ग़ुलाम ग़ैरशादीशुदा हालत में मालिक के घर आया हो तो वह आज़ाद होकर अकेला ही चला जाए। अगर वह शादीशुदा हालत में आया हो तो लाज़िम है कि वह अपनी बीवी समेत आज़ाद होकर जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","अगर मालिक ने ग़ुलाम की शादी कराई और बच्चे पैदा हुए हैं तो उस की बीवी और बच्चे मालिक की मिलकियत होंगे। छः साल के बाद जब ग़ुलाम आज़ाद होकर जाए तो उस की बीवी और बच्चे मालिक ही के पास रहें। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","अगर ग़ुलाम कहे, “मैं अपने मालिक और अपने बीवी बच्चों से मुहब्बत रखता हूँ, मैं आज़ाद नहीं होना चाहता” ");
INSERT INTO urdgvh_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","तो ग़ुलाम का मालिक उसे अल्लाह के सामने लाए। वह उसे दरवाज़े या उस की चौखट के पास ले जाए और सुताली यानी तेज़ औज़ार से उसके कान की लौ छेद दे। तब वह ज़िंदगी-भर उसका ग़ुलाम बना रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","अगर कोई अपनी बेटी को ग़ुलामी में बेच डाले तो उसके लिए आज़ादी मिलने की शरायत मर्द से फ़रक़ हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","अगर उसके मालिक ने उसे मुंतख़ब किया कि वह उस की बीवी बन जाए, लेकिन बाद में वह उसे पसंद न आए तो लाज़िम है कि वह मुनासिब मुआवज़ा लेकर उसे उसके रिश्तेदारों को वापस कर दे। उसे औरत को ग़ैरमुल्कियों के हाथ बेचने का इख़्तियार नहीं है, क्योंकि उसने उसके साथ बेवफ़ा सुलूक किया है। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","अगर लौंडी का मालिक उस की अपने बेटे के साथ शादी कराए तो औरत को बेटी के हुक़ूक़ हासिल होंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","अगर मालिक ने उससे शादी करके बाद में दूसरी औरत से भी शादी की तो लाज़िम है कि वह पहली को भी खाना और कपड़े देता रहे। इसके अलावा उसके साथ हमबिसतर होने का फ़र्ज़ भी अदा करना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","अगर वह यह तीन फ़रायज़ अदा न करे तो उसे औरत को आज़ाद करना पड़ेगा। इस सूरत में उसे मुफ़्त आज़ाद करना होगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","जो किसी को जान-बूझकर इतना सख़्त मारता हो कि वह मर जाए तो उसे ज़रूर सज़ाए-मौत देना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","लेकिन अगर उसने उसे जान-बूझकर न मारा बल्कि यह इत्तफ़ाक़ से हुआ और अल्लाह ने यह होने दिया, तो मारनेवाला एक ऐसी जगह पनाह ले सकता है जो मैं मुक़र्रर करूँगा। वहाँ उसे क़त्ल किए जाने की इजाज़त नहीं होगी। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","लेकिन जो दीदा-दानिस्ता और चालाकी से किसी को मार डालता है उसे मेरी क़ुरबानगाह से भी छीनकर सज़ाए-मौत देना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","जो अपने बाप या अपनी माँ को मारता पीटता है उसे सज़ाए-मौत दी जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","जिसने किसी को इग़वा कर लिया है उसे सज़ाए-मौत दी जाए, चाहे वह उसे ग़ुलाम बनाकर बेच चुका हो या उसे अब तक अपने पास रखा हुआ हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","जो अपने बाप या माँ पर लानत करे उसे सज़ाए-मौत दी जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","हो सकता है कि आदमी झगड़ें और एक शख़्स दूसरे को पत्थर या मुक्के से इतना ज़ख़मी कर दे कि गो वह बच जाए वह बिस्तर से उठ न सकता हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","अगर बाद में मरीज़ यहाँ तक शफ़ा पाए कि दुबारा उठकर लाठी के सहारे चल-फिर सके तो चोट पहुँचानेवाले को सज़ा नहीं मिलेगी। उसे सिर्फ़ उस वक़्त के लिए मुआवज़ा देना पड़ेगा जब तक मरीज़ पैसे न कमा सके। साथ ही उसे उसका पूरा इलाज करवाना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","जो अपने ग़ुलाम या लौंडी को लाठी से यों मारे कि वह मर जाए उसे सज़ा दी जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","लेकिन अगर ग़ुलाम या लौंडी पिटाई के बाद एक या दो दिन ज़िंदा रहे तो मालिक को सज़ा न दी जाए। क्योंकि जो रक़म उसने उसके लिए दी थी उसका नुक़सान उसे ख़ुद उठाना पड़ेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","हो सकता है कि लोग आपस में लड़ रहे हों और लड़ते लड़ते किसी हामिला औरत से यों टकरा जाएँ कि उसका बच्चा ज़ाया हो जाए। अगर कोई और नुक़सान न हुआ हो तो ज़रब पहुँचानेवाले को जुरमाना देना पड़ेगा। औरत का शौहर यह जुरमाना मुक़र्रर करे, और अदालत में इसकी तसदीक़ हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","लेकिन अगर उस औरत को और नुक़सान भी पहुँचा हो तो फिर ज़रब पहुँचानेवाले को इस उसूल के मुताबिक़ सज़ा दी जाए कि जान के बदले जान, ");
INSERT INTO urdgvh_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","आँख के बदले आँख, दाँत के बदले दाँत, हाथ के बदले हाथ, पाँव के बदले पाँव, ");
INSERT INTO urdgvh_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","जलने के ज़ख़म के बदले जलने का ज़ख़म, मार के बदले मार, काट के बदले काट। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","अगर कोई मालिक अपने ग़ुलाम की आँख पर यों मारे कि वह ज़ाया हो जाए तो उसे ग़ुलाम को आँख के बदले आज़ाद करना पड़ेगा, चाहे ग़ुलाम मर्द हो या औरत। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","अगर मालिक के पीटने से ग़ुलाम का दाँत टूट जाए तो उसे ग़ुलाम को दाँत के बदले आज़ाद करना पड़ेगा, चाहे ग़ुलाम मर्द हो या औरत। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","अगर कोई बैल किसी मर्द या औरत को ऐसा मारे कि वह मर जाए तो उस बैल को संगसार किया जाए। उसका गोश्त खाने की इजाज़त नहीं है। इस सूरत में बैल के मालिक को सज़ा न दी जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","लेकिन हो सकता है कि मालिक को पहले आगाह किया गया था कि बैल लोगों को मारता है, तो भी उसने बैल को खुला छोड़ा था जिसके नतीजे में उसने किसी को मार डाला। ऐसी सूरत में न सिर्फ़ बैल को बल्कि उसके मालिक को भी संगसार करना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","लेकिन अगर फ़ैसला किया जाए कि वह अपनी जान का फ़िद्या दे तो जितना मुआवज़ा भी मुक़र्रर किया जाए उसे देना पड़ेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","सज़ा में कोई फ़रक़ नहीं है, चाहे बेटे को मारा जाए या बेटी को। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","लेकिन अगर बैल किसी ग़ुलाम या लौंडी को मार दे तो उसका मालिक ग़ुलाम के मालिक को चाँदी के 30 सिक्के दे और बैल को संगसार किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","हो सकता है कि किसी ने अपने हौज़ को खुला रहने दिया या हौज़ बनाने के लिए गढ़ा खोदकर उसे खुला रहने दिया और कोई बैल या गधा उसमें गिरकर मर गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ऐसी सूरत में हौज़ का मालिक मुरदा जानवर के लिए पैसे दे। वह जानवर के मालिक को उस की पूरी क़ीमत अदा करे और मुरदा जानवर ख़ुद ले ले। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","अगर किसी का बैल किसी दूसरे के बैल को ऐसे मारे कि वह मर जाए तो दोनों मालिक ज़िंदा बैल को बेचकर उसके पैसे आपस में बराबर बाँट लें। इसी तरह वह मुरदा बैल को भी बराबर तक़सीम करें। ");
INSERT INTO urdgvh_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","लेकिन हो सकता है कि मालिक को मालूम था कि मेरा बैल दूसरे जानवरों पर हमला करता है, इसके बावुजूद उसने उसे आज़ाद छोड़ दिया था। ऐसी सूरत में उसे मुरदा बैल के एवज़ उसके मालिक को नया बैल देना पड़ेगा, और वह मुरदा बैल ख़ुद ले ले। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","जिसने कोई बैल या भेड़ चोरी करके उसे ज़बह किया या बेच डाला है उसे हर चोरी के बैल के एवज़ पाँच बैल और हर चोरी की भेड़ के एवज़ चार भेड़ें वापस करना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","हो सकता है कि कोई चोर नक़ब लगा रहा हो और लोग उसे पकड़कर यहाँ तक मारते पीटते रहें कि वह मर जाए। अगर रात के वक़्त ऐसा हुआ हो तो वह उसके ख़ून के ज़िम्मादार नहीं ठहर सकते। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","लेकिन अगर सूरज के तुलू होने के बाद ऐसा हुआ हो तो जिसने उसे मारा वह क़ातिल ठहरेगा। चोर को हर चुराई हुई चीज़ का एवज़ाना देना है। अगर उसके पास देने के लिए कुछ न हो तो उसे ग़ुलाम बनाकर बेचना है। जो पैसे उसे बेचने के एवज़ मिलें वह चुराई हुई चीज़ों के बदले में दिए जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","अगर चोरी का जानवर चोर के पास ज़िंदा पाया जाए तो उसे हर जानवर के एवज़ दो देने पड़ेंगे, चाहे वह बैल, भेड़, बकरी या गधा हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","हो सकता है कि कोई अपने मवेशी को अपने खेत या अंगूर के बाग़ में छोड़कर चरने दे और होते होते वह किसी दूसरे के खेत या अंगूर के बाग़ में जाकर चरने लगे। ऐसी सूरत में लाज़िम है कि मवेशी का मालिक नुक़सान के एवज़ अपने अंगूर के बाग़ और खेत की बेहतरीन पैदावार में से दे। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","हो सकता है कि किसी ने आग जलाई हो और वह काँटेदार झाड़ियों के ज़रीए पड़ोसी के खेत तक फैलकर उसके अनाज के पूलों को, उस की पकी हुई फ़सल को या खेत की किसी और पैदावार को बरबाद कर दे। ऐसी सूरत में जिसने आग जलाई हो उसे उस की पूरी क़ीमत अदा करनी है। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","हो सकता है कि किसी ने कुछ पैसे या कोई और माल अपने किसी वाक़िफ़कार के सुपुर्द कर दिया हो ताकि वह उसे महफ़ूज़ रखे। अगर यह चीज़ें उसके घर से चोरी हो जाएँ और बाद में चोर को पकड़ा जाए तो चोर को उस की दुगनी क़ीमत अदा करनी पड़ेगी। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","लेकिन अगर चोर पकड़ा न जाए तो लाज़िम है कि उस घर का मालिक जिसके सुपुर्द यह चीज़ें की गई थीं अल्लाह के हुज़ूर खड़ा हो ताकि मालूम किया जाए कि उसने ख़ुद यह माल चोरी किया है या नहीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","हो सकता है कि दो लोगों का आपस में झगड़ा हो, और दोनों किसी चीज़ के बारे में दावा करते हों कि यह मेरी है। अगर कोई क़ीमती चीज़ हो मसलन बैल, गधा, भेड़, बकरी, कपड़े या कोई खोई हुई चीज़ तो मामला अल्लाह के हुज़ूर लाया जाए। जिसे अल्लाह क़ुसूरवार क़रार दे उसे दूसरे को ज़ेरे-बहस चीज़ की दुगनी क़ीमत अदा करनी है। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","हो सकता है कि किसी ने अपना कोई गधा, बैल, भेड़, बकरी या कोई और जानवर किसी वाक़िफ़कार के सुपुर्द कर दिया ताकि वह उसे महफ़ूज़ रखे। वहाँ जानवर मर जाए या ज़ख़मी हो जाए, या कोई उस पर क़ब्ज़ा करके उसे उस वक़्त ले जाए जब कोई न देख रहा हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","यह मामला यों हल किया जाए कि जिसके सुपुर्द जानवर किया गया था वह रब के हुज़ूर क़सम खाकर कहे कि मैंने अपने वाक़िफ़कार के जानवर के लालच में यह काम नहीं किया। जानवर के मालिक को यह क़बूल करना पड़ेगा, और दूसरे को इसके बदले कुछ नहीं देना होगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","लेकिन अगर वाक़ई जानवर को चोरी किया गया है तो जिसके सुपुर्द जानवर किया गया था उसे उस की क़ीमत अदा करनी पड़ेगी। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","अगर किसी जंगली जानवर ने उसे फाड़ डाला हो तो वह सबूत के तौर पर फाड़ी हुई लाश को ले आए। फिर उसे उस की क़ीमत अदा नहीं करनी पड़ेगी। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","हो सकता है कि कोई अपने वाक़िफ़कार से इजाज़त लेकर उसका जानवर इस्तेमाल करे। अगर जानवर को मालिक की ग़ैरमौजूदगी में चोट लगे या वह मर जाए तो उस शख़्स को जिसके पास जानवर उस वक़्त था उसका मुआवज़ा देना पड़ेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","लेकिन अगर जानवर का मालिक उस वक़्त साथ था तो दूसरे को मुआवज़ा देने की ज़रूरत नहीं होगी। अगर उसने जानवर को किराए पर लिया हो तो उसका नुक़सान किराए से पूरा हो जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","अगर किसी कुँवारी की मँगनी नहीं हुई और कोई मर्द उसे वरग़लाकर उससे हमबिसतर हो जाए तो वह महर देकर उससे शादी करे। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","लेकिन अगर लड़की का बाप उस की उस मर्द के साथ शादी करने से इनकार करे, इस सूरत में भी मर्द को कुँवारी के लिए मुक़र्ररा रक़म देनी पड़ेगी। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","जादूगरनी को जीने न देना। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","जो शख़्स किसी जानवर के साथ जिंसी ताल्लुक़ात रखता हो उसे सज़ाए-मौत दी जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","जो न सिर्फ़ रब को क़ुरबानियाँ पेश करे बल्कि दीगर माबूदों को भी उसे क़ौम से निकालकर हलाक किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","जो परदेसी तेरे मुल्क में मेहमान है उसे न दबाना और न उससे बुरा सुलूक करना, क्योंकि तुम भी मिसर में परदेसी थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","किसी बेवा या यतीम से बुरा सुलूक न करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","अगर तू ऐसा करे और वह चिल्लाकर मुझसे फ़रियाद करें तो मैं ज़रूर उनकी सुनूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","मैं बड़े ग़ुस्से में आकर तुम्हें तलवार से मार डालूँगा। फिर तुम्हारी बीवियाँ ख़ुद बेवाएँ और तुम्हारे बच्चे ख़ुद यतीम बन जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","अगर तूने मेरी क़ौम के किसी ग़रीब को क़र्ज़ दिया है तो उससे सूद न लेना। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","अगर तुझे किसी से उस की चादर गिरवी के तौर पर मिली हो तो उसे सूरज डूबने से पहले ही वापस कर देना है, ");
INSERT INTO urdgvh_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","क्योंकि इसी को वह सोने के लिए इस्तेमाल करता है। वरना वह क्या चीज़ ओढ़कर सोएगा? अगर तू चादर वापस न करे और वह शख़्स चिल्लाकर मुझसे फ़रियाद करे तो मैं उस की सुनूँगा, क्योंकि मैं मेहरबान हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","अल्लाह को न कोसना, न अपनी क़ौम के किसी सरदार पर लानत करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","मुझे वक़्त पर अपने खेत और कोल्हुओं की पैदावार में से नज़राने पेश करना। अपने पहलौठे मुझे देना। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","अपने बैलों, भेड़ों और बकरियों के पहलौठों को भी मुझे देना। जानवर का पहलौठा पहले सात दिन अपनी माँ के साथ रहे। आठवें दिन वह मुझे दिया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","अपने आपको मेरे लिए मख़सूसो-मुक़द्दस रखना। इसलिए ऐसे जानवर का गोश्त मत खाना जिसे किसी जंगली जानवर ने फाड़ डाला है। ऐसे गोश्त को कुत्तों को खाने देना। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","ग़लत अफ़वाहें न फैलाना। किसी शरीर आदमी का साथ देकर झूटी गवाही देना मना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","अगर अकसरियत ग़लत काम कर रही हो तो उसके पीछे न हो लेना। अदालत में गवाही देते वक़्त अकसरियत के साथ मिलकर ऐसी बात न करना जिससे ग़लत फ़ैसला किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","लेकिन अदालत में किसी ग़रीब की तरफ़दारी भी न करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","अगर तुझे तेरे दुश्मन का बैल या गधा आवारा फिरता हुआ नज़र आए तो उसे हर सूरत में वापस कर देना। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","अगर तुझसे नफ़रत करनेवाले का गधा बोझ तले गिर गया हो और तुझे पता लगे तो उसे न छोड़ना बल्कि ज़रूर उस की मदद करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","अदालत में ग़रीब के हुक़ूक़ न मारना। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ऐसे मामले से दूर रहना जिसमें लोग झूट बोलते हैं। जो बेगुनाह और हक़ पर है उसे सज़ाए-मौत न देना, क्योंकि मैं क़ुसूरवार को हक़-बजानिब नहीं ठहराऊँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","रिश्वत न लेना, क्योंकि रिश्वत देखनेवाले को अंधा कर देती है और उस की बात बनने नहीं देती जो हक़ पर है। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","जो परदेसी तेरे मुल्क में मेहमान है उस पर दबाव न डालना। तुम ऐसे लोगों की हालत से ख़ूब वाक़िफ़ हो, क्योंकि तुम ख़ुद मिसर में परदेसी रहे हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","छः साल तक अपनी ज़मीन में बीज बोकर उस की पैदावार जमा करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","लेकिन सातवें साल ज़मीन को इस्तेमाल न करना बल्कि उसे पड़े रहने देना। जो कुछ भी उगे वह क़ौम के ग़रीब लोग खाएँ। जो उनसे बच जाए उसे जंगली जानवर खाएँ। अपने अंगूर और ज़ैतून के बाग़ों के साथ भी ऐसा ही करना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","छः दिन अपना काम-काज करना, लेकिन सातवें दिन आराम करना। फिर तेरा बैल और तेरा गधा भी आराम कर सकेंगे, तेरी लौंडी का बेटा और तेरे साथ रहनेवाला परदेसी भी ताज़ादम हो जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","जो भी हिदायत मैंने दी है उस पर अमल कर। दीगर माबूदों की परस्तिश न करना। मैं तेरे मुँह से उनके नामों तक का ज़िक्र न सुनूँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","साल में तीन दफ़ा मेरी ताज़ीम में ईद मनाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","पहले, बेख़मीरी रोटी की ईद मनाना। अबीब के महीने में सात दिन तक तेरी रोटी में ख़मीर न हो जिस तरह मैंने हुक्म दिया है, क्योंकि इस महीने में तू मिसर से निकला। इन दिनों में कोई मेरे हुज़ूर ख़ाली हाथ न आए। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","दूसरे, फ़सलकटाई की ईद उस वक़्त मनाना जब तू अपने खेत में बोई हुई पहली फ़सल काटेगा। तीसरे, जमा करने की ईद फ़सल की कटाई के इख़्तिताम पर मनाना है जब तूने अंगूर और बाक़ी बाग़ों के फल जमा किए होंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","यों तेरे तमाम मर्द तीन मरतबा रब क़ादिरे-मुतलक़ के हुज़ूर हाज़िर हुआ करें। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","जब तू किसी जानवर को ज़बह करके क़ुरबानी के तौर पर पेश करे तो उसके ख़ून के साथ ऐसी रोटी पेश न करना जिसमें ख़मीर हो। और जो जानवर तू मेरी ईदों पर चढ़ाए उनकी चरबी अगली सुबह तक बाक़ी न रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","अपनी ज़मीन की पहली पैदावार का बेहतरीन हिस्सा रब अपने ख़ुदा के घर में लाना। भेड़ या बकरी के बच्चे को उस की माँ के दूध में न पकाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","मैं तेरे आगे आगे फ़रिश्ता भेजता हूँ जो रास्ते में तेरी हिफ़ाज़त करेगा और तुझे उस जगह तक ले जाएगा जो मैंने तेरे लिए तैयार की है। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","उस की मौजूदगी में एहतियात बरतना। उस की सुनना, और उस की ख़िलाफ़वरज़ी न करना। अगर तू सरकश हो जाए तो वह तुझे मुआफ़ नहीं करेगा, क्योंकि मेरा नाम उसमें हाज़िर होगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","लेकिन अगर तू उस की सुने और सब कुछ करे जो मैं तुझे बताता हूँ तो मैं तेरे दुश्मनों का दुश्मन और तेरे मुख़ालिफ़ों का मुख़ालिफ़ हूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","क्योंकि मेरा फ़रिश्ता तेरे आगे आगे चलेगा और तुझे मुल्के-कनान तक पहुँचा देगा जहाँ अमोरी, हित्ती, फ़रिज़्ज़ी, कनानी, हिव्वी और यबूसी आबाद हैं। तब मैं उन्हें रूए-ज़मीन पर से मिटा दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","उनके माबूदों को सिजदा न करना, न उनकी ख़िदमत करना। उनके रस्मो-रिवाज भी न अपनाना बल्कि उनके बुतों को तबाह कर देना। जिन सतूनों के सामने वह इबादत करते हैं उनको भी टुकड़े टुकड़े कर डालना। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","रब अपने ख़ुदा की ख़िदमत करना। फिर मैं तेरी ख़ुराक और पानी को बरकत देकर तमाम बीमारियाँ तुझसे दूर करूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","फिर तेरे मुल्क में न किसी का बच्चा ज़ाया होगा, न कोई बाँझ होगी। साथ ही मैं तुझे तवील ज़िंदगी अता करूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","मैं तेरे आगे आगे दहशत फैलाऊँगा। जहाँ भी तू जाएगा वहाँ मैं तमाम क़ौमों में अबतरी पैदा करूँगा। मेरे सबब से तेरे सारे दुश्मन पलटकर भाग जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","मैं तेरे आगे ज़ंबूर भेज दूँगा जो हिव्वी, कनानी और हित्ती को मुल्क छोड़ने पर मजबूर करेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","लेकिन जब तू वहाँ पहुँचेगा तो मैं उन्हें एक ही साल में मुल्क से नहीं निकालूँगा। वरना पूरा मुल्क वीरान हो जाएगा और जंगली जानवर फैलकर तेरे लिए नुक़सान का बाइस बन जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","इसलिए मैं तेरे पहुँचने पर मुल्क के बाशिंदों को थोड़ा थोड़ा करके निकालता जाऊँगा। इतने में तेरी तादाद बढ़ेगी और तू रफ़्ता रफ़्ता मुल्क पर क़ब्ज़ा कर सकेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","मैं तेरी सरहद्दें मुक़र्रर करूँगा। बहरे-क़ुलज़ुम एक हद होगी और फ़िलिस्तियों का समुंदर दूसरी, जुनूब का रेगिस्तान एक होगी और दरियाए-फ़ुरात दूसरी। मैं मुल्क के बाशिंदों को तेरे क़ब्ज़े में कर दूँगा, और तू उन्हें अपने आगे आगे मुल्क से दूर करता जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","लाज़िम है कि तू उनके साथ या उनके माबूदों के साथ अहद न बाँधे। ");
INSERT INTO urdgvh_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","उनका तेरे मुल्क में रहना मना है, वरना तू उनके सबब से मेरा गुनाह करेगा। अगर तू उनके माबूदों की इबादत करेगा तो यह तेरे लिए फंदा बन जाएगा’।” ");
INSERT INTO urdgvh_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","रब ने मूसा से कहा, “तू, हारून, नदब, अबीहू और इसराईल के 70 बुज़ुर्ग मेरे पास ऊपर आएँ। कुछ फ़ासले पर खड़े होकर मुझे सिजदा करो। ");
INSERT INTO urdgvh_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","सिर्फ़ तू अकेला ही मेरे क़रीब आ, दूसरे दूर रहें। और क़ौम के बाक़ी लोग तेरे साथ पहाड़ पर न चढ़ें।” ");
INSERT INTO urdgvh_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","तब मूसा ने क़ौम के पास जाकर रब की तमाम बातें और अहकाम पेश किए। जवाब में सबने मिलकर कहा, “हम रब की इन तमाम बातों पर अमल करेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","तब मूसा ने रब की तमाम बातें लिख लीं। अगले दिन वह सुबह-सवेरे उठा और पहाड़ के पास गया। उसके दामन में उसने क़ुरबानगाह बनाई। साथ ही उसने इसराईल के हर एक क़बीले के लिए एक एक पत्थर का सतून खड़ा किया। ");
INSERT INTO urdgvh_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","फिर उसने कुछ इसराईली नौजवानों को क़ुरबानी पेश करने के लिए बुलाया ताकि वह रब की ताज़ीम में भस्म होनेवाली क़ुरबानियाँ चढ़ाएँ और जवान बैलों को सलामती की क़ुरबानी के तौर पर पेश करें। ");
INSERT INTO urdgvh_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","मूसा ने क़ुरबानियों का ख़ून जमा किया। उसका आधा हिस्सा उसने बासनों में डाल दिया और आधा हिस्सा क़ुरबानगाह पर छिड़क दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","फिर उसने वह किताब ली जिसमें रब के साथ अहद की तमाम शरायत दर्ज थीं और उसे क़ौम को पढ़कर सुनाया। जवाब में उन्होंने कहा, “हम रब की इन तमाम बातों पर अमल करेंगे। हम उस की सुनेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","इस पर मूसा ने बासनों में से ख़ून लेकर उसे लोगों पर छिड़का और कहा, “यह ख़ून उस अहद की तसदीक़ करता है जो रब ने तुम्हारे साथ किया है और जो उस की तमाम बातों पर मबनी है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","इसके बाद मूसा, हारून, नदब, अबीहू और इसराईल के 70 बुज़ुर्ग सीना पहाड़ पर चढ़े। ");
INSERT INTO urdgvh_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","वहाँ उन्होंने इसराईल के ख़ुदा को देखा। लगता था कि उसके पाँवों के नीचे संगे-लाजवर्द का-सा तख़्ता था। वह आसमान की मानिंद साफ़ो-शफ़्फ़ाफ़ था। ");
INSERT INTO urdgvh_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","अगरचे इसराईल के राहनुमाओं ने यह सब कुछ देखा तो भी रब ने उन्हें हलाक न किया, बल्कि वह अल्लाह को देखते रहे और उसके हुज़ूर अहद का खाना खाते और पीते रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","पहाड़ से उतरने के बाद रब ने मूसा से कहा, “मेरे पास पहाड़ पर आकर कुछ देर के लिए ठहरे रहना। मैं तुझे पत्थर की तख़्तियाँ दूँगा जिन पर मैंने अपनी शरीअत और अहकाम लिखे हैं और जो इसराईल की तालीमो-तरबियत के लिए ज़रूरी हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","मूसा अपने मददगार यशुअ के साथ चल पड़ा और अल्लाह के पहाड़ पर चढ़ गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","पहले उसने बुज़ुर्गों से कहा, “हमारी वापसी के इंतज़ार में यहाँ ठहरे रहो। हारून और हूर तुम्हारे पास रहेंगे। कोई भी मामला हो तो लोग उन्हीं के पास जाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","जब मूसा चढ़ने लगा तो पहाड़ पर बादल छा गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","रब का जलाल कोहे-सीना पर उतर आया। छः दिन तक बादल उस पर छाया रहा। सातवें दिन रब ने बादल में से मूसा को बुलाया। ");
INSERT INTO urdgvh_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","रब का जलाल इसराईलियों को भी नज़र आता था। उन्हें यों लगा जैसा कि पहाड़ की चोटी पर तेज़ आग भड़क रही हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","चढ़ते चढ़ते मूसा बादल में दाख़िल हुआ। वहाँ वह चालीस दिन और चालीस रात रहा। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“इसराईलियों को बता कि वह हदिये लाकर मुझे उठानेवाली क़ुरबानी के तौर पर पेश करें। लेकिन सिर्फ़ उनसे हदिये क़बूल करो जो दिली ख़ुशी से दें। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","उनसे यह चीज़ें हदिये के तौर पर क़बूल करो : सोना, चाँदी, पीतल; ");
INSERT INTO urdgvh_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","नीले, अरग़वानी और क़िरमिज़ी रंग का धागा, बारीक कतान, बकरी के बाल, ");
INSERT INTO urdgvh_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","मेंढों की सुर्ख़ रँगी हुई खालें, तख़स की खालें, कीकर की लकड़ी, ");
INSERT INTO urdgvh_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","शमादान के लिए ज़ैतून का तेल, मसह करने के लिए तेल और ख़ुशबूदार बख़ूर के लिए मसाले, ");
INSERT INTO urdgvh_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","अक़ीक़े-अहमर और दीगर जवाहर जो इमामे-आज़म के बालापोश और सीने के कीसे में जड़े जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","इन चीज़ों से लोग मेरे लिए मक़दिस बनाएँ ताकि मैं उनके दरमियान रहूँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","मैं तुझे मक़दिस और उसके तमाम सामान का नमूना दिखाऊँगा, क्योंकि तुम्हें सब कुछ ऐन उसी के मुताबिक़ बनाना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","12","लोग कीकर की लकड़ी का संदूक़ बनाएँ। उस की लंबाई पौने चार फ़ुट हो जबकि उस की चौड़ाई और ऊँचाई सवा दो दो फ़ुट हो। पूरे संदूक़ पर अंदर और बाहर से ख़ालिस सोना चढ़ाना। ऊपर की सतह के इर्दगिर्द सोने की झालर लगाना। संदूक़ को उठाने के लिए सोने के चार कड़े ढालकर उन्हें संदूक़ के चारपाइयों पर लगाना। दोनों तरफ़ दो दो कड़े हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","फिर कीकर की दो लकड़ियाँ संदूक़ को उठाने के लिए तैयार करना। उन पर सोना चढ़ाकर ");
INSERT INTO urdgvh_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","उनको दोनों तरफ़ के कड़ों में डालना ताकि उनसे संदूक़ को उठाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","यह लकड़ियाँ संदूक़ के इन कड़ों में पड़ी रहें। उन्हें कभी भी दूर न किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","संदूक़ में शरीअत की वह दो तख़्तियाँ रखना जो मैं तुझे दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","संदूक़ का ढकना ख़ालिस सोने का बनाना। उस की लंबाई पौने चार फ़ुट और चौड़ाई सवा दो फ़ुट हो। उसका नाम कफ़्फ़ारे का ढकना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","सोने से घड़कर दो करूबी फ़रिश्ते बनाए जाएँ जो ढकने के दोनों सिरों पर खड़े हों। यह दो फ़रिश्ते और ढकना एक ही टुकड़े से बनाने हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","फ़रिश्तों के पर यों ऊपर की तरफ़ फैले हुए हों कि वह ढकने को पनाह दें। उनके मुँह एक दूसरे की तरफ़ किए हुए हों, और वह ढकने की तरफ़ देखें। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ढकने को संदूक़ पर लगा, और संदूक़ में शरीअत की वह दो तख़्तियाँ रख जो मैं तुझे दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","वहाँ ढकने के ऊपर दोनों फ़रिश्तों के दरमियान से मैं अपने आपको तुझ पर ज़ाहिर करके तुझसे हमकलाम हूँगा और तुझे इसराईलियों के लिए तमाम अहकाम दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","कीकर की लकड़ी की मेज़ बनाना। उस की लंबाई तीन फ़ुट, चौड़ाई डेढ़ फ़ुट और ऊँचाई सवा दो फ़ुट हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","उस पर ख़ालिस सोना चढ़ाना, और उसके इर्दगिर्द सोने की झालर लगाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","मेज़ की ऊपर की सतह पर चौखटा लगाना जिसकी ऊँचाई तीन इंच हो और जिस पर सोने की झालर लगी हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","सोने के चार कड़े ढालकर उन्हें चारों कोनों पर लगाना जहाँ मेज़ के पाए लगे हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","यह कड़े मेज़ की सतह पर लगे चौखटे के नीचे लगाए जाएँ। उनमें वह लकड़ियाँ डालनी हैं जिनसे मेज़ को उठाया जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","यह लकड़ियाँ भी कीकर की हों और उन पर सोना चढ़ाया जाए। उनसे मेज़ को उठाना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","उसके थाल, प्याले, मरतबान और मै की नज़रें पेश करने के बरतन ख़ालिस सोने से बनाना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","मेज़ पर वह रोटियाँ हर वक़्त मेरे हुज़ूर पड़ी रहें जो मेरे लिए मख़सूस हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","ख़ालिस सोने का शमादान भी बनाना। उसका पाया और डंडी घड़कर बनाना है। उस की प्यालियाँ जो फूलों और कलियों की शक्ल की होंगी पाए और डंडी के साथ एक ही टुकड़ा हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","डंडी से दाईं और बाईं तरफ़ तीन तीन शाख़ें निकलें। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","हर शाख़ पर तीन प्यालियाँ लगी हों जो बादाम की कलियों और फूलों की शक्ल की हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","शमादान की डंडी पर भी इस क़िस्म की प्यालियाँ लगी हों, लेकिन तादाद में चार। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","इनमें से तीन प्यालियाँ दाएँ बाएँ की छः शाख़ों के नीचे लगी हों। वह यों लगी हों कि हर प्याली से दो शाख़ें निकलें। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","शाख़ें और प्यालियाँ बल्कि पूरा शमादान ख़ालिस सोने के एक ही टुकड़े से घड़कर बनाना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","शमादान के लिए सात चराग़ बनाकर उन्हें यों शाख़ों पर रखना कि वह सामने की जगह रौशन करें। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","बत्ती कतरने की क़ैंचियाँ और जलते कोयले के लिए छोटे बरतन भी ख़ालिस सोने से बनाए जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","शमादान और उस सारे सामान के लिए पूरे 34 किलोग्राम ख़ालिस सोना इस्तेमाल किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ग़ौर कर कि सब कुछ ऐन उस नमूने के मुताबिक़ बनाया जाए जो मैं तुझे यहाँ पहाड़ पर दिखाता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","मुक़द्दस ख़ैमे के लिए दस परदे बनाना। उनके लिए बारीक कतान और नीले, अरग़वानी और क़िरमिज़ी रंग का धागा इस्तेमाल करना। परदों में किसी माहिर कारीगर के कढ़ाई के काम से करूबी फ़रिश्तों का डिज़ायन बनवाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","हर परदे की लंबाई 42 फ़ुट और चौड़ाई 6 फ़ुट हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","पाँच परदों के लंबे हाशिये एक दूसरे के साथ जोड़े जाएँ और इसी तरह बाक़ी पाँच भी। यों दो बड़े टुकड़े बन जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","दोनों टुकड़ों को एक दूसरे के साथ मिलाने के लिए नीले धागे के हलक़े बनाना। यह हलक़े हर टुकड़े के 42 फ़ुटवाले एक किनारे पर लगाए जाएँ, ");
INSERT INTO urdgvh_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","एक टुकड़े के हाशिये पर 50 हलक़े और दूसरे पर भी उतने ही हलक़े। इन दो हाशियों के हलक़े एक दूसरे के आमने-सामने हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","फिर सोने की 50 हुकें बनाकर उनसे आमने-सामने के हलक़े एक दूसरे के साथ मिलाना। यों दोनों टुकड़े जुड़कर ख़ैमे का काम देंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","बकरी के बालों से भी 11 परदे बनाना जिन्हें कपड़ेवाले ख़ैमे के ऊपर रखा जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","हर परदे की लंबाई 45 फ़ुट और चौड़ाई 6 फ़ुट हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","पाँच परदों के लंबे हाशिये एक दूसरे के साथ जोड़े जाएँ और इसी तरह बाक़ी छः भी। इन छः परदों के छटे परदे को एक दफ़ा तह करना। यह सामनेवाले हिस्से से लटके। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","बकरी के बाल के इन दोनों टुकड़ों को भी मिलाना है। इसके लिए हर टुकड़े के 45 फ़ुटवाले एक किनारे पर पचास पचास हलक़े लगाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","फिर पीतल की 50 हुकें बनाकर उनसे दोनों हिस्से मिलाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","जब बकरियों के बालों का यह ख़ैमा कपड़े के ख़ैमे के ऊपर लगाया जाएगा तो आधा परदा बाक़ी रहेगा। वह ख़ैमे की पिछली तरफ़ लटका रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ख़ैमे के दाईं और बाईं तरफ़ बकरी के बालों का ख़ैमा कपड़े के ख़ैमे की निसबत डेढ़ डेढ़ फ़ुट लंबा होगा। यों वह दोनों तरफ़ लटके हुए कपड़े के ख़ैमे को महफ़ूज़ रखेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","एक दूसरे के ऊपर के इन दोनों ख़ैमों की हिफ़ाज़त के लिए दो ग़िलाफ़ बनाने हैं। बकरी के बालों के ख़ैमे पर मेंढों की सुर्ख़ रँगी हुई खालें जोड़कर रखी जाएँ और उन पर तख़स की खालें मिलाकर रखी जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","कीकर की लकड़ी के तख़्ते बनाना जो खड़े किए जाएँ ताकि ख़ैमे की दीवारों का काम दें। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","हर तख़्ते की ऊँचाई 15 फ़ुट हो और चौड़ाई सवा दो फ़ुट। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","हर तख़्ते के नीचे दो दो चूलें हों। यह चूलें हर तख़्ते को उसके पाइयों के साथ जोड़ेंगी ताकि तख़्ता खड़ा रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","ख़ैमे की जुनूबी दीवार के लिए 20 तख़्तों की ज़रूरत है ");
INSERT INTO urdgvh_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","और साथ ही चाँदी के 40 पाइयों की। उन पर तख़्ते खड़े किए जाएंगे। हर तख़्ते के नीचे दो पाए होंगे, और हर पाए में एक चूल लगेगी। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","इसी तरह ख़ैमे की शिमाली दीवार के लिए भी 20 तख़्तों की ज़रूरत है ");
INSERT INTO urdgvh_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","और साथ ही चाँदी के 40 पाइयों की। वह भी तख़्तों को खड़ा करने के लिए हैं। हर तख़्ते के नीचे दो पाए होंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ख़ैमे की पिछली यानी मग़रिबी दीवार के लिए छः तख़्ते बनाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","इस दीवार को शिमाली और जुनूबी दीवारों के साथ जोड़ने के लिए कोनेवाले दो तख़्ते बनाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","इन दो तख़्तों में नीचे से लेकर ऊपर तक कोना हो ताकि एक से शिमाली दीवार मग़रिबी दीवार के साथ जुड़ जाए और दूसरे से जुनूबी दीवार मग़रिबी दीवार के साथ। इनके ऊपर के सिरे कड़ों से मज़बूत किए जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","यों पिछले यानी मग़रिबी तख़्तों की पूरी तादाद 8 होगी और इनके लिए चाँदी के पाइयों की तादाद 16, हर तख़्ते के नीचे दो दो पाए होंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","27","इसके अलावा कीकर की लकड़ी के शहतीर बनाना, तीनों दीवारों के लिए पाँच पाँच शहतीर। वह हर दीवार के तख़्तों पर यों लगाए जाएँ कि वह उन्हें एक दूसरे के साथ मिलाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","दरमियानी शहतीर दीवार की आधी ऊँचाई पर दीवार के एक सिरे से दूसरे सिरे तक लगाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","शहतीरों को तख़्तों के साथ लगाने के लिए सोने के कड़े बनाकर तख़्तों में लगाना। तमाम तख़्तों और शहतीरों पर सोना चढ़ाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","पूरे मुक़द्दस ख़ैमे को उसी नमूने के मुताबिक़ बनाना जो मैं तुझे पहाड़ पर दिखाता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","अब एक और परदा बनाना। इसके लिए भी बारीक कतान और नीले, अरग़वानी और क़िरमिज़ी रंग का धागा इस्तेमाल करना। उस पर भी किसी माहिर कारीगर के कढ़ाई के काम से करूबी फ़रिश्तों का डिज़ायन बनवाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","इसे सोने की हुकों से कीकर की लकड़ी के चार सतूनों से लटकाना। इन सतूनों पर सोना चढ़ाया जाए और वह चाँदी के पाइयों पर खड़े हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","यह परदा मुक़द्दस कमरे को मुक़द्दसतरीन कमरे से अलग करेगा जिसमें अहद का संदूक़ पड़ा रहेगा। परदे को लटकाने के बाद उसके पीछे मुक़द्दसतरीन कमरे में अहद का संदूक़ रखना। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","फिर अहद के संदूक़ पर कफ़्फ़ारे का ढकना रखना। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","जिस मेज़ पर मेरे लिए मख़सूस की गई रोटियाँ पड़ी रहती हैं वह परदे के बाहर मुक़द्दस कमरे में शिमाल की तरफ़ रखी जाए। उसके मुक़ाबिल जुनूब की तरफ़ शमादान रखा जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","फिर ख़ैमे के दरवाज़े के लिए भी परदा बनाया जाए। इसके लिए भी बारीक कतान और नीले, अरग़वानी और क़िरमिज़ी रंग का धागा इस्तेमाल किया जाए। इस पर कढ़ाई का काम किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","इस परदे को सोने की हुकों से कीकर की लकड़ी के पाँच सतूनों से लटकाना। इन सतूनों पर भी सोना चढ़ाया जाए, और वह पीतल के पाइयों पर खड़े हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","कीकर की लकड़ी की क़ुरबानगाह बनाना। उस की ऊँचाई साढ़े चार फ़ुट हो जबकि उस की लंबाई और चौड़ाई साढ़े सात सात फ़ुट हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","उसके ऊपर चारों कोनों में से एक एक सींग निकले। सींग और क़ुरबानगाह एक ही टुकड़े के हों। सब पर पीतल चढ़ाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","उसका तमाम साज़ो-सामान और बरतन भी पीतल के हों यानी राख को उठाकर ले जाने की बालटियाँ, बेलचे, काँटे, जलते हुए कोयले के लिए बरतन और छिड़काव के कटोरे। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","क़ुरबानगाह को उठाने के लिए पीतल का जंगला बनाना जो ऊपर से खुला हो। जंगले के चारों कोनों पर कड़े लगाए जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","क़ुरबानगाह की आधी ऊँचाई पर किनारा लगाना, और क़ुरबानगाह को जंगले में इस किनारे तक रखा जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","उसे उठाने के लिए कीकर की दो लकड़ियाँ बनाना जिन पर पीतल चढ़ाना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","उनको क़ुरबानगाह के दोनों तरफ़ के कड़ों में डाल देना। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","पूरी क़ुरबानगाह लकड़ी की हो, लेकिन अंदर से खोखली हो। उसे ऐन उस नमूने के मुताबिक़ बनाना जो मैं तुझे पहाड़ पर दिखाता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","मुक़द्दस ख़ैमे के लिए सहन बनाना। उस की चारदीवारी बारीक कतान के कपड़े से बनाई जाए। चारदीवारी की लंबाई जुनूब की तरफ़ 150 फ़ुट हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","कपड़े को चाँदी की हुकों और पट्टियों से लकड़ी के 20 खंबों के साथ लगाया जाए। हर खंबा पीतल के पाए पर खड़ा हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","चारदीवारी शिमाल की तरफ़ भी इसी की मानिंद हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ख़ैमे के पीछे मग़रिब की तरफ़ चारदीवारी की चौड़ाई 75 फ़ुट हो और कपड़ा लकड़ी के 10 खंबों के साथ लगाया जाए। यह खंबे भी पीतल के पाइयों पर खड़े हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","सामने, मशरिक़ की तरफ़ जहाँ से सूरज तुलू होता है चारदीवारी की चौड़ाई भी 75 फ़ुट हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","यहाँ चारदीवारी का दरवाज़ा हो। कपड़ा दरवाज़े के दाईं तरफ़ साढ़े 22 फ़ुट चौड़ा हो और उसके बाईं तरफ़ भी उतना ही चौड़ा। उसे दोनों तरफ़ तीन तीन लकड़ी के खंबों के साथ लगाया जाए जो पीतल के पाइयों पर खड़े हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","दरवाज़े का परदा 30 फ़ुट चौड़ा बनाना। वह नीले, अरग़वानी और क़िरमिज़ी रंग के धागे और बारीक कतान से बनाया जाए, और उस पर कढ़ाई का काम हो। यह कपड़ा लकड़ी के चार खंबों के साथ लगाया जाए। वह भी पीतल के पाइयों पर खड़े हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","तमाम खंबे पीतल के पाइयों पर खड़े हों और कपड़ा चाँदी की हुकों और पट्टियों से हर खंबे के साथ लगाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","चारदीवारी की लंबाई 150 फ़ुट, चौड़ाई 75 फ़ुट और ऊँचाई साढ़े 7 फ़ुट हो। खंबों के तमाम पाए पीतल के हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","जो भी साज़ो-सामान मुक़द्दस ख़ैमे में इस्तेमाल किया जाता है वह सब पीतल का हो। ख़ैमे और चारदीवारी की मेख़ें भी पीतल की हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","इसराईलियों को हुक्म देना कि वह तेरे पास कूटे हुए ज़ैतूनों का ख़ालिस तेल लाएँ ताकि मुक़द्दस कमरे के शमादान के चराग़ मुतवातिर जलते रहें। ");
INSERT INTO urdgvh_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","हारून और उसके बेटे शमादान को मुलाक़ात के ख़ैमे के मुक़द्दस कमरे में रखें, उस परदे के सामने जिसके पीछे अहद का संदूक़ है। उसमें वह तेल डालते रहें ताकि वह रब के सामने शाम से लेकर सुबह तक जलता रहे। इसराईलियों का यह उसूल अबद तक क़ायम रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","अपने भाई हारून और उसके बेटों नदब, अबीहू, इलियज़र और इतमर को बुला। मैंने उन्हें इसराईलियों में से चुन लिया है ताकि वह इमामों की हैसियत से मेरी ख़िदमत करें। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","अपने भाई हारून के लिए मुक़द्दस लिबास बनवाना जो पुरवक़ार और शानदार हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","लिबास बनाने की ज़िम्मादारी उन तमाम लोगों को देना जो ऐसे कामों में माहिर हैं और जिनको मैंने हिकमत की रूह से भर दिया है। क्योंकि जब हारून को मख़सूस किया जाएगा और वह मुक़द्दस ख़ैमे की ख़िदमत सरंजाम देगा तो उसे इन कपड़ों की ज़रूरत होगी। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","उसके लिए यह लिबास बनाने हैं : सीने का कीसा, बालापोश, चोग़ा, बुना हुआ ज़ेरजामा, पगड़ी और कमरबंद। यह कपड़े अपने भाई हारून और उसके बेटों के लिए बनवाने हैं ताकि वह इमाम के तौर पर ख़िदमत कर सकें। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","इन कपड़ों के लिए सोना और नीले, अरग़वानी और क़िरमिज़ी रंग का धागा और बारीक कतान इस्तेमाल किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","बालापोश को भी सोने और नीले, अरग़वानी और क़िरमिज़ी रंग के धागे और बारीक कतान से बनाना है। उस पर किसी माहिर कारीगर से कढ़ाई का काम करवाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","उस की दो पट्टियाँ हों जो कंधों पर रखकर सामने और पीछे से बालापोश के साथ लगी हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","इसके अलावा एक पटका बुनना है जिससे बालापोश को बाँधा जाए और जो बालापोश के साथ एक टुकड़ा हो। उसके लिए भी सोना, नीले, अरग़वानी और क़िरमिज़ी रंग का धागा और बारीक कतान इस्तेमाल किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","फिर अक़ीक़े-अहमर के दो पत्थर चुनकर उन पर इसराईल के बारह बेटों के नाम कंदा करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","हर जौहर पर छः छः नाम उनकी पैदाइश की तरतीब के मुताबिक़ कंदा किए जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","यह नाम उस तरह जौहरों पर कंदा किए जाएँ जिस तरह मुहर कंदा की जाती है। फिर दोनों जौहर सोने के ख़ानों में जड़कर ");
INSERT INTO urdgvh_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","बालापोश की दो पट्टियों पर ऐसे लगाना कि कंधों पर आ जाएँ। जब हारून मेरे हुज़ूर आएगा तो जौहरों पर के यह नाम उसके कंधों पर होंगे और मुझे इसराईलियों की याद दिलाएँगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","सोने के ख़ाने बनाना ");
INSERT INTO urdgvh_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","और ख़ालिस सोने की दो ज़ंजीरें जो डोरी की तरह गुंधी हुई हों। फिर इन दो ज़ंजीरों को सोने के ख़ानों के साथ लगाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","सीने के लिए कीसा बनाना। उसमें वह क़ुरे पड़े रहें जिनकी मारिफ़त मेरी मरज़ी मालूम की जाएगी। माहिर कारीगर उसे उन्हीं चीज़ों से बनाए जिनसे हारून का बालापोश बनाया गया है यानी सोने और नीले, अरग़वानी और क़िरमिज़ी रंग के धागे और बारीक कतान से। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","जब कपड़े को एक दफ़ा तह किया गया हो तो कीसे की लंबाई और चौड़ाई नौ नौ इंच हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","उस पर चार क़तारों में जवाहर जड़ना। हर क़तार में तीन तीन जौहर हों। पहली क़तार में लाल, ज़बरजद और ज़ुमुर्रद। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","दूसरी में फ़ीरोज़ा, संगे-लाजवर्द और हजरुल-क़मर। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","तीसरी में ज़रक़ोन, अक़ीक़ और याक़ूते-अरग़वानी। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","चौथी में पुखराज, अक़ीक़े-अहमर और यशब। हर जौहर सोने के ख़ाने में जड़ा हुआ हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","यह बारह जवाहर इसराईल के बारह क़बीलों की नुमाइंदगी करते हैं। एक एक जौहर पर एक क़बीले का नाम कंदा किया जाए। यह नाम उस तरह कंदा किए जाएँ जिस तरह मुहर कंदा की जाती है। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","सीने के कीसे पर ख़ालिस सोने की दो ज़ंजीरें लगाना जो डोरी की तरह गुंधी हुई हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","उन्हें लगाने के लिए दो कड़े बनाकर कीसे के ऊपर के दो कोनों पर लगाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","अब दोनों ज़ंजीरें उन दो कड़ों से लगाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","उनके दूसरे सिरे बालापोश की कंधोंवाली पट्टियों के दो ख़ानों के साथ जोड़ देना, फिर सामने की तरफ़ लगाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","कीसे के निचले दो कोनों पर भी सोने के दो कड़े लगाना। वह अंदर, बालापोश की तरफ़ लगे हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","अब दो और कड़े बनाकर बालापोश की कंधोंवाली पट्टियों पर लगाना। यह भी सामने की तरफ़ लगे हों लेकिन नीचे, बालापोश के पटके के ऊपर ही। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","सीने के कीसे के निचले कड़े नीली डोरी से बालापोश के इन निचले कड़ों के साथ बाँधे जाएँ। यों कीसा पटके के ऊपर अच्छी तरह सीने के साथ लगा रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","जब भी हारून मक़दिस में दाख़िल होकर रब के हुज़ूर आएगा वह इसराईली क़बीलों के नाम अपने दिल पर सीने के कीसे की सूरत में साथ ले जाएगा। यों वह क़ौम की याद दिलाता रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","सीने के कीसे में दोनों क़ुरे बनाम ऊरीम और तुम्मीम रखे जाएँ। वह भी मक़दिस में रब के सामने आते वक़्त हारून के दिल पर हों। यों जब हारून रब के हुज़ूर होगा तो रब की मरज़ी पूछने का वसीला हमेशा उसके दिल पर होगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","चोग़ा भी बुनना। वह पूरी तरह नीले धागे से बनाया जाए। चोग़े को बालापोश से पहले पहना जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","उसके गरेबान को बुने हुए कालर से मज़बूत किया जाए ताकि वह न फटे। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","नीले, अरग़वानी और क़िरमिज़ी रंग के धागे से अनार बनाकर उन्हें चोग़े के दामन में लगा देना। उनके दरमियान सोने की घंटियाँ लगाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","दामन में अनार और घंटियाँ बारी बारी लगाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","हारून ख़िदमत करते वक़्त हमेशा चोग़ा पहने। जब वह मक़दिस में रब के हुज़ूर आएगा और वहाँ से निकलेगा तो घंटियाँ सुनाई देंगी। फिर वह नहीं मरेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","ख़ालिस सोने की तख़्ती बनाकर उस पर यह अलफ़ाज़ कंदा करना, ‘रब के लिए मख़सूसो-मुक़द्दस।’ यह अलफ़ाज़ यों कंदा किए जाएँ जिस तरह मुहर कंदा की जाती है। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","उसे नीली डोरी से पगड़ी के सामनेवाले हिस्से से लगाया जाए ");
INSERT INTO urdgvh_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ताकि वह हारून के माथे पर पड़ी रहे। जब भी वह मक़दिस में जाए तो यह तख़्ती साथ हो। जब इसराईली अपने नज़राने लाकर रब के लिए मख़सूस करें लेकिन किसी ग़लती के बाइस क़ुसूरवार हों तो उनका यह क़ुसूर हारून पर मुंतक़िल होगा। इसलिए यह तख़्ती हर वक़्त उसके माथे पर हो ताकि रब इसराईलियों को क़बूल कर ले। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","ज़ेरजामे को बारीक कतान से बुनना और इस तरह पगड़ी भी। फिर कमरबंद बनाना। उस पर कढ़ाई का काम किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","हारून के बेटों के लिए भी ज़ेरजामे, कमरबंद और पगड़ियाँ बनाना ताकि वह पुरवक़ार और शानदार नज़र आएँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","यह सब अपने भाई हारून और उसके बेटों को पहनाना। उनके सरों पर तेल उंडेलकर उन्हें मसह करना। यों उन्हें उनके ओहदे पर मुक़र्रर करके मेरी ख़िदमत के लिए मख़सूस करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","उनके लिए कतान के पाजामे भी बनाना ताकि वह ज़ेरजामे के नीचे नंगे न हों। उनकी लंबाई कमर से रान तक हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","जब भी हारून और उसके बेटे मुलाक़ात के ख़ैमे में दाख़िल हों तो उन्हें यह पाजामे पहनने हैं। इसी तरह जब उन्हें मुक़द्दस कमरे में ख़िदमत करने के लिए क़ुरबानगाह के पास आना होता है तो वह यह पहनें, वरना वह क़ुसूरवार ठहरकर मर जाएंगे। यह हारून और उस की औलाद के लिए एक अबदी उसूल है। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","इमामों को मक़दिस में मेरी ख़िदमत के लिए मख़सूस करने का यह तरीक़ा है : एक जवान बैल और दो बेऐब मेंढे चुन लेना। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","बेहतरीन मैदे से तीन क़िस्म की चीज़ें पकाना जिनमें ख़मीर न हो। पहले, सादा रोटी। दूसरे, रोटी जिसमें तेल डाला गया हो। तीसरे, रोटी जिस पर तेल लगाया गया हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","यह चीज़ें टोकरी में रखकर जवान बैल और दो मेंढों के साथ रब को पेश करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","फिर हारून और उसके बेटों को मुलाक़ात के ख़ैमे के दरवाज़े पर लाकर ग़ुस्ल कराना। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","इसके बाद ज़ेरजामा, चोग़ा, बालापोश और सीने का कीसा लेकर हारून को पहनाना। बालापोश को उसके महारत से बुने हुए पटके के ज़रीए बाँधना। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","उसके सर पर पगड़ी बाँधकर उस पर सोने की मुक़द्दस तख़्ती लगाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","हारून के सर पर मसह का तेल उंडेलकर उसे मसह करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","फिर उसके बेटों को आगे लाकर ज़ेरजामा पहनाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","उनके पगड़ियाँ और कमरबंद बाँधना। यों तू हारून और उसके बेटों को उनके मंसब पर मुक़र्रर करना। सिर्फ़ वह और उनकी औलाद हमेशा तक मक़दिस में मेरी ख़िदमत करते रहें। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","बैल को मुलाक़ात के ख़ैमे के सामने लाना। हारून और उसके बेटे उसके सर पर अपने हाथ रखें। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","उसे ख़ैमे के दरवाज़े के सामने रब के हुज़ूर ज़बह करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","बैल के ख़ून में से कुछ लेकर अपनी उँगली से क़ुरबानगाह के सींगों पर लगाना और बाक़ी ख़ून क़ुरबानगाह के पाए पर उंडेल देना। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","अंतड़ियों पर की तमाम चरबी, जोड़कलेजी और दोनों गुरदे उनकी चरबी समेत लेकर क़ुरबानगाह पर जला देना। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","लेकिन बैल के गोश्त, खाल और अंतड़ियों के गोबर को ख़ैमागाह के बाहर जला देना। यह गुनाह की क़ुरबानी है। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","इसके बाद पहले मेंढे को ले आना। हारून और उसके बेटे अपने हाथ मेंढे के सर पर रखें। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","उसे ज़बह करके उसका ख़ून क़ुरबानगाह के चार पहलुओं पर छिड़कना। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","मेंढे को टुकड़े टुकड़े करके उस की अंतड़ियों और पिंडलियों को धोना। फिर उन्हें सर और बाक़ी टुकड़ों के साथ मिलाकर ");
INSERT INTO urdgvh_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","पूरे मेंढे को क़ुरबानगाह पर जला देना। जलनेवाली यह क़ुरबानी रब के लिए भस्म होनेवाली क़ुरबानी है, और उस की ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","अब दूसरे मेंढे को ले आना। हारून और उसके बेटे अपने हाथ मेंढे के सर पर रखें। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","उसको ज़बह करना। उसके ख़ून में से कुछ लेकर हारून और उसके बेटों के दहने कान की लौ पर लगाना। इसी तरह ख़ून को उनके दहने हाथ और दहने पाँव के अंगूठों पर भी लगाना। बाक़ी ख़ून क़ुरबानगाह के चार पहलुओं पर छिड़कना। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","जो ख़ून क़ुरबानगाह पर पड़ा है उसमें से कुछ लेकर और मसह के तेल के साथ मिलाकर हारून और उसके कपड़ों पर छिड़कना। इसी तरह उसके बेटों और उनके कपड़ों पर भी छिड़कना। यों वह और उसके बेटे ख़िदमत के लिए मख़सूसो-मुक़द्दस हो जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","इस मेंढे का ख़ास मक़सद यह है कि हारून और उसके बेटों को मक़दिस में ख़िदमत करने का इख़्तियार और ओहदा दिया जाए। मेंढे की चरबी, दुम, अंतड़ियों पर की सारी चरबी, जोड़कलेजी, दोनों गुरदे उनकी चरबी समेत और दहनी रान अलग करनी है। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","उस टोकरी में से जो रब के हुज़ूर यानी ख़ैमे के दरवाज़े पर पड़ी है एक सादा रोटी, एक रोटी जिसमें तेल डाला गया हो और एक रोटी जिस पर तेल लगाया गया हो निकालना। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","मेंढे से अलग की गई चीज़ें और बेख़मीरी रोटी की टोकरी की यह चीज़ें लेकर हारून और उसके बेटों के हाथों में देना, और वह उन्हें हिलानेवाली क़ुरबानी के तौर पर रब के सामने हिलाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","फिर यह चीज़ें उनसे वापस लेकर भस्म होनेवाली क़ुरबानी के साथ क़ुरबानगाह पर जला देना। यह रब के लिए जलनेवाली क़ुरबानी है, और उस की ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","अब उस मेंढे का सीना लेना जिसकी मारिफ़त हारून को इमामे-आज़म का इख़्तियार दिया जाता है। सीने को भी हिलानेवाली क़ुरबानी के तौर पर रब के सामने हिलाना। यह सीना क़ुरबानी का तेरा हिस्सा होगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","यों तुझे हारून और उसके बेटों की मख़सूसियत के लिए मुस्तामल मेंढे के टुकड़े मख़सूसो-मुक़द्दस करने हैं। उसके सीने को रब के सामने हिलानेवाली क़ुरबानी के तौर पर हिलाया जाए और उस की रान को उठानेवाली क़ुरबानी के तौर पर उठाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","हारून और उस की औलाद को इसराईलियों की तरफ़ से हमेशा तक यह मिलने का हक़ है। जब भी इसराईली रब को अपनी सलामती की क़ुरबानियाँ पेश करें तो इमामों को यह दो टुकड़े मिलेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","जब हारून फ़ौत हो जाएगा तो उसके मुक़द्दस लिबास उस की औलाद में से उस मर्द को देने हैं जिसे मसह करके हारून की जगह मुक़र्रर किया जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","जो बेटा उस की जगह मुक़र्रर किया जाएगा और मक़दिस में ख़िदमत करने के लिए मुलाक़ात के ख़ैमे में आएगा वह यह लिबास सात दिन तक पहने रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","जो मेंढा हारून और उसके बेटों की मख़सूसियत के लिए ज़बह किया गया है उसे मुक़द्दस जगह पर उबालना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","फिर हारून और उसके बेटे मुलाक़ात के ख़ैमे के दरवाज़े पर मेंढे का गोश्त और टोकरी की बेख़मीरी रोटियाँ खाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","वह यह चीज़ें खाएँ जिनसे उन्हें गुनाहों का कफ़्फ़ारा और इमाम का ओहदा मिला है। लेकिन कोई और यह न खाए, क्योंकि यह मख़सूसो-मुक़द्दस हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","और अगर अगली सुबह तक इस गोश्त या रोटी में से कुछ बच जाए तो उसे जलाया जाए। उसे खाना मना है, क्योंकि वह मुक़द्दस है। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","जब तू हारून और उसके बेटों को इमाम मुक़र्रर करेगा तो ऐन मेरी हिदायत पर अमल करना। यह तक़रीब सात दिन तक मनाई जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","इसके दौरान गुनाह की क़ुरबानी के तौर पर रोज़ाना एक जवान बैल ज़बह करना। इससे तू क़ुरबानगाह का कफ़्फ़ारा देकर उसे हर तरह की नापाकी से पाक करेगा। इसके अलावा उस पर मसह का तेल उंडेलना। इससे वह मेरे लिए मख़सूसो-मुक़द्दस हो जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","सात दिन तक क़ुरबानगाह का कफ़्फ़ारा देकर उसे पाक-साफ़ करना और उसे तेल से मख़सूसो-मुक़द्दस करना। फिर क़ुरबानगाह निहायत मुक़द्दस होगी। जो भी उसे छुएगा वह भी मख़सूसो-मुक़द्दस हो जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","रोज़ाना एक एक साल के दो भेड़ के नर बच्चे क़ुरबानगाह पर जला देना, ");
INSERT INTO urdgvh_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","एक को सुबह के वक़्त, दूसरे को सूरज के ग़ुरूब होने के ऐन बाद। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","पहले जानवर के साथ डेढ़ किलोग्राम बेहतरीन मैदा पेश किया जाए जो कूटे हुए ज़ैतूनों के एक लिटर तेल के साथ मिलाया गया हो। मै की नज़र के तौर पर एक लिटर मै भी क़ुरबानगाह पर उंडेलना। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","दूसरे जानवर के साथ भी ग़ल्ला और मै की यह दो नज़रें पेश की जाएँ। ऐसी क़ुरबानी की ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","लाज़िम है कि आनेवाली तमाम नसलें भस्म होनेवाली यह क़ुरबानी बाक़ायदगी से मुक़द्दस ख़ैमे के दरवाज़े पर रब के हुज़ूर चढ़ाएँ। वहाँ मैं तुमसे मिला करूँगा और तुमसे हमकलाम हूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","वहाँ मैं इसराईलियों से भी मिला करूँगा, और वह जगह मेरे जलाल से मख़सूसो-मुक़द्दस हो जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","यों मैं मुलाक़ात के ख़ैमे और क़ुरबानगाह को मख़सूस करूँगा और हारून और उसके बेटों को मख़सूस करूँगा ताकि वह इमामों की हैसियत से मेरी ख़िदमत करें। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","तब मैं इसराईलियों के दरमियान रहूँगा और उनका ख़ुदा हूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","वह जान लेंगे कि मैं रब उनका ख़ुदा हूँ, कि मैं उन्हें मिसर से निकाल लाया ताकि उनके दरमियान सुकूनत करूँ। मैं रब उनका ख़ुदा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","कीकर की लकड़ी की क़ुरबानगाह बनाना जिस पर बख़ूर जलाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","वह डेढ़ फ़ुट लंबी, इतनी ही चौड़ी और तीन फ़ुट ऊँची हो। उसके चारों कोनों में से सींग निकलें जो क़ुरबानगाह के साथ एक ही टुकड़े से बनाए गए हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","उस की ऊपर की सतह, उसके चार पहलुओं और उसके सींगों पर ख़ालिस सोना चढ़ाना। ऊपर की सतह के इर्दगिर्द सोने की झालर हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","सोने के दो कड़े बनाकर इन्हें उस झालर के नीचे एक दूसरे के मुक़ाबिल पहलुओं पर लगाना। इन कड़ों में क़ुरबानगाह को उठाने की लकड़ियाँ डाली जाएँगी। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","यह लकड़ियाँ कीकर की हों, और उन पर भी सोना चढ़ाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","इस क़ुरबानगाह को ख़ैमे के मुक़द्दस कमरे में उस परदे के सामने रखना जिसके पीछे अहद का संदूक़ और उसका ढकना होंगे, वह ढकना जहाँ मैं तुझसे मिला करूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","जब हारून हर सुबह शमादान के चराग़ तैयार करे उस वक़्त वह उस पर ख़ुशबूदार बख़ूर जलाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","सूरज के ग़ुरूब होने के बाद भी जब वह दुबारा चराग़ों की देख-भाल करेगा तो वह साथ साथ बख़ूर जलाए। यों रब के सामने बख़ूर मुतवातिर जलता रहे। लाज़िम है कि बाद की नसलें भी इस उसूल पर क़ायम रहें। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","इस क़ुरबानगाह पर सिर्फ़ जायज़ बख़ूर इस्तेमाल किया जाए। इस पर न तो जानवरों की क़ुरबानियाँ चढ़ाई जाएँ, न ग़ल्ला या मै की नज़रें पेश की जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","हारून साल में एक दफ़ा उसका कफ़्फ़ारा देकर उसे पाक करे। इसके लिए वह कफ़्फ़ारे के दिन उस क़ुरबानी का कुछ ख़ून सींगों पर लगाए। यह उसूल भी अबद तक क़ायम रहे। यह क़ुरबानगाह रब के लिए निहायत मुक़द्दस है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“जब भी तू इसराईलियों की मर्दुमशुमारी करे तो लाज़िम है कि जिनका शुमार किया गया हो वह रब को अपनी जान का फ़िद्या दें ताकि उनमें वबा न फैले। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","जिस जिसका शुमार किया गया हो वह चाँदी के आधे सिक्के के बराबर रक़म उठानेवाली क़ुरबानी के तौर पर दे। सिक्के का वज़न मक़दिस के सिक्कों के बराबर हो। यानी चाँदी के सिक्के का वज़न 11 ग्राम हो, इसलिए छः ग्राम चाँदी देनी है। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","जिसकी भी उम्र 20 साल या इससे ज़ायद हो वह रब को यह रक़म उठानेवाली क़ुरबानी के तौर पर दे। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","अमीर और ग़रीब दोनों इतना ही दें, क्योंकि यही नज़राना रब को पेश करने से तुम्हारी जान का कफ़्फ़ारा दिया जाता है। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","कफ़्फ़ारे की यह रक़म मुलाक़ात के ख़ैमे की ख़िदमत के लिए इस्तेमाल करना। फिर यह नज़राना रब को याद दिलाता रहेगा कि तुम्हारी जानों का कफ़्फ़ारा दिया गया है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“पीतल का ढाँचा बनाना जिस पर पीतल का हौज़ बनाकर रखना है। यह हौज़ धोने के लिए है। उसे सहन में मुलाक़ात के ख़ैमे और जानवरों को चढ़ाने की क़ुरबानगाह के दरमियान रखकर पानी से भर देना। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","हारून और उसके बेटे अपने हाथ-पाँव धोने के लिए उसका पानी इस्तेमाल करें। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","मुलाक़ात के ख़ैमे में दाख़िल होने से पहले ही वह अपने आपको धोएँ वरना वह मर जाएंगे। इसी तरह जब भी वह ख़ैमे के बाहर की क़ुरबानगाह पर जानवरों की क़ुरबानियाँ चढ़ाएँ ");
INSERT INTO urdgvh_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","तो लाज़िम है कि पहले हाथ-पाँव धो लें, वरना वह मर जाएंगे। यह उसूल हारून और उस की औलाद के लिए हमेशा तक क़ायम रहे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“मसह के तेल के लिए उम्दा क़िस्म के मसाले इस्तेमाल करना। 6 किलोग्राम आबे-मुर, 3 किलोग्राम ख़ुशबूदार दारचीनी, 3 किलोग्राम ख़ुशबूदार बेद ");
INSERT INTO urdgvh_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","और 6 किलोग्राम तेजपात। यह चीज़ें मक़दिस के बाटों के हिसाब से तोलकर चार लिटर ज़ैतून के तेल में डालना। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","सब कुछ मिलाकर ख़ुशबूदार तेल तैयार करना। वह मुक़द्दस है और सिर्फ़ उस वक़्त इस्तेमाल किया जाए जब कोई चीज़ या शख़्स मेरे लिए मख़सूसो-मुक़द्दस किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","यही तेल लेकर मुलाक़ात का ख़ैमा और उसका सारा सामान मसह करना यानी ख़ैमा, अहद का संदूक़, ");
INSERT INTO urdgvh_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","मेज़ और उसका सामान, शमादान और उसका सामान, बख़ूर जलाने की क़ुरबानगाह, ");
INSERT INTO urdgvh_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","जानवरों को चढ़ाने की क़ुरबानगाह और उसका सामान, धोने का हौज़ और उसका ढाँचा। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","यों तू यह तमाम चीज़ें मख़सूसो-मुक़द्दस करेगा। इससे वह निहायत मुक़द्दस हो जाएँगी। जो भी उन्हें छुएगा वह मुक़द्दस हो जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","हारून और उसके बेटों को भी इस तेल से मसह करना ताकि वह मुक़द्दस होकर मेरे लिए इमाम का काम सरंजाम दे सकें। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","इसराईलियों को कह दे कि यह तेल हमेशा तक मेरे लिए मख़सूसो-मुक़द्दस है। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","इसलिए इसे अपने लिए इस्तेमाल न करना और न इस तरकीब से अपने लिए तेल बनाना। यह तेल मख़सूसो-मुक़द्दस है और तुम्हें भी इसे यों ठहराना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","जो इस तरकीब से आम इस्तेमाल के लिए तेल बनाता है या किसी आम शख़्स पर लगाता है उसे उस की क़ौम में से मिटा डालना है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","रब ने मूसा से कहा, “बख़ूर इस तरकीब से बनाना है : मस्तकी, ओनिका, बिरीजा और ख़ालिस लुबान बराबर के हिस्सों में ");
INSERT INTO urdgvh_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","मिलाकर ख़ुशबूदार बख़ूर बनाना। इत्रसाज़ का यह काम नमकीन, ख़ालिस और मुक़द्दस हो। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","इसमें से कुछ पीसकर पौडर बनाना और मुलाक़ात के ख़ैमे में अहद के संदूक़ के सामने डालना जहाँ मैं तुझसे मिला करूँगा। इस बख़ूर को मुक़द्दसतरीन ठहराना। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","इसी तरकीब के मुताबिक़ अपने लिए बख़ूर न बनाना। इसे रब के लिए मख़सूसो-मुक़द्दस ठहराना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","जो भी अपने ज़ाती इस्तेमाल के लिए इस क़िस्म का बख़ूर बनाए उसे उस की क़ौम में से मिटा डालना है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","फिर रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“मैंने यहूदाह के क़बीले के बज़लियेल बिन ऊरी बिन हूर को चुन लिया है ताकि वह मुक़द्दस ख़ैमे की तामीर में राहनुमाई करे। ");
INSERT INTO urdgvh_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","मैंने उसे इलाही रूह से मामूर करके हिकमत, समझ और तामीर के हर काम के लिए दरकार इल्म दे दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","वह नक़्शे बनाकर उनके मुताबिक़ सोने, चाँदी और पीतल की चीज़ें बना सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","वह जवाहर को काटकर जड़ने की क़ाबिलियत रखता है। वह लकड़ी को तराशकर उससे मुख़्तलिफ़ चीज़ें बना सकता है। वह बहुत सारे और कामों में भी महारत रखता है। ");
INSERT INTO urdgvh_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","साथ ही मैंने दान के क़बीले के उहलियाब बिन अख़ी-समक को मुक़र्रर किया है ताकि वह हर काम में उस की मदद करे। इसके अलावा मैंने तमाम समझदार कारीगरों को महारत दी है ताकि वह सब कुछ उन हिदायात के मुताबिक़ बना सकें जो मैंने तुझे दी हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","यानी मुलाक़ात का ख़ैमा, कफ़्फ़ारे के ढकने समेत अहद का संदूक़ और ख़ैमे का सारा दूसरा सामान, ");
INSERT INTO urdgvh_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","मेज़ और उसका सामान, ख़ालिस सोने का शमादान और उसका सामान, बख़ूर जलाने की क़ुरबानगाह, ");
INSERT INTO urdgvh_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","जानवरों को चढ़ाने की क़ुरबानगाह और उसका सामान, धोने का हौज़ उस ढाँचे समेत जिस पर वह रखा जाता है, ");
INSERT INTO urdgvh_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","वह लिबास जो हारून और उसके बेटे मक़दिस में ख़िदमत करने के लिए पहनते हैं, ");
INSERT INTO urdgvh_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","मसह का तेल और मक़दिस के लिए ख़ुशबूदार बख़ूर। यह सब कुछ वह वैसे ही बनाएँ जैसे मैंने तुझे हुक्म दिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“इसराईलियों को बता कि हर सबत का दिन ज़रूर मनाओ। क्योंकि सबत का दिन एक नुमायाँ निशान है जिससे जान लिया जाएगा कि मैं रब हूँ जो तुम्हें मख़सूसो-मुक़द्दस करता हूँ। और यह निशान मेरे और तुम्हारे दरमियान नसल-दर-नसल क़ायम रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","सबत का दिन ज़रूर मनाना, क्योंकि वह तुम्हारे लिए मख़सूसो-मुक़द्दस है। जो भी उस की बेहुरमती करे वह ज़रूर जान से मारा जाए। जो भी इस दिन काम करे उसे उस की क़ौम में से मिटाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","छः दिन काम करना, लेकिन सातवाँ दिन आराम का दिन है। वह रब के लिए मख़सूसो-मुक़द्दस है। ");
INSERT INTO urdgvh_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","इसराईलियों को हाल में और मुस्तक़बिल में सबत का दिन अबदी अहद समझकर मनाना है। ");
INSERT INTO urdgvh_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","वह मेरे और इसराईलियों के दरमियान अबदी निशान होगा। क्योंकि रब ने छः दिन के दौरान आसमानो-ज़मीन को बनाया जबकि सातवें दिन उसने आराम किया और ताज़ादम हो गया।” ");
INSERT INTO urdgvh_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","यह सब कुछ मूसा को बताने के बाद रब ने उसे सीना पहाड़ पर शरीअत की दो तख़्तियाँ दीं। अल्लाह ने ख़ुद पत्थर की इन तख़्तियों पर तमाम बातें लिखी थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","पहाड़ के दामन में लोग मूसा के इंतज़ार में रहे, लेकिन बहुत देर हो गई। एक दिन वह हारून के गिर्द जमा होकर कहने लगे, “आएँ, हमारे लिए देवता बना दें जो हमारे आगे आगे चलते हुए हमारी राहनुमाई करें। क्योंकि क्या मालूम कि उस बंदे मूसा को क्या हुआ है जो हमें मिसर से निकाल लाया।” ");
INSERT INTO urdgvh_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","जवाब में हारून ने कहा, “आपकी बीवियाँ, बेटे और बेटियाँ अपनी सोने की बालियाँ उतारकर मेरे पास ले आएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","सब लोग अपनी बालियाँ उतार उतारकर हारून के पास ले आए ");
INSERT INTO urdgvh_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","तो उसने यह ज़ेवरात लेकर बछड़ा ढाल दिया। बछड़े को देखकर लोग बोल उठे, “ऐ इसराईल, यह तेरे देवता हैं जो तुझे मिसर से निकाल लाए।” ");
INSERT INTO urdgvh_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","जब हारून ने यह देखा तो उसने बछड़े के सामने क़ुरबानगाह बनाकर एलान किया, “कल हम रब की ताज़ीम में ईद मनाएँगे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","अगले दिन लोग सुबह-सवेरे उठे और भस्म होनेवाली क़ुरबानियाँ और सलामती की क़ुरबानियाँ चढ़ाईं। वह खाने-पीने के लिए बैठ गए और फिर उठकर रंगरलियों में अपने दिल बहलाने लगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","उस वक़्त रब ने मूसा से कहा, “पहाड़ से उतर जा। तेरे लोग जिन्हें तू मिसर से निकाल लाया बड़ी शरारतें कर रहे हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","वह कितनी जल्दी से उस रास्ते से हट गए हैं जिस पर चलने के लिए मैंने उन्हें हुक्म दिया था। उन्होंने अपने लिए ढाला हुआ बछड़ा बनाकर उसे सिजदा किया है। उन्होंने उसे क़ुरबानियाँ पेश करके कहा है, ‘ऐ इसराईल, यह तेरे देवता हैं। यही तुझे मिसर से निकाल लाए हैं’।” ");
INSERT INTO urdgvh_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","अल्लाह ने मूसा से कहा, “मैंने देखा है कि यह क़ौम बड़ी हटधर्म है। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","अब मुझे रोकने की कोशिश न कर। मैं उन पर अपना ग़ज़ब उंडेलकर उनको रूए-ज़मीन पर से मिटा दूँगा। उनकी जगह मैं तुझसे एक बड़ी क़ौम बना दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","लेकिन मूसा ने कहा, “ऐ रब, तू अपनी क़ौम पर अपना ग़ुस्सा क्यों उतारना चाहता है? तू ख़ुद अपनी अज़ीम क़ुदरत से उसे मिसर से निकाल लाया है। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","मिसरी क्यों कहें, ‘रब इसराईलियों को सिर्फ़ इस बुरे मक़सद से हमारे मुल्क से निकाल ले गया है कि उन्हें पहाड़ी इलाक़े में मार डाले और यों उन्हें रूए-ज़मीन पर से मिटाए’? अपना ग़ुस्सा ठंडा होने दे और अपनी क़ौम के साथ बुरा सुलूक करने से बाज़ रह। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","याद रख कि तूने अपने ख़ादिमों इब्राहीम, इसहाक़ और याक़ूब से अपनी ही क़सम खाकर कहा था, ‘मैं तुम्हारी औलाद की तादाद यों बढ़ाऊँगा कि वह आसमान के सितारों के बराबर हो जाएगी। मैं उन्हें वह मुल्क दूँगा जिसका वादा मैंने किया है, और वह उसे हमेशा के लिए मीरास में पाएँगे’।” ");
INSERT INTO urdgvh_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","मूसा के कहने पर रब ने वह नहीं किया जिसका एलान उसने कर दिया था बल्कि वह अपनी क़ौम से बुरा सुलूक करने से बाज़ रहा। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","मूसा मुड़कर पहाड़ से उतरा। उसके हाथों में शरीअत की दोनों तख़्तियाँ थीं। उन पर आगे पीछे लिखा गया था। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","अल्लाह ने ख़ुद तख़्तियों को बनाकर उन पर अपने अहकाम कंदा किए थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","उतरते उतरते यशुअ ने लोगों का शोर सुना और मूसा से कहा, “ख़ैमागाह में जंग का शोर मच रहा है!” ");
INSERT INTO urdgvh_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","मूसा ने जवाब दिया, “न तो यह फ़तहमंदों के नारे हैं, न शिकस्त खाए हुओं की चीख़-पुकार। मुझे गानेवालों की आवाज़ सुनाई दे रही है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","जब वह ख़ैमागाह के नज़दीक पहुँचा तो उसने लोगों को सोने के बछड़े के सामने नाचते हुए देखा। बड़े ग़ुस्से में आकर उसने तख़्तियों को ज़मीन पर पटख़ दिया, और वह टुकड़े टुकड़े होकर पहाड़ के दामन में गिर गईं। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","मूसा ने इसराईलियों के बनाए हुए बछड़े को जला दिया। जो कुछ बच गया उसे उसने पीस पीसकर पौडर बना डाला और पौडर पानी पर छिड़ककर इसराईलियों को पिला दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","उसने हारून से पूछा, “इन लोगों ने तुम्हारे साथ क्या किया कि तुमने उन्हें ऐसे बड़े गुनाह में फँसा दिया?” ");
INSERT INTO urdgvh_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","हारून ने कहा, “मेरे आक़ा। ग़ुस्से न हों। आप ख़ुद जानते हैं कि यह लोग बदी पर तुले रहते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","उन्होंने मुझसे कहा, ‘हमारे लिए देवता बना दें जो हमारे आगे आगे चलते हुए हमारी राहनुमाई करें। क्योंकि क्या मालूम कि उस बंदे मूसा को क्या हुआ है जो हमें मिसर से निकाल लाया।’ ");
INSERT INTO urdgvh_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","इसलिए मैंने उनको बताया, ‘जिसके पास सोने के ज़ेवरात हैं वह उन्हें उतार लाए।’ जो कुछ उन्होंने मुझे दिया उसे मैंने आग में फेंक दिया तो होते होते सोने का यह बछड़ा निकल आया।” ");
INSERT INTO urdgvh_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","मूसा ने देखा कि लोग बेकाबू हो गए हैं। क्योंकि हारून ने उन्हें बेलगाम छोड़ दिया था, और यों वह इसराईल के दुश्मनों के लिए मज़ाक़ का निशाना बन गए थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","मूसा ख़ैमागाह के दरवाज़े पर खड़े होकर बोला, “जो भी रब का बंदा है वह मेरे पास आए।” जवाब में लावी के क़बीले के तमाम लोग उसके पास जमा हो गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","फिर मूसा ने उनसे कहा, “रब इसराईल का ख़ुदा फ़रमाता है, ‘हर एक अपनी तलवार लेकर ख़ैमागाह में से गुज़रे। एक सिरे के दरवाज़े से शुरू करके दूसरे सिरे के दरवाज़े तक चलते चलते हर मिलनेवाले को जान से मार दो, चाहे वह तुम्हारा भाई, दोस्त या रिश्तेदार ही क्यों न हो। फिर मुड़कर मारते मारते पहले दरवाज़े पर वापस आ जाओ’।” ");
INSERT INTO urdgvh_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","लावियों ने मूसा की हिदायत पर अमल किया तो उस दिन तक़रीबन 3,000 मर्द हलाक हुए। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","यह देखकर मूसा ने लावियों से कहा, “आज अपने आपको मक़दिस में रब की ख़िदमत करने के लिए मख़सूसो-मुक़द्दस करो, क्योंकि तुम अपने बेटों और भाइयों के ख़िलाफ़ लड़ने के लिए तैयार थे। इसलिए रब तुमको आज बरकत देगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","अगले दिन मूसा ने इसराईलियों से बात की, “तुमने निहायत संगीन गुनाह किया है। तो भी मैं अब रब के पास पहाड़ पर जा रहा हूँ। शायद मैं तुम्हारे गुनाह का कफ़्फ़ारा दे सकूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","चुनाँचे मूसा ने रब के पास वापस जाकर कहा, “हाय, इस क़ौम ने निहायत संगीन गुनाह किया है। उन्होंने अपने लिए सोने का देवता बना लिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","मेहरबानी करके उन्हें मुआफ़ कर। लेकिन अगर तू उन्हें मुआफ़ न करे तो फिर मुझे भी अपनी उस किताब में से मिटा दे जिसमें तूने अपने लोगों के नाम दर्ज किए हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","रब ने जवाब दिया, “मैं सिर्फ़ उसको अपनी किताब में से मिटाता हूँ जो मेरा गुनाह करता है। ");
INSERT INTO urdgvh_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","अब जा, लोगों को उस जगह ले चल जिसका ज़िक्र मैंने किया है। मेरा फ़रिश्ता तेरे आगे आगे चलेगा। लेकिन जब सज़ा का मुक़र्ररा दिन आएगा तब मैं उन्हें सज़ा दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","फिर रब ने इसराईलियों के दरमियान वबा फैलने दी, इसलिए कि उन्होंने उस बछड़े की पूजा की थी जो हारून ने बनाया था। ");
INSERT INTO urdgvh_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","रब ने मूसा से कहा, “इस जगह से रवाना हो जा। उन लोगों को लेकर जिनको तू मिसर से निकाल लाया है उस मुल्क को जा जिसका वादा मैंने इब्राहीम, इसहाक़ और याक़ूब से किया है। उन्हीं से मैंने क़सम खाकर कहा था, ‘मैं यह मुल्क तुम्हारी औलाद को दूँगा।’ ");
INSERT INTO urdgvh_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","मैं तेरे आगे आगे फ़रिश्ता भेजकर कनानी, अमोरी, हित्ती, फ़रिज़्ज़ी, हिव्वी और यबूसी अक़वाम को उस मुल्क से निकाल दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","उठ, उस मुल्क को जा जहाँ दूध और शहद की कसरत है। लेकिन मैं साथ नहीं जाऊँगा। तुम इतने हटधर्म हो कि अगर मैं साथ जाऊँ तो ख़तरा है कि तुम्हें वहाँ पहुँचने से पहले ही बरबाद कर दूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","जब इसराईलियों ने यह सख़्त अलफ़ाज़ सुने तो वह मातम करने लगे। किसी ने भी अपने ज़ेवर न पहने, ");
INSERT INTO urdgvh_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","क्योंकि रब ने मूसा से कहा था, “इसराईलियों को बता कि तुम हटधर्म हो। अगर मैं एक लमहा भी तुम्हारे साथ चलूँ तो ख़तरा है कि मैं तुम्हें तबाह कर दूँ। अब अपने ज़ेवरात उतार डालो। फिर मैं फ़ैसला करूँगा कि तुम्हारे साथ क्या किया जाए।” ");
INSERT INTO urdgvh_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","इन अलफ़ाज़ पर इसराईलियों ने होरिब यानी सीना पहाड़ पर अपने ज़ेवर उतार दिए। ");
INSERT INTO urdgvh_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","उस वक़्त मूसा ने ख़ैमा लेकर उसे कुछ फ़ासले पर ख़ैमागाह के बाहर लगा दिया। उसने उसका नाम ‘मुलाक़ात का ख़ैमा’ रखा। जो भी रब की मरज़ी दरियाफ़्त करना चाहता वह ख़ैमागाह से निकलकर वहाँ जाता। ");
INSERT INTO urdgvh_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","जब भी मूसा ख़ैमागाह से निकलकर वहाँ जाता तो तमाम लोग अपने ख़ैमों के दरवाज़ों पर खड़े होकर मूसा के पीछे देखने लगते। उसके मुलाक़ात के ख़ैमे में ओझल होने तक वह उसे देखते रहते। ");
INSERT INTO urdgvh_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","मूसा के ख़ैमे में दाख़िल होने पर बादल का सतून उतरकर ख़ैमे के दरवाज़े पर ठहर जाता। जितनी देर तक रब मूसा से बातें करता उतनी देर तक वह वहाँ ठहरा रहता। ");
INSERT INTO urdgvh_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","जब इसराईली मुलाक़ात के ख़ैमे के दरवाज़े पर बादल का सतून देखते तो वह अपने अपने ख़ैमे के दरवाज़े पर खड़े होकर सिजदा करते। ");
INSERT INTO urdgvh_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","रब मूसा से रूबरू बातें करता था, ऐसे शख़्स की तरह जो अपने दोस्त से बातें करता है। इसके बाद मूसा निकलकर ख़ैमागाह को वापस चला जाता। लेकिन उसका जवान मददगार यशुअ बिन नून ख़ैमे को नहीं छोड़ता था। ");
INSERT INTO urdgvh_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","मूसा ने रब से कहा, “देख, तू मुझसे कहता आया है कि इस क़ौम को कनान ले चल। लेकिन तू मेरे साथ किस को भेजेगा? तूने अब तक यह बात मुझे नहीं बताई हालाँकि तूने कहा है, ‘मैं तुझे बनाम जानता हूँ, तुझे मेरा करम हासिल हुआ है।’ ");
INSERT INTO urdgvh_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","अगर मुझे वाक़ई तेरा करम हासिल है तो मुझे अपने रास्ते दिखा ताकि मैं तुझे जान लूँ और तेरा करम मुझे हासिल होता रहे। इस बात का ख़याल रख कि यह क़ौम तेरी ही उम्मत है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","रब ने जवाब दिया, “मैं ख़ुद तेरे साथ चलूँगा और तुझे आराम दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","मूसा ने कहा, “अगर तू ख़ुद साथ नहीं चलेगा तो फिर हमें यहाँ से रवाना न करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","अगर तू हमारे साथ न जाए तो किस तरह पता चलेगा कि मुझे और तेरी क़ौम को तेरा करम हासिल हुआ है? हम सिर्फ़ इसी वजह से दुनिया की दीगर क़ौमों से अलग और मुमताज़ हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","रब ने मूसा से कहा, “मैं तेरी यह दरख़ास्त भी पूरी करूँगा, क्योंकि तुझे मेरा करम हासिल हुआ है और मैं तुझे बनाम जानता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","फिर मूसा बोला, “बराहे-करम मुझे अपना जलाल दिखा।” ");
INSERT INTO urdgvh_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","रब ने जवाब दिया, “मैं अपनी पूरी भलाई तेरे सामने से गुज़रने दूँगा और तेरे सामने ही अपने नाम रब का एलान करूँगा। मैं जिस पर मेहरबान होना चाहूँ उस पर मेहरबान होता हूँ, और जिस पर रहम करना चाहूँ उस पर रहम करता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","लेकिन तू मेरा चेहरा नहीं देख सकता, क्योंकि जो भी मेरा चेहरा देखे वह ज़िंदा नहीं रह सकता।” ");
INSERT INTO urdgvh_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","फिर रब ने फ़रमाया, “देख, मेरे पास एक जगह है। वहाँ की चट्टान पर खड़ा हो जा। ");
INSERT INTO urdgvh_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","जब मेरा जलाल वहाँ से गुज़रेगा तो मैं तुझे चट्टान के एक शिगाफ़ में रखूँगा और अपना हाथ तेरे ऊपर फैलाऊँगा ताकि तू मेरे गुज़रने के दौरान महफ़ूज़ रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","इसके बाद मैं अपना हाथ हटाऊँगा और तू मेरे पीछे देख सकेगा। लेकिन मेरा चेहरा देखा नहीं जा सकता।” ");
INSERT INTO urdgvh_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","रब ने मूसा से कहा, “अपने लिए पत्थर की दो तख़्तियाँ तराश ले जो पहली दो की मानिंद हों। फिर मैं उन पर वह अलफ़ाज़ लिखूँगा जो पहली तख़्तियों पर लिखे थे जिन्हें तूने पटख़ दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","सुबह तक तैयार होकर सीना पहाड़ पर चढ़ना। चोटी पर मेरे सामने खड़ा हो जा। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","तेरे साथ कोई भी न आए बल्कि पूरे पहाड़ पर कोई और शख़्स नज़र न आए, यहाँ तक कि भेड़-बकरियाँ और गाय-बैल भी पहाड़ के दामन में न चरें।” ");
INSERT INTO urdgvh_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","चुनाँचे मूसा ने दो तख़्तियाँ तराश लीं जो पहली की मानिंद थीं। फिर वह सुबह-सवेरे उठकर सीना पहाड़ पर चढ़ गया जिस तरह रब ने उसे हुक्म दिया था। उसके हाथों में पत्थर की दोनों तख़्तियाँ थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","जब वह चोटी पर पहुँचा तो रब बादल में उतर आया और उसके पास खड़े होकर अपने नाम रब का एलान किया। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","मूसा के सामने से गुज़रते हुए उसने पुकारा, “रब, रब, रहीम और मेहरबान ख़ुदा। तहम्मुल, शफ़क़त और वफ़ा से भरपूर। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","वह हज़ारों पर अपनी शफ़क़त क़ायम रखता और लोगों का क़ुसूर, नाफ़रमानी और गुनाह मुआफ़ करता है। लेकिन वह हर एक को उस की मुनासिब सज़ा भी देता है। जब वालिदैन गुनाह करें तो उनकी औलाद को भी तीसरी और चौथी पुश्त तक सज़ा के नतायज भुगतने पड़ेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","मूसा ने जल्दी से झुककर सिजदा किया। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","उसने कहा, “ऐ रब, अगर मुझ पर तेरा करम हो तो हमारे साथ चल। बेशक यह क़ौम हटधर्म है, तो भी हमारा क़ुसूर और गुनाह मुआफ़ कर और बख़्श दे कि हम दुबारा तेरे ही बन जाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","तब रब ने कहा, “मैं तुम्हारे साथ अहद बाँधूँगा। तेरी क़ौम के सामने ही मैं ऐसे मोजिज़े करूँगा जो अब तक दुनिया-भर की किसी भी क़ौम में नहीं किए गए। पूरी क़ौम जिसके दरमियान तू रहता है रब का काम देखेगी और उससे डर जाएगी जो मैं तेरे साथ करूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","जो अहकाम मैं आज देता हूँ उन पर अमल करता रह। मैं अमोरी, कनानी, हित्ती, फ़रिज़्ज़ी, हिव्वी और यबूसी अक़वाम को तेरे आगे आगे मुल्क से निकाल दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ख़बरदार, जो उस मुल्क में रहते हैं जहाँ तू जा रहा है उनसे अहद न बाँधना। वरना वह तेरे दरमियान रहते हुए तुझे गुनाहों में फँसाते रहेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","उनकी क़ुरबानगाहें ढा देना, उनके बुतों के सतून टुकड़े टुकड़े कर देना और उनकी देवी यसीरत के खंबे काट डालना। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","किसी और माबूद की परस्तिश न करना, क्योंकि रब का नाम ग़यूर है, अल्लाह ग़ैरतमंद है। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","ख़बरदार, उस मुल्क के बाशिंदों से अहद न करना, क्योंकि तेरे दरमियान रहते हुए भी वह अपने माबूदों की पैरवी करके ज़िना करेंगे और उन्हें क़ुरबानियाँ चढ़ाएँगे। आख़िरकार वह तुझे भी अपनी क़ुरबानियों में शिरकत की दावत देंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ख़तरा है कि तू उनकी बेटियों का अपने बेटों के साथ रिश्ता बाँधे। फिर जब यह अपने माबूदों की पैरवी करके ज़िना करेंगी तो उनके सबब से तेरे बेटे भी उनकी पैरवी करने लगेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","अपने लिए देवता न ढालना। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","बेख़मीरी रोटी की ईद मनाना। अबीब के महीने में सात दिन तक तेरी रोटी में ख़मीर न हो जिस तरह मैंने हुक्म दिया है। क्योंकि इस महीने में तू मिसर से निकला। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","हर पहलौठा मेरा है। तेरे माल मवेशियों का हर पहलौठा मेरा है, चाहे बछड़ा हो या लेला। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","लेकिन पहलौठे गधे के एवज़ भेड़ देना। अगर यह मुमकिन न हो तो उस की गरदन तोड़ डालना। अपने पहलौठे बेटों के लिए भी एवज़ी देना। कोई मेरे पास ख़ाली हाथ न आए। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","छः दिन काम-काज करना, लेकिन सातवें दिन आराम करना। ख़ाह हल चलाना हो या फ़सल काटनी हो तो भी सातवें दिन आराम करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","गंदुम की फ़सल की कटाई की ईद उस वक़्त मनाना जब तू गेहूँ की पहली फ़सल काटेगा। अंगूर और फल जमा करने की ईद इसराईली साल के इख़्तिताम पर मनानी है। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","लाज़िम है कि तेरे तमाम मर्द साल में तीन मरतबा रब क़ादिरे-मुतलक़ के सामने जो इसराईल का ख़ुदा है हाज़िर हों। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","मैं तेरे आगे आगे क़ौमों को मुल्क से निकाल दूँगा और तेरी सरहद्दें बढ़ाता जाऊँगा। फिर जब तू साल में तीन मरतबा रब अपने ख़ुदा के हुज़ूर आएगा तो कोई भी तेरे मुल्क का लालच नहीं करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","जब तू किसी जानवर को ज़बह करके क़ुरबानी के तौर पर पेश करता है तो उसके ख़ून के साथ ऐसी रोटी पेश न करना जिसमें ख़मीर हो। ईदे-फ़सह की क़ुरबानी से अगली सुबह तक कुछ बाक़ी न रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","अपनी ज़मीन की पहली पैदावार में से बेहतरीन हिस्सा रब अपने ख़ुदा के घर में ले आना। बकरी या भेड़ के बच्चे को उस की माँ के दूध में न पकाना।” ");
INSERT INTO urdgvh_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","रब ने मूसा से कहा, “यह तमाम बातें लिख ले, क्योंकि यह उस अहद की बुनियाद हैं जो मैंने तेरे और इसराईल के साथ बाँधा है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","मूसा चालीस दिन और चालीस रात वहीं रब के हुज़ूर रहा। इस दौरान न उसने कुछ खाया न पिया। उसने पत्थर की तख़्तियों पर अहद के दस अहकाम लिखे। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","इसके बाद मूसा शरीअत की दोनों तख़्तियों को हाथ में लिए हुए सीना पहाड़ से उतरा। उसके चेहरे की जिल्द चमक रही थी, क्योंकि उसने रब से बात की थी। लेकिन उसे ख़ुद इसका इल्म नहीं था। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","जब हारून और तमाम इसराईलियों ने देखा कि मूसा का चेहरा चमक रहा है तो वह उसके पास आने से डर गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","लेकिन उसने उन्हें बुलाया तो हारून और जमात के तमाम सरदार उसके पास आए, और उसने उनसे बात की। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","बाद में बाक़ी इसराईली भी आए, और मूसा ने उन्हें तमाम अहकाम सुनाए जो रब ने उसे कोहे-सीना पर दिए थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","यह सब कुछ कहने के बाद मूसा ने अपने चेहरे पर निक़ाब डाल लिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","जब भी वह रब से बात करने के लिए मुलाक़ात के ख़ैमे में जाता तो निक़ाब को ख़ैमे से निकलते वक़्त तक उतार लेता। और जब वह निकलकर इसराईलियों को रब से मिले हुए अहकाम सुनाता ");
INSERT INTO urdgvh_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","तो वह देखते कि उसके चेहरे की जिल्द चमक रही है। इसके बाद मूसा दुबारा निक़ाब को अपने चेहरे पर डाल लेता, और वह उस वक़्त तक चेहरे पर रहता जब तक मूसा रब से बात करने के लिए मुलाक़ात के ख़ैमे में न जाता था। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मूसा ने इसराईल की पूरी जमात को इकट्ठा करके कहा, “रब ने तुमको यह हुक्म दिए हैं : ");
INSERT INTO urdgvh_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","छः दिन काम-काज किया जाए, लेकिन सातवाँ दिन मख़सूसो-मुक़द्दस हो। वह रब के लिए आराम का सबत है। जो भी इस दिन काम करे उसे सज़ाए-मौत दी जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","हफ़ते के दिन अपने तमाम घरों में आग तक न जलाना।” ");
INSERT INTO urdgvh_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","मूसा ने इसराईल की पूरी जमात से कहा, “रब ने हिदायत दी है ");
INSERT INTO urdgvh_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","कि जो कुछ तुम्हारे पास है उसमें से हदिये लाकर रब को उठानेवाली क़ुरबानी के तौर पर पेश करो। जो भी दिली ख़ुशी से देना चाहे वह इन चीज़ों में से कुछ दे : सोना, चाँदी, पीतल; ");
INSERT INTO urdgvh_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","नीले, अरग़वानी और क़िरमिज़ी रंग का धागा, बारीक कतान, बकरी के बाल, ");
INSERT INTO urdgvh_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","मेंढों की सुर्ख़ रँगी हुई खालें, तख़स की खालें, कीकर की लकड़ी, ");
INSERT INTO urdgvh_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","शमादान के लिए ज़ैतून का तेल, मसह करने के लिए तेल और ख़ुशबूदार बख़ूर के लिए मसाले, ");
INSERT INTO urdgvh_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","अक़ीक़े-अहमर और दीगर जवाहर जो इमामे-आज़म के बालापोश और सीने के कीसे में जड़े जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","तुममें से जितने माहिर कारीगर हैं वह आकर वह कुछ बनाएँ जो रब ने फ़रमाया ");
INSERT INTO urdgvh_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","यानी ख़ैमा और वह ग़िलाफ़ जो उसके ऊपर लगाए जाएंगे, हुकें, दीवारों के तख़्ते, शहतीर, सतून और पाए, ");
INSERT INTO urdgvh_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","अहद का संदूक़, उसे उठाने की लकड़ियाँ, उसके कफ़्फ़ारे का ढकना, मुक़द्दसतरीन कमरे के दरवाज़े का परदा, ");
INSERT INTO urdgvh_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","मख़सूस रोटियों की मेज़, उसे उठाने की लकड़ियाँ, उसका सारा सामान और रोटियाँ, ");
INSERT INTO urdgvh_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","शमादान और उस पर रखने के चराग़ उसके सामान समेत, शमादान के लिए तेल, ");
INSERT INTO urdgvh_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","बख़ूर जलाने की क़ुरबानगाह, उसे उठाने की लकड़ियाँ, मसह का तेल, ख़ुशबूदार बख़ूर, मुक़द्दस ख़ैमे के दरवाज़े का परदा, ");
INSERT INTO urdgvh_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","जानवरों को चढ़ाने की क़ुरबानगाह, उसका पीतल का जंगला, उसे उठाने की लकड़ियाँ और बाक़ी सारा सामान, धोने का हौज़ और वह ढाँचा जिस पर हौज़ रखा जाता है, ");
INSERT INTO urdgvh_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","चारदीवारी के परदे उनके खंबों और पाइयों समेत, सहन के दरवाज़े का परदा, ");
INSERT INTO urdgvh_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ख़ैमे और चारदीवारी की मेख़ें और रस्से, ");
INSERT INTO urdgvh_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","और वह मुक़द्दस लिबास जो हारून और उसके बेटे मक़दिस में ख़िदमत करने के लिए पहनते हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","यह सुनकर इसराईल की पूरी जमात मूसा के पास से चली गई। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","और जो जो दिली ख़ुशी से देना चाहता था वह मुलाक़ात के ख़ैमे, उसके सामान या इमामों के कपड़ों के लिए कोई हदिया लेकर वापस आया। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","रब के हदिये के लिए मर्द और ख़वातीन दिली ख़ुशी से अपने सोने के ज़ेवरात मसलन जड़ाऊ पिनें, बालियाँ और छल्ले ले आए। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","जिस जिसके पास दरकार चीज़ों में से कुछ था वह उसे मूसा के पास ले आया यानी नीले, क़िरमिज़ी और अरग़वानी रंग का धागा, बारीक कतान, बकरी के बाल, मेंढों की सुर्ख़ रँगी हुई खालें और तख़स की खालें। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","चाँदी, पीतल और कीकर की लकड़ी भी हदिये के तौर पर लाई गई। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","और जितनी औरतें कातने में माहिर थीं वह अपनी काती हुई चीज़ें ले आईं यानी नीले, क़िरमिज़ी और अरग़वानी रंग का धागा और बारीक कतान। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","इसी तरह जो जो औरत बकरी के बाल कातने में माहिर थी और दिली ख़ुशी से मक़दिस के लिए काम करना चाहती थी वह यह कातकर ले आई। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","सरदार अक़ीक़े-अहमर और दीगर जवाहर ले आए जो इमामे-आज़म के बालापोश और सीने के कीसे के लिए दरकार थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","वह शमादान, मसह के तेल और ख़ुशबूदार बख़ूर के लिए मसाले और ज़ैतून का तेल भी ले आए। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","यों इसराईल के तमाम मर्द और ख़वातीन जो दिली ख़ुशी से रब को कुछ देना चाहते थे उस सारे काम के लिए हदिये ले आए जो रब ने मूसा की मारिफ़त करने को कहा था। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","फिर मूसा ने इसराईलियों से कहा, “रब ने यहूदाह के क़बीले के बज़लियेल बिन ऊरी बिन हूर को चुन लिया है। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","उसने उसे इलाही रूह से मामूर करके हिकमत, समझ और तामीर के हर काम के लिए दरकार इल्म दे दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","वह नक़्शे बनाकर उनके मुताबिक़ सोने, चाँदी और पीतल की चीज़ें बना सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","वह जवाहर को काटकर जड़ने की क़ाबिलियत रखता है। वह लकड़ी को तराशकर उससे मुख़्तलिफ़ चीज़ें बना सकता है। वह बहुत सारे और कामों में भी महारत रखता है। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","साथ ही रब ने उसे और दान के क़बीले के उहलियाब बिन अख़ी-समक को दूसरों को सिखाने की क़ाबिलियत भी दी है। ");
INSERT INTO urdgvh_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","उसने उन्हें वह महारत और हिकमत दी है जो हर काम के लिए दरकार है यानी कारीगरी के हर काम के लिए, कढ़ाई के काम के लिए, नीले, अरग़वानी और क़िरमिज़ी रंग के धागे और बारीक कतान से कपड़ा बनाने के लिए और बुनाई के काम के लिए। वह माहिर कारीगर हैं और नक़्शे भी बना सकते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","लाज़िम है कि बज़लियेल, उहलियाब और बाक़ी कारीगर जिनको रब ने मक़दिस की तामीर के लिए हिकमत और समझ दी है सब कुछ ऐन उन हिदायात के मुताबिक़ बनाएँ जो रब ने दी हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","मूसा ने बज़लियेल और उहलियाब को बुलाया। साथ ही उसने हर उस कारीगर को भी बुलाया जिसे रब ने मक़दिस की तामीर के लिए हिकमत और महारत दी थी और जो ख़ुशी से आना और यह काम करना चाहता था। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","उन्हें मूसा से तमाम हदिये मिले जो इसराईली मक़दिस की तामीर के लिए लाए थे। इसके बाद भी लोग रोज़ बरोज़ सुबह के वक़्त हदिये लाते रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","आख़िरकार तमाम कारीगर जो मक़दिस बनाने के काम में लगे थे अपना काम छोड़कर मूसा के पास आए। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","उन्होंने कहा, “लोग हद से ज़्यादा ला रहे हैं। जिस काम का हुक्म रब ने दिया है उसके लिए इतने सामान की ज़रूरत नहीं है।” ");
INSERT INTO urdgvh_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","तब मूसा ने पूरी ख़ैमागाह में एलान करवा दिया कि कोई मर्द या औरत मक़दिस की तामीर के लिए अब कुछ न लाए। यों उन्हें मज़ीद चीज़ें लाने से रोका गया, ");
INSERT INTO urdgvh_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","क्योंकि काम के लिए सामान ज़रूरत से ज़्यादा हो गया था। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","जो कारीगर महारत रखते थे उन्होंने ख़ैमे को बनाया। उन्होंने बारीक कतान और नीले, अरग़वानी और क़िरमिज़ी धागे से दस परदे बनाए। परदों पर किसी माहिर कारीगर के कढ़ाई के काम से करूबी फ़रिश्तों का डिज़ायन बनाया गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","हर परदे की लंबाई 42 फ़ुट और चौड़ाई 6 फ़ुट थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","पाँच परदों के लंबे हाशिये एक दूसरे के साथ जोड़े गए और इसी तरह बाक़ी पाँच भी। यों दो बड़े टुकड़े बन गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","दोनों टुकड़ों को एक दूसरे के साथ मिलाने के लिए उन्होंने नीले धागे के हलक़े बनाए। यह हलक़े हर टुकड़े के 42 फ़ुटवाले एक किनारे पर लगाए गए, ");
INSERT INTO urdgvh_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","एक टुकड़े के हाशिये पर 50 हलक़े और दूसरे पर भी उतने ही हलक़े। इन दो हाशियों के हलक़े एक दूसरे के आमने-सामने थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","फिर बज़लियेल ने सोने की 50 हुकें बनाकर उनसे आमने-सामने के हलक़ों को एक दूसरे के साथ मिलाया। यों दोनों टुकड़ों के जोड़ने से ख़ैमा बन गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","उसने बकरी के बालों से भी 11 परदे बनाए जिन्हें कपड़ेवाले ख़ैमे के ऊपर रखना था। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","हर परदे की लंबाई 45 फ़ुट और चौड़ाई 6 फ़ुट थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","पाँच परदों के लंबे हाशिये एक दूसरे के साथ जोड़े गए और इस तरह बाक़ी छः भी। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","इन दोनों टुकड़ों को मिलाने के लिए उसने हर टुकड़े के 45 फ़ुटवाले एक किनारे पर पचास पचास हलक़े लगाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","फिर पीतल की 50 हुकें बनाकर उसने दोनों हिस्से मिलाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","एक दूसरे के ऊपर के दोनों ख़ैमों की हिफ़ाज़त के लिए बज़लियेल ने दो और ग़िलाफ़ बनाए। बकरी के बालों के ख़ैमे पर रखने के लिए उसने मेंढों की सुर्ख़ रँगी हुई खालें जोड़ दीं और उसके ऊपर रखने के लिए तख़स की खालें मिलाईं। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","इसके बाद उसने कीकर की लकड़ी के तख़्ते बनाए जो ख़ैमे की दीवारों का काम देते थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","हर तख़्ते की ऊँचाई 15 फ़ुट थी और चौड़ाई सवा दो फ़ुट। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","हर तख़्ते के नीचे दो दो चूलें थीं। इन चूलों से हर तख़्ते को उसके पाइयों के साथ जोड़ा जाता था ताकि तख़्ता खड़ा रहे। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ख़ैमे की जुनूबी दीवार के लिए 20 तख़्ते बनाए गए ");
INSERT INTO urdgvh_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","और साथ ही चाँदी के 40 पाए भी जिन पर तख़्ते खड़े किए जाते थे। हर तख़्ते के नीचे दो पाए थे, और हर पाए में एक चूल लगती थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","इसी तरह ख़ैमे की शिमाली दीवार के लिए भी 20 तख़्ते बनाए गए ");
INSERT INTO urdgvh_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","और साथ ही चाँदी के 40 पाए जो तख़्तों को खड़ा करने के लिए थे। हर तख़्ते के नीचे दो पाए थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ख़ैमे की पिछली यानी मग़रिबी दीवार के लिए छः तख़्ते बनाए गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","इस दीवार को शिमाली और जुनूबी दीवारों के साथ जोड़ने के लिए कोनेवाले दो तख़्ते बनाए गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","इन दो तख़्तों में नीचे से लेकर ऊपर तक कोना था ताकि एक से शिमाली दीवार मग़रिबी दीवार के साथ जुड़ जाए और दूसरे से जुनूबी दीवार मग़रिबी दीवार के साथ। इनके ऊपर के सिरे कड़ों से मज़बूत किए गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","यों पिछले यानी मग़रिबी तख़्तों की पूरी तादाद 8 थी और इनके लिए चाँदी के पाइयों की तादाद 16, हर तख़्ते के नीचे दो पाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","फिर बज़लियेल ने कीकर की लकड़ी के शहतीर बनाए, तीनों दीवारों के लिए पाँच पाँच शहतीर। वह हर दीवार के तख़्तों पर यों लगाने के लिए थे कि उनसे तख़्ते एक दूसरे के साथ मिलाए जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","दरमियानी शहतीर यों बनाया गया कि वह दीवार की आधी ऊँचाई पर दीवार के एक सिरे से दूसरे सिरे तक लग सकता था। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","उसने तमाम तख़्तों और शहतीरों पर सोना चढ़ाया। शहतीरों को तख़्तों के साथ लगाने के लिए उसने सोने के कड़े बनाए जो तख़्तों में लगाने थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","अब बज़लियेल ने एक और परदा बनाया। उसके लिए भी बारीक कतान और नीले, अरग़वानी और क़िरमिज़ी रंग का धागा इस्तेमाल हुआ। उस पर भी किसी माहिर कारीगर के कढ़ाई के काम से करूबी फ़रिश्तों का डिज़ायन बनाया गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","फिर उसने परदे को लटकाने के लिए कीकर की लकड़ी के चार सतून, सोने की हुकें और चाँदी के चार पाए बनाए। सतूनों पर सोना चढ़ाया गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","बज़लियेल ने ख़ैमे के दरवाज़े के लिए भी परदा बनाया। वह भी बारीक कतान और नीले, अरग़वानी और क़िरमिज़ी रंग के धागे से बनाया गया, और उस पर कढ़ाई का काम किया गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","इस परदे को लटकाने के लिए उसने सोने की हुकें और कीकर की लकड़ी के पाँच सतून बनाए। सतूनों के ऊपर के सिरों और पट्टियों पर सोना चढ़ाया गया जबकि उनके पाए पीतल के थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","बज़लियेल ने कीकर की लकड़ी का संदूक़ बनाया। उस की लंबाई पौने चार फ़ुट थी जबकि उस की चौड़ाई और ऊँचाई सवा दो दो फ़ुट थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","उसने पूरे संदूक़ पर अंदर और बाहर से ख़ालिस सोना चढ़ाया। ऊपर की सतह के इर्दगिर्द उसने सोने की झालर लगाई। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","संदूक़ को उठाने के लिए उसने सोने के चार कड़े ढालकर उन्हें संदूक़ के चारपाइयों पर लगाया। दोनों तरफ़ दो दो कड़े थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","फिर उसने कीकर की दो लकड़ियाँ संदूक़ को उठाने के लिए तैयार कीं और उन पर सोना चढ़ाया। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","उसने इन लकड़ियों को दोनों तरफ़ के कड़ों में डाल दिया ताकि उनसे संदूक़ को उठाया जा सके। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","बज़लियेल ने संदूक़ का ढकना ख़ालिस सोने का बनाया। उस की लंबाई पौने चार फ़ुट और चौड़ाई सवा दो फ़ुट थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","8","फिर उसने दो करूबी फ़रिश्ते सोने से घड़कर बनाए जो ढकने के दोनों सिरों पर खड़े थे। यह दो फ़रिश्ते और ढकना एक ही टुकड़े से बनाए गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","फ़रिश्तों के पर यों ऊपर की तरफ़ फैले हुए थे कि वह ढकने को पनाह देते थे। उनके मुँह एक दूसरे की तरफ़ किए हुए थे, और वह ढकने की तरफ़ देखते थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","इसके बाद बज़लियेल ने कीकर की लकड़ी की मेज़ बनाई। उस की लंबाई तीन फ़ुट, चौड़ाई डेढ़ फ़ुट और ऊँचाई सवा दो फ़ुट थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","उसने उस पर ख़ालिस सोना चढ़ाकर उसके इर्दगिर्द सोने की झालर लगाई। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","मेज़ की ऊपर की सतह पर उसने चौखटा भी लगाया जिसकी ऊँचाई तीन इंच थी और जिस पर सोने की झालर लगी थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","अब उसने सोने के चार कड़े ढालकर उन्हें चारों कोनों पर लगाया जहाँ मेज़ के पाए लगे थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","यह कड़े मेज़ की सतह पर लगे चौखटे के नीचे लगाए गए। उनमें वह लकड़ियाँ डालनी थीं जिनसे मेज़ को उठाना था। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","बज़लियेल ने यह लकड़ियाँ भी कीकर से बनाईं और उन पर सोना चढ़ाया। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","आख़िरकार उसने ख़ालिस सोने के वह थाल, प्याले, मै की नज़रें पेश करने के बरतन और मरतबान बनाए जो उस पर रखे जाते थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","फिर बज़लियेल ने ख़ालिस सोने का शमादान बनाया। उसका पाया और डंडी घड़कर बनाए गए। उस की प्यालियाँ जो फूलों और कलियों की शक्ल की थीं पाए और डंडी के साथ एक ही टुकड़ा थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","डंडी से दाईं और बाईं तरफ़ तीन तीन शाख़ें निकलती थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","हर शाख़ पर तीन प्यालियाँ लगी थीं जो बादाम की कलियों और फूलों की शक्ल की थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","शमादान की डंडी पर भी इस क़िस्म की प्यालियाँ लगी थीं, लेकिन तादाद में चार। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","इनमें से तीन प्यालियाँ दाएँ बाएँ की छः शाख़ों के नीचे लगी थीं। वह यों लगी थीं कि हर प्याली से दो शाख़ें निकलती थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","शाख़ें और प्यालियाँ बल्कि पूरा शमादान ख़ालिस सोने के एक ही टुकड़े से घड़कर बनाया गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","बज़लियेल ने शमादान के लिए ख़ालिस सोने के सात चराग़ बनाए। उसने बत्ती कतरने की क़ैंचियाँ और जलते कोयले के लिए छोटे बरतन भी ख़ालिस सोने से बनाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","शमादान और उसके तमाम सामान के लिए पूरे 34 किलोग्राम ख़ालिस सोना इस्तेमाल हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","बज़लियेल ने कीकर की लकड़ी की क़ुरबानगाह बनाई जो बख़ूर जलाने के लिए थी। वह डेढ़ फ़ुट लंबी, इतनी ही चौड़ी और तीन फ़ुट ऊँची थी। उसके चार कोनों में से सींग निकलते थे जो क़ुरबानगाह के साथ एक ही टुकड़े से बनाए गए थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","उस की ऊपर की सतह, उसके चार पहलुओं और उसके सींगों पर ख़ालिस सोना चढ़ाया गया। ऊपर की सतह के इर्दगिर्द बज़लियेल ने सोने की झालर बनाई। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","सोने के दो कड़े बनाकर उसने उन्हें इस झालर के नीचे एक दूसरे के मुक़ाबिल पहलुओं पर लगाया। इन कड़ों में क़ुरबानगाह को उठाने की लकड़ियाँ डाली गईं। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","यह लकड़ियाँ कीकर की थीं, और उन पर भी सोना चढ़ाया गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","बज़लियेल ने मसह करने का मुक़द्दस तेल और ख़ुशबूदार ख़ालिस बख़ूर भी बनाया। यह इत्रसाज़ का काम था। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","बज़लियेल ने कीकर की लकड़ी की एक और क़ुरबानगाह बनाई जो भस्म होनेवाली क़ुरबानियों के लिए थी। उस की ऊँचाई साढ़े चार फ़ुट, उस की लंबाई और चौड़ाई साढ़े सात सात फ़ुट थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","उसके ऊपर चारों कोनों में से सींग निकलते थे। सींग और क़ुरबानगाह एक ही टुकड़े के थे, और उस पर पीतल चढ़ाया गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","उसका तमाम साज़ो-सामान और बरतन भी पीतल के थे यानी राख को उठाकर ले जाने की बालटियाँ, बेलचे, काँटे, जलते हुए कोयले के लिए बरतन और छिड़काव के कटोरे। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","क़ुरबानगाह को उठाने के लिए उसने पीतल का जंगला बनाया। वह ऊपर से खुला था और यों बनाया गया कि जब क़ुरबानगाह उसमें रखी जाए तो वह उस किनारे तक पहुँचे जो क़ुरबानगाह की आधी ऊँचाई पर लगी थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","उसने क़ुरबानगाह को उठाने के लिए चार कड़े बनाकर उन्हें जंगले के चार कोनों पर लगाया। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","फिर उसने कीकर की दो लकड़ियाँ बनाकर उन पर पीतल चढ़ाया ");
INSERT INTO urdgvh_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","और क़ुरबानगाह के दोनों तरफ़ लगे इन कड़ों में डाल दीं। यों उसे उठाया जा सकता था। क़ुरबानगाह लकड़ी की थी लेकिन खोखली थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","बज़लियेल ने धोने का हौज़ और उसका ढाँचा भी पीतल से बनाया। उसका पीतल उन औरतों के आईनों से मिला था जो मुलाक़ात के ख़ैमे के दरवाज़े पर ख़िदमत करती थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","फिर बज़लियेल ने सहन बनाया। उस की चारदीवारी बारीक कतान के कपड़े से बनाई गई। चारदीवारी की लंबाई जुनूब की तरफ़ 150 फ़ुट थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","कपड़े को लगाने के लिए चाँदी की हुकें, पट्टियाँ, लकड़ी के खंबे और उनके पाए बनाए गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","चारदीवारी शिमाल की तरफ़ भी इसी तरह बनाई गई। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ख़ैमे के पीछे मग़रिब की तरफ़ चारदीवारी की चौड़ाई 75 फ़ुट थी। कपड़े के अलावा उसके लिए 10 खंबे, 10 पाए और कपड़ा लगाने के लिए चाँदी की हुकें और पट्टियाँ बनाई गईं। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","सामने, मशरिक़ की तरफ़ जहाँ से सूरज तुलू होता है चारदीवारी की चौड़ाई भी 75 फ़ुट थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","कपड़ा दरवाज़े के दाईं तरफ़ साढ़े 22 फ़ुट चौड़ा था और उसके बाईं तरफ़ भी उतना ही चौड़ा। उसे दोनों तरफ़ तीन तीन खंबों के साथ लगाया गया जो पीतल के पाइयों पर खड़े थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","चारदीवारी के तमाम परदों के लिए बारीक कतान इस्तेमाल हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","खंबे पीतल के पाइयों पर खड़े थे, और परदे चाँदी की हुकों और पट्टियों से खंबों के साथ लगे थे। खंबों के ऊपर के सिरों पर चाँदी चढ़ाई गई थी। सहन के तमाम खंबों पर चाँदी की पट्टियाँ लगी थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","चारदीवारी के दरवाज़े का परदा नीले, अरग़वानी और क़िरमिज़ी रंग के धागे और बारीक कतान से बनाया गया, और उस पर कढ़ाई का काम किया गया। वह 30 फ़ुट चौड़ा और चारदीवारी के दूसरे परदों की तरह साढ़े सात फ़ुट ऊँचा था। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","उसके चार खंबे और पीतल के चार पाए थे। उस की हुकें और पट्टियाँ चाँदी की थीं, और खंबों के ऊपर के सिरों पर चाँदी चढ़ाई गई थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","ख़ैमे और चारदीवारी की तमाम मेख़ें पीतल की थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ज़ैल में उस सामान की फ़हरिस्त है जो मक़दिस की तामीर के लिए इस्तेमाल हुआ। मूसा के हुक्म पर इमामे-आज़म हारून के बेटे इतमर ने लावियों की मारिफ़त यह फ़हरिस्त तैयार की। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","(यहूदाह के क़बीले के बज़लियेल बिन ऊरी बिन हूर ने वह सब कुछ बनाया जो रब ने मूसा को बताया था। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","उसके साथ दान के क़बीले का उहलियाब बिन अख़ी-समक था जो कारीगरी के हर काम और कढ़ाई के काम में माहिर था। वह नीले, अरग़वानी और क़िरमिज़ी रंग के धागे और बारीक कतान से कपड़ा बनाने में भी माहिर था।) ");
INSERT INTO urdgvh_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","उस सोने का वज़न जो लोगों के हदियों से जमा हुआ और मक़दिस की तामीर के लिए इस्तेमाल हुआ तक़रीबन 1,000 किलोग्राम था (उसे मक़दिस के बाटों के हिसाब से तोला गया)। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","तामीर के लिए चाँदी जो मर्दुमशुमारी के हिसाब से वसूल हुई, उसका वज़न तक़रीबन 3,430 किलोग्राम था (उसे भी मक़दिस के बाटों के हिसाब से तोला गया)। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","जिन मर्दों की उम्र 20 साल या इससे ज़ायद थी उन्हें चाँदी का आधा आधा सिक्का देना पड़ा। मर्दों की कुल तादाद 6,03,550 थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","चूँकि दीवारों के तख़्तों के पाए और मुक़द्दसतरीन कमरे के दरवाज़े के सतूनों के पाए चाँदी के थे इसलिए तक़रीबन पूरी चाँदी इन 100 पाइयों के लिए सर्फ़ हुई। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","तक़रीबन 30 किलोग्राम चाँदी बच गई। इससे चारदीवारी के खंबों की हुकें और पट्टियाँ बनाई गईं, और यह खंबों के ऊपर के सिरों पर भी चढ़ाई गई। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","जो पीतल हदियों से जमा हुआ उसका वज़न तक़रीबन 2,425 किलोग्राम था। ");
INSERT INTO urdgvh_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ख़ैमे के दरवाज़े के पाए, जानवरों को चढ़ाने की क़ुरबानगाह, उसका जंगला, बरतन और साज़ो-सामान, ");
INSERT INTO urdgvh_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","चारदीवारी के पाए, सहन के दरवाज़े के पाए और ख़ैमे और चारदीवारी की तमाम मेख़ें इसी से बनाई गईं। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","बज़लियेल की हिदायत पर कारीगरों ने नीले, अरग़वानी और क़िरमिज़ी रंग का धागा लेकर मक़दिस में ख़िदमत के लिए लिबास बनाए। उन्होंने हारून के मुक़द्दस कपड़े उन हिदायात के ऐन मुताबिक़ बनाए जो रब ने मूसा को दी थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","उन्होंने इमामे-आज़म का बालापोश बनाने के लिए सोना, नीले, अरग़वानी और क़िरमिज़ी रंग का धागा और बारीक कतान इस्तेमाल किया। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","उन्होंने सोने को कूट कूटकर वर्क़ बनाया और फिर उसे काटकर धागे बनाए। जब नीले, अरग़वानी और क़िरमिज़ी रंग के धागे और बारीक कतान से कपड़ा बनाया गया तो सोने का यह धागा महारत से कढ़ाई के काम में इस्तेमाल हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","उन्होंने बालापोश के लिए दो पट्टियाँ बनाईं और उन्हें बालापोश के कंधों पर रखकर सामने और पीछे से बालापोश के साथ लगाइं। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","पटका भी बनाया गया जिससे बालापोश को बाँधा जाता था। इसके लिए भी सोना, नीले, अरग़वानी और क़िरमिज़ी रंग का धागा और बारीक कतान इस्तेमाल हुआ। यह उन हिदायात के ऐन मुताबिक़ हुआ जो रब ने मूसा को दी थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","फिर उन्होंने अक़ीक़े-अहमर के दो पत्थर चुन लिए और उन्हें सोने के ख़ानों में जड़कर उन पर इसराईल के बारह बेटों के नाम कंदा किए। यह नाम जौहरों पर उस तरह कंदा किए गए जिस तरह मुहर कंदा की जाती है। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","उन्होंने पत्थरों को बालापोश की दो पट्टियों पर यों लगाया कि वह हारून के कंधों पर रब को इसराईलियों की याद दिलाते रहें। यह सब कुछ रब की दी गई हिदायात के ऐन मुताबिक़ हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","इसके बाद उन्होंने सीने का कीसा बनाया। यह माहिर कारीगर का काम था और उन्हीं चीज़ों से बना जिनसे हारून का बालापोश भी बना था यानी सोने और नीले, अरग़वानी और क़िरमिज़ी रंग के धागे और बारीक कतान से। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","जब कपड़े को एक दफ़ा तह किया गया तो कीसे की लंबाई और चौड़ाई नौ नौ इंच थी। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","उन्होंने उस पर चार क़तारों में जवाहर जड़े। हर क़तार में तीन तीन जौहर थे। पहली क़तार में लाल, ज़बरजद और ज़ुमुर्रद। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","दूसरी में फ़ीरोज़ा, संगे-लाजवर्द और हजरुल-क़मर। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","तीसरी में ज़रक़ोन, अक़ीक़ और याक़ूते-अरग़वानी। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","चौथी में पुखराज, अक़ीक़े-अहमर और यशब। हर जौहर सोने के ख़ाने में जड़ा हुआ था। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","यह बारह जवाहर इसराईल के बारह क़बीलों की नुमाइंदगी करते थे। एक एक जौहर पर एक क़बीले का नाम कंदा किया गया, और यह नाम उस तरह कंदा किए गए जिस तरह मुहर कंदा की जाती है। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","अब उन्होंने सीने के कीसे के लिए ख़ालिस सोने की दो ज़ंजीरें बनाईं जो डोरी की तरह गुंधी हुई थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","साथ साथ उन्होंने सोने के दो ख़ाने और दो कड़े भी बनाए। उन्होंने यह कड़े कीसे के ऊपर के दो कोनों पर लगाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","फिर दोनों ज़ंजीरें उन दो कड़ों के साथ लगाई गईं। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","उनके दूसरे सिरे बालापोश की कंधोंवाली पट्टियों के दो ख़ानों के साथ जोड़ दिए गए, फिर सामने की तरफ़ लगाए गए। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","उन्होंने कीसे के निचले दो कोनों पर भी सोने के दो कड़े लगाए। वह अंदर, बालापोश की तरफ़ लगे थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","अब उन्होंने दो और कड़े बनाकर बालापोश की कंधोंवाली पट्टियों पर लगाए। यह भी सामने की तरफ़ लगे थे लेकिन नीचे, बालापोश के पटके के ऊपर ही। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","उन्होंने सीने के कीसे के निचले कड़े नीली डोरी से बालापोश के इन निचले कड़ों के साथ बाँधे। यों कीसा पटके के ऊपर अच्छी तरह सीने के साथ लगा रहा। यह उन हिदायात के ऐन मुताबिक़ हुआ जो रब ने मूसा को दी थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","फिर कारीगरों ने चोग़ा बुना। वह पूरी तरह नीले धागे से बनाया गया। चोग़े को बालापोश से पहले पहनना था। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","उसके गरेबान को बुने हुए कालर से मज़बूत किया गया ताकि वह न फटे। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","उन्होंने नीले, अरग़वानी और क़िरमिज़ी रंग के धागे से अनार बनाकर उन्हें चोग़े के दामन में लगा दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","उनके दरमियान ख़ालिस सोने की घंटियाँ लगाई गईं। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","दामन में अनार और घंटियाँ बारी बारी लगाई गईं। लाज़िम था कि हारून ख़िदमत करने के लिए हमेशा यह चोग़ा पहने। रब ने मूसा को यही हुक्म दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","कारीगरों ने हारून और उसके बेटों के लिए बारीक कतान के ज़ेरजामे बनाए। यह बुननेवाले का काम था। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","साथ साथ उन्होंने बारीक कतान की पगड़ियाँ और बारीक कतान के पाजामे बनाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","कमरबंद को बारीक कतान और नीले, अरग़वानी और क़िरमिज़ी रंग के धागे से बनाया गया। कढ़ाई करनेवालों ने इस पर काम किया। सब कुछ उन हिदायात के मुताबिक़ बनाया गया जो रब ने मूसा को दी थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","उन्होंने मुक़द्दस ताज यानी ख़ालिस सोने की तख़्ती बनाई और उस पर यह अलफ़ाज़ कंदा किए, ‘रब के लिए मख़सूसो-मुक़द्दस।’ ");
INSERT INTO urdgvh_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","फिर उन्होंने इसे नीली डोरी से पगड़ी के सामनेवाले हिस्से से लगा दिया। यह भी उन हिदायात के मुताबिक़ बनाया गया जो रब ने मूसा को दी थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","आख़िरकार मक़दिस का काम मुकम्मल हुआ। इसराईलियों ने सब कुछ उन हिदायात के मुताबिक़ बनाया था जो रब ने मूसा को दी थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","वह मक़दिस की तमाम चीज़ें मूसा के पास ले आए यानी मुक़द्दस ख़ैमा और उसका सारा सामान, उस की हुकें, दीवारों के तख़्ते, शहतीर, सतून और पाए, ");
INSERT INTO urdgvh_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ख़ैमे पर मेंढों की सुर्ख़ रँगी हुई खालों का ग़िलाफ़ और तख़स की खालों का ग़िलाफ़, मुक़द्दसतरीन कमरे के दरवाज़े का परदा, ");
INSERT INTO urdgvh_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","अहद का संदूक़ जिसमें शरीअत की तख़्तियाँ रखनी थीं, उसे उठाने की लकड़ियाँ और उसका ढकना, ");
INSERT INTO urdgvh_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","मख़सूस रोटियों की मेज़, उसका सारा सामान और रोटियाँ, ");
INSERT INTO urdgvh_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ख़ालिस सोने का शमादान और उस पर रखने के चराग़ उसके सारे सामान समेत, शमादान के लिए तेल, ");
INSERT INTO urdgvh_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","बख़ूर जलाने की सोने की क़ुरबानगाह, मसह का तेल, ख़ुशबूदार बख़ूर, मुक़द्दस ख़ैमे के दरवाज़े का परदा, ");
INSERT INTO urdgvh_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","जानवरों को चढ़ाने की पीतल की क़ुरबानगाह, उसका पीतल का जंगला, उसे उठाने की लकड़ियाँ और बाक़ी सारा सामान, धोने का हौज़ और वह ढाँचा जिस पर हौज़ रखना था, ");
INSERT INTO urdgvh_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","चारदीवारी के परदे उनके खंबों और पाइयों समेत, सहन के दरवाज़े का परदा, चारदीवारी के रस्से और मेख़ें, मुलाक़ात के ख़ैमे में ख़िदमत करने का बाक़ी सारा सामान ");
INSERT INTO urdgvh_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","और मक़दिस में ख़िदमत करने के वह मुक़द्दस लिबास जो हारून और उसके बेटों को पहनने थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","सब कुछ उन हिदायात के मुताबिक़ बनाया गया था जो रब ने मूसा को दी थीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","मूसा ने तमाम चीज़ों का मुआयना किया और मालूम किया कि उन्होंने सब कुछ रब की हिदायात के मुताबिक़ बनाया था। तब उसने उन्हें बरकत दी। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","फिर रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“पहले महीने की पहली तारीख़ को मुलाक़ात का ख़ैमा खड़ा करना। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","अहद का संदूक़ जिसमें शरीअत की तख़्तियाँ हैं मुक़द्दसतरीन कमरे में रखकर उसके दरवाज़े का परदा लगाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","इसके बाद मख़सूस रोटियों की मेज़ मुक़द्दस कमरे में लाकर उस पर तमाम ज़रूरी सामान रखना। उस कमरे में शमादान भी ले आना और उस पर उसके चराग़ रखना। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","बख़ूर की सोने की क़ुरबानगाह उस परदे के सामने रखना जिसके पीछे अहद का संदूक़ है। फिर ख़ैमे में दाख़िल होने के दरवाज़े पर परदा लगाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","जानवरों को चढ़ाने की क़ुरबानगाह सहन में ख़ैमे के दरवाज़े के सामने रखी जाए। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ख़ैमे और इस क़ुरबानगाह के दरमियान धोने का हौज़ रखकर उसमें पानी डालना। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","सहन की चारदीवारी खड़ी करके उसके दरवाज़े का परदा लगाना। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","फिर मसह का तेल लेकर उसे ख़ैमे और उसके सारे सामान पर छिड़क देना। यों तू उसे मेरे लिए मख़सूस करेगा और वह मुक़द्दस होगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","फिर जानवरों को चढ़ाने की क़ुरबानगाह और उसके सामान पर मसह का तेल छिड़कना। यों तू उसे मेरे लिए मख़सूस करेगा और वह निहायत मुक़द्दस होगा। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","इसी तरह हौज़ और उस ढाँचे को भी मख़सूस करना जिस पर हौज़ रखा गया है। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","हारून और उसके बेटों को मुलाक़ात के ख़ैमे के दरवाज़े पर लाकर ग़ुस्ल कराना। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","फिर हारून को मुक़द्दस लिबास पहनाना और उसे मसह करके मेरे लिए मख़सूसो-मुक़द्दस करना ताकि इमाम के तौर पर मेरी ख़िदमत करे। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","उसके बेटों को लाकर उन्हें ज़ेरजामे पहना देना। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","उन्हें उनके वालिद की तरह मसह करना ताकि वह भी इमामों के तौर पर मेरी ख़िदमत करें। जब उन्हें मसह किया जाएगा तो वह और बाद में उनकी औलाद हमेशा तक मक़दिस में इस ख़िदमत के लिए मख़सूस होंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","मूसा ने सब कुछ रब की हिदायात के मुताबिक़ किया। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","पहले महीने की पहली तारीख़ को मुक़द्दस ख़ैमा खड़ा किया गया। उन्हें मिसर से निकले पूरा एक साल हो गया था। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","मूसा ने दीवार के तख़्तों को उनके पाइयों पर खड़ा करके उनके साथ शहतीर लगाए। इसी तरह उसने सतूनों को भी खड़ा किया। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","उसने रब की हिदायात के ऐन मुताबिक़ दीवारों पर कपड़े का ख़ैमा लगाया और उस पर दूसरे ग़िलाफ़ रखे। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","उसने शरीअत की दोनों तख़्तियाँ लेकर अहद के संदूक़ में रख दीं, उठाने के लिए लकड़ियाँ संदूक़ के कड़ों में डाल दीं और कफ़्फ़ारे का ढकना उस पर लगा दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","फिर उसने रब की हिदायात के ऐन मुताबिक़ संदूक़ को मुक़द्दसतरीन कमरे में रखकर उसके दरवाज़े का परदा लगा दिया। यों अहद के संदूक़ पर परदा पड़ा रहा। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","मूसा ने मख़सूस रोटियों की मेज़ मुक़द्दस कमरे के शिमाली हिस्से में उस परदे के सामने रख दी जिसके पीछे अहद का संदूक़ था। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","उसने रब की हिदायत के ऐन मुताबिक़ रब के लिए मख़सूस की हुई रोटियाँ मेज़ पर रखीं। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","उसी कमरे के जुनूबी हिस्से में उसने शमादान को मेज़ के मुक़ाबिल रख दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","उस पर उसने रब की हिदायत के ऐन मुताबिक़ रब के सामने चराग़ रख दिए। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","उसने बख़ूर की सोने की क़ुरबानगाह भी उसी कमरे में रखी, उस परदे के बिलकुल सामने जिसके पीछे अहद का संदूक़ था। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","उसने उस पर रब की हिदायत के ऐन मुताबिक़ ख़ुशबूदार बख़ूर जलाया। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","फिर उसने ख़ैमे का दरवाज़ा लगा दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","बाहर जाकर उसने जानवरों को चढ़ाने की क़ुरबानगाह ख़ैमे के दरवाज़े के सामने रख दी। उस पर उसने रब की हिदायत के ऐन मुताबिक़ भस्म होनेवाली क़ुरबानियाँ और ग़ल्ला की नज़रें चढ़ाईं। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","उसने धोने के हौज़ को ख़ैमे और उस क़ुरबानगाह के दरमियान रखकर उसमें पानी डाल दिया। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","मूसा, हारून और उसके बेटे उसे अपने हाथ-पाँव धोने के लिए इस्तेमाल करते थे। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","जब भी वह मुलाक़ात के ख़ैमे में दाख़िल होते या जानवरों को चढ़ाने की क़ुरबानगाह के पास आते तो रब की हिदायत के ऐन मुताबिक़ पहले ग़ुस्ल करते। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","आख़िर में मूसा ने ख़ैमा, क़ुरबानगाह और चारदीवारी खड़ी करके सहन के दरवाज़े का परदा लगा दिया। यों मूसा ने मक़दिस की तामीर मुकम्मल की। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","फिर मुलाक़ात के ख़ैमे पर बादल छा गया और मक़दिस रब के जलाल से भर गया। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","मूसा ख़ैमे में दाख़िल न हो सका, क्योंकि बादल उस पर ठहरा हुआ था और मक़दिस रब के जलाल से भर गया था। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","तमाम सफ़र के दौरान जब भी मक़दिस के ऊपर से बादल उठता तो इसराईली सफ़र के लिए तैयार हो जाते। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","अगर वह न उठता तो वह उस वक़्त तक ठहरे रहते जब तक बादल उठ न जाता। ");
INSERT INTO urdgvh_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","दिन के वक़्त बादल मक़दिस के ऊपर ठहरा रहता और रात के वक़्त वह तमाम इसराईलियों को आग की सूरत में नज़र आता था। यह सिलसिला पूरे सफ़र के दौरान जारी रहा। ");
INSERT INTO urdgvh_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","रब ने मुलाक़ात के ख़ैमे में से मूसा को बुलाकर कहा ");
INSERT INTO urdgvh_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","कि इसराईलियों को इत्तला दे, “अगर तुममें से कोई रब को क़ुरबानी पेश करना चाहे तो वह अपने गाय-बैलों या भेड़-बकरियों में से जानवर चुन ले। ");
INSERT INTO urdgvh_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","अगर वह अपने गाय-बैलों में से भस्म होनेवाली क़ुरबानी चढ़ाना चाहे तो वह बेऐब बैल चुनकर उसे मुलाक़ात के ख़ैमे के दरवाज़े पर पेश करे ताकि रब उसे क़बूल करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","क़ुरबानी पेश करनेवाला अपना हाथ जानवर के सर पर रखे तो यह क़ुरबानी मक़बूल होकर उसका कफ़्फ़ारा देगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","क़ुरबानी पेश करनेवाला बैल को वहाँ रब के सामने ज़बह करे। फिर हारून के बेटे जो इमाम हैं उसका ख़ून रब को पेश करके उसे दरवाज़े पर की क़ुरबानगाह के चार पहलुओं पर छिड़कें। ");
INSERT INTO urdgvh_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","इसके बाद क़ुरबानी पेश करनेवाला खाल उतारकर जानवर के टुकड़े टुकड़े करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","इमाम क़ुरबानगाह पर आग लगाकर उस पर तरतीब से लकड़ियाँ चुनें। ");
INSERT INTO urdgvh_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","उस पर वह जानवर के टुकड़े सर और चरबी समेत रखें। ");
INSERT INTO urdgvh_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","लाज़िम है कि क़ुरबानी पेश करनेवाला पहले जानवर की अंतड़ियाँ और पिंडलियाँ धोए, फिर इमाम पूरे जानवर को क़ुरबानगाह पर जला दे। इस जलनेवाली क़ुरबानी की ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","अगर भस्म होनेवाली क़ुरबानी भेड़-बकरियों में से चुनी जाए तो वह बेऐब नर हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","पेश करनेवाला उसे रब के सामने क़ुरबानगाह की शिमाली सिम्त में ज़बह करे। फिर हारून के बेटे जो इमाम हैं उसका ख़ून क़ुरबानगाह के चार पहलुओं पर छिड़कें। ");
INSERT INTO urdgvh_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","इसके बाद पेश करनेवाला जानवर के टुकड़े टुकड़े करे और इमाम यह टुकड़े सर और चरबी समेत क़ुरबानगाह की जलती हुई लकड़ियों पर तरतीब से रखे। ");
INSERT INTO urdgvh_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","लाज़िम है कि क़ुरबानी पेश करनेवाला पहले जानवर की अंतड़ियाँ और पिंडलियाँ धोए, फिर इमाम पूरे जानवर को रब को पेश करके क़ुरबानगाह पर जला दे। इस जलनेवाली क़ुरबानी की ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","अगर भस्म होनेवाली क़ुरबानी परिंदा हो तो वह क़ुम्री या जवान कबूतर हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","इमाम उसे क़ुरबानगाह के पास ले आए और उसका सर मरोड़कर क़ुरबानगाह पर जला दे। वह उसका ख़ून यों निकलने दे कि वह क़ुरबानगाह की एक तरफ़ से नीचे टपके। ");
INSERT INTO urdgvh_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","वह उसका पोटा और जो उसमें है दूर करके क़ुरबानगाह की मशरिक़ी सिम्त में फेंक दे, वहाँ जहाँ राख फेंकी जाती है। ");
INSERT INTO urdgvh_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","उसे पेश करते वक़्त इमाम उसके पर पकड़कर परिंदे को फाड़ डाले, लेकिन यों कि वह बिलकुल टुकड़े टुकड़े न हो जाए। फिर इमाम उसे क़ुरबानगाह पर जलती हुई लकड़ियों पर जला दे। इस जलनेवाली क़ुरबानी की ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","अगर कोई रब को ग़ल्ला की नज़र पेश करना चाहे तो वह इसके लिए बेहतरीन मैदा इस्तेमाल करे। उस पर वह ज़ैतून का तेल उंडेले और लुबान रखकर ");
INSERT INTO urdgvh_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","उसे हारून के बेटों के पास ले आए जो इमाम हैं। इमाम तेल से मिलाया गया मुट्ठी-भर मैदा और तमाम लुबान लेकर क़ुरबानगाह पर जला दे। यह यादगार का हिस्सा है, और उस की ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","बाक़ी मैदा और तेल हारून और उसके बेटों का हिस्सा है। वह रब की जलनेवाली क़ुरबानियों में से एक निहायत मुक़द्दस हिस्सा है। ");
INSERT INTO urdgvh_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","अगर यह क़ुरबानी तनूर में पकाई हुई रोटी हो तो उसमें ख़मीर न हो। इसकी दो क़िस्में हो सकती हैं, रोटियाँ जो बेहतरीन मैदे और तेल से बनी हुई हों और रोटियाँ जिन पर तेल लगाया गया हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","अगर यह क़ुरबानी तवे पर पकाई हुई रोटी हो तो वह बेहतरीन मैदे और तेल की हो। उसमें ख़मीर न हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","चूँकि वह ग़ल्ला की नज़र है इसलिए रोटी को टुकड़े टुकड़े करना और उस पर तेल डालना। ");
INSERT INTO urdgvh_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","अगर यह क़ुरबानी कड़ाही में पकाई हुई रोटी हो तो वह बेहतरीन मैदे और तेल की हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","अगर तू इन चीज़ों की बनी हुई ग़ल्ला की नज़र रब के हुज़ूर लाना चाहे तो उसे इमाम को पेश करना। वही उसे क़ुरबानगाह के पास ले आए। ");
INSERT INTO urdgvh_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","फिर इमाम यादगार का हिस्सा अलग करके उसे क़ुरबानगाह पर जला दे। ऐसी क़ुरबानी की ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","क़ुरबानी का बाक़ी हिस्सा हारून और उसके बेटों के लिए है। वह रब की जलनेवाली क़ुरबानियों में से एक निहायत मुक़द्दस हिस्सा है। ");
INSERT INTO urdgvh_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","ग़ल्ला की जितनी नज़रें तुम रब को पेश करते हो उनमें ख़मीर न हो, क्योंकि लाज़िम है कि तुम रब को जलनेवाली क़ुरबानी पेश करते वक़्त न ख़मीर, न शहद जलाओ। ");
INSERT INTO urdgvh_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","यह चीज़ें फ़सल के पहले फलों के साथ रब को पेश की जा सकती हैं, लेकिन उन्हें क़ुरबानगाह पर न जलाया जाए, क्योंकि वहाँ रब को उनकी ख़ुशबू पसंद नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","ग़ल्ला की हर नज़र में नमक हो, क्योंकि नमक उस अहद की नुमाइंदगी करता है जो तेरे ख़ुदा ने तेरे साथ बाँधा है। तुझे हर क़ुरबानी में नमक डालना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","अगर तू ग़ल्ला की नज़र के लिए फ़सल के पहले फल पेश करना चाहे तो कुचली हुई कच्ची बालियाँ भूनकर पेश करना। ");
INSERT INTO urdgvh_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","चूँकि वह ग़ल्ला की नज़र है इसलिए उस पर तेल उंडेलना और लुबान रखना। ");
INSERT INTO urdgvh_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","कुचले हुए दानों और तेल का जो हिस्सा रब का है यानी यादगार का हिस्सा उसे इमाम तमाम लुबान के साथ जला दे। यह नज़र रब के लिए जलनेवाली क़ुरबानी है। ");
INSERT INTO urdgvh_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","अगर कोई रब को सलामती की क़ुरबानी पेश करने के लिए गाय या बैल चढ़ाना चाहे तो वह जानवर बेऐब हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","वह अपना हाथ जानवर के सर पर रखकर उसे मुलाक़ात के ख़ैमे के दरवाज़े पर ज़बह करे। हारून के बेटे जो इमाम हैं उसका ख़ून क़ुरबानगाह के चार पहलुओं पर छिड़कें। ");
INSERT INTO urdgvh_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","4","पेश करनेवाला अंतड़ियों पर की सारी चरबी, गुरदे उस चरबी समेत जो उन पर और कमर के क़रीब होती है और जोड़कलेजी जलनेवाली क़ुरबानी के तौर पर रब को पेश करे। इन चीज़ों को गुरदों के साथ ही अलग करना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","फिर हारून के बेटे यह सब कुछ भस्म होनेवाली क़ुरबानी के साथ क़ुरबानगाह की लकड़ियों पर जला दें। यह जलनेवाली क़ुरबानी है, और इसकी ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","अगर सलामती की क़ुरबानी के लिए भेड़-बकरियों में से जानवर चुना जाए तो वह बेऐब नर या मादा हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","अगर वह भेड़ का बच्चा चढ़ाना चाहे तो वह उसे रब के सामने ले आए। ");
INSERT INTO urdgvh_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","वह अपना हाथ उसके सर पर रखकर उसे मुलाक़ात के ख़ैमे के सामने ज़बह करे। हारून के बेटे उसका ख़ून क़ुरबानगाह के चार पहलुओं पर छिड़कें। ");
INSERT INTO urdgvh_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","10","पेश करनेवाला चरबी, पूरी दुम, अंतड़ियों पर की सारी चरबी, गुरदे उस चरबी समेत जो उन पर और कमर के क़रीब होती है और जोड़कलेजी जलनेवाली क़ुरबानी के तौर पर रब को पेश करे। इन चीज़ों को गुरदों के साथ ही अलग करना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","इमाम यह सब कुछ रब को पेश करके क़ुरबानगाह पर जला दे। यह ख़ुराक जलनेवाली क़ुरबानी है। ");
INSERT INTO urdgvh_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","अगर सलामती की क़ुरबानी बकरी की हो ");
INSERT INTO urdgvh_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","तो पेश करनेवाला उस पर हाथ रखकर उसे मुलाक़ात के ख़ैमे के सामने ज़बह करे। हारून के बेटे जानवर का ख़ून क़ुरबानगाह के चार पहलुओं पर छिड़कें। ");
INSERT INTO urdgvh_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","15","पेश करनेवाला अंतड़ियों पर की सारी चरबी, गुरदे उस चरबी समेत जो उन पर और कमर के क़रीब होती है और जोड़कलेजी जलनेवाली क़ुरबानी के तौर पर रब को पेश करे। इन चीज़ों को गुरदों के साथ ही अलग करना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","इमाम यह सब कुछ रब को पेश करके क़ुरबानगाह पर जला दे। यह ख़ुराक जलनेवाली क़ुरबानी है, और इसकी ख़ुशबू रब को पसंद है। सारी चरबी रब की है। ");
INSERT INTO urdgvh_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","तुम्हारे लिए ख़ून या चरबी खाना मना है। यह न सिर्फ़ तुम्हारे लिए मना है बल्कि तुम्हारी औलाद के लिए भी, न सिर्फ़ यहाँ बल्कि हर जगह जहाँ तुम रहते हो।” ");
INSERT INTO urdgvh_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“इसराईलियों को बताना कि जो भी ग़ैरइरादी तौर पर गुनाह करके रब के किसी हुक्म को तोड़े वह यह करे : ");
INSERT INTO urdgvh_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","अगर इमामे-आज़म गुनाह करे और नतीजे में पूरी क़ौम क़ुसूरवार ठहरे तो फिर वह रब को एक बेऐब जवान बैल लेकर गुनाह की क़ुरबानी के तौर पर पेश करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","वह जवान बैल को मुलाक़ात के ख़ैमे के दरवाज़े के पास ले आए और अपना हाथ उसके सर पर रखकर उसे रब के सामने ज़बह करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","फिर वह जानवर के ख़ून में से कुछ लेकर ख़ैमे में जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","वहाँ वह अपनी उँगली उसमें डालकर उसे सात बार रब के सामने यानी मुक़द्दसतरीन कमरे के परदे पर छिड़के। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","फिर वह ख़ैमे के अंदर की उस क़ुरबानगाह के चारों सींगों पर ख़ून लगाए जिस पर बख़ूर जलाया जाता है। बाक़ी ख़ून वह बाहर ख़ैमे के दरवाज़े पर की उस क़ुरबानगाह के पाए पर उंडेले जिस पर जानवर जलाए जाते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","जवान बैल की सारी चरबी, अंतड़ियों पर की सारी चरबी, ");
INSERT INTO urdgvh_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","गुरदे उस चरबी समेत जो उन पर और कमर के क़रीब होती है और जोड़कलेजी को गुरदों के साथ ही अलग करना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","यह बिलकुल उसी तरह किया जाए जिस तरह उस बैल के साथ किया गया जो सलामती की क़ुरबानी के लिए पेश किया जाता है। इमाम यह सब कुछ उस क़ुरबानगाह पर जला दे जिस पर जानवर जलाए जाते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","लेकिन वह उस की खाल, उसका सारा गोश्त, सर और पिंडलियाँ, अंतड़ियाँ और उनका गोबर ");
INSERT INTO urdgvh_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ख़ैमागाह के बाहर ले जाए। यह चीज़ें उस पाक जगह पर जहाँ क़ुरबानियों की राख फेंकी जाती है लकड़ियों पर रखकर जला देनी हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","अगर इसराईल की पूरी जमात ने ग़ैरइरादी तौर पर गुनाह करके रब के किसी हुक्म से तजावुज़ किया है और जमात को मालूम नहीं था तो भी वह क़ुसूरवार है। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","जब लोगों को पता लगे कि हमने गुनाह किया है तो जमात मुलाक़ात के ख़ैमे के पास एक जवान बैल ले आए और उसे गुनाह की क़ुरबानी के तौर पर पेश करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","जमात के बुज़ुर्ग रब के सामने अपने हाथ उसके सर पर रखें, और वह वहीं ज़बह किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","फिर इमामे-आज़म जानवर के ख़ून में से कुछ लेकर मुलाक़ात के ख़ैमे में जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","वहाँ वह अपनी उँगली उसमें डालकर उसे सात बार रब के सामने यानी मुक़द्दसतरीन कमरे के परदे पर छिड़के। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","फिर वह ख़ैमे के अंदर की उस क़ुरबानगाह के चारों सींगों पर ख़ून लगाए जिस पर बख़ूर जलाया जाता है। बाक़ी ख़ून वह बाहर ख़ैमे के दरवाज़े की उस क़ुरबानगाह के पाए पर उंडेले जिस पर जानवर जलाए जाते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","इसके बाद वह उस की तमाम चरबी निकालकर क़ुरबानगाह पर जला दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","उस बैल के साथ वह सब कुछ करे जो उसे अपने ज़ाती ग़ैरइरादी गुनाह के लिए करना होता है। यों वह लोगों का कफ़्फ़ारा देगा और उन्हें मुआफ़ी मिल जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","आख़िर में वह बैल को ख़ैमागाह के बाहर ले जाकर उस तरह जला दे जिस तरह उसे अपने लिए बैल को जला देना होता है। यह जमात का गुनाह दूर करने की क़ुरबानी है। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","अगर कोई सरदार ग़ैरइरादी तौर पर गुनाह करके रब के किसी हुक्म से तजावुज़ करे और यों क़ुसूरवार ठहरे तो ");
INSERT INTO urdgvh_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","जब भी उसे पता लगे कि मुझसे गुनाह हुआ है तो वह क़ुरबानी के लिए एक बेऐब बकरा ले आए। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","वह अपना हाथ बकरे के सर पर रखकर उसे वहाँ ज़बह करे जहाँ भस्म होनेवाली क़ुरबानियाँ ज़बह की जाती हैं। यह गुनाह की क़ुरबानी है। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","इमाम अपनी उँगली ख़ून में डालकर उसे उस क़ुरबानगाह के चारों सींगों पर लगाए जिस पर जानवर जलाए जाते हैं। बाक़ी ख़ून वह क़ुरबानगाह के पाए पर उंडेले। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","फिर वह उस की सारी चरबी क़ुरबानगाह पर उस तरह जला दे जिस तरह वह सलामती की क़ुरबानियों की चरबी जला देता है। यों इमाम उस आदमी का कफ़्फ़ारा देगा और उसे मुआफ़ी हासिल हो जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","अगर कोई आम शख़्स ग़ैरइरादी तौर पर गुनाह करके रब के किसी हुक्म से तजावुज़ करे और यों क़ुसूरवार ठहरे तो ");
INSERT INTO urdgvh_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","जब भी उसे पता लगे कि मुझसे गुनाह हुआ है तो वह क़ुरबानी के लिए एक बेऐब बकरी ले आए। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","वह अपना हाथ बकरी के सर पर रखकर उसे वहाँ ज़बह करे जहाँ भस्म होनेवाली क़ुरबानियाँ ज़बह की जाती हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","इमाम अपनी उँगली ख़ून में डालकर उसे उस क़ुरबानगाह के चारों सींगों पर लगाए जिस पर जानवर जलाए जाते हैं। बाक़ी ख़ून वह क़ुरबानगाह के पाए पर उंडेले। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","फिर वह उस की सारी चरबी उस तरह निकाले जिस तरह वह सलामती की क़ुरबानियों की चरबी निकालता है। इसके बाद वह उसे क़ुरबानगाह पर जला दे। ऐसी क़ुरबानी की ख़ुशबू रब को पसंद है। यों इमाम उस आदमी का कफ़्फ़ारा देगा और उसे मुआफ़ी हासिल हो जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","अगर वह गुनाह की क़ुरबानी के लिए भेड़ का बच्चा लाना चाहे तो वह बेऐब मादा हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","वह अपना हाथ उसके सर पर रखकर उसे वहाँ ज़बह करे जहाँ भस्म होनेवाली क़ुरबानियाँ ज़बह की जाती हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","इमाम अपनी उँगली ख़ून में डालकर उसे उस क़ुरबानगाह के चारों सींगों पर लगाए जिस पर जानवर जलाए जाते हैं। बाक़ी ख़ून वह क़ुरबानगाह के पाए पर उंडेले। ");
INSERT INTO urdgvh_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","फिर वह उस की तमाम चरबी उस तरह निकाले जिस तरह सलामती की क़ुरबानी के लिए ज़बह किए गए जवान मेंढे की चरबी निकाली जाती है। इसके बाद इमाम चरबी को क़ुरबानगाह पर उन क़ुरबानियों समेत जला दे जो रब के लिए जलाई जाती हैं। यों इमाम उस आदमी का कफ़्फ़ारा देगा और उसे मुआफ़ी मिल जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","हो सकता है कि किसी ने यों गुनाह किया कि उसने कोई जुर्म देखा या वह उसके बारे में कुछ जानता है। तो भी जब गवाहों को क़सम के लिए बुलाया जाता है तो वह गवाही देने के लिए सामने नहीं आता। इस सूरत में वह क़ुसूरवार ठहरता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","हो सकता है कि किसी ने ग़ैरइरादी तौर पर किसी नापाक चीज़ को छू लिया है, ख़ाह वह किसी जंगली जानवर, मवेशी या रेंगनेवाले जानवर की लाश क्यों न हो। इस सूरत में वह नापाक है और क़ुसूरवार ठहरता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","हो सकता है कि किसी ने ग़ैरइरादी तौर पर किसी शख़्स की नापाकी को छू लिया है यानी उस की कोई ऐसी चीज़ जिससे वह नापाक हो गया है। जब उसे मालूम हो जाता है तो वह क़ुसूरवार ठहरता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","हो सकता है कि किसी ने बेपरवाई से कुछ करने की क़सम खाई है, चाहे वह अच्छा काम था या ग़लत। जब वह जान लेता है कि उसने क्या किया है तो वह क़ुसूरवार ठहरता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","जो इस तरह के किसी गुनाह की बिना पर क़ुसूरवार हो, लाज़िम है कि वह अपना गुनाह तसलीम करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","फिर वह गुनाह की क़ुरबानी के तौर पर एक भेड़ या बकरी पेश करे। यों इमाम उसका कफ़्फ़ारा देगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","अगर क़ुसूरवार शख़्स ग़ुरबत के बाइस भेड़ या बकरी न दे सके तो वह रब को दो क़ुम्रियाँ या दो जवान कबूतर पेश करे, एक गुनाह की क़ुरबानी के लिए और एक भस्म होनेवाली क़ुरबानी के लिए। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","वह उन्हें इमाम के पास ले आए। इमाम पहले गुनाह की क़ुरबानी के लिए परिंदा पेश करे। वह उस की गरदन मरोड़ डाले लेकिन ऐसे कि सर जुदा न हो जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","फिर वह उसके ख़ून में से कुछ क़ुरबानगाह के एक पहलू पर छिड़के। बाक़ी ख़ून वह यों निकलने दे कि वह क़ुरबानगाह के पाए पर टपके। यह गुनाह की क़ुरबानी है। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","फिर इमाम दूसरे परिंदे को क़वायद के मुताबिक़ भस्म होनेवाली क़ुरबानी के तौर पर पेश करे। यों इमाम उस आदमी का कफ़्फ़ारा देगा और उसे मुआफ़ी मिल जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","अगर वह शख़्स ग़ुरबत के बाइस दो क़ुम्रियाँ या दो जवान कबूतर भी न दे सके तो फिर वह गुनाह की क़ुरबानी के लिए डेढ़ किलोग्राम बेहतरीन मैदा पेश करे। वह उस पर न तेल उंडेले, न लुबान रखे, क्योंकि यह ग़ल्ला की नज़र नहीं बल्कि गुनाह की क़ुरबानी है। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","वह उसे इमाम के पास ले आए जो यादगार का हिस्सा यानी मुट्ठी-भर उन क़ुरबानियों के साथ जला दे जो रब के लिए जलाई जाती हैं। यह गुनाह की क़ुरबानी है। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","यों इमाम उस आदमी का कफ़्फ़ारा देगा और उसे मुआफ़ी मिल जाएगी। ग़ल्ला की नज़र की तरह बाक़ी मैदा इमाम का हिस्सा है।” ");
INSERT INTO urdgvh_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“अगर किसी ने बेईमानी करके ग़ैरइरादी तौर पर रब की मख़सूस और मुक़द्दस चीज़ों के सिलसिले में गुनाह किया हो, ऐसा शख़्स क़ुसूर की क़ुरबानी के तौर पर रब को बेऐब और क़ीमत के लिहाज़ से मुनासिब मेंढा या बकरा पेश करे। उस की क़ीमत मक़दिस की शरह के मुताबिक़ मुक़र्रर की जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","जितना नुक़सान मक़दिस को हुआ है उतना ही वह दे। इसके अलावा वह मज़ीद 20 फ़ीसद अदा करे। वह उसे इमाम को दे दे और इमाम जानवर को क़ुसूर की क़ुरबानी के तौर पर पेश करके उसका कफ़्फ़ारा दे। यों उसे मुआफ़ी मिल जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","अगर कोई ग़ैरइरादी तौर पर गुनाह करके रब के किसी हुक्म से तजावुज़ करे तो वह क़ुसूरवार है, और वह उसका ज़िम्मादार ठहरेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","वह क़ुसूर की क़ुरबानी के तौर पर इमाम के पास एक बेऐब और क़ीमत के लिहाज़ से मुनासिब मेंढा ले आए। उस की क़ीमत मक़दिस की शरह के मुताबिक़ मुक़र्रर की जाए। फिर इमाम यह क़ुरबानी उस गुनाह के लिए चढ़ाए जो क़ुसूरवार शख़्स ने ग़ैरइरादी तौर पर किया है। यों उसे मुआफ़ी मिल जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","यह क़ुसूर की क़ुरबानी है, क्योंकि वह रब का गुनाह करके क़ुसूरवार ठहरा है।” ");
INSERT INTO urdgvh_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“हो सकता है किसी ने गुनाह करके बेईमानी की है, मसलन उसने अपने पड़ोसी की कोई चीज़ वापस नहीं की जो उसके सुपुर्द की गई थी या जो उसे गिरवी के तौर पर मिली थी, या उसने उस की कोई चीज़ चोरी की, या उसने किसी से कोई चीज़ छीन ली, ");
INSERT INTO urdgvh_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","या उसने किसी की गुमशुदा चीज़ के बारे में झूट बोला जब उसे मिल गई, या उसने क़सम खाकर झूट बोला है, या इस तरह का कोई और गुनाह किया है। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","अगर वह इस तरह का गुनाह करके क़ुसूरवार ठहरे तो लाज़िम है कि वह वही चीज़ वापस करे जो उसने चोरी की या छीन ली या जो उसके सुपुर्द की गई या जो गुमशुदा होकर उसके पास आ गई है ");
INSERT INTO urdgvh_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","या जिसके बारे में उसने क़सम खाकर झूट बोला है। वह उसका उतना ही वापस करके 20 फ़ीसद ज़्यादा दे। और वह यह सब कुछ उस दिन वापस करे जब वह अपनी क़ुसूर की क़ुरबानी पेश करता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","क़ुसूर की क़ुरबानी के तौर पर वह एक बेऐब और क़ीमत के लिहाज़ से मुनासिब मेंढा इमाम के पास ले आए और रब को पेश करे। उस की क़ीमत मक़दिस की शरह के मुताबिक़ मुक़र्रर की जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","फिर इमाम रब के सामने उसका कफ़्फ़ारा देगा तो उसे मुआफ़ी मिल जाएगी।” ");
INSERT INTO urdgvh_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“हारून और उसके बेटों को भस्म होनेवाली क़ुरबानियों के बारे में ज़ैल की हिदायात देना : भस्म होनेवाली क़ुरबानी पूरी रात सुबह तक क़ुरबानगाह की उस जगह पर रहे जहाँ आग जलती है। आग को बुझने न देना। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","सुबह को इमाम कतान का लिबास और कतान का पाजामा पहनकर क़ुरबानी से बची हुई राख क़ुरबानगाह के पास ज़मीन पर डाले। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","फिर वह अपने कपड़े बदलकर राख को ख़ैमागाह के बाहर किसी पाक जगह पर छोड़ आए। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","क़ुरबानगाह पर आग जलती रहे। वह कभी भी न बुझे। हर सुबह इमाम लकड़ियाँ चुनकर उस पर भस्म होनेवाली क़ुरबानी तरतीब से रखे और उस पर सलामती की क़ुरबानी की चरबी जला दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","आग हमेशा जलती रहे। वह कभी न बुझने पाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","ग़ल्ला की नज़र के बारे में हिदायात यह हैं : हारून के बेटे उसे क़ुरबानगाह के सामने रब को पेश करें। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","फिर इमाम यादगार का हिस्सा यानी तेल से मिलाया गया मुट्ठी-भर बेहतरीन मैदा और क़ुरबानी का तमाम लुबान लेकर क़ुरबानगाह पर जला दे। इसकी ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","हारून और उसके बेटे क़ुरबानी का बाक़ी हिस्सा खा लें। लेकिन वह उसे मुक़द्दस जगह पर यानी मुलाक़ात के ख़ैमे की चारदीवारी के अंदर खाएँ, और उसमें ख़मीर न हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","उसे पकाने के लिए उसमें ख़मीर न डाला जाए। मैंने जलनेवाली क़ुरबानियों में से यह हिस्सा उनके लिए मुक़र्रर किया है। यह गुनाह की क़ुरबानी और क़ुसूर की क़ुरबानी की तरह निहायत मुक़द्दस है। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","हारून की औलाद के तमाम मर्द उसे खाएँ। यह उसूल अबद तक क़ायम रहे। जो भी उसे छुएगा वह मख़सूसो-मुक़द्दस हो जाएगा।” ");
INSERT INTO urdgvh_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“जब हारून और उसके बेटों को इमाम की ज़िम्मादारी उठाने के लिए मख़सूस करके तेल से मसह किया जाएगा तो वह डेढ़ किलोग्राम बेहतरीन मैदा पेश करें। उसका आधा हिस्सा सुबह को और आधा हिस्सा शाम के वक़्त पेश किया जाए। वह ग़ल्ला की यह नज़र रोज़ाना पेश करें। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","उसे तेल के साथ मिलाकर तवे पर पकाना है। फिर उसे टुकड़े टुकड़े करके ग़ल्ला की नज़र के तौर पर पेश करना। उस की ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","यह क़ुरबानी हमेशा हारून की नसल का वह आदमी पेश करे जिसे मसह करके इमामे-आज़म का ओहदा दिया गया है, और वह उसे पूरे तौर पर रब के लिए जला दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","इमाम की ग़ल्ला की नज़र हमेशा पूरे तौर पर जलाना। उसे न खाना।” ");
INSERT INTO urdgvh_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“हारून और उसके बेटों को गुनाह की क़ुरबानी के बारे में ज़ैल की हिदायात देना : गुनाह की क़ुरबानी को रब के सामने वहीं ज़बह करना है जहाँ भस्म होनेवाली क़ुरबानी ज़बह की जाती है। वह निहायत मुक़द्दस है। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","उसे पेश करनेवाला इमाम उसे मुक़द्दस जगह पर यानी मुलाक़ात के ख़ैमे की चारदीवारी के अंदर खाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","जो भी इस क़ुरबानी के गोश्त को छू लेता है वह मख़सूसो-मुक़द्दस हो जाता है। अगर क़ुरबानी के ख़ून के छींटे किसी लिबास पर पड़ जाएँ तो उसे मुक़द्दस जगह पर धोना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","अगर गोश्त को हंडिया में पकाया गया हो तो उस बरतन को बाद में तोड़ देना है। अगर उसके लिए पीतल का बरतन इस्तेमाल किया गया हो तो उसे ख़ूब माँझकर पानी से साफ़ करना। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","इमामों के ख़ानदानों में से तमाम मर्द उसे खा सकते हैं। यह खाना निहायत मुक़द्दस है। ");
INSERT INTO urdgvh_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","लेकिन गुनाह की हर वह क़ुरबानी खाई न जाए जिसका ख़ून मुलाक़ात के ख़ैमे में इसलिए लाया गया है कि मक़दिस में किसी का कफ़्फ़ारा दिया जाए। उसे जलाना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","क़ुसूर की क़ुरबानी जो निहायत मुक़द्दस है उसके बारे में हिदायात यह हैं : ");
INSERT INTO urdgvh_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","क़ुसूर की क़ुरबानी वहीं ज़बह करनी है जहाँ भस्म होनेवाली क़ुरबानी ज़बह की जाती है। उसका ख़ून क़ुरबानगाह के चार पहलुओं पर छिड़का जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","उस की तमाम चरबी निकालकर क़ुरबानगाह पर चढ़ानी है यानी उस की दुम, अंतड़ियों पर की चरबी, ");
INSERT INTO urdgvh_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","गुरदे उस चरबी समेत जो उन पर और कमर के क़रीब होती है और जोड़कलेजी। इन चीज़ों को गुरदों के साथ ही अलग करना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","इमाम यह सब कुछ रब को क़ुरबानगाह पर जलनेवाली क़ुरबानी के तौर पर पेश करे। यह क़ुसूर की क़ुरबानी है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","इमामों के ख़ानदानों में से तमाम मर्द उसे खा सकते हैं। लेकिन उसे मुक़द्दस जगह पर खाया जाए। यह निहायत मुक़द्दस है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","गुनाह और क़ुसूर की क़ुरबानी के लिए एक ही उसूल है, जो इमाम क़ुरबानी को पेश करके कफ़्फ़ारा देता है उसको उसका गोश्त मिलता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","इस तरह जो इमाम किसी जानवर को भस्म होनेवाली क़ुरबानी के तौर पर चढ़ाता है उसी को जानवर की खाल मिलती है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","और इसी तरह तनूर में, कड़ाही में या तवे पर पकाई गई ग़ल्ला की हर नज़र उस इमाम को मिलती है जिसने उसे पेश किया है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","लेकिन हारून के तमाम बेटों को ग़ल्ला की बाक़ी नज़रें बराबर बराबर मिलती रहें, ख़ाह उनमें तेल मिलाया गया हो या वह ख़ुश्क हों। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","सलामती की क़ुरबानी जो रब को पेश की जाती है उसके बारे में ज़ैल की हिदायात हैं : ");
INSERT INTO urdgvh_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","अगर कोई इस क़ुरबानी से अपनी शुक्रगुज़ारी का इज़हार करना चाहे तो वह जानवर के साथ बेख़मीरी रोटी जिसमें तेल डाला गया हो, बेख़मीरी रोटी जिस पर तेल लगाया गया हो और रोटी जिसमें बेहतरीन मैदा और तेल मिलाया गया हो पेश करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","इसके अलावा वह ख़मीरी रोटी भी पेश करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","पेश करनेवाला क़ुरबानी की हर चीज़ का एक हिस्सा उठाकर रब के लिए मख़सूस करे। यह उस इमाम का हिस्सा है जो जानवर का ख़ून क़ुरबानगाह पर छिड़कता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","गोश्त उसी दिन खाया जाए जब जानवर को ज़बह किया गया हो। अगली सुबह तक कुछ नहीं बचना चाहिए। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","इस क़ुरबानी का गोश्त सिर्फ़ इस सूरत में अगले दिन खाया जा सकता है जब किसी ने मन्नत मानकर या अपनी ख़ुशी से उसे पेश किया है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","अगर कुछ गोश्त तीसरे दिन तक बच जाए तो उसे जलाना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","अगर उसे तीसरे दिन भी खाया जाए तो रब यह क़ुरबानी क़बूल नहीं करेगा। उसका कोई फ़ायदा नहीं होगा बल्कि उसे नापाक क़रार दिया जाएगा। जो भी उससे खाएगा वह क़ुसूरवार ठहरेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","अगर यह गोश्त किसी नापाक चीज़ से लग जाए तो उसे नहीं खाना है बल्कि उसे जलाया जाए। अगर गोश्त पाक है तो हर शख़्स जो ख़ुद पाक है उसे खा सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","लेकिन अगर नापाक शख़्स रब को पेश की गई सलामती की क़ुरबानी का यह गोश्त खाए तो उसे उस की क़ौम में से मिटा डालना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","हो सकता है कि किसी ने किसी नापाक चीज़ को छू लिया है चाहे वह नापाक शख़्स, जानवर या कोई और घिनौनी और नापाक चीज़ हो। अगर ऐसा शख़्स रब को पेश की गई सलामती की क़ुरबानी का गोश्त खाए तो उसे उस की क़ौम में से मिटा डालना है।” ");
INSERT INTO urdgvh_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“इसराईलियों को बता देना कि गाय-बैल और भेड़-बकरियों की चरबी खाना तुम्हारे लिए मना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","तुम फ़ितरी तौर पर मरे हुए जानवरों और फाड़े हुए जानवरों की चरबी दीगर कामों के लिए इस्तेमाल कर सकते हो, लेकिन उसे खाना मना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","जो भी उस चरबी में से खाए जो जलाकर रब को पेश की जाती है उसे उस की क़ौम में से मिटा डालना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","जहाँ भी तुम रहते हो वहाँ परिंदों या दीगर जानवरों का ख़ून खाना मना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","जो भी ख़ून खाए उसे उस की क़ौम में से मिटाया जाए।” ");
INSERT INTO urdgvh_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“इसराईलियों को बताना कि जो रब को सलामती की क़ुरबानी पेश करे वह रब के लिए एक हिस्सा मख़सूस करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","वह जलनेवाली यह क़ुरबानी अपने हाथों से रब को पेश करे। इसके लिए वह जानवर की चरबी और सीना रब के सामने पेश करे। सीना हिलानेवाली क़ुरबानी हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","इमाम चरबी को क़ुरबानगाह पर जला दे जबकि सीना हारून और उसके बेटों का हिस्सा है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","क़ुरबानी की दहनी रान इमाम को उठानेवाली क़ुरबानी के तौर पर दी जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","वह उस इमाम का हिस्सा है जो सलामती की क़ुरबानी का ख़ून और चरबी चढ़ाता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","इसराईलियों की सलामती की क़ुरबानियों में से मैंने हिलानेवाला सीना और उठानेवाली रान इमामों को दी है। यह चीज़ें हमेशा के लिए इसराईलियों की तरफ़ से इमामों का हक़ हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","यह उस दिन जलनेवाली क़ुरबानियों में से हारून और उसके बेटों का हिस्सा बन गईं जब उन्हें मक़दिस में रब की ख़िदमत में पेश किया गया। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","रब ने उस दिन जब उन्हें तेल से मसह किया गया हुक्म दिया था कि इसराईली यह हिस्सा हमेशा इमामों को दिया करें। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ग़रज़ यह हिदायात तमाम क़ुरबानियों के बारे में हैं यानी भस्म होनेवाली क़ुरबानी, ग़ल्ला की नज़र, गुनाह की क़ुरबानी, क़ुसूर की क़ुरबानी, इमाम को मक़दिस में ख़िदमत के लिए मख़सूस करने की क़ुरबानी और सलामती की क़ुरबानी के बारे में। ");
INSERT INTO urdgvh_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","रब ने मूसा को यह हिदायात सीना पहाड़ पर दीं, उस दिन जब उसने इसराईलियों को हुक्म दिया कि वह दश्ते-सीना में रब को अपनी क़ुरबानियाँ पेश करें। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“हारून और उसके बेटों को मेरे हुज़ूर ले आना। नीज़ इमामों के लिबास, मसह का तेल, गुनाह की क़ुरबानी के लिए जवान बैल, दो मेंढे और बेख़मीरी रोटियों की टोकरी ले आना। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","फिर पूरी जमात को ख़ैमे के दरवाज़े पर जमा करना।” ");
INSERT INTO urdgvh_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","मूसा ने ऐसा ही किया। जब पूरी जमात इकट्ठी हो गई तो ");
INSERT INTO urdgvh_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","उसने उनसे कहा, “अब मैं वह कुछ करता हूँ जिसका हुक्म रब ने दिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","मूसा ने हारून और उसके बेटों को सामने लाकर ग़ुस्ल कराया। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","उसने हारून को कतान का ज़ेरजामा पहनाकर कमरबंद लपेटा। फिर उसने चोग़ा पहनाया जिस पर उसने बालापोश को महारत से बुने हुए पटके से बाँधा। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","इसके बाद उसने सीने का कीसा लगाकर उसमें दोनों क़ुरे बनाम ऊरीम और तुम्मीम रखे। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","फिर उसने हारून के सर पर पगड़ी रखी जिसके सामनेवाले हिस्से पर उसने मुक़द्दस ताज यानी सोने की तख़्ती लगा दी। सब कुछ उस हुक्म के ऐन मुताबिक़ हुआ जो रब ने मूसा को दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","इसके बाद मूसा ने मसह के तेल से मक़दिस को और जो कुछ उसमें था मसह करके उसे मख़सूसो-मुक़द्दस किया। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","उसने यह तेल सात बार जानवर चढ़ाने की क़ुरबानगाह और उसके सामान पर छिड़क दिया। इसी तरह उसने सात बार धोने के हौज़ और उस ढाँचे पर तेल छिड़क दिया जिस पर हौज़ रखा हुआ था। यों यह चीज़ें मख़सूसो-मुक़द्दस हुईं। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","उसने हारून के सर पर मसह का तेल उंडेलकर उसे मसह किया। यों वह मख़सूसो-मुक़द्दस हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","फिर मूसा ने हारून के बेटों को सामने लाकर उन्हें ज़ेरजामे पहनाए, कमरबंद लपेटे और उनके सरों पर पगड़ियाँ बाँधीं। सब कुछ उस हुक्म के ऐन मुताबिक़ हुआ जो रब ने मूसा को दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","अब मूसा ने गुनाह की क़ुरबानी के लिए जवान बैल को पेश किया। हारून और उसके बेटों ने अपने हाथ उसके सर पर रखे। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","मूसा ने उसे ज़बह करके उसके ख़ून में से कुछ लेकर अपनी उँगली से क़ुरबानगाह के सींगों पर लगा दिया ताकि वह गुनाहों से पाक हो जाए। बाक़ी ख़ून उसने क़ुरबानगाह के पाए पर उंडेल दिया। यों उसने उसे मख़सूसो-मुक़द्दस करके उसका कफ़्फ़ारा दिया। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","मूसा ने अंतड़ियों पर की तमाम चरबी, जोड़कलेजी और दोनों गुरदे उनकी चरबी समेत लेकर क़ुरबानगाह पर जला दिए। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","लेकिन बैल की खाल, गोश्त और अंतड़ियों के गोबर को उसने ख़ैमागाह के बाहर ले जाकर जला दिया। सब कुछ उस हुक्म के मुताबिक़ हुआ जो रब ने मूसा को दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","इसके बाद उसने भस्म होनेवाली क़ुरबानी के लिए पहला मेंढा पेश किया। हारून और उसके बेटों ने अपने हाथ उसके सर पर रख दिए। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","मूसा ने उसे ज़बह करके उसका ख़ून क़ुरबानगाह के चार पहलुओं पर छिड़क दिया। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","उसने मेंढे को टुकड़े टुकड़े करके सर, टुकड़े और चरबी जला दी। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","उसने अंतड़ियाँ और पिंडलियाँ पानी से साफ़ करके पूरे मेंढे को क़ुरबानगाह पर जला दिया। सब कुछ उस हुक्म के ऐन मुताबिक़ हुआ जो रब ने मूसा को दिया था। रब के लिए जलनेवाली यह क़ुरबानी भस्म होनेवाली क़ुरबानी थी, और उस की ख़ुशबू रब को पसंद थी। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","इसके बाद मूसा ने दूसरे मेंढे को पेश किया। इस क़ुरबानी का मक़सद इमामों को मक़दिस में ख़िदमत के लिए मख़सूस करना था। हारून और उसके बेटों ने अपने हाथ मेंढे के सर पर रख दिए। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","मूसा ने उसे ज़बह करके उसके ख़ून में से कुछ लेकर हारून के दहने कान की लौ पर और उसके दहने हाथ और दहने पाँव के अंगूठों पर लगाया। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","यही उसने हारून के बेटों के साथ भी किया। उसने उन्हें सामने लाकर उनके दहने कान की लौ पर और उनके दहने हाथ और दहने पाँव के अंगूठों पर ख़ून लगाया। बाक़ी ख़ून उसने क़ुरबानगाह के चार पहलुओं पर छिड़क दिया। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","उसने मेंढे की चरबी, दुम, अंतड़ियों पर की सारी चरबी, जोड़कलेजी, दोनों गुरदे उनकी चरबी समेत और दहनी रान अलग की। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","फिर वह रब के सामने पड़ी बेख़मीरी रोटियों की टोकरी में से एक सादा रोटी, एक रोटी जिसमें तेल डाला गया था और एक रोटी जिस पर तेल लगाया गया था लेकर चरबी और रान पर रख दी। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","उसने यह सब कुछ हारून और उसके बेटों के हाथों पर रखकर उसे हिलानेवाली क़ुरबानी के तौर पर रब को पेश किया। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","फिर उसने यह चीज़ें उनसे वापस लेकर क़ुरबानगाह पर जला दीं जिस पर पहले भस्म होनेवाली क़ुरबानी रखी गई थी। रब के लिए जलनेवाली यह क़ुरबानी इमामों को मख़सूस करने के लिए चढ़ाई गई, और उस की ख़ुशबू रब को पसंद थी। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","मूसा ने सीना भी लिया और उसे हिलानेवाली क़ुरबानी के तौर पर रब के सामने हिलाया। यह मख़सूसियत के मेंढे में से मूसा का हिस्सा था। मूसा ने इसमें भी सब कुछ रब के हुक्म के ऐन मुताबिक़ किया। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","फिर उसने मसह के तेल और क़ुरबानगाह पर के ख़ून में से कुछ लेकर हारून, उसके बेटों और उनके कपड़ों पर छिड़क दिया। यों उसने उन्हें और उनके कपड़ों को मख़सूसो-मुक़द्दस किया। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","मूसा ने उनसे कहा, “गोश्त को मुलाक़ात के ख़ैमे के दरवाज़े पर उबालकर उसे उन रोटियों के साथ खाना जो मख़सूसियत की क़ुरबानियों की टोकरी में पड़ी हैं। क्योंकि रब ने मुझे यही हुक्म दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","गोश्त और रोटियों का बक़ाया जला देना। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","सात दिन तक मुलाक़ात के ख़ैमे के दरवाज़े में से न निकलना, क्योंकि मक़दिस में ख़िदमत के लिए तुम्हारी मख़सूसियत के इतने ही दिन हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","जो कुछ आज हुआ है वह रब के हुक्म के मुताबिक़ हुआ ताकि तुम्हारा कफ़्फ़ारा दिया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","तुम्हें सात रात और दिन तक ख़ैमे के दरवाज़े के अंदर रहना है। रब की इस हिदायत को मानो वरना तुम मर जाओगे, क्योंकि यह हुक्म मुझे रब की तरफ़ से दिया गया है।” ");
INSERT INTO urdgvh_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","हारून और उसके बेटों ने उन तमाम हिदायात पर अमल किया जो रब ने मूसा की मारिफ़त उन्हें दी थीं। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","मख़सूसियत के सात दिन के बाद मूसा ने आठवें दिन हारून, उसके बेटों और इसराईल के बुज़ुर्गों को बुलाया। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","उसने हारून से कहा, “एक बेऐब बछड़ा और एक बेऐब मेंढा चुनकर रब को पेश कर। बछड़ा गुनाह की क़ुरबानी के लिए और मेंढा भस्म होनेवाली क़ुरबानी के लिए हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","फिर इसराईलियों को कह देना कि गुनाह की क़ुरबानी के लिए एक बकरा जबकि भस्म होनेवाली क़ुरबानी के लिए एक बेऐब यकसाला बछड़ा और एक बेऐब यकसाला भेड़ का बच्चा पेश करो। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","साथ ही सलामती की क़ुरबानी के लिए एक बैल और एक मेंढा चुनो। तेल के साथ मिलाई हुई ग़ल्ला की नज़र भी लेकर सब कुछ रब को पेश करो। क्योंकि आज ही रब तुम पर ज़ाहिर होगा।” ");
INSERT INTO urdgvh_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","इसराईली मूसा की मतलूबा तमाम चीज़ें मुलाक़ात के ख़ैमे के सामने ले आए। पूरी जमात क़रीब आकर रब के सामने खड़ी हो गई। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","मूसा ने उनसे कहा, “तुम्हें वही करना है जिसका हुक्म रब ने तुम्हें दिया है। क्योंकि आज ही रब का जलाल तुम पर ज़ाहिर होगा।” ");
INSERT INTO urdgvh_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","फिर उसने हारून से कहा, “क़ुरबानगाह के पास जाकर गुनाह की क़ुरबानी और भस्म होनेवाली क़ुरबानी चढ़ाकर अपना और अपनी क़ौम का कफ़्फ़ारा देना। रब के हुक्म के मुताबिक़ क़ौम के लिए भी क़ुरबानी पेश करना ताकि उसका कफ़्फ़ारा दिया जाए।” ");
INSERT INTO urdgvh_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","हारून क़ुरबानगाह के पास आया। उसने बछड़े को ज़बह किया। यह उसके लिए गुनाह की क़ुरबानी था। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","उसके बेटे बछड़े का ख़ून उसके पास ले आए। उसने अपनी उँगली ख़ून में डुबोकर उसे क़ुरबानगाह के सींगों पर लगाया। बाक़ी ख़ून को उसने क़ुरबानगाह के पाए पर उंडेल दिया। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","फिर उसने उस की चरबी, गुरदों और जोड़कलेजी को क़ुरबानगाह पर जला दिया। जैसे रब ने मूसा को हुक्म दिया था वैसे ही हारून ने किया। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","बछड़े का गोश्त और खाल उसने ख़ैमागाह के बाहर ले जाकर जला दी। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","इसके बाद हारून ने भस्म होनेवाली क़ुरबानी को ज़बह किया। उसके बेटों ने उसे उसका ख़ून दिया, और उसने उसे क़ुरबानगाह के चार पहलुओं पर छिड़क दिया। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","उन्होंने उसे क़ुरबानी के मुख़्तलिफ़ टुकड़े सर समेत दिए, और उसने उन्हें क़ुरबानगाह पर जला दिया। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","फिर उसने उस की अंतड़ियाँ और पिंडलियाँ धोकर भस्म होनेवाली क़ुरबानी की बाक़ी चीज़ों पर रखकर जला दीं। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","अब हारून ने क़ौम के लिए क़ुरबानी चढ़ाई। उसने गुनाह की क़ुरबानी के लिए बकरा ज़बह करके उसे पहली क़ुरबानी की तरह चढ़ाया। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","उसने भस्म होनेवाली क़ुरबानी भी क़वायद के मुताबिक़ चढ़ाई। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","उसने ग़ल्ला की नज़र पेश की और उसमें से मुट्ठी-भर क़ुरबानगाह पर जला दिया। यह ग़ल्ला की उस नज़र के अलावा थी जो सुबह को भस्म होनेवाली क़ुरबानी के साथ चढ़ाई गई थी। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","फिर उसने सलामती की क़ुरबानी के लिए बैल और मेंढे को ज़बह किया। यह भी क़ौम के लिए थी। उसके बेटों ने उसे जानवरों का ख़ून दिया, और उसने उसे क़ुरबानगाह के चार पहलुओं पर छिड़क दिया। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","लेकिन उन्होंने बैल और मेंढे को चरबी, दुम, अंतड़ियों पर की चरबी और जोड़कलेजी निकालकर ");
INSERT INTO urdgvh_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","सीने के टुकड़ों पर रख दिया। हारून ने चरबी का हिस्सा क़ुरबानगाह पर जला दिया। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","सीने के टुकड़े और दहनी रानें उसने हिलानेवाली क़ुरबानी के तौर पर रब के सामने हिलाईं। उसने सब कुछ मूसा के हुक्म के मुताबिक़ ही किया। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","तमाम क़ुरबानियाँ पेश करने के बाद हारून ने अपने हाथ उठाकर क़ौम को बरकत दी। फिर वह क़ुरबानगाह से उतरकर ");
INSERT INTO urdgvh_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","मूसा के साथ मुलाक़ात के ख़ैमे में दाख़िल हुआ। जब दोनों बाहर आए तो उन्होंने क़ौम को बरकत दी। तब रब का जलाल पूरी क़ौम पर ज़ाहिर हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","रब के हुज़ूर से आग निकलकर क़ुरबानगाह पर उतरी और भस्म होनेवाली क़ुरबानी और चरबी के टुकड़े भस्म कर दिए। यह देखकर लोग ख़ुशी के नारे मारने लगे और मुँह के बल गिर गए। ");
INSERT INTO urdgvh_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","हारून के बेटे नदब और अबीहू ने अपने अपने बख़ूरदान लेकर उनमें जलते हुए कोयले डाले। उन पर बख़ूर डालकर वह रब के सामने आए ताकि उसे पेश करें। लेकिन यह आग नाजायज़ थी। रब ने यह पेश करने का हुक्म नहीं दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","अचानक रब के हुज़ूर से आग निकली जिसने उन्हें भस्म कर दिया। वहीं रब के सामने वह मर गए। ");
INSERT INTO urdgvh_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","मूसा ने हारून से कहा, “अब वही हुआ है जो रब ने फ़रमाया था कि जो मेरे क़रीब हैं उनसे मैं अपनी क़ुद्दूसियत ज़ाहिर करूँगा, मैं तमाम क़ौम के सामने ही अपने जलाल का इज़हार करूँगा।” हारून ख़ामोश रहा। ");
INSERT INTO urdgvh_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","मूसा ने हारून के चचा उज़्ज़ियेल के बेटों मीसाएल और इल्सफ़न को बुलाकर कहा, “इधर आओ और अपने रिश्तेदारों को मक़दिस के सामने से उठाकर ख़ैमागाह के बाहर ले जाओ।” ");
INSERT INTO urdgvh_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","वह आए और मूसा के हुक्म के ऐन मुताबिक़ उन्हें उनके ज़ेरजामों समेत उठाकर ख़ैमागाह के बाहर ले गए। ");
INSERT INTO urdgvh_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","मूसा ने हारून और उसके दीगर बेटों इलियज़र और इतमर से कहा, “मातम का इज़हार न करो। न अपने बाल बिखरने दो, न अपने कपड़े फाड़ो। वरना तुम मर जाओगे और रब पूरी जमात से नाराज़ हो जाएगा। लेकिन तुम्हारे रिश्तेदार और बाक़ी तमाम इसराईली ज़रूर इनका मातम करें जिनको रब ने आग से हलाक कर दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","मुलाक़ात के ख़ैमे के दरवाज़े के बाहर न निकलो वरना तुम मर जाओगे, क्योंकि तुम्हें रब के तेल से मसह किया गया है।” चुनाँचे उन्होंने ऐसा ही किया। ");
INSERT INTO urdgvh_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","रब ने हारून से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“जब भी तुझे या तेरे बेटों को मुलाक़ात के ख़ैमे में दाख़िल होना है तो मै या कोई और नशा-आवर चीज़ पीना मना है, वरना तुम मर जाओगे। यह उसूल आनेवाली नसलों के लिए भी अबद तक अनमिट है। ");
INSERT INTO urdgvh_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","यह भी लाज़िम है कि तुम मुक़द्दस और ग़ैरमुक़द्दस चीज़ों में, पाक और नापाक चीज़ों में इम्तियाज़ करो। ");
INSERT INTO urdgvh_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","तुम्हें इसराईलियों को तमाम पाबंदियाँ सिखानी हैं जो मैंने तुम्हें मूसा की मारिफ़त बताई हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","मूसा ने हारून और उसके बचे हुए बेटों इलियज़र और इतमर से कहा, “ग़ल्ला की नज़र का जो हिस्सा रब के सामने जलाया नहीं जाता उसे अपने लिए लेकर बेख़मीरी रोटी पकाना और क़ुरबानगाह के पास ही खाना। क्योंकि वह निहायत मुक़द्दस है। ");
INSERT INTO urdgvh_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","उसे मुक़द्दस जगह पर खाना, क्योंकि वह रब की जलनेवाली क़ुरबानियों में से तुम्हारे और तुम्हारे बेटों का हिस्सा है। क्योंकि मुझे इसका हुक्म दिया गया है। ");
INSERT INTO urdgvh_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","जो सीना हिलानेवाली क़ुरबानी और दहनी रान उठानेवाली क़ुरबानी के तौर पर पेश की गई है, वह तुम और तुम्हारे बेटे-बेटियाँ खा सकते हैं। उन्हें मुक़द्दस जगह पर खाना है। इसराईलियों की सलामती की क़ुरबानियों में से यह टुकड़े तुम्हारा हिस्सा हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","लेकिन पहले इमाम रान और सीने को जलनेवाली क़ुरबानियों की चरबी के साथ पेश करें। वह उन्हें हिलानेवाली क़ुरबानी के तौर पर रब के सामने हिलाएँ। रब फ़रमाता है कि यह टुकड़े अबद तक तुम्हारे और तुम्हारे बेटों का हिस्सा हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","मूसा ने दरियाफ़्त किया कि उस बकरे के गोश्त का क्या हुआ जो गुनाह की क़ुरबानी के तौर पर चढ़ाया गया था। उसे पता चला कि वह भी जल गया था। यह सुनकर उसे हारून के बेटों इलियज़र और इतमर पर ग़ुस्सा आया। उसने पूछा, ");
INSERT INTO urdgvh_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“तुमने गुनाह की क़ुरबानी का गोश्त क्यों नहीं खाया? तुम्हें उसे मुक़द्दस जगह पर खाना था। यह एक निहायत मुक़द्दस हिस्सा है जो रब ने तुम्हें दिया ताकि तुम जमात का क़ुसूर दूर करके रब के सामने लोगों का कफ़्फ़ारा दो। ");
INSERT INTO urdgvh_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","चूँकि इस बकरे का ख़ून मक़दिस में न लाया गया इसलिए तुम्हें उसका गोश्त मक़दिस में खाना था जिस तरह मैंने तुम्हें हुक्म दिया था।” ");
INSERT INTO urdgvh_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","हारून ने मूसा को जवाब देकर कहा, “देखें, आज लोगों ने अपने लिए गुनाह की क़ुरबानी और भस्म होनेवाली क़ुरबानी रब को पेश की है जबकि मुझ पर यह आफ़त गुज़री है। अगर मैं आज गुनाह की क़ुरबानी से खाता तो क्या यह रब को अच्छा लगता?” ");
INSERT INTO urdgvh_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","यह बात मूसा को अच्छी लगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","रब ने मूसा और हारून से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“इसराईलियों को बताना कि तुम्हें ज़मीन पर रहनेवाले जानवरों में से ज़ैल के जानवरों को खाने की इजाज़त है : ");
INSERT INTO urdgvh_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","जिनके खुर या पाँव बिलकुल चिरे हुए हैं और जो जुगाली करते हैं उन्हें खाने की इजाज़त है। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","ऊँट, बिज्जू या ख़रगोश खाना मना है। वह तुम्हारे लिए नापाक हैं, क्योंकि वह जुगाली तो करते हैं लेकिन उनके खुर या पाँव चिरे हुए नहीं हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","सुअर न खाना। वह तुम्हारे लिए नापाक है, क्योंकि उसके खुर तो चिरे हुए हैं लेकिन वह जुगाली नहीं करता। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","न उनका गोश्त खाना, न उनकी लाशों को छूना। वह तुम्हारे लिए नापाक हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","समुंदरी और दरियाई जानवर खाने के लिए जायज़ हैं अगर उनके पर और छिलके हों। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","लेकिन जिनके पर या छिलके नहीं हैं वह सब तुम्हारे लिए मकरूह हैं, ख़ाह वह बड़ी तादाद में मिलकर रहते हैं या नहीं। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","इसलिए उनका गोश्त खाना मना है, और उनकी लाशों से भी घिन खाना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","पानी में रहनेवाले तमाम जानवर जिनके पर या छिलके न हों तुम्हारे लिए मकरूह हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","ज़ैल के परिंदे तुम्हारे लिए क़ाबिले-घिन हों। इन्हें खाना मना है, क्योंकि वह मकरूह हैं : उक़ाब, दढ़ियल गिद्ध, काला गिद्ध, ");
INSERT INTO urdgvh_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","लाल चील, हर क़िस्म की काली चील, ");
INSERT INTO urdgvh_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","हर क़िस्म का कौवा, ");
INSERT INTO urdgvh_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","उक़ाबी उल्लू, छोटे कानवाला उल्लू, बड़े कानवाला उल्लू, हर क़िस्म का बाज़, ");
INSERT INTO urdgvh_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","छोटा उल्लू, क़ूक़, चिंघाड़नेवाला उल्लू, ");
INSERT INTO urdgvh_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","सफ़ेद उल्लू, दश्ती उल्लू, मिसरी गिद्ध, ");
INSERT INTO urdgvh_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","लक़लक़, हर क़िस्म का बूतीमार, हुदहुद और चमगादड़। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","तमाम पर रखनेवाले कीड़े जो चार पाँवों पर चलते हैं तुम्हारे लिए मकरूह हैं, ");
INSERT INTO urdgvh_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","सिवाए उनके जिनकी टाँगों के दो हिस्से हैं और जो फुदकते हैं। उनको तुम खा सकते हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","इस नाते से तुम मुख़्तलिफ़ क़िस्म के टिड्डे खा सकते हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","बाक़ी सब पर रखनेवाले कीड़े जो चार पाँवों पर चलते हैं तुम्हारे लिए मकरूह हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","28","जो भी ज़ैल के जानवरों की लाशें छुए वह शाम तक नापाक रहेगा : (अलिफ़) खुर रखनेवाले तमाम जानवर सिवाए उनके जिनके खुर या पाँव पूरे तौर पर चिरे हुए हैं और जो जुगाली करते हैं, (बे) तमाम जानवर जो अपने चार पंजों पर चलते हैं। यह जानवर तुम्हारे लिए नापाक हैं, और जो भी उनकी लाशें उठाए या छुए लाज़िम है कि वह अपने कपड़े धो ले। इसके बावुजूद भी वह शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","ज़मीन पर रेंगनेवाले जानवरों में से छछूँदर, मुख़्तलिफ़ क़िस्म के चूहे और मुख़्तलिफ़ क़िस्म की छिपकलियाँ तुम्हारे लिए नापाक हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","जो भी उन्हें और उनकी लाशें छू लेता है वह शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","अगर उनमें से किसी की लाश किसी चीज़ पर गिर पड़े तो वह भी नापाक हो जाएगी। इससे कोई फ़रक़ नहीं पड़ता कि वह लकड़ी, कपड़े, चमड़े या टाट की बनी हो, न इससे कोई फ़रक़ पड़ता है कि वह किस काम के लिए इस्तेमाल की जाती है। उसे हर सूरत में पानी में डुबोना है। तो भी वह शाम तक नापाक रहेगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","अगर ऐसी लाश मिट्टी के बरतन में गिर जाए तो जो कुछ भी उसमें है नापाक हो जाएगा और तुम्हें उस बरतन को तोड़ना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","हर खानेवाली चीज़ जिस पर ऐसे बरतन का पानी डाला गया है नापाक है। इसी तरह उस बरतन से निकली हुई हर पीनेवाली चीज़ नापाक है। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","जिस पर भी ऐसी लाश गिर पड़े वह नापाक हो जाता है। अगर वह तनूर या चूल्हे पर गिर पड़े तो उनको तोड़ देना है। वह नापाक हैं और तुम्हारे लिए नापाक रहेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","लेकिन जिस चश्मे या हौज़ में ऐसी लाश गिरे वह पाक रहता है। सिर्फ़ वह जो लाश को छू लेता है नापाक हो जाता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","अगर ऐसी लाश बीजों पर गिर पड़े जिनको अभी बोना है तो वह पाक रहते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","लेकिन अगर बीजों पर पानी डाला गया हो और फिर लाश उन पर गिर पड़े तो वह नापाक हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","अगर ऐसा जानवर जिसे खाने की इजाज़त है मर जाए तो जो भी उस की लाश छुए शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","जो उसमें से कुछ खाए या उसे उठाकर ले जाए उसे अपने कपड़ों को धोना है। तो भी वह शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","हर जानवर जो ज़मीन पर रेंगता है क़ाबिले-घिन है। उसे खाना मना है, ");
INSERT INTO urdgvh_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","चाहे वह अपने पेट पर चाहे चार या इससे ज़ायद पाँवों पर चलता हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","इन तमाम रेंगनेवालों से अपने आपको घिन का बाइस और नापाक न बनाना, ");
INSERT INTO urdgvh_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","क्योंकि मैं रब तुम्हारा ख़ुदा हूँ। लाज़िम है कि तुम अपने आपको मख़सूसो-मुक़द्दस रखो, क्योंकि मैं क़ुद्दूस हूँ। अपने आपको ज़मीन पर रेंगनेवाले तमाम जानवरों से नापाक न बनाना। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","मैं रब हूँ। मैं तुम्हें मिसर से निकाल लाया हूँ ताकि तुम्हारा ख़ुदा बनूँ। लिहाज़ा मुक़द्दस रहो, क्योंकि मैं क़ुद्दूस हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","ज़मीन पर चलनेवाले जानवरों, परिंदों, आबी जानवरों और ज़मीन पर रेंगनेवाले जानवरों के बारे में शरअ यही है। ");
INSERT INTO urdgvh_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","लाज़िम है कि तुम नापाक और पाक में इम्तियाज़ करो, ऐसे जानवरों में जो खाने के लिए जायज़ हैं और ऐसों में जो नाजायज़ हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“इसराईलियों को बता कि जब किसी औरत के लड़का पैदा हो तो वह माहवारी के ऐयाम की तरह सात दिन तक नापाक रहेगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","आठवें दिन लड़के का ख़तना करवाना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","फिर माँ मज़ीद 33 दिन इंतज़ार करे। इसके बाद उस की वह नापाकी दूर हो जाएगी जो ख़ून बहने से पैदा हुई है। इस दौरान वह कोई मख़सूस और मुक़द्दस चीज़ न छुए, न मक़दिस के पास जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","अगर उसके लड़की पैदा हो जाए तो वह माहवारी के ऐयाम की तरह नापाक है। यह नापाकी 14 दिन तक रहेगी। फिर वह मज़ीद 66 दिन इंतज़ार करे। इसके बाद उस की वह नापाकी दूर हो जाएगी जो ख़ून बहने से पैदा हुई है। ");
INSERT INTO urdgvh_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","जब लड़के या लड़की के सिलसिले में यह दिन गुज़र जाएँ तो वह मुलाक़ात के ख़ैमे के दरवाज़े पर इमाम को ज़ैल की चीज़ें दे : भस्म होनेवाली क़ुरबानी के लिए एक यकसाला भेड़ का बच्चा और गुनाह की क़ुरबानी के लिए एक जवान कबूतर या क़ुम्री। ");
INSERT INTO urdgvh_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","इमाम यह जानवर रब को पेश करके उसका कफ़्फ़ारा दे। फिर ख़ून बहने के बाइस पैदा होनेवाली नापाकी दूर हो जाएगी। उसूल एक ही है, चाहे लड़का हो या लड़की। ");
INSERT INTO urdgvh_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","अगर वह ग़ुरबत के बाइस भेड़ का बच्चा न दे सके तो फिर वह दो क़ुम्रियाँ या दो जवान कबूतर ले आए, एक भस्म होनेवाली क़ुरबानी के लिए और दूसरा गुनाह की क़ुरबानी के लिए। यों इमाम उसका कफ़्फ़ारा दे और वह पाक हो जाएगी।” ");
INSERT INTO urdgvh_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","रब ने मूसा और हारून से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“अगर किसी की जिल्द में सूजन या पपड़ी या सफ़ेद दाग़ हो और ख़तरा है कि वबाई जिल्दी बीमारी हो तो उसे इमामों यानी हारून या उसके बेटों के पास ले आना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","इमाम उस जगह का मुआयना करे। अगर उसके बाल सफ़ेद हो गए हों और वह जिल्द में धँसी हुई हो तो वबाई बीमारी है। जब इमाम को यह मालूम हो तो वह उसे नापाक क़रार दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","लेकिन हो सकता है कि जिल्द की जगह सफ़ेद तो है लेकिन जिल्द में धँसी हुई नहीं है, न उसके बाल सफ़ेद हुए हैं। इस सूरत में इमाम उस शख़्स को सात दिन के लिए अलहदगी में रखे। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","सातवें दिन इमाम दुबारा उसका मुआयना करे। अगर वह देखे कि मुतअस्सिरा जगह वैसी ही है और फैली नहीं तो वह उसे मज़ीद सात दिन अलहदगी में रखे। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","सातवें दिन वह एक और मरतबा उसका मुआयना करे। अगर उस जगह का रंग दुबारा सेहतमंद जिल्द के रंग की मानिंद हो रहा हो और फैली न हो तो वह उसे पाक क़रार दे। इसका मतलब है कि यह मरज़ आम पपड़ी से ज़्यादा नहीं है। मरीज़ अपने कपड़े धो ले तो वह पाक हो जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","लेकिन अगर इसके बाद मुतअस्सिरा जगह फैलने लगे तो वह दुबारा अपने आपको इमाम को दिखाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","इमाम उसका मुआयना करे। अगर जगह वाक़ई फैल गई हो तो इमाम उसे नापाक क़रार दे, क्योंकि यह वबाई जिल्दी मरज़ है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","अगर किसी के जिस्म पर वबाई जिल्दी मरज़ नज़र आए तो उसे इमाम के पास लाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","इमाम उसका मुआयना करे। अगर मुतअस्सिरा जिल्द में सफ़ेद सूजन हो, उसके बाल भी सफ़ेद हो गए हों, और उसमें कच्चा गोश्त मौजूद हो ");
INSERT INTO urdgvh_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","तो इसका मतलब है कि वबाई जिल्दी बीमारी पुरानी है। इमाम उस शख़्स को सात दिन के लिए अलहदगी में रखकर इंतज़ार न करे बल्कि उसे फ़ौरन नापाक क़रार दे, क्योंकि यह उस की नापाकी का सबूत है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","लेकिन अगर बीमारी जल्दी से फैल गई हो, यहाँ तक कि सर से लेकर पाँव तक पूरी जिल्द मुतअस्सिर हुई हो ");
INSERT INTO urdgvh_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","तो इमाम यह देखकर मरीज़ को पाक क़रार दे। चूँकि पूरी जिल्द सफ़ेद हो गई है इसलिए वह पाक है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","लेकिन जब भी कहीं कच्चा गोश्त नज़र आए उस वक़्त वह नापाक हो जाता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","इमाम यह देखकर मरीज़ को नापाक क़रार दे। कच्चा गोश्त हर सूरत में नापाक है, क्योंकि इसका मतलब है कि वबाई जिल्दी बीमारी लग गई है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","अगर कच्चे गोश्त का यह ज़ख़म भर जाए और मुतअस्सिरा जगह की जिल्द सफ़ेद हो जाए तो मरीज़ इमाम के पास जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","अगर इमाम देखे कि वाक़ई ऐसा ही हुआ है और मुतअस्सिरा जिल्द सफ़ेद हो गई है तो वह उसे पाक क़रार दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","अगर किसी की जिल्द पर फोड़ा हो लेकिन वह ठीक हो जाए ");
INSERT INTO urdgvh_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","और उस की जगह सफ़ेद सूजन या सुरख़ी-मायल सफ़ेद दाग़ नज़र आए तो मरीज़ अपने आपको इमाम को दिखाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","अगर वह उसका मुआयना करके देखे कि मुतअस्सिरा जगह जिल्द के अंदर धँसी हुई है और उसके बाल सफ़ेद हो गए हैं तो वह मरीज़ को नापाक क़रार दे। क्योंकि इसका मतलब है कि जहाँ पहले फोड़ा था वहाँ वबाई जिल्दी बीमारी पैदा हो गई है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","लेकिन अगर इमाम देखे कि मुतअस्सिरा जगह के बाल सफ़ेद नहीं हैं, वह जिल्द में धँसी हुई नज़र नहीं आती और उसका रंग दुबारा सेहतमंद जिल्द की मानिंद हो रहा है तो वह उसे सात दिन के लिए अलहदगी में रखे। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","अगर इस दौरान बीमारी मज़ीद फैल जाए तो इमाम मरीज़ को नापाक क़रार दे, क्योंकि इसका मतलब है कि वबाई जिल्दी बीमारी लग गई है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","लेकिन अगर दाग़ न फैले तो इसका मतलब है कि यह सिर्फ़ उस भरे हुए ज़ख़म का निशान है जो फोड़े से पैदा हुआ था। इमाम मरीज़ को पाक क़रार दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","अगर किसी की जिल्द पर जलने का ज़ख़म लग जाए और मुतअस्सिरा जगह पर सुरख़ी-मायल सफ़ेद दाग़ या सफ़ेद दाग़ पैदा हो जाए ");
INSERT INTO urdgvh_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","तो इमाम मुतअस्सिरा जगह का मुआयना करे। अगर मालूम हो जाए कि मुतअस्सिरा जगह के बाल सफ़ेद हो गए हैं और वह जिल्द में धँसी हुई है तो इसका मतलब है कि चोट की जगह पर वबाई जिल्दी मरज़ लग गया है। इमाम उसे नापाक क़रार दे, क्योंकि वबाई जिल्दी बीमारी लग गई है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","लेकिन अगर इमाम ने मालूम किया है कि दाग़ में बाल सफ़ेद नहीं हैं, वह जिल्द में धँसा हुआ नज़र नहीं आता और उसका रंग सेहतमंद जिल्द की मानिंद हो रहा है तो वह मरीज़ को सात दिन तक अलहदगी में रखे। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","अगर वह सातवें दिन मालूम करे कि मुतअस्सिरा जगह फैल गई है तो वह उसे नापाक क़रार दे। क्योंकि इसका मतलब है कि वबाई जिल्दी बीमारी लग गई है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","लेकिन अगर दाग़ फैला हुआ नज़र नहीं आता और मुतअस्सिरा जिल्द का रंग सेहतमंद जिल्द के रंग की मानिंद हो गया है तो इसका मतलब है कि यह सिर्फ़ उस भरे हुए ज़ख़म का निशान है जो जलने से पैदा हुआ था। इमाम मरीज़ को पाक क़रार दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","अगर किसी के सर या दाढ़ी की जिल्द में निशान नज़र आए ");
INSERT INTO urdgvh_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","तो इमाम मुतअस्सिरा जगह का मुआयना करे। अगर वह धँसी हुई नज़र आए और उसके बाल रंग के लिहाज़ से चमकते हुए सोने की मानिंद और बारीक हों तो इमाम मरीज़ को नापाक क़रार दे। इसका मतलब है कि ऐसी वबाई जिल्दी बीमारी सर या दाढ़ी की जिल्द पर लग गई है जो ख़ारिश पैदा करती है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","लेकिन अगर इमाम ने मालूम किया कि मुतअस्सिरा जगह जिल्द में धँसी हुई नज़र नहीं आती अगरचे उसके बालों का रंग बदल गया है तो वह उसे सात दिन के लिए अलहदगी में रखे। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","सातवें दिन इमाम जिल्द की मुतअस्सिरा जगह का मुआयना करे। अगर वह फैली हुई नज़र नहीं आती और उसके बालों का रंग चमकदार सोने की मानिंद नहीं है, साथ ही वह जगह जिल्द में धँसी हुई भी दिखाई नहीं देती, ");
INSERT INTO urdgvh_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","तो मरीज़ अपने बाल मुँडवाए। सिर्फ़ वह बाल रह जाएँ जो मुतअस्सिरा जगह से निकलते हैं। इमाम मरीज़ को मज़ीद सात दिन अलहदगी में रखे। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","सातवें दिन वह उसका मुआयना करे। अगर मुतअस्सिरा जगह नहीं फैली और वह जिल्द में धँसी हुई नज़र नहीं आती तो इमाम उसे पाक क़रार दे। वह अपने कपड़े धो ले तो वह पाक हो जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","लेकिन अगर इसके बाद जिल्द की मुतअस्सिरा जगह फैलना शुरू हो जाए ");
INSERT INTO urdgvh_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","तो इमाम दुबारा उसका मुआयना करे। अगर वह जगह वाक़ई फैली हुई नज़र आए तो मरीज़ नापाक है, चाहे मुतअस्सिरा जगह के बालों का रंग चमकते सोने की मानिंद हो या न हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","लेकिन अगर उसके ख़याल में मुतअस्सिरा जगह फैली हुई नज़र नहीं आती बल्कि उसमें से काले रंग के बाल निकल रहे हैं तो इसका मतलब है कि मरीज़ की सेहत बहाल हो गई है। इमाम उसे पाक क़रार दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","अगर किसी मर्द या औरत की जिल्द पर सफ़ेद दाग़ पैदा हो जाएँ ");
INSERT INTO urdgvh_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","तो इमाम उनका मुआयना करे। अगर उनका सफ़ेद रंग हलका-सा हो तो यह सिर्फ़ बेज़रर पपड़ी है। मरीज़ पाक है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","अगर किसी मर्द का सर माथे की तरफ़ या पीछे की तरफ़ गंजा है तो वह पाक है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","लेकिन अगर उस जगह जहाँ वह गंजा है सुरख़ी-मायल सफ़ेद दाग़ हो तो इसका मतलब है कि वहाँ वबाई जिल्दी बीमारी लग गई है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","इमाम उसका मुआयना करे। अगर गंजी जगह पर सुरख़ी-मायल सफ़ेद सूजन हो जो वबाई जिल्दी बीमारी की मानिंद नज़र आए ");
INSERT INTO urdgvh_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","तो मरीज़ को वबाई जिल्दी बीमारी लग गई है। इमाम उसे नापाक क़रार दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","वबाई जिल्दी बीमारी का मरीज़ फटे कपड़े पहने। उसके बाल बिखरे रहें। वह अपनी मूँछों को किसी कपड़े से छुपाए और पुकारता रहे, ‘नापाक, नापाक।’ ");
INSERT INTO urdgvh_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","जिस वक़्त तक वबाई जिल्दी बीमारी लगी रहे वह नापाक है। वह इस दौरान ख़ैमागाह के बाहर जाकर तनहाई में रहे। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","हो सकता है कि ऊन या कतान के किसी लिबास पर फफूँदी लग गई है, ");
INSERT INTO urdgvh_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","या कि फफूँदी ऊन या कतान के किसी कपड़े के टुकड़े या किसी चमड़े या चमड़े की किसी चीज़ पर लग गई है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","अगर फफूँदी का रंग हरा या लाल-सा हो तो वह फैलनेवाली फफूँदी है, और लाज़िम है कि उसे इमाम को दिखाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","इमाम उसका मुआयना करके उसे सात दिन के लिए अलहदगी में रखे। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","सातवें दिन वह दुबारा उसका मुआयना करे। अगर फफूँदी फैल गई हो तो इसका मतलब है कि वह नुक़सानदेह है। मुतअस्सिरा चीज़ नापाक है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","इमाम उसे जला दे, क्योंकि यह फफूँदी नुक़सानदेह है। लाज़िम है कि उसे जला दिया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","लेकिन अगर इन सात दिनों के बाद फफूँदी फैली हुई नज़र नहीं आती ");
INSERT INTO urdgvh_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","तो इमाम हुक्म दे कि मुतअस्सिरा चीज़ को धुलवाया जाए। फिर वह उसे मज़ीद सात दिन के लिए अलहदगी में रखे। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","इसके बाद वह दुबारा उसका मुआयना करे। अगर वह मालूम करे कि फफूँदी तो फैली हुई नज़र नहीं आती लेकिन उसका रंग वैसे का वैसा है तो वह नापाक है। उसे जला देना, चाहे फफूँदी मुतअस्सिरा चीज़ के सामनेवाले हिस्से या पिछले हिस्से में लगी हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","लेकिन अगर मालूम हो जाए कि फफूँदी का रंग माँद पड़ गया है तो इमाम कपड़े या चमड़े में से मुतअस्सिरा जगह फाड़कर निकाल दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","तो भी हो सकता है कि फफूँदी दुबारा उसी कपड़े या चमड़े पर नज़र आए। इसका मतलब है कि वह फैल रही है और उसे जला देना लाज़िम है। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","लेकिन अगर फफूँदी धोने के बाद ग़ायब हो जाए तो उसे एक और दफ़ा धोना है। फिर मुतअस्सिरा चीज़ पाक होगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","इसी तरह फफूँदी से निपटना है, चाहे वह ऊन या कतान के किसी लिबास को लग गई हो, चाहे ऊन या कतान के किसी टुकड़े या चमड़े की किसी चीज़ को लग गई हो। इन्हीं उसूलों के तहत फ़ैसला करना है कि मुतअस्सिरा चीज़ पाक है या नापाक।” ");
INSERT INTO urdgvh_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“अगर कोई शख़्स जिल्दी बीमारी से शफ़ा पाए और उसे पाक-साफ़ कराना है तो उसे इमाम के पास लाया जाए ");
INSERT INTO urdgvh_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","जो ख़ैमागाह के बाहर जाकर उसका मुआयना करे। अगर वह देखे कि मरीज़ की सेहत वाक़ई बहाल हो गई है ");
INSERT INTO urdgvh_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","तो इमाम उसके लिए दो ज़िंदा और पाक परिंदे, देवदार की लकड़ी, क़िरमिज़ी रंग का धागा और ज़ूफ़ा मँगवाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","इमाम के हुक्म पर परिंदों में से एक को ताज़ा पानी से भरे हुए मिट्टी के बरतन के ऊपर ज़बह किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","इमाम ज़िंदा परिंदे को देवदार की लकड़ी, क़िरमिज़ी रंग के धागे और ज़ूफ़ा के साथ ज़बह किए गए परिंदे के उस ख़ून में डुबो दे जो मिट्टी के बरतन के पानी में आ गया है। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","वह पानी से मिलाया हुआ ख़ून सात बार पाक होनेवाले शख़्स पर छिड़ककर उसे पाक क़रार दे, फिर ज़िंदा परिंदे को खुले मैदान में छोड़ दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","जो अपने आपको पाक-साफ़ करा रहा है वह अपने कपड़े धोए, अपने तमाम बाल मुँडवाए और नहा ले। इसके बाद वह पाक है। अब वह ख़ैमागाह में दाख़िल हो सकता है अगरचे वह मज़ीद सात दिन अपने डेरे में नहीं जा सकता। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","सातवें दिन वह दुबारा अपने सर के बाल, अपनी दाढ़ी, अपने अबरू और बाक़ी तमाम बाल मुँडवाए। वह अपने कपड़े धोए और नहा ले। तब वह पाक है। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","आठवें दिन वह दो भेड़ के नर बच्चे और एक यकसाला भेड़ चुन ले जो बेऐब हों। साथ ही वह ग़ल्ला की नज़र के लिए तेल के साथ मिलाया गया साढ़े 4 किलोग्राम बेहतरीन मैदा और 300 मिलीलिटर तेल ले। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","फिर जिस इमाम ने उसे पाक क़रार दिया वह उसे इन क़ुरबानियों समेत मुलाक़ात के ख़ैमे के दरवाज़े पर रब को पेश करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","भेड़ का एक नर बच्चा और 300 मिलीलिटर तेल क़ुसूर की क़ुरबानी के लिए है। इमाम उन्हें हिलानेवाली क़ुरबानी के तौर पर रब के सामने हिलाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","फिर वह भेड़ के इस बच्चे को ख़ैमे के दरवाज़े पर ज़बह करे जहाँ गुनाह की क़ुरबानियाँ और भस्म होनेवाली क़ुरबानियाँ ज़बह की जाती हैं। गुनाह की क़ुरबानियों की तरह क़ुसूर की यह क़ुरबानी इमाम का हिस्सा है और निहायत मुक़द्दस है। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","इमाम ख़ून में से कुछ लेकर पाक होनेवाले के दहने कान की लौ पर और उसके दहने हाथ और दहने पाँव के अंगूठों पर लगाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","अब वह 300 मिलीलिटर तेल में से कुछ लेकर अपने बाएँ हाथ की हथेली पर डाले। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","अपने दहने हाथ के अंगूठे के साथवाली उँगली इस तेल में डुबोकर वह उसे सात बार रब के सामने छिड़के। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","वह अपनी हथेली पर के तेल में से कुछ और लेकर पाक होनेवाले के दहने कान की लौ पर और उसके दहने हाथ और दहने पाँव के अंगूठों पर लगा दे यानी उन जगहों पर जहाँ वह क़ुसूर की क़ुरबानी का ख़ून लगा चुका है। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","इमाम अपनी हथेली पर का बाक़ी तेल पाक होनेवाले के सर पर डालकर रब के सामने उसका कफ़्फ़ारा दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","इसके बाद इमाम गुनाह की क़ुरबानी चढ़ाकर पाक होनेवाले का कफ़्फ़ारा दे। आख़िर में वह भस्म होनेवाली क़ुरबानी का जानवर ज़बह करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","वह उसे ग़ल्ला की नज़र के साथ क़ुरबानगाह पर चढ़ाकर उसका कफ़्फ़ारा दे। तब वह पाक है। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","अगर शफ़ायाब शख़्स ग़ुरबत के बाइस यह क़ुरबानियाँ नहीं चढ़ा सकता तो फिर वह क़ुसूर की क़ुरबानी के लिए भेड़ का सिर्फ़ एक नर बच्चा ले आए। काफ़ी है कि कफ़्फ़ारा देने के लिए यही रब के सामने हिलाया जाए। साथ साथ ग़ल्ला की नज़र के लिए डेढ़ किलोग्राम बेहतरीन मैदा तेल के साथ मिलाकर पेश किया जाए और 300 मिलीलिटर तेल। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","इसके अलावा वह दो क़ुम्रियाँ या दो जवान कबूतर पेश करे, एक को गुनाह की क़ुरबानी के लिए और दूसरे को भस्म होनेवाली क़ुरबानी के लिए। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","आठवें दिन वह उन्हें मुलाक़ात के ख़ैमे के दरवाज़े पर इमाम के पास और रब के सामने ले आए ताकि वह पाक-साफ़ हो जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","इमाम भेड़ के बच्चे को 300 मिलीलिटर तेल समेत लेकर हिलानेवाली क़ुरबानी के तौर पर रब के सामने हिलाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","वह क़ुसूर की क़ुरबानी के लिए भेड़ के बच्चे को ज़बह करे और उसके ख़ून में से कुछ लेकर पाक होनेवाले के दहने कान की लौ पर और उसके दहने हाथ और दहने पाँव के अंगूठों पर लगाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","अब वह 300 मिलीलिटर तेल में से कुछ अपने बाएँ हाथ की हथेली पर डाले ");
INSERT INTO urdgvh_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","और अपने दहने हाथ के अंगूठे के साथवाली उँगली इस तेल में डुबोकर उसे सात बार रब के सामने छिड़क दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","वह अपनी हथेली पर के तेल में से कुछ और लेकर पाक होनेवाले के दहने कान की लौ पर और उसके दहने हाथ और दहने पाँव के अंगूठों पर लगा दे यानी उन जगहों पर जहाँ वह क़ुसूर की क़ुरबानी का ख़ून लगा चुका है। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","अपनी हथेली पर का बाक़ी तेल वह पाक होनेवाले के सर पर डाल दे ताकि रब के सामने उसका कफ़्फ़ारा दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","इसके बाद वह शफ़ायाब शख़्स की गुंजाइश के मुताबिक़ दो क़ुम्रियाँ या दो जवान कबूतर चढ़ाए, ");
INSERT INTO urdgvh_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","एक को गुनाह की क़ुरबानी के लिए और दूसरे को भस्म होनेवाली क़ुरबानी के लिए। साथ ही वह ग़ल्ला की नज़र पेश करे। यों इमाम रब के सामने उसका कफ़्फ़ारा देता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","यह उसूल ऐसे शख़्स के लिए है जो वबाई जिल्दी बीमारी से शफ़ा पा गया है लेकिन अपनी ग़ुरबत के बाइस पाक हो जाने के लिए पूरी क़ुरबानी पेश नहीं कर सकता।” ");
INSERT INTO urdgvh_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","रब ने मूसा और हारून से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“जब तुम मुल्के-कनान में दाख़िल होगे जो मैं तुम्हें दूँगा तो वहाँ ऐसे मकान होंगे जिनमें मैंने फफूँदी फैलने दी है। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ऐसे घर का मालिक जाकर इमाम को बताए कि मैंने अपने घर में फफूँदी जैसी कोई चीज़ देखी है। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","तब इमाम हुक्म दे कि घर का मुआयना करने से पहले घर का पूरा सामान निकाला जाए। वरना अगर घर को नापाक क़रार दिया जाए तो सामान को भी नापाक क़रार दिया जाएगा। इसके बाद इमाम अंदर जाकर मकान का मुआयना करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","वह दीवारों के साथ लगी हुई फफूँदी का मुआयना करे। अगर मुतअस्सिरा जगहें हरी या लाल-सी हों और दीवार के अंदर धँसी हुई नज़र आएँ ");
INSERT INTO urdgvh_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","तो फिर इमाम घर से निकलकर सात दिन के लिए ताला लगाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","सातवें दिन वह वापस आकर मकान का मुआयना करे। अगर फफूँदी फैली हुई नज़र आए ");
INSERT INTO urdgvh_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","तो वह हुक्म दे कि मुतअस्सिरा पत्थरों को निकालकर आबादी के बाहर किसी नापाक जगह पर फेंका जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","नीज़ वह हुक्म दे कि अंदर की दीवारों को कुरेदा जाए और कुरेदी हुई मिट्टी को आबादी के बाहर किसी नापाक जगह पर फेंका जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","फिर लोग नए पत्थर लगाकर घर को नए गारे से पलस्तर करें। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","लेकिन अगर इसके बावुजूद फफूँदी दुबारा पैदा हो जाए ");
INSERT INTO urdgvh_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","तो इमाम आकर दुबारा उसका मुआयना करे। अगर वह देखे कि फफूँदी घर में फैल गई है तो इसका मतलब है कि फफूँदी नुक़सानदेह है, इसलिए घर नापाक है। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","लाज़िम है कि उसे पूरे तौर पर ढा दिया जाए और सब कुछ यानी उसके पत्थर, लकड़ी और पलस्तर को आबादी के बाहर किसी नापाक जगह पर फेंका जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","अगर इमाम ने किसी घर का मुआयना करके ताला लगा दिया है और फिर भी कोई उस घर में दाख़िल हो जाए तो वह शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","जो ऐसे घर में सोए या खाना खाए लाज़िम है कि वह अपने कपड़े धो ले। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","लेकिन अगर घर को नए सिरे से पलस्तर करने के बाद इमाम आकर उसका दुबारा मुआयना करे और देखे कि फफूँदी दुबारा नहीं निकली तो इसका मतलब है कि फफूँदी ख़त्म हो गई है। वह उसे पाक क़रार दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","उसे गुनाह से पाक-साफ़ कराने के लिए वह दो परिंदे, देवदार की लकड़ी, क़िरमिज़ी रंग का धागा और ज़ूफ़ा ले ले। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","वह परिंदों में से एक को ताज़ा पानी से भरे हुए मिट्टी के बरतन के ऊपर ज़बह करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","इसके बाद वह देवदार की लकड़ी, ज़ूफ़ा, क़िरमिज़ी रंग का धागा और ज़िंदा परिंदा लेकर उस ताज़ा पानी में डुबो दे जिसके साथ ज़बह किए हुए परिंदे का ख़ून मिलाया गया है और इस पानी को सात बार घर पर छिड़क दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","इन चीज़ों से वह घर को गुनाह से पाक-साफ़ करता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","आख़िर में वह ज़िंदा परिंदे को आबादी के बाहर खुले मैदान में छोड़ दे। यों वह घर का कफ़्फ़ारा देगा, और वह पाक-साफ़ हो जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","56","लाज़िम है कि हर क़िस्म की वबाई बीमारी से ऐसे निपटो जैसे बयान किया गया है, चाहे वह वबाई जिल्दी बीमारियाँ हों (मसलन ख़ारिश, सूजन, पपड़ी या सफ़ेद दाग़), चाहे कपड़ों या घरों में फफूँदी हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","इन उसूलों के तहत फ़ैसला करना है कि कोई शख़्स या चीज़ पाक है या नापाक।” ");
INSERT INTO urdgvh_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","रब ने मूसा और हारून से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“इसराईलियों को बताना कि अगर किसी मर्द को जरयान का मरज़ हो तो वह ख़ारिज होनेवाले माए के सबब से नापाक है, ");
INSERT INTO urdgvh_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","चाहे माए बहता रहता हो या रुक गया हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","जिस चीज़ पर भी मरीज़ लेटता या बैठता है वह नापाक है। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","6","जो भी उसके लेटने की जगह को छुए या उसके बैठने की जगह पर बैठ जाए वह अपने कपड़े धोकर नहा ले। वह शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","इसी तरह जो भी ऐसे मरीज़ को छुए वह अपने कपड़े धोकर नहा ले। वह शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","अगर मरीज़ किसी पाक शख़्स पर थूके तो यही कुछ करना है और वह शख़्स शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","जब ऐसा मरीज़ किसी जानवर पर सवार होता है तो हर चीज़ जिस पर वह बैठ जाता है नापाक है। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","जो भी ऐसी चीज़ छुए या उसे उठाकर ले जाए वह अपने कपड़े धोकर नहा ले। वह शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","जिस किसी को भी मरीज़ अपने हाथ धोए बग़ैर छुए वह अपने कपड़े धोकर नहा ले। वह शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","मिट्टी का जो बरतन ऐसा मरीज़ छुए उसे तोड़ दिया जाए। लकड़ी का जो बरतन वह छुए उसे ख़ूब धोया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","जिसे इस मरज़ से शफ़ा मिली है वह सात दिन इंतज़ार करे। इसके बाद वह ताज़ा पानी से अपने कपड़े धोकर नहा ले। फिर वह पाक हो जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","आठवें दिन वह दो क़ुम्रियाँ या दो जवान कबूतर लेकर मुलाक़ात के ख़ैमे के दरवाज़े पर रब के सामने इमाम को दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","इमाम उनमें से एक को गुनाह की क़ुरबानी के तौर पर और दूसरे को भस्म होनेवाली क़ुरबानी के तौर पर चढ़ाए। यों वह रब के सामने उसका कफ़्फ़ारा देगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","अगर किसी मर्द का नुतफ़ा ख़ारिज हो जाए तो वह अपने पूरे जिस्म को धो ले। वह शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","हर कपड़ा या चमड़ा जिससे नुतफ़ा लग गया हो उसे धोना है। वह भी शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","अगर मर्द और औरत के हमबिसतर होने पर नुतफ़ा ख़ारिज हो जाए तो लाज़िम है कि दोनों नहा लें। वह शाम तक नापाक रहेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","माहवारी के वक़्त औरत सात दिन तक नापाक है। जो भी उसे छुए वह शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","इस दौरान जिस चीज़ पर भी वह लेटती या बैठती है वह नापाक है। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","जो भी उसके लेटने की जगह को छुए या उसके बैठने की जगह पर बैठ जाए वह अपने कपड़े धोकर नहा ले। वह शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","अगर मर्द औरत से हमबिसतर हो और उसी वक़्त माहवारी के दिन शुरू हो जाएँ तो मर्द ख़ून लगने के बाइस सात दिन तक नापाक रहेगा। जिस चीज़ पर भी वह लेटता है वह नापाक हो जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","अगर किसी औरत को माहवारी के दिन छोड़कर किसी और वक़्त कई दिनों तक ख़ून आए या ख़ून माहवारी के दिनों के बाद भी जारी रहे तो वह माहवारी के दिनों की तरह उस वक़्त तक नापाक रहेगी जब तक ख़ून रुक न जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","जिस चीज़ पर भी वह लेटती या बैठती है वह नापाक है। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","जो भी ऐसी चीज़ को छुए वह अपने कपड़े धोकर नहा ले। वह शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","ख़ून के रुक जाने पर औरत मज़ीद सात दिन इंतज़ार करे। फिर वह पाक होगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","आठवें दिन वह दो क़ुम्रियाँ या दो जवान कबूतर लेकर मुलाक़ात के ख़ैमे के दरवाज़े पर इमाम के पास आए। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","इमाम उनमें से एक को गुनाह की क़ुरबानी के लिए और दूसरे को भस्म होनेवाली क़ुरबानी के लिए चढ़ाए। यों वह रब के सामने उस की नापाकी का कफ़्फ़ारा देगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","लाज़िम है कि इसराईलियों को ऐसी चीज़ों से दूर रखा जाए जिनसे वह नापाक हो जाएँ। वरना मेरा वह मक़दिस जो उनके दरमियान है उनसे नापाक हो जाएगा और वह हलाक हो जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","लाज़िम है कि इस क़िस्म के मामलों से ऐसे निपटो जैसे बयान किया गया है। इसमें वह मर्द शामिल है जो जरयान का मरीज़ है और वह जो नुतफ़ा ख़ारिज होने के बाइस नापाक है। ");
INSERT INTO urdgvh_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","इसमें वह औरत भी शामिल है जिसके माहवारी के ऐयाम हैं और वह मर्द जो नापाक औरत से हमबिसतर हो जाता है।” ");
INSERT INTO urdgvh_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","जब हारून के दो बेटे रब के क़रीब आकर हलाक हुए तो इसके बाद रब मूसा से हमकलाम हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","उसने कहा, “अपने भाई हारून को बताना कि वह सिर्फ़ मुक़र्ररा वक़्त पर परदे के पीछे मुक़द्दसतरीन कमरे में दाख़िल होकर अहद के संदूक़ के ढकने के सामने खड़ा हो जाए, वरना वह मर जाएगा। क्योंकि मैं ख़ुद उस ढकने के ऊपर बादल की सूरत में ज़ाहिर होता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","और जब भी वह दाख़िल हो तो गुनाह की क़ुरबानी के लिए एक जवान बैल और भस्म होनेवाली क़ुरबानी के लिए एक मेंढा पेश करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","पहले वह नहाकर इमाम के कतान के मुक़द्दस कपड़े पहन ले यानी ज़ेरजामा, उसके नीचे पाजामा, फिर कमरबंद और पगड़ी। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","इसराईल की जमात हारून को गुनाह की क़ुरबानी के लिए दो बकरे और भस्म होनेवाली क़ुरबानी के लिए एक मेंढा दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","पहले हारून अपने और अपने घराने के लिए जवान बैल को गुनाह की क़ुरबानी के तौर पर चढ़ाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","फिर वह दोनों बकरों को मुलाक़ात के ख़ैमे के दरवाज़े पर रब के सामने ले आए। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","वहाँ वह क़ुरा डालकर एक को रब के लिए चुने और दूसरे को अज़ाज़ेल के लिए। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","जो बकरा रब के लिए है उसे वह गुनाह की क़ुरबानी के तौर पर पेश करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","दूसरा बकरा जो क़ुरे के ज़रीए अज़ाज़ेल के लिए चुना गया उसे ज़िंदा हालत में रब के सामने खड़ा किया जाए ताकि वह जमात का कफ़्फ़ारा दे। वहाँ से उसे रेगिस्तान में अज़ाज़ेल के पास भेजा जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","लेकिन पहले हारून जवान बैल को गुनाह की क़ुरबानी के तौर पर चढ़ाकर अपना और अपने घराने का कफ़्फ़ारा दे। उसे ज़बह करने के बाद ");
INSERT INTO urdgvh_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","वह बख़ूर की क़ुरबानगाह से जलते हुए कोयलों से भरा हुआ बरतन लेकर अपनी दोनों मुट्ठियाँ बारीक ख़ुशबूदार बख़ूर से भर ले और मुक़द्दसतरीन कमरे में दाख़िल हो जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","वहाँ वह रब के हुज़ूर बख़ूर को जलते हुए कोयलों पर डाल दे। इससे पैदा होनेवाला धुआँ अहद के संदूक़ का ढकना छुपा देगा ताकि हारून मर न जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","अब वह जवान बैल के ख़ून में से कुछ लेकर अपनी उँगली से ढकने के सामनेवाले हिस्से पर छिड़के, फिर कुछ अपनी उँगली से सात बार उसके सामने ज़मीन पर छिड़के। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","इसके बाद वह उस बकरे को ज़बह करे जो क़ौम के लिए गुनाह की क़ुरबानी है। वह उसका ख़ून मुक़द्दसतरीन कमरे में ले आए और उसे बैल के ख़ून की तरह अहद के संदूक़ के ढकने पर और सात बार उसके सामने ज़मीन पर छिड़के। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","यों वह मुक़द्दसतरीन कमरे का कफ़्फ़ारा देगा जो इसराईलियों की नापाकियों और तमाम गुनाहों से मुतअस्सिर होता रहता है। इससे वह मुलाक़ात के पूरे ख़ैमे का भी कफ़्फ़ारा देगा जो ख़ैमागाह के दरमियान होने के बाइस इसराईलियों की नापाकियों से मुतअस्सिर होता रहता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","जितना वक़्त हारून अपना, अपने घराने का और इसराईल की पूरी जमात का कफ़्फ़ारा देने के लिए मुक़द्दसतरीन कमरे में रहेगा इस दौरान किसी दूसरे को मुलाक़ात के ख़ैमे में ठहरने की इजाज़त नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","फिर वह मुक़द्दसतरीन कमरे से निकलकर ख़ैमे में रब के सामने पड़ी क़ुरबानगाह का कफ़्फ़ारा दे। वह बैल और बकरे के ख़ून में से कुछ लेकर उसे क़ुरबानगाह के चारों सींगों पर लगाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","कुछ ख़ून वह अपनी उँगली से सात बार उस पर छिड़क दे। यों वह उसे इसराईलियों की नापाकियों से पाक करके मख़सूसो-मुक़द्दस करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","मुक़द्दसतरीन कमरे, मुलाक़ात के ख़ैमे और क़ुरबानगाह का कफ़्फ़ारा देने के बाद हारून ज़िंदा बकरे को सामने लाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","वह अपने दोनों हाथ उसके सर पर रखे और इसराईलियों के तमाम क़ुसूर यानी उनके तमाम जरायम और गुनाहों का इक़रार करके उन्हें बकरे के सर पर डाल दे। फिर वह उसे रेगिस्तान में भेज दे। इसके लिए वह बकरे को एक आदमी के सुपुर्द करे जिसे यह ज़िम्मादारी दी गई है। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","बकरा अपने आप पर उनका तमाम क़ुसूर उठाकर किसी वीरान जगह में ले जाएगा। वहाँ साथवाला आदमी उसे छोड़ आए। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","इसके बाद हारून मुलाक़ात के ख़ैमे में जाए और कतान के वह कपड़े जो उसने मुक़द्दसतरीन कमरे में दाख़िल होने से पेशतर पहन लिए थे उतारकर वहीं छोड़ दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","वह मुक़द्दस जगह पर नहाकर अपनी ख़िदमत के आम कपड़े पहन ले। फिर वह बाहर आकर अपने और अपनी क़ौम के लिए भस्म होनेवाली क़ुरबानी पेश करे ताकि अपना और अपनी क़ौम का कफ़्फ़ारा दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","इसके अलावा वह गुनाह की क़ुरबानी की चरबी क़ुरबानगाह पर जला दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","जो आदमी अज़ाज़ेल के लिए बकरे को रेगिस्तान में छोड़ आया है वह अपने कपड़े धोकर नहा ले। इसके बाद वह ख़ैमागाह में आ सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","जिस बैल और बकरे को गुनाह की क़ुरबानी के लिए पेश किया गया और जिनका ख़ून कफ़्फ़ारा देने के लिए मुक़द्दसतरीन कमरे में लाया गया, लाज़िम है कि उनकी खालें, गोश्त और गोबर ख़ैमागाह के बाहर जला दिया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","यह चीज़ें जलानेवाला बाद में अपने कपड़े धोकर नहा ले। फिर वह ख़ैमागाह में आ सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","लाज़िम है कि सातवें महीने के दसवें दिन इसराईली और उनके दरमियान रहनेवाले परदेसी अपनी जान को दुख दें और काम न करें। यह उसूल तुम्हारे लिए अबद तक क़ायम रहे। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","इस दिन तुम्हारा कफ़्फ़ारा दिया जाएगा ताकि तुम्हें पाक किया जाए। तब तुम रब के सामने अपने तमाम गुनाहों से पाक ठहरोगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","पूरा दिन आराम करो और अपनी जान को दुख दो। यह उसूल अबद तक क़ायम रहे। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","इस दिन इमामे-आज़म तुम्हारा कफ़्फ़ारा दे, वह इमाम जिसे उसके बाप की जगह मसह किया गया और इख़्तियार दिया गया है। वह कतान के मुक़द्दस कपड़े पहनकर ");
INSERT INTO urdgvh_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","मुक़द्दसतरीन कमरे, मुलाक़ात के ख़ैमे, क़ुरबानगाह, इमामों और जमात के तमाम लोगों का कफ़्फ़ारा दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","लाज़िम है कि साल में एक दफ़ा इसराईलियों के तमाम गुनाहों का कफ़्फ़ारा दिया जाए। यह उसूल तुम्हारे लिए अबद तक क़ायम रहे।” सब कुछ वैसे ही किया गया जैसा रब ने मूसा को हुक्म दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“हारून, उसके बेटों और तमाम इसराईलियों को हिदायत देना ");
INSERT INTO urdgvh_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","कि जो भी इसराईली अपनी गाय या भेड़-बकरी मुलाक़ात के ख़ैमे के दरवाज़े पर रब को क़ुरबानी के तौर पर पेश न करे बल्कि ख़ैमागाह के अंदर या बाहर किसी और जगह पर ज़बह करे वह ख़ून बहाने का क़ुसूरवार ठहरेगा। उसने ख़ून बहाया है, और लाज़िम है कि उसे उस की क़ौम में से मिटाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","इस हिदायत का मक़सद यह है कि इसराईली अब से अपनी क़ुरबानियाँ खुले मैदान में ज़बह न करें बल्कि रब को पेश करें। वह अपने जानवरों को मुलाक़ात के ख़ैमे के दरवाज़े पर इमाम के पास लाकर उन्हें रब को सलामती की क़ुरबानी के तौर पर पेश करें। ");
INSERT INTO urdgvh_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","इमाम उनका ख़ून मुलाक़ात के ख़ैमे के दरवाज़े पर की क़ुरबानगाह पर छिड़के और उनकी चरबी उस पर जला दे। ऐसी क़ुरबानी की ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","अब से इसराईली अपनी क़ुरबानियाँ उन बकरों के देवताओं को पेश न करें जिनकी पैरवी करके उन्होंने ज़िना किया है। यह उनके लिए और उनके बाद आनेवाली नसलों के लिए एक दायमी उसूल है। ");
INSERT INTO urdgvh_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","लाज़िम है कि हर इसराईली और तुम्हारे दरमियान रहनेवाला परदेसी अपनी भस्म होनेवाली क़ुरबानी या कोई और क़ुरबानी ");
INSERT INTO urdgvh_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","मुलाक़ात के ख़ैमे के दरवाज़े पर लाकर रब को पेश करे। वरना उसे उस की क़ौम में से मिटाया जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","ख़ून खाना बिलकुल मना है। जो भी इसराईली या तुम्हारे दरमियान रहनेवाला परदेसी ख़ून खाए मैं उसके ख़िलाफ़ हो जाऊँगा और उसे उस की क़ौम में से मिटा डालूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","क्योंकि हर मख़लूक़ के ख़ून में उस की जान है। मैंने उसे तुम्हें दे दिया है ताकि वह क़ुरबानगाह पर तुम्हारा कफ़्फ़ारा दे। क्योंकि ख़ून ही उस जान के ज़रीए जो उसमें है तुम्हारा कफ़्फ़ारा देता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","इसलिए मैं कहता हूँ कि न कोई इसराईली न कोई परदेसी ख़ून खाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","अगर कोई भी इसराईली या परदेसी किसी जानवर या परिंदे का शिकार करके पकड़े जिसे खाने की इजाज़त है तो वह उसे ज़बह करने के बाद उसका पूरा ख़ून ज़मीन पर बहने दे और ख़ून पर मिट्टी डाले। ");
INSERT INTO urdgvh_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","क्योंकि हर मख़लूक़ का ख़ून उस की जान है। इसलिए मैंने इसराईलियों को कहा है कि किसी भी मख़लूक़ का ख़ून न खाओ। हर मख़लूक़ का ख़ून उस की जान है, और जो भी उसे खाए उसे क़ौम में से मिटा देना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","अगर कोई भी इसराईली या परदेसी ऐसे जानवर का गोश्त खाए जो फ़ितरी तौर पर मर गया या जिसे जंगली जानवरों ने फाड़ डाला हो तो वह अपने कपड़े धोकर नहा ले। वह शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","जो ऐसा नहीं करता उसे अपने क़ुसूर की सज़ा भुगतनी पड़ेगी।” ");
INSERT INTO urdgvh_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“इसराईलियों को बताना कि मैं रब तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","मिसरियों की तरह ज़िंदगी न गुज़ारना जिनमें तुम रहते थे। मुल्के-कनान के लोगों की तरह भी ज़िंदगी न गुज़ारना जिनके पास मैं तुम्हें ले जा रहा हूँ। उनके रस्मो-रिवाज न अपनाना। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","मेरे ही अहकाम पर अमल करो और मेरी हिदायात के मुताबिक़ चलो। मैं रब तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","मेरी हिदायात और अहकाम के मुताबिक़ चलना, क्योंकि जो यों करेगा वह जीता रहेगा। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","तुममें से कोई भी अपनी क़रीबी रिश्तेदार से हमबिसतर न हो। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","अपनी माँ से हमबिसतर न होना, वरना तेरे बाप की बेहुरमती हो जाएगी। वह तेरी माँ है, इसलिए उससे हमबिसतर न होना। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","अपने बाप की किसी भी बीवी से हमबिसतर न होना, वरना तेरे बाप की बेहुरमती हो जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","अपनी बहन से हमबिसतर न होना, चाहे वह तेरे बाप या तेरी माँ की बेटी हो, चाहे वह तेरे ही घर में या कहीं और पैदा हुई हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","अपनी पोती या नवासी से हमबिसतर न होना, वरना तेरी अपनी बेहुरमती हो जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","अपने बाप की बीवी की बेटी से हमबिसतर न होना। वह तेरी बहन है। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","अपनी फूफी से हमबिसतर न होना। वह तेरे बाप की क़रीबी रिश्तेदार है। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","अपनी ख़ाला से हमबिसतर न होना। वह तेरी माँ की क़रीबी रिश्तेदार है। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","अपने बाप के भाई की बीवी से हमबिसतर न होना, वरना तेरे बाप के भाई की बेहुरमती हो जाएगी। उस की बीवी तेरी चची है। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","अपनी बहू से हमबिसतर न होना। वह तेरे बेटे की बीवी है। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","अपनी भाबी से हमबिसतर न होना, वरना तेरे भाई की बेहुरमती हो जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","अगर तेरा जिंसी ताल्लुक़ किसी औरत से हो तो उस की बेटी, पोती या नवासी से हमबिसतर होना मना है, क्योंकि वह उस की क़रीबी रिश्तेदार हैं। ऐसा करना बड़ी शर्मनाक हरकत है। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","अपनी बीवी के जीते-जी उस की बहन से शादी न करना। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","किसी औरत से उस की माहवारी के दिनों में हमबिसतर न होना। इस दौरान वह नापाक है। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","किसी दूसरे मर्द की बीवी से हमबिसतर न होना, वरना तू अपने आपको नापाक करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","अपने किसी भी बच्चे को मलिक देवता को क़ुरबानी के तौर पर पेश करके जला देना मना है। ऐसी हरकत से तू अपने ख़ुदा के नाम को दाग़ लगाएगा। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","मर्द दूसरे मर्द के साथ जिंसी ताल्लुक़ात न रखे। ऐसी हरकत क़ाबिले-घिन है। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","किसी जानवर से जिंसी ताल्लुक़ात न रखना, वरना तू नापाक हो जाएगा। औरतों के लिए भी ऐसा करना मना है। यह बड़ी शर्मनाक हरकत है। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","ऐसी हरकतों से अपने आपको नापाक न करना। क्योंकि जो क़ौमें मैं तुम्हारे आगे मुल्क से निकालूँगा वह इसी तरह नापाक होती रहीं। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","मुल्क ख़ुद भी नापाक हुआ। इसलिए मैंने उसे उसके क़ुसूर के सबब से सज़ा दी, और नतीजे में उसने अपने बाशिंदों को उगल दिया। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","लेकिन तुम मेरी हिदायात और अहकाम के मुताबिक़ चलो। न देसी और न परदेसी ऐसी कोई घिनौनी हरकत करें। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","क्योंकि यह तमाम क़ाबिले-घिन बातें उनसे हुईं जो तुमसे पहले इस मुल्क में रहते थे। यों मुल्क नापाक हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","लिहाज़ा अगर तुम भी मुल्क को नापाक करोगे तो वह तुम्हें इसी तरह उगल देगा जिस तरह उसने तुमसे पहले मौजूद क़ौमों को उगल दिया। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","जो भी मज़कूरा घिनौनी हरकतों में से एक करे उसे उस की क़ौम में से मिटाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","मेरे अहकाम के मुताबिक़ चलते रहो और ऐसे क़ाबिले-घिन रस्मो-रिवाज न अपनाना जो तुम्हारे आने से पहले रायज थे। इनसे अपने आपको नापाक न करना। मैं रब तुम्हारा ख़ुदा हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“इसराईलियों की पूरी जमात को बताना कि मुक़द्दस रहो, क्योंकि मैं रब तुम्हारा ख़ुदा क़ुद्दूस हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","तुममें से हर एक अपने माँ-बाप की इज़्ज़त करे। हफ़ते के दिन काम न करना। मैं रब तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","न बुतों की तरफ़ रुजू करना, न अपने लिए देवता ढालना। मैं ही रब तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","जब तुम रब को सलामती की क़ुरबानी पेश करते हो तो उसे यों चढ़ाओ कि तुम मंज़ूर हो जाओ। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","उसका गोश्त उसी दिन या अगले दिन खाया जाए। जो भी तीसरे दिन तक बच जाता है उसे जलाना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","अगर कोई उसे तीसरे दिन खाए तो उसे इल्म होना चाहिए कि यह क़ुरबानी नापाक है और रब को पसंद नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ऐसे शख़्स को अपने क़ुसूर की सज़ा उठानी पड़ेगी, क्योंकि उसने उस चीज़ की मुक़द्दस हालत ख़त्म की है जो रब के लिए मख़सूस की गई थी। उसे उस की क़ौम में से मिटाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","कटाई के वक़्त अपनी फ़सल पूरे तौर पर न काटना बल्कि खेत के किनारों पर कुछ छोड़ देना। इस तरह जो कुछ कटाई करते वक़्त खेत में बच जाए उसे छोड़ना। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","अंगूर के बाग़ों में भी जो कुछ अंगूर तोड़ते वक़्त बच जाए उसे छोड़ देना। जो अंगूर ज़मीन पर गिर जाएँ उन्हें उठाकर न ले जाना। उन्हें ग़रीबों और परदेसियों के लिए छोड़ देना। मैं रब तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","चोरी न करना, झूट न बोलना, एक दूसरे को धोका न देना। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","मेरे नाम की क़सम खाकर धोका न देना, वरना तुम मेरे नाम को दाग़ लगाओगे। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","एक दूसरे को न दबाना और न लूटना। किसी की मज़दूरी उसी दिन की शाम तक दे देना और उसे अगली सुबह तक रोके न रखना। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","बहरे को न कोसना, न अंधे के रास्ते में कोई चीज़ रखना जिससे वह ठोकर खाए। इसमें भी अपने ख़ुदा का ख़ौफ़ मानना। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","अदालत में किसी की हक़तलफ़ी न करना। फ़ैसला करते वक़्त किसी की भी जानिबदारी न करना, चाहे वह ग़रीब या असरो-रसूख़वाला हो। इनसाफ़ से अपने पड़ोसी की अदालत कर। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","अपनी क़ौम में इधर-उधर फिरते हुए किसी पर बुहतान न लगाना। कोई भी ऐसा काम न करना जिससे किसी की जान ख़तरे में पड़ जाए। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","दिल में अपने भाई से नफ़रत न करना। अगर किसी की सरज़निश करनी है तो रूबरू करना, वरना तू उसके सबब से क़ुसूरवार ठहरेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","इंतक़ाम न लेना। अपनी क़ौम के किसी शख़्स पर देर तक तेरा ग़ुस्सा न रहे बल्कि अपने पड़ोसी से वैसी मुहब्बत रखना जैसी तू अपने आपसे रखता है। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","मेरी हिदायात पर अमल करो। दो मुख़्तलिफ़ क़िस्म के जानवरों को मिलाप न करने देना। अपने खेत में दो क़िस्म के बीज न बोना। ऐसा कपड़ा न पहनना जो दो मुख़्तलिफ़ क़िस्म के धागों का बुना हुआ हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","अगर कोई आदमी किसी लौंडी से जिसकी मँगनी किसी और से हो चुकी हो हमबिसतर हो जाए और लौंडी को अब तक न पैसों से न वैसे ही आज़ाद किया गया हो तो मुनासिब सज़ा दी जाए। लेकिन उन्हें सज़ाए-मौत न दी जाए, क्योंकि उसे अब तक आज़ाद नहीं किया गया। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","क़ुसूरवार आदमी मुलाक़ात के ख़ैमे के दरवाज़े पर एक मेंढा ले आए ताकि वह रब को क़ुसूर की क़ुरबानी के तौर पर पेश किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","इमाम इस क़ुरबानी से रब के सामने उसके गुनाह का कफ़्फ़ारा दे। यों उसका गुनाह मुआफ़ किया जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","जब मुल्के-कनान में दाख़िल होने के बाद तुम फलदार दरख़्त लगाओगे तो पहले तीन साल उनका फल न खाना बल्कि उसे ममनू समझना। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","चौथे साल उनका तमाम फल ख़ुशी के मुक़द्दस नज़राने के तौर पर रब के लिए मख़सूस किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","पाँचवें साल तुम उनका फल खा सकते हो। यों तुम्हारी फ़सल बढ़ाई जाएगी। मैं रब तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","ऐसा गोश्त न खाना जिसमें ख़ून हो। फ़ाल या शुगून न निकालना। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","अपने सर के बाल गोल शक्ल में न कटवाना, न अपनी दाढ़ी को तराशना। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","अपने आपको मुरदों के सबब से काटकर ज़ख़मी न करना, न अपनी जिल्द पर नुक़ूश गुदवाना। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","अपनी बेटी को कसबी न बनाना, वरना उस की मुक़द्दस हालत जाती रहेगी और मुल्क ज़िनाकारी के बाइस हरामकारी से भर जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","हफ़ते के दिन आराम करना और मेरे मक़दिस का एहतराम करना। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","ऐसे लोगों के पास न जाना जो मुरदों से राबिता करते हैं, न ग़ैबदानों की तरफ़ रुजू करना, वरना तुम उनसे नापाक हो जाओगे। मैं रब तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","बूढ़े लोगों के सामने उठकर खड़ा हो जाना, बुज़ुर्गों की इज़्ज़त करना और अपने ख़ुदा का एहतराम करना। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","जो परदेसी तुम्हारे मुल्क में तुम्हारे दरमियान रहता है उसे न दबाना। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","उसके साथ ऐसा सुलूक कर जैसा अपने हमवतनों के साथ करता है। जिस तरह तू अपने आपसे मुहब्बत रखता है उसी तरह उससे भी मुहब्बत रखना। याद रहे कि तुम ख़ुद मिसर में परदेसी थे। मैं रब तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","नाइनसाफ़ी न करना। न अदालत में, न लंबाई नापते वक़्त, न तोलते वक़्त और न किसी चीज़ की मिक़दार नापते वक़्त। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","सहीह तराज़ू, सहीह बाट और सहीह पैमाना इस्तेमाल करना। मैं रब तुम्हारा ख़ुदा हूँ जो तुम्हें मिसर से निकाल लाया हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","मेरी तमाम हिदायात और तमाम अहकाम मानो और उन पर अमल करो। मैं रब हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“इसराईलियों को बताना कि तुममें से जो भी अपने बच्चे को मलिक देवता को क़ुरबानी के तौर पर पेश करे उसे सज़ाए-मौत देनी है। इसमें कोई फ़रक़ नहीं कि वह इसराईली है या परदेसी। जमात के लोग उसे संगसार करें। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","मैं ख़ुद ऐसे शख़्स के ख़िलाफ़ हो जाऊँगा और उसे उस की क़ौम में से मिटा डालूँगा। क्योंकि अपने बच्चों को मलिक को पेश करने से उसने मेरे मक़दिस को नापाक किया और मेरे नाम को दाग़ लगाया है। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","अगर जमात के लोग अपनी आँखें बंद करके ऐसे शख़्स की हरकतें नज़रंदाज़ करें और उसे सज़ाए-मौत न दें ");
INSERT INTO urdgvh_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","तो फिर मैं ख़ुद ऐसे शख़्स और उसके घराने के ख़िलाफ़ खड़ा हो जाऊँगा। मैं उसे और उन तमाम लोगों को क़ौम में से मिटा डालूँगा जिन्होंने उसके पीछे लगकर मलिक देवता को सिजदा करने से ज़िना किया है। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","जो शख़्स मुरदों से राबिता करने और ग़ैबदानी करनेवालों की तरफ़ रुजू करता है मैं उसके ख़िलाफ़ हो जाऊँगा। उनकी पैरवी करने से वह ज़िना करता है। मैं उसे उस की क़ौम में से मिटा डालूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","अपने आपको मेरे लिए मख़सूसो-मुक़द्दस रखो, क्योंकि मैं रब तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","मेरी हिदायात मानो और उन पर अमल करो। मैं रब हूँ जो तुम्हें मख़सूसो-मुक़द्दस करता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","जिसने भी अपने बाप या माँ पर लानत भेजी है उसे सज़ाए-मौत दी जाए। इस हरकत से वह अपनी मौत का ख़ुद ज़िम्मादार है। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","अगर किसी मर्द ने किसी की बीवी के साथ ज़िना किया है तो दोनों को सज़ाए-मौत देनी है। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","जो मर्द अपने बाप की बीवी से हमबिसतर हुआ है उसने अपने बाप की बेहुरमती की है। दोनों को सज़ाए-मौत देनी है। वह अपनी मौत के ख़ुद ज़िम्मादार हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","अगर कोई मर्द अपनी बहू से हमबिसतर हुआ है तो दोनों को सज़ाए-मौत देनी है। जो कुछ उन्होंने किया है वह निहायत शर्मनाक है। वह अपनी मौत के ख़ुद ज़िम्मादार हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","अगर कोई मर्द किसी दूसरे मर्द से जिंसी ताल्लुक़ात रखे तो दोनों को इस घिनौनी हरकत के बाइस सज़ाए-मौत देनी है। वह अपनी मौत के ख़ुद ज़िम्मादार हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","अगर कोई आदमी अपनी बीवी के अलावा उस की माँ से भी शादी करे तो यह एक निहायत शर्मनाक बात है। दोनों को जला देना है ताकि तुम्हारे दरमियान कोई ऐसी ख़बीस बात न रहे। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","जो मर्द किसी जानवर से जिंसी ताल्लुक़ात रखे उसे सज़ाए-मौत देना है। उस जानवर को भी मार दिया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","जो औरत किसी जानवर से जिंसी ताल्लुक़ात रखे उसे सज़ाए-मौत देनी है। उस जानवर को भी मार दिया जाए। वह अपनी मौत के ख़ुद ज़िम्मादार हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","जिस मर्द ने अपनी बहन से शादी की है उसने शर्मनाक हरकत की है, चाहे वह बाप की बेटी हो या माँ की। उन्हें इसराईली क़ौम की नज़रों से मिटाया जाए। ऐसे शख़्स ने अपनी बहन की बेहुरमती की है। इसलिए उसे ख़ुद अपने क़ुसूर के नतीजे बरदाश्त करने पड़ेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","अगर कोई मर्द माहवारी के ऐयाम में किसी औरत से हमबिसतर हुआ है तो दोनों को उनकी क़ौम में से मिटाना है। क्योंकि दोनों ने औरत के ख़ून के मंबा से परदा उठाया है। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","अपनी ख़ाला या फूफी से हमबिसतर न होना। क्योंकि जो ऐसा करता है वह अपनी क़रीबी रिश्तेदार की बेहुरमती करता है। दोनों को अपने क़ुसूर के नतीजे बरदाश्त करने पड़ेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","जो अपनी चची या ताई से हमबिसतर हुआ है उसने अपने चचा या ताया की बेहुरमती की है। दोनों को अपने क़ुसूर के नतीजे बरदाश्त करने पड़ेंगे। वह बेऔलाद मरेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","जिसने अपनी भाबी से शादी की है उसने एक नजिस हरकत की है। उसने अपने भाई की बेहुरमती की है। वह बेऔलाद रहेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","मेरी तमाम हिदायात और अहकाम को मानो और उन पर अमल करो। वरना जिस मुल्क में मैं तुम्हें ले जा रहा हूँ वह तुम्हें उगल देगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","उन क़ौमों के रस्मो-रिवाज के मुताबिक़ ज़िंदगी न गुज़ारना जिन्हें मैं तुम्हारे आगे से निकाल दूँगा। मुझे इस सबब से उनसे घिन आने लगी कि वह यह सब कुछ करते थे। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","लेकिन तुमसे मैंने कहा, ‘तुम ही उनकी ज़मीन पर क़ब्ज़ा करोगे। मैं ही उसे तुम्हें दे दूँगा, ऐसा मुल्क जिसमें कसरत का दूध और शहद है।’ मैं रब तुम्हारा ख़ुदा हूँ, जिसने तुमको दीगर क़ौमों में से चुनकर अलग कर दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","इसलिए लाज़िम है कि तुम ज़मीन पर चलनेवाले जानवरों और परिंदों में पाक और नापाक का इम्तियाज़ करो। अपने आपको नापाक जानवर खाने से क़ाबिले-घिन न बनाना, चाहे वह ज़मीन पर चलते या रेंगते हैं, चाहे हवा में उड़ते हैं। मैं ही ने उन्हें तुम्हारे लिए नापाक क़रार दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","तुम्हें मेरे लिए मख़सूसो-मुक़द्दस होना है, क्योंकि मैं क़ुद्दूस हूँ, और मैंने तुम्हें दीगर क़ौमों में से चुनकर अपने लिए अलग कर लिया है। ");
INSERT INTO urdgvh_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","तुममें से जो मुरदों से राबिता या ग़ैबदानी करता है उसे सज़ाए-मौत देनी है, ख़ाह औरत हो या मर्द। उन्हें संगसार करना। वह अपनी मौत के ख़ुद ज़िम्मादार हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","रब ने मूसा से कहा, “हारून के बेटों को जो इमाम हैं बता देना कि इमाम अपने आपको किसी इसराईली की लाश के क़रीब जाने से नापाक न करे ");
INSERT INTO urdgvh_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","सिवाए अपने क़रीबी रिश्तेदारों के यानी माँ, बाप, बेटा, बेटी, भाई ");
INSERT INTO urdgvh_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","और जो ग़ैरशादीशुदा बहन उसके घर में रहती है। ");
INSERT INTO urdgvh_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","वह अपनी क़ौम में किसी और के बाइस अपने आपको नापाक न करे, वरना उस की मुक़द्दस हालत जाती रहेगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","इमाम अपने सर को न मुँडवाएँ। वह न अपनी दाढ़ी को तराशें और न काटने से अपने आपको ज़ख़मी करें। ");
INSERT INTO urdgvh_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","वह अपने ख़ुदा के लिए मख़सूसो-मुक़द्दस रहें और अपने ख़ुदा के नाम को दाग़ न लगाएँ। चूँकि वह रब को जलनेवाली क़ुरबानियाँ यानी अपने ख़ुदा की रोटी पेश करते हैं इसलिए लाज़िम है कि वह मुक़द्दस रहें। ");
INSERT INTO urdgvh_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","इमाम ज़िनाकार औरत, मंदिर की कसबी या तलाक़याफ़्ता औरत से शादी न करें, क्योंकि वह अपने रब के लिए मख़सूसो-मुक़द्दस हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","इमाम को मुक़द्दस समझना, क्योंकि वह तेरे ख़ुदा की रोटी को क़ुरबानगाह पर चढ़ाता है। वह तेरे लिए मुक़द्दस ठहरे क्योंकि मैं रब क़ुद्दूस हूँ। मैं ही तुम्हें मुक़द्दस करता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","किसी इमाम की जो बेटी ज़िनाकारी से अपनी मुक़द्दस हालत को ख़त्म कर देती है वह अपने बाप की मुक़द्दस हालत को भी ख़त्म कर देती है। उसे जला दिया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","इमामे-आज़म के सर पर मसह का तेल उंडेला गया है और उसे इमामे-आज़म के मुक़द्दस कपड़े पहनने का इख़्तियार दिया गया है। इसलिए वह रंज के आलम में अपने बालों को बिखरने न दे, न कभी अपने कपड़ों को फाड़े। ");
INSERT INTO urdgvh_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","वह किसी लाश के क़रीब न जाए, चाहे वह उसके बाप या माँ की लाश क्यों न हो, वरना वह नापाक हो जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","जब तक कोई लाश उसके घर में पड़ी रहे वह मक़दिस को छोड़कर अपने घर न जाए, वरना वह मक़दिस को नापाक करेगा। क्योंकि उसे उसके ख़ुदा के तेल से मख़सूस किया गया है। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","इमामे-आज़म को सिर्फ़ कुँवारी से शादी की इजाज़त है। ");
INSERT INTO urdgvh_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","वह बेवा, तलाक़याफ़्ता औरत, मंदिर की कसबी या ज़िनाकार औरत से शादी न करे बल्कि सिर्फ़ अपने क़बीले की कुँवारी से, ");
INSERT INTO urdgvh_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","वरना उस की औलाद मख़सूसो-मुक़द्दस नहीं होगी। क्योंकि मैं रब हूँ जो उसे अपने लिए मख़सूसो-मुक़द्दस करता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","रब ने मूसा से यह भी कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“हारून को बताना कि तेरी औलाद में से कोई भी जिसके जिस्म में नुक़्स हो मेरे हुज़ूर आकर अपने ख़ुदा की रोटी न चढ़ाए। यह उसूल आनेवाली नसलों के लिए भी अटल है। ");
INSERT INTO urdgvh_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","क्योंकि कोई भी माज़ूर मेरे हुज़ूर न आए, न अंधा, न लँगड़ा, न वह जिसकी नाक चिरी हुई हो या जिसके किसी अज़ु में कमी बेशी हो, ");
INSERT INTO urdgvh_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","न वह जिसका पाँव या हाथ टूटा हुआ हो, ");
INSERT INTO urdgvh_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","न कुबड़ा, न बौना, न वह जिसकी आँख में नुक़्स हो या जिसे वबाई जिल्दी बीमारी हो या जिसके ख़ुसिये कुचले हुए हों। ");
INSERT INTO urdgvh_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","हारून इमाम की कोई भी औलाद जिसके जिस्म में नुक़्स हो मेरे हुज़ूर आकर रब को जलनेवाली क़ुरबानियाँ पेश न करे। चूँकि उसमें नुक़्स है इसलिए वह मेरे हुज़ूर आकर अपने ख़ुदा की रोटी न चढ़ाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","उसे अल्लाह की मुक़द्दस बल्कि मुक़द्दसतरीन क़ुरबानियों में से भी इमामों का हिस्सा खाने की इजाज़त है। ");
INSERT INTO urdgvh_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","लेकिन चूँकि उसमें नुक़्स है इसलिए वह मुक़द्दसतरीन कमरे के दरवाज़े के परदे के क़रीब न जाए, न क़ुरबानगाह के पास आए। वरना वह मेरी मुक़द्दस चीज़ों को नापाक करेगा। क्योंकि मैं रब हूँ जो उन्हें अपने लिए मख़सूसो-मुक़द्दस करता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","मूसा ने यह हिदायात हारून, उसके बेटों और तमाम इसराईलियों को दीं। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“हारून और उसके बेटों को बताना कि इसराईलियों की उन क़ुरबानियों का एहतराम करो जो तुमने मेरे लिए मख़सूसो-मुक़द्दस की हैं, वरना तुम मेरे नाम को दाग़ लगाओगे। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","जो इमाम नापाक होने के बावुजूद उन क़ुरबानियों के पास आ जाए जो इसराईलियों ने मेरे लिए मख़सूसो-मुक़द्दस की हैं उसे मेरे सामने से मिटाना है। यह उसूल आनेवाली नसलों के लिए भी अटल है। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","हारून की औलाद में से जो भी वबाई जिल्दी बीमारी या जरयान का मरीज़ हो उसे मुक़द्दस क़ुरबानियों में से अपना हिस्सा खाने की इजाज़त नहीं है। पहले वह पाक हो जाए। जो ऐसी कोई भी चीज़ छुए जो लाश से नापाक हो गई हो या ऐसे आदमी को छुए जिसका नुतफ़ा निकला हो वह नापाक हो जाता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","वह नापाक रेंगनेवाले जानवर या नापाक शख़्स को छूने से भी नापाक हो जाता है, ख़ाह वह किसी भी सबब से नापाक क्यों न हुआ हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","जो ऐसी कोई भी चीज़ छुए वह शाम तक नापाक रहेगा। इसके अलावा लाज़िम है कि वह मुक़द्दस क़ुरबानियों में से अपना हिस्सा खाने से पहले नहा ले। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","सूरज के ग़ुरूब होने पर वह पाक होगा और मुक़द्दस क़ुरबानियों में से अपना हिस्सा खा सकेगा। क्योंकि वह उस की रोज़ी हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","इमाम ऐसे जानवरों का गोश्त न खाए जो फ़ितरी तौर पर मर गए या जिन्हें जंगली जानवरों ने फाड़ डाला हो, वरना वह नापाक हो जाएगा। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","इमाम मेरी हिदायात के मुताबिक़ चलें, वरना वह क़ुसूरवार बन जाएंगे और मुक़द्दस चीज़ों की बेहुरमती करने के सबब से मर जाएंगे। मैं रब हूँ जो उन्हें अपने लिए मख़सूसो-मुक़द्दस करता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","सिर्फ़ इमाम के ख़ानदान के अफ़राद मुक़द्दस क़ुरबानियों में से खा सकते हैं। ग़ैरशहरी या मज़दूर को इजाज़त नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","लेकिन इमाम का ग़ुलाम या लौंडी उसमें से खा सकते हैं, चाहे उन्हें ख़रीदा गया हो या वह उसके घर में पैदा हुए हों। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","अगर इमाम की बेटी ने किसी ऐसे शख़्स से शादी की है जो इमाम नहीं है तो उसे मुक़द्दस क़ुरबानियों में से खाने की इजाज़त नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","लेकिन हो सकता है कि वह बेवा या तलाक़याफ़्ता हो और उसके बच्चे न हों। जब वह अपने बाप के घर लौटकर वहाँ ऐसे रहेगी जैसे अपनी जवानी में तो वह अपने बाप के उस खाने में से खा सकती है जो क़ुरबानियों में से बाप का हिस्सा है। लेकिन जो इमाम के ख़ानदान का फ़रद नहीं है उसे खाने की इजाज़त नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","जिस शख़्स ने नादानिस्ता तौर पर मुक़द्दस क़ुरबानियों में से इमाम के हिस्से से कुछ खाया है वह इमाम को सब कुछ वापस करने के अलावा 20 फ़ीसद ज़्यादा दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","इमाम रब को पेश की हुई क़ुरबानियों की मुक़द्दस हालत यों ख़त्म न करें ");
INSERT INTO urdgvh_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","कि वह दूसरे इसराईलियों को यह मुक़द्दस चीज़ें खाने दें। ऐसी हरकत से वह उनको बड़ा क़ुसूरवार बना देंगे। मैं रब हूँ जो उन्हें अपने लिए मख़सूसो-मुक़द्दस करता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“हारून, उसके बेटों और इसराईलियों को बताना कि अगर तुममें से कोई इसराईली या परदेसी रब को भस्म होनेवाली क़ुरबानी पेश करना चाहे तो तरीक़े-कार में कोई फ़रक़ नहीं है, चाहे वह यह मन्नत मानकर या वैसे ही दिली ख़ुशी से कर रहा हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","इसके लिए लाज़िम है कि तुम एक बेऐब बैल, मेंढा या बकरा पेश करो। फिर ही उसे क़बूल किया जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","क़ुरबानी के लिए कभी भी ऐसा जानवर पेश न करना जिसमें नुक़्स हो, वरना तुम उसके बाइस मंज़ूर नहीं होगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","अगर कोई रब को सलामती की क़ुरबानी पेश करना चाहे तो तरीक़े-कार में कोई फ़रक़ नहीं है, चाहे वह यह मन्नत मानकर या वैसे ही दिली ख़ुशी से कर रहा हो। इसके लिए लाज़िम है कि वह गाय-बैलों या भेड़-बकरियों में से बेऐब जानवर चुने। फिर उसे क़बूल किया जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","रब को ऐसे जानवर पेश न करना जो अंधे हों, जिनके आज़ा टूटे या कटे हुए हों, जिनको रसौली हो या जिन्हें वबाई जिल्दी बीमारी लग गई हो। रब को उन्हें जलनेवाली क़ुरबानी के तौर पर क़ुरबानगाह पर पेश न करना। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","लेकिन जिस गाय-बैल या भेड़-बकरी के किसी अज़ु में कमी बेशी हो उसे पेश किया जा सकता है। शर्त यह है कि पेश करनेवाला उसे वैसे ही दिली ख़ुशी से चढ़ाए। अगर वह उसे अपनी मन्नत मानकर पेश करे तो वह क़बूल नहीं किया जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","रब को ऐसा जानवर पेश न करना जिसके ख़ुसिये कुचले, तोड़े या कटे हुए हों। अपने मुल्क में जानवरों को इस तरह ख़सी न बनाना, ");
INSERT INTO urdgvh_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","न ऐसे जानवर किसी ग़ैरमुल्की से ख़रीदकर अपने ख़ुदा की रोटी के तौर पर पेश करना। तुम ऐसे जानवरों के बाइस मंज़ूर नहीं होगे, क्योंकि उनमें ख़राबी और नुक़्स है।” ");
INSERT INTO urdgvh_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","रब ने मूसा से यह भी कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“जब किसी गाय, भेड़ या बकरी का बच्चा पैदा होता है तो लाज़िम है कि वह पहले सात दिन अपनी माँ के पास रहे। आठवें दिन से पहले रब उसे जलनेवाली क़ुरबानी के तौर पर क़बूल नहीं करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","किसी गाय, भेड़ या बकरी के बच्चे को उस की माँ समेत एक ही दिन ज़बह न करना। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","जब तुम रब को सलामती की कोई क़ुरबानी चढ़ाना चाहते हो तो उसे यों पेश करना कि तुम मंज़ूर हो जाओ। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","अगली सुबह तक कुछ बचा न रहे बल्कि उसे उसी दिन खाना है। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","मेरे अहकाम मानो और उन पर अमल करो। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","मेरे नाम को दाग़ न लगाना। लाज़िम है कि मुझे इसराईलियों के दरमियान क़ुद्दूस माना जाए। मैं रब हूँ जो तुम्हें अपने लिए मख़सूसो-मुक़द्दस करता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","मैं तुम्हें मिसर से निकाल लाया हूँ ताकि तुम्हारा ख़ुदा हूँ। मैं रब हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“इसराईलियों को बताना कि यह मेरी, रब की ईदें हैं जिन पर तुम्हें लोगों को मुक़द्दस इजतिमा के लिए जमा करना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","हफ़ते में छः दिन काम करना, लेकिन सातवाँ दिन हर तरह से आराम का दिन है। उस दिन मुक़द्दस इजतिमा हो। जहाँ भी तुम रहते हो वहाँ काम न करना। यह दिन रब के लिए मख़सूस सबत है। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","यह रब की ईदें हैं जिन पर तुम्हें लोगों को मुक़द्दस इजतिमा के लिए जमा करना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","फ़सह की ईद पहले महीने के चौधवें दिन शुरू होती है। उस दिन सूरज के ग़ुरूब होने पर रब की ख़ुशी मनाई जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","अगले दिन रब की याद में बेख़मीरी रोटी की ईद शुरू होती है। सात दिन तक तुम्हारी रोटी में ख़मीर न हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","इन सात दिनों के पहले दिन मुक़द्दस इजतिमा हो और लोग अपना हर काम छोड़ें। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","इन सात दिनों में रोज़ाना रब को जलनेवाली क़ुरबानी पेश करो। सातवें दिन भी मुक़द्दस इजतिमा हो और लोग अपना हर काम छोड़ें।” ");
INSERT INTO urdgvh_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“इसराईलियों को बताना कि जब तुम उस मुल्क में दाख़िल होगे जो मैं तुम्हें दूँगा और वहाँ अनाज की फ़सल काटोगे तो तुम्हें इमाम को पहला पूला देना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","इतवार को इमाम यह पूला रब के सामने हिलाए ताकि तुम मंज़ूर हो जाओ। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","उस दिन भेड़ का एक यकसाला बेऐब बच्चा भी रब को पेश करना। उसे क़ुरबानगाह पर भस्म होनेवाली क़ुरबानी के तौर पर चढ़ाना। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","साथ ही ग़ल्ला की नज़र के लिए तेल से मिलाया गया 3 किलोग्राम बेहतरीन मैदा भी पेश करना। जलनेवाली यह क़ुरबानी रब को पसंद है। इसके अलावा मै की नज़र के लिए एक लिटर मै भी पेश करना। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","पहले यह सब कुछ करो, फिर ही तुम्हें नई फ़सल के अनाज से खाने की इजाज़त होगी, ख़ाह वह भुना हुआ हो, ख़ाह कच्चा या रोटी की सूरत में पकाया गया हो। जहाँ भी तुम रहते हो वहाँ ऐसा ही करना है। यह उसूल अबद तक क़ायम रहे। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","जिस दिन तुमने अनाज का पूला पेश किया उस दिन से पूरे सात हफ़ते गिनो। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","पचासवें दिन यानी सातवें इतवार को रब को नए अनाज की क़ुरबानी चढ़ाना। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","हर घराने की तरफ़ से रब को हिलानेवाली क़ुरबानी के तौर पर दो रोटियाँ पेश की जाएँ। हर रोटी के लिए 3 किलोग्राम बेहतरीन मैदा इस्तेमाल किया जाए। उनमें ख़मीर डालकर पकाना है। यह फ़सल की पहली पैदावार की क़ुरबानी हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","इन रोटियों के साथ एक जवान बैल, दो मेंढे और भेड़ के सात बेऐब और यकसाला बच्चे पेश करो। उन्हें रब के हुज़ूर भस्म होनेवाली क़ुरबानी के तौर पर चढ़ाना। इसके अलावा ग़ल्ला की नज़र और मै की नज़र भी पेश करनी है। जलनेवाली इस क़ुरबानी की ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","फिर गुनाह की क़ुरबानी के लिए एक बकरा और सलामती की क़ुरबानी के लिए दो यकसाला भेड़ के बच्चे चढ़ाओ। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","इमाम भेड़ के यह दो बच्चे मज़कूरा रोटियों समेत हिलानेवाली क़ुरबानी के तौर पर रब के सामने हिलाए। यह रब के लिए मख़सूसो-मुक़द्दस हैं और क़ुरबानियों में से इमाम का हिस्सा हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","उसी दिन लोगों को मुक़द्दस इजतिमा के लिए जमा करो। कोई भी काम न करना। यह उसूल अबद तक क़ायम रहे, और इसे हर जगह मानना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","कटाई के वक़्त अपनी फ़सल पूरे तौर पर न काटना बल्कि खेत के किनारों पर कुछ छोड़ देना। इस तरह जो कुछ कटाई करते वक़्त खेत में बच जाए उसे छोड़ना। बचा हुआ अनाज ग़रीबों और परदेसियों के लिए छोड़ देना। मैं रब तुम्हारा ख़ुदा हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“इसराईलियों को बताना कि सातवें महीने का पहला दिन आराम का दिन है। उस दिन मुक़द्दस इजतिमा हो जिस पर याद दिलाने के लिए नरसिंगा फूँका जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","कोई भी काम न करना। रब को जलनेवाली क़ुरबानी पेश करना।” ");
INSERT INTO urdgvh_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“सातवें महीने का दसवाँ दिन कफ़्फ़ारा का दिन है। उस दिन मुक़द्दस इजतिमा हो। अपनी जान को दुख देना और रब को जलनेवाली क़ुरबानी पेश करना। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","उस दिन काम न करना, क्योंकि यह कफ़्फ़ारा का दिन है, जब रब तुम्हारे ख़ुदा के सामने तुम्हारा कफ़्फ़ारा दिया जाता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","जो उस दिन अपनी जान को दुख नहीं देता उसे उस की क़ौम में से मिटाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","जो उस दिन काम करता है उसे मैं उस की क़ौम में से निकालकर हलाक करूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","कोई भी काम न करना। यह उसूल अबद तक क़ायम रहे, और इसे हर जगह मानना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","यह दिन आराम का ख़ास दिन है जिसमें तुम्हें अपनी जान को दुख देना है। इसे महीने के नवें दिन की शाम से लेकर अगली शाम तक मनाना।” ");
INSERT INTO urdgvh_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“इसराईलियों को बताना कि सातवें महीने के पंद्रहवें दिन झोंपड़ियों की ईद शुरू होती है। इसका दौरानिया सात दिन है। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","पहले दिन मुक़द्दस इजतिमा हो। इस दिन कोई काम न करना। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","इन सात दिनों के दौरान रब को जलनेवाली क़ुरबानियाँ पेश करना। आठवें दिन मुक़द्दस इजतिमा हो। रब को जलनेवाली क़ुरबानी पेश करो। इस ख़ास इजतिमा के दिन भी काम नहीं करना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","यह रब की ईदें हैं जिन पर तुम्हें मुक़द्दस इजतिमा करना है ताकि रब को रोज़मर्रा की मतलूबा जलनेवाली क़ुरबानियाँ और मै की नज़रें पेश की जाएँ यानी भस्म होनेवाली क़ुरबानियाँ, ग़ल्ला की नज़रें, ज़बह की क़ुरबानियाँ और मै की नज़रें। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","यह क़ुरबानियाँ उन क़ुरबानियों के अलावा हैं जो सबत के दिन चढ़ाई जाती हैं और जो तुमने हदिये के तौर पर या मन्नत मानकर या अपनी दिली ख़ुशी से पेश की हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","चुनाँचे सातवें महीने के पंद्रहवें दिन फ़सल की कटाई के इख़्तिताम पर रब की यह ईद यानी झोंपड़ियों की ईद मनाओ। इसे सात दिन मनाना। पहला और आख़िरी दिन आराम के दिन हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","पहले दिन अपने लिए दरख़्तों के बेहतरीन फल, खजूर की डालियाँ और घने दरख़्तों और सफ़ेदा की शाख़ें तोड़ना। सात दिन तक रब अपने ख़ुदा के सामने ख़ुशी मनाओ। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","हर साल सातवें महीने में रब की ख़ुशी में यह ईद मनाना। यह उसूल अबद तक क़ायम रहे। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ईद के हफ़ते के दौरान झोंपड़ियों में रहना। तमाम मुल्क में आबाद इसराईली ऐसा करें। ");
INSERT INTO urdgvh_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","फिर तुम्हारी औलाद जानेगी कि इसराईलियों को मिसर से निकालते वक़्त मैंने उन्हें झोंपड़ियों में बसाया। मैं रब तुम्हारा ख़ुदा हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","मूसा ने इसराईलियों को रब की ईदों के बारे में यह बातें बताईं। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“इसराईलियों को हुक्म दे कि वह तेरे पास कूटे हुए ज़ैतूनों का ख़ालिस तेल ले आएँ ताकि मुक़द्दस कमरे के शमादान के चराग़ मुतवातिर जलते रहें। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","हारून उन्हें मुसलसल, शाम से लेकर सुबह तक रब के हुज़ूर सँभाले यानी वहाँ जहाँ वह मुक़द्दसतरीन कमरे के परदे के सामने पड़े हैं, उस परदे के सामने जिसके पीछे अहद का संदूक़ है। यह उसूल अबद तक क़ायम रहे। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","वह ख़ालिस सोने के शमादान पर लगे चराग़ों की देख-भाल यों करे कि यह हमेशा रब के सामने जलते रहें। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","बारह रोटियाँ पकाना। हर रोटी के लिए 3 किलोग्राम बेहतरीन मैदा इस्तेमाल किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","उन्हें दो क़तारों में रब के सामने ख़ालिस सोने की मेज़ पर रखना। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","हर क़तार पर ख़ालिस लुबान डालना। यह लुबान रोटी के लिए यादगारी की क़ुरबानी है जिसे बाद में रब के लिए जलाना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","हर हफ़ते को रब के सामने ताज़ा रोटियाँ इसी तरतीब से मेज़ पर रखनी हैं। यह इसराईलियों के लिए अबदी अहद की लाज़िमी शर्त है। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","मेज़ की रोटियाँ हारून और उसके बेटों का हिस्सा हैं, और वह उन्हें मुक़द्दस जगह पर खाएँ, क्योंकि वह जलनेवाली क़ुरबानियों का मुक़द्दसतरीन हिस्सा हैं। यह अबद तक उनका हक़ रहेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","ख़ैमागाह में एक आदमी था जिसका बाप मिसरी और माँ इसराईली थी। माँ का नाम सलूमीत था। वह दिबरी की बेटी और दान के क़बीले की थी। एक दिन यह आदमी ख़ैमागाह में किसी इसराईली से झगड़ने लगा। लड़ते लड़ते उसने रब के नाम पर कुफ़र बककर उस पर लानत भेजी। यह सुनकर लोग उसे मूसा के पास ले आए। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","वहाँ उन्होंने उसे पहरे में बिठाकर रब की हिदायत का इंतज़ार किया। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","तब रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“लानत करनेवाले को ख़ैमागाह के बाहर ले जाओ। जिन्होंने उस की यह बातें सुनी हैं वह सब अपने हाथ उसके सर पर रखें। फिर पूरी जमात उसे संगसार करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","इसराईलियों से कहना कि जो भी अपने ख़ुदा पर लानत भेजे उसे अपने क़ुसूर के नतीजे बरदाश्त करने पड़ेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","जो भी रब के नाम पर कुफ़र बके उसे सज़ाए-मौत दी जाए। पूरी जमात उसे संगसार करे। जिसने रब के नाम पर कुफ़र बका हो उसे ज़रूर सज़ाए-मौत देनी है, ख़ाह देसी हो या परदेसी। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","जिसने किसी को मार डाला है उसे सज़ाए-मौत दी जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","जिसने किसी के जानवर को मार डाला है वह उसका मुआवज़ा दे। जान के बदले जान दी जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","अगर किसी ने किसी को ज़ख़मी कर दिया है तो वही कुछ उसके साथ किया जाए जो उसने दूसरे के साथ किया है। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","अगर दूसरे की कोई हड्डी टूट जाए तो उस की वही हड्डी तोड़ी जाए। अगर दूसरे की आँख ज़ाया हो जाए तो उस की आँख ज़ाया कर दी जाए। अगर दूसरे का दाँत टूट जाए तो उसका वही दाँत तोड़ा जाए। जो भी ज़ख़म उसने दूसरे को पहुँचाया वही ज़ख़म उसे पहुँचाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","जिसने किसी जानवर को मार डाला है वह उसका मुआवज़ा दे, लेकिन जिसने किसी इनसान को मार दिया है उसे सज़ाए-मौत देनी है। ");
INSERT INTO urdgvh_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","देसी और परदेसी के लिए तुम्हारा एक ही क़ानून हो। मैं रब तुम्हारा ख़ुदा हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","फिर मूसा ने इसराईलियों से बात की, और उन्होंने रब पर लानत भेजनेवाले को ख़ैमागाह से बाहर ले जाकर उसे संगसार किया। उन्होंने वैसा ही किया जैसा रब ने मूसा को हुक्म दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","रब ने सीना पहाड़ पर मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“इसराईलियों को बताना कि जब तुम उस मुल्क में दाख़िल होगे जो मैं तुम्हें दूँगा तो लाज़िम है कि रब की ताज़ीम में ज़मीन एक साल आराम करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","छः साल के दौरान अपने खेतों में बीज बोना, अपने अंगूर के बाग़ों की काँट-छाँट करना और उनकी फ़सलें जमा करना। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","लेकिन सातवाँ साल ज़मीन के लिए आराम का साल है, रब की ताज़ीम में सबत का साल। उस साल न अपने खेतों में बीज बोना, न अपने अंगूर के बाग़ों की काँट-छाँट करना। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","जो अनाज ख़ुद बख़ुद उगता है उस की कटाई न करना और जो अंगूर उस साल लगते हैं उनको तोड़कर जमा न करना, क्योंकि ज़मीन को एक साल के लिए आराम करना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","अलबत्ता जो भी यह ज़मीन आराम के साल में पैदा करेगी उससे तुम अपनी रोज़ाना की ज़रूरियात पूरी कर सकते हो यानी तू, तेरे ग़ुलाम और लौंडियाँ, तेरे मज़दूर, तेरे ग़ैरशहरी, तेरे साथ रहनेवाले परदेसी, ");
INSERT INTO urdgvh_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","तेरे मवेशी और तेरी ज़मीन पर रहनेवाले जंगली जानवर। जो कुछ भी यह ज़मीन पैदा करती है वह खाया जा सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","सात सबत के साल यानी 49 साल के बाद एक और काम करना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","पचासवें साल के सातवें महीने के दसवें दिन यानी कफ़्फ़ारा के दिन अपने मुल्क की हर जगह नरसिंगा बजाना। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","पचासवाँ साल मख़सूसो-मुक़द्दस करो और पूरे मुल्क में एलान करो कि तमाम बाशिंदों को आज़ाद कर दिया जाए। यह बहाली का साल हो जिसमें हर शख़्स को उस की मिलकियत वापस की जाए और हर ग़ुलाम को आज़ाद किया जाए ताकि वह अपने रिश्तेदारों के पास वापस जा सके। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","यह पचासवाँ साल बहाली का साल हो, इसलिए न अपने खेतों में बीज बोना, न ख़ुद बख़ुद उगनेवाले अनाज की कटाई करना, और न अंगूर तोड़कर जमा करना। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","क्योंकि यह बहाली का साल है जो तुम्हारे लिए मख़सूसो-मुक़द्दस है। रोज़ाना उतनी ही पैदावार लेना कि एक दिन की ज़रूरियात पूरी हो जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","बहाली के साल में हर शख़्स को उस की मिलकियत वापस की जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","चुनाँचे जब कभी तुम अपने किसी हमवतन भाई को ज़मीन बेचते या उससे ख़रीदते हो तो उससे नाजायज़ फ़ायदा न उठाना। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","ज़मीन की क़ीमत इस हिसाब से मुक़र्रर की जाए कि वह अगले बहाली के साल तक कितने साल फ़सलें पैदा करेगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","अगर बहुत साल रह गए हों तो उस की क़ीमत ज़्यादा होगी, और अगर कम साल रह गए हों तो उस की क़ीमत कम होगी। क्योंकि उन फ़सलों की तादाद बिक रही है जो ज़मीन अगले बहाली के साल तक पैदा कर सकती है। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","अपने हमवतन से नाजायज़ फ़ायदा न उठाना बल्कि रब अपने ख़ुदा का ख़ौफ़ मानना, क्योंकि मैं रब तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","मेरी हिदायात पर अमल करना और मेरे अहकाम को मानकर उनके मुताबिक़ चलना। तब तुम अपने मुल्क में महफ़ूज़ रहोगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ज़मीन अपनी पूरी पैदावार देगी, तुम सेर हो जाओगे और महफ़ूज़ रहोगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","हो सकता है कोई पूछे, ‘हम सातवें साल में क्या खाएँगे जबकि हम बीज नहीं बोएँगे और फ़सल नहीं काटेंगे?’ ");
INSERT INTO urdgvh_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","जवाब यह है कि मैं छटे साल में ज़मीन को इतनी बरकत दूँगा कि उस साल की पैदावार तीन साल के लिए काफ़ी होगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","जब तुम आठवें साल बीज बोओगे तो तुम्हारे पास छटे साल की इतनी पैदावार बाक़ी होगी कि तुम फ़सल की कटाई तक गुज़ारा कर सकोगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","कोई ज़मीन भी हमेशा के लिए न बेची जाए, क्योंकि मुल्क की तमाम ज़मीन मेरी ही है। तुम मेरे हुज़ूर सिर्फ़ परदेसी और ग़ैरशहरी हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","मुल्क में जहाँ भी ज़मीन बिक जाए वहाँ मौरूसी मालिक का यह हक़ माना जाए कि वह अपनी ज़मीन वापस ख़रीद सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","अगर तेरा कोई हमवतन भाई ग़रीब होकर अपनी कुछ ज़मीन बेचने पर मजबूर हो जाए तो लाज़िम है कि उसका सबसे क़रीबी रिश्तेदार उसे वापस ख़रीद ले। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","हो सकता है कि ऐसे शख़्स का कोई क़रीबी रिश्तेदार न हो जो उस की ज़मीन वापस ख़रीद सके, लेकिन वह ख़ुद कुछ देर के बाद इतने पैसे जमा करता है कि वह अपनी ज़मीन वापस ख़रीद सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","इस सूरत में वह हिसाब करे कि ख़रीदनेवाले के लिए अगले बहाली के साल तक कितने साल रह गए हैं। जितना नुक़सान ख़रीदनेवाले को ज़मीन को बहाली के साल से पहले वापस देने से पहुँचेगा उतने ही पैसे उसे देने हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","लेकिन अगर उसके पास इतने पैसे न हों तो ज़मीन अगले बहाली के साल तक ख़रीदनेवाले के हाथ में रहेगी। फिर उसे मौरूसी मालिक को वापस दिया जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","अगर किसी का घर फ़सीलदार शहर में है तो जब वह उसे बेचेगा तो अपना घर वापस ख़रीदने का हक़ सिर्फ़ एक साल तक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","अगर पहला मालिक उसे पहले साल के अंदर अंदर न ख़रीदे तो वह हमेशा के लिए ख़रीदनेवाले की मौरूसी मिलकियत बन जाएगा। वह बहाली के साल में भी वापस नहीं किया जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","लेकिन जो घर ऐसी आबादी में है जिसकी फ़सील न हो वह देहात में शुमार किया जाता है। उसके मौरूसी मालिक को हक़ हासिल है कि हर वक़्त अपना घर वापस ख़रीद सके। बहाली के साल में इस घर को लाज़िमन वापस कर देना है। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","लेकिन लावियों को यह हक़ हासिल है कि वह अपने वह घर हर वक़्त ख़रीद सकते हैं जो उनके लिए मुक़र्रर किए हुए शहरों में हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","अगर ऐसा घर किसी लावी के हाथ फ़रोख़्त किया जाए और वापस न ख़रीदा जाए तो उसे लाज़िमन बहाली के साल में वापस करना है। क्योंकि लावी के जो घर उनके मुक़र्ररा शहरों में होते हैं वह इसराईलियों में उनकी मौरूसी मिलकियत हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","लेकिन जो ज़मीनें शहरों के इर्दगिर्द मवेशी चराने के लिए मुक़र्रर हैं उन्हें बेचने की इजाज़त नहीं है। वह उनकी दायमी मिलकियत हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","अगर तेरा कोई हमवतन भाई ग़रीब हो जाए और गुज़ारा न कर सके तो उस की मदद कर। उस तरह उस की मदद करना जिस तरह परदेसी या ग़ैरशहरी की मदद करनी होती है ताकि वह तेरे साथ रहते हुए ज़िंदगी गुज़ार सके। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","उससे किसी तरह का सूद न लेना बल्कि अपने ख़ुदा का ख़ौफ़ मानना ताकि तेरा भाई तेरे साथ ज़िंदगी गुज़ार सके। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","अगर वह तेरा क़र्ज़दार हो तो उससे सूद न लेना। इसी तरह ख़ुराक बेचते वक़्त उससे नफ़ा न लेना। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","मैं रब तुम्हारा ख़ुदा हूँ। मैं तुम्हें इसलिए मिसर से निकाल लाया कि तुम्हें मुल्के-कनान दूँ और तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","अगर तेरा कोई इसराईली भाई ग़रीब होकर अपने आपको तेरे हाथ बेच डाले तो उससे ग़ुलाम का-सा काम न कराना। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","उसके साथ मज़दूर या ग़ैरशहरी का-सा सुलूक करना। वह तेरे लिए बहाली के साल तक काम करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","फिर वह और उसके बाल-बच्चे आज़ाद होकर अपने रिश्तेदारों और मौरूसी ज़मीन के पास वापस जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","चूँकि इसराईली मेरे ख़ादिम हैं जिन्हें मैं मिसर से निकाल लाया इसलिए उन्हें ग़ुलामी में न बेचा जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ऐसे लोगों पर सख़्ती से हुक्मरानी न करना बल्कि अपने ख़ुदा का ख़ौफ़ मानना। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","तुम पड़ोसी ममालिक से अपने लिए ग़ुलाम और लौंडियाँ हासिल कर सकते हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","जो परदेसी ग़ैरशहरी के तौर पर तुम्हारे मुल्क में आबाद हैं उन्हें भी तुम ख़रीद सकते हो। उनमें वह भी शामिल हैं जो तुम्हारे मुल्क में पैदा हुए हैं। वही तुम्हारी मिलकियत बनकर ");
INSERT INTO urdgvh_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","तुम्हारे बेटों की मीरास में आ जाएँ और वही हमेशा तुम्हारे ग़ुलाम रहें। लेकिन अपने हमवतन भाइयों पर सख़्त हुक्मरानी न करना। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","अगर तेरे मुल्क में रहनेवाला कोई परदेसी या ग़ैरशहरी अमीर हो जाए जबकि तेरा कोई हमवतन भाई ग़रीब होकर अपने आपको उस परदेसी या ग़ैरशहरी या उसके ख़ानदान के किसी फ़रद को बेच डाले ");
INSERT INTO urdgvh_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","तो बिक जाने के बाद उसे आज़ादी ख़रीदने का हक़ हासिल है। कोई भाई, ");
INSERT INTO urdgvh_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","चचा, ताया, चचा या ताया का बेटा या कोई और क़रीबी रिश्तेदार उसे वापस ख़रीद सकता है। वह ख़ुद भी अपनी आज़ादी ख़रीद सकता है अगर उसके पास पैसे काफ़ी हों। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","इस सूरत में वह अपने मालिक से मिलकर वह साल गिने जो उसके ख़रीदने से लेकर अगले बहाली के साल तक बाक़ी हैं। उस की आज़ादी के पैसे उस क़ीमत पर मबनी हों जो मज़दूर को इतने सालों के लिए दिए जाते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","52","जितने साल बाक़ी रह गए हैं उनके मुताबिक़ उस की बिक जाने की क़ीमत में से पैसे वापस कर दिए जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","उसके साथ साल बसाल मज़दूर का-सा सुलूक किया जाए। उसका मालिक उस पर सख़्त हुक्मरानी न करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","अगर वह इस तरह के किसी तरीक़े से आज़ाद न हो जाए तो उसे और उसके बच्चों को हर हालत में अगले बहाली के साल में आज़ाद कर देना है, ");
INSERT INTO urdgvh_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","क्योंकि इसराईली मेरे ही ख़ादिम हैं। वह मेरे ही ख़ादिम हैं जिन्हें मैं मिसर से निकाल लाया। मैं रब तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","अपने लिए बुत न बनाना। न अपने लिए देवता के मुजस्समे या पत्थर के मख़सूस किए हुए सतून खड़े करना, न सिजदा करने के लिए अपने मुल्क में ऐसे पत्थर रखना जिनमें देवता की तस्वीर कंदा की गई हो। मैं रब तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","सबत का दिन मनाना और मेरे मक़दिस की ताज़ीम करना। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","अगर तुम मेरी हिदायात पर चलो और मेरे अहकाम मानकर उन पर अमल करो ");
INSERT INTO urdgvh_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","तो मैं वक़्त पर बारिश भेजूँगा, ज़मीन अपनी पैदावार देगी और दरख़्त अपने अपने फल लाएँगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","कसरत के बाइस अनाज की फ़सल की कटाई अंगूर तोड़ते वक़्त तक जारी रहेगी और अंगूर की फ़सल उस वक़्त तक तोड़ी जाएगी जब तक बीज बोने का मौसम आएगा। इतनी ख़ुराक मिलेगी कि तुम कभी भूके नहीं होगे। और तुम अपने मुल्क में महफ़ूज़ रहोगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","मैं मुल्क को अमनो-अमान बख़्शूँगा। तुम आराम से लेट जाओगे, क्योंकि किसी ख़तरे से डरने की ज़रूरत नहीं होगी। मैं वहशी जानवर मुल्क से दूर कर दूँगा, और वह तलवार की क़त्लो-ग़ारत से बचा रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","तुम अपने दुश्मनों पर ग़ालिब आकर उनका ताक़्क़ुब करोगे, और वह तुम्हारी तलवार से मारे जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","तुम्हारे पाँच आदमी सौ दुश्मनों का पीछा करेंगे, और तुम्हारे सौ आदमी उनके दस हज़ार आदमियों को भगा देंगे। तुम्हारे दुश्मन तुम्हारी तलवार से मारे जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","मेरी नज़रे-करम तुम पर होगी। मैं तुम्हारी औलाद की तादाद बढ़ाऊँगा और तुम्हारे साथ अपना अहद क़ायम रखूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","एक साल इतनी फ़सल होगी कि जब अगली फ़सल की कटाई होगी तो नए अनाज के लिए जगह बनाने की ख़ातिर पुराने अनाज को फेंक देना पड़ेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","मैं तुम्हारे दरमियान अपना मसकन क़ायम करूँगा और तुमसे घिन नहीं खाऊँगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","मैं तुममें फिरूँगा, और तुम मेरी क़ौम होगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","मैं रब तुम्हारा ख़ुदा हूँ जो तुम्हें मिसर से निकाल लाया ताकि तुम्हारी ग़ुलामी की हालत ख़त्म हो जाए। मैंने तुम्हारे जुए को तोड़ डाला, और अब तुम आज़ाद और सीधे होकर चल सकते हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","लेकिन अगर तुम मेरी नहीं सुनोगे और इन तमाम अहकाम पर नहीं चलोगे, ");
INSERT INTO urdgvh_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","अगर तुम मेरी हिदायात को रद्द करके मेरे अहकाम से घिन खाओगे और उन पर अमल न करके मेरा अहद तोड़ोगे ");
INSERT INTO urdgvh_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","तो मैं जवाब में तुम पर अचानक दहशत तारी कर दूँगा। जिस्म को ख़त्म करनेवाली बीमारियों और बुख़ार से तुम्हारी आँखें ज़ाया हो जाएँगी और तुम्हारी जान छिन जाएगी। जब तुम बीज बोओगे तो बेफ़ायदा, क्योंकि दुश्मन उस की फ़सल खा जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","मैं तुम्हारे ख़िलाफ़ हो जाऊँगा, इसलिए तुम अपने दुश्मनों के हाथ से शिकस्त खाओगे। तुमसे नफ़रत रखनेवाले तुम पर हुकूमत करेंगे। उस वक़्त भी जब कोई तुम्हारा ताक़्क़ुब नहीं करेगा तुम भाग जाओगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","अगर तुम इसके बाद भी मेरी न सुनो तो मैं तुम्हारे गुनाहों के सबब से तुम्हें सात गुना ज़्यादा सज़ा दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","मैं तुम्हारा सख़्त ग़ुरूर ख़ाक में मिला दूँगा। तुम्हारे ऊपर आसमान लोहे जैसा और तुम्हारे नीचे ज़मीन पीतल जैसी होगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","जितनी भी मेहनत करोगे वह बेफ़ायदा होगी, क्योंकि तुम्हारे खेतों में फ़सलें नहीं पकेंगी और तुम्हारे दरख़्त फल नहीं लाएँगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","अगर तुम फिर भी मेरी मुख़ालफ़त करोगे और मेरी नहीं सुनोगे तो मैं इन गुनाहों के जवाब में तुम्हें इससे भी सात गुना ज़्यादा सज़ा दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","मैं तुम्हारे ख़िलाफ़ जंगली जानवर भेज दूँगा जो तुम्हारे बच्चों को फाड़ खाएँगे और तुम्हारे मवेशी बरबाद कर देंगे। आख़िर में तुम्हारी तादाद इतनी कम हो जाएगी कि तुम्हारी सड़कें वीरान हो जाएँगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","अगर तुम फिर भी मेरी तरबियत क़बूल न करो बल्कि मेरे मुख़ालिफ़ रहो ");
INSERT INTO urdgvh_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","तो मैं ख़ुद तुम्हारे ख़िलाफ़ हो जाऊँगा। इन गुनाहों के जवाब में मैं तुम्हें सात गुना ज़्यादा सज़ा दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","मैं तुम पर तलवार चलाकर इसका बदला लूँगा कि तुमने मेरे अहद को तोड़ा है। जब तुम अपनी हिफ़ाज़त के लिए शहरों में भागकर जमा होगे तो मैं तुम्हारे दरमियान वबाई बीमारियाँ फैलाऊँगा और तुम्हें दुश्मनों के हाथ में दे दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","अनाज की इतनी कमी होगी कि दस औरतें तुम्हारी पूरी रोटी एक ही तनूर में पका सकेंगी, और वह उसे बड़ी एहतियात से तोल तोलकर तक़सीम करेंगी। तुम खाकर भी भूके रहोगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","अगर तुम फिर भी मेरी नहीं सुनोगे बल्कि मेरे मुख़ालिफ़ रहोगे ");
INSERT INTO urdgvh_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","तो मेरा ग़ुस्सा भड़केगा और मैं तुम्हारे ख़िलाफ़ होकर तुम्हारे गुनाहों के जवाब में तुम्हें सात गुना ज़्यादा सज़ा दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","तुम मुसीबत के बाइस अपने बेटे-बेटियों का गोश्त खाओगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","मैं तुम्हारी ऊँची जगहों की क़ुरबानगाहें और तुम्हारी बख़ूर की क़ुरबानगाहें बरबाद कर दूँगा। मैं तुम्हारी लाशों के ढेर तुम्हारे बेजान बुतों पर लगाऊँगा और तुमसे घिन खाऊँगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","मैं तुम्हारे शहरों को खंडरात में बदलकर तुम्हारे मंदिरों को बरबाद करूँगा। तुम्हारी क़ुरबानियों की ख़ुशबू मुझे पसंद नहीं आएगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","मैं तुम्हारे मुल्क का सत्यानास यों करूँगा कि जो दुश्मन उसमें आबाद हो जाएंगे उनके रोंगटे खड़े हो जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","मैं तुम्हें मुख़्तलिफ़ ममालिक में मुंतशिर कर दूँगा, लेकिन वहाँ भी अपनी तलवार को हाथ में लिए तुम्हारा पीछा करूँगा। तुम्हारी ज़मीन वीरान होगी और तुम्हारे शहर खंडरात बन जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","उस वक़्त जब तुम अपने दुश्मनों के मुल्क में रहोगे तुम्हारी ज़मीन वीरान हालत में आराम के वह साल मना सकेगी जिनसे वह महरूम रही है। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","उन तमाम दिनों में जब वह बरबाद रहेगी उसे वह आराम मिलेगा जो उसे न मिला जब तुम मुल्क में रहते थे। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","तुममें से जो बचकर अपने दुश्मनों के ममालिक में रहेंगे उनके दिलों पर मैं दहशत तारी करूँगा। वह हवा के झोंकों से गिरनेवाले पत्ते की आवाज़ से चौंककर भाग जाएंगे। वह फ़रार होंगे गोया कोई हाथ में तलवार लिए उनका ताक़्क़ुब कर रहा हो। और वह गिरकर मर जाएंगे हालाँकि कोई उनका पीछा नहीं कर रहा होगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","वह एक दूसरे से टकराकर लड़खड़ाएँगे गोया कोई तलवार लेकर उनके पीछे चल रहा हो हालाँकि कोई नहीं है। चुनाँचे तुम अपने दुश्मनों का सामना नहीं कर सकोगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","तुम दीगर क़ौमों में मुंतशिर होकर हलाक हो जाओगे, और तुम्हारे दुश्मनों की ज़मीन तुम्हें हड़प कर लेगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","तुममें से बाक़ी लोग अपने और अपने बापदादा के क़ुसूर के बाइस अपने दुश्मनों के ममालिक में गल-सड़ जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","लेकिन एक वक़्त आएगा कि वह अपने और अपने बापदादा का क़ुसूर मान लेंगे। वह मेरे साथ अपनी बेवफ़ाई और वह मुख़ालफ़त तसलीम करेंगे ");
INSERT INTO urdgvh_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","जिसके सबब से मैं उनके ख़िलाफ़ हुआ और उन्हें उनके दुश्मनों के मुल्क में धकेल दिया था। पहले उनका ख़तना सिर्फ़ ज़ाहिरी तौर पर हुआ था, लेकिन अब उनका दिल आजिज़ हो जाएगा और वह अपने क़ुसूर की क़ीमत अदा करेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","फिर मैं इब्राहीम के साथ अपना अहद, इसहाक़ के साथ अपना अहद और याक़ूब के साथ अपना अहद याद करूँगा। मैं मुल्के-कनान भी याद करूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","लेकिन पहले वह ज़मीन को छोड़ेंगे ताकि वह उनकी ग़ैरमौजूदगी में वीरान होकर आराम के साल मनाए। यों इसराईली अपने क़ुसूर के नतीजे भुगतेंगे, इस सबब से कि उन्होंने मेरे अहकाम रद्द किए और मेरी हिदायात से घिन खाई। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","इसके बावुजूद भी मैं उन्हें दुश्मनों के मुल्क में छोड़कर रद्द नहीं करूँगा, न यहाँ तक उनसे घिन खाऊँगा कि वह बिलकुल तबाह हो जाएँ। क्योंकि मैं उनके साथ अपना अहद नहीं तोड़ने का। मैं रब उनका ख़ुदा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","मैं उनकी ख़ातिर उनके बापदादा के साथ बँधा हुआ अहद याद करूँगा, उन लोगों के साथ अहद जिन्हें मैं दूसरी क़ौमों के देखते देखते मिसर से निकाल लाया ताकि उनका ख़ुदा हूँ। मैं रब हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","रब ने मूसा को इसराईलियों के लिए यह तमाम हिदायात और अहकाम सीना पहाड़ पर दिए। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“इसराईलियों को बताना कि अगर किसी ने मन्नत मानकर किसी को रब के लिए मख़सूस किया हो तो वह उसे ज़ैल की रक़म देकर आज़ाद कर सकता है (मुस्तामल सिक्के मक़दिस के सिक्कों के बराबर हों) : ");
INSERT INTO urdgvh_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","उस आदमी के लिए जिसकी उम्र 20 और 60 साल के दरमियान है चाँदी के 50 सिक्के, ");
INSERT INTO urdgvh_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","इसी उम्र की औरत के लिए चाँदी के 30 सिक्के, ");
INSERT INTO urdgvh_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","उस लड़के के लिए जिसकी उम्र 5 और 20 साल के दरमियान हो चाँदी के 20 सिक्के, इसी उम्र की लड़की के लिए चाँदी के 10 सिक्के, ");
INSERT INTO urdgvh_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","एक माह से लेकर 5 साल तक के लड़के के लिए चाँदी के 5 सिक्के, इसी उम्र की लड़की के लिए चाँदी के 3 सिक्के, ");
INSERT INTO urdgvh_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","साठ साल से बड़े आदमी के लिए चाँदी के 15 सिक्के और इसी उम्र की औरत के लिए चाँदी के 10 सिक्के। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","अगर मन्नत माननेवाला मुक़र्ररा रक़म अदा न कर सके तो वह मख़सूस किए हुए शख़्स को इमाम के पास ले आए। फिर इमाम ऐसी रक़म मुक़र्रर करे जो मन्नत माननेवाला अदा कर सके। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","अगर किसी ने मन्नत मानकर ऐसा जानवर मख़सूस किया जो रब की क़ुरबानियों के लिए इस्तेमाल हो सकता है तो ऐसा जानवर मख़सूसो-मुक़द्दस हो जाता है। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","वह उसे बदल नहीं सकता। न वह अच्छे जानवर की जगह नाक़िस, न नाक़िस जानवर की जगह अच्छा जानवर दे। अगर वह एक जानवर दूसरे की जगह दे तो दोनों मख़सूसो-मुक़द्दस हो जाते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","अगर किसी ने मन्नत मानकर कोई नापाक जानवर मख़सूस किया जो रब की क़ुरबानियों के लिए इस्तेमाल नहीं हो सकता तो वह उसको इमाम के पास ले आए। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","इमाम उस की रक़म उस की अच्छी और बुरी सिफ़्तों का लिहाज़ करके मुक़र्रर करे। इस मुक़र्ररा क़ीमत में कमी बेशी नहीं हो सकती। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","अगर मन्नत माननेवाला उसे वापस ख़रीदना चाहे तो वह मुक़र्ररा क़ीमत जमा 20 फ़ीसद अदा करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","अगर कोई अपना घर रब के लिए मख़सूसो-मुक़द्दस करे तो इमाम उस की अच्छी और बुरी सिफ़्तों का लिहाज़ करके उस की रक़म मुक़र्रर करे। इस मुक़र्ररा क़ीमत में कमी बेशी नहीं हो सकती। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","अगर घर को मख़सूस करनेवाला उसे वापस ख़रीदना चाहे तो वह मुक़र्ररा रक़म जमा 20 फ़ीसद अदा करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","अगर कोई अपनी मौरूसी ज़मीन में से कुछ रब के लिए मख़सूसो-मुक़द्दस करे तो उस की क़ीमत उस बीज की मिक़दार के मुताबिक़ मुक़र्रर की जाए जो उसमें बोना होता है। जिस खेत में 135 किलोग्राम जौ का बीज बोया जाए उस की क़ीमत चाँदी के 50 सिक्के होगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","शर्त यह है कि वह अपनी ज़मीन बहाली के साल के ऐन बाद मख़सूस करे। फिर उस की यही क़ीमत मुक़र्रर की जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","अगर ज़मीन का मालिक उसे बहाली के साल के कुछ देर बाद मख़सूस करे तो इमाम अगले बहाली के साल तक रहनेवाले सालों के मुताबिक़ ज़मीन की क़ीमत मुक़र्रर करे। जितने कम साल बाक़ी हैं उतनी कम उस की क़ीमत होगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","अगर मख़सूस करनेवाला अपनी ज़मीन वापस ख़रीदना चाहे तो वह मुक़र्ररा क़ीमत जमा 20 फ़ीसद अदा करे। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","अगर मख़सूस करनेवाला अपनी ज़मीन को रब से वापस ख़रीदे बग़ैर उसे किसी और को बेचे तो उसे वापस ख़रीदने का हक़ ख़त्म हो जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","अगले बहाली के साल यह ज़मीन मख़सूसो-मुक़द्दस रहेगी और रब की दायमी मिलकियत हो जाएगी। चुनाँचे वह इमाम की मिलकियत होगी। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","अगर कोई अपना मौरूसी खेत नहीं बल्कि अपना ख़रीदा हुआ खेत रब के लिए मख़सूस करे ");
INSERT INTO urdgvh_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","तो इमाम अगले बहाली के साल तक रहनेवाले सालों का लिहाज़ करके उस की क़ीमत मुक़र्रर करे। खेत का मालिक उसी दिन उसके पैसे अदा करे। यह पैसे रब के लिए मख़सूसो-मुक़द्दस होंगे। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","बहाली के साल में यह खेत उस शख़्स के पास वापस आएगा जिसने उसे बेचा था। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","वापस ख़रीदने के लिए मुस्तामल सिक्के मक़दिस के सिक्कों के बराबर हों। उसके चाँदी के सिक्कों का वज़न 11 ग्राम है। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","लेकिन कोई भी किसी मवेशी का पहलौठा रब के लिए मख़सूस नहीं कर सकता। वह तो पहले से रब के लिए मख़सूस है। इसमें कोई फ़रक़ नहीं कि वह गाय, बैल या भेड़ हो। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","अगर उसने कोई नापाक जानवर मख़सूस किया हो तो वह उसे मुक़र्ररा क़ीमत जमा 20 फ़ीसद के लिए वापस ख़रीद सकता है। अगर वह उसे वापस न ख़रीदे तो वह मुक़र्ररा क़ीमत के लिए बेचा जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","लेकिन अगर किसी ने अपनी मिलकियत में से कुछ ग़ैरमशरूत तौर पर रब के लिए मख़सूस किया है तो उसे बेचा या वापस नहीं ख़रीदा जा सकता, ख़ाह वह इनसान, जानवर या ज़मीन हो। जो इस तरह मख़सूस किया गया हो वह रब के लिए निहायत मुक़द्दस है। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","इसी तरह जिस शख़्स को तबाही के लिए मख़सूस किया गया है उसका फ़िद्या नहीं दिया जा सकता। लाज़िम है कि उसे सज़ाए-मौत दी जाए। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","हर फ़सल का दसवाँ हिस्सा रब का है, चाहे वह अनाज हो या फल। वह रब के लिए मख़सूसो-मुक़द्दस है। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","अगर कोई अपनी फ़सल का दसवाँ हिस्सा छुड़ाना चाहता है तो वह इसके लिए उस की मुक़र्ररा क़ीमत जमा 20 फ़ीसद दे। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","इसी तरह गाय-बैलों और भेड़-बकरियों का दसवाँ हिस्सा भी रब के लिए मख़सूसो-मुक़द्दस है, हर दसवाँ जानवर जो गल्लाबान के डंडे के नीचे से गुज़रेगा। ");
INSERT INTO urdgvh_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","यह जानवर चुनने से पहले उनका मुआयना न किया जाए कि कौन-से जानवर अच्छे या कमज़ोर हैं। यह भी न करना कि दसवें हिस्से के किसी जानवर के बदले कोई और जानवर दिया जाए। अगर फिर भी उसे बदला जाए तो दोनों जानवर रब के लिए मख़सूसो-मुक़द्दस होंगे। और उन्हें वापस ख़रीदा नहीं जा सकता।” ");
INSERT INTO urdgvh_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","यह वह अहकाम हैं जो रब ने सीना पहाड़ पर मूसा को इसराईलियों के लिए दिए। ");
INSERT INTO urdgvh_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","इसराईलियों को मिसर से निकले हुए एक साल से ज़्यादा अरसा गुज़र गया था। अब तक वह दश्ते-सीना में थे। दूसरे साल के दूसरे महीने के पहले दिन रब मुलाक़ात के ख़ैमे में मूसा से हमकलाम हुआ। उसने कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“तू और हारून तमाम इसराईलियों की मर्दुमशुमारी कुंबों और आबाई घरानों के मुताबिक़ करना। उन तमाम मर्दों की फ़हरिस्त बनाना ");
INSERT INTO urdgvh_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","जो कम अज़ कम बीस साल के और जंग लड़ने के क़ाबिल हों। ");
INSERT INTO urdgvh_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","इसमें हर क़बीले के एक ख़ानदान का सरपरस्त तुम्हारी मदद करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","यह उनके नाम हैं : रूबिन के क़बीले से इलीसूर बिन शदियूर, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","शमौन के क़बीले से सलूमियेल बिन सूरीशद्दी, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","यहूदाह के क़बीले से नहसोन बिन अम्मीनदाब, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","इशकार के क़बीले से नतनियेल बिन ज़ुग़र, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ज़बूलून के क़बीले से इलियाब बिन हेलोन, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","यूसुफ़ के बेटे इफ़राईम के क़बीले से इलीसमा बिन अम्मीहूद, यूसुफ़ के बेटे मनस्सी के क़बीले से जमलियेल बिन फ़दाहसूर, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","बिनयमीन के क़बीले से अबिदान बिन जिदौनी, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","दान के क़बीले से अख़ियज़र बिन अम्मीशद्दी, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","आशर के क़बीले से फ़जियेल बिन अकरान, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","जद के क़बीले से इलियासफ़ बिन दऊएल, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","नफ़ताली के क़बीले से अख़ीरा बिन एनान।” ");
INSERT INTO urdgvh_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","यही मर्द जमात से इस काम के लिए बुलाए गए। वह अपने क़बीलों के राहनुमा और कुंबों के सरपरस्त थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","इनकी मदद से मूसा और हारून ने ");
INSERT INTO urdgvh_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","उसी दिन पूरी जमात को इकट्ठा किया। हर इसराईली मर्द जो कम अज़ कम 20 साल का था रजिस्टर में दर्ज किया गया। रजिस्टर की तरतीब उनके कुंबों और आबाई घरानों के मुताबिक़ थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","सब कुछ वैसा ही किया गया जैसा रब ने हुक्म दिया था। मूसा ने सीना के रेगिस्तान में लोगों की मर्दुमशुमारी की। नतीजा यह निकला : ");
INSERT INTO urdgvh_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","21","रूबिन के क़बीले के 46,500 मर्द, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","शमौन के क़बीले के 59,300 मर्द, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","जद के क़बीले के 45,650 मर्द, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","यहूदाह के क़बीले के 74,600 मर्द, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","इशकार के क़बीले के 54,400 मर्द, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","ज़बूलून के क़बीले के 57,400 मर्द, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","33","यूसुफ़ के बेटे इफ़राईम के क़बीले के 40,500 मर्द, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","35","यूसुफ़ के बेटे मनस्सी के क़बीले के 32,200 मर्द, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","बिनयमीन के क़बीले के 35,400 मर्द, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","दान के क़बीले के 62,700 मर्द, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","आशर के क़बीले के 41,500 मर्द, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","नफ़ताली के क़बीले के 53,400 मर्द। ");
INSERT INTO urdgvh_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","मूसा, हारून और क़बीलों के बारह राहनुमाओं ने इन तमाम आदमियों को गिना। ");
INSERT INTO urdgvh_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","46","उनकी पूरी तादाद 6,03,550 थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","लेकिन लावियों की मर्दुमशुमारी न हुई, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","क्योंकि रब ने मूसा से कहा था, ");
INSERT INTO urdgvh_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“इसराईलियों की मर्दुमशुमारी में लावियों को शामिल न करना। ");
INSERT INTO urdgvh_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","इसके बजाए उन्हें शरीअत की सुकूनतगाह और उसका सारा सामान सँभालने की ज़िम्मादारी देना। वह सफ़र करते वक़्त यह ख़ैमा और उसका सारा सामान उठाकर ले जाएँ, उस की ख़िदमत के लिए हाज़िर रहें और रुकते वक़्त उसे अपने ख़ैमों से घेरे रखें। ");
INSERT INTO urdgvh_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","रवाना होते वक़्त वही ख़ैमे को समेटें और रुकते वक़्त वही उसे लगाएँ। अगर कोई और उसके क़रीब आए तो उसे सज़ाए-मौत दी जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","बाक़ी इसराईली ख़ैमागाह में अपने अपने दस्ते के मुताबिक़ और अपने अपने अलम के इर्दगिर्द अपने ख़ैमे लगाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","लेकिन लावी अपने ख़ैमों से शरीअत की सुकूनतगाह को घेर लें ताकि मेरा ग़ज़ब किसी ग़लत शख़्स के नज़दीक आने से इसराईलियों की जमात पर नाज़िल न हो जाए। यों लावियों को शरीअत की सुकूनतगाह को सँभालना है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","इसराईलियों ने वैसा ही किया जैसा रब ने मूसा को हुक्म दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","रब ने मूसा और हारून से कहा ");
INSERT INTO urdgvh_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","कि इसराईली अपने ख़ैमे कुछ फ़ासले पर मुलाक़ात के ख़ैमे के इर्दगिर्द लगाएँ। हर एक अपने अपने अलम और अपने अपने आबाई घराने के निशान के साथ ख़ैमाज़न हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","इन हिदायात के मुताबिक़ मक़दिस के मशरिक़ में यहूदाह का अलम था जिसके इर्दगिर्द तीन दस्ते ख़ैमाज़न थे। पहले, यहूदाह का क़बीला जिसका कमाँडर नहसोन बिन अम्मीनदाब था, ");
INSERT INTO urdgvh_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","और जिसके लशकर के 74,600 फ़ौजी थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","दूसरे, इशकार का क़बीला जिसका कमाँडर नतनियेल बिन ज़ुग़र था, ");
INSERT INTO urdgvh_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","और जिसके लशकर के 54,400 फ़ौजी थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","तीसरे, ज़बूलून का क़बीला जिसका कमाँडर इलियाब बिन हेलोन था ");
INSERT INTO urdgvh_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","और जिसके लशकर के 57,400 फ़ौजी थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","तीनों क़बीलों के फ़ौजियों की कुल तादाद 1,86,400 थी। रवाना होते वक़्त यह आगे चलते थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","मक़दिस के जुनूब में रूबिन का अलम था जिसके इर्दगिर्द तीन दस्ते ख़ैमाज़न थे। पहले, रूबिन का क़बीला जिसका कमाँडर इलीसूर बिन शदियूर था, ");
INSERT INTO urdgvh_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","और जिसके 46,500 फ़ौजी थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","दूसरे, शमौन का क़बीला जिसका कमाँडर सलूमियेल बिन सूरीशद्दी था, ");
INSERT INTO urdgvh_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","और जिसके 59,300 फ़ौजी थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","तीसरे, जद का क़बीला जिसका कमाँडर इलियासफ़ बिन दऊएल था, ");
INSERT INTO urdgvh_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","और जिसके 45,650 फ़ौजी थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","तीनों क़बीलों के फ़ौजियों की कुल तादाद 1,51,450 थी। रवाना होते वक़्त यह मशरिक़ी क़बीलों के पीछे चलते थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","इन जुनूबी क़बीलों के बाद लावी मुलाक़ात का ख़ैमा उठाकर क़बीलों के ऐन बीच में चलते थे। क़बीले उस तरतीब से रवाना होते थे जिस तरतीब से वह अपने ख़ैमे लगाते थे। हर क़बीला अपने अलम के पीछे चलता था। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","मक़दिस के मग़रिब में इफ़राईम का अलम था जिसके इर्दगिर्द तीन दस्ते ख़ैमाज़न थे। पहले, इफ़राईम का क़बीला जिसका कमाँडर इलीसमा बिन अम्मीहूद था, ");
INSERT INTO urdgvh_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","और जिसके 40,500 फ़ौजी थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","दूसरे, मनस्सी का क़बीला जिसका कमाँडर जमलियेल बिन फ़दाहसूर था, ");
INSERT INTO urdgvh_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","और जिसके 32,200 फ़ौजी थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","तीसरे, बिनयमीन का क़बीला जिसका कमाँडर अबिदान बिन जिदौनी था, ");
INSERT INTO urdgvh_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","और जिसके 35,400 फ़ौजी थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","तीनों क़बीलों के फ़ौजियों की कुल तादाद 1,08,100 थी। रवाना होते वक़्त यह जुनूबी क़बीलों के पीछे चलते थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","मक़दिस के शिमाल में दान का अलम था जिसके इर्दगिर्द तीन दस्ते ख़ैमाज़न थे। पहले, दान का क़बीला जिसका कमाँडर अख़ियज़र बिन अम्मीशद्दी था, ");
INSERT INTO urdgvh_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","और जिसके 62,700 फ़ौजी थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","दूसरे, आशर का क़बीला जिसका कमाँडर फ़जियेल बिन अकरान था, ");
INSERT INTO urdgvh_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","और जिसके 41,500 फ़ौजी थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","तीसरे, नफ़ताली का क़बीला जिसका कमाँडर अख़ीरा बिन एनान था, ");
INSERT INTO urdgvh_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","और जिसके 53,400 फ़ौजी थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","तीनों क़बीलों की कुल तादाद 1,57,600 थी। वह आख़िर में अपना अलम उठाकर रवाना होते थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","पूरी ख़ैमागाह के फ़ौजियों की कुल तादाद 6,03,550 थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","सिर्फ़ लावी इस तादाद में शामिल नहीं थे, क्योंकि रब ने मूसा को हुक्म दिया था कि उनकी भरती न की जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","यों इसराईलियों ने सब कुछ उन हिदायात के मुताबिक़ किया जो रब ने मूसा को दी थीं। उनके मुताबिक़ ही वह अपने झंडों के इर्दगिर्द अपने ख़ैमे लगाते थे और उनके मुताबिक़ ही अपने कुंबों और आबाई घरानों के साथ रवाना होते थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","यह हारून और मूसा के ख़ानदान का बयान है। उस वक़्त का ज़िक्र है जब रब ने सीना पहाड़ पर मूसा से बात की। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","हारून के चार बेटे थे। बड़ा बेटा नदब था, फिर अबीहू, इलियज़र और इतमर। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","यह इमाम थे जिनको मसह करके इस ख़िदमत का इख़्तियार दिया गया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","लेकिन नदब और अबीहू उस वक़्त मर गए जब उन्होंने दश्ते-सीना में रब के हुज़ूर नाजायज़ आग पेश की। चूँकि वह बेऔलाद थे इसलिए हारून के जीते-जी सिर्फ़ इलियज़र और इतमर इमाम की ख़िदमत सरंजाम देते थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“लावी के क़बीले को लाकर हारून की ख़िदमत करने की ज़िम्मादारी दे। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","उन्हें उसके लिए और पूरी जमात के लिए मुलाक़ात के ख़ैमे की ख़िदमात सँभालना है। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","वह मुलाक़ात के ख़ैमे का सामान सँभालें और तमाम इसराईलियों के लिए मक़दिस के फ़रायज़ अदा करें। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","तमाम इसराईलियों में से सिर्फ़ लावियों को हारून और उसके बेटों की ख़िदमत के लिए मुक़र्रर कर। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","लेकिन सिर्फ़ हारून और उसके बेटों को इमाम की हैसियत हासिल है। जो भी बाक़ियों में से उनकी ज़िम्मादारियाँ उठाने की कोशिश करेगा उसे सज़ाए-मौत दी जाएगी।” ");
INSERT INTO urdgvh_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","रब ने मूसा से यह भी कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“मैंने इसराईलियों में से लावियों को चुन लिया है। वह तमाम इसराईली पहलौठों के एवज़ मेरे लिए मख़सूस हैं, ");
INSERT INTO urdgvh_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","क्योंकि तमाम पहलौठे मेरे ही हैं। जिस दिन मैंने मिसर में तमाम पहलौठों को मार दिया उस दिन मैंने इसराईल के पहलौठों को अपने लिए मख़सूस किया, ख़ाह वह इनसान के थे या हैवान के। वह मेरे ही हैं। मैं रब हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","रब ने सीना के रेगिस्तान में मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“लावियों को गिनकर उनके आबाई घरानों और कुंबों के मुताबिक़ रजिस्टर में दर्ज करना। हर बेटे को गिनना है जो एक माह या इससे ज़ायद का है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","मूसा ने ऐसा ही किया। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","लावी के तीन बेटे जैरसोन, क़िहात और मिरारी थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","जैरसोन के दो कुंबे उसके बेटों लिबनी और सिमई के नाम रखते थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","क़िहात के चार कुंबे उसके बेटों अमराम, इज़हार, हबरून और उज़्ज़ियेल के नाम रखते थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","मिरारी के दो कुंबे उसके बेटों महली और मूशी के नाम रखते थे। ग़रज़ लावी के क़बीले के कुंबे उसके पोतों के नाम रखते थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","जैरसोन के दो कुंबों बनाम लिबनी और सिमई ");
INSERT INTO urdgvh_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","के 7,500 मर्द थे जो एक माह या इससे ज़ायद के थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","उन्हें अपने ख़ैमे मग़रिब में मक़दिस के पीछे लगाने थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","उनका राहनुमा इलियासफ़ बिन लाएल था, ");
INSERT INTO urdgvh_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","और वह ख़ैमे को सँभालते थे यानी उस की पोशिशें, ख़ैमे के दरवाज़े का परदा, ");
INSERT INTO urdgvh_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ख़ैमे और क़ुरबानगाह की चारदीवारी के परदे, चारदीवारी के दरवाज़े का परदा और तमाम रस्से। इन चीज़ों से मुताल्लिक़ सारी ख़िदमत उनकी ज़िम्मादारी थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","क़िहात के चार कुंबों बनाम अमराम, इज़हार, हबरून और उज़्ज़ियेल ");
INSERT INTO urdgvh_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","के 8,600 मर्द थे जो एक माह या इससे ज़ायद के थे और जिनको मक़दिस की ख़िदमत करनी थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","उन्हें अपने डेरे मक़दिस के जुनूब में डालने थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","उनका राहनुमा इलीसफ़न बिन उज़्ज़ियेल था, ");
INSERT INTO urdgvh_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","और वह यह चीज़ें सँभालते थे : अहद का संदूक़, मेज़, शमादान, क़ुरबानगाहें, वह बरतन और साज़ो-सामान जो मक़दिस में इस्तेमाल होता था और मुक़द्दसतरीन कमरे का परदा। इन चीज़ों से मुताल्लिक़ सारी ख़िदमत उनकी ज़िम्मादारी थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","हारून इमाम का बेटा इलियज़र लावियों के तमाम राहनुमाओं पर मुक़र्रर था। वह उन तमाम लोगों का इंचार्ज था जो मक़दिस की देख-भाल करते थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","मिरारी के दो कुंबों बनाम महली और मूशी ");
INSERT INTO urdgvh_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","के 6,200 मर्द थे जो एक माह या इससे ज़ायद के थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","उनका राहनुमा सूरियेल बिन अबीख़ैल था। उन्हें अपने डेरे मक़दिस के शिमाल में डालने थे, ");
INSERT INTO urdgvh_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","और वह यह चीज़ें सँभालते थे : ख़ैमे के तख़्ते, उसके शहतीर, खंबे, पाए और इस तरह का सारा सामान। इन चीज़ों से मुताल्लिक़ सारी ख़िदमत उनकी ज़िम्मादारी थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","वह चारदीवारी के खंबे, पाए, मेख़ें और रस्से भी सँभालते थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","मूसा, हारून और उनके बेटों को अपने डेरे मशरिक़ में मक़दिस के सामने डालने थे। उनकी ज़िम्मादारी मक़दिस में बनी इसराईल के लिए ख़िदमत करना थी। उनके अलावा जो भी मक़दिस में दाख़िल होने की कोशिश करता उसे सज़ाए-मौत देनी थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","उन लावी मर्दों की कुल तादाद जो एक माह या इससे ज़ायद के थे 22,000 थी। रब के कहने पर मूसा और हारून ने उन्हें कुंबों के मुताबिक़ गिनकर रजिस्टर में दर्ज किया। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","रब ने मूसा से कहा, “तमाम इसराईली पहलौठों को गिनना जो एक माह या इससे ज़ायद के हैं और उनके नाम रजिस्टर में दर्ज करना। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","उन तमाम पहलौठों की जगह लावियों को मेरे लिए मख़सूस करना। इसी तरह इसराईलियों के मवेशियों के पहलौठों की जगह लावियों के मवेशी मेरे लिए मख़सूस करना। मैं रब हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","मूसा ने ऐसा ही किया जैसा रब ने उसे हुक्म दिया। उसने तमाम इसराईली पहलौठे ");
INSERT INTO urdgvh_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","जो एक माह या इससे ज़ायद के थे गिन लिए। उनकी कुल तादाद 22,273 थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“मुझे तमाम इसराईली पहलौठों की जगह लावियों को पेश करना। इसी तरह मुझे इसराईलियों के मवेशियों की जगह लावियों के मवेशी पेश करना। लावी मेरे ही हैं। मैं रब हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","लावियों की निसबत बाक़ी इसराईलियों के 273 पहलौठे ज़्यादा हैं। उनमें से ");
INSERT INTO urdgvh_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","हर एक के एवज़ चाँदी के पाँच सिक्के ले जो मक़दिस के वज़न के मुताबिक़ हों (फ़ी सिक्का तक़रीबन 11 ग्राम)। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","यह पैसे हारून और उसके बेटों को देना।” ");
INSERT INTO urdgvh_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","मूसा ने ऐसा ही किया। ");
INSERT INTO urdgvh_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","यों उसने चाँदी के 1,365 सिक्के (तक़रीबन 16 किलोग्राम) जमा करके ");
INSERT INTO urdgvh_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","हारून और उसके बेटों को दिए, जिस तरह रब ने उसे हुक्म दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","रब ने मूसा और हारून से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“लावी के क़बीले में से क़िहातियों की मर्दुमशुमारी उनके कुंबों और आबाई घरानों के मुताबिक़ करना। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","उन तमाम मर्दों को रजिस्टर में दर्ज करना जो 30 से लेकर 50 साल के हैं और मुलाक़ात के ख़ैमे में ख़िदमत करने के लिए आ सकते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","क़िहातियों की ख़िदमत मुक़द्दसतरीन कमरे की देख-भाल है। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","जब ख़ैमे को सफ़र के लिए समेटना है तो हारून और उसके बेटे दाख़िल होकर मुक़द्दसतरीन कमरे का परदा उतारें और उसे शरीअत के संदूक़ पर डाल दें। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","इस पर वह तख़स की खालों का ग़िलाफ़ और आख़िर में पूरी तरह नीले रंग का कपड़ा बिछाएँ। इसके बाद वह संदूक़ को उठाने की लकड़ियाँ लगाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","वह उस मेज़ पर भी नीले रंग का कपड़ा बिछाएँ जिस पर रब को रोटी पेश की जाती है। उस पर थाल, प्याले, मै की नज़रें पेश करने के बरतन और मरतबान रखे जाएँ। जो रोटी हमेशा मेज़ पर होती है वह भी उस पर रहे। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","हारून और उसके बेटे इन तमाम चीज़ों पर क़िरमिज़ी रंग का कपड़ा बिछाकर आख़िर में उनके ऊपर तख़स की खालों का ग़िलाफ़ डालें। इसके बाद वह मेज़ को उठाने की लकड़ियाँ लगाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","वह शमादान और उसके सामान पर यानी उसके चराग़, बत्ती कतरने की क़ैंचियों, जलते कोयले के छोटे बरतनों और तेल के बरतनों पर नीले रंग का कपड़ा रखें। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","यह सब कुछ वह तख़स की खालों के ग़िलाफ़ में लपेटें और उसे उठाकर ले जाने के लिए एक चौखटे पर रखें। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","वह बख़ूर जलाने की सोने की क़ुरबानगाह पर भी नीले रंग का कपड़ा बिछाकर उस पर तख़स की खालों का ग़िलाफ़ डालें और फिर उसे उठाने की लकड़ियाँ लगाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","वह सारा सामान जो मुक़द्दस कमरे में इस्तेमाल होता है लेकर नीले रंग के कपड़े में लपेटें, उस पर तख़स की खालों का ग़िलाफ़ डालें और उसे उठाकर ले जाने के लिए एक चौखटे पर रखें। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","फिर वह जानवरों को जलाने की क़ुरबानगाह को राख से साफ़ करके उस पर अरग़वानी रंग का कपड़ा बिछाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","उस पर वह क़ुरबानगाह की ख़िदमत के लिए सारा ज़रूरी सामान रखें यानी छिड़काव के कटोरे, जलते हुए कोयले के बरतन, बेलचे और काँटे। इस सामान पर वह तख़स की खालों का ग़िलाफ़ डालकर क़ुरबानगाह को उठाने की लकड़ियाँ लगाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","सफ़र के लिए रवाना होते वक़्त यह सब कुछ उठाकर ले जाना क़िहातियों की ज़िम्मादारी है। लेकिन लाज़िम है कि पहले हारून और उसके बेटे यह तमाम मुक़द्दस चीज़ें ढाँपें। क़िहाती इनमें से कोई भी चीज़ न छुएँ वरना मर जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","हारून इमाम का बेटा इलियज़र पूरे मुक़द्दस ख़ैमे और उसके सामान का इंचार्ज हो। इसमें चराग़ों का तेल, बख़ूर, ग़ल्ला की रोज़ाना नज़र और मसह का तेल भी शामिल है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","रब ने मूसा और हारून से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“ख़बरदार रहो कि क़िहात के कुंबे लावी के क़बीले में से मिटने न पाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","चुनाँचे जब वह मुक़द्दसतरीन चीज़ों के पास आएँ तो हारून और उसके बेटे हर एक को उस सामान के पास ले जाएँ जो उसे उठाकर ले जाना है ताकि वह न मरें बल्कि जीते रहें। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","क़िहाती एक लमहे के लिए भी मुक़द्दस चीज़ें देखने के लिए अंदर न जाएँ, वरना वह मर जाएंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","फिर रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“जैरसोन की औलाद की मर्दुमशुमारी भी उनके आबाई घरानों और कुंबों के मुताबिक़ करना। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","उन तमाम मर्दों को रजिस्टर में दर्ज करना जो 30 से लेकर 50 साल के हैं और मुलाक़ात के ख़ैमे में ख़िदमत के लिए आ सकते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","वह यह चीज़ें उठाकर ले जाने के ज़िम्मादार हैं : ");
INSERT INTO urdgvh_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","मुलाक़ात का ख़ैमा, उस की छत, छत पर रखी हुई तख़स की खाल की पोशिश, ख़ैमे के दरवाज़े का परदा, ");
INSERT INTO urdgvh_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ख़ैमे और क़ुरबानगाह की चारदीवारी के परदे, चारदीवारी के दरवाज़े का परदा, उसके रस्से और उसे लगाने का बाक़ी सामान। वह उन तमाम कामों के ज़िम्मादार हैं जो इन चीज़ों से मुंसलिक हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","जैरसोनियों की पूरी ख़िदमत हारून और उसके बेटों की हिदायात के मुताबिक़ हो। ख़बरदार रहो कि वह सब कुछ ऐन हिदायात के मुताबिक़ उठाकर ले जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","यह सब मुलाक़ात के ख़ैमे में जैरसोनियों की ज़िम्मादारियाँ हैं। इस काम में हारून इमाम का बेटा इतमर उन पर मुक़र्रर है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","रब ने कहा, “मिरारी की औलाद की मर्दुमशुमारी भी उनके आबाई घरानों और कुंबों के मुताबिक़ करना। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","उन तमाम मर्दों को रजिस्टर में दर्ज करना जो 30 से लेकर 50 साल के हैं और मुलाक़ात के ख़ैमे में ख़िदमत के लिए आ सकते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","वह मुलाक़ात के ख़ैमे की यह चीज़ें उठाकर ले जाने के ज़िम्मादार हैं : दीवार के तख़्ते, शहतीर, खंबे और पाए, ");
INSERT INTO urdgvh_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","फिर ख़ैमे की चारदीवारी के खंबे, पाए, मेख़ें, रस्से और यह चीज़ें लगाने का सामान। हर एक को तफ़सील से बताना कि वह क्या क्या उठाकर ले जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","यह सब कुछ मिरारियों की मुलाक़ात के ख़ैमे में ज़िम्मादारियों में शामिल है। इस काम में हारून इमाम का बेटा इतमर उन पर मुक़र्रर हो।” ");
INSERT INTO urdgvh_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","मूसा, हारून और जमात के राहनुमाओं ने क़िहातियों की मर्दुमशुमारी उनके कुंबों और आबाई घरानों के मुताबिक़ की। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","37","उन्होंने उन तमाम मर्दों को रजिस्टर में दर्ज किया जो 30 से लेकर 50 साल के थे और जो मुलाक़ात के ख़ैमे में ख़िदमत कर सकते थे। उनकी कुल तादाद 2,750 थी। मूसा और हारून ने सब कुछ वैसा ही किया जैसा रब ने मूसा की मारिफ़त फ़रमाया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","41","फिर जैरसोनियों की मर्दुमशुमारी उनके कुंबों और आबाई घरानों के मुताबिक़ हुई। ख़िदमत के लायक़ मर्दों की कुल तादाद 2,630 थी। मूसा और हारून ने सब कुछ वैसा ही किया जैसा रब ने मूसा के ज़रीए फ़रमाया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","45","फिर मिरारियों की मर्दुमशुमारी उनके कुंबों और आबाई घरानों के मुताबिक़ हुई। ख़िदमत के लायक़ मर्दों की कुल तादाद 3,200 थी। मूसा और हारून ने सब कुछ वैसा ही किया जैसा रब ने मूसा के ज़रीए फ़रमाया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","48","लावियों के उन मर्दों की कुल तादाद 8,580 थी जिन्हें मुलाक़ात के ख़ैमे में ख़िदमत करना और सफ़र करते वक़्त उसे उठाकर ले जाना था। ");
INSERT INTO urdgvh_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","मूसा ने रब के हुक्म के मुताबिक़ हर एक को उस की अपनी अपनी ज़िम्मादारी सौंपी और उसे बताया कि उसे क्या क्या उठाकर ले जाना है। यों उनकी मर्दुमशुमारी रब के उस हुक्म के ऐन मुताबिक़ की गई जो उसने मूसा की मारिफ़त दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“इसराईलियों को हुक्म दे कि हर उस शख़्स को ख़ैमागाह से बाहर कर दो जिसको वबाई जिल्दी बीमारी है, जिसके ज़ख़मों से माए निकलता रहता है या जो किसी लाश को छूने से नापाक है। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ख़ाह मर्द हो या औरत, सबको ख़ैमागाह के बाहर भेज देना ताकि वह ख़ैमागाह को नापाक न करें जहाँ मैं तुम्हारे दरमियान सुकूनत करता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","इसराईलियों ने वैसा ही किया जैसा रब ने मूसा को कहा था। उन्होंने रब के हुक्म के ऐन मुताबिक़ इस तरह के तमाम लोगों को ख़ैमागाह से बाहर कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“इसराईलियों को हिदायत देना कि जो भी किसी से ग़लत सुलूक करे वह मेरे साथ बेवफ़ाई करता है और क़ुसूरवार है, ख़ाह मर्द हो या औरत। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","लाज़िम है कि वह अपना गुनाह तसलीम करे और उसका पूरा मुआवज़ा दे बल्कि मुतअस्सिरा शख़्स का नुक़सान पूरा करने के अलावा 20 फ़ीसद ज़्यादा दे। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","लेकिन अगर वह शख़्स जिसका क़ुसूर किया गया था मर चुका हो और उसका कोई वारिस न हो जो यह मुआवज़ा वसूल कर सके तो फिर उसे रब को देना है। इमाम को यह मुआवज़ा उस मेंढे के अलावा मिलेगा जो क़ुसूरवार अपने कफ़्फ़ारा के लिए देगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","10","नीज़ इमाम को इसराईलियों की क़ुरबानियों में से वह कुछ मिलना है जो उठानेवाली क़ुरबानी के तौर पर उसे दिया जाता है। यह हिस्सा सिर्फ़ इमामों को ही मिलना है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“इसराईलियों को बताना, हो सकता है कि कोई शादीशुदा औरत भटककर अपने शौहर से बेवफ़ा हो जाए और ");
INSERT INTO urdgvh_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","किसी और से हमबिसतर होकर नापाक हो जाए। उसके शौहर ने उसे नहीं देखा, क्योंकि यह पोशीदगी में हुआ है और न किसी ने उसे पकड़ा, न इसका कोई गवाह है। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","अगर शौहर को अपनी बीवी की वफ़ादारी पर शक हो और वह ग़ैरत खाने लगे, लेकिन यक़ीन से नहीं कह सकता कि मेरी बीवी क़ुसूरवार है कि नहीं ");
INSERT INTO urdgvh_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","तो वह अपनी बीवी को इमाम के पास ले आए। साथ साथ वह अपनी बीवी के लिए क़ुरबानी के तौर पर जौ का डेढ़ किलोग्राम बेहतरीन मैदा ले आए। इस पर न तेल उंडेला जाए, न बख़ूर डाला जाए, क्योंकि ग़ल्ला की यह नज़र ग़ैरत की नज़र है जिसका मक़सद है कि पोशीदा क़ुसूर ज़ाहिर हो जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","इमाम औरत को क़रीब आने दे और रब के सामने खड़ा करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","वह मिट्टी का बरतन मुक़द्दस पानी से भरकर उसमें मक़दिस के फ़र्श की कुछ ख़ाक डाले। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","फिर वह औरत को रब को पेश करके उसके बाल खुलवाए और उसके हाथों पर मैदे की नज़र रखे। इमाम के अपने हाथ में कड़वे पानी का वह बरतन हो जो लानत का बाइस है। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","फिर वह औरत को क़सम खिलाकर कहे, ‘अगर कोई और आदमी आपसे हमबिसतर नहीं हुआ है और आप नापाक नहीं हुई हैं तो इस कड़वे पानी की लानत का आप पर कोई असर न हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","लेकिन अगर आप भटककर अपने शौहर से बेवफ़ा हो गई हैं और किसी और से हमबिसतर होकर नापाक हो गई हैं ");
INSERT INTO urdgvh_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","तो रब आपको आपकी क़ौम के सामने लानती बनाए। आप बाँझ हो जाएँ और आपका पेट फूल जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","जब लानत का यह पानी आपके पेट में उतरे तो आप बाँझ हो जाएँ और आपका पेट फूल जाए।’ इस पर औरत कहे, ‘आमीन, ऐसा ही हो।’ ");
INSERT INTO urdgvh_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","फिर इमाम यह लानत लिखकर काग़ज़ को बरतन के पानी में यों धो दे कि उस पर लिखी हुई बातें पानी में घुल जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","बाद में वह औरत को यह पानी पिलाए ताकि वह उसके जिस्म में जाकर उसे लानत पहुँचाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","लेकिन पहले इमाम उसके हाथों में से ग़ैरत की क़ुरबानी लेकर उसे ग़ल्ला की नज़र के तौर पर रब के सामने हिलाए और फिर क़ुरबानगाह के पास ले आए। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","उस पर वह मुट्ठी-भर यादगारी की क़ुरबानी के तौर पर जलाए। इसके बाद वह औरत को पानी पिलाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","अगर वह अपने शौहर से बेवफ़ा थी और नापाक हो गई है तो वह बाँझ हो जाएगी, उसका पेट फूल जाएगा और वह अपनी क़ौम के सामने लानती ठहरेगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","लेकिन अगर वह पाक-साफ़ है तो उसे सज़ा नहीं दी जाएगी और वह बच्चे जन्म देने के क़ाबिल रहेगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","30","चुनाँचे ऐसा ही करना है जब शौहर ग़ैरत खाए और उसे अपनी बीवी पर ज़िना का शक हो। बीवी को क़ुरबानगाह के सामने खड़ा किया जाए और इमाम यह सब कुछ करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","इस सूरत में शौहर बेक़ुसूर ठहरेगा, लेकिन अगर उस की बीवी ने वाक़ई ज़िना किया हो तो उसे अपने गुनाह के नतीजे बरदाश्त करने पड़ेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“इसराईलियों को हिदायत देना कि अगर कोई आदमी या औरत मन्नत मानकर अपने आपको एक मुक़र्ररा वक़्त के लिए रब के लिए मख़सूस करे ");
INSERT INTO urdgvh_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","तो वह मै या कोई और नशा-आवर चीज़ न पिए। न वह अंगूर या किसी और चीज़ का सिरका पिए, न अंगूर का रस। वह अंगूर या किशमिश न खाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","जब तक वह मख़सूस है वह अंगूर की कोई भी पैदावार न खाए, यहाँ तक कि अंगूर के बीज या छिलके भी न खाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","जब तक वह अपनी मन्नत के मुताबिक़ मख़सूस है वह अपने बाल न कटवाए। जितनी देर के लिए उसने अपने आपको रब के लिए मख़सूस किया है उतनी देर तक वह मुक़द्दस है। इसलिए वह अपने बाल बढ़ने दे। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","जब तक वह मख़सूस है वह किसी लाश के क़रीब न जाए, ");
INSERT INTO urdgvh_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","चाहे वह उसके बाप, माँ, भाई या बहन की लाश क्यों न हो। क्योंकि इससे वह नापाक हो जाएगा जबकि अभी तक उस की मख़सूसियत लंबे बालों की सूरत में नज़र आती है। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","वह अपनी मख़सूसियत के दौरान रब के लिए मख़सूसो-मुक़द्दस है। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","अगर कोई अचानक मर जाए जब मख़सूस शख़्स उसके क़रीब हो तो उसके मख़सूस बाल नापाक हो जाएंगे। ऐसी सूरत में लाज़िम है कि वह अपने आपको पाक-साफ़ करके सातवें दिन अपने सर को मुँडवाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","आठवें दिन वह दो क़ुम्रियाँ या दो जवान कबूतर लेकर मुलाक़ात के ख़ैमे के दरवाज़े पर आए और इमाम को दे। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","इमाम इनमें से एक को गुनाह की क़ुरबानी के तौर पर चढ़ाए और दूसरे को भस्म होनेवाली क़ुरबानी के तौर पर। यों वह उसके लिए कफ़्फ़ारा देगा जो लाश के क़रीब होने से नापाक हो गया है। उसी दिन वह अपने सर को दुबारा मख़सूस करे ");
INSERT INTO urdgvh_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","और अपने आपको मुक़र्ररा वक़्त के लिए दुबारा रब के लिए मख़सूस करे। वह क़ुसूर की क़ुरबानी के तौर पर एक साल का भेड़ का बच्चा पेश करे। जितने दिन उसने पहले मख़सूसियत की हालत में गुज़ारे हैं वह शुमार नहीं किए जा सकते क्योंकि वह मख़सूसियत की हालत में नापाक हो गया था। वह दुबारा पहले दिन से शुरू करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","शरीअत के मुताबिक़ जब मख़सूस शख़्स का मुक़र्ररा वक़्त गुज़र गया हो तो पहले उसे मुलाक़ात के ख़ैमे के दरवाज़े पर लाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","वहाँ वह रब को भस्म होनेवाली क़ुरबानी के लिए भेड़ का एक बेऐब यकसाला नर बच्चा, गुनाह की क़ुरबानी के लिए एक बेऐब यकसाला भेड़ और सलामती की क़ुरबानी के लिए एक बेऐब मेंढा पेश करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","इसके अलावा वह एक टोकरी में बेख़मीरी रोटियाँ जिनमें बेहतरीन मैदा और तेल मिलाया गया हो और बेख़मीरी रोटियाँ जिन पर तेल लगाया गया हो मुताल्लिक़ा ग़ल्ला की नज़र और मै की नज़र के साथ ");
INSERT INTO urdgvh_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","रब को पेश करे। पहले इमाम गुनाह की क़ुरबानी और भस्म होनेवाली क़ुरबानी रब के हुज़ूर चढ़ाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","फिर वह मेंढे को बेख़मीरी रोटियों के साथ सलामती की क़ुरबानी के तौर पर पेश करे। इमाम ग़ल्ला की नज़र और मै की नज़र भी चढ़ाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","इस दौरान मख़सूस शख़्स मुलाक़ात के ख़ैमे पर अपने मख़सूस किए गए सर को मुँडवाकर तमाम बाल सलामती की क़ुरबानी की आग में फेंके। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","फिर इमाम मेंढे का एक पका हुआ शाना और टोकरी में से दोनों क़िस्मों की एक एक रोटी लेकर मख़सूस शख़्स के हाथों पर रखे। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","इसके बाद वह यह चीज़ें वापस लेकर उन्हें हिलाने की क़ुरबानी के तौर पर रब के सामने हिलाए। यह एक मुक़द्दस क़ुरबानी है जो इमाम का हिस्सा है। सलामती की क़ुरबानी का हिलाया हुआ सीना और उठाई हुई रान भी इमाम का हिस्सा हैं। क़ुरबानी के इख़्तिताम पर मख़सूस किए हुए शख़्स को मै पीने की इजाज़त है। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","जो अपने आपको रब के लिए मख़सूस करता है वह ऐसा ही करे। लाज़िम है कि वह इन हिदायात के मुताबिक़ तमाम क़ुरबानियाँ पेश करे। अगर गुंजाइश हो तो वह और भी पेश कर सकता है। बहरहाल लाज़िम है कि वह अपनी मन्नत और यह हिदायात पूरी करे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“हारून और उसके बेटों को बता देना कि वह इसराईलियों को यों बरकत दें, ");
INSERT INTO urdgvh_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘रब तुझे बरकत दे और तेरी हिफ़ाज़त करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","रब अपने चेहरे का मेहरबान नूर तुझ पर चमकाए और तुझ पर रहम करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","रब की नज़रे-करम तुझ पर हो, और वह तुझे सलामती बख़्शे।’ ");
INSERT INTO urdgvh_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","यों वह मेरा नाम लेकर इसराईलियों को बरकत दें। फिर मैं उन्हें बरकत दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","जिस दिन मक़दिस मुकम्मल हुआ उसी दिन मूसा ने उसे मख़सूसो-मुक़द्दस किया। इसके लिए उसने ख़ैमे, उसके तमाम सामान, क़ुरबानगाह और उसके तमाम सामान पर तेल छिड़का। ");
INSERT INTO urdgvh_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","3","फिर क़बीलों के बारह सरदार मक़दिस के लिए हदिये लेकर आए। यह वही राहनुमा थे जिन्होंने मर्दुमशुमारी के वक़्त मूसा की मदद की थी। उन्होंने छतवाली छ: बैलगाड़ियाँ और बारह बैल ख़ैमे के सामने रब को पेश किए, दो दो सरदारों की तरफ़ से एक बैलगाड़ी और हर एक सरदार की तरफ़ से एक बैल। ");
INSERT INTO urdgvh_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“यह तोह्फ़े क़बूल करके मुलाक़ात के ख़ैमे के काम के लिए इस्तेमाल कर। उन्हें लावियों में उनकी ख़िदमत की ज़रूरत के मुताबिक़ तक़सीम करना।” ");
INSERT INTO urdgvh_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","चुनाँचे मूसा ने बैलगाड़ियाँ और बैल लावियों को दे दिए। ");
INSERT INTO urdgvh_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","उसने दो बैलगाड़ियाँ चार बैलों समेत जैरसोनियों को ");
INSERT INTO urdgvh_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","और चार बैलगाड़ियाँ आठ बैलों समेत मिरारियों को दीं। मिरारी हारून इमाम के बेटे इतमर के तहत ख़िदमत करते थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","लेकिन मूसा ने क़िहातियों को न बैलगाड़ियाँ और न बैल दिए। वजह यह थी कि जो मुक़द्दस चीज़ें उनके सुपुर्द थीं वह उनको कंधों पर उठाकर ले जानी थीं। ");
INSERT INTO urdgvh_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","बारह सरदार क़ुरबानगाह की मख़सूसियत के मौक़े पर भी हदिये ले आए। उन्होंने अपने हदिये क़ुरबानगाह के सामने पेश किए। ");
INSERT INTO urdgvh_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","रब ने मूसा से कहा, “सरदार बारह दिन के दौरान बारी बारी अपने हदिये पेश करें।” ");
INSERT INTO urdgvh_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","पहले दिन यहूदाह के सरदार नहसोन बिन अम्मीनदाब की बारी थी। उसके हदिये यह थे : ");
INSERT INTO urdgvh_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","चाँदी का थाल जिसका वज़न डेढ़ किलोग्राम था और छिड़काव का चाँदी का कटोरा जिसका वज़न 800 ग्राम था। दोनों ग़ल्ला की नज़र के लिए तेल के साथ मिलाए गए बेहतरीन मैदे से भरे हुए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","इनके अलावा नहसोन ने यह चीज़ें पेश कीं : सोने का प्याला जिसका वज़न 110 ग्राम था और जो बख़ूर से भरा हुआ था, ");
INSERT INTO urdgvh_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","एक जवान बैल, एक मेंढा, भस्म होनेवाली क़ुरबानी के लिए भेड़ का एक यकसाला बच्चा, ");
INSERT INTO urdgvh_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","गुनाह की क़ुरबानी के लिए एक बकरा ");
INSERT INTO urdgvh_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","और सलामती की क़ुरबानी के लिए दो बैल, पाँच मेंढे, पाँच बकरे और भेड़ के पाँच यकसाला बच्चे। ");
INSERT INTO urdgvh_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","23","अगले ग्यारह दिन बाक़ी सरदार भी यही हदिये मक़दिस के पास ले आए। दूसरे दिन इशकार के सरदार नतनियेल बिन ज़ुग़र की बारी थी, ");
INSERT INTO urdgvh_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","29","तीसरे दिन ज़बूलून के सरदार इलियाब बिन हेलोन की, ");
INSERT INTO urdgvh_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","47","चौथे दिन रूबिन के सरदार इलीसूर बिन शदियूर की, पाँचवें दिन शमौन के सरदार सलूमियेल बिन सूरीशद्दी की, छटे दिन जद के सरदार इलियासफ़ बिन दऊएल की, ");
INSERT INTO urdgvh_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","53","सातवें दिन इफ़राईम के सरदार इलीसमा बिन अम्मीहूद की, ");
INSERT INTO urdgvh_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","71","आठवें दिन मनस्सी के सरदार जमलियेल बिन फ़दाहसूर की, नवें दिन बिनयमीन के सरदार अबिदान बिन जिदौनी की, दसवें दिन दान के सरदार अख़ियज़र बिन अम्मीशद्दी की, ");
INSERT INTO urdgvh_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","83","ग्यारहवें दिन आशर के सरदार फ़जियेल बिन अकरान की और बारहवें दिन नफ़ताली के सरदार अख़ीरा बिन एनान की बारी थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","इसराईल के इन सरदारों ने मिलकर क़ुरबानगाह की मख़सूसियत के लिए चाँदी के 12 थाल, छिड़काव के चाँदी के 12 कटोरे और सोने के 12 प्याले पेश किए। ");
INSERT INTO urdgvh_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","हर थाल का वज़न डेढ़ किलोग्राम और छिड़काव के हर कटोरे का वज़न 800 ग्राम था। इन चीज़ों का कुल वज़न तक़रीबन 28 किलोग्राम था। ");
INSERT INTO urdgvh_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","बख़ूर से भरे हुए सोने के प्यालों का कुल वज़न तक़रीबन डेढ़ किलोग्राम था (फ़ी प्याला 110 ग्राम)। ");
INSERT INTO urdgvh_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","सरदारों ने मिलकर भस्म होनेवाली क़ुरबानी के लिए 12 जवान बैल, 12 मेंढे और भेड़ के 12 यकसाला बच्चे उनकी ग़ल्ला की नज़रों समेत पेश किए। गुनाह की क़ुरबानी के लिए उन्होंने 12 बकरे पेश किए ");
INSERT INTO urdgvh_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","और सलामती की क़ुरबानी के लिए 24 बैल, 60 मेंढे, 60 बकरे और भेड़ के 60 यकसाला बच्चे। इन तमाम जानवरों को क़ुरबानगाह की मख़सूसियत के मौक़े पर चढ़ाया गया। ");
INSERT INTO urdgvh_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","जब मूसा मुलाक़ात के ख़ैमे में रब के साथ बात करने के लिए दाख़िल होता था तो वह रब की आवाज़ अहद के संदूक़ के ढकने पर से यानी दो करूबी फ़रिश्तों के दरमियान से सुनता था। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“हारून को बताना, ‘तुझे सात चराग़ों को शमादान पर यों रखना है कि वह शमादान का सामनेवाला हिस्सा रौशन करें’।” ");
INSERT INTO urdgvh_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","हारून ने ऐसा ही किया। जिस तरह रब ने मूसा को हुक्म दिया था उसी तरह उसने चराग़ों को रख दिया ताकि वह सामनेवाला हिस्सा रौशन करें। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","शमादान पाए से लेकर ऊपर की कलियों तक सोने के एक घड़े हुए टुकड़े का बना हुआ था। मूसा ने उसे उस नमूने के ऐन मुताबिक़ बनवाया जो रब ने उसे दिखाया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“लावियों को दीगर इसराईलियों से अलग करके पाक-साफ़ करना। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","इसके लिए गुनाह से पाक करनेवाला पानी उन पर छिड़ककर उन्हें हुक्म देना कि अपने जिस्म के पूरे बाल मुँडवाओ और अपने कपड़े धोओ। यों वह पाक-साफ़ हो जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","फिर वह एक जवान बैल चुनें और साथ की ग़ल्ला की नज़र के लिए तेल के साथ मिलाया गया बेहतरीन मैदा लें। तू ख़ुद भी एक जवान बैल चुन। वह गुनाह की क़ुरबानी के लिए होगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","इसके बाद लावियों को मुलाक़ात के ख़ैमे के सामने खड़ा करके इसराईल की पूरी जमात को वहाँ जमा करना। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","जब लावी रब के सामने खड़े हों तो बाक़ी इसराईली उनके सरों पर अपने हाथ रखें। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","फिर हारून लावियों को रब के सामने पेश करे। उन्हें इसराईलियों की तरफ़ से हिलाई हुई क़ुरबानी की हैसियत से पेश किया जाए ताकि वह रब की ख़िदमत कर सकें। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","फिर लावी अपने हाथ दोनों बैलों के सरों पर रखें। एक बैल को गुनाह की क़ुरबानी के तौर पर और दूसरे को भस्म होनेवाली क़ुरबानी के तौर पर चढ़ाओ ताकि लावियों का कफ़्फ़ारा दिया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","लावियों को इस तरीक़े से हारून और उसके बेटों के सामने खड़ा करके रब को हिलाई हुई क़ुरबानी के तौर पर पेश करना है। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","उन्हें बाक़ी इसराईलियों से अलग करने से वह मेरा हिस्सा बनेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","इसके बाद ही वह मुलाक़ात के ख़ैमे में आकर ख़िदमत करें, क्योंकि अब वह ख़िदमत करने के लायक़ हैं। उन्हें पाक-साफ़ करके हिलाई हुई क़ुरबानी के तौर पर पेश करने का सबब यह है ");
INSERT INTO urdgvh_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","कि लावी इसराईलियों में से वह हैं जो मुझे पूरे तौर पर दिए गए हैं। मैंने उन्हें इसराईलियों के तमाम पहलौठों की जगह ले लिया है। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","क्योंकि इसराईल में हर पहलौठा मेरा है, ख़ाह वह इनसान का हो या हैवान का। उस दिन जब मैंने मिसरियों के पहलौठों को मार दिया मैंने इसराईल के पहलौठों को अपने लिए मख़सूसो-मुक़द्दस किया। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","इस सिलसिले में मैंने लावियों को इसराईलियों के तमाम पहलौठों की जगह लेकर ");
INSERT INTO urdgvh_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","उन्हें हारून और उसके बेटों को दिया है। वह मुलाक़ात के ख़ैमे में इसराईलियों की ख़िदमत करें और उनके लिए कफ़्फ़ारा का इंतज़ाम क़ायम रखें ताकि जब इसराईली मक़दिस के क़रीब आएँ तो उनको वबा से मारा न जाए।” ");
INSERT INTO urdgvh_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","मूसा, हारून और इसराईलियों की पूरी जमात ने एहतियात से रब की लावियों के बारे में हिदायात पर अमल किया। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","लावियों ने अपने आपको गुनाहों से पाक-साफ़ करके अपने कपड़ों को धोया। फिर हारून ने उन्हें रब के सामने हिलाई हुई क़ुरबानी के तौर पर पेश किया और उनका कफ़्फ़ारा दिया ताकि वह पाक हो जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","इसके बाद लावी मुलाक़ात के ख़ैमे में आए ताकि हारून और उसके बेटों के तहत ख़िदमत करें। यों सब कुछ वैसा ही किया गया जैसा रब ने मूसा को हुक्म दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","रब ने मूसा से यह भी कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“लावी 25 साल की उम्र में मुलाक़ात के ख़ैमे में अपनी ख़िदमत शुरू करें ");
INSERT INTO urdgvh_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","और 50 साल की उम्र में रिटायर हो जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","इसके बाद वह मुलाक़ात के ख़ैमे में अपने भाइयों की मदद कर सकते हैं, लेकिन ख़ुद ख़िदमत नहीं कर सकते। तुझे लावियों को इन हिदायात के मुताबिक़ उनकी अपनी अपनी ज़िम्मादारियाँ देनी हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","इसराईलियों को मिसर से निकले एक साल हो गया था। दूसरे साल के पहले महीने में रब ने दश्ते-सीना में मूसा से बात की। ");
INSERT INTO urdgvh_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“लाज़िम है कि इसराईली ईदे-फ़सह को मुक़र्ररा वक़्त पर मनाएँ, ");
INSERT INTO urdgvh_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","यानी इस महीने के चौधवें दिन, सूरज के ग़ुरूब होने के ऐन बाद। उसे तमाम क़वायद के मुताबिक़ मनाना।” ");
INSERT INTO urdgvh_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","चुनाँचे मूसा ने इसराईलियों से कहा कि वह ईदे-फ़सह मनाएँ, ");
INSERT INTO urdgvh_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","और उन्होंने ऐसा ही किया। उन्होंने ईदे-फ़सह को पहले महीने के चौधवें दिन सूरज के ग़ुरूब होने के ऐन बाद मनाया। उन्होंने सब कुछ वैसा ही किया जैसा रब ने मूसा को हुक्म दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","लेकिन कुछ आदमी नापाक थे, क्योंकि उन्होंने लाश छू ली थी। इस वजह से वह उस दिन ईदे-फ़सह न मना सके। वह मूसा और हारून के पास आकर ");
INSERT INTO urdgvh_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","कहने लगे, “हमने लाश छू ली है, इसलिए नापाक हैं। लेकिन हमें इस सबब से ईदे-फ़सह को मनाने से क्यों रोका जाए? हम भी मुक़र्ररा वक़्त पर बाक़ी इसराईलियों के साथ रब की क़ुरबानी पेश करना चाहते हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","मूसा ने जवाब दिया, “यहाँ मेरे इंतज़ार में खड़े रहो। मैं मालूम करता हूँ कि रब तुम्हारे बारे में क्या हुक्म देता है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“इसराईलियों को बता देना कि अगर तुम या तुम्हारी औलाद में से कोई ईदे-फ़सह के दौरान लाश छूने से नापाक हो या किसी दूर-दराज़ इलाक़े में सफ़र कर रहा हो, तो भी वह ईद मना सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ऐसा शख़्स उसे ऐन एक माह के बाद मनाकर लेले के साथ बेख़मीरी रोटी और कड़वा साग-पात खाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","खाने में से कुछ भी अगली सुबह तक बाक़ी न रहे। जानवर की कोई भी हड्डी न तोड़ना। मनानेवाला ईदे-फ़सह के पूरे फ़रायज़ अदा करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","लेकिन जो पाक होने और सफ़र न करने के बावुजूद भी ईदे-फ़सह को न मनाए उसे उस की क़ौम में से मिटाया जाए, क्योंकि उसने मुक़र्ररा वक़्त पर रब को क़ुरबानी पेश नहीं की। उस शख़्स को अपने गुनाह का नतीजा भुगतना पड़ेगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","अगर कोई परदेसी तुम्हारे दरमियान रहते हुए रब के सामने ईदे-फ़सह मनाना चाहे तो उसे इजाज़त है। शर्त यह है कि वह पूरे फ़रायज़ अदा करे। परदेसी और देसी के लिए ईदे-फ़सह मनाने के फ़रायज़ एक जैसे हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","जिस दिन शरीअत के मुक़द्दस ख़ैमे को खड़ा किया गया उस दिन बादल आकर उस पर छा गया। रात के वक़्त बादल आग की सूरत में नज़र आया। ");
INSERT INTO urdgvh_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","इसके बाद यही सूरते-हाल रही कि बादल उस पर छाया रहता और रात के दौरान आग की सूरत में नज़र आता। ");
INSERT INTO urdgvh_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","जब भी बादल ख़ैमे पर से उठता इसराईली रवाना हो जाते। जहाँ भी बादल उतर जाता वहाँ इसराईली अपने डेरे डालते। ");
INSERT INTO urdgvh_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","इसराईली रब के हुक्म पर रवाना होते और उसके हुक्म पर डेरे डालते। जब तक बादल मक़दिस पर छाया रहता उस वक़्त तक वह वहीं ठहरते। ");
INSERT INTO urdgvh_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","कभी कभी बादल बड़ी देर तक ख़ैमे पर ठहरा रहता। तब इसराईली रब का हुक्म मानकर रवाना न होते। ");
INSERT INTO urdgvh_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","कभी कभी बादल सिर्फ़ दो-चार दिन के लिए ख़ैमे पर ठहरता। फिर वह रब के हुक्म के मुताबिक़ ही ठहरते और रवाना होते थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","कभी कभी बादल सिर्फ़ शाम से लेकर सुबह तक ख़ैमे पर ठहरता। जब वह सुबह के वक़्त उठता तो इसराईली भी रवाना होते थे। जब भी बादल उठता वह भी रवाना हो जाते। ");
INSERT INTO urdgvh_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","जब तक बादल मुक़द्दस ख़ैमे पर छाया रहता उस वक़्त तक इसराईली रवाना न होते, चाहे वह दो दिन, एक माह, एक साल या इससे ज़्यादा अरसा मक़दिस पर छाया रहता। लेकिन जब वह उठता तो इसराईली भी रवाना हो जाते। ");
INSERT INTO urdgvh_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","वह रब के हुक्म पर ख़ैमे लगाते और उसके हुक्म पर रवाना होते थे। वह वैसा ही करते थे जैसा रब मूसा की मारिफ़त फ़रमाता था। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“चाँदी के दो बिगुल घड़कर बनवा ले। उन्हें जमात को जमा करने और क़बीलों को रवाना करने के लिए इस्तेमाल कर। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","जब दोनों को देर तक बजाया जाए तो पूरी जमात मुलाक़ात के ख़ैमे के दरवाज़े पर आकर तेरे सामने जमा हो जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","लेकिन अगर एक ही बजाया जाए तो सिर्फ़ कुंबों के बुज़ुर्ग तेरे सामने जमा हो जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","अगर उनकी आवाज़ सिर्फ़ थोड़ी देर के लिए सुनाई दे तो मक़दिस के मशरिक़ में मौजूद क़बीले रवाना हो जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","फिर जब उनकी आवाज़ दूसरी बार थोड़ी देर के लिए सुनाई दे तो मक़दिस के जुनूब में मौजूद क़बीले रवाना हो जाएँ। जब उनकी आवाज़ थोड़ी देर के लिए सुनाई दे तो यह रवाना होने का एलान होगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","इसके मुक़ाबले में जब उनकी आवाज़ देर तक सुनाई दे तो यह इस बात का एलान होगा कि जमात जमा हो जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","बिगुल बजाने की ज़िम्मादारी हारून के बेटों यानी इमामों को दी जाए। यह तुम्हारे और आनेवाली नसलों के लिए दायमी उसूल हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","उनकी आवाज़ उस वक़्त भी थोड़ी देर के लिए सुना दो जब तुम अपने मुल्क में किसी ज़ालिम दुश्मन से जंग लड़ने के लिए निकलोगे। तब रब तुम्हारा ख़ुदा तुम्हें याद करके दुश्मन से बचाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","इसी तरह उनकी आवाज़ मक़दिस में ख़ुशी के मौक़ों पर सुनाई दे यानी मुक़र्ररा ईदों और नए चाँद की ईदों पर। इन मौक़ों पर वह भस्म होनेवाली क़ुरबानियाँ और सलामती की क़ुरबानियाँ चढ़ाते वक़्त बजाए जाएँ। फिर तुम्हारा ख़ुदा तुम्हें याद करेगा। मैं रब तुम्हारा ख़ुदा हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","इसराईलियों को मिसर से निकले एक साल से ज़ायद अरसा हो चुका था। दूसरे महीने के बीसवें दिन बादल मुलाक़ात के ख़ैमे पर से उठा। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","फिर इसराईली मुक़र्ररा तरतीब के मुताबिक़ दश्ते-सीना से रवाना हुए। चलते चलते बादल फ़ारान के रेगिस्तान में उतर आया। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","उस वक़्त वह पहली दफ़ा उस तरतीब से रवाना हुए जो रब ने मूसा की मारिफ़त मुक़र्रर की थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","पहले यहूदाह के क़बीले के तीन दस्ते अपने अलम के तहत चल पड़े। तीनों का कमाँडर नहसोन बिन अम्मीनदाब था। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","साथ चलनेवाले क़बीले इशकार का कमाँडर नतनियेल बिन ज़ुग़र था। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ज़बूलून का क़बीला भी साथ चला जिसका कमाँडर इलियाब बिन हेलोन था। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","इसके बाद मुलाक़ात का ख़ैमा उतारा गया। जैरसोनी और मिरारी उसे उठाकर चल दिए। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","इन लावियों के बाद रूबिन के क़बीले के तीन दस्ते अपने अलम के तहत चलने लगे। तीनों का कमाँडर इलीसूर बिन शदियूर था। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","साथ चलनेवाले क़बीले शमौन का कमाँडर सलूमियेल बिन सूरीशद्दी था। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","जद का क़बीला भी साथ चला जिसका कमाँडर इलियासफ़ बिन दऊएल था। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","फिर लावियों में से क़िहाती मक़दिस का सामान उठाकर रवाना हुए। लाज़िम था कि उनके अगली मनज़िल पर पहुँचने तक मुलाक़ात का ख़ैमा लगा दिया गया हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","इसके बाद इफ़राईम के क़बीले के तीन दस्ते अपने अलम के तहत चल दिए। उनका कमाँडर इलीसमा बिन अम्मीहूद था। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","इफ़राईम के साथ चलनेवाले क़बीले मनस्सी का कमाँडर जमलियेल बिन फ़दाहसूर था। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","बिनयमीन का क़बीला भी साथ चला जिसका कमाँडर अबिदान बिन जिदौनी था। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","आख़िर में दान के तीन दस्ते अक़बी मुहाफ़िज़ के तौर पर अपने अलम के तहत रवाना हुए। उनका कमाँडर अख़ियज़र बिन अम्मीशद्दी था। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","दान के साथ चलनेवाले क़बीले आशर का कमाँडर फ़जियेल बिन अकरान था। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","नफ़ताली का क़बीला भी साथ चला जिसका कमाँडर अख़ीरा बिन एनान था। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","इसराईली इसी तरतीब से रवाना हुए। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","मूसा ने अपने मिदियानी सुसर रऊएल यानी यितरो के बेटे होबाब से कहा, “हम उस जगह के लिए रवाना हो रहे हैं जिसका वादा रब ने हमसे किया है। हमारे साथ चलें! हम आप पर एहसान करेंगे, क्योंकि रब ने इसराईल पर एहसान करने का वादा किया है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","लेकिन होबाब ने जवाब दिया, “मैं साथ नहीं जाऊँगा बल्कि अपने मुल्क और रिश्तेदारों के पास वापस चला जाऊँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","मूसा ने कहा, “मेहरबानी करके हमें न छोड़ें। क्योंकि आप ही जानते हैं कि हम रेगिस्तान में कहाँ कहाँ अपने डेरे डाल सकते हैं। आप रेगिस्तान में हमें रास्ता दिखा सकते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","अगर आप हमारे साथ जाएँ तो हम आपको उस एहसान में शरीक करेंगे जो रब हम पर करेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","चुनाँचे उन्होंने रब के पहाड़ से रवाना होकर तीन दिन सफ़र किया। इस दौरान रब का अहद का संदूक़ उनके आगे आगे चला ताकि उनके लिए आराम करने की जगह मालूम करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","जब कभी वह रवाना होते तो रब का बादल दिन के वक़्त उनके ऊपर रहता। ");
INSERT INTO urdgvh_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","संदूक़ के रवाना होते वक़्त मूसा कहता, “ऐ रब, उठ। तेरे दुश्मन तित्तर-बित्तर हो जाएँ। तुझसे नफ़रत करनेवाले तेरे सामने से फ़रार हो जाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","और जब भी वह रुक जाता तो मूसा कहता, “ऐ रब, इसराईल के हज़ारों ख़ानदानों के पास वापस आ।” ");
INSERT INTO urdgvh_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","एक दिन लोग ख़ूब शिकायत करने लगे। जब यह शिकायतें रब तक पहुँचीं तो उसे ग़ुस्सा आया और उस की आग उनके दरमियान भड़क उठी। जलते जलते उसने ख़ैमागाह का एक किनारा भस्म कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","लोग मदद के लिए मूसा के पास आकर चिल्लाने लगे तो उसने रब से दुआ की, और आग बुझ गई। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","उस मक़ाम का नाम तबएरा यानी जलना पड़ गया, क्योंकि रब की आग उनके दरमियान जल उठी थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","इसराईलियों के साथ जो अजनबी सफ़र कर रहे थे वह गोश्त खाने की शदीद आरज़ू करने लगे। तब इसराईली भी रो पड़े और कहने लगे, “कौन हमें गोश्त खिलाएगा? ");
INSERT INTO urdgvh_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","मिसर में हम मछली मुफ़्त खा सकते थे। हाय, वहाँ के खीरे, तरबूज़, गंदने, प्याज़ और लहसन कितने अच्छे थे! ");
INSERT INTO urdgvh_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","लेकिन अब तो हमारी जान सूख गई है। यहाँ बस मन ही मन नज़र आता रहता है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","मन धनिये के दानों की मानिंद था, और उसका रंग गूगल के गूँद की मानिंद था। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","रात के वक़्त वह ख़ैमागाह में ओस के साथ ज़मीन पर गिरता था। सुबह के वक़्त लोग इधर-उधर घुमते-फिरते हुए उसे जमा करते थे। फिर वह उसे चक्की में पीसकर या उखली में कूटकर उबालते या रोटी बनाते थे। उसका ज़ायक़ा ऐसी रोटी का-सा था जिसमें ज़ैतून का तेल डाला गया हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","तमाम ख़ानदान अपने अपने ख़ैमे के दरवाज़े पर रोने लगे तो रब को शदीद ग़ुस्सा आया। उनका शोर मूसा को भी बहुत बुरा लगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","उसने रब से पूछा, “तूने अपने ख़ादिम के साथ इतना बुरा सुलूक क्यों किया? मैंने किस काम से तुझे इतना नाराज़ किया कि तूने इन तमाम लोगों का बोझ मुझ पर डाल दिया? ");
INSERT INTO urdgvh_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","क्या मैंने हामिला होकर इस पूरी क़ौम को जन्म दिया कि तू मुझसे कहता है, ‘इसे उस तरह उठाकर ले चलना जिस तरह आया शीरख़ार बच्चे को उठाकर हर जगह साथ लिए फिरती है। इसी तरह इसे उस मुल्क में ले जाना जिसका वादा मैंने क़सम खाकर इनके बापदादा से किया है।’ ");
INSERT INTO urdgvh_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ऐ अल्लाह, मैं इन तमाम लोगों को कहाँ से गोश्त मुहैया करूँ? वह मेरे सामने रोते रहते हैं कि हमें खाने के लिए गोश्त दो। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","मैं अकेला इन तमाम लोगों की ज़िम्मादारी नहीं उठा सकता। यह बोझ मेरे लिए हद से ज़्यादा भारी है। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","अगर तू इस पर इसरार करे तो फिर बेहतर है कि अभी मुझे मार दे ताकि मैं अपनी तबाही न देखूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","जवाब में रब ने मूसा से कहा, “मेरे पास इसराईल के 70 बुज़ुर्ग जमा कर। सिर्फ़ ऐसे लोग चुन जिनके बारे में तुझे मालूम है कि वह लोगों के बुज़ुर्ग और निगहबान हैं। उन्हें मुलाक़ात के ख़ैमे के पास ले आ। वहाँ वह तेरे साथ खड़े हो जाएँ, ");
INSERT INTO urdgvh_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","तो मैं उतरकर तेरे साथ हमकलाम हूँगा। उस वक़्त मैं उस रूह में से कुछ लूँगा जो मैंने तुझ पर नाज़िल किया था और उसे उन पर नाज़िल करूँगा। तब वह क़ौम का बोझ उठाने में तेरी मदद करेंगे और तू इसमें अकेला नहीं रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","लोगों को बताना, ‘अपने आपको मख़सूसो-मुक़द्दस करो, क्योंकि कल तुम गोश्त खाओगे। रब ने तुम्हारी सुनी जब तुम रो पड़े कि कौन हमें गोश्त खिलाएगा, मिसर में हमारी हालत बेहतर थी। अब रब तुम्हें गोश्त मुहैया करेगा और तुम उसे खाओगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","तुम उसे न सिर्फ़ एक, दो या पाँच दिन खाओगे बल्कि 10 या 20 दिन से भी ज़्यादा अरसे तक। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","तुम एक पूरा महीना ख़ूब गोश्त खाओगे, यहाँ तक कि वह तुम्हारी नाक से निकलेगा और तुम्हें उससे घिन आएगी। और यह इस सबब से होगा कि तुमने रब को जो तुम्हारे दरमियान है रद्द किया और रोते रोते उसके सामने कहा कि हम क्यों मिसर से निकले’।” ");
INSERT INTO urdgvh_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","लेकिन मूसा ने एतराज़ किया, “अगर क़ौम के पैदल चलनेवाले गिने जाएँ तो छः लाख हैं। तू किस तरह हमें एक माह तक गोश्त मुहैया करेगा? ");
INSERT INTO urdgvh_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","क्या गाय-बैलों या भेड़-बकरियों को इतनी मिक़दार में ज़बह किया जा सकता है कि काफ़ी हो? अगर समुंदर की तमाम मछलियाँ उनके लिए पकड़ी जाएँ तो क्या काफ़ी होंगी?” ");
INSERT INTO urdgvh_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","रब ने कहा, “क्या रब का इख़्तियार कम है? अब तू ख़ुद देख लेगा कि मेरी बातें दुरुस्त हैं कि नहीं।” ");
INSERT INTO urdgvh_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","चुनाँचे मूसा ने वहाँ से निकलकर लोगों को रब की यह बातें बताईं। उसने उनके बुज़ुर्गों में से 70 को चुनकर उन्हें मुलाक़ात के ख़ैमे के इर्दगिर्द खड़ा कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","तब रब बादल में उतरकर मूसा से हमकलाम हुआ। जो रूह उसने मूसा पर नाज़िल किया था उसमें से उसने कुछ लेकर उन 70 बुज़ुर्गों पर नाज़िल किया। जब रूह उन पर आया तो वह नबुव्वत करने लगे। लेकिन ऐसा फिर कभी न हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","अब ऐसा हुआ कि इन सत्तर बुज़ुर्गों में से दो ख़ैमागाह में रह गए थे। उनके नाम इलदाद और मेदाद थे। उन्हें चुना तो गया था लेकिन वह मुलाक़ात के ख़ैमे के पास नहीं आए थे। इसके बावुजूद रूह उन पर भी नाज़िल हुआ और वह ख़ैमागाह में नबुव्वत करने लगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","एक नौजवान भागकर मूसा के पास आया और कहा, “इलदाद और मेदाद ख़ैमागाह में ही नबुव्वत कर रहे हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","यशुअ बिन नून जो जवानी से मूसा का मददगार था बोल उठा, “मूसा मेरे आक़ा, उन्हें रोक दें!” ");
INSERT INTO urdgvh_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","लेकिन मूसा ने जवाब दिया, “क्या तू मेरी ख़ातिर ग़ैरत खा रहा है? काश रब के तमाम लोग नबी होते और वह उन सब पर अपना रूह नाज़िल करता!” ");
INSERT INTO urdgvh_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","फिर मूसा और इसराईल के बुज़ुर्ग ख़ैमागाह में वापस आए। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","तब रब की तरफ़ से ज़ोरदार हवा चलने लगी जिसने समुंदर को पार करनेवाले बटेरों के ग़ोल धकेलकर ख़ैमागाह के इर्दगिर्द ज़मीन पर फेंक दिए। उनके ग़ोल तीन फ़ुट ऊँचे और ख़ैमागाह के चारों तरफ़ 30 किलोमीटर तक पड़े रहे। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","उस पूरे दिन और रात और अगले पूरे दिन लोग निकलकर बटेरें जमा करते रहे। हर एक ने कम अज़ कम दस बड़ी टोकरियाँ भर लीं। फिर उन्होंने उनका गोश्त ख़ैमे के इर्दगिर्द ज़मीन पर फैला दिया ताकि वह ख़ुश्क हो जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","लेकिन गोश्त के पहले टुकड़े अभी मुँह में थे कि रब का ग़ज़ब उन पर आन पड़ा, और उसने उनमें सख़्त वबा फैलने दी। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","चुनाँचे मक़ाम का नाम क़ब्रोत-हत्तावा यानी ‘लालच की क़ब्रें’ रखा गया, क्योंकि वहाँ उन्होंने उन लोगों को दफ़न किया जो गोश्त के लालच में आ गए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","इसके बाद इसराईली क़ब्रोत-हत्तावा से रवाना होकर हसीरात पहुँच गए। वहाँ वह ख़ैमाज़न हुए। ");
INSERT INTO urdgvh_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","एक दिन मरियम और हारून मूसा के ख़िलाफ़ बातें करने लगे। वजह यह थी कि उसने कूश की एक औरत से शादी की थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","उन्होंने पूछा, “क्या रब सिर्फ़ मूसा की मारिफ़त बात करता है? क्या उसने हमसे भी बात नहीं की?” रब ने उनकी यह बातें सुनीं। ");
INSERT INTO urdgvh_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","लेकिन मूसा निहायत हलीम था। दुनिया में उस जैसा हलीम कोई नहीं था। ");
INSERT INTO urdgvh_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","अचानक रब मूसा, हारून और मरियम से मुख़ातिब हुआ, “तुम तीनों बाहर निकलकर मुलाक़ात के ख़ैमे के पास आओ।” तीनों वहाँ पहुँचे। ");
INSERT INTO urdgvh_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","तब रब बादल के सतून में उतरकर मुलाक़ात के ख़ैमे के दरवाज़े पर खड़ा हुआ। उसने हारून और मरियम को बुलाया तो दोनों आए। ");
INSERT INTO urdgvh_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","उसने कहा, “मेरी बात सुनो। जब तुम्हारे दरमियान नबी होता है तो मैं अपने आपको रोया में उस पर ज़ाहिर करता हूँ या ख़ाब में उससे मुख़ातिब होता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","लेकिन मेरे ख़ादिम मूसा की और बात है। उसे मैंने अपने पूरे घराने पर मुक़र्रर किया है। ");
INSERT INTO urdgvh_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","उससे मैं रूबरू हमकलाम होता हूँ। उससे मैं मुअम्मों के ज़रीए नहीं बल्कि साफ़ साफ़ बात करता हूँ। वह रब की सूरत देखता है। तो फिर तुम मेरे ख़ादिम के ख़िलाफ़ बातें करने से क्यों न डरे?” ");
INSERT INTO urdgvh_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","रब का ग़ज़ब उन पर आन पड़ा, और वह चला गया। ");
INSERT INTO urdgvh_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","जब बादल का सतून ख़ैमे से दूर हुआ तो मरियम की जिल्द बर्फ़ की मानिंद सफ़ेद थी। वह कोढ़ का शिकार हो गई थी। हारून उस की तरफ़ मुड़ा तो उस की हालत देखी ");
INSERT INTO urdgvh_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","और मूसा से कहा, “मेरे आक़ा, मेहरबानी करके हमें इस गुनाह की सज़ा न दें जो हमारी हमाक़त के बाइस सरज़द हुआ है। ");
INSERT INTO urdgvh_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","मरियम को इस हालत में न छोड़ें। वह तो ऐसे बच्चे की मानिंद है जो मुरदा पैदा हुआ हो, जिसके जिस्म का आधा हिस्सा गल चुका हो।” ");
INSERT INTO urdgvh_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","तब मूसा ने पुकारकर रब से कहा, “ऐ अल्लाह, मेहरबानी करके उसे शफ़ा दे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","रब ने जवाब में मूसा से कहा, “अगर मरियम का बाप उसके मुँह पर थूकता तो क्या वह पूरे हफ़ते तक शर्म महसूस न करती? उसे एक हफ़ते के लिए ख़ैमागाह के बाहर बंद रख। इसके बाद उसे वापस लाया जा सकता है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","चुनाँचे मरियम को एक हफ़ते के लिए ख़ैमागाह के बाहर बंद रखा गया। लोग उस वक़्त तक सफ़र के लिए रवाना न हुए जब तक उसे वापस न लाया गया। ");
INSERT INTO urdgvh_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","जब वह वापस आई तो इसराईली हसीरात से रवाना होकर फ़ारान के रेगिस्तान में ख़ैमाज़न हुए। ");
INSERT INTO urdgvh_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","फिर रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“कुछ आदमी मुल्के-कनान का जायज़ा लेने के लिए भेज दे, क्योंकि मैं उसे इसराईलियों को देने को हूँ। हर क़बीले में से एक राहनुमा को चुनकर भेज दे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","मूसा ने रब के कहने पर उन्हें दश्ते-फ़ारान से भेजा। सब इसराईली राहनुमा थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","उनके नाम यह हैं : रूबिन के क़बीले से सम्मुअ बिन ज़क्कूर, ");
INSERT INTO urdgvh_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","शमौन के क़बीले से साफ़त बिन होरी, ");
INSERT INTO urdgvh_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","यहूदाह के क़बीले से कालिब बिन यफ़ुन्ना, ");
INSERT INTO urdgvh_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","इशकार के क़बीले से इजाल बिन यूसुफ़, ");
INSERT INTO urdgvh_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","इफ़राईम के क़बीले से होसेअ बिन नून, ");
INSERT INTO urdgvh_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","बिनयमीन के क़बीले से फ़लती बिन रफ़ू, ");
INSERT INTO urdgvh_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ज़बूलून के क़बीले से जद्दियेल बिन सोदी, ");
INSERT INTO urdgvh_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","यूसुफ़ के बेटे मनस्सी के क़बीले से जिद्दी बिन सूसी, ");
INSERT INTO urdgvh_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","दान के क़बीले से अम्मियेल बिन जमल्ली, ");
INSERT INTO urdgvh_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","आशर के क़बीले से सतूर बिन मीकाएल, ");
INSERT INTO urdgvh_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","नफ़ताली के क़बीले से नख़बी बिन वुफ़सी, ");
INSERT INTO urdgvh_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","जद के क़बीले से जियुएल बिन माकी। ");
INSERT INTO urdgvh_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","मूसा ने इन्हीं बारह आदमियों को मुल्क का जायज़ा लेने के लिए भेजा। उसने होसेअ का नाम यशुअ यानी ‘रब नजात है’ में बदल दिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","उन्हें रुख़सत करने से पहले उसने कहा, “दश्ते-नजब से गुज़रकर पहाड़ी इलाक़े तक पहुँचो। ");
INSERT INTO urdgvh_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","मालूम करो कि यह किस तरह का मुल्क है और उसके बाशिंदे कैसे हैं। क्या वह ताक़तवर हैं या कमज़ोर, तादाद में कम हैं या ज़्यादा? ");
INSERT INTO urdgvh_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","जिस मुल्क में वह बसते हैं क्या वह अच्छा है कि नहीं? वह किस क़िस्म के शहरों में रहते हैं? क्या उनकी चारदीवारियाँ हैं कि नहीं? ");
INSERT INTO urdgvh_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","मुल्क की ज़मीन ज़रख़ेज़ है या बंजर? उसमें दरख़्त हैं कि नहीं? और जुर्रत करके मुल्क का कुछ फल चुनकर ले आओ।” उस वक़्त पहले अंगूर पक गए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","चुनाँचे इन आदमियों ने सफ़र करके दश्ते-सीन से रहोब तक मुल्क का जायज़ा लिया। रहोब लबो-हमात के क़रीब है। ");
INSERT INTO urdgvh_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","वह दश्ते-नजब से गुज़रकर हबरून पहुँचे जहाँ अनाक़ के बेटे अख़ीमान, सीसी और तलमी रहते थे। (हबरून को मिसर के शहर ज़ुअन से सात साल पहले तामीर किया गया था)। ");
INSERT INTO urdgvh_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","जब वह वादीए-इसकाल तक पहुँचे तो उन्होंने एक डाली काट ली जिस पर अंगूर का गुच्छा लगा हुआ था। दो आदमियों ने यह अंगूर, कुछ अनार और कुछ अंजीर लाठी पर लटकाए और उसे उठाकर चल पड़े। ");
INSERT INTO urdgvh_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","उस जगह का नाम उस गुच्छे के सबब से जो इसराईलियों ने वहाँ से काट लिया इसकाल यानी गुच्छा रखा गया। ");
INSERT INTO urdgvh_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","चालीस दिन तक मुल्क का खोज लगाते लगाते वह लौट आए। ");
INSERT INTO urdgvh_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","वह मूसा, हारून और इसराईल की पूरी जमात के पास आए जो दश्ते-फ़ारान में क़ादिस की जगह पर इंतज़ार कर रहे थे। वहाँ उन्होंने सब कुछ बताया जो उन्होंने मालूम किया था और उन्हें वह फल दिखाए जो लेकर आए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","उन्होंने मूसा को रिपोर्ट दी, “हम उस मुल्क में गए जहाँ आपने हमें भेजा था। वाक़ई उस मुल्क में दूध और शहद की कसरत है। यहाँ हमारे पास उसके कुछ फल भी हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","लेकिन उसके बाशिंदे ताक़तवर हैं। उनके शहरों की फ़सीलें हैं, और वह निहायत बड़े हैं। हमने वहाँ अनाक़ की औलाद भी देखी। ");
INSERT INTO urdgvh_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","अमालीक़ी दश्ते-नजब में रहते हैं जबकि हित्ती, यबूसी और अमोरी पहाड़ी इलाक़े में आबाद हैं। कनानी साहिली इलाक़े और दरियाए-यरदन के किनारे किनारे बसते हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","कालिब ने मूसा के सामने जमाशुदा लोगों को इशारा किया कि वह ख़ामोश हो जाएँ। फिर उसने कहा, “आएँ, हम मुल्क में दाख़िल हो जाएँ और उस पर क़ब्ज़ा कर लें, क्योंकि हम यक़ीनन यह करने के क़ाबिल हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","लेकिन दूसरे आदमियों ने जो उसके साथ मुल्क को देखने गए थे कहा, “हम उन लोगों पर हमला नहीं कर सकते, क्योंकि वह हमसे ताक़तवर हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","उन्होंने इसराईलियों के दरमियान उस मुल्क के बारे में ग़लत अफ़वाहें फैलाईं जिसकी तफ़तीश उन्होंने की थी। उन्होंने कहा, “जिस मुल्क में से हम गुज़रे ताकि उसका जायज़ा लें वह अपने बाशिंदों को हड़प कर लेता है। जो भी उसमें रहता है निहायत दराज़क़द है। ");
INSERT INTO urdgvh_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","हमने वहाँ देवक़ामत अफ़राद भी देखे। (अनाक़ के बेटे देवक़ामत के अफ़राद की औलाद थे)। उनके सामने हम अपने आपको टिड्डी जैसा महसूस कर रहे थे, और हम उनकी नज़र में ऐसे थे भी।” ");
INSERT INTO urdgvh_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","उस रात तमाम लोग चीख़ें मार मारकर रोते रहे। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","सब मूसा और हारून के ख़िलाफ़ बुड़बुड़ाने लगे। पूरी जमात ने उनसे कहा, “काश हम मिसर या इस रेगिस्तान में मर गए होते! ");
INSERT INTO urdgvh_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","रब हमें क्यों उस मुल्क में ले जा रहा है? क्या इसलिए कि दुश्मन हमें तलवार से क़त्ल करे और हमारे बाल-बच्चों को लूट ले? क्या बेहतर नहीं होगा कि हम मिसर वापस जाएँ?” ");
INSERT INTO urdgvh_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","उन्होंने एक दूसरे से कहा, “आओ, हम राहनुमा चुनकर मिसर वापस चले जाएँ।” ");
INSERT INTO urdgvh_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","तब मूसा और हारून पूरी जमात के सामने मुँह के बल गिरे। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","लेकिन यशुअ बिन नून और कालिब बिन यफ़ुन्ना बाक़ी दस जासूसों से फ़रक़ थे। परेशानी के आलम में उन्होंने अपने कपड़े फाड़कर ");
INSERT INTO urdgvh_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","पूरी जमात से कहा, “जिस मुल्क में से हम गुज़रे और जिसकी तफ़तीश हमने की वह निहायत ही अच्छा है। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","अगर रब हमसे ख़ुश है तो वह ज़रूर हमें उस मुल्क में ले जाएगा जिसमें दूध और शहद की कसरत है। वह हमें ज़रूर यह मुल्क देगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","रब से बग़ावत मत करना। उस मुल्क के रहनेवालों से न डरें। हम उन्हें हड़प कर जाएंगे। उनकी पनाह उनसे जाती रही है जबकि रब हमारे साथ है। चुनाँचे उनसे मत डरें।” ");
INSERT INTO urdgvh_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","यह सुनकर पूरी जमात उन्हें संगसार करने के लिए तैयार हुई। लेकिन अचानक रब का जलाल मुलाक़ात के ख़ैमे पर ज़ाहिर हुआ, और तमाम इसराईलियों ने उसे देखा। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","रब ने मूसा से कहा, “यह लोग मुझे कब तक हक़ीर जानेंगे? वह कब तक मुझ पर ईमान रखने से इनकार करेंगे अगरचे मैंने उनके दरमियान इतने मोजिज़े किए हैं? ");
INSERT INTO urdgvh_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","मैं उन्हें वबा से मार डालूँगा और उन्हें रूए-ज़मीन पर से मिटा दूँगा। उनकी जगह मैं तुझसे एक क़ौम बनाऊँगा जो उनसे बड़ी और ताक़तवर होगी।” ");
INSERT INTO urdgvh_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","लेकिन मूसा ने रब से कहा, “फिर मिसरी यह सुन लेंगे! क्योंकि तूने अपनी क़ुदरत से इन लोगों को मिसर से निकालकर यहाँ तक पहुँचाया है। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","मिसरी यह बात कनान के बाशिंदों को बताएँगे। यह लोग पहले से सुन चुके हैं कि रब इस क़ौम के साथ है, कि तुझे रूबरू देखा जाता है, कि तेरा बादल उनके ऊपर ठहरा रहता है, और कि तू दिन के वक़्त बादल के सतून में और रात को आग के सतून में इनके आगे आगे चलता है। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","अगर तू एकदम इस पूरी क़ौम को तबाह कर डाले तो बाक़ी क़ौमें यह सुनकर कहेंगी, ");
INSERT INTO urdgvh_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘रब इन लोगों को उस मुल्क में ले जाने के क़ाबिल नहीं था जिसका वादा उसने उनसे क़सम खाकर किया था। इसी लिए उसने उन्हें रेगिस्तान में हलाक कर दिया।’ ");
INSERT INTO urdgvh_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","ऐ रब, अब अपनी क़ुदरत यों ज़ाहिर कर जिस तरह तूने फ़रमाया है। क्योंकि तूने कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘रब तहम्मुल और शफ़क़त से भरपूर है। वह गुनाह और नाफ़रमानी मुआफ़ करता है, लेकिन हर एक को उस की मुनासिब सज़ा भी देता है। जब वालिदैन गुनाह करें तो उनकी औलाद को भी तीसरी और चौथी पुश्त तक सज़ा के नतायज भुगतने पड़ेंगे।’ ");
INSERT INTO urdgvh_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","इन लोगों का क़ुसूर अपनी अज़ीम शफ़क़त के मुताबिक़ मुआफ़ कर। उन्हें उस तरह मुआफ़ कर जिस तरह तू उन्हें मिसर से निकलते वक़्त अब तक मुआफ़ करता रहा है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","रब ने जवाब दिया, “तेरे कहने पर मैंने उन्हें मुआफ़ कर दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","इसके बावुजूद मेरी हयात की क़सम और मेरे जलाल की क़सम जो पूरी दुनिया को मामूर करता है, ");
INSERT INTO urdgvh_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","इन लोगों में से कोई भी उस मुल्क में दाख़िल नहीं होगा। उन्होंने मेरा जलाल और मेरे मोजिज़े देखे हैं जो मैंने मिसर और रेगिस्तान में कर दिखाए हैं। तो भी उन्होंने दस दफ़ा मुझे आज़माया और मेरी न सुनी। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","उनमें से एक भी उस मुल्क को नहीं देखेगा जिसका वादा मैंने क़सम खाकर उनके बापदादा से किया था। जिसने भी मुझे हक़ीर जाना है वह कभी उसे नहीं देखेगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","सिर्फ़ मेरा ख़ादिम कालिब मुख़्तलिफ़ है। उस की रूह फ़रक़ है। वह पूरे दिल से मेरी पैरवी करता है, इसलिए मैं उसे उस मुल्क में ले जाऊँगा जिसमें उसने सफ़र किया है। उस की औलाद मुल्क मीरास में पाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","लेकिन फ़िलहाल अमालीक़ी और कनानी उस की वादियों में आबाद रहेंगे। चुनाँचे कल मुड़कर वापस चलो। रेगिस्तान में बहरे-क़ुलज़ुम की तरफ़ रवाना हो जाओ।” ");
INSERT INTO urdgvh_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","रब ने मूसा और हारून से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“यह शरीर जमात कब तक मेरे ख़िलाफ़ बुड़बुड़ाती रहेगी? उनके गिले-शिकवे मुझ तक पहुँच गए हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","इसलिए उन्हें बताओ, ‘रब फ़रमाता है कि मेरी हयात की क़सम, मैं तुम्हारे साथ वही कुछ करूँगा जो तुमने मेरे सामने कहा है। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","तुम इस रेगिस्तान में मरकर यहीं पड़े रहोगे, हर एक जो 20 साल या इससे ज़ायद का है, जो मर्दुमशुमारी में गिना गया और जो मेरे ख़िलाफ़ बुड़बुड़ाया। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","गो मैंने हाथ उठाकर क़सम खाई थी कि मैं तुझे उसमें बसाऊँगा तुममें से कोई भी उस मुल्क में दाख़िल नहीं होगा। सिर्फ़ कालिब बिन यफ़ुन्ना और यशुअ बिन नून दाख़िल होंगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","तुमने कहा था कि दुश्मन हमारे बच्चों को लूट लेंगे। लेकिन उन्हीं को मैं उस मुल्क में ले जाऊँगा जिसे तुमने रद्द किया है। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","लेकिन तुम ख़ुद दाख़िल नहीं होगे। तुम्हारी लाशें इस रेगिस्तान में पड़ी रहेंगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","तुम्हारे बच्चे 40 साल तक यहाँ रेगिस्तान में गल्लाबान होंगे। उन्हें तुम्हारी बेवफ़ाई के सबब से उस वक़्त तक तकलीफ़ उठानी पड़ेगी जब तक तुममें से आख़िरी शख़्स मर न गया हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","तुमने चालीस दिन के दौरान उस मुल्क का जायज़ा लिया। अब तुम्हें चालीस साल तक अपने गुनाहों का नतीजा भुगतना पड़ेगा। तब तुम्हें पता चलेगा कि इसका क्या मतलब है कि मैं तुम्हारी मुख़ालफ़त करता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","मैं, रब ने यह बात फ़रमाई है। मैं यक़ीनन यह सब कुछ उस सारी शरीर जमात के साथ करूँगा जिसने मिलकर मेरी मुख़ालफ़त की है। इसी रेगिस्तान में वह ख़त्म हो जाएंगे, यहीं मर जाएंगे’।” ");
INSERT INTO urdgvh_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","जिन आदमियों को मूसा ने मुल्क का जायज़ा लेने के लिए भेजा था, रब ने उन्हें फ़ौरन मोहलक वबा से मार डाला, क्योंकि उनके ग़लत अफ़वाहें फैलाने से पूरी जमात बुड़बुड़ाने लगी थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","सिर्फ़ यशुअ बिन नून और कालिब बिन यफ़ुन्ना ज़िंदा रहे। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","जब मूसा ने रब की यह बातें इसराईलियों को बताईं तो वह ख़ूब मातम करने लगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","अगली सुबह-सवेरे वह उठे और यह कहते हुए ऊँचे पहाड़ी इलाक़े के लिए रवाना हुए कि हमसे ग़लती हुई है, लेकिन अब हम हाज़िर हैं और उस जगह की तरफ़ जा रहे हैं जिसका ज़िक्र रब ने किया है। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","लेकिन मूसा ने कहा, “तुम क्यों रब की ख़िलाफ़वरज़ी कर रहे हो? तुम कामयाब नहीं होगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","वहाँ न जाओ, क्योंकि रब तुम्हारे साथ नहीं है। तुम दुश्मनों के हाथों शिकस्त खाओगे, ");
INSERT INTO urdgvh_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","क्योंकि वहाँ अमालीक़ी और कनानी तुम्हारा सामना करेंगे। चूँकि तुमने अपना मुँह रब से फेर लिया है इसलिए वह तुम्हारे साथ नहीं होगा, और दुश्मन तुम्हें तलवार से मार डालेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","तो भी वह अपने ग़ुरूर में जुर्रत करके ऊँचे पहाड़ी इलाक़े की तरफ़ बढ़े, हालाँकि न मूसा और न अहद के संदूक़ ही ने ख़ैमागाह को छोड़ा। ");
INSERT INTO urdgvh_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","फिर उस पहाड़ी इलाक़े में रहनेवाले अमालीक़ी और कनानी उन पर आन पड़े और उन्हें मारते मारते हुरमा तक तित्तर-बित्तर कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“इसराईलियों को बताना कि जब तुम उस मुल्क में दाख़िल होगे जो मैं तुम्हें दूँगा ");
INSERT INTO urdgvh_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","4","तो जलनेवाली क़ुरबानियाँ यों पेश करना : अगर तुम अपने गाय-बैलों या भेड़-बकरियों में से ऐसी क़ुरबानी पेश करना चाहो जिसकी ख़ुशबू रब को पसंद हो तो साथ साथ डेढ़ किलोग्राम बेहतरीन मैदा भी पेश करो जो एक लिटर ज़ैतून के तेल के साथ मिलाया गया हो। इसमें कोई फ़रक़ नहीं कि यह भस्म होनेवाली क़ुरबानी, मन्नत की क़ुरबानी, दिली ख़ुशी की क़ुरबानी या किसी ईद की क़ुरबानी हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","हर भेड़ को पेश करते वक़्त एक लिटर मै भी मै की नज़र के तौर पर पेश करना। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","जब मेंढा क़ुरबान किया जाए तो 3 किलोग्राम बेहतरीन मैदा भी साथ पेश करना जो सवा लिटर तेल के साथ मिलाया गया हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","सवा लिटर मै भी मै की नज़र के तौर पर पेश की जाए। ऐसी क़ुरबानी की ख़ुशबू रब को पसंद आएगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","अगर तू रब को भस्म होनेवाली क़ुरबानी, मन्नत की क़ुरबानी या सलामती की क़ुरबानी के तौर पर जवान बैल पेश करना चाहे ");
INSERT INTO urdgvh_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","तो उसके साथ साढ़े 4 किलोग्राम बेहतरीन मैदा भी पेश करना जो दो लिटर तेल के साथ मिलाया गया हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","दो लिटर मै भी मै की नज़र के तौर पर पेश की जाए। ऐसी क़ुरबानी की ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","लाज़िम है कि जब भी किसी गाय, बैल, भेड़, मेंढे, बकरी या बकरे को चढ़ाया जाए तो ऐसा ही किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","अगर एक से ज़ायद जानवरों को क़ुरबान करना है तो हर एक के लिए मुक़र्ररा ग़ल्ला और मै की नज़रें भी साथ ही पेश की जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","लाज़िम है कि हर देसी इसराईली जलनेवाली क़ुरबानियाँ पेश करते वक़्त ऐसा ही करे। फिर उनकी ख़ुशबू रब को पसंद आएगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","यह भी लाज़िम है कि इसराईल में आरिज़ी या मुस्तक़िल तौर पर रहनेवाले परदेसी इन उसूलों के मुताबिक़ अपनी क़ुरबानियाँ चढ़ाएँ। फिर उनकी ख़ुशबू रब को पसंद आएगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","मुल्के-कनान में रहनेवाले तमाम लोगों के लिए पाबंदियाँ एक जैसी हैं, ख़ाह वह देसी हों या परदेसी, क्योंकि रब की नज़र में परदेसी तुम्हारे बराबर है। यह तुम्हारे और तुम्हारी औलाद के लिए दायमी उसूल है। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","तुम्हारे और तुम्हारे साथ रहनेवाले परदेसी के लिए एक ही शरीअत है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“इसराईलियों को बताना कि जब तुम उस मुल्क में दाख़िल होगे जिसमें मैं तुम्हें ले जा रहा हूँ ");
INSERT INTO urdgvh_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","और वहाँ की पैदावार खाओगे तो पहले उसका एक हिस्सा उठानेवाली क़ुरबानी के तौर पर रब को पेश करना। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","फ़सल के पहले ख़ालिस आटे में से मेरे लिए एक रोटी बनाकर उठानेवाली क़ुरबानी के तौर पर पेश करो। वह गाहने की जगह की तरफ़ से रब के लिए उठानेवाली क़ुरबानी होगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","अपनी फ़सल के पहले ख़ालिस आटे में से यह क़ुरबानी पेश किया करो। यह उसूल हमेशा तक लागू रहे। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","हो सकता है कि ग़ैरइरादी तौर पर तुमसे ग़लती हुई है और तुमने उन अहकाम पर पूरे तौर पर अमल नहीं किया जो रब मूसा को दे चुका है ");
INSERT INTO urdgvh_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","या जो वह आनेवाली नसलों को देगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","अगर जमात इस बात से नावाक़िफ़ थी और ग़ैरइरादी तौर पर उससे ग़लती हुई तो फिर पूरी जमात एक जवान बैल भस्म होनेवाली क़ुरबानी के तौर पर पेश करे। साथ ही वह मुक़र्ररा ग़ल्ला और मै की नज़रें भी पेश करे। इसकी ख़ुशबू रब को पसंद होगी। इसके अलावा जमात गुनाह की क़ुरबानी के लिए एक बकरा पेश करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","इमाम इसराईल की पूरी जमात का कफ़्फ़ारा दे तो उन्हें मुआफ़ी मिलेगी, क्योंकि उनका गुनाह ग़ैरइरादी था और उन्होंने रब को भस्म होनेवाली क़ुरबानी और गुनाह की क़ुरबानी पेश की है। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","इसराईलियों की पूरी जमात को परदेसियों समेत मुआफ़ी मिलेगी, क्योंकि गुनाह ग़ैरइरादी था। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","अगर सिर्फ़ एक शख़्स से ग़ैरइरादी तौर पर गुनाह हुआ हो तो गुनाह की क़ुरबानी के लिए वह एक यकसाला बकरी पेश करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","इमाम रब के सामने उस शख़्स का कफ़्फ़ारा दे। जब कफ़्फ़ारा दे दिया गया तो उसे मुआफ़ी हासिल होगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","यही उसूल परदेसी पर भी लागू है। अगर उससे ग़ैरइरादी तौर पर गुनाह हुआ हो तो वह मुआफ़ी हासिल करने के लिए वही कुछ करे जो इसराईली को करना होता है। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","लेकिन अगर कोई देसी या परदेसी जान-बूझकर गुनाह करता है तो ऐसा शख़्स रब की इहानत करता है, इसलिए लाज़िम है कि उसे उस की क़ौम में से मिटाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","उसने रब का कलाम हक़ीर जानकर उसके अहकाम तोड़ डाले हैं, इसलिए उसे ज़रूर क़ौम में से मिटाया जाए। वह अपने गुनाह का ज़िम्मादार है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","जब इसराईली रेगिस्तान में से गुज़र रहे थे तो एक आदमी को पकड़ा गया जो हफ़ते के दिन लकड़ियाँ जमा कर रहा था। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","जिन्होंने उसे पकड़ा था वह उसे मूसा, हारून और पूरी जमात के पास ले आए। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","चूँकि साफ़ मालूम नहीं था कि उसके साथ क्या किया जाए इसलिए उन्होंने उसे गिरिफ़्तार कर लिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","फिर रब ने मूसा से कहा, “इस आदमी को ज़रूर सज़ाए-मौत दी जाए। पूरी जमात उसे ख़ैमागाह के बाहर ले जाकर संगसार करे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","चुनाँचे जमात ने उसे ख़ैमागाह के बाहर ले जाकर संगसार किया, जिस तरह रब ने मूसा को हुक्म दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“इसराईलियों को बताना कि तुम और तुम्हारे बाद की नसलें अपने लिबास के किनारों पर फुँदने लगाएँ। हर फुँदना एक क़िरमिज़ी डोरी से लिबास के साथ लगा हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","इन फुँदनों को देखकर तुम्हें रब के तमाम अहकाम याद रहेंगे और तुम उन पर अमल करोगे। फिर तुम अपने दिलों और आँखों की ग़लत ख़ाहिशों के पीछे नहीं पड़ोगे बल्कि ज़िनाकारी से दूर रहोगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","फिर तुम मेरे अहकाम को याद करके उन पर अमल करोगे और अपने ख़ुदा के सामने मख़सूसो-मुक़द्दस रहोगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","मैं रब तुम्हारा ख़ुदा हूँ जो तुम्हें मिसर से निकाल लाया ताकि तुम्हारा ख़ुदा हूँ। मैं रब तुम्हारा ख़ुदा हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","एक दिन क़ोरह बिन इज़हार मूसा के ख़िलाफ़ उठा। वह लावी के क़बीले का क़िहाती था। उसके साथ रूबिन के क़बीले के तीन आदमी थे, इलियाब के बेटे दातन और अबीराम और ओन बिन पलत। उनके साथ 250 और आदमी भी थे जो जमात के सरदार और असरो-रसूख़वाले थे, और जो कौंसल के लिए चुने गए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","वह मिलकर मूसा और हारून के पास आकर कहने लगे, “आप हमसे ज़्यादती कर रहे हैं। पूरी जमात मख़सूसो-मुक़द्दस है, और रब उसके दरमियान है। तो फिर आप अपने आपको क्यों रब की जमात से बढ़कर समझते हैं?” ");
INSERT INTO urdgvh_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","यह सुनकर मूसा मुँह के बल गिरा। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","फिर उसने क़ोरह और उसके तमाम साथियों से कहा, “कल सुबह रब ज़ाहिर करेगा कि कौन उसका बंदा और कौन मख़सूसो-मुक़द्दस है। उसी को वह अपने पास आने देगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","ऐ क़ोरह, कल अपने तमाम साथियों के साथ बख़ूरदान लेकर ");
INSERT INTO urdgvh_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","रब के सामने उनमें अंगारे और बख़ूर डालो। जिस आदमी को रब चुनेगा वह मख़सूसो-मुक़द्दस होगा। अब तुम लावी ख़ुद ज़्यादती कर रहे हो।” ");
INSERT INTO urdgvh_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","मूसा ने क़ोरह से बात जारी रखी, “ऐ लावी की औलाद, सुनो! ");
INSERT INTO urdgvh_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","क्या तुम्हारी नज़र में यह कोई छोटी बात है कि रब तुम्हें इसराईली जमात के बाक़ी लोगों से अलग करके अपने क़रीब ले आया ताकि तुम रब के मक़दिस में और जमात के सामने खड़े होकर उनकी ख़िदमत करो? ");
INSERT INTO urdgvh_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","वह तुझे और तेरे साथी लावियों को अपने क़रीब लाया है। लेकिन अब तुम इमाम का ओहदा भी अपनाना चाहते हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","अपने साथियों से मिलकर तूने हारून की नहीं बल्कि रब की मुख़ालफ़त की है। क्योंकि हारून कौन है कि तुम उसके ख़िलाफ़ बुड़बुड़ाओ?” ");
INSERT INTO urdgvh_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","फिर मूसा ने इलियाब के बेटों दातन और अबीराम को बुलाया। लेकिन उन्होंने कहा, “हम नहीं आएँगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","आप हमें एक ऐसे मुल्क से निकाल लाए हैं जहाँ दूध और शहद की कसरत है ताकि हम रेगिस्तान में हलाक हो जाएँ। क्या यह काफ़ी नहीं है? क्या अब आप हम पर हुकूमत भी करना चाहते हैं? ");
INSERT INTO urdgvh_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","न आपने हमें ऐसे मुल्क में पहुँचाया जिसमें दूध और शहद की कसरत है, न हमें खेतों और अंगूर के बाग़ों के वारिस बनाया है। क्या आप इन आदमियों की आँखें निकाल डालेंगे? नहीं, हम हरगिज़ नहीं आएँगे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","तब मूसा निहायत ग़ुस्से हुआ। उसने रब से कहा, “उनकी क़ुरबानी को क़बूल न कर। मैंने एक गधा तक उनसे नहीं लिया, न मैंने उनमें से किसी से बुरा सुलूक किया है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","क़ोरह से उसने कहा, “कल तुम और तुम्हारे साथी रब के सामने हाज़िर हो जाओ। हारून भी आएगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","हर एक अपना बख़ूरदान लेकर उसे रब को पेश करे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","चुनाँचे हर आदमी ने अपना बख़ूरदान लेकर उसमें अंगारे और बख़ूर डाल दिया। फिर सब मूसा और हारून के साथ मुलाक़ात के ख़ैमे के दरवाज़े पर खड़े हुए। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","क़ोरह ने पूरी जमात को दरवाज़े पर मूसा और हारून के मुक़ाबले में जमा किया था। अचानक पूरी जमात पर रब का जलाल ज़ाहिर हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","रब ने मूसा और हारून से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“इस जमात से अलग हो जाओ ताकि मैं इसे फ़ौरन हलाक कर दूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","मूसा और हारून मुँह के बल गिरे और बोल उठे, “ऐ अल्लाह, तू तमाम जानों का ख़ुदा है। क्या तेरा ग़ज़ब एक ही आदमी के गुनाह के सबब से पूरी जमात पर आन पड़ेगा?” ");
INSERT INTO urdgvh_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","तब रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“जमात को बता दे कि क़ोरह, दातन और अबीराम के डेरों से दूर हो जाओ।” ");
INSERT INTO urdgvh_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","मूसा उठकर दातन और अबीराम के पास गया, और इसराईल के बुज़ुर्ग उसके पीछे चले। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","उसने जमात को आगाह किया, “इन शरीरों के ख़ैमों से दूर हो जाओ! जो कुछ भी उनके पास है उसे न छुओ, वरना तुम भी उनके साथ तबाह हो जाओगे जब वह अपने गुनाहों के बाइस हलाक होंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","तब बाक़ी लोग क़ोरह, दातन और अबीराम के डेरों से दूर हो गए। दातन और अबीराम अपने बाल-बच्चों समेत अपने ख़ैमों से निकलकर बाहर खड़े थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","मूसा ने कहा, “अब तुम्हें पता चलेगा कि रब ने मुझे यह सब कुछ करने के लिए भेजा है। मैं अपनी नहीं बल्कि उस की मरज़ी पूरी कर रहा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","अगर यह लोग दूसरों की तरह तबई मौत मरें तो फिर रब ने मुझे नहीं भेजा। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","लेकिन अगर रब ऐसा काम करे जो पहले कभी नहीं हुआ और ज़मीन अपना मुँह खोलकर उन्हें और उनका पूरा माल हड़प कर ले और उन्हें जीते-जी दफ़ना दे तो इसका मतलब होगा कि इन आदमियों ने रब को हक़ीर जाना है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","यह बात कहते ही उनके नीचे की ज़मीन फट गई। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","उसने अपना मुँह खोलकर उन्हें, उनके ख़ानदानों को, क़ोरह के तमाम लोगों को और उनका सारा सामान हड़प कर लिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","वह अपनी पूरी मिलकियत समेत जीते-जी दफ़न हो गए। ज़मीन उनके ऊपर वापस आ गई। यों उन्हें जमात से निकाला गया और वह हलाक हो गए। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","उनकी चीख़ें सुनकर उनके इर्दगिर्द खड़े तमाम इसराईली भाग उठे, क्योंकि उन्होंने सोचा, “ऐसा न हो कि ज़मीन हमें भी निगल ले।” ");
INSERT INTO urdgvh_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","उसी लमहे रब की तरफ़ से आग उतर आई और उन 250 आदमियों को भस्म कर दिया जो बख़ूर पेश कर रहे थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“हारून इमाम के बेटे इलियज़र को इत्तला दे कि वह बख़ूरदानों को राख में से निकालकर रखे। उनके अंगारे वह दूर फेंके। बख़ूरदानों को रखने का सबब यह है कि अब वह मख़सूसो-मुक़द्दस हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","लोग उन आदमियों के यह बख़ूरदान ले लें जो अपने गुनाह के बाइस जान-बहक़ हो गए। वह उन्हें कूटकर उनसे चादरें बनाएँ और उन्हें जलनेवाली क़ुरबानियों की क़ुरबानगाह पर चढ़ाएँ। क्योंकि वह रब को पेश किए गए हैं, इसलिए वह मख़सूसो-मुक़द्दस हैं। यों वह इसराईलियों के लिए एक निशान रहेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","चुनाँचे इलियज़र इमाम ने पीतल के यह बख़ूरदान जमा किए जो भस्म किए हुए आदमियों ने रब को पेश किए थे। फिर लोगों ने उन्हें कूटकर उनसे चादरें बनाईं और उन्हें क़ुरबानगाह पर चढ़ा दिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","हारून ने सब कुछ वैसा ही किया जैसा रब ने मूसा की मारिफ़त बताया था। मक़सद यह था कि बख़ूरदान इसराईलियों को याद दिलाते रहें कि सिर्फ़ हारून की औलाद ही को रब के सामने आकर बख़ूर जलाने की इजाज़त है। अगर कोई और ऐसा करे तो उसका हाल क़ोरह और उसके साथियों का-सा होगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","अगले दिन इसराईल की पूरी जमात मूसा और हारून के ख़िलाफ़ बुड़बुड़ाने लगी। उन्होंने कहा, “आपने रब की क़ौम को मार डाला है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","लेकिन जब वह मूसा और हारून के मुक़ाबले में जमा हुए और मुलाक़ात के ख़ैमे का रुख़ किया तो अचानक उस पर बादल छा गया और रब का जलाल ज़ाहिर हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","फिर मूसा और हारून मुलाक़ात के ख़ैमे के सामने आए, ");
INSERT INTO urdgvh_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","और रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“इस जमात से निकल जाओ ताकि मैं इसे फ़ौरन हलाक कर दूँ।” यह सुनकर दोनों मुँह के बल गिरे। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","मूसा ने हारून से कहा, “अपना बख़ूरदान लेकर उसमें क़ुरबानगाह के अंगारे और बख़ूर डालें। फिर भागकर जमात के पास चले जाएँ ताकि उनका कफ़्फ़ारा दें। जल्दी करें, क्योंकि रब का ग़ज़ब उन पर टूट पड़ा है। वबा फैलने लगी है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","हारून ने ऐसा ही किया। वह दौड़कर जमात के बीच में गया। लोगों में वबा शुरू हो चुकी थी, लेकिन हारून ने रब को बख़ूर पेश करके उनका कफ़्फ़ारा दिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","वह ज़िंदों और मुरदों के बीच में खड़ा हुआ तो वबा रुक गई। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","तो भी 14,700 अफ़राद वबा से मर गए। इसमें वह शामिल नहीं हैं जो क़ोरह के सबब से मर गए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","जब वबा रुक गई तो हारून मूसा के पास वापस आया जो अब तक मुलाक़ात के ख़ैमे के दरवाज़े पर खड़ा था। ");
INSERT INTO urdgvh_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“इसराईलियों से बात करके उनसे 12 लाठियाँ मँगवा ले, हर क़बीले के सरदार से एक लाठी। हर लाठी पर उसके मालिक का नाम लिखना। ");
INSERT INTO urdgvh_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","लावी की लाठी पर हारून का नाम लिखना, क्योंकि हर क़बीले के सरदार के लिए एक लाठी होगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","फिर उनको मुलाक़ात के ख़ैमे में अहद के संदूक़ के सामने रख जहाँ मेरी तुमसे मुलाक़ात होती है। ");
INSERT INTO urdgvh_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","जिस आदमी को मैंने चुन लिया है उस की लाठी से कोंपलें फूट निकलेंगी। इस तरह मैं तुम्हारे ख़िलाफ़ इसराईलियों की बुड़बुड़ाहट ख़त्म कर दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","चुनाँचे मूसा ने इसराईलियों से बात की, और क़बीलों के हर सरदार ने उसे अपनी लाठी दी। इन 12 लाठियों में हारून की लाठी भी शामिल थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","मूसा ने उन्हें मुलाक़ात के ख़ैमे में अहद के संदूक़ के सामने रखा। ");
INSERT INTO urdgvh_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","अगले दिन जब वह मुलाक़ात के ख़ैमे में दाख़िल हुआ तो उसने देखा कि लावी के क़बीले के सरदार हारून की लाठी से न सिर्फ़ कोंपलें फूट निकली हैं बल्कि फूल और पके हुए बादाम भी लगे हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","मूसा तमाम लाठियाँ रब के सामने से बाहर लाकर इसराईलियों के पास ले आया, और उन्होंने उनका मुआयना किया। फिर हर एक ने अपनी अपनी लाठी वापस ले ली। ");
INSERT INTO urdgvh_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","रब ने मूसा से कहा, “हारून की लाठी अहद के संदूक़ के सामने रख दे। यह बाग़ी इसराईलियों को याद दिलाएगी कि वह अपना बुड़बुड़ाना बंद करें, वरना हलाक हो जाएंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","मूसा ने ऐसा ही किया। ");
INSERT INTO urdgvh_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","लेकिन इसराईलियों ने मूसा से कहा, “हाय, हम मर जाएंगे। हाय, हम हलाक हो जाएंगे, हम सब हलाक हो जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","जो भी रब के मक़दिस के क़रीब आए वह मर जाएगा। क्या हम सब ही हलाक हो जाएंगे?” ");
INSERT INTO urdgvh_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","रब ने हारून से कहा, “मक़दिस तेरी, तेरे बेटों और लावी के क़बीले की ज़िम्मादारी है। अगर इसमें कोई ग़लती हो जाए तो तुम क़ुसूरवार ठहरोगे। इसी तरह इमामों की ख़िदमत सिर्फ़ तेरी और तेरे बेटों की ज़िम्मादारी है। अगर इसमें कोई ग़लती हो जाए तो तू और तेरे बेटे क़ुसूरवार ठहरेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","अपने क़बीले लावी के बाक़ी आदमियों को भी मेरे क़रीब आने दे। वह तेरे साथ मिलकर यों हिस्सा लें कि वह तेरी और तेरे बेटों की ख़िदमत करें जब तुम ख़ैमे के सामने अपनी ज़िम्मादारियाँ निभाओगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","तेरी ख़िदमत और ख़ैमे में ख़िदमत उनकी ज़िम्मादारी है। लेकिन वह ख़ैमे के मख़सूसो-मुक़द्दस सामान और क़ुरबानगाह के क़रीब न जाएँ, वरना न सिर्फ़ वह बल्कि तू भी हलाक हो जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","यों वह तेरे साथ मिलकर मुलाक़ात के ख़ैमे के पूरे काम में हिस्सा लें। लेकिन किसी और को ऐसा करने की इजाज़त नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","सिर्फ़ तू और तेरे बेटे मक़दिस और क़ुरबानगाह की देख-भाल करें ताकि मेरा ग़ज़ब दुबारा इसराईलियों पर न भड़के। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","मैं ही ने इसराईलियों में से तेरे भाइयों यानी लावियों को चुनकर तुझे तोह्फ़े के तौर पर दिया है। वह रब के लिए मख़सूस हैं ताकि ख़ैमे में ख़िदमत करें। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","लेकिन सिर्फ़ तू और तेरे बेटे इमाम की ख़िदमत सरंजाम दें। मैं तुम्हें इमाम का ओहदा तोह्फ़े के तौर पर देता हूँ। कोई और क़ुरबानगाह और मुक़द्दस चीज़ों के नज़दीक न आए, वरना उसे सज़ाए-मौत दी जाए।” ");
INSERT INTO urdgvh_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","रब ने हारून से कहा, “मैंने ख़ुद मुक़र्रर किया है कि तमाम उठानेवाली क़ुरबानियाँ तेरा हिस्सा हों। यह हमेशा तक क़ुरबानियों में से तेरा और तेरी औलाद का हिस्सा हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","तुम्हें मुक़द्दसतरीन क़ुरबानियों का वह हिस्सा मिलना है जो जलाया नहीं जाता। हाँ, तुझे और तेरे बेटों को वही हिस्सा मिलना है, ख़ाह वह मुझे ग़ल्ला की नज़रें, गुनाह की क़ुरबानियाँ या क़ुसूर की क़ुरबानियाँ पेश करें। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","उसे मुक़द्दस जगह पर खाना। हर मर्द उसे खा सकता है। ख़याल रख कि वह मख़सूसो-मुक़द्दस है। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","मैंने मुक़र्रर किया है कि तमाम हिलानेवाली क़ुरबानियों का उठाया हुआ हिस्सा तेरा है। यह हमेशा के लिए तेरे और तेरे बेटे-बेटियों का हिस्सा है। तेरे घराने का हर फ़रद उसे खा सकता है। शर्त यह है कि वह पाक हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","जब लोग रब को अपनी फ़सलों का पहला फल पेश करेंगे तो वह तेरा ही हिस्सा होगा। मैं तुझे ज़ैतून के तेल, नई मै और अनाज का बेहतरीन हिस्सा देता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","फ़सलों का जो भी पहला फल वह रब को पेश करेंगे वह तेरा ही होगा। तेरे घराने का हर पाक फ़रद उसे खा सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","इसराईल में जो भी चीज़ रब के लिए मख़सूसो-मुक़द्दस की गई है वह तेरी होगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","हर इनसान और हर हैवान का जो पहलौठा रब को पेश किया जाता है वह तेरा ही है। लेकिन लाज़िम है कि तू हर इनसान और हर नापाक जानवर के पहलौठे का फ़िद्या देकर उसे छुड़ाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","जब वह एक माह के हैं तो उनके एवज़ चाँदी के पाँच सिक्के देना। (हर सिक्के का वज़न मक़दिस के बाटों के मुताबिक़ 11 ग्राम हो)। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","लेकिन गाय-बैलों और भेड़-बकरियों के पहले बच्चों का फ़िद्या यानी मुआवज़ा न देना। वह मख़सूसो-मुक़द्दस हैं। उनका ख़ून क़ुरबानगाह पर छिड़क देना और उनकी चरबी जला देना। ऐसी क़ुरबानी रब को पसंद होगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","उनका गोश्त वैसे ही तुम्हारे लिए हो, जैसे हिलानेवाली क़ुरबानी का सीना और दहनी रान भी तुम्हारे लिए हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","मुक़द्दस क़ुरबानियों में से तमाम उठानेवाली क़ुरबानियाँ तेरा और तेरे बेटे-बेटियों का हिस्सा हैं। मैंने उसे हमेशा के लिए तुझे दिया है। यह नमक का दायमी अहद है जो मैंने तेरे और तेरी औलाद के साथ क़ायम किया है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","रब ने हारून से कहा, “तू मीरास में ज़मीन नहीं पाएगा। इसराईल में तुझे कोई हिस्सा नहीं दिया जाएगा, क्योंकि इसराईलियों के दरमियान मैं ही तेरा हिस्सा और तेरी मीरास हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","अपनी पैदावार का जो दसवाँ हिस्सा इसराईली मुझे देते हैं वह मैं लावियों को देता हूँ। यह उनकी विरासत है, जो उन्हें मुलाक़ात के ख़ैमे में ख़िदमत करने के बदले में मिलती है। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","अब से इसराईली मुलाक़ात के ख़ैमे के क़रीब न आएँ, वरना उन्हें अपनी ख़ता का नतीजा बरदाश्त करना पड़ेगा और वह हलाक हो जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","सिर्फ़ लावी मुलाक़ात के ख़ैमे में ख़िदमत करें। अगर इसमें कोई ग़लती हो जाए तो वही क़ुसूरवार ठहरेंगे। यह एक दायमी उसूल है। उन्हें इसराईल में मीरास में ज़मीन नहीं मिलेगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","क्योंकि मैंने उन्हें वही दसवाँ हिस्सा मीरास के तौर पर दिया है जो इसराईली मुझे उठानेवाली क़ुरबानी के तौर पर पेश करते हैं। इस वजह से मैंने उनके बारे में कहा कि उन्हें बाक़ी इसराईलियों के साथ मीरास में ज़मीन नहीं मिलेगी।” ");
INSERT INTO urdgvh_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“लावियों को बताना कि तुम्हें इसराईलियों की पैदावार का दसवाँ हिस्सा मिलेगा। यह रब की तरफ़ से तुम्हारी विरासत होगी। लाज़िम है कि तुम इसका दसवाँ हिस्सा रब को उठानेवाली क़ुरबानी के तौर पर पेश करो। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","तुम्हारी यह क़ुरबानी नए अनाज या नए अंगूर के रस की क़ुरबानी के बराबर क़रार दी जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","इस तरह तुम भी रब को इसराईलियों की पैदावार के दसवें हिस्से में से उठानेवाली क़ुरबानी पेश करोगे। रब के लिए यह क़ुरबानी हारून इमाम को देना। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","जो भी तुम्हें मिला है उसमें से सबसे अच्छा और मुक़द्दस हिस्सा रब को देना। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","जब तुम इसका सबसे अच्छा हिस्सा पेश करोगे तो उसे नए अनाज या नए अंगूर के रस की क़ुरबानी के बराबर क़रार दिया जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","तुम अपने घरानों समेत इसका बाक़ी हिस्सा कहीं भी खा सकते हो, क्योंकि यह मुलाक़ात के ख़ैमे में तुम्हारी ख़िदमत का अज्र है। ");
INSERT INTO urdgvh_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","अगर तुमने पहले इसका बेहतरीन हिस्सा पेश किया हो तो फिर इसे खाने में तुम्हारा कोई क़ुसूर नहीं होगा। फिर इसराईलियों की मख़सूसो-मुक़द्दस क़ुरबानियाँ तुमसे नापाक नहीं हो जाएँगी और तुम नहीं मरोगे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","रब ने मूसा और हारून से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“इसराईलियों को बताना कि वह तुम्हारे पास सुर्ख़ रंग की जवान गाय लेकर आएँ। उसमें नुक़्स न हो और उस पर कभी जुआ न रखा गया हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","तुम उसे इलियज़र इमाम को देना जो उसे ख़ैमे के बाहर ले जाए। वहाँ उसे उस की मौजूदगी में ज़बह किया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","फिर इलियज़र इमाम अपनी उँगली से उसके ख़ून से कुछ लेकर मुलाक़ात के ख़ैमे के सामनेवाले हिस्से की तरफ़ छिड़के। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","उस की मौजूदगी में पूरी की पूरी गाय को जलाया जाए। उस की खाल, गोश्त, ख़ून और अंतड़ियों का गोबर भी जलाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","फिर वह देवदार की लकड़ी, ज़ूफ़ा और क़िरमिज़ी रंग का धागा लेकर उसे जलती हुई गाय पर फेंके। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","इसके बाद वह अपने कपड़ों को धोकर नहा ले। फिर वह ख़ैमागाह में आ सकता है लेकिन शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","जिस आदमी ने गाय को जलाया वह भी अपने कपड़ों को धोकर नहा ले। वह भी शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","एक दूसरा आदमी जो पाक है गाय की राख इकट्ठी करके ख़ैमागाह के बाहर किसी पाक जगह पर डाल दे। वहाँ इसराईल की जमात उसे नापाकी दूर करने का पानी तैयार करने के लिए महफ़ूज़ रखे। यह गुनाह से पाक करने के लिए इस्तेमाल होगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","जिस आदमी ने राख इकट्ठी की है वह भी अपने कपड़ों को धो ले। वह भी शाम तक नापाक रहेगा। यह इसराईलियों और उनके दरमियान रहनेवाले परदेसियों के लिए दायमी उसूल हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","जो भी लाश छुए वह सात दिन तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","तीसरे और सातवें दिन वह अपने आप पर नापाकी दूर करने का पानी छिड़ककर पाक-साफ़ हो जाए। इसके बाद ही वह पाक होगा। लेकिन अगर वह इन दोनों दिनों में अपने आपको यों पाक न करे तो नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","जो भी लाश छूकर अपने आपको यों पाक नहीं करता वह रब के मक़दिस को नापाक करता है। लाज़िम है कि उसे इसराईल में से मिटाया जाए। चूँकि नापाकी दूर करने का पानी उस पर छिड़का नहीं गया इसलिए वह नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","अगर कोई डेरे में मर जाए तो जो भी उस वक़्त उसमें मौजूद हो या दाख़िल हो जाए वह सात दिन तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","हर खुला बरतन जो ढकने से बंद न किया गया हो वह भी नापाक होगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","इसी तरह जो खुले मैदान में लाश छुए वह भी सात दिन तक नापाक रहेगा, ख़ाह वह तलवार से या तबई मौत मरा हो। जो इनसान की कोई हड्डी या क़ब्र छुए वह भी सात दिन तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","नापाकी दूर करने के लिए उस सुर्ख़ रंग की गाय की राख में से कुछ लेना जो गुनाह दूर करने के लिए जलाई गई थी। उसे बरतन में डालकर ताज़ा पानी में मिलाना। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","फिर कोई पाक आदमी कुछ ज़ूफ़ा ले और उसे उस पानी में डुबोकर मरे हुए शख़्स के ख़ैमे, उसके सामान और उन लोगों पर छिड़के जो उसके मरते वक़्त वहाँ थे। इसी तरह वह पानी उस शख़्स पर भी छिड़के जिसने तबई या ग़ैरतबई मौत मरे हुए शख़्स को, किसी इनसान की हड्डी को या कोई क़ब्र छूई हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","पाक आदमी यह पानी तीसरे और सातवें दिन नापाक शख़्स पर छिड़के। सातवें दिन वह उसे पाक करे। जिसे पाक किया जा रहा है वह अपने कपड़े धोकर नहा ले तो वह उसी शाम पाक होगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","लेकिन जो नापाक शख़्स अपने आपको पाक नहीं करता उसे जमात में से मिटाना है, क्योंकि उसने रब का मक़दिस नापाक कर दिया है। नापाकी दूर करने का पानी उस पर नहीं छिड़का गया, इसलिए वह नापाक रहा है। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","यह उनके लिए दायमी उसूल है। जिस आदमी ने नापाकी दूर करने का पानी छिड़का है वह भी अपने कपड़े धोए। बल्कि जिसने भी यह पानी छुआ है शाम तक नापाक रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","और नापाक शख़्स जो भी चीज़ छुए वह नापाक हो जाती है। न सिर्फ़ यह बल्कि जो बाद में यह नापाक चीज़ छुए वह भी शाम तक नापाक रहेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","पहले महीने में इसराईल की पूरी जमात दश्ते-सीन में पहुँचकर क़ादिस में रहने लगी। वहाँ मरियम ने वफ़ात पाई और वहीं उसे दफ़नाया गया। ");
INSERT INTO urdgvh_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","क़ादिस में पानी दस्तयाब नहीं था, इसलिए लोग मूसा और हारून के मुक़ाबले में जमा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","वह मूसा से यह कहकर झगड़ने लगे, “काश हम अपने भाइयों के साथ रब के सामने मर गए होते! ");
INSERT INTO urdgvh_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","आप रब की जमात को क्यों इस रेगिस्तान में ले आए? क्या इसलिए कि हम यहाँ अपने मवेशियों समेत मर जाएँ? ");
INSERT INTO urdgvh_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","आप हमें मिसर से निकालकर उस नाख़ुशगवार जगह पर क्यों ले आए हैं? यहाँ न तो अनाज, न अंजीर, अंगूर या अनार दस्तयाब हैं। पानी भी नहीं है!” ");
INSERT INTO urdgvh_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","मूसा और हारून लोगों को छोड़कर मुलाक़ात के ख़ैमे के दरवाज़े पर गए और मुँह के बल गिरे। तब रब का जलाल उन पर ज़ाहिर हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“अहद के संदूक़ के सामने पड़ी लाठी पकड़कर हारून के साथ जमात को इकट्ठा कर। उनके सामने चट्टान से बात करो तो वह अपना पानी देगी। यों तू चट्टान में से जमात के लिए पानी निकालकर उन्हें उनके मवेशियों समेत पानी पिलाएगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","मूसा ने ऐसा ही किया। उसने अहद के संदूक़ के सामने पड़ी लाठी उठाई ");
INSERT INTO urdgvh_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","और हारून के साथ जमात को चट्टान के सामने इकट्ठा किया। मूसा ने उनसे कहा, “ऐ बग़ावत करनेवालो, सुनो! क्या हम इस चट्टान में से तुम्हारे लिए पानी निकालें?” ");
INSERT INTO urdgvh_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","उसने लाठी को उठाकर चट्टान को दो मरतबा मारा तो बहुत-सा पानी फूट निकला। जमात और उनके मवेशियों ने ख़ूब पानी पिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","लेकिन रब ने मूसा और हारून से कहा, “तुम्हारा मुझ पर इतना ईमान नहीं था कि मेरी क़ुद्दूसियत को इसराईलियों के सामने क़ायम रखते। इसलिए तुम उस जमात को उस मुल्क में नहीं ले जाओगे जो मैं उन्हें दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","यह वाक़िया मरीबा यानी ‘झगड़ना’ के पानी पर हुआ। वहाँ इसराईलियों ने रब से झगड़ा किया, और वहाँ उसने उन पर ज़ाहिर किया कि वह क़ुद्दूस है। ");
INSERT INTO urdgvh_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","क़ादिस से मूसा ने अदोम के बादशाह को इत्तला भेजी, “आपके भाई इसराईल की तरफ़ से एक गुज़ारिश है। आपको उन तमाम मुसीबतों के बारे में इल्म है जो हम पर आन पड़ी हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","हमारे बापदादा मिसर गए थे और वहाँ हम बहुत अरसे तक रहे। मिसरियों ने हमारे बापदादा और हमसे बुरा सुलूक किया। ");
INSERT INTO urdgvh_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","लेकिन जब हमने चिल्लाकर रब से मिन्नत की तो उसने हमारी सुनी और फ़रिश्ता भेजकर हमें मिसर से निकाल लाया। अब हम यहाँ क़ादिस शहर में हैं जो आपकी सरहद पर है। ");
INSERT INTO urdgvh_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","मेहरबानी करके हमें अपने मुल्क में से गुज़रने दें। हम किसी खेत या अंगूर के बाग़ में नहीं जाएंगे, न किसी कुएँ का पानी पिएँगे। हम शाहराह पर ही रहेंगे। आपके मुल्क में से गुज़रते हुए हम उससे न दाईं और न बाईं तरफ़ हटेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","लेकिन अदोमियों ने जवाब दिया, “यहाँ से न गुज़रना, वरना हम निकलकर आपसे लड़ेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","इसराईल ने दुबारा ख़बर भेजी, “हम शाहराह पर रहते हुए गुज़रेंगे। अगर हमें या हमारे जानवरों को पानी की ज़रूरत हुई तो पैसे देकर ख़रीद लेंगे। हम पैदल ही गुज़रना चाहते हैं, और कुछ नहीं चाहते।” ");
INSERT INTO urdgvh_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","लेकिन अदोमियों ने दुबारा इनकार किया। साथ ही उन्होंने उनके साथ लड़ने के लिए एक बड़ी और ताक़तवर फ़ौज भेजी। ");
INSERT INTO urdgvh_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","चूँकि अदोम ने उन्हें गुज़रने की इजाज़त न दी इसलिए इसराईली मुड़कर दूसरे रास्ते से चले गए। ");
INSERT INTO urdgvh_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","इसराईल की पूरी जमात क़ादिस से रवाना होकर होर पहाड़ के पास पहुँची। ");
INSERT INTO urdgvh_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","यह पहाड़ अदोम की सरहद पर वाक़े था। वहाँ रब ने मूसा और हारून से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“हारून अब कूच करके अपने बापदादा से जा मिलेगा। वह उस मुल्क में दाख़िल नहीं होगा जो मैं इसराईलियों को दूँगा, क्योंकि तुम दोनों ने मरीबा के पानी पर मेरे हुक्म की ख़िलाफ़वरज़ी की। ");
INSERT INTO urdgvh_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","हारून और उसके बेटे इलियज़र को लेकर होर पहाड़ पर चढ़ जा। ");
INSERT INTO urdgvh_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","हारून के कपड़े उतारकर उसके बेटे इलियज़र को पहना देना। फिर हारून कूच करके अपने बापदादा से जा मिलेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","मूसा ने ऐसा ही किया जैसा रब ने कहा। तीनों पूरी जमात के देखते देखते होर पहाड़ पर चढ़ गए। ");
INSERT INTO urdgvh_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","मूसा ने हारून के कपड़े उतरवाकर उसके बेटे इलियज़र को पहना दिए। फिर हारून वहाँ पहाड़ की चोटी पर फ़ौत हुआ, और मूसा और इलियज़र नीचे उतर गए। ");
INSERT INTO urdgvh_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","जब पूरी जमात को मालूम हुआ कि हारून इंतक़ाल कर गया है तो सबने 30 दिन तक उसके लिए मातम किया। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","दश्ते-नजब के कनानी मुल्क अराद के बादशाह को ख़बर मिली कि इसराईली अथारिम की तरफ़ बढ़ रहे हैं। उसने उन पर हमला किया और कई एक को पकड़कर क़ैद कर लिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","तब इसराईलियों ने रब के सामने मन्नत मानकर कहा, “अगर तू हमें उन पर फ़तह देगा तो हम उन्हें उनके शहरों समेत तबाह कर देंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","रब ने उनकी सुनी और कनानियों पर फ़तह बख़्शी। इसराईलियों ने उन्हें उनके शहरों समेत पूरी तरह तबाह कर दिया। इसलिए उस जगह का नाम हुरमा यानी तबाही पड़ गया। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","होर पहाड़ से रवाना होकर वह बहरे-क़ुलज़ुम की तरफ़ चल दिए ताकि अदोम के मुल्क में से गुज़रना न पड़े। लेकिन चलते चलते लोग बेसबर हो गए। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","वह रब और मूसा के ख़िलाफ़ बातें करने लगे, “आप हमें मिसर से निकालकर रेगिस्तान में मरने के लिए क्यों ले आए हैं? यहाँ न रोटी दस्तयाब है न पानी। हमें इस घटिया क़िस्म की ख़ुराक से घिन आती है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","तब रब ने उनके दरमियान ज़हरीले साँप भेज दिए जिनके काटने से बहुत-से लोग मर गए। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","फिर लोग मूसा के पास आए। उन्होंने कहा, “हमने रब और आपके ख़िलाफ़ बातें करते हुए गुनाह किया। हमारी सिफ़ारिश करें कि रब हमसे साँप दूर कर दे।” मूसा ने उनके लिए दुआ की ");
INSERT INTO urdgvh_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","तो रब ने मूसा से कहा, “एक साँप बनाकर उसे खंबे से लटका दे। जो भी डसा गया हो वह उसे देखकर बच जाएगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","चुनाँचे मूसा ने पीतल का एक साँप बनाया और खंबा खड़ा करके साँप को उससे लटका दिया। और ऐसा हुआ कि जिसे भी डसा गया था वह पीतल के साँप पर नज़र करके बच गया। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","इसराईली रवाना हुए और ओबोत में अपने ख़ैमे लगाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","फिर वहाँ से कूच करके ऐये-अबारीम में डेरे डाले, उस रेगिस्तान में जो मशरिक़ की तरफ़ मोआब के सामने है। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","वहाँ से रवाना होकर वह वादीए-ज़िरद में ख़ैमाज़न हुए। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","जब वादीए-ज़िरद से रवाना हुए तो दरियाए-अरनोन के परले यानी जुनूबी किनारे पर ख़ैमाज़न हुए। यह दरिया रेगिस्तान में है और अमोरियों के इलाक़े से निकलता है। यह अमोरियों और मोआबियों के दरमियान की सरहद है। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","इसका ज़िक्र किताब ‘रब की जंगें’ में भी है, “वाहेब जो सूफ़ा में है, दरियाए-अरनोन की वादियाँ ");
INSERT INTO urdgvh_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","और वादियों का वह ढलान जो आर शहर तक जाता है और मोआब की सरहद पर वाक़े है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","वहाँ से वह बैर यानी ‘कुआँ’ पहुँचे। यह वही बैर है जहाँ रब ने मूसा से कहा, “लोगों को इकट्ठा कर तो मैं उन्हें पानी दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","उस वक़्त इसराईलियों ने यह गीत गाया, “ऐ कुएँ, फूट निकल! उसके बारे में गीत गाओ, ");
INSERT INTO urdgvh_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","उस कुएँ के बारे में जिसे सरदारों ने खोदा, जिसे क़ौम के राहनुमाओं ने असाए-शाही और अपनी लाठियों से खोदा।” फिर वह रेगिस्तान से मत्तना को गए, ");
INSERT INTO urdgvh_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","मत्तना से नहलियेल को और नहलियेल से बामात को। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","बामात से वह मोआबियों के इलाक़े की उस वादी में पहुँचे जो पिसगा पहाड़ के दामन में है। इस पहाड़ की चोटी से वादीए-यरदन का जुनूबी हिस्सा यशीमोन ख़ूब नज़र आता है। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","इसराईल ने अमोरियों के बादशाह सीहोन को इत्तला भेजी, ");
INSERT INTO urdgvh_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“हमें अपने मुल्क में से गुज़रने दें। हम सीधे सीधे गुज़र जाएंगे। न हम कोई खेत या अंगूर का बाग़ छेड़ेंगे, न किसी कुएँ का पानी पिएँगे। हम आपके मुल्क में से सीधे गुज़रते हुए शाहराह पर ही रहेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","लेकिन सीहोन ने उन्हें गुज़रने न दिया बल्कि अपनी फ़ौज जमा करके इसराईल से लड़ने के लिए रेगिस्तान में चल पड़ा। यहज़ पहुँचकर उसने इसराईलियों से जंग की। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","लेकिन इसराईलियों ने उसे क़त्ल किया और दरियाए-अरनोन से लेकर दरियाए-यब्बोक़ तक यानी अम्मोनियों की सरहद तक उसके मुल्क पर क़ब्ज़ा कर लिया। वह इससे आगे न जा सके क्योंकि अम्मोनियों ने अपनी सरहद की हिसारबंदी कर रखी थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","इसराईली तमाम अमोरी शहरों पर क़ब्ज़ा करके उनमें रहने लगे। उनमें हसबोन और उसके इर्दगिर्द की आबादियाँ शामिल थीं। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","हसबोन अमोरी बादशाह सीहोन का दारुल-हुकूमत था। उसने मोआब के पिछले बादशाह से लड़कर उससे यह इलाक़ा दरियाए-अरनोन तक छीन लिया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","उस वाक़िये का ज़िक्र शायरी में यों किया गया है, “हसबोन के पास आकर उसे अज़ सरे-नौ तामीर करो, सीहोन के शहर को अज़ सरे-नौ क़ायम करो। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","हसबोन से आग निकली, सीहोन के शहर से शोला भड़का। उसने मोआब के शहर आर को जला दिया, अरनोन की बुलंदियों के मालिकों को भस्म किया। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ऐ मोआब, तुझ पर अफ़सोस! ऐ कमोस देवता की क़ौम, तू हलाक हुई है। कमोस ने अपने बेटों को मफ़रूर और अपनी बेटियों को अमोरी बादशाह सीहोन की क़ैदी बना दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","लेकिन जब हमने अमोरियों पर तीर चलाए तो हसबोन का इलाक़ा दीबोन तक बरबाद हुआ। हमने नुफ़ह तक सब कुछ तबाह किया, वह नुफ़ह जिसका इलाक़ा मीदबा तक है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","यों इसराईल अमोरियों के मुल्क में आबाद हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","वहाँ से मूसा ने अपने जासूस याज़ेर शहर भेजे। वहाँ भी अमोरी रहते थे। इसराईलियों ने याज़ेर और उसके इर्दगिर्द के शहरों पर भी क़ब्ज़ा किया और वहाँ के अमोरियों को निकाल दिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","इसके बाद वह मुड़कर बसन की तरफ़ बढ़े। तब बसन का बादशाह ओज अपनी तमाम फ़ौज लेकर उनसे लड़ने के लिए शहर इदरई आया। ");
INSERT INTO urdgvh_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","उस वक़्त रब ने मूसा से कहा, “ओज से न डरना। मैं उसे, उस की तमाम फ़ौज और उसका मुल्क तेरे हवाले कर चुका हूँ। उसके साथ वही सुलूक कर जो तूने अमोरियों के बादशाह सीहोन के साथ किया, जिसका दारुल-हुकूमत हसबोन था।” ");
INSERT INTO urdgvh_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","इसराईलियों ने ओज, उसके बेटों और तमाम फ़ौज को हलाक कर दिया। कोई भी न बचा। फिर उन्होंने बसन के मुल्क पर क़ब्ज़ा कर लिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","इसके बाद इसराईली मोआब के मैदानों में पहुँचकर दरियाए-यरदन के मशरिक़ी किनारे पर यरीहू के आमने-सामने ख़ैमाज़न हुए। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","मोआब के बादशाह बलक़ बिन सफ़ोर को मालूम हुआ कि इसराईलियों ने अमोरियों के साथ क्या कुछ किया है। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","मोआबियों ने यह भी देखा कि इसराईली बहुत ज़्यादा हैं, इसलिए उन पर दहशत छा गई। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","उन्होंने मिदियानियों के बुज़ुर्गों से बात की, “अब यह हुजूम उस तरह हमारे इर्दगिर्द का इलाक़ा चट कर जाएगा जिस तरह बैल मैदान की घास चट कर जाता है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","तब बलक़ ने अपने क़ासिद फ़तोर शहर को भेजे जो दरियाए-फ़ुरात पर वाक़े था और जहाँ बिलाम बिन बओर अपने वतन में रहता था। क़ासिद उसे बुलाने के लिए उसके पास पहुँचे और उसे बलक़ का पैग़ाम सुनाया, “एक क़ौम मिसर से निकल आई है जो रूए-ज़मीन पर छाकर मेरे क़रीब ही आबाद हुई है। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","इसलिए आएँ और इन लोगों पर लानत भेजें, क्योंकि वह मुझसे ज़्यादा ताक़तवर हैं। फिर शायद मैं उन्हें शिकस्त देकर मुल्क से भगा सकूँ। क्योंकि मैं जानता हूँ कि जिन्हें आप बरकत देते हैं उन्हें बरकत मिलती है और जिन पर आप लानत भेजते हैं उन पर लानत आती है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","यह पैग़ाम लेकर मोआब और मिदियान के बुज़ुर्ग रवाना हुए। उनके पास इनाम के पैसे थे। बिलाम के पास पहुँचकर उन्होंने उसे बलक़ का पैग़ाम सुनाया। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","बिलाम ने कहा, “रात यहाँ गुज़ारें। कल मैं आपको बता दूँगा कि रब इसके बारे में क्या फ़रमाता है।” चुनाँचे मोआबी सरदार उसके पास ठहर गए। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","रात के वक़्त अल्लाह बिलाम पर ज़ाहिर हुआ। उसने पूछा, “यह आदमी कौन हैं जो तेरे पास आए हैं?” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","बिलाम ने जवाब दिया, “मोआब के बादशाह बलक़ बिन सफ़ोर ने मुझे पैग़ाम भेजा है, ");
INSERT INTO urdgvh_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘जो क़ौम मिसर से निकल आई है वह रूए-ज़मीन पर छा गई है। इसलिए आएँ और मेरे लिए उन पर लानत भेजें। फिर शायद मैं उनसे लड़कर उन्हें भगा देने में कामयाब हो जाऊँ’।” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","रब ने बिलाम से कहा, “उनके साथ न जाना। तुझे उन पर लानत भेजने की इजाज़त नहीं है, क्योंकि उन पर मेरी बरकत है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","अगली सुबह बिलाम जाग उठा तो उसने बलक़ के सरदारों से कहा, “अपने वतन वापस चले जाएँ, क्योंकि रब ने मुझे आपके साथ जाने की इजाज़त नहीं दी।” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","चुनाँचे मोआबी सरदार ख़ाली हाथ बलक़ के पास वापस आए। उन्होंने कहा, “बिलाम हमारे साथ आने से इनकार करता है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","तब बलक़ ने और सरदार भेजे जो पहलेवालों की निसबत तादाद और ओहदे के लिहाज़ से ज़्यादा थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","वह बिलाम के पास जाकर कहने लगे, “बलक़ बिन सफ़ोर कहते हैं कि कोई भी बात आपको मेरे पास आने से न रोके, ");
INSERT INTO urdgvh_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","क्योंकि मैं आपको बड़ा इनाम दूँगा। आप जो भी कहेंगे मैं करने के लिए तैयार हूँ। आएँ तो सही और मेरे लिए उन लोगों पर लानत भेजें।” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","लेकिन बिलाम ने जवाब दिया, “अगर बलक़ अपने महल को चाँदी और सोने से भरकर भी मुझे दे तो भी मैं रब अपने ख़ुदा के फ़रमान की ख़िलाफ़वरज़ी नहीं कर सकता, ख़ाह बात छोटी हो या बड़ी। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","आप दूसरे सरदारों की तरह रात यहाँ गुज़ारें। इतने में मैं मालूम करूँगा कि रब मुझे मज़ीद क्या कुछ बताता है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","उस रात अल्लाह बिलाम पर ज़ाहिर हुआ और कहा, “चूँकि यह आदमी तुझे बुलाने आए हैं इसलिए उनके साथ चला जा। लेकिन सिर्फ़ वही कुछ करना जो मैं तुझे बताऊँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","सुबह को बिलाम ने उठकर अपनी गधी पर ज़ीन कसा और मोआबी सरदारों के साथ चल पड़ा। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","लेकिन अल्लाह निहायत ग़ुस्से हुआ कि वह जा रहा है, इसलिए उसका फ़रिश्ता उसका मुक़ाबला करने के लिए रास्ते में खड़ा हो गया। बिलाम अपनी गधी पर सवार था और उसके दो नौकर उसके साथ चल रहे थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","जब गधी ने देखा कि रब का फ़रिश्ता अपने हाथ में तलवार थामे हुए रास्ते में खड़ा है तो वह रास्ते से हटकर खेत में चलने लगी। बिलाम उसे मारते मारते रास्ते पर वापस ले आया। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","फिर वह अंगूर के दो बाग़ों के दरमियान से गुज़रने लगे। रास्ता तंग था, क्योंकि वह दोनों तरफ़ बाग़ों की चारदीवारी से बंद था। अब रब का फ़रिश्ता वहाँ खड़ा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","गधी यह देखकर चारदीवारी के साथ साथ चलने लगी, और बिलाम का पाँव कुचला गया। उसने उसे दुबारा मारा। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","रब का फ़रिश्ता आगे निकला और तीसरी मरतबा रास्ते में खड़ा हो गया। अब रास्ते से हट जाने की कोई गुंजाइश नहीं थी, न दाईं तरफ़ और न बाईं तरफ़। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","जब गधी ने रब का फ़रिश्ता देखा तो वह लेट गई। बिलाम को ग़ुस्सा आ गया, और उसने उसे अपनी लाठी से ख़ूब मारा। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","तब रब ने गधी को बोलने दिया, और उसने बिलाम से कहा, “मैंने आपसे क्या ग़लत सुलूक किया है कि आप मुझे अब तीसरी दफ़ा पीट रहे हैं?” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","बिलाम ने जवाब दिया, “तूने मुझे बेवुक़ूफ़ बनाया है! काश मेरे हाथ में तलवार होती तो मैं अभी तुझे ज़बह कर देता!” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","गधी ने बिलाम से कहा, “क्या मैं आपकी गधी नहीं हूँ जिस पर आप आज तक सवार होते रहे हैं? क्या मुझे कभी ऐसा करने की आदत थी?” उसने कहा, “नहीं।” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","फिर रब ने बिलाम की आँखें खोलीं और उसने रब के फ़रिश्ते को देखा जो अब तक हाथ में तलवार थामे हुए रास्ते में खड़ा था। बिलाम ने मुँह के बल गिरकर सिजदा किया। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","रब के फ़रिश्ते ने पूछा, “तूने तीन बार अपनी गधी को क्यों पीटा? मैं तेरे मुक़ाबले में आया हूँ, क्योंकि जिस तरफ़ तू बढ़ रहा है उसका अंजाम बुरा है। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","गधी तीन मरतबा मुझे देखकर मेरी तरफ़ से हट गई। अगर वह न हटती तो तू उस वक़्त हलाक हो गया होता अगरचे मैं गधी को छोड़ देता।” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","बिलाम ने रब के फ़रिश्ते से कहा, “मैंने गुनाह किया है। मुझे मालूम नहीं था कि तू मेरे मुक़ाबले में रास्ते में खड़ा है। लेकिन अगर मेरा सफ़र तुझे बुरा लगे तो मैं अब वापस चला जाऊँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","रब के फ़रिश्ते ने कहा, “इन आदमियों के साथ अपना सफ़र जारी रख। लेकिन सिर्फ़ वही कुछ कहना जो मैं तुझे बताऊँगा।” चुनाँचे बिलाम ने बलक़ के सरदारों के साथ अपना सफ़र जारी रखा। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","जब बलक़ को ख़बर मिली कि बिलाम आ रहा है तो वह उससे मिलने के लिए मोआब के उस शहर तक गया जो मोआब की सरहद दरियाए-अरनोन पर वाक़े है। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","उसने बिलाम से कहा, “क्या मैंने आपको इत्तला नहीं भेजी थी कि आप ज़रूर आएँ? आप क्यों नहीं आए? क्या आपने सोचा कि मैं आपको मुनासिब इनाम नहीं दे पाऊँगा?” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","बिलाम ने जवाब दिया, “बहरहाल अब मैं पहुँच गया हूँ। लेकिन मैं सिर्फ़ वही कुछ कह सकता हूँ जो अल्लाह ने पहले ही मेरे मुँह में डाल दिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","फिर बिलाम बलक़ के साथ क़िरियत-हुसात गया। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","वहाँ बलक़ ने गाय-बैल और भेड़-बकरियाँ क़ुरबान करके उनके गोश्त में से बिलाम और उसके साथवाले सरदारों को दे दिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","अगली सुबह बलक़ बिलाम को साथ लेकर एक ऊँची जगह पर चढ़ गया जिसका नाम बामोत-बाल था। वहाँ से इसराईली ख़ैमागाह का किनारा नज़र आता था। ");
INSERT INTO urdgvh_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","बिलाम ने कहा, “यहाँ मेरे लिए सात क़ुरबानगाहें बनाएँ। साथ साथ मेरे लिए सात बैल और सात मेंढे तैयार कर रखें।” ");
INSERT INTO urdgvh_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","बलक़ ने ऐसा ही किया, और दोनों ने मिलकर हर क़ुरबानगाह पर एक बैल और एक मेंढा चढ़ाया। ");
INSERT INTO urdgvh_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","फिर बिलाम ने बलक़ से कहा, “यहाँ अपनी क़ुरबानी के पास खड़े रहें। मैं कुछ फ़ासले पर जाता हूँ, शायद रब मुझसे मिलने आए। जो कुछ वह मुझ पर ज़ाहिर करे मैं आपको बता दूँगा।” यह कहकर वह एक ऊँचे मक़ाम पर चला गया जो हरियाली से बिलकुल महरूम था। ");
INSERT INTO urdgvh_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","वहाँ अल्लाह बिलाम से मिला। बिलाम ने कहा, “मैंने सात क़ुरबानगाहें तैयार करके हर क़ुरबानगाह पर एक बैल और एक मेंढा क़ुरबान किया है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","तब रब ने उसे बलक़ के लिए पैग़ाम दिया और कहा, “बलक़ के पास वापस जा और उसे यह पैग़ाम सुना।” ");
INSERT INTO urdgvh_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","बिलाम बलक़ के पास वापस आया जो अब तक मोआबी सरदारों के साथ अपनी क़ुरबानी के पास खड़ा था। ");
INSERT INTO urdgvh_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","बिलाम बोल उठा, “बलक़ मुझे अराम से यहाँ लाया है, मोआबी बादशाह ने मुझे मशरिक़ी पहाड़ों से बुलाकर कहा, ‘आओ, याक़ूब पर मेरे लिए लानत भेजो। आओ, इसराईल को बददुआ दो।’ ");
INSERT INTO urdgvh_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","मैं किस तरह उन पर लानत भेजूँ जिन पर अल्लाह ने लानत नहीं भेजी? मैं किस तरह उन्हें बददुआ दूँ जिन्हें रब ने बददुआ नहीं दी? ");
INSERT INTO urdgvh_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","मैं उन्हें चट्टानों की चोटी से देखता हूँ, पहाड़ियों से उनका मुशाहदा करता हूँ। वाक़ई यह एक ऐसी क़ौम है जो दूसरों से अलग रहती है। यह अपने आपको दूसरी क़ौमों से मुमताज़ समझती है। ");
INSERT INTO urdgvh_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","कौन याक़ूब की औलाद को गिन सकता है जो गर्द की मानिंद बेशुमार है। कौन इसराईलियों का चौथा हिस्सा भी गिन सकता है? रब करे कि मैं रास्तबाज़ों की मौत मरूँ, कि मेरा अंजाम उनके अंजाम जैसा अच्छा हो।” ");
INSERT INTO urdgvh_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","बलक़ ने बिलाम से कहा, “आपने मेरे साथ क्या किया है? मैं आपको अपने दुश्मनों पर लानत भेजने के लिए लाया और आपने उन्हें अच्छी-ख़ासी बरकत दी है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","बिलाम ने जवाब दिया, “क्या लाज़िम नहीं कि मैं वही कुछ बोलूँ जो रब ने बताने को कहा है?” ");
INSERT INTO urdgvh_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","फिर बलक़ ने उससे कहा, “आएँ, हम एक और जगह जाएँ जहाँ से आप इसराईली क़ौम को देख सकेंगे, गो उनकी ख़ैमागाह का सिर्फ़ किनारा ही नज़र आएगा। आप सबको नहीं देख सकेंगे। वहीं से उन पर मेरे लिए लानत भेजें।” ");
INSERT INTO urdgvh_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","यह कहकर वह उसके साथ पिसगा की चोटी पर चढ़कर पहरेदारों के मैदान तक पहुँच गया। वहाँ भी उसने सात क़ुरबानगाहें बनाकर हर एक पर एक बैल और एक मेंढा क़ुरबान किया। ");
INSERT INTO urdgvh_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","बिलाम ने बलक़ से कहा, “यहाँ अपनी क़ुरबानगाह के पास खड़े रहें। मैं कुछ फ़ासले पर जाकर रब से मिलूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","रब बिलाम से मिला। उसने उसे बलक़ के लिए पैग़ाम दिया और कहा, “बलक़ के पास वापस जा और उसे यह पैग़ाम सुना दे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","वह वापस चला गया। बलक़ अब तक अपने सरदारों के साथ अपनी क़ुरबानी के पास खड़ा था। उसने उससे पूछा, “रब ने क्या कहा?” ");
INSERT INTO urdgvh_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","बिलाम ने कहा, “ऐ बलक़, उठो और सुनो। ऐ सफ़ोर के बेटे, मेरी बात पर ग़ौर करो। ");
INSERT INTO urdgvh_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","अल्लाह आदमी नहीं जो झूट बोलता है। वह इनसान नहीं जो कोई फ़ैसला करके बाद में पछताए। क्या वह कभी अपनी बात पर अमल नहीं करता? क्या वह कभी अपनी बात पूरी नहीं करता? ");
INSERT INTO urdgvh_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","मुझे बरकत देने को कहा गया है। उसने बरकत दी है और मैं यह बरकत रोक नहीं सकता। ");
INSERT INTO urdgvh_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","याक़ूब के घराने में ख़राबी नज़र नहीं आती, इसराईल में दुख दिखाई नहीं देता। रब उसका ख़ुदा उसके साथ है, और क़ौम बादशाह की ख़ुशी में नारे लगाती है। ");
INSERT INTO urdgvh_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","अल्लाह उन्हें मिसर से निकाल लाया, और उन्हें जंगली बैल की ताक़त हासिल है। ");
INSERT INTO urdgvh_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","याक़ूब के घराने के ख़िलाफ़ जादूगरी नाकाम है, इसराईल के ख़िलाफ़ ग़ैबदानी बेफ़ायदा है। अब याक़ूब के घराने से कहा जाएगा, ‘अल्लाह ने कैसा काम किया है!’ ");
INSERT INTO urdgvh_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","इसराईली क़ौम शेरनी की तरह उठती और शेरबबर की तरह खड़ी हो जाती है। जब तक वह अपना शिकार न खा ले वह आराम नहीं करता, जब तक वह मारे हुए लोगों का ख़ून न पी ले वह नहीं लेटता।” ");
INSERT INTO urdgvh_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","यह सुनकर बलक़ ने कहा, “अगर आप उन पर लानत भेजने से इनकार करें, कम अज़ कम उन्हें बरकत तो न दें।” ");
INSERT INTO urdgvh_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","बिलाम ने जवाब दिया, “क्या मैंने आपको नहीं बताया था कि जो कुछ भी रब कहेगा मैं वही करूँगा?” ");
INSERT INTO urdgvh_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","तब बलक़ ने बिलाम से कहा, “आएँ, मैं आपको एक और जगह ले जाऊँ। शायद अल्लाह राज़ी हो जाए कि आप मेरे लिए वहाँ से उन पर लानत भेजें।” ");
INSERT INTO urdgvh_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","वह उसके साथ फ़ग़ूर पहाड़ पर चढ़ गया। उस की चोटी से यरदन की वादी का जुनूबी हिस्सा यशीमोन दिखाई दिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","बिलाम ने उससे कहा, “मेरे लिए यहाँ सात क़ुरबानगाहें बनाकर सात बैल और सात मेंढे तैयार कर रखें।” ");
INSERT INTO urdgvh_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","बलक़ ने ऐसा ही किया। उसने हर एक क़ुरबानगाह पर एक बैल और एक मेंढा क़ुरबान किया। ");
INSERT INTO urdgvh_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","अब बिलाम को उस बात का पूरा यक़ीन हो गया कि रब को पसंद है कि मैं इसराईलियों को बरकत दूँ। इसलिए उसने इस मरतबा पहले की तरह जादूगरी का तरीक़ा इस्तेमाल न किया बल्कि सीधा रेगिस्तान की तरफ़ रुख़ किया ");
INSERT INTO urdgvh_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","जहाँ इसराईल अपने अपने क़बीलों की तरतीब से ख़ैमाज़न था। यह देखकर अल्लाह का रूह उस पर नाज़िल हुआ, ");
INSERT INTO urdgvh_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","और वह बोल उठा, “बिलाम बिन बओर का पैग़ाम सुनो, उसके पैग़ाम पर ग़ौर करो जो साफ़ साफ़ देखता है, ");
INSERT INTO urdgvh_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","उसका पैग़ाम जो अल्लाह की बातें सुन लेता है, क़ादिरे-मुतलक़ की रोया को देख लेता है और ज़मीन पर गिरकर पोशीदा बातें देखता है। ");
INSERT INTO urdgvh_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","ऐ याक़ूब, तेरे ख़ैमे कितने शानदार हैं! ऐ इसराईल, तेरे घर कितने अच्छे हैं! ");
INSERT INTO urdgvh_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","वह दूर तक फैली हुई वादियों की मानिंद, नहर के किनारे लगे बाग़ों की मानिंद, रब के लगाए हुए ऊद के दरख़्तों की मानिंद, पानी के किनारे लगे देवदार के दरख़्तों की मानिंद हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","उनकी बालटियों से पानी छलकता रहेगा, उनके बीज को कसरत का पानी मिलेगा। उनका बादशाह अजाज से ज़्यादा ताक़तवर होगा, और उनकी सलतनत सरफ़राज़ होगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","अल्लाह उन्हें मिसर से निकाल लाया, और उन्हें जंगली बैल की-सी ताक़त हासिल है। वह मुख़ालिफ़ क़ौमों को हड़प करके उनकी हड्डियाँ चूर चूर कर देते हैं, वह अपने तीर चलाकर उन्हें मार डालते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","इसराईल शेरबबर या शेरनी की मानिंद है। जब वह दबककर बैठ जाए तो कोई भी उसे छेड़ने की जुर्रत नहीं करता। जो तुझे बरकत दे उसे बरकत मिले, और जो तुझ पर लानत भेजे उस पर लानत आए।” ");
INSERT INTO urdgvh_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","यह सुनकर बलक़ आपे से बाहर हुआ। उसने ताली बजाकर अपनी हिक़ारत का इज़हार किया और कहा, “मैंने तुझे इसलिए बुलाया था कि तू मेरे दुश्मनों पर लानत भेजे। अब तूने उन्हें तीनों बार बरकत ही दी है। ");
INSERT INTO urdgvh_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","अब दफ़ा हो जा! अपने घर वापस भाग जा! मैंने कहा था कि बड़ा इनाम दूँगा। लेकिन रब ने तुझे इनाम पाने से रोक दिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","बिलाम ने जवाब दिया, “क्या मैंने उन लोगों को जिन्हें आपने मुझे बुलाने के लिए भेजा था नहीं बताया था ");
INSERT INTO urdgvh_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","कि अगर बलक़ अपने महल को चाँदी और सोने से भरकर भी मुझे दे दे तो भी मैं रब की किसी बात की ख़िलाफ़वरज़ी नहीं कर सकता, ख़ाह मेरी नीयत अच्छी हो या बुरी। मैं सिर्फ़ वह कुछ कर सकता हूँ जो अल्लाह फ़रमाता है। ");
INSERT INTO urdgvh_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","अब मैं अपने वतन वापस चला जाता हूँ। लेकिन पहले मैं आपको बता देता हूँ कि आख़िरकार यह क़ौम आपकी क़ौम के साथ क्या कुछ करेगी।” ");
INSERT INTO urdgvh_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","वह बोल उठा, “बिलाम बिन बओर का पैग़ाम सुनो, उसका पैग़ाम जो साफ़ साफ़ देखता है, ");
INSERT INTO urdgvh_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","उसका पैग़ाम जो अल्लाह की बातें सुन लेता और अल्लाह तआला की मरज़ी को जानता है, जो क़ादिरे-मुतलक़ की रोया को देख लेता और ज़मीन पर गिरकर पोशीदा बातें देखता है। ");
INSERT INTO urdgvh_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","जिसे मैं देख रहा हूँ वह इस वक़्त नहीं है। जो मुझे नज़र आ रहा है वह क़रीब नहीं है। याक़ूब के घराने से सितारा निकलेगा, और इसराईल से असाए-शाही उठेगा जो मोआब के माथों और सेत के तमाम बेटों की खोपड़ियों को पाश पाश करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","अदोम उसके क़ब्ज़े में आएगा, उसका दुश्मन सईर उस की मिलकियत बनेगा जबकि इसराईल की ताक़त बढ़ती जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","याक़ूब के घराने से एक हुक्मरान निकलेगा जो शहर के बचे हुओं को हलाक कर देगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","फिर बिलाम ने अमालीक़ को देखा और कहा, “अमालीक़ क़ौमों में अव्वल था, लेकिन आख़िरकार वह ख़त्म हो जाएगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","फिर उसने क़ीनियों को देखा और कहा, “तेरी सुकूनतगाह मुस्तहकम है, तेरा चट्टान में बना घोंसला मज़बूत है। ");
INSERT INTO urdgvh_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","लेकिन तू तबाह हो जाएगा जब असूर तुझे गिरिफ़्तार करेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","एक और दफ़ा उसने बात की, “हाय, कौन ज़िंदा रह सकता है जब अल्लाह यों करेगा? ");
INSERT INTO urdgvh_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","कित्तीम के साहिल से बहरी जहाज़ आएँगे जो असूर और इबर को ज़लील करेंगे, लेकिन वह ख़ुद भी हलाक हो जाएंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","फिर बिलाम उठकर अपने घर वापस चला गया। बलक़ भी वहाँ से चला गया। ");
INSERT INTO urdgvh_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","जब इसराईली शित्तीम में रह रहे थे तो इसराईली मर्द मोआबी औरतों से ज़िनाकारी करने लगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","यह ऐसा हुआ कि मोआबी औरतें अपने देवताओं को क़ुरबानियाँ पेश करते वक़्त इसराईलियों को शरीक होने की दावत देने लगीं। इसराईली दावत क़बूल करके क़ुरबानियों से खाने और देवताओं को सिजदा करने लगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","इस तरीक़े से इसराईली मोआबी देवता बनाम बाल-फ़ग़ूर की पूजा करने लगे, और रब का ग़ज़ब उन पर आन पड़ा। ");
INSERT INTO urdgvh_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","उसने मूसा से कहा, “इस क़ौम के तमाम राहनुमाओं को सज़ाए-मौत देकर सूरज की रौशनी में रब के सामने लटका, वरना रब का इसराईलियों पर से ग़ज़ब नहीं टलेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","चुनाँचे मूसा ने इसराईल के क़ाज़ियों से कहा, “लाज़िम है कि तुममें से हर एक अपने उन आदमियों को जान से मार दे जो बाल-फ़ग़ूर देवता की पूजा में शरीक हुए हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","मूसा और इसराईल की पूरी जमात मुलाक़ात के ख़ैमे के दरवाज़े पर जमा होकर रोने लगे। इत्तफ़ाक़ से उसी वक़्त एक आदमी वहाँ से गुज़रा जो एक मिदियानी औरत को अपने घर ले जा रहा था। ");
INSERT INTO urdgvh_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","यह देखकर हारून का पोता फ़ीनहास बिन इलियज़र जमात से निकला और नेज़ा पकड़कर ");
INSERT INTO urdgvh_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","उस इसराईली के पीछे चल पड़ा। वह औरत समेत अपने ख़ैमे में दाख़िल हुआ तो फ़ीनहास ने उनके पीछे पीछे जाकर नेज़ा इतने ज़ोर से मारा कि वह दोनों में से गुज़र गया। उस वक़्त वबा फैलने लगी थी, लेकिन फ़ीनहास के इस अमल से वह रुक गई। ");
INSERT INTO urdgvh_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","तो भी 24,000 अफ़राद मर चुके थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“हारून के पोते फ़ीनहास बिन इलियज़र ने इसराईलियों पर मेरा ग़ुस्सा ठंडा कर दिया है। मेरी ग़ैरत अपनाकर वह इसराईल में दीगर माबूदों की पूजा को बरदाश्त न कर सका। इसलिए मेरी ग़ैरत ने इसराईलियों को नेस्तो-नाबूद नहीं किया। ");
INSERT INTO urdgvh_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","लिहाज़ा उसे बता देना कि मैं उसके साथ सलामती का अहद क़ायम करता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","इस अहद के तहत उसे और उस की औलाद को अबद तक इमाम का ओहदा हासिल रहेगा, क्योंकि अपने ख़ुदा की ख़ातिर ग़ैरत खाकर उसने इसराईलियों का कफ़्फ़ारा दिया।” ");
INSERT INTO urdgvh_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","जिस आदमी को मिदियानी औरत के साथ मार दिया गया उसका नाम ज़िमरी बिन सलू था, और वह शमौन के क़बीले के एक आबाई घराने का सरपरस्त था। ");
INSERT INTO urdgvh_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","मिदियानी औरत का नाम कज़बी था, और वह सूर की बेटी थी जो मिदियानियों के एक आबाई घराने का सरपरस्त था। ");
INSERT INTO urdgvh_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“मिदियानियों को दुश्मन क़रार देकर उन्हें मार डालना। ");
INSERT INTO urdgvh_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","क्योंकि उन्होंने अपनी चालाकियों से तुम्हारे साथ दुश्मन का-सा सुलूक किया, उन्होंने तुम्हें बाल-फ़ग़ूर की पूजा करने पर उकसाया और तुम्हें अपनी बहन मिदियानी सरदार की बेटी कज़बी के ज़रीए जिसे वबा फैलते वक़्त मार दिया गया बहकाया।” ");
INSERT INTO urdgvh_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","वबा के बाद रब ने मूसा और हारून के बेटे इलियज़र से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“पूरी इसराईली जमात की मर्दुमशुमारी उनके आबाई घरानों के मुताबिक़ करना। उन तमाम मर्दों को गिनना जो 20 साल या इससे ज़ायद के हैं और जो जंग लड़ने के क़ाबिल हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","4","मूसा और इलियज़र ने इसराईलियों को बताया कि रब ने उन्हें क्या हुक्म दिया है। चुनाँचे उन्होंने मोआब के मैदानी इलाक़े में यरीहू के सामने, लेकिन दरियाए-यरदन के मशरिक़ी किनारे पर मर्दुमशुमारी की। यह वह इसराईली आदमी थे जो मिसर से निकले थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","7","इसराईल के पहलौठे रूबिन के क़बीले के 43,730 मर्द थे। क़बीले के चार कुंबे हनूकी, फ़ल्लुवी, हसरोनी और करमी रूबिन के बेटों हनूक, फ़ल्लू, हसरोन और करमी से निकले हुए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","रूबिन का बेटा फ़ल्लू इलियाब का बाप था ");
INSERT INTO urdgvh_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","जिसके बेटे नमुएल, दातन और अबीराम थे। दातन और अबीराम वही लोग थे जिन्हें जमात ने चुना था और जिन्होंने क़ोरह के गुरोह समेत मूसा और हारून से झगड़ते हुए ख़ुद रब से झगड़ा किया। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","उस वक़्त ज़मीन ने अपना मुँह खोलकर उन्हें क़ोरह समेत हड़प कर लिया था। उसके 250 साथी भी मर गए थे जब आग ने उन्हें भस्म कर दिया। यों वह सब इसराईल के लिए इबरतअंगेज़ मिसाल बन गए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","लेकिन क़ोरह की पूरी नसल मिटाई नहीं गई थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","14","शमौन के क़बीले के 22,200 मर्द थे। क़बीले के पाँच कुंबे नमुएली, यमीनी, यकीनी, ज़ारही और साऊली शमौन के बेटों नमुएल, यमीन, यकीन, ज़ारह और साऊल से निकले हुए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","18","जद के क़बीले के 40,500 मर्द थे। क़बीले के सात कुंबे सफ़ोनी, हज्जी, सूनी, उज़नी, एरी, अरूदी और अरेली जद के बेटों सफ़ोन, हज्जी, सूनी, उज़नी, एरी, अरूद और अरेली से निकले हुए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","22","यहूदाह के क़बीले के 76,500 मर्द थे। यहूदाह के दो बेटे एर और ओनान मिसर आने से पहले कनान में मर गए थे। क़बीले के तीन कुंबे सेलानी, फ़ारसी और ज़ारही यहूदाह के बेटों सेला, फ़ारस और ज़ारह से निकले हुए थे। फ़ारस के दो बेटों हसरोन और हमूल से दो कुंबे हसरोनी और हमूली निकले हुए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","25","इशकार के क़बीले के 64,300 मर्द थे। क़बीले के चार कुंबे तोलई, फ़ुव्वी, यसूबी और सिमरोनी इशकार के बेटों तोला, फ़ुव्वा, यसूब और सिमरोन से निकले हुए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","27","ज़बूलून के क़बीले के 60,500 मर्द थे। क़बीले के तीन कुंबे सरदी, ऐलोनी और यहलियेली ज़बूलून के बेटों सरद, ऐलोन और यहलियेल से निकले हुए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","यूसुफ़ के दो बेटों मनस्सी और इफ़राईम के अलग अलग क़बीले बने। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","34","मनस्सी के क़बीले के 52,700 मर्द थे। क़बीले के आठ कुंबे मकीरी, जिलियादी, इयज़री, ख़लक़ी, असरियेली, सिकमी, समीदाई और हिफ़री थे। मकीरी मनस्सी के बेटे मकीर से जबकि जिलियादी मकीर के बेटे जिलियाद से निकले हुए थे। बाक़ी कुंबे जिलियाद के छः बेटों इयज़र, ख़लक़, असरियेल, सिकम, समीदा और हिफ़र से निकले हुए थे। हिफ़र सिलाफ़िहाद का बाप था। सिलाफ़िहाद का कोई बेटा नहीं बल्कि पाँच बेटियाँ महलाह, नुआह, हुजलाह, मिलकाह और तिरज़ा थीं। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","37","इफ़राईम के क़बीले के 32,500 मर्द थे। क़बीले के चार कुंबे सूतलही, बकरी, तहनी और ईरानी थे। पहले तीन कुंबे इफ़राईम के बेटों सूतलह, बकर और तहन से जबकि ईरानी सूतलह के बेटे ईरान से निकले हुए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","41","बिनयमीन के क़बीले के 45,600 मर्द थे। क़बीले के सात कुंबे बालाई, अशबेली, अख़ीरामी, सूफ़ामी, हूफ़ामी, अरदी और नामानी थे। पहले पाँच कुंबे बिनयमीन के बेटों बाला, अशबेल, अख़ीराम, सूफ़ाम और हूफ़ाम से जबकि अरदी और नामानी बाला के बेटों से निकले हुए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","43","दान के क़बीले के 64,400 मर्द थे। सब दान के बेटे सूहाम से निकले हुए थे, इसलिए सूहामी कहलाते थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","47","आशर के क़बीले के 53,400 मर्द थे। क़बीले के पाँच कुंबे यिमनी, इसवी, बरीई, हिबरी और मलकियेली थे। पहले तीन कुंबे आशर के बेटों यिमना, इसवी और बरिया से जबकि बाक़ी बरिया के बेटों हिबर और मलकियेल से निकले हुए थे। आशर की एक बेटी बनाम सिरह भी थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","50","नफ़ताली के क़बीले के 45,400 मर्द थे। क़बीले के चार कुंबे यहसियेली, जूनी, यिसरी और सिल्लीमी नफ़ताली के बेटों यहसियेल, जूनी, यिसर और सिल्लीम से निकले हुए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","इसराईली मर्दों की कुल तादाद 6,01,730 थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“जब मुल्के-कनान को तक़सीम किया जाएगा तो ज़मीन इनकी तादाद के मुताबिक़ देना है। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","बड़े क़बीलों को छोटे की निसबत ज़्यादा ज़मीन दी जाए। हर क़बीले का इलाक़ा उस की तादाद से मुताबिक़त रखे। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","56","क़ुरा डालने से फ़ैसला किया जाए कि हर क़बीले को कहाँ ज़मीन मिलेगी। लेकिन हर क़बीले के इलाक़े का रक़बा इस पर मबनी हो कि क़बीले के कितने अफ़राद हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","लावी के क़बीले के तीन कुंबे जैरसोनी, क़िहाती और मिरारी लावी के बेटों जैरसोन, क़िहात और मिरारी से निकले हुए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","इसके अलावा लिबनी, हिब्रूनी, महली, मूशी और कोरही भी लावी के कुंबे थे। क़िहात अमराम का बाप था। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","अमराम ने लावी औरत यूकबिद से शादी की जो मिसर में पैदा हुई थी। उनके दो बेटे हारून और मूसा और एक बेटी मरियम पैदा हुए। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","हारून के बेटे नदब, अबीहू, इलियज़र और इतमर थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","लेकिन नदब और अबीहू रब को बख़ूर की नाजायज़ क़ुरबानी पेश करने के बाइस मर गए। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","लावियों के मर्दों की कुल तादाद 23,000 थी। इनमें वह सब शामिल थे जो एक माह या इससे ज़ायद के थे। उन्हें दूसरे इसराईलियों से अलग गिना गया, क्योंकि उन्हें इसराईल में मीरास में ज़मीन नहीं मिलनी थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","यों मूसा और इलियज़र ने मोआब के मैदानी इलाक़े में यरीहू के सामने लेकिन दरियाए-यरदन के मशरिक़ी किनारे पर इसराईलियों की मर्दुमशुमारी की। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","लोगों को गिनते गिनते उन्हें मालूम हुआ कि जो लोग दश्ते-सीन में मूसा और हारून की पहली मर्दुमशुमारी में गिने गए थे वह सब मर चुके हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","रब ने कहा था कि वह सबके सब रेगिस्तान में मर जाएंगे, और ऐसा ही हुआ था। सिर्फ़ कालिब बिन यफ़ुन्ना और यशुअ बिन नून ज़िंदा रहे। ");
INSERT INTO urdgvh_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","सिलाफ़िहाद की पाँच बेटियाँ महलाह, नुआह, हुजलाह, मिलकाह और तिरज़ा थीं। सिलाफ़िहाद यूसुफ़ के बेटे मनस्सी के कुंबे का था। उसका पूरा नाम सिलाफ़िहाद बिन हिफ़र बिन जिलियाद बिन मकीर बिन मनस्सी बिन यूसुफ़ था। ");
INSERT INTO urdgvh_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","सिलाफ़िहाद की बेटियाँ मुलाक़ात के ख़ैमे के दरवाज़े पर आकर मूसा, इलियज़र इमाम और पूरी जमात के सामने खड़ी हुईं। उन्होंने कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“हमारा बाप रेगिस्तान में फ़ौत हुआ। लेकिन वह क़ोरह के उन साथियों में से नहीं था जो रब के ख़िलाफ़ मुत्तहिद हुए थे। वह इस सबब से न मरा बल्कि अपने ज़ाती गुनाह के बाइस। जब वह मर गया तो उसका कोई बेटा नहीं था। ");
INSERT INTO urdgvh_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","क्या यह ठीक है कि हमारे ख़ानदान में बेटा न होने के बाइस हमें ज़मीन न मिले और हमारे बाप का नामो-निशान मिट जाए? हमें भी हमारे बाप के दीगर रिश्तेदारों के साथ ज़मीन दें।” ");
INSERT INTO urdgvh_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","मूसा ने उनका मामला रब के सामने पेश किया ");
INSERT INTO urdgvh_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","तो रब ने उससे कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“जो बात सिलाफ़िहाद की बेटियाँ कर रही हैं वह दुरुस्त है। उन्हें ज़रूर उनके बाप के रिश्तेदारों के साथ ज़मीन मिलनी चाहिए। उन्हें बाप का विरसा मिल जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","इसराईलियों को भी बताना कि जब भी कोई आदमी मर जाए जिसका बेटा न हो तो उस की बेटी को उस की मीरास मिल जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","अगर उस की बेटी भी न हो तो उसके भाइयों को उस की मीरास मिल जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","अगर उसके भाई भी न हों तो उसके बाप के भाइयों को उस की मीरास मिल जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","अगर यह भी न हों तो उसके सबसे क़रीबी रिश्तेदार को उस की मीरास मिल जाए। वह उस की ज़ाती मिलकियत होगी। यह उसूल इसराईलियों के लिए क़ानूनी हैसियत रखता है। वह इसे वैसा मानें जैसा रब ने मूसा को हुक्म दिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","फिर रब ने मूसा से कहा, “अबारीम के पहाड़ी सिलसिले के इस पहाड़ पर चढ़कर उस मुल्क पर निगाह डाल जो मैं इसराईलियों को दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","उसे देखने के बाद तू भी अपने भाई हारून की तरह कूच करके अपने बापदादा से जा मिलेगा, ");
INSERT INTO urdgvh_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","क्योंकि तुम दोनों ने दश्ते-सीन में मेरे हुक्म की ख़िलाफ़वरज़ी की। उस वक़्त जब पूरी जमात ने मरीबा में मेरे ख़िलाफ़ गिला-शिकवा किया तो तूने चट्टान से पानी निकालते वक़्त लोगों के सामने मेरी क़ुद्दूसियत क़ायम न रखी।” (मरीबा दश्ते-सीन के क़ादिस में चश्मा है।) ");
INSERT INTO urdgvh_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","मूसा ने रब से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“ऐ रब, तमाम जानों के ख़ुदा, जमात पर किसी आदमी को मुक़र्रर कर ");
INSERT INTO urdgvh_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","जो उनके आगे आगे जंग के लिए निकले और उनके आगे आगे वापस आ जाए, जो उन्हें बाहर ले जाए और वापस ले आए। वरना रब की जमात उन भेड़ों की मानिंद होगी जिनका कोई चरवाहा न हो।” ");
INSERT INTO urdgvh_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","जवाब में रब ने मूसा से कहा, “यशुअ बिन नून को चुन ले जिसमें मेरा रूह है, और अपना हाथ उस पर रख। ");
INSERT INTO urdgvh_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","उसे इलियज़र इमाम और पूरी जमात के सामने खड़ा करके उनके रूबरू ही उसे राहनुमाई की ज़िम्मादारी दे। ");
INSERT INTO urdgvh_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","अपने इख़्तियार में से कुछ उसे दे ताकि इसराईल की पूरी जमात उस की इताअत करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","रब की मरज़ी जानने के लिए वह इलियज़र इमाम के सामने खड़ा होगा तो इलियज़र रब के सामने ऊरीम और तुम्मीम इस्तेमाल करके उस की मरज़ी दरियाफ़्त करेगा। उसी के हुक्म पर यशुअ और इसराईल की पूरी जमात ख़ैमागाह से निकलेंगे और वापस आएँगे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","मूसा ने ऐसा ही किया। उसने यशुअ को चुनकर इलियज़र और पूरी जमात के सामने खड़ा किया। ");
INSERT INTO urdgvh_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","फिर उसने उस पर अपने हाथ रखकर उसे राहनुमाई की ज़िम्मादारी सौंपी जिस तरह रब ने उसे बताया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“इसराईलियों को बताना, ख़याल रखो कि तुम मुक़र्ररा औक़ात पर मुझे जलनेवाली क़ुरबानियाँ पेश करो। यह मेरी रोटी हैं और इनकी ख़ुशबू मुझे पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","रब को जलनेवाली यह क़ुरबानी पेश करना : रोज़ाना भेड़ के दो यकसाला बच्चे जो बेऐब हों पूरे तौर पर जला देना। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","एक को सुबह के वक़्त पेश करना और दूसरे को सूरज के डूबने के ऐन बाद। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","भेड़ के बच्चे के साथ ग़ल्ला की नज़र भी पेश की जाए यानी डेढ़ किलोग्राम बेहतरीन मैदा जो एक लिटर ज़ैतून के कूटकर निकाले हुए तेल के साथ मिलाया गया हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","यह रोज़मर्रा की क़ुरबानी है जो पूरे तौर पर जलाई जाती है और पहली दफ़ा सीना पहाड़ पर चढ़ाई गई। इस जलनेवाली क़ुरबानी की ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","8","साथ ही एक लिटर शराब भी नज़र के तौर पर क़ुरबानगाह पर डाली जाए। सुबह और शाम की यह क़ुरबानियाँ दोनों ही इस तरीक़े से पेश की जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","सबत के दिन भेड़ के दो और बच्चे चढ़ाना। वह भी बेऐब और एक साल के हों। साथ ही मै और ग़ल्ला की नज़रें भी पेश की जाएँ। ग़ल्ला की नज़र के लिए 3 किलोग्राम बेहतरीन मैदा तेल के साथ मिलाया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","भस्म होनेवाली यह क़ुरबानी हर हफ़ते के दिन पेश करनी है। यह रोज़मर्रा की क़ुरबानियों के अलावा है। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","हर माह के शुरू में रब को भस्म होनेवाली क़ुरबानी के तौर पर दो जवान बैल, एक मेंढा और भेड़ के सात यकसाला बच्चे पेश करना। सब बग़ैर नुक़्स के हों। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","हर जानवर के साथ ग़ल्ला की नज़र पेश करना जिसके लिए तेल में मिलाया गया बेहतरीन मैदा इस्तेमाल किया जाए। हर बैल के साथ साढ़े 4 किलोग्राम, हर मेंढे के साथ 3 किलोग्राम ");
INSERT INTO urdgvh_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","और भेड़ के हर बच्चे के साथ डेढ़ किलोग्राम मैदा पेश करना। भस्म होनेवाली यह क़ुरबानियाँ रब को पसंद हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","इन क़ुरबानियों के साथ मै की नज़र भी क़ुरबानगाह पर डालना यानी हर बैल के साथ दो लिटर, हर मेंढे के साथ सवा लिटर और भेड़ के हर बच्चे के साथ एक लिटर मै पेश करना। यह क़ुरबानी साल में हर महीने के पहले दिन के मौक़े पर पेश करनी है। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","इस क़ुरबानी और रोज़मर्रा की क़ुरबानियों के अलावा रब को एक बकरा गुनाह की क़ुरबानी के तौर पर पेश करना। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","पहले महीने के चौधवें दिन फ़सह की ईद मनाई जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","अगले दिन पूरे हफ़ते की वह ईद शुरू होती है जिसके दौरान तुम्हें सिर्फ़ बेख़मीरी रोटी खानी है। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","पहले दिन काम न करना बल्कि मुक़द्दस इजतिमा के लिए इकट्ठे होना। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","रब के हुज़ूर भस्म होनेवाली क़ुरबानी के तौर पर दो जवान बैल, एक मेंढा और भेड़ के सात यकसाला बच्चे पेश करना। सब बग़ैर नुक़्स के हों। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","हर जानवर के साथ ग़ल्ला की नज़र भी पेश करना जिसके लिए तेल के साथ मिलाया गया बेहतरीन मैदा इस्तेमाल किया जाए। हर बैल के साथ साढ़े 4 किलोग्राम, हर मेंढे के साथ 3 किलोग्राम ");
INSERT INTO urdgvh_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","और भेड़ के हर बच्चे के साथ डेढ़ किलोग्राम मैदा पेश करना। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","गुनाह की क़ुरबानी के तौर पर एक बकरा भी पेश करना ताकि तुम्हारा कफ़्फ़ारा दिया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","24","इन तमाम क़ुरबानियों को ईद के दौरान हर रोज़ पेश करना। यह रोज़मर्रा की भस्म होनेवाली क़ुरबानियों के अलावा हैं। इस ख़ुराक की ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","सातवें दिन काम न करना बल्कि मुक़द्दस इजतिमा के लिए इकट्ठे होना। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","फ़सल की कटाई के पहले दिन की ईद पर जब तुम रब को अपनी फ़सल की पहली पैदावार पेश करते हो तो काम न करना बल्कि मुक़द्दस इजतिमा के लिए इकट्ठे होना। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","29","उस दिन दो जवान बैल, एक मेंढा और भेड़ के सात यकसाला बच्चे क़ुरबानगाह पर पूरे तौर पर जला देना। इसके साथ ग़ल्ला और मै की वही नज़रें पेश करना जो फ़सह की ईद पर भी पेश की जाती हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","इसके अलावा रब को एक बकरा गुनाह की क़ुरबानी के तौर पर चढ़ाना। ");
INSERT INTO urdgvh_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","यह तमाम क़ुरबानियाँ रोज़मर्रा की भस्म होनेवाली क़ुरबानियों और उनके साथवाली ग़ल्ला और मै की नज़रों के अलावा हैं। वह बेऐब हों। ");
INSERT INTO urdgvh_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","सातवें माह के पंद्रहवें दिन भी काम न करना बल्कि मुक़द्दस इजतिमा के लिए इकट्ठे होना। उस दिन नरसिंगे फूँके जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","रब को भस्म होनेवाली क़ुरबानी पेश की जाए जिसकी ख़ुशबू उसे पसंद हो यानी एक जवान बैल, एक मेंढा और भेड़ के सात यकसाला बच्चे। सब नुक़्स के बग़ैर हों। ");
INSERT INTO urdgvh_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","हर जानवर के साथ ग़ल्ला की नज़र भी पेश करना जिसके लिए तेल के साथ मिलाया गया बेहतरीन मैदा इस्तेमाल किया जाए। बैल के साथ साढ़े 4 किलोग्राम, मेंढे के साथ 3 किलोग्राम ");
INSERT INTO urdgvh_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","और भेड़ के हर बच्चे के साथ डेढ़ किलोग्राम मैदा पेश करना। ");
INSERT INTO urdgvh_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","एक बकरा भी गुनाह की क़ुरबानी के तौर पर पेश करना ताकि तुम्हारा कफ़्फ़ारा दिया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","यह क़ुरबानियाँ रोज़ाना और हर माह के पहले दिन की क़ुरबानियों और उनके साथ की ग़ल्ला और मै की नज़रों के अलावा हैं। इनकी ख़ुशबू रब को पसंद है। ");
INSERT INTO urdgvh_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","सातवें महीने के दसवें दिन मुक़द्दस इजतिमा के लिए इकट्ठे होना। उस दिन काम न करना और अपनी जान को दुख देना। ");
INSERT INTO urdgvh_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","11","रब को वही क़ुरबानियाँ पेश करना जो इसी महीने के पहले दिन पेश की जाती हैं। सिर्फ़ एक फ़रक़ है, उस दिन एक नहीं बल्कि दो बकरे गुनाह की क़ुरबानी के तौर पर पेश किए जाएँ ताकि तुम्हारा कफ़्फ़ारा दिया जाए। ऐसी क़ुरबानियाँ रब को पसंद हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","सातवें महीने के पंद्रहवें दिन भी काम न करना बल्कि मुक़द्दस इजतिमा के लिए इकट्ठे होना। सात दिन तक रब की ताज़ीम में ईद मनाना। ");
INSERT INTO urdgvh_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","ईद के पहले दिन रब को 13 जवान बैल, 2 मेंढे और 14 भेड़ के यकसाला बच्चे भस्म होनेवाली क़ुरबानी के तौर पर पेश करना। इनकी ख़ुशबू उसे पसंद है। सब नुक़्स के बग़ैर हों। ");
INSERT INTO urdgvh_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","हर जानवर के साथ ग़ल्ला की नज़र भी पेश करना जिसके लिए तेल से मिलाया गया बेहतरीन मैदा इस्तेमाल किया जाए। हर बैल के साथ साढ़े 4 किलोग्राम, हर मेंढे के साथ 3 किलोग्राम ");
INSERT INTO urdgvh_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","और भेड़ के हर बच्चे के साथ डेढ़ किलोग्राम मैदा पेश करना। ");
INSERT INTO urdgvh_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","इसके अलावा एक बकरा भी गुनाह की क़ुरबानी के तौर पर पेश करना। यह क़ुरबानियाँ रोज़ाना की भस्म होनेवाली क़ुरबानियों और उनके साथवाली ग़ल्ला और मै की नज़रों के अलावा हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","34","ईद के बाक़ी छः दिन यही क़ुरबानियाँ पेश करनी हैं। लेकिन हर दिन एक बैल कम हो यानी दूसरे दिन 12, तीसरे दिन 11, चौथे दिन 10, पाँचवें दिन 9, छटे दिन 8 और सातवें दिन 7 बैल। हर दिन गुनाह की क़ुरबानी के लिए बकरा और मामूल की रोज़ाना की क़ुरबानियाँ भी पेश करना। ");
INSERT INTO urdgvh_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","ईद के आठवें दिन काम न करना बल्कि मुक़द्दस इजतिमा के लिए इकट्ठे होना। ");
INSERT INTO urdgvh_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","रब को एक जवान बैल, एक मेंढा और भेड़ के सात यकसाला बच्चे भस्म होनेवाली क़ुरबानी के तौर पर पेश करना। इनकी ख़ुशबू रब को पसंद है। सब नुक़्स के बग़ैर हों। ");
INSERT INTO urdgvh_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","38","साथ ही वह तमाम क़ुरबानियाँ भी पेश करना जो पहले दिन पेश की जाती हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","यह सब वही क़ुरबानियाँ हैं जो तुम्हें रब को अपनी ईदों पर पेश करनी हैं। यह उन तमाम क़ुरबानियों के अलावा हैं जो तुम दिली ख़ुशी से या मन्नत मानकर देते हो, चाहे वह भस्म होनेवाली, ग़ल्ला की, मै की या सलामती की क़ुरबानियाँ क्यों न हों।” ");
INSERT INTO urdgvh_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","मूसा ने रब की यह तमाम हिदायात इसराईलियों को बता दीं। ");
INSERT INTO urdgvh_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","फिर मूसा ने क़बीलों के सरदारों से कहा, “रब फ़रमाता है, ");
INSERT INTO urdgvh_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","अगर कोई आदमी रब को कुछ देने की मन्नत माने या किसी चीज़ से परहेज़ करने की क़सम खाए तो वह अपनी बात पर क़ायम रहकर उसे पूरा करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","अगर कोई जवान औरत जो अब तक अपने बाप के घर में रहती है रब को कुछ देने की मन्नत माने या किसी चीज़ से परहेज़ करने की क़सम खाए ");
INSERT INTO urdgvh_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","तो लाज़िम है कि वह अपनी मन्नत या क़सम की हर बात पूरी करे। शर्त यह है कि उसका बाप उसके बारे में सुनकर एतराज़ न करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","लेकिन अगर उसका बाप यह सुनकर उसे ऐसा करने से मना करे तो उस की मन्नत या क़सम मनसूख़ है, और वह उसे पूरा करने से बरी है। रब उसे मुआफ़ करेगा, क्योंकि उसके बाप ने उसे मना किया है। ");
INSERT INTO urdgvh_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","हो सकता है कि किसी ग़ैरशादीशुदा औरत ने मन्नत मानी या किसी चीज़ से परहेज़ करने की क़सम खाई, चाहे उसने दानिस्ता तौर पर या बेसोचे-समझे ऐसा किया। इसके बाद उस औरत ने शादी कर ली। ");
INSERT INTO urdgvh_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","शादीशुदा हालत में भी लाज़िम है कि वह अपनी मन्नत या क़सम की हर बात पूरी करे। शर्त यह है कि उसका शौहर इसके बारे में सुनकर एतराज़ न करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","लेकिन अगर उसका शौहर यह सुनकर उसे ऐसा करने से मना करे तो उस की मन्नत या क़सम मनसूख़ है, और वह उसे पूरा करने से बरी है। रब उसे मुआफ़ करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","अगर किसी बेवा या तलाक़शुदा औरत ने मन्नत मानी या किसी चीज़ से परहेज़ करने की क़सम खाई तो लाज़िम है कि वह अपनी हर बात पूरी करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","अगर किसी शादीशुदा औरत ने मन्नत मानी या किसी चीज़ से परहेज़ करने की क़सम खाई ");
INSERT INTO urdgvh_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","तो लाज़िम है कि वह अपनी हर बात पूरी करे। शर्त यह है कि उसका शौहर उसके बारे में सुनकर एतराज़ न करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","लेकिन अगर उसका शौहर उसे ऐसा करने से मना करे तो उस की मन्नत या क़सम मनसूख़ है। वह उसे पूरा करने से बरी है। रब उसे मुआफ़ करेगा, क्योंकि उसके शौहर ने उसे मना किया है। ");
INSERT INTO urdgvh_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","चाहे बीवी ने कुछ देने की मन्नत मानी हो या किसी चीज़ से परहेज़ करने की क़सम खाई हो, उसके शौहर को उस की तसदीक़ या उसे मनसूख़ करने का इख़्तियार है। ");
INSERT INTO urdgvh_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","अगर उसने अपनी बीवी की मन्नत या क़सम के बारे में सुन लिया और अगले दिन तक एतराज़ न किया तो लाज़िम है कि उस की बीवी अपनी हर बात पूरी करे। शौहर ने अगले दिन तक एतराज़ न करने से अपनी बीवी की बात की तसदीक़ की है। ");
INSERT INTO urdgvh_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","अगर वह इसके बाद यह मन्नत या क़सम मनसूख़ करे तो उसे इस क़ुसूर के नतायज भुगतने पड़ेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","रब ने मूसा को यह हिदायात दीं। यह ऐसी औरतों की मन्नतों या क़समों के उसूल हैं जो ग़ैरशादीशुदा हालत में अपने बाप के घर में रहती हैं या जो शादीशुदा हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“मिदियानियों से इसराईलियों का बदला ले। इसके बाद तू कूच करके अपने बापदादा से जा मिलेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","चुनाँचे मूसा ने इसराईलियों से कहा, “हथियारों से अपने कुछ आदमियों को लैस करो ताकि वह मिदियान से जंग करके रब का बदला लें। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","हर क़बीले के 1,000 मर्द जंग लड़ने के लिए भेजो।” ");
INSERT INTO urdgvh_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","चुनाँचे हर क़बीले के 1,000 मुसल्लह मर्द यानी कुल 12,000 आदमी चुने गए। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","तब मूसा ने उन्हें जंग लड़ने के लिए भेज दिया। उसने इलियज़र इमाम के बेटे फ़ीनहास को भी उनके साथ भेजा जिसके पास मक़दिस की कुछ चीज़ें और एलान करने के बिगुल थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","उन्होंने रब के हुक्म के मुताबिक़ मिदियानियों से जंग की और तमाम आदमियों को मौत के घाट उतार दिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","इनमें मिदियानियों के पाँच बादशाह इवी, रक़म, सूर, हूर और रबा थे। बिलाम बिन बओर को भी जान से मार दिया गया। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","इसराईलियों ने मिदियानी औरतों और बच्चों को गिरिफ़्तार करके उनके तमाम गाय-बैल, भेड़-बकरियाँ और माल लूट लिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","उन्होंने उनकी तमाम आबादियों को ख़ैमागाहों समेत जलाकर राख कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","12","फिर वह तमाम लूटा हुआ माल क़ैदियों और जानवरों समेत मूसा, इलियज़र इमाम और इसराईल की पूरी जमात के पास ले आए जो ख़ैमागाह में इंतज़ार कर रहे थे। अभी तक वह मोआब के मैदानी इलाक़े में दरियाए-यरदन के मशरिक़ी किनारे पर यरीहू के सामने ठहरे हुए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","मूसा, इलियज़र और जमात के तमाम सरदार उनका इस्तक़बाल करने के लिए ख़ैमागाह से निकले। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","उन्हें देखकर मूसा को हज़ार हज़ार और सौ सौ अफ़राद पर मुक़र्रर अफ़सरान पर ग़ुस्सा आया। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","उसने कहा, “आपने तमाम औरतों को क्यों बचाए रखा? ");
INSERT INTO urdgvh_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","उन्हीं ने बिलाम के मशवरे पर फ़ग़ूर में इसराईलियों को रब से दूर कर दिया था। उन्हीं के सबब से रब की वबा उसके लोगों में फैल गई। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","चुनाँचे अब तमाम लड़कों को जान से मार दो। उन तमाम औरतों को भी मौत के घाट उतारना जो कुँवारियाँ नहीं हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","लेकिन तमाम कुँवारियों को बचाए रखना। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","जिसने भी किसी को मार दिया या किसी लाश को छुआ है वह सात दिन तक ख़ैमागाह के बाहर रहे। तीसरे और सातवें दिन अपने आपको अपने क़ैदियों समेत गुनाह से पाक-साफ़ करना। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","हर लिबास और हर चीज़ को पाक-साफ़ करना जो चमड़े, बकरियों के बालों या लकड़ी की हो।” ");
INSERT INTO urdgvh_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","फिर इलियज़र इमाम ने जंग से वापस आनेवाले मर्दों से कहा, “जो शरीअत रब ने मूसा को दी उसके मुताबिक़ ");
INSERT INTO urdgvh_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","जो भी चीज़ जल नहीं जाती उसे आग में से गुज़ार देना ताकि पाक-साफ़ हो जाए। उसमें सोना, चाँदी, पीतल, लोहा, टीन और सीसा शामिल है। फिर उस पर नापाकी दूर करने का पानी छिड़कना। बाक़ी तमाम चीज़ें पानी में से गुज़ार देना ताकि वह पाक-साफ़ हो जाएँ। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","सातवें दिन अपने लिबास को धोना तो तुम पाक-साफ़ होकर ख़ैमागाह में दाख़िल हो सकते हो।” ");
INSERT INTO urdgvh_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“तमाम क़ैदियों और लूटे हुए जानवरों को गिन। इसमें इलियज़र इमाम और क़बायली कुंबों के सरपरस्त तेरी मदद करें। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","सारा माल दो बराबर के हिस्सों में तक़सीम करना, एक हिस्सा फ़ौजियों के लिए और दूसरा बाक़ी जमात के लिए हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","फ़ौजियों के हिस्से के पाँच पाँच सौ क़ैदियों में से एक एक निकालकर रब को देना। इसी तरह पाँच पाँच सौ बैलों, गधों, भेड़ों और बकरियों में से एक एक निकालकर रब को देना। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","उन्हें इलियज़र इमाम को देना ताकि वह उन्हें रब को उठानेवाली क़ुरबानी के तौर पर पेश करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","बाक़ी जमात के हिस्से के पचास पचास क़ैदियों में से एक एक निकालकर रब को देना, इसी तरह पचास पचास बैलों, गधों, भेड़ों और बकरियों या दूसरे जानवरों में से भी एक एक निकालकर रब को देना। उन्हें उन लावियों को देना जो रब के मक़दिस को सँभालते हैं।” ");
INSERT INTO urdgvh_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","मूसा और इलियज़र ने ऐसा ही किया। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","34","उन्होंने 6,75,000 भेड़-बकरियाँ, 72,000 गाय-बैल और 61,000 गधे गिने। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","इनके अलावा 32,000 क़ैदी कुँवारियाँ भी थीं। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","40","फ़ौजियों को तमाम चीज़ों का आधा हिस्सा मिल गया यानी 3,37,500 भेड़-बकरियाँ, 36,000 गाय-बैल, 30,500 गधे और 16,000 क़ैदी कुँवारियाँ। इनमें से उन्होंने 675 भेड़-बकरियाँ, 72 गाय-बैल, 61 गधे और 32 लड़कियाँ रब को दीं। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","मूसा ने रब का यह हिस्सा इलियज़र इमाम को उठानेवाली क़ुरबानी के तौर पर दे दिया, जिस तरह रब ने हुक्म दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","47","बाक़ी जमात को भी लूटे हुए माल का आधा हिस्सा मिल गया। मूसा ने पचास पचास क़ैदियों और जानवरों में से एक एक निकालकर उन लावियों को दे दिया जो रब का मक़दिस सँभालते थे। उसने वैसा ही किया जैसा रब ने हुक्म दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","फिर वह अफ़सर मूसा के पास आए जो लशकर के हज़ार हज़ार और सौ सौ आदमियों पर मुक़र्रर थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","उन्होंने उससे कहा, “आपके ख़ादिमों ने उन फ़ौजियों को गिन लिया है जिन पर वह मुक़र्रर हैं, और हमें पता चल गया कि एक भी कम नहीं हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","इसलिए हम रब को सोने का तमाम ज़ेवर क़ुरबान करना चाहते हैं जो हमें फ़तह पाने पर मिला था मसलन सोने के बाज़ूबंद, कंगन, मुहर लगाने की अंगूठियाँ, बालियाँ और हार। यह सब कुछ हम रब को पेश करना चाहते हैं ताकि रब के सामने हमारा कफ़्फ़ारा हो जाए।” ");
INSERT INTO urdgvh_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","मूसा और इलियज़र इमाम ने सोने की तमाम चीज़ें उनसे ले लीं। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","जो चीज़ें उन्होंने अफ़सरान के लूटे हुए माल में से रब को उठानेवाली क़ुरबानी के तौर पर पेश कीं उनका पूरा वज़न तक़रीबन 190 किलोग्राम था। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","सिर्फ़ अफ़सरान ने ऐसा किया। बाक़ी फ़ौजियों ने अपना लूट का माल अपने लिए रख लिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","मूसा और इलियज़र अफ़सरान का यह सोना मुलाक़ात के ख़ैमे में ले आए ताकि वह रब को उस की क़ौम की याद दिलाता रहे। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","रूबिन और जद के क़बीलों के पास बहुत-से मवेशी थे। जब उन्होंने देखा कि याज़ेर और जिलियाद का इलाक़ा मवेशी पालने के लिए अच्छा है ");
INSERT INTO urdgvh_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","तो उन्होंने मूसा, इलियज़र इमाम और जमात के राहनुमाओं के पास आकर कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","“जिस इलाक़े को रब ने इसराईल की जमात के आगे आगे शिकस्त दी है वह मवेशी पालने के लिए अच्छा है। अतारात, दीबोन, याज़ेर, निमरा, हसबोन, इलियाली, सबाम, नबू और बऊन जो इसमें शामिल हैं हमारे काम आएँगे, क्योंकि आपके ख़ादिमों के पास मवेशी हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","अगर आपकी नज़रे-करम हम पर हो तो हमें यह इलाक़ा दिया जाए। यह हमारी मिलकियत बन जाए और हमें दरियाए-यरदन को पार करने पर मजबूर न किया जाए।” ");
INSERT INTO urdgvh_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","मूसा ने जद और रूबिन के अफ़राद से कहा, “क्या तुम यहाँ पीछे रहकर अपने भाइयों को छोड़ना चाहते हो जब वह जंग लड़ने के लिए आगे निकलेंगे? ");
INSERT INTO urdgvh_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","इस वक़्त जब इसराईली दरियाए-यरदन को पार करके उस मुल्क में दाख़िल होनेवाले हैं जो रब ने उन्हें दिया है तो तुम क्यों उनकी हौसलाशिकनी कर रहे हो? ");
INSERT INTO urdgvh_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","तुम्हारे बापदादा ने भी यही कुछ किया जब मैंने उन्हें क़ादिस-बरनीअ से मुल्क के बारे में मालूमात हासिल करने के लिए भेजा। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","इसकाल की वादी में पहुँचकर मुल्क की तफ़तीश करने के बाद उन्होंने इसराईलियों की हौसलाशिकनी की ताकि वह उस मुल्क में दाख़िल न हों जो रब ने उन्हें दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","उस दिन रब ने ग़ुस्से में आकर क़सम खाई, ");
INSERT INTO urdgvh_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘उन आदमियों में से जो मिसर से निकल आए हैं कोई उस मुल्क को नहीं देखेगा जिसका वादा मैंने क़सम खाकर इब्राहीम, इसहाक़ और याक़ूब से किया था। क्योंकि उन्होंने पूरी वफ़ादारी से मेरी पैरवी न की। सिर्फ़ वह जिनकी उम्र उस वक़्त 20 साल से कम है दाख़िल होंगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","बुज़ुर्गों में से सिर्फ़ कालिब बिन यफ़ुन्ना क़निज़्ज़ी और यशुअ बिन नून मुल्क में दाख़िल होंगे, इसलिए कि उन्होंने पूरी वफ़ादारी से मेरी पैरवी की।’ ");
INSERT INTO urdgvh_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","उस वक़्त रब का ग़ज़ब उन पर आन पड़ा, और उन्हें 40 साल तक रेगिस्तान में मारे मारे फिरना पड़ा, जब तक कि वह तमाम नसल ख़त्म न हो गई जिसने उसके नज़दीक ग़लत काम किया था। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","अब तुम गुनाहगारों की औलाद अपने बापदादा की जगह खड़े होकर रब का इसराईल पर ग़ुस्सा मज़ीद बढ़ा रहे हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","अगर तुम उस की पैरवी से हटोगे तो वह दुबारा इन लोगों को रेगिस्तान में रहने देगा, और तुम इनकी हलाकत का बाइस बनोगे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","इसके बाद रूबिन और जद के अफ़राद दुबारा मूसा के पास आए और कहा, “हम यहाँ फ़िलहाल अपने मवेशी के लिए बाड़े और अपने बाल-बच्चों के लिए शहर बनाना चाहते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","इसके बाद हम मुसल्लह होकर इसराईलियों के आगे आगे चलेंगे और हर एक को उस की अपनी जगह तक पहुँचाएँगे। इतने में हमारे बाल-बच्चे हमारे शहरों की फ़सीलों के अंदर मुल्क के मुख़ालिफ़ बाशिंदों से महफ़ूज़ रहेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","हम उस वक़्त तक अपने घरों को नहीं लौटेंगे जब तक हर इसराईली को उस की मौरूसी ज़मीन न मिल जाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","दूसरे, हम ख़ुद उनके साथ दरियाए-यरदन के मग़रिब में मीरास में कुछ नहीं पाएँगे, क्योंकि हमें अपनी मौरूसी ज़मीन दरियाए-यरदन के मशरिक़ी किनारे पर मिल चुकी है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","यह सुनकर मूसा ने कहा, “अगर तुम ऐसा ही करोगे तो ठीक है। फिर रब के सामने जंग के लिए तैयार हो जाओ ");
INSERT INTO urdgvh_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","और सब हथियार बाँधकर रब के सामने दरियाए-यरदन को पार करो। उस वक़्त तक न लौटो जब तक रब ने अपने तमाम दुश्मनों को अपने आगे से निकाल न दिया हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","फिर जब मुल्क पर रब का क़ब्ज़ा हो गया होगा तो तुम लौट सकोगे। तब तुमने रब और अपने हमवतन भाइयों के लिए अपने फ़रायज़ अदा कर दिए होंगे, और यह इलाक़ा रब के सामने तुम्हारा मौरूसी हक़ होगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","लेकिन अगर तुम ऐसा न करो तो फिर तुम रब ही का गुनाह करोगे। यक़ीन जानो तुम्हें अपने गुनाह की सज़ा मिलेगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","अब अपने बाल-बच्चों के लिए शहर और अपने मवेशियों के लिए बाड़े बना लो। लेकिन अपने वादे को ज़रूर पूरा करना।” ");
INSERT INTO urdgvh_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","जद और रूबिन के अफ़राद ने मूसा से कहा, “हम आपके ख़ादिम हैं, हम अपने आक़ा के हुक्म के मुताबिक़ ही करेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","हमारे बाल-बच्चे और मवेशी यहीं जिलियाद के शहरों में रहेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","लेकिन आपके ख़ादिम मुसल्लह होकर दरिया को पार करेंगे और रब के सामने जंग करेंगे। हम सब कुछ वैसा ही करेंगे जैसा हमारे आक़ा ने हमें हुक्म दिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","तब मूसा ने इलियज़र इमाम, यशुअ बिन नून और क़बायली कुंबों के सरपरस्तों को हिदायत दी, ");
INSERT INTO urdgvh_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“लाज़िम है कि जद और रूबिन के मर्द मुसल्लह होकर तुम्हारे साथ ही रब के सामने दरियाए-यरदन को पार करें और मुल्क पर क़ब्ज़ा करें। अगर वह ऐसा करें तो उन्हें मीरास में जिलियाद का इलाक़ा दो। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","लेकिन अगर वह ऐसा न करें तो फिर उन्हें मुल्के-कनान ही में तुम्हारे साथ मौरूसी ज़मीन मिले।” ");
INSERT INTO urdgvh_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","जद और रूबिन के अफ़राद ने इसरार किया, “आपके ख़ादिम सब कुछ करेंगे जो रब ने कहा है। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","हम मुसल्लह होकर रब के सामने दरियाए-यरदन को पार करेंगे और कनान के मुल्क में दाख़िल होंगे, अगरचे हमारी मौरूसी ज़मीन यरदन के मशरिक़ी किनारे पर होगी।” ");
INSERT INTO urdgvh_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","तब मूसा ने जद, रूबिन और मनस्सी के आधे क़बीले को यह इलाक़ा दिया। उसमें वह पूरा मुल्क शामिल था जिस पर पहले अमोरियों का बादशाह सीहोन और बसन का बादशाह ओज हुकूमत करते थे। इन शिकस्तख़ुरदा ममालिक के देहातों समेत तमाम शहर उनके हवाले किए गए। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","जद के क़बीले ने दीबोन, अतारात, अरोईर, ");
INSERT INTO urdgvh_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","अतरात-शोफ़ान, याज़ेर, युगबहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","बैत-निमरा और बैत-हारान के शहरों को दुबारा तामीर किया। उन्होंने उनकी फ़सीलें बनाईं और अपने मवेशियों के लिए बाड़े भी। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","रूबिन के क़बीले ने हसबोन, इलियाली, क़िरियतायम, ");
INSERT INTO urdgvh_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","नबू, बाल-मऊन और सिबमाह दुबारा तामीर किए। नबू और बाल-मऊन के नाम बदल गए, क्योंकि उन्होंने उन शहरों को नए नाम दिए जो उन्होंने दुबारा तामीर किए। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","मनस्सी के बेटे मकीर की औलाद ने जिलियाद जाकर उस पर क़ब्ज़ा कर लिया और उसके तमाम अमोरी बाशिंदों को निकाल दिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","चुनाँचे मूसा ने मकीरियों को जिलियाद की सरज़मीन दे दी, और वह वहाँ आबाद हुए। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","मनस्सी के एक आदमी बनाम याईर ने उस इलाक़े में कुछ बस्तियों पर क़ब्ज़ा करके उन्हें हव्वोत-याईर यानी ‘याईर की बस्तियाँ’ का नाम दिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","इसी तरह उस क़बीले के एक और आदमी बनाम नूबह ने जाकर क़नात और उसके देहातों पर क़ब्ज़ा कर लिया। उसने शहर का नाम नूबह रखा। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ज़ैल में उन जगहों के नाम हैं जहाँ जहाँ इसराईली क़बीले अपने दस्तों के मुताबिक़ मूसा और हारून की राहनुमाई में मिसर से निकलकर ख़ैमाज़न हुए थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","रब के हुक्म पर मूसा ने हर जगह का नाम क़लमबंद किया जहाँ उन्होंने अपने ख़ैमे लगाए थे। उन जगहों के नाम यह हैं : ");
INSERT INTO urdgvh_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","पहले महीने के पंद्रहवें दिन इसराईली रामसीस से रवाना हुए। यानी फ़सह के दिन के बाद के दिन वह बड़े इख़्तियार के साथ तमाम मिसरियों के देखते देखते चले गए। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","मिसरी उस वक़्त अपने पहलौठों को दफ़न कर रहे थे, क्योंकि रब ने पहलौठों को मारकर उनके देवताओं की अदालत की थी। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","रामसीस से इसराईली सुक्कात पहुँच गए जहाँ उन्होंने पहली मरतबा अपने डेरे लगाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","वहाँ से वह एताम पहुँचे जो रेगिस्तान के किनारे पर वाक़े है। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","एताम से वह वापस मुड़कर फ़ी-हख़ीरोत की तरफ़ बढ़े जो बाल-सफ़ोन के मशरिक़ में है। वह मिजदाल के क़रीब ख़ैमाज़न हुए। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","फिर वह फ़ी-हख़ीरोत से कूच करके समुंदर में से गुज़र गए। इसके बाद वह तीन दिन एताम के रेगिस्तान में सफ़र करते करते मारा पहुँच गए और वहाँ अपने ख़ैमे लगाए। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","मारा से वह एलीम चले गए जहाँ 12 चश्मे और खजूर के 70 दरख़्त थे। वहाँ ठहरने के बाद ");
INSERT INTO urdgvh_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","वह बहरे-क़ुलज़ुम के साहिल पर ख़ैमाज़न हुए, ");
INSERT INTO urdgvh_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","फिर दश्ते-सीन में पहुँच गए। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","उनके अगले मरहले यह थे : दुफ़क़ा, ");
INSERT INTO urdgvh_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","37","अलूस, रफ़ीदीम जहाँ पीने का पानी दस्तयाब न था, दश्ते-सीना, क़ब्रोत-हत्तावा, हसीरात, रितमा, रिम्मोन-फ़ारस, लिबना, रिस्सा, क़हीलाता, साफ़र पहाड़, हरादा, मक़हीलोत, तहत, तारह, मितक़ा, हशमूना, मौसीरोत, बनी-याक़ान, होर-हज्जिदजाद, युतबाता, अबरूना, अस्यून-जाबर, दश्ते-सीन में वाक़े क़ादिस और होर पहाड़ जो अदोम की सरहद पर वाक़े है। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","वहाँ रब ने हारून इमाम को हुक्म दिया कि वह होर पहाड़ पर चढ़ जाए। वहीं वह पाँचवें माह के पहले दिन फ़ौत हुआ। इसराईलियों को मिसर से निकले 40 साल गुज़र चुके थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","उस वक़्त हारून 123 साल का था। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","उन दिनों में अराद के कनानी बादशाह ने सुना कि इसराईली मेरे मुल्क की तरफ़ बढ़ रहे हैं। वह कनान के जुनूब में हुकूमत करता था। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","47","होर पहाड़ से रवाना होकर इसराईली ज़ैल की जगहों पर ठहरे : ज़लमूना, फ़ूनोन, ओबोत, ऐये-अबारीम जो मोआब के इलाक़े में था, दीबोन-जद, अलमून-दिबलातायम और नबू के क़रीब वाक़े अबारीम का पहाड़ी इलाक़ा। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","वहाँ से उन्होंने यरदन की वादी में उतरकर मोआब के मैदानी इलाक़े में अपने डेरे लगाए। अब वह दरियाए-यरदन के मशरिक़ी किनारे पर यरीहू शहर के सामने थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","उनके ख़ैमे बैत-यसीमोत से लेकर अबील-शित्तीम तक लगे थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","वहाँ रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“इसराईलियों को बताना कि जब तुम दरियाए-यरदन को पार करके मुल्के-कनान में दाख़िल होगे ");
INSERT INTO urdgvh_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","तो लाज़िम है कि तुम तमाम बाशिंदों को निकाल दो। उनके तराशे और ढाले हुए बुतों को तोड़ डालो और उनकी ऊँची जगहों के मंदिरों को तबाह करो। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","मुल्क पर क़ब्ज़ा करके उसमें आबाद हो जाओ, क्योंकि मैंने यह मुल्क तुम्हें दे दिया है। यह मेरी तरफ़ से तुम्हारी मौरूसी मिलकियत है। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","मुल्क को मुख़्तलिफ़ क़बीलों और ख़ानदानों में क़ुरा डालकर तक़सीम करना। हर ख़ानदान के अफ़राद की तादाद का लिहाज़ रखना। बड़े ख़ानदान को निसबतन ज़्यादा ज़मीन देना और छोटे ख़ानदान को निसबतन कम ज़मीन। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","लेकिन अगर तुम मुल्क के बाशिंदों को नहीं निकालोगे तो बचे हुए तुम्हारी आँखों में ख़ार और तुम्हारे पहलुओं में काँटे बनकर तुम्हें उस मुल्क में तंग करेंगे जिसमें तुम आबाद होगे। ");
INSERT INTO urdgvh_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","फिर मैं तुम्हारे साथ वह कुछ करूँगा जो उनके साथ करना चाहता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“इसराईलियों को बताना कि जब तुम उस मुल्क में दाख़िल होगे जो मैं तुम्हें मीरास में दूँगा तो उस की सरहद्दें यह होंगी : ");
INSERT INTO urdgvh_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","उस की जुनूबी सरहद दश्ते-सीन में अदोम की सरहद के साथ साथ चलेगी। मशरिक़ में वह बहीराए-मुरदार के जुनूबी साहिल से शुरू होगी, फिर इन जगहों से होकर मग़रिब की तरफ़ गुज़रेगी : ");
INSERT INTO urdgvh_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","दर्राए-अक़्रब्बीम के जुनूब में से, दश्ते-सीन में से, क़ादिस-बरनीअ के जुनूब में से हसर-अद्दार और अज़मून में से। ");
INSERT INTO urdgvh_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","वहाँ से वह मुड़कर मिसर की सरहद पर वाक़े वादीए-मिसर के साथ साथ बहीराए-रूम तक पहुँचेगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","उस की मग़रिबी सरहद बहीराए-रूम का साहिल होगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","उस की शिमाली सरहद बहीराए-रूम से लेकर इन जगहों से होकर मशरिक़ की तरफ़ गुज़रेगी : होर पहाड़, ");
INSERT INTO urdgvh_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","लबो-हमात, सिदाद, ");
INSERT INTO urdgvh_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ज़िफ़रून और हसर-एनान। हसर-एनान शिमाली सरहद का सबसे मशरिक़ी मक़ाम होगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","उस की मशरिक़ी सरहद शिमाल में हसर-एनान से शुरू होगी। फिर वह इन जगहों से होकर जुनूब की तरफ़ गुज़रेगी : सिफ़ाम, ");
INSERT INTO urdgvh_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","रिबला जो ऐन के मशरिक़ में है और किन्नरत यानी गलील की झील के मशरिक़ में वाक़े पहाड़ी इलाक़ा। ");
INSERT INTO urdgvh_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","इसके बाद वह दरियाए-यरदन के किनारे किनारे गुज़रती हुई बहीराए-मुरदार तक पहुँचेगी। यह तुम्हारे मुल्क की सरहद्दें होंगी।” ");
INSERT INTO urdgvh_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","मूसा ने इसराईलियों से कहा, “यह वही मुल्क है जिसे तुम्हें क़ुरा डालकर तक़सीम करना है। रब ने हुक्म दिया है कि उसे बाक़ी साढ़े नौ क़बीलों को देना है। ");
INSERT INTO urdgvh_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","क्योंकि अढ़ाई क़बीलों के ख़ानदानों को उनकी मीरास मिल चुकी है यानी रूबिन और जद के पूरे क़बीले और मनस्सी के आधे क़बीले को। ");
INSERT INTO urdgvh_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","उन्हें यहाँ, दरियाए-यरदन के मशरिक़ में यरीहू के सामने ज़मीन मिल चुकी है।” ");
INSERT INTO urdgvh_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“इलियज़र इमाम और यशुअ बिन नून लोगों के लिए मुल्क तक़सीम करें। ");
INSERT INTO urdgvh_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","हर क़बीले के एक एक राहनुमा को भी चुनना ताकि वह तक़सीम करने में मदद करे। जिनको तुम्हें चुनना है उनके नाम यह हैं : ");
INSERT INTO urdgvh_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","यहूदाह के क़बीले का कालिब बिन यफ़ुन्ना, ");
INSERT INTO urdgvh_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","शमौन के क़बीले का समुएल बिन अम्मीहूद, ");
INSERT INTO urdgvh_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","बिनयमीन के क़बीले का इलीदाद बिन किस्लोन, ");
INSERT INTO urdgvh_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","दान के क़बीले का बुक़्क़ी बिन युगली, ");
INSERT INTO urdgvh_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","मनस्सी के क़बीले का हन्नियेल बिन अफ़ूद, ");
INSERT INTO urdgvh_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","इफ़राईम के क़बीले का क़मुएल बिन सिफ़तान, ");
INSERT INTO urdgvh_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ज़बूलून के क़बीले का इलीसफ़न बिन फ़रनाक, ");
INSERT INTO urdgvh_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","इशकार के क़बीले का फ़लतियेल बिन अज़्ज़ान, ");
INSERT INTO urdgvh_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","आशर के क़बीले का अख़ीहूद बिन शलूमी, ");
INSERT INTO urdgvh_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","नफ़ताली के क़बीले का फ़िदाहेल बिन अम्मीहूद।” ");
INSERT INTO urdgvh_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","रब ने इन्हीं आदमियों को मुल्क को इसराईलियों में तक़सीम करने की ज़िम्मादारी दी। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","इसराईली अब तक मोआब के मैदानी इलाक़े में दरियाए-यरदन के मशरिक़ी किनारे पर यरीहू के सामने थे। वहाँ रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“इसराईलियों को बता दे कि वह लावियों को अपनी मिली हुई ज़मीनों में से रहने के लिए शहर दें। उन्हें शहरों के इर्दगिर्द मवेशी चराने की ज़मीन भी मिले। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","फिर लावियों के पास रहने के लिए शहर और अपने जानवर चराने के लिए ज़मीन होगी। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","चराने के लिए ज़मीन शहर के इर्दगिर्द होगी, और चारों तरफ़ का फ़ासला फ़सीलों से 1,500 फ़ुट हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","चराने की यह ज़मीन मुरब्बा शक्ल की होगी जिसके हर पहलू का फ़ासला 3,000 फ़ुट हो। शहर इस मुरब्बा शक्ल के बीच में हो। यह रक़बा शहर के बाशिंदों के लिए हो ताकि वह अपने मवेशी चरा सकें। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","7","लावियों को कुल 48 शहर देना। इनमें से छः पनाह के शहर मुक़र्रर करना। उनमें ऐसे लोग पनाह ले सकेंगे जिनके हाथों ग़ैरइरादी तौर पर कोई हलाक हुआ हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","हर क़बीला लावियों को अपने इलाक़े के रक़बे के मुताबिक़ शहर दे। जिस क़बीले का इलाक़ा बड़ा है उसे लावियों को ज़्यादा शहर देने हैं जबकि जिस क़बीले का इलाक़ा छोटा है वह लावियों को कम शहर दे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","फिर रब ने मूसा से कहा, ");
INSERT INTO urdgvh_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“इसराईलियों को बताना कि दरियाए-यरदन को पार करने के बाद ");
INSERT INTO urdgvh_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","कुछ पनाह के शहर मुक़र्रर करना। उनमें वह शख़्स पनाह ले सकेगा जिसके हाथों ग़ैरइरादी तौर पर कोई हलाक हुआ हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","वहाँ वह इंतक़ाम लेनेवाले से पनाह ले सकेगा और जमात की अदालत के सामने खड़े होने से पहले मारा नहीं जा सकेगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","इसके लिए छः शहर चुन लो। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","तीन दरियाए-यरदन के मशरिक़ में और तीन मुल्के-कनान में हों। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","यह छः शहर हर किसी को पनाह देंगे, चाहे वह इसराईली, परदेसी या उनके दरमियान रहनेवाला ग़ैरशहरी हो। जिससे भी ग़ैरइरादी तौर पर कोई हलाक हुआ हो वह वहाँ पनाह ले सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","18","अगर किसी ने किसी को जान-बूझकर लोहे, पत्थर या लकड़ी की किसी चीज़ से मार डाला हो वह क़ातिल है और उसे सज़ाए-मौत देनी है। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","मक़तूल का सबसे क़रीबी रिश्तेदार उसे तलाश करके मार दे। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","21","क्योंकि जो नफ़रत या दुश्मनी के बाइस जान-बूझकर किसी को यों धक्का दे, उस पर कोई चीज़ फेंक दे या उसे मुक्का मारे कि वह मर जाए वह क़ातिल है और उसे सज़ाए-मौत देनी है। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","लेकिन वह क़ातिल नहीं है जिससे दुश्मनी के बाइस नहीं बल्कि इत्तफ़ाक़ से और ग़ैरइरादी तौर पर कोई हलाक हुआ हो, चाहे उसने उसे धक्का दिया, कोई चीज़ उस पर फेंक दी ");
INSERT INTO urdgvh_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","या कोई पत्थर उस पर गिरने दिया। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","अगर ऐसा हुआ तो लाज़िम है कि जमात इन हिदायात के मुताबिक़ उसके और इंतक़ाम लेनेवाले के दरमियान फ़ैसला करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","अगर मुलज़िम बेक़ुसूर है तो जमात उस की हिफ़ाज़त करके उसे पनाह के उस शहर में वापस ले जाए जिसमें उसने पनाह ली है। वहाँ वह मुक़द्दस तेल से मसह किए गए इमामे-आज़म की मौत तक रहे। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","लेकिन अगर यह शख़्स इससे पहले पनाह के शहर से निकले तो वह महफ़ूज़ नहीं होगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","अगर उसका इंतक़ाम लेनेवाले से सामना हो जाए तो इंतक़ाम लेनेवाले को उसे मार डालने की इजाज़त होगी। अगर वह ऐसा करे तो बेक़ुसूर रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","पनाह लेनेवाला इमामे-आज़म की वफ़ात तक पनाह के शहर में रहे। इसके बाद ही वह अपने घर वापस जा सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","यह उसूल दायमी हैं। जहाँ भी तुम रहते हो तुम्हें हमेशा इन पर अमल करना है। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","जिस पर क़त्ल का इलज़ाम लगाया गया हो उसे सिर्फ़ इस सूरत में सज़ाए-मौत दी जा सकती है कि कम अज़ कम दो गवाह हों। एक गवाह काफ़ी नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","क़ातिल को ज़रूर सज़ाए-मौत देना। ख़ाह वह इससे बचने के लिए कोई भी मुआवज़ा दे उसे आज़ाद न छोड़ना बल्कि सज़ाए-मौत देना। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","उस शख़्स से भी पैसे क़बूल न करना जिससे ग़ैरइरादी तौर पर कोई हलाक हुआ हो और जो इस सबब से पनाह के शहर में रह रहा है। उसे इजाज़त नहीं कि वह पैसे देकर पनाह का शहर छोड़े और अपने घर वापस चला जाए। लाज़िम है कि वह इसके लिए इमामे-आज़म की वफ़ात का इंतज़ार करे। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","जिस मुल्क में तुम रहते हो उस की मुक़द्दस हालत को नापाक न करना। जब किसी को उसमें क़त्ल किया जाए तो वह नापाक हो जाता है। जब इस तरह ख़ून बहता है तो मुल्क की मुक़द्दस हालत सिर्फ़ उस शख़्स के ख़ून बहने से बहाल हो जाती है जिसने यह ख़ून बहाया है। यानी मुल्क का सिर्फ़ क़ातिल की मौत से ही कफ़्फ़ारा दिया जा सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","उस मुल्क को नापाक न करना जिसमें तुम आबाद हो और जिसमें मैं सुकूनत करता हूँ। क्योंकि मैं रब हूँ जो इसराईलियों के दरमियान सुकूनत करता हूँ।” ");
INSERT INTO urdgvh_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","एक दिन जिलियाद बिन मकीर बिन मनस्सी बिन यूसुफ़ के कुंबे से निकले हुए आबाई घरानों के सरपरस्त मूसा और उन सरदारों के पास आए जो दीगर आबाई घरानों के सरपरस्त थे। ");
INSERT INTO urdgvh_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","उन्होंने कहा, “रब ने आपको हुक्म दिया था कि आप क़ुरा डालकर मुल्क को इसराईलियों में तक़सीम करें। उस वक़्त उसने यह भी कहा था कि हमारे भाई सिलाफ़िहाद की बेटियों को उस की मौरूसी ज़मीन मिलनी है। ");
INSERT INTO urdgvh_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","अगर वह इसराईल के किसी और क़बीले के मर्दों से शादी करें तो फिर यह ज़मीन जो हमारे क़बीले का मौरूसी हिस्सा है उस क़बीले का मौरूसी हिस्सा बनेगी और हम उससे महरूम हो जाएंगे। फिर हमारा क़बायली इलाक़ा छोटा हो जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","और अगर हम यह ज़मीन वापस भी ख़रीदें तो भी वह अगले बहाली के साल में दूसरे क़बीले को वापस चली जाएगी जिसमें इन औरतों ने शादी की है। इस तरह वह हमेशा के लिए हमारे हाथ से निकल जाएगी।” ");
INSERT INTO urdgvh_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","मूसा ने रब के हुक्म पर इसराईलियों को बताया, “जिलियाद के मर्द हक़-बजानिब हैं। ");
INSERT INTO urdgvh_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","इसलिए रब की हिदायत यह है कि सिलाफ़िहाद की बेटियों को हर आदमी से शादी करने की इजाज़त है, लेकिन सिर्फ़ इस सूरत में कि वह उनके अपने क़बीले का हो। ");
INSERT INTO urdgvh_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","इस तरह एक क़बीले की मौरूसी ज़मीन किसी दूसरे क़बीले में मुंतक़िल नहीं होगी। लाज़िम है कि हर क़बीले का पूरा इलाक़ा उसी के पास रहे। ");
INSERT INTO urdgvh_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","जो भी बेटी मीरास में ज़मीन पाती है उसके लिए लाज़िम है कि वह अपने ही क़बीले के किसी मर्द से शादी करे ताकि उस की ज़मीन क़बीले के पास ही रहे। ");
INSERT INTO urdgvh_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","एक क़बीले की मौरूसी ज़मीन किसी दूसरे क़बीले को मुंतक़िल करने की इजाज़त नहीं है। लाज़िम है कि हर क़बीले का पूरा मौरूसी इलाक़ा उसी के पास रहे।” ");
INSERT INTO urdgvh_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","11","सिलाफ़िहाद की बेटियों महलाह, तिरज़ा, हुजलाह, मिलकाह और नुआह ने वैसा ही किया जैसा रब ने मूसा को बताया था। उन्होंने अपने चचाज़ाद भाइयों से शादी की। ");
INSERT INTO urdgvh_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","चूँकि वह भी मनस्सी के क़बीले के थे इसलिए यह मौरूसी ज़मीन सिलाफ़िहाद के क़बीले के पास रही। ");
INSERT INTO urdgvh_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","रब ने यह अहकाम और हिदायात इसराईलियों को मूसा की मारिफ़त दीं जब वह मोआब के मैदानी इलाक़े में दरियाए-यरदन के मशरिक़ी किनारे पर यरीहू के सामने ख़ैमाज़न थे। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","इस किताब में वह बातें दर्ज हैं जो मूसा ने तमाम इसराईलियों से कहीं जब वह दरियाए-यरदन के मशरिक़ी किनारे पर बयाबान में थे। वह यरदन की वादी में सूफ़ के क़रीब थे। एक तरफ़ फ़ारान शहर था और दूसरी तरफ़ तोफ़ल, लाबन, हसीरात और दीज़हब के शहर थे। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","अगर अदोम के पहाड़ी इलाक़े से होकर जाएँ तो होरिब यानी सीना पहाड़ से क़ादिस-बरनीअ तक का सफ़र 11 दिन में तय किया जा सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","इसराईलियों को मिसर से निकले 40 साल हो गए थे। इस साल के ग्यारहवें माह के पहले दिन मूसा ने उन्हें सब कुछ बताया जो रब ने उसे उन्हें बताने को कहा था। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","उस वक़्त वह अमोरियों के बादशाह सीहोन को शिकस्त दे चुका था जिसका दारुल-हुकूमत हसबोन था। बसन के बादशाह ओज पर भी फ़तह हासिल हो चुकी थी जिसकी हुकूमत के मरकज़ अस्तारात और इदरई थे। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","वहाँ, दरियाए-यरदन के मशरिक़ी किनारे पर जो मोआब के इलाक़े में था मूसा अल्लाह की शरीअत की तशरीह करने लगा। उसने कहा, ");
INSERT INTO urdgvh_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","जब तुम होरिब यानी सीना पहाड़ के पास थे तो रब हमारे ख़ुदा ने हमसे कहा, “तुम काफ़ी देर से यहाँ ठहरे हुए हो। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","अब इस जगह को छोड़कर आगे मुल्के-कनान की तरफ़ बढ़ो। अमोरियों के पहाड़ी इलाक़े और उनके पड़ोस की क़ौमों के पास जाओ जो यरदन के मैदानी इलाक़े में आबाद हैं। पहाड़ी इलाक़े में, मग़रिब के नशेबी पहाड़ी इलाक़े में, जुनूब के दश्ते-नजब में, साहिली इलाक़े में, मुल्के-कनान में और लुबनान में दरियाए-फ़ुरात तक चले जाओ। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","मैंने तुम्हें यह मुल्क दे दिया है। अब जाकर उस पर क़ब्ज़ा कर लो। क्योंकि रब ने क़सम खाकर तुम्हारे बापदादा इब्राहीम, इसहाक़ और याक़ूब से वादा किया था कि मैं यह मुल्क तुम्हें और तुम्हारी औलाद को दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","उस वक़्त मैंने तुमसे कहा, “मैं अकेला तुम्हारी राहनुमाई करने की ज़िम्मादारी नहीं उठा सकता। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","रब तुम्हारे ख़ुदा ने तुम्हारी तादाद इतनी बढ़ा दी है कि आज तुम आसमान के सितारों की मानिंद बेशुमार हो। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","और रब तुम्हारे बापदादा का ख़ुदा करे कि तुम्हारी तादाद मज़ीद हज़ार गुना बढ़ जाए। वह तुम्हें वह बरकत दे जिसका वादा उसने किया है। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","लेकिन मैं अकेला ही तुम्हारा बोझ उठाने और झगड़ों को निपटाने की ज़िम्मादारी नहीं उठा सकता। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","इसलिए अपने हर क़बीले में से कुछ ऐसे दानिशमंद और समझदार आदमी चुन लो जिनकी लियाक़त को लोग मानते हैं। फिर मैं उन्हें तुम पर मुक़र्रर करूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","यह बात तुम्हें पसंद आई। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","तुमने अपने में से ऐसे राहनुमा चुन लिए जो दानिशमंद थे और जिनकी लियाक़त को लोग मानते थे। फिर मैंने उन्हें हज़ार हज़ार, सौ सौ और पचास पचास मर्दों पर मुक़र्रर किया। यों वह क़बीलों के निगहबान बन गए। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","उस वक़्त मैंने उन क़ाज़ियों से कहा, “अदालत करते वक़्त हर एक की बात ग़ौर से सुनकर ग़ैरजानिबदार फ़ैसले करना, चाहे दो इसराईली फ़रीक़ एक दूसरे से झगड़ा कर रहे हों या मामला किसी इसराईली और परदेसी के दरमियान हो। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","अदालत करते वक़्त जानिबदारी न करना। छोटे और बड़े की बात सुनकर दोनों के साथ एक जैसा सुलूक करना। किसी से मत डरना, क्योंकि अल्लाह ही ने तुम्हें अदालत करने की ज़िम्मादारी दी है। अगर किसी मामले में फ़ैसला करना तुम्हारे लिए मुश्किल हो तो उसे मुझे पेश करो। फिर मैं ही उसका फ़ैसला करूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","उस वक़्त मैंने तुम्हें सब कुछ बताया जो तुम्हें करना था। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","हमने वैसा ही किया जैसा रब ने हमें कहा था। हम होरिब से रवाना होकर अमोरियों के पहाड़ी इलाक़े की तरफ़ बढ़े। सफ़र करते करते हम उस वसी और हौलनाक रेगिस्तान में से गुज़र गए जिसे तुमने देख लिया है। आख़िरकार हम क़ादिस-बरनीअ पहुँच गए। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","वहाँ मैंने तुमसे कहा, “तुम अमोरियों के पहाड़ी इलाक़े तक पहुँच गए हो जो रब हमारा ख़ुदा हमें देनेवाला है। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","देख, रब तेरे ख़ुदा ने तुझे यह मुल्क दे दिया है। अब जाकर उस पर क़ब्ज़ा कर ले जिस तरह रब तेरे बापदादा के ख़ुदा ने तुझे बताया है। मत डरना और बेदिल न हो जाना!” ");
INSERT INTO urdgvh_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","लेकिन तुम सब मेरे पास आए और कहा, “क्यों न हम जाने से पहले कुछ आदमी भेजें जो मुल्क के हालात दरियाफ़्त करें और वापस आकर हमें उस रास्ते के बारे में बताएँ जिस पर हमें जाना है और उन शहरों के बारे में इत्तला दें जिनके पास हम पहुँचेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","यह बात मुझे पसंद आई। मैंने इस काम के लिए हर क़बीले के एक आदमी को चुनकर भेज दिया। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","जब यह बारह आदमी पहाड़ी इलाक़े में जाकर वादीए-इसकाल में पहुँचे तो उस की तफ़तीश की। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","फिर वह मुल्क का कुछ फल लेकर लौट आए और हमें मुल्क के बारे में इत्तला देकर कहा, “जो मुल्क रब हमारा ख़ुदा हमें देनेवाला है वह अच्छा है।” ");
INSERT INTO urdgvh_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","लेकिन तुम जाना नहीं चाहते थे बल्कि सरकशी करके रब अपने ख़ुदा का हुक्म न माना। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","तुमने अपने ख़ैमों में बुड़बुड़ाते हुए कहा, “रब हमसे नफ़रत रखता है। वह हमें मिसर से निकाल लाया है ताकि हमें अमोरियों के हाथों हलाक करवाए। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","हम कहाँ जाएँ? हमारे भाइयों ने हमें बेदिल कर दिया है। वह कहते हैं, ‘वहाँ के लोग हमसे ताक़तवर और दराज़क़द हैं। उनके बड़े बड़े शहरों की फ़सीलें आसमान से बातें करती हैं। वहाँ हमने अनाक़ की औलाद भी देखी जो देवक़ामत हैं’।” ");
INSERT INTO urdgvh_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","मैंने कहा, “न घबराओ और न उनसे ख़ौफ़ खाओ। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","रब तुम्हारा ख़ुदा तुम्हारे आगे आगे चलता हुआ तुम्हारे लिए लड़ेगा। तुम ख़ुद देख चुके हो कि वह किस तरह मिसर ");
INSERT INTO urdgvh_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","और रेगिस्तान में तुम्हारे लिए लड़ा। यहाँ भी वह ऐसा ही करेगा। तू ख़ुद गवाह है कि बयाबान में पूरे सफ़र के दौरान रब तुझे यों उठाए फिरा जिस तरह बाप अपने बेटे को उठाए फिरता है। इस तरह चलते चलते तुम यहाँ तक पहुँच गए।” ");
INSERT INTO urdgvh_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","इसके बावुजूद तुमने रब अपने ख़ुदा पर भरोसा न रखा। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","तुमने यह बात नज़रंदाज़ की कि वह सफ़र के दौरान रात के वक़्त आग और दिन के वक़्त बादल की सूरत में तुम्हारे आगे आगे चलता रहा ताकि तुम्हारे लिए ख़ैमे लगाने की जगहें मालूम करे और तुम्हें रास्ता दिखाए। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","जब रब ने तुम्हारी यह बातें सुनीं तो उसे ग़ुस्सा आया और उसने क़सम खाकर कहा, ");
INSERT INTO urdgvh_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“इस शरीर नसल का एक मर्द भी उस अच्छे मुल्क को नहीं देखेगा अगरचे मैंने क़सम खाकर तुम्हारे बापदादा से वादा किया था कि मैं उसे उन्हें दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","सिर्फ़ कालिब बिन यफ़ुन्ना उसे देखेगा। मैं उसे और उस की औलाद को वह मुल्क दूँगा जिसमें उसने सफ़र किया है, क्योंकि उसने पूरे तौर पर रब की पैरवी की।” ");
INSERT INTO urdgvh_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","तुम्हारी वजह से रब मुझसे भी नाराज़ हुआ और कहा, “तू भी उसमें दाख़िल नहीं होगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","लेकिन तेरा मददगार यशुअ बिन नून दाख़िल होगा। उस की हौसलाअफ़्ज़ाई कर, क्योंकि वह मुल्क पर क़ब्ज़ा करने में इसराईल की राहनुमाई करेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","तुमसे रब ने कहा, “तुम्हारे बच्चे जो अभी अच्छे और बुरे में इम्तियाज़ नहीं कर सकते, वही मुल्क में दाख़िल होंगे, वही बच्चे जिनके बारे में तुमने कहा कि दुश्मन उन्हें मुल्के-कनान में छीन लेंगे। उन्हें मैं मुल्क दूँगा, और वह उस पर क़ब्ज़ा करेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","लेकिन तुम ख़ुद आगे न बढ़ो। पीछे मुड़कर दुबारा रेगिस्तान में बहरे-क़ुलज़ुम की तरफ़ सफ़र करो।” ");
INSERT INTO urdgvh_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","तब तुमने कहा, “हमने रब का गुनाह किया है। अब हम मुल्क में जाकर लड़ेंगे, जिस तरह रब हमारे ख़ुदा ने हमें हुक्म दिया है।” चुनाँचे यह सोचते हुए कि उस पहाड़ी इलाक़े पर हमला करना आसान होगा, हर एक मुसल्लह हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","लेकिन रब ने मुझसे कहा, “उन्हें बताना कि वहाँ जंग करने के लिए न जाओ, क्योंकि मैं तुम्हारे साथ नहीं हूँगा। तुम अपने दुश्मनों के हाथों शिकस्त खाओगे।” ");
INSERT INTO urdgvh_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","मैंने तुम्हें यह बताया, लेकिन तुमने मेरी न सुनी। तुमने सरकशी करके रब का हुक्म न माना बल्कि मग़रूर होकर पहाड़ी इलाक़े में दाख़िल हुए। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","वहाँ के अमोरी बाशिंदे तुम्हारा सामना करने निकले। वह शहद की मक्खियों के ग़ोल की तरह तुम पर टूट पड़े और तुम्हारा ताक़्क़ुब करके तुम्हें सईर से हुरमा तक मारते गए। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","तब तुम वापस आकर रब के सामने ज़ारो-क़तार रोने लगे। लेकिन उसने तवज्जुह न दी बल्कि तुम्हें नज़रंदाज़ किया। ");
INSERT INTO urdgvh_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","इसके बाद तुम बहुत दिनों तक क़ादिस-बरनीअ में रहे। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","फिर जिस तरह रब ने मुझे हुक्म दिया था हम पीछे मुड़कर रेगिस्तान में बहरे-क़ुलज़ुम की तरफ़ सफ़र करने लगे। काफ़ी देर तक हम सईर यानी अदोम के पहाड़ी इलाक़े के किनारे किनारे फिरते रहे। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","एक दिन रब ने मुझसे कहा, ");
INSERT INTO urdgvh_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“तुम बहुत देर से इस पहाड़ी इलाक़े के किनारे किनारे फिर रहे हो। अब शिमाल की तरफ़ सफ़र करो। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","क़ौम को बताना, अगले दिनों में तुम सईर के मुल्क में से गुज़रोगे जहाँ तुम्हारे भाई एसौ की औलाद आबाद है। वह तुमसे डरेंगे। तो भी बड़ी एहतियात से गुज़रना। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","उनके साथ जंग न छेड़ना, क्योंकि मैं तुम्हें उनके मुल्क का एक मुरब्बा फ़ुट भी नहीं दूँगा। मैंने सईर का पहाड़ी इलाक़ा एसौ और उस की औलाद को दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","लाज़िम है कि तुम खाने और पीने की तमाम ज़रूरियात पैसे देकर ख़रीदो।” ");
INSERT INTO urdgvh_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","जो भी काम तूने किया है रब ने उस पर बरकत दी है। इस वसी रेगिस्तान में पूरे सफ़र के दौरान उसने तेरी निगहबानी की। इन 40 सालों के दौरान रब तेरा ख़ुदा तेरे साथ था, और तेरी तमाम ज़रूरियात पूरी होती रहीं। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","चुनाँचे हम सईर को छोड़कर जहाँ हमारे भाई एसौ की औलाद आबाद थी दूसरे रास्ते से आगे निकले। हमने वह रास्ता छोड़ दिया जो ऐलात और अस्यून-जाबर के शहरों से बहीराए-मुरदार तक पहुँचाता है और मोआब के बयाबान की तरफ़ बढ़ने लगे। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","वहाँ रब ने मुझसे कहा, “मोआब के बाशिंदों की मुख़ालफ़त न करना और न उनके साथ जंग छेड़ना, क्योंकि मैं उनके मुल्क का कोई भी हिस्सा तुझे नहीं दूँगा। मैंने आर शहर को लूत की औलाद को दिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","पहले ऐमी वहाँ रहते थे जो अनाक़ की औलाद की तरह ताक़तवर, दराज़क़द और तादाद में ज़्यादा थे। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","अनाक़ की औलाद की तरह वह रफ़ाइयों में शुमार किए जाते थे, लेकिन मोआबी उन्हें ऐमी कहते थे। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","इसी तरह क़दीम ज़माने में होरी सईर में आबाद थे, लेकिन एसौ की औलाद ने उन्हें वहाँ से निकाल दिया था। जिस तरह इसराईलियों ने बाद में उस मुल्क में किया जो रब ने उन्हें दिया था उसी तरह एसौ की औलाद बढ़ते बढ़ते होरियों को तबाह करके उनकी जगह आबाद हुए थे। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","रब ने कहा, “अब जाकर वादीए-ज़िरद को उबूर करो।” हमने ऐसा ही किया। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","हमें क़ादिस-बरनीअ से रवाना हुए 38 साल हो गए थे। अब वह तमाम आदमी मर चुके थे जो उस वक़्त जंग करने के क़ाबिल थे। वैसा ही हुआ था जैसा रब ने क़सम खाकर कहा था। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","रब की मुख़ालफ़त के बाइस आख़िरकार ख़ैमागाह में उस नसल का एक मर्द भी न रहा। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","जब वह सब मर गए थे ");
INSERT INTO urdgvh_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","तब रब ने मुझसे कहा, ");
INSERT INTO urdgvh_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“आज तुम्हें आर शहर से होकर मोआब के इलाक़े में से गुज़रना है। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","फिर तुम अम्मोनियों के इलाक़े तक पहुँचोगे। उनकी भी मुख़ालफ़त न करना, और न उनके साथ जंग छेड़ना, क्योंकि मैं उनके मुल्क का कोई भी हिस्सा तुम्हें नहीं दूँगा। मैंने यह मुल्क लूत की औलाद को दिया है।” ");
INSERT INTO urdgvh_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","हक़ीक़त में अम्मोनियों का मुल्क भी रफ़ाइयों का मुल्क समझा जाता था जो क़दीम ज़माने में वहाँ आबाद थे। अम्मोनी उन्हें ज़मज़ुमी कहते थे, ");
INSERT INTO urdgvh_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","और वह देवक़ामत थे, ताक़तवर और तादाद में ज़्यादा। वह अनाक़ की औलाद जैसे दराज़क़द थे। जब अम्मोनी मुल्क में आए तो रब ने रफ़ाइयों को उनके आगे आगे तबाह कर दिया। चुनाँचे अम्मोनी बढ़ते बढ़ते उन्हें निकालते गए और उनकी जगह आबाद हुए, ");
INSERT INTO urdgvh_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","बिलकुल उसी तरह जिस तरह रब ने एसौ की औलाद के आगे आगे होरियों को तबाह कर दिया था जब वह सईर के मुल्क में आए थे। वहाँ भी वह बढ़ते बढ़ते होरियों को निकालते गए और उनकी जगह आबाद हुए। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","इसी तरह एक और क़दीम क़ौम बनाम अव्वी को भी उसके मुल्क से निकाला गया। अव्वी ग़ज़्ज़ा तक आबाद थे, लेकिन जब कफ़तूरी कफ़तूर यानी क्रेते से आए तो उन्होंने उन्हें तबाह कर दिया और उनकी जगह आबाद हो गए। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","रब ने मूसा से कहा, “अब जाकर वादीए-अरनोन को उबूर करो। यों समझो कि मैं हसबोन के अमोरी बादशाह सीहोन को उसके मुल्क समेत तुम्हारे हवाले कर चुका हूँ। उस पर क़ब्ज़ा करना शुरू करो और उसके साथ जंग करने का मौक़ा ढूँडो। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","इसी दिन से मैं तमाम क़ौमों में तुम्हारे बारे में दहशत और ख़ौफ़ पैदा करूँगा। वह तुम्हारी ख़बर सुनकर ख़ौफ़ के मारे थरथराएँगी और काँपेंगी।” ");
INSERT INTO urdgvh_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","मैंने दश्ते-क़दीमात से हसबोन के बादशाह सीहोन के पास क़ासिद भेजे। मेरा पैग़ाम नफ़रत और मुख़ालफ़त से ख़ाली था। वह यह था, ");
INSERT INTO urdgvh_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“हमें अपने मुल्क में से गुज़रने दें। हम शाहराह पर ही रहेंगे और उससे न बाईं, न दाईं तरफ़ हटेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","हम खाने और पीने की तमाम ज़रूरियात के लिए मुनासिब पैसे देंगे। हमें पैदल अपने मुल्क में से गुज़रने दें, ");
INSERT INTO urdgvh_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","जिस तरह सईर के बाशिंदों एसौ की औलाद और आर के रहनेवाले मोआबियों ने हमें गुज़रने दिया। क्योंकि हमारी मनज़िल दरियाए-यरदन के मग़रिब में है, वह मुल्क जो रब हमारा ख़ुदा हमें देनेवाला है।” ");
INSERT INTO urdgvh_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","लेकिन हसबोन के बादशाह सीहोन ने हमें गुज़रने न दिया, क्योंकि रब तुम्हारे ख़ुदा ने उसे बे-लचक और हमारी बात से इनकार करने पर आमादा कर दिया था ताकि सीहोन हमारे क़ाबू में आ जाए। और बाद में ऐसा ही हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","रब ने मुझसे कहा, “यों समझ ले कि मैं सीहोन और उसके मुल्क को तेरे हवाले करने लगा हूँ। अब निकलकर उस पर क़ब्ज़ा करना शुरू करो।” ");
INSERT INTO urdgvh_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","जब सीहोन अपनी सारी फ़ौज लेकर हमारा मुक़ाबला करने के लिए यहज़ आया ");
INSERT INTO urdgvh_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","तो रब हमारे ख़ुदा ने हमें पूरी फ़तह बख़्शी। हमने सीहोन, उसके बेटों और पूरी क़ौम को शिकस्त दी। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","उस वक़्त हमने उसके तमाम शहरों पर क़ब्ज़ा कर लिया और उनके तमाम मर्दों, औरतों और बच्चों को मार डाला। कोई भी न बचा। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","हमने सिर्फ़ मवेशी और शहरों का लूटा हुआ माल अपने लिए बचाए रखा। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","वादीए-अरनोन के किनारे पर वाक़े अरोईर से लेकर जिलियाद तक हर शहर को शिकस्त माननी पड़ी। इसमें वह शहर भी शामिल था जो वादीए-अरनोन में था। रब हमारे ख़ुदा ने उन सबको हमारे हवाले कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","लेकिन तुमने अम्मोनियों का मुल्क छोड़ दिया और न दरियाए-यब्बोक़ के इर्दगिर्द के इलाक़े, न उसके पहाड़ी इलाक़े के शहरों को छेड़ा, क्योंकि रब हमारे ख़ुदा ने ऐसा करने से तुम्हें मना किया था। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","इसके बाद हम शिमाल में बसन की तरफ़ बढ़ गए। बसन का बादशाह ओज अपनी तमाम फ़ौज के साथ निकलकर हमारा मुक़ाबला करने के लिए इदरई आया। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","रब ने मुझसे कहा, “उससे मत डर। मैं उसे, उस की पूरी फ़ौज और उसका मुल्क तेरे हवाले कर चुका हूँ। उसके साथ वह कुछ कर जो तूने अमोरी बादशाह सीहोन के साथ किया जो हसबोन में हुकूमत करता था।” ");
INSERT INTO urdgvh_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","ऐसा ही हुआ। रब हमारे ख़ुदा की मदद से हमने बसन के बादशाह ओज और उस की तमाम क़ौम को शिकस्त दी। हमने सबको हलाक कर दिया। कोई भी न बचा। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","उसी वक़्त हमने उसके तमाम शहरों पर क़ब्ज़ा कर लिया। हमने कुल 60 शहरों पर यानी अरजूब के सारे इलाक़े पर क़ब्ज़ा किया जिस पर ओज की हुकूमत थी। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","इन तमाम शहरों की हिफ़ाज़त ऊँची ऊँची फ़सीलों और कुंडेवाले दरवाज़ों से की गई थी। देहात में बहुत-सी ऐसी आबादियाँ भी मिल गईं जिनकी फ़सीलें नहीं थीं। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","हमने उनके साथ वह कुछ किया जो हमने हसबोन के बादशाह सीहोन के इलाक़े के साथ किया था। हमने सब कुछ रब के हवाले करके हर शहर को और तमाम मर्दों, औरतों और बच्चों को हलाक कर डाला। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","हमने सिर्फ़ तमाम मवेशी और शहरों का लूटा हुआ माल अपने लिए बचाए रखा। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","यों हमने उस वक़्त अमोरियों के इन दो बादशाहों से दरियाए-यरदन का मशरिक़ी इलाक़ा वादीए-अरनोन से लेकर हरमून पहाड़ तक छीन लिया। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(सैदा के बाशिंदे हरमून को सिरयून कहते हैं जबकि अमोरियों ने उसका नाम सनीर रखा)। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","हमने ओज बादशाह के पूरे इलाक़े पर क़ब्ज़ा कर लिया। इसमें मैदाने-मुरतफ़ा के तमाम शहर शामिल थे, नीज़ सलका और इदरई तक जिलियाद और बसन के पूरे इलाक़े। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","बादशाह ओज देवक़ामत क़बीले रफ़ाई का आख़िरी मर्द था। उसका लोहे का ताबूत 13 से ज़ायद फ़ुट लंबा और छः फ़ुट चौड़ा था और आज तक अम्मोनियों के शहर रब्बा में देखा जा सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","जब हमने दरियाए-यरदन के मशरिक़ी इलाक़े पर क़ब्ज़ा किया तो मैंने रूबिन और जद के क़बीलों को उसका जुनूबी हिस्सा शहरों समेत दिया। इस इलाक़े की जुनूबी सरहद दरियाए-अरनोन पर वाक़े शहर अरोईर है जबकि शिमाल में इसमें जिलियाद के पहाड़ी इलाक़े का आधा हिस्सा भी शामिल है। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","जिलियाद का शिमाली हिस्सा और बसन का मुल्क मैंने मनस्सी के आधे क़बीले को दिया। (बसन में अरजूब का इलाक़ा है जहाँ पहले ओज बादशाह की हुकूमत थी और जो रफ़ाइयों यानी देवक़ामत अफ़राद का मुल्क कहलाता था। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","मनस्सी के क़बीले के एक आदमी बनाम याईर ने अरजूब पर जसूरियों और माकातियों की सरहद तक क़ब्ज़ा कर लिया था। उसने इस इलाक़े की बस्तियों को अपना नाम दिया। आज तक यही नाम हव्वोत-याईर यानी याईर की बस्तियाँ चलता है।) ");
INSERT INTO urdgvh_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","मैंने जिलियाद का शिमाली हिस्सा मनस्सी के कुंबे मकीर को दिया ");
INSERT INTO urdgvh_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","लेकिन जिलियाद का जुनूबी हिस्सा रूबिन और जद के क़बीलों को दिया। इस हिस्से की एक सरहद जुनूब में वादीए-अरनोन के बीच में से गुज़रती है जबकि दूसरी सरहद दरियाए-यब्बोक़ है जिसके पार अम्मोनियों की हुकूमत है। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","उस की मग़रिबी सरहद दरियाए-यरदन है यानी किन्नरत (गलील) की झील से लेकर बहीराए-मुरदार तक जो पिसगा के पहाड़ी सिलसिले के दामन में है। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","उस वक़्त मैंने रूबिन, जद और मनस्सी के क़बीलों से कहा, “रब तुम्हारे ख़ुदा ने तुम्हें मीरास में यह मुल्क दे दिया है। लेकिन शर्त यह है कि तुम्हारे तमाम जंग करने के क़ाबिल मर्द मुसल्लह होकर तुम्हारे इसराईली भाइयों के आगे आगे दरियाए-यरदन को पार करें। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","सिर्फ़ तुम्हारी औरतें और बच्चे पीछे रहकर उन शहरों में इंतज़ार कर सकते हैं जो मैंने तुम्हारे लिए मुक़र्रर किए हैं। तुम अपने मवेशियों को भी पीछे छोड़ सकते हो, क्योंकि मुझे पता है कि तुम्हारे बहुत ज़्यादा जानवर हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","अपने भाइयों के साथ चलते हुए उनकी मदद करते रहो। जब रब तुम्हारा ख़ुदा उन्हें दरियाए-यरदन के मग़रिब में वाक़े मुल्क देगा और वह तुम्हारी तरह आराम और सुकून से वहाँ आबाद हो जाएंगे तब तुम अपने मुल्क में वापस जा सकते हो।” ");
INSERT INTO urdgvh_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","साथ साथ मैंने यशुअ से कहा, “तूने अपनी आँखों से सब कुछ देख लिया है जो रब तुम्हारे ख़ुदा ने इन दोनों बादशाहों सीहोन और ओज से किया। वह यही कुछ हर उस बादशाह के साथ करेगा जिसके मुल्क पर तू दरिया को पार करके हमला करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","उनसे न डरो। तुम्हारा ख़ुदा ख़ुद तुम्हारे लिए जंग करेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","उस वक़्त मैंने रब से इल्तिजा करके कहा, ");
INSERT INTO urdgvh_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“ऐ रब क़ादिरे-मुतलक़, तू अपने ख़ादिम को अपनी अज़मत और क़ुदरत दिखाने लगा है। क्या आसमान या ज़मीन पर कोई और ख़ुदा है जो तेरी तरह के अज़ीम काम कर सकता है? हरगिज़ नहीं! ");
INSERT INTO urdgvh_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","मेहरबानी करके मुझे भी दरियाए-यरदन को पार करके उस अच्छे मुल्क यानी उस बेहतरीन पहाड़ी इलाक़े को लुबनान तक देखने की इजाज़त दे।” ");
INSERT INTO urdgvh_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","लेकिन तुम्हारे सबब से रब मुझसे नाराज़ था। उसने मेरी न सुनी बल्कि कहा, “बस कर! आइंदा मेरे साथ इसका ज़िक्र न करना। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","पिसगा की चोटी पर चढ़कर चारों तरफ़ नज़र दौड़ा। वहाँ से ग़ौर से देख, क्योंकि तू ख़ुद दरियाए-यरदन को उबूर नहीं करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","अपनी जगह यशुअ को मुक़र्रर कर। उस की हौसलाअफ़्ज़ाई कर और उसे मज़बूत कर, क्योंकि वही इस क़ौम को दरियाए-यरदन के मग़रिब में ले जाएगा और क़बीलों में उस मुल्क को तक़सीम करेगा जिसे तू पहाड़ से देखेगा।” ");
INSERT INTO urdgvh_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","चुनाँचे हम बैत-फ़ग़ूर के क़रीब वादी में ठहरे। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","ऐ इसराईल, अब वह तमाम अहकाम ध्यान से सुन ले जो मैं तुम्हें सिखाता हूँ। उन पर अमल करो ताकि तुम ज़िंदा रहो और जाकर उस मुल्क पर क़ब्ज़ा करो जो रब तुम्हारे बापदादा का ख़ुदा तुम्हें देनेवाला है। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","जो अहकाम मैं तुम्हें सिखाता हूँ उनमें न किसी बात का इज़ाफ़ा करो और न उनसे कोई बात निकालो। रब अपने ख़ुदा के तमाम अहकाम पर अमल करो जो मैंने तुम्हें दिए हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","तुमने ख़ुद देखा है कि रब ने बाल-फ़ग़ूर से क्या कुछ किया। वहाँ रब तेरे ख़ुदा ने हर एक को हलाक कर डाला जिसने फ़ग़ूर के बाल देवता की पूजा की। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","लेकिन तुममें से जितने रब अपने ख़ुदा के साथ लिपटे रहे वह सब आज तक ज़िंदा हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","मैंने तुम्हें तमाम अहकाम यों सिखा दिए हैं जिस तरह रब मेरे ख़ुदा ने मुझे बताया। क्योंकि लाज़िम है कि तुम उस मुल्क में इनके ताबे रहो जिस पर तुम क़ब्ज़ा करनेवाले हो। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","इन्हें मानो और इन पर अमल करो तो दूसरी क़ौमों को तुम्हारी दानिशमंदी और समझ नज़र आएगी। फिर वह इन तमाम अहकाम के बारे में सुनकर कहेंगी, “वाह, यह अज़ीम क़ौम कैसी दानिशमंद और समझदार है!” ");
INSERT INTO urdgvh_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","कौन-सी अज़ीम क़ौम के माबूद इतने क़रीब हैं जितना हमारा ख़ुदा हमारे क़रीब है? जब भी हम मदद के लिए पुकारते हैं तो रब हमारा ख़ुदा मौजूद होता है। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","कौन-सी अज़ीम क़ौम के पास ऐसे मुंसिफ़ाना अहकाम और हिदायात हैं जैसे मैं आज तुम्हें पूरी शरीअत सुनाकर पेश कर रहा हूँ? ");
INSERT INTO urdgvh_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","लेकिन ख़बरदार, एहतियात करना और वह तमाम बातें न भूलना जो तेरी आँखों ने देखी हैं। वह उम्र-भर तेरे दिल में से मिट न जाएँ बल्कि उन्हें अपने बच्चों और पोते-पोतियों को भी बताते रहना। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","वह दिन याद कर जब तू होरिब यानी सीना पहाड़ पर रब अपने ख़ुदा के सामने हाज़िर था और उसने मुझे बताया, “क़ौम को यहाँ मेरे पास जमा कर ताकि मैं उनसे बात करूँ और वह उम्र-भर मेरा ख़ौफ़ मानें और अपने बच्चों को मेरी बातें सिखाते रहें।” ");
INSERT INTO urdgvh_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","उस वक़्त तुम क़रीब आकर पहाड़ के दामन में खड़े हुए। वह जल रहा था, और उस की आग आसमान तक भड़क रही थी जबकि काले बादलों और गहरे अंधेरे ने उसे नज़रों से छुपा दिया। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","फिर रब आग में से तुमसे हमकलाम हुआ। तुमने उस की बातें सुनीं लेकिन उस की कोई शक्ल न देखी। सिर्फ़ उस की आवाज़ सुनाई दी। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","उसने तुम्हारे लिए अपने अहद यानी उन 10 अहकाम का एलान किया और हुक्म दिया कि इन पर अमल करो। फिर उसने उन्हें पत्थर की दो तख़्तियों पर लिख दिया। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","रब ने मुझे हिदायत की, “उन्हें वह तमाम अहकाम सिखा जिनके मुताबिक़ उन्हें चलना होगा जब वह दरियाए-यरदन को पार करके कनान पर क़ब्ज़ा करेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","जब रब होरिब यानी सीना पहाड़ पर तुमसे हमकलाम हुआ तो तुमने उस की कोई शक्ल न देखी। चुनाँचे ख़बरदार रहो ");
INSERT INTO urdgvh_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","कि तुम ग़लत काम करके अपने लिए किसी भी शक्ल का बुत न बनाओ। न मर्द, औरत, ");
INSERT INTO urdgvh_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","ज़मीन पर चलनेवाले जानवर, परिंदे, ");
INSERT INTO urdgvh_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","रेंगनेवाले जानवर या मछली का बुत बनाओ। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","जब तू आसमान की तरफ़ नज़र उठाकर आसमान का पूरा लशकर देखे तो सूरज, चाँद और सितारों की परस्तिश और ख़िदमत करने की आज़माइश में न पड़ना। रब तेरे ख़ुदा ने इन चीज़ों को बाक़ी तमाम क़ौमों को अता किया है, ");
INSERT INTO urdgvh_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","लेकिन तुम्हें उसने मिसर के भड़कते भट्टे से निकाला है ताकि तुम उस की अपनी क़ौम और उस की मीरास बन जाओ। और आज ऐसा ही हुआ है। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","तुम्हारे सबब से रब ने मुझसे नाराज़ होकर क़सम खाई कि तू दरियाए-यरदन को पार करके उस अच्छे मुल्क में दाख़िल नहीं होगा जो रब तेरा ख़ुदा तुझे मीरास में देनेवाला है। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","मैं यहीं इसी मुल्क में मर जाऊँगा और दरियाए-यरदन को पार नहीं करूँगा। लेकिन तुम दरिया को पार करके उस बेहतरीन मुल्क पर क़ब्ज़ा करोगे। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","हर सूरत में वह अहद याद रखना जो रब तुम्हारे ख़ुदा ने तुम्हारे साथ बाँधा है। अपने लिए किसी भी चीज़ की मूरत न बनाना। यह रब का हुक्म है, ");
INSERT INTO urdgvh_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","क्योंकि रब तेरा ख़ुदा भस्म कर देनेवाली आग है, वह ग़यूर ख़ुदा है। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","तुम मुल्क में जाकर वहाँ रहोगे। तुम्हारे बच्चे और पोते-नवासे उसमें पैदा हो जाएंगे। जब इस तरह बहुत वक़्त गुज़र जाएगा तो ख़तरा है कि तुम ग़लत काम करके किसी चीज़ की मूरत बनाओ। ऐसा कभी न करना। यह रब तुम्हारे ख़ुदा की नज़र में बुरा है और उसे ग़ुस्सा दिलाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","आज आसमान और ज़मीन मेरे गवाह हैं कि अगर तुम ऐसा करो तो जल्दी से उस मुल्क में से मिट जाओगे जिस पर तुम दरियाए-यरदन को पार करके क़ब्ज़ा करोगे। तुम देर तक वहाँ जीते नहीं रहोगे बल्कि पूरे तौर पर हलाक हो जाओगे। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","रब तुम्हें मुल्क से निकालकर मुख़्तलिफ़ क़ौमों में मुंतशिर कर देगा, और वहाँ सिर्फ़ थोड़े ही अफ़राद बचे रहेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","वहाँ तुम इनसान के हाथों से बने हुए लकड़ी और पत्थर के बुतों की ख़िदमत करोगे, जो न देख सकते, न सुन सकते, न खा सकते और न सूँघ सकते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","वहीं तू रब अपने ख़ुदा को तलाश करेगा, और अगर उसे पूरे दिलो-जान से ढूँडे तो वह तुझे मिल भी जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","जब तू इस तकलीफ़ में मुब्तला होगा और यह सारा कुछ तुझ पर से गुज़रेगा फिर आख़िरकार रब अपने ख़ुदा की तरफ़ रुजू करके उस की सुनेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","क्योंकि रब तेरा ख़ुदा रहीम ख़ुदा है। वह तुझे न तर्क करेगा और न बरबाद करेगा। वह उस अहद को नहीं भूलेगा जो उसने क़सम खाकर तेरे बापदादा से बाँधा था। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","दुनिया में इनसान की तख़लीक़ से लेकर आज तक माज़ी की तफ़तीश कर। आसमान के एक सिरे से दूसरे सिरे तक खोज लगा। क्या इससे पहले कभी इस तरह का मोजिज़ाना काम हुआ है? क्या किसी ने इससे पहले इस क़िस्म के अज़ीम काम की ख़बर सुनी है? ");
INSERT INTO urdgvh_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","तूने आग में से बोलती हुई अल्लाह की आवाज़ सुनी तो भी जीता बचा! क्या किसी और क़ौम के साथ ऐसा हुआ है? ");
INSERT INTO urdgvh_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","क्या किसी और माबूद ने कभी जुर्रत की है कि रब की तरह पूरी क़ौम को एक मुल्क से निकालकर अपनी मिलकियत बनाया हो? उसने ऐसा ही तुम्हारे साथ किया। उसने तुम्हारे देखते देखते मिसरियों को आज़माया, उन्हें बड़े मोजिज़े दिखाए, उनके साथ जंग की, अपनी बड़ी क़ुदरत और इख़्तियार का इज़हार किया और हौलनाक कामों से उन पर ग़ालिब आ गया। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","तुझे यह सब कुछ दिखाया गया ताकि तू जान ले कि रब ख़ुदा है। उसके सिवा कोई और नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","उसने तुझे नसीहत देने के लिए आसमान से अपनी आवाज़ सुनाई। ज़मीन पर उसने तुझे अपनी अज़ीम आग दिखाई जिसमें से तूने उस की बातें सुनीं। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","उसे तेरे बापदादा से प्यार था, और उसने तुझे जो उनकी औलाद हैं चुन लिया। इसलिए वह ख़ुद हाज़िर होकर अपनी अज़ीम क़ुदरत से तुझे मिसर से निकाल लाया। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","उसने तेरे आगे से तुझसे ज़्यादा बड़ी और ताक़तवर क़ौमें निकाल दीं ताकि तुझे उनका मुल्क मीरास में मिल जाए। आज ऐसा ही हो रहा है। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","चुनाँचे आज जान ले और ज़हन में रख कि रब आसमान और ज़मीन का ख़ुदा है। कोई और माबूद नहीं है। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","उसके अहकाम पर अमल कर जो मैं तुझे आज सुना रहा हूँ। फिर तू और तेरी औलाद कामयाब होंगे, और तू देर तक उस मुल्क में जीता रहेगा जो रब तुझे हमेशा के लिए दे रहा है। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","यह कहकर मूसा ने दरियाए-यरदन के मशरिक़ में पनाह के तीन शहर चुन लिए। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","उनमें वह शख़्स पनाह ले सकता था जिसने दुश्मनी की बिना पर नहीं बल्कि ग़ैरइरादी तौर पर किसी को जान से मार दिया था। ऐसे शहर में पनाह लेने के सबब से उसे बदले में क़त्ल नहीं किया जा सकता था। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","इसके लिए रूबिन के क़बीले के लिए मैदाने-मुरतफ़ा का शहर बसर, जद के क़बीले के लिए जिलियाद का शहर रामात और मनस्सी के क़बीले के लिए बसन का शहर जौलान चुना गया। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","दर्जे-ज़ैल वह शरीअत है जो मूसा ने इसराईलियों को पेश की। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","मूसा ने यह अहकाम और हिदायात उस वक़्त पेश कीं जब वह मिसर से निकल कर ");
INSERT INTO urdgvh_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","दरियाए-यरदन के मशरिक़ी किनारे पर थे। बैत-फ़ग़ूर उनके मुक़ाबिल था, और वह अमोरी बादशाह सीहोन के मुल्क में ख़ैमाज़न थे। सीहोन की रिहाइश हसबोन में थी और उसे इसराईलियों से शिकस्त हुई थी जब वह मूसा की राहनुमाई में मिसर से निकल आए थे। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","उसके मुल्क पर क़ब्ज़ा करके उन्होंने बसन के मुल्क पर भी फ़तह पाई थी जिसका बादशाह ओज था। इन दोनों अमोरी बादशाहों का यह पूरा इलाक़ा उनके हाथ में आ गया था। यह इलाक़ा दरियाए-यरदन के मशरिक़ में था। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","उस की जुनूबी सरहद दरियाए-अरनोन के किनारे पर वाक़े शहर अरोईर थी जबकि उस की शिमाली सरहद सिरयून यानी हरमून पहाड़ थी। ");
INSERT INTO urdgvh_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","दरियाए-यरदन का पूरा मशरिक़ी किनारा पिसगा के पहाड़ी सिलसिले के दामन में वाक़े बहीराए-मुरदार तक उसमें शामिल था। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","मूसा ने तमाम इसराईलियों को जमा करके कहा, ऐ इसराईल, ध्यान से वह हिदायात और अहकाम सुन जो मैं तुम्हें आज पेश कर रहा हूँ। उन्हें सीखो और बड़ी एहतियात से उन पर अमल करो। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","रब हमारे ख़ुदा ने होरिब यानी सीना पहाड़ पर हमारे साथ अहद बाँधा। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","उसने यह अहद हमारे बापदादा के साथ नहीं बल्कि हमारे ही साथ बाँधा है, जो आज इस जगह पर ज़िंदा हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","रब पहाड़ पर आग में से रूबरू होकर तुमसे हमकलाम हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","उस वक़्त मैं तुम्हारे और रब के दरमियान खड़ा हुआ ताकि तुम्हें रब की बातें सुनाऊँ। क्योंकि तुम आग से डरते थे और इसलिए पहाड़ पर न चढ़े। उस वक़्त रब ने कहा, ");
INSERT INTO urdgvh_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“मैं रब तेरा ख़ुदा हूँ जो तुझे मुल्के-मिसर की ग़ुलामी से निकाल लाया। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","मेरे सिवा किसी और माबूद की परस्तिश न करना। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","अपने लिए बुत न बनाना। किसी भी चीज़ की मूरत न बनाना, चाहे वह आसमान में, ज़मीन पर या समुंदर में हो। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","न बुतों की परस्तिश, न उनकी ख़िदमत करना, क्योंकि मैं तेरा रब ग़यूर ख़ुदा हूँ। जो मुझसे नफ़रत करते हैं उन्हें मैं तीसरी और चौथी पुश्त तक सज़ा दूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","लेकिन जो मुझसे मुहब्बत रखते और मेरे अहकाम पूरे करते हैं उन पर मैं हज़ार पुश्तों तक मेहरबानी करूँगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","रब अपने ख़ुदा का नाम बेमक़सद या ग़लत मक़सद के लिए इस्तेमाल न करना। जो भी ऐसा करता है उसे रब सज़ा दिए बग़ैर नहीं छोड़ेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","सबत के दिन का ख़याल रखना। उसे इस तरह मनाना कि वह मख़सूसो-मुक़द्दस हो, उसी तरह जिस तरह रब तेरे ख़ुदा ने तुझे हुक्म दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","हफ़ते के पहले छः दिन अपना काम-काज कर, ");
INSERT INTO urdgvh_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","लेकिन सातवाँ दिन रब तेरे ख़ुदा का आराम का दिन है। उस दिन किसी तरह का काम न करना। न तू, न तेरा बेटा, न तेरी बेटी, न तेरा नौकर, न तेरी नौकरानी, न तेरा बैल, न तेरा गधा, न तेरा कोई और मवेशी। जो परदेसी तेरे दरमियान रहता है वह भी काम न करे। तेरे नौकर और तेरी नौकरानी को तेरी तरह आराम का मौक़ा मिलना है। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","याद रखना कि तू मिसर में ग़ुलाम था और कि रब तेरा ख़ुदा ही तुझे बड़ी क़ुदरत और इख़्तियार से वहाँ से निकाल लाया। इसलिए उसने तुझे हुक्म दिया है कि सबत का दिन मनाना। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","अपने बाप और अपनी माँ की इज़्ज़त करना जिस तरह रब तेरे ख़ुदा ने तुझे हुक्म दिया है। फिर तू उस मुल्क में जो रब तेरा ख़ुदा तुझे देनेवाला है ख़ुशहाल होगा और देर तक जीता रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","क़त्ल न करना। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","ज़िना न करना। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","चोरी न करना। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","अपने पड़ोसी के बारे में झूटी गवाही न देना। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","अपने पड़ोसी की बीवी का लालच न करना। न उसके घर का, न उस की ज़मीन का, न उसके नौकर का, न उस की नौकरानी का, न उसके बैल और न उसके गधे का बल्कि उस की किसी भी चीज़ का लालच न करना।” ");
INSERT INTO urdgvh_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","रब ने तुम सबको यह अहकाम दिए जब तुम सीना पहाड़ के दामन में जमा थे। वहाँ तुमने आग, बादल और गहरे अंधेरे में से उस की ज़ोरदार आवाज़ सुनी। यही कुछ उसने कहा और बस। फिर उसने उन्हें पत्थर की दो तख़्तियों पर लिखकर मुझे दे दिया। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","जब तुमने तारीकी से यह आवाज़ सुनी और पहाड़ की जलती हुई हालत देखी तो तुम्हारे क़बीलों के राहनुमा और बुज़ुर्ग मेरे पास आए। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","उन्होंने कहा, “रब हमारे ख़ुदा ने हम पर अपना जलाल और अज़मत ज़ाहिर की है। आज हमने आग में से उस की आवाज़ सुनी है। हमने देख लिया है कि जब अल्लाह इनसान से हमकलाम होता है तो ज़रूरी नहीं कि वह मर जाए। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","लेकिन अब हम क्यों अपनी जान ख़तरे में डालें? अगर हम मज़ीद रब अपने ख़ुदा की आवाज़ सुनें तो यह बड़ी आग हमें भस्म कर देगी और हम अपनी जान से हाथ धो बैठेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","क्योंकि फ़ानी इनसानों में से कौन हमारी तरह ज़िंदा ख़ुदा को आग में से बातें करते हुए सुनकर ज़िंदा रहा है? कोई भी नहीं! ");
INSERT INTO urdgvh_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","आप ही क़रीब जाकर उन तमाम बातों को सुनें जो रब हमारा ख़ुदा हमें बताना चाहता है। फिर लौटकर हमें वह बातें सुनाएँ। हम उन्हें सुनेंगे और उन पर अमल करेंगे।” ");
INSERT INTO urdgvh_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","जब रब ने यह सुना तो उसने मुझसे कहा, “मैंने इन लोगों की यह बातें सुन ली हैं। वह ठीक कहते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","काश उनकी सोच हमेशा ऐसी ही हो! काश वह हमेशा इसी तरह मेरा ख़ौफ़ मानें और मेरे अहकाम पर अमल करें! अगर वह ऐसा करेंगे तो वह और उनकी औलाद हमेशा कामयाब रहेंगे। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","जा, उन्हें बता दे कि अपने ख़ैमों में लौट जाओ। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","लेकिन तू यहाँ मेरे पास रह ताकि मैं तुझे तमाम क़वानीन और अहकाम दे दूँ। उनको लोगों को सिखाना ताकि वह उस मुल्क में उनके मुताबिक़ चलें जो मैं उन्हें दूँगा।” ");
INSERT INTO urdgvh_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","चुनाँचे एहतियात से उन अहकाम पर अमल करो जो रब तुम्हारे ख़ुदा ने तुम्हें दिए हैं। उनसे न दाईं तरफ़ हटो न बाईं तरफ़। ");
INSERT INTO urdgvh_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","हमेशा उस राह पर चलते रहो जो रब तुम्हारे ख़ुदा ने तुम्हें बताई है। फिर तुम कामयाब होगे और उस मुल्क में देर तक जीते रहोगे जिस पर तुम क़ब्ज़ा करोगे। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","यह वह तमाम अहकाम हैं जो रब तुम्हारे ख़ुदा ने मुझे तुम्हें सिखाने के लिए कहा। उस मुल्क में इन पर अमल करना जिसमें तुम जानेवाले हो ताकि उस पर क़ब्ज़ा करो। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","उम्र-भर तू, तेरे बच्चे और पोते-नवासे रब अपने ख़ुदा का ख़ौफ़ मानें और उसके उन तमाम अहकाम पर चलें जो मैं तुझे दे रहा हूँ। तब तू देर तक जीता रहेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","ऐ इसराईल, यह मेरी बातें सुन और बड़ी एहतियात से इन पर अमल कर! फिर रब तेरे ख़ुदा का वादा पूरा हो जाएगा कि तू कामयाब रहेगा और तेरी तादाद उस मुल्क में ख़ूब बढ़ती जाएगी जिसमें दूध और शहद की कसरत है। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","सुन ऐ इसराईल! रब हमारा ख़ुदा एक ही रब है। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","रब अपने ख़ुदा से अपने पूरे दिल, अपनी पूरी जान और अपनी पूरी ताक़त से प्यार करना। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","जो अहकाम मैं तुझे आज बता रहा हूँ उन्हें अपने दिल पर नक़्श कर। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","उन्हें अपने बच्चों के ज़हननशीन करा। यही बातें हर वक़्त और हर जगह तेरे लबों पर हों ख़ाह तू घर में बैठा या रास्ते पर चलता हो, लेटा हो या खड़ा हो। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","उन्हें निशान के तौर पर और याददिहानी के लिए अपने बाज़ुओं और माथे पर लगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","उन्हें अपने घरों की चौखटों और अपने शहरों के दरवाज़ों पर लिख। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","रब तेरे ख़ुदा का वादा पूरा होगा जो उसने क़सम खाकर तेरे बापदादा इब्राहीम, इसहाक़ और याक़ूब के साथ किया कि मैं तुझे कनान में ले जाऊँगा। जो बड़े और शानदार शहर उसमें हैं वह तूने ख़ुद नहीं बनाए। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","जो मकान उसमें हैं वह ऐसी अच्छी चीज़ों से भरे हुए हैं जो तूने उनमें नहीं रखीं। जो कुएँ उसमें हैं उनको तूने नहीं खोदा। जो अंगूर और ज़ैतून के बाग़ उसमें हैं उन्हें तूने नहीं लगाया। यह हक़ीक़त याद रख। जब तू उस मुल्क में कसरत का खाना खाकर सेर हो जाएगा ");
INSERT INTO urdgvh_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","तो ख़बरदार! रब को न भूलना जो तुझे मिसर की ग़ुलामी से निकाल लाया। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","रब अपने ख़ुदा का ख़ौफ़ मानना। सिर्फ़ उसी की इबादत करना और उसी का नाम लेकर क़सम खाना। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","दीगर माबूदों की पैरवी न करना। इसमें तमाम पड़ोसी अक़वाम के देवता भी शामिल हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","वरना रब तेरे ख़ुदा का ग़ज़ब तुझ पर नाज़िल होकर तुझे मुल्क में से मिटा डालेगा। क्योंकि वह ग़यूर ख़ुदा है और तेरे दरमियान ही रहता है। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","रब अपने ख़ुदा को उस तरह न आज़माना जिस तरह तुमने मस्सा में किया था। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","ध्यान से रब अपने ख़ुदा के अहकाम के मुताबिक़ चलो, उन तमाम हिदायात और क़वानीन पर जो उसने तुझे दिए हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","जो कुछ रब की नज़र में दुरुस्त और अच्छा है वह कर। फिर तू कामयाब रहेगा, तू जाकर उस अच्छे मुल्क पर क़ब्ज़ा करेगा जिसका वादा रब ने तेरे बापदादा से क़सम खाकर किया था। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","तब रब की बात पूरी हो जाएगी कि तू अपने दुश्मनों को अपने आगे आगे निकाल देगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","आनेवाले दिनों में तेरे बच्चे पूछेंगे, “रब हमारे ख़ुदा ने आपको इन तमाम अहकाम पर अमल करने को क्यों कहा?” ");
INSERT INTO urdgvh_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","फिर उन्हें जवाब देना, “हम मिसर के बादशाह फ़िरौन के ग़ुलाम थे, लेकिन रब हमें बड़ी क़ुदरत का इज़हार करके मिसर से निकाल लाया। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","हमारे देखते देखते उसने बड़े बड़े निशान और मोजिज़े किए और मिसर, फ़िरौन और उसके पूरे घराने पर हौलनाक मुसीबतें भेजीं। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","उस वक़्त वह हमें वहाँ से निकाल लाया ताकि हमें लेकर वह मुल्क दे जिसका वादा उसने क़सम खाकर हमारे बापदादा के साथ किया था। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","रब हमारे ख़ुदा ही ने हमें कहा कि इन तमाम अहकाम के मुताबिक़ चलो और रब अपने ख़ुदा का ख़ौफ़ मानो। क्योंकि अगर हम ऐसा करें तो फिर हम हमेशा कामयाब और ज़िंदा रहेंगे। और आज तक ऐसा ही रहा है। ");
INSERT INTO urdgvh_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","अगर हम रब अपने ख़ुदा के हुज़ूर रहकर एहतियात से उन तमाम बातों पर अमल करेंगे जो उसने हमें करने को कही हैं तो वह हमें रास्तबाज़ क़रार देगा।” ");
INSERT INTO urdgvh_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","रब तेरा ख़ुदा तुझे उस मुल्क में ले जाएगा जिस पर तू जाकर क़ब्ज़ा करेगा। वह तेरे सामने से बहुत-सी क़ौमें भगा देगा। गो यह सात क़ौमें यानी हित्ती, जिरजासी, अमोरी, कनानी, फ़रिज़्ज़ी, हिव्वी और यबूसी तादाद और ताक़त के लिहाज़ से तुझसे बड़ी होंगी ");
INSERT INTO urdgvh_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","तो भी रब तेरा ख़ुदा उन्हें तेरे हवाले करेगा। जब तू उन्हें शिकस्त देगा तो उन सबको उसके लिए मख़सूस करके हलाक कर देना है। न उनके साथ अहद बाँधना और न उन पर रहम करना। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","उनमें से किसी से शादी न करना। न अपनी बेटियों का रिश्ता उनके बेटों को देना, न अपने बेटों का रिश्ता उनकी बेटियों से करना। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","वरना वह तुम्हारे बच्चों को मेरी पैरवी से दूर करेंगे और वह मेरी नहीं बल्कि उनके देवताओं की ख़िदमत करेंगे। तब रब का ग़ज़ब तुम पर नाज़िल होकर जल्दी से तुम्हें हलाक कर देगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","इसलिए उनकी क़ुरबानगाहें ढा देना। जिन पत्थरों की वह पूजा करते हैं उन्हें चकनाचूर कर देना, उनके यसीरत देवी के खंबे काट डालना और उनके बुत जला देना। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","क्योंकि तू रब अपने ख़ुदा के लिए मख़सूसो-मुक़द्दस है। उसने दुनिया की तमाम क़ौमों में से तुझे चुनकर अपनी क़ौम और ख़ास मिलकियत बनाया। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","रब ने क्यों तुम्हारे साथ ताल्लुक़ क़ायम किया और तुम्हें चुन लिया? क्या इस वजह से कि तुम तादाद में दीगर क़ौमों की निसबत ज़्यादा थे? हरगिज़ नहीं! तुम तो बहुत कम थे। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","बल्कि वजह यह थी कि रब ने तुम्हें प्यार किया और वह वादा पूरा किया जो उसने क़सम खाकर तुम्हारे बापदादा के साथ किया था। इसी लिए वह फ़िद्या देकर तुम्हें बड़ी क़ुदरत से मिसर की ग़ुलामी और उस मुल्क के बादशाह के हाथ से बचा लाया। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","चुनाँचे जान ले कि सिर्फ़ रब तेरा ख़ुदा ही ख़ुदा है। वह वफ़ादार ख़ुदा है। जो उससे मुहब्बत रखते और उसके अहकाम पर अमल करते हैं उनके साथ वह अपना अहद क़ायम रखेगा और उन पर हज़ार पुश्तों तक मेहरबानी करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","लेकिन उससे नफ़रत करनेवालों को वह उनके रूबरू मुनासिब सज़ा देकर बरबाद करेगा। हाँ, जो उससे नफ़रत करते हैं, उनके रूबरू वह मुनासिब सज़ा देगा और झिजकेगा नहीं। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","चुनाँचे ध्यान से उन तमाम अहकाम पर अमल कर जो मैं आज तुझे दे रहा हूँ ताकि तू उनके मुताबिक़ ज़िंदगी गुज़ारे। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","अगर तू उन पर तवज्जुह दे और एहतियात से उन पर चले तो फिर रब तेरा ख़ुदा तेरे साथ अपना अहद क़ायम रखेगा और तुझ पर मेहरबानी करेगा, बिलकुल उस वादे के मुताबिक़ जो उसने क़सम खाकर तेरे बापदादा से किया था। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","वह तुझे प्यार करेगा और तुझे उस मुल्क में बरकत देगा जो तुझे देने का वादा उसने क़सम खाकर तेरे बापदादा से किया था। तुझे बहुत औलाद बख़्शने के अलावा वह तेरे खेतों को बरकत देगा, और तुझे कसरत का अनाज, अंगूर और ज़ैतून हासिल होगा। वह तेरे रेवड़ों को भी बरकत देगा, और तेरे गाय-बैलों और भेड़-बकरियों की तादाद बढ़ती जाएगी। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","तुझे दीगर तमाम क़ौमों की निसबत कहीं ज़्यादा बरकत मिलेगी। न तुझमें और न तेरे मवेशियों में बाँझपन पाया जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","रब हर बीमारी को तुझसे दूर रखेगा। वह तुझमें वह ख़तरनाक वबाएँ फैलने नहीं देगा जिनसे तू मिसर में वाक़िफ़ हुआ बल्कि उन्हें उनमें फैलाएगा जो तुझसे नफ़रत रखते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","जो भी क़ौमें रब तेरा ख़ुदा तेरे हाथ में कर देगा उन्हें तबाह करना लाज़िम है। उन पर रहम की निगाह से न देखना, न उनके देवताओं की ख़िदमत करना, वरना तू फँस जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","गो तेरा दिल कहे, “यह क़ौमें हमसे ताक़तवर हैं। हम किस तरह इन्हें निकाल सकते हैं?” ");
INSERT INTO urdgvh_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","तो भी उनसे न डर। वही कुछ ज़हन में रख जो रब तेरे ख़ुदा ने फ़िरौन और पूरे मिसर के साथ किया। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","क्योंकि तूने अपनी आँखों से रब अपने ख़ुदा की वह बड़ी आज़मानेवाली मुसीबतें और मोजिज़े, उसका वह अज़ीम इख़्तियार और क़ुदरत देखी जिससे वह तुझे वहाँ से निकाल लाया। वही कुछ रब तेरा ख़ुदा उन क़ौमों के साथ भी करेगा जिनसे तू इस वक़्त डरता है। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","न सिर्फ़ यह बल्कि रब तेरा ख़ुदा उनके दरमियान ज़ंबूर भी भेजेगा ताकि वह भी तबाह हो जाएँ जो पहले हमलों से बचकर छुप गए हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","उनसे दहशत न खा, क्योंकि रब तेरा ख़ुदा तेरे दरमियान है। वह अज़ीम ख़ुदा है जिससे सब ख़ौफ़ खाते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","वह रफ़्ता रफ़्ता उन क़ौमों को तेरे आगे से भगा देगा। तू उन्हें एकदम ख़त्म नहीं कर सकेगा, वरना जंगली जानवर तेज़ी से बढ़कर तुझे नुक़सान पहुचाएँगे। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","रब तेरा ख़ुदा उन्हें तेरे हवाले कर देगा। वह उनमें इतनी सख़्त अफ़रा-तफ़री पैदा करेगा कि वह बरबाद हो जाएंगे। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","वह उनके बादशाहों को भी तेरे क़ाबू में कर देगा, और तू उनका नामो-निशान मिटा देगा। कोई भी तेरा सामना नहीं कर सकेगा बल्कि तू उन सबको बरबाद कर देगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","उनके देवताओं के मुजस्समे जला देना। जो चाँदी और सोना उन पर चढ़ाया हुआ है उसका लालच न करना। उसे न लेना वरना तू फँस जाएगा। क्योंकि इन चीज़ों से रब तेरे ख़ुदा को घिन आती है। ");
INSERT INTO urdgvh_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","इस तरह की मकरूह चीज़ अपने घर में न लाना, वरना तुझे भी उसके साथ अलग करके बरबाद किया जाएगा। तेरे दिल में उससे शदीद नफ़रत और घिन हो, क्योंकि उसे पूरे तौर पर बरबाद करने के लिए मख़सूस किया गया है। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","एहतियात से उन तमाम अहकाम पर अमल करो जो मैं आज तुझे दे रहा हूँ। क्योंकि ऐसा करने से तुम जीते रहोगे, तादाद में बढ़ोगे और जाकर उस मुल्क पर क़ब्ज़ा करोगे जिसका वादा रब ने तुम्हारे बापदादा से क़सम खाकर किया था। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","वह पूरा वक़्त याद रख जब रब तेरा ख़ुदा रेगिस्तान में 40 साल तक तेरी राहनुमाई करता रहा ताकि तुझे आजिज़ करके आज़माए और मालूम करे कि क्या तू उसके अहकाम पर चलेगा कि नहीं। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","उसने तुझे आजिज़ करके भूके होने दिया, फिर तुझे मन खिलाया जिससे न तू और न तेरे बापदादा वाक़िफ़ थे। क्योंकि वह तुझे सिखाना चाहता था कि इनसान की ज़िंदगी सिर्फ़ रोटी पर मुनहसिर नहीं होती बल्कि हर उस बात पर जो रब के मुँह से निकलती है। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","इन 40 सालों के दौरान तेरे कपड़े न घिसे न फटे, न तेरे पाँव सूजे। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","चुनाँचे दिल में जान ले कि जिस तरह बाप अपने बेटे की तरबियत करता है उसी तरह रब हमारा ख़ुदा हमारी तरबियत करता है। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","रब अपने ख़ुदा के अहकाम पर अमल करके उस की राहों पर चल और उसका ख़ौफ़ मान। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","क्योंकि वह तुझे एक बेहतरीन मुल्क में ले जा रहा है जिसमें नहरें और ऐसे चश्मे हैं जो पहाड़ियों और वादियों की ज़मीन से फूट निकलते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","उस की पैदावार अनाज, जौ, अंगूर, अंजीर, अनार, ज़ैतून और शहद है। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","उसमें रोटी की कमी नहीं होगी, और तू किसी चीज़ से महरूम नहीं रहेगा। उसके पत्थरों में लोहा पाया जाता है, और खुदाई से तू उस की पहाड़ियों से ताँबा हासिल कर सकेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","जब तू कसरत का खाना खाकर सेर हो जाएगा तो फिर रब अपने ख़ुदा की तमजीद करना जिसने तुझे यह शानदार मुल्क दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","ख़बरदार, रब अपने ख़ुदा को न भूल और उसके उन अहकाम पर अमल करने से गुरेज़ न कर जो मैं आज तुझे दे रहा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","क्योंकि जब तू कसरत का खाना खाकर सेर हो जाएगा, तू शानदार घर बनाकर उनमें रहेगा ");
INSERT INTO urdgvh_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","और तेरे रेवड़, सोने-चाँदी और बाक़ी तमाम माल में इज़ाफ़ा होगा ");
INSERT INTO urdgvh_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","तो कहीं तू मग़रूर होकर रब अपने ख़ुदा को भूल न जाए जो तुझे मिसर की ग़ुलामी से निकाल लाया। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","जब तू उस वसी और हौलनाक रेगिस्तान में सफ़र कर रहा था जिसमें ज़हरीले साँप और बिच्छू थे तो वही तेरी राहनुमाई करता रहा। पानी से महरूम उस इलाक़े में वही सख़्त पत्थर में से पानी निकाल लाया। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","रेगिस्तान में वही तुझे मन खिलाता रहा, जिससे तेरे बापदादा वाक़िफ़ न थे। इन मुश्किलात से वह तुझे आजिज़ करके आज़माता रहा ताकि आख़िरकार तू कामयाब हो जाए। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","जब तुझे कामयाबी हासिल होगी तो यह न कहना कि मैंने अपनी ही क़ुव्वत और ताक़त से यह सब कुछ हासिल किया है। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","बल्कि रब अपने ख़ुदा को याद करना जिसने तुझे दौलत हासिल करने की क़ाबिलियत दी है। क्योंकि वह आज भी उसी अहद पर क़ायम है जो उसने तेरे बापदादा से किया था। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","रब अपने ख़ुदा को न भूलना, और न दीगर माबूदों के पीछे पड़कर उन्हें सिजदा और उनकी ख़िदमत करना। वरना मैं ख़ुद गवाह हूँ कि तुम यक़ीनन हलाक हो जाओगे। ");
INSERT INTO urdgvh_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","अगर तुम रब अपने ख़ुदा की इताअत नहीं करोगे तो फिर वह तुम्हें उन क़ौमों की तरह तबाह कर देगा जो तुमसे पहले इस मुल्क में रहती थीं। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","सुन ऐ इसराईल! आज तू दरियाए-यरदन को पार करनेवाला है। दूसरी तरफ़ तू ऐसी क़ौमों को भगा देगा जो तुझसे बड़ी और ताक़तवर हैं और जिनके शानदार शहरों की फ़सीलें आसमान से बातें करती हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","वहाँ अनाक़ी बसते हैं जो ताक़तवर और दराज़क़द हैं। तू ख़ुद जानता है कि उनके बारे में कहा जाता है, “कौन अनाक़ियों का सामना कर सकता है?” ");
INSERT INTO urdgvh_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","लेकिन आज जान ले कि रब तेरा ख़ुदा तेरे आगे आगे चलते हुए उन्हें भस्म कर देनेवाली आग की तरह हलाक करेगा। वह तेरे आगे आगे उन पर क़ाबू पाएगा, और तू उन्हें निकालकर जल्दी मिटा देगा, जिस तरह रब ने वादा किया है। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","जब रब तेरा ख़ुदा उन्हें तेरे सामने से निकाल देगा तो तू यह न कहना, “मैं रास्तबाज़ हूँ, इसी लिए रब मुझे लायक़ समझकर यहाँ लाया और यह मुल्क मीरास में दे दिया है।” यह बात हरगिज़ दुरुस्त नहीं है। रब उन क़ौमों को उनकी ग़लत हरकतों की वजह से तेरे सामने से निकाल देगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","तू अपनी रास्तबाज़ी और दियानतदारी की बिना पर उस मुल्क पर क़ब्ज़ा नहीं करेगा बल्कि रब उन्हें उनकी शरीर हरकतों के बाइस तेरे सामने से निकाल देगा। दूसरे, जो वादा उसने तेरे बापदादा इब्राहीम, इसहाक़ और याक़ूब के साथ क़सम खाकर किया था उसे पूरा होना है। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","चुनाँचे जान ले कि रब तेरा ख़ुदा तुझे तेरी रास्ती के बाइस यह अच्छा मुल्क नहीं दे रहा। हक़ीक़त तो यह है कि तू हटधर्म क़ौम है। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","याद रख और कभी न भूल कि तूने रेगिस्तान में रब अपने ख़ुदा को किस तरह नाराज़ किया। मिसर से निकलते वक़्त से लेकर यहाँ पहुँचने तक तुम रब से सरकश रहे हो। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","ख़ासकर होरिब यानी सीना के दामन में तुमने रब को इतना ग़ुस्सा दिलाया कि वह तुम्हें हलाक करने को था। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","उस वक़्त मैं पहाड़ पर चढ़ गया था ताकि पत्थर की तख़्तियाँ यानी उस अहद की तख़्तियाँ मिल जाएँ जो रब ने तुम्हारे साथ बाँधा था। कुछ खाए पिए बग़ैर मैं 40 दिन और रात वहाँ रहा। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","11","जो कुछ रब ने आग में से कहा था जब तुम पहाड़ के दामन में जमा थे वही कुछ उसने अपनी उँगली से दोनों तख़्तियों पर लिखकर मुझे दिया। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","उसने मुझसे कहा, “फ़ौरन यहाँ से उतर जा। तेरी क़ौम जिसे तू मिसर से निकाल लाया बिगड़ गई है। वह कितनी जल्दी से मेरे अहकाम से हट गए हैं। उन्होंने अपने लिए बुत ढाल लिया है। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","मैंने जान लिया है कि यह क़ौम कितनी ज़िद्दी है। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","अब मुझे छोड़ दे ताकि मैं उन्हें तबाह करके उनका नामो-निशान दुनिया में से मिटा डालूँ। उनकी जगह मैं तुझसे एक क़ौम बना लूँगा जो उनसे बड़ी और ताक़तवर होगी।” ");
INSERT INTO urdgvh_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","मैं मुड़कर पहाड़ से उतरा जो अब तक भड़क रहा था। मेरे हाथों में अहद की दोनों तख़्तियाँ थीं। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","तुम्हें देखते ही मुझे मालूम हुआ कि तुमने रब अपने ख़ुदा का गुनाह किया है। तुमने अपने लिए बछड़े का बुत ढाल लिया था। तुम कितनी जल्दी से रब की मुक़र्ररा राह से हट गए थे। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","तब मैंने तुम्हारे देखते देखते दोनों तख़्तियों को ज़मीन पर पटख़कर टुकड़े टुकड़े कर दिया। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","एक और बार मैं रब के सामने मुँह के बल गिरा। मैंने न कुछ खाया, न कुछ पिया। 40 दिन और रात मैं तुम्हारे तमाम गुनाहों के बाइस इसी हालत में रहा। क्योंकि जो कुछ तुमने किया था वह रब को निहायत बुरा लगा, इसलिए वह ग़ज़बनाक हो गया था। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","वह तुमसे इतना नाराज़ था कि मैं बहुत डर गया। यों लग रहा था कि वह तुम्हें हलाक कर देगा। लेकिन इस बार भी उसने मेरी सुन ली। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","मैंने हारून के लिए भी दुआ की, क्योंकि रब उससे भी निहायत नाराज़ था और उसे हलाक कर देना चाहता था। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","जो बछड़ा तुमने गुनाह करके बनाया था उसे मैंने जला दिया, फिर जो कुछ बाक़ी रह गया उसे कुचल दिया और पीस पीसकर पौडर बना दिया। यह पौडर मैंने उस चश्मे में फेंक दिया जो पहाड़ पर से बह रहा था। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","तुमने रब को तबएरा, मस्सा और क़ब्रोत-हत्तावा में भी ग़ुस्सा दिलाया। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","क़ादिस-बरनीअ में भी ऐसा ही हुआ। वहाँ से रब ने तुम्हें भेजकर कहा था, “जाओ, उस मुल्क पर क़ब्ज़ा करो जो मैंने तुम्हें दे दिया है।” लेकिन तुमने सरकश होकर रब अपने ख़ुदा के हुक्म की ख़िलाफ़वरज़ी की। तुमने उस पर एतमाद न किया, न उस की सुनी। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","जब से मैं तुम्हें जानता हूँ तुम्हारा रब के साथ रवैया बाग़ियाना ही रहा है। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","मैं 40 दिन और रात रब के सामने ज़मीन पर मुँह के बल रहा, क्योंकि रब ने कहा था कि वह तुम्हें हलाक कर देगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","मैंने उससे मिन्नत करके कहा, “ऐ रब क़ादिरे-मुतलक़, अपनी क़ौम को तबाह न कर। वह तो तेरी ही मिलकियत है जिसे तूने फ़िद्या देकर अपनी अज़ीम क़ुदरत से बचाया और बड़े इख़्तियार के साथ मिसर से निकाल लाया। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","अपने ख़ादिमों इब्राहीम, इसहाक़ और याक़ूब को याद कर, और इस क़ौम की ज़िद, शरीर हरकतों और गुनाह पर तवज्जुह न दे। ");
INSERT INTO urdgvh_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","वरना मिसरी कहेंगे, ‘रब उन्हें उस मुल्क में लाने के क़ाबिल नहीं था जिसका वादा उसने किया था, बल्कि वह उनसे नफ़रत करता था। हाँ, वह उन्हें हलाक करने के लिए रेगिस्तान में ले आया।’ ");
INSERT INTO urdgvh_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","वह तो तेरी क़ौम हैं, तेरी मिलकियत जिसे तू अपनी अज़ीम क़ुदरत और इख़्तियार से मिसर से निकाल लाया।” ");
INSERT INTO urdgvh_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","उस वक़्त रब ने मुझसे कहा, “पत्थर की दो और तख़्तियाँ तराशना जो पहली तख़्तियों की मानिंद हों। उन्हें लेकर मेरे पास पहाड़ पर चढ़ आ। लकड़ी का संदूक़ भी बनाना। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","फिर मैं इन तख़्तियों पर दुबारा वही बातें लिखूँगा जो मैं उन तख़्तियों पर लिख चुका था जो तूने तोड़ डालीं। तुम्हें उन्हें संदूक़ में महफ़ूज़ रखना है।” ");
INSERT INTO urdgvh_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","मैंने कीकर की लकड़ी का संदूक़ बनवाया और दो तख़्तियाँ तराशीं जो पहली तख़्तियों की मानिंद थीं। फिर मैं दोनों तख़्तियाँ लेकर पहाड़ पर चढ़ गया। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","रब ने उन तख़्तियों पर दुबारा वह दस अहकाम लिख दिए जो वह पहली तख़्तियों पर लिख चुका था। (उन्हीं अहकाम का एलान उसने पहाड़ पर आग में से किया था जब तुम उसके दामन में जमा थे।) फिर उसने यह तख़्तियाँ मेरे सुपुर्द कीं। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","मैं लौटकर उतरा और तख़्तियों को उस संदूक़ में रखा जो मैंने बनाया था। वहाँ वह अब तक हैं। सब कुछ वैसा ही हुआ जैसा रब ने हुक्म दिया था। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","(इसके बाद इसराईली बनी-याक़ान के कुओं से रवाना होकर मौसीरा पहुँचे। वहाँ हारून फ़ौत हुआ। उसे दफ़न करने के बाद उसका बेटा इलियज़र उस की जगह इमाम बना। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","फिर वह आगे सफ़र करते करते जुदजूदा, फिर युतबाता पहुँचे जहाँ नहरें हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","उन दिनों में रब ने लावी के क़बीले को अलग करके उसे रब के अहद के संदूक़ को उठाकर ले जाने, रब के हुज़ूर ख़िदमत करने और उसके नाम से बरकत देने की ज़िम्मादारी दी। आज तक यह उनकी ज़िम्मादारी रही है। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","इस वजह से लावियों को दीगर क़बीलों की तरह न हिस्सा न मीरास मिली। रब तेरा ख़ुदा ख़ुद उनकी मीरास है। उसने ख़ुद उन्हें यह फ़रमाया है।) ");
INSERT INTO urdgvh_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","जब मैंने दूसरी मरतबा 40 दिन और रात पहाड़ पर गुज़ारे तो रब ने इस दफ़ा भी मेरी सुनी और तुझे हलाक न करने पर आमादा हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","उसने कहा, “जा, क़ौम की राहनुमाई कर ताकि वह जाकर उस मुल्क पर क़ब्ज़ा करें जिसका वादा मैंने क़सम खाकर उनके बापदादा से किया था।” ");
INSERT INTO urdgvh_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","ऐ इसराईल, अब मेरी बात सुन! रब तेरा ख़ुदा तुझसे क्या तक़ाज़ा करता है? सिर्फ़ यह कि तू उसका ख़ौफ़ माने, उस की तमाम राहों पर चले, उसे प्यार करे, अपने पूरे दिलो-जान से उस की ख़िदमत करे ");
INSERT INTO urdgvh_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","और उसके तमाम अहकाम पर अमल करे। आज मैं उन्हें तुझे तेरी बेहतरी के लिए दे रहा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","पूरा आसमान, ज़मीन और जो कुछ उस पर है, सबका मालिक रब तेरा ख़ुदा है। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","तो भी उसने तेरे बापदादा पर ही अपनी ख़ास शफ़क़त का इज़हार करके उनसे मुहब्बत की। और उसने तुम्हें चुनकर दूसरी तमाम क़ौमों पर तरजीह दी जैसा कि आज ज़ाहिर है। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","ख़तना उस की क़ौम का निशान है, लेकिन ध्यान रखो कि वह न सिर्फ़ ज़ाहिरी बल्कि बातिनी भी हो। आइंदा अड़ न जाओ। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","क्योंकि रब तुम्हारा ख़ुदा ख़ुदाओं का ख़ुदा और रब्बों का रब है। वह अज़ीम और ज़ोरावर ख़ुदा है जिससे सब ख़ौफ़ खाते हैं। वह जानिबदारी नहीं करता और रिश्वत नहीं लेता। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","वह यतीमों और बेवाओं का इनसाफ़ करता है। वह परदेसी से प्यार करता और उसे ख़ुराक और पोशाक मुहैया करता है। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","तुम भी उनके साथ मुहब्बत से पेश आओ, क्योंकि तुम भी मिसर में परदेसी थे। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","रब अपने ख़ुदा का ख़ौफ़ मान और उस की ख़िदमत कर। उससे लिपटा रह और उसी के नाम की क़सम खा। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","वही तेरा फ़ख़र है। वह तेरा ख़ुदा है जिसने वह तमाम अज़ीम और डरावने काम किए जो तूने ख़ुद देखे। ");
INSERT INTO urdgvh_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","जब तेरे बापदादा मिसर गए थे तो 70 अफ़राद थे। और अब रब तेरे ख़ुदा ने तुझे सितारों की मानिंद बेशुमार बना दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","रब अपने ख़ुदा से प्यार कर और हमेशा उसके अहकाम के मुताबिक़ ज़िंदगी गुज़ार। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","आज जान लो कि तुम्हारे बच्चों ने नहीं बल्कि तुम्हीं ने रब अपने ख़ुदा से तरबियत पाई। तुमने उस की अज़मत, बड़े इख़्तियार और क़ुदरत को देखा, ");
INSERT INTO urdgvh_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","और तुम उन मोजिज़ों के गवाह हो जो उसने मिसर के बादशाह फ़िरौन और उसके पूरे मुल्क के सामने किए। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","तुमने देखा कि रब ने किस तरह मिसरी फ़ौज को उसके घोड़ों और रथों समेत बहरे-क़ुलज़ुम में ग़रक़ कर दिया जब वह तुम्हारा ताक़्क़ुब कर रहे थे। उसने उन्हें यों तबाह किया कि वह आज तक बहाल नहीं हुए। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","तुम्हारे बच्चे नहीं बल्कि तुम ही गवाह हो कि यहाँ पहुँचने से पहले रब ने रेगिस्तान में तुम्हारी किस तरह देख-भाल की। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","तुमने उसका इलियाब के बेटों दातन और अबीराम के साथ सुलूक देखा जो रूबिन के क़बीले के थे। उस दिन ज़मीन ने ख़ैमागाह के अंदर मुँह खोलकर उन्हें उनके घरानों, डेरों और तमाम जानदारों समेत हड़प कर लिया। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","तुमने अपनी ही आँखों से रब के यह तमाम अज़ीम काम देखे हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","चुनाँचे उन तमाम अहकाम पर अमल करते रहो जो मैं आज तुम्हें दे रहा हूँ ताकि तुम्हें वह ताक़त हासिल हो जो दरकार होगी जब तुम दरियाए-यरदन को पार करके मुल्क पर क़ब्ज़ा करोगे। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","अगर तुम फ़रमाँबरदार रहो तो देर तक उस मुल्क में जीते रहोगे जिसका वादा रब ने क़सम खाकर तुम्हारे बापदादा से किया था और जिसमें दूध और शहद की कसरत है। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","क्योंकि यह मुल्क मिसर की मानिंद नहीं है जहाँ से तुम निकल आए हो। वहाँ के खेतों में तुझे बीज बोकर बड़ी मेहनत से उस की आबपाशी करनी पड़ती थी ");
INSERT INTO urdgvh_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","जबकि जिस मुल्क पर तुम क़ब्ज़ा करोगे उसमें पहाड़ और वादियाँ हैं जिन्हें सिर्फ़ बारिश का पानी सेराब करता है। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","रब तेरा ख़ुदा ख़ुद उस मुल्क का ख़याल रखता है। रब तेरे ख़ुदा की आँखें साल के पहले दिन से लेकर आख़िर तक मुतवातिर उस पर लगी रहती हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","चुनाँचे उन अहकाम के ताबे रहो जो मैं आज तुम्हें दे रहा हूँ। रब अपने ख़ुदा से प्यार करो और अपने पूरे दिलो-जान से उस की ख़िदमत करो। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","फिर वह ख़रीफ़ और बहार की सालाना बारिश वक़्त पर भेजेगा। अनाज, अंगूर और ज़ैतून की फ़सलें पकेंगी, और तू उन्हें जमा कर लेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","नीज़, अल्लाह तेरी चरागाहों में तेरे रेवड़ों के लिए घास मुहैया करेगा, और तू खाकर सेर हो जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","लेकिन ख़बरदार, कहीं तुम्हें वरग़लाया न जाए। ऐसा न हो कि तुम रब की राह से हट जाओ और दीगर माबूदों को सिजदा करके उनकी ख़िदमत करो। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","वरना रब का ग़ज़ब तुम पर आन पड़ेगा, और वह मुल्क में बारिश होने नहीं देगा। तुम्हारी फ़सलें नहीं पकेंगी, और तुम्हें जल्द ही उस अच्छे मुल्क में से मिटा दिया जाएगा जो रब तुम्हें दे रहा है। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","चुनाँचे मेरी यह बातें अपने दिलों पर नक़्श कर लो। उन्हें निशान के तौर पर और याददिहानी के लिए अपने हाथों और माथों पर लगाओ। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","उन्हें अपने बच्चों को सिखाओ। हर जगह और हमेशा उनके बारे में बात करो, ख़ाह तू घर में बैठा या रास्ते पर चलता हो, लेटा हो या खड़ा हो। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","उन्हें अपने घरों की चौखटों और अपने शहरों के दरवाज़ों पर लिख ");
INSERT INTO urdgvh_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","ताकि जब तक ज़मीन पर आसमान क़ायम है तुम और तुम्हारी औलाद उस मुल्क में जीते रहें जिसका वादा रब ने क़सम खाकर तुम्हारे बापदादा से किया था। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","एहतियात से उन अहकाम की पैरवी करो जो मैं तुम्हें दे रहा हूँ। रब अपने ख़ुदा से प्यार करो, उसके तमाम अहकाम पर अमल करो और उसके साथ लिपटे रहो। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","फिर वह तुम्हारे आगे आगे यह तमाम क़ौमें निकाल देगा और तुम ऐसी क़ौमों की ज़मीनों पर क़ब्ज़ा करोगे जो तुमसे बड़ी और ताक़तवर हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","तुम जहाँ भी क़दम रखोगे वह तुम्हारा ही होगा, जुनूबी रेगिस्तान से लेकर लुबनान तक, दरियाए-फ़ुरात से बहीराए-रूम तक। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","कोई भी तुम्हारा सामना नहीं कर सकेगा। तुम उस मुल्क में जहाँ भी जाओगे वहाँ रब तुम्हारा ख़ुदा अपने वादे के मुताबिक़ तुम्हारी दहशत और ख़ौफ़ पैदा कर देगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","आज तुम ख़ुद फ़ैसला करो। क्या तुम रब की बरकत या उस की लानत पाना चाहते हो? ");
INSERT INTO urdgvh_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","अगर तुम रब अपने ख़ुदा के उन अहकाम पर अमल करो जो मैं आज तुम्हें दे रहा हूँ तो वह तुम्हें बरकत देगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","लेकिन अगर तुम उनके ताबे न रहो बल्कि मेरी पेशकरदा राह से हटकर दीगर माबूदों की पैरवी करो तो वह तुम पर लानत भेजेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","जब रब तेरा ख़ुदा तुझे उस मुल्क में ले जाएगा जिस पर तू क़ब्ज़ा करेगा तो लाज़िम है कि गरिज़ीम पहाड़ पर चढ़कर बरकत का एलान करे और ऐबाल पहाड़ पर लानत का। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","यह दो पहाड़ दरियाए-यरदन के मग़रिब में उन कनानियों के इलाक़े में वाक़े हैं जो वादीए-यरदन में आबाद हैं। वह मग़रिब की तरफ़ जिलजाल शहर के सामने मोरिह के बलूत के दरख़्तों के नज़दीक हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","अब तुम दरियाए-यरदन को पार करके उस मुल्क पर क़ब्ज़ा करनेवाले हो जो रब तुम्हारा ख़ुदा तुम्हें दे रहा है। जब तुम उसे अपनाकर उसमें आबाद हो जाओगे ");
INSERT INTO urdgvh_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","तो एहतियात से उन तमाम अहकाम पर अमल करते रहो जो मैं आज तुम्हें दे रहा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","ज़ैल में वह अहकाम और क़वानीन हैं जिन पर तुम्हें ध्यान से अमल करना होगा जब तुम उस मुल्क में आबाद होगे जो रब तेरे बापदादा का ख़ुदा तुझे दे रहा है ताकि तू उस पर क़ब्ज़ा करे। मुल्क में रहते हुए उम्र-भर उनके ताबे रहो। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","उन तमाम जगहों को बरबाद करो जहाँ वह क़ौमें जिन्हें तुम्हें निकालना है अपने देवताओं की पूजा करती हैं, ख़ाह वह ऊँचे पहाड़ों, पहाड़ियों या घने दरख़्तों के साये में क्यों न हों। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","उनकी क़ुरबानगाहों को ढा देना। जिन पत्थरों की पूजा वह करते हैं उन्हें चकनाचूर कर देना। यसीरत देवी के खंबे जला देना। उनके देवताओं के मुजस्समे काट डालना। ग़रज़ इन जगहों से उनका नामो-निशान मिट जाए। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","रब अपने ख़ुदा की परस्तिश करने के लिए उनके तरीक़े न अपनाना। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","रब तुम्हारा ख़ुदा क़बीलों में से अपने नाम की सुकूनत के लिए एक जगह चुन लेगा। इबादत के लिए वहाँ जाया करो, ");
INSERT INTO urdgvh_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","और वहाँ अपनी तमाम क़ुरबानियाँ लाकर पेश करो, ख़ाह वह भस्म होनेवाली क़ुरबानियाँ, ज़बह की क़ुरबानियाँ, पैदावार का दसवाँ हिस्सा, उठानेवाली क़ुरबानियाँ, मन्नत के हदिये, ख़ुशी से पेश की गई क़ुरबानियाँ या मवेशियों के पहलौठे क्यों न हों। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","वहाँ रब अपने ख़ुदा के हुज़ूर अपने घरानों समेत खाना खाकर उन कामयाबियों की ख़ुशी मनाओ जो तुझे रब तेरे ख़ुदा की बरकत के बाइस हासिल हुई हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","उस वक़्त तुम्हें वह नहीं करना जो हम करते आए हैं। आज तक हर कोई अपनी मरज़ी के मुताबिक़ इबादत करता है, ");
INSERT INTO urdgvh_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","क्योंकि अब तक तुम आराम की उस जगह नहीं पहुँचे जो तुझे रब तेरे ख़ुदा से मीरास में मिलनी है। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","लेकिन जल्द ही तुम दरियाए-यरदन को पार करके उस मुल्क में आबाद हो जाओगे जो रब तुम्हारा ख़ुदा तुम्हें मीरास में दे रहा है। उस वक़्त वह तुम्हें इर्दगिर्द के दुश्मनों से बचाए रखेगा, और तुम आराम और सुकून से ज़िंदगी गुज़ार सकोगे। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","तब रब तुम्हारा ख़ुदा अपने नाम की सुकूनत के लिए एक जगह चुन लेगा, और तुम्हें सब कुछ जो मैं बताऊँगा वहाँ लाकर पेश करना है, ख़ाह वह भस्म होनेवाली क़ुरबानियाँ, ज़बह की क़ुरबानियाँ, पैदावार का दसवाँ हिस्सा, उठानेवाली क़ुरबानियाँ या मन्नत के ख़ास हदिये क्यों न हों। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","वहाँ रब के सामने तुम, तुम्हारे बेटे-बेटियाँ, तुम्हारे ग़ुलाम और लौंडियाँ ख़ुशी मनाएँ। अपने शहरों में आबाद लावियों को भी अपनी ख़ुशी में शरीक करो, क्योंकि उनके पास मौरूसी ज़मीन नहीं होगी। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","ख़बरदार, अपनी भस्म होनेवाली क़ुरबानियाँ हर जगह पर पेश न करना ");
INSERT INTO urdgvh_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","बल्कि सिर्फ़ उस जगह पर जो रब क़बीलों में से चुनेगा। वहीं सब कुछ यों मना जिस तरह मैं तुझे बताता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","लेकिन वह जानवर इसमें शामिल नहीं हैं जो तू क़ुरबानी के तौर पर पेश नहीं करना चाहता बल्कि सिर्फ़ खाना चाहता है। ऐसे जानवर तू आज़ादी से अपने तमाम शहरों में ज़बह करके उस बरकत के मुताबिक़ खा सकता है जो रब तेरे ख़ुदा ने तुझे दी है। ऐसा गोश्त हिरन और ग़ज़ाल के गोश्त की मानिंद है यानी पाक और नापाक दोनों ही उसे खा सकते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","लेकिन ख़ून न खाना। उसे पानी की तरह ज़मीन पर उंडेलकर ज़ाया कर देना। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","जो भी चीज़ें रब के लिए मख़सूस की गई हैं उन्हें अपने शहरों में न खाना मसलन अनाज, अंगूर के रस और ज़ैतून के तेल का दसवाँ हिस्सा, मवेशियों के पहलौठे, मन्नत के हदिये, ख़ुशी से पेश की गई क़ुरबानियाँ और उठानेवाली क़ुरबानियाँ। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","यह चीज़ें सिर्फ़ रब के हुज़ूर खाना यानी उस जगह पर जिसे वह मक़दिस के लिए चुनेगा। वहीं तू अपने बेटे-बेटियों, ग़ुलामों, लौंडियों और अपने क़बायली इलाक़े के लावियों के साथ जमा होकर ख़ुशी मना कि रब ने हमारी मेहनत को बरकत दी है। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","अपने मुल्क में लावियों की ज़रूरियात उम्र-भर पूरी करने की फ़िकर रख। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","जब रब तेरा ख़ुदा अपने वादे के मुताबिक़ तेरी सरहद्दें बढ़ा देगा और तू गोश्त खाने की ख़ाहिश रखेगा तो जिस तरह जी चाहे गोश्त खा सकेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","अगर तेरा घर उस मक़दिस से दूर हो जिसे रब तेरा ख़ुदा अपने नाम की सुकूनत के लिए चुनेगा तो तू जिस तरह जी चाहे अपने शहरों में रब से मिले हुए मवेशियों को ज़बह करके खा सकता है। लेकिन ऐसा ही करना जैसा मैंने हुक्म दिया है। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","ऐसा गोश्त हिरन और ग़ज़ाल के गोश्त की मानिंद है यानी पाक और नापाक दोनों ही उसे खा सकते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","अलबत्ता गोश्त के साथ ख़ून न खाना, क्योंकि ख़ून जानदार की जान है। उस की जान गोश्त के साथ न खाना। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","ख़ून न खाना बल्कि उसे ज़मीन पर उंडेलकर ज़ाया कर देना। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","उसे न खाना ताकि तुझे और तेरी औलाद को कामयाबी हासिल हो, क्योंकि ऐसा करने से तू रब की नज़र में सहीह काम करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","लेकिन जो चीज़ें रब के लिए मख़सूसो-मुक़द्दस हैं या जो तूने मन्नत मानकर उसके लिए मख़सूस की हैं लाज़िम है कि तू उन्हें उस जगह ले जाए जिसे रब मक़दिस के लिए चुनेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","वहीं, रब अपने ख़ुदा की क़ुरबानगाह पर अपनी भस्म होनेवाली क़ुरबानियाँ गोश्त और ख़ून समेत चढ़ा। ज़बह की क़ुरबानियों का ख़ून क़ुरबानगाह पर उंडेल देना, लेकिन उनका गोश्त तू खा सकता है। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","जो भी हिदायात मैं तुझे दे रहा हूँ उन्हें एहतियात से पूरा कर। फिर तू और तेरी औलाद ख़ुशहाल रहेंगे, क्योंकि तू वह कुछ करेगा जो रब तेरे ख़ुदा की नज़र में अच्छा और दुरुस्त है। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","रब तेरा ख़ुदा उन क़ौमों को मिटा देगा जिनकी तरफ़ तू बढ़ रहा है। तू उन्हें उनके मुल्क से निकालता जाएगा और ख़ुद उसमें आबाद हो जाएगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","लेकिन ख़बरदार, उनके ख़त्म होने के बाद भी उनके देवताओं के बारे में मालूमात हासिल न कर, वरना तू फँस जाएगा। मत कहना कि यह क़ौमें किस तरीक़े से अपने देवताओं की पूजा करती हैं? हम भी ऐसा ही करें। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","ऐसा मत कर! यह क़ौमें ऐसे घिनौने तरीक़े से पूजा करती हैं जिनसे रब नफ़रत करता है। वह अपने बच्चों को भी जलाकर अपने देवताओं को पेश करते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","कलाम की जो भी बात मैं तुम्हें पेश करता हूँ उसके ताबे रहकर उस पर अमल करो। न किसी बात का इज़ाफ़ा करना, न कोई बात निकालना। ");
INSERT INTO urdgvh_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","तेरे दरमियान ऐसे लोग उठ खड़े होंगे जो अपने आपको नबी या ख़ाब देखनेवाले कहेंगे। हो सकता है कि वह किसी इलाही निशान या मोजिज़े का एलान करें ");
INSERT INTO urdgvh_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","जो वाक़ई वुजूद में आए। साथ साथ वह कहें, “आ, हम दीगर माबूदों की पूजा करें, हम उनकी ख़िदमत करें जिनसे तू अब तक वाक़िफ़ नहीं है।” ");
INSERT INTO urdgvh_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","ऐसे लोगों की न सुन। इससे रब तुम्हारा ख़ुदा तुम्हें आज़माकर मालूम कर रहा है कि क्या तुम वाक़ई अपने पूरे दिलो-जान से उससे प्यार करते हो। ");
INSERT INTO urdgvh_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","तुम्हें रब अपने ख़ुदा की पैरवी करना और उसी का ख़ौफ़ मानना है। उसके अहकाम के मुताबिक़ ज़िंदगी गुज़ारो, उस की सुनो, उस की ख़िदमत करो, उसके साथ लिपटे रहो। ");
INSERT INTO urdgvh_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","ऐसे नबियों या ख़ाब देखनेवालों को सज़ाए-मौत देना, क्योंकि वह तुझे रब तुम्हारे ख़ुदा से बग़ावत करने पर उकसाना चाहते हैं, उसी से जिसने फ़िद्या देकर तुम्हें मिसर की ग़ुलामी से बचाया और वहाँ से निकाल लाया। चूँकि वह तुझे उस राह से हटाना चाहते हैं जिसे रब तेरे ख़ुदा ने तेरे लिए मुक़र्रर किया है इसलिए लाज़िम है कि उन्हें सज़ाए-मौत दी जाए। ऐसी बुराई अपने दरमियान से मिटा देना। ");
INSERT INTO urdgvh_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","हो सकता है कि तेरा सगा भाई, तेरा बेटा या बेटी, तेरी बीवी या तेरा क़रीबी दोस्त तुझे चुपके से वरग़लाने की कोशिश करे कि आ, हम जाकर दीगर माबूदों की पूजा करें, ऐसे देवताओं की जिनसे न तू और न तेरे बापदादा वाक़िफ़ थे। ");
INSERT INTO urdgvh_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","ख़ाह इर्दगिर्द की या दूर-दराज़ की क़ौमों के देवता हों, ख़ाह दुनिया के एक सिरे के या दूसरे सिरे के माबूद हों, ");
INSERT INTO urdgvh_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","किसी सूरत में अपनी रज़ामंदी का इज़हार न कर, न उस की सुन। उस पर रहम न कर। न उसे बचाए रख, न उसे पनाह दे ");
INSERT INTO urdgvh_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","बल्कि उसे सज़ाए-मौत दे। और उसे संगसार करते वक़्त पहले तेरा हाथ उस पर पत्थर फेंके, फिर ही बाक़ी तमाम लोग हिस्सा लें। ");
INSERT INTO urdgvh_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","उसे ज़रूर पत्थरों से सज़ाए-मौत देना, क्योंकि उसने तुझे रब तेरे ख़ुदा से दूर करने की कोशिश की, उसी से जो तुझे मिसर की ग़ुलामी से निकाल लाया। ");
INSERT INTO urdgvh_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","फिर तमाम इसराईल यह सुनकर डर जाएगा और आइंदा तेरे दरमियान ऐसी शरीर हरकत करने की जुर्रत नहीं करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","जब तू उन शहरों में रहने लगेगा जो रब तेरा ख़ुदा तुझे दे रहा है तो शायद तुझे ख़बर मिल जाए ");
INSERT INTO urdgvh_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","कि शरीर लोग तेरे दरमियान से उभर आए हैं जो अपने शहर के बाशिंदों को यह कहकर ग़लत राह पर लाए हैं कि आओ, हम दीगर माबूदों की पूजा करें, ऐसे माबूदों की जिनसे तुम वाक़िफ़ नहीं हो। ");
INSERT INTO urdgvh_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","लाज़िम है कि तू दरियाफ़्त करके इसकी तफ़तीश करे और ख़ूब मालूम करे कि क्या हुआ है। अगर साबित हो जाए कि यह घिनौनी बात वाक़ई हुई है ");
INSERT INTO urdgvh_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","तो फिर लाज़िम है कि तू शहर के तमाम बाशिंदों को हलाक करे। उसे रब के सुपुर्द करके सरासर तबाह करना, न सिर्फ़ उसके लोग बल्कि उसके मवेशी भी। ");
INSERT INTO urdgvh_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","शहर का पूरा माले-ग़नीमत चौक में इकट्ठा कर। फिर पूरे शहर को उसके माल समेत रब के लिए मख़सूस करके जला देना। उसे दुबारा कभी न तामीर किया जाए बल्कि उसके खंडरात हमेशा तक रहें। ");
INSERT INTO urdgvh_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","पूरा शहर रब के लिए मख़सूस किया गया है, इसलिए उस की कोई भी चीज़ तेरे पास न पाई जाए। सिर्फ़ इस सूरत में रब का ग़ज़ब ठंडा हो जाएगा, और वह तुझ पर रहम करके अपनी मेहरबानी का इज़हार करेगा और तेरी तादाद बढ़ाएगा, जिस तरह उसने क़सम खाकर तेरे बापदादा से वादा किया है। ");
INSERT INTO urdgvh_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","लेकिन यह सब कुछ इस पर मबनी है कि तू रब अपने ख़ुदा की सुने और उसके उन तमाम अहकाम पर अमल करे जो मैं तुझे आज दे रहा हूँ। वही कुछ कर जो उस की नज़र में दुरुस्त है। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","तुम रब अपने ख़ुदा के फ़रज़ंद हो। अपने आपको मुरदों के सबब से न ज़ख़मी करो, न अपने सर के सामनेवाले बाल मुँडवाओ। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","क्योंकि तू रब अपने ख़ुदा के लिए मख़सूसो-मुक़द्दस क़ौम है। दुनिया की तमाम क़ौमों में से रब ने तुझे ही चुनकर अपनी मिलकियत बना लिया है। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","कोई भी मकरूह चीज़ न खाना। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","तुम बैल, भेड़-बकरी, ");
INSERT INTO urdgvh_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","हिरन, ग़ज़ाल, मृग, पहाड़ी बकरी, महात, ग़ज़ाले-अफ़्रीक़ा और पहाड़ी बकरी खा सकते हो। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","जिनके खुर या पाँव बिलकुल चिरे हुए हैं और जो जुगाली करते हैं उन्हें खाने की इजाज़त है। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","ऊँट, बिज्जू या ख़रगोश खाना मना है। वह तुम्हारे लिए नापाक हैं, क्योंकि वह जुगाली तो करते हैं लेकिन उनके खुर या पाँव चिरे हुए नहीं हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","सुअर न खाना। वह तुम्हारे लिए नापाक है, क्योंकि उसके खुर तो चिरे हुए हैं लेकिन वह जुगाली नहीं करता। न उनका गोश्त खाना, न उनकी लाशों को छूना। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","पानी में रहनेवाले जानवर खाने के लिए जायज़ हैं अगर उनके पर और छिलके हों। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","लेकिन जिनके पर या छिलके नहीं हैं वह तुम्हारे लिए नापाक हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","तुम हर पाक परिंदा खा सकते हो। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","लेकिन ज़ैल के परिंदे खाना मना है : उक़ाब, दढ़ियल गिद्ध, काला गिद्ध, ");
INSERT INTO urdgvh_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","लाल चील, काली चील, हर क़िस्म का गिद्ध, ");
INSERT INTO urdgvh_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","हर क़िस्म का कौवा, ");
INSERT INTO urdgvh_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","उक़ाबी उल्लू, छोटे कानवाला उल्लू, बड़े कानवाला उल्लू, हर क़िस्म का बाज़, ");
INSERT INTO urdgvh_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","छोटा उल्लू, चिंघाड़नेवाला उल्लू, सफ़ेद उल्लू, ");
INSERT INTO urdgvh_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","दश्ती उल्लू, मिसरी गिद्ध, क़ूक़, ");
INSERT INTO urdgvh_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","लक़लक़, हर क़िस्म का बूतीमार, हुदहुद और चमगादड़। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","तमाम पर रखनेवाले कीड़े तुम्हारे लिए नापाक हैं। उन्हें खाना मना है। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","लेकिन तुम हर पाक परिंदा खा सकते हो। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","जो जानवर ख़ुद बख़ुद मर जाए उसे न खाना। तू उसे अपनी आबादी में रहनेवाले किसी परदेसी को दे या किसी अजनबी को बेच सकता है और वह उसे खा सकता है। लेकिन तू उसे मत खाना, क्योंकि तू रब अपने ख़ुदा के लिए मख़सूसो-मुक़द्दस क़ौम है। बकरी के बच्चे को उस की माँ के दूध में पकाना मना है। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","लाज़िम है कि तू हर साल अपने खेतों की पैदावार का दसवाँ हिस्सा रब के लिए अलग करे। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","इसके लिए अपना अनाज, अंगूर का रस, ज़ैतून का तेल और मवेशी के पहलौठे रब अपने ख़ुदा के हुज़ूर ले आना यानी उस जगह जो वह अपने नाम की सुकूनत के लिए चुनेगा। वहाँ यह चीज़ें क़ुरबान करके खा ताकि तू उम्र-भर रब अपने ख़ुदा का ख़ौफ़ मानना सीखे। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","लेकिन हो सकता है कि जो जगह रब तेरा ख़ुदा अपने नाम की सुकूनत के लिए चुनेगा वह तेरे घर से हद से ज़्यादा दूर हो और रब तेरे ख़ुदा की बरकत के बाइस मज़कूरा दसवाँ हिस्सा इतना ज़्यादा हो कि तू उसे मक़दिस तक नहीं पहुँचा सकता। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","इस सूरत में उसे बेचकर उसके पैसे उस जगह ले जा जो रब तेरा ख़ुदा अपने नाम की सुकूनत के लिए चुनेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","वहाँ पहुँचकर उन पैसों से जो जी चाहे ख़रीदना, ख़ाह गाय-बैल, भेड़-बकरी, मै या मै जैसी कोई और चीज़ क्यों न हो। फिर अपने घराने के साथ मिलकर रब अपने ख़ुदा के हुज़ूर यह चीज़ें खाना और ख़ुशी मनाना। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","ऐसे मौक़ों पर उन लावियों का ख़याल रखना जो तेरे क़बायली इलाक़े में रहते हैं, क्योंकि उन्हें मीरास में ज़मीन नहीं मिलेगी। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","हर तीसरे साल अपनी पैदावार का दसवाँ हिस्सा अपने शहरों में जमा करना। ");
INSERT INTO urdgvh_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","उसे लावियों को देना जिनके पास मौरूसी ज़मीन नहीं है, नीज़ अपने शहरों में आबाद परदेसियों, यतीमों और बेवाओं को देना। वह आएँ और खाना खाकर सेर हो जाएँ ताकि रब तेरा ख़ुदा तेरे हर काम में बरकत दे। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","हर सात साल के बाद एक दूसरे के कर्ज़े मुआफ़ कर देना। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","उस वक़्त जिसने भी किसी इसराईली भाई को क़र्ज़ दिया है वह उसे मनसूख़ करे। वह अपने पड़ोसी या भाई को पैसे वापस करने पर मजबूर न करे, क्योंकि रब की ताज़ीम में क़र्ज़ मुआफ़ करने के साल का एलान किया गया है। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","इस साल में तू सिर्फ़ ग़ैरमुल्की क़र्ज़दारों को पैसे वापस करने पर मजबूर कर सकता है। अपने इसराईली भाई के तमाम क़र्ज़ मुआफ़ कर देना। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","तेरे दरमियान कोई भी ग़रीब नहीं होना चाहिए, क्योंकि जब तू उस मुल्क में रहेगा जो रब तेरा ख़ुदा तुझे मीरास में देनेवाला है तो वह तुझे बहुत बरकत देगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","लेकिन शर्त यह है कि तू पूरे तौर पर उस की सुने और एहतियात से उसके उन तमाम अहकाम पर अमल करे जो मैं तुझे आज दे रहा हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","फिर रब तुम्हारा ख़ुदा तुझे अपने वादे के मुताबिक़ बरकत देगा। तू किसी भी क़ौम से उधार नहीं लेगा बल्कि बहुत-सी क़ौमों को उधार देगा। कोई भी क़ौम तुझ पर हुकूमत नहीं करेगी बल्कि तू बहुत-सी क़ौमों पर हुकूमत करेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","जब तू उस मुल्क में आबाद होगा जो रब तेरा ख़ुदा तुझे देनेवाला है तो अपने दरमियान रहनेवाले ग़रीब भाई से सख़्त सुलूक न करना, न कंजूस होना। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","खुले दिल से उस की मदद कर। जितनी उसे ज़रूरत है उसे उधार के तौर पर दे। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","ख़बरदार, ऐसा मत सोच कि क़र्ज़ मुआफ़ करने का साल क़रीब है, इसलिए मैं उसे कुछ नहीं दूँगा। अगर तू ऐसी शरीर बात अपने दिल में सोचते हुए ज़रूरतमंद भाई को क़र्ज़ देने से इनकार करे और वह रब के सामने तेरी शिकायत करे तो तू क़ुसूरवार ठहरेगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","उसे ज़रूर कुछ दे बल्कि ख़ुशी से दे। फिर रब तेरा ख़ुदा तेरे हर काम में बरकत देगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","मुल्क में हमेशा ग़रीब और ज़रूरतमंद लोग पाए जाएंगे, इसलिए मैं तुझे हुक्म देता हूँ कि खुले दिल से अपने ग़रीब और ज़रूरतमंद भाइयों की मदद कर। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","अगर कोई इसराईली भाई या बहन अपने आपको बेचकर तेरा ग़ुलाम बन जाए तो वह छः साल तेरी ख़िदमत करे। लेकिन लाज़िम है कि सातवें साल उसे आज़ाद कर दिया जाए। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","आज़ाद करते वक़्त उसे ख़ाली हाथ फ़ारिग़ न करना ");
INSERT INTO urdgvh_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","बल्कि अपनी भेड़-बकरियों, अनाज, तेल और मै से उसे फ़ैयाज़ी से कुछ दे, यानी उन चीज़ों में से जिनसे रब तेरे ख़ुदा ने तुझे बरकत दी है। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","याद रख कि तू भी मिसर में ग़ुलाम था और कि रब तेरे ख़ुदा ने फ़िद्या देकर तुझे छुड़ाया। इसी लिए मैं आज तुझे यह हुक्म देता हूँ। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","लेकिन मुमकिन है कि तेरा ग़ुलाम तुझे छोड़ना न चाहे, क्योंकि वह तुझसे और तेरे ख़ानदान से मुहब्बत रखता है, और वह तेरे पास रहकर ख़ुशहाल है। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","इस सूरत में उसे दरवाज़े के पास ले जा और उसके कान की लौ चौखट के साथ लगाकर उसे सुताली यानी तेज़ औज़ार से छेद दे। तब वह ज़िंदगी-भर तेरा ग़ुलाम बना रहेगा। अपनी लौंडी के साथ भी ऐसा ही करना। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","अगर ग़ुलाम तुझे छः साल के बाद छोड़ना चाहे तो बुरा न मानना। आख़िर अगर उस की जगह कोई और वही काम तनख़ाह के लिए करता तो तेरे अख़राजात दुगने होते। उसे आज़ाद करना तो रब तेरा ख़ुदा तेरे हर काम में बरकत देगा। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","अपनी गायों और भेड़-बकरियों के नर पहलौठे रब अपने ख़ुदा के लिए मख़सूस करना। न गाय के पहलौठे को काम के लिए इस्तेमाल करना, न भेड़ के पहलौठे के बाल कतरना। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","हर साल ऐसे बच्चे उस जगह ले जा जो रब अपने मक़दिस के लिए चुनेगा। वहाँ उन्हें रब अपने ख़ुदा के हुज़ूर अपने पूरे ख़ानदान समेत खाना। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","अगर ऐसे जानवर में कोई ख़राबी हो, वह अंधा या लँगड़ा हो या उसमें कोई और नुक़्स हो तो उसे रब अपने ख़ुदा के लिए क़ुरबान न करना। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","ऐसे जानवर तू घर में ज़बह करके खा सकता है। वह हिरन और ग़ज़ाल की मानिंद हैं जिन्हें तू खा तो सकता है लेकिन क़ुरबानी के तौर पर पेश नहीं कर सकता। पाक और नापाक शख़्स दोनों उसे खा सकते हैं। ");
INSERT INTO urdgvh_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","लेकिन ख़ून न खाना। उसे पानी की तरह ज़मीन पर उंडेलकर ज़ाया कर देना। ");
INSERT INTO urdgvh_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","अबीब के महीने में रब अपने ख़ुदा की ताज़ीम में फ़सह की ईद मनाना, क्योंकि इस महीने में वह तुझे रात के वक़्त मिसर से निकाल लाया। ");
INSERT INTO urdgvh_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","उस जगह जमा हो जा जो रब अपने नाम की सुकूनत के लिए चुनेगा। उसे क़ुरबानी के लिए भेड़-बकरियाँ या गाय-बैल पेश करना। ");
INSERT INTO urdgvh_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","गोश्त के साथ बेख़मीरी रोटी खाना। सात दिन तक यही रोटी खा, बिलकुल उसी तरह जिस तरह तूने किया जब जल्दी जल्दी मिसर से निकला। मुसीबत की यह रोटी इसलिए खा ताकि वह दिन तेरे जीते-जी याद रहे जब तू मिसर से रवाना हुआ। ");
INSERT INTO urdgvh_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","लाज़िम है कि ईद के हफ़ते के दौरान तेरे पूरे मुल्क में ख़मीर न पाया जाए। जो क़ुरबानी तू ईद के पहले दिन की शाम को पेश करे उसका गोश्त उसी वक़्त खा ले। अगली सुबह तक कुछ बाक़ी न रह जाए। ");
INSERT INTO urdgvh_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","फ़सह की क़ुरबानी किसी भी शहर में जो रब तेरा ख़ुदा तुझे देगा न चढ़ाना ");
INSERT INTO urdgvh_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","बल्कि सिर्फ़ उस जगह जो वह अपने नाम की सुकूनत के लिए चुनेगा। मिसर से निकलते वक़्त की तरह क़ुरबानी के जानवर को सूरज डूबते वक़्त ज़बह कर। ");
INSERT INTO urdgvh_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","फिर उसे भूनकर उस जगह खाना जो रब तेरा ख़ुदा चुनेगा। अगली सुबह अपने घर वापस चला जा। ");
INSERT INTO urdgvh_vpl VALUES (