﻿USE sofia;
DROP TABLE IF EXISTS sofia.urd_vpl;
CREATE TABLE urd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES urd_vpl WRITE;
INSERT INTO urd_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ख़ुदा ने सबसे पहले ज़मीन — ओ — आसमान को पैदा किया। ");
INSERT INTO urd_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","और ज़मीन वीरान और सुनसान थी और गहराओ के ऊपर अँधेरा था: और ख़ुदा की रूह पानी की सतह पर जुम्बिश करती थी। ");
INSERT INTO urd_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","और ख़ुदा ने कहा कि रोशनी हो जा, और रोशनी हो गई। ");
INSERT INTO urd_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","और ख़ुदा ने देखा कि रोशनी अच्छी है, और ख़ुदा ने रोशनी को अँधेरे से जुदा किया। ");
INSERT INTO urd_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","और ख़ुदा ने रोशनी को तो दिन कहा और अँधेरे को रात। और शाम हुई और सुबह हुई तब पहला दिन हुआ। ");
INSERT INTO urd_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","और ख़ुदा ने कहा कि पानियों के बीच फ़ज़ा हो ताकि पानी, पानी से जुदा हो जाए। ");
INSERT INTO urd_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","फिर ख़ुदा ने फ़ज़ा को बनाया और फ़ज़ा के नीचे के पानी को फ़ज़ा के ऊपर के पानी से जुदा किया; और ऐसा ही हुआ। ");
INSERT INTO urd_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","और ख़ुदा ने फ़ज़ा को आसमान कहा। और शाम हुई और सुबह हुई — तब दूसरा दिन हुआ। ");
INSERT INTO urd_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","और ख़ुदा ने कहा कि आसमान के नीचे का पानी एक जगह जमा हो कि ख़ुश्की नज़र आए, और ऐसा ही हुआ। ");
INSERT INTO urd_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","और ख़ुदा ने ख़ुश्की को ज़मीन कहा और जो पानी जमा हो गया था उसको समुन्दर; और ख़ुदा ने देखा कि अच्छा है। ");
INSERT INTO urd_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","और ख़ुदा ने कहा कि ज़मीन घास और बीजदार बूटियों को, और फलदार दरख़्तों को जो अपनी — अपनी क़िस्म के मुताबिक़ फलें और जो ज़मीन पर अपने आप ही में बीज रख्खें उगाए और ऐसा ही हुआ। ");
INSERT INTO urd_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","तब ज़मीन ने घास, और बूटियों को, जो अपनी — अपनी क़िस्म के मुताबिक़ बीज रख्खें और फलदार दरख़्तों को जिनके बीज उन की क़िस्म के मुताबिक़ उनमें हैं उगाया; और ख़ुदा ने देखा कि अच्छा है। ");
INSERT INTO urd_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","और शाम हुई और सुबह हुई — तब तीसरा दिन हुआ। ");
INSERT INTO urd_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","और ख़ुदा ने कहा कि फ़लक पर सितारे हों कि दिन को रात से अलग करें; और वह निशान और ज़मानो और दिनों और बरसों के फ़र्क़ के लिए हों। ");
INSERT INTO urd_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","और वह फ़लक पर रोशनी के लिए हों कि ज़मीन पर रोशनी डालें, और ऐसा ही हुआ। ");
INSERT INTO urd_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","फिर ख़ुदा ने दो बड़े चमकदार सितारे बनाए; एक बड़ा चमकदार सितारा, कि दिन पर हुक्म करे और एक छोटा चमकदार सितारा कि रात पर हुक्म करे और उसने सितारों को भी बनाया। ");
INSERT INTO urd_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","और ख़ुदा ने उनको फ़लक पर रख्खा कि ज़मीन पर रोशनी डालें, ");
INSERT INTO urd_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","और दिन पर और रात पर हुक्म करें, और उजाले को अन्धेरे से जुदा करें; और ख़ुदा ने देखा कि अच्छा है। ");
INSERT INTO urd_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","और शाम हुई और सुबह हुई — तब चौथा दिन हुआ। ");
INSERT INTO urd_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","और ख़ुदा ने कहा कि पानी जानदारों को कसरत से पैदा करे, और परिन्दे ज़मीन के ऊपर फ़ज़ा में उड़ें। ");
INSERT INTO urd_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","और ख़ुदा ने बड़े बड़े दरियाई जानवरों को, और हर क़िस्म के जानदार को जो पानी से बकसरत पैदा हुए थे, उनकी क़िस्म के मुताबिक़ और हर क़िस्म के परिन्दों को उनकी क़िस्म के मुताबिक़, पैदा किया; और ख़ुदा ने देखा कि अच्छा है। ");
INSERT INTO urd_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","और ख़ुदा ने उनको यह कह कर बरकत दी कि फलो और बढ़ो और इन समुन्दरों के पानी को भर दो, और परिन्दे ज़मीन पर बहुत बढ़ जाएँ। ");
INSERT INTO urd_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","और शाम हुई और सुबह हुई — तब पाँचवाँ दिन हुआ। ");
INSERT INTO urd_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","और ख़ुदा ने कहा कि ज़मीन जानदारों को, उनकी क़िस्म के मुताबिक़, चौपाये और रेंगनेवाले जानदार और जंगली जानवर उनकी क़िस्म के मुताबिक़ पैदा करे, और ऐसा ही हुआ। ");
INSERT INTO urd_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","और ख़ुदा ने जंगली जानवरों और चौपायों को उनकी क़िस्म के मुताबिक़ और ज़मीन के रेंगने वाले जानदारों को उनकी क़िस्म के मुताबिक़ बनाया; और ख़ुदा ने देखा कि अच्छा है। ");
INSERT INTO urd_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","फिर ख़ुदा ने कहा कि हम इंसान को अपनी सूरत पर अपनी शबीह की तरह बनाएँ और वह समुन्दर की मछलियों और आसमान के परिन्दों और चौपायों, और तमाम ज़मीन और सब जानदारों पर जो ज़मीन पर रेंगते हैं इख़्तियार रख्खें। ");
INSERT INTO urd_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","और ख़ुदा ने इंसान को अपनी सूरत पर पैदा किया ख़ुदा की सूरत पर उसको पैदा किया — नर — ओ — नारी उनको पैदा किया। ");
INSERT INTO urd_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","और ख़ुदा ने उनको बरकत दी और कहा कि फलो और बढ़ो और ज़मीन को भर दो और हुकूमत करो और समुन्दर की मछलियों और हवा के परिन्दों और कुल जानवरों पर जो ज़मीन पर चलते हैं इख़ितयार रख्खो। ");
INSERT INTO urd_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","और ख़ुदा ने कहा कि देखो, मैं तमाम रू — ए — ज़मीन की कुल बीजदार सब्ज़ी और हर दरख़्त जिसमें उसका बीजदार फल हो, तुम को देता हूँ; यह तुम्हारे खाने को हों। ");
INSERT INTO urd_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","और ज़मीन के कुल जानवरों के लिए, और हवा के कुल परिन्दों के लिए और उन सब के लिए जो ज़मीन पर रेंगने वाले हैं जिनमें ज़िन्दगी का दम है, कुल हरी बूटियाँ खाने को देता हूँ, और ऐसा ही हुआ। ");
INSERT INTO urd_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","और ख़ुदा ने सब पर जो उसने बनाया था नज़र की, और देखा कि बहुत अच्छा है, और शाम हुई और सुबह हुई तब छठा दिन हुआ। ");
INSERT INTO urd_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","तब आसमान और ज़मीन और उनके कुल लश्कर का बनाना ख़त्म हुआ। ");
INSERT INTO urd_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","और ख़ुदा ने अपने काम को, जिसे वह करता था सातवें दिन ख़त्म किया, और अपने सारे काम से जिसे वह कर रहा था, सातवें दिन फ़ारिग़ हुआ। ");
INSERT INTO urd_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","और ख़ुदा ने सातवें दिन को बरकत दी, और उसे मुक़द्दस ठहराया; क्यूँकि उसमें ख़ुदा सारी कायनात से जिसे उसने पैदा किया और बनाया फ़ारिग़ हुआ। ");
INSERT INTO urd_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","यह है आसमान और ज़मीन की पैदाइश, जब वह पैदा हुए जिस दिन ख़ुदावन्द ख़ुदा ने ज़मीन और आसमान को बनाया; ");
INSERT INTO urd_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","और ज़मीन पर अब तक खेत का कोई पौधा न था और न मैदान की कोई सब्ज़ी अब तक उगी थी, क्यूँकि ख़ुदावन्द ख़ुदा ने ज़मीन पर पानी नहीं बरसाया था, और न ज़मीन जोतने को कोई इंसान था। ");
INSERT INTO urd_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","बल्कि ज़मीन से कुहर उठती थी, और तमाम रू — ए — ज़मीन को सेराब करती थी। ");
INSERT INTO urd_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","और ख़ुदावन्द ख़ुदा ने ज़मीन की मिट्टी से इंसान को बनाया और उसके नथनों में ज़िन्दगी का दम फूंका इंसान जीती जान हुआ। ");
INSERT INTO urd_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","और ख़ुदावन्द ख़ुदा ने मशरिक़ की तरफ़ अदन में एक बाग़ लगाया और इंसान को जिसे उसने बनाया था वहाँ रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","और ख़ुदावन्द ख़ुदा ने हर दरख़्त को जो देखने में ख़ुशनुमा और खाने के लिए अच्छा था ज़मीन से उगाया और बाग़ के बीच में ज़िन्दगी का दरख़्त और भले और बुरे की पहचान का दरख़्त भी लगाया। ");
INSERT INTO urd_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","और अदन से एक दरिया बाग़ के सेराब करने को निकला और वहाँ से चार नदियों में तक़सीम हुआ। ");
INSERT INTO urd_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","पहली का नाम फ़ैसून है जो हवीला की सारी ज़मीन को जहाँ सोना होता है घेरे हुए है। ");
INSERT INTO urd_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","और इस ज़मीन का सोना चोखा है। और वहाँ मोती और संग-ए-सुलेमानी भी हैं। ");
INSERT INTO urd_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","और दूसरी नदी का नाम जैहून है, जो कूश की सारी ज़मीन को घेरे हुए है। ");
INSERT INTO urd_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","और तीसरी नदी का नाम दिजला है जो असूर के मशरिक़ को जाती है। और चौथी नदी का नाम फ़रात है। ");
INSERT INTO urd_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","और ख़ुदावन्द ख़ुदा ने आदम को लेकर बाग़ — ए — 'अदन में रख्खा के उसकी बाग़वानी और निगहबानी करे। ");
INSERT INTO urd_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","और ख़ुदावन्द ख़ुदा ने आदम को हुक्म दिया और कहा कि तू बाग़ के हर दरख़्त का फल बे रोक टोक खा सकता है। ");
INSERT INTO urd_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","लेकिन भले और बुरे की पहचान के दरख़्त का कभी न खाना क्यूँकि जिस रोज़ तूने उसमें से खायेगा तू मर जायेगा। ");
INSERT INTO urd_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","और ख़ुदावन्द ख़ुदा ने कहा कि आदम का अकेला रहना अच्छा नहीं मैं उसके लिए एक मददगार उसकी तरह बनाऊँगा। ");
INSERT INTO urd_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","और ख़ुदावन्द ख़ुदा ने सब जंगली जानवर और हवा के सब परिन्दे मिट्टी से बनाए और उनको आदम के पास लाया कि देखे कि वह उनके क्या नाम रखता है और आदम ने जिस जानवर को जो कहा वही उसका नाम ठहरा। ");
INSERT INTO urd_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","और आदम ने सब चौपायों और हवा के परिन्दों और सब जंगली जानवरों के नाम रख्खे लेकिन आदम के लिए कोई मददगार उसकी तरह न मिला। ");
INSERT INTO urd_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","और ख़ुदावन्द ख़ुदा ने आदम पर गहरी नींद भेजी और वह सो गया और उसने उसकी पसलियों में से एक को निकाल लिया और उसकी जगह गोश्त भर दिया। ");
INSERT INTO urd_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","और ख़ुदावन्द ख़ुदा उस पसली से जो उसने आदम में से निकाली थी एक 'औरत बना कर उसे आदम के पास लाया। ");
INSERT INTO urd_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","और आदम ने कहा कि यह तो अब मेरी हड्डियों में से हड्डी, और मेरे गोश्त में से गोश्त है; इसलिए वह 'औरत कहलाएगी क्यूँकि वह मर्द से निकाली गई। ");
INSERT INTO urd_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","इसलिए आदमी अपने माँ बाप को छोड़ेगा और अपनी बीवी से मिला रहेगा और वह एक तन होंगे। ");
INSERT INTO urd_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","और आदम और उसकी बीवी दोनों नंगे थे और शरमाते न थे। ");
INSERT INTO urd_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","और साँप सब जंगली जानवरों से, जिनको ख़ुदावन्द ख़ुदा ने बनाया था चालाक था, और उसने 'औरत से कहा क्या वाक़'ई ख़ुदा ने कहा है, कि बाग़ के किसी दरख़्त का फल तुम न खाना? ");
INSERT INTO urd_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","'औरत ने साँप से कहा कि बाग़ के दरख़्तों का फल तो हम खाते हैं। ");
INSERT INTO urd_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","लेकिन जो दरख़्त बाग़ के बीच में है उसके फल के बारे में ख़ुदा ने कहा है कि तुम न तो उसे खाना और न छूना वरना मर जाओगे। ");
INSERT INTO urd_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","तब साँप ने 'औरत से कहा कि तुम हरगिज़ न मरोगे! ");
INSERT INTO urd_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","बल्कि ख़ुदा जानता है कि जिस दिन तुम उसे खाओगे, तुम्हारी आँखें खुल जाएँगी, और तुम ख़ुदा की तरह भले और बुरे के जानने वाले बन जाओगे। ");
INSERT INTO urd_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","'औरत ने जो देखा कि वह दरख़्त खाने के लिए अच्छा और आँखों को ख़ुशनुमा मा'लूम होता है और अक्ल बख़्शने के लिए ख़ूब है तो उसके फल में से लिया और खाया और अपने शौहर को भी दिया और उसने खाया। ");
INSERT INTO urd_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","तब दोनों की आँखें खुल गई और उनको मा'लूम हुआ कि वह नंगे हैं और उन्होंने अंजीर के पत्तों को सी कर अपने लिए लूंगियाँ बनाई। ");
INSERT INTO urd_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","और उन्होंने ख़ुदावन्द ख़ुदा की आवाज़ जो ठंडे वक़्त बाग़ में फिरता था सुनी और आदम और उसकी बीवी ने अपने आप को ख़ुदावन्द ख़ुदा के सामने से बाग़ के दरख़तों में छिपाया। ");
INSERT INTO urd_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","तब ख़ुदावन्द ख़ुदा ने आदम को पुकारा और उससे कहा कि तू कहाँ है? ");
INSERT INTO urd_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","उसने कहा, मैंने बाग़ में तेरी आवाज़ सुनी और मैं डरा क्यूँकि मैं नंगा था और मैंने अपने आप को छिपाया। ");
INSERT INTO urd_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","उसने कहा, तुझे किसने बताया कि तू नंगा है? क्या तूने उस दरख़्त का फल खाया जिसके बारे में मैंने तुझ को हुक्म दिया था कि उसे न खाना? ");
INSERT INTO urd_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","आदम ने कहा कि जिस 'औरत को तूने मेरे साथ किया है उसने मुझे उस दरख़्त का फल दिया और मैंने खाया। ");
INSERT INTO urd_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","तब ख़ुदावन्द ख़ुदा ने, 'औरत से कहा कि तूने यह क्या किया? 'औरत ने कहा कि साँप ने मुझ को बहकाया तो मैंने खाया। ");
INSERT INTO urd_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","और ख़ुदावन्द ख़ुदा ने साँप से कहा, इसलिए कि तूने यह किया तू सब चौपायों और जंगली जानवरों में ला'नती ठहरा; तू अपने पेट के बल चलेगा, और अपनी उम्र भर खाक चाटेगा। ");
INSERT INTO urd_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","और मैं तेरे और 'औरत के बीच और तेरी नसल और औरत की नसल के बीच 'अदावत डालूँगा वह तेरे सिर को कुचलेगा और तू उसकी एड़ी पर काटेगा। ");
INSERT INTO urd_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","फिर उसने 'औरत से कहा कि मैं तेरे दर्द — ए — हम्ल को बहुत बढ़ाऊँगा तू दर्द के साथ बच्चे जनेगी और तेरी रग़बत अपने शौहर की तरफ़ होगी और वह तुझ पर हुकूमत करेगा। ");
INSERT INTO urd_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","और आदम से उसने कहा चूँकि तूने अपनी बीवी की बात मानी और उस दरख़्त का फल खाया जिस के बारे मैंने तुझे हुक्म दिया था कि उसे न खाना इसलिए ज़मीन तेरी वजह से ला'नती हुई। मशक़्क़त के साथ तू अपनी उम्र भर उसकी पैदावार खाएगा ");
INSERT INTO urd_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","और वह तेरे लिए काँटे और ऊँटकटारे उगाएगी और तू खेत की सब्ज़ी खाएगा। ");
INSERT INTO urd_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","तू अपने मुँह के पसीने की रोटी खाएगा जब तक कि ज़मीन में तू फिर लौट न जाए इसलिए कि तू उससे निकाला गया है क्यूँकि तू ख़ाक है और ख़ाक में फिर लौट जाएगा। ");
INSERT INTO urd_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","और आदम ने अपनी बीवी का नाम हव्वा रख्खा, इसलिए कि वह सब ज़िन्दों की माँ है। ");
INSERT INTO urd_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","और ख़ुदावन्द ख़ुदा ने आदम और उसकी बीवी के लिए चमड़े के कुर्तें बना कर उनको पहनाए। ");
INSERT INTO urd_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","और ख़ुदावन्द ख़ुदा ने कहा, देखो इंसान भले और बुरे की पहचान में हम में से एक की तरह हो गया: अब कहीं ऐसा न हो कि वह अपना हाथ बढ़ाए और ज़िन्दगी के दरख़्त से भी कुछ लेकर खाए और हमेशा ज़िन्दा रहे। ");
INSERT INTO urd_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","इसलिए ख़ुदावन्द ख़ुदा ने उसको बाग — ए — 'अदन से बाहर कर दिया, ताकि वह उस ज़मीन की जिसमें से वह लिया गया था, खेती करे। ");
INSERT INTO urd_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","चुनाँचे उसने आदम को निकाल दिया और बाग — ए — 'अदन के मशरिक़ की तरफ़ करूबियों को और चारों तरफ़ घूमने वाली शो'लाज़न तलवार को रख्खा, कि वह ज़िन्दगी के दरख़्त की राह की हिफ़ाज़त करें। ");
INSERT INTO urd_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","और आदम अपनी बीवी हव्वा के पास गया, और वह हामिला हुई और उसके क़ाइन पैदा हुआ। तब उसने कहा, मुझे ख़ुदावन्द से एक फ़र्ज़न्द मिला। ");
INSERT INTO urd_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","फिर क़ाइन का भाई हाबिल पैदा हुआ; और हाबिल भेड़ बकरियों का चरवाहा और क़ाइन किसान था। ");
INSERT INTO urd_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","कुछ दिन के बाद ऐसा हुआ कि क़ाइन अपने खेत के फल का हदिया ख़ुदावन्द के लिए लाया। ");
INSERT INTO urd_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","और हाबिल भी अपनी भेड़ बकरियों के कुछ पहलौठे बच्चों का और कुछ उनकी चर्बी का हदिया लाया। और ख़ुदावन्द ने हाबिल को और उसके हदिये को क़ुबूल किया, ");
INSERT INTO urd_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","लेकिन क़ाइन को और उसके हदिये को क़ुबूल न किया। इसलिए क़ाइन बहुत ग़ुस्सा हुआ और उसका मुँह बिगड़ा। ");
INSERT INTO urd_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","और ख़ुदावन्द ने क़ाइन से कहा, तू क्यूँ ग़ुस्सा हुआ? और तेरा मुँह क्यूँ बिगड़ा हुआ है? ");
INSERT INTO urd_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","अगर तू भला करे तो क्या तू मक़्बूल न होगा? और अगर तू भला न करे तो गुनाह दरवाज़े पर दुबका बैठा है और तेरा मुश्ताक़ है, लेकिन तू उस पर ग़ालिब आ। ");
INSERT INTO urd_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","और क़ाइन ने अपने भाई हाबिल को कुछ कहा और जब वह दोनों खेत में थे तो ऐसा हुआ कि क़ाइन ने अपने भाई हाबिल पर हमला किया और उसे क़त्ल कर डाला। ");
INSERT INTO urd_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","तब ख़ुदावन्द ने क़ाइन से कहा कि तेरा भाई हाबिल कहाँ है? उसने कहा, मुझे मा'लूम नहीं; क्या मैं अपने भाई का मुहाफ़िज़ हूँ? ");
INSERT INTO urd_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","फिर उसने कहा कि तूने यह क्या किया? तेरे भाई का ख़ून ज़मीन से मुझ को पुकारता है। ");
INSERT INTO urd_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","और अब तू ज़मीन की तरफ़ से ला'नती हुआ, जिसने अपना मुँह पसारा कि तेरे हाथ से तेरे भाई का ख़ून ले। ");
INSERT INTO urd_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","जब तू ज़मीन को जोतेगा, तो वह अब तुझे अपनी पैदावार न देगी और ज़मीन पर तू ख़ानाख़राब और आवारा होगा। ");
INSERT INTO urd_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","तब क़ाइन ने ख़ुदावन्द से कहा कि मेरी सज़ा बर्दाश्त से बाहर है। ");
INSERT INTO urd_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","देख, आज तूने मुझे रू — ए — ज़मीन से निकाल दिया है, और मैं तेरे सामने से ग़ायब हो जाऊँगा; और ज़मीन पर खानाख़राब और आवारा रहूँगा, और ऐसा होगा कि जो कोई मुझे पाएगा क़त्ल कर डालेगा। ");
INSERT INTO urd_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","तब ख़ुदावन्द ने उसे कहा, नहीं, बल्कि जो क़ाइन को क़त्ल करे उससे सात गुना बदला लिया जाएगा। और ख़ुदावन्द ने क़ाइन के लिए एक निशान ठहराया कि कोई उसे पा कर मार न डाले। ");
INSERT INTO urd_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","इसलिए, क़ाइन ख़ुदावन्द के सामने से निकल गया और अदन के मशरिक़ की तरफ़ नूद के इलाक़े में जा बसा। ");
INSERT INTO urd_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","और क़ाइन अपनी बीवी के पास गया और वह हामिला हुई और उसके हनूक पैदा हुआ; और उसने एक शहर बसाया और उसका नाम अपने बेटे के नाम पर हनूक रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","और हनूक से ईराद पैदा हुआ, और ईराद से महुयाएल पैदा हुआ, और महुयाएल से मतूसाएल पैदा हुआ, और मत्तूसाएल से लमक पैदा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","और लमक दो औरतें ब्याह लाया: एक का नाम अदा और दूसरी का नाम ज़िल्ला था। ");
INSERT INTO urd_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","और अदा के याबल पैदा हुआ: वह उनका बाप था जो ख़ेमों में रहते और जानवर पालते हैं। ");
INSERT INTO urd_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","और उसके भाई का नाम यूबल था: वह बीन और बांसली बजाने वालों का बाप था। ");
INSERT INTO urd_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","और ज़िल्ला के भी तूबलक़ाइन पैदा हुआ: जो पीतल और लोहे के सब तेज़ हथियारों का बनाने वाला था; और नामा तूबलक़ाइन की बहन थी। ");
INSERT INTO urd_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","और लमक ने अपनी बीवियों से कहा कि ऐ अदा और ज़िल्ला मेरी बात सुनो; ऐ लमक की बीवियो, मेरी बात पर कान लगाओ: मैंने एक आदमी को जिसने मुझे ज़ख़्मी किया, मार डाला। और एक जवान को जिसने मेरे चोट लगाई, क़त्ल कर डाला। ");
INSERT INTO urd_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","अगर क़ाइन का बदला सात गुना लिया जाएगा, तो लमक का सत्तर और सात गुना। ");
INSERT INTO urd_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","और आदम फिर अपनी बीवी के पास गया और उसके एक और बेटा हुआ और उसका नाम सेत रख्खा: और वह कहने लगी कि ख़ुदा ने हाबिल के बदले जिसको क़ाइन ने क़त्ल किया, मुझे दूसरा फ़र्ज़न्द दिया। ");
INSERT INTO urd_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","और सेत के यहाँ भी एक बेटा पैदा हुआ, जिसका नाम उसने अनूस रख्खा; उस वक़्त से लोग यहोवा का नाम लेकर दुआ करने लगे। ");
INSERT INTO urd_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","यह आदम का नसबनामा है। जिस दिन ख़ुदा ने आदम को पैदा किया; तो उसे अपनी शबीह पर बनाया। ");
INSERT INTO urd_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","मर्द और औरत उनको पैदा किया और उनको बरकत दी, और जिस दिन वह पैदा हुए उनका नाम आदम रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","और आदम एक सौ तीस साल का था जब उसकी सूरत — ओ — शबीह का एक बेटा उसके यहाँ पैदा हुआ; और उसने उसका नाम सेत रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","और सेत की पैदाइश के बाद आदम आठ सौ साल ज़िन्दा रहा, और उससे बेटे और बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","और आदम की कुल उम्र नौ सौ तीस साल की हुई, तब वह मरा। ");
INSERT INTO urd_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","और सेत एक सौ पाँच साल का था जब उससे अनूस पैदा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","और अनूस की पैदाइश के बाद सेत आठ सौ सात साल ज़िन्दा रहा, और उससे बेटे और बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","और सेत की कुल उम्र नौ सौ बारह साल की हुई, तब वह मरा। ");
INSERT INTO urd_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","और अनूस नव्वे साल का था जब उससे क़ीनान पैदा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","और क़ीनान की पैदाइश के बाद अनूस आठ सौ पन्द्रह साल ज़िन्दा रहा, और उससे बेटे और बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","और अनूस की कुल उम्र नौ सौ पाँच साल की हुई, तब वह मरा। ");
INSERT INTO urd_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","और क़ीनान सत्तर साल का था जब उससे महललेल पैदा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","और महललेल की पैदाइश के बाद क़ीनान आठ सौ चालीस साल ज़िन्दा रहाऔर उससे बेटे और बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","और क़ीनान की कुल उम्र नौ सौ दस साल की हुई, तब वह मरा। ");
INSERT INTO urd_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","और महललेल पैंसठ साल का था जब उससे यारिद पैदा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","और यारिद की पैदाइश के बाद महललेल आठ सौ तीस साल ज़िन्दा रहा, और उससे बेटे और बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","और महललेल की कुल उम्र आठ सौ पचानवे साल की हुई, तब वह मरा। ");
INSERT INTO urd_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","और यारिद एक सौ बासठ साल का था जब उससे हनूक पैदा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","और हनूक की पैदाइश के बाद यारिद आठ सौ साल ज़िन्दा रहा, और उससे बेटे और बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","और यारिद की कुल उम्र नौ सौ बासठ साल की हुई, तब वह मरा। ");
INSERT INTO urd_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","और हनूक पैंसठ साल का था उससे मतुसिलह पैदा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","और मतूसिलह की पैदाइश के बाद हनूक तीन सौ साल तक ख़ुदा के साथ — साथ चलता रहा, और उससे बेटे और बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","और हनूक की कुल उम्र तीन सौ पैंसठ साल की हुई। ");
INSERT INTO urd_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","और हनूक ख़ुदा के साथ — साथ चलता रहा, और वह ग़ायब हो गया क्यूँकि ख़ुदा ने उसे उठा लिया। ");
INSERT INTO urd_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","और मतूसिलह एक सौ सतासी साल का था जब उससे लमक पैदा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","और लमक की पैदाइश के बाद मतूसिलह सात सौ बयासी साल ज़िन्दा रहा, और उससे बेटे और बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","और मतूसिलह की कुल उम्र नौ सौ उनहत्तर साल की हुई, तब वह मरा। ");
INSERT INTO urd_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","और लमक एक सौ बयासी साल का था जब उससे एक बेटा पैदा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","और उसने उसका नाम नूह रख्खा और कहा, कि यह हमारे हाथों की मेहनत और मशक़्क़त से जो ज़मीन की वजह से है जिस पर ख़ुदा ने ला'नत की है, हमें आराम देगा। ");
INSERT INTO urd_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","और नूह की पैदाइश के बाद लमक पाँच सौ पंचानवे साल ज़िन्दा रहा, और उससे बेटे और बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","और लमक की कुल उम्र सात सौ सत्तर साल की हुई, तब वह मरा। ");
INSERT INTO urd_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","और नूह पाँच सौ साल का था, जब उससे सिम, हाम और याफ़त, पैदा हुए। ");
INSERT INTO urd_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","जब रु — ए — ज़मीन पर आदमी बहुत बढ़ने लगे और उनके बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","तो ख़ुदा के बेटों ने आदमी की बेटियों को देखा कि वह ख़ूबसूरत हैं; और जिनको उन्होंने चुना उनसे ब्याह कर लिया। ");
INSERT INTO urd_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","तब ख़ुदावन्द ने कहा कि मेरी रूह इंसान के साथ हमेशा मुज़ाहमत न करती रहेगी। क्यूँकि वह भी तो इंसान है; तो भी उसकी उम्र एक सौ बीस साल की होगी। ");
INSERT INTO urd_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","उन दिनों में ज़मीन पर जब्बार थे, और बाद में जब ख़ुदा के बेटे इंसान की बेटियों के पास गए, तो उनके लिए उनसे औलाद हुई। यही पुराने ज़माने के सूर्मा हैं, जो बड़े नामवर हुए हैं। ");
INSERT INTO urd_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","और ख़ुदावन्द ने देखा कि ज़मीन पर इंसान की बदी बहुत बढ़ गई, और उसके दिल के तसव्वुर और ख़याल हमेशा बुरे ही होते हैं। ");
INSERT INTO urd_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","तब ख़ुदावन्द ज़मीन पर इंसान के पैदा करने से दुखी हुआ और दिल में ग़म किया। ");
INSERT INTO urd_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","और ख़ुदावन्द ने कहा कि मैं इंसान को जिसे मैंने पैदा किया, रू — ए — ज़मीन पर से मिटा डालूँगा; इंसान से लेकर हैवान और रेंगनेवाले जानदार और हवा के परिन्दों तक; क्यूँकि मैं उनके बनाने से दुखी हूँ। ");
INSERT INTO urd_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","मगर नूह ख़ुदावन्द की नज़र में मक़्बूल हुआ। ");
INSERT INTO urd_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","नूह का नसबनामा यह है: नूह मर्द — ए — रास्तबाज़ और अपने ज़माने के लोगों में बे'ऐब था, और नूह ख़ुदा के साथ — साथ चलता रहा। ");
INSERT INTO urd_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","और उससे तीन बेटे सिम, हाम और याफ़त पैदा हुए। ");
INSERT INTO urd_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","लेकिन ज़मीन ख़ुदा के आगे नापाक हो गई थी, और वह ज़ुल्म से भरी थी। ");
INSERT INTO urd_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","और ख़ुदा ने ज़मीन पर नज़र की और देखा, कि वह नापाक हो गई है; क्यूँकि हर इंसान ने ज़मीन पर अपना तरीक़ा बिगाड़ लिया था। ");
INSERT INTO urd_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","और ख़ुदा ने नूह से कहा कि पूरे इंसान का ख़ातिमा मेरे सामने आ पहुँचा है; क्यूँकि उनकी वजह से ज़मीन जुल्म से भर गई, इसलिए देख, मैं ज़मीन के साथ उनको हलाक करूँगा। ");
INSERT INTO urd_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","तू गोफर की लकड़ी की एक कश्ती अपने लिए बना; उस कश्ती में कोठरियाँ तैयार करना और उसके अन्दर और बाहर राल लगाना। ");
INSERT INTO urd_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","और ऐसा करना कि कश्ती की लम्बाई तीन सौ हाथ, उसकी चौड़ाई पचास हाथ और उसकी ऊँचाई तीस हाथ हो। ");
INSERT INTO urd_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","और उस कश्ती में एक रौशनदान बनाना, और ऊपर से हाथ भर छोड़ कर उसे ख़त्म कर देना; और उस कश्ती का दरवाज़ा उसके पहलू में रखना; और उसमें तीन हिस्से बनाना निचला, दूसरा और तीसरा। ");
INSERT INTO urd_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","और देख, मैं ख़ुद ज़मीन पर पानी का तूफ़ान लानेवाला हूँ, ताकि हर इंसान को जिसमें जिन्दगी की साँस है, दुनिया से हलाक कर डालूँ, और सब जो ज़मीन पर हैं मर जाएँगे। ");
INSERT INTO urd_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","लेकिन तेरे साथ मैं अपना 'अहद क़ाईम करूँगा; और तू कश्ती में जाना — तू और तेरे साथ तेरे बेटे और तेरी बीवी और तेरे बेटों की बीवियाँ। ");
INSERT INTO urd_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","और जानवरों की हर क़िस्म में से दो — दो अपने साथ कश्ती में ले लेना, कि वह तेरे साथ जीते बचें, वह नर — ओ — मादा हों। ");
INSERT INTO urd_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","और परिन्दों की हर क़िस्म में से, और चरिन्दों की हर क़िस्म में से, और ज़मीन पर रेंगने वालों की हर क़िस्म में से दो दो तेरे पास आएँ, ताकि वह जीते बचें। ");
INSERT INTO urd_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","और तू हर तरह की खाने की चीज़ लेकर अपने पास जमा' कर लेना, क्यूँकि यही तेरे और उनके खाने को होगा। ");
INSERT INTO urd_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","और नूह ने ऐसा ही किया; जैसा ख़ुदा ने उसे हुक्म दिया था, वैसा ही 'अमल किया। ");
INSERT INTO urd_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","और ख़ुदावन्द ने नूह से कहा कि तू अपने पूरे ख़ान्दान के साथ कश्ती में आ; क्यूँकि मैंने तुझी को अपने सामने इस ज़माना में रास्तबाज़ देखा है। ");
INSERT INTO urd_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","सब पाक जानवरों में से सात — सात, नर और उनकी मादा; और उनमें से जो पाक नहीं हैं दो — दो, नर और उनकी मादा अपने साथ ले लेना। ");
INSERT INTO urd_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","और हवा के परिन्दों में से भी सात — सात, नर और मादा, लेना ताकि ज़मीन पर उनकी नसल बाक़ी रहे। ");
INSERT INTO urd_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","क्यूँकि सात दिन के बाद मैं ज़मीन पर चालीस दिन और चालीस रात पानी बरसाऊंगा, और हर जानदार शय को जिसे मैंने बनाया ज़मीन पर से मिटा डालूँगा। ");
INSERT INTO urd_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","और नूह ने वह सब जैसा ख़ुदावन्द ने उसे हुक्म दिया था किया। ");
INSERT INTO urd_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","और नूह छ: सौ साल का था, जब पानी का तूफ़ान ज़मीन पर आया। ");
INSERT INTO urd_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","तब नूह और उसके बेटे और उसकी बीवी, और उसके बेटों की बीवियाँ, उसके साथ तूफ़ान के पानी से बचने के लिए कश्ती में गए। ");
INSERT INTO urd_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","और पाक जानवरों में से और उन जानवरों में से जो पाक नहीं, और परिन्दों में से और ज़मीन पर के हर रेंगनेवाले जानदार में से ");
INSERT INTO urd_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","दो — दो, नर और मादा, कश्ती में नूह के पास गए, जैसा ख़ुदा ने नूह को हुक्म दिया था। ");
INSERT INTO urd_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","और सात दिन के बाद ऐसा हुआ कि तूफ़ान का पानी ज़मीन पर आ गया। ");
INSERT INTO urd_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","नूह की उम्र का छ: सौवां साल था, कि उसके दूसरे महीने के ठीक सत्रहवीं तारीख़ को बड़े समुन्दर के सब सोते फूट निकले और आसमान की खिड़कियाँ खुल गई। ");
INSERT INTO urd_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","और चालीस दिन और चालीस रात ज़मीन पर बारिश होती रही। ");
INSERT INTO urd_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","उसी दिन नूह और नूह के बेटे सिम और हाम और याफ़त, और ");
INSERT INTO urd_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","और हर क़िस्म का जानवर और हर क़िस्म का चौपाया और हर क़िस्म का ज़मीन पर का रेंगने वाला जानदार और हर क़िस्म का परिन्दा और हर क़िस्म की चिड़िया, यह सब कश्ती में दाख़िल हुए। ");
INSERT INTO urd_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","और जो ज़िन्दगी का दम रखते हैं उनमें से दो — दो कश्ती में नूह के पास आए। ");
INSERT INTO urd_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","और जो अन्दर आए वो, जैसा ख़ुदा ने उसे हुक्म दिया था, सब जानवरों के नर — ओ — मादा थे। तब ख़ुदावन्द ने उसको बाहर से बन्द कर दिया। ");
INSERT INTO urd_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","और चालीस दिन तक ज़मीन पर तूफ़ान रहा, और पानी बढ़ा और उसने कश्ती को ऊपर उठा दिया; तब कश्ती ज़मीन पर से उठ गई। ");
INSERT INTO urd_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","और पानी ज़मीन पर चढ़ता ही गया और बहुत बढ़ा और कश्ती पानी के ऊपर तैरती रही। ");
INSERT INTO urd_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","और पानी ज़मीन पर बहुत ही ज़्यादा चढ़ा और सब ऊँचे पहाड़ जो दुनिया में हैं छिप गए। ");
INSERT INTO urd_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","पानी उनसे पंद्रह हाथ और ऊपर चढ़ा और पहाड़ डूब गए। ");
INSERT INTO urd_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","और सब जानवर जो ज़मीन पर चलते थे, परिन्दे और चौपाए और जंगली जानवर और ज़मीन पर के सब रेंगनेवाले जानदार, और सब आदमी मर गए। ");
INSERT INTO urd_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","और ख़ुश्की के सब जानदार जिनके नथनों में ज़िन्दगी का दम था मर गए। ");
INSERT INTO urd_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","बल्कि हर जानदार शय जो इस ज़मीन पर थी मर मिटी — क्या इंसान क्या हैवान क्या रेंगने वाले जानदार क्या हवा का परिन्दा, यह सब के सब ज़मीन पर से मर मिटे। सिर्फ़ एक नूह बाक़ी बचा, या वह जो उसके साथ कश्ती में थे। ");
INSERT INTO urd_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","और पानी ज़मीन पर एक सौ पचास दिन तक बढ़ता रहा। ");
INSERT INTO urd_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","फिर ख़ुदा ने नूह को और सब जानदार और सब चौपायों को जो उसके साथ कश्ती में थे याद किया; और ख़ुदा ने ज़मीन पर एक हवा चलाई और पानी रुक गया। ");
INSERT INTO urd_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","और समुन्दर के सोते और आसमान के दरीचे बन्द किए गए, और आसमान से जो बारिश हो रही थी थम गई; ");
INSERT INTO urd_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","और पानी ज़मीन पर से घटते — घटते एक सौ पचास दिन के बाद कम हुआ। ");
INSERT INTO urd_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","और सातवें महीने की सत्रहवीं तारीख़ को कश्ती अरारात के पहाड़ों पर टिक गई। ");
INSERT INTO urd_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","और पानी दसवें महीने तक बराबर घटता रहा, और दसवें महीने की पहली तारीख़ को पहाड़ों की चोटियाँ नज़र आई। ");
INSERT INTO urd_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","और चालीस दिन के बाद ऐसा हुआ, कि नूह ने कश्ती की खिड़की जो उसने बनाई थी खोली, ");
INSERT INTO urd_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","और उसने एक कौवे को उड़ा दिया; इसलिए वह निकला और जब तक कि ज़मीन पर से पानी सूख न गया इधर उधर फिरता रहा। ");
INSERT INTO urd_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","फिर उसने एक कबूतरी अपने पास से उड़ा दी, ताकि देखे, कि ज़मीन पर पानी घटा या नहीं। ");
INSERT INTO urd_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","लेकिन कबूतरी ने पंजा टेकने की जगह न पाई और उसके पास कश्ती को लौट आई, क्यूँकि तमाम रू — ए — ज़मीन पर पानी था। तब उसने हाथ बढ़ाकर उसे ले लिया और अपने पास कश्ती में रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","और सात दिन ठहर कर उसने उस कबूतरी को फिर कश्ती से उड़ा दिया; ");
INSERT INTO urd_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","और वह कबूतरी शाम के वक़्त उसके पास लौट आई, और देखा तो जैतून की एक ताज़ा पत्ती उसकी चोंच में थी। तब नूह ने मा'लूम किया कि पानी ज़मीन पर से कम हो गया। ");
INSERT INTO urd_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","तब वह सात दिन और ठहरा, इसके बाद फिर उस कबूतरी को उड़ाया, लेकिन वह उसके पास फिर कभी न लौटी। ");
INSERT INTO urd_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","और छ: सौ पहले साल के पहले महीने की पहली तारीख़ को ऐसा हुआ, कि ज़मीन पर से पानी सूख गया; और नूह ने कश्ती की छत खोली और देखा कि ज़मीन की सतह सूख गई है। ");
INSERT INTO urd_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","और दूसरे महीने की सताईस्वीं तारीख़ को ज़मीन बिल्कुल सूख गई। ");
INSERT INTO urd_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","तब ख़ुदा ने नूह से कहा कि ");
INSERT INTO urd_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","कश्ती से बाहर निकल आ; तू और तेरे साथ तेरी बीवी और तेरे बेटे और तेरे बेटों की बीवियाँ। ");
INSERT INTO urd_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","और उन जानदारों को भी बाहर निकाल ला जो तेरे साथ हैं: क्या परिन्दे, क्या चौपाये, क्या ज़मीन के रेंगनेवाले जानदार; ताकि वह ज़मीन पर कसरत से बच्चे दें और फल दायक हों और ज़मीन पर बढ़ जाएँ। ");
INSERT INTO urd_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","तब नूह अपनी बीवी और अपने बेटों और अपने बेटों की बीवियों के साथ बाहर निकला। ");
INSERT INTO urd_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","और सब जानवर, सब रेंगनेवाले जानदार, सब परिन्दे और सब जो ज़मीन पर चलते हैं, अपनी अपनी क़िस्म के साथ कश्ती से निकल गए। ");
INSERT INTO urd_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","तब नूह ने ख़ुदावन्द के लिए एक मज़बह बनाया; और सब पाक चौपायों और पाक परिन्दों में से थोड़े से लेकर उस मज़बह पर सोख़्तनी क़ुर्बानियाँ पेश कीं। ");
INSERT INTO urd_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","और ख़ुदावन्द ने उसकी राहत अंगेज़ ख़ुशबू ली, और ख़ुदावन्द ने अपने दिल में कहा कि इंसान की वजह से मैं फिर कभी ज़मीन पर ला'नत नहीं भेजूँगा, क्यूँकि इंसान के दिल का ख़्याल लड़कपन से बुरा है; और न फिर सब जानदारों को जैसा अब किया है, मारूँगा। ");
INSERT INTO urd_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","बल्कि जब तक ज़मीन क़ाईम है बीज बोना और फ़सल कटना, सर्दी और तपिश, गर्मी और जाड़ा और रात ख़त्म न होंगे। ");
INSERT INTO urd_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","और ख़ुदा ने नूह और उसके बेटों को बरकत दी और उनको कहा कि फ़ायदेमन्द हो और बढ़ो और ज़मीन को भर दो। ");
INSERT INTO urd_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","और ज़मीन के सब जानदारों और हवा के सब परिन्दों पर तुम्हारी दहशत और तुम्हारा रौब होगा; यह और तमाम कीड़े जिन से ज़मीन भरी पड़ी है, और समुन्दर की कुल मछलियाँ तुम्हारे क़ब्ज़े में की गई। ");
INSERT INTO urd_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","हर चलता फिरता जानदार तुम्हारे खाने को होगा; हरी सब्ज़ी की तरह मैंने सबका सब तुम को दे दिया ");
INSERT INTO urd_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","मगर तुम गोश्त के साथ खू़न को, जो उसकी जान है न खाना। ");
INSERT INTO urd_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","मैं तुम्हारे खू़न का बदला ज़रूर लुँगा, हर जानवर से उसका बदला लूँगा; आदमी की जान का बदला आदमी से और उसके भाई बन्द से लुँगा। ");
INSERT INTO urd_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","जो आदमी का खू़न करे उसका खू़न आदमी से होगा, क्यूँकि ख़ुदा ने इंसान को अपनी सूरत पर बनाया है। ");
INSERT INTO urd_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","और तुम फल दायक हो और बढ़ो और ज़मीन पर खू़ब अपनी नसल बढ़ाओ, और बहुत ज़्यादा हो जाओ। ");
INSERT INTO urd_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","और ख़ुदा ने नूह और उसके बेटों से कहा, ");
INSERT INTO urd_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","देखो, मैं खुद तुमसे और तुम्हारे बाद तुम्हारी नसल से, ");
INSERT INTO urd_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","और सब जानदारों से जो तुम्हारे साथ हैं, क्या परिन्दे क्या चौपाए क्या ज़मीन के जानवर, या'नी ज़मीन के उन सब जानवरों के बारे में जो कश्ती से उतरे, 'अहद करता हूँ ");
INSERT INTO urd_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","मैं इस 'अहद को तुम्हारे साथ क़ाईम रखूँगा कि सब जानदार तूफ़ान के पानी से फिर हलाक न होंगे, और न कभी ज़मीन को तबाह करने के लिए फिर तूफ़ान आएगा ");
INSERT INTO urd_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","और ख़ुदा ने कहा कि जो अहद मैंने अपने और तुम्हारे बीच और सब जानदारों के बीच जो तुम्हारे साथ हैं, नसल — दर — नसल हमेशा के लिए करता हूँ, उसका निशान यह है कि ");
INSERT INTO urd_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","मैं अपनी कमान को बादल में रखता हूँ, वह मेरे और ज़मीन के बीच 'अहद का निशान होगी ");
INSERT INTO urd_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","और ऐसा होगा कि जब मैं ज़मीन पर बादल लाऊँगा, तो मेरी कमान बादल में दिखाई देगी। ");
INSERT INTO urd_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","और मैं अपने 'अहद को, जो मेरे और तुम्हारे और हर तरह के जानदार के बीच है, याद करूँगा; और तमाम जानदारों की हलाकत के लिए पानी का तूफ़ान फिर न होगा। ");
INSERT INTO urd_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","और कमान बादल में होगी और मैं उस पर निगाह करूँगा, ताकि उस अबदी 'अहद को याद करूँ जो ख़ुदा के और ज़मीन के सब तरह के जानदार के बीच है। ");
INSERT INTO urd_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","तब ख़ुदा ने नूह से कहा कि यह उस 'अहद का निशान है जो मैं अपने और ज़मीन के कुल जानदारों के बीच क़ाईम करता हूँ। ");
INSERT INTO urd_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","नूह के बेटे जो कश्ती से निकले, सिम, हाम और याफ़त थे और हाम कनान का बाप था। ");
INSERT INTO urd_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","यही तीनों नूह के बेटे थे और इन्हीं की नसल सारी ज़मीन फैली। ");
INSERT INTO urd_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","और नूह काश्तकारी करने लगा और उसने एक अँगूर का बाग़ लगाया। ");
INSERT INTO urd_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","और उसने उसकी मय पी और उसे नशा आया और वह अपने डेरे में नंगा हो गया। ");
INSERT INTO urd_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","और कनान के बाप हाम ने अपने बाप को नंगा देखा, और अपने दोनों भाइयों को बाहर आ कर ख़बर दी। ");
INSERT INTO urd_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","तब सिम और याफ़त ने एक कपड़ा लिया और उसे अपने कन्धों पर धरा, और पीछे को उल्टे चल कर गए और अपने बाप की नंगे पन को ढाँका, इसलिए उनके मुँह उल्टी तरफ़ थे और उन्होंने अपने बाप की नंगे पन को न देखा। ");
INSERT INTO urd_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","जब नूह अपनी मय के नशे से होश में आया, तो जो उसके छोटे बेटे ने उसके साथ किया था उसे मा'लूम हुआ। ");
INSERT INTO urd_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","और उसने कहा कि कनान मल'ऊन हो, वह अपने भाइयों के गु़लामों का ग़ुलाम होगा ");
INSERT INTO urd_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","फिर कहा, ख़ुदावन्द सिम का ख़ुदा मुबारक हो, और कनान सिम का ग़ुलाम हो। ");
INSERT INTO urd_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ख़ुदा याफ़त को फैलाए, कि वह सिम के डेरों में बसे, और कनान उसका गु़लाम ");
INSERT INTO urd_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","और तूफ़ान के बाद नूह साढ़े तीन सौ साल और ज़िन्दा रहा। ");
INSERT INTO urd_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","और नूह की कुल उम्र साढ़े नौ सौ साल की हुई। तब उसने वफ़ात पाई। ");
INSERT INTO urd_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","नूह के बेटों सिम, हाम और याफ़त की औलाद यह हैं। तूफान के बाद उनके यहाँ बेटे पैदा हुए। ");
INSERT INTO urd_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","बनी याफ़त यह हैं: जुमर और माजूज और मादी, और यावान और तूबल और मसक और तीरास। ");
INSERT INTO urd_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","और जुमर के बेटे: अशकनाज़ और रीफ़त और तुजरमा। ");
INSERT INTO urd_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","और यावान के बेटे: इलिसा और तरसीस, किती और दोदानी। ");
INSERT INTO urd_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","क़ौमों के जज़ीरे इन्हीं की नसल में बट कर, हर एक की ज़बान और क़बीले के मुताबिक़ मुख़तलिफ़ मुल्क और गिरोह हो गए। ");
INSERT INTO urd_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","और बनी हाम यह हैं: कूश और मिस्र और फ़ूत और कना'न। ");
INSERT INTO urd_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","और बनी कूश यह हैं। सबा और हवीला और सबता और रा'मा और सब्तीका। और बनी रा'मा यह हैं: सबा और ददान। ");
INSERT INTO urd_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","और कूश से नमरूद पैदा हुआ। वह रू — ए — ज़मीन पर एक सूर्मा हुआ है। ");
INSERT INTO urd_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ख़ुदावन्द के सामने वह एक शिकारी सूर्मा हुआ है, इसलिए यह मसल चली कि, “ख़ुदावन्द के सामने नमरूद सा शिकारी सूर्मा।” ");
INSERT INTO urd_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","और उस की बादशाही का पहला मुल्क सिन'आर में बाबुल और अरक और अक्काद और कलना से हुई। ");
INSERT INTO urd_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","उसी मुल्क से निकल कर वह असूर में आया, और नीनवा और रहोबोत ईर और कलह को, ");
INSERT INTO urd_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","और नीनवा और कलह के बीच रसन को, जो बड़ा शहर है बनाया। ");
INSERT INTO urd_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","और मिस्र से लूदी और अनामी और लिहाबी और नफ़तूही ");
INSERT INTO urd_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","और फ़तरूसी और कसलूही जिनसे फ़िलिस्ती निकले और कफ़तूरी पैदा हुए। ");
INSERT INTO urd_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","और कनान से सैदा जो उसका पहलौठा था, और हित, ");
INSERT INTO urd_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","और यबूसी और अमोरी और जिरजासी, ");
INSERT INTO urd_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","और हव्वी और अरकी और सीनी, ");
INSERT INTO urd_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","और अरवादी और समारी और हमाती पैदा हुए; और बाद में कना'नी क़बीले फैल गए। ");
INSERT INTO urd_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","और कना'नियों की हद यह है: सैदा से ग़ज़्ज़ा तक जो जिरार के रास्ते पर है, फिर वहाँ से लसा' तक जो सदूम और 'अमूरा और अदमा और ज़िबयान की राह पर है। ");
INSERT INTO urd_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","इसलिए बनी हाम यह हैं, जो अपने — अपने मुल्क और गिरोहों में अपने क़बीलों और अपनी ज़बानों के मुताबिक़ आबाद हैं। ");
INSERT INTO urd_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","और सिम के यहाँ भी जो तमाम बनी इब्र का बाप और याफ़त का बड़ा भाई था, औलाद हुई। ");
INSERT INTO urd_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","और बनी सिम यह हैं: ऐलाम और असुर और अरफ़कसद और लुद और आराम। ");
INSERT INTO urd_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","और बनी आराम यह हैं; ऊज़ और हूल और जतर और मस। ");
INSERT INTO urd_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","और अरफ़कसद से सिलह पैदा हुआ और सिलह से इब्र। ");
INSERT INTO urd_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","और इब्र के यहाँ दो बेटे पैदा हुए; एक का नाम फ़लज था क्यूँकि ज़मीन उसके दिनों में बटी, और उसके भाई का नाम युक्तान था। ");
INSERT INTO urd_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","और युक्तान से अलमूदाद और सलफ़ और हसारमावत और इराख़। ");
INSERT INTO urd_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","और हदूराम और ऊज़ाल और दिक़ला। ");
INSERT INTO urd_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","और ऊबल और अबीमाएल और सिबा। ");
INSERT INTO urd_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","और ओफ़ीर और हवील और यूबाब पैदा हुए; यह सब बनी युक्तान थे। ");
INSERT INTO urd_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","और इनकी आबादी मेसा से मशरिक़ के एक पहाड़ सफ़ार की तरफ़ थी। ");
INSERT INTO urd_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","इसलिए बनी सिम यह हैं, जो अपने — अपने मुल्क और गिरोह में अपने क़बीलों और अपनी ज़बानों के मुताबिक़ आबाद हैं। ");
INSERT INTO urd_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","नूह के बेटों के ख़ान्दान उनके गिरोह और नसलों के ऐतबार से यही हैं, और तूफ़ान के बाद जो क़ौमें ज़मीन पर इधर उधर बट गई वह इन्हीं में से थीं। ");
INSERT INTO urd_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","और तमाम ज़मीन पर एक ही ज़बान और एक ही बोली थी। ");
INSERT INTO urd_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","और ऐसा हुआ कि मशरिक़ की तरफ़ सफ़र करते करते उनको मुल्क — ए — सिन'आर में एक मैदान मिला और वह वहाँ बस गए। ");
INSERT INTO urd_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","और उन्होंने आपस में कहा, 'आओ, हम ईटें बनाएँ और उनको आग में खू़ब पकाएँ। तब उन्होंने पत्थर की जगह ईट से और चूने की जगह गारे से काम लिया। ");
INSERT INTO urd_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","फिर वह कहने लगे, कि आओ हम अपने लिए एक शहर और एक बुर्ज जिसकी चोटी आसमान तक पहुँचे बनाए और यहाँ अपना नाम करें, ऐसा न हो कि हम तमाम रु — ए — ज़मीन पर बिखर जाएँ। ");
INSERT INTO urd_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","और ख़ुदावन्द इस शहर और बुर्ज, को जिसे बनी आदम बनाने लगे देखने को उतरा। ");
INSERT INTO urd_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","और ख़ुदावन्द ने कहा, “देखो, यह लोग सब एक हैं और इन सभों की एक ही ज़बान है। वह जो यह करने लगे हैं तो अब कुछ भी जिसका वह इरादा करें उनसे बाक़ी न छूटेगा। ");
INSERT INTO urd_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","इसलिए आओ, हम वहाँ जाकर उनकी ज़बान में इख्तिलाफ़ डालें, ताकि वह एक दूसरे की बात समझ न सकें।” ");
INSERT INTO urd_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","तब, ख़ुदावन्द ने उनको वहाँ से तमाम रू — ए — ज़मीन में बिखेर दिया; तब वह उस शहर के बनाने से बाज़ आए। ");
INSERT INTO urd_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","इसलिए उसका नाम बाबुल हुआ क्यूँकि ख़ुदावन्द ने वहाँ सारी ज़मीन की ज़बान में इख्तिलाफ़ डाला और वहाँ से ख़ुदावन्द ने उनको तमाम रू — ए — ज़मीन पर बिखेर दिया। ");
INSERT INTO urd_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","यह सिम का नसबनामा है: सिम एक सौ साल का था जब उससे तूफ़ान के दो साल बाद अरफ़कसद पैदा हुआ; ");
INSERT INTO urd_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","और अरफ़कसद की पैदाइश के बाद सिम पाँच सौ साल ज़िन्दा रहा, और उससे बेटे और बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","जब अरफ़कसद पैतीस साल का हुआ, तो उससे सिलह पैदा हुआ; ");
INSERT INTO urd_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","और सिलह की पैदाइश के बाद अरफ़कसद चार सौ तीन साल और ज़िन्दा रहा, और उससे बेटे और बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","सिलह जब तीस साल का हुआ, तो उससे इब्र पैदा हुआ; ");
INSERT INTO urd_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","और इब्र की पैदाइश के बाद सिलह चार सौ तीन साल और ज़िन्दा रहा, और उससे बेटे और बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","जब इब्र चौंतीस साल का था, तो उससे फ़लज पैदा हुआ; ");
INSERT INTO urd_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","और फ़लज की पैदाइश के बाद इब्र चार सौ तीस साल और ज़िन्दा रहा, और उससे बेटे और बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","फ़लज तीस साल का था, जब उससे र'ऊ पैदा हुआ; ");
INSERT INTO urd_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","और र'ऊ की पैदाइश के बाद फ़लज दो सौ नौ साल और ज़िन्दा रहा, और उससे बेटे और बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","और र'ऊ बत्तीस साल का था, जब उससे सरूज पैदा हुआ; ");
INSERT INTO urd_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","और सरूज की पैदाइश के बाद र'ऊ दो सौ सात साल और ज़िन्दा रहा, और उससे बेटे और बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","और सरूज तीस साल का था, जब उससे नहूर पैदा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","और नहूर की पैदाइश के बाद सरूज दो सौ साल और ज़िन्दा रहा, और उससे बेटे और बेटियाँ पैदा हुईं। ");
INSERT INTO urd_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","नहूर उन्तीस साल का था, जब उससे तारह पैदा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","और तारह की पैदाइश के बाद नहूर एक सौ उन्नीस साल और ज़िन्दा रहा, और उससे बेटे और बेटियाँ पैदा हुई। ");
INSERT INTO urd_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","और तारह सत्तर साल का था, जब उससे इब्रहाम और नहूर और हारान पैदा हुए। ");
INSERT INTO urd_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","और यह तारह का नसबनामा है: तारह से इब्रहाम और नहूर और हारान पैदा हुए और हारान से लूत पैदा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","और हारान अपने बाप तारह के आगे अपनी पैदाइशी जगह यानी कसदियों के ऊर में मरा। ");
INSERT INTO urd_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","और अब्राम और नहूर ने अपना — अपना ब्याह कर लिया। इब्रहाम की बीवी का नाम सारय और नहुर की बीवी का नाम मिल्का था जो हारान की बेटी थी। वही मिल्का का बाप और इस्का का बाप था। ");
INSERT INTO urd_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","और सारय बाँझ थी; उसके कोई बाल — बच्चा न था। ");
INSERT INTO urd_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","और तारह ने अपने बेटे इब्रहाम को और अपने पोते लूत को, जो हारान का बेटा था, और अपनी बहू सारय को जो उसके बेटे इब्रहाम की बीवी थी, साथ लिया और वह सब कसदियों के ऊर से रवाना हुए की कनान के मुल्क में जाएँ; और वह हारान तक आए और वहीं रहने लगे। ");
INSERT INTO urd_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","और तारह की उम्र दो सौ पाँच साल की हुई और उस ने हारान में वफ़ात पाई। ");
INSERT INTO urd_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ख़ुदावन्द ने इब्रहाम से कहा, कि तू अपने वतन और अपने नातेदारों के बीच से और अपने बाप के घर से निकल कर उस मुल्क में जा जो मैं तुझे दिखाऊँगा। ");
INSERT INTO urd_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","और मैं तुझे एक बड़ी क़ौम बनाऊँगा और बरकत दूँगा और तेरा नाम सरफ़राज़ करूँगा; इसलिए तू बरकत का ज़रिया' हो। ");
INSERT INTO urd_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","जो तुझे मुबारक कहें उनको मैं बरकत दूँगा, और जो तुझ पर ला'नत करे उस पर मैं ला'नत करूँगा, और ज़मीन के सब क़बीले तेरे वसीले से बरकत पाएँगे। ");
INSERT INTO urd_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","तब इब्रहाम ख़ुदावन्द के कहने के मुताबिक़ चल पड़ा और लूत उसके साथ गया, और अब्राम पच्छत्तर साल का था जब वह हारान से रवाना हुआ। ");
INSERT INTO urd_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","और इब्रहाम ने अपनी बीवी सारय, और अपने भतीजे लूत को, और सब माल को जो उन्होंने जमा किया था, और उन आदमियों को जो उनको हारान में मिल गए थे साथ लिया, और वह मुल्क — ए — कनान को रवाना हुए और मुल्क — ए — कनान में आए। ");
INSERT INTO urd_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","और इब्रहाम उस मुल्क में से गुज़रता हुआ मक़ाम — ए — सिकम में मोरा के बलूत तक पहुँचा। उस वक़्त मुल्क में कनानी रहते थे। ");
INSERT INTO urd_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","तब ख़ुदावन्द ने इब्रहाम को दिखाई देकर कहा कि यही मुल्क मैं तेरी नसल को दूँगा। और उसने वहाँ ख़ुदावन्द के लिए जो उसे दिखाई दिया था, एक क़ुर्बानगाह बनाई। ");
INSERT INTO urd_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","और वहाँ से कूच करके उस पहाड़ की तरफ़ गया जो बैत — एल के मशरिक़ में है, और अपना डेरा ऐसे लगाया कि बैत — एल मग़रिब में और 'एे मशरिक़ में पड़ा; और वहाँ उसने ख़ुदावन्द के लिए एक क़ुर्बानगाह बनाई और ख़ुदावन्द से दुआ की। ");
INSERT INTO urd_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","और इब्रहाम सफ़र करता करता दख्खिन की तरफ़ बढ़ गया। ");
INSERT INTO urd_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","और उस मुल्क में काल पड़ा: और इब्रहाम मिस्र को गया कि वहाँ टिका रहे; क्यूँकि मुल्क में सख़्त काल था। ");
INSERT INTO urd_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","और ऐसा हुआ कि जब वह मिस्र में दाख़िल होने को था तो उसने अपनी बीवी सारय से कहा कि देख, मैं जानता हूँ कि तू देखने में ख़ूबसूरत औरत है। ");
INSERT INTO urd_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","और यूँ होगा कि मिस्री तुझे देख कर कहेंगे कि यह उसकी बीवी है, इसलिए वह मुझे तो मार डालेंगे मगर तुझे ज़िन्दा रख लेंगे। ");
INSERT INTO urd_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","इसलिए तू यह कह देना, कि मैं इसकी बहन हूँ, ताकि तेरी वजह से मेरा भला हो और मेरी जान तेरी बदौलत बची रहे। ");
INSERT INTO urd_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","और यूँ हुआ कि जब इब्रहाम मिस्र में आया तो मिस्रियों ने उस 'औरत को देखा कि वह निहायत ख़ूबसूरत है। ");
INSERT INTO urd_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","और फ़िर'औन के हाकिमों ने उसे देख कर फ़िर'औन के सामने में उसकी ता'रीफ़ की, और वह 'औरत फ़िर'औन के घर में पहुँचाई गई। ");
INSERT INTO urd_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","और उसने उसकी ख़ातिर इब्रहाम पर एहसान किया; और भेड़ बकरियाँ और गाय, बैल और गधे और ग़ुलाम और लौंडियाँ और गधियाँ और ऊँट उसके पास हो गए। ");
INSERT INTO urd_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","लेकिन ख़ुदावन्द ने फ़िर'औन और उसके ख़ान्दान पर, इब्रहाम की बीवी सारय की वजह से बड़ी — बड़ी बलाएं नाज़िल कीं। ");
INSERT INTO urd_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","तब फ़िर'औन ने इब्रहाम को बुला कर उससे कहा, कि तूने मुझ से यह क्या किया? तूने मुझे क्यूँ न बताया कि यह तेरी बीवी है। ");
INSERT INTO urd_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","तूने यह क्यूँ कहा कि वह मेरी बहन है? इसी लिए मैंने उसे लिया कि वह मेरी बीवी बने इसलिए देख तेरी बीवी हाज़िर है। उसको ले और चला जा। ");
INSERT INTO urd_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","और फ़िर'औन ने उसके हक़ में अपने आदमियों को हिदायत की, और उन्होंने उसे और उसकी बीवी को उसके सब माल के साथ रवाना कर दिया। ");
INSERT INTO urd_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","और इब्रहाम मिस्र से अपनी बीवी और अपने सब माल और लूत को साथ ले कर कनान के दख्खिन की तरफ़ चला। ");
INSERT INTO urd_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","और इब्रहाम के पास चौपाए और सोना चाँदी बकसरत था। ");
INSERT INTO urd_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","और वह कनान के दख्खिन से सफ़र करता हुआ बैत — एल में उस जगह पहुँचा जहाँ पहले बैत — एल और एे के बीच उसका डेरा था। ");
INSERT INTO urd_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","या'नी वह मक़ाम जहाँ उसने शुरु' में क़ुर्बानगाह बनाई थी, और वहाँ इब्रहाम ने ख़ुदावन्द से दुआ की। ");
INSERT INTO urd_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","और लूत के पास भी जो इब्रहाम का हमसफ़र था भेड़ — बकरियाँ, गाय — बैल और डेरे थे। ");
INSERT INTO urd_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","और उस मुल्क में इतनी गुन्जाइश न थी कि वह इकट्ठे रहें, क्यूँकि उनके पास इतना माल था कि वह इकट्ठे नहीं रह सकते थे। ");
INSERT INTO urd_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","और इब्रहाम के चरवाहों और लूत के चरवाहों में झगड़ा हुआ; और कना'नी और फ़रिज़्ज़ी उस वक़्त मुल्क में रहते थे। ");
INSERT INTO urd_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","तब इब्रहाम ने लूत से कहा कि मेरे और तेरे बीच और मेरे चरवाहों और तेरे चरवाहों के बीच झगड़ा न हुआ करे, क्यूँकि हम भाई हैं। ");
INSERT INTO urd_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","क्या यह सारा मुल्क तेरे सामने नहीं? इसलिए तू मुझ से अलग हो जा: अगर तू बाएँ जाए तो मैं दहने जाऊँगा, और अगर तू दहने जाए तो मैं बाएँ जाऊँगा। ");
INSERT INTO urd_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","तब लूत ने आँख उठाकर यरदन की सारी तराई पर जो ज़ुग़र की तरफ़ है नज़र दौड़ाई। क्यूँकि वह इससे पहले कि ख़ुदावन्द ने सदूम और 'अमूरा को तबाह किया, ख़ुदावन्द के बाग़ और मिस्र के मुल्क की तरह खू़ब सेराब थी। ");
INSERT INTO urd_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","तब लूत ने यरदन की सारी तराई को अपने लिए चुन लिया, और वह मशरिक़ की तरफ़ चला; और वह एक दूसरे से जुदा हो गए। ");
INSERT INTO urd_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","इब्रहाम तो मुल्क — ए — कना'न में रहा, और लूत ने तराई के शहरों में सुकूनत इख़्तियार की और सदूम की तरफ़ अपना डेरा लगाया। ");
INSERT INTO urd_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","और सदूम के लोग ख़ुदावन्द की नज़र में निहायत बदकार और गुनहगार थे। ");
INSERT INTO urd_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","और लूत के जुदा हो जाने के बाद ख़ुदावन्द ने इब्रहाम से कह कि अपनी आँख उठा और जिस जगह तू है वहाँ से शिमाल दख्खिन और मशरिक़ और मग़रिब की तरफ़ नज़र दौड़ा। ");
INSERT INTO urd_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","क्यूँकि यह तमाम मुल्क जो तू देख रहा है, मैं तुझ को और तेरी नसल को हमेशा के लिए दूँगा। ");
INSERT INTO urd_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","और मैं तेरी नसल को ख़ाक के ज़र्रों की तरह बनाऊँगा, ऐसा कि अगर कोई शख़्स ख़ाक के ज़र्रों को गिन सके तो तेरी नसल भी गिन ली जाएगी। ");
INSERT INTO urd_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","उठ, और इस मुल्क की लम्बाई और चौड़ाई में घूम, क्यूँकि मैं इसे तुझ को दूँगा। ");
INSERT INTO urd_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","और इब्रहाम ने अपना डेरा उठाया, और ममरे के बलूतों में जो हबरून में हैं जा कर रहने लगा; और वहाँ ख़ुदावन्द के लिए एक क़ुर्बानगाह बनाई। ");
INSERT INTO urd_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","और सिन'आर के बादशाह अमराफ़िल, और इल्लासर के बादशाह अर्युक, और 'ऐलाम के बादशाह किदरला उम्र, और जोइम के बादशाह तिद'आल के दिनों में, ");
INSERT INTO urd_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ऐसा हुआ कि उन्होंने सदूम के बादशाह बर'आ, और 'अमूरा के बादशाह बिरश'आ और अदमा के बादशाह सिनिअब, और ज़िबोईम के बादशाह शिमेबर, और बाला' या'नी ज़ुग़र के बादशाह से जंग की। ");
INSERT INTO urd_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","यह सब सिद्दीम या'नी दरिया — ए — शोर की वादी में इकट्ठे हुए। ");
INSERT INTO urd_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","बारह साल तक वह किदरला उम्र के फ़र्माबरदार रहे, लेकिन तेरहवें साल उन्होंने सरकशी की। ");
INSERT INTO urd_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","और चौदहवें साल किदरला उम्र और उसके साथ के बादशाह आए, और रिफ़ाईम को 'असतारात क़र्नेम में, और ज़ूज़ियों को हाम में, और ऐमीम को सवीक़र्यतैम में, ");
INSERT INTO urd_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","और होरियों को उनके कोह — ए — श'ईर में मारते — मारते एल-फ़ारान तक जो वीराने से लगा हुआ है आए। ");
INSERT INTO urd_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","फिर वह लौट कर 'ऐन — मिसफ़ात या'नी क़ादिस पहुँचे, और 'अमालीक़ियों के तमाम मुल्क को, और अमोरियों को जो हसेसून तमर में रहते थे मारा। ");
INSERT INTO urd_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","तब सदूम का बादशाह, और 'अमूरा का बादशाह, और अदमा का बादशाह, और ज़िबोइम का बादशाह, और बाला' या'नी ज़ुग़र का बादशाह, निकले और उन्होंने सिद्दीम की वादी में लड़ाई की। ");
INSERT INTO urd_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ताकि 'ऐलाम के बादशाह किदरला उम्र, और जोइम के बादशाह तिद'आल, और सिन'आर के बादशाह अमराफ़िल, और इल्लासर के बादशाह अर्यूक से जंग करें; यह चार बादशाह उन पाँचों के मुक़ाबिले में थे। ");
INSERT INTO urd_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","और सिद्दीम की वादी में जा — बजा नफ़्त के गढ़े थे; और सदूम और 'अमूरा के बादशाह भागते — भागते वहाँ गिरे, और जो बचे पहाड़ पर भाग गए। ");
INSERT INTO urd_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","तब वह सदूम 'अमूरा का सब माल और वहाँ का सब अनाज लेकर चले गए; ");
INSERT INTO urd_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","और इब्रहाम के भतीजे लूत को और उसके माल को भी ले गए क्यूँकि वह सदूम में रहता था ");
INSERT INTO urd_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","तब एक ने जो बच गया था जाकर इब्रहाम 'इब्रानी को ख़बर दी, जो इस्काल और 'आनेर के भाई ममरे अमोरी के बलूतों में रहता था, और यह अब्राम के हम 'अहद थे। ");
INSERT INTO urd_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","जब इब्रहाम ने सुना कि उसका भाई गिरफ़्तार हुआ, तो उसने अपने तीन सौ अट्ठारह माहिर लड़ाकों को लेकर दान तक उनका पीछा किया। ");
INSERT INTO urd_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","और रात को उसने और उसके ख़ादिमों ने गोल — गोल होकर उन पर धावा किया और उनको मारा और खू़बा तक, जो दमिश्क़ के बाएँ हाथ है, उनका पीछा किया। ");
INSERT INTO urd_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","और वह सारे माल को और अपने भाई लूत को और उसके माल और 'औरतों को भी और और लोगों को वापस फेर लाया। ");
INSERT INTO urd_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","और जब वह किदरला उम्र और उसके साथ के बादशाहों को मार कर फिरा तो सदूम का बादशाह उसके इस्तक़बाल को सवी की वादी तक जो बादशाही वादी है आया। ");
INSERT INTO urd_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","और मलिक — ए — सिदक़, सालिम का बादशाह, रोटी और मय लाया और वह ख़ुदा ता'ला का काहिन था। ");
INSERT INTO urd_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","और उसने उसको बरकत देकर कहा कि ख़ुदा ता'ला की तरफ़ से जो आसमान और ज़मीन का मालिक है, इब्रहाम मुबारक हो। ");
INSERT INTO urd_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","और मुबारक है ख़ुदा ता'ला जिसने तेरे दुश्मनों को तेरे हाथ में कर दिया। तब इब्रहाम ने सबका दसवाँ हिस्सा उसको दिया। ");
INSERT INTO urd_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","और सदूम के बादशाह ने इब्रहाम से कहा कि आदमियों को मुझे दे दे और माल अपने लिए रख ले। ");
INSERT INTO urd_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","लेकिन इब्रहाम ने सदूम के बादशाह से कहा कि मैंने ख़ुदावन्द ख़ुदा ता'ला, आसमान और ज़मीन के मालिक, की क़सम खाई है, ");
INSERT INTO urd_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","कि मैं न तो कोई धागा, न जूती का तस्मा, न तेरी और कोई चीज़ लूँ ताकि तू यह न कह सके कि मैंने इब्रहाम को दौलतमन्द बना दिया। ");
INSERT INTO urd_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","सिवा उसके जो जवानों ने खा लिया और उन आदमियों के हिस्से के जो मेरे साथ गए; इसलिए 'आनेर और इस्काल और ममरे अपना — अपना हिस्सा ले लें। ");
INSERT INTO urd_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","इन बातों के बाद ख़ुदावन्द का कलाम ख़्वाब में इब्रहाम पर नाज़िल हुआ और उसने फ़रमाया, “ऐ अब्राम, तू मत डर; मैं तेरी ढाल और तेरा बहुत बड़ा अज्र हूँ।” ");
INSERT INTO urd_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","इब्रहाम ने कहा, “ऐ ख़ुदावन्द ख़ुदा, तू मुझे क्या देगा? क्यूँकि मैं तो बेऔलाद जाता हूँ, और मेरे घर का मुख़्तार दमिश्क़ी इली'एलियाज़र है।” ");
INSERT INTO urd_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","फिर इब्रहाम ने कहा, “देख, तूने मुझे कोई औलाद नहीं दी और देख मेरा खानाज़ाद मेरा वारिस होगा।” ");
INSERT INTO urd_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","तब ख़ुदावन्द का कलाम उस पर नाज़िल हुआ और उसने फ़रमाया, “यह तेरा वारिस न होगा, बल्कि वह जो तेरे सुल्ब से पैदा होगा वही तेरा वारिस होगा।” ");
INSERT INTO urd_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","और वह उसको बाहर ले गया और कहा, कि अब आसमान कि तरफ़ निगाह कर और अगर तू सितारों को गिन सकता है तो गिन। और उससे कहा कि तेरी औलाद ऐसी ही होगी। ");
INSERT INTO urd_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","और वह ख़ुदावन्द पर ईमान लाया और इसे उसने उसके हक़ में रास्तबाज़ी शुमार किया। ");
INSERT INTO urd_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","और उसने उससे कहा कि मैं ख़ुदावन्द हूँ जो तुझे कसदियों के ऊर से निकाल लाया, कि तुझ को यह मुल्क मीरास में दूँ। ");
INSERT INTO urd_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","और उसने कहा, “ऐ ख़ुदावन्द ख़ुदा! मैं क्यूँ कर जानूँ कि मैं उसका वारिस हूँगा?” ");
INSERT INTO urd_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","उसने उस से कहा कि मेरे लिए तीन साल की एक बछिया, और तीन साल की एक बकरी, और तीन साल का एक मेंढा, और एक कुमरी, और एक कबूतर का बच्चा ले। ");
INSERT INTO urd_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","उसने उन सभों को लिया और उनके बीच से दो टुकड़े किया, और हर टुकड़े को उसके साथ के दूसरे टुकड़े के सामने रख्खा, मगर परिन्दों के टुकड़े न किए। ");
INSERT INTO urd_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","तब शिकारी परिन्दे उन टुकड़ों पर झपटने लगे पर इब्रहाम उनकी हँकता रहा। ");
INSERT INTO urd_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","सूरज डूबते वक़्त इब्रहाम पर गहरी नींद ग़ालिब हुई और देखो, एक बडा ख़तरनाक अँधेरा उस पर छा गया। ");
INSERT INTO urd_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","और उसने इब्रहाम से कहा, यक़ीन जान कि तेरी नसल के लोग ऐसे मुल्क में जो उनका नहीं परदेसी होंगे और वहाँ के लोगों की ग़ुलामी करेंगे और वह चार सौ साल तक उनको दुख देंगे। ");
INSERT INTO urd_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","लेकिन मैं उस कौम की 'अदालत करूँगा जिसकी वह गु़लामी करेंगे, और बाद में वह बड़ी दौलत लेकर वहाँ से निकल आएँगे। ");
INSERT INTO urd_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","और तू सही सलामत अपने बाप — दादा से जा मिलेगा और बहुत ही बुढापे में दफ़न होगा। ");
INSERT INTO urd_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","और वह चौथी पुश्त में यहाँ लौट आएँगे, क्यूँकि अमोरियों के गुनाह अब तक पूरे नहीं हुए। ");
INSERT INTO urd_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","और जब सूरज डूबा और अन्धेरा छा गया, तो एक तनूर जिसमें से धुंआ उठता था दिखाई दिया, और एक जलती मश'अल उन टुकड़ों के बीच में से होकर गुज़री। ");
INSERT INTO urd_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","उसी रोज़ ख़ुदावन्द ने इब्रहाम से 'अहद किया और फ़रमाया, यह मुल्क दरिया — ए — मिस्र से लेकर उस बड़े दरिया या'नी दरयाए — फ़रात तक, ");
INSERT INTO urd_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","क़ैनियों और क़नीज़ियों और क़दमूनियों, ");
INSERT INTO urd_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","और हित्तियों और फ़रिज़्ज़ियों और रिफ़ाईम, ");
INSERT INTO urd_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","और अमोरियों और कना'नियों और जिरजासियों और यबूसियों समेत मैंने तेरी औलाद को दिया है। ");
INSERT INTO urd_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","और इब्रहाम की बीवी सारय के कोई औलाद न हुई। उसकी एक मिस्री लौंडी थी जिसका नाम हाजिरा था। ");
INSERT INTO urd_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","और सारय ने इब्रहाम से कहा कि देख, ख़ुदावन्द ने मुझे तो औलाद से महरूम रख्खा है, इसलिए तू मेरी लौंडी के पास जा शायद उससे मेरा घर आबाद हो। और इब्रहाम ने सारय की बात मानी। ");
INSERT INTO urd_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","और इब्रहाम को मुल्क — ए — कना'न में रहते दस साल हो गए थे जब उसकी बीवी सारय ने अपनी मिस्री लौंडी उसे दी कि उसकी बीवी बने। ");
INSERT INTO urd_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","और वह हाजिरा के पास गया और वह हामिला हुई। और जब उसे मा'लूम हुआ कि वह हामिला हो गई तो अपनी बीवी को हक़ीर जानने लगी। ");
INSERT INTO urd_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","तब सारय ने इब्रहाम से कहा, जो जु़ल्म मुझ पर हुआ वह तेरी गर्दन पर है। मैंने अपनी लौंडी तेरे आग़ोश में दी और अब जो उसने आपको हामिला देखा तो मैं उसकी नज़रों में हक़ीर हो गई; इसलिए ख़ुदावन्द मेरे और तेरे बीच इन्साफ़ करे। ");
INSERT INTO urd_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","इब्रहाम ने सारय से कहा कि तेरी लौंडी तेरे हाथ में है; जो तुझे भला दिखाई दे वैसा ही उसके साथ कर। तब सारय उस पर सख़्ती करने लगी और वह उसके पास से भाग गई। ");
INSERT INTO urd_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","और वह ख़ुदावन्द के फ़रिश्ता को वीराने में पानी के एक चश्मे के पास मिली। यह वही चश्मा है जो शोर की राह पर है। ");
INSERT INTO urd_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","और उसने कहा, “ऐ सारय की लौंडी हाजिरा, तू कहाँ से आई और किधर जाती है?” उसने कहा कि मैं अपनी बीबी सारय के पास से भाग आई हूँ। ");
INSERT INTO urd_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ख़ुदावन्द के फ़रिश्ता ने उससे कहा कि तू अपनी बीबी के पास लौट जा और अपने को उसके कब्ज़े में कर दे ");
INSERT INTO urd_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","और ख़ुदावन्द के फ़रिश्ता ने उससे कहा, कि मै तेरी औलाद को बहुत बढ़ाऊँगा यहाँ तक कि कसरत की वजह से उसका शुमार न हो सकेगा। ");
INSERT INTO urd_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","और ख़ुदावन्द के फ़रिश्ता ने उससे कहा कि तू हामिला है और तेरा बेटा होगा, उसका नाम इस्मा'ईल रखना इसलिए कि ख़ुदावन्द ने तेरा दुख सुन लिया। ");
INSERT INTO urd_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","वह गोरखर की तरह आज़ाद मर्द होगा, उसका हाथ सबके ख़िलाफ़ और सबके हाथ उसके ख़िलाफ़ होंगे और वह अपने सब भाइयों के सामने बसा रहेगा। ");
INSERT INTO urd_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","और हाजिरा ने ख़ुदावन्द का जिसने उससे बातें कीं, अताएल — रोई नाम रख्खा या'नी ऐ ख़ुदा तू बसीर है; क्यूँकि उसने कहा, क्या मैंने यहाँ भी अपने देखने वाले को जाते हुए देखा?' ");
INSERT INTO urd_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","इसी वजह से उस कुएँ का नाम बैरलही रोई पड़ गया; वह क़ादिस और बरिद के बीच है। ");
INSERT INTO urd_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","और इब्रहाम से हाजिरा के एक बेटा हुआ, और इब्रहाम ने अपने उस बेटे का नाम जो हाजिरा से पैदा हुआ इस्मा'ईल रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","और जब इब्रहाम से हाजिरा के इस्मा'ईल पैदा हुआ तब इब्रहाम छियासी साल का था। ");
INSERT INTO urd_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","जब इब्रहाम निनानवे साल का हुआ तब ख़ुदावन्द इब्रहाम को नज़र आया और उससे कहा कि मैं ख़ुदा — ए — क़ादिर हूँ; तू मेरे सामने में चल और कामिल हो। ");
INSERT INTO urd_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","और मैं अपने और तेरे बीच 'अहद बाँधूंगा और तुझे बहुत ज़्यादा बढ़ाऊँगा। ");
INSERT INTO urd_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","तब इब्रहाम सिज्दे में हो गया और ख़ुदा ने उससे हम — कलाम होकर फ़रमाया। ");
INSERT INTO urd_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","कि देख मेरा 'अहद तेरे साथ है और तू बहुत क़ौमों का बाप होगा। ");
INSERT INTO urd_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","और तेरा नाम फिर इब्रहाम नहीं कहलाएगा बल्कि तेरा नाम अब्रहाम होगा, क्यूँकि मैंने तुझे बहुत क़ौमों का बाप ठहरा दिया है। ");
INSERT INTO urd_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","और मैं तुझे बहुत कामयाब करूँगा और क़ौमें तेरी नसल से होंगी और बादशाह तेरी औलाद में से निकलेंगे। ");
INSERT INTO urd_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","और मैं अपने और तेरे बीच, और तेरे बाद तेरी नसल के बीच उनकी सब नसलो के लिए अपना 'अहद जो अबदी 'अहद होगा, बांधूंगा ताकि मैं तेरा और तेरे बाद तेरी नसल का ख़ुदा रहूँ। ");
INSERT INTO urd_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","और मैं तुझ को और तेरे बाद तेरी नसल को, कनान का तमाम मुल्क जिसमें तू परदेसी है ऐसा दूँगा, कि वह हमेशा की मिल्कियत हो जाए; और मैं उनका ख़ुदा हूँगा। ");
INSERT INTO urd_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","फिर ख़ुदा ने अब्रहाम से कहा कि तू मेरे 'अहद को मानना और तेरे बाद तेरी नसल पुश्त दर पुश्त उसे माने। ");
INSERT INTO urd_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","और मेरा 'अहद जो मेरे और तेरे बीच और तेरे बाद तेरी नसल के बीच है, और जिसे तुम मानोगे वह यह है: कि तुम में से हर एक फ़र्ज़न्द — ए — नरीना का ख़तना किया जाए। ");
INSERT INTO urd_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","और तुम अपने बदन की खलड़ी का ख़तना किया करना, और यह उस 'अहद का निशान होगा जो मेरे और तुम्हारे बीच है। ");
INSERT INTO urd_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","तुम्हारे यहाँ नसल — दर — नसल हर लड़के का ख़तना, जब वह आठ रोज़ का हो, किया जाए; चाहे वह घर में पैदा हो चाहे उसे किसी परदेसी से ख़रीदा हो जो तेरी नसल से नहीं। ");
INSERT INTO urd_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","लाज़िम है कि तेरे ख़ानाज़ाद और तेरे ग़ुलाम का ख़तना किया जाए, और मेरा 'अहद तुम्हारे जिस्म में अबदी 'अहद होगा। ");
INSERT INTO urd_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","और वह फ़र्ज़न्द — ए — नरीना जिसका ख़तना न हुआ हो, अपने लोगों में से काट डाला जाए क्यूँकि उसने मेरा 'अहद तोड़ा। ");
INSERT INTO urd_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","और ख़ुदा ने अब्रहाम से कहा, कि सारय जो तेरी बीवी है इसलिए उसको सारय न पुकारना, उसका नाम सारा होगा। ");
INSERT INTO urd_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","और मैं उसे बरकत दूँगा और उससे भी तुझे एक बेटा बख्शूँगा; यक़ीनन मैं उसे बरकत दूँगा कि क़ौमें उसकी नसल से होंगी और 'आलम के बादशाह उससे पैदा होंगे। ");
INSERT INTO urd_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","तब अब्रहाम सिज्दे में हुआ और हँस कर दिल में कहने लगा कि क्या सौ साल के बूढ़े से कोई बच्चा होगा, और क्या सारा के जो नव्वे साल की है औलाद होगी? ");
INSERT INTO urd_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","और अब्रहाम ने ख़ुदा से कहा कि काश इस्मा'ईल ही तेरे सामने ज़िन्दा रहे, ");
INSERT INTO urd_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","तब ख़ुदा ने फ़रमाया, कि बेशक तेरी बीवी सारा के तुझ से बेटा होगा, तू उसका नाम इस्हाक़ रखना; और मैं उससे और फिर उसकी औलाद से अपना 'अहद जो अबदी 'अहद है बाँधूगा। ");
INSERT INTO urd_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","और इस्मा'ईल के हक़ में भी मैंने तेरी दुआ सुनी; देख मैं उसे बरकत दूँगा और उसे कामयाब करूँगा और उसे बहुत बढ़ाऊँगा; और उससे बारह सरदार पैदा होंगे और मैं उसे बड़ी क़ौम बनाऊँगा। ");
INSERT INTO urd_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","लेकिन मैं अपना 'अहद इस्हाक़ से बाँधूगा जो अगले साल इसी वक़्त — ए — मुक़र्रर पर सारा से पैदा होगा। ");
INSERT INTO urd_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","और जब ख़ुदा अब्रहाम से बातें कर चुका तो उसके पास से ऊपर चला गया। ");
INSERT INTO urd_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","तब अब्रहाम ने अपने बेटे इस्मा'ईल की और सब ख़ानाज़ादों और अपने सब ग़ुलामों को या'नी अपने घर के सब आदमियों को लिया और उसी दिन ख़ुदा के हुक्म के मुताबिक़ उन का ख़तना किया। ");
INSERT INTO urd_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","अब्रहाम निनानवे साल का था जब उसका ख़तना हुआ। ");
INSERT INTO urd_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","और जब उसके बेटे इस्मा'ईल का ख़तना हुआ तो वह तेरह साल का था। ");
INSERT INTO urd_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","अब्रहाम और उसके बेटे इस्मा'ईल का ख़तना एक ही दिन हुआ। ");
INSERT INTO urd_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","और उसके घर के सब आदमियों का ख़तना, ख़ानाज़ादों और उनका भी जो परदेसियों से ख़रीदे गए थे, उसके साथ हुआ। ");
INSERT INTO urd_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","फिर ख़ुदावन्द ममरे के बलूतों में उसे नज़र आया और वह दिन को गर्मी के वक़्त अपने खे़मे के दरवाज़े पर बैठा था। ");
INSERT INTO urd_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","और उसने अपनी आँखें उठा कर नज़र की और क्या देखता है कि तीन मर्द उसके सामने खड़े हैं। वह उनको देख कर खे़मे के दरवाज़े से उनसे मिलने को दौड़ा और ज़मीन तक झुका। ");
INSERT INTO urd_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","और कहने लगा कि ऐ मेरे ख़ुदावन्द, अगर मुझ पर आपने करम की नज़र की है तो अपने ख़ादिम के पास से चले न जाएँ। ");
INSERT INTO urd_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","बल्कि थोड़ा सा पानी लाया जाए, और आप अपने पाँव धो कर उस दरख़्त के नीचे आराम करें। ");
INSERT INTO urd_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","मैं कुछ रोटी लाता हूँ, आप ताज़ा — दम हो जाएँ; तब आगे बढ़ें क्यूँकि आप इसी लिए अपने ख़ादिम के यहाँ आए हैं उन्होंने कहा, जैसा तूने कहा है, वैसा ही कर। ");
INSERT INTO urd_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","और अब्रहाम डेरे में सारा के पास दौड़ा गया और कहा, कि तीन पैमाना बारीक आटा जल्द ले और उसे गूंध कर फुल्के बना। ");
INSERT INTO urd_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","और अब्रहाम गल्ले की तरफ़ दौड़ा और एक मोटा ताज़ा बछड़ा लाकर एक जवान को दिया, और उस ने जल्दी — जल्दी उसे तैयार किया। ");
INSERT INTO urd_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","फिर उसने मक्खन और दूध और उस बछड़े को जो उस ने पकवाया था, लेकर उनके सामने रख्खा; और ख़ुद उनके पास दरख़्त के नीचे खड़ा रहा और उन्होंने खाया। ");
INSERT INTO urd_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","फिर उन्होंने उससे पूछा कि तेरी बीवी सारा कहाँ है? उसने कहा, वह डेरे में है। ");
INSERT INTO urd_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","तब उसने कहा, “मैं फिर मौसम — ए — बहार में तेरे पास आऊँगा, और देख तेरी बीवी सारा के बेटा होगा।” उसके पीछे डेरे का दरवाज़ा था, सारा वहाँ से सुन रही थी। ");
INSERT INTO urd_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","और अब्रहाम और सारा ज़ईफ़ और बड़ी उम्र के थे, और सारा की वह हालत नहीं रही थी जो 'औरतों की होती है। ");
INSERT INTO urd_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","तब सारा ने अपने दिल में हँस कर कहा, ख़ुदावन्द “क्या इस क़दर उम्र — दराज़ होने पर भी मेरे लिए खु़शी हो सकती है, जबकि मेरा शौहर भी बूढ़ा है?” ");
INSERT INTO urd_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","फिर ख़ुदावन्द ने अब्रहाम से कहा कि सारा क्यूँ यह कह कर हँसी की क्या मेरे जो ऐसी बुढ़िया हो गई हूँ वाक़ई बेटा होगा? ");
INSERT INTO urd_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","क्या ख़ुदावन्द के नज़दीक कोई बात मुश्किल है? मौसम — ए — बहार में मुक़र्रर वक़्त पर मैं तेरे पास फिर आऊँगा और सारा के बेटा होगा। ");
INSERT INTO urd_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","तब सारा इन्कार कर गई, कि मैं नहीं हँसी। क्यूँकि वह डरती थी, लेकिन उसने कहा, “नहीं, तू ज़रूर हँसी थी।” ");
INSERT INTO urd_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","तब वह मर्द वहाँ से उठे और उन्होंने सदूम का रुख़ किया, और अब्रहाम उनको रुख़सत करने को उनके साथ हो लिया। ");
INSERT INTO urd_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","और ख़ुदावन्द ने कहा कि जो कुछ मैं करने को हूँ, क्या उसे अब्रहाम से छिपाए रख्खूँ ");
INSERT INTO urd_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","अब्रहाम से तो यक़ीनन एक बड़ी और ज़बरदस्त क़ौम पैदा होगी, और ज़मीन की सब क़ौमें उसके वसीले से बरकत पाएँगी। ");
INSERT INTO urd_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","क्यूँकि मैं जानता हूँ कि वह अपने बेटों और घराने को जो उसके पीछे रह जाएँगे, वसीयत करेगा कि वह ख़ुदावन्द की राह में क़ाईम रह कर 'अद्ल और इन्साफ़ करें; ताकि जो कुछ ख़ुदावन्द ने अब्रहाम के हक़ में फ़रमाया है उसे पूरा करे। ");
INSERT INTO urd_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","फिर ख़ुदावन्द ने फ़रमाया, “चूँकि सदूम और 'अमूरा का गुनाह बढ़ गया और उनका जुर्म निहायत संगीन हो गया है। ");
INSERT INTO urd_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","इसलिए मैं अब जाकर देखूँगा कि क्या उन्होंने सरासर वैसा ही किया है जैसा गुनाह मेरे कान तक पहुँचा है, और अगर नहीं किया तो मैं मा'लूम कर लूँगा।” ");
INSERT INTO urd_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","इसलिए वह मर्द वहाँ से मुड़े और सदूम की तरफ़ चले, लेकिन अब्रहाम ख़ुदावन्द के सामने खड़ा ही रहा। ");
INSERT INTO urd_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","तब अब्रहाम ने नज़दीक जा कर कहा, क्या तू नेक को बद के साथ हलाक करेगा? ");
INSERT INTO urd_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","शायद उस शहर में पचास रास्तबाज़ हों; “क्या तू उसे हलाक करेगा और उन पचास रास्तबाज़ों की ख़ातिर जो उसमें हों उस मक़ाम को न छोड़ेगा? ");
INSERT INTO urd_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ऐसा करना तुझ से दूर है कि नेक को बद के साथ मार डाले और नेक बद के बराबर हो जाएँ। ये तुझ से दूर है। क्या तमाम दुनिया का इन्साफ़ करने वाला इन्साफ़ न करेगा?” ");
INSERT INTO urd_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","और ख़ुदावन्द ने फ़रमाया, कि अगर मुझे सदूम में शहर के अन्दर पचास रास्तबाज़ मिलें, तो मैं उनकी ख़ातिर उस मक़ाम को छोड़ दूँगा। ");
INSERT INTO urd_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","तब अब्रहाम ने जवाब दिया और कहा, कि देखिए! मैंने ख़ुदावन्द से बात करने की हिम्मत की, अगरचे मैं मिट्टी और राख हूँ। ");
INSERT INTO urd_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","शायद पचास रास्तबाज़ों में पाँच कम हों; क्या उन पाँच की कमी की वजह से तू तमाम शहर को बर्बाद करेगा? उस ने कहा अगर मुझे वहाँ पैंतालीस मिलें तो मैं उसे बर्बाद नहीं करूँगा। ");
INSERT INTO urd_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","फिर उसने उससे कहा कि शायद वहाँ चालीस मिलें। तब उसने कहा कि मैं उन चालीस की ख़ातिर भी यह नहीं करूँगा। ");
INSERT INTO urd_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","फिर उसने कहा, “ख़ुदावन्द नाराज़ न हो तो मैं कुछ और 'अर्ज़ करूँ। शायद वहाँ तीस मिलें।” उसने कहा, “अगर मुझे वहाँ तीस भी मिलें तो भी ऐसा नहीं करूँगा।” ");
INSERT INTO urd_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","फिर उसने कहा, “देखिए! मैंने ख़ुदावन्द से बात करने की हिम्मत की; शायद वहाँ बीस मिलें।” उसने कहा, “मैं बीस के लिए भी उसे बर्बाद नहीं करूँगा।” ");
INSERT INTO urd_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","तब उसने कहा, “ख़ुदावन्द नाराज़ न हो तो मैं एक बार और कुछ 'अर्ज़ करूँ; शायद वहाँ दस मिलें।” उसने कहा, “मैं दस के लिए भी उसे बर्बाद नहीं करूँगा।” ");
INSERT INTO urd_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","जब ख़ुदावन्द अब्रहाम से बातें कर चुका तो चला गया और अब्रहाम अपने मकान को लौटा। ");
INSERT INTO urd_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","और वह दोनों फ़रिश्ता शाम को सदूम में आए और लूत सदूम के फाटक पर बैठा था। और लूत उनको देख कर उनके इस्तक़बाल के लिए उठा और ज़मीन तक झुका, ");
INSERT INTO urd_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","और कहा, “ऐ मेरे ख़ुदावन्द, अपने ख़ादिम के घर तशरीफ़ ले चलिए और रात भर आराम कीजिए और अपने पाँव धोइये और सुबह उठ कर अपनी राह लीजिए।” और उन्होंने कहा, “नहीं, हम चौक ही में रात काट लेंगे।” ");
INSERT INTO urd_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","लेकिन जब वह बहुत बजिद्द हुआ तो वह उसके साथ चल कर उसके घर में आए; और उसने उनके लिए खाना तैयार की और बेख़मीरी रोटी पकाई; और उन्होंने खाया। ");
INSERT INTO urd_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","और इससे पहले कि वह आराम करने के लिए लेटें सदूम शहर के आदमियों ने, जवान से लेकर बूढ़े तक सब लोगों ने, हर तरफ़ से उस घर को घेर लिया। ");
INSERT INTO urd_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","और उन्होंने लूत को पुकार कर उससे कहा कि वह आदमी जो आज रात तेरे यहाँ आए, कहाँ हैं? उनको हमारे पास बाहर ले आ ताकि हम उनसे सोहबत करें। ");
INSERT INTO urd_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","तब लूत निकल कर उनके पास दरवाज़ा पर गया और अपने पीछे किवाड़ बन्द कर दिया। ");
INSERT INTO urd_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","और कहा कि ऐ भाइयो! ऐसी बदी तो न करो। ");
INSERT INTO urd_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","देखो! मेरी दो बेटियाँ हैं जो आदमी से वाकिफ़ नहीं; मर्ज़ी हो तो मैं उनको तुम्हारे पास ले आऊँ और जो तुम को भला मा'लूम हो उनसे करो, मगर इन आदमियों से कुछ न कहना क्यूँकि वह इसलिए मेरी पनाह में आए हैं। ");
INSERT INTO urd_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","उन्होंने कहा, यहाँ से हट जा! “फिर कहने लगे, कि यह शख़्स हमारे बीच क़याम करने आया था और अब हुकूमत जताता है; इसलिए हम तेरे साथ उनसे ज़्यादा बद सलूकी करेंगे।” तब वह उस आदमी या'नी लूत पर पिल पड़े और नज़दीक आए ताकि किवाड़ तोड़ डालें। ");
INSERT INTO urd_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","लेकिन उन आदमियों ने अपना हाथ बढ़ा कर लूत को अपने पास घर में खींच लिया और दरवाज़ा बन्द कर दिया। ");
INSERT INTO urd_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","और उन आदमियों को जो घर के दरवाज़े पर थे क्या छोटे क्या बड़े, अंधा कर दिया; तब वह दरवाज़ा ढूँडते — ढूँडते थक गए। ");
INSERT INTO urd_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","तब उन आदमियों ने लूत से कहा, क्या यहाँ तेरा और कोई है? दामाद और अपने बेटों और बेटियों और जो कोई तेरा इस शहर में हो, सबको इस मक़ाम से बाहर निकाल ले जा। ");
INSERT INTO urd_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","क्यूँकि हम इस मक़ाम को बर्बाद करेंगे, इसलिए कि उनका गुनाह ख़ुदावन्द के सामने बहुत बुलन्द हुआ है और ख़ुदावन्द ने उसे बर्बाद करने को हमें भेजा है। ");
INSERT INTO urd_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","तब लूत ने बाहर जाकर अपने दामादों से जिन्होंने उसकी बेटियाँ ब्याही थीं बातें कीं और कहा कि उठो और इस मक़ाम से निकलो क्यूँकि ख़ुदावन्द इस शहर को बर्बाद करेगा। लेकिन वह अपने दामादों की नज़र में मज़ाक़ सा मा'लूम हुआ। ");
INSERT INTO urd_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","जब सुबह हुई तो फ़रिश्तों ने लूत से जल्दी कराई और कहा कि उठ अपनी बीवी और अपनी दोनों बेटियों को जो यहाँ हैं ले जा; ऐसा न हो कि तू भी इस शहर की बदी में गिरफ़्तार होकर हलाक हो जाए। ");
INSERT INTO urd_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","मगर उसने देर लगाई तो उन आदमियों ने उसका और उसकी बीवी और उसकी दोनों बेटियों का हाथ पकड़ा, क्यूँकि ख़ुदावन्द की मेहरबानी उस पर हुई और उसे निकाल कर शहर से बाहर कर दिया। ");
INSERT INTO urd_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","और यूँ हुआ कि जब वह उनको बाहर निकाल लाए तो उसने कहा, “अपनी जान बचाने को भाग; न तो पीछे मुड़ कर देखना न कहीं मैदान में ठहरना; उस पहाड़ को चला जा, ऐसा न हो कि तू हलाक हो जाए।” ");
INSERT INTO urd_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","और लूत ने उनसे कहा कि ऐ मेरे ख़ुदावन्द, ऐसा न कर। ");
INSERT INTO urd_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","देख, तूने अपने ख़ादिम पर करम की नज़र की है और ऐसा बड़ा फ़ज़ल किया कि मेरी जान बचाई; मैं पहाड़ तक जा नहीं सकता, कहीं ऐसा न हो कि मुझ पर मुसीबत आ पड़े और मैं मर जाऊँ। ");
INSERT INTO urd_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","देख, यह शहर ऐसा नज़दीक है कि वहाँ भाग सकता हूँ और यह छोटा भी है। इजाज़त हो तो मैं वहाँ चला जाऊँ, वह छोटा सा भी है और मेरी जान बच जाएगी। ");
INSERT INTO urd_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","उसने उससे कहा कि देख, मैं इस बात में भी तेरा लिहाज़ करता हूँ कि इस शहर को जिसका तू ने ज़िक्र किया, बर्बाद नहीं करूँगा। ");
INSERT INTO urd_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","जल्दी कर और वहाँ चला जा, क्यूँकि मैं कुछ नहीं कर सकता जब तक कि तू वहाँ पहुँच न जाए। इसीलिए उस शहर का नाम ज़ुग़र कहलाया। ");
INSERT INTO urd_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","और ज़मीन पर धूप निकल चुकी थी, जब लूत ज़ुग़र में दाख़िल हुआ। ");
INSERT INTO urd_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","तब ख़ुदावन्द ने अपनी तरफ़ से सदूम और 'अमूरा पर गन्धक और आग आसमान से बरसाई, ");
INSERT INTO urd_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","और उसने उन शहरों को और उस सारी तराई को और उन शहरों के सब रहने वालों को और सब कुछ जो ज़मीन से उगा था बर्बाद किया। ");
INSERT INTO urd_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","मगर उसकी बीवी ने उसके पीछे से मुड़ कर देखा और वह नमक का सुतून बन गई। ");
INSERT INTO urd_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","और अब्रहाम सुबह सवेरे उठ कर उस जगह गया जहाँ वह ख़ुदावन्द के सामने खड़ा हुआ था; ");
INSERT INTO urd_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","और उसने सदूम और 'अमूरा और उस तराई की सारी ज़मीन की तरफ़ नज़र की, और क्या देखता है कि ज़मीन पर से धुवां ऐसा उठ रहा है जैसे भट्टी का धुवां। ");
INSERT INTO urd_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","और यूँ हुआ कि जब ख़ुदा ने उस तराई के शहरों को बर्बाद किया, तो ख़ुदा ने अब्रहाम को याद किया और उन शहरों की जहाँ लूत रहता था, बर्बाद करते वक़्त लूत को उस बला से बचाया। ");
INSERT INTO urd_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","और लूत जुग़्रसे निकल कर पहाड़ पर जा बसा और उसकी दोनों बेटियाँ उसके साथ थीं; क्यूँकि उसे ज़ुग़र में बसते डर लगा, और वह और उसकी दोनों बेटियाँ एक ग़ार में रहने लगे। ");
INSERT INTO urd_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","तब पहलौठी ने छोटी से कहा, कि हमारा बाप बूढ़ा है और ज़मीन पर कोई आदमी नहीं जो दुनिया के दस्तूर के मुताबिक़ हमारे पास आए। ");
INSERT INTO urd_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","आओ, हम अपने बाप को मय पिलाएँ और उससे हम — आग़ोश हों, ताकि अपने बाप से नसल बाक़ी रख्खें। ");
INSERT INTO urd_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","इसलिए उन्होंने उसी रात अपने बाप को मय पिलाई और पहलौठी अन्दर गई और अपने बाप से हम — आग़ोश हुई, लेकिन उसने न जाना कि वह कब लेटी और कब उठ गई। ");
INSERT INTO urd_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","और दूसरे दिन यूँ हुआ कि पहलौठी ने छोटी से कहा कि देख, कल रात को मैं अपने बाप से हम — आग़ोश हुई, आओ, आज रात भी उसको मय पिलाएँ और तू भी जा कर उससे हमआग़ोश हो, ताकि हम अपने बाप से नसल बाक़ी रख्खें। ");
INSERT INTO urd_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","फिर उस रात भी उन्होंने अपने बाप को मय पिलाई और छोटी गई और उससे हम — आग़ोश हुई, लेकिन उसने न जाना कि वह कब लेटी और कब उठ गई। ");
INSERT INTO urd_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","फिर लूत की दोनों बेटियाँ अपने बाप से हामिला हुई। ");
INSERT INTO urd_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","और बड़ी के एक बेटा हुआ और उसने उसका नाम मोआब रख्खा; वही मोआबियों का बाप है जो अब तक मौजूद हैं। ");
INSERT INTO urd_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","और छोटी के भी एक बेटा हुआ और उसने उसका नाम बिन — 'अम्मी रख्खाः वही बनी — 'अम्मोन का बाप है जो अब तक मौजूद हैं। ");
INSERT INTO urd_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","और अब्रहाम वहाँ से दख्खिन के मुल्क की तरफ़ चला और क़ादिस और शोर के बीच ठहरा और जिरार में क़याम किया। ");
INSERT INTO urd_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","और अब्रहाम ने अपनी बीवी सारा के हक़ में कहा, कि वह मेरी बहन है, और जिरार के बादशाह अबीमलिक ने सारा को बुलवा लिया। ");
INSERT INTO urd_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","लेकिन रात को ख़ुदा अबीमलिक के पास ख़्वाब में आया और उसे कहा कि देख, तू उस 'औरत की वजह से जिसे तूने लिया है हलाक होगा क्यूँकि वह शौहर वाली है। ");
INSERT INTO urd_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","लेकिन अबीमलिक ने उससे सोहबत नहीं की थी; तब उसने कहा, ऐ ख़ुदावन्द, क्या तू सादिक़ क़ौम को भी मारेगा? ");
INSERT INTO urd_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","क्या उसने ख़ुद मुझ से नहीं कहा, कि यह मेरी बहन है? और वह ख़ुद भी यही कहती थी, कि वह मेरा भाई है; मैंने तो अपने सच्चे दिल और पाकीज़ा हाथों से यह किया। ");
INSERT INTO urd_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","और ख़ुदा ने उसे ख़्वाब में कहा, “हाँ, मैं जानता हूँ कि तूने अपने सच्चे दिल से यह किया, और मैंने भी तुझे रोका कि तू मेरा गुनाह न करे; इसी लिए मैंने तुझे उसको छूने न दिया। ");
INSERT INTO urd_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","अब तू उस आदमी की बीवी को वापस कर दे; क्यूँकि वह नबी है और वह तेरे लिए दुआ करेगा और तू ज़िन्दा रहेगा। लेकिन अगर तू उसे वापस न करे तो जान ले कि तू भी और जितने तेरे हैं सब ज़रूर हलाक होंगे।” ");
INSERT INTO urd_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","तब अबीमलिक ने सुबह सवेरे उठ कर अपने सब नौकरों को बुलाया और उनको ये सब बातें कह सुनाई, तब वह लोग बहुत डर गए। ");
INSERT INTO urd_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","और अबीमलिक ने अब्रहाम को बुला कर उससे कहा, कि तूने हम से यह क्या किया? और मुझ से तेरा क्या कु़सूर हुआ कि तू मुझ पर और मेरी बादशाही पर एक गुनाह — ए — अज़ीम लाया? तूने मुझ से वह काम किए जिनका करना मुनासिब न था। ");
INSERT INTO urd_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","अबीमलिक ने अब्रहाम से यह भी कहा कि तूने क्या समझ कर ये बात की? ");
INSERT INTO urd_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","अब्रहाम ने कहा, कि मेरा ख़्याल था कि ख़ुदा का ख़ौफ़ तो इस जगह हरगिज़ न होगा, और वह मुझे मेरी बीवी की वजह से मार डालेंगे। ");
INSERT INTO urd_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","और फ़िल — हक़ीक़त वह मेरी बहन भी है, क्यूँकि वह मेरे बाप की बेटी है अगरचे मेरी माँ की बेटी नहीं; फिर वह मेरी बीवी हुई। ");
INSERT INTO urd_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","और जब ख़ुदा ने मेरे बाप के घर से मुझे आवारा किया तो मैंने इससे कहा कि मुझ पर यह तेरी मेहरबानी होगी कि जहाँ कहीं हम जाएँ तू मेरे हक़ में यही कहना कि यह मेरा भाई है। ");
INSERT INTO urd_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","तब अबीमलिक ने भेड़ बकरियाँ और गाये बैल और ग़ुलाम और लौंडियाँ अब्रहाम को दीं, और उसकी बीवी सारा को भी उसे वापस कर दिया। ");
INSERT INTO urd_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","और अबीमलिक ने कहा कि देख, मेरा मुल्क तेरे सामने है, जहाँ जी चाहे रह। ");
INSERT INTO urd_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","और उसने सारा से कहा कि देख, मैंने तेरे भाई को चाँदी के हज़ार सिक्के दिए हैं, वह उन सब के सामने जो तेरे साथ हैं तेरे लिए आँख का पर्दा है, और सब के सामने तेरी बड़ाई हो गी। ");
INSERT INTO urd_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","तब अब्रहाम ने ख़ुदा से दुआ की, और ख़ुदा ने अबीमलिक और उसकी बीवी और उसकी — लौंडियों की शिफ़ा बख़्शी और उनके औलाद होने लगी। ");
INSERT INTO urd_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","क्यूँकि ख़ुदावन्द ने अब्रहाम की बीवी सारा की वजह से अबीमलिक के ख़ान्दान के सब रहम बन्द कर दिए थे। ");
INSERT INTO urd_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","और ख़ुदावन्द ने जैसा उसने फ़रमाया था, सारा पर नज़र की और उसने अपने वादे के मुताबिक़ सारा से किया। ");
INSERT INTO urd_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","तब सारा हामिला हुई और अब्रहाम के लिए उसके बुढ़ापे में उसी मुक़र्रर वक़्त पर जिसका ज़िक्र ख़ुदा ने उससे किया था, उसके बेटा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","और अब्रहाम ने अपने बेटे का नाम जो उससे, सारा के पैदा हुआ इस्हाक़ रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","और अब्रहाम ने ख़ुदा के हुक्म के मुताबिक़ अपने बेटे इस्हाक़ का ख़तना, उस वक़्त किया जब वह आठ दिन का हुआ। ");
INSERT INTO urd_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","और जब उसका बेटा इस्हाक़ उससे पैदा हुआ तो अब्रहाम सौ साल का था। ");
INSERT INTO urd_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","और सारा ने कहा, कि ख़ुदा ने मुझे हँसाया और सब सुनने वाले मेरे साथ हँसेंगे। ");
INSERT INTO urd_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","और यह भी कहा कि भला कोई अब्रहाम से कह सकता था कि सारा लड़कों को दूध पिलाएगी? क्यूँकि उससे उसके बुढ़ापे में मेरे एक बेटा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","और वह लड़का बढ़ा और उसका दूध छुड़ाया गया और इस्हाक़ के दूध छुड़ाने के दिन अब्रहाम ने बड़ी दावत की। ");
INSERT INTO urd_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","और सारा ने देखा कि हाजिरा मिस्री का बेटा जो उसके अब्रहाम से हुआ था, ठट्ठे मारता है। ");
INSERT INTO urd_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","तब उसने अब्रहाम से कहा कि इस लौंडी को और उसके बेटे को निकाल दे, क्यूँकि इस लौंडी का बेटा मेरे बेटे इस्हाक़ के साथ वारिस न होगा। ");
INSERT INTO urd_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","लेकिन अब्रहाम को उसके बेटे के ज़रिए' यह बात निहायत बुरी मा'लूम हुई। ");
INSERT INTO urd_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","और ख़ुदा ने अब्रहाम से कहा कि तुझे इस लड़के और अपनी लौंडी की वजह से बुरा न लगे; जो कुछ सारा तुझ से कहती है तू उसकी बात मान क्यूँकि इस्हाक़ से तेरी नसल का नाम चलेगा। ");
INSERT INTO urd_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","और इस लौंडी के बेटे से भी मैं एक क़ौम पैदा करूँगा, इसलिए कि वह तेरी नसल है। ");
INSERT INTO urd_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","तब अब्रहाम ने सुबह सवेरे उठ कर रोटी और पानी की एक मश्क ली और उसे हाजिरा को दिया, बल्कि उसे उसके कन्धे पर रख दिया और लड़के को भी उसके हवाले करके उसे रुख़सत कर दिया। इसलिए वह चली गई और बैरसबा' के वीराने में आवारा फिरने लगी। ");
INSERT INTO urd_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","और जब मश्क का पानी ख़त्म हो गया तो उसने लड़के को एक झाड़ी के नीचे डाल दिया। ");
INSERT INTO urd_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","और ख़ुद उसके सामने एक टप्पे के किनारे पर दूर जा कर बैठी और कहने लगी कि मैं इस लड़के का मरना तो न देखूँ। इसलिए वह उसके सामने बैठ गई और ज़ोर ज़ोर से रोने लगी। ");
INSERT INTO urd_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","और ख़ुदा ने उस लड़के की आवाज़ सुनी और ख़ुदा के फ़रिश्ता ने आसमान से हाजिरा को पुकारा और उससे कहा, “ऐ हाजिरा, तुझ को क्या हुआ? मत डर, क्यूँकि ख़ुदा ने उस जगह से जहाँ लड़का पड़ा है उसकी आवाज़ सुन ली है। ");
INSERT INTO urd_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","उठ, और लड़के को उठा और उसे अपने हाथ से संभाल; क्यूँकि मैं उसको एक बड़ी क़ौम बनाऊँगा।” ");
INSERT INTO urd_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","फिर ख़ुदा ने उसकी आँखें खोलीं और उसने पानी का एक कुआँ देखा, और जाकर मश्क को पानी से भर लिया और लड़के को पिलाया। ");
INSERT INTO urd_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","और ख़ुदा उस लड़के के साथ था और वह बड़ा हुआ और वीराने में रहने लगा और तीरंदाज़ बना। ");
INSERT INTO urd_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","और वह फ़ारान के वीराने में रहता था, और उसकी माँ ने मुल्क — ए — मिस्र से उसके लिए बीवी ली। ");
INSERT INTO urd_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","फिर उस वक़्त यूँ हुआ, कि अबीमलिक और उसके लश्कर के सरदार फ़ीकुल ने अब्रहाम से कहा कि हर काम में जो तू करता है ख़ुदा तेरे साथ है। ");
INSERT INTO urd_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","इसलिए तू अब मुझ से ख़ुदा की क़सम खा, कि तू न मुझ से न मेरे बेटे से और न मेरे पोते से दग़ा करेगा; बल्कि जो मेहरबानी मैंने तुझ पर की है वैसे ही तू भी मुझ पर और इस मुल्क पर, जिसमें तूने क़याम किया है, करेगा। ");
INSERT INTO urd_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","तब अब्रहाम ने कहा, “मैं क़सम खाऊँगा।” ");
INSERT INTO urd_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","और अब्रहाम ने पानी के एक कुएँ की वजह से, जिसे अबीमलिक के नौकरों ने ज़बरदस्ती छीन लिया था, अबीमलिक को झिड़का। ");
INSERT INTO urd_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","अबीमलिक ने कहा, “मुझे ख़बर नहीं कि किसने यह काम किया, और तूने भी मुझे नहीं बताया, न मैंने आज से पहले इसके बारे में कुछ सुना।” ");
INSERT INTO urd_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","फिर अब्रहाम ने भेड़ बकरियाँ और गाय — बैल लेकर अबीमलिक को दिए और दोनों ने आपस में 'अहद किया। ");
INSERT INTO urd_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","अब्रहाम ने भेड़ के सात मादा बच्चों को लेकर अलग रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","और अबीमलिक ने अब्रहाम से कहा कि भेड़ के इन सात मादा बच्चों को अलग रखने से तेरा मतलब क्या है? ");
INSERT INTO urd_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","उसने कहा, कि भेड़ के इन सात मादा बच्चों को तू मेरे हाथ से ले ताकि वह मेरे गवाह हों कि मैंने यह कुआँ खोदा। ");
INSERT INTO urd_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","इसीलिए उसने उस मक़ाम का नाम बैरसबा' रख्खा, क्यूँकि वहीं उन दोनों ने क़सम खाई। ");
INSERT INTO urd_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","तब उन्होंने बैरसबा' में 'अहद किया, तब अबीमलिक और उसके लश्कर का सरदार फ़ीकुल दोनों उठ खड़े हुए और फ़िलिस्तियों के मुल्क को लौट गए। ");
INSERT INTO urd_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","तब अब्रहाम ने बैरसबा' में झाऊ का एक दरख़्त लगाया और वहाँ उसने ख़ुदावन्द से जो अबदी ख़ुदा है दुआ की। ");
INSERT INTO urd_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","और अब्रहाम बहुत दिनों तक फ़िलिस्तियों के मुल्क में रहा। ");
INSERT INTO urd_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","इन बातों के बाद यूँ हुआ कि ख़ुदा ने अब्रहाम को आज़माया और उसे कहा, ऐ अब्रहाम! “उसने कहा, मैं हाज़िर हूँ।” ");
INSERT INTO urd_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","तब उसने कहा कि तू अपने बेटे इस्हाक़ को जो तेरा इकलौता है और जिसे तू प्यार करता है, साथ लेकर मोरियाह के मुल्क में जा और वहाँ उसे पहाड़ों में से एक पहाड़ पर जो मैं तुझे बताऊँगा, सोख़्तनी क़ुर्बानी के तौर पर चढ़ा। ");
INSERT INTO urd_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","तब अब्रहाम ने सुबह सवेरे उठ कर अपने गधे पर चार जामा कसा और अपने साथ दो जवानों और अपने बेटे इस्हाक़ को लिया, और सोख़्तनी क़ुर्बानी के लिए लकड़ियाँ चीरी और उठ कर उस जगह को जो ख़ुदा ने उसे बताई थी रवाना हुआ। ");
INSERT INTO urd_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","तीसरे दिन अब्रहाम ने निगाह की और उस जगह को दूर से देखा। ");
INSERT INTO urd_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","तब अब्रहाम ने अपने जवानों से कहा, “तुम यहीं गधे के पास ठहरो, मैं और यह लड़का दोनों ज़रा वहाँ तक जाते हैं, और सिज्दा करके फिर तुम्हारे पास लौट आएँगे।” ");
INSERT INTO urd_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","और अब्रहाम ने सोख्त़नी क़ुर्बानी की लकड़ियाँ लेकर अपने बेटें इस्हाक़ पर रख्खीं, और आग और छुरी अपने हाथ में ली और दोनों इकट्ठे रवाना हुए। ");
INSERT INTO urd_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","तब इस्हाक़ ने अपने बाप अब्रहाम से कहा, ऐ बाप! “उसने जवाब दिया कि ऐ मेरे बेटे, मैं हाज़िर हूँ। उसने कहा, देख, आग और लकड़ियाँ तो हैं, लेकिन सोख़्तनी क़ुर्बानी के लिए बर्रा कहाँ है?” ");
INSERT INTO urd_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","अब्रहाम ने कहा, “ऐ मेरे बेटे ख़ुदा ख़ुद ही अपने लिए सोख़्तनी क़ुर्बानी के लिए बर्रा मुहय्या कर लेगा।” तब वह दोनों आगे चलते गए। ");
INSERT INTO urd_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","और उस जगह पहुँचे जो ख़ुदा ने बताई थी; वहाँ अब्रहाम ने क़ुर्बान गाह बनाई और उस पर लकड़ियाँ चुनीं और अपने बेटे इस्हाक़ को बाँधा और उसे क़ुर्बानगाह पर लकड़ियों के ऊपर रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","और अब्रहाम ने हाथ बढ़ाकर छुरी ली कि अपने बेटे को ज़बह करे। ");
INSERT INTO urd_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","तब ख़ुदावन्द के फ़रिश्ता ने उसे आसमान से पुकारा, कि ऐ अब्रहाम, ऐ अब्रहाम! उसने कहा, “मैं हाज़िर हूँ।” ");
INSERT INTO urd_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","फिर उसने कहा कि तू अपना हाथ लड़के पर न चला और न उससे कुछ कर; क्यूँकि मैं अब जान गया कि तू ख़ुदा से डरता है, इसलिए कि तूने अपने बेटे को भी जो तेरा इकलौता है मुझ से दरेग न किया। ");
INSERT INTO urd_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","और अब्रहाम ने निगाह की और अपने पीछे एक मेंढा देखा जिसके सींग झाड़ी में अटके थे; तब अब्रहाम ने जाकर उस मेंढे को पकड़ा और अपने बेटे के बदले सोख़्तनी क़ुर्बानी के तौर पर चढ़ाया। ");
INSERT INTO urd_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","और अब्रहाम ने उस मक़म का नाम यहोवा यरी रख्खा। चुनाँचे आज तक यह कहावत है कि ख़ुदावन्द के पहाड़ पर मुहय्या किया जाएगा। ");
INSERT INTO urd_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","और ख़ुदावन्द के फ़रिश्ते ने आसमान से दोबारा अब्रहाम को पुकारा और कहा कि। ");
INSERT INTO urd_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“ख़ुदावन्द फ़रमाता है, चूँकि तूने यह काम किया कि अपने बेटे की भी जो तेरा इकलौता है दरेग न रख्खा; इसलिए मैंने भी अपनी ज़ात की क़सम खाई है कि ");
INSERT INTO urd_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","मैं तुझे बरकत पर बरकत दूँगा, और तेरी नसल को बढ़ाते — बढ़ाते आसमान के तारों और समुन्दर के किनारे की रेत की तरह कर दूँगा, और तेरी औलाद अपने दुश्मनों के फाटक की मालिक होगी। ");
INSERT INTO urd_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","और तेरी नसल के वसीले से ज़मीन की सब क़ौमें बरकत पाएँगी, क्यूँकि तूने मेरी बात मानी।” ");
INSERT INTO urd_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","तब अब्रहाम अपने जवानों के पास लौट गया, और वह उठे और इकट्ठे बैरसबा' को गए; और अब्रहाम बैरसबा' में रहा। ");
INSERT INTO urd_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","इन बातों के बाद यूँ हुआ कि अब्रहाम को यह ख़बर मिली, कि मिल्काह के भी तेरे भाई नहूर से बेटे हुए हैं। ");
INSERT INTO urd_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","या'नी ऊज़ जो उसका पहलौठा है, और उसका भाई बूज़ और क्रमूएल, अराम का बाप, ");
INSERT INTO urd_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","और कसद और हजू और फ़िल्दास और इद्लाफ़ और बैतूएल। ");
INSERT INTO urd_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","और बैतूएल से रिब्क़ा पैदा हुई। यह आठों अब्रहाम के भाई नहूर से मिल्काह के पैदा हुए। ");
INSERT INTO urd_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","और उसकी बाँदी से भी जिसका नाम रूमा था, तिबख़ और जाहम और तख़स और मा'का पैदा हुए। ");
INSERT INTO urd_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","और सारा की उम्र एक सौ सताईस साल की हुई, सारा की ज़िन्दगी के इतने ही साल थे। ");
INSERT INTO urd_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","और सारा ने करयतअरबा' में वफ़ात पाई। यह कनान में है और हबरून भी कहलाता है। और अब्रहाम सारा के लिए मातम और नौहा करने को वहाँ गया। ");
INSERT INTO urd_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","फिर अब्रहाम मय्यत के पास से उठ कर बनी — हित से बातें करने लगा और कहा कि। ");
INSERT INTO urd_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","मैं तुम्हारे बीच परदेसी और ग़रीब — उल — वतन हूँ। तुम अपने यहाँ क़ब्रिस्तान के लिए कोई मिलिकयत मुझे दो, ताकि मैं अपने मुर्दे को आँख के सामने से हटाकर दफ़्न कर दूँ। ");
INSERT INTO urd_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","तब बनीहित ने अब्रहाम को जवाब दिया कि। ");
INSERT INTO urd_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","ऐ ख़ुदावन्द हमारी सुनः तू हमारे बीच ज़बरदस्त सरदार है। हमारी कब्रों में जो सबसे अच्छी हो उसमें तू अपने मुर्दे को दफ़्न कर; हम में ऐसा कोई नहीं जो तुझ से अपनी क़ब्र का इन्कार करे, ताकि तू अपना मुर्दा दफ़न न कर सके। ");
INSERT INTO urd_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","अब्रहाम ने उठ कर और बनी — हित के आगे, जो उस मुल्क के लोग हैं, आदाब बजा लाकर ");
INSERT INTO urd_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","उनसे यूँ बातें की, कि अगर तुम्हारी मर्ज़ी हो कि मैं अपने मुर्दे को आँख के सामने से हटाकर दफ़्न कर दूँ, तो मेरी 'अर्ज़ सुनो, और सुहर के बेटे इफ़रोन से मेरी सिफ़ारिश करो, ");
INSERT INTO urd_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","कि वह मकफ़ीला के ग़ार को जो उसका है और उसके खेत के किनारे पर है, उसकी पूरी क़ीमत लेकर मुझे दे दे, ताकि वह क़ब्रिस्तान के लिए तुम्हारे बीच मेरी मिल्कियत हो जाए। ");
INSERT INTO urd_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","और 'इफ़रोन बनी-हित के बीच बैठा था। तब 'इफ़रोन हित्ती ने बनी हित के सामने, उन सब लोगों के आमने सामने जो उसके शहर के दरवाज़े से दाख़िल होते थे अब्रहाम को जवाब दिया, ");
INSERT INTO urd_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“ऐ मेरे ख़ुदावन्द! यूँ न होगा, बल्कि मेरी सुन! मैं यह खेत तुझे देता हूँ, और वह ग़ार भी जो उसमें है तुझे दिए देता हूँ। यह मैं अपनी क़ौम के लोगों के सामने तुझे देता हूँ, तू अपने मुर्दे को दफ़्न कर।” ");
INSERT INTO urd_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","तब अब्रहाम उस मुल्क के लोगों के सामने झुका। ");
INSERT INTO urd_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","फिर उसने उस मुल्क के लोगों के सुनते हुए 'इफ़रोन से कहा कि अगर तू देना ही चाहता है तो मेरी सुन, मैं तुझे उस खेत का दाम दूँगा; यह तू मुझ से ले ले, तो मैं अपने मुर्दे को वहाँ दफ़्न करूँगा। ");
INSERT INTO urd_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","इफ़रोन ने अब्रहाम को जवाब दिया, ");
INSERT INTO urd_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“ऐ मेरे ख़ुदावन्द, मेरी बात सुन; यह ज़मीन चाँदी की चार सौ मिस्काल की है इसलिए मेरे और तेरे बीच यह है क्या? तब अपना मुर्दा दफ़न कर।” ");
INSERT INTO urd_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","और अब्रहाम ने 'इफ़रोन की बात मान ली; इसलिए अब्रहाम ने इफ़रोन को उतनी ही चाँदी तौल कर दी, जितनी का ज़िक्र उसने बनी — हित के सामने किया था, या'नी चाँदी के चार सौ मिस्काल जो सौदागरों में राइज थी। ");
INSERT INTO urd_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","इसलिए इफ़रोन का वह खेत जो मकफ़ीला में ममरे के सामने था, और वह ग़ार जो उसमें था, और सब दरख़्त जो उस खेत में और उसके चारों तरफ़ की हदूद में थे, ");
INSERT INTO urd_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","यह सब बनी — हित के और उन सबके आमने सामने जो उसके शहर के दरवाज़े से दाख़िल होते थे, अब्रहाम की ख़ास मिल्कियत क़रार दिए गए। ");
INSERT INTO urd_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","इसके बाद अब्रहाम ने अपनी बीवी सारा को मकफ़ीला के खेत के ग़ार में, जो मुल्कए — कना'न में ममरे या'नी हबरून के सामने है, दफ़्न किया। ");
INSERT INTO urd_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","चुनाँचे वह खेत और वह ग़ार जो उसमें था, बनी — हित की तरफ़ से क़ब्रिस्तान के लिए अब्रहाम की मिल्कियत क़रार दिए गए। ");
INSERT INTO urd_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","और अब्रहाम ज़ईफ़ और उम्र दराज़ हुआ और ख़ुदावन्द ने सब बातों में अब्रहाम को बरकत बख़्शी थी। ");
INSERT INTO urd_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","और अब्रहाम ने अपने घर के ख़ास नौकर से, जो उसकी सब चीज़ों का मुख़्तार था कहा, तू अपना हाथ ज़रा मेरी रान के नीचे रख कि। ");
INSERT INTO urd_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","मैं तुझ से ख़ुदावन्द की जो ज़मीन — ओ — आसमान का ख़ुदा है क़सम लें, कि तू कना'नियों की बेटियों में से जिनमें मैं रहता हूँ, किसी को मेरे बेटे से नहीं ब्याहेगा। ");
INSERT INTO urd_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","बल्कि तू मेरे वतन में मेरे रिश्तेदारों के पास जा कर मेरे बेटे इस्हाक़ के लिए बीवी लाएगा। ");
INSERT INTO urd_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","उस नौकर ने उससे कहा, “शायद वह 'औरत इस मुल्क में मेरे साथ आना न चाहे; तो क्या मैं तेरे बेटे को उस मुल्क में जहाँ से तू आया फिर ले जाऊँ?” ");
INSERT INTO urd_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","तब अब्रहाम ने उससे कहा ख़बरदार तू मेरे बेटे को वहाँ हरगिज़ न ले जाना। ");
INSERT INTO urd_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ख़ुदावन्द, आसमान का ख़ुदा, जो मुझे मेरे बाप के घर और मेरी पैदाइशी जगह से निकाल लाया, और जिसने मुझ से बातें कीं और क़सम खाकर मुझ से कहा, कि मैं तेरी नसल को यह मुल्क दूँगा; वही तेरे आगे — आगे अपना फ़िरिश्ता भेजेगा कि तू वहाँ से मेरे बेटे के लिए बीवी लाए। ");
INSERT INTO urd_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","और अगर वह 'औरत तेरे साथ आना न चाहे, तो तू मेरी इस क़सम से छूटा, लेकिन मेरे बेटे को हरगिज़ वहाँ न ले जाना। ");
INSERT INTO urd_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","उस नौकर ने अपना हाथ अपने आक़ा अब्रहाम की रान के नीचे रख कर उससे इस बात की क़सम खाई। ");
INSERT INTO urd_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","तब वह नौकर अपने आक़ा के ऊँटों में से दस ऊँट लेकर रवाना हुआ, और उसके आक़ा की अच्छी अच्छी चीज़ें उसके पास थीं, और वह उठकर मसोपतामिया में नहूर के शहर को गया। ");
INSERT INTO urd_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","और शाम को जिस वक़्त 'औरतें पानी भरने आती है उस ने उस शहर के बाहर बावली के पास ऊँटों को बिठाया। ");
INSERT INTO urd_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","और कहा, “ऐ ख़ुदावन्द, मेरे आक़ा अब्रहाम के खुदा, मैं तेरी मिन्नत करता हूँ के आज तू मेरा काम बना दे, और मेरे आक़ा अब्रहाम पर करम कर। ");
INSERT INTO urd_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","देख, मैं पानी के चश्मा पर खड़ा हूँ और इस शहर के लोगों की बेटियाँ पानी भरने को आती हैं; ");
INSERT INTO urd_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","इसलिए ऐ ख़ुदावन्द ऐसा हो कि जिस लड़की से मैं कहूँ, कि तू ज़रा अपना घड़ा झुका दे तो मैं पानी पी लूँ और वह कहे, कि ले पी, और मैं तेरे ऊँटों को भी पिला दूँगी'; तो वह वही हो जिसे तूने अपने बन्दे इस्हाक़ के लिए ठहराया है; और इसी से मैं समझ लूँगा कि तूने मेरे आक़ा पर करम किया है।” ");
INSERT INTO urd_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","वह यह कह ही रहा था कि रिब्क़ा, जो अब्रहाम के भाई नहूर की बीवी मिल्काह के बेटे बैतूएल से पैदा हुई थी, अपना घड़ा कंधे पर लिए हुए निकली। ");
INSERT INTO urd_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","वह लड़की निहायत ख़ूबसूरत और कुंवारी, और मर्द से नवाक़िफ़ थी। वह नीचे पानी के चश्मा के पास गई और अपना घड़ा भर कर ऊपर आई। ");
INSERT INTO urd_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","तब वह नौकर उससे मिलने को दौड़ा और कहा कि ज़रा अपने घड़े से थोड़ा सा पानी मुझे पिला दे। ");
INSERT INTO urd_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","उसने कहा, पीजिए साहब; “और फ़ौरन घड़े को हाथ पर उतार उसे पानी पिलाया। ");
INSERT INTO urd_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","जब उसे पिला चुकी तो कहने लगी, कि मैं तेरे ऊँटों के लिए भी पानी भर — भर लाऊँगी, जब तक वह पी न चुकें।” ");
INSERT INTO urd_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","और फ़ौरन अपने घड़े को हौज़ में ख़ाली करके फिर बावली की तरफ़ पानी भरने दौड़ी गई, और उसके सब ऊँटों के लिए भरा। ");
INSERT INTO urd_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","वह आदमी चुप — चाप उसे ग़ौर से देखता रहा, ताकि मा'लूम करे कि ख़ुदावन्द ने उसका सफ़र मुबारक किया है या नहीं। ");
INSERT INTO urd_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","और जब ऊँट पी चुके तो उस शख़्स ने आधे मिस्काल सोने की एक नथ, और दस मिस्काल सोने के दो कड़े उसके हाथों के लिए निकाले। ");
INSERT INTO urd_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","और कहा कि ज़रा मुझे बता कि तू किसकी बेटी है? और क्या तेरे बाप के घर में हमारे टिकने की जगह है? ");
INSERT INTO urd_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","उसने उससे कहा कि मैं बैतूएल की बेटी हूँ। वह मिल्काह का बेटा है जो नहूर से उसके हुआ। ");
INSERT INTO urd_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","और यह भी उससे कहा कि हमारे पास भूसा और चारा बहुत है, और टिकने की जगह भी है। ");
INSERT INTO urd_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","तब उस आदमी ने झुक कर ख़ुदावन्द को सिज्दा किया, ");
INSERT INTO urd_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","और कहा, “ख़ुदावन्द मेरे आक़ा अब्रहाम का ख़ुदा मुबारक हो, जिसने मेरे आक़ा को अपने करम और सच्चाई से महरूम नहीं रख्खा और मुझे तो ख़ुदावन्द ठीक राह पर चलाकर मेरे आक़ा के भाइयों के घर लाया।” ");
INSERT INTO urd_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","तब उस लड़की ने दौड़ कर अपनी माँ के घर में यह सब हाल कह सुनाया। ");
INSERT INTO urd_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","और रिब्क़ा का एक भाई था जिसका नाम लाबन था; वह बाहर पानी के चश्मा पर उस आदमी के पास दौड़ा गया। ");
INSERT INTO urd_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","और ऐसा हुआ कि जब उसने वह नथ देखी, और वह कड़े भी जो उसकी बहन के हाथों में थे, और अपनी बहन रिब्क़ा का बयान भी सुन लिया कि उस शख़्स ने मुझ से ऐसी — ऐसी बातें कहीं, तो वह उस आदमी के पास आया और देखा कि वह चश्मा के नज़दीक ऊँटों के पास खड़ा है। ");
INSERT INTO urd_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","तब उससे कहा, “ऐ, तू जो ख़ुदावन्द की तरफ़ से मुबारक है। अन्दर चल, बाहर क्यूँ खड़ा है? मैंने घर को और ऊँटों के लिए भी जगह को तैयार कर लिया है।” ");
INSERT INTO urd_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","तब वह आदमी घर में आया, और उसने उसके ऊँटों को खोला और ऊँटों के लिए भूसा और चारा, और उसके और उसके साथ के आदमियों के पॉव धोने को पानी दिया। ");
INSERT INTO urd_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","और खाना उसके आगे रख्खा गया, लेकिन उसने कहा कि मैं जब तक अपना मतलब बयान न कर लूँ नहीं खाऊँगा। उसने कहा, अच्छा, कह। ");
INSERT INTO urd_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","तब उसने कहा कि मैं अब्रहाम का नौकर हूँ। ");
INSERT INTO urd_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","और ख़ुदावन्द ने मेरे आक़ा को बड़ी बरकत दी है, और वह बहुत बड़ा आदमी हो गया है; और उसने उसे भेड़ — बकरियाँ, और गाय बैल और सोना चाँदी और लौंडिया और ग़ुलाम और ऊँट और गधे बख़्शे हैं। ");
INSERT INTO urd_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","और मेरे आक़ा की बीवी सारा के जब वह बुढ़िया हो गई, उससे एक बेटा हुआ। उसी को उसने अपना सब कुछ दे दिया है। ");
INSERT INTO urd_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","और मेरे आक़ा ने मुझे क़सम दे कर कहा है, कि तू कना'नियों की बेटियों में से, जिनके मुल्क में मैं रहता हूँ किसी को मेरे बेटे से न ब्याहना। ");
INSERT INTO urd_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","बल्कि तू मेरे बाप के घर और मेरे रिश्तेदारों में जाना और मेरे बेटे के लिए बीवी लाना। ");
INSERT INTO urd_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","तब मैंने अपने आक़ा से कहा, 'शायद वह 'औरत मेरे साथ आना न चाहे। ");
INSERT INTO urd_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","तब उसने मुझ से कहा, 'ख़ुदावन्द, जिसके सामने मैं चलता रहा हूँ, अपना फ़रिश्ता तेरे साथ भेजेगा और तेरा सफ़र मुबारक करेगा; तू मेरे रिश्तेदारों और मेरे बाप के ख़ान्दान में से मेरे बेटे के लिए बीवी लाना। ");
INSERT INTO urd_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","और जब तू मेरे ख़ान्दान में जा पहुँचेगा, तब मेरी क़सम से छूटेगा; और अगर वह कोई लड़की न दें, तो भी तू मेरी क़सम से छूटा। ");
INSERT INTO urd_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","इसलिए मैं आज पानी के उस चश्मा पर आकर कहने लगा, 'ऐ ख़ुदावन्द, मेरे आक़ा अब्रहाम के ख़ुदा, अगर तू मेरे सफ़र को जो मैं कर रहा हूँ मुबारक करता है। ");
INSERT INTO urd_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","तो देख, मैं पानी के चश्मा के पास खड़ा होता हूँ, और ऐसा हो कि जो लड़की पानी भरने निकले और मैं उससे कहूँ, 'ज़रा अपने घड़े से थोड़ा पानी मुझे पिला दे, ");
INSERT INTO urd_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","और वह मुझे कहे कि तू भी पी और मैं तेरे ऊँटों के लिए भी भर दूँगी, तो वो वही 'औरत हो जिसे ख़ुदावन्द ने मेरे आक़ा के बेटे के लिए ठहराया है। ");
INSERT INTO urd_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","मैं दिल में यह कह ही रहा था कि रिब्क़ा अपना घड़ा कन्धे पर लिए हुए बाहर निकली, और नीचे चश्मा के पास गई, और पानी भरा। तब मैंने उससे कहा, 'ज़रा मुझे पानी पिला दे। ");
INSERT INTO urd_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","उसने फ़ौरन अपना घड़ा कन्धे पर से उतारा और कहा, 'ले पी और मैं तेरे ऊँटों को भी पिला दूँगी। तब मैंने पिया और उसने मेरे ऊँटों को भी पिलाया। ");
INSERT INTO urd_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","फिर मैंने उससे पूछा, 'तू किसकी बेटी है?' उसने कहा, 'मैं बैतूएल की बेटी हूँ, वह नहूर का बेटा है जो मिल्काह से पैदा हुआ; फिर मैंने उसकी नाक में नथ और उसके हाथों में कड़े पहना दिए। ");
INSERT INTO urd_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","और मैंने झुक कर ख़ुदावन्द को सिज्दा किया और ख़ुदावन्द, अपने आक़ा अब्रहाम के ख़ुदा को मुबारक कहा, जिसने मुझे ठीक राह पर चलाया कि अपने आक़ा के भाई की बेटी उसके बेटे के लिए ले जाऊँ। ");
INSERT INTO urd_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","इसलिए अब अगर तुम करम और सच्चाई से मेरे आक़ा के साथ पेश आना चाहते हो तो मुझे बताओ, और अगर नहीं तो कह दो, ताकि मैं दहनी या बाएँ तरफ़ फिर जाऊँ। ");
INSERT INTO urd_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","तब लाबन और बैतूएल ने जवाब दिया, कि यह बात ख़ुदावन्द की तरफ़ से हुई है, हम तुझे कुछ बुरा या भला नहीं कह सकते। ");
INSERT INTO urd_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","देख, रिब्क़ा तेरे सामने मौजूद है, उसे ले और जा, और ख़ुदावन्द के क़ौल के मुताबिक़ अपने आक़ा के बेटे से उसे ब्याह दे। ");
INSERT INTO urd_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","जब अब्रहाम के नौकर ने उनकी बातें सुनीं, तो ज़मीन तक झुक कर ख़ुदावन्द को सिज्दा किया। ");
INSERT INTO urd_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","और नौकर ने चाँदी और सोने के ज़ेवर, और लिबास निकाल कर रिब्क़ा को दिए, और उसके भाई और उसकी माँ को भी क़ीमती चीजें दीं। ");
INSERT INTO urd_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","और उसने और उसके साथ के आदमियों ने खाया पिया और रात भर वहीं रहे; सुबह को वह उठे और उसने कहा, कि मुझे मेरे आक़ा के पास रवाना कर दो। ");
INSERT INTO urd_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","रिब्क़ा के भाई और माँ ने कहा, कि लड़की को कुछ दिन, कम से कम दस दिन, हमारे पास रहने दे; इसके बाद वह चली जाएगी। ");
INSERT INTO urd_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","उसने उनसे कहा, कि मुझे न रोको क्यूँकि ख़ुदावन्द ने मेरा सफ़र मुबारक किया है, मुझे रुख़्सत कर दो ताकि मैं अपने आक़ा के पास जाऊँ। ");
INSERT INTO urd_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","उन्होंने कहा, “हम लड़की को बुलाकर पूछते हैं कि वह क्या कहती है।” ");
INSERT INTO urd_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","तब उन्होंने रिब्क़ा को बुला कर उससे पूछा, “क्या तू इस आदमी के साथ जाएगी?” उसने कहा, “जाऊँगी।” ");
INSERT INTO urd_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","तब उन्होंने अपनी बहन रिब्क़ा और उसकी दाया और अब्रहाम के नौकर और उसके आदमियों को रुख़सत किया। ");
INSERT INTO urd_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","और उन्होंने रिब्क़ा को दुआ दी और उससे कहा, “ऐ हमारी बहन, तू लाखों की माँ हो और तेरी नसल अपने कीना रखने वालों के फाटक की मालिक हो।” ");
INSERT INTO urd_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","और रिब्क़ा और उसकी सहेलियाँ उठकर ऊँटों पर सवार हुई, और उस आदमी के पीछे हो लीं। तब वह आदमी रिब्क़ा को साथ लेकर रवाना हुआ। ");
INSERT INTO urd_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","और इस्हाक़ बेरलही — रोई से होकर चला आ रहा था, क्यूँकि वह दख्खिन के मुल्क में रहता था। ");
INSERT INTO urd_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","और शाम के वक़्त इस्हाक़ बैतुलख़ला को मैदान में गया, और उसने जो अपनी आँखें उठाई और नज़र की तो क्या देखता है कि ऊँट चले आ रहे हैं। ");
INSERT INTO urd_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","और रिब्क़ा ने निगाह की और इस्हाक़ को देख कर ऊँट पर से उतर पड़ी। ");
INSERT INTO urd_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","और उसने नौकर से पूछा, “यह शख़्स कौन है जो हम से मिलने की मैदान में चला आ रहा है?” उस नौकर ने कहा, “यह मेरा आक़ा है।” तब उसने बुरक़ा लेकर अपने ऊपर डाल लिया। ");
INSERT INTO urd_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","नौकर ने जो — जो किया था सब इस्हाक़ को बताया। ");
INSERT INTO urd_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","और इस्हाक़ रिब्क़ा को अपनी माँ सारा के डेरे में ले गया। तब उसने रिब्क़ा से ब्याह कर लिया और उससे मुहब्बत की, और इस्हाक़ ने अपनी माँ के मरने के बाद तसल्ली पाई। ");
INSERT INTO urd_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","और अब्रहाम ने फिर एक और बीवी की जिसका नाम क़तूरा था। ");
INSERT INTO urd_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","और उससे ज़िम्रान और युकसान और मिदान और मिदियान और इसबाक़ और सूख़ पैदा हुए। ");
INSERT INTO urd_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","और युकसान से सिबा और ददान पैदा हुए, और ददान की औलाद से असूरी और लतूसी और लूमी थे। ");
INSERT INTO urd_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","और मिदियान के बेटे ऐफ़ा और इफ़िर और हनूक और अबीदा'आ और इल्दू'आ थे; यह सब बनी क़तूरा थे। ");
INSERT INTO urd_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","और अब्रहाम ने अपना सब कुछ इस्हाक़ को दिया। ");
INSERT INTO urd_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","और अपनी बाँदियों के बेटों को अब्रहाम ने बहुत कुछ इनाम देकर अपने जीते जी उनको अपने बेटे इस्हाक़ के पास से मशरिक़ की तरफ़ या'नी मशरिक़ के मुल्क में भेज दिया। ");
INSERT INTO urd_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","और अब्रहाम की कुल उम्र जब तक कि वह जिन्दा रहा एक सौ पिच्छत्तर साल की हुई। ");
INSERT INTO urd_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","तब अब्रहाम ने दम छोड़ दिया और ख़ूब बुढ़ापे में निहायत ज़ईफ़ और पूरी उम्र का होकर वफ़ात पाई, और अपने लोगों में जा मिला। ");
INSERT INTO urd_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","और उसके बेटे इस्हाक़ और इस्मा'ईल ने मकफ़ीला के ग़ार में, जो ममरे के सामने हित्ती सुहर के बेटे इफ़रोन के खेत में है, उसे दफ़्न किया। ");
INSERT INTO urd_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","यह वही खेत है जिसे अब्रहाम ने बनी — हित से ख़रीदा था; वहीं अब्रहाम और उसकी बीवी सारा दफ़्न हुए। ");
INSERT INTO urd_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","और अब्रहाम की वफ़ात के बाद ख़ुदा ने उसके बेटे इस्हाक़ को बरकत बख़्शी और इस्हाक़ बैर — लही — रोई के नज़दीक रहता था। ");
INSERT INTO urd_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","यह नसबनामा अब्रहाम के बेटे इस्मा'ईल का है जो अब्रहाम से सारा की लौंडी हाजिरा मिस्री के बत्न से पैदा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","और इस्मा'ईल के बेटों के नाम यह है: यह नाम तरतीबवार उनकी पैदाइश के मुताबिक़ हैं, इस्मा'ईल का पहलौठा नबायोत था, फिर कीदार और अदबिएल और मिबसाम, ");
INSERT INTO urd_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","और मिशमा' और दूमा और मस्सा, ");
INSERT INTO urd_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदद और तेमा और यतूर और नफ़ीस और क़िदमा। ");
INSERT INTO urd_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","यह इस्मा'ईल के बेटे हैं और इन्ही के नामों से इनकी बस्तियां और छावनियाँ नामज़द हुई और यही बारह अपने अपने क़बीले के सरदार हुए। ");
INSERT INTO urd_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","और इस्मा'ईल की कुल उम्र एक सौ सैंतीस साल की हुई तब उसने दम छोड़ दिया और वफ़ात पाई और अपने लोगों में जा मिला। ");
INSERT INTO urd_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","और उसकी औलाद हवीला से शोर तक, जो मिस्र के सामने उस रास्ते पर है जिस से असूर को जाते हैं आबाद थी। यह लोग अपने सब भाइयों के सामने बसे हुए थे। ");
INSERT INTO urd_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","और अब्रहाम के बेटे इस्हाक़ का नसबनामा यह है: अब्रहाम से इस्हाक़ पैदा हुआ: ");
INSERT INTO urd_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","इस्हाक़ चालीस साल का था जब उसने रिब्क़ा से ब्याह किया, जो फ़द्दान अराम के बाशिन्दे बैतूएल अरामी की बेटी और लाबन अरामी की बहन थी। ");
INSERT INTO urd_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","और इस्हाक़ ने अपनी बीवी के लिए ख़ुदावन्द से दुआ की, क्यूँकि वह बाँझ थी; और ख़ुदावन्द ने उसकी दुआ क़ुबूल की, और उसकी बीवी रिब्क़ा हामिला हुई। ");
INSERT INTO urd_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","और उसके पेट में दो लड़के आपस में मुज़ाहमत करने लगे। तब उसने कहा, “अगर ऐसा ही है तो मैं जीती क्यूँ हूँ?” और वह ख़ुदावन्द से पूछने गई। ");
INSERT INTO urd_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ख़ुदावन्द ने उससे कहा, “दो क़ौमें तेरे पेट में हैं, और दो क़बीले तेरे बत्न से निकलते ही अलग — अलग हो जाएँगे। और एक क़बीला दूसरे क़बीले से ताक़तवर होगा, और बड़ा छोटे की ख़िदमत करेगा।” ");
INSERT INTO urd_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","और जब उसके बच्चा पैदा होने के दिन पूरे हुए, तो क्या देखते हैं कि उसके पेट में जुड़वां बच्चे हैं। ");
INSERT INTO urd_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","और पहला जो पैदा हुआ तो सुर्ख़ था और ऊपर से ऐसा जैसे ऊनी कपड़ा, और उन्होंने उसका नाम 'ऐसौ रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","उसके बाद उसका भाई पैदा हुआ और उसका हाथ 'ऐसौ की एड़ी को पकड़े हुए था, और उसका नाम या'क़ूब रख्खा गया; जब वह रिब्क़ा से पैदा हुए तो इस्हाक़ साठ साल का था। ");
INSERT INTO urd_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","और वह लड़के बढ़े, और 'ऐसौ शिकार में माहिर हो गया और जंगल में रहने लगा, और या'क़ूब सादा मिजाज़ डेरों में रहने वाला आदमी था। ");
INSERT INTO urd_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","और इस्हाक़ 'ऐसौ को प्यार करता था क्यूँकि वह उसके शिकार का गोश्त खाता था और रिब्क़ा या'क़ूब को प्यार करती थी। ");
INSERT INTO urd_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","और या'क़ूब ने दाल पकाई, और 'ऐसौ जंगल से आया और वह बहुत भूका था। ");
INSERT INTO urd_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","और 'ऐसौ ने या'क़ूब से कहा, “यह जो लाल — लाल है मुझे खिला दे, क्यूँकि मैं बे — दम हो रहा हूँ।” इसी लिए उसका नाम अदोम भी हो गया। ");
INSERT INTO urd_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","तब या'क़ूब ने कहा, “तू आज अपने पहलौठे का हक़ मेरे हाथ बेच दे।” ");
INSERT INTO urd_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","'ऐसौ ने कहा, “देख, मैं तो मरा जाता हूँ, पहलौठे का हक़ मेरे किस काम आएगा?” ");
INSERT INTO urd_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","तब या'क़ूब ने कहा कि आज ही मुझ से क़सम खा, उसने उससे क़सम खाई; और उसने अपना पहलौठे का हक़ या'क़ूब के हाथ बेच दिया। ");
INSERT INTO urd_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","तब या'क़ूब ने 'ऐसौ को रोटी और मसूर की दाल दी; वह खा — पीकर उठा और चला गया। यूँ 'ऐसौ ने अपने पहलौठे के हक़ की क़द्र न जाना। ");
INSERT INTO urd_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","और उस मुल्क में उस पहले काल के 'अलावा जो अब्रहाम के दिनों में पड़ा था, फिर काल पड़ा। तब इस्हाक़ ज़िरार को फ़िलिस्तियों के बादशाह अबीमलिक के पास गया। ");
INSERT INTO urd_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","और ख़ुदावन्द ने उस पर ज़ाहिर हो कर कहा कि मिस्र को न जा; बल्कि जो मुल्क मैं तुझे बताऊँ उसमें रह। ");
INSERT INTO urd_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","तू इसी मुल्क में क़याम रख और मैं तेरे साथ रहूँगा और तुझे बरकत बख्शुंगा क्यूँकि मै तुझे और तेरी नसल को यह सब मुल्क दूँगा, और मैं उस क़सम को जो मैंने तेरे बाप अब्रहाम से खाई पूरा करूँगा। ");
INSERT INTO urd_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","और मैं तेरी औलाद को बढ़ा कर आसमान के तारों की तरह कर दूँगा, और यह सब मुल्क तेरी नसल को दूँगा, और ज़मीन की सब कौमें तेरी नसल के वसीले से बरकत पाएँगी। ");
INSERT INTO urd_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","इसलिए कि अब्रहाम ने मेरी बात मानी, और मेरी नसीहत और मेरे हुक्मों और कवानीन — ओ — आईन पर 'अमल किया। ");
INSERT INTO urd_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","फिर इस्हाक़ ज़िरार में रहने लगा; ");
INSERT INTO urd_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","और वहाँ के बाशिन्दों ने उससे उसकी बीवी के बारे में पूछा। उसने कहा, वह मेरी बहन है, क्यूँकि वह उसे अपनी बीवी बताते डरा, यह सोच कर कि कहीं रिबक़ा की वजह से वहाँ के लोग उसे क़त्ल न कर डालें, क्यूँकि वह ख़ूबसूरत थी। ");
INSERT INTO urd_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","जब उसे वहाँ रहते बहुत दिन हो गए तो, फ़िलिस्तियों के बादशाह अबीमलिक ने खिड़की में से झाँक कर नज़र की और देखा कि इस्हाक़ अपनी बीवी रिब्क़ा से हँसी खेल कर रहा है। ");
INSERT INTO urd_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","तब अबीमलिक ने इस्हाक़ को बुला कर कहा, “वह तो हक़ीक़त में तेरी बीवी है; फिर तूने क्यूँ कर उसे अपनी बहन बताया?” इस्हाक़ ने उससे कहा, “इसलिए कि मुझे ख़्याल हुआ कि कहीं मैं उसकी वजह से मारा न जाऊँ।” ");
INSERT INTO urd_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","अबीमलिक ने कहा, “तूने हम से क्या किया? यूँ तो आसानी से इन लोगों में से कोई तेरी बीवी के साथ मुबाश्रत कर लेता, और तू हम पर इल्ज़ाम लाता।” ");
INSERT INTO urd_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","तब अबीमलिक ने सब लोगों को यह हुक्म किया कि जो कोई इस आदमी को या इसकी बीवी को छुएगा वह मार डाला जाएगा। ");
INSERT INTO urd_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","और इस्हाक़ ने उस मुल्क में खेती की और उसी साल उसे सौ गुना फल मिला; और ख़ुदावन्द ने उसे बरकत बख़्शी। ");
INSERT INTO urd_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","और वह बढ़ गया और उसकी तरक़्क़ी होती गई, यहाँ तक कि वह बहुत बड़ा आदमी हो गया। ");
INSERT INTO urd_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","और उसके पास भेड़ बकरियाँ और गाय बैल और बहुत से नौकर चाकर थे, और फ़िलिस्तियों को उस पर रश्क आने लगा। ");
INSERT INTO urd_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","और उन्होंने सब कुएँ जो उसके बाप के नौकरों ने उसके बाप अब्रहाम के वक़्त में खोदे थे, बन्द कर दिए और उनको मिट्टी से भर दिया। ");
INSERT INTO urd_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","और अबीमलिक ने इस्हाक़ से कहा कि तू हमारे पास से चला जा, क्यूँकि तू हम से ज़्यादा ताक़तवर हो गया है। ");
INSERT INTO urd_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","तब इस्हाक़ ने वहाँ से जिरार की वादी में जाकर अपना डेरा लगाया और वहाँ रहने लगा। ");
INSERT INTO urd_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","और इस्हाक़ ने पानी के उन कुओं को जो उसके बाप अब्रहाम के दिनों में खोदे गए थे फिर खुदवाया, क्यूँकि फ़िलिस्तियों ने अब्रहाम के मरने के बाद उनको बन्द कर दिया था, और उसने उनके फिर वही नाम रख्खे जो उसके बाप ने रख्खे थे। ");
INSERT INTO urd_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","और इस्हाक़ के नौकरों को वादी में खोदते — खोदते बहते पानी का एक सोता मिल गया। ");
INSERT INTO urd_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","तब जिरार के चरवाहों ने इस्हाक़ के चरवाहों से झगड़ा किया और कहने लगे कि यह पानी हमारा है। और उसने उस कुएँ का नाम 'इस्क़ रख्खा, क्यूँकि उन्होंने उससे झगड़ा किया। ");
INSERT INTO urd_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","और उन्होंने दूसरा कुआँ खोदा, और उसके लिए भी वह झगड़ने लगे; और उसने उसका नाम सितना रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","इसलिए वह वहाँ से दूसरी जगह चला गया और एक और कुआँ खोदा, जिसके लिए उन्होंने झगड़ा न किया और उसने उसका नाम रहोबूत रख्खा और कहा किअब ख़ुदावन्द ने हमारे लिए जगह निकाली और हम इस मुल्क में कामयाब होंगे। ");
INSERT INTO urd_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","वहाँ से वह बैरसबा' को गया। ");
INSERT INTO urd_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","और ख़ुदावन्द उसी रात उस पर ज़ाहिर हुआ और कहा कि मैं तेरे बाप अब्रहाम का ख़ुदा हूँ! मत डर, क्यूँकि मैं तेरे साथ हूँ और तुझे बरकत दूँगा, और अपने बन्दे अब्रहाम की ख़ातिर तेरी नसल बढ़ाऊँगा। ");
INSERT INTO urd_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","और उसने वहाँ मज़बह बनाया और ख़ुदावन्द से दुआ की, और अपना डेरा वहीं लगा लिया; और वहाँ इस्हाक़ के नौकरों ने एक कुआँ खोदा। ");
INSERT INTO urd_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","तब अबीमलिक अपने दोस्त अख़ूज़त और अपने सिपहसालार फ़ीकुल को साथ ले कर, जिरार से उसके पास गया। ");
INSERT INTO urd_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","इस्हाक़ ने उनसे कहा कि तुम मेरे पास क्यूँ कर आए, हालाँकि मुझ से कीना रखते हो और मुझ को अपने पास से निकाल दिया। ");
INSERT INTO urd_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","उन्होंने कहा, “हम ने ख़ूब सफ़ाई से देखा कि ख़ुदावन्द तेरे साथ है, तब हम ने कहा कि हमारे और तेरे बीच क़सम हो जाए और हम तेरे साथ 'अहद करें, ");
INSERT INTO urd_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","कि जैसे हम ने तुझे छुआ तक नहीं, और अलावा नेकी के तुझ से और कुछ नहीं किया और तुझ को सलामत रुख़्सत, किया तू भी हम से कोई बदी न करेगा क्यूँकि तू अब ख़ुदावन्द की तरफ़ से मुबारक है।” ");
INSERT INTO urd_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","तब उसने उनके लिए दावत तैयार की और उन्होंने खाया पिया। ");
INSERT INTO urd_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","और वह सुबह सवेरे उठे और आपस में क़सम खाई; और इस्हाक़ ने उन्हें रुख़्सत किया और वह उसके पास से सलामत चले गए। ");
INSERT INTO urd_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","उसी रोज़ इस्हाक़ के नौकरों ने आ कर उससे उस कुएँ का ज़िक्र किया जिसे उन्होंने खोदा था और कहा कि हम को पानी मिल गया। ");
INSERT INTO urd_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","तब उसने उसका नाम सबा' रख्खा: इसीलिए वह शहर आज तक बैरसबा' कहलाता है। ");
INSERT INTO urd_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","जब 'ऐसौ चालीस साल का हुआ, तो उसने बैरी हित्ती की बेटी यहूदिथ और ऐलोन हिती की बेटी बशामथ से ब्याह किया; ");
INSERT INTO urd_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","और वह इस्हाक़ और रिब्क़ा के लिए वबाल — ए — जान हुईं। ");
INSERT INTO urd_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","जब इस्हाक़ ज़ईफ़ हो गया, और उसकी आँखें ऐसी धुन्धला गई कि उसे दिखाई न देता था तो उसने अपने बड़े बेटे 'ऐसौ को बुलाया और कहा, ऐ मेरे बेटे! “उसने कहा, मैं हाज़िर हूँ।” ");
INSERT INTO urd_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","तब उसने कहा, देख! मैं तो ज़ईफ़ हो गया और मुझे अपनी मौत का दिन मा'लूम नहीं। ");
INSERT INTO urd_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","इसलिए अब तू ज़रा अपना हथियार, अपना तरकश और अपनी कमान लेकर जंगल को निकल जा और मेरे लिए शिकार मार ला। ");
INSERT INTO urd_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","और मेरी हस्ब — ए पसन्द लज़ीज़ खाना मेरे लिए तैयार करके मेरे आगे ले आ, ताकि मैं खाऊँ और अपने मरने से पहले दिल से तुझे दुआ दूँ। ");
INSERT INTO urd_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","और जब इस्हाक़ अपने बेटे 'ऐसौ से बातें कर रहा था तो रिब्क़ा सुन रही थी, और 'ऐसौ जंगल को निकल गया कि शिकार मार कर लाए। ");
INSERT INTO urd_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","तब रिब्क़ा ने अपने बेटे या'क़ूब से कहा, कि देख, मैंने तेरे बाप को तेरे भाई 'ऐसौ से यह कहते सुना कि। ");
INSERT INTO urd_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","'मेरे लिए शिकार मार कर लज़ीज़ खाना मेरे लिए तैयार कर ताकि मैं खाऊँ और अपने मरने से पहले ख़ुदावन्द के आगे तुझे दुआ दूँ। ");
INSERT INTO urd_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","इसलिए ऐ मेरे बेटे, इस हुक़्म के मुताबिक़ जो मैं तुझे देती हूँ मेरी बात को मान। ");
INSERT INTO urd_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","और जाकर रेवड़ में से बकरी के दो अच्छे — अच्छे बच्चे मुझे ला दे, और मैं उनको लेकर तेरे बाप के लिए उसकी हस्ब — ए — पसन्द लज़ीज़ खाना तैयार कर दूँगी। ");
INSERT INTO urd_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","और तू उसे अपने बाप के आगे ले जाना, ताकि वह खाए और अपने मरने से पहले तुझे दुआ दे। ");
INSERT INTO urd_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","तब या'क़ूब ने अपनी माँ रिब्क़ा से कहा, “देख, मेरे भाई 'ऐसौ के जिस्म पर बाल हैं और मेरा जिस्म साफ़ है। ");
INSERT INTO urd_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","शायद मेरा बाप मुझे टटोले, तो मैं उसकी नज़र में दग़ाबाज़ ठहरूंगा; और बरकत नहीं बल्कि ला'नत कमाऊँगा।” ");
INSERT INTO urd_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","उसकी माँ ने उसे कहा, “ऐ मेरे बेटे! तेरी ला'नत मुझ पर आए; तू सिर्फ़ मेरी बात मान और जाकर वह बच्चे मुझे ला दे।” ");
INSERT INTO urd_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","तब वह गया और उनको लाकर अपनी माँ को दिया, और उसकी माँ ने उसके बाप की हस्ब — ए — पसन्द लज़ीज़ खाना तैयार किया। ");
INSERT INTO urd_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","और रिब्क़ा ने अपने बड़े बेटे 'ऐसौ के नफ़ीस लिबास, जो उसके पास घर में थे लेकर उनकी अपने छोटे बेटे या'क़ूब को पहनाया। ");
INSERT INTO urd_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","और बकरी के बच्चों की खालें उसके हाथो और उसकी गर्दन पर जहाँ बाल न थे लपेट दीं। ");
INSERT INTO urd_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","और वह लज़ीज़ खाना और रोटी जो उसने तैयार की थी, अपने बेटे या'क़ूब के हाथ में दे दी। ");
INSERT INTO urd_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","तब उसने बाप के पास आ कर कहा, ऐ मेरे बाप! “उसने कहा, मैं हाज़िर हूँ, तू कौन है मेरे बेटे?” ");
INSERT INTO urd_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","या'क़ूब ने अपने बाप से कहा, “मैं तेरा पहलौठा बेटा 'ऐसौ हूँ। मैंने तेरे कहने के मुताबिक़ किया है; इसलिए ज़रा उठ और बैठ कर मेरे शिकार का गोश्त खा, ताकि तू दिल से मुझे दुआ दे।” ");
INSERT INTO urd_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","तब इस्हाक़ ने अपने बेटे से कहा, “बेटा! तुझे यह इस क़दर जल्द कैसे मिल गया?” उसने कहा, “इसलिए कि ख़ुदावन्द तेरे ख़ुदा ने मेरा काम बना दिया।” ");
INSERT INTO urd_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","तब इस्हाक़ ने या'क़ूब से कहा, “ऐ मेरे बेटे, ज़रा नज़दीक आ कि मैं तुझे टटोलूँ कि तू मेरा ही बेटा 'ऐसौ है या नहीं।” ");
INSERT INTO urd_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","और या'क़ूब अपने बाप इस्हाक़ के नज़दीक गया; और उसने उसे टटोलकर कहा, “आवाज़ तो या'क़ूब की है लेकिन हाथ 'ऐसौ के हैं।” ");
INSERT INTO urd_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","और उसने उसे न पहचाना, इसलिए कि उसके हाथों पर उसके भाई 'ऐसौ के हाथों की तरह बाल थे; इसलिए उसने उसे दुआ दी। ");
INSERT INTO urd_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","और उसने पूछा कि क्या तू मेरा बेटा “ऐसौ ही है?” उसने कहा, “मैं वही हूँ।” ");
INSERT INTO urd_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","तब उसने कहा, “खाना मेरे आगे ले आ, और मैं अपने बेटे के शिकार का गोश्त खाऊँगा, ताकि दिल से तुझे दुआ दूँ।” तब वह उसे उसके नज़दीक ले आया, और उसने खाया; और वह उसके लिए मय लाया और उसने पी। ");
INSERT INTO urd_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","फिर उसके बाप इस्हाक़ ने उससे कहा, “ऐ मेरे बेटे! अब पास आकर मुझे चूम।” ");
INSERT INTO urd_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","उसने पास जाकर उसे चूमा। तब उसने उसके लिबास की ख़शबू पाई और उसे दुआ दे कर कहा, “देखो! मेरे बेटे की महक उस खेत की महक की तरह है जिसे ख़ुदावन्द ने बरकत दी हो। ");
INSERT INTO urd_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ख़ुदा आसमान की ओस और ज़मीन की फ़र्बही, और बहुत सा अनाज और मय तुझे बख़्शे। ");
INSERT INTO urd_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","कौमें तेरी खिदमत करें, और क़बीले तेरे सामने झुकें। तू अपने भाइयों का सरदार हो, और तेरी माँ के बेटे तेरे आगे झुकें, जो तुझ पर ला'नत करे वह खुद ला'नती हो, और जो तुझे दुआ दे वह बरकत पाए।” ");
INSERT INTO urd_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","जब इस्हाक़ या'क़ूब को दुआ दे चुका, और या'क़ूब अपने बाप इस्हाक़ के पास से निकला ही था कि उसका भाई 'ऐसौ अपने शिकार से लौटा। ");
INSERT INTO urd_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","वह भी लज़ीज़ खाना पका कर अपने बाप के पास लाया, और उसने अपने बाप से कहा, मेरा बाप उठ कर अपने बेटे के शिकार का गोश्त खाए, ताकि दिल से मुझे दुआ दे। ");
INSERT INTO urd_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","उसके बाप इस्हाक़ ने उससे पूछा कि तू कौन है? उसने कहा, मैं तेरा पहलौठा बेटा “ऐसौ हूँ।” ");
INSERT INTO urd_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","तब तो इस्हाक़ शिद्दत से काँपने लगा और उसने कहा, “फिर वह कौन था जो शिकार मार कर मेरे पास ले आया, और मैंने तेरे आने से पहले सबमें से थोड़ा — थोड़ा खाया और उसे दुआ दी? और मुबारक भी वही होगा।” ");
INSERT INTO urd_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ऐसौ अपने बाप की बातें सुनते ही बड़ी बुलन्दी और हसरतनाक आवाज़ से चिल्ला उठा, और अपने बाप से कहा, “मुझ को भी दुआ दे, ऐ मेरे बाप! मुझ को भी।” ");
INSERT INTO urd_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","उसने कहा, “तेरा भाई दग़ा से आया, और तेरी बरकत ले गया।” ");
INSERT INTO urd_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","तब उसने कहा, “क्या उसका नाम या'क़ूब ठीक नहीं रख्खा गया? क्यूँकि उसने दोबारा मुझे धोखा दिया। उसने मेरा पहलौठे का हक़ तो ले ही लिया था, और देख, अब वह मेरी बरकत भी ले गया।” फिर उसने कहा, “क्या तूने मेरे लिए कोई बरकत नहीं रख छोड़ी है?” ");
INSERT INTO urd_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","इस्हाक़ ने 'ऐसौ को जवाब दिया, कि देख, मैंने उसे तेरा सरदार ठहराया, और उसके सब भाइयों को उसके सुपर्द किया कि ख़ादिम हों, और अनाज और मय उसकी परवरिश के लिए बताई। अब ऐ मेरे बेटे, तेरे लिए मैं क्या करूँ? ");
INSERT INTO urd_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","तब 'ऐसौ ने अपने बाप से कहा, “क्या तेरे पास एक ही बरकत है, ऐ मेरे बाप? मुझे भी दुआ दे, ऐ मेरे बाप, मुझे भी।” और 'ऐसौ ज़ोर — ज़ोर से रोया। ");
INSERT INTO urd_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","तब उसके बाप इस्हाक़ ने उससे कहा, “देख ज़रख्खेज़ ज़मीन में तेरा घर हो, और ऊपर से आसमान की शबनम उस पर पड़े। ");
INSERT INTO urd_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","तेरी औकात — बसरी तेरी तलवार से हो, और तू अपने भाई की ख़िदमत करे, और जब तू आज़ाद हो; तो अपने भाई का जुआ अपनी गर्दन पर से उतार फेंके।” ");
INSERT INTO urd_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","और 'ऐसौ ने या'क़ूब से, उस बरकत की वजह से जो उसके बाप ने उसे बख्शी, कीना रख्खा; और 'ऐसौ ने अपने दिल में कहा, कि “मेरे बाप के मातम के दिन नज़दीक हैं, फिर मैं अपने भाई या'क़ूब को मार डालूँगा।” ");
INSERT INTO urd_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","और रिब्क़ा को उसके बड़े बेटे 'ऐसौ की यह बातें बताई गई; तब उसने अपने छोटे बेटे या'क़ूब को बुलवा कर उससे कहा, “देख, तेरा भाई 'ऐसौ तुझे मार डालने पर है, और यही सोच — सोचकर अपने को तसल्ली दे रहा है। ");
INSERT INTO urd_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","इसलिए ऐ मेरे बेटे, तू मेरी बात मान, और उठकर हारान को मेरे भाई लाबन के पास भाग जा; ");
INSERT INTO urd_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","और थोड़े दिन उसके साथ रह, जब तक तेरे भाई की नाराज़गी उतर न जाए। ");
INSERT INTO urd_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","या'नी जब तक तेरे भाई का क़हर तेरी तरफ़ से ठंडा न हो, और वह उस बात को जो तूने उससे की है भूल न जाए; तब मैं तुझे वहाँ से बुलवा भेजूँगी। मैं एक ही दिन में तुम दोनों को क्यूँ खो बैठूँ?” ");
INSERT INTO urd_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","और रिब्क़ा ने इस्हाक़ से कहा, 'मैं हिती लड़कियों की वजह से अपनी ज़िन्दगी से तंग हूँ, इसलिए अगर या'क़ूब हिती लड़कियों में से, जैसी इस मुल्क की लड़कियाँ हैं, किसी से ब्याह कर ले तो मेरी ज़िन्दगी में क्या लुत्फ़ रहेगा?' ");
INSERT INTO urd_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","तब इस्हाक़ ने या'क़ूब को बुलाया और उसे दुआ दी और उसे ताकीद की, कि तू कना'नी लड़कियों में से किसी से ब्याह न करना। ");
INSERT INTO urd_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","तू उठ कर फ़द्दान अराम को अपने नाना बैतूएल के घर जा, और वहाँ से अपने मामूं लाबन की बेटियों में से एक को ब्याह ला। ");
INSERT INTO urd_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","और क़ादिर — ए — मुतलक़ ख़ुदा तुझे बरकत बख़्शे और तुझे क़ामयाब करे और बढ़ाए, कि तुझ से क़ौमों के क़बीले पैदा हों। ");
INSERT INTO urd_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","और वह अब्रहाम की बरकत तुझे और तेरे साथ तेरी नसल को दे, कि तेरी मुसाफ़िरत की यह सरज़मीन जो ख़ुदा ने अब्रहाम को दी तेरी मीरास हो जाए। ");
INSERT INTO urd_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","तब इस्हाक़ ने या'क़ूब को रुख्सत किया और वह फ़द्दान अराम में लाबन के पास, जो अरामी बैतूएल का बेटा और या'क़ूब और 'ऐसौ की माँ रिब्क़ा का भाई था गया। ");
INSERT INTO urd_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","फिर जब 'ऐसौ ने देखा कि इस्हाक़ ने या'क़ूब को दुआ देकर उसे फ़द्दान अराम भेजा है, ताकि वह वहाँ से बीवी ब्याह कर लाए; और उसे दुआ देते वक़्त यह ताकीद भी की है कि तू कना'नी लड़कियों में से किसी से ब्याह न करना। ");
INSERT INTO urd_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","और या'क़ूब अपने माँ बाप की बात मान कर फ़द्दान अराम को चला गया। ");
INSERT INTO urd_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","और 'ऐसौ ने यह भी देखा कि कना'नी लड़कियाँ उसके बाप इस्हाक़ को बुरी लगती हैं, ");
INSERT INTO urd_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","तो 'ऐसौ इस्मा'ईल के पास गया और महलत को, जो इस्मा'ईल — बिन — अब्रहाम की बेटी और नबायोत की बहन थी, ब्याह कर उसे अपनी और बीवियों में शामिल किया। ");
INSERT INTO urd_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","और या'क़ूब बैर — सबा' से निकल कर हारान की तरफ़ चला। ");
INSERT INTO urd_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","और एक जगह पहुँच कर सारी रात वहीं रहा क्यूँकि सूरज डूब गया था, और उसने उस जगह के पत्थरों में से एक उठा कर अपने सरहाने रख लिया और उसी जगह सोने को लेट गया। ");
INSERT INTO urd_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","और ख़्वाब में क्या देखता है कि एक सीढ़ी ज़मीन पर खड़ी है, और उसका सिरा आसमान तक पहुँचा हुआ है। और ख़ुदा के फ़रिश्ता उस पर से चढ़ते उतरते हैं। ");
INSERT INTO urd_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","और ख़ुदावन्द उसके ऊपर खड़ा कह रहा है, कि मैं ख़ुदावन्द, तेरे बाप अब्रहाम का ख़ुदा और इस्हाक़ का ख़ुदा हूँ। मैं यह ज़मीन जिस पर तू लेटा है तुझे और तेरी नसल को दूँगा। ");
INSERT INTO urd_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","और तेरी नसल ज़मीन की गर्द के ज़रों की तरह होगी और तू मशरिक़ और मग़रिब और शिमाल और दख्खिनमें फैल जाएगा, और ज़मीन के सब क़बीले तेरे और तेरी नसल के वसीले से बरकत पाएंगे। ");
INSERT INTO urd_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","और देख, मैं तेरे साथ हूँ और हर जगह जहाँ कहीं तू जाए तेरी हिफ़ाज़त करूँगा और तुझ को इस मुल्क में फिर लाऊँगा, और जो मैंने तुझ से कहा है जब तक उसे पूरा न कर लें तुझे नहीं छोडुंगा। ");
INSERT INTO urd_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","तब या'क़ूब जाग उठा और कहने लगा, कि यक़ीनन ख़ुदावन्द इस जगह है और मुझे मा'लूम न था। ");
INSERT INTO urd_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","और उसने डर कर कहा, “यह कैसी ख़ौफ़नाक जगह है! तो यह ख़ुदा के घर और आसमान के आसताने के अलावा और कुछ न होगा।” ");
INSERT INTO urd_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","और या'क़ूब सुब्ह — सवेरे उठा, और उस पत्थर की जिसे उसने अपने सरहाने रख्खा था लेकर सुतून की तरह खड़ा किया और उसके सिरे पर तेल डाला। ");
INSERT INTO urd_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","और उस जगह का नाम बैतएल रख्खा, लेकिन पहले उस बस्ती का नाम लूज़ था। ");
INSERT INTO urd_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","और या'क़ूब ने मन्नत मानी और कहा कि अगर ख़ुदा मेरे साथ रहे, और जो सफ़र मैं कर रहा हूँ उसमें मेरी हिफ़ाज़त करे, और मुझे खाने को रोटी और पहनने की कपड़ा देता रहे, ");
INSERT INTO urd_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","और मैं अपने बाप के घर सलामत लौट आऊँ; तो ख़ुदावन्द मेरा ख़ुदा होगा। ");
INSERT INTO urd_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","और यह पत्थर जो मैंने सुतून सा खड़ा किया है, ख़ुदा का घर होगा; और जो कुछ तू मुझे दे उसका दसवाँ हिस्सा ज़रूर ही तुझे दिया करूँगा। ");
INSERT INTO urd_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","और या'क़ूब आगे चल कर मशरिक़ी लोगों के मुल्क में पहुँचा। ");
INSERT INTO urd_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","और उसने देखा कि मैदान में एक कुआँ है और कुएँ के नज़दीक भेड़ बकरियों के तीन रेवड़ बैठे हैं; क्यूँकि चरवाहे इसी कुएँ से रेवड़ों को पानी पिलाते थे और कुएँ के मुँह पर एक बड़ा पत्थर रख्खा रहता था। ");
INSERT INTO urd_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","और जब सब रेवड़ वहाँ इकट्ठे होते थे, तब वह उस पत्थर को कुएँ के मुँह पर से ढलकाते और भेड़ों को पानी पिला कर उस पत्थर को फिर उसी जगह कुएँ के मुँह पर रख देते थे। ");
INSERT INTO urd_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","तब या'क़ूब ने उनसे कहा, “ऐ मेरे भाइयों, तुम कहाँ के हो?” उन्होंने कहा, “हम हारान के हैं।” ");
INSERT INTO urd_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","फिर उसने पूछा कि तुम नहूर के बेटे लाबन से वाकिफ़ हो? उन्होंने कहा, हम वाकिफ़ हैं। ");
INSERT INTO urd_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","उसने पूछा, “क्या वह ख़ैरियत से है?” उन्होंने कहा, “ख़ैरियत से है, और वह देख, उसकी बेटी राख़िल भेड़ बकरियों के साथ चली आती है।” ");
INSERT INTO urd_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","और उसने कहा, देखो, अभी तो दिन बहुत है, और चौपायों के जमा' होने का वक़्त नहीं। तुम भेड़ बकरियों को पानी पिला कर फिर चराने को ले जाओ। ");
INSERT INTO urd_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","उन्होंने कहा, “हम ऐसा नहीं कर सकते, जब तक कि सब रेवड़ जमा' न हो जाएँ। तब हम उस पत्थर को कुएँ के मुँह पर से ढलकाते हैं, और भेड़ बकरियों को पानी पिलाते हैं।” ");
INSERT INTO urd_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","वह उनसे बातें कर ही रहा था कि राख़िल अपने बाप की भेड़ बकरियों के साथ आई, क्यूँकि वह उनको चराया करती थी। ");
INSERT INTO urd_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","जब या'क़ूब ने अपने मामूँ लाबन की बेटी राख़िल को और अपने मामूँ लाबन के रेवड़ को देखा, तो वह नज़दीक गया और पत्थर को कुएँ के मुँह पर से ढलका कर अपने मामूँ लाबन के रेवड़ को पानी पिलाया। ");
INSERT INTO urd_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","और या'क़ूब ने राख़िल को चूमा और ज़ोर ज़ोर से रोया। ");
INSERT INTO urd_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","और या'क़ूब ने राख़िल से कहा, कि मैं तेरे बाप का रिश्तेदार और रिब्क़ा का बेटा हूँ। तब उसने दौड़ कर अपने बाप को ख़बर दी। ");
INSERT INTO urd_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","लाबन अपने भांजे की ख़बर पाते ही उससे मिलने को दौड़ा, और उसको गले लगाया और चूमा और उसे अपने घर लाया; तब उसने लाबन को अपना सारा हाल बताया। ");
INSERT INTO urd_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","लाबन ने उसे कहा, “तू वाक़'ई मेरी हड्डी और मेरा गोश्त है।” फिर वह एक महीना उसके साथ रहा। ");
INSERT INTO urd_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","तब लाबन ने या'क़ूब से कहा, “चूँकि तू मेरा रिश्तेदार है, तो क्या इसलिए लाज़िम है कि तू मेरी ख़िदमत मुफ़्त करे? इसलिए मुझे बता कि तेरी मजदुरी क्या होगी?” ");
INSERT INTO urd_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","और लाबन की दो बेटियाँ थीं, बड़ी का नाम लियाह और छोटी का नाम राख़िल था। ");
INSERT INTO urd_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लियाह की आखें भूरी थीं लेकिन राख़िल हसीन और ख़ूबसूरत थी। ");
INSERT INTO urd_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","और या'क़ूब राख़िल पर फ़िदा था, तब उसने कहा, “तेरी छोटी बेटी राख़िल की ख़ातिर मैं सात साल तेरी खिदमत करूँगा।” ");
INSERT INTO urd_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","लाबन ने कहा, “उसे ग़ैर आदमी को देने की जगह तुझी को देना बेहतर है, तू मेरे पास रह।” ");
INSERT INTO urd_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","चुनाँचे या'क़ूब सात साल तक राख़िल की ख़ातिर ख़िदमत करता रहा लेकिन वह उसे राख़िल की मुहब्बत की वजह से चन्द दिनों के बराबर मा'लूम हुए। ");
INSERT INTO urd_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","या'क़ूब ने लाबन से कहा कि मेरी मुद्दत पूरी हो गई, इसलिए मेरी बीवी मुझे दे ताकि मैं उसके पास जाऊँ। ");
INSERT INTO urd_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","तब लाबन ने उस जगह के सब लोगों को बुला कर जमा' किया और उनकी दावत की। ");
INSERT INTO urd_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","और जब शाम हो गई तो अपनी बेटी लियाह को उसके पास ले आया, और या'क़ूब उससे हम आगोश हुआ। ");
INSERT INTO urd_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","और लाबन ने अपनी लौंडी ज़िल्फ़ा अपनी बेटी लियाह के साथ कर दी कि उसकी लौंडी हो। ");
INSERT INTO urd_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","जब सुबह को मा'लूम हुआ कि यह तो लियाह है, तब उसने लाबन से कहा, कि तूने मुझ से ये क्या किया? क्या मैंने जो तेरी ख़िदमत की, वह राख़िल की ख़ातिर न थी? फिर तूने क्यूँ मुझे धोका दिया? ");
INSERT INTO urd_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","लाबन ने कहा कि हमारे मुल्क में ये दस्तूर नहीं के पहलौठी से पहले छोटी को ब्याह दें। ");
INSERT INTO urd_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","तू इसका हफ़्ता पूरा कर दे, फिर हम दूसरी भी तुझे दे देंगे; जिसकी ख़ातिर तुझे सात साल और मेरी ख़िदमत करनी होगी। ");
INSERT INTO urd_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","या'क़ूब ने ऐसा ही किया, कि लियाह का हफ़्ता पूरा किया; तब लाबन ने अपनी बेटी राख़िल भी उसे ब्याह दी। ");
INSERT INTO urd_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","और अपनी लौडी बिल्हाह अपनी बेटी राख़िल के साथ कर दी कि उसकी लौंडी हो। ");
INSERT INTO urd_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","इसलिए वह राख़िल से भी हम आग़ोश हुआ, और वह लियाह से ज़्यादा राख़िल को चाहता था; और सात साल और साथ रह कर लाबन की ख़िदमत की। ");
INSERT INTO urd_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","और जब ख़ुदावन्द ने देखा कि लियाह से नफ़रत की गई, तो उसने उसका रिहम खोला, मगर राख़िल बाँझ रही। ");
INSERT INTO urd_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","और लियाह हामिला हुई और उसके बेटा हुआ, और उसने उसका नाम रूबिन रख्खा क्यूँकि उसने कहा कि ख़ुदावन्द ने मेरा दुख देख लिया, इसलिए मेरा शौहर अब मुझे प्यार करेगा। ");
INSERT INTO urd_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","वह फिर हामिला हुई और उसके बेटा हुआ तब उसने कहा कि ख़ुदावन्द ने सुना कि मुझ से नफ़रत की गई, इसलिए उसने मुझे यह भी बख़्शा। तब उसने उसका नाम शमौन रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","और वह फिर हामिला हुई और उसके बेटा हुआ तब उसने कहा, “अब इस बार मेरे शौहर को मुझ से लगन होगी, क्यूँकि उससे मेरे तीन बेटे हुए।” इसलिए उसका नाम लावी रख्खा गया। ");
INSERT INTO urd_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","और वह फिर हामिला हुई और उसके बेटा हुआ तब उसने कहा कि अब मैं ख़ुदावन्द की हम्द करूँगी। इसलिए उसका नाम यहूदाह रख्खा। फिर उसके औलाद होने में देरी हुई। ");
INSERT INTO urd_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","और जब राख़िल ने देखा कि या'क़ूब से उसके औलाद नहीं होती तो राख़िल को अपनी बहन पर रश्क आया, तब वह या'क़ूब से कहने लगी, “मुझे भी औलाद दे नहीं तो मैं मर जाऊँगी।” ");
INSERT INTO urd_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","तब या'क़ूब का क़हर राख़िल पर भड़का और उस ने कहा, “क्या मैं ख़ुदा की जगह हूँ जिसने तुझ को औलाद से महरूम रख्खा है?” ");
INSERT INTO urd_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","उसने कहा, “देख, मेरी लौंडी बिल्हाह हाज़िर है, उसके पास जा ताकि मेरे लिए उससे औलाद हो और वह औलाद मेरी ठहरे।” ");
INSERT INTO urd_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","और उसने अपनी लौंडी बिल्हाह को उसे दिया के उसकी बीवी बने, और या'क़ूब उसके पास गया। ");
INSERT INTO urd_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","और बिल्हाह हामिला हुई, और या'क़ूब से उसके बेटा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","तब राख़िल ने कहा कि ख़ुदा ने मेरा इन्साफ़ किया और मेरी फ़रियाद भी सुनी और मुझ को बेटा बख़्शा। इसलिए उसने उसका नाम दान रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","और राख़िल की लौंडी बिल्हाह फिर हामिला हुई और या'क़ूब से उसके दूसरा बेटा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","तब राख़िल ने कहा, “मैं अपनी बहन के साथ निहायत ज़ोर मार — मारकर कुश्ती लड़ी और मैंने फ़तह पाई।” इसलिए उसने उसका नाम नफ़्ताली रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","जब लियाह ने देखा कि वह जनने से रह गई तो उसने अपनी लौंडी ज़िलफ़ा को लेकर या'क़ूब को दिया कि उसकी बीवी बने। ");
INSERT INTO urd_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","और लियाह की लौंडी ज़िलफ़ा के भी या'क़ूब से एक बेटा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","तब लियाह ने कहा, ज़हे — किस्मत! “तब उसने उसका नाम जद्द रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","लियाह की लौंडी ज़िलफ़ा के या'क़ूब से फिर एक बेटा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","तब लियाह ने कहा, मैं ख़ुश क़िस्मत हूँ: 'औरतें मुझे खुश क़िस्मत कहेंगी।” और उसने उसका नाम आशर रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","और रूबिन गेहूँ काटने के मौसम में घर से निकला और उसे खेत में मदुम गियाह मिल गए, और वह अपनी माँ लियाह के पास ले आया। तब राख़िल ने लियाह से कहा किअपने बेटे के मदुम गियाह में से मुझे भी कुछ दे दे। ");
INSERT INTO urd_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","उसने कहा, “क्या ये छोटी बात है कि तूने मेरे शौहर को ले लिया, और अब क्या मेरे बेटे के मदुम गियाह भी लेना चाहती है?” राख़िल ने कहा, “बस तो आज रात वह तेरे बेटे के मदुम गियाह की ख़ातिर तेरे साथ सोएगा।” ");
INSERT INTO urd_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","जब या'क़ूब शाम को खेत से आ रहा था तो लियाह आगे से उससे मिलने को गई और कहने लगी कि तुझे मेरे पास आना होगा, क्यूँकि मैंने अपने बेटे के मदुम गियाह के बदले तुझे मज़दूरी पर लिया है। वह उस रात उसी के साथ सोया। ");
INSERT INTO urd_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","और ख़ुदा ने लियाह की सुनी और वह हामिला हुई, और या'क़ूब से उसके पाँचवाँ बेटा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","तब लियाह ने कहा कि ख़ुदा ने मेरी मज़दूरी मुझे दी क्यूँकि मैंने अपने शौहर को अपनी लौंडी दी। और उसने उसका नाम इश्कार रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","और लियाह फिर हामिला हुई और या'क़ूब से उसके छटा बेटा हुआ। ");
INSERT INTO urd_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","तब लियाह ने कहा कि ख़ुदा ने अच्छा महर मुझे बख़्शा; अब मेरा शौहर मेरे साथ रहेगा क्यूँकि मेरे उससे छ: बेटे हो चुके हैं। इसलिए उसने उसका नाम ज़बूलून रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","इसके बाद उसके एक बेटी हुई और उसने उसका नाम दीना रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","और ख़ुदा ने राख़िल को याद किया, और ख़ुदा ने उसकी सुन कर उसके रहम को खोला। ");
INSERT INTO urd_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","और वह हामिला हुई और उसके बेटा हुआ, तब उसने कहा कि ख़ुदा ने मुझ से रुस्वाई दूर की। ");
INSERT INTO urd_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","और उस ने उसका नाम यूसुफ़ यह कह कर रख्खा कि ख़ुदा वन्द मुझ को एक और बेटा बख़्शे। ");
INSERT INTO urd_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","और जब राख़िल से यूसुफ़ पैदा हुआ तो या'क़ूब ने लाबन से कहा, “मुझे रुख़्सत कर कि मैं अपने घर और अपने वतन को जाऊँ। ");
INSERT INTO urd_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","मेरी बीवियाँ और मेरे बाल बच्चे जिनकी ख़ातिर मैं ने तेरी ख़िदमत की है मेरे हवाले कर और मुझे जाने दे, क्यूँकि तू ख़ुद जानता है कि मैंने तेरी कैसी ख़िदमत की है।” ");
INSERT INTO urd_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","तब लाबन ने उसे कहा, “अगर मुझ पर तेरे करम की नज़र है तो यहीं रह क्यूँकि मैं जान गया हूँ कि ख़ुदावन्द ने तेरी वजह से मुझ को बरकत बख़्शी है।” ");
INSERT INTO urd_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","और यह भी कहा कि मुझ से तू अपनी मज़दूरी ठहरा ले, और मैं तुझे दिया करूँगा। ");
INSERT INTO urd_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","उसने उसे कहा कि तू ख़ुद जानता है कि मैंने तेरी कैसी ख़िदमत की और तेरे जानवर मेरे साथ कैसे रहे। ");
INSERT INTO urd_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","क्यूँकि मेरे आने से पहले यह थोड़े थे और अब बढ़ कर बहुत से हो गए हैं, और ख़ुदावन्द ने जहाँ जहाँ मेरे क़दम पड़े तुझे बरकत बख़्शी। अब मैं अपने घर का बन्दोबस्त कब करूँ? ");
INSERT INTO urd_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","उसने कहा, “तुझे मैं क्या दूँ?” या'क़ूब ने कहा, “तू मुझे कुछ न देना, लेकिन अगर तू मेरे लिए एक काम कर दे तो मैं तेरी भेड़ — बकरियों को फिर चराऊँगा और उनकी निगहबानी करूँगा। ");
INSERT INTO urd_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","मैं आज तेरी सब भेड़ — बकरियों में चक्कर लगाऊँगा, और जितनी भेड़ें चितली और और काली हों और जितनी बकरियाँ और चितली हों उन सबको अलग एक तरफ़ कर दूँगा, इन्हीं को मैं अपनी मज़दूरी ठहराता हूँ। ");
INSERT INTO urd_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","और आइन्दा जब कभी मेरी मज़दूरी का हिसाब तेरे सामने ही तो मेरी सच्चाई आप मेरी तरफ़ से इस तरह बोल उठेगी, कि जो बकरियाँ चितली और नहीं और जो भेड़े काली नहीं अगर वह मेरे पास हों तो चुराई हुई समझी जाएँगी।” ");
INSERT INTO urd_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","लाबन ने कहा, “मैं राज़ी हूँ, जो तू कहे वही सही।” ");
INSERT INTO urd_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","और उसने उसी रोज़ धारीदार और बकरों की और सब चितली और बकरियों को जिनमें कुछ सफ़ेदी थी, और तमाम काली भेड़ों को अलग करके उनकी अपने बेटों के हवाले किया। ");
INSERT INTO urd_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","और उसने अपने और या'क़ूब के बीच तीन दिन के सफ़र का फ़ासला ठहराया; और या'क़ूब लाबन के बाक़ी रेवड़ों को चराने लगा। ");
INSERT INTO urd_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","और या'क़ूब ने सफ़ेदा और बादाम, और चिनार की हरी हरी छड़ियाँ लीं उनको छील छीलकर इस तरह गन्डेदार बना लिया के उन छड़ियों की सफ़ेदी दिखाई देने लगी। ");
INSERT INTO urd_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","और उसने वह गन्डेदार छड़ियाँ भेड़ — बकरियों के सामने हौज़ों और नालियों में जहाँ वह पानी पीने आती थीं खड़ी कर दीं, और जब वह पानी पीने आई तब गाभिन हो गई। ");
INSERT INTO urd_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","और उन छड़ियों के आगे गाभिन होने की वजह से उन्होने धारीदार, चितले और बच्चे दिए। ");
INSERT INTO urd_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","और या'क़ूब ने भेड़ बकरियों के उन बच्चों को अलग किया, और लाबन की भेड़ — बकरियों के मुँह धारीदार और काले बच्चों की तरफ़ फेर दिए और उसने अपने रेवड़ों को जुदा किया, और लाबन की भेड़ बकरियों में मिलने न दिया। ");
INSERT INTO urd_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","और जब मज़बूत भेड़ — बकरियाँ गाभिन होती थीं तो या'क़ूब छड़ियों को नालियों में उनकी आँखों के सामने रख देता था, ताकि वह उन छड़ियों के आगे गाभिन हों। ");
INSERT INTO urd_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","लेकिन जब भेड़ बकरियाँ दुबली होतीं तो वह उनको वहाँ नहीं रखता था। इसलिए दुबली तो लाबन की रहीं और मज़बूत या'क़ूब की हो गई। ");
INSERT INTO urd_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","चुनाँचे वह निहायत बढ़ता गया और उसके पास बहुत से रेवड़ और लौंडिया और नौकर चाकर और ऊँट और गधे हो गये। ");
INSERT INTO urd_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","और उसने लाबन के बेटों की यह बातें सुनीं, कि या'क़ूब ने हमारे बाप का सब कुछ ले लिया और हमारे बाप के माल की बदौलत उसकी यह सारी शान — ओ — शौकत है। ");
INSERT INTO urd_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","और या'क़ूब ने लाबन के चेहरे को देख कर ताड़ लिया कि उसका रुख़ पहले से बदला हुआ है। ");
INSERT INTO urd_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","और ख़ुदावन्द ने या'क़ूब से कहा, कि तू अपने बाप दादा के मुल्क को और अपने रिश्तेदारो के पास लौट जा, और मैं तेरे साथ रहूँगा। ");
INSERT INTO urd_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","तब या'क़ूब ने राख़िल और लियाह को मैदान में जहाँ उसकी भेड़ — बकरियाँ थीं बुलवाया ");
INSERT INTO urd_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","और उनसे कहा, मैं देखता हूँ कि तुम्हारे बाप का रुख़ पहले से बदला हुआ है, लेकिन मेरे बाप का ख़ुदा मेरे साथ रहा। ");
INSERT INTO urd_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","तुम तो जानती हो कि मैंने अपनी ताक़त के मुताबिक़ तुम्हारे बाप की ख़िदमत की है। ");
INSERT INTO urd_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","लेकिन तुम्हारे बाप ने मुझे धोका दे देकर दस बार मेरी मज़दूरी बदली, लेकिन ख़ुदा ने उसको मुझे नुक़्सान पहुँचाने न दिया। ");
INSERT INTO urd_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","जब उसने यह कहा कि चितले बच्चे तेरी मज़दूरी होंगे, तो भेड़ बकरियाँ चितले बच्चे देने लगीं, और जब कहा कि धारीदार बच्चे तेरे होंगे, तो भेड़ — बकरियों ने धारीदार बच्चे दिए। ");
INSERT INTO urd_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","यूँ ख़ुदा ने तुम्हारे बाप के जानवर लेकर मुझे दे दिए। ");
INSERT INTO urd_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","और जब भेड़ बकरियाँ गाभिन हुई, तो मैंने ख़्वाब में देखा कि जो बकरे बकरियों पर चढ़ रहे हैं वो धारीदार, चितले और चितकबरे हैं। ");
INSERT INTO urd_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","और ख़ुदा के फ़रिश्ते ने ख़्वाब में मुझ से कहा, 'ऐ या'क़ूब!' मैंने कहा, 'मैं हाज़िर हूँ। ");
INSERT INTO urd_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","तब उसने कहा कि अब तू अपनी आँख उठा कर देख, कि सब बकरे जो बकरियों पर चढ़ रहे हैं धारीदार चितले और चितकबरे हैं, क्यूँकि जो कुछ लाबन तुझ से करता है मैंने देखा। ");
INSERT INTO urd_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","मैं बैतएल का ख़ुदा हूँ, जहाँ तूने सुतून पर तेल डाला और मेरी मन्नत मानी, इसलिए अब उठ और इस मुल्क से निकल कर अपने वतन को लौट जा'। ");
INSERT INTO urd_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","तब राख़िल और लियाह ने उसे जवाब दिया, “क्या, अब भी हमारे बाप के घर में कुछ हमारा बख़रा या मीरास है? ");
INSERT INTO urd_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","क्या वह हम को अजनबी के बराबर नहीं समझता? क्यूँकि उसने हम को भी बेच डाला और हमारे रुपये भी खा बैठा। ");
INSERT INTO urd_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","इसलिए अब जो दौलत ख़ुदा ने हमारे बाप से ली वह हमारी और हमारे फ़र्ज़न्दों की है, फिर जो कुछ ख़ुदा ने तुझ से कहा है वही कर।” ");
INSERT INTO urd_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","तब या'क़ूब ने उठ कर अपने बाल बच्चों और बीवियों को ऊँटों पर बिठाया। ");
INSERT INTO urd_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","और अपने सब जानवरों और माल — ओ — अस्बाब को जो उसने इकट्ठा किया था, या'नी वह जानवर जो उसे फ़द्दान — अराम में मज़दूरी में मिले थे, लेकर चला ताकि मुल्क — ए — कना'न में अपने बाप इस्हाक़ के पास जाए। ");
INSERT INTO urd_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","और लाबन अपनी भेड़ों की ऊन कतरने को गया हुआ था, तब राख़िल अपने बाप के बुतों को चुरा ले गई। ");
INSERT INTO urd_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","और या'क़ूब लाबन अरामी के पास से चोरी से चला गया, क्यूँकि उसे उसने अपने भागने की ख़बर न दी। ");
INSERT INTO urd_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","फिर वह अपना सब कुछ लेकर भागा और दरिया पार होकर अपना रुख़ कोह — ए — जिल'आद की तरफ किया। ");
INSERT INTO urd_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","और तीसरे दिन लाबन की ख़बर हुई कि या'क़ूब भाग गया। ");
INSERT INTO urd_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","तब उसने अपने भाइयों को हमराह लेकर सात मन्ज़िल तक उसका पीछा किया, और जिल'आद के पहाड़ पर उसे जा पकड़ा। ");
INSERT INTO urd_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","और रात को ख़ुदा लाबन अरामी के पास ख़्वाब में आया और उससे कहा कि ख़बरदार, तू या'क़ूब को बुरा या भला कुछ न कहना। ");
INSERT INTO urd_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","और लाबन या'क़ूब के बराबर जा पहुँचा और या'क़ूब ने अपना ख़ेमा पहाड़ पर खड़ा कर रख्खा था। इसलिए लाबन ने भी अपने भाइयों के साथ जिल'आद के पहाड़ पर डेरा लगा लिया। ");
INSERT INTO urd_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","तब लाबन ने या'क़ूब से कहा, कि तूने यह क्या किया कि मेरे पास से चोरी से चला आया, और मेरी बेटियों को भी इस तरह ले आया गोया वह तलवार से क़ैद की गई हैं? ");
INSERT INTO urd_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","तू छिप कर क्यूँ भागा और मेरे पास से चोरी से क्यूँ चला आया और मुझे कुछ कहा भी नहीं, वरना मैं तुझे खु़शी — खु़शी तबले और बरबत के साथ गाते बजाते रवाना करता? ");
INSERT INTO urd_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","और मुझे अपने बेटों और बेटियों को चूमने भी न दिया? यह तूने बेहूदा काम किया। ");
INSERT INTO urd_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","मुझ में इतनी ताक़त है कि तुम को दुख दूँ, लेकिन तेरे बाप के ख़ुदा ने कल रात मुझे यूँ कहा, कि ख़बरदार तू या'क़ूब को बुरा या भला कुछ न कहना। ");
INSERT INTO urd_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","खै़र! अब तू चला आया तो चला आया क्यूँकि तू अपने बाप के घर का बहुत ख़्वाहिश मन्द है, लेकिन मेरे देवताओं को क्यूँ चुरा लाया? ");
INSERT INTO urd_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","तब या'क़ूब ने लाबन से कहा, “इसलिए कि मैं डरा, क्यूँकि कि मैंने सोचा कि कहीं तू अपनी बेटियों को जबरन मुझ से छीन न ले। ");
INSERT INTO urd_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","अब जिसके पास तुझे तेरे बुत मिलें वह ज़िन्दा नहीं बचेगा। तेरा जो कुछ मेरे पास निकले उसे इन भाइयों के आगे पहचान कर ले।” क्यूँकि या'क़ूब को मा'लूम न था कि राख़िल उन देवताओं को चुरा लाई है। ");
INSERT INTO urd_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","चुनांचे लाबन या'क़ूब और लियाह और दोनों लौंडियों के ख़ेमों में गया लेकिन उनको वहाँ न पाया, तब वह लियाह के ख़ेमा से निकल कर राख़िल के ख़ेमे में दाख़िल हुआ। ");
INSERT INTO urd_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","और राख़िल उन बुतों को लेकर और उनकी ऊँट के कजावे में रख कर उन पर बैठ गई थी, और लाबन ने सारे ख़में में टटोल टटोल कर देख लिया पर उनको न पाया। ");
INSERT INTO urd_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","तब वह अपने बाप से कहने लगी, “ऐ मेरे आक़ा! तू इस बात से नाराज़ न होना कि मैं तेरे आगे उठ नहीं सकती, क्यूँकि मैं ऐसे हाल में हूँ जो 'औरतों का हुआ करता है।” तब उसने ढूंडा पर वह बुत उसको न मिले। ");
INSERT INTO urd_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","तब या'क़ूब ने ग़ुस्सा होकर लाबन को मलामत की और या'क़ूब लाबन से कहने लगा कि मेरा क्या जुर्म और क्या क़ुसूर है कि तूने ऐसी तेज़ी से मेरा पीछा किया? ");
INSERT INTO urd_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","तूने जो मेरा सारा सामान टटोल — टटोल कर देख लिया तो तुझे तेरे घर के सामान में से क्या चीज़ मिली? अगर कुछ है तो उसे मेरे और अपने इन भाइयो के आगे रख, कि वह हम दोनों के बीच इन्साफ़ करें। ");
INSERT INTO urd_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","मैं पूरे बीस साल तेरे साथ रहा; न तो कभी तेरी भेड़ों और बकरियों का गाभ गिरा, और न तेरे रेवड़ के मेंढे मैंने खाए। ");
INSERT INTO urd_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","जिसे दरिन्दों ने फाड़ा मैं उसे तेरे पास न लाया, उसका नुक़्सान मैंने सहा; जो दिन की या रात को चोरी गया उसे तूने मुझ से तलब किया। ");
INSERT INTO urd_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","मेरा हाल यह रहा कि मैं दिन को गर्मी और रात को सर्दी में मरा और मेरी आँखों से नींद दूर रहती थी। ");
INSERT INTO urd_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","मैं बीस साल तक तेरे घर में रहा, चौदह साल तक तो मैंने तेरी दोनों बेटियों की ख़ातिर और छ: साल तक तेरी भेड़ बकरियों की ख़ातिर तेरी ख़िदमत की, और तूने दस बार मेरी मज़दूरी बदल डाली। ");
INSERT INTO urd_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","अगर मेरे बाप का ख़ुदा अब्रहाम का मा'बूद जिसका रौब इस्हाक़ मानता था, मेरी तरफ़ न होता तो ज़रूर ही तू अब मुझे ख़ाली हाथ जाने देता। ख़ुदा ने मेरी मुसीबत और मेरे हाथों की मेहनत देखी है और कल रात तुझे डाँटा भी। ");
INSERT INTO urd_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","तब लाबन ने या'क़ूब को जवाब दिया, यह बेटियाँ भी मेरी और यह लड़के भी मेरे और यह भेड़ बकरियाँ भी मेरी हैं, बल्कि जो कुछ तुझे दिखाई देता है वह सब मेरा ही है। इसलिए मैं आज के दिन अपनी ही बेटियों से या उनके लड़कों से जो उनके हुए क्या कर सकता हूँ? ");
INSERT INTO urd_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","फिर अब आ, कि मैं और तू दोनों मिल कर आपस में एक 'अहद बाँधे और वही मेरे और तेरे बीच गवाह रहे। ");
INSERT INTO urd_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","तब या'क़ूब ने एक पत्थर लेकर उसे सुतून की तरह खड़ा किया। ");
INSERT INTO urd_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","और या'क़ूब ने अपने भाइयों से कहा, पत्थर जमा' करो! “उन्होंने पत्थर जमा' करके ढेर लगाया और वहीं उस ढेर के पास उन्होंने खाना खाया। ");
INSERT INTO urd_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","और लाबन ने उसका नाम यज्र शाहदूथा और या'क़ूब ने जिल'आद रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","और लाबन ने कहा कि यह ढेर आज के दिन मेरे और तेरे बीच गवाह हो। इसी लिए उसका नाम जिल'आद रख्खा गया। ");
INSERT INTO urd_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","और मिस्फ़ाह भी क्यूँकि लाबन ने कहा कि जब हम एक दूसरे से गैर हाज़िर हों तो ख़ुदावन्द मेरे और तेरे बीच निगरानी करता रहे। ");
INSERT INTO urd_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","अगर तू मेरी बेटियों को दुख दे और उनके अलावा और बीवियाँ करे तो कोई आदमी हमारे साथ नहीं है लेकिन देख ख़ुदा मेरे और तेरे बीच में गवाह है। ");
INSERT INTO urd_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","लाबन ने या'क़ूब से यह भी कहा कि इस ढेर को देख और उस सुतून को देख जो मैंने अपने और तेरे बीच में खड़ा किया है। ");
INSERT INTO urd_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","यह ढेर गवाह हो और ये सुतून गवाह हो, नुक़सान पहुँचाने के लिए न तो मैं इस ढेर से उधर तेरी तरफ़ हद से बढूँ और न तू इस ढेर और सुतून से इधर मेरी तरफ़ हद से बढ़े। ");
INSERT INTO urd_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","अब्रहाम का ख़ुदा और नहूर का ख़ुदा और उनके बाप का ख़ुदा हमारे बीच में इन्साफ़ करे।” और या'क़ूब ने उस ज़ात की क़सम खाई जिसका रौ'ब उसका बाप इस्हाक़ मानता था। ");
INSERT INTO urd_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","तब या'क़ूब ने वहीं पहाड़ पर क़ुर्बानी पेश की और अपने भाइयों को खाने पर बुलाया, और उन्होंने खाना खाया और रात पहाड़ पर काटी। ");
INSERT INTO urd_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","और लाबन सुबह — सवेरे उठा और अपने बेटों और अपनी बेटियों को चूमा और उनको दुआ देकर रवाना हो गया और अपने मकान को लौटा। ");
INSERT INTO urd_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","और या'क़ूब ने भी अपनी राह ली और ख़ुदा के फ़रिश्ता उसे मिले। ");
INSERT INTO urd_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","और या'क़ूब ने उनको देख कर कहा, कि यह ख़ुदा का लश्कर है और उस जगह का नाम महनाइम रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","और या'क़ूब ने अपने आगे — आगे क़ासिदों को अदोम के मुल्क को, जो श'ईर की सर — ज़मीन में है, अपने भाई 'ऐसौ के पास भेजा, ");
INSERT INTO urd_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","और उनको हुक्म दिया, कि तुम मेरे ख़ुदावन्द 'ऐसौ से यह कहना कि आपका बन्दा या'क़ूब कहता है, कि मै लाबन के यहाँ मुक़ीम था और अब तक वहीं रहा। ");
INSERT INTO urd_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","और मेरे पास गाय बैल गधे और भेड़ बकरियाँ और नौकर चाकर और लौंडियाँ है और मै अपने ख़ुदावन्द के पास इसलिए ख़बर भेजता हूँ कि मुझ पर आप के करम की नज़र हो ");
INSERT INTO urd_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","फिर क़ासिद या'क़ूब के पास लौट कर आए और कहने लगे कि हम भाई 'ऐसौ के पास गए थे; वह चार सौ आदमियों को साथ लेकर तेरी मुलाक़ात को आ रहा है ");
INSERT INTO urd_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","तब या'क़ूब निहायत डर गया और परेशान हो और उस ने अपने साथ के लोगों और भेड़ बकरियों और गाये बैलों और ऊँटों के दो ग़ोल किए ");
INSERT INTO urd_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","और सोचा कि 'ऐसौ एक ग़ोल पर आ पड़े और उसे मारे तो दुसरा ग़ोल बच कर भाग जाएगा ");
INSERT INTO urd_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","और या'क़ूब ने कहा ऐ मेरे बाप अब्रहाम के ख़ुदा और मेरे बाप इस्हाक़ के ख़ुदा! ऐ ख़ुदावन्द जिस ने मुझे यह फ़रमाया कि तू अपने मुल्क को अपने रिश्तेदारों के पास लौट जा और मैं तेरे साथ भलाई करूँगा ");
INSERT INTO urd_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","मै तेरी सब रहमतों और वफ़ादारी के मुक़ाबला में जो तूने अपने बन्दा के साथ बरती है बिल्कुल हेच हूँ क्यूँकि मै सिर्फ़ अपनी लाठी लेकर इस यरदन के पार गया था और अब ऐसा हूँ कि मेरे दो ग़ोल हैं ");
INSERT INTO urd_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","मैं तेरी मिन्नत करता हूँ कि मुझे मेरे भाई 'ऐसौ के हाथ से बचा ले क्यूँकि मै उस से डरता हूँ कि कहीं वह आकर मुझे और बच्चों को माँ समेत मार न डाले ");
INSERT INTO urd_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","यह तेरा ही फ़रमान है कि मैं तेरे साथ ज़रूर भलाई करूँगा और तेरी नसल को दरिया की रेत की तरह बनाऊंगा जो कसरत की वजह से गिनी नहीं जा सकती। ");
INSERT INTO urd_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","और वह उस रात वही रहा और जो उसके पास था उस में से अपने भाई 'ऐसौ के लिए यह नज़राना लिया। ");
INSERT INTO urd_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","दो सौ बकरियां और बीस बकरे; दो सौ भेड़ें और बीस मेंढे। ");
INSERT INTO urd_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","और तीस दूध देने वाली ऊँटनीयां बच्चों समेत और चालीस गाय और दस बैल बीस गधियाँ और दस गधे ");
INSERT INTO urd_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","और उनको जुदा — जुदा ग़ोल कर के नौकरों को सौंपना और उन से कहा कि तुम मेरे आगे आगे पार जाओ और ग़ोलों को ज़रा दूर दूर रखना। ");
INSERT INTO urd_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","और उसने सब से अगले ग़ोल के रखवाले को हुक्म दिया कि जब मेरा भाई 'ऐसौ तुझे मिले और तुझ से पूछे कि तू किस का नौकर है और कहाँ जाता है और यह जानवर जो तेरे आगे आगे हैं किस के हैं? ");
INSERT INTO urd_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","तू कहना कि यह तेरे ख़ादिम या'क़ूब के हैं, यह नज़राना है जो मेरे ख़ुदावन्द 'ऐसौ के लिए भेजा गया है और वह ख़ुद भी हमारे पीछे पीछे आ रहा है। ");
INSERT INTO urd_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","और उस ने दूसरे और तीसरे को ग़ोलों के सब रखवालों को हुक्म दिया कि जब 'एसौ तुमको मिले तो तुम यही बात कहना। ");
INSERT INTO urd_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","और यह भी कहना कि तेरा ख़ादिम या'क़ूब ख़ुद भी हमारे पीछे पीछे आ रहा है, उस ने यह सोचा कि मैं इस नज़राना से जो मुझ से पहले वहाँ जायेगा उसे ख़ुश कर लूँ, तब उस का मुँह देखूँगा, शायद यूँ वह मुझको क़ुबूल कर ले। ");
INSERT INTO urd_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","चुनाँचे वह नज़राना उसके आगे आगे पार गया लेकिन वह ख़ुद उस रात अपने डेरे में रहा। ");
INSERT INTO urd_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","और वह उसी रात उठा और अपनी दोनों बीवियों दोनों लौंडियों और ग्यारह बेटों को लेकर उनको यबूक के घाट से पार उतारा। ");
INSERT INTO urd_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","और उनको लेकर नदी पार कराया और अपना सब कुछ पार भेज दिया। ");
INSERT INTO urd_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","और या'क़ूब अकेला रह गया और पौ फटने के वक़्त तक एक शख़्स वहाँ उस से कुश्ती लड़ता रहा। ");
INSERT INTO urd_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","जब उसने देखा कि वह उस पर ग़ालिब नहीं होता, तो उसकी रान को अन्दर की तरफ़ से छुआ और या'क़ूब की रान की नस उसके साथ कुश्ती करने में चढ़ गई। ");
INSERT INTO urd_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","और उसने कहा, “मुझे जाने दे क्यूँकि पौ फट चली,” या'क़ूब ने कहा, “जब तक तू मुझे बरकत न दे, मैं तुझे जाने नहीं दूँगा।” ");
INSERT INTO urd_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","तब उसने उससे पूछा, तेरा क्या नाम है? उसने जवाब दिया, “या'क़ूब।” ");
INSERT INTO urd_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","उसने कहा, “तेरा नाम आगे को या'क़ूब नहीं बल्कि इस्राईल होगा, क्यूँकि तूने ख़ुदा और आदमियों के साथ ज़ोर आज़माई की और ग़ालिब हुआ।” ");
INSERT INTO urd_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","तब या'क़ूब ने उससे कहा, “मैं तेरी मिन्नत करता हूँ, तू मुझे अपना नाम बता दे।” उसने कहा, “तू मेरा नाम क्यूँ पूछता है?” और उसने उसे वहाँ बरकत दी। ");
INSERT INTO urd_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","और या'क़ूब ने उस जगह का नाम फ़नीएल रख्खा और कहा, “मैंने ख़ुदा को आमने सामने देखा, तो भी मेरी जान बची रही।” ");
INSERT INTO urd_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","और जब वह फ़नीएल से गुज़र रहा था तो आफ़ताब तुलू' हुआ और वह अपनी रान से लंगड़ाता था। ");
INSERT INTO urd_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","इसी वजह से बनी इस्राईल उस नस की जो रान में अन्दर की तरफ़ है आज तक नहीं खाते, क्यूँकि उस शख़्स ने या'क़ूब की रान की नस को जो अन्दर की तरफ़ से चढ़ गई थी छू दिया था। ");
INSERT INTO urd_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","और या'क़ूब ने अपनी आँखें उठा कर नज़र की और क्या देखता है कि 'ऐसौ चार सौ आदमी साथ लिए चला आ रहा है। तब उसने लियाह और राख़िल और दोनों लौंडियों को बच्चे बाँट दिए। ");
INSERT INTO urd_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","और लौंडियों और उनके बच्चों को सबसे आगे, और लियाह और उसके बच्चों को पीछे, और राख़िल और यूसुफ़ को सबसे पीछे रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","और वह खुद उनके आगे — आगे चला और अपने भाई के पास पहुँचते — पहुँचते सात बार ज़मीन तक झुका। ");
INSERT INTO urd_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","और 'ऐसौ उससे मिलने को दौड़ा, और उससे बग़लगीर हुआ और उसे गले लगाया और चूमा, और वह दोनों रोए। ");
INSERT INTO urd_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","फिर उसने आँखें उठाई और 'औरतों और बच्चों को देखा और कहा कि यह तेरे साथ कौन हैं? उसने कहा, “यह वह बच्चे हैं जो ख़ुदा ने तेरे ख़ादिम को इनायत किए हैं।” ");
INSERT INTO urd_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","तब लौडियाँ और उनके बच्चे नज़दीक आए और अपने आप को झुकाया। ");
INSERT INTO urd_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","फिर लियाह अपने बच्चों के साथ नज़दीक आई और वह झुके, आख़िर को यूसुफ़ और राख़िल पास आए और उन्होंने अपने आप को झुकाया। ");
INSERT INTO urd_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","फिर उसने कहा कि उस बड़े गोल से जो मुझे मिला तेरा क्या मतलब है? उसने कहा, यह कि मैं अपने ख़ुदावन्द की नज़र में मक़्बूल ठहरूँ। ");
INSERT INTO urd_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","तब 'ऐसौ ने कहा, “मेरे पास बहुत हैं; इसलिए ऐ मेरे भाई जो तेरा है वह तेरा ही रहे।” ");
INSERT INTO urd_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","या'क़ूब ने कहा, “नहीं अगर मुझ पर तेरे करम की नज़र हुई है तो मेरा नज़राना मेरे हाथ से क़ुबूल कर, क्यूँकि मैंने तो तेरा मुँह ऐसा देखा जैसा कोई ख़ुदा का मुँह देखता है, और तू मुझ से राज़ी हुआ। ");
INSERT INTO urd_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","इसलिए मेरा नज़राना जो तेरे सामने पेश हुआ उसे क़ुबूल कर ले, क्यूँकि ख़ुदा ने मुझ पर बड़ा फ़ज़ल किया है और मेरे पास सब कुछ है।” ग़र्ज़ उसने उसे मजबूर किया, तब उसने उसे ले लिया। ");
INSERT INTO urd_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","और उसने कहा कि अब हम कूच करें और चल पड़ें, और मैं तेरे आगे — आगे हो लूँगा। ");
INSERT INTO urd_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","उसने उसे जवाब दिया, “मेरा ख़ुदावन्द जानता है कि मेरे साथ नाज़ुक बच्चे और दूध पिलाने वाली भेड़ — बकरियाँ और गाय हैं। अगर उनकी एक दिन भी हद से ज़्यादा हंकाएँ तो सब भेड़ बकरियाँ मर जाएँगी। ");
INSERT INTO urd_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","इसलिए मेरा ख़ुदावन्द अपने ख़ादिम से पहले रवाना हो जाए, और मैं चौपायों और बच्चों की रफ़्तार के मुताबिक़ आहिस्ता — आहिस्ता चलता हुआ अपने ख़ुदावन्द के पास श'ईर में आ जाऊँगा।” ");
INSERT INTO urd_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","तब 'ऐसौ ने कहा कि मर्ज़ी हो तो मैं जो लोग मेरे साथ हैं उनमें से थोड़े तेरे साथ छोड़ता जाऊँ। उसने कहा, इसकी क्या ज़रूरत है? मेरे ख़ुदावन्द की नज़र — ए — करम मेरे लिए काफ़ी है। ");
INSERT INTO urd_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","तब 'ऐसौ उसी रोज़ उल्टे पाँव श'ईर को लौटा। ");
INSERT INTO urd_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","और या'क़ूब सफ़र करता हुआ सुक्कात में आया, और अपने लिए एक घर बनाया और अपने चौपायों के लिए झोंपड़े खड़े किए। इसी वजह से इस जगह का नाम सुक्कात पड़ गया। ");
INSERT INTO urd_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","और या'क़ूब जब फ़द्दान अराम से चला तो मुल्क — ए — कना'न के एक शहर सिकम के नज़दीक सही — ओ — सलामत पहुँचा और उस शहर के सामने अपने डेरे लगाए। ");
INSERT INTO urd_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","और ज़मीन के जिस हिस्से पर उसने अपना ख़ेमा खड़ा किया था, उसे उसने सिकम के बाप हमोर के लड़कों से चाँदी के सौ सिक्के देकर ख़रीद लिया। ");
INSERT INTO urd_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","और वहाँ उस ने ख़ुदा, के लिए एक मसबह बनाया और उसका नाम एल — इलाह — ए — इस्राईल रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","और लियाह की बेटी दीना जो या'क़ूब से उसके पैदा हुई थी, उस मुल्क की लड़कियों के देखने को बाहर गई। ");
INSERT INTO urd_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","तब उस मुल्क के अमीर हव्वी हमोर के बेटे सिकम ने उसे देखा, और उसे ले जाकर उसके साथ मुबाश्रत की और उसे ज़लील किया। ");
INSERT INTO urd_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","और उसका दिल या'क़ूब की बेटी दीना से लग गया, और उसने उस लड़की से इश्क में मीठी — मीठी बातें कीं। ");
INSERT INTO urd_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","और सिकम ने अपने बाप हमोर से कहा कि इस लड़की को मेरे लिए ब्याह ला दे। ");
INSERT INTO urd_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","और या'क़ूब को मा'लूम हुआ कि उसने उसकी बेटी दीना को बे इज़्ज़त किया है। लेकिन उसके बेटे चौपायों के साथ जंगल में थे इसलिए या'क़ूब उनके आने तक चुपका रहा। ");
INSERT INTO urd_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","तब सिकम का बाप हमोर निकल कर या'क़ूब से बातचीत करने को उसके पास गया। ");
INSERT INTO urd_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","और या'क़ूब के बेटे यह बात सुनते ही जंगल से आए। यह शख़्स बड़े नाराज़ और ख़ौफ़नाक थे, क्यूँकि उसने जो या'क़ूब की बेटी से मुबाश्रत की तो बनी — इस्राईल में ऐसा मकरूह फ़ेल किया जो हरगिज़ मुनासिब न था। ");
INSERT INTO urd_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","तब हमोर उन से कहने लगा कि मेरा बेटा सिकम तुम्हारी बेटी को दिल से चाहता है, उसे उसके साथ ब्याह दो। ");
INSERT INTO urd_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","हम से समधियाना कर लो; अपनी बेटियाँ हम को दो और हमारी बेटियाँ आप लो। ");
INSERT INTO urd_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","तो तुम हमारे साथ बसे रहोगे और यह मुल्क तुम्हारे सामने है, इसमें ठहरना और तिजारत करना और अपनी जायदादें खड़ी कर लेना। ");
INSERT INTO urd_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","और सिकम ने इस लड़की के बाप और भाइयों से कहा, कि मुझ पर बस तुम्हारे करम की नज़र हो जाए, फिर जो कुछ तुम मुझ से कहोगे मैं दूँगा। ");
INSERT INTO urd_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","मैं तुम्हारे कहने के मुताबिक़ जितना मेहर और जहेज़ तुम मुझ से तलब करो, दूँगा लेकिन लड़की को मुझ से ब्याह दो। ");
INSERT INTO urd_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","तब या'क़ूब के बेटों ने इस वजह से कि उसने उनकी बहन दीना को बे'इज़्ज़त किया था, रिया से सिकम और उसके बाप हमोर को जवाब दिया, ");
INSERT INTO urd_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","और कहने लगे, “हम यह नहीं कर सकते कि नामख़्तून आदमी को अपनी बहन दें, क्यूँकि इसमें हमारी बड़ी रुस्वाई है। ");
INSERT INTO urd_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","लेकिन जैसे हम हैं अगर तुम वैसे ही हो जाओ, कि तुम्हारे हर आदमियों का ख़तना कर दिया जाए तो हम राज़ी हो जाएँगे। ");
INSERT INTO urd_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","और हम अपनी बेटियाँ तुम्हे देंगे और तुम्हारी बेटियाँ लेंगे और तुम्हारे साथ रहेंगे और हम सब एक क़ौम हो जाएँगे। ");
INSERT INTO urd_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","और अगर तुम ख़तना कराने के लिए हमारी बात न मानी तो हम अपनी लड़की लेकर चले जाएँगे।” ");
INSERT INTO urd_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","उनकी बातें हमोर और उसके बेटे सिकम को पसन्द आई। ");
INSERT INTO urd_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","और उस जवान ने इस काम में ताख़ीर न की क्यूँकि उसे या'क़ूब की बेटी की चाहत थी, और वह अपने बाप के सारे घराने में सबसे ख़ास था। ");
INSERT INTO urd_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","फिर हमोर और उसका बेटा सिकम अपने शहर के फाटक पर गए और अपने शहर के लोगों से यूँ बातें करने लगे कि, ");
INSERT INTO urd_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","यह लोग हम से मेल जोल रखते हैं; तब वह इस मुल्क में रह कर सौदागरी करें, क्यूँकि इस मुल्क में उनके लिए बहुत गुन्जाइश है, और हम उनकी बेटियाँ ब्याह लें और अपनी बेटियाँ उनकी दें। ");
INSERT INTO urd_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","और वह भी हमारे साथ रहने और एक क़ौम बन जाने को राज़ी हैं, मगर सिर्फ़ इस शर्त पर कि हम में से हर आदमी का ख़तना किया जाए जैसा उनका हुआ है। ");
INSERT INTO urd_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","क्या उनके चौपाए और माल और सब जानवर हमारे न हो जाएँगे? हम सिर्फ़ उनकी मान लें और वह हमारे साथ रहने लगेंगे। ");
INSERT INTO urd_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","तब उन सभों ने जो उसके शहर के फाटक से आया — जाया करते थे, हमोर और उसके बेटे सिकम की बात मानी और जितने उसके शहर के फाटक से आया — जाया करते थे उनमें से हर आदमी ने ख़तना कराया। ");
INSERT INTO urd_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","और तीसरे दिन जब वह दर्द में मुब्तिला थे, तो यूँ हुआ कि या'क़ूब के बेटों में से दीना के दो भाई, शमौन और लावी, अपनी अपनी तलवार लेकर अचानक शहर पर आ पड़े और सब आदमियों को क़त्ल किया। ");
INSERT INTO urd_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","और हमोर और उसके बेटे सिकम को भी तलवार से क़त्ल कर डाला और सिकम के घर से दीना को निकाल ले गए। ");
INSERT INTO urd_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","और या'क़ूब के बेटे मक़्तूलों पर आए और शहर को लूटा, इसलिए कि उन्होंने उनकी बहन को बे'इज़्ज़त किया था। ");
INSERT INTO urd_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","उन्होंने उनकी भेड़ — बकरियाँ और गाय — बैल, गधे और जो कुछ शहर और खेत में था ले लिया। ");
INSERT INTO urd_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","और उनकी सब दौलत लूटी और उनके बच्चों और बीवियों को क़ब्ज़े में कर लिया, और जो कुछ घर में था सब लूट — घसूट कर ले गए। ");
INSERT INTO urd_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","तब या'क़ूब ने शमौन और लावी से कहा, कि तुम ने मुझे कुढ़ाया क्यूँकि तुम ने मुझे इस मुल्क के बाशिन्दों, या'नी कना'नियों और फ़रिज़्ज़ियों में नफ़रतअंगेज बना दिया, क्यूँकि मेरे साथ तो थोड़े ही आदमी हैं; अब वह मिल कर मेरे मुक़ाबिले को आएँगे और मुझे क़त्ल कर देंगे, और मैं अपने घराने समेत बर्बाद हो जाऊँगा। ");
INSERT INTO urd_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","उन्होंने कहा, “तो क्या उसे मुनासिब था कि वह हमारी बहन के साथ कसबी की तरह बर्ताव करता?” ");
INSERT INTO urd_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","और ख़ुदा ने या'क़ूब से कहा, कि उठ बैतएल को जा और वहीं रह और वहाँ ख़ुदा के लिए, जो तुझे उस वक़्त दिखाई दिया जब तू अपने भाई 'ऐसौ के पास से भागा जा रहा था, एक मज़बह बना। ");
INSERT INTO urd_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","तब या'क़ूब ने अपने घराने और अपने सब साथियों से कहा “ग़ैर मा'बूदों को जो तुम्हारे बीच हैं दूर करो, और पाकी हासिल करके अपने कपड़े बदल डालो। ");
INSERT INTO urd_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","और आओ, हम रवाना हों और बैत — एल को जाएँ, वहाँ मैं ख़ुदा के लिए जिसने मेरी तंगी के दिन मेरी दुआ क़ुबूल की और जिस राह में मैं चला मेरे साथ रहा, मज़बह बनाऊँगा।” ");
INSERT INTO urd_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","तब उन्होंने सब ग़ैर मा'बूदों को जो उनके पास थे और मुन्दरों को जो उनके कानों में थे, या'क़ूब को दे दिया और या'क़ूब ने उनको उस बलूत के दरख़्त के नीचे जो सिकम के नज़दीक था दबा दिया। ");
INSERT INTO urd_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","और उन्होंने कूच किया और उनके आस पास के शहरों पर ऐसा बड़ा ख़ौफ़ छाया हुआ था कि उन्होंने या'क़ूब के बेटों का पीछा न किया। ");
INSERT INTO urd_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","और या'क़ूब उन सब लोगों के साथ जो उसके साथ थे लूज़ पहुँचा, बैत — एल यही है और मुल्क — ए — कना'न में है। ");
INSERT INTO urd_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","और उसने वहाँ मज़बह बनाया और उस मुक़ाम का नाम एल — बैतएल रख्खा, क्यूँकि जब वह अपने भाई के पास से भागा जा रहा था तो ख़ुदा वहीं उस पर ज़ाहिर हुआ था। ");
INSERT INTO urd_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","और रिब्क़ा की दाया दबोरा मर गई और वह बैतएल की उतराई में बलूत के दरख़्त के नीचे दफ़्न हुई, और उस बलूत का नाम अल्लोन बकूत रख्खा गया। ");
INSERT INTO urd_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","और या'क़ूब के फ़द्दान अराम से आने के बाद ख़ुदा उसे फिर दिखाई दिया और उसे बरकत बख़्शी। ");
INSERT INTO urd_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","और ख़ुदा ने उसे कहा कि तेरा नाम या'क़ूब है; तेरा नाम आगे को या'क़ूब न कहलाएगा, बल्कि तेरा नाम इस्राईल होगा। तब उसने उसका नाम इस्राईल रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","फिर ख़ुदा ने उसे कहा, कि मैं ख़ुदा — ए — क़ादिर — ए — मुतलक हूँ, तू कामयाब हो और बहुत हो जा। तुझ से एक क़ौम, बल्कि क़ौमों के क़बीले पैदा होंगे और बादशाह तेरे सुल्ब से निकलेंगे। ");
INSERT INTO urd_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","और यह मुल्क जो मैंने अब्रहाम और इस्हाक़ को दिया है, वह तुझ को दूँगा और तेरे बाद तेरी नसल को भी यही मुल्क दूँगा। ");
INSERT INTO urd_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","और ख़ुदा जिस जगह उससे हम कलाम हुआ, वहीं से उसके पास से ऊपर चला गया। ");
INSERT INTO urd_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","तब या'क़ूब ने उस जगह जहाँ वह उससे हम — कलाम हुआ, पत्थर का एक सुतून खड़ा किया और उस पर तपावन किया और तेल डाला। ");
INSERT INTO urd_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","और या'क़ूब ने उस मक़ाम का नाम जहाँ ख़ुदा उससे हम कलाम हुआ 'बैतएल' रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","और वह बैतएल से चले और इफ़रात थोड़ी ही दूर रह गया था कि राख़िल के दर्द — ए — ज़िह लगा, और वज़ा' — ए — हम्ल में निहायत दिक्कत हुई। ");
INSERT INTO urd_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","और जब वह सख़्त दर्द में मुब्तिला थी तो दाई ने उससे कहा, “डर मत, अब के भी तेरे बेटा ही होगा।” ");
INSERT INTO urd_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","और यूँ हुआ कि उसने मरते — मरते उसका नाम बिनऊनी रख्खा और मर गई, लेकिन उसके बाप ने उसका नाम बिनयमीन रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","और राख़िल मर गई और इफ़रात, या'नी बैतलहम के रास्ते में दफ़्न हुई। ");
INSERT INTO urd_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","और या'क़ूब ने उसकी क़ब्र पर एक सुतून खड़ा कर दिया। राख़िल की क़ब्र का यह सुतून आज तक मौजूद है। ");
INSERT INTO urd_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","और इस्राईल आगे बढ़ा और 'अद्र के बुर्ज की परली तरफ़ अपना डेरा लगाया। ");
INSERT INTO urd_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","और इस्राईल के उस मुल्क में रहते हुए ऐसा हुआ कि रूबिन ने जाकर अपने बाप की हरम बिल्हाह से मुबाश्रत की और इस्राईल को यह मा'लूम हो गया। ");
INSERT INTO urd_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","उस वक़्त या'क़ूब के बारह बेटे थे लियाह के बेटे यह थे: रूबिन या'क़ूब का पहलौठा, और शमौन और लावी और यहूदाह, इश्कार और ज़बूलून। ");
INSERT INTO urd_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","और राख़िल के बेटे: यूसुफ़ और बिनयमीन थे। ");
INSERT INTO urd_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","और राख़िल की लौंडी बिल्हाह के बेटे, दान और नफ़्ताली थे। ");
INSERT INTO urd_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","और लियाह की लौडी ज़िलफ़ा के बेटे, जद्द और आशर थे। यह सब या'क़ूब के बेटे हैं जो फ़द्दान अराम में पैदा हुए। ");
INSERT INTO urd_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","और या'क़ूब ममरे में जो करयत अरबा' या'नी हबरून है जहाँ अब्रहाम और इस्हाक़ ने डेरा किया था, अपने बाप इस्हाक़ के पास आया। ");
INSERT INTO urd_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","और इस्हाक़ एक सौ अस्सी साल का हुआ। ");
INSERT INTO urd_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","तब इस्हाक़ ने दम छोड़ दिया और वफ़ात पाई और बूढ़ा और पूरी उम्र का हो कर अपने लोगों में जा मिला, और उसके बेटों 'ऐसौ और या'क़ूब ने उसे दफ़न किया। ");
INSERT INTO urd_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","और 'ऐसौ या'नी अदोम का नसबनामा यह है। ");
INSERT INTO urd_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","'ऐसौ कना'नी लड़कियों में से हित्ती ऐलोन की बेटी 'अद्दा को, और हव्वी सबा'ओन की नवासी और 'अना की बेटी ओहलीबामा की, ");
INSERT INTO urd_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","और इस्मा'ईल की बेटी और नबायोत की बहन बशामा को ब्याह लाया। ");
INSERT INTO urd_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","और 'ऐसौ से 'अद्दा के इलिफ़ज़ पैदा हुआ, और बशामा के र'ऊएल पैदा हुआ, ");
INSERT INTO urd_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","और ओहलीबामा के य'ओस और यालाम और क़ोरह पैदा हुए। यह 'ऐसौ के बेटे हैं जो मुल्क — ए — कना'न में पैदा हुए। ");
INSERT INTO urd_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","और 'ऐसौ अपनी बीवियों और बेटे बेटियों और अपने घर के सब नौकर चाकरों और अपने चौपायों और तमाम जानवरों और अपने सब माल अस्बाब को, जो उसने मुल्कए — कना'न में जमा' किया था, लेकर अपने भाई या'क़ूब के पास से एक दूसरे मुल्क को चला गया। ");
INSERT INTO urd_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","क्यूँकि उनके पास इस क़दर सामान हो गया था कि वह एक जगह रह नहीं सकते थे, और उनके चौपायों की कसरत की वजह से उस ज़मीन में जहाँ उनका क़याम था गुंजाइश न थी। ");
INSERT INTO urd_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","तब 'ऐसौ जिसे अदोम भी कहते हैं, कोह — ए — श'ईर में रहने लगा। ");
INSERT INTO urd_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","और 'ऐसौ का जो कोह — ए — श'ईर के अदोमियों का बाप है यह नसबनामा है। ");
INSERT INTO urd_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","'ऐसौ के बेटों के नाम यह हैं: इलिफ़ज़, 'ऐसौ की बीवी 'अद्दा का बेटा; और र'ऊएल, 'ऐसौ की बीवी बशामा का बेटा। ");
INSERT INTO urd_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","इलिफ़ज़ के बेटे, तेमान और ओमर और सफ़ी और जा'ताम और कनज़ थे। ");
INSERT INTO urd_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","और तिमना' 'ऐसौ के बेटे इलिफ़ज़ की हरम थी, और इलिफ़ज़ से उसके 'अमालीक पैदा हुआ; और 'ऐसौ की बीवी 'अद्दा के बेटे यह थे। ");
INSERT INTO urd_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","र'ऊएल के बेटे यह हैं: नहत और ज़ारह और सम्मा और मिज़्ज़ा, यह 'ऐसौ की बीवी बशामा के बेटे थे। ");
INSERT INTO urd_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","और ओहलीबामा के बेटे, जो 'अना की बेटी सबा'ओन की नवासी और 'ऐसौ की बीवी थी, यह हैं: 'ऐसौ से उसके य'ओस और यालाम और कोरह पैदा हुए। ");
INSERT INTO urd_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","और 'ऐसौ की औलाद में जो रईस थे वह यह हैं: 'ऐसी के पहलौटे बेटे इलिफ़ज़ की औलाद में रईस तेमान, रईस ओमर, रईस सफ़ी, रईस कनज़, ");
INSERT INTO urd_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","रईस कोरह, रईस जा'ताम, रईस 'अमालीक। यह वह रईस हैं जो इलिफ़ज़ से मुल्क — ए — अदोम में पैदा हुए और 'अद्दा के फ़र्ज़न्द थे। ");
INSERT INTO urd_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","और र'ऊएल — बिन 'ऐसौ के बेटे यह हैं: रईस नहत, रईस ज़ारह, रईस सम्मा, रईस मिज़्ज़ा। यह वह रईस हैं जो र'ऊएल से मुल्क — ए — अदोम में पैदा हुए और ऐसौ की बीवी बशामा के फ़ज़न्द थे। ");
INSERT INTO urd_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","और 'ऐसौ की बीवी ओहलीबामा की औलाद यह हैं: रईस य'ऊस, रईस यालाम, रईस कोरह। यह वह रईस हैं जो 'ऐसौ की बीवी उहलीबामा बिन्त 'अना के फ़र्ज़न्द थे। ");
INSERT INTO urd_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","और 'ऐसौ या'नी अदोम की औलाद और उनके रईस यह हैं। ");
INSERT INTO urd_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","और श'ईर होरी के बेटे जो उस मुल्क के बाशिन्दे थे, यह हैं: लोप्तान और सोबल और सबा'ओन और 'अना ");
INSERT INTO urd_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","और दीसोन और एसर और दीसान; बनी श'ईर में से जो होरी रईस मुल्क — ए — अदोम में हुए ये हैं। ");
INSERT INTO urd_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","होरी और हीमाम लोतान के बेटे, और तिम्ना' लोतान की बहन थी। ");
INSERT INTO urd_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","और यह सोबल के बेटे हैं: 'अलवान और मानहत और एबाल और सफ़ी और ओनाम। ");
INSERT INTO urd_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","और सबा'ओन के बेटे यह हैं: अय्याह और 'अना; यह वह 'अना है जिसे अपने बाप के गधों को वीराने में चराते वक़्त गर्म चश्मे मिले। ");
INSERT INTO urd_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","और 'अना की औलाद यह हैं: दीसोन और ओहलीबामा बिन्त 'अना। ");
INSERT INTO urd_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","और दीसोन के बेटे यह हैं: हमदान और इशबान और यित्रान और किरान। ");
INSERT INTO urd_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","यह एसर के बेटे हैं: बिलहान और ज़ावान और 'अकान। ");
INSERT INTO urd_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दीसान के बेटे यह है: 'ऊज़ और इरान। ");
INSERT INTO urd_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","जो होरियों में से रईस हुए वह यह हैं: रईस 'लुतान, रईस, सोबल 'रईस सब'उन और रईस 'अना, ");
INSERT INTO urd_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","रईस दीसोन, रईस एसर, रईस दीसान; यह उन होरियों के रईस हैं जो मुल्कए — श'ईर में थे। ");
INSERT INTO urd_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","यही वह बादशाह हैं जो मुल्क — ए — अदोम से पहले उससे कि इस्राईल का कोई बादशाह हो, मुसल्लत थे। ");
INSERT INTO urd_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बाला' — बिनब'ओर अदोम में एक बादशाह था, और उसके शहर का नाम दिन्हाबा था। ");
INSERT INTO urd_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","बाला' मर गया और यूबाब — बिन ज़ारह जो बुसराही था, उसकी जगह बादशाह हुआ। ");
INSERT INTO urd_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","फिर यूबाब मर गया और हुशीम जो तेमानियों के मुल्क का बाशिन्दा था, उसका जानशीन हुआ। ");
INSERT INTO urd_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","और हुशीम मर गया और हदद — बिन — बदद जिसने मोआब के मैदान में मिदियानियों को मारा, उसका जानशीन हुआ और उसके शहर का नाम 'अवीत था। ");
INSERT INTO urd_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","और हदद मर गया और शम्ला जो मुसरिका का था उसका जानशीन हुआ। ");
INSERT INTO urd_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","और शमला मर गया और साउल उसका जानशीन हुआ ये रहुबुत का था जो दरियाई फुर्रात के बराबर है। ");
INSERT INTO urd_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","और साऊल मर गया और बा'लहनानबिन — 'अकबूर उसका जानशीन हुआ। ");
INSERT INTO urd_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","और बा'लहनान — बिन — 'अकबूर मर गया और हदर उसका जानशीन हुआ, और उसके शहर का नाम पाऊ और उसकी बीवी का नाम महेतबएल था, जो मतरिद की बेटी और मेज़ाहाब की नवासी थी। ");
INSERT INTO urd_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","फिर ऐसौ के रईसों के नाम उनके ख़ान्दानों और मक़ामो और नामों के मुताबिक़ यह है: रईस, तिम्ना, रईस 'अलवा, रईस यतेत, ");
INSERT INTO urd_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","रईस ओहलीबामा, रईस ऐला, रईस फिनोन, ");
INSERT INTO urd_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","रईस क़नज़, रईस तेमान, रईस मिबसार, ");
INSERT INTO urd_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","रईस मज्दाएल, रईस इराम; अदोम का रईस यही है, जिनके नाम उनके मक़्बूज़ा मुल्क में उनके घर के मुताबिक़ दिए गए हैं। यह हाल अदोमियों के बाप 'ऐसौ का है। ");
INSERT INTO urd_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","और या'क़ूब मुल्क — ए — कना'न में रहता था, जहाँ उसका बाप मुसाफ़िर की तरह रहा था। ");
INSERT INTO urd_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","या'क़ूब की नसल का हाल यह है: कि यूसुफ़ सत्रह साल की उम्र में अपने भाइयों के साथ भेड़ — बकरियाँ चराया करता था। यह लड़का अपने बाप की बीवियों, बिल्हाह और ज़िल्फ़ा के बेटों के साथ रहता था और वह उनके बुरे कामों की ख़बर बाप तक पहुँचा देता था। ");
INSERT INTO urd_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","और इस्राईल यूसुफ़ को अपने सब बेटों से ज़्यादा प्यार करता था क्यूँकि वह उसके बुढ़ापे का बेटा था, और उसने उसे एक बूक़लमून क़बा भी बनवा दी। ");
INSERT INTO urd_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","और उसके भाइयों ने देखा कि उनका बाप उसके सब भाइयों से ज़्यादा उसी को प्यार करता है, इसलिए वह उससे अदावत रखने लगे और ठीक तौर से बात भी नहीं करते थे। ");
INSERT INTO urd_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","और यूसुफ़ ने एक ख़्वाब देखा जिसे उसने अपने भाइयों को बताया, तो वह उससे और भी अदावत रखने लगे। ");
INSERT INTO urd_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","और उसने उनसे कहा, “ज़रा वह ख़्वाब तो सुनो, जो मैंने देखा है: ");
INSERT INTO urd_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","हम खेत में पूले बांधते थे और क्या देखता हूँ कि मेरा पूला उठा और सीधा खड़ा हो गया, और तुम्हारे पूलों ने मेरे पूले को चारों तरफ़ से घेर लिया और उसे सिज्दा किया।” ");
INSERT INTO urd_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","तब उसके भाइयों ने उससे कहा, कि क्या तू सचमुच हम पर सल्तनत करेगा या हम पर तेरा तसल्लुत होगा? और उन्होंने उसके ख़्वाबों और उसकी बातों की वजह से उससे और भी ज़्यादा अदावत रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","फिर उसने दूसरा ख़्वाब देखा और अपने भाइयों को बताया। उसने कहा, “देखो! मुझे एक और ख़्वाब दिखाई दिया है, कि सूरज और चाँद और ग्यारह सितारों ने मुझे सिज्दा किया।” ");
INSERT INTO urd_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","और उसने इसे अपने बाप और भाइयों दोनों को बताया; तब उसके बाप ने उसे डाँटा और कहा कि यह ख़्वाब क्या है जो तूने देखा है? क्या मैं और तेरी माँ और तेरे भाई सचमुच तेरे आगे ज़मीन पर झुक कर तुझे सिज्दा करेंगे? ");
INSERT INTO urd_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","और उसके भाइयों को उससे हसद हो गया, लेकिन उसके बाप ने यह बात याद रख्खी। ");
INSERT INTO urd_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","और उसके भाई अपने बाप की भेड़ — बकरियाँ चराने सिकम को गए। ");
INSERT INTO urd_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","तब इस्राईल ने यूसुफ़ से कहा, “तेरे भाई सिकम में भेड़ — बकरियों को चरा रहे होंगे, इसलिए आ कि मैं तुझे उनके पास भेज़ें।” उसने उसे कहा, “मैं तैयार हूँ।” ");
INSERT INTO urd_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","तब उसने कहा, “तू जा कर देख कि तेरे भाइयों का और भेड़ — बकरियों का क्या हाल है, और आकर मुझे ख़बर दे।” तब उसने उसे हबरून की वादी से भेजा और वह सिकम में आया। ");
INSERT INTO urd_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","और एक शख़्स ने उसे मैदान में इधर — उधर आवारा फिरते पाया; यह देख कर उस शख़्स ने उससे पूछा, “तू क्या ढूंडता है?” ");
INSERT INTO urd_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","उसने कहा, “मैं अपने भाइयों को ढूंडता हूँ। ज़रा मुझे बता दे कि वह भेड़ बकरियों को कहाँ चरा रहे हैं?” ");
INSERT INTO urd_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","उस शख़्स ने कहा, “वह यहाँ से चले गए, क्यूँकि मैंने उनको यह कहते सुना, 'चलो, हम दूतैन को जाएँ।” चुनाँचे यूसुफ़ अपने भाइयों की तलाश में चला और उनको दूतैन में पाया। ");
INSERT INTO urd_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","और जूँ ही उन्होंने उसे दूर से देखा, इससे पहले कि वह नज़दीक पहुँचे, उसके क़त्ल का मन्सूबा बाँधा। ");
INSERT INTO urd_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","और आपस में कहने लगे, “देखो! ख़्वाबों का देखने वाला आ रहा है। ");
INSERT INTO urd_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","आओ, अब हम उसे मार डालें और किसी गढ़े में डाल दें और यह कह देंगे कि कोई बुरा दरिन्दा उसे खा गया; फिर देखेंगे कि उसके ख़्वाबों का अन्जाम क्या होता है।” ");
INSERT INTO urd_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","तब, रूबिन ने यह सुन कर उसे उनके हाथों से बचाया और कहा, “हम उसकी जान न लें।” ");
INSERT INTO urd_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","और रूबिन ने उनसे यह भी कहा कि ख़ून न बहाओ बल्कि उसे इस गढ़े में जो वीराने में है डाल दो, लेकिन उस पर हाथ न उठाओ। वह चाहता था कि उसे उनके हाथ से बचा कर उसके बाप के पास सलामत पहुँचा दे। ");
INSERT INTO urd_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","और यूँ हुआ कि जब यूसुफ़ अपने भाइयों के पास पहुँचा, तो उन्होंने उसकी बू क़लमून क़बा की जो वह पहने था उतार लिया; ");
INSERT INTO urd_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","और उसे उठा कर गढ़े में डाल दिया। वह गढ़ा सूखा था, उसमें ज़रा भी पानी न था। ");
INSERT INTO urd_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","और वह खाना खाने बैठे और ऑखें उठाई तो देखा कि इस्माईलियों का एक काफ़िला जिल'आद से आ रहा है, और गर्म मसाल्हे और रौग़न बलसान और मुर्र ऊँटों पर लादे हुए मिस्र को लिए जा रहा है। ");
INSERT INTO urd_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","तब यहूदाह ने अपने भाइयों से कहा किअगर हम अपने भाई को मार डालें और उसका खू़न छिपाएँ तो क्या नफ़ा' होगा? ");
INSERT INTO urd_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","आओ, उसे इस्माईलियों के हाथ बेच डालें कि हमारे हाथ उस पर न उठे क्यूँकि वह हमारा भाई और हमारा खू़न है। उसके भाइयों ने उसकी बात मान ली। ");
INSERT INTO urd_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","फिर वह मिदिया'नी सौदागर उधर से गुज़रे, तब उन्होंने यूसुफ़ को खींच कर गढ़े से बाहर निकाला और उसे इस्माईलियों के हाथ बीस रुपये को बेच डाला और वह यूसुफ़ को मिस्र में ले गए। ");
INSERT INTO urd_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","जब रूबिन गढ़े पर लौट कर आया और देखा कि यूसुफ़ उसमें नहीं है तो अपना लिबास चाक किया। ");
INSERT INTO urd_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","और अपने भाइयों के पास उल्टा फिरा और कहने लगा, कि लड़का तो वहाँ नहीं है, अब मैं कहाँ जाऊँ? ");
INSERT INTO urd_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","फिर उन्होंने यूसुफ़ की क़बा लेकर और एक बकरा ज़बह करके उसे उसके खू़न में तर किया। ");
INSERT INTO urd_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","और उन्होंने उस बूक़लमून क़बा को भिजवा दिया। फिर वह उसे उनके बाप के पास ले आए और कहा, “हम को यह चीज़ पड़ी मिली; अब तू पहचान कि यह तेरे बेटे की क़बा है या नहीं?” ");
INSERT INTO urd_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","और उसने उसे पहचान लिया और कहा, “यह तो मेरे बेटे की क़बा है। कोई बुरा दरिन्दा उसे खा गया है, यूसुफ़ बेशक फाड़ा गया।” ");
INSERT INTO urd_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","तब या'क़ूब ने अपना लिबास चाक किया और टाट अपनी कमर से लपेटा, और बहुत दिनों तक अपने बेटे के लिए मातम करता रहा। ");
INSERT INTO urd_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","और उसके सब बेटे बेटियाँ उसे तसल्ली देने जाते थे, लेकिन उसे तसल्ली न होती थी। वह यही कहता रहा, कि मैं तो मातम ही करता हुआ क़ब्र में अपने बेटे से जा मिलूँगा। इसलिए उसका बाप उसके लिए रोता रहा। ");
INSERT INTO urd_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","और मिदियानियों ने उसे मिस्र में फूतीफ़ार के हाथ जो फ़िर'औन का एक हाकिम और जिलौदारों का सरदार था बेचा। ");
INSERT INTO urd_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","उन्ही दिनों में ऐसा हुआ कि यहूदाह अपने भाइयों से जुदा हो कर एक 'अदूल्लामी आदमी के पास, जिसका नाम हीरा था गया। ");
INSERT INTO urd_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","और यहूदाह ने वहाँ सुवा' नाम किसी कना'नी की बेटी को देखा और उससे ब्याह करके उसके पास गया। ");
INSERT INTO urd_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","वह हामिला हुई और उसके एक बेटा हुआ, जिसका नाम उसने 'एर रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","और वह फिर हामिला हुई और एक बेटा हुआ और उसका नाम ओनान रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","फिर उसके एक और बेटा हुआ और उसका नाम सीला रख्खा, और यहूदाह कज़ीब में था जब इस 'औरत के यह लड़का हुआ। ");
INSERT INTO urd_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","और यहूदाह अपने पहलौठे बेटे 'एर के लिए एक 'औरत ब्याह लाया जिसका नाम तमर था। ");
INSERT INTO urd_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","और यहूदाह का पहलौठा बेटा 'एर ख़ुदावन्द की निगाह में शरीर था, इसलिए ख़ुदावन्द ने उसे हलाक कर दिया। ");
INSERT INTO urd_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","तब यहूदाह ने ओनान से कहा किअपने भाई की बीवी के पास जा और देवर का हक़ अदा कर ताकि तेरे भाई के नाम से नसल चले। ");
INSERT INTO urd_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","और ओनान जानता था कि यह नसल मेरी न कहलाएगी, इसलिए यूँ हुआ कि जब वह अपने भाई की बीवी के पास जाता तो नुत्फ़े को ज़मीन पर गिरा देता था कि मबादा उसके भाई के नाम से नसल चले। ");
INSERT INTO urd_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","और उसका यह काम ख़ुदावन्द की नज़र में बहुत बुरा था, इसलिए उसने उसे भी हलाक किया। ");
INSERT INTO urd_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","तब यहूदाह ने अपनी बहू तमर से कहा कि मेरे बेटे सीला के बालिग़ होने तक तू अपने बाप के घर बेवा बैठी रह। क्यूँकि उसने सोचा कि कहीं यह भी अपने भाइयों की तरह हलाक न हो जाए। तब तमर अपने बाप के घर में जाकर रहने लगी। ");
INSERT INTO urd_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","और एक 'अरसे के बाद ऐसा हुआ कि सुवा' की बेटी जो यहूदाह की बीवी थी मर गई, और जब यहूदाह को उसका ग़म भूला तो वह अपने 'अदूल्लामी दोस्त हीरा के साथ अपनी भेड़ो की ऊन के कतरने वालों के पास तिमनत को गया। ");
INSERT INTO urd_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","और तमर की यह ख़बर मिली कि तेरा ख़ुसर अपनी भेड़ो की ऊन कतरने के लिए तिमनत को जा रहा है। ");
INSERT INTO urd_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","तब उसने अपने रंडापे के कपड़ों को उतार फेंका और बुर्का ओढ़ा और अपने को ढांका और 'ऐनीम के फाटक के बराबर जो तिमनत की राह पर है, जा बैठी क्यूँकि उसने देखा कि सीला बालिग़ हो गया मगर यह उससे ब्याही नहीं गई। ");
INSERT INTO urd_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","यहूदाह उसे देख कर समझा कि कोई कस्बी है, क्यूँकि उसने अपना मुँह ढाँक रख्खा था। ");
INSERT INTO urd_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","इसलिए वह रास्ते से उसकी तरफ़ को फिरा और उससे कहने लगा कि जरा मुझे अपने साथ मुबासरत कर लेने दे, क्यूँकि इसे बिल्कुल नहीं मा'लूम था कि वह इसकी बहू है। उसने कहा, तू मुझे क्या देगा ताकि मेरे साथ मुबाश्रत करे। ");
INSERT INTO urd_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","उसने कहा, “मैं रेवड़ में से बकरी का एक बच्चा तुझे भेज दूँगा।” उसने कहा कि उसके भेजने तक तू मेरे पास कुछ रहन कर देगा। ");
INSERT INTO urd_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","उसने कहा, “तुझे रहन क्या दूँ?” उसने कहा, “अपनी मुहर और अपना बाजू बंद और अपनी लाठी जो तेरे हाथ में है।” उसने यह चीजें उसे दीं और उसके साथ मुबाश्रत की, और वह उससे हामिला हो गई। ");
INSERT INTO urd_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","फिर वह उठ कर चली गई और बुरका उतार कर रंडापे का जोड़ा पहन लिया। ");
INSERT INTO urd_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","और यहूदाह ने अपने 'अदूल्लामी दोस्त के हाथ बकरी का बच्चा भेजा ताकि उस 'औरत के पास से अपना रहन वापिस मंगाए, लेकिन वह 'औरत उसे न मिली। ");
INSERT INTO urd_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","तब उसने उस जगह के लोगों से पूछा, “वह कस्बी जो ऐनीम में रास्ते के बराबर बैठी थी कहाँ है?” उन्होंने कहा, यहाँ कोई कस्बी नहीं थी। ");
INSERT INTO urd_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","तब उसने यहूदाह के पास लौट कर उसे बताया कि वह मुझे नहीं मिली; और वहाँ के लोग भी कहते थे कि वहाँ कोई कस्बी नहीं थी। ");
INSERT INTO urd_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","यहूदाह ने कहा, “ख़ैर! उस रहन को वही रख्खे, हम तो बदनाम न हों; मैंने तो बकरी का बच्चा भेजा लेकिन वह तुझे नहीं मिली।” ");
INSERT INTO urd_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","और करीबन तीन महीने के बाद यहूदाह को यह ख़बर मिली कि तेरी बहू तमर ने ज़िना किया और उसे छिनाले का हम्ल भी है। यहूदाह ने कहा कि उसे बाहर निकाल लाओ कि वह जलाई जाए। ");
INSERT INTO urd_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","जब उसे बाहर निकाला तो उसने अपने खुसर को कहला भेजा कि मेरे उसी शख़्स का हम्ल है जिसकी यह चीजें हैं। इसलिए तू पहचान तो सही कि यह मुहर और बाजूबन्द और लाठी किसकी है। ");
INSERT INTO urd_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","तब यहूदाह ने इक़रार किया और कहा, “वह मुझ से ज़्यादा सच्ची है, क्यूँकि मैंने उसे अपने बेटे सीला से नहीं ब्याहा।” और वह फिर कभी उसके पास न गया। ");
INSERT INTO urd_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","और उसके वज़ा — ए — हम्ल के वक़्त मा'लूम हुआ कि उसके पेट में तौअम हैं। ");
INSERT INTO urd_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","और जब वह जनने लगी तो एक बच्चे का हाथ बाहर आया और दाई ने पकड़ कर उसके हाथ में लाल डोरा बाँध दिया, और कहने लगी, “यह पहले पैदा हुआ।” ");
INSERT INTO urd_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","और यूँ हुआ कि उसने अपना हाथ फिर खींच लिया, इतने में उसका भाई पैदा हो गया। तब वह दाई बोल उठी कि तू कैसे ज़बरदस्ती निकल पड़ा तब उसका नाम फ़ारस रख्खा गया। ");
INSERT INTO urd_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","फिर उसका भाई जिसके हाथ में लाल डोरा बंधा था, पैदा हुआ और उसका नाम ज़ारह रख्खा गया। ");
INSERT INTO urd_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","और यूसुफ़ को मिस्र में लाए, और फूतीफ़ार मिस्री ने जो फ़िर'औन का एक हाकिम और जिलौदारों का सरदार था, उसकी इस्माईलियों के हाथ से जो उसे वहाँ ले गए थे ख़रीद लिया। ");
INSERT INTO urd_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","और ख़ुदावन्द यूसुफ़ के साथ था और वह इक़बालमन्द हुआ, और अपने मिस्री आक़ा के घर में रहता था। ");
INSERT INTO urd_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","और उसके आक़ा ने देखा कि ख़ुदावन्द उसके साथ है और जिस काम को वह हाथ लगाता है ख़ुदावन्द उसमें उसे इकबालमंद करता है। ");
INSERT INTO urd_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","चुनाँचे यूसुफ़ उसकी नज़र में मक़्बूल ठहरा और वही उसकी ख़िदमत करता था; और उसने उसे अपने घर का मुख़्तार बना कर अपना सब कुछ उसे सौंप दिया। ");
INSERT INTO urd_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","और जब उसने उसे घर का और सारे माल का मुख़्तार बनाया, तो ख़ुदावन्द ने उस मिस्री के घर में यूसुफ़ की ख़ातिर बरकत बख़्शी; और उसकी सब चीज़ों पर जो घर में और खेत में थीं, ख़ुदावन्द की बरकत होने लगी। ");
INSERT INTO urd_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","और उसने अपना सब कुछ यूसुफ़ के हाथ में छोड़ दिया, और सिवा रोटी के जिसे वह खा लेता था, उसे अपनी किसी चीज़ का होश न था। और यूसुफ़ ख़ूबसूरत और हसीन था। ");
INSERT INTO urd_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","इन बातों के बाद यूँ हुआ कि उसके आक़ा की बीवी की आँख यूसुफ़ पर लगी और उसने उससे कहा कि मेरे साथ हमबिस्तर हो। ");
INSERT INTO urd_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","लेकिन उसने इन्कार किया; और अपने आक़ा की बीवी से कहा कि देख, मेरे आक़ा को ख़बर भी नहीं कि इस घर में मेरे पास क्या — क्या है, और उसने अपना सब कुछ मेरे हाथ में छोड़ दिया है। ");
INSERT INTO urd_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","इस घर में मुझ से बड़ा कोई नहीं; और उसने तेरे अलावा कोई चीज़ मुझ से बाज़ नहीं रख्खी, क्यूँकि तू उसकी बीवी है। इसलिए भला मैं क्यूँ ऐसी बड़ी बुराई करूँ और ख़ुदा का गुनहगार बनूँ? ");
INSERT INTO urd_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","और वह हर दिन यूसुफ़ को मजबूर करती रही, लेकिन उसने उसकी बात न मानी कि उससे हमबिस्तर होने के लिए उसके साथ लेटे। ");
INSERT INTO urd_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","और एक दिन ऐसा हुआ कि वह अपना काम करने के लिए घर में गया, और घर के आदमियों में से कोई भी अन्दर न था। ");
INSERT INTO urd_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","तब उस 'औरत ने उसका लिबास पकड़ कर कहा, मेरे साथ हम बिस्तर हो, वह अपना लिबास उसके हाथ में छोड़ कर भागा और बाहर निकल गया। ");
INSERT INTO urd_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","जब उसने देखा कि वह अपना लिबास उसके हाथ में छोड़ कर भाग गया, ");
INSERT INTO urd_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","तो उसने अपने घर के आदमियों को बुला कर उनसे कहा, “देखो, वह एक 'इब्री को हम से मज़ाक करने के लिए हमारे पास ले आया है। यह मुझ से हम बिस्तर होने को अन्दर घुस आया, और मैं बुलन्द आवाज़ से चिल्लाने लगी। ");
INSERT INTO urd_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","जब उसने देखा कि मैं ज़ोर — ज़ोर से चिल्ला रही हूँ, तो अपना लिबास मेरे पास छोड़ कर भागा और बाहर निकल गया।” ");
INSERT INTO urd_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","और वह उसका लिबास उसके आक़ा के घर लौटने तक अपने पास रख्खे रही। ");
INSERT INTO urd_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","तब उसने यह बातें उससे कहीं, “यह इब्री गुलाम, जो तू लाया है मेरे पास अन्दर घुस आया कि मुझ से मज़ाक़ करे। ");
INSERT INTO urd_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","जब मैं ज़ोर — ज़ोर से चिल्लाने लगी तो वह अपना लिबास मेरे ही पास छोड़ कर बाहर भाग गया।” ");
INSERT INTO urd_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","जब उसके आक़ा ने अपनी बीवी की वह बातें जो उसने उससे कहीं, सुन लीं, कि तेरे ग़ुलाम ने मुझ से ऐसा ऐसा किया तो उसका ग़ज़ब भड़का। ");
INSERT INTO urd_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","और यूसुफ़ के आक़ा ने उसको लेकर क़ैद खाने में जहाँ बादशाह के क़ैदी बन्द थे डाल दिया, तब वह वहाँ क़ैद खाने में रहा। ");
INSERT INTO urd_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","लेकिन ख़ुदावन्द यूसुफ़ के साथ था; उसने उस पर रहम किया और क़ैद खाने के दारोग़ा की नज़र में उसे मक़्बूल बनाया। ");
INSERT INTO urd_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","और क़ैद खाने के दारोग़ा ने सब क़ैदियों को जो क़ैद में थे, यूसुफ़ के हाथ में सौंपा; और जो कुछ वह करते उसी के हुक्म से करते थे। ");
INSERT INTO urd_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","और क़ैद खाने का दारोग़ा सब कामों की तरफ़ से, जो उसके हाथ में थे बेफ़िक्र था, इसलिए कि ख़ुदावन्द उसके साथ था; और जो कुछ वह करता ख़ुदावन्द उसमें इक़बाल मन्दी बख़्शता था। ");
INSERT INTO urd_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","इन बातों के बाद यूँ हुआ कि शाह ए — मिस्र का साकी और नानपज़ अपने ख़ुदावन्द शाह — ए — मिस्र के मुजरिम हुए। ");
INSERT INTO urd_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","और फ़िर'औन अपने इन दोनों हाकिमों से जिनमें एक साकियों और दूसरा नानपज़ों का सरदार था, नाराज़ हो गया। ");
INSERT INTO urd_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","और उसने इनको जिलौदारों के सरदार के घर में उसी जगह जहाँ यूसुफ़ हिरासत में था, क़ैद खाने में नज़रबन्द करा दिया। ");
INSERT INTO urd_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","जिलौदारों के सरदार ने उनको यूसुफ़ के हवाले किया, और वह उनकी ख़िदमत करने लगा और वह एक मुद्दत तक नज़रबन्द रहे। ");
INSERT INTO urd_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","और शाह — ए — मिस्र के साकी और नानपज़ दोनों ने, जो क़ैद खाने में नज़रबन्द थे एक ही रात में अपने — अपने होनहार के मुताबिक़ एक — एक ख़्वाब देखा। ");
INSERT INTO urd_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","और यूसुफ़ सुबह को उनके पास अन्दर आया और देखा कि वह उदास हैं। ");
INSERT INTO urd_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","और उसने फ़िर'औन के हाकिमों से जो उसके साथ उसके आक़ा के घर में नज़रबन्द थे, पूछा कि आज तुम क्यूँ ऐसे उदास नज़र आते हो? ");
INSERT INTO urd_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","उन्होंने उससे कहा, “हम ने एक ख़्वाब देखा है, जिसकी ता'बीर करने वाला कोई नहीं।” यूसुफ़ ने उनसे कहा, “क्या ता'बीर की कुदरत ख़ुदा को नहीं? मुझे ज़रा वह ख़्वाब बताओ।” ");
INSERT INTO urd_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","तब सरदार साकी ने अपना ख़्वाब यूसुफ़ से बयान किया। उसने कहा, “मैंने ख़्वाब में देखा कि अंगूर की बेल मेरे सामने है। ");
INSERT INTO urd_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","और उस बेल में तीन शाखें हैं, और ऐसा दिखाई दिया कि उसमें कलियाँ लगीं और फूल आए और उसके सब गुच्छों में पक्के — पक्के अंगूर लगे। ");
INSERT INTO urd_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","और फ़िर'औन का प्याला मेरे हाथ में है, और मैंने उन अंगूरों को लेकर फ़िर'औन के प्याले में निचोड़ा और वह प्याला मैंने फ़िर'औन के हाथ में दिया।” ");
INSERT INTO urd_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","यूसुफ़ ने उससे कहा, “इसकी ता'बीर यह है कि वह तीन शाखें तीन दिन हैं। ");
INSERT INTO urd_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","इसलिए अब से तीन दिन के अन्दर फ़िर'औन तुझे सरफ़राज़ फ़रमाएगा, और तुझे फिर तेरे 'ओहदे पर बहाल कर देगा; और पहले की तरह जब तू उसका साकी था, प्याला फ़िर'औन के हाथ में दिया करेगा। ");
INSERT INTO urd_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","लेकिन जब तू ख़ुशहाल हो जाए तो मुझे याद करना और ज़रा मुझ से मेहरबानी से पेश आना, और फ़िर'औन से मेरा ज़िक्र करना और मुझे इस घर से छुटकारा दिलवाना। ");
INSERT INTO urd_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","क्यूँकि इब्रानियों के मुल्क से मुझे चुरा कर ले आए हैं, और यहाँ भी मैंने ऐसा कोई काम नहीं किया जिसकी वजह से क़ैद खाने में डाला जाऊँ।” ");
INSERT INTO urd_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","जब सरदार नानपज़ ने देखा कि ता'बीर अच्छी निकली तो यूसुफ़ से कहा, “मैंने भी ख़्वाब में देखा, कि मेरे सिर पर सफ़ेद रोटी की तीन टोकरियाँ हैं; ");
INSERT INTO urd_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","और ऊपर की टोकरी में हर क़िस्म का पका हुआ खाना फ़िर'औन के लिए है, और परिन्दे मेरे सिर पर की टोकरी में से खा रहे हैं।” ");
INSERT INTO urd_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","यूसुफ़ ने उसे कहा, “इसकी ता'बीर यह है कि वह तीन टोकरियाँ तीन दिन हैं। ");
INSERT INTO urd_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","इसलिए अब से तीन दिन के अन्दर फ़िर'औन तेरा सिर तेरे तन से जुदा करा के तुझे एक दरख़्त पर टंगवा देगा, और परिन्दे तेरा गोश्त नोंच — नोंच कर खाएँगे।” ");
INSERT INTO urd_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","और तीसरे दिन जो फ़िर'औन की सालगिरह का दिन था, यूँ हुआ कि उसने अपने सब नौकरों की दावत की और उसने सरदार साकी और सरदार नानपज़ को अपने नौकरों के साथ याद फ़रमाया। ");
INSERT INTO urd_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","और उसने सरदार साकी को फिर उसकी ख़िदमत पर बहाल किया, और वह फ़िर'औन के हाथ में प्याला देने लगा। ");
INSERT INTO urd_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","लेकिन उसने सरदार नानपज़ को फाँसी दिलवाई, जैसा यूसुफ़ ने ता'बीर करके उनको बताया था। ");
INSERT INTO urd_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","लेकिन सरदार साकी ने यूसुफ़ को याद न किया बल्कि उसे भूल गया। ");
INSERT INTO urd_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","पूरे दो साल के बाद फ़िर'औन ने ख़्वाब में देखा कि वह दरिया-ए-नील के किनारे खड़ा है; ");
INSERT INTO urd_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","और उस दरिया में से सात ख़ूबसूरत और मोटी — मोटी गायें निकल कर सरकंडों के खेत में चरने लगीं। ");
INSERT INTO urd_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","उनके बाद और सात बदशक्ल और दुबली — दुबली गायें दरिया से निकलीं और दूसरी गायों के बराबर दरिया के किनारे जा खड़ी हुई। ");
INSERT INTO urd_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","और यह बदशक्ल और दुबली दुबली गायें उन सातों ख़ूबसूरत और मोटी मोटी गायों को खा गई, तब फ़िर'औन जाग उठा। ");
INSERT INTO urd_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","और वह फिर सो गया और उसने दूसरा ख़्वाब देखा कि एक टहनी में अनाज की सात मोटी और अच्छी — अच्छी बालें निकलीं। ");
INSERT INTO urd_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","उनके बाद और सात पतली और पूरबी हवा की मारी मुरझाई हुई बालें निकलीं। ");
INSERT INTO urd_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","यह पतली बालें उन सातों मोटी और भरी हुई बालों को निगल गई। और फ़िर'औन जाग गया और उसे मा'लूम हुआ कि यह ख़्वाब था। ");
INSERT INTO urd_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","और सुबह को यूँ हुआ कि उसका जी घबराया तब उसने मिस्र के सब जादूगरों और सब अक्लमन्दों को बुलवा भेजा, और अपना ख़्वाब उनको बताया। लेकिन उनमें से कोई फ़िर'औन के आगे उनकी ता'बीर न कर सका। ");
INSERT INTO urd_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","उस वक़्त सरदार साक़ी ने फ़िर'औन से कहा, मेरी ख़ताएँ आज मुझे याद आईं। ");
INSERT INTO urd_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","जब फ़िर'औन अपने ख़ादिमों से नाराज़ था और उसने मुझे और सरदार नानपज़ को जिलौदारों के सरदार के घर में नज़रबन्द करवा दिया। ");
INSERT INTO urd_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","तो मैंने और उसने एक ही रात में एक — एक ख़्वाब देखा, यह ख्वाब हम ने अपने अपने होनहार के मुताबिक़ देखे। ");
INSERT INTO urd_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","वहाँ एक 'इब्री जवान, जिलौदारों के सरदार का नौकर, हमारे साथ था। हम ने उसे अपने ख़्वाब बताए और उसने उनकी ता'बीर की, और हम में से हर एक को हमारे ख़्वाब के मुताबिक़ उसने ता'बीर बताई। ");
INSERT INTO urd_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","और जो ता'बीर उसने बताई थी वैसा ही हुआ, क्यूँकि मुझे तो उसने मेरे मन्सब पर बहाल किया था और उसे फाँसी दी थी। ");
INSERT INTO urd_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","तब फ़िर'औन ने यूसुफ़ को बुलवा भेजा: तब उन्होंने जल्द उसे क़ैद खाने से बाहर निकाला, और उसने हजामत बनवाई और कपड़े बदल कर फ़िर'औन के सामने आया। ");
INSERT INTO urd_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","फ़िर'औन ने यूसुफ़ से कहा, “मैंने एक ख़्वाब देखा है जिसकी ता'बीर कोई नहीं कर सकता, और मुझ से तेरे बारे में कहते हैं कि तू ख़्वाब को सुन कर उसकी ता'बीर करता है।” ");
INSERT INTO urd_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","यूसुफ़ ने फ़िर'औन को जवाब दिया, “मैं कुछ नहीं जानता, ख़ुदा ही फ़िर'औन को सलामती बख़्श जवाब देगा।” ");
INSERT INTO urd_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","तब फ़िर'औन ने यूसुफ़ से कहा, मैंने ख़्वाब में देखा कि मैं दरिया-ए-नील के किनारे खड़ा हूँ। ");
INSERT INTO urd_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","और उस दरिया में से सात मोटी और ख़ूबसूरत गायें निकल कर सरकंडों के खेत में चरने लगीं। ");
INSERT INTO urd_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","उनके बाद और सात ख़राब और निहायत बदशक्ल और दुबली गायें निकलीं, और वह इस क़दर बुरी थीं कि मैंने सारे मुल्क — ए — मिस्र में ऐसी कभी नहीं देखीं। ");
INSERT INTO urd_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","और वह दुबली और बदशक्ल गायें उन पहली सातों मोटी गायों को खा गई; ");
INSERT INTO urd_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","और उनके खा जाने के बाद यह मा'लूम भी नहीं होता था कि उन्होंने उनको खा लिया है, बल्कि वह पहले की तरह जैसी की तैसी बदशक्ल रहीं। तब मैं जाग गया। ");
INSERT INTO urd_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","और फिर ख़्वाब में देखा कि एक टहनी में सात भरी और अच्छी — अच्छी बालें निकलीं। ");
INSERT INTO urd_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","और उनके बाद और सात सूखी और पतली और पूरबी हवा की मारी मुरझाई हुई बालें निकलीं। ");
INSERT INTO urd_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","और यह पतली बाले उन सातों अच्छी — अच्छी बालों को निगल गई। और मैंने इन जादूगरों से इसका बयान किया लेकिन ऐसा कोई न निकला जो मुझे इसका मतलब बताता। ");
INSERT INTO urd_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","तब यूसुफ़ ने फ़िर'औन से कहा कि फ़िर'औन का ख़्वाब एक ही है, जो कुछ ख़ुदा करने को है उसे उसने फ़िर'औन पर ज़ाहिर किया है। ");
INSERT INTO urd_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","वह सात अच्छी — अच्छी गायें सात साल हैं, और वह सात अच्छी अच्छी बालें भी सात साल हैं; ख़्वाब एक ही है। ");
INSERT INTO urd_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","और वह सात बदशक्ल और दुबली गायें जो उनके बाद निकलीं, और वह सात ख़ाली और पूरबी हवा की मारी मुरझाई हुई बालें भी सात साल ही हैं; मगर काल के सात बरस। ");
INSERT INTO urd_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","यह वही बात है जो मैं फ़िर'औन से कह चुका हूँ कि जो कुछ ख़ुदा करने को है उसे उसने फ़िर'औन पर ज़ाहिर किया है। ");
INSERT INTO urd_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","देख! सारे मुल्क — ए — मिस्र में सात साल तो पैदावार ज़्यादा के होंगे। ");
INSERT INTO urd_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","उनके बाद सात साल काल के आएँगे और तमाम मुल्क ए — मिस्र में लोग इस सारी पैदावार को भूल जाएँगे और यह काल मुल्क को तबाह कर देगा। ");
INSERT INTO urd_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","और अज़ानी मुल्क में याद भी नहीं रहेगी, क्यूँकि जो काल बाद में पड़ेगा वह निहायत ही सख़्त होगा। ");
INSERT INTO urd_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","और फ़िर'औन ने जो यह ख़्वाब दो दफ़ा' देखा तो इसकी वजह यह है कि यह बात ख़ुदा की तरफ़ से मुक़र्रर हो चुकी है, और ख़ुदा इसे जल्द पूरा करेगा। ");
INSERT INTO urd_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","इसलिए फ़िर'औन को चाहिए कि एक समझदार और 'अक़्लमन्द आदमी को तलाश कर ले और उसे मुल्क — ए — मिस्र पर मुख़्तार बनाए। ");
INSERT INTO urd_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","फ़िर'औन यह करे ताकि उस आदमी को इख़्तियार हो कि वह मुल्क में नाज़िरों को मुक़र्रर कर दे, और अज़ानी के सात बरसों में सारे मुल्क — ए — मिस्र की पैदावार का पाँचवा हिस्सा ले ले। ");
INSERT INTO urd_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","और वह उन अच्छे बरसों में जो आते हैं सब खाने की चीजें जमा' करें और शहर — शहर में गल्ला जो फ़िर'औन के इख़्तियार में हो, ख़ुराक के लिए फ़राहम करके उसकी हिफ़ाज़त करें। ");
INSERT INTO urd_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","यही ग़ल्ला मुल्क के लिए ज़ख़ीरा होगा, और सातों साल के लिए जब तक मुल्क में काल रहेगा काफ़ी होगा, ताकि काल की वजह से मुल्क बर्बाद न हो जाए। ");
INSERT INTO urd_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","य बात फ़िर'औन और उसके सब ख़ादिमों को पसंद आई। ");
INSERT INTO urd_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","तब फ़िर'औन ने अपने ख़ादिमों से कहा कि क्या हम को ऐसा आदमी जैसा यह है, जिसमें ख़ुदा का रूह है मिल सकता है? ");
INSERT INTO urd_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","और फ़िर'औन ने यूसुफ़ से कहा, चूँकि ख़ुदा ने तुझे यह सब कुछ समझा दिया है, इसलिए तेरी तरह समझदार और अक़्लमन्द कोई नहीं। ");
INSERT INTO urd_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","इसलिए तू मेरे घर का मुख़्तार होगा और मेरी सारी रि'आया तेरे हुक्म पर चलेगी, सिर्फ़ तख़्त का मालिक होने की वजह से मैं बुज़ुर्गतर हूँगा। ");
INSERT INTO urd_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","और फ़िर'औन ने यूसुफ़ से कहा कि देख, मैं तुझे सारे मुल्क — ए — मिस्र का हाकिम बनाता हूँ ");
INSERT INTO urd_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","और फ़िर'औन ने अपनी अंगूठी अपने हाथ से निकाल कर यूसुफ़ के हाथ में पहना दी, और उसे बारीक कतान के लिबास में आरास्ता करवा कर सोने का हार उसके गले में पहनाया। ");
INSERT INTO urd_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","और उसने उसे अपने दूसरे रथ में सवार करा कर उसके आगे — आगे यह 'ऐलान करवा दिया, कि घुटने टेको और उसने उसे सारे मुल्क — ए — मिस्र का हाकिम बना दिया। ");
INSERT INTO urd_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","और फ़िर'औन ने यूसुफ़ से कहा, “मैं फ़िर'औन हूँ और तेरे हुक्म के बग़ैर कोई आदमी इस सारे मुल्क — ए — मिस्र में अपना हाथ या पाँव हिलाने न पाएगा।” ");
INSERT INTO urd_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","और फ़िर'औन ने यूसुफ़ का नाम सिफ़्नात फ़ा'नेह रख्खा, और उसने ओन के पुजारी फ़ोतीफ़िरा' की बेटी आसिनाथ को उससे ब्याह दिया, और यूसुफ़ मुल्क — ए — मिस्र में दौरा करने लगा। ");
INSERT INTO urd_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","और यूसुफ़ तीस साल का था जब वह मिस्र के बादशाह फ़िर'औन के सामने गया, और उसने फ़िर'औन के पास से रुख़्सत हो कर सारे मुल्क — ए — मिस्र का दौरा किया। ");
INSERT INTO urd_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","और अज़ानी के सात बरसों में इफ़्रात से फ़स्ल हुई। ");
INSERT INTO urd_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","और वह लगातार सातों साल हर क़िस्म की ख़ुराक, जो मुल्क — ए — मिस्र में पैदा होती थी, जमा' कर करके शहरों में उसका ज़ख़ीरा करता गया। हर शहर की चारों तरफ़ो की ख़ुराक वह उसी शहर में रखता गया। ");
INSERT INTO urd_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","और यूसुफ़ ने ग़ल्ला समुन्दर की रेत की तरह निहायत कसरत से ज़ख़ीरा किया, यहाँ तक कि हिसाब रखना भी छोड़ दिया क्यूँ कि वह बे — हिसाब था। ");
INSERT INTO urd_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","और काल से पहले ओन के पुजारी फ़ोतीफ़िरा' की बेटी आसिनाथ के यूसुफ़ से दो बेटे पैदा हुए। ");
INSERT INTO urd_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","और यूसुफ़ ने पहलौठे का नाम मनस्सी यह कह कर रख्खा, कि 'ख़ुदा ने मेरी और मेरे बाप के घर की सब मुसीबत मुझ से भुला दी। ");
INSERT INTO urd_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","और दूसरे का नाम इफ़्राईम यह कह कर रख्खा, कि 'ख़ुदा ने मुझे मेरी मुसीबत के मुल्क में फलदार किया। ");
INSERT INTO urd_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","और अज़ानी के वह सात साल जो मुल्क — ए — मिस्र में हुए तमाम हो गए, और यूसुफ़ के कहने के मुताबिक़ काल के सात साल शुरू' हुए। ");
INSERT INTO urd_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","और सब मुल्कों में तो काल था लेकिन मुल्क — ए — मिस्र में हर जगह खुराक मौजूद थी। ");
INSERT INTO urd_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","और जब मुल्क — ए — मिस्र में लोग भूकों मरने लगे तो रोटी के लिए फ़िर'औन के आगे चिल्लाए। फ़िर'औन ने मिस्रियों से कहा कि यूसुफ़ के पास जाओ, जो कुछ वह तुम से कहे वह करो। ");
INSERT INTO urd_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","और तमाम रू — ए — ज़मीन पर काल था; और यूसुफ़ अनाज के ज़खीरह को खुलवा कर मिस्रियों के हाथ बेचने लगा, और मुल्क — ए — मिस्र में सख़्त काल हो गया। ");
INSERT INTO urd_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","और सब मुल्कों के लोग अनाज मोल लेने के लिए यूसुफ़ के पास मिस्र में आने लगे, क्यूँकि सारी ज़मीन पर सख़्त काल पड़ा था। ");
INSERT INTO urd_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","और या'क़ूब को मा'लूम हुआ कि मिस्र में ग़ल्ला है, तब उसने अपने बेटों से कहा कि तुम क्यूँ एक दूसरे का मुँह ताकते हो? ");
INSERT INTO urd_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","देखो, मैंने सुना है कि मिस्र में ग़ल्ला है। तुम वहाँ जाओ और वहाँ से हमारे लिए अनाज मोल ले आओ, ताकि हम ज़िन्दा रहें और हलाक न हों। ");
INSERT INTO urd_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","तब यूसुफ़ के दस भाई ग़ल्ला मोल लेने को मिस्र में आए। ");
INSERT INTO urd_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","लेकिन या'क़ूब ने यूसुफ़ के भाई बिनयमीन को उसके भाइयों के साथ न भेजा, क्यूँकि उसने कहा, कि कहीं उस पर कोई आफ़त न आ जाए। ");
INSERT INTO urd_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","इसलिए जो लोग ग़ल्ला खरीदने आए उनके साथ इस्राईल के बेटे भी आए, क्यूँकि कनान के मुल्क में काल था। ");
INSERT INTO urd_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","और यूसुफ़ मुल्क — ए — मिस्र का हाकिम था और वही मुल्क के सब लोगों के हाथ ग़ल्ला बेचता था। तब यूसुफ़ के भाई आए और अपने सिर ज़मीन पर टेक कर उसके सामने आदाब बजा लाए। ");
INSERT INTO urd_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","यूसुफ़ अपने भाइयों को देख कर उनको पहचान गया; लेकिन उसने उनके सामने अपने आप को अन्जान बना लिया और उनसे सख़्त लहजे में पूछा, “तुम कहाँ से आए हो?” उन्होंने कहा, “कना'न के मुल्क से अनाज मोल लेने को।” ");
INSERT INTO urd_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","यूसुफ़ ने तो अपने भाइयों को पहचान लिया था लेकिन उन्होंने उसे न पहचाना। ");
INSERT INTO urd_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","और यूसुफ़ उन ख़्वाबों को जो उसने उनके बारे में देखे थे याद करके उनसे कहने लगा कि तुम जासूस हो। तुम आए हो कि इस मुल्क की बुरी हालत दरियाफ़्त करो। ");
INSERT INTO urd_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","उन्होंने उससे कहा, “नहीं ख़ुदावन्द! तेरे ग़ुलाम अनाज मोल लेने आए हैं। ");
INSERT INTO urd_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","हम सब एक ही शख़्स के बेटे हैं। हम सच्चे हैं; तेरे ग़ुलाम जासूस नहीं हैं।” ");
INSERT INTO urd_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","उसने कहा, “नहीं; बल्कि तुम इस मुल्क की बुरी हालत दरियाफ़्त करने को आए हो।” ");
INSERT INTO urd_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","तब उन्होंने कहा, “तेरे ग़ुलाम बारह भाई एक ही शख़्स के बेटे हैं जो मुल्क — ए — कना'न में है। सबसे छोटा इस वक़्त हमारे बाप के पास है और एक का कुछ पता नहीं।” ");
INSERT INTO urd_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","तब यूसुफ़ ने उनसे कहा, “मैं तो तुम से कह चुका कि तुम जासूस हो। ");
INSERT INTO urd_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","इसलिए तुम्हारी आज़माइश इस तरह की जाएगी कि फ़िर'औन की हयात की क़सम, तुम यहाँ से जाने न पाओगे; जब तक तुम्हारा सबसे छोटा भाई यहाँ न आ जाए। ");
INSERT INTO urd_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","इसलिए अपने में से किसी एक को भेजो कि वह तुम्हारे भाई को ले आए और तुम क़ैद रहो, ताकि तुम्हारी बातों की तसदीक़ हो कि तुम सच्चे हो या नहीं; वरना फ़िर'औन की हयात की क़सम तुम ज़रूर ही जासूस हो।” ");
INSERT INTO urd_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","और उसने उन सब को तीन दिन तक इकट्ठे नज़रबन्द रख्खा। ");
INSERT INTO urd_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","और तीसरे दिन यूसुफ़ ने उनसे कहा, “एक काम करो तो ज़िन्दा रहोगे; क्यूँकि मुझे ख़ुदा का ख़ौफ़ है। ");
INSERT INTO urd_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","अगर तुम सच्चे हो तो अपने भाइयों में से एक को क़ैद खाने में बन्द रहने दो, और तुम अपने घरवालों के खाने के लिए अनाज ले जाओ। ");
INSERT INTO urd_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","और अपने सबसे छोटे भाई को मेरे पास ले आओ, यूँ तुम्हारी बातों की तस्दीक़ हो जाएगी और तुम हलाक न होगे।” इसलिए उन्होंने ऐसा ही किया। ");
INSERT INTO urd_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","और वह आपस में कहने लगे, “हम दरअसल अपने भाई की वजह से मुजरिम ठहरे हैं; क्यूँकि जब उसने हम से मिन्नत की तो हम ने यह देखकर भी, कि उसकी जान कैसी मुसीबत में है उसकी न सुनी; इसी लिए यह मुसीबत हम पर आ पड़ी है।” ");
INSERT INTO urd_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","तब रूबिन बोल उठा, “क्या मैंने तुम से न कहा था कि इस बच्चे पर ज़ुल्म न करो, और तुम ने न सुना; इसलिए देख लो, अब उसके ख़ून का बदला लिया जाता है।” ");
INSERT INTO urd_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","और उनको मा'लूम न था कि यूसुफ़ उनकी बातें समझता है, इसलिए कि उनके बीच एक तरजुमान था। ");
INSERT INTO urd_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","तब वह उनके पास से हट गया और रोया, और फिर उनके पास आकर उनसे बातें कीं और उनमें से शमौन को लेकर उनकी आँखों के सामने उसे बन्धवा दिया। ");
INSERT INTO urd_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","फिर यूसुफ़ ने हुक्म किया, कि उनके बोरों में अनाज भरें और हर शख़्स की नकदी उसी के बोरे में रख दें, और उनको सफ़र का सामान भी दे दें। चुनांचे उनके लिए ऐसा ही किया गया। ");
INSERT INTO urd_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","और उन्होंने अपने गधों पर ग़ल्ला लाद लिया और वहाँ से रवाना हुए। ");
INSERT INTO urd_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","जब उनमें से एक ने मन्जिल पर अपने गधे को चारा देने के लिए अपना बोरा खोला, तो अपनी नक़दी बोरे के मुँह में रख्खी देखी। ");
INSERT INTO urd_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","तब उसने अपने भाइयों से कहा कि मेरी नक़दी वापस कर दी गई है, वह मेरे बोरे में है, देख लो!' फिर तो वह घबरा गए और हक्का — बक्का होकर एक दूसरे को देखने और कहने लगे, ख़ुदा ने हम से यह क्या किया? ");
INSERT INTO urd_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","और वह मुल्क — ए — कना'न में अपने बाप या'क़ूब के पास आए, और सारी वारदात उसे बताई और कहने लगे कि ");
INSERT INTO urd_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","उस शख़्स ने जो उस मुल्क का मालिक है हम से सख़्त लहजे में बातें कीं, और हम को उस मुल्क के जासूस समझा। ");
INSERT INTO urd_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","हम ने उससे कहा कि हम सच्चे आदमी हैं; हम जासूस नहीं। ");
INSERT INTO urd_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","हम बारह भाई एक ही बाप के बेटे हैं; हम में से एक का कुछ पता नहीं और सबसे छोटा इस वक़्त हमारे बाप के पास मुल्क — ए — कना'न में है। ");
INSERT INTO urd_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","तब उस शख़्स ने जो मुल्क का मालिक है हम से कहा, 'मैं इसी से जान लूँगा कि तुम सच्चे हो कि अपने भाइयों में से किसी को मेरे पास छोड़ दो और अपने घरवालों के खाने के लिए अनाज लेकर चले जाओ। ");
INSERT INTO urd_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","और अपने सबसे छोटे भाई को मेरे पास ले आओ; तब मैं जान लूँगा कि तुम जासूस नहीं बल्कि सच्चे आदमी हो। और मैं तुम्हारे भाई को तुम्हारे हवाले कर दूँगा, फिर तुम मुल्क में सौदागरी करना'। ");
INSERT INTO urd_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","और यूँ हुआ कि जब उन्होंने अपने अपने बोरे खाली किए तो हर शख़्स की नक़दी की थैली उसी के बोरे में रख्खी देखी, और वह और उनका बाप नक़दी की थैलियाँ देख कर डर गए। ");
INSERT INTO urd_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","और उनके बाप या'क़ूब ने उनसे कहा, “तुम ने मुझे बेऔलाद कर दिया। यूसुफ़ नहीं रहा और शमौन भी नहीं है, और अब बिनयमीन को भी ले जाना चाहते ही। ये सब बातें मेरे ख़िलाफ़ हैं।” ");
INSERT INTO urd_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","तब रूबिन ने अपने बाप से कहा, “अगर मैं उसे तेरे पास न ले आऊँ तो तू मेरे दोनों बेटों को क़त्ल कर डालना। उसे मेरे हाथ में सौंप दे और मैं उसे फिर तेरे पास पहुँचा दूँगा।” ");
INSERT INTO urd_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","उसने कहा, मेरा बेटा तुम्हारे साथ नहीं जाएगा; क्यूँकि उसका भाई मर गया और वह अकेला रह गया है। अगर रास्ते में जाते — जाते उस पर कोई आफ़त आ पड़े तो तुम मेरे सफ़ेद बालों को ग़म के साथ क़ब्र में उतारोगे। ");
INSERT INTO urd_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","और काल मुल्क में और भी सख़्त हो गया। ");
INSERT INTO urd_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","और यूँ हुआ कि जब उस ग़ल्ले को जिसे मिस्र से लाए थे, खा चुके तो उनके बाप ने उनसे कहा कि जाकर हमारे लिए फिर कुछ अनाज मोल ले आओ। ");
INSERT INTO urd_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","तब यहूदाह ने उसे कहा कि उस शख़्स ने हम को निहायत ताकीद से कह दिया था कि तुम मेरा मुँह न देखोगे, जब तक तुम्हारा भाई तुम्हारे साथ न हो। ");
INSERT INTO urd_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","इसलिए अगर तू हमारे भाई को हमारे साथ भेज दे, तो हम जाएँगे और तेरे लिए अनाज मोल लाएँगे। ");
INSERT INTO urd_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","और अगर तू उसे न भेजे तो हम नहीं जाएँगे; क्यूँकि उस शख़्स ने कह दिया है कि तुम मेरा मुँह न देखोगे जब तक तुम्हारा भाई तुम्हारे साथ न हो'। ");
INSERT INTO urd_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","तब इस्राईल ने कहा कि तुम ने मुझ से क्यूँ यह बदसुलूकी की, कि उस शख़्स को बता दिया कि हमारा एक भाई और भी है? ");
INSERT INTO urd_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","उन्होंने कहा, “उस शख़्स ने बजिद्द हो कर हमारा और हमारे ख़ान्दान का हाल पूछा कि 'क्या तुम्हारा बाप अब तक ज़िन्दा है? और क्या तुम्हारा कोई और भाई है?' तो हम ने इन सवालों के मुताबिक़ उसे बता दिया। हम क्या जानते थे कि वह कहेगा, 'अपने भाई को ले आओ'।” ");
INSERT INTO urd_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","तब यहूदाह ने अपने बाप इस्राईल से कहा कि उस लड़के को मेरे साथ कर दे तो हम चले जाएँगे; ताकि हम और तू और हमारे बाल बच्चे ज़िन्दा रहें और हलाक न हों। ");
INSERT INTO urd_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","और मैं उसका ज़िम्मेदार होता हूँ, तू उसको मेरे हाथ से वापस माँगना। अगर मैं उसे तेरे पास पहुँचा कर सामने खड़ा न कर दूँ, तो मैं हमेशा के लिए गुनहगार ठहरूंगा। ");
INSERT INTO urd_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","अगर हम देर न लगाते तो अब तक दूसरी दफ़ा' लौट कर आ भी जाते। ");
INSERT INTO urd_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","तब उनके बाप इस्राईल ने उनसे कहा, “अगर यही बात है तो ऐसा करो कि अपने बर्तनों में इस मुल्क की मशहूर पैदावार में से कुछ उस शख़्स के लिए नज़राना लेते जाओ; जैसे थोड़ा सा रौग़ान — ए — बलसान, थोड़ा सा शहद, कुछ गर्म मसाले, और मुर्र और पिस्ता और बादाम, ");
INSERT INTO urd_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","और दूना दाम अपने हाथ में ले लो, और वह नक़दी जो फेर दी गई और तुम्हारे बोरों के मुँह में रख्खी मिली अपने साथ वापस ले जाओ; क्यूँकि शायद भूल हो गई होगी। ");
INSERT INTO urd_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","और अपने भाई को भी साथ लो, और उठ कर फिर उस शख़्स के पास जाओ। ");
INSERT INTO urd_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","और ख़ुदा — ए — क़ादिर उस शख़्स को तुम पर मेहरबानी करे, ताकि वह तुम्हारे दूसरे भाई को और बिनयमीन को तुम्हारे साथ भेज दे। मैं अगर बे — औलाद हुआ तो हुआ।” ");
INSERT INTO urd_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","तब उन्होंने नज़राना लिया और दूना दाम भी हाथ में ले लिया, और बिनयमीन को लेकर चल पड़े; और मिस्र पहुँच कर यूसुफ़ के सामने जा खड़े हुए। ");
INSERT INTO urd_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","जब यूसुफ़ ने बिनयमीन को उनके साथ देखा तो उसने अपने घर के मुन्तज़िम से कहा, “इन आदमियों को घर में ले जा, और कोई जानवर ज़बह करके खाना तैयार करवा; क्यूँकि यह आदमी दोपहर को मेरे साथ खाना खाएँगे।” ");
INSERT INTO urd_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","उस शख़्स ने जैसा यूसुफ़ ने फ़रमाया था किया, और इन आदमियों को यूसुफ़ के घर में ले गया। ");
INSERT INTO urd_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","जब इनको यूसुफ़ के घर में पहुँचा दिया तो डर के मारे कहने लगे, “वह नक़दी जो पहली दफ़ा' हमारे बोरों में रख कर वापस कर दी गई थी, उसी की वजह से हम को अन्दर करवा दिया है; ताकि उसे हमारे ख़िलाफ़ बहाना मिल जाए और वह हम पर हमला करके हम को ग़ुलाम बना ले और हमारे गधों को छीन ले।” ");
INSERT INTO urd_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","और वह यूसुफ़ के घर के मुन्तज़िम के पास गए और दरवाज़े पर खड़े होकर उससे कहने लगे, ");
INSERT INTO urd_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“जनाब, हम पहले भी यहाँ अनाज मोल लेने आए थे; ");
INSERT INTO urd_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","और यूँ हुआ कि जब हम ने मंज़िल पर उतर कर अपने बोरों को खोला, तो अपनी अपनी पूरी तौली हुई नक़दी अपने अपने बोरे के मुँह में रख्खी देखी, इसलिए हम उसे अपने साथ वापस लेते आए हैं। ");
INSERT INTO urd_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","और हम अनाज मोल लेने को और भी नक़दी साथ लाए हैं, ये हम नहीं जानते के हमारी नक़दी किसने हमारे बोरों में रख दी।” ");
INSERT INTO urd_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","उसने कहा कि तुम्हारी सलामती हो, मत डरो! तुम्हारे ख़ुदा और तुम्हारे बाप के ख़ुदा ने तुम्हारे बोरों में तुम को ख़ज़ाना दिया होगा, मुझे तो तुम्हारी नक़दी मिल चुकी। फिर वह शमौन को निकाल कर उनके पास ले आया। ");
INSERT INTO urd_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","और उस शख़्स ने उनको यूसुफ़ के घर में लाकर पानी दिया, और उन्होंने अपने पाँव धोए; और उनके गधों को चारा दिया। ");
INSERT INTO urd_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","फिर उन्होंने यूसुफ़ के इन्तिज़ार में कि वह दोपहर को आएगा, नज़राना तैयार करके रख्खा; क्यूँकि उन्होंने सुना था कि उनको वहीं रोटी खानी है। ");
INSERT INTO urd_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","जब यूसुफ़ घर आया, तो वह उस नज़राने को जो उनके पास था उसके सामने ले गए, और ज़मीन पर झुक कर उसके सामने आदाब बजा लाए। ");
INSERT INTO urd_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","उसने उनसे ख़ैर — ओ — 'आफियत पूछी और कहा कि तुम्हारा बूढ़ा बाप जिसका तुम ने ज़िक्र किया था अच्छा तो है? क्या वह अब तक ज़िन्दा है? ");
INSERT INTO urd_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","उन्होंने जवाब दिया, “तेरा ख़ादिम हमारा बाप ख़ैरियत से है; और अब तक ज़िन्दा है।” फिर वह सिर झुका — झुका कर उसके सामने आदाब बजा लाए। ");
INSERT INTO urd_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","फिर उसने आँख उठा कर अपने भाई बिनयमीन को जो उसकी माँ का बेटा था, देखा और कहा कि तुम्हारा सबसे छोटा भाई जिसका ज़िक्र तुम ने मुझ से किया था यही है? फिर कहा कि ऐ मेरे बेटे! ख़ुदा तुझ पर मेहरबान रहे। ");
INSERT INTO urd_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","तब यूसुफ़ ने जल्दी की क्यूँकि भाई को देख कर उसका जी भर आया, और वह चाहता था कि कहीं जाकर रोए। तब वह अपनी कोठरी में जा कर वहाँ रोने लगा। ");
INSERT INTO urd_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","फिर वह अपना मुँह धोकर बाहर निकला और अपने को बर्दाश्त करके हुक्म दिया कि खाना लगाओ। ");
INSERT INTO urd_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","और उन्होंने उसके लिए अलग और उनके लिए जुदा, और मिस्रियों के लिए, जो उसके साथ खाते थे, जुदा खाना लगाया; क्यूँकि मिस्र के लोग इब्रानियों के साथ खाना नहीं खा सकते थे, क्यूँकि मिस्रियों को इससे कराहियत है। ");
INSERT INTO urd_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","और यूसुफ़ के भाई उसके सामने तरतीबवार अपनी उम्र की बड़ाई और छोटाई के मुताबिक़ बैठे और आपस में हैरान थे। ");
INSERT INTO urd_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","फिर वह अपने सामने से खाना उठा कर हिस्से कर — कर के उनको देने लगा, और बिनयमीन का हिस्सा उनके हिस्सों से पाँच गुना ज़्यादा था। और उन्होंने मय पी और उसके साथ खु़शी मनाई। ");
INSERT INTO urd_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","फिर उसने अपने घर के मुन्ताज़िम को यह हुक्म किया कि इन आदमियों के बोरों में जितना अनाज वह लेजा सकें भर दे, और हर शख़्स की नक़दी उसी के बोरे के मुँह में रख दे; ");
INSERT INTO urd_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","और मेरा चाँदी का प्याला सबसे छोटे के बोरे के मुँह में उसकी नक़दी के साथ रखना। चुनांचे उसने यूसुफ़ के फ़रमाने के मुताबिक़ 'अमल किया। ");
INSERT INTO urd_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","सुबह रौशनी होते ही यह आदमी अपने गधों के साथ रुख़्सत कर दिए गए। ");
INSERT INTO urd_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","वह शहर से निकल कर अभी दूर भी नहीं गए थे कि यूसुफ़ ने अपने घर के मुन्तज़िम से कहा, जा! उन लोगों का पीछा कर; और जब तू उनको पा ले तो उनसे कहना, 'नेकी के बदले तुम ने बदी क्यूँ की? ");
INSERT INTO urd_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","क्या यह वही चीज़ नहीं जिससे मेरा आक़ा पीता और इसी से ठीक फ़ाल भी खोला करता है? तुम ने जो यह किया इसलिए बुरा किया' ");
INSERT INTO urd_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","और उसने उनको पा लिया और यही बातें उनसे कहीं। ");
INSERT INTO urd_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","तब उन्होंने उससे कहा कि हमारा ख़ुदावन्द, ऐसी बातें क्यूँ कहता है? ख़ुदा न करे कि तेरे ख़ादिम ऐसा काम करें ");
INSERT INTO urd_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","भला, जो नक़दी हम को अपने बोरों के मुँह में मिली, उसे तो हम मुल्क — ए — कना'न से तेरे पास वापस ले आए; फिर तेरे आक़ा के घर से चाँदी या सोना क्यूँ कर चुरा सकते हैं? ");
INSERT INTO urd_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","इसलिए तेरे ख़ादिमों में से जिस किसी के पास वह निकले वह मार दिया जाए, और हम भी अपने ख़ुदावन्द के ग़ुलाम हो जाएँगे। ");
INSERT INTO urd_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","उसने कहा कि तुम्हारा ही कहना सही, जिसके पास वह निकल आए वह मेरा ग़ुलाम होगा, और तुम बेगुनाह ठहरोगे। ");
INSERT INTO urd_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","तब उन्होंने जल्दी की, और एक — एक ने अपना बोरा ज़मीन पर उतार लिया और हर शख़्स ने अपना बोरा खोल दिया। ");
INSERT INTO urd_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","तब वह ढूँढने लगा और सबसे बड़े से शुरू' करके सबसे छोटे पर तलाशी ख़त्म की, और प्याला बिनयमीन के बोरे में मिला। ");
INSERT INTO urd_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","तब उन्होंने अपने लिबास चाक किए और हर एक अपने गधे को लादकर उल्टा शहर को फिरा। ");
INSERT INTO urd_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","और यहूदाह और उसके भाई यूसुफ़ के घर आए, वह अब तक वहीं था; तब वह उसके आगे ज़मीन पर गिरे। ");
INSERT INTO urd_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","तब यूसुफ़ ने उनसे कहा, “तुम ने यह कैसा काम किया? क्या तुम को मा'लूम नहीं कि मुझ सा आदमी ठीक फ़ाल खोलता है?” ");
INSERT INTO urd_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","यहूदाह ने कहा कि हम अपने ख़ुदावन्द से क्या कहें? हम क्या बात करें? या क्यूँ कर अपने को बरी ठहराएँ? ख़ुदा ने तेरे ख़ादिमों की बदी पकड़ ली। इसलिए देख, हम भी और वह भी जिसके पास प्याला निकला, दोनों अपने ख़ुदावन्द के ग़ुलाम हैं। ");
INSERT INTO urd_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","उसने कहा कि ख़ुदा न करे कि मैं ऐसा करूँ; जिस शख़्स के पास यह प्याला निकला वही मेरा ग़ुलाम होगा, और तुम अपने बाप के पास सलामत चले जाओ। ");
INSERT INTO urd_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","तब यहूदाह उसके नज़दीक जाकर कहने लगा, “ऐ मेरे ख़ुदावन्द! ज़रा अपने ख़ादिम को इजाज़त दे कि अपने ख़ुदावन्द के कान में एक बात कहे; और तेरा ग़ज़ब तेरे ख़ादिम पर न भड़के, क्यूँकि तू फ़िर'औन की तरह है। ");
INSERT INTO urd_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","मेरे ख़ुदावन्द ने अपने ख़ादिमों से सवाल किया था कि तुम्हारा बाप या तुम्हारा भाई है? ");
INSERT INTO urd_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","और हम ने अपने ख़ुदावन्द से कहा था, 'हमारा एक बूढ़ा बाप है और उसके बुढ़ापे का एक छोटा लड़का भी है; और उसका भाई मर गया है और वह अपनी माँ का एक ही रह गया है, इसलिए उसका बाप उस पर जान देता है। ");
INSERT INTO urd_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","तब तूने अपने ख़ादिमों से कहा, 'उसे मेरे पास ले आओ कि मैं उसे देख़ूँ। ");
INSERT INTO urd_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","हम ने अपने ख़ुदावन्द को बताया, 'वह लड़का अपने बाप को छोड़ नहीं सकता, क्यूँकि अगर वह अपने बाप को छोड़े तो उसका बाप मर जाएगा। ");
INSERT INTO urd_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","फिर तूने अपने खादिमों से कहा कि जब तक तुम्हारा छोटा भाई तुम्हारे साथ न आए, तुम फिर मेरा मुँह न देखोगे।” ");
INSERT INTO urd_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","और यूँ हुआ कि जब हम अपने बाप के पास, जो तेरा ख़ादिम है, पहुँचे तो हम ने अपने ख़ुदावन्द की बातें उससे कहीं। ");
INSERT INTO urd_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","हमारे बाप ने कहा, “फिर जा कर हमारे लिए कुछ अनाज मोल लाओ।” ");
INSERT INTO urd_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","हम ने कहा, “हम नहीं जा सकते; अगर हमारा सबसे छोटा भाई हमारे साथ हो तो हम जाएँगे। क्यूँकि जब तक हमारा सबसे छोटा भाई हमारे साथ न हो, हम उस शख़्स का मुँह न देखेंगे।” ");
INSERT INTO urd_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","और तेरे ख़ादिम मेरे बाप ने हम से कहा, “तुम जानते हो कि मेरी बीवी के मुझ से दो बेटे हुए। ");
INSERT INTO urd_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","एक तो मुझे छोड़ ही गया और मैंने ख़्याल किया कि वह ज़रूर फाड़ डाला गया होगा; और मैंने उसे उस वक़्त से फिर नहीं देखा। ");
INSERT INTO urd_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","अब अगर तुम इसको भी मेरे पास से ले जाओ और इस पर कोई आफ़त आ पड़े, तो तुम मेरे सफ़ेद बालों को ग़म के साथ क़ब्र में उतारोगे।” ");
INSERT INTO urd_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“इसलिए अब अगर मैं तेरे ख़ादिम अपने बाप के पास जाऊँ और यह लड़का हमारे साथ न हो, तो चूँकि उसकी जान इस लड़के की जान के साथ जुड़ी है। ");
INSERT INTO urd_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","वह यह देख कर कि लड़का नहीं आया मर जाएगा, और तेरे ख़ादिम अपने बाप के, जो तेरा ख़ादिम है, सफ़ेद बालों को ग़म के साथ क़ब्र में उतारेंगे। ");
INSERT INTO urd_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","और तेरा ख़ादिम अपने बाप के सामने इस लड़के का ज़िम्मेदार भी हो चुका है और यह कहा है किअगर मैं इसे तेरे पास वापस न पहुँचा दूँ तो मैं हमेशा के लिए अपने बाप का गुनहगार ठहरूंगा। ");
INSERT INTO urd_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","इसलिए अब तेरे ख़ादिम की इजाज़त हो कि वह इस लड़के के बदले अपने ख़ुदावन्द का ग़ुलाम हो कर रह जाए, और यह लड़का अपने भाइयों के साथ चला जाए। ");
INSERT INTO urd_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","क्यूँकि लड़के के बग़ैर मैं क्या मुँह लेकर अपने बाप के पास जाऊँ? कहीं ऐसा न हो कि मुझे वह मुसीबत देखनी पड़े, जो ऐसे हाल में मेरे बाप पर आएगी।” ");
INSERT INTO urd_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","तब यूसुफ़ उनके आगे जो उसके आस पास खड़े थे, अपने को रोक न कर सका और चिल्ला कर कहा, “हर एक आदमी को मेरे पास से बाहर कर दो।” चुनांचे जब यूसुफ़ ने अपने आप को अपने भाइयों पर ज़ाहिर किया उस वक़्त और कोई उसके साथ न था। ");
INSERT INTO urd_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","और वह ज़ोर ज़ोर से रोने लगा; और मिस्रियों ने सुना, और फ़िर'औन के महल में भी आवाज़ गई। ");
INSERT INTO urd_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","और यूसुफ़ ने अपने भाइयों से कहा, “मैं यूसुफ़ हूँ! क्या मेरा बाप अब तक ज़िन्दा है?” और उसके भाई उसे कुछ जवाब न दे सके, क्यूँकि वह उसके सामने घबरा गए। ");
INSERT INTO urd_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","और यूसुफ़ ने अपने भाइयों से कहा, “ज़रा नज़दीक आ जाओ।” और वह नज़दीक आए। तब उसने कहा, “मैं तुम्हारा भाई यूसुफ़ हूँ, जिसको तुम ने बेच कर मिस्र पहुँचवाया। ");
INSERT INTO urd_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","और इस बात से कि तुम ने मुझे बेच कर यहाँ पहुँचवाया, न तो ग़मगीन हो और न अपने — अपने दिल में परेशान हो; क्यूँकि ख़ुदा ने जानों को बचाने के लिए मुझे तुम से आगे भेजा। ");
INSERT INTO urd_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","इसलिए कि अब दो साल से मुल्क में काल है, और अभी पाँच साल और ऐसे हैं जिनमें न तो हल चलेगा और न फसल कटेगी। ");
INSERT INTO urd_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","और ख़ुदा ने मुझ को तुम्हारे आगे भेजा, ताकि तुम्हारा बक़िया ज़मीन पर सलामत रख्खे और तुम को बड़ी रिहाई के वसीले से ज़िन्दा रख्खे। ");
INSERT INTO urd_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","फिर तुम ने नहीं बल्कि ख़ुदा ने मुझे यहाँ भेजा, और उसने मुझे गोया फ़िर'औन का बाप और उसके सारे घर का ख़ुदावन्द और सारे मुल्क — ए — मिस्र का हाकिम बनाया। ");
INSERT INTO urd_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","इसलिए तुम जल्द मेरे बाप के पास जाकर उससे कहो, 'तेरा बेटा यूसुफ़ यूँ कहता है, कि ख़ुदावन्द ने मुझ को सारे मिस्र का मालिक कर दिया है। तू मेरे पास चला आ, देर न कर। ");
INSERT INTO urd_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","तू जशन के इलाक़े में रहना, और तू और तेरे बेटे और तेरे पोते और तेरी भेड़ बकरियाँ और गायें बैल और तेरा माल ओ — मता'अ, यह सब मेरे नज़दीक होंगे। ");
INSERT INTO urd_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","और वहीं मैं तेरी परवरिश करूँगा; ऐसा न हो कि तुझ को और तेरे घराने और तेरे माल — ओ — मता'अ को ग़रीबी आ दबाए, क्यूँकि काल के अभी पाँच साल और हैं। ");
INSERT INTO urd_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","और देखो, तुम्हारी आँखें और मेरे भाई बिनयमीन की आँखें देखती हैं कि खुद मेरे मुँह से ये बातें तुम से हो रही हैं। ");
INSERT INTO urd_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","और तुम मेरे बाप से मेरी सारी शान — ओ — शौकत का जो मुझे मिस्र में हासिल है, और जो कुछ तुम ने देखा है सबका ज़िक्र करना; और तुम बहुत जल्द मेरे बाप को यहाँ ले आना।” ");
INSERT INTO urd_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","और वह अपने भाई बिनयमीन के गले लग कर रोया और बिनयमीन भी उसके गले लगकर रोया। ");
INSERT INTO urd_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","और उसने सब भाइयों को चूमा और उनसे मिल कर रोया, इसके बाद उसके भाई उससे बातें करने लगे। ");
INSERT INTO urd_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","और फ़िर'औन के महल में इस बात का ज़िक्र हुआ कि यूसुफ़ के भाई आए हैं और इस से फ़िर'औन के नौकर चाकर बहुत खुश हुए। ");
INSERT INTO urd_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","और फ़िर'औन ने यूसुफ़ से कहा कि अपने भाइयों से कह, “तुम यह काम करो कि अपने जानवरों को लाद कर मुल्क — ए — कना'न को चले जाओ। ");
INSERT INTO urd_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","और अपने बाप को और अपने — अपने घराने को लेकर मेरे पास आ जाओ, और जो कुछ मुल्क — ए — मिस्र में अच्छे से अच्छा है वह मैं तुम को दूँगा और तुम इस मुल्क की उम्दा उम्दा चीज़ें खाना। ");
INSERT INTO urd_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","तुझे हुक्म मिल गया है, कि उनसे कहे, 'तुम यह करो कि अपने बाल बच्चों और अपनी बीवियों के लिए मुल्क — ए — मिस्र से अपने साथ गाड़ियाँ ले जाओ, और अपने बाप को भी साथ लेकर चले आओ। ");
INSERT INTO urd_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","और अपने अस्बाब का कुछ अफ़सोस न करना, क्यूँकि मुल्क — ए — मिस्र की सब अच्छी चीज़ें तुम्हारे लिए हैं।” ");
INSERT INTO urd_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","और इस्राईल के बेटों ने ऐसा ही किया; और यूसुफ़ ने फ़िर'औन के हुक्म के मुताबिक़ उनको गाड़ियाँ दीं और सफ़र का सामान भी दिया। ");
INSERT INTO urd_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","और उसने उनमें से हर एक को एक — एक जोड़ा कपड़ा दिया, लेकिन बिनयमीन को चाँदी के तीन सौ सिक्के और पाँच जोड़े कपड़े दिए। ");
INSERT INTO urd_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","और अपने बाप के लिए उसने यह चीज़ें भेजीं, या'नी दस गधे जो मिस्र की अच्छी चीज़ों से लदे हुए थे, और दस गधियाँ जो उसके बाप के रास्ते के लिए ग़ल्ला और रोटी और सफ़र के सामान से लदी हुई थीं। ");
INSERT INTO urd_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","चुनांचे उसने अपने भाइयों को रवाना किया और वह चल पड़े; और उसने उनसे कहा, “देखना, कहीं रास्ते में तुम झगड़ा न करना।” ");
INSERT INTO urd_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","और वह मिस्र से रवाना हुए और मुल्क — ए — कना'न में अपने बाप या'क़ूब के पास पहुँचे, ");
INSERT INTO urd_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","और उससे कहा, “यूसुफ़ अब तक ज़िन्दा है और वही सारे मुल्क — ए — मिस्र का हाकिम है।” और या'क़ूब का दिल धक से रह गया, क्यूँकि उसने उनका यक़ीन न किया। ");
INSERT INTO urd_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","तब उन्होंने उसे वह सब बातें जो यूसुफ़ ने उनसे कही थीं बताई, और जब उनके बाप या'क़ूब ने वह गाड़ियाँ देख लीं जो यूसुफ़ ने उसके लाने को भेजीं थीं, तब उसकी जान में जान आई। ");
INSERT INTO urd_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","और इस्राईल कहने लगा, “यह बस है कि मेरा बेटा यूसुफ़ अब तक ज़िन्दा है। मैं अपने मरने से पहले जाकर उसे देख तो लूँगा।” ");
INSERT INTO urd_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","और इस्राईल अपना सब कुछ लेकर चला और बैरसबा' में आकर अपने बाप इस्हाक़ के ख़ुदा के लिए क़ुर्बानियाँ पेश कीं। ");
INSERT INTO urd_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","और ख़ुदा ने रात को ख़्वाब में इस्राईल से बातें कीं और कहा, ऐ या'क़ूब, ऐ या'कूब! “उसने जवाब दिया, मैं हाज़िर हूँ।” ");
INSERT INTO urd_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","उसने कहा, “मैं ख़ुदा, तेरे बाप का ख़ुदा हूँ! मिस्र में जाने से न डर, क्यूँकि मैं वहाँ तुझ से एक बड़ी क़ौम पैदा करूँगा। ");
INSERT INTO urd_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","मैं तेरे साथ मिस्र को जाऊँगा और फिर तुझे ज़रूर लौटा भी लाऊँगा, और यूसुफ़ अपना हाथ तेरी आँखों पर लगाएगा।” ");
INSERT INTO urd_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","तब या'क़ूब बैरसबा' से रवाना हुआ, और इस्राईल के बेटे अपने बाप या'क़ूब को और अपने बाल बच्चों और अपनी बीवियों को उन गाड़ियों पर ले गए जो फ़िर'औन ने उनके लाने को भेजीं थीं। ");
INSERT INTO urd_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","और वह अपने चौपायों और सारे माल — ओ — अस्बाब को जो उन्होंने मुल्क — ए — कना'न में जमा' किया था लेकर मिस्र में आए, और या'क़ूब के साथ उसकी सारी औलाद थी। ");
INSERT INTO urd_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","वह अपने बेटों और बेटियों और पोतों और पोतियों, और अपनी कुल नसल को अपने साथ मिस्र में ले आया। ");
INSERT INTO urd_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","और या'क़ूब के साथ जो इस्राईली या'नी उसके बेटे वग़ैरा मिस्र में आए उनके नाम यह हैं: रूबिन, या'क़ूब का पहलौठा। ");
INSERT INTO urd_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","और बनी रूबिन यह हैं: हनूक और फ़ल्लू और हसरोन और करमी। ");
INSERT INTO urd_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","और बनी शमौन यह हैं: यमूएल और यमीन और उहद और यकीन और सुहर और साऊल, जो एक कना'नी 'औरत से पैदा हुआ था। ");
INSERT INTO urd_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","और बनी लावी यह हैं: जैरसोन और किहात और मिरारी। ");
INSERT INTO urd_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","और बनी यहूदाह यह हैं: 'एर और ओनान और सीला, और फ़ारस और ज़ारह — इनमें से 'एर और ओनान मुल्क — ए — कना'न में मर चुके थे। और फ़ारस के बेटे यह हैं: हसरोन और हमूल। ");
INSERT INTO urd_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","और बनी इश्कार यह हैं: तोला' और फूवा और योब और सिमरोन। ");
INSERT INTO urd_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","और बनी ज़बूलून यह हैं: सरद और एलोन और यहलीएल। ");
INSERT INTO urd_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","यह सब या'क़ूब के उन बेटों की औलाद हैं जो फ़द्दान अराम में लियाह से पैदा हुए, इसी के बत्न से उसकी बेटी दीना थी। यहाँ तक तो उसके सब बेटे बेटियों का शुमार तैंतीस हुआ। ");
INSERT INTO urd_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","बनी जद्द यह हैं: सफ़ियान और हज्जी और सूनी और असबान और 'एरी और अरूदी और अरेली। ");
INSERT INTO urd_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","और बनी आशर यह हैं: यिमना और इसवाह और इसवी और बरि'आह और सिर्राह उनकी बहन और बनी बरी'आह यह हैं: हिब्र और मलकीएल। ");
INSERT INTO urd_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","यह सब या'क़ूब के उन बेटों की औलाद हैं जो ज़िल्फ़ा लौंडी से पैदा हुए, जिसे लाबन ने अपनी बेटी लियाह को दिया था। उनका शुमार सोलह था। ");
INSERT INTO urd_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","और या'क़ूब के बेटे यूसुफ़ और बिनयमीन राख़िल से पैदा हुए थे। ");
INSERT INTO urd_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","और यूसुफ़ से मुल्क — ए — मिस्र में ओन के पुजारी फ़ोतीफ़िरा' की बेटी आसिनाथ के मनस्सी और इफ़्राईम पैदा हुए। ");
INSERT INTO urd_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","और बनी बिनयमीन यह हैं: बाला' और बक्र और अशबेल और जीरा और ना'मान, अख़ी और रोस, मुफ़्फ़ीम और हुफ़्फ़ीम और अरद। ");
INSERT INTO urd_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","यह सब या'क़ूब के उन बेटों की औलाद हैं जो राख़िल से पैदा हुए। यह सब शुमार में चौदह थे। ");
INSERT INTO urd_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","और दान के बेटे का नाम हशीम था। ");
INSERT INTO urd_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","और बनी नफ़्ताली यह हैं: यहसीएल और जूनी और यिस्र और सलीम। ");
INSERT INTO urd_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","यह सब या'क़ूब के उन बेटों की औलाद हैं जो बिल्हाह लौंडी से पैदा हुए, जिसे लाबन ने अपनी बेटी राख़िल को दिया था। इनका शुमार सात था। ");
INSERT INTO urd_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","या'क़ूब के सुल्ब से जो लोग पैदा हुए और उसके साथ मिस्र में आए वह उसकी बहुओं को छोड़ कर शुमार में छियासठ थे। ");
INSERT INTO urd_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","और यूसुफ़ के दो बेटे थे जो मिस्र में पैदा हुए, इसलिए या'क़ूब के घराने के जो लोग मिस्र में आए वह सब मिल कर सत्तर हुए। ");
INSERT INTO urd_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","और उसने यहूदाह को अपने से आगे यूसुफ़ के पास भेजा ताकि वह उसे जशन का रास्ता दिखाए, और वह जशन के 'इलाक़े में आए। ");
INSERT INTO urd_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","और यूसुफ़ अपना रथ तैयार करवा के अपने बाप इस्राईल के इस्तक़बाल के लिए जशन को गया, और उसके पास जाकर उसके गले से लिपट गया और वहीं लिपटा हुआ देर तक रोता रहा। ");
INSERT INTO urd_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","तब इस्राईल ने यूसुफ़ से कहा, “अब चाहे मैं मर जाऊँ; क्यूँकि तेरा मुँह देख चुका कि तू अभी ज़िन्दा है।” ");
INSERT INTO urd_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","और यूसुफ़ ने अपने भाइयों से और अपने बाप के घराने से कहा, मैं अभी जाकर फ़िर'औन को ख़बर कर दूँगा और उससे कह दूँगा कि मेरे भाई और मेरे बाप के घराने के लोग, जो मुल्क — ए — कना'न में थे मेरे पास आ गए हैं। ");
INSERT INTO urd_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","और वह चौपान हैं; क्यूँकि बराबर चौपायों को पालते आए हैं, और वह अपनी भेड़ बकरियाँ और गाय — बैल और जो कुछ उनका है सब ले आए हैं। ");
INSERT INTO urd_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","तब जब फ़िर'औन तुम को बुला कर पूछे कि तुम्हारा पेशा क्या है? ");
INSERT INTO urd_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","तो तुम यह कहना कि तेरे ख़ादिम, हम भी और हमारे बाप दादा भी, लड़कपन से लेकर आज तक चौपाये पालते आए हैं। तब तुम जशन के इलाक़े में रह सकोगे, इसलिए कि मिस्रियों को चौपानों से नफ़रत है। ");
INSERT INTO urd_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","तब यूसुफ़ ने आकर फ़िर'औन को ख़बर दी कि मेरा बाप और मेरे भाई और उनकी भेड़ बकरियाँ और गाय बैल और उनका सारा माल — ओ — सामान' मुल्क — ए — कना'न से आ गया है, और अभी तो वह सब जशन के 'इलाक़े में हैं। ");
INSERT INTO urd_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","फिर उसने अपने भाइयों में से पाँच को अपने साथ लिया और उनको फ़िर'औन के सामने हाज़िर किया। ");
INSERT INTO urd_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","और फ़िर'औन ने उसके भाइयों से पूछा, “तुम्हारा पेशा क्या है?” उन्होंने फ़िर'औन से कहा, “तेरे ख़ादिम चौपान हैं जैसे हमारे बाप दादा थे।” ");
INSERT INTO urd_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","फिर उन्होंने फ़िर'औन से कहा कि हम इस मुल्क में मुसाफ़िराना तौर पर रहने आए हैं, क्यूँकि मुल्क — ए — कना'न में सख़्त काल होने की वजह से वहाँ तेरे खादिमों के चौपायों के लिए चराई नहीं रही। इसलिए करम करके अपने ख़ादिमों को जशन के 'इलाक़े में रहने दे। ");
INSERT INTO urd_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","तब फ़िर'औन ने यूसुफ़ से कहा कि तेरा बाप और तेरे भाई तेरे पास आ गए हैं। ");
INSERT INTO urd_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","मिस्र का मुल्क तेरे आगे पड़ा है, यहाँ के अच्छे से अच्छे इलाक़े में अपने बाप और भाइयों को बसा दे, या'नी जशन ही के 'इलाक़े में उनको रहने दे, और अगर तेरी समझ में उनमें होशियार आदमी भी हों तो उनको मेरे चौपायों पर मुक़र्रर कर दे। ");
INSERT INTO urd_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","और यूसुफ़ अपने बाप या'क़ूब को अन्दर लाया और उसे फ़िर'औन के सामने हाज़िर किया, और या'क़ूब ने फ़िर'औन को दुआ दी। ");
INSERT INTO urd_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","और फ़िर'औन ने या'क़ूब से पूछा कि तेरी उम्र कितने साल की है? ");
INSERT INTO urd_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","या'क़ूब ने फ़िर'औन से कहा कि मेरी मुसाफ़िरत के साल एक सौ तीस हैं; मेरी ज़िन्दगी के दिन थोड़े और दुख से भरे हुए रहे, और अभी यह इतने हुए भी नही हैं जितने मेरे बाप दादा की ज़िन्दगी के दिन उनके दौर — ए — मुसाफ़िरत में हुए। ");
INSERT INTO urd_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","और या'क़ूब फ़िर'औन को दुआ दे कर उसके पास से चला गया। ");
INSERT INTO urd_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","और यूसुफ़ ने अपने बाप और अपने भाइयों को बसा दिया और फ़िर'औन के हुक्म के मुताबिक़ रा'मसीस के इलाक़े को, जो मुल्क — ए — मिस्र का निहायत हरा भरा 'इलाक़ा है उनकी जागीर ठहराया। ");
INSERT INTO urd_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","और यूसुफ़ अपने बाप और अपने भाइयों और अपने बाप के घर के सब आदमियों की परवरिश, एक — एक के ख़ान्दान की ज़रूरत के मुताबिक़ अनाज से करने लगा। ");
INSERT INTO urd_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","और उस सारे मुल्क में खाने को कुछ न रहा, क्यूँकि काल ऐसा सख़्त था कि मुल्क — ए — मिस्र और मुल्क — ए — कना'न दोनों काल की वजह से तबाह हो गए थे। ");
INSERT INTO urd_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","और जितना रुपया मुल्क — ए — मिस्र और मुल्क — ए — कना'न में था वह सब यूसुफ़ ने उस ग़ल्ले के बदले, जिसे लोग ख़रीदते थे, ले ले कर जमा' कर लिया और सब रुपये को उसने फ़िर'औन के महल में पहुँचा दिया। ");
INSERT INTO urd_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","और जब वह सारा रुपया, जो मिस्र और कनान के मुल्कों में था, ख़र्च हो गया तो मिस्री यूसुफ़ के पास आकर कहने लगे, “हम को अनाज दे; क्यूँकि रुपया तो हमारे पास रहा नहीं। हम तेरे होते हुए क्यूँ। मरें?” ");
INSERT INTO urd_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","यूसुफ़ ने कहा कि अगर रुपया नहीं हैं तो अपने चौपाये दो; और मैं तुम्हारे चौपायों के बदले तुम को अनाज दूँगा। ");
INSERT INTO urd_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","तब वह अपने चौपाये यूसुफ़ के पास लाने लगे और गाय बैलों और गधों के बदले उनको अनाज देने लगा; और पूरे साल भर उनको उनके सब चौपायों के बदले अनाज खिलाया। ");
INSERT INTO urd_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","जब यह साल गुज़र गया तो वह दूसरे साल उसके पास आ कर कहने लगे कि इसमें हम अपने ख़ुदावन्द से कुछ नहीं छिपाते कि हमारा सारा रुपया खर्च हो चुकाऔर हमारे चौपायों के गल्लों का मालिक भी हमारा ख़ुदावन्द हो गया है। और हमारा ख़ुदावन्द देख चुका है कि अब हमारे जिस्म और हमारी ज़मीन के अलावा कुछ बाक़ी नहीं। ");
INSERT INTO urd_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","फिर ऐसा क्यूँ हो कि तेरे देखते — देखते हम भी मरें और हमारी ज़मीन भी उजड़ जाए? इसलिए तू हम को और हमारी ज़मीन को अनाज के बदले ख़रीद ले कि हम फ़िर'औन के ग़ुलाम बन जाएँ, और हमारी ज़मीन का मालिक भी वही हो जाए और हम को बीज दे ताकि हम हलाक न हों बल्कि ज़िन्दा रहें और मुल्क भी वीरान न हो। ");
INSERT INTO urd_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","और यूसुफ़ ने मिस्र की सारी ज़मीन फ़िर'औन के नाम पर ख़रीद ली; क्यूँकि काल से तंग आ कर मिस्रियों में से हर शख़्स ने अपना खेत बेच डाला। तब सारी ज़मीन फ़िर'औन की हो गई। ");
INSERT INTO urd_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","और मिस्र के एक सिरे से लेकर दूसरे सिरे तक जो लोग रहते थे उनको उसने शहरों में बसाया। ");
INSERT INTO urd_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","लेकिन पुजारियों की ज़मीन उसने न ख़रीदी, क्यूँकि फ़िर'औन की तरफ़ से पुजारियों को ख़ुराक मिलती थी। इसलिए वह अपनी — अपनी ख़ुराक, जो फ़िर'औन उनको देता था खाते थे इसलिए उन्होंने अपनी ज़मीन न बेची। ");
INSERT INTO urd_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","तब यूसुफ़ ने वहाँ के लोगों से कहा, कि देखो, मैंने आज के दिन तुम को और तुम्हारी ज़मीन को फ़िर'औन के नाम पर ख़रीद लिया है। इसलिए तुम अपने लिए यहाँ से बीज लो और खेत बो डालो। ");
INSERT INTO urd_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","और फ़सल पर पाँचवाँ हिस्सा फ़िर'औन को दे देना और बाक़ी चार तुम्हारे रहे, ताकि खेती के लिए बीज के भी काम आएँ, और तुम्हारे और तुम्हारे घर के आदमियों और तुम्हारे बाल बच्चों के लिए खाने को भी हो। ");
INSERT INTO urd_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","उन्होंने कहा, कि तूने हमारी जान बचाई है, हम पर हमारे ख़ुदावन्द के करम की नज़र रहे और हम फ़िर'औन के ग़ुलाम बने रहेंगे। ");
INSERT INTO urd_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","और यूसुफ़ ने यह कानून जो आज तक है मिस्र की ज़मीन के लिए ठहराया, के फ़िर'औन पैदावार का पाँचवाँ हिस्सा लिया करे। इसलिए सिर्फ़ पुजारियों की ज़मीन ऐसी थी जो फ़िर'औन की न हुई। ");
INSERT INTO urd_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","और इस्राईली मुल्क — ए — मिस्र में जशन के इलाक़े में रहते थे, और उन्होंने अपनी जायदादें खड़ी कर लीं और वह बढ़े और बहुत ज़्यादा हो गए। ");
INSERT INTO urd_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","और या'क़ूब मुल्क — ए — मिस्र में सत्रह साल और जिया; तब या'क़ूब की कुल उम्र एक सौ सैंतालीस साल की हुई। ");
INSERT INTO urd_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","और इस्राईल के मरने का वक़्त नज़दीक आया; तब उसने अपने बेटे यूसुफ़ को बुला कर उससे कहा, “अगर मुझ पर तेरे करम की नज़र है तो अपना हाथ मेरी रान के नीचे रख, और देख, मेहरबानी और सच्चाई से मेरे साथ पेश आना; मुझ को मिस्र में दफ़्न न करना। ");
INSERT INTO urd_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","बल्कि जब मैं अपने बाप — दादा के साथ सो जाऊँ तो मुझे मिस्र से ले जाकर उनके कब्रिस्तान में दफ़न करना।” उसने जवाब दिया, “जैसा तूने कहा है मैं वैसा ही करूँगा।” ");
INSERT INTO urd_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","और उसने कहा कि तू मुझ से क़सम खा। और उसने उससे क़सम खाई, तब इस्राईल अपने बिस्तर पर सिरहाने की तरफ़ सिजदे में हो गया। ");
INSERT INTO urd_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","इन बातों के बाद यूँ हुआ कि किसी ने यूसुफ़ से कहा, “तेरा बाप बीमार है।” तब वह अपने दोनो बेटों, मनस्सी और इफ़्राईम को साथ लेकर चला। ");
INSERT INTO urd_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","और या'क़ूब से कहा गया, तेरा बेटा यूसुफ़ तेरे पास आ रहा है, और इस्राईल अपने को संभाल कर पलंग पर बैठ गया। ");
INSERT INTO urd_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","और या'क़ूब ने यूसुफ़ से कहा, “खुदा — ए — क़ादिर — ए — मुतलक़ मुझे लूज़ में जो मुल्क — ए — कना'न में है, दिखाई दिया और मुझे बरकत दी। ");
INSERT INTO urd_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","और उसने मुझ से कहा मै तुझे कामयाब करूँगा और बढ़ाऊंगा और तुझ से क़ौमों का एक गिरोह पैदा करूँगा; और तेरे बाद यह ज़मीन तेरी नसल को दूँगा, ताकि यह उनकी हमेशा की जायदाद हो जाए। ");
INSERT INTO urd_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","तब तेरे दोनों बेटे, जो मुल्क — ए — मिस्र में मेरे आने से पहले पैदा हुए मेरे हैं, या'नी रूबिन और शमौन की तरह इफ़्राईम और मनस्सी भी मेरे ही होंगे। ");
INSERT INTO urd_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","और जो औलाद अब उनके बाद तुझ से होगी वह तेरी ठहरेगी, लेकिन अपनी मीरास में अपने भाइयों के नाम से वह लोग नामज़द होंगे। ");
INSERT INTO urd_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","और मैं जब फ़द्दान से आता था तो राख़िल ने रास्ते ही में जब इफ़रात थोड़ी दूर रह गया था, मेरे सामने मुल्क — ए — कना'न में वफ़ात पाई। और मैंने उसे वहीं इफ़रात के रास्ते में दफ़्न किया। बैतलहम वही है।” ");
INSERT INTO urd_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","फिर इस्राईल ने यूसुफ़ के बेटों को देख कर पूछा, “यह कौन हैं?” ");
INSERT INTO urd_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","यूसुफ़ ने अपने बाप से कहा, “यह मेरे बेटे हैं जो ख़ुदा ने मुझे यहाँ दिए हैं।” उसने कहा, “उनको ज़रा मेरे पास ला, मैं उनको बरकत दूँगा।” ");
INSERT INTO urd_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","लेकिन इस्राईल की आँखें बुढ़ापे की वजह से धुन्धला गई थीं, और उसे दिखाई नहीं देता था। तब यूसुफ़ उनको उसके नज़दीक ले आया। तब उसने उनको चूम कर गले लगा लिया। ");
INSERT INTO urd_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","और इस्राईल ने यूसुफ़ से कहा, “मुझे तो ख़्याल भी न था कि मैं तेरा मुँह देखूँगा लेकिन ख़ुदा ने तेरी औलाद भी मुझे दिखाई।” ");
INSERT INTO urd_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","और यूसुफ़ उनको अपने घुटनों के बीच से हटा कर मुँह के बल ज़मीन तक झुका। ");
INSERT INTO urd_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","और यूसुफ़ उन दोनों को लेकर, या'नी इफ़्राईम को अपने दहने हाथ से इस्राईल के बाएं हाथ के सामने और मनस्सी को अपने बाएं हाथ से इस्राईल के दहने हाथ के सामने करके, उनको उसके नज़दीक लाया। ");
INSERT INTO urd_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","और इस्राईल ने अपना दहना हाथ बढ़ा कर इफ़्राईम के सिर पर जो छोटा था, और बाँया हाथ मनस्सी के सिर पर रख दिया। उसने जान बूझ कर अपने हाथ यूँ रख्खे, क्यूँकि पहलौठा तो मनस्सी ही था। ");
INSERT INTO urd_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","और उसने यूसुफ़ को बरकत दी और कहा कि ख़ुदा, जिसके सामने मेरे बाप अब्रहाम और इस्हाक़ ने अपना दौर पूरा किया; वह ख़ुदा, जिसने सारी उम्र आज के दिन तक मेरी रहनुमाई की। ");
INSERT INTO urd_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","और वह फ़रिश्ता, जिसने मुझे सब बलाओं से बचाया, इन लड़कों को बरकत दे; और जो मेरा और मेरे बाप दादा अब्रहाम और इस्हाक़ का नाम है उसी से यह नामज़द हों, और ज़मीन पर बहुत कसरत से बढ़ जाएँ। ");
INSERT INTO urd_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","और यूसुफ़ यह देखकर कि उसके बाप ने अपना दहना हाथ इफ़्राईम के सिर पर रख्खा, नाखुश हुआ और उसने अपने बाप का हाथ थाम लिया, ताकि उसे इफ़्राईम के सिर पर से हटाकर मनस्सी के सिर पर रख्खे। ");
INSERT INTO urd_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","और यूसुफ़ ने अपने बाप से कहा कि ऐ मेरे बाप, ऐसा न कर; क्यूँकि पहलौठा यह है, अपना दहना हाथ इसके सिर पर रख। ");
INSERT INTO urd_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","उसके बाप ने न माना, और कहा, “ऐ मेरे बेटे, मुझे खू़ब मा'लूम है। इससे भी एक गिरोह पैदा होगी और यह भी बुज़ुर्ग होगा, लेकिन इसका छोटा भाई इससे बहुत बड़ा होगा और उसकी नसल से बहुत सी क़ौमें होंगी।” ");
INSERT INTO urd_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","और उसने उनको उस दिन बरकत बख़्शी और कहा, इस्राईली तेरा नाम ले लेकर यूँ दुआ दिया करेंगे, 'ख़ुदा तुझ को इफ़्राईम और मनस्सी को तरह कामयाब करे'!' तब उसने इफ़ाईम को मनस्सी पर फ़ज़ीलत दी। ");
INSERT INTO urd_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","और इस्राईल ने यूसुफ़ से कहा, मैं तो मरता हूँ लेकिन ख़ुदा तुम्हारे साथ होगा और तुम को फिर तुम्हारे बाप दादा के मुल्क में ले जाएगा। ");
INSERT INTO urd_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","और मैं तुझे तेरे भाइयों से ज़्यादा एक हिस्सा, जो मैने अमोरियों के हाथ से अपनी तलवार और कमान से लिया देता हूँ। ");
INSERT INTO urd_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","और या'क़ूब ने अपने बेटों को यह कह कर बुलवाया कि तुम सब जमा' हो जाओ, ताकि मैं तुम को बताऊँ कि आख़िरी दिनों में तुम पर क्या — क्या गुज़रेगा। ");
INSERT INTO urd_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","ऐ, या'क़ूब के बेटों जमा' हो कर सुनो, और अपने बाप इस्राईल की तरफ़ कान लगाओ। ");
INSERT INTO urd_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","ऐ रूबिन! तू मेरा पहलौठा, मेरी क़ुव्वत और मेरी शहज़ोरी का पहला फल है। तू मेरे रौब की और मेरी ताक़त की शान है। ");
INSERT INTO urd_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","तू पानी की तरह बे सबात है, इसलिए मुझे फ़ज़ीलत नहीं मिलेगी क्यूँकि तू अपने बाप के बिस्तर पर चढ़ा तूने उसे नापाक किया; रूबिन मेरे बिछोने पर चढ़ गया। ");
INSERT INTO urd_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","शमौन और लावी तो भाई — भाई हैं, उनकी तलवारें ज़ुल्म के हथियार हैं। ");
INSERT INTO urd_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ऐ मेरी जान! उनके मधरे में शरीक न हो, ऐ मेरी बुज़ुर्गी! उनकी मजलिस में शामिल न हो, क्यूँकि उन्होंने अपने ग़ज़ब में एकआदमी को क़त्ल किया, और अपनी खुदराई से बैलों की कूँचें काटीं। ");
INSERT INTO urd_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ला'नत उनके ग़ज़ब पर, क्यूँकि वह तुन्द था। और उनके क़हर पर, क्यूँकि वह सख़्त था; मैं उन्हें या'क़ूब में अलग अलग और इस्राईल में बिखेर दूँगा। ");
INSERT INTO urd_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","ऐ यहूदाह, तेरे भाई तेरी मदह करेंगे, तेरा हाथ तेरे दुश्मनों की गर्दन पर होगा। तेरे बाप की औलाद तेरे आगे सिज्दा करेगी। ");
INSERT INTO urd_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","यहूदाह शेर — ए — बबर का बच्चा है ऐ मेरे बेटे! तू शिकार मार कर चल दिया है। वह शेर — ए — बबर, बल्कि शेरनी की तरह दुबक कर बैठ गया, कौन उसे छेड़े? ");
INSERT INTO urd_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","यहूदाह से सल्तनत नहीं छूटेगी। और न उसकी नसल से हुकूमत का 'असा मौकूफ़ होगा। जब तक शीलोह न आए और क़ौमें उसकी फ़रमाबरदार होंगी। ");
INSERT INTO urd_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","वह अपना जवान गधा अंगूर के दरख़्त से, और अपनी गधी का बच्चा 'आला दरजे के अंगूर के दरख़्त से बाँधा करेगा; वह अपना लिबास मय में, और अपनी पोशाक आब — ए अंगूर में धोया करेगा ");
INSERT INTO urd_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","उसकी आँखें मय की वजह से लाल, और उसके दाँत दूध की वजह से सफ़ेद रहा करेंगे। ");
INSERT INTO urd_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","ज़बूलून समुन्दर के किनारे बसेगा, और जहाज़ों के लिए बन्दरगाह का काम देगा, और उसकी हद सैदा तक फैली होगी। ");
INSERT INTO urd_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","इश्कार मज़बूत गधा है, जो दो भेड़सालों के बीच बैठा है; ");
INSERT INTO urd_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","उसने एक अच्छी आरामगाह और खुशनुमा ज़मीन को देख कर अपना कन्धा बोझ उठाने को झुकाया, और बेगार में ग़ुलाम की तरह काम करने लगा। ");
INSERT INTO urd_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","दान इस्राईल के क़बीलों में से एक की तरह अपने लोगों का इन्साफ़ करेगा। ");
INSERT INTO urd_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान रास्ते का साँप है, वह राहगुज़र का अज़दह है, जो घोड़े के 'अकब को ऐसा डसता है किउसका सवार पछाड़ खा कर गिर पड़ता है। ");
INSERT INTO urd_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","ऐ ख़ुदावन्द, मैं तेरी नजात की राह देखता आया हूँ। ");
INSERT INTO urd_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","जद्द पर एक फौज़ हमला करेगी लेकिन वह उसके दुम्बाला पर छापा मारेगा। ");
INSERT INTO urd_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","आशर नफ़ीस अनाज पैदा किया करेगा और बादशाहों के लायक़ लज़ीज़ सामान मुहय्या करेगा। ");
INSERT INTO urd_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","नफ़्ताली ऐसा है जैसा छूटी हुई हिरनी, वह मीठी — मीठी बातें करता है। ");
INSERT INTO urd_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","यूसुफ़ एक फलदार पौधा है, ऐसा फलदार पौधा जो पानी के चश्में के पास लगा हुआ हो, और उसकी शाखें। दीवार पर फैल गई हों। ");
INSERT INTO urd_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","तीरंदाज़ों ने उसे बहुत छेड़ा और मारा और सताया है; ");
INSERT INTO urd_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","लेकिन उसकी कमान मज़बूत रही, और उसके हाथों और बाजुओं ने या'क़ूब के क़ादिर के हाथ से ताक़त पाई, वहीं से वह चौपान उठा है जो इस्राईल की चट्टान है। ");
INSERT INTO urd_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","यह तेरे बाप के ख़ुदा का काम है, जो तेरी मदद करेगा, उसी क़ादिर — ए — मुतलक का काम जो ऊपर से आसमान की बरकतें, और नीचे से गहरे समुन्दर कि बरकतें 'अता करेगा। ");
INSERT INTO urd_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","तेरे बाप की बरकतें, मेरे बाप दादा की बरकतों से कहीं ज़्यादा हैं, और क़दीम पहाड़ों की इन्तिहा तक पहुँची हैं; वह यूसुफ़ के सिर, बल्कि उसके सिर की चाँदी पर जो अपने भाइयों से जुदा हुआ नाज़िल होंगी। ");
INSERT INTO urd_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","बिनयमीन फाड़ने वाला भेड़िया है, वह सुबह को शिकार खाएगा और शाम को लूट का माल बाँटेगा। ");
INSERT INTO urd_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","इस्राईल के बारह क़बीले यही हैं: और उनके बाप ने जो — जो बातें कह कर उनको बरकत दीं वह भी यही हैं; हर एक को, उसकी बरकत के मुवाफ़िक़ उसने बरकत दी। ");
INSERT INTO urd_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","फिर उसने उनको हुक्म किया और कहा, कि मैं अपने लोगों में शामिल होने पर हूँ; मुझे मेरे बाप दादा के पास उस मग़ारह मारे में जो इफ़रोन हित्ती के खेत में है दफ़्न करना, ");
INSERT INTO urd_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","या'नी उस मग़ारे में जो मुल्क — ए — कना'न में ममरे के सामने मकफ़ीला के खेत में है, जिसे अब्रहाम ने खेत के साथ 'इफ़रोन हित्ती से मोल लिया था, ताकि क़ब्रिस्तान के लिए वह उसकी मिलिकयत बन जाए। ");
INSERT INTO urd_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","वहाँ उन्होंने अब्रहाम को और उसकी बीवी सारा को दफ़न किया, वहीं उन्होने इस्हाक़ और उसकी बीवी रिबक़ा को दफ़न किया, और वहीं मैंने भी लियाह को दफ़न किया, ");
INSERT INTO urd_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","या'नी उसी खेत के माग़ारे में जो बनी हित्ती से ख़रीदा था। ");
INSERT INTO urd_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","और जब या'क़ूब अपने बेटों को वसीयत कर चुका तो, उसने अपने पाँव बिछौने पर समेट लिए और दम छोड़ दिया और अपने लोगों में जा मिला। ");
INSERT INTO urd_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","तब यूसुफ़ अपने बाप के मुँह से लिपट कर उस पर रोया और उसको चूमा। ");
INSERT INTO urd_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","और यूसुफ़ ने उन हकीमों को जो उसके नौकर थे, अपने बाप की लाश में खुशबू भरने का हुक्म दिया। तब हकीमों ने इस्राईल की लाश में ख़ुशबू भरी। ");
INSERT INTO urd_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","और उसके चालीस दिन पूरे हुए, क्यूँकि खुशबू भरने में इतने ही दिन लगते हैं। और मिस्री उसके लिए सत्तर दिन तक मातम करते रहे। ");
INSERT INTO urd_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","और जब मातम के दिन गुज़र गए तो यूसुफ़ ने फ़िर'औन के घर के लोगों से कहा, अगर मुझ पर तुम्हारे करम की नज़र है तो फ़िर'औन से ज़रा 'अर्ज़ कर दो, ");
INSERT INTO urd_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","कि मेरे बाप ने यह मुझ से क़सम लेकर कहा है, “मैं तो मरता हूँ, तू मुझ को मेरी क़ब्र में जो मैंने मुल्क — ए — कना'न में अपने लिए खुदवाई है, दफ़्न करना। इसलिए ज़रा मुझे इजाज़त दे कि मैं वहाँ जाकर अपने बाप को दफ़्न करूँ, और मैं लौट कर आ जाऊँगा।” ");
INSERT INTO urd_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","फ़िर'औन ने कहा, कि जा और अपने बाप को जैसे उसने तुझ से क़सम ली है दफ़्न कर। ");
INSERT INTO urd_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","तब यूसुफ़ अपने बाप को दफ़्न करने चला, और फ़िर'औन के सब ख़ादिम और उसके घर के बुज़ुर्ग, और मुल्क — ए — मिस्र के सब बुज़ुर्ग, ");
INSERT INTO urd_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","और यूसुफ़ के घर के सब लोग और उसके भाई, और उसके बाप के घर के आदमी उसके साथ गए; वह सिर्फ़ अपने बाल बच्चे और भेड़ बकरियाँ और गाय — बैल जशन के 'इलाक़े में छोड़ गए। ");
INSERT INTO urd_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","और उसके साथ रथ और सवार भी गए, और एक बड़ा क़ाफिला उसके साथ था। ");
INSERT INTO urd_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","और वह अतद के खलिहान पर जो यरदन के पार है पहुंचे, और वहाँ उन्होंने बुलन्द और दिलसोज़ आवाज़ से नौहा किया; और यूसुफ़ ने अपने बाप के लिए सात दिन तक मातम कराया। ");
INSERT INTO urd_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","और जब उस मुल्क के बाशिन्दों या'नी कना'नियों ने अतद में खलिहान पर इस तरह का मातम देखा, तो कहने लगे, “मिस्रियों का यह बड़ा दर्दनाक मातम है।” इसलिए वह जगह अबील मिस्रयीम कहलाई, और वह यरदन के पार है। ");
INSERT INTO urd_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","और या'क़ूब के बेटों ने जैसा उसने उनको हुक्म किया था, वैसा ही उसके लिए किया। ");
INSERT INTO urd_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","क्यूँकि उन्होंने उसे मुल्क — ए — कना'न में ले जाकर ममरे के सामने मकफ़ीला के खेत के मग़ारे में, जिसे अब्रहाम ने 'इफ़रोन हित्ती से खरीदकर क़ब्रिस्तान के लिए अपनी मिल्कियत बना लिया था दफ़न किया। ");
INSERT INTO urd_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","और यूसुफ़ अपने बाप को दफ़्न करके अपने भाइयों, और उनके साथ जोउसके बाप को दफ़्न करने के लिए उसके साथ गए थे, मिस्र को लौटा। ");
INSERT INTO urd_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","और यूसुफ़ के भाई यह देख कर कि उनका बाप मर गया कहने लगे, कि यूसुफ़ शायद हम से दुश्मनी करे, और सारी बुराई का जो हम ने उससे की है पूरा बदला ले। ");
INSERT INTO urd_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","तब उन्होंने यूसुफ़ को यह कहला भेजा, “तेरे बाप ने अपने मरने से आगे ये हुक्म किया था, ");
INSERT INTO urd_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","'तुम यूसुफ़ से कहना कि अपने भाइयों की ख़ता और उनका गुनाह अब बख़्श दे, क्यूँकि उन्होंने तुझ से बुराई की; इसलिए अब तू अपने बाप के ख़ुदा के बन्दों की ख़ता बख़्श दे'।” और यूसुफ़ उनकी यह बातें सुन कर रोया। ");
INSERT INTO urd_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","और उसके भाइयों ने ख़ुद भी उसके सामने जाकर अपने सिर टेक दिए और कहा, “देख! हम तेरे ख़ादिम हैं।” ");
INSERT INTO urd_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","यूसुफ़ ने उनसे कहा, “मत डरो! क्या मैं ख़ुदा की जगह पर हूँ? ");
INSERT INTO urd_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","तुम ने तो मुझ से बुराई करने का इरादा किया था, लेकिन ख़ुदा ने उसी से नेकी का क़स्द किया, ताकि बहुत से लोगों की जान बचाए चुनाँचे आज के दिन ऐसा ही हो रहा है। ");
INSERT INTO urd_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","इसलिए तुम मत डरो, मैं तुम्हारी और तुम्हारे बाल बच्चों की परवरिश करता रहूँगा।” इस तरह उसने अपनी मुलायम बातों से उनको तसल्ली दी। ");
INSERT INTO urd_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","और यूसुफ़ और उसके बाप के घर के लोग मिस्र में रहे, और यूसुफ़ एक सौ दस साल तक ज़िन्दा रहा। ");
INSERT INTO urd_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","और यूसुफ़ ने इफ़्राईम की औलाद तीसरी नसल तक देखी, और मनस्सी के बेटे मकीर की औलाद को भी यूसुफ़ ने अपने घुटनों पर खिलाया। ");
INSERT INTO urd_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","और यूसुफ़ ने अपने भाइयों से कहा, “मैं मरता हूँ; और ख़ुदा यक़ीनन तुम को याद करेगा, और तुम को इस मुल्क से निकाल कर उस मुल्क में पहुँचाएगा जिसके देने की क़सम उसने अब्रहाम और इस्हाक़ और या'क़ूब से खाई थी।” ");
INSERT INTO urd_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","और यूसुफ़ ने बनी — इस्राईल से क़सम लेकर कहा, ख़ुदा यक़ीनन तुम को याद करेगा, इसलिए तुम ज़रूर ही मेरी हडिड्डयों को यहाँ से ले जाना। ");
INSERT INTO urd_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","और यूसुफ़ ने एक सौ दस साल का होकर वफ़ात पाई; और उन्होंने उसकी लाश में ख़ुशबू भरी और उसे मिस्र ही में ताबूत में रख्खा।");
INSERT INTO urd_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","इस्राईल के बेटों के नाम जो अपने — अपने घराने को लेकर या'क़ूब के साथ मिस्र में आए यह हैं: ");
INSERT INTO urd_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रूबिन, शमौन, लावी, यहूदाह, ");
INSERT INTO urd_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इश्कार, ज़बूलून, बिनयमीन, ");
INSERT INTO urd_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान, नफ़्ताली, जद्द, आशर ");
INSERT INTO urd_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","और सब जानें जो या'क़ूब के सुल्ब से पैदा हुई सत्तर थीं, और यूसुफ़ तो मिस्र में पहले ही से था। ");
INSERT INTO urd_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","और यूसुफ़ और उसके सब भाई और उस नसल के सब लोग मर मिटे। ");
INSERT INTO urd_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","और इस्राईल की औलाद क़ामयाब और ज़्यादा ता'दाद और फ़िरावान और बहुत ताक़तवर हो गई और वह मुल्क उनसे भर गया। ");
INSERT INTO urd_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","तब मिस्र में एक नया बादशाह हुआ जो यूसुफ़ को नहीं जानता था। ");
INSERT INTO urd_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","और उसने अपनी क़ौम के लोगों से कहा, “देखो इस्राईली हम से ज़्यादा और ताक़तवर हो गए हैं। ");
INSERT INTO urd_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","इसलिए आओ, हम उनके साथ हिकमत से पेश आएँ, ऐसा न हो कि जब वह और ज़्यादा हो जाएँ और उस वक़्त जंग छिड़ जाए तो वह हमारे दुश्मनों से मिल कर हम से लड़ें और मुल्क से निकल जाएँ।” ");
INSERT INTO urd_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","इसलिए उन्होंने उन पर बेगार लेने वाले मुक़र्रर किए जो उनसे सख़्त काम लेकर उनको सताएँ। तब उन्होंने फ़िर'औन के लिए ज़ख़ीरे के शहर पितोम और रा'मसीस बनाए। ");
INSERT INTO urd_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","तब उन्होंने जितना उनको सताया वह उतना ही ज़्यादा बढ़ते और फैलते गए, इसलिए वह लोग बनी — इस्राईल की तरफ़ से फ़िक्रमन्द ही गए। ");
INSERT INTO urd_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","और मिस्रियों ने बनी — इस्राईल पर तशद्दुद कर — कर के उनसे काम कराया। ");
INSERT INTO urd_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","और उन्होंने उनसे सख़्त मेहनत से गारा और ईंट बनवा — बनवाकर और खेत में हर क़िस्म की ख़िदमत ले — लेकर उनकी ज़िन्दगी कड़वी की; उनकी सब ख़िदमतें जो वह उनसे कराते थे दुख की थीं। ");
INSERT INTO urd_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","तब मिस्र के बादशाह ने'इब्रानी दाइयों से जिनमें एक का नाम सिफ़रा और दूसरी का नाम फू'आ था बातें की, ");
INSERT INTO urd_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","और कहा, “जब 'इब्रानी 'औरतों के तुम बच्चा जनाओ और उनको पत्थर की बैठकों पर बैठी देखो, तो अगर बेटा हो तो उसे मार डालना, और अगर बेटी हो तो वह जीती रहे।” ");
INSERT INTO urd_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","लेकिन वह दाइयाँ ख़ुदा से डरती थीं, तब उन्होंने मिस्र के बादशाह का हुक्म न माना बल्कि लड़कों को ज़िन्दा छोड़ देती थीं। ");
INSERT INTO urd_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","फिर मिस्र के बादशाह ने दाइयों को बुलवा कर उनसे कहा, “तुम ने ऐसा क्यूँ किया कि लड़कों को ज़िन्दा रहने दिया?” ");
INSERT INTO urd_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","दाइयों ने फ़िर'औन से कहा, “'इब्रानी 'औरतें मिस्री 'औरतों की तरह नहीं हैं। वह ऐसी मज़बूत होती हैं कि दाइयों के पहुँचने से पहले ही जनकर फ़ारिग़ हो जाती हैं।” ");
INSERT INTO urd_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","तब ख़ुदा ने दाइयों का भला किया और लोग बढ़े और बहुत ज़बरदस्त हो गए। ");
INSERT INTO urd_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","और इस वजह से कि दाइयाँ ख़ुदा से डरी, उसने उनके घर आबाद कर दिए। ");
INSERT INTO urd_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","और फ़िर'औन ने अपनी क़ौम के सब लोगों को ताकीदन कहा, “उनमें जो बेटा पैदा हो तुम उसे दरिया में डाल देना, और जो बेटी हो उसे ज़िन्दा छोड़ना।” ");
INSERT INTO urd_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","और लावी के घराने के एक शख़्स ने जाकर लावी की नसल की एक 'औरत से ब्याह किया। ");
INSERT INTO urd_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","वह 'औरत हामिला हुई और उसके बेटा हुआ, और उस ने यह देखकर कि बच्चा ख़ूबसूरत है तीन महीने तक उसे छिपा कर रखा। ");
INSERT INTO urd_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","और जब उसे और ज़्यादा छिपा न सकी तो उसने सरकंडों का एक टोकरा लिया, और उस पर चिकनी मिट्टी और राल लगा कर लड़के को उसमें रख्खा, और उसे दरिया के किनारे झाऊ में छोड़ आई। ");
INSERT INTO urd_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","और उसकी बहन दूर खड़ी रही ताकि देखे कि उसके साथ क्या होता है। ");
INSERT INTO urd_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","और फ़िर'औन की बेटी दरिया पर ग़ुस्ल करने आई और उसकी सहेलियाँ दरिया के किनारे — किनारे टहलने लगीं। तब उसने झाऊ में वह टोकरा देख कर अपनी सहेली की भेजा कि उसे उठा लाए। ");
INSERT INTO urd_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","जब उसने उसे खोला तो लड़के को देखा, और वह बच्चा रो रहा था। उसे उस पर रहम आया और कहने लगी, “यह किसी 'इब्रानी का बच्चा है।” ");
INSERT INTO urd_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","तब उसकी बहन ने फ़िर'औन की बेटी से कहा, “क्या मैं जा कर 'इब्रानी 'औरतों में से एक दाई तेरे पास बुला लाऊँ, जो तेरे लिए इस बच्चे को दूध पिलाया करे?” ");
INSERT INTO urd_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","फ़िर'औन की बेटी ने उसे कहा, “जा!” वह लड़की जाकर उस बच्चे की माँ को बुला लाई। ");
INSERT INTO urd_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","फ़िर'औन की बेटी ने उसे कहा, “तू इस बच्चे को ले जाकर मेरे लिए दूध पिला, मैं तुझे तेरी मज़दूरी दिया करूँगी।” वह 'औरत उस बच्चे को ले जाकर दूध पिलाने लगी। ");
INSERT INTO urd_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","जब बच्चा कुछ बड़ा हुआ तो वह उसे फ़िर'औन की बेटी के पास ले गई और वह उसका बेटा ठहरा और उसने उसका नाम मूसा यह कह कर रख्खा, “मैंने उसे पानी से निकाला।” ");
INSERT INTO urd_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","इतने में जब मूसा बड़ा हुआ तो बाहर अपने भाइयों के पास गया। और उनकी मशक़्क़तों पर उसकी नज़र पड़ी और उसने देखा कि एक मिस्री उसके एक 'इब्रानी भाई को मार रहा है। ");
INSERT INTO urd_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","फिर उसने इधर उधर निगाह की और जब देखा कि वहाँ कोई दूसरा आदमी नहीं है, तो उस मिस्री को जान से मार कर उसे रेत में छिपा दिया। ");
INSERT INTO urd_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","फिर दूसरे दिन वह बाहर गया और देखा कि दो 'इब्रानी आपस में मार पीट कर रहे हैं। तब उसने उसे जिसका कु़सूर था कहा, कि “तू अपने साथी को क्यूँ मारता है?” ");
INSERT INTO urd_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","उसने कहा, “तुझे किसने हम पर हाकिम या मुन्सिफ़ मुक़र्रर किया? क्या जिस तरह तूने उस मिस्री को मार डाला, मुझे भी मार डालना चाहता है?” तब मूसा यह सोच कर डरा, “बिला शक यह राज़ खुल गया।” ");
INSERT INTO urd_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","जब फ़िर'औन ने यह सुना तो चाहा कि मूसा को क़त्ल करे। पर मूसा फ़िर'औन के सामने से भाग कर मुल्क — ए — मिदियान में जा बसा। वहाँ वह एक कुएँ के नज़दीक बैठा था। ");
INSERT INTO urd_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","और मिदियान के काहिन की सात बेटियाँ थी। वह आईं और पानी भर — भर कर कठरों में डालने लगीं ताकि अपने बाप की भेड़ — बकरियों को पिलाएँ। ");
INSERT INTO urd_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","और गड़रिये आकर उनको भगाने लगे, लेकिन मूसा खड़ा हो गया और उसने उनकी मदद की और उनकी भेड़ — बकरियों को पानी पिलाया। ");
INSERT INTO urd_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","और जब वह अपने बाप र'ऊएल के पास लौटीं तो उसने पूछा, “आज तुम इस क़दर जल्द कैसे आ गई?” ");
INSERT INTO urd_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","उन्होंने कहा, “'एक मिस्री ने हम को गड़रियों के हाथ से बचाया, और हमारे बदले पानी भर — भर कर भेड़ बकरियों को पिलाया।” ");
INSERT INTO urd_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","उसने अपनी बेटियों से कहा, “वह आदमी कहाँ है? तुम उसे क्यूँ छोड़ आई? उसे बुला लाओ कि रोटी खाए।” ");
INSERT INTO urd_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","और मूसा उस शख़्स के साथ रहने को राज़ी हो गया। तब उसने अपनी बेटी सफ़्फूरा मूसा को ब्याह दी। ");
INSERT INTO urd_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","और उसके एक बेटा हुआ, और मूसा ने उसका नाम जैरसोम यह कहकर रख्खा, “मैं अजनबी मुल्क में मुसाफ़िर हूँ।” ");
INSERT INTO urd_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","और एक मुद्दत के बाद यूँ हुआ कि मिस्र का बादशाह मर गया। और बनी — इस्राईल अपनी ग़ुलामी की वजह से आह भरने लगे और रोए; और उनका रोना जो उनकी ग़ुलामी की वजह था ख़ुदा तक पहुँचा। ");
INSERT INTO urd_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","और ख़ुदा ने उनका कराहना सुना, और ख़ुदा ने अपने 'अहद को जो अब्रहाम और इस्हाक़ और या'क़ूब के साथ था याद किया। ");
INSERT INTO urd_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","और ख़ुदा ने बनी — इस्राईल पर नज़र की और उनके हाल को मा'लूम किया। ");
INSERT INTO urd_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","और मूसा के ससुर यित्रो कि जो मिदियान का काहिन था, भेड़ — बकारियाँ चराता था। और वह भेड़ — बकरियों को हंकाता हुआ उनको वीराने की परली तरफ़ से ख़ुदा के पहाड़ होरिब के नज़दीक ले आया। ");
INSERT INTO urd_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","और ख़ुदावन्द का फ़रिश्ता एक झाड़ी में से आग के शो'ले में उस पर ज़ाहिर हुआ। उसने निगाह की और क्या देखता है, कि एक झाड़ी में आग लगी हुई है पर वह झाड़ी भसम नहीं होती। ");
INSERT INTO urd_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","तब मूसा ने कहा, “मैं अब ज़रा उधर कतरा कर इस बड़े मन्ज़र को देखूँ कि यह झाड़ी क्यूँ नहीं जल जाती।” ");
INSERT INTO urd_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","जब ख़ुदावन्द ने देखा कि वह देखने को कतरा कर आ रहा है, तो ख़ुदा ने उसे झाड़ी में से पुकारा और कहा, ऐ मूसा! ऐ मूसा! “उसने कहा, मैं हाज़िर हूँ।” ");
INSERT INTO urd_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","तब उसने कहा, “इधर पास मत आ। अपने पाँव से जूता उतार, क्यूँकि जिस जगह तू खड़ा है वह पाक ज़मीन है।” ");
INSERT INTO urd_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","फिर उसने कहा कि मैं तेरे बाप का ख़ुदा, या'नी अब्रहाम का ख़ुदा और इस्हाक़ का ख़ुदा और या'क़ूब का ख़ुदा हूँ। मूसा ने अपना मुँह छिपाया क्यूँकि वह ख़ुदा पर नज़र करने से डरता था। ");
INSERT INTO urd_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","और ख़ुदावन्द ने कहा, “मैंने अपने लोगों की तक्लीफ़ जो मिस्र में हैं ख़ूब देखी, और उनकी फ़रियाद जो बेगार लेने वालों की वजह से है सुनी, और मैं उनके दुखों को जानता हूँ। ");
INSERT INTO urd_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","और मैं उतरा हूँ कि उनको मिस्रियों के हाथ से छुड़ाऊँ, और उस मुल्क से निकाल कर उनको एक अच्छे और बड़े मुल्क में जहाँ दूध और शहद बहता है या'नी कना'नियों और हित्तियों और अमोरियों और फ़रिज़्ज़ीयों और हव्वियों और यबूसियों के मुल्क में पहुँचाऊँ। ");
INSERT INTO urd_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","देख बनी — इस्राईल की फ़रियाद मुझ तक पहुँची है, और मैंने वह जु़ल्म भी जो मिस्री उन पर करते हैं देखा है। ");
INSERT INTO urd_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","इसलिए अब आ मैं तुझे फ़िर'औन के पास भेजता हूँ कि तू मेरी क़ौम बनी — इस्राईल को मिस्र से निकाल लाए।” ");
INSERT INTO urd_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","मूसा ने ख़ुदा से कहा, “मैं कौन हूँ जो फ़िर'औन के पास जाऊँ और बनी — इस्राईल को मिस्र से निकाल लाऊँ?” ");
INSERT INTO urd_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","उसने कहा, “मैं ज़रूर तेरे साथ रहूँगा और इसका कि मैंने तुझे भेजा है तेरे लिए यह निशान होगा, कि जब तू उन लोगों को मिस्र से निकाल लाएगा तो तुम इस पहाड़ पर ख़ुदा की इबादत करोगे।” ");
INSERT INTO urd_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","तब मूसा ने ख़ुदा से कहा, “जब मैं बनी — इस्राईल के पास जाकर उनको कहूँ कि तुम्हारे बाप — दादा के ख़ुदा ने मुझे तुम्हारे पास भेजा है, और वह मुझे कहें कि उसका नाम क्या है? तो मैं उनको क्या बताऊँ?” ");
INSERT INTO urd_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ख़ुदा ने मूसा से कहा, “मैं जो हूँ सो मैं हूँ। इसलिए तू बनी — इस्राईल से यूँ कहना, 'मैं जो हूँ ने मुझे तुम्हारे पास भेजा है'।” ");
INSERT INTO urd_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","फिर ख़ुदा ने मूसा से यह भी कहा कि तू बनी — इस्राईल से यूँ कहना कि ख़ुदावन्द तुम्हारे बाप — दादा के ख़ुदा, अब्रहाम के ख़ुदा और इस्हाक़ के ख़ुदा और या'क़ूब के ख़ुदा ने मुझे तुम्हारे पास भेजा है। हमेशा तक मेरा यही नाम है और सब नसलों में इसी से मेरा ज़िक्र होगा। ");
INSERT INTO urd_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","जा कर इस्राईली बुजु़र्गों को एक जगह जमा' कर और उनको कह, 'ख़ुदावन्द तुम्हारे बाप — दादा के ख़ुदा, अब्रहाम और इस्हाक़ और या'क़ूब के ख़ुदा ने मुझे दिखाई देकर यह कहा है कि मैंने तुम को भी, और जो कुछ बरताव तुम्हारे साथ मिस्र में किया जा रहा है उसे भी ख़ूब देखा है। ");
INSERT INTO urd_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","और मैंने कहा है कि मैं तुम को मिस्र के दुख में से निकाल कर कना'नियों और हित्तियों और अमोरियोंऔर फ़रिज़्ज़ियों और हव्वियों और यबूसियों के मुल्क में ले चलूँगा, जहाँ दूध और शहद बहता है। ");
INSERT INTO urd_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","और वह तेरी बात मानेंगे और तू इस्राईली बुज़ुर्गों को साथ लेकर मिस्र के बादशाह के पास जाना और उससे कहना कि 'ख़ुदावन्द इब्रानियों के ख़ुदा की हम से मुलाक़ात हुई। अब तू हम को तीन दिन की मंज़िल तक वीराने में जाने दे ताकि हम ख़ुदावन्द अपने ख़ुदा के लिए क़ुर्बानी करें। ");
INSERT INTO urd_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","और मैं जानता हूँ कि मिस्र का बादशाह तुम को न यूँ जाने देगा, न बड़े ज़ोर से। ");
INSERT INTO urd_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","तब मैं अपना हाथ बढ़ाऊँगा और मिस्र को उन सब 'अजायब से जो मैं उसमें करूँगा, मुसीबत में डाल दूँगा। इसके बाद वह तुम को जाने देगा। ");
INSERT INTO urd_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","और मैं उन लोगों को मिस्रियों की नज़र में इज़्ज़त बख़्शूँगा और यूँ होगा कि जब तुम निकलोगे तो ख़ाली हाथ न निकलोगे। ");
INSERT INTO urd_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","बल्कि तुम्हारी एक — एक 'औरत अपनी अपनी पड़ौसन से और अपने — अपने घर की मेहमान से सोने चाँदी के ज़ेवर और लिबास माँग लेगी। इनको तुम अपने बेटों और बेटियों को पहनाओगे और मिस्रियों को लूट लोगे। ");
INSERT INTO urd_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","तब मूसा ने जवाब दिया, “लेकिन वह तो मेरा यक़ीन ही नहीं करेंगे न मेरी बात सुनेंगे। वह कहेंगे, 'ख़ुदावन्द तुझे दिखाई नहीं दिया'।” ");
INSERT INTO urd_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","और ख़ुदावन्द ने मूसा से कहा कि यह तेरे हाथ में क्या है? उसने कहा, “लाठी।” ");
INSERT INTO urd_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","फिर उसने कहा कि उसे ज़मीन पर डाल दे। उसने उसे ज़मीन पर डाला और वह साँप बन गई, और मूसा उसके सामने से भागा। ");
INSERT INTO urd_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","तब ख़ुदावन्द ने मूसा से कहा, हाथ बढ़ा कर उसकी दुम पकड़ ले। उसने हाथ बढ़ाया और उसे पकड़ लिया, वह उसके हाथ में लाठी बन गया। ");
INSERT INTO urd_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ताकि वह यक़ीन करें कि ख़ुदावन्द उनके बाप — दादा का ख़ुदा, अब्रहाम का ख़ुदा, इस्हाक़ का ख़ुदा और या'क़ूब का ख़ुदा तुझ को दिखाई दिया। ");
INSERT INTO urd_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","फिर ख़ुदावन्द ने उसे यह भी कहा, कि तू अपना हाथ अपने सीने पर रख कर ढाँक ले। उसने अपना हाथ अपने सीने पर रख कर उसे ढाँक लिया, और जब उसने उसे निकाल कर देखा तो उसका हाथ कोढ़ से बर्फ़ की तरह सफ़ेद था। ");
INSERT INTO urd_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","उसने कहा कि तू अपना हाथ फिर अपने सीने पर रख कर ढाँक ले। उसने फिर उसे सीने पर रख कर ढाँक लिया। जब उसने उसे सीने पर से बाहर निकाल कर देखा तो वह फिर उसके बाकी जिस्म की तरह हो गया। ");
INSERT INTO urd_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","और यूँ होगा कि अगर वह तेरा यक़ीन न करें और पहले निशान और मोअजिज़े को भी न मानें तो वह दूसरे निशान और मोअजिज़े की वजह से यक़ीन करेंगे। ");
INSERT INTO urd_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","और अगर वह इन दोनों निशान और मुअजिज़ों की वजह से भी यक़ीन न करें और तेरी बात न सुनें, तो तू दरिया-ए-नील से पानी लेकर ख़ुश्क ज़मीन पर छिड़क देना और वह पानी जो तू दरिया से लेगा ख़ुश्क ज़मीन पर ख़ून हो जाएगा। ");
INSERT INTO urd_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","तब मूसा ने ख़ुदावन्द से कहा, “ऐ ख़ुदावन्द! मैं फ़सीह नहीं, न तो पहले ही था और न जब से तूने अपने बन्दे से कलाम किया बल्कि रुक — रुक कर बोलता हूँ और मेरी ज़बान कुन्दहै।” ");
INSERT INTO urd_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","तब ख़ुदावन्द ने उसे कहा कि आदमी का मुँह किसने बनाया है? और कौन गूँगा या बहरा या बीना या अन्धा करता है? क्या मैं ही जो ख़ुदावन्द हूँ यह नहीं करता? ");
INSERT INTO urd_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","इसलिए अब तू जा और मैं तेरी ज़बान का ज़िम्मा लेता हूँ और तुझे सिखाता रहूँगा कि तू क्या — क्या कहे। ");
INSERT INTO urd_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","तब उसने कहा कि ऐ ख़ुदावन्द! मैं तेरी मिन्नत करता हूँ, किसी और के हाथ से जिसे तू चाहे यह पैग़ाम भेज। ");
INSERT INTO urd_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","तब ख़ुदावन्द का क़हर मूसा पर भड़का और उसने कहा, क्या लावियों में से हारून तेरा भाई नहीं है? मैं जानता हूँ कि वह फ़सीह है और वह तेरी मुलाक़ात को आ भी रहा है, और तुझे देख कर दिल में खु़श होगा। ");
INSERT INTO urd_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","इसलिए तू उसे सब कुछ बताना और यह सब बातें उसे सिखाना और मैं तेरी और उसकी ज़बान का ज़िम्मा लेता हूँ, और तुम को सिखाता रहूँगा कि तुम क्या — क्या करो। ");
INSERT INTO urd_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","और वह तेरी तरफ़ से लोगों से बातें करेगा और वह तेरा मुँह बनेगा और तू उसके लिए जैसे ख़ुदा होगा। ");
INSERT INTO urd_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","और तू इस लाठी को अपने हाथ में लिए जा और इसी से यह निशान और मो'मुअजिज़ों को दिखाना। ");
INSERT INTO urd_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","तब मूसा लौट कर अपने ससुर यित्रो के पास गया और उसे कहा, “मुझे ज़रा इजाज़त दे कि अपने भाइयों के पास जो मिस्र में हैं, जाऊँ औरदेखूँ कि वह अब तक ज़िन्दा हैं कि नहीं।” यित्रो ने मूसा से कहा, कि सलामत जा। ");
INSERT INTO urd_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","और ख़ुदावन्द ने मिदियान में मूसा से कहा, कि “मिस्र को लौट जा, क्यूँकि वह सब जो तेरी जान के ख़्वाहाँ थे मर गए।” ");
INSERT INTO urd_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","तब मूसा अपनी बीवी और अपने बेटों को लेकर और उनको एक गधे पर चढ़ा कर मिस्र को लौटा, और मूसा ने ख़ुदा की लाठी अपने हाथ में ले ली। ");
INSERT INTO urd_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","और ख़ुदावन्द ने मूसा से कहा, कि “जब तू मिस्र में पहुँचे तो देख वह सब करामात जो मैंने तेरे हाथ में रख्खी हैं फ़िर'औन के आगे दिखाना, लेकिन मैं उसके दिल को सख़्त करूँगा, और वह उन लोगों को जाने नहीं देगा। ");
INSERT INTO urd_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","तू फ़िर'औन से कहना, कि 'ख़ुदावन्द यूँ फ़रमाता है, कि इस्राईल मेरा बेटा बल्कि मेरा पहलौठा है। ");
INSERT INTO urd_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","और मैं तुझे कह चुका हूँ कि मेरे बेटे को जाने दे ताकि वह मेरी इबादत करे, और तूने अब तक उसे जाने देने से इन्कार किया है; और देख मैं तेरे बेटे को बल्कि तेरे पहलौटे को मार डालूँगा'।” ");
INSERT INTO urd_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","और रास्ते में मंज़िल पर ख़ुदावन्द उसे मिला और चाहा कि उसे मार डाले। ");
INSERT INTO urd_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","तब सफ़्फूरा ने चक़मक़ का एक पत्थर लेकर अपने बेटे की खलड़ी काट डाली और उसे मूसा के पाँव पर फेंक कर कहा, “तू बेशक मेरे लिए ख़ूनी दूल्हा ठहरा।” ");
INSERT INTO urd_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","तब उसने उसे छोड़ दिया। लेकिन उसने कहा, कि “ख़तने की वजह से तू ख़ूनी दूल्हा है।” ");
INSERT INTO urd_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","और ख़ुदावन्द ने हारून से कहा, कि “वीराने में जा कर मूसा से मुलाक़ात कर।” वह गया और ख़ुदा के पहाड़ पर उससे मिला और उसे बोसा दिया। ");
INSERT INTO urd_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","और मूसा ने हारून को बताया, कि ख़ुदा ने क्या — क्या बातें कह कर उसे भेजा और कौन — कौन से निशान और मुअजिज़े दिखाने का उसे हुक्म दिया है। ");
INSERT INTO urd_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","तब मूसा और हारून ने जाकर बनी — इस्राईल के सब बुज़ुर्गों को एक जगह जमा' किया। ");
INSERT INTO urd_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","और हारून ने सब बातें जो ख़ुदावन्द ने मूसा से कहीं थी उनको बताई और लोगों के सामने निशान और मो'जिज़े किए। ");
INSERT INTO urd_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","तब लोगों ने उनका यक़ीन किया और यह सुन कर कि ख़ुदावन्द ने बनी — इस्राईल की ख़बर ली और उनके दुखों पर नज़र की, उन्होंने अपने सिर झुका कर सिज्दा किया। ");
INSERT INTO urd_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","इसके बाद मूसा और हारून ने जाकर फ़िर'औन से कहा कि, “ख़ुदावन्द इस्राईल का ख़ुदा यूँ फ़रमाता है, कि 'मेरे लोगों को जाने दे ताकि वह वीराने में मेरे लिए 'ईद करें'।” ");
INSERT INTO urd_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","फ़िर'औन ने कहा, कि “ख़ुदावन्द कौन है कि मैं उसकी बात को मान कर बनी — इस्राईल को जानें दूँ? मैं ख़ुदावन्द को नहीं जानता और मैं बनी — इस्राईल को जाने भी नहीं दूँगा।” ");
INSERT INTO urd_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","तब उन्होंने कहा, कि “'इब्रानियों का ख़ुदा हम से मिला है; इसलिए हम को इजाज़त दे कि हम तीन दिन की मन्ज़िल वीराने में जा कर ख़ुदावन्द अपने ख़ुदा के लिए क़ुर्बानी करें, ऐसा न हो कि वह हम पर वबा भेज दे या हम को तलवार से मरवा दे।” ");
INSERT INTO urd_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","तब मिस्र के बादशाह ने उनको कहा, कि “ऐ मूसा और ऐ हारून! तुम क्यूँ इन लोगों को इनके काम से छुड़वाते हो? तुम जाकर अपने — अपने बोझ को उठाओ।” ");
INSERT INTO urd_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","और फ़िर'औन ने यह भी कहा, कि “देखो, यह लोग इस मुल्क में बहुत हो गए हैं, और तुम इनको इनके काम से बिठाते हो।” ");
INSERT INTO urd_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","और उसी दिन फ़िर'औन ने बेगार लेने वालों और सरदारों को जो लोगों पर थे हुक्म किया, ");
INSERT INTO urd_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“अब आगे को तुम इन लोगों को ईटें बनाने के लिए भुस न देना जैसे अब तक देते रहे, वह ख़ुद ही जाकर अपने लिए भुस बटोरें। ");
INSERT INTO urd_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","और इनसे उतनी ही ईटें बनवाना जितनी वह अब तक बनाते आए हैं; तुम उसमें से कुछ न घटाना क्यूँकि वह काहिल हो गए हैं, इसीलिए चिल्ला — चिल्ला कर कहते हैं, 'हम को जाने दो कि हम अपने ख़ुदा के लिए क़ुर्बानी करें। ");
INSERT INTO urd_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","इसलिए इनसे ज़्यादा सख़्त मेहनत ली जाए, ताकि काम में मशगू़ल रहें और झूठी बातों से दिल न लगाएँ।” ");
INSERT INTO urd_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","तब बेगार लेने वालों और सरदारों ने जो लोगों पर थे जाकर उनसे कहा, कि फ़िर'औन कहता है, कि 'मैं तुम को भुस नहीं देने का। ");
INSERT INTO urd_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","तुम ख़ुद ही जाओ और जहाँ कहीं तुम को भुस मिले वहाँ से लाओ, क्यूँकि तुम्हारा काम कुछ भी घटाया नहीं जाएगा'। ");
INSERT INTO urd_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","चुनाँचे वह लोग तमाम मुल्क — ए — मिस्र में मारे — मारे फिरने लगे कि भुस के 'बदले खूँटी जमा' करें। ");
INSERT INTO urd_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","और बेगार लेने वाले यह कह कर जल्दी कराते थे कि तुम अपना रोज़ का काम जैसे भुस पा कर करते थे अब भी करो। ");
INSERT INTO urd_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","और बनी — इस्राईल में से जो — जो फ़िर'औन के बेगार लेने वालों की तरफ़ से इन लोगों पर सरदार मुक़र्रर हुए थे, उन पर मार पड़ी और उनसे पूछा गया, कि “क्या वजह है कि तुम ने पहले की तरह आज और कल पूरी — पूरी ईंटें नहीं बनवाई?” ");
INSERT INTO urd_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","तब उन सरदारों ने जो बनी — इस्राईल में से मुक़र्रर हुए थे फ़िर'औन के आगे जा कर फ़रियाद की और कहा कि तू अपने ख़ादिमों से ऐसा सुलूक क्यूँ करता है? ");
INSERT INTO urd_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","तेरे ख़ादिमों को भुस तो दिया नहीं जाता और वह हम से कहते रहते हैं ईंटें बनाओ', और देख तेरे ख़ादिम मार भी खाते हैं पर कु़सूर तेरे लोगों का है। ");
INSERT INTO urd_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","उसने कहा, “तुम सब काहिल हो काहिल, इसी लिए तुम कहते हो कि हम को जाने दे कि ख़ुदावन्द के लिए क़ुर्बानी करें। ");
INSERT INTO urd_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","इसलिए अब तुम जाओ और काम करो, क्यूँकि भुस तुम को नहीं मिलेगा और ईटों को तुम्हें उसी हिसाब से देना पड़ेगा।” ");
INSERT INTO urd_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","जब बनी — इस्राईल के सरदारों से यह कहा गया, कि तुम अपनी ईटों और रोज़ मर्रा के काम में कुछ भी कमी नहीं करने पाओगे तो वह जान गए कि वह कैसे वबाल में फैसे हुए हैं। ");
INSERT INTO urd_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","जब वह फ़िर'औन के पास से निकले आ रहे थे तो उनको मूसा और हारून मुलाक़ात के लिए रास्ते पर खड़े मिले। ");
INSERT INTO urd_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","तब उन्होंने उन से कहा, कि ख़ुदावन्द ही देखे और तुम्हारा इन्साफ़ करे, क्यूँकि तुम ने हम को फ़िर'औन और उसके ख़ादिमों की निगाह में ऐसा घिनौना किया है, कि हमारे क़त्ल के लिए उनके हाथ में तलवार दे दी है। ");
INSERT INTO urd_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","तब मूसा ख़ुदावन्द के पास लौट कर गया और कहा, कि ऐ ख़ुदावन्द! तूने इन लोगों को क्यूँ दुख में डाला और मुझे क्यूँ भेजा? ");
INSERT INTO urd_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","क्यूँकि जब से मैं फ़िर'औन के पास तेरे नाम से बातें करने गया, उसने इन लोगों से बुराई ही बुराई की और तूने अपने लोगों को ज़रा भी रिहाई न बख़्शी। ");
INSERT INTO urd_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","तब ख़ुदावन्द ने मूसा से कहा, कि 'अब तू देखेगा कि मैं फ़िर'औन के साथ क्या करता हूँ, तब वह ताक़तवर हाथ की वजह से उनको जाने देगा और ताक़तवर हाथ ही की वजह से वह उनको अपने मुल्क से निकाल देगा। ");
INSERT INTO urd_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","फिर ख़ुदा ने मूसा से कहा, कि मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","और मैं अब्रहाम और इस्हाक़ और या'क़ूब को ख़ुदा — ए — क़ादिर — ए — मुतलक के तौर पर दिखाई दिया, लेकिन अपने यहोवा नाम से उन पर ज़ाहिर न हुआ। ");
INSERT INTO urd_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","और मैंने उनके साथ अपना 'अहद भी बाँधा है कि मुल्क — ए — कना'न जो उनकी मुसाफ़िरत का मुल्क था और जिसमें वह परदेसी थे उनको दूँगा। ");
INSERT INTO urd_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","और मैंने बनी — इस्राईल के कराहने को भी सुन कर, जिनको मिस्रियों ने ग़ुलामी में रख छोड़ा है, अपने उस 'अहद को याद किया है। ");
INSERT INTO urd_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","इसलिए तू बनी — इस्राईल से कह, कि 'मैं ख़ुदावन्द हूँ, और मैं तुम को मिस्रियों के बोझों के नीचे से निकाल लूँगा और मैं तुम को उनकी ग़ुलामी से आज़ाद करूँगा, और मैं अपना हाथ बढ़ा कर और उनको बड़ी — बड़ी सज़ाएँ देकर तुम को रिहाई दूँगा। ");
INSERT INTO urd_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","और मैं तुम को ले लूँगा कि मेरी क़ौम बन जाओ और मैं तुम्हारा ख़ुदा हूँगा, और तुम जान लोगे के मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ जो तुम्हें मिस्रियों के बोझों के नीचे से निकालता हूँ। ");
INSERT INTO urd_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","और जिस मुल्क को अब्रहाम और इस्हाक़ और या'क़ूब को देने की क़सम मैंने खाई थी उसमें तुम को पहुँचा कर उसे तुम्हारी मीरास कर दूँगा। ख़ुदावन्द मैं हूँ। ");
INSERT INTO urd_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","और मूसा ने बनी — इस्राईल को यह बातें सुना दीं, लेकिन उन्होंने दिल की कुढ़न और ग़ुलामी की सख़्ती की वजह से मूसा की बात न सुनी। ");
INSERT INTO urd_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","फिर ख़ुदावन्द ने मूसा को फ़रमाया, ");
INSERT INTO urd_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","कि जा कर मिस्र के बादशाह फ़िर'औन से कह कि बनी — इस्राईल को अपने मुल्क में से जाने दे। ");
INSERT INTO urd_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","मूसा ने ख़ुदावन्द से कहा, कि “देख, बनी — इस्राईल ने तो मेरी सुनी नहीं; तब मैं जो ना मख़्तून होंट रखता हूँ फ़िर'औन मेरी क्यूँ कर सुनेगा?” ");
INSERT INTO urd_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","तब ख़ुदावन्द ने मूसा और हारून को बनी — इस्राईल और मिस्र के बादशाह फ़िर'औन के हक़ में इस मज़मून का हुक्म दिया कि वह बनी — इस्राईल को मुल्क — ए — मिस्र से निकाल ले जाएँ। ");
INSERT INTO urd_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","उनके आबाई ख़ान्दानों के सरदार यह थे: रूबिन, जो इस्राईल का पहलौठा था, उसके बेटे: हनूक और फ़ल्लू और हसरोन और करमी थे; यह रूबिन के घराने थे। ");
INSERT INTO urd_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","बनी शमौन यह थे: यमूएल और यमीन और उहद और यकीन और सुहर और साऊल, जो एक कना'नी 'औरत से पैदा हुआ था; यह शमौन के घराने थे। ");
INSERT INTO urd_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","और बनी लावी जिनसे उनकी नसल चली उनके नाम यह हैं: जैरसोन और क़िहात और मिरारी; और लावी की उम्र एक सौ सैंतीस बरस की हुई। ");
INSERT INTO urd_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","बनी जैरसोन: लिबनी और सिम'ई थे; इन ही से इनके ख़ान्दान चले। ");
INSERT INTO urd_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","और बनी क़िहात: 'अमराम और इज़हार और हबरून और 'उज़्ज़ीएल थे; और क़िहात की उम्र एक सौ तैतीस बरस की हुई। ");
INSERT INTO urd_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","और बनी मिरारी: महली और मूर्शी थे। लावियों के घराने जिनसे उनकी नसल चली यही थे। ");
INSERT INTO urd_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","और 'अमराम ने अपने बाप की बहन यूकबिद से ब्याह किया, उस 'औरत के उससे हारून और मूसा पैदा हुए; और 'अमराम की उम्र एक सौ सैंतीस बरस की हुई। ");
INSERT INTO urd_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","बनी इज़हार: क़ोरह और नफ़ज और ज़िकरी थे। ");
INSERT INTO urd_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","और बनी उज़्ज़ीएल: मीसाएल और इलसफ़न और सितरी थे। ");
INSERT INTO urd_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","और हारून ने नहसोन की बहन 'अमीनदाब की बेटी इलिशीबा' से ब्याह किया; उससे नदब और अबीहू और इली'एलियाज़र और ऐतामर पैदा हुए। ");
INSERT INTO urd_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","और बनी क़ोरह: अस्सीर और इलाकना और अबियासफ़ थे, और यह कोरहियों के घराने थे। ");
INSERT INTO urd_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","और हारून के बेटे इली'एलियाज़र ने फूतिएल की बेटियों में से एक के साथ ब्याह किया, उससे फ़ीन्हास पैदा हुआ; लावियों के बाप — दादा के घरानों के सरदार जिनसे उनके ख़ान्दान चले यही थे। ");
INSERT INTO urd_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","यह वह हारून और मूसा हैं जिनको ख़ुदावन्द ने फ़रमाया: कि बनी — इस्राईल को उनके लश्कर के मुताबिक़ मुल्क — ए — मिस्र से निकाल ले जाओ। ");
INSERT INTO urd_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","यह वह हैं जिन्होंने मिस्र के बादशाह फ़िर'औन से कहा, कि हम बनी — इस्राईल को मिस्र से निकाल ले जाएँगे; यह वही मूसा और हारून हैं। ");
INSERT INTO urd_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","जब ख़ुदावन्द ने मुल्क — ए — मिस्र में मूसा से बातें कीं तो यूँ हुआ, ");
INSERT INTO urd_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","कि ख़ुदावन्द ने मूसा से कहा, कि मैं ख़ुदावन्द हूँ जो कुछ मैं तुझे कहूँ तू उसे मिस्र के बादशाह फ़िर'औन से कहना। ");
INSERT INTO urd_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","मूसा ने ख़ुदावन्द से कहा, कि देख, मेरे तो होटों का ख़तना नहीं हुआ। फ़िर'औन क्यूँ कर मेरी सुनेगा? ");
INSERT INTO urd_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","फिर ख़ुदावन्द ने मूसा से कहा, “देख, मैंने तुझे फ़िर'औन के लिए जैसे ख़ुदा ठहराया और तेरा भाई हारून पैग़म्बर होगा। ");
INSERT INTO urd_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","जो — जो हुक्म मैं तुझे दूँ तब तू कहना, और तेरा भाई हारून उसे फ़िर'औन से कहे कि वह बनी — इस्राईल को अपने मुल्क से जाने दे। ");
INSERT INTO urd_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","और मैं फ़िर'औन के दिल को सख़्त करूँगा और अपने निशान अजाईब मुल्क — ए — मिस्र में कसरत से दिखाऊँगा। ");
INSERT INTO urd_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","तो भी फ़िर'औन तुम्हारी न सुनेगा, तब मैं मिस्र को हाथ लगाऊँगा और उसे बड़ी — बड़ी सज़ाएँ देकर अपने लोगों, बनी — इस्राईल के लश्करों को मुल्क — ए — मिस्र से निकाल लाऊँगा। ");
INSERT INTO urd_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","और मैं जब मिस्र पर हाथ चलाऊँगा और बनी — इस्राईल को उनमें से निकाल लाऊँगा, तब मिस्री जानेंगे कि मैं ख़ुदावन्द हूँ।” ");
INSERT INTO urd_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","मूसा और हारून ने जैसा ख़ुदावन्द ने उनको हुक्म दिया वैसा ही किया। ");
INSERT INTO urd_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","और मूसा अस्सी बरस और हारून तिरासी बरस का था, जब वह फ़िर'औन से हम कलाम हुए। ");
INSERT INTO urd_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","और ख़ुदावन्द ने मूसा और हारून से कहा, ");
INSERT INTO urd_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“जब फ़िर'औन तुम को कहे, कि अपना मो'अजिज़ा दिखाओ, तो हारून से कहना, कि अपनी लाठी को लेकर फ़िर'औन के सामने डाल दे, ताकि वह साँप बन जाए'।” ");
INSERT INTO urd_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","और मूसा और हारून फ़िर'औन के पास गए और उन्होंने ख़ुदावन्द के हुक्म के मुताबिक़ किया; और हारून ने अपनी लाठी फ़िर'औन और उसके ख़ादिमों के सामने डाल दी और वह साँप बन गई। ");
INSERT INTO urd_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","तब फ़िर'औन ने भी 'अक़्लमन्दों और जादूगरों को बुलवाया, और मिस्र के जादूगरों ने भी अपने जादू से ऐसा ही किया। ");
INSERT INTO urd_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","क्यूँकि उन्होंने भी अपनी — अपनी लाठी सामने डाली और वह साँप बन गई, लेकिन हारून की लाठी उनकी लाठियों को निगल गई। ");
INSERT INTO urd_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","और फ़िर'औन का दिल सख़्त हो गया और जैसा ख़ुदावन्द ने कह दिया था उसने उनकी न सुनी। ");
INSERT INTO urd_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","तब ख़ुदावन्द ने मूसा से कहा, कि फ़िर'औन का दिल मुतास्सिब है, वह इन लोगों को जाने नहीं देता। ");
INSERT INTO urd_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","अब तू सुबह को फ़िर'औन के पास जा। वह दरिया पर जाएगा इसलिए तू दरिया के किनारे उसकी मुलाक़ात के लिए खड़ा रहना, और जो लाठी साँप बन गई थी उसे हाथ में ले लेना। ");
INSERT INTO urd_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","और उससे कहना, कि 'ख़ुदावन्द 'इब्रानियों के ख़ुदा ने मुझे तेरे पास यह कहने को भेजा है कि मेरे लोगों को जाने दे ताकि वह वीराने में मेरी इबादत करें; और अब तक तूने कुछ सुनी नहीं। ");
INSERT INTO urd_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","तब ख़ुदावन्द यूँ फ़रमाता है कि तू इसी से जान लेगा कि मैं ख़ुदावन्द हूँ, देख, मैं अपने हाथ की लाठी को दरिया के पानी पर मारूँगा और वह ख़ून हो जाएगा। ");
INSERT INTO urd_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","और जो मछलियाँ दरिया में हैं मर जाएँगी, और दरिया से झाग उठेगा और मिस्रियों को दरिया का पानी पीने से कराहियत होगी'। ");
INSERT INTO urd_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","और ख़ुदावन्द ने मूसा से कहा, कि हारून से कह, अपनी लाठी ले और मिस्र में जितना पानी है, या'नी दरियाओं और नहरों और झीलों और तालाबों पर, अपना हाथ बढ़ा ताकि वह ख़ून बन जाएँ; और सारे मुल्क — ए — मिस्र में पत्थर और लकड़ी के बर्तनों में भी ख़ून ही ख़ून होगा। ");
INSERT INTO urd_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","और मूसा और हारून ने ख़ुदावन्द के हुक्म के मुताबिक़ किया; उसने लाठी उठाकर उसे फ़िर'औन और उसके ख़ादिमों के सामने दरिया के पानी पर मारा, और दरिया का पानी सब ख़ून हो गया। ");
INSERT INTO urd_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","और दरिया की मछलियाँ मर गई, और दरिया से झाग उठने लगा और मिस्री दरिया का पानी पी न सके, और तमाम मुल्क — ए — मिस्र में ख़ून ही ख़ून हो गया। ");
INSERT INTO urd_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","तब मिस्र के जादूगरों ने भी अपने जादू से ऐसा ही किया, लेकिन फ़िर'औन का दिल सख़्त हो गया; और जैसा ख़ुदावन्द ने कह दिया था उसने उनकी न सुनी। ");
INSERT INTO urd_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","और फ़िर'औन लौट कर अपने घर चला गया, और उसके दिल पर कुछ असर न हुआ। ");
INSERT INTO urd_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","और सब मिस्रियों ने दरिया के आस पास पीने के पानी के लिए कुएँ खोद डाले, क्यूँकि वह दरिया का पानी नहीं पी सकते थे। ");
INSERT INTO urd_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","और जब से ख़ुदावन्द ने दरिया को मारा उसके बाद सात दिन गुज़रे। ");
INSERT INTO urd_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","फिर ख़ुदावन्द ने मूसा से कहा कि फ़िर'औन के पास जा और उससे कह कि 'ख़ुदावन्द यूँ फ़रमाता है कि मेरे लोगों को जाने दे ताकि वह मेरी इबादत करें। ");
INSERT INTO urd_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","और अगर तू उनको जाने न देगा, तो देख, मैं तेरे मुल्क को मेंढकों से मारूँगा। ");
INSERT INTO urd_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","और दरिया बेशुमार मेंढकों से भर जाएगा, और वह आकर तेरे घर में और तेरी आरामगाह में और तेरे पलंग पर और तेरे मुलाज़िमों के घरों में और तेरी र'इयत पर और तेरे तनूरों और आटा गूँधने के लगनों में घुसते फिरेंगे, ");
INSERT INTO urd_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","और तुझ पर और तेरी र'इयत और तेरे नौकरों पर चढ़ जाएँगे'। ");
INSERT INTO urd_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","और ख़ुदावन्द ने मूसा को फ़रमाया, हारून से कह, कि अपनी लाठी लेकर अपने हाथ दरियाओं और नहरों और झीलों पर बढ़ा और मेंढकों को मुल्क — ए — मिस्र पर चढ़ा ला। ");
INSERT INTO urd_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","चुनाँचे जितना पानी मिस्र में था उस पर हारून ने अपना हाथ बढ़ाया, और मेंढक चढ़ आए और मुल्क — ए — मिस्र को ढाँक लिया। ");
INSERT INTO urd_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","और जादूगरों ने भी अपने जादू से ऐसा ही किया और मुल्क — ए — मिस्र पर मेंढक चढ़ा लाए ");
INSERT INTO urd_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","तब फ़िर'औन ने मूसा और हारून को बुलवाकर कहा, कि “ख़ुदावन्द से सिफ़ारिश करो के मेंढकों को मुझ से और मेरी र'इयत से दफ़ा' करे, और मैं इन लोगों को जाने दूँगा ताकि वह ख़ुदावन्द के लिए क़ुर्बानी करें।” ");
INSERT INTO urd_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","मूसा ने फ़िर'औन से कहा, कि तुझे मुझ पर यही फ़ख़्र रहे! मैं तेरे और तेरे नौकरों और तेरी र'इयत के वास्ते कब के लिए सिफ़ारिश करूँ कि मेंढक तुझ से और तेरे घरों से दफ़ा' हों और दरिया ही में रहें? ");
INSERT INTO urd_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","उसने कहा, “कल के लिए।” तब उसने कहा, “तेरे ही कहने के मुताबिक़ होगा ताकि तू जाने कि ख़ुदावन्द हमारे ख़ुदा की तरह कोई नहीं ");
INSERT INTO urd_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","और मेंढक तुझ से और तेरे घरों से और तेरे नौकरों से और तेरी र'इयत से दूर होकर दरिया ही में रहा करेंगे।” ");
INSERT INTO urd_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","फिर मूसा और हारून फ़िर'औन के पास से निकल कर चले गए; और मूसा ने ख़ुदावन्द से मेंढकों के बारे में जो उसने फ़िर'औन पर भेजे थे फ़रियाद की। ");
INSERT INTO urd_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","और ख़ुदावन्द ने मूसा की दरख़्वास्त के मुवाफ़िक किया, और सब घरों और सहनों और खेतों के मेंढक मर गए। ");
INSERT INTO urd_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","और लोगों ने उनको जमा' कर करके उनके ढेर लगा दिए, और ज़मीन से बदबू आने लगी। ");
INSERT INTO urd_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","फिर जब फ़िर'औन ने देखा कि छुटकारा मिल गया तो उसने अपना दिल सख़्त कर लिया, और जैसा ख़ुदावन्द ने कह दिया था उनकी न सुनी। ");
INSERT INTO urd_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","तब ख़ुदावन्द ने मूसा से कहा, “हारून से कह, 'अपनी लाठी बढ़ा कर ज़मीन की गर्द को मार, ताकि वह तमाम मुल्क — ए — मिस्र में जूएँ बन जाएँ।” ");
INSERT INTO urd_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","उन्होंने ऐसा ही किया, और हारून ने अपनी लाठी लेकर अपना हाथ बढ़ाया और ज़मीन की गर्द को मारा, और इंसान और हैवान पर जूएँ हो गई और तमाम मुल्क — ए — मिस्र में ज़मीन की सारी गर्द जूएँ बन गई। ");
INSERT INTO urd_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","और जादूगरों ने कोशिश की कि अपने जादू से जूएँ पैदा करें लेकिन न कर सके। और इंसान और हैवान दोनों पर जूएँ चढ़ी रहीं। ");
INSERT INTO urd_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","तब जादूगरों ने फ़िर'औन से कहा, कि “यह ख़ुदा का काम है।” लेकिन फ़िर'औन का दिल सख़्त हो गया, और जैसा ख़ुदावन्द ने कह दिया था उसने उनकी न सुनी। ");
INSERT INTO urd_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","तब ख़ुदावन्द ने मूसा से कहा, “सुबह — सवेरे उठ कर फ़िर'औन के आगे जा खड़ा होना, वह दरिया पर आएगा तब तू उससे कहना, 'ख़ुदावन्द यूँ फ़रमाता है, कि मेरे लोगों को जाने दे कि वह मेरी इबादत करें। ");
INSERT INTO urd_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","वर्ना अगर तू उनको जाने न देगा तो देख मैं तुझ पर और तेरे नौकरों और तेरी र'इयत पर और तेरे घरों में मच्छरों के ग़ोल के ग़ोल भेजूँगा; और मिस्रियों के घर और तमाम ज़मीन जहाँ जहाँ वह हैं, मच्छरों के ग़ोलों से भर जाएगी। ");
INSERT INTO urd_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","और मैं उस दिन जशन के 'इलाके़ को उसमें मच्छरों के ग़ोल न होंगे; ताकि तू जान ले कि दुनिया में ख़ुदावन्द मैं ही हूँ। ");
INSERT INTO urd_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","और मैंऔर अपने लोगों और तेरे लोगों में फ़र्क़ करूँगा और कल तक यह निशान ज़ुहूर में आएगा।” ");
INSERT INTO urd_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","चुनाँचे ख़ुदावन्द ने ऐसा ही किया, और फ़िर'औन के घर और उसके नौकरों के घरों और सारे मुल्क — ए — मिस्र में मच्छरों के ग़ोल के ग़ोल भर गए, और इन मच्छरों के ग़ोलों की वजह से मुल्क का नास हो गया। ");
INSERT INTO urd_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","तब फ़िर'औन ने मूसा और हारून को बुलवा कर कहा, कि तुम जाओ और अपने ख़ुदा के लिए इसी मुल्क में क़ुर्बानी करो। ");
INSERT INTO urd_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","मूसा ने कहा, “ऐसा करना मुनासिब नहीं, क्यूँकि हम ख़ुदावन्द अपने ख़ुदा के लिए उस चीज़ की क़ुर्बानी करेंगे जिससे मिस्री नफ़रत रखते हैं; तब अगर हम मिस्रियों की आँखों के आगे उस चीज़ की क़ुर्बानी करें जिससे वह नफ़रत रखते हैं तो क्या वह हम को संगसार न कर डालेंगे? ");
INSERT INTO urd_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","तब हम तीन दिन की राह वीराने में जाकर ख़ुदावन्द अपने ख़ुदा के लिए जैसा वह हम को हुक्म देगा क़ुर्बानी करेंगे।” ");
INSERT INTO urd_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","फ़िर'औन ने कहा, “मैं तुम को जाने दूँगा ताकि तुम ख़ुदावन्द अपने ख़ुदा के लिए वीराने में क़ुर्बानी करो, लेकिन तुम बहुत दूर मत जाना और मेरे लिए सिफ़ारिश करना।” ");
INSERT INTO urd_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","मूसा ने कहा, “देख, मैं तेरे पास से जाकर ख़ुदावन्द से सिफ़ारिश करूँगा के मच्छरों के ग़ोल फ़िर'औन और उसके नौकरों और उसकी र'इयत के पास से कल ही दूर हो जाएँ, सिर्फ़ इतना हो कि फ़िर'औन आगे को दग़ा करके लोगों को ख़ुदावन्द के लिए क़ुर्बानी करने को जाने देने से इन्कार न कर दे।” ");
INSERT INTO urd_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","और मूसा ने फ़िर'औन के पास से जा कर ख़ुदावन्द से सिफ़ारिश की। ");
INSERT INTO urd_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ख़ुदावन्द ने मूसा की दरख़्वास्त के मुवाफ़िक़ किया; और उसने मच्छरों के ग़ोलों को फ़िर'औन और उसके नौकरों और उसकी र'इयत के पास से दूर कर दिया, यहाँ तक कि एक भी बाक़ी न रहा। ");
INSERT INTO urd_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","फिर फ़िर'औन ने इस बार भी अपना दिल सख़्त कर लिया, और उन लोगों को जाने न दिया। ");
INSERT INTO urd_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","तब ख़ुदावन्द ने मूसा से कहा कि फ़िर'औन के पास जाकर उससे कह, ख़ुदावन्द 'इब्रानियों का ख़ुदा यूँ फ़रमाता है, कि मेरे लोगों को जाने दे ताकि वह मेरी इबादत करें। ");
INSERT INTO urd_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","क्यूँकि अगर तू इन्कार करे और उनको जाने न दे और अब भी उनको रोके रख्खे, ");
INSERT INTO urd_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","तो देख, ख़ुदावन्द का हाथ तेरे चौपायों पर जो खेतों में हैं या'नी घोड़ों, गधों, ऊँटों, गाय बैलों और भेड़ — बकरियों पर ऐसा पड़ेगा कि उनमें बड़ी भारी मरी फैल जाएगी। ");
INSERT INTO urd_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","और ख़ुदावन्द इस्राईल के चौपायों को मिस्रियों के चौपायों से जुदा करेगा, और जो बनी — इस्राईल के हैं उनमें से एक भी नहीं मरेगा'। ");
INSERT INTO urd_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","और ख़ुदावन्द ने एक वक़्त मुक़र्रर कर दिया और बता दिया कि कल ख़ुदावन्द इस मुल्क में यही काम करेगा। ");
INSERT INTO urd_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","और ख़ुदावन्द ने दूसरे दिन ऐसा ही किया और मिस्रियों के सब चौपाए मर गए लेकिन बनी — इस्राईल के चौपायों में से एक भी न मरा। ");
INSERT INTO urd_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","चुनाँचे फ़िर'औन ने आदमी भेजे तो मा'लूम हुआ कि इस्राईलियों के चौपायों में से एक भी नहीं मरा है, लेकिन फ़िर'औन का दिल ता'अस्सुब में था और उसने लोगों को जाने न दिया। ");
INSERT INTO urd_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","और ख़ुदावन्द ने मूसा और हारून से कहा कि तुम दोनों भट्टी की राख अपनी मुट्ठियों में ले लो, और मूसा उसे फ़िर'औन के सामने आसमान की तरफ़ उड़ा दे। ");
INSERT INTO urd_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","और वह सारे मुल्क — ए — मिस्र में बारीक गर्द हो कर मिस्र के आदमियों और जानवरों के जिस्म पर फोड़े और फफोले बन जाएगी। ");
INSERT INTO urd_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","फिर वह भट्टी की राख लेकर फ़िर'औन के आगे जा खड़े हुए, और मूसा ने उसे आसमान की तरफ़ उड़ा दिया और वह आदमियों और जानवरों के जिस्म पर फोड़े और फफोले बन गयी। ");
INSERT INTO urd_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","और जादूगर फोड़ों की वजह से मूसा के आगे खड़े न रह सके, क्यूँकि जादूगरों और सब मिस्रियों के फोड़े निकले हुए थे। ");
INSERT INTO urd_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","और ख़ुदावन्द ने फ़िर'औन के दिल को सख़्त कर दिया, और उसने जैसा ख़ुदावन्द ने मूसा से कह दिया था उनकी न सुनी। ");
INSERT INTO urd_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","फिर ख़ुदावन्द ने मूसा से कहा कि “सुबह — सवेरे उठ कर फ़िर'औन के आगे जा खड़ा हो और उसे कह, कि 'ख़ुदावन्द 'इब्रानियों का ख़ुदा यूँ फ़रमाता है, कि मेरे लोगों को जाने दे ताकि वह मेरी इबादत करें। ");
INSERT INTO urd_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","क्यूँकि मैं अब की बार अपनी सब बलाएँ तेरे दिल और तेरे नौकरों और तेरी र'इयत पर नाज़िल करूँगा, ताकि तू जान ले कि तमाम दुनिया में मेरी तरह कोई नहीं है। ");
INSERT INTO urd_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","और मैंने तो अभी हाथ बढ़ा कर तुझे और तेरी र'इयत को वबा से मारा होता और तू ज़मीन पर से हलाक हो जाता। ");
INSERT INTO urd_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","लेकिन मैंने तुझे हक़ीक़त में इसलिए क़ाईम रख्खा है कि अपनी ताक़त तुझे दिखाऊँ, ताकि मेरा नाम सारी दुनिया में मशहूर हो जाए। ");
INSERT INTO urd_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","क्या तू अब भी मेरे लोगों के मुक़ाबले में तकब्बुर करता है कि उनको जाने नहीं देता? ");
INSERT INTO urd_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","देख, मैं कल इसी वक़्त ऐसे बड़े — बड़े ओले बरसाऊँगा जो मिस्र में जब से उसकी बुनियाद डाली गई आज तक नहीं पड़े। ");
INSERT INTO urd_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","तब आदमी भेज कर अपने चौपायों को, जो कुछ तेरा माल खेतों में है उसको अन्दर कर ले; क्यूँकि जितने आदमी और जानवर मैदान में होंगे और घर में नहीं पहुँचाए जाएँगे, उन पर ओले पड़ेंगे और वह हलाक हो जाएँगे'।” ");
INSERT INTO urd_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","तब फ़िर'औन के ख़ादिमों में जो — जो ख़ुदावन्द के कलाम से डरता था, वह अपने नौकरों और चौपायों को घर में भगा ले आया। ");
INSERT INTO urd_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","और जिन्होंने ख़ुदावन्द के कलाम का लिहाज़ न किया, उन्होंने अपने नौकरों और चौपायों को मैदान में रहने दिया। ");
INSERT INTO urd_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","और ख़ुदावन्द ने मूसा से कहा, कि अपना हाथ आसमान की तरफ़ बढ़ा ताकि सब मुल्क — ए — मिस्र में इंसान और हैवान और खेत की सब्ज़ी पर जो मुल्क — ए — मिस्र में है ओले गिरें। ");
INSERT INTO urd_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","और मूसा ने अपनी लाठी आसमान की तरफ़ उठाई, और ख़ुदावन्द ने रा'द और ओले भेजे और आग ज़मीन तक आने लगी, और ख़ुदावन्द ने मुल्क — ए — मिस्र पर ओले बरसाए। ");
INSERT INTO urd_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","तब ओले गिरे और ओलों के साथ आग मिली हुई थी, और वह ओले ऐसे भारी थे कि जब से मिस्री क़ौम आबाद हुई ऐसे ओले मुल्क में कभी नहीं पड़े थे। ");
INSERT INTO urd_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","और ओलों ने सारे मुल्क — ए — मिस्र में उनको जो मैदान में थे क्या इंसान, क्या हैवान, सबको मारा और खेतों की सारी सब्ज़ी को भी ओले मार गए और मैदान के सब दरख़्तों को तोड़ डाला। ");
INSERT INTO urd_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","मगर जशन के 'इलाक़ा में जहाँ बनी — इस्राईल रहते थे ओले नहीं गिरे। ");
INSERT INTO urd_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","तब फ़िर'औन ने मूसा और हारून को बुला कर उनसे कहा, कि मैंने इस दफ़ा' गुनाह किया; ख़ुदावन्द सच्चा है और मैं और मेरी क़ौम हम दोनों बदकार हैं। ");
INSERT INTO urd_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ख़ुदावन्द से सिफ़ारिश करो क्यूँकि यह ज़ोर का गरजना और ओलों का बरसना बहुत हो चुका, और मैं तुम को जाने दूँगा और तुम अब रुके नहीं रहोगे। ");
INSERT INTO urd_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","तब मूसा ने उसे कहा, कि मैं शहर से बाहर निकलते ही ख़ुदावन्द के आगे हाथ फैलाऊँगा और गरज ख़त्म हो जाएगा और ओले भी फिर न पड़ेंगे, ताकि तू जान ले कि दुनिया ख़ुदावन्द ही की है। ");
INSERT INTO urd_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","लेकिन मैं जानता हूँ कि तू और तेरे नौकर अब भी ख़ुदावन्द ख़ुदा से नहीं डरोगे। ");
INSERT INTO urd_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","अब सुन और जौ को तो ओले मार गए, क्यूँकि जौ की बालें निकल चुकी थीं और सन में फूल लगे हुए थे; ");
INSERT INTO urd_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","पर गेहूँ और कठिया गेहूँ मारे न गए क्यूँकि वह बढ़े न थे। ");
INSERT INTO urd_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","और मूसा ने फ़िर'औन के पास से शहर के बाहर जाकर ख़ुदावन्द के आगे हाथ फैलाए, तब गरज और ओले ख़त्म हो गए और ज़मीन पर बारिश थम गई। ");
INSERT INTO urd_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","जब फ़िर'औन ने देखा कि मेंह और ओले और गरज ख़त्म हो गए, तो उसने और उसके ख़ादिमों ने और ज़्यादा गुनाह किया कि अपना दिल सख़्त कर लिया। ");
INSERT INTO urd_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","और फ़िर'औन का दिल सख़्त हो गया, और उसने बनी — इस्राईल को जैसा ख़ुदावन्द ने मूसा के ज़रिए' कह दिया था जाने न दिया। ");
INSERT INTO urd_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","और ख़ुदावन्द ने मूसा से कहा, कि फ़िर'औन के पास जा; क्यूँकि मैं ही ने उसके दिल और उसके नौकरों के दिल को सख़्त कर दिया है, ताकि मैं अपने यह निशान उनके बीच दिखाऊँ; ");
INSERT INTO urd_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","और तू अपने बेटे और अपने पोते को मेरे निशान और वह काम जो मैंने मिस्र में उनके बीच किए सुनाए और तुम जान लो कि ख़ुदावन्द मैं ही हूँ। ");
INSERT INTO urd_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","और मूसा और हारून ने फ़िर'औन के पास जाकर उससे कहा कि ख़ुदावन्द, 'इब्रानियों का ख़ुदा यूँ फ़रमाता है, कि 'तू कब तक मेरे सामने नीचा बनने से इन्कार करेगा? मेरे लोगों को जाने दे कि वह मेरी इबादत करें। ");
INSERT INTO urd_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","वर्ना, अगर तू मेरे लोगों को जाने न देगा, तो देख, कल मैं तेरे मुल्क में टिड्डियाँ ले आऊँगा। ");
INSERT INTO urd_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","और वह ज़मीन की सतह को ऐसा ढाँक लेंगी कि कोई ज़मीन को देख भी न सकेगा; और तुम्हारा जो कुछ ओलों से बच रहा है वह उसे खा जाएँगी, और तुम्हारे जितने दरख़्त मैदान में लगे हैं उनको भी चट कर जाएँगी, ");
INSERT INTO urd_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","और वह तेरे और तेरे नौकरों बल्कि सब मिस्रियों के घरों में भर जाएँगी; और ऐसा तेरे बाप दादाओं ने जब से वह पैदा हुए उस वक़्त से आज तक नहीं देखा होगा'। और वह लौट कर फ़िर'औन के पास से चला गया। ");
INSERT INTO urd_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","तब फ़िर'औन के नौकर फ़िर'औन से कहने लगे कि “ये शख़्स कब तक हमारे लिए फन्दा बना रहेगा? इन लोगों को जाने दे ताकि वह ख़ुदावन्द अपने ख़ुदा की इबादत करें। क्या तुझे ख़बर नहीं कि मिस्र बर्बाद हो गया?” ");
INSERT INTO urd_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","तब मूसा और हारून फ़िर'औन के पास फिर बुला लिए गए, और उसने उनको कहा, कि “'जाओ, और ख़ुदावन्द अपने ख़ुदा की इबादत करो, लेकिन वह कौन — कौन हैं जो जाएँगे?” ");
INSERT INTO urd_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मूसा ने कहा, कि “हम अपने जवानों और बूढों और अपने बेटों और बेटियों और अपनी भेड़ बकरियों और अपने गाये बैलों समेत जाएँगे, क्यूँकि हम को अपने ख़ुदा की 'ईद करनी है।” ");
INSERT INTO urd_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","तब उसने उनको कहा कि “ख़ुदावन्द ही तुम्हारे साथ रहे, मैं तो ज़रूर ही तुम को बच्चों समेत जाने दूँगा, ख़बरदार हो जाओ इसमें तुम्हारी ख़राबी है। ");
INSERT INTO urd_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","नहीं, ऐसा नहीं होने पाएगा; तब तुम मर्द ही मर्द जाकर ख़ुदावन्द की इबादत करो क्यूँकि तुम यही चाहते थे।” और वह फ़िर'औन के पास से निकाल दिए गए। ");
INSERT INTO urd_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","तब ख़ुदावन्द ने मूसा से कहा कि “मुल्क — ए — मिस्र पर अपना हाथ बढ़ा ताकि टिड्डियाँ मुल्क — ए — मिस्र पर आएँ और हर क़िस्म की सब्ज़ी को जो इस मुल्क में ओलों से बच रही है चट कर जाएँ।” ");
INSERT INTO urd_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","तब मूसा ने मुल्क — ए — मिस्र पर अपनी लाठी बढ़ाई, और ख़ुदावन्द ने उस सारे दिन और सारी रात पुरवा आँधी चलाई; और सुबह होते होते पुरवा आँधी टिड़िडयाँ ले आई। ");
INSERT INTO urd_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","और टिडिडयाँ सारे मुल्क — ए — मिस्र पर छा गई और वहीं मिस्र की हदों में बसेरा किया, और उनका दल ऐसा भारी था कि न तो उनसे पहले ऐसी टिड्डियाँ कभी आई न उनके बाद फिर आएँगी। ");
INSERT INTO urd_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","क्यूँकि उन्होंने इस ज़मीन को ढाँक लिया, ऐसा कि मुल्क में अन्धेरा हो गया; और उन्होंने उस मुल्क की एक — एक सब्ज़ी को और दरख़्तों के मेवह को, जो ओलों से बच गए थे चट कर लिया। और मुल्क — ए — मिस्र में न तो किसी दरख़्त की, न खेत की किसी सब्ज़ी की हरियाली बाक़ी रही। ");
INSERT INTO urd_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","तब फ़िर'औन ने जल्द मूसा और हारून को बुलवा कर कहा कि “मैं ख़ुदावन्द तुम्हारे ख़ुदा का और तुम्हारा गुनहगार हूँ। ");
INSERT INTO urd_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","इसलिए सिर्फ़ इस बार मेरा गुनाह बख़्शो, और ख़ुदावन्द अपने ख़ुदा से सिफ़ारिश करो कि वह सिर्फ़ इस मौत को मुझ से दूर कर दे।” ");
INSERT INTO urd_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","फिर उसने फ़िर'औन के पास से निकल कर ख़ुदावन्द से सिफ़ारिश की। ");
INSERT INTO urd_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","और ख़ुदावन्द ने पछुवा आँधी भेजी जो टिड्डियों को उड़ा कर ले गई और उनको बहर — ए — कु़लजु़म में डाल दिया, और मिस्र की हदों में एक टिड्डी भी बाक़ी न रही। ");
INSERT INTO urd_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","लेकिन ख़ुदावन्द ने फ़िर'औन के दिल को सख़्त कर दिया और उसने बनी — इस्राईल को जाने न दिया। ");
INSERT INTO urd_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","फिर ख़ुदावन्द ने मूसा से कहा, कि अपना हाथ आसमान की तरफ़ बढ़ा ताकि मुल्क — ए — मिस्र में तारीकी छा जाए, ऐसी तारीकी जिसे टटोल सकें। ");
INSERT INTO urd_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","और मूसा ने अपना हाथ आसमान की तरफ़ बढ़ाया और तीन दिन तक सारे मुल्क — ए — मिस्र में गहरी तारीकी रही। ");
INSERT INTO urd_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","तीन दिन तक न तो किसी ने किसी को देखा और न कोई अपनी जगह से हिला, लेकिन सब बनी — इस्राईल के मकानों में उजाला रहा। ");
INSERT INTO urd_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","तब फ़िर'औन ने मूसा को बुलवा कर कहा कि “तुम जाओ और ख़ुदावन्द की इबादत करो सिर्फ़ अपनी भेड़ बकरियों और गाये बैलों को यहीं छोड़ जाओ और जो तुम्हारे बाल — बच्चे हैं उनको भी साथ लेते जाओ।” ");
INSERT INTO urd_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","मूसा ने कहा, कि तुझे हम को कु़र्बानियों और सोख़्तनी कु़र्बानियों के लिए जानवर देने पड़ेंगे, ताकि हम ख़ुदावन्द अपने ख़ुदा के आगे क़ुर्बानी करें। ");
INSERT INTO urd_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","इसलिए हमारे चौपाये भी हमारे साथ जाएँगे और उनका एक खुर तक भी पीछे नहीं छोड़ा जाएगा, क्यूँकि उन्ही में से हम को ख़ुदावन्द अपने ख़ुदा की इबादत का सामान लेना पड़ेगा, और जब तक हम वहाँ पहुँच न जाएँ हम नहीं जानते कि क्या — क्या लेकर हम को ख़ुदावन्द की इबादत करनी होगी। ");
INSERT INTO urd_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","लेकिन ख़ुदावन्द ने फ़िर'औन के दिल को सख़्त कर दिया और उसने उनको जाने ही न दिया। ");
INSERT INTO urd_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","और फ़िर'औन ने उसे कहा, “मेरे सामने से चला जा; और होशियार रह, फिर मेरा मुँह देखने को मत आना क्यूँकि जिस दिन तूने मेरा मुँह देखा तो मारा जाएगा।” ");
INSERT INTO urd_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","तब मूसा ने कहा, कि तूने ठीक कहा है, मैं फिर तेरा मुँह कभी नहीं देखूँगा। ");
INSERT INTO urd_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","और ख़ुदावन्द ने मूसा से कहा कि “मैं फ़िर'औन और मिस्रियों पर एक बला और लाऊँगा, उसके बाद वह तुम को यहाँ से जाने देगा, और जब वह तुम को जाने देगा तो यक़ीनन तुम सब को यहाँ से बिल्कुल निकाल देगा। ");
INSERT INTO urd_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","इसलिए अब तू लोगों के कान में यह बात डाल दे कि उनमें से हर शख़्स अपने पड़ोसी और हर 'औरत अपनी पड़ौसन से सोने, चाँदी के ज़ेवर ले।” ");
INSERT INTO urd_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","और ख़ुदावन्द ने उन लोगों पर मिस्रियों को मेहरबान कर दिया, और यह आदमी मूसा भी मुल्क — ए — मिस्र में फ़िर'औन के ख़ादिमों के नज़दीक और उन लोगों की निगाह में बड़ा बुज़ुर्ग़ था। ");
INSERT INTO urd_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","और मूसा ने कहा, कि ख़ुदावन्द यूँ फ़रमाता है कि मैं आधी रात को निकल कर मिस्र के बीच में जाऊँगा; ");
INSERT INTO urd_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","और मुल्क — ए — मिस्र के सब पहलौटे, फ़िर'औन जो तख़्त पर बैठा है उसके पहलौटे से लेकर वह लौंडी जो चक्की पीसती है उसके पहलौटे तक और सब चौपायों के पहलौठे मर जाएँगे। ");
INSERT INTO urd_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","और सारे मुल्क — ए — मिस्र में ऐसा बड़ा मातम होगा जैसा न कभी पहले हुआ और न फिर कभी होगा। ");
INSERT INTO urd_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","लेकिन इस्राईल में से किसी पर चाहे इंसान हो चाहे हैवान एक कुत्ता भी नही भौंकेगा, ताकि तुम जान लो कि ख़ुदावन्द मिस्रियों और इस्राईलियों में कैसा फ़र्क करता है। ");
INSERT INTO urd_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","और तेरे यह सब नौकर मेरे पास आकर मेरे आगे सर झुकाएंगे और कहेंगे, कि 'तू भी निकल और तेरे सब पैरौ भी निकलें, इसके बाद मैं निकल जाऊँगा। यह कह कर वह बड़े ग़ुस्से में फ़िर'औन के पास से निकल कर चला गया। ");
INSERT INTO urd_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","और ख़ुदावन्द ने मूसा से कहा, कि फ़िर'औन तुम्हारी इसी वजह से नहीं सुनेगा; ताकि 'अजायब मुल्क — ए — मिस्र में बहुत ज़्यादा हो जाएँ। ");
INSERT INTO urd_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","और मूसा और हारून ने यह करामात फ़िरऔन को दिखाई, और ख़ुदावन्द ने फ़िर'औन के दिल को सख़्त कर दिया कि उसने अपने मुल्क से बनी — इस्राईल को जाने न दिया। ");
INSERT INTO urd_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","फिर ख़ुदावन्द ने मुल्क — ए — मिस्र में मूसा और हारून से कहा कि ");
INSERT INTO urd_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“यह महीना तुम्हारे लिए महीनों का शुरू' और साल का पहला महीना हो। ");
INSERT INTO urd_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","तब इस्राईलियों की सारी जमा'अत से यह कह दो कि इसी महीने के दसवें दिन, हर शख़्स अपने आबाई ख़ान्दान के मुताबिक़ घर पीछे एक बर्रा ले; ");
INSERT INTO urd_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","और अगर किसी के घराने में बर्रे को खाने के लिए आदमी कम हों, तो वह और उसका पड़ोसी जो उसके घर के बराबर रहता हो, दोनों मिल कर नफ़री के शुमार के मुवाफ़िक़ एक बर्रा ले रख्खें, तुम हर एक आदमी के खाने की मिक़्दार के मुताबिक़ बर्रे का हिसाब लगाना। ");
INSERT INTO urd_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","तुम्हारा बर्रा बे “ऐब और यक साला नर हो, और ऐसा बच्चा या तो भेड़ों में से चुन कर लेना या बकरियों में से। ");
INSERT INTO urd_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","और तुम उसे इस महीने की चौदहवीं तक रख छोड़ना, और इस्राईलियों के क़बीलों की सारी जमा'अत शाम को उसे ज़बह करे। ");
INSERT INTO urd_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","और थोड़ा सा ख़ून लेकर जिन घरों में वह उसे खाएँ, उनके दरवाज़ों के दोनों बाजु़ओं और ऊपर की चौखट पर लगा दें। ");
INSERT INTO urd_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","और वह उसके गोश्त को उसी रात आग पर भून कर बेख़मीरी रोटी और कड़वे साग पात के साथ खा लें। ");
INSERT INTO urd_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","उसे कच्चा या पानी में उबाल कर हरगिज़ न खाना, बल्कि उसको सिर और पाये और अन्दरूनी 'आज़ा समेत आग पर भून कर खाना। ");
INSERT INTO urd_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","और उसमें से कुछ भी सुबह तक बाक़ी न छोड़ना और अगर कुछ उसमें से सुबह तक बाक़ी रह जाए तो उसे आग में जला देना। ");
INSERT INTO urd_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","और तुम उसे इस तरह खाना अपनी कमर बाँधे और अपनी जूतियाँ पाँव में पहने और अपनी लाठी हाथ में लिए हुए तुम उसे जल्दी — जल्दी खाना, क्यूँकि यह फ़सह ख़ुदावन्द की है। ");
INSERT INTO urd_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","इसलिए कि मैं उस रात मुल्क — ए — मिस्र में से होकर गुज़रूँगा और इंसान और हैवान के सब पहलौठों को जो मुल्क — ए — मिस्र में हैं, मारूँगा और मिस्र के सब मा'बूदों को भी सज़ा दूँगा; मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","और जिन घरों में तुम हो उन पर वह ख़ून तुम्हारी तरफ़ से निशान ठहरेगा और मैं उस ख़ून को देख कर तुम को छोड़ता जाऊँगा, और जब मैं मिस्रियों को मारूँगा तो वबा तुम्हारे पास फटकने की भी नहीं कि तुम को हलाक करे। ");
INSERT INTO urd_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","और वह दिन तुम्हारे लिए एक यादगार होगा और तुम उसको ख़ुदावन्द की 'ईद का दिन समझ कर मानना। तुम उसे हमेशा की रस्म करके उस दिन को नसल दर नसल 'ईद का दिन मानना। ");
INSERT INTO urd_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","'सात दिन तक तुम बेख़मीरी रोटी खाना, और पहले ही दिन से ख़मीर अपने अपने घर से बाहर कर देना; इसलिए कि जो कोई पहले दिन से सातवें दिन तक ख़मीरी रोटी खाए वह शख़्स इस्राईल में से काट डाला जाएगा। ");
INSERT INTO urd_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","और पहले दिन तुम्हारा मुक़द्दस मजमा' हो, और सातवें दिन भी मुक़द्दस मजमा' हो; उन दोनों दिनों में कोई काम न किया जाए सिवा उस खाने के जिसे हर एक आदमी खाए, सिर्फ़ यही किया जाए। ");
INSERT INTO urd_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","और तुम बेख़मीरी रोटी की यह 'ईद मनाना, क्यूँकि मैं उसी दिन तुम्हारे लश्कर को मुल्क — ए — मिस्र से निकालूँगा; इस लिए तुम उस दिन को हमेशा की रस्म करके नसल दर नसल मानना। ");
INSERT INTO urd_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","पहले महीने की चौदहवीं तारीख़ की शाम से इक्कीसवीं तारीख़ की शाम तक तुम बेख़मीरी रोटी खाना। ");
INSERT INTO urd_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","सात दिन तक तुम्हारे घरों में कुछ भी ख़मीर न हो, क्यूँकि जो कोई किसी ख़मीरी चीज़ को खाए, वह चाहे मुसाफ़िर हो चाहे उसकी पैदाइश उसी मुल्क की हो, इस्राईल की जमा'अत से काट डाला जाएगा। ");
INSERT INTO urd_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","तुम कोई ख़मीरी चीज़ न खाना बल्कि अपनी सब बस्तियों में बेख़मीरी रोटी खाना।” ");
INSERT INTO urd_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","तब मूसा ने इस्राईल के सब बुज़ुर्गों को बुलवाकर उनको कहा, कि अपने — अपने ख़ान्दान के मुताबिक़ एक — एक बर्रा निकाल रख्खो, और यह फ़सह का बर्रा ज़बह करना। ");
INSERT INTO urd_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","और तुम ज़ूफ़े का एक गुच्छा लेकर उस ख़ून में जो तसले में होगा डुबोना और उसी तसले के ख़ून में से कुछ ऊपर की चौखट और दरवाज़े के दोनों बाजु़ओं पर लगा देना; और तुम में से कोई सुबह तक अपने घर के दरवाज़े से बाहर न जाए। ");
INSERT INTO urd_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","क्यूँकि ख़ुदावन्द मिस्रियों को मारता हुआ गुज़रेगा, और जब ख़ुदावन्द ऊपर की चौखट और दरवाज़े के दोनों बाज़ुओं पर ख़ून देखेगा तो वह उस दरवाज़े को छोड़ जाएगा; और हलाक करने वाले को तुम को मारने के लिए घर के अन्दर आने न देगा। ");
INSERT INTO urd_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","और तुम इस बात को अपने और अपनी औलाद के लिए हमेशा की रिवायत करके मानना। ");
INSERT INTO urd_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","और जब तुम उस मुल्क में जो ख़ुदावन्द तुम को अपने वा'दे के मुवाफ़िक़ देगा दाख़िल हो जाओ, तो इस इबादत को बराबर जारी रखना। ");
INSERT INTO urd_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","और जब तुम्हारी औलाद तुम से पूछे, कि इस इबादत से तुम्हारा मक़सद क्या है? ");
INSERT INTO urd_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","तो तुम यह कहना, कि 'यह ख़ुदावन्द की फ़सह की क़ुर्बानी है, जो मिस्र में मिस्रियों को मारते वक़्त बनी — इस्राईल के घरों को छोड़ गया और यूँ हमारे घरों को बचा लिया'। तब लोगों ने सिर झुका कर सिज्दा किया। ");
INSERT INTO urd_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","और बनी — इस्राईल ने जाकर, जैसा ख़ुदावन्द ने मूसा और हारून को फ़रमाया था वैसा ही किया। ");
INSERT INTO urd_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","और आधी रात को ख़ुदावन्द ने मुल्क — ए — मिस्र के सब पहलौठों को फ़िर'औन जो अपने तख़्त पर बैठा था उसके पहलौठे से लेकर वह कै़दी जो कै़दखानें में था उसके पहलौठे तक, बल्कि चौपायों के पहलौठों को भी हलाक कर दिया। ");
INSERT INTO urd_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","और फ़िर'औन और उसके सब नौकर और सब मिस्री रात ही को उठ बैठे और मिस्र में बड़ा कोहराम मचा, क्यूँकि एक भी ऐसा घर न था जिसमें कोई न मरा हो। ");
INSERT INTO urd_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","तब उसने रात ही रात में मूसा और हारून को बुलवा कर कहा, कि “तुम बनी — इस्राईल को लेकर मेरी क़ौम के लोगों में से निकल जाओ और जैसा कहते हो जाकर ख़ुदावन्द की इबादत करो। ");
INSERT INTO urd_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","और अपने कहने के मुताबिक़ अपनी भेड़ बकरियाँ और गाय बैल भी लेते जाओ और मेरे लिए भी दुआ' करना।” ");
INSERT INTO urd_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","और मिस्री उन लोगों से बजिद्द होने लगे, ताकि उनको मुल्क — ए — मिस्र से जल्द बाहर चलता करें, क्यूँकि वह समझे कि हम सब मर जाएँगे। ");
INSERT INTO urd_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","तब इन लोगों ने अपने गुन्धे गुन्धाए आटे को बग़ैर ख़मीर दिए लगनों समेत कपड़ों में बाँध कर अपने कंधों पर धर लिया। ");
INSERT INTO urd_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","और बनी — इस्राईल ने मूसा के कहने के मुवाफ़िक यह भी किया, कि मिस्रियों से सोने चाँदी के ज़ेवर और कपड़े माँग लिए। ");
INSERT INTO urd_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","और ख़ुदावन्द ने उन लोगों को मिस्रियों की निगाह में ऐसी 'इज़्ज़त बख़्शी कि जो कुछ उन्होंने माँगा उन्होंने दे दिया। तब उन्होंने मिस्रियों को लूट लिया। ");
INSERT INTO urd_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","और बनी — इस्राईल ने रा'मसीस से सुक्कात तक पैदल सफ़र किया और बाल बच्चों को छोड़ कर वह कोई छः लाख मर्द थे। ");
INSERT INTO urd_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","और उनके साथ एक मिली — जुली गिरोह भी गई और भेड़ — बकरियाँ और गाय — बैल और बहुत चौपाये उनके साथ थे। ");
INSERT INTO urd_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","और उन्होंने उस गुन्धे हुए आटे की जिसे वह मिस्र से लाए थे बेख़मीरी रोटियाँ पकाई, क्यूँकि वह उसमें ख़मीर देने न पाए थे इसलिए कि वह मिस्र से ऐसे जबरन निकाल दिए गए कि वहाँ ठहर न सके और न कुछ खाना अपने लिए तैयार करने पाए। ");
INSERT INTO urd_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","और बनी — इस्राईल को मिस्र में रहते हुए चार सौ तीस बरस हुए थे। ");
INSERT INTO urd_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","और उन चार सौ तीस बरसों के गुज़र जाने पर ठीक उसी दिन ख़ुदावन्द का सारा लश्कर मुल्क — ए — मिस्र से निकल गया। ");
INSERT INTO urd_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ये वह रात है जिसे ख़ुदावन्द की ख़ातिर मानना बहुत मुनासिब है क्यूँकि इसमें वह उनको मुल्क — ए — मिस्र से निकाल लाया, ख़ुदावन्द की यह वही रात है जिसे ज़रूरी है कि सब बनी इस्राईल नसल — दर — नसल ख़ूब मानें। ");
INSERT INTO urd_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","फिर ख़ुदावन्द ने मूसा और हारून से कहा, कि 'फ़सह की रिवायत यह है, कि कोई बेगाना उसे खाने न पाए। ");
INSERT INTO urd_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","लेकिन अगर कोई शख़्स किसी का ख़रीदा हुआ ग़ुलाम हो, और तूने उसका ख़तना कर दिया हो तो वह उसे खाए। ");
INSERT INTO urd_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","पर अजनबी और मज़दूर उसे खाने न पाए। ");
INSERT INTO urd_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","और उसे एक ही घर में खाएँ या'नी उसका ज़रा भी गोश्त तू घर से बाहर न ले जाना और न तुम उसकी कोई हड्डी तोड़ना। ");
INSERT INTO urd_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","इस्राईल की सारी जमा'अत इस पर 'अमल करे। ");
INSERT INTO urd_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","और अगर कोई अजनबी तेरे साथ मुक़ीम हो और ख़ुदावन्द की फ़सह को मानना चाहता हो उसके यहाँ के सब मर्द अपना ख़तना कराएँ, तब वह पास आकर फ़सह करे; यूँ वह ऐसा समझा जाएगा जैसे उसी मुल्क की उसकी पैदाइश है लेकिन कोई नामख़्तून आदमी उसे खाने न पाए। ");
INSERT INTO urd_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","वतनी और उस अजनबी के लिए जो तुम्हारे बीच मुक़ीम हो एक ही शरी'अत होगी। ");
INSERT INTO urd_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","तब सब बनी — इस्राईल ने जैसा ख़ुदावन्द ने मूसा और हारून को फ़रमाया वैसा ही किया। ");
INSERT INTO urd_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","और ठीक उसी दिन ख़ुदावन्द बनी — इस्राईल के सब लश्करों को मुल्क — ए — मिस्र से निकाल ले गया। ");
INSERT INTO urd_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","और ख़ुदावन्द ने मूसा को फ़रमाया, कि। ");
INSERT INTO urd_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“सब पहलौठों को या'नी जो बनी — इस्राईल में, चाहे इंसान हो चाहे हैवान पहलौठे बच्चे हों उनको मेरे लिए पाक ठहरा क्यूँकि वह मेरे हैं।” ");
INSERT INTO urd_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","और मूसा ने लोगों से कहा, कि “तुम इस दिन को याद रखना जिस में तुम मिस्र से जो ग़ुलामी का घर है निकले, क्यूँकि ख़ुदावन्द अपनी ताक़त से तुम को वहाँ से निकाल लाया; इसमें ख़मीरी रोटी खाई न जाए। ");
INSERT INTO urd_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","तुम अबीब के महीने में आज के दिन निकले हो। ");
INSERT INTO urd_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","फिर जब ख़ुदावन्द तुझ को कना'नियों और हित्तियों और अमोरियों और हव्वियों और यबूसियों के मुल्क में पहुँचा दे जिसे तुझ को देने की क़सम उसने तेरे बाप दादा से खाई थी और जिसमें दूध और शहद बहता है, तो तू इसी महीने में यह इबादत किया करना। ");
INSERT INTO urd_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","सात दिन तक तो तू बेख़मीरी रोटी खाना और सातवें दिन ख़ुदावन्द की 'ईद मनाना। ");
INSERT INTO urd_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","बेख़मीरी रोटी सातों दिन खाई जाए, और ख़मीरी रोटी तेरे पास दिखाई भी न दे और न तेरे मुल्क की हदों में कहीं कुछ ख़मीर नज़र आए। ");
INSERT INTO urd_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","और तू उस दिन अपने बेटे को यह बताना, कि इस दिन को मैं उस काम की वजह से मानता हूँ जो ख़ुदावन्द ने मेरे लिए उस वक़्त किया जब मैं मुल्क — ए — मिस्र से निकला। ");
INSERT INTO urd_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","और यही तेरे पास जैसे तेरे हाथ में एक निशान और तेरी दोनों आँखों के सामने एक यादगार ठहरे, ताकि ख़ुदावन्द की शरी'अत तेरी ज़बान पर हो; क्यूँकि ख़ुदावन्द ने तुझ को अपनी ताक़त से मुल्क — ए — मिस्र से निकाला। ");
INSERT INTO urd_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","तब तू इस रिवायत को इसी वक़्त — ए — मु'अय्यन में हर साल माना करना। ");
INSERT INTO urd_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“और जब ख़ुदावन्द उस क़सम के मुताबिक़, जो उसने तुझ से और तेरे बाप दादा से खाई, तुझ को कना'नियों के मुल्क में पहुँचा कर वह मुल्क तुझ को दे दे। ");
INSERT INTO urd_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","तो तू पहलौटे बच्चों को और जानवरों के पहलौठों को ख़ुदावन्द के लिए अलग कर देना। सब नर बच्चे ख़ुदावन्द के होंगे। ");
INSERT INTO urd_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","और गधे के पहले बच्चे के फ़िदिये में बर्रा देना, और अगर तू उसका फ़िदिया न दे तो उसकी गर्दन तोड़ डालना। और तेरे बेटों में जितने पहलौठे हों उन सबका फ़िदिया तुझ को देना होगा। ");
INSERT INTO urd_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","और जब अगले ज़माने में तेरा बेटा तुझसे सवाल करे, कि 'यह क्या है?” तो तू उसे यह जवाब देना, 'ख़ुदावन्द हम को मिस्र से जो ग़ुलामी का घर है अपनी ताक़त से निकाल लाया। ");
INSERT INTO urd_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","और जब फ़िर'औन ने हम को जाने देना न चाहा, तो ख़ुदावन्द ने मुल्क — ए — मिस्र में इंसान और हैवान दोनों के पहलौठे मार दिए। इसलिए मैं जानवरों के सब नर बच्चों को जो अपनी अपनी माँ के रिहम को खोलते हैं ख़ुदावन्द के आगे क़ुर्बानी करता हूँ, लेकिन अपने बेटों के सब पहलौठों का फ़िदिया देता हूँ। ");
INSERT INTO urd_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","और यह तेरे हाथ पर एक निशान और तेरी पेशानी पर टीकों की तरह हों, क्यूँकि ख़ुदावन्द अपने ताक़त से हम को मिस्र से निकाल लाया।” ");
INSERT INTO urd_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","और जब फ़िर'औन ने उन लोगों को जाने की इजाज़त दे दी तो ख़ुदा इनको फ़िलिस्तियों के मुल्क के रास्ते से नहीं ले गया, अगरचे उधर से नज़दीक पड़ता; क्यूँकि ख़ुदा ने कहा, ऐसा न हो कि यह लोग लड़ाई — भिड़ाई देख कर पछताने लगें और मिस्र को लौट जाएँ। ");
INSERT INTO urd_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","बल्कि ख़ुदा इनको चक्कर खिला कर बहर — ए — कु़लजु़म के वीरान के रास्ते से ले गया और बनी — इस्राईल मुल्क — ए — मिस्र से हथियार बन्द निकले थे। ");
INSERT INTO urd_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","और मूसा यूसुफ़ की हड्डियों को साथ लेता गया, क्यूँकि उसने बनी — इस्राईल से यह कह कर, कि ख़ुदा ज़रूर तुम्हारी ख़बर लेगा इस बात की सख़्त क़सम ले ली थी, कि तुम यहाँ से मेरी हड्डियाँ अपने साथ लेते जाना। ");
INSERT INTO urd_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","और उन्होंने सुक्कात से रवाना करके वीराने के किनारे ईताम में ख़ेमा लगाया। ");
INSERT INTO urd_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","और ख़ुदावन्द उनको दिन को रास्ता दिखाने के लिए बादल के सुतून में और रात को रौशनी देने के लिए आग के सुतून में हो कर उनके आगे — आगे चला करता था, ताकि वह दिन और रात दोनों में चल सके। ");
INSERT INTO urd_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","वह बादल का सुतून दिन को और आग का सुतून रात को उन लोगों के आगे से हटता न था। ");
INSERT INTO urd_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","और ख़ुदावन्द ने मूसा से फ़रमाया, कि ");
INSERT INTO urd_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“बनी — इस्राईल को हुक्म दे कि वह लौट कर मिजदाल और समुन्दर के बीच फ़ी हख़ीरोत के सामने बाल — सफ़ोन के आगे ख़ेमे लगाएँ, उसी के आगे समुन्दर के किनारे किनारे ख़ेमें लगाना। ");
INSERT INTO urd_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","फ़िर'औन बनी — इस्राईल के हक़ में कहेगा कि वह ज़मीन की उलझनों में आकर वीरान में घिर गए हैं। ");
INSERT INTO urd_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","और मैं फ़िर'औन के दिल को सख़्त करूँगा और वह उनका पीछा करेगा, और मैं फ़िर'औन और उसके सारे लश्कर पर मुम्ताज़ हूँगा और मिस्री जान लेंगे कि ख़ुदावन्द मैं हूँ।” और उन्होंने ऐसा ही किया। ");
INSERT INTO urd_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","जब मिस्र के बादशाह को ख़बर मिली कि वह लोग चल दिए, तो फ़िर'औन और उसके खादिमों का दिल उन लोगों की तरफ़ से फिर गया, और वह कहने लगे कि हम ने यह क्या किया, कि इस्राईलियों को अपनी ख़िदमत से छुट्टी देकर उनको जाने दिया? ");
INSERT INTO urd_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","तब उसने अपना रथ तैयार करवाया और अपनी क़ौम के लोगों को साथ लिया, ");
INSERT INTO urd_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","और उसने छ: सौ चुने हुए रथ बल्कि मिस्र के सब रथ लिए और उन सभों में सरदारों को बिठाया। ");
INSERT INTO urd_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","और ख़ुदावन्द ने मिस्र के बादशाह फ़िर'औन के दिल को सख़्त कर दिया और उसने बनी इस्राईल का पीछा किया, क्यूँकि बनी — इस्राईल बड़े फ़ख़्र से निकले थे। ");
INSERT INTO urd_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","और मिस्री फ़ौज ने फ़िर'औन के सब घोड़ों और रथों और सवारों समेत उनका पीछा किया और उनको जब वह समुन्दर के किनारे फ़ी — हख़ीरोत के पास बाल सफ़ोन के सामने ख़ेमा लगा रहे थे जा लिया। ");
INSERT INTO urd_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","और जब फ़िर'औन नज़दीक आ गया तब बनी — इस्राईल ने आँख उठा कर देखा कि मिस्री उनका पीछा किए चले आते हैं, और वह बहुत ख़ौफ़ज़दा हो गए। तब बनी — इस्राईल ने ख़ुदावन्द से फ़रियाद की, ");
INSERT INTO urd_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","और मूसा से कहने लगे, “क्या मिस्र में क़ब्रे न थीं जो तू हम को वहाँ से मरने के लिए वीराने में ले आया है? तूने हम से यह क्या किया कि हम को मिस्र से निकाल लाया? ");
INSERT INTO urd_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","क्या हम तुझ से मिस्र में यह बात न कहते थे कि हम को रहने दे कि हम मिस्रियों की ख़िदमत करें? क्यूँकि हमारे लिए मिस्रियों की ख़िदमत करना वीराने में मरने से बेहतर होता।” ");
INSERT INTO urd_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","तब मूसा ने लोगों से कहा, “डरो मत, चुपचाप खड़े होकर ख़ुदावन्द की नजात के काम को देखो जो वह आज तुम्हारे लिए करेगा। क्यूँकि जिन मिस्रियों को तुम आज देखते हो उनको फिर कभी हमेशा तक न देखोगे। ");
INSERT INTO urd_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ख़ुदावन्द तुम्हारी तरफ़ से जंग करेगा और तुम ख़ामोश रहोगे।” ");
INSERT INTO urd_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","और ख़ुदावन्द ने मूसा से कहा, कि तू क्यूँ मुझ से फ़रियाद कर रहा है? बनी — इस्राईल से कह कि वह आगे बढ़ें। ");
INSERT INTO urd_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","और तू अपनी लाठी उठा कर अपना हाथ समुन्दर के ऊपर बढ़ा और उसे दो हिस्से कर, और बनी इस्राईल समुन्दर के बीच में से ख़ुश्क ज़मीन पर चल कर निकल जाएँगे। ");
INSERT INTO urd_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","और देख, मिस्रियों के दिल सख़्त कर दूँगा और वह उनका पीछा करेंगे, और मैं फ़िर'औन और उसकी सिपाह और उसके रथों और सवारों पर मुम्ताज़ हूँगा। ");
INSERT INTO urd_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","और जब मैं फ़िर'औन और उसके रथों और सवारों पर मुम्ताज़ हो जाउँगा तो मिस्री जान लेंगे कि मैं ही ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","और ख़ुदा उसका फ़रिश्ता जो इस्राईली लश्कर के आगे — आगे चला करता था जा कर उनके पीछे हो गया और बादल का वह सुतून उनके सामने से हट कर उनके पीछे जा ठहरा। ");
INSERT INTO urd_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","इस तरह वह मिस्रियों के लश्कर और इस्राईली लश्कर के बीच में हो गया, तब वहाँ बादल भी था और अन्धेरा भी तो भी रात को उससे रौशनी रही। तब वह रात भर एक दूसरे के पास नहीं आए। ");
INSERT INTO urd_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","फिर मूसा ने अपना हाथ समुन्दर के ऊपर बढ़ाया और ख़ुदावन्द ने रात भर तुन्द पूरबी आँधी चला कर और समुन्दर को पीछे हटा कर उसे ख़ुश्क ज़मीन बना दिया और पानी दो हिस्से हो गया। ");
INSERT INTO urd_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","और बनी — इस्राईल समुन्दर के बीच में से ख़ुश्क ज़मीन पर चल कर निकल गए और उनके दाहने और बाएँ हाथ पानी दीवार की तरह था। ");
INSERT INTO urd_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","और मिस्रियों ने पीछा किया और फ़िर'औन सब घोडे़ और रथ और सवार उनके पीछे — पीछे समुन्दर के बीच में चले गए। ");
INSERT INTO urd_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","और रात के पिछले पहर ख़ुदावन्द ने आग और बादल के सुतून में से मिस्रियों के लश्कर पर नज़र कीऔर उनके लश्कर को घबरा दिया। ");
INSERT INTO urd_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","और उसने उनके रथों के पहियों को निकाल डाला इसलिए उनका चलना मुश्किल हो गया तब मिस्री कहने लगे, “आओ, हम इस्राईलियों के सामने से भागें, क्यूँकि ख़ुदावन्द उनकी तरफ़ से मिस्रियों के साथ जंग करता है।” ");
INSERT INTO urd_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","और ख़ुदावन्द ने मूसा से कहा, कि अपना हाथ समुन्दर के ऊपर बढ़ा, ताकि पानी मिस्रियों और उनके रथों और सवारों पर फिर बहने लगे। ");
INSERT INTO urd_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","और मूसा ने अपना हाथ समुन्दर के ऊपर बढ़ाया, और सुबह होते होते समुन्दर फिर अपनी असली ताक़त पर आ गया; और मिस्री उल्टे भागने लगे और ख़ुदावन्द ने समुन्दर के बीच ही में मिस्रियों को हलाक कर दिया। ");
INSERT INTO urd_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","और पानी पलट कर आया और उसने रथों और सवारों और फ़िर'औन सारे लश्कर जो इस्राईलियों का पीछा करता हुआ समुन्दर में गया था डुबो दिया और उसमे से एक भी बाक़ी न छोड़ा। ");
INSERT INTO urd_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","लेकिन बनी — इस्राईल समुन्दर के बीच में ख़ुश्क ज़मीन पर चलकर निकल गए और पानी उनके दहने और बाएँ हाथ दीवार की तरह रहा। ");
INSERT INTO urd_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","फिर ख़ुदावन्द ने उस दिन इस्राईलियों को मिस्रियों को हाथ से इस तरह बचाया, और इस्राईलियों ने मिस्रियों को समुन्दर के किनारे मरे हुए पड़े देखा। ");
INSERT INTO urd_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","और इस्राईलियों ने बड़ी क़ुदरत जो ख़ुदावन्द ने मिस्रियों पर ज़ाहिर की देखी, और वह लोग ख़ुदावन्द से डर गये और ख़ुदावन्द पर और उसके बन्दे मूसा पर ईमान लाए। ");
INSERT INTO urd_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","तब मूसा और बनी — इस्राईल ने ख़ुदावन्द के लिए यह गीत गाया और यूँ कहने लगे, “मैं ख़ुदा वन्द की सना गाँऊगा क्यूँकि वह जलाल के साथ फ़तहमन्द हुआ; उस ने घोड़े को सवार समेत समुन्द्र में डाल दिया। ");
INSERT INTO urd_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","ख़ुदावन्द मेरी ताक़त और राग है, वही मेरी नजात भी ठहरा। वह मेरा ख़ुदा है, मैं उसकी बड़ाई करूँगा, वह मेरे बाप का ख़ुदा है मैं उसकी बुजु़र्गी करूँगा। ");
INSERT INTO urd_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ख़ुदावन्द साहिब — ए — जंग है, यहोवा उसका नाम है। ");
INSERT INTO urd_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","फ़िर'औन के रथों और लश्कर को उसने समुन्दर में डाल दिया; और उसके चुने सरदार बहर — ए — कु़लजु़म में डूब गये। ");
INSERT INTO urd_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","गहरे पानी ने उनको छिपा लिया; वह पत्थर की तरह तह में चले गए। ");
INSERT INTO urd_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","ऐ ख़ुदावन्द, तेरा दहना हाथ कु़दरत की वजह से जलाली है। ऐ ख़ुदावन्द तेरा दहना हाथ दुश्मन को चकनाचूर कर देता है। ");
INSERT INTO urd_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","तू अपनी 'अज़मत के ज़ोर से अपने मुख़ालिफ़ों को हलाक करता है; तू अपना क़हर भेजता है, और वह उनको खूँटी की तरह भस्म कर डालता है। ");
INSERT INTO urd_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","तेरे नथनों के दम से पानी का ढेर लग गया, सैलाब तूदे की तरह सीधे खड़े हो गए, और गहरा पानी समन्दर के बीच में जम गया। ");
INSERT INTO urd_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","दुश्मन ने तो यह कहा था, मैं पीछा करूँगा, मैं जा पकड़ूँगा, मैं लूट का माल बाटूँगा, उनकी तबाही से मेरा कलेजा ठंडा होगा। मैं अपनी तलवार खींच कर अपने ही हाथ से उनको हलाक करूँगा। ");
INSERT INTO urd_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","तूने अपनी आँधी की फूँक मारी, तो समन्दर ने उनको छिपा लिया। वह ज़ोर के पानी में शीसे की तरह डूब गए। ");
INSERT INTO urd_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","मा'बूदों में ऐ ख़ुदावन्द तेरी तरह कौन है? कौन है जो तेरी तरह अपनी पाकीज़गी की वजह से जलाली और अपनी मदह की वजह से रौ'ब वाला और साहिब — ए — करामात है? ");
INSERT INTO urd_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","तूने अपना दहना हाथ बढ़ाया, तो ज़मीन उनको निगल गई। ");
INSERT INTO urd_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“अपनी रहमत से तूने उन लोगों की जिनको तूने छुटकारा बख़्शा रहनुमाई की, और अपने ज़ोर से तू उनको अपने मुक़द्दस मकान को ले चला है। ");
INSERT INTO urd_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","क़ौमें सुन कर काँप गई हैं। और फ़िलिस्तीन के रहने वालों की जान पर आ बनी है। ");
INSERT INTO urd_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","अदोम के उहदे दार हैरान हैं, मोआब के पहलवानों को कपकपी लग गई है; कनान के सब रहने वालों के दिल पिघले जाते हैं। ");
INSERT INTO urd_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ख़ौफ़ — ओ — हिरास उन पर तारी है; तेरे बाजू़ की 'अज़मत की वजह से वह पत्थर की तरह बेहिस — ओ — हरकत हैं। जब तक ऐ ख़ुदावन्द, तेरे लोग निकल न जाएँ, जब तक तेरे लोग जिनको तूने ख़रीदा है पार न हो जाएँ, ");
INSERT INTO urd_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","तू उनको वहाँ ले जाकर अपनी मीरास के पहाड़ पर दरख़्त की तरह लगाएगा, तू उनको उसी जगह ले जाएगा जिसे तूने अपनी सुकूनत के लिए बनाया है। ऐ ख़ुदावन्द! वह तेरी जा — ए — मुक़द्दस है, जिसे तेरे हाथों ने क़ाईम किया है। ");
INSERT INTO urd_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","ख़ुदावन्द हमेशा से हमेशा तक सल्तनत करेगा।” ");
INSERT INTO urd_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","इस हम्द की वजह यह थी कि फ़िर'औन के सवार घोड़ों और रथों समेत समन्दर में गए, और ख़ुदावन्द समन्दर के पानी को उन पर लौटा लाया; लेकिन बनी — इस्राईल समन्दर के बीच में से ख़ुश्क ज़मीन पर चल कर निकल गए। ");
INSERT INTO urd_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","तब हारून की बहन मरियम नबिया ने दफ़ हाथ में लिया, और सब 'औरतें दफ़ लिए नाचती हुई उसके पीछे चलीं। ");
INSERT INTO urd_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","और मरियम उनके हम्द के जवाब में यह गाती थी, “ख़ुदावन्द की हम्द — ओ — सना गाओ, क्यूँकि वह जलाल के साथ फ़तहमन्द हुआ है; उसने घोड़े को उसके सवार समेत समन्दर में डाल दिया है।” ");
INSERT INTO urd_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","फ़िर मूसा बनी — इस्राईल को बहर — ए — कु़लजु़म से आगे ले गया और वह शोर के वीराने में आए, और वीराने में चलते हुए तीन दिन तक उनको कोई पानी का चश्मा न मिला। ");
INSERT INTO urd_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","और जब वह मारह में आए तो मारह का पानी पी न सके क्यूँकि वह कड़वा था, इसीलिए उस जगह का नाम मारह पड़ गया। ");
INSERT INTO urd_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","तब वह लोग मूसा पर बड़बड़ा कर कहने लगे, कि हम क्या पिएँ? ");
INSERT INTO urd_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","उसने ख़ुदावन्द से फ़रियाद की; ख़ुदावन्द ने उसे एक पेड़ दिखाया जिसे जब उसने पानी में डाला तो पानी मीठा हो गया। वहीं ख़ुदावन्द ने उनके लिए एक क़ानून और शरी'अत बनाई और वहीं यह कह कर उनकी आज़माइश की, ");
INSERT INTO urd_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","कि “अगर तू दिल लगा कर ख़ुदावन्द अपने ख़ुदा की बात सुने और वही काम करे जो उसकी नज़र में भला है और उसके हुक्मों को माने और उसके क़ानूनों पर 'अमल करे, तो मैं उन बीमारियों में से जो मैंने मिस्रियों पर भेजीं तुझ पर कोई न भेजूँगा क्यूँकि मैं ख़ुदावन्द तेरा शाफ़ी हूँ।” ");
INSERT INTO urd_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","फिर वह एलीम में आए जहाँ पानी के बारह चश्मे और खजूर के सत्तर दरख़्त थे, और वहीं पानी के क़रीब उन्होंने अपने ख़ेमे लगाए। ");
INSERT INTO urd_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","फिर वह एलीम से रवाना हुए और बनी — इस्राईल की सारी जमा'अत मुल्क — ए — मिस्र से निकलने के बाद दूसरे महीने की पंद्रहवीं तारीख़ को सीन के वीराने में जो एलीम और सीना के बीच है पहुँची। ");
INSERT INTO urd_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","और उस वीराने में बनी — इस्राईल की सारी जमा'अत मूसा और हारून पर बड़बड़ाने लगी। ");
INSERT INTO urd_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","और बनी — इस्राईल कहने लगे, “काश कि हम ख़ुदावन्द के हाथ से मुल्क — ए — मिस्र में जब ही मार दिए जाते जब हम गोश्त की हाँडियों के पास बैठ कर दिल भर कर रोटी खाते थे, क्यूँकि तुम तो हम को इस वीराने में इसीलिए ले आए हो कि सारे मजमे' को भूका मारो।” ");
INSERT INTO urd_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","तब ख़ुदावन्द ने मूसा से कहा, “मैं आसमान से तुम लोगों के लिए रोटियाँ बरसाऊँगा, फिर यह लोग निकल निकल कर सिर्फ़ एक — एक दिन का हिस्सा हर दिन बटोर लिया करें कि इस से मैं इनकी आज़माइश करूँगा कि वह मेरी शरी'अत पर चलेंगे या नहीं। ");
INSERT INTO urd_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","और छटे दिन ऐसा होगा कि जितना वह ला कर पकाएँगे वह उससे जितना रोज़ जमा' करते हैं दूना होगा।” ");
INSERT INTO urd_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","तब मूसा और हारून ने सब बनी — इस्राईल से कहा, कि “शाम को तुम जान लोगे कि जो तुम को मुल्क — ए — मिस्र से निकाल कर लाया है वह ख़ुदावन्द है। ");
INSERT INTO urd_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","और सुबह को तुम ख़ुदावन्द का जलाल देखोगे, क्यूँकि तुम जो ख़ुदावन्द पर बड़बड़ाने लगते हो उसे वह सुनता है। और हम कौन हैं जो तुम हम पर बड़बड़ाते हो?” ");
INSERT INTO urd_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","और मूसा ने यह भी कहा, कि “शाम को ख़ुदावन्द तुम को खाने को गोश्त और सुबह को रोटी पेट भर के देगा; क्यूँकि तुम जो ख़ुदावन्द पर बड़बड़ाते हो उसे वह सुनता है। और हमारी क्या हक़ीक़त है? तुम्हारा बड़बड़ाना हम पर नहीं बल्कि ख़ुदावन्द पर है।” ");
INSERT INTO urd_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","फिर मूसा ने हारून से कहा, कि “बनी इस्राईल की सारी जमा'अत से कह, कि तुम ख़ुदावन्द के नज़दीक आओ क्यूँकि उसने तुम्हारा बड़बड़ाना सुन लिया है।” ");
INSERT INTO urd_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","और जब हारून बनी — इस्राईल की जमा'अत से यह बातें कह रहा था, तो उन्होंने वीराने की तरफ़ नज़र की और उनको ख़ुदावन्द का जलाल बादल में दिखाई दिया। ");
INSERT INTO urd_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“मैंने बनी — इस्राईल का बड़बड़ाना सुन लिया है, इसलिए तू उनसे कह दे कि शाम को तुम गोश्त खाओगे और सुबह को तुम रोटी से सेर होगे, और तुम जान लोगे कि मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ।” ");
INSERT INTO urd_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","और यूँ हुआ कि शाम को इतनी बटेरें आईं कि उनकी खे़मागाह को ढाँक लिया, और सुबह को ख़ेमागाह के आस पास ओस पड़ी हुई थी। ");
INSERT INTO urd_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","और जब वह ओस जो पड़ी थी। सूख गई तो क्या देखते हैं, कि वीराने में एक छोटी — छोटी गोल गोल चीज़ ऐसी छोटी जैसे पाले के दाने होते हैं ज़मीन पर पड़ी है। ");
INSERT INTO urd_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","बनी — इस्राईल उसे देखकर आपस में कहने लगे, मन्न? क्यूँकि वह नहीं जानते थे कि वह क्या है। तब मूसा ने उनसे कहा, यह वही रोटी है जो ख़ुदावन्द ने खाने को तुम को दी है। ");
INSERT INTO urd_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","इसलिए ख़ुदावन्द का हुक्म यह है कि तुम उसे अपने — अपने खाने की मिक़्दार के मुवाफ़िक़ या'नी अपने — अपने आदमियों के शुमार के मुताबिक़ हर शख़्स एक ओमर जमा' करना, और हर शख्स़ उतने ही आदमियों के लिए जमा' करे जितने उसके ख़ेमे में हों। ");
INSERT INTO urd_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","चुनाँचे बनी — इस्राईल ने ऐसा ही किया और किसी ने ज़्यादा और किसी ने कम जमा' किया। ");
INSERT INTO urd_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","और जब उन्होंने उसे ओमर से नापा तो जिसने ज़्यादा जमा' किया था कुछ ज़्यादा न पाया और उसका जिसने कम जमा' किया था कम न हुआ। उनमें से हर एक ने अपने खाने की मिक़्दार के मुताबिक़ जमा' किया था। ");
INSERT INTO urd_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","और मूसा ने उनसे कह दिया था कि कोई उसमें से कुछ सुबह तक बाक़ी न छोड़े। ");
INSERT INTO urd_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","तोभी उन्होंने मूसा की बात न मानी बल्कि बा'ज़ों ने सुबह तक कुछ रहने दिया, इसलिए उसमें कीड़े पड़ गए और वह सड़ गया; तब मूसा उनसे नाराज़ हुआ। ");
INSERT INTO urd_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","और वह हर सुबह को अपने — अपने खाने की मिक़्दार के मुताबिक़ जमा' कर लेते थे और धूप तेज़ होते ही वह पिघल जाता था। ");
INSERT INTO urd_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","और छटे दिन ऐसा हुआ कि जितनी रोटी वह रोज़ जमा' करते थे उससे दूनी जमा' की या'नी हर शख़्स दो ओमर, और जमा'अत के सब सरदारों ने आकर यह मूसा को बताया। ");
INSERT INTO urd_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","उसने उनको कहा, कि “ख़ुदावन्द का हुक्म यह है कि कल ख़ास आराम का दिन या'नी ख़ुदावन्द का मुक़द्दस सबत है, जो तुम को पकाना हो पका लो और जो उबालना हो उबाल लो और वह जो बच रहे उसे अपने लिए सुबह तक महफ़ूज़ रख्खो।” ");
INSERT INTO urd_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","चुनाँचे उन्होंने जैसा मूसा ने कहा था उसे सुबह तक रहने दिया, और वह न तो सड़ा और न उसमें कीड़े पड़े। ");
INSERT INTO urd_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","और मूसा ने कहा कि आज उसी को खाओ क्यूँकि आज ख़ुदावन्द का सबत है, इसलिए वह आज तुम को मैदान में नहीं मिलेगा। ");
INSERT INTO urd_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","छ: दिन तक तुम उसे जमा' करना लेकिन सातवें दिन सबत है, उसमें वह नहीं मिलेगा। ");
INSERT INTO urd_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","और सातवें दिन ऐसा हुआ कि उनमें से कुछ आदमी मन बटोरने गए पर उनको कुछ नहीं मिला। ");
INSERT INTO urd_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","तब ख़ुदावन्द ने मूसा से कहा, कि “तुम लोग कब तक मेरे हुक्मों और शरी'अत के मानने से इन्कार करते रहोगे? ");
INSERT INTO urd_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","देखो, चूँकि ख़ुदावन्द ने तुम को सबत का दिन दिया है, इसीलिए वह तुम को छठे दिन दो दिन का खाना देता है। इसलिए तुम अपनी — अपनी जगह रहो और सातवें दिन कोई अपनी जगह से बाहर न जाए।” ");
INSERT INTO urd_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","चुनाँचे लोगों ने सातवें दिन आराम किया। ");
INSERT INTO urd_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","और बनी — इस्राईल ने उसका नाम मन्न रख्खा, और वह धनिये के बीज की तरह सफ़ेद और उसका मज़ा शहद के बने हुए पूए की तरह था। ");
INSERT INTO urd_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","और मूसा ने कहा, “ख़ुदावन्द यह हुक्म देता है, कि इसका एक ओमर भर कर अपनी नसल के लिए रख लो, ताकि वह उस रोटी को देखें जो मैंने तुम को वीराने में खिलाई जब मैं तुम को मुल्क — ए — मिस्र से निकाल कर लाया।” ");
INSERT INTO urd_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","और मूसा ने हारून से कहा, “एक मर्तबान ले और एक ओमर मन उसमें भर कर उसे ख़ुदावन्द के आगे रख दे, ताकि वह तुम्हारी नसल के लिए रख्खा रहे।” ");
INSERT INTO urd_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","और जैसा ख़ुदावन्द ने मूसा को हुक्म दिया था उसी के मुताबिक़ हारून ने उसे शहादत के सन्दूक के आगे रख दिया ताकि वह रख्खा रहे। ");
INSERT INTO urd_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","और बनी — इस्राईल जब तक आबाद मुल्क में न आए या'नी चालीस बरस तक मन्न खाते रहे, अलग़रज़ जब तक वह मुल्क — ए — कना'न की हद तक न आए मन्न खाते रहे। ");
INSERT INTO urd_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","और एक ओमर ऐफ़ा का दसवाँ हिस्सा है। ");
INSERT INTO urd_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","फिर बनी — इस्राईल की सारी जमा'अत सीन के वीराने से चली और ख़ुदावन्द के हुक्म के मुताबिक़ सफ़र करती हुई रफ़ीदीम में आकर ख़ेमा लगाया; वहाँ उन लोगों के पीने को पानी न मिला। ");
INSERT INTO urd_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","वहाँ वह लोग मूसा से झगड़ा करके कहने लगे, कि “हम को पीने को पानी दे।” मूसा ने उनसे कहा, कि “तुम मुझ से क्यूँ झगड़ते हो और ख़ुदावन्द को क्यूँ आज़माते हो?” ");
INSERT INTO urd_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","वहाँ उन लोगों को बड़ी प्यास लगी, तब वह लोग मूसा पर बड़बड़ाने लगे और कहा, कि तू हम को और हमारे बच्चों और चौपायों को प्यासा मारने के लिए हम लोगों को क्यूँ मुल्क — ए — मिस्र से निकाल लाया? ");
INSERT INTO urd_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","मूसा ने ख़ुदावन्द से फ़रियाद करके कहा कि मैं इन लोगों से क्या करूँ? वह सब तो अभी मुझे संगसार करने को तैयार हैं। ");
INSERT INTO urd_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","ख़ुदावन्द ने मूसा से कहा कि लोगों के आगे होकर चल और बनी — इस्राईल के बुज़ुर्गों में से कुछ को अपने साथ ले ले और जिस लाठी से तूने दरिया पर मारा था उसे अपने हाथ में लेता जा। ");
INSERT INTO urd_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","देख, मैं तेरे आगे जाकर वहाँ होरिब की एक चट्टान पर खड़ा रहूँगा, और तू उस चट्टान पर मारना तो उसमें से पानी निकलेगा कि यह लोग पिएँ। चुनाँचे मूसा ने बनी — इस्राईल के बुज़ुर्गों के सामने यही किया, ");
INSERT INTO urd_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","और उसने उस जगह का नाम मस्सा और मरीबा रख्खा; क्यूँकि बनी — इस्राईल ने वहाँ झगड़ा किया और यह कह कर ख़ुदावन्द का इम्तिहान किया, “ख़ुदावन्द हमारे बीच में है या नहीं?” ");
INSERT INTO urd_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","तब 'अमालीक़ी आकर रफ़ीदीम में बनी — इस्राईल से लड़ने लगे। ");
INSERT INTO urd_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","और मूसा ने यशू'अ से कहा, “हमारी तरफ़ के कुछ आदमी चुन कर ले जा और 'अमालीक़ियों से लड़, और मैं कल ख़ुदा की लाठी अपने हाथ में लिए हुए पहाड़ की चोटी पर खड़ा रहूँगा।” ");
INSERT INTO urd_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","फिर मूसा के हुक्म के मुताबिक़ यशू'अ 'अमालीक़ियों से लड़ने लगा, और मूसा और हारून और हूर पहाड़ की चोटी पर चढ़ गए। ");
INSERT INTO urd_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","और जब तक मूसा अपना हाथ उठाए रहता था बनी — इस्राईल ग़ालिब रहते थे, और जब वह हाथ लटका देता था तब 'अमालीक़ी ग़ालिब होते थे। ");
INSERT INTO urd_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","और जब मूसा के हाथ भर गए तो उन्होंने एक पत्थर लेकर मूसा के नीचे रख दिया और वह उस पर बैठ गया, और हारून और हूर एक इधर से दूसरा उधर से उसके हाथों को संभाले रहे। तब उसके हाथ आफ़ताब के गु़रूब होने तक मज़बूती से उठे रहे। ");
INSERT INTO urd_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","और यशू'अ ने 'अमालीक़ और उसके लोगों की तलवार की धार से शिकस्त दी। ");
INSERT INTO urd_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","तब ख़ुदावन्द ने मूसा से कहा, “इस बात की यादगारी के लिए किताब में लिख दे और यशू'अ को सुना दे कि मैं 'अमालीक़ का नाम — ओ — निशान दुनिया से बिल्कुल मिटा दूँगा।” ");
INSERT INTO urd_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","और मूसा ने एक क़ुर्बानगाह बनाई और उसका नाम 'यहोवा निस्सी' रख्खा। ");
INSERT INTO urd_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","और उसने कहा ख़ुदावन्द ने क़सम खाई है; इसलिए ख़ुदावन्द 'अमालीक़ियों से नसल दर नसल जंग करता रहेगा। ");
INSERT INTO urd_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","और जो कुछ ख़ुदावन्द ने मूसा और अपनी क़ौम इस्राईल के लिए किया और जिस तरह से ख़ुदावन्द ने इस्राईल को मिस्र से निकाला, सब मूसा के ससुर यित्रो ने जो मिदियान का काहिन था सुना। ");
INSERT INTO urd_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","और मूसा के ससुर यित्रो ने मूसा की बीवी सफ़्फूरा को जो मायके भेज दी गई थी, ");
INSERT INTO urd_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","और उसके दोनों बेटों को साथ लिया। इनमें से एक का नाम मूसा ने यह कह कर जैरसोम रख्खा था कि “मैं परदेस में मुसाफ़िर हूँ।” ");
INSERT INTO urd_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","और दूसरे का नाम यह कह कर इली'एलियाज़र रख्खा था कि “मेरे बाप का ख़ुदा मेरा मददगार हुआ, और उसने मुझे फ़िर'औन की तलवार से बचाया।” ");
INSERT INTO urd_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","और मूसा का ससुर यित्रो उसके बेटों और बीवी को लेकर मूसा के पास उस वीराने में आया, जहाँ ख़ुदा के पहाड़ के पास उसका ख़ेमा लगा था, ");
INSERT INTO urd_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","और मूसा से कहा, कि “मैं तेरा ससुर यित्रो तेरी बीवी को और उसके साथ उसके दोनों बेटों को लेकर तेरे पास आया हूँ।” ");
INSERT INTO urd_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","तब मूसा अपने ससुर से मिलने को बाहर निकला और कोर्निश बजा लाकर उसको चूमा, और वह एक दूसरे की ख़ैर — ओ — 'आफ़ियत पूछते हुए ख़ेमे में आए। ");
INSERT INTO urd_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","और मूसा ने अपने ससुर को बताया कि ख़ुदावन्द ने इस्राईल की ख़ातिर फ़िर'औन के साथ क्या क्या किया, और इन लोगों पर रास्ते में क्या — क्या मुसीबतें पड़ीं और ख़ुदावन्द उनको किस किस तरह बचाता आया। ");
INSERT INTO urd_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","और यित्रो इन सब एहसानों की वजह से जो ख़ुदावन्द ने इस्राईल पर किए कि उनको मिस्रियों के हाथ से नजात बख़्शी बहुत ख़ुश हुआ। ");
INSERT INTO urd_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","और यित्रो ने कहा, “ख़ुदावन्द मुबारक हो, जिसने तुम को मिस्रियों के हाथ और फ़िर'औन के हाथ से नजात बख़्शी, और जिसने इस क़ौम को मिस्रियों के पंजे से छुड़ाया। ");
INSERT INTO urd_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","अब मैं जान गया कि ख़ुदावन्द सब मा'बूदों से बड़ा है, क्यूँकि वह उन कामों में जो उन्होंने गु़रूर से किए उन पर ग़ालिब हुआ।” ");
INSERT INTO urd_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","और मूसा के ससुर यित्रो ने ख़ुदा के लिए सोख़्तनी क़ुर्बानी और ज़बीहे चढ़ाए, और हारून और इस्राईल के सब बुज़ुर्ग़ मूसा के ससुर के साथ ख़ुदा के सामने खाना खाने आए। ");
INSERT INTO urd_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","और दूसरे दिन मूसा लोगों की 'अदालत करने बैठा और लोग मूसा के आसपास सुबह से शाम तक खड़े रहे। ");
INSERT INTO urd_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","और जब मूसा के ससुर ने सब कुछ जो वह लोगों के लिए करता था देख लिया तो उससे कहा, “यह क्या काम है जो तू लोगों के लिए करता है? तू क्यूँ आप अकेला बैठता है और सब लोग सुबह से शाम तक तेरे आस — पास खड़े रहते हैं?” ");
INSERT INTO urd_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","मूसा ने अपने ससुर से कहा, “इसकी वजह यह है कि लोग मेरे पास ख़ुदा से मा'लूम करने के लिए आते हैं। ");
INSERT INTO urd_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","जब उनमें कुछ झगड़ा होता है तो वह मेरे पास आते हैं, और मैं उनके बीच इन्साफ़ करता और ख़ुदा के अहकाम और शरी'अत उनको बताता हूँ।” ");
INSERT INTO urd_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","तब मूसा के ससुर ने उससे कहा, कि “तू अच्छा काम नहीं करता। ");
INSERT INTO urd_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","इससे तू क्या बल्कि यह लोग भी जो तेरे साथ हैं क़त'ई घुल जाएँगे, क्यूँकि यह काम तेरे लिए बहुत भारी है। ");
INSERT INTO urd_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","तू अकेला इसे नहीं कर सकता। इसलिए अब तू मेरी बात सुन, मैं तुझे सलाह देता हूँ और ख़ुदा तेरे साथ रहे! तू इन लोगों के लिए ख़ुदा के सामने जाया कर और इनके सब मु'आमिले ख़ुदा के पास पहुँचा दिया कर। ");
INSERT INTO urd_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","और तू रिवायतों और शरी'अत की बातें इनको सिखाया कर, और जिस रास्ते इनको चलना और जो काम इनको करना हो वह इनको बताया कर। ");
INSERT INTO urd_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","और तू इन लोगों में से ऐसे लायक़ शख़्सों को चुन ले जो ख़ुदातरस और सच्चे और रिश्वत के दुश्मन हों, और उनको हज़ार — हज़ार और सौ — सौ और पचास — पचास और दस — दस आदमियों पर हाकिम बना दे; ");
INSERT INTO urd_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","कि वह हर वक़्त लोगों का इन्साफ़ किया करें और ऐसा हो कि बड़े — बड़े मुक़द्दमें तो वह तेरे पास लाएँ और छोटी — छोटी बातों का फ़ैसला ख़ुद ही कर दिया करें। यूँ तेरा बोझ हल्का हो जाएगा और वह भी उसके उठाने में तेरे शरीक होंगे। ");
INSERT INTO urd_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","अगर तू यह काम करे और ख़ुदा भी तुझे ऐसा ही हुक्म दे, तो तू सब कुछ झेल सकेगा और यह लोग भी अपनी जगह इत्मीनान से जाएँगे।” ");
INSERT INTO urd_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","और मूसा ने अपने ससुर की बात मान कर जैसा उसने बताया था वैसा ही किया। ");
INSERT INTO urd_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","चुनाँचे मूसा ने सब इस्राईलियों में से लायक़ शख़्सों को चुना और उन को हज़ार — हज़ार और सौ — सौ और पचास — पचास और दस — दस आदमियों के ऊपर हाकिम मुक़र्रर किया। ");
INSERT INTO urd_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","इसलिए यही हर वक़्त लोगों का इन्साफ़ करने लगे, मुश्किल मुक़द्दमात तो वह मूसा के पास ले आते थे पर छोटी — छोटी बातों का फ़ैसला ख़ुद ही कर देते थे। ");
INSERT INTO urd_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","फिर मूसा ने अपने ससुर को रुख़्सत किया और वह अपने वतन को रवाना हो गया। ");
INSERT INTO urd_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","और बनी — इस्राईल को जिस दिन मुल्क — ए — मिस्र से निकले तीन महीने हुए उसी दिन वह सीना के वीराने में आए। ");
INSERT INTO urd_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","और जब वह रफ़ीदीम से रवाना होकर सीना के वीरान में आए तो वीरान ही में ख़ेमे लगा लिए, इसलिए वहीं पहाड़ के सामने इस्राईलियों के डेरे लगे। ");
INSERT INTO urd_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","और मूसा उस पर चढ़ कर ख़ुदा के पास गया और ख़ुदावन्द ने उसे पहाड़ पर से पुकार कर कहा, “तू या'क़ूब के ख़ान्दान से यूँ कह और बनी — इस्राईल को यह सुना दे: ");
INSERT INTO urd_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","'तुम ने देखा कि मैंने मिस्रियों से क्या — क्या किया, और तुम को जैसे 'उक़ाब के परों पर बैठा कर अपने पास ले आया। ");
INSERT INTO urd_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","इसलिए अब अगर तुम मेरी बात मानो और मेरे 'अहद पर चलो तो सब क़ौमों में से तुम ही मेरी ख़ास मिल्कियत ठहरोगे क्यूँकि सारी ज़मीन मेरी है। ");
INSERT INTO urd_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","और तुम मेरे लिए काहिनों की एक मम्लुकत और एक मुक़द्दस क़ौम होगे, इन्हीं बातों को तू बनी — इस्राईल को सुना देना।” ");
INSERT INTO urd_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","तब मूसा ने आ कर और उन लोगों के बुज़ुर्गों को बुलाकर उनके आमने — सामने वह सब बातें जो ख़ुदावन्द ने उसे फ़रमाई थीं बयान कीं। ");
INSERT INTO urd_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","और सब लोगों ने मिल कर जवाब दिया, “जो कुछ ख़ुदावन्द ने फ़रमाया है वह सब हम करेंगे।” और मूसा ने लोगों का जवाब ख़ुदावन्द को जाकर सुनाया। ");
INSERT INTO urd_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","और ख़ुदावन्द ने मूसा से कहा, कि “देख, मैं काले बादल में इसलिए तेरे पास आता हूँ कि जब मैं तुझ से बातें करूँ तो यह लोग सुनें और हमेशा तेरा यक़ीन करें।” और मूसा ने लोगों की बातें ख़ुदावन्द से बयान कीं। ");
INSERT INTO urd_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","और ख़ुदावन्द ने मूसा से कहा, “लोगों के पास जा, और आज और कल उनको पाक कर, और वह अपने कपड़े धो लें, ");
INSERT INTO urd_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","और तीसरे दिन तैयार रहें, क्यूँकि ख़ुदावन्द तीसरे दिन सब लोगों के देखते देखते कोह-ए-सीना पर उतरेगा। ");
INSERT INTO urd_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","और तू लोगों के लिए चारों तरफ़ हद बाँध कर उनसे कह देना, ख़बरदार तुम न तो इस पहाड़ पर चढ़ना और न इसके दामन को छूना; जो कोई पहाड़ को छुए ज़रूर जान से मार डाला जाए। ");
INSERT INTO urd_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","मगर उसे कोई हाथ न लगाए बल्कि वह ला — कलाम संगसार किया जाए, या तीर से छेदा जाए चाहे वह इंसान हो चाहे हैवान, वह जीता न छोड़ा जाए; और जब नरसिंगा देर तक फूंका जाए तो वह सब पहाड़ के पास आ जाएँ।” ");
INSERT INTO urd_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","तब मूसा पहाड़ पर से उतरकर लोगों के पास गया और उसने लोगों को पाक साफ़ किया, और उन्होंने अपने कपड़े धो लिए। ");
INSERT INTO urd_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","और उसने लोगों से कहा कि “तीसरे दिन तैयार रहना और 'औरत के नज़दीक न जाना।” ");
INSERT INTO urd_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","जब तीसरा दिन आया तो सुबह होते ही बादल गरजने और बिजली चमकने लगी, और पहाड़ पर काली घटा छा गई और करना की आवाज़ बहुत बुलन्द हुई और सब लोग ख़ेमों में काँप गए। ");
INSERT INTO urd_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","और मूसा लोगों को ख़ेमा गाह से बाहर लाया कि ख़ुदा से मिलाए, और वह पहाड़ से नीचे आ खड़े हुए। ");
INSERT INTO urd_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","और कोह-ए-सीना ऊपर से नीचे तक धुएँ से भर गया क्यूँकि ख़ुदावन्द शोले में होकर उस पर उतरा, और धुआँ तनूर के धुएँ की तरह ऊपर को उठ रहा था और वह सारा पहाड़ ज़ोर से हिल रहा था। ");
INSERT INTO urd_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","और जब करना की आवाज़ निहायत ही बुलन्द होती गई तो मूसा बोलने लगा और ख़ुदा ने आवाज़ के ज़रिए' से उसे जवाब दिया। ");
INSERT INTO urd_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","और ख़ुदावन्द कोह-ए-सीना की चोटी पर उतरा, और ख़ुदावन्द ने पहाड़ की चोटी पर मूसा को बुलाया; तब मूसा ऊपर चढ़ गया। ");
INSERT INTO urd_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","और ख़ुदावन्द ने मूसा से कहा, “नीचे उतर कर लोगों को ताकीदन समझा देता ऐसा न हो कि वह देखने के लिए हदों को तोड़ कर ख़ुदावन्द के पास आ जाएँ और उनमें से बहुत से हलाक हो जाएँ। ");
INSERT INTO urd_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","और काहिन भी जो ख़ुदावन्द के नज़दीक आया करते हैं अपने आपको पाक करें, कहीं ऐसा न हो कि ख़ुदावन्द उन पर टूट पड़े।” ");
INSERT INTO urd_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","तब मूसा ने ख़ुदावन्द से कहा, “लोग कोह-ए-सीना पर नहीं चढ़ सकते क्यूँकि तूने तो हम को ताकीदन कहा है, कि पहाड़ के चौगिर्द हद बन्दी करके उसे पाक रख्खो।” ");
INSERT INTO urd_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","ख़ुदावन्द ने उसे कहा, नीचे उतर जा, और हारून को अपने साथ लेकर ऊपर आ; लेकिन काहिन और अवाम हदें तोड़कर ख़ुदावन्द के पास ऊपर न आए, ऐसा न हो कि वह उन पर टूट पड़े। ");
INSERT INTO urd_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","चुनाँचे मूसा नीचे उतर कर लोगों के पास गया और यह बातें उन को बताई। ");
INSERT INTO urd_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","और ख़ुदा ने यह सब बातें फ़रमाई कि ");
INSERT INTO urd_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“ख़ुदावन्द तेरा ख़ुदा जो तुझे मुल्क — ए — मिस्र से और ग़ुलामी के घर से निकाल लाया मैं हूँ। ");
INSERT INTO urd_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“मेरे सामने तू गै़र मा'बूदों को न मानना। ");
INSERT INTO urd_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“तू अपने लिए कोई तराशी हुई मूरत न बनाना, न किसी चीज़ की सूरत बनाना जो ऊपर आसमान में या नीचे ज़मीन पर या ज़मीन के नीचे पानी में है। ");
INSERT INTO urd_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","तू उनके आगे सिज्दा न करना और न उनकी इबादत करना, क्यूँकि मैं ख़ुदावन्द तेरा ख़ुदा ग़य्यूर ख़ुदा हूँ और जो मुझ से 'अदावत रखते हैं उनकी औलाद को तीसरी और चौथी नसल तक बाप दादा की बदकारी की सज़ा देता हूँ। ");
INSERT INTO urd_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","और हज़ारों पर जो मुझ से मुहब्बत रखते और मेरे हुक्मों को मानते हैं। रहम करता हूँ। ");
INSERT INTO urd_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“तू ख़ुदावन्द अपने ख़ुदा का नाम बेफ़ाइदा न लेना, क्यूँकि जो उसका नाम बेफ़ायदा लेता है ख़ुदावन्द उसे बेगुनाह न ठहराएगा। ");
INSERT INTO urd_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“याद कर कि तू सबत का दिन पाक मानना। ");
INSERT INTO urd_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","छ: दिन तक तू मेहनत करके अपना सारा काम — काज करना। ");
INSERT INTO urd_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","लेकिन सातवाँ दिन ख़ुदावन्द तेरे ख़ुदा का सबत है; उसमें न तू कोई काम करे न तेरा बेटा, न तेरी बेटी, न तेरा गु़लाम, न तेरी लोंडी, न तेरा चौपाया, न कोई मुसाफ़िर जो तेरे यहाँ तेरे फाटकों के अन्दर हो ");
INSERT INTO urd_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","क्यूँकि ख़ुदावन्द ने छ: दिन में आसमान और ज़मीन और समन्दर और जो कुछ उनमें है वह सब बनाया, और सातवें दिन आराम किया; इसलिए ख़ुदावन्द ने सबत के दिन को बरकत दी और उसे पाक ठहराया। ");
INSERT INTO urd_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“तू अपने बाप और अपनी माँ की इज़्ज़त करना ताकि तेरी उम्र उस मुल्क में जो ख़ुदावन्द तेरा ख़ुदा तुझे देता है दराज़ हो। ");
INSERT INTO urd_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“तू ख़ून न करना। ");
INSERT INTO urd_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“तू ज़िना न करना। ");
INSERT INTO urd_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“तू चोरी न करना। ");
INSERT INTO urd_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“तू अपने पड़ोसी के खिलाफ़ झूटी गवाही न देना। ");
INSERT INTO urd_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“तू अपने पड़ोसी के घर का लालच न करना; तू अपने पड़ोसी की बीवी का लालच न करना, और न उसके ग़ुलाम और उसकी लौंडी और उसके बैल और उसके गधे का, और न अपने पड़ोसी की किसी और चीज़ का लालच करना।” ");
INSERT INTO urd_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","और सब लोगों ने बादल गरजते और बिजली चमकते और करना की आवाज़ होते और पहाड़ से धुआँ उठते देखा, और जब लोगों ने यह देखा तो काँप उठे और दूर खड़े हो गए; ");
INSERT INTO urd_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","और मूसा से कहने लगे, “तू ही हम से बातें किया कर और हम सुन लिया करेंगे; लेकिन ख़ुदा हम से बातें न करे, ऐसा न हो कि हम मर जाएँ।” ");
INSERT INTO urd_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","मूसा ने लोगों से कहा, “तुम डरो मत, क्यूँकि ख़ुदा इसलिए आया है कि तुम्हारा इम्तिहान करे और तुम को उसका ख़ौफ़ हो ताकि तुम गुनाह न करो।” ");
INSERT INTO urd_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","और वह लोग दूर ही खड़े रहे और मूसा उस गहरी तारीकी के नज़दीक गया जहाँ ख़ुदा था। ");
INSERT INTO urd_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","और ख़ुदावन्द ने मूसा से कहा, तू बनी — इस्राईल से यह कहना कि 'तुम ने ख़ुद देखा कि मैंने आसमान पर से तुम्हारे साथ बातें कीं। ");
INSERT INTO urd_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","तुम मेरे साथ किसी को शरीक न करना, या'नी चाँदी या सोने के देवता अपने लिए न गढ़ लेना। ");
INSERT INTO urd_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","और तू मिट्टी की एक क़ुर्बानगाह मेरे लिए बनाया करना, और उस पर अपनी भेंड़ बकरियों और गाय — बैल की सोख़्तनी कु़र्बानियाँ और सलामती की क़ुर्बानियाँ पेश करना और जहाँ — जहाँ मैं अपने नाम की यादगारी कराऊँगा वहाँ मैं तेरे पास आकर तुझे बरकत दूँगा। ");
INSERT INTO urd_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","और अगर तू मेरे लिए पत्थर की क़ुर्बानगाह बनाए तो तराशे हुए पत्थर से न बनाना, क्यूँकि अगर तू उस पर अपने औज़ार लगाए तो तू उसे नापाक कर देगा। ");
INSERT INTO urd_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","और तू मेरी क़ुर्बानगाह पर सीढ़ियों से हरगिज़ न चढ़ना ऐसा न हो कि तेरा नंगापन उस पर ज़ाहिर हो। ");
INSERT INTO urd_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“वह अहकाम जो तुझे उनको बताने हैं यह हैं: ");
INSERT INTO urd_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","अगर तू कोई 'इब्रानी ग़ुलाम ख़रीदे तो वह छ: बरस ख़िदमत करे और सातवें बरस मुफ़्त आज़ाद होकर चला जाए। ");
INSERT INTO urd_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","अगर वह अकेला आया हो तो अकेला ही चला जाए और अगर वह शादी शुदा हो तो उसकी बीवी भी उसके साथ जाए। ");
INSERT INTO urd_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","अगर उसके आक़ा ने उसकी शादी कराया हो और उस 'औरत के उससे बेटे और बेटियाँ हुई हों तो वह 'औरत और उसके बच्चे उस आक़ा के होकर रहें और वह अकेला चला जाए। ");
INSERT INTO urd_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","पर अगर वह ग़ुलाम साफ़ कह दे कि मैं अपने आक़ा से और अपनी बीवी और बच्चों से मुहब्बत रखता हूँ, मैं आज़ाद होकर नहीं जाऊँगा। ");
INSERT INTO urd_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","तो उसका आक़ा उसे ख़ुदा के पास ले जाए, और उसे दरवाज़े पर या दरवाज़े की चौखट पर लाकर सुतारी से उसका कान छेदे; तब वह हमेशा उसकी खि़दमत करता रहे। ");
INSERT INTO urd_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","'और अगर कोई शख़्स अपनी बेटी को लौंडी होने के लिए बेच डाले तो वह गु़लामों की तरह चली न जाए। ");
INSERT INTO urd_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","अगर उसका आक़ा जिसने उससे निस्बत की है उससे ख़ुश न हो, तो वह उसका फ़िदिया मंजूर करे पर उसे यह इख़्तियार न होगा कि उसको किसी अजनबी क़ौम के हाथ बेचे, क्यूँकि उसने उससे दग़ाबाज़ी की। ");
INSERT INTO urd_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","और अगर वह उसकी निस्बत अपने बेटे से कर दे तो वह उससे बेटियों का सा सुलूक करे। ");
INSERT INTO urd_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","अगर वह दूसरी 'औरत कर ले तो भी वह उसके खाने, कपड़े और शादी के फ़र्ज़ में क़ासिर न हो। ");
INSERT INTO urd_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","और अगर वह उससे यह तीनों बातें न करे तो वह मुफ़्त बे — रुपये दिए चली जाए। ");
INSERT INTO urd_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","'अगर कोई किसी आदमी को ऐसा मारे कि वह मर जाए तो वह क़तई' जान से मारा जाए। ");
INSERT INTO urd_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","लेकिन अगर वह शख़्स घात लगाकर न बैठा हो बल्कि ख़ुदा ही ने उसे उसके हवाले कर दिया हो, तो मैं ऐसे हाल में एक जगह बता दूँगा जहाँ वह भाग जाए। ");
INSERT INTO urd_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","और अगर कोई दीदा — ओ — दानिस्ता अपने पड़ोसी पर चढ़ आए ताकि उसे धोखे से मार डाले, तो तू उसे मेरी क़ुर्बानगाह से जुदा कर देना ताकि वह मारा जाए। ");
INSERT INTO urd_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“और जो कोई अपने बाप या अपनी माँ को मारे वह क़तई' जान से मारा जाए। ");
INSERT INTO urd_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“और जो कोई किसी आदमी को चुराए चाहे वह उसे बेच डाले चाहे वह उसके यहाँ मिले, वह क़तई' मार डाला जाए। ");
INSERT INTO urd_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","'और जो अपने बाप या अपनी माँ पर ला'नत करे वह क़तई' मार डाला जाए। ");
INSERT INTO urd_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“और अगर दो शख़्स झगड़ें और एक दूसरे को पत्थर या मुक्का मारे और वह मरे तो नहीं पर बिस्तर पर पड़ा रहे, ");
INSERT INTO urd_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","तो जब वह उठ कर अपनी लाठी के सहारे बाहर चलने — फिरने लगे, तब वह जिसने मारा था बरी हो जाए और सिर्फ़ उसका हरजाना भर दे और उसका पूरा 'इलाज करा दे। ");
INSERT INTO urd_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“और अगर कोई अपने ग़ुलाम या लौंडी को लाठी से ऐसा मारे कि वह उसके हाथ से मर जाए तो उसे ज़रूर सज़ा दी जाए। ");
INSERT INTO urd_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","लेकिन अगर वह एक — दो दिन जीता रहे तो आक़ा को सज़ा न दी जाए, इसलिए कि वह ग़ुलाम उसका माल है। ");
INSERT INTO urd_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“अगर लोग आपस में मार पीट करें और किसी हामिला को ऐसी चोट पहुँचाएँ कि उसे इस्क़ात हो जाए, लेकिन और कोई नुक़्सान न हो तो उससे जितना जुर्माना उसका शौहर तजवीज़ करे लिया जाए, और वह जिस तरह क़ाज़ी फ़ैसला करें जुर्माना भर दे। ");
INSERT INTO urd_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","लेकिन अगर नुक़्सान हो जाए तो तू जान के बदले जान ले, ");
INSERT INTO urd_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","और आँख के बदले आँख, दाँत के बदले दाँत, और हाथ के बदले हाथ, पाँव के बदले पाँव, ");
INSERT INTO urd_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","जलाने के बदले जलाना, ज़ख़्म के बदले ज़ख़्म और चोट के बदले चोट। ");
INSERT INTO urd_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“और अगर कोई अपने ग़ुलाम या अपनी लौंडी की आँख पर ऐसा मारे कि वह फूट जाए, तो वह उसकी आँख के बदले उसे आज़ाद कर दे। ");
INSERT INTO urd_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","अगर कोई अपने ग़ुलाम या अपनी लौंडी का दाँत मार कर तोड़ दे, तो वह उसके दाँत के बदले उसे आज़ाद कर दे। ");
INSERT INTO urd_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","'अगर बैल किसी मर्द या 'औरत को ऐसा सींग मारे कि वह मर जाए, तो वह बैल ज़रूर संगसार किया जाय और उसका गोश्त खाया न जाए, लेकिन बैल का मालिक बेगुनाह ठहरे। ");
INSERT INTO urd_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","लेकिन अगर उस बैल की पहले से सींग मारने की 'आदत थी और उसके मालिक को बता भी दिया गया था तोभी उसने उसे बाँध कर नहीं रख्खा, और उसने किसी मर्द या'औरत को मार दिया हो तो बैल संगसार किया जाए और उसका मालिक भी मारा जाए। ");
INSERT INTO urd_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","और अगर उससे ख़ूनबहा माँगा जाए, तो उसे अपनी जान के फ़िदिया में जितना उसके लिए ठहराया जाए उतना ही देना पड़ेगा। ");
INSERT INTO urd_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","चाहे उसने किसी के बेटे को मारा हो या बेटी को, इसी हुक्म के मुवाफ़िक़ उसके साथ 'अमल किया जाए। ");
INSERT INTO urd_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","अगर बैल किसी के ग़ुलाम या लौंडी को सींग से मारे तो मालिक उस ग़ुलाम या लौंडी के मालिक को तीस मिस्काल रुपये दे और बैल संगसार किया जाए। ");
INSERT INTO urd_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","'और अगर कोई आदमी गढ़ा खोले या खोदे और उसका मुँह न ढाँपे, और कोई बैल या गधा उसमें गिर जाए; ");
INSERT INTO urd_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","तो गढ़े का मालिक इसका नुक़्सान भर दे और उनके मालिक को क़ीमत दे और मरे हुए जानवर को ख़ुद ले ले। ");
INSERT INTO urd_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“और अगर किसी का बैल दूसरे के बैल को ऐसी चोट पहुँचाए के वह मर जाए, तो वह जीते बैल को बेचें और उसका दाम आधा आधा आपस में बाँट लें और इस मरे हुए बैल को भी ऐसे ही बाँट लें। ");
INSERT INTO urd_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","और अगर मा'लूम हो जाए कि उस बैल की पहले से सींग मारने की 'आदत थी और उसके मालिक ने उसे बाँध कर नहीं रख्खा, तो उसे क़तई' बैल के बदले बैल देना होगा और वह मरा हुआ जानवर उसका होगा। ");
INSERT INTO urd_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“अगर कोई आदमी बैल या भेड़ चुरा ले और उसे ज़बह कर दे या बेच डाले, तो वह एक बैल के बदले पाँच बैल और एक भेड़ के बदले चार भेड़े भरे। ");
INSERT INTO urd_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","अगर चोर सेंध मारते हुए पकड़ा जाए और उस पर ऐसी मार पड़े कि वह मर जाए तो उसके ख़ून का कोई जुर्म नहीं। ");
INSERT INTO urd_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","अगर सूरज निकल चुके तो उसका ख़ून जुर्म होगा; बल्कि उसे नुक़्सान भरना पड़ेगा और अगर उसके पास कुछ न हो तो वह चोरी के लिए बेचा जाए। ");
INSERT INTO urd_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","अगर चोरी का माल उसके पास जीता मिले चाहे वह बैल हो या गधा या भेड़ तो वह उसका दूना भर दे। ");
INSERT INTO urd_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","'अगर कोई आदमी किसी खेत या ताकिस्तान को खिलवा दे और अपने जानवर को छोड़ दे कि वह दूसरे के खेत को चर लें, तो अपने खेत या ताकिस्तान की अच्छी से अच्छी पैदावार में से उसका मु'आवज़ा दे। ");
INSERT INTO urd_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","'अगर आग भड़के और काँटों में लग जाए और अनाज के ढेर या खड़ी फ़सल या खेत को जला कर भस्म कर दे, तो जिस ने आग जलाई हो वह ज़रूर मु'आवज़ा दे। ");
INSERT INTO urd_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“अगर कोई अपने पड़ोसी की नक़द या जिन्स रखने को दे और वह उस शख़्स के घर से चोरी हो जाए, तो अगर चोर पकड़ा जाए तो दूना उसको भरना पड़ेगा। ");
INSERT INTO urd_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","लेकिन अगर चोर पकड़ा न जाए तो उस घर का मालिक ख़ुदा के आगे लाया जाए, ताकि मालूम हो जाए कि उसने अपने पड़ोसी के माल को हाथ नहीं लगाया। ");
INSERT INTO urd_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","हर क़िस्म की ख़ियानत के मु'आमिले में चाहे बैल का चाहे गधे या भेड़ या कपड़े या किसी और खोई हुई चीज़ का हो, जिसकी निस्बत कोई बोल उठे कि वह चीज़ यह है तो फ़रीक़ीन का मुक़द्दमा ख़ुदा के सामने लाया जाए और जिसे ख़ुदा मुजरिम ठहराए वह अपने पड़ोसी को दूना भर दे। ");
INSERT INTO urd_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","'अगर कोई अपने पड़ोसी के पास गधा या बैल या भेड़ या कोई और जानवर अमानत रख्खे और वह बगै़र किसी के देखे मर जाए या चोट खाए या हंका दिया जाए, ");
INSERT INTO urd_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","तो उन दोनों के बीच ख़ुदावन्द की क़सम हो कि उसने अपने हमसाये के माल को हाथ नहीं लगाया, और मालिक इसे सच माने और दूसरा उसका मु'आवज़ा न दे। ");
INSERT INTO urd_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","लेकिन अगर वह उसके पास से चोरी हो जाए तो वह उसके मालिक को मु'आवज़ा दे। ");
INSERT INTO urd_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","और अगर उसको किसी दरिन्दे ने फाड़ डाला हो तो वह उसको गवाही के तौर पर पेश कर दे और फाड़े हुए का नुक़्सान न भरे। ");
INSERT INTO urd_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","'अगर कोई शख़्स अपने पड़ोसी से कोई जानवर 'आरियत ले और वह ज़ख़्मी हो जाए या मर जाए, और मालिक वहाँ मौजूद न हो तो वह ज़रूर उसका मु'आवज़ा दे। ");
INSERT INTO urd_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","लेकिन अगर मालिक साथ हो तो उसका नुक़्सान न भरे और अगर किराया की हुई चीज़ हो तो उसका नुक़्सान उसके किराये में आ गया। ");
INSERT INTO urd_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“अगर कोई आदमी किसी कुँवारी को जिसकी निस्बत न हुई हो, फुसला कर उससे मुबाश्रत करे तो वह ज़रूर ही उसे महर देकर उससे शादी करे। ");
INSERT INTO urd_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","लेकिन अगर उसका बाप हरगिज़ राज़ी न हो कि उस लड़की को उसे दे, तो वह कुँवारियों के महर के मुवाफ़िक़ उसे नक़दी दे। ");
INSERT INTO urd_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“तू जादूगरनी को जीने न देना। ");
INSERT INTO urd_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“जो कोई किसी जानवर से मुबाश्रत करे वह क़तई' जान से मारा जाए। ");
INSERT INTO urd_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“जो कोई एक ख़ुदावन्द को छोड़ कर किसी और मा'बूद के आगे क़ुर्बानी चढ़ाए वह बिल्कुल नाबूद कर दिया जाए। ");
INSERT INTO urd_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“और तू मुसाफ़िर को न तो सताना न उस पर सितम करना, इस लिए के तुम भी मुल्क — ए — मिस्र में मुसाफ़िर थे। ");
INSERT INTO urd_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","तुम किसी बेवा या यतीम लड़के को दुख न देना। ");
INSERT INTO urd_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","अगर तू उनको किसी तरह से दुख दे और वह मुझ से फ़रियाद करें तो मैं ज़रूर उनकी फ़रियाद सुनूँगा। ");
INSERT INTO urd_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","और मेरा क़हर भड़केगा और मैं तुम को तलवार से मार डालूँगा और तुम्हारी बीवियाँ बेवा और तुम्हारे बच्चे यतीम हो जाएँगे। ");
INSERT INTO urd_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“अगर तू मेरे लोगों में से किसी मोहताज को जो तेरे पास रहता हो कुछ क़र्ज़ दे तो उससे क़र्ज़दार की तरह सुलूक न करना और न उससे सूद लेना। ");
INSERT INTO urd_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","अगर तू किसी वक़्त अपने पड़ोसी के कपड़े गिरवी रख भी ले तो सूरज के डूबने तक उसको वापस कर देना। ");
INSERT INTO urd_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","क्यूँकि सिर्फ़ वही उसका एक ओढ़ना है, उसके जिस्म का वही लिबास है फिर वह क्या ओढ़ कर सोएगा? फिर जब वह फ़रियाद करेगा तो मैं उसकी सुनूँगा क्यूँकि मैं मेहरबान हूँ। ");
INSERT INTO urd_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“तू ख़ुदा को न कोसना और न अपनी क़ौम के सरदार पर ला'नत भेजना। ");
INSERT INTO urd_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“तू अपनी ज़्यादा पैदावार और अपने कोल्हू के रस में से मुझे नज़्र — ओ — नियाज़ देने में देर न करना और अपने बेटों में से पहलौठे को मुझे देना। ");
INSERT INTO urd_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","अपनी गायों और भेड़ों से भी ऐसा ही करना; सात दिन तक तो बच्चा अपनी माँ के साथ रहे, आठवें दिन तू उसे मुझ को देना। ");
INSERT INTO urd_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“और तू मेरे लिए पाक आदमी होना, इसी वजह से दरिन्दों के फाड़े हुए जानवर का गोश्त जो मैदान में पड़ा हुआ मिले मत खाना; तुम उसे कुत्तों के आगे फेंक देना। ");
INSERT INTO urd_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","तू झूठी बात ना फैलाना और नारास्त गवाह होने के लिए शरीरों का साथ न देना। ");
INSERT INTO urd_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","बुराई करने के लिए किसी भीड़ की पैरवी न करना, और न किसी मुक़दमें में इन्साफ़ का ख़ून कराने के लिए भीड़ का मुँह देखकर कुछ कहना। ");
INSERT INTO urd_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","और न मुक़दमों में कंगाल की तरफ़दारी करना। ");
INSERT INTO urd_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","'अगर तेरे दुश्मन का बैल या गधा तुझे भटकता हुआ मिले, तो तू ज़रूर उसे उसके पास फेर कर ले आना। ");
INSERT INTO urd_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","अगर तू अपने दुश्मन के गधे को बोझ के नीचे दबा हुआ देखे और उसकी मदद करने को जी भी न चाहता हो तो भी ज़रूर उसे मदद देना। ");
INSERT INTO urd_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“तू अपने कंगाल लोगों के मुक़दमों में इन्साफ़ का ख़ून न करना। ");
INSERT INTO urd_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","झूटे मु'आमिले से दूर रहना और बेगुनाहों और सादिकों को क़त्ल न करना क्यूँकि मैं शरीर को रास्त नहीं ठहराऊँगा। ");
INSERT INTO urd_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","तू रिश्वत न लेना क्यूँकि रिश्वत बीनाओं को अन्धा कर देती है और सादिकों की बातों को पलट देती है। ");
INSERT INTO urd_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“परदेसी पर ज़ुल्म न करना क्यूँकि तुम परदेसी के दिल को जानते हो, इसलिए कि तुम ख़ुद भी मुल्क — ए — मिस्र में परदेसी थे। ");
INSERT INTO urd_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“छ: बरस तक तू अपनी ज़मीन में बोना और उसका ग़ल्ला जमा' करना, ");
INSERT INTO urd_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","पर सातवें बरस उसे यूँ ही छोड़ देना कि पड़ती रहे, ताकि तेरी क़ौम के ग़रीब उसे खाएँ और जो उनसे बचे उसे जंगल के जानवर चर लें। अपने अंगूर और जैतून के बाग़ से भी ऐसा ही करना। ");
INSERT INTO urd_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","छ: दिन तक अपना काम काज करना और सातवें दिन आराम करना, ताकि तेरे बैल और गधे को आराम मिले और तेरी लौंडी का बेटा और परदेसी ताज़ा दम हो जाएँ। ");
INSERT INTO urd_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","और तुम सब बातों में जो मैंने तुम से कहीं हैं होशियार रहना और दूसरे मा'बूदों का नाम तक न लेना बल्कि वह तेरे मुँह से सुनाई भी न दे। ");
INSERT INTO urd_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","'तू साल भर में तीन बार मेरे लिए 'ईद मनाना। ");
INSERT INTO urd_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","ईद — ए — फ़तीर को मानना, उसमें मेरे हुक्म के मुताबिक़ अबीब महीने के मुक़र्ररा वक़्त पर सात दिन तक बेख़मीरी रोटियाँ खाना क्यूँकि उसी महीने में तू मिस्र से निकला था और कोई मेरे आगे ख़ाली हाथ न आए। ");
INSERT INTO urd_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","और जब तेरे खेत में जिसे तूने मेहनत से बोया पहला फल आए तो फ़स्ल काटने की 'ईद मानना, और साल के आखिर में जब तू अपनी मेहनत का फल खेत से जमा' करे तो जमा' करने की 'ईद मनाना। ");
INSERT INTO urd_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","और साल में तीनों मर्तबा तुम्हारे यहाँ के सब मर्द ख़ुदावन्द ख़ुदा के आगे हाज़िर हुआ करें। ");
INSERT INTO urd_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“तू ख़़मीरी रोटी के साथ मेरे ज़बीहे का ख़ून न चढ़ाना और मेरी 'ईद की चर्बी सुबह तक बाक़ी न रहने देना। ");
INSERT INTO urd_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","तू अपनी ज़मीन के पहले फलों का पहला हिस्सा ख़ुदावन्द अपने ख़ुदा के घर में लाना। तू हलवान को उसकी माँ के दूध में न पकाना। ");
INSERT INTO urd_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“देख, मैं एक फ़रिश्ता तेरे आगेआगे भेजता हूँ कि रास्ते में तेरा निगहबान हो और तुझे उस जगह पहुँचा दे जिसे मैंने तैयार किया है। ");
INSERT INTO urd_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","तुम उसके आगे होशियार रहना और उसकी बात मानना, उसे नाराज़ न करना क्यूँकि वह तुम्हारी ख़ता नहीं बख़्शेगा इसलिए कि मेरा नाम उसमें रहता है। ");
INSERT INTO urd_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","लेकिन अगर तू सचमुच उसकी बात माने और जो मैं कहता हूँ वह सब करे, तो मैं तेरे दुश्मनों का दुश्मन और तेरे मुख़ालिफ़ों का मुख़ालिफ़ हूँगा। ");
INSERT INTO urd_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","इसलिए कि मेरा फ़रिश्ता तेरे आगे — आगे चलेगा और तुझे अमोरियों और हित्तियों और फ़रिज़्ज़ियों और कना'नियों और हव्वियों यबूसियों में पहुँचा देगा और मैं उनको हलाक कर डालूँगा। ");
INSERT INTO urd_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","तू उनके मा'बूदो को सिज्दा न करना, न उनकी इबादत करना, न उनके से काम करना बल्कि तू उनको बिल्कुल उलट देना और उनके सुतूनो को टुकड़े टुकड़े कर डालना। ");
INSERT INTO urd_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","और तुम ख़ुदावन्द अपने ख़ुदा की इबादत करना, तब वह तेरी रोटी और पानी पर बरकत देगा और मैं तेरे बीच से बीमारी को दूर कर दूँगा। ");
INSERT INTO urd_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","और तेरे मुल्क में न तो किसी के इस्कात होगा और न कोई बाँझ रहेगी और मैं तेरी उम्र पूरी करूँगा। ");
INSERT INTO urd_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","मैं अपने ख़ौफ़ को तेरे आगे — आगे भेजूँगा और मैं उन सब लोगों को जिनके पास तू जाएगा शिकस्त दूँगा, और मैं ऐसा करूँगा कि तेरे सब दुश्मन तेरे आगे अपनी पुश्त फेर देंगे। ");
INSERT INTO urd_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","मैं तेरे आगे ज़म्बूरों को भेजूँगा, जो हव्वी और कना'नी और हित्ती को तेरे सामने से भगा देंगे। ");
INSERT INTO urd_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","मैं उनको एक ही साल में तेरे आगे से दूर नहीं करूँगा ऐसा न हो के ज़मीन वीरान हो जाए और जंगली दरिन्दे ज़्यादा होकर तुझे सताने लगें। ");
INSERT INTO urd_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","बल्कि मैं थोड़ा थोड़ा करके उनको तेरे सामने से दूर करता रहूँगा, जब तक तू शुमार में बढ़ कर मुल्क का वारिस न हो जाए। ");
INSERT INTO urd_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","मैं बहर — ए — कु़लजु़म से लेकर फ़िलिस्तियों के समन्दर तक और वीरान से लेकर नहर — ए — फु़रात तक तेरी हदें बाधूँगा। क्यूँकि मैं उस मुल्क के बाशिन्दों को तुम्हारे हाथ में कर दूँगा और तू उनको अपने आगे से निकाल देगा। ");
INSERT INTO urd_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","तू उनसे या उनके मा'बूदों से कोई 'अहद न बाँधना। ");
INSERT INTO urd_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","वह तेरे मुल्क में रहने न पाएँ ऐसा न हो कि वह तुझ से मेरे ख़िलाफ़ गुनाह कराएँ, क्यूँकि अगर तू उनके मा'बूदों की इबादत करे तो यह तेरे लिए ज़रूर फंदा हो जाएगा।” ");
INSERT INTO urd_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","और उसने मूसा से कहा, कि “तू हारून और नदब और अबीहू और बनी इस्राईल के सत्तर बुज़ुर्गों को लेकर ख़ुदावन्द के पास ऊपर आ, और तुम दूर ही से सिज्दा करना। ");
INSERT INTO urd_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","और मूसा अकेला ख़ुदावन्द के नज़दीक आए पर वह नज़दीक न आएँ और लोग उसके साथ ऊपर न चढ़ें।” ");
INSERT INTO urd_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","और मूसा ने लोगों के पास जाकर ख़ुदावन्द की सब बातें और अहकाम उनको बता दिए और सब लोगों ने हम आवाज़ होकर जवाब दिया, “जितनी बातें ख़ुदावन्द ने फ़रमाई हैं, हम उन सब को मानेंगे।” ");
INSERT INTO urd_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","और मूसा ने ख़ुदावन्द की सब बातें लिख लीं और सुब्ह को सवेरे उठ कर पहाड़ के नीचे एक क़ुर्बानगाह और बनी — इस्राईल के बारह क़बीलों के हिसाब से बारह सुतून बनाए। ");
INSERT INTO urd_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","और उसने बनी इस्राईल के जवानों को भेजा, जिन्होंने सोख़्तनी कु़र्बानियाँ चढ़ाई और बैलों को ज़बह करके सलामती के ज़बीहे ख़ुदावन्द के लिए पेश किया। ");
INSERT INTO urd_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","और मूसा ने आधा ख़ून लेकर तसलों में रख्खा और आधा क़ुर्बानगाह पर छिड़क दिया। ");
INSERT INTO urd_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","फिर उसने 'अहदनामा लिया और लोगों को पढ़ कर सुनाया। उन्होंने कहा, कि “जो कुछ ख़ुदावन्द ने फ़रमाया है उस सब को हम करेंगे और ताबे' रहेंगे।” ");
INSERT INTO urd_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","तब मूसा ने उस ख़ून को लेकर लोगों पर छिड़का और कहा, “देखो, यह उस 'अहद का ख़ून है जो ख़ुदावन्द ने इन सब बातों के बारे में तुम्हारे साथ बाँधा है।” ");
INSERT INTO urd_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","तब मूसा और हारून और नदब और अबीहू और बनी — इस्राईल के सत्तर बुज़ुर्ग़ ऊपर गए। ");
INSERT INTO urd_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","और उन्होंने इस्राईल के ख़ुदा को देखा, और उसके पाँव के नीचे नीलम के पत्थर का चबूतरा सा था जो आसमान की तरह शफ़्फ़ाफ़ था। ");
INSERT INTO urd_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","और उसने बनी इस्राईल के शरीफ़ों पर अपना हाथ न बढ़ाया। फिर उन्होंने ख़ुदा को देखा और खाया और पिया। ");
INSERT INTO urd_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","और ख़ुदावन्द ने मूसा से कहा, कि “पहाड़ पर मेरे पास आ और वहीं ठहरा रह; और मैं तुझे पत्थर की लोहें और शरी'अत और अहकाम जो मैंने लिखे हैं दूँगा ताकि तू उनको सिखाए।” ");
INSERT INTO urd_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","और मूसा और उसका ख़ादिम यशू'अ उठे और मूसा ख़ुदा के पहाड़ के ऊपर गया। ");
INSERT INTO urd_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","और बुज़ुर्गों से कह गया कि “जब तक हम लौट कर तुम्हारे पास न आ जाएँ तुम हमारे लिए यहीं ठहरे रहो, और देखो हारून और हूर तुम्हारे साथ हैं, जिस किसी का कोई मुक़दमा हो वह उनके पास जाए।” ");
INSERT INTO urd_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","तब मूसा पहाड़ के ऊपर गया और पहाड़ पर घटा छा गई। ");
INSERT INTO urd_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","और ख़ुदावन्द का जलाल कोह-ए-सीना पर आकर ठहरा और छ: दिन तक घटा उस पर छाई रही और सातवें दिन उसने घटा में से मूसा को बुलाया। ");
INSERT INTO urd_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","और बनी — इस्राईल की निगाह में पहाड़ की चोटी पर ख़ुदावन्द के जलाल का मन्ज़र भसम करने वाली आग की तरह था। ");
INSERT INTO urd_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","और मूसा घटा के बीच में होकर पहाड़ पर चढ़ गया और वह पहाड़ पर चालीस दिन और चालीस रात रहा। ");
INSERT INTO urd_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","और ख़ुदावन्द ने मूसा को फ़रमाया, ");
INSERT INTO urd_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","'बनी — इस्राईल से यह कहना कि मेरे लिए नज़्र लाएँ, और तुम उन्हीं से मेरी नज़्र लेना जो अपने दिल की ख़ुशी से दें। ");
INSERT INTO urd_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","और जिन चीज़ों की नज़्र तुम को उनसे लेनी हैं वह यह हैं: सोना और चाँदी और पीतल, ");
INSERT INTO urd_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","और आसमानी और अर्ग़वानी और सुर्ख़ रंग का कपड़ा और बारीक कतान और बकरी की पश्म, ");
INSERT INTO urd_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","और मेंढों की सुर्ख़ रंगी हुई खालें और तुख़स की खालें और कीकर की लकड़ी, ");
INSERT INTO urd_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","और चराग़ के लिए तेल और मसह करने के तेल के लिए और ख़ुशबूदार ख़ुशबू के लिए मसाल्हे, ");
INSERT INTO urd_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","और संग-ए-सुलेमानी और अफ़ोद और सीनाबन्द में जड़ने के नगीने। ");
INSERT INTO urd_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","और वह मेरे लिए एक मक़दिस बनाएँ ताकि मैं उनके बीच सुकूनत करूँ। ");
INSERT INTO urd_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","और घर और उसके सारे सामान का जो नमूना मैं तुझे दिखाऊँ ठीक उसी के मुताबिक़ तुम उसे बनाना। ");
INSERT INTO urd_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","'और वह कीकर की लकड़ी का एक सन्दूक़ बनाये जिस की लम्बाई ढाई हाथ और चौड़ाई डेढ़ हाथ और ऊँचाई डेढ़ हाथ हो। ");
INSERT INTO urd_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","और तू उसके अन्दर और बाहर ख़ालिस सोना मंढ़ना और उसके ऊपर चारों तरफ़ एक ज़रीन ताज बनाना। ");
INSERT INTO urd_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","और उसके लिए सोने के चार कड़े ढालकर उसके चारों पायों में लगाना, दो कड़े एक तरफ़ हों और दो ही दूसरी तरफ़। ");
INSERT INTO urd_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","और कीकर की लकड़ी की चोबें बना कर उन पर सोना मंढ़ना। ");
INSERT INTO urd_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","और इन चोबों को सन्दूक़ के पास के कड़ों में डालना कि उनके सहारे सन्दूक उठ जाए। ");
INSERT INTO urd_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","चोबें सन्दूक के कड़ों के अन्दर लगी रहें और उससे अलग न की जाएँ। ");
INSERT INTO urd_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","और तू उस शहादत नामे को जो मैं तुझे दूँगा उसी सन्दूक में रखना। ");
INSERT INTO urd_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“और तू कफ़्फ़ारे का सरपोश ख़ालिस सोने का बनाना जिसकी लम्बाई ढाई हाथ और चौड़ाई डेढ़ हाथ हो। ");
INSERT INTO urd_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","और सोने के दो करूबी सरपोश के दोनों सिरों पर गढ़ कर बनाना। ");
INSERT INTO urd_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","एक करूबी को एक सिरे पर और दूसरे करूबी को दूसरे सिरे पर लगाना, और तुम सरपोश को और दोनों सिरों के करूबियों को एक ही टुकड़े से बनाना। ");
INSERT INTO urd_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","और वह करूबी इस तरह ऊपर को अपने पर फैलाए हुए हों कि सरपोश को अपने परों से ढाँक लें और उनके मुँह आमने — सामने सरपोश की तरफ़ हों। ");
INSERT INTO urd_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","और तू उस सरपोश को उस सन्दूक के ऊपर लगाना और वह 'अहदनामा जो मैं तुझे दूँगा उसे उस सन्दूक के अन्दर रखना। ");
INSERT INTO urd_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","वहाँ मैं तुझ से मिला करूँगा और उस सरपोश के ऊपर से और करूबियों के बीच में से जो 'अहदनामे के सन्दूक़ के ऊपर होंगे, उन सब अहकाम के बारे में जो मैं बनी — इस्राईल के लिए तुझे दूँगा तुझ से बातचीत किया करूँगा। ");
INSERT INTO urd_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“और तू दो हाथ लम्बी और एक हाथ चौड़ी और डेढ़ हाथ ऊँची कीकर की लकड़ी की एक मेज़ भी बनाना। ");
INSERT INTO urd_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","और उसको ख़ालिस सोने से मंढ़ना और उसके चारों तरफ़ एक ज़रीन ताज बनाना। ");
INSERT INTO urd_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","और उसके चौगिर्द चार उंगल चौड़ी एक कंगनी लगाना और उस कंगनी के चारों तरफ़ एक ज़रीन ताज बनाना। ");
INSERT INTO urd_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","और सोने के चार कड़े उसके लिए बना कर उन कड़ों को उन चारों कोनों में लगाना जो चारों पायों के सामने होंगे। ");
INSERT INTO urd_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","वह कड़े कंगनी के पास ही हों, ताकि चोबों के लिए जिनके सहारे मेज़ उठाई जाए घरों का काम दें। ");
INSERT INTO urd_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","और कीकर की लकड़ी की चोबें बना कर उनको सोने से मंढ़ना ताकि मेज़ उन्हीं से उठाई जाए। ");
INSERT INTO urd_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","और तू उसके तबाक़ और चमचे और आफ़ताबे और उंडेलने के बड़े — बड़े कटोरे सब ख़ालिस सोने के बनाना। ");
INSERT INTO urd_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","और तू उस मेज़ पर नज़्र की रोटियाँ हमेशा मेरे सामने रखना। ");
INSERT INTO urd_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“और तू ख़ालिस सोने का एक शमा'दान बनाना। वह शमा'दान और उसका पाया और डन्डी सब घड़ कर बनाए जाएँ और उसकी प्यालियाँ और लट्टू और उसके फूल सब एक ही टुकड़े के बने हों। ");
INSERT INTO urd_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","और उसके दोनों पहलुओं से छ: शाँख़े बाहर को निकलती हों, तीन शाखें शमा'दान के एक पहलू से निकलें और तीन दूसरे पहलू से। ");
INSERT INTO urd_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","एक शाख़ में बादाम के फूल की सूरत की तीन प्यालियाँ, एक लट्टू और एक फूल हो; और दूसरी शाख़ में भी बादाम के फूल की सूरत की तीन प्यालियाँ, एक लट्टू और एक फूल हो; इसी तरह शमा'दान की छहों शाख़ों में यह सब लगा हुआ हो। ");
INSERT INTO urd_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","और खु़द शमादान में बादाम के फूल की सूरत की चार प्यालियाँ अपने — अपने लट्टू और फूल समेत हों। ");
INSERT INTO urd_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","और दो शाख़ों के नीचे एक लट्टू, सब एक ही टुकड़े के हों और फिर दो शाख़ों के नीचे एक लट्टू, सब एक ही टुकड़े के हों और फिर दो शाखों के नीचे एक लट्टू, सब एक ही टुकड़े के हों शमा'दान की छहों बाहर को निकली हुई शाखें ऐसी ही हों। ");
INSERT INTO urd_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","या'नी लट्टू और शाख़ें और शमा 'दान सब एक ही टुकड़े के बने हों, यह सबका सब ख़ालिस सोने के एक ही टुकड़े से गढ़ कर बनाया जाए। ");
INSERT INTO urd_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","और तू उसके लिए सात चराग़ बनाना, यही चराग़ जलाए जाएँ ताकि शमा'दान के सामने रौशनी हो। ");
INSERT INTO urd_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","और उसके गुलगीर और गुलदान ख़ालिस सोने के हों। ");
INSERT INTO urd_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","शमा'दान और यह सब बर्तन एक किन्तार ख़ालिस सोने के बने हुए हों। ");
INSERT INTO urd_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","और देख, तू इनको ठीक इनके नमूने के मुताबिक़ जो तुझे पहाड़ पर दिखाया गया है बनाना। ");
INSERT INTO urd_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“और तू घर के लिए दस पर्दे बनाना; यह बटे हुए बारीक कतान और आसमानी क़िरमिज़ी और सुर्ख़ रंग के कपड़ों के हों और इनमें किसी माहिर उस्ताद से करूबियों की सूरत कढ़वाना। ");
INSERT INTO urd_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","हर पर्दे की लम्बाई अट्ठाईस हाथ और चौड़ाई चार हाथ हो और सब पर्दे एक ही नाप के हों। ");
INSERT INTO urd_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","और पाँच पर्दे एक दूसरे से जोड़े जाएँ और बाक़ी पाँच पर्दे भी एक दूसरे से जोड़े जाएँ। ");
INSERT INTO urd_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","और तू एक बड़े पर्दे के हाशिये में बटे हुए किनारे की तरफ़ जो जोड़ा जाएगा आसमानी रंग के तुकमे बनाना और ऐसे ही दूसरे बड़े पर्दे के हाशिये में जो इसके साथ मिलाया जाएगा तुकमे बनाना। ");
INSERT INTO urd_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","पचास तुकमे एक बड़े पर्दे में बनाना और पचास ही दूसरे बड़े पर्दे के हाशिये में जो इसके साथ मिलाया जाएगा बनाना, और सब तुकमे एक दूसरे के आमने सामने हों। ");
INSERT INTO urd_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","और सोने की पचास घुन्डियाँ बना कर इन पर्दों को इन्हीं घुन्डियों से एक दूसरे के साथ जोड़ देना, तब वह घर एक हो जाएगा। ");
INSERT INTO urd_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","'और तू बकरी के बाल के पर्दे बनाना ताकि घर के ऊपर ख़ेमा का काम दें, ऐसे पर्दे ग्यारह हों। ");
INSERT INTO urd_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","और हर पर्दे की लम्बाई तीस हाथ और चौड़ाई चार हाथ हो, वह ग्यारह हों, पर्दे एक ही नाप के हों। ");
INSERT INTO urd_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","और तू पाँच पर्दे एक जगह और छ: पर्दे एक जगह आपस में जोड़ देना, और छटे पर्दे को खे़मे के सामने मोड़ कर दोहरा कर देना। ");
INSERT INTO urd_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","और तू पचास तुकमे उस पर्दे के हाशिये में, जो बाहर से मिलाया जाएगा और पचास ही तुकमे दूसरी तरफ़ के पर्दे के हाशिये में जो बाहर से मिलाया जाएगा बनाना। ");
INSERT INTO urd_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","और पीतल की पचास घुन्डियाँ बना कर इन घुन्डियों को तुकमों में पहना देना और खे़मे को जोड़ देना ताकि वह एक हो जाए। ");
INSERT INTO urd_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","और खे़मे के पर्दों का लटका हुआ हिस्सा, या'नी आधा पर्दा जो बचा रहेगा वह घर की पिछली तरफ़ लटका रहे। ");
INSERT INTO urd_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","और ख़ेमे के पर्दों की लम्बाई के बाक़ी हिस्से में से एक हाथ पर्दा इधर से और एक हाथ पर्दा उधर से घर की दोनों तरफ़ इधर और उधर लटका रहे ताकि उसे ढाँक ले। ");
INSERT INTO urd_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","और तू इस खे़मे के लिए मेंढों की सुर्ख़ रंगी हुई खालों का ग़िलाफ़ और उसके ऊपर तुख़्सों की खालों का ग़िलाफ़ बनाना। ");
INSERT INTO urd_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“और तू घर के लिए कीकर की लकड़ी के तख़्ते बनाना कि खड़े किए जाएँ। ");
INSERT INTO urd_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","हर तख़्ते की लम्बाई दस हाथ और चौड़ाई डेढ़ हाथ हो। ");
INSERT INTO urd_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","और हर तख़्ते में दो — दो चूलें हों जो एक दूसरे से मिली हुई हों, घर के सब तख़्ते इसी तरह के बनाना। ");
INSERT INTO urd_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","और घर के लिए जो तख़्ते तू बनाएगा उनमें से बीस तख़्ते दाख्खिनी रुख़ के लिए हों। ");
INSERT INTO urd_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","और इन बीसों तख़्तों के नीचे चाँदी के चालीस ख़ाने बनाना या'नी हर एक तख़्ते के नीचे उसकी दोनों चूलों के लिए दो — दो ख़ाने। ");
INSERT INTO urd_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","और घर की दूसरी तरफ़ या'नी उत्तरी रुख़ के लिए बीस तख़्ते हों। ");
INSERT INTO urd_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","और उनके लिए भी चाँदी के चालीस ही ख़ाने हों, या'नी एक — एक तख़्ते के नीचे दो — दो ख़ाने। ");
INSERT INTO urd_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","और घर के पिछले हिस्से के लिए पश्चिमी रुख़ में छ: तख़्ते बनाना। ");
INSERT INTO urd_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","और उसी पिछले हिस्से में घर के कोनों के लिए दो तख़्ते बनाना। ");
INSERT INTO urd_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","यह नीचे से दोहरे हों और इसी तरह ऊपर के सिरे तक आकर एक हल्के़ में मिलाए जाएँ, दोनों तख़्ते इसी ढब के हों, यह तख़्ते दोनों कोनों के लिए होंगे। ");
INSERT INTO urd_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","तब आठ तख़्ते और चाँदी के सोलह ख़ाने होंगे, या'नी एक एक तख़्ते के लिए दो दो ख़ाने। ");
INSERT INTO urd_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“और तू कीकर की लकड़ी के बेन्डे बनाना, पाँच बेन्डे घर के एक पहलू के तख़्तों के लिए, ");
INSERT INTO urd_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","और पाँच बेन्डे घर के दूसरे पहलू के तख़्तों के लिए, और पाँच बेन्डे घर के पिछले हिस्से या'नी पश्चिमी रुख़ के तख़्तों के लिए, ");
INSERT INTO urd_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","और वस्ती बेन्डा जो तख़्तों के बीच में हो, वह ख़ेमे की एक हद से दूसरी हद तक पहुँचे। ");
INSERT INTO urd_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","और तू तख़्तों को सोने से मंढ़ना और बेन्डों के घरों के लिए सोने के कड़े बनाना और बेन्डों को भी सोने से मंढ़ना। ");
INSERT INTO urd_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","और तू घर को उसी नमूने के मुताबिक़ बनाना जो पहाड़ पर दिखाया गया है। ");
INSERT INTO urd_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“और तू आसमानी — अर्ग़वानी और सुर्ख़ रंग के कपड़ों और बारीक बटे हुए कतान का एक पर्दा बनाना, और उसमें किसी माहिर उस्ताद से करूबियों की सूरत कढ़वाना। ");
INSERT INTO urd_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","और उसे सोने से मंढ़े हुए कीकर के चार सुतूनों पर लटकाना, इनके कुन्डे सोने के हों और चाँदी के चार ख़ानों पर खड़े किए जाएँ, ");
INSERT INTO urd_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","और पर्दे को घुन्डियों के नीचे लटकाना और शहादत के सन्दूक को वहीं पर्दे के अन्दर ले जाना और यह पर्दा तुम्हारे लिए पाक मक़ाम को पाकतरीन मक़ाम से अलग करेगा। ");
INSERT INTO urd_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","और तू सरपोश को पाकतरीन मक़ाम में शहादत के सन्दूक़ पर रखना। ");
INSERT INTO urd_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","और मेज़ को पर्दे के बाहर रख कर शमा'दान को उसके सामने घर की दाख्खिनी रुख़ में रखना या'नी मेज़ उत्तरी रुख़ में रखना। ");
INSERT INTO urd_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","और तू एक पर्दा खे़मे के दरवाज़े के लिए आसमानी अर्ग़वानी और सुर्ख़ रंग के कपड़ों और बारीक बटे हुए कतान का बनाना और उस पर बेल बूटे कढ़े हुए हों। ");
INSERT INTO urd_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","और इस पर्दे के लिए कीकर की लकड़ी के पाँच सुतून बनाना और उनको सोने से मंढ़ना और उनके कुन्डे सोने के हों, जिनके लिए तू पीतल के पाँच ख़ाने ढाल कर बनाना। ");
INSERT INTO urd_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“और तू कीकर की लकड़ी की क़ुर्बानगाह पाँच हाथ लम्बी और पाँच हाथ चौड़ी बनाना; वह क़ुर्बानगाह चौखुन्टी और उसकी ऊँचाई तीन हाथ हो। ");
INSERT INTO urd_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","और तू उसके लिए उसके चारों कोनों पर सींग बनाना, और वह सींग और क़ुर्बानगाह सब एक ही टुकड़े के हों और तू उनको पीतल से मंढ़ना। ");
INSERT INTO urd_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","और तू उसकी राख उठाने के लिए देगें और बेलचे और कटोरे और सीखें और अन्गुठियाँ बनाना; उसके सब बर्तन पीतल के बनाना। ");
INSERT INTO urd_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","और उसके लिए पीतल की जाली की झंजरी बनाना और उस जाली के चारों कोनों पर पीतल के चार कड़े लगाना। ");
INSERT INTO urd_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","और उस झंजरी को क़ुर्बानगाह की चारों तरफ़ के किनारे के नीचे इस तरह लगाना कि वह ऊँचाई में क़ुर्बानगाह की आधी दूर तक पहुँचे। ");
INSERT INTO urd_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","और तू क़ुर्बानगाह के लिए कीकर की लकड़ी की चोबें बनाकर उनको पीतल से मंढ़ना। ");
INSERT INTO urd_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","और तू उन चोबों को कड़ों में पहना देना कि जब कभी क़ुर्बानगाह उठाई जाए, वह चोबें उसकी दोनों तरफ़ रहें। ");
INSERT INTO urd_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","तख़्तों से वह क़ुर्बानगाह बनाना और वह खोखली हो। वह उसे ऐसी ही बनाएँ जैसी तुझे पहाड़ पर दिखाई गई है। ");
INSERT INTO urd_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“फिर तू घर के लिए सहन बनाना, उस सहन की दाख्खिनी तरफ़ के लिए बारीक बटे हुए कतान के पर्दे हों जो मिला कर सौ हाथ लम्बे हों; यह सब एक ही रुख़ में हों। ");
INSERT INTO urd_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","और उनके लिए बीस सुतून बनें और सुतूनों के लिए पीतल के बीस ही ख़ाने बनें और इन सुतूनों के कुन्डे और पट्टियाँ चाँदी की हों। ");
INSERT INTO urd_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","इसी तरह उत्तरी रुख़ के लिए पर्दे सब मिला कर लम्बाई में सौ हाथ हों, उनके लिए भी बीस ही सुतून और सुतूनों के लिए बीस ही पीतल के ख़ाने बनें और सुतूनों के कुन्डे और पट्टियाँ चाँदी की हों। ");
INSERT INTO urd_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","और सहन की पश्चिमी रुख़ की चौड़ाई में पचास हाथ के पर्दे हों, उनके लिए दस सुतून और सुतूनों के लिए दस ही ख़ाने बनें। ");
INSERT INTO urd_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","और पूर्वी रुख़ में सहन हो। ");
INSERT INTO urd_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","और सहन के दरवाज़े के एक पहलू के लिए पन्द्रह हाथ के पर्दे हों, जिनके लिए तीन सुतून और सुतून के लिए तीन ही ख़ाने बनें। ");
INSERT INTO urd_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","और दूसरे पहलू के लिए भी पन्द्रह हाथ के पर्दे और तीन सुतून और तीन ही ख़ाने बनें। ");
INSERT INTO urd_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","और सहन के दरवाज़े के लिए बीस हाथ का एक पर्दा हो जो आसमानी, अर्ग़वानी और सुर्ख़ रंग के कपड़ों और बारीक बटे हुए कतान का बना हुआ हो और उस पर बेल — बूटे कढ़े हों, उसके सुतून चार और सुतूनों के ख़ाने भी चार ही हों। ");
INSERT INTO urd_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","और सहन के आस पास सब सुतून चाँदी की पट्टियों से जड़े हुए हों और उनके कुन्डे चाँदी के और उनके ख़ाने पीतल के हों। ");
INSERT INTO urd_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","सहन की लम्बाई सौ हाथ और चौड़ाई हर जगह पचास हाथ और कनात की ऊँचाई पाँच हाथ ही, पर्दे बारीक बटे हुए कतान के और सुतूनों के ख़ाने पीतल के हों। ");
INSERT INTO urd_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","घर के तरह तरह के काम के सब सामान और वहाँ की मेख़ें और सहन की मेख़े यह सब पीतल के हों। ");
INSERT INTO urd_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","'और तू बनी — इस्राईल को हुक्म देना कि वह तेरे पास कूट कर निकाला हुआ जैतून का ख़ालिस तेल रोशनी के लिए लाएँ ताकि चराग़ हमेशा जलता रहे। ");
INSERT INTO urd_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ख़ेमा-ए-इजितमा'अ में उस पर्दे के बाहर, जो शहादत के सन्दूक के सामने होगा, हारून और उसके बेटे शाम से सुबह तक शमा 'दान को ख़ुदावन्द के सामने अरास्ता रख्खें, यह दस्तूर — उल'अमल बनी — इस्राईल के लिए नसल — दर — नसल हमेशा क़ाईम रहेगा। ");
INSERT INTO urd_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“और तू बनी — इस्राईल में से हारून को जो तेरा भाई है, और उसके साथ उसके बेटों को अपने नज़दीक कर लेना; ताकि हारून और उसके बेटे नदब और अबीहू और इली'एलियाज़र और ऐतामर कहानत के 'उहदे पर होकर मेरी ख़िदमत करें। ");
INSERT INTO urd_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","और तू अपने भाई हारून के लिए 'इज़्ज़त और ज़ीनत के लिए पाक लिबास बना देना। ");
INSERT INTO urd_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","और तू उन सब रोशन ज़मीरों से जिनको मैंने हिकमत की रूह से भरा है, कह कि वह हारून के लिए लिबास बनाएँ ताकि वह पाक होकर मेरे लिए काहिन की ख़िदमत को अन्जाम दे। ");
INSERT INTO urd_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","और जो लिबास वह बनाएँगे यह हैं: या'नी सीना बन्द और अफ़ूद और जुब्बा और चार ख़ाने का कुरता, और 'अमामा, और कमरबन्द, वह तेरे भाई हारून और उसके बेटों के लिए यह पाक लिबास बनाएँ, ताकि वह मेरे लिए काहिन की खि़दमत को अन्जाम दे। ");
INSERT INTO urd_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","और वह सोना और आसमानी और अर्ग़वानी और सुर्ख़ रंग के कपड़े और महीन कतान लें। ");
INSERT INTO urd_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“और वह अफ़ोद सोने और आसमानी और अर्ग़वानी और सुर्ख़ रंग के कपड़ों और बारीक बटे हुए कतान का बनाएँ, जो किसी माहिर उस्ताद के हाथ का काम हो। ");
INSERT INTO urd_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","और वह इस तरह से जोड़ा जाए कि उसके दोनों मोंढों के सिरे आपस में मिला दिए जाएँ। ");
INSERT INTO urd_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","और उसके ऊपर जो कारीगरी से बना हुआ पटका उसके बाँधने के लिए होगा, उस पर अफ़ोद की तरह काम हो और वह उसी कपड़े का हो, और सोने और आसमानी और अर्ग़वानी और सुर्ख़ रंग के कपड़ों और बारीक बटे हुए कतान का बुना हुआ हो। ");
INSERT INTO urd_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","और तू दो संग-ए-सुलेमानी लेकर उन पर इस्राईल के बेटों के नाम कन्दा कराना। ");
INSERT INTO urd_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","उनमें से छ: के नाम तो एक पत्थर पर और बाक़ियों के छः नाम दूसरे पत्थर पर उनकी पैदाइश की तरतीब के मुवाफ़िक हों। ");
INSERT INTO urd_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","तू पत्थर के कन्दाकार को लगा कर अँगूठी के नक़्श की तरह इस्राईल के बेटों के नाम उन दोनों पत्थरों पर खुदवा कर के उनको सोने के ख़ानों में जड़वाना। ");
INSERT INTO urd_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","और दोनों पत्थरों को अफ़ोद के दोनों मोंढों पर लगाना ताकि यह पत्थर इस्राईल के बेटों की यादगारी के लिए हों, और हारून उनके नाम ख़ुदावन्द के सामने अपने दोनों कन्धों पर यादगारी के लिए लगाए रहे। ");
INSERT INTO urd_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","और तू सोने के ख़ाने बनाना, ");
INSERT INTO urd_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","और ख़ालिस सोने की दो ज़जीरें डोरी की तरह गुन्धी हुई बनाना और इन गुन्धी हुई ज़ंजीरों को ख़ानों में जड़ देना। ");
INSERT INTO urd_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“और 'अदल का सीना बन्द किसी माहिर उस्ताद से बनवाना और अफ़ोद की तरह सोने और आसमानी और अर्ग़वानी और सुर्ख़ रंग के कपड़ों और बारीक बटे हुए कतान का बनाना। ");
INSERT INTO urd_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","वह चौखुन्टा और दोहरा हो, उसकी लम्बाई एक बालिश्त और चौड़ाई भी एक ही बालिश्त हो। ");
INSERT INTO urd_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","और चार कतारों में उस पर जवाहर जड़ना, पहली क़तार में याकू़त — ए — सुर्ख़ और पुखराज और गौहर — ए — शब चराग़ हो ");
INSERT INTO urd_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","दूसरी क़तार में ज़मुर्रुद और नीलम और हीरा, ");
INSERT INTO urd_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","तीसरी कतार में लश्म और यश्म और याकू़त, ");
INSERT INTO urd_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","चौथी क़तार में फ़ीरोज़ा और संग — ए — सुलेमानी और ज़बरजद; यह सब सोने के ख़ानों में जड़े जाएँ। ");
INSERT INTO urd_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","यह जवाहर इस्राईल के बेटों के नामों के मुताबिक़ शुमार में बारह हों और अँगूठी के नक़्श की तरह यह नाम जो बारह क़बीलों के नाम होंगे, उन पर खुदवाए जाएँ। ");
INSERT INTO urd_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","और तू सीनाबन्द पर डोरी की तरह गुन्धी हुई ख़ालिस सोने की दो ज़ंजीरें लगाना। ");
INSERT INTO urd_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","और सीनाबन्द के लिए सोने के दो हल्के़ बना कर उनको सीनाबन्द के दोनों सिरों पर लगाना; ");
INSERT INTO urd_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","और सोने की दोनों गुन्धी हुई ज़ंजीरों को उन दोनों हल्क़ों में जो सीनाबन्द के दोनों सिरों पर होंगे लगा देना। ");
INSERT INTO urd_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","और दोनों गुन्धी हुई ज़ंजीरों के बाक़ी दोनों सिरों को दोनों पत्थरों के ख़ानों में जड़ कर उनको अफ़ोद के दोनों मोंढों पर सामने की तरफ़ लगा देना। ");
INSERT INTO urd_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","और सोने के और दो हल्के़ बनाकर उनको सीनाबन्द के दोनों सिरों के उस हाशिये में लगाना जो अफ़ोद के अन्दर की तरफ़ है। ");
INSERT INTO urd_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","फिर सोने के दो हल्के़ और बनाकर उनको अफ़ोद के दोनों मोंढों के नीचे उसके अगले हिस्से में लगाना जहाँ अफ़ोद जोड़ा जाएगा, ताकि वह अफ़ोद के कारीगरी से बुने हुए पटके के ऊपर रहे। ");
INSERT INTO urd_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","और वह सीनाबन्द को लेकर उसके हल्क़ो को एक नीले फ़ीते से बाँधे, ताकि यह सीनाबन्द अफ़ोद के कारीगरी से बने हुए पटके के ऊपर भी रहे और अफ़ोद से भी अलग न होने पाए। ");
INSERT INTO urd_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","और हारून इस्राईल के बेटों के नाम 'अदल के सीनाबन्द पर अपने सीने पर पाक मक़ाम में दाख़िल होने के वक़्त ख़ुदावन्द के आमने सामने लगाए रहे, ताकि हमेशा उनकी यादगारी हुआ करे। ");
INSERT INTO urd_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","और तू 'अदल के सीनाबन्द में ऊरीम और तुम्मीम को रखना और जब हारून ख़ुदावन्द के सामने जाए तो यह उसके दिल के ऊपर हों, यूँ हारून बनी — इस्राईल के फै़सले को अपने दिल के ऊपर ख़ुदावन्द के आमने सामने हमेशा लिए रहेगा। ");
INSERT INTO urd_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“और तू अफ़ोद का जुब्बा बिल्कुल आसमानी रंग का बनाना। ");
INSERT INTO urd_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","और उसका गिरेबान बीच में हो, और ज़िरह के गिरेबान की तरह उसके गिरेबान के चारों तरफ़ बुनी हुई गोट हो ताकि वह फटने न पाए। ");
INSERT INTO urd_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","और उसके दामन के घेर में चारों तरफ़ आसमानी, अर्ग़वानी और सुर्ख़ रंग के अनार बनाना और उनके बीच चारों तरफ़ सोने की घंटियाँ लगाना। ");
INSERT INTO urd_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","या'नी जुब्बे के दामन के पूरे घेर में एक सोने की घन्टी हो और उसके बाद अनार, फिर एक सोने की घन्टी हो और उसके बाद अनार। ");
INSERT INTO urd_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","इस जुब्बे को हारून ख़िदमत के वक़्त पहना करे, ताकि जब — जब वह पाक मक़ाम के अन्दर ख़ुदावन्द के सामने जाए या वहाँ से निकले तो उसकी आवाज़ सुनाई दे, कहीं ऐसा न हो कि वह मर जाए। ");
INSERT INTO urd_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“और तू ख़ालिस सोने का एक पत्तर बना कर उस पर अँगूठी के नक़्श की तरह यह खुदवाना, ख़ुदावन्द के लिए मुक़द्दस। ");
INSERT INTO urd_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","और उसे नीले फ़ीते से बाँधना, ताकि वह 'अमामे पर या'नी 'अमामे के सामने के हिस्से पर हो। ");
INSERT INTO urd_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","और यह हारून की पेशानी पर रहे ताकि जो कुछ बनी — इस्राईल अपने पाक हदियों के ज़रिए' से पाक ठहराएँ, उन पाक ठहराई हुई चीज़ों की बदी हारून उठाए और यह उसकी पेशानी पर हमेशा रहे, ताकि वह ख़ुदावन्द के सामने मक़बूल हों। ");
INSERT INTO urd_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“और कुरता बारीक कतान का बुना हुआ और चार ख़ाने का हो और 'अमामा भी बारीक कतान ही का बनाना, और एक कमरबन्द बनाना जिस पर बेल बूटे कढ़े हों। ");
INSERT INTO urd_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“और हारून के बेटों के लिए कुरते बनाना और 'इज़्ज़त और ज़ीनत के लिए उनके लिए कमरबन्द और पगड़ियाँ बनाना। ");
INSERT INTO urd_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","और तू यह सब अपने भाई हारून और उसके साथ उसके बेटों को पहनाना, और उनको मसह और मख़्सूस और पाक करना ताकि वह सब मेरे लिए काहिन की ख़िदमत को अन्जाम दें। ");
INSERT INTO urd_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","और तू उनके लिए कतान के पाजामे बना देना ताकि उनका बदन ढंका रहे, यह कमर से रान तक के हों। ");
INSERT INTO urd_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","और हारून और उसके बेटे जब — जब ख़ेमा — ए — इजितमा'अ में दाख़िल हों या ख़िदमत करने को पाक मक़ाम के अन्दर क़ुर्बानगाह के नज़दीक जाएँ, उनको पहना करें कहीं ऐसा न हो कि गुनाहगार ठहरें और मर जाएँ। यह दस्तूर — उल — 'अमल उसके और उसकी नसल के लिए हमेशा रहेगा। ");
INSERT INTO urd_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","और उनको पाक करने की ख़ातिर ताकि वह मेरे लिए काहिन की ख़िदमत को अन्जाम दें, तू उनके लिए यह करना कि एक बछड़ा और दो बे — 'ऐब मेंढे लेना, ");
INSERT INTO urd_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","और बेख़मीरी रोटी और बे — ख़मीर के कुल्चे जिनके साथ तेल मिला हो और तेल की चुपड़ी हुई बे — ख़मीरी चपातियाँ लेना। यह सब गेहूँ के मैदे की बनाना। ");
INSERT INTO urd_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","और इनको एक टोकरी में रख कर उस टोकरी को बछड़े और दोनों मेंढों समेत आगे ले आना। ");
INSERT INTO urd_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","फिर हारून और उसके बेटों को ख़ेमा — ए — इजितमा'अ के दरवाज़े पर लाकर उनको पानी से नहलाना। ");
INSERT INTO urd_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","और वह लिबास लेकर हारून को कुरता और अफ़ोद का जुब्बा और अफ़ोद और सीनाबन्द पहनाना, और अफ़ोद का कारीगरी से बुना हुआ कमरबन्द उसके बांध देना। ");
INSERT INTO urd_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","और 'अमामे को उसके सिर पर रख कर उस 'अमामे के ऊपर पाक ताज लगा देना। ");
INSERT INTO urd_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","और मसह करने का तेल लेकर उसके सिर पर डालना और उसको मसह करना। ");
INSERT INTO urd_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","फिर उसके बेटों को आगे लाकर उनको कुरते पहनाना। ");
INSERT INTO urd_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","और हारून और उसके बेटों के कमरबन्द लपेट कर उनके पगड़ियाँ बाँधना ताकि कहानत के 'उहदे पर हमेशा के लिए उनका हक़ रहे; और हारून और उसके बेटों को मख़्सूस करना। ");
INSERT INTO urd_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“फिर तू उस बछड़े को ख़ेमा — ए — इजितमा'अ के सामने लाना, और हारून और उसके बेटे अपने हाथ उस बछड़े के सिर पर रख्खें। ");
INSERT INTO urd_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","फिर उस बछड़े को ख़ुदावन्द के आगे ख़ेमा — ए — इजितमा'अ के दरवाज़े पर ज़बह करना। ");
INSERT INTO urd_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","और उस बछड़े के ख़ून में से कुछ लेकर उसे अपनी उंगली से क़ुर्बानगाह के सींगों पर लगाना और बाक़ी सारा ख़ून क़ुर्बानगाह के पाये पर उंडेल देना। ");
INSERT INTO urd_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","फिर उस चर्बी को जिससे अंतड़ियाँ ढकी रहती हैं, और जिगर पर की झिल्ली को और दोनों गुर्दों को और उनके ऊपर की चर्बी को लेकर सब क़ुर्बानगाह पर जलाना। ");
INSERT INTO urd_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","लेकिन उस बछड़े के गोश्त और खाल और गोबर को ख़ेमागाह के बाहर आग से जला देना इसलिए कि यह ख़ता की क़ुर्बानी है। ");
INSERT INTO urd_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“फिर तू एक मेंढे को लेना, और हारून और उसके बेटे अपने हाथ उस मेंढे के सिर पर रख्खें। ");
INSERT INTO urd_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","और तू उस मेंढे को ज़बह करना और उसका ख़ून लेकर क़ुर्बानगाह पर चारों तरफ़ छिड़कना। ");
INSERT INTO urd_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","और तू मेंढे को टुकड़े — टुकड़े काटना और उसकी अंतड़ियों और पायों को धो कर उसके टुकड़ों और उसके सिर के साथ मिला देना। ");
INSERT INTO urd_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","फिर इस पूरे मेंढे को क़ुर्बानगाह पर जलाना। यह ख़ुदावन्द के लिए सोख़्तनी क़ुर्बानी है। यह राहतअंगेज़ खु़शबू या'नी ख़ुदावन्द के लिए आतिशीन क़ुर्बानी है। ");
INSERT INTO urd_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“फिर दूसरे मेंढे को लेना और हारून और उसके बेटे अपने हाथ उस मेंढे के सिर पर रख्खें। ");
INSERT INTO urd_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","और तू इस मेंढे को ज़बह करना और उसके ख़ून में से कुछ लेकर हारून और उसके बेटों के दहने कान की लौ पर और दहने हाथ और दहने पाँव के अंगूठों पर लगाना, और ख़ून को क़ुर्बानगाह पर चारों तरफ़ छिड़क देना। ");
INSERT INTO urd_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","और क़ुर्बानगाह पर के ख़ून और मसह करने के तेल में से कुछ कुछ लेकर हारून और उसके लिबास पर, और उसके साथ उसके बेटों और उनके लिबास पर छिड़कना, तब वह अपने लिबास समेत और उसके साथ ही उसके बेटे अपने — अपने लिबास समेत पाक होंगे। ");
INSERT INTO urd_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","और तू मेंढे की चर्बी और मोटी दुम को, और जिस चर्बी से अंतड़ियाँ ढकी रहती हैं उसको और जिगर पर की झिल्ली को, और दोनों गुर्दों को और उनके ऊपर की चर्बी को और दहनी रान को लेना; इस लिए कि यह ख़ास मेंढा है। ");
INSERT INTO urd_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","और बेख़मीरी रोटी की टोकरी में से जो ख़ुदावन्द के आगे रखी होगी, रोटी का एक गिरदा और एक कुल्चा जिसमें तेल मिला हुआ हो और एक चपाती लेना। ");
INSERT INTO urd_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","और इन सभों को हारून और उसके बेटों के हाथों पर रख कर इनको ख़ुदावन्द के सामने हिलाना, ताकि यह हिलाने का हदिया हो। ");
INSERT INTO urd_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","फिर इनको उनके हाथों से लेकर क़ुर्बानगाह पर सोख़्तनी क़ुर्बानी के ऊपर जला देना, ताकि वह ख़ुदावन्द के आगे राहतअंगेज़ ख़ुशबू हो; यह ख़ुदावन्द के लिए आतिशीन क़ुर्बानी है। ");
INSERT INTO urd_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“और तू हारून के ख़ास मेंढे का सीना लेकर उसको ख़ुदावन्द के सामने हिलाना ताकि वह हिलाने का हदिया हो, यह तेरा हिस्सा ठहरेगा। ");
INSERT INTO urd_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","और तू हारून और उसके बेटों के ख़ास मेंढे के हिलाने के हदिये के सीने को जो हिलाया जा चुका है, और उठाए जाने के हदिये की रान को जो उठाई जा चुकी है, लेकर उन दोनों को पाक ठहराना, ");
INSERT INTO urd_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ताकि यह सब बनी — इस्राईल की तरफ़ से हमेशा के लिए हारून और उसके बेटों का हक़ हो क्यूँकि यह उठाए जाने का हदिया है। इसलिए यह बनी — इस्राईल की तरफ़ से उनकी सलामती के ज़बीहों में से उठाए जाने का हदिया होगा, जो उनकी तरफ़ से ख़ुदावन्द के लिए उठाया गया है। ");
INSERT INTO urd_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","'और हारून के बाद उसके पाक लिबास उसकी औलाद के लिए होंगे ताकि उन ही में वह मसह — ओ — मख़्सूस किए जाएँ। ");
INSERT INTO urd_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","उसका जो बेटा उसकी जगह काहिन हो वह जब पाक मक़ाम में ख़िदमत करने को ख़ेमा — ए — इजितमा'अ में दाख़िल हो तो उनको सात दिन तक पहने रहे। ");
INSERT INTO urd_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“और तू ख़ास मेंढे को लेकर उसके गोश्त को किसी पाक जगह में उबालना। ");
INSERT INTO urd_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","और हारून और उसके बेटे मेंढे का गोश्त और टोकरी की रोटियाँ ख़ेमा — ए — इजितमा'अ के दरवाज़े पर खाएँ। ");
INSERT INTO urd_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","और जिन चीज़ों से उनको मख़्सूस और पाक करने के लिए कफ़्फ़ारा दिया जाए वह उनको भी खाएँ, लेकिन अजनबी शख़्स उनमें से कुछ न खाने पाए क्यूँकि यह चीजें पाक हैं। ");
INSERT INTO urd_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","और अगर मख़्सूस करने के गोश्त या रोटी में से कुछ सुबह तक बचा रह जाए तो उस बचे हुए को आग से जला देना, वह हरगिज़ न खाया जाए इसलिए कि वह पाक है। ");
INSERT INTO urd_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“और तू हारून और उसके बेटों के साथ जो कुछ मैंने हुक्म दिया है वह सब 'अमल में लाना, और सात दिन तक उनको मख़्सूस करते रहना। ");
INSERT INTO urd_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","और तू हर रोज़ ख़ता की क़ुर्बानी के बछड़े को कफ़्फ़ारे के लिए ज़बह करना; और तू क़ुर्बानगाह को उसके कफ़्फ़ारा देने के वक़्त साफ़ करना, और उसे मसह करना ताकि वह पाक हो जाए, ");
INSERT INTO urd_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","तू सात दिन तक क़ुर्बानगाह के लिए कफ़्फ़ारा देना और उसे पाक करना तो क़ुर्बानगाह निहायत पाक हो जाएगी, और जो कुछ उससे छू जाएगा वह भी पाक ठहरेगा ");
INSERT INTO urd_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“और तू हर रोज़ सदा एक — एक बरस के दो — दो बर्रे क़ुर्बानगाह पर चढ़ाया करना। ");
INSERT INTO urd_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","एक बर्रा सुबह को और दूसरा बर्रा ज़वाल और गु़रूब के बीच चढ़ाना। ");
INSERT INTO urd_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","और एक बर्रे के साथ ऐफ़ा के दसवें हिस्से के बराबर मैदा देना, जिसमें हीन के चौथे हिस्से की मिक़्दार में कूट कर निकाला हुआ तेल मिला हुआ हो और हीन के चौथे हिस्से की मिक़्दार में तपावन के लिए मय भी देना। ");
INSERT INTO urd_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","और तू दूसरे बर्रे को ज़वाल और गु़रूब के बीच चढ़ाना और उसके साथ सुबह की तरह नज़्र की क़ुर्बानी और वैसा ही तपावन देना, जिससे वह ख़ुदावन्द के लिए राहतअंगेज़ ख़ुशबू और आतिशीन क़ुर्बानी ठहरे। ");
INSERT INTO urd_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","ऐसी ही सोख़्तनी क़ुर्बानी तुम्हारी नसल दर नसल ख़ेमा — ए — इजितमा'अ के दरवाज़े पर ख़ुदावन्द के आगे हमेशा हुआ करे। वहाँ मैं तुम से मिलूँगा और तुझ से बातें करूँगा। ");
INSERT INTO urd_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","और वहीं मैं बनी इस्राईल से मुलाक़ात करूँगा और वह मक़ाम मेरे जलाल से पाक होगा। ");
INSERT INTO urd_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","और मैं ख़ेमा — ए — इजितमा'अ को और क़ुर्बानगाह को पाक करूँगा, और मैं हारून और उसके बेटों को पाक करूँगा ताकि वह मेरे लिए काहिन की ख़िदमत की अन्जाम दें। ");
INSERT INTO urd_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","और मैं बनी — इस्राईल के बीच सुकूनत करूँगा और उनका ख़ुदा हूँगा। ");
INSERT INTO urd_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","तब वह जान लेंगे कि मैं ख़ुदावन्द उनका ख़ुदा हूँ जो उनको मुल्क — ए — मिस्र से इसलिए निकाल कर लाया कि मैं उनके बीच सुकूनत करूँ। मैं ही ख़ुदावन्द उनका ख़ुदा हूँ। ");
INSERT INTO urd_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","और तू ख़ुशबू जलाने के लिए कीकर की लकड़ी की एक क़ुर्बानगाह बनाना। ");
INSERT INTO urd_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","उसकी लम्बाई एक हाथ और चौड़ाई एक हाथ हो, वह चौखुन्टी रहे और उसकी ऊँचाई दो हाथ हो और उसके सींग उसी टुकड़े से बनाए जाएँ। ");
INSERT INTO urd_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","और तू उसकी ऊपर की सतह और चारों पहलूओं को जो उसके चारों ओर हैं, और उसके सींगों को ख़ालिस सोने से मढ़ना और उसके लिए चारों ओर एक ज़रीन ताज बनाना। ");
INSERT INTO urd_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","और तू उस ताज के नीचे उसके दोनों पहलुओं में सोने के दो कड़े उसकी दोनों तरफ़ बनाना। वह उसके उठाने की चोबों के लिए ख़ानों का काम देंगे। ");
INSERT INTO urd_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","और चोबें कीकर की लकड़ी की बना कर उनको सोने से मंढना। ");
INSERT INTO urd_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","और तू उसको उस पर्दे के आगे रखना जो शहादत के सन्दूक के सामने है; वह सरपोश के सामने रहे जो शहादत के सन्दूक के ऊपर है, जहाँ मैं तुझ से मिला करूँगा। ");
INSERT INTO urd_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“इसी पर हारून ख़ुशबूदार ख़ुशबू जलाया करे, हर सुबह चराग़ों को ठीक करते वक़्त ख़ुशबू जलाएँ। ");
INSERT INTO urd_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","और ज़वाल और गु़रूब के बीच भी जब हारून चरागों को रोशन करे तब ख़ुशबू जलाए, यह ख़ुशबू ख़ुदावन्द के सामने तुम्हारी नसल — दर — नसल हमेशा जलाया जाए। ");
INSERT INTO urd_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","और तुम उस पर और तरह की ख़ुशबू न जलाना, न उस पर सोख़्तनी क़ुर्बानी और नज़र की क़ुर्बानी चढ़ाना और कोई तपावन भी उस पर न तपाना। ");
INSERT INTO urd_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","और हारून साल में एक बार उसके सींगों पर कफ़्फ़ारा दे। तुम्हारी नसल — दर — नसल साल में एक बार इस ख़ता की क़ुर्बानी के ख़ून से जो कफ़्फ़ारे के लिए हो, उसके लिए कफ़्फ़ारा दिया जाए। यह ख़ुदावन्द के लिए सबसे ज़्यादा पाक है।” ");
INSERT INTO urd_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“जब तू बनी — इस्राईल का शुमार करे तो जितनों का शुमार हुआ हो वह फ़ी — मर्द शुमार के वक़्त अपनी जान का फ़िदिया ख़ुदावन्द के लिए दें, ताकि जब तू उनका शुमार कर रहा हो उस वक़्त कोई वबा उनमें फैलने न पाए। ");
INSERT INTO urd_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","हर एक जो निकल — निकल कर शुमार किए हुओं में मिलता जाए, वह मक़दिस की मिस्काल के हिसाब से नीम मिस्काल दे। मिस्काल बीस जीरहों की होती है। यह नीम मिस्काल ख़ुदावन्द के लिए नज़र है। ");
INSERT INTO urd_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","जितने बीस बरस के या इससे ज़्यादा उम्र के निकल निकल कर शुमार किए हुओं में मिलते जाएँ, उनमें से हर एक ख़ुदावन्द की नज़्र दे। ");
INSERT INTO urd_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","जब तुम्हारी जानों के कफ़्फ़ारे के लिए ख़ुदावन्द की नज़्र दी जाए, तो दौलतमन्द नीम मिस्काल से ज़्यादा न दे और न ग़रीब उससे कम दे। ");
INSERT INTO urd_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","और तू बनी — इस्राईल से कफ़्फ़ारे की नक़्दी लेकर उसे ख़ेमा — ए — इजितमा'अ के काम में लगाना। ताकि वह बनी — इस्राईल की तरफ़ से तुम्हारी जानों के कफ़्फ़ारे के लिए ख़ुदावन्द के सामने यादगार हो।” ");
INSERT INTO urd_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","फिर ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“तू धोने के लिए पीतल का एक हौज़ और पीतल ही की उसकी कुर्सी बनाना, और उसे ख़ेमा — ए — इजितमा'अ और क़ुर्बानगाह के बीच में रख कर उसमें पानी भर देना। ");
INSERT INTO urd_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","और हारून और उसके बेटे अपने हाथ पाँव उससे धोया करें। ");
INSERT INTO urd_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ख़ेमा — ए — इजितमा'अ में दाख़िल होते वक़्त पानी से धो लिया करें ताकि हलाक न हों, या जब वह क़ुर्बानगाह के नज़दीक ख़िदमत के लिए या'नी ख़ुदावन्द के लिए सोख़्तनी क़ुर्बानी पेश करने को आएँ, ");
INSERT INTO urd_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","तो अपने — अपने हाथ पाँव धो लें ताकि मर न जाएँ। यह उसके और उसकी औलाद के लिए नसल — दर — नसल हमेशा की रिवायत हो।” ");
INSERT INTO urd_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","कि तू मक़दिस की मिस्काल के हिसाब से ख़ास — ख़ास खु़शबूदार मसाल्हे लेना; या'नी अपने आप निकला हुआ मुर्र पाँच सौ मिस्काल, और उसका आधा या'नी ढाई सौ मिस्काल दारचीनी, और ख़ुशबूदार अगर ढाई सौ मिस्काल, ");
INSERT INTO urd_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","और तज पाँच सौ मिस्काल, और जैतून का तेल एक हीन; ");
INSERT INTO urd_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","और तू उनसे मसह करने का पाक तेल बनाना, या'नी उनकी गन्धी की हिकमत के मुताबिक़ मिला कर एक ख़ुशबूदार रौग़न तैयार करना। यही मसह करने का पाक तेल होगा। ");
INSERT INTO urd_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","इसी से तू ख़ेमा — ए — इजितमा'अ को, और शहादत के सन्दूक को, ");
INSERT INTO urd_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","और मेज़ को उसके बर्तन के साथ, और शमा'दान को उसके बर्तन के साथ, और ख़ुशबू जलाने की क़ुर्बानगाह को ");
INSERT INTO urd_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","और सोख़्तनी क़ुर्बानी पेश करने के मज़बह को उसके सब बर्तन के साथ, और हौज़ को और उसकी कुर्सी को मसह करना; ");
INSERT INTO urd_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","और तू उनको पाक करना ताकि वह निहायत पाक हो जाएँ, जो कुछ उनसे छू जाएगा वह पाक ठहरेगा। ");
INSERT INTO urd_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“और तू हारून और उसके बेटों को मसह करना और उनको पाक करना ताकि वह मेरे लिए काहिन की ख़िदमत को अन्जाम दें। ");
INSERT INTO urd_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","और तू बनी — इस्राईल से कह देना, 'यह तेल मेरे लिए तुम्हारी नसल दर नसल मसह करने का पाक तेल होगा। ");
INSERT INTO urd_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","यह किसी आदमी के जिस्म पर न डाला जाए, और न तुम कोई और रौग़न इसकी तरकीब से बनाना; इस लिए के यह पाक है और तुम्हारे नज़दीक पाक ठहरे। ");
INSERT INTO urd_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","जो कोई इसकी तरह कुछ बनाए या इसमें, से कुछ किसी अजनबी पर लगाए वह अपनी कौम में से काट डाला जाए।” ");
INSERT INTO urd_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","और ख़ुदावन्द ने मूसा से कहा, “तू ख़ुशबूदार मसाल्हे मुर्र और मस्तकी और लौन और खु़शबूदार मसाल्हे के साथ ख़ालिस लुबान वज्न में बराबर — बराबर लेना, ");
INSERT INTO urd_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","और नमक मिलाकर उनसे गन्धी की हिकमत के मुताबिक़ ख़ुशबूदार रोग़न की तरह साफ़ और पाक ख़ुशबू बनाना। ");
INSERT INTO urd_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","और इसमें से कुछ ख़ूब बारीक पीस कर ख़ेमा — ए — इजितमा'अ में शहादत के सन्दूक़ के सामने जहाँ मैं तुझ से मिला करूँगा रखना। यह तुम्हारे लिए निहायत पाक ठहरे। ");
INSERT INTO urd_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","और जो ख़ुशबू तू बनाए उसकी तरकीब के मुताबिक़ तुम अपने लिए कुछ न बनाना। वह ख़ुशबू तेरे नज़दीक ख़ुदावन्द के लिए पाक हो। ");
INSERT INTO urd_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","जो कोई सूघने के लिए भी उसकी तरह कुछ बनाए वह अपनी क़ौम में से काट डाला जाए।” ");
INSERT INTO urd_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","फिर ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“देख मैंने बज़लीएल — बिन — ऊरी, बिन हूर को यहूदाह के क़बीले में से नाम लेकर बुलाया है। ");
INSERT INTO urd_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","और मैंने उसको हिकमत और समझऔर 'इल्म और हर तरह की कारिगरी में अल्लाह के रूह से मा'मूर किया है। ");
INSERT INTO urd_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ताकि हुनरमन्दी के कामों को ईजाद करे, और सोने और चाँदी और पीतल की चीज़ें बनाए। ");
INSERT INTO urd_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","और पत्थर को जड़ने के लिए काटे और लकड़ी को तराशे, जिससे सब तरह की कारीगरी का काम हो। ");
INSERT INTO urd_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","और देख, मैंने अहलियाब को जो अख़ीसमक का बेटा और दान के क़बीले में से है उसका साथी मुक़र्रर किया है, और मैंने सब रौशन ज़मीरो के दिल में ऐसी समझ रख्खी है कि जिन — जिन चीज़ों का मैंने तुझ को हुक्म दिया है उन सभों को वह बना सकें। ");
INSERT INTO urd_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","या'नी ख़ेमा — ए — इजितमा'अ और शहादत का सन्दूक और सरपोश जो उसके ऊपर रहेगा, और ख़ेमें का सब सामान, ");
INSERT INTO urd_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","और मेज़ और उसके बर्तन, और ख़ालिस सोने का शमा'दान और उसके सब बर्तन, और ख़ुशबू जलाने की क़ुर्बानगाह, ");
INSERT INTO urd_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","और सब बर्तन, और हौज़ और उसकी कुर्सी, ");
INSERT INTO urd_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","और बेल — बूटे कढ़े हुए जामे और हारून काहिन के पाक लिबास और उसके बेटों के लिबास, ताकि काहिन की ख़िदमत को अन्जाम दें। ");
INSERT INTO urd_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","और मसह करने का तेल, और मक़दिस के लिए खु़शबूदार मसाल्हे का ख़ुशबू; इन सभों को वह जैसा मैंने तुझे हुक्म दिया है वैसा ही बनाएँ।” ");
INSERT INTO urd_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","कि तू बनी — इस्राईल से यह भी कह देना, 'तुम मेरे सबतों को ज़रूर मानना, इस लिए कि यह मेरे और तुम्हारे बीच तुम्हारी नसल दर नसल एक निशान रहेगा, ताकि तुम जानों कि मैं ख़ुदावन्द तुम्हारा पाक करने वाला हूँ। ");
INSERT INTO urd_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“फिर तुम सबत को मानना इस लिए कि वह तुम्हारे लिए पाक है, जो कोई उसकी बे हुरमती करे वह ज़रूर मार डाला जाए। जो उसमें कुछ काम करे वह अपनी क़ौम में से काट डाला जाए। ");
INSERT INTO urd_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","छ: दिन काम काज किया जाए लेकिन सातवाँ दिन आराम का सबत है जो ख़ुदावन्द के लिए पाक है, जो कोई सबत के दिन काम करे वह ज़रूर मार डाला जाए। ");
INSERT INTO urd_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","तब बनी — इस्राईल सबत को मानें और नसल दर नसल उसे हमेशा का 'अहद' जानकर उसका लिहाज़ रख्खें। ");
INSERT INTO urd_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","मेरे और बनी — इस्राईल के बीच यह हमेशा के लिए एक निशान रहेगा, इस लिए कि छ: दिन में ख़ुदावन्द ने आसमान और ज़मीन को पैदा किया और सातवें दिन आराम करके ताज़ा दम हुआ'।” ");
INSERT INTO urd_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","और जब ख़ुदावन्द कोह-ए-सीना पर मूसा से बातें कर चुका तो उसने उसे शहादत की दो तख़्तियाँ दीं, वह तख़्तियाँ पत्थर की और ख़ुदा के हाथ की लिख्खी हुई थीं। ");
INSERT INTO urd_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","और जब लोगों ने देखा कि मूसा ने पहाड़ से उतरने में देर लगाई तो वह हारून के पास जमा' होकर उससे कहने लगे, कि “उठ, हमारे लिए देवता बना दे जो हमारे आगे — आगे चले; क्यूँकि हम नहीं जानते कि इस मर्द मूसा को, जो हम को मुल्क — ए — मिस्र से निकाल कर लाया क्या हो गया?” ");
INSERT INTO urd_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","हारून ने उनसे कहा, “तुम्हारी बीवियों और लड़कों और लड़कियों के कानों में जो सोने की बालियाँ हैं उनको उतार कर मेरे पास ले आओ।” ");
INSERT INTO urd_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","चुनाँचे सब लोग उनके कानों से सोने की बालियाँ उतार — उतार कर उनको हारून के पास ले आए। ");
INSERT INTO urd_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","और उसने उनको उनके हाथों से लेकर एक ढाला हुआ बछड़ा बनाया, जिसकी सूरत छेनी से ठीक की। तब वह कहने लगे, “ऐ इस्राईल, यही तेरा वह देवता है जो तुझ को मुल्क — ए — मिस्र से निकाल कर लाया।” ");
INSERT INTO urd_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","यह देख कर हारून ने उसके आगे एक क़ुर्बानगाह बनाई और उसने 'ऐलान कर दिया कि “कल ख़ुदावन्द के लिए 'ईद होगी।” ");
INSERT INTO urd_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","और दूसरे दिन सुबह सवेरे उठ कर उन्होंने क़ुर्बानियाँ पेश कीं और सलामती की क़ुर्बानियाँ पेशअदा कीं फिर उन लोगों ने बैठ कर खाया — पिया और उठकर खेल — कूद में लग गए। ");
INSERT INTO urd_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","तब ख़ुदावन्द ने मूसा को कहा, नीचे जा, क्यूँकि तेरे लोग जिनको तू मुल्क — ए — मिस्र से निकाल लाया बिगड़ गए हैं। ");
INSERT INTO urd_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","वह उस राह से जिसका मैंने उनको हुक्म दिया था बहुत जल्द फिर गए हैं; उन्होंने अपने लिए ढाला हुआ बछड़ा बनाया और उसे पूजा और उसके लिए क़ुर्बानी चढ़ाकर यह भी कहा, कि “ऐ इस्राईल, यह तेरा वह देवता है जो तुझ को मुल्क — ए — मिस्र से निकाल कर लाया'।” ");
INSERT INTO urd_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","और ख़ुदावन्द ने मूसा से कहा, कि “मैं इस क़ौम को देखता हूँ कि यह बाग़ी क़ौम है। ");
INSERT INTO urd_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","इसलिए तू मुझे अब छोड़ दे कि मेरा ग़ज़ब उन पर भड़के और मैं उनको भसम कर दूँ, और मैं तुझे एक बड़ी क़ौम बनाऊँगा।” ");
INSERT INTO urd_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","तब मूसा ने ख़ुदावन्द अपने ख़ुदा के आगे मिन्नत करके कहा, ऐ ख़ुदावन्द, क्यूँ तेरा ग़ज़ब अपने लोगों पर भड़कता है जिनको तू क़ुव्वत — ए — 'अज़ीम और ताक़तवर हाथों से मुल्क — ए — मिस्र से निकाल कर लाया है? ");
INSERT INTO urd_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","मिस्री लोग यह क्यूँ कहने पाएँ, कि 'वह उनको बुराई के लिए निकाल ले गया, ताकि उनको पहाड़ों में मार डाले और उनको इस ज़मीन पर से फ़ना कर दे'? इसलिए तू अपने क़हर — ओ — ग़ज़ब से बाज़ रह और अपने लोगों से इस बुराई करने के ख़याल को छोड़ दे। ");
INSERT INTO urd_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","तू अपने बन्दों, अब्रहाम और इस्हाक़ और इस्राईल, को याद कर जिनसे तूने अपनी ही क़सम खा कर यह कहा था, कि मैं तुम्हारी नसल को आसमान के तारों की तरह बढ़ाऊँगा; और यह सारा मुल्क जिसका मैंने ज़िक्र किया है तुम्हारी नसल को बख़्शूँगा कि वह सदा उसके मालिक रहें।” ");
INSERT INTO urd_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","तब ख़ुदावन्द ने उस बुराई के ख़याल को छोड़ दिया जो उसने कहा था कि अपने लोगों से करेगा। ");
INSERT INTO urd_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","और मूसा शहादत की दोनों तख़्तियाँ हाथ में लिए हुए उल्टा फिरा और पहाड़ से नीचे उतरा; और वह तख़्तियाँ इधर से और उधर से दोनों तरफ़ से लिखी हुई थीं। ");
INSERT INTO urd_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","और वह तख़्तियाँ ख़ुदा ही की बनाई हुई थीं, और जो लिखा हुआ था वह भी ख़ुदा ही का लिखा और उन पर खुदा हुआ था। ");
INSERT INTO urd_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","और जब यशू'अ ने लोगों की ललकार की आवाज़ सुनी तो मूसा से कहा, कि “लश्करगाह में लड़ाई का शोर हो रहा है।” ");
INSERT INTO urd_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","मूसा ने कहा, यह आवाज़ न तो फ़तहमन्दों का नारा है, न मग़लूबों की फ़रियाद; बल्कि मुझे तो गाने वालों की आवाज़ सुनाई देती है।” ");
INSERT INTO urd_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","और लश्करगाह के नज़दीक आकर उसने वह बछड़ा और उनका नाचना देखा। तब मूसा का ग़ज़ब भड़का, और उसने उन तख़्तियाँ को अपने हाथों में से पटक दिया और उनकी पहाड़ के नीचे तोड़ डाला। ");
INSERT INTO urd_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","और उसने उस बछड़े को जिसे उन्होंने बनाया था लिया, और उसको आग में जलाया और उसे बारीक पीस कर पानी पर छिड़का और उसी में से बनी — इस्राईल को पिलवाया। ");
INSERT INTO urd_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","और मूसा ने हारून से कहा, कि “इन लोगों ने तेरे साथ क्या किया था जो तूने इनको इतने बड़े गुनाह में फँसा दिया?” ");
INSERT INTO urd_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","हारून ने कहा, कि “मेरे मालिक का ग़ज़ब न भड़के; तू इन लोगों को जानता है कि गुनाह पर तुले रहते हैं,' ");
INSERT INTO urd_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","चुनाँचे इन्हीं ने मुझ से कहा, कि 'हमारे लिए देवता बना दे जो हमारे आगे — आगे चले, क्यूँकि हम नहीं जानते कि इस आदमी मूसा को जो हम को मुल्क — ए — मिस्र से निकाल कर लाया क्या हो गया? ");
INSERT INTO urd_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","तब मैंने इनसे कहा, कि “जिसके यहाँ सोना हो वह उसे उतार लाए। तब इन्होंने उसे मुझ को दिया और मैंने उसे आग में डाला, तो यह बछड़ा निकल पड़ा।” ");
INSERT INTO urd_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","जब मूसा ने देखा कि लोग बेक़ाबू हो गए, क्यूँकि हारून ने उनको बेलगाम छोड़कर उनको उनके दुश्मनों के बीच ज़लील कर दिया, ");
INSERT INTO urd_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","तो मूसा ने लश्करगाह के दरवाज़े पर खड़े होकर कहा, जो — जो ख़ुदावन्द की तरफ़ है वह मेरे पास आ जाए।” तब सभी बनी लावी उसके पास जमा' हो गए। ");
INSERT INTO urd_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","और उसने उनसे कहा, कि “ख़ुदावन्द इस्राईल का ख़ुदा यूँ फ़रमाता है, कि तुम अपनी — अपनी रान से तलवार लटका कर फाटक — फाटक घूम — घूम कर सारी लश्करगाह में अपने अपने भाइयों और अपने अपने साथियों और अपने अपने पड़ोसियों को क़त्ल करते फिरो।” ");
INSERT INTO urd_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","और बनी लावी ने मूसा के कहने के मुवाफ़िक़ 'अमल किया; चुनाँचे उस दिन लोगों में से करीबन तीन हज़ार मर्द मारे गए। ");
INSERT INTO urd_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","और मूसा ने कहा, कि “आज ख़ुदावन्द के लिए अपने आपको मख़्सूस करो; बल्कि हर शख़्स अपने ही बेटे और अपने ही भाई के ख़िलाफ़ हो ताकि वह तुम को आज ही बरकत दे।” ");
INSERT INTO urd_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","और दूसरे दिन मूसा ने लोगों से कहा, कि “तुम ने बड़ा गुनाह किया; और अब मैं ख़ुदावन्द के पास ऊपर जाता हूँ शायद मैं तुम्हारे गुनाह का कफ़्फ़ारा दे सकूं।” ");
INSERT INTO urd_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","और मूसा ख़ुदावन्द के पास लौट कर गया और कहने लगा, 'हाय, इन लोगों ने बड़ा गुनाह किया कि अपने लिए सोने का देवता बनाया। ");
INSERT INTO urd_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","और अब अगर तू इनका गुनाह मु'आफ़ कर दे तो ख़ैर वरना मेरा नाम उस किताब में से जो तूने लिखी है मिटा दे।” ");
INSERT INTO urd_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","और ख़ुदावन्द ने मूसा से कहा, कि “जिसने मेरा गुनाह किया है मैं उसी के नाम को अपनी किताब में से मिटाऊँगा। ");
INSERT INTO urd_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","अब तू रवाना हो और लोगों को उस जगह ले जा जो मैंने तुझे बताई है। देख, मेरा फ़रिश्ता तेरे आगे — आगे चलेगा। लेकिन मैं अपने मुतालबे के दिन उनको उनके गुनाह की सज़ा दूँगा।” ");
INSERT INTO urd_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","और ख़ुदावन्द ने उन लोगों में वबा भेजी, क्यूँकि जो बछड़ा हारून ने बनाया वह उन्हीं का बनवाया हुआ था। ");
INSERT INTO urd_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","और ख़ुदावन्द ने मूसा से कहा, कि “उन लोगों को अपने साथ लेकर, जिनको तू मुल्क — ए — मिस्र से निकाल कर लाया, यहाँ से उस मुल्क की तरफ़ रवाना हो जिसके बारे में अब्रहाम और इस्हाक़ और या'क़ूब से मैंने क़सम खाकर कहा था कि इसे मैं तेरी नसल को दूँगा। ");
INSERT INTO urd_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","और मैं तेरे आगे — आगे एक फ़रिश्ते को भेजूँगा; और मैं कना'नियों और अमोरियों और हित्तियों और फ़रिज़्ज़ियों और हव्वियों और यबूसियों को निकाल दूँगा। ");
INSERT INTO urd_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","उस मुल्क में दूध और शहद बहता है; और चूँकि तू बाग़ी क़ौम है इस लिए मैं तेरे बीच में होकर न चलूँगा, कहीं ऐसा न हो कि मैं तुझ को राह में फ़ना कर डालूँ।” ");
INSERT INTO urd_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","लोग इस दहशतनाक ख़बर को सुन कर ग़मगीन हुए और किसी ने अपने ज़ेवर न पहने। ");
INSERT INTO urd_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","क्यूँकि ख़ुदावन्द ने मूसा से कह दिया था, कि “बनी — इस्राईल से कहना, कि 'तुम बाग़ी लोग हो, अगर मैं एक लम्हा भी तेरे बीच में होकर चलूँ तो तुझ को फ़ना कर दूँगा। फिर तू अपने ज़ेवर उतार डाल ताकि मुझे मा'लूम हो कि तेरे साथ क्या करना चाहिए।” ");
INSERT INTO urd_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","चुनाँचे बनी — इस्राईल होरिब पहाड़ से लेकर आगेआगे अपने ज़ेवरों को उतारे रहे। ");
INSERT INTO urd_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","और मूसा ख़ेमें को लेकर उसे लश्करगाह से बाहर बल्कि लश्करगाह से दूर लगा लिया करता था, और उसका नाम ख़ेमा — ए — इजितमा'अ रख्खा। और जो कोई ख़ुदावन्द का तालिब होता वह लश्करगाह के बाहर उसी ख़ेमे की तरफ़ चला जाता था। ");
INSERT INTO urd_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","और जब मूसा बाहर ख़ेमे की तरफ़ जाता तो सब लोग उठकर अपने — अपने ख़ेमे के दरवाज़े पर खड़े हो जाते और मूसा के पीछे देखते रहते थे, जब तक वह ख़ेमे के अन्दर दाख़िल न हो जाता। ");
INSERT INTO urd_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","और जब मूसा ख़ेमे के अन्दर चला जाता तो बादल का सुतून उतरकर ख़ेमे के दरवाज़े पर ठहरा रहता, और ख़ुदावन्द मूसा से बातें करने लगता। ");
INSERT INTO urd_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","और सब लोग बादल के सुतून को ख़ेमे के दरवाज़े पर ठहरा हुआ देखते थे, और सब लोग उठ — उठकर अपने — अपने ख़ेमे के दरवाज़े पर से उसे सिज्दा करते थे। ");
INSERT INTO urd_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","और जैसे कोई शख़्स अपने दोस्त से बात करता है वैसे ही ख़ुदावन्द आमने सामने होकर मूसा से बातें करता था। और मूसा लश्करगाह को लौट आता था, लेकिन उसका ख़ादिम यशू'अ जो नून का बेटा और जवान आदमी था ख़ेमे से बाहर नहीं निकलता था। ");
INSERT INTO urd_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","और मूसा ने ख़ुदावन्द से कहा, देख, तू मुझ से कहता है, कि “इन लोगों को ले चल, 'लेकिन मुझे यह नहीं बताया कि तू किसको मेरे पास भेजेगा। हालाँकि तूने यह भी कहा है, कि मैं तुझ को नाम से जानता हूँ और तुझ पर मेरे करम की नज़र है। ");
INSERT INTO urd_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","तब अगर मुझ पर तेरे करम की नज़र है तो मुझ को अपनी राह बता, जिससे मैं तुझे पहचान लूँ ताकि मुझ पर तेरे करम की नज़र रहे; और यह ख़याल रख कि यह क़ौम तेरी ही उम्मत है।” ");
INSERT INTO urd_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","तब उसने कहा, “मैं साथ चलूँगा और तुझे आराम दूँगा।” ");
INSERT INTO urd_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","मूसा ने कहा, अगर तू साथ न चले तो हम को यहाँ से आगे न ले जा। ");
INSERT INTO urd_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","क्यूँकि यह क्यूँ कर मा'लूम होगा कि मुझ पर और तेरे लोगों पर तेरे करम की नज़र है? क्या इसी तरह से नहीं कि तू हमारे साथ — साथ चले, ताकि मैं और तेरे लोग इस ज़मीन की सब क़ौमों से निराले ठहरें? ");
INSERT INTO urd_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ख़ुदावन्द ने मूसा से कहा, “मैं यह काम भी जिसका तूने ज़िक्र किया है, करूँगा क्यूँकि तुझ पर मेरे करम की नज़र है और मैं तुझ को नाम से पहचानता हूँ।” ");
INSERT INTO urd_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","तब वह बोल उठा, कि “मैं तेरी मिन्नत करता हूँ, मुझे अपना जलाल दिखा दे।” ");
INSERT INTO urd_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","उसने कहा, “मैं अपनी सारी नेकी तेरे सामने ज़ाहिर करूँगा और तेरे ही सामने ख़ुदावन्द के नाम का 'ऐलान करूँगा; और मैं जिस पर मेहरबान होना चाहूँ मेहरबान हूँगा, और जिस पर रहम करना चाहूँ रहम करूँगा।” ");
INSERT INTO urd_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","और यह भी कहा, “तू मेरा चेहरा नहीं देख सकता, क्यूँकि इंसान मुझे देख कर ज़िन्दा नहीं रहेगा।” ");
INSERT INTO urd_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","फिर ख़ुदावन्द ने कहा, “देख, मेरे क़रीब ही एक जगह है, इसलिए तू उस चट्टान पर खड़ा हो। ");
INSERT INTO urd_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","और जब तक मेरा जलाल गुज़रता रहेगा मैं तुझे उस चट्टान के शिगाफ़ में रख्खूँगा, और जब तक मैं निकल न जाऊँ तुझे अपने हाथ से ढाँके रहूँगा। ");
INSERT INTO urd_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","इसके बाद मैं अपना हाथ उठा लूँगा, और तू मेरा पीछा देखेगा लेकिन मेरा चेहरा दिखाई नहीं देगा।” ");
INSERT INTO urd_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","फिर ख़ुदावन्द ने मूसा से कहा पहली तख़्तियों की तरह दो तख़्तियाँ अपने लिए तराश लेना; और मैं उन तख़्तियों पर वही बातें लिख दूँगा जो पहली तख़्तियों पर, जिनको तूने तोड़ डाला मरकू़म थीं। ");
INSERT INTO urd_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","और सुबह तक तैयार हो जाना, और सवेरे ही कोह-ए-सीना पर आकर वहाँ पहाड़ की चोटी पर मेरे सामने हाज़िर होना। ");
INSERT INTO urd_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","लेकिन तेरे साथ कोई और आदमी न आए, और न पहाड़ पर कहीं कोई दूसरा शख़्स दिखाई दे। भेड़ बकरियाँ और गाय — बैल भी पहाड़ के सामने चरने न पाएँ। ");
INSERT INTO urd_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","और मूसा ने पहली तख़्तियों की तरह पत्थर की दो तख़्तियाँ तराशीं, और सुबह सवेरे उठ कर पत्थर की दोनों तख़्तियाँ हाथ में लिए हुए ख़ुदावन्द के हुक्म के मुताबिक़ कोह-ए-सीना पर चढ़ गया। ");
INSERT INTO urd_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","तब ख़ुदावन्द बादल में हो कर उतरा और उसके साथ वहाँ खड़े हो कर ख़ुदावन्द के नाम का 'ऐलान किया। ");
INSERT INTO urd_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","और ख़ुदावन्द उसके आगे से यह पुकारता हुआ गुज़रा “ख़ुदावन्द, ख़ुदावन्द ख़ुदा — ए — रहीम और मेहरबान, क़हर करने में धीमा और शफ़क़त और वफ़ा में ग़नी। ");
INSERT INTO urd_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","हज़ारों पर फ़ज़ल करने वाला, गुनाह और तक़सीर और ख़ता का बख़्शने वाला; लेकिन वह मुजरिम को हरगिज़ बरी नहीं करेगा, बल्कि बाप — दादा के गुनाह की सज़ा उनके बेटों और पोतों को तीसरी और चौथी नसल तक देता है।” ");
INSERT INTO urd_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","तब मूसा ने जल्दी से सिर झुका कर सिज्दा किया, ");
INSERT INTO urd_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","और कहा, ऐ ख़ुदावन्द, “अगर मुझ पर तेरे करम की नज़र है, तो ऐ ख़ुदावन्द, मैं तेरी मिन्नत करता हूँ कि हमारे बीच में होकर चल, अगरचे यह क़ौम बाग़ी है, और तू हमारे गुनाह और ख़ता को मु'आफ़ कर और हम को अपनी मीरास कर ले।” ");
INSERT INTO urd_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","उसने कहा, देख, मैं 'अहद बाँधता हूँ, कि तेरे सब लोगों के सामने ऐसी करामात करूँगा जो दुनिया भर में और किसी क़ौम में कभी की नहीं गई; और वह सब लोग जिनके बीच तू रहता है, ख़ुदावन्द के काम को देखेंगे क्यूँकि जो मैं तुम लोगों से करने को हूँ वह हैबतनाक काम होगा। ");
INSERT INTO urd_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","आज के दिन जो हुक्म मैं तुझे देता हूँ, तू उसे याद रखना। देख, मैं अमोरियों और कना'नियों और हित्तियों और फ़रिज़्ज़यों और हव्वियों और यबूसियों को तेरे आगे से निकालता हूँ। ");
INSERT INTO urd_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","इसलिए ख़बरदार रहना कि जिस मुल्क को तू जाता है उसके बाशिन्दों से कोई 'अहद न बाँधना, ऐसा न हो कि वह तेरे लिए फन्दा ठहरें। ");
INSERT INTO urd_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","बल्कि तुम उनकी क़ुर्बानगाहों को ढा देना, और उनके सुतूनों के टुकड़े — टुकड़े कर देना, और उनकी यसीरतों को काट डालना। ");
INSERT INTO urd_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","क्यूँकि तुझ को किसी दूसरे मा'बूद की परस्तिश नहीं करनी होगी, इसलिए कि ख़ुदावन्द जिसका नाम ग़य्यूर है वह ख़ुदा — ए — ग़य्यूर है भी। ");
INSERT INTO urd_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","कहीं ऐसा न हो कि तू उस मुल्क के बाशिन्दों से कोई 'अहद बाँध ले और जब वह अपने मा'बूदों की पैरवी में ज़िनाकार ठहरें और अपने मा'बूदों के लिए क़ुर्बानी करें, और कोई तुझ को दा'वत दे और तू उसकी क़ुर्बानी में से कुछ खा ले; ");
INSERT INTO urd_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","और तू उनकी बेटियाँ अपने बेटों से ब्याहे और उनकी बेटियाँ अपने मा'बूदों की पैरवी में ज़िनाकार ठहरें, और तेरे बेटों को भी अपने मा'बूदों की पैरवी में ज़िनाकार बना दें। ");
INSERT INTO urd_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“तू अपने लिए ढाले हुए देवता न बना लेना। ");
INSERT INTO urd_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“तू बेख़मीरी रोटी की 'ईद माना करना। मेरे हुक्म के मुताबिक़ सात दिन तक अबीब के महीने में वक़्त — ए — मुअय्यना पर बेख़मीरी रोटियाँ खाना; क्यूँकि माह — ए — अबीब में तू मिस्र से निकला था। ");
INSERT INTO urd_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","सब पहलौठे मेरे हैं: और तेरे चौपायों में जो नर पहलौटे हों, क्या बछड़े, क्या बर्रे सब मेरे होंगे। ");
INSERT INTO urd_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","लेकिन गधे के पहले बच्चे का फ़िदिया बर्रा देकर होगा, और अगर तू फ़िदिया देना न चाहे तो उसकी गर्दन तोड़ डालना; लेकिन अपने सब पहलौठे बेटों का फ़िदिया ज़रूर देना। और कोई मेरे सामने ख़ाली हाथ दिखाई न दे। ");
INSERT INTO urd_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“छ: दिन काम काज करना लेकिन सातवें दिन आराम करना, हल जोतने और फ़सल काटने के मौसम में भी आराम करना। ");
INSERT INTO urd_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","और तू गेहूँ के पहले फल के काटने के वक़्त हफ़्तों की 'ईद, और साल के आख़िर में फ़सल जमा' करने की 'ईद माना करना। ");
INSERT INTO urd_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","तेरे सब मर्द साल में तीन बार ख़ुदावन्द ख़ुदा के आगे जो इस्राईल का ख़ुदा है, हाज़िर हों। ");
INSERT INTO urd_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","क्यूँकि मैं क़ौमों को तेरे आगे से निकाल कर तेरी सरहदों को बढ़ा दूँगा, और जब साल में तीन बार तू ख़ुदावन्द अपने ख़ुदा के आगे हाज़िर होगा तो कोई शख़्स तेरी ज़मीन का लालच न करेगा। ");
INSERT INTO urd_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“तू मेरी क़ुर्बानी का ख़ून ख़मीरी रोटी के साथ न पेश करना, और 'ईद — ए — फ़सह की क़ुर्बानी में से कुछ सुबह तक बाक़ी न रहने देना। ");
INSERT INTO urd_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","अपनी ज़मीन की पहली पैदावार का पहला फल ख़ुदावन्द अपने ख़ुदा के घर में लाना। हलवान को उसकी माँ के दूध में न पकाना।” ");
INSERT INTO urd_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","और ख़ुदावन्द ने मूसा से कहा, कि “तू यह बातें लिख; क्यूँकि इन्हीं बातों के मतलब के मुताबिक़ मैं तुझ से और इस्राईल से 'अहद बाँधता हूँ।” ");
INSERT INTO urd_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","तब वह चालीस दिन और चालीस रात वहीं ख़ुदावन्द के पास रहा और न रोटी खाई और न पानी पिया, और उसने उन तख़्तियों पर उस 'अहद की बातों को या'नी दस अहकाम को लिखा। ");
INSERT INTO urd_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","और जब मूसा शहादत की दोनों तख़्तियाँ अपने हाथ में लिए हुए कोह-ए-सीना से उतरा आता था, तो पहाड़ से नीचे उतरते वक़्त उसे ख़बर न थी कि ख़ुदावन्द के साथ बातें करने की वजह से उसका चेहरा चमक रहा है। ");
INSERT INTO urd_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","और जब हारून और बनी इस्राईल ने मूसा पर नज़र की और उसके चेहरे को चमकते देखा तो उसके नज़दीक आने से डरे। ");
INSERT INTO urd_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","तब मूसा ने उनको बुलाया; और हारून और जमा'अत के सब सरदार उसके पास लौट आए और मूसा उन से बातें करने लगा। ");
INSERT INTO urd_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","और बाद में सब बनी इस्राईल नज़दीक आए और उसने वह सब अहकाम जो ख़ुदावन्द ने कोह-ए-सीना पर बातें करते वक़्त उसे दिए थे उनको बताए। ");
INSERT INTO urd_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","और जब मूसा उनसे बातें कर चुका तो उसने अपने मुँह पर नक़ाब डाल लिया। ");
INSERT INTO urd_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","और जब मूसा ख़ुदावन्द से बातें करने के लिए उसके सामने जाता तो बाहर निकलने के वक़्त तक नक़ाब को उतारे रहता था; और जो हुक्म उसे मिलता था, वह उसे बाहर आकर बनी — इस्राईल को बता देता था। ");
INSERT INTO urd_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","और बनी — इस्राईल मूसा के चेहरे को देखते थे कि उसके चेहरे की जिल्द चमक रही है; और जब तक मूसा ख़ुदावन्द से बातें करने न जाता तब तक अपने मुँह पर नक़ाब डाले रहता। ");
INSERT INTO urd_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","और मूसा ने बनी — इस्राईल की सारी जमा'अत को जमा' करके कहा, जिन बातों पर 'अमल करने का हुक्म ख़ुदावन्द ने तुम को दिया है वह यह हैं। ");
INSERT INTO urd_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","छ: दिन काम लिए रोज़ — ए — मुक़द्दस या'नी ख़ुदावन्द के आराम का सबत हो; जो कोई उसमें कुछ काम करे वह मार डाला जाए। ");
INSERT INTO urd_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","तुम सबत के दिन अपने घरों में कहीं भी आग न जलाना।” ");
INSERT INTO urd_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","और मूसा ने बनी — इस्राईल की सारी जमा'अत से कहा, जिस बात का हुक्म ख़ुदावन्द ने दिया है वह यह है, कि ");
INSERT INTO urd_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","तुम अपने पास से ख़ुदावन्द के लिए हदिया लाया करो। जिस किसी के दिल की खु़शी हो वह ख़ुदावन्द का हदिया लाये सोना और चाँदी और पीतल, ");
INSERT INTO urd_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","और आसमानी रंग और अर्ग़वानी रंगऔर सुर्ख़ रंग के कपड़े, और महीन कतान, और बकरियों की पश्म, ");
INSERT INTO urd_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","और मेंढों की सुर्ख़ रंगी हुई खालें और तुख़्स की खालें और कीकर की लकड़ी, ");
INSERT INTO urd_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","और जलाने का तेल, और मसह करने के तेल के लिए और ख़ुशबूदार ख़ुशबू के लिए मसाल्हे, ");
INSERT INTO urd_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","और अफ़ोद और सीनाबन्द के लिए सुलेमानी पत्थर और और जड़ाऊ पत्थर। ");
INSERT INTO urd_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“और तुम्हारे बीच जो रौशन ज़मीर हैं, वह आकर वह चीजें बनाएँ जिनका हुक्म ख़ुदावन्द ने दिया है। ");
INSERT INTO urd_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","या'नी घर और उसका ख़ेमा और ग़िलाफ़ और उसकी घुन्डियाँ और तख़्तें और बेंडे और उसके सुतून, और ख़ाने, ");
INSERT INTO urd_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","सन्दूक और उसकी चोबें, सरपोश और बीच का पर्दा, ");
INSERT INTO urd_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","मेज़ और उसकी चोबें और उसके सब बर्तन, और नज़्र की रोटियाँ, ");
INSERT INTO urd_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","और रोशनी के लिए शमा 'दान और उसके बर्तन और चराग़ और जलाने का तेल; ");
INSERT INTO urd_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","और ख़ुशबू जलाने की क़ुर्बान गाह और उसकी चोबें और मसह करने का तेल, और ख़ुशबूदार ख़ुशबू; और घर के दरवाज़े के लिए दरवाज़े का पर्दा, ");
INSERT INTO urd_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","और सोख़्तनी क़ुर्बानी का मज़बह, और उसके लिए पीतल की झंजरी और उसकी चोबें और उसके सब बर्तन, और हौज़ और उसकी कुर्सी; ");
INSERT INTO urd_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","और सहन के पर्दे सुतूनों के साथ और उनके ख़ाने, और सहन के दरवाज़े का पर्दा, ");
INSERT INTO urd_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","और घर की मेंख़े, और सहन की मेखें, और उन दोनों की रस्सियाँ, ");
INSERT INTO urd_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","और मकदिस की खिदमत के लिए बेल बूटे कढ़े हुए लिबास, और हारून काहिन के लिए पाक लिबास और उसके बेटों के लिबास, ताकि वह काहिन की ख़िदमत को अन्जाम दें।” ");
INSERT INTO urd_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","तब बनी — इस्राईल की सारी जमा'अत मूसा के पास से रुख़्सत हुई। ");
INSERT INTO urd_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","और जिस जिस का जी चाहा और जिस — जिस के दिल में रग़बत। हुई, वह ख़ेमा-ए-इजितमा'अ के काम और वहाँ की इबादत और पाक लिबास के लिए ख़ुदावन्द का हदिया लाया। ");
INSERT INTO urd_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","और क्या मर्द, क्या 'औरत, जितनों का दिल चाहा वह सब जुगनू बालियाँ, अँगूठियाँ और बाजूबन्द, जो सब सोने के ज़ेवर थे लाने लगे। इस तरीके से लोगों ने ख़ुदावन्द को सोने का हदिया दिया। ");
INSERT INTO urd_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","और जिस — जिस के पास आसमानी रंग और अर्ग़वानी रंग और सुर्ख़ रंग के कपड़े, और महीन कतान और बकरियों की पश्म और मेंढों की सुर्ख रंगी हुई खाले और तुख़स की खालें थीं, वह उनको ले आए। ");
INSERT INTO urd_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","जिसने चाँदी या पीतल का हदिया देना चाहा वह वैसा ही हदिया ख़ुदावन्द के लिए लाया, और जिस किसी के पास कीकर की लकड़ी थी वह उसी को ले आया। ");
INSERT INTO urd_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","और जितनी 'औरतें होशियार थीं उन्होंने अपने हाथों से कात — कात कर आसमानी और अर्ग़वानी और सुर्ख़ रंग के और महीन कतान के तार लाकर दिए। ");
INSERT INTO urd_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","और जितनी 'औरतों के दिल हिकमत की तरफ़ मायल थे उन्होंने बकरियों की पश्म काती। ");
INSERT INTO urd_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","और जो सरदार थे वह अफ़ोद और सीना बन्द के लिए सुलेमानी पत्थर और जड़ाऊ पत्थर, ");
INSERT INTO urd_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","और रोशनी और मसह करने के तेल, और ख़ुशबूदार ख़ुशबू के लिए मसाल्हे और तेल लाए। ");
INSERT INTO urd_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","यूँ बनी — इस्राईल अपनी ही ख़ुशी से ख़ुदावन्द के लिए हदिये लाए, या'नी जिस — जिस मर्द या 'औरत का जी चाहा कि इन कामों के लिए जिनके बनने का हुक्म ख़ुदावन्द ने मूसा के ज़रिए' दिया था, कुछ दे वह उन्होंने दिया ");
INSERT INTO urd_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","और मूसा ने बनी — इस्राईल से कहा, देखो, ख़ुदावन्द ने बज़लीएल बिन ऊरी बिन हूर को जो यहूदाह के क़बीले में से है नाम लेकर बुलाया है। ");
INSERT INTO urd_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","और उसने उसे हिकमत और समझ और अक़्ल और हर तरह की कारीगरी के लिए रूह उल्लाह से मा'मूर किया है। ");
INSERT INTO urd_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","और कारीगरी में और सोना, चाँदी और पीतल के काम में, ");
INSERT INTO urd_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","और जड़ाऊ पत्थर और लकड़ी के तराशने में गरज़ हर एक नादिर काम के बनाने में माहिर किया है। ");
INSERT INTO urd_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","और उसने उसे और अख़ीसमक के बेटे अहलियाब को भी जो दान के क़बीले का है, हुनर सिखाने की क़ाबिलियत बख़्शी है। ");
INSERT INTO urd_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","और उनके दिलों में ऐसी हिकमत भर दी है जिससे वह हर तरह की कारीगरी में माहिर हों, और कन्दाकार का और माहिर उस्ताद का और ज़रदोज़ का जो आसमानी, अर्ग़वानी और सु़र्ख रंग के कपड़ों और महीन कतान पर गुलकारी करता है, और जूलाहे का और हर तरह के दस्तकार का काम कर सके और 'अजीब और नादिर चीजें ईजाद करें। ");
INSERT INTO urd_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","फिर बज़लीएल और अहलियाब और सब रोशन ज़मीर आदमी काम करें, जिनको ख़ुदावन्द ने हिकमत और समझ से मालामाल किया है ताकि वह मक़दिस की' इबादत के सब काम को ख़ुदावन्द के हुक्म के मुताबिक़ अन्जाम दें। ");
INSERT INTO urd_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","तब मूसा ने बज़लीएल और अहलियाब और सब रोशन ज़मीर आदमियों को बुलाया, जिनके दिल में ख़ुदावन्द ने हिकमत भर दी थी, या'नी जिनके दिल में तहरीक हुई कि जाकर काम करें। ");
INSERT INTO urd_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","और जो — जो हदिये बनी — इस्राईल लाए थे कि उनसे मक़दिस की इबादत की चीज़ें बनाई जाएँ, वह सब उन्होंने मूसा से ले लिए, और लोग फिर भी अपनी खु़शी से हर सुबह उसके पास हदिये लाते रहे। ");
INSERT INTO urd_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","तब वह सब 'अक़्लमन्द कारीगर जो मक़दिस के सब काम बना रहे थे, अपने — अपने काम को छोड़कर मूसा के पास आए, ");
INSERT INTO urd_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","और वह मूसा से कहने लगे, “कि लोग इस काम के सरअन्जाम के लिए, जिसके बनाने का हुक्म ख़ुदावन्द ने दिया है, ज़रूरत से बहुत ज़्यादा ले आए हैं।” ");
INSERT INTO urd_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","तब मूसा ने जो हुक्म दिया उसका 'ऐलान उन्होंने तमाम लश्करगाह में करा दिया: “कि कोई मर्द या 'औरत अब से मक़दिस के लिए हदिया देने की ग़र्ज़ से कुछ और काम न बनाएँ।” यूँ वह लोग और लाने से रोक दिए गए। ");
INSERT INTO urd_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","क्यूँकि जो सामान उनके पास पहुँच चुका था वह सारे काम को तैयार करने के लिए न सिर्फ़ काफ़ी बल्कि ज़्यादा था। ");
INSERT INTO urd_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","और काम करनेवालों में जितने रोशन ज़मीर थे, उन्होंने मक़दिस के लिए बारीक बटे हुए कतान के और आसमानी और अर्ग़वानी और सुर्ख़ रंग के कपड़ों के दस पर्दे बनाए, जिन पर माहिर उस्ताद के हाथ के कढ़े हुए करूबी थे। ");
INSERT INTO urd_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","हर पर्दे की लम्बाई अट्ठाईस हाथ और चौड़ाई चार हाथ थी और वह सब पर्दे एक ही नाप के थे। ");
INSERT INTO urd_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","और उसने पाँच पर्दे एक दूसरे के साथ जोड़ दिए और दूसरे पाँच पर्दे भी एक दूसरे के साथ जोड़ दिए। ");
INSERT INTO urd_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","और उसने एक बड़े पर्दे के हाशिये में उसके मिलाने के रुख़ पर आसमानी रंग के तुकमे बनाए। ऐसे ही तुकमे उसने दूसरे बड़े पर्दे की उस तरफ़ के हाशिये में बनाए जिधर मिलाने का रुख़ था। ");
INSERT INTO urd_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","पचास तुकमे उसने एक पर्दे में और पचास ही दूसरे पर्दे के हाशिये में उसके मिलाने के रुख़ पर बनाए, यह तुकमे आपस में एक दूसरे के सामने थे। ");
INSERT INTO urd_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","और उसने सोने की पचास घुन्डियाँ बनाई और उन्हीं घुन्डियों से पर्दों को आपस में ऐसा जोड़ दिया कि घर मिलकर एक हो गया। ");
INSERT INTO urd_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","और बकरी के बालों से ग्यारह पर्दे घर के ऊपर के ख़ेमे के लिए बनाए। ");
INSERT INTO urd_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","हर पर्दे की लम्बाई तीस हाथ और चौड़ाई चार हाथ थी, और वह ग्यारह पर्दे एक ही नाप के थे। ");
INSERT INTO urd_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","और उसने पाँच पर्दे तो एक साथ जोड़े और छ: एक साथ। ");
INSERT INTO urd_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","और पचास तुकमे उन जुड़े हुए पर्दों में से किनारे के पर्दे के हाशिये में बनाए और पचास ही तुकमे उन दूसरे जुड़े हुए पर्दों में से किनारे के पर्दे के हाशिये में बनाए। ");
INSERT INTO urd_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","और उसने पीतल की पचास घुन्डियाँ भी बनाई ताकि उनसे उस ख़ेमे को ऐसा जोड़ दे कि वह एक हो जाए। ");
INSERT INTO urd_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","और ख़ेमे के लिए एक ग़िलाफ़ मेंढों की सुर्ख़ रंगी हुई खालों का और उसके लिए ग़िलाफ़ तुख़स की खालों का बनाया। ");
INSERT INTO urd_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","और उसने घर के लिए कीकर की लकड़ी के तख़्ते बनाए कि खड़े किए जाएँ। ");
INSERT INTO urd_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","हर तख़्ते की लम्बाई दस हाथ और चौड़ाई डेढ़ हाथ थी। ");
INSERT INTO urd_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","और उसने एक एक तख़्ते के लिए दो — दो जुड़ी हुई चूलें बनाई, घर के सब तख़्तों की चूलें ऐसी ही बनाई। ");
INSERT INTO urd_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","और घर के लिए जो तख़्ते बने थे उनमें से बीस तख़्ते दाख्खिनी रुख़ में लगाए। ");
INSERT INTO urd_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","और उसने उन बीसों तख़्तों के नीचे चाँदी के चालीस ख़ाने बनाए, या'नी हर तख़्ते की दोनों चूलों के लिए दो — दो ख़ाने। ");
INSERT INTO urd_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","और घर की दूसरी तरफ़ या'नी उत्तरी रुख़ के लिए बीस तख़्ते बनाए। ");
INSERT INTO urd_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","और उनके लिए भी चाँदी के चालीस ही ख़ाने बनाए, या'नी एक — एक तख़्ते के नीचे दो — दो ख़ाने। ");
INSERT INTO urd_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","और घर के पिछले हिस्से या'नी पश्चिमी रुख़ के लिए छ: तख़्ते बनाए। ");
INSERT INTO urd_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","और दो तख़्ते घर के दोनों कोनों के लिए पिछले हिस्से में बनाए। ");
INSERT INTO urd_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","यह नीचे से दोहरे थे और इसी तरह ऊपर के सिरे तक आकर एक ही हल्के में मिला दिए गए थे, उसने दोनों कोनों के दोनों तख़्ते इसी ढब के बनाए। ");
INSERT INTO urd_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","वह, आठ तख़्ते थे और उनके लिए चाँदी के सोलह ख़ाने, या'नी एक — एक तख़्ते के लिए दो — दो ख़ाने। ");
INSERT INTO urd_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","और उसने कीकर की लकड़ी के बेन्डे बनाये पाँच बेन्डे घर के एक तरफ़ के तख़्तों के लिए, ");
INSERT INTO urd_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","और पाँच बेन्डे घर के दूसरी तरफ़ के तख़्तों के लिए, और पाँच बेन्डे घर के पिछले हिस्से में पश्चिम की तरफ़ के तख़्तों के लिए बनाए। ");
INSERT INTO urd_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","और उसने वस्ती बेन्डे को ऐसा बनाया कि तख़्तों के बीच में से होकर एक सिरे से दूसरे सिरे तक पहुँचे। ");
INSERT INTO urd_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","और तख़्तों को सोने से मंढ़ा और सोने के कड़े बनाए, ताकि बेन्डों के लिए ख़ानों का काम दें और बेन्डों को सोने से मंढ़ा। ");
INSERT INTO urd_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","और उसने बीच का पर्दा आसमानी, अर्ग़वानी और सुर्ख़ रंग के कपड़ों और बारीक बटे हुए कतान का बनाया जिस पर माहिर उस्ताद के हाथ के करूबी कढ़े हुए थे। ");
INSERT INTO urd_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","और उसके लिए कीकर के चार सुतून बनाए और उनको सोने से मंढ़ा, उनके कुन्डे सोने के थे और उसने उनके लिए चाँदी के चार ख़ाने ढाल कर बनाए। ");
INSERT INTO urd_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","और उसने ख़ेमे के दरवाज़े के लिए एक पर्दा आसमानी, अर्ग़वानी और सुर्ख़ रंग के कपड़ों और बारीक बटे हुए कतान का बनाया, वह बेल — बूटेदार था। ");
INSERT INTO urd_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","और उसके लिए पाँच सुतून कुन्डों समेत बनाए और उनके सिरों और पट्टियों को सोने से मंढ़ा, उनके लिए जो पाँच ख़ाने थे वह पीतल के बने हुए थे। ");
INSERT INTO urd_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","और बज़लीएल ने वह सन्दूक कीकर की लकड़ी का बनाया, उसकी लम्बाई ढाई हाथ और चौड़ाई डेढ़ हाथ और ऊँचाई डेढ़ हाथ थी। ");
INSERT INTO urd_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","और उसने उसके अन्दर और बाहर ख़ालिस सोना मंढा और उसके लिए चारों तरफ़ एक सोने का ताज बनाया। ");
INSERT INTO urd_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","और उसने उसके चारों पायों पर लगाने को सोने के चार कड़े ढाले, दो कड़े तो उसकी एक तरफ़ और दो दूसरी तरफ़ थे। ");
INSERT INTO urd_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","और उसने कीकर की लकड़ी की चोबें बनाकर उनको सोने से मंढ़ा। ");
INSERT INTO urd_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","और उन चोबों को सन्दूक के दोनों तरफ़ के कड़ों में डाला ताकि सन्दूक उठाया जाए। ");
INSERT INTO urd_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","और उसने सरपोश ख़ालिस सोने का बनाया, उसकी लम्बाई ढाई हाथ और चौड़ाई डेढ़ हाथ थी। ");
INSERT INTO urd_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","और उसने सरपोश के दोनों सिरों पर सोने के दो करूबी गढ़ कर बनाए। ");
INSERT INTO urd_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","एक करूबी को उसने एक सिरे पर रख्खा और दूसरे को दूसरे सिरे पर, दोनों सिरों के करूबी और सरपोश एक ही टुकड़े से बने थे। ");
INSERT INTO urd_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","और करूबियों के बाजू ऊपर से फैले हुए थे और उनके बाजूओं से सरपोश ढका हुआ था, और उन करूबियों के चेहरे सरपोश की तरफ़ और एक दूसरे के सामने थे। ");
INSERT INTO urd_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","और उसने वह मेज़ कीकर की लकड़ी की बनाई, उसकी लम्बाई दो हाथ और चौड़ाई एक हाथ और ऊँचाई डेढ़ हाथ थी। ");
INSERT INTO urd_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","और उसने उसको ख़ालिस सोने से मंढ़ा और उसके लिए चारों तरफ़ सोने का एक ताज बनाया। ");
INSERT INTO urd_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","और उसने एक कंगनी चार उंगल चौड़ी उसके चारों तरफ़ रख्खी और उस कंगनी पर चारों तरफ़ सोने का एक ताज बनाया। ");
INSERT INTO urd_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","और उसने उसके लिए सोने के चार कड़े ढाल कर उनको उसके चारों पायों के चारों कोनों में लगाया। ");
INSERT INTO urd_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","यह कड़े कंगनी के पास थे, ताकि मेज़ उठाने की चोबों के ख़ानों का काम दें। ");
INSERT INTO urd_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","और उसने मेज़ उठाने की वह चोबें कीकर की लकड़ी की बनाई और उनको सोने से मंढ़ा। ");
INSERT INTO urd_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","और उसने मेज़ पर के सब बर्तन, या'नी उसके तबाक़ और चमचे और बड़े — बड़े प्याले और उंडेलने के लोटे ख़ालिस सोने के बनाए। ");
INSERT INTO urd_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","और उसने शमा'दान ख़ालिस सोने का बनाया। वह शमा'दान और उसका पायाऔर उसकी डन्डी गढ़े हुए थे। यह सब और उसकी प्यालियाँ और लट्टू और फूल एक ही टुकड़े के बने हुए थे। ");
INSERT INTO urd_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","और छ: शाखें उसकी दोनों तरफ़ से निकली हुई थीं। शमा'दान की तीन शाख़ें तो उसकी एक तरफ़ से और तीन शाख़ उसकी दूसरी तरफ़ से। ");
INSERT INTO urd_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","और एक शाख़ में बादाम के फूल की शक्ल की तीन प्यालियाँ और एक लट्टू और एक फूल था, और दूसरी शाख़ में भी बादाम के फूल की शक्ल की तीन प्यालियाँ और एक लट्टू और एक फूल था। ग़र्ज़ उस शमा'दान की छहों शाखों में सब कुछ ऐसा ही था। ");
INSERT INTO urd_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","और ख़ुद शमा'दान में बादाम के फूल की शक्ल की चार प्यालियाँ अपने — अपने लट्टू और फूल समेत बनी थीं। ");
INSERT INTO urd_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","और शमा'दान की छहों निकली हुई शाख़ों में से हर दो — दो शाखें और एक — एक लट्टू एक ही टुकड़े के थे। ");
INSERT INTO urd_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","उनके लट्टू और उनकी शाख़ें सब एक ही टुकड़े के थे। सारा शमा'दान ख़ालिस सोने का और एक ही टुकड़े का गढ़ा हुआ था। ");
INSERT INTO urd_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","और उसने उसके लिए सात चराग़ बनाए और उसके गुलगीर और गुलदान ख़ालिस सोने के थे। ");
INSERT INTO urd_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","और उसने उसको और उसके सब बर्तन को एक किन्तार ख़ालिस सोने से बनाया ");
INSERT INTO urd_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","और उसने ख़ुशबू जलाने की क़ुर्बानगाह कीकर की लकड़ी की बनाई, उसकी लम्बाई एक हाथ और चौड़ाई एक हाथ थी। वह चौकोर थी और उसकी ऊँचाई दो हाथ थी और वह और उसके सींग एक ही टुकड़े के थे। ");
INSERT INTO urd_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","और उसने उसके ऊपर की सतह और चारों तरफ़ की अतराफ़ और सींगों को ख़ालिस सोने से मढ़ा और उसके लिए सोने का एक ताज चारों तरफ़ बनाया। ");
INSERT INTO urd_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","और उसने उसकी दोनों तरफ़ के दोनों पहलुओं में ताज के नीचे सोने के दो कड़े बनाए जो उसके उठाने की चोबों के लिए ख़ानों का काम दें। ");
INSERT INTO urd_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","और चोबें कीकर की लकड़ी की बनाई और उनको सोने से मढ़ा। ");
INSERT INTO urd_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","और उसने मसह करने का पाक तेल और खु़शबूदार मसाल्हे का ख़ालिस ख़ुशबू गन्धी की हिकमत के मुताबिक़ तैयार किया। ");
INSERT INTO urd_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","और उसने सोख़्तनी क़ुर्बानी का मज़बह कीकर की लकड़ी का बनाया; उसकी लम्बाई पाँच हाथ और चौड़ाई पाँच हाथ थी, वह चौकोर था और उसकी ऊँचाई तीन हाथ थी। ");
INSERT INTO urd_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","और उसने उसके चारों कोनों पर सींग बनाए सींग और वह मज़बह दोनों एक ही टुकड़े के थे, और उसने उसको पीतल से मंढ़ा। ");
INSERT INTO urd_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","और उसने मज़बह के सब बर्तन, या'नी देगें और बेलचे और कटोरे और सीहें और अंगूठियाँ बनायीं उसके सब बर्तन पीतल के थे। ");
INSERT INTO urd_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","और उसने मज़बह के लिए उसकी चारों तरफ़ किनारे के नीचे पीतल की जाली की झंजरी इस तरह लगाई कि वह उसकी आधी दूर तक पहुँचती थी। ");
INSERT INTO urd_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","और उसने पीतल की झंजरी के चारों कोनों में लगाने के लिए चार कड़े ढाले ताकि चोबों के लिए ख़ानों का काम दें। ");
INSERT INTO urd_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","और चोबें कीकर की लकड़ी की बनाकर उनको पीतल से मंढ़ा। ");
INSERT INTO urd_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","और उसने वह चोबें मज़बह की दोनों तरफ़ के कड़ों में उसके उठाने के लिए डाल दीं। वह खोखला तख़्तों का बना हुआ था। ");
INSERT INTO urd_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","और जो ख़िदमत गुज़ार 'औरतें ख़ेमा — ए — इजितमा'अ के दरवाज़े पर ख़िदमत करती थीं, उनके आईनों के पीतल से उसने पीतल का हौज़ और पीतल ही की उसकी कुर्सी बनाई। ");
INSERT INTO urd_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","फिर उसने सहन बनाया, और दख्खिनी रुख़ के लिए उस सहन के पर्दे बारीक बटे हुए कतान के थे और सब मिला कर सौ हाथ लम्बे थे। ");
INSERT INTO urd_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","उनके लिए बीस सुतून और उनके लिए पीतल के बीस ख़ाने थे, और सुतून के कुन्डे और पट्टियाँ चाँदी की थीं। ");
INSERT INTO urd_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","और उत्तरी रुख़ में भी वह सौ हाथ लम्बे और उनके लिए बीस सुतून और उनके लिए बीस ही पीतल के ख़ाने थे, और सुतूनों के कुन्डे और पट्टियाँ चाँदी की थीं। ");
INSERT INTO urd_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","और पश्चिमी रुख़ के लिए सब पर्दे मिला कर पचास हाथ के थे, उनके लिए दस सुतून और दस ही उनके ख़ाने थे और सुतूनों के कुन्डे और पट्टियाँ चाँदी की थीं। ");
INSERT INTO urd_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","और पूर्वी रुख़ में भी वह पचास ही हाथ के थे। ");
INSERT INTO urd_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","उसके दरवाज़े की एक तरफ़ पन्द्रह हाथ के पर्दे और उनके लिए तीन सुतून और तीन ख़ाने थे। ");
INSERT INTO urd_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","और दुसरी तरफ़ भी वैसा ही था तब सहन के दरवाज़े के इधर और उधर पंद्रह — पन्द्रह हाथ के पर्दे थे। उनके लिए तीन — तीन सुतून और तीन ही तीन ख़ाने थे। ");
INSERT INTO urd_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","सहन के चारों तरफ़ के सब पर्दे बारीक बटे हुए कतान के बुने हुए थे। ");
INSERT INTO urd_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","और सुतूनों के ख़ाने पीतल के और उनके कुंडे और पट्टियाँ चाँदी की थी। उनके सिरे चाँदी से मंढ़े हुए और सहन के कुल सुतून चाँदी की पट्टियों से जड़े हुए थे। ");
INSERT INTO urd_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","और सहन के दरवाज़े के पर्दे पर बेल बूटे का काम था, और वह आसमानी और अर्ग़वानी और सुर्ख़ रंग के कपड़े और बारीक बटे हुए कतान का बुना हुआ था; उसकी लम्बाई बीस हाथ और ऊँचाई सहन के पर्दे की चौड़ाई के मुताबिक़ पाँच हाथ थी। ");
INSERT INTO urd_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","उनके लिए चार सुतून और चार ही उनके लिए पीतल के ख़ाने थे, उनके कुन्दे चाँदी के थे और उनके सिरों पर चाँदी मंढी हुई थी और उनकी पट्टियाँ भी चाँदी की थीं। ");
INSERT INTO urd_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","और घर के और सहन के चारो तरफ़ की सब मेखे़ं पीतल की थीं ");
INSERT INTO urd_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","और घर या'नी मस्कन — ए — शहादत के जो सामान लावियों की ख़िदमत के लिए बने और जिनको मूसा के हुक्म के मुताबिक़ हारून काहिन के बेटे ऐतामर ने गिना, उनका हिसाब यह है। ");
INSERT INTO urd_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","बज़लीएल बिन — ऊरी बिन — हूर ने जो यहूदाह के क़बीले का था, सब कुछ जो ख़ुदावन्द ने मूसा को फ़रमाया था बनाया। ");
INSERT INTO urd_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","और उसके साथ दान के क़बीले का अहलियाब बिन अख़ीसमक था जो खोदने में माहिर कारीगर था और आसमानी और अर्ग़वानी और सुर्ख़ रंग के कपड़ो और बारीक कतान पर बेल — बूटे काढ़ता था ");
INSERT INTO urd_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","सब सोना जो मक़दिस की चीज़ों के काम में लगा, या'नी हदिये का सोना उन्तीस क़िन्तार और मक़दिस की मिस्क़ाल के हिसाब से एक हज़ार सात सौ पिछत्तर मिस्क़ाल था। ");
INSERT INTO urd_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","और जमा'त में से गिने हुए लोगों के हदिये की चाँदी एक सौ क़िन्तार और मक़दिस की मिस्क़ाल के हिसाब से एक हज़ार सात सौ पिछत्तर मिस्क़ाल थी। ");
INSERT INTO urd_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","मक़दिस की मिस्क़ाल के हिसाब से हरआदमी जो निकल कर शुमार किए हुओ में मिल गया एक बिका, या'नी नीम मिस्क़ाल बीस बरस और उससे ज़्यादा उम्र लोगों से लिया गया था यह छ: लाख तीन हज़ार साढ़े पाँच सौ मर्द थे। ");
INSERT INTO urd_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","इस सौ क़िन्तार चाँदी से मक़दिस के और बीच के पर्दे के ख़ाने ढाले गए, सौ क़िन्तार से सौ ही ख़ाने बने या'नी एक — एक क़िन्तार। एक — एक ख़ाने में लगा ");
INSERT INTO urd_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","और एक हज़ार सात सौ पिछत्तर मिस्क़ाल चाँदी से सुतूनों के कुन्डे बने और उनके सिरे मंढे गए और उनके लिए पट्टियाँ तैयार हुई। ");
INSERT INTO urd_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","और हदिये का पीतल सत्तर क़िन्तार और दो हज़ार चार सौ मिस्क़ाल था। ");
INSERT INTO urd_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","इससे उसने ख़ेमा — ए — इजितमा'अ के दरवाज़े के ख़ाने और पीतल का मज़बह और उसके लिए पीतल की झंजरी और मज़बह के सब बर्तन, ");
INSERT INTO urd_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","और सहन के चारों तरफ़ के ख़ाने और सहन के दरवाज़े के ख़ाने और घर की मेख़ें और सहन के चारों तरफ़ की मेख़ें बनाई। ");
INSERT INTO urd_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","और उन्होंने मक़दिस में ख़िदमत करने के लिए आसमानी और अर्ग़वानी और सुर्ख़ बेल बूटे कढ़े हुए लिबास और हारून के लिए पाक लिबास, जैसा ख़ुदावन्द ने मूसा को हुक्म दिया था बनाए। ");
INSERT INTO urd_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","और उसने सोने, और आसमानी और अर्ग़वानी और सुर्ख़ रंग के कपड़ों और बारीक बटे हुए कतान का अफ़ोद बनाया। ");
INSERT INTO urd_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","और उन्होंने सोना पीट पीट कर पतले — पतले पत्तर और पतरों को काट — काट कर तार बनाए, ताकि आसमानी और अर्ग़वानी और सुर्ख़ रंग के कपड़ों और बारीक बटे हुए कतान पर माहिर उस्ताद की तरह उनसे ज़रदोज़ी करें। ");
INSERT INTO urd_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","और अफ़ोद को जोड़ने के लिए उन्होंने दो मोंढे बनाए और उनके दोनों सिरों को मिलाकर बाँध दिया। ");
INSERT INTO urd_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","और उसके कसने के लिए कारीगरी से बुना हुआ कमरबन्द जो उसके ऊपर था, वह भी उसी टुकड़े और बनावट का था, या'नी सोने और आसमानी और अर्ग़वानी और सुर्ख़ रंग के कपड़ों और बारीक बटे हुए कतान का बना हुआ था; जैसा ख़ुदावन्द ने मूसा को हुक्म किया था। ");
INSERT INTO urd_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","और उन्होंने सुलेमानी पत्थर काट कर साफ़ किए जो सोने के ख़ानों में जड़े गए, और उन पर अँगूठी के नक़्श की तरह बनी इस्राईल के नाम खुदे थे। ");
INSERT INTO urd_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","और उसने उनको अफ़ोद के मोंढों पर लगाया ताकि वह बनी — इस्राईल की यादगारी के पत्थर हों, जैसा ख़ुदावन्द ने मूसा को हुक्म किया था। ");
INSERT INTO urd_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","और उसने अफ़ोद की बनावट का सीनाबन्द तैयार किया जो माहिर उस्ताद के हाथ का काम था, या'नी वह सोने और आसमानी और अर्ग़वानी और सुर्ख़ रंग के कपड़ों और बारीक बटे हुए कतान का बना हुआ था। ");
INSERT INTO urd_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","वह चौकोर था; उन्होंने उस सीनाबन्द को दोहरा बनाया और दोहरा होने पर उसकी लम्बाई एक बालिश्त और चौड़ाई एक बालिश्त थी। ");
INSERT INTO urd_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","इस पर चार कतारों में उन्होंने जवाहर जड़े। याकू़त — ए — सुर्ख़, और पुखराज, और ज़मुर्रुद की कतार तो पहली कतार थी। ");
INSERT INTO urd_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","और दूसरी क़तार में गौहर — ए — शब चराग़, और नीलम, और हीरा: ");
INSERT INTO urd_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","तीसरी कतार में लश्म, और यश्म, और याकू़त: ");
INSERT INTO urd_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","चौथी क़तार में फ़ीरोज़ा, और संग — ए — सुलेमानी, और ज़बरजद; यह सब अलग — अलग सोने के ख़ानों में जड़े हुए थे। ");
INSERT INTO urd_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","और यह पत्थर इस्राईल के बेटों के नामों के शुमार के मुताबिक़ बारह थे और अँगूठी के नक़्श की तरह बारह क़बीलों में से एक — एक का नाम अलग — अलग एक एक पत्थर पर ख़ुदा था। ");
INSERT INTO urd_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","और उन्होंने सीना बन्द पर डोरी की तरह गुन्धी हुई ख़ालिस सोने की ज़न्जीरें बनाई। ");
INSERT INTO urd_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","और उन्होंने सोने के दो ख़ाने और सोने के दो कड़े बनाए और दोनों कड़ों को सीनाबन्द के दोनों सिरों पर लगाया। ");
INSERT INTO urd_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","और सोने की दोनों गुन्धी हुई ज़न्जीरें उन कड़ों में पहनाई जो सीनाबन्द के सिरों पर थे ");
INSERT INTO urd_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","और दोनों गुन्धी हुई ज़न्जीरों के बाक़ी दोनों सिरों को दोनों ख़ानो में जड़कर उनको अफ़ोद के दोनों मोंढों पर सामने के रुख़ लगाया। ");
INSERT INTO urd_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","और उन्होंने सोने के दो कड़े और बना कर उनको सीना बन्द के दोनो सिरों के उस हाशिये में लगाया जिस का रुख़ अन्दर अफ़ोद की तरफ़ था। ");
INSERT INTO urd_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","और उन्होंने सोने के दो कड़े और बना कर उनको अफ़ोद के दोनों मेढ़ों के सामने के हिस्से में अन्दर के रुख़ जहाँ अफ़ोद जुड़ा था लगाया ताकि वह अफ़ोद के कारीगरी से बुने हुए पटके के ऊपर रहे। ");
INSERT INTO urd_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","और उन्होंने सीना बन्द को लेकर उसके कड़े को अफ़ोद के कड़ों के साथ एक नीले फ़ीते से इस तरह बाँधा कि वह अफ़ोद के कारीगरी से बने हुए पटके के ऊपर रहे और सीना बन्द ढीला होकर अफ़ोद से अलग न होने पाए जैसा ख़ुदावन्द ने मूसा को हुक्म दिया था। ");
INSERT INTO urd_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","और उसने अफ़ोद का जुब्बा बुन कर बिल्कुल आसमानी रंग का बनाया। ");
INSERT INTO urd_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","और उसका गिरेबान ज़िरह के गिरेबान की तरह बीच में था और उसके चारों तरफ़ गोट लगी हुई थी ताकि वह फट न जाए। ");
INSERT INTO urd_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","और उन्होंने उसके दामन के घेरे में आसमानी और अर्ग़वानी और सुर्ख़ रंग के बटे हुए तार से अनार बनाये। ");
INSERT INTO urd_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","और ख़ालिस सोंने की घंटियाँ बना कर उनको जुब्बे के दामन के घेरे में चारों तरफ़ अनारों के बीच लगाया। ");
INSERT INTO urd_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","तब जुब्बे के दामन के सारे घेरे में ख़िदमत करने के लिए एक — एक घन्टी थी और फिर एक — एक अनार जैसा ख़ुदावन्द ने मूसा को हुक्म दिया था। ");
INSERT INTO urd_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","और उन्होंने बारीक कतान के बुने हुए कुरते हारून और उसके बेटों के लिए बनाये। ");
INSERT INTO urd_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","और बारीक कतान का 'अमामा, और बारीक कतान की ख़ूबसूरत पगड़ियाँ, और बारीक बटे हुए कतान के पजामे, ");
INSERT INTO urd_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","और बारीक बटे हुए कतान, और आसमानी अर्ग़वानी और सुर्ख़ रंग के कपड़ों का बेल बूटेदार कमरबन्द भी बनाया; जैसा ख़ुदावन्द ने मूसा को हुक्म किया था। ");
INSERT INTO urd_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","और उन्होंने पाक ताज का पत्तर ख़ालिस सोने का बनाकर उस पर अँगूठी के नक़्श की तरह यह खुदवाया: ख़ुदावन्द के लिए पाक। ");
INSERT INTO urd_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","और उसे 'अमामे के साथ ऊपर बाँधने के लिए उसमे एक नीला फ़ीता लगाया, जैसा ख़ुदावन्द ने मूसा को हुक्म किया था। ");
INSERT INTO urd_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","इस तरह ख़ेमा — ए — इजितमा'अ के घर का सब काम ख़त्म हुआ और बनी इस्राईल ने सब कुछ जैसा ख़ुदावन्द ने मूसा को हुक्म दिया था वैसा ही किया। ");
INSERT INTO urd_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","और वह घर को मूसा के पास लाए, या'नी ख़ेमा, और उसका सारा सामान, उसकी घुन्डियाँ, और तख़्ते, बेन्डे और सुतून और ख़ाने; ");
INSERT INTO urd_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","और घटा टोप, मेंढों की सुर्ख़ रंगी हुई खालों का ग़िलाफ़ और तुख़स की खालों का ग़िलाफ़ और बीच का पर्दा; ");
INSERT INTO urd_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","शहादत का सन्दूक़ और उसकी चोबें और सरपोश, ");
INSERT INTO urd_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","और मेज़ और उसके सब बर्तन और नज़्र की रोटी; ");
INSERT INTO urd_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","और पाक शमा'दान और उसकी सजावट के चराग़ और उसके सब बर्तनऔर जलाने का तेल; ");
INSERT INTO urd_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","और ज़र्रीन क़ुर्बानगाह, और मसह करने का तेल और ख़ुशबूदार ख़ुशबू और ख़ेमे के दरवाज़े का पर्दा; ");
INSERT INTO urd_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","और पीतल मढ़ा हुआ मज़बह, और पीतल की झंजरी, और उसकी चोबें और उसके सब बर्तन और हौज़ और उसकी कुर्सी; ");
INSERT INTO urd_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","सहन के पर्दे और उनके सुतून और ख़ाने और सहन के दरवाज़े का पर्दा और उसकी रस्सियाँ और मेख़े और ख़ेमा — ए — इजितमा'अ के काम के लिए घर की इबादत के सब सामान; ");
INSERT INTO urd_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","और पाक मुक़ाम कि ख़िदमत के लिए कढ़े हुए लिबास और हारून काहिन के पाक लिबास और उसके बेटों के लिबास जिनको पहन कर उनको काहिन की ख़िदमत को अन्जाम देना था। ");
INSERT INTO urd_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","जो कुछ ख़ुदावन्द ने मूसा को हुक्म किया था उसी के मुताबिक़ बनी इस्राईल ने सब काम बनाया। ");
INSERT INTO urd_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","और मूसा ने सब काम का मुलाहज़ा किया और देखा कि उन्होंने उसे कर लिया है जैसा ख़ुदावन्द ने हुक्म दिया था उन्होंने सब कुछ वैसा ही किया, और मूसा ने उनको बरकत दी। ");
INSERT INTO urd_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","और ख़ुदावन्द ने मूसा से कहा; ");
INSERT INTO urd_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“पहले महीने की पहली तारीख़ को तू ख़ेमा — ए — इजितमा'अ के घर को खड़ा कर देना। ");
INSERT INTO urd_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","और उस में शहादत का संदूक रख कर संदूक पर बीच का पर्दा खींच देना। ");
INSERT INTO urd_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","और मेज़ को अन्दर ले जाकर उस पर की सब चीज़ें तरतीब से सजा देना और शमा'दान को अन्दर करके उसके चराग़ रोशन कर देना। ");
INSERT INTO urd_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","और ख़ुशबू जलाने की ज़र्रीन क़ुर्बानगाह को शहादत के संदूक़ के सामने रखना और घर के दरवाज़े का पर्दा लगा देना। ");
INSERT INTO urd_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","और सोख़्तनी क़ुर्बानी का मज़बह ख़ेमा — ए — इजितमा'अ के घर के दरवाज़े के सामने रखना। ");
INSERT INTO urd_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","और हौज़ को ख़ेमा — ए — इजितमा'अ और मज़बह के बीच में रख कर उसमे पानी भर देना ");
INSERT INTO urd_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","और सहन के चारो तरफ़ से घेर कर सहन के दरवाज़े में पर्दा लटका देना। ");
INSERT INTO urd_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","और मसह करने का तेल लेकर घर को और उसके अन्दर के सब चीजों को मसह करना; और यूँ उसे और उसके सब बर्तन को पाक करना तब वह पाक ठहरेगा। ");
INSERT INTO urd_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","और तू सोख़्तनी क़ुर्बानी के मज़बह और उसके सब बर्तन को मसह करके मज़बह को पाक करना, और मज़बह निहायत ही पाक ठहरेगा ");
INSERT INTO urd_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","और तू हौज़ और उसकी कुर्सी को भी मसह करके पाक करना। ");
INSERT INTO urd_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","और हारून और उसके बेटे को ख़ेमा — ए — इजितमा'अ के दरवाज़े पर लाकर उसको पानी से ग़ुस्ल दिलाना ");
INSERT INTO urd_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","और हारून को पाक लिबास पहनाना और उसे मसह और पाक करना, ताकि वह मेरे लिए काहिन की ख़िदमत को अन्जाम दे ");
INSERT INTO urd_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","और उनके बेटों को लाकर उनको कुरते पहनाना, ");
INSERT INTO urd_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","और जैसा उनके बाप को मसह करे वैसा ही उनको भी मसह करना, ताकि वह मेरे लिए काहिन की ख़िदमत को अन्जाम दे; और उनका मसह होना उनके लिए नसल — दर — नसल हमेशा की कहानत का निशान होगा।” ");
INSERT INTO urd_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","और मूसा ने सब कुछ जैसा ख़ुदावन्द ने उसको हुक्म किया था उसके मुताबिक़ किया। ");
INSERT INTO urd_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","और दूसरे साल के पहले महीने की पहली तारीख़ को घर खड़ा किया गया। ");
INSERT INTO urd_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","और मूसा ने घर को खड़ा किया और ख़ानों को रख कर उनमे तख़्ते लगा उनके बेन्डे खींच दिए और उसके सुतूनों खड़ा कर दिया। ");
INSERT INTO urd_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","और घर के ऊपर ख़ेमे को तान दिया और ख़ेमा पर उसका ग़िलाफ़ चढ़ा दिया, जैसे ख़ुदावन्द ने मूसा को हुक्म किया था। ");
INSERT INTO urd_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","और शहादतनामे को लेकर सन्दूक़ में रख्खा, और चोबों को सन्दूक़ में लगा सरपोश को सन्दूक़ के ऊपर रख्खा; ");
INSERT INTO urd_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","फिर उस सन्दूक़ को घर के अन्दर लाया, और बीच का पर्दा लगा कर शहादत के सन्दूक़ को पर्दे के अन्दर किया, जैसा ख़ुदावन्द ने मूसा को हुक्म किया था। ");
INSERT INTO urd_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","और मेज़ को उस पर्दे के बाहर घर को उत्तरी रुख़ में ख़ेमा — ए — इजितमा'अ के अन्दर रख्खा, ");
INSERT INTO urd_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","और उस पर ख़ुदावन्द के आमने सामने रोटी सजाकर रख्खी, जैसा ख़ुदावन्द ने मूसा को हुक्म किया था। ");
INSERT INTO urd_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","और ख़ेमा — ए — इजितमा'अ के अन्दर ही मेज़ के सामने घर की दाख्खिनी रुख़ में शमा'दान को रख्खा, ");
INSERT INTO urd_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","और चराग़ ख़ुदावन्द के सामने रोशन कर दिए, जैसा ख़ुदावन्द ने मूसा को हुक्म किया था। ");
INSERT INTO urd_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","और ज़रीन क़ुर्बानगाह को ख़ेमा — ए — इजितमा'अ के अन्दर पर्दे के सामने रख्खा, ");
INSERT INTO urd_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","और उस पर ख़ुशबूदार मसाल्हे का ख़ुशबू जलाया, जैसा ख़ुदावन्द ने मूसा को हुक्म किया था ");
INSERT INTO urd_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","और उसने घर के दरवाज़े में पर्दा लगाया था। ");
INSERT INTO urd_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","और ख़ेमा — ए — इजितमा'अ के घर के दरवाज़े पर सोख़्तनी क़ुर्बानी का मज़बह रखकर उस पर सोख़्तनी क़ुर्बानी और नज़्र की क़ुर्बानी पेश कीं, जैसा ख़ुदावन्द ने मूसा को हुक्म किया, ");
INSERT INTO urd_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","और उसने हौज़ को ख़ेमा — ए — इजितमा'अ और मज़बह के बीच में रखकर उसमें धोने के लिए पानी भर दिया। ");
INSERT INTO urd_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","और मूसा और हारून और उसके बेटों ने अपने — अपने हाँथ — पाँव उसमे धोए। ");
INSERT INTO urd_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","जब — जब वह ख़ेमा — ए — इजितमा'अ के अन्दर दाख़िल होते, और जब — जब वह मज़बह के नज़दीक जाते तो अपने आपको धोकर जाते थे, जैसा ख़ुदावन्द ने मूसा को हुक्म किया था। ");
INSERT INTO urd_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","और उसने घर और मज़बह के चारों तरफ़ सहन को घेर कर सहन के दरवाज़े का पर्दा डाल दिया यूँ मूसा ने उस काम को ख़त्म किया। ");
INSERT INTO urd_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","तब ख़ेमा — ए — इजितमा'अ पर बादल छा गया, और घर ख़ुदावन्द के जलाल से भरा हो गया। ");
INSERT INTO urd_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","और मूसा ख़ेमा — ए — इजितमा'अ में दाख़िल न हो सका क्यूँकि वह बादल उस पर ठहरा हुआ था, और घर ख़ुदावन्द के जलाल से भरा था। ");
INSERT INTO urd_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","और बनी — इस्राईल के सारे सफ़र में यह होता रहा कि जब वह बादल घर के ऊपर से उठ जाता तो वह आगे बढ़ाते, ");
INSERT INTO urd_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","लेकिन अगर वह बादल न उठता तो उस दिन तक सफ़र नहीं करते थे जब तक वह उठ न जाता। ");
INSERT INTO urd_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","क्यूँकि ख़ुदावन्द का बादल इस्राईल के सारे घराने के समाने और उनके सारे सफ़र में दिन के वक़्त तो घर के ऊपर ठहरा रहता और रात को उसमें आग रहती थी।");
INSERT INTO urd_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","और ख़ुदावन्द ने ख़ेमा — ए — इजितमा'अ में से मूसा को बुलाकर उससे कहा, ");
INSERT INTO urd_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","बनी — इस्राईल से कह, कि जब तुम में से कोई ख़ुदावन्द के लिए चढ़ावा चढ़ाए, तो तुम चौपायों या'नी गाय — बैल और भेड़ — बकरी का हदिया देना। ");
INSERT INTO urd_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","अगर उसका चढ़ावा गाय — बैल की सोख़्तनी क़ुर्बानी हो, तो वह बे'ऐब नर को लाकर उसे ख़ेमा — ए — इजितमा'अ के दरवाज़े पर चढ़ाए ताकि वह ख़ुद ख़ुदावन्द के सामने मक़बूल ठहरे। ");
INSERT INTO urd_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","और वह सोख़्तनी क़ुर्बानी के जानवर के सिर पर अपना हाथ रख्खे, तब वह उसकी तरफ़ से मक़बूल होगा ताकि उसके लिए कफ़्फ़ारा हो। ");
INSERT INTO urd_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","और वह उस बछड़े को ख़ुदावन्द के सामने ज़बह करे, और हारून के बेटे जो काहिन हैं ख़ून को लाकर उसे उस मज़बह पर चारों तरफ़ छिड़कें जो ख़ेमा — ए — इजितमा'अ के दरवाज़े पर है। ");
INSERT INTO urd_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","तब वह उस सोख़्तनी क़ुर्बानी के जानवर की खाल खींचे और उसके 'उज़्व — 'उज़्व को काट कर जुदा — जुदा करे। ");
INSERT INTO urd_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","फिर हारून काहिन के बेटे मज़बह पर आग रख्खें, और आग पर लकड़ियाँ तरतीब से चुन दें। ");
INSERT INTO urd_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","और हारून के बेटे जो काहिन हैं, उसके 'आज़ा को और सिर और चर्बी को उन लकड़ियों पर जो मज़बह की आग पर होंगी तरतीब से रख दें। ");
INSERT INTO urd_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","लेकिन वह उसकी अंतड़ियों और पायों को पानी से धो ले, तब काहिन सबको मज़बह पर जलाए कि वह सोख़्तनी क़ुर्बानी या'नी ख़ुदावन्द के लिए राहतअंगेज़ ख़ुशबू की आतिशी क़ुर्बानी हों। ");
INSERT INTO urd_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","और अगर उसका चढ़ावा रेवड़ में से भेड़ या बकरी की सोख़्तनी क़ुर्बानी हो, तो वह बे — 'ऐब नर को लाए। ");
INSERT INTO urd_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","और वह उसे मज़बह की उत्तरी सिम्त में ख़ुदावन्द के आगे ज़बह करे, और हारून के बेटे जो काहिन हैं उसके ख़ून को मज़बह पर चारों तरफ़ छिड़कें। ");
INSERT INTO urd_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","फिर वह उसके 'उज़्व — 'उज़्व को और सिर और चर्बी को काट कर जुदा — जुदा करे, और काहिन उनकी तरतीब से उन लकड़ियों पर जो मज़बह की आग पर होंगी चुन दे; ");
INSERT INTO urd_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","लेकिन वह अंतड़ियों और पायों को पानी से धो ले। तब काहिन सबको लेकर मज़बह पर जला दे, वह सोख़्तनी क़ुर्बानी या'नी ख़ुदावन्द के लिए राहतअंगेज़ ख़ूशबू की आतिशी क़ुर्बानी है। ");
INSERT INTO urd_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“और अगर उसका चढ़ावा ख़ुदावन्द के लिए परिन्दों की सोख़्तनी क़ुर्बानी हो, तो वह कुमरियों या कबूतर के बच्चों का चढ़ावा चढ़ाए। ");
INSERT INTO urd_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","और काहिन उसको मज़बह पर लाकर उसका सिर मरोड़ डाले, और उसे मज़बह पर जला दे; और उसका ख़ून मज़बह के पहलू पर गिर जाने दे। ");
INSERT INTO urd_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","और उसके पोटे को आलाइश के साथ ले जाकर मज़बह की पूरबी सिम्त में राख की जगह में डाल दे। ");
INSERT INTO urd_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","और वह उसके दोनों बाज़ुओं को पकड़ कर उसे चीरे पर अलग — अलग न करे। तब काहिन उसे मज़बह पर उन लकड़ियों के ऊपर रख कर जो आग पर होंगी जला दे, वह सोख़्तनी क़ुर्बानी या'नी ख़ुदावन्द के लिए राहतअंगेज़ ख़ुशबू की आतिशी क़ुर्बानी है। ");
INSERT INTO urd_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","और अगर कोई ख़ुदावन्द के लिए नज़्र की क़ुर्बानी का हदिया लाए, तो अपने हदिये के लिए मैदा ले और उसमें तेल डाल कर उसके ऊपर लुबान रख्खे; ");
INSERT INTO urd_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","और वह उसे हारून के बेटों के पास जो काहिन हैं लाए, और तेल मिले हुए मैदे में से इस तरह अपनी मुट्ठी भर कर निकाले कि सब लुबान उसमें आ जाए। तब काहिन उसे नज़्र की क़ुर्बानी की यादगारी के तौर पर मज़बह के ऊपर जलाए। यह ख़ुदावन्द के लिए राहतअंगेज़ ख़ुशबू की आतिशी क़ुर्बानी होगी। ");
INSERT INTO urd_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","और जो कुछ उस नज़्र की क़ुर्बानी में से बाक़ी रह जाए, वह हारून और उसके बेटों का होगा। यह ख़ुदावन्द की आतिशी क़ुर्बानियों में पाकतरीन चीज़ है। ");
INSERT INTO urd_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“और जब तू तनूर का पका हुआ नज़्र की क़ुर्बानी का हदिया लाए, तो वह तेल मिले हुए मैदे के बेख़मीरी गिरदे या तेल चुपड़ी हुई बेख़मीरी चपातियाँ हों। ");
INSERT INTO urd_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","और अगर तेरी नज़्र की क़ुर्बानी का चढ़ावा तवे का पका हुआ हो, तो वह तेल मिले हुए बेख़मीरी मैदे का हो। ");
INSERT INTO urd_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","उसको टुकड़े — टुकड़े करके उस पर तेल डालना, तो वह नज़्र की क़ुर्बानी होगी। ");
INSERT INTO urd_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","और अगर तेरी नज़्र की क़ुर्बानी का चढ़ावा कढ़ाई का तला हुआ हो, तो वह मैदे से तेल में बनाया जाए। ");
INSERT INTO urd_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","तू इन चीज़ों की नज़्र की क़ुर्बानी का चढ़ावा ख़ुदावन्द के पास लाना, वह काहिन को दिया जाए। और वह उसे मज़बह के पास लाए। ");
INSERT INTO urd_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","और काहिन उस नज़्र की क़ुर्बानी में से उसकी यादगारी का हिस्सा उठा कर मज़बह पर जलाए, यह ख़ुदावन्द के लिए राहतअंगेज़ ख़ुशबू की आतिशी क़ुर्बानी होगी। ");
INSERT INTO urd_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","और जो कुछ उस नज़्र की क़ुर्बानी में से बच रहे वह हारून और उसके बेटों का होगा। यह ख़ुदावन्द की आतिशी क़ुर्बानियों में पाकतरीन चीज़ है। ");
INSERT INTO urd_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","कोई नज़्र की क़ुर्बानी जो तुम ख़ुदावन्द के सामने चढ़ाओ, वह ख़मीर मिला कर न बनाई जाए; तुम कभी आतिशी क़ुर्बानी के तौर पर ख़ुदावन्द के सामने ख़मीर या शहद न जलाना। ");
INSERT INTO urd_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","तुम इनको पहले फलों के हदिये के तौर पर ख़ुदावन्द के सामने लाना, लेकिन राहतअंगेज़ ख़ुशबू के लिए वह मज़बह पर न पेश किये जाएँ। ");
INSERT INTO urd_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","और तू अपनी नज़्र की क़ुर्बानी के हर हदिये को नमकीन बनाना, और अपनी किसी नज़्र की क़ुर्बानी को अपने ख़ुदा के 'अहद के नमक बग़ैर न रहने देना; अपने सब हदियों के साथ नमक भी पेश करना। ");
INSERT INTO urd_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","'और अगर तू पहले फलों की नज़्र का हदिया ख़ुदावन्द के सामने पेश करे तो अपने पहले फलों की नज़्र के चढ़ावे के लिए अनाज की भुनी हुई बालें, या'नी हरी — हरी बालों में से हाथ से मलकर निकाले हुए अनाज को चढ़ाना। ");
INSERT INTO urd_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","और उसमें तेल डालना और उसके ऊपर लुबान रखना, तो वह नज़्र की क़ुर्बानी होगी। ");
INSERT INTO urd_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","और काहिन उसकी यादगारी के हिस्से को, या'नी थोड़े से मल कर निकाले हुए दानों को और थोड़े से तेल को और सारे लुबान को जला दे; यह ख़ुदावन्द के लिए आतिशी क़ुर्बानी होगी। ");
INSERT INTO urd_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","और अगर उसका हदिया सलामती का ज़बीहा हो और वह गाय बैल में से किसी को अदा करे, तो चाहे वह नर हो या मादा; लेकिन जो बे — 'ऐब हो उसी को वह ख़ुदावन्द के सामने पेश करे। ");
INSERT INTO urd_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","और वह अपना हाथ अपने हदिये के जानवर के सिर पर रख्खे, और ख़ेमा — ए — इजितमा'अ के दरवाज़े पर उसे ज़बह करे; और हारून के बेटे जो काहिन हैं उसके ख़ून को मज़बह पर चारों तरफ़ छिड़कें। ");
INSERT INTO urd_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","और वह सलामती के ज़बीहे में से ख़ुदावन्द के लिए आतिशी क़ुर्बानी पेश करे, या'नी जिस चर्बी से अंतड़ियाँ ढकी रहती हैं, ");
INSERT INTO urd_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","और वह सारी चर्बी जो अंतड़ियों पर लिपटी रहती है, और दोनों गुर्दे और उनके ऊपर की चर्बी जो कमर के पास रहती है, और जिगर पर की झिल्ली गुर्दों के साथ; इन सभों को वह जुदा करे। ");
INSERT INTO urd_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","और हारून के बेटे उन्हें मज़बह पर सोख़्तनी क़ुर्बानी के ऊपर जलाएँ जो उन लकड़ियों पर होगी जो आग के ऊपर हैं; यह ख़ुदावन्द के लिए राहतअंगेज़ ख़ुशबू की अतिशी क़ुर्बानी है। ");
INSERT INTO urd_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","और अगर उसका सलामती के ज़बीहे का हदिया ख़ुदावन्द के लिए भेड़ — बकरी में से हो, तो चाहे नर हो या मादा, लेकिन जो बे — 'ऐब हो उसी को वह अदा करे। ");
INSERT INTO urd_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","अगर वह बर्रा पेश करता हो, तो उसे ख़ुदावन्द के सामने अदा करे, ");
INSERT INTO urd_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","और अपना हाथ अपने चढ़ावे के जानवर के सिर पर रख्खे, और उसे ख़ेमा — ए — इजितमा'अ के सामने ज़बह करे; और हारून के बेटे उसके ख़ून को मज़बह पर चारों तरफ़ छिड़कें। ");
INSERT INTO urd_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","और वह सलामती के ज़बीहे में से ख़ुदावन्द के लिए अतिशी क़ुर्बानी पेश करे; या'नी उसकी पूरी चर्बी भरी दुम को वह रीढ़ के पास से अलग करे, और जिस चर्बी से अंतड़ियाँ ढकी रहती हैं, और वह सारी चर्बी जो अंतड़ियों पर लिपटी रहती है, ");
INSERT INTO urd_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","और दोनों गुर्दे और उनके ऊपर की चर्बी जो कमर के पास रहती है, और जिगर पर की झिल्ली गुर्दों के साथ; इन सभों को वह अलग करे। ");
INSERT INTO urd_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","और काहिन इन्हें मज़बह पर जलाए; यह उस अतिशी क़ुर्बानी की ग़िज़ा है जो ख़ुदावन्द को पेश की जाती है। ");
INSERT INTO urd_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“और अगर वह बकरा या बकरी पेश करता हो, तो उसे ख़ुदावन्द के सामने अदा करे। ");
INSERT INTO urd_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","और वह अपना हाथ उसके सिर पर रख्खे, और उसे ख़ेमा — ए — इजितमा'अ के सामने ज़बह करे; और हारून के बेटे उसके ख़ून को मज़बह पर चारों तरफ़ छिड़कें। ");
INSERT INTO urd_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","और वह उसमें से अपना चढ़ावा अतिशी क़ुर्बानी के तौर पर ख़ुदावन्द के सामने पेश करे; या'नी जिस चर्बी से अंतड़ियाँ ढकी रहती हैं, और वह सब चर्बी जो अंतड़ियों पर लिपटी रहती है, ");
INSERT INTO urd_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","और दोनों गुर्दे और उनके ऊपर की चर्बी जो कमर के पास रहती है, और जिगर पर की झिल्ली गुर्दों के साथ, इन सभों को वह अलग करे। ");
INSERT INTO urd_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","और काहिन इनको मज़बह पर जलाए; यह उस अतिशीन क़ुर्बानी की ग़िज़ा है, जो राहतअंगेज़ ख़ुशबू के लिए होती है; सारी चर्बी ख़ुदावन्द की है। ");
INSERT INTO urd_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","यह तुम्हारी सब सुकूनतगाहों में नसल — दर — नसल एक हमेशा का क़ानून रहेगा, कि तुम चर्बी या ख़ून मुतलक़ न खाओ।” ");
INSERT INTO urd_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","और ख़ुदावन्द ने मूसा से कहा कि, ");
INSERT INTO urd_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","बनी इस्राईल से कह कि अगर कोई उन कामों में से जिनको ख़ुदावन्द ने मना' किया है, किसी काम को करे और उससे अनजाने में ख़ता हो जाए। ");
INSERT INTO urd_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","अगर काहिन — ए — मम्सूह ऐसी ख़ता करे जिससे क़ौम मुजरिम ठहरती हो, तो वह अपनी उस ख़ता के लिए जो उसने की है, एक बे — 'ऐब बछड़ा ख़ता की क़ुर्बानी के तौर पर ख़ुदावन्द के सामने पेश करे। ");
INSERT INTO urd_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","वह उस बछड़े को ख़ेमा — ए — इजितमा'अ के दरवाज़े पर ख़ुदावन्द के आगे लाए, और बछड़े के सिर पर अपना हाथ रख्खे और उसको ख़ुदावन्द के आगे ज़बह करे। ");
INSERT INTO urd_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","और वह काहिन — ए — मम्सूह उस बछड़े के ख़ून में से कुछ लेकर उसे ख़ेमा — ए — इजितमा'अ में ले जाए। ");
INSERT INTO urd_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","और काहिन अपनी उँगली ख़ून में डुबो — डुबो कर, और ख़ून में से ले लेकर उसे हैकल के पर्दे के सामने सात बार ख़ुदावन्द के आगे छिड़के। ");
INSERT INTO urd_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","और काहिन उसी ख़ून में से ख़ुशबूदार ख़ुशबू जलाने की क़ुर्बानगाह के सींगों पर, जो ख़ेमा — ए — इज्तिमा'अ में है, ख़ुदावन्द के आगे लगाए; और उस बछड़े के बाक़ी सब ख़ून को सोख़्तनी क़ुर्बानी के मज़बह के पाये पर, जो ख़ेमा — ए — इजितमा'अ के दरवाज़े पर है उँडेल दे। ");
INSERT INTO urd_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","फिर वह ख़ता की क़ुर्बानी के बछड़े की सब चर्बी को उससे अलग करे; या'नी जिस चर्बी से अंतड़ियाँ ढकी रहती हैं, और वह सब चर्बी जो अंतड़ियों पर लिपटी रहती है, ");
INSERT INTO urd_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","और दोनों गुर्दे और उनके ऊपर की चर्बी जो कमर के पास रहती है, और जिगर पर की झिल्ली गुर्दों के साथ; इन सभों को वह वैसे ही अलग करे। ");
INSERT INTO urd_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","जैसे सलामती के ज़बीहे के बछड़े से वह अलग किए जाते हैं; और काहिन उनको सोख़्तनी क़ुर्बानी के मज़बह पर जलाए। ");
INSERT INTO urd_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","और उस बछड़े की खाल, और उसका सब गोश्त, और सिर और पाये, और अंतड़ियाँ और गोबर; ");
INSERT INTO urd_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","या'नी पूरे बछड़े को लश्कर गाह के बाहर किसी साफ़ जगह में जहाँ राख पड़ती है, ले जाए; और सब कुछ लकड़ियों पर रख कर आग से जलाए, वह वहीं जलाया जाए जहाँ राख डाली जाती है। ");
INSERT INTO urd_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","'अगर बनी — इस्राईल की सारी जमा'अत से अनजाने चूक हो जाए, और यह बात जमा'अत की आँखों से छिपी तो हो तो भी वह उन कामों में से जिन्हें ख़ुदावन्द ने मना' किया है, किसी काम को करके मुजरिम हो गई हो, ");
INSERT INTO urd_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","तो उस ख़ता के जिसके वह क़ुसूरवार हों, मा'लूम हो जाने पर जमा'अत एक बछड़ा ख़ता की क़ुर्बानी के तौर पर चढ़ाने के लिए ख़ेमा — ए — इजितमा'अ के सामने लाए। ");
INSERT INTO urd_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","और जमा'अत के बुज़ुर्ग अपने — अपने हाथ ख़ुदावन्द के आगे उस बछड़े के सिर पर रख्खें, और बछड़ा ख़ुदावन्द के आगे ज़बह किया जाए। ");
INSERT INTO urd_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","और काहिन — ए — मम्सूह उस बछड़े के ख़ून में से कुछ ख़ेमा — ए — इजितमा'अ में ले जाए; ");
INSERT INTO urd_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","और काहिन अपनी उँगली उस ख़ून में डुबो — डुबो कर उसे पर्दे के सामने सात बार ख़ुदावन्द के आगे छिड़के, ");
INSERT INTO urd_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","और उसी ख़ून में से मज़बह के सींगों पर जो ख़ुदावन्द के आगे ख़ेमा — ए — इजितमा'अ में है लगाए, और बाक़ी सारा ख़ून सोख़्तनी क़ुर्बानी के मज़बह के पाये पर, जो ख़ेमा — ए — इजितमा'अ के दरवाज़े पर है, उँडेल दे। ");
INSERT INTO urd_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","और उसकी सब चर्बी उससे अलग करके उसे मज़बह पर जलाए। ");
INSERT INTO urd_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","वह बछड़े से यही करे, या'नी जो कुछ ख़ता की क़ुर्बानी के बछड़े से किया था, वही इस बछड़े से करे। यूँ काहिन उनके लिए कफ़्फ़ारा दे, तो उन्हें मु'आफ़ी मिलेगी; ");
INSERT INTO urd_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","और वह उस बछड़े को लश्करगाह के बाहर ले जा कर जलाए, जैसे पहले बछड़े को जलाया था; यह जमा'अत की ख़ता की क़ुर्बानी है। ");
INSERT INTO urd_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","और जब किसी सरदार से ख़ता हो जाए, और वह उन कामों में से जिन्हें ख़ुदावन्द ने मना' किया है किसी काम को अनजाने में कर बैठे और मुजरिम हो जाए। ");
INSERT INTO urd_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","तो जब वह ख़ता जो उससे सरज़द हुई है उसे बता दी जाए, तो वह एक बे — 'ऐब बकरा अपनी क़ुर्बानी के लिए लाए; ");
INSERT INTO urd_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","और अपना हाथ उस बकरे के सिर पर रख्खे, और उसे उस जगह ज़बह करे जहाँ सोख़्तनी क़ुर्बानी के जानवर ख़ुदावन्द के आगे ज़बह करते हैं; यह ख़ता की क़ुर्बानी है। ");
INSERT INTO urd_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","और काहिन ख़ता की क़ुर्बानी का कुछ ख़ून अपनी उँगली पर लेकर उसे सोख़्तनी क़ुर्बानी के मज़बह के सींगों पर लगाए, और उसका बाक़ी सब ख़ून सोख़्तनी क़ुर्बानी के मज़बह के पाए पर उँडेल दे। ");
INSERT INTO urd_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","और सलामती के ज़बीहे की चर्बी की तरह उसकी सब चर्बी मज़बह पर जलाए। यूँ काहिन उसकी ख़ता का कफ़्फ़ारा दे, तो उसे मु'आफ़ी मिलेगी। ");
INSERT INTO urd_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","'और अगर कोई 'आम आदमियों में से अनजाने में ख़ता करे, और उन कामों में से जिन्हें ख़ुदावन्द ने मना' किया है किसी काम को करके मुजरिम हो जाए; ");
INSERT INTO urd_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","तो जब वह ख़ता जो उसने की है उसे बता दी जाए, तो वह अपनी उस ख़ता के लिए जो उससे सरज़द हुई है, एक बे — 'ऐब बकरी लाए। ");
INSERT INTO urd_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","और वह अपना हाथ ख़ता की क़ुर्बानी के जानवर के सिर पर रख्खे, और ख़ता की क़ुर्बानी के उस जानवर को सोख़्तनी क़ुर्बानी की जगह पर ज़बह करे। ");
INSERT INTO urd_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","और काहिन उसका कुछ ख़ून अपनी उँगली पर ले कर उसे सोख़्तनी क़ुर्बानी के मज़बह के सींगों पर लगाए, और उसका बाक़ी सब ख़ून मज़बह के पाए पर उँडेल दे; ");
INSERT INTO urd_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","और वह उसकी सारी चर्बी को अलग करे जैसे सलामती के ज़बीहे की चर्बी अलग की जाती है, और काहिन उसे मज़बह पर राहतअंगेज़ ख़ुशबू के तौर पर ख़ुदावन्द के लिए जलाए। यूँ काहिन उसके लिए कफ़्फ़ारा दे, तो उसे मु'आफ़ी मिलेगी। ");
INSERT INTO urd_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","और अगर ख़ता की क़ुर्बानी के लिए उसका हदिया बर्रा हो, तो वह बे — 'ऐब मादा लाए; ");
INSERT INTO urd_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","और अपना हाथ ख़ता की क़ुर्बानी के जानवर के सिर पर रख्खे; और उसे ख़ता की क़ुर्बानी के तौर पर उस जगह ज़बह करे जहाँ सोख़्तनी क़ुर्बानी ज़बह करते है। ");
INSERT INTO urd_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","और काहिन ख़ता की क़ुर्बानी का कुछ ख़ून अपनी उँगली पर लेकर उसे सोख़्तनी क़ुर्बानी के मज़बह के सींगों पर लगाए, और उसका बाक़ी सब ख़ून मज़बह के पाये पर उँडेल दे। ");
INSERT INTO urd_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","और उसकी सब चर्बी को अलग करे जैसे सलामती के ज़बीहे के बर्रे की चर्बी अलग की जाती है। और काहिन उसको मज़बह पर ख़ुदावन्द की आतिशी क़ुर्बानियों के ऊपर जलाए। यूँ काहिन उसके लिए उसकी ख़ता का जो उससे हुई है कफ़्फ़ारा दे, तो उसे मु'आफ़ी मिलेगी। ");
INSERT INTO urd_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","और अगर कोई इस तरह ख़ता करे कि वह गवाह हो और उसे क़सम दी जाए कि जैसे उसने कुछ देखा या उसे कुछ मा'लूम है, और वह न बताए, तो उसका गुनाह उसी के सिर लगेगा। ");
INSERT INTO urd_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","या अगर कोई शख़्स किसी नापाक चीज़ को छू ले, चाहे वह नापाक जानवर या नापाक चौपाये या नापाक रेंगनेवाले जानदार की लाश हो, तो चाहे उसे मा'लूम भी न हो कि वह नापाक हो गया है तो भी वह मुजरिम ठहरेगा। ");
INSERT INTO urd_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","या अगर वह इंसान की उन नजासतों में से जिनसे वह नजिस हो जाता है, किसी नजासत को छू ले और उसे मा'लूम न हो, तो वह उस वक़्त मुजरिम ठहरेगा जब उसे मा'लूम हो जाएगा। ");
INSERT INTO urd_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","या अगर कोई बगै़र सोचे अपनी ज़बान से बुराई या भलाई करने की क़सम खाले, तो क़सम खा कर वह आदमी चाहे कैसी ही बात बग़ैर सोचे कह दे, बशर्ते कि उसे मा'लूम न हो, तो ऐसी बात में मुजरिम उस वक़्त ठहरेगा जब उसे मा'लूम हो जाएगा। ");
INSERT INTO urd_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","और जब वह इन बातों में से किसी में मुजरिम हो, तो जिस अम्र में उससे ख़ता हुई है वह उसका इक़रार करे, ");
INSERT INTO urd_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","और ख़ुदावन्द के सामने अपने जुर्म की क़ुर्बानी लाए; या'नी जो ख़ता उससे हुई है उसके लिए रेवड़ में से एक मादा, या'नी एक भेड़ या बकरी ख़ता की क़ुर्बानी के तौर पर पेश करे, और काहिन उसकी ख़ता का कफ़्फ़ारा दे ");
INSERT INTO urd_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“और अगर उसे भेड़ देने का मक़दूर न हो, तो वह अपनी ख़ता के लिए जुर्म की क़ुर्बानी के तौर पर दो कुमरियाँ या कबूतर के दो बच्चे ख़ुदावन्द के सामने पेश करे; एक ख़ता की क़ुर्बानी के लिए और दूसरा सोख़्तनी क़ुर्बानी के लिए। ");
INSERT INTO urd_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","वह उन्हें काहिन के पास ले आए जो पहले उसे जो ख़ता की क़ुर्बानी के लिए है पेश करे, और उसका सिर गर्दन के पास से मरोड़ डाले पर उसे अलग न करे, ");
INSERT INTO urd_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","और ख़ता की क़ुर्बानी का कुछ ख़ून मज़बह के पहलू पर छिड़के और बाक़ी ख़ून को मज़बह के पाये पर गिर जाने दे; यह ख़ता की क़ुर्बानी है। ");
INSERT INTO urd_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","और दूसरे परिन्दे को हुक्म के मुवाफ़िक़ सोख़्तनी क़ुर्बानी के तौर पर अदा करे यूँ काहिन उसकी ख़ता का जो उसने की है कफ़्फ़ारा दे, तो उसे मु'आफ़ी मिलेगी। ");
INSERT INTO urd_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","और अगर उसे दो कुमरियाँ या कबूतर के दो बच्चे लाने का भी मक़दूर न हो, तो अपनी ख़ता के लिए अपने हदिये के तौर पर, ऐफ़ा के दसवें हिस्से के बराबर मैदा ख़ता की क़ुर्बानी के लिए लाए। उस पर न तो वह तेल डाले, न लुबान रख्खे, क्यूँकि यह ख़ता की क़ुर्बानी है। ");
INSERT INTO urd_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","वह उसे काहिन के पास लाए, और काहिन उसमें से अपनी मुट्ठी भर कर उसकी यादगारी का हिस्सा मज़बह पर ख़ुदावन्द की आतिशीन क़ुर्बानी के ऊपर जलाए। यह ख़ता की क़ुर्बानी है। ");
INSERT INTO urd_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","यूँ काहिन उसके लिए इन बातों में से, जिस किसी में उससे ख़ता हुई है उस ख़ता का कफ़्फ़ारा दे, तो उसे मु'आफ़ी मिलेगी; और जो कुछ बाक़ी रह जाएगा, वह नज़्र की क़ुर्बानी की तरह काहिन का होगा।” ");
INSERT INTO urd_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","और ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","अगर ख़ुदावन्द की पाक चीज़ों में किसी से तक़सीर हो और वह अनजाने में ख़ता करे, तो वह अपने जुर्म की क़ुर्बानी के तौर पर रेवड़ में से बे — 'ऐब मेंढा ख़ुदावन्द के सामने अदा करे। जुर्म की क़ुर्बानी के लिए उसकी क़ीमत हैकल की मिस्क़ाल के हिसाब से चाँदी की उतनी ही मिस्क़ालें हों, जितनी तू मुक़र्रर कर दे। ");
INSERT INTO urd_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","और जिस पाक चीज़ में उससे तक़सीर हुई है वह उसका मु'आवज़ा दे, और उसमें पाँचवाँ हिस्सा और बढ़ा कर उसे काहिन के हवाले करे। यूँ काहिन जुर्म की क़ुर्बानी का मेंढा पेश कर उसका कफ़्फ़ारा दे, तो उसे मु'आफ़ी मिलेगी। ");
INSERT INTO urd_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","'और अगर कोई ख़ता करे, और उन कामों में से जिन्हें ख़ुदावन्द ने मना' किया है किसी काम को करे, तो चाहे वह यह बात जानता भी न हो तो भी मुजरिम ठहरेगा; और उसका गुनाह उसी के सिर लगेगा। ");
INSERT INTO urd_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","तब वह रेवड़ में से एक बे — 'ऐब मेंढा उतने ही दाम का, जो तू मुक़र्रर कर दे, जुर्म की क़ुर्बानी के तौर पर काहिन के पास लाए। यूँ काहिन उसकी उस बात का, जिसमें उससे अनजाने में चूक हो गई क़फ़्फ़ारा दे, तो उसे मु'आफ़ी मिलेगी। ");
INSERT INTO urd_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","यह जुर्म की क़ुर्बानी है, क्यूँकि वह यक़ीनन ख़ुदावन्द के आगे मुजरिम है।” ");
INSERT INTO urd_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","फिर ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“अगर किसी से यह ख़ता हो कि वह ख़ुदावन्द का क़ुसूर करे, और अमानत या लेन — देन या लूट के मु'आमिले में अपने पड़ोसी को धोखा दे, या अपने पड़ोसी पर ज़ुल्म करे, ");
INSERT INTO urd_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","या किसी खोई हुई चीज़ को पाकर धोखा दे, और झूठी क़सम भी खा ले; तब इनमें से चाहे कोई बात हो जिसमें किसी शख़्स से ख़ता हो गई है, ");
INSERT INTO urd_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","इसलिए अगर उससे ख़ता हुई है और वह मुजरिम ठहरा है, तो जो चीज़ उसने लूटी, या जो चीज़ उसने ज़ुल्म करके छीनी, या जो चीज़ उसके पास अमानत थी, या जो खोई हुई चीज़ उसे मिली, ");
INSERT INTO urd_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","या जिस चीज़ के बारे में उसने झूटी क़सम खाई; उस चीज़ को वह ज़रूर पूरा — पूरा वापस करे, और असल के साथ पाँचवा हिस्सा भी बढ़ा कर दे। जिस दिन यह मा'लूम हो कि वह मुजरिम है, उसी दिन वह उसे उसके मालिक को वापस दे; ");
INSERT INTO urd_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","और अपने जुर्म की क़ुर्बानी ख़ुदावन्द के सामने अदा करे, और जितना दाम तू मुक़र्रर करे उतने दाम का एक बे — 'ऐब मेंढा रेवड़ में से जुर्म की क़ुर्बानी के तौर पर काहिन के पास लाए। ");
INSERT INTO urd_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","यूँ काहिन उसके लिए ख़ुदावन्द के सामने कफ़्फ़ारा दे, तो जिस काम को करके वह मुजरिम ठहरा है उसकी उसे मु'आफ़ी मिलेगी।” ");
INSERT INTO urd_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","फिर ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“हारून और उसके बेटों को यूँ हुक्म दे कि सोख़्तनी क़ुर्बानी के बारे में शरा' यह है, कि सोख़्तनी क़ुर्बानी मज़बह के ऊपर आतिशदान पर तमाम रात सुबह तक रहे, और मज़बह की आग उस पर जलती रहे। ");
INSERT INTO urd_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","और काहिन अपना कतान का लिबास पहने और कतान के पाजामे को अपने तन पर डाले और आग ने जो सोख़्तनी क़ुर्बानी को मज़बह पर भसम करके राख कर दिया है, उस राख को उठा कर उसे मज़बह की एक तरफ़ रख्खे। ");
INSERT INTO urd_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","फिर वह अपने लिबास को उतार कर दूसरे कपड़े पहने, और उस राख को उठा कर लश्करगाह के बाहर किसी साफ़ जगह में ले जाए। ");
INSERT INTO urd_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","और मज़बह पर आग जलती रहे, और कभी बुझने न पाए; और काहिन हर सुबह को उस पर लकड़ियाँ जला कर सोख़्तनी क़ुर्बानी को उसके ऊपर चुन दे, और सलामती के ज़बीहों की चर्बी को उसके ऊपर जलाया करे। ");
INSERT INTO urd_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","मज़बह पर आग हमेशा जलती रख्खी जाए; वह कभी बुझने न पाए। ");
INSERT INTO urd_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“नज़्र की क़ुर्बानी 'और नज़्र की क़ुर्बानी के बारे में शरा' यह है, कि हारून के बेटे उसे मज़बह के आगे ख़ुदावन्द के सामने पेश करें। ");
INSERT INTO urd_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","और वह नज़्र की क़ुर्बानी में से अपनी मुट्ठी भर इस तरह निकाले कि उसमें थोड़ा सा मैदा और कुछ तेल जो उसमें पड़ा होगा और नज़्र की क़ुर्बानी का सब लुबान आ जाए, और इस यादगारी के हिस्से को मज़बह पर ख़ुदावन्द के सामने राहतअंगेज ख़ुशबू के तौर पर जलाए। ");
INSERT INTO urd_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","और जो बाक़ी बचे उसे हारून और उसके बेटे खाएँ, वह बग़ैर ख़मीर के पाक जगह में खाया जाए, या'नी वह ख़ेमा — ए — इजितमा'अ के सहन में उसे खाएँ। ");
INSERT INTO urd_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","वह ख़मीर के साथ पकाया न जाए; मैंने यह अपनी आतिशीन क़ुर्बानियों में से उनका हिस्सा दिया है, और यह ख़ता की क़ुर्बानी और जुर्म की क़ुर्बानी की तरह बहुत पाक है। ");
INSERT INTO urd_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","हारून की औलाद के सब मर्द उसमें से खाएँ। तुम्हारी नसल — दर — नसल की आतिशी क़ुर्बानियां जो ख़ुदावन्द को पेश करेंगे उनमें से यह उनका हक़ होगा। जो कोई उन्हें छुए वह पाक ठहरेगा।” ");
INSERT INTO urd_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","और ख़ुदावन्द ने मूसा से कहा कि, ");
INSERT INTO urd_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“जिस दिन हारून को मसह किया जाए उस दिन वह और उसके बेटे ख़ुदावन्द के सामने यह हदिया अदा करें, कि ऐफ़ा के दसवें हिस्से के बराबर मैदा, आधा सुबह को और आधा शाम को, हमेशा नज़्र की क़ुर्बानी के लिए लाएँ। ");
INSERT INTO urd_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","वह तवे पर तेल में पकाया जाए; जब वह तर हो जाए तो तू उसे ले आना। इस नज़्र की क़ुर्बानी को पकवान के टुकड़ों की सूरत में पेश करना ताकि वह ख़ुदावन्द के लिए राहतअंगेज़ ख़ुशबू भी हो। ");
INSERT INTO urd_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","और जो उसके बेटों में से उसकी जगह काहिन मम्सूह हो वह उसे पेश करे। यह हमेशा का क़ानून होगा कि वह ख़ुदावन्द के सामने बिल्कुल जलाया जाए। ");
INSERT INTO urd_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","काहिन की हर एक नज़्र की क़ुर्बानी बिल्कुल जलाई जाए; वह कभी खाई न जाए।” ");
INSERT INTO urd_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“हारून और उसके बेटों से कह कि ख़ता की क़ुर्बानी के बारे में शरा' यह है, कि जिस जगह सोख़्तनी क़ुर्बानी का जानवर ज़बह किया जाता है, वहीं ख़ता की क़ुर्बानी का जानवर भी ख़ुदावन्द के आगे ज़बह किया जाए; वह बहुत पाक है। ");
INSERT INTO urd_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","जो काहिन उसे ख़ता के लिए पेश करे वह उसे खाए: वह पाक जगह में, या'नी ख़ेमा — ए — इजितमा'अ के सहन में खाया जाए। ");
INSERT INTO urd_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","जो कुछ उसके गोश्त से छू जाए वह पाक ठहरेगा, और अगर किसी कपड़े पर उसके ख़ून की छिट पड़ जाए, तो जिस कपड़े पर उसकी छींट पड़ी है तू उसे किसी पाक जगह में धोना। ");
INSERT INTO urd_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","और मिट्टी का वह बर्तन जिसमें वह पकाया जाए तोड़ दिया जाए, लेकिन अगर वह पीतल के बर्तन में पकाया जाए तो उस बर्तन की माँज कर पानी से धो लिया जाए। ");
INSERT INTO urd_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","और काहिनों में से हर मर्द उसे खाए; वह बहुत पाक है। ");
INSERT INTO urd_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","लेकिन जिस ख़ता की क़ुर्बानी का कुछ ख़ून ख़ेमा — ए — इजितमा'अ के अन्दर पाक मक़ाम में कफ़्फ़ारे के लिए पहुँचाया गया है, उसका गोश्त कभी न खाया जाए; बल्कि वह आग से जला दिया जाए। ");
INSERT INTO urd_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“और जुर्म की क़ुर्बानी के बारे में शरा' यह है। वह बहुत पाक है। ");
INSERT INTO urd_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","जिस जगह सोख़्तनी क़ुर्बानी के जानवर को ज़बह करते हैं, वहीं वह जुर्म की क़ुर्बानी के जानवर को भी ज़बह करें; और वह उसके ख़ून को मज़बह के चारों तरफ़ छिड़के। ");
INSERT INTO urd_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","और वह उसकी सब चर्बी को चढ़ाए, या'नी उसकी मोटी दुम को, और उस चर्बी को जिससे अंतड़ियाँ ढकी रहती हैं ");
INSERT INTO urd_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","और दोनों गुर्दे और उनके ऊपर की चर्बी जो कमर के पास रहती है, और जिगर पर की झिल्ली गुर्दों के साथः इन सबको वह अलग करे। ");
INSERT INTO urd_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","और काहिन उनको मज़बह पर ख़ुदावन्द के सामने आतिशीन क़ुर्बानी के तौर पर जलाए, यह जुर्म की क़ुर्बानी है। ");
INSERT INTO urd_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","और काहिनों में से हर मर्द उसे खाए और किसी पाक जगह में उसे खाएँ; वह बहुत पाक है। ");
INSERT INTO urd_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","जुर्म की क़ुर्बानी वैसी ही है जैसी ख़ता की क़ुर्बानी है और उनके लिए एक ही शरा' है, और उन्हें वही काहिन ले जो उनसे कफ़्फ़ारा देता है ");
INSERT INTO urd_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","और जो काहिन किसी शख़्स की तरफ़ से सोख़्तनी क़ुर्बानी पेश करता हैं वही काहिन उस सोख़्तनी क़ुर्बानी की खाल को जो उसने पेश कीं, अपने लिए ले — ले। ");
INSERT INTO urd_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","और हर एक नज़्र की क़ुर्बानी जो तनूर में पकाई जाए, और वह भी जी कड़ाही में तैयार की जाए, और तवे की पकी हुई भी उसी काहिन की है जो उसे पेश करे। ");
INSERT INTO urd_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","और हर एक नज़्र की क़ुर्बानी चाहे उसमे तेल मिला हुआ हो या वह ख़ुश्क हो, बराबर — बराबर हारून के सब बेटों के लिए हो। ");
INSERT INTO urd_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","'और सलामती के ज़बीहे के बारे में जिसे कोई ख़ुदावन्द के सामने चढ़ाए शरा' यह है, ");
INSERT INTO urd_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","कि वह अगर शुक्राने के तौर पर उसे अदा करे तो वह शुक्राने के ज़बीहे के साथ, तेल मिले हुए बे — ख़मीरी कुल्चे और तेल चुपड़ी हुई बे — ख़मीरी चपातियाँ और तेल मिले हुए मैदे के तर कुल्चे भी पेश करे। ");
INSERT INTO urd_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","और सलामती के ज़बीहे की क़ुर्बानी के साथ जो शुक्राने के लिए होगी, वह ख़मीरी रोटी के गिर्द अपने हदिये पर पेश करे। ");
INSERT INTO urd_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","और हर हदिये में से वह एक को लेकर उसे ख़ुदावन्द के सामने हिलाने की क़ुर्बानी के तौर पर अदा करे; और यह उस काहिन का ही जो सलामती के ज़बीहे का ख़ून छिड़कता है। ");
INSERT INTO urd_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","और सलामती के ज़बीहों की उस क़ुर्बानी का गोश्त, जो उस की तरफ़ से शुक्राने के तौर पर होगी, क़ुर्बानी अदा करने के दिन ही खा लिया जाए; वह उसमें से कुछ सुबह तक बाक़ी न छोड़े। ");
INSERT INTO urd_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","लेकिन अगर उसके चढ़ावे की क़ुर्बानी मिन्नत का या रज़ा का हदिया हो, तो वह उस दिन खाई जाए जिस दिन वह अपनी क़ुर्बानी पेश करे; और जो कुछ उस में से बच रहे, वह दूसरे दिन खाया जाए। ");
INSERT INTO urd_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","लेकिन जो कुछ उस क़ुर्बानी के गोश्त में से तीसरे दिन तक रह जाए वह आग में जला दिया जाए। ");
INSERT INTO urd_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","और उसके सलामती के ज़बीहों की क़ुर्बानी के गोश्त में से अगर कुछ तीसरे दिन खाया जाए तो वह मंजूर न होगा, और न उस का सवाब क़ुर्बानी देने वाले की तरफ़ मन्सूब होगा, बल्कि यह मकरूह बात होगी; और जो उस में से खाए उस का गुनाह उसी के सिर लगेगा। ");
INSERT INTO urd_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“और जो गोश्त किसी नापाक चीज़ से छू जाए, खाया न जाए; वह आग में जलाया जाए। और ज़बीहे के गोश्त को, जो पाक है वह तो खाए, ");
INSERT INTO urd_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","लेकिन जो शख़्स नापाकी की हालत में ख़ुदावन्द की सलामती के ज़बीहे का गोश्त खाए, वह अपने लोगों में से काट डाला जाए। ");
INSERT INTO urd_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","और जो कोई किसी नापाक चीज़ को छुए, चाहे वह इंसान की नापाकी हो या नापाक जानवर हो या कोई नजिस मकरूह शय हो, और फिर ख़ुदावन्द के सलामती के ज़बीहे के गोश्त में से खाए, वह भी अपने लोगों में से काट डाला जाए।” ");
INSERT INTO urd_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“बनी — इस्राईल से कह, कि तुम लोग न तो बैल की न भेड़ की और न बकरी की कुछ चर्बी खाना। ");
INSERT INTO urd_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","जो जानवर ख़ुद — ब — ख़ुद मर गया हो और जिस को दरिन्दों ने फाड़ा हो, उनकी चर्बी और — और काम में लाओ तो लाओ पर उसे तुम किसी हाल में न खाना। ");
INSERT INTO urd_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","क्यूँकि जो कोई ऐसे चौपाये की चर्बी खाए, जिसे लोग आतिशी क़ुर्बानी के तौर पर ख़ुदावन्द के सामने चढ़ाते हैं, वह खाने वाला आदमी अपने लोगों में से काट डाला जाए। ");
INSERT INTO urd_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","और तुम अपनी सुकूनतगाहों में कहीं भी किसी तरह का ख़ून चाहे परिन्दे का हो या चौपाये का, हरगिज़ न खाना। ");
INSERT INTO urd_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","जो कोई किसी तरह का ख़ून खाए, वह शख़्स अपने लोगों में से काट डाला जाए।” ");
INSERT INTO urd_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“बनी — इस्राईल से कह कि जो कोई अपना सलामती का ज़बीहा ख़ुदावन्द के सामने पेश करे, वह ख़ुद ही अपने सलामती के ज़बीहे की क़ुर्बानी में से अपना हदिया ख़ुदावन्द के सामने लाए।” ");
INSERT INTO urd_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","वह अपने ही हाथों में ख़ुदावन्द की आतिशी क़ुर्बानी को लाए, या'नी चर्बी को सीने के साथ लाए कि सीना हिलाने की क़ुर्बानी के तौर पर हिलाया जाए। ");
INSERT INTO urd_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","और काहिन चर्बी को मज़बह पर जलाए, लेकिन सीना हारून और उसके बेटों का हो। ");
INSERT INTO urd_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","और तुम सलामती के ज़बीहों की दहनी रान उठाने की क़ुर्बानी के तौर पर काहिन को देना। ");
INSERT INTO urd_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","हारून के बेटों में से जो सलामती के ज़बीहों का ख़ून और चर्बी पेश करे, वही वह दहनी रान अपना हिस्सा ले। ");
INSERT INTO urd_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","क्यूँकि बनी इस्राईल के सलामती के ज़बीहों में से हिलाने की क़ुर्बानी का सीना और उठाने की क़ुर्बानी की रान को लेकर, मैंने हारून काहिन और उसके बेटों को दिया है, कि यह हमेशा बनी इस्राईल की तरफ़ से उन का हक़ हो। ");
INSERT INTO urd_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","“यह ख़ुदावन्द की आतिशी क़ुर्बानियों में से हारून के मम्सूह होने का और उसके बेटों के मम्सूह होने का हिस्सा है, जो उस दिन मुक़र्रर हुआ जब वह ख़ुदावन्द के सामने काहिन की ख़िदमत को अंजाम देने के लिए हाज़िर किए गए। ");
INSERT INTO urd_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","या'नी जिस दिन ख़ुदावन्द ने उन्हें मसह किया, उस दिन उसने यह हुक्म दिया कि बनी — इस्राईल की तरफ़ से उन्हें यह मिला करे; इसलिए उन की नसल — दर — नसल यह उन का हक़ रहेगा।” ");
INSERT INTO urd_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","सोख़्तनी क़ुर्बानी, और नज़्र की क़ुर्बानी, और ख़ता की क़ुर्बानी, और जुर्म की क़ुर्बानी, और तख़्सीस और सलामती के ज़बीहे के बारे में शरा' यह है। ");
INSERT INTO urd_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","जिसका हुक्म ख़ुदावन्द ने मूसा को उस दिन कोह-ए-सीना पर दिया जिस दिन उसने बनी — इस्राईल को फ़रमाया, कि सीना के वीराने में ख़ुदावन्द के सामने अपनी क़ुर्बानी पेश करें। ");
INSERT INTO urd_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“हारून और उसके साथ उसके बेटों को, और लिबास, को और मसह करने के तेल को, और ख़ता की क़ुर्बानी के बछड़े और दोनों मेंढों और बे — ख़मीरी रोटियों की टोकरी को ले; ");
INSERT INTO urd_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","और सारी जमा'अत को ख़ेमा — ए — इजितमा'अ के दरवाज़े पर जमा' कर।” ");
INSERT INTO urd_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","चुनाँचे मूसा ने ख़ुदावन्द के हुक्म के मुताबिक़ 'अमल किया; और सारी जमा'अत ख़ेमा — ए — इजितमा'अ के दरवाज़े पर जमा' हुई। ");
INSERT INTO urd_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","तब मूसा ने जमा'अत से कहा, “यह वह काम है, जिसके करने का हुक्म ख़ुदावन्द ने दिया है।” ");
INSERT INTO urd_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","फिर मूसा हारून और उसके बेटों को आगे लाया और उन को पानी से ग़ुस्ल दिलाया। ");
INSERT INTO urd_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","और उसको कुरता पहना कर उस पर कमरबन्द लपेटा, और उसको जुब्बा पहना कर उस पर अफ़ोद लगाया और अफ़ोद के कारीगरी से बुने हुए कमरबन्द को उस पर लपेटा, और उसी से उसको उसके ऊपर कस दिया। ");
INSERT INTO urd_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","और सीनाबन्द को उसके ऊपर लगा कर सीनाबन्द में ऊरीम और तुम्मीम लगा दिए। ");
INSERT INTO urd_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","और उसके सिर पर 'अमामा रख्खा और 'अमामे पर सामने सोने के पत्तर या'नी पाक ताज को लगाया, जैसा ख़ुदावन्द ने मूसा को हुक्म किया था। ");
INSERT INTO urd_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","और मूसा ने मसह करने का तेल लिया; और घर को और जो कुछ उसमें था सब को मसह कर के पाक किया। ");
INSERT INTO urd_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","और उस में से थोड़ा सा लेकर मज़बह पर सात बार छिड़का; और मज़बह और उसके सब बर्तनों को, और हौज़ और उसकी कुर्सी को मसह किया, ताकि उन्हें पाक करे। ");
INSERT INTO urd_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","और मसह करने के तेल में से थोड़ा सा हारून के सिर पर डाला और उसे मसह किया ताकि वह पाक हो। ");
INSERT INTO urd_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","फिर मूसा हारून के बेटों को आगे लाया और उन को कुरते पहनाए, और उन पर कमरबन्द लपेटे, और उनको पगड़ियाँ पहनाई जैसा ख़ुदावन्द ने मूसा को हुक्म किया था। ");
INSERT INTO urd_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","और वह ख़ता की क़ुर्बानी के बछड़े को आगे लाया, और हारून और उसके बेटों ने अपने — अपने हाथ ख़ता की क़ुर्बानी के बछड़े के सिर पर रख्खे। ");
INSERT INTO urd_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","फिर उसने उसको ज़बह किया, और मूसा ने ख़ून को लेकर मज़बह के चारों तरफ़ उसके सींगों पर अपनी उँगली से लगाया और मज़बह को पाक किया; और बाक़ी ख़ून मज़बह के पाये पर उँडेल कर उसका कफ़्फ़ारा दिया, ताकि वह पाक हो। ");
INSERT INTO urd_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","और मूसा ने अंतड़ियों के ऊपर की सारी चर्बी, और जिगर पर की झिल्ली, और दोनों गुर्दों और उन की चर्बी को लिया और उन्हें मज़बह पर जलाया; ");
INSERT INTO urd_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","लेकिन बछड़े को, उसकी खाल और गोश्त और गोबर के साथ, लश्करगाह के बाहर आग में जलाया, जैसा ख़ुदावन्द ने मूसा को हुक्म किया था। ");
INSERT INTO urd_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","फिर उसने सोख़्तनी क़ुर्बानी के मेंढे को हाज़िर किया, और हारून और उसके बेटों ने अपने — अपने हाथ उस मेंढे के सिर पर रख्खे। ");
INSERT INTO urd_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","और उसने उसको ज़बह किया, और मूसा ने ख़ून को मज़बह के ऊपर चारों तरफ़ छिड़का। ");
INSERT INTO urd_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","फिर उसने मेंढे के 'उज़्व — 'उज़्व को काट कर अलग किया, और मूसा ने सिर और 'आज़ा और चर्बी को जलाया। ");
INSERT INTO urd_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","और उसने अंतड़ियों और पायों को पानी से धोया, और मूसा ने पूरे मेंढे को मज़बह पर जलाया। यह सोख़्तनी क़ुर्बानी राहतअंगेज़ ख़ुशबू के लिए थी, यह ख़ुदावन्द की आतिशी क़ुर्बानी थी, जैसा ख़ुदावन्द ने मूसा को हुक्म किया था। ");
INSERT INTO urd_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","और उसने दूसरे मेंढे को जो तख़्सीसी मेंढा था हाज़िर किया, और हारून और उसके बेटों ने अपने — अपने हाथ उस मेंढे के सिर पर रख्खे। ");
INSERT INTO urd_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","और उसने उस को ज़बह किया, और मूसा ने उसका कुछ ख़ून लेकर उसे हारून के दहने कान की लौ पर, और दहने हाथ के अंगूठे और दहने पाँव के अंगूठे पर लगाया। ");
INSERT INTO urd_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","फिर वह हारून के बेटों को आगे लाया, और उसी ख़ून में से कुछ उनके दहने कान की लौ पर और दहने हाथ के अंगूठे और दहने पाँव के अंगूठे पर लगाया; और बाक़ी ख़ून को उसने मज़बह के ऊपर चारों तरफ़ छिड़का। ");
INSERT INTO urd_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","और उसने चर्बी और मोटी दुम, और अंतड़ियों के ऊपर की चर्बी, और जिगर पर की झिल्ली, और दोनो गुर्दे और उन की चर्बी, और दहनी रान इन सभों को लिया, ");
INSERT INTO urd_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","और बे — ख़मीरी रोटियों की टोकरी में से जो ख़ुदावन्द के सामने रहती थी, बे — ख़मीरी रोटी का एक गिर्दा, और तेल चुपड़ी हुई रोटी का एक गिर्दा, और एक चपाती निकाल कर उन्हे चर्बी और दहनी रान पर रख्खा। ");
INSERT INTO urd_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","और इन सभों को हारून और उसके बेटों के हाथों पर रखकर उन्हें हिलाने की क़ुर्बानी के तौर पर ख़ुदावन्द के सामने हिलाया। ");
INSERT INTO urd_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","फिर मूसा ने उनको उनके हाथों से ले लिया, और उनको मज़बह पर सोख़्तनी क़ुर्बानी के ऊपर जलाया। यह राहतअंगेज़ ख़ुशबू के लिए तख़्सीसी क़ुर्बानी थी। यह ख़ुदावन्द की आतिशी क़ुर्बानी थी। ");
INSERT INTO urd_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","फिर मूसा ने सीने को लिया, और उसको हिलाने की क़ुर्बानी के तौर पर ख़ुदावन्द के सामने हिलाया। उस तख़्सीसी मेंढे में से यही मूसा का हिस्सा था, जैसा ख़ुदावन्द ने मूसा को हुक्म किया था। ");
INSERT INTO urd_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","और मूसा ने मसह करने के तेल और मज़बह के ऊपर के ख़ून में से कुछ — कुछ लेकर उसे हारून और उसके लिबास पर, और साथ ही उसके बेटों पर और उनके लिबास पर छिड़का; और हारून और उसके लिबास को, और उसके बेटों को और उनके लिबास को पाक किया। ");
INSERT INTO urd_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","और मूसा ने हारून और उसके बेटों से कहा कि, ये गोश्त ख़ेमा — ए — इजितमा'अ के दरवाज़े पर पकाओ, और इसको वहीं उस रोटी के साथ जो तख़्सीसी टोकरी में है, खाओ, जैसा मैंने हुक्म किया है कि हारून और उसके बेटे उसे खाएँ। ");
INSERT INTO urd_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","और इस गोश्त और रोटी में से जो कुछ बच रहे उसे आग में जला देना; ");
INSERT INTO urd_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","और जब तक तुम्हारी तख्सीस के दिन पूरे न हों, तब तक या'नी सात दिन तक, तुम ख़ेमा — ए — इजितमा'अ के दरवाज़े से बाहर न जाना; क्यूँकि सात दिन तक वह तुम्हारी तख्सीस करता रहेगा। ");
INSERT INTO urd_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","जैसा आज किया गया है, वैसा ही करने का हुक्म ख़ुदावन्द ने दिया है ताकि तुम्हारे लिए कफ़्फ़ारा हो। ");
INSERT INTO urd_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","इसलिए तुम ख़ेमा — ए — इजितमा'अ के दरवाज़े पर सात रोज़ तक दिन रात ठहरे रहना, और ख़ुदावन्द के हुक्म को मानना, ताकि तुम मर न जाओ; क्यूँकि ऐसा ही हुक्म मुझको मिला है। ");
INSERT INTO urd_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","तब हारून और उसके बेटों ने सब काम ख़ुदावन्द के हुक्म के मुताबिक़ किया जो उस ने मूसा के ज़रिए' दिया था। ");
INSERT INTO urd_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","आठवें दिन मूसा ने हारून और उसके बेटों को और बनी — इस्राईल के बुज़ुर्गों को बुलाया और हारून से कहा कि, ");
INSERT INTO urd_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","“ख़ता की क़ुर्बानी के लिए एक बे — 'ऐब बछड़ा और सोख़्तनी क़ुर्बानी के लिए एक बे — 'ऐब मेंढा तू अपने वास्ते ले और उन को ख़ुदावन्द के सामने पेश कर। ");
INSERT INTO urd_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","और बनी — इस्राईल से कह, कि तुम ख़ता की क़ुर्बानी के लिए एक बकरा, और सोख़्तनी क़ुर्बानी के लिए एक बछड़ा, और एक बर्रा जो यकसाला और बे — 'ऐब हों लो। ");
INSERT INTO urd_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","और सलामती के ज़बीहे के लिए ख़ुदावन्द के सामने चढ़ाने के वास्ते एक बैल और एक मेंढा, और तेल मिली हुई नज़्र की क़ुर्बानी भी लो; क्यूँकि आज ख़ुदावन्द तुम पर ज़ाहिर होगा।” ");
INSERT INTO urd_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","और वह जो कुछ मूसा ने हुक्म किया था सब ख़ेमा — ए — इजितमा'अ के सामने ले आए, और सारी जमा'अत नज़दीक आकर ख़ुदावन्द के सामने खड़ी हुई। ");
INSERT INTO urd_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","मूसा ने कहा, “ये वह काम है जिसके बारे में ख़ुदावन्द ने हुक्म दिया है कि तुम उसे करो, और ख़ुदावन्द का जलाल तुम पर ज़ाहिर होगा।” ");
INSERT INTO urd_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","और मूसा ने हारून से कहा, कि मज़बह के नज़दीक जा और अपनी ख़ता की क़ुर्बानी और अपनी सोख़्तनी क़ुर्बानी पेश कर और अपने लिए और क़ौम के लिए कफ़्फ़ारा दे, और जमा'अत के हदिये को पेश कर और उनके लिए कफ़्फ़ारा दे जैसा ख़ुदावन्द ने हुक्म किया है। ");
INSERT INTO urd_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","तब हारून ने मज़बह के पास जाकर उस बछड़े को जो उसकी ख़ता की क़ुर्बानी के लिए था ज़बह किया। ");
INSERT INTO urd_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","और हारून के बेटे ख़ून को उसके पास ले गए, और उस ने अपनी उँगली उस में डुबो — डुबो कर उसे मज़बह के सीगों पर लगाया और बाक़ी ख़ून मज़बह के पाये पर उँडेल दिया। ");
INSERT INTO urd_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","लेकिन ख़ता की क़ुर्बानी की चर्बी, और गुर्दों और जिगर पर की झिल्ली को उसने मज़बह पर जलाया, जैसा ख़ुदावन्द ने मूसा को हुक्म किया था। ");
INSERT INTO urd_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","और गोश्त और खाल को लश्करगाह के बाहर आग में जलाया। ");
INSERT INTO urd_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","फिर उसने सोख़्तनी क़ुर्बानी के जानवर को ज़बह किया, और हारून के बेटों ने ख़ून उसे दिया और उसने उसको मज़बह के चारों तरफ़ छिड़का। ");
INSERT INTO urd_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","और सोख़्तनी क़ुर्बानी को एक — एक टुकड़ा कर के, सिर के साथ उसको दिया और उसने उन्हें मज़बह पर जलाया। ");
INSERT INTO urd_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","और उसने अंतड़ियों और पायों को धोया और उनको मज़बह पर सोख़्तनी क़ुर्बानी के उपर जलाया। ");
INSERT INTO urd_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","फिर जमा'अत के हदिये को आगे लाकर, और उस बकरे को जो जमा'अत की ख़ता की क़ुर्बानी के लिए था लेकर उस को ज़बह किया, और पहले की तरह उसे भी ख़ता के लिए पेश करा। ");
INSERT INTO urd_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","और सोख़्तनी क़ुर्बानी के जानवर को आगे लाकर, उसने उसे हुक्म के मुताबिक़ पेश किया। ");
INSERT INTO urd_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","फिर नज़्र की क़ुर्बानी को आगे लाया, और उसमें से एक मुट्ठी लेकर सुबह की सोख़्तनी क़ुर्बानी के 'अलावा उसे जलाया। ");
INSERT INTO urd_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","और उसने बैल और मेंढे को, जो लोगों की तरफ़ से सलामती के ज़बीहे थे, ज़बह किया; और हारून के बेटों ने ख़ून उसे दिया, और उसने उसको मज़बह पर चारों तरफ़ छिड़का। ");
INSERT INTO urd_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","और उन्होंने बैल की चर्बी को, और मेंढे की मोटी दुम को, और उस चर्बी को जिससे अंतड़ियाँ ढकी रहती हैं, और दोनों गुर्दों, और जिगर पर की झिल्ली को भी उसे दिया; ");
INSERT INTO urd_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","और चर्बी सीनों पर धर दी। तब उसने वह चर्बी मज़बह पर जलाई, ");
INSERT INTO urd_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","और सीना और दहनी रान को हारून ने मूसा के हुक्म के मुताबिक़ हिलाने की क़ुर्बानी के तौर पर ख़ुदावन्द के सामने हिलाया। ");
INSERT INTO urd_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","और हारून ने जमा'अत की तरफ़ अपने हाथ बढ़ाकर उनको बरकत दी; और ख़ता की क़ुर्बानी और सोख़्तनी क़ुर्बानी और सलामती की क़ुर्बानी पेश करके नीचे उतर आया। ");
INSERT INTO urd_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","और मूसा और हारून ख़ेमा — ए — इजितमा'अ में दाख़िल हुए, और बाहर निकल कर लोगों को बरकत दी; तब सब लोगों पर ख़ुदावन्द का जलाल नमूदार हुआ। ");
INSERT INTO urd_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","और ख़ुदावन्द के सामने से आग निकली और सोख़्तनी क़ुर्बानी और चर्बी को मज़बह के ऊपर भसम कर दिया; लोगों ने यह देख कर ना'रे मारे और सरनगूँ हो गए। ");
INSERT INTO urd_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","और नदब और अबीहू ने जो हारून के बेटे थे, अपने — अपने ख़ुशबूदान को लेकर उनमें आग भरी, और उस पर और ऊपरी आग जिस का हुक्म ख़ुदावन्द ने उनको नहीं दिया था, ख़ुदावन्द के सामने पेश कीं। ");
INSERT INTO urd_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","और ख़ुदावन्द के सामने से आग निकली और उन दोनों को खा गई, और वह ख़ुदावन्द के सामने मर गए। ");
INSERT INTO urd_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","तब मूसा ने हारून से कहा, “यह वही बात है जो ख़ुदावन्द ने कही थी, कि जो मेरे नज़दीक आएँ ज़रूर है कि वह मुझे पाक जानें, और सब लोगों के आगे मेरी तम्जीद करें।” और हारून चुप रहा ");
INSERT INTO urd_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","फिर मूसा ने मीसाएल और अलसफ़न को जो हारून के चचा उज़्ज़ीएल के बेटे थे, बुला कर उन से कहा, “नज़दीक आओ, और अपने भाइयों को हैकल के सामने से उठा कर लश्करगाह के बाहर ले जाओ।” ");
INSERT INTO urd_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","तब वह नज़दीक गए, और उन्हें उनके कुरतों के साथ उठाकर मूसा के हुक्म के मुताबिक़ लश्करगाह के बाहर ले गए। ");
INSERT INTO urd_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","और मूसा ने हारून और उसके बेटों, इली'एलियाज़र और ऐतामर से कहा, कि न तुम्हारे सिर के बाल बिखरने पाएँ, और न तुम अपने कपड़े फाड़ना, ताकि न तुम ही मरो, और न सारी जमा'अत पर उसका ग़ज़ब नाज़िल हो; लेकिन इस्राईल के सब घराने के लोग जो तुम्हारे भाई हैं, उस आग पर जो ख़ुदावन्द ने लगाई है नोहा करें। ");
INSERT INTO urd_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","और तुम ख़ेमा — ए — इजितमा'अ के दरवाज़े से बाहर न जाना, ता ऐसा न हो कि तुम मर जाओ; क्यूँकि ख़ुदावन्द का मसह करने का तेल तुम पर लगा हुआ है। इसलिए उन्होंने मूसा के कहने के मुताबिक़ 'अमल किया। ");
INSERT INTO urd_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","और ख़ुदावन्द ने हारून से कहा, कि ");
INSERT INTO urd_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“तू या तेरे बेटे मय या शराब पीकर कभी ख़ेमा — ए — इजितमा'अ के अन्दर दाख़िल न होना, ताकि तुम मर न जाओ। यह तुम्हारे लिए नसल — दर — नसल हमेशा तक एक क़ानून रहेगा; ");
INSERT INTO urd_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ताकि तुम पाक और 'आम अशिया में, और पाक और नापाक में तमीज़ कर सको; ");
INSERT INTO urd_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","और बनी — इस्राईल को वह सब तौर — तरीक़े सिखा सको जो ख़ुदावन्द ने मूसा के ज़रिए' उनको फ़रमाए हैं।” ");
INSERT INTO urd_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","फिर मूसा ने हारून और उसके बेटों, इली'एलियाज़र और ऐतामर से जो बाक़ी रह गए थे कहा, कि “ख़ुदावन्द की आतिशी क़ुर्बानियों में से जो नज़्र की क़ुर्बानी बच रही है उसे ले लो, और बग़ैर ख़मीर के उसको मज़बह के पास खाओ, क्यूँकि यह बहुत पाक है; ");
INSERT INTO urd_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","और तुम उसे किसी पाक जगह में खाना, इसलिए ख़ुदावन्द की आतिशी क़ुर्बानियों में से तेरा और तेरे बेटों का यह हक़ है; क्यूँकि मुझे ऐसा ही हुक्म मिला है। ");
INSERT INTO urd_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","और हिलाने की क़ुर्बानी के सीने को, और उठाने की क़ुर्बानी की रान को तुम लोग या'नी तेरे साथ तेरे बेटे और बेटियाँ भी, किसी साफ़ जगह में खाना; क्यूँकि बनी — इस्राईल की सलामती के ज़बीहो में से यह तेरा और तेरे बेटों का हक़ है जो दिया गया है। ");
INSERT INTO urd_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","और उठाने की क़ुर्बानी की रान और हिलाने की क़ुर्बानी का सीना, जिसे वह चर्बी की आतिशी क़ुर्बानियों के साथ लाएँगे, ताकि वह ख़ुदावन्द के सामने हिलाने की क़ुर्बानी के तौर पर हिलाए जाएँ। यह दोनों हमेशा के लिए ख़ुदावन्द के हुक्म के मुताबिक़ तेरा और तेरे बेटों का हक़ होगा।” ");
INSERT INTO urd_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","फिर मूसा ने ख़ता की क़ुर्बानी के बकरे को जो बहुत तलाश किया, तो क्या देखता है कि वह जल चुका है। तब वह हारून के बेटों इली'एलियाज़र और ऐतामर पर, जो बच रहे थे, नाराज़ हुआ और कहने लगा कि, ");
INSERT INTO urd_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“ख़ता की क़ुर्बानी जो बहुत पाक है और जिसे ख़ुदावन्द ने तुम को इसलिए दिया है कि तुम जमा'अत के गुनाह को अपने ऊपर उठा कर ख़ुदावन्द के सामने उनके लिए कफ़्फ़ारा दो, तुम ने उसका गोश्त हैकल में क्यूँ न खाया? ");
INSERT INTO urd_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","देखो, उसका ख़ून हैकल में तो लाया ही नहीं गया था। पस तुम्हें लाज़िम था कि मेरे हुक्म के मुताबिक़ तुम उसे हैकल में खा लेते।” ");
INSERT INTO urd_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","तब हारून ने मूसा से कहा, “देख, आज ही उन्होंने अपनी ख़ता की क़ुर्बानी और अपनी सोख़्तनी क़ुर्बानी ख़ुदावन्द के सामने पेश कीं, और मुझ पर ऐसे — ऐसे हादसे गुज़र गए। तब अगर मैं आज ख़ता की क़ुर्बानी का गोश्त खाता तो क्या यह बात ख़ुदावन्द की नज़र में भली होती?” ");
INSERT INTO urd_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","जब मूसा ने यह सुना तो उसे पसन्द आया। ");
INSERT INTO urd_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","फ़िर ख़ुदावन्द ने मूसा और हारून से कहा, ");
INSERT INTO urd_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“तुम बनी — इस्राईल से कहो कि ज़मीन के सब हैवानात में से जिन जानवरों को तुम खा सकते हो वह यह हैं। ");
INSERT INTO urd_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","जानवरों में जिनके पाँव अलग और चिरे हुए हैं और वह जुगाली करते हैं, तुम उनको खाओ। ");
INSERT INTO urd_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","मगर जो जुगाली करते हैं या जिनके पाँव अलग हैं, उन में से तुम इन जानवरों को न खाना; या'नी ऊँट को, क्यूँकि वह जुगाली करता है लेकिन उसके पाँव अलग नहीं, इसलिए वह तुम्हारे लिए नापाक है। ");
INSERT INTO urd_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","और साफ़ान को, क्यूँकि वह जुगाली करता है लेकिन उसके पाँव अलग नहीं, वह भी तुम्हारे लिए नापाक है। ");
INSERT INTO urd_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","और ख़रगोश को, क्यूँकि वह जुगाली तो करता है लेकिन उसके पाँव अलग नहीं, वह भी तुम्हारे लिए नापाक है। ");
INSERT INTO urd_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","और सूअर को, क्यूँकि उसके पाँव अलग और चिरे हुए हैं लेकिन वह जुगाली नहीं करता, वह भी तुम्हारे लिए नापाक है। ");
INSERT INTO urd_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","तुम उनका गोश्त न खाना और उन की लाशों को न छूना, वह तुम्हारे लिए नापाक हैं। ");
INSERT INTO urd_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“जो जानवर पानी में रहते हैं उन में से तुम इनको खाना, या'नी समन्दरों और दरियाओं वग़ैरह के जानवरो में, जिनके पर और छिल्के हों तुम उन्हें खाओ। ");
INSERT INTO urd_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","लेकिन वह सब जानदार जो पानी में या'नी समन्दरों और दरियाओं वग़ैरह में चलते फिरते और रहते हैं, लेकिन उनके पर और छिल्के नहीं होते, वह तुम्हारे लिए मकरूह हैं। ");
INSERT INTO urd_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","और वह तुम्हारे लिए मकरूह ही रहें। तुम उनका गोश्त न खाना और उन की लाशों से कराहियत करना। ");
INSERT INTO urd_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","पानी के जिस किसी जानदार के न पर हों और न छिल्के, वह तुम्हारे लिए मकरूह हैं। ");
INSERT INTO urd_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","'और परिन्दों में जो मकरूह होने की वजह से कभी खाए न जाएँ और जिन से तुम्हें कराहियत करना है वो यह हैं। उक़ाब और उस्तख़्वान ख़्वार और लगड़, ");
INSERT INTO urd_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","और चील और हर क़िस्म का बाज़, ");
INSERT INTO urd_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","और हर क़िस्म के कव्वे, ");
INSERT INTO urd_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","और शुतरमुर्ग़ और चुग़द और कोकिल और हर क़िस्म के शाहीन, ");
INSERT INTO urd_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","और बूम और हड़गीला और उल्लू, ");
INSERT INTO urd_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","और क़ाज़ और हवासिल और गिद्ध, ");
INSERT INTO urd_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","और लक़लक़ और सब क़िस्म के बगुले और हुद — हुद, और चमगादड़। ");
INSERT INTO urd_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“और सब परदार रेंगने वाले जानदार जितने चार पाँवों के बल चलते हैं, वह तुम्हारे लिए मकरूह हैं। ");
INSERT INTO urd_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","मगर परदार रेंगने वाले जानदारों में से जो चार पाँव के बल चलते हैं तुम उन जानदारों को खा सकते हो, जिनके ज़मीन के ऊपर कूदने फाँदने को पाँव के ऊपर टाँगें होती हैं, ");
INSERT INTO urd_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","वह जिन्हें तुम खा सकते हो यह हैं, हर क़िस्म की टिड्डी और हर क़िस्म का सुलि'आम और हर क़िस्म का झींगर और हर क़िस्म का टिड्डा। ");
INSERT INTO urd_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","लेकिन सब परदार रेंगने वाले जानदार जिनके चार पाँव हैं, वह तुम्हारे लिए मकरूह हैं। ");
INSERT INTO urd_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","'और इन से तुम नापाक ठहरोगे, जो कोई इन में से किसी की लाश को छुए वह शाम तक नापाक रहेगा। ");
INSERT INTO urd_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","और जो कोई इन की लाश में से कुछ भी उठाए वह अपने कपड़े धो डाले और वह शाम तक नापाक रहेगा। ");
INSERT INTO urd_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","और सब चारपाए जिनके पाँव अलग हैं लेकिन वह चिरे हुए नहीं और न वह जुगाली करते हैं, वह तुम्हारे लिए नापाक हैं; जो कोई उन को छुए वह नापाक ठहरेगा। ");
INSERT INTO urd_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","और चार पाँवों पर चलने वाले जानवरों में से जितने अपने पंजों के बल चलते हैं, वह भी तुम्हारे लिए नापाक हैं। जो कोई उन की लाश को छुए वह शाम तक नापाक रहेगा। ");
INSERT INTO urd_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","और जो कोई उन की लाश को उठाए वह अपने कपड़े धो डाले और वह शाम तक नापाक रहेगा। यह सब तुम्हारे लिए नापाक हैं। ");
INSERT INTO urd_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“और ज़मीन पर के रेंगने वाले जानवरों में से जो तुम्हारे लिए नापाक हैं वह यह हैं, या'नी नेवला और चूहा और हर क़िस्म की बड़ी छिपकली, ");
INSERT INTO urd_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","और हिरजून और गोह और छिपकली और सान्डा और गिरगिट। ");
INSERT INTO urd_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","सब रेंगने वाले जानदारों में से यह तुम्हारे लिए नापाक हैं, जो कोई उनके मरे पीछे उन को छुए वह शाम तक नापाक रहेगा। ");
INSERT INTO urd_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","और जिस चीज़ पर वह मरे पीछे गिरें वह चीज़ नापाक होगी, चाहे वह लकडी का बर्तन हो या कपड़ा या चमड़ा या बोरा हो, चाहे किसी का कैसा ही बर्तन हो, ज़रूर है कि वह पानी में डाला जाए और वह शाम तक नापाक रहेगा, इस के बाद वह पाक ठहरेगा। ");
INSERT INTO urd_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","और अगर इनमें से कोई किसी मिट्टी के बर्तन में गिर जाए तो जो कुछ उस में है वह नापाक होगा, और बर्तन को तुम तोड़ डालना। ");
INSERT INTO urd_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","उसके अन्दर अगर खाने की कोई चीज़ हो जिस में पानी पड़ा हुआ हो, तो वह भी नापाक ठहरेगी; और अगर ऐसे बर्तन में पीने के लिए कुछ हो तो वह नापाक होगा ");
INSERT INTO urd_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","और जिस चीज़ पर उनकी लाश का कोई हिस्सा गिरे, चाहे वह तनूर हो या चूल्हा, वह नापाक होगी और तोड़ डाली जाए। ऐसी चीज़ें नापाक होती हैं और वह तुम्हारे लिए भी नापाक हों, ");
INSERT INTO urd_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","मगर चश्मा या तालाब जिस में बहुत पानी हो वह पाक रहेगा, लेकिन जो कुछ उन की लाश से छू जाए वह नापाक होगा। ");
INSERT INTO urd_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","और अगर उन की लाश का कुछ हिस्सा किसी बोने के बीज पर गिरे तो वह बीज पाक रहेगा; ");
INSERT INTO urd_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","लेकिन अगर बीज पर पानी डाला गया हो और इसके बाद उन की लाश में से कुछ उस पर गिरा हो, तो वह तुम्हारे लिए नापाक होगा। ");
INSERT INTO urd_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“और जिन जानवरों को तुम खा सकते हो, अगर उन में से कोई मर जाए तो जो कोई उस की लाश को छुए वह शाम तक नापाक रहेगा। ");
INSERT INTO urd_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","और जो कोई उनकी लाश में से कुछ खाए, वह अपने कपड़े धो डाले और वह शाम तक नापाक रहेगा; और जो कोई उन की लाश को उठाए, वह अपने कपड़े धो डाले और वह शाम तक नापाक रहेगा। ");
INSERT INTO urd_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","'और सब रेंगने वाले जानदार जो ज़मीन पर रेंगते हैं, मकरूह हैं और कभी खाए न जाएँ। ");
INSERT INTO urd_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","और ज़मीन पर के सब रेंगने वाले जानदारों में से, जितने पेट या चार पाँवों के बल चलते हैं या जिनके बहुत से पाँव होते हैं, उनको तुम न खाना क्यूँकि वह मकरूह हैं। ");
INSERT INTO urd_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","और तुम किसी रेंगने वाले जानदार की वजह से जो ज़मीन पर रेंगता है, अपने आप को मकरूह न बना लेना और न उन से अपने आप को नापाक करना के नजिस हो जाओ; ");
INSERT INTO urd_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","क्यूँकि मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ, इसलिए अपने आप को पाक करना और पाक होना क्यूँकि मैं क़ुद्दूस हूँ, इसलिए तुम किसी तरह के रेंगने वाले जानदार से जो ज़मीन पर चलता है, अपने आप को नापाक न करना; ");
INSERT INTO urd_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","क्यूँकि मैं ख़ुदावन्द हूँ, और तुमको मुल्क — ए — मिस्र से इसी लिए निकाल कर लाया हूँ कि मैं तुम्हारा ख़ुदा ठहरूँ। इसलिए तुम पाक होना क्यूँकि मैं क़ुद्दुस हूँ।” ");
INSERT INTO urd_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","हैवानात, और परिन्दों, और आबी जानवरों, और ज़मीन पर के सब रेंगने वाले जानदारों के बारे में शरा' यही है; ");
INSERT INTO urd_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ताकि पाक और नापाक में, और जो जानवर खाए जा सकते हैं और जो नहीं खाए जा सकते, उनके बीच इम्तियाज़ किया जाए। ");
INSERT INTO urd_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“बनी — इस्राईल से कह कि अगर कोई 'औरत हामिला हो, और उसके लड़का हो तो वह सात दिन तक नापाक रहेगी; जैसे हैज़ के दिनों में रहती है। ");
INSERT INTO urd_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","और आठवें दिन लड़के का ख़तना किया जाए। ");
INSERT INTO urd_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","इसके बाद तैतीस दिन तक वह तहारत के ख़ून में रहे, और जब तक उसकी तहारत के दिन पूरे न हों तब तक न तो किसी पाक चीज़ को छुए और न हैकल में दाख़िल हो। ");
INSERT INTO urd_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","और अगर उसके लड़की हो तो वह दो हफ़्ते नापाक रहेगी, जैसे हैज़ के दिनों में रहती है। इसके बाद वह छियासठ दिन तक तहारत के ख़ून में रहे। ");
INSERT INTO urd_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","'और जब उसकी तहारत के दिन पूरे हो जाएँ, तो चाहे उसके बेटा हुआ हो या बेटी, वह सोख़्तनी क़ुर्बानी के लिए एक यक — साला बर्रा, और ख़ता की क़ुर्बानी के लिए कबूतर का एक बच्चा या एक कुमरी ख़ेमा — ए — इजितमा'अ के दरवाज़े पर काहिन के पास लाए; ");
INSERT INTO urd_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","और काहिन उसे ख़ुदावन्द के सामने पेश करे और उसके लिए कफ़्फ़ारा दे। तब वह अपने जिरयान — ए — ख़ून से पाक ठहरेगी। जिस 'औरत के लड़का या लड़की हो उसके बारे में शरा' यह है। ");
INSERT INTO urd_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","और अगर उस को बर्रा लाने का मक़दूर न हो तो वह दो कुमरियाँ या कबूतर के दो बच्चे, एक सोख़्तनी क़ुर्बानी के लिए और दूसरा ख़ता की क़ुर्बानी के लिए लाए। यूँ काहिन उसके लिए कफ़्फ़ारा दे तो वह पाक ठहरेगी।” ");
INSERT INTO urd_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","फिर ख़ुदावन्द ने मूसा और हारून से कहा, ");
INSERT INTO urd_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“अगर किसी के जिस्म की जिल्द में वर्म, या पपड़ी, या सफ़ेद चमकता हुआ दाग़ हो, और उसके जिस्म की जिल्द में कोढ़ जैसी बला हो, तो उसे हारून काहिन के पास या उसके बेटों में से जो काहिन हैं किसी के पास ले जाएँ। ");
INSERT INTO urd_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","और काहिन उसके जिस्म की जिल्द की बला को देखे, अगर उस बला की जगह के बाल सफ़ेद हो गए हों और वह बला देखने में खाल से गहरी हो, तो वह कोढ़ का मर्ज़ है; और काहिन उस शख़्स को देख कर उसे नापाक करार दे। ");
INSERT INTO urd_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","और अगर उसके जिस्म की जिल्द का चमकता हुआ दाग़ सफ़ेद तो हो लेकिन खाल से गहरा न दिखाई दे, और न उसके ऊपर के बाल सफ़ेद हो गए हों, तो काहिन उस शख़्स को सात दिन तक बन्द रख्खे; ");
INSERT INTO urd_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","और सातवें दिन काहिन उसे मुलाहिज़ा करे, और अगर वह बला उसे वहीं के वहीं दिखाई दे और जिल्द पर फैल न गई हो, तो काहिन उसे सात दिन और बन्द रख्खे; ");
INSERT INTO urd_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","और सातवें दिन काहिन उसे मुलाहिज़ा करे, और अगर देखे कि उस बला की चमक कम है और वह जिल्द के ऊपर फैली भी नहीं है; तो काहिन उसे पाक क़रार दे क्यूँकि वह पपड़ी है। इसलिए वह अपने कपड़े धो डाले और साफ़ हो जाए। ");
INSERT INTO urd_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","लेकिन अगर काहिन के उस मुलहज़े के बाद जिस में वह साफ़ क़रार दिया गया था, वह पपड़ी उसकी जिल्द पर बहुत फैल जाए, तो वह शख़्स काहिन को फिर दिखाया जाए; ");
INSERT INTO urd_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","और काहिन उसे मुलाहिज़ा करे, और अगर देखे कि वह पपड़ी जिल्द पर फैल गई है तो वह उसे नापाक क़रार दे; क्यूँकि वह कोढ़ है। ");
INSERT INTO urd_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“अगर किसी शख़्स को कोढ़ का मर्ज़ हो, तो उसे काहिन के पास ले जाएँ, ");
INSERT INTO urd_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","और काहिन उसे मुलाहिज़ा करे, और अगर देखे कि जिल्द पर सफ़ेद वर्म है और उसने बालों को सफ़ेद कर दिया है, और उस वर्म की जगह का गोश्त ज़िन्दा और कच्चा है, ");
INSERT INTO urd_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","तो यह उसके जिस्म की जिल्द में पुराना कोढ़ है, इसलिए काहिन उसे नापाक करार दे लेकिन उसे बन्द न करे क्यूँकि वह नापाक है। ");
INSERT INTO urd_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","और अगर कोढ़ जिल्द में चारों तरफ़ फूट आए, और जहाँ तक काहिन को दिखाई देता है, यही मा'लूम हो कि उस की जिल्द सिर से पाँव तक कोढ़ से ढंक गई है; ");
INSERT INTO urd_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","तो काहिन ग़ौर से देखे और अगर उस शख़्स का सारा जिस्म कोढ़ से ढका हुआ निकले, तो काहिन उस मरीज़ को पाक क़रार दे, क्यूँकि वह सब सफ़ेद हो गया है और वह पाक है। ");
INSERT INTO urd_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","लेकिन जिस दिन जीता और कच्चा गोश्त उस पर दिखाई दे, वह नापाक होगा। ");
INSERT INTO urd_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","और काहिन उस कच्चे गोश्त को देख कर उस शख़्स को नापाक करार दे, कच्चा गोश्त नापाक होता है; वह कोढ़ है। ");
INSERT INTO urd_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","और अगर वह कच्चा गोश्त फिर कर सफ़ेद हो जाए, तो वह काहिन के पास जाए; ");
INSERT INTO urd_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","और काहिन उसे मुलाहिज़ा करे, और अगर देखे कि मर्ज़ की जगह सब सफ़ेद हो गई है तो काहिन मरीज़ को पाक क़रार दे; वह पाक है। ");
INSERT INTO urd_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","'और अगर किसी के जिस्म की जिल्द पर फोड़ा हो कर अच्छा हो जाए, ");
INSERT INTO urd_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","और फोड़े की जगह सफ़ेद वर्म या सुर्ख़ी माइल चमकता हुआ सफ़ेद दाग़ हो तो वह दिखाया जाए; ");
INSERT INTO urd_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","और काहिन उसे मुलाहिज़ा करे, और अगर देखे कि वह खाल से गहरा नज़र आता है और उस पर के बाल भी सफ़ेद हो गए हैं, तो काहिन उस शख़्स को नापाक करार दे; क्यूँकि वह कोढ़ है जो फोड़े में से फूट कर निकला है। ");
INSERT INTO urd_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","लेकिन अगर काहिन देखे कि उस पर सफ़ेद बाल नहीं, और वह खाल से गहरा भी नहीं है और उसकी चमक कम है; तो काहिन उसे सात दिन तक बन्द रख्खे। ");
INSERT INTO urd_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","और अगर वह जिल्द पर चारों तरफ़ फैल जाए, तो काहिन उसे नापाक क़रार दे; क्यूँकि वह कोढ़ की बला है। ");
INSERT INTO urd_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","लेकिन अगर वह चमकता हुआ दाग अपनी जगह पर वहीं का वहीं रहे, और फैल न जाए तो वह फोड़े का दाग़ है; तब काहिन उस शख़्स को पाक करार दे। ");
INSERT INTO urd_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“या अगर जिस्म की खाल कहीं से जल जाए, और उस जली हुई जगह का ज़िन्दा गोश्त एक सुर्ख़ी माइल चमकता हुआ सफ़ेद दाग़ या बिल्कुल ही सफ़ेद दाग़ बन जाए ");
INSERT INTO urd_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","तो काहिन उसे मुलाहिज़ा करे, और अगर देखे कि उस चमकते हुए दाग़ के बाल सफ़ेद हो गए हैं और वह खाल से गहरा दिखाई देता है; तो वह कोढ़ है जो उस जल जाने से पैदा हुआ है; और काहिन उस शख़्स को नापाक क़रार दे क्यूँकि उसे कोढ़ की बीमारी है। ");
INSERT INTO urd_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","लेकिन अगर काहिन देखे कि उस चमकते हुए दाग़ पर सफ़ेद बाल नहीं, और न वह खाल से गहरा है बल्कि उसकी चमक भी कम है, तो वह उसे सात दिन तक बन्द रख्खे; ");
INSERT INTO urd_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","और सातवें दिन काहिन उसे देखे, अगर वह जिल्द पर बहुत फैल गया हो तो काहिन उस शख़्स को नापाक क़रार दे; क्यूँकि उसे कोढ़ की बीमारी है। ");
INSERT INTO urd_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","और अगर वह चमकता हुआ दाग़ अपनी जगह पर वहीं का वहीं रहे और जिल्द पर फैला हुआ न हो, बल्कि उसकी चमक भी कम हो, तो वह सिर्फ़ जल जाने की वजह से फूला हुआ है; और काहिन उस शख़्स को पाक क़रार दे क्यूँकि वह दाग़ जल जाने की वजह से है। ");
INSERT INTO urd_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“अगर किसी मर्द या 'औरत के सिर या ठोड़ी में दाग़ हो, ");
INSERT INTO urd_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","तो काहिन उस दाग़ को मुलाहिज़ा करे और अगर देखे कि वह खाल से गहरा मा'लूम होता है और उस पर ज़र्द — ज़र्द बारीक रोंगटे हैं तों काहिन उस शख़्स को नापाक क़रार दे क्यूँकि वह सा'फ़ा है जो सिर या ठोड़ी का कोढ़ है। ");
INSERT INTO urd_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","और अगर काहिन देखे कि वह सा'फ़ा की बला खाल से गहरी नहीं मा'लूम होती और उस पर स्याह बाल नहीं हैं, तो काहिन उस शख़्स को जिसे सा'फ़ा का मर्ज़ है, सात दिन तक बन्द रख्खे; ");
INSERT INTO urd_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","और सातवें दिन काहिन उस बला का मुलाहिज़ा करे और अगर देखे कि सा'फ़ा फैला नहीं और उस पर कोई ज़र्द बाल भी नहीं और सा'फ़ा खाल से गहरा नहीं मा'लूम होता; ");
INSERT INTO urd_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","तो उस शख़्स के बाल मूँडे जाएँ, लेकिन जहाँ सा'फ़ा हो वह जगह न मूँडी जाए। और काहिन उस शख़्स को जिसे सा'फ़ा का मर्ज़ है, सात दिन और बन्द रख्खे। ");
INSERT INTO urd_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","फिर सातवें रोज़ काहिन सा'फ़े का मुलाहिज़ा करे, और अगर देखें कि सा'फ़ा जिल्द में फैला नहीं और न वह खाल से गहरा दिखाई देता है तो काहिन उस शख़्स को पाक करार दे; और वह अपने कपड़े धोए और साफ़ हो जाए। ");
INSERT INTO urd_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","लेकिन अगर उस की सफ़ाई के बाद सा'फ़ा उसकी जिल्द पर बहुत फैल जाए तो काहिन उसे देखे, ");
INSERT INTO urd_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","और अगर सा'फ़ा उसकी जिल्द पर फैला हुआ नज़र आए तो काहिन ज़र्द बाल को न ढूँढे क्यूँकि वह शख़्स नापाक है। ");
INSERT INTO urd_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","लेकिन अगर उस को सा'फ़ा अपनी जगह पर वहीं का वहीं दिखाई दे और उस पर स्याह बाल निकले हुए हों, तो सा'फ़ा अच्छा हो गया; वह शख़्स पाक है और काहिन उसे पाक क़रार दे। ");
INSERT INTO urd_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","और अगर किसी मर्द या 'औरत के जिस्म की जिल्द में चमकते हुए दाग़ या सफ़ेद चमकते हुए दाग़ हों, ");
INSERT INTO urd_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","तो काहिन देखे, और अगर उनके जिस्म की जिल्द के दाग स्याही माइल सफ़ेद रंग के हों, तो वह छीप है जो जिल्द में फूट निकली है; वह शख़्स पाक है। ");
INSERT INTO urd_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","'और जिस शख़्स के सिर के बाल गिर गए हों, वह गंजा तो है मगर पाक है। ");
INSERT INTO urd_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","और जिस शख़्स के सर के बाल पेशानी की तरफ़ से गिर गए हों, वह चँदुला तो है मगर पाक है। ");
INSERT INTO urd_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","लेकिन उस गंजे या चँदले सिर पर सुर्ख़ी माइल सफ़ेद दाग़ हों, तो यह कोढ़ है जो उसके गंजे या चँदले सिर पर निकला है; ");
INSERT INTO urd_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","इसलिए काहिन उसे मुलाहिज़ा करे, और अगर वह देखे कि उसके गंजे या चँदले सिर पर वह दाग़ ऐसा सुर्खी माइल सफ़ेद रंग लिए हुए है, जैसा जिल्द के कोढ़ में होता है, ");
INSERT INTO urd_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","तो वह आदमी कोढ़ी है, वह नापाक है और काहिन उसे ज़रूर ही नापाक करार दे क्यूँकि वह मर्ज़ उसके सिर पर है। ");
INSERT INTO urd_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","और जो कोढ़ी इस बला में मुब्तिला हो, उसके कपड़े फटे और उसके सिर के बाल बिखरे रहें, और वह अपने ऊपर के होंट को ढाँके और चिल्ला — चिल्ला कर कहे, नापाक, नापाक। ");
INSERT INTO urd_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","जितने दिनों तक वह इस बला में मुब्तिला रहे, वह नापाक रहेगा और वह है भी नापाक। तब वह अकेला रहा करे, उसका मकान लश्करगाह के बाहर हो। ");
INSERT INTO urd_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","'और वह कपड़ा भी जिस में कोढ़ की बला हो, चाहे वह ऊन का हो या कतान का; ");
INSERT INTO urd_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","और वह बला भी चाहे कतान या ऊन के कपड़े के ताने में या उसके बाने में हो, या वह चमड़े में हो या चमड़े की बनी हुई किसी चीज़ में हो; ");
INSERT INTO urd_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","अगर वह बला कपड़े में या चमड़े में, कपड़े के ताने में या बाने में या चमड़े की किसी चीज़ में सब्ज़ी माइल या सुर्ख़ी माइल रंग की हो, तो वह कोढ़ की बला है और काहिन को दिखाई जाए। ");
INSERT INTO urd_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","और काहिन उस बला को देखे, और उस चीज़ को जिस में वह बला है सात दिन तक बन्द रख्खे; ");
INSERT INTO urd_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","और सातवें दिन उस को देखें। अगर वह बला कपड़े के ताने में या बाने में, या चमड़े पर या चमड़े की बनी हुई किसी चीज़ पर फैल गई हो, तो वह खा जाने वाला कोढ़ है और नापाक है। ");
INSERT INTO urd_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","और उस ऊन या कतान के कपड़े को जिसके ताने में या बाने में वह बला है, या चमड़े की उस चीज़ को जिस में वह है जला दे; क्यूँकि यह खा जाने वाला कोढ़ है। वह आग में जलाया जाए। ");
INSERT INTO urd_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“और अगर काहिन देखे, कि वह बला कपड़े के ताने में या बाने में, या चमड़े की किसी चीज़ में फैली हुई नज़र नहीं आती, ");
INSERT INTO urd_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","तो काहिन हुक्म करे कि उस चीज़ को जिस में वह बला है धोएँ, और वह फिर उसे और सात दिन तक बन्द रख्खे; ");
INSERT INTO urd_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","और उस बला के धोए जाने के बाद काहिन फिर उसे मुलाहिज़ा करे, और अगर देखे कि उस बला का रंग नहीं बदला और वह फैली भी नहीं है, तो वह नापाक है। तू उस कपड़े को आग में जला देना; क्यूँकि वह खा जाने वाली बला है, चाहे उस का फ़साद अन्दरूनी हो या बैरूनी। ");
INSERT INTO urd_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","और अगर काहिन देखे कि धोने के बाद उस बला की चमक कम हो गई है, तो वह उसे उस कपड़े से या चमड़े से, ताने या बाने से, फाड़ कर निकाल फेंके। ");
INSERT INTO urd_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","और अगर वह बला फिर भी कपड़े के ताने या बाने में या चमड़े की चीज़ में दिखाई दे, तो वह फूटकर निकल रही है। तब तू उस चीज़ को जिस में वह बला है आग में जला देना। ");
INSERT INTO urd_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","और अगर उस कपड़े के ताने या बाने में से, या चमड़े की चीज़ में से, जिसे तूने धोया है, वह बला जाती रहे तो वह चीज़ दोबारा धोई जाए और वह पाक ठहरेगी।” ");
INSERT INTO urd_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ऊन या कतान के ताने या बाने में, या चमड़े की किसी चीज़ में अगर कोढ़ की बला हो, तो उसे पाक या नापाक क़रार देने केलिए शरा' यही है। ");
INSERT INTO urd_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","फिर ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","'कोढ़ी के लिए जिस दिन वह पाक क़रार दिया जाए यह शरा' है, कि उसे काहिन के पास ले जाएँ, ");
INSERT INTO urd_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","और काहिन लश्करगाह के बाहर जाए, और काहिन ख़ुद कोढ़ी को मुलाहिज़ा करे और अगर देखे कि उसका कोढ़ अच्छा हो गया है, ");
INSERT INTO urd_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","तो काहिन हुक्म दे कि वह जो पाक क़रार दिए जाने को है, उसके लिए दो ज़िन्दा पाक परिन्दे और देवदार की लकड़ी और सुर्ख़ कपड़ा और ज़ूफ़ा लें। ");
INSERT INTO urd_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","और काहिन हुक्म दे कि उनमें से एक परिन्दा किसी मिट्टी के बर्तन में बहते हुए पानी के ऊपर ज़बह किया जाए। ");
INSERT INTO urd_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","फिर वह ज़िन्दा परिन्दे को और देवदार की लकड़ी और सुर्ख़ कपड़े और ज़ूफ़े को ले, और इन को और उस ज़िन्दा परिन्दे को उस परिन्दे के ख़ून में ग़ोता दे जो बहते पानी पर ज़बह हो चुका है। ");
INSERT INTO urd_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","और उस शख़्स पर जो कोढ़ से पाक करार दिया जाने को है, सात बार छिड़क कर उसे पाक क़रार दे और ज़िन्दा परिन्दे को खुले मैदान में छोड़ दे। ");
INSERT INTO urd_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","और वह जो पाक करार दिया जाएगा अपने कपड़े धोए और सारे बाल मुन्डाए और पानी में ग़ुस्ल करे, तब वह पाक ठहरेगा; इसके बाद वह लश्करगाह में आए, लेकिन सात दिन तक अपने ख़ेमे के बाहर ही रहे। ");
INSERT INTO urd_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","और सातवें रोज़ अपने सिर के सब बाल और अपनी दाढ़ी और अपने अबरू ग़र्ज़ अपने सारे बाल मुंडाए, और अपने कपड़े धोए और पानी में नहाए, तब वह पाक ठहरेगा। ");
INSERT INTO urd_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","और वह आठवें दिन दो बे — 'ऐब नर बर्रे और एक बे — 'ऐब यक — साला मादा बर्रा और नज़्र की क़ुर्बानी के लिए ऐफ़ा के तीन दहाई हिस्से के बराबर तेल मिला हुआ मैदा और लोज भर तेल ले। ");
INSERT INTO urd_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","तब वह काहिन जो उसे पाक करार देगा, उस शख़्स को जो पाक करार दिया जाएगा और इन चीज़ों को ख़ुदावन्द के सामने ख़ेमा — ए — इजितमा'अ के दरवाज़े पर हाज़िर करे। ");
INSERT INTO urd_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","और काहिन नर बर्रों में से एक को लेकर जुर्म की क़ुर्बानी के लिए उसे और उस लोज भर तेल की नज़दीक लाए, और उनको हिलाने की क़ुर्बानी के तौर पर ख़ुदावन्द के सामने हिलाए; ");
INSERT INTO urd_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","और उस बर्रे को हैकल में उस जगह ज़बह करे जहाँ ख़ता की क़ुर्बानी और सोख़्तनी क़ुर्बानी के जानवर ज़बह किए जाते हैं, क्यूँकि जुर्म की क़ुर्बानी ख़ता की क़ुर्बानी की तरह काहिन का हिस्सा ठहरेगी; वह बहुत पाक है। ");
INSERT INTO urd_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","और काहिन जुर्म की क़ुर्बानी का कुछ ख़ून ले और जो शख़्स पाक क़रार दिया जाएगा उसके दहने कान की लौ पर और दहने हाथ के अँगूठे पर और दहने पाँव के अंगूठे पर उसे लगाए, ");
INSERT INTO urd_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","और काहिन उस लोज भर तेल में से कुछ लेकर अपने बाएँ हाथ की हथेली में डाले; ");
INSERT INTO urd_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","और काहिन अपनी दहनी उँगली को अपने बाएँ हाथ के तेल में डुबोए, और ख़ुदावन्द के सामने कुछ तेल सात बार अपनी उँगली से छिड़के। ");
INSERT INTO urd_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","और काहिन अपने हाथ के बाक़ी तेल में से कुछ ले और जो शख़्स पाक करार दिया जाएगा उसके दहने कान की लौ पर और उसके दहने हाथ के अंगूठे और दहने पांव के अंगूठे पर, जुर्म की क़ुर्बानी के ख़ून के ऊपर लगाए। ");
INSERT INTO urd_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","और जो तेल काहिन के हाथ में बाक़ी बचे उसे वह उस शख़्स के सिर में डाल दे जो पाक करार दिया जाएगा, यूँ काहिन उसके लिए ख़ुदावन्द के सामने कफ़्फ़ारा दे। ");
INSERT INTO urd_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","और काहिन ख़ता की क़ुर्बानी भी पेश करे, और उसके लिए जो अपनी नापाकी से पाक करार दिया जाएगा कफ़्फ़ारा दे; इसके बाद वह सोख़्तनी क़ुर्बानी के जानवर को ज़बह करे। ");
INSERT INTO urd_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","फिर काहिन सोख़्तनी कुबानी और नज़्र की क़ुर्बानी को मज़बह पर अदा करे। यूँ काहिन उसके लिए कफ़्फ़ारा दे तो वह पाक ठहरेगा। ");
INSERT INTO urd_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“और अगर वह ग़रीब हो और इतना उसे मक़दूर न हो तो वह हिलाने के लिए जुर्म की क़ुर्बानी के लिए एक नर बर्रा ले ताकि उसके लिए कफ़्फ़ारा दिया जाए और नज़्र की क़ुर्बानी के लिए ऐफ़ा के दसवें हिस्से के बराबर तेल मिला हुआ मैदा और लोज भर तेल, ");
INSERT INTO urd_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","और अपने मक़दूर के मुताबिक़ दो कुमरियाँ या कबूतर के दो बच्चे भी ले, जिन में से एक तो ख़ता की क़ुर्बानी के लिए और दूसरा सोख़्तनी क़ुर्बानी के लिए हो। ");
INSERT INTO urd_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","इन्हें वह आठवें दिन अपने पाक करार दिए जाने के लिए काहिन के पास ख़ेमा — ए — इजितमा'अ के दरवाज़े पर ख़ुदावन्द के सामने लाए। ");
INSERT INTO urd_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","और काहिन जुर्म की क़ुर्बानी के बर्रे को और उस लोज भर तेल को लेकर उनको ख़ुदावन्द के सामने हिलाने की क़ुर्बानी के तौर पर हिलाए। ");
INSERT INTO urd_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","फिर काहिन जुर्म की क़ुर्बानी के बर्रे को ज़बह करे, और वह जुर्म की क़ुर्बानी का कुछ ख़ून लेकर जो शख़्स पाक क़रार दिया जाएगा, उसके दहने कान की लौ पर और दहने हाथ के अंगूठे और दहने पाँव के अंगूठे पर उसे लगाए। ");
INSERT INTO urd_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","फिर काहिन उस तेल में से कुछ अपने बाएँ हाथ की हथेली में डाले, ");
INSERT INTO urd_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","और वह अपने बाएँ हाथ के तेल में से कुछ अपनी दहनी उँगली से ख़ुदावन्द के सामने सात बार छिड़के। ");
INSERT INTO urd_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","फिर काहिन कुछ अपने हाथ के तेल में से ले, और जो शख़्स पाक करार दिया जाएगा उसके दहने कान की लौ पर और उसके दहने हाथ के अंगूठे और दहने पाँव के अंगूठे पर, जुर्म की क़ुर्बानी के ख़ून की जगह उसे लगाए; ");
INSERT INTO urd_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","और जो तेल काहिन के हाथ में बाक़ी बचे उसे वह उस शख़्स के सिर में डाल दे जो पाक क़रार दिया जाएगा, ताकि उसके लिए ख़ुदावन्द के सामने कफ़्फ़ारा दिया जाए। ");
INSERT INTO urd_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","फिर वह कुमरियों या कबूतर के बच्चों में से जिन्हें वह ला सका हो एक को अदा करे, ");
INSERT INTO urd_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","या'नी जो कुछ उसे मयस्सर हुआ हो उस में से एक को ख़ता की क़ुर्बानी के तौर पर और दूसरे को सोख़्तनी क़ुर्बानी के तौर पर, नज़्र की क़ुर्बानी के साथ पेश करे। यूँ काहिन उस शख़्स के लिए जो पाक क़रार दिया जाएगा, ख़ुदावन्द के सामने कफ़्फ़ारा दे। ");
INSERT INTO urd_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","उस कोढ़ी के लिए जो अपने पाक क़रार दिए जाने के सामान को लाने का मक़दूर न रखता हो शरा' यह है।” ");
INSERT INTO urd_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","फिर ख़ुदावन्द ने मूसा और हारून से कहा, ");
INSERT INTO urd_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“जब तुम मुल्क — ए — कनान में जिसे मैं तुम्हारी मिल्कियत किए देता हूँ दाख़िल हो, और मैं तुम्हारे मीरासी मुल्क के किसी घर में कोढ़ की बला भेजूँ। ");
INSERT INTO urd_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","तो उस घर का मालिक जाकर काहिन को ख़बर दे कि मुझे ऐसा मा'लूम होता है कि उस घर में कुछ बला सी है। ");
INSERT INTO urd_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","तब काहिन हुक्म करे कि इससे पहले कि उस बला को देखने के लिए काहिन वहाँ जाए लोग उस घर को ख़ाली करें, ताकि जो कुछ घर में हो वह नापाक न ठहराया जाए। इसके बाद काहिन घर देखने को अन्दर जाए। ");
INSERT INTO urd_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","और उस बला को मुलाहिज़ा करे, और अगर देखे कि वह बला उस घर की दीवारों में सब्ज़ी या सुर्ख़ीमाइल गहरी लकीरों की सूरत में है, और दीवार में सतह के अन्दर नज़र आती है, ");
INSERT INTO urd_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","तो काहिन घर से बाहर निकल कर घर के दरवाज़े पर जाए और घर को सात दिन के लिए बन्द कर दे; ");
INSERT INTO urd_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","और वह सातवें दिन फिर आकर उसे देखें। अगर वह बला घर की दीवारों में फैली हुई नज़र आए, ");
INSERT INTO urd_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","तो काहिन हुक्म दे कि उन पत्थरों को जिन में वह बला है, निकालकर उन्हें शहर के बाहर किसी नापाक जगह में फेंक दें। ");
INSERT INTO urd_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","फिर वह उस घर को अन्दर ही अन्दर चारों तरफ़ से खुर्चवाए, और उस खुर्ची हुई मिट्टी को शहर के बाहर किसी नापाक जगह में डालें। ");
INSERT INTO urd_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","और वह उन पत्थरों की जगह और पत्थर लेकर लगाएं और काहिन ताज़ा गारे से उस घर की अस्तरकारी कराए। ");
INSERT INTO urd_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","और अगर पत्थरों के निकाले जाने और उस घर के खुर्च और अस्तरकारी कराए जाने के बाद भी वह बला फिर आ जाए और उस घर में फूट निकले, ");
INSERT INTO urd_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","तो काहिन अन्दर जाकर मुलाहिज़ा करे, और अगर देखे कि वह बला घर में फैल गई है तो उस घर में खा जाने वाला कोढ़ है; वह नापाक है। ");
INSERT INTO urd_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","तब वह उस घर को, उसके पत्थरों और लकड़ियों और उसकी सारी मिट्टी को गिरा दे; और वह उनको शहर के बाहर निकाल कर किसी नापाक जगह में ले जाए। ");
INSERT INTO urd_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","इसके सिवा, अगर कोई उस घर के बन्द कर दिए जाने के दिनों में उसके अन्दर दाख़िल हो तो वह शाम तक नापाक रहेगा; ");
INSERT INTO urd_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","और जो कोई उस घर में सोए वह अपने कपड़े धो डाले, और जो कोई उस घर में कुछ खाए वह भी अपने कपड़े धोए। ");
INSERT INTO urd_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“और अगर काहिन अन्दर जाकर मुलाहिज़ा करे और देखे कि घर की अस्तरकारी के बाद वह बला उस घर में नहीं फैली, तो वह उस घर को पाक क़रार दे क्यूँकि वह बला दूर हो गई। ");
INSERT INTO urd_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","और वह उस घर को पाक करार देने के लिए दो परिन्दे और देवदार की लकड़ी और सुर्ख़ कपड़ा और ज़ूफ़ा ले, ");
INSERT INTO urd_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","और वह उन परिन्दों में से एक को मिट्टी के किसी बर्तन में बहते हुए पानी पर ज़बह करे; ");
INSERT INTO urd_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","फिर वह देवदार की लकड़ी और ज़ूफ़ा और सुर्ख़ कपड़े और उस ज़िन्दा परिन्दे को लेकर उनको उस ज़बह किए हुए परिन्दे के ख़ून में और उस बहते हुए पानी में गोता दे, और सात बार उस घर पर छिड़के। ");
INSERT INTO urd_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","और वह उस परिन्दे के ख़ून से, और बहते हुए पानी और ज़िन्दा परिन्दे और देवदार की लकड़ी और ज़ूफ़े और सुर्ख़ कपड़े से उस घर को पाक करे; ");
INSERT INTO urd_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","और उस ज़िन्दा परिन्दे को शहर के बाहर खुले मैदान में छोड़ दे; यूँ वह घर के लिए कफ़्फ़ारा दे, तो वह पाक ठहरेगा।” ");
INSERT INTO urd_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","कोढ़ की हर क़िस्म की बला के, और साफ़े के लिए, ");
INSERT INTO urd_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","और कपड़े और घर के कोढ़ के लिए, ");
INSERT INTO urd_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","और वर्म और पपड़ी, और चमकते हुए दाग़ के लिए शरा' यह है; ");
INSERT INTO urd_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ताकि बताया जाए कि कब वह नापाक और कब पाक करार दिए जाएँ। कोढ़ के लिए शरा' यही है। ");
INSERT INTO urd_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","और ख़ुदावन्द ने मूसा और हारून से कहा कि; ");
INSERT INTO urd_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“बनी — इस्राईल से कहो कि अगर किसी शख़्स की जिरयान का मर्ज़ हो तो वह जिरयान की वजह से नापाक है; ");
INSERT INTO urd_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","और जिरयान की वजह से उसकी नापाकी यूँ होगी, कि चाहे धात बहती हो या धात का बहना ख़त्म हो गया हो वह नापाक है। ");
INSERT INTO urd_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","जिस बिस्तर पर जिरयान का मरीज़ सोए वह बिस्तर नापाक होगा, और जिस चीज़ पर वह बैठे वह चीज़ नापाक होगी। ");
INSERT INTO urd_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","और जो कोई उसके बिस्तर को छुए, वह अपने कपड़े धोए और पानी से ग़ुस्ल करे और शाम तक नापाक रहे। ");
INSERT INTO urd_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","और जो कोई उस चीज़ पर बैठे जिस पर जिरयान का मरीज़ बैठा हो, वह अपने कपड़े धोए और पानी से ग़ुस्ल करे और शाम तक नापाक रहे। ");
INSERT INTO urd_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","और जो कोई जिरयान के मरीज़ के जिस्म को छुए, वह भी अपने कपड़े धोए और पानी से ग़ुस्ल करे और शाम तक नापाक रहे। ");
INSERT INTO urd_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","और अगर जिरयान का मरीज़ किसी शख़्स पर जो पाक है। थूक दे, तो वह शख़्स अपने कपड़े धोए और पानी से ग़ुस्ल करे और शाम तक नापाक रहे। ");
INSERT INTO urd_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","और जिस ज़ीन पर जिरयान का मरीज़ सवार हो, वह ज़ीन नापाक होगा। ");
INSERT INTO urd_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","और जो कोई किसी चीज़ को जो उस मरीज़ के नीचे रही हो छुए, वह शाम तक नापाक रहे; और जो कोई उन चीज़ों को उठाए, वह अपने कपड़े धोए और पानी से ग़ुस्ल करे और शाम तक नापाक रहे। ");
INSERT INTO urd_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","और जिस शख़्स की जिरयान का मरीज़ बगै़र हाथ धोए छुए, वह अपने कपड़े धोए और पानी से ग़ुस्ल करे और शाम तक नापाक रहे। ");
INSERT INTO urd_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","और मिट्टी के जिस बर्तन को जिरयान का मरीज़ छुए, वह तोड़ डाला जाए; लेकिन चोबी बर्तन पानी से धोया जाए। ");
INSERT INTO urd_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","'और जब जिरयान के मरीज़ को शिफ़ा हो जाए, तो वह अपने पाक ठहरने के लिए सात दिन गिने; इस के बाद वह अपने कपड़े धोए और बहते हुए पानी में नहाए तब वह पाक होगा। ");
INSERT INTO urd_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","और आठवें दिन दो कुमरियाँ या कबूतर के दो बच्चे लेकर वह ख़ुदावन्द के सामने ख़ेमा — ए — इजितमा'अ के दरवाज़े पर जाए, और उन को काहिन के हवाले करे; ");
INSERT INTO urd_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","और काहिन एक को ख़ता की क़ुर्बानी के लिए, और दूसरे को सोख़्तनी क़ुर्बानी के लिए पेश करे। यूँ काहिन उसके लिए उसके जिरयान की वजह से ख़ुदावन्द के सामने कफ़्फ़ारा दे। ");
INSERT INTO urd_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","'और अगर किसी मर्द की धात बहती हो, तो वह पानी में नहाए और शाम तक नापाक रहे। ");
INSERT INTO urd_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","और जिस कपड़े या चमड़े पर नुत्फ़ा लग जाए, वह कपड़ा या चमड़ा पानी से धोया जाए और शाम तक नापाक रहे। ");
INSERT INTO urd_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","और वह 'औरत भी जिसके साथ मर्द सुहबत करे और मुन्ज़िल हो, तो वह दोनों पानी से ग़ुस्ल करें और शाम तक नापाक रहे। ");
INSERT INTO urd_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","'और अगर किसी 'औरत को ऐसा जिरयान हो कि उसे हैज़ का ख़ून आए, तो वह सात दिन तक नापाक रहेगी, और जो कोई उसे छुए वह शाम तक नापाक रहेगा। ");
INSERT INTO urd_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","और जिस चीज़ पर वह अपनी नापाकी की हालत में सोए वह चीज़ नापाक होगी, और जिस चीज़ पर बैठे वह भी नापाक हो जाएगी। ");
INSERT INTO urd_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","और जो कोई उसके बिस्तर को छुए, वह अपने कपड़े धोए और पानी से ग़ुस्ल करे और शाम तक नापाक रहे। ");
INSERT INTO urd_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","और जो कोई उस चीज़ को जिस पर वह बैठी हो छुए, वह अपने कपड़े धोए और पानी से नहाए और शाम तक नापाक रहे। ");
INSERT INTO urd_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","और अगर उसका ख़ून उसके बिस्तर पर या जिस चीज़ पर वह बैठी हो उस पर लगा हुआ हो और उस वक़्त कोई उस चीज़ को छुए, तो वह शाम तक नापाक रहे। ");
INSERT INTO urd_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","और अगर मर्द उसके साथ सुहबत करे और उसके हैज़ का ख़ून उसे लग जाए, तो वह सात दिन तक नापाक रहेगा और हर एक बिस्तर जिस पर वह मर्द सोएगा नापाक होगा। ");
INSERT INTO urd_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","'और अगर किसी 'औरत को हैज़ के दिन को छोड़कर यूँ बहुत दिनों तक ख़ून आए या हैज़ की मुद्दत गुज़र जाने पर भी ख़ून जारी रहे, तो जब तक उस को यह मैला ख़ून आता रहेगा तब तक वह ऐसी ही रहेगी जैसी हैज़ के दिनों में रहती है, वह नापाक है। ");
INSERT INTO urd_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","और इस जिरयान — ए — ख़ून के कुल दिनों में जिस — जिस बिस्तर पर वह सोएगी, वह हैज़ के बिस्तर की तरह नापाक होगा; और जिस — जिस चीज़ पर वह बैठेगी, वह चीज़ हैज़ की नजासत की तरह नापाक होगी। ");
INSERT INTO urd_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","और जो कोई उन चीज़ों को छुए वह नापाक होगा, वह अपने कपड़े धोए और पानी से ग़ुस्ल करे और शाम तक नापाक रहे। ");
INSERT INTO urd_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","और जब वह अपने जिरयान से शिफ़ा पा जाए तो सात दिन गिने, तब इसके बाद वह पाक ठहरेगी। ");
INSERT INTO urd_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","और आठवें दिन वह दो कुमरियाँ या कबूतर के दो बच्चे लेकर उनको ख़ेमा — ए — इजितमा'अ के दरवाज़े पर काहिन के पास लाए। ");
INSERT INTO urd_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","और काहिन एक को ख़ता की क़ुर्बानी के लिए और दूसरे को सोख़्तनी क़ुर्बानी के लिए पेश करे, यूँ काहिन उसके नापाक ख़ून के जिरयान के लिए ख़ुदावन्द के सामने उस की तरफ़ से कफ़्फ़ारा दे। ");
INSERT INTO urd_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“इस तरीक़े से तुम बनी — इस्राईल को उन की नजासत से अलग रखना, ताकि वह मेरे हैकल की जो उनके बीच है नापाक करने की वजह से अपनी नजासत में हलाक न हों।” ");
INSERT INTO urd_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","उसके लिए जिसे जिरयान का मर्ज़ हो, और उसके लिए जिस की धात बहती हो, और वह उसकी वजह से नापाक हो जाए, ");
INSERT INTO urd_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","और उसके लिए जो हैज़ से हो, और उस मर्द और 'औरत के लिए जिनको जिरयान का मर्ज़ हो, और उस मर्द के लिए जो नापाक 'औरत के साथ सुहबत करे शरा' यही है। ");
INSERT INTO urd_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","और हारून के दो बेटों की वफ़ात के बाद जब वह ख़ुदावन्द के नज़दीक आए और मर गए। ");
INSERT INTO urd_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ख़ुदावन्द मूसा से हम कलाम हुआ; और ख़ुदावन्द ने मूसा से कहा, अपने भाई हारून से कह कि वह हर वक़्त पर्दे के अन्दर के पाकतरीन मक़ाम में सरपोश के पास जो सन्दूक के ऊपर है न आया करे, ताकि वह मर न जाए; क्यूँकि मैं सरपोश पर बादल में दिखाई दूँगा। ");
INSERT INTO urd_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","और हारून पाकतरीन मक़ाम में इस तरह आए कि ख़ता की क़ुर्बानी के लिए एक बछड़ा और सोख़्तनी क़ुर्बानी के लिए एक मेंढा लाए। ");
INSERT INTO urd_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","और वह कतान का पाक कुरता पहने, और उसके तन पर कतान का पाजामा हो, और कतान के कमरबन्द से उसकी कमर कसी हुई हो, और कतान ही का 'अमामा उसके सिर पर बँधा हो; यह पाक लिबास हैं और वह इन को पानी से नहा कर पहने ");
INSERT INTO urd_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","और बनी — इस्राईल की जमा'अत से ख़ता की क़ुर्बानी के लिए दो बकरे और सोख़्तनी क़ुर्बानी के लिए एक मेंढा ले। ");
INSERT INTO urd_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","और हारून ख़ता की क़ुर्बानी के बछड़े को जो उसकी तरफ़ से है पेश कर अपने और अपने घर के लिए कफ़्फ़ारा दे। ");
INSERT INTO urd_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","फिर उन दोनों बकरों को लेकर उन को ख़ेमा — ए — इजितमा'अ के दरवाज़े पर ख़ुदावन्द के सामने खड़ा करे। ");
INSERT INTO urd_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","और हारून उन दोनों बकरों पर चिट्ठियाँ डाले, एक चिट्ठी ख़ुदावन्द के लिए और दूसरी 'अज़ाज़ेल के लिए हो। ");
INSERT INTO urd_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","और जिस बकरे पर ख़ुदावन्द के नाम की चिट्ठी निकले उसे हारून लेकर ख़ता की क़ुर्बानी के लिए अदा करे; ");
INSERT INTO urd_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","लेकिन जिस बकरे पर 'अज़ाज़ेल के नाम की चिट्ठी निकले वह ख़ुदावन्द के सामने ज़िन्दा खड़ा किया जाए, ताकि उससे कफ़्फ़ारा दिया जाए और वह 'अज़ाज़ेल के लिए वीराने में छोड़ दिया जाए। ");
INSERT INTO urd_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“और हारून ख़ता की क़ुर्बानी के बछड़े की जो उस की तरफ़ से है, आगे लाकर अपने और अपने घर के लिए कफ़्फ़ारा दे, और उस बछड़े को जो उस की तरफ़ से ख़ता की क़ुर्बानी के लिए है ज़बह करे। ");
INSERT INTO urd_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","और वह एक ख़ुशबूदान को ले जिसमें ख़ुदावन्द के मज़बह पर की आग के अंगारे भर हों और अपनी मुठ्ठियाँ बारीक ख़ुशबूदार ख़ुशबू से भर ले और उसे पर्दे के अन्दर लाए ");
INSERT INTO urd_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","और उस ख़ुशबू को ख़ुदावन्द के सामने आग में डाले, ताकि ख़ुशबू का धुआँ सरपोश को जो शहादत के सन्दूक के ऊपर है छिपा ले, कि वह हलाक न हो। ");
INSERT INTO urd_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","फिर वह उस बछड़े का कुछ ख़ून लेकर उसे अपनी उँगली से पूरब की तरफ़ सरपोश के ऊपर छिड़के, और सरपोश के आगे भी कुछ ख़ून अपनी उँगली से सात बार छिड़के। ");
INSERT INTO urd_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","फिर वह ख़ता की क़ुर्बानी के उस बकरे को ज़बह करे जो जमा'अत की तरफ़ से है और उसके ख़ून को पर्दे के अन्दर लाकर जो कुछ उसने बछड़े के ख़ून से किया था वही इससे भी करे, और उसे सरपोश के ऊपर और उसके सामने छिड़के। ");
INSERT INTO urd_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","और बनी — इस्राईल की सारी नापाकियों, और गुनाहों, और ख़ताओं की वजह से पाकतरीन मक़ाम के लिए कफ़्फ़ारा दे; और ऐसा ही वह ख़ेमा — ए — इजितमा'अ के लिए भी करे जो उनके साथ उन की नापाकियों के बीच रहता है। ");
INSERT INTO urd_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","और जब वह कफ़्फ़ारा देने को पाकतरीन मक़ाम के अन्दर जाए, तो जब तक वह अपने और अपने घराने और बनी — इस्राईल की सारी जमा'अत के लिए कफ़्फ़ारा देकर बाहर न आ जाए उस वक़्त तक कोई आदमी ख़ेमा — ए — इजितमा'अ के अन्दर न रहे ");
INSERT INTO urd_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","फिर वह निकल कर उस मज़बह के पास जो ख़ुदावन्द के सामने है जाए और उसके लिए कफ़्फ़ारा दे, और उस बछड़े और बकरे का थोड़ा — थोड़ा सा ख़ून लेकर मज़बह के सींगों पर चारों तरफ़ लगाए; ");
INSERT INTO urd_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","और कुछ ख़ून उसके ऊपर सात बार अपनी उँगली से छिड़के और उसे बनी — इस्राईल की नापाकियों से पाक और पाक करे। ");
INSERT INTO urd_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","और जब वह पाकतरीन मक़ाम और ख़ेमा — ए — इजितमा'अ और मज़बह के लिए कफ़्फ़ारा दे चुके तो उस ज़िन्दा बकरे को आगे लाए; ");
INSERT INTO urd_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","और हारून अपने दोनों हाथ उस ज़िन्दा बकरे के सिर पर रख कर उसके ऊपर बनी — इस्राईल की सब बदकारियों, और उनके सब गुनाहों, और ख़ताओं का इक़रार करे और उन को उस बकरे के सिर पर धर कर उसे किसी शख़्स के हाथ जो इस काम के लिए तैयार ही वीरान में भिजवा दे। ");
INSERT INTO urd_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","और वह बकरा उनकी सब बदकारियाँ अपने ऊपर लादे हुए किसी वीरान में ले जाएगा, इसलिए वह उस बकरे को वीराने में छोड़े दे। ");
INSERT INTO urd_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“फिर हारून ख़ेमा — ए — इजितमा'अ में आकर कतान के सारे लिबास को जिसे उसने पाकतरीन मक़ाम में जाते वक़्त पहना था उतारे और उसकी वहीं रहने दे। ");
INSERT INTO urd_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","फिर वह किसी पाक जगह में पानी से ग़ुस्ल करके अपने कपड़े पहन ले, और बाहर आ कर अपनी सोख़्तनी क़ुर्बानी और जमा'त की सोख़्तनी क़ुर्बानी पेश करे और अपने लिए और जमा'अत के लिए कफ़्फ़ारा दे। ");
INSERT INTO urd_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","और ख़ता की क़ुर्बानी की चर्बी को मज़बह पर जलाए। ");
INSERT INTO urd_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","और जो आदमी बकरे को 'अज़ाज़ेल के लिए छोड़ कर आए, वह अपने कपड़े धोए और पानी से नहाए, इसके बाद वह लश्करगाह में दाख़िल हो। ");
INSERT INTO urd_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","और ख़ता की क़ुर्बानी के बछड़े को और ख़ता की क़ुर्बानी के बकरे को जिन का ख़ून पाकतरीन मक़ाम में कफ़्फ़ारे के लिए पहुँचाया जाए, उन को वह लश्करगाह से बाहर ले जाएँ, और उनकी खाल और गोश्त और फुज़लात को आग में जला दें: ");
INSERT INTO urd_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","और जो उन को जलाए वह अपने कपड़े धोए और पानी से ग़ुस्ल करे, उसके बाद वह लश्करगाह में दाख़िल हो। ");
INSERT INTO urd_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“और यह तुम्हारे लिए एक हमेशा का क़ानून हो कि सातवें महीने की दसवीं तारीख़ को तुम अपनी अपनी जान को दुख देना, और उस दिन कोई चाहे वह देसी हो या परदेसी जो तुम्हारे बीच बूद — ओ — बाश रखता हो किसी तरह का काम न करे; ");
INSERT INTO urd_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","क्यूँकि उस रोज़ तुम्हारे लिए तुम को पाक करने के लिए कफ़्फ़ारा दिया जाएगा, इसलिए तुम अपने सब गुनाहों से ख़ुदावन्द के सामने पाक ठहरोगे। ");
INSERT INTO urd_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","यह तुम्हारे लिए ख़ास आराम का सबत होगा। तुम उस दिन अपनी अपनी जान को दुख देना; यह हमेशा का क़ानून है। ");
INSERT INTO urd_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","और जो अपने बाप की जगह काहिन होने के लिए मसह और मख़्सूस किया जाए, वह काहिन कफ़्फ़ारा दिया करे; या'नी कतान के पाक लिबास को पहनकर ");
INSERT INTO urd_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","वह हैकल के लिए कफ़्फ़ारा दे, और ख़ेमा — ए — इजितमा'अ और मज़बह के लिए कफ़्फ़ारा दे, और काहिनों और जमा'अत के सब लोगों के लिए कफ़्फ़ारा दे। ");
INSERT INTO urd_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","इसलिए यह तुम्हारे लिए एक हमेशा क़ानून हो कि तुम बनी — इस्राईल के लिए साल में एक दफ़ा' उनके सब गुनाहों का कफ़्फ़ारा दो।” और उसने जैसा ख़ुदावन्द ने मूसा को हुक्म दिया था वैसा ही किया। ");
INSERT INTO urd_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","फिर ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","'हारून और उसके बेटों से और सब बनी — इस्राईल से कह कि ख़ुदावन्द ने यह हुक्म दिया है कि ");
INSERT INTO urd_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","इस्राईल के घराने का जो कोई शख़्स बैल या बर्रे या बकरे को चाहे लश्करगाह में या लश्करगाह के बाहर ज़बह कर के ");
INSERT INTO urd_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","उसे ख़ेमा — ए — इजितमा'अ के दरवाज़े पर, ख़ुदावन्द के घर के आगे, ख़ुदावन्द के सामने चढ़ाने को न ले जाए, उस शख़्स पर ख़ून का इल्ज़ाम होगा कि उसने ख़ून किया है; और वह शख़्स अपने लोगों में से काट डाला जाए। ");
INSERT INTO urd_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","इससे मक़सूद यह है कि बनी — इस्राईल अपनी क़ुर्बानियाँ, जिनको वह खुले मैदान में ज़बह करते हैं, उन्हें ख़ुदावन्द के सामने ख़ेमा — ए — इजितमा'अ के दरवाज़े पर काहिन के पास लाएँ और उनको ख़ुदावन्द के सामने सलामती के ज़बीहों के तौर पर पेश करें, ");
INSERT INTO urd_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","और काहिन उस ख़ून को ख़ेमा — ए — इजितमा'अ के दरवाज़े पर ख़ुदावन्द के मज़बह के ऊपर छिड़के और चर्बी को जलाए, ताकि ख़ुदावन्द के लिए राहतअंगेज़ ख़ुशबू हो। ");
INSERT INTO urd_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","और आइन्दा कभी वह उन बकरों के लिए जिनके पैरौ होकर वह ज़िनाकार ठहरें हैं, अपनी क़ुर्बानियाँ न पेश करे। उनके लिए नसल — दर — नसल यह हमेशा क़ानून होगा। ");
INSERT INTO urd_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“इसलिए तू उन से कह दे कि इस्राईल के घराने का या उन परदेसियों में से जो उनमें क़याम करते हैं जो कोई सोख़्तनी क़ुर्बानी या कोई ज़बीहा पेश कर, ");
INSERT INTO urd_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","उसे ख़ेमा — ए — इजितमा'अ के दरवाज़े पर ख़ुदावन्द के सामने चढ़ाने को न लाए; वह अपने लोगों में से काटडाला जाए। ");
INSERT INTO urd_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“और इस्राईल के घराने का या उन परदेसियों में से जो उनमें क़याम करते हैं जो कोई किसी तरह का ख़ून खाए, मैं उस ख़ून खाने वाले के खिलाफ़ हूँगा और उसे उसके लोगों में से काट डालूँगा। ");
INSERT INTO urd_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","क्यूँकि जिस्म की जान ख़ून में है; और मैंने मज़बह पर तुम्हारी जानों के कफ़्फ़ारे के लिए उसे तुम को दिया है कि उससे तुम्हारी जानों के लिए कफ़्फ़ारा हो; क्यूँकि जान रखने ही की वजह से ख़ून कफ़्फ़ारा देता है। ");
INSERT INTO urd_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","इसीलिए मैंने बनी — इस्राईल से कहा है कि तुम में से कोई शख़्स ख़ून कभी न खाए, और न कोई परदेसी जो तुम में क़याम करता हो कभी ख़ून को खाए। ");
INSERT INTO urd_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“और बनी — इस्राईल में से या उन परदेसियों में से जो उनमें क़याम करते हैं जो कोई शिकार में ऐसे जानवर या परिन्दे को पकड़े जिसका खाना ठीक है, तो वह उसके ख़ून को निकाल कर उसे मिट्टी से ढॉक दे। ");
INSERT INTO urd_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","क्यूँकि जिस्म की जान जो है वह उस का ख़ून है, जो उसकी जान के साथ एक है। इसीलिए मैंने बनी — इस्राईल को हुक्म किया है कि तुम किसी क़िस्म के जानवर का ख़ून न खाना, क्यूँकि हर जानवर की जान उसका ख़ून ही है; जो कोई उसे खाए वह काट डाला जाएगा। ");
INSERT INTO urd_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","और जो शख़्स मुरदार को या दरिन्दे के फाड़े हुए जानवर को खाए, वह चाहे देसी हो या परदेसी अपने कपड़े धोए और पानी से ग़ुस्ल करे और शाम तक नापाक रहे; तब वह पाक होगा। ");
INSERT INTO urd_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","लेकिन अगर वह उनको न धोए और न ग़ुस्ल करे, तो उसका गुनाह उसी के सिर लगेगा।” ");
INSERT INTO urd_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","फिर ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","बनी — इस्राईल से कह कि मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urd_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","तुम मुल्क — ए — मिस्र के से काम जिसमें तुम रहते थे, न करना और मुल्क — ए — कना'न के से काम भी जहाँ मैं तुम्हें लिए जाता हूँ, न करना और न उनकी रस्मों पर चलना। ");
INSERT INTO urd_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","तुम मेरे हुक्मों पर 'अमल करना और मेरे क़ानून को मान कर उन पर चलना। मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urd_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","इसलिए तुम मेरे आईन और अहकाम मानना, जिन पर अगर कोई 'अमल करे तो वह उन ही की बदौलत ज़िन्दा रहेगा। मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“तुम में से कोई अपनी किसी क़रीबी रिश्तेदार के पास उसके बदन को बे — पर्दा करने के लिए न जाए। मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","तू अपनी माँ के बदन को जो तेरे बाप का बदन है बे — पर्दा न करना; क्यूँकि वह तेरी माँ है, तू उसके बदन को बे — पर्दा न करना। ");
INSERT INTO urd_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","तू अपने बाप की बीवी के बदन को बे — पर्दा न करना, क्यूँकि वह तेरे बाप का बदन है। ");
INSERT INTO urd_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","तू अपनी बहन के बदन को, चाहे वह तेरे बाप की बेटी हो चाहे तेरी माँ की और चाहे वह घर में पैदा हुई हो चाहे और कहीं, बे — पर्दा न करना। ");
INSERT INTO urd_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","तू अपनी पोती या नवासी के बदन को बे — पर्दा न करना क्यूँकि उनका बदन तो तेरा ही बदन है। ");
INSERT INTO urd_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","तेरे बाप की बीवी की बेटी, जो तेरे बाप से पैदा हुई है, तेरी बहन है; तू उसके बदन को बे — पर्दा न करना। ");
INSERT INTO urd_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","तू अपनी फूफी के बदन को बे — पर्दा न करना, क्यूँकि वह तेरे बाप की क़रीबी रिश्तेदार है। ");
INSERT INTO urd_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","तू अपनी ख़ाला के बदन को बेपर्दा न करना, क्यूँकि वह तेरी माँ की क़रीबी रिश्तेदार है। ");
INSERT INTO urd_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","तू अपने बाप के भाई के बदन को बे — पर्दा न करना, या'नी उस की बीवी के पास न जाना, वह तेरी चची है। ");
INSERT INTO urd_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","तू अपनी बहू के बदन को बे — पर्दा न करना, क्यूँकि वह तेरे बेटे की बीवी है, इसलिए तू उसके बदन को बे — पर्दा न करना। ");
INSERT INTO urd_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","तू अपनी भावज के बदन को बे — पर्दा न करना, क्यूँकि वह तेरे भाई का बदन है। ");
INSERT INTO urd_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","तू किसी 'औरत और उसकी बेटी दोनों के बदन को बेपर्दा न करना; और न तू उस 'औरत की पोती या नवासी से ब्याह कर के उस में से किसी के बदन को बे — पर्दा करना, क्यूँकि वह दोनों उस 'औरत की क़रीबी रिश्तेदार हैं: यह बड़ी ख़बासत है। ");
INSERT INTO urd_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","तू अपनी साली से ब्याह कर के उसे अपनी बीवी की सौतन न बनाना, कि दूसरी के जीते जी उसके बदन को भी बेपर्दा करे। ");
INSERT INTO urd_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“और तू 'औरत के पास जब तक वह हैज़ की वजह से नापाक है, उसके बदन को बे — पर्दा करने के लिए न जाना। ");
INSERT INTO urd_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","और तू अपने को नजिस करने के लिए अपने पड़ोसी की बीवी से सुहबत न करना। ");
INSERT INTO urd_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","तू अपनी औलाद में से किसी को मोलक की ख़ातिर आग में से पेश करने के लिए न देना, और न अपने ख़ुदा के नाम को नापाक ठहराना। मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","तू मर्द के साथ सुहबत न करना जैसे 'औरत से करता है; यह बहुत मकरूह काम है। ");
INSERT INTO urd_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","तू अपने को नजिस करने के लिए किसी जानवर से सुहबत न करना, और न कोई 'औरत किसी जानवर से हम — सुहबत होने के लिए उसके आगे खड़ी हो; क्यूँकि यह औंधी बात है। ");
INSERT INTO urd_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“तुम इन कामों में से किसी में फँस कर आलूदा न हो जाना, क्यूँकि जिन क़ौमों को मैं तुम्हारे आगे से निकालता हूँ वह इन सब कामों की वजह से आलूदा हैं। ");
INSERT INTO urd_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","और उन का मुल्क भी आलूदा हो गया है; इसलिए मैं उसकी बदकारी की सज़ा उसे देता हूँ, ऐसा कि वह अपने बाशिन्दों को उगले देता है। ");
INSERT INTO urd_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","लिहाज़ा तुम मेरे आईन और अहकाम को मानना और तुम में से कोई, चाहे वह देसी हो या परदेसी जो तुम में क़याम रखता हो, इन मकरूहात में से किसी काम को न करे; ");
INSERT INTO urd_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","क्यूँकि उस मुल्क के बाशिंदों ने जो तुमसे पहले थे यह सब मकरूह काम किये हैं और मुल्क आलूदा हो गया है। ");
INSERT INTO urd_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","इसलिए ऐसा न हो कि जिस तरह उस मुल्क ने उस क़ौम को जो तुमसे पहले वहाँ थी उगल दिया, उसी तरह तुम को भी जब तुम उसे आलूदा करो तो उगल दे। ");
INSERT INTO urd_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","क्यूँकि जो इन मकरूह कामों में से किसी को करेगा, वह अपने लोगों में से काट डाला जाएगा। ");
INSERT INTO urd_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","इसलिए मेरी शरी'अत को मानना, और यह मकरूह रस्में जो तुमसे पहले अदा की जाती थीं, इनमें से किसी को 'अमल में न लाना और इन में फँस कर आलूदा न हो जाना। मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ।” ");
INSERT INTO urd_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","फिर ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“बनी — इस्राईल की सारी जमा'अत से कह कि तुम पाक रहो; क्यूँकि मैं जो ख़ुदावन्द तुम्हारा ख़ुदा हूँ पाक हूँ ");
INSERT INTO urd_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","तुम में से हर एक अपनी माँ और अपने बाप से डरता रहे, और तुम मेरे सबतों को मानना; मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urd_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","तुम बुतों की तरफ़ रुजू' न होना, और न अपने लिए ढाले हुए मा'बूद बनाना; मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urd_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“और जब तुम ख़ुदावन्द के सामने सलामती के ज़बीहे पेश करो, तो उनको इस तरह पेश करना कि तुम मक़बूल हो। ");
INSERT INTO urd_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","और जिस दिन उसे पेश करो उस दिन और दूसरे दिन वह खाया जाए, और अगर तीसरे दिन तक कुछ बचा रह जाए तो वह आग में जला दिया जाए। ");
INSERT INTO urd_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","और अगर वह ज़रा भी तीसरे दिन खाया जाए, तो मकरूह ठहरेगा और मक़बूल न होगा; ");
INSERT INTO urd_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","बल्कि जो कोई उसे खाए उसका गुनाह उसी के सिर लगेगा, क्यूँकि उसने ख़ुदावन्द की पाक चीज़ को नजिस किया; इसलिए वह शख़्स अपने लोगों में से काट डाला जाएगा। ");
INSERT INTO urd_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“और जब तुम अपनी ज़मीन की पैदावार की फ़स्ल काटो, तो अपने खेत के कोने — कोने तक पूरा — पूरा न काटना और न कटाई की गिरी — पड़ी बालों को चुन लेना। ");
INSERT INTO urd_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","और तू अपने अंगूरिस्तान का दाना — दाना न तोड़ लेना, और न अपने अंगूरिस्तान के गिरे हुए दानों को जमा' करना; उनको ग़रीबों और मुसाफ़िरों के लिए छोड़ देना। मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urd_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“तुम चोरी न करना और न दग़ा देना और न एक दूसरे से झूट बोलना। ");
INSERT INTO urd_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","और तुम मेरा नाम लेकर झूटी क़सम न खाना जिससे तू अपने ख़ुदा के नाम को नापाक ठहराए; मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“तू अपने पड़ोसी पर न ज़ुल्म करना, न उसे लूटना। मज़दूर की मज़दूरी तेरे पास सारी रात सुबह तक रहने न पाए। ");
INSERT INTO urd_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","तू बहरे को न कोसना, और न अन्धे के आगे ठोकर खिलाने की चीज़ को धरना, बल्कि अपने ख़ुदा से डरना। मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“तुम फ़ैसले में नारास्ती न करना, न तो ग़रीब की रि'आयत करना और न बड़े आदमी का लिहाज़; बल्कि रास्ती के साथ अपने पड़ोसी का इन्साफ़ करना। ");
INSERT INTO urd_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","तू अपनी क़ौम में इधर — उधर लुतरापन न करते फिरना, और न अपने पड़ोसी का ख़ून करने पर आमादा होना; मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","तू अपने दिल में अपने भाई से बुग्ज़ न रखना; और अपने पड़ोसी को ज़रूर डाँटते भी रहना, ताकि उसकी वजह से तेरे सिर गुनाह न लगे। ");
INSERT INTO urd_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","तू इन्तक़ाम न लेना, और न अपनी क़ौम की नसल से कीना रखना, बल्कि अपने पड़ोसी से अपनी तरह मुहब्बत करना; मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“तू मेरी शरी'अतों को माननाः तू अपने चौपायों को ग़ैर जिन्स से भरवाने न देना, और अपने खेत में दो क़िस्म के बीज एक साथ न बोना, और न तुझ पर दो क़िस्म के मिले जुले तार का कपड़ा हो। ");
INSERT INTO urd_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“अगर कोई ऐसी 'औरत से सुहबत करे जो लौंडी और किसी शख़्स की मंगेतर हो, और न तो उसका फ़िदिया ही दिया गया हो और न वह आज़ाद की गई हो, तो उन दोनों की सज़ा मिले लेकिन वह जान से मारे न जाएँ इसलिए कि वह 'औरत आज़ाद न थी। ");
INSERT INTO urd_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","और वह आदमी अपने जुर्म की क़ुर्बानी के लिए ख़ेमा — ए — इजितमा'अ के दरवाज़े पर ख़ुदावन्द के सामने एक मेंढा लाए कि वह उसके जुर्म की क़ुर्बानी हो। ");
INSERT INTO urd_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","और काहिन उसके जुर्म की क़ुर्बानी के मेंढे से उसके लिए ख़ुदावन्द के सामने कफ़्फ़ारा दे, तब जो ख़ता उसने की है वह उसे मु'आफ़ की जाएगी। ");
INSERT INTO urd_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","और जब तुम उस मुल्क में पहुँचकर क़िस्म — क़िस्म के फल के दरख़्त लगाओ तो तुम उनके फल को जैसे नामख़्तून समझना वह तुम्हारे लिए तीन बरस तक नामख़्तून के बराबर हों और खाए न जाएँ। ");
INSERT INTO urd_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","और चौथे साल उनका सारा फल ख़ुदावन्द की तम्जीद करने के लिए पाक होगा। ");
INSERT INTO urd_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","तब पाँचवे साल से उनका फल खाना ताकि वह तुम्हारे लिए इफ़रात के साथ पैदा हों। मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urd_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“तुम किसी चीज़ को ख़ून के साथ न खाना। और न जादू मंतर करना, न शगुन निकालना। ");
INSERT INTO urd_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","तुम अपने अपने सिर के गोशों को बाल काट कर गोल न बनाना, और न तू अपनी दाढ़ी के कोनों को बिगाड़ना। ");
INSERT INTO urd_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","तुम मुर्दों की वजह से अपने जिस्म को ज़ख़्मी न करना, और न अपने ऊपर कुछ गुदवाना। मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","तू अपनी बेटी को कस्बी बना कर नापाक न होने देना, कहीं ऐसा न हो कि मुल्क में रण्डी बाज़ी फैल जाए और सारा मुल्क बदकारी से भर जाए। ");
INSERT INTO urd_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","तुम मेरे सबतों को मानना और मेरे हैकल की ता'ज़ीम करना; मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","जो जिन्नात के यार हैं और जो जादूगर हैं, तुम उनके पास न जाना और न उनके तालिब होना कि वह तुम को नजिस बना दें। मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urd_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“जिनके सिर के बाल सफ़ेद हैं, तुम उनके सामने उठ खड़े होना और बड़े — बूढ़े का अदब करना, और अपने ख़ुदा से डरना। मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","'और अगर कोई परदेसी तेरे साथ तुम्हारे मुल्क में क़याम करता हो तो तुम उसे आज़ार न पहुँचाना; ");
INSERT INTO urd_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","बल्कि जो परदेसी तुम्हारे साथ रहता हो उसे देसी की तरह समझना, बल्कि तू उससे अपनी तरह मुहब्बत करना; इसलिए कि तुम मुल्क — ए — मिस्र में परदेसी थे। मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urd_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“तुम इन्साफ़, और पैमाइश, और वज़न, और पैमाने में नारास्ती न करना। ");
INSERT INTO urd_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ठीक तराजू, ठीक तौल बाट पूरा ऐफ़ा और पूरा हीन रखना। जो तुम को मुल्क — ए — मिस्र से निकाल कर लाया मैं ही हूँ, ख़ुदावन्द तुम्हारा ख़ुदा। ");
INSERT INTO urd_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","इसलिए तुम मेरे सब आईन और सब अहकाम मानना और उन पर 'अमल करना; मैं ख़ुदावन्द हूँ।” ");
INSERT INTO urd_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","फिर ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“तू बनी — इस्राईल से यह भी कह दे कि बनी — इस्राईल में से या उन परदेसियों में से जो इस्राईलियों के बीच क़याम करते हैं, जो कोई शख़्स अपनी औलाद में से किसी की मोलक की नज़्र करे वह ज़रूर जान से मारा जाए; अहल — ए — मुल्क उसे संगसार करें। ");
INSERT INTO urd_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","और मैं भी उस शख़्स का मुख़ालिफ़ हूँगा और उसे उसके लोगों में से काट डालेंगा, इसलिए कि उस ने अपनी औलाद को मोलक की नज़्र कर के मेरे हैकल और मेरे पाक नाम को नापाक ठहराया। ");
INSERT INTO urd_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","और अगर उस वक़्त जब वह अपनी औलाद में से किसी की मोलक की नज़्र करे, अहल — ए — मुल्क उस शख़्स की तरफ़ से चश्मपोशी कर के उसे जान से न मारें ");
INSERT INTO urd_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","तो मैं ख़ुद उस शख़्स का और उसके घराने का मुख़ालिफ़ हो कर उसको और उन सभों को जो उसकी पैरवी में ज़िनाकार बनें और मोलक के साथ ज़िना करें, उनकी क़ौम में से काट डालूँगा। ");
INSERT INTO urd_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","'और जो शख़्स जिन्नात के यारों और जादूगरों के पास जाए कि उनकी पैरवी में ज़िना करे, मैं उसका मुख़ालिफ़ हूँगा और उसे उस की क़ौम में से काट डालूँगा। ");
INSERT INTO urd_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","इसलिए तुम अपने आप को पाक करो और पाक रहो, मैं ख़ुदावन्द तुम्हारा ख़दा हूँ। ");
INSERT INTO urd_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","और तुम मेरे क़ानून को मानना और उस पर 'अमल करना। मैं ख़ुदावन्द हूँ जो तुम को पाक करता हूँ। ");
INSERT INTO urd_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","और जो कोई अपने बाप या अपनी माँ पर ला'नत करे वह ज़रूर जान से मारा जाए, उसने अपने बाप या माँ पर ला'नत की है, इसलिए उस का ख़ून उसी की गर्दन पर होगा। ");
INSERT INTO urd_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","'और जो शख़्स दूसरे की बीवी से या'नी अपने पड़ोसी की बीवी से ज़िना करे, वह ज़ानी और ज़ानिया दोनों ज़रूर जान से मार दिए जाएँ। ");
INSERT INTO urd_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","और जो शख़्स अपनी सौतेली माँ से सुहबत करे उसने अपने बाप के बदन को बे — पर्दा किया, वह दोनों ज़रूर जान से मारे जाएँ, उन का ख़ून उन ही की गर्दन पर होगा। ");
INSERT INTO urd_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","और अगर कोई शख़्स अपनी बहू से सुहबत करे तो वह दोनों ज़रूर जान से मारे जायें उन्होंने औंधी बात की है उनका ख़ून उन ही की गर्दन पर होगा। ");
INSERT INTO urd_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","और अगर कोई मर्द से सुहबत करे जैसे 'औरत से करते हैं तो उन दोनों ने बहुत मकरूह काम किया है, इसलिए वह दोनों ज़रूर जान से मारे जाएँ, उनका ख़ून उनही की गर्दन पर होगा। ");
INSERT INTO urd_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","और अगर कोई शख़्स अपनी बीवी और अपनी सास दोनों को रख्खे तो यह बड़ी ख़बासत है, इसलिए वह आदमी और वह 'औरतें तीनों के तीनों जला दिए जाएँ ताकि तुम्हारे बीच ख़बासत न रहे; ");
INSERT INTO urd_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","और अगर कोई मर्द किसी जानवर से जिमा'अ करे तो वह ज़रूर जान से मारा जाए और तुम उस जानवर को भी मार डालना। ");
INSERT INTO urd_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","और अगर कोई 'औरत किसी जानवर के पास जाए और उससे हम सुहबत हो तो उस 'औरत और जानवर दोनों को मार डालना, वह ज़रूर जान से मारे जाएँ; उनका ख़ून उन ही की गर्दन पर होगा। ");
INSERT INTO urd_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","'और अगर कोई मर्द अपनी बहन को जो उसके बाप की या उसकी माँ की बेटी हो, लेकर उसका बदन देखे और उसकी बहन उसका बदन देखे, तो यह शर्म की बात है; वह दोनों अपनी क़ौम के लोगों की आँखों के सामने क़त्ल किए जाएँ, उसने अपनी बहन के बदन को बे — पर्दा किया, उसका गुनाह उसी के सिर लगेगा। ");
INSERT INTO urd_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","और अगर मर्द उस 'औरत से जो कपड़ों से हो सुहबत कर के उसके बदन को बे — पर्दा करे, तो उसने उसका चश्मा खोला और उस 'औरत ने अपने ख़ून का चश्मा खुलवाया। इसलिए वह दोनों अपनी क़ौम में से काट डाले जाएँ। ");
INSERT INTO urd_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","और तू अपनी ख़ाला या फूफी के बदन को बे — पर्दा न करना, क्यूँकि जो ऐसा करे उसने अपनी क़रीबी रिश्तेदार को बे — पर्दा किया; इसलिए उन दोनों का गुनाह उन ही के सिर लगेगा। ");
INSERT INTO urd_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","और अगर कोई अपनी चची या ताई से सुहबत करे तो उसने अपने चचा या ताऊ के बदन को बे — पर्दा किया; इसलिए उनका गुनाह उनके सिर लगेगा, वह बे — औलाद मरेंगे। ");
INSERT INTO urd_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","अगर कोई शख़्स अपने भाई की बीवी को रख्खें तो यह नजासत है, उसने अपने भाई के बदन को बे — पर्दा किया है; वह बे — औलाद रहेंगे। ");
INSERT INTO urd_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","इसलिए तुम मेरे सब आईन और अहकाम मानना और उन पर 'अमल करना, ताकि वह मुल्क जिसमें मैं तुम को बसाने को लिए जाता हूँ तुम को उगल न दे। ");
INSERT INTO urd_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","तुम उन क़ौमों के दस्तूरों पर जिनको मैं तुम्हारे आगे से निकालता हूँ मत चलना, क्यूँकि उन्होंने यह सब काम किए इसीलिए मुझे उन से नफ़रत हो गई। ");
INSERT INTO urd_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","लेकिन मैंने तुमसे कहा है कि तुम उनके मुल्क के वारिस होगे, और मैं तुम को वह मुल्क जिस में दूध और शहद बहता है तुम्हारी मिल्कियत होने के लिए दूँगा। मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ, जिसने तुम को और क़ौमों से अलग किया है। ");
INSERT INTO urd_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","इसलिए तुम पाक और नापाक चौपायों में, और पाक और नापाक परिन्दों में फ़र्क़ करना, और तुम किसी जानवर या परिन्दे या ज़मीन पर के रेंगनेवाले जानदार से, जिनको मैंने तुम्हारे लिए नापाक ठहराकर अलग किया है अपने आप को मकरूह न बना लेना। ");
INSERT INTO urd_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","और तुम मेरे लिए पाक बने रहना, क्यूँकि मैं जो ख़ुदावन्द हूँ पाक हूँ; और मैंने तुम को और क़ौमों से अलग किया है ताकि तुम मेरे ही रहो। ");
INSERT INTO urd_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","और वह मर्द या 'औरत जिसमें जिन्न हो या वह जादूगर हो तो वह ज़रूर जान से मारा जाए, ऐसों को लोग संगसार करें; उनका ख़ून उन ही की गर्दन पर होगा।” ");
INSERT INTO urd_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","और ख़ुदावन्द ने मूसा से कहा कि 'हारून के बेटों से जो काहिन हैं कह कि अपने क़बीले के मुर्दे की वजह से कोई अपने आप को नजिस न कर ले। ");
INSERT INTO urd_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","अपने क़रीबी रिश्तेदारों की वजह से जैसे अपनी माँ की वजह से, और अपने बाप की वजह से, और अपने बेटे — बेटी की वजह से, और अपने भाई की वजह से, ");
INSERT INTO urd_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","और अपनी सगी कुँवारी बहन की वजह से जिसने शौहर न किया हो, इन की ख़ातिर वह अपने को नजिस कर सकता है। ");
INSERT INTO urd_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","चूँकि वह अपने लोगों में सरदार है, इसलिए वह अपने आप को ऐसा आलूदा न करे कि नापाक हो जाए। ");
INSERT INTO urd_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","वह न अपने सिर उनकी ख़ातिर बीच से घुटवाएँ और न अपनी दाढ़ी के कोने मुण्डवाएँ, और न अपने को ज़ख़्मी करें। ");
INSERT INTO urd_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","वह अपने ख़ुदा के लिए पाक बने रहें और अपने ख़ुदा के नाम को बेहुरमत न करें, क्यूँकि वह ख़ुदावन्द की आतिशीन क़ुर्बानियाँ जो उनके ख़ुदा की गिज़ा है पेश करते हैं; इसलिए वह पाक रहें। ");
INSERT INTO urd_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","वह किसी फ़ाहिशा या नापाक 'औरत से ब्याह न करें, और न उस 'औरत से ब्याह करें जिसे उसके शौहर ने तलाक़ दी हो; क्यूँकि काहिन अपने ख़ुदा के लिए पाक है। ");
INSERT INTO urd_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","तब तू काहिन को पाक जानना क्यूँकि वह तेरे ख़ुदा की गिज़ा पेश करता है; इसलिए वह तेरी नज़र में पाक ठहरे, क्यूँकि मैं ख़ुदावन्द जो तुम को पाक करता हूँ क़ुद्दूस हूँ। ");
INSERT INTO urd_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","और अगर काहिन की बेटी फ़ाहिशा बनकर अपने आप को नापाक करे तो वह अपने बाप को नापाक ठहराती है, वह 'औरत आग में जलाई जाए। ");
INSERT INTO urd_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","और वह जो अपने भाइयों के बीच सरदार काहिन हो, जिसके सिर पर मसह करने का तेल डाला गया और जो पाक लिबास पहनने के लिए मख़्सूस किया गया, वह अपने सिर के बाल बिखरने न दे और अपने कपड़े न फाड़े। ");
INSERT INTO urd_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","वह किसी मुर्दे के पास न जाए, और न अपने बाप या माँ की ख़ातिर अपने आप को नजिस करे। ");
INSERT INTO urd_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","और वह हैकल के बाहर भी न निकले और न अपने ख़ुदा के हैकल को बेहुरमत करे, क्यूँकि उसके ख़ुदा के मसह करने के तेल का ताज उस पर है; मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","और वह कुँवारी 'औरत से ब्याह करे; ");
INSERT INTO urd_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","जो बेवा या मुतल्लक़ा या नापाक 'औरत या फ़ाहिशा हो, उनसे वह ब्याह न करे बल्कि वह अपनी ही क़ौम की कुँवारी को ब्याह ले। ");
INSERT INTO urd_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","और वह अपने तुख़्म को अपनी क़ौम में नापाक न ठहराए, क्यूँकि मैं ख़ुदावन्द हूँ जो उसे पाक करता हूँ। ");
INSERT INTO urd_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","फिर ख़ुदावन्द ने मूसा से कहा कि, ");
INSERT INTO urd_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“हारून से कह दे कि तेरी नसल में नसल — दर — नसल अगर कोई किसी तरह का 'ऐब रखता हो, तो वह अपने ख़ुदा की गिज़ा पेश करने को नज़दीक न आए; ");
INSERT INTO urd_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","चाहे कोई हो जिसमें 'ऐब हो वह नज़दीक न आए चाहे वह अन्धा हो या लंगड़ा, या नकचपटा हो, या ज़ाइद — उल — 'आज़ा, ");
INSERT INTO urd_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","या उसका पाँव टूटा हो, या हाथ टूटा हो ");
INSERT INTO urd_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","या वह कुबड़ा या बौना हो, या उसकी आँख में कुछ नुक्स हो, या खुजली भरा हो, या उसके पपड़ियाँ हों, या उसके खुसिए पिचके हों। ");
INSERT INTO urd_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","हारून काहिन की नसल में से कोई जो 'ऐबदार हो ख़ुदावन्द की आतिशी क़ुर्बानियाँ पेश करने को नज़दीक न आए, वह 'ऐबदार है; वह हरगिज़ अपने ख़ुदा की ग़िज़ा पेश करने को पास न आए। ");
INSERT INTO urd_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","वह अपने ख़ुदा की बहुत ही मुक़द्दस और पाक दोनों तरह की रोटी खाए, ");
INSERT INTO urd_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","लेकिन पर्दे के अन्दर दाख़िल न हो, न मज़बह के पास आए इसलिए कि वह 'ऐबदार है; कहीं ऐसा न हो कि वह मेरे पाक मक़ामों को बे — हुरमत करे, क्यूँकि मैं ख़ुदावन्द उनका पाक करने वाला हूँ।” ");
INSERT INTO urd_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","तब मूसा ने हारून और उसके बेटों और सब बनी — इस्राईल से यह बातें कहीं। ");
INSERT INTO urd_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“हारून और उसके बेटों से कह कि वह बनी — इस्राईल की पाक चीज़ों से जिनको वह मेरे लिए पाक करते हैं अपने आप को बचाए रख्खें, और मेरे पाक नाम को बे — हुरमत न करें; मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","उनको कह दे कि तुम्हारी नसल — दर — नसल जो कोई तुम्हारी नसल में से अपनी नापाकी की हालत में उन पाक चीज़ों के पास जाए, जिनको बनी — इस्राईल ख़ुदावन्द के लिए पाक करते हैं, वह शख़्स मेरे सामने से काट डाला जाएगा; मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","हारून की नसल में जो कोढ़ी, या जिरयान का मरीज़ हो वह जब तक पाक न हो जाए, पाक चीज़ों में से कुछ न खाए; और जो कोई ऐसी चीज़ को जो मुर्दे की वजह से नापाक हो गई है, या उस शख़्स की जिस की धात बहती हो छुए ");
INSERT INTO urd_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","या जो कोई किसी रेंगने वाले जानदार को जिसके छूने से वह नापाक हो सकता है, छुए या किसी ऐसे शख़्स को छुए जिससे उसकी नापाकी चाहे वह किसी क़िस्म की हो उसको भी लग सकती हो; ");
INSERT INTO urd_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","तो वह आदमी जो इनमें से किसी को छुए शाम तक नापाक रहेगा, और जब तक पानी से ग़ुस्ल न कर ले पाक चीज़ों में से कुछ न खाए; ");
INSERT INTO urd_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","और वह उस वक़्त पाक ठहरेगा जब आफ़ताब गुरूब हो जाए, इसके बाद वह पाक चीज़ों में से खाए, क्यूँकि यह उसकी ख़ुराक है। ");
INSERT INTO urd_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","और मुरदार या दरिन्दों के फाड़े हुए जानवर को खाने से वह अपने आप को नजिस न कर ले; मैं ख़ुदावन्द हूँ ");
INSERT INTO urd_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","इसलिए वह मेरी शरा' को माने, ऐसा न हो कि उस की वजह से उनके सिर गुनाह लगे और उसकी बेहुरमती करने की वजह से वह मर भी जाएँ, मैं ख़ुदावन्द उनका पाक करने वाला हूँ। ");
INSERT INTO urd_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","'कोई अजनबी पाक चीज़ की न खाने पाए चाहे वह काहिन ही के यहाँ ठहरा हो, या उसका नौकर हो तो भी वह कोई पाक चीज़ न खाए; ");
INSERT INTO urd_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","लेकिन वह जिसे काहिन ने अपने ज़र से ख़रीदा हो उसे खा सकता है, और वह जो उसके घर में पैदा हुए हों वह भी उसके खाने में से खाएँ। ");
INSERT INTO urd_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","अगर काहिन की बेटी किसी अजनबी से ब्याही गई हो, तो वह पाक चीज़ों की क़ुर्बानी में से कुछ न खाए। ");
INSERT INTO urd_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","लेकिन अगर काहिन की बेटी बेवा हो जाए, या मुतल्लक़ा हो और बे — औलाद हो, और लड़कपन के दिनों की तरह अपने बाप के घर में फिर आ कर रहे तो वह अपने बाप के खाने में से खाए; लेकिन कोई अजनबी उसे न खाए। ");
INSERT INTO urd_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","और अगर कोई अनजाने में पाक चीज़ को खा जाए तो वह उसके पाँचवें हिस्से के बराबर अपने पास से उस में मिला कर वह पाक चीज़ काहिन को दे ");
INSERT INTO urd_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","और वह बनी — इस्राईल की पाक चीज़ों को जिनको वह ख़ुदावन्द की नज़्र करते हों बेहुरमत करके, ");
INSERT INTO urd_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","उनके सिर उस गुनाह का जुर्म न लादें जो उनकी पाक चीज़ों को खाने से होगा; क्यूँकि मैं ख़ुदावन्द उनका पाक करने वाला हूँ।” ");
INSERT INTO urd_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“हारून और उसके बेटों और सब बनी — इस्राईल से कह कि इस्राईल के घराने का या उन परदेसियों में से जो इस्राईलियों के बीच रहते हैं, जो कोई शख़्स अपनी क़ुर्बानी लाए, चाहे वह कोई मिन्नत की क़ुर्बानी हो या रज़ा की क़ुर्बानी, जिसे वह सोख़्तनी क़ुर्बानी के तौर पर ख़ुदावन्द के सामने पेश करते हैं; ");
INSERT INTO urd_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","तो अपने मक़बूल होने के लिए तुम बैलों या बर्रों या बकरों में से बे — 'ऐब नर चढ़ाना। ");
INSERT INTO urd_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","और जिसमें 'ऐब हो उसे न अदा करना क्यूँकि वह तुम्हारी तरफ़ से मक़बूल न होगा। ");
INSERT INTO urd_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","और जो कोई अपनी मिन्नत पूरी करने के लिए या रज़ा की क़ुर्बानी के तौर पर गाय, बैल या भेड़ बकरी में से सलामती का ज़बीहा ख़ुदावन्द के सामने पेश करे, तो वह जानवर मक़बूल ठहरने के लिए बे — 'ऐब हो; उसमें कोई नुक़्स न हो। ");
INSERT INTO urd_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","जो अन्धा या शिकस्ता — ए — 'उज़्व या लूला हो, जिसके रसौली या खुजली या पपड़ियाँ हों, ऐसों को ख़ुदावन्द के सामने न चढ़ाना और न मज़बह पर उनकी आतिशी क़ुर्बानी ख़ुदावन्द के सामने पेश करना। ");
INSERT INTO urd_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","जिस बछड़े या बर्रे का कोई 'उज़्व ज़्यादा या कम हो उसे तो रज़ा की क़ुर्बानी के तौर पर पेश कर सकता है, लेकिन मिन्नत पूरी करने के लिए वह मक़बूल न होगा। ");
INSERT INTO urd_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","जिस जानवर के ख़ुसिए कुचले हुए या चूर किए हुए या टूटे या कटे हुए हों, उसे तुम ख़ुदावन्द के सामने न चढ़ाना और न अपने मुल्क में ऐसा काम करना; ");
INSERT INTO urd_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","और न इनमें से किसी को लेकर तुम अपने ख़ुदा की ग़िज़ा परदेसी या अजनबी के हाथ से अदा करवाना, क्यूँकि उनका बिगाड़ उनमें मौजूद होता है, उनमें 'ऐब है इसलिए वह तुम्हारी तरफ़ से मक़बूल न होंगे।” ");
INSERT INTO urd_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“जिस वक़्त बछड़ा या भेड़ या बकरी का बच्चा पैदा हो, तो सात दिन तक वह अपनी माँ के साथ रहे और आठवें दिन से और उसके बाद से वह ख़ुदावन्द की आतिशी क़ुर्बानी के लिए मक़बूल होगा। ");
INSERT INTO urd_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","और चाहे गाय हो या भेड़, बकरी, तुम उसे और उसके बच्चे दोनों को एक ही दिन ज़बह न करना। ");
INSERT INTO urd_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","और जब तुम ख़ुदावन्द के शुक्राने का ज़बीहा क़ुर्बानी करो, तो उसे इस तरह क़ुर्बानी करना कि तुम मक़बूल ठहरो; ");
INSERT INTO urd_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","और वह उसी दिन खा भी लिया जाए, तुम उसमें से कुछ भी दूसरे दिन की सुबह तक बाक़ी न छोड़ना; मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“इसलिए तुम मेरे हुक्मों को मानना और उन पर 'अमल करना; मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","तुम मेरे पाक नाम को नापाक न ठहराना, क्यूँकि मैं बनी — इस्राईल के बीच ज़रूर ही पाक माना जाऊँगा; मैं ख़ुदावन्द तुम्हारा पाक करने वाला हूँ, ");
INSERT INTO urd_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","जो तुम को मुल्क — ए — मिस्र से निकाल लाया हूँ ताकि तुम्हारा ख़ुदा बना रहूँ, मैं ख़ुदावन्द हूँ।” ");
INSERT INTO urd_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","और ख़ुदावन्द ने मूसा से कहा, कि ");
INSERT INTO urd_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“बनी — इस्राईल से कह कि ख़ुदावन्द की 'ईदें जिनका तुम को पाक मजम'ओं के लिए 'ऐलान देना होगा, मेरी वह 'ईदें यह हैं। ");
INSERT INTO urd_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","छ: दिन काम — काज किया जाए लेकिन सातवाँ दिन ख़ास आराम का और पाक मजमे' का सबत है, उस रोज़ किसी तरह का काम न करना; वह तुम्हारी सब सुकूनतगाहों में ख़ुदावन्द का सबत है। ");
INSERT INTO urd_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ख़ुदावन्द की 'ईदें जिनका 'ऐलान तुम को पाक मजम'ओं के लिए वक़्त — ए — मु'अय्यन पर करना होगा इसलिए यह हैं। ");
INSERT INTO urd_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","पहले महीने की चौदहवीं तारीख़ की शाम के वक़्त ख़ुदावन्द की फ़सह हुआ करे। ");
INSERT INTO urd_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","और उसी महीने की पंद्रहवीं तारीख़ को ख़ुदावन्द के लिए 'ईद — ए — फ़तीर हो, उसमें तुम सात दिन तक बे — ख़मीरी रोटी खाना। ");
INSERT INTO urd_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","पहले दिन तुम्हारा पाक मजमा' हो उसमें तुम कोई ख़ादिमाना काम न करना। ");
INSERT INTO urd_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","और सातों दिन तुम ख़ुदावन्द के सामने आतिशी क़ुर्बानी पेश करना और और सातवें दिन फिर पाक मजमा' हो उस रोज़ तुम कोई ख़ादिमाना काम न करना।” ");
INSERT INTO urd_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“बनी — इस्राईल से कह कि जब तुम उस मुल्क में जो मैं तुम को देता हूँ दाख़िल हो जाओ और उसकी फ़स्ल काटो, तो तुम अपनी फ़स्ल के पहले फलों का एक पूला काहिन के पास लाना; ");
INSERT INTO urd_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","और वह उसे ख़ुदावन्द के सामने हिलाए, ताकि वह तुम्हारी तरफ़ से क़ुबूल हो और काहिन उसे सबत के दूसरे दिन सुबह को हिलाए। ");
INSERT INTO urd_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","और जिस दिन तुम पूले को हिलाओ उसी दिन एक नर बे — 'ऐब यक — साला बर्रा सोख़्तनी क़ुर्बानी के तौर पर ख़ुदावन्द के सामने पेश करना। ");
INSERT INTO urd_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","और उसके साथ नज़्र की क़ुर्बानी के लिए तेल मिला हुआ मैदा ऐफ़ा के दो दहाई हिस्से के बराबर हो, ताकि वह आतिशी क़ुर्बानी के तौर पर ख़ुदावन्द के सामने राहतअंगेज़ ख़ुशबू के लिए जलाई जाए; और उसके साथ मय का तपावन हीन के चौथे हिस्से के बराबर मय लेकर करना। ");
INSERT INTO urd_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","और जब तक तुम अपने ख़ुदा के लिए यह हदिया न ले आओ, उस दिन तक नई फ़स्ल की रोटी या भुना हुआ अनाज, या हरी बालें हरगिज़ न खाना। तुम्हारी सब सुकूनतगाहों में नसल — दर — नसल हमेशा यही क़ानून रहेगा। ");
INSERT INTO urd_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“और तुम सबत के दूसरे दिन से जिस दिन हिलाने की क़ुर्बानी के लिए पूला लाओगे गिनना शुरू' करना, जब तक सात सबत पूरे न हो जाएँ। ");
INSERT INTO urd_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","और सातवें सबत के दूसरे दिन तक पचास दिन गिन लेना, तब तुम ख़ुदावन्द के लिए नज़्र की नई क़ुर्बानी पेश करना। ");
INSERT INTO urd_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","तुम अपने घरों में से ऐफ़ा के दो दहाई हिस्से के वज़न के मैदे के दो गिर्दे हिलाने की क़ुर्बानी के लिए ले आना; वह ख़मीर के साथ पकाए जाएँ ताकि ख़ुदावन्द के लिए पहले फल ठहरें। ");
INSERT INTO urd_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","और उन गिर्दों के साथ ही तुम सात यक — साला बे — 'ऐब बर्रे और एक बछड़ा और दो मेंढे लाना, ताकि वह अपनी अपनी नज़्र की क़ुर्बानी और तपावन के साथ ख़ुदावन्द के सामने सोख़्तनी क़ुर्बानी के तौर पर पेश करे जाएँ, और ख़ुदावन्द के सामने राहतअंगेज़ ख़शबू की आतिशी क़ुर्बानी ठहरें। ");
INSERT INTO urd_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","और तुम ख़ता की क़ुर्बानी के लिए एक बकरा और सलामती के ज़बीहे के लिए दो यकसाला नर बर्रे चढ़ाना। ");
INSERT INTO urd_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","और काहिन इनको पहले फल के दोनों गिर्दों के साथ लेकर उन दोनों बर्रों के साथ हिलाने की क़ुर्बानी के तौर पर ख़ुदावन्द के सामने हिलाए, वह ख़ुदावन्द के लिए पाक और काहिन का हिस्सा ठहरें। ");
INSERT INTO urd_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","और तुम ऐन उसी दिन 'ऐलान कर देना, उस रोज़ तुम्हारा पाक मजमा' हो, तुम उस दिन कोई ख़ादिमाना काम न करना; तुम्हारी सब सुकूनतगाहों में नसल — दर — नसल सदा यही तौर तरीक़ा रहेगा। ");
INSERT INTO urd_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“और जब तुम अपनी ज़मीन की पैदावार की फ़सल काटो, तो तू अपने खेत को कोने — कोने तक पूरा न काटना और न अपनी फ़सल की गिरी — पड़ी बालों को जमा' करना, बल्कि उनको ग़रीबों और मुसाफ़िरों के लिए छोड़ देना; मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ।” ");
INSERT INTO urd_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“बनी — इस्राईल से कह कि सातवें महीने की पहली तारीख़ तुम्हारे लिए ख़ास आराम का दिन हो, उसमें यादगारी के लिए नरसिंगे फूंके जाएँ और पाक मजमा' हो। ");
INSERT INTO urd_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","तुम उस रोज़ कोई ख़ादिमाना काम न करना और ख़ुदावन्द के सामने आतिशी क़ुर्बानी पेश करना।” ");
INSERT INTO urd_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","ख़ुदावन्द ने मूसा से कहा ");
INSERT INTO urd_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“उसी सातवें महीने की दसवीं तारीख़ की कफ़्फ़ारे का दिन है; उस रोज़ तुम्हारा पाक मजमा' हो, और तुम अपनी जानों को दुख देना और ख़ुदावन्द के सामने आतिशी क़ुर्बानी पेश करना। ");
INSERT INTO urd_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","तुम उस दिन किसी तरह का काम न करना, क्यूँकि वह कफ़्फ़ारे का दिन है जिसमें ख़ुदावन्द तुम्हारे ख़ुदा के सामने तुम्हारे लिए क़फ्फारा दिया जाएगा। ");
INSERT INTO urd_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","जो शख़्स उस दिन अपनी जान को दुख ने दे वह अपने लोगों में से काट डाला जाएगा। ");
INSERT INTO urd_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","और जो शख़्स उस दिन किसी तरह का काम करे, उसे मैं उसके लोगों में से फ़ना कर दूँगा। ");
INSERT INTO urd_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","तुम किसी तरह का काम मत करना, तुम्हारी सब सुकुनत गाहों में नसल — दर — नसल हमेशा यही तौर तरीक़े रहेंगे। ");
INSERT INTO urd_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","यह तुम्हारे लिए ख़ास आराम का सबत हो, इसमें तुम अपनी जानों को दुख देना; तुम उस महीने की नौवीं तारीख़ की शाम से दूसरी शाम तक अपना सबत मानना।” ");
INSERT INTO urd_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","'बनी — इस्राईल से कह कि उसी सातवें महीने की पंद्रहवीं तारीख़ से लेकर सात दिन तक ख़ुदावन्द के लिए 'ईद — ए — ख़ियाम होगी। ");
INSERT INTO urd_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","पहले दिन पाक मजमा हो; तुम उस दिन कोई ख़ादिमाना काम न करना। ");
INSERT INTO urd_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","तुम सातों दिन बराबर ख़ुदावन्द के सामने आतिशी क़ुर्बानी पेश करना। आठवें दिन तुम्हारा पाक मजमा' हो और फिर ख़ुदावन्द के सामने आतिशी क़ुर्बानी पेश करना; वह ख़ास मजमा' है, उसमें कोई ख़ादिमाना काम न करना। ");
INSERT INTO urd_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“यह ख़ुदावन्द की मुक़र्ररा 'ईदें हैं जिनमें तुम पाक मजम'ओं का 'ऐलान करना; ताकि ख़ुदावन्द के सामने आतिशी क़ुर्बानी, और सोख़्तनी क़ुर्बानी, और नज़्र की क़ुर्बानी और जबीहा और तपावन हर एक अपने अपने मुअ'य्यन दिन में पेश किया जाए। ");
INSERT INTO urd_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","इनके अलावा ख़ुदावन्द के सबतों को मानना, और अपने हदियों और मिन्नतों और रज़ा की क़ुर्बानियों को जो तुम ख़ुदावन्द के सामने लाते हो पेश करना। ");
INSERT INTO urd_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“और सातवें महीने की पंद्रहवीं तारीख़ से, जब तुम ज़मीन की पैदावार जमा' कर चुको तो सात दिन तक ख़ुदावन्द की 'ईद मानना। पहला दिन खास आराम का हो, और अट्ठारहवें दिन भी ख़ास आराम ही का हो। ");
INSERT INTO urd_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","इसलिए तुम पहले दिन ख़ुशनुमा दरख़्तों के फल और खजूर की डालियाँ, और घने दरख़्तों की शाख़े और नदियों की बेद — ए — मजनूँ लेना; और तुम ख़ुदावन्द अपने ख़ुदा के आगे सात दिन तक ख़ुशी मनाना। ");
INSERT INTO urd_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","और तुम हर साल ख़ुदावन्द के लिए सात रोज़ तक यह 'ईद माना करना। तुम्हारी नसल दर नसल हमेशा यही क़ानून रहेगा कि तुम सातवें महीने इस 'ईद को मानो। ");
INSERT INTO urd_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","सात रोज़ तक बराबर तुम सायबानों में रहना, जितने इस्राईल की नसल के हैं सब के सब सायबानों में रहें; ");
INSERT INTO urd_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ताकि तुम्हारी नसल को मा'लूम हो कि जब मैं बनी — इस्राईल को मुल्क — ए — मिस्र से निकाल कर ला रहा था तो मैंने उनको सायबानों में टिकाया था; मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ।” ");
INSERT INTO urd_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","इसलिए मूसा ने बनी — इस्राईल को ख़ुदावन्द की मुक़र्ररा 'ईदें बता दीं। ");
INSERT INTO urd_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“बनी — इस्राईल को हुक्म कर कि वह तेरे पास जै़तून का कूट कर निकाला हुआ ख़ालिस तेल रोशनी के लिए लाएँ, ताकि चराग़ा हमेशा जलता रहे। ");
INSERT INTO urd_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","हारून उसे शहादत के पर्दे के बाहर ख़ेमा — ए — इजितमा'अ में शाम से सुबह तक ख़ुदावन्द के सामने क़रीने से रख्खा करे; तुम्हारी नसल — दर — नसल सदा यही क़ानून रहेगा। ");
INSERT INTO urd_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","वह हमेशा उन चराग़ो की तरतीब से पाक शमा'दान पर ख़ुदावन्द के सामने रख्खा करे। ");
INSERT INTO urd_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“और तू मैदा लेकर बारह गिर्दे पकाना, हर एक गिर्दे में ऐफ़ा के दो दहाई हिस्से के बराबर मैदा हो; ");
INSERT INTO urd_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","और तू उनको दो क़तारें कर कि हर क़तार में छ: छ: रोटियाँ, पाक मेज़ पर ख़ुदावन्द के सामने रखना। ");
INSERT INTO urd_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","और तू हर एक क़तार पर ख़ालिस लुबान रखना, ताकि वह रोटी पर यादगारी या'नी ख़ुदावन्द के सामने आतिशी क़ुर्बानी के तौर पर हो। ");
INSERT INTO urd_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","वह हमेशा हर सबत के रोज़ उनको ख़ुदावन्द के सामने तरतीब दिया करे, क्यूँकि यह बनी — इस्राईल की जानिब से एक हमेशा 'अहद है। ");
INSERT INTO urd_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","और यह रोटियाँ हारून और उसके बेटों की होंगी वह इन को किसी पाक जगह में खाएँ, क्यूँकि वह एक जाविदानी क़ानून के मुताबिक़ ख़ुदावन्द की आतिशी क़ुर्बानियों में से हारून के लिए बहुत पाक हैं।” ");
INSERT INTO urd_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","और एक इस्राईली 'औरत का बेटा जिसका बाप मिस्री था, इस्राईलियों के बीच चला गया और वह इस्राईली 'औरत का बेटा और एक इस्राईली लश्करगाह में आपस में मार पीट करने लगे; ");
INSERT INTO urd_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","और इस्राईली 'औरत के बेटे ने पाक नाम पर कुफ़्र बका और ला'नत की। तब लोग उसे मूसा के पास ले गए। उसकी माँ का नाम सलोमीत था, जो दिब्री की बेटी थी जो दान के क़बीले का था। ");
INSERT INTO urd_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","और उन्होंने उसे हवालात में डाल दिया ताकि ख़ुदावन्द की जानिब से इस बात का फ़ैसला उन पर ज़ाहिर किया जाए। ");
INSERT INTO urd_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","तब ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","'उस ला'नत करने वाले को लश्करगाह के बाहर निकाल कर ले जा: और जितनों ने उसे ला'नत करते सुना, वह सब अपने — अपने हाथ उसके सिर पर रख्खें और सारी जमा'अत उसे संगसार करे। ");
INSERT INTO urd_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","और तू बनी — इस्राईल से कह दे कि जो कोई अपने ख़ुदा पर ला'नत करे उसका गुनाह उसी के सिर लगेगा। ");
INSERT INTO urd_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","और वह जो ख़ुदावन्द के नाम पर कुफ़्र बके, ज़रूर जान से मारा जाए; सारी जमा'अत उसे कत'ई संगसार करे, चाहे वह देसी हो या परदेसी; जब वह पाक नाम पर कुफ़्र बके तो वह ज़रूर जान से मारा जाए। ");
INSERT INTO urd_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","'और जो कोई किसी आदमी को मार डाले वह ज़रूर जान से मारा जाए। ");
INSERT INTO urd_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","और जो कोई किसी चौपाए को मार डाले, वह उसका मु'आवज़ा जान के बदले जान दे। ");
INSERT INTO urd_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“और अगर कोई शख़्स अपने पड़ोसी को 'ऐबदार बना दे, जो जैसा उसने किया वैसा ही उससे किया जाए; ");
INSERT INTO urd_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","या'नी 'उज़्व तोड़ने के बदले 'उज़्व तोड़ना हो, और आँख के बदले आँख और दाँत के बदले दाँत। जैसा ऐब उसने दूसरे आदमी में पैदा कर दिया है वैसा ही उसमें भी कर दिया जाए ");
INSERT INTO urd_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","अलग़र्ज़, जो कोई किसी चौपाए को मार डाले वह उसका मु'आवज़ा दे; लेकिन इंसान का क़ातिल जान से मारा जाए। ");
INSERT INTO urd_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","तुम एक ही तरह का क़ानून देसी और परदेसी दोनों के लिए रखना, क्यूँकि मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ।” ");
INSERT INTO urd_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","और मूसा ने यह बनी — इस्राईल को बताया। तब वह उस ला'नत करने वाले को निकाल कर लश्करगाह के बाहर ले गए और उसे संगसार कर दिया। इसलिए बनी — इस्राईल ने जैसा ख़ुदावन्द ने मूसा को हुक्म दिया था वैसा ही किया। ");
INSERT INTO urd_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","और ख़ुदावन्द ने कोह-ए-सीना पर मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“बनी — इस्राईल से कहा कि, जब तुम उस मुल्क में जो मैं तुम को देता हूँ दाख़िल हो जाओ, तो उसकी ज़मीन भी ख़ुदावन्द के लिए सबत को माने। ");
INSERT INTO urd_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","तू अपने खेत को छ: बरस बोना, और अपने अंगूरिस्तान को छ: बरस छाँटना और उसका फल जमा' करना। ");
INSERT INTO urd_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","लेकिन सातवें साल ज़मीन के लिए ख़ास आराम का सबत हो। यह सबत ख़ुदावन्द के लिए हो। इसमें तू न अपने खेत को बोना और न अपने अंगूरिस्तान को छाँटना। ");
INSERT INTO urd_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","और न अपनी खु़दरो फ़सल को काटना और न अपनी बे — छटी ताकों के अंगूरों को तोड़ना; यह ज़मीन के लिए ख़ास आराम का साल हो। ");
INSERT INTO urd_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","और ज़मीन का यह सबत तेरे, और तेरे ग़ुलामों और तेरी लौंडी और मज़दूरों और उन परदेसियों के लिए जो तेरे साथ रहते हैं, तुम्हारी ख़ुराक का ज़रिया' होगा; ");
INSERT INTO urd_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","और उसकी सारी पैदावार तेरे चौपायों और तेरे मुल्क के और जानवरों के लिए ख़ूराक़ ठहरेगी। ");
INSERT INTO urd_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“और तू बरसों के सात सबतों को, या’नी सात गुना सात साल गिन लेना, और तेरे हिसाब से बरसों के सात सबतों की मुद्दत कुल उन्चास साल होंगे। ");
INSERT INTO urd_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","तब तू सातवें महीने की दसवीं तारीख़ की बड़ा नरसिंगा ज़ोर से फुँकवाना, तुम कफ़्फ़ारे के रोज़ अपने सारे मुल्क में यह नरसिंगा फुँकवाना। ");
INSERT INTO urd_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","और तुम पचासवें बरस को पाक जानना और तमाम मुल्क में सब बाशिन्दों के लिए आज़ादी का 'ऐलान कराना, यह तुम्हारे लिए यूबली हो। इसमें तुम में से हर एक अपनी मिल्कियत का मालिक हो, और हर शख़्स अपने ख़ान्दान में फिर शामिल हो जाए। ");
INSERT INTO urd_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","वह पचासवाँ बरस तुम्हारे लिए यूबली हो, तुम उसमें कुछ न बोना और न उसे जो अपने आप पैदा हो जाए काटना और न बे — छटी ताकों का अंगूर जमा' करना। ");
INSERT INTO urd_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","क्यूँकि वह साल — ए — यूबली होगा; इसलिए वह तुम्हारे लिए पाक ठहरे, तुम उसकी पैदावार की खेत से लेकर खाना। ");
INSERT INTO urd_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“उस साल — ए — यूबली में तुम में से हर एक अपनी मिल्कियत का फिर मालिक हो जाए। ");
INSERT INTO urd_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","और अगर तू अपने पड़ोसी के हाथ कुछ बेचे या अपने पड़ोसी से कुछ ख़रीदे, तो तुम एक दूसरे पर अन्धेर न करना। ");
INSERT INTO urd_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","यूबली के बाद जितने बरस गुज़रें हो उनके शुमार के मुताबिक़ तू अपने पड़ोसी से उसे ख़रीदना, और वह उसे फ़सल के बरसों के शुमार के मुताबिक़ तेरे हाथ बेचे। ");
INSERT INTO urd_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","जितने ज़्यादा बरस हों उतना ही दाम ज़्यादा करना और जितने कम बरस हों उतनी ही उस की क़ीमत घटाना; क्यूँकि बरसों के शुमार के मुताबिक़ वह उनकी फ़स्ल तेरे हाथ बेचता है। ");
INSERT INTO urd_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","और तुम एक दूसरे पर अन्धेर न करना, बल्कि अपने ख़ुदा से डरते रहना; क्यूँकि मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urd_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","इसलिए तुम मेरी शरी'अत पर 'अमल करना और मेरे हुक्मों को मानना और उन पर चलना, तो तुम उस मुल्क में अम्न के साथ बसे रहोगे। ");
INSERT INTO urd_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","और ज़मीन फलेगी और तुम पेट भर कर खाओगे, और वहाँ अम्न के साथ रहा करोगे। ");
INSERT INTO urd_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","और अगर तुम को ख़याल हो कि हम सातवें बरस क्या खाएँगे? क्यूँकि देखो, हम को न तो बोना है और न अपनी पैदावार की जमा' करना है। ");
INSERT INTO urd_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","तो मैं छटे ही बरस ऐसी बरकत तुम पर नाज़िल करूँगा कि तीनों साल के लिए काफ़ी ग़ल्ला पैदा हो जाएगा। ");
INSERT INTO urd_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","और आठवें बरस फिर जीतना बोना और पिछला ग़ल्ला खाते रहना, बल्कि जब तक नौवें साल के बोए हुए की फ़सल न काट लो उस वक़्त तक वही पिछला ग़ल्ला खाते रहोगे। ");
INSERT INTO urd_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“और ज़मीन हमेशा के लिए बेची न जाए क्यूँकि ज़मीन मेरी है, और तुम मेरे मुसाफ़िर और मेहमान हो। ");
INSERT INTO urd_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","बल्कि तुम अपनी मिल्कियत के मुल्क में हर जगह ज़मीन को छुड़ा लेने देना। ");
INSERT INTO urd_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“और अगर तुम्हारा भाई ग़रीब हो जाए और अपनी मिल्कियत का कुछ हिस्सा बेच डाले, तो जो उस का सबसे क़रीबी रिश्तेदार है वह आकर उस को जिसे उसके भाई ने बेच डाला है छुड़ा ले। ");
INSERT INTO urd_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","और अगर उस आदमी का कोई न हो जो उसे छुड़ाए, और वह ख़ुद मालदार हो जाए और उसके छुड़ाने के लिए उसके पास काफ़ी हो। ");
INSERT INTO urd_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","तो वह फ़रोख़्त के बाद के बरसों को गिन कर बाक़ी दाम उसकी जिसके हाथ ज़मीन बेची है फेर दे; तब वह फिर अपनी मिल्कियत का मालिक हो जाए। ");
INSERT INTO urd_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","लेकिन अगर उसमें इतना मक़दूर न हो कि अपनी ज़मीन वापस करा ले, तो जो कुछ सन बेच डाला है वह साल — ए — यूबली तक ख़रीदार के हाथ में रहे; और साल — ए — यूबली में छुट जाए, तब यह आदमी अपनी मिल्कियत का फिर मालिक हो जाए। ");
INSERT INTO urd_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","और अगर कोई शख़्स रहने के ऐसे मकान को बेचे जो किसी फ़सीलदार शहर में हो, तो वह उसके बिक जाने के बाद साल भर के अन्दर — अन्दर उसे छुड़ा सकेगा; या'नी पूरे एक साल तक वह उसे छुड़ाने का हक़दार रहेगा। ");
INSERT INTO urd_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","और अगर वह पूरे एक साल की मी'आद के अन्दर छुड़ाया न जाए, तो उस फ़सीलदार शहर के मकान पर ख़रीदार का नसल — दर — नसल हमेशा का क़ब्ज़ा हो जाए और वह साल — ए — यूबली में भी न छूटे। ");
INSERT INTO urd_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","लेकिन जिन देहात के गिर्द कोई फ़सील नहीं उनके मकानों का हिसाब मुल्क के खेतों की तरह होगा, वह छुड़ाए भी जा सकेंगे और साल — ए — यूबली में वह छूट भी जाएँगे। ");
INSERT INTO urd_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","तो भी लावियों के जो शहर हैं, लावी अपनी मिल्कियत के शहरों के मकानों को चाहे किसी वक़्त छुड़ा लें। ");
INSERT INTO urd_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","और अगर कोई दूसरा लावी उनको छुड़ा ले, तो वह मकान जो बेचा गया और उसकी मिल्कियत का शहर दोनों साल ए — यूबली में छूट जाएँ; क्यूँकि जो मकान लावियों के शहरों में हैं वही बनी — इस्राईल के बीच लावियों की मिल्कियत हैं। ");
INSERT INTO urd_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","लेकिन उनके शहरों की 'इलाक़े के खेत नहीं बिक सकते, क्यूँकि वह उनकी हमेशा की मिल्कियत हैं। ");
INSERT INTO urd_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","और अगर तेरा कोई भाई ग़रीब हो जाए और वह तेरे सामने तंगदस्त हो, तो तू उसे संभालना। वह परदेसी और मुसाफ़िर की तरह तेरे साथ रहे। ");
INSERT INTO urd_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","तू उससे सूद या नफ़ा' मत लेना बल्कि अपने ख़ुदा का ख़ौफ़ रखना, ताकि तेरा भाई तेरे साथ ज़िन्दगी बसर कर सके। ");
INSERT INTO urd_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","तू अपना रुपया उसे सूद पर मत देना और अपना खाना भी उसे नफ़े' के ख़याल से न देना। ");
INSERT INTO urd_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ, जो तुम को इसी लिए मुल्क — ए — मिस्र से निकाल कर लाया कि मुल्क — ए — कना'न तुम को दूँ और तुम्हारा ख़ुदा ठहरूँ। ");
INSERT INTO urd_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","'और अगर तेरा कोई भाई तेरे सामने ऐसा ग़रीब हो जाए कि अपने को तेरे हाथ बेच डाले, तो तू उससे गु़लाम की तरह ख़िदमत न लेना। ");
INSERT INTO urd_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","बल्कि वह मज़दूर और मुसाफ़िर की तरह तेरे साथ रहे और साल — ए — यूबली तक तेरी ख़िदमत करे। ");
INSERT INTO urd_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","उसके बाद वह बाल — बच्चों के साथ तेरे पास से चला जाए, और अपने घराने के पास और अपने बाप दादा की मिल्कियत की जगह को लौट जाए। ");
INSERT INTO urd_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","इसलिए कि वह मेरे ख़ादिम हैं जिनको मैं मुल्क — ए — मिस्र से निकाल कर लाया हूँ, वह ग़ुलामों की तरह बेचे न जाएँ। ");
INSERT INTO urd_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","तू उन पर सख़्ती से हुक्मरानी न करना, बल्कि अपने ख़ुदा से डरते रहना। ");
INSERT INTO urd_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","और तेरे जो ग़ुलाम और तेरी जो लौंडियाँ हों, वह उन क़ौमों में से हों जो तुम्हारे चारों तरफ़ रहती हैं; उन ही में से तुम गु़लाम और लौंडियाँ ख़रीदा करना। ");
INSERT INTO urd_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","इनके सिवा उन परदेसियों के लड़के बालों में से भी जो तुम में क़याम करते हैं और उनके घरानों में से जो तुम्हारे मुल्क में पैदा हुए और तुम्हारे साथ हैं तुम ख़रीदा करना और वह तुम्हारी ही मिल्कियत होंगे। ");
INSERT INTO urd_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","और तुम उनको मीरास के तौर पर अपनी औलाद के नाम कर देना कि वह उनकी मौरूसी मिल्कियत हों। इनमें से तुम हमेशा अपने लिए ग़ुलाम लिया करना; लेकिन बनी — इस्राईल जो तुम्हारे भाई हैं, उनमें से किसी पर तुम सख़्ती से हुक्मरानी न करना। ");
INSERT INTO urd_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“और अगर कोई परदेसी या मुसाफ़िर जो तेरे साथ हो, दौलतमन्द हो जाए और तेरा भाई उसके सामने ग़रीब हो कर अपने आप को उस परदेसी या मुसाफ़िर या परदेसी के ख़ान्दान के किसी आदमी के हाथ बेच डाले, ");
INSERT INTO urd_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","तो बिक जाने के बाद वह छुड़ाया जा सकता है, उसके भाइयों में से कोई उसे छुड़ा सकता है, ");
INSERT INTO urd_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","या उसका चचा या ताऊ, या उसके चचा या ताऊ का बेटा, या उसके ख़ान्दान का कोई और आदमी जो उसका क़रीबी रिश्तेदार हो वह उस को छुड़ा सकता है; या अगर वह मालदार हो जाए, तो वह अपना फ़िदिया दे कर छूट सकता है। ");
INSERT INTO urd_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","वह अपने ख़रीदार के साथ अपने को फ़रोख़्त कर देने के साल से लेकर साल — ए — यूबली तक हिसाब करे और उसके बिकने की क़ीमत बरसों की ता'दाद के मुताबिक़ हो; या'नी उसका हिसाब मज़दूर के दिनों की तरह उसके साथ होगा। ");
INSERT INTO urd_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","अगर यूबली के अभी बहुत से बरस बाक़ी हों, तो जितने रुपयों में वह ख़रीदा गया था उनमें से अपने छूटने की क़ीमत उतने ही बरसों के हिसाब के मुताबिक़ फेर दे। ");
INSERT INTO urd_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","और अगर साल — ए — यूबली के थोड़े से बरस रह गए हों, तो वह उसके साथ हिसाब करे और अपने छूटने की क़ीमत उतने ही बरसों के मुताबिक़ उसे फेर दे; ");
INSERT INTO urd_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","और वह उस मज़दूर की तरह अपने आक़ा के साथ रहे जिसकी मज़दूरी साल — ब — साल ठहराई जाती हो, और उसका आक़ा उस पर तुम्हारे सामने सख़्ती से हुकूमत न करने पाए। ");
INSERT INTO urd_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","और अगर वह इन तरीक़ों से छुड़ाया न जाए तो साल — ए — यूबली में बाल बच्चों के साथ छूट जाए। ");
INSERT INTO urd_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","क्यूँकि बनी — इस्राईल मेरे लिए ख़ादिम हैं, वह मेरे ख़ादिम हैं जिनको मैं मुल्क — ए — मिस्र से निकाल कर लाया हूँ; मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urd_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","तुम अपने लिए बुत न बनाना और न कोई तराशी हुई मूरत या लाट अपने लिए खड़ी करना, और न अपने मुल्क में कोई शबीहदार पत्थर रखना कि उसे सिज्दा करो; इसलिए कि मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ। ");
INSERT INTO urd_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","तुम मेरे सबतों को मानना और मेरे हैकल की ता'ज़ीम करना; मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“अगर तुम मेरी शरी'अत पर चलो और मेरे हुक्मों को मानो और उन पर 'अमल करो, ");
INSERT INTO urd_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","तो मैं तुम्हारे लिए सही वक़्त मेंह बरसाऊँगा और ज़मीन से अनाज पैदा होगा और मैदान के दरख़्त फलेंगे; ");
INSERT INTO urd_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","यहाँ तक कि अंगूर जमा' करने के वक़्त तक तुम दावते रहोगे, और जोतने बोने के वक़्त तक अंगूर जमा' करोगे, और पेट भर अपनी रोटी खाया करोगे, और चैन से अपने मुल्क में बसे रहोगे। ");
INSERT INTO urd_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","और मैं मुल्क में अम्न बख़्शूंगा, और तुम सोओगे और तुम को कोई नहीं डराएगा; और मैं बुरे दरिन्दों को मुल्क से हलाक कर दूँगा, और तलवार तुम्हारे मुल्क में नहीं चलेगी। ");
INSERT INTO urd_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","और तुम अपने दुश्मनों का पीछा करोगे, और वह तुम्हारे आगे — आगे तलवार से मारे जाएँगे। ");
INSERT INTO urd_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","और तुम्हारे पाँच आदमी सौ को दौड़ाएंगे, और तुम्हारे सौ आदमी दस हज़ार को खदेड़ देगें, और तुम्हारे दुश्मन तलवार से तुम्हारे आगे — आगे मारे जाएँगे; ");
INSERT INTO urd_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","और मैं तुम पर नज़र — ए — 'इनायत रख्खूंगा, और तुम को कामयाब करूँगा और बढ़ाऊँगा, और जो मेरा 'अहद तुम्हारे साथ है उसे पूरा करूँगा। ");
INSERT INTO urd_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","और तुम 'अरसे का ज़ख़ीरा किया हुआ पुराना अनाज खाओगे, और नये की वजह से पुराने को निकाल बाहर करोगे। ");
INSERT INTO urd_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","और मैं अपना घर तुम्हारे बीच क़ायम रखूँगा और मेरी रूह तुमसे नफ़रत न करेगी। ");
INSERT INTO urd_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","और मैं तुम्हारे बीच चला फिरा करूँगा, और तुम्हारा ख़ुदा हूँगा, और तुम मेरी क़ौम होगे। ");
INSERT INTO urd_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ, जो तुम को मुल्क — ए — मिस्र से इसलिए निकाल कर ले आया कि तुम उनके ग़ुलाम न बने रहो; और मैंने तुम्हारे जूए की चोबें तोड़ डाली हैं और तुम को सीधा खड़ा करके चलाया। ");
INSERT INTO urd_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","लेकिन अगर तुम मेरी न सुनो और इन सब हुक्मों पर 'अमल न करो, ");
INSERT INTO urd_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","और मेरी शरी'अत को छोड़ दो, और तुम्हारी रूहों को मेरे फ़ैसलों से नफ़रत हो, और तुम मेरे सब हुक्मों पर 'अमल न करो बल्कि मेरे 'अहद को तोड़ो; ");
INSERT INTO urd_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","तो मैं भी तुम्हारे साथ इस तरह पेश आऊँगा कि दहशत और तप — ए — दिक़ और बुख़ार को तुम पर मुक़र्रर कर दूँगा, जो तुम्हारी आँखों को चौपट कर देंगे और तुम्हारी जान को घुला डालेंगे, और तुम्हारा बीज बोना फ़िज़ूल होगा क्यूँकि तुम्हारे दुश्मन उसकी फ़सल खाएँगे; ");
INSERT INTO urd_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","और मैं ख़ुद भी तुम्हारा मुख़ालिफ़ हो जाऊँगा, और तुम अपने दुश्मनों के आगे शिकस्त खाओगे; और जिनको तुमसे 'अदावत है वही तुम पर हुक्मरानी करेंगे, और जब कोई तुमको दौड़ाता भी न होगा तब भी तुम भागोगे। ");
INSERT INTO urd_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","और अगर इतनी बातों पर भी तुम मेरी न सुनो तो मैं तुम्हारे गुनाहों के ज़रिए' तुम को सात गुनी सज़ा और दूँगा। ");
INSERT INTO urd_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","और मैं तुम्हारी शहज़ोरी के फ़ख़्र को तोड़ डालूँगा, और तुम्हारे लिए आसमान को लोहे की तरह और ज़मीन को पीतल की तरह कर दूँगा। ");
INSERT INTO urd_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","और तुम्हारी क़ुव्वत बेफ़ायदा सर्फ़ होगी क्यूँकि तुम्हारी ज़मीन से कुछ पैदा न होगा और मैदान के दरख़्त फलने ही के नहीं। ");
INSERT INTO urd_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","और अगर तुम्हारा चलन मेरे ख़िलाफ़ ही रहे और तुम मेरा कहा न मानो, तो मैं तुम्हारे गुनाहों के मुवाफ़िक़ तुम्हारे ऊपर और सातगुनी बलाएँ लाऊँगा। ");
INSERT INTO urd_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","जंगली दरिन्दे तुम्हारे बीच छोड़ दूंगा जो तुम को बेऔलाद कर देंगे और तुम्हारे चौपायों को हलाक करेंगे और तुम्हारा शुमार घटा देगें, और तुम्हारी सड़कें सूनी पड़ जाएँगी। ");
INSERT INTO urd_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","और अगर इन बातों पर भी तुम मेरे लिए न सुधरो बल्कि मेरे ख़िलाफ़ ही चलते रहो, ");
INSERT INTO urd_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","तो मैं भी तुम्हारे ख़िलाफ़ चलूँगा, और मैं आप ही तुम्हारे गुनाहों के लिए तुम को और सात गुना मारूँगा। ");
INSERT INTO urd_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","और तुम पर एक ऐसी तलवार चलवाऊँगा जो 'अहदशिकनी का पूरा पूरा इन्तक़ाम ले लेगी, और जब तुम अपने शहरों के अन्दर जा जाकर इकट्ठे हो जाओ, तो मैं वबा को तुम्हारे बीच भेजूँगा और तुम ग़नीम के हाथ में सौंप दिए जाओगे। ");
INSERT INTO urd_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","और जब मैं तुम्हारी रोटी का सिलसिला तोड़ दूंगा, तो दस 'औरतें एक ही तनूर में तुम्हारी रोटी पकाएँगी। और तुम्हारी उन रोटियों को तोल — तोल कर देती जाएँगी; और तुम खाते जाओगे पर सेर न होगे। ");
INSERT INTO urd_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“और अगर तुम इन सब बातों पर भी मेरी न सुनो और मेरे ख़िलाफ़ ही चलते रहो, ");
INSERT INTO urd_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","तो मैं अपने ग़ज़ब में तुम्हारे बरख़िलाफ़ चलूँगा, और तुम्हारे गुनाहों के ज़रिए' तुम को सात गुनी सज़ा भी दूँगा। ");
INSERT INTO urd_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","और तुम को अपने बेटों का गोश्त और अपनी बेटियों का गोश्त खाना पड़ेगा। ");
INSERT INTO urd_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","और मैं तुम्हारी परस्तिश के बलन्द मकामों को ढा दुंगा, और तुम्हारी सूरज की मूरतों को काट डालूँगा और तुम्हारी लाशें तुम्हारे शिकस्ता बुतों पर डाल दूँगा, और मेरी रूह को तुमसे नफ़रत हो जाएगी। ");
INSERT INTO urd_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","और मैं तुम्हारे शहरों को वीरान कर डालूँगा, और तुम्हारे हैकलों को उजाड़ बना दूँगा, और तुम्हारी ख़ुशबू — ए — शीरीन की लपट को मैं सूघने का भी नहीं। ");
INSERT INTO urd_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","और मैं मुल्क को सूना कर दूँगा, और तुम्हारे दुश्मन जो वहाँ रहते हैं इस बात से हैरान होंगे। ");
INSERT INTO urd_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","और मैं तुम को गैर क़ौमों में बिखेर दूँगा और तुम्हारे पीछे — पीछे तलवार खींचे रहूँगा; और तुम्हारा मुल्क सूना हो जाएगा, और तुम्हारे शहर वीरान बन जाएँगे। ");
INSERT INTO urd_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","'और यह ज़मीन जब तक वीरान रहेगी और तुम दुश्मनों के मुल्क में होगे, तब तक वह अपने सबत मनाएगी; तब ही इस ज़मीन को आराम भी मिलेगा और वह अपने सबत भी मनाने पाएगी। ");
INSERT INTO urd_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","ये जब तक वीरान रहेगी तब ही तक आराम भी करेगी, जो इसे कभी तुम्हारे सबतों में जब तुम उसमें रहते थे नसीब नहीं हुआ था। ");
INSERT INTO urd_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","और जो तुम में से बच जाएँगे और अपने दुश्मनों के मुल्कों में होंगे, उनके दिल के अन्दर मैं बेहिम्मती पैदा कर दूँगा उड़ती हुई पट्टी की आवाज़ उनको खदेड़ेगी, और वह ऐसे भागेंगे जैसे कोई तलवार से भागता हो और हालाँकि कोई पीछा भी न करता होगा तो भी वह गिर — गिर पड़ेगे। ");
INSERT INTO urd_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","और वह तलवार के ख़ौफ़ से एक दूसरे से टकरा — टकरा जाएँगे बावजूद यह कि कोई खदेड़ता न होगा, और तुम को अपने दुश्मनों के मुक़ाबले की ताब न होगी। ");
INSERT INTO urd_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","और तुम ग़ैर क़ौमों के बीच बिखर कर हलाक हो जाओगे, और तुम्हारे दुश्मनों की ज़मीन तुम को खा जाएगी। ");
INSERT INTO urd_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","और तुम में से जो बाक़ी बचेंगे वह अपनी बदकारी की वजह से तुम्हारे दुश्मनों के मुल्कों में घुलते रहेंगे, और अपने बाप दादा की बदकारी की वजह से भी वह उन्हीं की तरह घुलते जाएँगे। ");
INSERT INTO urd_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","'तब वह अपनी और अपने बाप दादा की इस बदकारी का इक़रार करेंगे कि उन्होंने मुझ से ख़िलाफ़वर्ज़ी कर कि मेरी हुक्म — उदूली की; और यह भी मान लेंगे कि चूँकि वह मेरे ख़िलाफ़ चले थे, ");
INSERT INTO urd_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","इसलिए मैं भी उनका मुख़ालिफ़ हुआ और उनको उनके दुश्मनों के मुल्क में ला छोड़ा। अगर उस वक़्त उनका नामख़्तून दिल 'आजिज़ बन जाए और वह अपनी बदकारी की सज़ा को मन्जूर करें, ");
INSERT INTO urd_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","तब मैं अपना 'अहद जो या'क़ूब के साथ था याद करूँगा, और जो 'अहद मैंने इस्हाक़ के साथ, और जो 'अहद मैंने अब्रहाम के साथ बान्धा था उनको भी याद करूँगा, और इस मुल्क को याद करूँगा। ");
INSERT INTO urd_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","और वह ज़मीन भी उनसे छूट कर जब तक उनकी ग़ैर हाज़िरी में सूनी पड़ी रहेगी तब तक अपने सबतों को मनाएगी; और वह अपनी बदकारी की सज़ा को मन्जूर कर लेंगे, इसी वजह से कि उन्होंने मेरे हुक्मों को छोड़ दिया था, और उनकी रूहों को मेरी शरी'अत से नफ़रत ही गई थी। ");
INSERT INTO urd_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","इस पर भी जब वह अपने दुश्मनों के मुल्क में होंगे तो मैं उनको ऐसा नहीं छोड़ूँगा करूँगा और न मुझे उनसे ऐसी नफ़रत होगी कि मैं उनकी बिल्कुल फ़ना कर दूँ, और मेरा जो 'अहद उनके साथ है उसे तोड़ दूँ क्यूँकि मैं ख़ुदावन्द उनका ख़ुदा हूँ। ");
INSERT INTO urd_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","बल्कि मैं उनकी ख़ातिर उनके बाप दादा के 'अहद की याद करूँगा, जिनको मैं ग़ैरक़ौमों की आँखों के सामने मुल्क — ए — मिस्र से निकाल कर लाया ताकि मैं उनका ख़ुदा ठहरूँ; मैं ख़ुदावन्द हूँ।” ");
INSERT INTO urd_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","यह वह शरी'अत और अहकाम और क़वानीन हैं जो ख़ुदावन्द ने कोह-ए-सीना पर अपने और बनी — इस्राईल के बीच मूसा की ज़रिए' मुक़र्रर किए। ");
INSERT INTO urd_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","फिर ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“बनी — इस्राईल से कह, कि जब कोई शख़्स अपनी मिन्नत पूरी करने लगे, तो मिन्नत के आदमी तेरी क़ीमत ठहराने के मुताबिक़ ख़ुदावन्द के होंगे। ");
INSERT INTO urd_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","इसलिए बीस बरस की उम्र से लेकर साठ बरस की उम्र तक के मर्द के लिए तेरी ठहराई हुई क़ीमत हैकल की मिस्क़ाल के हिसाब से चाँदी की पचास मिस्क़ाल हों। ");
INSERT INTO urd_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","और अगर वह 'औरत हो, तो तेरी ठहराई हुई क़ीमत तीस मिस्क़ाल हों। ");
INSERT INTO urd_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","और अगर पाँच बरस से लेकर बीस बरस तक की उम्र हो, तो तेरी ठहराई हुई क़ीमत मर्द के लिए बीस मिस्क़ाल और 'औरत के लिए दस मिस्क़ाल हों। ");
INSERT INTO urd_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","लेकिन अगर उम्र एक महीने से लेकर पाँच बरस तक की हो, तो लड़के के लिए चाँदी के पाँच मिस्क़ाल और लड़की के लिए चाँदी के तीन मिस्क़ाल ठहराई जाएँ। ");
INSERT INTO urd_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","और अगर साठ बरस से लेकर ऊपर ऊपर की उम्र हो, तो मर्द के लिए पन्द्रह मिस्क़ाल और 'औरत के लिए दस मिस्क़ाल मुक़र्रर हों। ");
INSERT INTO urd_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","लेकिन अगर कोई तेरे अन्दाज़े की निस्बत कम मक़दूर रखता हो, तो वह काहिन के सामने हाज़िर किया जाए और काहिन उसकी क़ीमत ठहराए, या'नी जिस शख़्स ने मिन्नत मानी है उसकी जैसी हैसियत ही वैसी ही क़ीमत काहिन उसके लिए ठहराए। ");
INSERT INTO urd_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","'और अगर वह मिन्नत किसी ऐसे जानवर की है जिसकी क़ुर्बानी लोग ख़ुदावन्द के सामने चढ़ाया करते हैं, तो जो जानवर कोई ख़ुदावन्द की नज़्र करे वह पाक ठहरेगा। ");
INSERT INTO urd_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","वह उसे फिर किसी तरह न बदले, न तो अच्छे की बदले बुरा दे और न बुरे की बदले अच्छा दे; और अगर वह किसी हाल में एक जानवर के बदले दूसरा जानवर दे तो वह और उसका बदल दोनों पाक ठहरेंगे। ");
INSERT INTO urd_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","और अगर वह कोई नापाक जानवर हो जिसकी क़ुर्बानी ख़ुदावन्द के सामने नहीं पेश करते, तो वह उसे काहिन के सामने खड़ा करे, ");
INSERT INTO urd_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","और चाहे वह अच्छा हो या बुरा काहिन उसकी क़ीमत ठहराए और ऐ काहिन, जो कुछ तू उसका दाम ठहराएगा वही रहेगा। ");
INSERT INTO urd_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","और अगर वह चाहे कि उसका फ़िदिया देकर उसे छुड़ाए, तो जो क़ीमत तूने ठहराई है उसमें उसका पाँचवा हिस्सा वह और मिला कर दे। ");
INSERT INTO urd_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","'और अगर कोई अपने घर को पाक क़रार दे ताकि वह ख़ुदावन्द के लिए पाक हो, तो ख़्वाह वह अच्छा हो या बुरा काहिन उसकी क़ीमत ठहराए, और जो कुछ वह ठहराए वही उसकी क़ीमत रहेगी। ");
INSERT INTO urd_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","और जिसने उस घर को पाक क़रार दिया है अगर वह चाहे कि घर का फ़िदिया देकर उसे छुड़ाए, तो तेरी ठहराई हुई क़ीमत में उसका पाँचवाँ हिस्सा और मिला दे तब वह घर उसी का रहेगा। ");
INSERT INTO urd_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","और अगर कोई शख़्स अपने मौरूसी खेत का कोई हिस्सा ख़ुदावन्द के लिए पाक क़रार दे, तो तू क़ीमत का अन्दाज़ा करते यह देखना कि उसमें कितना बीज बोया जाएगा। जितनी ज़मीन में एक ख़ोमर के वज़न के बराबर जौ बो सकें उसकी क़ीमत चाँदी की पचास मिस्क़ाल हो। ");
INSERT INTO urd_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","अगर कोई साल — ए — यूबली से अपना खेत पाक करार दे, तो उसकी क़ीमत जो तू ठहराए वही रहेगी। ");
INSERT INTO urd_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","लेकिन अगर वह साल — ए — यूबली के बाद अपने खेत को पाक क़रार दे, तो जितने बरस दूसरे साल — ए — यूबली के बाक़ी हों उन्ही के मुताबिक़ काहिन उसके लिए रुपये का हिसाब करे; और जितना हिसाब में आए उतना तेरी ठहराई हुई क़ीमत से कम किया जाए। ");
INSERT INTO urd_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","और अगर वह जिसने उस खेत को पाक करार दिया है यह चाहे कि उसका फ़िदिया देकर उसे छुड़ाए, वह तेरी ठहराई हुई क़ीमत का पाँचवाँ हिस्सा उसके साथ और मिला कर दे तो वह खेत उसी का रहेगा। ");
INSERT INTO urd_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","और अगर वह उस खेत का फ़िदिया देकर उसे न छुड़ाए या किसी दूसरे शख़्स के हाथ उसे बेच दे, तो फिर वह खेत कभी न छुड़ाया जाए; ");
INSERT INTO urd_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","बल्कि वह खेत जब साल — ए — यूबली में छूटे तो वक्फ़ किए हुए खेत की तरह वह ख़ुदावन्द के लिए पाक होगा, और काहिन की मिल्कियत ठहरेगा ");
INSERT INTO urd_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","और अगर कोई शख़्स किसी ख़रीदे हुए खेत को जो उसका मौरूसी नहीं, ख़ुदावन्द के लिए पाक क़रार दे, ");
INSERT INTO urd_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","तो काहिन जितने बरस दूसरे साल — ए — यूबली के बाक़ी हों उनके मुताबिक़ तेरी ठहराई हुई क़ीमत का हिसाब उसके लिए करे, और वह उसी दिन तेरी ठहराई हुई क़ीमत को ख़ुदावन्द के लिए पाक जानकर दे दे। ");
INSERT INTO urd_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","और साल — ए — यूबली में वह खेत उसी को वापस हो जाए जिससे वह ख़रीदा गया था और जिसकी वह मिल्कियत है। ");
INSERT INTO urd_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","और तेरे सारे क़ीमत के अन्दाज़े हैकल की मिस्क़ाल के हिसाब से हों; और एक मिस्क़ाल बीस जीरह का हो। ");
INSERT INTO urd_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","लेकिन सिर्फ़ चौपायों के पहलौठों को जो पहलौठे होने की वजह से ख़ुदावन्द के ठहर चुके हैं, कोई शख़्स पाक क़रार न दे, चाहे वह बैल हो या भेड़ — बकरी वह तो ख़ुदावन्द ही का है। ");
INSERT INTO urd_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","लेकिन अगर वह किसी नापाक जानवर का पहलौठा हो तो वह शख़्स तेरी ठहराई हुई क़ीमत का पाँचवा हिस्सा क़ीमत में और मिलाकर उसका फ़िदिया दे और उसे छुड़ाए; और अगर उसका फ़िदिया न दिया जाए तो वह तेरी ठहराई हुई क़ीमत पर बेचा जाए। ");
INSERT INTO urd_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“तोभी कोई मख़्सूस की हुई चीज़ जिसे कोई शख़्स अपने सारे माल में से ख़ुदावन्द के लिए मख़्सूस करे, चाहे वह उसका आदमी या जानवर या मौरूसी ज़मीन ही बेची न जाए और न उसका फ़िदिया दिया जाए; हर एक मख़्सूस की हुई चीज़ ख़ुदावन्द के लिए बहुत पाक है। ");
INSERT INTO urd_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","अगर आदमियों में से कोई मख़्सूस किया जाए तो उसका फ़िदिया न दिया जाए, वह ज़रूर जान से मारा जाए। ");
INSERT INTO urd_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","और ज़मीन की पैदावार की सारी दहेकी चाहे वह ज़मीन के बीज की या दरख़्त के फल की हो, ख़ुदावन्द की है और ख़ुदावन्द के लिए पाक है। ");
INSERT INTO urd_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","और अगर कोई अपनी दहेकी में से कुछ छुड़ाना चाहे, तो वह उसका पाँचवाँ हिस्सा उसमें और मिला कर उसे छुड़ाए। ");
INSERT INTO urd_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","और गाय, बैल और भेड़ बकरी, या जो जानवर चरवाहे की लाठी के नीचे से गुज़रता हो, उनकी दहेकी या'नी दस पीछे एक — एक जानवर ख़ुदावन्द के लिए पाक ठहरे। ");
INSERT INTO urd_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","कोई उसकी देख भाल न करे कि वह अच्छा है या बुरा है और न उसे बदलें और अगर कहीं कोई उसे बदले तो वह असल और बदल दोनों के दोनों पाक ठहरे और उसका फ़िदिया भी न दिया जाए। ");
INSERT INTO urd_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","जो हुक्म ख़ुदावन्द ने कोह-ए-सीना पर बनी इस्राईल के लिए मूसा को दिए वह यही हैं।");
INSERT INTO urd_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","बनी — इस्राईल के मुल्क — ए — मिस्र से निकल आने के दूसरे बरस के दूसरे महीने की पहली तारीख़ को सीना के वीरान में ख़ुदावन्द ने ख़ेमा — ए — इजितमा'अ में मूसा से कहा कि, ");
INSERT INTO urd_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“तुम एक — एक मर्द का नाम ले लेकर गिनो, और उनके नामों की ता'दाद से बनी — इस्राईल की सारी जमा'अत की मर्दुमशुमारी का हिसाब उनके क़बीलों और आबाई ख़ान्दानों के मुताबिक़ करो। ");
INSERT INTO urd_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","बीस बरस और उससे ऊपर — ऊपर की उम्र के जितने इस्राईली जंग करने के क़ाबिल हों, उन सभों के अलग — अलग दलों को तू और हारून दोनों मिल कर गिन डालो। ");
INSERT INTO urd_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","और हर क़बीले से एक — एक आदमी जो अपने आबाई ख़ान्दान का सरदार है तुम्हारे साथ हो। ");
INSERT INTO urd_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","और जो आदमी तुम्हारे साथ होंगे उनके नाम यह हैं: रूबिन के क़बीले से इलिसूर बिन शदियूर ");
INSERT INTO urd_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","शमौन के क़बीले से सलूमीएल बिन सूरीशद्दी, ");
INSERT INTO urd_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","यहूदाह के क़बीले से नहसोन बिन 'अम्मीनदाब, ");
INSERT INTO urd_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","इश्कार के क़बीले से नतनीएल बिन ज़ुग़र, ");
INSERT INTO urd_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ज़बूलून के क़बीले से इलियाब बिन हेलोन, ");
INSERT INTO urd_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","यूसुफ़ की नसल में से इफ़्राईम के क़बीले का इलीसमा'अ बिन 'अम्मीहूद, और मनस्सी के क़बीले का जमलीएल बिन फ़दाहसूर, ");
INSERT INTO urd_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","बिनयमीन के क़बीले से अबिदान बिन जिदा'ऊनी ");
INSERT INTO urd_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","दान के क़बीले से अख़ी'अज़र बिन 'अम्मीशद्दी, ");
INSERT INTO urd_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","आशर के क़बीले से फ़ज'ईएल बिन 'अकरान, ");
INSERT INTO urd_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","जद्द के क़बीले से इलियासफ़ बिन द'ऊएल, ");
INSERT INTO urd_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","नफ़्ताली के क़बीले से अख़ीरा' बिन 'एनान।” ");
INSERT INTO urd_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","यही अश्ख़ास जो अपने आबाई क़बीलों के रईस और बनी — इस्राईल में हज़ारों के सरदार थे जमा'अत में से बुलाए गए। ");
INSERT INTO urd_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","और मूसा और हारून ने इन अश्ख़ास को जिनके नाम मज़कूर हैं अपने साथ लिया। ");
INSERT INTO urd_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","और उन्होंने दूसरे महीने की पहली तारीख़ को सारी जमा'अत को जमा' किया, और इन लोगों ने बीस बरस और उससे ऊपर — ऊपर की उम्र के सब आदमियों का शुमार करवा के अपने — अपने क़बीले, और आबाई ख़ान्दान के मुताबिक़ अपना अपना हस्ब — ओ — नसब लिखवाया। ");
INSERT INTO urd_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","इसलिए जैसा ख़ुदावन्द ने मूसा को हुक्म दिया था उसी के मुताबिक़ उसने उनको दश्त — ए — सीना में गिना। ");
INSERT INTO urd_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","और इस्राईल के पहलौठे रूबिन की नसल के लोगों में से एक — एक मर्द जो बीस बरस या उससे ऊपर — ऊपर की उम्र का और जंग करने के क़ाबिल था, वह अपने घराने और आबाई ख़ान्दान के मुताबिक़ अपने नाम से गिना गया। ");
INSERT INTO urd_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","इसलिए रूबिन के क़बीले के जो आदमी शुमार किए गए वह छियालीस हज़ार पाँच सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","और शमौन की नसल के लोगों में से एक — एक मर्द जो बीस बरस या उससे ऊपर — ऊपर की उम्र का और जंग करने के क़ाबिल था, वह अपने घराने और आबाई ख़ान्दान के मुताबिक़ अपने नाम से गिना गया। ");
INSERT INTO urd_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","इसलिए शमौन के क़बीले के जो आदमी शुमार किए गए वह उन्सठ हज़ार तीन सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","और जद्द की नसल के लोगों में से एक — एक मर्द जो बीस बरस या उससे ऊपर — ऊपर की उम्र का और जंग करने के क़ाबिल था, वह अपने घराने और आबाई ख़ान्दान के मुताबिक़ गिना गया। ");
INSERT INTO urd_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","इसलिए जद्द के क़बीले के जो आदमी शुमार किए गए वह पैंतालीस हज़ार छ: सौ पचास थे। ");
INSERT INTO urd_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","और यहूदाह की नसल के लोगों में से एक — एक मर्द जो बीस बरस या उससे ऊपर — ऊपर की उम्र का और जंग करने के क़ाबिल था, वह अपने घराने और आबाई ख़ान्दान के मुताबिक़ गिना गया। ");
INSERT INTO urd_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","इसलिए यहूदाह के क़बीले के जो आदमी शुमार किए गए वह चौहत्तर हज़ार छ: सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","और इश्कार की नसल के लोगों में से एक — एक मर्द जो बीस बरस या उससे ऊपर — ऊपर की उम्र का और जंग करने के क़ाबिल था, वह अपने घराने और आबाई ख़ान्दान के मुताबिक़ गिना गया। ");
INSERT INTO urd_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","इसलिए इश्कार के क़बीले के जो आदमी शुमार किए गए वह चव्वन हज़ार चार सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","और ज़बूलून की नसल के लोगों में से एक — एक मर्द जो बीस बरस या उससे ऊपर — ऊपर की उम्र का और जंग करने के क़ाबिल था, वह अपने घराने और आबाई ख़ान्दान के मुताबिक़ गिना गया। ");
INSERT INTO urd_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","इसलिए ज़बूलून के क़बीले के जो आदमी शुमार किए गए वह सतावन हज़ार चार सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","और यूसुफ़ की औलाद या'नी इफ़्राईम की नसल के लोगों में से एक — एक मर्द जो बीस बरस या उससे ऊपर — ऊपर की उम्र का और जंग करने के क़ाबिल था, वह अपने घराने और आबाई ख़ान्दान के मुताबिक़ गिना गया। ");
INSERT INTO urd_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","इसलिए इफ़्राईम के क़बीले के जो आदमी शुमार किए गए वह चालीस हज़ार पाँच सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","और मनस्सी की नसल के लोगों में से एक — एक मर्द जो बीस बरस या उससे ऊपर — ऊपर की उम्र का और जंग करने के क़ाबिल था, वह अपने घराने और आबाई ख़ान्दान के मुताबिक़ गिना गया। ");
INSERT INTO urd_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","इसलिए मनस्सी के क़बीले के जो आदमी शुमार किए गए वह बत्तीस हज़ार दो सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","और बिनयमीन की नसल के लोगों में से एक — एक मर्द जो बीस बरस या उससे ऊपर — ऊपर की उम्र का और जंग करने के क़ाबिल था, वह अपने घराने और आबाई ख़ान्दान के मुताबिक़ गिना गया। ");
INSERT INTO urd_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","इसलिए बिनयमीन के क़बीले के जो आदमी शुमार किए गए वह पैतिस हज़ार चार सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","और दान की नसल के लोगों में से एक — एक मर्द जो बीस बरस या उससे ऊपर — ऊपर की उम्र का और जंग करने के क़ाबिल था, वह अपने घराने और आबाई ख़ान्दान के मुताबिक़ गिना गया। ");
INSERT INTO urd_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","इसलिए दान के क़बीले के जो आदमी शुमार किए गए वह बासठ हज़ार सात सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","और आशर की नसल के लोगों में से एक — एक मर्द जो बीस बरस या उससे ऊपर — ऊपर की उम्र का और जंग करने के क़ाबिल था, वह अपने घराने और आबाई ख़ान्दान के मुताबिक़ गिना गया। ");
INSERT INTO urd_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","इसलिए आशर के क़बीले के जो आदमी शुमार किए गए वह इकतालीस हज़ार पाँच सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","और नफ़्ताली की नसल के लोगों में से एक — एक मर्द जो बीस बरस या उससे ऊपर — ऊपर की उम्र का और जंग करने के क़ाबिल था, वह अपने घराने और आबाई ख़ान्दान के मुताबिक़ गिना गया। ");
INSERT INTO urd_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","इसलिए, नफ़्ताली के क़बीले के जो आदमी शुमार किए गए वह तिरपन हज़ार चार सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","यही वह लोग हैं जो गिने गए। इन ही को मूसा और हारून और बनी — इस्राईल के बारह रईसों ने जो अपने — अपने आबाई ख़ान्दान के सरदार थे, गिना। ");
INSERT INTO urd_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","इसलिए बनी — इस्राईल में से जितने आदमी बीस बरस या उससे ऊपर — ऊपर की उम्र के और जंग करने के क़ाबिल थे, वह सब गिने गए। ");
INSERT INTO urd_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","और उन सभों का शुमार छः लाख तीन हज़ार पाँच सौ पचास था। ");
INSERT INTO urd_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","पर लावी अपने आबाई क़बीले के मुताबिक़ उनके साथ गिने नहीं गए। ");
INSERT INTO urd_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","क्यूँकि ख़ुदावन्द ने मूसा से कहा था कि, ");
INSERT INTO urd_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","'तू लावियों के क़बीले को न गिनना और न बनी — इस्राईल के शुमार में उनका शुमार दाख़िल करना, ");
INSERT INTO urd_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","बल्कि तू लावियों को शहादत के घर और उसके सब बर्तनों और उसके सब लवाज़िम के मुतवल्ली मुक़र्रर करना। वही घर और उसके सब बर्तनों को उठाया करें और वहीँ उसमें ख़िदमत भी करें और घर के आस — पास वही अपने ख़ेमे लगाया करें। ");
INSERT INTO urd_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","और जब घर को आगे रवाना करने का वक़्त हो तो लावी उसे उतारें, और जब घर को लगाने का वक़्त हो तो लावी उसे खड़ा करें; और अगर कोई अजनबी शख़्स उसके नज़दीक आए तो वह जान से मारा जाए। ");
INSERT INTO urd_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","और बनी — इस्राईल अपने — अपने दल के मुताबिक़ अपनी — अपनी छावनी और अपने — अपने झंडे के पास अपने — अपने ख़ेमे डालें; ");
INSERT INTO urd_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","लेकिन लावी शहादत के घर के चारों तरफ़ ख़ेमे लगाएँ, ताकि बनी — इस्राईल की जमा'अत पर ग़ज़ब न हो; और लावी ही शहादत के घर की निगाहबानी करें।” ");
INSERT INTO urd_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","चुनाँचे बनी — इस्राईल ने जैसा ख़ुदावन्द ने मूसा को हुक्म दिया था वैसा ही किया। ");
INSERT INTO urd_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","और ख़ुदावन्द ने मूसा और हारून से कहा कि ");
INSERT INTO urd_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“बनी — इस्राईल अपने — अपने ख़ेमे अपने — अपने झंडे के निशान के पास और अपने — अपने आबाई ख़ान्दान के 'अलम के साथ ख़ेमा — ए — इजितमा'अ के सामने और उसके चारों तरफ़ लगाएँ। ");
INSERT INTO urd_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","और जो पश्चिम की तरफ़ जिधर से सूरज निकलता है, अपने ख़ेमे अपने दलों के मुताबिक़ लगाएँ वह यहूदाह की छावनी के झंडे के लोग हों, और अम्मीनदाब का बेटा नहसोन बनी यहूदाह का सरदार हो; ");
INSERT INTO urd_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","और उसके दल के लोग जो शुमार किए गए थे वह सब चौहत्तर हजार छ: सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","और इनके क़रीब इश्कार के क़बीले के लोग ख़ेमे लगायें, और ज़ुग़र का बेटा नतनीएल बनी इश्कार का सरदार हो; ");
INSERT INTO urd_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","और उसके दल के लोग जो शुमार किए गए थे चव्वन हज़ार चार सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","फिर ज़बूलून का क़बीला हो, और हेलोन का बेटा इलियाब बनी ज़बूलून का सरदार हो; ");
INSERT INTO urd_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","और उसके दल के लोग जो शुमार किए गए थे वह सत्तावन हज़ार चार सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","इसलिए जितने यहूदाह की छावनी में अपने — अपने दल के मुताबिक़ गिने गए वह एक लाख छियासी हज़ार चार सौ थे। पहले यही रवाना हुआ करें। ");
INSERT INTO urd_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“और दख्खिन की तरफ़ अपने दलों के मुताबिक़ रूबिन की छावनी के झंडे के लोग हों, और शदियूर का बेटा इलिसूर बनी रूबिन का सरदार हो; ");
INSERT INTO urd_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","और उसके दल के लोग जो शुमार किए गए थे वह छियालीस हज़ार पाँच सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","और इनके क़रीब शमौन के क़बीले के लोग ख़ेमे लगायें, और सूरीशद्दी का बेटा सलूमीएल बनी शमौन का सरदार हो; ");
INSERT INTO urd_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","और उसके दल के लोग जो शुमार किए गए थे वह उनसठ हज़ार तीन सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","फिर जद्द का क़बीला हो, और र'ऊएल का बेटा इलियासफ़ बनी जद्द का सरदार हो; ");
INSERT INTO urd_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","और उसके दल के लोग जो शुमार किए गए थे वह पैन्तालीस हज़ार छ: सौ पचास थे। ");
INSERT INTO urd_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","इसलिए जितने रूबिन की छावनी में अपने — अपने दल के मुताबिक़ गिने गए वह एक लाख इक्कावन हज़ार चार सौ पचास थे। रवानगी के वक़्त दूसरी नौबत इन लोगों की हो। ");
INSERT INTO urd_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“फिर ख़ेमा — ए — इजितमा'अ लावियों की छावनी के साथ जो और छावनियों के बीच में होगी आगे जाए और जिस तरह से लावी ख़ेमे लगाएँ उसी तरह से वह अपनी — अपनी जगह और अपने — अपने झंडे के पास — पास चलें। ");
INSERT INTO urd_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","'और पश्चिम की तरफ़ अपने दलों के मुताबिक़ इफ़्राईम की छावनी के झंडे के लोग हों, और 'अम्मीहूद का बेटा इलीसमा' बनी इफ़्राईम का सरदार हो; ");
INSERT INTO urd_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","और उसके दल के लोग जो शुमार किए गए थे, वह चालीस हज़ार पाँच सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","और इनके क़रीब मनस्सी का क़बीला हो, और फ़दाहसूर का बेटा जमलीएल बनी मनस्सी का सरदार हो; ");
INSERT INTO urd_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","उसके दल के लोग जो शुमार किए गए थे बत्तीस हज़ार दो सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","फिर बिनयमीन का क़बीला हो, और जिद'औनी का बेटा अबिदान बनी बिनयमीन का सरदार हो; ");
INSERT INTO urd_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","और उसके दल के लोग जो शुमार किए गए थे वह पैंतीस हज़ार चार सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","इसलिए जितने इफ़्राईम की छावनी में अपने — अपने दल के मुताबिक़ गिने गए वह एक लाख आठ हज़ार एक सौ थे। रवाना के वक़्त तीसरी नौबत इन लोगों की हो। ");
INSERT INTO urd_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","'और शिमाल की तरफ़ अपने दलों के मुताबिक़ दान की छावनी के झंडे के लोग हों और 'अम्मीशद्दी का बेटा अख़ी'अज़र बनी दान का सरदार हो; ");
INSERT INTO urd_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","और उसके दल के लोग जो शुमार किए गए थे, वह बासठ हज़ार सात सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","इनके क़रीब आशर के क़बीले के लोग ख़ेमे लगाएँ, और 'अकरान का बेटा फ़ज'ईएल बनी आशर का सरदार हो; ");
INSERT INTO urd_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","और उसके दल के लोग जो शुमार किए गए थे वह, इकतालीस हज़ार पाँच सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","फिर नफ़्ताली का क़बीला हो, और 'एनान का बेटा अख़ीरा' बनी नफ़्ताली का सरदार हो; ");
INSERT INTO urd_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","और उसके दल के लोग जो शुमार किये गए, वह तिरपन हज़ार चार सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","फिर जितने दान की छावनी में गिने गए वह एक लाख सत्तावन हज़ार छ: सौ थे। यह लोग अपने — अपने झंडे के पास — पास होकर सब से पीछे रवाना हुआ करें।” ");
INSERT INTO urd_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","बनी — इस्राईल में से जो लोग अपने आबाई ख़ान्दानों के मुताबिक़ गिने गए वह यही हैं; और सब छावनियों के जितने लोग अपने — अपने दल के मुताबिक़ गिने गए वह छः लाख तीन हज़ार पाँच सौ पचास थे। ");
INSERT INTO urd_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","लेकिन लावी जैसा ख़ुदावन्द ने मूसा को हुक्म किया था, बनी — इस्राईल के साथ गिने नहीं गए। ");
INSERT INTO urd_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","इसलिए बनी — इस्राईल ने ऐसा ही किया और जो — जो हुक्म ख़ुदावन्द ने मूसा को दिया था उसी के मुताबिक़ वह अपने — अपने झंडे के पास और अपने आबाई ख़ान्दानों के मुताबिक़, अपने — अपने घराने के साथ ख़ेमे लगाते और रवाना होते थे। ");
INSERT INTO urd_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","और जिस दिन ख़ुदावन्द ने कोह-ए-सीना पर मूसा से बातें कीं, तब हारून और मूसा के पास यह औलाद थी। ");
INSERT INTO urd_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","और हारून के बेटों के नाम यह हैं: नदब जो पहलौठा था, और अबीहू और इली'एलियाज़र और ऐतामर। ");
INSERT INTO urd_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","हारून के बेटे जो कहानत के लिए मम्सूह हुए और जिनको उसने कहानत की ख़िदमत के लिए मख़्सूस किया था उनके नाम यही हैं। ");
INSERT INTO urd_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","और नदब और अबीहू तो जब उन्होंने दश्त — ए — सीना में ख़ुदावन्द के सामने ऊपरी आग पेश कीं तब ही ख़ुदावन्द के सामने मर गए, और वह बे — औलाद भी थे। और इली'एलियाज़र और ऐतामर अपने बाप हारून के सामने कहानत की ख़िदमत को अन्जाम देते थे। ");
INSERT INTO urd_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“लावी के क़बीले को नज़दीक लाकर हारून काहिन के आगे हाज़िर कर ताकि वह उसकी ख़िदमत करें। ");
INSERT INTO urd_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","और जो कुछ उसकी तरफ़ से और जमा'अत की तरफ़ से उनको सौंपा जाए वह सब की ख़ेमा — ए — इजितमा'अ के आगे निगहबानी करें ताकि घर की ख़िदमत बजा लाएँ। ");
INSERT INTO urd_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","और वह ख़ेमा — ए — इजितमा'अ के सब सामान की और बनी — इस्राईल की सारी अमानत की हिफ़ाज़त करें ताकि घर की ख़िदमत बजा लाएँ। ");
INSERT INTO urd_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","और तू लावियों को हारून और उसके बेटों के हाथ में सुपर्द कर; बनी — इस्राईल की तरफ़ से वह बिल्कुल उसे दे दिए गए हैं। ");
INSERT INTO urd_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","और हारून और उसके बेटों को मुक़र्रर कर, और वह अपनी कहानत को महफ़ूज़ रख्खे और अगर कोई अजनबी नज़दीक आये तो वह जान से मारा जाए।” ");
INSERT INTO urd_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","और ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“देख, मैंने बनी — इस्राईल में से लावियों को उन सभों के बदले में ले लिया है जो इस्राईलियों में पहलौठी के बच्चे हैं, इसलिए लावी मेरे हों। ");
INSERT INTO urd_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","क्यूँकि सब पहलौठे मेरे हैं, इसलिए कि जिस दिन मैंने मुल्क — ए — मिस्र में सब पहलौठों को मारा, उसी दिन मैंने बनी — इस्राईल के सब पहलौठों को, क्या इंसान और क्या हैवान, अपने लिए पाक किया; इसलिए वह ज़रूर मेरे हों। मैं ख़ुदावन्द हूँ।” ");
INSERT INTO urd_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","फिर ख़ुदावन्द ने दश्त — ए — सीना में मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“बनी लावी को उनके आबाई ख़ान्दानों और घरानों के मुताबिक़ शुमार कर, या'नी एक महीने और उससे ऊपर — ऊपर के हर लड़के को गिनना।” ");
INSERT INTO urd_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","चुनाँचे मूसा ने ख़ुदावन्द के हुक्म के मुताबिक़ जो उसने उसे दिया, उनको गिना। ");
INSERT INTO urd_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","और लावी के बेटों के नाम यह हैं: जैरसोन और क़िहात और मिरारी। ");
INSERT INTO urd_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","जैरसोन के बेटों के नाम जिनसे उनके ख़ान्दान चले यह हैं: लिबनी और सिम'ई। ");
INSERT INTO urd_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","और क़िहात के बेटों के नाम जिनसे उनके ख़ान्दान चले 'अमराम और इज़हार और हब्रून और 'उज़्ज़ीएल हैं। ");
INSERT INTO urd_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","और मिरारी के बेटे जिनसे उनके ख़ान्दान चले, महली और मूशी हैं। लावियों के घराने उनके आबाई ख़ान्दानों के मुवाफ़िक़ यही हैं। ");
INSERT INTO urd_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","और जैरसोन से लिबनियों और सिम'ईयों के ख़ान्दान चले; यह जैरसोनियों के ख़ान्दान हैं। ");
INSERT INTO urd_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","इनमें जितने फ़रज़न्द — ए — नरीना एक महीने और उससे ऊपर — ऊपर के थे वह सब गिने गए और उनका शुमार सात हज़ार पाँच सौ था। ");
INSERT INTO urd_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","जैरसोनियों के ख़ान्दानों के आदमी घर के पीछे पश्चिम की तरफ़ अपने ख़ेमे लगाया करें। ");
INSERT INTO urd_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","और लाएल का बेटा इलियासफ़, जैरसोनियों के आबाई ख़ान्दानों का सरदार हो। ");
INSERT INTO urd_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","और ख़ेमा — ए — इजितमा'अ के जो सामान बनी जैरसोन की हिफ़ाज़त में सौंपे जाएँ वह यह हैं: घर और ख़ेमा, और उसका ग़िलाफ़, और ख़ेमा — ए — इजितमा'अ के दरवाज़े का पर्दा, ");
INSERT INTO urd_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","और घर और मज़बह के गिर्द के सहन के पर्दे, और सहन के दरवाज़े का पर्दा, और वह सब रस्सियाँ जो उसमें काम आती हैं। ");
INSERT INTO urd_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","और क़िहात से 'अमरामियों और इज़हारियों और हबरूनियों और 'उज़्ज़ीएलियों के ख़ान्दान चले; ये क़िहातियों के ख़ान्दान हैं। ");
INSERT INTO urd_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","उनके फ़र्ज़न्द — ए — नरीना एक महीने और उससे ऊपर — ऊपर के आठ हज़ार छ: सौ थे। हैकल की निगहबानी इनके ज़िम्मे थी। ");
INSERT INTO urd_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","बनी क़िहात के ख़ान्दानों के आदमी घर की दख्खिनी सिम्त में अपने ख़ेमे डाला करें। ");
INSERT INTO urd_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","और 'उज़्ज़ीएल का बेटा इलिसफ़न क़िहातियों के घरानों के आबाई खान्दान का सरदार हो। ");
INSERT INTO urd_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","और सन्दूक़ और मेज़ और शमा'दान और दोनों मज़बहे और हैकल के बर्तन, जो इबादत के काम में आते हैं, और पर्दे और हैकल में बर्तन का सारा सामान, यह सब उनके ज़िम्मे हों। ");
INSERT INTO urd_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","और हारून काहिन का बेटा इली'एलियाज़र लावियों के सरदारों का सरदार और हैकल के मुत्वल्लियों का नाज़िर हो। ");
INSERT INTO urd_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","मिरारी से महलियों और मूशियों के ख़ान्दान चले; यह मिरारियों के ख़ान्दान हैं। ");
INSERT INTO urd_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","इनमें जितने फ़रज़न्द — ए — नरीना एक महीने और उससे ऊपर — ऊपर के थे वह छः हज़ार दो सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","और अबीख़ैल का बेटा सूरीएल मिरारियों के घरानों के आबाई ख़ान्दान का सरदार हो। यह लोग घर की उत्तरी सिम्त में अपने ख़ेमे डाला करें। ");
INSERT INTO urd_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","और घर के तख़्तों और उसकी बेडों और सुतूनों और ख़ानों और उसके सब आलात, और उसकी ख़िदमत के सब लवाज़िम की मुहाफ़िज़त, ");
INSERT INTO urd_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","और सहन के चारों तरफ़ के सुतूनों, और ख़ानों और मेख़ों और रस्सियों की निगरानी बनी मिरारी के ज़िम्मे हो। ");
INSERT INTO urd_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","और घर के आगे पश्चिम की तरफ़ जिधर से सूरज निकलता है, या'नी ख़ेमा — ए — इजितमा'अ के आगे, मूसा और हारून और उसके बेटे अपने ख़ेमे लगाया करें और बनी — इस्राईल के बदले हैकल की हिफ़ाज़त किया करें; और जो अजनबी शख़्स उसके नज़दीक आए वह जान से मारा जाए। ");
INSERT INTO urd_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","इसलिए लावियों में से जितने एक महीने और उससे ऊपर — ऊपर की उम्र के थे उनको मूसा और हारून ने ख़ुदावन्द के हुक्म के मुवाफ़िक़ उनके घरानों के मुताबिक़ गिना, वह शुमार में बाईस हज़ार थे। ");
INSERT INTO urd_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","और ख़ुदावन्द ने मूसा से कहा कि “बनी इस्राईल के सब नरीना पहलौटे, एक महीने और उससे ऊपर — ऊपर के गिन ले और उनके नामों का शुमार लगा। ");
INSERT INTO urd_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","और बनी — इस्राईल के सब पहलौठों के बदले लावियों को, और बनी — इस्राईल के चौपायों के सब पहलौठों के बदले लावियों के चौपायों को मेरे लिए ले। मैं ख़ुदावन्द हूँ।” ");
INSERT INTO urd_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","चुनाँचे मूसा ने ख़ुदावन्द के हुक्म के मुताबिक़ बनी — इस्राईल के सब पहलौठों को गिना। ");
INSERT INTO urd_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","तब जितने नरीना पहलौठे एक महीने और उससे ऊपर — ऊपर की उम्र के गिने गए, वह नामों के शुमार के मुताबिक़ बाईस हज़ार दो सौ तिहतर थे। ");
INSERT INTO urd_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","और ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“बनी — इस्राईल के सब पहलौठों के बदले लावियों को, और उनके चौपायों के बदले लावियों के चौपायों को ले; और लावी मेरे हों, मैं ख़ुदावन्द हूँ। ");
INSERT INTO urd_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","और बनी — इस्राईल के पहलौठों में जो दो सौ तिहत्तर लावियों के शुमार से ज़्यादा हैं, उनके फ़िदिये के लिए ");
INSERT INTO urd_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","तू हैकल की मिस्काल के हिसाब से हर शख़्स पाँच मिस्काल लेना एक मिस्क़ाल बीस जीरह का होता है। ");
INSERT INTO urd_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","और इनके फ़िदिये का रुपया जो शुमार में ज़्यादा हैं तू हारून और उसके बेटों को देना।” ");
INSERT INTO urd_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","तब जो उनसे जिनको लावियों ने छुड़ाया था, शुमार में ज़्यादा निकले थे उनके फ़िदिये का रुपया मूसा ने उनसे लिया। ");
INSERT INTO urd_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ये रुपया उसने बनी — इस्राईल के पहलौठों से लिया, इसलिए हैकल की मिस्काल के हिसाब से एक हज़ार तीन सौ पैंसठ मिस्क़ालें वसूल हुई। ");
INSERT INTO urd_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","और मूसा ने ख़ुदावन्द के हुक्म के मुताबिक़ फ़िदिये का रुपया जैसा ख़ुदावन्द ने मूसा को फ़रमाया था, हारून और उसके बेटों को दिया। ");
INSERT INTO urd_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","और ख़ुदावन्द ने मूसा और हारून से कहा कि, ");
INSERT INTO urd_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“बनी लावी में से क़िहातियों को उनके घरानों और आबाई ख़ान्दानों के मुताबिक़, ");
INSERT INTO urd_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","तीस बरस से लेकर पचास बरस की उम्र तक के जितने ख़ेमा — ए — इजितमा'अ में काम करने के लिए हैकल की ख़िदमत में शामिल हैं, उन सभों को गिनो। ");
INSERT INTO urd_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","और ख़ेमा — ए — इजितमा'अ में पाकतरीन चीज़ों की निस्बत बनी क़िहात का यह काम होगा, ");
INSERT INTO urd_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","कि जब लश्कर रवाना हो तो हारून और उसके बेटे आएँ और बीच के पर्दे को उतारें और उससे शहादत के सन्दूक़ को ढाँकें, ");
INSERT INTO urd_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","और उस पर तुख़स की खालों का एक ग़िलाफ़ डालें, और उसके ऊपर बिल्कुल आसमानी रंग का कपड़ा बिछाएँ, और उसमें उसकी चोबें लगाएँ। ");
INSERT INTO urd_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","और नज़्र की रोटी की मेज़ पर आसमानी रंग का कपड़ा बिछाकर, उसके ऊपर तबाक़ और चमचे और उँडेलने के कटोरे और प्याले रख्खें; और दाइमी रोटी भी उस पर हो। ");
INSERT INTO urd_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","फिर वह उन पर सुर्ख़ रंग का कपड़ा बिछाएँ और उसे तुख़स की खालों के एक ग़िलाफ़ से ढाँकें, और मेज़ में उसकी चोबें लगा दें। ");
INSERT INTO urd_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","फिर आसमानी रंग का कपड़ा लेकर उससे रोशनी देने वाले शमा'दान को, और उसके चराग़ों और गुलगीरों और गुलदानों और तेल के सब बर्तनों को, जो शमा'दान के लिए काम में आते हैं ढाँकें; ");
INSERT INTO urd_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","और उसको और उसके सब बर्तनों को तुख़स की खालों के एक ग़िलाफ़ के अन्दर रख कर उस ग़िलाफ़ को चौखटे पर धर दें। ");
INSERT INTO urd_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","और ज़रीन मज़बह पर आसमानी रंग का कपड़ा बिछाएँ और उसे तुख़स की खालों के एक ग़िलाफ़ से ढाँकें और उसकी चोबें उसमें लगाएँ। ");
INSERT INTO urd_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","और सब बर्तनों को जो हैकल की ख़िदमत के काम में आते हैं लेकर उनको आसमानी रंग के कपड़े में लपेटें और उनको तुख़स की खालों के एक ग़िलाफ़ से ढाँक कर चौखटे पर धरें। ");
INSERT INTO urd_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","फिर वह मज़बह पर से सब राख को उठाकर उसके ऊपर अर्गवानी रंग का कपड़ा बिछाएँ। ");
INSERT INTO urd_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","उसके सब बर्तन जिनसे उसकी ख़िदमत करते हैं जैसे अंगीठियाँ और सेख़ें और बेल्चे और कटोरे, ग़र्ज़ मज़बह के सब बर्तन उस पर रख्खें, और उस पर तुख़स की खालों का एक ग़िलाफ़ बिछाएँ और मज़बह में चोबें लगा दें। ");
INSERT INTO urd_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","और जब हारून और उसके बेटे हैकल की और हैकल के सब अस्बाब को ढाँक चुकें, तब ख़ेमागाह के रवानगी के वक़्त बनी क़िहात उसके उठाने के लिए आएँ लेकिन वह हैकल को न छुएँ, ऐसा न हो कि वह मर जाएँ। ख़ेमा — ए — इजितमा'अ की यही चीज़ें बनी क़िहात के उठाने की हैं। ");
INSERT INTO urd_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“और रोशनी के तेल, और ख़ुशबूदार ख़ुशबू और दाइमी नज़्र की क़ुर्बानी और मसह करने के तेल, और सारे घर, और उसके लवाज़िम और हैकल और उसके सामान की निगहबानी हारून काहिन के बेटे इली'एलियाज़र के ज़िम्मे हो।” ");
INSERT INTO urd_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","और ख़ुदावन्द ने मूसा और हारून से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“तुम लावियों में से क़िहातियों के क़बीले के ख़ान्दानों को मुनक़ता' होने न देना; ");
INSERT INTO urd_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","बल्कि इस मक़सूद से कि जब वह पाकतरीन चीज़ों के पास आएँ तो ज़िन्दा रहें, और मर न जाएँ, तुम उनके लिए ऐसा करना कि हारून और उसके बेटे अन्दर आ कर उनमें से एक — एक का काम और बोझ मुक़र्रर कर दें। ");
INSERT INTO urd_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","लेकिन वह हैकल को देखने की ख़ातिर दम भर के लिए भी अन्दर न आने पाएँ, ऐसा न हो कि वह मर जाएँ।” ");
INSERT INTO urd_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","फिर ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","'बनी जैरसोन में से भी उनके आबाई ख़ान्दानों और घरानों के मुताबिक़, ");
INSERT INTO urd_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","तीस बरस से लेकर पचास बरस तक की उम्र के जितने ख़ेमा — ए — इजितमा'अ में काम करने के लिए हैकल की ख़िदमत के वक़्त हाज़िर रहते हैं उन सभों को गिन। ");
INSERT INTO urd_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","जैरसोनियों के ख़ान्दानों का काम ख़िदमत करने और बोझ उठाने का है। ");
INSERT INTO urd_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","वह घर के पर्दों को, और ख़ेमा — ए — इजितमा'अ और उसके ग़िलाफ़ को, और उसके ऊपर के ग़िलाफ़ को जो तुख़स की खालों का है, और ख़ेमा — ए — इजितमा'अ के दरवाज़े के पर्दे को, ");
INSERT INTO urd_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","और घर और मज़बह के चारों तरफ़ के सहन के पर्दों को, और सहन के दरवाज़े के पर्दे को और उनकी रस्सियों को, और ख़िदमत के सब बर्तनों को उठाया करें; और इन चीज़ों से जो — जो काम लिया जाता है वह भी यही लोग किया करें। ");
INSERT INTO urd_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","जैरसोनियों की औलाद का ख़िदमत करने और बोझ उठाने का सारा काम हारून और उसके बेटों के हुक्म के मुताबिक़ हो, और तुम उनमें से हर एक का बोझ मुक़र्रर करके उनके सुपुर्द करना। ");
INSERT INTO urd_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ख़ेमा — ए — इजितमा'अ में बनी जैरसोन के ख़ान्दानों का यही काम रहे और वह हारून काहिन के बेटे ऐतामर के मातहत होकर ख़िदमत करें। ");
INSERT INTO urd_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“और बनी मिरारी में से उनके आबाई ख़ान्दानों और घरानों के मुताबिक़, ");
INSERT INTO urd_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","तीस बरस से लेकर पचास बरस तक की उम्र के जितने ख़ेमा — ए — इजितमा'अ में काम करने के लिए हैकल की ख़िदमत के वक़्त हाज़िर रहते हैं उन सभों को गिन। ");
INSERT INTO urd_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","और ख़ेमा — ए — इजितमा'अ में जिन चीज़ों के उठाने की ख़िदमत उनके ज़िम्मे हो वह यह हैं: घर के तख़्ते और उसके बेंडे, और सुतून और सुतूनों के ख़ाने, ");
INSERT INTO urd_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","और चारों तरफ़ के सहन के सुतून और उनके सब आलात और सारे सामान; और जो चीज़ें उनके उठाने के लिए तुम मुक़र्रर करो उनमें से एक — एक का नाम लेकर उसे उनके सुपुर्द करो। ");
INSERT INTO urd_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","बनी मिरारी के ख़ान्दानों को जो कुछ ख़िदमत ख़ेमा — ए — इजितमा'अ में हारून काहिन के बेटे ऐतामर के मातहत करना है वह यही है।” ");
INSERT INTO urd_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","चुनाँचे मूसा और हारून और जमा'अत के सरदारों ने क़िहातियों की औलाद में से उनके घरानों और आबाई ख़ान्दानों के मुताबिक़, ");
INSERT INTO urd_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","तीस बरस की उम्र से लेकर पचास बरस की उम्र तक के जितने ख़ेमा — ए — इजितमा'अ में काम करने के लिए हैकल की ख़िदमत में शामिल थे, उन सभों की गिन लिया; ");
INSERT INTO urd_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","और उनमें से जितने अपने घरानों के मुवाफ़िक़ गिने गए वह दो हज़ार सात सौ पचास थे। ");
INSERT INTO urd_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","क़िहातियों के ख़ान्दानों में से जितने ख़ेमा — ए — इजितमा'अ में ख़िदमत करते थे उन सभों का शुमार इतना ही है; जो हुक्म ख़ुदावन्द ने मूसा के ज़रिए' दिया था उसके मुताबिक़ मूसा और हारून ने उनको गिना। ");
INSERT INTO urd_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","और बनी जैरसोन में से अपने घरानों और आबाई ख़ान्दानों के मुताबिक़, ");
INSERT INTO urd_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","तीस बरस से लेकर पचास बरस की उम्र तक के जितने ख़ेमा — ए — इजितमा'अ में काम करने के लिए हैकल की ख़िदमत में शामिल थे, वह सब गिने गए; ");
INSERT INTO urd_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","और जितने अपने घरानों और आबाई ख़ान्दानों के मुताबिक़ गिने गए वह दो हज़ार छ: सौ तीस थे। ");
INSERT INTO urd_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","इसलिए बनी जैरसोन के ख़ान्दानों में से जितने ख़ेमा — ए — इजितमा'अ में ख़िदमत करते थे और जिनको मूसा और हारून ने ख़ुदावन्द के हुक्म के मुताबिक़ शुमार किया वह इतने ही थे। ");
INSERT INTO urd_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","और बनी मिरारी के घरानों में से अपने घरानों और आबाई ख़ान्दानों के मुताबिक़, ");
INSERT INTO urd_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","तीस बरस से लेकर पचास बरस की उम्र तक के जितने ख़ेमा — ए — इजितमा'अ में काम करने के लिए हैकल की ख़िदमत में शामिल थे, ");
INSERT INTO urd_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","वह सब गिने गए; और जितने उनमें से अपने घरानों के मुवाफ़िक़ गिने गए वह तीन हज़ार दो सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","इसलिए ख़ुदावन्द के उस हुक्म के मुताबिक़ जो उसने मूसा के ज़रिए' दिया था, जितनों को मूसा और हारून ने बनी मिरारी के ख़ान्दानों में से गिना वह यही हैं। ");
INSERT INTO urd_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","अलग़रज़ लावियों में से जिनको मूसा और हारून और इस्राईल के सरदारों ने उनके घरानों और आबाई ख़ान्दानों के मुताबिक़ गिना, ");
INSERT INTO urd_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","या'नी तीस बरस से लेकर पचास बरस की उम्र तक के जितने ख़ेमा — ए — इजितमा'अ में ख़िदमत करने और बोझ उठाने के काम के लिए हाज़िर होते थे, ");
INSERT INTO urd_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","उन सभों का शुमार आठ हज़ार पाँच सौ अस्सी था। ");
INSERT INTO urd_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","वह ख़ुदावन्द के हुक्म के मुताबिक़ मूसा के ज़रिए' अपनी अपनी ख़िदमत और बोझ उठाने के काम के मुताबिक़ गिने गए। यूँ वह मूसा के ज़रिए' जैसा ख़ुदावन्द ने उसको हुक्म दिया था गिने गए। ");
INSERT INTO urd_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","फिर ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“बनी — इस्राईल को हुक्म दे कि वह हर कोढ़ी को, और जिरयान के मरीज़ को, और जो मुर्दे की वजह से नापाक हो, उसको लश्करगाह से बाहर कर दें; ");
INSERT INTO urd_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ऐसों को चाहे वह मर्द हों या 'औरत, तुम निकाल कर उनको लश्करगाह के बाहर रख्खो ताकि वह उनकी लश्करगाह को जिसके बीच मैं रहता हूँ, नापाक न करें।” ");
INSERT INTO urd_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","चुनाँचे बनी — इस्राईल ने ऐसा ही किया और उनको निकाल कर लश्करगाह के बाहर रख्खा; जैसा ख़ुदावन्द ने मूसा को हुक्म दिया था वैसा ही बनी — इस्राईल ने किया। ");
INSERT INTO urd_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","और ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“बनी — इस्राईल से कह कि अगर कोई मर्द या 'औरत ख़ुदावन्द की हुक्म उदूली करके कोई ऐसा गुनाह करे जो आदमी करते हैं और क़ुसूरवार हो जाए, ");
INSERT INTO urd_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","तो जो गुनाह उसने किया है वह उसका इक़रार करे, और अपनी तक़सीर के मु'आवज़े में पूरा दाम और उसमें पाँचवाँ हिस्सा और मिलकर उस शख़्स को दे जिसका उसने क़ुसूर किया है। ");
INSERT INTO urd_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","लेकिन अगर उस शख़्स का कोई रिश्तेदार न हो जिसे उस तक़सीर का मु'आवज़ा दिया जाए, तो तक़सीर का जो मु'आवज़ा ख़ुदावन्द को दिया जाए वह काहिन का हो 'अलावा कफ़्फ़ारे के उस मेंढे के जिससे उसका कफ़्फ़ारा दिया जाए। ");
INSERT INTO urd_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","और जितनी पाक चीज़ें बनी इस्राईल उठाने की क़ुर्बानी के तौर पर काहिन के पास लाएँ वह उसी की हों। ");
INSERT INTO urd_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","और हर शख़्स की पाक की हुई चीज़ें उसकी हों और जो चीज़ कोई शख़्स काहिन को दे वह भी उसी की हो।” ");
INSERT INTO urd_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","और ख़ुदावन्द ने मूसा से कहा कि “बनी इस्राईल से कह कि ");
INSERT INTO urd_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","अगर किसी की बीवी गुमराह हो कर उससे बेवफ़ाई करे, ");
INSERT INTO urd_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","और कोई दूसरा आदमी उस 'औरत के साथ मुबाश्रत करे और उसके शौहर को मा'लूम न हो बल्कि यह उससे पोशीदा रहे, और वह नापाक हो गई हो लेकिन न तो कोई शाहिद ही और न वह 'ऐन फ़ेल के वक़्त पकड़ी गई हो। ");
INSERT INTO urd_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","और उसके शौहर के दिल में ग़ैरत आए: और वह अपनी बीवी से ग़ैरत खाने लगे हालाँकि वह नापाक हुई हो, या उसके शौहर के दिल में ग़ैरत आए और वह अपनी बीवी से ग़ैरत खाने लगे हालाँके वह नापाक नहीं हुई। ");
INSERT INTO urd_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","तो वह शख़्स अपनी बीवी को काहिन के पास हाज़िर करे, और उस 'औरत के चढ़ावे के लिए ऐफ़ा के दस्वें हिस्से के बराबर जौ का आटा लाए लेकिन उस पर न तेल डाले न लुबान रख्खे; क्यूँकि यह नज़्र की क़ुर्बानी ग़ैरत की है, या'नी यह यादगारी की नज़्र की क़ुर्बानी है जिससे गुनाह याद दिलाया जाता है। ");
INSERT INTO urd_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“तब काहिन उस 'औरत की नज़दीक लाकर ख़ुदावन्द के सामने खड़ी करे, ");
INSERT INTO urd_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","और काहिन मिट्टी के एक बासन में पाक पानी ले और घर के फ़र्श की गर्द लेकर उस पानी में डाले। ");
INSERT INTO urd_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","फिर काहिन उस 'औरत को ख़ुदावन्द के सामने खड़ी करके उसके सिर के बाल खुलवा दे, और यादगारी की नज़्र की क़ुर्बानी को जो ग़ैरत की नज़्र की क़ुर्बानी है उसके हाथों पर धरे, और काहिन अपने हाथ में उस कड़वे पानी को ले जो ला'नत को लाता है। ");
INSERT INTO urd_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","फिर काहिन उस 'औरत को क़सम खिला कर कहे कि अगर किसी शख़्स ने तुझसे सुहबत नहीं की है और तू अपने शौहर की होती हुई नापाकी की तरफ़ माइल नहीं हुई, तो तू इस कड़वे पानी की तासीर से जो ला'नत लाता है बची रह। ");
INSERT INTO urd_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","लेकिन अगर तू अपने शौहर की होती हुई गुमराह होकर नापाक हो गई है और तेरे शौहर के 'अलावा किसी दूसरे शख़्स ने तुझ से सुहबत की है, ");
INSERT INTO urd_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","तो काहिन उस 'औरत को ला'नत की क़सम खिला कर उससे कहे, कि ख़ुदावन्द तुझे तेरी क़ौम में तेरी रान को सड़ा कर और तेरे पेट को फुला कर ला'नत और फटकार का निशाना बनाए; ");
INSERT INTO urd_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","और यह पानी जो ला'नत लाता है तेरी अंतड़ियों में जा कर तेरे पेट को फुलाए और तेरी रान को सड़ाए। और 'औरत आमीन, आमीन कहे। ");
INSERT INTO urd_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“फिर काहिन उन ला'नतों को किसी किताब में लिख कर उनको उसी कड़वे पानी में धो डाले। ");
INSERT INTO urd_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","और वह कड़वा पानी जो ला'नत को लाता है उस 'औरत को पिलाए, और वह पानी जो ला'नत को लाता है उस 'औरत के पेट में जा कर कड़वा हो जाएगा। ");
INSERT INTO urd_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","और काहिन उस 'औरत के हाथ से ग़ैरत की नज़्र की क़ुर्बानी को लेकर ख़ुदावन्द के सामने उसको हिलाए, और उसे मज़बह के पास लाए, ");
INSERT INTO urd_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","फिर काहिन उस नज़्र की क़ुर्बानी में से उसकी यादगारी के तौर पर एक मुट्ठी लेकर उसे मज़बह पर जलाए, बाद उसके वह पानी उस 'औरत को पिलाए। ");
INSERT INTO urd_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","और जब वह उसे वह पानी पिला चुकेगा, तो ऐसा होगा कि अगर वह नापाक हुई और उसने अपने शौहर से बेवफ़ाई की, तो वह पानी जो ला'नत को लाता है उसके पेट में जा कर कड़वा हो जाएगा और उसका पेट फूल जाएगा और उसकी रान सड़ जाएगी; और वह 'औरत अपनी क़ौम में ला'नत का निशाना बनेगी। ");
INSERT INTO urd_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","पर अगर वह नापाक नहीं हुई बल्कि पाक है, तो बे — इल्ज़ाम ठहरेगी और उससे औलाद होगी। ");
INSERT INTO urd_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ग़ैरत के बारे में यही शरा' है, चाहे 'औरत अपने शौहर की होती हुई गुमराह होकर नापाक हो जाए या मर्द पर ग़ैरत सवार हो, ");
INSERT INTO urd_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","और वह अपनी बीवी से ग़ैरत खाने लगे; ऐसे हाल में वह उस 'औरत को ख़ुदावन्द के आगे खड़ी करे और काहिन उस पर यह सारी शरी'अत 'अमल में लाए। ");
INSERT INTO urd_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","तब मर्द गुनाह से बरी ठहरेगा और उस 'औरत का गुनाह उसी के सिर लगेगा।” ");
INSERT INTO urd_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","फिर ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","'बनी — इस्राईल से कह कि जब कोई मर्द या 'औरत नज़ीर की मिन्नत, या'नी अपने आप को ख़ुदावन्द के लिए अलग रखने की ख़ास मिन्नत माने, ");
INSERT INTO urd_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","तो वह मय और शराब से परहेज़ करे, और मय का या शराब का सिरका न पिए और न अंगूर का रस पिए और न ताज़ा या ख़ुश्क अंगूर खाए। ");
INSERT INTO urd_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","और अपनी नज़ारत के तमाम दिनों में बीज से लेकर छिल्के तक जो कुछ अंगूर के दरख़्त में पैदा हो उसे न खाए। ");
INSERT INTO urd_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","'और उसकी नज़ारत की मिन्नत के दिनों में उसके सिर पर उस्तरा न फेरा जाए; जब तक वह मुद्दत जिसके लिए वह ख़ुदावन्द का नज़ीर बना है पूरी न हो, तब तक वह पाक रहे और अपने सिर के बालों की लटों को बढ़ने दे। ");
INSERT INTO urd_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","उन तमाम दिनों में जब वह ख़ुदावन्द का नज़ीर हो वह किसी लाश के नज़दीक न जाए। ");
INSERT INTO urd_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","वह अपने बाप या माँ या भाई या बहन की ख़ातिर भी जब वह मरें, अपने आप को नजिस न करे। क्यूँकि उसकी नज़ारत जो ख़ुदा के लिए है, उसके सिर पर है। ");
INSERT INTO urd_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","वह अपनी नज़ारत की पूरी मुद्दत तक ख़ुदावन्द के लिए पाक है। ");
INSERT INTO urd_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“और अगर कोई आदमी नागहान उसके पास ही मर जाए और उसकी नज़ारत के सिर को नापाक कर दे, तो वह अपने पाक होने के दिन अपना सिर मुण्डवाए, या'नी सातवें दिन सिर मुण्डवाए। ");
INSERT INTO urd_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","और आठवें दिन दो कुमरियाँ या कबूतर के दो बच्चे ख़ेमा — ए — इजितमा'अ के दरवाज़े पर काहिन के पास लाए। ");
INSERT INTO urd_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","और काहिन एक को ख़ता की क़ुर्बानी के लिए और दूसरे को सोख़्तनी क़ुर्बानी के लिए पेश करे और उसके लिए कफ़्फ़ारा दे, क्यूँकि वह मुर्दे की वजह से गुनहगार ठहरा है; और उसके सिर को उसी दिन पाक करे। ");
INSERT INTO urd_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","फिर वह अपनी नज़ारत की मुद्दत को ख़ुदावन्द के लिए पाक करे, और एक यकसाला नर बर्रा जुर्म की क़ुर्बानी के लिए लाए; लेकिन जो दिन गुज़र गए हैं वह गिने नहीं जाएँगे क्यूँकि उसकी नज़ारत नापाक हो गई थी। ");
INSERT INTO urd_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","'और नज़ीर के लिए शरा' यह है, कि जब उसकी नज़ारत के दिन पूरे हो जाएँ तो वह ख़ेमा — ए — इजितमा'अ के दरवाज़े पर हाज़िर किया जाए। ");
INSERT INTO urd_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","और वह ख़ुदावन्द के सामने अपना चढ़ावा चढ़ाए, या'नी सोख़्तनी क़ुर्बानी के लिए एक बे — 'ऐब यक — साला नर बर्रा, और ख़ता की क़ुर्बानी के लिए एक बे — 'ऐब यक — साला मादा बर्रा, और सलामती की क़ुर्बानी के लिए एक बे — 'ऐब मेंढा, ");
INSERT INTO urd_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","और बेख़मीरी रोटियों की एक टोकरी, और तेल मिले हुए मैदे के कुल्चे, और तेल चुपड़ी हुई बे — ख़मीरी रोटियाँ, और उनकी नज़्र की कुर्बानी, और उनके तपावन लाए। ");
INSERT INTO urd_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","और काहिन उनको ख़ुदावन्द के सामने ला कर उसकी तरफ़ से ख़ता की क़ुर्बानी और सोख़्तनी क़ुर्बानी पेश करे। ");
INSERT INTO urd_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","और उस मेंढे को बेख़मीरी रोटियों की टोकरी के साथ ख़ुदावन्द के सामने सलामती की क़ुर्बानी के तौर पर पेश करे, और काहिन उसकी नज़्र की क़ुर्बानी और उसका तपावन भी अदा करे। ");
INSERT INTO urd_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","फिर वह नज़ीर ख़ेमा — ए — इजितमा'अ के दरवाज़े पर अपनी नज़ारत के बाल मुण्डवाए, और नज़ारत के बालों को उस आग में डाल दे जो सलामती की क़ुर्बानी के नीचे होगी। ");
INSERT INTO urd_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","और जब नज़ीर अपनी नज़ारत के बाल मुण्डवा चुके, तो काहिन उस मेंढे का उबाला हुआ शाना और एक बे — ख़मीरी रोटी टोकरी में से और एक बे — ख़मीरी कुल्चा लेकर उस नज़ीर के हाथों पर उनको धरे। ");
INSERT INTO urd_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","फिर काहिन उनको हिलाने की क़ुर्बानी के तौर पर ख़ुदावन्द के सामने हिलाए। हिलाने की क़ुर्बानी के सीने और उठाने की क़ुर्बानी के शाने के साथ यह भी काहिन के लिए पाक हैं। इसके बाद नज़ीर मय पी सकेगा। ");
INSERT INTO urd_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“नज़ीर जो मिन्नत माने और जो चढ़ावा अपनी नज़ारत के लिए ख़ुदावन्द के सामने लाये 'अलावा उसके जिसका उसे मक़दूर हो उन सभों के बारे में शरा' यह है। जैसी मिन्नत उसने मानी हो वैसा ही उसको नज़ारत की शरा' के मुताबिक़ 'अमल करना पड़ेगा।” ");
INSERT INTO urd_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","और ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“हारून और उसके बेटों से कह कि तुम बनी — इस्राईल को इस तरह दुआ दिया करना। तुम उनसे कहना: ");
INSERT INTO urd_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","'ख़ुदावन्द तुझे बरकत दे और तुझे महफ़ूज़ रख्खें। ");
INSERT INTO urd_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","“ख़ुदावन्द अपना चेहरा तुझ पर जलवागर फ़रमाए, और तुझ पर मेहरबान रहे। ");
INSERT INTO urd_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","“ख़ुदावन्द अपना चेहरा तेरी तरफ़ मुतवज्जिह करे, और तुझे सलामती बख़्शे। ");
INSERT INTO urd_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“इस तरह वह मेरे नाम को बनी — इस्राईल पर रख्खें और मैं उनको बरकत बख़्शूँगा।” ");
INSERT INTO urd_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","और जिस दिन मूसा घर को खड़ा करने से फ़ारिग़ हुआ और उसको और उसके सब सामान को मसह और पाक किया, और मज़बह और उसके सब मसह को भी मसह और पाक किया; ");
INSERT INTO urd_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","तो इस्राईली रईस जो अपने आबाई ख़ान्दानों के सरदार और क़बीलों के रईस और शुमार किए हुओं के ऊपर मुक़र्रर थे नज़राना लाए। ");
INSERT INTO urd_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","वह अपना हदिया छ: पर्देदार गाड़ियाँ और बारह बैल ख़ुदावन्द के सामने लाये दो — दो रईसों की तरफ़ से एक — एक गाड़ी और हर रईस की तरफ़ से एक बैल था, इनको उन्होंने घर के सामने हाज़िर किया। ");
INSERT INTO urd_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","तब ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“तू इनको उनसे ले ताकि वह ख़ेमा — ए — इजितमा'अ के काम में आएँ, और तू लावियों में हर शख़्स की ख़िदमत के मुताबिक़ उनको तक़सीम कर दे।” ");
INSERT INTO urd_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","तब मूसा ने वह गाड़ियाँ और बैल लेकर उनको लावियों को दे दिया। ");
INSERT INTO urd_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","बनी जैरसोन को उसने उनकी ख़िदमत के लिहाज़ से दो गाड़ियाँ और चार बैल दिए। ");
INSERT INTO urd_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","और चार गाड़ियाँ और आठ बैल उसने बनी मिरारी को उनकी ख़िदमत के लिहाज़ से हारून काहिन के बेटे ऐतामर के माताहत करके दिए। ");
INSERT INTO urd_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","लेकिन बनी क़िहात को उसने कोई गाड़ी नहीं दी, क्यूँकि उनके ज़िम्में हैकल की ख़िदमत थी; वह उसे अपने कन्धों पर उठाते थे, ");
INSERT INTO urd_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","और जिस दिन मज़बह मसह किया गया उस दिन वह रईस उसकी तक़दीस के लिए हदिये लाए, और अपने हदियों को वह रईस मज़बह के आगे ले जाने लगे। ");
INSERT INTO urd_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","तब ख़ुदावन्द ने मूसा से कहा, “मज़बह की तक़दीस के लिए एक — एक रईस एक — एक दिन अपना हदिया पेश करे।” ");
INSERT INTO urd_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","इसलिए पहले दिन यहूदाह के क़बीले में से 'अम्मीनदाब के बेटे नहसोन ने अपना हदिया पेश करा। ");
INSERT INTO urd_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","और उसका हदिया यह था: हैकल की मिस्क़ाल के हिसाब से एक सौ तीस मिस्क़ाल चाँदी का एक तबाक़, और सत्तर मिस्क़ाल चाँदी का एक कटोरा, उन दोनों में नज़्र की क़ुर्बानी के लिए तेल मिला हुआ मैदा भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","दस मिस्क़ाल सोने का एक चम्मच, जो ख़ुशबू से भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","सोख़्तनी क़ुर्बानी के लिए एक बछड़ा, एक मेंढा, एक नर यक — साला बर्रा, ");
INSERT INTO urd_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ख़ता की क़ुर्बानी के लिए एक बकरा; ");
INSERT INTO urd_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","और सलामती की क़ुर्बानी के लिए दो बैल, पाँच मेंढे, पाँच बकरे, पाँच नर यक — साला बर्रे। यह 'अमीनदाब के बेटे नहसोन का हदिया था। ");
INSERT INTO urd_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","दूसरे दिन ज़ुग़र के बेटे नतनीएल ने जो इश्कार के क़बीले का सरदार था, अपना हदिया पेश करा। ");
INSERT INTO urd_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","और उसका हदिया यह था: हैकल की मिस्क़ाल के हिसाब से एक सौ तीस मिस्क़ाल चाँदी का एक तबाक़, और सत्तर मिस्क़ाल चाँदी का एक कटोरा, उन दोनों में नज़्र की क़ुर्बानी के लिए तेल मिला हुआ मैदा भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","दस मिस्क़ाल सोने का एक चम्मच, जो ख़ुशबू से भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","सोख़्तनी क़ुर्बानी के लिए एक बछड़ा, एक मेंढा, एक नर यक — साला बर्रा; ");
INSERT INTO urd_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ख़ता की क़ुर्बानी के लिए एक बकरा; ");
INSERT INTO urd_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","और सलामती की क़ुर्बानी के लिए दो बैल, पाँच मेंढे, पाँच बकरे, पाँच नर यक — साला बर्रे। यह ज़ुग़र के बेटे नतनीएल का हदिया था। ");
INSERT INTO urd_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","और तीसरे दिन हेलोन के बेटे इलियाब ने जो ज़बूलून के क़बीले का सरदार था, अपना हदिया पेश करा। ");
INSERT INTO urd_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","और उसका हदिया यह था: हैकल की मिस्क़ाल के हिसाब से एक सौ तीस मिस्क़ाल चाँदी का एक तबाक़, और सत्तर मिस्क़ाल चाँदी का एक कटोरा, उन दोनों में नज़्र की क़ुर्बानी के लिए तेल मिला हुआ मैदा भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","दस मिस्क़ाल सोने का एक चम्मच, जो ख़ुशबू से भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","सोख़्तनी क़ुर्बानी के लिए एक बछड़ा, एक मेंढा, एक नर यक — साला बर्रा; ");
INSERT INTO urd_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ख़ता की क़ुर्बानी के लिए एक बकरा; ");
INSERT INTO urd_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","और सलामती की क़ुर्बानी के लिए दो बैल, पाँच मेंढे, पाँच बकरे, पाँच नर यक — साला बर्रे। यह हेलोन के बेटे इलियाब का हदिया था। ");
INSERT INTO urd_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","चौथे दिन शदियूर के बेटे इलीसूर ने जो रूबिन के क़बीले का सरदार था, अपना हदिया पेश करा। ");
INSERT INTO urd_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","और उसका हदिया यह था: हैकल की मिस्क़ाल के हिसाब से एक सौ तीस मिस्क़ाल चाँदी का एक तबाक़, और सत्तर मिस्क़ाल चाँदी का एक कटोरा, उन दोनों में नज़्र की क़ुर्बानी के लिए तेल मिला हुआ मैदा भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","दस मिस्क़ाल सोने का एक चम्मच, जो ख़ुशबू से भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","सोख़्तनी क़ुर्बानी के लिए एक बछड़ा, एक मेंढा, एक नर यक — साला बर्रा; ");
INSERT INTO urd_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ख़ता की क़ुर्बानी के लिए एक बकरा; ");
INSERT INTO urd_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","और सलामती की क़ुर्बानी लिए दो बैल, पाँच मेंढे, पाँच बकरे, पाँच नर यक — साला बर्रे। यह शदियूर के बेटे इलीसूर का हदिया था। ");
INSERT INTO urd_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","और पाँचवे दिन सूरीशद्दी के बेटे सलूमीएल ने जो शमौन के क़बीले का सरदार था, अपना हदिया पेश करा। ");
INSERT INTO urd_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","और उसका हदिया यह था: हैकल की मिस्क़ाल के हिसाब से एक सौ तीस मिस्क़ाल चाँदी का एक तबाक़ और सत्तर मिस्क़ाल चाँदी का एक कटोरा, उन दोनों में नज़्र की क़ुर्बानी के लिए तेल मिला हुआ मैदा भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","दस मिस्क़ाल सोने का एक चम्मच, जो ख़ुशबू से भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","सोख़्तनी क़ुर्बानी के लिए एक बछड़ा, एक मेंढा, एक नर यक — साला बर्रा; ");
INSERT INTO urd_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ख़ता की क़ुर्बानी के लिए एक बकरा; ");
INSERT INTO urd_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","और सलामती की क़ुर्बानी के लिए दो बैल पाँच मेंढे पाँच बकरे पाँच नर यक — साला बर्रे। यह सूरीशद्दी के बेटे सलूमीएल का हदिया था। ");
INSERT INTO urd_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","और छटे दिन द'ऊएल के बेटे इलियासफ़ ने जो जद्द के क़बीले का सरदार था, अपना हदिया पेश करा। ");
INSERT INTO urd_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","और उसका हदिया यह था: हैकल की मिस्क़ाल के हिसाब से एक सौ तीस मिस्क़ाल चाँदी का एक तबाक़, और सत्तर मिस्क़ाल चाँदी का एक कटोरा, उन दोनों में नज़्र की क़ुर्बानी के लिए तेल मिला हुआ मैदा भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","दस मिस्क़ाल सोने का एक चम्मच, जो ख़ुशबू से भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","सोख़्तनी क़ुर्बानी के लिए एक बछड़ा, एक मेंढा, एक नर यक — साला बर्रा; ");
INSERT INTO urd_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ख़ता की क़ुर्बानी के लिए एक बकरा; ");
INSERT INTO urd_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","और सलामती की क़ुर्बानी के लिए दो बैल, पाँच मेंढे, पाँच बकरे, पाँच नर यक — साला बर्रे। यह द'ऊएल के बेटे इलियासफ़ का हदिया था। ");
INSERT INTO urd_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","और सातवें दिन 'अम्मीहूद के बेटे इलीसमा' ने जो इफ़्राईम के क़बीले का सरदार था, अपना हदिया पेश करा। ");
INSERT INTO urd_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","और उसका हदिया यह था: हैकल की मिस्क़ाल के हिसाब से एक सौ तीस मिस्क़ाल चाँदी का एक तबाक़, और सत्तर मिस्क़ाल चाँदी का एक कटोरा, उन दोनों में नज़्र की क़ुर्बानी के लिए तेल मिला हुआ मैदा भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","दस मिस्क़ाल सोने का एक चम्मच, जो ख़ुशबू से भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","सोख़्तनी क़ुर्बानी के लिए एक बछड़ा एक मेंढा, एक नर यक — साला बर्रा; ");
INSERT INTO urd_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ख़ता की क़ुर्बानी के लिए एक बकरा; ");
INSERT INTO urd_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","और सलामती की क़ुर्बानी के लिए दो बैल, पाँच मेंढे, पाँच बकरे, पाँच नर यक — साला बर्रे। यह 'अम्मीहूद के बेटे इलीसमा' का हदिया था। ");
INSERT INTO urd_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","और आठवें दिन फ़दाहसूर के बेटे जमलीएल ने जो मनस्सी के क़बीले का सरदार था, अपना हदिया पेश करा। ");
INSERT INTO urd_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","और उसका हदिया यह था: हैकल की मिस्क़ाल के हिसाब से एक सौ तीस मिस्क़ाल चाँदी का एक तबाक़, और सत्तर मिस्क़ाल चाँदी का एक कटोरा, उन दोनों में नज़्र की क़ुर्बानी के लिए तेल मिला हुआ मैदा भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","दस मिस्क़ाल सोने का एक चम्मच, जो ख़ुशबू से भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","सोख़्तनी क़ुर्बानी के लिए एक बछड़ा, एक मेंढा, एक नर यक — साला बर्रा, ");
INSERT INTO urd_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ख़ता की क़ुर्बानी के लिए एक बकरा; ");
INSERT INTO urd_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","और सलामती की क़ुर्बानी के लिए दो बैल, पाँच मेंढे, पाँच बकरे, पाँच नर यक — साला बर्रे। यह फ़दाहसूर के बेटे जमलीएल का हदिया था। ");
INSERT INTO urd_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","और नवें दिन जिद'औनी के बेटे अबिदान ने जो बिनयमीन के क़बीले का सरदार था, अपना हदिया पेश करा। ");
INSERT INTO urd_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","और उसका हदिया यह था: हैकल की मिस्क़ाल के हिसाब से एक सौ तीस मिस्क़ाल चाँदी का एक तबाक़, और सत्तर मिस्क़ाल चाँदी का एक कटोरा, उन दोनों में नज़्र की क़ुर्बानी के लिए तेल मिला हुआ मैदा भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","दस मिस्क़ाल सोने का एक चम्मच जो ख़ुशबू से भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","सोख़्तनी क़ुर्बानी के लिए एक बछड़ा, एक मेंढा, एक नर यक — साला बर्रा; ");
INSERT INTO urd_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ख़ता की क़ुर्बानी के लिए एक बकरा; ");
INSERT INTO urd_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","और सलामती की क़ुर्बानी के लिए दो बैल, पाँच मेंढे, पाँच बकरे, पाँच नर यक — साला बर्रे। यह जिद'औनी के बेटे अबिदान का हदिया था। ");
INSERT INTO urd_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","और दसवें दिन 'अम्मीशद्दी के बेटे अख़ी'अज़र ने जो दान के क़बीले का सरदार था, अपना हदिया पेश करा। ");
INSERT INTO urd_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","और उसका हदिया यह था: हैकल की मिस्क़ाल के हिसाब से एक सौ तीस मिस्क़ाल चाँदी का एक तबाक़, और सत्तर मिस्क़ाल चाँदी का एक कटोरा, उन दोनों में नज़्र की क़ुर्बानी के लिए तेल मिला हुआ मैदा भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","दस मिस्क़ाल सोने का एक चम्मच, जो ख़ुशबू से भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","सोख़्तनी क़ुर्बानी के लिए एक बछड़ा, एक मेंढा, एक नर यक — साला बर्रा; ");
INSERT INTO urd_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ख़ता की क़ुर्बानी के लिए एक बकरा; ");
INSERT INTO urd_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","और सलामती की क़ुर्बानी के लिए दो बैल, पाँच मेंढे, पाँच बकरे, पाँच नर यक — साला बर्रे। यह 'अम्मीशद्दी के बेटे अख़ी'अज़र का हदिया था। ");
INSERT INTO urd_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","और ग्यारहवें दिन 'अकरान के बेटे फ़ज'ईएल ने जो आशर के क़बीले का सरदार था, अपना हदिया पेश करा। ");
INSERT INTO urd_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","और उसका हदिया यह था: हैकल की मिस्क़ाल के हिसाब से एक सौ तीस मिस्क़ाल चाँदी का एक तबाक़, और सत्तर मिस्क़ाल चाँदी का एक कटोरा, उन दोनों में नज़्र की क़ुर्बानी के लिए तेल मिला हुआ मैदा भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","दस मिस्क़ाल चाँदी का एक चम्मच, जो ख़ुशबू से भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","सोख़्तनी क़ुर्बानी के लिए एक बछड़ा, एक मेंढा, एक नर यक — साला बर्रा; ");
INSERT INTO urd_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ख़ता की क़ुर्बानी के लिए एक बकरा; ");
INSERT INTO urd_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","और सलामती की क़ुर्बानी के लिए दो बैल, पाँच मेंढे, पाँच बकरे, पाँच नर यक — साला बर्रे। यह 'अकरान के बेटे फ़ज'ईएल का हदिया था। ");
INSERT INTO urd_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","और बारहवें दिन 'एनान के बेटे अख़ीरा' ने जो बनी नफ़्ताली के क़बीले का सरदार था, अपना हदिया पेश करा। ");
INSERT INTO urd_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","और उसका हदिया यह था: हैकल की मिस्क़ाल के हिसाब से एक सौ तीस मिस्क़ाल चाँदी का एक तबाक़, और सत्तर मिस्क़ाल चाँदी का एक कटोरा, उन दोनों में नज़्र की क़ुर्बानी के लिए तेल मिला हुआ मैदा भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","दस मिस्क़ाल सोने का एक चम्मच, जो ख़ुशबू से भरा था; ");
INSERT INTO urd_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","सोख़्तनी क़ुर्बानी के लिए एक बछड़ा, एक मेंढा, एक नर यक — साला बर्रा; ");
INSERT INTO urd_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ख़ता की क़ुर्बानी के लिए एक बकरा; ");
INSERT INTO urd_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","और सलामती की क़ुर्बानी के लिए दो बैल, पाँच मेंढे, पाँच बकरे, पाँच नर यकसाला बर्रे। यह 'एनान के बेटे अख़ीरा' का हदिया था। ");
INSERT INTO urd_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","मज़बह के मम्सूह होने के दिन जो हदिये उसकी तक़दीस के लिए इस्राईली रईसों की तरफ़ से पेश करे गए वह यही थे: या'नी चाँदी के बारह तबाक़, चाँदी के बारह कटोरे, सोने के बारह चम्मच। ");
INSERT INTO urd_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","चाँदी का हर तबाक़ वज़न में एक सौ तीस मिस्क़ाल और हर एक कटोरा सत्तर मिस्क़ाल का था। इन बर्तनों की सारी चाँदी हैकल की मिस्क़ाल के हिसाब से दो हज़ार चार सौ मिस्क़ाल थी। ");
INSERT INTO urd_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ख़ुशबू से भरे हुए सोने के बारह चम्मच जो हैकल की मिस्क़ाल की तौल के मुताबिक़ वज़न में दस — दस मिस्क़ाल के थे, इन चम्मचों का सारा सोना एक सौ बीस मिस्क़ाल था। सोख़्तनी क़ुर्बानी के लिए कुल बारह बछड़े, बारह मेंढे, बारह नर यक — साला बर्रे अपनी — अपनी नज़्र की क़ुर्बानी के साथ थे; और ख़ता की क़ुर्बानी के लिए बारह बकरे थे; ");
INSERT INTO urd_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","सोख़्तनी क़ुर्बानी के लिए कुल बारह बछड़े, बारह मेंढे, बारह नर यक — साला बर्रे अपनी — अपनी नज़्र की क़ुर्बानी के साथ थे; और ख़ता की क़ुर्बानी के लिए बारह बकरे थे; ");
INSERT INTO urd_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","और सलामती की क़ुर्बानी के लिए कुल चौबीस बैल, साठ मेंढे, साठ बकरे, साठ नर यक — साला बर्रे थे। मज़बह की तक़दीस के लिए जब वह मम्सूह हुआ इतना हदिया पेश करा गया। ");
INSERT INTO urd_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","और जब मूसा ख़ुदा से बातें करने को ख़ेमा — ए — इजितमा'अ में गया, तो उसने सरपोश पर से जो शहादत के सन्दूक़ के ऊपर था, दोनों करूबियों के बीच से वह आवाज़ सुनी जो उससे मुख़ातिब थी; और उसने उससे बातें की। ");
INSERT INTO urd_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","और ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“हारून से कह, जब तू चराग़ों को रोशन करे तो सातों चराग़ों की रोशनी शमा'दान के सामने हो।” ");
INSERT INTO urd_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","चुनाँचे हारून ने ऐसा ही किया, उसने चराग़ों को इस तरह जलाया कि शमा'दान के सामने रोशनी पड़े, जैसा ख़ुदावन्द ने मूसा को हुक्म दिया था। ");
INSERT INTO urd_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","और शमा'दान की बनावट ऐसी थी कि वह पाये से लेकर फूलों तक गढ़े हुए सोने का बना हुआ था। जो नमूना ख़ुदावन्द ने मूसा को दिखाया उसी के मुवाफ़िक उसने शमा'दान को बनाया। ");
INSERT INTO urd_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","और ख़ुदावन्द ने मूसा से कहा कि ");
INSERT INTO urd_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“लावियों को बनी — इस्राईल से अलग करके उनको पाक कर। ");
INSERT INTO urd_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","और उनको पाक करने के लिए उनके साथ यह करना, कि ख़ता का पानी लेकर उन पर छिड़कना; फिर वह अपने सारे जिस्म पर उस्तरा फिरवाएँ, और अपने कपड़े धोएँ, और अपने को साफ़ करें। ");
INSERT INTO urd_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","तब वह एक बछड़ा और उसके साथ की नज़्र की क़ुर्बानी के लिए तेल मिला हुआ मैदा लें, और तू ख़ता की क़ुर्बानी के लिए एक दूसरा बछड़ा भी लेना। ");
INSERT INTO urd_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","और तू लावियों को ख़ेमा — ए — इजितमा'अ के आगे हाज़िर करना और बनी — इस्राईल की सारी जमा'अत को जमा' करना। ");
INSERT INTO urd_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","फिर लावियों को ख़ुदावन्द के आगे लाना, तब बनी — इस्राईल अपने — अपने हाथ लावियों पर रख्खें। ");
INSERT INTO urd_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","और हारून लावियों की बनी — इस्राईल की तरफ़ से हिलाने की क़ुर्बानी के लिए ख़ुदावन्द के सामने पेश करे, ताकि वह ख़ुदावन्द की ख़िदमत करने पर रहें। ");
INSERT INTO urd_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","फिर लावी अपने — अपने हाथ बछड़ों के सिरों पर रख्खें, और तू एक को ख़ता की क़ुर्बानी और दूसरे को सोख़्तनी क़ुर्बानी के लिए ख़ुदावन्द के सामने पेश करना, ताकि लावियों के वास्ते कफ़्फ़ारा दिया जाए। ");
INSERT INTO urd_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","फिर तू लावियों को हारून और उसके बेटों के आगे खड़ा करना और उनको हिलाने की क़ुर्बानी के लिए ख़ुदावन्द के सामने पेश करना। ");
INSERT INTO urd_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","“यूँ तू लावियों को बनी — इस्राईल से अलग करना और लावी मेरे ही ठहरेंगे। ");
INSERT INTO urd_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","इसके बाद लावी ख़ेमा — ए — इजितमा'अ की ख़िदमत के लिए अन्दर आया करें, इसलिए तू उनको पाक कर और हिलाने की क़ुर्बानी के लिए उनको पेश करना। ");
INSERT INTO urd_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","इसलिए कि वह सब बनी — इस्राईल में से मुझे बिल्कुल दे दिए गए हैं, क्यूँकि मैंने इन ही को उन सभों के बदले जो इस्राईलियों में पहलौठी के बच्चे हैं, अपने लिए ले लिया है। ");
INSERT INTO urd_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","इसलिए कि बनी — इस्राईल के सब पहलौठे, क्या इंसान क्या हैवान मेरे हैं, मैंने जिस दिन मुल्क — ए — मिस्र के पहलौठों को मारा उसी दिन उनको अपने लिए पाक किया। ");
INSERT INTO urd_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","और बनी — इस्राईल के सब पहलौठों के बदले मैंने लावियों को ले लिया है। ");
INSERT INTO urd_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","और मैंने बनी — इस्राईल में से लावियों को लेकर उनको हारून और उसके बेटों को 'अता किया है, ताकि वह ख़ेमा — ए — इजितमा'अ में बनी — इस्राईल की जगह ख़िदमत करें और बनी — इस्राईल के लिए कफ़्फ़ारा दिया करें; ताकि जब बनी — इस्राईल हैकल के नज़दीक आएँ तो उनमें कोई वबा न फैले।” ");
INSERT INTO urd_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","चुनाँचे मूसा और हारून और बनी — इस्राईल की सारी जमा'अत ने लावियों से ऐसा ही किया; जो कुछ ख़ुदावन्द ने लावियों के बारे में मूसा को हुक्म दिया था, वैसा ही बनी — इस्राईल ने उनके साथ किया। ");
INSERT INTO urd_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","और लावियों ने अपने आप को गुनाह से पाक करके अपने कपड़े धोए, और हारून ने उनको हिलाने की क़ुर्बानी के लिए ख़ुदावन्द के सामने पेश करा, और हारून ने उनकी तरफ़ से कफ़्फ़ारा दिया ताकि वह पाक हो जाएँ। ");
INSERT INTO urd_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","इसके बाद लावी अपनी ख़िदमत बजा लाने को हारून और उसके बेटों के सामने ख़ेमा — ए — इजितमा'अ में जाने लगे। इसलिए जैसा ख़ुदावन्द ने लावियों के बारे में मूसा को हुक्म दिया था उन्होंने वैसा ही उनके साथ किया। ");
INSERT INTO urd_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","फिर ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“लावियों के मुत'अल्लिक़ जो बात है वह यह है, कि पच्चीस बरस से लेकर उससे ऊपर — ऊपर की उम्र में वह ख़ेमा — ए — इजितमा'अ की ख़िदमत के काम के लिए अन्दर हाज़िर हुआ करें। ");
INSERT INTO urd_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","और जब पचास बरस के हों तो फिर उस काम के लिए न आएँ और न ख़िदमत करें, ");
INSERT INTO urd_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","बल्कि ख़ेमा — ए — इजितमा'अ में अपने भाइयों के साथ निगहबानी के काम में मशग़ूल हों, और कोई ख़िदमत न करें। लावियों को जो — जो काम सौंपे जाएँ उनके मुत'अल्लिक़ तू उनसे ऐसा ही करना।” ");
INSERT INTO urd_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","बनी — इस्राईल के मुल्क — ए — मिस्र से निकलने के दूसरे बरस के पहले महीने में ख़ुदावन्द ने दश्त — ए — सीना में मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“बनी इस्राईल 'ईद — ए — फ़सह उसके मु'अय्यन वक़्त पर मनाएँ। ");
INSERT INTO urd_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","इसी महीने की चौदहवीं तारीख़ की शाम को तुम वक़्त — ए — मु'अय्यन पर यह 'ईद मनाना, और जितने उसके तौर तरीक़े और रसूम हैं, उन सभों के मुताबिक़ उसे मनाना।” ");
INSERT INTO urd_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","इसलिए मूसा ने बनी — इस्राईल को हुक्म किया कि 'ईद — ए — फ़सह करें। ");
INSERT INTO urd_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","और उन्होंने पहले महीने की चौदहवीं तारीख़ की शाम को दश्त — ए — सीना में 'ईद — ए — फ़सह की और बनी — इस्राईल ने सब पर, जो ख़ुदावन्द ने मूसा को हुक्म दिया था 'अमल किया। ");
INSERT INTO urd_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","और कई आदमी ऐसे थे जो किसी लाश की वजह से नापाक हो गए थे, वह उस दिन फ़सह न कर सके। इसलिए वह उसी दिन मूसा और हारून के पास आए, ");
INSERT INTO urd_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","और मूसा से कहने लगे, “हम एक लाश की वजह से नापाक हो रहे हैं; फिर भी हम और इस्राईलियों के साथ वक़्त — ए — मु'अय्यन पर ख़ुदावन्द की क़ुर्बानी पेश करने से क्यूँ रोके जाएँ?” ");
INSERT INTO urd_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","मूसा ने उनसे कहा, “ठहर जाओ, मैं ज़रा सुन लूँ कि ख़ुदावन्द तुम्हारे हक़ में क्या हुक्म करता है।” ");
INSERT INTO urd_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“बनी — इस्राईल से कह कि अगर कोई तुम में से या तुम्हारी नसल में से, किसी लाश की वजह से नापाक हो जाए या वह कहीं दूर सफ़र में हो तोभी वह ख़ुदावन्द के लिए 'ईद — ए — फ़सह करे। ");
INSERT INTO urd_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","वह दूसरे महीने की चौदहवीं तारीख़ की शाम को यह 'ईद मनाएँ और क़ुर्बानी के गोश्त को बे — ख़मीरी रोटियों और कड़वी तरकारियों के साथ खाएँ। ");
INSERT INTO urd_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","वह उसमें से कुछ भी सुबह के लिए बाक़ी न छोड़ें, और न उसकी कोई हड्डी तोड़ें, और फ़सह को उसके सारे तौर तरीक़े के मुताबिक़ मानें। ");
INSERT INTO urd_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","लेकिन जो आदमी पाक हो और सफ़र में भी न हो, अगर वह फ़सह करने से बाज़ रहे तो वह आदमी अपनी क़ौम में से अलग कर डाला जाएगा; क्यूँकि उसने मु'अय्यन वक़्त पर ख़ुदावन्द की क़ुर्बानी नहीं पेश कीं इसलिए उस आदमी का गुनाह उसी के सिर लगेगा। ");
INSERT INTO urd_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","और अगर कोई परदेसी तुम में क़याम करता हो और वह ख़ुदावन्द के लिए फ़सह करना चाहे, तो वह फ़सह के तौर तरीक़े और रसूम के मुताबिक़ उसे माने; तुम देसी और परदेसी दोनों के लिए एक ही क़ानून रखना।” ");
INSERT INTO urd_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","और जिस दिन घर या'नी ख़ेमा — ए — शहादत नस्ब हुआ उसी दिन बादल उस पर छा गया, और शाम को वह घर पर आग सा दिखाई दिया और सुबह तक वैसा ही रहा। ");
INSERT INTO urd_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","और हमेशा ऐसा ही हुआ करता था, कि बादल उस पर छाया रहता और रात को आग दिखाई देती थी। ");
INSERT INTO urd_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","और जब घर पर से वह बादल उठ जाता तो बनी — इस्राईल रवाना होते थे, और जिस जगह वह बादल जा कर ठहर जाता वहीं बनी — इस्राईल ख़ेमा लगाते थे। ");
INSERT INTO urd_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ख़ुदावन्द के हुक्म से बनी — इस्राईल रवाना होते, और ख़ुदावन्द ही के हुक्म से वह ख़ेमे लगाते थे; और जब तक बादल घर पर ठहरा रहता वह अपने ख़ेमे डाले पड़े रहते थे। ");
INSERT INTO urd_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","और जब बादल घर पर बहुत दिनों ठहरा रहता, तो बनी — इस्राईल ख़ुदावन्द के हुक्म को मानते और रवाना नहीं होते थे। ");
INSERT INTO urd_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","और कभी — कभी वह बादल चंद दिनों तक घर पर रहता, और तब भी वह ख़ुदावन्द के हुक्म से ख़ेमे लगाये रहते और ख़ुदावन्द ही के हुक्म से वह रवाना होते थे। ");
INSERT INTO urd_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","फिर कभी — कभी वह बादल शाम से सुबह तक ही रहता, तो जब वह सुबह को उठ जाता तब वह रवाना ते थे; और अगर वह रात दिन बराबर रहता, तो जब वह उठ जाता तब ही वह रवाना होते थे। ");
INSERT INTO urd_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","और जब तक वह बादल घर पर ठहरा रहता, चाहे दो दिन या एक महीने या एक बरस हो, तब तक बनी — इस्राईल अपने ख़ेमों में मक़ीम रहते और रवाना नहीं होते थे; पर जब वह उठ जाता तो वह रवाना होते थे। ");
INSERT INTO urd_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","ग़रज़ वह ख़ुदावन्द के हुक्म से मक़ाम करते और ख़ुदावन्द ही के हुक्म से रवाना होते थे; और जो हुक्म ख़ुदावन्द मूसा के ज़रिए' देता, वह ख़ुदावन्द के उस हुक्म को माना करते थे। ");
INSERT INTO urd_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","और ख़ुदावन्द ने मूसा से कहा कि, ");
INSERT INTO urd_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“अपने लिए चाँदी के दो नरसिंगे बनवा; वह दोनों गढ़कर बनाए जाएँ, तू उनको जमा'अत के बुलाने और लश्करों की रवानगी के लिए काम में लाना। ");
INSERT INTO urd_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","और जब वह दोनों नरसिंगे फूँकें, तो सारी जमा'अत ख़ेमा-ए-इजितमा'अ के दरवाज़े पर तेरे पास इकट्ठी हो जाए। ");
INSERT INTO urd_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","और अगर एक ही फूँके, तो वह रईस जो हज़ारों इस्राईलियों के सरदार हैं तेरे पास जमा' हो। ");
INSERT INTO urd_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","और जब तुम साँस बाँध कर ज़ोर से फूँको, तो वह लश्कर जो पश्चिम की तरफ़ हैं रवानगी करें। ");
INSERT INTO urd_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","जब तुम दोबारा साँस बाँध कर ज़ोर से फूँको, तो उन लश्करों को जो दख्खिन की तरफ़ हैं रवाना हो। इसलिए रवानगी के लिए साँस बाँध कर ज़ोर से नरसिंगा फूँका करें। ");
INSERT INTO urd_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","लेकिन जब जमा'अत को जमा' करना हो तब भी फूँकना, लेकिन साँस बाँध कर ज़ोर से न फूँकना। ");
INSERT INTO urd_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","और हारून के बेटे जो काहिन हैं वह नरसिंगे फूँका करें। यही तौर तरीक़े हमेशा तुम्हारी नसल — दर — नसल क़ाईम रहे। ");
INSERT INTO urd_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","और जब तुम अपने मुल्क में ऐसे दुश्मन से जो तुम को सताता हो लड़ने को निकलो, तो तुम नरसिंगों को साँस बाँध कर ज़ोर से फूँकना। इस हाल में ख़ुदावन्द तुम्हारे ख़ुदा के सामने तुम्हारी याद होगी और तुम अपने दुश्मनों से नजात पाओगे। ");
INSERT INTO urd_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","और तुम अपनी खुशी के दिन और अपनी मुक़र्ररा 'ईदों के दिन और अपने महीनों के शुरू' में अपनी सोख़्तनी कुर्बानियों और सलामती की कुर्बानियों के वक़्त नरसिंगे फूँकना ताकि उनसे तुम्हारे ख़ुदा के सामने तुम्हारी यादगारी हो; मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ।” ");
INSERT INTO urd_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","और दूसरे साल के दूसरे महीने की बीसवीं तारीख़ को वह बादल शहादत के घर पर से उठ गया। ");
INSERT INTO urd_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","तब बनी — इस्राईल सीना के जंगल से रवाना होकर निकले और वह बादल फारान के जंगल में ठहर गया। ");
INSERT INTO urd_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","इसलिए ख़ुदावन्द के उस हुक्म के मुताबिक़ जो उसने मूसा के ज़रिए' दिया था, उनकी पहली रवानगी हुई। ");
INSERT INTO urd_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","और सब से पहले बनी यहूदाह के लश्कर का झंडा रवाना हुआ और वह अपने दलों के मुताबिक़ चले, उनके लश्कर का सरदार 'अम्मीनदाब का बेटा नहसोन था। ");
INSERT INTO urd_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","और इश्कार के क़बीले के लश्कर का सरदार ज़ुग़र का बेटा नतनीएल था। ");
INSERT INTO urd_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","और ज़बूलून के क़बीले के लश्कर का सरदार हेलोन का बेटा इलियाब था। ");
INSERT INTO urd_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","फिर घर उतारा गया और बनी जैरसोन और बनी मिरारी, जो घर को उठाते थे रवाना हुए। ");
INSERT INTO urd_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","फिर रूबिन के लश्कर का झंडा आगे बढ़ा और वह अपने दलों के मुताबिक़ चले, शदियूर का बेटा इलीसूर उनके लश्कर का सरदार था। ");
INSERT INTO urd_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","और शमौन के क़बीले के लश्कर का सरदार सूरीशद्दी का बेटा सलूमीएल था। ");
INSERT INTO urd_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","और जद्द के क़बीले के लश्कर का सरदार द'ऊएल का बेटा इलियासफ़ था। ");
INSERT INTO urd_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","फिर क़िहातियों ने जो हैकल को उठाते थे रवानगी की, और उनके पहुँचने तक घर खड़ा कर दिया जाता था। ");
INSERT INTO urd_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","फिर बनी इफ़्राईम के लश्कर का झंडा निकला और वह अपने दलों के मुताबिक़ चले, उनके लश्कर का सरदार 'अम्मीहूद का बेटा इलीसमा' था। ");
INSERT INTO urd_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","और मनस्सी के क़बीले के लश्कर का सरदार फ़दाहसूर का बेटा जमलीएल था। ");
INSERT INTO urd_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","और बिनयमीन के क़बीले के लश्कर का सरदार जिद'औनी का बेटा अबिदान था। ");
INSERT INTO urd_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","और बनी दान के लश्कर का झंडा उनके सब लश्करों के पीछे — पीछे रवाना हुआ और वह अपने दलों के मुताबिक़ चले, उनके लश्कर का सरदार 'अम्मीशद्दी का बेटा अख़ी'अज़र था। ");
INSERT INTO urd_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","और आशर के क़बीले के लश्कर का सरदार 'अकरान का बेटा फ़ज'ईएल था। ");
INSERT INTO urd_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","और नफ़्ताली के क़बीले के लश्कर का सरदार एनान का बेटा अख़ीरा' था। ");
INSERT INTO urd_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","तब बनी — इस्राईल इसी तरह अपने दलों के मुताबिक़ कूच करते और आगे रवाना होते थे। ");
INSERT INTO urd_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","इसलिए मूसा ने अपने ससुर र'ऊएल मिदियानी के बेटे होबाब से कहा कि “हम उस जगह जा रहे हैं जिसके बारे में ख़ुदावन्द ने कहा है कि मैं उसे तुम को दूँगा; इसलिए तू भी साथ चल और हम तेरे साथ नेकी करेंगे, क्यूँकि ख़ुदावन्द ने बनी — इस्राईल से नेकी का वा'दा किया है।” ");
INSERT INTO urd_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","उसने उसे जवाब दिया, “मैं नहीं चलता, बल्कि मैं अपने वतन को और अपने रिश्तेदारों में लौट कर जाऊँगा।” ");
INSERT INTO urd_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","तब मूसा ने कहा, “हम को छोड़ मत, क्यूँकि यह तुझ को मा'लूम है कि हमको वीराने में किस तरह ख़ेमाज़न होना चाहिए, इसलिए तू हमारे लिए आँखों का काम देगा; ");
INSERT INTO urd_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","और अगर तू हमारे साथ चले, तो इतनी बात ज़रूर होगी कि जो नेकी ख़ुदावन्द हम से करे वही हम तुझ से करेंगे।” ");
INSERT INTO urd_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","फिर वह ख़ुदावन्द के पहाड़ से सफ़र करके तीन दिन की राह चले, और तीनों दिन के सफ़र में ख़ुदावन्द के 'अहद का संदूक़ उनके लिए आरामगाह तलाश करता हुआ उनके आगे — आगे चलता रहा। ");
INSERT INTO urd_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","और जब वह लश्करगाह से रवाना होते तो ख़ुदावन्द का बादल दिन भर उनके ऊपर छाया रहता था। ");
INSERT INTO urd_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","और संदूक़ की रवानगी के वक़्त मूसा यह कहा करता, “उठ, ऐ ख़ुदावन्द, तेरे दुश्मन तितर — बितर हो जाएँ, और जो तुझ से कीना रखते है वह तेरे आगे से भागें।” ");
INSERT INTO urd_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","और जब वह ठहर जाता तो वह यह कहता था, “ऐ ख़ुदावन्द, हज़ारों — हज़ार इस्राईलियों में लौट कर आ जा।” ");
INSERT INTO urd_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","फिर वह लोग़ कुड़कुड़ाने और ख़ुदावन्द के सुनते बुरा कहने लगे; चुनाँचे ख़ुदावन्द ने सुना और उसका ग़ज़ब भड़का और ख़ुदावन्द की आग उनके बीच जल उठी, और लश्करगाह को एक किनारे से भसम करने लगी। ");
INSERT INTO urd_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","तब लोगों ने मूसा से फ़रियाद की; और मूसा ने ख़ुदावन्द से दुआ की, तो आग बुझ गई। ");
INSERT INTO urd_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","और उस जगह का नाम तबे'रा पड़ा, क्यूँकि ख़ुदावन्द की आग उनमें जल उठी थी। ");
INSERT INTO urd_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","और जो मिली — जुली भीड़ इन लोगों में थी वह तरह — तरह की लालच करने लगी, और बनी — इस्राईल भी फिर रोने और कहने लगे, हम को कौन गोश्त खाने को देगा? ");
INSERT INTO urd_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","हम को वह मछली याद आती है जो हम मिस्र में मुफ़्त खाते थे; और हाय! वह खीरे, और वह ख़रबूज़े, और वह गन्दने, और प्याज़, और लहसन; ");
INSERT INTO urd_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","लेकिन अब तो हमारी जान ख़ुश्क हो गई, यहाँ कोई चीज़ मयस्सर नहीं और मन के अलावा हम को और कुछ दिखाई नहीं देता। ");
INSERT INTO urd_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","और मन धनिये की तरह था और ऐसा नज़र आता था जैसे मोती। ");
INSERT INTO urd_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","लोग इधर — उधर जा कर उसे जमा' करते और उसे चक्की में पीसते या ओखली में कूट लेते थे, फिर उसे हाण्डियों में उबाल कर रोटियाँ बनाते थे; उसका मज़ा ताज़ा तेल का सा था। ");
INSERT INTO urd_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","और रात को जब लश्करगाह में ओस पड़ती तो उसके साथ मन भी गिरता था। ");
INSERT INTO urd_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","और मूसा ने सब घरानों के आदमियों को अपने — अपने ख़ेमे के दरवाज़े पर रोते सुना, और ख़ुदावन्द का क़हर बहुत भड़का और मूसा ने भी बुरा माना। ");
INSERT INTO urd_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","तब मूसा ने ख़ुदावन्द से कहा, “तूने अपने ख़ादिम से यह सख़्त बर्ताव क्यूँ किया? और मुझ पर तेरे करम की नज़र क्यूँ नहीं हुई, जो तू इन सब लोगों का बोझ मुझ पर डालता है? ");
INSERT INTO urd_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","क्या यह सब लोग मेरे पेट में पड़े थे? क्या यह मुझ ही से पैदा हुए थे जो तू मुझे कहता है कि जिस तरह से बाप दूध पीते बच्चे को उठाए — उठाए फिरता है, उसी तरह मैं इन लोगों को अपनी गोद में उठा कर उस मुल्क में ले जाऊँ जिसके देने की क़सम तूने उनके बाप दादा से खाई है? ");
INSERT INTO urd_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","मैं इन सब लोगों को कहाँ से गोश्त ला कर दूँ? क्यूँकि वह यह कह — कह कर मेरे सामने रोते हैं, कि हम को गोश्त खाने को दे। ");
INSERT INTO urd_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","मैं अकेला इन सब लोगों को नहीं सम्भाल सकता, क्यूँकि यह मेरी ताक़त से बाहर है। ");
INSERT INTO urd_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","और जो तुझे मेरे साथ यही बर्ताव करना है तो मेरे ऊपर अगर तेरे करम की नज़र हुई है, तो मुझे एक ही बार में जान से मार डाल ताकि मैं अपनी बुरी हालत देखने न पाऊँ।” ");
INSERT INTO urd_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","ख़ुदावन्द ने मूसा से कहा, “बनी — इस्राईल के बुज़ुगों में से सत्तर मर्द, जिनको तू जानता है कि क़ौम के बुज़ुर्ग और उनके सरदार हैं मेरे सामने जमा' कर और उनको ख़ेमा — ए — इजितमा'अ के पास ले आ; ताकि वह तेरे साथ वहाँ खड़े हों। ");
INSERT INTO urd_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","और में उतर कर तेरे साथ वहाँ बातें करूँगा, और मैं उस रूह में से जो तुझ में है, कुछ लेकर उनमें डाल दूँगा कि वह तेरे साथ क़ौम का बोझ उठाएँ, ताकि तू उसे अकेला न उठाए। ");
INSERT INTO urd_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","और लोगों से कह कि कल के लिए अपने को पाक कर रख्खो तो तुम गोश्त खाओगे, क्यूँकि तुम ख़ुदावन्द के सुनते हुए यह कह — कह कर रोए हो कि हम को कौन गोश्त खाने को देगा? हम तो मिस्र ही में मौज से थे। इसलिए ख़ुदावन्द तुम को गोश्त देगा और तुम खाना। ");
INSERT INTO urd_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","और तुम एक या दो दिन नहीं और न पाँच या दस या बीस दिन, ");
INSERT INTO urd_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","बल्कि एक महीना कामिल उसे खाते रहोगे, जब तक वह तुम्हारे नथुनों से निकलने न लगे और तुम उससे घिन न खाने लगो; क्यूँकि तुम ने ख़ुदावन्द को जो तुम्हारे बीच है छोड़ दिया, और उसके सामने यह कह — कह कर रोए हो कि हम मिस्र से क्यूँ निकल आए?” ");
INSERT INTO urd_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","फिर मूसा कहने लगा, “जिन लोगों में मैं हूँ उनमें छः लाख तो प्यादे ही हैं; और तू ने कहा है कि मैं उनको इतना गोश्त दूँगा कि वह महीने भर उसे खाते रहेंगे। ");
INSERT INTO urd_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","इसलिए क्या भेड़बकरियों के यह रेवड़ और गाय — बैलों के झुण्ड उनकी ख़ातिर ज़बह हों कि उनके लिए बस हो? या समन्दर की सब मछलियाँ उनकी ख़ातिर इकट्ठी की जाएँ कि उन सब के लिए काफ़ी हो?” ");
INSERT INTO urd_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","ख़ुदावन्द ने मूसा से कहा, “क्या ख़ुदावन्द का हाथ छोटा हो गया है? अब तू देख लेगा कि जो मैंने तुझ से कहा है वह पूरा होता है या नहीं।” ");
INSERT INTO urd_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","तब मूसा ने बाहर जाकर ख़ुदावन्द की बातें उन लोगों को कह सुनाई, और क़ौम के बुज़ुर्गों में से सत्तर शख़्स इकट्ठे करके उनको ख़ेमे के चारों तरफ़ खड़ा कर दिया। ");
INSERT INTO urd_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","तब ख़ुदावन्द बादल में होकर उतरा और उसने मूसा से बातें कीं, और उस रूह में से जो उसमें थी कुछ लेकर उसे उन सत्तर बुज़ुगों में डाला; चुनाँचे जब रूह उनमें आई तो वह नबुव्वत करने लगे, लेकिन बाद में फिर कभी न की। ");
INSERT INTO urd_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","लेकिन उनमें से दो शख़्स लश्करगाह ही में रह गए, एक का नाम इलदाद और दूसरे का मेदाद था, उनमें भी रूह आई; यह भी उन्हीं में से थे जिनके नाम लिख लिए गए थे लेकिन यह खेमे के पास न गए, और लश्करगाह ही में नबुव्वत करने लगे। ");
INSERT INTO urd_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","तब किसी जवान ने दौड़ कर मूसा को ख़बर दी और कहने लगा, कि इलदाद और मेदाद लश्करगाह में नबुव्वत कर रहे हैं। ");
INSERT INTO urd_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","इसलिए मूसा के ख़ादिम नून के बेटे यशू'आ ने, जो उसके चुने हुए जवानों में से था मूसा से कहा, “ऐ मेरे मालिक मूसा, तू उनको रोक दे।” ");
INSERT INTO urd_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","मूसा ने उससे कहा, “क्या तुझे मेरी ख़ातिर रश्क आता है? काश ख़ुदावन्द के सब लोग नबी होते, और ख़ुदावन्द अपनी रूह उन सब में डालता।” ");
INSERT INTO urd_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","फिर मूसा और वह इस्राईली बुज़ुर्ग लश्करगाह में गए। ");
INSERT INTO urd_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","और ख़ुदावन्द की तरफ़ से एक आँधी चली और समन्दर से बटेरें उड़ा लाई, और उनको लश्करगाह के बराबर और उसके चारों तरफ़ एक दिन की राह तक इस तरफ़ और एक ही दिन की राह तक दूसरी तरफ़ ज़मीन से क़रीबन दो — दो हाथ ऊपर डाल दिया। ");
INSERT INTO urd_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","और लोगों ने उठ कर उस सारे दिन और उस सारी रात और उसके दूसरे दिन भी बटेरें जमा' कीं, और जिसने कम से कम जमा' की थीं उसके पास भी दस खोमर के बराबर जमा' हो गई; और उन्होंने अपने लिए लश्करगाह की चारों तरफ़ उनको फैला दिया। ");
INSERT INTO urd_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","और उनका गोश्त उन्होंने दाँतों से काटा ही था और उसे चबाने भी नहीं पाए थे कि ख़ुदावन्द का क़हर उन लोगों पर भड़क उठा, और ख़ुदावन्द ने उन लोगों को बड़ी सख़्त वबा से मारा। ");
INSERT INTO urd_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","इसलिए उस मक़ाम का नाम क़ब्रोत हतावा रखा गया, क्यूँकि उन्होंने उन लोगों को जिन्होंने लालच किया था वहीं दफ़न किया। ");
INSERT INTO urd_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","और वह लोग कब्रोत हतावा से सफ़र करके हसेरात को गए और वहीं हसेरात में रहने लगे। ");
INSERT INTO urd_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","और मूसा ने एक कूशी 'औरत से ब्याह कर लिया। तब उस कूशी 'औरत की वजह से जिसे मूसा ने ब्याह लिया था, मरियम और हारून उसकी बदगोई करने लगे। ");
INSERT INTO urd_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","वह कहने लगे, “क्या ख़ुदावन्द ने सिर्फ़ मूसा ही से बातें की हैं? क्या उसने हम से भी बातें नहीं कीं?” और ख़ुदावन्द ने यह सुना। ");
INSERT INTO urd_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","और मूसा तो इस ज़मीन के सब आदमियों से ज़्यादा हलीम था। ");
INSERT INTO urd_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","तब ख़ुदावन्द ने अचानक मूसा और हारून और मरियम से कहा, “तुम तीनों निकल कर ख़ेमा — ए — इजितमा'अ के पास हाज़िर हो।” तब वह तीनों वहाँ आए। ");
INSERT INTO urd_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","और ख़ुदावन्द बादल के सुतून में होकर उतरा और ख़ेमे के दरवाज़े पर खड़े होकर हारून और मरियम को बुलाया। वह दोनों पास गए। ");
INSERT INTO urd_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","तब उसने कहा, “मेरी बातें सुनो, अगर तुम में कोई नबी हो, तो मैं जो ख़ुदावन्द हूँ उसे रोया में दिखाई दूँगा और ख़्वाब में उससे बातें करूँगा। ");
INSERT INTO urd_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","पर मेरा ख़ादिम मूसा ऐसा नहीं है, वह मेरे सारे ख़ान्दान में अमानत दार है; ");
INSERT INTO urd_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","मैं उससे राज़ों में नहीं बल्कि आमने — सामने और सरीह तौर पर बातें करता हूँ, और उसे ख़ुदावन्द का दीदार भी नसीब होता है। इसलिए तुम को मेरे ख़ादिम मूसा की बदगोई करते ख़ौफ़ क्यूँ न आया?” ");
INSERT INTO urd_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","और ख़ुदावन्द का ग़ज़ब उन पर भड़का और वह चला गया। ");
INSERT INTO urd_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","और बादल ख़ेमे के ऊपर से हट गया, और मरियम कोढ़ से बर्फ़ की तरह सफ़ेद हो गई; और हारून ने जो मरियम की तरफ़ नज़र की तो देखा कि वह कोढ़ी हो गई है। ");
INSERT INTO urd_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","तब हारून मूसा से कहने लगा, “हाय मेरे मालिक, इस गुनाह को हमारे सिर न लगा, क्यूँकि हम से नादानी हुई और हम ने ख़ता की। ");
INSERT INTO urd_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","और मरियम की उस मरे हुए की तरह न रहने दे, जिसका जिस्म उसकी पैदाइश ही के वक़्त आधा गला हुआ होता है।” ");
INSERT INTO urd_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","तब मूसा ख़ुदावन्द से फ़रियाद करने लगा, “ऐ ख़ुदा, मैं तेरी मिन्नत करता हूँ, उसे शिफ़ा दे।” ");
INSERT INTO urd_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","और ख़ुदावन्द ने मूसा से कहा, “अगर उसके बाप ने उसके मुँह पर सिर्फ़ थूका ही होता, तो क्या सात दिन तक वह शर्मिन्दा न रहती? इसलिए वह सात दिन तक लश्करगाह के बाहर बन्द रहे, इसके बाद वह फिर अन्दर आने पाए।” ");
INSERT INTO urd_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","चुनाँचे मरियम सात दिन तक लश्करगाह के बाहर बन्द रही, और लोगों ने जब तक वह अन्दर आने न पाई रवाना न हुए। ");
INSERT INTO urd_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","इसके बाद वह लोग हसेरात से रवाना हुए और फ़ारान के जंगल में पहुँच कर उन्होंने ख़ेमे लगाए। ");
INSERT INTO urd_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","और ख़ुदावन्द ने मूसा से कहा कि, ");
INSERT INTO urd_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“तू आदमियों को भेज कि वह मुल्क — ए — कना'न का, जो मैं बनी — इस्राईल को देता हूँ हाल दरियाफ़्त करें; उनके बाप — दादा के हर क़बीले से एक आदमी भेजना जो उनके यहाँ का रईस हो।” ");
INSERT INTO urd_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","चुनाँचे मूसा ने ख़ुदावन्द के इरशाद के मुवाफ़िक़ फ़ारान के जंगल से ऐसे आदमी रवाना किए जो बनी — इस्राईल के सरदार थे। ");
INSERT INTO urd_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","उनके यह नाम थे: रूबिन के क़बीले से ज़कूर का बेटा सम्मूअ, ");
INSERT INTO urd_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","और शमौन के क़बीले से होरी का बेटा साफ़त, ");
INSERT INTO urd_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","और यहूदाह के क़बीले से यफुना का बेटा कालिब, ");
INSERT INTO urd_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","और इश्कार के क़बीले से युसुफ़ का बेटा इजाल, ");
INSERT INTO urd_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","और इफ़्राईम के क़बीले से नून का बेटा होसे'अ, ");
INSERT INTO urd_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","और बिनयमीन के क़बीले से रफू का बेटा फ़ल्ती, ");
INSERT INTO urd_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","और ज़बूलून के क़बीले से सोदी का बेटा जद्दीएल, ");
INSERT INTO urd_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","और यूसुफ़ के क़बीले या'नी मनस्सी के क़बीले से सूसी का बेटा जद्दी, ");
INSERT INTO urd_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","और दान के क़बीले से जमल्ली का बेटा 'अम्मीएल, ");
INSERT INTO urd_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","और आशर के क़बीले से मीकाएल का बेटा सतूर, ");
INSERT INTO urd_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","और नफ़्ताली के क़बीले से वुफ़सी का बेटा नख़बी, ");
INSERT INTO urd_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","और जद्द के क़बीले से माकी का बेटा ज्यूएल। ");
INSERT INTO urd_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","यही उन लोगों के नाम हैं जिनको मूसा ने मुल्क का हाल दरियाफ़्त करने को भेजा था। और नून के बेटे होसे'अ का नाम मूसा ने यशू'अ रख्खा। ");
INSERT INTO urd_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","और मूसा ने उनको रवाना किया ताकि मुल्क — ए — कना'न का हाल दरियाफ़्त करें और उनसे कहा, “तुम इधर दख्खिन की तरफ़ से जाकर पहाड़ों में चले जाना। ");
INSERT INTO urd_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","और देखना कि वह मुल्क कैसा है, और जो लोग वहाँ बसे हुए हैं वह कैसे हैं, ज़ोरावर हैं या कमज़ोर और थोड़े से हैं या बहुत। ");
INSERT INTO urd_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","और जिस मुल्क में वह आबाद हैं वह कैसा है, अच्छा है या बुरा; जिन शहरों में वह रहते हैं वह कैसे हैं, आया वह ख़ेमों में रहते हैं या किलों' में। ");
INSERT INTO urd_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","और वहाँ की ज़मीन कैसी है, ज़रखेज़ है या बंजर और उसमें दरख़्त हैं या नहीं; तुम्हारी हिम्मत बन्धी रहे और तुम उस मुल्क का कुछ फल लेते आना।” और वह मौसम अंगूर की पहली फ़सल का था। ");
INSERT INTO urd_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","तब वह रवाना हुए और दश्त — ए — सीन से रहोब तक जो हमात के रास्ते में है, मुल्क को ख़ूब देखा भाला। ");
INSERT INTO urd_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","और वह दख्खिन की तरफ़ से होते हुए हबरून तक गए, जहाँ 'अनाक के बेटे अख़ीमान और सीसी और तलमी रहते थे और हबरून जुअन से जो मिस्र में है, सात बरस आगे बसा था। ");
INSERT INTO urd_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","और वह वादी — ए — इस्काल में पहुँचे, वहाँ से उन्होंने अंगूर की एक डाली काट ली जिसमें एक ही गुच्छा था, और जिसे दो आदमी एक लाठी पर लटकाए हुए लेकर गए; और वह कुछ अनार और अंजीर भी लाए। ");
INSERT INTO urd_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","उसी गुच्छे की वजह से जिसे इस्राईलियों ने वहाँ से काटा था, उस जगह का नाम वादी — ए — इस्काल पड़ गया। ");
INSERT INTO urd_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","और चालीस दिन के बाद वह उस मुल्क का हाल दरियाफ़्त करके लौटे। ");
INSERT INTO urd_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","और वह चले और मूसा और हारून और बनी — इस्राईल की सारी जमा'अत के पास दश्त — ए — फ़ारान के क़ादिस में आए, और उनकी और सारी जमा'अत को सब हाल सुनाया, और उस मुल्क का फल उनको दिखाया। ");
INSERT INTO urd_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","और मूसा से कहने लगे, “जिस मुल्क में तूने हम को भेजा था हम वहाँ गए; वाक़'ई दूधऔर शहद उसमें बहता है, और यह वहाँ का फल है। ");
INSERT INTO urd_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","लेकिन जो लोग वहाँ बसे हुए हैं वह ज़ोरावर हैं और उनके शहर बड़े — बड़े और फ़सीलदार हैं, और हम ने बनी 'अनाक को भी वहाँ देखा। ");
INSERT INTO urd_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","उस मुल्क के दख्खिनी हिस्से में तो अमालीकी आबाद हैं, और हित्ती और यबूसी और अमोरी पहाड़ों पर रहते हैं, और समन्दर के साहिल पर और यरदन के किनारे — किनारे कना'नी बसे हुए हैं।” ");
INSERT INTO urd_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","तब कालिब ने मूसा के सामने लोगों को चुप कराया और कहा, “चलो, हम एक दम जा कर उस पर क़ब्ज़ा करें, क्यूँकि हम इस क़ाबिल हैं कि उस पर हासिल कर लें।” ");
INSERT INTO urd_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","लेकिन जो और आदमी उसके साथ गए थे वह कहने लगे, “हम इस लायक़ नहीं हैं कि उन लोगों पर हमला करें, क्यूँकि वह हम से ज़्यादा ताक़तवर हैं।” ");
INSERT INTO urd_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","इन आदमियों ने बनी — इस्राईल को उस मुल्क की, जिसे वह देखने गए थे बुरी ख़बर दी, और यह कहा, “वह मुल्क जिसका हाल दरियाफ़्त करने को हम उसमें से गुज़रे, एक ऐसा मुल्क है जो अपने बाशिन्दों को खा जाता है; और वहाँ जितने आदमी हम ने देखें वह सब बड़े क़द्दावर हैं। ");
INSERT INTO urd_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","और हम ने वहाँ बनी 'अनाक को भी देखा जो जब्बार हैं और जब्बारों की नसल से हैं, और हम तो अपनी ही निगाह में ऐसे थे जैसे टिड्डे होते हैं और ऐसे ही उनकी निगाह में थे।” ");
INSERT INTO urd_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","तब सारी जमा'अत ज़ोर ज़ोर से चीखने लगी और वह लोग उस रात रोते ही रहे। ");
INSERT INTO urd_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","और कुल बनी — इस्राईल मूसा और हारून की शिकायत करने लगे, और सारी जमा'त उनसे कहने लगी हाय काश हम मिस्र ही में मर जाते या काश इस वीरान ही में मरते। ");
INSERT INTO urd_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ख़ुदावन्द क्यूँ हम को उस मुल्क में ले जा कर तलवार से क़त्ल कराना चाहता है? ");
INSERT INTO urd_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","“फिर तो हमारी बीवियाँ और बाल बच्चे लूट का माल ठहरेंगे, क्या हमारे लिए बेहतर न होगा कि हम मिस्र को वापस चले जाएँ?” फिर वह आपस में कहने लगे, “आओ हम किसी को अपना सरदार बना लें, और मिस्र को लौट चलें।” ");
INSERT INTO urd_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","तब मूसा और हारून बनी — इस्राईल की सारी जमा'अत के सामने औधे मुँह हो गए। ");
INSERT INTO urd_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","और नून का बेटा यशू'अ और यफुन्ना का बेटा कालिब, जो उस मुल्क का हाल दरियाफ़्त करने वालों में से थे, अपने — अपने कपड़े फाड़ कर ");
INSERT INTO urd_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","बनी — इस्राईल की सारी जमा'अत से कहने लगे कि “वह मुल्क जिसका हाल दरियाफ़्त करने को हम उसमें से गुज़रे, बहुत अच्छा मुल्क है। ");
INSERT INTO urd_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","अगर ख़ुदा हम से राज़ी रहे तो वह हम को उस मुल्क में पहुँचाएगा, और वही मुल्क जिस में दूध और शहद बहता है हम को देगा। ");
INSERT INTO urd_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","सिर्फ़ इतना हो कि तुम ख़ुदावन्द से बग़ावत न करो और न उस मुल्क के लोगों से डरो; वह तो हमारी ख़ुराक हैं, उनकी पनाह उनके सिर पर से जाती रही है और हमारे साथ ख़ुदावन्द है; इसलिए उनका ख़ौफ़ न करो।” ");
INSERT INTO urd_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","तब सारी जमा'अत बोल उठी कि इनको संगसार करो। उस वक़्त ख़ेमा — ए — इजितमा'अ में सब बनी — इस्राईल के सामने ख़ुदावन्द का जलाल नुमायाँ हुआ। ");
INSERT INTO urd_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","और ख़ुदावन्द ने मूसा से कहा कि “यह लोग कब तक मेरी तौहीन करते रहेंगे? और बावजूद उन सब निशान — आत को जो मैंने इनके बीच किए हैं, कब तक मुझ पर ईमान नहीं लाएँगे? ");
INSERT INTO urd_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","में इनको वबा से मारूँगा और मीरास से ख़ारिज करूँगा, और तुझे एक ऐसी क़ौम बनाऊँगा जो इनसे कहीं बड़ी और ज़्यादा ज़ोरावर हो।” ");
INSERT INTO urd_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","मूसा ने ख़ुदावन्द से कहा, “तब तो मिस्री, जिनके बीच से तू इन लोगों को अपने ज़ोर — ए — बाज़ू से निकाल ले आया यह सुनेंगे, ");
INSERT INTO urd_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","और उसे इस मुल्क के बाशिन्दों को बताएँगे। उन्होंने सुना है कि तू जो ख़ुदावन्द है इन लोगों के बीच रहता है, क्यूँकि तू ऐ ख़ुदावन्द सरीह तौर पर दिखाई देता है, और तेरा बादल इन पर साया किए रहता है, और तू दिन को बादल के सुतून में और रात को आग के सुतून में हो कर इनके आगे — आगे चलता है। ");
INSERT INTO urd_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","तब अगर तू इस क़ौम को एक अकेले आदमी की तरह जान से मार डाले, तो वह क़ौमें जिन्होंने तेरी शोहरत सुनी कहेंगी; ");
INSERT INTO urd_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","कि चूँकि ख़ुदावन्द इस क़ौम को उस मुल्क में, जिसे उसने इनको देने की क़सम खाई थी पहुँचा न सका, इसलिए उसने इनको वीरान में हलाक कर दिया। ");
INSERT INTO urd_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","तब ख़ुदावन्द की क़ुदरत की 'अज़मत तेरे ही इस क़ौल के मुताबिक़ ज़ाहिर हो, ");
INSERT INTO urd_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","कि ख़ुदावन्द क़हर करने में धीमा और शफ़क़त में ग़नी है, वह गुनाह और ख़ता को बख़्श देता है लेकिन मुजरिम को हरगिज़ बरी नहीं करेगा, क्यूँकि वह बाप दादा के गुनाह की सज़ा उनकी औलाद को तीसरी और चौथी नसल तक देता है। ");
INSERT INTO urd_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","इसलिए तू अपनी रहमत की फ़िरावानी से इस उम्मत का गुनाह, जैसे तू मिस्र से लेकर यहाँ तक इन लोगों को मु'आफ़ करता रहा है अब भी मु'आफ़ कर दे।” ");
INSERT INTO urd_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","ख़ुदावन्द ने कहा, “मैंने तेरी दरख़्वास्त के मुताबिक़ मुआफ़ किया; ");
INSERT INTO urd_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","लेकिन मुझे अपनी हयात की क़सम और ख़ुदावन्द के जलाल की क़सम जिससे सारी ज़मीन मा'मूर होगी, ");
INSERT INTO urd_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","चूँकि इन सब लोगों ने जिन्होंने बावजूद मेरे जलाल के देखने के, और बावजूद उन निशान — आत को जो मैंने मिस्र में और इस वीरान में दिखाए, फिर भी दस बार मुझे आज़माया और मेरी बात नहीं मानी; ");
INSERT INTO urd_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","इसलिए वह उस मुल्क को जिसके देने की क़सम मैंने उनके बाप दादा से खाई थी देखने भी न पायेंगे और जिन्होंने मेरी तौहीन की है उन में से भी कोई उसे देखने नहीं पाएगा। ");
INSERT INTO urd_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","लेकिन इसलिए कि मेरे बन्दे कालिब का कुछ और ही मिज़ाज था और उसने मेरी पूरी पैरवी की है, मैं उसको उस मुल्क में जहाँ वह हो आया है पहुँचाऊँगा और उसकी औलाद उसकी वारिस होगी। ");
INSERT INTO urd_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","और वादी में तो 'अमालीकी और कना'नी बसे हुए हैं, इसलिए कल तुम घूम कर उस रास्ते से जो बहर — ए — कु़लजु़म को जाता है वीरान में दाख़िल हो जाओ।” ");
INSERT INTO urd_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","और ख़ुदावन्द ने मूसा और हारून से कहा, ");
INSERT INTO urd_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“मैं कब तक इस ख़बीस गिरोह की जो मेरी शिकायत करती रहती है, बर्दाश्त करूँ? बनी — इस्राईल जो मेरे बरख़िलाफ़ शिकायतें करते रहते हैं, मैंने वह सब शिकायतें सुनी हैं। ");
INSERT INTO urd_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","इसलिए तुम उससे कह दो, ख़ुदावन्द कहता है, मुझे अपनी हयात की क़सम है कि जैसा तुम ने मेरे सुनते कहा है, मैं तुम से ज़रूर वैसा ही करूँगा। ");
INSERT INTO urd_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","तुम्हारी लाशें इसी वीरान में पड़ी रहेंगी, और तुम्हारी सारी ता'दाद में से या 'नी बीस बरस से लेकर उससे ऊपर — ऊपर की उम्र के तुम सब जितने गिने गए, और मुझ पर शिकायत करते रहे, ");
INSERT INTO urd_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","इनमें से कोई उस मुल्क में, जिसके बारे में मैने क़सम खाई थी कि तुमको वहाँ बसाऊँगा, जाने न पाएगा, अलावा यफ़ुन्ना के बेटे कालिब और नून के बेटे यशू'अ के। ");
INSERT INTO urd_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","और तुम्हारे बाल — बच्चे जिनके बारे में तुम ने यह कहा कि वह तो लूट का माल ठहरेंगे, उनको मैं वहाँ पहुँचाऊगा, और जिस मुल्क को तुम ने हक़ीर जाना वह उसकी हक़ीक़त पहचानेंगे। ");
INSERT INTO urd_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","और तुम्हारा यह हाल होगा कि तुम्हारी लाशें इसी वीरान में पड़ी रहेंगी। ");
INSERT INTO urd_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","और तुम्हारे लड़के बाले चालीस बरस तक वीरान में आवारा फिरते और तुम्हारी ज़िनाकारियों का फल पाते रहेंगे, जब तक कि तुम्हारी लाशें वीरान में गल न जाएँ। ");
INSERT INTO urd_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","उन चालीस दिनों के हिसाब से जिनमें तुम उस मुल्क का हाल दरियाफ़्त करते रहे थे, अब दिन पीछे एक — एक बरस या'नी चालीस बरस तक, तुम अपने गुनाहों का फल पाते रहोगे; तब तुम मेरे मुख़ालिफ़ हो जाने को समझोगे। ");
INSERT INTO urd_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","मैं ख़ुदावन्द यह कह चुका हूँ कि मैं इस पूरी ख़बीस गिरोह से जो मेरी मुखालिफ़त पर मुत्तफ़िक़ है क़त'ई ऐसा ही करूँगा, इनका ख़ातमा इसी वीरान में होगा और वह यहीं मरेंगे।” ");
INSERT INTO urd_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","और जिन आदमियों को मूसा ने मुल्क का हाल दरियाफ़्त करने को भेजा था, जिन्होंने लौट कर उस मुल्क की ऐसी बुरी ख़बर सुनाई थी, जिससे सारी जमा'अत मूसा पर कुड़कुड़ाने लगी, ");
INSERT INTO urd_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","इसलिए वह आदमी जिन्होंने मुल्क की बुरी ख़बर दी थी ख़ुदावन्द के सामने वबा से मर गए। ");
INSERT INTO urd_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","लेकिन जो आदमी उस मुल्क का हाल दरियाफ़्त करने गए थे उनमें से नून का बेटा यशू'अ और यफ़ुन्ना का बेटा कालिब दोनों जीते बचे रहे। ");
INSERT INTO urd_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","और मूसा ने यह बातें सब बनी इस्राईल से कहीं, तब वह लोग ज़ार — ज़ार रोए। ");
INSERT INTO urd_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","और वह दूसरे दिन सुबह सवेरे उठ कर यह कहते हुए पहाड़ की चोटी पर चढ़ने लगे, कि हम हाज़िर हैं और जिस जगह का वा'दा ख़ुदावन्द ने किया है वहाँ जाएँगे क्यूँकि हम से ख़ता हुई है। ");
INSERT INTO urd_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","मूसा ने कहा, “तुम क्यूँ अब ख़ुदावन्द की हुक्म उदूली करते हो? इससे कोई फ़ाइदा न होगा। ");
INSERT INTO urd_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","ऊपर मत चढ़ो क्यूँकि ख़ुदावन्द तुम्हारे बीच नहीं है ऐसा न हो कि अपने दुश्मनों के मुक़ाबले में शिकस्त खाओ। ");
INSERT INTO urd_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","क्यूँकि वहाँ तुम से आगे 'अमालीक़ी और कना'नी लोग हैं, इसलिए तुम तलवार से मारे जाओगे; क्यूँकि ख़ुदावन्द से तुम फिर गए हो, इसलिए ख़ुदावन्द तुम्हारे साथ नहीं रहेगा।” ");
INSERT INTO urd_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","लेकिन वह शोख़ी करके पहाड़ की चोटी तक चढ़े चले गए, लेकिन ख़ुदावन्द के 'अहद का सन्दूक़ और मूसा लश्करगाह से बाहर न निकले। ");
INSERT INTO urd_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","तब 'अमालीक़ी और कना'नी जो उस पहाड़ पर रहते थे, उन पर आ पड़े और उनको क़त्ल किया और हुरमा तक उनको मारते चले आए। ");
INSERT INTO urd_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“बनी — इस्राईल से कह कि जब तुम अपने रहने के मुल्क में जो मैं तुम को देता हूँ पहुँचो ");
INSERT INTO urd_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","और ख़ुदावन्द के सामने आतिशी क़ुर्बानी, या'नी सोख़्तनी क़ुर्बानी या ख़ास मिन्नत का ज़बीहा या रज़ा की क़ुर्बानी पेश करो, या अपनी मु'अय्यन 'ईदों में राहतअंगेज़ ख़ुशबू के तौर पर ख़ुदावन्द के सामने गाय बैल या भेड़ बकरी चढ़ाओ। ");
INSERT INTO urd_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","तो जो शख़्स अपना हदिया लाए, वह ख़ुदावन्द के सामने नज़्र की क़ुर्बानी के तौर पर ऐफ़ा के दस्वें हिस्से के बराबर मैदा जिसमें चौथाई हीन के बराबर तेल मिला हुआ हो, ");
INSERT INTO urd_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","और तपावन के तौर पर चौथाई हीन के बराबर मय भी लाए; तू अपनी सोख़्तनी क़ुर्बानी या अपने ज़बीहे के हर बर्रे के साथ इतना ही तैयार किया करना। ");
INSERT INTO urd_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","और हर मेंढे के साथ ऐफ़ा के पाँचवे हिस्से के बराबर मैदा, जिसमें तिहाई हीन के बराबर तेल मिला हुआ हो, नज़्र की क़ुर्बानी के तौर पर लाना। ");
INSERT INTO urd_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","और तपावन के तौर पर तिहाई हीन के बराबर मय देना, ताकि वह ख़ुदावन्द के सामने राहतअंगेज़ ख़ुशबू ठहरे। ");
INSERT INTO urd_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","और जब तू ख़ुदावन्द के सामने सोख़्तनी क़ुर्बानी या ख़ास मिन्नत के ज़बीहे या सलामती के ज़बीहे के तौर पर बछड़ा पेश करे, ");
INSERT INTO urd_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","तो वह उस बछड़े के साथ नज़्र की क़ुर्बानी के तौर पर ऐफ़ा के तीन दहाई हिस्से के बराबर मैदा, जिसमें आधे हीन के बराबर तेल मिला हुआ हो चढ़ाए। ");
INSERT INTO urd_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","और तू तपावन के तौर पर आधे हीन के बराबर मय पेश करना, ताकि वह ख़ुदावन्द के सामने राहतअंगेज़ ख़ुशबू की आतिशी क़ुर्बानी ठहरे। ");
INSERT INTO urd_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“हर बछड़े, और हर मेंढे, और हर नर बर्रे या बकरी के बच्चे के लिए ऐसा ही किया जाए। ");
INSERT INTO urd_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","तुम जितने जानवर लाओ, उनके शुमार के मुताबिक़ एक — एक के साथ ऐसा ही करना। ");
INSERT INTO urd_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","जितने देसी ख़ुदावन्द के सामने राहतअंगेज़ ख़ुशबू की आतिशी क़ुर्बानी पेश करें वह उस वक़्त यह सब काम इसी तरीक़े से करें। ");
INSERT INTO urd_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","और अगर कोई परदेसी तुम्हारे साथ क़याम करता हो या जो कोई नसलों से तुम्हारे साथ रहता आया हो, और वह ख़ुदावन्द के सामने राहतअंगेज़ ख़ुशबू की आतिशीन क़ुर्बानी पेश करना चाहे तो जैसा तुम करते हो वह भी वैसा ही करे। ");
INSERT INTO urd_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","मजमे' के लिए, या'नी तुम्हारे लिए और उस परदेसी के लिए जो तुम में रहता हो नसल — दर — नसल हमेशा एक ही क़ानून रहेगा; ख़ुदावन्द के आगे परदेसी भी वैसे ही हों जैसे तुम हो। ");
INSERT INTO urd_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","तुम्हारे लिए और परदेसियों के लिए जो तुम्हारे साथ रहते हैं एक ही शरी'अत और एक ही क़ानून हो।” ");
INSERT INTO urd_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","और ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“बनी — इस्राईल से कह, जब तुम उस मुल्क में पहुँचो, जहाँ मैं तुम को लिए जाता हूँ, ");
INSERT INTO urd_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","और उस मुल्क की रोटी खाओ तो ख़ुदावन्द के सामने उठाने की क़ुर्बानी पेश करना। ");
INSERT INTO urd_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","तुम अपने पहले गूँधे हुए आटे का एक गिर्दा उठाने की क़ुर्बानी के तौर पर अदा करना, जैसे खलीहान की उठाने की क़ुर्बानी को लेकर उठाते हो वैसे ही इसे भी उठाना। ");
INSERT INTO urd_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","तुम अपनी नसल — दर — नसल अपने पहले ही गूँधे हुए आटे में से कुछ लेकर उसे ख़ुदावन्द के सामने उठाने की क़ुर्बानी के तौर पर पेश करना। ");
INSERT INTO urd_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“और अगर तुम से भूल हो जाए और तुमने उन सब हुक्मों पर जो ख़ुदावन्द ने मूसा को दिए 'अमल न किया हो, ");
INSERT INTO urd_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","या'नी जिस दिन से ख़ुदावन्द ने हुक्म देना शुरू' किया उस दिन से लेकर आगे — आगे, जो कुछ हुक्म ख़ुदावन्द ने तुम्हारी नसल — दर — नसल मूसा के ज़रिए' तुम को दिया है, ");
INSERT INTO urd_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","उसमें अगर अनजाने में कोई ख़ता हो गई हो और जमा'अत उससे वाक़िफ़ न हो तो सारी जमा'अत एक बछड़ा सोख़्तनी क़ुर्बानी के लिए पेश करे, ताकि वह ख़ुदावन्द के सामने राहतअंगेज़ ख़ुशबू हो, और उसके साथ शरा' के मुताबिक़ उसकी नज़्र की क़ुर्बानी और उसका तपावन भी चढ़ाए, और ख़ता की क़ुर्बानी के लिए एक बकरा पेश करे। ");
INSERT INTO urd_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","यूँ काहिन बनी — इस्राईल की सारी जमा'अत के लिए कफ़्फ़ारा दे तो उनकी मु'आफ़ी मिलेगी, क्यूँकि यह महज़ भूल थी और उन्होंने उस भूल के बदले वह क़ुर्बानी भी चढ़ाई जो ख़ुदावन्द के सामने आतिशी क़ुर्बानी ठहरती है, और ख़ता की क़ुर्बानी भी ख़ुदावन्द के सामने पेश कीं। ");
INSERT INTO urd_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","तब बनी — इस्राईल की सारी जमा'अत को और उन परदेसियों को भी जो उनमें रहते हैं मु'आफ़ी मिलेगी, क्यूँकि जमा'अत के ऐतबार से यह अनजाने में हुआ। ");
INSERT INTO urd_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","और अगर एक ही शख़्स अनजाने में ख़ता करे तो वह यक — साला बकरी ख़ता की क़ुर्बानी के लिए चढ़ाए।” ");
INSERT INTO urd_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","यूँ काहिन उस शख़्स की तरफ़ से जिसने अनजाने में ख़ता की, उसकी ख़ता के लिए ख़ुदावन्द के सामने कफ़्फ़ारा दे तो उसे मु'आफ़ी मिलेगी। ");
INSERT INTO urd_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","जिस शख़्स ने अनजाने में ख़ता की हो, उसके लिए तुम एक ही शरा' रखना चाहे वह बनी — इस्राईल में से देसी हो या परदेसी जो उनमें रहता हो। ");
INSERT INTO urd_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","लेकिन जो शख़्स बेख़ौफ़ हो कर गुनाह करे, चाहे वह देसी हो या परदेसी, वह ख़ुदावन्द की बे'इज़्ज़ती करता है; वह शख़्स अपने लोगों में से अलग किया जाएगा। ");
INSERT INTO urd_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","क्यूँकि उसने ख़ुदावन्द के कलाम की हिक़ारत की और उसके हुक्म को तोड़ डाला, वह शख़्स बिल्कुल अलग कर दिया जाएगा, उसका गुनाह उसी के सिर लगेगा।” ");
INSERT INTO urd_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","और जब बनी — इस्राईल वीरान में रहते थे, उन दिनों एक आदमी उनको सबत के दिन लकड़ियाँ जमा' करता हुआ मिला। ");
INSERT INTO urd_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","और जिनकी वह लकड़ियाँ जमा' करता हुआ मिला वह उसे मूसा और हारून और सारी जमा'अत के पास ले गए। ");
INSERT INTO urd_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","उन्होंने उसे हवालात में रख्खा, क्यूँकि उनको यह नहीं बताया गया था कि उसके साथ क्या करना चाहिए ");
INSERT INTO urd_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","तब ख़ुदावन्द ने मूसा से कहा, “यह शख़्स ज़रूर जान से मारा जाए; सारी जमा'अत लश्करगाह के बाहर उसे पथराव करे।” ");
INSERT INTO urd_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","चुनाँचे जैसा ख़ुदावन्द ने मूसा को हुक्म दिया था, उसके मुताबिक़ सारी जमा'अत ने उसे लश्करगाह के बाहर ले जाकर पथराव किया और वह मर गया। ");
INSERT INTO urd_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“बनी — इस्राईल से कह कि वह नसल — दर — नसल अपने लिबासों के किनारों पर झालर लगाएँ, और हर किनारे की झालर के ऊपर आसमानी रंग का डोरा टाँके। ");
INSERT INTO urd_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","यह झालर तुम्हारे लिए ऐसी हो कि जब तुम उसे देखो तो ख़ुदावन्द के सारे हुक्मों को याद करके उन पर 'अमल करो और अपने दिल और आँखों की ख़्वाहिशों की पैरवी में ज़िनाकारी न करते फिरो जैसा करते आए हो; ");
INSERT INTO urd_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","बल्कि मेरे सब हुक्मों को याद करके उनको 'अमल में लाओ और अपने ख़ुदा के लिए पाक हो। ");
INSERT INTO urd_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ, जो तुम को मुल्क — ए — मिस्र से निकाल कर लाया ताकि तुम्हारा ख़ुदा ठहरूँ। मैं ख़ुदावन्द तुम्हारा ख़ुदा हूँ।” ");
INSERT INTO urd_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","और क़ोरह बिन इज़हार बिन क़िहात बिन लावी ने बनी रूबिन में से इलियाब के बेटों दातन और अबीराम, और पलत के बेटे ओन के साथ मिल कर और आदमियों को साथ लिया; ");
INSERT INTO urd_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","और वह और बनी — इस्राईल में से ढाई सौ और अश्ख़ास जो जमा'अत के सरदार और चीदा और मशहूर आदमी थे, मूसा के मुक़ाबले में उठे; ");
INSERT INTO urd_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","और वह मूसा और हारून के ख़िलाफ़ इकट्ठे होकर उनसे कहने लगे, “तुम्हारे तो बड़े दा'वे हो चले, क्यूँकि जमा'अत का एक — एक आदमी पाक है और ख़ुदावन्द उनके बीच रहता है। इसलिए तुम अपने आप को ख़ुदावन्द की जमा'अत से बड़ा क्यूँकर ठहराते हो?” ");
INSERT INTO urd_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","मूसा यह सुन कर मुँह के बल गिरा। ");
INSERT INTO urd_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","फिर उसने क़ोरह और उसके कुल फ़रीक़ से कहा कि “कल सुबह ख़ुदावन्द दिखा देगा कि कौन उसका है और कौन पाक है और वह उसी को अपने नज़दीक आने देगा, क्यूँकि जिसे वह ख़ुद चुनेगा उसे वह अपनी क़ुरबत भी देगा। ");
INSERT INTO urd_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","इसलिए ऐ क़ोरह और उसके फ़रीक़ के लोगों, तुम यूँ करो कि अपना अपना ख़ुशबूदान लो, ");
INSERT INTO urd_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","और उनमें आग भरो और ख़ुदावन्द के सामने कल उनमें ख़ुशबू जलाओ, तब जिस शख़्स को ख़ुदावन्द चुन ले वही पाक ठहरेगा। ऐ लावी के बेटो, बड़े — बड़े दा'वे तो तुम्हारे हैं।” ");
INSERT INTO urd_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","फिर मूसा ने क़ोरह की तरफ़ मुख़ातिब होकर कहा, ऐ बनी लावी सुनो, ");
INSERT INTO urd_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","क्या यह तुम को छोटी बात दिखाई देती है कि इस्राईल के ख़ुदा ने तुम को बनी — इस्राईल की जमा'अत में से चुन कर अलग किया, ताकि तुम को वह अपनी क़ुरबत बख़्शे और तुम ख़ुदावन्द के घर की ख़िदमत करो, और जमा'अत के आगे खड़े हो कर उसकी भी ख़िदमत बजा लाओ। ");
INSERT INTO urd_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","और तुझे और तेरे सब भाइयों को जो बनी लावी हैं, अपने नज़दीक आने दिया? इसलिए क्या अब तुम कहानत को भी चाहते हो? ");
INSERT INTO urd_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","इसीलिए तू और तेरे फ़रीक़ के लोग, यह सब के सब ख़ुदावन्द के खिलाफ़ इकट्ठे हुए हैं; और हारून कौन है जो तुम उस की शिकायत करते हो?” ");
INSERT INTO urd_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","फिर मूसा ने दातन और अबीराम को जो इलियाब के बेटे थे बुलवा भेजा; उन्होंने कहा, “हम नहीं आते; ");
INSERT INTO urd_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","क्या यह छोटी बात है कि तू हम को एक ऐसे मुल्क से, जिसमें दूध और शहद बहता है निकाल लाया है, कि हमको वीरान में हलाक करे, और उस पर भी यह तुर्रा है कि अब तू सरदार बन कर हम पर हुकूमत जताता है? ");
INSERT INTO urd_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","इसके अलावा तूने हम को उस मुल्क में भी नहीं पहुँचाया जहाँ दूध और शहद बहता है, और न हम को खेतों और ताकिस्तानों का वारिस बनाया; क्या तू इन लोगों की आँखें निकाल डालेगा? हम तो नहीं आने के।” ");
INSERT INTO urd_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","तब मूसा बहुत तैश में आ कर ख़ुदावन्द से कहने लगा, “तू उनके हदिये की तरफ़ तवज्जुह मत कर। मैंने उनसे एक गधा भी नहीं लिया, न उनमें से किसी को कोई नुक़सान पहुँचाया है।” ");
INSERT INTO urd_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","फिर मूसा ने क़ोरह से कहा, “कल तू अपने सारे फ़रीक़ के लोगों को लेकर ख़ुदावन्द के आगे हाज़िर हो; तू भी हो और वह भी हों, और हारून भी हो। ");
INSERT INTO urd_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","और तुम में से हर शख़्स अपना ख़ुशबूदान लेकर उसमें ख़ुशबू डाले, और तुम अपने — अपने ख़ुशबूदान को जो शुमार में ढाई सौ होंगे, ख़ुदावन्द के सामने लाओ और तू भी अपना ख़ुशबूदान लाना और हारून भी लाए।” ");
INSERT INTO urd_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","तब उन्होंने अपना अपना ख़ुशबूदान लेकर और उनमें आग रख कर उस पर ख़ुशबू डाला, और ख़ेमा — ए — इजितमा'अ के दरवाज़े पर मूसा और हारून के साथ आ कर खड़े हुए। ");
INSERT INTO urd_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","और क़ोरह ने सारी जमा'अत को उनके खिलाफ़ ख़ेमा — ए — इजितमा'अ के दरवाज़े पर जमा' कर लिया था। तब ख़ुदावन्द का जलाल सारी जमा'अत के सामने नुमायाँ हुआ। ");
INSERT INTO urd_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","और ख़ुदावन्द ने मूसा और हारून से कहा; ");
INSERT INTO urd_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","कि “तुम अपने आप को इस जमा'अत से बिल्कुल अलग कर लो, ताकि मैं उनको एक पल में भसम कर दूँ।” ");
INSERT INTO urd_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","तब वह मुँह के बल गिर कर कहने लगे, “ऐ ख़ुदा, सब बशर की रूहों के ख़ुदा! क्या एक आदमी के गुनाह की वजह से तेरा क़हर सारी जमा'अत पर होगा?” ");
INSERT INTO urd_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","तब ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“तू जमा'अत से कह कि तुम क़ोरह और दातन और अबीराम के खेमों के आस पास से दूर हट जाओ।” ");
INSERT INTO urd_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","और मूसा उठ कर दातन और अबीराम की तरफ़ गया, और बनी — इस्राईल के बुज़ुर्ग उसके पीछे पीछे गए। ");
INSERT INTO urd_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","और उसने जमा'अत से कहा, “इन शरीर आदमियों के खेमों से निकल जाओ और उनकी किसी चीज़ को हाथ न लगाओ, ऐसा न हो कि तुम भी उनके सब गुनाहों की वजह से हलाक हो जाओ।” ");
INSERT INTO urd_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","तब वह लोग क़ोरह और दातन और अबीराम के खेमों के आस पास से दूर हट गए; और दातन और अबीराम अपनी बीवियों और बेटों और बाल — बच्चों समेत निकल कर अपने ख़ेमों के दरवाज़ों पर खड़े हुए। ");
INSERT INTO urd_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","तब मूसा ने कहा, “इस से तुम जान लोगे के ख़ुदावन्द ने मुझे भेजा है कि यह सब काम करूँ, क्यूँकि मैंने अपनी मर्ज़ी से कुछ नहीं किया। ");
INSERT INTO urd_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","अगर यह आदमी वैसी ही मौत से मरें जो सब लोगों को आती है, या इन पर वैसे ही हादसे गुज़रें जो सब पर गुज़रते हैं, तो मैं ख़ुदावन्द का भेजा हुआ नहीं हूँ। ");
INSERT INTO urd_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","लेकिन अगर ख़ुदावन्द कोई नया करिश्मा दिखाए, और ज़मीन अपना मुँह खोल दे और इनको इनके घर — बार के साथ निगल जाए और यह जीते जी पाताल में समा जाएँ, तो तुम जानना कि इन लोगों ने ख़ुदावन्द की तहक़ीर की है।” ");
INSERT INTO urd_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","उसने यह बातें ख़त्म ही की थीं कि ज़मीन उनके पाओं तले फट गई। ");
INSERT INTO urd_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","और ज़मीन ने अपना मुँह खोल दिया और उनको और उनके घर — बार को, और क़ोरह के यहाँ के सब आदमियों को और उनके सारे माल — ओ — अस्बाब को निगल गई। ");
INSERT INTO urd_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","तब वह और उनका सारा घर — बार जीते जो पाताल में समा गए और ज़मीन उनके ऊपर बराबर हो गई, और वह जमा'अत में से ख़त्म हो गए। ");
INSERT INTO urd_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","और सब इस्राईली जो उनके आस पास थे उनका चिल्लाना सुन कर यह कहते हुए भागे, कि कहीं ज़मीन हम को भी निगल न ले। ");
INSERT INTO urd_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","और ख़ुदावन्द के सामने से आग निकली और उन ढाई सौ आदमियों को जिन्होंने ख़ुशबू पेश करा था भसम कर डाला। ");
INSERT INTO urd_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","और ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“हारून काहिन के बेटे इली'एलियाज़र से कह कि वह ख़ुशबूदान को शोलों में से उठा ले और आग के अंगारों को उधर ही बिखेर दे क्यूँकि वह पाक हैं। ");
INSERT INTO urd_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","जो ख़ताकार अपनी ही जान के दुश्मन हुए, उनके ख़ुशबूदानों के पीट पीट कर पत्तर बनाए जाएँ ताकि वह मज़बह पर मंढे जाएँ, क्यूँकि उन्होंने उनको ख़ुदावन्द के सामने रख्खा था इसलिए वह पाक हैं, और वह बनी — इस्राईल के लिए एक निशान भी ठहरेंगे।” ");
INSERT INTO urd_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","तब इली'एलियाज़र काहिन ने पीतल के उन ख़ुशबूदानों को उठा लिया जिनमें उन्होंने जो भसम कर दिए गए थे ख़ुशबू पेश करा था, और मज़बह पर मंढने के लिए उनके पत्तर बनवाए: ");
INSERT INTO urd_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ताकि बनी — इस्राईल के लिए एक यादगार हो कि कोई ग़ैर शख़्स जो हारून की नसल से नहीं, ख़ुदावन्द के सामने ख़ुशबू जलाने को नज़दीक न जाए, ऐसा न हो कि वह क़ोरह और उसके फ़रीक़ की तरह हलाक हो, जैसा ख़ुदावन्द ने उसको मूसा के ज़रिए' बता दिया था। ");
INSERT INTO urd_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","लेकिन दूसरे ही दिन बनी — इस्राईल की सारी जमाअत ने मूसा और हारून की शिकायत की और कहने लगे, कि तुम ने ख़ुदावन्द के लोगों को मार डाला है। ");
INSERT INTO urd_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","और जब वह जमा'अत मूसा और हारून के ख़िलाफ़ इकट्ठी हो रही थी तो उन्होंने ख़ेमा — ए — इजितमा'अ की तरफ़ निगाह की, और देखा कि बादल उस पर छाया हुआ है और ख़ुदावन्द का जलाल नुमायाँ है। ");
INSERT INTO urd_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","तब मूसा और हारून ख़ेमा — ए — इजितमा'अ के सामने आए। ");
INSERT INTO urd_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","और ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“तुम इस जमा'अत के बीच से हट जाओ, ताकि मैं इनको एक पल में भसम कर डालूँ।” तब वह मुँह के बल गिरे। ");
INSERT INTO urd_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","और मूसा ने हारून से कहा, “अपना ख़ुशबूदान ले और मज़बह पर से आग लेकर उसमें डाल और उस पर ख़ुशबू जला, और जल्द जमा'अत के पास जाकर उनके लिए कफ़्फ़ारा दे क्यूँकि ख़ुदावन्द का क़हर नाज़िल हुआ है और वबा शुरू' हो गई।” ");
INSERT INTO urd_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","मूसा के कहने के मुताबिक़ हारून ख़ुशबूदान लेकर जमा'अत के बीच में दौड़ता हुआ गया और देखा कि वबा लोगों में फैलने लगी है, तब उसने ख़ुशबू जलायी और उन लोगों के लिए कफ़्फ़ारा दिया। ");
INSERT INTO urd_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","और वह मुर्दों और ज़िन्दों के बीच में खड़ा हुआ, तब वबा ख़त्म हुई। ");
INSERT INTO urd_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","तब 'अलावा उनके जो क़ोरह के मुआ'मिले की वजह से हलाक हुए थे, चौदह हज़ार सात सौ आदमी वबा से हलाक गए। ");
INSERT INTO urd_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","फिर हारून लौट कर ख़ेमा — ए — इजितमा'अ के दरवाज़े पर मूसा के पास आया और वबा ख़त्म हो गई। ");
INSERT INTO urd_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","फिर ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“बनी — इस्राईल से गुफ़्तगू करके उनके सब सरदारों से उनके आबाई ख़ान्दानों के मुताबिक, हर ख़ान्दान एक लाठी के हिसाब से बारह लाठियाँ ले; और हर सरदार का नाम उसी की लाठी पर लिख, ");
INSERT INTO urd_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","और लावी की लाठी पर हारून का नाम लिखना। क्यूँकि उनके आबाई ख़ान्दानों के हर सरदार के लिए एक लाठी होगी। ");
INSERT INTO urd_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","और उनको लेकर ख़ेमा — ए — इजितमा'अ में शहादत के सन्दूक के सामने जहाँ मैं तुम से मुलाक़ात करता हूँ रख देना। ");
INSERT INTO urd_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","और जिस शख़्स को मैं चुनूँगा उसकी लाठी से कलियाँ फूट निकलेंगी, और बनी — इस्राईल जो तुम पर कुड़कुड़ाते रहते हैं, वह कुड़कुड़ाना मैं अपने पास से दफ़ा' करूँगा।” ");
INSERT INTO urd_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","तब मूसा ने बनी — इस्राईल से गुफ़्तगू की, और उनके सब सरदारों ने अपने आबाई ख़ान्दानों के मुताबिक़ हर सरदार एक लाठी के हिसाब से बारह लाठियाँ उस को दीं; और हारून की लाठी भी उनकी लाठियों में थी। ");
INSERT INTO urd_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","और मूसा ने उन लाठियों को शहादत के ख़ेमे में ख़ुदावन्द के सामने रख दिया। ");
INSERT INTO urd_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","और दूसरे दिन जब मूसा शहादत के ख़ेमे में गया, तो देखा कि हारून की लाठी में जो लावी के ख़ान्दान के नाम की थी कलियाँ फूटी हुई और शगूफ़े खिले हुए और पक्के बादाम लगे हैं। ");
INSERT INTO urd_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","और मूसा उन सब लाठियों को ख़ुदावन्द के सामने से निकाल कर सब बनी — इस्राईल के पास ले गया, और उन्होंने देखा और हर शख़्स ने अपनी लाठी ले ली। ");
INSERT INTO urd_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","और ख़ुदावन्द ने मूसा से कहा, “हारून की लाठी शहादत के सन्दूक़ के आगे धर दे, ताकि वह फ़ित्नाअंगेज़ों के लिए एक निशान के तौर पर रख्खी रहे, और इस तरह तू उनकी शिकायतें जो मेरे ख़िलाफ़ होती रहती हैं बन्द कर दे ताकि वह हलाक न हों।” ");
INSERT INTO urd_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","और मूसा ने जैसा ख़ुदावन्द ने उसे हुक्म दिया था वैसा ही किया। ");
INSERT INTO urd_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","और बनी — इस्राईल ने मूसा से कहा, “देख, हम हलाक हुए जाते, हम हलाक हुए जाते, हम सब के सब हलाक हुए जाते हैं। ");
INSERT INTO urd_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","जो कोई ख़ुदावन्द के घर के नज़दीक जाता है, मर जाता है। तो क्या हम सब के सब हलाक ही हो जाएँगे?” ");
INSERT INTO urd_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","और ख़ुदावन्द ने हारून से कहा कि, हैकल का बार — ए — गुनाह तुझ पर और तेरे बेटों और तेरे आबाई ख़ान्दान पर होगा, और तुम्हारी कहानत का बार — ए — गुनाह भी तुझ पर और तेरे बेटों पर होगा। ");
INSERT INTO urd_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","और तू लावी के क़बीले या'नी अपने बाप के क़बीले के लोगों को भी जो तेरे भाई हैं अपने साथ ले आया कर, ताकि वह तेरे साथ होकर तेरी ख़िदमत करें; लेकिन शहादत के ख़ेमे के आगे तू और तेरे बेटे ही आया करें। ");
INSERT INTO urd_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","वह तेरी ख़िदमत और सारे ख़ेमे की मुहाफ़िज़त करें; सिर्फ़ वह हैकल के बर्तनों और मज़बह के नज़दीक न जाएँ, ऐसा न हो कि वह भी और तुम भी हलाक हो जाओ। ");
INSERT INTO urd_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","इसलिए वह तेरे साथ होकर ख़ेमा — ए — इजितमा'अ और ख़ेमे के इस्ते'माल की सब चीज़ों की मुहाफ़िज़त करें, और कोई ग़ैर शख़्स तुम्हारे नज़दीक न आने पाए। ");
INSERT INTO urd_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","और तुम हैकल और मज़बह की मुहाफ़िज़त करो ताकि आगे को फिर बनी इस्राईल पर क़हर नाज़िल न हो। ");
INSERT INTO urd_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","और देखो, मैंने बनी लावी को जो तुम्हारे भाई हैं बनी — इस्राईल से अलग करके ख़ुदावन्द की ख़ातिर बख़्शिश के तौर पर तुम को सुपुर्द किया, ताकि वह ख़ेमा — ए — इजितमा'अ की ख़िदमत करें। ");
INSERT INTO urd_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","लेकिन मज़बह की और पर्दे के अन्दर की ख़िदमत तेरे और तेरे बेटों के ज़िम्मे है; इसलिए उसके लिए तुम अपनी कहानत की हिफ़ाज़त करना, वहाँ तुम ही ख़िदमत किया करना, कहानत की ख़िदमत का शर्फ़ मैं तुम को बख़्शता हूँ और जो ग़ैर शख़्स नज़दीक आए वह जान से मारा जाए। ");
INSERT INTO urd_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","फिर ख़ुदावन्द ने हारून से कहा, देख, मैंने बनी — इस्राईल की सब पाक चीज़ों में से उठाने की कुर्बानियाँ तुझे दे दीं; मैंने उनको तेरे मम्सूह होने का हक़ ठहराकर तुझे और तेरे बेटों को हमेशा के लिए दिया। ");
INSERT INTO urd_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","सबसे पाक चीज़ों में से जो कुछ आग से बचाया जाए वह तेरा होगा; उनके सब चढ़ावे, या'नी नज़्र की क़ुर्बानी और ख़ता की क़ुर्बानी और जुर्म की क़ुर्बानी जिनको वह मेरे सामने गुजरानें, वह तेरे और तेरे बेटों के लिए बहुत पाक ठहरें। ");
INSERT INTO urd_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","और तू उनको बहुत पाक जान कर खाना; मर्द ही मर्द उनको खाएँ, वह तेरे लिए पाक हैं। ");
INSERT INTO urd_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","और अपने हदिये में से जो कुछ बनी — इस्राईल उठाने की क़ुर्बानी और हिलाने की क़ुर्बानी के तौर पर पेश करें वह भी तेरा ही हो, इनको मैं तुझ को और तेरे बेटे — बेटियों को हमेशा के हक़ के तौर पर देता हूँ; तेरे घराने में जितने पाक हैं वह उनको खाएँ। ");
INSERT INTO urd_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","अच्छे से अच्छा तेल और अच्छी से अच्छी मय और अच्छे से अच्छा गेहूँ, या'नी इन चीज़ों में से जो कुछ वह पहले फल के तौर पर ख़ुदावन्द के सामने पेश करें वह सब मैंने तुझे दिया। ");
INSERT INTO urd_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","उनके मुल्क की सारी पैदावार के पहले पक्के फल, जिनको वह ख़ुदावन्द के सामने लाएँ तेरे होंगे; तेरे घराने में जितने पाक हैं वह उनको खाएँ। ");
INSERT INTO urd_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","बनी — इस्राईल की हर एक मख़्सूस की हुई चीज़ तेरी होगी। ");
INSERT INTO urd_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","उन जानदारों में से जिनको वह ख़ुदावन्द के सामने पेश करते हैं, जितने पहलौठी के बच्चे हैं चाहे वह इंसान के हों चाहे हैवान के वह सब तेरे होंगे; लेकिन इंसान के पहलौठों का फ़िदिया लेकर उनको ज़रूर छोड़ देना और नापाक जानवरों के पहलौठे भी फ़िदिये से छोड़ दिए जाएँ। ");
INSERT INTO urd_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","और जिनका फ़िदिया दिया जाए वह जब एक महीने के हों, तो उनको अपनी ठहराई हुई क़ीमत के मुताबिक़ हैकल की मिस्क़ाल के हिसाब से जो बीस जीरे की होती है चाँदी की पाँच मिस्क़ाल लेकर छोड़ देना। ");
INSERT INTO urd_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","लेकिन गाय और भेड़ — बकरी के पहलौठों का फ़िदिया न लिया जाए, वह पाक हैं; तू उनका ख़ून मज़बह पर छिड़कना और उनकी चर्बी आतिशीन क़ुर्बानी के तौर पर जला देना, ताकि वह ख़ुदावन्द के सामने राहतअंगेज़ ख़ुशबू ठहरे। ");
INSERT INTO urd_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","और उनका गोश्त तेरा होगा जिस तरह हिलाई हुई क़ुर्बानी का सीना और दहनी रान तेरे हैं। ");
INSERT INTO urd_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","जितनी पाक चीज़ें बनी — इस्राईल उठाने की क़ुर्बानी के तौर पर ख़ुदावन्द के सामने पेश करें, उन सभों को मैंने तुझे और तेरे बेटे — बेटियों को हमेशा के हक़ के तौर पर दिया; यह ख़ुदावन्द के सामने तेरे और तेरी नसल के लिए नमक का दाइमी 'अहद है।” ");
INSERT INTO urd_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","और ख़ुदावन्द ने हारून से कहा, उनके मुल्क में तुझे कोई मीरास नहीं मिलेगी और न उनके बीच तेरा कोई हिस्सा होगा क्यूँकि बनी — इस्राईल में तेरा हिस्सा और तेरी मीरास मैं हूँ। ");
INSERT INTO urd_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","'और बनी लावी को उस ख़िदमत के मु'आवज़े में जो वह ख़ेमा — ए — इजितमा'अ में करते हैं मैंने बनी इस्राईल की सारी दहेकी मौरूसी हिस्से के तौर पर दी। ");
INSERT INTO urd_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","और आगे को बनी — इस्राईल ख़ेमा — ए — इजितमा'अ के नज़दीक हरगिज़ न आएँ, ऐसा न हो कि गुनाह उनके सिर लगे और वह मर जाएँ। ");
INSERT INTO urd_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","बल्कि बनी लावी ख़ेमा — ए — इजितमा'अ की ख़िदमत करें और वहीँ उनका बार — ए — गुनाह उठाएँ; तुम्हारी नसल — दर — नसल यह एक दाइमी क़ानून हो, और बनी इस्राईल के बीच उनको कोई मीरास न मिले। ");
INSERT INTO urd_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","क्यूँकि मैंने बनी — इस्राईल की दहेकी को, जिसे वह उठाने की क़ुर्बानी के तौर पर ख़ुदावन्द के सामने पेश करेंगे उनका मौरूसी हिस्सा कर दिया है; इसी वजह से मैंने उनके हक़ में कहा है कि बनी — इस्राईल के बीच उनकी कोई मीरास न मिले।” ");
INSERT INTO urd_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","और ख़ुदावन्द ने मूसा से कहा कि, ");
INSERT INTO urd_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“तू लावियों से इतना कह देना कि जब तुम बनी — इस्राईल से उस दहेकी को लो जिसे मैंने उनकी तरफ़ से तुम्हारा मौरूसी हिस्सा कर दिया है, तो तुम उस दहेकी की दहेकी ख़ुदावन्द के सामने उठाने की क़ुर्बानी के लिए पेश करना। ");
INSERT INTO urd_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","और यह तुम्हारी उठाई हुई क़ुर्बानी तुम्हारी तरफ़ से ऐसी ही समझी जाएगी जैसे खलिहान का गल्ला और कोल्हू की मय समझी जाती है। ");
INSERT INTO urd_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","इस तरीक़े से तुम भी अपनी सब दहेकियों में से जो तुम को बनी इस्राईल की तरफ़ से मिलेगी ख़ुदावन्द के सामने उठाने की क़ुर्बानी पेश करना, और ख़ुदावन्द की यह उठाई हुई क़ुर्बानी हारून काहिन को देना। ");
INSERT INTO urd_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","जितने नज़राने तुम को मिलें उनमें से उनका अच्छे से अच्छा हिस्सा, जो पाक किया गया है और ख़ुदावन्द का है, तुम उठाने की क़ुर्बानी के तौर पर पेश करना। ");
INSERT INTO urd_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","इसलिए तू उनसे कह देना कि जब तुम इनमें से उनका अच्छे से अच्छा हिस्सा उठाने की क़ुर्बानी के तौर पर पेश करोगे, तो वह लावियों के हक़ में खलिहान के भरे गल्ले और कोल्हू की भरी मय के बराबर का हिसाब होगा। ");
INSERT INTO urd_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","और इनको तुम अपने घरानों के साथ हर जगह खा सकते हो, क्यूँकि यह उस ख़िदमत के बदले तुम्हारा मजदूरी है जो तुम ख़ेमा — ए — इजितमा'अ में करोगे। ");
INSERT INTO urd_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","और जब तुम उसमें से अच्छे से अच्छा हिस्सा उठाने की क़ुर्बानी के तौर पर पेश करोगे, तो तुम उसकी वजह से गुनाहगार न ठहरोगे; और ख़बरदार बनी इस्राईल की पाक चीज़ों को नापाक न करना ताकि तुम हलाक न हो।” ");
INSERT INTO urd_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","और ख़ुदावन्द ने मूसा और हारून से कहा, ");
INSERT INTO urd_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","कि शरी'अत के जिस क़ानून का हुक्म ख़ुदावन्द ने दिया है वह यह है, कि तू बनी — इस्राईल से कह कि वह तेरे पास एक बेदाग़ और बे — 'ऐब सुर्ख़ रंग की बछिया लाएँ, जिस पर कभी बोझ न रख्खा गया हो। ");
INSERT INTO urd_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","और तुम उसे लेकर इली'एलियाज़र काहिन को देना कि वह उसे लश्करगाह के बाहर ले जाए, और कोई उसे उसी के सामने ज़बह कर दे; ");
INSERT INTO urd_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","और इली'एलियाज़र काहिन अपनी उंगली से उसका कुछ ख़ून लेकर उसे ख़ेमा — ए — इजितमा'अ के आगे की तरफ़ सात बार छिड़के। ");
INSERT INTO urd_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","फिर कोई उसकी आँखों के सामने उस गाय को जला दे; या'नी उसका चमड़ा, और गोश्त, और ख़ून, और गोबर, इन सब को वह जलाए। ");
INSERT INTO urd_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","फिर काहिन देवदार की लकड़ी और ज़ूफ़ा और सुर्ख़ कपड़ा लेकर उस आग में जिसमें गाय जलती हो डाल दे। ");
INSERT INTO urd_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","तब काहिन अपने कपड़े धोए और पानी से ग़ुस्ल करे; इसके बाद वह लश्करगाह के अन्दर आए, फिर भी काहिन शाम तक नापाक रहेगा। ");
INSERT INTO urd_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","और जो उस गाय को जलाए वह भी अपने कपड़े पानी से धोए और पानी से ग़ुस्ल करे और वह भी शाम तक नापाक रहेगा। ");
INSERT INTO urd_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","और कोई पाक शख़्स उस गाय की राख को बटोरे, और उसे लश्करगाह के बाहर किसी पाक जगह में धर दे; यह बनी — इस्राईल की जमा'अत के लिए नापाकी दूर करने के पानी के लिए रख्खी रहे, क्यूँकि यह ख़ता की क़ुर्बानी है। ");
INSERT INTO urd_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","और जो उस गाय की राख को बटोरे वह भी अपने कपड़े धोए और वह भी शाम तक नापाक रहेगा, और यह बनी — इस्राईल के और उन परदेसियों के लिए जो उनमें क़याम करते हैं एक दाइमी क़ानून होगा। ");
INSERT INTO urd_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","'जो कोई किसी आदमी की लाश को छुए वह सात दिन तक नापाक रहेगा। ");
INSERT INTO urd_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ऐसा आदमी तीसरे दिन उस राख से अपने को साफ़ करे तो वह सातवें दिन पाक ठहरेगा लेकिन अगर वह तीसरे दिन अपने को साफ़ न करे तों वह सातवें दिन पाक नहीं ठहरेगा। ");
INSERT INTO urd_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","जो कोई आदमी की लाश को छूकर अपने को साफ़ न करे वह ख़ुदावन्द के घर को नापाक करता है, वह शख़्स इस्राईल में से अलग किया जाएगा क्यूँकि नापाकी दूर करने का पानी उस पर छिड़का नहीं गया इसलिए वह नापाक है उसकी नापाकी अब तक उस पर है। ");
INSERT INTO urd_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","अगर कोई आदमी किसी ख़ेमे में मर जाए तो उसके बारे में शरा' यह है, कि जितने उस ख़ेमे में आएँ और जितने उस ख़ेमे में रहते हों वह सात दिन तक नापाक रहेंगे। ");
INSERT INTO urd_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","और हर एक खुला बर्तन जिसका ढकना उस पर बन्धा न हो नापाक ठहरेगा। ");
INSERT INTO urd_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","और जो कोई मैदान में तलवार के मक़तूल को या मुर्दे को या आदमी की हड्डी को या किसी क़ब्र को छुए वह सात दिन तक नापाक रहेगा। ");
INSERT INTO urd_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","और नापाक आदमी के लिए उस जली हुई ख़ता की क़ुर्बानी की राख को किसी बर्तन में लेकर उस पर बहता पानी डालें। ");
INSERT INTO urd_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","फिर कोई पाक आदमी ज़ूफ़ा लेकर और उसे पानी में डुबो — डुबोकर उस ख़ेमे पर, और जितने बर्तन और आदमी वहाँ हों उन पर और जिस शख़्स ने हड्डी को, या मक़तूलको, या मुर्दे को, या क़ब्र को छुआ है उस पर छिड़के। ");
INSERT INTO urd_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","वह पाक आदमी तीसरे दिन और सातवें दिन उस नापाक आदमी पर इस पानी को छिड़के और सातवें दिन उसे साफ़ करे फिर वह अपने कपड़े धोए और पानी से नहाए, तो वह शाम को पाक होगा। ");
INSERT INTO urd_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","'लेकिन जो कोई नापाक हो और अपनी सफ़ाई न करे, वह शख़्स जमा'अत में से अलग किया जाएगा क्यूँकि उसने ख़ुदावन्द के हैकल को नापाक किया नापाकी दूर करने का पानी उस पर छिड़का नहीं गया इसलिए वह नापाक है। ");
INSERT INTO urd_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","और यह उनके लिए एक दाइमी क़ानून हो; जो नापाकी दूर करने के पानी को लेकर छिड़के वह अपने कपड़े धोए, और जो कोई नापाकी दूर करने के पानी को छुए वह भी शाम तक नापाक रहेगा। ");
INSERT INTO urd_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","और जिस किसी चीज़ को वह नापाक आदमी छुए वह चीज़ नापाक ठहरेगी, और जो कोई उस चीज़ को छू ले वह भी शाम तक नापाक रहेगा। ");
INSERT INTO urd_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","और पहले महीने में बनी — इस्राईल की सारी जमा'अत सीन के जंगल में आ गई और वह लोग क़ादिस में रहने लगे, और मरियम ने वहाँ वफ़ात पाई और वहीं दफ़्न हुई। ");
INSERT INTO urd_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","और जमा'अत के लोगों के लिए वहाँ पानी न मिला, इसलिए वह मूसा और हारून के बरख़िलाफ़ इकट्ठे हुए। ");
INSERT INTO urd_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","और लोग मूसा से झगड़ने और यह कहने लगे, “हाय, काश हम भी उसी वक़्त मर जाते जब हमारे भाई ख़ुदावन्द के सामने मरे। ");
INSERT INTO urd_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","तुम ख़ुदावन्द की जमा'अत को इस जंगल में क्यूँ ले आए हो कि हम भी और हमारे जानवर भी यहाँ मरें? ");
INSERT INTO urd_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","और तुम ने क्यूँ हम को मिस्र से निकाल कर इस बुरी जगह पहुँचाया है? यह तो बोने की और अंजीरों और ताकों और अनार की जगह नहीं है बल्कि यहाँ तो पीने के लिए पानी तक हासिल नहीं।” ");
INSERT INTO urd_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","और मूसा और हारून जमा'अत के पास से जाकर ख़ेमा — ए — इजितमा'अ के दरवाज़े पर औंधे मुँह गिरे। तब ख़ुदावन्द का जलाल उन पर ज़ाहिर हुआ, ");
INSERT INTO urd_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","और ख़ुदावन्द ने मूसा से कहा कि, ");
INSERT INTO urd_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“उस लाठी को ले और तू और तेरा भाई हारून, तुम दोनों जमा'अत को इकट्ठा करो और उनकी आँखों के सामने उस चट्टान से कहो कि वह अपना पानी दे; और तू उनके लिए चट्टान ही से पानी निकालना, यूँ जमा'अत को और उनके चौपायों को पिलाना।” ");
INSERT INTO urd_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","चुनाँचे मूसा ने ख़ुदावन्द के सामने से उसी के हुक्म के मुताबिक़ वह लाठी ली। ");
INSERT INTO urd_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","और मूसा और हारून ने जमा'अत को उस चट्टान के सामने इकट्ठा किया, और उसने उनसे कहा, “सुनो, ऐ बाग़ियों, क्या हम तुम्हारे लिए इसी चट्टान से पानी निकालें?” ");
INSERT INTO urd_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","तब मूसा ने अपना हाथ उठाया और उस चट्टान पर दो बार लाठी मारी, और कसरत से पानी बह निकला और जमा'अत ने और उनके चौपायों ने पिया। ");
INSERT INTO urd_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","लेकिन मूसा और हारून से ख़ुदावन्द ने कहा, “चूँकि तुम ने मेरा यक़ीन नहीं किया कि बनी — इस्राईल के सामने मेरी तक़दीस करते, इसलिए तुम इस जमा'अत को उस मुल्क में जो मैंने उनको दिया है नहीं पहुँचाने पाओगे।” ");
INSERT INTO urd_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","मरीबा का चश्मा यही है क्यूँकि बनी — इस्राईल ने ख़ुदावन्द से झगड़ा किया और वह उनके बीच क़ुद्दूस साबित हुआ। ");
INSERT INTO urd_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","और मूसा ने क़ादिस से अदोम के बादशाह के पास क़ासिद रवाना किए और कहला भेजा कि “तेरा भाई इस्राईल यह 'अर्ज़ करता है, कि तू हमारी सारी मुसीबतों से जो हम पर आईं वाकिफ़ है; ");
INSERT INTO urd_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","कि हमारे बाप दादा मिस्र में गए और हम बहुत मुद्दत तक मिस्र में रहे, और मिस्रियों ने हम से और हमारे बाप दादा से बुरा सुलूक किया। ");
INSERT INTO urd_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","और जब हमने ख़ुदावन्द से फ़रियाद की तो उसने हमारी सुनी, और एक फ़रिश्ते को भेज कर हम को मिस्र से निकाल ले आया है, और अब हम क़ादिस शहर में हैं जो तेरी सरहद के आख़िर में वाक़े' है। ");
INSERT INTO urd_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","इसलिए हम को अपने मुल्क में से होकर जाने की इजाज़त दे। हम खेतों और ताकिस्तानों में से होकर नहीं गुज़रेंगे, और न कुओं का पानी पिएँगे; हम शाहराह पर चल कर जाएँगे और दहने या बाएँ हाथ नहीं मुड़ेंगे, जब तक तेरी सरहद से बाहर निकल न जाएँ।” ");
INSERT INTO urd_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","लेकिन शाह — ए — अदोम ने कहला भेजा, “तू मेरे मुल्क से होकर जाने नहीं पाएगा, वरना मैं तलवार लेकर तेरा सामना करूँगा।” ");
INSERT INTO urd_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","बनी — इस्राईल ने उसे फिर कहला भेजा कि “हम सड़क ही सड़क जाएँगे, और अगर हम या हमारे चौपाये तेरा पानी भी पिएँ तो उसका दाम देंगे; हम को और कुछ नहीं चाहिए अलावा इसके कि हम को पॉव — पाँव चल कर निकल जाने दे।” ");
INSERT INTO urd_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","लेकिन उसने कहा, “तू हरगिज़ निकलने नहीं पाएगा।” और अदोम उसके मुक़ाबले के लिए बहुत से आदमी और हथियार लेकर निकल आया। ");
INSERT INTO urd_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","यूँ अदोम ने इस्राईल को अपनी हदों से गुज़रने का रास्ता देने से इन्कार किया, इसलिए इस्राईल उसकी तरफ़ से मुड़ गया। ");
INSERT INTO urd_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","और बनी — इस्राईल की सारी जमा'अत क़ादिस से रवाना होकर कोह — ए — हूर पहुँची। ");
INSERT INTO urd_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","और ख़ुदावन्द ने कोह — ए — हूर पर, जो अदोम की सरहद से मिला हुआ था, मूसा और हारून से कहा, ");
INSERT INTO urd_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“हारून अपने लोगों में जा मिलेगा, क्यूँकि वह उस मुल्क में जो मैने बनी — इस्राईल को दिया है जाने नहीं पाएगा, इसलिए कि मरीबा के चश्मे पर तुम ने मेरे कलाम के ख़िलाफ़ 'अमल किया। ");
INSERT INTO urd_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","इसलिए तू हारून और उसके बेटे इली'एलियाज़र को अपने साथ लेकर कोह — ए — हूर के ऊपर आ जा। ");
INSERT INTO urd_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","और हारून के लिबास को उतार कर उसके बेटे इली'एलियाज़र को पहना देना, क्यूँकि हारून वहीं वफ़ात पाकर अपने लोगों में जा मिलेगा।” ");
INSERT INTO urd_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","और मूसा ने ख़ुदा के हुक्म के मुताबिक़ 'अमल किया, और वह सारी जमा'अत की आँखों के सामने कोह — ए — हूर पर चढ़ गए। ");
INSERT INTO urd_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","और मूसा ने हारून के लिबास को उतार कर उस के बेटे इली'एलियाज़र को पहना दिया, और हारून ने वहीं पहाड़ की चोटी पर रहलत की। तब मूसा और इली'अजर पहाड़ पर से उतर आए। ");
INSERT INTO urd_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","जब जमा'अत ने देखा कि हारून ने वफ़ात पाई तो इस्राईल के सारे घराने के लोग हारून पर तीस दिन तक मातम करते रहे। ");
INSERT INTO urd_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","और जब 'अराद के कना'नी बादशाह ने जो दख्खिन की तरफ़ रहता था सुना, कि इस्राईली अथारिम की राह से आ रहे हैं, तो वह इस्राईलियों से लड़ा और उनमें से कई एक को ग़ुलाम कर लिया। ");
INSERT INTO urd_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","तब इस्राईलियों ने ख़ुदावन्द के सामने मिन्नत मानी और कहा कि “अगर तू सचमुच उन लोगों को हमारे हवाले कर दे तो हम उनके शहरों को बर्बाद कर देंगे।” ");
INSERT INTO urd_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","और ख़ुदावन्द ने इस्राईल की फ़रियाद सुनी और कना'नियों को उन के हवाले कर दिया; और उन्होंने उनको और उनके शहरों को बर्बाद कर दिया, चुनाँचे उस जगह का नाम भी हुरमा पड़ गया। ");
INSERT INTO urd_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","फिर उन्होंने कोह — ए — होर से रवाना होकर बहर — ए — कु़लजु़म का रास्ता लिया, ताकि मुल्क — ए — अदोम के बाहर — बाहर घूम कर जाएँ; लेकिन उन लोगों की जान उस रास्ते से 'आजिज़ आ गई। ");
INSERT INTO urd_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","और लोग ख़ुदा की और मूसा की शिकायत करके कहने लगे कि “तुम क्यूँ हम को मिस्र से वीरान में मरने के लिए ले आए? यहाँ तो न रोटी है, न पानी, और हमारा जी इस निकम्मी ख़ुराक से कराहियत करता है।” ");
INSERT INTO urd_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","तब ख़ुदावन्द ने उन लोगों में जलाने वाले साँप भेजे, उन्होंने लोगों को काटा और बहुत से इस्राईली मर गए। ");
INSERT INTO urd_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","तब वह लोग मूसा के पास आकर कहने लगे कि “हम ने गुनाह किया, क्यूँकि हम ने ख़ुदावन्द की और तेरी शिकायत की; इसलिए तू ख़ुदावन्द से दुआ कर कि वह इन साँपों को हम से दूर करे।” चुनौंचे मूसा ने लोगों के लिए दुआ की। ");
INSERT INTO urd_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","तब ख़ुदावन्द ने मूसा से कहा कि “एक जलाने वाला साँप बना ले और उसे एक बल्ली पर लटका दे, और जो साँप का डसा हुआ उस पर नज़र करेगा वह ज़िन्दा बचेगा।” ");
INSERT INTO urd_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","चुनाँचे मूसा ने पीतल का एक साँप बनवाकर उसे बल्ली पर लटका दिया; और ऐसा हुआ कि जिस जिस साँप के डसे हुए आदमी ने उस पीतल के साँप पर निगाह की वह ज़िन्दा बच गया। ");
INSERT INTO urd_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","और बनी — इस्राईल ने वहाँ से रवानगी की और ओबूत में आकर ख़ेमे डाले। ");
INSERT INTO urd_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","फिर ओबूत से कूच किया और 'अय्ये 'अबारीम में, जो पश्चिम की तरफ़ मोआब के सामने के वीरान में वाके' है ख़ेमे डाले। ");
INSERT INTO urd_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","और वहाँ से रवाना होकर वादी — ए — ज़रद में ख़ेमे डाले। ");
INSERT INTO urd_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","जब वहाँ से चले तो अरनोन से पार हो कर, जो अमोरियों की सरहद से निकल कर वीरान में बहती है, ख़ेमे डाले: क्यूँकि मोआब और अमोरियों के बीच अरनोन मोआब की सरहद है। ");
INSERT INTO urd_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","इसी वजह से ख़ुदावन्द के जंग नामे में यूँ लिखा है: “वाहेब जो सूफ़ा में है, और अरनोन के नाले ");
INSERT INTO urd_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","और उन नालों का ढलान जो 'आर शहर तक जाता है, और मोआब की सरहद से मुतसिल है।” ");
INSERT INTO urd_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","फिर इस जगह से वह बैर को गए; यह वही कुवाँ है जिसके बारे में ख़ुदावन्द ने मूसा से कहा था कि “इन लोगों को एक जगह जमा' कर, और मैं इनको पानी दूँगा।” ");
INSERT INTO urd_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","तब इस्राईल ने यह गीत गाया: 'ऐ कुएँ, तू उबल आ! तुम इस कुएँ की ता'रीफ़ गाओ। ");
INSERT INTO urd_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","यह वही कुआँ है जिसे रईसों ने बनाया, और क़ौम के अमीरों ने अपने 'असा और लाठियों से खोदा।” तब वह उस जंगल से मत्तना को गए, ");
INSERT INTO urd_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","और मत्तना से नहलीएल को, और नहलीएल से बामात को, ");
INSERT INTO urd_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","और बामात से उस वादी में पहुँच कर जो मोआब के मैदान में है, पिसगा की उस चोटी तक निकल गए जहाँ से यशीमोन नज़र आता है। ");
INSERT INTO urd_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","और इस्राईलियों ने अमोरियों के बादशाह सीहोन के पास क़ासिद रवाना किए और यह कहला भेजा कि; ");
INSERT INTO urd_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“हम को अपने मुल्क से गुज़र जाने दे; हम खेतों और अँगूर के बाग़ों में नहीं घुसेंगे, और न कुओं का पानी पीएँगे, बल्कि शाहराह से सीधे चले जाएँगे जब तक तेरी हद के बाहर न हो जाएँ।” ");
INSERT INTO urd_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","लेकिन सीहोन ने इस्राईलियों को अपनी हद में से गुज़रने न दिया; बल्कि सीहोन अपने सब लोगों को इकट्ठा करके इस्राईलियों के मुक़ाबले के लिए वीरान में पहुँचा, और उसने यहज़ में आकर इस्राईलियों से जंग की। ");
INSERT INTO urd_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","और इस्राईल ने उसे तलवार की धार से मारा और उसके मुल्क पर, अरनोन से लेकर यब्बोक़ तक जहाँ बनी 'अम्मोन की सरहद है क़ब्ज़ा कर लिया; क्यूँकि बनी 'अम्मोन की सरहद मज़बूत थी। ");
INSERT INTO urd_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","तब बनी — इस्राईल ने यहाँ के सब शहरों को ले लिया और अमोरियों के सब शहरों में, या'नी हस्बोन और उसके आस पास के कस्बों में बनी — इस्राईल बस गए। ");
INSERT INTO urd_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","हस्बोन अमोरियों के बादशाह सीहोन का शहर था, इसने मोआब के अगले बादशाह से लड़कर उसके सारे मुल्क को, अरनोन तक उससे छीन लिया था। ");
INSERT INTO urd_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","इसी वजह से मिसाल कहने वालों की यह कहावत है कि “हस्बोन में आओ, ताकि सीहोन का शहर बनाया और मज़बूत किया जाए। ");
INSERT INTO urd_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","क्यूँकि हस्बोन से आग निकली, सीहोन के शहर से शोला बरामद हुआ, इसने मोआब के 'आर शहर को और अरनोन के ऊँचे मक़ामात के सरदारों को भसम कर दिया। ");
INSERT INTO urd_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ऐ, मोआब! तुझ पर नोहा है। ऐ कमोस के मानने वालों! तुम हलाक हुए, उसने अपने बेटों को जो भागे थे और अपनी बेटियों को ग़ुलामों की तरह अमोरियों के बादशाह सीहोन के हवाले किया। ");
INSERT INTO urd_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","हमने उन पर तीर चलाए, इसलिए हस्बोन दीबोन तक तबाह हो गया, बल्कि हम ने नुफ़ा तक सब कुछ उजाड़ दिया। वह नुफ़ा जो मीदबा से मुत्तसिल है।” ");
INSERT INTO urd_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","तब बनी — इस्राईल अमोरियों के मुल्क में रहने लगे। ");
INSERT INTO urd_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","और मूसा ने या'ज़ेर की जासूसी कराई; फिर उन्होंने उसके गाँव ले लिए और अमोरियों को जो वहाँ थे निकाल दिया। ");
INSERT INTO urd_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","और वह घूम कर बसन के रास्ते से आगे को बढ़े और बसन का बादशाह 'ओज अपने सारे लश्कर को लेकर निकला, ताकि अदराई में उनसे जंग करे। ");
INSERT INTO urd_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","और ख़ुदावन्द ने मूसा से कहा, “उससे मत डर, क्यूँकि मैंने उसे और उसके सारे लश्कर को और उसके मुल्क को तेरे हवाले कर दिया है। इसलिए जैसा तूने अमोरियों के बादशाह सीहोन के साथ जो हस्बोन में रहता था किया है, वैसा ही इसके साथ भी करना।” ");
INSERT INTO urd_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","चुनाँचे उन्होंने उसको और उसके बेटों और सब लोगों को यहाँ तक मारा कि उसका कोई बाक़ी न रहा, और उसके मुल्क को अपने क़ब्ज़े में कर लिया। ");
INSERT INTO urd_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","फिर बनी — इस्राईल रवाना हुए और दरिया — ए — यरदन के पार मोआब के मैदानों में यरीहू के सामने ख़ेमे खड़े किए। ");
INSERT INTO urd_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","और जो कुछ बनी — इस्राईल ने अमोरियों के साथ किया था वह सब बलक़ बिन सफ़ोर ने देखा था। ");
INSERT INTO urd_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","इसलिए मोआबियों को इन लोगों से बड़ा ख़ौफ़ आया, क्यूँकि यह बहुत से थे; ग़र्ज़ मोआबी बनी — इस्राईल की वजह से परेशान हुए। ");
INSERT INTO urd_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","तब मोआबियों ने मिदियानी बुज़ुर्गों से कहा, “जो कुछ हमारे आस पास है उसे यह लश्कर ऐसा चट कर जाएगा जैसे बैल मैदान की घास को चट कर जाता है।” उस वक़्त बलक़ बिन सफ़ोर मोआबियों का बादशाह था। ");
INSERT INTO urd_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","इसलिए उस ने ब'ओर के बेटे बल'आम के पास फ़तोर को, जो बड़े दरिया कि किनारे उसकी क़ौम के लोगों का मुल्क था, क़ासिद रवाना किए कि उसे बुला लाएँ और यह कहला भेजा, “देख, एक क़ौम मिस्र से निकलकर आई है, उनसे ज़मीन की सतह छिप गई है; अब वह मेरे सामने ही आकर जम गए हैं। ");
INSERT INTO urd_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","इसलिए अब तू आकर मेरी ख़ातिर इन लोगों पर ला'नत कर, क्यूँकि यह मुझ से बहुत क़वी हैं; फिर मुम्किन है कि मैं ग़ालिब आऊँ, और हम सब इनको मार कर इस मुल्क से निकाल दें; क्यूँकि यह मैं जानता हूँ कि जिसे तू बरकत देता है उसे बरकत मिलती है, और जिस पर तू ला'नत करता है वह मला'ऊन होता है।” ");
INSERT INTO urd_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","तब मोआब के बुज़ुर्ग और मिदियान के बुज़ुर्ग फ़ाल खोलने का इनाम साथ लेकर रवाना हुए और बल'आम के पास पहुँचे और बलक़ का पैग़ाम उसे दिया। ");
INSERT INTO urd_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","उसने उनसे कहा, “आज रात यहीं ठहरो और जो कुछ ख़ुदावन्द मुझ से कहेगा, उसके मुताबिक़ मैं तुम को जवाब दूँगा।” चुनाँचे मोआब के हाकिम बल'आम के साथ ठहर गए। ");
INSERT INTO urd_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","और ख़ुदा ने बल'आम के पास आकर कहा, “तेरे यहाँ यह कौन आदमी हैं?” ");
INSERT INTO urd_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","बल'आम ने ख़ुदा से कहा, “मोआब के बादशाह बलक़ बिन सफ़ोर ने मेरे पास कहला भेजा है, कि ");
INSERT INTO urd_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","जो कौम मिस्र से निकल कर आई है उससे ज़मीन की सतह छिप गई है, इसलिए तू अब आकर मेरी ख़ातिर उन पर ला'नत कर, फिर मुम्किन है कि मैं उनसे लड़ सकूँ और उनको निकाल दूँ।” ");
INSERT INTO urd_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ख़ुदा ने बल'आम से कहा, “तू इनके साथ मत जाना, तू उन लोगों पर ला'नत न करना, इसलिए कि वह मुबारक हैं।” ");
INSERT INTO urd_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","बल'आम ने सुबह को उठ कर बलक़ के हाकिमों से कहा, “तुम अपने मुल्क को लौट जाओ, क्यूँकि ख़ुदावन्द मुझे तुम्हारे साथ जाने की इजाज़त नहीं देता।” ");
INSERT INTO urd_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","और मोआब के हाकिम चले गए और जाकर बलक़ से कहा, “बल'आम हमारे साथ आने से इंकार करता है।” ");
INSERT INTO urd_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","तब दूसरी दफ़ा' बलक़ ने और हाकिमों को भेजा, जो पहलों से बढ़ कर मु'अज़िज़ और शुमार में भी ज़्यादा थे। ");
INSERT INTO urd_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","उन्होंने बल'आम के पास जाकर उस से कहा, “बलक़ बिन सफ़ोर ने यूँ कहा है, कि मेरे पास आने में तेरे लिए कोई रुकावट न हो; ");
INSERT INTO urd_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","क्यूँकि मैं बहुत 'आला मन्सब पर तुझे मुम्ताज़ करूँगा, और जो कुछ तू मुझ से कहे मैं वही करूँगा; इसलिए तू आ जा और मेरी ख़ातिर इन लोगों पर ला'नत कर।” ");
INSERT INTO urd_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","बल'आम ने बलक़ के ख़ादिमों को जवाब दिया, “अगर बलक़ अपना घर भी चाँदी और सोने से भर कर मुझे दे, तो भी मैं ख़ुदावन्द अपने ख़ुदा के हुक्म से तजावुज़ नहीं कर सकता, कि उसे घटाकर या बढ़ा कर मानूँ। ");
INSERT INTO urd_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","इसलिए अब तुम भी आज रात यहीं ठहरो, ताकि मैं देखूँ कि ख़ुदावन्द मुझ से और क्या कहता है।” ");
INSERT INTO urd_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","और ख़ुदा ने रात को बल'आम के पास आ कर उससे कहा, “अगर यह आदमी तुझे बुलाने को आए हुए हैं तो तू उठ कर उनके साथ जा; मगर जो बात मैं तुझ से कहूँ उसी पर 'अमल करना।” ");
INSERT INTO urd_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","तब बल'आम सुबह को उठा, और अपनी गधी पर ज़ीन रख कर मोआब के हाकिमों के साथ चला। ");
INSERT INTO urd_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","और उसके जाने की वजह से ख़ुदा का ग़ज़ब भड़का, और ख़ुदावन्द का फ़रिश्ता उससे मुज़ाहमत करने के लिए रास्ता रोक कर खड़ा हो गया। वह तो अपनी गधी पर सवार था और उसके साथ उसके दो मुलाज़िम थे। ");
INSERT INTO urd_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","और उस गधी ने ख़ुदावन्द के फ़रिश्ते को देखा, कि वह अपने हाथ में नंगी तलवार लिए हुए रास्ता रोके खड़ा है; तब गधी रास्ता छोड़कर एक तरफ़ हो गई और खेत में चली गई। तब बल'आम ने गधी को मारा ताकि उसे रास्ते पर ले आए। ");
INSERT INTO urd_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","तब ख़ुदावन्द का फ़रिश्ता एक नीची राह में जा खड़ा हुआ, जो ताकिस्तानों के बीच से होकर निकलती थी और उसकी दोनों तरफ़ दीवारें थीं। ");
INSERT INTO urd_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","गधी ख़ुदावन्द के फ़रिश्ते को देख कर दीवार से जा लगी और बल'आम का पाँव दीवार से पिचा दिया, इसलिए उसने फिर उसे मारा। ");
INSERT INTO urd_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","तब ख़ुदावन्द का फ़रिश्ता आगे बढ़ कर एक ऐसे तंग मक़ाम में खड़ा हो गया, जहाँ दहनी या बाई तरफ़ मुड़ने की जगह न थी। ");
INSERT INTO urd_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","फिर जो गधी ने ख़ुदावन्द के फ़रिश्ते को देखा तो बल'आम को लिए हुए बैठ गई; फिर तो बल'आम झल्ला उठा और उसने गधी को अपनी लाठी से मारा। ");
INSERT INTO urd_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","तब ख़ुदावन्द ने गधी की ज़बान खोल दी और उसने बल'आम से कहा, “मैंने तेरे साथ क्या किया है कि तूने मुझे तीन बार मारा?” ");
INSERT INTO urd_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","बल'आम ने गधी से कहा, “इसलिए कि तूने मुझे चिढ़ाया; काश मेरे हाथ में तलवार होती, तो मैं तुझे अभी मार डालता।” ");
INSERT INTO urd_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","गधी ने बल'आम से कहा, “क्या मैं तेरी वही गधी नहीं हूँ जिस पर तू अपनी सारी उम्र आज तक सवार होता आया है? क्या मैं तेरे साथ पहले कभी ऐसा करती थी?” उसने कहा, “नहीं।” ");
INSERT INTO urd_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","तब ख़ुदावन्द ने बल'आम की आँखें खोलीं, और उसने ख़ुदावन्द के फ़रिश्ते को देखा कि वह अपने हाथ में नंगी तलवार लिए हुए रास्ता रोके खड़ा है, तब उसने अपना सिर झुका लिया और औंधा हो गया। ");
INSERT INTO urd_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","ख़ुदावन्द के फ़रिश्ते ने उसे कहा, “तू ने अपनी गधी को तीन बार क्यूँ मारा? देख, मैं तुझ से मुज़ाहमत करने को आया हूँ, इसलिए कि तेरी चाल मेरी नज़र में टेढ़ी है। ");
INSERT INTO urd_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","और गधी ने मुझ को देखा, और वह तीन बार मेरे सामने से मुड़ गई। अगर वह मेरे सामने से न हटती तो मैं ज़रूर तुझ को मार ही डालता, और उसको ज़िन्दा छोड़ देता।” ");
INSERT INTO urd_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","बल'आम ने ख़ुदावन्द के फ़रिश्ते से कहा, “मुझ से ख़ता हुई, क्यूँकि मुझे मा'लूम न था कि तू मेरा रास्ता रोके खड़ा है। इसलिए अगर अब तुझे बुरा लगता है तो मैं लौट जाता हूँ।” ");
INSERT INTO urd_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","ख़ुदावन्द के फ़रिश्ते ने बल'आम से कहा, “तू इन आदमियों के साथ चला ही जा, लेकिन सिर्फ़ वही बात कहना जो मैं तुझ से कहूँ।” तब बल'आम बलक़ के हाकिमों के साथ गया। ");
INSERT INTO urd_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","जब बलक़ ने सुना कि बल'आम आ रहा है, तो वह उसके इस्तक़बाल के लिए मोआब के उस शहर तक गया जो अरनोन की सरहद पर उसकी हदों के इन्तिहाई हिस्से में वाक़े' था। ");
INSERT INTO urd_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","तब बलक़ ने बल'आम से कहा, “क्या मैंने बड़ी उम्मीद के साथ तुझे नहीं बुलवा भेजा था? फिर तू मेरे पास क्यूँ न चला आया? क्या मैं इस क़ाबिल नहीं कि तुझे 'आला मन्सब पर मुम्ताज़ करूँ?” ");
INSERT INTO urd_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","बल'आम ने बलक़ को जवाब दिया, “देख, मैं तेरे पास आ तो गया हूँ लेकिन क्या मेरी इतनी मजाल है कि मैं कुछ बोलूँ? जो बात ख़ुदा मेरे मुँह में डालेगा, वही मैं कहूँगा।” ");
INSERT INTO urd_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","और बल'आम बलक़ के साथ — साथ चला और वह करयत हुसात में पहुँचे। ");
INSERT INTO urd_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","बलक़ ने बैल और भेड़ों की क़ुर्बानी पेश कीं, और बल'आम और उन हाकिमों के पास जो उसके साथ थे क़ुर्बानी का गोश्त भेजा। ");
INSERT INTO urd_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","दूसरे दिन सुबह को बलक़ बल'आम को साथ लेकर उसे बा'ल के बुलन्द मक़ामों पर ले गया। वहाँ से उसने दूर दूर के इस्राईलियों को देखा। ");
INSERT INTO urd_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","और बल'आम ने बलक़ से कहा, “मेरे लिए यहाँ सात मज़बहे बनवा दे, और सात बछड़े और सात मेंढे मेरे लिए यहाँ तैयार कर रख।” ");
INSERT INTO urd_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","बलक़ ने बल'आम के कहने के मुताबिक़ किया, और बलक़ और बल'आम ने हर मज़बह पर एक बछड़ा और एक मेंढा चढ़ाया। ");
INSERT INTO urd_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","फिर बल'आम ने बलक़ से कहा, “तू अपनी सोख़्तनी क़ुर्बानी के पास खड़ा रह, और मैं जाता हूँ, मुम्किन है कि ख़ुदावन्द मुझ से मुलाक़ात करने को आए। इसलिए जो कुछ वह मुझ पर ज़ाहिर करेगा, मैं तुझे बताऊँगा।” और वह एक बरहना पहाड़ी पर चला गया। ");
INSERT INTO urd_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","और ख़ुदा बल'आम से मिला; उसने उससे कहा “मैंने सात मज़बहे तैयार किए हैं और उन पर एक — एक बछड़ा और एक — एक मेंढा चढ़ाया है।” ");
INSERT INTO urd_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","तब ख़ुदावन्द ने एक बात बल'आम के मुँह में डाली और कहा कि “बलक़ के पास लौट जा, और यूँ कहना।” ");
INSERT INTO urd_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","तब वह उसके पास लौट कर आया और क्या देखता है, कि वह अपनी सोख़्तनी क़ुर्बानी के पास मोआब के सब हाकिमों के साथ खड़ा है। ");
INSERT INTO urd_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","तब उसने अपनी मिसाल शुरू' की, और कहने लगा, “बलक़ ने मुझे अराम से, या'नी शाह — ए — मोआब ने पश्चिम के पहाड़ों से बुलवाया, कि आ जा, और मेरी ख़ातिर या'क़ूब पर ला'नत कर, आ, इस्राईल को फटकार! ");
INSERT INTO urd_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","मैं उस पर ला'नत कैसे करूँ, जिस पर ख़ुदा ने ला'नत नहीं की? मैं उसे कैसे फटकारूँ, जिसे ख़ुदावन्द ने नहीं फटकारा ");
INSERT INTO urd_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","चट्टानों की चोटी पर से वह मुझे नज़र आते हैं, और पहाड़ों पर से मैं उनको देखता हूँ। देख, यह वह क़ौम है जो अकेली बसी रहेगी, और दूसरी क़ौमों के साथ मिल कर इसका शुमार न होगा। ");
INSERT INTO urd_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","या'क़ूब की गर्द के ज़र्रों को कौन गिन सकता है, और बनी इस्राईल की चौथाई को कौन शुमार कर सकता है? काश, मैं सादिक़ों की मौत मरूँ और मेरी 'आक़बत भी उन ही की तरह हो।” ");
INSERT INTO urd_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","तब बलक़ ने बल'आम से कहा, “ये तूने मुझ से क्या किया? मैंने तुझे बुलवाया ताकि तू मेरे दुश्मनों पर ला'नत करे, और तू ने उनको बरकत ही बरकत दी।” ");
INSERT INTO urd_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","उसने जवाब दिया और कहा क्या मैं उसी बात का ख़याल न करूँ, जो ख़ुदावन्द मेरे मुँह में डाले?' ");
INSERT INTO urd_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","फिर बलक़ ने उससे कहा, “अब मेरे साथ दूसरी जगह चल, जहाँ से तू उनको देख भी सकेगा; वह सब के सब तो तुझे नहीं दिखाई देंगे, लेकिन जो दूर दूर पड़े हैं उनको देख लेगा; फिर तू वहाँ से मेरी ख़ातिर उन पर ला'नत करना।” ");
INSERT INTO urd_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","तब वह उसे पिसगा की चोटी पर, जहाँ ज़ोफ़ीम का मैदान है ले गया; वहीं उसने सात मज़बहे बनाए और हर मज़बह पर एक — एक बछड़ा और एक मेंढा चढ़ाया। ");
INSERT INTO urd_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","तब उसने बलक़ से कहा, “तू यहाँ अपनी सोख़्तनी क़ुर्बानी के पास ठहरा रह, जब कि मैं उधर जाकर ख़ुदावन्द से मिल कर आऊँ।” ");
INSERT INTO urd_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","और ख़ुदावन्द बल'आम से मिला, और उसने उसके मुँह में एक बात डाली, और कहा, “बलक़ के पास लौट जा, और यूँ कहना।” ");
INSERT INTO urd_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","और जब वह उसके पास लौटा तो क्या देखता है, कि वह अपनी सोख़्तनी क़ुर्बानी कि पास मोआब के हाकिमों के साथ खड़ा है। तब बलक़ ने उससे पूछा, “ख़ुदावन्द ने क्या कहा है?” ");
INSERT INTO urd_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","तब उसने अपनी मिसाल शुरू' की और कहने लगा, “उठ ऐ बलक़, और सुन, ऐ सफ़ोर के बेटे! मेरी बातों पर कान लगा, ");
INSERT INTO urd_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ख़ुदा इंसान नहीं कि झूठ बोले, और न वह आदमज़ाद है कि अपना इरादा बदले। क्या, जो कुछ उसने कहा उसे न करे? या, जो फ़रमाया है उसे पूरा न करे? ");
INSERT INTO urd_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","देख, मुझे तो बरकत देने का हुक्म मिला है; उसने बरकत दी है, और मैं उसे पलट नहीं सकता। ");
INSERT INTO urd_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","वह या'क़ूब में बदी नहीं पाता, और न इस्राईल में कोई ख़राबी देखता है। ख़ुदावन्द उसका ख़ुदा उसके साथ है, और बादशाह के जैसी ललकार उन लोगों के बीच में है। ");
INSERT INTO urd_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ख़ुदा उनको मिस्र से निकाल कर लिए आ रहा है, उनमें जंगली साँड के जैसी ताक़त है। ");
INSERT INTO urd_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","या'क़ूब पर कोई जादू नहीं चलता, और न इस्राईल के ख़िलाफ़ फ़ाल कोई चीज़ है; बल्कि या'क़ूब और इस्राईल के हक़ में अब यह कहा जाएगा, कि ख़ुदा ने कैसे कैसे काम किए। ");
INSERT INTO urd_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","देख, यह गिरोह शेरनी की तरह उठती है। और शेर की तरह तन कर खड़ी होती है। वह अब नहीं लेटने को, जब तक शिकार न खा ले। और मक़तूलों का ख़ून न पी ले।” ");
INSERT INTO urd_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","तब बलक़ ने बल'आम से कहा, “न तो तू उन पर ला'नत ही कर और न उनको बरकत ही दे।” ");
INSERT INTO urd_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","बल'आम ने जवाब दिया, और बलक़ से कहा, “क्या मैंने तुझ से नहीं कहा कि जो कुछ ख़ुदावन्द कहे, वही मुझे करना पड़ेगा?” ");
INSERT INTO urd_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","तब बलक़ ने बल'आम से कहा, “अच्छा आ, मैं तुझ को एक और जगह ले जाऊँ; शायद ख़ुदा को पसन्द आए कि तू मेरी ख़ातिर वहाँ से उन पर ला'नत करे।” ");
INSERT INTO urd_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","तब बलक़ बल'आम को फ़गूर की चोटी पर, जहाँ से यशीमोन नज़र आता है ले गया। ");
INSERT INTO urd_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","और बल'आम ने बलक़ से कहा कि “मेरे लिए यहाँ सात मज़बहे बनवा और सात बैल और सात ही मेंढे मेरे लिए तैयार कर रख।” ");
INSERT INTO urd_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","चुनाँचे बलक़ ने, जैसा बल'आम ने कहा वैसा ही किया और हर मज़बह पर एक बैल और एक मेंढा चढ़ाया। ");
INSERT INTO urd_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","जब बल'आम ने देखा कि ख़ुदावन्द को यही मन्ज़ूर है कि इस्राईल को बरकत दे, तो वह पहले की तरह शगून देखने को इधर उधर न गया, बल्कि वीरान की तरफ़ अपना मुँह कर लिया। ");
INSERT INTO urd_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","और बल'आम ने निगाह की, और देखा कि बनी — इस्राईल अपने — अपने क़बीले की तरतीब से मुक़ीम हैं। और ख़ुदा की रूह उस पर नाज़िल हुई। ");
INSERT INTO urd_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","और उसने अपनी मसल शुरू' की और कहने लगा, “ब'ओर का बेटा बल'आम कहता है, या'नी वही शख़्स जिसकी आँखें बन्द थीं यह कहता है, ");
INSERT INTO urd_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","बल्कि यह उसी का कहना है जो ख़ुदा की बातें सुनता है, और सिज्दे में पड़ा हुआ खुली आँखों से क़ादिर — ए — मुतलक का ख्व़ाब देखता है। ");
INSERT INTO urd_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","ऐ या'क़ूब, तेरे डेरे, ऐ इस्राईल, तेरे ख़ेमें कैसे ख़ुशनुमा हैं! ");
INSERT INTO urd_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","वह ऐसे फैले हुए हैं, जैसे वादियाँ और दरिया कि किनारे बाग़, और ख़ुदावन्द के लगाए हुए 'ऊद के दरख़्त और नदियों के किनारे देवदार के दरख़्त। ");
INSERT INTO urd_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","उसके चरसों से पानी बहेगा, और सेराब खेतों में उसका बीज पड़ेगा। उसका बादशाह अजाज से बढ़कर होगा, और उसकी सल्तनत को 'उरूज हासिल होगा। ");
INSERT INTO urd_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ख़ुदा उसे मिस्र से निकाल कर लिए आ रहा उसमें जंगली सांड के जैसी ताक़त है, वह उन क़ौमों को जो उसकी दुश्मन हैं, चट कर जाएगा, और उनकी हड्डियों को तोड़ डालेगा और उनको अपने तीरों से छेद — छेद कर मारेगा। ");
INSERT INTO urd_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","वह दुबक कर बैठा है, वह शेर की तरह बल्कि शेरनी की तरह लेट गया है, अब कौन उसे छेड़े? जो तुझे बरकत दे वह मुबारक, और जो तुझ पर ला'नत करे वह मला'ऊन हो।” ");
INSERT INTO urd_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","तब बलक़ को बल'आम पर बड़ा ग़ुस्सा आया, और वह अपने हाथ पीटने लगा। फिर उसने बल'आम से कहा, “मैंने तुझे बुलाया कि तू मेरे दुश्मनों पर ला'नत करे, लेकिन तू ने तीनों बार उनको बरकत ही बरकत दी। ");
INSERT INTO urd_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","इसलिए अब तू अपने मुल्क को भाग जा। मैंने तो सोचा था कि तुझे 'आला मन्सब पर मुम्ताज़ करूँ, लेकिन ख़ुदावन्द ने तुझे ऐसे ऐज़ाज़ से महरूम रख्खा।” ");
INSERT INTO urd_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","बल'आम ने बलक़ को जवाब दिया, “क्या मैंने तेरे उन क़ासिदों से भी जिनको तूने मेरे पास भेजा था। यह नहीं कह दिया था, कि ");
INSERT INTO urd_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","अगर बलक़ अपना घर चाँदी और सोने से भर कर मुझे दे तोभी मैं अपनी मर्ज़ी से भला या बुरा करने की ख़ातिर ख़ुदावन्द के हुक्म से तजावुज़ नहीं कर सकता, बल्कि जो कुछ ख़ुदावन्द कहे मैं वही कहूँगा? ");
INSERT INTO urd_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","'और अब मैं अपनी क़ौम के पास लौट कर जाता हूँ, इसलिए तू आ, मैं तुझे आगाह कर दूँ कि यह लोग तेरी क़ौम के साथ आख़िरी दिनों में क्या क्या करेंगे।” ");
INSERT INTO urd_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","चुनौंचे उसने अपनी मिसाल शुरू' की और कहने लगा, “ब'ओर का बेटा बल'आम कहता है, या'नी वही शख़्स जिसकी आँखें बन्द थी यह कहता है, ");
INSERT INTO urd_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","बल्कि यह उसी का कहना है जो ख़ुदा की बातें सुनता है, और हक़ता'ला का इरफ़ान रखता है, और सिज्दे में पड़ा हुआ खुली आँखों से क़ादिर — ए — मुतलक का ख्व़ाब देखता है; ");
INSERT INTO urd_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","मैं उसे देखूँगा तो सही, लेकिन अभी नहीं; वह मुझे नज़र भी आएगा, लेकिन नज़दीक से नहीं; या'क़ूब में से एक सितारा निकलेगा और इस्राईल में से एक 'असा उठेगा, और मोआब के 'इलाक़े को मार मार कर साफ़ कर देगा, और सब हंगामा करने वालों को हलाक कर डालेगा। ");
INSERT INTO urd_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","और उसके दुश्मन अदोम और श'ईर दोनों उसके क़ब्ज़े में होंगे, और इस्राईल दिलावरी करेगा। ");
INSERT INTO urd_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","और या'क़ूब ही की नसल से वह फ़रमाँरवाँ उठेगा, जो शहर के बाक़ी मान्दा लोगों को हलाक कर डालेगा।” ");
INSERT INTO urd_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","फिर उसने 'अमालीक पर नज़र करके अपनी यह मसल शुरू' की, और कहने लगा, “क़ौमोंमें पहली क़ौम 'अमालीक़ की थी, लेकिन उसका अन्जाम हलाकत है।” ");
INSERT INTO urd_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","और कीनियों की तरफ़ निगाह करके यह मिसाल शुरू' की, और कहने लगा “तेरा घर मज़बूत है और तेरा आशियाना भी चट्टान पर बना हुआ है। ");
INSERT INTO urd_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","तोभी क़ीन ख़ाना ख़राब होगा, यहाँ तक कि असूर तुझे ग़ुलाम करके ले जाएगा।” ");
INSERT INTO urd_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","और उसने यह मसल भी शुरू' की, और कहने लगा, हाय, अफ़सोस! जब ख़ुदा यह करेगा तो कौन जीता बचेगा? ");
INSERT INTO urd_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","लेकिन कितीम के साहिल से जहाज़ आएँगे, और वह असूर और इब्र दोनों को दुख देंगे। फिर वह भी हलाक हो जाएगा।” ");
INSERT INTO urd_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","इसके बाद बल'आम उठ कर रवाना हुआ और अपने मुल्क को लौटा, और बलक़ ने भी अपनी राह ली। ");
INSERT INTO urd_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","और इस्राईली शित्तीम में रहते थे, और लोगों ने मोआबी 'औरतों के साथ हरामकारी शुरू' कर दी। ");
INSERT INTO urd_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","क्यूँकि वह 'औरतें इन लोगों को अपने मा'बूदों की क़ुर्बानियों में आने की दावत देती थीं, और यह लोग जाकर खाते और उनके मा'बूदों को सिज्दा करते थे। ");
INSERT INTO urd_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","यूँ इस्राईली बा'ल फ़ग़ूर की इबादत लगे। तब ख़ुदावन्द का क़हर बनी इस्राईल पर भड़का, ");
INSERT INTO urd_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","और ख़ुदावन्द ने मूसा से कहा, “क़ौम के सब सरदारों को पकड़कर ख़ुदावन्द के सामने धूप में टाँग दे, ताकि ख़ुदावन्द का शदीद क़हर इस्राईल पर से टल जाए।” ");
INSERT INTO urd_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","तब मूसा ने बनी — इस्राईल के हाकिमों से कहा, “तुम्हारे जो — जो आदमी बा'ल फ़गूर की इबादत करने लगे हैं उनको क़त्ल कर डालो।” ");
INSERT INTO urd_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","और जब बनी — इस्राईल की जमा'अत ख़ेमा — ए — इजितमा'अ के दरवाज़े पर रो रही थी, तो एक इस्राईली मूसा और तमाम लोगों की आँखों के सामने एक मिदियानी 'औरत को अपने साथ अपने भाइयों के पास ले आया। ");
INSERT INTO urd_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","जब फ़ीन्हास बिन इली'एलियाज़र बिन हारून काहिन ने यह देखा, तो उसने जमा'अत में से उठ हाथ में एक बर्छी ली, ");
INSERT INTO urd_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","और उस मर्द के पीछे जाकर ख़ेमे के अन्दर घुसा और उस इस्राईली मर्द और उस 'औरत दोनों का पेट छेद दिया। तब बनी — इस्राईल में से वबा जाती रही। ");
INSERT INTO urd_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","और जितने इस वबा से मरे उनका शुमार चौबीस हज़ार था। ");
INSERT INTO urd_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","और ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“फ़ीन्हास बिन इली'एलियाज़र बिन हारून काहिन ने मेरे क़हर को बनी — इस्राईल पर से हटाया क्यूँकि उनके बीच उसे मेरे लिए ग़ैरत आई, इसीलिए मैंने बनी — इस्राईल को अपनी ग़ैरत के जोश में हलाक नहीं किया। ");
INSERT INTO urd_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","इसलिए तू कह दे कि मैंने उससे अपना सुलह का 'अहद बाँधा, ");
INSERT INTO urd_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","और वह उसके लिए और उसके बाद उसकी नसल के लिए कहानत का 'दाइमी 'अहद होगा; क्यूँकि वह अपने ख़ुदा के लिए ग़ैरतमन्द हुआ और उसने बनी — इस्राईल के लिए कफ़्फ़ारा दिया।” ");
INSERT INTO urd_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","उस इस्राईली मर्द का नाम जो उस मिदियानी 'औरत के साथ मारा गया ज़िमरी था, जो सलू का बेटा और शमौन के क़बीले के एक आबाई ख़ान्दान का सरदार था। ");
INSERT INTO urd_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","और जो मिदियानी 'औरत मारी गई उसका नाम कज़बी था, वह सूर की बेटी थी जो मिदियान में एक आबाई ख़ान्दान के लोगों का सरदार था। ");
INSERT INTO urd_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","और ख़ुदावन्द ने मूसा से कहा कि, ");
INSERT INTO urd_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“मिदियानियों को सताना और उनको मारना, ");
INSERT INTO urd_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","क्यूँकि वह तुम को अपने धोखे के दाम में फँसाकर सताते हैं, जैसा फ़गूर के मु'आमिले में हुआ और कज़बी के मु'आमिले में भी हुआ।” जो मिदियान के सरदार की बेटी और मिदियानियों की बहन थी, और फ़गूर ही के मु'आमिले में वबा के दिन मारी गई। ");
INSERT INTO urd_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","और वबा के बाद ख़ुदावन्द ने मूसा और हारून काहिन के बोटे इली'एलियाज़र से कहा कि, ");
INSERT INTO urd_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“बनी — इस्राईल की सारी जमा'अत में बीस बरस और उससे ऊपर — ऊपर की उम्र के जितने इस्राईली जंग करने के क़ाबिल हैं, उन सभों को उनके आबाई ख़ान्दानों के मुताबिक़ गिनो।” ");
INSERT INTO urd_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","चुनाँचे मूसा और इली'एलियाज़र काहिन ने मोआब के मैदानों में जो यरदन के किनारे किनारे यरीहू के सामने हैं, उन लोगों से कहा, ");
INSERT INTO urd_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","कि “बीस बरस और उससे ऊपर — ऊपर की उम्र के आदमियों को वैसे ही गिन लो जैसे ख़ुदावन्द ने मूसा और बनी — इस्राईल को, जब वह मुल्क — ए — मिस्र से निकल आए थे हुक्म किया था।” ");
INSERT INTO urd_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","रूबिन जो इस्राईल का पहलौठा था उसके बेटे यह हैं, या'नी हनूक, जिससे हनूकियों का ख़ान्दान चला; और फ़ल्लू, जिससे फ़लवियों का ख़ान्दान चला; ");
INSERT INTO urd_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","और हसरोन, जिससे हसरोनियों का ख़ान्दान चला; और करमी, जिससे करमियों का ख़ान्दान चला। ");
INSERT INTO urd_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ये बनी रूबिन के ख़ान्दान हैं, और इनमें से जो गिने गए वह तैन्तालीस हज़ार सात सौ तीस थे। ");
INSERT INTO urd_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","और फ़ल्लू का बेटा इलियाब था, ");
INSERT INTO urd_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","और इलियाब के बेटे नमूएल और दातन और अबीराम थे। यह वही दातन और अबीराम हैं जो जमा'अत के चुने हुए थे, और जब क़ोरह के फ़रीक़ ने ख़ुदावन्द से झगड़ा किया तो यह भी उस फ़रीक़ के साथ मिल कर मूसा और हारून से झगड़े; ");
INSERT INTO urd_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","और जब उन ढाई सौ आदमियों के आग में भसम हो जाने से वह फ़रीक़ हलाक हो गया, उसी मौक़े' पर ज़मीन ने मुँह खोल कर क़ोरह के साथ उनको भी निगल लिया था; और वह सब 'इबरत का निशान ठहरे। ");
INSERT INTO urd_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","लेकिन क़ोरह के बेटे नहीं मरे थे। ");
INSERT INTO urd_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","और शमौन के बेटे जिनसे उनके ख़ान्दान चले यह हैं, या'नी नमूएल, जिससे नमूएलियों का ख़ान्दान चला; और यमीन, जिससे यमीनियों का ख़ान्दान चला; और यकीन, जिससे यकीनियों का ख़ान्दान चला; ");
INSERT INTO urd_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","और ज़ारह, जिससे ज़ारहियों का ख़ान्दान चला; और साऊल, जिससे साऊलियों का ख़ान्दान चला। ");
INSERT INTO urd_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","तब बनी शमौन के ख़ान्दानों में से बाईस हज़ार दो सौ आदमी गिने गए। ");
INSERT INTO urd_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","और जद्द के बेटे जिनसे उनके ख़ान्दान चले यह हैं, या'नी सफ़ोन, जिससे सफ़ोनियों का ख़ान्दान चला; और हज्जी, जिससे हज्जियों का ख़ान्दान चला; और सूनी, जिससे सूनियों का ख़ान्दान चला; ");
INSERT INTO urd_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","और उज़नी जिससे उज़नियों का ख़ान्दान चला; और 'एरी, जिससे 'एरियों का ख़ान्दान चला; ");
INSERT INTO urd_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","और अरूद, जिससे अरूदियों का ख़ान्दान चला; और अरेली, जिससे अरेलियों का ख़ान्दान चला। ");
INSERT INTO urd_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","बनी जद्द के यही घराने हैं, जो इनमें से गिने गए वह चालीस हज़ार पाँच सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","यहूदाह के बेटों में से 'एर और ओनान तो मुल्क — ए — कना'न ही में मर गए। ");
INSERT INTO urd_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","और यहूदाह के और बेटे जिनसे उनके ख़ान्दान चले यह हैं, या'नी सीला, जिससे सीलानियों का ख़ान्दान चला; और फ़ारस, जिससे फ़ारसियों का ख़ान्दान चला; और ज़ारह, जिससे ज़ारहियों का ख़ान्दान चला। ");
INSERT INTO urd_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","फ़ारस के बेटे यह हैं, या'नी हसरोन, जिससे हसरोनियों का ख़ान्दान चला; और हमूल, जिससे हमूलियों का ख़ान्दान चला। ");
INSERT INTO urd_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ये बनी यहूदाह के घराने हैं। इनमें से छिहत्तर हज़ार पाँच सौ आदमी गिने गए। ");
INSERT INTO urd_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","और इश्कार के बेटे जिनसे उनके ख़ान्दान चले यह हैं, या'नी तोला', जिससे तोल'इयों का ख़ान्दान चला; और फ़ुव्वा, जिससे फ़ुवियों का ख़ान्दान चला: ");
INSERT INTO urd_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","यसूब, जिससे यसूबियों का ख़ान्दान चला; सिमरोन, जिससे सिमरोनियों का ख़ान्दान चला। ");
INSERT INTO urd_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","यह बनी इश्कार के घराने हैं। इनमें से जो गिने गए वह चौंसठ हज़ार तीन सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","और ज़बूलून के बेटे जिनसे उनके ख़ान्दान चले यह हैं, या'नी सरद, जिससे सरदियों का ख़ान्दान चला; एलोन, जिससे एलोनियों का ख़ान्दान चला; यहलीएल, जिससे यहलीएलियों का ख़ान्दान चला। ");
INSERT INTO urd_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","यह बनी ज़बूलून के घराने हैं। इनमें से साठ हज़ार पाँच सौ आदमी गिने गए। ");
INSERT INTO urd_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","और यूसुफ़ के बेटे जिनसे उनके ख़ान्दान चले यह हैं, या'नी मनस्सी और इफ़्राईम। ");
INSERT INTO urd_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","और मनस्सी का बेटा मकीर था, जिससे मकीरियों का ख़ान्दान चला; और मकीर से जिल'आद पैदा हुआ, जिससे जिल'आदियों का ख़ान्दान चला। ");
INSERT INTO urd_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","और जिल'आद के बेटे यह हैं, या'नी ई'एलियाज़र, जिससे ई'अज़रियों का ख़ान्दान चला; और ख़लक़, जिससे ख़लक़ियों का ख़ान्दान चला; ");
INSERT INTO urd_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","और असरीएल, जिससे असरिएलियों का ख़ान्दान चला; और सिकम, जिससे सिकमियों का ख़ान्दान चला; ");
INSERT INTO urd_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","और समीदा', जिससे समीदा'इयों का ख़ान्दान चला; और हिफ़्र, जिससे हिफ़्रियों का ख़ान्दान चला। ");
INSERT INTO urd_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","और हिफ़्र के बेटे सिलाफ़िहाद के यहाँ कोई बेटा नहीं बल्कि बेटियाँ ही हुई, और सिलाफ़िहाद की बेटियों के नाम यह हैं: महलाह, और नू'आह, और हुजलाह, और मिल्काह, और तिरज़ाह। ");
INSERT INTO urd_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","यह बनी मनस्सी के घराने हैं। इनमें से जो गिने गए वह बावन हज़ार सात सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","और इफ़्राईम के बेटे जिनसे उनके ख़ान्दान चले यह हैं, या'नी सुतलह, जिससे सुतलहियों का ख़ान्दान चला; और बकर, जिससे बकरियों का ख़ान्दान चला; और तहन जिससे तहनियों का ख़ान्दान चला। ");
INSERT INTO urd_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","और सुतलह का बेटा 'ईरान था, जिससे 'ईरानियों का ख़ान्दान चला। ");
INSERT INTO urd_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","यह बनी इफ़्राईम के घराने हैं। इनमें से जो गिने गए वह बत्तीस हज़ार पाँच सौ थे। यूसुफ़ के बेटों के ख़ान्दान यही हैं। ");
INSERT INTO urd_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","और बिनयमीन के बेटे जिनसे उनके ख़ान्दान चले यह हैं, या'नी बला', जिससे बला'इयों का ख़ान्दान चला; और अशबील, जिससे अशबीलियों का ख़ान्दान चला; और अख़ीराम, जिससे अख़ीरामियों का ख़ान्दान चला; ");
INSERT INTO urd_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","और सूफ़ाम, जिससे सूफ़ामियों का ख़ान्दान चला; और हूफ़ाम, जिससे हूफ़ामियों का ख़ान्दान चला। ");
INSERT INTO urd_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","बाला' के दो बेटे थे एक अर्द, जिससे अर्दियों का ख़ान्दान चला; दूसरा ना'मान, जिससे ना'मानियों का ख़ानदान चला। ");
INSERT INTO urd_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","यह बनी बिनयमीन के घराने हैं। इनमें से जो गिने गए वह पैंतालस हजार छ: सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","और दान का बेटा जिससे उसका ख़ान्दान चला सुहाम था, उससे सूहामियों ख़ान्दान चला। दानियों का ख़ान्दान यही था। ");
INSERT INTO urd_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","सूहामियों के ख़ान्दान के जो आदमी गिने गए वह चौंसठ हज़ार चार सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","और आशर के बेटे जिनसे उनके ख़ान्दान चले यह हैं, या'नी यिमना, जिससे यिमनियों का ख़ान्दान चला; और इसवी, जिससे इसवियों का ख़ान्दान चला; और बरी'अह, जिससे बरी'अहियों का ख़ान्दान चला। ");
INSERT INTO urd_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","बनी बरी'आह यह हैं, या'नी हिब्र, जिससे हिब्रियों का ख़ान्दान चला; और मलकीएल, जिससे मलकीएलियों का ख़ान्दान चला। ");
INSERT INTO urd_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","और आशर की बेटी का नाम सारा था। ");
INSERT INTO urd_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","यह बनी आशर के घराने हैं, और जो इनमें से गिने गए वह तिरपन हज़ार चार सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","और नफ़्ताली के बेटे जिनसे उनके ख़ान्दान चले यह हैं, या'नी यहसीएल, जिससे यहसीएलियों का ख़ान्दान चला; और जूनी, जिससे जूनियों का ख़ान्दान चला; ");
INSERT INTO urd_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","और यिस्र, जिससे यिस्रियों का ख़ान्दान चला; और सलीम, जिससे सलीमियों का ख़ान्दान चला। ");
INSERT INTO urd_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","यह बनी नफ़्ताली के घराने हैं, और जितने इनमें से गिने गए वह पैंतालीस हज़ार चार सौ थे। ");
INSERT INTO urd_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","फिर बनी — इस्राईल में से जितने गिने गए वह सब मिला कर छः लाख एक हज़ार सात सौ तीस थे। ");
INSERT INTO urd_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","और ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“इन ही को, इनके नामों के शुमार के मुवाफ़िक़ वह ज़मीन मीरास के तौर पर बाँट दी जाए। ");
INSERT INTO urd_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","जिस क़बीले में ज़्यादा आदमी हों उसे ज़्यादा हिस्सा मिले, और जिसमें कम हों उसे कम हिस्सा मिले। हर क़बीले की मीरास उसके गिने हुए आदमियों के शुमार पर ख़त्म हो। ");
INSERT INTO urd_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","लेकिन ज़मीन पर्ची से तक़्सीम की जाए। वह अपने आबाई क़बीलों के नामों के मुताबिक़ मीरास पाएँ। ");
INSERT INTO urd_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","और चाहे ज़्यादा आदमियों का क़बीला हो या थोड़ों का, पर्चीसे उनकी मीरास तक़्सीम की जाए।” ");
INSERT INTO urd_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","और जो लावियों में से अपने — अपने ख़ान्दान के मुताबिक़ गिने गए वह यह हैं, या'नी जैरसोन से जैरसोनियों का घराना, क़िहात से क़िहातियों का घराना, मिरारी से मिरारियों का घराना। ");
INSERT INTO urd_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","और यह भी लावियों के घराने हैं, या'नी लिबनी का घराना, हबरून का घराना, महली का घराना, और मूशी का घराना, और कोरह का घराना। और क क़िहात से अमराम पैदा हुआ। ");
INSERT INTO urd_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","और अमराम की बीवी का नाम यूकबिद था, जो लावी की बेटी थी और मिस्र में लावी के यहाँ पैदा हुई; इसी के हारून और मूसा और उनकी बहन मरियम अमराम से पैदा हुए। ");
INSERT INTO urd_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","और हारून के बेटे यह थे: नदब और अबीहू और इली'एलियाज़र और ऐतामर। ");
INSERT INTO urd_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","और नदब और अबीहू तो उसी वक़्त मर गए जब उन्होंने ख़ुदावन्द के सामने ऊपरी आग पेश कीं थी। ");
INSERT INTO urd_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","फिर उनमें से जितने एक महीने और उससे ऊपर — ऊपर के नरीना फ़र्ज़न्द गिने गए वह तेईस हज़ार थे। यह बनी — इस्राईल के साथ नहीं गिने गए क्यूँकि इनको बनी — इस्राईल के साथ मीरास नहीं मिली। ");
INSERT INTO urd_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","तब मूसा और इली'एलियाज़र काहिन ने जिन बनी — इस्राईल को मोआब के मैदानों में जो यरदन के किनारे किनारे यरीहू के सामने हैं शुमार किया वह यही हैं। ");
INSERT INTO urd_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","लेकिन जिन इस्राईलियों को मूसा और हारून काहिन ने सीना के जंगल में गिना था, उनमें से एक शख़्स भी इनमें न था। ");
INSERT INTO urd_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","क्यूँकि ख़ुदावन्द ने उनके हक़ में कह दिया था कि वह यक़ीनन वीरान में मर जाएँगे, चुनाँचे उनमें से अलावा युफ़न्ना के बेटे कालिब और नून के बेटे यशू'अ के एक भी बाक़ी नहीं बचा था। ");
INSERT INTO urd_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","तब यूसुफ़ के बेटे मनस्सी की औलाद के घरानों में से सिलाफ़िहाद बिन हिफ़्र बिन जिल'आद बिन मकीर बिन मनस्सी की बेटियाँ, जिनके नाम महलाह और नो'आह और हुजलाह और मिलकाह और तिरज़ाह हैं, पास आकर ");
INSERT INTO urd_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ख़ेमा — ए — इजितमा'अ के दरवाज़े पर मूसा और इली'एलियाज़र काहिन और अमीरों और सब जमा'अत के सामने खड़ी हुई और कहने लगीं कि; ");
INSERT INTO urd_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“हमारा बाप वीरान में मरा, लेकिन वह उन लोगों में शामिल न था जिन्होंने क़ोरह के फ़रीक से मिल कर ख़ुदावन्द के ख़िलाफ़ सिर उठाया था; बल्कि वह अपने गुनाह में मरा और उसके कोई बेटा न था। ");
INSERT INTO urd_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","इसलिए बेटा न होने की वजह से हमारे बाप का नाम उसके घराने से क्यूँ मिटने पाए? इसलिए हम को भी हमारे बाप के भाइयों के साथ हिस्सा दो।” ");
INSERT INTO urd_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","मूसा उनके मु'आमिले को ख़ुदावन्द के सामने ले गया। ");
INSERT INTO urd_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“सिलाफ़िहाद की बेटियाँ ठीक कहती हैं; तू उनको उनके बाप के भाइयों के साथ ज़रूर ही मीरास का हिस्सा देना, या'नी उनको उनके बाप की मीरास मिले। ");
INSERT INTO urd_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","और बनी — इस्राईल से कह, कि अगर कोई शख़्स मर जाए और उसका कोई बेटा न हो, तो उस की मीरास उसकी बेटी को देना। ");
INSERT INTO urd_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","अगर उसकी कोई बेटी भी न हो, तो उसके भाइयों को उसकी मीरास देना। ");
INSERT INTO urd_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","अगर उसके भाई भी न हों, तो तुम उसकी मीरास उसके बाप के भाइयों को देना। ");
INSERT INTO urd_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","अगर उसके बाप का भी कोई भाई न हो, तो जो शख़्स उसके घराने में उसका सब से क़रीबी रिश्तेदार हो उसे उसकी मीरास देना; वह उसका वारिस होगा। और यह हुक्म बनी — इस्राईल के लिए, जैसा ख़ुदावन्द ने मूसा को फ़रमाया वाजिबी फ़र्ज़ होगा।” ");
INSERT INTO urd_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","फिर ख़ुदावन्द ने मूसा से कहा, “तू 'अबारीम के इस पहाड़ पर चढ़कर उस मुल्क को, जो मैंने बनी — इस्राईल को 'इनायत किया है देख ले। ");
INSERT INTO urd_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","और जब तू उसे देख लेगा, तो तू भी अपने लोगों में अपने भाई हारून की तरह जा मिलेगा। ");
INSERT INTO urd_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","क्यूँकि सीन के जंगल में जब जमा'अत ने मुझ से झगड़ा किया, तो बरअक्स इसके कि वहाँ पानी के चश्मे पर तुम दोनों उनकी आँखों के सामने मेरी तक़दीस करते, तुम ने मेरे हुक्म से सरकशी की।” यह वही मरीबा का चश्मा है जो दश्त — ए — सीन के क़ादिस में है। ");
INSERT INTO urd_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","मूसा ने ख़ुदावन्द से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“ख़ुदावन्द सारे बशर की रूहों का ख़ुदा, किसी आदमी को इस जमा'अत पर मुक़र्रर करे; ");
INSERT INTO urd_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","जिसकी आमद — ओ — रफ़्त उनके सामने हो और वह उनको बाहर ले जाने और अन्दर ले आने में उनका रहबर हो, ताकि ख़ुदावन्द की जमा'अत उन भेड़ों की तरह न रहे जिनका कोई चरवाहा नहीं।” ");
INSERT INTO urd_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","ख़ुदावन्द ने मूसा से कहा, “तू नून के बेटे यशू'अ को लेकर उस पर अपना हाथ रख, क्यूँकि उस शख़्स में रूह है; ");
INSERT INTO urd_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","और उसे इली'एलियाज़र काहिन और सारी जमा'अत के आगे खड़ा करके उनकी आँखों के सामने उसे वसीयत कर। ");
INSERT INTO urd_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","और अपने रोबदाब से उसे बहरावर कर दे, ताकि बनी — इस्राईल की सारी जमा'अत उसकी फ़रमाबरदारी करे। ");
INSERT INTO urd_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","वह इली'एलियाज़र' काहिन के आगे खड़ा हुआ करे, जो उसकी जानिब से ख़ुदावन्द के सामने ऊरीम का हुक्म दरियाफ़्त किया करेगा। उसी के कहने से वह और बनी — इस्राईल की सारी जमा'अत के लोग निकला करें, और उसी के कहने से लौटा भी करें।” ");
INSERT INTO urd_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","इसलिए मूसा ने ख़ुदावन्द के हुक्म के मुताबिक़ 'अमल किया, और उसने यशू'अ को लेकर उसे इली'एलियाज़र काहिन और सारी जमा'अत के सामने खड़ा किया; ");
INSERT INTO urd_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","और उसने अपने हाथ उस पर रख्खे, और जैसा ख़ुदावन्द ने उसको हुक्म दिया था उसे वसीयत की। ");
INSERT INTO urd_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","और ख़ुदावन्द ने मूसा से कहा कि; ");
INSERT INTO urd_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“बनी — इस्राईल से कह कि मेरा हदिया, या'नी मेरी वह गिज़ा जो राहतअंगेज़ ख़ुशबू की आतिशीन क़ुर्बानी है, तुम याद करके मेरे सामने वक़्त — ए — मु'अय्यन पर पेश करा करना। ");
INSERT INTO urd_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","तू उन से कह दे कि जो आतिशी क़ुर्बानी तुम को ख़ुदावन्द के सामने पेश करना है वह यह है: कि दो बे — 'ऐब यक — साला नर बर्रे हर दिन दाइमी सोख़्तनी क़ुर्बानी के लिए 'अदा करो। ");
INSERT INTO urd_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","एक बर्रा सुबह और दूसरा बर्रा शाम को चढ़ाना; ");
INSERT INTO urd_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","और साथ ही ऐफ़ा के दसवें हिस्से के बराबर मैदा, जिसमें कूट कर निकाला हुआ तेल चौथाई हीन के बराबर मिला हो, नज़्र की क़ुर्बानी के तौर पर पेश करना। ");
INSERT INTO urd_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","यह वही दाइमी सोख़्तनी क़ुर्बानी है जो कोह-ए-सीना पर मुक़र्रर की गई, ताकि ख़ुदावन्द के सामने राहतअंगेज़ ख़ुशबू की आतिशी क़ुर्बानी ठहरे। ");
INSERT INTO urd_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","और हीन की चौथाई के बराबर मय हर एक बर्रा तपावन के लिए लाना। हैकल ही में ख़ुदावन्द के सामने मय का यह तपावन चढ़ाना। ");
INSERT INTO urd_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","और दूसरे बर्रे को शाम के वक़्त चढ़ाना, और उसके साथ भी सुबह की तरह वैसी ही नज़्र की क़ुर्बानी और तपावन हो, ताकि यह ख़ुदावन्द के सामने राहतअंगेज़ ख़ुशबू की आतिशी क़ुर्बानी ठहरे। ");
INSERT INTO urd_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","'और सबत के दिन दो बे — 'ऐब यकसाला नर बर्रे और नज़्र की क़ुर्बानी के तौर पर ऐफ़ा के पाँचवें हिस्से के बराबर मैदा, जिसमें तेल मिला हो, तपावन के साथ पेश करना। ");
INSERT INTO urd_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","दाइमी सोख़्तनी क़ुर्बानी और उसके तपावन के 'अलावा यह हर सब्त की सोख़्तनी क़ुर्बानी है। ");
INSERT INTO urd_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“और अपने महीनों के शुरू' में हर माह दो। बछड़े और एक मेंढा और सात बे'ऐब यक — साला नर बर्रे सोख़्तनी क़ुर्बानी के तौर पर ख़ुदावन्द के सामने चढ़ाया करना। ");
INSERT INTO urd_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","और ऐफ़ा के तीन दहाई हिस्से के बराबर मैदा, जिसमें तेल मिला हो, हर बछड़े के साथ; और ऐफ़ा के पाँचवे हिस्से के बराबर मैदा, जिसमें तेल मिला हो, हर मेंढे के साथ: और ऐफ़ा के दसवें हिस्से के बराबर मैदा, जिसमें तेल मिला हो, ");
INSERT INTO urd_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","हर बर्रे के साथ नज़्र की क़ुर्बानी के तौर पर लाना। ताकि यह राहतअंगेज़ ख़ुशबू की सोख़्तनी कुर्बानी, या'नी ख़ुदावन्द के सामने आतिशीन क़ुर्बानी ठहरे। ");
INSERT INTO urd_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","और इन के साथ तपावन के लिए मय हर एक बछड़ा आधे हीन के बराबर, और हर एक मेंढा तिहाई हीन के बराबर, और हर एक बर्रा चौथाई हीन के बराबर हो। यह साल भर के हर महीने की सोख़्तनी क़ुर्बानी है। ");
INSERT INTO urd_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","और उस दाइमी सोख़्तनी क़ुर्बानी और उसके तपावन के 'अलावा एक बकरा ख़ता की क़ुर्बानी के तौर पर ख़ुदावन्द के सामने पेश करा जाए। ");
INSERT INTO urd_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","और पहले महीने की चौदहवीं तारीख़ को ख़ुदावन्द की फ़सह हुआ करे। ");
INSERT INTO urd_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","और उसी महीने की पंद्रहवीं तारीख़ को 'ईद हो, और सात दिन तक बेख़मीरी रोटी खाई जाए। ");
INSERT INTO urd_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","पहले दिन लोगों का पाक मजमा' हो, तुम उस दिन कोई ख़ादिमाना काम न करना। ");
INSERT INTO urd_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","बल्कि तुम आतिशी क़ुर्बानी, या'नी ख़ुदावन्द के सामने सोख़्तनी क़ुर्बानी के तौर पर दो बछड़े और एक मेंढा और सात यक — साला नर बर्रे चढ़ाना। यह सब के सब बे — 'ऐब हों। ");
INSERT INTO urd_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","और उनके साथ नज़्र की क़ुर्बानी के तौर पर तेल मिला हुआ मैदा; हर एक बछड़ा ऐफ़ा के तीन दहाई हिस्से के बराबर, और हर एक मेंढा पाँचवें हिस्से के बराबर। ");
INSERT INTO urd_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","और सातों बर्रों में से हर बर्रा पीछे ऐफ़ा के दसवें हिस्से के बराबर पेश करा करना। ");
INSERT INTO urd_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","और ख़ता की क़ुर्बानी के लिए एक बकरा हो, ताकि उससे तुम्हारे लिए कफ़्फ़ारा दिया जाए। ");
INSERT INTO urd_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","तुम सुबह की सोख़्तनी क़ुर्बानी के 'अलावा, जो दाइमी सोख़्तनी क़ुर्बानी है, इनको भी पेश करना। ");
INSERT INTO urd_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","इसी तरह तुम हर दिन सात दिन तक आतिशी क़ुर्बानी की यह ग़िज़ा चढ़ाना, ताकि वह ख़ुदावन्द के सामने राहतअंगेज़ ख़ुशबू ठहरे; दिन — मर्रा की दाइमी सोख़्तनी क़ुर्बानी और तपावन के 'अलावा यह भी पेश करा जाए। ");
INSERT INTO urd_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","और सातवें दिन फिर तुम्हारा पाक मज़मा हो उसमें कोई ख़ादिमाना काम न करना। ");
INSERT INTO urd_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","'और पहले फलों के दिन, जब तुम नई नज़्र की क़ुर्बानी हफ़्तों की 'ईद में ख़ुदावन्द के सामने पेश करो, तब भी तुम्हारा पाक मजमा' हो; उस दिन कोई ख़ादिमाना काम न करना। ");
INSERT INTO urd_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","बल्कि तुम सोख़्तनी क़ुर्बानी के तौर पर दो बछड़े, एक मेंढा और सात यक — साला नर बर्रे पेश करना; ताकि यह ख़ुदावन्द के सामने राहत अंगेज़ ख़ुशबू हो, ");
INSERT INTO urd_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","और इनके साथ नज़्र की क़ुर्बानी के तौर पर तेल मिला हुआ मैदा; हर बछड़ा ऐफ़ा के तीन दहाई हिस्से के बराबर, और हर मेंढा पाँचवें हिस्से के बराबर, ");
INSERT INTO urd_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","और सातों बर्रों में से हर बर्रे पीछे ऐफ़ा के दसवें हिस्से के बराबर हो। ");
INSERT INTO urd_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","और एक बकरा हो ताकि तुम्हारे लिए कफ़्फ़ारा दिया जाए। ");
INSERT INTO urd_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","दाइमी सोख़्तनी क़ुर्बानी और उसकी नज़्र की क़ुर्बानी के 'अलावा तुम इनको भी पेश करना। यह सब बे — 'ऐब हों और इनके तपावन साथ हों। ");
INSERT INTO urd_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","और सातवें महीने की पहली तारीख़ को तुम्हारा पाक मजमा' हो, उसमें कोई ख़ादिमाना काम न करना। यह तुम्हारे लिए नरसिंगे फूँकने का दिन है। ");
INSERT INTO urd_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","तुम सोख़्तनी क़ुर्बानी के तौर पर एक बछड़ा, एक मेंढा और सात बे — 'ऐब यक — साला नर बर्रे चढ़ाना ताकि यह ख़ुदावन्द के सामने राहत अंगेज़ ख़ुशबू ठहरे। ");
INSERT INTO urd_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","और इनके साथ नज़्र की क़ुर्बानी के तौर पर तेल मिला हुआ मैदा; बछड़ा ऐफ़ा के तीन दहाई हिस्से के बराबर, और हर मेंढा पाँचवें हिस्से के बराबर, ");
INSERT INTO urd_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","और सातों बर्रों में से हर बर्रे पीछे ऐफ़ा के दसवें हिस्से के बराबर हो। ");
INSERT INTO urd_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","और एक बकरा ख़ता की क़ुर्बानी के लिए हो, ताकि तुम्हारे वास्ते कफ़्फ़ारा दिया जाए। ");
INSERT INTO urd_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","नये चाँद की सोख़्तनी क़ुर्बानी और उसकी नज़्र की क़ुर्बानी, और दाइमी सोख़्तनी क़ुर्बानी और उसकी नज़्र की क़ुर्बानी और उनके तपावनों के 'अलावा, जो अपने — अपने क़ानून के मुताबिक़ पेश करे जाएँगे, यह भी राहतअंगेज़ ख़ुशबू की आतिशी क़ुर्बानी के तौर पर ख़ुदावन्द के सामने अदा किये जाए। ");
INSERT INTO urd_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","'फिर उसी सातवें महीने की दसवीं तारीख़ को तुम्हारा पाक मजमा' हो; तुम अपनी अपनी जान को दुख देना और किसी तरह का काम न करना, ");
INSERT INTO urd_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","बल्कि सोख़्तनी क़ुर्बानी के तौर पर एक बछड़ा, एक मेंढा और सात यक — साला नर बर्रे ख़ुदावन्द के सामने चढ़ाना, ताकि यह राहतअंगेज़ ख़ुशबू ठहरे; यह सब के सब बे — 'ऐब हों, ");
INSERT INTO urd_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","और इनके साथ नज़्र की क़ुर्बानी के तौर पर तेल मिला हुआ मैदा; हर बछड़ा ऐफ़ा के तीन दहाई हिस्से के बराबर, और हर मेंढा पाँचवें हिस्से के बराबर, ");
INSERT INTO urd_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","और सातों बर्रों में से हर बर्रे पीछे ऐफ़ा के दसवें हिस्से के बराबर हो, ");
INSERT INTO urd_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","और ख़ता की क़ुर्बानी के लिए एक बकरा हो; यह भी उस ख़ता की क़ुर्बानी के 'अलावा, जो कफ़्फ़ारे के लिए है और दाइमी सोख़्तनी क़ुर्बानी और उसकी नज़्र की कुर्बानी, और तपावनों के 'अलावा अदा किये जाएँ। ");
INSERT INTO urd_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","और सातवें महीने की पन्द्रहवीं तारीख़ को फिर तुम्हारा पाक मजमा' हो; उस दिन तुम कोई ख़ादिमाना काम न करना, और सात दिन तक ख़ुदावन्द की ख़ातिर 'ईद मनाना। ");
INSERT INTO urd_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","और तुम सोख़्तनी क़ुर्बानी के तौर पर तेरह बछड़े, दो मेंढे, और चौदह यक — साला नर बर्रे चढ़ाना ताकि यह राहत अंगेज़ ख़ुशबू ख़ुदावन्द के लिए आतिशीन क़ुर्बानी ठहरे; यह सब के सब बे — 'ऐब हों। ");
INSERT INTO urd_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","और इनके साथ नज़्र की क़ुर्बानी के तौर पर तेरह बछड़ों में से हर बछड़े पीछे तेल मिला हुआ मैदा ऐफ़ा के तीन दहाई हिस्से के बराबर, और दोनों मेंढों में से हर मेंढे पीछे पाँचवें हिस्से के बराबर, ");
INSERT INTO urd_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","और चौदह बर्रों में से हर बर्रे पीछे ऐफ़ा के दसवें हिस्से के बराबर हो। ");
INSERT INTO urd_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","और एक बकरा ख़ता की क़ुर्बानी के लिए हो। यह सब दाइमी सोख़्तनी क़ुर्बानी और उसकी नज़्र की क़ुर्बानी और तपावन के 'अलावा चढ़ाए जाएँ। ");
INSERT INTO urd_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“और दूसरे दिन बारह बछड़े, दो मेंढे और चौदह बे — 'ऐब यक — साला नर बर्रे चढ़ाना। ");
INSERT INTO urd_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","और बछड़ों और मेंढों और बर्रों के साथ, उनके शुमार और तौर तरीक़े के मुताबिक़ उनकी नज़्र की क़ुर्बानी और तपावन हों, ");
INSERT INTO urd_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","और एक बकरा ख़ता की क़ुर्बानी के लिए हो। यह सब दाइमी सोख़्तनी क़ुर्बानी और उसकी नज़्र की क़ुर्बानी और तपावनों के 'अलावा चढ़ाए जाएँ। ");
INSERT INTO urd_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","'और तीसरे दिन ग्यारह बछड़े, दो मेंढे और चौदह यक — साला बे — 'ऐब नर बर्रे हों। ");
INSERT INTO urd_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","और बछड़ों और मेंढों और बर्रों के साथ, उनके शुमार और तौर तरीक़े के मुताबिक़ उनकी नज़्र की क़ुर्बानी और तपावन हों, ");
INSERT INTO urd_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","और एक बकरा ख़ता की क़ुर्बानी के लिए हो। यह सब दाइमी सोख़्तनी क़ुर्बानी और उसकी नज़्र की क़ुर्बानी और तपावन के अलावा चढ़ाए जाएँ। ");
INSERT INTO urd_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","'और चौथे दिन दस बछड़े, दो मेंढे और चौदह यक — साला बे — 'ऐब नर बर्रे हों। ");
INSERT INTO urd_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","और बछड़ों और मेंढों और बर्रों के साथ, उनके शुमार और तौर तरीक़े के मुताबिक़ उनकी नज़्र की क़ुर्बानी और तपावन हों, ");
INSERT INTO urd_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","और एक बकरा ख़ता की क़ुर्बानी के लिए हो। यह सब दाइमी सोख़्तनी क़ुर्बानी और उसकी नज़्र की क़ुर्बानी और तपावन के 'अलावा चढ़ाए जाए। ");
INSERT INTO urd_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“और पाँचवे दिन नौ बछड़े, दो मेंढे और चौदह यक — साला बे — 'ऐब नर बर्रे हों। ");
INSERT INTO urd_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","और बछड़ों और मेंढों और बर्रों के साथ, उनके शुमार और क़ानून के मुताबिक़ उनकी नज़्र की क़ुर्बानी और तपावन हों, ");
INSERT INTO urd_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","और एक बकरा ख़ता की क़ुर्बानी के लिए हो। यह सब दाइमी सोख़्तनी क़ुर्बानी और उसकी नज़्र की क़ुर्बानी और तपावन के 'अलावा चढ़ाए जाए। ");
INSERT INTO urd_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","'और छठे दिन आठ बछड़े, दो मेंढे और चौदह यक — साला बे — 'ऐब नर बर्रे हों। ");
INSERT INTO urd_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","और बछड़ों और मेंढों और बर्रों के साथ, उनके शुमार और क़ानून के मुताबिक़ उनकी नज़्र की क़ुर्बानी और तपावन हों; ");
INSERT INTO urd_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","और एक बकरा ख़ता की क़ुर्बानी के लिए हो। यह सब दाइमी सोख़्तनी क़ुर्बानी और उसकी नज़्र की क़ुर्बानी और तपावन के 'अलावा अदा की जाए। ");
INSERT INTO urd_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“और सातवें दिन सात बछड़े, दो मेंढे और चौदह यक — साला बे — 'ऐब नर बर्रे हों। ");
INSERT INTO urd_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","और बछड़ों और मेंढों और बर्रों के साथ, उनके शुमार और तौर तरीक़े के मुताबिक़ उनकी नज़्र की क़ुर्बानी और तपावन हों, ");
INSERT INTO urd_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","और एक बकरा ख़ता की क़ुर्बानी के लिए हो। यह सब दाइमी सोख़्तनी क़ुर्बानी और उसकी नज़्र की क़ुर्बानी और तपावन के अलावा अदा की जाएँ ");
INSERT INTO urd_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“और आठवें दिन तुम्हारा पाक मजमा' हो; तुम उस दिन कोई ख़ादिमाना काम न करना, ");
INSERT INTO urd_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","बल्कि तुम एक बछड़ा, एक मेंढा, और सात यक — साला बे — 'ऐब नर बर्रे सोख़्तनी क़ुर्बानी के तौर पर चढ़ाना ताकि वह ख़ुदावन्द के सामने राहतअंगेज़ ख़ुशबू की आतिशी क़ुर्बानी ठहरे। ");
INSERT INTO urd_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","और बछड़े और मेंढे और बर्रों के साथ, उनके शुमार और तौर तरीक़े के मुताबिक़ उनकी नज़्र की क़ुर्बानी और तपावन हों, ");
INSERT INTO urd_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","और एक बकरा ख़ता की क़ुर्बानी के लिए हो। यह सब दाइमी सोख़्तनी क़ुर्बानी और उसकी नज़्र की क़ुर्बानी और तपावन के 'अलावा चढ़ाए जाएँ। ");
INSERT INTO urd_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“तुम अपनी मुक़र्ररा 'ईदों में अपनी मिन्नतों और रज़ा की क़ुर्बानियों के 'अलावा यहीं सोख़्तनी क़ुर्बानियाँ और नज़्र की कुर्बानियाँ और तपावन और सलामती की कुर्बानियाँ ख़ुदावन्द को पेश करना।” ");
INSERT INTO urd_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","और जो कुछ ख़ुदावन्द ने मूसा को हुक्म दिया, वह सब मूसा ने बनी इस्राईल को बता दिया। ");
INSERT INTO urd_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","और मूसा ने बनी — इस्राईल के क़बीलों के सरदारों से कहा, “जिस बात का ख़ुदावन्द ने हुक्म दिया है वह यह है, कि ");
INSERT INTO urd_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","जब कोई मर्द ख़ुदावन्द की मिन्नत माने या क़सम खाकर अपने ऊपर कोई ख़ास फ़र्ज़ ठहराए, तो वह अपने 'अहद को न तोड़े; बल्कि जो कुछ उसके मुँह से निकला है उसे पूरा करे। ");
INSERT INTO urd_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","और अगर कोई 'औरत ख़ुदावन्द की मिन्नत माने और अपनी नौ जवानी के दिनों में अपने बाप के घर होते हुए अपने ऊपर कोई फ़र्ज़ ठहराए। ");
INSERT INTO urd_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","और उसका बाप उसकी मिन्नत और उसके फ़र्ज़ का हाल जो उसने अपने ऊपर ठहराया है सुनकर चुप हो रहे, तो वह सब मिन्नतें और सब फ़र्ज़ जो उस 'औरत ने अपने ऊपर ठहराए हैं क़ाईम रहेंगे। ");
INSERT INTO urd_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","लेकिन अगर उसका बाप जिस दिन यह सुने उसी दिन उसे मना' करे, तो उसकी कोई मिन्नत या कोई फ़र्ज़ जो उसने अपने ऊपर ठहराया है, क़ाईम नहीं रहेगा; और ख़ुदावन्द उस 'औरत को मा'ज़ूर रख्खेगा क्यूँकि उसके बाप ने उसे इजाज़त नहीं दी। ");
INSERT INTO urd_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","और अगर किसी आदमी से उसकी निस्बत हो जाए, हालाँके उसकी मिन्नतें या मुँह की निकली हुई बात जो उसने अपने ऊपर फ़र्ज़ ठहराई है, अब तक पूरी न हुई हो; ");
INSERT INTO urd_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","और उसका आदमी यह हाल सुनकर उस दिन उससे कुछ न कहे तो उसकी मनतें क़ाईम रहेंगी, और जो बातें उसने अपने ऊपर फ़र्ज़ ठहराई हैं वह भी क़ाईम रहेंगी। ");
INSERT INTO urd_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","लेकिन अगर उसका आदमी जिस दिन यह सब सुने, उसी दिन उसे मना' करे तो उसने जैसे उस 'औरत की मिन्नत को और उसके मुँह की निकली हुई बात को जो उसने अपने ऊपर फ़र्ज़ ठहराई थी तोड़ दिया; और ख़ुदावन्द उस 'औरत को मा'जूर रख्खेगा। ");
INSERT INTO urd_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","लेकिन बेवा और तलाकशुदा कीं मिन्नतें और फ़र्ज़ ठहरायी हुई बातें क़ाईम रहेंगी। ");
INSERT INTO urd_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","और अगर उसने अपने शौहर के घर होते हुए कुछ मिन्नत मानी या क़सम खाकर अपने ऊपर कोई फ़र्ज़ ठहराया हो, ");
INSERT INTO urd_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","और उसका शौहर यह हाल सुन कर ख़ामोश रहा हो और उसे मना' न किया हो, तो उसकी मिन्नतें और सब फ़र्ज़ जो उसने अपने ऊपर ठहराए क़ाईम रहेंगे। ");
INSERT INTO urd_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","लेकिन अगर उसके शौहर ने जिस दिन यह सब सुना उसी दिन उसे बातिल ठहराया हो, तो जो कुछ उस 'औरत के मुँह से उसकी मिन्नतों और ठहराए हुए फ़र्ज़ के बारे में निकला है, वह क़ाईम नहीं रहेगा; उसके शौहर ने उनको तोड़ डाला है, और ख़ुदावन्द उस 'औरत को मा'ज़ूर रख्खेगा। ");
INSERT INTO urd_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","उसकी हर मिन्नत को और अपनी जान को दुख देने की हर क़सम को उसका शौहर चाहे तो क़ाईम रख्खे, या अगर चाहे तो बातिल ठहराए। ");
INSERT INTO urd_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","लेकिन अगर उसका शौहर दिन — ब — दिन ख़ामोश ही रहे, तो वह जैसे उसकी सब मिन्नतों और ठहराए हुए फ़र्ज़ों को क़ाईम कर देता है; उसने उनको क़ाईम यूँ किया कि जिस दिन से सब सुना वह ख़ामोश ही रहा। ");
INSERT INTO urd_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","लेकिन अगर वह उनको सुन कर बाद में उनको बातिल ठहराए तो वह उस 'औरत का गुनाह उठाएगा।” ");
INSERT INTO urd_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","शौहर और बीवी के बीच और बाप बेटी के बीच, जब बेटी नौ — जवानी के दिनों में बाप के घर हो, इन ही तौर तरीक़े का हुक्म ख़ुदावन्द ने मूसा को दिया। ");
INSERT INTO urd_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","फिर ख़ुदावन्द ने मूसा से कहा, ");
INSERT INTO urd_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“मिदियानियों से बनी — इस्राईल का इन्तक़ाम ले; इसके बाद तू अपने लोगों में जा मिलेगा।” ");
INSERT INTO urd_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","तब मूसा ने लोगों से कहा, “अपने में से जंग के लिए आदमियों को हथियारबन्द करो, ताकि वह मिदियानियों पर हमला करें और मिदियानियों से ख़ुदावन्द का इन्तक़ाम लें। ");
INSERT INTO urd_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","और इस्राईल के सब क़बीलों में से हर क़बीला एक हज़ार आदमी लेकर जंग के लिए भेजना।” ");
INSERT INTO urd_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","फिर हज़ारों हज़ार बनी — इस्राईल में से हर क़बीला एक हज़ार के हिसाब से बारह हज़ार हथियारबन्द आदमी जंग के लिए चुने गए। ");
INSERT INTO urd_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","यूँ मूसा ने हर क़बीले से एक हज़ार आदमियों को जंग के लिए भेजा और इली'एलियाज़र काहिन के बेटे फ़ीन्हास को भी जंग पर रवाना किया, और हैकल के बर्तन और बलन्द आवाज़ के नरसिंगे उसके साथ कर दिए। ");
INSERT INTO urd_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","और जैसा ख़ुदावन्द ने मूसा को हुक्म दिया था, उसके मुताबिक़ उन्होंने मिदियानियों से जंग की और सब मर्दों को क़त्ल किया। ");
INSERT INTO urd_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","और उन्होंने उन मक्तूलों के अलावा ईव्वी और रक़म और सूर और होर और रबा' को भी, जो मिदियान के पाँच बादशाह थे, जान से मारा और ब'ओर के बेटे बल'आम को भी तलवार से क़त्ल किया। ");
INSERT INTO urd_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","और बनी — इस्राईल ने मिदियान की 'औरतों और उनके बच्चों को ग़ुलाम किया, और उनके चौपाये और भेड़ बकरियाँ और माल — ओ — अस्बाब सब कुछ लूट लिया। ");
INSERT INTO urd_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","और उनकी सुकुनतगाहों के सब शहरों को जिनमें वह रहते थे, और उनकी सब छावनियों को आग से फूँक दिया। ");
INSERT INTO urd_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","और उन्होंने सारा माल — ए — ग़नीमत और सब ग़ुलाम, क्या इंसान और क्या हैवान साथ लिए, ");
INSERT INTO urd_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","और उन ग़ुलामों और माल — ए — ग़नीमत को मूसा और इली'एलियाज़र काहिन और बनी इस्राईल की सारी जमा'अत के पास उस लश्करगाह में ले आए जो यरीहू के सामने यरदन के किनारे किनारे मोआब के मैदानों में थी। ");
INSERT INTO urd_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","तब मूसा और इली'एलियाज़र काहिन और जमा'अत के सब सरदार उनके इस्तक़बाल के लिए लश्करगाह के बाहर गए। ");
INSERT INTO urd_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","और मूसा उन फ़ौजी सरदारों पर जो हज़ारों और सैकड़ों के सरदार थे और जंग से लौटे थे झल्लाया, ");
INSERT INTO urd_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","और उनसे कहने लगा, “क्या तुम ने सब 'औरतें जीती बचा रख्खी हैं? ");
INSERT INTO urd_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","देखो, इन ही ने बल'आम की सलाह से फ़गूर के मु'आमिले में बनी — इस्राईल से ख़ुदावन्द की हुक्म उदूली कराई, और यूँ ख़ुदावन्द की जमा'अत में वबा फैली। ");
INSERT INTO urd_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","इसलिए इन बच्चों में जितने लड़के हैं सब को मार डालो, और जितनी 'औरतें मर्द का मुँह देख चुकी हैं उनको क़त्ल कर डालो। ");
INSERT INTO urd_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","लेकिन उन लड़कियों को जो मर्द से वाक़िफ़ नहीं और अछूती हैं, अपने लिए ज़िन्दा रख्खो। ");
INSERT INTO urd_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","और तुम सात दिन तक लश्करगाह के बाहर ही ख़ेमे डाले पड़े रहो, और तुम में से जितनों ने किसी आदमी की जान से मारा हो और जितनों ने किसी मक़्तूल को छुआ हो, वह सब अपने आप को और अपने कैदियों को तीसरे दिन और सातवें दिन पाक करें। ");
INSERT INTO urd_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","तुम अपने सब कपड़ों और चमड़े की सब चीज़ों को और बकरी के बालों की बुनी हुई चीज़ों को और लकड़ी के सब बर्तनों को पाक करना।” ");
INSERT INTO urd_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","और इली'एलियाज़र काहिन ने उन सिपाहियों से जो जंग पर गए थे कहा, शरी'अत का वह क़ानून जिसका हुक्म ख़ुदावन्द ने मूसा को दिया यही है, कि ");
INSERT INTO urd_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","सोना और चाँदी और पीतल और लोहा और रांगा और सीसा; ");
INSERT INTO urd_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ग़रज़ जो कुछ आग में ठहर सके वह सब तुम आग में डालना तब वह साफ़ होगा, तो भी नापाकी दूर करने के पानी से उसे पाक करना पड़ेगा; और जो कुछ आग में न ठहर सके उसे तुम पानी में डालना। ");
INSERT INTO urd_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","और तुम सातवें दिन अपने कपड़े धोना तब तुम पाक ठहरोगे, इसके बाद लश्करगाह में दाख़िल होना। ");
INSERT INTO urd_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","और ख़ुदावन्द ने मूसा से कहा कि, ");
INSERT INTO urd_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“इली'एलियाज़र काहिन और जमा'अत के आबाई ख़ान्दानों के सरदारों को साथ लेकर, तू उन आदमियों और जानवरों को शुमार कर जो लूट में आए हैं। ");
INSERT INTO urd_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","और लूट के इस माल को दो हिस्सों में तक़्सीम कर कि, एक हिस्सा उन जंगी मर्दों को दे जो लड़ाई में गए थे और दूसरा हिस्सा जमा'अत को दे। ");
INSERT INTO urd_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","और उन जंगी मर्दों से जो लड़ाई में गए थे, ख़ुदावन्द के लिए चाहे आदमी हों या गाय — बैल या गधे या भेड़ बकरियाँ, हर पाँच सौ पीछे एक को हिस्से के तौर पर ले; ");
INSERT INTO urd_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","इनही के आधे में से इस हिस्से को लेकर इली'एलियाज़र काहिन को देना, ताकि यह ख़ुदावन्द के सामने उठाने की क़ुर्बानी ठहरे। ");
INSERT INTO urd_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","और बनी — इस्राईल के आधे में से चाहे आदमी हों या गाय — बैल या गधे या भेड़ — बकरियाँ, या'नी सब क़िस्म के चौपायों में से पचास — पचास पीछे एक — एक को लेकर लावियों को देना जो ख़ुदावन्द के घर की मुहाफ़िज़त करते हैं।” ");
INSERT INTO urd_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","चुनाँचे मूसा और इली'एलियाज़र काहिन ने जैसा ख़ुदावन्द ने मूसा से कहा था वैसा ही किया। ");
INSERT INTO urd_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","और जो कुछ माल — ए — ग़नीमत जंगी मदों के हाथ आया था उसे छोड़कर लूट के माल में छः लाख पिछतर हज़ार भेड़ — बकरियाँ थीं; ");
INSERT INTO urd_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","और बहतर हज़ार गाय — बैल, ");
INSERT INTO urd_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","और इकसठ हज़ार गधे, ");
INSERT INTO urd_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","और नुफूस — ए — इंसानी में से बतीस हज़ार ऐसी 'औरतें जो मर्द से नावाक़िफ़ और अछूती थीं। ");
INSERT INTO urd_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","और लूट के माल के उस आधे में जो जंगी मदों का हिस्सा था, तीन लाख सैंतीस हज़ार पाँच सौ भेड़ — बकरियाँ थीं, ");
INSERT INTO urd_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","जिनमें से छ: सौ पिछतर भेड़ — बकरियाँ ख़ुदावन्द के हिस्से के लिए थीं। ");
INSERT INTO urd_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","और छत्तीस हज़ार गाय — बैल थे, जिनमें से बहत्तर ख़ुदावन्द के हिस्से के थे। ");
INSERT INTO urd_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","और तीस हज़ार पाँच सौ गधे थे, जिनमें से इकसठ गधे ख़ुदावन्द के हिस्से के थे। ");
INSERT INTO urd_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","और नुफूस — ए — इंसानी का शुमार सोलह हज़ार था, जिनमें से बतीस जानें ख़ुदावन्द के हिस्से की थीं। ");
INSERT INTO urd_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","तब मूसा ने ख़ुदावन्द के हुक्म के मुवाफ़िक उस हिस्से को जो ख़ुदावन्द के उठाने की क़ुर्बानी थी, इली'एलियाज़र काहिन को दिया। ");
INSERT INTO urd_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","अब रहा बनी — इस्राईल का आधा हिस्सा, जिसे मूसा ने जंगी मर्दों के हिस्से से अलग रख्खा था; ");
INSERT INTO urd_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","फिर इस आधे में भी जो जमा'अत को दिया गया तीन लाख सैंतीस हज़ार पाँच सौ भेड़ — बकरियाँ थीं, ");
INSERT INTO urd_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","और छत्तीस हज़ार गाय — बैल ");
INSERT INTO urd_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","और तीस हज़ार पाँच सौ गधे, ");
INSERT INTO urd_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","और सोलह हज़ार नुफूस — ए — इंसान ी। ");
INSERT INTO urd_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","और बनी — इस्राईल के इस आधे में से मूसा ने ख़ुदावन्द के हुक्म के मुवाफ़िक, क्या इंसान और क्या हैवान हर पचास पीछे एक को लेकर लावियों को दिया जो ख़ुदावन्द के घर की मुहाफ़िज़त करते थे। ");
INSERT INTO urd_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","तब वह फ़ौजी सरदार जो हज़ारों और सैकड़ों सिपाहियों के सरदार थे, मूसा के पास आकर ");
INSERT INTO urd_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","उससे कहने लगे, “तेरे ख़ादिमों ने उन सब जंगी मदों को जो हमारे मातहत हैं गिना, और उनमें से एक जवान भी कम न हुआ। ");
INSERT INTO urd_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","इसलिए हम में से जो कुछ जिसके हाथ लगा, या'नी सोने के ज़ेवर और पाज़ेब और कंगन और अंगूठियाँ और मुन्दरें और बाज़ूबन्द यह सब हम ख़ुदावन्द के हदिये के तौर पर ले आए हैं ताकि हमारी जानों के लिए ख़ुदावन्द के सामने कफ़्फ़ारा दिया जाए।” ");
INSERT INTO urd_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","चुनाँचे मूसा और इली'एलियाज़र काहिन ने उनसे यह सब सोने के घड़े हुए ज़ेवर ले लिए। ");
INSERT INTO urd_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","और उस हदिये का सारा सोना जो हज़ारों और सैकड़ों के सरदारों ने ख़ुदावन्द के सामने पेश कर, वह या'नी, तकरीबन 190 कि. ग्रा. या'नीसोलह हज़ार सात सौ पचास मिस्काल था। ");
INSERT INTO urd_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","क्यूँकि जंगी मर्दों में से हर एक कुछ न कुछ लूट कर ले आया था। ");
INSERT INTO urd_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","तब मूसा और इली'एलियाज़र काहिन उस सोने को जो उन्होंने हज़ारों और सैकड़ों के सरदारों से लिया था, ख़ेमा — ए — इजितमा'अ में लाए ताकि वह ख़ुदावन्द के सामने बनी — इस्राईल की यादगार ठहरे। ");
INSERT INTO urd_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","और बनी रूबिन और बनी जद्द के पास चौपायों के बहुत बड़े बड़े ग़ोल थे। इसलिए जब उन्होंने या'ज़ेर और जिल'आद के मुल्कों को देखा कि यह मक़ाम चौपायों के लिए बहुत अच्छे हैं, ");
INSERT INTO urd_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","तो उन्होंने जाकर मूसा और इली'एलियाज़र काहिन और जमा'अत के सरदारों से कहा कि, ");
INSERT INTO urd_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","'अतारात और दीबोन और या'ज़ेर और निमरा और हस्बोन, इली'आली और शबाम और नबू और बऊन, ");
INSERT INTO urd_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","या'नी वह मुल्क जिस पर ख़ुदावन्द ने इस्राईल की जमा'अत को फ़तह दिलाई है, चौपायों के लिए बहुत अच्छा है और तेरे ख़ादिमों के पास चौपाये हैं। ");
INSERT INTO urd_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","इसलिए अगर हम पर तेरे करम की नज़र है तो इसी मुल्क को अपने ख़ादिमों की मीरास कर दे, और हम को यरदन पार न ले जा। ");
INSERT INTO urd_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","मूसा ने बनी रूबिन और बनी जद्द से कहा, “क्या तुम्हारे भाई लड़ाई में जाएँ और तुम यहीं बैठे रहो? ");
INSERT INTO urd_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","तुम क्यूँ बनी — इस्राईल को पार उतर कर उस मुल्क में जाने से, जो ख़ुदावन्द ने उन को दिया है, बेदिल करते हो? ");
INSERT INTO urd_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","तुम्हारे बाप दादा ने भी, जब मैंने उनको क़ादिस बरनी' से भेजा कि मुल्क का हाल दरियाफ़्त करें तो ऐसा ही किया था। ");
INSERT INTO urd_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","क्यूँकि जब वह वादी — ए — इस्काल में पहुँचे और उस मुल्क को देखा, तो उन्होंने बनी — इस्राईल को बे — दिल कर दिया, ताकि वह उस मुल्क में जो ख़ुदावन्द ने उनको 'इनायत किया न जाएँ। ");
INSERT INTO urd_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","और उसी दिन ख़ुदावन्द का ग़ज़ब भड़का और उसने क़सम खाकर कहा, कि ");
INSERT INTO urd_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","उन लोगों में से जो मिस्र से निकल कर आये हैं बीस बरस और उससे ऊपर — ऊपर की उम्र का कोई शख़्स उस मुल्क को नहीं देखने पाएगा, जिसके देने की क़सम मैंने अब्रहाम और इस्हाक़ और या'क़ूब से खाई; क्यूँकि उन्होंने मेरी पूरी पैरवी नहीं की। ");
INSERT INTO urd_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","मगर युफ़ना क़िन्ज़ी का बेटा कालिब और नून का बेटा यशू'अ उसे देखेंगे, क्यूँकि उन्होंने ख़ुदावन्द की पूरी पैरवी की है। ");
INSERT INTO urd_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","सो ख़ुदावन्द का क़हर इस्राईल पर भड़का और उसने उनकी वीरान में चालीस बरस तक आवारा फिराया, जब तक कि उस नसल के सब लोग जिन्होंने ख़ुदावन्द के सामने गुनाह किया था, नाबूद न हो गए। ");
INSERT INTO urd_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","और देखो, तुम जो गुनाहगारों की नसल हो, अब अपने बाप दादा की जगह उठे हो, ताकि ख़ुदावन्द के क़हर — ए — शदीद की इस्राईलियों पर ज़्यादा कराओ। ");
INSERT INTO urd_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","क्यूँकि अगर तुम उस की पैरवी से फिर जाओ तो वह उनको फिर वीरान में छोड़ देगा, और तुम इन सब लोगों को हलाक कराओगे।” ");
INSERT INTO urd_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","तब वह उसके नज़दीक आकर कहने लगे, हम अपने चौपायों के लिए यहाँ भेड़साले और अपने बाल — बच्चों के लिए शहर बनाएँगे, ");
INSERT INTO urd_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","लेकिन हम ख़ुद हथियार बाँधे हुए तैयार रहेंगे के बनी — इस्राईल के आगे आगे चलें, जब तक कि उनको उनकी जगह तक न पहुँचा दें; और हमारे बाल — बच्चे इस मुल्क के बाशिन्दों की वजह से फ़सीलदार शहरों में रहेंगे। ");
INSERT INTO urd_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","और हम अपने घरों को फिर वापस नहीं आएँगे जब तक बनी — इस्राईल का एक — एक आदमी अपनी मीरास का मालिक न हो जाए। ");
INSERT INTO urd_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","और हम उनमें शामिल होकर यरदन के उस पार या उससे आगे, मीरास न लेंगे क्यूँकि हमारी मीरास यरदन के इस पार पश्चिम की तरफ़ हम को मिल गई।” ");
INSERT INTO urd_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","मूसा ने उनसे कहा, अगर तुम यह काम करो और ख़ुदावन्द के सामने हथियारबन्द होकर लड़ने जाओ, ");
INSERT INTO urd_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","और तुम्हारे हथियार बन्द जवान ख़ुदावन्द के सामने यरदन पार जाएँ, जब तक कि ख़ुदावन्द अपने दुश्मनों को अपने सामने से दफ़ा' न करे, ");
INSERT INTO urd_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","और वह मुल्क ख़ुदावन्द के सामने क़ब्ज़े में न आ जाए; तो इसके बाद तुम वापस आओ, फिर तुम ख़ुदावन्द के सामने और इस्राईल के आगे बेगुनाह ठहरोगे और यह मुल्क ख़ुदावन्द के सामने तुम्हारी मिल्कियत हो जाएगा। ");
INSERT INTO urd_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","लेकिन अगर तुम ऐसा न करो तो तुम ख़ुदावन्द के गुनाहगार ठहरोगे; और यह जान लो कि तुम्हारा गुनाह तुम को पकड़ेगा। ");
INSERT INTO urd_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","इसलिए तुम अपने बाल बच्चों के लिए शहर और अपनी भेड़ — बकरियों के लिए भेड़साले बनाओ; जो तुम्हारे मुँह से निकला है वही करो।” ");
INSERT INTO urd_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","तब बनी जद्द और बनी रूबिन ने मूसा से कहा कि “तेरे ख़ादिम, जैसा हमारे मालिक का हुक्म है वैसा ही करेंगे। ");
INSERT INTO urd_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","हमारे बाल बच्चे और हमारी बीवियाँ, हमारी भेड़ बकरियाँ और हमारे सब चौपाये जिल'आद के शहरों में रहेंगे; ");
INSERT INTO urd_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","लेकिन हम जो तेरे ख़ादिम हैं, इसलिए हमारा एक — एक हथियारबन्द जवान ख़ुदावन्द के सामने लड़ने को पार जाएगा, जैसा हमारा मालिक कहता है।” ");
INSERT INTO urd_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","तब मूसा ने उनके बारे में इली'एलियाज़र काहिन और नून के बेटे यशू'अ और इस्राईली क़बाइल के आबाई ख़ान्दानों के सरदारों को वसीयत की ");
INSERT INTO urd_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","और उनसे यह कहा कि “अगर बनी जद्द और बनी रूबिन का एक — एक मर्द ख़ुदावन्द के सामने तुम्हारे साथ यरदन के पार हथियारबन्द होकर लड़ाई में जाए और उस मुल्क पर तुम्हारा क़ब्ज़ा हो जाए, तो तुम जिल'आद का मुल्क उनकी मीरास कर देना। ");
INSERT INTO urd_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","लेकिन अगर वह हथियार बाँध कर तुम्हारे साथ पार न जाएँ, तो उनको भी मुल्क — ए — कना'न ही में तुम्हारे बीच मीरास मिले।” ");
INSERT INTO urd_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","तब बनी जद्द और बनी रूबिन ने जवाब दिया, जैसा ख़ुदावन्द ने तेरे ख़ादिमों को हुक्म दिया है, हम वैसा ही करेंगे। ");
INSERT INTO urd_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","हम हथियार बाँध कर ख़ुदावन्द के सामने उस पार मुल्क — ए — कना'न को जाएँगे, लेकिन यरदन के इस पार ही हमारी मीरास रहे।” ");
INSERT INTO urd_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","तब मूसा ने अमोरियों के बादशाह सीहोन की मम्लकत और बसन के बादशाह 'ओज की मम्लकत को, या'नी उनके मुल्कों को और शहरों को जो उन अतराफ़ में थे, और उस सारी नवाही के शहरों को बनी जद्द और बनी रूबिन और मनस्सी बिन यूसुफ़ के आधे क़बीले को दे दिया। ");
INSERT INTO urd_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","तब बनी जद्द ने तब बनी जद्द ने दिबोन और 'अतारात और अरो'ईर, ");
INSERT INTO urd_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","और 'अतारात, शोफ़ान, और या'ज़ेर, और युगबिहा, ");
INSERT INTO urd_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","और बैत निमरा, और बैत हारन, फ़सीलदार शहर और भेड़साले बनाए। ");
INSERT INTO urd_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","और बनी रूबिन ने हस्बोन, और इली'आली, और करयताइम, ");
INSERT INTO urd_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","और नबो, और बालम'ऊन के नाम बदलकर उनको और शिबमाह को बनाया, और उन्होंने अपने बनाए हुए शहरों के दूसरे नाम रख्खे। ");
INSERT INTO urd_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","और मनस्सी के बेटे मकीर की नसल के लोगों ने जाकर जिल'आद को ले लिया, और अमोरियों को जो वहाँ बसे हुए थे निकाल दिया। ");
INSERT INTO urd_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","तब मूसा ने जिल'आद मकीर बिन मनस्सी को दे दिया। तब उसकी नसल के लोग वहाँ सुकूनत करने लगे। ");
INSERT INTO urd_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","और मनस्सी के बेटे याईर ने उस नवाही की बस्तियों की जाकर ले लिया और उनका नाम हव्वहत या'ईर रख्खा ");
INSERT INTO urd_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","और नूबह ने कनात और उसके देहात को अपने क़ब्ज़े में कर लिया और अपने ही नाम पर उस का भी नाम नूबह रख्खा। ");
INSERT INTO urd_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","जब बनी — इस्राईल मूसा और हारून के मातहत दल बाँधे हुए मुल्क — ए — मिस्र से निकल कर चले तो जैल की मंज़िलों पर उन्होंने क़याम किया। ");
INSERT INTO urd_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","और मूसा ने उनके सफ़र का हाल उनकी मंज़िलों के मुताबिक़ ख़ुदावन्द के हुक्म से लिखा किया; इसलिए उनके सफ़र की मंज़िलें यह हैं। ");
INSERT INTO urd_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","पहले महीने की पंद्रहवी तारीख़ की उन्होंने रा'मसीस से रवानगी की। फ़सह के दूसरे दिन सब बनी — इस्राईल के लोग सब मिस्रियों की आँखों के सामने बड़े फ़ख़्र से रवाना हुए। ");
INSERT INTO urd_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","उस वक़्त मिस्री अपने पहलौठों को, जिनको ख़ुदावन्द ने मारा था दफ़न कर रहे थे। ख़ुदावन्द ने उनके मा'बूदों को भी सज़ा दी थी। ");
INSERT INTO urd_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","इसलिए बनी — इस्राईल ने रा'मसीस से रवाना होकर सुक्कात में ख़ेमे डाले। ");
INSERT INTO urd_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","और सुक्कात से रवाना होकर एताम में, जो वीरान से मिला हुआ है मुक़ीम हुए। ");
INSERT INTO urd_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","फिर एताम से रवाना होकर हर हखीरोत को, जो बा'ल सफ़ोन के सामने है मुड़ गए और मिजदाल के सामने ख़ेमे डाले। ");
INSERT INTO urd_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","फिर उन्होंने फ़ी हख़ीरोत के सामने से कूच किया और समन्दर के बीच से गुज़र कर वीरान में दाख़िल हुए, और दश्त — ए — एताम में तीन दिन की राह चल कर मारा में पड़ाव किया। ");
INSERT INTO urd_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","और मारा से रवाना होकर एलीम में आए। और एलीम में पानी के बारह चश्मे और खजूर के सत्तर दरख़्त थे, इसलिए उन्होंने यहीं ख़ेमे डाल लिए। ");
INSERT INTO urd_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","और एलीम से रवाना होकर उन्होंने बहर — ए — कु़लजु़म के किनारे ख़ेमे खड़े किए। ");
INSERT INTO urd_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","और बहर — ए — कु़लजु़म से चल कर सीन के जंगल में ख़ेमाज़न हुए। ");
INSERT INTO urd_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","और सीन के जंगल से रवाना होकर दफ़का में ठहरे। ");
INSERT INTO urd_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","और दफ़का से रवाना होकर अलूस में मुक़ीम हुए। ");
INSERT INTO urd_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","और अलूस से चल कर रफ़ीदीम में ख़ेमे डाले। यहाँ इन लोगों को पीने के लिए पानी न मिला। ");
INSERT INTO urd_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","और रफ़ीदीम से रवाना होकर दश्त — ए — सीना में ठहरे। ");
INSERT INTO urd_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","और सीना के जंगल से चल कर क़बरोत हतावा में ख़ेमें खड़े किए। ");
INSERT INTO urd_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","और क़बरोत हतावा से रवाना होकर हसीरात में ख़ेमे डाले। ");
INSERT INTO urd_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","और हसीरात से रवाना होकर रितमा में ख़ेमे डाले। ");
INSERT INTO urd_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","और रितमा से रवाना होकर रिम्मोन फ़ारस में खेमें खड़े किए। ");
INSERT INTO urd_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","और रिमोन फ़ारस से जो चले तो लिबना में जाकर मुक़ीम हुए। ");
INSERT INTO urd_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","और लिबना से रवाना होकर रैस्सा में ख़ेमे डाले। ");
INSERT INTO urd_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","और रैस्सा से चलकर कहीलाता में ख़ेमे खड़े किए। ");
INSERT INTO urd_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","और कहीलाता से चल कर कोह — ए — साफ़र के पास ख़ेमा किया। ");
INSERT INTO urd_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","कोह — ए — साफ़र से रवाना होकर हरादा में ख़ेमाज़न हुए। ");
INSERT INTO urd_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","और हरादा से सफ़र करके मकहीलोत में क़याम किया। ");
INSERT INTO urd_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","और मकहीलोत से रवाना होकर तहत में ख़ेमें खड़े किए। ");
INSERT INTO urd_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","तहत से जो चले तो तारह में आकर ख़ेमे डाले। ");
INSERT INTO urd_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","और तारह से रवाना होकर मितक़ा में क़याम किया। ");
INSERT INTO urd_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","और मितका से रवाना होकर हशमूना में ख़ेमे डाले। ");
INSERT INTO urd_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","और हशमूना से चल कर मौसीरोत में ख़ेमे खड़े किए। ");
INSERT INTO urd_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","और मौसीरोत से रवाना होकर बनी या'कान में ख़ेमे डाले। ");
INSERT INTO urd_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","और बनी या'कान से चल कर होर हज्जिदजाद में ख़ेमाज़न हुए। ");
INSERT INTO urd_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","और हीर हज्जिदजाद से रवाना होकर यूतबाता में ख़ेमें खड़े किए। ");
INSERT INTO urd_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","और यूतबाता से चल कर 'अबरूना में ख़ेमे डाले। ");
INSERT INTO urd_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","और 'अबरूना से चल कर “अस्यून जाबर में ख़ेमा किया। ");
INSERT INTO urd_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","और 'अस्यून जाबर से रवाना होकर सीन के जंगल में, जो क़ादिस है क़याम किया। ");
INSERT INTO urd_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","और क़ादिस से चल कर कोह — ए — होर के पास, जो मुल्क — ए — अदोम की सरहद है ख़ेमाज़न हुए। ");
INSERT INTO urd_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","यहाँ हारून काहिन ख़ुदावन्द के हुक्म के मुताबिक़ कोह — ए — होर पर चढ़ गया और उसने बनी — इस्राईल के मुल्क — ए — मिस्र से निकलने के चालीसवें बरस के पाँचवें महीने की पहली तारीख़ को वहीं वफ़ात पाई। ");
INSERT INTO urd_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","और जब हारून ने कोह — ए — होर पर वफ़ात पाई तो वह एक सौ तेईस बरस का था। ");
INSERT INTO urd_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","और 'अराद के कना'नी बादशाह को, जो मुल्क — ए — कना'न के दख्खिन में रहता था, बनी इस्राईल की आमद की ख़बर मिली। ");
INSERT INTO urd_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","और इस्राईली कोह — ए — होर से रवाना होकर ज़लमूना में ठहरे। ");
INSERT INTO urd_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","और ज़लमूना से रवाना होकर फूनोन में ख़ेमे डाले। ");
INSERT INTO urd_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","और फूनोन से रवाना होकर ओबूत में क़याम किया। ");
INSERT INTO urd_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","और ओबूत से रवाना होकर 'अय्यी अबारीम में जो मुल्क — ए — मोआब की सरहद पर है ख़ेमे डाले, ");
INSERT INTO urd_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","और 'अय्यीम से रवाना होकर दीबोन जद्द में ख़ेमाज़न हुए। ");
INSERT INTO urd_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","और दीबोन जद्द से रवाना होकर 'अलमून दबलातायम में ख़मे खड़े किए। ");
INSERT INTO urd_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","और 'अलमून दबलातायम से रवाना होकर 'अबारीम के कोहिस्तान में, जो नबी के सामने है ख़ेमा किया। ");
INSERT INTO urd_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","और 'अबारीम के कोहिस्तान से चल कर मोआब के मैदानों में, जो यरीहू के सामने यरदन के किनारे वाके' है ख़ेमाज़न हुए। ");
INSERT INTO urd_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","और यरदन के किनारे बैत यसीमोत से लेकर अबील सतीम तक मोआब के मैदानों में उन्होंने ख़ेमे डाले। ");
INSERT INTO urd_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","और ख़ुदावन्द ने मोआब के मैदानों में, जो यरीहू के सामने यरदन के किनारे वाके' है, मूसा से कहा कि, ");
INSERT INTO urd_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“बनी — इस्राईल से यह कह दे कि जब तुम यरदन को उबूर करके मुल्क — ए — कना'न में दाख़िल हो, ");
INSERT INTO urd_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","तो तुम उस मुल्क के सारे बाशिन्दों को वहाँ से निकाल देना, और उनके शबीहदार पत्थरों को और उनके ढाले हुए बुतों को तोड़ डालना, और उनके सब ऊँचे मक़ामों को तबाह कर देना। ");
INSERT INTO urd_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","और तुम उस मुल्क पर क़ब्ज़ा करके उसमें बसना, क्यूँकि मैंने वह मुल्क तुम को दिया है कि तुम उसके मालिक बनो। ");
INSERT INTO urd_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","और तुम पर्ची डाल कर उस मुल्क को अपने घरानों में मीरास के तौर पर बाँट लेना। जिस ख़ान्दान में ज़्यादा आदमी हों उसको ज़्यादा, और जिसमें थोड़े हों उसको थोड़ी मीरास देना; और जिस आदमी का पर्चा जिस जगह के लिए निकले वही उसके हिस्से में मिले। तुम अपने आबाई क़बाइल के मुताबिक़ अपनी अपनी मीरास लेना। ");
INSERT INTO urd_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","लेकिन अगर तुम उस मुल्क के बाशिन्दों को अपने आगे से दूर न करो, तो जिनको तुम बाक़ी रहने दोगे वह तुम्हारी आँखों में ख़ार और तुम्हारे पहलुओं में काँटे होंगे, और उस मुल्क में जहाँ तुम बसोगे तुम को दिक़ करेंगे। ");
INSERT INTO urd_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","और आख़िर को यूँ होगा कि जैसा मैंने उनके साथ करने का इरादा किया वैसा ही तुम से करूँगा।” ");
INSERT INTO urd_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","फिर ख़ुदावन्द ने मूसा से कहा कि, ");
INSERT INTO urd_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“बनी — इस्राईल को हुक्म कर, और उनको कह दे कि जब तुम मुल्क — ए — कना'न में दाख़िल हो; यह वही मुल्क है जो तुम्हारी मीरास होगा, या'नी कनान का मुल्क म'ए अपनी हुदूद — ए — अरबा' के ");
INSERT INTO urd_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","तो तुम्हारी दख्खिनी सिम्त सीन के जंगल से लेकर मुल्क — ए — अदोम के किनारे किनारे हो, और तुम्हारी दख्खिनी सरहद दरिया — ए — शोर के आख़िर से शुरू' होकर पश्चिम को जाए। ");
INSERT INTO urd_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","वहाँ से तुम्हारी सरहद 'अक़राबियम की चढ़ाई के दख्खिन तक पहुँच कर मुड़े, और सीन से होती हुई क़ादिस बर्नी'अ के दख्खिन में जाकर निकले, और हसर अद्दार से होकर 'अज़मून तक पहुँचे। ");
INSERT INTO urd_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","फिर यही सरहद 'अज़मून से होकर घूमती हुई मिस्र की नहर तक जाए और समन्दर के किनारे पर ख़त्म हो। ");
INSERT INTO urd_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“और पश्चिमी सिम्त में बड़ा समन्दर और उसका साहिल हो, इसलिए यही तुम्हारी पश्चिमी सरहद ठहरे। ");
INSERT INTO urd_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“और उत्तरी सिम्त में तुम बड़े समन्दर से कोह — ए — होर तक अपनी हद्द रखना। ");
INSERT INTO urd_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","फिर कोह — ए — होर से हमात के मदख़ल तक तुम इस तरह अपनी हद्द मुक़र्रर करना कि वह सिदाद से जा मिले। ");
INSERT INTO urd_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","और वहाँ से होती हुई ज़िफ़रून को निकल जाए और हसर 'एनान पर जाकर ख़त्म हो, यह तुम्हारी उत्तरी सरहद हो। ");
INSERT INTO urd_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“और तुम अपनी पूरबी सरहद हसर 'एनान से लेकर सफ़ाम तक बाँधना। ");
INSERT INTO urd_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","और यह सरहद सफ़ाम से रिबला तक जो 'ऐन के पश्चिम में है जाए, और वहाँ से नीचे को उतरती हुई किन्नरत की झील के पूरबी किनारे तक पहुँचे: ");
INSERT INTO urd_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","और फिर यरदन के किनारे किनारे नीचे को जाकर दरिया — ए — शोर पर ख़त्म हो। इन हदों के अन्दर का मुल्क तुम्हारा होगा।” ");
INSERT INTO urd_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","तब मूसा ने बनी — इस्राईल को हुक्म दिया, “यही वह ज़मीन है जिसे तुम पर्ची डाल कर मीरास में लोगे, और इसी के बारे में ख़ुदावन्द ने हुक्म दिया है कि वह साढ़े नौ क़बीलों को दी जाए। ");
INSERT INTO urd_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","क्यूँकि बनी रूबिन के क़बीले ने अपने आबाई ख़ान्दानों के मुवाफ़िक, और बनी जद्द के क़बीले ने भी अपने आबाई ख़ान्दानों के मुताबिक़ मीरास पा ली, और बनी मनस्सी के आधे क़बीले ने भी अपनी मीरास पा ली; ");
INSERT INTO urd_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","या'नी इन ढाई क़बीलों को यरदन के इसी पार यरीहू के सामने पश्चिम की तरफ़ जिधर से सूरज निकलता है मीरास मिल चुकी है।” ");
INSERT INTO urd_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","और ख़ुदावन्द ने मूसा से कहा कि, ");
INSERT INTO urd_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","'जो अश्ख़ास इस मुल्क को मीरास के तौर पर तुम को बाँट देंगे उन के नाम यह हैं, या'नी इली'एलियाज़र काहिन और नून का बेटा यशू'अ। ");
INSERT INTO urd_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","और तुम ज़मीन को मीरास के तौर पर बाँटने के लिए हर क़बीले से एक सरदार को लेना। ");
INSERT INTO urd_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","और उन आदमियों के नाम यह हैं: यहूदाह के क़बीले से यफुना का बेटा कालिब, ");
INSERT INTO urd_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","और बनी शमौन के क़बीले से अम्मीहूद का बेटा समूएल, ");
INSERT INTO urd_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","और बिनयमीन के क़बीले से किसलून का बेटा इलीदाद, ");
INSERT INTO urd_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","और बनी दान के क़बीले से एक सरदार बुक्की बिन युगली, ");
INSERT INTO urd_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","और बनी यूसुफ़ में से या'नी बनी मनस्सी के क़बीले से एक सरदार हनीएल बिन अफ़ूद, ");
INSERT INTO urd_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","और बनी इफ़्राईम के क़बीले से एक सरदार क़मूएल बिन सिफ़्तान, ");
INSERT INTO urd_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","और बनी ज़बूलून के क़बीले से एक सरदार इलिसफ़न बिन फ़रनाक, ");
INSERT INTO urd_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","और बनी इश्कार के क़बीले से एक सरदार फ़लतीएल बिन 'अज़्ज़ान, ");
INSERT INTO urd_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","और बनी आशर के क़बीले से एक सरदार अखीहूद बिन शलूमी, ");
INSERT INTO urd_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","और बनी नफ़्ताली के क़बीले से एक सरदार फ़िदाहेल बिन 'अम्मीहूद।” ");
INSERT INTO urd_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","यह वह लोग हैं जिनको ख़ुदावन्द ने हुक्म दिया कि मुल्क — ए — कना'न में बनी — इस्राईल को मीरास तक़्सीम कर दें। ");
INSERT INTO urd_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","फिर ख़ुदावन्द ने मोआब के मैदानों में, जो यरीहू के सामने यरदन के किनारे वाके' हैं, मूसा से कहा कि, ");
INSERT INTO urd_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“बनी इस्राईल को हुक्म कर, कि अपनी मीरास में से जो उनके क़ब्ज़े में आए लावियों की रहने के लिए शहर दें, और उन शहरों के 'इलाक़े भी तुम लावियों को दे देना। ");
INSERT INTO urd_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","यह शहर उनके रहने के लिए हों; उनके 'इलाक़े उनके चौपायों और माल और सारे जानवरों के लिए हों। ");
INSERT INTO urd_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","और शहरों के 'इलाक़े जो तुम लावियों को दो वह हर शहर की दीवार से शुरू' करके बाहर चारों तरफ़ हज़ार — हज़ार हाथ के फेर में हों। ");
INSERT INTO urd_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","और तुम शहर के बाहर पश्चिम की तरफ़ दो हज़ार हाथ, और दख्खिन की तरफ़ दो हज़ार हाथ, और पश्चिम की तरफ़ दो हज़ार हाथ, और उत्तर की तरफ़ दो हज़ार हाथ इस तरह पैमाइश करना के शहर उनके बीच में आ जाए। उनके शहरों के इतनी ही 'इलाक़े हों। ");
INSERT INTO urd_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","और लावियों के उन शहरों में से जो तुम उनको दो, छः पनाह के शहर ठहरा देना जिनमें ख़ूनी भाग जाएँ। इन शहरों के 'अलावा बयालीस शहर और उनको देना; ");
INSERT INTO urd_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","या'नी सब मिला कर अठतालीस शहर लावियों की देना और इन शहरों के साथ इनके 'इलाक़े भी हों। ");
INSERT INTO urd_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","और वह शहर बनी — इस्राईल की मीरास में से यूँ दिए जाएँ। जिनके क़ब्ज़े में बहुत से हों उनसे थोड़े शहर लेना। हर क़बीला अपनी मीरास के मुताबिक़ जिसका वह वारिस हो लावियों के लिए शहर दे।” ");
INSERT INTO urd_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","और ख़ुदावन्द ने मूसा से कहा कि, ");
INSERT INTO urd_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“बनी — इस्राईल से कह दे कि जब तुम यरदन को पार करके मुल्क — ए — कना'न में पहुँच जाओ, ");
INSERT INTO urd_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","तो तुम कई ऐसे शहर मुक़र्रर करना जो तुम्हारे लिए पनाह के शहर हों, ताकि वह ख़ूनी जिससे अनजाने में ख़ून हो जाए वहाँ भाग जा सके। ");
INSERT INTO urd_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","इन शहरों में तुम को इन्तक़ाम लेने वाले से पनाह मिलेगी, ताकि ख़ूनी जब तक वह फ़ैसले के लिए जमा'अत के आगे हाज़िर न हो तब तक मारा न जाए। ");
INSERT INTO urd_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","और पनाह के जो शहर तुम दोगे वह छः हों। ");
INSERT INTO urd_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","तीन शहर तो यरदन के पार और तीन मुल्क — ए — कना'न में देना। यह पनाह के शहर होंगे। ");
INSERT INTO urd_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","इन छहों शहरों में बनी — इस्राईल को और उन मुसाफ़िरों और परदेसियों को जो तुम में क़याम करते हैं, पनाह मिलेगी ताकि जिस किसी से अनजाने में ख़ून हो जाए वह वहाँ भाग जा सके। ");
INSERT INTO urd_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","'और अगर कोई किसी को लोहे के हथियार से ऐसा मारे कि वह मर जाए, तो वह ख़ूनी ठहरेगा और वह ख़ूनी ज़रूर मारा जाए। ");
INSERT INTO urd_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","या अगर कोई ऐसा पत्थर हाथ में लेकर जिससे आदमी मर सकता हो, किसी को मारे और वह मर जाए, तो वह ख़ूनी ठहरेगा और वह ख़ूनी ज़रूर मारा जाए। ");
INSERT INTO urd_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","या अगर कोई चोबी आला हाथ में लेकर जिससे आदमी मर सकता हो, किसी को मारे और वह मर जाए, तो वह ख़ूनी ठहरेगा और वह ख़ूनी ज़रूर मारा जाए। ");
INSERT INTO urd_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","ख़ून का इन्तक़ाम लेने वाला ख़ूनी को आप ही क़त्ल करे; जब वह उसे मिले तब ही उसे मार डाले। ");
INSERT INTO urd_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","और अगर कोई किसी को 'अदावत से धकेल दे या घात लगा कर कुछ उस पर फेंक दे और वह मर जाए, ");
INSERT INTO urd_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","या दुश्मनी से उसे अपने हाथ से ऐसा मारे कि वह मर जाए; तो वह जिसने मारा हो ज़रूर क़त्ल किया जाए क्यूँकि वह ख़ूनी है। ख़ून का इन्तक़ाम लेने वाला इस ख़ूनी को जब वह उसे मिले मार डाले। ");
INSERT INTO urd_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","'लेकिन अगर कोई किसी को बग़ैर 'अदावत के नागहान धकेल दे या बग़ैर घात लगाए उस पर कोई चीज़ डाल दे, ");
INSERT INTO urd_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","या उसे बग़ैर देखे कोई ऐसा पत्थर उस पर फेंके जिससे आदमी मर सकता हो, और वह मर जाए; लेकिन यह न तो उसका दुश्मन और न उसके नुक़सान का ख्वाहान था; ");
INSERT INTO urd_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","तो जमा'अत ऐसे क़ातिल और ख़ून के इन्तक़ाम लेने वाले के बीच इन ही हुक्मों के मुवाफ़िक़ फ़ैसला करे; ");
INSERT INTO urd_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","और जमा'अत उस क़ातिल को ख़ून के इन्तक़ाम लेने वाले के हाथ से छुड़ाए और जमा'अत ही उसे पनाह के उस शहर में जहाँ वह भाग गया था वापस पहुँचा दे, और जब तक सरदार काहिन जो पाक तेल से मम्सूह हुआ था मर न जाए तब तक वह वहीं रहे। ");
INSERT INTO urd_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","लेकिन अगर वह ख़ूनी अपने पनाह के शहर की सरहद से, जहाँ वह भाग कर गया हो किसी वक़्त बाहर निकले, ");
INSERT INTO urd_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","और ख़ून के इन्तक़ाम लेने वाले की वह पनाह के शहर की सरहद के बाहर मिल जाए और इन्तक़ाम लेने वाला क़ातिल को क़त्ल कर डाले, तो वह ख़ून करने का मुजरिम न होगा; ");
INSERT INTO urd_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","क्यूँकि ख़ूनी को लाज़िम था कि सरदार काहिन की वफ़ात तक उसी पनाह कि शहर में रहता, लेकिन सरदार काहिन के मरने के बाद ख़ूनी अपनी मौरूसी जगह को लौट जाए। ");
INSERT INTO urd_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“इसलिए तुम्हारी सब सुकूनतगाहों में नसल — दर — नसल यह बातें फ़ैसले के लिए क़ानून ठहरेंगी। ");
INSERT INTO urd_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","अगर कोई किसी को मार डाले तो कातिल गवाहों की शहादत पर क़त्ल किया जाए, लेकिन एक गवाह की शहादत से कोई मारा न जाए। ");
INSERT INTO urd_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","और तुम उस क़ातिल से जो वाजिब — उल — क़त्ल हो दियत न लेना बल्कि वह ज़रूर ही मारा जाए। ");
INSERT INTO urd_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","और तुम उससे भी जो किसी पनाह के शहर को भाग गया हो, इस ग़र्ज़ से दियत न लेना कि वह सरदार काहिन की मौत से पहले फिर मुल्क में रहने को लौटने पाए। ");
INSERT INTO urd_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","इसलिए तुम उस मुल्क को जहाँ तुम रहोगे नापाक न करना, क्यूँकि ख़ून मुल्क को नापाक कर देता है; और उस मुल्क के लिए जिसमें ख़ून बहाया जाए अलावा क़ातिल के ख़ून के और किसी चीज़ का कफ़्फ़ारा नहीं लिया जा सकता। ");
INSERT INTO urd_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","और तुम अपनी क़याम के मुल्क को जिसके अन्दर मैं रहूँगा, गन्दा भी न करना; क्यूँकि मैं जो ख़ुदावन्द हूँ, इसलिए बनी — इस्राईल के बीच रहता हूँ।” ");
INSERT INTO urd_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","और बनी यूसुफ़ के घरानों में से बनी जिल'आद बिन मकीर बिन मनस्सी के आबाई ख़ान्दानों के सरदार मूसा और उन अमीरों के पास जाकर जो बनी इस्राईल के आबाई ख़ान्दानों के सरदार थे कहने लगे, ");
INSERT INTO urd_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“ख़ुदावन्द ने हमारे मालिक को हुक्म दिया था कि पर्ची डाल कर यह मुल्क मीरास के तौर पर बनी — इस्राईल को देना; और हमारे मालिक को ख़ुदावन्द की तरफ़ से हुक्म मिला था, कि हमारे भाई सिलाफ़िहाद की मीरास उसकी बेटियों को दी जाए। ");
INSERT INTO urd_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","लेकिन अगर वह बनी — इस्राईल के और क़बीलों के आदमियों से ब्याही जाएँ, तो उनकी मीरास हमारे बाप — दादा की मीरास से निकल कर उस क़बीले की मीरास में शामिल की जाएगी जिसमें वह ब्याही जाएँगी; यूँ वह हमारे हिस्से की मीरास से अलग हो जाएगी। ");
INSERT INTO urd_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","और जब बनी — इस्राईल का साल — ए — यूबली आएगा, तो उनकी मीरास उसी क़बीले की मीरास से मुल्हक़ की जाएगी जिसमें वह ब्याही जाएँगी। यूँ हमारे बाप — दादा के क़बीले की मीरास से उनका हिस्सा निकल जाएगा।” ");
INSERT INTO urd_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","तब मूसा ने ख़ुदावन्द के कलाम के मुताबिक़ बनी — इस्राईल को हुक्म दिया और कहा कि “बनी यूसुफ़ के क़बीले के लोग ठीक कहते हैं। ");
INSERT INTO urd_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","इसलिए सिलाफ़िहाद की बेटियों के हक़ में ख़ुदावन्द का हुक्म यह है कि वह जिनको पसन्द करें उन्हीं से ब्याह करें, लेकिन अपने बापदादा के क़बीले ही के ख़ान्दानों में ब्याही जाएँ। ");
INSERT INTO urd_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","यूँ बनी — इस्राईल की मीरास एक क़बीले से दूसरे क़बीले में नहीं जाने पाएगी; क्यूँकि हर इस्राईली को अपने बाप — दादा के क़बीले की मीरास को अपने क़ब्ज़े में रखना होगा। ");
INSERT INTO urd_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","और अगर बनी इस्राईल के किसी क़बीले में कोई लड़की हो जो मीरास की, मालिक हो तों वह अपने बाप के क़बीले के किसी ख़ानदान में ब्याह करे ताकि हर इस्राईली अपने बाप दादा की मीरास पर क़ाईम रहे। ");
INSERT INTO urd_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","यूँ किसी की मीरास एक क़बीले से दूसरे क़बीले में नहीं जाने पाएगी; क्यूँकि बनी — इस्राईल के क़बीलों को लाज़िम है कि अपनी अपनी मीरास अपने — अपने क़ब्ज़े में रख्खें।” ");
INSERT INTO urd_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","और सिलाफ़िहाद की बेटियों ने जैसा ख़ुदावन्द ने मूसा को हुक्म दिया था वैसा ही किया। ");
INSERT INTO urd_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","क्यूँकि महलाह और तिरज़ाह और हुजलाह और मिल्काह और नू'आह जो सिलाफ़िहाद की बेटियाँ थीं, वह अपने चचेरे भाइयों के साथ ब्याही गई, ");
INSERT INTO urd_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","या'नी वह यूसुफ़ के बेटे मनस्सी की नसल के ख़ान्दानों में ब्याही गई, और उनकी मीरास, उनके आबाई ख़ान्दान के क़बीले में क़ाईम रही। ");
INSERT INTO urd_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","जो हुक्म और फ़ैसले ख़ुदावन्द ने मूसा के ज़रिए' मोआब के मैदानों में जो यरीहू के सामने यरदन के किनारे वाक़े' है बनी इस्राईल को दिए वह यही हैं।");
INSERT INTO urd_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","यह वही बातें हैं जो मूसा ने यरदन के उस पार वीराने में, या'नी उस मैदान में जो सूफ़ के सामने और फ़ारान और तोफ़ल और लाबन और हसीरात और दीज़हब के बीच है, सब इस्राईलियों से कहीं। ");
INSERT INTO urd_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","कोह — ए — श'ईर की राह से होरिब से क़ादिस बर्नी'अ तकग्यारह दिन की मन्ज़िल है। ");
INSERT INTO urd_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","और चालीसवें बरस के ग्यारहवें महीने की पहली तारीख़ को मूसा ने उन सब अहकाम के मुताबिक़ जो ख़ुदावन्द ने उसे बनी — इस्राईल के लिए दिए थे, उनसे यह बातें कहीं: ");
INSERT INTO urd_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","या'नी जब उसने अमोरियों के बादशाह सीहोन को जो हस्बोन में रहता था मारा, और बसन के बादशाह 'ओज को जो 'इस्तारात में रहता था, अदराई में क़त्ल किया; ");
INSERT INTO urd_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","तो इसके बाद यरदन के पार मोआब के मैदान में मूसा इस शरी'अत को यूँ बयान करने लगा कि, ");
INSERT INTO urd_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“ख़ुदावन्द हमारे ख़ुदा ने होरिब में हमसे यह कहा था, कि तुम इस पहाड़ पर बहुत रह चुके हो ");
INSERT INTO urd_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","इसलिए अब फिरो और कूच करो और अमोरियों के पहाड़ी मुल्क, और उसके आस — पास के मैदान और पहाड़ी क़ता'अ और नशेब की ज़मीन और दख्खिनी अतराफ़ में, और समन्दर के साहिल तक जो कना'नियों का मुल्क है बल्कि कोह — ए — लुबनान और दरिया — ए — फ़रात तक जो एक बड़ा दरिया है, चले जाओ। ");
INSERT INTO urd_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","देखो, मैंने इस मुल्क को तुम्हारे सामने कर दिया है। इसलिए जाओ और उस मुल्क को अपने क़ब्ज़े में कर लो, जिसके बारे में ख़ुदावन्द ने तुम्हारे बाप — दादा अब्रहाम, इस्हाक़, और या'क़ूब से क़सम खाकर यह कहा था, कि वह उसे उनको और उनके बाद उनकी नसल को देगा।” ");
INSERT INTO urd_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","उस वक़्त मैंने तुमसे कहा था, कि मैं अकेला तुम्हारा बोझ नहीं उठा सकता। ");
INSERT INTO urd_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","ख़ुदावन्द तुम्हारे ख़ुदा ने तुमको बढ़ाया है और आज के दिन आसमान के तारों की तरह तुम्हारी कसरत है। ");
INSERT INTO urd_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","ख़ुदावन्द तुम्हारे बाप — दादा का ख़ुदा तुमको इससे भी हज़ार चँद बढ़ाए, और जो वा'दा उसने तुमसे किया है उसके मुताबिक़ तुमको बरकत बख़्शे। ");
INSERT INTO urd_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","मैं अकेला तुम्हारे जंजाल और बोझ और झंझट को कैसे उठा सकता हूँ? ");
INSERT INTO urd_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","इसलिए तुम अपने — अपने क़बीले से ऐसे आदमियों को चुनो जो दानिश्वर और 'अक़्लमन्द और मशहूर हों, और मैं उनको तुम पर सरदार बना दूँगा। ");
INSERT INTO urd_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","इसके जवाब में तुमने मुझसे कहा था, कि जो कुछ तूने फ़रमाया है उसका करना बेहतर है। ");
INSERT INTO urd_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","इसलिए मैंने तुम्हारे क़बीलों के सरदारों को जो 'अक़्लमन्द और मशहूर थे, लेकर उनको तुम पर मुक़र्रर किया ताकि वह तुम्हारे क़बीलों के मुताबिक़ हज़ारों के सरदार, और सैकड़ों के सरदार, और पचास — पचास के सरदार, और दस — दस के सरदार हाकिम हों। ");
INSERT INTO urd_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","और उसी मौक़े' पर मैंने तुम्हारे क़ाज़ियों से ताकीदन ये कहा, कि तुम अपने भाइयों के मुक़द्दमों को सुनना, पर चाहे भाई — भाई का मुआ'मिला हो या परदेसी का तुम उनका फैसला इन्साफ़ के साथ करना। ");
INSERT INTO urd_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","तुम्हारे फ़ैसले में किसी की रू — रि'आयत न हो, जैसे बड़े आदमी की बात सुनोगे वैसे ही छोटे की सुनना और किसी आदमी का मुँह देख कर डर न जाना; क्यूँकि यह 'अदालत ख़ुदा की है; और जो मुक़द्दमा तुम्हारे लिए मुश्किल हो उसे मेरे पास ले आना मैं उसे सुनूँगा ");
INSERT INTO urd_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","और मैंने उसी वक़्त सब कुछ जो तुमको करना है बता दिया। ");
INSERT INTO urd_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","और हम ख़ुदावन्द अपने ख़ुदा के हुक्म के मुताबिक़ होरिब से सफ़र करके उस बड़े और ख़तरनाक वीराने में से होकर गुज़रे, जिसे तुमने अमोरियों के पहाड़ी मुल्क के रास्ते में देखा। फिर हम क़ादिस बर्नी'अ में पहुँचे। ");
INSERT INTO urd_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","वहाँ मैंने तुमको कहा, कि तुम अमोरियों के पहाड़ी मुल्क तक आ गए हो जिसे ख़ुदावन्द हमारा ख़ुदा हमको देता है। ");
INSERT INTO urd_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","देख, उस मुल्क को ख़ुदावन्द तेरे ख़ुदा ने तेरे सामने कर दिया है। इसलिए तू जा, और जैसा ख़ुदावन्द तेरे बाप — दादा के ख़ुदा ने तुझ से कहा है तू उस पर क़ब्ज़ा कर और न ख़ौफ़ खा न हिरासान हो। ");
INSERT INTO urd_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","तब तुम सब मेरे पास आकर मुझसे कहने लगे, कि हम अपने जाने से पहले वहाँ आदमी भेजें, जो जाकर हमारी ख़ातिर उस मुल्क का हाल दरियाफ़्त करें और आकर हमको बताएँ के हमको किस राह से वहाँ जाना होगा और कौन — कौन से शहर हमारे रास्ते में पड़ेंगे। ");
INSERT INTO urd_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","यह बात मुझे बहुत पसन्द आई चुनाँचे मैंने क़बीले पीछे एक — एक आदमी के हिसाब से बारह आदमी चुने। ");
INSERT INTO urd_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","और वह रवाना हुए और पहाड़ पर चढ़ गए और वादी — ए — इसकाल में पहुँच कर उस मुल्क का हाल दरियाफ़्त किया। ");
INSERT INTO urd_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","और उस मुल्क का कुछ फल हाथ में लेकर उसे हमारे पास लाए, और हमको यह ख़बर दी कि जो मुल्क ख़ुदावन्द हमारा ख़ुदा हमको देता है वह अच्छा है। ");
INSERT INTO urd_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“तो भी तुम वहाँ जाने पर राज़ी न हुए, बल्कि तुमने ख़ुदावन्द अपने ख़ुदा के हुक्म से सरकशी की, ");
INSERT INTO urd_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","और अपने ख़ेमों में कुड़कुड़ाने और कहने लगे, कि ख़ुदावन्द को हमसे नफ़रत है इसीलिए वह हमको मुल्क — ए — मिस्र से निकाल लाया ताकि वह हमको अमोरियों के हाथ में गिरफ़्तार करा दे और वह हमको हलाक कर डालें। ");
INSERT INTO urd_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","हम किधर जा रहे हैं? हमारे भाइयों ने तो यह बता कर हमारा हौसला तोड़ दिया है, कि वहाँ के लोग हमसे बड़े — बड़े और लम्बे हैं; और उनके शहर बड़े — बड़े और उनकी फ़सीलें आसमान से बातें करती हैं। इसके अलावा हमने वहाँ 'अनाक़ीम की औलाद को भी देखा। ");
INSERT INTO urd_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","तब मैंने तुमको कहा, कि ख़ौफ़ज़दा मत हो और न उनसे डरो। ");
INSERT INTO urd_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","ख़ुदावन्द तुम्हारा ख़ुदा जो तुम्हारे आगे आगे चलता है, वही तुम्हारी तरफ़ से जंग करेगा जैसे उसने तुम्हारी ख़ातिर मिस्र में तुम्हारी आँखों के सामने सब कुछ किया ");
INSERT INTO urd_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","और वीराने में भी तुमने यही देखा के जिस तरह इंसान अपने बेटे को उठाए हुए चलता है उसी तरह ख़ुदावन्द तुम्हारा ख़ुदा तेरे इस जगह पहुँचने तक सारे रास्ते जहाँ — जहाँ तुम गए तुमको उठाए रहा ");
INSERT INTO urd_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","तो भी इस बात में तुमने ख़ुदावन्द अपने ख़ुदा का यक़ीन न किया, ");
INSERT INTO urd_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","जो राह में तुमसे आगे — आगे तुम्हारे वास्ते ख़ेमे लगाने की जगह तलाश करने के लिए, रात को आग में और दिन को बादल में होकर चला, ताकि तुमको वह रास्ता दिखाए जिस से तुम चलो। ");
INSERT INTO urd_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","'और ख़ुदावन्द तुम्हारी बातें सुन कर गज़बनाक हुआ और उसने क़सम खाकर कहा, कि ");
INSERT INTO urd_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","इस बुरी नसल के लोगों में से एक भी उस अच्छे मुल्क को देखने नहीं पाएगा, जिसे उनके बाप — दादा को देने की क़सम मैंने खाई है, ");
INSERT INTO urd_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","सिवा यफुना के बेटे कालिब के; वह उसे देखेगा, और जिस ज़मीन पर उसने क़दम रख्खा है उसे मैं उसकी और उसकी नसल को दूँगा; इसलिए के उसने ख़ुदावन्द की पैरवी पूरे तौर पर की, ");
INSERT INTO urd_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","और तुम्हारी ही वजह से ख़ुदावन्द मुझ पर भी नाराज़ हुआ और यह कहा, कि तू भी वहाँ जाने न पाएगा। ");
INSERT INTO urd_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","नून का बेटा यशू'अ जो तेरे सामने खड़ा रहता है वहाँ जाएगा, इसलिए तू उसकी हौसला अफ़ज़ाई कर क्यूँकि वही बनी इस्राईल को उस मुल्क का मालिक बनाएगा। ");
INSERT INTO urd_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","और तुम्हारे बाल — बच्चे जिनके बारे में तुमने कहा था, कि लूट में जाएँगे, और तुम्हारे लड़के बाले जिनको आज भले और बुरे की भी तमीज़ नहीं, यह वहाँ जाएँगे; और यह मुल्क मैं इन ही को दूँगा और यह उस पर क़ब्ज़ा करेंगे। ");
INSERT INTO urd_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","पर तुम्हारे लिए यह है, कि तुम लौटो और बहर — ए — कु़लजु़म की राह से वीराने में जाओ। ");
INSERT INTO urd_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“तब तुमने मुझे जवाब दिया, कि हमने ख़ुदावन्द का गुनाह किया है और अब जो कुछ ख़ुदावन्द हमारे ख़ुदा ने हमको हुक्म दिया है, उसके मुताबिक़ हम जाएँगे और जंग करेंगे। इसलिए तुम सब अपने — अपने जंगी हथियार बाँध कर पहाड़ पर चढ़ जाने को तैयार हो गए। ");
INSERT INTO urd_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","तब ख़ुदावन्द ने मुझसे कहा, कि उनसे कह दे के ऊपर मत चढ़ो और न जंग करो क्यूँकि मैं तुम्हारे बीच नहीं हूँ; कहीं ऐसा न हो कि तुम अपने दुश्मनों से शिकस्त खाओ। ");
INSERT INTO urd_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","और मैंने तुमसे कह भी दिया पर तुमने मेरी न सुनी, बल्कि तुमने ख़ुदावन्द के हुक्म से सरकशी की और शोख़ी से पहाड़ पर चढ़ गए। ");
INSERT INTO urd_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","तब अमोरी जो उस पहाड़ पर रहते थे तुम्हारे मुक़ाबले को निकले, और उन्होंने शहद की मक्खियों की तरह तुम्हारा पीछा किया और श'ईर में मारते — मारते तुमको हुरमा तक पहुँचा दिया। ");
INSERT INTO urd_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","तब तुम लौट कर ख़ुदावन्द के आगे रोने लगे, लेकिन ख़ुदावन्द ने तुम्हारी फ़रियाद न सुनी और न तुम्हारी बातों पर कान लगाया। ");
INSERT INTO urd_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","इसलिए तुम क़ादिस में बहुत दिनों तक पड़े रहे, यहाँ तक के एक ज़माना हो गया। ");
INSERT INTO urd_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","“और जैसा ख़ुदावन्द ने मुझे हुक्म दिया था, उसके मुताबिक़ हम लौटे और बहर — ए — कु़लजु़म की राह से वीराने में आए और बहुत दिनों तक कोह — ए — श'ईर के बाहर — बाहर चलते रहे। ");
INSERT INTO urd_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","तब ख़ुदावन्द ने मुझसे कहा, कि: ");
INSERT INTO urd_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","तुम इस पहाड़ के बाहर — बाहर बहुत चल चुके; उत्तर की तरफ़ मुड़ जाओ, ");
INSERT INTO urd_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","और तू इन लोगों को ताकीद कर दे कि तुमको बनी 'ऐसौ, तुम्हारे भाई जो श'ईर में रहते हैं उनकी सरहद के पास से होकर जाना है, और वह तुमसे हिरासान होंगे। इसलिए तुम ख़ूब एहतियात रखना, ");
INSERT INTO urd_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","और उनको मत छेड़ना; क्यूँकि मैं उनकी ज़मीन में से पाँव धरने तक की जगह भी तुमको नहीं दूँगा, इसलिए कि मैंने कोह — ए — श'ईर 'ऐसौ को मीरास में दिया है। ");
INSERT INTO urd_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","तुम रुपये देकर अपने खाने के लिए उनसे ख़ुराक ख़रीदना, और पीने के लिए पानी भी रुपया देकर उनसे मोल लेना। ");
INSERT INTO urd_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","क्यूँकि ख़ुदावन्द तुम्हारा ख़ुदा तेरे हाथ की कमाई में बरकत देता रहा है, और इस बड़े वीराने में जो तुम्हारा चलना फिरना है वह उसे जानता है। इन चालीस बरसों में ख़ुदावन्द तेरा ख़ुदा बराबर तुम्हारे साथ रहा और तुझको किसी चीज़ की कमी नहीं हुई। ");
INSERT INTO urd_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","इसलिए हम अपने भाइयों बनी 'ऐसौ के पास से जो श'ईर में रहते हैं, कतरा कर मैदान की राह से ऐलात और 'अस्यून जाबर होते हुए गुज़रे।” फिर हम मुड़े और मोआब के वीराने के रास्ते से चले। ");
INSERT INTO urd_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","फिर ख़ुदावन्द ने मुझसे कहा, कि मोआबियों को न तो सताना और न उनसे जंग करना; इसलिए कि मैं तुझको उनकी ज़मीन का कोई हिस्सा मिल्कियत के तौर पर नहीं दूँगा, क्यूँकि मैंने 'आर को बनी लूत की मीरास कर दिया है। ");
INSERT INTO urd_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","वहाँ पहले ऐमीम बसे हुए थे जो 'अनाक़ीम की तरह बड़े — बड़े और लम्बे — लम्बे और शुमार में बहुत थे। ");
INSERT INTO urd_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","और 'अनाक़ीम ही की तरह वह भी रिफ़ाईम में गिने जाते थे, लेकिन मोआबी उनको ऐमीम कहते हैं। ");
INSERT INTO urd_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","और पहले श'ईर में होरी क़ौम के लोग बसे हुए थे, लेकिन बनी 'ऐसौ ने उनको निकाल दिया और उनको अपने सामने से बर्बाद करके आप उनकी जगह बस गए, जैसे इस्राईल ने अपनी मीरास के मुल्क में किया जिसे ख़ुदावन्द ने उनको दिया। ");
INSERT INTO urd_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","अब उठो और वादी — ए — ज़रद के पार जाओ। चुनाँचे हम वादी — ए — ज़रद से पार हुए। ");
INSERT INTO urd_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","और हमारे क़ादिस बर्नी'अ से रवाना होने से लेकर वादी — ए — ज़रद के पार होने तक अठतीस बरस का 'अरसा गुज़रा। इस असना में ख़ुदावन्द की क़सम के मुताबिक़ उस नसल के सब जंगी मर्द लश्कर में से मर खप गए। ");
INSERT INTO urd_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","और जब तक वह नाबूद न हो गए तब तक ख़ुदावन्द का हाथ उनको लश्कर में से हलाक करने को उनके ख़िलाफ़ बढ़ा ही रहा। ");
INSERT INTO urd_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","जब सब जंगी मर्द मर गए और क़ौम में से फ़ना हो गए ");
INSERT INTO urd_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","तो ख़ुदावन्द ने मुझसे कहा, ");
INSERT INTO urd_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","आज तुझे 'आर शहर से होकर जो मोआब की सरहद है गुज़रना है। ");
INSERT INTO urd_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","और जब तू बनी 'अम्मोन के क़रीब जा पहुँचे, तो उन को मत सताना और न उनको छेड़ना, क्यूँकि मैं बनी 'अम्मोन की ज़मीन का कोई हिस्सा तुझे मीरास के तौर पर नहीं दूँगा इसलिए कि उसे मैंने बनी लूत को मीरास में दिया है। ");
INSERT INTO urd_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","वह मुल्क भी रिफ़ाईम का गिना जाता था, क्यूँकि पहले रफ़ाईम जिनको 'अम्मोनी लोग ज़मज़मीम कहते थे वहाँ बसे हुए थे। ");
INSERT INTO urd_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","यह लोग भी 'अनाक़ीम की तरह बड़े — बड़े और लम्बे — लम्बे और शुमार में बहुत थे, लेकिन ख़ुदावन्द ने उनको 'अम्मोनियों के सामने से हलाक किया, और वह उनको निकाल कर उनकी जगह आप बस गए। ");
INSERT INTO urd_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","ठीक वैसे ही जैसे उसने बनी 'ऐसौ के सामने से जो श'ईर में रहते थे होरियों को हलाक किया, और वह उनको निकाल कर आज तक उन ही की जगह बसे हुए हैं। ");
INSERT INTO urd_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","ऐसे ही 'अवियों को जो अपनी बस्तियों में ग़ज़्ज़ा तक बसे हुए थे, कफ़तूरियों ने जो कफ़तूरा से निकले थे हलाक किया और उनकी जगह आप बस गए ");
INSERT INTO urd_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","इसलिए उठो, और वादी — ए — अरनून के पार जाओ। देखो, मैंने हस्बोन के बादशाह सीहोन को, जो अमोरी है उसके मुल्क समेत तुम्हारे हाथ में कर दिया है; इसलिए उस पर क़ब्ज़ा करना शुरू' करो और उससे जंग छेड़ दो। ");
INSERT INTO urd_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","मैं आज ही से तुम्हारा ख़ौफ़ और रौब उन क़ौमों के दिल में डालना शुरू' करूँगा जो इस ज़मीन पर रहती हैं, वह तुम्हारी ख़बर सुनेंगी और काँपेंगी, और तुम्हारी वजह से बेताब हो जाएँगी। ");
INSERT INTO urd_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","“और मैंने दश्त — ए — क़दीमात से हस्बोन के बादशाह सीहोन के पास सुलह के पैग़ाम के साथ क़ासिद रवाना किए और कहला भेजा, कि ");
INSERT INTO urd_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","मुझे अपने मुल्क से गुज़र जाने दे; मैं शाहराह से होकर चलूँगा और दहने और बाएँ हाथ नहीं मुड़ूँगा ");
INSERT INTO urd_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","तू रुपये लेकर मेरे हाथ मेरे खाने के लिए ख़ुराक बेचना, और मेरे पीने के लिए पानी भी मुझे रुपया लेकर देना; सिर्फ़ मुझे पाँव — पाँव निकल जाने दे, ");
INSERT INTO urd_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","जैसे बनी 'ऐसौ ने जो श'ईर में रहते हैं, और मोआबियों ने जो 'आर शहर में बसते हैं। मेरे साथ किया; जब तक कि मैं यरदन को उबूर करके उस मुल्क में पहुँच न जाऊँ जो ख़ुदावन्द हमारा ख़ुदा हमको देता है। ");
INSERT INTO urd_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","लेकिन हस्बोन के बादशाह सीहोन ने हमको अपने हाँ से गुज़रने न दिया; क्यूँकि ख़ुदावन्द तेरे ख़ुदा ने उसका मिज़ाज कड़ा और उसका दिल सख़्त कर दिया ताकि उसे तेरे हाथ में हवाले कर दे, जैसा आज ज़ाहिर है। ");
INSERT INTO urd_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","और ख़ुदावन्द ने मुझसे कहा, देख, मैं सीहोन और उसके मुल्क को तेरे हाथ में हवाले करने को हूँ, इसलिए तू उस पर क़ब्ज़ा करना शुरू' कर, ताकि वह तेरी मीरास ठहरे। ");
INSERT INTO urd_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","तब सीहोन अपने सब आदमियों को लेकर हमारे मुक़ाबले में निकला और जंग करने के लिए यहज़ में आया। ");
INSERT INTO urd_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","और ख़ुदावन्द हमारे ख़ुदा ने उसे हमारे हवाले कर दिया; और हमने उसे, और उसके बेटों को, और उसके सब आदमियों को मार लिया। ");
INSERT INTO urd_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","और हमने उसी वक़्त उसके सब शहरों को ले लिया, और हर आबाद शहर को 'औरतों और बच्चों समेत बिल्कुल नाबूद कर दिया और किसी को बाक़ी न छोड़ा; ");
INSERT INTO urd_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","लेकिन चौपायों को और शहरों के माल को जो हमारे हाथ लगा लूट कर हमने अपने लिए रख लिया। ");
INSERT INTO urd_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","और 'अरो'ईर से जो वादी — ए — अरनोन के किनारे है, और उस शहर से जो वादी में है, जिल'आद तक ऐसा कोई शहर न था जिसको सर करना हमारे लिए मुश्किल हुआ; ख़ुदावन्द हमारे ख़ुदा ने सबको हमारे क़ब्ज़े में कर दिया। ");
INSERT INTO urd_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","लेकिन बनी 'अम्मोन के मुल्क के नज़दीक और दरिया — ए — यबोक़ का 'इलाक़ा और कोहिस्तान के शहरों में और जहाँ — जहाँ ख़ुदावन्द हमारे ख़ुदा ने हमको मना' किया था तो नहीं गया। ");
INSERT INTO urd_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","“फिर हमने मुड़ कर बसन का रास्ता लिया और बसन का बादशाह 'ओज अदराई में अपने सब आदमियों को लेकर हमारे मुक़ाबले में जंग करने को आया। ");
INSERT INTO urd_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","और ख़ुदावन्द ने मुझसे कहा, 'उससे मत डर, क्यूँकि मैंने उसको और उसके सब आदमियों और मुल्क को तेरे क़ब्ज़े में कर दिया है; जैसा तूने अमोरियों के बादशाह सीहोन से जो हस्बोन में रहता था किया, वैसा ही तू इससे भी करेगा। ");
INSERT INTO urd_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","चुनाँचे ख़ुदावन्द हमारे ख़ुदा ने बसन के बादशाह 'ओज को भी उसके सब आदमियों समेत हमारे क़ाबू में कर दिया, और हमने उनको यहाँ तक मारा के उनमें से कोई बाक़ी न रहा। ");
INSERT INTO urd_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","और हमने उसी वक़्त उसके सब शहर ले लिए, और एक शहर भी ऐसा न रहा जो हमने उनसे ले न लिया हो। यूँ अरजूब का सारा मुल्क जो बसन में 'ओज की सल्तनत में शामिल था और उसमें साठ शहर थे, हमारे क़ब्ज़े में आया। ");
INSERT INTO urd_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","यह सब शहर फ़सीलदार थे और इनकी ऊँची — ऊँची दीवारें और फाटक और बेंडे थे। इनके 'अलावा बहुत से ऐसे क़स्बे भी हमने ले लिए जो फ़सीलदार न थे। ");
INSERT INTO urd_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","और जैसा हमने हस्बोन के बादशाह सीहोन के यहाँ किया वैसा ही इन सब आबाद शहरों को म'ए 'औरतों और बच्चों के बिल्कुल नाबूद कर डाला। ");
INSERT INTO urd_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","लेकिन सब चौपायों और शहरों के माल को लूट कर हमने अपने लिए रख लिया। ");
INSERT INTO urd_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","यूँ हमने उस वक़्त अमोरियों के दोनों बादशाहों के हाथ से, जो यरदन पार रहते थे उनका मुल्क वादी — ए — अरनोन से कोह — ए — हरमून तक ले लिया। ");
INSERT INTO urd_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","इस हरमून को सैदानी सिरयून, और अमोरी सनीर कहते हैं ");
INSERT INTO urd_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","और सलका और अदराई तक मैदान के सब शहर और सारा जिल'आद और सारा बसन या'नी 'ओज की सल्तनत के सब शहर जो बसन में शामिल थे हमने ले लिए। ");
INSERT INTO urd_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","क्यूँकि रिफ़ाईम की नसल में से सिर्फ़ बसन का बादशाह 'ओज बाक़ी रहा था। उसका पलंग लोहे का बना हुआ था और वह बनी अम्मोन के शहर रब्बा में मौजूद है, और आदमी के हाथ के नाप के मुताबिक़ नौ हाथ लम्बा और चार हाथ चौड़ा है। ");
INSERT INTO urd_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","इसलिए इस मुल्क पर हमने उस वक़्त क़ब्ज़ा कर लिया, और 'अरो'ईर जो वादी — ए — अरनोन के किनारे है और जिल'आद के पहाड़ी मुल्क का आधा हिस्सा और उसके शहर मैंने रूबीनियों और जद्दियों को दिए। ");
INSERT INTO urd_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","और जिल'आद का बाक़ी हिस्सा और सारा बसन या'नी अरजूब का सारा मुल्क जो 'ओज की क़लमरौ में था, मैंने मनस्सी के आधे क़बीले को दिया। बसन रिफ़ाईम का मुल्क कहलाता था। ");
INSERT INTO urd_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","और मनस्सी के बेटे याईर ने जसूरियों और मा'कातियों की सरहद तक अरजूब के सारे मुल्क को ले लिया और अपने नाम पर बसन के शहरों को हव्वत याईर का नाम दिया, जो आज तक चला आता है ");
INSERT INTO urd_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","और जिल'आद मैंने मकीर को दिया, ");
INSERT INTO urd_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","और रूबीनियों और जद्दियों को मैंने जिल'आद से वादी — ए — अरनोन तक का मुल्क, या'नी उस वादी के बीच के हिस्से को उनकी एक हद ठहरा कर दरिया — ए — यबोक़ तक, जो 'अम्मोनियों की सरहद है उनको दिया। ");
INSERT INTO urd_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","और मैदान को और किन्नरत से लेकर मैदान के दरिया या'नी दरिया — ए — शोर तक, जो पूरब में पिसगा के ढाल तक फैला हुआ है और यरदन और उसका सारा इलाके को भी मैंने इन ही को दे दिया। ");
INSERT INTO urd_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","“और मैंने उस वक़्त तुमको हुक्म दिया, कि ख़ुदावन्द तुम्हारे ख़ुदा ने तुमको यह मुल्क दिया है कि तुम उस पर क़ब्ज़ा करो। इसलिए तुम सब जंगी मर्द हथियारबंद होकर अपने भाइयों बनी — इस्राईल के आगे — आगे पार चलो; ");
INSERT INTO urd_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","मगर तुम्हारी बीवियाँ और तुम्हारे बाल बच्चे और चौपाये क्यूँकि मुझे मा'लूम है कि तुम्हारे पास चौपाये बहुत हैं, इसलिए यह सब तुम्हारे उन ही शहरों में रह जाएँ जो मैंने तुमको दिए हैं; ");
INSERT INTO urd_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","आखीर तक कि ख़ुदावन्द तुम्हारे भाइयों को चैन न बख़्शे जैसे तुमको बख़्शा, और वह भी उस मुल्क पर जो ख़ुदावन्द तुम्हारा ख़ुदा यरदन के उस पार तुमको देता है क़ब्ज़ा न कर लें। तब तुम सब अपनी मिल्कियत में जो मैंने तुमको दी है लौट कर आने पाओगे। ");
INSERT INTO urd_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","और उसी मौक़े' पर मैंने यशू'अ को हुक्म दिया, कि जो कुछ ख़ुदावन्द तुम्हारे ख़ुदा ने इन दो बादशाहों से किया वह सब तूने अपनी आँखों से देखा; ख़ुदावन्द ऐसा ही उस पार उन सब सल्तनतों का हाल करेगा जहाँ तू जा रहा है। ");
INSERT INTO urd_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","तुम उनसे न डरना, क्यूँकि ख़ुदावन्द तुम्हारा ख़ुदा तुम्हारी तरफ़ से आप जंग कर रहा है। ");
INSERT INTO urd_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","उस वक़्त मैंने ख़ुदावन्द से 'आजिज़ी के साथ दरख़्वास्त की कि, ");
INSERT INTO urd_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","ऐ ख़ुदावन्द ख़ुदा तूने अपने बन्दे को अपनी 'अज़मत और अपना ताक़तवर हाथ दिखाना शुरू' किया है क्यूँकि आसमान में या ज़मीन पर ऐसा कौन मा'बूद है जो तेरे से काम या करामात कर सके। ");
INSERT INTO urd_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","इसलिए मैं तेरी मिन्नत करता हूँ कि मुझे पार जाने दे कि मैं भी अच्छे मुल्क को जो यरदन के पार है और उस ख़ुशनुमा पहाड़ और लुबनान को देखूँ। ");
INSERT INTO urd_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","लेकिन ख़ुदावन्द तुम्हारी वजह से मुझसे नाराज़ था और उसने मेरी न सुनी; बल्कि ख़ुदावन्द ने मुझसे कहा, कि बस कर इस मज़मून पर मुझसे फिर कभी कुछ न कहना। ");
INSERT INTO urd_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","तू कोह — ए — पिसगा की चोटी पर चढ़ जा और पश्चिम और उत्तर और दख्खिन और पूरब की तरफ़ नज़र दौड़ा कर उसे अपनी आँखों से देख ले, क्यूँकि तू इस यरदन के पार नहीं जाने पाएगा। ");
INSERT INTO urd_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","पर यशू'अ को वसीयत कर और उसकी हौसला अफ़्ज़ाई करके उसे मज़बूत कर क्यूँकि वह इन लोगों के आगे पार जाएगा; और वही इनको उस मुल्क का, जिसे तू देख लेगा मालिक बनाएगा। ");
INSERT INTO urd_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","चुनाँचे हम उस वादी में जो बैत फ़ग़ूर है ठहरे रहे। ");
INSERT INTO urd_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","“और अब ऐ इस्राईलियो, जो आईन और अहकाम मैं तुमको सिखाता हूँ तुम उन पर 'अमल करने के लिए उनको सुन लो, ताकि तुम ज़िन्दा रहो और उस मुल्क में जिसे ख़ुदावन्द तुम्हारे बाप — दादा का ख़ुदा तुमको देता है, दाख़िल हो कर उस पर क़ब्ज़ा कर लो। ");
INSERT INTO urd_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","जिस बात का मैं तुमको हुक्म देता हूँ, उसमें न तो कुछ बढ़ाना और न कुछ घटाना; ताकि तुम ख़ुदावन्द अपने ख़ुदा के हुक्मों को जो मैं तुमको बताता हूँ मान सको। ");
INSERT INTO urd_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","जो कुछ ख़ुदावन्द ने बा'ल फ़ग़ूर की वजह से किया, वह तुमने अपनी आँखों से देखा है; क्यूँकि उन सब आदमियों को जिन्होंने बा'ल फ़ग़ूर की पैरवी की, ख़ुदावन्द तुम्हारे ख़ुदा ने तुम्हारे बीच से नाबूद कर दिया। ");
INSERT INTO urd_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","पर तुम जो ख़ुदावन्द अपने ख़ुदा से लिपटे रहे हो, सब के सब आज तक ज़िन्दा हो। ");
INSERT INTO urd_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","देखो, जैसा ख़ुदावन्द मेरे ख़ुदा ने मुझे हुक्म दिया, उसके मुताबिक़ मैंने तुमको आईन और अहकाम सिखा दिए हैं; ताकि उस मुल्क में उन पर 'अमल करो जिस पर क़ब्ज़ा करने के लिए जा रहे हो। ");
INSERT INTO urd_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","इसलिए तुम इनको मानना और 'अमल में लाना, क्यूँकि और क़ौमों के सामने यही तुम्हारी 'अक़्ल और दानिश ठहरेंगे। वह इन तमाम क़वानीन को सुन कर कहेंगी, कि यक़ीनन ये बुज़ुर्ग क़ौम निहायत 'अक़्लमन्द और समझदार है। ");
INSERT INTO urd_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","क्यूँकि ऐसी बड़ी क़ौम कौन है जिसका मा'बूद इस क़द्र उसके नज़दीक हो जैसा ख़ुदावन्द हमारा ख़ुदा, कि जब कभी हम उससे दुआ करें हमारे नज़दीक है? ");
INSERT INTO urd_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","और कौन ऐसी बुज़ुर्ग क़ौम है जिसके आईन और अहकाम ऐसे रास्त हैं जैसी ये सारी शरी'अत है, जिसे मैं आज तुम्हारे सामने रखता हूँ। ");
INSERT INTO urd_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","“इसलिए तुम ज़रूर ही अपनी एहतियात रखना और बड़ी हिफ़ाज़त करना, ऐसा न हो कि तुम वह बातें जो तुमने अपनी आँख से देखी हैं भूल जाओ और वह ज़िन्दगी भर के लिए तुम्हारे दिल से जाती रहें; बल्कि तुम उनको अपने बेटों और पोतों को सिखाना। ");
INSERT INTO urd_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","ख़ासकर उस दिन की बातें, जब तू ख़ुदावन्द अपने ख़ुदा के सामने होरिब में खड़ा हुआ; क्यूँकि ख़ुदावन्द ने मुझसे कहा था, कि क़ौम को मेरे सामने जमा' कर और मैं उनको अपनी बातें सुनाऊँगा ताकि वह ये सीखें कि ज़िन्दगी भर, जब तक ज़मीन पर ज़िन्दा रहें मेरा ख़ौफ़ मानें और अपने बाल — बच्चों को भी यही सिखाएँ। ");
INSERT INTO urd_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","चुनाँचे तुम नज़दीक जाकर उस पहाड़ के नीचे खड़े हुए, और वह पहाड़ आग से दहक रहा था और उसकी लौ आसमान तक पहुँचती थी और चारों तरफ़ तारीकी और घटा और ज़ुलमत थी। ");
INSERT INTO urd_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","और ख़ुदावन्द ने उस आग में से होकर तुमसे कलाम किया; तुमने बातें तो सुनीं लेकिन कोई सूरत न देखी, सिर्फ़ आवाज़ ही आवाज़ सुनी। ");
INSERT INTO urd_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","और उसने तुमको अपने 'अहद के दसों अहकाम बताकर उनके मानने का हुक्म दिया, और उनको पत्थर की दो तख़्तियों पर लिख भी दिया। ");
INSERT INTO urd_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","उस वक़्त ख़ुदावन्द ने मुझे हुक्म दिया, कि तुमको यह आईन और अहकाम सिखाऊँ ताकि तुम उस मुल्क में जिस पर क़ब्ज़ा करने के लिए जा रहे हो, उन पर 'अमल करो। ");
INSERT INTO urd_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“इसलिए तुम अपनी ख़ूब ही एहतियात रखना; क्यूँकि तुमने उस दिन जब ख़ुदावन्द ने आग में से होकर होरिब में तुमसे कलाम किया, किसी तरह की कोई सूरत नहीं देखी। ");
INSERT INTO urd_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","ऐसा न हो कि तुम बिगड़कर किसी शक्ल या सूरत की खोदी हुई मूरत अपने लिए बना लो, जिसकी शबीह किसी मर्द या 'औरत, ");
INSERT INTO urd_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","या ज़मीन के किसी हैवान या हवा में उड़ने वाले परिन्दे, ");
INSERT INTO urd_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","या ज़मीन के रेंगनेवाले जानदार या मछली से, जो ज़मीन के नीचे पानी में रहती है मिलती हो; ");
INSERT INTO urd_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","या जब तू आसमान की तरफ नज़र करे और तमाम अजराम — ए — फ़लक या'नी सूरज और चाँद और तारों को देखे, तो गुमराह होकर उन्हीं को सिज्दा और उनकी इबादत करने लगे जिनको ख़ुदावन्द तुम्हारे ख़ुदा ने इस ज़मीन की सब क़ौमों के लिए रख्खा है। ");
INSERT INTO urd_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","लेकिन ख़ुदावन्द ने तुमको चुना, और तुमको जैसे लोहे की भट्टी या'नी मिस्र से निकाल ले आया है ताकि तुम उसकी मीरास के लोग ठहरो, जैसा आज ज़ाहिर है। ");
INSERT INTO urd_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","और तुम्हारी ही वजह से ख़ुदावन्द ने मुझसे नाराज़ होकर क़सम खाई, कि मैं यरदन पार न जाऊँ और न उस अच्छे मुल्क में पहुँचने पाऊँ, जिसे ख़ुदावन्द तुम्हारा ख़ुदा मीरास के तौर पर तुझको देता है; ");
INSERT INTO urd_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","बल्कि मुझे इसी मुल्क में मरना है, मैं यरदन पार नहीं जा सकता; लेकिन तुम पार जाकर उस अच्छे मुल्क पर क़ब्ज़ा करोगे। ");
INSERT INTO urd_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","इसलिए तुम एहतियात रखो, ऐसा न हो कि तुम ख़ुदावन्द अपने ख़ुदा के उस 'अहद को जो उसने तुमसे बाँधा है भूल जाओ, और अपने लिए किसी चीज़ की शबीह की खोदी हुई मूरत बना लो जिसे ख़ुदावन्द तेरे ख़ुदा ने तुझको मना' किया है ");
INSERT INTO urd_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","क्यूँकि ख़ुदावन्द तेरा ख़ुदा भसम करने वाली आग है; वह ग़य्यूर ख़ुदा है। ");
INSERT INTO urd_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","और जब तुझसे बेटे और पोते पैदा हों और तुमको उस मुल्क में रहते हुए एक ज़माना हो जाए, और तुम बिगड़कर किसी चीज़ की शबीह की खोदी हुई मूरत बना लो, और ख़ुदावन्द अपने ख़ुदा के सामने शरारत करके उसे ग़ुस्सा दिलाओ; ");
INSERT INTO urd_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","तो मैं आज के दिन तुम्हारे बरख़िलाफ़ आसमान और ज़मीन को गवाह बनाता हूँ कि तुम उस मुल्क से, जिस पर क़ब्ज़ा करने को यरदन पार जाने पर हो, जल्द बिल्कुल फ़ना हो जाओगे; तुम वहाँ बहुत दिन रहने न पाओगे बल्कि बिल्कुल नाबूद कर दिए जाओगे। ");
INSERT INTO urd_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","और ख़ुदावन्द तुमको क़ौमों में तितर बितर करेगा; और जिन क़ौमों के बीच ख़ुदावन्द तुमको पहुँचाएगा उनमें तुम थोड़े से रह जाओगे। ");
INSERT INTO urd_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","और वहाँ तुम आदमियों के हाथ के बने हुए लकड़ी और पत्थर के मा'बूदों की इबादत करोगे, जो न देखते न सुनते न खाते न सूँघते हैं। ");
INSERT INTO urd_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","लेकिन वहाँ भी अगर तुम ख़ुदावन्द अपने ख़ुदा के तालिब हो तो वह तुझको मिल जाएगा, बशर्ते कि तुम अपने पूरे दिल से और अपनी सारी जान से उसे ढूँढो। ");
INSERT INTO urd_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","जब तू मुसीबत में पड़ेगा और यह सब बातें तुझ पर गुज़रेंगी तो आख़िरी दिनों में तू ख़ुदावन्द अपने ख़ुदा की तरफ़ फिरेगा और उसकी मानेगा; ");
INSERT INTO urd_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","क्यूँकि ख़ुदावन्द तेरा ख़ुदा, रहीम ख़ुदा है, वह तुझको न तो छोड़ेगा और न हलाक करेगा और न उस 'अहद को भूलेगा जिसकी क़सम उसने तुम्हारे बाप — दादा से खाई। ");
INSERT INTO urd_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","“और जब से ख़ुदा ने इंसान को ज़मीन पर पैदा किया, तब से शुरू' करके तुम उन गुज़रे दिनों का हाल जो तुमसे पहले हो चुके पूछ, और आसमान के एक सिरे से दूसरे सिरे तक दरियाफ़्त कर, कि इतनी बड़ी वारदात की तरह कभी कोई बात हुई या सुनने में भी आई? ");
INSERT INTO urd_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","क्या कभी कोई क़ौम ख़ुदा की आवाज़ जैसे तू ने सुनी, आग में से आती हुई सुन कर ज़िन्दा बची है? ");
INSERT INTO urd_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","या कभी ख़ुदा ने एक क़ौम को किसी दूसरी क़ौम के बीच से निकालने का इरादा करके, इम्तिहानों और निशान और मो'जिज़ों और जंग और ताक़तवर हाथ और बलन्द बाज़ू और हौलनाक माजरों के वसीले से, उनको अपनी ख़ातिर बरगुज़ीदा करने के लिए वह काम किए जो ख़ुदावन्द तुम्हारे ख़ुदा ने तुम्हारी आँखों के सामने मिस्र में तुम्हारे लिए किए? ");
INSERT INTO urd_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","यह सब कुछ तुझको दिखाया गया, ताकि तू जाने कि ख़ुदावन्द ही ख़ुदा है और उसके अलावा और कोई है ही नहीं। ");
INSERT INTO urd_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","उसने अपनी आवाज़ आसमान में से तुमको सुनाई ताकि तुझको तरबियत करे, और ज़मीन पर उसने तुझको अपनी बड़ी आग दिखाई; और तुमने उसकी बातें आग के बीच में से आती हुई सुनी। ");
INSERT INTO urd_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","और चूँकि उसे तेरे बाप — दादा से मुहब्बत थी, इसीलिए उसने उनके बाद उनकी नसल को चुन लिया, और तेरे साथ होकर अपनी बड़ी कुदरत से तुझको मिस्र से निकाल लाया; ");
INSERT INTO urd_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","ताकि तुम्हारे सामने से उन क़ौमों को जो तुझ से बड़ी और ताक़तवर हैं दफ़ा' करे, और तुझको उनके मुल्क में पहुँचाए, और उसे तुझको मीरास के तौर पर दे, जैसा आज के दिन ज़ाहिर है। ");
INSERT INTO urd_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","इसलिए आज के दिन तू जान ले और इस बात को अपने दिल में जमा ले, कि ऊपर आसमान में और नीचे ज़मीन पर ख़ुदावन्द ही ख़ुदा है और कोई दूसरा नहीं। ");
INSERT INTO urd_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","इसलिए तू उसके आईन और अहकाम को जो मैं तुझको आज बताता हूँ मानना, ताकि तेरा और तेरे बाद तेरी औलाद का भला हो, और हमेशा उस मुल्क में जो ख़ुदावन्द तेरा ख़ुदा तुझको देता है तेरी उम्र दराज़ हो।” ");
INSERT INTO urd_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","फिर मूसा ने यरदन के पार पूरब की तरफ़ तीन शहर अलग किए, ");
INSERT INTO urd_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ताकि ऐसा ख़ूनी जो अनजाने बग़ैर क़दीमी 'अदावत के अपने पड़ोसी को मार डाले, वह वहाँ भाग जाए और इन शहरों में से किसी में जाकर जीता बच रहे। ");
INSERT INTO urd_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","या'नी रूबीनियों के लिए तो शहर — ए — बसर हो जो तराई में वीरान के बीच वाक़े' है, और जद्दियों के लिए शहर — ए — रामात जो जिल'आद में है, और मनस्सियों के लिए बसन का शहर — ए — जौलान। ");
INSERT INTO urd_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","यह वह शरी'अत है जो मूसा ने बनी — इस्राईल के आगे पेश की। ");
INSERT INTO urd_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","यही वह शहादतें और आईन और अहकाम हैं जिनको मूसा ने बनी — इस्राईल को उनके मिस्र से निकलने के बा'द, ");
INSERT INTO urd_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","यरदन के पार उस वादी में जो बैत फ़ग़ूर के सामने है, कह सुनाया; या'नी अमोरियों के बादशाह सीहोन के मुल्क में जो हस्बोन में रहता था, जिसे मूसा और बनी इस्राईल ने मुल्क — ए — मिस्र से निकलने के बाद मारा। ");
INSERT INTO urd_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","और फिर उसके मुल्क को, और बसन के बादशाह 'ओज के मुल्क को अपने क़ब्ज़े में कर लिया। अमोरियों के इन दोनों बादशाहों का यह मुल्क यरदन पार पूरब की तरफ़, ");
INSERT INTO urd_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","'अरो'ईर से जो वादी — ए — अरनोन के किनारे वाक़े' है, कोह — ए — सियून तक जिसे हरमून भी कहते हैं, फैला हुआ है। ");
INSERT INTO urd_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","इसी में यरदन पार पूरब की तरफ़ मैदान के दरिया तक जो पिसगा की ढाल के नीचे बहता है, वहाँ का सारा मैदान शामिल है। ");
INSERT INTO urd_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","फिर मूसा ने सब इस्रराईलियों को बुलावा कर उनको कहा, ऐ इस्राईलियो। तुम उन आईन और अहकाम को सुन लो, जिनको मैं आज तुमको सुनाता हूँ, ताकि तुम उनको सीख कर उन पर 'अमल करो। ");
INSERT INTO urd_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","ख़ुदावन्द हमारे ख़ुदा ने होरिब में हमसे एक 'अहद बाँधा। ");
INSERT INTO urd_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","ख़ुदावन्द ने यह 'अहद हमारे बाप — दादा से नहीं, बल्कि ख़ुद हम सब से जो यहाँ आज के दिन जीते हैं बाँधा। ");
INSERT INTO urd_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","ख़ुदावन्द ने तुमसे उस पहाड़ पर, आमने — सामने आग के बीच में से बातें कीं। ");
INSERT INTO urd_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","उस वक़्त मैं तुम्हारे और ख़ुदावन्द के बीच खड़ा हुआ ताकि ख़ुदावन्द का कलाम तुम पर ज़ाहिर करूँ क्यूँकि तुम आग की वजह से डरे हुए थे और पहाड़ पर न चढ़े। ");
INSERT INTO urd_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","तब उसने कहा, 'ख़ुदावन्द तेरा ख़ुदा, जो तुझको मुल्क — ए — मिस्र या'नी ग़ुलामी के घर से निकाल लाया, मैं हूँ। ");
INSERT INTO urd_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","'मेरे आगे तू और मा'बूदों को न मानना। ");
INSERT INTO urd_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","'तू अपने लिए कोई तराशी हुई मूरत न बनाना, न किसी चीज़ की सूरत बनाना जो ऊपर आसमान में या नीचे ज़मीन पर या ज़मीन के नीचे पानी में है। ");
INSERT INTO urd_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","तू उनके आगे सिज्दा न करना और न उनकी इबादत करना, क्यूँकि मैं ख़ुदावन्द तेरा ख़ुदा ग़य्यूर ख़ुदा हूँ। और जो मुझसे 'अदावत रखते हैं उनकी औलाद को तीसरी और चौथी नसल तक बाप — दादा की बदकारी की सज़ा देता हूँ ");
INSERT INTO urd_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","और हज़ारों पर जो मुझसे मुहब्बत रखते और मेरे हुक्मों को मानते हैं, रहम करता हूँ। ");
INSERT INTO urd_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","'तू ख़ुदावन्द अपने ख़ुदा का नाम बेफ़ायदा न लेना; क्यूँकि ख़ुदावन्द उसको जो उसका नाम बेफ़ायदा लेता है, बेगुनाह न ठहराएगा। ");
INSERT INTO urd_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","'तू ख़ुदावन्द अपने ख़ुदा के हुक्म के मुताबिक़ सबत के दिन को याद करके पाक मानना। ");
INSERT INTO urd_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","छ: दिन तक तू मेहनत करके अपना सारा काम — काज करना; ");
INSERT INTO urd_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","लेकिन सातवाँ दिन ख़ुदावन्द तेरे ख़ुदा का सबत है उसमें न तू कोई काम करे, न तेरा बेटा, न तेरी बेटी, न तेरा ग़ुलाम, न तेरी लौंडी, न तेरा बैल, न तेरा गधा, न तेरा और कोई जानवर और न कोई मुसाफ़िर जो तेरे फाटकों के अन्दर हों; ताकि तेरा ग़ुलाम और तेरी लौंडी भी तेरी तरह आराम करें। ");
INSERT INTO urd_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","और याद रखना कि तू मुल्क — ए — मिस्र में ग़ुलाम था, और वहाँ से ख़ुदावन्द तेरा ख़ुदा अपने ताक़तवर हाथ और बलन्द बाज़ू से तुझको निकाल लाया; इसलिए ख़ुदावन्द तेरे ख़ुदा ने तुझको सबत के दिन को मानने का हुक्म दिया। ");
INSERT INTO urd_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","'अपने बाप और अपनी माँ की 'इज़्ज़त करना, जैसा ख़ुदावन्द तेरे ख़ुदा ने तुझे हुक्म दिया है; ताकि तेरी उम्र दराज़ हो और जो तेरा मुल्क ख़ुदावन्द तेरा ख़ुदातुझे देता है उसमें तेरा भला हो। ");
INSERT INTO urd_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","तू ख़ून न करना। ");
INSERT INTO urd_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","'तू ज़िना न करना। ");
INSERT INTO urd_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“तू चोरी न करना। ");
INSERT INTO urd_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","'तू अपने पड़ोसी के ख़िलाफ़ झूठी गवाही न देना। ");
INSERT INTO urd_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","'तू अपने पड़ोसी की बीवी का लालच न करना, और न अपने पड़ोसी के घर, या उसके खेत, या ग़ुलाम, या लौंडी, या बैल, या गधे, या उसकी किसी और चीज़ का ख़्वाहिश मन्द होना। ");
INSERT INTO urd_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","“यही बातें ख़ुदावन्द ने उस पहाड़ पर, आग और घटा और ज़ुलमत में से तुम्हारी सारी जमा'अत को बलन्द आवाज़ से कहीं, और इससे ज़्यादा और कुछ न कहा और इन ही को उसने पत्थर की दो तख़्तियों पर लिखा और उनको मेरे सुपुर्द किया। ");
INSERT INTO urd_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","'और जब वह पहाड़ आग से दहक रहा था, और तुमने वह आवाज़ अन्धेरे में से आती सुनी तो तुम और तुम्हारे क़बीलों के सरदार और बुज़ुर्ग मेरे पास आए। ");
INSERT INTO urd_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","और तुम कहने लगे, कि ख़ुदावन्द हमारे ख़ुदा ने अपनी शौकत और 'अज़मत हमको दिखाई, और हमने उसकी आवाज़ आग में से आती सुनी; आज हमने देख लिया के ख़ुदावन्द इंसान से बातें करता है तो भी इंसान ज़िन्दा रहता है। ");
INSERT INTO urd_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","इसलिए अब हम क्यूँ अपनी जान दें? क्यूँकि ऐसी बड़ी आग हमको भसम कर देगी, अगर हम ख़ुदावन्द अपने ख़ुदा की आवाज़ फिर सुनें तो मर ही जाएँगे। ");
INSERT INTO urd_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","क्यूँकि ऐसा कौन सा बशर है जिसने ज़िन्दा ख़ुदा की आवाज़ हमारी तरह आग में से आती सुनी हो और फिर भी ज़िन्दा रहा? ");
INSERT INTO urd_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","इसलिए तू ही नज़दीक जाकर जो कुछ ख़ुदावन्द हमारा ख़ुदा कहे उसे सुन ले, और तू ही वह बातें जो ख़ुदावन्द हमारा ख़ुदा तुझ से कहे हमको बताना; और हम उसे सुनेंगे और उस पर 'अमल करेंगे। ");
INSERT INTO urd_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","“और जब तुम मुझसे गुफ़्तगू कर रहे थे तो ख़ुदावन्द ने तुम्हारी बातें सुनीं। तब ख़ुदावन्द ने मुझसे कहा, कि मैंने इन लोगों की बातें, जो उन्होंने तुझ से कहीं सुनी हैं; जो कुछ उन्होंने कहा ठीक कहा। ");
INSERT INTO urd_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","काश उनमें ऐसा ही दिल हो ताकि वह मेरा ख़ौफ़ मान कर हमेशा मेरे सब हुक्मों पर 'अमल करते, ताकि हमेशा उनका और उनकी औलाद का भला होता। ");
INSERT INTO urd_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","इसलिए तू जाकर उनसे कह दे, कि तुम अपने ख़ेमों को लौट जाओ। ");
INSERT INTO urd_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","लेकिन तू यहीं मेरे पास खड़ा रह और मैं वह सब फ़रमान और सब आईन और अहकाम जो तुझे उनको सिखाने हैं, तुझको बताऊँगा; ताकि वह उन पर उस मुल्क में जो मैं उनको क़ब्ज़ा करने के लिए देता हूँ, 'अमल करें। ");
INSERT INTO urd_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","इसलिए तुम एहतियात रखना और जैसा ख़ुदावन्द तुम्हारे ख़ुदा ने तुमको हुक्म दिया है वैसा ही करना, और दहने या बाएँ हाथ को न मुड़ना। ");
INSERT INTO urd_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","तुम उस सारे रास्ते पर जिसका हुक्म ख़ुदावन्द तुम्हारे ख़ुदा ने तुमको दिया है चलना; ताकि तुम ज़िन्दा रहो और तुम्हारा भला हो, और तुम्हारी उम्र उस मुल्क में जिस पर तुम क़ब्ज़ा करोगे दराज़ हो। ");
INSERT INTO urd_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","यह वह फ़रमान और आईन और अहकाम हैं, जिनको ख़ुदावन्द तुम्हारे ख़ुदा ने तुमको सिखाने का हुक्म दिया है; ताकि तुम उन पर उस मुल्क में 'अमल करो, जिस पर क़ब्ज़ा करने के लिए पार जाने को हो। ");
INSERT INTO urd_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","और तुम अपने बेटों और पोतों समेत ख़ुदावन्द अपने ख़ुदा का ख़ौफ़ मान कर उसके तमाम आईन और अहकाम पर, जो मैं तुमको बताता हूँ, ज़िन्दगी भर 'अमल करना ताकि तुम्हारी उम्र दराज़ हो। ");
INSERT INTO urd_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","इसलिए, ऐ इस्राईल सुन, और एहतियात करके उन पर 'अमल कर, ताकि तेरा भला हो और तुम ख़ुदावन्द अपने बाप — दादा के ख़ुदा के वा'दे के मुताबिक़ उस मुल्क में, जिस में दूध और शहद बहता है बहुत बढ़ जाओ। ");
INSERT INTO urd_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","'सुन, ऐ इस्राईल, ख़ुदावन्द हमारा ख़ुदा एक ही ख़ुदावन्द है। ");
INSERT INTO urd_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","तू अपने सारे दिल, और अपनी सारी जान, और अपनी सारी ताक़त से ख़ुदावन्द अपने ख़ुदा से मुहब्बत रख। ");
INSERT INTO urd_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","और ये बातें जिनका हुक्म आज मैं तुझे देता हूँ तेरे दिल पर नक़्श रहें। ");
INSERT INTO urd_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","और तू इनको अपनी औलाद के ज़हन नशीं करना, और घर बैठे और राह चलते और लेटते और उठते वक़्त इनका ज़िक्र किया करना। ");
INSERT INTO urd_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","और तू निशान के तौर पर इनको अपने हाथ पर बाँधना, और वह तेरी पेशानी पर टीकों की तरह हों। ");
INSERT INTO urd_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","और तू उनको अपने घर की चौखटों और अपने फाटकों पर लिखना। ");
INSERT INTO urd_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","और जब ख़ुदावन्द तेरा ख़ुदा तुझको उस मुल्क में पहुँचाए, जिसे तुझको देने की क़सम उसने तेरे बाप — दादा अब्रहाम और इस्हाक़ और या'क़ूब से खाई, और जब वह तुझको बड़े — बड़े और अच्छे शहर जिनको तूने नहीं बनाया, ");
INSERT INTO urd_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","और अच्छी — अच्छी चीज़ों से भरे हुऐ घर जिनको तूने नहीं भरा, और खोदे — खुदाए हौज़ जो तूने नहीं खोदे, और अंगूर के बाग़ और ज़ैतून के दरख़्त जो तूने नहीं लगाए 'इनायत करे, और तू खाए और सेर हो, ");
INSERT INTO urd_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","तो तू होशियार रहना, कहीं ऐसा न हो कि तू ख़ुदावन्द को जो तुझको मुल्क — ए — मिस्र या'नी ग़ुलामी के घर से निकाल लाया भूल जाए। ");
INSERT INTO urd_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","तू ख़ुदावन्द अपने ख़ुदा का ख़ौफ़ मानना, और उसी की इबादत करना, और उसी के नाम की क़सम खाना। ");
INSERT INTO urd_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","तुम और मा'बूदों की या'नी उन क़ौमों के मा'बूदों की, जो तुम्हारे आस — पास रहती हैं पैरवी न करना। ");
INSERT INTO urd_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","क्यूँकि ख़ुदावन्द तुम्हारा ख़ुदा जो तुम्हारे बीच है ग़य्यूर ख़ुदा है। इसलिए ऐसा न हो कि ख़ुदावन्द तुम्हारे ख़ुदा का ग़ज़ब तुझ पर भड़के, और वह तुझको इस ज़मीन पर से फ़ना कर दे। ");
INSERT INTO urd_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","“तुम ख़ुदावन्द अपने ख़ुदा को मत आज़माना, जैसा तुमने उसे मस्सा में आज़माया था। ");
INSERT INTO urd_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","तुम मेहनत से ख़ुदावन्द अपने ख़ुदा के हुक्मों और श