﻿USE sofia;
DROP TABLE IF EXISTS sofia.urbNT_vpl;
CREATE TABLE urbNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES urbNT_vpl WRITE;
INSERT INTO urbNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ko Jesu Kirisutu ramũi ta rer ihẽ amupinim aĩ. Ihẽ Matéu. Kome'ẽ paper ihẽ amupinim aĩ. (“Kirisutu” aja ihẽ apandu rahã: “Kapitã keruhũ” aja Tupã mu'am ame'ẽ ke a'e, aja amujekwa.) Jesu riki Ndawi rainõ ke a'e. (Aja rahã, Ndawi aja kapitã keruhũ a'e tĩ.) Ndawi Amarã rainõ. Kuja riki Jesu ramũi ta rer. ");
INSERT INTO urbNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Amarã Isak ru. Isak Jako ru. Jako Junda ru. Imu ta heta. Jako ame'ẽ ta pái tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Junda Per ru. Sera ru a'e tĩ. Junda rakehar Tam. Per Erõ ru. Erõ Aran ru. ");
INSERT INTO urbNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aran Amina ru. Amina Nasõ ru. Nasõ Samõ ru. ");
INSERT INTO urbNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Samõ Mboa ru. Hambe Samõ rakehar. Mboa Ombe ru. Mboa rakehar Hut. Ombe Jese ru. ");
INSERT INTO urbNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese Ndawi ru. Ndawi kapitã keruhũ tĩ. Ndawi Saromã ru. Saromã mãi Uri ambyr rakehar. Amarã rainõ hetaha ke jande jamanga manga rahã, awa py tumeme (14) hetaha ixo. Pe, Ndawi rehe mangaha uhyk. ");
INSERT INTO urbNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Saromã Homoã ru. Homoã Ambi ru. Ambi Asa ru. ");
INSERT INTO urbNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Josapa ru. Josapa Jorã ru. Jorã Usi ru. ");
INSERT INTO urbNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usi Jotã ru. Jotã Aka ru. Aka Eseki ru. ");
INSERT INTO urbNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Eseki Manase ru. Manase Amon ru. Amon Josi ru. ");
INSERT INTO urbNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josi Jekoni ru. Imu ta ru tĩ. Mambiro ok ta pe jundéu awa ta ke kapitã keruhũ raho. Mambiro ok ta pe har tama'e kapitã keruhũ raho. Arahã Jekoni ra'yr ta u'ar. A'erehe Ndawi rainõ ta hetaha jamanga manga rahã, awa py tumeme (14) hetaha ixo. Pe, Jekoni rehe uhyk. Arahã Mambiro ok ta pe jundéu awa ta ke Mambiro ok ta pe har tama'e kapitã keruhũ raho. ");
INSERT INTO urbNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mambiro ok ta rehe jundéu awa ta ixo rahã, Jekoni ra'yr u'ar. A'e Sarati ru. Sarati Soromambe ru. ");
INSERT INTO urbNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Soromambe Ambiu ru. Ambiu Eriakĩ ru. Eriakĩ Asor ru. ");
INSERT INTO urbNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor Sando ru. Sando Akĩ ru. Akĩ Eriu ru. ");
INSERT INTO urbNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eriu Erea ru. Erea Matã ru. Matã Jako ru. ");
INSERT INTO urbNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Pe, Jako Jose ru. Jose Mari ke pyhyk. Mari pusu ngi Jesu u'ar. Jesu mokõi her. “Kirisutu” amõ her tĩ. (“Kirisutu” aja ihẽ apandu rahã: “Kapitã keruhũ” aja Tupã mu'am ame'ẽ ke a'e. Jundéu awa ta harõ katu hũ ixo ame'ẽ ke a'e.) ");
INSERT INTO urbNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mambiro ok ta pe jundéu awa ta ixo. Arahã Jekoni ra'yr ta u'ar. Hainõ ta hetaha jamanga manga rahã, awa py tumeme (14) hetaha ixo. Pe, Jesu rehe mangaha uhyk. ");
INSERT INTO urbNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesu Kirisutu u'ariha kuja riki. Mari Jesu mãi wan ta. “Mari ke ihẽ apyhyk ta” aja Jose pandu katu. Pe, pyhyk ym rahã we, Mari pusu pe imembyr ihĩ, aja a'e ukwa. Tupã'ãma'e pyrãtãha ihĩ ehe. A'erehe ipusu pe imembyr ihĩ. (Awa ke mujã ym.) ");
INSERT INTO urbNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","“Mã! Imembyr” aja Jose ukwa rahã, Mari ke hijar ta tipe. Anĩ. Mari ke muhuxĩ tar ym. Ma'e katu ame'ẽ ke aja te'eha a'e ma'ema'e ixo ame'ẽ ke a'e. A'erehe Mari ke a'e muhuxĩ tar ym. A'erehe amõ ta ukwa ym ha rupi Mari pe a'e pandu ta: “Nde ke ihẽ apyhyk ym ta apo 'y” aja. Aja a'e ukwa. ");
INSERT INTO urbNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Aja a'e ukwa ukwa ou rahã, Tupã je'ẽha rahoha uhyk uwyr ehe. Ixeraiha pe a'e mujekwa ipe: —Jose! Nde riki Ndawi rainõ. Mari pyhykiha ngi ekyje ym. Mari ke epyhyk katu. Tupã'ãma'e pyrãtãha ihĩ katu ehe, a'erehe Mari imembyr namõ ixo. ");
INSERT INTO urbNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Imembyr u'ar ta. Sawa'e ra'yr ta. “Jesu” aja her emoĩ ehe. Ma'e ka'u te'eha ke jundéu awa ta ma'ema'e. Ame'ẽ ke rehe Jesu muhepy ta. A'erehe jundéu awa ta ke Tupã muhã katu ta — aja Jose pe. ");
INSERT INTO urbNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Upa aja rahã, ymanihar panduha ke uhyk. Yman Tupã je'ẽha ke pandu ame'ẽ ta mupinim. Aja uhyk apo 'y. Kuja a'eta mupinim: “Kũjã ixo te'e ame'ẽ ke imembyr namõ ixo. Imembyr u'ar ta. Sawa'e ra'yr ke. ‘Emanue’ aja her moĩ ta ehe.” “Emanue” aja pandu rahã: “Jande namõ Tupã ixo” aja ngã ukwa katu. ");
INSERT INTO urbNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pe, Jose upak rahã, Tupã je'ẽha rahoha mujekwa ame'ẽ ke a'e ma'e. Mari ke pyhyk 'y. ");
INSERT INTO urbNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Imembyr u'ar ym rahã we, Jose pyta ym te ehe. Pe, imembyr u'ar. Sawa'e ra'yr riki. “Jesu” aja her ke Jose moĩ ehe. ");
INSERT INTO urbNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Merẽ ok ta pe Jesu u'ar. Jundéi ywy rehe Merẽ ok ta ihĩ. Arahã Ero jundéu awa tama'e kapitã. Arahã amõ awa sawa'e ta Jerusarẽ ok ta pe uhyk uwyr. (Jundéu awa ym ame'ẽ ta ke a'eta.) Warahy uhemiha koty ngi uhyk uwyr. Jahy rata ta rehe har ukwa katu ame'ẽ ta ke a'eta. Usak usak hũ jahy rata ta rehe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pe, a'eta pandu: —My riki u'ar ame'ẽ ke my? A'e riki jundéu awa tama'e kapitã keruhũ wan ta. Warahy uhemiha koty jande jaxo rahã, jahy rata weraha keruhũ rehe jasak. (A'erehe amõ kapitã keruhũ u'ar ta aja jakwa.) A'erehe jande py'a jamoĩ moĩ ta jajur ehe — aja Ero ta pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ame'ẽ ke rehe Ero hendu rahã: “Mã! Katu ym ihẽ pe” aja jupandu jupe. Inamõ ixo ame'ẽ ta kapitã ta aja tĩ. “Katu ym” aja pandu pandu a'eta jupe. (Amõ kapitã keruhũ wan ta ame'ẽ ke jumai ta a'eta namõ, aja Ero ta ukwaha naĩ.) A'erehe: “Mã! Katu ym” aja pandu pandu a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jundéu awa tama'e pa'ihu ta ke Ero mujy'ar. Moise je'ẽha mu'e ame'ẽ ta ke mujy'ar tĩ. A'e pandu: —My riki Kirisutu u'ar ta my? Tupã mu'am ame'ẽ ke a'e — aja pandu. (“Mu'am ame'ẽ ke” aja pandu rahã: “Kapitã keruhũ” aja Tupã mu'am, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","—Merẽ ok ta pe u'ar ta, Jundéi ywy pe. Kuja Tupã je'ẽha pandu ame'ẽ ta mupinim: ");
INSERT INTO urbNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Merẽ ok ta riki Jundéi ywy rehe ihĩ. Ame'ẽ ok ta ngi kapitã keruhũ uwyr ta. A'erehe ame'ẽ ok ta ke upa ngã ukwa katu. Ame'ẽ kapitã keruhũ jundéu awa tama'e ke. A'e riki ma'e Tupã putar my, ame'ẽ ke a'e mujekwa ta. Jundéu awa ta pe mujekwa ta” aja Tupã je'ẽha pandu ame'ẽ ta mupinim — aja pa'ihu ta pandu Ero pe. ");
INSERT INTO urbNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Warahy uhemiha koty ngi uhyk ame'ẽ ta ke Ero mujy'ar. A'eta jõ mujy'ar. Pe, a'eta namõ Ero pandu pandu. Arahã kuja ukwa. Jahy rata keruhũ uhem, ame'ẽ ngi myja hetaha jahy kanim apo my, ame'ẽ ke ukwa. ");
INSERT INTO urbNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Upa ukwa rahã, Merẽ ok ta pe a'eta ke Ero mondo. Kuja ame'ẽ ta pe pandu: —Kurumĩ ra'yr ke pekekar katu peho. Pemahem rahã, ihẽ pe pepandu pejur. Aja rahã, ihẽ py'a ke ihẽ amoĩ moĩ katu ta ehe tĩ — aja Ero pandu naĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Pe, a'eta oho. Oho ixo rahã, jahy rata weraha keruhũ rehe a'eta usak tĩ. Warahy uhemiha koty ixo rahã, usak. Ame'ẽ ke rehe a'eta usak tĩ. A'erehe hury katu hũ ixo. Hundutar koty ame'ẽ jahy rata weraha keruhũ wata oho ixo. Pe, kurumĩ ra'yr ixo. Ame'ẽ ok 'ar pe jahy rata weraha pyta, ywa rehe. ");
INSERT INTO urbNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Hok pe a'eta ixe oho. Kurumĩ ra'yr rehe a'eta usak. Imãi namõ ixo, Mari namõ. Pe, a'eta pynarãi pe a'eta wapyk uĩ. Aja kurumĩ ra'yr rehe ipy'a ke a'eta moĩ moĩ. Pe, ma'e katu ame'ẽ ke a'eta me'ẽ me'ẽ ipe. Ko, itatawa ke. Ma'e pihe katu ame'ẽ ke me'ẽ ipe tĩ. Amõ pihe katu ame'ẽ ke me'ẽ ipe tĩ. Her mi. ");
INSERT INTO urbNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pe, a'eta ukwer rahã, a'eta ixerai riki. Ame'ẽ pe Tupã mujekwa: —Ero pe pepandu ym peho — aja mujekwa. A'erehe amõ awa rape rupi hekoha pe jywyr oho. ");
INSERT INTO urbNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Sawa'e ta ukwa katu te ame'ẽ ta upa jywyr oho rahã, Jose pe Tupã je'ẽha rahoha mujekwa. Ixeraiha pe mujekwa: —Epu'am. Kurumĩ ra'yr ke epyhyk. Eji ywy pe ekanim eho, imãi namõ. Ero riki kurumĩ ra'yr ke kekar ta. Mahem rahã, jukwa ta, a'erehe pahar ejan eho sengi. Eji ywy pe epyta we rĩ. Ihẽ amujekwa rahã jõ ejywyr — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Pe, pahar Jose pu'am. Kurumĩ ra'yr ke pyhyk. Pe, ame'ẽ pytun rahã, Eji ywy pe oho, ta'yn mãi namõ, Mari namõ. ");
INSERT INTO urbNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","A'ep a'eta pyta. Jundéi ywy rehe Ero ixo rahã, a'eta jywyr ym. Ero manõ rahã, jywyr. Aja rahã, yman Tupã je'ẽha pandu ame'ẽ mupinim, aja uhyk. Kuja. “‘Ihẽ ra'yr Eji ywy ngi ihẽ amujywyr’ aja Tupã pandu” aja amõ mupinim. ");
INSERT INTO urbNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Warahy uhemiha koty ngi uwyr ame'ẽ ta Ero koty jywyr ym oho. “Mã! Ihẽ pe te'e” aja Ero ukwa. A'erehe parahy riki. Pe, sonda ta pe a'e pandu: —Pahar Merẽ ok ta pe peho. Upa katu te kurumĩ ra'yr ta ke pejukwa. Mokõi warahy 'ar ame'ẽ ta ke pejukwa. Upa mokõi warahy 'ar wyr koty ame'ẽ ta ke pejukwa tĩ. Merẽ ok ta rake rupi ixo ame'ẽ ta aja tĩ. Pejukwa tĩ — aja Ero pandu. Aja riki warahy uhemiha koty ngi uwyr ame'ẽ ta mujekwa ipe. Jahy rata weraha keruhũ uhem rahã, mokõi warahy 'ar aha oho. A'erehe: “Kurumĩ ra'yr ta mokõi warahy 'ar ame'ẽ ta ke pejukwa” aja Ero pandu. (Jesu ke Ero jukwa ta tipe. A'erehe upa kurumĩ ra'yr ta ke Ero jukwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Aja rahã, yman Jeremi pandu ame'ẽ ke uhyk. A'e pandu: ");
INSERT INTO urbNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Hama ok ta pe jixi'uha rehe amõ hendu. Imembyr ta manõ, a'erehe Hakéu jixi'u. Marã ka ym muputu'uha” aja riki. (“Hama ok ta” aja pandu rahã: “Merẽ ok ta” aja ngã ukwa. “Hakéu” aja pandu rahã: “Ame'ẽ ok ta pe har kũjã ta” aja ngã ukwa tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ero manõ rahã, Eji ywy pe Jose ixo we rĩ. Pe, Tupã je'ẽha rahoha mujekwa ipe. Ixeraiha pe mujekwa ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Kurumĩ ra'yr ke jukwa tar katu ame'ẽ ta upa manõ. A'erehe jundéu awa tama'e ywy pe ejywyr eho. Kurumĩ ra'yr ke eraho, imãi namõ. Pejywyr peho — aja Tupã je'ẽha rahoha mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","A'erehe Jose pu'am. Pe, jundéu awa tama'e ywy pe jywyr oho. Kurumĩ ra'yr ke raho, imãi namõ. ");
INSERT INTO urbNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ero manõ rahã, henda ke pe Akeráu kapitã. Jundéi ywy pe har tama'e kapitã a'e. Ame'ẽ ke Jose ukwa rahã, ame'ẽ ywy pe a'e oho tar ym. Kyje ingi, a'erehe a'ep oho tar ym. Pe, ixeraiha pe Tupã mujekwa: —Ngariréi ywy pe eho — aja mujekwa. A'erehe Ngariréi ywy pe a'e oho. ");
INSERT INTO urbNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pe, Nasare ok ta pe uhyk oho. Nasare ok ta Ngariréi ywy rehe ihĩ. Pe, a'ep hok ke a'e mujã. Aja rahã, yman Tupã je'ẽha pandu ame'ẽ ta mupinim, aja uhyk. “Nasare ok ta pe har ke a'e” aja Jesu rehe har ngã ukwa. Aja uhyk. ");
INSERT INTO urbNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nasare ok ta pe Jesu ixo rĩ. Arahã awa nixói te ame'ẽ pe Juã mujahukiha uwyr. Ame'ẽ awa nixói te ame'ẽ ke Jundéi ywy rehe ihĩ. (Ixoty heta ngã uhyk uwyr.) ");
INSERT INTO urbNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ame'ẽ ta pe a'e pandu: —Apandu pehẽ pe. “Tupã kotyhar ta aja pemuruwak.” Ma'e peka'u te'eha ke pema'ema'e ym. Ame'ẽ rehe pepyai. Pexoha pyahu ame'ẽ ke Tupã putar, aja pexo katu. Aja rahã: “Ihẽ kotyhar ta ke pehẽ” aja pehẽ pe a'e pandu ta — aja ngã pe Juã pandu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Isai riki Tupã je'ẽha pandu ame'ẽ ke a'e. Kuja a'e mupinim: “Awa nixói te ame'ẽ pe amõ pandu pandu. Kuja: ‘Jandema'e sawa'e te uwyr ta. A'erehe pe ke pemukatu. (Aja rahã, pexoha ke pemukatu.) Pe ke pemutatambyk. Aja rahã, oho katu ta a'e’ aja pandu” aja Isai mupinim. (Aja rahã ma'e ka'u te'eha ma'ema'eha ke ngã hijar. Pe, Tupã koty ipy'a ke muruwak ta.) Aja Isai mupinim. (Yman ame'ẽ ke a'e mupinim rahã, Juã rehe har mupinim.) ");
INSERT INTO urbNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juãma'e mundeha awa rymba ra ke te'e mujã ame'ẽ ke. “Kame” aja ngã rymba rer. (Ymanihar Erima'e mundeha, aja saka ame'ẽ mundeha. Aja rahã, Tupã je'ẽha pandu ame'ẽ ke Juã tĩ, aja mujekwa tĩ.) So'o pirer pe ixu'a rupi pukwar. Tukuxixik mixir ame'ẽ ke a'e u'u. Eir namõ u'u tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusarẽ ok ta ngi heta uhyk uwyr ixoty. Jundéi ywy ngi uhyk uwyr ixoty tĩ. Jondã y rake rupi ixo ame'ẽ ta uhyk uwyr ixoty tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tupã pe kuja a'eta pandu: —Ma'e jaka'u te'eha ke jama'ema'e. Jande py'a ngi ame'ẽ ke ejuhyk — aja a'eta ipe. Aja pandu ame'ẽ ta ke Juã mujahuk. Jondã y pe mujahuk. ");
INSERT INTO urbNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Parise ta Juã koty uhyk uwyr tĩ. Sanduse ta uhyk uwyr ehe tĩ. Ame'ẽ ta Moise je'ẽha mu'e ame'ẽ ta ke a'eta. Johu pandu ipe: —Jande ke emujahuk. Tupã kotyhar ta aja jaxo tar katu tĩ — aja Juã pe. Ame'ẽ ke Juã ukwa rahã, pandu a'eta pe: —Kupixa amõ hapy rahã, tata ngi mbói ujan oho. Aja mbói aja pehẽ tĩ. Aja Tupã mupyraraha ngi pehem tar katu. Ipy'a ym ehe ame'ẽ ta ke Tupã mupyrara ta. Ame'ẽ mupyraraha ngi pehem peho aja pehẽ pe amõ pandu my. Anĩ. Pehem ym ta. ");
INSERT INTO urbNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mã peja ma'e katu ame'ẽ ke pema'ema'e. Aja rahã, ma'e peka'u te'eha pema'ema'eha ke pehijar, aja ngã pe pemujekwa ta kỹ. Aja rahã jõ, Tupã mupyraraha ngi pehem ta. ");
INSERT INTO urbNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","—“Amarã riki jande ramũi, a'erehe Tupã kotyhar ta ke jande. (A'erehe jande ke Tupã mupyrara ym ta)” aja pekwaha naĩ. Anĩ. Pehem ym ta tĩ. Pesarahã! Ko apandu pehẽ pe. Tupã putar rahã, peme'ẽ ita ta ngi Amarã rainõ ta ke a'e muhem ta. Pehẽ ke ombor, pe, pehẽ renda ke pe amõ ta ke muhem ta. (Aja rahã, kuja mujekwa. Tupã pyrãtã te hũ. A'e putar rahã, je'ẽha rupi amõ awa pyahu ame'ẽ ta ke a'e muhem ta. Hendu katu ehe, ame'ẽ ta ke muhem ta, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","—Ma'eywa jaxer rahã, ame'ẽ i'y ke amõ mondok ta. Pe, ame'ẽ myra ke amõ hapy. Pesarahã! Ji riki hapo rake ihĩ. (Aja rahã, mondok tate, aja mujekwa katu.) Aja ngã tĩ. Ma'e ka'u te'eha ke ma'ema'e ixo rahã, ame'ẽ ta ke Tupã mupyrara hũ ta. (I'y mondok, ame'ẽja saka.) Pesarahã! Ji pehĩ aja ngã ke a'e mupyrara tate tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Y pe pehẽ ke ihẽ amujahuk. Aja rahã, ma'e peka'u te'eha pema'ema'eha ke pehijar aja ihẽ amujekwa amõ ta pe. Pesarahã! Ihẽ raikwer rupi amõ uwyr ta. A'e riki pehẽ ke Tupã'ã namõ mujahuk ta. Tata namõ aja tĩ. Mujahuk ta pehẽ ke tĩ. Ihẽ 'ar koty te we ipy'a hãtã te ha a'e. Katu te ame'ẽ ke a'e, a'erehe ima'e miasu aja ihẽ axo rahã, ihẽ katu ym ihẽ jupe ihẽ. ");
INSERT INTO urbNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ahúi aja me'ẽ ngi ipirer ke amõ ombor rahã, urupen py'a pe mukatak. Ywate ombor. Aja ixurer ke ombor. Pe, ixurer matyr rahã, upa katu te tata pe ombor ta. Upa ukwái ta. Pe, ahúi aja me'ẽ ke matyriha renda pe matyr ta. Aja riki awa ta ke tĩ. Tupã rehe ipy'a ym ame'ẽ ta ke Tupã mupyrara tate. Tata keruhũ renda pe mupyrara hũ ta. (Ixurer ke ukwái ta, ame'ẽja saka.) Tupã rehe ipy'a katu ame'ẽ ta jõ ixoty a'e mujy'ar ta. Inamõ ixo ta — aja Juã pandu. (“Tupã'ã namõ mujahuk ta” aja pandu rahã: “Tupã'ã ke muwyr ta” aja mujekwa. “Tata namõ mujahuk ta” aja pandu rahã: “Mupyrara ta” aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jondã y rake Juã ixo rĩ. Arahã Jesu uhyk oho ehe. Ngariréi ywy ngi Jesu uhyk uwyr ehe. Pandu: —Ihẽ ke emujahuk — aja Juã pe. ");
INSERT INTO urbNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","—Anĩ. Ihẽ ke nde riki eremujahuk ta me'ẽ te'e. Nde ke ihẽ amujahuk, anĩ riki — aja Juã pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pe, Jesu pandu ipe: —Anĩ. Katu riki. Ihẽ ke emujahuk! Aja rahã, Tupã putar ame'ẽ ke jama'e ta — aja. Juã pandu ipe: —Hã — aja. (Pe, Jesu ke mujahuk.) ");
INSERT INTO urbNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Upa Juã mujahuk rahã, pahar y ngi Jesu uhem oho. Pe, ywa riki pirar, ame'ẽja saka Juã usak. Tupã'ã wyjy uwyr ehe ame'ẽ ke rehe a'e usak. Pykahuran aja saka Jesu rehe wyjy uwyr. ");
INSERT INTO urbNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pe, ywa ngi panduha uwyr: —Peme'ẽ ihẽ ra'yr. Ihẽ apy'a katu ehe ame'ẽ ke a'e. Ihẽ ke a'e muhury katu — aja Jesu rehe har pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ajame'ẽ ke awa nixói te ame'ẽ pe Jesu ke Tupã'ã muhyk raho. Ma'e ka'u te'eha ke Jesu ma'e, ame'ẽ ke Satana putar tipe. (Ãjã ramũi a'e.) Ame'ẽ ke a'e manga manga tipe. ");
INSERT INTO urbNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mokõi awa pypa hetaha (40) wera rahã, ma'e ke Jesu u'u ym te. A'erehe myjahy te hũ. ");
INSERT INTO urbNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pe, Satana uhyk ehe. Pandu ipe: —Tupã ra'yr nde. Kome'ẽ ita ra'yr ta pe kuja epandu: “Mbeju wan ewak. A'u ta” aja ita ra'yr ta pe — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesu pandu: —Anĩ. Ita ke mbeju wan amuruwak ym ta. Kuja Tupã je'ẽha rehe panduha ihĩ tĩ: “Marã ka ym humi'u namõ jõ amõ ixo katuha. Tupã pandu ame'ẽ ke namõ amõ ixo katu ta tĩ” aja riki panduha ihĩ — aja Satana pe. ");
INSERT INTO urbNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","A'engi Jerusarẽ ok ta pe Jesu ke Satana raho. Ok ta katu te ame'ẽ ke aja ngã ukwa. A'ep uhyk rahã, Tupã rehe ngã jumu'eha renda keruhũ kupe 'ar pe raho. (Ame'ẽ renda kupe ipe katu.) Ywatehar te ame'ẽ pe raho. Ame'ẽ renda kupe rymy'y rehe muhyk raho. ");
INSERT INTO urbNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Pe, pandu ipe: —Tupã ra'yr nde. Sengi epor eho. Ywy rehe e'ar ekwa rahã, ahy ym ta nde pe. Kuja Tupã je'ẽha rehe panduha ihĩ: “Ima'e je'ẽha rahoha ta pe Tupã pandu ta: ‘Pepyhyk peho!’ aja riki. Aja rahã, nde po rehe a'eta pyhyk ta. Aja rahã, nde py ke ita rehe nde eretukwa ym ta. Nde eremahy ym ta tĩ.” Aja panduha ihĩ. (A'erehe sengi nde erepor rahã, ahy ym ta nde pe) — aja Satana pandu ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Pe, Jesu pandu: —Anĩ. Apor ym ta. Kuja Tupã je'ẽha rehe panduha ihĩ tĩ: “Tupã riki jandema'e sawa'e te. Ima'e katuha ke mã peja te'e emanga ym” aja panduha ihĩ — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","A'engi ywy'ã keruhũ 'ar pe Jesu ke Satana muhyk raho. Kome'ẽ ywy keruhũ rupi heta te hũ kapitã keruhũ ta ixo. Amõ amõ ywy pe ixo. Upa katu te ame'ẽ ke pahar Jesu pe Satana mujesak. Usak rahã, katu te hũ, aja ukwa. ");
INSERT INTO urbNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Pe, a'e pandu: —Ihẽ rehe nde py'a nde eremoĩ moĩ katu rahã, upa katu te jasak ramõ ame'ẽ ke nde pe ihẽ amuwyr ta. Nde rehe upa ame'ẽ ta hendu katu ta — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pe, Jesu pandu: —Anĩ. Aja ym ta ihẽ. (Nde rehe ihẽ py'a amoĩ moĩ ym te ta.) Kuja Tupã je'ẽha rehe panduha ihĩ: “Tupã rehe jõ nde py'a nde eremoĩ moĩ katu. A'e riki sawa'e te. A'e ke rehe jõ ehendu katu” aja panduha ihĩ. —A'erehe ihẽ ngi eho! Nde rehe ihẽ ahendu ym te ta — aja Satana pe. ");
INSERT INTO urbNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","A'erehe Satana oho ingi. Pe, Tupã je'ẽha rahoha ta wyjy uwyr ehe, Jesu rehe. Usak katu uwyr ehe. ");
INSERT INTO urbNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kyndaha pe Juã ke amõ ta kynda raho. Arahã Ero kapitã a'e. (Ngariréi ywy pe har tama'e kapitã a'e.) Juã pandu ipe: “Nema'e ma'eha katu ym” aja ipe. A'erehe kyndaha pe Juã ke Ero kynda. “Juã ke kapitã kynda.” Ame'ẽ ke Jesu pe amõ ta pandu oho. Ame'ẽ ke rehe hendu rahã, amõ ywy pe Jesu oho. Ngariréi ywy pe oho. ");
INSERT INTO urbNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ame'ẽ ywy rehe Nasare ok ta ihĩ. A'ep Jesu pyta tar ym. A'erehe Kapana'ũ ok ta pe a'e pyta oho. Ypa rake ame'ẽ ok ta ihĩ. Ypa rer Ngariréi. Ame'ẽ ok ta wajar Semurõ ywy rake ihĩ. Wajar Natari ywy rake ihĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kapana'ũ ok ta pe Jesu pyta rahã, yman Isai mupinim ame'ẽ ke uhyk. Ymanihar Tupã je'ẽha pandu ame'ẽ ke Isai. Kuja a'e mupinim: ");
INSERT INTO urbNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Weraha keruhũ rehe Semurõ ywy pe har ta usak ta. (Aja rahã, Tupã rehe har ukwa ta.) Natari ywy pe har ta aja tĩ. Weraha keruhũ rehe usak ta tĩ. Ngariréi ywy pe har ta aja tĩ. Weraha keruhũ rehe usak ta tĩ. (Aja rahã, ame'ẽ pe har ta Tupã rehe har ukwa ta tĩ.) Jundéu awa aja ym ame'ẽ ta ixo a'ep. Tupã rehe har a'eta ukwa ta tĩ. Y ruwái, Jondã ruwái koty ame'ẽ ywy ta ihĩ. Ame'ẽ rupi awa rape asa oho. Y ramũi koty awa rape oho ixo. Upa ame'ẽ ywy pe har ta ukwa ym ma'e. Tupã rehe har ukwa ym te, aja ixo ame'ẽ ta ke a'eta. Apo upa ame'ẽ ta pe Tupã rehe har amõ mujekwa ta. Ipy'a upak aja saka wera katu te hũ ta” aja Isai mupinim. (A'ep Tupã rehe har Jesu mu'e, a'erehe Tupã rehe har ukwa katu ta.) ");
INSERT INTO urbNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kapana'ũ ok ta pe oho. A'engi kuja Jesu pandu: —Tupã mu'am ame'ẽ ke a'e muwyr. Kapitã keruhũ aja mu'am ame'ẽ ke. A'erehe peka'u te'eha pema'ema'eha ke pehijar. Ixoty pehẽ py'a pemuruwak. Aja rahã, ehe har pekwa katu ta — aja ngã pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ypa rymy'y rupi Jesu wata oho ixo, Ngariréi ypa rymy'y rupi. Mokõi sawa'e ta pira pyhyk ixo. Ame'ẽ ta rehe usak. Mokõi imu namõ ixo. Her Simã. “Petu” aja amõ her tĩ. Imu rer Andere. Kyhapari pe pira ke a'eta pyhyk ixo. ");
INSERT INTO urbNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","A'eta pe Jesu pandu: —Pira ke pepyhyk pexo. Apo har anĩ. Amõ kotyhar ta. Pehẽ ke ihẽ amu'e ta. A'erehe amõ ta py'a ke Tupã koty pemuruwak ta pexo kỹ. (Pira pepyhyk, ame'ẽja saka.) A'erehe ihẽ namõ peho 'y — aja mokõi sawa'e ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pe, pahar jarusu keruhũ hijar oho. Pe, Jesu namõ a'eta oho. ");
INSERT INTO urbNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","A'engi oho we rahã, amõ mokõi imu ta rehe Jesu usak. Tian rehe a'e usak, imu namõ. Imu rer Juã. Semende ra'yr ta ke ame'ẽ ta. Jarusu keruhũ pe ipái namõ kyhapari a'eta mukatu uĩ. Jesu pandu: —Ihẽ namõ peho 'y — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Pe, pahar jarusu keruhũ hijar oho. Ipái ke a'eta hijar oho tĩ. Pe, Jesu namõ mokõi imu ta oho. ");
INSERT INTO urbNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Upa Ngariréi ywy rupi Jesu wata oho. Inamõ ixo ame'ẽ ta oho tĩ. Jundéu awa tama'e jy'ariha renda pe a'e mu'e. Kuja myrandu katu ke a'e mu'e mu'e. “Ma'e peka'u te'eha pema'ema'eha ke pehijar. Tupã koty pehẽ py'a pemuruwak. Tupã putar aja pexoha pyahu aja pexo katu. Aja rahã: ‘Ihẽ kotyhar ta ke pehẽ’ aja a'e pandu ta” aja mu'e. Upa katu te ma'e ahy ixo ame'ẽ ta ke mukatu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Amõ ywy rupi Jesu rehe har ngã pandu pandu oho. Si ywy rupi pandu oho. A'erehe upa ma'e ahy ixo ame'ẽ ta ke ngã raho ipe. Upa ame'ẽ ta ke mukatu. Ko ipy'a rehe ãjã ihĩ ame'ẽ ta ke raho ipe. Manõ manõ ixo ame'ẽ ta ke raho ipe tĩ. Upa jupyrãtã rãtã ame'ẽ ta ke raho ipe tĩ. Upa katu te ame'ẽ ta ke mukatu. ");
INSERT INTO urbNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Heta ngã inamõ wata wata oho ixo. Heta ngariréi ywy pe har ta inamõ wata wata oho ixo tĩ. Jande popa ok ta ngi amõ ta wata wata oho ixo. Heta Jerusarẽ ok ta pe har ta inamõ wata wata oho ixo tĩ. Heta jundéi ywy pe har ta aja tĩ. Jondã y ruwái kotyhar ta aja tĩ. Inamõ wata wata oho ixo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Heta te hũ ngã rehe Jesu usak. A'erehe ywy'ã rehe jupir oho. A'ep wapyk. Ixotyhar ta juramã jy'ar tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Pe, ame'ẽ ta ke a'e mu'e. ");
INSERT INTO urbNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Pe, kuja Jesu pandu: —“Tupã rehe har jakwa ym jande” aja ukwa ame'ẽ ta mã peja hury katu ixo. Ixotyhar ta aja muruwak ta. Pe, inamõ ixo ta, a'erehe mã peja hury katu ixo. ");
INSERT INTO urbNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ma'e ka'u te'eha ke amõ ta ma'ema'e, a'erehe pyai ixo. Jixi'u tĩ. Ame'ẽ rehe har Tupã pe pandu. Aja rahã, Tupã ipy'a jywyr ta a'eta rehe. A'erehe mã peja hury katu ixo. ");
INSERT INTO urbNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Jande katu te jande” aja ym pandu ame'ẽ ta mã peja hury katu ixo. Ma'e ke Tupã pandu katu, ame'ẽ ke a'eta pe a'e muwyr ta. Katu ame'ẽ ke muwyr ta. ");
INSERT INTO urbNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Amõ myahy rahã, ma'e ke u'u ta. Jyngwéi rahã, y ke u'u ta tĩ. Aja Tupã putar ame'ẽ ke amõ ma'e tar katu te rahã, ame'ẽ ta riki hury katu te ame'ẽ ta ke a'eta. Upa ame'ẽ ta putar ame'ẽ ke Tupã muwyr katu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Amõ ta rehe amõ ta pyrara usak rahã, ame'ẽ riki hury katu ame'ẽ ta ke a'eta. Ame'ẽ ta rehe Tupã pyrara usak katu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ipy'a juhyk, aja ixo ame'ẽ ta riki hury katu ame'ẽ ta ke a'eta. Tupã namõ a'eta ixo ta. ");
INSERT INTO urbNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Jumaiha ke mukatu ame'ẽ ta riki hury katu ame'ẽ ta ke a'eta. Ame'ẽ ta pe Tupã pandu ta: “Pehẽ riki ihẽ ra'yr ta” aja riki. A'erehe ame'ẽ ta rehe a'e usak katu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tupã putar ame'ẽ ke amõ ta ma'ema'e rahã, ame'ẽ ta ke amõ ta mupyrara. Aja rahã, ame'ẽ ta riki hury katu ame'ẽ ta ke a'eta. Tupã kotyhar ta ke a'eta aja mujekwa. A'erehe ma'e katu ame'ẽ ke Tupã muwyr ta a'eta pe. ");
INSERT INTO urbNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","—Ihẽ kotyhar ta ke pehẽ. A'erehe pehẽ rehe har amõ ta juru ai. Mupyrara ta tĩ. Pehẽ rehe har te'e pandu tĩ. Upa aja rahã, pehẽ rury katu pexo. Ywa pe ma'e katu ame'ẽ ke pehẽ pe Tupã me'ẽ ta, a'erehe mã peja pehẽ rury katu pexo apo. Pesarahã! Yman Tupã je'ẽha pandu ame'ẽ ta ke amõ ta mupyrara hũ tĩ. Se pehẽ nixói rahã, ame'ẽ ymanihar ta ke amõ ta mupyrara hũ. A'erehe ame'ẽ ymanihar ta aja pehẽ ke ngã mupyrara ta apo tĩ. Ihẽ kotyhar ta ke pehẽ, a'erehe mupyrara ta pehẽ ke tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesu pandu tĩ: —Jukyr riki ma'e ke muhe'ẽ katu. Pe, jukyr ngi he'ẽha kanim rahã, marã ka ym he'ẽha amõ mujywyr ehe. Jaxer riki. Ombor riki awa. Pe, amõ pyrũ ehe. A'erehe jukyr katu aja katu pexo. “Pehẽ katu” aja Tupã ukwa. Pe, katuha ke pehijar rahã, jaxer riki pehẽ. Tupã rehe ipy'a ym ame'ẽ ta aja pejumuruwak tĩ. Katu ym aja. ");
INSERT INTO urbNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Tupã rehe har pemujekwa amõ ta pe, a'erehe kome'ẽ ywy keruhũ pe ma'e muweraha aja saka pehẽ. —Ywy'ã keruhũ 'ar pe ok ta ihĩ rahã, upa ngã usak katu ehe. Aja saka pehẽ. Tupã kotyhar ta ke pehẽ. A'erehe katu ame'ẽ ke pema'ema'e, ame'ẽ ke rehe upa amõ ta usak katu. ");
INSERT INTO urbNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","—Araparin ke amõ muwera rahã, kúi wyr pe jupyk ym. Ywate henda 'ar pe amõ moĩ. Aja rahã, muwera katu, pe, usak katu ma'e ke amõ. ");
INSERT INTO urbNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Aja weraha aja saka pehẽ tĩ. Aja rahã, katu ame'ẽ ke jõ pema'ema'e, ame'ẽ ke ngã pe pemujekwa. Ame'ẽ ke rehe a'eta usak rahã, jande pái keruhũ pe a'eta pandu ta: “Ne jõ riki katu te me'ẽ ke” aja. A'e riki ywatehar ke — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ngã pe Jesu pandu tĩ: —Moise je'ẽha ke ihẽ amukanim ajur, aja pekwaha naĩ. Anĩ. Amukanim ym ta. Ymanihar Tupã je'ẽha pandu ame'ẽ ta mu'e ame'ẽ ke ihẽ amukanim ajur tĩ, aja pekwaha naĩ tĩ. Anĩ. Upa ame'ẽ ke amukanim ym ta tĩ. Upa ame'ẽ mu'e ame'ẽ ke ihẽ amuhyk katu te ta kỹ. ");
INSERT INTO urbNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Moise je'ẽha mu'e ame'ẽ ke mukanim ym te ta awa. Ywa pehĩ rahã, marã ka ym amõ mukanĩha. Upa katu te ame'ẽ mu'e ame'ẽ ke amõ hendu katu ta me'ẽ te'e. Kome'ẽ ywy keruhũ kohĩ rahã, aja tĩ. Marã ka ym Moise je'ẽha mu'e ame'ẽ ke amõ mukanĩha. 'Ar rehe angaha uhyk rahã, Moise je'ẽha upa ta. ");
INSERT INTO urbNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Arahã Tupã namõ jaxo ta, a'erehe arahã Moise je'ẽha upa. A'erehe ihẽ apandu pehẽ pe. Amõ riki Moise je'ẽha rehe hendu katu. Ame'ẽ riki katu te ame'ẽ ke a'e. Amõ ta ke mu'e: “Pehendu katu ehe tĩ” aja. Ame'ẽ riki katu te tĩ. Tupã ixo ame'ẽ pe ixo ta rahã, a'e riki katu te aja Tupã mujekwa ta. —Amõ ta anĩ. Upa katu te Moise je'ẽha rehe amõ hendu ym. Pe, amõ ta pe pandu: “Pehendu ym ehe tĩ” aja mu'e. Ame'ẽ riki Tupã renda rehe ta'yr te mi katu ame'ẽ ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Myja katu ame'ẽ ke amõ ma'ema'e my? Ame'ẽ ke Moise je'ẽha mu'e. Ame'ẽ ke amõ ma'ema'e. Aja rahã: “Pehẽ katu” aja sawa'e ta pandu. Ame'ẽ ke a'eta putar. Parise ta aja tĩ. Katu ame'ẽ ke ma'ema'e tĩ. Aja rahã: “Pehẽ katu” aja sawa'e ta pandu. Ame'ẽ ke putar katu tĩ. —Pehẽ anĩ. Tupã putar aja katu ame'ẽ ke pema'ema'e rahã jõ, Tupã ixo ame'ẽ pe peho katu ta. Aja Tupã putar ame'ẽ ke pema'ema'e rahã: “Pehẽ katu” aja Tupã pandu. Ame'ẽ ke peputar katu. A'erehe katu ame'ẽ ke pema'ema'e katu — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","(Ma'e ke amõ ipy'a pe ukwa ukwa ixo, ame'ẽ ke amõ ma'e te, aja Jesu mujekwa.) A'erehe a'e pandu tĩ: —Ymanihar panduha ke pekwa. Kuja riki. “Amõ ke ejukwa ym. Amõ ke jukwa rahã, ame'ẽ ke amõ ta mupyrara ta tĩ” aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Apo amõ kotyhar. Apo pehẽ pe ihẽ apandu: “Amõ rehe amõ parahy rahã, ame'ẽ ke a'e jukwa” ame'ẽja saka. Aja rahã, ame'ẽ ke amõ ta mupyrara ta tĩ. Pe, amõ pe amõ pandu: “Katu ym nde” aja. Aja pandu rahã, ame'ẽ ke kapitã ta mupyrara ta. Pe, amõ pe amõ pandu: “Jaxer ai te'e nde” aja. Aja rahã, ame'ẽ ke tata keruhũ renda pe Tupã mupyrara ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","A'erehe kuja katu. Tupã rehe nde py'a nde eremoĩ moĩ rahã, ma'e ke Tupã pe nde ereme'ẽ. Ame'ẽ ke jumu'eha renda keruhũma'e myrape 'ar pe nde erehapy ta. Upa ukwái ta. Ame'ẽ ke nde erehapy tate rahã, kuja nde erekwa ere'am: “Éi! Ihẽ rehe amõ parahy. Aharái riki” aja. Aja rahã, ame'ẽ ne rymba nde erehapy ame'ẽ ke ehijar py. Myrape ruwa koty emapyk, pe, parahy ame'ẽ koty eho. Pahar eho. Pe, emukatu. Upa rahã jõ jumu'eha renda keruhũ pe ejywyr eho. Pe, ma'e ke Tupã pe hapy katu. Aja nde py'a emoĩ moĩ katu ehe, Tupã rehe. (Aja rahã jõ nde rehe Tupã ipy'a jywyr katu ta tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nde pe amõ pandu: “Tamatarer ke ihẽ pe nde emujywyr ym. Kapitã pe nde ke ihẽ araho ta” aja. Aja nde pe pandu rahã, kapitã koty inamõ nde ereho erexo rahã, pahar inamõ pangariha ke emukatu. Kapitã rehe nde erehyk ym rahã we, pangariha ke emukatu. Tamatarer ke emujywyr ipe. Anĩ rahã, kapitã rehe nde erehyk rahã, kapitã pe nde ke ne ruwajan mondo ta. A'engi sonda ta pe nde ke kapitã mondo ta. A'engi kyndaha pe nde ke sonda ta kynda ta raho. ");
INSERT INTO urbNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Apandu katu nde pe. A'ep nde erepyta katu ta. Marã ka ym nde erehemiha ingi. Upa katu te tamatarer ke nde eremujywyr ym rahã, marã ka ym nde erehemiha. A'erehe kapitã rehe uhyk ym rahã we, emukatu — aja Jesu pandu. (A'erehe amõ ta namõ katu aja pexo. Aja Tupã namõ katu aja pexo tĩ. Aja rahã, mupyraraha renda pe peho ym ta tĩ. Kyndaha ngi uhem ym, ame'ẽja saka ame'ẽ.) ");
INSERT INTO urbNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","(Ma'e ke amõ ipy'a pe ukwa ukwa ixo rahã, ame'ẽ ke ma'e te, aja Jesu mujekwa tĩ.) A'erehe a'e pandu tĩ: —Yman pandu ame'ẽ ke rehe pehendu. Kuja riki. “Amõ sawa'e rehe eka'u te'e ym. Amõ kũjã rehe eka'u te'e ym tĩ” aja. ");
INSERT INTO urbNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Apo amõ kotyhar. Apo pehẽ pe ihẽ apandu katu. Kũjã rehe amõ usak, pe, ipy'a pe ka'u te'e ehe. Aja rahã, amõ kũjã namõ jumusarái aja tĩ. Katu ym aja. ");
INSERT INTO urbNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","A'erehe kũjã rehe nde eresak, pe, a'engi ma'e nde ereka'u te'eha ke nde erema'e rahã, katu ym. Esak ym. Nde reha ejo'ok, pe, ame'ẽ ke embor, ame'ẽja saka. Esak ym. Nde eresak, pe, nde ereka'u te'eha ke nde erema'e, a'erehe mupyraraha renda pe nde ke Tupã ombor ta. Nde reha nde erembor, ame'ẽja saka esak ym. Ema'e ym ma'e nde ereka'u te'eha ke. Ame'ẽ riki i'ar koty te we katuha. ");
INSERT INTO urbNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","—Nde po pe te'e ma'e ke nde erema'e. Aja ma'e nde ereka'u te'eha ke nde erema'e rahã, nde po pe ema'e ym. Nde po emondok, pe, ame'ẽ ke embor, ame'ẽja saka. Nde po pe ma'e nde ereka'u te'eha ke nde erema'e, a'erehe mupyraraha renda pe nde ke Tupã ombor ta rahã, katu ym. Nde po embor, ame'ẽja saka exo. Ema'e ym ma'e nde ereka'u te'eha ke. Ame'ẽ riki i'ar koty te we katuha — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","(Te'e hakehar ke sawa'e hijar rahã, katu ym. Aja Jesu mu'e tar katu.) A'erehe kuja a'e pandu: —Yman kuja panduha ihĩ tĩ: “Hakehar ke sawa'e hijar rahã, paper rehe a'e mupinim: ‘Nde ke ihẽ aputar ym apo. Ahijar ta nde ke apo’ aja. Ame'ẽ ke hakehar pe me'ẽ. Pe, hijar” aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Apo amõ kotyhar. Apo pehẽ pe ihẽ apandu katu. Hakehar riki ka'u te'e ym amõ rehe. Ame'ẽ ke ixawa'e hijar rahã, katu ym ixawa'e ma'eha. Pe, ame'ẽ kũjã ke amõ sawa'e pyhyk rahã, ixawa'e aja ym ame'ẽ namõ kũjã jumusarái. Katu ym aja. Pe, ame'ẽ sawa'e riki hakehar aja ym ame'ẽ namõ jumusarái tĩ. Katu ym aja. Ixawa'e py katu ym ame'ẽ ke ma'e — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","(Ma'e ke amõ pandu rahã, ame'ẽ ke ma'e ta me'ẽ te'e. Aja Jesu mu'e tar katu.) A'erehe a'e pandu tĩ: —Yman amõ ta pe jande ramũi ta pandu ame'ẽ ke rehe pehendu. Kuja riki: “Tupã ruwa koty aja saka nde erexo. A'erehe ma'e ke nde erepandu ame'ẽ ke ema'e katu. Ame'ẽ panduha emukanim ym” aja pehendu. ");
INSERT INTO urbNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Apo amõ kotyhar ihẽ apandu. “Ma'e ke nde erepandu ame'ẽ ke nde erema'e katu. Ame'ẽ jõ. Ma'e ruwa koty aja saka nde erexo, aja ym ekwa exo.” Kuja pepandu ym tĩ. “Ywa pehĩ aja pekwa katu, a'erehe jetehar te japandu” aja pepandu ym. —Pesarahã! Ywa riki Tupã renda ke. A'erehe: “Ywa pehĩ, jetehar te japandu, aja pekwa” aja pepandu ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ywy keruhũ rehe har aja tĩ. Kome'ẽ ywy keruhũ Tupãma'e ke tĩ. Ipy moĩha aja saka ipe. A'erehe: “Kome'ẽ ywy keruhũ kohĩ, a'erehe jetehar te japandu” aja pepandu ym. —Jerusarẽ ok ta aja tĩ. Sawa'e te renda ke ame'ẽ. A'erehe: “Jerusarẽ ok ta kohĩ. A'erehe jetehar te japandu, aja pekwa” aja pepandu ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","—Nde pyahu rahã, marã ka ym nde ra nde eremutuwyriha. Marã ka ym nde eremutamũiha. Nde tamũi rahã, marã ka ym nde ra nde eremupihũha. Marã ka ym nde eremupyahuha. A'erehe kuja epandu ym: “Ihẽ ãkã kohĩ aja pekwa katu. A'erehe jetehar te apandu, aja pekwa tĩ” aja epandu ym. ");
INSERT INTO urbNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","—Kuja jõ epandu katu: “Jetehar te ke apandu. Ihẽ ama'e katu ta” aja. Anĩ rahã: “Anĩ. Ihẽ ama'e ym ta” aja jõ katu. Kuja amõ we nde erepandu: “Jetehar te ihẽ apandu ym rahã, ihẽ ke Tupã mupyrara ta” aja nde erepandu rahã, ame'ẽ riki Satana ngi uhem, ame'ẽja saka. Katu ym aja. (A'erehe aja epandu ym. Satana riki te'e pandu ame'ẽ ke a'e. Ãjã ramũi a'e. Aja te'eha te'e pandu ame'ẽ ke a'e) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","A'e pandu tĩ: —Yman pandu ame'ẽ ke rehe pehendu. Kuja riki. “Nde reha ke amõ mupuk rahã, ima'e ke emupuk eho tĩ” aja. “Nde rãi ke amõ mupen rahã, ima'e ke emupen eho tĩ” aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Apo amõ kotyhar. Apo pehẽ pe ihẽ apandu katu. Nde ke amõ mahy rahã, aja juja katu te nde emujywyr ym te ipe. Nde ruwa ke amõ nupã rahã, aja emujywyr ym te ipe tĩ. Mã peja nde ruwa wajar ke a'e nupã tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kapitã ruwa koty nde ke amõ raho, pe, pandu: “Tamatarer mujywyr ym kome'ẽ. Ima'e kamixa ihẽ aputar” aja ipe. Pe, kapitã pandu: “Ere. Ejo'ok!” A'erehe nema'e kamixa ke jo'ok nengi. Aja rahã, amõ we eme'ẽ ipe. Nema'e xirur te'e me'ẽ ipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","—Pe, nde pe sonda pandu: “Ihẽma'e sak ke eraho ihẽ pe” aja. Aja peteĩ kiro met nde ererahoha pandu rahã, amõ we eraho. Mokõi kiro met eraho. ");
INSERT INTO urbNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ma'e ke nde pe amõ pandu: “Ihẽ pe emuwyr” aja. Aja rahã, eme'ẽ ipe. Pe, amõ pandu nde pe: “Kome'ẽ araho ta. Pahar ihẽ amujywyr ta” aja. Aja rahã, nde erepandu ipe: “Ere. Eraho” aja riki — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","A'e pandu tĩ: —Yman pandu ame'ẽ ke pekwa. Kuja riki. “Nde rehe katu ame'ẽ ta rehe nde erepy'a katu” aja. Amõ we pehẽ ramũi ta je'ẽha pekwa: “Ne ruwajan rehe eparahy exo” aja pehẽ ramũi ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Apo amõ kotyhar. Apo pehẽ pe ihẽ apandu katu. Pehẽ ruwajan ta rehe epy'a katu. Pehẽ ke mupyrara ame'ẽ ta rehe har Tupã namõ pepandu pandu katu: “Mã peja a'eta rehe esak katu” aja pepandu Tupã namõ. ");
INSERT INTO urbNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Aja rahã, pehẽ riki jande pái keruhũ ra'yr ta. A'e riki ywatehar ke a'e. —Pesarahã! Katu ame'ẽ ta rehe warahy ke a'e muwera katu. Katu ym ame'ẽ ta rehe warahy ke a'e muwera katu tĩ. Juja katu te Tupã ma'eha. (Aja pehẽ tĩ. Upa katu te amõ ta pe katu ame'ẽ ke pema'ema'e tĩ.) Katu ame'ẽ ke amõ ma'ema'e ame'ẽ ta rehe aman ke a'e mungyr tĩ. A'erehe upa ma'eywa hury katu. Katu ym ame'ẽ ke amõ ma'ema'e ame'ẽ ta rehe aman ke a'e mungyr tĩ. Juja katu te Tupã ma'eha. (Aja pehẽ tĩ. A'erehe upa katu te amõ ta pe katu ame'ẽ ke pema'ema'e tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","—Pehẽ rehe ipy'a katu ame'ẽ ta rehe jõ pepy'a katu rahã, pehẽ pe ma'e katu ame'ẽ ke Tupã me'ẽ ym ta. Pesarahã! Jaxer ame'ẽ ta aja ma'e riki. Kapitã rehe tamatarer matyr ame'ẽ ta riki aja tĩ. Ipy'a katu ehe ame'ẽ ta rehe jõ a'eta ipy'a katu tĩ. Juja katu te mujywyr a'eta pe. ");
INSERT INTO urbNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Pehẽ rehe katu ame'ẽ ta namõ jõ pepandu rahã, marã ka ym pehẽ katuha. Tupã rehe ipy'a ym ame'ẽ ta aja tĩ. Ipy'a katu ehe ame'ẽ ta namõ a'eta pandu pandu katu tĩ. (A'erehe pehẽ ruwajan rehe pepy'a katu tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jande pái keruhũ riki katu te me'ẽ ke. Ywatehar ke a'e. A'e aja amõ rehe pepy'a katu tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","A'e pandu tĩ: —Tupã rehe pehẽ py'a pemoĩ moĩha ke rehe amõ ta usak, aja peputar. A'erehe amõ ta ruwa koty ma'e ke pema'e. Aja rahã: “Peme'ẽ katu” aja amõ ta pandu ta naĩ. Mã peja aja ym pehẽ. Amõ ta ruwa koty aja pema'e ym. Pema'e rahã, pehẽ pe ma'e katu ame'ẽ ke Tupã muwyr ym ta. Ywatehar ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","—A'erehe ima'e ym te ame'ẽ pe ma'e ke nde ereme'ẽ rahã, ma'e tyapu ym ha rupi eme'ẽ. (Amõ ta ukwa ym ha rupi eme'ẽ.) Tyapu rahã, amõ ta nde rehe usak ta, aja nde erekwa. Usak rahã: “Mã! Katu peme'ẽ sawa'e” aja nde rehe har pandu naĩ. Aja riki mokõi ukwaha ta ma'eha. Jundéu awa tama'e jy'ariha renda pe ima'e ym te ame'ẽ pe tamatarer me'ẽ. Ame'ẽ ke rehe amõ ta usak, aja a'eta putar. (Usak rahã: “Mã! Peme'ẽ katu” aja pandu naĩ.) Aja mokõi ukwaha ta putar. —Awa rape rupi wata ixo rahã, ma'e ke me'ẽ rahã, aja tĩ. A'eta rehe amõ ta usak, aja putar. Usak rahã, amõ ta pandu ta: “Mã! Sawa'e katu” aja pandu naĩ. Ame'ẽ panduha jõ riki ima'e ma'e katu ame'ẽ pyhykiha. Tupã anĩ. Ma'e ke ame'ẽ ta pe muwyr ym te. A'erehe mokõi nde erekwaha aja exo ym nde. ");
INSERT INTO urbNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ima'e ym te ame'ẽ pe ma'e ke nde ereme'ẽ rahã, amõ ta ukwa ym ha rupi eme'ẽ. Nde rehe katu ame'ẽ ukwa ym tĩ. Aja rahã, katu. ");
INSERT INTO urbNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Aja rahã, nde atu erekwa katu ta. Ima'e ym te ame'ẽ ukwa katu tĩ. Pehẽ mokõi jõ ukwa katu. Amõ ta ukwa ym ha rupi nde erema'eha ke rehe jande pái keruhũ usak ta tĩ. Pe, a'e riki nde pe ma'e katu ame'ẽ ke muwyr ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","A'e pandu tĩ: —Mokõi ukwaha ta Tupã namõ pandu pandu rahã, a'eta rehe amõ ta usak, aja a'eta putar. A'erehe jundéu awa tama'e jy'ariha renda pe Tupã namõ pandu pandu rahã, a'eta pu'am, pe Tupã namõ pandu pandu. Awa rape rupi ixo rahã, Tupã namõ pandu pandu tĩ. Aja rahã, a'eta rehe amõ ta usak, aja ukwa. A'eta rehe amõ ta usak rahã, pandu: “Mã! Sawa'e ta katu” aja naĩ. Ame'ẽ panduha jõ riki ima'e ma'e katu ame'ẽ pyhykiha. A'eta pe Tupã riki muwyr ym te ta ma'e ke. A'erehe Tupã namõ pepandu pandu rahã, mokõi pekwaha ym pehẽ. ");
INSERT INTO urbNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","—Tupã namõ nde erepandu pandu rahã, kapy pe eho. Hukwen ke ekynda. Pe, jande pái keruhũ namõ epandu pandu katu. Nde rehe usak ym awa. Pe, amõ ta ukwa ym ha rupi Tupã namõ nde erepandu pandu rahã, nde rehe jande pái keruhũ usak katu ta. Pe, ma'e katu ame'ẽ ke nde pe a'e muwyr ta. ");
INSERT INTO urbNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tupã namõ pepandu pandu rahã, amõ we amõ we aja ym pepandu pandu inamõ. Aja riki Tupã rehe ipy'a ym ame'ẽ ta pandu pandu. Ima'e tupã namõ a'eta pandu pandu rahã, i'i pandu pandu. Aja rahã, tupã hendu ta aja ukwaha naĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ame'ẽ ta aja ym pehẽ. Tupã namõ pepandu ym rahã we, upa a'e ukwa katu. Ma'e ke pehẽma'e nixói te, ame'ẽ ke a'e ukwa katu. A'erehe ame'ẽ rehe har i'i ym inamõ pepandu. ");
INSERT INTO urbNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tupã namõ pepandu rahã, kuja pepandu: Jande pái keruhũ! Ywa pe har ke nde. Nde rehe har amõ hendu rahã, mã peja pandu: “Mã katu te” aja. ");
INSERT INTO urbNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nema'e jetehar te ke rehe upa katu te awa ta hendu katu ta, ame'ẽ angaha ke rehe ihẽ aharõ hũ axo. Nde ereputar ame'ẽ ke ywa pe har ta ma'ema'e katu. Aja mã peja kome'ẽ ywy keruhũ pe har ta aja tĩ. Ma'ema'e katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kome'ẽ wera rahã, jande mi'u ke ja'u ta, ame'ẽ ke jande pe emuwyr. ");
INSERT INTO urbNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Jande pe ma'e ka'u te'eha ke amõ ta ma'e rahã, ame'ẽ ta rehe jande py'a jamujywyr ta. Aja jamujywyr jaxo rahã, jande rehe nde py'a emujywyr katu tĩ. Ma'e jaka'u te'eha ke jama'ema'e. Jande rehe nde py'a emujywyr katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma'e jaka'u te'eha ke jama'e tar katu rahã, ame'ẽ ke jande py'a ngi emukanim. Aja rahã, jama'e ym ta. Jande ke Satana manga tar katu rahã, a'e ke jande ngi emujan katu. Nde riki kapitã keruhũ te. Upa katu te ma'e ke nde eremuhendu katu nde juehe. A'erehe nde rehe hendu katu. Pyrãtã te hũ ame'ẽ ke nde. Katu te hũ ame'ẽ ke nde tĩ. Aja te'e ta nde erexo tĩ. Amen. A'e tỹ. —Upa aja Tupã namõ pepandu pandu katu. ");
INSERT INTO urbNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Pehẽ pe ma'e ka'u te'eha ke amõ ma'e rahã, pehẽ py'a pemujywyr katu ehe. Aja rahã, pehẽ rehe ipy'a ke jande pái keruhũ mujywyr ta tĩ. Ywatehar ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma'e peka'u te'eha ke pema'e. Pe, amõ ta rehe pehẽ py'a pemujywyr ym rahã, pehẽ rehe ipy'a ke jande pái keruhũ mujywyr ym ta tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","A'e pandu tĩ: —Mokõi ukwaha ta ma'e u'uha ke hijar rahã, pyai te aja ame'ẽ ta rehe amõ ta usak. U'u ym, a'erehe myahy aja amõ ta usak. A'erehe amõ ta pandu: “Mã! Huwa xi'a. U'uha hijar my. A'erehe Tupã namõ pandu pandu ixo” aja amõ ta ukwa. Ame'ẽ ta rehe amõ ta usak rahã: “A'eta katu” aja ukwaha naĩ. Ame'ẽ panduha jõ riki ima'e ma'e katu ame'ẽ pyhykiha. Tupã muwyr ym te ta ma'e ke. (A'erehe mokõi pekwaha ym pehẽ.) ");
INSERT INTO urbNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","—Tupã namõ nde erepandu pandu tar katu, a'erehe ma'e nde ere'uha ke nde erehijar rahã, y pe nde ruwa ekutuk. Nde'a emutyrõ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Aja rahã, nde ere'uha ke nde erehijar, aja amõ ta ukwa ym. Tupã namõ nde erepandu pandu aja amõ ta ukwa ym tĩ. Jande pái keruhũ jõ ukwa katu ta. Usak ym ehe awa ame'ẽ ke a'e. Pe, amõ ta ukwa ym ha rupi nde erema'e, ame'ẽ ke rehe jande pái keruhũ ukwa. Pe, ma'e katu ame'ẽ ke nde pe a'e muwyr ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","A'e pandu tĩ: —Kome'ẽ ywy keruhũ pe pexo rahã, heta ym pehẽma'e ke pematyr. Aja ima'ehũ ame'ẽ ta matyr. A'eta ta aja ym pehẽ. Se tarawe mujaxer ta ma'e ke. Puxi hũ tĩ. Pehẽ rok pe ma'e mukanĩha ixe tĩ. Pe, upa mukanim raho. A'erehe heta ym pehẽma'e ke pematyr. ");
INSERT INTO urbNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kuja katu. Kome'ẽ ywy keruhũ pe ma'e ke pema'e rahã, Tupãma'e ma'eha ke pema'ema'e katu. Ima'e je'ẽha rehe pehendu katu. Aja rahã, ywa pe ma'e ke pematyr katu, ame'ẽja saka. Ywa pe pehẽ rury katuha pematyr, ame'ẽja saka. A'ep tarawe nixói te ta. (A'erehe ma'e ke mujaxer ym te ta.) Puxi nixói te ta tĩ. (A'erehe mujaxer ym te ta tĩ.) Mukanĩha nixói te ta tĩ. (A'erehe raho ym te ta tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pehẽma'e ke ihĩ. Ame'ẽ rehe har pehẽ py'a pe pekwa pekwa pexo. A'erehe ywa pe pehẽma'e ke ihĩ rahã, a'ep pehẽ py'a ihĩ ta tĩ, ame'ẽja saka. Aja rahã, myja Tupã ke pemuhury katu ta my? Ame'ẽ rehe har pekwa pekwa ta pexo — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","A'e pandu tĩ: —Awa reha riki ma'e muweraha aja saka. (Aja rahã, Tupã rehe har ukwa katu, a'erehe ixoha katu aja ixo ta. Ma'e katu ame'ẽ ke ma'e ta tĩ.) A'erehe pehẽ reha katu rahã, pehẽ rete rupi wera katu, ame'ẽja saka. ");
INSERT INTO urbNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pehẽ reha katu ym rahã, weraha nixói, ame'ẽja saka. (Aja rahã, Tupã putar, aja ym pexo. Ma'e katu ame'ẽ ke pema'e ym ta tĩ.) Pe, weraha uwe rahã, pytun aja saka. Aja rahã, mãte hũ pytun. (Aja rahã, ma'e peka'u te'eha ke pema'ema'e. Katu ym aja) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","A'e pandu tĩ: —Marã ka ym mokõi ijar pe te'e paraky ame'ẽ paraky katuha. Mokõi jar pe paraky rahã, peteĩhar rehe jõ ipy'a katu ta. Amõ rehe anĩ ta. Peteĩhar jar je'ẽha rehe hendu katu ta. Amõ jar je'ẽha rehe anĩ ta. Hendu ym ta ehe. (Aja saka Tupã rehe tĩ.) Tamatarer ke rehe jõ ipy'a ke amõ moĩ moĩ rahã, marã ka ym Tupã rehe ipy'a katuha. (Mokõi jar aja saka tĩ.) Upa pyrãtãha namõ tamatarer ke matyr tar katu te hũ ixo. Aja rahã, marã ka ym Tupã putar ame'ẽ ke amõ ma'eha tĩ. (Mokõi jar aja saka tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","—Pehẽ mi'u rehe har pejumupyai ym pexo. “Ma'e ja'u ta my? Nixói ma'e. Jandema'e mundeha nixói. Awa me'ẽ ta jande pe my?” aja pejumupyai ym. Ixoha namõ amõ ixo rahã, ame'ẽ riki humi'u 'ar koty te we katuha. Awa rete aja tĩ. Awama'e mundeha 'ar koty te we katuha tĩ. A'erehe pehẽ mi'u rehe har pekwa pekwa ym pexo. ");
INSERT INTO urbNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","—Ma'ewyra ta wewe ixo, ame'ẽ rehe pesarahã! Ma'e ra'ĩ ke ame'ẽ ta jytym ym. Ma'eywa matyr ym tĩ. Matyriha renda pe mupyta ym tĩ. Ame'ẽ ta rehe jande pái keruhũ usak katu. Ame'ẽ ta rehe ipy'a katu tĩ. —Pesarahã! Ma'ewyra ta 'ar koty te we pehẽ rehe jande pái keruhũ ipy'a katuha. (A'erehe pehẽ rehe Tupã usak katu ta tĩ, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Myja hetaha warahy 'ar rahã, ko pehẽ pexo ta my” aja pekwa pekwa pexo rahã, yman rahã pexo te we ta rĩ, aja pekwaha naĩ. Anĩ. Marã ka ym pexoha pemupyta te we ta rĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","—“Ma'e jande jamunde ta my?” aja pejumupyai ym pexo tĩ. Ka'a rupi ma'eputyr ihĩ. Ame'ẽ rehe pesarahã! Paraky ym riki. Ima'e mundeha ke mujã ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Katukwer aja amõ usak. Ko ihẽ apandu pehẽ pe. Ymanihar Saromã riki ima'ehũ namõ ixo. Ima'e mundeha katukwer. Apandu pehẽ pe. Peme'ẽ ma'eputyr katu te ha riki Saromãma'e mundeha 'ar koty te we katu te ha. ");
INSERT INTO urbNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tupã riki kupi'i ke mujã. Katukwer aja mujã. Apo pehĩ. Koĩ tata renda pe amõ hapy. Kupi'i rehe Tupã usak katu. Ame'ẽ ta 'ar koty te we pehẽ rehe Tupã ipy'a katu. Aja rahã, i'ar koty te we pehẽma'e mundeha ke pehẽ pe a'e muwyr ta. Mã! Tupã rehe pejurujar katu ta me'ẽ te'e. ");
INSERT INTO urbNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","A'erehe kuja ym pepandu: “Ma'e ihẽ a'u ta my? Myja me'ẽ ihẽma'e mundeha ke ihẽ ajo'ok ta my?” Aja ym pekwa pekwa pexo. Ame'ẽ ke Tupã muwyr ta pehẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ame'ẽ rehe har jõ Tupã rehe ipy'a ym ame'ẽ ta ukwa ukwa ixo. Aja te'eha ukwa ukwa ixo. Mã peja aja ym pehẽ. Upa pehẽma'e ke nixói, ame'ẽ ke jande pái keruhũ ukwa katu. A'erehe pehẽ atu pekwa pekwa ym pexo. Pehẽ pe a'e muwyr ta. A'e riki ywatehar ke. ");
INSERT INTO urbNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kuja katu pehẽ pe. Myja Tupã putar ame'ẽ ke pema'ema'e katu ta my? Ame'ẽ rehe har pekwa pekwa py pexo. Myja ija katu ame'ẽ ke pema'ema'e ta my tĩ? Ame'ẽ rehe har pekwa pekwa py pexo tĩ. Aja rahã, upa pehẽma'e ke nixói ame'ẽ ke a'e muwyr ta pehẽ pe. Pehẽma'e mundeha rehe har aja tĩ. Pekwa pekwa ym tĩ. A'e muwyr ta. ");
INSERT INTO urbNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","A'erehe koĩ har rehe har pekwa pekwa ym pexo. “Koĩ myja me'ẽ ta my?” aja pekwa pekwa ym pexo. Apo kome'ẽ weraha rehe jõ pesak katu. Koĩ har rehe har anĩ. Ame'ẽ rehe har pekwa pekwa ym pexo — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","A'e pandu tĩ: —Amõ ta rehe har kuja ym pepandu: “Peme'ẽ ta katu ym” aja. Aja pepandu rahã, aja juja katu te pehẽ rehe har Tupã pandu ta tĩ. A'erehe aja ym pepandu. Myja me'ẽ amõ ta rehe har pepandu, aja juja katu te pehẽ rehe har Tupã pandu ta tĩ. Myja me'ẽ amõ ta pe ma'e ke pema'e, aja juja katu te pehẽ pe Tupã ma'e ta tĩ — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","(Ma'e ka'u te'eha ke amõ ma'ema'e, ame'ẽ riki myra kurer aja saka, aja Jesu mujekwa.) A'erehe kuja a'e pandu: —Ne mu reha ke myra kurer mupuk, ame'ẽ rehe nde eresak. (Aja rahã, ta'yr mi ma'e ka'u te'eha ke a'e ma'e, aja mujekwa.) Mã peja ame'ẽ rehe har ekwa ekwa ym exo. Nde reha rehe myra keruhũ mupuk riki. (Aja rahã, mãte hũ nde ereka'u te'eha ke nde erema'ema'e, aja mujekwa.) Mã peja ame'ẽ rehe har ekwa ekwa py exo. ");
INSERT INTO urbNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nde reha rehe myra keruhũ ihĩ, ame'ẽja saka. A'erehe kuja ym nde mu pe epandu: “Nde reha ngi myra kurer ke ihẽ ajo'ok ta” aja epandu ym. (Aja rahã, kuja riki: “Ta'yr mi ma'e nde ereka'u te'eha ke nde erema'e. Ame'ẽ ke mã peja ehijar” aja nde erepandu.) Mã! Nde eresak ym my? Nde reha rehe myra keruhũ ihĩ. (Aja rahã, mãte hũ ma'e nde ereka'u te'eha ke nde atu erema'ema'e, aja nde eremujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mã! Nde katu, aja nde erekwa nde jupe. Anĩ. Mokõi erekwaha namõ erexo. Nde reha ngi myra keruhũ ejujo'ok py nde jupe. (Aja rahã, mãte hũ ma'e nde ereka'u te'eha ke nde erema'ema'e, ame'ẽ ke nde erehijar katu py.) Aja rahã, upa ma'e ke nde eresak katu ta. Aja rahã, nde mu reha ngi myra kurer ta'yr mi nde erejo'ok katu ta. (Aja rahã, nde mu pe nde erepandu: “Ma'e nde ereka'u te'eha ke nde erema'e, ame'ẽ ke ehijar” aja nde erepandu katu) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","A'e pandu tĩ: —Ihẽ amu'e ame'ẽ ke katu te me'ẽ ke. Ame'ẽ ke amõ ta putar ym rahã, ame'ẽ ta pe pemujekwa ym. Hendu tipe rahã, putar ym. Jawar jarõ aja saka jumai mai ta. Je'ẽ je'ẽ hũ ta. —Ihẽ amu'e ame'ẽ ke katu te me'ẽ ke. Ame'ẽ ke amõ ta jaxer, aja ukwa rahã, ame'ẽ ta pe pepandu ym tĩ. Kure aja saka riki. Jaxer aja ukwaha, a'erehe pyrũ ehe aja saka ta. “Ihẽ amu'e ame'ẽ ke te'e” aja ame'ẽ ta ukwaha naĩ. Putar ym tĩ. (A'erehe ame'ẽ ta pe pepandu ym tĩ) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Tupã namõ pandu pandu, ame'ẽ rehe har Jesu mu'e rahã, kuja pandu: —Pehẽma'e nixói te rahã, ame'ẽ rehe har Tupã namõ pepandu pandu katu. Aja rahã, ame'ẽ ke a'e muwyr ta pehẽ pe. Tupã namõ pepandu rahã, pekekar, ame'ẽja saka. Pe, Tupã muwyr rahã, pemahem, ame'ẽja saka. (Amõ rok pe pexe tar katu rahã, pehẽ po penupã nupã. Pe, hukwen ke ijar pirar.) Tupã namõ pepandu pandu rahã, hukwen pirar ame'ẽja saka. Pirar rahã, pepandu ame'ẽ ke a'e muwyr ta pehẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Upa inamõ pandu ame'ẽ ta pe a'e muwyr ta. Amõ kekar rahã, mahem ta. Ipo nupã nupã rahã, hukwen ke a'e pirar ta. Aja saka riki. ");
INSERT INTO urbNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ipái pe ta'yr pandu: “Papa! Mbeju ihẽ aputar. A'u ta” aja. Aja rahã, ta'yr pe ita ra'yr ke ipái me'ẽ my? Anĩ. Aja ym ta. Mbeju me'ẽ ta ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Pe, ta'yr pandu: “Papa! Pira ka'ẽ ihẽ aputar. A'u ta” aja. Aja rahã, ta'yr pe mbói ke ipái me'ẽ ta my? Anĩ. Aja ym ta. Pira ka'ẽ me'ẽ ta ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Awa ta ke te'e pehẽ. Ma'e peka'u te'eha ke pema'ema'e ame'ẽ ta ke pehẽ. Pe, pehẽ ra'yr ta pe ma'e katu ame'ẽ ke peme'ẽ katu. Aja rahã, pehẽ 'ar koty te we ma'e katu ame'ẽ ke jande pái keruhũ me'ẽ ta. Ma'e ke amõ pandu ipe, ame'ẽ ke a'e muwyr ta. A'e riki ywatehar ke. ");
INSERT INTO urbNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","—Ma'e katu ame'ẽ ke pehẽ pe amõ ta ma'e, aja amõ ta pe pema'e katu tĩ. Aja riki Moise je'ẽha mu'e. Aja ymanihar Tupã je'ẽha pandu ame'ẽ ta mu'e tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","A'e pandu tĩ: —Tupã ixo ame'ẽ pe ohoha riki hukwen rupi asa oho, ame'ẽja saka. Asa oho rahã, uhã te hũ aja ixo. Ame'ẽ hukwen riki ta'yr mi. Ame'ẽ hape aja tĩ. Ta'yr mi tĩ. Ame'ẽ hape ohoha riki janam, ame'ẽja saka. Marã ka ym ohoha, ame'ẽja saka. Heta ym ame'ẽ rupi oho ame'ẽ ta ke. —Mupyraraha renda pe ohoha anĩ. Hukwen riki tiha. Hape riki aja tĩ. Tiha tĩ. Ame'ẽ rape ohoha riki sorok katu hũ, ame'ẽja saka. Pe, heta te hũ ame'ẽ rupi wata oho ame'ẽ ta ke — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","A'e pandu tĩ: —Tupã je'ẽha pandu ame'ẽ ta ran rehe har mã peja pekwa katu. Arapuharan ipy'a pitu te'e aja a'eta ixo tĩ. (Aja rahã, katu ame'ẽ ta aja pehẽ koty uwyr naĩ.) A'engi ma'e so'o jarõ aja a'eta rehe har amõ ukwa. Ma'e ke jukwa, ame'ẽja saka. (Aja rahã, pehẽ pexoha ke mujaxer ta. Pe, pehẽma'e ke te'e raho tar katu tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Myja ame'ẽ ta rehe har pekwa ta my? Kuja. Ima'e ma'eha namõ pekwa ta. Juruwe'y ngi akaju ke amõ po'ok ym. Ju'y ngi ama'yrary po'ok ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ma'eywa'y riki katu rahã, i'a katu. Aja amõ katu rahã, ima'e ma'eha katu tĩ. Ma'eywa'y katu ym rahã, anĩ. I'a ym. Aja amõ katu ym rahã, ima'e ma'eha katu ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ma'eywa'y riki katu rahã, marã ka ym i'a ym ha. I'a katu ta. Ma'eywa'y katu ym rahã, marã ka ym i'a katuha. I'a ym ta. ");
INSERT INTO urbNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ma'eywa i'a ym te rahã, jaxer rahã, ame'ẽ'y ke ijar mondok. Pe, myra ke hapy. Upa ukwái ta. Aja amõ jaxer rahã, Tupã mupyrara ta tĩ. (Myra ke hapy, ame'ẽja saka tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aja riki Tupã je'ẽha pandu ame'ẽ ta ran rehe har pekwa katu ta. Ma'eywa i'a ym aja a'eta tĩ. Aja rahã, a'eta ma'eha riki katu ym. A'erehe ame'ẽ ta rehe har pekwa katu ta. A'eta ma'eha namõ a'eta rehe har pekwa katu ta — aja Jesu mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","A'e pandu tĩ: —Amõ ta pandu: “Nde riki jandema'e sawa'e te” aja ihẽ pe pandu naĩ. Upa katu te ame'ẽ ta Tupã ixo ame'ẽ pe oho ym ta. Amõ amõ oho. Upa katu te anĩ. Ihẽ pái keruhũ putar ame'ẽ ke amõ ma'ema'e. Ame'ẽ ta jõ henda pe oho katu ta. Ihẽ pái riki ywatehar ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ngã ke Tupã mupyrara rahã, heta ihẽ pe pandu ta: “Sawa'e! Nde je'ẽha rupi Tupã je'ẽha ke japandu pandu riki. Nde je'ẽha rupi ãjã ta ke amõ ta py'a ngi jamuhem jamondo riki. Nde je'ẽha rupi marã ka ym amõ ma'eha, ame'ẽ ke nema'e pyrãtãha namõ jama'ema'e katu riki” aja ihẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pe, ame'ẽ ta pe ihẽ apandu ta: “Anĩ. Pehẽ rehe har ihẽ akwa ym te. Ihẽ kotyhar ta ym pehẽ. Ma'e peka'u te'eha ke pema'ema'e ame'ẽ ta ke pehẽ. Sengi peho. Ihẽ ngi peho” aja riki — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","A'e pandu tĩ: —Pesarahã! Ihẽ je'ẽha rehe amõ hendu katu. Pe, aja ma'ema'e rahã, ukwa katu ame'ẽ ke a'e. Kuja saka. Y rake ok ke a'e mujã. Ok pyter ke a'e jytyka katu te. Ok kangwer aja tĩ. Jytyka katu te tĩ. A'erehe katak ym te. ");
INSERT INTO urbNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pe, aman ukyr hũ. Ywytu keruhũ peju hũ tipe. Y tiha tĩ. Upa munde. Y ombor ym. Ywytu keruhũ ombor ym tĩ. Ok pyter ke jytyka katu te. Ok kangwer ke aja tĩ. Jytyka katu te tĩ. A'erehe u'ar ym ame'ẽ ok. ");
INSERT INTO urbNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","—Pe, amõ riki ihẽ je'ẽha rehe hendu tipe. Pe, aja a'e ma'ema'e ym rahã, ka'u te'e ame'ẽ ke a'e. Kuja saka. Y rake ok ke a'e mujã. Ywy ku'i 'ar pe mujã. ");
INSERT INTO urbNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pe, aman ukyr hũ. Y tiha oho. Pe, ywytu keruhũ peju hũ ok rehe. Pahar ame'ẽ ok u'ar. Tũ! Aja riki — aja Jesu mu'e. (Ok riki amõ ixoha aja saka. A'erehe Jesu je'ẽha rehe amõ hendu katu ta me'ẽ te'e. Je'ẽha mujekwa, aja ma'ema'e ta me'ẽ te'e tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Upa aja me'ẽ Jesu pandu rahã, hendu ame'ẽ ta pandu: —Mã! A'e mu'e katu! ");
INSERT INTO urbNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Moise je'ẽha mu'e, ame'ẽ ta aja ym a'e. Anĩ. Jesu pandu rahã, a'e je'ẽha te reko aja a'e mu'e — aja ukwa. ");
INSERT INTO urbNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Upa mu'e rahã, ywy'ã ngi Jesu wyjy uwyr. Arahã, heta ngã haikwer rupi wata. ");
INSERT INTO urbNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pe, pereran ma'e u'u hũ ame'ẽ ke uhyk uwyr ehe. Jesu ruwa koty ipynarãi pe wapyk oho. (Aja sawa'e katu te ame'ẽ ke kohĩ, a'erehe hendu katu ehe aja mujekwa.) Pe, pandu: —Sa'e! Nde ereputar rahã, ihẽ ke nde eremukatu ta, aja akwa katu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ijywa ke Jesu mupuku. Pe, sawa'e ãkã rehe ipo ke a'e mujar. Pandu ipe: —Ere. Nde ke ihẽ amukatu tar katu. Nde katu apo 'y — aja Jesu ipe. Pe, pereran ma'e u'u hũ ame'ẽ ke pahar upa ka'ẽ oho ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Pe, Jesu pandu ipe: —Ehendu katu. Nde ke ihẽ amukatu, ame'ẽ ke amõ ta pe epandu ym we rĩ. Pahar jundéu awa tama'e pa'i koty eho. Emujesak nde juehe har ipe. Pe, Moise mupinim, aja ma'e ke pa'i pe eme'ẽ. Ame'ẽ ke pa'i hapy ta Tupã pe. Upa ukwái ta. Aja rahã, upa nema'e pere ka'ẽ oho aja ngã pe a'e mujekwa ta — aja sawa'e pe. ");
INSERT INTO urbNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Kapana'ũ ok ta pe Jesu uhyk oho rahã, homa awa usak ehe. Sonda tama'e kapitã ke a'e. Jesu pe a'e pandu: —Sa'e! Ihẽma'e miasu ixyha pe túi. Ma'e ahy ipe. Wata ym tĩ. Emukatu ihẽ pe — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesu pandu: —Hã! Nde rok pe ihẽ amukatu ta aho — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kapitã pandu: —Anĩ. Sa'e! Ihẽ rok pe nde erexe rahã, ihẽ ruxĩ riki. Jundéu awa ym ihẽ. A'erehe eho ym. Sengi epandu: “Epu'am!” Aja rahã, ihẽma'e miasu katu ta oho. ");
INSERT INTO urbNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Akwa katu ihẽ. Ihẽma'e kapitã je'ẽha rehe ihẽ ahendu katu tĩ. Pe, ihẽ je'ẽha rehe amõ sonda ta hendu katu tĩ. Kuja. Amõ pe ihẽ apandu: “Eho!” Pe, pahar a'e oho. Amõ pe ihẽ apandu: “Ejur se!” Pe, pahar a'e uwyr tĩ. Ihẽma'e miasu pe ihẽ apandu: “Ereparaky eho!” Pe, a'e paraky katu oho tĩ. Aja ihẽ je'ẽha rehe hendu katu. A'erehe nde erepandu rahã, ihẽma'e miasu katu ta, aja akwa katu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ame'ẽ ke rehe Jesu hendu rahã: “Mã! Katu” aja a'e ukwa. Pe, haikwer rupi tur ame'ẽ ta pe a'e pandu: —Mã! Sonda tama'e kapitã jurujar katu te ihẽ rehe. Ko apandu pehẽ pe. Aja jundéu awa ta jurujar ym ihẽ rehe. Aja me'ẽ jurujar katu ame'ẽ ke ihẽ amahem ym. ");
INSERT INTO urbNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ihẽ apandu. Tupã ixo ame'ẽ pe heta ngã oho ta tĩ. Warahy uhemiha koty ngi heta oho ta. Jundéu awa aja ym ame'ẽ ta oho ta tĩ. Amarã namõ hury katu ta ixo. Isak namõ aja tĩ. Hury katu ta ixo tĩ. Jako namõ aja tĩ. Hury katu ta ixo tĩ. Aja warahy u'ariha koty ngi heta oho ta tĩ. Jundéu awa aja ym ame'ẽ ta oho ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tupã ixo ame'ẽ pe Amarã namõ jundéu awa ta ixo ta tipe. Jurujar ym riki. A'erehe oho ym. Anĩ. Mupyraraha renda pe a'eta ke Tupã ombor ta. A'ep ahy hũ ta, a'erehe jixi'u hũ ta. Tupã rehe parahy hũ tĩ, a'erehe hái ke su'u su'u hũ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pe, kapitã pe a'e pandu: —Nde jõ nde rok pe ejywyr eho 'y! Ihẽ rehe nde erejurujar katu, a'erehe nde ereputar ame'ẽ ke ihẽ ama'e ta kỹ. Ne miasu upa ihẽ amukatu riki — aja ipe. Arahã pahar kapitãma'e miasu katu oho. ");
INSERT INTO urbNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Petu rok pe Jesu uhyk oho rahã, Petu pen rehe a'e usak. Ixyha pe túi. Haku a'e. ");
INSERT INTO urbNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ipo ke Jesu pyhyk. Pahar hakuha maha oho ipe. Pe, kũjã pu'am. Pe, a'eta mi'u ke Jesu ta pe a'e me'ẽ me'ẽ. ");
INSERT INTO urbNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ame'ẽ pytun ramõ rahã, (jundéu awa tama'e putu'uha 'ar upa. A'erehe wata katu apo.) A'erehe ipy'a rehe ãjã ihĩ ame'ẽ ta ke ngã raho ipe. Heta te hũ raho ipe. Ame'ẽ ta ke Jesu mukatu. A'e pandu. —Ehem eho ingi! — aja. Aja mukatu. Upa katu te ma'e ahy ixo ame'ẽ ta ke a'e mukatu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ngã ke a'e mukatu rahã, Isai pandu aja Jesu ma'ema'e. Isai riki ymanihar Tupã je'ẽha pandu ame'ẽ ke a'e. Yman kuja a'e mupinim: “Jandema'e ahyha ke a'e jo'ok mondo. Jandema'e pyaiha ke mukanim tĩ” aja mupinim. Ame'ẽ riki Jesu ma'ema'eha. ");
INSERT INTO urbNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ixoty heta ngã jy'ar. Ame'ẽ rehe Jesu usak rahã, jumu'eha ta pe a'e pandu: —Ypa ruwái koty jahorahã! — aja. —Ere — aja jumu'eha ta. ");
INSERT INTO urbNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pe, oho tate rahã, Moise je'ẽha mu'e ame'ẽ ke Jesu rehe uhyk uwyr. Pandu ipe: —Sa'e! Ngã mu'eha nde. Ko ihẽ axo. Ne namõ ihẽ aho ta kỹ tĩ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesu pandu ipe: —Hokwar rupi ma'e so'o ukwer. Haity pe ma'ewyra ta ukwer tĩ. Ihẽ anĩ. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ akeriha renda nixói — aja ipe. (Aja rahã, inamõ oho rahã, ok nixói ta, aja mujekwa. Sawa'e jetehar te oho ta my, ame'ẽ ke Jesu manga, a'erehe aja pandu.) ");
INSERT INTO urbNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pe, amõ jumu'eha pandu: —Sa'e! Anĩ we rĩ. Ne namõ aho ym we ta rĩ. Ihẽ rok pe ajywyr we ta rĩ. Papa manõ rahã, ihẽ riki ajytym ta. Upa rahã, ne namõ ihẽ aho ta kỹ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","A'e pandu ipe: —Anĩ. Ihẽ namõ eho apo 'y! Tupã rehe ipy'a ym ame'ẽ ta manõ, ame'ẽja saka. Ame'ẽ ta riki manõ te ame'ẽ ta ke jytym ta. Nde anĩ. Ihẽ namõ eho apo 'y — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jarusu keruhũ pe Jesu opor oho. Jumu'eha ta inamõ opor oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Oho ixo rahã, pahar ywytu keruhũ ypa rupi peju uwyr. Pe, jarusu keruhũ pe y ke oho rãi. Amõ ta kyje riki. Jesu anĩ. A'e ukwer ou. ");
INSERT INTO urbNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Pe, ixoty jumu'eha ta oho. Pe, mupak. A'eta pandu ipe: —Sawa'e! Jande jamanõ tate riki. Emukatu, aja rahã, jamanõ ym ta — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesu pandu: —Mã! Pekyje ym pe'am. Tupã rehe pejurujar katu ta me'ẽ te'e — aja. Pe, a'e pu'am. Ywytu keruhũ pe a'e pandu: —Mã peja eputu'u katu ihẽ pe! — aja. Pe, ywytu keruhũ ke upa putu'u. Y kotok keruhũ pe a'e pandu tĩ: —Mã peja ewapyk katu! — aja. Pe, y kotok keruhũ ke wapyk katu. ");
INSERT INTO urbNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jumu'eha ta jupandu a'eta jupe: —Mã! Katu tiki! Pyrãtã te ame'ẽ ke kohĩ. Je'ẽha rehe ywytu keruhũ hendu katu! Y kotok keruhũ aja tĩ. Hendu katu tĩ. Mã! Myja me'ẽ sawa'e ko my? — aja a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ypa ruwái rehe Jesu uhyk oho rahã, Jera ywy pe uhyk oho. Jarusu keruhũ ngi uhem oho rahã, mokõi sawa'e ta uhyk uwyr ehe. Kangwerupa rupi har ta ke ame'ẽ ta. Itakwar rupi ixo ame'ẽ ta ke. Ame'ẽ sawa'e ta py'a rehe ãjã ta ihĩ. Parahy war ame'ẽ ta ke a'eta. A'erehe kangwerupa rape rupi wata ym awa. ");
INSERT INTO urbNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesu rehe ãjã ta usak rahã, pahar hãtã a'eta pandu: —Jesu! Nde riki Tupã ra'yr! Jande pe ema'e ym ma'e ke. 'Ar rehe angaha uhyk ym we rĩ. A'erehe jande ke emupyrara ym we rĩ — aja Jesu pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Petete kure ta i'ãi. Heta te hũ i'ãi. Kãpĩ u'u ixo. ");
INSERT INTO urbNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","A'erehe Jesu pe ãjã ta pandu: —Jande ke nde eremuhem eremondo rahã, kure ta koty jande ke emondo — aja pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ãjã ta pe Jesu pandu: —Peho! — aja. A'erehe sawa'e ta ngi ãjã ta uhem oho. Kure ta pe ixe oho. (Ka'u te'e hũ uwak.) Pe, upa katu te kure ta ujan oho. Upen te'e hũ ame'ẽ pe u'ar oho. Pe, ypa pe u'ar. Upa katu te y jukwa. ");
INSERT INTO urbNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ame'ẽ ke kure usakiha ta usak rahã, ok ta pe ujan oho. Ok ta pe har ta pe upa pandu pandu. “Kure ta upa manõ. Amõ ta py'a rehe ãjã ihĩ ame'ẽ ta ke amõ sawa'e mukatu” aja riki pandu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","A'erehe upa ok ta pe har ta usak oho. Pe, Jesu rehe usak rahã, a'eta pandu: —Jande ywy ngi eho! — aja Jesu pe. (Pyrãtã te hũ ame'ẽ ke kohĩ, aja ukwa, a'erehe kyje ingi. Amõ we a'etama'e kanim ta, aja a'eta putar ym tĩ. A'erehe: “Eho” aja Jesu pe a'eta pandu.) ");
INSERT INTO urbNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jarusu keruhũ pe Jesu opor oho tĩ. Ypa aha oho tĩ. Hekoha pe a'e jywyr oho. Kapana'ũ ok ta pe jywyr oho. ");
INSERT INTO urbNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pe, upa jupyrãtã rãtã ame'ẽ ke sawa'e ta hupir werur. Kyha aja me'ẽ ke pe a'eta werur. Amõ ke Jesu mukatu ame'ẽ rehe sawa'e ta jurujar katu. Ame'ẽ ke Jesu ukwa rahã, upa jupyrãtã rãtã ame'ẽ pe a'e pandu: —Sa'e! Nde rury katu eju. Ma'e nde ereka'u te'eha ke nde erema'ema'e. Apo nde rehe ihẽ py'a jywyr katu — aja Jesu ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ame'ẽ ke Moise je'ẽha mu'e ame'ẽ ta hendu rahã, jupandu pandu a'eta jupe: —Mã! Katu ym a'e pandu. Tupã jõ riki amõ ta pe pandu katu: “Ma'e nde ereka'u te'eha ke nde erema'e. Nde rehe ihẽ py'a jywyr” aja. A'erehe peme'ẽ riki Tupã aja jupe my. Katu ym aja — aja jupandu pandu a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ame'ẽ ipy'a pe ukwa ukwa uĩ ame'ẽ ke Jesu ukwa rahã, pandu: —Ma'e katu ym, aja pehẽ py'a pe pekwa pekwa ym peĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Myja me'ẽ riki hãtã ma'eha my? Kuja my: “Ma'e nde ereka'u te'eha ke nde erema'e. Nde rehe ihẽ py'a jywyr katu” aja apandu rahã, hãtã ma'eha my? (Ame'ẽ ke rehe usak ym awa.) Anĩ rahã, kuja my? “Epu'am! Ewata eho!” aja apandu rahã, hãtã te ma'eha my? (Ame'ẽ ke rehe usak katu awa.) ");
INSERT INTO urbNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pesarahã! Tupã jõ riki ahyha mukatu aja pekwaha. Tupã jõ riki ipy'a mujywyr katu ngã rehe aja pekwaha tĩ. Apo ihẽ tĩ. Ihẽ riki Tupã mu'am ame'ẽ ke aja ihẽ amujekwa ta apo 'y. Ihẽ pe Tupã pandu tĩ: “Ma'e ka'u te'eha ke ngã ma'ema'e. Ame'ẽ ta rehe nde py'a emujywyr katu” aja ihẽ pe. Pesarahã! Ame'ẽ ke pekwa ta apo — aja Moise je'ẽha mu'e ame'ẽ ta pe Jesu pandu. A'erehe upa jupyrãtã rãtã ame'ẽ pe a'e pandu: —Epu'am. Nde kyha aja me'ẽ ke emupu'a. Nde rok pe ejywyr eho — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sawa'e pu'am. Pe, hok pe jywyr oho. ");
INSERT INTO urbNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","(Jesu riki Tupã aja mujekwa sawa'e pe.) Ame'ẽ ke amõ ta ukwa rahã, pandu: “Mã! Katu tiki!” aja. Pe, Tupã pe a'eta pandu tĩ: —Ne jõ riki katu te me'ẽ ke. Nde riki pyrãtãha ke sawa'e ta pe nde eremuwyr katu — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","A'engi Jesu oho ixo rahã, Matéu rehe a'e usak. Homa awa tama'e kapitã keruhũ pe tamatarer ke a'e matyr matyr uĩ. Matyriha renda kapy pe a'e wapyk uĩ. Jesu pandu ipe: —Ihẽ namõ eho 'y — aja. Matéu pu'am. Upa hijar, pe, inamõ oho. ");
INSERT INTO urbNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pe, Matéu rok pe ma'e ke Jesu u'u uĩ rahã, amõ heta kapitã keruhũ pe tamatarer matyr ame'ẽ ta inamõ wapyk uĩ tĩ. Inamõ jumu'eha ta ma'e ke u'u uĩ tĩ. Amõ ka'u te'eha ke ma'ema'e ame'ẽ ta inamõ wapyk uĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ame'ẽ ke parise ta usak rahã, jumu'eha ta pe je'ẽ je'ẽ: —Ma'ewã ame'ẽ sawa'e ta jaxer ame'ẽ ta namõ Jesu u'u uĩ my? Tamatarer ke matyr ame'ẽ ta namõ aja tĩ. U'u inamõ tĩ. Katu ym aja — aja parise ta. ");
INSERT INTO urbNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","A'eta pandu ame'ẽ ke rehe Jesu hendu. A'erehe a'e pandu: —Ma'e ahy ixo rahã, mukatuha koty amõ oho. Ahy ym rahã, mukatuha koty oho ym awa. (Aja saka apo. Ma'e ka'u te'eha ke ma'ema'e ame'ẽ ta ihẽ rehe uhyk. Ipy'a juhyk. Ame'ẽ ke a'eta putar, a'erehe ihẽ rehe uhyk. Katu jupe, anĩ. Ame'ẽ ta ihẽ rehe uhyk ym.) ");
INSERT INTO urbNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pesarahã! Kuja Tupã je'ẽha rehe panduha ihĩ. Tupã pandu: “Ihẽ rehe ipy'a ke amõ moĩ moĩ rahã, ma'e hymba ke ukwái, arapuharan ra'yr ke. Ame'ẽ ke ihẽ aputar ym. Kuja katu te. Amõ ta rehe awa pyrara usak, ame'ẽ ke ihẽ aputar katu” aja panduha ihĩ. —Aja Tupã pandu ame'ẽ ke pekwa peho. (Tupã je'ẽha rehe pesak peho.) Pesarahã! Sawa'e katu aja ukwa jupe, ame'ẽ ta pe kuja ym ihẽ apandu: “Tupã koty pehẽ py'a pemuruwak pemondo” aja apandu ym. Anĩ. Ma'e ka'u te'eha ke ma'ema'e, ame'ẽ ta pe kuja ihẽ apandu katu: “Tupã koty pehẽ py'a pemuruwak pemondo” aja riki — aja parise ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juã mujahukiha namõ jumu'e ixo ame'ẽ ta Jesu pe pandu uwyr: —Jande riki ma'e ja'uha ke jahijar hijar jaxo. Amõ amõ rahã, jahijar. (Aja japyaiha ke jamujekwa Tupã pe.) Tupã namõ japandu pandu rahã aja tĩ. Ma'e ja'uha ke jahijar tĩ. Parise ta aja tĩ. Ma'e u'uha ke a'eta hijar hijar tĩ. Pe, ne namõ jumu'e ixo ame'ẽ ta aja ym. Ma'e ke a'eta u'u katu. Ma'e u'uha ke hijar ym. Ma'erehe my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","A'e pandu: —Sawa'e jumendar rahã, a'eta mi'u matyr. Huryha mujã. Pe, ame'ẽ pe oho ame'ẽ ta ma'e u'uha ke hijar ym. Sawa'e namõ ixo rahã, ma'e u'uha ke hijar ym. Pyaiha mujekwa ym. (Ihẽ namõ ihẽma'e jumu'eha ta ixo apo, a'erehe upa ma'e u'uha ke a'eta hijar ym.) Yman rahã, ihẽ ke amõ ta pyhyk ta raho a'eta ngi. Arahã ihẽma'e jumu'eha ta upa ma'e u'uha ke hijar ta. (Aja pyaiha ke mujekwa ta.) ");
INSERT INTO urbNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","—Kamixa ymanihar sorok rahã, pan jupu'a ym ame'ẽ ke amõ mujar ym ehe. Mujar ehe rahã, jupu'a we oho. Pe, kamixa ymanihar ke musak we ta. Sorok we ta oho. ");
INSERT INTO urbNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kawĩ mupupur ramõ ame'ẽ ke hyru ymanihar te pe awa purakar ym. Ame'ẽ pe purakar rahã, pupur we ixo rĩ. Pe, hyru ymanihar ke mupuk ta. Pe, upa kawĩ jyhẽ ta oho. Hyru ymanihar ke mujaxer ta tĩ. A'erehe kawĩ mupupur ramõ ame'ẽ ke hyru pyahu ame'ẽ pe awa purakar rahã, katu ta tiki. Aja rahã, kawĩ jyhẽ ym ta. Hyru ke upuk ym ta tĩ — aja Juã namõ jumu'e ixo ame'ẽ ta pe Jesu pandu. (Jesu mu'e rahã, myja ixoha katu aja mujekwa. Ixoha pyahu aja saka. A'erehe parise mu'e, aja ymanihar ixoha namõ marã ka ym muparaha, aja Jesu mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesu mu'e uĩ rahã, jundéu awa tama'e jy'ariha renda kapitã uhyk uwyr ehe. Huwa koty ipynarãi pe a'e wapyk. (Aja sawa'e katu te ame'ẽ ke kohĩ, a'erehe hendu katu ehe aja mujekwa.) Pe, pandu ipe: —Ihẽ rajyr manõ ramõ. Ihẽ rok pe ehorahã! Nde po ke iãkã rehe emujar! Aja rahã, kwera katu ta tĩ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","—Hã! Aho ta kỹ — aja pandu ipe. Pe, a'e pu'am. Inamõ oho. Inamõ jumu'e ixo ame'ẽ ta oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Oho ixo rahã, Jesu raikwer rupi amõ kũjã oho. Jai ha pupuriha namõ ixo ame'ẽ ke a'e. Awa py mokõi warahy 'ar rahã, aja te'e a'e ixo. A'e jupandu jupe: —Ima'e mundeha ke ihẽ apyhyk rahã jõ, ihẽ katu ta aho — aja kũjã jupe. A'erehe Jesuma'e mundeha apyr ke a'e pyhyk. ");
INSERT INTO urbNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Aja rahã, ixoty Jesu uwak. Pe, usak ehe rahã, pandu ipe: —Éi kũjã! Upa ma'e ahyha ke amukatu, ame'ẽ rehe nde erejurujar katu, a'erehe nde katu apo 'y. Nde rury katu eho apo 'y — aja kũjã pe. Arahã kũjã katu oho. ");
INSERT INTO urbNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jundéu awa tama'e jy'ariha rendama'e kapitã rok pe Jesu ixe oho rahã, takwar ra'yr peju ame'ẽ ta rehe a'e usak. (Aja te'eha riki jundéu awa ta. Amõ manõ rahã, takwar ra'yr ke peju. Aja pyaiha ke mujekwa.) Amõ ta mutyapu hũ ixo tĩ. (Aja pyaiha ke mujekwa tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","A'e pandu: —Kar pe upa pehem peho! Kũjãtãi manõ ym riki. Ukwer te'e ou riki — aja Jesu a'eta pe. (Kũjãtãi manõ te aja Jesu ukwa katu tĩ.) A'eta puka puka hũ ehe. Manõ te, aja ukwa katu, a'erehe puka puka hũ ehe. ");
INSERT INTO urbNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kar pe upa a'eta ke a'e mondo rahã, kũjãtãima'e kapy pe Jesu ixe oho. Ipo rehe pyhyk. Pe, kũjãtãi kwera katu. Pe, pu'am. ");
INSERT INTO urbNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ame'ẽ mukweraha rehe har amõ ta pandu pandu oho. Ame'ẽ ywy rupi amõ ta pandu pandu oho. ");
INSERT INTO urbNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","A'engi Jesu wata oho ixo rahã, mokõi sawa'e ta eha ym te ame'ẽ ta haikwer rupi oho. Hãtã a'eta pandu: —Sa'e! Ndawi rainõ ke nde! Tupã mu'am ame'ẽ ke nde. Jande rehe epyrara esak. Nema'e pyrãtãha namõ jande ke emukatu — aja. (“Tupã mu'am me'ẽ ke” aja pandu rahã: “Kapitã keruhũ” aja Tupã mu'am, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ok pe Jesu ixe oho rahã, eha ym te ame'ẽ ta uhyk uwyr ehe. A'eta pe a'e pandu: —Pehẽ ke ihẽ amukatu ame'ẽ ke ihẽ akwa katu. Ame'ẽ rehe pejurujar katu my? — aja Jesu. —A'e tỹ. Jajurujar katu — aja a'eta pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pe, a'eta reha rehe ipo ke a'e mujar. Pandu: —Ma'e ahyha ihẽ amukatu, ame'ẽ rehe pejurujar katu. Aja mã peja uhyk apo 'y — aja mokõi sawa'e ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Pe, upa ma'e ke rehe a'eta usak katu. Hãtã Jesu pandu: —Pehẽ ke ihẽ amukatu, ame'ẽ rehe har amõ ta pe pepandu ym! — aja pandu tipe. ");
INSERT INTO urbNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Anĩ. A'eta uhem oho rahã, Jesu rehe har upa ame'ẽ ywy rupi pandu pandu oho. ");
INSERT INTO urbNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Sawa'e ta uhem oho ixo rahã, sawa'e je'engai ame'ẽ ke Jesu rehe amõ ta muhyk muwyr. Sawa'e py'a rehe ãjã ihĩ, a'erehe je'engai ame'ẽ ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ãjã ke Jesu muhem mondo rahã, sawa'e rembe katak katu tĩ. Pandu pandu u'am tĩ. Pe, upa amõ ta pandu: —Mã! Katu tiki! Jundéu awa tama'e ywy rupi aja me'ẽ jasak ramõ te — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pe, parise ta pandu: —Ãjã tama'e kapitã riki pyrãtãha ke muwyr ipe. A'erehe ãjã ta ke a'e muhem mondo — aja pandu naĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Upa ok ta rupi Jesu ohoho. Upa ok ta hũ rupi a'e oho tĩ. Amõ amõ rupi wata oho. Jundéu awa tama'e jy'ariha renda pe mu'emu'e oho. Kuja myrandu katu ke a'e mu'emu'e. “Ma'e peka'u te'eha ke pehijar. Tupã koty pehẽ py'a pemuruwak. Aja rahã: ‘Ihẽ kotyhar ta ke pehẽ’ aja a'e pandu ta” aja mu'e. Upa katu te ma'e ahy ixo ame'ẽ ta ke a'e mukatu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Heta ame'ẽ ta rehe a'e usak rahã, ame'ẽ ta rehe pyrara usak. Ame'ẽ ta ke amõ ta mupyrara. Usakiha ta nixói tĩ. A'erehe ame'ẽ ta rehe Jesu pyrara usak. Ame'ẽ ta riki arapuharan ta aja saka. Usakiha ta nixói, ame'ẽja saka. Katu ym aja. ");
INSERT INTO urbNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","A'erehe inamõ jumu'e ixo ame'ẽ ta pe a'e pandu: —Ahúi aja me'ẽ itawa hũ tipe. Pe, matyr ame'ẽ ta heta ym. ");
INSERT INTO urbNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tupã riki ahúi aja me'ẽ jar aja saka. A'erehe ijar namõ pepandu: “Kupixa pe matyr ame'ẽ ta ke emondo. Ahúi aja me'ẽ ke matyr ta” aja — aja Jesu pandu. (Aja pandu rahã, heta ame'ẽ ta rehe har Jesu pandu. Tupã rehe har ukwa ym ame'ẽ ta heta hũ ixo. Ahúi aja me'ẽ ta heta hũ, ame'ẽja saka. Ehe har pandu ame'ẽ ta heta ym tĩ. Matyr ame'ẽ ta heta ym tĩ. A'erehe Tupã namõ pandu ta me'ẽ te'e: “Nde rehe har pandu pandu ame'ẽ ta ke emondo” aja Tupã pe. Aja Jesu mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Inamõ jumu'e ixo ame'ẽ ta ke Jesu mujy'ar. Awa py mokõi sawa'e ta hetaha ke. A'e pandu: —Pejur! Pesarahã! Ihẽ je'ẽha rupi ãjã ta ke pemuhem ta katu pemondo. Ihẽ je'ẽha rupi upa katu te ma'e ahy ixo ame'ẽ ta ke pemukatu ta tĩ — aja awa py mokõi sawa'e ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Pe, ame'ẽ ta ke a'e mondo. Awa py mokõi sawa'e ta ke Jesu mondo. Kuja riki sawa'e ta rer. Ko Simã. Petu aja amõ her tĩ. Amõ Andere tĩ. Simã mu a'e. Amõ Tian tĩ. Semende ra'yr a'e. Imu amõ tĩ. Her Juã. ");
INSERT INTO urbNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Amõ Siri tĩ. Amõ Matoroméu tĩ. Amõ Tome tĩ. Amõ Matéu tĩ. Amukwehe homa awa tama'e kapitã keruhũ pe tamatarer matyr ame'ẽ ke a'e. Amõ Tian tĩ. Apéu ra'yr a'e. Amõ Tandéu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Amõ Simã tĩ. Jundéu awa tama'e ywy ngi huwajan ta ke a'e mujan tar katu muhem ame'ẽ ke a'e. Amõ Jun Ikario amõ tĩ. A'e riki Jesu rehe huwajan ta ke muhyk ta werur. ");
INSERT INTO urbNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ame'ẽ awa py mokõi sawa'e ta ke Jesu mondo. Kuja a'eta pe a'e pandu: —Jundéu awa aja ym ame'ẽ ta koty peho ym. Samari ywy pe har tama'e ok ta pe peho ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Jundéu awa ta koty jõ peho. Tupã rehe har mu'e ame'ẽ ta nixói ngã pe, a'erehe arapuharan ta kanim ame'ẽ ta aja saka a'eta. A'erehe ame'ẽ ta pe jõ pepandu pandu peho. ");
INSERT INTO urbNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kuja pepandu peho: “Ixoty ipy'a ke ngã muruwak rahã, Tupã pandu ta: ‘Pehẽ rehe ihẽ rury katu. Ihẽma'e ta ke pehẽ’ aja. A'erehe mã peja pehẽ py'a ke ixoty pemuruwak” aja pepandu peho. ");
INSERT INTO urbNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pepandu pandu peho rahã, kuja pema'ema'e tĩ. Upa ahy ixo ame'ẽ ta ke pemukatu. Manõ ame'ẽ ta ke pemukwera katu tĩ. Pereran ma'e u'u hũ ame'ẽ ta ke pemukatu tĩ. Ipy'a rehe ãjã ta ihĩ ame'ẽ ta py'a ngi ãjã ta ke pemuhem pemondo tĩ. Pehẽ pe pyrãtãha ke Tupã muwyr. A'erehe ame'ẽ pyrãtãha namõ amõ ta ke pemukatu tĩ. Mukatuha rehe pemuhepy ym. ");
INSERT INTO urbNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","—Tamatarer ke peraho ym. ");
INSERT INTO urbNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Pehẽ kupe pe ma'e ryru peraho ym tĩ. Mokõi kamixa peraho ym tĩ. Mokõi sapat peraho ym tĩ. Myra te'e pehẽ po pe peraho ym tĩ. (Myra rehe te'e wata ame'ẽ ke.) Pehẽ po te'e peho. Pesarahã! Ma'e nixói ame'ẽ ke parakyha pe ijar muwyr ta me'ẽ te'e. A'erehe ma'e ke peraho ym. Ma'e ke Tupã riki muwyr ta pehẽ pe. (Parakyha pe ijar muwyr ta, ame'ẽja saka.) ");
INSERT INTO urbNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","—Amõ ok ta pe pehyk rahã, hok pe pehẽ ke muxe ame'ẽ ke pekekar. Mahem rahã, a'ep pepyta we rĩ. Ame'ẽ ok ta pe pexo rahã, ame'ẽ rok pe jõ pepyta. Amõ amõ ok ta pe peho rahã, aja pema'ema'e tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Amõ ta rok pe pexe peho rahã, kuja pepandu: “Mã peja pehẽ rehe Tupã usak katu” aja. ");
INSERT INTO urbNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Pe, ame'ẽ rok wyr pe har ta pandu: “Ko pejur katu” aja. Pehẽ po ke pyhyk katu pehẽ ngi rahã, ame'ẽ ta rehe Tupã usak katu ta. —Pe, ame'ẽ rok wyr pe har ta hok pe pehẽ ke muxe tar ym rahã, ame'ẽ ta rehe Tupã hury ym ta. ");
INSERT INTO urbNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Hok pe amõ ta pehẽ ke muxe ym rahã, peho rahã, pehẽ py ngi ywy ku'i pejuhyk pembor. (Tupã ke putar ym ame'ẽ ta ke ko, aja pemujekwa ngã pe tĩ.) Ok ta pe har ta pehẽ ke putar ym rahã, aja pemujekwa tĩ. Pehẽ py ngi ywy ku'i pejuhyk pembor tĩ. (Aja rahã, ame'ẽ ok ta pe har ta ke Tupã putar ym tĩ, aja pemujekwa ngã pe tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","—Ko ihẽ apandu pehẽ pe. Yman rahã ngã ke Tupã mupyrara ta. Sondo ok ta pe har ta ke Tupã mupyrara ta. Ngomo ok ta pe har ta ke Tupã mupyrara ta tĩ. Ame'ẽ ta 'ar koty te we pehẽ rehe hendu ym ame'ẽ ta ke Tupã mupyrara ta. Ymanihar ta 'ar koty te we pehẽ ke putar ym ame'ẽ ta ke a'e mupyrara ta tĩ — aja awa py mokõi sawa'e ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","A'e pandu tĩ: —Pehendurahã! Jundéu awa ta koty pehẽ ke ihẽ amondo axo. Amõ amõ ta Tupã je'ẽha putar ym tĩ. Parahy ta. So'o jarõ, ame'ẽja saka. A'erehe pesak katu peho. Mã peja pesak katu kỹ! Pehẽ riki peparahy ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pesak katu kỹ. Pehẽ ke amõ ta pyhyk ta. Pe, kapitã ruwa koty pehẽ ke raho ta. Pehẽ rehe har je'ẽ je'ẽ hũ ta. Jundéu awa tama'e jy'ariha renda pe pehẽ ke raho ta tĩ. A'ep pehẽ rehe har je'ẽ je'ẽ hũ ta tĩ. So'o pirer pu'i pe pehẽ ke pirok ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","—Ihẽ rehe pejurujar katu, a'erehe kapitã keruhũ ruwa koty pehẽ ke amõ ta raho ta tĩ. Pehẽ rehe har a'eta je'ẽ je'ẽ hũ ta. Pe, mahy ta. Kapitã ruwa koty aja tĩ. Pehẽ ke mupyrara ta tĩ. Arahã myrandu katu ke pepandu ta a'eta pe. Jundéu awa aja ym ame'ẽ ta pe pepandu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kapitã ta ruwa koty pehẽ ke pyhyk raho rahã: “Ma'e ke jande japandu ta my? Myja me'ẽ jande japandu ta my?” aja pekwa pekwa ym pexo tĩ. Arahã ma'e pepandu ta ame'ẽ ke pehẽ pe Tupã mujekwa ta. ");
INSERT INTO urbNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Arahã pepandu rahã, pehẽ je'ẽha aja ym ta. Anĩ. Tupã'ã muwyr ame'ẽ je'ẽha ke pepandu ta. Jande pái keruhũ I'ã ke muwyr ta pehẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","—Arahã amõ ke kapitã pe imu pandu ta: “Ko Jesu kotyhar ke. Ejukwa” aja pandu ta. Ipái ta aja tĩ. Kapitã pe ta'yr ta ke raho ta tĩ. “Ko Jesu kotyhar ta ke. Ejukwa” aja ta tĩ. Ipái ta ke ta'yr ta raho ta tĩ. “Ko Jesu kotyhar ta ke. Ejukwa” aja ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ihẽ rehe pejurujar katu, a'erehe pehẽ rehe upa amõ ta parahy ta. Ihẽ rehe tapijar te'e we pejurujar katu rahã, Tupã namõ pexo katu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pehẽ ke ok ta pe har ta mupyrara rahã, amõ ok ta pe pejan peho. Apandu katu pehẽ pe. Upa katu te ok ta rupi peho. Ame'ẽ upa rahã, ihẽ ajywyr ta. Ko awa ihẽ tĩ. Tupã je'ẽha rupi ajur. ");
INSERT INTO urbNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","—Pesarahã! Jumu'eha 'ar koty te we mu'eha katuha. Te'e paraky ame'ẽ 'ar koty te we ijar katuha tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","A'erehe mu'eha aja jumu'eha ixo rahã, katu tiki tĩ. Ijar aja te'e paraky ame'ẽ ixo rahã, katu tiki tĩ. Pehẽ riki aja tĩ. (Ihẽ riki mu'eha aja. Pehẽ riki jumu'eha ta.) Ihẽ rehe har amõ ta pandu: “Nde riki Satana” aja naĩ. (Ãjã ramũi a'e.) Aja rahã, ihẽ 'ar koty te we pehẽ rehe har ma'e jaxer ai ame'ẽ ke amõ ta pandu ta — aja Jesu mujekwa. Awa py mokõi jumu'eha ta pe mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","28","Awa py mokõi jumu'eha ta pe Jesu pandu tĩ: —Pehẽ ke amõ ta mupyrara ta. Anĩ. Sawa'e ta ngi pekyje ym. Pehẽ pe ihẽ apandu ame'ẽ ke amõ ta ukwa ym. Yman rahã upa ame'ẽ ke amõ ta pe pepandu pandu ta. Upa amõ ta ukwa ta. Ma'e ke rehe pehẽ jõ pehendu ame'ẽ ke amõ ta pe pemujekwa ta. Apo ma'e kanim aja ixo ame'ẽ ke upa mujekwa ta amõ ta pe. Amõ ta ukwa ym ha rupi pekwa ame'ẽ ke upa pemujekwa ta a'eta pe tĩ. —Pesarahã! Sawa'e ta ngi pekyje ym. Pehẽ ke a'eta jukwa rahã, ame'ẽ jõ riki. Pehẽ'ã ke marã ka ym mahyha. Tupã anĩ. Pekyje ingi. Pehẽ ke a'e jukwa rahã, amõ we tĩ. Mupyraraha renda pe pehẽ ke a'e mupyrara ta. A'erehe pekyje ingi. ");
INSERT INTO urbNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","—Mokõi ma'ewyra ra'yr rehe amõ muhepy rahã, peteĩ tamatarer pu'a ra'yr muhepy. Pe, ame'ẽ ma'ewyra ra'yr rehe har Tupã usak katu. Jande pái keruhũ pandu ym rahã, ma'ewyra ra'yr manõ ym ta. (Aja rahã, kuja mujekwa katu. Ma'ewyra ra'yr 'ar koty te we pehẽ rehe jande pái keruhũ usak katu.) Pehẽ aja tĩ. Pehẽ ãkã rehe pehẽ'a ihĩ. Ame'ẽ hetaha ke a'e ukwa katu. (Ame'ẽ ke ukwa rahã, upa katu te pehẽ rehe har a'e ukwa katu tĩ, aja mujekwa katu. A'erehe pehẽ rehe Tupã usak katu te we ta, aja mujekwa katu tĩ) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","A'e pandu tĩ: —Mupyrara ame'ẽ ta namõ amõ ixo rahã, kuja pandu: “Jesu kotyhar ke ihẽ” aja pandu. Aja rahã, kuja ehe har ihẽ riki apandu ta tĩ: “Ihẽ kotyhar te ke a'e” aja ihẽ pái keruhũ pe ihẽ apandu ta. (Aja rahã, ame'ẽ ke ihẽ pái keruhũ putar katu tĩ.) Ywatehar ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pe, mupyrara ame'ẽ ta namõ amõ ixo rahã, kuja pandu: “Ihẽ anĩ. Jesu ke ihẽ akwa ym. Ixotyhar ym ihẽ” aja pandu. Aja rahã, kuja ehe har ihẽ apandu ta tĩ: “Peme'ẽ anĩ. Ihẽ akwa ym peme'ẽ. Ihẽ kotyhar aja ym a'e” aja ihẽ pái keruhũ pe ihẽ apandu ta. (Aja rahã, ame'ẽ ke ihẽ pái keruhũ putar ym tĩ.) Ywatehar ke a'e — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","A'e pandu tĩ: —Kome'ẽ ywy keruhũ pe har ta jumai mai ixo. Ame'ẽ ke ihẽ amuputu'u ajur, aja pekwaha my? Anĩ. Aja ym ajur. Ihẽ ajur, a'erehe amõ amõ ta jumai mai ta. ");
INSERT INTO urbNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ipái ta ihẽ rehe jurujar katu, a'erehe ta'yr ta je'ẽ je'ẽ hũ ta. (Huwajan ta aja saka ta.) Imãi ta ihẽ rehe jurujar katu, a'erehe imembyr kũjã ta je'ẽ je'ẽ hũ ta tĩ. (Huwajan ta aja saka ta tĩ.) Ixawa'e mãi ta ihẽ rehe jurujar katu, a'erehe imembyr reko ame'ẽ ta je'ẽ je'ẽ hũ ta tĩ. (Huwajan ta aja saka ta tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ihẽ rehe amõ jurujar katu rahã, hok wyr pe har ta je'ẽ je'ẽ hũ ta. (Huwajan ta aja saka tĩ.) Amõ ruwajan 'ar koty te we katu ym ha. ");
INSERT INTO urbNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","—Ipái rehe amõ ipy'a katu, ame'ẽ 'ar koty te we ihẽ rehe ipy'a katu. Aja jõ rahã, ihẽ kotyhar te a'e. Imãi rehe aja tĩ. Ipy'a katu tĩ. Pe, i'ar koty te we ihẽ rehe ipy'a katu. Aja jõ rahã, ihẽ kotyhar te a'e tĩ. Ta'yr rehe aja tĩ. Tajyr rehe aja tĩ. Ame'ẽ ta 'ar koty te we ihẽ rehe ipy'a katu. Aja jõ rahã, ihẽ kotyhar te a'e tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ihẽ kotyhar aja amõ ixo rahã, ame'ẽ ke amõ ta jukwa tar katu. Ame'ẽ ngi kyje ym rahã, ihẽ kotyhar aja ixo ta. ");
INSERT INTO urbNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Amõ riki ihẽ kotyhar wan ta. A'erehe ame'ẽ ke amõ ta jukwa tar katu. A'erehe ihẽ rehe jurujar tar ym. Hijar, a'erehe jukwaha ke amõ muputu'u. A'erehe a'e ixo we tipe. Ame'ẽ ke Tupã putar ym. Inamõ ixo ym ta. Aja ihẽ tĩ. Aputar ym tĩ. Amõ riki ihẽ rehe jurujar katu, a'erehe a'e ke amõ ta jukwa. Jurujar katuha ke hijar ym. Aja rahã, Tupã namõ a'e ixo katu ta. Uhã te hũ aja a'e ixo ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","A'e pandu tĩ: —Ihẽ rehe har pepandu pandu peho. A'erehe pehẽ pe amõ pandu: “Ihẽ rok pe pepyta katu” aja. Aja pehẽ ke hok pe muxe katu rahã, ihẽ ke a'e muxe katu, ame'ẽja saka tĩ. Tupã ke a'e muxe katu tĩ, ame'ẽja saka tĩ. Ihẽ ke Tupã muwyr. ");
INSERT INTO urbNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tupã je'ẽha pandu ame'ẽ ke ko, aja amõ ukwa. A'erehe hok pe a'e muxe katu. Aja rahã, ma'e katu ame'ẽ ke Tupã muwyr ta ipe. Tupã je'ẽha pandu ame'ẽ pe ma'e katu ame'ẽ ke Tupã muwyr ta ipe. Aja ok jar pe a'e muwyr ta tĩ. Juja katu te muwyriha ke. “Ko sawa'e katu” aja amõ ukwa. A'erehe hok pe ame'ẽ sawa'e ke muxe katu rahã, ma'e katu ame'ẽ ke Tupã muwyr ta ipe tĩ. Sawa'e katu ame'ẽ pe ma'e katu ame'ẽ ke Tupã muwyr ta ipe. Aja ma'e katu ame'ẽ ke ok jar pe Tupã muwyr ta tĩ. Juja katu te muwyriha ke. ");
INSERT INTO urbNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Pesarahã! Kuja pekwa katu pexo. “Ko Jesu kotyhar ke” aja amõ ukwa. A'erehe jyngwéi rahã, kúi pe y rysã me'ẽ ipe. (Aja rahã ipy'a katu ehe aja mujekwa.) Aja rahã y me'ẽha pe ma'e katu ame'ẽ ke Tupã riki muwyr ta tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Awa py mokõi jumu'eha ta pe Jesu upa pandu rahã, ame'ẽ ok ta ngi a'e oho. Hake rupi amõ ok ta ihĩ. Ame'ẽ rupi a'e mu'e oho. ");
INSERT INTO urbNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kyndaha pe Juã mujahukiha ixo. Upa ma'e Jesu ma'ema'e ame'ẽ rehe har hendu rahã, sawa'e ta ke a'e mondo, Jesu pe. Inamõ jumu'e ixo ame'ẽ ta ke Juã mondo. ");
INSERT INTO urbNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ame'ẽ ta uhyk rahã, Jesu pe pandu: —“Amõ sawa'e uwyr ta” aja jande pe Juã pandu. Nde riki ame'ẽ sawa'e ke my? Ame'ẽ ym rahã, amõ sawa'e rehe jaharõ ta my? Emujekwa katu jande pe — aja Jesu pe sawa'e ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesu pandu: —Juã koty pejywyr peho. Pesak ramõ ame'ẽ ke upa pepandu ipe. Pehendu ame'ẽ ke upa pepandu ipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kuja. “Eha ym te ame'ẽ ke apo ma'e ke rehe usak katu tĩ. Wata ym te ame'ẽ ke apo wata katu tĩ. Pereran ma'e u'u hũ ame'ẽ namõ ixo ame'ẽ ta ke apo upa ka'ẽ oho ipe tĩ. Ma'e hendu ym te ame'ẽ ta apo ma'e hendu katu tĩ. Manõ ame'ẽ ta kwera katu uhem tĩ. Pyrara ixo ame'ẽ ta pe myrandu katu ke amõ ta pandu raho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pe, ihẽ rehe jurujar katuha ke hijar ym rahã, hury katu a'e ixo.” Aja Juã pe pepandu peho — aja Jesu. A'eta pandu: —Hã! Japandu ta jaho kỹ — aja sawa'e ta. (Ahy ame'ẽ ta ke Jesu mukatu. Manõ ame'ẽ ta ke mukwera tĩ. Aja rahã, a'e riki Kirisutu. “Kapitã keruhũ” aja Tupã mu'am ame'ẽ ke a'e. Jundéu awa ta harõ hũ ame'ẽ ke a'e aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juã muwyr ame'ẽ ta jywyr oho ixo rahã, Juã rehe har amõ ta pe Jesu pandu: —Amukwehe awa nixói te ame'ẽ pe Juã rehe pesak peho rahã, ma'e pesak peho my? Sawa'e pitu te'e ame'ẽ rehe pesak peho my? Anĩ. Aja ym Juã. Pyrãtã a'e. Pahar amõ koty koty ukwaha ke mondo ym a'e. ");
INSERT INTO urbNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ima'e mundeha katu te ame'ẽ ke namõ ixo. Ame'ẽ sawa'e rehe pesak peho my? Anĩ. Pesarahã! Aja mundeha katu te ame'ẽ ke namõ ixo ame'ẽ ta kapitã keruhũ rok rehe jõ ixo. (Juãma'e aja ym. Ima'e mundeha katu te aja ym namõ ixo.) ");
INSERT INTO urbNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ihẽ pe pepandurahã! Awa rehe pesak peho my? Tupã je'ẽha pandu ame'ẽ ke rehe pesak peho my? A'e riki. Pesarahã! Ihẽ apandu pehẽ pe. Ymanihar Tupã je'ẽha pandu ame'ẽ ta 'ar koty te we Juã katuha. (A'erehe Juã rehe pehendu katu ta me'ẽ te'e.) ");
INSERT INTO urbNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juã rehe har kuja Tupã je'ẽha rehe panduha ihĩ. Kuja Ta'yr rehe har Tupã pandu: “Ne ndutar koty myrandu raho ame'ẽ ke ko ihẽ amondo py. Nde ereho tate rahã, amõ ta py'a ke ihẽ koty a'e riki muruwak ta mondo” aja panduha ihĩ. (Ame'ẽ mondo py ame'ẽ ke Juã.) ");
INSERT INTO urbNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","—Apandu pehẽ pe. Upa katu te sawa'e ta 'ar koty te we Juã katuha ke. Apo amõ ixo. Apo myrandu katu pandu oho ame'ẽ ta ixo. Myrandu katu ymanihar Tupã je'ẽha pandu ame'ẽ ta pandu pandu. Juã pandu ame'ẽ ke i'ar koty te we katuha. Apo anĩ. Ihẽma'e jumu'eha ta myrandu katu ke pandu. Ame'ẽ ta Juã 'ar koty te we katuha. Ihẽma'e jumu'eha ta ukwa ym ame'ẽ ta ke, aja pekwaha naĩ. Anĩ. Ame'ẽ ta katu te, aja Tupã pe. ");
INSERT INTO urbNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Myrandu ke Juã pandu pandu. “Ixoty pehẽ py'a ke pemuruwak rahã, Tupã pandu ta: ‘Ihẽma'e ta ke pehẽ’ aja Tupã pandu” aja Juã pandu. Pe, Tupã koty heta ipy'a ke muruwak. Apo ihẽ apandu ame'ẽ ke rehe amõ ta heta te hũ jurujar katu tĩ. Putar katu hũ tĩ. A'erehe Tupã koty ipy'a ke muruwak katu. ");
INSERT INTO urbNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juã uwyr ym rahã we, upa Tupã je'ẽha pandu ame'ẽ ta pandu pandu tĩ. Myja me'ẽ Tupã kotyhar aja muruwak ta my? Ame'ẽ rehe har pandu pandu. Aja Moise je'ẽha mujekwa tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ame'ẽ ta je'ẽha rehe pejurujar tar katu rahã, kuja pekwa ta. Juã riki Eri. Eri riki uwyr ta kỹ, aja yman amõ mupinim. Juã riki ame'ẽ Eri aja saka. ");
INSERT INTO urbNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Pekwa tar katu rahã, pehendu apo. ");
INSERT INTO urbNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","—Ihẽ ke putar ym ame'ẽ ta riki kurumĩ ra'yr ta aja saka. Jumusaráiha ke a'eta mujã. Muhepyha renda pe wapyk. Pe, wajar ta pandu: ");
INSERT INTO urbNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Jande rury katuha ke jajyngar tipe. Pepurahái ym. Japyaiha jajyngar tipe. Pejixi'u ym” aja wajar ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Hury ym kurumĩ ra'yr ta. Aja riki ihẽ ke putar ym ame'ẽ ta tĩ. Juã uwyr rahã, amõ amõ rahã, ma'e u'uha ke a'e hijar. Kawĩ ke a'e u'u ym te tĩ. Pe, ehe har amõ ta pandu: “Ipy'a rehe ãjã ihĩ ame'ẽ ke a'e. Katu ym a'e” aja naĩ. Tupã je'ẽha pandu ame'ẽ ke a'e, aja a'eta putar ym. Jundéu awa ta hury ym ehe. (Jumusaráiha wajar saka.) ");
INSERT INTO urbNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","—Ko awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ko ihẽ ajur rahã, upa ma'e ke ihẽ a'u. Ma'e a'uha ahijar ym. Kawĩ ihẽ a'u tĩ. Pe, ihẽ rehe har amõ ta pandu: “Pesak eherahã! Ma'e u'u hũ ame'ẽ ke a'e. Kawĩ ngi ka'u ame'ẽ ke a'e” aja naĩ. Amõ we tĩ. “Ma'e jaxer ame'ẽ ta rehe katu ame'ẽ ke a'e. Homa awa tama'e kapitã keruhũ pe tamatarer matyr ame'ẽ ta rehe katu ame'ẽ ke a'e tĩ. Katu ym aja” aja riki naĩ. Tupã muwyr ame'ẽ ke ihẽ, aja a'eta putar ym. Jundéu awa ta hury ym ihẽ rehe. (Jumusaráiha wajar saka.) —Pesarahã! Tupã rehe amõ jurujar katu rahã, Tupã riki upa ma'e ke ukwa katu, aja amõ ukwa. Pe, ixotyhar aja a'e jumuruwak ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Amõ amõ ok ta pe marã ka ym amõ ma'eha. Ame'ẽ ke Jesu ma'ema'e katu tipe. Heta hũ ma'ema'e tipe. A'ep pe har ta hijar ym ma'e ke. Ma'e ka'u te'eha ma'ema'eha ke hijar ym. Tupã koty ipy'a ke muruwak ym. A'erehe a'ep pe har ta rehe har Jesu pandu: ");
INSERT INTO urbNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Korasĩ ok ta pe har ta! Mãte hũ pehẽ ke Tupã mupyrara ta. Mesái ok ta pe har ta aja tĩ! Mãte hũ pehẽ ke Tupã mupyrara ta tĩ. Marã ka ym amõ ma'eha, ame'ẽ ke heta te hũ pehẽ ruwa koty ihẽ ama'ema'e tipe. Pehẽ ruwa koty ihẽ ama'ema'e, ame'ẽ ke ymanihar Tir ok ta pe ihẽ ama'ema'e ta tipe rahã, a'ep pe har ta ma'e ka'u te'eha ke hijar ta tipe. Pan xuru aja me'ẽ ma'e mundeha ke munde ta tipe. (Aja pyaiha ke mujekwa ta tipe.) Tatimbuk ke iãkã rehe ombor ta tipe tĩ. (Aja pyaiha ke mujekwa ta tipe tĩ.) Ymanihar Sinõ ok ta pe har ta aja tĩ. (Pyaiha ke mujekwa ta tipe tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","—Ko ihẽ apandu. Ngã ke Tupã mupyrara rahã, Tir ok ta pe har ta ke a'e mupyrara ta. Sinõ ok ta pe har ta aja tĩ. Mupyrara ta tĩ. Ame'ẽ ok ta pe har ta 'ar koty te we Korasĩ ok ta pe har ta ke a'e mupyrara ta. (Ihẽ rehe jurujar ym, a'erehe i'ar koty te we mupyrara ta tĩ.) Aja Mesái ok ta pe har ta ke a'e mupyrara ta tĩ. (Ihẽ rehe jurujar ym, a'erehe i'ar koty te we mupyrara ta tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","—Kapana'ũ ok ta pe har ta tĩ. “Jande anĩ. Katu te jande” aja pekwaha naĩ. Upa pehẽma'e ok ta ke Tupã mumba ta tĩ. Marã ka ym amõ ma'eha, ame'ẽ ke pehẽ pyter pe ihẽ ama'ema'e katu tipe. Aja ymanihar Sondo ok ta pe ihẽ ama'ema'e ta tipe rahã, ame'ẽ ok ta apo ixo ta tipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pehẽ pe ihẽ apandu katu. Ngã ke Tupã mupyrara rahã, Sondo ok ta pe har ta ke a'e mupyrara ta. Ame'ẽ 'ar koty te we Kapana'ũ ok ta pe har ta ke a'e mupyrara ta. (Ihẽ rehe jurujar ym, a'erehe i'ar koty te we mupyrara ta tĩ) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Arahã Jesu pandu: —Papa! Sawa'e te nde! Ywa ke nde eremujã. Kome'ẽ ywy keruhũ aja tĩ. Nde eremujã tĩ. Ihẽ amu'e ame'ẽ ke paper rehe jumu'e ym ame'ẽ ta pe nde eremujekwa katu. A'erehe: “Ne jõ riki katu te me'ẽ ke” aja apandu nde pe. “Jakwa katu jande” aja ukwa ame'ẽ ta pe anĩ. Nde eremujekwa ym tĩ. “Upa jande jajumu'e” aja ukwa ame'ẽ ta pe anĩ tĩ. Nde eremujekwa ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aja riki nde ereputar ame'ẽ ke uhyk riki. Papa! Katu aja — aja ipái keruhũ pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jumu'eha ta pe Jesu pandu tĩ: —Upa katu te ma'e ke ihẽ pe ihẽ pái keruhũ muwyr. Ta'yr ke ihẽ. Ihẽ rehe har ukwa ym awa. Ihẽ pái jõ ukwa katu. Aja ihẽ pái rehe har ukwa ym awa. Ihẽ jõ akwa katu. Pe, ihẽ aputar ame'ẽ ta pe ehe har ihẽ amujekwa katu. Aja rahã, ame'ẽ ta ukwa katu ta ehe har tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","—Pehẽ ramũi ukwaha ke pehendu tipe. Hãtã riki ame'ẽ pema'eha. Pehẽ re'õ, ame'ẽja saka tĩ. A'erehe ihẽ koty pejur. Pehẽ py'a ke ihẽ amuhury katu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ihẽ apandu ame'ẽ ke pema'e. Hãtã ym ame'ẽ pema'ema'eha. A'erehe ihẽ namõ pejumu'e katu. Hãtã ihẽ aje'ẽ ym ta. Ihẽ katu. A'erehe ihẽ namõ pejumu'e katu. Aja rahã, pehẽ py'a ke ihẽ amuhury katu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ihẽ apandu ame'ẽ ke pema'e rahã, hãtã ym riki ame'ẽ pema'eha. Ihẽ amu'e ame'ẽ ke pema'e rahã, ame'ẽ hãtã ym tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Heta ym ukwer rahã, ahúi aja me'ẽ ty rupi Jesu wata ixo. Jumu'eha ta namõ wata ixo. Arahã jundéu awa tama'e putu'uha 'ar ke. Jumu'eha ta myahy riki. A'erehe ahúi aja me'ẽ ke a'eta po'ok. (Ame'ẽ ke ipo pe kamyrik. Aja pirer ke ombor.) Pe, u'u ixo. ");
INSERT INTO urbNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ame'ẽ rehe parise ta usak. Pe, Jesu pe pandu: —Anĩ. Katu ym u'uha. Jundéu awa tama'e putu'uha 'ar rahã, aja nema'e jumu'eha ta kamyrik rahã, katu ym. (Paraky te'e, aja saka. A'erehe katu ym.) Aja Moise je'ẽha rehe panduha ihĩ — aja parise ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","(Amõ rehe pyrara usak ta me'ẽ te'e, aja Jesu mujekwa tar katu) a'erehe pandu: —Yman Ndawi myahy te riki. Inamõ ixo ame'ẽ ta aja tĩ. Myahy te tĩ. Ame'ẽ ta ma'eha ke Tupã je'ẽha rehe pesak riki. ");
INSERT INTO urbNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ma'e u'u ame'ẽ ke nixói te rahã, Tupã rehe ngã jumu'eha renda keruhũ pe a'eta ixe oho. Pe, mbeju a'ep ihĩ. Ame'ẽ ke u'u. Ame'ẽ mbeju Tupã ruwa koty pa'ihu moĩ, ame'ẽja saka. Pa'i ta jõ ame'ẽ ke u'u katu. Amõ ta u'u rahã, anĩ. Katu ym. A'erehe Ndawi ta u'u rahã, katu ym ta tipe. (Ndawi ta pa'i ta ym. Aja Moise je'ẽha rehe hendu ym.) ");
INSERT INTO urbNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","—Amõ we tĩ. Jundéu awa tama'e putu'uha 'ar rahã pame katu te pa'i ta paraky ixo. Tupã rehe ngã jumu'eha renda keruhũ rehe paraky ixo. Putu'uha 'ar rahã, paraky rahã, katu ym, aja Moise je'ẽha rehe pesak. Pa'i ta paraky riki. Ame'ẽ katu pehẽ pe. A'erehe: “Mã peja pa'i ta paraky” aja pepandu. ");
INSERT INTO urbNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","—Ko amujekwa pehẽ pe. Tupã rehe ngã jumu'eha renda keruhũ riki katu. I'ar koty te we amõma'e katuha kohĩ. Ihẽ riki ame'ẽ. (A'erehe ihẽma'e jumu'eha ta ma'eha katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kuja Tupã je'ẽha rehe panduha ihĩ. (Tupã pandu:) “Ihẽ rehe pehẽ py'a pemoĩ moĩ rahã, pehẽ rymba ke pehapy tipe. Upa ukwái tipe. Arapuharan ra'yr ke ame'ẽ. Ame'ẽ ke ihẽ aputar ym. Kuja katu te. Amõ ta rehe pepyrara pesak. Ame'ẽ ke ihẽ aputar katu” aja panduha ihĩ. —Ame'ẽ pinĩha ke pekwa rahã, ma'e katu ame'ẽ ke amõ ta ma'ema'e ta. Ame'ẽ ta pe: “Pehẽ katu ym” aja pepandu ym ta tipe. ");
INSERT INTO urbNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Awa ihẽ tĩ. Tupã je'ẽha rupi ajur ame'ẽ ke ihẽ. A'erehe jundéu awa tama'e putu'uha 'ar rahã, ma'e ke amõ ma'e, ame'ẽ ke ihẽ riki apandu katu — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","A'engi a'e oho. Jundéu awa tama'e jy'ariha renda pe a'e ixe oho. ");
INSERT INTO urbNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","A'ep amõ sawa'e ihĩ. Ipo ke upa te'e jupu'a ame'ẽ ke a'e. Amõ sawa'e ta ihĩ tĩ. Jesu rehe a'eta usak katu uĩ. Jesu pe a'eta pandu: —Putu'uha 'ar rahã, ma'e ahy ixo ame'ẽ ke amõ mukatu rahã, katu ym, aja Moise je'ẽha mujekwa my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","12","Jesu pandu: —Anĩ. Katu, aja mujekwa. Pesarahã! Pehẽ ngi har amõ riki arapuharan namõ ixo. Putu'uha 'ar rahã, ywykwar pe ame'ẽ u'ar rahã, ame'ẽ ke hykýi ta muhem riki. (Ame'ẽ ke paraky te'e, aja pekwa.) Arapuharan riki katu. Sawa'e riki arapuharan 'ar koty te we katuha. A'erehe putu'uha 'ar rahã amõ ta rehe amõ pyrara usak rahã, katu te tiki, aja Moise je'ẽha mujekwa — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pe, sawa'e pe a'e pandu: —Nde po epirar 'y! — aja ipe. Ipo ke sawa'e pirar rahã, upa puku oho ipe. Imembek katu oho ipe tĩ. Wajar aja katu oho. ");
INSERT INTO urbNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A'engi parise ta uhem oho. Pe, a'eta jupandu pandu a'eta jupe: —Myja Jesu ke japyhyk ta my? Pe, jajukwa ta — aja parise ta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","A'e ke amõ ta jukwa tar katu, aja Jesu ukwa rahã, ame'ẽ renda ngi oho. Kapana'ũ ok ta rake ngi oho. Heta ngã haikwer rupi oho tĩ. Upa ahy ixo ame'ẽ ta ke a'e mukatu. ");
INSERT INTO urbNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pe, ame'ẽ ta pe a'e pandu: —Pehẽ ke ihẽ amukatu. Ihẽ Kirisutu. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke ihẽ. Ame'ẽ ke ngã pe pepandu ym — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aja ahy ixo ame'ẽ ta ke mukatu rahã, yman Tupã pandu, ame'ẽ panduha uhyk. Je'ẽha ke Isai mupinim. ");
INSERT INTO urbNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ta'yr rehe har Tupã pandu: “Ko ihẽma'e miasu ke. Ihẽ kotyhar aja ajo'ok. Ihẽ apy'a katu ehe. Ihẽ ke a'e muhury katu tĩ. Ihẽ'ã ke ihẽ amuwyr ta ipe. Upa awa ta pe ihẽ rehe har a'e pandu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Hãtã a'e pandu ym ta ngã pe. Je'ẽ je'ẽ ym ta tĩ. Awa rape rupi hãtã a'e je'ẽ je'ẽ ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Amõ pitu te'e ame'ẽ ta pe wewe katu ma'e ke a'e ma'e ta. Pyrãtã ym ame'ẽ ta rehe a'e pyrara usak ta tĩ. Aja tapijar te'e we a'e ixo ta. Aja rahã, myrandu katu ke upa ngã ukwa katu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Pe, ehe har amõ ta mujekwa. A'erehe upa amõ ta ukwa katu ta ehe har tĩ” aja Tupã pandu ame'ẽ ke Isai mupinim. ");
INSERT INTO urbNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ajame'ẽ ke eha ym te ame'ẽ ke amõ ta werur ipe. Sawa'e py'a rehe ãjã ihĩ, a'erehe eha ym te. Ame'ẽ je'engai tĩ. Pe, ame'ẽ ke Jesu mukatu rahã, ma'e ke sawa'e pandu katu tĩ. Upa ma'e ke rehe usak katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ahy ixo ame'ẽ ke Jesu mukatu, a'erehe a'eta pandu: —Mã! Katu tiki! Pyrãtã te ame'ẽ ke a'e! Kapitã keruhũ aja Tupã mu'am ame'ẽ ke nahã my? Jaharõ hũ ehe ame'ẽ ke — aja amõ ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ame'ẽ ke parise ta hendu rahã, pandu: —Anĩ. Aja ym. Satana riki pyrãtãha ke muwyr ipe, a'erehe ãjã ta ke Jesu muhem katu mondo — aja riki naĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ame'ẽ ta ipy'a pe ukwa ukwa uĩ, ame'ẽ ke Jesu ukwa katu, a'erehe a'eta pe pandu: —Anĩ. Aja ym. Ihẽ pe pyrãtãha ke Satana muwyr ym te. (Ãjã ramũi a'e.) Pesarahã! Ihẽ amujekwa ta. Ywy pe har ta amõ koty koty jy'ar. Pe, jumai mai ngã juehe rahã, pahar jumumba ta ngã juehe riki. (A'erehe jumai mai ym ta ngã juehe.) Ok ta pe har ta aja tĩ. Ok wyr pe har ta aja tĩ. Amõ koty koty jy'ar, pe, jumai mai a'eta juehe rahã, jumumba ta a'eta juehe tĩ. (A'erehe jumai mai ym ta a'eta juehe.) ");
INSERT INTO urbNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aja ãjã ta jumai mai a'eta juehe rahã, Satana koty har ta amõ koty koty ixo, aja mujekwa. Aja rahã, pahar jumumba ta a'eta juehe. (A'erehe ihẽ pe pyrãtãha ke Satana muwyr ym te.) ");
INSERT INTO urbNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ãjã ramũi riki ihẽ pe pyrãtãha ke muwyr, a'erehe ãjã ta ke ihẽ amuhem amondo, aja pepandu naĩ. Pesarahã! Ãjã ta ke ihẽ amuhem amondo. Pehẽ kotyhar ta aja tĩ. Ãjã ta ke muhem mondo tĩ. Aja rahã, awama'e pyrãtãha namõ muhem mondo my? Satanama'e pyrãtãha namõ my? Anĩ. Aja ym. Aja rahã, ihẽ aja tĩ. Satanama'e pyrãtãha namõ aja ym ihẽ tĩ. A'erehe pehẽ je'ẽha pejawy te'e aja pehẽ kotyhar ta mujekwa katu pehẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pesarahã! Ihẽ pe Satana pyrãtãha ke muwyr ym te. Tupã'ã riki ihẽ pe pyrãtãha ke muwyr. A'erehe ãjã ta ke amuhem katu amondo. Aja rahã, ihẽ riki kapitã keruhũ aja Tupã mu'am ame'ẽ ke ihẽ aja pekwa katu ta me'ẽ te'e. Peharõ katu pexo ame'ẽ ke ihẽ. ");
INSERT INTO urbNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","—Sawa'e pyrãtã rok pe ma'e ke mukanim ym oho awa. Mukanim oho rahã, sawa'e pyrãtã ame'ẽ jywa ke a'e mujere ta pukwar py. A'engi sawa'ema'e ke upa mukanim ta raho. (Aja ihẽ riki tĩ. Satanama'e pyrãtãha ngi sawa'e ke ihẽ riki amuhem. Aja rahã, Satanama'e pyrãtãha ke ihẽ riki amuputu'u aja ihẽ amujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","—Ihẽ kotyhar aja amõ ixo ym rahã, ihẽ namõ jumai ame'ẽ ke a'e. Tupã koty ihẽ namõ ngã ke amõ mujy'ar ym rahã, ame'ẽ riki amõ koty ihẽ ngi muhãi mondo a'e. Tupã ruwajan koty mujy'ar mondo. ");
INSERT INTO urbNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ko ihẽ apandu pehẽ pe. Ma'e ka'u te'eha ke ngã ma'ema'e. Ame'ẽ rehe Tupã ipy'a jywyr katu. Juru ai ehe rahã, ame'ẽ rehe Tupã ipy'a jywyr katu tĩ. Tupã'ã rehe juru ai rahã, ame'ẽ rehe marã ka ym Tupã ipy'a jywyriha. ");
INSERT INTO urbNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ rehe har katu ym amõ pandu rahã, ame'ẽ rehe Tupã ipy'a jywyr ta. Tupã'ã rehe har katu ym amõ pandu rahã, ame'ẽ rehe Tupã ipy'a jywyr ym te ta. Apo jywyr ym te ta. Yman rahã, jywyr ym te ta tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","A'e pandu tĩ: —Ma'eywa'y riki hury katu rahã, i'a hũ ta. Ma'eywa'y hury ym rahã, i'a ym ta. A'erehe i'a hũ rahã, ma'eywa'y riki katu aja amõ ukwa katu. ");
INSERT INTO urbNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Parise ta! Mbói aja saka pehẽ! Katu ym ame'ẽ ta ke pehẽ, a'erehe mbói aja saka. Ma'eywa'y katu ym aja saka pehẽ. A'erehe katu ame'ẽ ke ihẽ ama'ema'e, ame'ẽ rehe har: “Mã! Katu tiki” aja pepandu ym te. Pehẽ py'a pe peka'u te'eha ke pekwa pekwa pexo. A'erehe ame'ẽ ke pepandu rahã, ma'e jaxer ame'ẽ ke pepandu. ");
INSERT INTO urbNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Sawa'e katu ame'ẽ ke ipy'a pe katu ame'ẽ ke ukwa ukwa ixo. A'erehe a'e pandu rahã, katu ame'ẽ ke pandu katu. Sawa'e katu ym ame'ẽ ke ipy'a pe ma'e jaxer ame'ẽ ke ukwa ukwa ixo. A'erehe a'e pandu rahã, ma'e jaxer ame'ẽ ke pandu. Pehẽ parise ta katu ym, a'erehe ma'e katu ym ame'ẽ ke pepandu. (Ma'eywa'y katu ym, ame'ẽja saka pehẽ.) ");
INSERT INTO urbNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","—Yman rahã ngã ke Tupã mupyrara rahã, upa ma'e jaxer ame'ẽ ke amõ pandu, ame'ẽ ke Tupã mujekwa ta. Pe, a'e mupyrara ta. Upa katu te amõ tama'e panduha ke a'e mujekwa ta. ");
INSERT INTO urbNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ma'e pepandu ame'ẽ ke Tupã ukwa ta. Pe, mupyrara ta. “Nde katu ym” aja a'e pandu rahã, a'e mupyrara hũ ta. “Nde katu” aja a'e pandu rahã, mupyrara ym ta. A'erehe myja me'ẽ pepandu apo, ame'ẽ ke pekwa pekwa katu pexo. (Katu ame'ẽ ke jõ pepandu katu) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ajame'ẽ ke Moise je'ẽha mu'e ame'ẽ ta uhyk uwyr. Parise ta uhyk uwyr tĩ. Upa ame'ẽ ta Jesu pe pandu: —Sa'e! Ngã mu'eha nde. Marã ka ym amõ ma'eha, ame'ẽ ke ema'e apo. Jasak ta. (Aja rahã, nde ke Tupã muwyr, aja jakwa katu ta) — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesu pandu: —Anĩ. Pehẽ ruwa koty ama'e ym ta. Mã! Tupã rehe har pekwa ym te. Ma'e peka'u te'eha ke pema'ema'e ame'ẽ ta ke pehẽ tĩ. Marã ka ym amõ ma'eha, ame'ẽ ke ama'ema'e katu. Ame'ẽ ke rehe pesak tar katu. Anĩ ta. Pesarahã! Jon riki Tupã je'ẽha pandu ame'ẽ ke a'e. Yman pira keruhũ pusu rehe Jon túi. (Manõ ym.) A'erehe uhem ingi rahã: “Ihẽ ke Tupã muwyr” aja Jon mujekwa ngã pe. Jon aja ihẽ tĩ. Aja jõ ihẽ amujekwa ta pehẽ pe tĩ. Amanõha ngi akwera katu ahem rahã, ihẽ ke Tupã muwyr, aja amujekwa ta. (Pira keruhũ pusu ngi Jon uhem, ame'ẽja saka ihẽ tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Pira keruhũ pusu pe Jon túi. Mokõi ukwer rahã, a'ep túi. Aja ihẽ amanõ rahã, mokõi aker rahã, itakwar keruhũ pe ihẽ rete pete'e túi. Awa ihẽ tĩ. Tupã je'ẽha rupi ihẽ ajur. ");
INSERT INTO urbNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","—Yman rahã, ngã ke Tupã mupyrara ta. Arahã Nini ok ta pe har ta pu'am ta. Jon pandu ame'ẽ ke rehe a'eta hendu katu. Pe, ma'e ka'u te'eha ma'ema'eha ke hijar. Tupã koty ipy'a muruwak mondo. A'erehe yman rahã, Tupã mupyrara rahã, kuja pandu ta: “Jesu je'ẽha rehe pehendu ym. Katu ym pehẽ” aja apo ihẽ ke putar ym ame'ẽ ta pe pandu ta. Jon pandu ame'ẽ ke rehe Nini ok ta pe har ta hendu katu. Pesarahã! Ko ihẽ axo. Jon 'ar koty te we ihẽ katuha. Anĩ. Ihẽ je'ẽha rehe pehendu ym. (A'erehe pehẽ ke Tupã mupyrara hũ ta.) ");
INSERT INTO urbNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","—Yman rahã, ngã ke Tupã mupyrara ta. Arahã amõ kũjã pu'am ta. Kapitã keruhũ kũjã ke a'e. Pepaite ngi Saromã mu'e ame'ẽ ke rehe hendu uwyr kwe. A'erehe yman rahã, Tupã mupyrara rahã, ame'ẽ kũjã pandu ta: “Jesu je'ẽha rehe pehendu ym. Katu ym pehẽ” aja apo ihẽ ke putar ym ame'ẽ ta pe pandu ta. Pepaite ngi kũjã uwyr. Amõ wata oho rahã, heta ukwer. Warahy jurukwã koty ngi uwyr. Iapyr koty ngi. Ukwa katuha namõ ma'e Saromã mu'e ame'ẽ ke rehe kũjã hendu uwyr. Pesarahã! Ko ihẽ axo. Saromã 'ar koty te we ihẽ akwa katuha. Anĩ. Pehendu ym ihẽ je'ẽha rehe. A'erehe pehẽ ke Tupã mupyrara hũ ta — aja parise ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","A'e pandu tĩ: —Amõ py'a ngi ãjã uhem oho rahã, awa nixói te ame'ẽ rupi wata wata ixo. Putu'uha renda ke kekar tipe ixo. Mahem ym. ");
INSERT INTO urbNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","A'erehe jupandu jupe: “Sawa'e py'a ngi ihẽ ahem ajur. Ame'ẽ pe ajywyr ta aho. Ihẽ rok aja saka ihẽ pe” aja jupandu jupe. Pe, jywyr oho. Pe, uhyk rahã, hok pe nixói amõ. Upa peir katu amõ. Upa mukatu. Aja saka ipy'a ke. ");
INSERT INTO urbNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ame'ẽ ke rehe usak rahã, amõ ãjã ta rehe oho piam. Awa po wajar mokõi hetaha muhyk. Ame'ẽ ta riki i'ar koty te we jaxer ai ame'ẽ ta ke a'eta. Pe, muhyk rahã, sawa'e py'a rehe a'eta ixe oho tĩ. A'erehe ame'ẽ sawa'e mãte jaxer te apo 'y. Ãjã peteĩ ixo rahã, katu ym. Apo heta ihĩ, a'erehe i'ar koty te we jaxeriha — aja parise ta pe Jesu pandu. (Aja awa tĩ. Juehe ixoha jumukatu aja ixo tar katu. Anĩ. Tupã rehe jurujar ym. Nixói ma'e, ame'ẽja saka. A'erehe i'i atu we rahã, ymanihar aja jywyr. Pe, jywyr rahã, i'ar koty te we jaxeriha aja ixo ta.) ");
INSERT INTO urbNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ngã pe Jesu pandu pandu uĩ rahã, imãi uhyk uwyr. Imu ta uhyk uwyr tĩ. Hukwen rake soroka pe a'eta pyta. Pe, amõ pe pandu: —Jesu namõ japandu tar katu. Epandu eho — aja imãi ta. ");
INSERT INTO urbNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","A'erehe amõ pandu Jesu pe: —Esarahã! Soroka pe ne mãi i'ãi. Ne mu ta i'ãi tĩ. Ne namõ pandu tar katu — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pe, Jesu pandu: —Awa riki ihẽ mãi my? Awa riki ihẽ mu ta my tĩ? — aja a'eta pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pe, jumu'eha ta koty ijywa ke mupuku. Pe, pandu: —Pesarahã! Ko riki ihẽ mãi. Ko riki ihẽ mu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ihẽ pái keruhũ riki ywa pe har ke. A'e putar ame'ẽ ke amõ ma'ema'e rahã, ame'ẽ riki ihẽ mu aja saka. Ihẽ rendyr aja saka tĩ. Ihẽ mãi aja saka tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ame'ẽ wera rahã, ame'ẽ ok ke Jesu hijar oho. Ypa rymy'y rehe uhyk oho. A'ep wapyk. Pe, ngã ke mu'e uĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Heta ngã juramã jy'ar ehe. Heta te hũ. A'erehe jarusu keruhũ pe opor oho. Ame'ẽ pe wapyk. Ypa rymy'y rehe ngã pu'am u'am. ");
INSERT INTO urbNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Myja me'ẽ ma'e ra'ĩ my, ame'ẽ ke ngã pe Jesu pandu uĩ. Kuja riki: —Ma'e ra'ĩ ke amõ sawa'e muhãi oho. ");
INSERT INTO urbNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kupixa pe ma'e ra'ĩ muhãi rahã, awa rape rupi amõ ha'ĩ u'ar. Ame'ẽ ke ma'ewyra u'u uwyr. Upa u'u. ");
INSERT INTO urbNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Amõ ma'e ra'ĩ ita ty rupi u'ar. Ywy katu ame'ẽ ke ta'yr mi a'ep. Pe, ha'ĩ hywõi. Ywy heta ym a'ep, a'erehe pahar hywõi. ");
INSERT INTO urbNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pe, warahy haku rahã, i'y manõ. Hapo ipyp oho ym, a'erehe upa te'e manõ. ");
INSERT INTO urbNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Amõ ma'e ra'ĩ juruwe ty rupi u'ar. Juruwe tiha py oho, a'erehe ma'e ra'ĩ hywõi rahã, hury ym, a'erehe i'a ym. ");
INSERT INTO urbNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Amõ ma'e ra'ĩ ywy katu ame'ẽ rehe u'ar. Pe, hywõi rahã, hury katu oho. Tiha katu oho. I'a uhem, pe, tyarõ. Hymbo rehe heta i'a ihĩ. Tirĩ ta (30) aja hetaha. Amõ hymbo rehe heta we hũ i'a ihĩ. Sesen ta (60) aja hetaha. Amõ hymbo rehe heta te hũ i'a ihĩ. Sẽ (100) aja hetaha — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ame'ẽ upa rahã, a'e pandu: —Pehẽ pekwa tar katu rahã, ihẽ apandu ame'ẽ ke rehe pehendu katu ta me'ẽ te'e — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","I'i we Jesu rehe jumu'eha ta uhyk rahã, pandu ipe: —Ngã pe nde erepandu pandu rahã, myja me'ẽ ma'e ke my aja nde erepandu. Ma'erehe my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesu pandu: —Apo amõ koty Tupã mujekwa. Pyahu ame'ẽ ke, ame'ẽja saka. Kuja. Ixoty ipy'a ke amõ muruwak ame'ẽ ke a'e putar katu. “Ihẽma'e a'e” aja a'e pandu. “Ame'ẽ ke nema'e jumu'eha ta pe emujekwa” aja Tupã pandu ihẽ pe. Amõ ta pe anĩ. Amujekwa ym ta. (A'erehe myja me'ẽ ma'e ke my aja apandu pandu.) ");
INSERT INTO urbNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Amõ ukwa wan rahã, amõ we ukwaha ke Tupã muwyr ta ipe. Aja rahã, upa a'e ukwa. (Ukwa tar katu, a'erehe muwyr ta ipe.) Ta'yr te mi amõ ukwa rahã, ame'ẽ ta'yr te mi ukwaha ke Tupã mukanim ta ingi. (Ukwa tar ym, a'erehe mukanim ta ingi.) ");
INSERT INTO urbNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Myja me'ẽ ma'e ke my aja ngã pe ihẽ apandu. Ma'erehe my? Kuja riki. A'eta ma'ã tipe. Usak ym ma'e ke. A'eta hendu tipe. Ukwa ym riki. ");
INSERT INTO urbNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","A'erehe yman Isai pandu aja uhyk. Kuja riki ame'ẽ: “Peme'ẽ ta Tupã je'ẽha rehe hendu hendu tipe. Ukwa ym riki. A'eta usak usak tipe. Ukwa ym ma'e ke. ");
INSERT INTO urbNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Iãkã riki ianam rãi, a'erehe pyhyk ym. Ukwa ym. Ipyakwar ke kynda, ame'ẽja saka. Hendu tar ym. Eha ke jupyk tĩ, ame'ẽja saka tĩ. Usak tar ym. Upa aja ym rahã, upa ma'e ke usak ta. Upa ma'e ke rehe hendu katu ta. Upa ma'e ke ukwa katu ta. Aja rahã, Tupã koty ipy'a ke a'eta muruwak ta. Aja rahã, ipy'a ke Tupã mujywyr ta a'eta rehe” aja Isai pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","—Pehẽ anĩ. (Pehẽ riki ihẽma'e jumu'eha ta ke.) Upa ihẽ ama'ema'e ame'ẽ ke rehe pesak. Upa ihẽ apandu pandu ame'ẽ ke rehe pehendu tĩ. A'erehe jetehar te ke pekwa katu riki. A'erehe pehẽ rury katu ame'ẽ ta ke pehẽ. ");
INSERT INTO urbNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ko apandu pehẽ pe. Ihẽ rehe pesak. Aja ihẽ rehe heta ymanihar Tupã je'ẽha pandu ame'ẽ ta usak tar katu te riki. A'eta usak ym. (Pesak, a'erehe pehẽ rury katu ame'ẽ ta ke pehẽ.) Ihẽ je'ẽha rehe pehendu. Aja ihẽ je'ẽha rehe heta ymanihar Tupã je'ẽha pandu ame'ẽ ta hendu tar katu te tĩ. A'eta hendu ym. (Pehendu, a'erehe pehẽ rury katu ame'ẽ ta ke pehẽ) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","A'e pandu tĩ: —Pehendu katu! Myja me'ẽ ma'e ra'ĩ my aja ihẽ apandu ngã pe. Ame'ẽ ke ihẽ amujekwa ta pehẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Apo amõ koty Tupã mujekwa. Pyahu ame'ẽ ke, ame'ẽja saka. Kuja. Ixoty ipy'a ke amõ muruwak rahã, ame'ẽ ke a'e putar katu. “Ihẽma'e a'e” aja a'e pandu. Ame'ẽ rehe har amõ hendu tipe. Ukwa ym. Ame'ẽ riki ma'e ra'ĩ awa rape rupi u'ar, ame'ẽja saka. Tupã je'ẽha rehe hendu tipe. Pe, ãjã ramũi uhyk rahã, ame'ẽ ke a'e upa mukanim ingi. (Ma'ewyra u'u uwyr, ame'ẽja saka.) ");
INSERT INTO urbNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","—Ita ty rupi amõ ma'e ra'ĩ u'ar. Ame'ẽ riki kuja saka. Tupã je'ẽha rehe hendu rahã, hury katu tipe. (Pahar hywõi, ame'ẽja saka.) ");
INSERT INTO urbNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ame'ẽ Tupã je'ẽha ke ipy'a pe pyta ym. Hury wan riki. Tupã je'ẽha rehe a'e jurujar katu, a'erehe ame'ẽ ke amõ ta mupyrara rahã, pahar jurujar katuha ke hijar. (Warahy upa jukwa, ame'ẽja saka.) ");
INSERT INTO urbNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","—Juruwe ty rupi amõ ma'e ra'ĩ u'ar. Ame'ẽ riki kuja saka. Tupã je'ẽha rehe amõ hendu tipe. Ima'e ixoha rehe har a'e ukwa ukwa ixo. “Ma'e ihẽ a'u ta my? Ma'e ihẽ amunde ta my?” aja ukwa ukwa ixo. Tamatarer ke a'e matyr tar katu hũ tĩ. A'erehe upa Tupã je'ẽha ke mukanim, ame'ẽja saka. Upa harái riki. (A'erehe ma'e i'a ym ame'ẽja saka.) Aja rahã amõ we Tupã rehe har ukwa tar ym. ");
INSERT INTO urbNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","—Ywy katu, ame'ẽ pe amõ ma'e ra'ĩ u'ar. Ame'ẽ riki kuja saka. Tupã je'ẽha rehe hendu. Pe, upa ukwa katu. Aja rahã, amõ hymbo rehe i'a katu. Tirĩ ta (30) aja hetaha. Amõ hymbo rehe heta we hũ i'a ihĩ. Sesen ta (60) aja hetaha. Amõ hymbo rehe heta te hũ i'a ihĩ. Sẽ (100) aja hetaha. (Aja rahã, Tupã rehe har ukwa katu, a'erehe ma'e katu ame'ẽ ke ma'ema'e katu te hũ tĩ. Hymbo rehe i'a heta ihĩ, ame'ẽja saka) — aja Jesu mujekwa jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Amõ myja me'ẽ ma'e ke my, ame'ẽ ke Jesu pandu: —Apo apandu ta pehẽ pe. Yman rahã, upa katu te ngãma'e ma'ema'eha ke Tupã ukwa ta. Katu ame'ẽ ke ma'ema'e my? Jaxer ame'ẽ ke ma'ema'e my? Ame'ẽ ke ukwa ta. Ame'ẽ riki kuja saka. Kupixa pe ma'e ra'ĩ katu ame'ẽ ke sawa'e jytym, ahúi aja me'ẽ ra'ĩ ke. ");
INSERT INTO urbNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Amõ pytun rahã, amõ ta ukwer rahã, kupixa pe sawa'e ruwajan uhyk oho. Pe, ahúi aja me'ẽ pyter pe ahúi aja me'ẽ ran ra'ĩ ke jytym. Pe, oho. ");
INSERT INTO urbNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ahúi aja me'ẽ tiha oho. Pe, hymbo uhem tate rahã, ahúi aja me'ẽ ran tiha oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ame'ẽ ke miasu ta usak rahã, ijar koty uhyk oho. Pandu ipe: “Sa'e! Nema'e kupixa pe ma'e ra'ĩ katu ame'ẽ ke jande jajytym. Myja me'ẽ ahúi aja me'ẽ ran uhem my?” aja ijar pe. ");
INSERT INTO urbNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Miasu ta pe ijar pandu: “Ihẽ ruwajan riki jytym” aja ijar pandu. Miasu ta pandu: “Ahúi aja me'ẽ ran ke jande jahykýi ta jaho my? Aja nde ereputar my?” aja. ");
INSERT INTO urbNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Anĩ. Ahúi aja me'ẽ ran ke pehykýi pemuhem rahã, ahúi aja me'ẽ'y ke pehykýi pemuhem ta my tĩ. Juja katu te saka. ");
INSERT INTO urbNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","A'erehe mã peja ihĩ. Ahúi aja me'ẽ namõ ahúi aja me'ẽ ran pyta. Ahúi aja me'ẽ itawa ym rahã, mã peja ihĩ. Itawa rahã, parakyha ta pe ihẽ apandu ta: ‘Ahúi aja me'ẽ ran ke pemondok py. Pekakwar. Pe, upa hapy. Upa rahã, ahúi aja me'ẽ ke pemondok tĩ. Pe, ame'ẽ ke matyriha renda pe pematyr’ ” aja ijar pandu — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Amõ myja me'ẽ ma'e ke my, ame'ẽ ke Jesu pandu tĩ: —Kome'ẽ ywy keruhũ pe Tupã kotyhar ta ixo. Ame'ẽ riki kuja saka. Kupixa pe ma'e ra'ĩ ta'yr te mi, ame'ẽ ke sawa'e jytym. Mosata ra'ĩ ke. ");
INSERT INTO urbNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Amõ ma'e ra'ĩ wyr koty te we ta'yriha ame'ẽ. Ame'ẽ hywõi. I'y tiha te hũ oho rahã, kupixa pyter pe tiha te ame'ẽ ke a'e. Myra aja tihaha, a'erehe ma'ewyra riki haity mujã ehe. Hãkã rehe mujã — aja pandu. (Aja rahã, Jesu pandu py rahã, Tupã kotyhar ta heta ym te. Ma'e ra'ĩ ta'yr te mi, ame'ẽja saka. I'i atu te rahã, ixotyhar ta heta te hũ ta. I'y tiha te hũ, ame'ẽja saka, aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Amõ myja me'ẽ ma'e ke my, ame'ẽ ke Jesu pandu tĩ: —Kome'ẽ ywy keruhũ pe Tupã kotyhar ta ixo. Ame'ẽ riki kuja saka. Ahúi aja me'ẽ ku'i pe ma'e mupururukiha ke kũjã mupara. Rar tyryhem mupara. Upa rahã, upa ahúi aja me'ẽ ku'i pururuk hũ — aja pandu. (Aja rahã, Jesu pandu py rahã, Tupã kotyhar ta heta ym te. I'i atu te rahã, heta te hũ, aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ngã pe myja me'ẽ ma'e ke my aja jõ Jesu pandu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aja rahã, yman Tupã je'ẽha rehe panduha ihĩ, aja me'ẽ uhyk. Kuja riki: “Ngã pe ma'e ke ihẽ apandu pandu rahã, myja me'ẽ ma'e ke my aja ihẽ apandu ta. Kome'ẽ ywy keruhũ Tupã mujã, ame'ẽ ngi har ma'e ke amõ ukwa ym. Ame'ẽ ke ihẽ apandu pandu ta ngã pe” aja Tupã je'ẽha rehe panduha ihĩ. Ame'ẽ panduha uhyk apo 'y. ");
INSERT INTO urbNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ngã ke Jesu hijar. Pe, hok pe ixe oho. Jumu'eha ta jõ uhyk uwyr ehe. Pandu ipe: —Ahúi aja me'ẽ ran rehe har nde erepandu. Ame'ẽ ke jande pe emujekwa katu — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesu pandu: —Ko awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ma'e ra'ĩ katu ame'ẽ ke sawa'e jytym. Ihẽ riki ame'ẽ sawa'e ke. ");
INSERT INTO urbNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kupixa riki kome'ẽ ywy keruhũ aja saka. Ma'e ra'ĩ katu ame'ẽ riki Tupã kotyhar ta aja saka. Ahúi aja me'ẽ ran riki Satana kotyhar ta aja saka. ");
INSERT INTO urbNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ahúi aja me'ẽ ran ra'ĩ ke sawa'e ruwajan jytym. A'e riki Satana. (Ãjã ramũi a'e.) Itawa rahã, ijar matyr. Ame'ẽ riki 'ar rehe angaha uhyk. Parakyha ta riki Tupã je'ẽha rahoha ta ke. ");
INSERT INTO urbNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ahúi aja me'ẽ ran ke parakyha ta kakwar. Pe, hapy. Aja riki 'ar rehe angaha uhyk ta rahã, (Satana kotyhar ta ke mujy'ar ta tĩ.) Kuja. ");
INSERT INTO urbNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Pesarahã! Tupã je'ẽha rahoha ta ke ihẽ amondo ta. Parakyha ta aja amondo ta. Kome'ẽ ywy keruhũ pe ihẽ amondo ta. Pe, kome'ẽ ywy keruhũ pe har ta ngi upa ma'e ka'u te'eha ke ma'ema'e, ame'ẽ ta ke Tupã je'ẽha rahoha ta mujy'ar ta. Amõ ta pe ngã pandu: “Ma'e peka'u te'eha ke pema'erahã!” aja. Aja pandu ame'ẽ ta ke Tupã je'ẽha rahoha ta mujy'ar ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Pe, upa mujy'ar rahã, tata keruhũ renda pe ombor ta. A'ep ahy te hũ ta, a'erehe jixi'u hũ ta. Ahy te hũ, a'erehe hãi ke su'u su'u rãi. ");
INSERT INTO urbNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tupã kotyhar ta anĩ. Tupã je'ẽha rahoha ta mujy'ar ta tĩ. Pe, jande pái keruhũ koty hury katu te ta. Tupã ixo ame'ẽ pe hury katu te ta. Warahy hendy katu rahã, hury katu awa. Aja Tupã kotyhar ta hury katu te ta. Pehẽ pekwa tar katu rahã, ihẽ apandu ame'ẽ ke rehe pehendu katu ta me'ẽ te'e — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","A'e pandu tĩ: —Tupã ixo ame'ẽ pe amõ oho tar katu te hũ. Ame'ẽ riki kuja saka. Kome'ẽ ywy keruhũ pe har kupixa pe tamatarer hũ ke amõ mukanim. Jytym riki. Ame'ẽ ke amõ riki mahem. Pe, amõ renda pe mutyryk. Jytym tĩ. Hury katu a'e. A'erehe upa ima'e ke a'e muhepy. Pe, ame'ẽ tamatarer pe kupixa ke ijar ngi a'e jo'ok oho. Muhepy. Aja putar katu aja mujekwa — aja Jesu pandu. (Aja rahã, Tupã ixo ame'ẽ pe oho tar katu te hũ, aja mujekwa. A'erehe upa ima'e ke hijar. Pe, ohoha pyhyk katu. Ame'ẽ riki tamatarer keruhũ 'ar koty te we katuha, aja Jesu mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jesu pandu tĩ: —Tupã ixo ame'ẽ pe amõ oho tar katu te hũ. Ame'ẽ riki kuja saka tĩ. Pu'yr aja ame'ẽ ke. Pero ke. Ituwyr ame'ẽ. Ma'e ra'ĩ jupu'a. Ame'ẽ ke amõ sawa'e kekar. Kome'ẽ ywy keruhũ muhepyha renda rupi kekar kekar ixo. Katu te ame'ẽ ke kekar. ");
INSERT INTO urbNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pe, amõ katu te ame'ẽ ke sawa'e mahem rahã, upa katu te ima'e ma'e ke muhepy. Pe, ame'ẽ tamatarer pe ame'ẽ pero ke jo'ok oho. Muhepy. Aja putar katu aja mujekwa — aja Jesu. (Aja rahã, Tupã ixo ame'ẽ pe oho tar katu te hũ, aja mujekwa. A'erehe upa ima'e ke hijar. Pe, ohoha pyhyk katu. Ame'ẽ riki pu'yr hepy te hũ 'ar koty te we katuha, aja Jesu mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","A'e pandu tĩ: —Yman rahã, ngã rehe har Tupã ukwa ta. Katu ame'ẽ ke ma'ema'e my? Ka'u te'eha ke ma'ema'e my? Ame'ẽ ke a'e ukwa ta. Ame'ẽ riki kuja saka tĩ. Kome'ẽ ywy keruhũ pe har ypa pe kyhapari ke pira pyhykiha ta ombor ombor ixo. Upa ma'e pira ke a'eta pyhyk. ");
INSERT INTO urbNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kyhapari tyryhem rahã, ypa rymy'y rehe hykýi raho. Pe, wapyk rahã, pira ke amõ koty koty matyr. Amõ u'u katu ame'ẽ ke wasãkã pe mou. U'u ym ame'ẽ ke ombor. ");
INSERT INTO urbNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","'Ar rehe angaha uhyk rahã, aja ta tĩ. Tupã je'ẽha rahoha ta ohoho. Pe, awa ta pyter ngi katu ym ame'ẽ ta ke a'eta mujy'ar. Katu ame'ẽ ta Tupã koty pyta ta. ");
INSERT INTO urbNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Katu ym ame'ẽ ta anĩ. Tata keruhũ renda pe ombor ta. (Ahy hũ ta,) a'erehe jixi'u hũ ta. (Ahy te hũ ta,) a'erehe hãi ke su'u su'u riki — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jumu'eha ta pe Jesu pandu: —Upa ame'ẽ ihẽ apandu ame'ẽ ke pekwa katu my? — aja. —Upa jakwa katu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Pe, a'e pandu: —Aja rahã, kuja riki. Mu'eha ukwa katu ame'ẽ ke, aja saka. Moise je'ẽha mu'e ame'ẽ ta Tupã kotyhar ta aja jumuruwak rahã, ok jar aja saka. Matyriha renda pe ima'ehũ namõ ixo. Pe, ame'ẽ ngi ma'e pyahu ame'ẽ ke muhem. Ma'e kwehehar ame'ẽ ke muhem tĩ. (Ame'ẽ riki ma'e ke mu'e, ame'ẽja saka tĩ) — aja Jesu pandu. (Aja rahã, Jesu rehe har jetehar te jumu'eha ta mu'e ta. Ame'ẽ riki ma'e pyahu, ame'ẽ ke muhem, ame'ẽja saka. Ymanihar Tupã je'ẽha pandu ame'ẽ ke jetehar te mu'e ta tĩ. Kwehehar ame'ẽ ke muhem, ame'ẽja saka tĩ. Aja Jesu mujekwa katu jumu'eha ta pe.) ");
INSERT INTO urbNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Myja me'ẽ ma'e ke my, ame'ẽ ke Jesu upa pandu rahã, ame'ẽ ok ngi oho. ");
INSERT INTO urbNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Hekoha pe a'e jywyr oho, Nasare ok ta pe. Jundéu awa tama'e jy'ariha renda pe a'e mu'e. Hendu ame'ẽ ta pandu: —Mã! My riki ukwa katuha pyhyk my? Awa a'e ke mu'e my? (Jakwa ym jande.) Marã ka ym amõ ma'eha, ame'ẽ ke a'e ma'ema'e katu te. Mã! Jande aja awa te'e a'e tĩ. Myja ame'ẽ ke ma'ema'e my? (Jakwa ym tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Myra rehe ma'eha ame'ẽ ra'yr Jesu. Mari membyr a'e. Imu ta kohĩ tĩ, jande rekoha pe. Tian. Jose amõ tĩ. Jun amõ tĩ. Simã amõ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Upa hendyr ta jande rekoha pe ixo tĩ. My ngi upa ima'e ukwa katuha ke a'e pyhyk my? (Jande jakwa ym) — aja Jesu rehe har pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","A'erehe Jesu ke a'eta putar ym. (A'erehe a'eta pe Jesu pandu:) —Tupã je'ẽha pandu ame'ẽ ke upa amõ ok ta pe har ta putar katu. Hekoha te pe har ta anĩ. Putar ym. Katu ym aja usak ehe. Ianam ta aja tĩ. Katu ym aja usak ehe tĩ. (Aja ihẽ ke ihẽ rekoha pe har ta putar ym tĩ) — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Awa te'e a'e, aja jõ a'eta ukwaha naĩ. A'erehe a'ep pe har ta jurujar ym ehe. A'erehe marã ka ym amõ ma'eha, ame'ẽ ke heta a'e ma'e ym. (Aja a'e ke kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e aja Jesu mujekwa tar ym a'ep pe har ta pe.) ");
INSERT INTO urbNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jesu ke amõ ta putar ym. Arahã Jesu ma'ema'eha rehe har Ero hendu. A'e riki ngariréi ywy pe har tama'e kapitam. ");
INSERT INTO urbNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Inamõ ixo ame'ẽ ta pe a'e pandu: —Jesu riki Juã mujahukiha ke. Juã ke manõha ngi Tupã mukwera katu muhem tĩ. A'erehe pyrãtã te ha namõ ma'e ke Jesu ma'ema'e katu. Marã ka ym amõ ma'eha, ame'ẽ ke ma'ema'e katu — aja Ero ukwaha naĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Amukwehe te kuja ixo. Ero mu ixo. Her Siri. Siri rakehar rer Erondi. Ame'ẽ imu rakehar ke Ero jo'ok raho ingi. A'erehe Juã pandu ipe: —Peja ym. Ne mu rakehar namõ nde erexo rahã, katu ym tiki — aja Ero pe pandu. Ame'ẽ panduha ke Erondi putar ym. A'erehe Ero pe kũjã pandu: —Kyndaha pe Juã ke ekynda eraho — aja ixawa'e pe. A'erehe sonda ta pe Ero pandu: —Juã ke pepyhyk peho. Pepukwar, pe, kyndaha pe pekynda peraho — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","A'e ke Ero jukwa ta tipe. Juã riki Tupã je'ẽha pandu ame'ẽ ke aja jundéu awa ta ukwa katu. Juã ke jukwa rahã, jundéu awa ta parahy ta. A'erehe Ero kyje. Jundéu awa ta ngi kyje. A'erehe jukwa ym we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","(Pe, jukwaha angaha rehe uhyk 'y.) Yman imãi pusu ngi Ero u'ar. Ame'ẽ u'ariha ke ukwa ukwa uĩ ngã. A'erehe huryha amõ ta mujã. Arahã Erondi membyr riki purahái. Imembyr kũjã ke. Ame'ẽ rehe Ero usak rahã, hury katu. ");
INSERT INTO urbNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","(A'erehe kũjãtãi pe a'e pandu:) —Ma'e ke nde ereputar ame'ẽ ke nde pe ihẽ ame'ẽ ta. Jete katu te atu ihẽ apandu. Ihẽ ame'ẽ ta nde pe. Jete katu te atu ihẽ apandu ym rahã, mã peja Tupã ihẽ ke jukwarahã! — aja Ero pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pe, kũjãtãi pe imãi pandu: “Juã ãkã ke epandu ipe, Ero pe” aja. A'erehe kũjãtãi pandu: —Juã mujahukiha ãkã ihẽ aputar. Ita paratu 'ar pe ihẽ pe erur apo — aja Ero pe. ");
INSERT INTO urbNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ame'ẽ ke rehe Ero hendu rahã, pyai riki. Juã ke jukwa tar ym, a'erehe pyai tipe. A'e pandu ramõ: “Ma'e ke nde ereputar ame'ẽ ke ihẽ ame'ẽ ta nde pe” aja kũjãtãi pe. Ame'ẽ ke rehe upa inamõ ixo ame'ẽ ta hendu tĩ. Panduha aja ma'e ym rahã, huxĩ ta. A'erehe sonda ta pe pandu: —Kũjãtãi putar ame'ẽ ke pema'e peho — aja Ero. ");
INSERT INTO urbNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A'erehe sonda ta ke kyndaha pe mondo. Pe, a'eta Juã ãkã ke mondok ingi. ");
INSERT INTO urbNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ita paratu 'ar pe iãkã ke sonda ta werur. Pe, kũjãtãi pe me'ẽ. Ame'ẽ ke imãi pe kũjãtãi raho. (A'erehe Juã manõ te, aja Erondi ukwa katu 'y.) ");
INSERT INTO urbNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juã namõ jumu'e ixo ame'ẽ ta kyndaha pe oho. Hete ke raho ingi. Pe, jytym raho. Upa rahã, Jesu pe a'eta pandu oho. “Juã ke sonda ta jukwa” aja Jesu pe pandu oho. ");
INSERT INTO urbNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","“Juã ke amõ ta jukwa” aja Jesu hendu rahã, jarusu keruhũ pe opor oho. Y ruwái rehe oho. Awa nixói te ame'ẽ pe oho. Jesu oho ame'ẽ ke rehe ngã hendu. A'erehe ok ta ke hijar, pe, awa rape rupi wata oho. Jesu oho, a'ep a'eta oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jarusu keruhũ ngi uhem oho rahã, heta ngã rehe Jesu usak. Pyrara a'e usak ngã rehe. Pe, ahy ixo ame'ẽ ta ke mukatu. ");
INSERT INTO urbNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ka'aruk koty rahã, jumu'eha ta uhyk ehe. Pandu ipe: —Ka'aruk te apo. Ko awa nixói te ame'ẽ ke ko. Ngã ke emondo sengi. Paite ok ta rupi imi'u ke a'eta jo'ok ta oho — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A'e pandu: —Anĩ. Ame'ẽ ke pehẽ atu peme'ẽ ngã pe. Aja rahã, a'eta oho ym ta — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jumu'eha ta pandu: —Mbeju ke awa po wajar peteĩhar upa jõ kohĩ. Pira ka'ẽ mokõi jõ kohĩ tĩ. Marã ka ym ngã rehe uhykiha. ");
INSERT INTO urbNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Ame'ẽ ke ihẽ pe perur — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ngã pe Jesu pandu: —Kãpĩ 'ar pe upa pewapyk — aja. Pe, mbeju awa po wajar peteĩhar upa a'e pyhyk, mokõi pira ka'ẽ namõ. Ywa rehe a'e ma'ã. Pe, pandu: —Ne jõ riki katu te me'ẽ ke. Jande mi'u ke jande pe nde eremuwyr katu — aja Tupã pe. Pe, mbeju ke a'e mopok. Ame'ẽ ke jumu'eha ta pe me'ẽ. Pandu: —Ngã pe peme'ẽ me'ẽ peraho — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Upa ngã u'u. Uhyk ngã u'u. Pyta we ame'ẽ ke jumu'eha ta matyr matyr. Wasãkã pe matyr. Wasãkã kuja, awa py mokõi hetaha a'eta matyr. ");
INSERT INTO urbNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Upa ngã u'u. Sawa'e ta u'u. Kũjã ta u'u tĩ. Ta'yn ta u'u tĩ. Sawa'e ta jõ hetaha manga rahã, 5.000 sawa'e ta hetaha. ");
INSERT INTO urbNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jumu'eha ta pe Jesu pandu: —Hok pe ngã ke ihẽ amujywyr ta amondo axo rahã, ypa ruwái rehe peho. Jarusu keruhũ pe peho. I'i atu rahã we, ihẽ aho ta kỹ — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jarusu keruhũ pe jumu'eha ta opor oho. Pe, oho ingi. Pe, amõ ta pe pandu: —Pehẽ rok pe pejywyr peho — aja ngã pe. Upa ngã hijar oho rahã, ywy'ã 'ar pe jeje Jesu oho. Tupã namõ a'e pandu pandu oho. Pytun ramõ rahã, a'ep jeje a'e ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Arahã, ypa pyter pe jarusu keruhũ ihĩ. Ywytuhu juwapi uwyr ehe. A'erehe y kotok nupã hũ ehe. ");
INSERT INTO urbNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sapukái je'ẽ tate rahã, Jesu uhyk uwyr ixo a'eta rehe. Y 'ar rupi a'e pyrũ oho ixo. ");
INSERT INTO urbNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ame'ẽ ke rehe jumu'eha ta usak rahã, mukahem hũ ingi. Kuja pandu: —Ãjã riki peme'ẽ — aja ukwaha naĩ. Ahem hũ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pahar a'eta pe Jesu pandu: —Anĩ. Ihẽ te'e ko. Pemukahem ym ihẽ ngi! Pehẽ py'ahu te'e — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pe, Petu pandu: —Sawa'e! Nde te rahã, ihẽ pe epandu: “Y 'ar rupi ihẽ koty ejur” aja epandu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Ejur! — aja Jesu ipe. Pe, jarusu keruhũ ngi Petu uhem oho. Pe, y 'ar rupi Jesu koty a'e wata we oho tipe. ");
INSERT INTO urbNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ywytu keruhũ jupeju hũ. Ame'ẽ ke a'e ukwa rahã, kyje a'e ingi. A'erehe y pe a'e jypypyk. Hãtã pandu: —Sawa'e! Ihẽ ke epyhyk! — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Pahar ipo ke Jesu pyhyk. Pandu ipe: —Mã! Tapijar te'e we nde erejurujar katu ta me'ẽ te'e. Ma'erehe ihẽ rehe nde erejurujar ym my? Katu ym aja — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jarusu keruhũ pe a'eta mokõi opor oho. Pe, ywytuhu ke putu'u. ");
INSERT INTO urbNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jarusu keruhũ pe jumu'eha ta ihĩ. Jesu rehe a'eta py'a ke moĩ moĩ katu. A'eta pandu: —Jetehar te riki. Tupã ra'yr nde — aja jumu'eha ta. ");
INSERT INTO urbNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ypa ke a'eta aha oho rahã, Jenesare ywy pe uhyk oho. ");
INSERT INTO urbNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","A'ep pe har ta usak ehe rahã, pandu: —Ko Jesu uhyk uwyr — aja. A'erehe ame'ẽ renda juramã rupi amõ ta pandu oho: —Jesu pete'e ixo. Upa ahy ixo ame'ẽ ta ke peraho ipe — aja. A'erehe Jesu pe ahy ixo ame'ẽ ta ke ngã werur. ");
INSERT INTO urbNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jesu pe ngã pandu: —Mã peja nema'e mundeha rehe ahy ixo ame'ẽ ta pyhyk. Mã peja mundeha apyr rehe jõ pyhyk — aja riki. Pe, ima'e mundeha ke pyhyk ame'ẽ ta upa katu te katu oho. ");
INSERT INTO urbNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ajame'ẽ ke parise ta uhyk uwyr ehe. Moise je'ẽha mu'e ame'ẽ ta aja tĩ. Uhyk uwyr ehe tĩ. Jerusarẽ ok ta ngi Jesu rehe uhyk uwyr. A'eta pandu ipe: ");
INSERT INTO urbNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Ma'erehe jande ramũi mu'e ame'ẽ ke rehe nema'e jumu'eha ta hendu ym my? Ame'ẽ ta u'u rahã, jande ramũi mu'e, aja ipo ke a'eta kutuk ym riki. Katu ym aja — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Pe, parise ta pe Jesu pandu: —Pehẽ tĩ. Tupã pandu ame'ẽ ke rehe pehendu ym tĩ. Pe, pehẽ atu pemu'e ame'ẽ ke rehe pehendu katu. Katu ym aja. ");
INSERT INTO urbNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tupã pandu: “ ‘Nde pái rehe epy'a katu. Ne mãi rehe aja tĩ. Epy'a katu tĩ’ ” aja riki. —Amõ we tĩ: “ ‘Papa! Nde jaxer’ aja amõ pandu rahã, ame'ẽ ke jundéu awa ta jukwa ta me'ẽ te'e. ‘Mãi! Nde jaxer’ aja pandu rahã, aja tĩ. (Aja rahã, ipái ta rehe ipy'a ym, ame'ẽja saka.) Ame'ẽ ke jukwa tĩ” aja Tupã pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","—Apo amõ koty pemu'e. Ma'e ke pehĩ. Ame'ẽ namõ ipái ta rehe usak katu ta me'ẽ te'e. Anĩ. “Ko Tupãma'e apo 'y. Tupã pe ihẽ ame'ẽ ta, ame'ẽja saka. A'erehe pehẽ pe ihẽ ame'ẽ ym ta apo 'y” aja ipái ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Aja rahã, ame'ẽ namõ ipái ta rehe usak ym ta apo 'y. Aja rahã, Tupã pandu ame'ẽ ke rehe pehendu ym. “Nde pái rehe epy'a katu” ame'ẽ rehe pehendu ym. Anĩ. Pehẽ pemu'e ame'ẽ ke rehe pehendu katu. Katu ym aja. ");
INSERT INTO urbNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Parise ta! Moise je'ẽha mu'e ame'ẽ ta! Mokõi pekwaha pereko ame'ẽ ta ke pehẽ! Yman pehẽ rehe har Isai mujekwa. Ame'ẽ riki jetehar te ke. Kuja a'e mupinim. Tupã pandu: ");
INSERT INTO urbNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","9","“Peme'ẽ ta riki ihẽ pe pandu: ‘Ne jõ riki katu te me'ẽ ke’ aja tipe. Anĩ. Hendu ym ihẽ je'ẽha rehe. Ihẽ rehe ipy'a ke a'eta moĩ moĩ ym tĩ. Hamũi ta je'ẽha ke a'eta mu'e ixo. Kome'ẽ riki Tupã je'ẽha aja a'eta mu'e naĩ” aja Tupã pandu. Aja Isai mupinim. —Aja riki pehẽ tĩ. (Tupã je'ẽha rehe pehendu ym tĩ) — aja parise ta pe Jesu pandu. Moise je'ẽha mu'e ame'ẽ ta pe pandu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ngã pe Jesu pandu: —Se pehẽ pejur. Pehendurahã! Aja rahã, pekwa katu ta. Ipo kutukiha rehe har amujekwa ta. ");
INSERT INTO urbNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ma'e ke juru pe amõ moĩ. Ipo pe moĩ. Ame'ẽ ke amõ py'a ke mujaxer ym. Anĩ. Ma'e ke amõ pandu ame'ẽ ke juru ngi uhem, ame'ẽja saka. Ame'ẽ riki ipy'a jaxeriha ke mujekwa katu — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pe, jumu'eha ta jõ uhyk uwyr ehe. Pandu ipe: —Parise ta pe ymanihar Tupã je'ẽha ke nde erepandu ramõ. Arahã nde rehe a'eta parahy riki. Ame'ẽ ke nde erekwa my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A'e pandu: —A'e tỹ. Akwa riki. Pesarahã! Ihẽ pái keruhũ riki ywatehar a'e. Parise ta mu'e ame'ẽ ke ma'eywa'y aja saka. Ma'eywa'y ke ihẽ pái keruhũ jytym ym rahã, ame'ẽ ke a'e hykýi muhem ta. (Aja rahã, parise ta mu'e naĩ, ame'ẽ ke upa a'e mukanim ta, aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ame'ẽ parise ta rehe har pekwa pekwa ym pexo. Eha ym te ame'ẽ tama'e kapitã ta ke a'eta. Eha ym te, ame'ẽja saka riki. Eha ym te ame'ẽ ke amõ eha ym te ame'ẽ hykýi raho rahã, mokõi riki janãha pe oho ta — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Amõ py'a ke mujaxer, ame'ẽ rehe har Petu pandu: —Ma'e amõ u'u ame'ẽ ke rehe har nde erepandu. Ame'ẽ ke jande pe emujekwa katu. Jakwa ym — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesu pandu: —Mã! Amõ ta aja pekwa ym my tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Pekwa ta me'ẽ te'e. Amujekwa ta. Ma'e ke amõ juru pe moĩ rahã, ame'ẽ ke u'u. Pe, pusu pe oho. A'engi ka'a rahã, uhem tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pe, ma'e ke jurukwar ngi uhem rahã, ame'ẽ riki ma'e pandu, ame'ẽja saka. Aja rahã, ipy'a ngi muhem, ame'ẽja saka. Ame'ẽ riki amõ ke jaxeriha mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ipy'a pe upa ma'e ka'u te'eha ke ukwa ukwa ixo. Pe, ukwa ukwa ixo ame'ẽ ke a'e ma'ema'e tĩ. Ko amõ ke jukwa tar katu. Amõ kũjã rehe ka'u te'e tĩ. Amõ sawa'e rehe ka'u te'e tĩ. Amõ ka'u te'eha ma'ema'eha ke putar katu tĩ. Amõma'e ke mukanim tar katu tĩ. Te'e pandu tar katu tĩ. Amõ rehe juru ai tar katu tĩ. Upa aja ukwa ukwa ixo rahã, ame'ẽ ke ma'ema'e ta tĩ. Katu ym aja. ");
INSERT INTO urbNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Upa ame'ẽ riki amõ ke mujaxer ai. Ipy'a ke juhyk ym, aja ixo. Hamũi ta mu'e, aja ipo ke amõ kutuk ym ha namõ ma'e ke u'u rahã, ame'ẽ ke amõ py'a jaxeriha mujekwa ym — aja Jesu pandu jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","A'engi Jesu oho, jumu'eha ta namõ. Pe, amõ ywy pe oho. Tir ok ta rake ame'ẽ pe oho. Sinõ ok ta rake ame'ẽ ywy tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ame'ẽ ywy pe har uhyk uwyr ehe. Kũjã ke a'e. Jundéu awa aja ym ame'ẽ ke a'e. Hekoha te riki amõ ywy ke. Kanaã ywy ke. Jesu pe a'e pandu: —Sa'e! Ndawi rainõ ke nde. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke nde. Pyrãtãha namõ nde erexo, a'erehe ihẽ membyr ke nde eremukatu katu, aja akwa katu. A'erehe ihẽ rehe epyrara esak! Ihẽ membyr py'a rehe ãjã ihĩ, a'erehe mãte ixo — aja kũjã pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesu pandu ym te ipe. Jumu'eha ta uhyk uwyr ehe. Pandu: —Imembyr emukatu. Pe, emondo sengi. Jande raikwer rupi kũjã wata ixo. Mutyapu hũ riki. Jixi'u hũ riki — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","A'e pandu: —Jundéu awa ta pe jõ ihẽ ke Tupã mondo, a'erehe ihẽ amukatu tar ym. Jundéu awa aja ym kũjã. Jundéu awa ta riki arapuharan ta kanim, ame'ẽja saka riki. Tupã ke hijar oho, a'erehe kanim oho, ame'ẽja saka — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ame'ẽ ke rehe kũjã hendu rahã, uhyk uwyr ehe. Ipynarãi pe wapyk uĩ. (Aja sawa'e katu te ame'ẽ ke kohĩ, a'erehe hendu katu ehe aja mujekwa.) Pandu ipe: —Sa'e! Ihẽ rehe epyrara esak. Ihẽ membyr emukatu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","A'e pandu: —Ta'yn ta mi'u ke jawar ta pe ombor rahã, katu ym — aja kũjã pe. (Aja rahã, jundéu awa tama'e ke jundéu awa aja ym ame'ẽ ta pe me'ẽ rahã, katu ym, aja Jesu mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kũjã pandu: —Sa'e! Ame'ẽ riki jetehar te ke. Anĩ we rĩ. Ijarma'e myrape 'ar ngi u'ar ame'ẽ ke jawar ta u'u riki — aja ipe. (Aja rahã, jawar aja ma'e katu ame'ẽ ke rehe kũjã harõ ta, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Pe, kũjã pe Jesu pandu: —Ihẽ rehe nde erejurujar katu te. Ne membyr ke ihẽ amukatu ame'ẽ ke nde ereputar. Ame'ẽ ke ihẽ ama'e ta kỹ — aja ipe. Arahã imembyr upa katu oho 'y. ");
INSERT INTO urbNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","A'engi Jesu oho tĩ. Ypa rymy'y rake rupi wata ixo. Ngariréi ame'ẽ ypa ke. Pe, ywy'ã rehe jupir rahã, wapyk. ");
INSERT INTO urbNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Heta ngã uhyk uwyr ehe. Ahy ixo ame'ẽ ta ke a'eta werur. Wata katu ym ame'ẽ ta ke werur tĩ. Eha ym te ame'ẽ ta ke aja tĩ. Werur ipe tĩ. Ipy pyrãtã ame'ẽ ta ke aja tĩ. Je'engai ame'ẽ ta ke aja tĩ. Werur ipe tĩ. Heta ahy ixo ame'ẽ ta ke werur ipe. Jesu py rake mou. Pe, upa ame'ẽ ta ke a'e mukatu. ");
INSERT INTO urbNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Je'engai ame'ẽ ta pandu pandu katu. Ipy pyrãtã ame'ẽ ta wata katu tĩ. Wata katu ym ame'ẽ ta wata katu tĩ. Eha ym te ame'ẽ ta upa ma'e ke rehe ma'ã katu tĩ. Ma'e ke rehe usak katu tĩ. Upa aja ngã usak rahã, pandu: —Mã! Katu te hũ! — aja riki. Pandu tĩ: —Ne jõ riki katu te me'ẽ ke — aja Tupã pe. Tupã rehe ipy'a ke jundéu awa ta moĩ moĩ. Ame'ẽ Tupã pe ngã pandu: “Ne jõ riki katu te me'ẽ ke” aja. ");
INSERT INTO urbNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jumu'eha ta pe Jesu pandu: —Se pejur pehẽ! Pesarahã! Peme'ẽ heta ame'ẽ ta ihẽ namõ ixo. Mahapyr ukwer apo. Ngã mi'u nixói ngã pe. A'erehe ngã rehe apyrara ihẽ asak. Hok pe amujywyr amondo rahã, myjahyha ixangwer ym. Ngã mi'u ke ihẽ ame'ẽ ym rahã, hok pe amujywyr tar ym amondo — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jumu'eha ta pandu ipe: —Se awa nixói te ame'ẽ pe jande jaxo. Myja me'ẽ heta ame'ẽ ta pe ngã mi'u ke jame'ẽ ta my? My ngi jajo'ok ta my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","A'e pandu: —Myja hetaha mbeju namõ pexo my? — aja. A'eta pandu: —Kuja, awa po wajar mokõi hetaha kohĩ. Pira ka'ẽ ta'yr mi kohĩ tĩ — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Pe, ngã pe Jesu pandu: —Upa pewapyk! Ywy rehe pewapyk — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pe, mbeju ke a'e pyhyk, pira ka'ẽ namõ. Pe, Tupã pe a'e pandu: —Ne jõ riki katu te me'ẽ ke. Jande mi'u ke jande pe nde eremuwyr katu — aja Jesu pandu. Mbeju a'e mopok. Pira ka'ẽ mupen tĩ. Ame'ẽ ke jumu'eha ta pe me'ẽ me'ẽ. Pandu: —Ngã pe peme'ẽ me'ẽ peraho — aja. Pe, jumu'eha ta me'ẽ me'ẽ raho. ");
INSERT INTO urbNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pe, upa ngã u'u. Uhyk ngã u'u. Pyta we ame'ẽ ke jumu'eha ta matyr matyr. Wasãkã pe matyr. Kuja wasãkã, awa po wajar mokõi hetaha a'eta matyr. ");
INSERT INTO urbNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Sawa'e ta u'u. Kũjã ta u'u tĩ. Ta'yn ta u'u tĩ. Sawa'e ta hetaha ke jõ amõ manga rahã, kuja, 4.000 sawa'e ta hetaha. ");
INSERT INTO urbNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pe, ngã ke Jesu mujywyr mondo, hok pe. Pe, jarusu keruhũ pe a'e opor oho, jumu'eha ta namõ. Pe, amõ ywy pe oho, Mangandã ywy pe. ");
INSERT INTO urbNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Amõ parise ta uhyk uwyr ehe, Jesu rehe. Moise je'ẽha mu'e ame'ẽ ta uhyk uwyr ehe tĩ. Johu ngã pandu ipe: —Marã ka ym amõ ma'eha, ame'ẽ ke mã peja ema'e. Ywa rehe ma'e ke ema'e. Nde erema'e rahã, nde ke Tupã muwyr aja jakwa katu ta — aja Jesu pe. A'eta jurujar tar ym. Jesu jawy rahã, marã ka ym ma'eha rahã, a'e ke Tupã muwyr ym, aja ngã pe pandu ta tipe. A'erehe a'eta manga tipe. ");
INSERT INTO urbNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesu pandu: —Warahy wapyk tate rahã, pepandu: “Ywa riki pirã, a'erehe koĩ warahy katu ta” aja. ");
INSERT INTO urbNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pytuniwe pepandu: “Ywa riki pirã. (Aman pihun tĩ.) A'erehe apo aman ukyr ta” aja. Mã! Aman ukyriha rehe har pekwa. Ywa rehe pesak rahã, pekwa. Ihẽ rehe har anĩ. Ihẽ ke Tupã muwyr ame'ẽ ke pekwa ym. Marã ka ym amõ ma'eha, ame'ẽ ke pyrãtãha namõ ihẽ ama'ema'e. Ame'ẽ ke rehe pesak tipe. Anĩ. Ihẽ riki Tupã muwyr ame'ẽ ke ihẽ aja pekwa ym. ");
INSERT INTO urbNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mã! Katu ym pehẽ. Tupã rehe har pekwa ym tĩ. Marã ka ym amõ ma'eha, ame'ẽ ke pyrãtãha namõ ihẽ ama'ema'e. Ame'ẽ ke rehe pesak tar katu. Anĩ. Ihẽ amujesak ym ta pehẽ pe. Kuja jõ ihẽ amujekwa ta pehẽ pe. Yman Jon pira keruhũ pusu rehe ihĩ. Mokõi a'ep ukwer. Pe, katu jywyr tĩ. Aja rahã, a'e ke Tupã mondo, aja mujekwa ngã pe. Aja ihẽ tĩ — aja Jesu pandu. (Jon aja Jesu tĩ. Jesu manõ te rahã, katu jywyr ta tĩ. Manõha ngi kwera katu uhem tĩ. Aja rahã, Jesu ke Tupã muwyr, aja mujekwa katu tĩ.) Upa pandu rahã, parise ta ke Jesu hijar oho. Amõ koty oho. ");
INSERT INTO urbNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jarusu keruhũ pe ypa ruwái koty jumu'eha ta oho rahã, mbeju ke raho ym. Harái riki. ");
INSERT INTO urbNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Pe, Jesu pandu: —Pesak katu pe'am! Mbeju mupururukiha ke pepyhyk ym, parise tama'e ke. Moise je'ẽha mu'e ame'ẽ tama'e ke aja tĩ. Pepyhyk ym tĩ — aja jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","A'eta pandu pandu a'eta jupe: —Mbeju ke jande jarur ym, a'erehe aja Jesu pandu — aja pandu a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","A'eta pandu pandu a'eta jupe, ame'ẽ ke Jesu ukwa, a'erehe pandu: —Mbeju ke peharái, ame'ẽ rehe har pepandu ym pexo. Mã! Pehẽ mi'u ke ihẽ riki ame'ẽ katu, ame'ẽ rehe pejurujar ym riki. Katu ym aja. ");
INSERT INTO urbNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Pehẽ mi'u ke ihẽ ame'ẽ katu, pehẽ pe, ame'ẽ ke pekwa ta me'ẽ te'e. Kuja, 5.000 sawa'e ta hetaha pe mbeju awa po wajar peteĩhar upa ihẽ amopok. Pe, ihẽ ame'ẽ. Ame'ẽ rehe har pekwa pekwa pexo. Pyta ame'ẽ ke heta wasãkã pemutyryhem. Ame'ẽ rehe har pekwa pekwa pexo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Amõ we tĩ. Kuja, 4.000 sawa'e ta hetaha pe mbeju awa po wajar mokõi ihẽ amopok. Ihẽ ame'ẽ. Ame'ẽ rehe har pekwa pekwa pexo tĩ. Pyta ame'ẽ ke heta wasãkã pemutyryhem tĩ. Ame'ẽ rehe har pekwa pekwa pexo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mbeju rehe har ihẽ apandu ym riki. Mã! Ame'ẽ ke pekwa ym. Parise tama'e mupururukiha rehe pesak te'e kỹ. Sanduse tama'e mupururukiha rehe aja tĩ. Pesak te'e kỹ tĩ — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Arahã jumu'eha ta ukwa katu. Mbeju ke mupururukiha amõ moĩ. Ame'ẽ rehe har Jesu pandu ym, aja a'eta ukwa. Parise ta mu'e ame'ẽ ke mbeju mupururukiha aja saka. Ame'ẽ ta mu'e ame'ẽ ke rehe usak te'e kỹ. “Pejumu'e ym” aja mujekwa. Moise je'ẽha mu'e ame'ẽ ta ke rehe aja tĩ. “Pesak te'e kỹ. Pejumu'e ym tĩ” aja a'eta ukwa tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sesaréi Siri ok ta rake amõ henda túi. A'ep Jesu oho. Arahã jumu'eha ta pe a'e pandu: —Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ rehe har amõ pandu rahã, myja pandu my? — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","A'eta pandu: —Kuja amõ ta: “Juã mujahukiha ke nde” aja je. Amõ ta: “Eri nde. Ymanihar Tupã je'ẽha pandu ame'ẽ ke” aja je. Amõ ta: “Jeremi nde” aja tĩ. Amõ ta: “Amõ Tupã je'ẽha pandu ame'ẽ ke nde” aja je — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesu pandu: —Pehẽrahã! Myja me'ẽ ihẽ rehe har pekwa my? — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simã Petu pandu: —Kirisutu nde. Tupã mu'am ame'ẽ ke nde. Tupã ra'yr ke nde. Tupã riki uhã te hũ ame'ẽ ke a'e — aja ipe. (“Tupã mu'am ame'ẽ ke” aja pandu rahã: “Kapitã keruhũ” aja mu'am, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","—Katu tiki, Simã. Juã ra'yr nde. Ihẽ rehe har jetehar te nde erekwa. Ame'ẽ ke kome'ẽ ywy keruhũ pe har mujekwa ym nde pe. Anĩ. Ihẽ pái keruhũ nde pe mujekwa. Ywa pe har a'e. ");
INSERT INTO urbNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Petu! Ko apandu nde pe. Ita aja saka nde. Ihẽ rehe har nde erepandu, a'erehe amõ amõ we hũ ngã ke ihẽ amu'e katu ta. (Aja rahã, ihẽ rehe a'eta jurujar katu ta.) Pe, a'eta manõ tipe rahã, pyta ym ta. Yman rahã, kwera katu ta uhem tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ihẽ je'ẽha ke nde pe ihẽ amondo. Pe, ihẽ je'ẽha rupi nde erepandu rahã, ihẽ rehe amõ ta jurujar katu ta. Nde erepandu: “Peme'ẽ ema'e ym.” Aja rahã, ame'ẽ ma'eha ke Tupã putar ym tĩ. Nde erepandu: “Ere. Peme'ẽ katu.” Aja rahã, ame'ẽ ma'eha ke Tupã putar tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pe, jumu'eha ta pe Jesu pandu: —Ihẽ riki Kirisutu. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke ihẽ. Ame'ẽ rehe har amõ ta pe pepandu ym — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Arahã har jumu'eha ta pe Jesu mujekwa katu: —Jerusarẽ ok ta pe ihẽ aho ta me'ẽ te'e. Ihẽ ke jundéu awa tamũi ta mupyrara hũ ta. Jundéu awa tama'e pa'ihu ta aja tĩ. Moise je'ẽha mu'e ame'ẽ ta aja tĩ. Mupyrara hũ ta ihẽ ke tĩ. Pe, ihẽ ke jukwa ta. Mokõi aker rahã, mahapyrihar wera rahã, ihẽ ke Tupã mukwera katu ta muhem — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jumu'eha ta ngi Jesu ke Petu hykýi raho. Pe, pandu ipe: —Anĩ. Sawa'e! Aja ym ta. Nde ke amõ ta jukwa ym ta. Tupã putar ym aja — aja Jesu pe naĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pe, Petu koty Jesu uwak. Pandu ipe: —Mã! Nde riki Satana aja saka. (Ãjã ramũi a'e.) Ihẽ ruwajan aja saka. Eho ihẽ ngi. Nde erekwa erekwa exo, ame'ẽ ke Tupã muwyr ym riki. Sawa'e ukwaha namõ nde erepandu. A'erehe ihẽ ke nde eremupyta tar katu naĩ. Katu ym aja — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jumu'eha ta pe Jesu pandu: —Ihẽ namõ amõ ixo tar katu rahã, ima'e putariha ke hijar. Pe, Tupã putar ame'ẽ ke ma'ema'e ta me'ẽ te'e. Pe, ihẽ namõ oho. ");
INSERT INTO urbNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Amõ manõ tar ym. A'erehe a'e pandu: “Anĩ. Jesu rehe ajurujar ym ihẽ” aja. Aja rahã, Tupã namõ ixo ym te ta. Ihẽ rehe amõ jurujar katu, a'erehe a'e ke amõ ta jukwa. Aja rahã, Tupã namõ aja te'e ta a'e ixo. ");
INSERT INTO urbNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Upa katu te kome'ẽ ywy keruhũ pe ma'e katu ame'ẽ ke ihĩ. Ame'ẽ ke amõ jo'ok. Matyr hũ tĩ. Pe, manõ rahã, Tupã namõ ixo ym te ta. Aja rahã, marã ka ym katuha. Uhãha rehe marã ka ym ma'e ke muhepyha. Nixói te ma'e. ");
INSERT INTO urbNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","28","—Ywa ngi ihẽ ajywyr ta tĩ. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ pái keruhũ katuha namõ ajywyr ta. Tupã je'ẽha rahoha ta namõ ajywyr ta. Arahã ma'e katu ame'ẽ ke ihẽ ame'ẽ me'ẽ ta. Katu ame'ẽ ke amõ ma'ema'e katu rahã, ame'ẽ pe ihẽ ame'ẽ hũ ta. Katu ame'ẽ ke amõ ma'ema'e we mi rahã, ame'ẽ pe ihẽ ame'ẽ we mi ta tĩ. Aja myja me'ẽ amõ ma'ema'e, aja ihẽ ame'ẽ ta ipe. —Ko apandu katu pehẽ pe. Se amõ ta ixo. Ihẽ riki kapitã keruhũ, aja a'eta usak ta kỹ. Ame'ẽ ke usak ym rahã we, manõ ym we ta rĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Awa po wajar peteĩ ukwer rahã, ywy'ã keruhũ 'ar pe Jesu jupir oho. Petu ke a'e raho tĩ. Tian amõ tĩ. Imu amõ tĩ. Her Juã. A'eta jõ oho. ");
INSERT INTO urbNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","A'eta usak ixo ehe rahã, amõ koty Jesu uwak. Warahy hendyha aja huwa ke hendy. Ima'e mundeha riki ituwyr te tĩ. Hendy hũ. ");
INSERT INTO urbNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pe, Moise ta rehe mahapyr jumu'eha ta usak. Jesu namõ Moise pandu pandu u'am. Eri amõ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pe, Petu pandu: —Sawa'e! Ko jande ja'am. Katu tiki. Nde ereputar rahã, xipa ihẽ amujã ta. Mahapyr amujã ta. Nde pe amõ. Moise pe amõ tĩ. Eri pe amõ tĩ. (Aja rahã, pepyta we ta rĩ) — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ame'ẽ ke Petu pandu u'am rahã, ywa takãxĩha hendy ame'ẽ ke jupyk. Pe, ame'ẽ ngi panduha uwyr: —Ko riki ihẽ ra'yr. Ihẽ apy'a katu ehe ame'ẽ ke a'e. Ihẽ ke a'e muhury katu. A'e pandu ame'ẽ ke rehe pehendu katu — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ame'ẽ ke rehe jumu'eha ta hendu rahã, mukahem riki. Pe, ywy rehe u'ar oup. Ywy koty huwa ke ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mahapyr sawa'e ta rehe Jesu uhyk uwyr. Ipo ke mujar Petu ta rehe. Pe, pandu: —Pepu'am! Pekyje ym ingi! — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","A'erehe a'eta ma'ã tĩ. Nixói awa. Jesu rehe jõ a'eta usak. ");
INSERT INTO urbNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ywy'ã keruhũ ngi wyjy uwyr ixo rahã, Jesu pandu: —Pesak ramõ ame'ẽ ke amõ ta pe pepandu ym te. Moise ta namõ ihẽ apandu ame'ẽ ke. Manõha ngi ihẽ ke Tupã mukwera katu ta muhem. Arahã jõ pepandu katu — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","(Eri rehe Petu ta usak ramõ,) a'erehe Jesu pe pandu: —Nde riki Kirisutu. Nde ndutar koty Eri riki uwyr py, aja Moise je'ẽha mu'e ame'ẽ ta pandu. Ma'erehe aja pandu my? Eri uwyr ym rĩ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","A'e pandu: —Anĩ. Eri upa uwyr. Ihẽ Kirisutu. Ihẽ ndutar koty Eri riki uwyr py ixo. Ngã pe pandu pandu, aja rahã, ihẽ rehe ngã jurujar katu ta. Aja upa ma'e ke a'e mukatu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ko pehẽ pe ihẽ apandu. Eri uwyr riki. Ngã ukwa ym ehe har. A'eta putar, aja a'e ke a'eta mupyrara. Jukwa riki. Aja ihẽ ke ngã mupyrara ta tĩ. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pe, jumu'eha ta ukwa katu. Eri te rehe har pandu ym. Anĩ. Eri rehe har Jesu pandu rahã, Juã mujahukiha rehe har pandu. Juã riki Eri aja tĩ, aja jumu'eha ta ukwa. ");
INSERT INTO urbNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ywy'ã keruhũ ngi jywyr rahã, heta ame'ẽ ta koty Jesu ta jywyr oho. Uhyk rahã, amõ sawa'e uhyk ehe, Jesu rehe. Ipynarãi pe a'e wapyk. (Aja sawa'e katu te ame'ẽ ke kohĩ, a'erehe hendu katu ehe aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Pandu ipe: —Sawa'e! Ngã mu'eha nde. Ihẽ ra'yr rehe epyrara esak. Manõ manõ a'e ixo. Aja rahã, tata pe a'e u'ar. Amõ rahã, y pe a'e u'ar. ");
INSERT INTO urbNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nema'e jumu'eha ta pe ihẽ ra'yr ke ihẽ arur tipe. Mukatu ym a'eta — aja sawa'e pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesu pandu a'eta pe: —Mã! Pejurujar ym! Katu ym pehẽ! Pehẽ namõ aja te'eha ihẽ axo ym ta. Aja te'eha pejurujar ym ha ihẽ aputar ym. Kurumĩ ihẽ pe erur — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ãjã pe Jesu hãtã pandu. Arahã ãjã uhem oho ingi. Pe, kurumĩ katu u'am. ");
INSERT INTO urbNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pe, Jesu pe jumu'eha ta jõ pandu oho. Heta ame'ẽ ta nixói rahã, pandu oho. Kuja: —Ma'erehe ãjã ke jande jamuhem ym jamondo my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","A'e pandu: —Tupãma'e pyrãtãha rehe pejurujar katuha uhyk katu ym. Ko apandu pehẽ pe. Tupã rehe amõ jurujar katu rahã, upa katu te ma'e ke a'e ma'ema'e katu ta. Ma'e ra'ĩ riki ta'yr te mi, mosata ra'ĩ ke. Ame'ẽ ta'yriha saka, ta'yr mi jurujar katu ehe rahã, peme'ẽ ywy'ã rehe pepandu: “Sengi paite etyryk eho!” aja. Aja rahã, tyryk ta. Aja upa ma'e ke pema'e ta. ");
INSERT INTO urbNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Peme'ẽ kurumĩ py'a rehe ãjã ihĩ. Ame'ẽ ke amõ muhem mondo rahã, Tupã namõ pandu pandu. Ma'e u'uha ke hijar hijar tĩ. Aja jõ rahã, ãjã ke pemuhem katu ta pemondo — aja Jesu pandu jumu'eha ta pe. (“Ywy'am” aja pandu rahã: “Upa ma'e hãtã ma'eha ke” aja a'e mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ngariréi ywy pe Jesu namõ jumu'eha ta jy'ar uwyr. Arahã Jesu pandu: —Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ rehe sawa'e ta ke amõ muhyk ta werur. ");
INSERT INTO urbNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Pe, ihẽ ke ame'ẽ sawa'e ta jukwa ta. Mokõi aker rahã, ihẽ ke Tupã mukwera katu ta muhem — aja jumu'eha ta pe pandu. Ame'ẽ ke rehe hendu rahã, a'eta pyai ixo. ");
INSERT INTO urbNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kapana'ũ ok ta pe jumu'eha ta namõ Jesu uhyk uwyr rahã, Petu koty amõ ta uhyk. Tupã rehe ngã jumu'eha renda keruhũ rehe tamatarer ke a'eta matyr. (Ame'ẽ tamatarer namõ jundéu awa tama'e pa'i ta ma'ema'e ixo.) Matyr ame'ẽ ta Petu pe pandu: —Nema'e mu'eha tamatarer me'ẽ my? Tupã rehe ngã jumu'eha renda keruhũ rehe a'e me'ẽ my? — aja riki. (“Nema'e mu'eha” aja pandu rahã: “Jesu ke” aja ukwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—A'e tỹ. Me'ẽ katu a'e — aja Petu. Ok pe Petu ixe oho. (Tamatarer ke rehe oho.) Arahã Jesu pandu py ipe: —Simã! Myja me'ẽ nde erekwa my? Kome'ẽ ywy keruhũ pe har tama'e kapitã keruhũ pe awa riki tamatarer me'ẽ ipe my? Awa ngi a'e pyhyk my? Ta'yr ta ngi pyhyk my? Amõ ta ngi pyhyk my? — aja Petu pe. (“Ta'yr ta” aja pandu rahã: “Ixotyhar ta ke” aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","A'e pandu: —Amõ ta ngi tamatarer ke a'e pyhyk — aja Jesu pe. —Aja rahã, ta'yr ta kapitã keruhũ pe tamatarer me'ẽ ym ta riki. Aja ihẽ tĩ. Tupã ra'yr ihẽ. A'erehe Tupã rehe ngã jumu'eha renda keruhũ pe ihẽ ame'ẽ ym ta me'ẽ te'e. ");
INSERT INTO urbNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Anĩ. Peme'ẽ tamatarer matyr ame'ẽ ta ke jamuparahy tar ym. A'erehe tamatarer jame'ẽ ta. A'erehe ypa pe eho. Pinda embor. Pira nde erepyhyk py, ame'ẽ jurukwar rehe esak katu. A'ep tamatarer nde eremahem ta. Ame'ẽ ejo'ok. Pe, tamatarer matyr ame'ẽ ta pe eme'ẽ. Ame'ẽ riki Tupã rehe ngã jumu'eha renda keruhũma'e ke. Uhyk katu ta. Nema'e ke rehe uhyk katu ta. Ihẽma'e ke rehe aja tĩ. Uhyk katu ta tĩ — aja Petu pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Arahã, Jesu rehe jumu'eha ta uhyk uwyr. Pandu ipe: —Nde namõ jande riki kapitã keruhũ aja jaxo rahã, jande ngi har awa riki amõ ta 'ar koty te we katu te me'ẽ ke my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Pe, ta'yn pe a'e pandu: —Ejur — aja. Pe, jumu'eha ta ruwa koty ta'yn ke a'e mupu'am. ");
INSERT INTO urbNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Pandu: —Ko apandu pehẽ pe. Pehẽ py'a pemuruwak, pe, ta'yn ta aja pehẽ. Aja ym pehẽ pexo rahã, ihẽ namõ kapitã keruhũ aja pexo ym ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ihẽ namõ kapitã keruhũ aja amõ ixo rahã: “Katu te ame'ẽ ke ihẽ” aja ym ixo. Ta'yn ta aja muruwak. Ame'ẽ riki amõ ta 'ar koty te we katu ame'ẽ ke. ");
INSERT INTO urbNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kome'ẽja ta'yn ke hok pe mupyta katu, ihẽ kotyhar ke, a'erehe pandu ipe: “Ko nde erejur katu. Ihẽ rok pe epyta katu” aja. Aja rahã, ihẽ ke hok pe mupyta katu tĩ — aja jumu'eha ta pe Jesu pandu. (Aja rahã, upa Jesu kotyhar ta rehe amõ hury katu rahã, Jesu rehe hury katu tĩ, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jesu pandu tĩ: —Ihẽ rehe amõ amõ ta'yn ta jurujar katu. Pe, amõ pandu: “Mã! Jesu rehe pejurujar katuha ke pehijar” aja. A'erehe ta'yn ta hijar. Aja rahã, mã peja pandu ame'ẽ jurupy rupi itahu pukwar. Pe, itahu namõ a'e ke ypa pe ombor. Pe, y jukwa. (Aja rahã, ta'yn ta ke mu'e ym ta.) Aja manõ rahã, Tupã mupyraraha 'ar koty te we katuha. Tupã mupyrara rahã, mupyrara te hũ ta. ");
INSERT INTO urbNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mã! Kome'ẽ ywy keruhũ pe har ta ma'e ke rehe usak. Ma'e ke rehe hendu. A'erehe ihẽ rehe jurujar katuha ke hijar. Aja rahã, mã katu ym. Aja ihẽ rehe jurujar katuha ke hijar ame'ẽ ta ixo. Pe, amõ pandu: “Tupã rehe nde erejurujar katuha ke ehijar” aja. A'erehe hijar. Aja rahã, mãte hũ pandu ame'ẽ ke Tupã mupyrara ta. “Ehijar” aja pandu ame'ẽ ke mã katu ym te — aja pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jesu pandu tĩ: —Nde po pe amõ amõ ma'e ke nde erema'ema'e, a'erehe ma'e nde ereka'u te'eha ke nde erema'e. A'erehe ihẽ rehe nde erejurujar katuha ke nde erehijar. Aja rahã, ame'ẽ nde erema'eha ke ema'e ym. Nde erema'e ym rahã, nde po ke nde eremondok, ame'ẽja saka. Nde po peteĩ nixói, aja Tupã koty nde ereho ta rahã, katu tiki. Mokõi nde po rahã, mupyraraha renda pe nde ereho ta rahã, katu ym te tiki. —Nde py aja tĩ. Amõ amõ ma'e renda pe nde erewata ereho, a'erehe ma'e nde ereka'u te'eha ke nde erema'e. A'erehe ihẽ rehe nde erejurujar katuha ke nde erehijar. Aja rahã, eho ym. Nde ereho ym rahã, nde py nde eremondok, ame'ẽja saka. Nde py peteĩ nixói, aja Tupã renda pe nde ereho ta rahã, katu tiki. Mokõi nde py rahã, mupyraraha renda pe nde ereho ta rahã, katu ym te tiki. ");
INSERT INTO urbNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","—Amõ amõ ma'e ke rehe nde eresak, a'erehe ma'e nde ereka'u te'eha ke nde erema'e. A'erehe ihẽ rehe nde erejurujar katuha ke nde erehijar. Aja rahã ma'e ke rehe esak ym. Nde eresak ym rahã, nde reha nde erejo'ok, ame'ẽja saka. Nde reha peteĩ nixói, aja Tupã renda pe nde ereho ta rahã, katu tiki. Mokõi nde reha rahã, mupyraraha renda pe nde ereho ta rahã, katu ym te tiki — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","A'e pandu tĩ: —Kome'ẽ ta'yn riki jaxer, aja ym pekwa pexo. Ko apandu pehẽ pe. Ima'e Tupã je'ẽha rahoha ta riki ihẽ pái namõ ixo. A'erehe ta'yn ta rehe har ihẽ pái namõ a'eta pandu pandu. Ihẽ pái riki ywa pe har a'e — aja Jesu. (“Ta'yn ta rehe har” Jesu pandu rahã: “Ixotyhar ta rehe har” a'e pandu.) ");
INSERT INTO urbNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Jesu pandu tĩ: —Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ma'e ka'u te'eha ke amõ ma'ema'e, ame'ẽ ta ke ihẽ amuhã ajur. (Ame'ẽ ta riki kanim ame'ẽ ta aja saka.)  ");
INSERT INTO urbNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","—Pesarahã! Heta arapuharan ta namõ amõ ixo. Kuja, 100 hetaha ke. Pe, peteĩhar kanim oho rahã, myja me'ẽ ijar ma'e ta my? Myja me'ẽ pekwa my? Kuja riki. Heta ame'ẽ ta ke ijar mupyta. Ywy'ã rehe kãpĩ u'u ixo. Aja mupyta. Pe, kanim ame'ẽ ke a'e kekar kekar oho. ");
INSERT INTO urbNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mahem rahã, hury katu a'e. Ko apandu pehẽ pe. Heta ame'ẽ ta kanim ym. Pe, ame'ẽ peteĩhar kanim ame'ẽ ke rehe heta ame'ẽ ta 'ar koty te we huryha. ");
INSERT INTO urbNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aja riki pehẽ pái keruhũ tĩ. Ywa pe har a'e. Kome'ẽ ta'yn ta riki kanim oho ame'ẽ ke aja a'e putar ym — aja Jesu pandu. (Aja rahã, amõ ke mupyraraha renda pe oho, ame'ẽ ke Tupã putar ym, aja Jesu mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","A'e pandu tĩ: —Nde rehe ma'e ka'u te'eha ke ne mu ma'e rahã, ixoty eho. Pe, a'e ma'eha ke emujekwa. “Mã peja ehijar” aja epandu ipe. Pehẽ jõ mokõi pe'am rahã, pepandu pehẽ jupe. Amõ ta ukwa ym ha rupi pepandu pehẽ jupe. Nde rehe hendu katu rahã, nde rehe ne mu ipy'a jywyr ta. Katu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nde rehe a'e hendu ym rahã, amõ mokõi sawa'e ta ne namõ nde ereho. Mokõi nixói rahã, peteĩ eraho. Aja rahã, ame'ẽ ta riki ne mu pe nde erepandu ame'ẽ ke rehe hendu ta tĩ. Pe, ame'ẽ ta pandu ta tĩ. “Ma'e nde ereka'u te'eha nde erema'eha ke ehijar” aja ta tĩ. Kuja Tupã je'ẽha rehe panduha ihĩ. “ ‘Katu ym nde erema'e’ aja amõ pe nde erepandu rahã, ame'ẽ ke amõ mokõi hendu katu tĩ. Mokõi ym rahã, mahapyr hendu ta. Pe, nde erepandu, ame'ẽ ke a'eta mujekwa katu ta tĩ” aja riki panduha ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","—Pe, ame'ẽ mokõi sawa'e ta juja katu te pandu ame'ẽ ke rehe ne mu hendu ym rahã, upa jumu'eha renda pe jy'ar, ame'ẽ ta pe nde erepandu tĩ. Upa ne mu rehe har epandu. Pe, jumu'eha renda pe jy'ar ame'ẽ ta ne mu pe pandu ta tĩ. “Ma'e nde ereka'u te'eha nde erema'eha ke ehijar” aja ta tĩ. Ame'ẽ rehe ne mu hendu ym rahã, a'e riki jaxer ai ame'ẽ ke, aja pekwa ehe har. Tupã rehe ipy'a ym aja ixo ta, aja pekwa ehe har tĩ. Jaxer ame'ẽ riki ne mu, aja pekwa ehe har tĩ — aja Jesu pandu. (“Amõ imu rehe har” Jesu pandu rahã: “Ixotyhar rehe har” a'e pandu.) ");
INSERT INTO urbNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","A'e pandu tĩ: —Ko pehẽ pe ihẽ apandu. Kome'ẽ ywy keruhũ pe Tupã kotyhar ta ixo. Ame'ẽ ta pe pepandu: “Pema'e ym” aja. Aja rahã, aja Tupã pandu ta tĩ. Pe, Tupã kotyhar ta pe pepandu: “Katu. Ma'e ke pema'e katu” aja. Aja rahã, aja Tupã pandu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ko amõ we ihẽ apandu. Ma'e ke Tupã namõ pepandu pandu. Pehẽ ngi har mokõi ame'ẽ ta juja katu te pandu rahã, ame'ẽ ma'e ke jande pái keruhũ muwyr ta ame'ẽ ta pe. Ywa pe har a'e. ");
INSERT INTO urbNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pe, ihẽ rehe ipy'a ke amõ ta moĩ moĩ tar katu, a'erehe jy'ar uĩ. Pehẽ ngi har mahapyrihar jõ jy'ar rahã, ame'ẽ ta namõ ihẽ axo ta tĩ. Mahapyrihar nixói rahã, mokõihar jõ jy'ar rahã, ame'ẽ ta namõ ihẽ axo ta tĩ — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jesu pe Petu pandu uwyr: —Sawa'e! Ma'e ka'u te'e ame'ẽ ke ihẽ pe ihẽ mu ma'e rahã, ihẽ py'a ihẽ amujywyr ehe. Myja hetaha ihẽ py'a amujywyr ta ehe my? Awa po wajar mokõi hetaha my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesu pandu: —Anĩ. Awa po wajar mokõi jõ aja ym. Heta te hũ nde py'a emujywyr ehe. Marã ka ym nde eremangaha. Aja nde py'a emujywyr ehe. ");
INSERT INTO urbNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Amõ ta rehe Tupã ipy'a jywyr katu. Ame'ẽ ke pehẽ pe ihẽ amu'e ta. Kuja riki. Yman amõ ywyma'e kapitã keruhũ ixo. Myja tamatarer hetaha ke miasu ta jo'ok ingi my? Ame'ẽ ke kapitã keruhũ ukwa ta. ");
INSERT INTO urbNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","A'erehe miasu ta ke amõ ta werur werur ipe. Kapitã keruhũ ukwa ukwa uĩ ramõ rahã, amõ ke amõ ta muhyk. Ame'ẽ riki tamatarer heta te hũ kapitã keruhũ ngi jo'ok. Mujywyr ym riki. ");
INSERT INTO urbNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Marã ka ym mujywyriha. Nixói te miasuma'e tamatarer. A'erehe kapitã keruhũ pandu: “Kome'ẽ miasu ke emuhepy eho. Amõma'e wan ta. Amõ pe te'e paraky ta. Nde eremuhepy rahã, tamatarer ihẽ pe erur. Hakehar ke emuhepy tĩ. Ta'yr ta aja tĩ. Tajyr ta aja tĩ. Upa ima'e ke aja tĩ. Emuhepy. Pe, tamatarer ihẽ pe erur. Muhepyha riki” aja kapitã keruhũ pandu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pe, ipynarãi pe miasu wapyk. Kapitã keruhũ ruwa koty wapyk. Pandu ipe: “Eharõ we rĩ. Upa katu te tamatarer ke nde pe ihẽ amujywyr ta” aja miasu. ");
INSERT INTO urbNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kapitã keruhũ pyrara usak ehe. A'erehe pandu ipe: “Katu. Upa ihẽ aharái apo 'y. Tamatarer ihẽ pe emujywyr ym ta me'ẽ te'e. Eho te'e 'y” aja. ");
INSERT INTO urbNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","—Soroka pe ame'ẽ miasu oho ramõ rahã, ianam ke rehe a'e usak, amõ miasu ke rehe. Ta'yr te mi tamatarer ke ame'ẽ mujywyr ym. Pe, ame'ẽ jurupy rupi miasu hãtã pyhyk. Pandu ipe: “Ihẽ ngi tamatarer nde ereraho. Ame'ẽ ke emujywyr” aja. ");
INSERT INTO urbNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ipynarãi pe ame'ẽ ianam wapyk. Pe, pandu: “Eharõ we rĩ. Pe, upa tamatarer nde pe ihẽ amujywyr ta” aja. ");
INSERT INTO urbNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Miasu pandu: “Anĩ. Aharõ ym ta” aja. Pe, ianam ke kyndaha pe kynda raho. Upa katu te tamatarer mujywyr ym rahã, uhem ym ta riki. ");
INSERT INTO urbNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","—Ame'ẽ ke amõ miasu ta ukwa rahã, parahy riki. Pe, upa katu te ijar pe a'eta pandu oho. ");
INSERT INTO urbNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","A'erehe miasu ke ijar muhyk tĩ. Pandu ipe: “Mã! Jaxer ame'ẽ ke nde. Tamatarer heta te hũ ihẽ pe nde eremujywyr ym. Upa katu te ihẽ aharái riki. Nde erepandu ihẽ pe. ‘Marã ka ym ihẽ amujywyriha nde pe. A'erehe eharái katu’ aja riki. A'erehe upa katu te ihẽ aharái. ");
INSERT INTO urbNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nde rehe apyrara ihẽ asak, aja amõ miasu rehe nde erepyrara eresak ta me'ẽ te'e” aja ijar. ");
INSERT INTO urbNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ame'ẽ miasu rehe kapitã keruhũ parahy. Amõ rehe ame'ẽ miasu pyrara ym usak, a'erehe parahy ehe. (Amõ sawa'e pe pandu:) “Kyndaha pe peme'ẽ ekynda eraho. Tamatarer upa katu te ihẽ pe mujywyr ym rahã, a'ep a'e ke nupã ta amõ” aja kapitã keruhũ pandu — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","A'e pandu tĩ: —Ame'ẽ kapitã keruhũ aja ihẽ pái keruhũ tĩ. Pehẽ mu rehe pehẽ py'a pemujywyr ym rahã, aja pehẽ ke ihẽ pái keruhũ mupyrara ta tĩ. A'e riki ywa pe har a'e — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ipy'a jywyriha rehe har upa pandu rahã, Ngariréi ywy ke Jesu hijar. Pe, Jundéi ywy rehe a'e oho. Jumu'eha ta oho tĩ. Oho rahã, Jondã y ruwái rehe oho. ");
INSERT INTO urbNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Heta ngã haikwer rupi oho tĩ. Pe, ahy ixo ame'ẽ ta ke a'e mukatu a'ep. ");
INSERT INTO urbNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Amõ parise ta uhyk uwyr ehe. Jesu panduha ke a'eta manga uwyr tipe. A'e jawy rahã, a'eta pandu ta tipe: “Jaxer ame'ẽ ke nde erepandu” aja. A'erehe kuja a'eta pandu: —Upa ma'e amõ putar rahã, hakehar ke a'e hijar katu my? Myja me'ẽ jundéu awa ta je'ẽha mujekwa my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A'e pandu: —Tupã je'ẽha rehe pesak riki. Kuja amõ mupinim: “Ma'e ke Tupã mujã py rahã, sawa'e ke a'e mujã. Kũjã ke mujã tĩ” aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","—Amõ we tĩ: “Jumendar rahã, ipái ta ke sawa'e hijar, pe, hakehar namõ ixo katu. Ame'ẽ mokõihar riki peteĩhar aja ixo apo 'y” aja. ");
INSERT INTO urbNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","—A'erehe ame'ẽ ta riki mokõi ym. Peteĩhar aja ixo apo 'y. A'erehe peteĩhar aja Tupã riki mujã. Ame'ẽ ke sawa'e mumokõi rahã, katu ym tiki — aja Jesu. (“Mumokõi” aja pandu rahã: “Hakehar ke ixawa'e hijar” aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parise ta pandu ipe: —Aja rahã, ma'erehe Moise pandu my: “Hakehar ke amõ hijar rahã, paper rehe mupinim: ‘Nde ihẽ rakehar ym apo 'y’ aja. Pe, ipái ta koty hakehar ke mujywyr mondo, paper namõ” aja riki Moise — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","A'e pandu: —Jundéu awa ta iãkã jumujanam ngã juehe. Tupã je'ẽha rehe hendu tar ym, a'erehe Moise pandu: “Hakehar ke amõ hijar rahã, katu we” aja. Ma'e ke Tupã mujã py rahã, anĩ riki. Hakehar amõ hijar rahã, katu ym arahã. ");
INSERT INTO urbNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","A'erehe apandu pehẽ pe. Hakehar ipy'a wapyk katu tipe. Ame'ẽ ke ixawa'e hijar, pe, amõ kũjã ke pyhyk rahã, hakehar aja ym namõ jumusarái. Katu ym aja — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jumu'eha ta pandu: —Aja rahã, amõ jumendar ym rahã, katu tiki — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesu pandu: —Aja upa sawa'e ma'e ym ta. Tupã mujekwa rahã, pe, sawa'e jumendar ym ta. ");
INSERT INTO urbNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Amõ koty koty ukwa, a'erehe amõ amõ sawa'e jumendar ym. Amõ ta marã ka ym jumendariha. Imãi pusu ngi u'ar rahã ngi har aja riki. Marã ka ym jumendariha. Ehe ihĩ ame'ẽ ke nixói. Aja te'eha u'ar. Amõ ta amõ koty. Ame'ẽ ta ngi ehe ihĩ ame'ẽ ke amõ ta mondok, a'erehe marã ka ym jumendariha. Amõ ta Tupãma'e ma'eha ke ma'ema'e, a'erehe jumendar tar ym. Tupã rehe har pandu pandu oho. Ame'ẽ riki ima'e ma'eha. Ame'ẽ ke ma'ema'e, a'erehe jumendar tar ym rahã, mã peja ixo te'e — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ta'yn ta ke amõ ta werur ipe. Ipo ke ta'yn ta ãkã rehe Jesu mujar ame'ẽ ke a'eta putar. (Ipo mujar rahã, Tupã usak katu a'eta rehe, aja mujekwa.) Ta'yn ta rehe har Tupã namõ a'e pandu pandu, ame'ẽ ke a'eta putar tĩ. A'erehe werur ipe. Anĩ. Jumu'eha ta je'ẽ je'ẽ: —Mã! Jesu ma'ema'e ixo. A'erehe perur ym ipe — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesu pandu: —Anĩ. Mã peja ta'yn ta ihẽ rehe uhyk katu. Ta'yn ta ke se pemuhyk perur. Pemupyta ym. Aja riki Tupã putar tĩ. Kome'ẽ ta'yn ta aja me'ẽ Tupã kotyhar wan ta tĩ — aja jumu'eha ta pe. (Ta'yn ta aja ixo rahã: “Katu te ame'ẽ ta ke jande” aja ym ukwa, a'erehe pahar Tupã koty ipy'a ke muruwak, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pe, ipo ke ta'yn ta ãkã rehe Jesu mujar mujar. Upa rahã, a'engi a'e oho. ");
INSERT INTO urbNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Amõ rahã, amõ sawa'e uhyk uwyr ehe. Pandu: —Sawa'e! Ngã mu'eha nde. Myja me'ẽ katu ame'ẽ ke ihẽ ama'ema'e rahã, ihẽ ke Tupã muhã katu ta my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","A'e pandu: —Katu ame'ẽ ke nde erema'ema'e, ame'ẽ rehe har mã peja ihẽ pe epandu ym. (Nde erekwa riki.) Katu te ame'ẽ ke peteĩhar jõ ixo. Tupã a'e. Nde ke Tupã muhã katu, ame'ẽ ke nde ereputar rahã, a'e pandu ame'ẽ ke ema'ema'e katu — aja sawa'e pe. ");
INSERT INTO urbNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—Ma'e Tupã pandu my? — aja sawa'e pandu ipe. Jesu pandu: —Amõ ke ejukwa ym. Amõ kũjã rehe eka'u te'e ym. Amõma'e ke emukanim ym. Amõ rehe har te'e epandu ym. ");
INSERT INTO urbNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nde pái rehe epy'a katu. Ne mãi rehe aja tĩ. Epy'a katu tĩ. Nde erepy'a katu nde juehe, aja ne namõ ixo ame'ẽ ta rehe epy'a katu tĩ — aja ipe. (“Ne namõ ixo ame'ẽ ta” aja Jesu pandu rahã: “Upa amõ ta rehe ipy'a katu ta me'ẽ te'e” aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sawa'e pandu: —Upa aja Tupã pandu ame'ẽ ke rehe ihẽ ahendu katu. Myja amõ we ihẽ ama'e rahã, ihẽ ke Tupã muhã katu ta my? — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesu pandu ipe: —Katu te aja nde erexo tar katu rahã, upa katu te nema'e ke emuhepy eho. Pe, tamatarer nde erepyhyk rahã, upa katu te ame'ẽ ke ima'e ym te ame'ẽ ta pe te'e eme'ẽ me'ẽ. Aja rahã, ma'e katu ame'ẽ ke Tupã koty nema'ehũ ta. Pe, ihẽ namõ eho — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ame'ẽ ke rehe sawa'e hendu rahã, pyai riki. Ima'ehũ namõ ixo ame'ẽ ke a'e. (Ame'ẽ ke te'e me'ẽ tar ym) a'erehe pyai oho ingi. (Ima'e ke muhepy tar ym tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ame'ẽ ke rehe usak rahã, jumu'eha ta pe Jesu pandu: —Ko apandu pehẽ pe. Tupã putar, aja amõ ixo katu. Aja tamatarer rehe ipy'a moĩ moĩ ame'ẽ ta mã Tupã putar aja ixo tar ym te. ");
INSERT INTO urbNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ko apandu tĩ. Awi jupiha kwar rupi marã ka ym amõ rymba asa ohoha. Kame, ame'ẽ rymba asa ohoha ke. Pe, ima'ehũ namõ ixo ame'ẽ ta i'ar koty te we marã ka ym Tupã putar aja ixoha — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ame'ẽ ke jumu'eha ta hendu rahã, pandu: —Mãte hũ puki! Aja rahã, awa ke Tupã muhã katu ta my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jumu'eha ta rehe Jesu usak. Pe, pandu: —Ame'ẽ ke sawa'e ta marã ka ym ma'eha. Tupã anĩ. Upa katu te a'e ma'e katu. Amõ ke a'e riki muhã katu ta — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pe, Petu pandu: —Esarahã! Sawa'e pe nde erepandu, aja upa katu te jandema'e ke jahijar jajur. Pe, ne namõ jaxo 'y. A'erehe ma'e jande pe Tupã muwyr ta my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","A'e pandu: —Hã! Pesarahã! Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ko apandu pehẽ pe. Upa ma'e ke Tupã mupyahu rahã, kapitã keruhũ aja ihẽ axo ta. Ngã ke ihẽ amondo mondo ta axo. Arahã pehẽ riki kapitã wan ta tĩ. Pehẽ awa py mokõi sawa'e ta. Jundéu awa tama'e kapitã ta ke pehẽ tĩ. A'eta ke pemondo mondo ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","—Ihẽ rehe har amõ pandu tar katu, a'erehe hok ke hijar oho. Imu ta ke hijar tĩ. Hendyr ta ke hijar tĩ. Ipái ke hijar tĩ. Imãi ke hijar tĩ. Ta'yn ta ke hijar tĩ. Kupixa ke hijar tĩ. Aja rahã, upa katu te aja ixo ame'ẽ ta pe ma'e heta te hũ Tupã mujywyr ta. Pe, ame'ẽ ta ke a'e muhã katu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","—Ixoty uhyk rahã, upa katu te uhyk ame'ẽ ta rehe juja katu te Tupã me'ẽ me'ẽ ta. Tupã kotyhar aja muruwak py, ame'ẽ ta rehe Tupã usak katu ta. Tupã kotyhar aja a'ejõhar muruwak, ame'ẽ ta rehe juja katu te a'e usak katu ta tĩ — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesu pandu tĩ: —Yman rahã, ixotyhar ta pe ma'e katu ame'ẽ ke Tupã me'ẽ me'ẽ. (Juja katu te ngã rehe a'e usak katu ta.) Ame'ẽ ma'ema'eha kuja riki. Pytuniwe te rahã, parakyha ta pe amõ sawa'e pandu oho. Ame'ẽ ta rehe usak rahã, sawa'e pandu: “Ihẽma'e kupixa pe peparaky peho. ");
INSERT INTO urbNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Peteĩ wera rahã, peparaky. Peteĩ wera rahã muhepyha, ame'ẽ tamatarer pehẽ pe ihẽ ame'ẽ ta” aja kupixa jar pandu. “Katu. Jaho ta kỹ” aja parakyha ta. A'erehe a'eta ke kupixa pe ijar mondo. ");
INSERT INTO urbNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","—Ywa ku'a rahã, ma'e muhepyha renda pe kupixa jar oho tĩ. Amõ sawa'e ta i'ãi rĩ. Te'e ixo. ");
INSERT INTO urbNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kupixa jar pandu: “Ihẽma'e kupixa pe peparaky peho tĩ. Ma'e katu ihẽ akwa, aja pehẽ pe ihẽ amuhepy ta” aja ijar. “Hã!” aja sawa'e ta. A'erehe ame'ẽ ta kupixa pe paraky oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","—Warahy jandar rahã, aja tĩ. Muhepyha renda pe kupixa jar oho tĩ. Parakyha ta ke kupixa pe mondo tĩ. —Warahy ywa ku'a ihon rahã, aja tĩ. Muhepyha renda pe kupixa jar oho tĩ. Amõ sawa'e ta rehe usak rahã, kupixa pe mondo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","—Ka'aruk koty rahã, muhepyha renda pe kupixa jar oho rahã, amõ sawa'e ta i'ãi rĩ. Ijar pandu: “Ma'erehe te'e pexo se my?” aja sawa'e ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Sawa'e ta pandu: “Peparaky peho. Amuhepy ta” aja jande pe pandu ym awa, aja kupixa jar pe. “Aja rahã, ihẽma'e kupixa pe peparaky peho apo” aja riki kupixa jar. A'erehe ame'ẽ ta paraky oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","—Pytun ramõ rahã ima'e tamatarer usakiha ame'ẽ miasu pe kupixa jar pandu: “Parakyha ta ke emujy'ar. Tamatarer ke eme'ẽ me'ẽ. Kupixa pe a'ejõhar oho ame'ẽ ta pe eme'ẽ py. Ka'aruk koty oho ame'ẽ ta pe tamatarer eme'ẽ py. A'engi warahy ywa ku'a ihon rahã oho ame'ẽ ta pe eme'ẽ tĩ. A'engi warahy jandar rahã oho ame'ẽ ta pe eme'ẽ tĩ. A'engi ywa ku'a rahã oho ame'ẽ ta pe eme'ẽ tĩ. Pe, a'ejõhar pytuniwe rahã oho ame'ẽ ta pe eme'ẽ tĩ” aja kupixa jar. ");
INSERT INTO urbNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","—Ka'aruk koty paraky oho ame'ẽ ta pe tamatarer ke miasu me'ẽ. Peteĩ wera rahã, wetep muhepyha me'ẽ riki. ");
INSERT INTO urbNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","A'erehe amõ ta kuja: “Éi! Ame'ẽ ta 'ar koty te we japaraky, a'erehe ame'ẽ ta 'ar koty te we tamatarer japyhyk ta” aja pytuniwe rahã paraky oho ame'ẽ ta ukwaha naĩ. Anĩ. Peteĩ wera rahã, wetep muhepyha a'eta pe miasu me'ẽ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","—A'eta tamatarer ke pyhyk, pe, je'ẽ je'ẽ hũ u'am. Kupixa jar rehe har je'ẽ je'ẽ hũ. ");
INSERT INTO urbNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","A'eta pandu: “A'ejõhar paraky oho ame'ẽ ta ta'yr te mi paraky, ma'e, ka'aruk koty oho ame'ẽ ta ke. Jande anĩ. Warahy haku rahã, japaraky hũ. Pytuniwe jaho. Warahy jere rahã jaho tĩ. Pe, ka'aruk koty japutu'u. Japaraky hũ. Jande aja a'eta pe juja katu te nde ereme'ẽ me'ẽ. Katu ym aja” aja kupixa jar pe. ");
INSERT INTO urbNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","—Je'ẽ je'ẽ hũ ame'ẽ ta ngi har peteĩhar pe kupixa jar pandu: “Sa'e! Ehendurahã! Nde pe upa ihẽ amuhepy riki. Te'e ym ihẽ. Nde ereparaky ereho rahã, peteĩ wera rahã, wetep muhepyha nde erepyhyk ta, aja nde erekwa. Aja japandu katu riki. ");
INSERT INTO urbNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nema'e tamatarer eraho. Nde rok pe ejywyr eho. Kome'ẽ a'ejõhar paraky oho ame'ẽ pe nde aja ihẽ ame'ẽ tar katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ihẽma'e tamatarer namõ ihẽ aputar ame'ẽ ke ihẽ ama'ema'e katu. Amõ ta rehe ihẽ riki akyty'ỹ ym. Pehẽ rehe anĩ, aja pekwaha naĩ, a'erehe nde ereje'ẽ je'ẽ hũ ihẽ rehe my. Katu ym aja” aja kupixa jar — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Pe, a'e pandu tĩ: —Kupixa jar aja Tupã tĩ. Ixotyhar aja a'ejõhar muruwak, ame'ẽ ta rehe Tupã usak katu ta. Ixotyhar aja muruwak py, ame'ẽ ta rehe juja katu te a'e usak katu ta tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jerusarẽ ok ta pe a'e oho ixo rahã, jumu'eha ta ke a'e raho. Heta ame'ẽ ta ngi har jumu'eha ta awa py mokõi jõ mujy'ar. A'eta wata oho ixo rahã, kuja Jesu pandu: ");
INSERT INTO urbNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","19","—Pehendurahã! Jerusarẽ ok ta pe jaho jaxo. Jundéu awa tama'e pa'ihu ta kotyhar ta ke ihẽ rehe amõ muhyk ta werur. Moise je'ẽha mu'e ame'ẽ ta kotyhar ta aja tĩ. Ihẽ rehe muhyk ta werur tĩ. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Upa ame'ẽ ta ihẽ ke pyhyk ta. Pe, ihẽ pe a'eta pandu ta: “Katu ym nde. Nde eremanõ ta me'ẽ te'e” aja riki. Pe, jundéu awa aja ym ame'ẽ ta pe ihẽ ke ame'ẽ ta raho ta. Pe, ihẽ rehe jundéu awa aja ym ame'ẽ ta puka puka hũ ta. Ihẽ ke pirok ta tĩ. Pe, myra ngã mupia ame'ẽ ke rehe ihẽ ke jukwa ta. Mokõi aker rahã, ihẽ ke Tupã mukwera katu ta muhem — aja jumu'eha ta pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Semende rakehar uhyk uwyr ehe. Mokõi imembyr werur. (Imembyr rer Tian. Juã amõ tĩ.) Ipynarãi pe imãi wapyk. (Aja sawa'e katu te ame'ẽ ke kohĩ, a'erehe hendu katu ta ehe aja mujekwa.) Pe, pandu: —Ma'e ke ihẽ apandu ta nde pe — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","A'e pandu: —Ma'e nde pe? — aja ipe. Tian mãi pandu: —Nde riki kapitã keruhũ rahã, ko mokõi ihẽ membyr nde rake wapyk ta. Ame'ẽ ke emanga katu ihẽ pe apo. Nde jywa katu koty peteĩ wapyk ta. Nde jywa'i koty amõ wapyk ta tĩ — aja Jesu pe. (Jesu rake wapyk rahã, amõ ta 'ar koty te we je'ẽha te reko, aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","A'e pandu: —Mã! Upa pepandu ame'ẽ ke pekwa katu ym. Ihẽ rake pewapyk tar katu rahã, amõ we ta pehẽ pe tĩ. Kuja. Ihẽ apyrara hũ ta axo. Ihẽ aja pepyraraha ke pepyhyk ta katu my tĩ? — aja Jesu. Tian ta pandu ipe: —A'e tỹ. Japyhyk katu ta — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesu pandu: —A'e tỹ. Jete! Ihẽ kotyhar ta ke pehẽ, a'erehe pehẽ ke amõ ta mupyrara hũ ta. Ihẽ ke mupyrara hũ aja ta pehẽ tĩ. Pesarahã! Ihẽ rake pewapyk, anĩ. Apandu ym ta ame'ẽ. “Se ihẽ jywa katu koty ewapyk. Se ihẽ jywa'i koty ewapyk” aja ihẽ apandu ym ta. Ame'ẽ ke ihẽ pái jõ pandu katu. A'e riki ame'ẽ renda mukatu — aja Tian ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ame'ẽ ke rehe jande popa jumu'eha ta hendu rahã, imu ta rehe parahy, Tian ta rehe. (A'eta jyty'ym Tian ta rehe, a'erehe parahy.) ");
INSERT INTO urbNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","A'erehe upa jumu'eha ta ke Jesu mujy'ar. Pe, pandu: —Jundéu awa aja ym ame'ẽ tama'e kapitã keruhũ ta mondo mondo hũ ngã ke. Ima'e je'ẽha rupi kapitã ta mondo mondo hũ ngã ke tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pehẽ anĩ. Aja kapitã ta aja pexo rahã, katu ym. Amõ riki kapitã keruhũ aja ixo tar katu rahã, amõ ta namõ ma'e ke ma'ema'e katu ixo. Te'e paraky ame'ẽ ta aja mã peja ixo. Aja rahã, katu tiki. ");
INSERT INTO urbNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Pe, pehẽ ngi har peteĩ riki amõ ta 'ar koty te we katuha aja ixo tar katu rahã, a'e riki pehẽ rehe te'e paraky aja mã peja ixo. Aja rahã, katu tiki. ");
INSERT INTO urbNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","A'e riki ihẽ aja ta tĩ. Pesarahã! Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ namõ ma'e ke amõ ma'ema'e, a'erehe ihẽ ajur my? Anĩ. Aja ym. Amõ ta namõ ihẽ ama'ema'e. A'erehe ko ihẽ ajur. Ihẽ amanõ ta, a'erehe ngãma'e ka'u te'eha ma'ema'eha ke rehe amuhepy. A'erehe heta ngã ke Tupã muhã katu ta — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jeriko ok ta ngi Jesu ta uhem oho ixo rahã, haikwer rupi heta ngã oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Awa rape rake mokõi eha ym te ame'ẽ ta wapyk uĩ. Jesu asa oho ixo, aja a'eta hendu. A'erehe hãtã a'eta pukái: —Jesu! Ndawi rainõ ke nde! Jande rehe epyrara esak! — aja riki. (“Ndawi rainõ” aja pandu rahã: “Kapitã keruhũ” aja Tupã mu'am ame'ẽ ke a'e, aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mokõihar ta pe heta ame'ẽ ta pandu: —Pepandu ym aja — aja tipe. Eha ym te ame'ẽ ta i'ar koty te we hãtã pukáiha: —Sawa'e! Ndawi rainõ ke nde! Jande rehe epyrara esak! — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesu pyta. Pe, pandu: —Pejur! Ma'e nde pe? Ma'e ihẽ ama'e ta pehẽ pe my? — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","A'eta pandu: —Sawa'e! Jande reha ym te. Jande reha ke emukatu. Jasak tar katu — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Pe, a'eta rehe Jesu pyrara usak. Eha rehe ipo ke a'e mujar. Pahar upa ma'e ke rehe a'eta usak usak. Pe, haikwer rupi a'eta oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusarẽ ok ta pe uhyk tate rahã, Metaje ok ta pe uhyk py oho. Ame'ẽ riki ywy'ã rake ihĩ. Ywy'ã rer Oriwéi ty. A'engi mokõi jumu'eha ta ke hundutar koty Jesu mondo. ");
INSERT INTO urbNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Mokõihar ta pe pandu: —Jande ruwa koty ok ta ihĩ, Mbeta ok ta ke. A'ep pehẽ mokõi peho. Pehyk rahã, jumen rehe pesak ta. Myra jytyka ame'ẽ rehe amõ pukwar. Imembyr namõ i'ãi. Ame'ẽ mokõi pejirar. Pe, se ihẽ pe pemuhyk perur. ");
INSERT INTO urbNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","“Ma'erehe jumen pejirar my?” aja amõ pandu rahã, pepandu ipe: “Sawa'e riki putar apo” aja. “Hã!” aja a'e pandu ta. Pahar pehẽ namõ jumen ta ke a'e mondo ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Aja rahã, yman Tupã je'ẽha pandu ame'ẽ ke amõ mupinim, aja uhyk tĩ. Kuja riki: ");
INSERT INTO urbNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Siã ok ta pe har ta pe pepandu: ‘Pesarahã! Pehẽma'e kapitã keruhũ petur ixo apo 'y. A'erehe peta kỹ. “Katu te me'ẽ ke ihẽ” aja ym ame'ẽ ke a'e. Jumen 'ar pe a'e tur ixo. A'erehe kapitã keruhũ a'e, aja pekwa katu ta’ aja.” (“Siã ok ta” aja pandu rahã: “Jerusarẽ ok ta ke” aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Upa Jesu pandu rahã, mokõi jumu'eha ta oho. Upa Jesu pandu, aja a'eta ma'ema'e. ");
INSERT INTO urbNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Jumen ke Jesu pe werur. Imembyr ke werur tĩ. Jumen 'ar pe kamixa ke a'eta mou. Ame'ẽ 'ar pe Jesu wapyk uĩ. Pe, oho. (Kamixa mou rahã, a'e riki kapitã keruhũ aja a'eta ukwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Awa rape rupi heta ngã kamixa ke mou mou tĩ. Amõ ta pindo ro aja me'ẽ mondok. Ame'ẽ ke awa rape rupi mou mou tĩ. (Aja rahã, kapitã keruhũ ko tur. Jumai ym ha aja uwyr, aja mujekwa katu.) Ame'ẽ 'ar rupi jumen pyrũ oho. ");
INSERT INTO urbNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jesu ndutar koty heta ngã wata oho. Haikwer rupi aja tĩ. Heta wata oho tĩ. Upa ame'ẽ ta hãtã pandu pandu: —Ko nde erejur katu! Ymanihar Ndawi aja kapitã keruhũ nde tĩ. Aja Tupã mu'am ame'ẽ ke nde. Sawa'e te je'ẽha rupi nde erejur ame'ẽ ke nde. Mã peja nde rehe Tupã usak katu. Tupã riki katu te ame'ẽ ke a'e — aja ngã pandu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jerusarẽ ok ta pe Jesu ixe oho rahã, ngã mutyapu tyapu hũ. Amõ ta pandu: —Awa ko my? — aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Amõ ta pandu: —Ko Jesu. Tupã je'ẽha pandu ame'ẽ ke a'e. Nasare ok ta pe har ke a'e — aja. Nasare ok ta riki Ngariréi ywy rehe ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tupã rehe ngã jumu'eha renda keruhũ pe Jesu ixe oho. Pe, upa ma'e ke muhepy ame'ẽ ta ke a'e muhem mondo ingi. Ma'e ke muhepy jo'ok ame'ẽ ta ke muhem mondo ingi tĩ. Tamatarer muruwak ame'ẽ tama'e myrape ke mujere tĩ. Aja upa tamatarer ke muhãi ombor. (Amõ ywy ngi amõ ta uwyr. Amõ koty tamatarer ke ame'ẽ ta werur. Ame'ẽ ke Jerusarẽ ok ta pe har tama'e tamatarer ke pe muruwak. Ame'ẽ tama'e myrape ke Jesu mujere.) Pykahuran ke muhepy ame'ẽ tama'e myrape ke mujere tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Upa ngã pe a'e pandu: —Mã! Mukanĩha renda aja se pemuruwak. Sengi pehem peho. Tupã pandu ame'ẽ ke amõ mupinim. Kuja riki Tupã pandu: “Se ihẽma'e jumu'eha renda keruhũ ke. Ihẽ namõ ngã pandu pandu, ame'ẽ renda ke se” aja Tupã pandu. —Pehẽ anĩ. Ame'ẽ ke amõ koty pemuruwak. Ma'e ke mukanĩha renda aja pemuruwak — aja upa muhepyha ta pe Jesu pandu. Pe, muhem mondo ingi. (Muhepyha ta muhepy rahã, ka'u te'eha rupi muhepy, a'erehe mukanĩha aja ame'ẽ ta tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tupã rehe ngã jumu'eha renda keruhũ pe Jesu i'ãi. A'ep eha ym te ame'ẽ ta uhyk ehe. Wata katu ym ame'ẽ ta uhyk ehe tĩ. Upa ame'ẽ ta ke a'e mukatu. ");
INSERT INTO urbNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aja ma'e katu ame'ẽ ke a'e ma'ema'e. Ame'ẽ rehe parise ta usak rahã, parahy ehe riki. Moise je'ẽha mu'e ame'ẽ ta aja tĩ. Parahy ehe tĩ. Tupã rehe ngã jumu'eha renda keruhũ pe kurumĩ ra'yr ta hãtã pandu pandu: —Ko nde erejur katu! Kapitã keruhũ nde. Nde riki katu te me'ẽ ke — aja Jesu pe pandu. Kũjãtãi ra'yr aja tĩ. Pandu pandu tĩ. Ame'ẽ ke rehe parise ta hendu rahã, Jesu rehe parahy tĩ. Moise je'ẽha mu'e ame'ẽ ta aja tĩ. Parahy ehe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","A'erehe Jesu pe a'eta pandu: —Kurumĩ ta pandu ame'ẽ ke rehe nde erehendu my? Katu ym jande pe — aja ipe. —A'e tỹ. Ahendu katu. Tupã je'ẽha rehe amõ mupinim, ame'ẽ rehe pesak riki. Kuja: “Kurumĩ ra'yr ta ke nde eremu'e, a'erehe a'eta pandu katu: ‘Nde riki katu te me'ẽ ke.’ A'erehe ame'ẽ panduha aja a'eta pandu katu tĩ” — aja Jesu pandu. (Kurumĩ ra'yr ta Tupã rehe har pandu katu, aja Jesu mujekwa. Kũjãtãi ra'yr aja tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Parise ta ke Jesu hijar oho. Pe, Mbeta ok ta pe oho. A'ep a'e ukwer. ");
INSERT INTO urbNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ku'ẽ rahã, pytuniwe rahã, Jerusarẽ ok ta pe Jesu jywyr oho ixo rahã, myahy a'e. ");
INSERT INTO urbNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Awa rape rake ma'eywa'y rehe a'e usak. Sik'y ke. A'erehe uhyk oho ehe tipe. U'u ta tipe. Mahem ym ma'eywa. Ho ke te'e i'ãi. A'erehe ma'eywa'y pe a'e pandu: —Apo har ma'eywa nixói te ta — aja riki. Pahar ame'ẽ sik'y xirik oho. ");
INSERT INTO urbNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ame'ẽ ke rehe jumu'eha ta usak rahã, a'eta pandu: —Mãte hũ puki! Pahar sik'y xirik oho! Myja me'ẽ my? — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesu pandu: —Ko apandu pehẽ pe. Ame'ẽ sik'y ke ihẽ amuxirik. Tupã rehe pejurujar katu rahã, aja pema'e ta tĩ. Pejurujar katuha ke pehijar ym. Aja rahã, ihẽ ama'eha aja pema'e katu ta tĩ. Ame'ẽ jõ ym. Kome'ẽ ywy'ã pe pepandu: “Eho! Ejumbor eho y ramũi pe!” aja. Tupã namõ pepandu, pe, pejurujar katu ehe tĩ. “Mã! Opor ta nahã my? Akwa ym” aja ym pepandu. Aja rahã, ame'ẽ ywy'ã opor ta oho. ");
INSERT INTO urbNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pejurujar katu ehe rahã, ma'e ke pepandu pandu inamõ, ame'ẽ ke pehẽ pe Tupã muwyr ta — aja Jesu. (“Ywy'ã keruhũ” aja Jesu pandu rahã: “Upa ma'e hãtã ma'eha ke” aja a'e mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tupã rehe ngã jumu'eha renda keruhũ pe Jesu jywyr oho. A'e mu'e mu'e ixo rahã, jundéu awa tama'e pa'ihu ta uhyk uwyr ehe. Jundéu awa tama'e kapitã ta uhyk uwyr ehe tĩ. A'eta pandu ipe: —Sengi muhepyha ta ke nde eremuhem eremondo. Awa je'ẽha rupi nde eremuhem eremondo my? Awa riki nde ke muwyr se my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesu pandu: —Ihẽ aja tĩ. Pehẽ pe ihẽ apandu ta tĩ. Pe, ihẽ pe pepandu py rahã, awa je'ẽha rupi ma'e ke ihẽ ama'ema'e, ame'ẽ ke ihẽ apandu ta pehẽ pe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Apo pepandu py ihẽ pe. Sawa'e je'ẽha rupi Juã mujahuk ngã ke my? Awa Juã ke mondo my? A'e ke Tupã mondo my? Sawa'e mondo my? Pepandurahã! — aja Jesu. Ame'ẽ ke rehe pa'ihu ta hendu rahã, se koty Jesu ngi oho. Pe, pandu pandu a'eta jupe. Jundéu awa tama'e kapitã ta namõ pandu pandu ngã jupe. Kuja: —Mã! Myja japandu ta ipe my? “Tupã je'ẽha rupi Juã mujahuk” aja japandu ipe rahã, kuja jande pe Jesu pandu ta: “Aja rahã, ma'erehe Juã pandu ame'ẽ ke rehe pejurujar ym my?” aja jande pe Jesu pandu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Anĩ. “Sawa'e je'ẽha rupi Juã mujahuk” aja japandu rahã, jande rehe ngã parahy ta. Mahy ta jande ke tĩ. Juã riki Tupã je'ẽha pandu ame'ẽ ke a'e, aja ngã ukwa katu. Sawa'e mondo ym a'e aja ukwa katu. A'erehe jande rehe parahy ta. Mã! Myja japandu ta my? — aja pa'ihu ta pandu pandu a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","A'erehe Jesu pe pa'ihu ta pandu: —Juã rehe har japandu ym ta nde pe — aja. A'eta pe Jesu pandu: —Aja rahã, ihẽ aja tĩ. Awa je'ẽha rupi ma'e ke ihẽ ama'ema'e, ame'ẽ ke pehẽ pe ihẽ apandu ym ta tĩ — aja pa'ihu ta pe. Kapitã ta pe pandu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Amõ we pa'ihu ta pe Jesu pandu. Jundéu awa tama'e kapitã ta pe pandu tĩ: —Myja pekwa my? Amõ rahã, ipái namõ mokõi ta'yr ta ixo. Pe, u'ar py, ame'ẽ pe ipái pandu oho: “Sa'e! Kupixa pe eparaky eho apo” aja. ");
INSERT INTO urbNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Aho ym ta ihẽ” aja ipái pe. I'i atu rahã ipy'a ke muruwak, pe, kupixa pe ta'yr paraky oho. ");
INSERT INTO urbNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Pe, amõ ta'yr pe ipái pandu oho: “Sa'e! Kupixa pe eparaky eho apo” aja riki. Ta'yr pandu: “Aho ta kỹ” aja tipe. Anĩ. Oho ym riki. ");
INSERT INTO urbNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mokõi ta'yr ta ngi har awa riki ipái putar ame'ẽ ke ma'e my? — aja Jesu. —U'ar py ame'ẽ ke — aja pa'ihu ta pandu. A'erehe Jesu pandu a'eta pe tĩ: —Ko apandu pehẽ pe. Ame'ẽ ta'yr ta rehe har amujekwa ta pehẽ pe. Amõ ta jaxer ai te aja pekwaha. Homa awa tama'e kapitã keruhũ pe tamatarer matyr ame'ẽ ta ke. Kũjã ka'u te'e ame'ẽ ta jaxer ai aja pekwaha tĩ. Ame'ẽ ta Tupã koty ipy'a ke muruwak, a'erehe Tupã kotyhar ta aja muruwak. (Ta'yr u'ar py, ame'ẽja saka.) ");
INSERT INTO urbNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Myja Tupã kotyhar aja amõ muruwak my? Ame'ẽ rehe har Juã mujahukiha mujekwa uwyr pehẽ pe. A'e pandu ame'ẽ ke rehe pejurujar ym. Pehẽ pa'ihu ta. Pejurujar ym ehe tĩ. Kapitã keruhũ pe tamatarer matyr ame'ẽ ta jurujar katu ehe. Kũjã ka'u te'e ame'ẽ ta aja tĩ. Jurujar katu ehe tĩ. Ame'ẽ ke rehe pesak tipe. Anĩ. Pehẽ py'a ke pemuruwak ym. (Ta'yr iapyr aja pehẽ tĩ.) Juã pandu ame'ẽ ke rehe pejurujar ym, a'erehe Tupã kotyhar ta aja pemuruwak ym tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Amõ we pa'ihu ta pe Jesu pandu tĩ: —Amõ myja me'ẽ ma'e ke my aja ihẽ apandu ta. Pehendurahã! Amõ sawa'e ixo. Kupixa ke a'e mondok. (Upa hapy.) Pe, ma'eywa'y rãkã ra'yr ke a'e jytym. Uwa'y rãkã ke. Kupixa rymy'y rupi a'e mukurar kurar. Pe, ma'eywa rykwer jo'okiha renda ke pykũi tĩ. Kupixa my'y pe myta mujã tĩ. (Ywate ame'ẽ ke mujã. Ame'ẽ ngi usakiha usak usak katu.) Upa mujã rahã, amõ ta pe pandu: “Kupixa rehe pesak katu. I'a tyarõ rahã, ko amõ pehẽma'e ta kỹ. Amõ i'a ihẽma'e ta kỹ” aja. “Ere” aja ame'ẽ ta pandu. Pe, pepaite kupixa jar usak te'e oho. (Paxia oho.) ");
INSERT INTO urbNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","—I'a tyarõ rahã, miasu ta ke kupixa jar mondo, ima'e kupixa pe. Kupixa usakiha ta ngi ma'eywa rykwer ke miasu ta jo'ok we ta tipe oho. ");
INSERT INTO urbNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Miasu ta ke usakiha ta pyhyk. Amõ ke a'eta nupã riki. Amõ ke jukwa. Amõ rehe ita ke a'eta ombor. Mujan riki. Ijar pe me'ẽ ym te ma'e rykwer ke. ");
INSERT INTO urbNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Amõ miasu ta ke kupixa jar mondo tĩ. Mondo py, ame'ẽ 'ar koty te we hetaha mondo tipe. Ame'ẽ ta ke usakiha ta juja katu te mahy. Amõ ke nupã. Amõ ta ke jukwa. Aja riki. Ijar pe me'ẽ ym te ma'eywa rykwer ke. ");
INSERT INTO urbNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","—Pe, a'ejõhar ta'yr ke kupixa jar mondo. “Ihẽ ra'yr rehe a'eta hendu katu ta, aja ihẽ akwa” aja a'e jupe. A'erehe ta'yr ke mondo tipe. ");
INSERT INTO urbNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ta'yr rehe usakiha ta usak rahã, a'eta pandu pandu a'eta jupe: “Ko riki kupixa jar ra'yr. Ipái manõ rahã, kupixa riki ima'e wan ta. Jajukwa ta peme'ẽ ke. Aja rahã, kupixa riki jandema'e wan ta” aja a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","A'erehe a'eta pyhyk a'e ke. Pe, kupixa ngi hykýi raho. Pe, jukwa. Ta'yr ke jukwa. ");
INSERT INTO urbNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","—Apo kupixa jar uhyk uwyr rahã, usakiha ta pe myja me'ẽ a'e ma'e ta my? — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","—Ame'ẽ jaxer ame'ẽ ta ke kupixa jar jukwa ta. Pe, amõ ta pe a'e pandu ta: “Ihẽma'e kupixa rehe pesak katu” aja ta. Pe, i'a tyarõ rahã, ame'ẽ ta riki ma'eywa rykwer ke mowok ta. Kupixa jar pe ima'e rykwer ke me'ẽ ta — aja a'eta pandu ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","A'eta pe Jesu pandu: —Aja ta riki. Pesarahã! Kuja Tupã je'ẽha rehe panduha pesak katu riki. Kuja: “Ita rehe har ita ok mujãha pandu: ‘Jaxer te'e kome'ẽ ita ke’ aja. Anĩ. Tupã pandu: ‘Peme'ẽ riki ok pyter wan mupu'am katu riki’ aja. Aja jandema'e sawa'e te ma'eha riki. Katu te aja jakwa katu” aja panduha ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","—A'erehe pehẽ pe ihẽ apandu. Je'ẽha pyahu ke Tupã muwyr. Aja Tupã kotyhar ta aja pemuruwak tar ym. Peputar ym, a'erehe pehẽ ke a'e putar ym tĩ. Pe, amõ awa ta pe a'e pandu ta: “Ihẽ kotyhar ta aja pemuruwak” aja. Ame'ẽ ta putar katu ta. Pe, katu ame'ẽ ke ame'ẽ ta ma'ema'e ta. Tupã putar aja a'eta ma'ema'e ta. ");
INSERT INTO urbNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kome'ẽ ita rehe ipy ke amõ tukwa rahã, ahy ta. Amõ rehe ita u'ar rahã, mupe ta — aja Jesu pandu. (“Ita rehe har” Jesu pandu rahã: “Juehe har” a'e pandu. “Ipy tukwa” aja pandu rahã: “Jesu ke amõ ta putar ym” aja mujekwa. Amõ rehe ita u'ar rahã, ame'ẽ ke Jesu mupyrara hũ ta, aja a'e mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Myja me'ẽ kupixa usakiha ta my, ame'ẽ ke Jesu pandu. Ame'ẽ rehe jundéu awa tama'e pa'ihu ta hendu rahã, a'eta rehe har Jesu pandu aja a'eta ukwa. Parise ta rehe har a'e pandu tĩ, aja a'eta ukwa tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","A'erehe a'eta parahy ehe, Jesu rehe. A'erehe Jesu ke a'eta pyhyk ta tipe. Heta ame'ẽ ta ngi a'eta kyje. Jesu riki Tupã je'ẽha pandu ame'ẽ ke a'e, aja heta ame'ẽ ta ukwa katu, a'erehe heta ame'ẽ ta ngi parise ta kyje. A'erehe Jesu ke pyhyk ym arahã. ");
INSERT INTO urbNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ngã pe pandu rahã, myja me'ẽ ma'e ke my aja Jesu pandu pandu. Kuja: ");
INSERT INTO urbNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Tupã pandu: “Ihẽ kotyhar ta aja pemuruwak” aja. Ame'ẽ ke putar ame'ẽ ta kuja riki. Amõ rahã, sawa'e ixo. Kapitã keruhũ a'e. Ta'yr riki jumendar, a'erehe imi'u ke ipái matyr. Huryha mujã. ");
INSERT INTO urbNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pe, miasu ta pe kapitã keruhũ pandu. “Pepandu peho. Kwehe amõ ta pe ihẽ apandu: ‘Ihẽ mi'u ke pe'u pejur’ aja. Ame'ẽ ta pe pepandu peho: ‘Pe'u pejur apo’ aja.” A'erehe miasu ta pandu oho tipe. Uwyr tar ym ngã. ");
INSERT INTO urbNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","—A'erehe amõ miasu ta ke kapitã keruhũ mondo. Kwehe pandu: “Pejur” ame'ẽ ta pe miasu ta pandu we ta oho tĩ. Kuja pandu ta: “Kapitã keruhũ pandu: ‘Ihẽ mi'u ke upa amatyr hũ. Tapi'iruhu upa ihẽ ajukwa. Tapi'iruhu ra'yr ixa ame'ẽ ke ajukwa tĩ. Upa amuka'ẽ riki. Myrape 'ar pe ihĩ apo. Ihẽ ra'yr jumendariha rehe pesak pejur’ aja riki.” Aja miasu ta pandu tipe. ");
INSERT INTO urbNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ame'ẽ rehe ngã hendu ym tĩ. Pe, ima'e ma'ema'e oho. Amõ riki kupixa pe paraky oho. Amõ riki ima'e muhepyha renda pe paraky oho. ");
INSERT INTO urbNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Amõ ta riki miasu ta ke pyhyk. Pe, nupã hũ. Pe, jukwa. ");
INSERT INTO urbNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ame'ẽ ukwa rahã, kapitã keruhũ riki parahy. A'erehe sonda ta ke a'e mondo. Pe, miasu ke jukwa, ame'ẽ ta ke sonda ta jukwa tĩ. Ame'ẽ ta rekoha ke sonda ta hapy tĩ. Upa ukwái. ");
INSERT INTO urbNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","—Pe, amõ miasu ta ke kapitã keruhũ mujy'ar. A'e pandu: “Jumendariha rehe ihẽ mi'u ke ihẽ amatyr. Kwehe ihẽ apandu: ‘Pejur’ ame'ẽ ta uwyr rahã, katu ym ta tipe. Uwyr tar ym, putar ym, a'erehe u'u rahã, katu ym. ");
INSERT INTO urbNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Apo awa rape rupi peho. A'ep amõ ta ke pemahem rahã, pepandu: ‘Kapitã mi'u matyriha rehe pe'u pejur’ ” aja kapitã keruhũ pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","A'erehe miasu ta oho. Awa rape rupi oho. Pe, ame'ẽ rupi wata ame'ẽ ta mujy'ar. Katu ame'ẽ ta ke a'eta mujy'ar. Jaxer ame'ẽ ta ke mujy'ar tĩ. Pe, jumendariha renda ke mutyryhem. ");
INSERT INTO urbNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","—Uwyr ame'ẽ ta rehe kapitã keruhũ usak oho. Pe, amõ rehe usak. Ma'e mundeha nixói riki. (Jumendariha rehe amõ oho rahã, ma'e mundeha katu ame'ẽ ke ijar me'ẽ ngã pe.) Ame'ẽ ke pyhyk ym. Putar ym, a'erehe munde ym. ");
INSERT INTO urbNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kapitã keruhũ pandu ipe: “Sa'e! Jumendariha rehe amõ oho rahã, ma'e mundeha katu ame'ẽ ke munde. (Ihẽ ame'ẽ, ame'ẽ ke nde eremunde ym.) Myja se nde erexe my?” aja ipe. Ame'ẽ sawa'e je'ẽ ym. ");
INSERT INTO urbNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Pe, miasu ta pe kapitã keruhũ pandu: “Sawa'e po ke pepukwar. Ipyta ke pepukwar tĩ. Pe, soroka pe pembor. A'ep pytun. A'ep ahy ixo, a'erehe jixi'u hũ ta. Ahy hũ, a'erehe hãi ke su'u su'u rãi” aja kapitã keruhũ pandu — aja Jesu pandu. (“Ta'yr jumendariha rehe oho” aja pandu rahã: “Tupã renda pe ohoha” aja mujekwa. “Ma'e mundeha katu ame'ẽ ke Tupã me'ẽ” aja pandu rahã: “Ipy'a juhyk” aja mujekwa. Aja ym rahã, marã ka ym Tupã koty amõ ohoha.) ");
INSERT INTO urbNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pe, Jesu pandu tĩ: —Heta te hũ ame'ẽ ta pe Tupã pandu: “Ihẽ renda pe pejur” aja. Anĩ. Heta te hũ ame'ẽ ta oho ym. Heta ym ame'ẽ ta rehe a'e katu usak. Ixotyhar ta jõ aja jo'ok riki — aja pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Parise ta oho ingi. A'eta pandu pandu a'eta jupe. “Jesu pe ma'e ke japandu ta. Pe, je'ẽha a'e jawy rahã, japyhyk ta” aja riki pandu pandu a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","A'erehe ima'e jumu'eha ta ke parise ta mondo. Jesu koty mondo. Ero kotyhar ta ke a'eta mondo tĩ. Ame'ẽ ta Jesu rehe uhyk. (Muka'u te'e tar katu, a'erehe katu ehe har pandu py.) Kuja pandu: —Sawa'e! Ngã mu'eha nde. Jetehar te ke nde erepandu, ame'ẽ ke jakwa katu. Myja me'ẽ amõ ixoha ke Tupã putar, ame'ẽ rehe har jetehar nde eremu'e. Amõ ngi nde erekyje ym ha rupi nde eremu'e katu. Upa awa ta rehe juja katu te nde eresak, a'erehe nde erekyje ym ha rupi nde eremu'e katu. ");
INSERT INTO urbNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Apo jande pe epandu. Myja me'ẽ nde erekwa my? Homa awa tama'e kapitã keruhũ pe tamatarer jame'ẽ rahã, katu my? Anĩ rahã, katu ym my? Myja me'ẽ jundéu awa ta je'ẽha mujekwa my? “Pehẽ peme'ẽ katu” aja mujekwa my? “Peme'ẽ ym” aja mujekwa my? Myja my? Epandu jande pe — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","A'eta riki katu ym ame'ẽ ke ma'e tar katu, aja Jesu ukwa. A'erehe kuja a'e pandu: —Mã! Mokõi pekwaha ta ke pehẽ! Ihẽ ke pemuka'u te'e tar katu. ");
INSERT INTO urbNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kapitã keruhũ pe tamatarer ke amõ me'ẽ. Ame'ẽ tamatarer ke ihẽ pe pemujesak — aja parise tama'e jumu'eha ta pe. Tamatarer ke a'eta werur ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Pe, Jesu pandu: —Kome'ẽ tamatarer rehe awa'ã ihĩ my? Awa rer ngã mupinim ko my? — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Homa awa tama'e kapitã keruhũma'e ke! Sesama'e riki — aja a'eta pandu. (Sesa riki homa awa tama'e kapitã keruhũ.) A'erehe Jesu pandu: —Aja rahã, kapitã keruhũma'e ke kapitã keruhũ pe peme'ẽ katu. Tupãma'e ke rahã, pehẽ py'a pemoĩ moĩ katu ehe tĩ. Ame'ẽ riki ma'e ke peme'ẽ, ame'ẽja saka — aja pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ame'ẽ ke rehe a'eta hendu rahã, pandu: —Mã! Ukwa katu a'e! — aja. Pe, a'eta oho ingi, Jesu ngi. ");
INSERT INTO urbNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jesu namõ parise tama'e jumu'eha ta pandu uwyr. Ame'ẽ wera rahã, sanduse ta uhyk ehe tĩ. Ame'ẽ ta manõha ngi amõ kwera ym te ta, aja ukwa ame'ẽ ta ke a'eta. ");
INSERT INTO urbNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","A'eta pandu: —Sawa'e! Ngã mu'eha nde. Yman kuja Moise mujekwa: “Sawa'e jumendar, pe, ta'yr ym ipe. Pe, manõ rahã, imu riki imu ambyr rakehar ke pyhyk. Pe, a'e ta'yr ipe. Ame'ẽ ta'yr riki imu ambyr ra'yr aja saka ngã ukwa” aja Moise mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","—Apo ehendurahã! Se awa po wajar mokõi imu ta ixo kwe. U'ar py ame'ẽ ke jumendar. Pe, ta'yr ym ipe. Pe, manõ. A'erehe imu riki imu ambyr rakehar ke pyhyk tipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mokõihar aja tĩ. Sawa'e manõ tĩ. Ta'yr ym ipe tĩ. A'erehe imu mahapyrihar kũjã ke pyhyk tipe tĩ. Ame'ẽ aja tĩ. Manõ tĩ. Ta'yr ym ipe tĩ. Aja upa imu ta riki tĩ. Imu ambyr rakehar ke pyhyk tipe tĩ. Pe, manõ tĩ. Ta'yr ym ipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Upa awa po wajar mokõi imu ta manõ. Pe, kũjã manõ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Apo epandurahã! Yman rahã, manõ ame'ẽ ta kwera katu uhem rahã, kũjã riki awa rakehar wan ta my? Se ixo rahã, upa imu awa po wajar mokõi riki pyhyk — aja sanduse ta pandu. (“Manõ ame'ẽ ta kwera katu ta uhem” aja ukwa ame'ẽ ta ke muka'u te'e tar katu, a'erehe ame'ẽ panduha ke sanduse ta pandu.) ");
INSERT INTO urbNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Pe, Jesu pandu: —Mã! Tupã je'ẽha pekwa ym. Tupãma'e pyrãtãha ke pekwa ym tĩ, a'erehe pehẽ je'ẽha ke pejawy. ");
INSERT INTO urbNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yman rahã, ngã kwera katu uhem rahã, jumendar ym te ta awa. Ywa pe Tupã je'ẽha rahoha ta ixo. Ame'ẽ ta aja ngã ixo ta tĩ. Jumendar ym te ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Apo kweraha rehe har amujekwa ta. Tupã pandu ame'ẽ rehe har pekwa riki. Paper rehe pesak riki. Tupã pandu: ");
INSERT INTO urbNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ihẽ rehe ipy'a ke Amarã moĩ moĩ katu. Isak aja tĩ. Jako aja tĩ. Ipy'a ke a'eta moĩ moĩ katu tĩ” aja Tupã. —Pesarahã! Ixuwe ixo ame'ẽ ta jõ Tupã rehe ipy'a ke moĩ moĩ katu. Manõ ame'ẽ ta anĩ. Aja rahã, Amarã ta'ã ixuwe katu aja te'e ta ixo 'y. Yman riki manõ. I'ã ixuwe katu aja te'e ta ixo 'y. A'erehe tapijar te'e we ipy'a ke moĩ moĩ katu Tupã rehe. A'erehe manõ ame'ẽ ta kwera katu ta kỹ, aja Tupã mujekwa katu — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ame'ẽ ke rehe sanduse ta hendu rahã, pandu: —Mã! Mu'e katu a'e — aja Jesu rehe har. ");
INSERT INTO urbNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sanduse ta je'ẽha ke Jesu mukanim, aja parise ta hendu. A'erehe a'eta jy'ar uwyr ehe. ");
INSERT INTO urbNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ame'ẽ ta ngi har amõ pandu ipe. Jesu je'ẽha ke a'e mujawy tar katu, a'erehe kuja pandu ipe: ");
INSERT INTO urbNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Sawa'e! Ngã mu'eha nde. Moise je'ẽha ke jande jakwa jaxo. Ame'ẽ ngi har myja me'ẽ riki katu te me'ẽ ke my — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","A'e pandu: —Tupã rehe epy'a katu te. Aja te'eha ehe har ekwa ekwa katu exo. Nde py'a emoĩ moĩ katu ehe tĩ. Aja epy'a katu te ehe. ");
INSERT INTO urbNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ame'ẽ riki Moise je'ẽha katu te ame'ẽ ke. Amõ 'ar koty te we katuha ame'ẽ. ");
INSERT INTO urbNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mokõi katu te ame'ẽ ke ihẽ apandu py aja tĩ. Kuja. Ne namõ ixo ame'ẽ ta rehe epy'a katu. Nde juehe nde erepy'a katu, aja amõ ta rehe epy'a katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ame'ẽ mokõi riki katu te me'ẽ ke. Ame'ẽ mokõi rehe amõ hendu katu te rahã, upa katu te Moise je'ẽha rehe hendu katu, ame'ẽja saka — aja Jesu pandu parise ta pe. (“Ne namõ ixo ame'ẽ ta rehe ipy'a katu ta me'ẽ te'e” aja Jesu pandu rahã: “Upa amõ ta rehe ipy'a katu ta me'ẽ te'e” aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Amõ parise ta jy'ar uwyr. Arahã kuja Jesu pandu ngã pe: ");
INSERT INTO urbNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Kirisutu rehe har, myja me'ẽ pekwa my? Awa rainõ ke a'e my? Myja ehe har pekwa my? —Ndawi rainõ ke a'e, aja ehe har jakwa — aja parise ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesu pandu: —A'e tỹ. Awa a'e tĩ. A'erehe Ndawi rainõ ke a'e. Amõ we tĩ. Tupã'ã mujekwa ame'ẽ ke Ndawi pandu: “Ihẽma'e sawa'e te” aja Kirisutu pe. (Aja rahã, Tupã a'e tĩ.) Kuja Ndawi pandu: ");
INSERT INTO urbNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Ihẽma'e sawa'e te pe sawa'e te pandu: ‘Se ihẽ rake ewapyk eĩ. (Aja rahã, katu te ame'ẽ ke nde, aja amujekwa.) Ne ruwajan ta ke ihẽ amuputu'u ta. Ame'ẽ ym rahã we, se ewapyk eĩ. Nde rehe a'eta hendu ym rahã we, se ewapyk eĩ tĩ’ ” aja Ndawi pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","—“Ihẽma'e sawa'e te” aja Ndawi pandu. Aja rahã, Kirisutu riki ima'e sawa'e te aja mujekwa katu. (Aja rahã, a'e Tupã tĩ, aja Ndawi ukwa katu tĩ.) Aja jõ ym. A'e riki hainõ ke tĩ. (Aja rahã, awa a'e tĩ, aja mujekwa tĩ) — aja Jesu mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jesu pe marã ka ym je'ẽha ke amõ mujywyriha. A'engi ma'e ke amõ ta pandu ym ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Heta ngã pe Jesu pandu. Jumu'eha ta pe pandu tĩ: ");
INSERT INTO urbNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Moise mupinim, ame'ẽ ke Moise je'ẽha mu'e ame'ẽ ta mujekwa ngã pe. Parise ta aja tĩ. Mujekwa ngã pe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","A'erehe a'eta mujekwa ame'ẽ ke rehe pehendu katu ta me'ẽ te'e. Ame'ẽ ta mu'e, aja pema'ema'e katu tĩ. Kuja jõ anĩ. Parise ta aja pema'ema'e ym. A'eta mujekwa, aja a'eta ma'ema'e ym. Mokõi ukwaha aja a'eta ixo. ");
INSERT INTO urbNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","A'eta mu'e ame'ẽ ke kuja pandu: “Mã peja jande jamu'e ame'ẽ ke pema'ema'e katu” aja riki. Ame'ẽ riki mã hãtã te hũ ma'eha. Ame'ẽ riki ma'e puhýi ame'ẽ ke xupe pe hupir raho, ame'ẽja saka. “Pehẽ namõ jama'e ta. Pehẽ rehe japy'a katu” aja pandu ym te parise ta. (Aja rahã: “Pehẽ namõ pehẽma'e puhýiha ke jahupir ta” aja pandu ym te ta. Katu ym aja.) ");
INSERT INTO urbNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ma'e ke parise ma'e ixo rahã, ame'ẽ ke rehe amõ ta usak. Ame'ẽ ke a'eta putar katu. Amõ ta usak rahã: “Mã! Pehẽ katu” aja amõ ta pandu naĩ. Amõ we tĩ. Tupã je'ẽha ke paper rehe a'eta mupinim. Ame'ẽ ke mupu'a, pe, ijywa rehe pukwar. Ipykã pyter pe pukwar tĩ. Tiha ame'ẽ ke pukwar. (Aja rahã, Tupã rehe ipy'a ke moĩ moĩ katu, aja ukwaha naĩ.) Kamixa apyr rehe iham pukwar tĩ. Puku ame'ẽ ke pukwar. (Aja rahã, Tupã rehe ipy'a ke moĩ moĩ katu, aja ukwaha naĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ngã mi'u matyriha ke amõ mujã rahã, kapitã keruhũ rake jõ a'eta wapyk tar katu. Kapitã ta jupe. Jundéu awa tama'e jy'ariha renda pe oho rahã, kapitã ta rake jõ a'eta wapyk tar katu tĩ. “Jande katu te ame'ẽ ke jande” aja mujekwa tar katu naĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Muhepyha renda rupi wata ixo rahã: “Sa'e ta! Ko pexo. Katu pehẽ” aja amõ ta pandu. Ame'ẽ ke putar katu tĩ. A'eta pe amõ ta pandu: “Ngã mu'eha pehẽ” aja a'eta putar katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","—Pehẽ anĩ. Ihẽma'e jumu'eha ta ke pehẽ. Pehẽ pe: “Ngã mu'eha pehẽ” aja mã peja amõ ta pandu ym ta me'ẽ te'e. Pehẽ riki pehẽ mu pehẽ juehe, a'erehe pehẽ pe: “Ngã mu'eha pehẽ” aja mã peja pandu ym. Peteĩ riki pehẽma'e mu'eha. (Ihẽ ame'ẽ.) ");
INSERT INTO urbNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kome'ẽ ywy keruhũ pe har pe: “Ihẽ pái keruhũ” aja pepandu ym ta me'ẽ te'e tĩ. Peteĩ riki pehẽ pái keruhũ. Ywa pe har jõ riki ame'ẽ, a'erehe ywy pe har pe pepandu ym: “Ihẽ pái keruhũ.” ");
INSERT INTO urbNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pehẽ pe: “Ihẽma'e jar keruhũ” aja mã peja amõ ta pandu ym ta me'ẽ te'e. Peteĩ riki pehẽma'e jar keruhũ. Kirisutu jõ riki pehẽma'e jar keruhũ. (Ihẽ ame'ẽ.) ");
INSERT INTO urbNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pehẽ pyter ngi har peteĩ riki katu te ame'ẽ ke aja putar rahã, mã peja amõ ta rehe te'e paraky aja ixo. ");
INSERT INTO urbNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","“Katu te” aja amõ ukwa jupe rahã: “A'e katu ym” aja Tupã ukwa. “Katu ym ihẽ” aja amõ ukwa jupe rahã: “A'e katu” aja Tupã ukwa — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","A'e pandu tĩ: —Moise je'ẽha mu'e ame'ẽ ta! Mã pehẽ ke Tupã mupyrara ta. Parise ta! Pehẽ ke aja tĩ. Tupã mupyrara ta tĩ. Upa pehẽ riki mokõi pekwaha namõ pexo ame'ẽ ta ke pehẽ. “Ihẽ kotyhar ta aja pemuruwak” aja Tupã pandu. Parise ta! Pehẽ anĩ. Ame'ẽ ke peputar ym. Moise je'ẽha mu'e ame'ẽ ta! Pehẽ aja tĩ. Peputar ym tĩ. Amõ ta anĩ. Putar katu. Ame'ẽ ta ke pemuka'u te'e, a'erehe Tupã kotyhar ta aja muruwak ym. Ame'ẽ ta pe: “Anĩ. Pemuruwak ym” aja pepandu. Katu ym aja. Mã pehẽ ke Tupã mupyrara ta. ");
INSERT INTO urbNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","—Moise je'ẽha mu'e ame'ẽ ta! Parise ta! Mã mokõi pekwaha namõ pexo ame'ẽ ta ke pehẽ! Te'e peje'ẽ, pe, ixawa'e manõ ame'ẽ rok ke pejo'ok te'e ingi. A'engi te'e pejo'okiha ke amõ ta ngi pemukanim tar katu, a'erehe i'i we Tupã namõ pepandu pandu tipe. Aja rahã, katu ame'ẽ ta ke pehẽ aja amõ ta ukwaha naĩ. Mã pehẽ ke Tupã mupyrara ta. Amõ ta 'ar koty te we pehẽ ke mupyrara ta. ");
INSERT INTO urbNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—Moise je'ẽha mu'e ame'ẽ ta! Parise ta! Mã upa pehẽ riki mokõi pekwaha namõ pexo ame'ẽ ta ke pehẽ! Upa katu te ma'e ke pema'e, aja peteĩ jundéu awa ym ame'ẽ ke pehẽ kotyhar aja pemuruwak. Upa pemuruwak rahã, pehẽ 'ar koty te we a'e riki mupyraraha renda pe oho ta ame'ẽ ke a'e. (Pehẽ 'ar koty te we ma'e ka'u te'eha ke ma'ema'e, ame'ẽ ke apo 'y. A'erehe mupyraraha renda pe oho ta ame'ẽ ke a'e.) Mã pehẽ johu Tupã mupyrara ta. ");
INSERT INTO urbNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","—Parise ta! Moise je'ẽha mu'e ame'ẽ ta! Pehẽ johu riki eha ym te ame'ẽ ta aja pehẽ. Pe, amõ ta ke pehykýi peraho pexo. Kuja pemu'e: “Tupã rehe ngã jumu'eha renda keruhũ pe itatawa ihĩ, aja pekwa. A'erehe jete katu te atu ihẽ apandu. A'erehe apandu ame'ẽ ke ihẽ ama'e ta” aja pekwa tĩ. —Aja pandu rahã, itatawa rehe har pandu. A'erehe ame'ẽ panduha ke a'e ma'e te ta, aja pekwa. Anĩ. Jumu'eha renda keruhũ jõ pepandu rahã, amõ koty pemu'e. Itatawa pandu ym. Kuja amõ pandu: “Tupã rehe jumu'eha renda keruhũ pehĩ, aja pekwa. A'erehe jete katu te atu ihẽ apandu. A'erehe apandu ame'ẽ ke ihẽ ama'e ta” aja pekwa tĩ. —Aja pandu rahã, itatawa rehe har pandu ym. A'erehe ame'ẽ panduha aja amõ ma'e ta nahã my? Ma'e ym ta nahã my? Ukwa ym awa, aja pekwa. Aja pemu'e. Mã katu ym pemu'eha. ");
INSERT INTO urbNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mã! Eha ym te ame'ẽ ta aja pehẽ! Ma'e riki katu te my? Itatawa riki katu te my? Tupã rehe ngã jumu'eha renda keruhũ riki katu te my? Pesarahã! Jumu'eha renda keruhũ riki katu te tiki. Ame'ẽ riki itatawa ke mukatuha, ame'ẽja saka, a'erehe itatawa 'ar koty te we jumu'eha renda keruhũ katuha. ");
INSERT INTO urbNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kuja pemu'e tĩ: “Myrape 'ar pe ma'e hymba ke hapy, Tupã pe. Ame'ẽ ke pekwa, a'erehe jete katu te atu apandu. Ihẽ apandu ame'ẽ ke ihẽ ama'e katu ta” aja pekwa katu. —Aja pandu rahã, hymba rehe har pandu. A'erehe ame'ẽ panduha aja amõ ma'e te ta, aja pekwa. Aja pemu'e. Myrape jõ pandu rahã, anĩ. Ma'e ym ta nahã my. Ukwa ym awa. Kuja amõ pandu: “Myrape 'ar pe ma'e ke hapy. Ame'ẽ myrape pehĩ, aja pekwa. A'erehe jete katu te atu apandu. A'erehe ihẽ apandu ame'ẽ ke ihẽ ama'e katu ta” aja pekwa katu tĩ. —Aja pandu rahã, hymba rehe har pandu ym. A'erehe ame'ẽ panduha aja amõ ma'e ta nahã my? Ma'e ym ta nahã my? Ukwa ym awa, aja pekwa. Aja pemu'e. Mã katu ym pemu'eha. ");
INSERT INTO urbNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mã! Eha ym te ame'ẽ ta aja pehẽ. Ma'e riki katu te ame'ẽ ke my? Tupã pe hymba ke hapy ame'ẽ ke katu te my? Myrape riki katu te ame'ẽ ke my? Pesarahã! Myrape riki katu te. Ame'ẽ riki ma'e hymba ke mukatuha, ame'ẽja saka. ");
INSERT INTO urbNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","A'erehe: “Myrape 'ar pe ma'e ke hapy, ame'ẽ myrape pehĩ, aja pekwa, a'erehe jete katu te atu ihẽ apandu. Ihẽ apandu ame'ẽ ke ihẽ ama'e katu ta” aja pekwa tĩ. —Aja pandu rahã, upa myrape 'ar pe moĩ, ame'ẽ ke pandu. Myrape ke amõ pandu tĩ. A'erehe ame'ẽ panduha aja amõ ma'e ta me'ẽ te'e. ");
INSERT INTO urbNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pe, amõ pandu: “Tupã rehe jumu'eha renda keruhũ pehĩ, aja pekwa. A'erehe jete katu te atu ihẽ apandu. Ihẽ apandu ame'ẽ ke ihẽ ama'e katu ta” aja pekwa tĩ. —Aja pandu rahã: “Tupã pete'e ixo, aja pekwa” aja pandu, ame'ẽja saka. Tupã riki jumu'eha renda keruhũ pe ixo, ame'ẽja saka. Pe, jumu'eha renda keruhũ ke amõ pandu tĩ. A'erehe ame'ẽ panduha aja amõ ma'e ta me'ẽ te'e tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pe, amõ pandu: “Ywa pehĩ, aja pekwa, a'erehe jete katu te atu ihẽ apandu. A'erehe ihẽ apandu ame'ẽ ke ihẽ ama'e katu ta” aja pekwa katu tĩ. —Aja pandu rahã, ywa pe Tupã ihĩ, aja amõ ukwa. Wapyka ngi je'ẽha mondo mondo, aja ukwa tĩ. A'erehe aja pandu rahã, ame'ẽ panduha aja ma'e ta me'ẽ te'e. ");
INSERT INTO urbNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","—Moise je'ẽha mu'e ame'ẽ ta! Parise ta! Mã! Mokõi pekwaha namõ pexo ame'ẽ ta ke pehẽ! Pehẽma'e kupixa ngi ta'yr mi ma'e ke Tupã pe peme'ẽ me'ẽ. Pehẽ mi'u muhembykiha ke peme'ẽ. Ky'in. Ma'ero muhe'ẽ ame'ẽ ke. Aja peme'ẽ me'ẽ. Katu ame'ẽ. Amõ we anĩ. Moise je'ẽha katu te ame'ẽ ke rehe pehendu ym. Katu ame'ẽ ke amõ ta pe pema'e ym. Amõ ta rehe pepyrara ym pesak. Mã! Kuja riki katu te me'ẽ ke. Ma'e ke pepandu, aja pema'e ta me'ẽ te'e. Te'e peje'ẽ ym. Katu ame'ẽ ke amõ ta pe pema'e ta me'ẽ te'e tĩ. Amõ ta rehe pepyrara pesak ta me'ẽ te'e tĩ. Pehẽma'e ta'yr mi Tupã pe pemujywyr ta me'ẽ te'e tĩ. Mã! Upa aja pema'e ym. A'erehe pehẽ ke Tupã mupyrara ta. ");
INSERT INTO urbNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Eha ym te ame'ẽ ta aja pehẽ. Pe, amõ ta ke pehykýi peraho aja saka. Pehẽ pekwaha ke pemu'e, a'erehe pehykýi peraho aja saka. Moise je'ẽha ta'yr te mi, ame'ẽ ke rehe pehendu katu. Moise je'ẽha katu te ame'ẽ ke rehe pehendu ym. Katu ym aja. ");
INSERT INTO urbNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","—Moise je'ẽha mu'e ame'ẽ ta! Parise ta! Mã! Mokõi pekwaha namõ pexo ame'ẽ ta ke pehẽ. Kúi soroka ke pejuhyk katu. Ita rekúi ra'yr soroka aja tĩ. Soroka ke pejuhyk tĩ. Jywĩ pe anĩ. Upa ma'e ka'u te'eha pehĩ. Ame'ẽja saka pehẽ. Pehẽ pejahuk riki. Soroka jõ pekutuk katu. Pehẽ py'a pe upa ma'e peka'u te'eha pehĩ, ame'ẽja saka. (Pehẽ py'a juhyk ym, aja pexo.) Amõ tama'e ke pemukanim peraho. Ame'ẽ namõ pexo. Katu ym aja. Amõ ta rehe pekyty'ym tĩ. Mã! Pehẽ ke Tupã mupyrara ta. ");
INSERT INTO urbNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Parise ta! Eha ym te ame'ẽ ta aja pehẽ! Jywĩ ke pekutuk py, aja pexo. (Aja rahã, pehẽ py'a juhyk, aja pexo ta.) Aja rahã, soroka xi'a ym ta tĩ, aja pexo tĩ. Pehẽ py'a pe ma'e katu ame'ẽ ke pekwa pekwa pexo. Aja rahã, upa juhyk, ame'ẽ ta aja pexo ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","—Moise je'ẽha mu'e ame'ẽ ta! Parise ta! Mã! Pehẽ ke Tupã mupyrara ta! Mokõi pekwaha namõ pexo ame'ẽ ta aja pehẽ tĩ. Kangwerupa pe ita ke amõ mupu'am. “Ko kangwerupa” aja mujekwa. Ame'ẽ ke amõ mutuwyr. Amõ usak rahã, katu aja ukwa. Ywy jywĩ pe ixangwer heta ihĩ. Inẽha pehĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Aja saka riki pehẽ. Pehẽ rehe amõ usak rahã, katu, aja ukwaha naĩ. (Kangwerupa pe ita pehĩ, ame'ẽja saka.) Pehẽ py'a riki upa peka'u te'eha ihĩ. (Ywy jywĩ pe ixangwer pehĩ, ame'ẽja saka.) Ma'e peka'u te'eha ke pema'ema'e. Mokõi pekwaha namõ pexo ame'ẽ ta ke pehẽ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","A'e pandu tĩ: —Moise je'ẽha mu'e me'ẽ ta! Parise ta! Pehẽ katu te aja pekwaha pehẽ jupe! Anĩ. Jaxer ame'ẽ ta ke pehẽ! Mã! Pehẽ ke Tupã mupyrara ta! Mokõi pekwaha namõ pexo ame'ẽ ta ke pehẽ. Ymanihar Tupã je'ẽha pandu ame'ẽ ta kangwer 'ar pe ngã ukwaha pemupu'am. Ita ke pemupu'am. Ymanihar katu ame'ẽ ta kangwer 'ar pe ngã ukwaha pemupu'am tĩ. Ngã harái ym, ame'ẽ ukwaha ke. Ame'ẽ ke pemukatu. Aja rahã, ngã pandu: “Mã! Katu te” aja. ");
INSERT INTO urbNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Pe, pepandu: “Jande ramũi namõ jaxo ta tipe rahã, a'eta ma'e, aja jama'e ym ta tipe. Ymanihar ta aja Tupã je'ẽha pandu ame'ẽ ta ke jajukwa ym ta tipe tĩ” aja pepandu. ");
INSERT INTO urbNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mã! Aja rahã, jukwaha ta rainõ ta ke pehẽ, aja pepandu. Tupã je'ẽha pandu ame'ẽ ta ke pehẽ ramũi ta jukwa. Ame'ẽ jukwaha ta rainõ ta ke pehẽ. (Aja rahã, ame'ẽ ta aja pema'e ta tĩ, aja pepandu.) ");
INSERT INTO urbNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pehẽ ramũi ta aja tapijar te'e we ma'e peka'u te'eha ke pema'e apo tĩ. Mã peja pehẽ ramũi ma'eha ke pemumbarahã! Ihẽ riki Tupã je'ẽha apandu, ame'ẽ ke ihẽ tĩ. Ihẽ ke pejukwa ta. Aja rahã, pehẽ ramũi ta ma'eha ke pemumba ta tĩ, aja ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","—Mbói aja pehẽ tĩ! Mbói ra'yr aja pehẽ tĩ! Amõ ke mbói ahy su'u rahã, mahy, aja amõ ta ixoha ke pemujaxer riki. Katu ym aja. Mupyraraha renda pe pehẽ ke Tupã mupyrara ta. Marã ka ym pehemiha. ");
INSERT INTO urbNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","—Ko apandu pehẽ pe. Pehẽ koty Tupã je'ẽha pandu ame'ẽ ta ke ihẽ amondo ta. Ukwa katu ame'ẽ ta ke ihẽ amondo ta tĩ. Tupã je'ẽha mu'e ame'ẽ ta ke ihẽ amondo ta tĩ. Ame'ẽ ta ngi har amõ amõ ke pejukwa ta. Amõ ta ke myra ngã mupia ame'ẽ ke rehe pejukwa ta tĩ. Amõ ta ke jundéu awa tama'e jy'ariha renda pe pemupirok hũ ta tĩ. Hok ngi amõ ta ke pemujan ta pemondo. Amõ amõ ok ta rupi pemujan ta pemondo. ");
INSERT INTO urbNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","36","Aja rahã, pehẽ ke Tupã mupyrara ta. Yman katu ame'ẽ ta ke amõ ta jukwa. Ame'ẽ ta ke Tupã mupyrara ta. Pehẽ riki upa katu te ame'ẽ mupyraraha ke pepyhyk ta. Ambéu riki katu ame'ẽ ke a'e. A'e ke amõ jukwa. A'engi amõ amõ heta katu ame'ẽ ta ke pehẽ ramũi ta jukwa. Pe, a'ejõhar Sakari rehe uhyk. A'e ke pejukwa tĩ. Mbaraki ra'yr ke a'e. Aja upa katu te jukwa ame'ẽ ta ke Tupã mupyrara ta. Ame'ẽ mupyraraha ke pehẽ aja amõ ta pyhyk ta tĩ. Pehẽ ke Tupã mupyrara ta. Ko jetehar te apandu pehẽ pe. Yman katu ame'ẽ ta ke amõ ta jukwa. Upa katu te ame'ẽ jukwaha mupyraraha ke pehẽ aja ame'ẽ ta pyhyk ta tĩ — aja Moise je'ẽha mu'e ame'ẽ ta pe Jesu pandu. Parise ta pe pandu tĩ. Tupã rehe ngã jumu'eha renda keruhũ pe kapy katu te ame'ẽ ke ihĩ. Myrape ihĩ tĩ. Ame'ẽ mokõi pyter pe Sakari ke amõ jukwa. Tupã rehe ipy'a ke amõ moĩ moĩ rahã, ame'ẽ myrape 'ar pe hymba ke hapy. (A'ep ixo rahã, a'e ke jukwa ym ta me'ẽ te'e. Anĩ. Jukwa riki. Katu ym aja.) ");
INSERT INTO urbNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesu pandu tĩ: —Mã! Jerusarẽ ok ta pe har ta! Tupã je'ẽha pandu ame'ẽ ta ke pejukwa. Tupã muwyr ame'ẽ ta ke ita pe pejapi. Aja pejukwa. Pehẽ rehe ihẽ jywa ke ihẽ amaman tar katu tipe. Sapukái ra'yr ta ke ipypo wyr pe imãi moĩ. Aja saka pehẽ rehe ihẽ apy'a katu tipe. Anĩ. Peputar ym ihẽ ke. ");
INSERT INTO urbNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","A'erehe pehẽma'e Tupã rehe ngã jumu'eha renda keruhũ ke ngã hijar ta oho. (A'ep jy'ar ym te ta ngã tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ko apandu pehẽ pe. Apo har ihẽ rehe pesak ym te ta. “Jandema'e sawa'e te je'ẽha rupi tur ame'ẽ rehe mã peja Tupã usak katu” aja pepandu rahã jõ, ihẽ rehe pesak ta tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tupã rehe ngã jumu'eha renda keruhũ ngi Jesu uhem oho. Uhem ixo rahã, jumu'eha ta pandu ipe: —Esarahã! Mã! Katu jumu'eha renda keruhũ ke — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesu pandu: —A'e tỹ. Pesak katu ehe apo. Yman rahã nixói ta. Ko apandu pehẽ pe. Peme'ẽ ke amõ ta upa mujaxer ta kỹ. Ita mokõi mokõi ihĩ ym te ta. Upa katu te ita ke amõ ta ombor ta. Aja rahã, Tupã rehe ngã jumu'eha keruhũ muhãi ta — aja jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jumu'eha renda keruhũ ngi uhem rahã, ywy'ã 'ar pe jupir oho. Ywy'ã rer Oriwéi ty. A'ep Jesu wapyk uĩ. Pe, amõ ta nixói rahã, jumu'eha ta jõ pandu uwyr ipe. A'eta pandu: —Myja rahã, ita mokõi mokõi ihĩ ym ta my? Emujekwa jande pe. Ma'e uhyk rahã, nde erejywyr ta, aja jakwa ta my? Ma'e uhyk rahã, 'ar rehe angaha uhyk ta, aja jakwa ta my tĩ? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","A'e pandu: —Pesak katu kỹ! Mã peja pehẽ ke amõ ta muka'u te'e ym. ");
INSERT INTO urbNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Heta uwyr ta. “Jesu je'ẽha rupi ihẽ ajur” aja pandu te'e ta. “Ko Kirisutu ihẽ. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke ihẽ” aja pandu te'e ta tĩ. Pe, heta ngã ke a'eta muka'u te'e ta. ");
INSERT INTO urbNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Jumai ha tyapuha ke pehendu ta. “Paite amõ ta jumai ixo” aja pehendu ta tĩ. Pemukahem ym ingi. Aja jumaiha uhyk ta. Uhyk rahã, 'ar rehe angaha uhyk ym we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Amõ amõ ywy pe har ta jumai mai ta ngã juehe. Kapitã keruhũ riki amõ kapitã keruhũ namõ jumai mai ta. Amõ amõ ywy pe ngã mi'u nixói te ta. Amõ amõ ywy katak hũ ta. ");
INSERT INTO urbNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Upa aja riki ahy py, ame'ẽja saka. Kũjã imembyr u'ar tate rahã, ahy py. Aja ahyha mangaha riki. I'i we rahã, ahy te ta. (Aja rahã, amõ we mupyraraha uhyk ta, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","—'Ar rehe angaha uhyk ym rahã we pehẽ ke amõ ta pyhyk ta. Sonda ta koty pehẽ ke mondo ta. Pehẽ ke a'eta mahy ta. Pehẽ ngi har amõ amõ ke a'eta jukwa ta tĩ. Ihẽ kotyhar ta ke pehẽ, a'erehe pehẽ rehe ngã parahy ta. Putar ym ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Arahã, ihẽ rehe jurujar katuha ke heta hijar ta. Pe, ame'ẽ ta sonda ta pe pandu ta: “Pehĩ. Peme'ẽ riki Jesu kotyhar ta ke tĩ. Pepyhyk peho” aja. Ame'ẽ ta parahy ta ngã juehe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pe, heta Tupã je'ẽha pandu ame'ẽ ta ran uwyr ta. Heta hũ ngã ke ame'ẽ ta muka'u te'e hũ ta. A'erehe ihẽ rehe jurujar katuha ke hijar ta. ");
INSERT INTO urbNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ma'e ka'u te'eha ke i'ar koty te we ohoha. Pe, Tupã rehe ipy'a katuha hijar hijar ta oho. ");
INSERT INTO urbNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pe, a'ejõhar rehe tapijar te'e we ihẽ rehe jurujar katu rahã, ame'ẽ ta ke Tupã muhã katu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tupã koty ipy'a ke amõ muruwak rahã, ame'ẽ pe: “Ihẽ kotyhar ke nde” aja Tupã pandu ta. Ame'ẽ myrandu katu ke kome'ẽ ywy keruhũ rupi ihẽ kotyhar ta pandu pandu ta oho. Upa ngã hendu ta. Aja rahã jõ 'ar rehe angaha uhyk ta — aja Jesu mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","'Ar rehe angaha uhyk ta, ame'ẽ rehe har Jesu pandu tĩ: —Ma'e jaxer ai te ame'ẽ rehe pesak ta tĩ. Tupã rehe ngã jumu'eha renda keruhũ pe ixo ta. Kapy katu te ame'ẽ pe ixo ta. Ame'ẽ rehe har Ndanie mupinim yman. A'e riki Tupã je'ẽha pandu ame'ẽ ke a'e tĩ. Kome'ẽ paper rehe amõ usak rahã, mã peja ekwa katu exo. ");
INSERT INTO urbNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ame'ẽ jaxer ai te ame'ẽ rehe ngã usak rahã, mã peja ywy'ã koty kanim ujan oho. Jundéi ywy pe har ta kanim ujan oho. (Aja rahã, manõ ym ta.) ");
INSERT INTO urbNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","—Hok kupe 'ar pe amõ ixo rahã, mã peja hok wyr pe ima'e ke pyhyk ym oho. (I'i pyta ym.) Pahar ujan oho. (Aja rahã, manõ ym ta.) ");
INSERT INTO urbNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kupixa pe amõ paraky ixo rahã, mã peja hok pe jywyr ym oho. Kamixa pyhyk ym oho. Pahar ujan oho. (Aja rahã, manõ ym ta.) ");
INSERT INTO urbNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","—Ame'ẽ 'ar rahã, ipusu pe imembyr ixo, ame'ẽ ta pyrara ta ixo. (Marã ka ym pahar ujaniha.) Imembyr pe kamby me'ẽ, ame'ẽ ta pyrara ta ixo tĩ. (Marã ka ym pahar ujaniha.) ");
INSERT INTO urbNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tupã namõ pepandu katu: “Aman ndy'ar rahã anĩ. (Aman heta rahã, jande jajan tar ym)” aja. Kuja tĩ. “Jundéu awa tama'e putu'u 'ar rahã anĩ. (Arahã jundéu awa ta wata ym riki)” aja Tupã namõ pepandu. ");
INSERT INTO urbNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ame'ẽ jaxer ai te ha 'ar rahã, ngã pyrara te hũ ta. Arahã jõ pyrara te hũ ta. Aja pyraraha ke amõ ukwa ym riki. Kome'ẽ ywy keruhũ Tupã mujã ame'ẽ ngi har, aja pyrara te ha nixói. Pe, yman rahã, aja uhyk ym ta tĩ. Arahã jõ pyrara te hũ ta ngã. ");
INSERT INTO urbNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","—Arahã jõ aja ahyha keruhũ 'ar ke Tupã muheta ym. Aja ym rahã, nixói te ta awa. Upa manõ ta. Tupã kotyhar ta ixo. A'erehe ahyha keruhũ 'ar ke a'e muheta ym ta. ");
INSERT INTO urbNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Pe, pehẽ pe amõ pandu: “Pesarahã! Kirisutu kotete ixo” aja. Ame'ẽ rehe pejurujar ym. Amõ pandu: “Pesarahã! Kirisutu paite ixo” aja. Ame'ẽ rehe pejurujar ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kirisuturan uhyk ta. Tupã je'ẽha pandu ame'ẽ ta ran uhyk ta tĩ. Marã ka ym amõ ma'eha, ame'ẽ ke ame'ẽ ta ma'ema'e ta tĩ. Aja Tupã kotyhar ta ke muka'u te'e tar katu. ");
INSERT INTO urbNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pehendu katu! Aja uhyk ym rahã we, pehẽ pe upa ihẽ apandu. Upa ihẽ amujekwa ko. ");
INSERT INTO urbNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Pe, amõ ta pandu ta pehẽ pe. “Pesarahã! Awa nixói te ame'ẽ pe a'e ixo” aja. Ame'ẽ rehe pejurujar ym. (A'ep peho ym.) Amõ pandu: “Pepaite a'e kanim ixo” aja. Ame'ẽ rehe pejurujar ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","—Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Yman rahã, ihẽ ajywyr ajur rahã, upa ngã ukwa katu ta. Tupã pirãha muwera rahã, warahy uhemiha koty ixo ame'ẽ ta ukwa katu. Warahy u'ariha koty ixo ame'ẽ ta ukwa katu tĩ. Upa katu te awa ta ukwa katu. Aja ihẽ ajywyr ajur rahã, upa katu te awa ta ukwa katu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pesarahã! So'o inem ame'ẽ ke pehĩ rahã, pahar xumukape ukwa katu. (Pe, jy'ar oho ehe.) Aja ihẽ ajywyr ajur rahã, upa katu te awa ta ukwa katu te ta tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","A'e pandu tĩ: —Ame'ẽ ahyha keruhũ 'ar upa rahã, amõ we mãte ma'e uhyk ta. Warahy uwe ta. Jahy wera ym ta tĩ. Ywa ngi jahy rata u'ar u'ar ta tĩ. Ywa pe ihĩ ame'ẽ ke Tupã mukatak hũ ta. ");
INSERT INTO urbNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ame'ẽ upa rahã, ihẽ ajywyriha ukwaha ke ywa pe ihẽ amoĩ ta. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ywa takãxĩha 'ar pe ihẽ ajywyr ta ajur. Tupãma'e pyrãtãha namõ ajur ta. A'e katu te ha namõ ajur ta tĩ. Pe, ihẽ rehe kome'ẽ ywy keruhũ pe har ta usak rahã, jixi'u ta. (“Jande ke mupyrara ta apo” aja ukwa, a'erehe jixi'u ta.) ");
INSERT INTO urbNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tupãma'e jumi'a keruhũ tyapu ta. Tupã riki ima'e je'ẽha rahoha ta ke muwyr ta. Upa katu te kome'ẽ ywy keruhũ rupi muwyr ta. Pe, upa katu te Tupã kotyhar ta ke a'eta mujy'ar ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","A'e pandu tĩ: —Ihẽ ajywyriha ke ma'eywa'y mujekwa ta pehẽ pe. Sik'y ke. Hãkã rehe hokyr uhem rahã, warahy haku tate, aja pekwa. ");
INSERT INTO urbNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aja ihẽ ajywyriha riki. Ihẽ apandu ramõ, ma'e warahy uwe. Ma'e jahy rata ta katak. Upa aja pesak rahã, ihẽ riki ajywyr tate, aja pekwa katu ta tĩ. (Hãkã rehe hokyr uhem, ame'ẽja saka.) ");
INSERT INTO urbNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Pesarahã! Apandu katu pehẽ pe. Amõ ihẽ kotyhar ta pyrara hũ ta ixo. Upa aja me'ẽ uhyk ta kỹ. Manõ ym ta rĩ. Upa usak ta. (Anĩ. Tapijar te'e we ihẽ rehe jurujar katu ta rĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ywa upa kanim ta. Kome'ẽ ywy keruhũ upa kanim ta tĩ. Ihẽ apandu ame'ẽ ke anĩ. Ame'ẽ ke kanim ym te ta. (Aja ihẽ je'ẽha rehe jurujar katu ame'ẽ ta tapijar te'e we ixo ta kỹ.) Apandu, aja me'ẽ upa katu te uhyk ta kỹ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","A'e pandu tĩ: —Myja rahã, ihẽ ajywyr ta my? Ma'e wera rahã, ajywyr ta my? My warahy rahã, ajywyr ta my? Ame'ẽ ke ukwa ym awa. Ywa pe ixo Tupã je'ẽha rahoha ta ukwa ym tĩ. Ihẽ riki akwa ym tĩ. Ihẽ pái jõ ukwa katu. ");
INSERT INTO urbNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ ajywyriha riki kuja. Yman Noe ixo. Arahã aja saka tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Y keruhũ upa ngã ke jukwa. Kuja riki. Y keruhũ uhyk tate rahã, aja te'eha ngã ixo. Amõ ta kekar oho. Pe, so'o ke jukwa rahã, ame'ẽ ke u'u riki. Sawa'e ta kũjã ta ke pyhyk. Kũjã ta sawa'e ta ke pyhyk tĩ. Aja te'e ngã ixo. Jarusu keruhũ pe Noe ixe ym rahã we, aja te'e ngã ixo. ");
INSERT INTO urbNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Y keruhũ uhyk ta, aja ngã harõ ym. Pe, y keruhũ uhyk rahã, upa katu te y jukwa. Aja ihẽ ajywyr rahã, ngã harõ ym rahã, ihẽ ajywyr ta. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. ");
INSERT INTO urbNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","—Ihẽ ajywyr rahã, kuja ta tĩ. Kupixa pe mokõi sawa'e ta paraky ixo. Peteĩ pyta ta a'ep. Amõ ke Tupã je'ẽha rahoha ta raho ta. ");
INSERT INTO urbNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Paratu rok pe mokõi kũjã ta paraky u'am. Peteĩ pyta ta a'ep. Amõ ke Tupã je'ẽha rahoha ta raho ta. ");
INSERT INTO urbNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","A'erehe pesak katu pexo. Peta kỹ. Ihẽ ajywyriha angaha ke pekwa ym. A'erehe pesak katu pexo. Ihẽ riki pehẽma'e sawa'e te. ");
INSERT INTO urbNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ma'e mukanĩha uwyr ame'ẽ ke ok jar ukwa rahã, ukwer ym ta tipe. Harõ ta tipe. Hok pe mukanĩha ixe tate rahã, a'e ke ok jar mujan ta tipe mondo. ");
INSERT INTO urbNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","A'erehe pesak katu pexo. Peta kỹ. Peharõ ym pexo rahã, ihẽ ajywyr ta. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","(Miasu katu ame'ẽ ta aja ixotyhar ta ixo ta me'ẽ te'e tĩ. Aja Jesu mu'e tar katu.) A'erehe a'e pandu: —Myja me'ẽ miasu riki ukwa katu ame'ẽ ke my? Myja me'ẽ miasu riki ijar pandu ame'ẽ ke ma'ema'e katu my? Ko apandu ta. Amõ miasu pe ijar pandu: “Amõ miasu ta rehe esak esak katu exo. Myahy rahã, a'eta mi'u ke eme'ẽ me'ẽ katu a'eta pe” aja ijar. Pe, ijar paxia oho. ");
INSERT INTO urbNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Pe, ijar pandu, aja miasu ma'ema'e ixo. Hok pe jywyr rahã, ame'ẽ ke rehe ijar usak. Aja rahã, ame'ẽ miasu hury katu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Pesarahã! Ihẽ apandu pehẽ pe. Ame'ẽ miasu pe kuja ijar pandu ta: “Katu ame'ẽ ke nde. Upa katu te ihẽma'e ke rehe nde eresak eresak katu ta apo 'y” aja ta. ");
INSERT INTO urbNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","—Aja ym rahã, katu ym. Miasu katu ym ame'ẽ ke rahã, kuja jupandu jupe: “Ihẽ jar pepaite oho. Yman rahã jywyr ta” aja jupe. ");
INSERT INTO urbNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Pe, amõ miasu ta ke a'e nupã nupã ta. Pe, jaxer ame'ẽ ta namõ ma'e ke a'e u'u hũ ta uĩ. Kawĩ ngi ka'u, ame'ẽ ta namõ u'u uĩ. Ka'u tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pe, ijar rehe harõ ym rahã, ame'ẽ wera rahã, ijar jywyr ta. “Apo jywyr ym we ta rĩ” aja pandu rahã, pahar ijar jywyr ta. ");
INSERT INTO urbNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ame'ẽ miasu jaxer ame'ẽ ke ijar pirok hũ te ta. Mokõi ukwaha ta ke amõ ta mupyrara hũ, aja ame'ẽ miasu ke ijar mupyrara hũ ta tĩ. (Ahy te hũ,) a'erehe jixi'u hũ ta. (Ahy te hũ,) a'erehe hãi ke su'u su'u ta tĩ — aja Jesu pandu. (A'erehe miasu katu aja Jesu jywyriha rehe ixotyhar ta harõ katu ta me'ẽ te'e tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesu pandu tĩ: —Ihẽ ajywyr rahã, kuja riki Tupã ma'eha. Awa riki inamõ ixo ta my? Awa riki inamõ ixo ym te ta my? Ame'ẽ ke amujekwa ta. Kuja. Amõ rahã, jande popa kũjãtãi ta ixo. Pytun rahã, araparin ke kũjãtãi ta raho. Sawa'e jumendar ame'ẽ rehe usak oho. ");
INSERT INTO urbNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Awa po wajar peteĩhar upa kũjãtãi ta ukwa katu ame'ẽ ta ke. Amõ awa po wajar peteĩhar upa anĩ. Ukwa katu ym riki. ");
INSERT INTO urbNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","4","Awa po wajar peteĩhar upa kũjãtãi ta riki ukwa katu ame'ẽ ta ke a'eta. A'erehe araparin raho rahã, amõ hyru pe tykwer tyryhem raho. Amõ kũjãtãi ta anĩ. Ukwa katu ym ame'ẽ ta ke a'eta. A'erehe araparin raho rahã, amõ hyru pe tykwer raho ym. ");
INSERT INTO urbNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Sawa'e jumendar ame'ẽ ke pyta we rĩ. Uhyk ym we rĩ. I'i hũ pyta. A'erehe kũjãtãi ta pyhýi hũ. Pe, ukwer tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","—Pytun pyter pe amõ pandu: “Petur. Sawa'e jumendar ta ame'ẽ ke petur. Peho. Pesak pehorahã!” aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Upa kũjãtãi ta upak. Pe, araparin hapy tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pe, kũjãtãi ukwa katu ame'ẽ ta pe amõ ta pandu. Ukwa katu ym ame'ẽ ta pandu: “Jandema'e araparin uwe tate. Jande pe tykwer pemuwyr we mi” aja. ");
INSERT INTO urbNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Anĩ. Pehẽ pe jame'ẽ rahã, jandema'e uwe ta tĩ. Upa jande pe uhyk ym tykwer. Muhepyha renda pe pejo'ok peho” aja ukwa katu ame'ẽ ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","—A'erehe ukwa katu ym ame'ẽ ta jo'ok oho. A'eta nixói rahã, sawa'e jumendar ame'ẽ ke uhyk uwyr. Awa po wajar peteĩhar upa kũjãtãi riki araparin hapy, aja ixo. Pe, sawa'e namõ ixe oho. Ngã mi'u matyr ame'ẽ rehe ixe oho. Huryha rehe ixo katu. Upa ixe rahã, hukwen ke amõ kynda katu. ");
INSERT INTO urbNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","—I'i rahã amõ kũjãtãi ta uhyk uwyr tĩ. “Sa'e! Hukwen epirar jande pe” aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Anĩ ta. Pehẽ ke ihẽ akwa ym” aja sawa'e jumendar ame'ẽ ke pandu — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","A'e pandu tĩ: —Aja riki ihẽ ajywyriha. Myja rahã, ihẽ ajywyr ta my? Ame'ẽ ke pekwa ym. My warahy rahã, ihẽ ajywyr ta my? Ame'ẽ ke pekwa ym tĩ. A'erehe pesak katu kỹ. Peharõ katu pexo — aja jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesu pandu tĩ: —Ihẽ apandu ame'ẽ ke ihẽ kotyhar ta ma'ema'e katu rahã, ma'e katu ame'ẽ ke ihẽ ame'ẽ me'ẽ ta a'eta pe. Ame'ẽ rehe har amujekwa ta apo. Kuja riki. Amõ sawa'e ixo. Pepaite paxia tate rahã, miasu ta pe a'e pandu: “Upa ihẽma'e ke rehe pesak” aja. ");
INSERT INTO urbNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pe, tamatarer ke a'e me'ẽ me'ẽ. Amõ miasu pe 5.000 itatuwyr tamatarer me'ẽ. Amõ pe 2.000 itatuwyr tamatarer a'e me'ẽ. Amõ pe 1.000 itatuwyr tamatarer a'e me'ẽ. Miasu ta ma'eha ukwa katuha, aja ijar me'ẽ me'ẽ. Upa me'ẽ rahã, pepaite paxia oho. ");
INSERT INTO urbNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","—Kuja, 5.000 itatuwyr tamatarer pyhyk, ame'ẽ miasu pahar oho. Ame'ẽ tamatarer namõ muhepy hepy. Pe, muheta. Amõ 5.000 itatuwyr tamatarer pyhyk. (A'erehe 10.000 hetaha apo 'y.) ");
INSERT INTO urbNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aja amõ miasu tĩ. Kuja, 2.000 itatuwyr tamatarer pyhyk ame'ẽ ke. Tamatarer namõ a'e muhepy hepy tĩ. Pe, muheta tĩ. Pe, amõ 2.000 itatuwyr tamatarer ke a'e pyhyk. (A'erehe 4.000 hetaha apo 'y.) ");
INSERT INTO urbNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amõ miasu anĩ. 1.000 itatuwyr tamatarer pyhyk ame'ẽ ke. Ywykwar ke a'e pykũi oho. Pe, ijarma'e tamatarer ke a'ep a'e mou. Jupyk tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","—Yman rahã, miasu jar jywyr uwyr. Pe, miasu ta ma'ema'eha ke a'e ukwa ta. ");
INSERT INTO urbNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kuja, 5.000 itatuwyr tamatarer pyhyk, ame'ẽ miasu uhyk py. Ijar pe 5.000 itatuwyr tamatarer ke a'e mujywyr. A'e pandu: “Sawa'e! Kuja 5.000 itatuwyr tamatarer ihẽ pe nde ereme'ẽ. Esarahã! Ko amõ 5.000 itatuwyr tamatarer ke ihẽ apyhyk. Amuheta riki. A'erehe ko 10.000 hetaha kohĩ” aja ijar pe. ");
INSERT INTO urbNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Mã! Katu! Nde katu. Ihẽ apandu ame'ẽ ke nde erema'ema'e katu. Ta'yr mi tamatarer namõ nde ereparaky. Apo heta ame'ẽ namõ nde ereparaky ta. Ejur. Ihẽ rury katu riki. Aja nde rury katu nde erexo tĩ” aja ijar ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","—Pe, amõ miasu uhyk uwyr tĩ. Kuja, 2.000 itatuwyr tamatarer pyhyk ame'ẽ ke a'e. A'e pandu: “Sawa'e! Kuja, 2.000 itatuwyr tamatarer ihẽ pe nde eremuwyr. Ame'ẽ kohĩ. Esarahã! Amõ we 2.000 itatuwyr tamatarer ke ihẽ apyhyk. Amuheta riki. A'erehe ko 4.000 hetaha kohĩ” aja ijar pe. ");
INSERT INTO urbNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Mã! Katu! Nde katu. Ihẽ apandu ame'ẽ ke nde erema'ema'e katu. Ta'yr mi tamatarer namõ nde ereparaky. Apo heta ame'ẽ namõ nde ereparaky ta. Ejur. Ihẽ rury katu riki. Aja nde rury katu nde erexo tĩ” aja ijar ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","—Pe, kuja, 1.000 itatuwyr tamatarer pyhyk, ame'ẽ miasu uhyk uwyr tĩ. Pandu: “Sawa'e! Amõ rehe nde erepyrara nde eresak ym ame'ẽ ke nde, aja akwa. Amõma'e kupixa ngi ma'e ke nde ere'u. Nde erejytym ym, ame'ẽ kupixa ngi. Amõma'e ke nde erematyr tĩ. Nde erejytym ym ame'ẽ ke, amõ riki jytym. (Aja rahã, amõ riki paraky ame'ẽ ke nde erepyhyk.) ");
INSERT INTO urbNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nde ngi ihẽ akyje. A'erehe nema'e tamatarer ke ywykwar pe ihẽ amukanim araho. Esarahã! Ko 1.000 itatuwyr tamatarer nema'e ke” aja ijar pe. ");
INSERT INTO urbNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ame'ẽ ke rehe hendu rahã, ijar pandu ipe: “Mã! Nde katu ym! Jyty'ym ame'ẽ ke nde. Ihẽ ajytym ym, ame'ẽ kupixa pe har ma'e ke ihẽ a'u. Ihẽ ajytym ym, amõ jytym ame'ẽ ke ihẽ amatyr, aja nde erekwa katu. Amõ paraky ame'ẽ ke ihẽ apyhyk, aja nde erekwa katu. ");
INSERT INTO urbNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aja rahã, tamatarer renda pe ihẽma'e tamatarer ke nde eremupyta ta me'ẽ te'e. Aja rahã, amõ ta riki ihẽma'e tamatarer namõ paraky ta tipe. Aja muheta ta tipe. Aja rahã, ihẽ ajywyr rahã, i'ar koty te we ihẽma'e tamatarer muheta ta tipe” aja ijar pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Pe, amõ miasu pe ijar pandu tĩ: “Tamatarer ejo'ok ingi. Miasu katu ym ame'ẽ ke ngi ejo'ok. Pe, 10.000 hetaha namõ ixo ame'ẽ pe eme'ẽ. ");
INSERT INTO urbNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ma'e ta'yr mi ame'ẽ namõ amõ ma'ema'e rahã, amõ we hũ amõ me'ẽ ta ipe. Aja rahã, ima'ehũ ta. Pe, ma'e ta'yr mi ame'ẽ namõ amõ ma'ema'e ym rahã, ame'ẽ ta'yr mi ame'ẽ ke amõ jo'ok ta ingi. Aja rahã, nixói te ta ima'e ke. ");
INSERT INTO urbNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Apo kome'ẽ miasu jaxer ame'ẽ ke embor eho, soroka pe. Pytuniha renda pe embor. A'ep ahy ta. A'erehe jixi'u ta. Ahy te ta, a'erehe hãi ke su'u su'u ta” aja ijar pandu — aja Jesu pandu. (Aja Tupã kotyhar ta ma'ema'e ta me'ẽ te'e tĩ. Ma'e ke Tupã me'ẽ, ame'ẽ namõ ma'ema'e katu ta me'ẽ te'e tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesu pandu tĩ: —Ko awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Kapitã keruhũ aja ihẽ ajywyr rahã, Tupã je'ẽha rahoha ta ihẽ namõ uwyr ta tĩ. Arahã myrape katu te ame'ẽ pe ihẽ awapyk ta aĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Pe, upa katu te kome'ẽ ywy keruhũ pe har ta ke mujy'ar ta. Tupã je'ẽha rahoha ta mujy'ar ta. Ihẽ ruwa koty mujy'ar ta. Pe, ngã ke ihẽ amondo mondo ta. Se koty amõ ta ke ihẽ amondo ta. Amõ ta amõ koty. Arapuharan usakiha ta aja saka. Arapuhame ta ke arapuharan ta pyter ngi mondo mondo. Aja ngã ke ihẽ amondo mondo ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Katu ame'ẽ ta ke ihẽ jywa katu koty ihẽ amondo ta. Amõ pyta ame'ẽ ta ihẽ jywa'i koty ihẽ amondo ta. ");
INSERT INTO urbNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ihẽ riki kapitã keruhũ. Pe, ihẽ jywa katu koty i'ãi, ame'ẽ ta pe kuja ihẽ apandu ta: “Pejur! Pehẽ riki ihẽ pái ke muhury katu ame'ẽ ta ke pehẽ. Ihẽ pái renda pe pexe peho. Ame'ẽ renda ke yman a'e mukatu. Kome'ẽ ywy keruhũ a'e mujã rahã, ame'ẽ renda ke a'e mujã pehẽ pe tĩ. Apo pexe peho a'ep. ");
INSERT INTO urbNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pesarahã! Ihẽ myahy rahã, ihẽ pe pehẽ mi'u peme'ẽ. Ihẽ hyngwéi rahã, y ke ihẽ pe peme'ẽ tĩ. Ihẽ rehe pesak ramõ rahã, pehẽ rok pe ihẽ ke pemupyta katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ihẽma'e mundeha nixói rahã, pehẽma'e mundeha ihẽ pe peme'ẽ tĩ. Ihẽ ahy axo rahã, ihẽ pe puhã peme'ẽ katu tĩ. Kyndaha pe ihẽ axo rahã, ihẽ rehe pesak pejur tĩ” aja ihẽ apandu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","—Aja rahã, ihẽ jywa katu koty i'ãi ame'ẽ ta pandu ta. Katu ame'ẽ ta ke ame'ẽ ta. Kuja pandu ta: “Sawa'e! Myja rahã nde myahy, pe, jande mi'u nde pe jame'ẽ my? Jakwa ym. Myja rahã, nde nengwéi, pe, nde pe y jande jame'ẽ my tĩ? Jakwa ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Myja rahã, nde rehe jasak ramõ, pe, jande rok pe nde ke jamupyta my? Jakwa ym tĩ. Myja rahã, nema'e mundeha nixói, pe, jandema'e mundeha ke jame'ẽ nde pe my tĩ? Jakwa ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Myja rahã, nde ahy nde erexo, pe, nde pe puhã jame'ẽ katu my? Jakwa ym tĩ. Myja rahã kyndaha pe nde erexo, pe, nde rehe jasak jaho my? Jakwa ym tĩ” aja ihẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","—Pe, ihẽ apandu ta. Ihẽ riki kapitã keruhũ. Kuja apandu ta: “Ko apandu pehẽ pe. Ko ihẽ kotyhar ta ixo. Ihẽ mu ta aja riki. ‘Katu ym’ aja amõ ta ukwaha naĩ. Ame'ẽ ta pe ma'e ke pema'ema'e rahã, ihẽ pe pema'ema'e katu, ame'ẽja saka. A'erehe ihẽ pái renda pe pehẽ rury katuha namõ pexe peho” aja ihẽ apandu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","—Pe, ihẽ jywa'i koty i'ãi, ame'ẽ ta pe kuja ihẽ apandu ta: “Peho ihẽ ngi! Pehẽ riki Tupã mupyrara ta ame'ẽ ta ke pehẽ. Tata keruhũ renda pe peho. Ame'ẽ tata uwe ym te ta. Ame'ẽ renda ke Tupã mujã. A'ep Satana ke mupyrara ta. (Ãjã ramũi ke a'e.) Ame'ẽ renda ke tata keruhũ renda. Satana kotyhar ta ke a'e mupyrara ta a'ep tĩ. Ame'ẽ renda pe peho. ");
INSERT INTO urbNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Pesarahã! Ihẽ myahy rahã, pehẽ mi'u ihẽ pe peme'ẽ ym. Ihẽ hyngwéi rahã, y ke ihẽ pe peme'ẽ ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ihẽ rehe pesak ramõ rahã, pehẽ rok pe ihẽ ke pemupyta ym tĩ. Ihẽma'e mundeha nixói rahã, pehẽma'e mundeha ke ihẽ pe peme'ẽ ym tĩ. Ihẽ ahy rahã, ihẽ pe puhã peme'ẽ ym tĩ” aja ihẽ jywa'i koty i'ãi ame'ẽ ta pe apandu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","—Pe, a'eta pandu ta ihẽ pe: “Sawa'e! Myja rahã, nde myahy my? Pe, jande mi'u jame'ẽ ym nde pe my. Jakwa ym. Myja rahã, nde nengwéi my? Pe, y jame'ẽ ym nde pe my? Jakwa ym tĩ. Myja rahã, nde rehe jasak ramõ my? Pe, jande rok pe nde ke jamupyta ym my? Jakwa ym tĩ. Myja rahã, nema'e mundeha nixói my? Pe, jame'ẽ ym nde pe my? Jakwa ym tĩ. Myja rahã, nde ahy my? Pe, puhã jame'ẽ ym nde pe my? Jakwa ym tĩ. Myja rahã, kyndaha pe nde erexo my? Pe, nde rehe jasak ym jaho my? Jakwa ym tĩ” aja ta. ");
INSERT INTO urbNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","—Ihẽ riki kapitã keruhũ. Kuja ame'ẽ ta pe ihẽ apandu ta. “Ko apandu pehẽ pe. Ihẽ kotyhar ta kohĩ. ‘Ame'ẽ ta katu ym’ aja amõ ta ukwaha naĩ. Ame'ẽ ta pe ma'e ke pema'ema'e ym rahã, ihẽ pe ma'e ke pema'ema'e ym tĩ, ame'ẽja saka” aja ihẽ apandu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pe, ame'ẽ ta ke mupyraraha renda pe ihẽ pái mondo ta. A'ep ahyha upa ym te ta. Katu ame'ẽ ta anĩ. Ihẽ pái namõ aja te'e ta ixo. Uhã te hũ ta a'eta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Jywyriha rehe har upa a'e mu'e rahã, jumu'eha ta pe a'e pandu: —Mokõi jaker rahã, Pasuko 'ar rehe uhyk ta. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ ruwajan ta ke ihẽ rehe amõ muhyk ta werur. Pe, ame'ẽ ta ihẽ ke jukwa ta. Myra ngã mupia ame'ẽ ke rehe jukwa ta — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pe, pa'ihu ta jy'ar oho. Jundéu awa tamũi ta namõ jy'ar oho. Kái rok keruhũ pe jy'ar. Kái riki jundéu awa tama'e pa'i keruhũ. ");
INSERT INTO urbNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","A'eta pandu pandu a'eta jupe: “Jesu ke jande japyhyk ta jaho. Ngã ukwa ym ha rupi japyhyk ta. Pe, a'e ke jande jajukwa ta. ");
INSERT INTO urbNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pasuko 'ar rahã, japyhyk ym we ta rĩ. Anĩ. Arahã japyhyk rahã, ngã parahy ta. Mutyapu tyapu hũ ta. Katu ym aja. A'erehe arahã japyhyk ym we ta rĩ” aja a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mbeta ok ta pe Jesu ihĩ. Simã rok pe ihĩ. Ame'ẽ Simã riki yman pere ma'e u'u hũ ame'ẽ namõ ixo. Apo anĩ. Upa ka'ẽ katu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ma'e ke Jesu u'u uĩ rahã, kũjã uhyk uwyr ehe. Ma'e piheha ke a'e werur. Ame'ẽ hepy hũ ame'ẽ ke. Hyru pe werur. Ame'ẽ hyru riki aramba ke te'e mujã ame'ẽ ke. Pe, kyndaha ke mopok rahã, tykwer ke Jesu ãkã rehe kũjã jyhẽ. ");
INSERT INTO urbNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Ame'ẽ rehe jumu'eha ta usak rahã, parahy kũjã rehe. A'eta je'ẽ je'ẽ hũ: —Mã! Tykwer upa kanim. Ame'ẽ tykwer ke amõ muhepy rahã, tamatarer hũ pyhyk ta tipe. Pe, ame'ẽ tamatarer ke ima'e ym te ame'ẽ ta pe amõ me'ẽ me'ẽ katu ta tipe — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jumu'eha ta panduha ke Jesu ukwa. A'erehe a'eta pe kuja a'e pandu: —Kũjã rehe har aja ym peje'ẽ je'ẽ. Ma'e katu ame'ẽ ke ihẽ pe a'e ma'e. ");
INSERT INTO urbNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ima'e ym te ame'ẽ ta pe ma'e ke peme'ẽ tar katu rahã, pete'e a'eta ixo. Aja te'eha a'eta ixo koropi. Ihẽ anĩ. Aja te'eha pehẽ namõ ihẽ axo ym ta. ");
INSERT INTO urbNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kũjã putar aja a'e ma'e katu. Pesarahã! (Jundéu awa manõ rahã, hete ke amõ ta mupihe te'e, aja te'eha a'eta ma'eha.) Aja ihẽ rehe tĩ. Ihẽ amanõ ym rĩ. Ko ihẽ ke mouha rehe kũjã upa mupihe. (A'erehe ihẽ rehe pyaiha apo mujesak rahã, katu tiki.) ");
INSERT INTO urbNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Pesarahã! Apo ihẽ apandu katu. Ihẽ rehe har myrandu katu ke amõ ta pandu pandu raho. Kome'ẽ ywy keruhũ rupi pandu pandu raho rahã, kome'ẽ kũjã ma'eha rehe har pandu ta tĩ. Kũjã ma'eha ke harái ym ta ngã — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pe, jundéu awa tama'e pa'ihu ta koty Jun oho. Jun amõ her Ikario. Awa py mokõi jumu'eha ta ngi har peteĩ a'e. ");
INSERT INTO urbNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","A'e pandu: —Jesu rehe pehẽ ke amuhyk araho rahã, myja tamatarer hetaha peme'ẽ ta ihẽ pe my? — aja pa'ihu ta pe. —Jande pypa, amõ jande popa hetaha (30) jame'ẽ ta nde pe — aja pa'ihu ta pandu. Pe, itatuwyr tamatarer ke pa'ihu ta manga. Kuja, 30 hetaha me'ẽ Jun pe. ");
INSERT INTO urbNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","A'engi Jesu rehe pa'ihu ta ke muhyk ta raho ame'ẽ angaha ke rehe Jun harõ ixo. ");
INSERT INTO urbNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pasuko 'ar rahã, jundéu awa ta arapuharan ra'yr ka'ẽ ke u'u. Arahã mbeju ke mupururukiha nixói ame'ẽ ke u'u py. Ame'ẽ 'ar rehe har Jesu pe jumu'eha ta pandu: —Pasuko 'ar rahã, arapuharan ra'yr ka'ẽ ke nde ere'u ta. Ame'ẽ ke jamatyr, aja nde ereputar. My jamatyr ta my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesu pandu: —Paite awa ok ta hũ ihĩ, Jerusarẽ ok ta ke. A'ep peho. A'ep amõ sawa'e ixo. Pepandu ipe: “Jandema'e mu'eha pandu: ‘Ihẽ ahoha angaha rehe uhyk. Ihẽma'e jumu'eha ta namõ arapuharan ra'yr ka'ẽ ke ihẽ a'u ta kỹ. Nde rok pe a'u ta kỹ’ aja ipe” — aja jumu'eha ta pe pandu. (“Ohoha angaha” aja pandu rahã: “A'e manõ ta” aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesu pandu ame'ẽ ke jumu'eha ta ma'e katu. Pasuko 'ar rahã, a'eta mi'u ke a'eta matyr. ");
INSERT INTO urbNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pytun ramõ rahã, ame'ẽ renda pe Jesu ta oho. Pe, awa py mokõi jumu'eha ta namõ Jesu wapyk. Arapuharan ra'yr ka'ẽ ke u'u. ");
INSERT INTO urbNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","A'eta u'u uĩ rahã, Jesu pandu: —Ko apandu pehẽ pe. Pehẽ ngi har peteĩ ihẽ rehe ihẽ ruwajan ta ke muhyk ta werur — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ame'ẽ ke rehe a'eta hendu rahã, a'eta pyai uĩ. Peteĩ teĩ Jesu pe pandu: —Sawa'e! Ihẽ ke ame'ẽ my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesu pandu: —Ihẽ namõ arapuharan ra'yr rykwer namõ mbeju ke mururu, ame'ẽ ihẽ rehe ihẽ ruwajan ta ke muhyk ta werur. ");
INSERT INTO urbNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Myja ihẽ amanõ ta my, ame'ẽ ke Tupã je'ẽha rehe amõ mupinim. Ame'ẽ panduha aja ihẽ amanõ ta. Aja ihẽ rehe ihẽ ruwajan ta ke muhyk ta werur, ame'ẽ ke mã Tupã mupyrara hũ ta. Ame'ẽ imãi pusu ngi u'ar ym rahã, katu ta tipe — aja jumu'eha ta pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jun pandu. A'e riki Jesu rehe huwajan ta ke muhyk ta werur ame'ẽ ke a'e. Kuja pandu: —Sawa'e! Ihẽ ke ame'ẽ my? — aja. —A'e tỹ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","A'eta mi'u ke u'u uĩ rahã, mbeju ra'yr ke Jesu pyhyk. Tupã namõ a'e pandu: “Ne jõ riki katu te me'ẽ ke. Jande mi'u jande pe nde ereme'ẽ katu” aja. Upa rahã, mbeju ke mopok, pe, jumu'eha ta pe me'ẽ me'ẽ. Pandu: —Ko pepyhyk. Pe'u. Kome'ẽ riki ihẽ rete — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Upa rahã. Ita rekúi ra'yr ke a'e pyhyk tĩ. Ame'ẽ pe ma'eywa rykwer ihĩ, uwa rykwer ke. Tupã namõ pandu tĩ: “Ne jõ riki katu te me'ẽ ke. Jande mi'u jande pe nde ereme'ẽ katu” aja. Pe, ita rekúi ra'yr ke jumu'eha ta pe me'ẽ. A'e pandu: —Pehẽ johu pe'u. ");
INSERT INTO urbNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kome'ẽ riki ihẽ ruwy. Ihẽ ruwy uhem ta, a'erehe Tupã pandu katu ta: “Ihẽ ra'yr rehe amõ jurujar katu rahã, ame'ẽ ke ihẽ amuhã katu ta” aja Tupã pandu. Ihẽ ruwy uhem ta, a'erehe heta ngã rehe ipy'a ke Tupã mujywyr katu ta. Ma'e ka'u te'eha ke ngã ma'ema'e. Ame'ẽ ta rehe ipy'a ke a'e mujywyr katu ta. ");
INSERT INTO urbNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ko apandu pehẽ pe. Uwa rykwer ihẽ a'u ym te ta apo 'y. Kapitã keruhũ aja ihẽ ke ihẽ pái keruhũ mu'am ta kỹ. Arahã jõ pyahu ame'ẽ ke pehẽ namõ a'u ta kỹ tĩ — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tupã rehe har upa jyngar rahã, ywy'ã koty a'eta oho. Ywy'ã rer Oriwéi ty. ");
INSERT INTO urbNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pe, jumu'eha ta pe Jesu pandu: —Kome'ẽ pytun rahã, upa katu te ihẽ ngi pejan ta peho kỹ. Kuja Tupã je'ẽha rehe panduha ihĩ: “Arapuharan usakiha ke Tupã jukwa ta. Aja rahã, upa arapuharan ta uhãi ta oho” aja amõ mupinim. —Aja ihẽ ke jukwa rahã, upa ihẽ ngi pejan ta peho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pe, ihẽ ke Tupã mukwera katu ta muhem rahã, Ngariréi ywy pe pehẽ ndutar koty ihẽ aho ta — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petu pandu ipe: —Nde ke ihẽ ahijar ym te ta. Nengi upa amõ ta ujan ta oho. Ihẽ anĩ ta. Nde namõ apyta ta kỹ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesu pandu: —Petu! Ko apandu katu nde pe. Kome'ẽ pytun upa ym rahã we, sapukái je'ẽ ym rahã we, mahapyr nde erepandu ta: “Jesu ke akwa ym ihẽ” aja nde erepandu ta — aja Petu pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—Anĩ. Aja ihẽ apandu ym te ta. Nde namõ ihẽ ke amõ ta jukwa rahã: “Nde rehe har akwa ym ihẽ” aja ihẽ apandu ym te ta — aja Petu pandu ipe. Upa amõ jumu'eha ta aja pandu ipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pe, amõ renda pe Jesu oho, Ngese renda pe. Jumu'eha ta inamõ oho tĩ. A'e pandu: —Se pewapyk we rĩ. Kotete Tupã namõ apandu ta aho — aja jumu'eha ta pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pe, iãkã koty we Petu ke a'e raho. Mokõi Semende ra'yr ta ke a'e raho tĩ. Tian ke. Juã amõ. Pyai te riki Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Petu ta pe a'e pandu: —Apyai te hũ ihẽ ke. Amanõ aja ihẽ apyaiha tĩ. Se pepyta we rĩ. Peker ym we rĩ — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A'engi a'e oho we. Ipixi'a pe u'ar te'e oup. Pe, Tupã namõ pandu pandu: —Papa! Nde ereputar rahã, ihẽ apyraraha ngi ihẽ ke emuhem kỹ. Anĩ. Ihẽ aputar ame'ẽ ke ema'e ym. Nde ereputar ame'ẽ ke ema'e katu — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Upa pandu rahã, mahapyr jumu'eha ta rehe uhyk tĩ, Petu ta rehe. A'eta ukwer ou. Mupak rahã, Petu ta pe a'e pandu: —Mã! Peker peju. Ta'yr mi ihẽ namõ pesak ym we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Peker ym we rĩ. Tupã namõ pepandu. Aja rahã pejurujar katuha ke amõ ta manga rahã, pehijar ym ta. Ihẽ namõ nde erepyta tar katu te. Anĩ. Nde riki pitu te'e — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Pe, Petu ta ngi a'e oho we tĩ. Tupã namõ pandu tĩ. Kuja: —Papa! Ihẽ apyraraha ke marã ka ym aha oho ihẽ ngi rahã, ihẽ py'ahu te'e ahendu katu ta kỹ. Nde ereputar ame'ẽ ke ihẽ ama'e ta kỹ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Upa pandu rahã, Petu ta koty a'e jywyr tĩ. A'eta ukwer ou tĩ. Pyhýi riki. ");
INSERT INTO urbNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pe, a'eta ngi a'e oho we tĩ. Tupã namõ pandu tĩ. Ipái namõ pandu ramõ, aja a'e pandu tĩ. Mahapyrihar ke a'e pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pe, upa rahã, Petu ta koty a'e jywyr tĩ. Mupak rahã, a'eta pe pandu: —Mã! Peker peju. Mã! Peputu'u peju we rĩ. A'ewan pekeriha. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Pesarahã! Ihẽ ruwajan ta ke ihẽ rehe amõ muhyk ta werur. Ame'ẽ angaha ke rehe uhyk oho. ");
INSERT INTO urbNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pepu'am. Jahorahã! Pesarahã! Ihẽ ruwajan ta ke ihẽ rehe amõ muhyk ta werur. Ame'ẽ ke petur ixo — aja Petu ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesu pandu u'am rahã, Jun uhyk uwyr ehe. Awa py mokõi jumu'eha ta ngi har peteĩ a'e. Jun namõ heta amõ ta ixo. Tamarã a'eta pyhyk werur. Kyse puku pyhyk werur tĩ. Jesu koty heta a'eta ke pa'ihu ta mondo. Ixoty heta a'eta ke jundéu awa tamũi ta mondo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ame'ẽ ta pe Jun pandu ramõ: —Kuja Jesu ke pekwa ta. Huwa ke ihẽ apyter. Ame'ẽ riki Jesu. Pahar pepyhyk a'e ke — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jun uhyk rahã, pahar Jesu rehe uhyk oho. Pandu ipe: —Sawa'e! Ngã mu'eha nde. Ko nde ere'am — aja. (Pe, huwa ke a'e pyter.) ");
INSERT INTO urbNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesu pandu: —Mã! Sa'e! Ame'ẽ rehe pejur — aja Jun pe. Pe, ngã uwyr. Jesu jywa ke hãtã a'eta pyhyk. ");
INSERT INTO urbNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jesu namõ ixo ame'ẽ ta ngi har amõ riki kyse puku ke muhem. Pe, ame'ẽ pe amõ nambi ke mopok ingi. Jundéu awa tama'e pa'i keruhũma'e miasu nambi ke mopok ingi. ");
INSERT INTO urbNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pe, Jesu pandu ipe: —Anĩ. Hyru pe nema'e kyse puku emujywyr. Kyse puku namõ jumai ame'ẽ ke kyse puku pe amõ jukwa ta. ");
INSERT INTO urbNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ihẽ pái pe apandu rahã, pahar ihẽ pe Tupã je'ẽha rahoha ta ke muwyr ta. Ame'ẽ ke nde erekwa riki. Heta te hũ a'e muwyr ta. Kuja, 12.000 hetaha ta. Ame'ẽ ta ihẽ namõ jumai ta. Anĩ. Ame'ẽ ke aputar ym. (A'erehe apandu ym ta.) ");
INSERT INTO urbNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tupã je'ẽha rahoha ihẽ pe a'e muwyr ta tipe rahã, Tupã je'ẽha rehe panduha ihĩ, aja uhyk ym ta. Ihẽ apyrara ta, aja uhyk ym ta. A'erehe: “Tupã je'ẽha rahoha ta ke emuwyr” aja apandu ym ta ihẽ pái pe — aja jumu'eha pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ngã pe Jesu pandu: —Ma'e mukanĩha aja ihẽ ke pepyhyk pejur tĩ. A'erehe kyse puku namõ pejur. Tamarã namõ. Wera rahã pame katu te Tupã rehe ngã jumu'eha renda keruhũ pe ihẽ amu'e axo. Arahã ihẽ ke pepyhyk ym. ");
INSERT INTO urbNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Apo ihẽ ke pepyhyk. Katu 'y. Aja rahã yman Tupã je'ẽha pandu ame'ẽ ta mupinim, aja upa uhyk apo 'y — aja Jesu pandu. Pe, Jesu ke upa katu te jumu'eha ta hijar oho. Ujan oho ingi. ");
INSERT INTO urbNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesu ke amõ ta pyhyk. Ame'ẽ ta jundéu awa tama'e pa'i keruhũ rok pe pyhyk raho. Jundéu awa tama'e pa'i keruhũ rer Kái. Moise je'ẽha ke mu'e ame'ẽ ta jy'ar a'ep. Jundéu awa tamũi ta aja tĩ. Jy'ar a'ep tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petete Jesu raikwer rupi Petu tur ixo. Jundéu awa tama'e pa'i keruhũ rok soroka pe jõ uhyk oho. A'ep harõha ta namõ a'e wapyk. Ma'e Jesu namõ amõ ta ma'e ta my, ame'ẽ ke Petu ukwa tar katu uĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jesu katu ym, aja pandu te'e ame'ẽ ta ke pa'ihu ta kekar. A'ep jy'ar ame'ẽ ta aja tĩ. Pandu te'e ame'ẽ ta mahem rahã, ame'ẽ panduha rupi Jesu ke a'eta jukwa ta. ");
INSERT INTO urbNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pe, a'eta kekar tipe. Heta te'e pandu ehe har tipe. Pe, mokõi sawa'e ta pandu uwyr. ");
INSERT INTO urbNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Kuja a'eta pandu: —Peme'ẽ sawa'e kuja pandu: “Tupã rehe ngã jumu'eha renda keruhũ ke ihẽ upa amai ta. Pe, mokõi aker rahã, amõ pyahu ame'ẽ ke ihẽ amujã ta” aja peme'ẽ sawa'e pandu — aja mokõi sawa'e ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pa'i keruhũ pu'am. Pandu Jesu pe: —Mokõi sawa'e ta pandu. Myja me'ẽ nde erepandu ta apo my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesu pandu ym. Amõ we pa'i keruhũ pandu ipe: —Tupã je'ẽha rupi ihẽ apandu nde pe. Uhã te hũ ame'ẽ ke a'e. Jetehar te nde erepandu ym rahã, mã peja nde ke Tupã mupyrara. Apo jande pe epandu katu. Kirisutu ke nde my? Kapitã keruhũ aja Tupã mu'am ame'ẽ ke nde my? Tupã ra'yr nde my? — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesu pandu ipe: —A'e tỹ. Apandu pehẽ pe. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Apo har kupe koty Tupã rake ihẽ awapyk ta aho kỹ. Ame'ẽ ke pekwa ta. Ywa takãxĩha 'ar pe ihẽ ajywyr ta ajur tĩ. Ame'ẽ rehe pesak ta tĩ — aja pandu. (“Tupã rake” aja Jesu pandu rahã: “Tupã a'e tĩ” aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jesu pandu ame'ẽ ke rehe pa'i keruhũ hendu rahã, ima'e mundeha ke pa'i keruhũ musak. (Aja rahã, Tupã parahy tĩ, aja mujekwa naĩ.) Pe, pandu: —Mã! Pehendu my! Peme'ẽ riki Tupã aja jupe. Katu ym aja. Peme'ẽ rehe har amõ pandu ame'ẽ ke jakekar ym ta apo 'y. ");
INSERT INTO urbNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Myja pekwa my? — aja. Amõ ta pandu: —Katu ym riki a'e. Manõ ta me'ẽ te'e — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Pe, Jesu ruwa rehe a'eta tymũ. Nupã tĩ. (Eha ke pan pe jupyk.) Pe, ipo pe huwa ke nupã. Ame'ẽ ta pandu: ");
INSERT INTO urbNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—Kirisutu! Awa nde ke nupã my? Epandu jande pe! — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Soroka pe Petu wapyk uĩ rahã, jundéu awa tama'e pa'i keruhũma'e parakyha uhyk uwyr ehe. Kũjã ke. Kuja pandu ipe: —Jesu namõ nde erexo ame'ẽ ke nde. Jesu ngariréi ywy pe har namõ — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pe, Petu te'e pandu: —Anĩ. Ihẽ akwa ym ehe har. Nde erepandu ame'ẽ ke akwa ym ihẽ — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pe, soroka pe a'e oho, hukwen rake. Amõ kũjã parakyha usak ehe. Pe, a'ep i'ãi ame'ẽ sawa'e ta pe a'e pandu: —Jesu Nasare ok ta pe har ke a'e. Inamõ ixo ame'ẽ kohĩ — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Amõ we Petu te'e pandu tĩ: —Anĩ. Ihẽ akwa ym ehe har. Jetehar te ihẽ apandu. Akwa ym ehe har. Jetehar te apandu ym rahã, mã peja ihẽ ke Tupã mupyrara katu — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","A'ep sawa'e ta pu'am u'am. I'i atu rahã, ame'ẽ ta uhyk uwyr ehe, Petu rehe. Pandu ipe: —A'e riki. Peme'ẽ ta ngi har nde tĩ. Nde je'ẽha riki ngariréi ywy pe har je'ẽha aja jahendu. A'erehe a'eta ngi har nde tĩ, aja jakwa — aja pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petu te'e pandu tĩ: —Jetehar te ihẽ apandu. Jesu rehe har ihẽ akwa ym. Jetehar te ihẽ apandu ym rahã, mã peja ihẽ ke Tupã mupyrara — aja. Upa Petu pandu rahã, sapukái je'ẽ. ");
INSERT INTO urbNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pe, Jesu pandu ame'ẽ ke Petu ukwa ukwa u'am. Kuja: “Sapukái je'ẽ ym rahã we, mahapyr kuja nde erepandu ta: ‘Akwa ym ehe har’ aja ihẽ rehe har nde erepandu ta.” Ame'ẽ panduha ke Petu ukwa ukwa u'am apo. A'erehe a'engi a'e uhem oho. Jixi'u hũ. Huxĩ, a'erehe jixi'u hũ. ");
INSERT INTO urbNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pytuniwe te rahã, upa jundéu awa tama'e pa'ihu ta pandu pandu a'eta jupe. Jundéu awa tamũi ta namõ pandu pandu a'eta jupe. Kuja: “Jesu ke jajukwa ta” aja. ");
INSERT INTO urbNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pe, Jesu ke pukwar. Tupaham pe a'eta pukwar. Pe, kapitã pe raho. Her Pirat. (Homa awa tama'e kapitã a'e.) ");
INSERT INTO urbNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jun riki ngã ke Jesu rehe muhyk raho. Jesu ke pa'ihu ta jukwa ta, aja Jun ukwa rahã, ipy'a ke a'e muruwak. Pe, pa'ihu ta koty a'e oho. Tamũi ta koty oho tĩ. Tamatarer ke a'e mujywyr raho. Kuja, 30 itatuwyr tamatarer ke a'e raho. ");
INSERT INTO urbNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","A'e pandu: —Katu ym ihẽ. Ma'e ka'u te'eha ke a'e ma'e ym te, ame'ẽ ke pehẽ pe ihẽ arur, Jesu ke. Ame'ẽ ke pejukwa ta. Katu ym aja — aja pa'ihu ta pe pandu. A'eta pandu: —Jande jakwa ym ame'ẽ. Nde atu erekwa — aja Jun pe. ");
INSERT INTO urbNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Pe, tamatarer ke Jun ombor. Tupã rehe ngã jumu'eha renda keruhũ pe ombor. Pe, a'engi uhem oho. Oho riki. Pe, jurupy rupi tupaham jeje jupukwar. Aja tupaham rehe jixiko manõ. ");
INSERT INTO urbNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ita tamatarer ke pa'ihu ta pyhyk. Pe, pandu pandu a'eta jupe: —Kome'ẽ tamatarer riki amõ ke jukwaha muhepyha ke. A'erehe jumu'eha renda keruhũma'e tamatarer renda pe jamoĩ rahã, katu ym. Aja jundéu awa je'ẽha rehe panduha ihĩ — aja pa'ihu ta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pe, a'eta pandu pandu a'eta jupe rahã, kuja a'eta ukwa. Ame'ẽ tamatarer pe ywy ke pa'ihu ta jo'ok. Ame'ẽ ywy riki tujuk pander mujãhama'e ke. Pe, amõ awa ta manõ rahã, a'ep amõ ta jytym ta. Kangwerupa renda aja riki. (Jundéu awa aja ym ame'ẽ ta jõ a'ep jytym ta.) ");
INSERT INTO urbNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","A'erehe ame'ẽ ywy rehe har ngã pandu: “Huwy namõ muhepy, ame'ẽ ywy ke” aja. Aja apo ixo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Aja yman Jeremi mupinim ame'ẽ ke rehe uhyk apo 'y. Kuja a'e mupinim: “Ita tamatarer ke a'eta pyhyk. Kuja, 30 itatuwyr tamatarer ke pyhyk. Ame'ẽ riki muhepyha ke. A'eta pandu: ‘A'e koty jande ke nde eremuhyk ereraho rahã, kuja, 30 itatuwyr tamatarer ke jame'ẽ ta nde pe’ aja. ");
INSERT INTO urbNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ame'ẽ tamatarer pe ywy ke jo'ok. Ywy pander mujãhama'e ke jo'ok ingi. Aja jandema'e sawa'e te pandu ihẽ pe” aja Jeremi mupinim. ");
INSERT INTO urbNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Homa awa tama'e kapitã ruwa koty Jesu pu'am. Jesu pe a'e pandu: —Jundéu awa tama'e kapitã keruhũ nde my? — aja. Jesu pandu: —A'e tỹ — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jundéu awa tama'e pa'ihu ta je'ẽ je'ẽ hũ. Jundéu awa tamũi ta aja tĩ. Ame'ẽ ta rehe je'ẽha ke Jesu mujywyr ym te. ");
INSERT INTO urbNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pirat pandu ipe tĩ: —Mãte nde rehe har ame'ẽ ta je'ẽ je'ẽ hũ. Upa nde erehendu. Nde erepandu ym ta my? — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesu pandu ym te. A'erehe kapitã jupandu jupe: “Mã! Ma'erehe pandu ym my?” aja jupe. ");
INSERT INTO urbNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pasuko 'ar rahã, ngã mi'u ngã matyr. Arahã pame katu te kyndaha ngi sawa'e ke Pirat muhem ta. ");
INSERT INTO urbNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Arahã kyndaha pe amõ ihĩ. Upa ngã ukwa katu ehe har. Her Jesu Mahamba. ");
INSERT INTO urbNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pe, ngã jy'ar rahã, Pirat pandu: —Awa ke pehẽ pe ihẽ amuhem ta amondo my? Jesu Mahamba, ame'ẽ katu pehẽ pe my? Anĩ rahã, Jesu Kirisutu amuhem ta my? — aja ngã pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","A'eta jyty'ym Jesu rehe. A'erehe Jesu ke raho ipe. Aja Pirat ukwa katu. ");
INSERT INTO urbNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ngã panduha renda pe Pirat wapyk uĩ rahã, myrandu ke hakehar muwyr ipe. Kuja riki: —Peme'ẽ sawa'e ke ma'e katu ym ame'ẽ ke ma'e ym te. Jukwaha epandu ym. Pytun rahã, ihẽ kerai ehe. A'erehe a'e ke nde erejukwa rahã, pyraraha uhyk ta jande rehe aja ihẽ akwaha. A'erehe ihẽ aker ym te ihẽ — aja panduha ke Pirat rakehar muwyr. ");
INSERT INTO urbNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ngã pe pa'ihu ta pandu pandu. (Kuja Pirat pe pepandu:) —Mahamba ke emuhem emondo jande pe. Jesu ke ejukwa — aja jundéu awa tamũi ta ngã pe pandu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pe, kapitã pandu ngã pe: —Mokõi sawa'e ta kohĩ. Awa ke ihẽ te'e amuhem ta amondo my? Myja peputar my? — aja. A'eta pandu: —Mahamba ke jande japutar — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pirat pandu: —Ko Jesu Kirisutu. Myja ihẽ ama'e ta my? — aja. A'eta pandu: —Myra ngã mupi'a ame'ẽ ke rehe ejukwa — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pirat pandu: —Ma'ewã my? Ma'e ka'u te'eha ke a'e ma'e te ym riki — aja. Pe, hãtã ngã pandu: —Myra ngã mupia ame'ẽ ke rehe ejukwa — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pirat pandu pandu tipe. Pe, ngã mutyapu tyapu tate, aja a'e ukwa rahã, Pirat pandu: “Y ihẽ pe erur” aja sonda pe. Werur rahã, ame'ẽ pe ipo ke a'e kutuk. Ame'ẽ ke rehe ngã usak. Pe, Pirat pandu: —Ko ihẽ po ihẽ akutuk. Aja rahã kome'ẽ sawa'e ke ihẽ ajukwa tar ym, aja ihẽ amujekwa pehẽ pe. Pehẽ riki kome'ẽ sawa'e ke pejukwa tar katu — aja Pirat. ");
INSERT INTO urbNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ngã pandu ipe: —A'e ke jajukwa rahã, mã peja jande rehe pyraraha uhyk. Jande ra'yr ta rehe uhyk tĩ — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pe, Mahamba ke a'eta pe Pirat te'e muhem mondo. Amõ sonda ta pe a'e pandu: —Jesu ke epirok — aja. (Pirok rahã, jukwa ta ame'ẽ ke a'e, aja mujekwa katu.) Aja mahy hũ. Upa rahã, sonda ta pe Jesu ke Pirat me'ẽ. Myra ngã mupia ame'ẽ ke rehe Jesu ke a'eta jukwa ta raho. ");
INSERT INTO urbNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pe, homa awa tama'e kapitã rok keruhũ pe Jesu ke Piratma'e sonda ta raho. Heta ngã jy'ar jy'ar uwyr a'ep. ");
INSERT INTO urbNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Upa katu te Jesuma'e mundeha ke a'eta jo'ok ingi. Pe, pytangwer ame'ẽ ke moĩ ehe. (Kapitã keruhũma'e aja saka. Aja puka puka hũ ehe. “Ko kapitã keruhũ” aja riki puka puka hũ ehe.) ");
INSERT INTO urbNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Japekã rãkã ke te'e iãkã rehe har a'eta mujã. Ame'ẽ ke iãkã rehe a'eta moĩ. (Aja mahy.) Myra ke ipo pe moĩ tĩ. (Kapitã keruhũma'e aja saka.) Pe, huwa koty ipynarãi pe a'eta wapyk. “Ko kapitã keruhũ” aja puka puka hũ ehe. Katu katu ipe. Kuja pandu ipe tĩ: —Sa'e! Jundéu awa tama'e kapitã keruhũ nde! — aja riki puka puka hũ ehe. ");
INSERT INTO urbNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","A'eta tymũ ehe tĩ. (Aja jaxer ai ame'ẽ ke a'e, aja a'eta ukwaha naĩ.) Pe, myra ra'yr pe iãkã ke nupã nupã. Japekã rãkã rehe nupã. (Aja mahy.) ");
INSERT INTO urbNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Upa a'eta puka puka rahã, mundeha ke a'eta jo'ok ingi, pytangwer ame'ẽ ke. Pe, Jesuma'e mundeha ke a'eta mujywyr ipe tĩ. Pe, soroka pe raho. Myra ngã mupia ame'ẽ ke rehe jukwa ta raho. ");
INSERT INTO urbNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ok ta ngi a'eta uhem oho ixo rahã, amõ sawa'e rehe a'eta usak. Her Simã. Syre ok ta pe har ke a'e. Sonda ta pandu ipe: —Kome'ẽ myra ngã mupia ame'ẽ ke ehupir eraho. Jesuma'e ke — aja Simã pe. (Jesu ke ngã mahy hũ, a'erehe arahã Jesu pyrãtã ym. A'erehe Simã raho.) ");
INSERT INTO urbNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pe, Ngóu renda pe a'eta uhyk oho. Ame'ẽ renda rehe awa usak rahã, awa ãkã kangwer 'ã ke aja saka. ");
INSERT INTO urbNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","A'ep kawĩ namõ puhã mupara. Iro riki ame'ẽ. (Ahyha muputu'u ame'ẽ ke.) Ame'ẽ ke Jesu pe sonda ta me'ẽ ta tipe. Jesu manga rahã, u'u ym. Putar ym. ");
INSERT INTO urbNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Myra ngã mupia ame'ẽ ke rehe Jesu ke a'eta jukwa. Pe, ima'e mundeha ke a'eta pyhyk pyhyk raho. Ita pinim ra'yr ke a'eta ombor. Amõ ombor, pe, pinĩha i'ar koty te we u'ar rahã, a'e riki mundeha ke pyhyk. Aja Jesuma'e mundeha ke sonda ta pyhyk pyhyk. ");
INSERT INTO urbNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pe, upa rahã, a'ep a'eta wapyk. Jesu manõha ke rehe a'eta harõ uĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jesu ãkã 'ar koty ngã ukwaha ke amõ mupinim. Ma'erehe jukwa my? Ame'ẽ ukwaha ke moĩ. Kuja: “Jundéu awa tama'e kapitã keruhũ riki kome'ẽ” aja mupinim. ");
INSERT INTO urbNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","A'ep mokõi ma'e mukanĩha ta ke a'eta jukwa tĩ. Jesu jywa katu koty peteĩ. Ijywa'i koty amõ ke jukwa tĩ. Myra ngã mupia ame'ẽ ke rehe jukwa tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","A'ep wata oho ame'ẽ ta puka puka hũ ehe. Iãkã ke a'eta mukatak katak ipe. (Aja puka hũ ehe.) Katu katu ipe. Pandu ipe tĩ: ");
INSERT INTO urbNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Mã! Nde erepandu: “Tupã rehe ngã jumu'eha renda keruhũ upa ihẽ amai ta. Pe, mokõi aker rahã, amõ amujã ta” aja nde erepandu. Nde riki Tupã ra'yr rahã, myra ngã mupia ame'ẽ ngi ewyjy ejur. Aja rahã, nde eremanõ ym ta — aja puka puka hũ ehe. Katu katu ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Aja jundéu awa tama'e pa'ihu ta puka puka hũ ehe tĩ. Moise je'ẽha ke mu'e ame'ẽ ta aja tĩ. Jundéu awa tamũi ta aja tĩ. Puka puka hũ ehe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","A'eta pandu pandu: —Amõ ta ke a'e mukatu. A'erehe manõ ym. Mukatu riki. Mã! Jumumanõ ym juehe. A'e riki jundéu awa tama'e kapitã keruhũ. Apo myra ngã mupia ame'ẽ ngi wyjy uwyr rahã, jande jajurujar katu ta ehe. ");
INSERT INTO urbNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tupã rehe a'e jurujar katu. A'e pandu: “Tupã ra'yr ihẽ” aja. Apo jasak ta. A'e ke Tupã mujy ta muwyr my? Jasak ta — aja puka puka hũ. Katu katu ipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aja ma'e mukanĩha ta puka puka hũ ehe tĩ. Myra ngã mupia ame'ẽ ke rehe i'ãi ame'ẽ ta ke a'eta. Katu katu ipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Warahy jandar rahã, ame'ẽ ywy pe pytun oho. Warahy uwe riki. Aja te'e warahy ywa ku'ap oho. ");
INSERT INTO urbNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Warahy ywa ku'a ihon rahã, hãtã Jesu pandu: —Eroi! Eroi! Rema samatani? — aja. Ame'ẽ jundéu awa je'ẽha kuja riki: —Tupã! Tupã! Ma'erehe ihẽ ke nde erehijar my? — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ame'ẽ je'ẽha rehe a'ep ixo ame'ẽ ta hendu rahã, amõ koty ukwaha. A'erehe pandu: —Ymanihar Eri pe a'e pukái — aja a'eta ukwaha naĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","A'eta ngi har peteĩ sawa'e ujan oho. Mandeju aja me'ẽ pe ma'e rykwer mupyta, kawĩ iro ym te ame'ẽ ke. Wina aja me'ẽ rykwer ke. Ame'ẽ ke u'ywa aja me'ẽ rehe pukwar. Pe, me'ẽ ta tipe ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pe, amõ ta pandu: —Anĩ we rĩ. Eharõ we! Jasarahã! Myra ngã mupia ame'ẽ ngi Eri jo'ok ta uwyr my. Jasak ta — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pe, Jesu ahem hũ. Pe, manõ. ");
INSERT INTO urbNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tupã rehe ngã jumu'eha renda keruhũ pe kyndaha ihĩ. Pan janam te hũ ke. Ame'ẽ hukwen pehĩ. Ame'ẽ riki ywate ngi owok riki. Iwyr rehe owokiha upa uhyk oho. (Aja rahã, Tupã koty ohoha apo katu aja mujekwa.) Ywy ke katak hũ tĩ. Ita keruhũ owok hũ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kangwerupa opok tĩ. Yman manõ, ame'ẽ ta ngi har amõ amõ Tupã kotyhar ta ke Tupã mukwera katu muhem. ");
INSERT INTO urbNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kangwerupa ngi uhem oho. Jesu riki kwera katu uhem rahã, Jerusarẽ ok ta keruhũ pe a'eta ixe oho tĩ. A'ep a'eta rehe heta ngã usak. ");
INSERT INTO urbNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jesu manõ ame'ẽ ke rehe sonda tama'e kapitã usak u'am. Sonda ta aja tĩ. Usak u'am tĩ. Pe, ywy katakiha ke rehe a'eta usak. Warahy uwe ame'ẽ ke rehe usak tĩ. Arahã a'eta pandu: —Jetehar te ke. Tupã ra'yr te riki peme'ẽ sawa'e — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Paite we kũjã ta usak u'am. A'eta riki Ngariréi ywy ngi Jesu namõ uwyr. Inamõ ma'e ke a'eta ma'ema'e. ");
INSERT INTO urbNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ame'ẽ kũjã ta namõ Mari Mandare usak u'am. Amõ Mari usak u'am tĩ. Tian mãi ke ame'ẽ. Jose mãi tĩ. Semende ra'yr ta mãi usak u'am tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pytun tate rahã, amõ sawa'e uhyk uwyr. Her Jose. Arimatéi ok ta pe har ke a'e. Jesu namõ jumu'e ixo ame'ẽ ke a'e tĩ. Ima'ehũ namõ ixo ame'ẽ ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pirat koty a'e oho. Pe, pandu: —Jesu rete ke ihẽ aputar. Amou ta araho — aja. Pirat pandu amõ pe: —Jesu rete ke eme'ẽ ipe — aja. ");
INSERT INTO urbNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Pe, Jesu rete ke a'e mujy muwyr. Pan tuwyr pyahu ame'ẽ pe hete ke pukek. ");
INSERT INTO urbNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ima'e itakwar keruhũ pe hete ke Jose mou. Pykũi ramõ ame'ẽ ke ame'ẽ. Pe, itahu pe hukwen ke Jose kynda. Pe, a'engi oho. ");
INSERT INTO urbNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Itakwar keruhũ rukwen koty Mari Mandare wapyk uĩ. Amõ Mari inamõ wapyk uĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ku'ẽ rahã, jundéu awa tama'e putu'uha 'ar ke. Pirat namõ parise ta jy'ar oho. Pa'ihu ta aja tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","A'eta pandu: —Kapitam! Ame'ẽ te'e pandu ame'ẽ ke se ixo rahã, kuja pandu: “Mokõi aker rahã, ihẽ ke Tupã mukwera katu ta muhem” aja. Ame'ẽ riki te'e aja jakwa ja'am apo. ");
INSERT INTO urbNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","A'erehe kuja sonda ta pe epandu: “Itakwar keruhũ rehe peharõ katu pexo. Mokõi peker rahã, peharõ pexo. Pesak katu ehe kỹ.” aja epandu a'eta pe. Aja rahã, Jesu rete ke jumu'eha ta mukanim ym ta raho. Mukanim rahã, ngã pe a'eta te'e pandu ta: “A'e manõha ngi kwera katu uhem” aja te'e pandu ta. Ame'ẽ riki: “Mokõi aker rahã, ihẽ ke Tupã mukwera katu ta muhem” ame'ẽ 'ar koty te we katu ym te ha — aja parise ta pandu ipe. ");
INSERT INTO urbNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pirat pandu: —Pehẽ atu sonda ta ke peraho. Pepandu katu: “Itakwar keruhũ rehe peharõ katu te pexo. Pesak katu kỹ” aja sonda ta pe pepandu — aja parise ta pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","A'eta oho ingi. Pe, itakwar kyndaha ke yraity aja me'ẽ pe kynda. Ita keruhũ riki kyndaha ke. Yraity aja me'ẽ pe mujar. (Amõ pirar rahã, ame'ẽ ke ukwa ta.) Pe, sonda ta pe a'eta pandu: “Se peharõ katu pe'am. Aja rahã, ixe ym ta awa” aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jundéu awa tama'e putu'uha 'ar upa. Nomin pytuniwe te rahã itakwar keruhũ rehe Mari Mandare usak oho. Amõ Mari namõ usak oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pahar ywy ke katak hũ. Ywa ngi Tupã je'ẽha rahoha wyjy uwyr. Itahu hukwen ke a'e mujere mondo. Ame'ẽ 'ar pe a'e wapyk uĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Hendy riki ima'e mundeha. Tupã weraha aja hendyha. Mandeju aja ituwyr te hũ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sonda harõha ta a'ep ixo rĩ. A'eta ryrýi. Kyje riki, a'erehe ryrýi. A'eta manõ ame'ẽja ywy rehe u'ar oup. ");
INSERT INTO urbNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pe, kũjã ta pe Tupã je'ẽha rahoha pandu: —Pekyje ym. Jesu ke pekekar, aja ihẽ akwa. Myra ngã mupia ame'ẽ ke rehe a'e ke amõ ta jukwa. ");
INSERT INTO urbNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","A'e ke Tupã mukwera katu muhem. A'e pandu aja uhyk apo 'y. Pejur! Mouha renda rehe pesak pejur. Se a'e nixói te 'y. ");
INSERT INTO urbNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pahar jumu'eha ta pe pepandu peho apo. Kuja: “A'e ke Tupã mukwera katu muhem. Ngariréi ywy pe pehẽ ndutar koty a'e oho ta. A'ep pehẽ johu pesak ta ehe.” Ihẽ apandu ame'ẽ ke peharái ym — aja Tupã je'ẽha rahoha pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Pe, pahar itakwar keruhũ ngi a'eta oho. Kyje riki. Pe, hury katu tĩ. Jumu'eha ta pe pandu oho. Ujan riki oho. ");
INSERT INTO urbNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Oho ixo rahã, pahar a'eta rehe Jesu uhyk. Pandu: —Ko ihẽ ajur — aja. Ixoty a'eta uwyr. Ipy ke a'eta pyhyk. Ipy'a ke a'eta moĩ moĩ katu ehe, Jesu rehe. ");
INSERT INTO urbNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","A'eta pe Jesu pandu: —Pekyje ym. Ihẽ mu ta pe kuja pepandu peho: “Ngariréi ywy pe peho. A'ep ihẽ rehe a'eta usak ta tĩ” aja pepandu — aja kũjã ta pe pandu. (“Ihẽ mu ta” aja pandu rahã: “Upa katu te jurujar katu ehe ame'ẽ ta ke” aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Itakwar keruhũ ngi kũjã ta oho ixo rahã, sonda ta ngi har amõ ta uhyk oho tĩ. Jerusarẽ ok ta keruhũ pe harõha ta uhyk oho tĩ. Pe, jundéu awa tama'e pa'ihu ta pe upa katu te pandu. Ywy katak hũ. Itahu rukwen kyndaha amõ mujere mondo. Ame'ẽ ke upa katu te pandu. ");
INSERT INTO urbNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tamũi ta namõ pa'ihu ta jy'ar. Pandu pandu a'eta jupe. Pe, kuja a'eta ukwa. Sonda ta pe tamatarer ke a'eta me'ẽ me'ẽ hũ. ");
INSERT INTO urbNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Pandu: —Kuja pepandu ngã pe. “Pytun rahã, jande jaker rahã, Jesu rete ke jumu'eha ta mukanim raho” aja pepandu. ");
INSERT INTO urbNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ame'ẽ ke homa awa tama'e kapitã hendu rahã, japandu ta ipe: “Sonda ta anĩ. Ame'ẽ ta ke emupirok ym” aja. A'erehe pekyje ym ingi. Pehẽ ke a'e mupyrara ym ta — aja sonda ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Parise ta ngi tamatarer ke sonda ta pyhyk. Te'e pandu ame'ẽ muhepyha ke. Pe, parise ta panduha aja sonda ta pandu pandu oho tĩ. A'erehe sonda ta pandu, aja jundéu awa ta pandu pandu naĩ apo rĩ. “Jesu rete ke jumu'eha ta mukanim raho” aja pandu pandu naĩ apo rĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesu mujekwa ame'ẽ ywy'ã pe awa py peteĩ jumu'eha ta oho. Ngariréi ywy pe ame'ẽ ywy'ã ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesu rehe usak rahã, a'eta py'a ke a'eta moĩ moĩ katu ehe. Ame'ẽ ta ngi har amõ amõ kuja: “Kome'ẽ Jesu my? Kwera katu uhem ame'ẽ ke my?” aja amõ ta ukwa ukwa u'am. ");
INSERT INTO urbNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","A'eta koty Jesu oho. Pe, pandu a'eta pe: —Ihẽ pe Tupã pandu: “Ywa pe upa katu te nde erema'e tar katu. Ame'ẽ ke ema'e katu. Peme'ẽ ywy keruhũ pe aja tĩ. Ema'e katu tĩ” aja ihẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","A'erehe pehẽ pe ihẽ apandu: “Upa kome'ẽ ywy keruhũ pe har ta pe pepandu peho. Ihẽ rehe har pepandu pandu peho. Aja a'eta ke ihẽ kotyhar ta aja pemuruwak ta. Ame'ẽ ta ke pemujahuk. (Aja rahã, ihẽ kotyhar ta ke, aja pemujekwa ta ngã pe.) Jande pái keruhũ je'ẽha rupi pemujahuk. Ta'yr je'ẽha rupi pemujahuk tĩ. Tupã'ã je'ẽha rupi pemujahuk tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Upa pehẽ pe ihẽ amu'e ame'ẽ ke amõ ta pe pemu'e katu tĩ. Aja rahã, ame'ẽ ta hendu katu ta tĩ. Ihẽ je'ẽha rehe hendu katu ta tĩ. Wera rahã pame katu te pehẽ namõ ihẽ axo ta kỹ. 'Ar rehe angaha uhyk ym rahã we, aja te'eha pehẽ namõ ihẽ axo ta kỹ” — aja jumu'eha ta pe Jesu pandu. Upa.");
INSERT INTO urbNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Myrandu katu ke Mak mupinim werur. Jesu Kirisutu rehe har a'e mupinim. Tupã ra'yr a'e. ");
INSERT INTO urbNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kuja riki a'e uwyriha. Yman paper rehe Isai mupinim. Tupã je'ẽha ke a'e mupinim tĩ. (Kuja, Ta'yr pe Tupã pandu:) “Ihẽ je'ẽha pandu ame'ẽ ke amondo py ta kỹ. Kuja ngã pe pandu py ta oho: ‘Jandema'e sawa'e te uwyr tate, a'erehe pe ke pemukatu. (Aja rahã, ma'e peka'u te'eha ke pehijar. Aja pexo katu 'y)’ aja ihẽ je'ẽha pandu ame'ẽ ke pandu ta. Ame'ẽ raikwer rupi nde ereho ta” aja Ta'yr pe Tupã pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kuja awa nixói te ame'ẽ pe amõ pandu u'am: “Kapitã keruhũ uhyk tate rahã, ma'e ke upa mukatu. Aja jandema'e sawa'e te uhyk tate. A'erehe pexoha ke pemukatu. A'erehe ma'e peka'u te'eha ke pehijar” aja pandu u'am. Aja riki Isai mupinim. (Yman aja a'e mupinim rahã, Juã rehe har mupinim.) ");
INSERT INTO urbNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Pe, awa nixói te ame'ẽ pe Juã mujahukiha uhyk uwyr. (A'ep heta ngã uhyk uwyr ehe.) Ame'ẽ ta pe pandu: —Ma'e peka'u te'eha pema'ema'eha ke pehijar. Katu ame'ẽ ke pema'ema'e katu 'y. Aja rahã, pehẽ rehe ipy'a ke Tupã mujywyr ta. Pe, pehẽ ke ihẽ amujahuk ta — aja Juã pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Juã koty heta ngã uhyk uwyr. Jundéi ywy ngi heta ngã uhyk uwyr ehe. Heta Jerusarẽ ok ta pe har ta uhyk uwyr ehe tĩ. “Ma'e jaka'u te'eha jama'ema'eha ke upa jande jahijar 'y” aja pandu ame'ẽ ta ke Juã mujahuk. Jondã y pe mujahuk. (Aja rahã, Tupã kotyhar ta ke a'eta apo 'y, aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juãma'e mundeha awa rymba ra ke te'e mujã ame'ẽ ke. “Kame” aja ngã rymba rer. Ame'ẽ ra ke ima'e mundeha. (Ymanihar Erima'e mundeha aja ame'ẽ mundeha. Aja rahã, Tupã je'ẽha pandu ame'ẽ ke Juã tĩ, aja mujekwa.) So'o pirer pe ixu'a rupi pukwar. Tukuxixik mixir ame'ẽ ke a'e u'u. Eir namõ u'u tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juã pandu: —Ihẽ raikwer rupi amõ tur. Katu te hũ me'ẽ ke a'e. Ihẽ anĩ. Aja ym ihẽ. A'erehe ima'e miasu aja axo rahã, ihẽ katu ym ihẽ jupe ihẽ. ");
INSERT INTO urbNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Y pe pehẽ ke ihẽ amujahuk. A'e anĩ. Pehẽ ke Tupã'ã namõ mujahuk, ame'ẽja saka — aja ngã pe Juã pandu. (“Tupã'ã namõ mujahuk” aja pandu rahã: “Ngã py'a rehe Tupã'ã ke a'e muwyr ta” aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Arahã Ngariréi ywy ngi Jesu uhyk uwyr ehe, Juã rehe. Nasare ok ta ngi uhyk uwyr ehe. Pe, y pe Jesu ke Juã mujahuk. Y rer Jondã. ");
INSERT INTO urbNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pe, y ngi Jesu uhem rahã, pahar ywa pirar, ame'ẽja saka Juã usak u'am. Pe, Jesu rehe Tupã'ã wyjy uwyr. Pykahuran aja saka wyjy uwyr ehe. ");
INSERT INTO urbNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Pe, ywa ngi panduha uwyr: —Nde riki ihẽ ra'yr. Nde rehe ihẽ apy'a katu. Ihẽ ke nde eremuhury katu — aja Ta'yr pe Tupã pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pahar awa nixói ame'ẽ pe Tupã'ã Jesu ke muhyk raho. ");
INSERT INTO urbNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","A'ep heta ukwer rahã, ixo. Kuja, mokõi awa pypa (40) hetaha wera rahã, a'ep ixo. Arahã, Satana uhyk uwyr ehe. (Ãjã ramũi a'e.) Ma'e ka'u te'eha ke Jesu ma'e, ame'ẽ ke Satana putar tipe. Manga manga tipe. Anĩ. Jesu ma'e ym te. Ame'ẽ renda pe so'o jarõ ame'ẽ ta ixo tĩ. Pe, Jesu rehe Tupã je'ẽha rahoha ta wyjy uwyr. Usak katu uwyr ehe. ");
INSERT INTO urbNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ajame'ẽ ke kyndaha pe Juã ke amõ ta kynda raho rahã, Ngariréi ywy pe Jesu uhyk oho. Myrandu katu ke pandu oho. Tupã rehe har pandu oho. ");
INSERT INTO urbNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kuja pandu: —Angaha ke rehe uhyk oho apo 'y. Ixotyhar ta ke pehẽ, aja Tupã putar. A'erehe ma'e peka'u te'eha pema'ema'eha ke pehijar. Tupã koty pehẽ py'a pemuruwak. Pexoha pyahu ame'ẽ ke Tupã putar, aja pexo katu. Aja rahã, ixotyhar ta ke aja pehẽ ke a'e muruwak ta. Ame'ẽ myrandu katu rehe pejurujar katu — aja Jesu pandu ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ypa rymy'y rupi Jesu wata ixo rahã, pira pyhyk ame'ẽ ta rehe usak. Ypa rer Ngariréi. Mokõi sawa'e ta ixo. Her Simã. Imu rer Andere. Kyhapari pe pira pyhyk ixo. Ypa pe ombor ombor ixo. ");
INSERT INTO urbNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Pe, Jesu pandu: —Ihẽ namõ peho 'y. Pira pepyhyk ame'ẽ ta ke pehẽ. Apo har anĩ. Amõ kotyhar ta. Pehẽ ke amu'e ta. Pe, ngã py'a ke Tupã koty pemuruwak ta 'y. Pejur — aja Jesu Simã ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pahar kyhapari hijar. Pe, Jesu namõ a'eta oho. ");
INSERT INTO urbNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","A'engi Jesu oho we rahã, ame'ẽ ypa pe amõ mokõi sawa'e ta rehe uhyk oho tĩ. Tian ta rehe uhyk oho. Imu rer Juã. Semende ra'yr ta ame'ẽ ta. Jarusu keruhũ pe kyhapari mukatu uĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ame'ẽ ta rehe usak rahã, pandu: —Pejur. Ihẽ namõ peho — aja Jesu Tian ta pe. Pe, Jesu namõ Tian ta oho tĩ. Jarusu keruhũ pe ipái ihĩ. Semende aja her. Parakyha ta namõ ihĩ. Upa ame'ẽ ta ke Tian ta hijar. Pe, Jesu namõ a'eta oho. ");
INSERT INTO urbNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","A'engi Kapana'ũ ok ta pe Jesu uhyk uwyr. Inamõ ixo ame'ẽ ta uhyk uwyr tĩ. Jundéu awa tama'e putu'uha 'ar rahã, jundéu awa tama'e jy'ariha renda pe ixe oho. A'ep ngã ke mu'e uĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Amõ ta Moise je'ẽha mu'e. Aja ym Jesu mu'e. Ukwa katuha namõ mu'e katu. A'erehe hendu ame'ẽ ta pandu: “Mã! Je'ẽha te reko aja pandu katu” aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pe, amõ sawa'e jy'ariha renda pe ixe uwyr. Ipy'a rehe ãjã ihĩ ame'ẽ ke a'e. Pe, hãtã pandu: ");
INSERT INTO urbNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Éi! Jesu! Nasare ok ta pe har ke nde. Ma'ewã jande ke nde eremupyrara erejur my? Nde rehe har ihẽ akwa katu. Tupã koty ngi nde erejur ame'ẽ ke nde. Ima'e je'ẽha ke nde erepandu erejur. Ma'e nde ereka'u te'eha nde erema'eha ke nixói te nde pe, aja akwa katu — aja hãtã pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pe, ãjã pe Jesu pandu: —Eje'ẽ ym! Sawa'e py'a ngi ehem eho — aja ãjã pe. ");
INSERT INTO urbNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pe, ãjã sawa'e ke mukatak katak hũ. Ahem hũ riki. Pe, uhem oho ingi. ");
INSERT INTO urbNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","A'ep ixo ame'ẽ ta mukahem riki. Pandu pandu a'eta jupe: —Mã! Mã katu tiki? Amõ kotyhar ma'e mu'eha ko. Ima'e je'ẽha rupi pandu, pe, ãjã ta hendu katu ehe. Mã! — aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Pe, Jesu rehe har upa Ngariréi ywy rupi ngã pandu pandu oho. Pahar pandu pandu oho. ");
INSERT INTO urbNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ajame'ẽ ke jundéu awa tama'e jy'ariha renda ke Jesu hijar oho. Simã ta oho tĩ. Pe, Simã rok pe ixe oho. Ame'ẽ ke Andere rok tĩ. Tian oho tĩ. Juã amõ oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","A'ep Simã pen haku. A'erehe ixyha pe túi. Jesu uhyk rahã, pahar amõ ta pandu ipe. “Simã pen haku hũ” aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","A'erehe hake Jesu oho. Ipo rehe pyhyk, pe, mupu'am. Pahar hakuha maha oho ipe. Pe, imi'u Jesu ta pe a'e me'ẽ me'ẽ. ");
INSERT INTO urbNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ame'ẽ pytun ramõ rahã, upa warahy u'ar rahã, (jundéu awa ta putu'uha 'ar upa. A'erehe wata katu apo.) A'erehe ma'e ahy ixo ame'ẽ ta ke upa katu te ngã werur ipe. Ipy'a rehe ãjã ihĩ ame'ẽ ta ke ngã werur ipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ok ta pe har ta mãte hũ hukwen rake rupi i'ãi. ");
INSERT INTO urbNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma'e ahy ixo ame'ẽ ta ke mukatu hũ. Ipy'a rehe ãjã ihĩ ame'ẽ ta ke upa mukatu tĩ. Jesu rehe har ãjã ta ukwa katu, a'erehe hãtã Jesu pandu: “Epandu ym ihẽ rehe har” aja ãjã pe. ");
INSERT INTO urbNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ame'ẽ ku'ẽ rahã, sapukái je'ẽ py rahã, Jesu pu'am. Simã rok ngi uhem oho. Pe, paite we awa nixói te ame'ẽ pe oho. A'ep Tupã namõ pandu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pe, Simã upak rahã, Jesu ke kekar oho. Inamõ ixo ame'ẽ ta kekar oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pe, usak ehe rahã, Simã ta pandu ipe: —Upa ngã nde ke kekar ixo tipe — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesu pandu: —Amõ ta renda rupi jaho ta me'ẽ te'e. A'ep pe har ta pe Tupã rehe har apandu ta me'ẽ te'e tĩ. A'erehe ihẽ ajur. Jahorahã! — aja Simã ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","A'erehe upa Ngariréi ywy rupi wata oho. Upa jundéu awa tama'e jy'ariha renda pe pandu pandu oho. Amõ ta py'a ngi ãjã ke muhem mondo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pereran ma'e u'u hũ ame'ẽ ke Jesu rehe uhyk uwyr. Ipynarãi pe wapyk. (Aja sawa'e katu te ame'ẽ ke kohĩ, a'erehe hendu katu ehe aja mujekwa.) Pe, pandu: —Nde ereputar rahã, ihẽ ke nde eremukatu ta aja akwa katu — aja sawa'e. ");
INSERT INTO urbNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Pyrara Jesu usak ehe. Pe, ijywa ke mupuku. Pe, sawa'e ãkã rehe ipo ke a'e mujar. Pandu ipe: —Ere. Nde ke ihẽ amukatu tar katu. Nde katu apo 'y — aja sawa'e pe. ");
INSERT INTO urbNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pahar upa katu ipe 'y. Upa ka'ẽ oho ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Pe, hãtã Jesu pandu ipe: —Ehendurahã! Nde ke ihẽ amukatu, ame'ẽ ke amõ ta pe epandu ym we rĩ. Jundéu awa tama'e pa'i koty eho py. Nde rehe pa'i usak ta. “Katu apo 'y” aja pandu ta. Pe, yman Moise pandu, aja ma'e ke pa'i pe eme'ẽ. Aja rahã, upa nde pirer katu, aja ngã ukwa ta tĩ — aja Jesu pandu tipe ipe. Pe, pahar sawa'e ke muhem mondo. ");
INSERT INTO urbNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pe, sawa'e oho ingi. (Jesu rehe hendu ym.) Mukatuha rehe har pandu pandu oho. Upa katu te ok ta rupi pandu pandu oho. Pyta we ym awa renda ke. A'erehe ok ta pe marã ka ym Jesu ixeha. Upa ngã ukwa katu ehe har. A'erehe amõ koty pyta. Awa nixói te ame'ẽ pe pyta. A'ep upa hekoha ngi ngã uhyk oho ehe. ");
INSERT INTO urbNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ku'ẽ rahã ha pe we Kapana'ũ ok ta pe Jesu jywyr oho. “Hok pe apo ihĩ” aja amõ ta pandu pandu oho. ");
INSERT INTO urbNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","A'erehe heta te hũ ngã jy'ar uwyr ehe. Ok wyr pe soroka nixói te. Hukwen rupi soroka nixói te tĩ. Pe, ngã pe Tupã je'ẽha ke Jesu pandu pandu uĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Arahã tumeme sawa'e ta uhyk uwyr ehe. Ame'ẽ ta upa jupyrãtã rãtã ame'ẽ ke muhyk werur. ");
INSERT INTO urbNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mãte hũ ngã i'ãi. A'erehe marã ka ym Jesu rehe muhykiha. A'erehe ok kupe 'ar pe jupir oho. (Ame'ẽ ok kupe ipe katu.) Pe, jupyka jo'ok jo'ok. Ixwar ihĩ rahã, upa jupyrãtã rãtã ame'ẽ ke ame'ẽ rupi mujy mondo ehe. Kyha aja me'ẽ 'ar pe sawa'e túi. Tupaham rehe mujy mondo. Pe, Jesu rake mou. ");
INSERT INTO urbNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ma'e ahyha Jesu mukatu. Ame'ẽ rehe sawa'e ta jurujar katu. Ame'ẽ ke Jesu ukwa rahã, jupyrãtã rãtã ame'ẽ pe pandu: —Sa'e! Ma'e nde ereka'u te'eha ke nde erema'ema'e. Apo nde rehe ihẽ py'a jywyr katu — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","A'ep Moise je'ẽha mu'e ame'ẽ ta wapyk uĩ tĩ. Jesu pandu ame'ẽ ke rehe hendu rahã, kuja ipy'a pe ukwa ukwa uĩ: ");
INSERT INTO urbNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—Mã! Aja pandu rahã, katu ym. Tupã jõ riki ngã pe pandu katu: “Ma'e nde ereka'u te'eha ke nde erema'ema'e. Nde rehe ihẽ py'a jywyr” aja. A'erehe peme'ẽ riki Tupã aja jupe my? Katu ym aja — aja a'eta py'a pe a'eta ukwa ukwa uĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pe, pahar ame'ẽ ta ukwaha ke Jesu ukwa tĩ. A'erehe pandu: —Mã! Pehẽ py'a pe ma'e ke pekwa pekwa ym peĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Myja me'ẽ riki hãtã ma'eha my? Kuja my: “Ma'e nde ereka'u te'eha ke nde erema'ema'e. Nde rehe ihẽ py'a jywyr katu” aja apandu rahã, hãtã ma'eha my? (Ame'ẽ ke rehe usak ym awa.) Anĩ rahã, kuja my? “Epu'am! Nde kyha aja me'ẽ ke emupu'a! Ewata inamõ eho!” aja apandu rahã, hãtã ma'eha my? (Ame'ẽ ke rehe usak katu awa.) ");
INSERT INTO urbNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","—Pesarahã! (Tupã jõ riki ahyha mukatu aja pekwaha. Tupã jõ riki ngã rehe ipy'a mujywyr katu aja pekwaha tĩ.) Apo ihẽ tĩ. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ riki kapitã keruhũ aja Tupã mu'am ame'ẽ ke ihẽ aja ihẽ amujekwa ta apo. Ihẽ pe Tupã pandu tĩ: “Ma'e ka'u te'eha ke awa ta ma'ema'e. Ame'ẽ ta rehe nde py'a emujywyr katu” aja ihẽ pe. Pesarahã! Ame'ẽ ke pekwa ta apo. Amujesak ta — aja Moise je'ẽha mu'e ame'ẽ ta pe Jesu pandu. Pe, jupyrãtã rãtã ame'ẽ pe pandu: ");
INSERT INTO urbNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Ko apandu nde pe. Epu'am! Nde kyha aja me'ẽ ke emupu'a! Nde rok pe ejywyr eho — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Pe, upa ngã usak usak uĩ rahã, sawa'e pu'am. Kyha aja me'ẽ ke mupu'a. Pe, pahar uhem oho. A'erehe ngã pandu: —Mã! Katu tiki — aja riki. Pe, Tupã pe pandu tĩ: —Ne jõ riki katu te me'ẽ ke. Mã! A'eramõ te aja mukatuha jasak py 'y. Katu! — aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","A'engi Jesu uhem oho. Pe, ypa rymy'y rehe jywyr oho tĩ, Ngariréi ypa rehe. A'ep heta ngã jy'ar oho ehe tĩ. Ame'ẽ ta ke mu'e uĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","A'engi wata oho ixo rahã, amõ sawa'e rehe usak. Her Rewi. (Amõ her: “Matéu” aja.) Apéu ra'yr a'e. Tamatarer matyriha renda pe wapyk uĩ. Homa awa tama'e kapitã keruhũ pe tamatarer matyr matyr. (A'erehe a'e ke jundéu awa ta putar ym ame'ẽ ke a'e.) Jesu pandu ipe: —Ihẽ namõ eho 'y — aja ipe. Rewi pu'am. Upa hijar. Pe, inamõ oho. ");
INSERT INTO urbNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","I'i atu rahã, Rewi rok pe ma'e ke Jesu ta u'u uĩ. Heta tamatarer matyriha ta inamõ uwyr tĩ. Amõ heta ma'e ka'u te'eha ke ma'ema'e ame'ẽ ta aja tĩ. Inamõ uwyr tĩ. Ame'ẽ ta ngi har heta Jesu namõ ma'e ke u'u uĩ. Jumu'eha ta u'u uĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pe, amõ Moise je'ẽha mu'e ame'ẽ ta i'ãi tĩ. Parise kotyhar ta ke ame'ẽ ta. Kuja jumu'eha ta pe ame'ẽ ta je'ẽ je'ẽ: —Ma'ewã ame'ẽ sawa'e ta jaxer ame'ẽ ta namõ Jesu u'u uĩ my? Tamatarer ke matyr ame'ẽ ta namõ aja tĩ. U'u inamõ tĩ. Katu ym aja — aja Moise je'ẽha mu'e ame'ẽ ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ame'ẽ ke rehe Jesu hendu rahã, pandu: —Ma'e ahy ixo rahã, mukatuha koty amõ oho. Ahy ym ixo rahã, mukatuha koty oho ym. (Aja apo. Ma'e ka'u te'eha ke ma'ema'e, ame'ẽ ta ihẽ rehe uhyk. Ipy'a juhyk. Ame'ẽ ke a'eta putar, a'erehe ihẽ rehe uhyk. Mukatuha rehe uhyk, ame'ẽja saka. Katu jupe ame'ẽ ta anĩ. Ame'ẽ ta ihẽ rehe uhyk ym.) Pesarahã! Sawa'e katu aja ukwa jupe, ame'ẽ ta pe kuja ihẽ apandu ym: “Tupã koty pehẽ py'a pemuruwak pemondo” aja. Anĩ. Ma'e ka'u te'eha ke ma'ema'e, ame'ẽ ta pe kuja ihẽ apandu katu: “Tupã koty pehẽ py'a pemuruwak pemondo” aja — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Amõ rahã, Juã mujahukiha namõ jumu'e ixo ame'ẽ ta upa ma'e u'uha ke hijar ixo. Parise ta aja tĩ. Ma'e u'uha ke hijar ixo tĩ. (Aja pyaiha ke mujekwa Tupã pe.) Pe, amõ ta pandu uwyr. Jesu pe pandu: —Juã mujahukiha namõ jumu'e ixo ame'ẽ ta upa ma'e u'uha ke hijar ixo. Parise ta namõ jumu'e ixo ame'ẽ ta aja tĩ. Upa ma'e u'uha ke hijar ixo tĩ. Nde namõ jumu'e ixo ame'ẽ ta anĩ. Upa ma'e u'uha ke hijar ym. Ma'erehe hijar ym my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesu pandu: —Sawa'e jumendar rahã, imi'u matyr. Huryha mujã. Pe, ame'ẽ pe oho ame'ẽ ta ma'e u'uha ke hijar ym. Sawa'e namõ ixo rahã, ma'e u'uha ke hijar ym. ");
INSERT INTO urbNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","(Ihẽ namõ ihẽma'e jumu'eha ta ixo apo, a'erehe upa ma'e u'uha ke a'eta hijar ym.) Yman rahã, ihẽ ke amõ ta pyhyk ta raho a'eta ngi. Arahã ihẽ jumu'eha ta upa ma'e u'uha ke hijar ta. (Aja pyaiha mujekwa ta.) ");
INSERT INTO urbNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","—Amõ we tĩ. Kamixa ymanihar ke sorok rahã, pan jupu'a ym ame'ẽ ke amõ mujar ym ehe. Mujar ehe rahã, jupu'a we oho. Pe, kamixa ymanihar ke musak we ta. Sorok riki tiha we ta oho. ");
INSERT INTO urbNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kawĩ mupupur ramõ ame'ẽ ke hyru ymanihar te pe amõ purakar ym. Ame'ẽ pe purakar rahã, pupur we ixo rĩ. Pe, hyru ymanihar ke mupuk ta. Pe, upa kawĩ jyhẽ ta oho. Hyru ymanihar ke mujaxer ta tĩ. A'erehe kawĩ mupupur ramõ ame'ẽ ke hyru katu ame'ẽ pe amõ purakar rahã, katu ta tiki. Aja rahã, kawĩ jyhẽ ym ta. Hyru ke upuk ym ta tĩ — aja ngã pe Jesu pandu. (Jesu mu'e rahã, myja ixoha katu aja mujekwa. Ixoha pyahu aja saka. A'erehe parise ta mu'e aja ixoha namõ marã ka ym muparaha, aja Jesu mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Amõ jundéu awa tama'e putu'uha 'ar rahã, ahúi aja me'ẽ ty rupi Jesu wata oho ixo. Jumu'eha ta namõ oho ixo rahã, jumu'eha ta amõ amõ po'ok oho. (Ame'ẽ ke ipo pe kamyrik. Aja pirer ke ombor. Upa ombor rahã, ame'ẽ ke u'u.) ");
INSERT INTO urbNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pe, Jesu pe parise ta pandu: —Anĩ. Katu ym kamyrikiha. Jundéu awa tama'e putu'uha 'ar rahã, aja nema'e jumu'eha ta kamyrik rahã, katu ym. (Paraky te'e, ame'ẽja saka. A'erehe katu ym.) Aja Moise je'ẽha rehe panduha ihĩ — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","(Amõ rehe pyrara usak ta me'ẽ te'e, aja Jesu mujekwa tar katu) a'erehe pandu: —Yman Ndawi myahy te riki. Inamõ ixo ame'ẽ ta aja tĩ. Myahy te tĩ. Ame'ẽ ta ma'eha Tupã je'ẽha rehe pesak riki. Ame'ẽ pekwa riki. Ma'e u'u ame'ẽ ke nixói te rahã, Tupã rehe ngã jumu'eha renda keruhũ pe Ndawi ixe. A'ep mbeju ihĩ. Ame'ẽ ke Ndawi u'u. Inamõ ixo ame'ẽ ta pe me'ẽ me'ẽ tĩ. Ame'ẽ ta u'u tĩ. Arahã Amiata pa'i keruhũ. Jundéu awa tama'e pa'i keruhũ. Ame'ẽ mbeju ke Tupã ruwa koty aja saka pa'ihu moĩ. Pa'i ta jõ ame'ẽ ke u'u katu. Amõ ta u'u rahã, anĩ. (Ndawi ta pa'i ym. A'erehe Ndawi ta u'u rahã, katu ym ta tipe. Aja Moise je'ẽha rehe hendu ym) — aja parise ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pandu tĩ: —Putu'uha 'ar ke Tupã mujã py my? Anĩ. Aja ym. Awa ke a'e mujã py. A'engi putu'uha 'ar ke manga. Aja rahã, awa rehe putu'uha 'ar haihu katu, ame'ẽja saka riki. Putu'uha 'ar rehe awa haihu katu, aja ym. ");
INSERT INTO urbNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","A'erehe putu'uha 'ar rahã, ma'e ke amõ ma'e, ame'ẽ ke ihẽ riki apandu katu. Tupã je'ẽha rupi ajur ame'ẽ ke ihẽ. Awa ihẽ tĩ — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Amõ wera rahã, jundéu awa tama'e jy'ariha renda pe Jesu ixe oho tĩ. A'ep ipo ke upa te'e jupu'a ame'ẽ ke ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","A'ep amõ ta ixo. Jundéu awa tama'e putu'uha 'ar rahã, Jesu mukatu ta my? Ame'ẽ ke ukwa tar katu. Mukatu rahã: “Katu ym. Putu'uha 'ar rahã, nde eremukatu. (Nde ereparaky te'e aja nde.) A'erehe katu ym nde erema'eha” aja Jesu pe pandu ta tipe. A'erehe ame'ẽ ta Jesu rehe usak usak uĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pe, ipo ke upa te'e jupu'a ame'ẽ pe Jesu pandu: —Se ejur. Ngã ruwa koty ejur e'am — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pe, ngã pe Jesu pandu: —Myja me'ẽ Moise je'ẽha pandu katu my? Myja me'ẽ putu'uha 'ar rahã, amõ ma'e my? Ko katu ame'ẽ ke amõ pe ma'e my? Anĩ rahã, katu ym ame'ẽ ke ma'e my? Ko amõ rehe pyrara usak my? Anĩ rahã, amõ ke jukwa my? Myja me'ẽ katu pehẽ pe my? — aja ngã pe. Anĩ. Je'ẽ ym ngã. ");
INSERT INTO urbNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ame'ẽ ta rehe Jesu juramã ma'ã. Parahy ngã rehe. Katu ame'ẽ ke ame'ẽ ta ma'e tar ym, a'erehe Jesu parahy ngã rehe. Amõ we tĩ. Pyrara usak ngã rehe a'e tĩ. Jumen saka jurupy hãtã, aja ngã ixo. Hendu tar ym. Jetehar te ke putar ym tĩ. A'erehe pyrara usak ngã rehe a'e tĩ. Pe, sawa'e pe pandu: —Nde po epirar 'y — aja Jesu. Ipo ke sawa'e pirar. Upa puku oho ipe. Imembek katu oho ipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","A'engi parise ta uhem oho. Pahar Ero kotyhar ta namõ jy'ar oho. Ame'ẽ ta namõ pandu pandu. —Myja Jesu ke japyhyk ta my? Pe, jajukwa — aja riki parise ta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","A'engi ypa pe Jesu oho tĩ, Ngariréi ypa pe. Jumu'eha ta oho inamõ tĩ. Haikwer rupi heta te hũ ngã oho tĩ. Ngariréi ywy ngi heta uhyk oho ehe. Jundéi ywy ngi aja tĩ. Heta ngã uhyk oho ehe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusarẽ ok ta ngi aja tĩ. Heta ngã uhyk oho ehe tĩ. Inuméi ywy ngi aja tĩ. Uhyk oho ehe tĩ. Jondã y ruwái pe har ta aja tĩ. Heta ngã uhyk oho ehe tĩ. Tir ok ta rake ixo ame'ẽ ta aja tĩ. Sinõ ok ta rake ixo ame'ẽ ta aja tĩ. Heta te hũ uhyk oho ehe tĩ. Upa ma'e katu ame'ẽ ke Jesu ma'ema'e ixo, aja ngã hendu, a'erehe johu ngã uhyk oho ehe. ");
INSERT INTO urbNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Mã heta te hũ ngã ixo. Ahy ixo ame'ẽ ta ke Jesu mukatu hũ. A'erehe upa katu te ahy ixo ame'ẽ ta ixoty jusosok oho ixo. Ipo ke mujar tar katu ehe. (Aja rahã, katu ta oho.) Ixoty jusosok sosok hũ oho ixo ngã. A'erehe jumu'eha ta pe Jesu pandu: —Se jarusu keruhũ pemuhyk perur — aja riki. Pe, jumãtã hũ ngã uwyr ehe rahã, jarusu keruhũ pe Jesu opor ta oho. (Aja rahã, jusosokiha rupi jukwa ym ta.) ");
INSERT INTO urbNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ahy ixo ame'ẽ ta ke Jesu mukatu. Pe, ipy'a rehe ãjã ihĩ, ame'ẽ ta usak ehe rahã, Jesu ruwa koty u'ar. (Aja rahã, katu te ame'ẽ ke kohĩ, aja mujekwa katu.) Pe, hãtã pandu: —Nde riki Tupã ra'yr — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Anĩ. Hãtã Jesu pandu: —Pepandu ym ihẽ rehe har — aja ãjã ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ajame'ẽ ke ywy'ã rehe Jesu jupir oho. Pe, sawa'e ta pe pandu: —Pejur! — aja. Katu usak ame'ẽ ta ke mujy'ar. Sawa'e ta uhyk uwyr ehe. ");
INSERT INTO urbNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kuja, awa py mokõi sawa'e ta ke jo'ok. “Ko ihẽ amondo ame'ẽ ta ke” aja Jesu. Ame'ẽ ta pe pandu tĩ: —Amõ ta ngi har pehẽ ke ihẽ ajo'ok. Ihẽ namõ pepyta ta. Amõ ta renda rupi pehẽ ke ihẽ amondo ta tĩ. Ame'ẽ rupi Tupã je'ẽha ke pepandu pandu ta peho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ihẽ je'ẽha rupi ãjã ta ke pemuhem ta katu tĩ. Awa ta py'a ngi pemuhem ta katu — aja awa py mokõi sawa'e ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jo'ok ame'ẽ ta kuja sawa'e ta rer. Ko Simã. Amõ her Jesu moĩ ehe. “Petu” aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Amõ sawa'e Tian. Imu Juã. Semende ra'yr ta ame'ẽ ta. Ame'ẽ ta rehe amõ her ke Jesu moĩ tĩ. “Mboane” aja a'eta pe. Ame'ẽ je'ẽha: “Pahar ipy'a pihun” aja. ");
INSERT INTO urbNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Amõ sawa'e Andere. Siri amõ tĩ. Amõ Matoroméu tĩ. Amõ Matéu. Amõ Tome tĩ. Tian amõ tĩ. Apéu ra'yr ame'ẽ. Tandéu amõ tĩ. Simã amõ tĩ. Sero aja her tĩ. (“Sero” pandu rahã: “Jundéu awa tama'e ywy ngi huwajan ta ke a'e mujan tar katu muhem” aja a'e.) ");
INSERT INTO urbNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Amõ Jun Ikario tĩ. A'e riki Jesu rehe huwajan ta ke muhyk werur. ");
INSERT INTO urbNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ajame'ẽ ke hok pe Jesu jywyr oho. Heta te hũ ngã uhyk uwyr ehe tĩ. Ame'ẽ ta pe Tupã je'ẽha pandu pandu hũ. Mukatu hũ ngã ke. Heta te hũ ngã uwyr ehe. A'erehe marã ka ym ma'e ke u'uha uĩ. Jumu'eha ta aja inamõ ixo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ame'ẽ rehe har ianam ta hendu rahã, Jesu ke oho piam tipe. Amõ ta pandu u'am: —Ka'u te'e riki a'e — aja naĩ. A'erehe oho piam tipe. (Anĩ. A'eta namõ Jesu oho ym.) ");
INSERT INTO urbNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusarẽ ok ta ngi amõ Moise je'ẽha mu'e ame'ẽ ta uhyk uwyr ehe. Ame'ẽ ta pandu pandu u'am: —Ipy'a rehe Mesembu ihĩ, a'erehe ãjã ta ke Jesu muhem katu mondo — aja pandu naĩ. (“Mesembu” aja pandu rahã: “Satana ke” aja ukwa. Ãjã ramũi a'e.) Amõ ta pandu: —Satana je'ẽha rupi ãjã ke a'e muhem mondo tĩ — aja pandu naĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pe, ngã ke Jesu mujy'ar. Myja me'ẽ ãjã ta my, ame'ẽ ke pandu pandu: —Satana jumuhem ym jumondo. ");
INSERT INTO urbNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ka'a rupi har ta jumai mai ngã juehe rahã, jumumba ta ngã juehe. (A'erehe jumai mai ym ta ngã juehe.) ");
INSERT INTO urbNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ok wyr pe har ta jumai mai a'eta juehe rahã, jumumba ta a'eta juehe tĩ. (A'erehe jumai mai ym ta a'eta juehe.) ");
INSERT INTO urbNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aja ixotyhar ta namõ Satana jumai mai a'eta juehe rahã, jumumba ta a'eta juehe tĩ. (A'erehe jumai mai ym ta a'eta juehe. A'erehe Satana je'ẽha rupi ãjã ta ke ihẽ amuhem ym amondo.) ");
INSERT INTO urbNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","—Sawa'e pyrãtã rok pe ma'e ke mukanim ym oho awa. Mukanim ta oho rahã, sawa'e pyrãtã ame'ẽ jywa ke mujere pukwar py, pe, sawa'ema'e ke upa mukanim ta raho. (Aja ihẽ tĩ. Satanama'e pyrãtãha ngi sawa'e ke ihẽ riki amuhem tĩ. Aja rahã, Satanama'e pyrãtãha 'ar koty te we ihẽma'e pyrãtãha, aja ihẽ amujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","—Ko apandu katu pehẽ pe. Upa ma'e ka'u te'eha ke amõ ma'ema'e. Ame'ẽ rehe Tupã ipy'a jywyr ta. “Tupã! Nde katu ym” aja pandu ame'ẽ ke rehe aja tĩ. Ipy'a jywyr ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tupã'ã pe anĩ. “Tupã'ã! Nde katu ym. Nde erema'eha katu ym” aja pandu ame'ẽ ke rehe anĩ. Ame'ẽ rehe jõ Tupã ipy'a jywyr ym te ta. Ma'e ka'u te'eha ma'ema'eha aja te'e ta ixo, a'erehe Tupã ipy'a jywyr ym te ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","A'eramõ amõ ta pandu: “Ãjã ipy'a rehe ihĩ” aja Jesu rehe har pandu naĩ. A'erehe myja me'ẽ ãjã ta my, ame'ẽ rehe har Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Imãi uhyk uwyr ehe. Imu ta amõ tĩ. Hukwen rake uhyk u'am. Pe, amõ pe imãi pandu: —Jesu pe epandu eho: “Se ejur” aja ipe — aja imãi. ");
INSERT INTO urbNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Heta ngã juramã jy'ar ixo ehe. Amõ ta pandu ipe: —Soroka pe ne mãi i'ãi, ne mu ta namõ. Nde pe pandu tar katu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","34","Pe, ngã rehe juramã usak. Pandu: —Pesarahã! Ko riki ihẽ mãi. Amõ ta ihẽ mu ta aja tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tupã putar ame'ẽ ke amõ ma'ema'e rahã, ame'ẽ riki ihẽ mu aja saka. Ihẽ rendyr aja tĩ. Ihẽ mãi aja tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Amõ rahã, ypa rymy'y rehe Jesu mu'e mu'e uĩ tĩ. Heta hũ ngã jumãtã katu te jy'ar ehe, a'erehe jarusu keruhũ pe opor oho. A'ep wapyk uĩ. Y pe jarusu keruhũ túi. Ypa rymy'y rehe upa ngã wapyk uĩ. Aja Jesu mu'e hũ ngã ke. ");
INSERT INTO urbNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Myja me'ẽ ma'e ra'ĩ ta my ame'ẽ ke pandu uĩ. Mu'e rahã, kuja pandu: ");
INSERT INTO urbNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Pehendu katurahã! Ma'e ra'ĩ ke amõ muhãi oho. ");
INSERT INTO urbNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kupixa pe ma'e ra'ĩ muhãi rahã, awa rape rupi amõ ha'ĩ u'ar. Ame'ẽ ke ma'ewyra u'u uwyr. Upa u'u. ");
INSERT INTO urbNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Amõ ma'e ra'ĩ ita ty rupi u'ar. A'ep ywy katu ame'ẽ ke ta'yr mi. Pe, ha'ĩ hywõi. Ywy heta ym a'ep, a'erehe pahar hywõi. ");
INSERT INTO urbNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pe, warahy haku rahã, i'y manõ. Hapo ipyp oho ym, a'erehe upa te'e manõ. ");
INSERT INTO urbNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Amõ ma'e ra'ĩ juruwe ty rupi u'ar. Juruwe tiha py oho. A'erehe ma'e ra'ĩ hywõi rahã, hury ym. A'erehe i'a ym. ");
INSERT INTO urbNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pe, amõ ma'e ra'ĩ ywy katu ame'ẽ rupi u'ar. Pe, hywõi rahã, hury katu oho. Tiha katu oho. I'a uhem, pe, tyarõ. Hymbo rehe heta i'a ihĩ. Tirĩ ta (30) aja hetaha. Amõ hymbo rehe heta we hũ i'a ihĩ. Sesen ta (60) aja hetaha. Amõ hymbo rehe heta te hũ i'a ihĩ. Sẽ (100) aja hetaha — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pandu tĩ: —Pekwa tar katu rahã, ihẽ apandu ame'ẽ ke rehe pehendu katu ta me'ẽ te'e — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesu jeje ixo rahã, awa py mokõi jumu'eha ta pandu uwyr ipe. Amõ ta aja tĩ. Pandu uwyr ipe tĩ. —Jande pe emujekwarahã! Myja me'ẽ ma'e ra'ĩ ta my, ame'ẽ ke emujekwa katu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A'e pandu: —Apo amõ koty Tupã mujekwa. Pyahu ame'ẽ ke. Kuja. Ixoty ipy'a ke amõ muruwak, ame'ẽ ke a'e putar katu. “Ihẽma'e a'e” aja a'e pandu. “Ame'ẽ ke nema'e jumu'eha ta pe emujekwa” aja Tupã pandu ihẽ pe. Amõ ta pe anĩ. Amujekwa ym ta. A'erehe myja me'ẽ ma'e ke my, ame'ẽ ke apandu pandu. Ame'ẽ ke rehe jõ ngã hendu tipe. ");
INSERT INTO urbNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Aja rahã: “A'eta usak usak tipe. Anĩ. Ukwa ym riki. Hendu hendu tipe. Anĩ. Ukwa ym riki tĩ. Ukwa rahã, Tupã rehe ipy'a ke muruwak ta tipe. Pe, ame'ẽ ta rehe ipy'a ke Tupã mujywyr ta tipe” aja ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pe, a'e pandu tĩ: —Ko ma'e ra'ĩ rehe har pekwa ta me'ẽ te'e. Pekwa ym rahã, amõ myja me'ẽ ma'e ke my, ame'ẽ ke ihẽ apandu rahã, pekwa ym ta tĩ. A'erehe ko amujekwa ta. ");
INSERT INTO urbNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ma'e ra'ĩ ke amõ muhãi oho. Ame'ẽ riki Tupã je'ẽha pandu pandu oho. ");
INSERT INTO urbNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ma'e ra'ĩ awa rape rupi u'ar. Ame'ẽ riki kuja. Tupã je'ẽha rehe amõ ta hendu. Pe, hendu rahã, pahar Satana mukanim uwyr. (Ma'ewyra uwyr, ame'ẽja saka.) ");
INSERT INTO urbNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","—Amõ ma'e ra'ĩ ita ty rupi u'ar. Ame'ẽ kuja. Tupã je'ẽha rehe hendu tipe. Hendu rahã, hury katu tipe. (Pahar hywõi, ame'ẽja saka.) ");
INSERT INTO urbNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tupã je'ẽha pyta katu ym, a'erehe tapijar te'e we jurujar ym. Tupã je'ẽha rehe jurujar, a'erehe amõ ta parahy ehe. (Warahy haku, ame'ẽja saka.) A'erehe pahar Tupã je'ẽha ke hijar. Amõ ta puka puka hũ ehe, a'erehe pahar Tupã je'ẽha ke hijar tĩ. Katu ym aja. ");
INSERT INTO urbNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","—Amõ ma'e ra'ĩ juruwe ty rupi u'ar. Ame'ẽ kuja. Tupã je'ẽha rehe hendu tipe. ");
INSERT INTO urbNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ima'e ixoha rehe te'e a'e ukwa ukwa ixo. “Ma'e ihẽ a'u ta my? Ma'e ihẽ amunde ta my?” aja ukwa ukwa ixo. Ko tamatarer matyr tar katu hũ. Upa ma'e ke matyr tar katu hũ. Upa ame'ẽ ke Tupã je'ẽha ke mukanim. (Juruwe jukwa, ame'ẽja saka.) Tupã rehe har ukwa ukwa tar ym. Ima'e ke rehe ipy'a katu. Katu ym aja. A'erehe ma'e i'a ym, ame'ẽja saka. (Aja rahã, amõ we Tupã rehe har ukwa tar ym.) ");
INSERT INTO urbNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","—Amõ ma'e ra'ĩ ywy katu rupi u'ar. Ame'ẽ ke kuja. Tupã je'ẽha rehe hendu katu. Hury katu. I'a heta aja ixo. Tirĩ ta (30) aja hetaha. Amõ amõ heta we hũ. Sesen ta (60) aja hetaha. Amõ heta te hũ. Sẽ (100) aja hetaha. (Aja rahã, Tupã rehe har ukwa katu, a'erehe ma'e katu ame'ẽ ke ma'ema'e hũ tĩ. Hymbo rehe i'a ihĩ, ame'ẽja saka) — aja Jesu mujekwa katu jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesu pandu tĩ: —Araparin amõ hapy rahã, pander pe jupyk ym. Myrape wyr pe moĩ ym tĩ. Anĩ. Ywate pukwar. Aja rahã, ok pe amõ ta ixo rahã, wera katu a'eta pe. ");
INSERT INTO urbNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ihẽ amu'e ame'ẽ ke ame'ẽja saka. Apo mukanim, ame'ẽja saka. I'i atu rahã, upa mujekwa ta ngã pe. Wera katu, ame'ẽja saka riki. Apo jupyk, ame'ẽja saka. I'i atu rahã, upa pirar ta, ame'ẽja saka. (Aja rahã, juehe har Tupã mujekwa ta ngã pe. Wera katu, ame'ẽja saka.) ");
INSERT INTO urbNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Pekwa tar katu rahã, pehendu katu 'y — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","A'e pandu tĩ: —Amõ pandu rahã, pehendu katu ehe. Pehendu tar ym rahã, pehẽ pe Tupã mujekwa ym ta. Pehendu tar katu rahã, pehẽ pe a'e mujekwa katu ta. Jete. I'ar koty te we mujekwa katu ta pehẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kuja riki. Amõ ukwa katu rahã, amõ we ukwa katuha ke Tupã muwyr ta ipe. Amõ ukwa tar ym rahã, ta'yr mi ukwa, ame'ẽ ke upa mukanim ta ingi. (Aja rahã, ukwa ym te ta) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Pe, a'e pandu tĩ: —Ihẽ amu'e ame'ẽ ke myja my? Ame'ẽ rehe har pehẽ pe apandu ta. Ame'ẽ ke kuja. Ywy rehe ma'e ra'ĩ ke amõ muhãi. ");
INSERT INTO urbNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pe, ima'e ke rehe a'e ma'ema'e oho ixo. Pytun rahã, aja. Wera rahã aja tĩ. Ima'e ke ma'ema'e oho ixo tĩ. Aja ixo rahã, ma'e ra'ĩ hywõi. Pe, tiha oho. Myja tihaha my, ukwa ym awa. ");
INSERT INTO urbNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jeje ywy ngi uhem. Ho uhem py. A'engi i'y. A'engi hãkã. A'engi hymbo. Pe, i'a. ");
INSERT INTO urbNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tyarõ rahã, amõ matyr oho. Matyriha angaha ke rehe uhyk oho — aja Jesu pandu. (Aja rahã, kuja mujekwa. Jesu mu'e, ame'ẽ ke rehe jurujar katu te rahã, ixoha amõ koty muruwak ta. Katu aja muruwak ta, aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","A'e pandu tĩ: —Se Tupã kotyhar ta ixo. Ame'ẽ rehe har pehẽ pe apandu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kuja ma'e ra'ĩ aja saka. Mosata ra'ĩ ame'ẽja saka. Ha'ĩ riki ta'yr te mi. ");
INSERT INTO urbNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pe, amõ jytym rahã, hywõi katu. Pe, i'y tiha te hũ oho. Kupixa pe har ta pyter pe tiha te ame'ẽ ke a'e. Hãkã ke pia pia hũ. Pe, ma'ewyra ta haity ta matyr ehe, hãkã rehe. Pytun atu ame'ẽ wyr pe ma'ewyra ta ihĩ — aja Jesu pandu. (Aja rahã, kuja mujekwa. Jesu pandu py rahã, Tupã kotyhar ta heta ym te. Ma'e ra'ĩ ta'yr te mi, ame'ẽja saka. Pe, i'i atu te rahã, ixotyhar ta heta te hũ ta. I'y tiha te hũ, ame'ẽja saka, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Pe, ngã ukwa katu rahã, amõ amõ myja me'ẽ ma'e ke my, ame'ẽ ke Jesu pandu ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Aja jõ ngã pe pandu. Jumu'eha ta anĩ. Ame'ẽ ta namõ jõ ixo rahã, upa katu te mujekwa. Myja me'ẽ ma'e ke my ame'ẽ ke upa katu te mujekwa jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ame'ẽ pytun ramõ rahã, jumu'eha ta pe Jesu pandu: —Y ruwái rehe jaha jaho — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Y rymy'y rehe heta ngã ke a'eta hijar oho. Jarusu keruhũ pe Jesu ihĩ. Ame'ẽ pe jumu'eha ta opor oho tĩ. Pe, y ruwái rehe oho. Amõ jarusu keruhũ pe amõ ta oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pe, oho we rahã, ywytu keruhũ uhyk ehe. Y kotok keruhũ katak hũ tĩ. Y ke oho rãi ipe. Tate jere oho. ");
INSERT INTO urbNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jarusu keruhũ tangwa koty Jesu ukwer ou. Iãkã renda rehe iãkã mupyta. Aja ukwer ou. Pe, amõ mupak oho. Pandu ipe: —Sa'e! Jande ke jajere tate riki. Nde erema'e ym ma'e ke my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Pe, pu'am rahã, hãtã ywytu keruhũ pe Jesu pandu. —Mã peja ym! Eputu'u katu ihẽ pe — aja riki. Y kotok keruhũ pe pandu tĩ: —Mã peja ym! Ewapyk katu — aja riki. Pe, ywytu keruhũ putu'u. Y ke wapyk katu te tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pe, jumu'eha ta pe pandu: —Mã! Pekyje ym ta me'ẽ te'e. Ihẽ rehe pejurujar ym my rĩ — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Anĩ. Jumu'eha ta kyje hũ. Pandu a'eta jupe: —Mã! Katu tiki! Pyrãtã te ame'ẽ ke kohĩ! Je'ẽha rehe ywytu keruhũ hendu katu! Y kotok keruhũ aja tĩ. Hendu katu ehe tĩ. Mã! Myja me'ẽ sawa'e ko my? — aja jumu'eha ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","A'engi ypa ruwái rehe uhyk oho, Jera ywy pe. ");
INSERT INTO urbNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jarusu keruhũ ngi Jesu uhem oho rahã, amõ sawa'e uhyk uwyr ehe. Itakwar kangwerupa ngi uhyk uwyr ehe. ");
INSERT INTO urbNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ipy'a rehe ãjã ihĩ ame'ẽ ke a'e. Itakwar kangwerupa rupi ixo ame'ẽ ke a'e. Ngã pukwar ym a'e ke apo 'y. Ita tupaham pe pukwar rahã, pyta ym. ");
INSERT INTO urbNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Amukwehe te ita tupaham pe ijywa ke mujere pukwar pukwar. Itymã ke pukwar tĩ. Anĩ riki. Ijywa pukwariha ke mohok riki. Ten! Itymã pukwariha ke mohok tĩ. Ten! Aja tĩ. Pyrãtã te hũ. A'erehe parahyha ke marã ka ym ngã mukanĩha ingi. Parahy te'e ixo. ");
INSERT INTO urbNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pytun rahã, ahem hũ. Wera rahã, ahem hũ tĩ. Itakwar kangwerupa rupi ahem ixo. Ywy'ã rupi ahem ixo tĩ. Hãtã ita pe jumu'i mu'i. ");
INSERT INTO urbNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Paite we Jesu rehe usak rahã, ixoty ujan oho. Hake ipynarãi pe wapyk oho. (Aja sawa'e katu te ame'ẽ ke kohĩ, a'erehe hendu katu ehe aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesu pandu ixo: —Ãjã! Sawa'e py'a ngi ehem eho! — aja riki. A'erehe hãtã je'ẽha uhem ingi: —Jesu! Nde riki Tupã ra'yr! Ywatehar te a'e. Ihẽ pe ema'e ym ma'e ke. Tupã je'ẽha rupi apandu: “Ihẽ ke emahy ym” — aja riki hãtã pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Pe, Jesu pandu: —Ma'e nde rer? — aja. Sawa'e pandu: —Jande reta ame'ẽ ke jande, a'erehe: “Heta” aja riki jande rer — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jesu pe pandu pandu u'am: —Kome'ẽ renda ngi ãjã ta ke emujan ym emondo — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ame'ẽ ywy'ã rehe kure ta mãte hũ ixo. Kãpĩ ke u'u ixo. ");
INSERT INTO urbNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ãjã ta pandu: —Kure ta koty jande ke emondo. Kure ta rehe jande jaĩ ta — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","—Ere. Peho — aja Jesu. Pe, sawa'e ngi ãjã ta uhem oho. Pe, kure ta pe ixe oho. (Ka'u te'e hũ uwak.) Pe, kure ta ujan oho. Upen te'e hũ ame'ẽ pe u'ar oho. Ypa pe u'ar oho. Upa katu te y jukwa. Heta te hũ kure ta manõ. Kuja, 2.000 hetaha manõ. ");
INSERT INTO urbNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kure usakiha ta ujan oho. Ok ta rupi pandu pandu oho. Ma'e usak ramõ, ame'ẽ rehe har pandu pandu oho. Amõ amõ awa renda rupi pandu oho tĩ. Pe, a'ep pe har ta usak uwyr. ");
INSERT INTO urbNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","16","Jesu rehe uhyk rahã, sawa'e rehe ngã usak. Ame'ẽ sawa'e ngi ãjã ta uhem ramõ. Wapyk uĩ. Ka'u ym apo 'y. Ima'e mundeha namõ ixo apo 'y. Myja sawa'e ka'u ame'ẽ ke katu oho. Ame'ẽ ke rehe usak ame'ẽ ta upa pandu pandu ngã pe. Kure ta ka'u oho, ame'ẽ rehe har upa pandu tĩ. (Pyrãtã te hũ ame'ẽ ke pehĩ, aja ukwa. A'erehe ngã kyje ingi, Jesu ngi. Amõ we ngãma'e kanim ta, ame'ẽ ke putar ym tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","A'erehe pandu ipe: —Jande rekoha ngi eho — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jarusu keruhũ pe Jesu opor oho ixo rahã, ãjã ta uhem ramõ ame'ẽ sawa'e pandu: —Ne namõ ihẽ aho ta — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","—Anĩ. Nde rekoha pe ejywyr eho. Jandema'e sawa'e te nde ke mukatu, ame'ẽ rehe har ne anam ta pe epandu eho. Nde rehe pyrara usak, ame'ẽ ke epandu tĩ — aja sawa'e pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Pe, sawa'e jywyr oho. Amõ amõ ok ta rupi pandu pandu. “Jesu ihẽ ke mukatu” aja pandu pandu. Aja Jande popa ok ta, ame'ẽ rupi upa pandu pandu oho. Sawa'e panduha rehe hendu ame'ẽ ta pandu: —Mã! Katu tiki! Katu te hũ — aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Y ruwái rehe Jesu jywyr oho tĩ. Jarusu keruhũ pe aha oho. Pe, heta ngã jy'ar uwyr ehe tĩ. Y rymy'y rehe pyta. ");
INSERT INTO urbNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Amõ sawa'e uhyk uwyr ehe. Her Jái. Jundéu awa tama'e jy'ariha rendama'e kapitã a'e. Jesu rehe uhyk rahã, ipixi'a pe u'ar oho oup. (Aja sawa'e katu te ame'ẽ ke kohĩ, a'erehe hendu katu ehe, aja mujekwa.) Pandu ipe: ");
INSERT INTO urbNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Ihẽ rajyr manõ tate. Ihẽ rok pe eho! Iãkã rehe nde po nde eremujar rahã, katu ta oho — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Pe, oho inamõ. Oho ixo rahã, heta ngã Jesu rake rupi tuka tuka hũ oho ixo. ");
INSERT INTO urbNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pe, amõ kũjã oho ixo tĩ. Ma'e ahyha namõ ixo. Jaiha ke pupur rãi namõ ixo. Aja yman riki ixo. Kuja. Awa py mokõi (12) warahy 'ar rahã, aja te'e ixo. ");
INSERT INTO urbNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ahyha mukatuha koty oho oho hũ tipe. Ame'ẽ ta pe upa tamatarer me'ẽ me'ẽ tipe. Mukatu ym. I'ar koty te we mupyraraha riki ame'ẽ ta. Pe, katu ym oho ipe rĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Jesu rehe har ngã pandu pandu, ame'ẽ ke hendu. “Jesu mukatu” aja kũjã hendu. A'erehe kuja ipy'a pe ukwa ukwa ixo: —Ima'e mundeha rehe ihẽ po amujar rahã, ihẽ katu ta aho — aja kũjã. Pe, ngã pyter rupi kũjã wata oho ixo. Pe, xupe rehe uhyk oho. ");
INSERT INTO urbNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pe, Jesuma'e mundeha apyr rehe ipo mujar. Pahar jaiha ke pupur ame'ẽ ke putu'u ingi. Upa katu, aja ukwa. ");
INSERT INTO urbNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pe, pahar Jesu ukwa. Amõ ke mukatu, aja ukwa. A'erehe uwak u'am. Pe, pandu: —Awa ihẽma'e mundeha rehe ipo mujar my? — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","—Nde rake rupi heta ngã juramã u'am, a'erehe nde rehe tukwa tukwa hũ u'am. Ma'ewã nde erepandu my: “Awa ihẽma'e mundeha rehe ipo mujar” aja — aja jumu'eha ta pandu ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Anĩ. Jesu usak usak we rĩ. Awa mujar my? Kekar we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Katu apo, aja kũjã ukwa katu, a'erehe kyje uhyk ehe. Ryrýi tĩ. Huwa koty ipynarãi pe wapyk. (Aja sawa'e katu te ame'ẽ ke kohĩ, a'erehe hendu katu ehe, aja mujekwa.) Pe, upa katu te Jesu pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","—Éi, kũjã! Upa ma'e ahyha ke amukatu, ame'ẽ rehe nde erejurujar katu, a'erehe nde katu apo 'y. Nde rury katu eho apo. Jaiha pupur ame'ẽ ke upa putu'u katu te nde pe apo 'y — aja Jesu ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kũjã namõ pandu u'am rahã, Jái rok ngi amõ ta uhyk uwyr. —Nde rajyr manõ ramõ te. Mã peja mu'eha jywyr oho — aja Jái pe. (“Mu'eha” aja pandu rahã: “Jesu ke” aja a'eta ukwa.) ");
INSERT INTO urbNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tajyr manõ ame'ẽ ke rehe Jesu hendu rahã, Jái pe pandu: —Anĩ. Nde py'ahu te'e exo. Ihẽ rehe tapijar te'e we ejurujar katu — aja ipe. —Hã! — aja Jái. ");
INSERT INTO urbNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","A'engi Jái rok pe oho inamõ. Heta ngã anĩ. Mupyta. —Se pepyta — aja. Kuja jõ oho. Kũjãtãi pái. Petu oho. Tian oho tĩ. Imu oho tĩ. Her Juã. Ame'ẽ ta jõ inamõ oho. ");
INSERT INTO urbNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pe, Jái rok pe uhyk rahã, heta ngã i'ãi a'ep. Ngã mutyapu tyapu hũ. Jixi'u xi'u hũ ngã. Ahem amõ tĩ. (Aja pyaiha ke mujekwa.) Ame'ẽ ke rehe Jesu usak. ");
INSERT INTO urbNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pe, pandu: —Mã! Pemutyapu tyapu hũ ym. Pejixi'u ym tĩ. Kũjãtãi manõ ym. Ukwer ou riki — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pe, ngã puka puka hũ ehe. Manõ te aja ukwa katu, a'erehe puka puka hũ ehe. A'erehe soroka pe upa ngã ke Jesu muhem. Pe, kũjãtãi túi, ame'ẽ kapy pe oho. Mahapyr jumu'eha ta ke raho inamõ tĩ. Kũjãtãi pái raho tĩ. Imãi raho tĩ. Ame'ẽ ta jõ kapy pe ixe oho. ");
INSERT INTO urbNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Uhyk rahã, ipo rehe Jesu pyhyk. Pe, pandu: —Tarita kumi — aja. Ame'ẽ jundéu awa ta je'ẽha ipe: “Kũjãtãi! Nde pe apandu, epu'am!” aja. ");
INSERT INTO urbNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Pahar kũjãtãi pu'am. Pe, wata ixo. Awa py mokõi warahy 'ar ame'ẽ ke kũjãtãi. Kweraha rehe usak ame'ẽ ta pandu pandu a'eta jupe: —Mã! Katu tiki! — aja kapy pe ixo ame'ẽ ta. ");
INSERT INTO urbNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pe, Jesu pandu: —Pehẽ py'a rupi te'e pereko — aja. Imãi pe pandu tĩ: —Ma'e ke eme'ẽ ipe. Kũjãtãi u'u ta — aja. (Ma'e ke u'u rahã, ixuwe katu a'e, aja ukwa katu ta, a'erehe: “Ma'e ke eme'ẽ ipe” aja Jesu pandu ipe.) ");
INSERT INTO urbNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","A'engi Jesu oho. Hekoha pe jywyr oho, Nasare ok ta pe. Upa jumu'eha ta oho inamõ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Jundéu awa tama'e putu'uha 'ar rahã, jundéu awa tama'e jy'ariha renda pe mu'e oho. Heta ngã ixo a'ep. Pe, hendu ame'ẽ ta pandu: —Mã! My riki ukwa katuha ukwa my? Awa a'e ke mu'e my? (Jakwa ym jande.) Marã ka ym amõ ma'eha, ame'ẽ ke a'e ma'ema'e katu te. Mã! (Jande aja awa te'e a'e tĩ.) Myja ame'ẽ ke a'e ma'ema'e my? (Jakwa ym tĩ.) Jesu riki peme'ẽ. Myra rehe ma'eha peme'ẽ. Mari membyr ke a'e. Imu ta ko jande namõ ixo tĩ, jande rekoha pe. Tian. Jose amõ tĩ. Jun amõ tĩ. Simã amõ tĩ. Hendyr ta jande namõ ixo tĩ — aja ngã pandu. Hekoha pe har ta aja Jesu tĩ, aja ngã ukwa, a'erehe Jesu ke putar ym. ");
INSERT INTO urbNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","A'erehe Jesu pandu: —Tupã je'ẽha pandu ame'ẽ ke amõ hekoha pe pandu oho rahã, ame'ẽ ta hendu katu. Putar katu. Hekoha te pe pandu rahã, anĩ. Hekoha pe har ta hendu ym. Putar ym. Hok wyr pe har ta aja tĩ. Hendu ym tĩ. Amõ ianam ta aja tĩ. Hendu ym tĩ. Putar ym tĩ — aja ngã pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ngã putar ym, a'erehe mukatu hũ ym a'ep. Peteĩ teĩ ma'e ahy ixo ame'ẽ ta rehe ipo mujar. Aja mukatu. ");
INSERT INTO urbNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ipy'a pe Jesu ukwa ixo: —Mã! Marã ka ym amõ ma'eha, ame'ẽ ke ihẽ ama'ema'e katu. Aja ihẽ ke Tupã muwyr, aja amujekwa. Anĩ. Peme'ẽ ta jurujar ym ihẽ rehe. Mã! — aja jupe. Pe, a'engi amõ ta hekoha rupi mu'e mu'e oho. ");
INSERT INTO urbNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","9","Ajame'ẽ ke awa py mokõi jumu'eha ta pe Jesu pandu: —Se pejur. Ko pehẽ ke ihẽ amondo ta. Pehẽ mokõi mokõi peho. Ihẽ je'ẽha rupi peho. Amõ ta py'a ngi ãjã ta ke pemuhem katu ta. Peho rahã, ma'e ke peraho ym. Pehẽ mi'u peraho ym. Pehẽ kupe pe ma'e ryru ke peraho ym tĩ. Tamatarer peraho ym tĩ. Myra te'e pehẽ po pe peraho katu. (Pehẽ re'õ rahã, myra rehe pepyta pyta peho pexo.) Pehẽ py rehe har pemunde. Peteĩ kamixa namõ peho katu. ");
INSERT INTO urbNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","—Amõ rekoha rehe pehyk rahã, amõ pandu ta: “Ko pejur katu. Se ihẽ rok pe pepyta katu” aja. Ame'ẽ rok pe pepyta katu. A'ep pepyta pexo rahã, ame'ẽ rok pe jõ pepyta katu. ");
INSERT INTO urbNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","—Amõ rekoha pe pehyk. A'ep pe har ta putar ym pehẽ ke. Pehẽ je'ẽha rehe hendu tar ym tĩ. Aja rahã, ame'ẽ hekoha ngi peho. Ok ta ngi pehem peho rahã, ywy ku'i pehẽ py ngi pejuhyk katu. Ame'ẽ ke ngã usak rahã, kuja ukwa ta. Tupã ke a'ep pe har ta putar ym aja pemujekwa — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pe, jumu'eha ta oho. Mokõi pame a'eta oho. Amõ ok ta rupi pandu pandu oho. —Ma'e peka'u te'eha pema'ema'eha ke pehijar. Tupã koty pehẽ py'a pemuruwak — aja pandu oho. ");
INSERT INTO urbNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Heta ãjã ta ke ngã py'a ngi muhem mondo tĩ. Ma'e ahy ixo ame'ẽ ta rehe ma'e ka kytyk tĩ. Ipykã rehe kytyk. Karapatu ka aja me'ẽ. Aja ngã ke mukatu hũ. ");
INSERT INTO urbNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesu ma'ema'eha rehe har upa ngã pandu pandu. Ame'ẽ ke rehe Ero hendu. A'e jundéu awa tama'e kapitam. Amõ ta kuja pandu: —Peme'ẽ riki Juã mujahukiha ke. Manõha ngi Tupã mukwera katu muhem. A'erehe pyrãtã te ha namõ ma'e ke Jesu ma'ema'e katu. Marã ka ym amõ ma'eha, ame'ẽ ke ma'ema'e katu — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Amõ ta pandu: —Anĩ. Peme'ẽ riki Eri. Ymanihar Tupã je'ẽha pandu ame'ẽ ke jywyr — aja riki tĩ. Amõ ta pandu: —Anĩ. Peme'ẽ riki Tupã je'ẽha pandu ame'ẽ ke a'e. Ymanihar aja Tupã je'ẽha pandu ame'ẽ ke a'e tĩ — aja tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Amõ koty koty Jesu rehe har Ero hendu rahã, kuja pandu: —Anĩ. Peme'ẽ riki Juã mujahukiha ke. A'e ke Tupã mukwera katu muhem tĩ. Amukwehe te we amõ pe ihẽ apandu: “Juã ãkã ke emondok eho ingi” aja. Kwera katu uhem apo 'y — aja ukwaha naĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Amukwehe te we kuja ixo. Ero mu ixo. Her Siri. Siri rakehar rer Erondi. Ame'ẽ imu rakehar ke Ero jo'ok raho ingi. A'erehe Juã pandu ipe: —Mã peja ym. Ne mu rakehar namõ nde erexo rahã, katu ym — aja Ero pe pandu. Ame'ẽ ke Erondi ukwa tĩ. A'erehe parahy ehe, Juã rehe. Jukwa tar katu tĩ. Ame'ẽ ke Ero putar ym, a'erehe marã ka ym Juã ke hakehar jukwaha. ");
INSERT INTO urbNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Juã riki sawa'e katu ame'ẽ ke a'e aja Ero ukwa. Jaxer ame'ẽ ke nixói ipe aja ukwa tĩ, a'erehe kyje ingi, Juã ngi. A'erehe amõ renda pe Juã ke Ero mupyta. (A'erehe marã ka a'e ke hakehar jukwaha.) Juã je'ẽha rehe Ero hendu tar katu tĩ. Hendu katu tipe. Amõ amõ rahã, hendu rahã: “Mã! Myja me'ẽ ihẽ ama'e ta my?” aja Ero pandu jupe. ");
INSERT INTO urbNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pe! Juã jukwaha angaha ke rehe uhyk 'y. Kuja. Yman imãi pusu ngi Ero u'ar. Ame'ẽ rehe imi'u matyr ixo apo. Aja ukwa ukwa ixo tĩ. Pe, kapitã ta ke mujy'ar. Sonda tama'e kapitã ta ke mujy'ar tĩ. Ima'ehũ namõ ixo ame'ẽ ta ke mujy'ar tĩ. Ame'ẽ ta ngariréi ywy pe har ta ke a'eta. Ma'e u'uha renda pe upa ame'ẽ ta ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ame'ẽ renda pe Erondi membyr ixe uwyr. Kũjãtãi keruhũ a'e. Pe, purahái. Upa kapitã ta ke muhury. Ero hury katu tĩ. Pe, kũjãtãi pe pandu: —Ma'e nde ereputar my? Upa nde ereputar ame'ẽ ke ihẽ riki ame'ẽ ta nde pe — aja Ero. ");
INSERT INTO urbNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pandu pandu riki tĩ: —Ko Tupã ruwa koty aja jaxo. Apandu katu. Upa nde ereputar ame'ẽ ke ihẽ riki ame'ẽ ta nde pe. Esarahã! Upa katu te ihẽma'e ihĩ. Nde ereputar rahã, ame'ẽ ke amowok ta nde pe. Wajar nema'e ta — aja Ero. ");
INSERT INTO urbNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Imãi pe kũjãtãi pandu oho: —Mãi! Ma'e ihẽ apandu ta my? — aja. Imãi pandu: —Juã mujahukiha ãkã ke epandu ipe — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Pahar Ero koty jywyr oho. Pe, pandu ipe: —Juã ãkã ke ihẽ aputar. Ita paratu 'ar pe ihẽ pe erur apo — aja kũjãtãi. ");
INSERT INTO urbNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ame'ẽ ke rehe hendu rahã, Ero pyai te hũ. (Juã ke jukwa tar ym.) A'erehe pyai te hũ. Ero je'ẽha rehe upa kapitã ta hendu ramõ te: “Tupã ruwa koty aja jaxo. Nde ereputar ame'ẽ ke ihẽ riki ame'ẽ ta” aja. A'erehe kũjãtãi pe: “Anĩ. Ama'e ym ta” aja marã ka ym panduha. Pandu rahã, huxĩ hũ ta tipe. ");
INSERT INTO urbNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","A'erehe pahar sonda pe pandu: —Juã ãkã ke emondok erur — aja. Kyndaha pe sonda oho. Pe, iãkã mondok ingi. ");
INSERT INTO urbNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pe, ita paratu 'ar pe werur. Kũjãtãi pe me'ẽ. Ame'ẽ ke imãi pe kũjãtãi raho. ");
INSERT INTO urbNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juã ke amõ jukwa, aja Juã namõ jumu'e ixo ame'ẽ ta hendu rahã, hete ke oho piam. Pe, kangwerupa pe jytym raho. ");
INSERT INTO urbNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ajame'ẽ ke Jesu mondo ame'ẽ ta jywyr uwyr ixoty, Jesu koty. Upa ma'ema'eha ke pandu ipe. Upa ma'e mu'e ame'ẽ ke pandu ipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pe, heta ngã uhyk uwyr ehe tĩ. Pe, hekoha pe ame'ẽ ta jywyr oho tĩ. Amõ ta uhyk ehe tĩ. Ame'ẽ ta jywyr oho tĩ. Amõ amõ ta uhyk tĩ. Aja riki ixo. A'erehe marã ka ym ma'e ke u'uha. (Ma'ema'e hũ ixo, myja ym ma'e ke u'uha.) A'erehe Jesu pandu: —Jande jõ ngã nixói te ame'ẽ pe jaho. A'ep japutu'u we ta — aja jumu'eha ta pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pe, ngã nixói te ame'ẽ pe a'eta jõ oho ixo. Jarusu keruhũ pe oho, y ruwái rehe. ");
INSERT INTO urbNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Amõ ta ohoha rehe usak. Jesu ta oho, aja ame'ẽ ta ukwa. A'erehe pe rupi ngã ujan oho. Y rymy'y rupi ujan oho. Ok ta ngi upa ngã ujan oho. Pe, ngã nixói te ame'ẽ pe uhyk py oho. ");
INSERT INTO urbNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","A'ep Jesu uhyk rahã, heta te hũ ngã rehe usak. Usak rahã, pyai. Ame'ẽ ta riki arapuharan ta aja saka. Usakiha nixói, ame'ẽja saka. (Aja rahã, ngã rehe usakiha nixói tĩ, aja mujekwa.) A'erehe Jesu pyai. A'erehe pyrara ngã rehe usak. A'erehe Tupã je'ẽha ke mu'e hũ ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Ka'aruk koty rahã, jumu'eha ta uhyk ehe. Ngã mi'u nixói te, a'erehe pandu ipe: —Warahy ka'aruk te apo. Ko awa nixói te, ame'ẽ renda ke se. Ngã ke emondo sengi. Paite ok ta rupi imi'u ke a'eta jo'ok ta oho — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Anĩ. Ngã mi'u ke pehẽ atu peme'ẽ me'ẽ katu — aja jumu'eha ta pe pandu. —Mã! Kuja, 200 wera rahã, paraky. Aja tamatarer pyhyk. Ame'ẽ tamatarer pe mbeju jajo'ok. Pe, ngã pe jame'ẽ me'ẽ. Aja nde ereputar my? — aja jumu'eha ta. ");
INSERT INTO urbNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—Myja mbeju hetaha pehĩ my? Pesak peho — aja Jesu. Usak rahã, pandu ipe: —Kuja pehĩ. Awa po wajar peteĩhar upa mbeju hetaha. Pira ka'ẽ, kuja, mokõi jõ — aja jumu'eha ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesu pandu: —“Pewapyk” aja ngã pe pepandu — aja jumu'eha ta pe. Ngã pe jumu'eha ta pandu: —Amõ koty koty pejy'ar aja pewapyk — aja. Pe, kãpĩ ra'yr 'ar pe ngã wapyk. ");
INSERT INTO urbNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ko 50 hetaha wapyk. Se koty amõ 100 hetaha. Se koty amõ 50 hetaha. Se koty amõ 100 hetaha. Aja upa katu te ngã wapyk uĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pe, awa po wajar peteĩhar upa mbeju ke Jesu pyhyk, pira ka'ẽ namõ. Pe, ywa rehe ma'ã. Tupã namõ pandu: —Ne jõ riki katu te me'ẽ ke. Jande mi'u nde eremuwyr katu — aja. Pe, mbeju mopok. Jumu'eha ta pe me'ẽ. Ame'ẽ ke ngã pe jumu'eha ta me'ẽ me'ẽ raho. Aja mokõi pira ka'ẽ ke me'ẽ me'ẽ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Pe, upa ngã u'u. Uhyk ngã u'u. Upa u'u rahã, jumu'eha ta pyta we ame'ẽ ke matyr. Kuja, awa py mokõi wasãkã tyryhem matyr. Mbeju pyta we ame'ẽ ke matyr. Pira ka'ẽ aja tĩ. Pyta we matyr tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ngã mi'u u'u, ame'ẽ ta heta te hũ. Sawa'e ta jõ manga rahã, kuja, 5.000 hetaha ngã ixo. ");
INSERT INTO urbNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ajame'ẽ ke pahar jumu'eha ta ke Jesu mondo. Jarusu keruhũ pe mondo. Pandu: —Hok pe ngã ke ihẽ amujywyr ta amondo axo rahã, ypa ruwái koty peho. Mesái ok ta pe peho. Jarusu keruhũ pe peho. I'i atu rahã we, ihẽ aho ta kỹ — aja Jesu. Pe, jarusu keruhũ pe jumu'eha ta opor oho. Pe, aha oho ixo. Jesu pyta we rĩ. Pe, amõ ta pe pandu: —Pehẽ rok pe pejywyr peho — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Upa ngã hijar oho rahã, ywy'ã rehe Jesu jeje jupir oho. Tupã namõ a'e pandu pandu oho. ");
INSERT INTO urbNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pytun rahã, ywy rehe Jesu jeje ixo rĩ. Jarusu keruhũ ke ypa pyter pe ihĩ. Ame'ẽ pe jumu'eha ta ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ame'ẽ ta rehe ywytuhu juwapi uwyr. A'erehe jumu'eha ta pykũi hũ tipe. Henda te'e ihĩ. Paite ngi ame'ẽ ta rehe Jesu usak. Pe, sapukái je'ẽ ramõ rahã, a'eta rehe Jesu uhyk uwyr ixo. Y 'ar rupi te'e uwyr ixo. Xupe 'ar rupi aha ta tipe oho. ");
INSERT INTO urbNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Y 'ar rupi wata uwyr ixo ame'ẽ ke rehe jumu'eha ta usak. Ame'ẽ riki Jesu aja ukwa ym, a'erehe ahem hũ: —Ãjã pe tur ixo — aja jumu'eha ta ukwaha naĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Upa usak ehe rahã, mukahem hũ. Pe, pahar Jesu pukái: —Pekyje ym! Pehẽ py'ahu te'e pexo. Ihẽ Jesu — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pe, jarusu keruhũ rehe uhyk, pe, opor oho. Ywytuhu putu'u. Jumu'eha ta pandu pandu a'eta jupe: —Mã! Y 'ar rupi wata katu! — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pyrãtãha namõ ngã mi'u ke Jesu muheta. Ame'ẽ ke jumu'eha ta ukwa ym, (a'erehe pyrãtãha namõ y 'ar rupi Jesu wata katu tĩ. Ame'ẽ ke ukwa ym tĩ.) Iãkã riki janam rãi te'e. ");
INSERT INTO urbNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","A'engi y ruwái rehe uhyk, Jenesare ywy pe. A'ep jarusu keruhũ pukwar. ");
INSERT INTO urbNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pe, jarusu keruhũ ngi uhem oho rahã, ame'ẽ ta rehe heta ngã usak. Pe, pahar ngã ukwa katu. —Ko Jesu — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pe, ame'ẽ hekoha rupi upa ma'e ahy ixo ame'ẽ ta ke ngã oho piam. Muhyk werur ehe. Kyha aja me'ẽ pe werur tĩ. “Paite ixo apo” aja hendu rahã, a'ep ahy ixo ame'ẽ ta ke raho ngã. ");
INSERT INTO urbNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pe, amõ amõ hekoha rupi Jesu oho. Ok ta rupi oho. Ok ta keruhũ rupi oho tĩ. Awa renda rupi oho tĩ. Upa ame'ẽ rupi oho rahã, soroka pe ma'e ahy ixo ame'ẽ ta ke ngã mou. Pete'e túi. Ame'ẽ ta pandu: —Mã peja nema'e mundeha rehe ahy ixo ame'ẽ ta pyhyk. Mã peja nema'e mundeha apyr rehe jõ pyhyk — aja Jesu pe. Pe, ima'e mundeha apyr ke pyhyk ame'ẽ ta upa katu te katu oho. ");
INSERT INTO urbNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Hamũi ta mu'e aja ipo ke jundéu awa ta kutuk ym rahã, ma'e ke u'u ym. Aja te'eha a'eta ma'eha. (Hamũi ta mu'e aja ipo ke kutuk rahã, Tupã usak katu ehe, aja ukwaha naĩ.) Parise ta aja tĩ. Upa ymanihar hamũi ta mu'e ame'ẽ ke rehe hendu katu. Ma'e muhepyha renda ngi hok pe jywyr rahã, ma'e ke u'u ym rĩ. Ipo ke kutuk py, pe, u'u. Aja amõ amõ heta ymanihar hamũi ta mu'e ame'ẽ ke rehe hendu katu. Ko y u'uha ke kutuk. Pander ke aja tĩ. Ita pander ke aja tĩ. Hamũi ta mu'e aja upa kutuk riki tĩ. (Aja rahã, Tupã usak katu ehe, aja ukwaha naĩ.) Pe, Jesu rehe parise ta jy'ar uwyr. (Parise ta riki hamũi mu'eha rehe hendu katu te ame'ẽ ta ke a'eta.) Jundéu awa ramũi ta je'ẽha ukwa, ame'ẽ ta jy'ar uwyr tĩ. Jerusarẽ ok ta ngi johu jy'ar uwyr ehe. Jesu namõ ame'ẽ ta je'ẽ je'ẽ. Hamũi ta mu'e aja ipo ke jumu'eha ta kutuk ym. Aja te'e ma'e ke u'u. ");
INSERT INTO urbNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","A'erehe Jesu pe a'eta pandu: —Ma'erehe jande ramũi mu'e ame'ẽ ke rehe nema'e jumu'eha ta hendu ym my? Ame'ẽ ta u'u rahã, jande ramũi mu'e, aja ipo ke a'eta kutuk ym tiki. Katu ym aja — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","—A'e riki. Ipo ke kutuk ym. Pesarahã! Yman pehẽ rehe har Tupã je'ẽha rehe Isai mupinim, aja mokõi pekwaha namõ pexo ame'ẽ ta ke pehẽ. Ame'ẽ rehe har a'e mupinim. Kuja Tupã pandu: “Ihẽ rehe har ngã katu pandu tipe. Anĩ. Hendu ym ihẽ je'ẽha rehe. ");
INSERT INTO urbNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ihẽ rehe har katu pandu tipe. Pandu te'e riki. Hamũi je'ẽha ke ngã mu'e ixo. ‘Kome'ẽ riki Tupã je'ẽha’ aja ngã mu'e naĩ” aja Tupã pandu. Aja Isai mupinim. ");
INSERT INTO urbNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","—Tupã je'ẽha ke pehijar. Apo ymanihar pehẽ ramũi ta mu'e ame'ẽ ke rehe jõ pehendu katu. Katu ym aja — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A'e Pandu tĩ: —Mã! Tupã je'ẽha ke pehijar. A'erehe ymanihar pehẽ ramũi ta mu'e, ame'ẽ ke pemu'e katu ta, aja pekwaha naĩ. Aja rahã, pekwa katu ame'ẽ ta ke pehẽ, aja pekwaha naĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yman Moise mupinim: “Nde pái rehe epy'a katu. Ne mãi rehe aja tĩ. Epy'a katu tĩ. Kuja tĩ. ‘Papa! Nde jaxer’ aja amõ pandu rahã, ame'ẽ ke ejukwa. ‘Mãi! Nde jaxer’ aja pandu ame'ẽ ke ejukwa tĩ” aja Moise mupinim. (“Jaxer” aja pandu rahã: “Ipái ta rehe ipy'a ym” aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","13","—Anĩ riki. Ame'ẽ rehe pehendu ym te. Pesarahã! Ma'e ke pehĩ. Ame'ẽ namõ ipái ta rehe usak katu ta me'ẽ te'e. Anĩ. “Ko Tupãma'e ke apo 'y. Tupã pe ihẽ ame'ẽ, ame'ẽja saka. A'erehe pehẽ pe ihẽ ame'ẽ ym ta apo 'y” aja ipái ta pe pandu. Aja rahã, ame'ẽ namõ ipái ta rehe usak ym ta apo 'y. Haihu ym ta apo 'y. A'erehe Tupã je'ẽha rehe pehendu ym. “Pehẽ pái ta rehe pepy'a katu” ame'ẽ rehe pehendu ym. Katu ym aja. Aja amõ amõ we pemu'e ame'ẽ ke pehĩ. Aja Tupã je'ẽha rehe pehendu ym. Katu ym aja — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","(Pe, ipo ke kutuk ym ha namõ ma'e ke u'u. Ame'ẽ ke mujekwa.) Kuja heta ngã pe Jesu pandu: —Se pejur! Pehendu katurahã! Pekwa katu ta. ");
INSERT INTO urbNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Soroka pe ma'e ke ihĩ. Ame'ẽ ke amõ juru kwar rupi oho rahã, ipy'a ke mujaxer ym. Ma'e ke amõ pandu, ame'ẽ ke juru ngi uhem, ame'ẽja saka. Ame'ẽ riki ipy'a jaxeriha ke mujekwa katu. ");
INSERT INTO urbNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Pekwa tar katu rahã, pehendu katu — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Hetaha ta ke Jesu hijar oho. Pe, ok pe ixe oho rahã, jumu'eha ta pandu: —Ame'ẽ amõ py'a jaxer ame'ẽ rehe har emujekwa jande pe. Jakwa ym — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","—Mã! Amõ ta aja pekwa ym my tĩ! Ko amujekwa ta pehẽ pe. Ma'e ke amõ u'u rahã, juru kwar rupi oho. Ame'ẽ mujaxer ym amõ py'a ke. ");
INSERT INTO urbNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ipy'a pe oho ym, a'erehe ipy'a mujaxer ym. Ipusu pe ihon. A'engi ka'a aja uhem oho — aja Jesu pandu. (Aja pandu rahã, upa ma'e ke ngã u'u ame'ẽ ke katu, aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pandu tĩ: —Amõ jywĩ ngi ma'e ke uhem rahã, ame'ẽ riki amõ ke mujaxer. ");
INSERT INTO urbNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Amõ jywĩ ngi uhem. Aja rahã, ipy'a ngi uhem, ame'ẽja saka. Ko ma'e ka'u te'eha ke ipy'a pe ukwa ukwa ixo. Upa rahã, ame'ẽ ke ma'ema'e. Ko amõ kũjã rehe ka'u te'e. Amõ sawa'e rehe ka'u te'e tĩ. Amõma'e ke mukanim. Amõ ke jukwa tar katu. ");
INSERT INTO urbNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Hakehar aja ym ame'ẽ namõ jumusarái. Ixawa'e aja ym ame'ẽ namõ jumusarái. Amõma'e ke rehe ipy'a moĩ hũ. Upa ma'e katu ym ame'ẽ ke ma'ema'e. Te'e pandu. Ma'e ke mujesak ame'ẽ rehe huxĩ awa. Katu ym aja. Kyty'ym. Amõ ta rehe juru ai. “Ihẽ jõ katu me'ẽ ke” aja jõ pandu. Ko ka'u te'e hũ ame'ẽ ke. ");
INSERT INTO urbNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Upa katu te aja jaxer ame'ẽ ke amõ jywĩ ngi uhem. Ipy'a ngi uhem, ame'ẽja saka. Upa ame'ẽ ke mujaxer awa ke — aja Jesu mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","A'engi Jesu uhem oho. Amõ ywy pe oho. Tir ok ta rake ame'ẽ pe oho. Sinõ ok ta rake ame'ẽ ywy tĩ. Pe, amõ rok pe ixe oho. A'ep a'e ixo aja amõ ta ukwa. Ame'ẽ ke a'e putar ym. Anĩ. Marã ka ym mukanĩha. “Pete'e ixo” aja ngã ukwa riki. ");
INSERT INTO urbNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","A'e uhyk aja amõ kũjã hendu. Pe, uhyk oho ehe. Amõ koty je'ẽha kũjãma'e ke. Ngere ywy pe har je'ẽha ke ame'ẽ. Jundéu awa ym a'e. Siro-seni ywy pe har a'e. Ame'ẽ membyr py'a rehe ãjã ihĩ, kũjãtãi ra'yr ke a'e. Pe, Jesu rehe kũjã uhyk rahã, pahar huwa koty ipynarãi pe wapyk. (Aja sawa'e katu te ame'ẽ ke kohĩ, a'erehe hendu katu ehe aja mujekwa.) Pe, pandu ipe: —Ihẽ membyr ngi ãjã ke emuhem emondo — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","—Ta'yn ta pe a'eta mi'u ke amõ me'ẽ py. Ta'ỹma'e mi'u ke jawar ta pe ombor rahã, katu ym — aja Jesu. (Aja rahã jundéu awa ta namõ Jesu ma'ema'e py ta, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kũjã pandu: —Sa'e! Esarahã! A'eta mi'u ke ta'yn ta mukurer kurer riki. Ame'ẽ ke jawar ra'yr ta myrape wyr pe u'u riki — aja ipe. (Aja rahã, ta'yr mi ma'e katu ame'ẽ ke amõ awa ta pyhyk ta, aja kũjã mujekwa katu. “Jawar ra'yr” aja pandu rahã: “Amõ awa ta” aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","—Mã! Nde erepandu katu. Nde rok pe ejywyr eho. Ne membyr py'a ngi ãjã uhem oho apo 'y — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Pe, hok pe kũjã jywyr oho. Uhyk rahã, imembyr rehe usak. Myrape 'ar pe nino ou. Jete. Ipy'a ngi ãjã uhem oho, aja kũjãtãi túi. (Jesu pandu, aja me'ẽ uhyk katu 'y.) ");
INSERT INTO urbNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ajame'ẽ ke ame'ẽ renda ke Jesu hijar oho. Ame'ẽ renda Tir ok ta rake ihĩ. Oho rahã, Sinõ ok ta rupi asa oho. Ngariréi ypa pe oho ixo. “Jande popa ok ta” ame'ẽ rupi asa oho ixo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","A'ep pe har ta sawa'e ke muhyk raho ehe. Ame'ẽ ipyakwar ym. Hembe ke hãtã tĩ. Jesu pe a'eta pandu: —Sawa'e rehe nde po emujar — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Heta ame'ẽ ta ngi Jesu sawa'e ke hykýi raho. A'eta jõ ixo. Pe, sawa'e pyakwar rupi ipo ke pu'ẽ. Ipo rehe tymũ tĩ, ame'ẽ namõ sawa'e rembe rehe mujar. ");
INSERT INTO urbNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pe, ywa rehe Jesu ma'ã. He'õha mupuk. (Aja pyrara usak ehe, aja mujekwa.) Pe, pandu: “Epata” aja Jesu. Ame'ẽ jundéu awa ta je'ẽha ipe: “Epirar” aja. ");
INSERT INTO urbNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Pahar sawa'e pyakwar sorok katu. Hendu katu ma'e ke. Hembe imembek katu tĩ. Pandu katu ma'e ke apo 'y. ");
INSERT INTO urbNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pe, hãtã Jesu pandu ipe: —Amukatuha rehe har amõ ta pe pepandu ym — aja ngã pe tipe. Anĩ. Pandu pandu hũ ngã. Amõ we Jesu pandu tipe: —Pepandu ym — aja. Anĩ tĩ. Pandu pandu we hũ ngã. ");
INSERT INTO urbNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hendu ame'ẽ ta pandu: —Mã! Katu tiki. Upa katu te ma'ema'e katu tiki. Mã! Ipyakwar ym ame'ẽ ke mukatu! Pe, hendu katu apo 'y. Je'engai ame'ẽ ke mukatu tĩ. Pandu katu ma'e ke apo 'y — aja ngã jupe. ");
INSERT INTO urbNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ajame'ẽ ke amõ heta ngã jy'ar uwyr ehe tĩ. Ma'e ke ngã u'u ame'ẽ ke nixói te rahã, jumu'eha ta pe Jesu pandu: —Se pejur. ");
INSERT INTO urbNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Pesarahã! Peme'ẽ heta ame'ẽ ta ihẽ namõ ixo. Mahapyr ukwer apo. Ngã mi'u nixói te ngã pe. A'erehe ngã rehe apyrara ihẽ asak. ");
INSERT INTO urbNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Hok pe amujywyr amondo rahã, myahyha ixangwer ym. Amõ ta paite ngi uwyr — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jumu'eha ta pandu ipe: —Ko awa nixói te ame'ẽ pe jande jaxo. Myja heta ame'ẽ ta pe mbeju jame'ẽ ta my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—Myja hetaha mbeju namõ pexo my? — aja Jesu. —Kuja. Awa po wajar mokõi hetaha kohĩ — aja jumu'eha ta. ");
INSERT INTO urbNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Heta ame'ẽ ta pe Jesu pandu: —Pewapyk — aja. Pe, mbeju ke pyhyk. Tupã pe pandu: —Ne jõ riki katu te me'ẽ ke. Jande mi'u nde eremuwyr katu — aja. Pe, upa mbeju mopok rahã, jumu'eha ta pe me'ẽ. Pandu: —Ngã pe peme'ẽ me'ẽ peraho — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Pe, jumu'eha ta me'ẽ me'ẽ raho. Heta katu ym pira ka'ẽ ke pehĩ tĩ. Ame'ẽ rehe Tupã pe Jesu pandu tĩ: —Ne jõ riki katu te me'ẽ ke. Jande mi'u nde eremuwyr katu — aja tĩ. Pe, jumu'eha ta pe pandu: —Kome'ẽ ngã pe peme'ẽ me'ẽ peraho tĩ — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Upa ngã u'u. Uhyk ngã u'u. Pe, pyta we ame'ẽ ke matyr. Kuja, awa po wajar mokõi wasãkã tyryhem matyr. ");
INSERT INTO urbNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Arahã heta ngã u'u. Kuja, 4.000 hetaha u'u. Ngã heta ame'ẽ ta pe Jesu pandu: —Pehẽ rok pe pejywyr peho — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Upa ngã oho rahã, pahar jarusu keruhũ pe opor oho, jumu'eha ta namõ. Ame'ẽ pe y ruwái rehe oho. Namanu ywy pe uhyk oho. ");
INSERT INTO urbNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Amõ parise ta uhyk ehe. (Parise ta ymanihar hamũi ta mu'e ame'ẽ ke rehe hendu katu te ame'ẽ ta ke a'eta.) Pe, Jesu namõ je'ẽ je'ẽ hũ. Parise ta pandu ipe: —Marã ka ym amõ ma'eha, ame'ẽ ke ema'ema'e. Jasak ta. Aja rahã, kome'ẽ ywy keruhũ pe nde ke Tupã muwyr, aja jakwa ta — aja Jesu pe. (Marã ka ym Jesu ma'eha rahã, Tupã muwyr ym, aja ukwa ta tipe. Ame'ẽ manga ta tipe.) ");
INSERT INTO urbNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","He'õha ke Jesu mupuk hũ. (Parise ta ãkã janam rãi aja ukwa, a'erehe he'õha mupuk.) Pe, pandu: —Anĩ. Ama'e ym ta. Mã! Marã ka ym amõ ma'eha, ame'ẽ ke ihẽ ama'ema'e. Ame'ẽ ke pesak tar katu. Ma'ewã my? Anĩ ta. A'ewan. Amujesak ym ta pehẽ pe — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Upa pandu rahã, ame'ẽ ta ke hijar oho. Pe, jarusu keruhũ pe opor oho. Huwái koty jywyr oho. ");
INSERT INTO urbNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jumu'eha ta mbeju ke harái. Raho ym riki. Mbeju peteĩ jõ jarusu keruhũ pe raho. ");
INSERT INTO urbNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Pe, jumu'eha ta ke Jesu mu'e. Kuja: —Pesak katu pexo. Mbeju mupururukiha ke pepyhyk ym, parise tama'e ke. Eroma'e ke aja tĩ. Pepyhyk ym tĩ — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ame'ẽ ke rehe hendu rahã, jumu'eha ta pandu pandu a'eta jupe: —Mbeju nixói, a'erehe aja a'e pandu — aja a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ame'ẽ panduha ke Jesu ukwa rahã, pandu: —Mbeju nixói. Ame'ẽ rehe har pepandu pandu ym ta me'ẽ te'e. Mã! Pekwa ym my rĩ. Pehẽ ãkã janam rãi. Pepyhyk ym ma'e ke. ");
INSERT INTO urbNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pehẽ reha pehĩ. Pesak ym ma'e. Pehẽ pyakwar pehĩ. Pehendu ym ma'e. Aja pexo. Ihẽ ama'ema'eha ke peharái my? ");
INSERT INTO urbNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Awa po wajar peteĩhar upa mbeju ke 5.000 hetaha ame'ẽ ta pe amopok rahã, myja mbeju pyta we ame'ẽ ke pematyr my? Myja wasãkã tyryhem pematyr my? — aja Jesu. A'eta pandu: —Awa py mokõi wasãkã tyryhem jamatyr — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Pe, awa po wajar mokõi mbeju ke 4.000 hetaha ame'ẽ ta pe amopok rahã, myja mbeju pyta we ame'ẽ ke pematyr my? Myja wasãkã tyryhem pematyr my? — aja Jesu. A'eta pandu: —Awa po wajar mokõi wasãkã tyryhem jamatyr — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Pe, Jesu pandu: —Mã! Pekwa apo my? — aja jumu'eha ta pe. (“Mbeju mupururukiha” Jesu pandu rahã: “Ame'ẽ riki parise ta mu'e ame'ẽ ke” aja mujekwa. Ame'ẽ ke rehe hendu ym ta me'ẽ te'e, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ajame'ẽ ke Mesái ok ta pe Jesu uhyk uwyr, jumu'eha ta namõ. Jesu rehe eha ym te ame'ẽ ke amõ ta muhyk werur. Amõ ta pandu: —Nde po emujar ehe — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Pe, eha ym te ame'ẽ po Jesu pyhyk. Pe, hykýi raho. Ame'ẽ ok ta ngi a'eta jõ uhem oho. Pe, eha rehe tymũ. Ipo ke mujar tĩ, eha rehe. Pandu ipe: —Eresak ma'e ke apo 'y — aja sawa'e pe. ");
INSERT INTO urbNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Eha ym te ame'ẽ ke ma'ã. Pandu: —Asak katu ym. Awa ta ke rehe asak. Myra aja ihẽ asak. Wata ixo — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Pe, eha rehe ipo ke Jesu mujar we tĩ. Pe, sawa'e ma'ã katu. Eha katu oho 'y. Upa katu te ma'e ke rehe usak katu apo 'y. ");
INSERT INTO urbNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pe, hok pe sawa'e ke mujywyr mondo. Pandu ipe: —Mesái ok ta pe ejywyr ym eho — aja sawa'e pe. (Ame'ẽ ok ta pe ehe har ngã pandu pandu, ame'ẽ ke Jesu putar ym. A'erehe sawa'e pe pandu: “Ejywyr ym eho” aja.) ");
INSERT INTO urbNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ajame'ẽ ke amõ renda pe Jesu oho, jumu'eha ta namõ. Sesaréi Siri ok ta rake ihĩ, ame'ẽ pe oho. Oho ixo rahã, jumu'eha ta pe Jesu pandu: —Ihẽ rehe har amõ ta pandu rahã, myja pandu my? — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","A'eta pandu: —Kuja amõ ta: “Juã mujahukiha ke nde” aja je. Amõ ta: “Eri ke nde. Ymanihar Tupã je'ẽha pandu ame'ẽ ke nde” aja je. Amõ ta: “Amõ ymanihar Tupã je'ẽha pandu ame'ẽ ke nde” aja ngã je — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Pehẽ rahã! Myja pekwa my? — aja Jesu. Petu pandu: —Kirisutu nde. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke nde — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","—A'e tỹ. Ihẽ rehe har amõ ta pe pemujekwa ym — aja hãtã jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Arahã har ngi jumu'eha ta ke Jesu mu'e: —Ko awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ ke amõ ta mupyrara ta. Jundéu awa tamũi ta putar ym te ta ihẽ ke. Jundéu awa tama'e pa'ihu ta aja tĩ. Putar ym ta ihẽ ke tĩ. Moise je'ẽha mu'e ame'ẽ ta aja tĩ. Putar ym ta ihẽ ke tĩ. Ihẽ ke jukwa ta. Pe, mokõi aker rahã, ihẽ akwera katu ta ahem — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Aja Jesu mujekwa katu juehe har. Pe, jumu'eha ta ngi Petu Jesu ke hykýi raho. Pandu ipe: —Anĩ. Sawa'e! Nde ke jukwa ym ta awa — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pe, Jesu uwak, pe, amõ jumu'eha ta rehe usak. Pe, Petu pe pandu: —Nde riki Satana aja saka. (Ãjã ramũi a'e.) Ihẽ ruwajan aja nde tĩ. Eho ihẽ ngi. Nde erekwa erekwa e'am, ame'ẽ ke Tupã muwyr ym riki. Sawa'e ukwaha namõ nde erepandu. A'erehe ihẽ ke nde eremupyta tar katu naĩ. Katu ym aja — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pe, heta hũ ngã ke Jesu mujy'ar, jumu'eha ta namõ. Pandu ngã pe: —Ihẽ namõ amõ ixo tar katu rahã, ima'e putariha ke hijar ta me'ẽ te'e. Pe, Tupã putar ame'ẽ ke ma'ema'e ta me'ẽ te'e. Ima'e putariha ke mukanim ta me'ẽ te'e tĩ. Pe, ihẽ namõ oho katu. ");
INSERT INTO urbNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Amõ manõ tar ym. A'erehe a'e pandu: “Anĩ. Jesu rehe ajurujar ym ihẽ” aja. Aja rahã, Tupã namõ ixo ym te ta. Ihẽ rehe amõ jurujar katu, a'erehe a'e ke amõ jukwa tar katu. Tupã je'ẽha ke pandu oho, a'erehe ame'ẽ ke amõ jukwa tar katu tĩ. Tapijar te'e we jurujar katu, a'erehe amõ jukwa. Manõ. Aja rahã, Tupã namõ aja te'e ta ixo. ");
INSERT INTO urbNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Upa katu te kome'ẽ ywy keruhũ pe ma'e katu ame'ẽ ke ihĩ. Ame'ẽ ke amõ jo'ok. Matyr hũ tĩ. Pe, manõ rahã, Tupã namõ ixo ym te. Aja rahã, marã ka ym katuha. ");
INSERT INTO urbNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Uhãha rehe marã ka ym ma'e ke muhepyha. Nixói te ma'e. ");
INSERT INTO urbNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ma'e ka'u te'eha ke ma'ema'e aja ngã ixo apo. Tupã nixói, aja ukwaha naĩ, aja ngã ixo apo tĩ. Ame'ẽ ta ruwa koty ihẽ ngi amõ huxĩ rahã, ihẽ ruxĩ ta ingi tĩ. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ amu'e ame'ẽ ke ngi amõ huxĩ rahã, ame'ẽ sawa'e ngi ihẽ ruxĩ ta tĩ. Ihẽ ajywyr rahã, ihẽ ruxĩ ta ingi. Katu te ha rupi ihẽ ajywyr ta. Papama'e katu te ha rupi ajywyr ta tĩ. Ima'e je'ẽha rahoha tama'e katu te ha rupi ajywyr ta tĩ. Arahã ihẽ ngi huxĩ ame'ẽ ta ngi ihẽ ruxĩ ta tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","A'e pandu tĩ: —Jetehar te ke pehẽ pe apandu. Ko riki amõ ta ixo apo. Ame'ẽ ta manõ ym we ta rĩ. Pyrãtã te ha namõ ihẽ riki kapitã keruhũ, ame'ẽ rehe usak py ta. Manõ ym we ta rĩ — aja jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Awa po wajar peteĩ ukwer rahã, Jesu oho. Petu ke raho inamõ. Tian amõ tĩ. Juã amõ tĩ. Ame'ẽ tumeme jõ a'eta oho. Ywy'ã keruhũ rehe jupir oho. Pe, Jesu rehe Petu ta usak u'am rahã, amõ koty a'e uwak oho u'am. ");
INSERT INTO urbNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ima'e mundeha hendy hendy. Ituwyr te. Kome'ẽ ywy keruhũ pe ame'ẽ tuwyriha ke rehe uhyk ym. ");
INSERT INTO urbNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pe, Eri rehe Petu ta usak. Moise rehe usak tĩ. (Ame'ẽ mokõi ymanihar Tupã je'ẽha pandu ame'ẽ ta ke a'eta.) Jesu namõ mokõi sawa'e ta pandu pandu u'am. ");
INSERT INTO urbNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pe, Jesu pe Petu pandu: —Sawa'e! Ko riki katu jande jaxo. Mahapyr xipa jamujã ta. Ko nde pe peteĩ. Amõ Moise pe tĩ. Amõ Eri pe tĩ. (Aja rahã pepyta we ta rĩ) — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petu ta mukahem hũ ingi, a'erehe myja pandu rahã, katu my? Ukwa ym, a'erehe aja pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pe, a'eta rehe ywa takãxĩha uhyk. Ame'ẽ pytuniha te'e Petu ta i'ãi. Pe, takãxĩha ngi panduha uwyr: —Peme'ẽ ihẽ ra'yr. Ihẽ apy'a katu ehe ame'ẽ ke a'e. A'e pandu ame'ẽ ke rehe pehendu katu — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pe, pahar Petu ta juramã usak. Nixói awa. Jesu jõ pete'e ixo. ");
INSERT INTO urbNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pe, ywy'ã keruhũ 'ar ngi wyjy uwyr ixo rahã, hãtã Jesu pandu: —A'eramõ pesak ame'ẽ ke amõ ta pe pepandu ym we rĩ. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ ke amõ ta jukwa ta. Pe, ihẽ akwera katu ta ahem. Arahã jõ pesak ramõ ame'ẽ ke pepandu katu ngã pe — aja Petu ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Petu ta hendu katu ehe, a'erehe amõ ta pe pandu ym. Petu ta jupe: —“Akwera katu ta” aja a'e. Ma'e ame'ẽ my? — aja a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Pe, Jesu pe a'eta pandu: —Moise je'ẽha mu'e ame'ẽ ta kuja pandu: “Eri uwyr py ta. Haikwer koty Kirisutu uwyr ta” aja pandu. Ma'erehe aja pandu my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesu mujekwa: —Ame'ẽ panduha jetehar te ke. Eri uwyr py ta. Ngã py'a ke mukatu ta uwyr, aja rahã Kirisutu uwyriha rehe ngã harõ katu ta. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Pesarahã! Ihẽ ke amõ ta mupyrara ta, aja Tupã je'ẽha rehe panduha ihĩ. Ihẽ ke amõ ta putar ym ta, aja Tupã je'ẽha rehe panduha ihĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ko pehẽ pe apandu katu. Amõ riki upa uwyr. Eri aja a'e tĩ. Amõ ta putar, aja a'e ke amõ ta mupyrara riki. Yman Tupã je'ẽha mujekwa ehe har, aja amõ ta muhyk ehe — aja Jesu pandu. (Eri te rehe har pandu ym. Anĩ. Eri rehe har Jesu pandu rahã, Juã mujahukiha rehe har pandu. Eri aja Juã tĩ, aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","A'engi amõ jumu'eha ta rehe a'eta uhyk rahã, heta hũ ngã rehe usak. Ngã heta ame'ẽ ta pyter pe jumu'eha ta ixo. Moise je'ẽha mu'e ame'ẽ ta namõ je'ẽ je'ẽ hũ u'am. ");
INSERT INTO urbNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesu rehe heta ame'ẽ ta usak rahã, pandu: —Mã! Pewe tur! — aja ngã. Pe, huryha namõ ixoty ujan oho. Pe, ipo pyhyk pyhyk ingi. —Mã! Ko nde erejur — aja ngã pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesu pandu: —Ma'e ke rehe peje'ẽ je'ẽ hũ pexo my? — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Amõ pandu ipe: —Sawa'e! Ihẽ ra'yr py'a rehe ãjã ihĩ, a'erehe je'engai. Ãjã ihĩ katu rahã, ihẽ ra'yr ke ombor mungwa. Tyjúi hũ tái. Hãi hãtã su'u su'u riki. Pe, upa jupyrãtã rãtã oho. Nde pe arur ta tipe. Nde nixói. A'erehe nema'e jumu'eha ta pe apandu: “Ãjã ke pemuhem pemondo ingi” aja tipe. A'eta manga tipe. Anĩ riki. Muhem ym mondo — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","—Mã! Tupãma'e pyrãtãha rehe pejurujar ym. Heta hũ jahy rahã, pehẽ namõ ihẽ axo riki. Mã! Ihẽ rehe pejurujar ym we rĩ. Pehẽ ke ihẽ amu'e hũ tipe. Anĩ. Ihẽ rehe pejurujar ym we rĩ. Katu ym aja! Ere! Kurumĩ ke ihẽ pe erur — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Pe, amõ ta werur ipe. Jesu rehe ãjã usak rahã, pahar kurumĩ ke mumanõ manõ. Kurumĩ ywy rehe u'ar ukwap. Pe, jere jere oup. Tyjúi hũ tái. ");
INSERT INTO urbNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kurumĩ pái pe Jesu pandu: —Myja jahy rahã ãjã ihĩ ehe my? — aja. —Ta'yn rahã har aja te'e. ");
INSERT INTO urbNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mãte hũ jukwa ta tipe. Tata pe kurumĩ ke ityk, aja jukwa ta tipe. Pe, pu'am. Y pe pypyk tĩ. Pe, uhem. Jukwa ta tipe. A'erehe nde eremukatu tar katu rahã, jande rehe epyrara esak. Emukatu katu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—Hã! Nde tĩ. Tupã rehe nde erejurujar katu rahã, upa katu te ma'e ke nde erema'e katu ta — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Pahar kurumĩ pái jixi'uha namõ pandu: —Ajurujar katu we riki ihẽ. A'ewan ym rĩ. A'erehe ihẽ pe emujekwa katu, aja rahã, ajurujar katu te ta tĩ — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Heta ngã ujan uwyr. Juramã uwyr. Ima'e ma'eha ke mupyta ta, aja ukwa. A'erehe hãtã ãjã pe pandu: —Ãjã! Nde pe ihẽ apandu. Ehem eho ingi. Kurumĩ ke emupyakwar ym te apo. Emuje'engai ym tĩ. Eho ingi. Ejywyr ym te ehe kỹ — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ãjã riki ahem hũ. Pe, kurumĩ ke mumanõ manõ. Pe, uhem oho ingi. Pete'e kurumĩ túi. Manõ me'ẽ aja túi, a'erehe ngã pandu: —Manõ apo 'y — aja ukwaha naĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ipo rehe Jesu pyhyk. Pe, mupu'am. Pu'am katu kurumĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ajame'ẽ ke amõ rok pe Jesu ixe oho. A'ep jumu'eha ta pandu ipe: —Mã! Marã ka ym ãjã ke jamuhemiha. Ma'erehe my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Aja me'ẽ ãjã ke kuja jõ muhem mondo. Tupã namõ pepandu pandu katu. Ma'e pe'uha ke pehijar tĩ. (Aja Tupã rehe pehẽ py'a pemoĩ moĩ katu.) Aja rahã jõ, aja me'ẽ ãjã ke pemuhem katu pemondo. (Pyrãtã te ame'ẽ ke a'e, a'erehe aja rahã jõ pemuhem katu pemondo) — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","A'engi oho tĩ. Ngariréi ywy ke asa oho. Jumu'eha ta ke Jesu mu'e tar katu u'am, a'erehe ohoha ke ngã ukwa, ame'ẽ ke putar ym. Jumu'eha ta pe jõ pandu: —Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ rehe sawa'e ta ke amõ muhyk ta werur. Pe, ihẽ ke ame'ẽ sawa'e ta jukwa ta. Mokõi aker rahã, akwera katu ta ahem tĩ — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","“Kwera ta” ame'ẽ je'ẽha ke jumu'eha ta ukwa ym. —Emujekwa jande pe — aja pandu tar ym. Kyje ingi, a'erehe pandu ym we ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kapana'ũ ok ta pe uhyk uwyr. Amõ rok pe ixe oho. A'ep jumu'eha ta pe Jesu pandu: —Pe rupi jande jajur jaxo rahã, peje'ẽ je'ẽ pexo pehẽ jupe. Ma'erehe peje'ẽ je'ẽ my? — aja pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","A'eta pandu tar ym Jesu pe. Wata ixo rahã, kuja jumu'eha ta pandu pandu a'eta jupe: —Jande ngi har awa riki katu te ame'ẽ ke my? — aja riki. A'erehe ame'ẽ ke pandu tar ym Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","A'e wapyk. Awa py mokõi jumu'eha ta ke mujy'ar. Pandu: —Pejur se! Pesarahã! “Apo ihẽ py kỹ” aja amõ putar katu rahã, a'ejõhar aja ixo ta me'ẽ te'e. Pe, upa amõ tama'e miasu aja ixo ta me'ẽ te'e tĩ. Aja rahã, katu te ame'ẽ ke a'e aja ixo — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Pe, ta'yn ke Jesu pyhyk raho. Jumu'eha ta pyter pe raho. Peteĩ ijywa jurupy rupi pyhyk. Pe, jumu'eha ta pe pandu: ");
INSERT INTO urbNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Kome'ẽja ta'yn ke hok pe mupyta katu. Ihẽ kotyhar ke, a'erehe pandu ipe: “Ko nde erejur katu. Ihẽ rok pe epyta katu” aja. Aja rahã, ihẽ ke hok pe mupyta katu, aja tĩ. Amõ we tĩ. Ihẽ pái ke hok pe mupyta, aja tĩ. Ihẽ ke ihẽ pái muwyr — aja Jesu mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Amõ rahã, Juã pandu ipe: —Sawa'e! Paite amõ sawa'e rehe jasak. Nde je'ẽha rupi ãjã ta ke a'e muhem katu mondo. Jande namõ ixo ym, a'erehe japandu ipe: “Anĩ. Mã peja ym. Jesu je'ẽha rupi ãjã ta ke emuhem ym emondo” aja ipe — aja Jesu pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","—Anĩ. Aja pepandu ym sawa'e pe. Ihẽ je'ẽha rupi ma'e katu ame'ẽ ke amõ ma'e rahã, ihẽ namõ ma'ema'e katu tĩ. Aja rahã, pahar ihẽ ruwajan wan uwak ym ta. ");
INSERT INTO urbNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Jande namõ jumai ym rahã, jande kotyhar ta ke aja ixo. ");
INSERT INTO urbNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pesarahã! Kirisutu ihẽ. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke ihẽ. Ihẽ kotyhar ta ke pehẽ. A'erehe y ke pehẽ pe amõ me'ẽ, ita rekúi ra'yr pe. Aja rahã, ame'ẽ rehe Tupã usak katu ta tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","A'e pandu tĩ: —Ihẽ rehe amõ amõ ta'yn ta jurujar katu. Pe, amõ pandu: “Mã peja Jesu rehe nde erejurujar katuha ke ehijar” aja mu'e. A'erehe ta'yn hijar. Aja rahã, mã peja jurupy rupi itahu pukwar. Pe, itahu namõ a'e ke ypa pe ombor. (Pe, y jukwa. Aja rahã, ta'yn ke mu'e ym ta.) ");
INSERT INTO urbNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nde po pe amõ amõ ma'e ke nde erema'e, a'erehe ma'e nde ereka'u te'eha ke nde erema'e. A'erehe ihẽ rehe nde erejurujar katuha ke nde erehijar. Aja rahã, ame'ẽ nde erema'eha ke ema'e ym. Nde erema'e ym rahã, nde po ke nde eremondok, ame'ẽja saka. Ema'e ym. Nde po peteĩ nixói, aja Tupã koty nde ereho ta rahã, katu tiki. Nde po mokõi namõ nde erexo aja mupyraraha renda pe nde ereho ta rahã, katu ym tiki. Ame'ẽ renda pe tata uwe ym te. ");
INSERT INTO urbNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ame'ẽ renda pe tapuru manõ ym te ta. Tata uwe ym te ta tĩ. (Aja rahã, ahyha upa ym te ta, aja mujekwa katu.)  ");
INSERT INTO urbNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","—Nde py aja tĩ. Amõ amõ ma'e renda pe nde erewata ereho, a'erehe ma'e nde ereka'u te'eha ke nde erema'e. A'erehe ihẽ rehe nde erejurujar katuha ke nde erehijar. Aja rahã, eho ym. Nde ereho ym rahã, nde py nde eremondok, ame'ẽja saka. Eho ym. Nde py peteĩ nixói, aja Tupã renda pe nde ereho ta rahã, katu tiki. Nde py mokõi namõ nde erexo aja mupyraraha renda pe nde ereho ta rahã, katu ym te tiki. ");
INSERT INTO urbNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ame'ẽ renda pe tapuru manõ ym te ta. Tata uwe ym te ta tĩ. (Aja rahã, ahyha upa ym te ta, aja mujekwa katu.)  ");
INSERT INTO urbNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","—Nde reha aja tĩ. Amõ amõ ma'e ke rehe nde eresak, a'erehe ma'e nde ereka'u te'eha ke nde erema'e. A'erehe ihẽ rehe nde erejurujar katuha ke nde erehijar. Aja rahã, mã peja ma'e ke rehe esak ym. Nde eresak ym rahã, nde reha nde erejo'ok, ame'ẽja saka. Esak ym. Nde reha peteĩ nixói, aja Tupã renda pe nde ereho ta rahã, katu tiki. Nde reha mokõi namõ nde erexo aja mupyraraha renda pe nde ereho ta rahã, katu ym te tiki. ");
INSERT INTO urbNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ame'ẽ renda pe tapuru manõ ym te ta. Tata uwe ym te ta tĩ. (Aja rahã, ahyha upa ym te ta aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","—(Jundéu awa ta Tupã rehe ipy'a moĩ moĩ rahã, hymba hapy. Upa ukwái. Arahã jukyr ke ombor ehe.) Ame'ẽ jukyr aja johu ngã rehe tata ke Tupã ombor ta, ame'ẽja saka. (Aja rahã, johu ngã ahyha manga ta. Tata ombor, ame'ẽja saka. Aja ipy'a katuha ke Tupã manga ta.) ");
INSERT INTO urbNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Jukyr namõ ma'e ke katu. Jukyr he'ẽha kanim rahã, marã ka ym mujywyriha. Pehẽ aja tĩ. Jukyr katu, aja pexo. Aja rahã, pexoha katu aja pexo katu. Amõ ta namõ pejumai ym aja pexo katu — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","A'engi Jesu oho, jumu'eha ta namõ. Jundéi ywy ke asa oho. Y ruwái koty oho. Y rer Jondã. Heta ngã jy'ar uwyr ehe tĩ. Jesu mu'e uĩ tĩ. Amukwehe mu'e, aja mu'e apo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pe, parise ta uhyk uwyr ehe. Jesu ukwa katuha ke manga tipe, a'erehe pandu ipe: —Hakehar ke awa hijar katu my? Myja me'ẽ jundéu awa ta je'ẽha mujekwa my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—Yman ame'ẽ rehe har Moise mupinim. Myja mupinim my? — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—Kuja mupinim. Hakehar ke amõ hijar oho rahã, kuja je'ẽha paper rehe mupinim. “Nde ihẽ rakehar ym apo 'y” aja. Pe, ipái ta koty hakehar ke mujywyr mondo, paper namõ, aja panduha mupinim — aja parise ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesu pandu: —Aja riki yman Moise mupinim. Pehẽ ãkã janam rãi. Tupã putar ame'ẽ ke pema'e tar ym, a'erehe aja yman Moise mupinim. ");
INSERT INTO urbNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yman ma'e ke Tupã mujã py rahã, sawa'e ke mujã. A'engi kũjã ke mujã tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","A'erehe sawa'e jumendar rahã, ipái ta ke hijar. Pe, hakehar namõ ixo katu. ");
INSERT INTO urbNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ame'ẽ mokõihar riki peteĩhar aja ixo. A'erehe ame'ẽ ta riki mokõihar aja ym saka. ");
INSERT INTO urbNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","A'erehe peteĩhar aja Tupã mujã rahã, ame'ẽ ke sawa'e mumokõi rahã, katu ym — aja parise ta pe Jesu pandu. (“Mumokõi” aja pandu rahã: “Hakehar ke ixawa'e hijar” aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ok wyr pe jywyr oho rahã, jumu'eha ta pandu: —Ame'ẽ je'ẽha rehe har emujekwa — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","—Hakehar ke ixawa'e hijar oho, pe, amõ kũjã pyhyk rahã, hakehar aja ym ame'ẽ namõ jumusarái aja riki. Katu ym aja. ");
INSERT INTO urbNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kũjã aja tĩ. Ixawa'e ke kũjã hijar oho, pe, amõ sawa'e ke pyhyk rahã, ixawa'e aja ym ame'ẽ namõ jumusarái tĩ, aja tĩ. Katu ym tĩ — aja Jesu pandu. (Aja rahã, hakehar ke ixawa'e hijar rahã, katu ym. Ixawa'e ke hakehar hijar rahã, katu ym tĩ, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jesu pe ta'yn ta ke ngã muhyk werur. Ta'yn ta ãkã rehe ipo Jesu mujar, ame'ẽ ke ngã putar. (Aja Tupã usak katu a'eta rehe aja mujekwa. Anĩ. Ame'ẽ ke jumu'eha ta putar ym) a'erehe a'eta pandu: —Mã! Jesu ma'ema'e ixo. A'erehe perur ym ipe — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ame'ẽ ke rehe Jesu hendu rahã, jumu'eha ta pe pandu: —Anĩ. Mã peja ta'yn ta ihẽ rehe uhyk katu. Ta'yn ta ke se pemuhyk perur. Pemupyta ym. Aja riki Tupã putar tĩ. Kome'ẽ ta'yn ta Tupã kotyhar wan ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ko apandu katu. Tupã kotyhar ta aja ta'yn ta putar katu. Ta'yn ta aja amõ putar ym rahã, Tupã kotyhar aja ym te ta awa — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pe, i'u 'ar pe ta'yn ta ke Jesu mapyk mapyk. Iãkã rehe ipo mujar, pe, pandu: —Nde rehe Tupã usak katu — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Pe, Jesu oho tate rahã, amõ sawa'e ujan uwyr ixoty. Huwa koty ipynarãi pe wapyk. (Aja sawa'e katu te ame'ẽ ke kohĩ, a'erehe hendu katu ehe aja mujekwa.) Pe, pandu: —Sawa'e! Katu te ame'ẽ ke nde. Ma'e ihẽ ama'ema'e rahã, Tupã ihẽ ke muhã katu ta my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","—“Katu te ame'ẽ ke nde” aja ihẽ pe nde erepandu. Tupã jõ riki katu te ame'ẽ ke a'e. Awa ke anĩ. Ihẽ Tupã aja nde erekwa my? ");
INSERT INTO urbNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Esarahã! Tupã je'ẽha ke nde erekwa katu. Kuja panduha ihĩ. “Amõ ke ejukwa ym. Amõ kũjã rehe eka'u te'e ym. Amõma'e ke emukanim ym. Amõ rehe har te'e epandu ym. Ma'e te'e nde erepandu, aja amõma'e ke emukanim ym. Nde pái rehe epy'a katu. Ne mãi rehe aja tĩ. Epy'a katu ehe tĩ” aja Tupã je'ẽha rehe panduha ihĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Sawa'e pandu: —Sawa'e! Aja kurumĩ rahã har upa Tupã je'ẽha rehe ihẽ ahendu katu — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu usak ehe. Ipy'a katu ehe. Pe, pandu ipe: —Pewe amõ ma'e ke ema'e we rĩ. Eho. Upa katu te nema'e ke emuhepy. Aja tamatarer epyhyk. Pe, upa ame'ẽ ke ima'e ym te ame'ẽ ta pe te'e eme'ẽ me'ẽ. Aja rahã, Tupã koty nema'ehũ ta. A'engi eho, ihẽ namõ ejur — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ame'ẽ je'ẽha ke rehe hendu rahã, sawa'e pyai te. Pe, hok pe jywyr oho ingi. Ima'ehũ aja ixo. (Ame'ẽ ke me'ẽ tar ym, a'erehe pyai te.) ");
INSERT INTO urbNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jumu'eha ta rehe Jesu juramã usak. Pandu: —Tupã putar, aja amõ ixo katu. Aja ima'ehũ ame'ẽ ta mã ma'e tar ym te — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ame'ẽ ke rehe hendu rahã, jumu'eha ta pandu: —Mã! Aja ym my? — aja pandu. Jesu pandu tĩ: —Sa'e ta! Tupã putar, aja amõ ixo katu. Aja mã ma'e tar ym te. ");
INSERT INTO urbNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Awi jupiha kwar rupi marã ka ym awa rymba asaha oho. Kame, ame'ẽ hymba asaha oho. Pe, ima'ehũ ame'ẽ ke Tupã putar, aja ixo tar katu rahã, i'ar koty te we marã ka ym ma'eha — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jumu'eha ta mukahem te. Pandu: —Mã! Aja rahã, awa ke Tupã muhã ta my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","A'eta rehe Jesu usak katu. Pe, pandu: —Ame'ẽ ke sawa'e ta marã ka ym ma'eha. Tupã anĩ. Upa katu te a'e ma'e katu. Awa ke a'e riki muhã katu ta — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petu pandu: —Esarahã! Sawa'e pe nde erepandu, aja upa katu te jandema'e ke jahijar jajur. Pe, nde namõ jande jaxo 'y — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","—Hã! Apandu katu pehẽ pe. Ihẽ rehe amõ ipy'a katu, a'erehe upa ima'e ke hijar oho. Aja rahã, ame'ẽ pe ma'e ke Tupã mujywyr hũ ta. Tupã je'ẽha ke amõ pandu oho, a'erehe upa ima'e ke hijar oho. Aja rahã, ame'ẽ pe ma'e ke Tupã mujywyr hũ ta tĩ. Ko hok ke amõ hijar oho. Imu ta ke hijar tĩ. Ianam ta ke hijar tĩ. Imãi ta ke hijar tĩ. Ta'yn ta ke hijar tĩ. Kupixa ke hijar tĩ. Pe, kome'ẽ ywy keruhũ pe ame'ẽ ixo rahã, Tupã mujywyr hũ ta ipe. Ko heta ok ke mujywyr ta. Heta imu ta ke mujywyr ta tĩ. Heta ianam ta ke mujywyr ta tĩ. Heta imãi ta ke mujywyr ta tĩ. Heta ta'yn ta ke mujywyr ta tĩ. Heta hekoha ke mujywyr ta tĩ. Amõ we tĩ. Ame'ẽ ta ke amõ ta mupyrara ta tĩ. Puka puka hũ ta ehe tĩ. Pe, 'ar ke upa rahã, Tupã namõ ixo katu ta. Uhã te hũ aja ixo ta. ");
INSERT INTO urbNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ixoty uhyk rahã, upa katu te uhyk ame'ẽ ta rehe juja katu te Tupã me'ẽ me'ẽ ta. Tupã kotyhar ta aja muruwak py, ame'ẽ ta rehe Tupã usak katu ta. Tupã kotyhar ta aja a'ejõhar muruwak, ame'ẽ ta rehe juja katu te a'e usak katu ta tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","33","Pe, Jerusarẽ ok ta pe Jesu oho ixo, pe rupi. Jumu'eha ta oho ixo inamõ tĩ. Hundutar Jesu oho ixo. Amõ ta jumukahem. Jumu'eha ta aja tĩ. (Mãte we uhyk ta, aja ukwa, a'erehe kyje riki.) Pandu pandu a'eta jupe: —Mã! Jerusarẽ ok ta pe oho ixo! Ohoha ngi kyje ym a'e — aja. Pe, awa py mokõi jumu'eha ta jõ Jesu raho we tĩ. Kuja pandu ixo: —Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Pesarahã! Jerusarẽ ok ta pe jande jaho jaxo. Jundéu awa tama'e pa'ihu ta pe ihẽ ke amõ raho ta. Moise je'ẽha mu'e ame'ẽ ta pe aja tĩ. Ihẽ ke raho ta tĩ. Upa ame'ẽ ta ihẽ ke pyhyk ta. Pe, kuja pandu ta: “Nde katu ym. Nde eremanõ ta me'ẽ te'e” aja ta. Pe, jundéu awa aja ym ame'ẽ ta pe ihẽ ke ame'ẽ ta raho ta. ");
INSERT INTO urbNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pe, jundéu awa aja ym ame'ẽ ta puka puka hũ ta ihẽ rehe. Ahem hũ ta tĩ. Tymũ ta ihẽ rehe tĩ. Hãtã pirok katu te ta ihẽ ke. Pe, ihẽ ke jukwa ta. Mokõi aker rahã, akwera katu ta ahem tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Pe, Tian uhyk uwyr ehe, imu namõ, Juã namõ. Semende ra'yr ta a'eta. Jesu pe pandu: —Sawa'e! Ma'e ke nde pe japandu. Ame'ẽ ke jande pe nde erema'e, aja japutar — aja Tian ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesu pandu: —Ma'e peputar my? — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Nde riki kapitã keruhũ te rahã, ame'ẽ renda katu te hũ ta riki. Arahã kuja japutar. Nde rake jande mokõi riki jawapyk tar katu. Nde jywa katu koty peteĩ. Ko nde jywa'i koty amõ tĩ — aja Tian ta. ");
INSERT INTO urbNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesu pandu: —Mã. Pekwa ym pepanduha ke. Amõ ta ihẽ ke mahy hũ ta. Amõ ta ihẽ ke jukwa ta. Ihẽ aja pehẽ ke rahã, ihẽ rake pewapyk tar katu rĩ? — aja Tian ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—A'e tỹ! — aja ipe. Pe, Jesu pandu: —A'e riki. Ihẽ rehe pejurujar katu, a'erehe pehẽ ke amõ ta mahy hũ ta. Pehẽ ke amõ ta jukwa ta tĩ. Ihẽ aja pehẽ ke tĩ. Pepyrara ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ihẽ rake amõ wapyk, ame'ẽ apandu ym ta. “Se ihẽ jywa katu koty ewapyk. Se ihẽ jywa'i koty ewapyk” aja ihẽ apandu ym ta. Ame'ẽ ke ihẽ pái jõ riki pandu katu. Ame'ẽ renda ke a'e riki mukatu. Pe, a'e riki pandu katu ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ame'ẽ je'ẽha rehe amõ jande popa jumu'eha ta hendu rahã, Tian ta rehe parahy. (Imu ta rehe jyty'ym, a'erehe parahy.) ");
INSERT INTO urbNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pe, upa jumu'eha ta ke Jesu mujy'ar. Pandu: —Se pejur. Kuja pekwa katu. Jundéu awa aja ym ame'ẽ tama'e kapitã keruhũ ta mondo mondo hũ ngã ke. Ima'e je'ẽha rupi kapitã ta mondo mondo hũ ngã ke tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pehẽ anĩ. Aja kapitã ta aja pexo rahã, katu ym. (Amõ ta ke pemondo mondo rahã, katu ym.) Amõ riki kapitã keruhũ, aja ixo tar katu rahã, amõ ta namõ ma'ema'e katu ixo. Paraky te'e aja ixo. Aja rahã, katu tiki. ");
INSERT INTO urbNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pe, pehẽ ngi har peteĩ riki amõ ta 'ar koty te we katuha aja ixo tar katu rahã, a'e riki pehẽ rehe paraky te'e aja mã peja ixo. Aja rahã, katu tiki. ");
INSERT INTO urbNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","A'e riki ihẽ aja ta tĩ. Pesarahã! Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ namõ ma'e ke amõ ma'ema'e, a'erehe ihẽ ajur my? Anĩ. Aja ym. Amõ ta namõ ihẽ ama'ema'e. A'erehe ko ihẽ ajur. Ihẽ amanõ ta, a'erehe ngã ma'e ka'u te'eha ma'ema'eha ke rehe ihẽ amuhepy ta. A'erehe heta ngã ke Tupã muhã katu ta — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Pe, Jeriko ok ta pe a'eta uhyk uwyr. Pe, asa oho. A'engi Jesu uhem oho. Jumu'eha ta uhem oho inamõ tĩ. Heta ngã uhem oho inamõ tĩ. Pe rake amõ sawa'e wapyk uĩ. Her Matime. Time ra'yr a'e. Eha ym te ame'ẽ ke Matime, a'erehe tamatarer ke ngã pe pandu pandu uĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pe, amõ ta pandu: —Jesu petur ixo. Nasare ok ta pe har a'e — aja ngã. Ame'ẽ ke rehe hendu rahã, Matime pukái hũ uĩ: —Jesu! Nde riki Ndawi rainõ ke. Epyrara esak ihẽ rehe — aja riki. (“Ndawi rainõ” aja pandu rahã: “Kapitã keruhũ” aja Tupã mu'am ame'ẽ ke a'e aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Amõ ta hãtã je'ẽ ipe: —Epukái ym — aja. Anĩ. Matime pukái we hũ: —Sawa'e! Ndawi rainõ ke nde! Epyrara esak ihẽ rehe — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesu pyta hendu. Pandu: —Ihẽ pe emuwyr — aja ngã pe. Pe, Matime pe amõ ta pukái oho: —Katu! Epu'am! “Ejur” aja nde pe Jesu pandu. Epu'am. Eho — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Pe, jupukeka ke ombor. Pahar pu'am. Pe, Jesu rehe uhyk. ");
INSERT INTO urbNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesu pandu ipe: —Ma'e nde ereputar ihẽ ngi my? — aja. Eha ym te ame'ẽ ke pandu: —Sawa'e! Ihẽ reha ym te. Ihẽ reha emukatu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—Hã! Upa ma'e ahyha ke ihẽ amukatu, ame'ẽ ke rehe nde erejurujar katu, a'erehe nde reha katu apo 'y. Eho katu — aja Jesu ipe. Pe, pahar eha opok. Upa ma'e ke rehe usak katu 'y. Pe, pe rupi Jesu namõ oho. ");
INSERT INTO urbNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ajame'ẽ ke Jerusarẽ ok ta pe uhyk tate rahã, Mbetaje ok ta pe uhyk py oho. Ame'ẽ rake Mbeta ok ta ihĩ tĩ. Ame'ẽ ok ta ywy'ã rake ihĩ. Ywy'ã rer Oriwéi ty. Ame'ẽ ywy'ã rehe uhyk rahã, hundutar koty mokõi jumu'eha ta ke Jesu mondo. ");
INSERT INTO urbNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Kuja pandu: —Pesarahã! Jande ndutar koty amõ ok ta ihĩ, Mbeta ok ta ke. A'ep pehẽ mokõi peho. Pehyk rahã, jumen rehe pesak ta. Myra jytyka ame'ẽ rehe amõ pukwar. Ame'ẽ jumen 'ar pe amõ oho ym rĩ. Pejirar, pe, se ihẽ pe pemuhyk perur. ");
INSERT INTO urbNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","“Ma'erehe jumen pejirar my?” aja amõ pandu rahã, pepandu ipe: “Sawa'e riki putar apo. Pahar mujywyr ta nde pe” — aja mokõihar ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Pe, mokõihar ta oho. Jumen mahem. Awa rape rupi pu'am u'am. Hukwen rake amõ pukwar. Pe, iham jirar. ");
INSERT INTO urbNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","A'ep amõ ta i'ãi. Ame'ẽ ta ngi har amõ pandu: —Ma'erehe jumen pejirar my? — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesu panduha aja mokõihar ta pandu: —Sawa'e riki jumen putar apo. Pahar mujywyr ta nde pe — aja ipe. —Ererahã! — aja riki a'ep pe har pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jesu pe jumen raho. Uhyk rahã, jumu'eha tama'e kamixa ke jumen kupe 'ar pe a'eta moĩ. Ame'ẽ 'ar pe Jesu wapyk oho. ");
INSERT INTO urbNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Awa rape rupi kamixa ke heta ngã mou mou tĩ. Amõ ta myra rãkã mupen ame'ẽ ke mou mou tĩ. (Kapitã keruhũ jumai ym ha rupi ko tur aja ame'ẽ mujekwa katu.) Ame'ẽ 'ar rupi jumen pyrũ oho. ");
INSERT INTO urbNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Hundutar oho ame'ẽ ta pukái pukái oho ixo. Haikwer rupi oho ame'ẽ ta pukái pukái oho ixo tĩ. Kuja pukái: —Ko nde erejur katu! Ko riki sawa'e te je'ẽha rupi uwyr ame'ẽ ke. Mã! Katu te ame'ẽ ke a'e. Tupã riki katu te ame'ẽ ke a'e tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ymanihar Ndawi aja kapitã keruhũ nde tĩ. Aja nde ke Tupã mu'am ta. Mã peja Tupã usak katu nde rehe. Tupã riki katu te ame'ẽ ke a'e — aja ngã pukái pukái oho ixo. ");
INSERT INTO urbNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jerusarẽ ok ta pe Jesu uhyk oho. Tupã rehe ngã jumu'eha renda keruhũ pe ixe oho. Upa ma'e ke rehe juramã usak. Ka'aruk koty apo, a'erehe Jerusarẽ ok ta ngi uhem oho. Mbeta ok ta pe jywyr oho tĩ. Awa py mokõi jumu'eha ta oho inamõ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ame'ẽ ku'ẽ rahã, Mbeta ok ta ngi a'eta uhem oho. Oho ixo rahã, Jesu myahy. ");
INSERT INTO urbNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Paite ma'eywa'y rehe usak. Sik'y rehe usak. Ame'ẽ'y rehe ho heta tipe. Pe, i'a ke po'ok oho tipe. Pe, usak katu rahã, i'a nixói te. I'a angaha rehe uhyk ym we rĩ. Ho te'e jõ ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Pe, sik'y rehe har pandu: —Peme'ẽ myra ngi i'a ke po'ok ym te ta tĩ. U'u ym te ta awa — aja Jesu. Ame'ẽ je'ẽha rehe jumu'eha ta hendu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pe, Jerusarẽ ok ta pe a'eta jywyr oho tĩ. Tupã rehe ngã jumu'eha renda keruhũ pe Jesu ixe oho tĩ. Ma'e ke muhepy ame'ẽ ta ke muhem mondo ingi. Ma'e ke jo'ok ame'ẽ ta ke muhem mondo tĩ. Tamatarer muruwak ame'ẽ tama'e myrape ke mujere tĩ. (Ame'ẽja upa tamatarer ke muhãi ombor. Amõ ywy ngi amõ ta uwyr. Amõ koty tamatarer ke ame'ẽ ta werur. Ame'ẽ ke Jerusarẽ ok ta pe har tama'e tamatarer ke pe muruwak, ame'ẽ ta myrape ke Jesu mujere.) Pykahuran ke muhepy, ame'ẽ tama'e myrape ke mujere tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kuja pandu: —Koropi peraho ym pehẽma'e ke. Tupã rehe ngã jumu'eha renda keruhũ rupi peraho ym ma'e ke — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ngã ke mu'e rahã, kuja pandu: —Tupã je'ẽha rehe panduha ihĩ. Ame'ẽ ke pekwa katu. Kuja Tupã pandu: “Jumu'eha renda rehe har upa katu te ngã pandu ta: ‘Ko riki Tupã namõ pandu panduha renda ke’ aja riki.” Pehẽ anĩ. Ame'ẽ ke amõ koty pemuruwak. Ma'e ke mukanĩha renda aja pemuruwak riki. Katu ym aja — aja Jesu. (Muhepyha ta muhepy rahã, ka'u te'eha rupi muhepy, a'erehe mukanĩha aja ame'ẽ ta.) ");
INSERT INTO urbNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ame'ẽ ke rehe pa'ihu ta hendu. Moise je'ẽha mu'e ame'ẽ ta hendu tĩ. Ngã pandu ame'ẽ ke rehe a'eta hendu tĩ. Kuja ngã: —Mã! Jesu mu'e katu — aja riki pandu. Ame'ẽ ke rehe pa'ihu ta hendu tĩ. Jesu kotyhar aja ngã uwak ta, ame'ẽ ngi pa'ihu ta kyje, a'erehe kuja pandu pandu a'eta jupe: —Jesu ke jajukwa ta. Myja jajukwa ta my? — aja pandu pandu a'eta jupe. Aja pa'ihu ta pandu pandu a'eta jupe. Moise je'ẽha mu'e ame'ẽ ta namõ pandu pandu a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pytun ramõ rahã, Jerusarẽ ok ta ngi Jesu uhem oho, jumu'eha ta namõ. ");
INSERT INTO urbNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ame'ẽ ku'ẽ rahã, a'eta wata oho ixo. Ma'eywa'y rehe usak tĩ, sik'y ke rehe. Upa katu te xirik apo 'y. Ho ke xirik. I'y manõ tĩ. Hapo manõ tĩ. Upa katu te 'y. ");
INSERT INTO urbNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kwehe sik'y pe Jesu pandu, ame'ẽ ke Petu ukwa ukwa ixo. Pe, pandu ipe: —Sawa'e! Esarahã! Kwehe sik'y pe: “I'a ym te ta apo 'y” aja nde erepandu. Ame'ẽ ke upa katu te manõ apo 'y — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","A'e pandu: —Ko apandu katu pehẽ pe. Tupã rehe pejurujar katu rahã, peme'ẽ ywy'ã rehe pepandu katu: “Ere. Eho! Ejumbor eho y ramũi pe” aja. “Mã! Opor ta nahã my? Akwa ym” aja ym pepandu. Pejurujar katu ehe. Aja rahã, ame'ẽ ywy'ã opor ta oho. Pepanduha aja Tupã muhyk katu ta. ");
INSERT INTO urbNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","A'erehe apandu katu pehẽ pe. Tupã namõ ma'e ke pepandu pandu rahã: “Pehĩ apo 'y. Uhyk katu apo 'y” aja pejurujar katu rahã, upa katu te pehẽ pe Tupã muhyk katu ta — aja Jesu pandu. (“Ywy'ã keruhũ” aja Jesu pandu rahã: “Upa ma'e hãtã ma'eha ke” aja a'e mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","A'e pandu tĩ: —Pe, Tupã namõ pepandu pandu pe'am rahã, amõ rehe pehẽ py'a pemujywyr katu. Amõ rehe pemujywyr ym we rĩ. Arahã pahar pemujywyr katu. Aja rahã, ywa pe har jande pái keruhũ pehẽ rehe ipy'a ke mujywyr katu tĩ. Ma'e peka'u te'eha ke pema'e. Pehẽ rehe ipy'a mujywyr katu ta. ");
INSERT INTO urbNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Amõ rehe pehẽ py'a pemujywyr ym rahã, pehẽ rehe Tupã ipy'a ke mujywyr ym ta tĩ — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pe, Jerusarẽ ok ta pe a'eta jywyr oho tĩ. Tupã rehe ngã jumu'eha renda keruhũ pe Jesu wata ixo rahã, jundéu awa tama'e pa'ihu ta uhyk uwyr ehe. Moise je'ẽha mu'e ame'ẽ ta aja tĩ. Uhyk uwyr ehe tĩ. Jundéu awa tamũi ta aja tĩ. Uhyk uwyr ehe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Johu ngã pandu: —Kwehe ngã ke nde eremuhem eremondo sengi. Awa je'ẽha rupi nde eremuhem eremondo my? Awa riki nde ke muwyr se my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","—Anĩ we rĩ. Pehẽ pe ihẽ apandu ta tĩ. Pe, ihẽ pe pepandu py rahã, awa je'ẽha rupi ma'e ke ihẽ ama'ema'e, ame'ẽ ke ihẽ apandu ta pehẽ pe tĩ. Pesarahã! Yman Juã ambyr mujahuk, ngã ke. Myja pekwa my? Tupã je'ẽha rupi mujahuk my? Anĩ rahã, sawa'e je'ẽha rupi mujahuk my? Ame'ẽ ke ihẽ pe pepandu py — aja pa'ihu ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pa'ihu ta je'ẽ je'ẽ hũ a'eta jupe: —Mã! Myja japandu ta my? “Tupã je'ẽha rupi Juã mujahuk” aja japandu ipe rahã, kuja jande pe Jesu pandu ta: “Aja rahã, ma'erehe Juã pandu ame'ẽ ke rehe pejurujar ym my?” aja a'e pandu ta. ");
INSERT INTO urbNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Anĩ. “Sawa'e je'ẽha rupi Juã mujahuk” aja japandu rahã, ngã parahy te ta jande rehe. Myja japandu ta my? — aja je'ẽ je'ẽ hũ a'eta jupe. (Juã ambyr ke Tupã je'ẽha pandu ame'ẽ ke, aja upa ngã ukwa katu, a'erehe heta ame'ẽ ta ngi pa'ihu ta kyje. Ngã parahy ta, aja ukwa.) ");
INSERT INTO urbNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","A'erehe a'eta pandu: —Juã rehe har japandu ym ta nde pe — aja pa'ihu ta. Pe, Jesu pandu tĩ: —Aja rahã, ihẽ aja tĩ. Awa je'ẽha rupi ma'e ke ihẽ ama'ema'e. Tupã rehe ngã jumu'eha renda keruhũ ngi ngã ke amuhem amondo, ame'ẽ ke pehẽ pe apandu ym ta tĩ — aja a'e pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Pe, myja me'ẽ ma'eywa ty usakiha ta my, ame'ẽ ke Jesu pandu pandu uĩ: —Ko kupixa pe ma'eywa'y rãkã ra'yr ke ijar jytym. Uwa'y rãkã ke jytym. Kupixa rymy'y rupi mukurar kurar. Pe, ma'eywa rykwer jo'okiha renda pykũi tĩ. Kupixa rymy'y rehe myta mujã tĩ. Ywate ame'ẽ ke mujã. (Ame'ẽ ngi usakiha usak usak katu.) Pe, amõ ta pe ijar pandu: “Pepaite ihẽ apaxia ta aho. Ihẽma'e kupixa rehe pesak pesak katu. I'a tyarõ rahã, ko amõ pehẽma'e ta kỹ. Amõ i'a ihẽma'e ta kỹ” aja ijar. “Ere” aja ame'ẽ ta pandu. Pe, ijar oho. ");
INSERT INTO urbNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","I'a tyarõ rahã, miasu ke kupixa jar mondo. Usakiha ta koty ma'eywa rykwer rehe miasu oho piam. ");
INSERT INTO urbNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Anĩ. Ame'ẽ ke usakiha ta pyhyk. Pe, upa pirok. Ijar koty mujywyr mondo. Ipo te'e jywyr oho. I'a me'ẽ ym te. ");
INSERT INTO urbNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","A'engi amõ miasu ke kupixa jar mondo. Ame'ẽ ke iãkã rupi usakiha ta nupã nupã. Muhuxĩ ame'ẽ ke tĩ. Pe, mujywyr mondo. ");
INSERT INTO urbNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pe, amõ ke ijar mondo. Ame'ẽ ke usakiha ta jukwa. A'erehe amõ amõ miasu ta ke ijar mondo. Pe, amõ amõ ke usakiha ta nupã hũ tĩ. Amõ amõ ta ke jukwa tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","—Amõ sawa'e ijar namõ ixo. Ta'yr ke ame'ẽ. Ipái ipy'a katu ehe. Ame'ẽ ke usakiha ta koty mondo. Ijar pandu jupe: “Ko ihẽ ra'yr. Usakiha ta hendu katu ta ehe” aja ipái naĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pe, usakiha ta rehe ta'yr uhyk rahã, ame'ẽ ta pandu pandu a'eta jupe: “Peme'ẽ riki ijar ra'yr. (Ipái manõ rahã, kupixa riki ima'e wan ta.) Jahorahã! Jajukwa ta peme'ẽ. Aja rahã, kupixa riki jandema'e wan ta” aja usakiha ta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","A'erehe ta'yr ke usakiha ta pyhyk. Pe, jukwa. Kupixa kupe koty hete ke ombor. ");
INSERT INTO urbNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","—Mã! Ma'e kupixa jar ma'e ta apo my? Pesarahã! Ijar te uwyr, pe, upa katu te usakiha ta ke jukwa ta. Pe, amõ usakiha ta pe kupixa me'ẽ ta. Ame'ẽ ta kupixa rehe usak usak katu ta ixo. ");
INSERT INTO urbNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kuja Tupã je'ẽha rehe panduha pesak katu. “Ita rehe har ita ok mujãha pandu: ‘Jaxer te'e kome'ẽ ita ke’ aja. Tupã pandu: ‘Anĩ. Peme'ẽ ita riki ok pyter wan mupu'am katu riki’ aja. ");
INSERT INTO urbNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Aja jandema'e sawa'e te ma'eha riki. Katu aja jakwa” aja panduha ihĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jesu ke jundéu awa tama'e kapitã ta pyhyk ta tipe. Ame'ẽ ta pandu: —Ma'eywa ty usakiha ta rehe har Jesu pandu. Jande rehe har ame'ẽ — aja ukwa. (Ame'ẽ ta riki usakiha ta aja saka, aja ukwa.) A'erehe a'e ke pyhyk ta tipe. Anĩ. Heta ame'ẽ ta hury katu, Jesu panduha rehe. Jesu ke pyhyk rahã, heta ame'ẽ ta parahy ta. A'erehe heta ame'ẽ ta ngi kapitã ta kyje, a'erehe pyhyk ym. Oho ingi. ");
INSERT INTO urbNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ajame'ẽ ke Jesu koty parise ta ke jundéu awa tama'e kapitã ta mondo. Ero kotyhar ta ke mondo ixoty tĩ. Jesu je'ẽha rehe hendu. Pe, je'ẽha jawy rahã: “Katu ym nde erepandu” aja pandu ta. (Muka'u te'e tar katu, a'erehe katu ehe har pandu py.) ");
INSERT INTO urbNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jesu rehe uhyk rahã, ame'ẽ ta pandu ipe: —Sawa'e! Ngã mu'eha nde. Jetehar te ke nde erepandu, aja jakwa katu. Myja me'ẽ sawa'e my, ame'ẽ rehe nde eresak eresak ym, a'erehe nde erekwa katuha ke pahar amõ mukanim ym. Muka'u te'e ym nde ke. Jetehar rupi Tupã putar ame'ẽ ke nde eremu'e mu'e katu. A'erehe epandu katu jande pe. Homa awa tama'e kapitã keruhũ pe tamatarer jame'ẽ rahã, katu my? Myja me'ẽ jundéu awa ta je'ẽha mujekwa katu my? “Pehẽ peme'ẽ katu” aja mujekwa my? “Peme'ẽ ym” aja mujekwa my? Myja my? Epandu katu — aja parise ta pandu ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ame'ẽ ta mokõi ukwaha namõ ixo, aja Jesu ukwa katu. A'erehe kuja pandu: —Ma'erehe ihẽ akwa katuha ke pemanga te'e pexo my? Ita tamatarer ihẽ pe perur. Ihẽ asak ta — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Pe, werur ipe. Jesu pandu: —Kome'ẽ tamatarer rehe awa'ã ihĩ my? Awa rer amõ ta mupinim ko my? — aja parise ta pe. —Homa awa tama'e kapitã keruhũ 'ã kome'ẽ. Sesa'ã ke — aja ipe. (Sesa riki homa awa tama'e kapitã keruhũ.) ");
INSERT INTO urbNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Aja rahã, kapitã keruhũma'e ke kapitã keruhũ pe peme'ẽ katu. Tupãma'e rahã, Tupã rehe pehẽ py'a pemoĩ moĩ katu. (Ame'ẽ riki ma'e ke peme'ẽ ipe, ame'ẽja saka) — aja parise ta pe Jesu pandu. Ame'ẽ ke rehe hendu rahã, parise ta pandu: —Mã! Ukwa katu riki a'e — aja Jesu rehe har pandu. Pe, oho ingi. ");
INSERT INTO urbNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pe, amõ sawa'e ta uhyk uwyr ehe. Sanduse ta uhyk uwyr ehe. Kwera ym te ta awa aja ame'ẽ ta ukwa. Jesu pe pandu: ");
INSERT INTO urbNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Sawa'e! Ngã mu'eha nde. Yman kuja Moise mupinim: “Sawa'e jumendar, pe, ta'yr ym ipe rĩ. Pe, manõ rahã, imu riki imu ambyr rakehar ke pyhyk. Pe, a'e ta'yr ipe. Ame'ẽ ta'yr riki imu ambyr ra'yr aja ngã ukwa” aja Moise mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","—Apo ehendurahã! Se awa po wajar mokõi imu ta ixo kwe. U'ar py ame'ẽ ke jumendar. Pe, ta'yr ym ipe rĩ. Pe, manõ. ");
INSERT INTO urbNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","A'erehe imu riki imu ambyr rakehar ke pyhyk tipe tĩ. Mokõihar aja tĩ. Sawa'e manõ tĩ. Ta'yr ym ipe tĩ. A'erehe imu mahapyrihar kũjã ke pyhyk tĩ. Ame'ẽ aja tĩ. Manõ tĩ. Ta'yr ym ipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aja upa imu ta riki tĩ. Imu ambyr rakehar ke pyhyk tĩ. Pe, manõ tĩ. Ta'yr ym ipe tĩ. Upa awa po wajar mokõi imu ta manõ. Pe, kũjã manõ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Apo epandurahã! Yman rahã, manõ ame'ẽ ta kwera katu uhem rahã, kũjã riki awa rakehar wan ta my? Se ixo rahã, upa awa po wajar mokõi imu ta riki pyhyk — aja sanduse ta pandu. (“Manõ ame'ẽ ta kwera katu ta uhem” aja ukwa ame'ẽ ta ke muka'u te'e tar katu, a'erehe ame'ẽ panduha ke sanduse ta pandu.) ");
INSERT INTO urbNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu pandu: —Mã! Tupã je'ẽha pekwa ym. Tupãma'e pyrãtãha ke pekwa ym tĩ, a'erehe pehẽ je'ẽha ke pejawy. ");
INSERT INTO urbNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yman rahã, ngã kwera katu uhem rahã, jumendar ym te ta awa. Ywa pe Tupã je'ẽha rahoha ta ixo. Ame'ẽ ta aja ngã ixo ta tĩ. Jumendar ym te ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Apo kweraha rehe har amujekwa ta. Yman ju pirã'y rehe har Moise mupinim. Ame'ẽ rehe har pekwa riki. A'ep kuja panduha ihĩ. Moise pe Tupã pandu: “Ihẽ rehe Amarã ipy'a moĩ moĩ katu. Ihẽ rehe Isak aja tĩ. Ipy'a moĩ moĩ katu tĩ. Jako aja tĩ. Ihẽ rehe ipy'a a'e moĩ moĩ katu tĩ” aja Tupã pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","—Pesarahã! Ixuwe katu ixo ame'ẽ ta jõ Tupã rehe ipy'a ke moĩ moĩ katu. Manõ ame'ẽ ta anĩ. Aja rahã, Amarã ta 'ã ixuwe katu aja ixo rĩ. Yman riki manõ. A'eta 'ã ixuwe katu ixo. A'erehe tapijar te'e we ipy'a ke moĩ moĩ katu Tupã rehe. A'erehe: “Amarã ta ihẽ rehe ipy'a ke moĩ moĩ” aja Tupã pandu. (A'eta 'ã pehĩ.) A'erehe manõ ame'ẽ ta kwera katu ta kỹ, aja Tupã mujekwa. A'erehe pehẽ pekwaha pejawy riki — aja Jesu mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jesu namõ sanduse ta pandu pandu ame'ẽ ke amõ Moise je'ẽha mu'e ame'ẽ hendu. Sanduse ta pe ukwa katuha namõ Jesu pandu, aja Moise je'ẽha mu'e ame'ẽ ukwa. A'erehe a'e riki Jesu pe Tupã je'ẽha rehe har pandu: —Myja me'ẽ riki katu te ame'ẽ ke my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","—Kuja riki katu te me'ẽ ke. “Jundéu awa ta! Pehendu katurahã! Tupã riki jandema'e sawa'e te. A'e jõ riki sawa'e te. ");
INSERT INTO urbNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tupã rehe nde py'a emoĩ moĩ katu. Tupã rehe har nde erekwa erekwa exo rahã, epy'a katu ehe. Upa nde erekwa katuha namõ epy'a katu ehe tĩ. Upa nema'e pyrãtãha namõ ma'e ke nde erema'ema'e rahã, epy'a katu ehe tĩ.” ");
INSERT INTO urbNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","—Mokõihar Tupã je'ẽha katu te ame'ẽ ke kuja. “Ne namõ ixo ame'ẽ ta rehe epy'a katu. Nde juehe nde erepy'a katu, aja amõ rehe epy'a katu tĩ.” —Ame'ẽ mokõi je'ẽha riki katu te ame'ẽ ke. Aja me'ẽ amõ je'ẽha uhyk ym — aja Jesu ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Moise je'ẽha mu'e ame'ẽ pandu: —Sawa'e! Katu nde erepandu. Jetehar nde erepandu. Jandema'e sawa'e te jõ riki Tupã. Amõ Tupã aja nixói te. ");
INSERT INTO urbNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","A'erehe Tupã rehe amõ ipy'a katu ta me'ẽ te'e. Upa ukwa katuha namõ ipy'a katu ta me'ẽ te'e tĩ. Upa ma'e ke pyrãtãha namõ amõ ma'e rahã, Tupã rehe ipy'a katu ta me'ẽ te'e tĩ. Pe, inamõ ixo ame'ẽ ta rehe ipy'a katu ta me'ẽ te'e tĩ. Juehe aja amõ rehe ipy'a katu ta me'ẽ te'e tĩ. Ame'ẽ mokõi je'ẽha rehe hendu katu rahã, katu te ame'ẽ ke. Ma'e hymba hapy, aja ymanihar ta aja Tupã rehe ipy'a moĩ moĩ tĩ. Ame'ẽ katu we. Amõ ma'e heta ma'e ke hapy, aja Tupã rehe ipy'a moĩ moĩ rahã, katu we tĩ. Tupã je'ẽha rehe hendu katuha riki i'ar koty te we katuha — aja sawa'e pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ukwa katuha namõ sawa'e pandu, aja Jesu ukwa. A'erehe pandu ipe: —Awa ixoha amõ koty Tupã putar. Jetehar rupi amõ ixo katu, aja a'e putar. Ame'ẽ ke nde erekwa nahã my, aja akwa. A'erehe ixotyhar aja nde eremuruwak tate nahã my — aja sawa'e pe. Jesu mu'e katu te, a'erehe arahã har ngi ma'e ke ngã pandu ym ipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tupã rehe ngã jumu'eha renda keruhũ pe Jesu mu'e uĩ rahã, kuja pandu: —Ihẽ pe pepandurahã! Moise je'ẽha mu'e ame'ẽ ta kuja pandu: “Kirisutu Ndawi rainõ. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e” aja pandu. Ma'erehe aja pandu my? ");
INSERT INTO urbNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tupã'ã mujekwa ame'ẽ ke Ndawi pandu. Kuja. “Ihẽma'e sawa'e te pe jandema'e sawa'e te pandu: ‘Ihẽ rake ewapyk eĩ.’ (Aja rahã, katu te ame'ẽ ke nde, aja amujekwa.) Nde ruwajan ta ke ihẽ amuputu'u ta, a'erehe nde rehe ame'ẽ ta hendu katu ta” aja. ");
INSERT INTO urbNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","—Kirisutu rehe har Ndawi pandu: “Ihẽma'e sawa'e te” aja. (Aja rahã, a'e Tupã tĩ, aja Ndawi ukwa.) Aja rahã, myja me'ẽ Kirisutu Ndawi rainõ aja ixo my tĩ? (Aja rahã, awa te'e a'e, aja mujekwa) — aja ngã pe Jesu pandu. (Anĩ. Jundéu awa tama'e kapitã ta pandu ym ma'e ke.) Heta ame'ẽ ta anĩ. Jesu je'ẽha rehe upa ngã hendu. Hury katu ngã ehe. ");
INSERT INTO urbNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ngã ke Jesu mu'e rahã, kuja pandu: —Moise je'ẽha mu'e ame'ẽ ta aja mã peja ym pehẽ tĩ. Ame'ẽ ta ima'e mundeha katu te aja putar katu. (Aja rahã, kapitã jupe aja mujekwa tar katu tipe.) Amõ we tĩ. Muhepyha renda rupi wata ixo rahã: “Ko nde erexo. Nde katu” aja je'ẽha putar katu tĩ. (Katu te ame'ẽ ke jupe aja mujekwa tar katu tipe.) ");
INSERT INTO urbNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jundéu awa tama'e jy'ariha renda pe wapyk rahã, kapitã ta rake wapyk tar katu. (Aja rahã, katu te ame'ẽ ke jupe aja mujekwa tar katu tipe.) Ma'e huryha amõ mujã rahã, imi'u matyr. Ame'ẽ pe oho rahã, aja tĩ. Kapitã ta rake wapyk tar katu tĩ. (Katu te ame'ẽ ke jupe aja mujekwa tar katu tipe tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ixawa'e manõ ame'ẽ ta pe a'eta pandu: “Pehẽ ke jahaihu tar katu” aja naĩ. Anĩ. Te'e riki. Kũjãma'e ke te'e pyhyk raho. Hok ke te'e jo'ok ingi tĩ. Pe, katu te ame'ẽ ke jupe aja mujekwa tar katu, a'erehe i'i Tupã namõ pandu pandu. (Aja rahã, katu te ame'ẽ ke aja ngã ukwaha naĩ.) Mã! Ame'ẽ ta ke Tupã mupyrara hũ ta — aja Moise je'ẽha mu'e ame'ẽ ta rehe har Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Pe, tamatarer purakariha renda koty Jesu wapyk uĩ. Henda pe tamatarer ke ngã purakar. (Aja Tupã rehe ipy'a moĩ moĩ katu.) Jesu usak usak uĩ rahã, ima'ehũ namõ ixo ame'ẽ ta heta purakar. ");
INSERT INTO urbNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pe, ixawa'e manõ ame'ẽ ke uhyk uwyr a'ep. Tamatarer ta'yr mi namõ ixo. Mokõi jõ ita tamatarer ra'yr henda pe purakar. Ame'ẽ mokõi ta'yr te mi. ");
INSERT INTO urbNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Pe, jumu'eha ta pe Jesu pandu: —Se pejur. Pesarahã! Amõ ta ima'ehũ namõ ixo. Ame'ẽ ta ngi har a'eta jo'ok, pe, henda pe purakar. Ima'e ke pyta we hũ rĩ. Peme'ẽ ixawa'e manõ ame'ẽ ke anĩ. Tamatarer heta ym te. Mokõi jõ namõ ixo. Ame'ẽ ke upa katu te purakar. Ima'e ke pyta ym te. Nixói te apo 'y. Ima'e ke jo'ok ta tipe. Anĩ. Upa katu te ame'ẽ ke henda pe moĩ. (Tupã rehe ipy'a moĩ moĩ tar katu te hũ, a'erehe upa katu te henda pe moĩ.) Upa katu te moĩ, a'erehe amõ ta 'ar koty te we kũjã moĩ katu — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tupã rehe ngã jumu'eha renda keruhũ ngi Jesu uhem ixo, jumu'eha ta namõ. Ame'ẽ ta ngi har amõ pandu ipe: —Sawa'e! Esarahã! Jumu'eha renda keruhũ katu te. Ita keruhũ ke te'e mujã ame'ẽ ke. Mã! Katukwer — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesu pandu: —A'e tỹ! Pesak katu ehe apo. Yman rahã nixói ta. Peme'ẽ ke amõ ta upa mujaxer ta kỹ. Ita mokõi mokõi ihĩ ym te ta kỹ. Upa katu te ita ke amõ ta ombor ta. (Aja rahã, Tupã rehe ngã jumu'eha renda keruhũ ke mujaxer ta, aja mujekwa) — aja jumu'eha ta pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ywy'ã rehe Jesu wapyk uĩ, Oriwéi ywy'ã rehe. Arahã Petu uhyk ehe. Tian aja tĩ. Juã amõ tĩ. Andere amõ tĩ. Uhyk ehe tĩ. A'eta jõ Jesu namõ ixo. Paite we Tupã rehe ngã jumu'eha renda keruhũ ihĩ. Usak katu ehe. Ame'ẽ rehe har jumu'eha ta pandu: ");
INSERT INTO urbNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Jande pe epandurahã! Myja rahã, ita mokõi mokõi ihĩ ym ta my? Ma'e jasak ta my, pe, ame'ẽ ke uhyk tate, aja jakwa katu ta my? — aja Jesu pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jumu'eha ta ke Jesu mu'e: —Pesak katu kỹ! Mã peja pehẽ ke amõ ta muka'u te'e ym. ");
INSERT INTO urbNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kuja. Heta uwyr ta. “Jesu je'ẽha rupi ihẽ ajur” aja pandu te'e ta. “Ko Kirisutu ihẽ. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke ihẽ” aja pandu te'e ta tĩ. Heta ngã ke muka'u te'e ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kotete jumaiha tyapuha ke pehendu ta. “Paite amõ ta jumai mai ixo” aja pehendu ta tĩ. Pemukahem ym. Aja jumaiha uhyk ta kỹ. Uhyk rahã, 'ar rehe angaha uhyk, anĩ we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Amõ amõ ywy pe har ta jumai mai ta ngã juehe. Kapitã keruhũ riki amõ kapitã keruhũ namõ jumai mai ta tĩ. Amõ amõ ywy katak katak hũ ta. Amõ amõ ywy rehe ngã mi'u nixói te ta tĩ. Aja ahyha uhem ramõ. Ahy py, ame'ẽja saka. ");
INSERT INTO urbNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","—Pesak katu pehẽ juehe. Jundéu awa tama'e kapitã ta ruwa koty pehẽ ke amõ ta raho ta. “Jaxer pehẽ” aja naĩ. Pe, pehẽ ke nupã ta. Pe, jundéu awa tama'e jy'ariha renda pe raho ta tĩ. A'ep ngã petek hũ ta pehẽ ke tĩ. Ihẽ kotyhar ta ke pehẽ, a'erehe homa awa tama'e kapitã ta ruwa koty pepu'am ta. Kapitã keruhũ ruwa koty pepu'am ta tĩ. Ame'ẽ ta pe pepandu ta: “Jesu rehe jõ amõ jurujar katu rahã, ame'ẽ ke Tupã muhã katu ta” aja pepandu ta. Ame'ẽ myrandu katu pepandu ta. ");
INSERT INTO urbNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ame'ẽ myrandu katu ke upa katu te ngã pe amõ ta pandu pandu ta me'ẽ te'e. Pe, 'ar rehe angaha uhyk ta. ");
INSERT INTO urbNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pehẽ ke amõ ta pyhyk ta kỹ. Jundéu awa tama'e kapitã ta ruwa koty raho ta tĩ. Arahã pehẽ py'a pe pekwa pekwa ym pe'am: “Ma'e jande japandu ta my? Myja me'ẽ katu my?” aja pekwa pekwa ym pe'am. Kapitã ta ruwa koty pepu'am rahã, je'ẽha amõ muwyr ame'ẽ ke pepandu katu. Arahã pehẽ atu je'ẽha pepandu ta my? Anĩ. Aja ym. Tupã'ã riki mujekwa ame'ẽ ke pepandu katu ta. ");
INSERT INTO urbNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Arahã kapitã pe imu pandu ta: “Ko Jesu kotyhar ke. Ejukwa” aja pandu ta. Ipái ta aja tĩ. Kapitã pe ta'yr ta ke raho ta. “Ko Jesu kotyhar ke. Ejukwa” aja pandu ta tĩ. Ipái ta ke ta'yr ta raho ta tĩ. “Ko Jesu kotyhar ke. Ejukwa” aja pandu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ihẽ kotyhar ta ke pehẽ, a'erehe pehẽ rehe upa ngã parahy ta. Ihẽ rehe jurujar katuha ke hijar ym ame'ẽ ke Tupã namõ ixo ta. Manõ. Anĩ. Tupã namõ ixo katu ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","A'e pandu tĩ: —Paper rehe esak katu! Pe, ekwarahã! Tupã rehe ngã jumu'eha renda keruhũ pe amõ ta ma'e jaxer ai te ame'ẽ ke moĩ ta. Katu ym a'ep. Ame'ẽ ke rehe pesak rahã, jundéi ywy pe har ta kanim ujan oho. Ywy'ã koty ujan oho. (Aja rahã, manõ ym ta.) ");
INSERT INTO urbNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Hok kupe 'ar pe amõ ixo rahã, mã peja hok pe ixe ym oho. Pyhyk ym oho ima'e ke. I'i pyta ym. Pahar ujan oho. (Aja rahã, manõ ym ta.) ");
INSERT INTO urbNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kupixa pe ixo rahã, ima'e ke rehe hok pe jywyr ym oho. Ima'e mundeha rehe pyhyk ym oho. Pahar ujan oho. (Aja rahã, manõ ym ta.) ");
INSERT INTO urbNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Arahã ipusu pe imembyr namõ kũjã ixo rahã, mã pyrara ta ixo. (Marã ka ym pahar ujaniha.) Ixamby u'u ame'ẽ ke namõ ixo rahã, aja tĩ. Mã pyrara ta ixo tĩ. (Marã ka ym pahar ujaniha.) ");
INSERT INTO urbNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“Aman ndy'ar rahã, ahyha emuhyk ym” aja Tupã pe pepandu. (Aman ukyr rahã, rysã. A'erehe marã ka ym pahar ujaniha.) ");
INSERT INTO urbNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","—Arahã ngã rehe ahyha keruhũ uhyk ta. Aja ahyha keruhũ ngã ukwa ym we rĩ. Yman kome'ẽ ywy keruhũ Tupã mujã. Arahã har ngi aja ahyha keruhũ ngã ukwa ym we rĩ. Uhyk ym we rĩ. Arahã jõ uhyk katu ta. Ahyha keruhũ upa rahã, aja ahyha keruhũ ngã ukwa ym ta tĩ. Uhyk ym ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Pahar jandema'e sawa'e te ahyha keruhũ ke mumba ym rahã, kome'ẽ ywy keruhũ pe ngã nixói te ta tipe. Anĩ. Tupã rehe ipy'a katu ame'ẽ ta kome'ẽ ywy keruhũ pe ixo. A'erehe pahar ahyha keruhũ ke jandema'e sawa'e te mumba ta. ");
INSERT INTO urbNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","—A'engi amõ ta pehẽ pe pandu ta: “Ko Kirisutu ixo. Kapitã keruhũ aja Tupã mu'am me'ẽ ke” aja pandu naĩ. Amõ: “Pete'e ixo apo” aja ta naĩ tĩ. Ame'ẽ rehe pejurujar ym pehẽ. Te'e ame'ẽ ta. ");
INSERT INTO urbNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Amõ ta te'e pandu ta uwyr: “Ihẽ Kirisutu” aja naĩ. Amõ: “Tupã je'ẽha pandu ame'ẽ ke ihẽ” aja riki te'e pandu ta. Marã ka ym amõ ma'eha, ame'ẽ ke ma'ema'e katu ta. Aja Tupã rehe ipy'a katu ame'ẽ ta ke muka'u te'e ta tipe. Tupã pandu: “Ihẽ kotyhar ta ke pehẽ.” Ame'ẽ ta ke muka'u te'e ta tipe. ");
INSERT INTO urbNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","A'erehe pesak katu kỹ! Ame'ẽ te'e pandu ame'ẽ ta uhyk ym we rĩ. Upa katu te ame'ẽ rehe har ihẽ amujekwa pehẽ pe apo 'y — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","A'e pandu tĩ: —Ame'ẽ ahyha keruhũ 'ar upa rahã, amõ we mãte ma'e ke uhyk ta. Warahy muwe ta tĩ. Jahy wera ym ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ywa ngi jahy rata ta u'ar u'ar ta tĩ. Ywa rehe ihĩ ame'ẽ ke Tupã mukatak hũ ta. ");
INSERT INTO urbNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","—Ajame'ẽ ke ihẽ ajywyr ta. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ywa takãxĩha 'ar pe apu'am ta ajur. Tupãma'e pyrãtãha namõ ajywyr ta. Hendy hũ aja ajywyr ta. ");
INSERT INTO urbNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pe, Tupã je'ẽha rahoha ta ke ihẽ amondo ta. Upa katu te kome'ẽ ywy keruhũ rupi amondo ta. Tupã pandu: “Ihẽ kotyhar ta ke peme'ẽ ta. Aputar ame'ẽ ta ke ame'ẽ ta” aja. Ame'ẽ ta ke Tupã je'ẽha rahoha ta mujy'ar ta. Upa katu te ame'ẽ ta ke mujy'ar ta. (Pe, Tupã namõ ixo ta) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","A'e pandu tĩ: —Ma'eywa'y riki pehẽ pe mujekwa ta. Sik'y ke. Hãkã rehe hokyr uhem rahã, warahy haku tate, aja pekwa. ");
INSERT INTO urbNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aja ihẽ ajywyriha pekwa ta tĩ. Warahy uwe, ame'ẽ rehe har apandu ramõ. Aja pesak rahã, ywa ngi ajywyr tate, aja pekwa ta. ");
INSERT INTO urbNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ko apandu katu. Upa pehẽ pe apandu ramõ, aja uhyk ta. Amõ ihẽ kotyhar ta pyrara hũ ta. Anĩ. Tapijar te'e we ihẽ rehe jurujar katu ta rĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ywa ke upa kanim ta. Kome'ẽ ywy keruhũ upa kanim ta tĩ. Ihẽ apandu ame'ẽ ke anĩ. Ame'ẽ kanim ym te ta. Apandu, aja upa katu te uhyk ta kỹ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","A'e pandu tĩ: —Myja rahã, ihẽ ajywyr ta my? Ma'e wera rahã, ajywyr ta my? My warahy rahã, ajywyr ta my? Ame'ẽ ke ukwa ym awa. Ywa pe ixo ame'ẽ Tupã je'ẽha rahoha ta ukwa ym tĩ. Ihẽ riki akwa ym tĩ. Ta'yr ke ihẽ. Ihẽ pái jõ ukwa katu. ");
INSERT INTO urbNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Pesak katu, aja pexo! (Peker aja ym pexo.) Ajywyriha angaha ke rehe pekwa ym. A'erehe pesak katu pexo. Peta kỹ. ");
INSERT INTO urbNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","—Kuja riki. Sawa'e paxia oho, ame'ẽja saka. Oho rahã, hok ke hijar oho. Oho tate rahã, miasu ta pe pandu: “Ihẽ rok rehe pesak katu. Peparaky katu pexo rĩ” aja ijar pandu. Hukwen rupi harõha pe pandu tĩ: “Eharõ katu e'am” aja. ");
INSERT INTO urbNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Aja pexo tĩ. Pehẽ pe ihẽ apandu katu: “Pesak katu pexo.” Ywa ngi ihẽ ajywyr rahã, ihẽ ajywyriha angaha ke pekwa ym ta. Pytun ramõ rahã, ajywyr ta nahã my. Pytun pyter pe, ajywyr ta nahã my. Sapukái je'ẽ ramõ rahã, ajywyr ta nahã my. Pytuniwe rahã, ajywyr ta nahã my. Pekwa ym ta, a'erehe peharõ katu pexo. ");
INSERT INTO urbNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ajywyriha riki pahar ta. Ajywyr rahã, peker aja pehẽ rehe asak rahã, katu ym ta. ");
INSERT INTO urbNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","A'erehe pehẽ pe apandu katu: “Peharõ katu pexo.” Amõ we tĩ. Upa katu te ngã pe apandu tĩ: “Peharõ katu pexo” — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pe, mokõi ukwer rahã, Pasuko 'ar rehe uhyk ta. Arahã jundéu awa ta mbeju ke u'u ta. Mbeju ke mupururukiha nixói, ame'ẽ ke u'u ta. Pe, Jesu ke jundéu awa tama'e pa'ihu ta pyhyk tar katu. Moise je'ẽha mu'e ame'ẽ ta aja tĩ. Pyhyk tar katu tĩ. Ngã ukwa ym ha rupi pyhyk tar katu. Pe, jukwa tar katu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ame'ẽ ta pandu pandu a'eta jupe: —Ngã mi'u matyr rahã, heta ngã ixo. Arahã japyhyk ym we ta rĩ. Arahã japyhyk rahã, jande rehe ngã parahy ta. Jande namõ jumai ta — aja a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mbeta ok ta pe Jesu ihĩ, Simã rok pe. Yman pere ma'e u'u hũ ame'ẽ ke namõ Simã ixo. Apo anĩ. Katu 'y. Pe, u'uha renda pe Jesu wapyk uĩ rahã, ita parasuku ke kũjã muhyk werur ehe. Ita aramba ke te'e mujã ame'ẽ ke ame'ẽ parasuku. Ita parasuku pe na rykwer ihĩ. Pihe katu te ame'ẽ! Muhepy hũ ame'ẽ tĩ. Parasuku kyndaha ke kũjã mopok. Pe, Jesu ãkã rehe tykwer jyhẽ. ");
INSERT INTO urbNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ame'ẽ rehe usak rahã, amõ ta je'ẽ je'ẽ kũjã rehe har. Pandu pandu a'eta jupe: —Ma'erehe tykwer ke te'e jyhẽ my? ");
INSERT INTO urbNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Peme'ẽ rykwer muhepy rahã, tamatarer hũ pyhyk ta. Pe, ame'ẽ ke ima'e ym te ame'ẽ ta pe me'ẽ me'ẽ katu ta tipe — aja a'eta jupe. A'erehe kũjã rehe har je'ẽ je'ẽ hũ a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Anĩ. Jesu pandu: —Mã peja ym pehẽ. Peje'ẽ je'ẽ ym pehẽ jupe. Katu ym aja. Kũjã rehe peparahy ym. Ma'e katu ame'ẽ ke ihẽ pe kũjã ma'e. ");
INSERT INTO urbNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pesarahã! Ima'e ym te ame'ẽ ta kote'e ixo. Ame'ẽ ta pe tamatarer peme'ẽ tar katu rahã, pete'e ixo. Ihẽ anĩ. Pehẽ namõ aja te'eha apyta ym ta. ");
INSERT INTO urbNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kũjã putar aja a'e ma'e katu. Pesarahã! (Jundéu awa manõ rahã, hete ke amõ ta mupihe te'e, aja te'eha a'eta ma'eha.) Aja ihẽ rehe tĩ. Ihẽ amanõ ym we rĩ. Ko ihẽ ke mouha rehe kũjã upa mupihe. (A'erehe ihẽ rehe pyaiha apo mujekwa rahã, katu tiki.) ");
INSERT INTO urbNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Pesarahã! Apo apandu katu. Ihẽ rehe har myrandu katu ke amõ ta pandu pandu raho. Kome'ẽ ywy keruhũ rupi pandu pandu raho rahã, kome'ẽ kũjã ma'eha rehe har pandu ta tĩ. Kũjã ma'eha ke harái ym ta ngã — aja a'eta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jundéu awa tama'e pa'ihu ta koty Jun Ikario oho. Awa py mokõi jumu'eha ta ngi har peteĩ a'e. Pa'ihu ta pe pandu: —Jesu koty pehẽ ke ihẽ araho ta — aja Jun. ");
INSERT INTO urbNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ame'ẽ ke rehe pa'ihu ta hendu rahã, hury katu. Pe, pandu ipe: —Jesu koty jande ke nde ereraho rahã, nde pe tamatarer jame'ẽ ta — aja Jun pe. Pe, a'engi Jesu rehe pa'ihu ta ke muhyk ta raho ame'ẽ angaha ke rehe Jun harõ ixo. ");
INSERT INTO urbNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ajame'ẽ ke Pasuko 'ar uhyk. Ame'ẽ 'ar rahã, arapuharan ra'yr ke jundéu awa ta jukwa. (Aja ipy'a pe Tupã rehe har ukwa ukwa uĩ.) Jesu pe jumu'eha ta pandu: —Pasuko 'ar rahã, arapuharan ra'yr ka'ẽ ke nde ere'u ta. Ame'ẽ ke jamatyr, aja nde ereputar. My jamatyr ta my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Mokõi jõ jumu'eha ta pe Jesu pandu: —Pehẽ mokõi ihẽ amondo ta. Paite awa ok ta hũ ihĩ, Jerusarẽ ok ta ke. A'ep peho. A'ep amõ sawa'e rehe pesak ta. Iãkã 'ar pe y ke ame'ẽ raho. Ame'ẽ sawa'e namõ peho. Ijar rok pe a'e ixe ta. ");
INSERT INTO urbNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ame'ẽ rok pe inamõ pexe peho tĩ. Ok jar rehe pesak rahã, kuja pepandu ipe: “Jandema'e mu'eha kuja me'u: ‘Pasuko 'ar ke jande jakwa jakwa tar katu. My u'uha renda ihĩ my? Ihẽma'e jumu'eha ta namõ arapuharan ra'yr ka'ẽ ke a'u ta’ ” aja ijar pe pepandu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ywate pyrũha renda ke ijar mujesak ta pehẽ pe. Upa ma'e ke pehĩ. (Myrape, ita rekúi. Upa pehĩ.) A'ep jande rehe jande mi'u pematyr — aja mokõi jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jerusarẽ ok ta pe mokõi sawa'e ta oho. Ma'e u'uha renda mahem. Jesu pandu, aja upa katu te usak. Pe, a'eta mi'u matyr. A'ep Pasuko 'ar ke ukwa ukwa ta. ");
INSERT INTO urbNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pytun ramõ rahã, Jerusarẽ ok ta pe Jesu uhyk. Ma'e u'uha renda pe uhyk oho, awa py mokõi jumu'eha ta namõ. ");
INSERT INTO urbNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ma'e ke u'u uĩ rahã, Jesu pandu: —Ko apandu katu pehẽ pe. Pehẽ ngi har peteĩ ihẽ rehe ihẽ ruwajan ta ke muhyk ta werur. Muhyk ta ame'ẽ ko ihẽ namõ u'u uĩ apo — aja jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ame'ẽ rehe hendu rahã, a'eta pyai. Peteĩ teĩ pandu ipe: —Mã! Ihẽ ke ame'ẽ my? — aja upa pandu ipe. Aja pame katu te upa jumu'eha ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesu pandu: —Awa py mokõi hetaha pehẽ. Pehẽ ngi har peteĩ ihẽ rehe amõ ta ke muhyk ta werur. Ita rekúi pe ihẽ namõ mbeju ke munde, ma'e rykwer pe. Ame'ẽ riki ihẽ rehe amõ ta ke muhyk ta werur. ");
INSERT INTO urbNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Myja ihẽ amanõ ta my? Kuja. Tupã je'ẽha rehe panduha ihĩ, aja amanõ ta. Aja uhyk ta. Ihẽ ruwajan ta ke ihẽ rehe muhyk ta werur. Mã! Ame'ẽ ke pyrara te hũ aja ixo ta. A'erehe imãi pusu ngi u'ar ym rahã, katu ta tipe — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ma'e ke u'u rahã, mbeju ke Jesu pyhyk. Pe, Tupã pe pandu: —Ne jõ riki katu te me'ẽ ke. Jande mi'u jande pe nde eremuwyr katu — aja. Pe, ame'ẽ ke mopok. Jumu'eha ta pe me'ẽ me'ẽ. Pandu: —Pe'u! Kome'ẽ ihẽ rete — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ita rekúi ra'yr ke Jesu pyhyk. Ma'eywa rykwer ita rekúi ra'yr pe ihĩ, uwa rykwer ke. Tupã pe pandu tĩ: —Ne jõ riki katu te me'ẽ ke. Jande mi'u jande pe nde eremuwyr katu — aja. Pe, jumu'eha ta pe me'ẽ me'ẽ tĩ. Johu u'u. ");
INSERT INTO urbNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","A'e pandu: —Kome'ẽ ihẽ ruwy. Upa ngã rehe ihẽ ruwy uhem ta, a'erehe Tupã pandu ta: “Ihẽ ra'yr rehe amõ jurujar katu rahã, ame'ẽ ke ihẽ amuhã katu ta” aja ngã pe pandu ta. ");
INSERT INTO urbNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ko apandu katu pehẽ pe. Uwa rykwer ihẽ a'u ym ta tĩ. Kapitã keruhũ te aja ihẽ ke ihẽ pái keruhũ mu'am ta kỹ. Arahã jõ pyahu ame'ẽ ke pehẽ namõ a'u ta kỹ tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Upa u'u rahã, Tupã rehe har jyngar. A'engi uhem oho. Oriwéi ywy'ã koty a'eta oho. ");
INSERT INTO urbNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jumu'eha ta pe Jesu pandu: —Ihẽ ke upa pehijar ta. Kuja Tupã je'ẽha rehe panduha ihĩ. “Arapuharan ta usakiha ke Tupã jukwa ta. Aja rahã, upa arapuharan ta uhãi ta oho” aja amõ mupinim. —(Aja ta pehẽ ke tĩ. Amõ ta ihẽ ke jukwa rahã, upa pehẽ pehãi ta peho tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","A'engi ihẽ akwera katu ahem rahã, Ngariréi ywy pe ihẽ aho py ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petu pandu: —Nde ke ihẽ ahijar ym te ta. Upa amõ ta ujan ta oho nengi. Ihẽ anĩ ta. Nde namõ apyta ta kỹ — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pe, Jesu pandu: —Petu! Ko apandu katu nde pe. Kome'ẽ pytun, sapukái mokõihar je'ẽ ym rahã, kuja te'e nde erepandu ta: “Jesu rehe har akwa ym ihẽ” aja nde erepandu ta. Aja mahapyrihar te'e nde erepandu ta — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Anĩ. I'ar koty te we hãtã Petu pandu: —Anĩ. Aja apandu ym te ta. Nde namõ ihẽ ke amõ ta jukwa rahã: “Nde rehe har ihẽ akwa ym” aja apandu ym te ta — aja ipe. Petu pandu aja upa jumu'eha ta pandu pandu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ajame'ẽ ke amõ renda pe a'eta oho, Ngese renda pe. Jumu'eha ta pe Jesu pandu: —Se pewapyk we rĩ. Tupã namõ ihẽ apandu ta aho — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pe, iãkã koty we Petu ke Jesu raho. Tian ke raho tĩ. Juã ke raho tĩ. Ame'ẽ mahapyr jõ raho. Pe, Jesu pyai te hũ. Mãte hũ ukwaha. ");
INSERT INTO urbNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Mahapyrihar ta pe pandu: —Apyai te hũ ihẽ! Amanõ aja ihẽ apyaiha tĩ. Se pepyta we rĩ. Pesak katu pexo. (Aja rahã, amõ uhyk ym ta jande rehe) — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","A'engi jeje Jesu oho we. Ipixi'a pe u'ar te'e oup. Aja Tupã namõ pandu: —Papa! Ihẽ apyraraha uhyk tate, ihẽ rehe. Nde ereputar rahã, ame'ẽ ngi ihẽ ke nde eremuhem katu, aja akwa katu. Upa katu te ma'e ke nde erema'ema'e katu. A'erehe pyraraha ngi emuhem katu ihẽ ke. Anĩ rahã, ihẽ py'ahu te'e ahendu katu ta. Nde ereputar ame'ẽ ke ihẽ ama'ema'e ta kỹ — aja Tupã pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","A'engi mahapyrihar ta koty jywyr oho. Uhyk rahã, mahapyrihar ta rehe usak. Ukwer riki. Mupak rahã, Petu pe pandu: —Simã! Mã! Nde ereker ereju. Nde eresak ym we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Peker ym we rĩ. Tupã namõ pepandu! Aja rahã, pejurujar katuha ke amõ ta manga rahã, pehijar ym ta. Ihẽ namõ nde erepyta tar katu te. Anĩ. Nde riki pitu te'e — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Pe, Jesu oho we tĩ. Tupã namõ pandu tĩ: —Papa! Ihẽ apyraraha ngi emuhem ihẽ ke. Anĩ rahã, ihẽ py'ahu te'e ahendu katu ta. Nde ereputar ame'ẽ ke ihẽ ama'e ta — aja Jesu pandu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pe, jywyr tĩ. Mahapyr jumu'eha ta rehe uhyk tĩ. Ukwer ou tĩ. Pyhýi te hũ. Upak rahã, je'ẽha ke uhem ym. ");
INSERT INTO urbNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jesu oho we tĩ. Pe, jywyr tĩ. Mahapyrihar ta koty jywyr rahã, a'eta ukwer ou tĩ. A'e pandu: —Mã! Peker peju tĩ. Peputu'u peju tĩ. A'ewan pekeriha. Pesarahã! Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ma'e ka'u te'eha ke ma'ema'e ame'ẽ ta ke ihẽ rehe amõ muhyk ta werur. Ame'ẽ angaha ke rehe uhyk apo 'y. ");
INSERT INTO urbNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pepu'am! Jahorahã! Pesarahã! Ihẽ ruwajan ta ke ihẽ rehe muhyk ta werur ame'ẽ ke petur ixo — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","A'e pandu u'am rahã, Jun uhyk uwyr ehe. Awa py mokõi jumu'eha ta ngi har peteĩ a'e. Jun namõ heta ngã uhyk. Kyse puku namõ ngã uwyr. Tamarã namõ uwyr tĩ. Ame'ẽ ta ke Jesu koty pa'ihu ta mondo. Moise je'ẽha mu'e ame'ẽ ta mondo tĩ. Jundéu awa tamũi ta mondo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ngã pe Jun pandu ramõ: —Kuja Jesu ke pekwa ta. Huwa ke ihẽ apyter, ame'ẽ riki Jesu. Pahar pepyhyk a'e ke. Pesak katu peraho — aja Jun pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pe, Jun uhyk rahã, pahar Jesu koty oho. Pandu ipe: —Sa'e! — aja Jesu pe. Pe, huwa ke pyter. ");
INSERT INTO urbNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pe, Jesu ke ngã pyhyk. Hãtã pyhyk. ");
INSERT INTO urbNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pe, amõ a'ep ixo. Ame'ẽ riki kyse puku jo'ok. Pe, pa'i keruhũma'e miasu ke nupã. Inambi ke mopok ingi, kyse puku pe. ");
INSERT INTO urbNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ngã pe Jesu pandu: —Kyse puku namõ pejur, tamarã namõ. Aja ma'e mukanĩha ke amõ ta pyhyk. Mã! Aja ihẽ ke pepyhyk pejur tĩ. Aja ym ta tipe rahã, katu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Pesarahã! Kwehe we amõ amõ wera rahã, Tupã rehe ngã jumu'eha renda keruhũ pe ihẽ amu'e aĩ. Pehẽ pyter pe axo. Amõ amõ ku'ẽ rahã we, ihẽ amu'e aĩ tĩ. Amõ ku'ẽ rahã we, aja tĩ. Amu'e aĩ tĩ. Arahã pepyhyk ym ihẽ ke. Anĩ. Apo ihẽ ke pepyhyk. Tupã je'ẽha rehe panduha ihĩ. Aja uhyk apo 'y. Aja ihẽ ke pepyhyk apo tĩ. Mukanĩha aja ihẽ ke pepyhyk pejur tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pe, Jesu ke upa katu te jumu'eha ta hijar oho. Ujan riki oho ingi. ");
INSERT INTO urbNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jesu ke ngã raho rahã, haikwer rupi amõ sawa'e wan oho ixo. Pan tuwyr pe jõ hete rupi jupukek oho ixo. Pe, amõ ta pyhyk a'e ke. ");
INSERT INTO urbNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Anĩ. Pan tuwyr ombor oho. Jawe te'e ujan oho. ");
INSERT INTO urbNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jundéu awa tama'e pa'i keruhũ rok pe Jesu ke amõ ta raho. A'ep upa pa'ihu ta jy'ar uĩ. Upa jundéu awa tamũi ta aja tĩ. Jy'ar uĩ tĩ. Upa Moise je'ẽha mu'e ame'ẽ ta aja tĩ. Jy'ar uĩ tĩ. Pa'ihu ta namõ jy'ar uĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Paite we Jesu raikwer rupi Petu tur ixo. Pe, pa'i keruhũ rok pe uhyk, soroka pe. Pa'i keruhũma'e parakyha ta namõ Petu wapyk uĩ. Tata rake jumaku uĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pa'ihu ta ma'e usakiha ke kekar kekar tipe. Ma'e ka'u te'eha ke Jesu ma'e, ame'ẽ rehe usak ame'ẽ ta ke kekar tipe. Johu jy'ar ame'ẽ ta rupi kekar kekar tipe. Anĩ. Mahem ym riki. Mahem rahã: “Nde katu ym. Nde eremanõ ta me'ẽ te'e” aja Jesu pe pandu ta tipe. Anĩ. Mahem ym. ");
INSERT INTO urbNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Amõ amõ pu'am. Te'e pandu, Jesu rehe har. Te'eha juja ym, a'erehe marã ka ym Jesu pe pandu: “Nde katu ym. Nde eremanõ ta me'ẽ te'e” aja. ");
INSERT INTO urbNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pe, amõ sawa'e ta pu'am. Jesu rehe har te'e pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Kuja: —Kwehe Jesu pandu ame'ẽ ke rehe jahendu: “Kome'ẽ Tupã rehe ngã jumu'eha renda keruhũ ke sawa'e ta mujã. Ihẽ amai ta. Mokõi aker rahã, amõ ke ihẽ amujã ta. Ame'ẽ ke sawa'e mujã ym ame'ẽ ke. Ipo pe te'e mujã ym ame'ẽ ke” — aja jahendu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ame'ẽ sawa'e ta panduha juja ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pe, pa'i keruhũ pu'am. Heta ame'ẽ ta pyter pe pu'am. Jesu pe pandu: —Nde rehe har amõ ta je'ẽ je'ẽ hũ. Nde erepandu ym ta my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pandu ym riki Jesu. Pe, pa'i keruhũ pandu tĩ: —Kirisutu nde my? Kapitã keruhũ aja Tupã mu'am ame'ẽ ke nde my? Ngã pandu: “Nde riki katu te me'ẽ ke” aja Tupã pe. Ame'ẽ ra'yr nde my tĩ? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—A'e tỹ. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Tupã pyrãtã te hũ ame'ẽ ke a'e. Hake ihẽ awapyk ta aĩ. Ame'ẽ rehe pehẽ johu pesak ta kỹ. Ywa takãxĩha 'ar pe ihẽ apyrũ ta ajur. Ame'ẽ rehe pehẽ johu pesak ta kỹ tĩ — aja Jesu pandu. (“Tupã rake” aja Jesu pandu rahã: “Tupã a'e tĩ” aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Jesu pandu ame'ẽ ke rehe hendu rahã, pa'i keruhũ parahy ehe. A'erehe ima'e mundeha ke musak. (Aja rahã, Tupã parahy tĩ, aja mujekwa naĩ.) —Mã! Pehẽ johu pehendu riki. Peme'ẽ riki Tupã aja jupe. Katu ym aja. Peme'ẽ rehe har amõ ta pandu ame'ẽ ke japutar ym apo. Myja pekwa my? — aja pa'i keruhũ pandu. A'ep johu jy'ar ame'ẽ ta pandu: —Katu ym riki a'e. Manõ ta me'ẽ te'e — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","A'engi amõ ta tymũ ehe. Pan pe eha ke jupyk. Pe, hãtã ipo pe huwa ke nupã. Pandu ipe: —Awa nde ruwa nupã my? — aja Jesu pe. Hukwen harõha ta aja tĩ. Huwa ke nupã tĩ. Aja mahy Jesu ke. ");
INSERT INTO urbNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Soroka pe Petu ihĩ tĩ. Arahã pa'i keruhũma'e parakyha uhyk uwyr ehe. ");
INSERT INTO urbNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Petu rehe usak. Jumaku uĩ a'e. Kũjã usak katu ehe. Pe, pandu ipe: —Jesu namõ nde erexo ame'ẽ ke nde. Jesu Nasare ok ta pe har — aja Petu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Petu pandu: —Anĩ. Ihẽ akwa ym ehe har. Nde erepandu ame'ẽ ke akwa ym ihẽ — aja ipe. Pe, hukwen rake oho. Arahã sapukái je'ẽ. ");
INSERT INTO urbNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kũjã usak ehe tĩ. A'ep ixo ame'ẽ ta pe pandu: —Peme'ẽ riki amõ tĩ. Jumu'eha ta ngi har amõ tĩ — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petu te'e tĩ: —Anĩ. Aja ym ihẽ — aja pandu te'e. I'i atu rahã, a'ep i'ãi ame'ẽ ta pandu tĩ: —Jetehar te ke. Jumu'eha ta ngi har nde tĩ. Ngariréi ywy pe har je'ẽha aja nde ereje'ẽha, a'erehe inamõ nde erexo aja jakwa — aja Petu pe. ");
INSERT INTO urbNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pe, Petu kuja tĩ: —Jetehar te ke pehẽ pe apandu katu. Ihẽ akwa ym te ehe har. Jetehar te ke apandu ym rahã, mã peja ihẽ ke Tupã mahy — aja te'e pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pejot sapukái je'ẽ, mokõihar ame'ẽ. Pe, Jesu je'ẽha ke Petu ukwa ukwa u'am: “Sapukái mokõihar je'ẽ ym rahã we, mahapyr nde erepandu ta: ‘Jesu rehe har ihẽ akwa ym’ aja nde erepandu ta.” Ame'ẽ ke Petu ukwa ukwa u'am. Te'e pandu ramõ aja Petu ukwa katu, a'erehe jixi'u hũ a'e. ");
INSERT INTO urbNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pytuniwe te rahã, jundéu awa tama'e pa'ihu ta pandu pandu a'eta jupe. Jundéu awa tamũi ta namõ pandu pandu tĩ. Moise je'ẽha mu'e ame'ẽ ta namõ pandu pandu tĩ. Amõ sawa'e ukwa katu ame'ẽ ta namõ pandu pandu tĩ. Johu ame'ẽ ta pandu pandu a'eta jupe uĩ: —Homa awa tama'e kapitã pe Jesu ke jaraho. A'e riki jukwaha ke pandu ta — aja. Pe, Jesu po apyr ipixi'a koty pukwar. Pe, kapitã pe raho. Her Pirat. ");
INSERT INTO urbNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jesu pe Pirat pandu: —Jundéu awa tama'e kapitã keruhũ nde my? — aja. —A'e tỹ — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pa'ihu ta te'e je'ẽ je'ẽ hũ: —Ma'e ka'u te'eha ke peme'ẽ ma'ema'e hũ — aja Pirat pe. ");
INSERT INTO urbNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","A'erehe ame'ẽ rehe har Jesu pe Pirat pandu tĩ: —Mã! Mãte nde rehe har ngã je'ẽha ke. Nde juehe har nde erepandu ym ta my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Anĩ. Jesu pandu ym te ipe tĩ. A'erehe Pirat jeje ipy'a pe ukwa ukwa u'am: —Mã! Ma'ewã je'ẽ ym my? — aja ipy'a pe. ");
INSERT INTO urbNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pasuko 'ar rahã, ngã mi'u ke jundéu awa ta matyr. Arahã pame katu te kyndaha ngi peteĩ sawa'e ke Pirat muhem ta. Te'e poir. Ngã pandu ame'ẽ sawa'e ke poir. ");
INSERT INTO urbNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Arahã kyndaha pe amõ sawa'e ixo. Her Mahamba. Homa awa tama'e kapitãma'e sonda ta namõ jumai. Ame'ẽ ta namõ ixo, kyndaha pe. Amukwehe kapitãma'e sonda ta namõ jumai rahã, amõ sawa'e ke Mahamba jukwa. (A'erehe kyndaha pe ixo.) ");
INSERT INTO urbNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pirat rehe ngã uhyk. Pandu ipe: —Kome'ẽ wera rahã, kyndaha ngi sawa'e ke nde eremuhem. Kome'ẽ wera rahã pame katu te nde erepoir. Aja sawa'e ke epoir emondo apo tĩ — aja Pirat pe. ");
INSERT INTO urbNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Jesu rehe hetaha ta ipy'a katu aja pa'ihu ta ukwa. A'erehe Jesu rehe jundéu awa tama'e kapitã ta jyty'ym aja Pirat ukwa katu tĩ. A'erehe Jesu ke pa'ihu ta werur ipe, aja Pirat ukwa katu tĩ. A'erehe Pirat pandu: —Awa peputar my? Jundéu awa tama'e kapitã keruhũ ke ihẽ apoir te'e ta my? — aja a'eta pe. ");
INSERT INTO urbNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Anĩ. Ngã ke pa'ihu ta muparahy. Aja muka'u te'e ngã ke. Ngã pe pandu: —“Mahamba ke te'e emuhem” aja Pirat pe peme'u — aja pa'ihu ta pandu. A'erehe ngã pandu: —Mahamba ke te'e emuhem — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ngã pe Pirat pandu tĩ: —Jundéu awa tama'e kapitã keruhũ aja Jesu rehe har amõ ta pandu. Myja ihẽ ama'e ta my? — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Hãtã ngã pukái: —Myra ngã mupia ame'ẽ ke rehe ejukwa — aja ngã pukái. ");
INSERT INTO urbNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—Ma'erehe my? Ma'e ka'u te'eha ke a'e ma'e ym te. Jukwa rahã, katu ym — aja Pirat. Anĩ. I'ar koty te we ngã pukái hũ: —Myra ngã mupia ame'ẽ ke rehe ejukwa — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Hetaha ta ke Pirat muhury tar katu. A'erehe kyndaha ngi Mahamba ke te'e muhem. Pe, sonda ta pe Pirat pandu: —Jesu ke pepirok — aja. (Pirok rahã, jukwa ta ame'ẽ ke a'e, aja mujekwa katu.) Upa Jesu ke sonda ta pirok rahã, ame'ẽ sonda ta pe Pirat me'ẽ. Ame'ẽ ta myra ngã mupia ame'ẽ ke rehe jukwa ta raho. ");
INSERT INTO urbNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Homa awa tama'e kapitã rok wyr pe Jesu ke sonda ta raho, ma'e renda pe, pereto renda pe. Sonda ta pyta we ame'ẽ ta pe pukái tĩ. —Pejur — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pan pytangwer ame'ẽ ke pe Jesu ke pukek. (Kapitã keruhũma'e aja saka pan pytangwer.) Iãkã rehe har moĩ ehe tĩ. (Kapitã keruhũma'e aja saka tĩ.) Ame'ẽ iãkã rehe har sonda ta japekã rãkã ke te'e mujã. Ame'ẽ ke moĩ ehe. ");
INSERT INTO urbNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pe, puka puka hũ ehe. —Nde katu. Jundéu awa tama'e kapitã keruhũ nde — aja sonda ta puka puka hũ ehe. ");
INSERT INTO urbNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","U'ywa aja me'ẽ pe iãkã ke nupã, japekã rãkã 'ar pe. (Aja mahy.) Tymũ ehe tĩ. (Aja rahã, jaxer ai ame'ẽ ke a'e aja mujekwa naĩ.) Ipynarãi pe sonda ta wapyk tĩ. (Aja rahã, sawa'e katu te ame'ẽ ke kohĩ, a'erehe hendu katu ehe aja mujekwaha naĩ.) Pe, pandu: —Nde katu te — aja sonda ta puka puka hũ ehe. ");
INSERT INTO urbNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Upa puka puka hũ ehe rahã, pan pytangwer jo'ok ingi, Jesu ngi. Ima'e mundeha mujywyr ipe. Pe, myra ngã mupia ame'ẽ ke rehe jukwa raho. ");
INSERT INTO urbNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jukwaha renda koty ngã raho reko rahã, amõ sawa'e wata oho ixo tĩ. Her Simã. Syre ok ta pe har ke a'e. Mokõi ta'yr ipe. Ta'yr rer Arexan. Amõ Hu. Amõ renda ngi hok pe Simã jywyr ixo. Arahã sonda ta pandu ipe: —Kome'ẽ myra ngã mupia ame'ẽ ke eraho, Jesuma'e ke — aja ipe. Pe, Simã jixi'y 'ar pe moĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pe, Ngóu renda pe Jesu ke muhyk raho. Ame'ẽ renda pe usak rahã, awa ãkã kangwer 'ã aja saka. ");
INSERT INTO urbNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","A'ep kawĩ namõ mi puhã mupara. Ame'ẽ puhã ahyha ke muputu'u we ta. Ame'ẽ kawĩ Jesu pe me'ẽ ta tipe. Anĩ. U'u ym a'e. ");
INSERT INTO urbNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pe, myra ngã mupia ame'ẽ ke rehe Jesu ke sonda ta mujar mu'am. (Itapywa pe mujar mu'am.) Pe, ima'e mundeha ke sonda ta pyhyk pyhyk raho. Ita pinim ra'yr ke sonda ta ombor ixo. Awa ombor, pe, pinĩha i'ar koty te we u'ar rahã, a'e riki mundeha ke pyhyk. Aja Jesuma'e mundeha ke sonda ta pyhyk pyhyk raho. ");
INSERT INTO urbNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Warahy uhemiha koty ywa ku'a tate rahã, myra ngã mupia ame'ẽ ke rehe Jesu ke sonda ta mujar mu'am. ");
INSERT INTO urbNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ma'erehe Jesu ke jukwa my, ame'ẽ ngã ukwaha ke iãkã 'ar koty Pirat mupinim. Kuja: “Jundéu awa tama'e kapitã keruhũ kome'ẽ” aja mupinim. ");
INSERT INTO urbNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ame'ẽ renda pe mokõi ma'e mukanĩha ta ke sonda ta mujar mu'am tĩ, myra ngã mupia ame'ẽ ke rehe. Ko Jesu jywa katu koty peteĩ. Amõ ijywa'i koty mujar mu'am. ");
INSERT INTO urbNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yman Tupã je'ẽha ke amõ mupinim. Aja uhyk apo 'y. Kuja: “Ma'e ka'u te'eha ke ma'ema'e, ame'ẽ ke ngã mupyrara. Ame'ẽ ta namõ a'e ke ngã mupyrara ta tĩ” aja amõ mupinim. ");
INSERT INTO urbNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","A'ep wata ame'ẽ ta puka puka hũ ehe. Iãkã ke ngã mukatak katak hũ ipe tĩ, aja puka puka hũ ehe. Pandu tĩ: —Mã! Nde erepandu: “Tupã rehe ngã jumu'eha renda keruhũ upa ihẽ amai ta. Pe, mokõi aker rahã, amõ amujã ta” aja nde erepandu. ");
INSERT INTO urbNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pengi ejujo'ok ewyjy! Myra ngã mupia ame'ẽ ngi ewyjy ejur! Aja rahã, nde eremanõ ym ta! — aja ngã puka puka hũ ehe. ");
INSERT INTO urbNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aja jundéu awa tama'e pa'ihu ta puka puka hũ ehe tĩ. Moise je'ẽha mu'e ame'ẽ ta aja tĩ. Puka puka hũ ehe tĩ. Upa ame'ẽ ta pandu pandu a'eta jupe: —Mã! Amõ ta ke a'e mukatu hũ. (A'erehe manõ ym.) Apo jumumanõ ym juehe. ");
INSERT INTO urbNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","A'e Kirisutu rahã, myra ngã mupia ame'ẽ ngi ewyjyrahã! Tupã mu'am ame'ẽ ke Kirisutu. A'e riki jundéu awa tama'e kapitã keruhũ rahã, ewyjyrahã! Aja rahã, jajurujar katu ta ehe — aja pa'ihu ta puka puka hũ ehe tĩ. Myra ngã mupia ame'ẽ ke rehe amõ mokõi sawa'e ta jixiko u'am tĩ. Ngã aja ame'ẽ ta puka puka hũ ehe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Warahy jandar rahã, ame'ẽ ywy rupi pytun oho. Warahy uwe riki. Aja te'e warahy ywa ku'ap ihon. ");
INSERT INTO urbNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Warahy ywa ku'a ihon rahã, hãtã Jesu pandu: —Eroi! Eroi! Rema samatani? — aja. Ame'ẽ jundéu awa ta je'ẽha kuja riki: —Tupã! Tupã! Ma'erehe ihẽ ke nde erehijar my? — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ame'ẽ je'ẽha rehe a'ep ixo ame'ẽ ta hendu rahã, amõ koty ukwa. A'erehe pandu: —Pehendurahã! Eri pe pukái — aja ukwaha naĩ. (Ymanihar Tupã je'ẽha pandu ame'ẽ ke Eri.) (Anĩ. Eri pe pukái ym.) ");
INSERT INTO urbNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Pe, amõ ujan oho. Mandeju aja me'ẽ namõ ma'e rykwer mupyta, kawĩ iro ym te ame'ẽ ke. Wina aja me'ẽ rykwer ke. Ame'ẽ ke myra rehe pukwar, pe, Jesu pe me'ẽ. Juru rehe mujar. Amõ pandu: —Anĩ we rĩ. Eharõ we. Jasarahã! Myra ngã mupia ame'ẽ ngi Eri jo'ok ta uwyr my. Jasak ta — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesu ahem hũ. Pe, manõ. ");
INSERT INTO urbNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tupã rehe ngã jumu'eha renda keruhũ pe pan rãtã ke te'e hukwen ke kynda mu'am. Ame'ẽ ihĩ. Ame'ẽ riki ywate ngi owok riki. Iwyr rehe owokiha upa uhyk oho. (Aja rahã, Tupã koty ohoha katu apo aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Amõ sonda tama'e kapitã myra ngã mupia ame'ẽ koty i'ãi. Jesu ahem hũ, pe, manõ. Myja manõ my. Ame'ẽ rehe usak. A'erehe pandu: —Jetehar te ke. Tupã ra'yr te peme'ẽ sawa'e — aja. ");
INSERT INTO urbNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Amukwehe Jerusarẽ ok ta hũ pe heta kũjã ta Jesu namõ uhyk uwyr. Paite ngi ame'ẽ ta Jesu rehe usak u'am, myra ngã mupia ame'ẽ ke rehe. Ko Mari usak u'am. Mandare ok ta ngi ame'ẽ. A'erehe Mari Mandare aja her. Amõ kũjã Sarome. Amõ Mari usak u'am tĩ. Ame'ẽ Jose mãi. Tian mãi tĩ. Ame'ẽ Tian sawa'e pyahu aja her tĩ. Amukwehe Ngariréi ywy pe Jesu wata ixo rahã, ame'ẽ kũjã ta inamõ wata tĩ. Amõ heta kũjã ta inamõ wata tĩ. Arahã Jesu ta namõ ma'e ke a'eta ma'ema'e katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Pytun tate apo. Ngã mi'u matyr, ame'ẽ weraha tate upa aha oho. Jundéu awa tama'e putu'uha 'ar uhyk tate. Ame'ẽ wera rahã, jundéu awa ta putu'u ta. (Paraky ym te ta.) Pe, amõ sawa'e ixo. Her Jose. Arimatéi ok ta pe har ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Sawa'e katu ame'ẽ ke a'e, aja jundéu awa tamũi ta ukwa. Jesu kapitã keruhũ te aja Tupã mu'am ta, ame'ẽ rehe Jose harõ katu tĩ. A'erehe Tupã koty ipy'a ke a'e muruwak. Ame'ẽ Jose ipy'ahu, pe, Pirat rehe uhyk. Pandu ipe: —Jesu rete ke ihẽ aputar. Amou ta araho — aja Jose. ");
INSERT INTO urbNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pirat pandu jupe: “Mã! Manõ te apo my?” aja jupe. A'erehe miasu pe pandu: —Sonda tama'e kapitã ke emuhyk se — aja. Sonda tama'e kapitã uhyk rahã, Pirat pandu ipe: —Jesu manõ apo my'y? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","—Manõ riki 'y — aja kapitã. ");
INSERT INTO urbNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jesu rete ke Pirat me'ẽ, Jose pe. Jose oho ingi. Pe, Jesu rete ke mujy werur, myra ngã mupia ame'ẽ ngi. Muhepyha renda ngi pan tuwyr katu ame'ẽ ke jo'ok. Ame'ẽ pe Jesu rete ke pukek. Pe, itakwar keruhũ pe hete ke mou. Ita rupi hokwar keruhũ pykũi, ame'ẽ rupi mou. Pe, hukwen ke itahu pe Jose kynda. Mujere kynda. ");
INSERT INTO urbNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Kũjã ta mouha rehe usak u'am. Ko Mari usak u'am. Ame'ẽ Mari Mandare. Amõ Mari usak u'am tĩ. Ame'ẽ Jose mãi. ");
INSERT INTO urbNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jundéu awa tama'e putu'uha 'ar upa rahã, puhã pihe ame'ẽ ke Mari Mandare jo'ok oho. Sarome oho inamõ tĩ. Amõ Mari oho inamõ tĩ. Ame'ẽ Tian mãi. Puhã pihe ame'ẽ namõ Jesu rete ke mupihe ta. Aja te'eha jundéu awa ta ma'eha. ");
INSERT INTO urbNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pe, nomin pytuniwe rahã, itakwar keruhũ koty kũjã ta oho. Warahy uhem ramõ te mi rahã, oho. ");
INSERT INTO urbNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kwehe hukwen ke itahu pe amõ kynda. A'erehe kũjã ta oho ixo rahã, pandu pandu a'eta jupe: —Awa jande pe ame'ẽ itahu ke mujere jo'ok ta my? — aja a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Uhyk rahã, usak katu rahã, kyndaha ke hukwen rake túi. Itahu te kyndaha ke. ");
INSERT INTO urbNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pe, itakwar keruhũ pe ixe rahã, Tupã je'ẽha rahoha rehe kũjã ta usak. Sawa'e wan aja usak. Kũjã ta jywa katu koty wapyk uĩ. Kamixa puku namõ ixo. Ima'e ke ituwyr te! Pe, kũjã ta jumukahem ingi! ");
INSERT INTO urbNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kũjã ta pe pandu: —Pejumukahem ym ihẽ ngi. Jesu rete ke pekekar pexo. Nasare ok ta pe har a'e. Myra ngã mupia ame'ẽ ke rehe manõ a'e. Anĩ. Se nixói te a'e. Kwera katu uhem riki. Pesarahã! Mouha renda ke te'e ko. Nixói te Jesu se. ");
INSERT INTO urbNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Apo peho. Jumu'eha ta pe pepandu peho. Petu pe pepandu tĩ. Ngariréi ywy pe pehẽ ndutar koty Jesu oho ta. A'ep pehẽ johu pesak ta ehe. Aja kwehe pehẽ pe pandu: “Ngariréi ywy pe ihẽ aho py ta kỹ” aja johu pehẽ pe Jesu pandu — aja kũjã ta pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","A'erehe itakwar keruhũ ngi kũjã ta uhem oho. Ujan oho ingi. Ryrýi riki. Kyje! Mukahem tĩ. A'erehe ujan oho. Kyje hũ, a'erehe amõ ta pe pandu ym. ");
INSERT INTO urbNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nomin pytuniwe te rahã, Jesu kwera katu uhem. Mari Mandare pe jumujesak py. Amukwehe te ame'ẽ Mari py'a ngi ãjã ta ke Jesu muhem mondo. Kuja ãjã hetaha. Awa po wajar mokõi hetaha muhem mondo ingi. ");
INSERT INTO urbNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Upa Jesu rehe usak rahã, jumu'eha ta pe Mari pandu oho. Ame'ẽ ta pyai. Jixi'u tĩ. (Kweraha ukwa ym we rĩ, a'erehe pyai we rĩ. Jixi'u we rĩ.) ");
INSERT INTO urbNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ame'ẽ ta pe pandu: —Jesu kwera katu uhem! Ihẽ asak ehe — aja Mari. Anĩ. Mari je'ẽha rehe ame'ẽ ta jurujar ym. ");
INSERT INTO urbNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ajame'ẽ ke Jerusarẽ ok ta ngi mokõi sawa'e ta wata oho ixo rahã, Jesu uhyk uwyr a'eta rehe. A'eta usak ehe rahã, amõ koty saka, a'erehe usak py rahã, Jesu ke ukwa ym. ");
INSERT INTO urbNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pe, ukwa katu rahã, amõ ta rehe ame'ẽ mokõi sawa'e ta jywyr oho. Pandu: —Jesu kwera katu riki! Jande jasak ehe! — aja riki mokõi sawa'e ta pandu. Anĩ. Ame'ẽ je'ẽha rehe jumu'eha ta jurujar ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","I'i atu rahã, awa py peteĩ jumu'eha ta rehe Jesu uhyk uwyr 'y. Ame'ẽ ta ma'e ke u'u uĩ. Jesu rehe a'eta usak. Jesu pandu a'eta pe: —Mã! Pejurujar ym riki amõ ta je'ẽha rehe. Ihẽ akwera katu rahã, amõ ta ihẽ rehe usak. Ame'ẽ ta je'ẽha rehe pejurujar ym. Mã! Katu ym aja. Jumen jurupy hãtã, aja pehẽ. Pehendu tar ym — aja jumu'eha ta pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","16","Jesu pandu tĩ: —Upa kome'ẽ ywy keruhũ pe har ta pe myrandu katu ke pepandu pandu peho. Ihẽ rehe amõ jurujar katu. Pe, ame'ẽ ke amõ mujahuk. (Aja rahã, ihẽ kotyhar ke, aja mujekwa.) Ihẽ rehe jurujar katu ame'ẽ ke Tupã muhã katu ta. Ame'ẽ myrandu katu ke pepandu pandu peho. Amõ jurujar katu ehe rahã, Tupã muhã katu ta. Amõ jurujar ym rahã, ame'ẽ ke Tupã mupyrara ta. ");
INSERT INTO urbNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ihẽ rehe jurujar katu ame'ẽ ta ma'e ke ma'ema'e ta. Pyrãtã te ha ke Tupã muwyr, ame'ẽ namõ ma'e ke ma'ema'e ta. Marã ka ym amõ ma'eha, ame'ẽ ke ma'ema'e katu ta. Aja rahã, Tupã inamõ ixo, aja mujekwa ta ngã pe. Ko ihẽ je'ẽha rupi ãjã ta ke muhem ta mondo. Amõ koty koty awa ta je'ẽha ke pandu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Pe, mbói ahy hũ ame'ẽ ke pyhyk tar ym ha rupi pyhyk rahã, mbói jukwa ym ta. Ma'e ahy ame'ẽ rykwer ke putar ym ha rupi u'u rahã, manõ ym ta tĩ. Ma'e ahy ixo ame'ẽ ta ãkã rehe ipo mujar. Aja rahã, katu ta oho ipe — aja jumu'eha ta pe Jesu pandu katu. ");
INSERT INTO urbNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesu riki jandema'e sawa'e te. Jumu'eha ta pe upa pandu rahã, ywa pe Jesu ke Tupã mujywyr raho. Hake wapyk oho. (Aja rahã, katu te ame'ẽ ke a'e, aja a'e mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ajame'ẽ ke upa katu te awa ta renda rupi jumu'eha ta pandu pandu oho. Tupã je'ẽha ke pandu pandu raho. Ame'ẽ ta je'ẽha ke jetehar te ke, aja jandema'e sawa'e te mujekwa. Jumu'eha ta pe pyrãtã te ha ke muwyr. A'erehe marã ka ym amõ ma'eha, ame'ẽ ke jumu'eha ta ma'ema'e katu. Aja je'ẽha riki jetehar te ke aja mujekwa katu ngã pe. Upa.");
INSERT INTO urbNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teo! Nde riki katu me'ẽ ke. Ko paper pinim nde pe ihẽ amondo axo. Ihẽ Ruk. Jumu'eha ta namõ Jesu ixo rahã, a'e ma'ema'e, ame'ẽ ke rehe ngã usak. Ame'ẽ rehe har amõ ta mupinim, aja nde erekwa katu. Myrandu rehe hendu ame'ẽ ke upa amõ mupinim katu. ");
INSERT INTO urbNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jesu ma'ema'eha rehe usak py, ame'ẽ ta pandu pandu jande pe. Ame'ẽ ta riki myrandu katu ke pandu pandu raho tĩ. Ame'ẽ ke amõ ta hendu. Pe, ame'ẽ ke amõ ta mupinim. ");
INSERT INTO urbNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ihẽ aja tĩ. Jesu ma'ema'eha rehe har amõ ta pandu py. Ame'ẽ ta rehe ihẽ ahendu katu te tĩ. A'erehe nde pe ihẽ amupinim rahã, jetehar te ke aja nde erekwa katu. Ma'e ke Jesu ma'e py, ame'ẽ ke ihẽ amupinim aĩ. A'engi mokõihar a'e ma'e, ame'ẽ ke ihẽ amupinim aĩ tĩ. A'engi mahapyrihar a'e ma'e, ame'ẽ ke amupinim aĩ tĩ. A'engi aja te'e a'e ma'ema'e ixo ame'ẽ ke ihẽ amupinim aĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ko nde pe ihẽ amupinim aĩ, a'erehe nde erekwa katu te ta. Nde ke amõ mu'e mu'e katu, ame'ẽ rehe har nde erekwa katu te ta tĩ. Jetehar te ke aja nde erekwa katu te ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ero riki jundéi ywy pe har tama'e kapitã rahã, amõ sawa'e ixo. Her Sakari. A'e jundéu awa tama'e pa'i. Ambi kotyhar ke a'e tĩ. Hakehar rer Isambe. Jundéu awa tama'e pa'i rajyr a'e tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Katu ame'ẽ ta ke a'eta. Aja Tupã ukwa katu tĩ. Tupã je'ẽha rehe a'eta hendu katu te tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Isambe imembyr ym te, a'erehe a'eta ta'yn ym. A'e riki a'i te. Ixawa'e tamũi te tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Amõ wera rahã, pa'ima'e ma'ema'eha ke Sakari kotyhar ta ma'ema'e ixo. A'erehe Tupã rehe ma'e ke Sakari ma'ema'e ixo tĩ, ame'ẽja saka. Parakyha rehe ohoha ke pa'i ta manga manga. “Awa oho ta my?” aja manga manga rahã, Sakari rehe uhyk oho. A'erehe Sakari riki paraky oho. A'erehe Tupã rehe ngã jumu'eha renda keruhũ pe Sakari ixe oho. A'ep ma'e pihe katu ame'ẽ ke hapy oho. (Aja Tupã rehe ipy'a ke moĩ moĩ ngã.) ");
INSERT INTO urbNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ma'e pihe katu ame'ẽ ke Sakari hapy u'am rahã, Tupã namõ heta jundéu awa ta pandu pandu u'am. Henda keruhũ soroka pe pandu pandu u'am. ");
INSERT INTO urbNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pe, Tupã je'ẽha rahoha uhyk uwyr ehe, Sakari rehe. Ma'e piheha hapyha renda rake pu'am u'am. Sakari jywa katu koty pu'am u'am. ");
INSERT INTO urbNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pe, Sakari usak ehe rahã, jumukahem ingi. (Sakari harõ ym ha rupi uhem, a'erehe kyje ingi.) ");
INSERT INTO urbNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pe, Tupã je'ẽha rahoha pandu ipe: —Sakari! Ekyje ym ihẽ ngi! Tupã pe nde erepandu: “Ihẽ pe ihẽ ra'yr emuwyr” aja nde erepandu Tupã pe. Ame'ẽ ke a'e ukwa katu. A'erehe nde rakehar imembyr ta kỹ'y. Sawa'e ra'yr u'ar ta kỹ. U'ar rahã: “Juã” aja her emoĩ ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","U'ar rahã, nde rury katu te ta. Heta ngã hury katu te ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Sawa'e katu ame'ẽ wan ta a'e, aja Tupã ukwa katu tĩ. Kawĩ u'u ym ta me'ẽ te'e a'e. Kawĩ aja muka'u ame'ẽ ke u'u ym ta me'ẽ te'e tĩ. Ta'yn rahã har ipy'a rehe Tupã'ã ihĩ katu ta. ");
INSERT INTO urbNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Heta jundéu awa ta py'a ke Tupã koty a'e muruwak ta mondo. Tupã riki jandema'e sawa'e te. ");
INSERT INTO urbNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tupã je'ẽha ke a'e pandu pandu ta oho tĩ. Yman Eri Tupã je'ẽha pandu ame'ẽ ke a'e. Ame'ẽ Eri aja pyrãtãha ke Tupã muwyr ta ipe tĩ, Juã pe tĩ. Eri aja ma'e katu ame'ẽ ke ma'ema'e ta tĩ. Kuja ta tĩ. Ipái namõ ta'yr ke a'e muhury katu ta tĩ. Katu ame'ẽ ke ukwa katu, ame'ẽ ta ma'ema'e. Ame'ẽ ta koty hendu ym ame'ẽ ta ke a'e muruwak ta mondo tĩ. Aja rahã, katu ame'ẽ ke a'eta ma'ema'e ta tĩ. Aja jandema'e sawa'e te rehe ngã py'a ke a'e muruwak ta. Aja rahã, huryha namõ sawa'e te rehe harõ ta ngã — aja ta'yn wan ta ame'ẽ rehe har Tupã je'ẽha rahoha pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Pe, Sakari pandu ipe: —Myja ihẽ ra'yr ta my? Myja ihẽ akwa ta my? Ihẽ riki tamũi te. Ihẽ rakehar a'i te tĩ. A'erehe imembyr ym ta, aja akwaha — aja Sakari pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Pe, Tupã je'ẽha rahoha pandu: —Ihẽ rer Ngambie. Tupã pandu ame'ẽ ke ihẽ ama'ema'e. Ima'e miasu ke ihẽ. Nde koty ihẽ ke a'e muwyr. A'erehe nde pe Juã u'ariha rehe har ihẽ apandu ajur. ");
INSERT INTO urbNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Esarahã! Angaha rehe uhyk rahã, ihẽ apanduha aja me'ẽ uhyk ta kỹ. Apo ihẽ apandu ame'ẽ ke rehe nde erejurujar ym, a'erehe ne je'ẽha kanim ta oho. Ta'yn u'ar ym rahã we, aja nde erexo ta tĩ — aja Sakari pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pe, Tupã rehe ngã jumu'eha renda keruhũ soroka pe heta ngã harõ u'am. I'i atu we harõ u'am. Kuja ipy'a pe ngã ukwa u'am: —Mã! I'i we Sakari pyta u'am. Jumu'eha renda keruhũ pe pyta hũ. Ma'ewã my? — aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pe, Sakari uhem uwyr rahã, marã ka ym je'ẽha ke uhemiha ipe. A'erehe jumu'eha renda keruhũ pe ixeraiha aja usak, aja ngã ukwa. Je'ẽha uhem ym, a'erehe ipo te'e ngã pe a'e pandu 'y. Ma'e usak, ame'ẽ ke ngã pe ipo te'e pandu 'y. ");
INSERT INTO urbNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","24","Pe, jumu'eha renda keruhũ pe pa'ima'e ma'ema'eha ke a'e ma'ema'e we rĩ. Ima'e ma'eha upa rahã, hok pe jywyr oho, hakehar koty, Isambe koty. Pe, heta ym ukwer rahã, hakehar imembyr. Pe, awa po peteĩ jahy rahã, hok pe te'e ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Pandu: —A'eramõ ihẽ membyr. Ihẽ rehe Tupã ipy'a katu. Yman ihẽ membyr ym te ihẽ, a'erehe ihẽ ke amõ kũjã ta muhuxĩ. Apo ihẽ rehe Tupã usak katu. A'erehe ihẽ membyr ym ha ke a'e mukanim apo 'y — aja Isambe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Isambe pusu tiha oho ixo. Awa po wajar peteĩ jahy kanim. Arahã ima'e je'ẽha rahoha ke Tupã muwyr. Her Ngambie. Nasare ok ta pe muwyr. Ame'ẽ ok ta Ngariréi ywy rehe ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kũjã koty muwyr. Her Mari. Amõ sawa'e pe ipái pandu katu ame'ẽ ke a'e. Jumendar ta. Sawa'e rer Jose. Ndawi rainõ a'e. Ame'ẽ Ndawi ymanihar kapitã keruhũ. ");
INSERT INTO urbNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pe, kũjã rehe Ngambie uhyk rahã, pandu ipe: —Ko ajur. Nde rehe Tupã katu usak. Ne namõ a'e ixo katu — aja Mari pe. ");
INSERT INTO urbNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ame'ẽ ke rehe Mari hendu rahã, ma'erehe ym ukwa. Ipy'a pe kuja ukwa ixo: —Mã! Ma'erehe ihẽ pe aja pandu my? — aja jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tupã je'ẽha rahoha pandu ipe: —Mari! Ekyje ym ihẽ ngi. Nde rehe Tupã katu usak. ");
INSERT INTO urbNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Esarahã! Ne membyr ta apo kỹ. Sawa'e ra'yr ta kỹ. U'ar rahã, her emoĩ ehe: “Jesu” aja. ");
INSERT INTO urbNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A'e riki katu te ame'ẽ ke a'e. “Tupã ra'yr” aja riki her tĩ. Tupã ywate te ixo, ame'ẽ ra'yr ke a'e. Kapitã keruhũ aja a'e mu'am ta tĩ. Ndawi aja mu'am ta a'e ke tĩ. Ndawi ymanihar hamũi ke. ");
INSERT INTO urbNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jesu jundéu awama'e kapitã keruhũ wan ta. Aja te'e ta ixo a'e. Kapitã keruhũ aja te'e ta ixo. Ame'ẽ ke upa ym ta — aja Tupã je'ẽha rahoha pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari pandu ipe: —Myja ihẽ membyr ta apo my? Ihẽ axo te'e me'ẽ te'e ihẽ — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tupã je'ẽha rahoha pandu: —Nde rehe Tupã'ã ihĩ katu ta kỹ. Tupãma'e pyrãtãha ne namõ ixo katu ta kỹ. A'erehe ne membyr ta kỹ, pe, ta'yn u'ar rahã, ame'ẽ riki katu te ame'ẽ ke ta. “Ihẽ ra'yr” aja Tupã pandu ta. ");
INSERT INTO urbNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Esarahã! Ne anam rehe har ekwa ekwa e'am. Her Isambe. Ehe har amõ ta pandu: “Imembyr ym te ame'ẽ ke a'e” aja. Apo anĩ. A'e riki imembyr apo 'y. Awa po wajar peteĩ jahy kanim ipe. A'i rahã, imembyr. ");
INSERT INTO urbNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tupã putar rahã, upa katu te ma'e ke a'e ma'ema'e katu — aja Mari pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Pe, Mari pandu: —A'e tỹ. Tupã pandu ame'ẽ ke ihẽ ama'e ta. Tupãma'e miasu aja ihẽ. Nde erepandu, aja mã peja ihẽ rehe uhyk katu — aja ipe. Pe, Tupã je'ẽha rahoha oho ingi. ");
INSERT INTO urbNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Heta ym ukwer rahã, ima'e ke Mari munde katu. Pe, pahar amõ ok ta pe oho. Isambe rehe usak oho. Ywy'ã ty rupi ame'ẽ ok ta ihĩ. Ame'ẽ ok ta Jundéi ywy rehe ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pe, Sakari rok rehe uhyk oho rahã, Isambe pe pandu: —Se te'e ihẽ asak ta ajur — aja Mari ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ame'ẽ rehe Isambe hendu rahã, ipusu pe imembyr katak katu. Pe, Isambe py'a rehe Tupã'ã ihĩ katu. ");
INSERT INTO urbNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Hãtã Isambe pandu: —Mã! Kũjã ta ngi har nde rehe jõ Tupã katu te usak. Nde pusu pe ne membyr ihĩ, ame'ẽ rehe Tupã katu usak tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nde riki ihẽma'e sawa'e te mãi wan ta. Ihẽ rehe nde eresak erejur. Mã katu! Ihẽ rehe Tupã katu usak tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nde erepandu: “Se te'e ihẽ asak ta ajur” aja. Ame'ẽ rehe ihẽ ahendu rahã, ihẽ pusu pe ihẽ membyr katak katu. (Hury katu, a'erehe katak katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tupã je'ẽha ke Tupã je'ẽha rahoha pandu nde pe. Aja nde rehe uhyk ta kỹ. Ame'ẽ rehe nde erejurujar katu, a'erehe nde riki nde rury katu te — aja Isambe pandu ipe, Mari pe. ");
INSERT INTO urbNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Pe, Tupã rehe har Mari pandu: —Ihẽma'e sawa'e te riki katu te ame'ẽ ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","A'e riki ihẽ muhãha, a'erehe ihẽ rury katu ihẽ. ");
INSERT INTO urbNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Ima'e te'e aparaky ame'ẽ ke ihẽ. Ihẽ katu ym ihẽ jupe ihẽ. Ihẽ rehe a'e harái ym, a'erehe ihẽ rury katu ihẽ tĩ. Tupã riki pyrãtã te hũ ame'ẽ ke a'e. A'e riki katu te ame'ẽ ke tĩ. Ma'e katu te ame'ẽ ke ihẽ pe a'e ma'e, a'erehe apo har ngi upa ngã pandu ta: “Hury katu me'ẽ ke a'e” aja ihẽ rehe har. ");
INSERT INTO urbNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Upa katu te amõ ipy'a ke moĩ moĩ ehe. Ame'ẽ ta rehe pyrara a'e usak. Aja te'eha a'e. ");
INSERT INTO urbNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Amõ riki juehe jõ katu ame'ẽ ke jupe, aja ipy'a pe ukwa. Ame'ẽ ukwaha ke Tupã mukanim ingi. ");
INSERT INTO urbNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Henda ngi kapitã keruhũ ke a'e mutyryk. “Katu ym ihẽ jupe” aja ukwa ame'ẽ ta pe a'e pandu: “Nde katu” aja. ");
INSERT INTO urbNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pyrara ame'ẽ ta pe ma'e ke a'e me'ẽ katu. Ima'ehũ namõ ixo ame'ẽ ta ke a'e mujywyr te'e ta mondo. Ipo te'e mujywyr mondo. ");
INSERT INTO urbNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Yman Tupã manga katu: “Yman rahã, jundéu awa ta namõ ihẽ axo ta” aja Tupã manga katu jande ramũi ta pe. Ame'ẽ panduha uhyk apo 'y. Jundéu awa ta namõ Tupã ixo katu 'y. Jundéu awa ta ipy'a moĩ moĩ katu ehe. Ame'ẽ ta namõ ixo katu. ");
INSERT INTO urbNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Amarã rainõ ta rehe a'e harái ym, jundéu awa ta rehe. Pyrara usak ngã rehe. Upa katu te hainõ ta rehe pyrara usak tĩ. Aja te'eha pyrara usak katu te ame'ẽ ke a'e — aja Mari pandu Tupã rehe har. ");
INSERT INTO urbNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Pe, mahapyr jahy rahã, Isambe namõ Mari pyta ixo rĩ. Upa rahã, a'engi hok pe jywyr oho. ");
INSERT INTO urbNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Imembyr u'ariha rehe uhyk oho 'y. Pe, Isambe membyr sawa'e ra'yr u'ar. ");
INSERT INTO urbNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tupã pyrara usak katu te ehe, aja ianam ta ukwa. Hok rake ihĩ ame'ẽ ta aja tĩ. Ukwa tĩ. A'erehe imãi ta namõ a'eta hury katu. ");
INSERT INTO urbNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Awa po wajar mokõi ukwer rahã, ta'yn rehe ihĩ ame'ẽ pirer ke a'eta jupã uwyr. (Aja te'eha jundéu awa ma'eha.) Arahã ipái rer ngi har amõ ta moĩ ta tipe. A'erehe: “Sakari” aja muher ta tipe. ");
INSERT INTO urbNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Imãi pandu: —Anĩ. “Juã” aja jamuher ta — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Amõ ta pandu ipe: —Ma'erehe: “Juã” aja my? Ne anam ta rer ngi har aja me'ẽ nixói te — aja imãi pe. ");
INSERT INTO urbNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Pe, ipái pe: —Myja her nde eremoĩ ta my? — aja ipo te'e ngã pandu ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Pe, ipo te'e ipái pandu: —Myrape ra'yr mupinim ame'ẽ ke erur — aja. Pe, amõ werur rahã, ipái mupinim. Her: “Juã” aja mupinim. A'erehe upa ngã pandu: —Mã! Juã tiki kome'ẽ ta'yn rer! Mã! — aja. ");
INSERT INTO urbNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ta'yn rer Sakari mupinim rahã, pahar je'ẽha uhem ipe. Je'ẽha jywyr tĩ. Pe, katu Tupã rehe har a'e pandu pandu u'am. ");
INSERT INTO urbNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ame'ẽ rehe hendu rahã, upa hok rake ihĩ ame'ẽ ta pandu: “Mã! Katu tiki!” aja. Tupãma'e pyrãtãha usak, a'erehe pandu: “Mã! Katu tiki!” aja. Pe, upa ame'ẽ rehe har upa ok ta rupi ngã pandu oho. Jundéi ywy'ã rupi ixo ame'ẽ ta rupi pandu oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ame'ẽ rehe upa hendu ame'ẽ ta ipy'a rehe ma'e ke ukwa ukwa ixo. Kuja. Ta'yn namõ Tupãma'e pyrãtãha ixo te, aja ngã ukwa, a'erehe pandu: —Mã! Sawa'e rahã, ma'e katu ame'ẽ ke kome'ẽ ta'yn ra'yr ma'ema'e ta kỹ — aja ngã ukwa. ");
INSERT INTO urbNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ipái py'a rehe Tupã'ã ihĩ katu, Sakari py'a rehe. Pe, Tupã je'ẽha ke Sakari pe mujekwa. A'erehe Sakari kuja pandu: ");
INSERT INTO urbNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Mã peja katu jandema'e sawa'e te rehe har japandu. Tupã a'e. Jundéu awa ta ipy'a moĩ moĩ katu ehe ame'ẽ ke a'e. Ixotyhar ta namõ Tupã ixo katu, a'erehe katu ehe har japandu. Jande ruwajan ta ngi a'e poir uwyr tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Jande muhãha pyrãtã te hũ ame'ẽ ke a'e, aja a'e ke Tupã mu'am tĩ. Ndawi rainõ ke a'e. Ndawi ymanihar ima'e miasu ke. ");
INSERT INTO urbNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","“Muhãha muwyr ta” aja ymanihar Tupã je'ẽha pandu ame'ẽ ta pandu. Ame'ẽ ta katu ame'ẽ ta ke. Ame'ẽ ta pe je'ẽha ke Tupã muwyr. Kuja ame'ẽ ta pandu tĩ: ");
INSERT INTO urbNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Pehẽ ruwajan ta ngi pehẽ ke muhãha mupoir ta. Upa pehẽ rehe parahy ame'ẽ ta ngi aja tĩ. Mupoir ta tĩ” aja. ");
INSERT INTO urbNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","“Jande ramũi ta rehe pyrara Tupã usak ta” aja a'e pandu. “Ymanihar manga katuha ke ihẽ akwa akwa ta axo. Ihẽ aharái ym ta” aja a'e pandu katu tĩ. Manga katuha katu te ame'ẽ ke ame'ẽ. ");
INSERT INTO urbNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ymanihar Amarã pe Tupã manga katu. Amarã ymanihar jande ramũi ke. Kuja Tupã manga katu te: “Pehẽ ruwajan ta ngi pehẽ ke ihẽ apoir ta, aja ihẽ amanga katu. Pehẽ ke ihẽ apoir ta, a'erehe ihẽ rehe pehẽ py'a pemoĩ moĩ katu ta. Ame'ẽ ta ngi pekyje ym ta 'y. Aja ihẽ rehe pehẽ py'a ke pemoĩ moĩ katu ta” aja Tupã manga katu te. ");
INSERT INTO urbNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Aja rahã, jande py'a juhyk. Aja Tupã rehe jande py'a jamoĩ moĩ katu ta. A'e pandu: “Pehẽ katu. Ma'e peka'u te'eha pema'ema'eha nixói te pehẽ pe” aja. A'erehe jande py'a jamoĩ moĩ katu ta ehe tĩ. Jande jaxo rahã, aja jande py'a jamoĩ moĩ katu ta ehe — aja Sakari pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A'e pandu tĩ: —Juã! Ihẽ ra'yr nde! Kuja nde pe Tupã pandu ta: “Ihẽ je'ẽha ke nde erepandu ta. Ywatehar ame'ẽ ke ihẽ” aja Tupã pandu ta. Jandema'e sawa'e te ndutar koty nde ereho py ta. Tupã koty ngã py'a ke nde eremuruwak ta eremondo. Aja rahã jandema'e sawa'e te uwyr rahã, ngã hendu katu ta ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kuja Tupã kotyhar ta pe nde erepandu ta. Jundéu awa ta pe nde erepandu ta: “Ma'e ka'u te'eha ke ngã ma'ema'e. Tupã ipy'a jywyr ta ngã rehe. Pe, a'eta ke Tupã muhã katu ta” aja nde erepandu ta ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Jande rehe Tupã pyrara usak. Jande rehe ipy'a katu tĩ. A'erehe jande pe muhãha ke a'e muwyr ta. ");
INSERT INTO urbNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Aja rahã, upa manõha ngi kyje, ame'ẽ ta ke a'e mu'e ta uwyr tĩ. (Aja rahã, kyje ym ta ngã.) Myja Tupã namõ jande juehe katu jaxo my, ame'ẽ ke a'e mu'e ta uwyr tĩ — aja Sakari pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pe, Sakari ra'yr tiha oho. Ipy'ahu ame'ẽ ke a'e. Ukwa katu te we oho tĩ. Sawa'e rahã, awa nixói te ame'ẽ pe ixo. Jundéu awa ta pe ma'e ke pandu ym we rĩ. A'erehe awa nixói te ame'ẽ pe pyta we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","3","Imãi pusu ngi Juã u'ar. A'engi mahapyr jahy kanim nahã my. Arahã amõ kapitã keruhũ je'ẽha ke mondo. Homa awa tama'e kapitã keruhũ mondo. Her Angu. Amõ amõ ywy pe har kapitã keruhũ a'e tĩ. Ame'ẽ rupi je'ẽha ke mondo. Kuja mondo: —Ngã hetaha ke ihẽ akwa ta. Myja ngã hetaha my? Myja hetaha ihẽ rehe hendu katu ame'ẽ ta ixo my? Akwa ta. A'erehe pehẽ rer ke pemapyk peho. Aja rahã ngã hetaha akwa ta — aja je'ẽha ke mondo. Ame'ẽ ke ngã hetaha mapyk py ame'ẽ ke. Arahã Sirẽ kapitã tĩ. Si ywy pe har tama'e kapitã ke a'e. Angu ke je'ẽha mondo, a'erehe her ke upa katu te ngã mapyk oho. Imãi pusu ngi u'ar, ame'ẽ ok ta pe ngã jywyr oho. A'ep her ke mapyk oho. ");
INSERT INTO urbNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","A'erehe Jose jywyr oho tĩ. Imãi pusu ngi u'ar, ame'ẽ ok ta pe jywyr oho. Ok ta rer Merẽ. Jundéi ywy rehe Merẽ ok ta ihĩ. Yman te a'ep Ndawi imãi pusu ngi u'ar tĩ. Jose Ndawi rainõ tĩ. A'erehe Merẽ ok ta pe a'e jywyr oho. A'ep Jose jywyr oho rahã, Nasare ok ta ngi uhem oho. Ngariréi ywy rehe Nasare ok ta ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Her ke Jose mapyk oho. Mari namõ oho. Mari ke ipái me'ẽ katu ta ame'ẽ ke a'e. Ipusu tiha te ipe. Imembyr u'ar tate. ");
INSERT INTO urbNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Merẽ ok ta pe a'eta ixo rahã, imembyr u'ariha angaha ke rehe uhyk oho 'y. ");
INSERT INTO urbNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","A'eta pe ukweriha renda nixói te. Amõ rok pe nixói te. Heta te hũ ngã ixo, a'erehe nixói te ukweriha renda ke. A'erehe tapi'iruhu renda pe ixe oho. Pe, imembyr py ame'ẽ ke u'ar a'ep. Sawa'e ra'yr riki. Pan pe imãi pukek. Pe, tapi'iruhu mi'u renda pe mou, myrakwar pe. ");
INSERT INTO urbNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Merẽ ok ta sorokap pe arapuharan ta usakiha ta ixo. Pytun rahã, arapuharan ta rehe usak usak u'am. Kãpĩ ty rupi usak usak u'am. ");
INSERT INTO urbNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pe, Tupã je'ẽha rahoha uhyk uwyr a'eta rehe. A'eta ixo ame'ẽ rupi wera hũ. Jandema'e sawa'e te muwera. (Aja rahã, Tupã a'ep ixo, aja mujekwa katu.) Wera hũ, a'erehe usakiha ta mukahem hũ! ");
INSERT INTO urbNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tupã je'ẽha rahoha pandu: —Pemukahem ym ihẽ ngi! Pehẽ pe myrandu katu ke ihẽ arur. Ame'ẽ muhury katu te ta pehẽ ke. Upa katu te ngã ke muhury katu te ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","A'eramõ Merẽ ok ta pe ta'yn ra'yr u'ar. Ndawi ambyr rekohama'e ke, aja ngã ukwa. A'ep ta'yn u'ar ramõ. Yman te a'ep Ndawi u'ar tĩ. Apo ame'ẽ Merẽ ok ta pe ta'yn ra'yr u'ar. Ame'ẽ ta'yn ra'yr Kirisutu. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e. Jandema'e sawa'e te wan ta a'e tĩ. A'e riki pehẽ ke muhã katu ta. ");
INSERT INTO urbNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kuja pekwa katu ta ehe har. Tapi'iruhu mi'u renda pe ta'yn ra'yr túi. Pan pe imãi pukek. Aja pesak rahã, ngã muhãha petúi aja pekwa katu ta — aja Tupã je'ẽha rahoha pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ame'ẽ ke upa pandu rahã, ywatehar ta uhem uwyr tĩ. Heta te hũ uwyr. Uwyr py Tupã je'ẽha rahoha rake uwyr. Upa Tupã rehe har katu a'eta pandu. Kuja: ");
INSERT INTO urbNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Ne jõ riki katu te me'ẽ ke. Nde riki ywatehar ke. Kome'ẽ ywy keruhũ pe har ta rehe nde rury katu. Ame'ẽ ta pe ipy'a huryha nde eremuwyr. (Aja rahã, katu ngã juehe ixo) — aja a'eta pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pe, ywa pe Tupã je'ẽha rahoha ta jywyr oho a'eta ngi. Arapuharan ta usakiha ta ngi jywyr oho. Upa jywyr oho rahã, arapuharan ta usakiha ta pandu pandu a'eta jupe: —Jasak jahorahã! Merẽ ok ta pe jasak jaho. A'eta pandu ame'ẽ ke rehe jasak jaho. Tupã riki jande pe mujekwa ame'ẽ ke rehe jasak jaho — aja pandu pandu a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","A'erehe pahar oho. Jose ta ke a'eta kekar oho. Mari ke kekar tĩ. Mahem rahã, ta'yn ra'yr rehe a'eta usak, imãi namõ, Mari namõ. Tapi'iruhu mi'u renda pe ta'yn ra'yr túi. ");
INSERT INTO urbNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pe, a'eta usak ehe rahã, upa Tupã je'ẽha rahoha pandu ame'ẽ ke a'eta pandu pandu ipái ta pe. Ta'yn ra'yr rehe har Tupã je'ẽha rahoha pandu, ame'ẽ ke a'eta pandu pandu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Arapuharan ta usakiha ta pandu, ame'ẽ ke rehe hendu ame'ẽ ta pandu: —Mã! Katu tiki! — aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Arapuharan ta usakiha ta pandu ame'ẽ ke Mari upa katu te ipy'a pe moĩ. Ame'ẽ ke harái ym ta. ");
INSERT INTO urbNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pe, arapuharan ta usakiha ta jywyr oho. Arahã Tupã rehe har a'eta katu pandu pandu oho ixo. “Ne jõ riki katu te me'ẽ ke” aja pandu oho ixo tĩ. Upa katu te a'eta hendu. Upa katu te a'eta usak tĩ. A'erehe Tupã rehe har katu a'eta pandu pandu oho ixo. Tupã je'ẽha rahoha mujekwa, aja ta'yn ra'yr rehe a'eta usak. ");
INSERT INTO urbNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Awa po wajar mokõi ukwer rahã, ta'yn ra'yr rehe ihĩ ame'ẽ pirer jupãha angaha rehe uhyk oho. Arahã: “Jesu” aja her ipái ta moĩ. Ame'ẽ her ke Mari pe Tupã je'ẽha rahoha mujekwa. Imembyr ym rahã we, ame'ẽ her ke mujekwa ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Pe, Mari ipy'a juhykiha ke rehe uhyk oho. Yman te Moise mupinim, aja juhykiha ke rehe uhyk oho. (Upa juhyk rahã, Tupã rehe ngã jumu'eha renda keruhũ pe Mari ixe katu ta tĩ.) Pe, ame'ẽ juhykiha upa rahã, Jerusarẽ ok ta pe ta'yn ra'yr ke a'eta raho. Jesu ke raho. Tupã ruwa koty raho, ame'ẽja saka a'e ta raho. A'erehe Tupã pe Mari ta pandu: “Kome'ẽ ta'yn jande pe nde eremuwyr. Ko nema'e ke” aja imãi ta. Yman te Moise pe Tupã mujekwa. Ame'ẽ ke Moise mupinim: “Sawa'e jepy ke Tupãma'e ke. Aja pame katu te ima'e ke” aja mupinim. ");
INSERT INTO urbNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Pe, Jose ta ma'e ke me'ẽ oho tĩ. Ma'e ke jukwa, aja ipy'a ke juhyk. Tupã je'ẽha ke Moise mupinim, aja Jose ta me'ẽ raho. Kuja me'ẽ raho. Mokõi pykahuran ta. Ame'ẽ nixói rahã, mokõi pykahuran ra'yr ta. Ame'ẽ ke jundéu awa tama'e pa'i pe me'ẽ raho. Ame'ẽ ke pa'i ta jukwa. Pe, hapy. Aja rahã Mari ipy'a juhyk katu, aja Tupã je'ẽha rehe panduha ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jesu ke Jose ta raho rahã, Jerusarẽ ok ta pe amõ sawa'e ixo. Her Simeã. Sawa'e katu ame'ẽ ke a'e. Tupã rehe ipy'a moĩ moĩ katu tĩ. Huwajan ta ngi jundéu awa ta ke amõ mupoir ta. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke muwyr ta. Ame'ẽ angaha ke rehe Simeã harõ ixo tĩ. Ipy'a rehe Tupã'ã ihĩ katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","28","Yman Tupã'ã mujekwa katu ipe: —Nde eremanõ ym ta rĩ. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke rehe nde eresak ym rahã we, nde eremanõ ym ta rĩ. Yman Tupã pandu: “Ihẽ amondo ta kỹ” aja riki. Ame'ẽ ke rehe nde eresak py ta kỹ — aja Simeã pe yman mujekwa. Apo Simeã pe mujekwa tĩ: —Tupã rehe ngã jumu'eha renda keruhũ pe eho apo 'y — aja ipe. A'erehe Simeã oho, Tupã rehe ngã jumu'eha renda keruhũ pe. A'ep ta'yn ra'yr ke Jose ta werur. Yman Moise mupinim, aja Tupã ruwa koty raho, ame'ẽja saka Jose ta werur. Arahã Simeã uhyk. Pe, usak. Pe, ta'yn ra'yr ke pyhyk. Ta'yn rer Jesu. “Ne jõ riki katu te me'ẽ ke” aja Tupã pe Simeã pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Pandu tĩ: —Sawa'e! Yman nde erepandu katu: “Kapitã keruhũ aja Tupã mu'am ame'ẽ ke rehe nde eresak ta kỹ” aja ihẽ pe. Aja uhyk apo 'y. Ihẽ asak 'y. A'erehe ihẽ rury katu. Ajaha ihẽ amanõ ta. Ihẽ riki nema'e miasu. ");
INSERT INTO urbNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ko ngã muhãha rehe ihẽ asak. Nde eremuwyr ame'ẽ ke rehe asak. Ihẽ atu asak katu. ");
INSERT INTO urbNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Heta ngã usak ta ehe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nde rehe har amõ awa ta pe a'e mujekwa ta tĩ. Jundéu awa aja ym ame'ẽ ta pe mujekwa ta. Aja rahã, katu jundéu awa ta rehe har amõ ta pandu ta tĩ. Jundéu awa ta nde kotyhar ta ke — aja Tupã pe Simeã pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ta'yn rehe har Simeã pandu. Ame'ẽ rehe har Jose ta hendu rahã, jupandu a'eta jupe: —Mã! Katu tiki! — aja ipy'a pe ukwa ukwa u'am. ");
INSERT INTO urbNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pe, Jose ta pe Simeã pandu: —Mã peja pehẽ rehe Tupã usak katu — aja. Imãi pe pandu tĩ: —Kome'ẽ ta'yn rehe Tupã usak katu. A'e pandu: “Ihẽma'e ko” aja. A'e uwyr, a'erehe heta jundéu awa ta ke kome'ẽ ta'yn muhã katu ta kỹ. Heta jundéu awa ta ke mupyraraha renda pe mondo ta kỹ tĩ. “Tupãma'e ko” aja ngã ukwa tĩ. A'erehe heta ngã je'ẽ je'ẽ hũ ta ehe har tĩ. Putar ym ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Aja ipy'a pe ma'e ka'u te'eha ma'ema'eha ke ngã ukwa ukwa ixo. Ame'ẽ ke amõ ukwa ym. Anĩ. Ame'ẽ ke ngã pe kome'ẽ ta'yn mujekwa ta kỹ tĩ. A'erehe ngã je'ẽ je'ẽ hũ ta ehe har. —Mari! Ne rahã tĩ. A'e ke ngã mupyrara ta tĩ, ame'ẽ ke rehe nde eresak ta tĩ, a'erehe nde ke mupyai ta kỹ tĩ — aja Mari pe Simeã pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","A'ep amõ kũjã ixo. Her An. Panue rajyr ke a'e. Ase ambyr rainõ ke a'e. A'i te apo 'y. Awa po wajar mokõi warahy 'ar rahã, ixawa'e namõ ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","(Pe, ixawa'e manõ.) Yman ixo te'e a'e 'y. Kuja, 84 warahy 'ar rahã, ixo te'e a'e 'y. Tupã rehe ngã jumu'eha renda keruhũ pe a'e ixo. Aja te'eha a'e. Tupã rehe ipy'a ke moĩ moĩ katu. Aja te'eha a'e. Tupã rehe ipy'a moĩ moĩ rahã, Tupã namõ pandu pandu katu. Ma'e u'uha ke hijar tĩ. (Aja ipy'a moĩ moĩ katu ehe tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","A'ep Jose ta ixo. Arahã An uhyk. Pe, Tupã pe pandu: —Ko nde eremuwyr ame'ẽ ke. Ihẽ asak ehe tĩ. Ne jõ riki katu te me'ẽ ke — aja An. Pe, amõ ta ixo. Huwajan ta ngi Tupã mupoir ta. Jundéu awa ta ke mupoir ta. Ame'ẽ angaha ke rehe a'eta harõ ixo. Ame'ẽ ta pe kuja An pandu tĩ: —Ko uwyr 'y. Tupã muwyr ame'ẽ ke ko — aja a'eta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tupã je'ẽha ke Moise mupinim. Aja upa ma'e rahã, Ngariréi ywy pe Jose ta jywyr oho. Hekoha pe uhyk oho. Hekoha rer Nasare ok ta. ");
INSERT INTO urbNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pe, ta'yn tiha oho ixo. Pyrãtã oho ixo tĩ. Tupã riki usak katu ehe. Ukwa katu ma'e oho ixo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Warahy 'ar rahã pame katu te Jerusarẽ ok ta pe Jose ta ohoho. Jundéu awa ta imi'u matyriha rehe usak oho. Jundéu awa tama'e mi'u matyriha weraha rer Pasuko. ");
INSERT INTO urbNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Awa py mokõi warahy 'ar ame'ẽ ke Jesu. Arahã Pasuko 'ar uhyk oho tĩ. Ame'ẽ pe Jose ta oho tĩ. Aja te'eha a'eta oho. ");
INSERT INTO urbNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pe, ngã mi'u matyriha upa rahã, hok pe a'eta jywyr wan oho. Jesu anĩ. Jerusarẽ ok ta pe a'e pyta we rĩ. Ame'ẽ ke Jose ta ukwa ym we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Johuha ta namõ a'e ixo, aja Jose ta ukwaha naĩ. A'erehe peteĩ wera rahã, a'eta wata oho. Pe, ka'aruk koty rahã, ianam ta rupi Jose ta kekar kekar tipe oho. Ehe katu ame'ẽ ta rupi kekar kekar tipe oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Anĩ. Mahem ym, a'erehe Jerusarẽ ok ta pe jywyr oho. A'ep kekar ixo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pe, mokõi ukwer rahã, mahem. Tupã rehe ngã jumu'eha renda keruhũ pe usak ehe. Jundéu awa ta mu'eha ta namõ Jesu wapyk uĩ. Mu'eha ta rehe hendu uĩ. Ame'ẽ ta pe pandu pandu uĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jesu pandu rahã, ukwa katu te ha namõ pandu. A'erehe upa hendu ehe ame'ẽ ta pandu: —Mã! My kome'ẽ kurumĩ ma'e ukwa katuha ukwa my! — aja. ");
INSERT INTO urbNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pe, Jose ta usak ehe rahã, ipy'a pe ukwa ukwa u'am tĩ. —Mã! Myja a'e ukwa katu my! — aja ukwa. Pe, imãi pandu ipe: —Jesu! Ma'erehe ko te'e nde ereĩ my? Nde ke akekar axo rahã, nde rehe ihẽ apyai te axo. Nde pái aja tĩ — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Pe, imãi ta pe Jesu pandu: —Ma'ewã ok ta rupi ihẽ ke pekekar pexo my? Ihẽ pái keruhũ rok pe ihẽ axo ta me'ẽ te'e, aja pekwa ta me'ẽ te'e — aja imãi ta pe Jesu. ");
INSERT INTO urbNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Anĩ. Ame'ẽ panduha rehe har imãi ta ukwa ym. (Tupã ra'yr a'e, aja imãi ta ukwa ym we rĩ, a'erehe Jesu panduha ke ukwa ym.) ");
INSERT INTO urbNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ajame'ẽ ke Nasare ok ta pe Jose ta namõ kurumĩ ra'yr jywyr oho. Jose ta rehe hendu katu. Upa katu te ipy'a pe imãi moĩ. Harái ym ta. ");
INSERT INTO urbNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Pe, Jesu sawa'e oho. Ukwa katu ma'e oho ixo tĩ. Tupã usak katu ehe tĩ. “Katu ame'ẽ ke a'e” aja ukwa. Aja ngã ukwa tĩ. “Katu ame'ẽ ke a'e” aja ngã pandu Jesu rehe har tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Awa py wajar upa warahy 'ar rahã, Timbe kapitã keruhũ. Ame'ẽ awa py wajar upa rahã, Juã pe ima'e je'ẽha ke Tupã muwyr. Arahã Jundéi ywy pe Pon Pirat kapitã. Ngariréi ywy pe Ero kapitã tĩ. Imu Ituréi ywy pe kapitã a'e tĩ. Takoni ywy pe aja tĩ. Imu rer Siri. Ambiri ywy pe Risa kapitã a'e tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Arahã Ana jundéu awa tama'e pa'i keruhũ. Kái pa'i keruhũ a'e tĩ. Arahã awa nixói te ame'ẽ pe Juã ixo. Juã Sakari ra'yr ke a'e. Pe, ima'e je'ẽha ke Tupã muwyr ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","A'erehe ame'ẽ ke ngã pe Juã pandu pandu oho. Y rymy'y rupi ok ta ihĩ ihĩ. Y rer Jondã. Ame'ẽ rupi Juã pandu pandu oho. Kuja ngã pe pandu: —Ma'e peka'u te'eha ke pema'ema'e. Ame'ẽ ke pehijar apo 'y. Pe, Tupã koty pehẽ py'a pemuruwak pemondo. Aja rahã, pehẽ rehe Tupã ipy'a jywyr ta. Aja rahã, pehẽ ke ihẽ amujahuk ta — aja ngã pe Juã. ");
INSERT INTO urbNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yman Tupã je'ẽha ke Isai mupinim. Isai Tupã je'ẽha pandu ame'ẽ ke a'e. Kuja a'e mupinim: “Ngã pe sawa'e pandu pandu u'am. Awa nixói te ame'ẽ pe pandu pandu u'am. Kuja: ‘Kapitã keruhũ uwyr tate rahã, pe ke amõ mukatu. Aja pehẽ pexoha ke pemukatu tĩ. Jandema'e sawa'e te uwyr ta, a'erehe pexoha pemukatu. ");
INSERT INTO urbNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pehu ke amõ mujã rahã, ywy'ã ke mupe. Ywy typy ame'ẽ ke mutyryhem tĩ. Pehu iapar rahã, mutatambyk tĩ. Ita heta rahã, jo'ok tĩ. Aja pehẽ tĩ. (Pehu ke mukatu, aja pexoha ke pemukatu tĩ. Aja rahã, ma'e peka'u te'eha pema'ema'eha ke pehijar. Tupã koty pehẽ py'a pemuruwak.) ");
INSERT INTO urbNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ngã muhãha ke Tupã muwyr. Aja rahã, myja me'ẽ ngã ke Tupã muhã katu ta my. Ame'ẽ ke upa ngã ukwa ta’ aja awa nixói te ame'ẽ pe ngã pe pandu pandu.” (Yman ame'ẽ Isai mupinim rahã, Juã rehe har mupinim.) ");
INSERT INTO urbNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Heta ngã Juã koty uhyk uwyr. Ok ta ngi uhyk uwyr ehe. Ngã pe Juã pandu: —Mã! Mbói aja pehẽ. (Kupixa ke amõ hapy rahã, mbói ujan oho.) Aja pehẽ tĩ. Tupã mupyraraha uhyk tate. Ame'ẽ ngi pehem tar katu tipe. (A'erehe mbói aja pejan tar katu tipe tĩ.) Pehẽ ke ihẽ amujahuk rahã, pehẽ ke Tupã mupyrara ym ta, aja pekwaha naĩ. Aja amõ pandu pehẽ pe naĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Anĩ. Pexoha katu aja pemujekwa. Aja rahã, ma'e peka'u te'eha pema'ema'eha ke pehijar aja pemujekwa ta. “Amarã riki jande ramũi, (a'erehe Tupã kotyhar ta ke jande. A'erehe jande ke Tupã mupyrara ym ta)” aja pekwaha naĩ. Anĩ. Pehem ym ta. Pesarahã! Ko apandu pehẽ pe. Tupã putar rahã, kome'ẽ ita ngi Amarã rainõ ta ke a'e muhem ta. Pehẽ ke ombor, pe, pehẽ renda ke pe amõ muhem ta. (Tupã riki pyrãtã te hũ ame'ẽ ke a'e. Putar rahã, je'ẽha rupi amõ awa pyahu ame'ẽ ta ke a'e muhem katu ta. Hendu katu ehe ame'ẽ ta ke muhem katu, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ma'eywa'y jaxer rahã, ame'ẽ i'y ke amõ mondok ta. Pe, ame'ẽ myra ke amõ hapy riki. Pe, upa ukwái. Pesarahã! Ji riki hapo rake ihĩ. (Aja rahã, mondok tate. Aja rahã, ngã ke mupyrara tate, aja mujekwa katu) — aja Juã pandu ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Pe, Juã pe amõ ta pandu u'am: —Myja jaxo rahã, katu ta my? — aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juã pandu: —(Pexoha katu, aja pemujekwa.) A'erehe mokõi pehẽma'e mundeha namõ pexo rahã, ima'e ym te ame'ẽ pe peteĩ peme'ẽ katu. (Aja pepy'a katuha ke pemujekwa.) Pehẽ mi'u heta rahã, ima'e ym te ame'ẽ ta pe peme'ẽ katu. (Aja pepy'a katuha ke pemujekwa tĩ) — aja ngã pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pe, homa awa tama'e kapitã keruhũ pe tamatarer matyr ame'ẽ ta uhyk uwyr ehe, Juã rehe. Ame'ẽ ta pandu: —Sa'e! Ngã mu'eha nde. Myja jaxo rahã, katu ta my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juã pandu: —(Pexoha katu, aja pexo.) Kuja. Homa awa tama'e kapitã keruhũ pandu, ame'ẽ jõ ngã ngi tamatarer pepyhyk katu. Amõ we pepyhyk ym te — aja tamatarer matyr ame'ẽ ta pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pe, sonda ta pandu ipe tĩ: —Jande riki! Myja jaxo rahã, katu ta my? — aja Juã pe. A'e pandu: —(Pexoha katu, aja pexo tĩ.) Kuja. Penupã aja amõ tama'e tamatarer pepyhyk ym. Amõ rehe har te'e pepandu ym. Te'e pepandu, aja amõma'e tamatarer ke pepyhyk ym tĩ. Pehẽ pe tamatarer ke homa awa tama'e kapitã keruhũ me'ẽ. Ame'ẽ namõ jõ pehẽ rury katu pexo — aja sonda ta pe Juã pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Juã pandu katu, a'erehe ehe har ipy'a pe ngã ukwa ukwa u'am. —Mã! A'e riki kapitã keruhũ aja Tupã mu'am ame'ẽ ke nahã my. Jaharõ ame'ẽ ke my? Apo Juã pandu ta — aja ngã ukwaha naĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Anĩ. Ngã pe Juã pandu katu: —Ihẽ riki aja ym. Kirisutu ym ihẽ. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke aja ym ihẽ. Y pe pehẽ ke ihẽ amujahuk. Amõ uwyr ta ixo. Tupã'ã namõ pehẽ ke mujahuk ta, ame'ẽja saka. (Aja rahã, pehẽ py'a rehe Tupã'ã muwyr ta, aja mujekwa katu.) Tata namõ mujahuk ta tĩ. (Aja rahã, ma'e ka'u te'eha ke ma'ema'e, ame'ẽ ta ke a'e mupyrara ta, aja mujekwa katu.) Ihẽ 'ar koty te we pyrãtãha a'e. A'erehe ima'e miasu aja axo rahã, ihẽ katu ym ihẽ jupe ihẽ. ");
INSERT INTO urbNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Urupen py'a ipo pe mukatak reko, aja ixo. Pe, ixurer ke peir tĩ. Ame'ẽ ke tata pe hapy indo. Ame'ẽ tata uwe ym te ame'ẽ ke. Pe, matyriha renda pe ahúi aja me'ẽ ke matyr ta. Upa kome'ẽ ywy keruhũ pe har ta ke a'e riki mutyryk tyryk ta. (Aja rahã ima'e te ame'ẽ ta ke inamõ raho ta.) Henda pe matyr ta, ame'ẽja saka. (Ima'e ym ame'ẽ ta ke mupyraraha renda pe mahy ta.) Ixurer hapy, ame'ẽja saka. Tata keruhũ a'ep ihĩ. Uwe ym te ame'ẽ — aja Juã pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Aja me'ẽ pandu pandu hũ ngã pe. —Tupã koty pehẽ py'a pemuruwak pemondo — aja ngã pe. Myrandu katu ke pandu pandu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ero kapitã a'e. Pe, Juã je'ẽ je'ẽ hũ ipe. Ero mu pete'e ixo. Ame'ẽ mu rakehar ke Ero pyhyk raho. Imu rakehar rer Erondi. Juã pandu ipe: —Mã! Ne mu rakehar nde erepyhyk. Katu ym aja. Mã peja amõ amõ ma'e nde ereka'u te'eha ke ema'ema'e ym — aja Juã pandu Ero pe. ");
INSERT INTO urbNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pe, i'ar koty te we Ero katu ym ame'ẽ ke ma'e. Kuja. Sonda ta pe a'e pandu. —Kyndaha pe Juã ke pekynda peraho — aja. (A'erehe Juã ke sonda ta kynda raho.) ");
INSERT INTO urbNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Pe, kyndaha pe Juã ixo ym rahã we, heta ngã ke a'e mujahuk u'am. Arahã Jesu ke a'e mujahuk tĩ. Pe, Tupã namõ Jesu pandu pandu u'am rahã, ywa ngi Tupã'ã wyjy uwyr ehe. Pykahuran aja saka wyjy uwyr ehe. Pe, ywa ngi panduha uwyr. Kuja: —Nde riki ihẽ ra'yr. Nde rehe ihẽ apy'a katu ame'ẽ ke nde. Ihẽ ke nde eremuhury katu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kuja, tirĩ ta (30) warahy 'ar tate nahã Jesu apo my. Kuja, 30 warahy 'ar aha oho nahã my. Arahã ngã ke a'e mu'e mu'e oho. A'e Jose ra'yr aja je ngã ukwa. Jose Eri ra'yr. ");
INSERT INTO urbNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eri Matate ra'yr. Matate Rewi ra'yr. Rewi Maki ra'yr. Maki Janai ra'yr. Janai Jose ra'yr. ");
INSERT INTO urbNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jose Matati ra'yr. Matati Amo ra'yr. Amo Naũ ra'yr. Naũ Eseri ra'yr. Eseri Nangai ra'yr. ");
INSERT INTO urbNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nangai Mate ra'yr. Mate Matati ra'yr. Matati Seméi ra'yr. Seméi Jose ra'yr. Jose Jonda ra'yr. ");
INSERT INTO urbNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jonda Joanã ra'yr. Joanã Hesa ra'yr. Hesa Soromambe ra'yr. Soromambe Sarati ra'yr. Sarati Neri ra'yr. ");
INSERT INTO urbNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Meki ra'yr. Meki Andi ra'yr. Andi Kosã ra'yr. Kosã Emanã ra'yr. Emanã Er ra'yr. ");
INSERT INTO urbNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josue ra'yr. Josue Erie ra'yr. Erie Jorin ra'yr. Jorin Matate ra'yr. Matate Rewi ra'yr. ");
INSERT INTO urbNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Rewi Simeã ra'yr. Simeã Junda ra'yr. Junda Jose ra'yr. Jose Jonã ra'yr. Jonã Eriakĩ ra'yr. ");
INSERT INTO urbNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eriakĩ Merea ra'yr. Merea Men ra'yr. Men Matata ra'yr. Matata Natã ra'yr. Natã Ndawi ra'yr. ");
INSERT INTO urbNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ndawi Jese ra'yr. Jese Ombe ra'yr. Ombe Mboa ra'yr. Mboa Sar ra'yr. Sar Nasõ ra'yr. ");
INSERT INTO urbNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasõ Amina ra'yr. Amina Amĩ ra'yr. Amĩ Ani ra'yr. Ani Erõ ra'yr. Erõ Per ra'yr. Per Junda ra'yr. ");
INSERT INTO urbNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Junda Jako ra'yr. Jako Isak ra'yr. Isak Amarã ra'yr. Amarã Ter ra'yr. Ter Nakor ra'yr. ");
INSERT INTO urbNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor Seru ra'yr. Seru Hangau ra'yr. Hangau Pare ra'yr. Pare Embe ra'yr. Embe Sa ra'yr. ");
INSERT INTO urbNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sa Kainã ra'yr. Kainã Apaxa ra'yr. Apaxa Sen ra'yr. Sen Noe ra'yr. Noe Rame ra'yr. ");
INSERT INTO urbNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Rame Metusarẽ ra'yr. Metusarẽ Eno ra'yr. Eno Jare ra'yr. Jare Marere ra'yr. Marere Kainã ra'yr. ");
INSERT INTO urbNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainã Eno ra'yr. Eno Se ra'yr. Se Anã ra'yr. Anã Tupã mujã ame'ẽ ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Y rake ngi Jesu jywyr oho. Y rer Jondã. Oho rahã, ipy'a rehe Tupã'ã ihĩ katu. Pe, awa nixói te ame'ẽ pe Jesu ke Tupã'ã muhyk raho. ");
INSERT INTO urbNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","A'ep Jesu ixo. Ma'e ka'u te'eha ke Jesu ma'e, ame'ẽ ke Satana putar tipe. (Ãjã ramũi a'e.) A'erehe manga manga tipe ixo. Kuja, 40 wera rahã, manga manga tipe. Arahã Jesu u'u ym te ma'e ke. A'erehe 40 weraha upa rahã, myahy te hũ. ");
INSERT INTO urbNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Pe, Satana pandu ipe: —Tupã ra'yr nde. Aja rahã, kome'ẽ ita pe epandu. “Mbeju wan ewak. A'u ta” aja epandu ipe — aja Jesu pe Satana pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesu pandu: —Anĩ. Apandu ym ta. Tupã je'ẽha rehe kuja panduha ihĩ: “Marã ka ym imi'u namõ jõ amõ ixoha” aja panduha ihĩ — aja Satana pe. ");
INSERT INTO urbNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pe, kome'ẽ ywy keruhũ rupi heta te hũ kapitã keruhũ ta ixo. Amõ amõ ywy pe ixo. Upa katu te ame'ẽ ke pahar Jesu pe Satana mujesak. Ywate ngi mujesak. ");
INSERT INTO urbNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Pe, pandu ipe: —Upa ame'ẽ ta ihẽ rehe hendu katu. Ihẽma'e ke. Tamatarer hũ ame'ẽ rupi ihĩ tĩ. Upa ame'ẽ riki ihẽma'e tĩ. Upa ihẽ pe amõ muwyr ame'ẽ ke. Ihẽma'e ke. Ihẽ aputar rahã, upa ame'ẽ ke amõ pe ihẽ ame'ẽ katu. Apo ihẽ rehe nde py'a nde eremoĩ moĩ rahã, upa katu te ame'ẽ ke nde pe ihẽ ame'ẽ ta kỹ. Upa katu te nema'e ta — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","A'e pandu: —Anĩ. Katu ym aja. Nde rehe ihẽ py'a amoĩ moĩ ym te ta. Tupã je'ẽha rehe kuja panduha ihĩ tĩ: “Tupã rehe jõ nde py'a nde eremoĩ moĩ katu. A'e riki sawa'e te. A'e ke rehe jõ ehendu katu” aja panduha ihĩ — aja Satana pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ajame'ẽ ke Jerusarẽ ok ta pe Jesu ke Satana muhyk raho. Tupã rehe ngã jumu'eha renda keruhũ kupe 'ar pe raho. (Ame'ẽ kupe ipe katu.) Ame'ẽ kupe rymy'y rehe muhyk raho. A'ejõhar ihĩ ame'ẽ pe muhyk raho. Iwyr koty upen te hũ ame'ẽ ke ihĩ. Sorok katu hũ riki. Pe, Jesu pe pandu: —Tupã ra'yr nde. Aja rahã, sengi epor eho. Ywy rehe nde ere'ar erekwa rahã, ahy ym ta nde pe. ");
INSERT INTO urbNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kuja Tupã je'ẽha rehe panduha ihĩ: “Ima'e je'ẽha rahoha ta pe Tupã pandu ta: ‘Pepyhyk peho!’ aja riki. Aja nde rehe a'eta usak usak katu ta” aja panduha ihĩ. (A'erehe sengi nde erepor rahã, ahy ym ta nde pe.) ");
INSERT INTO urbNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","—Kuja Tupã je'ẽha rehe panduha ihĩ tĩ: “Nde po rehe a'eta pyhyk ta, a'erehe ita rehe nde py tukwa ym te ta” aja panduha ihĩ — aja Jesu pe Satana pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Pe, Jesu pandu ipe: —Anĩ. Apor ym ta. Tupã je'ẽha rehe kuja panduha ihĩ tĩ: “Tupã riki sawa'e te. A'e katuha ke mã peja te'e emanga ym” aja panduha ihĩ tĩ — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Upa ma'e ka'u te'eha ke Jesu ma'e, ame'ẽ ke Satana putar tipe. (Ãjã ramũi a'e.) Upa manga manga tipe. Anĩ. Jesu ma'e ym te. Upa manga rahã, oho ingi, Jesu ngi. Yman atu uwyr ym ehe rĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ajame'ẽ ke Ngariréi ywy pe Jesu jywyr oho. Tupã'ãma'e pyrãtãha namõ jywyr oho. Upa ame'ẽ ywy rupi Jesu rehe har ngã ukwa ukwa. ");
INSERT INTO urbNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jundéu awa tama'e jy'ariha renda pe Jesu mu'e uĩ ngã ke. “Peme'ẽ sawa'e katu” aja ehe har upa ngã pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pe, Nasare ok ta pe Jesu jywyr oho. A'ep sawa'e ame'ẽ ke a'e. Pe, jundéu awa tama'e putu'uha 'ar rahã, jy'ariha renda pe ixe oho. Aja te'eha a'e ma'eha. Pe, Tupã je'ẽha ke pandu tar katu, a'erehe pu'am. ");
INSERT INTO urbNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pe, Isai mupinim ame'ẽ ke amõ me'ẽ ipe. Isai ymanihar Tupã je'ẽha pandu ame'ẽ ke a'e. Pe, paper ke Jesu pirar rahã, kuja panduha ihĩ ame'ẽ rehe muhyk. Kuja: ");
INSERT INTO urbNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ihẽ rehe Tupã katu usak, a'erehe ihẽ pe pandu: ‘Ihẽma'e ke nde’ aja. Pe, I'ã ke ihẽ py'a rehe a'e moĩ katu tĩ. A'erehe myrandu katu ke pyrara ixo ame'ẽ ta pe ihẽ apandu aho. Ma'e ka'u te'eha ke ma'ema'e, ame'ẽ ta marã ka ym hijariha. Kyndaha pe ixo, ame'ẽja saka. Ame'ẽ ta pe apandu aho. Myja ma'e ka'u te'eha ma'ema'eha ke hijar my, aja amujekwa aho. Jetehar te ke ukwa ym ame'ẽ ta eha ym te, ame'ẽja saka. Ame'ẽ ta pe jetehar te ke amujekwa aho tĩ. Ma'e ka'u te'eha ke ma'e, a'erehe pyai amõ. Myja ame'ẽ ke mukanim my, ame'ẽ ke ihẽ amujekwa aho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Jundéu awa ta pe ihẽ apandu tĩ. ‘Pehẽ ke jandema'e sawa'e te muhã katu ta’ ” aja panduha ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pe, paper pinim ame'ẽ ke Jesu maman. Pe, kapitã pe mujywyr rahã, wapyk. Mu'e ta. Upa jy'ariha renda pe ihĩ ame'ẽ ta usak katu ehe uĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Pe, a'ep pe har ta pe Jesu pandu: —Apo ramõ Tupã je'ẽha ke ihẽ apandu. Aja panduha uhyk apo 'y. Pehendurahã! — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Hendu ehe rahã, upa ngã pandu: —Mã! Pandu katu te a'e. Mã! Katu tiki. Jose ra'yr peme'ẽ. Myja ukwa katuha ukwa my? (Jakwa ym) — aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesu pandu: —Amõma'e panduha ke ihẽ pe pepandu tar katu, aja akwa. Kuja: “Éi, paje! Nde juehe ejumukatu!” aja. Kuja ihẽ pe pepandu tar katu tĩ: “Kapana'ũ ok ta pe ma'e katu ame'ẽ ke nde erema'ema'e, aja jahendu. Aja se nde rekoha pe ema'ema'e tĩ” aja pepandu tar katu ihẽ pe tĩ. Anĩ. Aja ama'e ym ta se. ");
INSERT INTO urbNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ko apandu katu pehẽ pe. Tupã je'ẽha mujekwa ame'ẽ ke ima'e hekoha te pe har ta putar ym. Aja ihẽ tĩ. Se ihẽ ke peputar ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","—Pehendu katurahã! Jetehar te ke. Yman te Eri ixo rahã, heta te hũ jahy rahã, aman ukyr ym te riki. Warahy 'ar mahapyr rahã, amõ ixu'a rupi rahã, aman ukyr ym te. A'erehe ame'ẽ ywy rupi myahy te hũ ngã. Ngã mi'u nixói. Arahã jundéu awa tama'e ywy pe heta ixawa'e manõ ame'ẽ ta ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pe, upa ame'ẽ ta pe Eri ke Tupã muwyr ym te. Amõ awa tama'e ixawa'e manõ ame'ẽ pe muwyr. Jundéu awa aja ym ame'ẽ pe muwyr. Sare ok ta pe har pe muwyr. Sare ok ta Sinõ ywy rehe ihĩ. Ame'ẽ ixawa'e manõ ame'ẽ pe jõ Eri oho. ");
INSERT INTO urbNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","—Aja Erise tĩ. Yman te Erise Tupã je'ẽha pandu ame'ẽ ke a'e. A'e ixo rahã, jundéu awa tama'e ywy pe heta ma'e ahy ixo ame'ẽ ta ixo. Pereran ma'e u'u hũ ame'ẽ ta ke. Ame'ẽ ta ke a'e mukatu ym te. Amõ awa sawa'e ke a'e mukatu. Jundéu awa aja ym ame'ẽ ke mukatu. Her Namã. Si ywy pe har ke a'e. Ame'ẽ jõ Erise mukatu — aja ngã pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ame'ẽ panduha ke rehe hendu rahã, upa katu te jy'ariha renda pe wapyk uĩ ame'ẽ ta parahy ehe, Jesu rehe. Ame'ẽ ta rehe har Jesu pandu, aja ngã ukwa, a'erehe parahy ngã Jesu rehe. ");
INSERT INTO urbNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pe, a'eta pu'am. Pe, Jesu ke ngã hykýi muhem raho. Ok ta ngi hykýi muhem raho. Ame'ẽ ok ta ywy'ã rake ihĩ. Ame'ẽ ywy'ã 'ar pe hykýi raho. Upen te'e hũ ame'ẽ pe ombor ta tipe raho. ");
INSERT INTO urbNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Anĩ. Heta ame'ẽ ta pyter rupi Jesu asa oho. Pe, wata oho ngã ngi. ");
INSERT INTO urbNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pe, Kapana'ũ ok ta pe Jesu oho. Ame'ẽ ok ta Ngariréi ywy rehe ihĩ. A'ep jundéu awa tama'e putu'uha 'ar rahã, jundéu awa tama'e jy'ariha renda pe Jesu mu'e mu'e ngã ke ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mu'e rahã, ukwa katu te ha namõ ngã ke mu'e, a'erehe ngã pandu: “Mã! Je'ẽha te reko aja pandu katu! Mã!” aja riki. ");
INSERT INTO urbNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Pe, jundéu awa tama'e jy'ariha renda pe amõ sawa'e ihĩ. Ãjã ipy'a rehe ihĩ ame'ẽ ke a'e. Hãtã ame'ẽ pandu: ");
INSERT INTO urbNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Éi! Jesu! Nasare ok ta pe har ke nde. Ma'ewã jande ke nde eremupyrara erejur my? Nde rehe har ihẽ akwa katu. Tupã ngi nde erejur ame'ẽ ke nde. Ima'e je'ẽha ke nde erepandu erejur. Ma'e ka'u te'eha ma'eha nixói te nde pe, aja akwa katu — aja sawa'e pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ãjã pe Jesu pandu: —Eje'ẽ ym! Sawa'e ngi ehem eho! — aja ipe. Hetaha ruwa koty sawa'e ke ãjã ityk inom. Pe, uhem oho ingi. Mahy ym ha namõ uhem oho. ");
INSERT INTO urbNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pandu pandu ngã jupe: —Mã! Katu tiki! Myja me'ẽ ame'ẽ panduha my? Hãtã je'ẽha rupi ãjã pe pandu katu. Pe, sawa'e ngi ãjã uhem oho. Pyrãtãha namõ ãjã ke muhem mondo tĩ — aja ngã jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pe, ame'ẽ ywy rupi Jesu rehe har ngã pandu pandu oho. ");
INSERT INTO urbNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jundéu awa tama'e jy'ariha renda ngi Jesu uhem oho. Pe, Simã rok pe ixe oho. Apo Simã pen ke haku hũ ou. Pe, Jesu pe amõ ta pandu oho: “Simã pen haku hũ” aja. ");
INSERT INTO urbNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pe, ixoty oho. Hake pu'am u'am rahã, pandu: “Eputu'u ipe” aja. Pahar hakuha maha oho ipe. Pahar pu'am. Pe, a'eta mi'u Simã pen me'ẽ me'ẽ a'eta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pe, pytun ramõ te rahã, jundéu awa tama'e putu'uha 'ar upa. (A'erehe jundéu awa ta wata katu apo 'y.) A'erehe Jesu koty ma'e ahy ixo ame'ẽ ta ke ngã raho raho. Ehe katu ame'ẽ ta upa ma'e ahy ixo ame'ẽ ta ke raho ipe tĩ. Pe, ma'e ahy ixo ame'ẽ ta ãkã rehe ipo ke Jesu mujar. Aja upa katu te mukatu. ");
INSERT INTO urbNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Awa ta ngi ãjã ta uhem oho tĩ. Ahem riki uhem oho. Kuja: —Nde riki Tupã ra'yr — aja Jesu rehe har. A'e riki Kirisutu. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e. Ame'ẽ ke upa ãjã ta ukwa katu, a'erehe Jesu pandu: —Ihẽ rehe har peje'ẽ ym — aja ãjã ta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pytuniwe te rahã, ok ta ngi Jesu uhem oho. Awa nixói te ame'ẽ renda pe oho. A'ep Tupã namõ pandu pandu. Pe, ngã kekar kekar ixo. “My ihon my?” aja ngã. Pe, mahem rahã, Jesu ke ngã mupyta tar katu. Pandu ipe: —Se jande rekoha pe epyta katu exo — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","A'e pandu: —Anĩ. Apyta ym ta. Amõ ok ta rupi myrandu katu ihẽ apandu ta me'ẽ te'e oho. Ame'ẽ rehe ihẽ ke Tupã muwyr. Ma'e ka'u te'eha ke amõ ma'ema'e, a'erehe pyai. A'erehe ame'ẽ ke hijar. Pe, Tupã koty ipy'a muruwak rahã: “Ihẽ kotyhar ke nde” aja Tupã pandu ta. Aja a'e putar. Ame'ẽ myrandu katu ke ihẽ apandu ta aho — aja ngã pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","A'erehe pandu pandu oho. Jundéi ywy rupi heta jundéu awa tama'e jy'ariha renda ihĩ. Ame'ẽ rupi pandu pandu oho. ");
INSERT INTO urbNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Amõ wera rahã, ypa rake Jesu mu'e u'am. Ypa rer Jenesare. (Mokõi her: “Ngariréi” aja ngã ipe tĩ.) Pe, heta ngã ixoty jy'ar uwyr. Tupã je'ẽha ke a'eta hendu tar katu, a'erehe ixoty ngã jy'ar uwyr. A'erehe jarusu keruhũ pe opor oho. ");
INSERT INTO urbNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","A'ep y rymy'y rehe mokõi jarusu keruhũ rehe Jesu usak. Y rymy'y rehe musosok ame'ẽ ke rehe usak. Ame'ẽ ke pira pyhykiha ta hijar oho. Pe, kyhapari ke a'eta kutuk u'am. ");
INSERT INTO urbNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Peteĩhar jarusu keruhũ pe Jesu opor oho. Simãma'e pe opor oho. Pe, Simã pe pandu: —Y koty esosok we rĩ — aja Jesu. Upa sosok rahã, Jesu wapyk. Pe, heta ame'ẽ ta ke mu'e uĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Upa mu'e rahã, pandu: —Simã! Apo jarusu keruhũ ke y typyha koty esosok we. Nde namõ ixo ame'ẽ ta namõ kyhapari embor emondo, y pe. Pira pepyhyk — aja Jesu ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simã pandu: —Sa'e! Pytun rahã jande jamanga hũ jaxo tipe. Aja te'e xu'em oho. Japyhyk ym te riki jande. Ko nde erepandu, a'erehe kyhapari ke jambor ta tĩ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pe, kyhapari ke a'eta ombor indo. Pe, mãte hũ te'e pira ke 'y. Kyhapari ke musak tate. ");
INSERT INTO urbNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","A'erehe ehe katu ame'ẽ ta pe Simã ta pukái. Amõ jarusu keruhũ pe ehe katu ame'ẽ ta i'ãi. —Pahar pira rehe pejur! — aja. Ixoty a'eta oho. Mokõi jarusu keruhũ ke mutyryhem. Tate mupypyk indo. ");
INSERT INTO urbNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ame'ẽ pira hetaha rehe Simã usak rahã, Jesu ruwa koty wapyk. Ipynarãi pe wapyk. (Aja sawa'e katu te ame'ẽ ke kohĩ aja mujekwa) Pe, pandu: —Sawa'e! Nde riki katu te me'ẽ ke. Ma'e nde ereka'u te'eha nde erema'eha nixói te nde pe. Ihẽ anĩ. Ma'e aka'u te'eha ke ama'ema'e ame'ẽ ke ihẽ. A'erehe ihẽ ruxĩ ihẽ. A'erehe ihẽ ngi eho — aja Jesu pe Simã pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Mãte hũ pira ke Simã ta pyhyk, a'erehe: “Mã!” aja Simã ta. Inamõ ixo ame'ẽ ta aja tĩ. “Mã!” aja tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simã rehe katu ame'ẽ ta aja tĩ. Her Tian. Imu rer Juã. Ame'ẽ mokõi Semende ra'yr. “Mã!” aja a'eta tĩ. Pe, Simã pe Jesu pandu: —Pira ke pepyhyk pexo. Apo har anĩ. Amõ kotyhar ta. Pehẽ ke ihẽ amu'e ta. A'erehe amõ ta py'a ke Tupã koty pemuruwak ta pexo kỹ. (Pira pepyhyk, ame'ẽja saka.) Pekyje ym. (Ihẽ namõ peho) — aja. ");
INSERT INTO urbNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pe, jarusu keruhũ ke y rymy'y rehe Simã ta muhyk raho. Y ngi kyhapari ke hykýi muhem rahã, upa katu te Simã ta hijar oho. Pe, Jesu namõ a'eta oho. ");
INSERT INTO urbNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Amõ wera rahã, amõ ok ta pe Jesu ixo. A'ep amõ sawa'e ixo. Pereran ma'e u'u hũ ame'ẽ ke namõ a'e ixo. (A'erehe amõ ta rake uhyk ym ame'ẽ ke a'e.) Pe, Jesu rehe usak rahã, Jesu ruwa koty wapyk oho. Ipynarãi pe wapyk oho. (Aja sawa'e katu te ame'ẽ ke kohĩ, a'erehe hendu katu ehe aja mujekwa.) Pe, pandu: —Sa'e! Nde ereputar rahã, ihẽ ke nde eremukatu katu aja akwa — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ijywa ke Jesu mupuku. Pe, sawa'e ãkã rehe ipo ke mujar. Pandu ipe: —Hã! Nde ke ihẽ amukatu tar katu. Nde katu apo 'y — aja Jesu ipe. Pe, pereran ma'e u'u hũ ame'ẽ ke pahar upa ka'ẽ oho ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Pe, Jesu pandu ipe: —Ame'ẽ ke amõ ta pe epandu ym. Pahar jundéu awa tama'e pa'i koty eho. Ejumujesak nde juehe har ipe. Nde rehe usak katu ta. “Nde katu” aja pandu ta. Pe, Moise mupinim aja ma'e ke pa'i pe eme'ẽ. Ame'ẽ ke a'e hapy ta Tupã pe, ame'ẽja saka. Aja rahã, upa ka'ẽ oho nde pe aja ngã pe nde eremujekwa ta — aja sawa'e pe. ");
INSERT INTO urbNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jesu mukatu, ame'ẽ rehe har ngã pandu pandu oho. Pe, heta ngã jy'ar ixoty. Ima'e panduha rehe a'eta hendu uwyr. Ma'e ahy ixo ame'ẽ ta ke Jesu mukatu, a'erehe a'eta uwyr tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Anĩ. Heta ame'ẽ ta ke Jesu hijar oho. Awa nixói te ame'ẽ pe oho. A'ep Tupã namõ pandu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Amõ wera rahã, ngã ke Jesu mu'e mu'e uĩ. A'ep parise ta ihĩ tĩ. Moise je'ẽha ke mu'e ame'ẽ ta ihĩ tĩ. Ok ta pame katu te ngi a'eta uhyk uwyr ehe. Ngariréi ywy rehe ok ta ihĩ, ame'ẽ ngi uhyk uwyr ehe. Jundéi ywy rehe ok ta ihĩ, ame'ẽ ngi uhyk uwyr ehe tĩ. Jerusarẽ ok ta ngi uhyk uwyr ehe tĩ. Tupãma'e pyrãtãha ihĩ katu ehe, Jesu rehe. A'erehe ma'e ahy ixo ame'ẽ ta ke mukatu hũ. ");
INSERT INTO urbNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Pe, upa jupyrãtã rãtã ame'ẽ ke amõ sawa'e ta hupir werur reko. Kyha aja me'ẽ pe a'eta werur reko. Jesu ruwa koty a'eta mou tar katu raho. A'erehe hok pe a'eta ixe tar katu. ");
INSERT INTO urbNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Heta te hũ ame'ẽ ta i'ãi, a'erehe marã ka ym ixeha. A'erehe ok kupe 'ar pe upa jupyrãtã rãtã ame'ẽ ke a'eta hupir raho. (Ame'ẽ ok kupe ipe katu.) Pe, jupyka ke jo'ok. Ame'ẽ rupi upa jupyrãtã rãtã ame'ẽ ke mujy mondo. Kyha aja me'ẽ pe mujy mondo, tupaham rehe. Ngã pyter pe mou. Jesu rake mou. ");
INSERT INTO urbNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Amõ ke Jesu mukatu, ame'ẽ rehe sawa'e ta jurujar katu. Ame'ẽ ke Jesu ukwa rahã, upa jupyrãtã rãtã ame'ẽ pe pandu: —Sa'e! Ma'e nde ereka'u te'eha ke nde erema'ema'e. Apo nde rehe ihẽ py'a jywyr katu — aja Jesu ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pe, parise ta pandu pandu a'eta jupe. Moise je'ẽha ke mu'e ame'ẽ ta namõ pandu pandu a'eta jupe. Kuja: —Mã! Amõ pe Tupã jõ riki pandu katu: “Ma'e nde ereka'u te'eha ke nde erema'ema'e. Nde rehe ihẽ py'a jywyr katu” aja. Aja me'ẽ Jesu pandu rahã, katu ym riki. Awa te'e Jesu. A'erehe peme'ẽ riki Tupã aja jupe my. Katu ym aja — aja a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pe, a'eta pandu pandu a'eta jupe, ame'ẽ ke Jesu ukwa rahã, pandu: —Aja ym pekwa pekwa peĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Myja me'ẽ riki hãtã ma'eha my? Kuja my: “Ma'e nde ereka'u te'eha ke nde erema'ema'e. Nde rehe ihẽ py'a jywyr katu” aja apandu rahã, hãtã te ma'eha my? (Ame'ẽ ke rehe usak ym awa.) Anĩ rahã, kuja my? “Epu'am! Ewata eho!” aja apandu rahã, hãtã te ma'eha my? (Ame'ẽ rehe usak awa.) ");
INSERT INTO urbNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pesarahã! Tupã jõ riki ahyha mukatu aja pekwaha. Tupã jõ riki ipy'a mujywyr katu. Ma'e ka'u te'eha ke ma'ema'e, ame'ẽ ke rehe mujywyr katu, aja pekwaha tĩ. Apo ihẽ tĩ. Ihẽ riki kapitã keruhũ aja Tupã mu'am ame'ẽ ke ihẽ, aja amujekwa ta apo. Ihẽ pe Tupã pandu tĩ: “Ma'e ka'u te'eha ke amõ ta ma'ema'e. Ame'ẽ ta rehe nde py'a emujywyr katu” aja ihẽ pe. Pesarahã! Ame'ẽ ke pekwa ta apo — aja Jesu pandu. A'erehe upa jupyrãtã rãtã ame'ẽ pe a'e pandu: —Apandu nde pe! Epu'am! Nde kyha aja me'ẽ ke emupu'a! Nde rok pe ejywyr eho inamõ — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Pe, heta ame'ẽ ta usak uĩ ehe rahã, pahar sawa'e pu'am. Kyha aja me'ẽ pe nino, ame'ẽ ke mupu'a. Ame'ẽ ke hok pe raho. Oho ixo rahã, Tupã pe pandu pandu: —Ne jõ riki katu te me'ẽ ke — aja sawa'e pandu oho ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ame'ẽ rehe ngã usak rahã, pandu: —Mã! Katu tiki! — aja. Pe, Tupã rehe har katu ngã pandu tĩ: —Mã! A'eramõ marã ka ym amõ ma'eha, ame'ẽ ke a'e ma'e katu, ame'ẽ ke rehe jasak katu. Mã! — aja ngã pandu. (Arahã Jesu Tupã tĩ, aja ngã pe mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ajame'ẽ ke ok ta ngi Jesu uhem oho. Pe, amõ sawa'e rehe usak. Homa awa tama'e kapitã keruhũ pe tamatarer matyr ame'ẽ ke a'e. (A'erehe a'e ke jundéu awa ta putar ym ame'ẽ ke a'e.) Her Rewi. (Amõ her: “Matéu” aja.) Tamatarer matyriha renda pe wapyk uĩ. Jesu pandu ipe: —Ihẽ namõ eho 'y — aja Rewi pe. ");
INSERT INTO urbNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A'e pu'am. Upa katu te hijar oho. Pe, Jesu namõ oho. ");
INSERT INTO urbNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Hok pe jywyr rahã, Jesu pe imi'u ke Rewi moĩ hũ. Amõ heta tamatarer matyr ame'ẽ ta wapyk uĩ tĩ. Heta amõ ma'e ka'u te'eha ke ma'ema'e ame'ẽ ta wapyk uĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parise ta amõ ta ihĩ tĩ. Moise je'ẽha ke mu'e ame'ẽ ta amõ ta tĩ. Wapyk uĩ tĩ. Parise ta kotyhar ta ke a'eta. Upa ame'ẽ ta je'ẽ je'ẽ hũ. Jesu namõ jumu'e ixo ame'ẽ ta namõ a'eta je'ẽ je'ẽ hũ. Kuja a'eta pandu: —Ma'ewã ame'ẽ sawa'e ta jaxer ame'ẽ ta namõ Jesu u'u uĩ my? Tamatarer matyr ame'ẽ ta namõ aja tĩ. U'u a'eta namõ tĩ. Katu ym aja — aja parise ta je'ẽ je'ẽ hũ. ");
INSERT INTO urbNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ame'ẽ ke rehe Jesu hendu rahã, pandu ngã pe: —Ma'e ahy ixo rahã, mukatuha koty amõ oho. Ahy ym rahã, mukatuha koty oho ym. (Aja apo tĩ. Ma'e ka'u te'eha ke ma'ema'e, ame'ẽ ta ihẽ rehe uhyk. Ipy'a juhyk. Ame'ẽ ke a'eta putar, a'erehe ihẽ rehe uhyk. Katu jupe, ame'ẽ ta anĩ. Ihẽ rehe uhyk ym.) ");
INSERT INTO urbNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Pesarahã! Sawa'e katu aja ukwa jupe ame'ẽ ta pe kuja ihẽ apandu ym: “Tupã koty pehẽ py'a pemuruwak pemondo” aja. Anĩ. Ma'e ka'u te'eha ke ma'ema'e, aja ukwa ame'ẽ ta pe kuja ihẽ apandu katu: “Tupã koty pehẽ py'a pemuruwak pemondo” aja riki — aja parise ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Amõ ta Jesu pe pandu: —Juã namõ jumu'e ixo ame'ẽ ta ma'e u'uha ke hijar hijar ixo. (Aja pyaiha ke mujekwa Tupã pe.) Tupã namõ a'eta pandu pandu tĩ. Parise ta namõ jumu'e ixo ame'ẽ ta aja tĩ. Ma'e u'uha ke hijar hijar tĩ. Ne namõ jumu'e ixo ame'ẽ ta aja ym riki. Ma'e ke a'eta u'u katu ixo. Hijar ym. Ma'erehe my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesu pandu: —Sawa'e jumendar rahã, ngã mi'u matyr. Huryha mujã. Pe, ame'ẽ pe oho ame'ẽ ta ma'e u'uha ke hijar ym. Sawa'e namõ ixo rahã, ma'e u'uha ke hijar ym. ");
INSERT INTO urbNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ihẽ namõ ihẽma'e jumu'eha ta ixo apo, a'erehe upa ma'e u'uha ke a'eta hijar ym. Yman rahã, ihẽ ke amõ ta pyhyk ta raho a'eta ngi. Arahã ihẽma'e jumu'eha ta upa ma'e u'uha ke hijar ta. (Aja pyaiha ke mujekwa ta) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Myja me'ẽ ymanihar ke my, ame'ẽ ke Jesu pandu tĩ: —Kamixa ymanihar sorok rahã, kamixa pyahu mondok, ame'ẽ kurer ke amõ mujar ym ehe. Mondok rahã, kamixa pyahu ame'ẽ ke mujaxer ta. Pe, ixurer ke kamixa ymanihar rehe katu ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kawĩ mupupur ramõ ame'ẽ ke hyru ymanihar te pe amõ purakar ym. Ame'ẽ pe purakar rahã, mupupur we ixo rĩ. Pe, hyru ymanihar ke mupuk ta. Pe, kawĩ jyhen ta oho. Hyru ymanihar ke mujaxer ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pesarahã! Kawĩ mupupur ramõ ame'ẽ ke hyru katu ame'ẽ pe amõ purakar rahã, katu ta tiki. (Aja rahã, kawĩ jyhen ym ta. Hyru ke upuk ym ta tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kawĩ iro ame'ẽ ke amõ u'u rahã, kawĩ mupupur ramõ ame'ẽ ke u'u tar ym. “Iro ame'ẽ ke katu te” aja pandu — aja Jesu pandu. (Jesu mu'e rahã, myja ixoha katu aja mujekwa. Ixoha pyahu aja saka. Kawĩ mupupur ramõ, ame'ẽja saka ame'ẽ. Kamixa pyahu, ame'ẽja saka ame'ẽ tĩ. A'erehe parise ta mu'e, aja ixoha namõ marã ka ym muparaha. Hyru ymanihar, aja saka. Kamixa ymanihar, aja saka tĩ, aja Jesu mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jundéu awa tama'e putu'uha 'ar rahã, ahúi aja me'ẽ ty rupi Jesu wata oho ixo, jumu'eha ta namõ. Pe, ame'ẽ ke jumu'eha ta amõ amõ po'ok ixo. (Ame'ẽ ke ipo pe kamyrik. Aja pirer ke ombor. Upa ombor rahã, ame'ẽ ke u'u.) ");
INSERT INTO urbNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pe, amõ parise ta a'ep ixo. Ame'ẽ ta pandu: —Anĩ. Katu ym u'uha. Jundéu awa tama'e putu'uha 'ar rahã, aja nema'e jumu'eha ta kamyrik rahã, katu ym. (Paraky te'e, aja saka. A'erehe katu ym.) Aja Moise je'ẽha rehe panduha ihĩ — aja parise ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","(Amõ rehe pyrara usak ta me'ẽ te'e, aja Jesu mujekwa tar katu,) a'erehe a'e pandu: —Yman Ndawi myahy te riki. Inamõ ixo ame'ẽ ta aja tĩ. Myahy te tĩ. Ame'ẽ ta ma'eha ke Tupã je'ẽha rehe pesak riki. ");
INSERT INTO urbNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ma'e u'u ame'ẽ ke nixói te rahã, Tupã rehe ngã jumu'eha renda keruhũ pe a'e ixe oho. Pe, mbeju a'ep ihĩ. Ame'ẽ ke u'u. Inamõ ixo ame'ẽ ta pe me'ẽ tĩ. A'eta u'u tĩ. Ame'ẽ mbeju ke Tupã ruwa koty pa'ihu moĩ, ame'ẽja saka. Pa'i ta jõ ame'ẽ ke u'u katu. Amõ ta u'u rahã, anĩ. (Ndawi ta pa'i ta ym.) A'erehe Ndawi ta u'u rahã, katu ym ta tipe. (Aja Moise je'ẽha rehe hendu ym) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","A'e pandu tĩ: —Jundéu awa tama'e putu'uha 'ar rahã, ma'e ke amõ ma'e, ame'ẽ ke ihẽ riki apandu katu. Tupã je'ẽha rupi ajur ame'ẽ ke ko ihẽ. Awa ihẽ tĩ — aja parise ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Amõ jundéu awa tama'e putu'uha 'ar rahã, jundéu awa tama'e jy'ariha renda pe ixe oho. A'ep ngã ke a'e mu'e uĩ. A'ep amõ sawa'e ihĩ. Ipo ke upa te'e jupu'a ame'ẽ ke a'e. Ijywa katu kotyhar ipo ke upa te'e jupu'a. ");
INSERT INTO urbNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","A'ep Moise je'ẽha mu'e ame'ẽ ta amõ ihĩ tĩ. Parise ta amõ ihĩ tĩ. Jesu rehe a'eta usak katu uĩ. Putu'uha 'ar rahã, ma'e ahy ixo ame'ẽ ke Jesu mukatu ta my? Mukatu rahã, pandu ta ipe: “Mã! Katu ym nde erema'e. Putu'uha 'ar rahã, nde eremukatu. (Nde ereparaky te'e, ame'ẽja saka.) Jundéu awa ta je'ẽha rehe nde erehendu ym. Katu ym aja” aja Jesu pe a'eta pandu ta. A'erehe a'eta usak katu ehe uĩ, Jesu rehe. ");
INSERT INTO urbNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ame'ẽ ta ipy'a pe ukwa ukwa uĩ, ame'ẽ ke Jesu ukwa katu. A'erehe ipo ke upa te'e jupu'a ame'ẽ pe pandu: —Epu'am! Se heta ame'ẽ ta pyter pe ejur! — aja riki. Sawa'e pu'am. Heta ame'ẽ ta pyter pe pu'am oho. ");
INSERT INTO urbNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pe, ngã pe Jesu pandu: —Ihẽ pe pepandurahã! Putu'uha 'ar rahã, myja jundéu awa je'ẽha mujekwa my? Myja riki katu my? Ko amõ ta rehe amõ pyrara usak rahã, katu my? Ko mai rahã, katu my? Ko amõ ta ke jukwa rahã, katu my? Ko jukwaha ke muputu'u rahã, katu my? Myja katu my? Pepandurahã! — aja ngã pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pe, ngã rehe juramã usak. Pandu ym awa. A'erehe ipo ke upa te'e jupu'a ame'ẽ pe pandu: —Nde po epirar 'y! — aja. Ipo ke sawa'e pirar rahã, upa puku oho ipe. Imembek katu oho ipe tĩ. Upa katu. ");
INSERT INTO urbNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ame'ẽ ke rehe usak rahã, parise ta parahy te ehe, Jesu rehe. Jundéu awa je'ẽha rehe hendu ym, aja ukwaha naĩ, a'erehe parahy. Pandu pandu a'eta jupe: —Myja Jesu ke japyhyk ta my? Pe, jajukwa — aja parise ta pandu pandu a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Amõ pytun ramõ rahã, ywy'ã rehe jeje te Jesu jupir oho. A'ep Tupã namõ pandu pandu u'am. Aja te'e xu'em oho. ");
INSERT INTO urbNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wera rahã, jumu'eha ta ke mujy'ar. Ame'ẽ ta ngi har awa py mokõi sawa'e ta ke jo'ok. Ame'ẽ ta pe pandu: —Pehẽ riki ihẽ amondo ta ame'ẽ ta ke apo 'y — aja. ");
INSERT INTO urbNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ame'ẽ ta rer kuja. Ko Simã. Amõ her moĩ ehe. “Petu” aja her moĩ ehe. Ko Andere amõ tĩ. Simã mu a'e. Tian amõ tĩ. Ko Juã amõ tĩ. Tian mu a'e. Amõ Siri tĩ. Amõ Matoroméu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Amõ Matéu tĩ. Amõ Tome tĩ. Amõ Tian tĩ. Apéu ra'yr a'e. Amõ Simã tĩ. Sero aja amõ ta ipe tĩ. (“Sero” aja pandu rahã, jundéu awa tama'e ywy ngi huwajan ta ke a'e mujan tar katu muhem, aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Amõ Jun tĩ. Tian ra'yr a'e. Ko Jun Ikario amõ tĩ. A'e riki Jesu rehe huwajan ta ke muhyk ta werur. ");
INSERT INTO urbNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pe, ame'ẽ ta namõ ywy'ã ngi wyjy oho. Ywy ipe katu ame'ẽ pe a'eta uhyk. Amõ jumu'eha ta heta a'ep ixo tĩ. A'ep Jundéi ywy ngi uhyk uwyr ame'ẽ ta heta ixo tĩ. Jerusarẽ ok ta ngi uhyk uwyr ame'ẽ ta amõ tĩ. Heta ixo tĩ. Tir ok ta ngi uhyk uwyr ame'ẽ ta amõ tĩ. Sinõ ok ta ngi uhyk uwyr ame'ẽ ta amõ tĩ. Heta ixo tĩ. Sinõ ok ta y ramũi rake ihĩ. Tir ok ta aja tĩ. Y ramũi rake ihĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jesu pandu ame'ẽ ke rehe johu ngã hendu uwyr. Ma'e ahy ixo ame'ẽ ta ke mukatu, ame'ẽ ke rehe johu ngã uhyk uwyr tĩ. Ãjã ipy'a rehe ihĩ ame'ẽ ta uhyk uwyr ehe tĩ. Ame'ẽ ta ke a'e mukatu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ima'e pyrãtãha namõ ngã ke mukatu hũ. A'erehe upa ngã ipo ke mujar tar katu ehe. Mujar ehe rahã, upa katu oho ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jumu'eha ta rehe Jesu usak. Pandu: —“Tupã rehe har jakwa ym jande” aja pekwa ame'ẽ ta mã peja pehẽ rury katu pe'am. Ixotyhar ta aja pemuruwak ta. Pe, inamõ pexo ta, a'erehe mã peja pehẽ rury katu pe'am. ");
INSERT INTO urbNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Amõ myahy rahã, ma'e ke u'u ta. Aja Tupã putar ame'ẽ ke pema'ema'e tar katu te rahã, mã peja pehẽ rury katu pe'am. Upa peputar ame'ẽ ke Tupã muwyr katu ta. Ma'e peka'u te'eha ke pema'e, a'erehe pejixi'u apo. Ame'ẽ ke Tupã pe pepandu. Aja rahã, mã peja pehẽ rury katu ta pe'am. Pepuka ta tĩ. Tupã ipy'a jywyr ta pehẽ rehe, a'erehe pehẽ rury katu pe'am. ");
INSERT INTO urbNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","—Mã! Pehẽ rury katu pehẽ. Ihẽ rehe pejurujar katu, a'erehe pehẽ rehe amõ ta parahy. Pehẽ ke putar ym tĩ. Pehẽ rehe juru ai ngã tĩ. “Peme'ẽ ta jaxer ai” aja pehẽ rehe har pandu naĩ tĩ. Ihẽ rehe pejurujar katu, a'erehe upa aja ta. Aja rahã, pehẽ rury katu pexo. Pehẽ ruryha namõ pepor pepor pexo. Pehẽ aja ymanihar Tupã je'ẽha pandu ame'ẽ ta tĩ. Ame'ẽ ta ke pehẽ ramũi ta mupyrara tĩ. Aja pehẽ ke amõ ta mupyrara ta tĩ. Anĩ. Tapijar te'e we ihẽ rehe pejurujar katu. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ywa pe pehẽma'e hũ ta, a'erehe pehẽ rury katu pe'am. ");
INSERT INTO urbNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","—Apo pehẽma'e hũ namõ pexo, a'erehe pehẽ rury katu pe'am. Mã! I'i atu we rahã, pepyai ta. (Amõ ta rehe pekyty'ym.) A'erehe pehẽ ke Tupã mupyrara hũ ta. ");
INSERT INTO urbNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Ma'e ke japutar ym te apo. Upa katu te jandema'e kohĩ apo, a'erehe Tupã ke japutar ym” aja pepandu ame'ẽ ta. Mã! Tupã koty pehẽma'e nixói te ta. Myahy te hũ, aja saka nixói te ta. Mã! Tupã mupyrara hũ ta pehẽ ke. “Upa katu te jandema'e kohĩ, a'erehe Tupã ke japutar ym” aja apo pepuka puka ame'ẽ ta. Mã! Pepyai ta. I'i atu we rahã, pejixi'u hũ ta. Tupã mupyrara ta, a'erehe pejixi'u hũ ta. ");
INSERT INTO urbNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","—Yman Tupã je'ẽha pandu ame'ẽ ta ran rehe har amõ ta pandu: “Katu peme'ẽ ta” aja naĩ. Te'e riki. A'engi Tupã mupyrara hũ riki. A'erehe: “Mã! Katu peme'ẽ ta” aja pehẽ rehe har pandu naĩ rahã, mã pepyai pe'am. Ymanihar ta aja Tupã mupyrara ta my tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","A'e pandu tĩ: —Ihẽ rehe hendu ame'ẽ ta pe ihẽ apandu katu. Pehẽ ruwajan ta rehe pepy'a katu. Pehẽ rehe parahy ame'ẽ ta rehe pepy'a katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","“Mã peja pehẽ ke Tupã mahy” aja pandu ame'ẽ ta pe kuja pepandu: “Mã peja pehẽ rehe Tupã usak katu” aja ipe. Pehẽ ke mahy ame'ẽ ta rehe har Tupã namõ pepandu katu. (“Mã peja esak katu ehe” aja Tupã namõ pepandu.) ");
INSERT INTO urbNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nde ruwa amõ nupã rahã, aja emujywyr ym ipe tĩ. Mã peja nde ruwa wajar a'e nupã tĩ. Nema'e kamixa ke amõ raho rahã, mã peja nema'e xirur raho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Nema'e aputar” aja nde pe amõ pandu rahã, ame'ẽ ke eme'ẽ ipe. Nema'e ke amõ pyhyk rahã, ame'ẽ mujywyriha ke epandu ym ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pehẽ pe ma'e ke amõ ta ma'ema'e katu, ame'ẽ ke peputar. Aja pemujywyr ipe tĩ. Katu ame'ẽ ke pema'ema'e ngã pe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","35","—Pehẽ rehe ipy'a katu ame'ẽ ta rehe jõ pepy'a katu rahã: “Mã! Peme'ẽ katu ame'ẽ ke” aja pehẽ rehe har Tupã pandu ym. Pesarahã! Jaxer ame'ẽ ta aja tĩ. Ipy'a katu ehe ame'ẽ ta rehe jõ ipy'a katu tĩ. (Mã! Pehẽ ruwajan ta rehe pepy'a katu ta me'ẽ te'e tĩ.) —Pe, pehẽ pe ma'e katu ame'ẽ ke ma'e. Ame'ẽ ta rehe jõ pepy'a katu rahã! “Mã! Peme'ẽ katu ame'ẽ ke” aja pehẽ rehe har Tupã pandu ym tĩ. Pesarahã! Jaxer ame'ẽ ta aja tĩ. Ma'e katu ame'ẽ ke ma'e katu. Ame'ẽ ta rehe jõ ipy'a katu tĩ. (Mã! Pehẽ ruwajan ta rehe pepy'a katu ta me'ẽ te'e tĩ.) —Amõ ta pe tamatarer pemupyta rahã, ame'ẽ ke pehẽ pe mujywyr ta, aja pekwa. A'erehe ame'ẽ ta pe pemupyta katu. Aja rahã: “Mã! Peme'ẽ katu ame'ẽ ke” aja pehẽ rehe har Tupã pandu ym. Pesarahã! Jaxer ame'ẽ ta aja tĩ. Aja mupyta tĩ. Juja katu te mujywyr tĩ, aja ukwa. Aja ym pehẽ! (Pehẽ ruwajan rehe pepy'a katu.) Ame'ẽ ta rehe pesak katu tĩ. Tamatarer ke pemupyta katu. Mujywyriha ke peputar ym pexo. Aja rahã Tupã koty nema'e heta te hũ ta. “Tupã ra'yr ta” aja ta pexo. Tupã riki ywatehar te ke a'e. Upa ngã rehe katu ame'ẽ ke a'e ma'ema'e. “Ne jõ riki katu te me'ẽ ke” aja pandu ym ame'ẽ ta rehe a'e usak katu tĩ. Jaxer ame'ẽ ta rehe aja tĩ. Usak katu tĩ. Upa ngã rehe aja tĩ. Usak katu tĩ. Aja Tupã. ");
INSERT INTO urbNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Pehẽ rehe pehẽ pái keruhũ pyrara usak. Aja amõ ta rehe pepyrara pesak tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","A'e pandu tĩ: —Amõ ta rehe har kuja ym pepandu: “Peme'ẽ ta katu ym” aja. Aja pepandu rahã, aja juja katu te pehẽ rehe har Tupã pandu ta tĩ. A'erehe aja ym pepandu. Kuja amõ ta rehe har kapitã pe pepandu ym: “Peme'ẽ riki katu ym. A'erehe emahy” aja pepandu ym. Pepandu ym rahã, aja pehẽ rehe har Tupã pandu ym ta tĩ. “Katu ym pehẽ” aja a'e pandu ym ta tĩ. —Amõ rehe peparahy rahã, pehẽ py'a pemujywyr katu ehe. Aja rahã, pehẽ katu ym rahã, pehẽ rehe Tupã ipy'a jywyr katu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","—Amõ ta pe ma'e ke peme'ẽ katu. Aja rahã, pehẽ pe ma'e ke Tupã me'ẽ katu ta tĩ. Tyryhem aja pehẽ pe muwyr ta. Jetehar te ke! I'ar koty te we muwyr ta, pehẽ pe. Myja me'ẽ amõ ta pe ma'e ke pema'e, aja juja katu te pehẽ pe Tupã ma'e ta tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Myja me'ẽ eha ym te ame'ẽ my, ame'ẽ ke jumu'eha ta pe Jesu pandu: —Mokõi eha ym te ame'ẽ ta ixo rahã, marã ka ym jumokõi wataha. Ipo rehe a'eta jupyhyk wata oho rahã, janam ha pe te'e mokõi oho ta. (Aja eha ym te aja ym pehẽ tĩ. Jetehar te ke pejumu'e katu rahã, ame'ẽ ke amõ ta pe pemu'e katu ta. Janam ha aja pejawy ym ta.) ");
INSERT INTO urbNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Jumu'eha riki mu'eha aja ym. Mu'eha 'ar koty te we ukwa ym. Pe, upa katu te jumu'e rahã, mu'eha aja a'e tĩ. Ukwa katu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","—Ne mu reha ke myra kurer mupuk, ame'ẽ rehe nde eresak. (Aja rahã, ta'yr mi ma'e ka'u te'eha ke a'e ma'e.) Mã peja ame'ẽ rehe har ekwa ekwa ym exo. Nde reha rehe myra keruhũ mupuk riki. (Aja rahã, mãte hũ nde ereka'u te'eha ke nde erema'e. Katu ym aja.) Mã peja ame'ẽ rehe har ekwa ekwa py exo. ");
INSERT INTO urbNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","—Kuja ne mu pe epandu my: “Éi! Sa'e! Nde reha ngi myra kurer ke ihẽ ajo'ok ta” aja. (Aja rahã, kuja riki: “Ta'yr mi ma'e nde ereka'u te'eha ke nde erema'e. Ame'ẽ ke mã peja ehijar” aja nde erepandu.) Mã! Nde eresak ym my? Nde reha rehe myra keruhũ ihĩ. (Aja rahã, mãte hũ nde ereka'u te'eha ke nde erema'e.) —Mã! Mokõi nde erekwaha namõ nde erexo. Nde reha ngi myra keruhũ ke ejujo'ok py. (Aja rahã, mãte hũ nde ereka'u te'eha nde erema'ema'eha ke nde erehijar katu py.) Aja rahã, upa ma'e ke nde eresak katu ta. Pe, nde mu reha ngi myra kurer ta'yr mi nde erejo'ok katu ta. (Aja rahã, nde mu pe nde erepandu: “Ma'e nde ereka'u te'eha nde erema'eha ke ehijar” aja nde erepandu katu) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","A'e pandu tĩ: —Ma'eywa'y hury katu rahã, i'a katu riki. Pe, ma'eywa'y hury ym rahã, i'a ym. ");
INSERT INTO urbNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","I'a katu rahã, ma'eywa'y rehe har amõ ukwa katu ta. (Ma'eywa'y hury katu, aja ukwa katu ta.) Pesarahã! Juruwe'y ngi akaju ke amõ po'ok ym te. Japekã'y ngi waja ke amõ po'ok ym te tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Aja amõ tĩ. I'a aja amõ rehe har amõ ta ukwa katu tĩ. Katu ame'ẽ ke amõ ma'ema'e rahã, sawa'e katu ame'ẽ ke a'e, aja amõ ta ukwa. (I'a katu, ame'ẽja saka.) Jaxer ame'ẽ ke amõ ma'e rahã, sawa'e katu ym ame'ẽ ke a'e, aja amõ ta ukwa. (I'a ym, ame'ẽja saka.) Ipy'a pe ukwa ukwa ixo, ame'ẽ ke amõ pandu. A'erehe i'a ym aja: “Katu ym a'e” aja ehe har ukwa katu awa — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","A'e pandu tĩ: —Ihẽ pe nde erepandu: “Éi! Sawa'e! Nde katu!” aja. Mã! Aja panduha jõ. Anĩ. Ihẽ apandu ame'ẽ ke rehe nde erehendu ym rahã, katu ym aja. ");
INSERT INTO urbNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ihẽ rehe amõ uhyk. Pe, ihẽ je'ẽha rehe amõ hendu katu. Pe, aja ma'ema'e. Esarahã! Ehe har ihẽ amujekwa ta pehẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ok ke mujã a'e. Kuja y rake mujã. Ywykwar ypyp pykũi katu. Itahu rehe uhyk oho. Ame'ẽ 'ar pe ok pyter ke jytyka. Ok pyter ke hãtã jytyka. Pe, y tiha rahã, ok ke u'ar ym. Ok pyter hãtã jytyka, a'erehe y ombor ym. ");
INSERT INTO urbNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","—Amõ anĩ. Ihẽ je'ẽha rehe amõ hendu tipe. Pe, aja a'e ma'e ym. Ame'ẽ riki amõ koty ok ke mujã. Kuja, y rake mujã tĩ. Ok pyter ke hãtã ym jytyka. Pe, y tiha rahã, upa munde raho. Pahar ok ke y ombor oho. Tũ! Mã! Tyapu hũ! — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Upa aja me'ẽ ngã pe Jesu pandu rahã, a'engi oho. Kapana'ũ ok ta pe oho. ");
INSERT INTO urbNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","A'ep amõ sawa'e ixo. Homa awa ke a'e. (Jundéu awa ym a'e.) Sonda tama'e kapitã ke a'e tĩ. Ima'e miasu ahy ixo. Ame'ẽ riki amõ miasu 'ar koty te we katu ame'ẽ ke ipe. Manõ tate a'e. ");
INSERT INTO urbNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pe, Jesu uwyriha rehe har kapitã ukwa rahã, jundéu awa tamũi ta ke ixoty a'e mondo. Tamũi ta pe pandu: —“Ihẽma'e miasu ke emukatu ejur. Pahar ejur” aja Jesu pe peme'u peho — aja tamũi ta pe kapitã pandu. A'erehe tamũi ta oho. ");
INSERT INTO urbNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jesu rehe uhyk rahã, pandu ipe: —Sa'e! Kapitã panduha ke nde erema'e rahã, katu ta tiki. ");
INSERT INTO urbNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Jundéu awa ta rehe a'e ipy'a katu. Jandema'e jy'ariha renda ke a'e riki mujã tĩ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tamũi ta pandu, a'erehe a'eta namõ Jesu oho. Kapitã rok pe uhyk tate rahã, ixoty ehe katu ame'ẽ ta ke kapitã mondo tĩ. Kapitã je'ẽha ke a'eta raho. Kuja Jesu pe kapitã rehe katu ame'ẽ ta pandu oho: —Sa'e! Ehendurahã! Kuja kapitã pandu: “Ihẽ rok pe nde erexe rahã, ihẽ ruxĩ riki. Amõ awa ihẽ. Nde aja jundéu awa ym ihẽ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","A'erehe nde koty ihẽ atu aho ym tĩ. Esarahã! Epandu jõ! Pe, ihẽma'e miasu katu ta oho. ");
INSERT INTO urbNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Akwa katu ihẽ. Ihẽma'e kapitã je'ẽha rehe ihẽ ahendu katu tĩ. Pe, ihẽ je'ẽha rehe amõ sonda ta hendu katu tĩ. Amõ pe ihẽ apandu: ‘Eho!’ aja. Pe, pahar a'e oho. Amõ pe ihẽ apandu: ‘Ejur se!’ aja. Pe, pahar a'e uwyr. Ihẽma'e miasu pe ihẽ apandu: ‘Eparaky eho!’ aja. Pe, a'e paraky oho. A'erehe paite nde erepandu rahã, se ihẽma'e miasu katu ta, aja akwa katu” — aja Jesu pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ame'ẽ ke Jesu hendu rahã: “Mã! Katu tiki!” aja ukwa. Uwak rahã, haikwer rupi uwyr ame'ẽ ta pe pandu: —Mã! Sonda tama'e kapitã jurujar katu te ihẽ rehe. Ihẽ apandu pehẽ pe. Aja jundéu awa ta jurujar ym ihẽ rehe. Amõ ywy pe nixói. Jundéu awa tama'e ywy pe nixói tĩ. A'eramõ akwa — aja Jesu pandu. Arahã mukatuha ke pandu. Pe, kapitãma'e miasu katu oho. ");
INSERT INTO urbNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Sonda tama'e kapitã rok pe ehe katu ame'ẽ ta jõ jywyr oho rahã, kapitãma'e miasu katu aja a'eta usak. ");
INSERT INTO urbNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ku'ẽ rahã har pe we Naĩ ok ta pe Jesu oho. Inamõ jumu'e ixo ame'ẽ ta oho tĩ. Inamõ heta ngã oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ok ta kurar rukwen rehe uhyk tate rahã, ok ta ngi heta uhem uwyr ixo. Manõ ame'ẽ ke jytym ta raho reko tĩ. Ixawa'e manõ ame'ẽ membyr ke a'e. Peteĩhar ke a'e. Heta ok ta pe har ta kũjã namõ uwyr ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Usak ehe rahã, pyrara Jesu usak ehe, ixawa'e manõ ame'ẽ ke rehe. Pandu ipe: —Ejixi'u ym! — aja kũjã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pe, kaixã koty oho. Ipo ke mujar ehe rahã, sawa'e ta hupir raho ame'ẽ ta pyta. Pe, Jesu pandu: —Sa'e! Ihẽ apandu nde pe: “Epu'am!” — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Pahar manõ ame'ẽ ke wapyk tĩ. Kwera katu uĩ. Pandu pandu a'e tĩ. Imãi pe Jesu pandu: —Ko ne membyr. Kwera katu tĩ — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","(Pyrãtã te ame'ẽ ke kohĩ, aja ngã ukwa.) A'erehe Tupã rehe har katu ngã pandu tĩ. —Mã! Katu tiki! Tupã je'ẽha ke pandu ame'ẽ ke jande namõ ixo apo! Katu te ame'ẽ ke a'e. Ima'e awa ta ke Tupã muhã katu uwyr, jundéu awa ta ke — aja ngã pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Pe, Jesu rehe har ngã pandu pandu oho. Jundéi ywy rupi pandu oho. Hake ywy ihĩ ame'ẽ rupi pandu oho tĩ. “Ngã ke Jesu mukatu” aja riki pandu oho ngã. ");
INSERT INTO urbNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Upa ame'ẽ mukatuha rehe har Juã pe inamõ jumu'e ixo ame'ẽ ta pandu tĩ. Arahã kyndaha pe Juã ixo. Pe, inamõ jumu'e ixo ame'ẽ ta ngi har mokõihar pe jõ Juã pandu. —Pejur! Pesarahã! ");
INSERT INTO urbNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Sawa'e te pe ma'e ke peme'u peho. Kuja: “ ‘Amõ sawa'e uwyr ta’ aja ihẽ apandu. Nde riki ame'ẽ ke my? Ame'ẽ ym rahã, amõ sawa'e rehe jaharõ ta my?” aja peme'u peho — aja Juã pandu mokõihar pe. ");
INSERT INTO urbNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pe, Jesu koty mokõihar ta oho. Uhyk ehe rahã, pandu ipe: —Nde koty jande ke Juã mujahukiha muwyr. A'e pandu nde pe: “Amõ sawa'e uwyr ta” aja a'e pandu. Nde riki ame'ẽ ke my? Anĩ rahã, amõ sawa'e rehe jaharõ ta my? — aja Juã muwyr ame'ẽ ta pandu ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Anĩ. Jesu pandu ym. Kuja a'e ma'ema'eha mujesak. Kuja. Arahã heta ahy ixo ame'ẽ ta ke mukatu hũ. Ãjã ipy'a rehe ihĩ ame'ẽ ta ke mukatu hũ tĩ. Eha ym te ame'ẽ ta ke mukatu hũ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pe, Juã muwyr ame'ẽ ta pe pandu: —Juã koty pejywyr peho. Pesak ramõ ame'ẽ ke upa pepandu ipe. Pehendu ame'ẽ ke upa pepandu ipe tĩ. Kuja. Eha ym te ame'ẽ ke apo ma'e ke usak katu tĩ. Wata ym te ame'ẽ ke apo wata katu tĩ. Pereran ma'e u'u hũ ame'ẽ ta ke apo upa ka'ẽ oho ipe tĩ. Ma'e hendu ym te ame'ẽ ta ke apo ma'e hendu katu tĩ. Manõ ame'ẽ ta ke kwera katu tĩ. Pyrara ixo ame'ẽ ta pe myrandu katu ke amõ ta pandu raho tĩ. A'erehe hury katu ixo apo 'y. ");
INSERT INTO urbNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pe, ihẽ rehe jurujar katuha ke hijar ym rahã, hury katu a'e ixo. Aja Juã pe pepandu peho — aja Jesu pandu. —Hã! Japandu ta jaho kỹ — aja sawa'e ta. (Ahy ixo ame'ẽ ta ke Jesu mukatu. Manõ ame'ẽ ta ke mukwera katu tĩ. Aja rahã, a'e riki Kirisutu, kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juã muwyr ame'ẽ ta jywyr oho rahã, Juã rehe har Jesu pandu ngã pe: —Amukwehe te awa nixói te ame'ẽ pe Juã rehe pesak peho rahã, ma'e pesak peho my? Sawa'e pitu te'e ame'ẽ ke rehe pesak peho my? Anĩ. Aja ym Juã. (Pyrãtã a'e. Pahar amõ koty koty ukwaha ke mondo ym a'e.) ");
INSERT INTO urbNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ima'e mundeha katu te ame'ẽ ke namõ ixo, ame'ẽ sawa'e rehe pesak peho my? Anĩ. Aja ym tĩ. Pesarahã! Aja mundeha katu te ame'ẽ ke namõ ixo ame'ẽ ta kapitã keruhũ rok pe ixo. Ma'e katu te ame'ẽ ke namõ jõ ixo ame'ẽ ta a'ep ixo tĩ. Kapitã keruhũ rok pe ixo tĩ. (Juãma'e aja ym. Ima'e mundeha katu te ame'ẽ namõ a'e ixo ym.) ");
INSERT INTO urbNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ihẽ pe pepandu! Awa rehe pesak peho my? Tupã je'ẽha pandu ame'ẽ ke rehe pesak peho my? A'e tiki. Pesarahã! Apandu katu pehẽ pe. Ymanihar te Tupã je'ẽha pandu ame'ẽ ta 'ar koty te we Juã riki Tupã je'ẽha pandu ame'ẽ ke a'e. (A'erehe Juã rehe pehendu katu ta me'ẽ te'e.) ");
INSERT INTO urbNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ta'yr rehe har kuja Tupã je'ẽha rehe panduha ihĩ. Kuja Tupã pandu: “Ne ndutar koty myrandu raho ame'ẽ ke ko ihẽ amondo py. Nde ereho tate rahã, ngã py'a ke ihẽ koty a'e muruwak ta mondo” aja panduha ihĩ. (Ame'ẽ mondo py ame'ẽ ke Juã.) ");
INSERT INTO urbNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","—Apandu pehẽ pe. Upa katu te sawa'e ta 'ar koty te we Juã katuha ke. Pe, amõ ixo. Apo myrandu katu pandu oho ame'ẽ ta Juã 'ar koty te we katuha. Myrandu ke ymanihar Tupã je'ẽha pandu ame'ẽ ta pandu pandu. Juã pandu, a'e riki ymanihar ta 'ar koty te we katu. Apo anĩ. Ihẽma'e jumu'eha ta myrandu katu ke pandu. Ame'ẽ ta Juã 'ar koty te we katuha. Ihẽma'e jumu'eha ta ma'e ukwa ym ame'ẽ ta ke, aja pekwaha naĩ. Anĩ. Ame'ẽ ta katu te, aja Tupã ukwa katu — aja ngã pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jesu rehe heta ngã hendu. Homa awa tama'e kapitã keruhũ pe tamatarer matyr ame'ẽ ta hendu ehe tĩ. Amukwehe te Juã mujahuk ame'ẽ ta ke a'eta. (Ame'ẽ ta jaxer te, aja amõ ta ukwaha.) Ame'ẽ ta Tupã je'ẽha rehe hendu katu. “Ma'e peka'u te'eha ke pema'e ym. Tupã koty pehẽ py'a pemuruwak” ame'ẽ Tupã je'ẽha rehe hendu katu. A'erehe Juã mujahuk. (Aja rahã, ma'e ka'u te'eha ke hijar aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Parise ta anĩ. Putar ym. Ame'ẽ ta pandu: “Jande ke Juã mujahuk ame'ẽ ke japutar ym. Tupã mujekwa ame'ẽ ke rehe jahendu tar ym tĩ” aja riki. Moise je'ẽha mu'e ame'ẽ ta aja tĩ. Tupã mujekwa ame'ẽ ke rehe hendu tar ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesu pandu tĩ: —Myja me'ẽ ihẽ ke putar ym ame'ẽ ta my? Kuja nahã my? ");
INSERT INTO urbNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ame'ẽ ta riki kurumĩ ra'yr ta aja saka. Kũjãtãi ta aja tĩ. Jumusaráiha ke a'eta mujã. Muhepyha renda pe wapyk. Pe, wajar ta pandu: “Huryha rehe jande jajyngar tipe. Pepurahái ym. Pyaiha rehe jajyngar tipe. Pejixi'u ym tĩ” aja wajar ta pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","—Aja apo jundéu awa ta ixo ame'ẽ ta tĩ. Juã mujahukiha uwyr rahã, ma'e u'uha ke a'e hijar. (Aja pyaiha ke mujekwa.) Kawĩ ke u'u ym te tĩ. Pe, ehe har pepandu: “Ipy'a rehe ãjã ihĩ ame'ẽ ke a'e. Katu ym a'e” aja pandu naĩ. (Pehẽ rury ym ehe. Wajar ihĩ, ame'ẽja saka pehẽ tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","—Pesarahã! Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Juã aja ym ihẽ. Upa ma'e ke ihẽ a'u. Kawĩ a'u we tĩ. Pe, ihẽ rehe har pepandu: “Pesarahã! Ma'e u'u hũ ame'ẽ ke a'e. Kawĩ ngi ka'u ame'ẽ ke a'e” aja ihẽ rehe pandu naĩ. Katu ym aja. “Jaxer ai ame'ẽ ta rehe katu ame'ẽ ke a'e. Homa awa tama'e kapitã keruhũ rehe tamatarer matyr ame'ẽ ta rehe katu ame'ẽ ke a'e tĩ. Katu ym aja” aja riki ihẽ rehe har pandu naĩ tĩ. Tupã muwyr ame'ẽ ke ihẽ, aja a'eta putar ym. Jundéu awa ta hury ym ihẽ rehe. (Jumusaráiha wajar saka.) ");
INSERT INTO urbNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","—Pesarahã! Tupã koty ipy'a ke amõ muruwak rahã, Tupã riki upa ma'e ke ukwa katu, aja a'e ukwa katu — aja Jesu pandu. (Aja rahã, kuja riki. Juã ke Tupã muwyr. Juã ma'ema'eha katu, aja Tupã ukwa. Jesu ke Tupã muwyr tĩ. Pe, Jesu ma'ema'eha katu, aja Tupã ukwa tĩ. Aja Tupã kotyhar ta ukwa katu tĩ, aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jesu pe parise pandu: —Ihẽ rok pe e'u ejur — aja ipe. Pe, hok pe inamõ uhyk rahã, wapyk. Ma'e ke u'u uĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ame'ẽ ok ta pe amõ kũjã ixo. Kũjã ixo te'e ame'ẽ ke a'e. Parise rok pe ma'e ke Jesu u'u uĩ, aja hendu. A'erehe ixoty oho. Ma'e piheha ke raho. Ita parasuku pe ihĩ, ame'ẽ ke raho. ");
INSERT INTO urbNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pe, Jesu py rake wapyk uĩ. Jixi'u uĩ tĩ. Aja ipy ke makym. Pe, i'a puku ame'ẽ pe ipy ke muxikã rahã, ipy ke juru pe pyter pyter tĩ. (Aja ipy'a moĩ moĩ ehe.) Pe, ma'e piheha ke jyhen ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ame'ẽ rehe parise usak. Hok pe Jesu ke muhyk ame'ẽ ke a'e. Her Simã. A'e jupandu jupe uĩ: —Peme'ẽ sawa'e Tupã je'ẽha pandu ame'ẽ ke rahã, kũjã rehe har ukwa ta tipe. Ipy ke pyhyk pyhyk, ame'ẽ rehe har ukwa ta tipe. Ma'e ka'u te'eha ke ma'ema'e ame'ẽ kũjã ke a'e, aja a'e ukwa ta tipe — aja Jesu rehe har Simã jupandu jupe uĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ame'ẽ ke Jesu ukwa, a'erehe pandu: —Simã! Ma'e ke ihẽ apandu ta nde pe — aja. Simã pandu: —Ere! Sawa'e! Ngã mu'eha nde. Epandurahã! — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Pe, kuja Jesu pandu ipe: —Ko mokõi sawa'e ta ixo. Tamatarer jar ngi tamatarer ke ame'ẽ ta pyhyk. Peteĩ sawa'e heta te hũ pyhyk. Amõ heta ym pyhyk. ");
INSERT INTO urbNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pe, ijar pe marã ka ym mujywyriha. A'erehe mokõi sawa'e ta pe ijar pandu: “Ere! Katu apo 'y. Tamatarer pemujywyr ym ta me'ẽ te'e. Upa ihẽ aharái apo 'y” aja. Aja rahã, mokõi sawa'e ta ngi har myja me'ẽ sawa'e riki ijar rehe ipy'a katu te my? — aja Jesu Simã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simã pandu: —Tamatarer heta te hũ pyhyk, ame'ẽ riki ipy'a katu te. Tamatarer mujywyriha ijar harái, a'erehe ipy'a katu te, aja nahã my — aja ipe. Jesu pandu: —A'e tỹ. Nde erepandu katu — aja. ");
INSERT INTO urbNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Simã pe pandu we rahã, kũjã koty uwak. —Simã! Kome'ẽ kũjã rehe esarahã! Ko nde rok pe ihẽ ajur rahã, y ke nde eremoĩ ym. Ihẽ py kutukiha ke. (Aja jundéu awa ma'eha ke.) Kome'ẽ kũjã anĩ. Ihẽ py ke kutuk. Eha rykwer pe kutuk. Pe, i'a pe muxikã tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ahyk rahã, ihẽ rehe nde erejuman ym tĩ. “Ko nde erejur katu” aja nde erepandu ym. Kome'ẽ kũjã anĩ. Ihẽ ahyk rahã, ihẽ py ke pyter pyter. Putu'u ym a'e. Aja ipy'a katuha mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ihẽ ãkã rehe ma'e ka pihe katu ame'ẽ ke nde erejyhen ym. (Aja nde rury katuha ke nde eremujekwa ym.) Kũjã anĩ. Ihẽ py rehe ma'e piheha ke jyhen. Aja ipy'a katuha mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","A'erehe ihẽ apandu nde pe. Ihẽ rehe ipy'a katu te ha ke kũjã mujekwa. (Aja rahã, Tupã koty ipy'a muruwak aja mujekwa.) A'erehe Tupã ipy'a jywyr ehe. Ma'e ka'u te'eha ke kũjã ma'ema'e. Tupã ipy'a jywyr ehe. Ta'yr mi ka'u te'eha ke amõ ma'e rahã, Tupã ipy'a jywyr ehe. Ta'yr mi ma'e. A'erehe ta'yr mi ipy'a katuha amõ mujekwa tĩ — aja Simã pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pe, kũjã pe Jesu pandu: —Ma'e nde ereka'u te'eha ke nde erema'ema'e. Nde rehe ihẽ py'a jywyr — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Myrape 'ar pe amõ ta wapyk uĩ. Ame'ẽ ta jupandu a'eta jupe uĩ: —Mã! Awa ko my? Esarahã! Amõ ke rehe ipy'a jywyr ame'ẽ ke a'e. Tupã a'e my tĩ — aja jupandu a'eta jupe uĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pe, kũjã pe Jesu pandu: —Ihẽ rehe nde erejurujar katu, a'erehe nde ke Tupã muhã katu. Ererahã! Eho katu — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ku'ẽ rahã har pe we amõ amõ ok ta rupi Jesu ohoho ixo. Awa renda rupi ohoho ixo tĩ. “Ma'e peka'u te'eha pema'ema'eha ke pehijar. Tupã koty pehẽ py'a pemuruwak. A'e putar aja pexoha pyahu aja pexo katu. Aja rahã: ‘Ihẽ kotyhar ta ke pehẽ’ aja a'e pandu ta” ame'ẽ myrandu katu ke pandu pandu oho ixo. Jumu'eha ta inamõ oho tĩ, awa py mokõi ame'ẽ ta ke. ");
INSERT INTO urbNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Inamõ kũjã ta oho tĩ. Amukwehe amõ kũjã ta py'a ngi ãjã ke Jesu muhem mondo. Ame'ẽ kũjã ta oho inamõ tĩ. Amukwehe amõ ma'e ahy ixo ame'ẽ ta ke mukatu tĩ. Ame'ẽ kũjã ta oho inamõ tĩ. Ko Mari Mandare oho inamõ tĩ. Amukwehe te awa po wajar mokõi ãjã ta ke Jesu muhem mondo ingi. ");
INSERT INTO urbNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ko Joa oho inamõ tĩ. Ku rakehar ke a'e. Ku riki Ero rok pe ma'e ke ma'ema'e ixo ame'ẽ ke a'e. Ko Susã oho inamõ tĩ. Ko amõ kũjã ta heta oho inamõ tĩ. Upa ame'ẽ ta ma'e ke me'ẽ katu, Jesu ta pe. Ima'e tamatarer ke me'ẽ. Ame'ẽ namõ ma'e ke johu jo'ok jo'ok ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Heta ngã ixoty jy'ar uwyr. Amõ amõ ok ta ngi jy'ar uwyr ixoty. Ame'ẽ ta pe myja me'ẽ ma'e ke my, ame'ẽ ke Jesu pandu: ");
INSERT INTO urbNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Ma'e ra'ĩ ke amõ sawa'e muhãi oho. Kupixa pe ma'e ra'ĩ muhãi rahã, awa rape rupi amõ ha'ĩ u'ar. A'ep amõ ta pyrũ ehe. Ma'ewyra ta u'u amõ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Amõ ma'e ra'ĩ ita ty rupi u'ar. Ame'ẽ hywõi rahã, te'e manõ. Ita ty rupi y nixói, a'erehe te'e manõ. ");
INSERT INTO urbNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Amõ ma'e ra'ĩ juruwe ty rupi u'ar. Juruwe namõ hywõi. Pe, juruwe tiha py oho, a'erehe ma'e ra'ĩ hywõi rahã, hury ym. A'erehe i'a ym. ");
INSERT INTO urbNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Amõ ma'e ra'ĩ ywy katu ame'ẽ rehe u'ar. A'ep hury katu. I'a hũ tĩ. Hymbo rehe heta te hũ i'a ihĩ. Sẽ (100) aja hetaha. Aja hymbo pame katu te i'a ihĩ — aja Jesu pandu. A'e pandu tĩ: —Pesarahã! Pekwa tar katu rahã, ihẽ apandu ame'ẽ ke rehe pehendu katu ta me'ẽ te'e! — aja ngã pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","I'i we myja me'ẽ ma'e ke my, ame'ẽ rehe har jumu'eha ta pandu: —Ma'e ame'ẽ my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Pe, a'e pandu: —Apo amõ kotyhar Tupã mujekwa. Pyahu ame'ẽ ke. Kuja. Ixoty ipy'a ke amõ muruwak ame'ẽ ke a'e putar katu. “Ihẽma'e a'e” aja a'e pandu. “Ame'ẽ ke nema'e jumu'eha ta pe emujekwa” aja Tupã ihẽ pe pandu. Amõ ta pe anĩ. Amujekwa ym ta. A'erehe myja me'ẽ ma'e ke my, ame'ẽ ke apandu pandu. Aja rahã, amõ usak usak tipe. Anĩ. Ukwa ym te ame'ẽ rehe har. Amõ hendu hendu tipe. Anĩ. Ukwa ym te tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","A'e pandu tĩ: —Myja me'ẽ ma'e ra'ĩ my, ame'ẽ rehe har amujekwa ta apo 'y. Ma'e ra'ĩ riki Tupã je'ẽha aja saka. ");
INSERT INTO urbNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ma'e ra'ĩ awa rape rupi u'ar. Ame'ẽ riki Tupã je'ẽha rehe amõ ta hendu tipe. Pe, ame'ẽ ta rehe Satana uhyk ta. (Ãjã ramũi a'e. Ma'ewyra u'u uwyr, ame'ẽja saka.) Pe, Tupã je'ẽha ke upa mukanim a'eta ngi. Aja rahã, Tupã rehe jurujar ym. Pe, ame'ẽ ke Tupã muhã ym. ");
INSERT INTO urbNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","—Ma'e ra'ĩ ita ty rupi u'ar. Ame'ẽ riki Tupã je'ẽha rehe huryha namõ hendu katu tipe tĩ. (Pahar hywõi, ame'ẽja saka.) Anĩ. Pyta katu ym. Heta ym jahy rahã, jurujar katu we rĩ. Pe, Tupã rehe jurujar katu, a'erehe amõ ta putar ym. Mahy riki tĩ. A'erehe jurujar katuha ke hijar. (Warahy upa jukwa, ame'ẽja saka.) ");
INSERT INTO urbNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","—Ma'e ra'ĩ juruwe ty rupi u'ar. Ame'ẽ riki Tupã je'ẽha rehe hendu tipe tĩ. Pe, ixoha rehe har a'eta jumupyai ixo, a'erehe Tupã je'ẽha harái. Upa ipy'a ngi mukanim. Tamatarer hũ pyhykiha rehe jõ ukwa ukwa ixo, a'erehe Tupã je'ẽha harái tĩ. Jumuhuryha rehe jõ ukwa ukwa ixo tĩ, a'erehe Tupã je'ẽha harái tĩ. Upa mukanim ingi tĩ. A'erehe Tupã rehe har ukwa tar ym. A'erehe ma'e katu ame'ẽ ke ma'ema'e ym. (I'a ym, ame'ẽja saka.) ");
INSERT INTO urbNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","—Ma'e ra'ĩ ywy katu ame'ẽ rehe u'ar. Ame'ẽ riki Tupã je'ẽha rehe hendu katu tĩ. Ipy'a pe ihĩ katu. Hendu katu te ehe tĩ. Amõ koty uwak ym oho, a'erehe ma'e katu ame'ẽ ke a'e ma'ema'e katu. (I'a heta hũ, ame'ẽja saka) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","A'e pandu tĩ: —Araparin amõ hapy rahã, pander pe jupyk ym. Myrape wyr pe moĩ ym tĩ. Anĩ. Ywate pukwar. Aja rahã, ok pe ngã ixo rahã, wera katu ipe. Wera katu, aja Tupã rehe har ukwa ta. ");
INSERT INTO urbNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ihẽ amu'e ame'ẽ ke ame'ẽja saka. Apo mukanim, ame'ẽja saka. I'I atu rahã, upa mujekwa ta ngã pe. Wera katu, ame'ẽja saka. Apo jupyk, ame'ẽja saka. I'i atu rahã, upa pirar ta, ame'ẽja saka. (Aja rahã, juehe har Tupã mujekwa ta ngã pe. Wera katu, ame'ẽja saka.) ");
INSERT INTO urbNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","—Pesarahã! Ma'e pehendu ame'ẽ ke pekwa katu pexo. Tupã rehe har ukwa tar katu. Aja rahã, ame'ẽ pe amõ we Tupã mujekwa ta. Ta'yr te mi ukwa, aja amõ ta ukwaha naĩ. Anĩ. Ame'ẽ ke upa katu te Tupã mukanim ta ingi. Aja rahã, ukwa ym te ta — aja jumu'eha ta pe Jesu mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesu mãi ixoty oho. Imu ta oho ixoty tĩ. Hake uhyk ym ehe. Heta te hũ ngã, a'erehe marã ka ym uhykiha ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pe, amõ pandu oho ipe: —Soroka pe ne mãi ixo. Ne mu ta amõ tĩ. Ne namõ pandu tar katu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pe, heta ame'ẽ ta pe Jesu pandu: —Tupã je'ẽha rehe hendu, pe, pandu: “Katu. Tupã je'ẽha mujekwa, aja ihẽ ama'ema'e ta” aja. Aja pandu ame'ẽ ta ihẽ mãi aja tĩ. Ihẽ mu ta aja tĩ — aja ngã pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Amõ wera rahã, jarusu keruhũ pe Jesu opor oho. Jumu'eha ta opor oho tĩ. Ame'ẽ ta pe pandu: —Ypa ruwái koty jaha jaho — aja Jesu. Pe, sosok mondo. ");
INSERT INTO urbNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pe, aha oho ixo rahã, Jesu ukwer oup. Pe, pahar ywytu keruhũ uhyk ehe. Ypa rupi peju hũ. Jarusu keruhũ pe y ke oho rãi. Tate jere oho. ");
INSERT INTO urbNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pe, Jesu ke jumu'eha ta mupak oho. Pandu ipe: —Sa'e! Jande jajere tate jaho — aja Jesu pe. Pe, pu'am rahã, ywytu keruhũ pe Jesu pandu: —Mã peja ym! Eputu'u katu ihẽ pe — aja. Pahar ywytu keruhũ putu'u! Y kotok keruhũ pe pandu tĩ: —Mã peja ym! Ewapyk katu — aja. Pahar y kotok keruhũ wapyk katu te uĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pe, jumu'eha ta pe pandu: —Mã! Pehẽ namõ ihẽ axo. Ihẽ rehe pejurujar ym. Katu ym aja — aja Jesu. A'eta mukahem riki. Kyje tĩ. Jupandu a'eta jupe: —Mã! Katu tiki! Pyrãtã te ame'ẽ ke kohĩ. Je'ẽha rehe ywytu keruhũ hendu katu! Y kotok keruhũ aja tĩ. Hendu katu ehe tĩ. Mã! Myja me'ẽ sawa'e ko my? — aja a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pe, ypa ruwái rehe Jesu ta aha oho, jarusu keruhũ pe. Jera ywy koty oho. Ame'ẽ ywy Ngariréi ywy kupe koty ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pe, jarusu keruhũ ngi Jesu uhem oho rahã, amõ sawa'e uhyk uwyr ehe. Ok ta pe har ame'ẽ ke a'e kwe. Ipy'a rehe ãjã ihĩ ame'ẽ ke a'e tĩ. Yman jawe te'e ixo rĩ, a'erehe hok pe pyta ym te. Kangwerupa rupi ixo ame'ẽ ke a'e. Itakwar rupi kangwerupa ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Pe, ãjã ihĩ katu ehe rahã, awa nixói te ame'ẽ pe sawa'e ke mujan mujan mondo. Sawa'e ke amõ ta pukwar kwe. Ita tupaham pe ipo apyr pukwar. Ipyta ke pukwar tĩ. Anĩ. Ten! Aja ame'ẽ ke upa te'e mohok. Pe, awa nixói te ame'ẽ pe ãjã mujan mondo. Pe, Jesu rehe sawa'e usak rahã, ahem hũ ixo. Jesu ruwa koty u'ar. (Aja sawa'e katu te ame'ẽ ke kohĩ aja mujekwa.) Ãjã pe Jesu pandu: —Sawa'e ngi ehem eho — aja. A'erehe Jesu pe sawa'e hãtã pandu: —Jesu! Nde riki Tupã ra'yr! Ywatehar ke a'e. Ema'e ym ihẽ pe. Ihẽ apandu nde pe, emahy ym ihẽ ke — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Pe, Jesu pandu ipe: —Ma'e nde rer? — aja ipe. —Ihẽ rer riki: “Heta” — aja. Sawa'e py'a rehe heta te hũ ãjã ta ihĩ, a'erehe: “Heta” aja pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pe, Jesu pe ãjã ta pandu: —Mupyraraha renda pe jande ke emondo ym we rĩ. Aja emahy ym we jande ke rĩ — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pe, petete kure ta ixo. Ame'ẽ ke rehe ãjã ta usak. Heta te hũ kure ta i'ãi. Ywy'ã rupi kãpĩ u'u ixo. Jesu pe ãjã ta pandu: —Kure ta koty jaho tar katu — aja. —Ere! — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","A'erehe sawa'e ngi ãjã ta uhem oho. Kure ta pe ixe oho. (Ka'u te'e hũ uwak.) Pe, kure ta upa katu te ujan oho. Upen te'e hũ ame'ẽ pe u'ar oho. Ypa pe u'ar. Upa katu te y jukwa. ");
INSERT INTO urbNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ame'ẽ ke kure usakiha ta usak rahã, ame'ẽ rehe har ok ta pe pandu pandu oho. Amõ ta renda rupi pandu pandu oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pe, ame'ẽ ke rehe ngã usak oho tĩ. Jesu rehe uhyk rahã, sawa'e rehe usak. A'eramõ ãjã ta uhem oho ingi, ame'ẽ ke rehe usak. Jesu rake wapyk uĩ. Ima'e mundeha namõ ixo apo 'y. Apo ka'u te'e ym tĩ. Pe, upa ngã kyje ingi, Jesu ngi. (Sawa'e pyrãtã te hũ ko ixo, aja ukwa, a'erehe kyje ingi.) ");
INSERT INTO urbNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Sawa'e ke Jesu mukatu, ame'ẽ ke rehe usak ame'ẽ ta upa ame'ẽ rehe har ngã pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pe, Jesu ngi upa jera ywy pe har ta kyje. (Sawa'e pyrãtã te hũ ko ixo, aja ukwa.) A'erehe kyje ngã ingi. (Amõ we ngãma'e kanim ta, ame'ẽ ke putar ym tĩ.) A'erehe pandu ipe: —Sengi eho — aja Jesu pe. A'erehe jarusu keruhũ pe Jesu opor oho. Oho ingi. ");
INSERT INTO urbNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Oho tate rahã, sawa'e pandu ipe. A'eramõ ãjã ta uhem oho ingi ame'ẽ ke a'e. Kuja pandu: —Sawa'e! Ne namõ ihẽ aho ta — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","A'e pandu: —Anĩ. Nde rok pe ejywyr eho. Nde ke Tupã mukatu, ame'ẽ rehe har epandu eho — aja sawa'e pe. Pe, hok pe mujywyr mondo. Pe, ok ta rupi sawa'e pandu pandu oho. “Mã! Katu tiki. Ihẽ ke Jesu mukatu” aja pandu pandu oho. ");
INSERT INTO urbNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ypa ruwái koty Jesu jywyr oho. Y rymy'y rehe uhyk rahã, heta ngã harõ u'am ehe. Huryha namõ ame'ẽ ta pandu: —Ko nde erejur! — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pe, amõ sawa'e uhyk uwyr ehe. Her Jái. Jundéu awa tama'e jy'ariha renda kapitã ke a'e. Huwa koty ipynarãi pe a'e wapyk. (Aja sawa'e katu te ame'ẽ ke kohĩ, a'erehe hendu katu ehe aja mujekwa.) Pandu hũ ipe: —Ihẽ rok pe jaho! ");
INSERT INTO urbNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ihẽ rajyr ahy oup. Manõ tate oup. Emukatu ejur! — aja Jesu pe. Awa py mokõi warahy 'ar ame'ẽ ke tajyr. Tajyr peteĩhar ke. Pe, Jái namõ Jesu oho ixo rahã, heta ngã jumujar mujar hũ te'e oho ixo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Heta ame'ẽ ta pyter pe amõ kũjã oho ixo. Jaiha pupur hũ ame'ẽ ke a'e. Awa py mokõi warahy 'ar rahã, aja te'eha a'e. Mukatuha ta pe upa katu te tamatarer ke me'ẽ me'ẽ. Anĩ. Mukatu ym te a'e ke. ");
INSERT INTO urbNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jesu raikwer rupi uwyr. Pe, heta ame'ẽ ta rupi asa oho. Pe, Jesuma'e mundeha apyr ke pyhyk. Pahar jaiha pupur ame'ẽ ke putu'u katu ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesu pandu: —Awa ihẽ ke pyhyk my? — aja. Upa ngã pandu: —Anĩ ihẽ — aja ipe. Petu pandu: —Sawa'e! Mã! Ukwa ym awa! Nde rake rupi heta ngã ixo. Mujar mujar hũ tĩ — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesu pandu: —Jetehar te ke! Ihẽ ke amõ pyhyk! Ihẽma'e pyrãtãha uhem oho. Amukatu amõ ke, a'erehe ihẽma'e pyrãtãha uhem, aja akwa katu — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pe, ngã ukwa ym ha rupi asa oho ym ta, aja kũjã ukwa. A'erehe Jesu rake oho. Ryrýi riki. Jesu rake wapyk oho. Pe, ngã pyter pe upa pandu. Ma'erehe Jesu ke pyhyk my, ame'ẽ rehe har upa pandu. Pahar katu oho jupe, ame'ẽ rehe har pandu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Pe, Jesu pandu ipe: —Éi, kũjã! Upa ma'e ahyha ke amukatu, ame'ẽ rehe nde erejurujar katu, a'erehe nde katu apo 'y. Ejywyr katu eho — aja kũjã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Pe, pandu ixo rahã, kapitã rok ngi amõ pandu uwyr, Jái rok ngi. Kuja Jái pe pandu: —Nde rajyr manõ ramõ te. Mã peja mu'eha jywyr oho. Nde rajyr manõ tái — aja sawa'e ta pandu. (“Mu'eha” aja pandu rahã: “Jesu ke” aja a'eta ukwa.) ");
INSERT INTO urbNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sawa'e ta panduha rehe Jesu hendu rahã, Jái pe pandu: —Anĩ. Nde py'ahu te'e. Ihẽ rehe nde erejurujar katu, aja rahã jõ katu ta tiki. Pe, nde rajyr katu ta tĩ — aja Jesu ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pe, hok pe uhyk rahã, heta ame'ẽ ta pe pandu: —Se pepyta. Soroka pe pepyta — aja Jesu. Kuja jõ inamõ hok pe ixe oho. Ko Petu. Juã amõ tĩ. Tian amõ tĩ. Ipái amõ tĩ. Imãi amõ tĩ. Ame'ẽ ta jõ. Heta ame'ẽ ta soroka pe pyta. ");
INSERT INTO urbNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kũjãtãi manõ, a'erehe a'ep pe har ta jixi'u hũ. Ahem ehe ixo tĩ. Pe, Jesu pandu: —Pejixi'u ym. Kũjãtãi manõ ym. Ukwer te'e oup — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","—Héi! Héi! Mã! Ukwa ym a'e — aja upa a'ep har ta puka puka hũ ehe. Kũjãtãi manõ te, aja a'eta ukwa. A'erehe puka puka hũ ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kapy pe ixe rahã, ipo ke Jesu pyhyk. Pe, pandu: —Kũjãtãi! Epu'am! — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Pe, pahar kwera katu. Pu'am tĩ. Pe, imãi pe Jesu pandu: —Ma'e ke eme'ẽ ipe. U'u ta — aja. (Ma'e u'u rahã, ixuwe katu a'e aja ukwa katu, a'erehe aja Jesu pandu.) ");
INSERT INTO urbNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ipái ta pandu: —Mã! Mã katu tiki! — aja. Jesu pandu: —Myja kwera katu my, ame'ẽ rehe har amõ ta pe pepandu ym te — aja ipái ta pe. Petu ta pe aja tĩ. “Pepandu ym” aja pandu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Pe, awa py mokõi jumu'eha ta ke Jesu mujy'ar. Pandu: —Ihẽ je'ẽha rupi amõ ta py'a ngi ãjã ta ke pemuhem pemondo. Ihẽma'e pyrãtãha namõ aja tĩ. Pemuhem pemondo tĩ. Ihẽ je'ẽha rupi ahy ixo ame'ẽ ta ke pemukatu tĩ. Ihẽma'e pyrãtãha namõ aja tĩ. Pemukatu tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pe, ame'ẽ ta ke mondo rahã, kuja pandu tĩ: —Kuja pepandu pandu peho: “Ixoty ipy'a ke amõ muruwak rahã, Tupã pandu ta ipe: ‘Ihẽma'e nde’ aja. A'erehe mã peja pehẽ py'a ke ixoty pemuruwak” aja ngã pe pepandu peho. Ahy ixo ame'ẽ ta ke pemukatu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Peho rahã, pehẽma'e ke peraho ym te. Pehẽ mi'u ke peraho ym. Tamatarer ke peraho ym tĩ. Mokõi kamixa ke peraho ym tĩ. Pehẽ kupe pe ma'e ryru peraho ym tĩ. Myra te'e pehẽ po pe peraho ym tĩ. Myra rehe te'e wata ame'ẽ ke. ");
INSERT INTO urbNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Amõ ta rok pe pehyk, pe, pehẽ pe ijar pandu: “Ko nde erejur katu. Ihẽ rok pe epyta katu” aja. A'ep pepyta katu we rĩ. Ame'ẽ ok ta pe pexo rahã, ame'ẽ rok pe jõ peker. Ame'ẽ rok pe jõ ma'e ke pe'u tĩ. (Aja rahã, ijar pandu py ame'ẽ ke parahy ym ta.) ");
INSERT INTO urbNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","—Pehẽ ke amõ ta putar ym rahã, ame'ẽ ok ta ngi pehem peho. “Ko nde erejur katu. Se epyta katu” aja pandu ym te awa. Aja rahã, pehem peho. Peho rahã, pehẽ py ngi ywyku'i pejuhyk pembor. Ame'ẽ ke a'ep pe har ta usak rahã, a'ep pe har ta ke Tupã putar ym tĩ, aja pemujekwa ta ngã pe tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Upa Jesu pandu rahã, jumu'eha ta oho. Amõ amõ ok ta rupi ohoho. Myrandu katu ke pandu pandu oho. Oho ixo rahã, ahy ixo ame'ẽ ta ke a'eta mukatu. ");
INSERT INTO urbNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ero kapitã ke a'e. Ngariréi ywy pe har tama'e kapitã ke. Pe, upa Jesu ma'ema'e ame'ẽ rehe har hendu. Amõ ta pandu: —Jesu riki Juã mujahukiha ke. Juã ke Tupã mukwera katu muhem tĩ — aja Jesu rehe har pandu naĩ. A'erehe ame'ẽ hendu rahã, Ero ka'u te'e. ");
INSERT INTO urbNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Amõ ta pandu: —Anĩ. Jesu riki Eri. Ymanihar Tupã je'ẽha pandu ame'ẽ ke jywyr uwyr a'e tĩ — aja Jesu rehe har pandu naĩ tĩ. Amõ ta pandu: —Anĩ. Ymanihar te Tupã je'ẽha pandu ame'ẽ ke kwera katu uhem tĩ — aja Jesu rehe har pandu naĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pe, Ero pandu: —Anĩ. Amukwehe amõ pe apandu: “Juã ãkã emondok eho ingi” aja. (Juã manõ te, aja akwa katu. A'erehe Jesu riki Juã ym, aja akwa katu.) Pe, awa peme'ẽ my? Mãte hũ ehe har ihẽ ahendu — aja. Pe, Jesu rehe Ero usak tar katu tipe. Ukwa tar katu ehe har. ");
INSERT INTO urbNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pe, Jesu mondo ame'ẽ ta jywyr uwyr ixoty. Upa katu te ma'ema'eha ke pandu ipe. Pe, ame'ẽ ta namõ jõ Jesu oho. Mesái ok ta pe oho. ");
INSERT INTO urbNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pe, ame'ẽ ke hetaha ta ukwa rahã, haikwer rupi ngã oho tĩ. Uhyk rahã, Jesu pandu: —Ko pejur katu — aja hetaha ta pe. Tupã rehe har kuja pandu: “Apo amõ koty Tupã mujekwa. Pyahu ame'ẽ ke. Kuja. Ixoty ipy'a ke amõ muruwak, ame'ẽ ke a'e putar katu. Ixoty ipy'a muruwak rahã: ‘Ihẽma'e ke a'e’ aja a'e pandu” aja Jesu pandu pandu ngã pe. Ahy ixo ame'ẽ ta ke mukatu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pe, warahy ka'aruk koty rahã, awa py mokõi jumu'eha ta uhyk uwyr ehe. Pandu ipe: —Ko awa nixói te ame'ẽ pe jaxo. Ngã mi'u nixói te se. A'erehe hetaha ta ke emujywyr emondo. Paite ok ta rupi ngã oho ta. Ame'ẽ rupi imi'u ngã jo'ok ta. Ukweriha renda a'ep ihĩ tĩ. Amõ awa renda rupi aja tĩ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesu pandu: —Anĩ. Ame'ẽ ke pehẽ atu peme'ẽ me'ẽ ngã pe — aja jumu'eha ta pe. A'eta pandu: —Pira ka'ẽ mokõi jõ kohĩ. Mbeju, awa po wajar peteĩhar upa jõ kohĩ tĩ. Ame'ẽ uhyk ym ta ngã pe. Amõ heta te hũ jajo'ok ym rahã, uhyk ym ta ngã pe. Ngã heta te hũ kote'e ixo — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kuja, 5.000 sawa'e ta a'ep ixo nahã my. Sawa'e ta jõ manga rahã, aja hetaha ta ixo nahã my. Pe, Jesu pandu: —Amõ koty koty ngã ke pemujy'ar. Ko 50 hetaha nahã. Se amõ 50 nahã. Paite amõ 50 nahã. Aja pame katu te. “Pewapyk” aja pepandu ngã pe — aja jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pe, aja jumu'eha ta mujy'ar. Upa ngã pe pandu: —Pewapyk — aja riki. Pe, wapyk. Se 50 hetaha. Se amõ 50. Paite amõ 50. Aja pame katu te. ");
INSERT INTO urbNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pe, mbeju ke Jesu pyhyk. Pira ka'ẽ amõ. Ywa rehe ma'ã. Pe, pandu: —Ne jõ riki katu te me'ẽ ke. Jande mi'u ke jande pe nde eremuwyr katu — aja Tupã pe. Pe, mbeju mopok. Ame'ẽ ke jumu'eha ta pe me'ẽ. Pira ka'ẽ mupen tĩ. Ame'ẽ ke me'ẽ tĩ. Pandu: —Ngã pe peme'ẽ me'ẽ peraho — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Upa ngã u'u. Uhyk ngã u'u. Pyta we ame'ẽ ke jumu'eha ta matyr matyr. Wasãkã pe matyr. Kuja, awa py mokõi wasãkã mutyryhem. ");
INSERT INTO urbNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pe, amõ rahã, Tupã namõ jeje Jesu pandu u'am. Jumu'eha ta uhyk uwyr ehe. Jesu pandu: —Ihẽ rehe har ngã pandu rahã, myja pandu my? — aja jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ame'ẽ ta pandu: —Kuja amõ ta: “Juã mujahukiha nde” aja je. Amõ ta: “Eri nde. Ymanihar Tupã je'ẽha pandu me'ẽ ke” aja je tĩ. Amõ ta: “Amõ ymanihar Tupã je'ẽha pandu ame'ẽ ke kwera katu uhem. Ame'ẽ ke nde” aja je tĩ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","A'e pandu: —Pehẽrahã! Myja ihẽ rehe har pekwa my? — aja jumu'eha ta pe. Petu pandu: —Nde riki Kirisutu! Kapitã keruhũ aja Tupã mu'am ame'ẽ ke nde — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pe, Jesu pandu: —Kirisutu ihẽ. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke ihẽ. Ame'ẽ rehe har amõ ta pe pepandu ym te — aja jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","A'e pandu tĩ: —Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ko apandu pehẽ pe. Ihẽ ke amõ ta mahy hũ ta. Jundéu awa tamũi ta putar ym te ihẽ ke tĩ. Jundéu awa tama'e pa'i keruhũ aja tĩ. Moise je'ẽha mu'e ame'ẽ ta aja tĩ. Ihẽ ke putar ym te tĩ. Ihẽ ke amõ ta jukwa ta. Pe, mokõi aker rahã, ihẽ ke Tupã mukwera katu ta muhem — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Upa ngã pe Jesu pandu: —Ihẽ namõ amõ ixo tar katu rahã, ima'e putariha ke hijar ta me'ẽ te'e. Pe, Tupã putar ame'ẽ ke ma'ema'e ta me'ẽ te'e. Wera rahã pame katu te ima'e putariha ke mukanim ta me'ẽ te'e tĩ. Pe, ihẽ namõ tapijar te'e we oho ta me'ẽ te'e. ");
INSERT INTO urbNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Amõ manõ tar ym. A'erehe a'e pandu naĩ: “Anĩ. Jesu rehe ajurujar ym ihẽ” aja. Aja rahã, Tupã namõ ixo ym te ta. Ihẽ rehe amõ jurujar katu, a'erehe a'e ke amõ ta jukwa. Aja rahã, Tupã namõ aja te'e ta a'e ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kome'ẽ ywy keruhũ pe ma'e katu ame'ẽ ke heta te hũ ihĩ. Upa ame'ẽ ke amõ pyhyk. Matyr hũ tĩ. Pe, manõ rahã, Tupã namõ ixo ym te ta. Aja rahã, marã ka ym katuha. ");
INSERT INTO urbNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","—Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ ngi amõ huxĩ rahã, ihẽ ruxĩ ta ingi tĩ. Ihẽ amu'e ame'ẽ ke ngi amõ huxĩ rahã, ame'ẽ sawa'e ngi ihẽ ruxĩ ta tĩ. Ihẽ ajywyr rahã, ihẽ ruxĩ ta ingi. Katu te ha namõ ihẽ ajywyr ta. Papama'e katu te ha namõ ajywyr ta tĩ. Ima'e je'ẽha rahoha tama'e katu te ha namõ ajywyr ta tĩ. Arahã ihẽ ngi huxĩ ame'ẽ ta ngi ihẽ ruxĩ ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pesarahã! Apandu pehẽ pe! Ihẽ riki kapitã keruhũ te. Ame'ẽ ke pehẽ ngi har amõ ta usak ta. Ixuwe katu ixo rahã, usak ta, manõ ym we ta rĩ — aja ngã pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Upa ame'ẽ ke Jesu pandu rahã, kuja a'e ukwer nahã my, awa po wajar mokõi. Pe, ywy'ã keruhũ pe oho. Petu ke raho. Juã amõ tĩ. Tian amõ tĩ. Tupã namõ pandu oho. ");
INSERT INTO urbNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Pe, Tupã namõ pandu u'am rahã, huwa ke amõ koty uwak oho. Ima'e mundeha ke ituwyr te hũ. ");
INSERT INTO urbNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Pahar ywa pe har weraha namõ mokõi sawa'e ta uhem. (Wera te hũ rahã, Tupã pete'e ixo aja mujekwa katu.) Ko ymanihar te Moise ke uhem. Ymanihar te Eri amõ tĩ. Jesu namõ a'eta pandu pandu u'am. Kuja a'eta pandu inamõ: —Jerusarẽ ok ta pe nde eremanõ ta. Aja Tupã putar ame'ẽ ke nde erema'e ta — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petu ta riki ukwer katu te. Pe, upak rahã, Jesuma'e katu te ha rehe a'eta usak. Mokõi sawa'e ta inamõ pu'am u'am, ame'ẽ ke rehe a'eta usak tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pe, mokõi sawa'e ta oho ixo ingi rahã, Jesu pe Petu pandu: —Sawa'e! Ko jande johu jaxo, a'erehe katu tiki. Pehẽ mahapyr pe mahapyr xipa ke jamujã ta. Ko nde pe amõ. Moise pe amõ tĩ. Eri pe amõ tĩ. (Aja rahã, amõ we pepyta we ta my) — aja Petu Jesu pe. Ukwa ym ma'e panduha ke, a'erehe aja Petu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pe, Petu pandu u'am rahã, ywa takãxĩha uhyk a'eta rehe. Takãxĩha rysãha uhyk a'eta rehe. Pe, ywa takãxĩha pe mokõi sawa'e ta ixe oho rahã, Petu ta kyje. Usak ame'ẽ ke ngi kyje. ");
INSERT INTO urbNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pe, ywa takãxĩha ngi panduha uwyr. Kuja: —Ko riki ihẽ ra'yr. Katu asak ame'ẽ ke a'e. Ihẽma'e ke a'e. A'e pandu ame'ẽ ke rehe pehendu katu — aja. ");
INSERT INTO urbNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Panduha putu'u rahã, jeje Jesu ixo. Upa usak ame'ẽ ke amõ ta pe Petu ta pandu ym te. Arahã pandu ym te rĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ame'ẽ ku'ẽ rahã, ywy'ã keruhũ ngi Jesu ta wyjy oho. Wyjy uwyr ixo rahã, heta ngã uhyk ixoty. ");
INSERT INTO urbNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Heta ame'ẽ ta ngi har amõ sawa'e pukái Jesu pe: —Sawa'e! Ngã mu'eha nde. Apandu nde pe. Ihẽ ra'yr rehe esarahã! Peteĩhar ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ipy'a rehe ãjã ihĩ rahã, pahar ahem ahem a'e. Mumanõ manõ a'e ke reko tĩ. Aja rahã, juru ke tyjúi hũ. A'e ke mahy hũ tĩ. Pe, he'õ te rahã, uhem oho ingi. ");
INSERT INTO urbNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ne namõ jumu'e ixo ame'ẽ ta pe ihẽ apandu hũ: “Ãjã ke pemuhem pemondo ingi” aja riki. Anĩ. Marã ka ym muhemiha — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","A'e pandu: —Mã! Apo pehẽ pexo ame'ẽ ta! Mã! Tupã pyrãtãha rehe pejurujar ym! Katu ym aja. Aja te'e pehẽ namõ ihẽ axo ym ta. Pejurujar ym ha namõ aja te'eha ihẽ py'ahu te'e ahendu. Anĩ. Aja ym ta — aja ngã pe. Pe, sawa'e pe pandu: —Nde ra'yr ihẽ pe erur — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pe, kurumĩ uwyr ixo rahã, a'e ke ãjã ityk. Ywy rehe ityk. Pe, mumanõ manõ hũ. Ãjã pe Jesu pandu: —Ehem eho ingi — aja. Pe, uhem oho. Aja mukatu, pe, ipái pe raho. ");
INSERT INTO urbNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tupãma'e pyrãtãha rehe har ngã pandu: —Mã! Katu tiki! Katu hũ — aja. Jesu ma'eha rehe har ngã pandu pandu ixo rĩ: —Mã! Katu te me'ẽ a'e my! — aja. Arahã jumu'eha ta pe Jesu pandu: ");
INSERT INTO urbNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Ko ihẽ apandu ame'ẽ ke pehẽ py'a pe pekwa pekwa pexo. Aja rahã, peharái ym ta. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Pesarahã! Ihẽ rehe ihẽ ruwajan ta ke amõ muhyk ta werur — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Anĩ. Ame'ẽ panduha ke jumu'eha ta ukwa ym. Mujekwa ym Jesu, a'erehe ukwa ym. Jumu'eha ta kyje ingi, a'erehe ame'ẽ rehe har pandu ym we ipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jumu'eha ta je'ẽ je'ẽ hũ a'eta jupe u'am: —Jande ngi har awa riki katu te ame'ẽ ke my? — aja a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ame'ẽ ta ukwa ukwa u'am ame'ẽ ke Jesu ukwa rahã, ta'yn ke pyhyk. Pe, hake mupu'am. ");
INSERT INTO urbNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Pandu: —Kome'ẽ ta'yn ke hok pe mupyta katu. Ihẽ kotyhar ke, a'erehe pandu ipe: “Ko nde erejur katu. Ihẽ rok pe epyta katu” aja. Aja rahã, ihẽ ke hok pe mupyta katu tĩ, ame'ẽja saka tĩ. Ihẽ pe: “Ko nde erejur katu” aja pandu rahã, ihẽ pái pe: “Ko nde erejur katu” aja pandu tĩ, ame'ẽja saka tĩ. Ihẽ ke ihẽ pái muwyr ame'ẽ ke ihẽ. Pehẽ ngi har amõ kuja ukwa: “Katu ym ame'ẽ ke ihẽ” aja ukwa. Aja rahã, ame'ẽ ke katu te aja Tupã ukwa — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juã pandu: —Sawa'e! Paite amõ sawa'e rehe jasak. Ame'ẽ riki nde je'ẽha rupi ãjã ta ke muhem katu mondo, ngã py'a ngi. Jande namõ ixo ym a'e, a'erehe japandu ipe: “Anĩ. Mã peja ym. Jesu je'ẽha rupi ãjã ta ke emuhem ym emondo” aja sawa'e pe jande japandu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pe, Juã ta pe Jesu pandu: —Anĩ. Aja ym pepandu ipe. Amõ riki pehẽ ruwajan aja ym rahã, pehẽ rehe katu ame'ẽ ke a'e — aja Juã ta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ywa pe Jesu ke Tupã mujywyr ta, ame'ẽ angaha ke rehe uhyk tate rahã, Jesu pandu: —Jerusarẽ ok ta pe ihẽ aho ta kỹ — aja. Pe, ixoty oho ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Amõ sawa'e ta ke mondo py. Pe, sawa'e ta oho. Samari ywy pe amõ ok ta ihĩ. Ame'ẽ pe oho. (A'ep Jesu rehe ukweriha renda ke mukatu oho.) ");
INSERT INTO urbNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Anĩ. A'ep pe har ta putar ym. (Jesu riki jundéu awa ke, a'erehe putar ym.) Jerusarẽ ok ta jaxer aja a'ep pe har ta ukwaha naĩ. Jerusarẽ ok ta pe Jesu oho ixo, aja a'ep pe har ta ukwa, a'erehe putar ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ame'ẽ ke Tian ukwa rahã, Jesu pe pandu. Juã aja tĩ. Jumu'eha ta ke mokõi. Kuja pandu: —Sawa'e! Ame'ẽ ok ta pe har ta ke tata mai ta my. (Nde ke putar ym ame'ẽ ta ke a'eta.) Ywa ngi tata keruhũ ke japandu ta. Aja nde ereputar my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesu uwak rahã, pandu a'eta pe: —Anĩ. Peja ym! — aja Tian ta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pe, amõ ok ta pe Jesu ta oho. ");
INSERT INTO urbNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pe, a'eta oho ixo rahã, amõ sawa'e pandu ipe: —Nde ereho ame'ẽ pe ne namõ ihẽ aho ta kỹ tĩ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","A'e pandu ipe: —Hokwar rupi so'o ukwer. Haity pe ma'ewyra ta ukwer tĩ. Ihẽ anĩ. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Pesarahã! Ihẽ akeriha renda nixói — aja ipe. (Aja rahã, inamõ oho rahã, hok te nixói ta, aja mujekwa katu. Sawa'e jetehar te oho ta my, ame'ẽ ke Jesu manga, a'erehe aja pandu.) ");
INSERT INTO urbNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Amõ sawa'e pe Jesu pandu: —Ihẽ namõ eho — aja ipe. Sawa'e pandu: —Sa'e! Anĩ we rĩ. Ihẽ rok pe ajywyr we ta rĩ. Papa manõ rahã, ihẽ riki ajytym ta. Arahã jõ ne namõ ihẽ aho ta kỹ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","A'e pandu: —Anĩ. Tupã rehe ipy'a ym ame'ẽ ta manõ aja saka ixo. Ame'ẽ ta riki manõ te ame'ẽ ke jytym ta. Ne anĩ. Ihẽ namõ ejur apo 'y. “Tupã kotyhar ta aja pemuruwak” aja epandu eho apo 'y — aja sawa'e pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Amõ sawa'e pandu: —Sa'e! Ne namõ ihẽ aho ta kỹ. Kuja py ta rĩ. Ihẽ rok pe aho we ta rĩ. Papa ta pe ihẽ apandu ta: “Ihẽ aho ta kỹ” aja ta. Upa rahã, ne namõ ihẽ aho ta kỹ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","A'e pandu ipe: —Mandi'i'y ke purure pe amõ jytym rahã, hok pe purure mujywyr jywyr ym. Kupixa pe pyta. Aja Tupã rehe har amõ pandu pandu oho rahã, hok pe jywyr jywyr oho rahã, katu ym tiki. (Jywyr jywyr rahã, ihẽ namõ oho te ta, aja mujekwa ym. Katu ym aja) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ajame'ẽ ke amõ heta sawa'e ta pe Jesu pandu: “Ihẽ koty pejur. Ihẽma'e ta ke pehẽ pexo” aja riki. Jesu jandema'e sawa'e te. Kuja, 72 sawa'e ta ke jo'ok. Ame'ẽ ta ke jumokõi mokõi pame katu te mondo. Jesu oho ta ame'ẽ rupi ame'ẽ ta ke mondo py. Ok ta rupi mondo. Awa renda rupi mondo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ame'ẽ ta pe pandu: —Heta te hũ ngã ixo. Ihẽ rehe har pandu oho ame'ẽ ta anĩ. Heta ym. A'erehe Tupã namõ pepandu. “Sawa'e te! Ne je'ẽha pandu oho ame'ẽ ta ke emondo. Heta emondo. Aja rahã, nde koty ngã py'a ke ame'ẽ ta muruwak ta” aja Tupã pe pepandu. ");
INSERT INTO urbNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Peho apo 'y. Pesarahã! Arapuharan rehe jangwate usak rahã, marã ka ym arapuharan ujan oho ingi. Arapuharan ta aja saka pehẽ. Pehẽ ke Tupã rehe ipy'a ym ame'ẽ ta mahy tar katu tĩ. (Arapuharan ke jangwate pyhyk, ame'ẽja saka.) A'erehe peta kỹ. ");
INSERT INTO urbNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Te'e peho. Peho rahã, tamatarer ryru peraho ym. Ma'e ryru pehẽ kupe pe peraho ym tĩ. Mokõi pehẽ py rehe har peraho ym tĩ. Peho pexo rahã, i'i atu pehẽ rehe uhyk ame'ẽ ta namõ pepyta ym. Pahar peasa peho. ");
INSERT INTO urbNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Amõ rok pe pehyk rahã, pepandu py: “Mã peja kome'ẽ rok pe har ta rehe Tupã usak katu” aja. ");
INSERT INTO urbNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","7","Pe, ok jar pandu: “Katu. Ko pejur katu! Se pepyta” aja rahã, Tupã usak katu ta ehe. Ame'ẽ rok pe jõ pepyta katu. Pehẽ mi'u ke ok jar me'ẽ. Ame'ẽ ke pe'u katu. Parakyha pe ma'e ke ijar me'ẽ me'ẽ katu. Aja ihẽma'e parakyha ke pehẽ, a'erehe pehẽ pe ijar werur ame'ẽ ke pe'u katu. Amõ amõ rok pe pehẽ mi'u pekekar ym peho. —Anĩ. Ok jar putar ym rahã: “Katu. Ko pejur katu. Se pepyta” aja ym pandu rahã, peho ingi. Katuha pepandu ame'ẽ ke pehẽ rehe jywyr ta, ame'ẽja saka. Pehẽ rehe Tupã usak katu ta. ");
INSERT INTO urbNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","—Amõ ok ta pe peho, pe, a'ep pe har ta mupyta katu rahã, ma'e ke pehẽ pe ngã werur ame'ẽ ke pe'u katu. ");
INSERT INTO urbNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","A'ep ahy ixo ame'ẽ ta ke pemukatu. A'ep pe har ta pe pepandu tĩ: “Tupã koty pehẽ py'a ke pemuruwak. Aja rahã, Tupã pandu ta: ‘Ihẽ kotyhar ta ke pehẽ apo 'y’ aja Tupã pandu” aja ngã pe pepandu. ");
INSERT INTO urbNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","—Pe, amõ ok ta pe peho, pe, a'ep pe har ta pehẽ ke mupyta ym rahã, ok ta pyter pe peho. A'ep pepandu: ");
INSERT INTO urbNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Pehẽ ok ta rupi jawata rahã, ywyku'i jande py rehe pyta rãi. Pesarahã! Ame'ẽ ke jajuhyk apo. Aja rahã, kuja pehẽ py'a rupi pekwa katu pe'am. Tupã pandu: ‘Ihẽ kotyhar ta aja pemuruwak apo’ aja riki. Anĩ. A'e ke peputar ym” aja ok ta pe har ta pe pepandu. ");
INSERT INTO urbNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","—Apandu pehẽ pe. Kome'ẽ ywy keruhũ pe har ta ke Tupã mupyrara rahã, Sondo ok ta pe har ta ke a'e mupyrara ta tĩ. (Ymanihar te jaxer ma'ema'e ame'ẽ ta ke a'eta, a'erehe mupyrara ta.) Pe, pehẽ ke mupyta ym apo. (Ame'ẽ ta Tupã muwyr ame'ẽ ke putar ym. Ihẽ riki Tupã muwyr ame'ẽ ke ihẽ.) A'erehe ame'ẽ ok ta pe har ta ke Sondo ok ta pe har ta 'ar koty te we Tupã mupyrara hũ ta — aja 72 mondo ame'ẽ ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","A'e pandu tĩ: —Korasĩ ok ta pe har ta! Mã! Mãte hũ pehẽ ke Tupã mupyrara ta tĩ. Mesái ok ta pe har ta! Pehẽ aja tĩ. Mãte hũ pehẽ ke Tupã mupyrara ta tĩ. Marã ka ym amõ ma'eha, ame'ẽ ke heta hũ pehẽ ruwa koty ihẽ ama'ema'e tipe. (Anĩ. Ihẽ rehe pejurujar ym.) Pehẽ ruwa koty ihẽ ama'ema'e ame'ẽ ke ymanihar Tir ok ta pe ihẽ ama'ema'e ta tipe rahã, a'ep pe har ta ma'e ka'u te'eha ma'ema'eha ke hijar ta tipe. Pan xuru aja me'ẽ ma'e mundeha ke munde ta tipe. (Aja pyaiha ke mujekwa ta tipe.) Aja Tupã koty ipy'a ke muruwak, aja mujekwa ta tipe tĩ. Tatimbuk ke iãkã rehe ombor ta tipe tĩ. (Aja pyaiha ke mujekwa ta tipe tĩ.) Ymanihar Sinõ ok ta pe har ta aja tĩ. (Pyaiha ke mujekwa ta tipe tĩ.) Ma'e ka'u te'eha ke hijar ta tipe tĩ. Tupã koty a'eta py'a ke muruwak aja mujekwa ta tipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","—Ko ihẽ apandu. Ngã ke Tupã mupyrara rahã, Tir ok ta pe har ta ke a'e mupyrara ta. Sinõ ok ta pe har ta aja tĩ. Ame'ẽ ok ta pe har ta 'ar koty te we Korasĩ ok ta pe har ta ke a'e mupyrara ta. Aja Mesái ok ta pe har ta ke a'e mupyrara ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kapana'ũ ok ta pe har ta! Kuja: “Jande anĩ. Katu te jande” aja pekwaha naĩ. Upa pehẽma'e ok ta ke Tupã mukanim ta tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jumu'eha ta pe pandu: —Pehẽ rehe amõ hendu katu rahã, ihẽ rehe hendu katu tĩ. Pehẽ ke amõ putar ym rahã, ihẽ ke putar ym tĩ. Ihẽ ke amõ putar ym rahã, ihẽ pái ke putar ym tĩ. Ihẽ ke ihẽ pái muwyr. A'e ke putar ym tĩ — aja Jesu pandu. (Upa Jesu pandu rahã, kuja 72 sawa'e ta pandu oho. Tupã je'ẽha ke pandu oho.) ");
INSERT INTO urbNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ok ta rupi upa pandu oho rahã, kuja 72 sawa'e ta jywyr uwyr, Jesu rehe. Hury riki ame'ẽ ta. Jesu pe a'eta pandu: —Sawa'e! Pesarahã! Ãjã ta riki jande rehe hendu katu tĩ! Nde je'ẽha rupi japandu: “Ehem eho ngã py'a ngi” aja. Aja rahã, ãjã ta uhem katu oho — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A'e pandu: —A'e tỹ! Satana rehe asak a'am rahã, pyrãtãha kanim ingi. (Ãjã ramũi a'e.) Ame'ẽ ke rehe ihẽ asak. Ywa ngi Tupã weraha, aja pahar pyrãtãha kanim ingi. A'erehe ãjã ta ke pemuhem pemondo ngã py'a ngi. ");
INSERT INTO urbNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pesarahã! Ihẽma'e pyrãtãha ke pehẽ pe amondo, a'erehe mbói ta rehe pepyrũ, pe, su'u rahã, ahy ym pehẽ pe. Jawajyr ta rehe aja tĩ. Pepyrũ, pe, jupi rahã, ahy ym pehẽ pe tĩ. Satanama'e pyrãtãha ke aja tĩ. (Ãjã ramũi a'e.) Pehẽ ke mahy ym ta tĩ. Pehẽ ke mahy ym te ta ma'e ke. ");
INSERT INTO urbNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ãjã ta pehẽ rehe hendu katu. Ame'ẽ rehe pehẽ rury katu. Amõ we tĩ. Tupã kotyhar ta ke pehẽ, a'erehe pehẽ rer ke Tupã mapyk. Ima'e paper rehe mapyk. Ywa pe ame'ẽ ke ihĩ. A'erehe i'ar koty te we hũ pehẽ rury katu te pexo — aja 72 sawa'e ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Upa 72 sawa'e ta pe Jesu pandu rahã, Jesu rehe Tupã'ã ihĩ katu te. A'erehe hury katu te a'e. Pe, Jesu pandu: —Papa! Ywa pe har ta kapitã keruhũ ke nde! Kome'ẽ ywy keruhũ pe har ta kapitã keruhũ ke nde tĩ. “Ne jõ riki katu te me'ẽ ke” aja nde pe apandu. “Akwa katu te ame'ẽ ke ihẽ” aja pandu ame'ẽ ta pe nema'e pyrãtãha ke nde eremujekwa ym. “Ihẽ riki ajumu'e katu te ame'ẽ ke ihẽ” aja pandu ame'ẽ ta pe nde eremujekwa ym tĩ. Ta'yn ta aja ihẽma'e jumu'eha ta. Upa katu te ukwa ym. Ame'ẽ ta pe nema'e pyrãtã te ha ke nde eremujekwa katu. A'erehe apandu: “Ne jõ riki katu te me'ẽ ke” aja nde pe. Papa! Jetehar te ke. Nde ereputar, a'erehe aja nde eremujekwa katu — aja Tupã pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pe, ngã pe pandu: —Upa katu te ma'e ke ihẽ pe ihẽ pái mujekwa katu. A'erehe upa katu te ihẽ akwa katu. Ihẽ rehe har ukwa ym awa. Ihẽ pái jõ ukwa katu te ihẽ rehe har. Ihẽ pái rehe har ukwa ym awa. Ihẽ jõ akwa katu te ehe har. Ta'yr ke ihẽ. Pe, amõ ta pe ehe har ihẽ amujekwa tar katu, ame'ẽ ta jõ ukwa katu te ehe har tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pe, jumu'eha ta jeje ixo rahã, hake Jesu oho. Pandu: —Pehẽ rury katu ame'ẽ ta ke pehẽ! Ihẽ ama'ema'e ame'ẽ rehe pesak katu, a'erehe pehẽ rury katu pehẽ. ");
INSERT INTO urbNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Apandu pehẽ pe. Ihẽ ama'ema'e ame'ẽ ke rehe pehẽ atu pesak katu. Ame'ẽ rehe heta ymanihar Tupã je'ẽha pandu ame'ẽ ta usak tar katu tĩ. Marã ka ym usakiha. (Arahã se ihẽ nixói.) Heta ymanihar kapitã keruhũ ta aja tĩ. Usak tar katu tĩ. Pehẽ riki ihẽ je'ẽha rehe pehendu, ame'ẽ rehe ymanihar ta hendu tar katu tĩ. Marã ka ym henduha. (Arahã se ihẽ nixói tĩ.) Pehẽ anĩ. Pehendu, a'erehe pehẽ rury katu ame'ẽ ta ke pehẽ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pe, amõ sawa'e uhyk uwyr ehe. Moise je'ẽha ke mu'e ame'ẽ ke a'e. Jesu ukwa katuha ke a'e manga tipe. Ame'ẽ ke mujawy tar katu, a'erehe pandu: —Sa'e! Ngã mu'eha nde. Myja ma'e ke ihẽ ama'e rahã, ihẽ ke Tupã muhã katu ta my — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesu pandu ipe: —Moise mupinim ame'ẽ ke rehe nde eresak. Ame'ẽ mujekwa katu. Myja nde erema'e rahã, nde ke Tupã muhã katu ta. Ame'ẽ pehĩ. Myja nde erekwa my? — aja sawa'e pe. ");
INSERT INTO urbNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Sawa'e pandu: —Kuja panduha ihĩ. Tupã riki jandema'e sawa'e te! Nde erepy'a katu te ehe. Tupã rehe nde py'a nde eremoĩ moĩ ehe rahã, epy'a katu ehe. Ehe har nde erekwa erekwa erexo rahã, epy'a katu ehe tĩ. Upa nema'e pyrãtãha namõ ma'e ke nde erema'e rahã, epy'a katu ehe tĩ. Upa nde erekwa katuha namõ epy'a katu ehe tĩ. Nde juehe nde erepy'a katu, aja ne namõ ixo ame'ẽ rehe epy'a katu tĩ — aja Jesu pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","A'e pandu: —A'e tỹ. Aja ema'e eho. Aja rahã, nde ke Tupã muhã katu ta — aja sawa'e pe. ");
INSERT INTO urbNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pe, sawa'e riki katu ame'ẽ ke a'e aja mujekwa tar katu, a'erehe Jesu pe pandu: —Awa rehe ihẽ apy'a katu ta me'ẽ te'e my? — aja sawa'e. ");
INSERT INTO urbNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","(Pe, amõ rehe a'e ipy'a katu ta me'ẽ te'e, ame'ẽ rehe har Jesu mujekwa tar katu.) A'erehe kuja sawa'e pe Jesu pandu: —Jerusarẽ ok ta ngi amõ sawa'e uhem oho. Jundéu awa ke a'e. Jeriko ok ta pe oho ixo. Arahã a'e ke ma'e mukanĩha ta pyhyk. Upa ima'e ke ame'ẽ ta mukanim raho. Nupã hũ tĩ. Tate jukwa. Pete'e túi 'y. ");
INSERT INTO urbNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","—Arahã ame'ẽ pe rupi jundéu awa tama'e pa'i oho ixo tĩ. Sawa'e rehe usak rahã, asa oho. Xupe 'ar rupi asa oho. ");
INSERT INTO urbNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","A'engi amõ sawa'e oho ixo tĩ. Pa'ima'e miasu ke a'e. Jundéu awa ke a'e tĩ. Sawa'e rehe usak rahã, ixoty usak oho. Pyrara usak tar ym ehe, a'erehe upa usak rahã, xupe 'ar rupi asa oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","—Pe, amõ sawa'e ame'ẽ rupi oho ixo tĩ. Samari ywy pe har ke a'e. (Jundéu awa aja ym ame'ẽ ke a'e. Samari ywy pe har ta ke jundéu awa putar ym. A'erehe huwajan aja saka.) Sawa'e rehe uhyk oho tĩ. Usak ehe rahã, pyrara usak ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Hake oho. Pirokiha rape rehe puhã moĩ. Ame'ẽ ke pukek tĩ. Pe, ima'e hymba 'ar pe mondo, jumen 'ar pe. Aja amõ ukweriha renda pe raho. A'ep usak katu we ehe rĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ku'ẽ rahã, hyru ngi tamatarer ke muhem. Mokõi wera rahã, wetep paraky, ame'ẽ hepyha jo'ok. Ame'ẽ ke ukweriha renda jar pe me'ẽ. Pandu ipe: “Ko riki tamatarer ihĩ. Kome'ẽ namõ sawa'e rehe esak katu kỹ. Amõ we sawa'e mukatuha rehe puhã nde erejo'ok rahã, ame'ẽ ke upa nde pe ihẽ amujywyr ta kỹ. Koropi ajywyr rahã, amujywyr ta nde pe, a'erehe sawa'e mukatuha rehe esak katu tĩ” aja ijar pe samari ywy pe har pandu — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ame'ẽ panduha upa rahã, sawa'e pe Jesu pandu: —Apo myja nde erekwa my? Mahapyr sawa'e ta usak ehe, ma'e mukanĩha ta nupã ame'ẽ ke rehe. Mahapyr sawa'e ta ngi har awa ipy'a katu ehe my? — aja Moise je'ẽha mu'e ame'ẽ ke pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","A'e pandu: —Raho ame'ẽ ke pyrara usak ehe. (Samari ywy pe har ke.) A'e riki ipy'a katu te — aja Jesu pe. A'e pandu: —A'e tỹ. Eho tĩ. Aja nde tĩ. (Nde ruwajan aja ame'ẽ rehe epy'a katu kỹ) — aja sawa'e pe. ");
INSERT INTO urbNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pe, jumu'eha ta namõ Jesu oho ixo rahã, amõ ok ta pe uhyk oho. A'ep amõ kũjã ixo. Her Mar. Hok pe Jesu ta ke mupyta katu. ");
INSERT INTO urbNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ianam inamõ ixo tĩ. Her Mari. Jesu py rake wapyk uĩ. A'ep Jesu mu'e ame'ẽ ke rehe hendu uĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mar anĩ. Ma'e ke mupupur hũ a'eta pe ixo. A'erehe ipy'a ahy tate. (Mari mupupur ym uwyr, a'erehe ipy'a ahy tate ehe.) Pe, Jesu rake oho rahã, pandu ipe: —Sawa'e! Ihẽ namõ ihẽ anam mupupur ym. Ihẽ jõ riki ma'e ke amupupur axo. Aja katu nde pe my? Epandu ipe: “Inamõ ma'e emupupur eho” aja Mari pe — aja Mar pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pe, Jesu pandu ipe: —Mar! Heta ame'ẽ ta rehe nde erejumupyai te'e hũ erexo. Nde py'a ahy tate tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Peteĩhar ma'e ke jõ nde eremupupur rahã, katu tiki. (Ma'e ke ja'u ame'ẽ ke upa harái ta ngã.) Mari anĩ. Ihẽ je'ẽha rehe hendu tar katu uĩ. Ame'ẽ je'ẽha ke Mari harái ym ta. Ame'ẽ ke katu te ame'ẽ ke — aja Mar pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Amõ renda pe Tupã namõ Jesu pandu pandu u'am. Upa pandu rahã, jumu'eha ta ngi har peteĩ pandu ipe: —Sawa'e! Myja Tupã namõ japandu ta my? Ame'ẽ ke jande ke emu'erahã! Ima'e jumu'eha ta ke Juã mujahukiha mu'e, aja jande ke emu'e tĩ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Pe, a'e pandu: —Kuja Tupã namõ pepandu: “Jande pái keruhũ! Nde rehe har amõ hendu rahã, mã peja pandu: ‘Mã katu te’ aja. Nema'e jetehar te ke rehe upa katu te awa ta hendu katu, ame'ẽ angaha ke rehe ihẽ aharõ hũ axo. ");
INSERT INTO urbNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Jande mi'u wera rahã pame katu te emuwyr. ");
INSERT INTO urbNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ma'e ka'u te'eha ke jande pe amõ ta ma'e rahã, ame'ẽ ta rehe jande py'a jamujywyr. Aja jande rehe nde tĩ. Ma'e jaka'u te'eha ke jama'e. Ame'ẽ rehe japyai. Aja rahã, jande rehe nde py'a emujywyr katu tĩ. Ma'e jaka'u te'eha ke jama'e tar katu rahã, ame'ẽ ke jande py'a ngi emukanim. (Aja rahã, jama'e ym ta)” aja pepandu ipe — aja Jesu mu'e. ");
INSERT INTO urbNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Pe, jumu'eha ta ke mu'e tĩ. (Tapijar te'e we Tupã namõ pandu pandu ta me'ẽ te'e, aja mu'e.) A'erehe kuja pandu: —Pesarahã! Pehẽ ngi har peteĩ riki ehe katu ame'ẽ rok pe oho. Pytun pyter pe oho. Pandu ipe: “Sa'e! Ne mi'u ihẽ pe emuwyr te'e rĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ihẽ rehe katu ame'ẽ ke uhyk ramõ te uwyr. Paite ngi uhyk uwyr. Myahy hũ a'e. Nixói te ihẽma'e ke apo. Ma'e ke ym ihẽ ame'ẽ ipe” aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Pesarahã! Kuja a'e pandu nahã my. Kapy ngi je'ẽha ke ehe katu ame'ẽ pe pandu: “Apo anĩ ta. Hukwen ke jykynda u'am. Ihẽ anino aju. Ta'yn ta aja tĩ. Marã ka ym apu'amiha. Marã ka ym nde pe ihẽ mi'u ihẽ ame'ẽha rĩ” aja pandu my. ");
INSERT INTO urbNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Anĩ. Pesarahã! Aja ym ta. Aja pandu ym. Ihẽ apandu pehẽ pe. Ehe katu ame'ẽ ke a'e, a'erehe pahar pu'am ta my? Anĩ. A'e riki i'i pandu pandu hũ u'am. Huxĩ ym panduha. A'erehe pu'am ta. Upa pandu ame'ẽ ke me'ẽ ta ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","—A'erehe ihẽ apandu pehẽ pe. Aja Tupã tĩ. Ma'e ke Tupã namõ pepandu. Pe, ame'ẽ ke a'e muwyr ta pehẽ pe. (Tupã namõ pepandu rahã, aja tĩ.) Pekekar, ame'ẽja saka tĩ. Pe, Tupã muwyr rahã, pemahem, ame'ẽja saka. (Amõ rok pe pexe tar katu rahã,) pehẽ po penupã nupã. Pe, hukwen ke ijar pirar. (Tupã namõ pepandu pandu rahã, ame'ẽja saka.) Pehẽ po penupã nupã, ame'ẽja saka. Inamõ pepandu pandu rahã, pe, hukwen pirar ame'ẽja saka tĩ. (Pirar rahã, pepandu ame'ẽ ke a'e muwyr ta pehẽ pe tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Upa inamõ pandu ame'ẽ ta pe a'e muwyr ta kỹ. Amõ kekar rahã, mahem ta kỹ. Ipo nupã nupã rahã, hukwen ke a'e pirar ta kỹ. Aja riki. ");
INSERT INTO urbNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","—Pesarahã! Pehẽ namõ ipái ta ixo. Pe, ta'yr pandu: “Papa! Pira ka'ẽ ihẽ a'u ta” aja. Aja rahã, mbói ke ipái me'ẽ ipe my? Anĩ. Aja ym. Pira ka'ẽ me'ẽ ta ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Pe, ta'yr pandu: “Papa! Sapukái pi'a ihẽ a'u ta” aja. Aja rahã, jawajyr ipái me'ẽ ipe my? Anĩ. Aja ym. Sapukái pi'a me'ẽ ta ipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Awa ta te'e pehẽ. Ma'e peka'u te'eha ke pema'ema'e ame'ẽ ta ke pehẽ. Pehẽ ra'yr ta pe ma'e katu ame'ẽ ke peme'ẽ me'ẽ katu. Aja rahã, pehẽ 'ar koty te we ma'e katu ame'ẽ ke jande pái keruhũ me'ẽ me'ẽ ta pehẽ pe. Ywa pe ixo ame'ẽ ke a'e. “Jande py'a rehe Ne'ã emuwyr” aja pandu ame'ẽ ta pe I'ã ke a'e muwyr katu ta — aja Jesu mu'e jumu'eha ta pe. (Aja tapijar te'e we Tupã namõ pandu pandu ta me'ẽ te'e, aja Jesu mu'e.) ");
INSERT INTO urbNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Amõ sawa'e ke ãjã muje'engai te'e. Ame'ẽ ãjã ke Jesu muhem mondo ingi. Ãjã uhem oho ingi rahã, sawa'e ma'e ke pandu pandu katu tĩ. Amõ ta pandu: —Mã! Katu tiki! — aja hetaha ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Amõ ta anĩ. Jesu rehe har kuja pandu: —Mesembu tiki. Ame'ẽ riki ãjã tama'e kapitam. Ame'ẽ riki pyrãtãha muwyr ipe, Jesu pe, a'erehe ãjã ke a'e muhem katu mondo — aja a'eta pandu naĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jesuma'e pyrãtãha ke amõ ta manga tar katu. A'erehe ame'ẽ ta pandu ipe: —Marã ka ym amõ ma'eha, ame'ẽ ke ema'e apo. Aja rahã, ima'e pyrãtãha ke Tupã muwyr nde pe, aja jakwa ta. Aja rahã, nde ke a'e riki muwyr, aja jakwa ta tĩ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Anĩ. Ame'ẽ ta ma'e ke ipy'a pe ukwa ukwa u'am ame'ẽ ke Jesu ukwa, a'erehe pandu: —Anĩ ta. Pesarahã! Ywy pe har ta amõ koty koty henda pe jy'ar. Aja jumai mai ixo ngã juehe rahã, pahar ngã jumumba ta ngã juehe. (A'erehe jumai mai ym ta ngã juehe.) Ok wyr pe har ta aja tĩ. Amõ koty koty jy'ar, pe, jumai mai ixo a'eta juehe rahã, pahar jumumba ta a'eta juehe tĩ. (A'erehe jumai mai ym ta a'eta juehe.) ");
INSERT INTO urbNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Aja Satana kotyhar ta amõ koty koty jy'ar, pe, jumai mai ixo ngã juehe rahã, marã ka ym ãjã ta ixoha. Jumumba ta ngã juehe tĩ. Satanama'e pyrãtãha namõ ãjã ke ihẽ amuhem amondo, aja pepandu rahã, ãjã ta riki jumumba ta ngã juehe, aja pepandu. Anĩ. Aja ym. ");
INSERT INTO urbNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","—Pesarahã! Ãjã ke ihẽ amuhem amondo. Pehẽ kotyhar ta aja tĩ. Ãjã ta ke muhem mondo tĩ. Awama'e pyrãtãha namõ a'eta muhem mondo my? Satanama'e pyrãtãha namõ muhem mondo my? Anĩ. Aja ym. Aja rahã, ihẽ aja tĩ. Satanama'e pyrãtãha namõ aja ym tĩ. A'erehe pehẽ je'ẽha pejawy te'e aja pehẽ kotyhar ta riki mujekwa pehẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Jetehar te ke. Amõ koty riki. Kuja. Tupãma'e pyrãtãha namõ ãjã ta ke ihẽ amuhem amondo. Aja rahã, ihẽ riki kapitã keruhũ aja Tupã mu'am ame'ẽ ke ihẽ, aja pekwa katu ta me'ẽ te'e. Peharõ katu pexo ame'ẽ ke. ");
INSERT INTO urbNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","—Sawa'e pyrãtã hũ ame'ẽ ke hok rehe usak katu rahã, parã te'e ta ima'e ke rehe ngã. Upa moĩ katu, kyse puku, itatakwar, hapar. Aja hok rehe usak katu. ");
INSERT INTO urbNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pe, i'ar koty te we sawa'e pyrãtã ame'ẽ ke jumai uwyr ehe. Pe, upa muputu'u rahã, amõ riki ijar moĩ katu ame'ẽ ke upa katu te raho, kyse puku, itatakwar, hapar. Ame'ẽ pe huwajan ke ijar muputu'u ta, aja ukwaha naĩ. Anĩ. Ame'ẽ ke i'ar koty te we pyrãtã ame'ẽ ke upa raho. Pe, upa ma'e ke raho ame'ẽ ke amõ ta pe me'ẽ me'ẽ. Inamõ ixo ame'ẽ ta pe me'ẽ me'ẽ. (Aja ihẽ tĩ. Sawa'e pyrãtã hũ ame'ẽ ke Satana aja saka. Ihẽ riki i'ar koty te we pyrãtã te hũ ame'ẽ ke ihẽ. A'erehe a'e ke ihẽ amuputu'u katu. A'erehe ãjã ta ke ngã py'a ngi ihẽ amuhem katu amondo.) ");
INSERT INTO urbNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","—Ihẽ kotyhar aja awa ixo ym rahã, ihẽ namõ jumai ame'ẽ ke a'e. Tupã koty ihẽ namõ ngã ke amõ mujy'ar ym rahã, amõ koty muhãi mondo ame'ẽ ke a'e tĩ. Tupã ruwajan koty mujy'ar mondo a'e — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","A'e pandu tĩ: —Sawa'e py'a ngi ãjã uhem oho rahã, awa nixói te ame'ẽ rupi wata wata ixo. Putu'uha renda ke kekar ixo. Mahem ym. A'erehe jupandu jupe: “Sawa'e py'a ngi ihẽ ahem ajur, ame'ẽ pe ajywyr ta aho. Ihẽ rok aja ihẽ pe” aja jupandu. ");
INSERT INTO urbNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pe, jywyr oho. Pe, uhyk oho rahã, hok pe nixói awa. Upa peir katu amõ. Upa mukatu. Aja awa py'a ke. ");
INSERT INTO urbNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ame'ẽ rehe usak rahã, amõ ãjã ta a'e oho piam. Awa po wajar mokõi hetaha a'e muhyk. Ame'ẽ ta riki i'ar koty te we jaxer ai ame'ẽ ke. Pe, muhyk rahã, sawa'e py'a rehe a'eta ixe oho. A'erehe ame'ẽ sawa'e mãte jaxer ame'ẽ ke apo. Ãjã peteĩ ixo rahã, katu ym. Apo heta ihĩ, a'erehe i'ar koty te we jaxeriha — aja Jesu pandu. (Aja awa tĩ. Jeje ixoha jumukatu aja ixo tar katu. Anĩ. Tupã rehe jurujar ym. Nixói ma'e, ame'ẽja saka. A'erehe i'i atu we rahã, ymanihar aja jywyr tĩ. Pe, jywyr rahã, i'ar koty te we jaxeriha.) ");
INSERT INTO urbNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Pe, ame'ẽ pandu rahã, amõ heta ame'ẽ ta pyter ngi kũjã pandu: —Nde ke ipusu ngi muhem, ame'ẽ ke mã hury katu a'e. Ne mãi ke. Nde ta'yn rahã, nde pe kamby me'ẽ, ame'ẽ mãi mã hury katu — aja Jesu pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pe, a'e pandu: —A'e tỹ. Amõ we tĩ. Tupã je'ẽha rehe hendu. Pe, panduha aja ma'ema'e ame'ẽ riki i'ar koty te we hury katu ame'ẽ ke a'e — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ngã hetaha juramã jy'ar ehe rahã, Jesu pandu: —Mã pehẽ katu ym riki. Marã ka ym amõ ma'eha, ame'ẽ ke ihẽ ama'ema'e, ame'ẽ ke rehe pesak tar katu. Aja rahã, Tupã riki ihẽ ke muwyr, aja pekwa ta aja pepandu tipe. Marã ka ym amõ ma'eha, ame'ẽ ke amujesak ym ta pehẽ pe. Kuja jõ amujekwa ta. Pira keruhũ pusu pe mokõi Jon ukwer. Pe, jywyr. (Manõ ym.) Aja ihẽ rehe har amujekwa ta pehẽ pe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yman te Tupã je'ẽha pandu ame'ẽ ke Jon. Pira keruhũ pusu ngi Jon uhem rahã, nini ok ta pe har ta usak ehe rahã, a'e ke Tupã muwyr, aja ukwa katu. Aja ihẽ tĩ. Manõha ngi ihẽ akwera katu ahem rahã, ihẽ ke Tupã muwyr, aja pehẽ pekwa katu ta tĩ. Aja jõ pehẽ pe amujekwa ta. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. ");
INSERT INTO urbNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","—Yman rahã, ngã ke Tupã mupyrara ta. Arahã amõ kũjã pu'am ta. Kapitã keruhũ kũjã ke a'e. Pepaite ngi Saromã mu'e ame'ẽ ke rehe hendu uwyr kwe. A'erehe yman rahã, Tupã mupyrara rahã, ame'ẽ kũjã pandu ta: “Jesu je'ẽha rehe pehendu ym. Katu ym pehẽ” aja apo pehẽ pexo ame'ẽ ta pe pandu ta. Pepaite ngi kũjã uwyr. (Amõ wata oho rahã, heta ukwer.) Warahy jurukwã koty ngi uwyr, iapyr koty ngi. Ukwa katuha namõ ma'e ke Saromã mu'e ame'ẽ ke rehe kũjã hendu uwyr. Pesarahã! Ko ihẽ axo. Saromã 'ar koty te we ihẽ akwa katuha. Anĩ. Pehendu ym ihẽ je'ẽha rehe. (A'erehe ymanihar ta 'ar koty te we pehẽ ke Tupã mupyrara ta.) ");
INSERT INTO urbNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","—Yman rahã, ngã ke Tupã mupyrara ta. Arahã Nini ok ta pe har ta pu'am ta. Jon pandu ame'ẽ ke rehe ame'ẽ ta hendu katu. Pe, ma'e ka'u te'eha ma'ema'eha ke hijar. Tupã koty ipy'a muruwak mondo. A'erehe yman rahã, Tupã mupyrara rahã, kuja pandu ta: “Jesu je'ẽha rehe pehendu ym. Katu ym pehẽ” aja pehẽ pe pandu ta. Jon pandu ame'ẽ ke rehe Nini ok ta pe har ta hendu. Pesarahã! Ko ihẽ axo. Jon 'ar koty te we ihẽ katuha ke. Anĩ. Ihẽ je'ẽha rehe pehendu ym. (A'erehe ymanihar ta 'ar koty te we pehẽ ke Tupã mupyrara ta) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","A'e pandu tĩ: —Araparin ke amõ muwera rahã, mukanim ym awa. Pander pe jupyk ym tĩ. Anĩ. Ywate henda 'ar pe moĩ. Pe, hok pe ixe uwyr ame'ẽ ta usak katu ma'e. Aja ihẽ amu'e ame'ẽ ke amukanim ym. Anĩ. Amujekwa katu ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Awa reha riki ma'e muweraha aja saka. (Aja rahã, Tupã rehe har ukwa, a'erehe ixoha katu aja ixo katu.) Pehẽ reha katu rahã, pehẽ rete rupi wera katu, ame'ẽja saka. (Aja rahã, Tupã putar aja pexoha katu, aja pexo katu ta.) Nde reha katu ym rahã, weraha nixói, ame'ẽja saka. (Aja rahã, Tupã putar, aja ym pexo.) ");
INSERT INTO urbNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","A'erehe apandu katu pehẽ pe. Pehẽ reha katu aja pexo. (Aja rahã, pexo ai te'e aja ym pexo.) ");
INSERT INTO urbNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Aja rahã, pehẽ rete rupi wera katu rahã, pytuniha nixói te rahã, upa katu te wera hũ, ame'ẽja saka. Nde rehe ma'e muwera, ame'ẽja saka. (Aja rahã, aja te'eha Tupã putar aja pexoha katu aja pexo katu te ta) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Upa Jesu pandu rahã, parise pandu ipe: —Ihẽ rok pe ma'e ke ja'u jaho rĩ — aja Jesu pe. Pe, hok pe ixe oho. Pe, ma'e ngã u'uha renda pe wapyk oho. ");
INSERT INTO urbNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pe, jundéu awa ramũi ta ukwaha aja ipo ke kutuk hũ ym ha namõ ma'e ke Jesu u'u uĩ. Ame'ẽ ke parise usak rahã, ipy'a pe ukwa ukwa uĩ: —Mã! Jundéu awa ramũi ta ukwaha aja ipo ke kutuk ym a'e. Katu ym, aja akwa — aja parise jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ame'ẽ ke Jesu ukwa, a'erehe pandu ipe: —Pehẽ parise ta! Pehẽ riki paratuxĩ aja saka. Y amõ u'uha aja tĩ. Paratuxĩ soroka ke jõ pekutuk katu. Typyha ke anĩ. Aja pehẽ pirer ke pekutuk katu. Pehẽ py'a anĩ. Juhyk aja ym pexo. Pehẽ py'a pe upa ma'e peka'u te'eha pema'ema'eha ke pekwa pekwa pexo. Amõ ta ke pemahy hũ tar katu, ame'ẽ ke pehẽ py'a pe pekwa pekwa pexo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Pehẽ peka'u te'e! Pehẽ rete ke Tupã mujã. Pehẽ py'a ke a'e mujã tĩ. (A'erehe pehẽ py'a juhyk, aja pexo ta me'ẽ te'e tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ima'e ym te ame'ẽ ta pe pehẽma'e ke peme'ẽ me'ẽ. (Aja rahã, Tupã koty pehẽ py'a pemuruwak pemondo, aja pemujekwa ta.) Aja rahã, pehẽ py'a ke juhyk aja pexo ta. ");
INSERT INTO urbNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","—Parise ta! Mã! Tupã mupyrara ta pehẽ ke. Tupã rehe pehẽ py'a pemoĩ moĩ. A'erehe ta'yr mi so'o rukwer pupur muhembykiha ke peme'ẽ ipe. Jande popa hetaha ngi peteĩ peme'ẽ. Aja ky'in ke. Ma'eywanem ra'yr aja tĩ. Aja pema'ema'eha. Amõ koty anĩ. Katu ame'ẽ ke aja ym pema'ema'e. Tupã rehe pepy'a ym tĩ. Pesarahã! Amõ we pema'ema'e ta me'ẽ te'e. Kuja. Tupã rehe pepy'a katu ta me'ẽ te'e. Katu ame'ẽ ke pema'ema'e katu ta me'ẽ te'e tĩ. Ma'e muhembykiha ke peme'ẽ ta me'ẽ te'e tĩ. Ame'ẽ me'ẽha peharái ym ta me'ẽ te'e tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","—Parise ta! Mã! Tupã mupyrara ta pehẽ ke! Jundéu awa tama'e jy'ariha renda pe peho rahã, kapitã ta wapyka pe jõ pewapyk tar katu, myrape katu te ame'ẽ ke pe. (Aja pehẽ katu te aja pemujekwa tar katu naĩ.) Ma'e muhepyha renda pe peho rahã: “Ko nde erexo. Katu nde” aja panduha jõ peputar katu. (Aja rahã, pehẽ katu te aja pekwaha naĩ.) ");
INSERT INTO urbNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","—Mã! Tupã mupyrara ta pehẽ ke! Pehẽ riki kangwerupa aja saka. Ngã ukwa ame'ẽ ke nixói, a'erehe ukwa ym ha rupi kangwerupa rupi amõ wata. (Aja rahã, ipy'a juhyk ym aja ixo apo, aja jundéu awa ta ukwa.) Aja pexo tĩ. Pehẽ py'a juhyk ym, aja te'e pexo. Ame'ẽ ke amõ ta ukwa ym. Pe, pehẽ namõ ame'ẽ ta ixo rahã, ame'ẽ ta py'a ke pemujaxer te'e ta tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pe, Moise je'ẽha mu'e ame'ẽ ta ngi har peteĩ pandu ipe: —Sawa'e! Ngã mu'eha nde. Aja nde erepandu rahã, jande rehe har nde erepandu hũ tĩ. Katu ym ihẽ pe — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ame'ẽ Moise je'ẽha mu'e ame'ẽ pe a'e pandu: —Mã! Parise ta aja pehẽ tĩ. Mã! Tupã mupyrara ta pehẽ ke tĩ. Pehẽ pemu'e ame'ẽ ke rehe marã ka ym amõ hendu katuha. Pe, pemu'e rĩ. Anĩ. Pehẽ atu pehendu ym te ehe tĩ. Katu ym aja. ");
INSERT INTO urbNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mã! Tupã mupyrara ta pehẽ ke! Pehẽ ramũi ta Tupã je'ẽha pandu ame'ẽ ta ke jukwa. Ame'ẽ ta kangwerupa ke pemukatu hũ. ");
INSERT INTO urbNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Aja rahã, pehẽ ramũi ta jukwa ame'ẽ riki katu aja pekwa tĩ. Tupã je'ẽha pandu ame'ẽ ta ke pehẽ ramũi ta jukwa. Ame'ẽ ke katu, aja pekwa. A'erehe kangwerupa ke pemukatu pexo rĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Anĩ. Upa ma'e ke Tupã ukwa katu. Kuja pandu: “Ihẽ je'ẽha pandu ame'ẽ ta ke ihẽ amondo ta. Amõ amõ ta ke amondo tĩ. Pe, amõ amõ ke ngã jukwa ta. Amõ amõ ke ngã mahy ta tĩ” aja Tupã pandu. Ukwa katu a'e. ");
INSERT INTO urbNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","A'erehe ame'ẽ ta aja pehẽ ke Tupã mupyrara ta tĩ. Kome'ẽ ywy keruhũ Tupã mujã. A'engi amõ amõ ymanihar Tupã je'ẽha pandu ame'ẽ ta ke pehẽ ramũi ta jukwa. Jukwa ame'ẽ ta ke Tupã mupyrara ta. Ame'ẽ jukwa ame'ẽ ta aja pehẽ riki upa katu te mupyraraha ke pyhyk ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ko Ambéu ke amõ jukwa py. A'engi amõ amõ ta ke ngã jukwa tĩ. Pe! Sakari ke amõ jukwa tĩ. Jetehar te ke. Ngã jukwa ame'ẽ ta ke Tupã mupyrara ta. Ame'ẽ jukwa ame'ẽ ta aja pehẽ riki mupyraraha ke pyhyk ta tĩ. Tupã riki mupyrara hũ ta — aja Jesu pandu. Tupã rehe ngã jumu'eha renda keruhũ pe kapy katu te ame'ẽ ke ihĩ. Myrape ihĩ tĩ. Ame'ẽ mokõi pyter pe Sakari ke amõ jukwa. (A'ep a'e ixo rahã, a'e ke amõ ta jukwa ym ta me'ẽ te'e. Anĩ. Jukwa riki.) Tupã rehe ipy'a ke amõ moĩ moĩ rahã, ame'ẽ myrape 'ar pe hymba hapy. ");
INSERT INTO urbNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Jesu pandu tĩ: —Moise je'ẽha mu'e ame'ẽ ta! Mã! Tupã mupyrara ta pehẽ ke! Myja Tupã je'ẽha ke amõ ukwa katu my, ame'ẽ ke pemuka'u te'e. Pehẽ atu pekwa ym tĩ. Amõ ta ukwa tar katu rahã, ame'ẽ ta ke pemuka'u te'e tĩ. A'erehe ame'ẽ ta ukwa ym tĩ. Katu ym aja — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pe, parise rok ngi Jesu uhem oho ixo rahã, parise ta je'ẽ je'ẽ hũ ipe. Moise je'ẽha mu'e ame'ẽ ta aja tĩ. Je'ẽ je'ẽ hũ ma'e ke ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ame'ẽ ta ma'e ke pandu pandu inamõ, Jesu namõ. Pe, Jesu ma'e panduha jawy rahã: “Katu ym nde” aja parise ta pandu ta. A'erehe panduha manga manga tipe. ");
INSERT INTO urbNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Heta te hũ ngã jy'ar uwyr ehe. A'erehe jumujar mujar hũ ngã juehe. Pe, jumu'eha ta pe Jesu pandu py: —Parise ta riki ipy'a pe mokõi ma'e ukwaha namõ ixo ame'ẽ ta ke a'eta. A'eta aja ym pehẽ tĩ. Ipy'a pe mokõi ukwaha namõ a'eta ixo. Ame'ẽ riki mbeju mupururukiha aja saka. Katu ym aja. ");
INSERT INTO urbNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pesarahã! Ma'e ke amõ jupyk, aja ukwaha naĩ. Anĩ. Ame'ẽ ke Tupã mupirar ta. (Aja rahã, upa mujekwa ta.) Jeje te'e ixokwa katu, aja ukwaha naĩ. Anĩ. Ame'ẽ ke Tupã mujekwa ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pe, pytun rahã, amõ ta ukwa ym ha rupi ma'e ke pepandu, ame'ẽ ke wera rahã amõ ta upa pandu ta. (A'erehe upa hendu ta, pe, ukwa ta ngã.) Kapy pe amõ pe peje'ẽ ra'yr u'am, ame'ẽ ke amõ ta pandu hũ ngã pe. (Upa ngã ukwa ta) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","A'e pandu tĩ: —Ihẽ rehe katu ame'ẽ ta ke pehẽ. Ko pehẽ pe apandu axo. Ko awa ke amõ jukwa. Ame'ẽ ta ngi pekyje ym. Jukwa, pe, a'engi amõ we marã ka ym awa ke mahyha 'y. ");
INSERT INTO urbNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ko ihẽ amujekwa ta pehẽ pe. Amõ ngi pekyje. Tupã ngi pekyje. Upa jukwa rahã, amõ we mahy ta. Je'ẽha rupi tata keruhũ pe ame'ẽ ke a'e ombor ta. Pyrara hũ ta a'ep. Jete. Apandu pehẽ pe. Pekyje katu ingi, Tupã ngi! ");
INSERT INTO urbNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","—Pehẽ anĩ. Ihẽma'e jumu'eha ta ke pehẽ. Pehẽ rehe Tupã ipy'a katu. Pesarahã! Awa po wajar peteĩhar upa hetaha ma'ewyra ra'yr rehe amõ muhepy rahã, mokõi tamatarer pu'a ra'yr me'ẽ ipe. Ame'ẽ ke Tupã ukwa katu. Ma'ewyra ra'yr rehe har ukwa katu a'e. (Aja rahã, ame'ẽ 'ar koty te we pehẽ rehe har ukwa katu, aja mujekwa katu. A'erehe pekyje ym ingi.) ");
INSERT INTO urbNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","—Pesarahã! Pehẽ ãkã rehe pehẽ'a ihĩ. Ame'ẽ hetaha ke Tupã ukwa katu. (Aja rahã, upa katu te pehẽ rehe har ukwa katu, aja mujekwa katu.) A'erehe pekyje ym ingi. Ma'ewyra ra'yr ta rehe a'e usak katu. Ame'ẽ ta 'ar koty te we pehẽ rehe a'e usak katu te we ta tĩ — aja Jesu pandu jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","A'e pandu tĩ: —Ko pehẽ pe amujekwa a'am. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ ngi amõ huxĩ ym. Amõ ta pe kuja pandu: “Jesu kotyhar ke ihẽ” aja. Aja rahã, kuja ehe har ihẽ apandu ta tĩ: “Ihẽ kotyhar ke a'e” aja Tupã je'ẽha rahoha ta pe apandu ta. ");
INSERT INTO urbNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Amõ ta anĩ. Ihẽ ngi huxĩ a'e. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ ngi huxĩ. A'erehe amõ ta pe kuja pandu: “Ihẽ anĩ. Ixotyhar aja ym ihẽ” aja pandu. Aja rahã, kuja ehe har ihẽ riki apandu ta tĩ: “Peme'ẽ anĩ. Ihẽ akwa ym peme'ẽ. Ihẽ kotyhar ym a'e” aja Tupã je'ẽha rahoha ta pe apandu ta. ");
INSERT INTO urbNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","—Ihẽ rehe amõ juru ai, ame'ẽ ke rehe Tupã ipy'a jywyr ta. (Tupã koty ipy'a muruwak rahã, Tupã ipy'a jywyr ta ehe.) Tupã'ã rehe juru ai rahã, anĩ. Amõ juru ai ehe rahã, ame'ẽ rehe Tupã ipy'a jywyr ym te ta. ");
INSERT INTO urbNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","—Jundéu awa tama'e jy'ariha renda pe pehẽ ke amõ ta hykýi ta raho. Ihẽ rehe pejurujar katu, a'erehe mupyrara ta raho. Kapitã ruwa koty pehẽ ke raho ta tĩ. Kapitã ruwa koty aja tĩ. Mupyrara ta raho tĩ. Arahã myja pehẽ juehe har pepandu ta my, ame'ẽ rehe har pekwa pekwa ym pexo. Ma'e pepandu ta my, ame'ẽ rehe har pekwa pekwa ym pexo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Arahã Tupã'ã riki mujekwa ta pehẽ pe. Ma'e pepandu ta, ame'ẽ ke mujekwa ta pehẽ pe. (Ame'ẽ ke pepandu ta) — aja Jesu pandu jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Hetaha ta pyter ngi amõ sawa'e pandu ipe: —Sawa'e! Ngã mu'eha nde. Jande pái manõ. Pe, upa ima'e ke hijar jande pe. Ame'ẽ ngi har: “Ne mu pe eme'ẽ tĩ!” aja ihẽ mu pe epandu. Ihẽ mu riki upa katu te pyhyk — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","A'e pandu: —Sa'e! Anĩ. Esarahã! “Ihẽ amanõ rahã, ihẽ ra'yr ta pe ihẽma'e ke eme'ẽ me'ẽ” aja nde pái pandu ym te ihẽ pe. A'erehe ame'ẽ me'ẽ ym ta nde páima'e ke — aja sawa'e pe. ");
INSERT INTO urbNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Upa ngã pe a'e pandu tĩ: —Pehendu katurahã! Upa katu te ma'e ke rehe pehẽ py'a pemoĩ moĩ tar katu rahã, pesak katu te'e. Pemoĩ ym pehẽ. Pesarahã! Ima'ehũ namõ amõ ixo. Aja rahã, kome'ẽ ywy keruhũ pe yman rahã ixo katu ta, aja ukwaha naĩ. Anĩ. Aja ym ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","(Pe, ame'ẽ rehe har mujekwa te we. Upa ma'e ke rehe ipy'a moĩ moĩ rahã, katu ym aja mujekwa tar katu.) A'erehe myja me'ẽ ima'ehũ matyr ame'ẽ ke my, ame'ẽ ke pandu: —Ko amõ sawa'e ixo. Ima'ehũ namõ ixo ame'ẽ ke a'e. Pe, heta te hũ ma'e ke kupixa pe ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Pe, ipy'a pe ma'e ukwa ukwa uĩ: “Mã! Kupixa ngi marã ka ym ma'e matyriha. (Tyryhem apo 'y.) Nixói te matyriha renda ke. Myja ta apo my?” aja sawa'e jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pe, kuja ame'ẽ jupandu jupe: “Aa! Akwa apo. Matyriha renda ihẽ amutiha te we ta apo. I'ar koty te we hũ tiha ame'ẽ ke amujã ta. A'ep ihẽma'e ke amatyr ta. Kupixa ngi ma'e matyr ame'ẽ ke amoĩ ta ipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Upa rahã, ihẽ ajupandu ta ihẽ jupe. ‘Mã! Katu tiki ihẽ pe. Yman rahã, pehũ ta ihẽma'e ke. Aputu'u katu. Ihẽ mi'u amatyr. Ajumuhury katu ihẽ juehe’ aja ihẽ pe” aja sawa'e pandu jupe tipe. ");
INSERT INTO urbNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Anĩ. Aja ym ta. Ywa ngi Tupã pandu: “Nde riki ereka'u te'e! Kome'ẽ pytun rahã, nde eremanõ ta kỹ. Pe, nema'e matyr hũ ame'ẽ ke awa pe nde eremupyta ta my? Nde pe anĩ. Amõ pe nde eremupyta ta riki, aja Tupã pandu” — aja Jesu mu'e. ");
INSERT INTO urbNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Pe, a'e pandu tĩ: —Aja ta riki amõ pe. Ima'e ma'e ke jõ amõ matyr hũ rahã, aja ta. Pe riki Tupã koty nixói te ta ma'e ke. Ma'e katu ame'ẽ ke nixói te ta. Katu ym aja — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","(Ma'e ke jõ amõ matyr hũ rahã, katu ym, aja mu'e tar katu tĩ.) A'erehe jumu'eha ta pe Jesu pandu: —Pesarahã! Pehẽ pe apandu katu. Pehẽ mi'u rehe har jõ pejumupyai ym pexo. “Ma'e jande ja'u ta my? Nixói ma'e. Jandema'e mundeha nixói. Awa me'ẽ ta jande pe my?” aja pejumupyai ym pexo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ixoha namõ amõ ixo rahã, ame'ẽ riki awa mi'u 'ar koty te we katuha. Awa rete aja tĩ. Awama'e mundeha 'ar koty te we katuha tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ma'ewyra rehe pesarahã! Jytym ym ma'e ke. Matyr ym ma'e ke tĩ. Ma'e matyriha renda nixói tĩ. Humi'u ke Tupã me'ẽ katu ipe. Pesarahã! Ma'ewyra 'ar koty te we pehẽ pexoha katuha ke. (A'erehe pehẽ rehe Tupã usak katu ta aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","—“Myja hetaha warahy 'ar rahã, ko pehẽ pexo ta my” aja pekwa pekwa pexo rahã, yman pepyta te we ta rĩ, aja pekwaha naĩ. Anĩ. Marã ka ym pexoha pemupyta te we ta rĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Aja ta'yr mi marã ka ym pexoha pemupyta te we ta rĩ. Aja rahã, amõ ma'e ke rehe pejumupyai ym pexo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","—Ma'eputyr rehe pesarahã! Ma'e puwan ym. Ima'e ma'e ke mujã ym tĩ. Amõ usak ehe rahã, katukwer. Apandu katu pehẽ pe. Ymanihar Saromã ima'ehũ te namõ ixo. Ima'e mundeha katukwer tĩ. Pesarahã! I'ar koty te we ma'eputyr katu te ha ke. ");
INSERT INTO urbNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tupã riki ma'eputyr ke mukatu te. Apo putyr katu. Koĩ upa ta kanim. Upa xirik. Ame'ẽ ke jape'a aja amõ hapy. Upa ukwái. Pesarahã! Ma'eputyr ke a'e mukatu te rahã, pehẽma'e mundeha ke a'e me'ẽ katu ta pehẽ pe tĩ. Mã! Ame'ẽ rehe pejurujar katu ta me'ẽ te'e tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Pehẽ pe'u ame'ẽ ke rehe pekekar pexo. Aja te'eha ym pehẽ. Ame'ẽ rehe jõ pejumupyai ym. ");
INSERT INTO urbNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ame'ẽ ke rehe jõ kome'ẽ ywy pe har ta kekar kekar ixo. Aja te'eha ixo. Tupã rehe ipy'a ym ame'ẽ ta ke a'eta. Aja pexo ym tĩ. Pehẽ mi'u peputar. Pehẽma'e mundeha peputar. Ame'ẽ ke pehẽ pái keruhũ ukwa katu. (Pehẽ pe a'e muwyr ta.) A'erehe ame'ẽ ke rehe jõ pejumupyai ym pexo. ");
INSERT INTO urbNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kuja katu. Myja Tupã putar ame'ẽ ke pema'ema'e katu ta my? Ame'ẽ rehe har pekwa pekwa py pexo. Aja rahã, upa pehẽma'e nixói ame'ẽ ke a'e muwyr ta pehẽ pe tĩ — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jumu'eha ta pe a'e pandu tĩ: —Ihẽ kotyhar ta ke pehẽ! Heta ym pehẽ. Apandu katu pehẽ pe. Ngã ngi pekyje ym pexo. Pehẽ rehe pehẽ pái keruhũ usak katu te ixo, a'erehe ngã ngi pekyje ym pexo. Yman rahã, henda ke pe pehẽ ke a'e raho ta tĩ. Aja a'e putar. ");
INSERT INTO urbNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pehẽma'e ke upa katu te pemuhepy. Pe, ame'ẽ tamatarer ke ima'e ym te ame'ẽ ta pe peme'ẽ me'ẽ. Pe, tamatarer ryru ijuk ym aja me'ẽ namõ pexo. Ame'ẽ riki ywa pe ihĩ, ame'ẽja saka. Ywa pe pehẽma'e hũ namõ pexo, ame'ẽja saka. A'ep ame'ẽ ke kanim ym te ta. Ma'e mukanĩha nixói. A'erehe mukanim ym te ta awa. ");
INSERT INTO urbNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pehẽma'e ke ihĩ. Ame'ẽ rehe har pekwa pekwa pexo. A'erehe ywa pe pehẽma'e ke ihĩ rahã, a'ep pehẽ py'a ihĩ ta tĩ — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","A'e pandu tĩ: —Peharõ katu pexo! Pehẽma'e kamixa pemunde katu. Pehẽma'e xirur aja tĩ. Pemunde katu tĩ. Araparin pemuwera katu aja pexo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ijar rehe miasu ta harõ ixo. (Aja ihẽ rehe peharõ katu pexo tĩ.) Jumendariha rehe ngã mi'u matyr. Ame'ẽ upa rahã, ijar jywyr uwyr. Ame'ẽ ke rehe miasu ta harõ ixo. A'e jywyr uwyr rahã, pukái ta. Pe, pahar miasu ta hukwen ke pirar ta. ");
INSERT INTO urbNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Miasu ta harõ katu ixo. Ukwer ym ngã tĩ. Ame'ẽ ke ijar ukwa rahã, miasu ta hury katu ta. Apandu pehẽ pe. Kamixa ke ijar pypyk katu ta, xirur wyr rupi. Pe, miasu ta pepandu ta: “Ma'e ngã u'uha renda pe pewapyk peho” aja. Pe, a'e atu ngã mi'u ke moĩ ta, miasu ta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pytun pyter pe ijar jywyr ta uwyr my. Satur rahã we ta jywyr my. Miasu ta harõ katu ixo. Ame'ẽ ke ijar usak rahã, miasu ta hury katu ta. ");
INSERT INTO urbNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pesarahã! Ma'e mukanĩha uwyriha angaha ke rehe ok jar ukwa katu rahã, ukwer ym ta tipe. Harõ ta tipe. Pe, a'e ke muputu'u ta tipe. Hok ke ma'e mukanĩha musorok ym ta tipe. ");
INSERT INTO urbNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","—Pehẽ aja tĩ. Ihẽ rehe peharõ katu pexo. Awa aja ihẽ tĩ. Tupã je'ẽha rupi ajur. Ywa ngi ihẽ riki ajywyr rahã, peharõ katu pexo my. “Jywyr ym ta apo rĩ” aja pekwa pekwa pexo rahã, pahar ihẽ ajywyr ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pe, Petu pandu ipe: —Sawa'e! Apo myja me'ẽ miasu harõ katu ixo my, ame'ẽ ke nde erepandu. Ame'ẽ ke jande pe jõ nde erepandu my? Upa ngã pe nde erepandu my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A'e pandu: —Ihẽ kotyhar ta pe jõ apandu. Upa ihẽ kotyhar ta ihẽ rehe harõ katu ta me'ẽ te'e. Ijar rehe miasu harõ katu. Aja ihẽ rehe harõ katu ta me'ẽ te'e tĩ. Pesarahã! Myja me'ẽ miasu riki ukwa katu ame'ẽ ke my? Myja me'ẽ miasu riki ijar pandu ame'ẽ ke ma'ema'e katu my? Ko apandu ta. Amõ miasu pe ijar pandu: “Amõ miasu ta rehe esak esak katu exo. Myahy rahã, ngã mi'u ke eme'ẽ me'ẽ katu ngã pe” aja ijar pandu. (Pe, ijar paxia oho.) ");
INSERT INTO urbNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pe, ijar pandu, aja miasu ma'ema'e ixo. Hok pe jywyr rahã, ame'ẽ ke rehe ijar usak. Aja rahã, ame'ẽ miasu hury katu ta. ");
INSERT INTO urbNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Pesarahã! Apandu pehẽ pe. Ame'ẽ miasu pe kuja ijar pandu ta: “Katu ame'ẽ ke nde. Upa katu te ihẽma'e ke rehe nde esak esak katu ta apo 'y” aja ta. ");
INSERT INTO urbNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","—Amõ kotyhar rahã, katu ym. Miasu katu ym ame'ẽ ke rahã, kuja jupandu jupe: “Ihẽ jar pepaite oho. Yman rahã, jywyr ta” aja jupe. Pe, amõ miasu ta ke a'e nupã hũ. Sawa'e ta ke. Kũjã ta ke aja tĩ. Nupã hũ tĩ. Pe, ma'e ke jeje u'u te'e hũ uĩ. Kawĩ ngi ka'u tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Pe, ijar rehe harõ ym rahã, ame'ẽ wera rahã, ijar jywyr ta. “Apo jywyr ym we ta rĩ” aja pandu rahã, pahar ijar jywyr ta. Pe, ame'ẽ ke ijar mupyrara hũ ta. Tupã rehe hendu ym ame'ẽ ta ke Tupã mupyrara hũ ta. Aja ijar mupyrara hũ ta. Miasu katu ym ame'ẽ ke mupyrara hũ ta. ");
INSERT INTO urbNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","—Ijar pandu ame'ẽ ke miasu ukwa katu tipe. Anĩ. Ukwaha aja ma'ema'e ym. Jeje ima'e ke ma'ema'e ixo rĩ. Hendu ym ehe, ijar rehe. Aja rahã, ijar mahy hũ ta a'e ke. Pirok hũ ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pe, amõ ihĩ. Ijar pandu ame'ẽ ke miasu ukwa ym. Pe, a'e ma'ema'eha katu ym. Ijar mahy a'e ke rahã, katu tiki. Mahy rahã, pirokiwe mi ta. Ukwa ym ha namõ miasu ma'ema'e, a'erehe pirokiwe mi ta. Aja ihẽ kotyhar ta tĩ. Pekwa katu rahã, pehendu katu ta me'ẽ te'e. I'ar koty we pekwa katu rahã, i'ar koty te we pehendu katu ta me'ẽ te'e — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","A'e pandu tĩ: —Ihẽ ajur, a'erehe kome'ẽ ywy pe har ta amõ koty koty jy'ar ta. Ame'ẽ ke upa rahã, katu ta tipe. Ame'ẽ upaha ihẽ aputar. ");
INSERT INTO urbNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Amõ ta ihẽ ke mupyrara hũ ta me'ẽ te'e. Ame'ẽ upa ym we rĩ. A'erehe ihẽ apyai te'e axo we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kome'ẽ ywy pe har ta jumai mai ixo. Ame'ẽ ke ihẽ amuputu'u ajur, aja pekwaha my? Anĩ. Aja ym. Ko pehẽ pe apandu. Ihẽ ajur, a'erehe amõ koty koty amõ ta jy'ar jy'ar ta. ");
INSERT INTO urbNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Apo ngi har ok wyr pe awa po peteĩhar upa hetaha ta ixo. Ihẽ rehe mahapyr jurujar katu ta. Mokõi anĩ ta. Amõ rahã, ihẽ rehe mokõi jurujar katu ta. Mahapyr anĩ ta. Aja amõ koty koty jy'ar jy'ar ta. ");
INSERT INTO urbNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ihẽ rehe ipái ta jurujar katu ta. Ta'yr ta anĩ. Pe, ihẽ rehe ta'yr ta jurujar katu ta. Ipái ta anĩ. Ihẽ rehe imãi ta jurujar katu ta. Imembyr kũjã ta anĩ. Ihẽ rehe imembyr kũjã ta jurujar katu ta. Imãi ta anĩ. Ihẽ rehe imembyr reko ame'ẽ ta jurujar katu ta. Kũjã ta anĩ. Ihẽ rehe kũjã ta jurujar katu ta. Imembyr reko ame'ẽ ta anĩ ta. Aja amõ koty koty jy'ar jy'ar ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ngã pe pandu tĩ: —Aman pihuniha rehe pesak rahã, pahar pepandu: “Aa! Aman ukyr ta” aja. Pe, pahar aman ukyr. ");
INSERT INTO urbNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pe, ywytuhu rahã, pepandu: “Aa! Warahy haku ta apo” aja pepandu. Pe, warahy hakuha uwyr. ");
INSERT INTO urbNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mã! Mokõi pekwaha namõ pexo! Ywa rehe ihĩ ame'ẽ ke rehe pesak rahã, ame'ẽ ke pekwa katu. Ywy rupi ihĩ ame'ẽ ke aja tĩ. Pekwa katu tĩ. Ihẽ rehe har anĩ. Marã ka ym amõ ma'eha, ame'ẽ ke ihẽ ama'ema'e katu tipe. Ame'ẽ rehe pesak tipe. Anĩ. Ihẽ riki Tupã muwyr ame'ẽ ke ihẽ, aja pekwa ym te riki — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","A'e pandu tĩ: —“Katu ame'ẽ ke ihẽ ama'ema'e. Ame'ẽ ke ihẽ akwa katu” aja nde erepandu. Aja rahã, katu ame'ẽ ke nde erema'e ta me'ẽ te'e. ");
INSERT INTO urbNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Esarahã! Nde rehe har ne ruwajan pandu: “Katu ym nde. A'erehe ngã panduha renda pe nde ke araho ta” aja riki. Mã! Inamõ nde ereho erexo rahã, emukatu. “Mã peja ym. Eraho ym ihẽ ke. Ihẽ rehe nde py'a emujywyr katu. Katu ta apo 'y” aja pahar emukatu. Aja rahã, ngã panduha ruwa koty nde ke raho ym ta. Anĩ rahã, nde eremukatu ym rahã, nde ke raho ta. Aja rahã, sonda ta pe nde ke mondo ta. Pe, kyndaha pe nde ke sonda ta kynda ta raho. ");
INSERT INTO urbNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Apandu nde pe. Nde erehem ym te ta ingi. Mukatuha rehe upa katu te nde eremuhepy ym rahã, kyndaha ngi nde erehem ym te ta. (A'erehe mã peja pahar emukatu. Katu ame'ẽ ke ema'e katu) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Arahã, amõ ta Jesu rehe uhyk uwyr. Pandu ipe: —Hymba ke amõ ngariréi ywy pe har ta hapy hapy ixo. Aja Tupã rehe ipy'a ke moĩ moĩ u'am. Arahã, ame'ẽ ta ke Pirat je'ẽha rupi amõ ta jukwa. Mã! Ame'ẽ ta jaxer ai te'e nahã my? — aja Jesu pe pandu uwyr. ");
INSERT INTO urbNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Pe, Jesu pandu: —Hã! Aja ame'ẽ ngariréi ywy pe har ta ke amõ ta jukwa. A'erehe kuja pekwaha my: “Mã! Ame'ẽ ta jaxer ai ame'ẽ ta ke nahã my? Amõ ngariréi ywy pe har ta 'ar koty te we jaxer te” aja pekwaha naĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Anĩ. Aja ym. Ko pehẽ pe apandu. Ma'e peka'u te'eha pema'ema'eha ngi Tupã koty pehẽ py'a pemuruwak ym rahã, ame'ẽ ngariréi ywy pe har ta aja pemanõ ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","—Amõ we tĩ. Siroe renda pe heta ngã ixo. Awa py wajar mahapyr hetaha ixo. Ame'ẽ ta rehe ywy pirã ok u'ar ukwa. Ok ywate ame'ẽ ke u'ar. Upa ngã ke jukwa. Kuja pekwaha my: “Mã! Ame'ẽ ta jaxer te. Jerusarẽ ok ta pe har ta 'ar koty te we jaxer te” aja pekwaha my? ");
INSERT INTO urbNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Anĩ. Aja ym. Ko pehẽ pe apandu katu. Ma'e peka'u te'eha pema'ema'eha ngi Tupã koty pehẽ py'a pemuruwak ym rahã, ame'ẽ ta aja upa katu te pemanõ ta tĩ — aja Jesu pandu. (“Pemanõ ta” aja pandu rahã: “Mupyraraha renda pe mupyrara ta” aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Pe, myja me'ẽ ma'eywa'y my, ame'ẽ ke a'e pandu: —Ma'eywa'y rehe amõ sawa'e usak oho. Hok rake i'ãi ame'ẽ ke. Ma'eywa rehe usak oho tĩ. Anĩ. I'a ym. Nixói. ");
INSERT INTO urbNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Pe, kupixa usakiha pe ijar pandu: “Esarahã! Yman ma'eywa ke ihẽ apo'ok ta tipe. Mahapyr warahy 'ar rahã, kome'ẽ ma'eywa'y ngi apo'ok ta tipe. I'a ym te riki. Ma'ewã kuja i'ãi my. Katu ym. Emondok embor” aja ijar pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pe, kupixa usakiha pandu ipe: “Sa'e! Anĩ we rĩ. Mã pewe i'ãi rĩ. Ko ywy ke hake rupi ihẽ amungái mungái we ta rĩ. Ame'ẽ rupi ma'e muhuryha ihẽ amoĩ ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Pe, amõ i'aha angaha ke rehe uhyk rahã, i'a rahã, katu ta tiki. I'a ym rahã: ‘Emondok embor’ aja ihẽ pe nde erepandu ta kỹ. Pe, ihẽ amondok ta” aja ijar pe kupixa usakiha pandu — aja Jesu pandu. (Aja Tupã tĩ. Ma'e ka'u te'eha ma'ema'eha ngi ipy'a ke ngã muruwak mondo. I'a katu, ame'ẽja saka. Ixoty muruwak mondo, ame'ẽ ke rehe Tupã harõ we rĩ. Pyrara usak we ehe rĩ. Muruwak ym rahã jõ, pe, mupyrara ta ngã ke. I'a ym, ame'ẽja saka.) ");
INSERT INTO urbNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Amõ jundéu awa tama'e putu'uha 'ar rahã, jundéu awa tama'e jy'ariha renda pe Jesu mu'e uĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","A'ep amõ kũjã ihĩ. Ãjã ipy'a rehe ihĩ ame'ẽ ke a'e, a'erehe ahy hũ. Yman te ahy ixo. Heta te hũ warahy 'ar rahã, aja te'e ixo. Kuja, 18 hetaha warahy 'ar rahã, aja ixo. Jixiko te'e wata. Marã ka ym pu'am katu wataha. ");
INSERT INTO urbNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesu usak ehe rahã, pandu ipe: —Nde katu apo 'y — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Aja pandu rahã, iãkã rehe ipo ke mujar. Aja rahã, pahar katu pu'am u'am. Tupã pe: “Mã! Ne jõ riki katu te me'ẽ ke” aja kũjã pandu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jy'ariha rendama'e kapitã parahy ehe, Jesu rehe. Jundéu awa tama'e putu'uha 'ar rahã, Jesu mukatu. (Aja rahã, paraky te'e, aja ukwaha naĩ, a'erehe parahy ehe.) A'erehe a'ep ihĩ, ame'ẽ ta pe pandu: —Awa po wajar peteĩ wera rahã jõ, ma'e ke amõ ma'ema'e katu. Ame'ẽ wera rahã jõ, amõ mukatu katu pehẽ ke. Ame'ẽ wera rahã jõ mukatuha rehe pejur. Putu'uha 'ar rahã, anĩ ta. Mukatu ym ta me'ẽ te'e — aja jy'ariha rendama'e kapitã pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jesu pandu: —Mã! Putu'uha 'ar rahã ihẽ aparaky, aja pekwaha naĩ. Anĩ. Pesarahã! Upa pehẽ ngi har amõ tapi'iruhu ke jirar ta raho. Kurar ngi y ke me'ẽ ta raho. Jumen ke aja tĩ. Putu'uha 'ar rahã, aja te'e pehẽ. Ame'ẽ peparaky, ame'ẽja saka tĩ. (Pehẽ py'a pe mokõi pekwaha namõ pexo!) Katu ym aja. ");
INSERT INTO urbNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pesarahã! Ko kũjã riki Amarã rainõ ke. (A'erehe Tupã usak katu ehe, ame'ẽ ke a'e tĩ.) Kuja, 18 hetaha warahy 'ar rahã, a'e ke Satana mupyrara. (Ãjã ramũi a'e.) Mujixiko mahy. A'erehe apo putu'uha 'ar rahã, kũjã ahyha ke amukatu. Apo jõ putu'u a'e 'y — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Aja pandu rahã, huwajan ta huxĩ. A'e pandu katu, a'erehe ame'ẽ ta huxĩ ingi. Amõ ta anĩ. Hury katu riki. Upa ma'e katu ame'ẽ ke Jesu ma'ema'e. A'erehe hury katu ngã ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesu pandu: —Kome'ẽ ywy keruhũ pe Tupã kotyhar ta ixo. Ame'ẽ ta riki kuja saka. ");
INSERT INTO urbNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kupixa pe ma'e ra'ĩ ta'yr te mi ame'ẽ ke sawa'e jytym. Mosata ra'ĩ ke. Ame'ẽ hywõi. I'y tiha te hũ oho rahã, myra aja tiha oho tĩ. Pe, hãkã rehe ma'ewyra ta haity mujã mujã — aja Jesu pandu. (Aja rahã, Jesu pandu py rahã, Tupã kotyhar ta heta ym te. Ma'e ra'ĩ ta'yr te mi, ame'ẽja saka. I'i atu te rahã, ixotyhar ta heta te hũ ta. I'y tiha te hũ, ame'ẽja saka, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","A'e pandu tĩ: —Kome'ẽ ywy keruhũ pe Tupã kotyhar ta ixo. Ame'ẽ ta riki kuja saka. ");
INSERT INTO urbNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ahúi aja me'ẽ ku'i pe ma'e mupururukiha ke kũjã mupara. Rar tyryhem mupara. Upa rahã, upa ahúi aja me'ẽ ku'i pururuk hũ oho — aja Jesu. (Aja rahã, pandu py rahã, Tupã kotyhar ta heta ym. I'i atu te rahã, heta te hũ ta aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jerusarẽ ok ta pe Jesu oho ixo rahã, amõ amõ ok ta ra'yr rupi ngã ke mu'e mu'e oho ixo. Awa renda rupi aja tĩ. Mu'e mu'e oho tĩ. Aja Jerusarẽ ok ta koty oho ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pe, amõ pandu ipe: —Sawa'e! Tupã muhã katu ame'ẽ ta heta ym my? — aja Jesu pe. A'e pandu: ");
INSERT INTO urbNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Hukwen ta'yr mi rupi amõ ixe. Pehẽma'e pyrãtã katuha namõ mã peja pexerahã! Ko pehẽ pe apandu. Heta ame'ẽ ta ixe tar katu tipe. Marã ka ym ixeha. ");
INSERT INTO urbNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Pesarahã! Ok jar pu'am ta. Pe, hukwen ke kynda ta. Pe, soroka pe pepukái pe'am: “Sa'e! Epirar jande pe” aja ipe. Pe, a'e pandu ta: “Anĩ ta. My pe har pehẽ my? Akwa ym ihẽ” aja pehẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Pe, pepandu: “Nde erekwa riki. Nde namõ ma'e ke ja'u katu. A'erehe nde rehe katu ame'ẽ ta ke jande. Jande rekoha pe Tupã je'ẽha ke nde eremu'e katu jande ke. Jahendu riki” aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","A'e pandu tĩ: “Anĩ. My pe har pehẽ my? Akwa ym ihẽ. Ma'e peka'u te'eha ke pema'ema'e ame'ẽ ta ke pehẽ. Pejywyr peho ihẽ ngi” aja pehẽ pe ok jar pandu ta. (Ihẽ riki ame'ẽ ok jar aja saka.) ");
INSERT INTO urbNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","—Tupã ixo ame'ẽ pe huryha namõ Amarã ixo. Isak aja tĩ. Jako aja tĩ. Huryha namõ ixo tĩ. Upa katu te Tupã je'ẽha pandu ame'ẽ ta aja tĩ. A'ep huryha namõ ixo tĩ. Pehẽ anĩ. Soroka pe pepu'am ta. Ame'ẽ rehe pesak rahã, pejixi'u hũ ta. Tupã rehe peparahy ta, a'erehe pehẽ rãi pesu'u su'u ta. ");
INSERT INTO urbNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Heta ame'ẽ ta jy'ar ta uwyr. Amõ awa ta jy'ar ta uwyr. Jundéu awa aja ym ame'ẽ ta jy'ar ta uwyr. Warahy uhemiha koty ngi jy'ar ta uwyr. Warahy u'ariha koty ngi aja tĩ. Jy'ar ta uwyr tĩ. Warahy jurukwã koty ngi aja tĩ. Jy'ar ta uwyr tĩ. Iapyr koty ngi. Tumaha koty ngi aja tĩ. Jy'ar ta uwyr tĩ. Tupã ixo ame'ẽ pe jy'ar ta uwyr. Tupãma'e imi'u matyriha rehe wapyk ta uwyr. Hury katu te hũ ta ngã. ");
INSERT INTO urbNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Upa katu te ame'ẽ ta rehe Tupã juja katu te ipy'a katu ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Arahã amõ parise ta uhyk ehe. Pandu ipe: —Eho nde sengi! Nde ke Ero jukwa tar katu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","A'e pandu: —Jawaran aja saka a'e. Ngã jukwaha ke. Kuja pepandu peho ipe: “Apyta we ta rĩ. Apo ngã py'a ngi ãjã ta ke amuhem amondo axo. Apo ma'e ahy ixo ame'ẽ ta ke amukatu axo tĩ. Koĩ aja ta tĩ. Koĩ har pewe ihẽ ama'eha ke amumba ta” aja Ero pe pepandu peho. ");
INSERT INTO urbNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mã! Ihẽ aho we ta me'ẽ te'e rĩ. Koĩ aja tĩ. Koĩ har pewe aja tĩ. Pe, Jerusarẽ ok ta pe ahyk ta. Jerusarẽ ok ta pe jõ Tupã je'ẽha pandu ame'ẽ ke amõ jukwa ta me'ẽ te'e. Amõ renda pe anĩ — aja Jesu. (Aja rahã, Jerusarẽ ok ta pe a'e manõ ta, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","A'e pandu tĩ: —Jerusarẽ ok ta pe har ta! Mã! Ima'e je'ẽha pandu ame'ẽ ta ke Tupã muwyr rahã, ame'ẽ ta ke pejukwa. Myrandu katu pandu ame'ẽ ta ke a'e muwyr rahã, ita ra'yr pe pejukwa tĩ. Jerusarẽ ok ta pe har ta! Pehẽ kotyhar ta ke amõ amõ rahã, ihẽ amujy'ar tar katu. Amujy'ar rahã, pehẽ ke amõ ta jukwa ym ta tipe. Anĩ. Amujy'ariha ke peputar ym. Sapukái ra'yr ta ke ipypo wyr pe imãi mujy'ar inom, aja pehẽ ke amujy'ar tar katu tĩ. Anĩ. Peputar ym. ");
INSERT INTO urbNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Jerusarẽ ok ta pe har ta! Pehẽ rekoha ke pehẽ pe te'e Tupã hijar oho. Ko pehẽ pe apandu katu. Kuja pepandu ta: “Mã peja jandema'e sawa'e te muwyr ame'ẽ ke rehe Tupã usak katu” aja ta pehẽ. Aja pepandu rahã jõ, ihẽ rehe pesak ta tĩ. Ihẽ riki Tupã muwyr ame'ẽ ke — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Amõ jundéu awa tama'e putu'uha 'ar rahã, Jesu pe amõ parise pandu. Parisema'e kapitã a'e. —Ihẽ rok pe ihẽ namõ ja'u jaho — aja. Pe, inamõ ma'e ke Jesu u'u oho. Parise rok pe uhyk rahã, amõ ta usak usak katu ehe. Putu'uha 'ar rahã, mukatu ta my? Mukatu rahã: “Nde katu ym” aja pandu ta, a'erehe usak usak ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Huwa koty amõ sawa'e wata uwyr. Ijywa ke punga rãi ipe. Itymã ke aja tĩ. Punga rãi tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pe, Moise je'ẽha mu'eha ta pe Jesu pandu. Parise ta pe pandu tĩ: —Myja Moise je'ẽha rehe panduha ihĩ my? Jundéu awa tama'e putu'uha 'ar rahã, ahy ixo ame'ẽ ke amõ mukatu katu my? Anĩ ta my? — aja Jesu a'eta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Anĩ. A'eta pandu ym te ipe. “Ma'e katu ame'ẽ ke ema'e ym” aja Moise je'ẽha pandu ym. A'erehe a'eta pandu ym te ipe. Pe, sawa'e po ke Jesu pyhyk. Mukatu. Pe, hok pe mujywyr mondo. Katu aja mujywyr mondo. ");
INSERT INTO urbNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pe, a'ep pe har ta pe Jesu pandu: —Pehẽ ngi har ta'yr ywykwar typy ame'ẽ pe u'ar rahã, pahar amõ jo'ok ta ingi. Putu'uha 'ar rahã, u'ar. Pahar jo'ok ta ingi. Tapi'iruhu u'ar rahã, aja tĩ. Putu'uha 'ar rahã, u'ar tĩ. Pahar jo'ok ta ingi tĩ. (A'erehe putu'uha 'ar rahã, ahy ixo ame'ẽ ke amukatu rahã, katu tiki tĩ) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ame'ẽ panduha rehe marã ka ym je'ẽha ke amõ ta mujywyriha ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ma'e ke amõ ta u'u uwyr rahã, wapyka katu te ame'ẽ pe wapyk wapyk oho. Ame'ẽ rehe Jesu usak rahã, myja me'ẽ ma'e ke my, ame'ẽ ke pandu ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Jumendariha rehe ngã mi'u ke amõ matyr rahã: “Ejur se nde tĩ” aja ijar pandu nde pe. Aja rahã, kapitã rake ewapyk ym eho. Nde erewapyk rahã, nde 'ar koty te we sawa'e katu ame'ẽ ke ijar mujy'ar my tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Pe, nde pe pandu uwyr. “Nde wapyka ke kome'ẽ sawa'e pe eme'ẽ” aja nde pe ijar pandu. Aja rahã, nde ruxĩ ta ingi. Amõ wapyka, xupe kotyhar pe nde erewapyk ta ereho. ");
INSERT INTO urbNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","—Pesarahã! Kuja katu. Nde pe ngã mi'u jar pandu: “Ejur se nde tĩ” aja. Nde ereho rahã, xupe kotyhar wapyka pe ewapyk eho. Pe, nde rehe ijar uhyk uwyr rahã, pandu nde pe: “Anĩ! Sa'e! Se koty ewapyk ejur. Wapyka katu te ame'ẽ pe ewapyk ejur” aja ngã mi'u jar. Aja rahã, nde rehe a'ep ihĩ ame'ẽ ta usak. Aja rahã, nde rury katu ta. ");
INSERT INTO urbNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","—“Ihẽ riki amõ ta 'ar koty te we katuha” aja jupe ukwa rahã, ame'ẽ ke Tupã muhuxĩ ta. “Ihẽ riki amõ ta 'ar koty te we katuha aja ym ihẽ” aja jupe ukwa rahã, ame'ẽ ke Tupã muhury katu ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","A'engi: “Ihẽ rok pe ja'u jaho” aja pandu ame'ẽ pe Jesu pandu: —Ma'e ke nde ere'u rahã, nde rehe katu ame'ẽ ta ke jõ emujy'ar ym. Aja nde mu ta ke jõ emujy'ar ym tĩ. Ne anam ta ke jõ emujy'ar ym tĩ. Amõ amõ nde rok rake rupi ihĩ, ame'ẽ ta ima'ehũ namõ ixo. Ame'ẽ ta ke jõ emujy'ar ym tĩ. Esarahã! Nde eremujy'ar rahã, pe, i'i atu rahã, nde pe pandu ta uwyr: “Ihẽ rok pe ma'e ke e'u ejur” aja nde pe. ");
INSERT INTO urbNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","A'erehe ngã mi'u nde erematyr rahã, ima'e ym te ame'ẽ ta ke emujy'ar. Wata katu ym ame'ẽ ta ke emujy'ar tĩ. Eha ym te ame'ẽ ta ke emujy'ar tĩ. Ijywa katu ym ame'ẽ ta ke emujy'ar tĩ. (Ame'ẽ ta marã ka ym so'o jukwaha.) Ame'ẽ ta ke emujy'ar. ");
INSERT INTO urbNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aja rahã, nde rehe Tupã usak katu ta. Esarahã! Ame'ẽ ta nde pe marã ka ym ma'e ke juja katu te mujywyriha. Esarahã! Nde pe Tupã riki mujywyr ta. Yman rahã, katu ame'ẽ ke ma'ema'e ame'ẽ ta ke Tupã mukwera katu muhem rahã, ma'e ke a'e riki mujywyr katu ta nde pe — aja Jesu pandu parisema'e kapitã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Amõ sawa'e myrape rake wapyk uĩ. Jesu pandu ame'ẽ ke rehe hendu rahã, pandu ipe: —Tupã ixo ame'ẽ pe oho. Pe, myrape rake wapyk ame'ẽ ta mã hury katu ta kỹ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pe, sawa'e pe pandu: —Amõ sawa'e ngã mi'u ke matyr hũ. Heta ngã pe pandu: ");
INSERT INTO urbNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","“Pehẽ johu pe'u pejur” aja ngã pe. Angaha ke rehe uhyk rahã, miasu pe pandu: “Eho. Ihẽ mi'u u'u ame'ẽ ta pe epandu eho. ‘Pe'u pejur. Upa ihẽ amoĩ katu’ aja epandu eho” aja ngã mi'u matyriha jar pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","—Pe, miasu pandu oho rahã, amõ amõ pandu: “Aho ym ta ihẽ” aja. Kuja amõ pandu py: “Ywy ke ihẽ amõ ajo'ok. A'erehe asak ta aho ehe apo 'y. ‘Aho ym ta ihẽ’ aja nde jar pe epandu” aja miasu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Amõ pandu: “Tapi'iruhu mokõi mu'am ame'ẽ ke ajo'ok. Aja me'ẽ awa po wajar peteĩhar upa ajo'ok. Ma'e ke hykýi katu raho nahã my? Ame'ẽ ke amanga ta aho. ‘Aho ym ta ihẽ’ aja nde jar pe epandu” aja miasu pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Pe, amõ pandu: “Ajumendar ramõ te ihẽ. A'erehe marã ka ym ihẽ ahoha” aja miasu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","—Pe, upa amõ ta pandu ame'ẽ ke ijar pe miasu pandu oho. Ijar parahy hũ ngã rehe. Miasu pe pandu: “Pahar eho! Ok ta rupi eho. Upa awa rape rupi eho. Ima'e ym te ame'ẽ ta ke se emuhyk erur. Itymã hãtã ame'ẽ ta ke aja tĩ. Se emuhyk erur tĩ. Eha ym te ame'ẽ ta ke aja tĩ. Se emuhyk erur tĩ. Wata katu ym ame'ẽ ta ke aja tĩ. Se emuhyk erur tĩ” aja miasu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","—I'i atu ijar pe miasu pandu: “Sa'e! Upa nde erepandu ame'ẽ ke ihẽ ama'e. Pewe soroka ihĩ, ma'e u'uha renda pe” aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","—A'erehe miasu pe ijar pandu tĩ: “Eho we rĩ. Ok ta kurar kupe koty rupi heta awa rape ihĩ. Ame'ẽ ngi upa ngã epyhyk erur. Ihẽ rok ke emutyryhem. ");
INSERT INTO urbNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Apandu katu. ‘Ma'e ke pe'u pejur’ aja ihẽ apandu py, ame'ẽ ta u'u ym te ta. Ihẽ mi'u amatyr ame'ẽ ke u'u ym te ta” aja ijar pandu — aja Jesu mu'e. (Aja rahã: “Tupã koty pehẽ py'a pemuruwak pemondo” aja jundéu awa ta pe pandu py. Ame'ẽ ta upa katu te jurujar ym ta. Jundéu awa aja ym ame'ẽ ta jurujar katu ta, aja Jesu mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Heta te hũ ngã oho ixo inamõ. Pe, Jesu uwak rahã, pandu ngã pe: ");
INSERT INTO urbNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Ihẽ namõ amõ ixo rahã, ihẽ rehe a'e ipy'a ym rahã, marã ka ym ihẽ kotyhar aja ixoha. Ipái rehe amõ ipy'a katu. Ame'ẽ 'ar koty te we ihẽ rehe ipy'a katu. Aja rahã jõ, ihẽ kotyhar aja ixo ta. Imãi rehe aja tĩ. Ipy'a katu tĩ. Hakehar rehe aja tĩ. Ipy'a katu tĩ. Ta'yr ta rehe aja tĩ. Ipy'a katu tĩ. Imu ta rehe aja tĩ. Ipy'a katu tĩ. Ianam ta rehe aja tĩ. Ipy'a katu tĩ. Juehe te'e aja tĩ. Ipy'a katu tĩ. Pe, ame'ẽ ta 'ar koty te we ihẽ rehe ipy'a katu. Aja rahã jõ, ihẽ kotyhar aja ixo ta. ");
INSERT INTO urbNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","—Ihẽ namõ amõ ixo rahã, ame'ẽ ke amõ ta jukwa tar katu my. Pe, a'e pandu: “Anĩ. Ihẽ ajurujar katuha ke ahijar ym ta. Ihẽ ke jukwa ta my? Ahijar ym ta” aja. Aja rahã, ihẽ kotyhar aja ixo ta. ");
INSERT INTO urbNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","—Pehẽ ngi har amõ riki ok keruhũ mujã rahã, myja myra hetaha rahã, uhyk ta my? Upa ta my? Aja ukwa ukwa py ixo. Upa katu te pehĩ nahã my, ame'ẽ ukwa ta. Ukwa ukwa py ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ukwa ym rahã, mumba ym ta. Ixangwer jõ upa jytyka. Uhyk ym myra ke. Marã ka ym mumbaha. Ame'ẽ rehe usak ame'ẽ ta upa puka puka hũ ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Mã! Ok keruhũ sawa'e mujã ta tipe ixo. Mumba ym ta riki” aja ngã puka puka hũ ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","—Pesarahã! Amõ kapitã keruhũ jumai tate oho. Heta te hũ sonda ta namõ oho ta. I'ar koty te we huwajan ta rahã, ima'e pyrãtãha ke a'e ukwa py ta. Huwajan ta ke a'e muputu'u ta my, ame'ẽ ke ukwa py ta. Ukwa ukwa py ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Marã ka ym muputu'uha rahã, je'ẽha ke mondo ta, amõ kapitã keruhũ koty, huwajan koty. Paite we huwajan ixo rahã, je'ẽha ke mondo ta. “Myja rahã, nde ereputu'u ta my? Jamukatu jande juehe” aja je'ẽha ke amõ pandu ta oho ipe. Pe, muputu'u. ");
INSERT INTO urbNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","—Aja pehẽ pe tĩ. Pekwa pekwa katu py pexo. “Ixotyhar aja ihẽ axo ta. Ihẽ ke amõ jukwa tar katu rahã, tapijar te'e we ixotyhar aja ihẽ axo ta” aja pekwa pekwa pexo. Pehẽ ngi har amõ upa katu te ima'e ke hijar ym rahã, marã ka ym ihẽ kotyhar aja ixoha — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","A'e pandu tĩ: —Jukyr ma'e ke muhembyk katu. Pe, jukyr ngi he'ẽha kanim rahã, marã ka ym he'ẽha amõ mujywyr ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Jaxer riki. Ywy rehe moĩ rahã, muhury ym ma'eywa'y ra'yr ke. Amõ ma'e muhuryha namõ mupara ym tĩ. Ombor te'e awa. Pehẽ pekwa tar katu rahã, ihẽ amu'e ame'ẽ ke rehe pehendu katu! — aja Jesu pandu. (Aja riki amõ. “Jesu kotyhar aja ihẽ axo ta” aja amõ pandu rahã, jukyr katu aja saka. Pe, Jesu rehe jurujar katuha ke hijar rahã, jukyr he'ẽha upa kanim ame'ẽja saka. Katu ym. A'e ke Tupã ombor te'e, ame'ẽja saka ta tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Amõ rahã, heta ngã jy'ar uwyr ehe, Jesu rehe. Homa awa tama'e kapitã keruhũ pe tamatarer matyr ame'ẽ ta jy'ar uwyr ehe. Amõ sawa'e katu ym ame'ẽ ta jy'ar uwyr ehe tĩ. Panduha rehe hendu uwyr. ");
INSERT INTO urbNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pe, parise ta je'ẽ je'ẽ hũ ehe har, Jesu rehe har. Moise je'ẽha mu'e ame'ẽ ta aja tĩ. Je'ẽ je'ẽ hũ ehe har tĩ. Kuja: —Mã! Amõ jaxer ame'ẽ ta namõ ixo katu. Ma'e ke a'eta namõ u'u tĩ. Katu ym aja jande pe — aja a'eta je'ẽ je'ẽ hũ. ");
INSERT INTO urbNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","A'erehe myja me'ẽ ma'e kanim ame'ẽ ke my, ame'ẽ ke Jesu pandu ngã pe: ");
INSERT INTO urbNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Pehẽ ngi har amõ heta arapuharan ta namõ ixo. Kuja, 100 hetaha ke. Pe, peteĩ kanim oho rahã, ijar kekar kekar ta oho. Kãpĩ u'u, aja kanim ym ame'ẽ ta ke ijar hijar ta. Pe, kanim ame'ẽ ke kekar kekar oho. Pe! Mahem. ");
INSERT INTO urbNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mahem rahã, hury katu ehe. Ijixi'y 'ar pe hupir werur. ");
INSERT INTO urbNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Hok pe muhyk rahã, ehe katu ame'ẽ ta ke mujy'ar. Hok rake rupi ixo ame'ẽ ta ke mujy'ar tĩ. Pandu: “Arapuharan kanim ame'ẽ ke amahem, a'erehe ihẽ namõ pehẽ rury katu pexo!” aja arapuharan jar. ");
INSERT INTO urbNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Pesarahã! Aja ywa pe Tupã je'ẽha rahoha ta hury katu tĩ. Amõ ta katu ame'ẽ ta aja ixo. Kuja, 99 hetaha. Ame'ẽ ta ipy'a ke muruwak ym ta me'ẽ te'e. Katu ame'ẽ ta aja ixo. Ame'ẽ ta rehe Tupã je'ẽha rahoha ta hury katu. Pe, peteĩ sawa'e katu ym ame'ẽ riki ipy'a ke Tupã koty muruwak mondo rahã, i'ar koty te we Tupã je'ẽha rahoha ta hury katu ehe. Kuja, 99 hetaha 'ar koty te we hury katu te ta ha — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","A'e pandu rĩ: —Kuja amõ we tĩ. Amõ kũjã ita tamatarer pu'a namõ ixo. Itatuwyr ke te'e mujã ame'ẽ ke. Jande popa hetaha namõ ixo. Pe, peteĩ kanim rahã, kuja kekar. Araparin ke muwera. Ame'ẽ weraha rupi peir peir ixo. Ame'ẽ matyriha pe kekar kekar katu. Aja upa hok wyr rupi usak usak ixo ehe. Pe, mahem. ");
INSERT INTO urbNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mahem rahã, ehe katu ame'ẽ ta ke mujy'ar. Hok rake ixo ame'ẽ ta ke mujy'ar tĩ. Pandu: “Ita tamatarer pu'a kanim ame'ẽ ke amahem, a'erehe ihẽ namõ pehẽ rury katu pexo!” aja kũjã pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Pesarahã! Aja Tupã je'ẽha rahoha ta hury katu ta tĩ. Peteĩ sawa'e katu ym ame'ẽ ke ipy'a ke Tupã koty muruwak mondo rahã, Tupã je'ẽha rahoha ta hury katu ta ehe tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","A'e pandu tĩ: —Amõ sawa'e mokõi ta'yr ta namõ ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Amõ wera rahã, ipái pe peteĩ pandu. Ame'ẽ riki u'ar we ame'ẽ ke. (Ame'ẽ ta'yr ipáima'e tamatarer pyhyk tar katu apo 'y. Ipái manõha rehe harõ tar ym.) Kuja pandu: “Papa! Nde eremanõ rahã, upa katu te nema'e ke jande pe nde eremupyta ta kỹ. Wajar ihẽma'e ta. Apo ame'ẽ ke ihẽ pe emuwyrahã!” aja ipái pe. A'erehe ima'e ke ipái me'ẽ me'ẽ. Mokõi ta'yr ta pe me'ẽ hũ. ");
INSERT INTO urbNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","—Pe, ame'ẽ ta'yr wajar pyhyk. U'ar we ame'ẽ ke. Upa muhepy. Aja tamatarer pyhyk. Pe, heta katu ym ukwer rahã, ipái rekoha ke hijar oho. Pepaite ihon. Amõ ywy pe har ta koty oho. A'ep ka'u te'eha rupi tamatarer ke me'ẽ me'ẽ. Upa katu te ipy'a moĩ, ame'ẽ ke rehe tamatarer me'ẽ me'ẽ rãi. ");
INSERT INTO urbNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Aja upa katu te tamatarer kanim ipe. Pe, ame'ẽ ywy rupi nixói te ngã mi'u ke. A'erehe a'e pyrara ixo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","A'erehe ame'ẽ ywy pe har sawa'e pe pandu. “Ihẽ aparaky ta nde pe” aja. “Ere. Ihẽma'e kure ta rehe esak katu. Kure mi'u eme'ẽ me'ẽ katu” aja sawa'e pandu. Ame'ẽ ke rehe a'e usak usak ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Myahy a'e. Ynga aja me'ẽ ke kure ta u'u ixo. Ame'ẽ ke a'e u'u ta tipe tĩ. Me'ẽ ym ma'e ke ngã ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","—Peramõ ipy'a upak ipe. Jupandu jupe: “Mã! Ihẽ páima'e miasu ta ma'e ke u'u rahã, pyta we riki. Heta ma'e ke ihĩ. Ko ihẽ myahyha namõ ihẽ axo. Amanõ tate ihẽ. ");
INSERT INTO urbNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Papa rekoha pe ihẽ ajywyr ta aho tĩ. Kuja ihẽ apandu ta: ‘Papa! Ma'e aka'u te'eha ke ihẽ ama'e, aja Tupã ukwa katu. Nde aja tĩ. Nde erekwa katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","“Ihẽ ra'yr” aja ihẽ pe nde erepandu ym rahã, mã katu apo 'y. Miasu aja nde pe aparaky te'e ta apo tĩ’ aja papa pe ihẽ apandu ta” aja jupandu jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","A'erehe a'engi oho. Ipái rekoha pe jywyr oho ixo. —Ipái rok paite we riki. Uhyk oho ixo rahã, ipái usak ehe. Pyrara usak ehe. Pe, ujan ixoty. Ta'yr jurupy rupi juman juman. Huwa ke pyter pyter tĩ. (Aja hury katuha mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","—Ta'yr pandu ipe: “Papa! Ma'e aka'u te'eha ke ama'ema'e, aja Tupã ukwa katu. Nde aja tĩ. Nde erekwa katu tĩ. ‘Ihẽ ra'yr’ aja ihẽ pe nde erepandu ym rahã, katu tiki” aja ipái pe. ");
INSERT INTO urbNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","—Anĩ. Miasu ta pe ipái pandu: “Pahar perur! Ma'e mundeha katu te ame'ẽ ke perur. Pemunde ehe. Ipo rehe har aja tĩ. Ipy rehe har aja tĩ. Perur tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Upa rahã, perur amõ tĩ. Tapi'iruhu ta'yrer ke perur. Ixa te ame'ẽ ke perur. Pejukwa. Jande rury katuha jamujã ta. ");
INSERT INTO urbNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ko ihẽ ra'yr manõ aja akwa naĩ. Anĩ. Apo ixuwe katu uhyk uwyr. Kanim oho aja ixo. Ko apo ixo 'y” aja ipái pandu. Pe, hury katuha ngã mujã ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","—Aja ixo rahã, ta'yr jepy ame'ẽ ke kupixa pe paraky ixo. A'engi jywyr uwyr. Hok pe uhyk tate rahã, ma'e tyapuha rehe hendu. ");
INSERT INTO urbNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pe, amõ miasu pe pukái: “Ejur se! Ma'e puki?” aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","A'e pandu: “Ne mu ko uhyk uwyr. Manõ ym a'e. Katu uhyk uwyr. A'erehe jande pe nde pái pandu: ‘Tapi'iruhu ta'yrer ke pejukwa. Ixa te ame'ẽ ke’ aja jande pe” aja miasu pandu ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","—Ta'yr jepy ame'ẽ ke parahy te'e. Hok pe ixe tar ym. A'erehe ipái uhem oho ixoty. Pandu ipe: “Exe ejur nde tĩ” aja pandu hũ ta'yr pe. ");
INSERT INTO urbNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ta'yr pandu: “Anĩ. Axe ym ta. Esarahã! Aparaky hũ axo nde pe. Heta warahy 'ar aha oho. Te'e paraky ame'ẽja ihẽ. Ne je'ẽha rehe ihẽ ahendu katu te. Aja te'eha ihẽ axo. Nde ereme'ẽ ym te ma'e ke ihẽ pe. Arapuhame ra'yr nde ereme'ẽ ym riki. Ame'ẽ namõ ihẽ rehe katu ame'ẽ ta namõ jõ amuhury ta tipe. Ja'u ta tipe. Anĩ. Nde ereme'ẽ ym ihẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Apo peme'ẽ nde ra'yr upa katu te nema'e ke mukanim. Kũjã ka'u te'e ame'ẽ ta pe upa mukanim. Ko riki jywyr uwyr. Pe, nde je'ẽha rupi tapi'iruhu ta'yrer ke nema'e miasu ta jukwa. Ixa te ame'ẽ ke. Katu ym aja” aja ipái pe ta'yr jepy ame'ẽ pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Pe, ipái pandu: “Sa'e! Ihẽ ra'yr nde. Ihẽ namõ nde erexo. Aja te'eha nde. Upa ihẽma'e kohĩ. Ame'ẽ riki upa katu te nema'e tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ko nde mu riki manõ, aja ixo. Apo ixuwe katu aja uhyk uwyr. Kanim oho aja ixo. Ko apo ixo 'y. A'erehe jande rury katuha jamujã ta me'ẽ te'e. Jande rury katu ta me'ẽ te'e. Jande rok pe jaxe jahorahã!” aja ta'yr pe ipái pandu — aja Jesu pandu. (Aja Tupã tĩ. Peteĩ sawa'e katu ym ame'ẽ ke ipy'a ke ixoty muruwak mondo rahã, Tupã hury katu ta, aja Jesu mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jumu'eha ta pe Jesu pandu: —Pe, amõ sawa'e ixo. Ima'ehũ ame'ẽ ke a'e. Ima'e tamatarer ke amõ usak usak ixo. Pe, ijar pe amõ ta pandu oho: “Tamatarer usakiha riki nema'e ke te'e mukanim ixo” aja ijar pe. ");
INSERT INTO urbNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pe, amõ pe ijar pandu: “Tamatarer usakiha emuhyk se” aja ipe. Usakiha uhyk rahã, ijar pandu ipe: “Nde erema'ema'eha rehe har ihẽ ahendu. Jetehar te my? Myja ihẽma'e tamatarer nde ereme'ẽ me'ẽ my? Myja nde eremujywyr tĩ? Ame'ẽ ke upa katu te emapyk. Ihẽ asak ta. Ihẽma'e ke nde eresak ym ta apo 'y” aja ijar pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","—Pe, hok pe jywyr rahã, usakiha jupandu jupe: “Ihẽma'e parakyha ngi ihẽ jar ihẽ ke muhem ta apo. Myja aparaky ta apo my? Ihẽ pyrãtã ym ihẽ. (Marã ka ym kupixa rehe aparakyha.) Tamatarer ke ngã pe apandu pandu rahã, ihẽ ruxĩ ta ihẽ ke ingi. Aja ama'e ym ta. ");
INSERT INTO urbNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aa! Apo akwa katu! Ihẽ rehe katu ame'ẽ ta ke amu'am ta. Pe, ihẽma'e parakyha ngi ihẽ ke muhem rahã, ihẽ rehe katu ame'ẽ ta ixo ta. Hok pe ame'ẽ ta ihẽ ke mupyta katu ta” aja jupandu jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","—A'erehe ijar pe ma'e ke mujywyr ame'ẽ ta ke muhyk. Upa muhyk. Amõ pe pandu py: “Myja hetaha ihẽ jar pe nde eremujywyr ta my?” aja tamatarer usakiha pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Sawa'e pandu: “Mandeju ra'ĩ ka aja me'ẽ heta te hũ amujywyr ta me'ẽ te'e. Kamuxĩ ra'yr ke tyryhem heta te hũ, kuja, 100 hetaha ke” aja usakiha pe. A'e pandu: “Esarahã! Ko nema'e mangaha ke. Se ewapyk. Pahar iwyr koty paper rehe emupinim. Wajar jõ nema'e mangaha kohĩ. Kuja, 50 aja hetaha jõ emupinim. Ihẽma'e parakyha nixói rahã, ihẽ rehe eharái ym” aja usakiha pandu. (A'e jupandu jupe tĩ: “Apo ihẽma'e parakyha ngi ihẽ jar muhem rahã, peme'ẽ ihẽ rehe usak katu ta my” aja jupandu jupe.) ");
INSERT INTO urbNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","—Amõ pe pandu: “Ne rahã tĩ! Myja nde eremujywyr ta ihẽ jar pe my?” aja usakiha pandu. Amõ pandu: “Ahúi aja me'ẽ heta te hũ amujywyr ta me'ẽ te'e. Kuja, 1.000 wasãkã mangaha mutyryhem” aja usakiha pe. A'e pandu: “Ko nema'e mangaha kohĩ. Iwyr koty paper rehe emupinim. Kuja, 800 aja emupinim. Te'e apandu ta, aja rahã ihẽ jar ukwa ym ta. Esarahã! Ihẽma'e parakyha nixói rahã, ihẽ rehe eharái ym” aja ipe. (A'e jupandu jupe tĩ: “Apo ihẽma'e parakyha ngi ihẽ jar muhem rahã, peme'ẽ ihẽ rehe usak katu ta my” aja jupandu jupe.) ");
INSERT INTO urbNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","—Ame'ẽ usakiha ma'ema'eha rehe har ijar hendu rahã, pandu: “Mã! Usakiha ukwa katu ma'e. Ehe katu ame'ẽ ta ke mu'am ixo” aja riki ijar pandu. (Jetehar te rupi ym usakiha ma'e. Katu ym ame'ẽ.) Ukwa katuha rehe har jõ ijar katu pandu — aja Jesu pandu. A'e pandu tĩ: —Ima'e ke rehe ukwa katuha namõ Tupã kotyhar ta usak usak katu. Aja rahã, yman rahã ima'e ke pewe hũ ta. Mã! Tupã kotyhar ta 'ar koty te we Tupã rehe ipy'a ym ame'ẽ ta ukwa katuha. Tupã rehe ipy'a ym ame'ẽ ta ma'e ke ukwa ukwa ixo, ame'ẽ ta pe ukwa katuha namõ amõ Tupã rehe ipy'a ym ame'ẽ ta ma'ema'e. Aja rahã, yman rahã ima'e ke pewe hũ ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","A'e pandu tĩ: —Pesarahã! Kome'ẽ ywy keruhũ pe ma'e ke heta ihĩ. Tamatarer. Ma'e katu ame'ẽ ke. Heta ihĩ tĩ. “Aa! Ame'ẽ ke Tupã kotyhar ta pe ihẽ ame'ẽ ta. Aja rahã, kome'ẽ ywy keruhũ pe Tupãma'e parakyha riki katu ta oho” aja pepandu. Aja rahã, pemanõ rahã, ixoty oho rahã, pehẽ pe Tupã pandu ta: “Se pejur katu. Katuha renda ke se. Manõ ym te ta awa se. Katu tiki” aja pehẽ pe Tupã pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","—Jetehar rupi ta'yr mi ma'e ke rehe amõ usak usak katu. Aja rahã, jetehar rupi heta te hũ ma'e ke rehe usak usak katu ta tĩ. Te'eha rupi ta'yr mi ma'e ke rehe usak usak. Aja rahã, te'eha rupi heta te hũ ma'e rehe usak usak ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kome'ẽ ywy keruhũ pe ma'e ke heta hũ ihĩ. Ame'ẽ ke jetehar rupi ym pesak pesak rahã, ma'e katu ame'ẽ ke Tupã me'ẽ, ame'ẽ ke pehẽ pe a'e me'ẽ ym ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Amõ tama'e ke rehe pesak pesak katu ym rahã, pehẽma'e ke pehẽ pe amõ me'ẽ ym ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","—Mokõi ijar pe marã ka ym miasu paraky katuha. Mokõi jar pe paraky rahã, peteĩhar rehe jõ ipy'a katu ta. Amõ rehe anĩ ta. Peteĩ jar je'ẽha rehe hendu katu ta. Amõ jar je'ẽha rehe anĩ ta. Hendu ym ta ehe. (Aja Tupã rehe tĩ.) Tamatarer ke rehe jõ ipy'a ke amõ moĩ moĩ rahã, marã ka ym Tupã rehe ipy'a katuha. (Mokõi ijar aja saka tĩ) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ame'ẽ panduha ke parise ta hendu rahã, puka puka hũ ehe, Jesu rehe. Tamatarer ke rehe ame'ẽ ta ipy'a ke moĩ moĩ katu, a'erehe Jesu rehe puka puka hũ. ");
INSERT INTO urbNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesu pandu: —Sawa'e katu te pehẽ aja amõ ta ukwaha. Ame'ẽ ke peputar katu. Anĩ. Aja ym pehẽ, aja pehẽ rehe har Tupã ukwa katu. Ma'e ke katu te aja sawa'e ukwaha. Anĩ. Ame'ẽ riki jaxer ame'ẽ ke te'e aja Tupã ukwa katu. Tupã riki ukwa katu te ame'ẽ ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","—Aja Moise je'ẽha rehe har amõ koty pekwa. Pesarahã! Juã mujahukiha uhyk ym rahã we, Moise je'ẽha rehe amõ hendu katu rĩ. Tupã je'ẽha ke pandu ame'ẽ ta rehe aja tĩ. Hendu katu tĩ. Pe, Juã uhyk. A'engi myrandu katu ke ihẽ apandu pandu axo. Ma'e ka'u te'eha ke amõ hijar, pe, Tupã koty ipy'a ke muruwak. Aja rahã: “Ihẽ kotyhar ke nde” aja Tupã pandu. Ame'ẽ myrandu katu rehe heta te hũ jurujar katu. ");
INSERT INTO urbNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Moise je'ẽha rehe amõ hendu katu ta me'ẽ te'e tĩ. Ywa ke kanim ta oho. Kome'ẽ ywy keruhũ aja tĩ. Upa ta tĩ. Moise je'ẽha rehe hendu katuha anĩ. Upa ym te ta. A'erehe Moise je'ẽha rehe hendu katu ta me'ẽ te'e we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","—Pesarahã! Kuja riki amõ. Hakehar ke sawa'e hijar oho. Pe, amõ kũjã ke pyhyk rahã, ma'e ka'u te'eha ke a'e ma'e. Pe, hijar ame'ẽ kũjã ke amõ sawa'e pyhyk rahã, ma'e ka'u te'eha ke ame'ẽ kũjã ma'e tĩ. Katu ym aja. A'erehe aja pema'e ym ta me'ẽ te'e — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","(Tamatarer rehe jõ amõ ipy'a moĩ rahã, katu ym aja Jesu mu'e.) A'erehe kuja pandu: —Pe, amõ sawa'e ixo. Ima'ehũ namõ ixo ame'ẽ ke a'e. Ima'e mundeha muhepy hũ ame'ẽ ke namõ wata ixo. Wera rahã pame katu te humi'u ke matyr hũ. Aja jumuhury hury juehe. ");
INSERT INTO urbNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Hok rukwen pe amõ sawa'e ke amõ ta muhyk muhyk raho. Her Rasaro. Ima'e ym te a'e. Pere ke mãte hũ te'e ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A'ep harõ uĩ. Ima'ehũ, ame'ẽma'e myrape 'ar ngi imi'u kurer u'ar u'ar. Ame'ẽ ke Rasaro u'u ta tipe. Me'ẽ ym amõ ipe. Jawar ta riki pere ke here here tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pe, ima'e ym te ame'ẽ ke manõ, Rasaro ke. Amarã rake i'ã ke Tupã je'ẽha rahoha ta muhyk raho. Ywa pe huryha rehe muhyk raho. —Ima'ehũ ame'ẽ ke manõ tĩ. Pe, amõ ta jytym raho. ");
INSERT INTO urbNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mupyraraha renda pe pyrara hũ ixo. Ma'ã rahã, Amarã rehe usak. Hake Rasaro i'ãi. Pijaite we usak ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Pe, pukái: “Amarã! Epyrara ihẽ rehe esarahã! Ihẽ koty Rasaro ke emuwyr. Y pe ipo ãkã rakehar munde ta. Ame'ẽ pe ihẽ juru ke murysã ta. Tata keruhũ pe ihẽ axo. Apyrara hũ ihẽ ke” aja Amarã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","—Pe, Amarã pandu ipe: “Sa'e! Anĩ. Ywy pe nde erexo rahã, upa katu te ma'e katu ame'ẽ ke nema'e riki. Ame'ẽ ke rehe ekwa ekwa exo. Rasaro rehe anĩ. Upa katu te ma'e katu ym ame'ẽ ke ima'e riki. Apo anĩ. Se a'e hury katu ixo apo 'y. Nde anĩ. Nde erepyrara erexo apo 'y. ");
INSERT INTO urbNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ko riki amõ we tĩ. Jande pyter rupi sorok te'e hũ ame'ẽ ke túi. A'erehe sengi marã ka ym nde koty amõ ahaha oho. Nde koty har ngi marã ka ym jande koty amõ ahaha uwyr tĩ” aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","—Sawa'e pandu: “Amarã! Aja rahã, ko apandu nde pe. Ihẽ pái rekoha pe Rasaro ke emondo. ");
INSERT INTO urbNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","A'ep ihẽ mu ta ixo. Awa po wajar peteĩhar upa hetaha ixo. Ame'ẽ ta pe je'ẽha namõ Rasaro ke emondo. Aja rahã, ame'ẽ ta se uwyr ym ta tĩ. Se pyrara hũ awa” aja pyrara ixo ame'ẽ ke pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","—Amarã pandu: “Anĩ ta. Moise mupinim ame'ẽ ke namõ ne mu ta ixo. Tupã je'ẽha pandu ame'ẽ ta mupinim. Ame'ẽ ta namõ ixo tĩ. Ame'ẽ panduha rehe ne mu ta hendu katu ta me'ẽ te'e. Hendu katu rahã, ukwa katu ta. Aja rahã peme'ẽ pyraraha renda pe oho ym ta tĩ” aja pyrara ixo ame'ẽ pe Amarã pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","—Sawa'e pandu: “Anĩ ta Amarã! Ame'ẽ ke a'ewan ym we rĩ. Amõ we rahã, katu. Kuja. Manõha ngi amõ kwera katu uhem, pe, ame'ẽ riki Tupã je'ẽha ke pandu oho rahã, ma'e ka'u te'eha ma'ema'eha ngi ipy'a ke muruwak ta mondo. Tupã koty muruwak ta mondo” aja pyrara ixo ame'ẽ pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","—Amarã pandu: “Anĩ. Moise je'ẽha rehe a'eta hendu ym rahã, amõ rehe hendu ym tĩ. Manõha ngi kwera katu uhem ame'ẽ ke Tupã je'ẽha pandu. Ame'ẽ ke rehe hendu ym ta tĩ. Tupã je'ẽha ke pandu ame'ẽ ta rehe hendu ym rahã, aja tĩ. Manõha ngi kwera katu uhem ame'ẽ ke pandu oho. Tupã je'ẽha ke pandu oho. Ame'ẽ ke rehe hendu ym ta tĩ” aja pyrara ixo ame'ẽ pe Amarã pandu — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jumu'eha ta pe Jesu pandu: —Ma'e ke rehe amõ usak, a'erehe ma'e ka'u te'eha ke ma'e ta. Aja me'ẽ aja te'e ta ixo. Pe, ngã muka'u te'eha ke mu'e, ame'ẽ ke mã Tupã mupyrara te hũ ta. ");
INSERT INTO urbNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ihẽ rehe amõ amõ ta'yn ta jurujar katu. Pe, amõ pandu: “Mã! Jesu rehe pejurujar katuha pehijar” aja. A'erehe ta'yn ta hijar. Aja rahã, mã peja pandu ame'ẽ jurupy rupi itahu pukwar. Pe, itahu namõ a'e ke ypa pe ombor. Pe, y jukwa. (Aja rahã, ta'yn ta ke mu'e ym ta.) Aja manõ rahã, Tupã mupyraraha 'ar koty te we katuha. Tupã mupyrara rahã, mupyrara te hũ ta. ");
INSERT INTO urbNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","—Pesak katu te'e! Ma'e ka'u te'eha ke ne mu ma'e rahã: “Mã peja ym” aja epandu ipe. Ame'ẽ ngi ipy'a ke muruwak mondo rahã, nde py'a emujywyr ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Wera rahã, awa po wajar mokõi hetaha ma'e ka'u te'eha ke a'e ma'ema'e nde pe. Pe, a'e ma'e, a'engi nde pe pandu: “Ame'ẽ ngi ihẽ py'a amuruwak amondo. Ihẽ rehe nde py'a emujywyr katu” aja nde pe pandu. Aja rahã, aja pame katu te nde py'a ke emujywyr ehe — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesu mondo ame'ẽ ta pandu ipe: —Sawa'e! Mã! Jande py'a jamujywyriha hãtã ame'ẽ ma'eha. Jande ke emu'e katu. Aja rahã, jajurujar katuha amõ we katu ta. Pe, nde erepandu aja jama'ema'e katu ta — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","A'e pandu: —Pesarahã! Ta'yr mi pejurujar katu rahã, marã ka ym amõ ma'eha, ame'ẽ ke pema'ema'e katu ta kỹ tĩ. Ta'yr mi pejurujar katu. Ma'e ra'ĩ ta'yr te mi, ame'ẽja saka. Aja rahã kome'ẽ myra keruhũ pe pepandu ta: “Nde rapo ke namõ ejujo'ok ehem eho. Y ramũi pe ejujytym eho” aja myra pe. Ta'yr mi pejurujar katu rahã, ame'ẽ myra jujo'ok ta oho — aja Jesu. (“Myra” aja pandu rahã: “Upa ma'e hãtã ma'eha ke” aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ajame'ẽ ke Jesu mu'e: —Pehẽ ngi har amõ ixo. Miasu aja paraky ixo, kupixa rehe. Arapuharan ta rehe usak usak ixo amõ nahã my. Pe, hok pe uhyk jywyr rahã, ame'ẽ pe kuja nde erepandu my: “Ere. Nde ereparaky katu. Pahar ma'e ke e'u eho” aja pandu my? ");
INSERT INTO urbNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Anĩ. Aja ym. Amõ koty nde erepandu ta. Kuja: “Ma'e ke ihẽ pe emupupur. Nema'e kamixa emunde. Pe, ihẽ a'u rahã, ma'e ke emoĩ moĩ ihẽ pe. Upa a'u rahã, nde ere'u ta” aja miasu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Miasu pe: “Katu nde. Nde ereparaky katu” aja nde erepandu ym ta. Anĩ. Ne je'ẽha rehe jõ hendu katu. Aja miasu katu ame'ẽ ke a'e, aja mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pehẽ aja tĩ. “Pehẽ katu. Pema'ema'e katu” aja jandema'e sawa'e te pandu ym rahã, nde rury katu pexo rĩ. A'e pandu ame'ẽ ke pema'ema'e rahã, kuja pepandu ta: “Miasu ta jõ jande. Jande pe sawa'e te pandu ame'ẽ ke jõ jama'ema'e” aja pehẽ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusarẽ ok ta pe Jesu oho ixo rahã, amõ ywy rupi asa oho ixo. Ngariréi ywy ngi uhem oho rahã, Samari ywy pe uhyk oho. Ame'ẽ rupi asa oho ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pe, amõ ok ta pe uhyk tate rahã, pereran ma'e u'u hũ ame'ẽ ta uhyk uwyr ixoty. Jande popa sawa'e ta hetaha. Paite we pu'am u'am. (Amõ jundéu awa ta namõ ixo ym ta me'ẽ te'e ame'ẽ ta.) ");
INSERT INTO urbNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","A'eta pukái: —Jesu! Sawa'e! Jande rehe epyrara esak! Jande ke emukatu — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","A'eta rehe usak rahã, pandu: —Ere! Peho! Jundéu awa tama'e pa'ihu koty peho. Pemujesak pehẽ juehe har ipe. Pehẽ katu aja a'e mujekwa ta ngã pe — aja Jesu. Pe, ame'ẽ ta johu oho ixo rahã, upa katu te katu 'y. ");
INSERT INTO urbNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ame'ẽ ta ngi har peteĩ jõ jywyr. (Samari ywy pe har ke a'e.) Katu, aja ukwa rahã, Jesu koty jywyr uwyr. Tupã rehe har katu pandu pandu hũ uwyr. ");
INSERT INTO urbNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesu ruwa koty ipynarãi pe wapyk uwyr. (Aja ipy'a moĩ moĩ katu ehe.) “Ne jõ riki katu te me'ẽ ke. Ihẽ ke nde eremukatu” aja pandu ipe, Jesu pe. Samari ywy pe har ke a'e. Jundéu awa ym ame'ẽ ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesu pandu: —Mã! Jande popa sawa'e hetaha amukatu. Awa po wajar tumeme sawa'e ta jywyr ym uwyr, ihẽ koty. ");
INSERT INTO urbNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mã! Amõ awa ke jõ jywyr uwyr. Tupã pe: “Ne jõ riki katu te me'ẽ ke” aja pandu uwyr. Mã! Aja jundéu awa ta pandu ym uwyr. Ko samari ywy pe har jõ jywyr uwyr — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pe, a'e pandu ipe: —Epu'am katu! Eho! Ihẽ rehe nde erejurujar katu, a'erehe nde ke amukatu. A'erehe nde katu apo 'y — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Amõ parise ta Jesu pe pandu: —Myja rahã kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e muwyr ta my? Pe, jundéu awa ta ke huwajan ta ngi poir ta my? Pe, jandema'e ywy pe kapitã keruhũ aja ixo ta my? — aja parise ta pandu. Jesu pandu: —Kapitã keruhũ aja Tupã mu'am ame'ẽ ke uwyr rahã, ehe har upa katu te ngã pandu pandu ym ta. ");
INSERT INTO urbNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kuja ym ta. Amõ pandu: “Pesarahã! Ko riki ixo.” Amõ: “Paite riki ixo!” Aja ym riki. Pesarahã! Pehẽ namõ a'e ixo apo 'y. Pekwa ym riki — aja parise ta pe. (“A'e ixo apo 'y” aja pandu rahã: “Juehe har” Jesu pandu.) ");
INSERT INTO urbNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jumu'eha ta pe jõ Jesu pandu. Kuja: —Ngã pyrara hũ, ame'ẽ angaha rehe uhyk ta. Arahã kuja peputar ta. Kirisutu uwyr. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e. Ihẽ riki Kirisutu. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Pe, ngã mupyraraha ngi pehẽ ke ihẽ ajo'ok ta. Ame'ẽ ke peputar katu tipe. ");
INSERT INTO urbNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pe, amõ ta pandu ta pehẽ pe. “Paite pesak peho! Kirisutu pehĩ!” Amõ: “Se pesak pejur. Kirisutu kohĩ!” Anĩ. Pekekar ym peho. Nixói. ");
INSERT INTO urbNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tupã wera rahã, paite rupi upa ta wera oho. Paite rupi upa katu te ngã usak. Aja ihẽ ajywyr rahã, paite rupi upa katu te ngã ukwa katu ta kỹ tĩ. Ko awa ihẽ tĩ. Tupã je'ẽha rupi ajur. ");
INSERT INTO urbNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pesarahã! Ajywyriha angaha rehe uhyk ym we ta rĩ. Kuja uhyk py ta. Ihẽ ke amõ ta mupyrara hũ ta. Parise ta aja amõ ta putar ym ta ihẽ ke tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","—Yman te Noe ixo rahã, amõ ta ixoha rehe te'e ukwa ukwa ixo. Ma'e ke u'u uĩ. Sawa'e ta kũjã ta ke pyhyk. Kũjã ta aja tĩ. Sawa'e ta ke pyhyk tĩ. Aja te'e ngã ixo. Ima'e ke rehe jõ usak usak ixo. Pe, jarusu keruhũ pe Noe ixe oho. Pe, y ke upa katu te ma'e ke munde oho. Upa ngã ke jukwa. Ihẽ ajywyr tate rahã, aja ta ngã ixo tĩ. Ixoha rehe te'e upa apo ixo ame'ẽ ta ukwa ukwa ixo tĩ. Ima'e ke rehe jõ ukwa ukwa ixo. Pahar ihẽ ajywyr ta. Ko awa ihẽ tĩ. Tupã je'ẽha rupi ajur. ");
INSERT INTO urbNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","30","—Yman te Ro ixo rahã, aja upa ngã ixo tĩ. Ima'e ke rehe jõ ukwa ukwa ixo. Ma'e ke u'u uĩ. Ma'e ke muhepy hepy u'am tĩ. Kupixa mujã mujã ixo tĩ. Hok ke mujã mujã ixo tĩ. Pe, Sondo ok ta ngi Ro uhem oho rahã, aman aja tata ke Tupã mungyr. Tatãpũi aja ita ra'yr ke mungyr tĩ. Upa katu te ame'ẽ ok ta pe har ta ke tata jukwa. Pahar jukwa. Ihẽ ajywyr rahã, aja ta ngã ixo tĩ. Ima'e ke rehe jõ ukwa ukwa ixo tĩ. “Uwyr ym a'e” aja ngã ukwaha naĩ. Anĩ. Pahar ihẽ ajywyr ta. Ko awa ihẽ tĩ. Tupã je'ẽha rupi ajur. ");
INSERT INTO urbNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","—Pyraraha uhyk rahã, hok kupe ipe ame'ẽ 'ar pe amõ ixo rahã, pahar ujan oho. (Aja rahã, manõ ym ta.) Hok pe ixe ym oho. Ima'e ke pyhyk ym oho. Pahar ujan oho. Kupixa pe ixo ame'ẽ ke hok pe jywyr ym oho tĩ. (Ima'e ke pyhyk ym jywyr.) Pahar ujan oho. ");
INSERT INTO urbNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ymanihar Ro rakehar rehe pekwa pekwa pexo. (Haikwer koty ma'ã. Pyta riki. Arahã pahar manõ.) ");
INSERT INTO urbNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ima'e ke amõ mupyta ta katu aja jõ ipy'a pe ukwa ukwa ixo rahã, ixoha kanim ta. Manõ ta. Ima'e ke putar ym. “Mã peja kanim” aja ipy'a pe ukwa ukwa ixo. Pe, ujan oho rahã, ixoha kanim ym ta. Manõ ym ta. ");
INSERT INTO urbNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","—Ko apandu pehẽ pe. Ihẽ ajywyr rahã, mokõi sawa'e ukwer ou, pytun rahã. Peteĩ pyta ta. Amõ anĩ. Ame'ẽ ke Tupã je'ẽha rahoha raho ta. ");
INSERT INTO urbNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ma'e ke mokõi kũjã kytyk kytyk u'am. Peteĩ pyta ta. Amõ anĩ ta. Ame'ẽ ke Tupã je'ẽha rahoha raho ta. ");
INSERT INTO urbNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kupixa pe mokõi sawa'e ta paraky ixo. Peteĩ pyta ta. Amõ anĩ ta. Ame'ẽ ke Tupã je'ẽha rahoha raho ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jumu'eha ta pandu ipe: —Sawa'e! Myp pyraraha uhyk ta my? — aja Jesu pe. A'e pandu: —Ma'e inem ame'ẽ ke túi rahã, a'ep xumukape jy'ar ta oho. Aja ma'e ka'u te'eha ke ngã ma'ema'e hũ, ame'ẽ renda pe pahar pyraraha uhyk ta — aja Jesu. (Aja rahã, Jerusarẽ ok ta pe har ta ke amõ awa ta mupyrara ta uwyr, aja Jesu mujekwa. Jerusarẽ ok ta pe har ta ma'e ka'u te'eha ke ma'ema'e, a'erehe aja.) ");
INSERT INTO urbNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pe, jumu'eha ta ke Jesu mu'e ixo. Tupã namõ a'eta tapijar te'e we pandu pandu ta me'ẽ te'e. Myja me'ẽ ame'ẽ ke my, ame'ẽ ke a'e mu'e. “Mã! Tupã hendu ym jande rehe” aja pahar pandu ym ta me'ẽ te'e. A'erehe kuja mu'e ixo: ");
INSERT INTO urbNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Amõ ok ta pe sawa'e ixo. Ame'ẽ ke amõ ta rehe har hendu, pe, pandu: “Nde katu” aja. Anĩ rahã: “Nde katu ym” aja. Tupã rehe ipy'a ym ame'ẽ ke a'e. Amõ ta rehe pyrara usak ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ame'ẽ ok ta pe ixawa'e manõ ame'ẽ ke ixo tĩ. Sawa'e koty ohoho hũ ixo. Pandu pandu hũ tipe ipe: “Ihẽ rehe ihẽ ruwajan ma'e ke ma'ema'e hũ. Nde riki epandu ipe: ‘Ema'e ym’ aja. Nde jõ riki nde eremukatu” aja kũjã pandu pandu hũ tipe ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Anĩ. Yman atu kũjã rehe sawa'e hendu ym. A'erehe kũjã jywyr jywyr ixoty. A'erehe uhyk kũjã panduha ipe. A'erehe sawa'e jupandu jupe: “Mã! Tupã rehe ihẽ apy'a ym. Sawa'e ta rehe apyrara asak ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Mã! Peme'ẽ ixawa'e manõ ame'ẽ ke ihẽ rehe uwyr uwyr hũ ixo. Amukatu ym rahã, ihẽ ke muhe'õ te'e ta. A'erehe kũjã ruwajan pe ihẽ apandu ta: ‘A'ewan. Ma'e ke ema'e ym apo 'y. Mã peja pete'e pyta katu’ aja apandu ta” aja sawa'e jupandu jupe — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","A'e pandu tĩ: —Pesarahã! Ame'ẽ sawa'e katu ym ame'ẽ ke a'e. Anĩ. Pandu ame'ẽ ke katu riki. “Ihẽ amukatu ta” aja a'e pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aja Tupã namõ pepandu tĩ. Ixotyhar ta tapijar te'e we pandu pandu: “Jande ke amõ ta mupyrara” aja. Aja rahã, ame'ẽ ke Tupã mukatu ta. (Sawa'e pe kũjã tapijar te'e we pandu, ame'ẽja saka.) “Mã! Jande rehe Tupã hendu ym” aja ym pepandu. ");
INSERT INTO urbNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Anĩ. Pahar mukatu ta. Pesarahã! Ixotyhar ta rehe usak katu. Yman rahã, kome'ẽ ywy keruhũ pe ihẽ ajywyr ta ajur tĩ. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Pesarahã! Ihẽ ajywyr rahã, Tupã kotyhar ta tapijar te'e we Tupã namõ pandu pandu ixo my. Yman ame'ẽ ta ke amõ ta mupyrara riki. Anĩ. Tapijar te'e we Tupã namõ pandu pandu rahã, katu tiki — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Juehe har katu aja ukwaha jupe naĩ, aja me'ẽ sawa'e ixo. Upa amõ ta riki katu ym aja ame'ẽ ta ukwaha naĩ tĩ. Ame'ẽ ta rehe har Jesu pandu. Myja me'ẽ ame'ẽ ta my, ame'ẽ ke pandu. Kuja: ");
INSERT INTO urbNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Amõ rahã, Tupã rehe ngã jumu'eha renda keruhũ pe mokõi sawa'e ta oho. Tupã namõ pandu pandu oho. Peteĩhar parise ke. Amõ riki homa awa tama'e kapitã keruhũ pe tamatarer matyr ame'ẽ ke a'e. (A'erehe ame'ẽ sawa'e jaxer ame'ẽ ke aja parise ta ukwa.) ");
INSERT INTO urbNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ko parise se koty jeje pandu pandu u'am, Tupã namõ. Kuja: “Tupã! Amõ ta aja ym ihẽ, a'erehe: ‘Ne jõ riki katu te me'ẽ ke’ aja ihẽ apandu nde pe. Amõma'e ke rehe ipy'a ke amõ ta moĩ moĩ hũ. Pe, pyrãtãha namõ jo'ok ingi. Ihẽ anĩ. Aja ym ihẽ. Sawa'e katu ame'ẽ ke ihẽ. Kũjã rehe amõ ta ka'u te'e hũ. Ihẽ anĩ. Aja ym ihẽ. Kotete tamatarer matyr ame'ẽ ke i'ãi. Sawa'e jaxer ame'ẽ ke aja ihẽ akwa. Peme'ẽ aja ym ihẽ, a'erehe: ‘Ne jõ riki katu te me'ẽ ke’ aja apandu nde pe. ");
INSERT INTO urbNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Peteĩ seman ngi har mokõi wera rahã, ma'e ke a'u ym te. (Aja nde rehe ihẽ py'a amoĩ moĩ katu.) Upa ihẽ apyhyk ame'ẽ ke ngi ta'yr te mi nde pe ihẽ ame'ẽ. Jande popa hetaha ngi har peteĩ ihẽ ame'ẽ nde pe. (Aja nde rehe ihẽ py'a amoĩ moĩ)” aja parise jeje pandu pandu u'am. (Jeje te'e pandu pandu u'am. Tupã hendu ym ehe.) ");
INSERT INTO urbNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","—Amõ sawa'e amõ koty panduha. Homa awa tama'e kapitã keruhũ pe tamatarer matyr ame'ẽ ke a'e. (Jaxer ame'ẽ ke a'e, aja parise ta ukwa.) Paite we mi pandu pandu u'am, Tupã namõ. Huxĩ a'e, a'erehe ywa rehe ma'ã ym u'am. (Ywa pe Tupã ixo, ame'ẽ rehe ma'ã ym u'am.) Ipixi'a ke mokõi po pe nupã nupã u'am. (Aja pyaiha mujekwa.) Pe, kuja pandu u'am: “Tupã! Ma'e aka'u te'eha ke ihẽ ama'ema'e. Ihẽ rehe epyrara esak. Ihẽ rehe nde py'a emujywyr” aja tamatarer matyr ame'ẽ ke pandu u'am. ");
INSERT INTO urbNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ko apandu pehẽ pe. Ame'ẽ rehe Tupã pyrara usak. Ame'ẽ sawa'e rehe hendu. Pe, ame'ẽ pe Tupã pandu: “Nde katu. Ma'e nde ereka'u te'eha nde erema'eha nixói te nde pe” aja. Amõ anĩ. Parise anĩ. Ame'ẽ rehe hendu ym. “Nde katu. Ma'e nde ereka'u te'eha nde erema'eha nixói te nde pe” aja Tupã pandu ym. “Ihẽ katu te” aja ukwa jupe naĩ, ame'ẽ pe Tupã pandu: “Nde katu ym” aja. “Ihẽ katu ym. Ma'e aka'u te'eha ke ama'e” aja pandu ame'ẽ ke pe Tupã pandu: “Nde katu” — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ta'yn ta ãkã rehe ipo Jesu mujar ta. Aja ipy'a katuha mujekwa. Ame'ẽ ke amõ ta putar, a'erehe ixoty a'eta raho raho. Ame'ẽ ke jumu'eha ta usak rahã, je'ẽ je'ẽ a'eta pe: —Mã! Jesu ma'ema'e ixo. A'erehe perur ym ipe — aja jumu'eha ta. ");
INSERT INTO urbNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pe, Jesu pandu: —Anĩ. Mã peja ta'yn ta ihẽ rehe uhyk katu. Ta'yn ta ke se pemuhyk perur. Pemupyta ym. Aja riki Tupã putar tĩ. Kome'ẽ ta'yn ta aja me'ẽ ta Tupã kotyhar wan ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ko pekwa pekwa pexo. Tupã kotyhar ta aja ta'yn ta putar katu. Ta'yn ta aja amõ putar ym rahã, Tupã kotyhar aja ym te ta awa — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pe, amõ jundéu awa tama'e kapitã pandu ipe: —Sawa'e! Ngã mu'eha nde. Nde riki katu te ame'ẽ ke nde. Ma'e ihẽ ama'e rahã, ihẽ ke Tupã muhã katu ta my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","A'e pandu: —“Katu te ame'ẽ ke nde” aja ihẽ pe nde erepandu. Tupã jõ riki katu te ame'ẽ ke a'e. Awa ke anĩ. (Ihẽ Tupã aja nde erekwa my?) ");
INSERT INTO urbNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Esarahã! Tupã pandu ame'ẽ ke nde erekwa katu. “Amõ kũjã rehe eka'u te'e ym. Amõ sawa'e rehe eka'u te'e ym tĩ. Amõ ke ejukwa ym. Emukanim ym amõma'e ke. Te'e ma'e ke epandu ym. Nde pái rehe epy'a katu. Ne mãi rehe aja tĩ. Epy'a katu tĩ” aja Tupã je'ẽha ke rehe panduha ihĩ — aja sawa'e pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Sawa'e pandu: —Upa ame'ẽ panduha rehe ihẽ ahendu katu. Kurumĩ rahã har ahendu katu axo — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ame'ẽ ke rehe Jesu hendu rahã, pandu ipe: —Pewe amõ ma'e ke nde pe. Upa katu te nema'e ke emuhepy. (Aja tamatarer epyhyk.) Pe, ame'ẽ tamatarer ke ima'e ym te ame'ẽ ta pe upa katu te eme'ẽ me'ẽ. Aja rahã, ywa pe nema'e ke heta te hũ ta. Pe, ihẽ namõ eho — aja sawa'e pe. ");
INSERT INTO urbNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ame'ẽ ke rehe sawa'e hendu rahã, pyai te'e u'am. Ima'ehũ namõ ixo ame'ẽ ke a'e. (Me'ẽ tar ym ma'e ke. A'erehe pyai te'e u'am.) ");
INSERT INTO urbNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ame'ẽ ke Jesu ukwa rahã, pandu: —“Ere. Tupã putar, aja ihẽ axo ta” aja ima'ehũ ame'ẽ ta marã ka ym panduha. Aja panduha riki hãtã. ");
INSERT INTO urbNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Awi jupiha kwar rupi marã ka ym amõ rymba asaha oho. Kame hymba asaha oho. Aja ima'ehũ ame'ẽ ta ke. Tupã putar aja ixo tar ym te — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ame'ẽ rehe hendu ame'ẽ ta pandu: —Mã! Aja rahã, Tupã muhã ym te ta awa ke — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesu pandu: —Ame'ẽ ke sawa'e ta marã ka ym ma'eha. Myja awa ke muhã katu ta my, ame'ẽ ke Tupã jõ ukwa katu — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pe, Petu pandu: —Esarahã! Upa katu te jandema'e ke jahijar jajur. Ko ne namõ jaho jaxo. Tupã putar aja jama'ema'e jaxo — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A'e pandu: —Hã! Ko apandu pehẽ pe. Tupã putar, aja upa katu te amõ ma'ema'e. A'erehe hok ke hijar oho. Hakehar ke aja tĩ. Hijar oho tĩ. Imu ta ke aja tĩ. Hijar oho tĩ. Ianam ta ke aja tĩ. Hijar oho tĩ. Ta'yn ta ke aja tĩ. Hijar oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Aja rahã, ma'e ke hijar oho, ame'ẽ 'ar koty te we Tupã mujywyr ta ipe. Apo ixo rahã, mujywyr ta. Pe, yman rahã, Tupã namõ ixo ta. Uhã te hũ aja ixo ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Awa py mokõi jumu'eha ta ke Jesu mujy'ar raho. Heta ame'ẽ ta ngi mujy'ar raho. A'eta pe jõ pandu: —Pehendu katurahã! Jerusarẽ ok ta pe jande jaho jaxo. A'ep ihẽ rehe har amõ ta mupinim. Tupã je'ẽha pandu ame'ẽ ta mupinim. Ame'ẽ panduha aja upa katu te uhyk ta ihẽ rehe. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. ");
INSERT INTO urbNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Jundéu awa aja ym ame'ẽ ta koty ihẽ ke jundéu awa ta raho ta. Pe, jundéu awa aja ym ame'ẽ ta puka puka hũ ta ihẽ rehe. Ihẽ ke a'eta muhuxĩ ta tĩ. Ihẽ rehe tymũ ta tĩ. (Aja ihẽ jaxer aja mujekwa ta naĩ.) ");
INSERT INTO urbNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ihẽ ke a'eta pirok ta tĩ. Pe, ihẽ ke jukwa ta tĩ. Mokõi aker rahã, ihẽ akwera katu ta ahem tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Anĩ. Ame'ẽ panduha ke jumu'eha ta ukwa ym te. Pyhyk ym te. Ukwaha ke Tupã mukanim te'e we ngã ngi. A'erehe Jesu pandu ame'ẽ ke ukwa ym. ");
INSERT INTO urbNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jeriko ok ta pe Jesu uhyk tate rahã, pe rymy'y rake amõ sawa'e wapyk uĩ. Eha ym te ame'ẽ ke a'e. Tamatarer ke ngã pe pandu pandu uĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Heta ame'ẽ ta ohoha ke rehe hendu. Pe, pandu: —Ma'e puki? — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Amõ ta pandu: —Jesu Nasare ok ta pe har ko oho ixo — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pe, ame'ẽ pukái: —Jesu! Ndawi rainõ nde! Ihẽ rehe epyrara esak! — aja Jesu pe. (“Ndawi rainõ” aja pandu rahã: “Kapitã keruhũ” aja Tupã mu'am ame'ẽ ke a'e, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hundutar oho ame'ẽ ta je'ẽ je'ẽ hũ ipe: —Epukái ym nde — aja ipe. Anĩ. I'ar koty te we hãtã pukái: —Sawa'e! Ndawi rainõ nde. Ihẽ rehe epyrara esak — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Pe, Jesu pyta. Amõ ta pe pandu: —Se perur — aja. Pe, eha ym te ame'ẽ ke uhyk tate uwyr ehe rahã, Jesu pandu ipe: ");
INSERT INTO urbNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—Ma'e nde pe ihẽ ama'e ta my? — aja ipe. A'e pandu: —Sawa'e! Ihẽ reha ym te. Ihẽ reha ke emukatu! — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Pe, a'e pandu: —Ere! Upa ma'e ahyha ke ihẽ amukatu, ame'ẽ ke rehe nde erejurujar katu, a'erehe nde reha katu apo 'y. Eho katu 'y — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Pe, pahar eha opok. Upa ma'e ke rehe usak katu. Pe, inamõ oho, Jesu namõ. Tupã pe: “Ne jõ riki katu te me'ẽ ke” aja pandu pandu oho ixo. Upa mukatuha rehe usak ame'ẽ ta aja tĩ. “Ne jõ riki katu te me'ẽ ke” aja pandu pandu oho ixo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Pe, Jeriko ok ta pe Jesu uhyk oho. Ame'ẽ rupi asa oho ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","A'ep amõ sawa'e ixo. Her Sakéu. Ima'ehũ namõ ixo ame'ẽ ke a'e. (A'erehe te'eha rupi tamatarer a'e matyr hũ. A'erehe sawa'e jaxer ai, aja ngã ukwa. Homa awa tama'e kapitã keruhũ pe tamatarer ke matyr. A'e aja amõ ta ixo tĩ.) Ame'ẽ tama'e kapitã ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","“Awa riki Jesu my?” Ame'ẽ ke ukwa tar katu. Heta ame'ẽ ta Jesu rake rupi ixo. A'e sawa'e ra'yr mi te'e, a'erehe marã ka ym jumupukuha usakiha. ");
INSERT INTO urbNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","A'erehe heta ame'ẽ ta hundutar koty ujan oho. Pe, myrahu rehe jupir oho. A'ep harõ uĩ. Ame'ẽ iwyr rupi Jesu oho rahã, Sakéu usak ta ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pe, ame'ẽ myrahu wyr pe uhyk rahã, ywate koty Jesu ma'ã. Pe, pandu ipe: —Sakéu! Pahar ewyjy ejur! Apo ne namõ ihẽ apyta ta me'ẽ te'e — aja Jesu. —Ere! — aja Sakéu. ");
INSERT INTO urbNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Pe, pahar Sakéu wyjy uwyr. Huryha namõ Jesu ke muhyk katu, hok pe. ");
INSERT INTO urbNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Upa ame'ẽ ke rehe usak ame'ẽ ta je'ẽ je'ẽ hũ: —Mã! Sawa'e jaxer ai ame'ẽ ke namõ pyta ta oho — aja Jesu rehe har je'ẽ je'ẽ hũ. ");
INSERT INTO urbNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ajame'ẽ ke Sakéu pu'am. Jesu pe pandu: —Sawa'e! Ehendu katurahã! Upa ihẽma'e ke ihẽ amowok ta apo 'y. Pe, wajar ke ima'e ym te ame'ẽ ta pe ihẽ ame'ẽ me'ẽ ta. Yman te'eha rupi amõma'e ke apyhyk. A'erehe amujywyr ta apo 'y. I'ar koty te we amujywyr ta ipe. Te'eha rupi peteĩ apyhyk rahã, tumeme amujywyr ta ipe — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","A'e pandu ipe: —Ma'e nde ereka'u te'eha nde erema'ema'eha ke nde erehijar aja nde eremujekwa. (A'erehe Tupã koty nde py'a nde eremuruwak, aja nde eremujekwa katu.) A'erehe nde ke Tupã muhã katu. Amarã rainõ ke nde. ");
INSERT INTO urbNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ma'e ka'u te'eha ke ma'ema'e, ame'ẽ ta ke ihẽ akekar ajur. Ame'ẽ ta ke ihẽ amuhã katu ajur tĩ. Aja rahã mupyraraha renda pe oho ym ta — aja Jesu pandu. (“Amarã rainõ” aja pandu rahã: “Jundéu awa ke a'e” aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sakéu pe pandu ame'ẽ ke rehe amõ ta hendu. Ame'ẽ ta kuja ukwaha. Jerusarẽ ok ta pe Jesu uhyk tate, a'erehe kuja ukwaha naĩ. “Jundéu awa tama'e kapitã keruhũ ihẽ” aja Jesu pandu ta, aja ame'ẽ ta ukwaha naĩ. (Anĩ. Yman rahã, kapitã keruhũ wan ta aja Jesu mujekwa tar katu.) A'erehe myja me'ẽ kapitã keruhũ wan ta ame'ẽ my, ame'ẽ ke Jesu pandu ngã pe. Kuja: ");
INSERT INTO urbNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—Amõ sawa'e ixo. Kapitã ra'yr ke a'e. Amõ ywy pepaite ame'ẽ pe oho tate. A'ep kapitã keruhũ wan amõ mu'am ta. Upa rahã, hekoha pe jywyr ta. Kapitã keruhũ aja jywyr ta. ");
INSERT INTO urbNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Oho tate rahã, miasu ta ke mujy'ar. Jande popa hetaha mujy'ar. Ame'ẽ ta pe ita tamatarer tawa ke me'ẽ me'ẽ. Peteĩ pame katu te me'ẽ me'ẽ. Pe, pandu: “Pepaite ihẽ axo rahã, kome'ẽ tamatarer pemuhepy hepy. Pemuheta” aja ijar pandu. Pe, oho. ");
INSERT INTO urbNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pe, hekoha pe har ta putar ym a'e ke. A'erehe haikwer rupi myrandu rahoha ke a'eta mondo. Kuja myrandu ke raho: “Peme'ẽ sawa'e kapitã keruhũ aja emu'am ym. Japutar ym. Jandema'e kapitã keruhũ aja japutar ym” aja hekoha pe har ta mondo. ");
INSERT INTO urbNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","—Anĩ. Ame'ẽ sawa'e ke kapitã keruhũ aja amõ mu'am. Pe, hekoha pe jywyr oho. Uhyk rahã, amõ ta pe pandu: “Se miasu ta ke pemuhyk perur. Tamatarer ihẽ ame'ẽ. Ame'ẽ ta ke pemuhyk perur. Myja ame'ẽ ta muheta my? Ame'ẽ ke akwa ta” aja ijar. ");
INSERT INTO urbNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pe, uhyk py, ame'ẽ pandu: “Sa'e! Peteĩ ita tamatarer tawa ihẽ pe nde eremuwyr. Ame'ẽ ke amuhepy hepy. Aja amuheta mondo. Jande popa ita tamatarer tawa kohĩ apo. Ko upa nema'e” aja miasu. ");
INSERT INTO urbNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ijar pandu: “Katu tiki! Miasu katu ame'ẽ ke nde. Ma'e ta'yr mi ame'ẽ ke rehe nde eresak eresak katu, aja akwa. A'erehe apo ngi har heta ok ta rehe nde eresak eresak ta. Kapitã aja nde tĩ. Kuja, jande popa hetaha ok ta rehe nde eresak eresak ta apo 'y” aja miasu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","—Pe, amõ miasu uhyk uwyr ehe tĩ. Pandu: “Sa'e! Peteĩ ita tamatarer tawa ihẽ pe nde eremuwyr. Ame'ẽ ke ihẽ amuheta tĩ. Awa po wajar peteĩhar upa ita tamatarer tawa kohĩ apo. Upa nema'e ko” aja miasu. ");
INSERT INTO urbNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ame'ẽ pe ijar pandu: “Heta ok ta rehe nde eresak eresak ta tĩ. Kuja, awa po wajar peteĩhar upa hetaha. Kapitã aja nde tĩ” aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","—Pe, amõ miasu uhyk uwyr ehe tĩ. Pandu: “Sa'e! Ko nema'e ita tamatarer ke. Nde eremuwyr ihẽ pe, ame'ẽ ke ko. Pan kurer ra'yr pe ihẽ apukek, pe, amukanim katu inom. ");
INSERT INTO urbNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kyty'ym ame'ẽ ke nde. A'erehe nengi akyje. Amõma'e ke nde erejo'ok katu. Kupixa pe amõ jytym, ame'ẽ ngi ma'e ke nde ere'u te'e” aja miasu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ijar parahy ehe. Pandu ipe: “Katu ym nde! Nde erepandu ame'ẽ namõ nde ke ihẽ amahy ta. Akyty'ym ame'ẽ ke ihẽ, aja nde erekwa riki. Amõma'e ke ihẽ ajo'ok katu, aja nde erekwa tĩ. Amõ jytym ame'ẽ ngi ma'e ke ihẽ a'u te'e, aja nde erekwa tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Aja rahã, tamatarer matyriha renda pe ihẽma'e tamatarer nde eremoĩ rahã, katu ta tipe. Jeje jumuheta ta tipe. Pe, ihẽ ajywyr rahã, ame'ẽ ke ihẽ apyhyk ta tipe. Muhetaha ke apyhyk ta tipe tĩ” aja miasu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","—Pe, a'ep i'ãi ame'ẽ ta pe ijar pandu: “Ita tamatarer tawa ke pejo'ok ingi. Amõ miasu pe peme'ẽ. Jande popa hetaha namõ ixo ame'ẽ pe peme'ẽ” aja. ");
INSERT INTO urbNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Amõ ta pandu: “Mã! Sa'e! Heta riki ima'e apo 'y. Jande popa hetaha” aja ijar pe. ");
INSERT INTO urbNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","A'e pandu: “Katu. Ko apandu pehẽ pe. Heta ima'e ke namõ ixo ame'ẽ pe i'ar koty te we amõ me'ẽ ta. Ima'e ym ame'ẽ ke ta'yr mi te'e namõ ixo, aja ukwaha naĩ. Ame'ẽ ke amõ jo'ok ta ingi. ");
INSERT INTO urbNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","—Apo ihẽ ruwajan ta ke ihẽ ruwa koty pemuhyk perur. Pejukwa. Ame'ẽ ta ihẽ ke putar ym. Ihẽ riki kapitã keruhũ aja putar ym. Ame'ẽ ta ke pejukwa” aja ijar pandu — aja Jesu mu'e. (Aja mu'e rahã, juehe har pandu. A'e riki kapitã keruhũ aja putar ym ngã. Anĩ. Kapitã keruhũ rahã, upa huwajan ta ke mupyrara ta, aja Jesu mu'e katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ame'ẽ ke upa pandu rahã, Jerusarẽ ok ta pe oho. A'e ngã hundutar koty oho. ");
INSERT INTO urbNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pe, amõ mokõi ok ta pe uhyk tate. Her Metaje. Ame'ẽ rake Mbeta ok ta ihĩ tĩ. Ame'ẽ mokõi ok ta ywy'ã rake ihĩ. Ywy'ã rer Oriwéi ty. A'ep uhyk tate rahã, mokõi jumu'eha ta ke hundutar koty Jesu mondo. ");
INSERT INTO urbNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Kuja pandu: —Pesarahã! Jande ndutar koty we ok ta ihĩ, Mbeta ok ta ke. A'ep pehẽ mokõi peho. Ok ta pe pexe rahã, a'ep jumen ra'yr rehe pesak ta. Myra jytyka ame'ẽ rehe amõ pukwar. Ame'ẽ 'ar pe amõ oho ym rĩ. Ame'ẽ ke pejirar. Se ihẽ pe pemuhyk perur. ");
INSERT INTO urbNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Amõ ta kuja pandu ta pehẽ pe: “Ma'erehe jumen pejirar my?” aja. Aja rahã, kuja pepandu: “Sawa'e putar. Xupe 'ar pe oho ta” aja a'eta pe pepandu — aja mokõi jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Pe, ame'ẽ mokõi sawa'e ta oho. Jesu pandu, aja upa katu te mahem. ");
INSERT INTO urbNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jumen ra'yr ke jirar u'am rahã, jumen jar ta pandu: “Ma'erehe jumen pejirar my?” aja mokõi sawa'e ta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Sawa'e ta pandu: —Sawa'e putar. Kome'ẽ 'ar pe oho ta — aja. —Hã! — aja ame'ẽ ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pe, jumen ra'yr ke Jesu rehe muhyk raho. Xupe 'ar rupi a'etama'e mundeha ke ngã mou mou. (Aja rahã, kapitã keruhũ ko, aja mujekwa.) Jumen kupe rehe mundeha mou. Ame'ẽ 'ar pe Jesu ke a'eta mondo. ");
INSERT INTO urbNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pe, jumen 'ar pe oho ixo rahã, a'ep ixo ame'ẽ ta mundeha ke mou mou. Awa rape rupi mundeha ke mou mou. (Aja rahã, kapitã keruhũ jumai ym ha namõ ko tur, aja mujekwa.) Pe, kamixa 'ar rupi jumen pyrũ wata oho. ");
INSERT INTO urbNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pe, Jerusarẽ ok ta pe uhyk tate rahã, ywy'ã ngi amõ wyjy oho. Ywy'ã rer Oriwéi ty. A'ep heta te hũ jumu'eha ta oho ixo inamõ. Pahar Tupã pe ame'ẽ ta pandu pandu: “Ne jõ riki katu te me'ẽ ke” aja ipe. Hãtã Jesu rehe har katu pandu pandu tĩ. Jesu mukatu hũ ngã ke ame'ẽ ke rehe a'eta usak. Ame'ẽ rehe har katu pandu pandu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","A'eta pandu: —Sawa'e te je'ẽha rupi uwyr ame'ẽ ke ko. Mã peja Tupã usak katu ehe. Mã peja ywa pe har ta hury katu ixo. Tupã jõ riki katu te me'ẽ ke. Ywatehar ke a'e — aja riki. ");
INSERT INTO urbNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Heta ame'ẽ ta pyter pe parise ta ixo. Ame'ẽ ta ngi har amõ amõ pandu: —Sawa'e! Ngã mu'eha nde. Nema'e jumu'eha ta pe epandu: “Pepukái ym” aja — aja Jesu pe parise ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pe, a'e pandu: —Anĩ. Ko apandu pehẽ pe. Ame'ẽ ta pandu ta me'ẽ te'e. Marã ka ym je'ẽha mukanĩha — aja parise ta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ok ta koty oho we. Usak ehe rahã, Jesu jixi'u ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Pe, ame'ẽ Jerusarẽ ok ta pe har ta rehe har pandu: —Mã! Myja pehẽ py'a ke amuhury katu my? Ame'ẽ ke apo pekwa rahã, katu ta tipe. Apo marã ka ym pekwaha. ");
INSERT INTO urbNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pehẽ pe pyraraha 'ar ke uhyk ta kỹ. Pehẽ ruwajan ta uhyk ta kỹ. Ok ta kupe 'ar rupi juramã ta u'am. Mukurar ta. Upa kynda ta. Pe, jumai ta. Juramã ta ngã jumai uwyr. ");
INSERT INTO urbNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Upa katu te ok ta ke mujaxer ta. Ok ta pe har ta ke jukwa ta tĩ. Ita ngã mupu'am ame'ẽ ke upa ombor ta. Ihẽ ke Tupã muwyr. Pehẽ py'a ke ihẽ riki amuhury katu ta tipe. Ihẽ ke peputar ym. Pekwa tar ym ihẽ rehe har. A'erehe pehẽma'e ok ta ke pehẽ ruwajan ta upa mujaxer ta — aja Jesu pandu. (“Pehẽma'e ok ta” aja pandu rahã: “Jerusarẽ ok ta ke” aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tupã rehe ngã jumu'eha renda keruhũ pe Jesu oho. A'ep ma'e muhepyha ta ixo. Ame'ẽ ta ke muhem mondo. ");
INSERT INTO urbNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Pandu a'eta pe: —Tupã je'ẽha rehe panduha ihĩ. Kuja Tupã pandu: “Ihẽ rehe ngã jumu'eha renda pe ihẽ namõ ngã pandu pandu katu. Ame'ẽ renda ke aja ngã ukwa” aja Tupã. —Pehẽ anĩ. Ame'ẽ ke amõ koty pemuruwak. Ma'e mukanĩha renda aja pemuruwak. Katu ym aja — aja ma'e muhepyha ta pe Jesu pandu. (Ma'e ke muhepy rahã, ka'u te'eha rupi muhepy, a'erehe: “Mukanĩha renda ke” aja Jesu pandu.) Pe, muhem mondo ingi. ");
INSERT INTO urbNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tupã rehe ngã jumu'eha renda keruhũ pe Jesu mu'e. Wera rahã pame katu te mu'e. A'e ke jundéu awa tama'e pa'ihu ta jukwa tar katu. Moise je'ẽha mu'e ame'ẽ ta aja tĩ. Jukwa tar katu tĩ. Jundéu awa tamũi ta aja tĩ. Jukwa tar katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Myja jukwa ta my? Upa ngã hendu katu u'am ehe. Hury katu ehe. Upa katu te ukwa tar katu. A'erehe marã ka ym jukwaha. Pa'ihu ta kyje ngã ngi. ");
INSERT INTO urbNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Amõ wera rahã, Tupã rehe ngã jumu'eha renda keruhũ pe Jesu mu'e uĩ. Ngã pe myrandu katu ke pandu pandu uĩ tĩ. Arahã amõ ta uhyk uwyr ehe. Jundéu awa tama'e pa'ihu ta uhyk uwyr ehe. Moise je'ẽha mu'e ame'ẽ ta uhyk uwyr ehe tĩ. Jundéu awa tamũi ta uhyk uwyr ehe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Upa ame'ẽ ta pandu ipe: —Jande pe epandurahã! Sengi muhepyha ta ke nde eremuhem eremondo. Awa je'ẽha rupi nde eremuhem eremondo my? Awa riki nde ke muwyr se my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","A'e pandu: —Ihẽ aja tĩ. Pehẽ pe apandu ta tĩ. Ngã ke Juã mujahuk rahã, Tupã je'ẽha rupi mujahuk my? — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pe, se koty Jesu ngi oho. Pe, a'eta pandu pandu hũ a'eta jupe. —Myja japandu ta my? “Tupã je'ẽha rupi Juã mujahuk” aja japandu rahã, jande pe Jesu pandu ta: “Aja rahã, ma'erehe Juã pandu ame'ẽ ke rehe pejurujar ym my?” aja jande pe pandu ta. ");
INSERT INTO urbNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Anĩ. “Sawa'e je'ẽha rupi Juã mujahuk” aja japandu rahã, peme'ẽ heta ame'ẽ ta jukwa ta jande ke. Ita pe jukwa ta. Juã riki Tupã je'ẽha pandu ame'ẽ ke a'e, aja peme'ẽ ta ukwa katu, a'erehe: “Sawa'e je'ẽha rupi” aja japandu rahã, jande ke jukwa ta — aja a'eta je'ẽ je'ẽ hũ a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Myja ym panduha. Ukwa ym. A'erehe Jesu koty jywyr rahã, a'eta pandu: —Juã rehe har japandu ym ta nde pe — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Pe, a'e pandu: —Aja rahã, ihẽ aja tĩ. Awa je'ẽha rupi ma'e ke ihẽ ama'ema'e. Ame'ẽ ke pehẽ pe apandu ym ta tĩ — aja tamũi ta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pe, myja me'ẽ kupixa usakiha ta my, ame'ẽ ke Jesu pandu: —Ko amõ sawa'e kupixa pe ma'e ke jytym. Ma'eywa rãkã ra'yr ke jytym. Uwa'y rãkã ke. Upa rahã, amõ ta pe pandu: “Kupixa rehe pesak katu. I'a tyarõ rahã, ko amõ pehẽma'e ta kỹ. Amõ i'a ihẽma'e ta kỹ” aja. “Ere” aja ame'ẽ ta pandu. Pe, amõ ywy pe ijar paxia oho. Yman a'ep ihon rĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","—Ma'eywa tyarõ rahã, miasu ke ijar mondo. Pandu: “Kupixa usakiha ta koty eho. Ma'eywa rykwer rehe eho piam” aja. Uhyk rahã, ame'ẽ ta pe miasu pandu: “Ihẽ jar ma'e ke jõ ihẽ pe pemuwyr” aja. Anĩ. Miasu ke usakiha ta nupã te'e. Ijar koty ipo te'e mujywyr mondo. ");
INSERT INTO urbNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pe, amõ miasu ke ijar mondo tĩ. Ame'ẽ ke usakiha ta nupã te'e tĩ. Muhuxĩ tĩ. Pe, ijar koty ipo te'e mujywyr mondo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pe, mahapyrihar ke ijar mondo tĩ. Ame'ẽ ke usakiha ta mahy te'e tĩ. Kupixa ngi ombor muhem mondo. ");
INSERT INTO urbNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","—Pe, kupixa jar jupandu jupe: “Myja me'ẽ ihẽ ama'e ta apo my? Kuja nahã. Ihẽ ra'yr ke ihẽ amondo ta. Ihẽ apy'a katu ehe ame'ẽ ke a'e. A'e ke usakiha ta mahy ym ta nahã my” aja jupe. A'erehe ta'yr ke mondo. ");
INSERT INTO urbNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pe, ta'yr rehe usakiha ta usak rahã, pandu a'eta jupe: “Ko riki ijar ra'yr ke. (Ipái manõ rahã, kupixa riki ima'e wan ta. Jahorahã!) Jajukwa ta peme'ẽ. Aja rahã, kupixa jandema'e wan ta” aja a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","A'erehe ta'yr ke kupixa ngi a'eta ombor muhem mondo. Jukwa riki — aja Jesu pandu. A'e pandu tĩ: —Apo myja usakiha ta pe kupixa jar ma'e ta my? Kuja riki. ");
INSERT INTO urbNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","A'e uhyk rahã, usakiha ta ke jukwa ta. Pe, amõ kupixa usakiha ta ke mu'am ta — aja Jesu. Ame'ẽ ke rehe ngã hendu rahã, pandu: —Mã! Peja ym — aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesu usak katu ngã rehe. Pandu: —Kuja Tupã je'ẽha rehe panduha ihĩ: “Ita rehe har ita ok mujãha pandu: ‘Jaxer te'e kome'ẽ ita ke’ aja. Tupã pandu: ‘Anĩ. Peme'ẽ riki ok pyter wan mupu'am katu riki’ aja a'e pandu” aja panduha ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","—Kome'ẽ ita rehe ipy ke amõ tukwa rahã, ahy ta. Amõ rehe ita u'ar rahã, mupe ta — aja Jesu pandu. (“Ita” rehe har Jesu pandu rahã: “Juehe har” a'e pandu. “Ipy tukwa” aja pandu rahã: “Jesu ke amõ ta putar ym” aja mujekwa. “Amõ rehe ita u'ar” aja pandu rahã: “Ame'ẽ ke Tupã mupyrara hũ ta” aja a'e mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kupixa usakiha ta rehe har Jesu pandu rahã, Moise je'ẽha mu'e ame'ẽ ta kuja ukwa. —Mã! Jande rehe har Jesu pandu. Mã! Katu ym — aja a'eta ukwaha. A'erehe a'ep Jesu ke a'eta pyhyk tar katu. Jundéu awa tama'e pa'ihu ta aja tĩ. Pyhyk tar katu tĩ. —Apo japyhyk ta — aja pandu. Anĩ. Pyhyk ym we rĩ. Ngã ngi kyje. Pyhyk rahã, ame'ẽ ta ke ngã nupã ta, ame'ẽ ngi kyje, a'erehe pyhyk ym we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","A'erehe pyhykiha angaha ke rehe harõ we ixo rĩ. Amõ sawa'e ta pe pa'ihu ta pandu. Moise je'ẽha mu'e ame'ẽ ta pandu tĩ. Kuja. —Jesu koty peho. “Nde eremu'e ame'ẽ ke jakwa tar katu” aja pepandu ipe. Inamõ pepandu pandu. Pe, ma'e katu ym ame'ẽ ke pandu rahã, kapitã pe a'e ke jande johu jaraho ta. Kapitã je'ẽha rupi jajukwa ta. Aja Jesu ke pepyhyk rahã, tamatarer hũ pehẽ pe jame'ẽ ta — aja sawa'e ta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Pe, Jesu rehe sawa'e ta uhyk rahã, (muka'u te'e tar katu, a'erehe katu ehe har pandu py.) Kuja, pandu ipe: —Sawa'e! Ngã mu'eha nde. Nde erepandu ame'ẽ ke jetehar te ke aja jakwa. Nde eremu'e ame'ẽ ke aja tĩ. Jetehar te ke tĩ. Upa ngã rehe juja katu te aja nde eresak katu tĩ, aja jakwa tĩ. Myja awa ixoha katu my, ame'ẽ ke myja Tupã putar katu, ame'ẽ ke jetehar rupi nde eremu'e, aja jakwa tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Apo jande pe epandurahã! Homa awa tama'e kapitã keruhũ pe tamatarer ke jame'ẽ rahã, katu my? Anĩ rahã, jame'ẽ ym ta my? Myja me'ẽ jundéu awa je'ẽha mujekwa my? “Peme'ẽ katu” aja mujekwa my? “Peme'ẽ ym” aja mujekwa my? Epandurahã — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ame'ẽ panduha namõ muka'u te'e tar katu, aja Jesu ukwa katu. A'erehe a'eta pe pandu: ");
INSERT INTO urbNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Ita tamatarer pu'a ra'yr ke ihẽ pe perur. Asak ta — aja. Pe, amõ ta werur ipe rahã, pandu. —Pesarahã! Kome'ẽ tamatarer rehe awa'ã ihĩ my? Awa rer amõ mupinim ko my? — aja sawa'e ta pe. Ame'ẽ ta pandu: —Homa awa tama'e kapitã keruhũma'e ke — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Pe, a'e pandu: —Aja rahã, ma'e ke kapitã keruhũma'e ke rahã, kapitã keruhũ pe peme'ẽ katu. Tupãma'e rahã, Tupã rehe pehẽ py'a pemoĩ moĩ katu. Ame'ẽ riki ma'e ke peme'ẽ ipe, ame'ẽja saka — aja sawa'e ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Panduha namõ Jesu ke amõ ta muka'u te'e ym te, a'erehe heta ame'ẽ ta ruwa koty: “Katu ym nde erepandu” aja Jesu rehe har marã ka ym panduha. Ma'e ka'u te'eha ke mahem ym te ipe, Jesu pe. A'erehe a'eta je'ẽha uhem ym. Kuja jõ ukwa: —Mã! Pandu katu a'e — aja Jesu rehe har. ");
INSERT INTO urbNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pe, amõ sanduse ta uhyk uwyr ehe. Ame'ẽ ta awa kwera ym te ta, aja ukwaha. A'eta pandu ipe: ");
INSERT INTO urbNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Sawa'e! Ngã mu'eha nde. Yman kuja Moise mupinim jande pe: “Sawa'e jumendar, pe, ta'yr ym ipe rahã, manõ rahã, imu riki imu ambyr rakehar ke pyhyk. Pe, a'e ta'yr ipe. Ame'ẽ ta'yr riki imu ambyr ra'yr aja ngã ukwa” aja Moise mupinim. ");
INSERT INTO urbNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","—Apo ehendurahã! Se awa po wajar mokõi imu ta ixo kwe. U'ar py ame'ẽ ke jumendar. Pe, ta'yr ym ipe riki. Pe, manõ. ");
INSERT INTO urbNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A'erehe imu riki imu ambyr rakehar ke pyhyk tipe tĩ. Mokõihar ke ame'ẽ. (Ame'ẽ sawa'e manõ tĩ. Ta'yr ym ipe riki tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","A'engi imu mahapyrihar kũjã ke pyhyk tipe tĩ. (Aja tĩ. Manõ tĩ. Ta'yr ym ipe tĩ.) Aja upa imu ta riki tĩ. Awa po wajar mokõi imu ta ke. Upa imu ambyr rakehar ke pyhyk tipe. Upa manõ tĩ. Ta'yr ym te a'eta ipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","A'engi kũjã manõ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Apo esarahã! Yman rahã, manõ ame'ẽ ta kwera katu uhem rahã, kũjã riki awa rakehar wan ta my? Se ixo rahã, upa imu awa po wajar mokõi riki pyhyk? — aja sanduse ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesu pandu: —Kome'ẽ ywy keruhũ pe kũjã ta ke sawa'e ta pyhyk katu. Sawa'e ta ke kũjã ta aja tĩ. Pyhyk katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Awa kwera katu uhem rahã, anĩ ta. “Pehẽ katu. Pekwera katu pehem. Ihẽ namõ pexo katu” aja Tupã pandu ta. Ame'ẽ ta jumendar ym te ta. Arahã sawa'e ta pyhyk ym te ta kũjã ta ke. Pe, sawa'e ta ke kũjã ta pyhyk ym te ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ame'ẽ ta ke Tupã mukwera katu muhem. A'erehe Tupã ra'yr ta aja ame'ẽ ta. Tupã je'ẽha rahoha ta aja saka tĩ. (A'erehe kũjã ta ke sawa'e ta pyhyk ym te ta tĩ. Sawa'e ta ke kũjã ta pyhyk ym te ta tĩ.) Pe, Tupã je'ẽha rahoha ta aja manõ ym te ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","—Manõ ame'ẽ ta ke Tupã mukwera ta. Aja yman Moise mujekwa katu te. Kuja. Ju pirã'y ukwái ukwái u'am. Ame'ẽ rehe har Moise mupinim. Arahã Tupã panduha ke a'e mupinim. Arahã kuja Tupã pandu: “Ihẽ rehe ipy'a ke Amarã moĩ moĩ katu. Isak aja tĩ. Ipy'a ke moĩ moĩ katu tĩ. Jako aja tĩ. Ipy'a ke a'e moĩ moĩ katu tĩ” aja Tupã pandu. Aja Moise mupinim. ");
INSERT INTO urbNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pesarahã! Ixuwe katu ame'ẽ ta jõ Tupã rehe ipy'a ke moĩ moĩ katu. Manõ ame'ẽ ta anĩ. Aja rahã, Amarã ta'ã ixuwe katu aja ixo rĩ. Yman riki manõ. I'ã ixuwe katu ixo. A'erehe tapijar te'e we ipy'a moĩ moĩ katu Tupã rehe. (A'eta'ã pehĩ.) A'erehe manõ ame'ẽ ta kwera katu ta kỹ, aja Tupã mujekwa katu — aja sanduse ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Moise je'ẽha mu'e ame'ẽ ta ixo. Ame'ẽ ta ngi har amõ ta pandu: —Sawa'e! Katu riki nema'e panduha ke — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","A'engi ma'e ke a'eta pandu ym we ipe, Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesu pandu ngã pe: —Kirisutu riki Ndawi rainõ ke, aja amõ ta pandu. Ma'erehe my? ");
INSERT INTO urbNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pesarahã! Tupã je'ẽha rehe panduha ihĩ. Her Saumo. Ame'ẽ rehe ihĩ. Ame'ẽ pe Ndawi panduha ihĩ. Kuja pandu: “Ihẽma'e sawa'e te pe jandema'e sawa'e te pandu: ‘Se ihẽ rake ewapyk eĩ. (Aja rahã, katu te ame'ẽ ke nde, aja amujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ne ruwajan ta ke ihẽ amuputu'u ta, a'erehe nde rehe ame'ẽ ta hendu katu ta’ ” aja Ndawi panduha ke. ");
INSERT INTO urbNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","—“Ihẽma'e sawa'e te” aja Kirisutu rehe har Ndawi pandu. (Aja rahã, a'e Tupã tĩ, aja Ndawi ukwa.) Aja rahã, myja Kirisutu riki Ndawi rainõ my tĩ? (Ndawi rainõ aja rahã, awa te'e a'e tĩ, aja mujekwa katu) — aja Jesu pandu. Ame'ẽ rehe har pandhuha mujywyr ym ipe, Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jesu pandu ame'ẽ ke rehe heta ame'ẽ ta hendu ixo. Arahã jumu'eha ta pe Jesu pandu: ");
INSERT INTO urbNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Moise je'ẽha mu'e ame'ẽ ta aja ym pexo. Ima'e mundeha katu te ame'ẽ namõ jõ a'eta wata katu. (Aja rahã, Tupã rehe ipy'a moĩ moĩ katu aja mujekwaha jupe naĩ.) Muhepyha renda pe oho rahã: “Sa'e! Ko nde erexo. Nde katu” aja panduha jõ putar katu. Jundéu awa tama'e jy'ariha renda pe oho rahã, wapyka katu te ame'ẽ ke rehe jõ wapyk tar katu. (Aja rahã, katu te ame'ẽ ke jupe aja mujekwa tar katu tipe tĩ.) Ngã mi'u matyriha pe oho rahã, kapitã tama'e wapyka rehe jõ wapyk tar katu. (Aja rahã, katu te me'ẽ ke jupe aja mujekwa tar katu tipe tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ixawa'e manõ ame'ẽma'e ke a'eta upa mukanim ingi. Hok ke aja mukanim ingi tĩ. Katu ym aja. I'i atu rahã, i'i Tupã namõ ma'e pandu pandu u'am. (Aja sawa'e katu ame'ẽ ta ke a'eta aja mujekwaha jupe naĩ.) Mã! Ame'ẽ ta ke Tupã mupyrara ta. Amõ ta 'ar koty te we ame'ẽ ta ke mupyrara ta. A'erehe Moise je'ẽha mu'e ame'ẽ ta aja ym pehẽ — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Pe, usak u'am rahã, ima'ehũ namõ ixo ame'ẽ ta rehe Jesu usak. Tamatarer ke ame'ẽ ta purakar u'am, tamatarer henda pe. Tupã rehe ngã jumu'eha renda keruhũ pe henda ihĩ, ame'ẽ pe purakar. ");
INSERT INTO urbNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pe, ixawa'e manõ ame'ẽ ke rehe usak tĩ. Nixói te ima'e ke ipe. Mokõi jõ tamatarer pu'a ke henda pe moĩ. Ta'yr te mi ame'ẽ mokõihar ke. ");
INSERT INTO urbNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pe, amõ ta pe Jesu pandu: —Ko apandu katu pehẽ pe. Peme'ẽ ixawa'e manõ ame'ẽ ke ixo. Nixói te ima'e ke ipe. Tamatarer moĩ rahã, amõ ta 'ar koty te we moĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Pesarahã! Amõ ta tamatarer pyta we, ame'ẽ ke ngi henda pe purakar. (Pe, amõ we hũ pehĩ rĩ.) Ixawa'e manõ ame'ẽ ke anĩ. Ima'e ke nixói te ipe. Mokõi jõ tamatarer pu'a. Ame'ẽ namõ ima'e ma'e ke jo'ok ta tipe. Anĩ. Upa katu te ame'ẽ ke henda pe moĩ. (Apo ima'e ym te 'y.) A'erehe amõ ta 'ar koty te we kũjã moĩ katu — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tupã rehe ngã jumu'eha renda keruhũ rehe har amõ ta pandu pandu u'am. —Pesarahã! Mã! Katu te! Ita keruhũ katu te ke te'e ngã mujã. Ko Tupã pe ma'e ke ngã me'ẽ me'ẽ, ame'ẽ ke katu te hũ tĩ — aja pandu. Tupã rehe ipy'a ke amõ moĩ moĩ rahã, ma'e ke werur. Jumu'eha renda keruhũ pe werur. Ame'ẽ riki katu te hũ aja ngã ukwa. Pe, Jesu pandu: ");
INSERT INTO urbNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Peme'ẽ rehe pesak katu apo. Yman rahã, nixói te ta 'y. Peme'ẽ ke amõ ta upa mujaxer ta kỹ. Ita mokõi mokõi ihĩ ym ta kỹ. Upa katu te ita ke amõ ta ombor ta. (Aja rahã, Tupã rehe ngã jumu'eha keruhũ muhãi ta) — aja amõ ta pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Pe, amõ ta pandu ipe: —Sawa'e! Myja rahã, ita mokõi mokõi ihĩ ym ta my? Ma'e jasak ta my, pe, ame'ẽ ke uhyk tate, aja jakwa ta my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A'e pandu: —Pesak katu kỹ! Mã peja pehẽ ke amõ ta muka'u te'e ym. Heta uwyr ta. “Kirisutu je'ẽha rupi ihẽ ajur” aja pandu te'e ta. “Ko Kirisutu ihẽ. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke ihẽ” aja pandu te'e ta tĩ. “Upa angaha rehe uhyk apo” aja pandu naĩ tĩ. Pehendu ym ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jumaiha tyapuha rehe pehendu ta. Paite amõ ta jumai ixo, aja pehendu ta tĩ. Pemukahem ym. Aja jumaiha uhyk ta. Uhyk rahã, 'ar rehe angaha uhyk, anĩ we rĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","A'e pandu tĩ: —Amõ amõ ywy pe har ta jumai mai ta ngã juehe. Amõ amõ kapitã keruhũ ta jumai mai ta ngã juehe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Amõ amõ ywy katak hũ ta tĩ. Ngã mi'u nixói te ta tĩ. Ma'e ahyha uhem hũ ta tĩ. Pe, ywa rehe ma'e ke ngã usak ta tĩ. Mãte uhyk ta, aja ngã ukwa. A'erehe mukahem hũ ta ngã. ");
INSERT INTO urbNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","—Upa aja me'ẽ uhyk ym rahã we, pehẽ ke amõ ta pyhyk ta. Mahy ta tĩ. Jundéu awa tama'e jy'ariha renda pe raho ta tĩ. A'ep pehẽ rehe har je'ẽ je'ẽ hũ ta. “Peme'ẽ ta jaxer” aja naĩ. Pe, pehẽ ke nupã ta. Kyndaha pe pehẽ ke a'eta kynda ta raho tĩ. Ihẽ rehe pejurujar katu, a'erehe kapitã keruhũ ruwa koty pehẽ ke amõ ta mupu'am ta. Kapitã ruwa koty aja tĩ. Pe, mahy ta pehẽ ke. ");
INSERT INTO urbNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Arahã myrandu katu ke pepandu ta. ");
INSERT INTO urbNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kapitã keruhũ ruwa koty pepu'am ym rahã we, kuja pepandu pehẽ jupe my: “Mã! Myja jande juehe har japandu ta my” aja riki. Anĩ. Aja ym pehẽ py'a pe pekwa pekwa pexo. ");
INSERT INTO urbNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Pesarahã! Kapitã ruwa koty pehẽ ke ngã raho rahã, pehẽ pe je'ẽha ke ihẽ amondo ta. Ma'e pekwa katuha ke amondo ta tĩ. Pe, pehẽ ruwajan je'ẽha ke pemukanim ta. “Te'e pepandu” aja a'eta pandu ym ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","—Pehẽ ke pehẽ pái ta kynda ta raho tĩ, kyndaha pe. Pehẽ mãi ta aja tĩ. Kyndaha pe kynda ta raho tĩ. Pehẽ mu ta aja tĩ. Pehẽ rendyr ta aja tĩ. Kyndaha pe a'eta kynda ta raho tĩ. Pehẽ rehe katu ame'ẽ ta aja tĩ. Kyndaha pe a'eta kynda ta raho tĩ. Pe, pehẽ ngi har amõ amõ ta ke a'eta jukwa ta. ");
INSERT INTO urbNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ihẽ rehe pejurujar katu, a'erehe pehẽ rehe upa ngã parahy ta. ");
INSERT INTO urbNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pesarahã! Pehẽ rehe Tupã usak katu ta kỹ. (Aja rahã, pehẽ ke amõ ta jukwa ym ta, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ihẽ apandu ame'ẽ ke rehe tapijar te'e we pejurujar katu pe'am. Pehẽ py'ahu te'e pehendu. Aja rahã, pemanõ ym ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","A'e pandu tĩ: —Jerusarẽ ok ta soroka rupi sonda ta juramã u'am. Ame'ẽ ke rehe pesak rahã, Jerusarẽ ok ta ke mujaxer tate aja pekwa katu. ");
INSERT INTO urbNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pe, Jundéi ywy rehe ixo ame'ẽ ta kanim oho rahã, manõ ym ta. Ywy'ã rupi kanim oho. Ok ta pe ixo ame'ẽ ta uhem oho rahã, manõ ym ta tĩ. Ok ta soroka pe ixo ame'ẽ ta ok ta pe jywyr ym rahã, manõ ym ta tĩ. Ujan oho ingi. ");
INSERT INTO urbNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Jerusarẽ ok ta mujaxeriha 'ar ke: “Mahyha mangaha 'ar ke.” Arahã Tupã je'ẽha rehe panduha ihĩ, aja upa katu te uhyk ta. ");
INSERT INTO urbNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Arahã, imembyr ipusu pe ixo rahã, mã pyrara hũ ta. (Marã ka ym pahar ujaniha.) Ixamby te'e u'u ame'ẽ namõ imãi ixo rahã, pyrara hũ ta tĩ. (Marã ka ym pahar ujaniha tĩ.) Kome'ẽ ywy keruhũ pe har ta rehe ma'e ahyha uhyk hũ ta. Jundéu awa ta ke Tupã mupyrara hũ ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Heta jundéu awa ta ke amõ ta jukwa ta, kyse puku pe. Amõ amõ ywy pe pukwar ta raho tĩ. Pe, Jerusarẽ ok ta ke amõ awa ta mujaxer ta. Ame'ẽ awa tama'e angaha upa ym rahã we, aja te'eha ta. Mujaxer ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","A'e pandu tĩ: —Warahy rehe ma'e ke ngã usak ta. Pe, mukahem hũ ta. Jahy rehe aja tĩ. Ngã usak ta tĩ. Jahy rata rehe aja tĩ. Kome'ẽ ywy keruhũ pe har ta mukahem hũ ta. Y ramũi tyapu hũ, ame'ẽja saka heta te hũ sonda ta uwyr ta. Ame'ẽ ngi mukahem hũ ta ngã. Y kotok keruhũ, ame'ẽja saka uwyr ta tĩ. Mukahem hũ ta ngã tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ma'e pyrara te hũ ha kome'ẽ ywy keruhũ rehe uhyk ta kỹ. Ame'ẽ rehe ngã usak rahã, mukahem hũ ta. Iãkã muka'u te'e hũ ta. Pe, u'ar ukwap. Ywa rehe henda te'e ihĩ, ame'ẽ ke wata hũ. Ame'ẽ rehe mãte hũ amõ ukwaha. Mukahem hũ ta. ");
INSERT INTO urbNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","28","—Ame'ẽ upa rahã, ihẽ ajywyr ta ajur. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ywa takãxĩha 'ar pe ajywyr ta ajur. Tupãma'e pyrãtãha namõ ajywyr ta ajur. Katuha namõ ajywyr ta ajur tĩ. Ihẽ apandu ame'ẽ ke rehe pesak rahã, pepu'am katu. Peta kỹ. Pejuma'u katu kỹ. Aja saka pexo. Pehẽ ruhãha angaha ke rehe uhyk tate — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Pe, myja me'ẽ ma'e ke upa tate rahã my, ame'ẽ ke Jesu pandu: —Ma'e'y rehe har pekwa pekwa pexo. Ma'e, parawa'y ame'ẽja ma'e'y ke. Sik'y amõ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Hokyr uhem ixo rahã, warahy haku tate, aja pekwa. ");
INSERT INTO urbNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aja ta tĩ. Ywa rehe ihĩ, ame'ẽ rehe har ihẽ apandu ramõ. Aja pesak rahã, kome'ẽ ywy keruhũ pe Tupã riki kapitã keruhũ wan ta. Ame'ẽ angaha ke rehe uhyk tate, aja pekwa. ");
INSERT INTO urbNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kuja pekwa katu pexo. Ihẽ apandu ramõ ame'ẽ ke upa katu te uhyk ta tĩ. Ngã mupyraraha ke ihẽ kotyhar ta pyhyk ta. Anĩ. Tapijar te'e we ihẽ rehe jurujar katu ta rĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ywa ke upa kanim ta. Kome'ẽ ywy keruhũ upa kanim ta tĩ. Ihẽ apandu ame'ẽ ke anĩ. Kanim ym te ta. Apandu, aja upa katu te uhyk katu ta kỹ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","A'e pandu tĩ: —Pesak katu pexo! “Jaho rahã! Jande mi'u jamatyr ta. Ja'u ta!” Aja jõ pexo rahã, katu ym tiki. Pexoha rehe jõ pekwa pekwa pexo rahã, katu ym tiki tĩ. Aja te'e pexo rahã, peharõ ym rahã, pahar ihẽ ajywyr ta ajur kỹ. ");
INSERT INTO urbNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","“Jywyr ym we ta rĩ” aja upa kome'ẽ ywy keruhũ pe har ta pandu naĩ rahã, pahar ihẽ ajywyr ta ajur kỹ. ");
INSERT INTO urbNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","A'erehe peharõ katu. Peta kỹ! Pe, kuja Tupã namõ pepandu katu: “Pyrãtãha ke jande pe emuwyr. Aja rahã, upa ma'e uhyk, ame'ẽ ke jande py'ahu te'e jahendu ta. Nde ra'yr ruwa koty japu'am katu ta tĩ” aja tapijar te'e we Tupã namõ pepandu — aja Jesu pandu. Awa a'e tĩ. Tupã je'ẽha rupi uwyr a'e. ");
INSERT INTO urbNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Wera rahã pame katu te Tupã rehe ngã jumu'eha renda keruhũ pe Jesu mu'e uĩ. Ka'aruk koty ok ta ngi uhem oho. Jerusarẽ ok ta ngi uhem oho. Pe, amõ ywy'ã pe pyta ixo. Ywy'ã rer Oriwéi ty. Aja te'e wera oho. ");
INSERT INTO urbNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pytuniwe rahã, Tupã rehe ngã jumu'eha renda keruhũ pe heta ngã oho. A'ep Jesu mu'e ame'ẽ ke rehe hendu oho. ");
INSERT INTO urbNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pe, ngã mi'u matyriha rehe uhyk tate. Her Pasuko. Arahã mbeju ke mupururukiha moĩ ym jundéu awa ta. ");
INSERT INTO urbNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pe, amõ ta Jesu ke jukwa tar katu. Jundéu awa tama'e pa'ihu ta jukwa tar katu Jesu ke. Moise je'ẽha mu'e ame'ẽ ta aja tĩ. Jukwa tar katu tĩ. —Myja Jesu ke jajukwa ta my? — aja ame'ẽ ta pandu pandu a'eta jupe. Heta ame'ẽ ta ngi a'eta kyje. Ngã ukwa rahã, mutyapu hũ ta, a'erehe ngã ngi kyje. ");
INSERT INTO urbNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pe, Jun py'a rehe Satana ihĩ katu. (Ãjã ramũi a'e.) Amõ we Jun her tĩ. Ikario aja Jun her tĩ. Awa py mokõi jumu'eha ta ngi har peteĩ a'e. ");
INSERT INTO urbNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Pe, amõ ta pe pandu oho. Tupã rehe ngã jumu'eha renda keruhũ pe sonda ta ixo. Harõha ta riki ame'ẽ ta. Ame'ẽ tama'e kapitã ta pe Jun pandu oho. Jundéu awa tama'e pa'ihu ta pe pandu oho tĩ. —Ihẽ riki Jesu koty pehẽ ke araho ta kỹ — aja Jun pandu oho. ");
INSERT INTO urbNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ame'ẽ ke rehe pa'ihu ta hendu rahã, hury katu riki. —Jesu koty jande ke nde ereraho rahã, tamatarer jande jame'ẽ ta nde pe kỹ — aja a'eta pandu ipe, Jun pe. ");
INSERT INTO urbNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","—Ere! Katu! — aja Jun pandu. Pe, ngã ukwa ym ha rupi Jesu koty a'eta ke muhyk ta raho, ame'ẽ angaha ke rehe Jun harõ ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pe, ngã mi'u matyriha 'ar rehe uhyk. Arahã mbeju ke mupururukiha moĩ ym jundéu awa ta. Arahã arapuharan ra'yr ke jundéu awa ta jukwa. Ame'ẽ xa'ẽ ke u'u ta. Aja Pasuko 'ar ke a'eta ukwa ukwa uĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pe, Petu pe Jesu pandu. Juã pe tĩ. Kuja pandu: —Pasuko 'ar rahã, jande mi'u ke jande pe pematyr peho tĩ — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","A'eta pandu: —Myp jande jamatyr ta my? Myp nde ereputar my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A'e pandu: —Pesarahã! Jerusarẽ ok ta pe peho. Pehyk rahã, amõ sawa'e pehẽ rehe uhyk ta. Kamuxĩ ra'yr pe y ke raho a'e. Ok pe ixe ta oho. Haikwer rupi peho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ok jar pe kuja pepandu: “Sawa'e pandu nde pe: ‘My ma'e u'uha renda ihĩ? Pasuko 'ar rahã, imi'u ke amõ matyr. Ame'ẽ ke ima'e jumu'eha ta namõ u'u ta’ ” aja ok jar pe pepandu. ");
INSERT INTO urbNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Pe, ywate henda keruhũ ke ok jar mujesak ta pehẽ pe. Upa ma'e ke ihĩ, myrape, paratuxĩ, koje, aja. A'ep jande mi'u ke pematyr — aja Petu ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Pe, a'eta mokõi oho. Jesu pandu, aja me'ẽ upa katu te a'eta usak. Pasuko 'ar rahã, a'eta mi'u ke a'eta matyr tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Angaha ke rehe uhyk rahã, myrape rake Jesu wapyk uĩ. A'e mondo ame'ẽ ta namõ wapyk uĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Pe, pandu: —Pasuko 'ar rahã, jande mi'u ke jamatyr. Ko pehẽ namõ ame'ẽ ke ihẽ a'u tar katu te aĩ. Ihẽ ke amõ ta mupyrara ym rahã we, pehẽ namõ a'u tar katu. Ko pehẽ namõ ihẽ a'u aĩ apo. ");
INSERT INTO urbNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Apandu pehẽ pe. Kome'ẽja me'ẽ amõ ke ihẽ a'u ym te ta tĩ. Kapitã keruhũ aja ihẽ ke Tupã mu'am rahã jõ amõ pehẽ namõ ihẽ a'u ta kỹ tĩ. Arahã Pasuko 'ar te aja jakwa ta kỹ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pe, ita rekúi ra'yr ke pyhyk. “Ne jõ riki katu te me'ẽ ke. Jande mi'u jande pe nde eremuwyr katu” aja Tupã pe pandu. Pe, jumu'eha ta pe pandu: —Peme'ẽ ke pehẽ pame katu te pe'u. ");
INSERT INTO urbNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ko pehẽ pe apandu katu. Uwa rykwer ihẽ a'u ym te ta apo 'y. Kapitã keruhũ aja ihẽ ke ihẽ pái keruhũ mu'am ta kỹ. Arahã jõ pyahu ame'ẽ ke pehẽ namõ a'u ta kỹ tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ajame'ẽ ke mbeju ke pyhyk. Ame'ẽ rehe: “Ne jõ riki katu te me'ẽ ke. Jande pe jande mi'u nde eremuwyr katu” aja Tupã pe pandu. Pe, mopok. Ame'ẽ ke me'ẽ jumu'eha ta pe. Pandu: —Peme'ẽ riki ihẽ rete ke. Pehẽ ma'e peka'u te'eha pema'ema'eha ke rehe ihẽ amuhepy ta. A'erehe ihẽ amanõ ta. Ko mbeju ke ihẽ amopok ramõ. Ihẽ aja pehẽ tĩ. Pemopok mopok tĩ. Ihẽ nixói rahã, pemopok pemopok tĩ. Aja rahã, ihẽ manõha ke pekwa pekwa ta peĩ — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","A'eta mi'u upa u'u rahã, mbeju aja ita rekúi ra'yr ke a'e me'ẽ tĩ. Kawĩ ihĩ ipe. Pandu: —Peme'ẽ riki Tupãma'e pandu katuha pyahu ame'ẽ ke, ame'ẽja saka. Kuja pandu katu: “Ihẽ ra'yr rehe amõ jurujar katu rahã, ame'ẽ ke ihẽ amuhã katu ta” aja. Ihẽ amanõ rahã, ihẽ ruwy uhem ta. A'erehe Tupã pandu katu, aja a'e muhyk katu ta kỹ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","—Pesarahã! Ihẽ ruwajan ta ke ihẽ rehe amõ muhyk ta werur. A'e riki ihẽ namõ myrape 'ar pe wapyk uĩ apo. ");
INSERT INTO urbNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ amanõ ta. Yman ame'ẽ rehe har Tupã pandu katu. Ame'ẽ panduha aja ihẽ amanõ ta. Pe, ihẽ rehe amõ ta ke muhyk ta werur. Mã! Ame'ẽ ke Tupã mupyrara hũ ta — aja a'e mondo ame'ẽ ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pe, a'eta pandu pandu a'eta jupe: —Jande ngi har awa muhyk ta werur my? Awa riki huwajan ta ke muhyk ta werur ehe my? — aja Jesu mondo ame'ẽ ta pandu pandu a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jumu'eha ta pandu pandu hũ a'eta jupe. A'eta pandu: “Jande ngi har awa riki katu te ame'ẽ ke my?” aja a'eta pandu pandu hũ. “Ihẽ ke!” “Anĩ. Peme'ẽ riki!” “Anĩ. Ame'ẽ riki” aja riki pandu pandu hũ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pe, Jesu pandu: —Kome'ẽ ywy keruhũ pe kapitã keruhũ ixo. Je'ẽha rupi ngã ke a'eta mondo mondo. Pe, kapitã ta amõ her jumoĩ juehe. Kuja. “Ima'e awa ta rehe usak katu ame'ẽ ke a'e” aja jumoĩ juehe tipe. A'erehe katu te ame'ẽ ke a'e, aja ukwaha jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pehẽ anĩ. Aja ym pexo. Amõ kotyhar katu. Kuja. Pehẽ ngi har amõ kuja ukwa. “Amõ ta 'ar koty te we ihẽ riki katu te ame'ẽ ke ihẽ” aja ukwa rahã, mã peja pitu te'e aja ixo. Pehẽ ngi har amõ riki katu te aja ukwa rahã, mã peja miasu aja ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Myrape 'ar pe amõ sawa'e wapyk uĩ. Amõ riki imi'u ke me'ẽ me'ẽ raho ipe. Ame'ẽ mokõi ngi har awa riki amõ 'ar koty te we kapitã my? Pesarahã! Wapyk ame'ẽ riki amõ 'ar koty te we kapitãha. Pehẽ pyter pe ihẽ riki kapitam. Anĩ. Ihẽ riki pehẽma'e miasu aja ihẽ axo. A'erehe mã peja aja pexo tĩ. Miasu aja pexo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","—Ihẽ ke amõ ta mupyrara rahã, ihẽ namõ pepyta katu pexo. Aja te'eha ihẽ namõ pexo. ");
INSERT INTO urbNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ihẽ ke kapitã keruhũ aja ihẽ pái mu'am. Ko apandu katu pehẽ pe. Aja pehẽ ke ihẽ amu'am ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Pe, ywa pe ihẽ renda pe ihẽ namõ pexo ta kỹ. Ihẽ riki kapitã keruhũ, ame'ẽ renda pe pexo ta kỹ. A'ep pehẽ riki kapitã keruhũ wan ta tĩ. Tupã kotyhar tama'e kapitã keruhũ aja pexo ta tĩ — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","A'e pandu: —Simã! Ehendu katurahã! Ahúi aja me'ẽ pirer ke amõ ombor rahã, urupen pi'a ke mukatak katu. Aja ixurer ke ombor. Pe, ahúi aja me'ẽ pyta katu. Aja upa pehẽ ke Satana manga ta tĩ. (Ãjã ramũi a'e.) Pehẽ pejurujar katuha ke manga ta. Pehijar my? Pehijar ym my? Ame'ẽ ke manga ta. Pesarahã! Tupã pe Satana pandu: “Nde kotyhar tama'e jurujar katuha ke ihẽ amanga ta” aja a'e. “Ere” aja Tupã pandu ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Simã! Nde rehe har Tupã namõ ihẽ apandu. Ihẽ rehe nde erejurujar katu. “Mã peja Simã py'a emãtã katu. Aja rahã, jurujar katuha ke hijar ym ta” aja ihẽ apandu nde rehe har. Pe, ihẽ koty nde erejywyr rahã, amõ ta py'a ke emãtã katu. Ihẽ rehe jurujar katu ame'ẽ ta py'a ke emãtã katu tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petu pandu ipe: —Sawa'e! Ko axo. Kyndaha pe nde ke amõ kynda raho rahã, ne namõ ihẽ aho ta kỹ. Nde ke amõ ta jukwa rahã, ne namõ ihẽ ke jukwa ta kỹ. Akyje ym — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","A'e pandu: —Petu! Ko apandu nde pe. Pytuniwe te rahã, sapukái je'ẽ ym rahã we, mahapyr kuja nde erepandu ta. “Jesu rehe har akwa ym ihẽ” aja ihẽ rehe har nde erepandu ta — aja Jesu pandu ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jumu'eha ta pe Jesu pandu: —Ymaniwe pehẽ ke ihẽ amondo rahã, tamatarer ryru peraho ym. Pehẽ kupep ma'e ryru aja tĩ. Peraho ym tĩ. Mokõi pehẽ py rehe har aja tĩ. Peraho ym tĩ. Arahã pehẽ pe pehẽma'e upa my? — aja Jesu. A'eta pandu: —Anĩ. Upa ym — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Pe, a'e pandu: —Apo amõ kotyhar. Tamatarer ryru namõ amõ ixo rahã, inamõ oho katu. Ma'e ryru xupe pe har aja tĩ. Inamõ oho katu tĩ. Kyse puku nixói rahã, ame'ẽ rehe kamixa muhepy rahã, katu tiki. Kyse puku namõ pexo. ");
INSERT INTO urbNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tupã je'ẽha rehe kuja panduha ihĩ. “Ma'e mukanĩha ta ke ngã jukwa. Aja ame'ẽ sawa'e ke ngã jukwa ta tĩ” aja panduha ihĩ. Ame'ẽ panduha riki ihẽ rehe har. Aja ihẽ rehe uhyk ta kỹ. Ihẽ aho tate — aja Jesu pandu. (“Kyse puku namõ pexo” aja pandu rahã: “Peta kỹ. Pepyrara ta pexo” aja a'e mujekwa. Anĩ. Amõ koty jumu'eha ta ukwaha. “Pejumai ta pexo” aja ukwaha naĩ.) ");
INSERT INTO urbNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jumu'eha ta pandu: —Sawa'e! Esarahã! Ko mokõi kyse puku — aja ipe. A'e pandu: —A'ewan — aja. ");
INSERT INTO urbNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ok ta ngi Jesu uhem oho. Ywy'ã pe oho. Ame'ẽ riki ohoho ame'ẽ ke. Ywy'ã rer Oriwéi ty. Jumu'eha ta oho inamõ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pe, ame'ẽ renda pe uhyk rahã, pandu: —Tupã namõ pepandu pandu. Aja rahã, pejurujar katuha ke amõ ta manga rahã, pehijar tar ym ta — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Pe, kotete we oho ingi. Kuja, 30 met tate koteteha. Pe, ipynarãi pe wapyk. Aja Tupã namõ pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Papa! Nde ereputar rahã, ihẽ apyraraha ngi ihẽ ke emuhem katu. Anĩ. Ihẽ aputar ame'ẽ ke ema'e ym. Nde ereputar ame'ẽ ke ema'e katu — aja Jesu ipái pe. ");
INSERT INTO urbNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ywa ngi Tupã je'ẽha rahoha uhyk ehe. Ipy'a ke a'e mãtã. ");
INSERT INTO urbNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesu pyai te hũ. A'erehe Tupã namõ a'e pandu pandu we hũ. Hi'ái riki huwy aja ywy rehe sururu hũ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Upa pandu rahã, pu'am. Jumu'eha ta koty jywyr oho. A'eta ukwer ou, aja a'e usak. A'eta pyai te hũ, a'erehe he'õ hũ ou. A'erehe ukwer ou. ");
INSERT INTO urbNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A'e pandu: —Peker ym rahã, katu ta tipe. Pepu'am. Tupã namõ pepandu pandu. Aja rahã, pejurujar katuha ke amõ ta manga rahã, pehijar tar ym ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","A'e pandu u'am rahã, heta ame'ẽ ta uhyk uwyr ixoty. Jun uwyr py. Awa py mokõi jumu'eha ta ngi har peteĩ a'e. Jesu rehe uhyk. Huwa ke pyter ta. ");
INSERT INTO urbNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesu pandu: —Jun! Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ihẽ ruwa ke nde erepyter. Aja ihẽ ke nde eremujekwa ta ngã pe my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesu ke ngã pyhyk ta. Ame'ẽ ke jumu'eha ta ukwa rahã, pandu: —Sawa'e! Kyse puku pe ngã ke jamujan ta jamondo my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Pe, amõ nambi ke kyse puku pe amõ mopok ingi. Ijywa katu kotyhar ke. Jundéu awa tama'e pa'i keruhũma'e miasu pehĩ tĩ. Ima'e nambi ke mopok ingi. ");
INSERT INTO urbNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pe, Jesu pandu: —A'ewan tiki — aja. Pe, miasu nambi renda ke pe ipo mujar. Pe, mukatu. Inambi katu tĩ. Wajar aja katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pe, pyhyk uwyr ame'ẽ ta pe Jesu pandu. Jundéu awa tama'e pa'ihu ta pe pandu. Jundéu awa tamũi ta pe pandu tĩ. Kapitã ta pe pandu tĩ. Tupã rehe ngã jumu'eha renda keruhũ harõha tama'e kapitã ta ke ame'ẽ ta. Kuja Jesu pandu: —Ma'e mukanĩha aja ihẽ ke pepyhyk pejur tĩ. A'erehe kyse puku namõ pejur. Tamarã namõ. Anĩ. Ma'e mukanĩha ym ihẽ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Pesarahã! Wera rahã pame katu te Tupã rehe ngã jumu'eha renda keruhũ pe pehẽ namõ ihẽ axo. Arahã ihẽ ke pepyhyk ym. Pepyhykiha pemanga ym tĩ. Apo anĩ. Ihẽ pepyhykiha angaha ke rehe uhyk apo 'y. Satana ma'ema'eha angaha ke rehe uhyk apo tĩ. (Ãjã ramũi a'e) — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pe, Jesu ke ngã pyhyk raho. Jundéu awa tama'e pa'i keruhũ rok pe raho. Haikwer rupi Petu oho tĩ. Pijaite te'e oho ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pa'i keruhũ rok soroka pe tata ke amõ ta hapy. Ame'ẽ rake ngã jumaku uĩ. Ame'ẽ ta namõ Petu wapyk oho uĩ. Jumaku uĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","A'ep amõ miasu usak ehe. Kũjã ke. A'e ma'ã katu ehe. Pe, pandu amõ ta pe: —Kome'ẽ sawa'e Jesu namõ ixo ame'ẽ ke tĩ — aja kũjã. ");
INSERT INTO urbNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Petu pandu kũjã pe: —Anĩ! Akwa ym ehe har — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","I'i atu amõ sawa'e usak ehe tĩ. Pandu: —Ame'ẽ ta ngi har nde tĩ — aja Petu pe. A'e pandu: —Anĩ! Sa'e! — aja Petu. ");
INSERT INTO urbNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","I'i atu we amõ sawa'e pandu hũ: —Jete! Inamõ ixo ame'ẽ ke a'e tĩ. Ngariréi ywy pe har ke a'e tĩ, a'erehe inamõ ixo ame'ẽ ke a'e tĩ — aja Petu rehe har amõ pandu hũ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petu pandu: —Sa'e! Nde erepandu ame'ẽ ke te'e! Akwa ym ehe har — aja ipe. A'e pandu u'am rahã, pahar sapukái je'ẽ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jesu riki uwak. Petu rehe ma'ã katu te. Ame'ẽ ke Petu ukwa. Pe, Jesuma'e panduha ke Petu ukwa ukwa u'am. Kuja Jesu pandu: “Sapukái je'ẽ ym rahã we, mahapyr kuja nde erepandu ta. ‘Akwa ym ehe har’ aja ihẽ rehe har nde erepandu ta.” Ame'ẽ panduha ke Petu ukwa ukwa u'am. ");
INSERT INTO urbNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pe, a'engi uhem oho. Jixi'u hũ. Huxĩ, a'erehe jixi'u hũ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesu rehe usak te'e ame'ẽ ta puka puka hũ ehe. Ipo pe nupã hũ a'e ke tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kuja. Eha ke amõ ta pukek, pan pe. Pe, ipo pe huwa nupã. Pandu ipe: —Epandurahã! Awa nde ke nupã my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Amõ we tĩ. A'eta juru ai ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pytuniwe rahã, jundéu awa tamũi ta jy'ar oho. Jundéu awa tama'e pa'ihu ta jy'ar oho tĩ. Moise je'ẽha mu'e ame'ẽ ta jy'ar oho tĩ. Ngã panduha renda pe johu jy'ar oho. Amõ ta pe a'eta pandu: —Jesu ke pemuhyk perur se — aja. ");
INSERT INTO urbNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","A'e uhyk rahã, a'eta pandu ipe: —Epandu katu jande pe. Nde riki Kirisutu my? Kapitã keruhũ aja Tupã mu'am ame'ẽ ke nde — aja Jesu pe. A'e pandu: —Ihẽ amujekwa rahã, ihẽ rehe pejurujar ym ta. ");
INSERT INTO urbNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Pe, ma'e ke pehẽ pe apandu rahã, je'ẽha pemujywyr ym ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Apo har ngi Tupã rake ihẽ awapyk ta aho. Tupã pyrãtã te hũ ame'ẽ ke a'e — aja Jesu ngã pe. (“Tupã rake” aja Jesu pandu rahã: “Tupã a'e tĩ” aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Johu pandu ipe: —Aja rahã, nde riki Tupã ra'yr my? — aja Jesu pe. A'e pandu: —A'e ihẽ — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","A'eta pandu: —Mã! Ehe har jande pe amõ pandu ame'ẽ ta ke japutar ym apo. Ima'e panduha ke jande atu jahendu. A'erehe ame'ẽ panduha namõ jande riki japandu ta: “Katu ym nde. Nde eremanõ ta me'ẽ te'e” — aja tamũi ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Johu pu'am. Pe, amõ sawa'e koty a'eta oho. Pirat koty oho. Jesu ke ngã raho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","A'ep ehe har ngã je'ẽ je'ẽ hũ: —Jundéu awa ta ke a'e muka'u te'e hũ ixo rahã, peme'ẽ ke japyhyk. “Homa awa tama'e kapitã keruhũ pe tamatarer peme'ẽ ym” aja a'e pandu. “Ihẽ riki Kirisutu. Kapitã keruhũ ihẽ tĩ” aja a'e pandu. Aja muka'u te'e hũ ngã ke — aja Pirat pe ngã pandu naĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pirat pandu ipe: —Jundéu awa tama'e kapitã keruhũ nde my? — aja ipe. Jesu pandu: —A'e ihẽ — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pe, pa'ihu ta pe Pirat pandu. Heta ame'ẽ ta pe pandu tĩ: —Peme'ẽ sawa'e ke jajukwa rahã, katu ym tiki. Nixói te ma'e ka'u te'eha ma'eha ke ipe. Amahem ym ma'e ka'u te'eha ma'eha ke ipe — aja Pirat pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pe, ngã pandu pandu we hũ: —Ngã ke a'e mutyapu tyapu hũ. Mu'e ame'ẽ ke namõ muparahy ngã ke. Ngariréi ywy pe mu'e py. A'engi upa Jundéi ywy rupi mu'e tĩ. Apo se uwyr — aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","“Ngariréi ywy” aja Pirat hendu rahã, ngã pe pandu: —Peme'ẽ sawa'e ngariréi ywy pe har my? — aja Pirat. —A'e riki — aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ame'ẽ ywy pe har Jesu aja Pirat ukwa rahã, Ero koty Jesu ke a'e mondo. Arahã Jerusarẽ ok ta pe Ero ixo tĩ. Ero ngariréi ywy pe har tama'e kapitam. A'erehe Jesu rehe har a'e ukwa ta, aja Pirat putar tipe. Jesu katu my? Katu ym a'e my? Ame'ẽ ke Ero ukwa ta. (Katu ym rahã, Ero riki jukwaha ke pandu ta) aja Pirat putar tipe. A'erehe ixoty Pirat mondo. ");
INSERT INTO urbNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Pe, Jesu rehe usak rahã, hury katu Ero. Ehe har hendu. Yman usak tar katu ehe. Marã ka ym amõ ma'eha, ame'ẽ ke Jesu ma'e apo, ame'ẽ ke rehe usak tar katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pe, Jesu pe a'e pandu pandu hũ. Anĩ. Jesu pandu ym te ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","A'ep jundéu awa tama'e pa'i keruhũ pu'am. Moise je'ẽha mu'e ame'ẽ ta aja tĩ. Jesu rehe har ame'ẽ ta je'ẽ je'ẽ hũ. —Ma'e ka'u te'eha ke a'e ma'ema'e hũ — aja ame'ẽ ta je'ẽ te'e. ");
INSERT INTO urbNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Pe, Ero puka puka hũ ehe. Ima'e sonda ta aja tĩ. A'eta muhuxĩ a'e ke tĩ. Pe, ma'e mundeha katu te ame'ẽ ke ngã munde ehe. Kapitã keruhũma'e mundeha aja munde ehe. Aja puka puka hũ ehe. Pe, Pirat koty a'e ke Ero mujywyr mondo. ");
INSERT INTO urbNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Arahã Pirat ipy'a jywyr ehe, Ero rehe. Yman Pirat ruwajan aja Ero ixo. Apo ehe katu aja jywyr 'y. ");
INSERT INTO urbNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jundéu awa tama'e pa'ihu ta ke Pirat mujy'ar. Kapitã ta ke aja tĩ. Upa ngã ke aja tĩ. Mujy'ar tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pe, Pirat pandu: —Ihẽ pe peme'ẽ sawa'e ke perur. “Ngã ke a'e muka'u te'e hũ” aja ehe har pepandu. Pehẽ ndutar koty ehe har ihẽ ahendu katu. Nixói te ma'e ka'u te'eha ma'eha ipe. Ehe har peje'ẽ je'ẽ hũ pe'am, ame'ẽ ke nixói ehe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aja Ero ukwa katu tĩ. Nixói te ma'e ka'u te'eha ma'eha ipe. A'erehe jande koty Ero mujywyr muwyr tĩ. Nixói te ma'e ka'u te'eha ma'eha ipe, a'erehe jajukwa rahã, katu ym tiki. ");
INSERT INTO urbNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","A'erehe ihẽ je'ẽha rupi a'e ke amõ ta pirok ta. Pe, a'e ke ihẽ apoir ta — aja Pirat pandu. (Pirok rahã: “Amõ ma'e nde ereka'u te'eha ke ema'e ym” aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pasuko 'ar rahã, imi'u ke jundéu awa ta matyr. Arahã pame katu te kyndaha ngi sawa'e ke Pirat muhem ta me'ẽ te'e. ");
INSERT INTO urbNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pe, upa ngã je'ẽ hũ: —Anĩ. Jesu ke ejukwa! Mahamba ke emuhem jande pe! Mahamba ke epoir! — aja Pirat pe. ");
INSERT INTO urbNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Mahamba ke sonda ta kynda. Ok ta rupi ngã ke a'e riki mutyapu tyapu hũ. Arahã amõ ke a'e jukwa tĩ. A'erehe a'e ke sonda ta kynda raho. ");
INSERT INTO urbNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jesu ke Pirat poir tar katu, a'erehe heta ame'ẽ ta pe a'e pandu tĩ. —Jesu ke apoir ta — aja. ");
INSERT INTO urbNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Anĩ. Ngã je'ẽ hũ: —Myra ngã mupia ame'ẽ ke rehe ejukwa! Myra ngã mupia ame'ẽ ke rehe ejukwa! — aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pe, mahapyrihar Pirat pandu: —Ma'e ka'u te'eha ke a'e ma'e ym te. Nixói te ma'e ka'u te'eha ma'eha ipe. Amahem ym. A'erehe jukwa rahã, katu ym tiki. Ihẽ je'ẽha rupi a'e ke amõ ta pirok ta. Pe, a'e ke ihẽ apoir ta amondo — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Anĩ. Heta ame'ẽ ta hãtã te hũ pandu pandu u'am: —Myra ngã mupia ame'ẽ ke rehe Jesu ke ejukwa — aja hãtã pandu pandu hũ. Uhyk Pirat hendu! ");
INSERT INTO urbNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","A'erehe pandu: —Pehẽ pepandu ame'ẽ ke ihẽ ama'e ta apo — aja. ");
INSERT INTO urbNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pe, Jesu ke jukwa ta, ame'ẽ ta pe Pirat mondo. Aja ngã putar ame'ẽ ke a'e ma'e. Pe, amõ ke Pirat muhem, Mahamba ke. Ngã pandu ame'ẽ ke muhem tĩ. Kyndaha pe ame'ẽ ke amõ ta kynda raho ame'ẽ ke a'e. Ngã mutyapu tyapu rahã, amõ ke Mahamba jukwa tĩ. Ame'ẽ Mahamba ke Pirat muhem mondo, kyndaha ngi. Ame'ẽ ke poir. ");
INSERT INTO urbNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pe, Jesu ke sonda ta pyhyk raho. Oho ixo rahã, amõ awa ke rehe a'eta usak. Her Simã. Syre ok ta pe har ke a'e. Kupixa ngi a'e jywyr uwyr ixo. Ame'ẽ rehe sonda ta pyhyk. Pe, jixi'y 'ar pe myra ngã mupia ame'ẽ ke a'eta moĩ. Pandu ipe: —Jesu raikwer rupi ehupir eraho. Ima'e ke — aja Simã pe. ");
INSERT INTO urbNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Heta haikwer rupi ngã oho tĩ. Ame'ẽ ta namõ kũjã ta oho ixo tĩ. Jixi'u oho ixo tĩ. Ahem oho ixo tĩ. (Jesu manõ ta, aja ukwa, a'erehe jixi'u oho ixo.) ");
INSERT INTO urbNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ixoty Jesu uwak. Pandu: —Éi, kũjã ta! Jerusarẽ ok ta pe har ta ke pehẽ. Ihẽ rehe pejixi'u ym. Pehẽ atu pejixi'u pehẽ juehe. Pyraraha uhyk ta pehẽ rehe a'erehe pejixi'u pehẽ juehe. Pehẽ membyr ta rehe pejixi'u tĩ. Pyrara ta ame'ẽ ta, a'erehe pejixi'u tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ma'e 'ar ke uhyk ta. Arahã kuja upa ngã pandu ta: “Imembyr ym te ame'ẽ ta hury ixo. Pyraraha rehe imembyr usak ym ta. A'erehe hury ixo. Ipusu ngi imembyr muhem ym ame'ẽ ta aja tĩ. Hury ixo tĩ. Imembyr rehe usak katu, aja ym ame'ẽ ta aja tĩ. Hury ixo tĩ. Pyraraha rehe imembyr usak ym ta, a'erehe hury katu ixo.” ");
INSERT INTO urbNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Arahã ywy'ã keruhũ pe amõ ta pandu ta: “Jande ke ejupyk. Pahar ejukwa. Aja rahã, pyraraha rehe jasak ym ta” aja. Amõ ta ywy'ã pe: “Jande ke emukanim. Aja rahã, pyraraha rehe jasak ym ta” aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ma'e aka'u te'eha ke ihẽ ama'e ym te. Anĩ. Ihẽ ke amõ ta mupyrara ixo apo. Aja rahã, ihẽ 'ar koty te we pehẽ ke amõ ta mupyrara hũ ta. Ma'e peka'u te'eha ke pema'ema'e, a'erehe ihẽ 'ar koty te we pehẽ ke mupyrara hũ ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Amõ mokõi sawa'e ta ke sonda ta raho tĩ. Ma'e ka'u te'eha ma'ema'eha ta ke a'eta. Ame'ẽ mokõi Jesu namõ jukwa ta. ");
INSERT INTO urbNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pe, amõ renda pe uhyk oho. Henda rer: “Awa ãkã kangwer.” A'ep myra ngã mupia ame'ẽ ke rehe Jesu ke mujar mu'am. Mokõi ma'e ka'u te'eha ma'ema'eha ta ke mujar mu'am tĩ. Jesu jywa katu koty peteĩ mujar mu'am. Amõ ke ijywa'i koty aja tĩ. Mujar mu'am tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Pe, sonda ta rehe har Tupã pe Jesu pandu: —Papa! Peme'ẽ ta rehe nde py'a ke emujywyr. Ima'e ma'eha ke ukwa ym ha rupi ma'ema'e. A'erehe nde py'a emujywyr a'eta rehe — aja sonda ta rehe har a'e pandu. Pe, Jesuma'e mundeha ke sonda ta pyhyk pyhyk raho. Ita pinim ra'yr ke omombor. Amõ ombor, pe, pinĩha i'ar koty te we u'ar rahã, ame'ẽ riki mundeha ke pyhyk. Aja ima'e mundeha ke pyhyk pyhyk raho. ");
INSERT INTO urbNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","A'ep amõ ta usak usak u'am. Aja ixo rahã, jundéu awa tamũi ta puka puka hũ ehe. —Amõ ta ke a'e mukatu hũ! A'e riki Kirisutu rahã, mã peja pengi a'e wyjy uwyr. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e rahã, mã peja pengi a'e wyjy uwyr — aja puka puka hũ ngã. ");
INSERT INTO urbNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sonda ta puka puka hũ ehe tĩ. Ixoty a'eta oho. Pe, kawĩ iro ym te ame'ẽ ke me'ẽ tipe. Aja puka puka hũ ehe. Anĩ. U'u ym Jesu. ");
INSERT INTO urbNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Pandu ipe: —Nde riki jundéu awa tama'e kapitã keruhũ rahã, pengi ewyjy ejur. Pep nde erepyta rahã, nde eremanõ ta — aja puka puka hũ ehe. ");
INSERT INTO urbNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","I'ar pe kuja amõ mupinim: “Ko jundéu awa tama'e kapitã keruhũ” aja pinĩha moĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","A'ep ma'e ka'u te'eha ma'eha ke jixiko u'am tĩ. Peteĩ je'ẽ je'ẽ hũ ipe, Jesu pe. Kuja: —Nde riki Kirisutu. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke nde. Pengi ewyjy eho. Aja rahã, nde eremanõ ym ta. Jande ke emujy eraho tĩ. Aja rahã, jamanõ ym ta tĩ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Amõ ma'e ka'u te'eha ma'eha anĩ. Kuja pandu: —Mã! Peja ym epandu. Tupã ngi nde erekyje ym my? Ixoty nde py'a nde eremuruwak ta me'ẽ te'e. Jesu aja jande ke amõ ta jukwa u'am tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Jandema'e riki katu tiki. Ma'e jaka'u te'eha ke jama'ema'e, a'erehe jande ke amõ ta jukwa ta tĩ. Jesu anĩ. Nixói te ma'e ka'u te'eha ma'eha ipe — aja amõ jixiko u'am ame'ẽ pe pandu. Wajar pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pe, Jesu pe a'e pandu tĩ: —Jesu! Kapitã keruhũ aja nde erejywyr rahã, ihẽ rehe har ekwa ekwa katu exo — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesu pandu ipe: —Ko apandu nde pe. Apo ywa pe ihẽ namõ katuha renda pe nde erexo ta tĩ — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Warahy jandar tate rahã, ame'ẽ ywy rupi pytun oho. Warahy uwe riki. Aja te'e warahy ywa ku'ap ihon. ");
INSERT INTO urbNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tupã rehe ngã jumu'eha renda keruhũ pe kyndaha u'am. Pan janam hũ ke te'e mujã ame'ẽ ke ame'ẽ. Hukwen ke kynda u'am. Ame'ẽ riki ywate ngi owok riki. Pyter rupi owok oho. Iwyr rehe owokiha upa uhyk oho. (Aja rahã, Tupã koty ohoha apo katu, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Pe, hãtã Jesu pandu: —Papa! Ihẽ'ã ke eraho! — aja ipái pe. Upa pandu rahã, manõ. ");
INSERT INTO urbNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sonda tama'e kapitã upa ma'e ke rehe usak. Pe, Tupã rehe har katu pandu. Kuja: —Jetehar te ke! Katu ame'ẽ ke peme'ẽ sawa'e — aja Jesu rehe har pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Upa ma'e ke rehe amõ ta usak. A'ep jy'ar ame'ẽ ta usak. Upa usak rahã, hok pe jywyr oho. Pyaiha namõ ipixi'a ke mokõi ipo pe nupã nupã. (Aja pyaiha mujekwa.) Aja hok pe jywyr oho. ");
INSERT INTO urbNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesu rehe katu ame'ẽ ta upa ma'e ke rehe usak usak tĩ. Paite we ame'ẽ ta usak usak u'am. Kũjã ta usak usak u'am tĩ. Ame'ẽ ta Ngariréi ywy ngi inamõ uhyk uwyr ame'ẽ ta ke a'eta. ");
INSERT INTO urbNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Pe, amõ sawa'e ixo. Her Jose. Arimatéi ok ta pe har ke a'e. Ame'ẽ ok ta Jundéi ywy rehe ihĩ. Sawa'e katu ame'ẽ ke a'e. Katu ame'ẽ ke jõ a'e ma'ema'e. Jesu ke kapitã keruhũ aja Tupã mu'am, ame'ẽ rehe Jose jurujar katu. Ame'ẽ rehe a'e harõ ixo tĩ. A'erehe Tupã koty ipy'a ke a'e muruwak. Jesu jukwaha rehe har tamũi ta pandu pandu rahã, a'ep tamũi ta namõ Jose ixo tĩ. Anĩ. Jesu jukwaha ke a'e jõ putar ym. ");
INSERT INTO urbNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Apo Pirat pe pandu oho. —Kapitam! Jesu rete ke ihẽ aputar. (Amou ta araho) — aja Jose. ");
INSERT INTO urbNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","—Ere. Eraho — aja Pirat pandu. A'erehe hete ke Jose oho piam. Amõ ta pe a'e pandu: —Pemujy perur — aja Jose. Pe, mujy rahã, pan katu te ame'ẽ pe pukek. Pe, itakwar keruhũ rupi mou raho. Ame'ẽ ke amõ pykũi ame'ẽ ke. A'eramõ mou raho. ");
INSERT INTO urbNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Arahã séi ta séi ra. Jundéu awa tama'e putu'uha 'ar uhyk tate. (Putu'uha 'ar rahã, paraky ym te ta jundéu awa ta.) ");
INSERT INTO urbNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ngariréi ywy ngi Jesu namõ kũjã ta uhyk uwyr. Ame'ẽ ta Jose namõ usak oho tĩ. Itakwar keruhũ rehe a'eta usak tĩ. Jesu rete mouha rehe usak tĩ. Ma'e pihe katu ame'ẽ namõ hete ke kytyk ym, aja kũjã ta ukwa. ");
INSERT INTO urbNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pe, hok pe a'eta jywyr oho. Puhã pihe ame'ẽ ke a'eta matyr. Ma'e piheha ke matyr tĩ. Ame'ẽ ke Jesu rete rupi upa kytyk ta. (Aja manõ ame'ẽ rete rehe jundéu awa ta ma'eha ke.) Pe, jundéu awa tama'e putu'uha 'ar rahã, a'eta putu'u. Moise je'ẽha mujekwa aja a'eta ma'e. ");
INSERT INTO urbNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nomin pytuniwe te rahã, itakwar keruhũ pe kũjã ta oho. Puhã pihe ame'ẽ ke matyr. Ame'ẽ ke a'eta raho. ");
INSERT INTO urbNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Hukwen ngi ita kyndaha ke amõ mujere mu'am. Ame'ẽ ke rehe a'eta usak. ");
INSERT INTO urbNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","A'erehe ixe oho. Anĩ. Jesu rete ke rehe usak ym. Jesu riki jandema'e sawa'e te. Hete ke rehe kũjã ta usak ym. ");
INSERT INTO urbNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","A'ep a'eta pu'am u'am. Myja ym ukwa. Pe, pahar mokõi sawa'e ta uhem. Hake pu'am u'am. Ima'e mundeha hendy hendy hũ. ");
INSERT INTO urbNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kũjã ta jumukahem hũ a'eta ngi. Ywy koty te'e ma'ã. Sawa'e ta pandu: —Ixuwe katu ame'ẽ ke pekekar pexo tipe. Ame'ẽ ke kangwerupa rupi pekekar rahã, katu ym tiki. ");
INSERT INTO urbNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ko Jesu nixói te. Kwera katu uhem oho. Amukwehe Ngariréi ywy pe ixo rahã, pandu katu pehẽ pe. Ame'ẽ panduha rehe pekwa pekwa pe'am apo. ");
INSERT INTO urbNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Kuja: “Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Pesarahã! Sawa'e katu ym ame'ẽ ta pe ihẽ ke amõ raho ta kỹ. Pe, myra ngã mupia ame'ẽ ke rehe ihẽ ke amõ ta jukwa ta. Mokõi aker rahã, ihẽ akwera katu ta ahem tĩ” aja Jesu pandu — aja sawa'e ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Pe, Jesu panduha ke kũjã ta ukwa ukwa u'am tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pe, itakwar keruhũ ngi a'eta jywyr oho. Upa usak ame'ẽ ke jumu'eha ta pe a'eta pandu tipe, awa py peteĩ jumu'eha ta pe. Amõ ta namõ ixo, ame'ẽ ta pe pandu tipe tĩ. (Anĩ. Kũjã ta panduha rehe jurujar ym.) ");
INSERT INTO urbNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kuja kũjã ta rer. Ko Mari Mandare. Amõ Joa. Amõ Mari. Tian mãi a'e. Ame'ẽ ta namõ amõ kũjã ta ixo. Upa ame'ẽ ta riki Jesu mondo ame'ẽ ta pe pandu tipe. Upa usak ame'ẽ ke pandu tipe. ");
INSERT INTO urbNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Anĩ. Kũjã ta riki ka'u te'e, aja Jesu mondo ame'ẽ ta ukwaha naĩ. A'erehe kũjã panduha rehe jurujar ym. ");
INSERT INTO urbNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pe, Petu pu'am rahã, itakwar keruhũ pe usak ujan oho. Uhyk rahã, jumumbe ma'ã rahã, hete pukeka ke te'e usak. Ame'ẽ jõ usak. Hete nixói te. Pe, hok pe jywyr oho. Jupandu jupe: —Mã! My ihon my? — aja jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ame'ẽ 'ar rahã, mokõi sawa'e ta wata oho ixo. Jesu kotyhar ta ke ame'ẽ ta. Emau ok ta pe oho ixo. Jerusarẽ ok ta ngi ame'ẽ pepaite we. Awa py peteĩ kiro met tate pepaiteha. ");
INSERT INTO urbNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","15","Ame'ẽ mokõihar ta pandu pandu a'eta jupe. Jesu manõ, ame'ẽ rehe har pandu pandu a'eta jupe. Aja rahã, Jesu te'e hake uhem u'am. A'eta namõ a'e wata oho ixo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","A'eta usak ehe. Anĩ. Ehe har ukwa ym we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Pe, Jesu pandu: —Pehẽ pewata pexo rahã, ma'e pepandu pandu pehẽ jupe my? — aja sawa'e ta pe. A'eta pyta. Pyai u'am. ");
INSERT INTO urbNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Pe, mokõihar ngi peteĩ pandu. Her Kereo. Kuja: —Mã! Nde erekwa ym my? Jerusarẽ ok ta pe har ta ngi har ne jõ riki ma'e ke nde erekwa ym my? A'ep amõ amõ wera rahã, ma'e ixo ame'ẽ ke nde erekwa ym my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","A'e pandu: —Myja ame'ẽ my? — aja Jesu. A'eta pandu: —Jesu rehe har. Nasare ok ta pe har a'e. A'e pe ma'e uhyk ame'ẽ ke. A'e riki Tupã je'ẽha pandu ame'ẽ ke a'e. Pyrãtãha namõ ma'e katu ame'ẽ ke a'e ma'ema'e, aja upa ngã ukwa. Tupã aja tĩ. Ukwa katu tĩ. Jesu je'ẽha te reko, aja upa ngã ukwa katu tĩ. Ma'e ke pandu katu tĩ, aja upa ngã ukwa tĩ. Tupã aja tĩ. Ukwa katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","—Pirat pe a'e ke jandema'e pa'ihu ta raho. Tamũi ta aja tĩ. Raho tĩ. Jukwaha ke Pirat jõ pandu katu, a'erehe pa'ihu ta raho. Pe, myra ngã mupia ame'ẽ ke rehe a'e ke amõ ta jukwa. ");
INSERT INTO urbNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","A'e ke kapitã keruhũ aja Tupã mu'am ta, aja jakwaha naĩ. Pe, jundéu awa ta ke poir ta, aja jakwaha naĩ. Jande ruwajan ta ngi poir ta tipe. Anĩ riki. A'e manõ. (A'erehe jande ruwajan ta ngi poir ym.) Mokõi jaker apo. ");
INSERT INTO urbNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","—Jande ngi har kũjã ta muka'u te'e hũ jande ke ixo. Pytuniwe te rahã, itakwar keruhũ pe a'eta oho. ");
INSERT INTO urbNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jesu rete rehe usak oho tipe. Mahem ym. Jywyr oho rahã, a'eta pandu: “Tupã je'ẽha rahoha ta rehe jasak. ‘Jesu ixuwe katu’ aja jande pe a'eta pandu” aja kũjã ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","A'erehe itakwar keruhũ rehe amõ ta usak tipe oho tĩ. Kũjã ta pandu, aja a'eta usak tĩ. Usak ym ehe, Jesu rehe — aja mokõi sawa'e ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Pe, mokõi sawa'e ta pe Jesu pandu: —Mã! Pehẽ ãkã tiha we. Upa amõ ta pandu ame'ẽ ke rehe pejurujar ym. Tupã je'ẽha pandu ame'ẽ ke rehe pejurujar ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tupã muwyr ame'ẽ ke amõ ta mupyrara ta me'ẽ te'e. Pe, ma'e katu te ha ke Tupã me'ẽ ta ipe tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tupã je'ẽha rehe panduha ihĩ. Upa juehe har pandu ame'ẽ ke Jesu mujekwa. Mokõi sawa'e ta pe mujekwa. Yman Moise mupinim. Ame'ẽ rehe Jesu rehe har panduha ihĩ. Ame'ẽ ke upa mujekwa py. Yman Tupã je'ẽha ke pandu ame'ẽ ta mupinim tĩ. Ame'ẽ rehe Jesu rehe har panduha ihĩ tĩ. Ame'ẽ ke upa mujekwa tĩ. Juehe har mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ok ta pe a'eta oho ixo. Ame'ẽ pe uhyk tate rahã, Jesu pandu: “Asa we ta aho” aja. ");
INSERT INTO urbNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","—Anĩ. Se eker rĩ. Warahy ka'aruk te oho. Pytun tate — aja Jesu pe pandu hũ. A'erehe a'eta namõ pyta oho. ");
INSERT INTO urbNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","A'eta namõ wapyk. Ma'e u'uha renda pe wapyk. Mbeju ke pyhyk. Pe, Tupã pe pandu: “Ne jõ riki katu te me'ẽ ke. Jande mi'u ke jande pe nde eremuwyr katu” aja. Pe, mopok mopok. Ame'ẽ ke a'e me'ẽ mokõi sawa'e ta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Arahã ehe har Tupã mujekwa. Mokõi sawa'e ta pe mujekwa. Pe, mokõihar ukwa katu. “Ko Jesu” aja ukwa katu. Arahã pahar Jesu kanim oho. ");
INSERT INTO urbNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Pe, pandu a'eta jupe: —Pe rupi jande jajur rahã, Tupã je'ẽha ke mujekwa katu jande pe. Arahã jande rury katu te jande jaxo — aja a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Pahar a'eta pu'am. Pe, Jerusarẽ ok ta pe jywyr oho. A'ep jumu'eha ta rehe uhyk oho. Awa py peteĩ hetaha ta rehe uhyk oho. A'eta jy'ar uĩ. Heta amõ ta jy'ar uĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ame'ẽ ta pe mokõi sawa'e ta pandu: —A'e ty. Jandema'e sawa'e te kwera katu uhem riki. Simã usak ehe — aja uhyk ramõ ame'ẽ ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ame'ẽ ta pe mokõi sawa'e ta pandu pandu. Pe rupi oho ixo rahã, Jesu uhyk uwyr a'eta rehe. Ame'ẽ rehe har upa pandu pandu. Pe, mbeju ke mopok rahã, ehe har a'eta ukwa. Ame'ẽ rehe har upa pandu pandu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Upa ma'e ke mokõi sawa'e ta pandu pandu u'am rahã, pahar Jesu uhem u'am. Ame'ẽ ta pyter pe uhem u'am. Pe, a'eta pe pandu: —Mã peja pehẽ py'a ke Tupã muhury katu — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","A'eta mukahem te hũ ingi. Awa'ã rehe a'eta usak, aja ukwaha naĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pe, a'e pandu: —Pemukahem ym ihẽ ngi. “Awa ko my?” aja ym pepandu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ihẽ po rehe pesak katu. Ihẽ py rehe pesak katu tĩ. Itapywa rape rehe pesak. Ihẽ atu ko. Ihẽ rehe pehẽ po pemujar. Ihẽ pirer kohĩ. Ihẽ te ko. Pepyhyk katu ihẽ ke. Awa'ã aja ym ihẽ. Pesak katu — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Upa pandu rahã, a'eta pe ipo ke mujesak. Ipy ke mujesak tĩ. Itapywa rape ke mujesak tĩ. ");
INSERT INTO urbNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","A'eta jurujar ym we rĩ. “Mã!” aja a'eta. Hury katu te tĩ. Pe, a'eta pe Jesu pandu: —Pehẽ mi'u pehĩ my? — aja. ");
INSERT INTO urbNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Pira ka'ẽ ra'yr ke a'eta me'ẽ ipe. ");
INSERT INTO urbNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ame'ẽ ke pyhyk rahã, a'eta ruwa koty u'u. (Aja rahã, Jesu te aja a'eta ukwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pe, a'eta pe Jesu pandu: —Pehẽ namõ ihẽ axo rahã, ma'e ke ihẽ apandu pehẽ pe. Kuja. Ihẽ rehe har Moise mupinim. Aja upa ihẽ rehe uhyk ta me'ẽ te'e. Tupã je'ẽha pandu ame'ẽ ta mupinim tĩ. Upa ihẽ rehe har mupinim tĩ. Aja upa ihẽ rehe uhyk ta me'ẽ te'e tĩ. Saumo rehe amõ panduha ihĩ. Aja upa ihẽ rehe uhyk ta me'ẽ te'e tĩ — aja a'eta pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pe, Tupã je'ẽha rehe panduha ihĩ. Ame'ẽ ke upa katu te Jesu mujekwa katu. ");
INSERT INTO urbNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","A'e pandu: —Kuja amõ ta mupinim. Kirisutu ke amõ ta mupyrara hũ ta me'ẽ te'e. Pe, jukwa. Mokõi ukwer rahã, a'e ke Tupã mukwera katu ta muhem. ");
INSERT INTO urbNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Pe, upa awa ta pe myrandu ke pepandu pandu ta me'ẽ te'e. Kuja amõ ta pe pepandu: “Ma'e peka'u te'eha pema'ema'eha ke pehijar. Pe, pehẽ py'a ke Tupã koty pemuruwak pemondo. Aja rahã, pehẽ rehe Tupã ipy'a jywyr ta” aja amõ ta pe pepandu. Ihẽ je'ẽha rupi pepandu peho. Jerusarẽ ok ta pe pepandu py. Pe, amõ amõ ok ta pe pepandu peho. ");
INSERT INTO urbNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Upa pesak, ame'ẽ rehe har pepandu pandu katu. ");
INSERT INTO urbNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Tupã'ã ke pehẽ pe ihẽ amondo ta” aja ihẽ pái pandu katu pehẽ pe. Ame'ẽ ke ihẽ riki pehẽ pe amuwyr ta. Pesarahã! Pehẽ pe pyrãtãha ke Tupã muwyr ta. Ame'ẽ rehe peharõ pexo rahã, se pepyta we rĩ. Jerusarẽ ok ta pe pepyta we rĩ — aja Jesu pandu jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pe, Jerusarẽ ok ta ngi uhem oho. Inamõ ixo ame'ẽ ta ke a'e raho. Mbeta ok ta pe uhyk tate. A'ep pyta u'am. A'eta 'ar pe mokõi ijywa ke mupuku. Pe, a'e pandu: —Mã peja pehẽ rehe Tupã usak katu — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","A'e pandu u'am rahã, a'eta ngi oho. Ywa pe a'e ke Tupã mujywyr raho. ");
INSERT INTO urbNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pe, ipy'a ke a'eta moĩ moĩ ehe, Jesu rehe. Pe, Jerusarẽ ok ta pe jywyr oho. A'eta hury katu ixo. ");
INSERT INTO urbNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tupã rehe ngã jumu'eha renda keruhũ pe a'eta ohoho. Tupã rehe har katu a'eta pandu. —Ne jõ riki katu te me'ẽ ke — aja ngã pandu. Upa.");
INSERT INTO urbNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kome'ẽ ywy keruhũ nixói te rahã: “Je'ẽha” pete'e ixo. (Jesu Kirisutu a'e.) Tupã namõ a'e ixo. Tupã riki a'e tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ma'e ke nixói te rahã, Je'ẽha Tupã namõ ixo. ");
INSERT INTO urbNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Upa katu te ma'e ke a'e mujã. A'e mujã ym rahã, nixói te ta ma'e ke apo. ");
INSERT INTO urbNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Uhã te hũ ame'ẽ ke a'e. Ngã pe uhãha ke Je'ẽha me'ẽ. Weraha ngã pe a'e werur. (Aja rahã, Tupã rehe har ngã pe mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Pytuniha ke muweraha muwera katu. Ame'ẽ ke marã ka ym pytuniha muweha. (Aja rahã, Tupã rehe ipy'a ym ame'ẽ ta pe ma'e ke mujekwa. Tupã rehe har mujekwa. Pe, ame'ẽ ukwa katuha ke Tupã rehe ipy'a ym ame'ẽ ta marã ka ym mukanĩha.) ");
INSERT INTO urbNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ko amõ sawa'e ke Tupã muwyr. Myrandu panduha ke a'e. Her Juã. ");
INSERT INTO urbNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ngã pe ma'e ke a'e pandu uwyr. Weraha rehe har a'e pandu uwyr. Weraha aja Jesu Kirisutu a'e. Pe, ame'ẽ myrandu rehe heta ngã hendu. Aja rahã ame'ẽ rehe a'eta jurujar katu my. ");
INSERT INTO urbNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Weraha rehe har Juã pandu uwyr. A'e atu weraha aja ym. ");
INSERT INTO urbNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ko riki weraha te. Jesu Kirisutu a'e. Kome'ẽ ywy keruhũ pe a'e uwyr. Upa awa ta pe Tupã rehe har a'e mujekwa. (A'erehe weraha aja a'e.) ");
INSERT INTO urbNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Je'ẽha kome'ẽ ywy keruhũ pe ixo. Ehe har kome'ẽ ywy keruhũ pe har ta ukwa ym. A'e je'ẽha rupi kome'ẽ ywy keruhũ Tupã mujã. ");
INSERT INTO urbNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ima'e ywy pe a'e uwyr. Anĩ. A'e ke a'ep pe har ta putar ym. (Jundéu awa ta putar ym.) ");
INSERT INTO urbNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ame'ẽ ta ngi har amõ amõ ta putar katu. A'erehe jurujar katu ehe tĩ. A'erehe Tupã ra'yr ta aja ame'ẽ ta ke Tupã muruwak. ");
INSERT INTO urbNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tupã ra'yr ta ke a'eta apo 'y. Imãi pusu ngi u'ar, a'erehe Tupã ra'yr ta a'eta my? Anĩ, aja ym. Sawa'e ta putar, a'erehe Tupã ra'yr ta ke a'eta my? Anĩ, aja ym tĩ. Tupã jõ putar, a'erehe Tupã ra'yr ta ke a'eta. “Ihẽ ra'yr ta pehẽ” aja a'e mu'am. ");
INSERT INTO urbNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Her Je'ẽha. A'e uwyr. Awa aja uwyr. Jande namõ a'e ixo. Ngã rehe a'e atu ipy'a katu te. Jetehar Tupã rehe har a'e pandu. Marã ka ym amõ ma'eha, ame'ẽ ke a'e ma'ema'e katu. Aja ima'e pyrãtãha ke jasak. Ame'ẽ pyrãtãha ke ipái muwyr ipe. Ta'yr peteĩhar ke a'e, a'erehe ipái muwyr ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ehe har Juã pandu. Kuja: —Amukwehe we ehe har ihẽ apandu: “Ihẽ raikwer rupi a'e uwyr ta. Ihẽ nixói rahã, pete'e a'e ixo. A'erehe ihẽ 'ar koty te we a'e katuha” — aja Juã pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ngã rehe a'e atu ipy'a katu te. A'erehe jande rehe a'e usak katu. Jete. Amõ amõ we jande rehe a'e usak katu. ");
INSERT INTO urbNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tupã je'ẽha ke Moise mujekwa. (Ame'ẽ ke Moise je'ẽha aja jakwa.) Myja katu ame'ẽ ke amõ ma'ema'e my? Ma'e riki katu ym. Ame'ẽ jõ Moise je'ẽha mujekwa. Jesu anĩ. Ngã rehe Tupã atu ipy'a katu, ame'ẽ ke Jesu Kirisutu mujekwa. Jetehar Tupã rehe har a'e mujekwa tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tupã rehe usak ym te awa. Ta'yr riki ehe har mujekwa ngã pe. A'erehe amõ usak ehe rahã, Tupã rehe usak tĩ, ame'ẽja saka. Ta'yr peteĩhar ke a'e. Tupã a'e tĩ. Ipái ipy'a katu ehe ame'ẽ ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusarẽ ok ta pe jundéu awa tama'e kapitã ta ixo. Amõ ta ke Juã koty a'eta mondo tĩ. Pa'i ta ke mondo. Rewi rainõ ta ke mondo tĩ. Sonda aja a'eta. Myja me'ẽ sawa'e a'e my, ame'ẽ ke a'eta ukwa tar katu te. Kuja ame'ẽ ta pandu oho ipe: —Awa nde? Kirisutu nde my? Kapitã keruhũ aja Tupã mu'am ame'ẽ ke nde — aja Juã mujahukiha pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Pe, a'e pandu katu te: —Anĩ. Kirisutu ym ihẽ — aja a'eta pe. ");
INSERT INTO urbNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","A'eta pandu: —Aja rahã, awa nde? Eri nde my? Ywa ngi Tupã muwyr ame'ẽ ke — aja ipe. —Anĩ. Ihẽ Eri ym tĩ — aja Juã pandu. A'eta pandu ipe tĩ: —Amõ Tupã je'ẽha pandu ame'ẽ ke rehe jande jaharõ jaxo. Ame'ẽ ke nde my? — aja ipe. Juã pandu: —Anĩ. Ame'ẽ ym ihẽ tĩ — aja a'eta pe. ");
INSERT INTO urbNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Pe, a'eta pandu tĩ: —Awa nde my? Epandu katu jande pe. Ko nde koty jande ke amõ ta muwyr. Ame'ẽ ta pe nde rehe har japandu ta me'ẽ te'e. Myja nde juehe har nde erepandu my? — aja Juã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Isai riki yman Tupã je'ẽha pandu ame'ẽ ke. Isaima'e panduha ke Juã pandu. Kuja a'e pandu: —Kuja ihẽ. “Awa nixói te ame'ẽ pe amõ pandu u'am. Ngã pe pandu u'am: ‘Jandema'e sawa'e te rape ke emutatambyk 'y. Ame'ẽ rupi a'e uwyr ta’ aja Isai mupinim.” —Ihẽ riki ame'ẽ awa nixói te ame'ẽ pe apandu a'am — aja Juã pandu. (Hape ke mutatambyk rahã, ngã py'a Tupã koty muruwak. Aja rahã, jandema'e sawa'e te uwyr rahã, hendu katu ta ehe, aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Juã namõ pandu ixo ame'ẽ ta ke amõ ta mondo. Parise ta riki mondo. ");
INSERT INTO urbNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Juã pe ame'ẽ ta pandu: —Kirisutu ym nde. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke aja ym nde. Eri ym nde. Amõ Tupã je'ẽha pandu ame'ẽ ke rehe jaharõ jaxo. Ame'ẽ ym nde. Aja rahã, ma'erehe ngã ke nde eremujahuk my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","A'e pandu: —Y pe ngã ke ihẽ amujahuk. (Aja rahã, Tupã koty ipy'a ke ngã muruwak, aja mujekwa.) Esarahã! A'e riki pehẽ namõ ixo tipe. (Pehendu ym ehe.) ");
INSERT INTO urbNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ihẽ raikwer rupi a'e uwyr ta. Ihẽ 'ar koty te we a'e katuha. A'erehe ima'e miasu aja ihẽ axo rahã, ihẽ katu ym ihẽ jupe ihẽ — aja Juã pandu ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Upa aja me'ẽ Juã namõ amõ ta pandu. Mbeta ok ta pe pandu. Ame'ẽ ok ta y ruwái koty ihĩ, Jondã ruwái koty. A'ep ngã ke Juã mujahuk u'am. (Mujahuk rahã, Tupã koty ipy'a muruwak, aja ngã mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ku'ẽ rahã Juã koty Jesu uwyr ixo. Juã usak ehe rahã, a'e pandu: —Ko riki Tupãma'e arapuharan ra'yr aja a'e. Ma'e ka'u te'eha ke kome'ẽ ywy keruhũ pe har ta ma'ema'e. Ame'ẽ ke rehe a'e muhepy ta. A'erehe Tupãma'e arapuharan ra'yr aja a'e. Tupã muwyr ame'ẽ ke a'e. (Kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e.) ");
INSERT INTO urbNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kwehe ehe har ihẽ apandu: “Ihẽ raikwer rupi amõ uwyr ta. Ihẽ nixói rahã, pete'e a'e ixo. A'erehe ihẽ 'ar koty te we a'e katuha” aja ihẽ apandu kwehe. ");
INSERT INTO urbNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ihẽ aja tĩ. Ehe har ihẽ akwa ym we rĩ. (Ko Kirisutu. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e) aja akwa ym we rĩ. Pe, jundéu awa ta pe ehe har ihẽ amujekwa ta. A'erehe y pe ihẽ amujahuk ngã ke, aja rahã, ngã ipy'a ke Tupã koty muruwak aja mujekwa — aja Juã pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","34","Amõ we Juã mujekwa. Ma'e a'e usak ame'ẽ ke a'e pandu ngã pe tĩ. Kuja a'e pandu: —Ko Kirisutu. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke, aja ihẽ akwa ym we rĩ. Pe, Tupã'ã rehe ihẽ asak. Pykahuran aja ihẽ asak. Ywa ngi wyjy uwyr ehe, Jesu rehe. Pe, Tupã pandu ihẽ pe: “Y pe ngã ke emujahuk eho” aja. A'e riki ihẽ pe mujekwa tĩ: “Sawa'e rehe ihẽ'ã wyjy ta uwyr. Ame'ẽ ke rehe nde eresak ta. A'e riki ihẽ'ã namõ ngã ke mujahuk ta” aja Tupã mujekwa ihẽ pe. Tupã'ã wyjy uwyr ehe tĩ. Aja ihẽ asak 'y. A'erehe ihẽ apandu pehẽ pe. Jesu riki Tupã ra'yr — aja Juã pandu. (“Tupã'ã namõ mujahuk” aja pandu rahã: “Ngã py'a rehe Tupã'ã ke muwyr ta” aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ku'ẽ rahã a'ep Juã ixo tĩ. Mokõi sawa'e ta namõ. Inamõ jumu'e ixo ame'ẽ ta ke a'eta. ");
INSERT INTO urbNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Pe, Jesu asa oho ixo rahã, Juã usak ehe. Pandu: —Peme'ẽ Tupãma'e arapuharan ra'yr aja a'e. (Kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e) — aja Juã pandu. (Yman arapuharan ra'yr ke jundéu awa ta jukwa rahã, ma'e ka'u te'eha ma'ema'eha ke rehe muhepy aja jundéu awa ta ukwa. Aja Jesu a'e tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ame'ẽ ke rehe mokõi jumu'eha ta hendu rahã, Jesu raikwer rupi a'eta oho. (Juã ke a'eta hijar.) ");
INSERT INTO urbNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Pe, ixoty Jesu uwak. Mokõi sawa'e ta haikwer rupi uwyr. Ame'ẽ ta rehe a'e usak rahã, a'eta pe pandu: —My pehẽ peho ta my? — aja Jesu. —Sawa'e! Ngã mu'eha nde. My nde ereker ta my? — aja sawa'e ta ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesu pandu: —Pesak pejur — aja sawa'e ta pe. A'erehe inamõ a'eta oho. Jesu ukweriha renda rehe usak oho. Warahy ywa ku'ap ihon rahã usak oho. Pe, inamõ a'eta pyta. Aja te'e pytun oho. ");
INSERT INTO urbNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kwehe Juã pandu ame'ẽ ke rehe mokõi sawa'e ta hendu. Pe, Jesu namõ oho. Andere riki ame'ẽ mokõi ngi har peteĩ. Simã Petu mu a'e. ");
INSERT INTO urbNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Pe, pahar Andere oho. Imu ke mahem oho, Simã ke. Pe, Andere pandu ipe: —Kirisutu rehe asak — aja Simã pe. (“Kirisutu” aja pandu rahã: “Kapitã keruhũ” aja Tupã mu'am ame'ẽ ke a'e aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pe, Simã ke a'e muhyk werur ehe, Jesu rehe. Simã rehe a'e usak rahã, pandu ipe: —Nde riki Simã. Juã ra'yr nde. Apo nde rer: “Sepa” aja tĩ — aja Jesu ipe. “Sepa” aja her rahã: “Petu” aja tĩ. “Sepa” aja rahã: “Ita ke” aja ngã ukwa. ");
INSERT INTO urbNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ku'ẽ rahã Jesu jupandu jupe: —Ngariréi ywy pe ihẽ aho ta — aja jupe. Pe, oho ixo rahã, Siri rehe a'e usak. Pandu ipe: —Ihẽ namõ ejumu'e eho — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Siri riki Mesái ok ta pe har ke a'e. Andere aja tĩ. Petu aja tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pe, Natanae ke Siri mahem oho. Pandu ipe: —Kirisutu rehe asak. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e. Ehe har paper rehe Moise mupinim. “Moise je'ẽha ke” aja jakwa, ame'ẽ rehe mupinim. Sawa'e rehe har a'e mupinim. Amõ ta mupinim tĩ. Sawa'e rehe har Tupã je'ẽha pandu ame'ẽ ta mupinim tĩ. Ame'ẽ sawa'e rehe ihẽ asak. A'e riki Jesu. Jose ra'yr a'e. Nasare ok ta pe har a'e — aja pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—Mã! Ame'ẽ ok ta ngi katu ame'ẽ ke uwyr ym — aja Natanae pandu naĩ. Siri pandu: —Esak ejurahã! — aja Natanae pe. Pe, Natanae oho inamõ. ");
INSERT INTO urbNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Pe, Jesu rehe Natanae uhyk tate rahã, Jesu usak ehe. Pe, ehe har a'e pandu: —Peme'ẽ riki jundéu awa te. Amõ ta ke muka'u te'e ym ame'ẽ ke a'e — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Pe, Natanae pandu ipe: —Ihẽ rehe nde eresak ramõ te. Myja ihẽ rehe har nde erekwa katu my? — aja Jesu pe. A'e pandu: —Siri nde pe pukái ym rahã we, nde rehe har ihẽ akwa katu. Ma'eywa'y wyr pe nde ereĩ rahã, ihẽ akwa katu, sik'y wyr pe — aja Natanae pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ame'ẽ ke rehe hendu rahã, Natanae pandu: —Sawa'e! Ngã mu'eha nde. Mã! Upa nde erekwa. Tupã ra'yr nde. Jundéu awa tama'e kapitã keruhũ nde. Jande jaharõ jaxo ame'ẽ ke nde — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Pe, a'e pandu: —Sik'y wyr pe nde ereĩ rahã, nde rehe har ihẽ akwa katu. Aja nde pe ihẽ apandu. A'erehe ihẽ rehe nde erejurujar katu. Amõ we ma'e ke rehe nde eresak ta. Marã ka ym amõ ma'eha, ame'ẽ ke ihẽ ama'ema'e ta. Ame'ẽ ke rehe nde eresak ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Pesarahã! Ywa pirar, aja nde eresak ta tĩ. Pe, Tupã je'ẽha rahoha ta rehe pesak ta tĩ. Awa ihẽ tĩ. Tupã je'ẽha rupi ihẽ ajur. Ihẽ rehe a'eta wyjy ta uwyr. Jupir jupir oho tĩ. Ame'ẽ ke rehe pesak ta kỹ — aja Jesu pandu ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mokõi ukwer rahã, amõ ok ta pe amõ sawa'e jumendar. Ok ta rer Kana. Ame'ẽ ok ta Ngariréi ywy rehe ihĩ. A'ep Jesu mãi ixo. ");
INSERT INTO urbNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesu pe amõ pandu. Jumu'eha ta pe tĩ: —Jumendariha rehe pesak pejur tĩ — aja. A'erehe a'ep a'eta ixo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pe, kawĩ ke ngã upa u'u rahã, Jesu pe imãi pandu: —Kawĩ upa riki — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesu pandu: —Mãi! Anĩ we rĩ. Ihẽ akwa ta kỹ. Ihẽ ama'eha angaha ke rehe uhyk ym we rĩ — aja Jesu ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pe, parakyha ta pe imãi pandu: —A'e pandu ame'ẽ ke pema'e katu — aja. ");
INSERT INTO urbNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","A'ep kamuxĩhu i'ãi. Tiha ame'ẽ ke. Kuja, 100 rit tihaha. Awa po wajar peteĩ hetaha kamuxĩ i'ãi. Ita ke te'e ngã mujã ame'ẽ ke. Y ke amõ purakar ipe. Ame'ẽ pe jundéu awa ta jukutuk kutuk. Aja te'eha. (Aja rahã, ipy'a juhyk aja ixo aja jundéu awa ta ukwaha jupe.) ");
INSERT INTO urbNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Pe, parakyha ta pe Jesu pandu: —Peme'ẽ kamuxĩhu ke pemutyryhem. Y ke te'e pemutyryhem — aja. Pe, a'eta mutyryhem te. Hukwen rake rupi ihon u'am. ");
INSERT INTO urbNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","A'e pandu tĩ: —Apo y ke pejo'ok 'y. Ame'ẽ ke ngã mi'u matyrihama'e kapitã pe peraho — aja parakyha ta pe Jesu pandu. A'eta raho ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pe, me'ẽ ipe. Pe, a'e u'u. Kawĩ riki. Y ke te'e kawĩ wan uwak oho. (Pyrãtãha namõ Jesu muruwak.) My ngi kawĩ werur my? Ame'ẽ ke kapitã ukwa ym. Parakyha ta jõ ukwa katu. A'eta riki y ke jo'ok. Pe, amõ pe kapitã pandu: —Se sawa'e jumendar ame'ẽ ke emuhyk — aja amõ pe. Pe, sawa'e uhyk. ");
INSERT INTO urbNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Kapitã pandu ipe: —Amõ ta kawĩ iro ame'ẽ ke me'ẽ me'ẽ py. Pe, ngã mi'u matyriha rehe uhyk uwyr ame'ẽ ta u'u hũ rahã, pe, iro ym ame'ẽ ke me'ẽ me'ẽ. Nde anĩ. Jande ja'u we hũ, iro ym ame'ẽ ke. A'eramõ kawĩ iro te ame'ẽ ke jande pe amõ me'ẽ me'ẽ — aja kapitã pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ame'ẽ ok ta pe ma'e katu ame'ẽ ke Jesu ma'e py. Kana ok ta pe. A'ep ima'e pyrãtãha ke a'e mujesak py amõ ta pe. A'erehe inamõ jumu'e ixo ame'ẽ ta jurujar katu ehe. (Kirisutu a'e. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e, aja a'eta ukwa katu.) Kana ok ta riki Ngariréi ywy rehe ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ame'ẽ upa rahã, amõ ok ta pe Jesu oho. Kapana'ũ ok ta pe oho. Imãi oho tĩ. Imu ta oho tĩ. Jumu'eha ta oho tĩ. A'ep heta ym ukwer. ");
INSERT INTO urbNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ma'e huryha ke rehe uhyk tate. Her Pasuko. Arahã jundéu awa ta imi'u matyr. (Aja yman te Eji ywy ngi jundéu awa ta ke Tupã muhem muwyr. Ame'ẽ ke ukwa ukwa u'am.) Ame'ẽ Pasuko weraha rehe uhyk tate, a'erehe Jerusarẽ ok ta pe Jesu oho. ");
INSERT INTO urbNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pe, Tupã rehe ngã jumu'eha renda keruhũ pe a'e oho. A'ep amõ sawa'e ta rehe a'e usak. Amõ ta tapi'iruhu ta ke muhepy hepy u'am tĩ. Tupã rehe ipy'a ngã moĩ rahã, ame'ẽ ke ngã jukwa. Amõ ta arapuharan ta ke muhepy hepy u'am tĩ. Tupã rehe ipy'a ke ngã moĩ rahã, ame'ẽ ke jukwa tĩ. Pykahuran ta aja tĩ. Muhepy tĩ. Amõ ywy ngi amõ ta uwyr. Amõ koty tamatarer ke ame'ẽ ta werur. Ame'ẽ ke Jerusarẽ ok ta pe har tama'e tamatarer ke muruwak ame'ẽ ta pehĩ tĩ. Tamatarer muruwak ame'ẽ ta ke a'eta. Myrape rake wapyk uĩ. Upa ame'ẽ ta rehe Jesu usak. ");
INSERT INTO urbNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pe, tupaham pe nupãha ke a'e puwan. Ame'ẽ pe upa ngã rymba ke a'e muhem mondo. Jumu'eha renda keruhũ ngi muhem mondo. Tapi'iruhu ta ke aja tĩ. Arapuharan ta aja tĩ. Muhem mondo tĩ. Myrape a'e mujere tĩ. Tamatarer muruwakiha tama'e ke. Tamatarer ke upa a'e ombor muhãi. ");
INSERT INTO urbNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pykahuran ta ke muhepy ame'ẽ ta pe a'e pandu: —Sengi upa pemuhem peraho! Ko riki ihẽ pái rok. Ame'ẽ ke muhepyha renda wan pemuruwak. Katu ym. Peho! — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ame'ẽ ke rehe jumu'eha ta hendu rahã, kuja ukwa ukwa u'am. Tupã je'ẽha rehe panduha amõ mupinim. Ame'ẽ ke ukwa ukwa u'am. Kuja: “Tupã! Ko riki nde rok. A'ep nde rehe ngã py'a ke ngã moĩ moĩ katu. Ame'ẽ ke jõ ihẽ aputar katu te.” Ame'ẽ panduha ke jumu'eha ta ukwa ukwa u'am. ");
INSERT INTO urbNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pe, Jesu pe amõ ta pandu uwyr. Jundéu awa tama'e kapitã ta pandu uwyr: —Awa je'ẽha rupi ngã ke nde eremuhem eremondo my? Marã ka ym amõ ma'eha, ame'ẽ ke ema'ema'e katu apo. Jasak ta. Aja rahã, nde je'ẽha rupi ngã ke nde eremuhem eremondo katu, aja jakwa katu ta tĩ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","A'e pandu: —Kome'ẽ Tupã rehe ngã jumu'eha renda keruhũ ke upa pemai. Pe, mokõi aker rahã, amõ pyahu ame'ẽ ke ihẽ amujã ta tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","A'eta pandu: —Mã! Mokõi nde ereker rahã, amõ nde eremujã ta my? Marã ka ym nde eremujãha. Yman te kome'ẽ jumu'eha renda keruhũ ngã mujã mujã ixo. Heta te hũ warahy 'ar rahã, mujã mujã ixo. Kuja, 46 warahy 'ar rahã, mujã mujã ixo — aja ngã pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Anĩ. Ame'ẽ jumu'eha renda keruhũ rehe har Jesu pandu ym. Juehe har a'e pandu. (“Mai” aja rahã: “Jukwa” aja riki. Mokõi ukwer rahã, amõ jumu'eha renda keruhũ mujã ta, aja pandu rahã, mokõi ukwer rahã, manõha ngi a'e ke Tupã mukwera katu ta muhem, aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","A'erehe manõha ngi a'e kwera katu uhem rahã, pe, ame'ẽ panduha rehe jumu'eha ta ukwa ukwa ixo. Pe, Tupã je'ẽha rehe panduha ihĩ, ame'ẽ riki jetehar te ke, aja a'eta ukwa katu. Jesu pandu ame'ẽ ke rehe a'eta jurujar katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pasuko 'ar rahã, Jerusarẽ ok ta pe Jesu ixo. Marã ka ym amõ ma'eha, ame'ẽ ke Jesu ma'ema'e. Ame'ẽ ke mujesak jesak hũ ngã pe u'am. Ame'ẽ ke rehe heta ngã usak, a'erehe: “Ko Kirisutu. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e” aja a'eta ukwa katu. ");
INSERT INTO urbNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesu anĩ. Ngã rehe har a'e ukwa katu. Pahar amõ koty ngã ukwa ta, aja Jesu ukwa katu. A'erehe jurujar ym ngã rehe. Ma'e ke rehe usak rahã jõ, ngã jurujar katu ehe, aja Jesu ukwa katu. A'erehe jurujar ym ngã rehe a'e. ");
INSERT INTO urbNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Marã ka ym ngã rehe har amõ panduha ipe. Upa a'e ukwa katu. Ipy'a pe ma'e ke amõ ukwa ukwa ixo, ame'ẽ ke a'e atu ukwa katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ko amõ sawa'e ixo. Her Nikonde. Jundéu awa tama'e kapitã a'e. Parise kotyhar ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Amõ pytun rahã, Jesu rehe a'e usak uwyr. Pandu ipe: —Sawa'e! Ngã mu'eha nde. Nde ke Tupã muwyr, a'erehe ehe har jande ke nde eremu'e katu. Aja jakwa katu. Ne namõ Tupã ixo, a'erehe marã ka ym amõ ma'eha, ame'ẽ ke nde erema'ema'e katu. Pyrãtã te ha namõ nde erema'ema'e katu. A'erehe nde ke Tupã muwyr aja ihẽ akwa katu tĩ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","A'e pandu: —Esarahã! Mokõihar amõ uhem ym rahã, Tupã ixo ame'ẽ pe marã ka ym ohoha — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Pe, Nikonde pandu: —Mã! Marã ka ym. Tamũi rahã, mokõihar uhem ym awa. Marã ka ym mokõihar imãi pusu pe ohoha. Pe, marã ka ym mokõihar uhemiha — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesu pandu: —Esarahã! Imãi pusu ngi uhem rahã, awa te'e a'e. Amõ we tĩ. Tupã'ã je'ẽha rupi uhem rahã, Tupã ra'yr a'e. Aja ym rahã, Tupã ixo ame'ẽ pe marã ka ym ohoha. ");
INSERT INTO urbNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Imãi pusu ngi uhem rahã, awa te'e a'e. Tupã'ã je'ẽha rupi uhem rahã, Tupã ra'yr a'e. ");
INSERT INTO urbNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Mokõihar pehem ta me'ẽ te'e” aja ihẽ apandu nde pe. “Mã! Marã ka ym” aja ym epandu. (Ame'ẽ ke nde erekwa ym my? Esarahã! Amõ we nde erekwa ym ame'ẽ ke pehĩ. Ywytu ke.) ");
INSERT INTO urbNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Amõ koty koty ngi ywytu jupeju uwyr. Tyapuha nde erehendu. My ngi tur my? My ihon ta my? Ame'ẽ ke nde erekwa ym. Pehĩ. Ame'ẽ ke jõ nde erekwa katu. Tupã'ã je'ẽha rupi uhem rahã, ame'ẽja saka tĩ. Nde erekwa ym tĩ. Tupã ra'yr, aja jõ nde erekwa — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—Myja puki? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","A'e pandu: —Jundéu awa ta ke nde eremu'e tĩ. Mu'eha katu ame'ẽ ke nde. Mã! Ihẽ apandu ame'ẽ ke nde erekwa ym we rĩ. Jande jakwa katu, ame'ẽ rehe har japandu pandu katu. ");
INSERT INTO urbNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Esarahã! Ma'e jasak ame'ẽ rehe har japandu katu tĩ. Pe, jande japandu ame'ẽ rehe har pekwa ym. Kapitã ta riki pehẽ. Pekwa ym rĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ma'e ke kome'ẽ ywy keruhũ pe ihĩ. Ame'ẽ rehe har ihẽ apandu rahã, pejurujar ym. Pe, ywa pe ma'e ke ihĩ. Ame'ẽ rehe har ihẽ apandu rahã, marã ka ym pejurujariha ehe. ");
INSERT INTO urbNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ma'e ke ywa pe ihĩ. Ame'ẽ rehe har amõ ukwa ta oho my? Anĩ. Aja me'ẽ ke nixói. Oho ym awa. Ihẽ jõ akwa katu. Awa ihẽ tĩ. Tupã je'ẽha rupi ihẽ ajur. A'erehe akwa katu. ");
INSERT INTO urbNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","—Awa nixói te ame'ẽ pe Moise ixo rahã, mbói'ã a'e mujar mu'am. Myra rehe mujar mu'am. Aja ihẽ ke amõ ta mujar ta mu'am tĩ. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Myra ngã mupia ame'ẽ ke rehe mujar ta mu'am tĩ. A'erehe ihẽ rehe upa ngã jurujar katu rahã, ame'ẽ ta ke Tupã muhã katu ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kome'ẽ ywy keruhũ pe har ta rehe Tupã ipy'a katu te hũ. A'erehe Ta'yr ke a'e muwyr. Ta'yr peteĩ har ke muwyr. A'erehe amõ jurujar katu ehe rahã, mupyraraha renda pe oho ym te ta. Tupã namõ ixo katu ta. ");
INSERT INTO urbNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kome'ẽ ywy keruhũ pe Ta'yr ke Tupã muwyr. Kome'ẽ ywy keruhũ pe har ta ke Ta'yr muhã katu ta uwyr. A'eta ke a'e mupyrara ta uwyr. Anĩ. Aja ym. Muhã katu ta uwyr. ");
INSERT INTO urbNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ta'yr rehe amõ jurujar katu rahã: “Nde katu ym. Nde ke amupyrara ta” aja Tupã pandu ym te ta. Amõ jurujar ym ehe rahã: “Nde katu ym. Nde ke amupyrara ta” aja Tupã pandu ta kỹ. Tupã ra'yr rehe a'e jurujar ym. Ta'yr peteĩhar rehe jurujar ym, a'erehe aja Tupã pandu ta kỹ. ");
INSERT INTO urbNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ma'erehe mupyrara ta my? Kuja riki. Kome'ẽ ywy keruhũ pe har ta pe weraha uwyr tipe. (Aja rahã, Tupã rehe har Ta'yr mujekwa tipe.) Ame'ẽ ke a'eta putar ym. Anĩ. Pytuniha ke a'eta putar. (Aja rahã, ma'e ka'u te'eha ma'ema'eha ke putar.) Upa ma'e ka'u te'eha ke ma'ema'e ixo, a'erehe weraha ke a'eta putar ym. ");
INSERT INTO urbNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ma'e ka'u te'eha ke amõ ma'e rahã, weraha koty uwyr ym ta. (Tupã rehe har ukwa tar ym. Putar ym.) Weraha koty uwyr rahã, ma'e ka'u te'eha ma'eha ke Tupã mujekwa ta. A'erehe uwyr ym. (Tupã rehe har ukwa tar ym.) ");
INSERT INTO urbNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pe, ma'e katu ame'ẽ ke amõ ma'e rahã, weraha rehe uhyk. (Aja rahã, Tupã rehe har a'e ukwa tar katu.) Aja rahã, Tupã putar ame'ẽ ke a'e ma'ema'e. Aja a'e mujekwa. Tupã rehe hendu katu, a'erehe ma'e katu ame'ẽ ke a'e ma'ema'e katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nikonde namõ upa Jesu pandu rahã, amõ ywy pe oho. Jundéi ywy pe oho. Jumu'eha ta oho tĩ. A'ep jumu'eha ta namõ a'e pyta we rĩ. A'ep amõ ta ke a'eta mujahuk. ");
INSERT INTO urbNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Amõ renda pe Juã mujahuk ixo tĩ. Enõ renda pe mujahuk ixo. A'ep y heta. Ame'ẽ renda Sarĩ ok ta rake ihĩ. Heta ngã uhyk oho ehe. Ame'ẽ ta ke Juã mujahuk. (Aja rahã, Tupã koty ipy'a muruwak, aja a'eta mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Arahã kyndaha pe Juã ke amõ ta kynda ym we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Juã namõ jumu'e ixo ame'ẽ ta ngi har amõ ta ixo. Ame'ẽ ta namõ jundéu awa ta je'ẽ je'ẽ hũ. “Juã mujahuk ame'ẽ ke riki katu te” aja Juã namõ jumu'e ixo ame'ẽ ta pandu pandu u'am. “Anĩ. Jesu mujahuk ame'ẽ ke riki katu te” aja jundéu awa ta je'ẽ je'ẽ hũ. ");
INSERT INTO urbNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","A'erehe Juã pe a'eta pandu oho: —Sa'e! Ngã mu'eha nde. Amukwehe y ruwái koty ne namõ amõ sawa'e ixo, Jondã ruwái koty. Ehe har nde erepandu. “Peme'ẽ riki Tupã ra'yr” aja nde erepandu. Ame'ẽ nde erekwa u'am my. Apo heta ngã ohoho ixoty. Ame'ẽ ta ke mujahuk u'am apo — aja Juã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Pe, Juã pandu: —Ixoty ngã ke Tupã mondo. A'erehe heta ngã ohoho ixoty. ");
INSERT INTO urbNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ihẽ apandu ame'ẽ ke pehẽ atu pekwa katu. Kuja ihẽ apandu: “Anĩ. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke aja ym ihẽ. Ihẽ ke Tupã muwyr py. Tupã muwyr ame'ẽ ndutar koty ihẽ ke Tupã mondo” aja ihẽ apandu. ");
INSERT INTO urbNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Sawa'e jumendar rahã, kũjã riki sawa'ema'e wan ta. Pe, sawa'e rehe katu ame'ẽ ta sawa'e rake hendu u'am. Pe, sawa'e rehe kũjã uhyk rahã, ehe katu ame'ẽ ta hury katu. Aja ihẽ tĩ. Jesu rehe heta ngã uhyk oho rahã, ihẽ rury katu te ihẽ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","A'erehe ihẽ 'ar koty te we ixoty ngã oho rahã, katu tiki. Aja rahã, ihẽ rury katu te ihẽ axo rĩ — aja inamõ jumu'e ixo ame'ẽ ta pe Juã pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ywa ngi wyjy uwyr. Ame'ẽ riki i'ar koty te we a'e katuha. Upa awa ta 'ar koty te we a'e katuha. Awa ke anĩ. Kome'ẽ ywy keruhũ pe ixo ame'ẽ ke a'e. A'e riki awa te'e tĩ. Kome'ẽ ywy keruhũ pe ma'e ke ihĩ. Ame'ẽ rehe har jõ a'e ukwa. Ame'ẽ ke a'e pandu. Panduha rehe jurujar katu awa tĩ. Ywa ngi wyjy uwyr ame'ẽ ke anĩ. I'ar koty te we jurujar katu ta me'ẽ te'e ehe. ");
INSERT INTO urbNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","A'ep a'e usak ame'ẽ rehe har a'e pandu pandu tipe. A'ep a'e hendu ame'ẽ rehe har a'e pandu pandu tipe tĩ. Pe, amõ jurujar ym ehe. ");
INSERT INTO urbNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","A'e pandu ame'ẽ rehe amõ jurujar katu rahã, kuja ukwa katu. Tupã pandu ame'ẽ ke a'e ma'ema'e katu. Aja rahã, Tupã pandu ame'ẽ ke jetehar te ke aja mujekwa ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Jesu ke Tupã muwyr. Pe, Tupã pandu ame'ẽ ke a'e pandu pandu. I'ãma'e pyrãtãha ke Tupã muwyr ipe. Ame'ẽ riki upa ym. A'erehe Tupã mujekwa ame'ẽ ke a'e pandu pandu katu. ");
INSERT INTO urbNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ta'yr rehe ipái ipy'a katu. Upa katu te a'e me'ẽ ipe. A'erehe upa katu te ima'e ke. A'erehe upa katu te awa tama'e kapitã keruhũ te a'e. ");
INSERT INTO urbNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ta'yr rehe amõ jurujar katu rahã, a'e ke Tupã muhã katu ta. Ta'yr rehe jurujar ym rahã, marã ka ym a'e uhãha. A'e ke Tupã mupyrara ta. Aja te'e ta ixo. ");
INSERT INTO urbNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesu koty amõ amõ we ngã jumu'e oho. Ame'ẽ ke parise ta hendu. Juã 'ar koty te we ngã ke Jesu mujahuk, aja parise ta hendu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jesu riki ngã ke mujahuk ym. Inamõ jumu'e ixo ame'ẽ ta riki mujahuk u'am, ngã ke. ");
INSERT INTO urbNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Parise ta hendu ame'ẽ ke Jesu ukwa rahã, Jundéi ywy ngi a'e oho. Ngariréi ywy pe a'e jywyr oho. ");
INSERT INTO urbNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Amõ awa rape Samari ywy rupi ihon. Ame'ẽ rupi Jesu oho ta me'ẽ te'e. ");
INSERT INTO urbNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samari ywy rupi a'e asa oho rahã, amõ ok ta rehe a'e uhyk tate oho. Her Sikar. Ame'ẽ ok ta rake ma'e ywy kotete ihĩ, Jakoma'e ywy ke. Yman te ta'yr pe ame'ẽ ywy ke Jako me'ẽ. Jose pe a'e me'ẽ. ");
INSERT INTO urbNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","A'ep ywykwar ihĩ. Yman te Jako pykũi ame'ẽ ke. Ame'ẽ rake Jesu wapyk. A'e wata hũ, a'erehe he'õ. Warahy jandar tate rahã, a'ep a'e wapyk uĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ok ta pe jumu'eha ta oho. A'eta mi'u ke jo'ok oho. Pe, Jesu jeje ihĩ rahã, amõ kũjã uhyk uwyr ehe. Samari ywy pe har ke a'e. Y rehe uwyr. Pe, Jesu pandu ipe: —Y ihẽ pe emuwyr. Ihẽ hyngwéi te ihẽ ke — aja kũjã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","—Mã! Nde riki jundéu awa. Ihẽ riki Samari ywy pe har. Ma'ewã y nde erepandu ihẽ pe my? — aja Jesu pe. Samari ywy pe har tama'e ita rekúi ra'yr ke jundéu awa ta pyhyk ym te. A'erehe: “Mãte we ame'ẽ te a'e my” aja kũjã ukwa. ");
INSERT INTO urbNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesu pandu: —Ma'e ke nde pe Tupã me'ẽ tar katu. Ame'ẽ ke nde erekwa rahã, ihẽ pe y nde erepandu ta tipe. “Y ihẽ pe emuwyr” aja nde pe ihẽ apandu. Ihẽ rehe har nde erekwa rahã, aja tĩ. Ihẽ pe y nde riki nde erepandu ta tipe tĩ. Ihẽ pe nde erepandu rahã, y ke nde pe ihẽ ame'ẽ ta tipe. Ame'ẽ y nde ke muxuwe katu ta tipe — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—Sa'e! “Y nde ke muxuwe katu ta” aja nde erepandu. Myja ame'ẽ ke ihẽ pe nde ereme'ẽ ta my? Ko ywykwar riki typy hũ. Y jo'okiha namõ nde erexo ym. ");
INSERT INTO urbNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jande ramũi riki kome'ẽ ywykwar ke jande pe mupyta. Jako mupyta. Yman kome'ẽ y ke a'e u'u ixo. Ta'yr ta u'u tĩ. Hymba ta u'u tĩ. Jako riki mupyta jande pe. “Y muxuwe katu ta” aja nde erepandu rahã, Jako 'ar koty te we pyrãtãha nde my? — aja kũjã pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","—Kome'ẽ y amõ u'u rahã, jyngwéi ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Y ke ihẽ ame'ẽ. Ame'ẽ ke amõ u'u rahã, jyngwéi ym te ta. Y ihẽ ame'ẽ ipe rahã, ipy'a pe mundu aja saka. Upa ym te ta. Uhãha namõ ixo ta — aja kũjã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","(Awa uhãha rehe har Jesu pandu uĩ. Ame'ẽ ke kũjã ukwa ym we rĩ.) A'erehe a'e pandu: —Sa'e! Ihẽ ke y muxuwe katu, ame'ẽ ke ihẽ pe emuwyr. Aja rahã, ihẽ hyngwéi ym te ta tĩ. Se y ihẽ ajo'ok ym te ta ajur tĩ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Nde sawa'e pe epukái eho. Pe, se ejywyr inamõ ejur tĩ — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Anĩ. Ihẽ sawa'e ym ihẽ — aja kũjã. —“Ihẽ sawa'e ym” aja nde erepandu. Ame'ẽ riki jetehar te ke. ");
INSERT INTO urbNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Heta sawa'e nde erepyhyk. Awa po wajar peteĩhar upa hetaha. Apo ne namõ ixo ame'ẽ ke nde sawa'e ym. Jetehar te ke nde erepandu ihẽ pe — aja kũjã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","(Kũjã ixoha rehe har Jesu mujekwa, a'erehe) kũjã pandu: —Sa'e! Tupã je'ẽha pandu ame'ẽ ke nde. Aja ihẽ akwa 'y. (A'erehe ihẽ pe emujekwa. Myp Tupã rehe ipy'a ke amõ moĩ moĩ katu my?) ");
INSERT INTO urbNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tupã rehe ihẽ ramũi ta ipy'a moĩ moĩ, samari ywy pe har ta ke. Peme'ẽ ywy'ã keruhũ 'ar pe a'eta moĩ moĩ. Pehẽ anĩ. Jundéu awa ta anĩ. Jerusarẽ ok ta pe jõ Tupã rehe ipy'a ngã moĩ moĩ ta me'ẽ te'e, aja jundéu awa ta pandu. Myja me'ẽ katu te my? — aja Jesu pe kũjã pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Pe, kũjã pe a'e pandu: —Ko ihẽ apandu ame'ẽ jetehar te ke. Ame'ẽ ke nde erekwa katu ta. Peme'ẽ ywy'ã keruhũ 'ar pe jande pái keruhũ rehe ipy'a moĩ moĩ ym ta awa. Ame'ẽ angaha ke rehe uhyk tate. Jerusarẽ ok ta pe aja tĩ. Jande pái keruhũ rehe ipy'a moĩ moĩ ym ta awa a'ep tĩ. Ame'ẽ angaha ke rehe uhyk tate tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tupã rehe ipy'a ke samari ywy pe har ta moĩ moĩ tipe. Ehe har a'eta ukwa ym. Ipy'a jundéu awa ta moĩ moĩ ehe tĩ. Ehe har a'eta ukwa katu. Jundéu awa ta ngi har ngãma'e muhãha uwyr ta. A'erehe Tupã rehe har a'eta ukwa. ");
INSERT INTO urbNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Jande pái keruhũ rehe ipy'a amõ moĩ moĩ katu te ta. Ame'ẽ angaha ke rehe uhyk tate. Jete. Uhyk apo 'y. Tupã rehe har jetehar te ke Tupã'ã mujekwa. A'e riki amõ py'a rehe ihĩ katu. A'erehe amõ ixo, a'ep jande pái keruhũ rehe ipy'a ke moĩ moĩ katu. (Aja rahã, henda nixói, ame'ẽja saka. Amõ ixo, a'ep ipy'a ke a'e moĩ moĩ katu ehe.) ");
INSERT INTO urbNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tupã riki I'ã te'e a'e. A'erehe jande pái keruhũ rehe ipy'a ke amõ moĩ moĩ tar katu rahã, Tupã'ã je'ẽha rupi uhem ta me'ẽ te'e. Ame'ẽ ta riki jande pái keruhũ rehe ipy'a moĩ moĩ katu — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kũjã pandu ipe: —Kirisutu uwyr ta, aja ihẽ akwa. (Kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e.) A'e uwyr rahã, upa katu te ma'e ke jande ke a'e mu'e ta — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","A'e pandu: —Ko ihẽ aĩ. Kirisutu ihẽ. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke ihẽ — aja kũjã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Arahã jumu'eha ta jywyr uwyr. Kũjã namõ Jesu pandu pandu uĩ. Ame'ẽ ke rehe a'eta usak rahã: “Mã!” aja. Anĩ. “Ma'e ke rehe har nde erepandu inamõ my?” aja Jesu pe a'eta pandu ym. “Ma'erehe nde erepandu inamõ my?” aja a'eta pandu ym ipe tĩ. (Jundéu awa tama'e mu'eha rahã, kũjã namõ pandu ym te awa, a'erehe: “Mã!” aja ukwa.) ");
INSERT INTO urbNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pe, kamuxĩ ra'yr ke kũjã hijar oho. Ok ta pe a'e jywyr oho. A'ep pe har ta pe a'e pandu: ");
INSERT INTO urbNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Sawa'e rehe pesak peho. Upa katu te ihẽ ama'ema'e ame'ẽ ke a'e mujekwa ihẽ pe. Kirisutu a'e my, kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e — aja kũjã pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","A'erehe ok ta pe har ta uhem oho. Jesu koty a'eta oho. ");
INSERT INTO urbNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kũjã oho rahã, Jesu pe jumu'eha ta pandu pandu u'am: —Sawa'e! Ko jande mi'u. E'urahã! — aja pandu hũ tipe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","A'e pandu: —A'ewan ihẽ pe. Ma'e a'u ame'ẽ ke namõ ko ihẽ axo. Ame'ẽ ke pekwa ym pehẽ — aja jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Pe, jumu'eha ta pandu pandu a'eta jupe: —Imi'u ke amõ ta werur ipe nahã my? — aja a'eta pandu pandu a'eta jupe naĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesu pandu: —Tupã ihẽ ke muwyr. A'e putar ame'ẽ ke ihẽ ama'ema'e rahã, ame'ẽ riki ihẽ mi'u aja saka tĩ. Imi'u namõ amõ ixo rahã, hury katu a'e. Aja ihẽ tĩ. Ihẽ rury katu tĩ. Ma'e parakyha ke ihẽ pe a'e me'ẽ tĩ. Ame'ẽ ke ihẽ amumba ta axo. A'erehe ihẽ rury katu axo. ");
INSERT INTO urbNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","—Pehẽ pepandu: “Amõ tumeme jahy kanim rahã, ahúi aja me'ẽ ke itawa ta. Amõ mondok ta” aja. Pe, ihẽ apandu pehẽ pe. Pesarahã! Itawa apo 'y. Mondokiha angaha rehe uhyk apo 'y. (Aja rahã, ihẽ rehe a'ep pe har ta jurujar tar katu.) ");
INSERT INTO urbNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ahúi aja me'ẽ mondokiha pe ijar muhepy. Pe, mondokiha matyr. (Aja matyriha aja apo tĩ. Ihẽ rehe peme'ẽ ta jurujar katu ta.) Aja rahã, ame'ẽ ta ke Tupã muhã katu ta. Matyr rahã, ma'e ra'ĩ jytym ame'ẽ ta hury katu. Matyr ame'ẽ ta hury katu tĩ. Johu hury katu. (Aja apo tĩ. Ajytym aja Tupã je'ẽha ke ihẽ apandu. Pe, matyr aja ihẽ rehe jurujar katu ta. Johu hury katu ta tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Aja amõ panduha riki jete. Kuja: “Ma'eywa ke amõ jytym oho. Pe, tyarõ rahã, ame'ẽ ke amõ riki mondok oho” aja panduha ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","—Amõ kupixa pe peparaky ym. Amõ ta paraky. Ame'ẽ pe pehẽ ke ihẽ amondo. A'ep ma'e ke pematyr ta. Pe, pehẽ rury katu ta. (Aja apo tĩ. Amõ rekoha pe amõ ta Tupã je'ẽha pandu. A'ep pehẽ ke ihẽ amondo. Pe, a'ep pe har ta ihẽ rehe jurujar katu. Pematyr, ame'ẽja saka) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ok ta pe samari ywy pe har ta ixo. A'eta pe kũjã pandu: “Upa katu te ihẽ ama'ema'e ame'ẽ ke a'e mujekwa” aja Jesu rehe har kũjã pandu. A'erehe heta ame'ẽ ok ta pe har ta jurujar katu ehe tĩ, Jesu rehe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pe, Jesu rehe samari ywy pe har ta uhyk uwyr rahã, a'eta pandu ipe: —Jande namõ epyta we rĩ — aja pandu hũ. A'erehe a'ep mokõi Jesu ukwer. ");
INSERT INTO urbNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jesu mu'e. A'erehe amõ we hũ a'ep pe har ta jurujar katu ehe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Pe, kũjã pe a'eta pandu: —Ehe har jande pe nde erepandu, a'erehe jajurujar katu ehe apo tĩ. Ame'ẽ jõ ym. A'e pandu ame'ẽ ke rehe jande atu jahendu. A'e riki kome'ẽ ywy keruhũ pe har ta ke a'e muhã katu ta. Aja jakwa katu. A'erehe jajurujar katu ehe tĩ — aja a'ep pe har ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Samari ywy pe mokõi ukwer. Pe, Jesu oho. A'e riki pandu: “Tupã je'ẽha ke pandu ame'ẽ rehe hekoha pe har ta katu ym usak” aja a'e ukwa. A'erehe hekoha te pe oho ym. Anĩ. Amõ ok ta pe oho. Ame'ẽ ok ta Ngariréi ywy rehe ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pe, ame'ẽ ok ta pe uhyk rahã, a'ep pe har ta hury katu ehe, Jesu rehe. Amukwehe Jerusarẽ ok ta pe a'eta ixo tĩ. Pasuko 'ar rahã, ngã mi'u ke jundéu awa ta matyr. Arahã a'eta a'ep ixo tĩ. Arahã marã ka ym amõ ma'eha, ame'ẽ ke Jesu ma'ema'e. Ame'ẽ ke rehe upa a'eta usak. A'erehe a'eta hury katu ehe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Pe, ma'e ok ta pe a'e uhyk tĩ. Kana ok ta pe uhyk tĩ. Ngariréi ywy rehe ame'ẽ ok ta ihĩ. Yman a'ep y ke te'e kawĩ wan a'e muruwak. A'ep amõ kapitã ixo. Ta'yr ahy ipe. Amõ ok ta pe ta'yr ihĩ. Kapana'ũ ok ta pe ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jundéi ywy ngi Ngariréi ywy pe Jesu uhyk uwyr. Ame'ẽ ke kapitã hendu rahã, a'e pandu ipe, Jesu pe. —Ihẽ rekoha pe ihẽ namõ eho. Kapana'ũ ok ta pe. Ihẽ ra'yr ahy ou. Manõ tate. A'e ke emukatu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesu pandu ipe: —Marã ka ym amõ ma'eha. Ame'ẽ ke ihẽ ama'ema'e katu. Ame'ẽ ke rehe nde eresak rahã jõ, ihẽ rehe nde erejurujar katu. Mã! Katu ym — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kapitã pandu: —Sa'e! Pahar ihẽ namõ eho. Ihẽ ra'yr manõ tate. Manõ ym we rĩ. Pahar eho — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","(Usak rahã jõ jurujar katuha katu ym, aja Jesu mujekwa tar katu.) A'erehe a'e pandu ipe: —Anĩ. Aho ym ta. Nde jeje ejywyr eho. Nde ra'yr manõ ym ta — aja kapitã pe. Jesu mukatu, ame'ẽ ke rehe kapitã usak ym. Anĩ. Jesu pandu ame'ẽ ke rehe kapitã jurujar katu. A'erehe pahar a'e jywyr oho. ");
INSERT INTO urbNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Hok pe a'e jywyr oho ixo rahã, miasu ta uhyk uwyr ehe. Pandu uwyr: —Nde ra'yr katu apo 'y — aja kapitã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Pe, miasu ta pe a'e pandu: —My warahy rahã, katu oho my? — aja. A'eta pandu: —Kwehe hakuha maha oho ipe. Se warahy rahã, hakuha maha oho ipe. Warahy jere rahã — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Arahã katu te: “Ne ra'yr manõ ym ta” aja Jesu pandu kwehe. Ame'ẽ ke ipy'a pe ipái ukwa ukwa u'am. Pe, Jesu rehe a'e jurujar katu te. Upa hok wyr pe har ta jurujar katu ehe tĩ, Jesu rehe. ");
INSERT INTO urbNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Aja marã ka ym amõ ma'eha, ame'ẽ ke Jesu ma'e katu. (Aja Kirisutu a'e. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e, aja mujekwa katu ngã pe.) Jundéi ywy ngi Ngariréi ywy pe uhyk rahã, marã ka ym amõ ma'eha, ame'ẽ ke a'e ma'e katu. Ame'ẽ riki mokõihar ke. ");
INSERT INTO urbNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pe, heta ukwer rahã, amõ jundéu awa ta mi'u matyriha rehe Jesu usak oho. Jerusarẽ ok ta pe usak oho. Arahã Tupã rehe jundéu awa ta ipy'a moĩ moĩ. A'erehe ngã mi'u matyr. ");
INSERT INTO urbNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusarẽ ok ta pe y kynda ame'ẽ ke ihĩ. Hukwen rake ihĩ. Arapuharan ta ixe, ame'ẽ hukwen rake ihĩ. Y kynda ame'ẽ rake rupi ok rymy'y heta ihĩ tĩ. Katukwer ame'ẽ ta ke. Kuja, awa po wajar peteĩhar upa hetaha. Ame'ẽ kynda ame'ẽ rehe her ngã moĩ. “Mbete” aja riki jundéu awa ta je'ẽha ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ok rymy'y wyr rupi ahy ixo ame'ẽ ta heta túi. Eha ym te ame'ẽ ta a'ep ihĩ tĩ. Jupyrãtã rãtã ame'ẽ ta túi tĩ. Wata ym te ame'ẽ ta ihĩ tĩ. Y katak ame'ẽ rehe a'eta harõ ixo. ");
INSERT INTO urbNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Amõ amõ rahã, Tupã je'ẽha rahoha wyjy uwyr ehe, y kynda ame'ẽ rehe. Pe, y ke a'e mukatak. Arahã y pe u'ar py, ame'ẽ ke jõ katu oho. Peteĩ jõ katu oho. Ma'e ahy ixo ame'ẽ ke upa katu oho. ");
INSERT INTO urbNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","A'ep amõ sawa'e túi. Heta te hũ warahy 'ar rahã, ma'e ahyha namõ te'e a'e ixo. Kuja, 38 warahy 'ar rahã, aja te'e a'e ixo. ");
INSERT INTO urbNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","A'ep a'e túi, aja Jesu usak ehe. Heta te hũ warahy 'ar rahã, ma'e ahyha namõ te'e a'e ixo, aja Jesu ukwa. A'erehe a'e pandu ipe: —Katu aja nde ereputar my? — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Sa'e! Aputar. Y katak rahã, y pe ihẽ ke mou ame'ẽ nixói. Pe, ihẽ atu aho axo rahã, amõ riki y pe opor py, a'erehe ihẽ katu ym aju — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","—Epu'am. Nema'e tupe ke emaman. Inamõ ewata eho 'y — aja ahy ixo ame'ẽ pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Pahar sawa'e katu oho. Tupe ke pyhyk. Inamõ wata oho. Arahã riki jundéu awa tama'e putu'uha 'ar ke. ");
INSERT INTO urbNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","A'erehe jundéu awa tama'e kapitã ta pandu ipe. Sawa'e wata ramõ ame'ẽ pe pandu: —Apo riki jundéu awa tama'e putu'uha 'ar ke. A'erehe nema'e tupe ke nde erepyhyk ereraho rahã, katu ym. (Nde ereparaky te'e, aja saka.) Katu ym. Aja jundéu awa je'ẽha rehe panduha ihĩ. Ame'ẽ rehe jahendu katu — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Sawa'e pandu: —Ihẽ ke mukatu ame'ẽ pandu ihẽ pe: “Nema'e tupe epyhyk. Inamõ ewata eho” aja ihẽ pe — aja jundéu awa tama'e kapitã ta pe sawa'e pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","A'eta pandu ipe: —Awa aja me'ẽ pandu nde pe my? — aja sawa'e pe. ");
INSERT INTO urbNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","A'e pandu: —Awa mamy? Akwa ym ihẽ — aja sawa'e. Heta ngã a'ep ixo, a'erehe Jesu oho. A'erehe ehe har sawa'e ukwa ym. ");
INSERT INTO urbNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","I'i atu we rahã, sawa'e rehe Jesu usak. Tupã rehe ngã jumu'eha renda keruhũ pe a'e usak ehe. A'e pandu ipe: —Esarahã! Apo nde katu 'y. Ma'e nde ereka'u te'eha ke ema'e ym tĩ. Tapijar te'e we nde ereka'u te'eha nde erema'e rahã, nde erepyrara we hũ ta tĩ — aja sawa'e pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Pe, sawa'e oho. Jundéu awa tama'e kapitã ta pe a'e pandu oho: —Jesu riki ihẽ ke mukatu — aja pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","A'erehe Jesu ke jundéu awa tama'e kapitã ta mupyrara tar katu. Putu'uha 'ar rahã, a'e mukatu. (Aja rahã paraky te'e, aja ukwa, a'erehe mupyrara tar katu.) ");
INSERT INTO urbNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pe, ngã pe Jesu pandu: —Ma'e katu ame'ẽ ke ihẽ pái keruhũ ma'e ixo rĩ. Aja te'eha a'e. (Aja rahã, putu'uha 'ar rahã, a'e ma'e ixo rĩ, aja mujekwa.) A'erehe aja ma'e katu ame'ẽ ke ihẽ ama'e ta me'ẽ te'e tĩ. (Putu'uha 'ar rahã, ihẽ ama'e ta me'ẽ te'e tĩ) — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ame'ẽ panduha rehe jundéu awa tama'e kapitã ta parahy. I'ar koty te we parahy ehe. Jukwa tar katu. Jundéu awa tama'e putu'uha 'ar rahã, sawa'e ke mukatu. (Paraky te'e, aja ukwa.) A'erehe katu ym, aja a'eta ukwaha naĩ. Amõ we tĩ. Tupã riki ipái, aja a'e pandu. Aja rahã, Tupã a'e tĩ, aja a'eta ukwa. A'erehe parahy te hũ ehe. “Mã! Jajukwa ta” aja pandu pandu a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","(Tupã a'e tĩ, aja Jesu mujekwa tar katu.) A'erehe ngã pe a'e pandu: —Ko pehẽ pe ihẽ apandu: “Ta'yr ke ihẽ.” Ihẽ jeje ma'e ke ihẽ ama'e ym. Ihẽ pái ma'ema'eha rehe ihẽ asak. Aja ihẽ ama'e tĩ. Ihẽ pái ma'eha aja ihẽ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ihẽ rehe ihẽ pái keruhũ ipy'a katu. (Ta'yr ke ihẽ.) Upa a'e ma'e ixo ame'ẽ ke ihẽ pe a'e mujekwa. Peme'ẽ sawa'e ihẽ amukatu. Ame'ẽ 'ar koty te we marã ka ym amõ ma'eha, ame'ẽ ke ihẽ ama'ema'e ta. Ihẽ pái mujekwa ta ihẽ pe tĩ. Ame'ẽ ke ihẽ ama'ema'e ta tĩ. Pesak ehe rahã: “Mã! Katu hũ!” aja pekwa ta. ");
INSERT INTO urbNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","—Manõ ame'ẽ ke ihẽ pái keruhũ mukwera katu muhem. Aja ihẽ aputar ame'ẽ ta ke ihẽ amukwera katu ta amuhem tĩ. Ta'yr ke ihẽ, a'erehe amukwera katu amuhem ngã ke tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","—Ihẽ pái keruhũ ihẽ pe pandu: “Nde riki ngã pe epandu katu. Kuja. Katu ma'ema'e ame'ẽ ta pe: ‘Katu nde. Tupã namõ exo katu’ aja. Ma'e ka'u te'eha ke ma'ema'e ame'ẽ ta pe: ‘Katu ym nde. Mupyraraha renda pe eho’ aja” aja ihẽ pái pandu ihẽ pe. Aja a'e atu pandu ym ta. Ihẽ riki apandu ta kỹ. ");
INSERT INTO urbNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Pe, ihẽ pái keruhũ rehe har aja katu ihẽ rehe har amõ ta pandu ta tĩ. Katu ihẽ rehe har amõ ta pandu ym rahã, ihẽ pái keruhũ rehe har katu pandu ym ta tĩ. Jande juja katu te jande tĩ. Ta'yr ke ihẽ. Ihẽ pái keruhũ muwyr ame'ẽ ke ihẽ. ");
INSERT INTO urbNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","—Jetehar ke pehẽ pe ihẽ apandu. Ihẽ pái ihẽ ke muwyr. Ihẽ je'ẽha rehe amõ hendu. Pe, ihẽ pái rehe a'e jurujar katu rahã, uhã te hũ ame'ẽ ke a'e aja te'e ta ixo. A'e ke ihẽ pái keruhũ mupyrara ym te ta. Anĩ. Manõha ngi mutyryk oho, ame'ẽja saka. (Aja rahã, mupyraraha renda pe ohoha ngi mutyryk oho, ame'ẽja saka.) Pe, uhã te hũ ame'ẽ ke a'e aja te'e ta ixo. Aja rahã, Tupã koty oho ta ame'ẽ ke a'e. Aja rahã, apo Tupã pandu 'y: “Ame'ẽ ke mupyraraha renda pe oho ym te ta. Anĩ. Uhã te hũ aja ixo apo 'y” aja Tupã pandu 'y. ");
INSERT INTO urbNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","—Ko apandu pehẽ pe. Tupã ra'yr ihẽ. Ma'e angaha ke rehe uhyk ta. Kuja. Manõ ame'ẽ ta ihẽ je'ẽha rehe hendu ta. Aja rahã, uhã ta. Apandu pehẽ pe. Apo aja tĩ. Ihẽ rehe jurujar ym ame'ẽ ta riki manõ ame'ẽ ta aja saka. Uhã ym, a'erehe aja. Apo ihẽ je'ẽha rehe hendu. Pe, ihẽ rehe jurujar katu ta. Aja rahã, uhã te hũ aja ixo ta apo 'y. ");
INSERT INTO urbNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","—Ihẽ pái keruhũ riki je'ẽha te reko. A'erehe uhãha ke ngã pe a'e me'ẽ katu. Aja ihẽ tĩ. Ta'yr ke ihẽ. Ihẽ pe a'e pandu: “Ngã pe uhãha nde ereme'ẽ katu tĩ” aja ihẽ pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","—Ihẽ pái keruhũ pandu: “Ngã pe epandu katu. Kuja. Katu ma'ema'e ame'ẽ ta pe: ‘Nde katu. Tupã namõ exo katu’ aja nde erepandu katu. Ma'e ka'u te'eha ke ma'ema'e ame'ẽ ta pe: ‘Nde katu ym. Mupyraraha renda pe eho’ aja nde erepandu katu tĩ” aja ihẽ pe pandu tĩ. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. A'erehe aja me'ẽ ihẽ pe ihẽ pái pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","—Ko ihẽ apandu ame'ẽ ke rehe: “Mã!” aja pepandu ym. Kuja. Ihẽ je'ẽha rehe upa katu te manõ ame'ẽ ta hendu ta. Ame'ẽ angaha ke rehe uhyk ta kỹ. ");
INSERT INTO urbNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Pe, ihẽ je'ẽha rehe hendu rahã, a'eta kwera katu ta uhem. Pe, katu ame'ẽ ke ma'ema'e, ame'ẽ ta ke ihẽ pái keruhũ mukwera katu ta muhem. Tupã namõ ixo ta. Ma'e ka'u te'eha ke ma'ema'e. Ame'ẽ ta ke a'e mukwera katu ta muhem tĩ. Ame'ẽ ta ke mupyraraha renda pe mondo ta kỹ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","A'e pandu tĩ: —Ihẽ jeje ma'e ke ihẽ ama'ema'e ym. Ihẽ pái keruhũ mujekwa. Ame'ẽ ke jõ ngã pe ihẽ apandu pandu ta. “Pehẽ katu. Tupã namõ pexo katu” aja. Ma'e ka'u te'eha ke ma'ema'e ame'ẽ ta pe: “Pehẽ katu ym. Mupyraraha renda pe peho” aja. Ihẽ aputar ame'ẽ ke ihẽ ama'ema'e ym. Anĩ. Ihẽ pái keruhũ ihẽ ke muwyr. A'e putar ame'ẽ ke ihẽ ama'ema'e katu. A'erehe jetehar rupi ngã rehe har ihẽ pandu pandu ta. ");
INSERT INTO urbNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","—Ihẽ apandu: “Ihẽ ke Tupã muwyr” aja. Aja ihẽ jõ apandu rahã, ihẽ apandu ame'ẽ ke rehe pejurujar ym ta me'ẽ te'e. ");
INSERT INTO urbNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Anĩ. Amõ ihẽ rehe har pandu ame'ẽ ke pehĩ. Ihẽ pái ke ame'ẽ. Ihẽ rehe har a'e pandu ame'ẽ ke jetehar te ke. Aja ihẽ akwa katu. A'erehe ihẽ rehe pejurujar katu ta me'ẽ te'e. ");
INSERT INTO urbNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Amõ ta ke Juã koty pehẽ pemondo. Juã pe a'eta pandu oho. Pe, jetehar te ke ihẽ rehe har Juã pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pesarahã! Ihẽ rehe har sawa'e pandu. Ame'ẽ ke ihẽ aputar my? Anĩ riki. Kuja riki. Sawa'e pandu ame'ẽ ke rehe pejurujar katu rahã, ihẽ rehe har pekwa katu ta tĩ. Aja rahã, ihẽ rehe pejurujar katu ta. Aja rahã, pehẽ ke ihẽ pái keruhũ muhã katu ta. ");
INSERT INTO urbNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","—Araparin aja Juã. Hendy aja saka. (Aja rahã, jetehar Tupã rehe har a'e mujekwa.) Pe, pehendu ehe rahã, i'i atu we pehẽ rury katu ehe. ");
INSERT INTO urbNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","(Ihẽ rehe har mujekwa, ame'ẽ ke tumeme pehĩ.) Ihẽ rehe har Juã pandu pandu. Amõ we tĩ. Juã 'ar koty te we ihẽ rehe har mujekwa ame'ẽ ke ko ixo. Ihẽ ama'ema'eha ke. (Ame'ẽ ihẽ rehe har mujekwa tĩ. Mokõihar ke ame'ẽ.) Ame'ẽ ke ihẽ pái keruhũ me'ẽ ihẽ pe. Ame'ẽ ke ihẽ ama'ema'e. Ame'ẽ rehe amõ usak rahã: “Ko Tupã muwyr ame'ẽ ke” aja ukwa ta. ");
INSERT INTO urbNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Amõ we tĩ. Ihẽ ke ihẽ pái keruhũ muwyr. A'e riki ihẽ rehe har pandu tĩ. (Ame'ẽ ihẽ rehe har mujekwa tĩ. Mahapyrihar ke ame'ẽ.) Ima'e je'ẽha rehe pehendu ym te. Ima'e ma'ema'eha rehe pejurujar ym te tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Je'ẽha ke a'e muwyr. Ame'ẽ ke rehe pehendu tar ym tĩ. Ihẽ rehe pehẽ pejurujar ym, a'erehe pehendu tar ym ehe tĩ. A'e muwyr ame'ẽ ke ihẽ. ");
INSERT INTO urbNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","—Tupã je'ẽha rehe pejumu'e mu'e pexo. Aja rahã, pehẽ ruhã ta, aja pekwaha naĩ. Pesarahã! Tupã je'ẽha rehe ihẽ rehe har panduha ihĩ. (Ame'ẽ ke ihẽ rehe har mujekwa tĩ. Tumemehar ke ame'ẽ.) Ame'ẽ ke jetehar ihẽ rehe har mujekwa tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Anĩ. Ihẽ rehe pejurujar tar ym. Ihẽ rehe pejurujar katu rahã, pehẽ ke ihẽ pái muhã katu ta. ");
INSERT INTO urbNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","—Ihẽ rehe har katu amõ ta pandu. Ame'ẽ ke ihẽ aputar ym. (Katu ihẽ rehe har Tupã pandu. Ame'ẽ ke ihẽ aputar.) ");
INSERT INTO urbNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pehẽ rehe har ihẽ akwa katu. Tupã rehe pehẽ pepy'a ym, aja ihẽ akwa katu. ");
INSERT INTO urbNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ihẽ pái keruhũ je'ẽha rupi ihẽ ajur. Pe, ihẽ ke peputar ym. A'erehe Tupã rehe pehẽ pepy'a ym, aja akwa katu. Ima'e je'ẽha rupi amõ sawa'e uwyr rahã, ame'ẽ ke peputar katu. Ihẽ anĩ. Peputar ym. ");
INSERT INTO urbNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","—Pehẽ rehe har katu amõ ta pandu. Ame'ẽ ke peputar katu. Pehẽ rehe har katu Tupã riki pandu. Ame'ẽ ke peputar ym. A'erehe marã ka ym ihẽ rehe pejurujariha. Tupã peteĩhar a'e. Pandu katuha ke peputar ym. ");
INSERT INTO urbNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","—Pehẽ rehe har ihẽ pái keruhũ pe ihẽ apandu ym ta. Aja pekwaha naĩ. Kuja: “Pehẽ katu ym. Ihẽ rehe pejurujar ym” aja apandu ym ta, aja pekwaha naĩ. Anĩ. Pesarahã! Amõ riki pandu ta tĩ. Moise pandu ta tĩ. “Pehẽ katu ym. Pejurujar ym. Tupã muwyr ame'ẽ ke rehe pejurujar ym” aja pandu ta tĩ. A'e mupinim ame'ẽ ke rehe pehendu katu. Aja rahã, pehẽ ruhã ta, aja pekwaha naĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moise mupinim ame'ẽ ke rehe pehendu katu ta tipe rahã, ihẽ rehe pejurujar katu ta tipe tĩ. Ihẽ rehe har a'e mupinim, a'erehe pejurujar katu ta me'ẽ te'e. ");
INSERT INTO urbNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Anĩ. A'e mupinim ame'ẽ ke rehe pejurujar ym. A'erehe ihẽ apandu ame'ẽ ke rehe marã ka ym pejurujariha tĩ — aja Jesu pandu jundéu awa tama'e kapitã ta pe. ");
INSERT INTO urbNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Heta ukwer rahã, ypa ke Jesu aha oho, jarusu keruhũ pe. Ypa rer Ngariréi. Mokõi her. Timberi aja her tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Heta haikwer rupi ngã oho tĩ. Ma'e ahy ixo ame'ẽ ta ke a'e mukatu. Ame'ẽ ma'e katu ame'ẽ rehe ngã usak, a'erehe haikwer rupi a'eta oho. ");
INSERT INTO urbNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ywy'ã rehe Jesu jupir oho. Ame'ẽ 'ar pe a'e wapyk, jumu'eha ta namõ. ");
INSERT INTO urbNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jundéu awa ta mi'u matyriha 'ar rehe uhyk tate. Her Pasuko. Arahã jundéu awa ta imi'u matyr. ");
INSERT INTO urbNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesu juramã usak rahã, hetaha ta uhyk uwyr ixoty. Ame'ẽ ke rehe a'e usak. Pe, Siri pe a'e pandu: —Hetaha ta pe ngã mi'u jame'ẽ ta. My ame'ẽ ke jande jajo'ok ta my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Myja ngã pe ngã mi'u me'ẽ me'ẽ ta my? Ame'ẽ ke Jesu ukwa katu. Siri ukwaha ke a'e manga u'am. A'erehe aja me'ẽ a'e pandu ipe, Siri pe. ");
INSERT INTO urbNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Siri pandu: —Kuja, 200 'ar rahã, amõ paraky. Ame'ẽ tamatarer pe mbeju jajo'ok rahã, uhyk ym ngã pe. Ta'yr mi ngã u'u ta — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Pe, amõ jumu'eha uhyk. Andere ke. Simã Petu mu a'e. ");
INSERT INTO urbNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","A'e pandu: —Se amõ kurumĩ ixo. Mokõi pira ka'ẽ namõ a'e ixo. Mbeju ra'yr, awa po wajar peteĩhar upa. Ahúi aja me'ẽ ku'i ke te'e mujã ame'ẽ ke. Ame'ẽ ke ngã hetaha ta rehe uhyk ym te ta — aja Andere. ");
INSERT INTO urbNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Pe, Jesu pandu: —“Pewapyk” aja ngã pe pepandu — aja jumu'eha ta pe. Pe, jumu'eha ta pandu rahã, upa ngã wapyk. A'ep sorok katu. Kãpĩ ra'yr heta. Kuja, 5.000 sawa'e ta hetaha ta ixo nahã my. ");
INSERT INTO urbNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pe, mbeju ke Jesu pyhyk. Pe, Tupã pe a'e pandu: —Ne jõ riki katu te me'ẽ ke. Jande mi'u jande pe nde eremuwyr katu — aja. Pe, ame'ẽ ke jumu'eha ta pe a'e me'ẽ me'ẽ. Pe, wapyk ame'ẽ ta pe jumu'eha ta upa me'ẽ me'ẽ tĩ. Aja pira ka'ẽ tĩ. Me'ẽ me'ẽ tĩ. Upa ngã u'u. Uhyk ngã u'u. ");
INSERT INTO urbNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Upa u'u rahã, upa ngã iãpũ rahã, jumu'eha ta pe Jesu pandu: —Pyta we ame'ẽ ke pematyr. Aja rahã katu ta. Ombor ym ta awa, pyta we ame'ẽ ke — aja. ");
INSERT INTO urbNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pe, mbeju pyta ame'ẽ ke a'eta matyr matyr. Ahúi aja me'ẽ ku'i ke te'e mujã ame'ẽ ke. Awa po wajar peteĩhar upa hetaha ngi ngã u'u. Ame'ẽ pyta we ame'ẽ ke matyr matyr. Heta wasãkã mutyryhem. Awa py mokõi hetaha mutyryhem. ");
INSERT INTO urbNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Marã ka ym mbeju ke amõ muhetaha. Ame'ẽ ke Jesu ma'ema'e katu. Ame'ẽ rehe a'ep pe har ta usak. A'erehe ngã pandu pandu ngã jupe: —Tupã je'ẽha pandu ame'ẽ ke kome'ẽ ywy keruhũ pe uwyr ta. Peme'ẽ riki a'e — aja Jesu rehe har ngã pandu pandu ngã jupe. ");
INSERT INTO urbNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","A'e ke kapitã keruhũ aja ngã mu'am tar katu. Pyrãtãha namõ a'e ke ngã mu'am ta raho. Aja Jesu ukwa. Ame'ẽ ke a'e putar ym. (A'e ke Tupã muwyr, aja ngã ukwa ym. Tupã ra'yr a'e, aja ukwa ym tĩ. Kome'ẽ ywy keruhũ pe har kapitã keruhũ, aja jõ ngã putar. Ame'ẽ ke Jesu putar ym tĩ.) A'erehe oho ngã ngi. Amõ we ywy'ã rehe jeje jupir oho. Ngã ngi oho. ");
INSERT INTO urbNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pytun ramõ rahã, ypa pe jumu'eha ta oho. ");
INSERT INTO urbNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Pe, jarusu keruhũ pe a'eta opor oho. Ame'ẽ pe a'eta aha ta oho ixo. Kapana'ũ ok ta koty oho ixo. Pe, pahar pytun oho. Jesu uhyk ym we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pe, ywytu keruhũ jupeju hũ uwyr ehe. A'erehe y ke kotok hũ. ");
INSERT INTO urbNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Paite we jumu'eha ta pykũi hũ oho ixo. Awa po wajar peteĩ kiro met paiteha nahã my. Pe, Jesu rehe a'eta usak. Y 'ar rupi a'e wata uwyr ixo. Jarusu keruhũ koty wata uwyr ixo. A'eta jumukahem hũ ingi. ");
INSERT INTO urbNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesu pandu a'eta pe: —Ihẽ ko. Pejumukahem ym ihẽ ngi — aja. ");
INSERT INTO urbNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pe, huryha namõ jumu'eha ta pandu ipe: —Ejur nde ipe tĩ — aja Jesu pe. A'e opor ipe rahã, pahar y ruwái rehe a'eta uhyk oho. Oho ta, ame'ẽ ywy pe pahar uhyk oho. ");
INSERT INTO urbNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ku'ẽ rahã, peteĩ jõ jarusu keruhũ rehe ngã usak. Y ruwái rehe pyta ame'ẽ ta ke a'eta. Jarusu keruhũ pe jumu'eha ta namõ Jesu oho ym, aja a'eta ukwa katu. Jumu'eha ta jõ oho, aja a'eta ukwa katu. ");
INSERT INTO urbNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pe, amõ amõ jarusu keruhũ pe heta ngã uhyk uwyr a'ep tĩ. Timberi ok ta ngi uhyk uwyr. Mbeju ke ngã u'u. Ame'ẽ renda y rymy'y rehe uhyk uwyr. Mbeju Jesu pyhyk rahã, Tupã pe: “Ne jõ riki katu te me'ẽ ke. Jande mi'u jande pe nde eremuwyr katu” aja a'e pandu. Ame'ẽ renda rake ame'ẽ. ");
INSERT INTO urbNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pe, a'ep Jesu nixói, aja ngã ukwa. Jumu'eha ta nixói tĩ, aja a'eta ukwa tĩ. A'erehe jarusu keruhũ pe opor oho tĩ. Pe, ame'ẽ pe Kapana'ũ ok ta pe oho. Jesu ke a'eta kekar oho. ");
INSERT INTO urbNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ypa ruwái rehe Jesu ke ngã mahem rahã, pandu ipe: —Sawa'e! Ngã mu'eha nde. Myja rahã nde erejur se my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","A'e pandu: —Pesarahã! Marã ka ym amõ ma'eha, ame'ẽ ke pyrãtãha namõ ihẽ ama'ema'e. Aja Tupã ihẽ ke muwyr, aja amujekwa. Ame'ẽ ke rehe pesak. A'erehe ihẽ ke pekekar pexo. Anĩ. Aja ym. Mbeju ke pe'u. Uhyk pe'u. A'erehe ihẽ ke pekekar pexo. ");
INSERT INTO urbNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Pehẽ mi'u ke rehe jõ pehẽ py'a pemoĩ moĩ ym pexo. Ame'ẽ upa ta. Pahar myahy ta awa. Kuja katu. Ma'e mi'u upa ym, ame'ẽ ke rehe pehẽ py'a pemoĩ moĩ katu. Ame'ẽ ke amõ u'u rahã, uhã te hũ aja ixo ta. Ame'ẽ ke ihẽ ame'ẽ me'ẽ ta awa ta pe. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Ame'ẽ ngã mi'u ihẽ ame'ẽ me'ẽ, a'erehe Tupã, ihẽ pái keruhũ pandu ihẽ pe: “Ngã pe uhãha nde ereme'ẽ me'ẽ katu, a'erehe nde rehe ihẽ rury katu” aja pandu. A'erehe awa ruhãha ihẽ ame'ẽ katu — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","A'eta pandu: —Tupã putar ame'ẽ ke jama'e tar katu rahã, myja me'ẽ jama'e ta my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","A'e pandu: —Kuja Tupã putar katu. A'e muwyr ame'ẽ ke rehe pejurujar katu, ame'ẽ ke a'e putar katu. Ko ihẽ riki a'e muwyr ame'ẽ ke ihẽ. Aja rahã, ihẽ rehe pejurujar katu, aja Tupã putar katu — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","A'eta pandu: —Marã ka ym ma'e ke amõ ma'eha. Ame'ẽ ke ema'e. Jande jasak ehe rahã, Tupã nde ke muwyr, aja jakwa ta. Ma'e nde erema'e ta my? ");
INSERT INTO urbNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Esarahã! Awa nixói te ame'ẽ rupi jande ramũi ta ixo rahã, ma'e ke a'eta u'u. “Mana” aja ipe. Ame'ẽ ke a'eta u'u. Tupã je'ẽha rehe kuja panduha ihĩ: “Ywa ngi ngã mi'u ke a'eta pe Moise me'ẽ” aja panduha ihĩ. —Moise me'ẽ, a'erehe a'e ke Tupã mondo aja jakwa katu. Nerahã! Ma'e jande pe nde eremuwyr ta my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","A'e pandu: —Pesarahã! Ywa ngi uwyr, ame'ẽ ngã mi'u ke pehẽ pe Moise me'ẽ ym. Ywa ngi uwyr ame'ẽ ke aja ym ame'ẽ. Pehẽ mi'u te ke pehẽ pe ihẽ pái keruhũ muwyr. ");
INSERT INTO urbNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ngã mi'u ke Tupã me'ẽ. Ame'ẽ riki ywa ngi wyjy uwyr ame'ẽ ke. Pe, kome'ẽ ywy keruhũ pe har ta ke a'e muhã katu ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Sa'e! Ame'ẽ mi'u ke jande pe eme'ẽ te'e — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","A'e pandu: —Ihẽ riki ame'ẽ mi'u aja saka. Ame'ẽ ke amõ u'u rahã, myahy ym te ta. Aja rahã, ihẽ rehe jurujar katu ame'ẽ ta myahy ym ta tĩ. Uhãha namõ ixo, a'erehe myahy ym ta. Kome'ẽ ywy keruhũ pe har mi'u ke amõ u'u rahã, myahy tĩ. Jyngwéi tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","—Ihẽma'e ma'ema'eha rehe pesak tipe. Ihẽ ke Tupã muwyr ame'ẽ rehe pejurujar ym. Aja me'ẽ upa ihẽ apandu ramõ pehẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Amõ amõ ta ke ihẽ pái keruhũ muhyk ta ihẽ rehe. A'erehe ihẽ rehe jurujar katu ta. Ame'ẽ ta riki ihẽ kotyhar wan ta. Ihẽ rehe jurujar katu ame'ẽ ta pe ihẽ apandu ym te ta: “Nde ke aputar ym” aja. ");
INSERT INTO urbNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ywa ngi ihẽ awyjy ajur. Ihẽ ke muwyr. A'e putar ame'ẽ ke ihẽ ama'ema'e ajur. Ihẽ aputar ame'ẽ ke anĩ. Ame'ẽ ke ama'e ym. ");
INSERT INTO urbNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ihẽ ke muwyr. A'e putar ame'ẽ ke ihẽ ama'ema'e ta. Kuja. Awa ta ke ihẽ rehe a'e muhyk ta. A'erehe ihẽ rehe a'eta jurujar katu ta. Ame'ẽ ta mupyraraha renda pe oho ym te ta. Ihẽ amondo ym te ta. Aja a'e putar. Ame'ẽ ta manõ rahã, pe, 'ar rehe angaha uhyk rahã, upa ame'ẽ ta ke ihẽ amukwera katu ta amuhem. ");
INSERT INTO urbNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kuja ihẽ pái keruhũ putar: Ta'yr ke ihẽ. Upa ame'ẽ ke ukwa ame'ẽ ta jurujar katu ihẽ rehe. Ame'ẽ ta ke ihẽ amuhã katu ta. Pe, 'ar rehe angaha uhyk rahã, upa ame'ẽ ta ke ihẽ amukwera katu ta amuhem tĩ — aja Jesu pandu ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Kuja Jesu pandu ramõ: “Ngã mi'u aja saka ihẽ. Ywa ngi ihẽ awyjy ajur” aja a'e. A'erehe jundéu awa ta je'ẽ je'ẽ hũ ehe har. ");
INSERT INTO urbNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kuja a'eta pandu: —Mã! Ko riki Jesu. My ngi a'e uwyr my? Jakwa katu riki. Awa te'e a'e. Jose ra'yr a'e. Imãi rehe jasak. Ipái rehe aja tĩ. Jasak tĩ. A'erehe ywa ngi uwyr ym aja jakwa. Ma'ewã ywa ngi a'e wyjy uwyr aja a'e pandu my? — aja ngã je'ẽ je'ẽ hũ. ");
INSERT INTO urbNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesu pandu: —Anĩ. Peje'ẽ je'ẽ hũ ym pehẽ jupe. ");
INSERT INTO urbNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ihẽ ke ihẽ pái keruhũ muwyr. Ihẽ rehe amõ ke a'e muhyk katu rahã, ihẽ rehe a'e jurujar katu. Aja ihẽ pái muhyk ym rahã, ihẽ rehe jurujar ym ta awa. Ihẽ rehe jurujar katu ame'ẽ ta ke ihẽ amukwera katu ta amuhem. 'Ar rehe angaha uhyk rahã, amukwera katu ta amuhem. ");
INSERT INTO urbNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tupã je'ẽha pandu ame'ẽ ta kuja mupinim: “Upa awa ta ke Tupã mu'e ta” aja. —Aja ihẽ pái keruhũ rehe amõ hendu katu rahã, ihẽ rehe a'e jurujar katu tĩ. Ihẽ pái keruhũ pandu ame'ẽ ke amõ jumu'e rahã, aja tĩ. Ihẽ rehe jurujar katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ihẽ pái keruhũ rehe amõ usak. Anĩ. Aja ym ihẽ apandu. Ihẽ jõ asak katu ehe. Ingi ihẽ ajur. A'erehe ihẽ asak ehe. ");
INSERT INTO urbNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","48","—Pesarahã! Ngã mi'u aja saka ihẽ. Ihẽ rehe amõ jurujar katu rahã, myahy ym te ta ixo. Uhãha ke ihẽ ame'ẽ ta ipe, a'erehe myahy ym te ta ixo. ");
INSERT INTO urbNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ymanihar pehẽ ramũi ta ma'e ke u'u. “Mana” aja ipe. Ame'ẽ ke u'u. Awa nixói te ame'ẽ rupi ixo rahã, u'u. Pe, a'eta manõ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ngã mi'u ywa ngi wyjy uwyr, aja ihẽ apandu. Ame'ẽ ke amõ u'u rahã, manõ ym te ta. ");
INSERT INTO urbNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ywa ngi ihẽ awyjy ajur. Uhãha ke ihẽ ame'ẽ katu. Ngã mi'u aja saka ihẽ. Ame'ẽ ke amõ u'u rahã, uhã te hũ a'e. Ngã mi'u ke ihẽ ame'ẽ katu, ame'ẽ riki ihẽ rete ke. Ihẽ amanõ rahã, ngã pe ihẽ rete ihẽ ame'ẽ, ame'ẽja saka. A'erehe ihẽ rehe jurujar katu rahã, kome'ẽ ywy keruhũ pe har ta uhã te hũ ta — aja Jesu pandu ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Pe, ame'ẽ ke hendu rahã, jundéu awa ta pandu pandu hũ ngã jupe: —Myja hete ke ja'u ta my? Myja ame'ẽ ke jande pe peme'ẽ sawa'e me'ẽ ta my? — aja a'eta pandu pandu hũ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesu pandu ngã pe: —Pesarahã! Ihẽ rete ke pehẽ pe'u ym rahã, pehẽ ruhã ym te ta. Ihẽ ruwy ke pe'u ym rahã, aja tĩ. Pehẽ ruhã ym te ta tĩ. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Tupã muwyr ame'ẽ ke ihẽ. ");
INSERT INTO urbNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ihẽ rete ke amõ u'u rahã, Tupã namõ ixo ta. Ihẽ ruwy ke amõ u'u rahã, aja tĩ. Tupã namõ ixo ta tĩ. Pe, 'ar rehe angaha uhyk rahã, a'e ke ihẽ amukwera katu ta amuhem. ");
INSERT INTO urbNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ihẽ rete riki ngã mi'u te aja saka. Myahy ym te ta awa. Ihẽ ruwy riki y te aja saka tĩ. Jyngwéi ym te ta awa. ");
INSERT INTO urbNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ihẽ rete ke amõ u'u rahã, ihẽ namõ a'e juehe katu a'e ixo tĩ. Ihẽ ruwy ke amõ u'u rahã, aja tĩ. Ihẽ namõ a'e juehe katu a'e ixo tĩ. Pe, ipy'a rehe ihẽ aĩ ta. ");
INSERT INTO urbNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ihẽ ke ihẽ pái keruhũ muwyr. Uhã te hũ ame'ẽ ke a'e. A'e uhã te hũ, a'erehe aja ihẽ tĩ. Ihẽ ruhã te hũ ihẽ tĩ. Kuja tĩ. Ihẽ ruhã te hũ tĩ, a'erehe ihẽ rete ke amõ u'u rahã, aja a'e tĩ. Uhã te hũ a'e tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aja riki ngã mi'u ke. Ywa ngi wyjy uwyr ame'ẽ ke. Ame'ẽ ke pehẽ ramũi ta u'u ame'ẽ ke aja ym. Ma'e mi'u ke pehẽ ramũi u'u. Pe, a'eta manõ. Ngã mi'u ihẽ ame'ẽ, ame'ẽ ke amõ u'u rahã, uhã te hũ ta a'e — aja Jesu pandu ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Aja me'ẽ Jesu pandu. Jundéu awa tama'e jy'ariha renda pe a'e mu'e rahã, aja me'ẽ a'e pandu. Kapana'ũ ok ta pe ame'ẽ jy'ariha renda ihĩ. (Jesu rete ke amõ u'u, ame'ẽ riki jurujar katu ehe aja riki. Huwy ke amõ u'u, ame'ẽ ke aja tĩ. Jurujar katu ehe, aja tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Aja me'ẽ Jesu pandu ame'ẽ ke rehe heta jumu'eha ta hendu. Ame'ẽ ta ngi har amõ amõ ta pandu: —Mã! A'e pandu ame'ẽ ke wewe jakwa. Japutar ym — aja a'eta. ");
INSERT INTO urbNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jumu'eha ta riki je'ẽ je'ẽ hũ a'eta jupe. Ame'ẽ ke Jesu ukwa katu. Amõ pandu ym ipe. Ukwa katu. A'erehe a'e pandu: —Ihẽ apandu ame'ẽ ke peputar ym my? A'erehe ihẽ namõ peho tar ym apo my? ");
INSERT INTO urbNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yman ywa pe ihẽ axo. Apo a'ep ihẽ ajupiriha ke rehe pesak rahã, peparahy te ta my? Awa ihẽ tĩ. Tupã je'ẽha rupi ihẽ ajur. Tupã muwyr ame'ẽ ke ihẽ. ");
INSERT INTO urbNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Awa ruhãha ke Tupã'ã me'ẽ katu. Awa pyrãtãha rupi te'e ma'ema'e rahã, marã ka ym uhãha namõ ixoha. Ihẽ apandu ramõ ame'ẽ ke rehe amõ jurujar katu rahã, ipy'a rehe Tupã'ã ixo ta. Uhã te hũ ta a'e. ");
INSERT INTO urbNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pehẽ anĩ. Pehẽ ngi har amõ amõ ta jurujar ym ihẽ rehe — aja Jesu pandu. Amõ amõ ta jurujar ym ehe, aja Jesu ukwa katu. Aja te'eha ukwa katu. Huwajan ta ke Jesu rehe amõ muhyk ta werur. Ame'ẽ rehe har Jesu ukwa katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Pe, a'e pandu tĩ: —Pehẽ ngi har amõ amõ jurujar ym ihẽ rehe. A'erehe pehẽ pe ihẽ apandu: “Amõ amõ ke ihẽ rehe ihẽ pái keruhũ muhyk ym rahã, marã ka ym ihẽ rehe jurujariha” — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ame'ẽ ke rehe jumu'eha ta hendu rahã, ame'ẽ ta ngi har amõ amõ ta hijar oho. Jesu namõ a'eta wata ym te tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Pe, awa py mokõi jumu'eha ta pe Jesu pandu: —Ihẽ ke pehijar ta peho my tĩ? — aja. ");
INSERT INTO urbNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simã Petu pandu: —Anĩ. Sawa'e! Awa namõ jaho ta my? Ne jõ awa ruhãha rehe har nde erepandu katu. ");
INSERT INTO urbNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Katu te ame'ẽ ke nde, aja jakwa katu. Tupã muwyr ame'ẽ ke nde, aja jakwa katu tĩ. Ame'ẽ ke rehe jande jajurujar katu tĩ — aja Petu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesu pandu: —Awa py mokõi riki pehẽ. Pehẽ ke ihẽ amujy'ar ihẽ koty. Pehẽ ngi har amõ ixo. Satana rehe hendu katu ta. (Ãjã ramũi a'e) — aja Petu ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Satana rehe hendu katu ta, aja pandu rahã, Jun rehe har Jesu pandu. A'e riki huwajan ta ke Jesu rehe muhyk ta werur. Jun riki Simã Ikario ra'yr. Awa py mokõi jumu'eha ta ngi har peteĩ a'e. ");
INSERT INTO urbNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ajame'ẽ ke Ngariréi ywy rupi Jesu wata oho ixo. Jundéi ywy rupi a'e wata tar ym. Jywyr tar ym. A'ep pe har ta a'e ke jukwa tar katu. A'e ke jundéu awa tama'e kapitã ta jukwa tar katu. A'erehe ame'ẽ rupi oho tar ym. ");
INSERT INTO urbNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pe, jundéu awa ta mi'u matyriha ke rehe uhyk tate. Arahã kupixa rymy'y rehe xipa mujã. (Ame'ẽ wyr pe jundéu awa ta ukwer. Aja ymanihar ta ma'ema'e.) Ame'ẽ ke jundéu awa ta ukwa ukwa ta ixo apo tĩ. Ame'ẽ rehe imi'u ngã matyr. ");
INSERT INTO urbNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","5","Jesu rehe imu ta jurujar ym. A'erehe puka puka hũ ehe. A'erehe kuja pandu ipe. —Sengi eho. Jundéi ywy pe eho, Jerusarẽ ok ta pe. Aja rahã nde erema'ema'eha ke rehe jumu'eha ta usak ta. Marã ka ym amõ ma'eha, ame'ẽ ke nde erema'ema'e. Ame'ẽ ke rehe a'eta usak ta. Jande jasak ta tĩ. Ima'e ma'eha ke amõ ta pe amõ mujesak tar katu rahã, ima'e ma'eha ke mukanim ym awa. Aja nde tĩ. Emujesak katu. Aja rahã, nde ke Tupã muwyr, aja ngã ukwa ta. Jande jakwa ta tĩ — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","8","A'e pandu: —Ihẽ ahoha angaha rehe uhyk ym we rĩ. Tupã rehe ipy'a ym ame'ẽ ta parahy ihẽ rehe. Upa ma'e ka'u te'eha ke a'eta ma'ema'e ixo, aja ihẽ apandu pandu a'eta pe. A'erehe ihẽ rehe a'eta parahy. Pehẽ rehe parahy ym. A'erehe ngã mi'u matyriha pe peho tar katu rahã, pesak peho. Ihẽ ahoha angaha ke rehe uhyk ym we rĩ. A'erehe pehẽ namõ ihẽ aho ym ta — aja imu ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aja me'ẽ a'e pandu. Pe, Ngariréi ywy pe a'e pyta we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ngã mi'u matyriha rehe imu ta upa oho rahã, haikwer rupi Jesu oho tĩ. Ngã ukwa ym ha rupi oho. ");
INSERT INTO urbNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ngã mi'u matyr, ame'ẽ pe heta ngã ixo. Ame'ẽ ta rupi Jesu ke jundéu awa tama'e kapitã ta kekar kekar ixo tipe. “Myp ixo my?” aja a'eta pandu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Hetaha ta ngi har amõ amõ ta pandu pandu hũ ehe har. Amõ ta pandu: —Sawa'e katu ame'ẽ ke a'e — aja. Amõ ta pandu: —Anĩ. Muka'u te'e hũ ngã ke — aja naĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Jundéu awa tama'e kapitã ta ngi a'eta kyje. A'erehe hetaha ta ukwa ym ha rupi a'eta pandu pandu ehe har. Wewe katu pandu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ngã mi'u matyriha rehe heta ngã ukwer ta. Awa po wajar mokõi hetaha ukwer ta. Pe, mahapyrihar rehe uhyk. Pyter pe uhyk. Arahã Tupã rehe ngã jumu'eha renda keruhũ pe Jesu mu'e oho. ");
INSERT INTO urbNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Pe, jundéu awa tama'e kapitã ta pandu pandu a'eta jupe: —Mã! Myja a'e ukwa katu my? Jundéu awa tama'e paper renda pe a'e jumu'e ym riki — aja a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesu pandu: —Ihẽ atu akwa ame'ẽ ke ihẽ amu'e ym ngã pe. Ihẽ ke muwyr. A'e ukwa katu ame'ẽ ke ihẽ amu'e katu. ");
INSERT INTO urbNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ihẽ akwa ame'ẽ ke ihẽ amu'e my? Anĩ. Aja ym. Ko Tupã mujekwa ame'ẽ ke ihẽ amu'e. Tupã putar ame'ẽ ke amõ ma'ema'e rahã, kuja ukwa katu ta. Ko Tupã mujekwa ame'ẽ ke ihẽ amu'e, aja ukwa katu ta. ");
INSERT INTO urbNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Amõ ukwa ame'ẽ ke a'e pandu rahã, katu ehe har amõ pandu. Ame'ẽ ke putar. Ihẽ anĩ. Ihẽ ke muwyr. Katu ehe har amõ ta pandu. Ame'ẽ ke ihẽ aputar katu. A'erehe ihẽ apandu ame'ẽ ke jetehar te ke. Ngã ke ihẽ amuka'u te'e ym. ");
INSERT INTO urbNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Yman Tupã je'ẽha ke Moise mupinim pehẽ pe tipe. Anĩ. Pehendu ym te ehe. Moise je'ẽha rehe ihẽ riki ahendu ym, aja pekwaha naĩ. A'erehe ihẽ ke pejukwa tar katu — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Amõ amõ pandu: —Mã! Anĩ. Nde ke jukwa tar ym awa! Ãjã nde py'a rehe ihĩ nahã my, a'erehe: “Ihẽ ke pejukwa tar katu” aja nde erepandu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","A'e pandu: —Jundéu awa tama'e putu'uha 'ar rahã, marã ka ym amõ ma'eha, ame'ẽ ke ihẽ ama'ema'e. Ma'e ahy ixo ame'ẽ ke ihẽ amukatu. “Ihẽ aparaky te'e” aja pekwaha naĩ. “Ma'ewã my?” aja pepandu. ");
INSERT INTO urbNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","(Pehẽ aja tĩ. Peparaky te'e tĩ. Putu'uha 'ar rahã, ma'e ke pema'ema'e tĩ.) Jundéu awa tama'e putu'uha 'ar rahã, kurumĩ ra'yr rehe ihĩ, ame'ẽ pirer ke pejupã. (Aja rahã, jundéu awa ke a'e. Tupã usak katu ehe, aja mujekwa.) Moise mupinim aja pejupã. (Aja rahã, peparaky te'e tĩ.) Ame'ẽ jupãha ke Moise mupinim py ym. Amõ mupinim py. Ymanihar Moise ramũi riki pandu py. ");
INSERT INTO urbNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moise mupinim, ame'ẽ ke rehe pehendu katu, a'erehe kurumĩ ra'yr rehe ihĩ pirer ke pejupã. Putu'uha 'ar rahã, pejupã tĩ. (Aja rahã, peparaky te'e tĩ.) Aja rahã putu'uha 'ar rahã, amõ ke ihẽ amukatu rahã, ma'erehe peparahy ihẽ rehe my? Katu ym aja. ");
INSERT INTO urbNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ma'e ke rehe pesak, pe, pahar: “Ko katu” aja pepandu ym. Anĩ rahã, pahar: “Ko katu ym” aja pepandu ym tĩ. I'i atu te pekwa pekwa pexo. Aja rahã jõ: “Ko katu.” Anĩ rahã: “Ko katu ym” aja pepandu katu. Jetehar rupi pepandu katu — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusarẽ ok ta pe har ta ngi har amõ amõ ta pandu: —Ko riki Jesu. A'e ke jundéu awa tama'e kapitã ta jukwa tar katu. ");
INSERT INTO urbNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pesarahã! Ngã pe a'e pandu pandu ixo. Jumukanim ym a'e ixo. Je'ẽha ke muputu'u ym awa. A'e riki Tupã muwyr ame'ẽ ke, aja jundéu awa tama'e kapitã ta ukwa katu nahã my apo. ");
INSERT INTO urbNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Anĩ nahã my. Tupã muwyr ame'ẽ ke uwyr rahã, my ngi uwyr my? Ukwa ym awa. Hekoha jakwa ym. Peme'ẽ sawa'e anĩ. Hekoha jakwa katu. (Nasare ok ta pe har ke a'e.) A'erehe my ngi a'e uwyr ame'ẽ ke jakwa katu. A'erehe peme'ẽ sawa'e Tupã muwyr ame'ẽ ke a'e aja ym nahã my — aja ngã pandu pandu naĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tupã rehe ngã jumu'eha renda keruhũ pe Jesu mu'e u'am rahã, hãtã pandu ngã pe: —Ihẽ rehe har pekwa katu my? Anĩ. Pekwa ym riki. Pesarahã! Ihẽ aputar, a'erehe ihẽ ajur. Anĩ. Aja ym. Ihẽ ke amõ muwyr. Jetehar te ke pandu ame'ẽ ke a'e. Ehe har pekwa ym. ");
INSERT INTO urbNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ehe har ihẽ akwa katu. A'e ixo. Ingi ihẽ ajur, a'erehe ehe har akwa katu. Ihẽ ke a'e muwyr. (Tupã ke a'e) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","A'e pyhykiha ke jundéu awa tama'e kapitã ta manga te'e ixo. Anĩ. Pyhyk ym ngã. A'e manõha angaha ke rehe uhyk ym we rĩ. A'erehe pyhyk ym te ngã. ");
INSERT INTO urbNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ko riki heta ame'ẽ ta ngi har amõ amõ ta jurujar katu ehe. A'eta pandu: —Tupã muwyr ame'ẽ ke uwyr rahã, marã ka ym amõ ma'eha, ame'ẽ ke a'e ma'ema'e ta. Aja katu ame'ẽ ke peme'ẽ sawa'e ma'ema'e. A'erehe a'e riki Tupã muwyr ame'ẽ ke, aja jakwa katu — aja jurujar katu ehe ame'ẽ ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","“A'e riki Tupã muwyr ame'ẽ ke” aja heta ame'ẽ ta wewe pandu pandu. Ame'ẽ ke rehe parise ta hendu. A'erehe Jesu koty harõha ta ke a'eta mondo. Tupã rehe ngã jumu'eha renda keruhũ harõha ta ke ame'ẽ ta. Jundéu awa tama'e pa'ihu ta mondo tĩ. Jesu ke harõha ta pyhyk ta oho. ");
INSERT INTO urbNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesu pandu: —Pehẽ namõ ihẽ apyta we ta rĩ. Pe, ihẽ aho ta. A'engi ihẽ ke muwyr, ame'ẽ koty ihẽ ajywyr ta aho. ");
INSERT INTO urbNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ihẽ ke pekekar ta. Ihẽ ke pemahem ym te ta. Ihẽ aho ame'ẽ pe marã ka ym pehoha — aja ngã pe Jesu pandu. (“Ihẽ aho ta” aja pandu rahã: “A'e manõ ta” aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Pe, jundéu awa tama'e kapitã ta pandu pandu a'eta jupe: —Jande jamahem ym, ame'ẽ pe a'e oho ta. My ihon ta my? Amõ awa tama'e ok ta pe a'e oho ta my? A'ep jundéu awa aja ym ame'ẽ ta ke a'e mu'e ta oho my? ");
INSERT INTO urbNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A'e pandu: “Ihẽ ke pekekar ta. Ihẽ ke pemahem ym ta. Ihẽ aho ame'ẽ pe marã ka ym pehoha” aja a'e pandu. Myja ame'ẽ my? Jakwa ym jande — aja a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ngã mi'u matyriha riki upa. Weraha a'ejõhar ke. Ame'ẽ wera rahã, hury katu te ngã. Arahã Jesu pu'am. Pe, hãtã pandu ngã pe: —Jyngwéi ame'ẽ ke mã peja ihẽ koty ejur. Amõ y ke ihẽ ame'ẽ ta. Mã peja ame'ẽ ke e'u katu. ");
INSERT INTO urbNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kuja Tupã je'ẽha rehe panduha ihĩ: “Ihẽ rehe amõ jurujar katu rahã, y aja saka ipy'a ngi uhem ta. Ame'ẽ ke muxuwe katu ngã ke” aja Tupã je'ẽha rehe panduha ihĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Y aja saka ipy'a ngi uhem, aja Jesu pandu rahã, Tupã'ã ipy'a rehe ihĩ katu, ame'ẽ rehe har a'e pandu. Jurujar katu ehe ame'ẽ ta py'a pe a'e muwyr ta. Arahã ngã py'a rehe Tupã'ã ihĩ ym we rĩ. Ipái koty Jesu jywyr ym we rĩ. A'ep ipái pandu ta: “Nde katu te ame'ẽ ke nde” aja. A'ep jywyr ym we rĩ. A'erehe ngã py'a rehe Tupã'ã ihĩ ym we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesu pandu ame'ẽ ke rehe heta ngã hendu. Amõ ta pandu: —Jete. Peme'ẽ riki Tupã je'ẽha pandu ame'ẽ ke a'e. Jaharõ jaxo ame'ẽ ke a'e — aja pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Amõ ta pandu: —Anĩ. A'e riki Kirisutu. Kapitã keruhũ aja Tupã mu'am ame'ẽ ke a'e — aja. Amõ ta pandu: —Anĩ. Peme'ẽ riki ngariréi ywy pe har ke a'e. Ame'ẽ ywy ngi Kirisutu uwyr ym ta. A'erehe peme'ẽ riki Kirisutu ym a'e. ");
INSERT INTO urbNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kuja Tupã je'ẽha rehe panduha ihĩ: “Kirisutu riki Ndawi rainõ. Merẽ ok ta pe a'e u'ar ta. A'ep yman Ndawi ixo, ame'ẽ ok ta pe Kirisutu u'ar ta” aja Tupã je'ẽha rehe panduha ihĩ. —Peme'ẽ riki ngariréi ywy pe har ke a'e. A'erehe peme'ẽ riki Kirisutu ym — aja amõ ta pandu naĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jesu rehe har muka'u te'e ngã panduha. A'erehe amõ koty koty ngã ukwaha. ");
INSERT INTO urbNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Amõ ta pyhyk tar katu a'e ke. Pe, jukwa tar katu. Anĩ. Pyhyk ym we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tupã rehe ngã jumu'eha renda keruhũma'e harõha ta jywyr oho. Jundéu awa tama'e pa'ihu ta koty jywyr oho. Parise ta koty jywyr oho tĩ. Pe, harõha ta pe ame'ẽ ta pandu: —Ma'erehe perur ym Jesu ke my? — aja a'eta pe. ");
INSERT INTO urbNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Harõha ta pandu: —Mã! A'e pandu katu te. A'e je'ẽha te reko, aja pandu katu te a'e. A'erehe jarur ym — aja pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parise ta pandu: —Mã! Pehẽ ke a'e muka'u te'e rãi tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Jundéu awa tama'e kapitã ta ngi har amõ jurujar katu ehe my? Anĩ. Nixói. Parise ta ngi har aja tĩ. Jurujar ym ehe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mã! Paite ame'ẽ hetaha ta jurujar katu ehe. Anĩ. Peme'ẽ ta Moise je'ẽha ke ukwa ym. A'erehe ame'ẽ ta ke Tupã mupyrara ta — aja parise ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Parise ta ngi har amõ ixo. Her Nikonde. Amukwehe we Jesu rehe a'e usak oho. Ame'ẽ ke a'e. Inamõ ixo ame'ẽ ta pe a'e pandu: ");
INSERT INTO urbNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—“A'e jaxer” aja Jesu rehe har japandu rahã, katu ym. “Peme'ẽ riki ma'e ka'u te'eha ke ma'ema'e” aja jande japandu rahã, ehe har jahendu py ta. A'e ma'ema'eha ke jande jakwa py ta. Aja jande je'ẽha rehe panduha ihĩ. A'erehe: “A'e jaxer” aja japandu rahã, katu ym — aja Nikonde pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Pe, amõ parise ta pandu ipe, Nikonde pe: —Mã! Nde Jesu kotyhar nahã my tĩ. A'erehe ngariréi ywy pe har nde my tĩ? Tupã je'ẽha rehe esak katu! Aja rahã, nde erekwa katu ta tĩ. Esarahã! Ngariréi ywy ngi Tupã je'ẽha pandu ame'ẽ ke uwyr ym te ta. Mã! Nde ereka'u te'e — aja ipe. Arahã, parise ta jy'ariha upa. Upa pandu rahã, hok pe a'eta jywyr oho. ");
INSERT INTO urbNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pe, ywy'ã rehe Jesu oho. Ywy'ã rer Oriwéi ty. ");
INSERT INTO urbNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ku'ẽ rahã, Tupã rehe ngã jumu'eha renda keruhũ pe Jesu jywyr oho. Pytuniwe oho. Pe, heta ame'ẽ ta juramã jy'ar uwyr ehe. Pe, ame'ẽ ta ke a'e mu'e uĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Pe, amõ kũjã ke amõ ta werur ipe. Ixawa'e aja ym ame'ẽ namõ kũjã ixo rahã, amõ ta pyhyk. Ame'ẽ kũjã ke ngã werur ipe. Moise je'ẽha ke mu'e ame'ẽ ta werur. Parise ta namõ werur. Pe, heta ame'ẽ ta pyter pe kũjã ke a'eta mupu'am. ");
INSERT INTO urbNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesu pe a'eta pandu: —Sawa'e! Ngã mu'eha nde. Kome'ẽ kũjã riki ixawa'e aja ym ame'ẽ namõ ixo rahã, jande japyhyk. ");
INSERT INTO urbNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Aja rahã, kũjã ke ita pe jajukwa ta me'ẽ te'e, aja Moise mupinim. Nerahã! Myja nde erepandu my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Aja me'ẽ a'eta pandu rahã, Jesu je'ẽha ke a'eta manga tipe. Kuja. Moise mupinim, anĩ, amõ koty Jesu pandu rahã: “Moise je'ẽha rehe nde erehendu ym” aja a'eta pandu ta tipe. Anĩ. Jesu pandu ym. A'e wapyk. Pe, ywy ke ipo pe a'e mupinim uĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pe, a'eta pandu pandu we rĩ. Pe, Jesu pu'am. Ngã pe a'e pandu: —Pehẽ ngi har ma'e ka'u te'eha ke ma'e ym te, ame'ẽ ke ixo my? Ame'ẽ riki kũjã rehe ita ke ombor py. Ejukwarahã! — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Pe, a'e wapyk tĩ. Ywy ke ipo pe mupinim uĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pe, Jesu pandu ame'ẽ ke rehe a'eta hendu rahã, a'eta uhem oho ingi. Peteĩ teĩ uhem oho ingi. Tamũi ta uhem py oho. (Ma'e ka'u te'eha ke upa ngã ma'ema'e, aja upa ngã ukwa katu.) A'erehe upa katu te uhem oho ingi. Pe, Jesu jeje pyta. Kũjã amõ pyta u'am. A'eta mokõi jõ pyta. ");
INSERT INTO urbNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Pe, Jesu pu'am tĩ. Pe, kũjã pe a'e pandu: —My ixo my? Nde ke jukwa tar katu ame'ẽ ta ke. My ixo my? Pyta ym my? — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Sa'e! Nixói se — aja kũjã. —Aja ihẽ tĩ. Nde ke ihẽ amahy ym ta tĩ. Ejywyr eho. Pe, amõ we ma'e nde ereka'u te'eha ke ema'e ym tĩ — aja kũjã pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Pe, ngã pe Jesu pandu pandu tĩ: —Kome'ẽ ywy keruhũ pe weraha aja saka ihẽ. (Aja rahã, Tupã rehe har kome'ẽ ywy pe har ta pe ihẽ amujekwa.) Ihẽ kotyhar aja amõ ixo tar katu rahã, weraha namõ ixo. (Aja rahã, myja ixoha katu, ame'ẽ ke ukwa ta.) Pytuniha rupi wata ym te ta. (Aja rahã, tapijar te'e we ma'e ka'u te'eha ke ma'ema'e ym ta) — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Parise ta pandu ipe: —“Weraha aja saka ihẽ” aja nde erepandu ramõ. Nde jeje nde erepandu. A'erehe katu ym. A'erehe jetehar te ym. A'erehe nde rehe jahendu ym ta me'ẽ te'e — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","A'e pandu: —Ihẽ juehe har ihẽ apandu rahã, ame'ẽ riki jetehar te ke. My ngi ihẽ ajur my, ame'ẽ ke akwa katu. My ihẽ aho ta my, ame'ẽ ke ihẽ akwa katu tĩ. Aja rahã, awa je'ẽha rupi ko axo, aja akwa katu. A'erehe ihẽ apandu ame'ẽ ke jetehar te ke. My ngi ihẽ ajur my, ame'ẽ ke pekwa ym. My ihẽ aho ta my, ame'ẽ ke pekwa ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Sawa'e ukwa katuha namõ amõ ta rehe har pepandu: “Ko katu ame'ẽ ke” aja. Anĩ rahã: “Ko katu ym ame'ẽ ke” aja. Aja sawa'e ukwa katuha namõ pepandu. Ihẽ anĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ihẽ ke ihẽ pái keruhũ muwyr. A'e ukwa katuha namõ ihẽ apandu: “Ko katu ame'ẽ ke” aja. Anĩ rahã: “Ko katu ym ame'ẽ ke” aja ihẽ apandu. Ihẽ pái ukwa katuha namõ aja ihẽ apandu, a'erehe jetehar rupi apandu katu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mokõihar ta juja katu te pandu rahã, jetehar te ke aja pekwa. Kuja Moise mupinim ame'ẽ ke rehe panduha ihĩ: “Ma'e ke rehe har mokõihar ta juja katu te pandu katu rahã, ame'ẽ panduha riki jetehar te ke” aja panduha ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","—Ko mokõihar ta panduha riki. Ihẽ ke ihẽ pái keruhũ muwyr. A'e riki ihẽ rehe har mujekwa katu. Ko ihẽ tĩ. Ihẽ juehe har ihẽ amujekwa. Jande jamujekwa ame'ẽ ke juja katu te pandu katuha. A'erehe ihẽ rehe har ihẽ amujekwa riki jetehar te ke — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—My nde pái ixo my? — aja ngã ipe. —Ihẽ rehe har pehẽ pekwa ta tipe rahã, ihẽ pái keruhũ rehe har pekwa ta tipe tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Aja me'ẽ Tupã rehe ngã jumu'eha renda keruhũ pe Jesu pandu pandu. Ngã ke a'e mu'e rahã, aja me'ẽ pandu. Tamatarer purakar, ame'ẽ kapy pe a'e pandu. Pe, a'e ke pyhyk ym awa. Ame'ẽ angaha ke rehe uhyk ym we rĩ. (Tupã putar ame'ẽ angaha ke rehe uhyk ym we rĩ. A'erehe pyhyk ym we rĩ.) ");
INSERT INTO urbNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ngã pe Jesu pandu tĩ: —Ihẽ aho ta. Pe, ihẽ ke pekekar ta. Ihẽ rehe pejurujar ym. Peputar ym. Ma'e peka'u te'eha ke pema'ema'e. Tupã ipy'a jywyr ym pehẽ rehe. Ajaha pemanõ ta kỹ. A'erehe ihẽ aho ame'ẽ pe peho ym te ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Pe, jundéu awa ta pandu: —A'e pandu: “Ihẽ aho ame'ẽ pe peho ym te ta” aja riki. Myja ame'ẽ my? A'e jujukwa ta my? — aja ngã pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesu pandu: —Kome'ẽ ywy keruhũ pe har ta ke riki pehẽ. Ihẽ anĩ. Ywa pe har ke ihẽ. Pehẽ riki kome'ẽ ywy keruhũ pe har ta ke. A'erehe kome'ẽ ywy keruhũ pe har ta aja jõ pekwa pekwa pexo. Ihẽ anĩ. Ihẽ kome'ẽ ywy keruhũ pe har aja ym akwa akwa axo. ");
INSERT INTO urbNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","A'erehe aja ihẽ apandu pehẽ pe. Ma'e peka'u te'eha ke pema'ema'e. Tupã ipy'a jywyr ym pehẽ rehe. Ajaha pemanõ ta. Ihẽ rehe pejurujar ym rahã, ajaha pemanõ ta. “Tupã muwyr ame'ẽ ke ihẽ” aja tapijar te'e we apandu axo. Ame'ẽ rehe pejurujar ym rahã, ajaha pemanõ ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","A'eta pandu: —“Tupã muwyr ame'ẽ ke ihẽ” aja nde erepandu jande pe. Aja ym nahã my. Awa nde my? — aja Jesu pe. —Ihẽ amu'e py rahã, kuja apandu: “Tupã muwyr ame'ẽ ke ihẽ” aja pehẽ pe. Aja me'ẽ ihẽ. ");
INSERT INTO urbNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Amõ we pehẽ rehe har ihẽ apandu katu ta tipe. Ihẽ rehe pejurujar ym. A'erehe: “Pehẽ jaxer ai” aja apandu ta tipe. Anĩ. Ihẽ ke muwyr. A'e jõ ame'ẽ ke pandu katu. A'erehe ihẽ rehe pejurujar ym rahã, mã peja a'e pandu ame'ẽ ke rehe pejurujar katu — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesu ke ipái keruhũ muwyr. Ehe har Jesu pandu pandu u'am. Ame'ẽ ke jundéu awa tama'e kapitã ta ukwa ym. ");
INSERT INTO urbNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","A'erehe Jesu pandu tĩ: —Awa ihẽ tĩ. Tupã je'ẽha rupi ihẽ ajur. Myra ngã mupia ame'ẽ ke rehe ihẽ ke pejukwa rahã, pekwa ta. “Ihẽ atu ame'ẽ. Tupã muwyr ame'ẽ ke ihẽ.” Aja pekwa katu ta. Amõ we pekwa ta tĩ. Ma'e ke jeje ihẽ ama'ema'e ym. Ihẽ pái keruhũ ihẽ pe mujekwa, ame'ẽ ke jõ ihẽ apandu. Aja pekwa katu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ihẽ ke muwyr, a'e riki ihẽ namõ ixo. A'e putar ame'ẽ ke ihẽ ama'ema'e. Aja te'eha ihẽ ama'ema'e. A'erehe ihẽ ke a'e hijar ym. A'erehe jeje ihẽ axo ym ihẽ. Ihẽ namõ a'e ixo — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","A'e pandu ame'ẽ ke rehe heta ngã hendu. Ame'ẽ ta jurujar katu ehe. ");
INSERT INTO urbNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jurujar katu ehe ame'ẽ ta pe Jesu pandu. Jundéu awa ta ke ame'ẽ ta. Kuja: —Ihẽ amu'e ame'ẽ ke rehe tapijar te'e we pejurujar katu rahã, ihẽma'e jumu'eha ta te ke pehẽ. ");
INSERT INTO urbNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Aja rahã, jetehar te ke pekwa katu ta. Ame'ẽ ke pekwa rahã, pehẽ ke Tupã muhem aja saka pexo ta — aja Jesu pandu. (“Muhem” aja Jesu pandu rahã: “Tupã muhã katu ta” aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","A'eta pandu: —Mã! Jande ke muhem ta my? Ma'e ame'ẽ my? Jande riki Amarã rainõ ta ke. Amõ ta pe jande japaraky te'e ym te. Mã! “Muhem ta” ame'ẽ panduha jakwa ym — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","A'e pandu: —Pesarahã! Ma'e ka'u te'eha ke amõ ma'ema'e rahã, ame'ẽ riki ijar, ame'ẽja saka. Aja rahã, marã ka ym ma'e ka'u te'eha ma'ema'eha ke hijariha. ");
INSERT INTO urbNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Amõ pandu: “Ihẽ aputar ame'ẽ ke ihẽ ama'ema'e katu” aja marã ka ym paraky te'e ame'ẽ panduha. Anĩ. Ijar pandu ame'ẽ ke ma'ema'e ta me'ẽ te'e. Ta'yr anĩ. Je'ẽha te reko, a'erehe upa putar ame'ẽ ke a'e ma'ema'e katu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tupã ra'yr ihẽ. A'erehe pehẽ ke ihẽ amuhem ta, ame'ẽ ke akwa katu. Ma'e peka'u te'eha pema'ema'eha ngi ihẽ amuhem ta. Aja rahã, ame'ẽ pema'ema'eha ke pehijar katu ta. Pehem ame'ẽ ta ke aja pexo katu ta. (Aja rahã, pehẽ ruhã te hũ aja pexo ta.) ");
INSERT INTO urbNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Pehẽ riki Amarã rainõ ta ke. Aja ihẽ akwa katu. Ihẽ amu'e ame'ẽ ke peputar ym. A'erehe ihẽ ke pejukwa tar katu pexo. ");
INSERT INTO urbNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ma'e ke ihẽ pái keruhũ mujekwa. Ame'ẽ rehe har ihẽ apandu pandu pehẽ pe tipe. Pesarahã! Pehẽ riki pehẽ pái pandu ame'ẽ ke pema'ema'e — aja ngã pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","A'eta pandu: —Esarahã! Amarã jande ramũi ke — aja. Jesu pandu: —Pehẽ riki Amarã rainõ te rahã, Amarã aja ma'e katu ame'ẽ ke pema'ema'e ta tipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Jetehar Tupã rehe har pehẽ pe apandu. Ame'ẽ ke jõ pehẽ pe ihẽ apandu pandu tipe. Pejurujar ym. A'erehe ihẽ ke pejukwa tar katu pexo. Amarã rainõ aja ym pehẽ. Yman Tupã muwyr ame'ẽ ke a'e jukwa tar ym ixo. ");
INSERT INTO urbNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pehẽ pái ma'ema'e, ame'ẽ ke pema'ema'e pexo apo 'y — aja Jesu pandu. —Anĩ. Peteĩ jõ riki jande pái keruhũ. Tupã a'e. Amõ rehe jande py'a jamoĩ moĩ ym — aja ngã pandu ipe naĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","—Tupã riki pehẽ pái keruhũ rahã, ihẽ rehe pepy'a katu ta tipe. Tupã ngi ihẽ ajur. Ko ihẽ axo apo 'y. Ihẽ aputar, a'erehe ihẽ ajur my? Anĩ. Aja ym. Ihẽ ke a'e muwyr, a'erehe ko ihẽ ajur. ");
INSERT INTO urbNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mã! Ihẽ apandu ame'ẽ ke pekwa ym. Ihẽ apandu ame'ẽ ke rehe pehendu tar ym, a'erehe pekwa ym. ");
INSERT INTO urbNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","—Satana riki pehẽ pái. (Ãjã ramũi a'e.) Ta'yr ta ke pehẽ. A'e putar ame'ẽ ke pema'ema'e tar katu. Ngã jukwaha ke a'e. Aja te'eha riki a'e. Jetehar pandu ym te a'e, a'erehe te'e pame a'e pandu. Te'e a'e pandu rahã, aja te'eha te'e a'e. Amõ ta ke a'e mu'e. (A'erehe te'e a'eta pandu tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Te'e a'e. Ihẽ anĩ. Jetehar te Tupã rehe har ihẽ apandu. A'erehe ihẽ rehe pehẽ pejurujar ym. ");
INSERT INTO urbNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Ma'e nde ereka'u te'eha ke nde erema'e” aja ihẽ rehe har pandu ym te awa. Jetehar ihẽ apandu rahã, ma'erehe ihẽ rehe pehẽ pejurujar ym my? ");
INSERT INTO urbNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tupã je'ẽha rehe Tupã kotyhar ta hendu katu. Pehẽ anĩ. Pehẽ riki Tupã kotyhar ta ym pehẽ. A'erehe pehendu ym ehe — aja ngã pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jundéu awa tama'e kapitã ta pandu ipe: —Jetehar japandu. Nde riki samari ywy pe har aja riki. (Jande ruwajan nde.) Ãjã nde py'a rehe ihĩ. (A'erehe nde ereka'u te'e) — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","A'e pandu: —Anĩ. Nixói te ãjã ihẽ py'a rehe. Katu ihẽ pái keruhũ rehe har ihẽ apandu. Pehẽ anĩ. Ihẽ rehe har pehẽ juru ai. ");
INSERT INTO urbNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Katu ihẽ rehe har ngã pandu. Ame'ẽ panduha ke ihẽ aputar ym. Ame'ẽ panduha ke amõ riki putar. Ihẽ pái keruhũ putar. A'e riki ihẽ pe pandu ta: “Ne katu te” aja. ");
INSERT INTO urbNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mã! Pejurujar ym ihẽ rehe. Pesarahã! Ihẽ apandu ame'ẽ ke rehe amõ hendu katu rahã, a'e manõ ym ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","53","A'eta pandu: —Mã! Nde ereka'u te'e. Amarã manõ. Tupã je'ẽha pandu ame'ẽ ta manõ tĩ. Nde erepandu: “Ihẽ apandu ame'ẽ ke rehe amõ hendu katu rahã, a'e manõ ym ta” aja. Mã! Nde ereka'u te'e. A'erehe ãjã nde py'a rehe ihĩ, aja jakwa katu te apo 'y. Tupã je'ẽha rehe Amarã hendu katu. A'e riki jande ramũi. A'e manõ. I'ar koty te we nema'e pyrãtãha my? Aja rahã, nde rehe hendu katu ame'ẽ ta manõ ym ta my? Tupã je'ẽha pandu ame'ẽ ta aja tĩ. Tupã je'ẽha rehe a'eta hendu katu tĩ. A'eta manõ tĩ. Nerahã! Nde erepandu ame'ẽ ke rehe amõ hendu rahã, manõ ym ta, aja nde erepandu. Anĩ. Amarã ta 'ar koty te we nema'e pyrãtãha aja ym. A'erehe: “Manõ ym ta” aja nde erepandu ym ta me'ẽ te'e — aja ngã pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","—Pesarahã! Kuja ihẽ. Ihẽ pái ihẽ rehe har pandu ame'ẽ ke ihẽ. “Nde katu te” aja. Ame'ẽ ke ihẽ jeje ihẽ rehe har apandu rahã, ame'ẽ panduha jaxer ta tipe. Anĩ. Amõ pandu. Ihẽ pái riki ihẽ rehe har pandu: “Nde katu te” aja. A'e riki pehẽ pái keruhũ, aja pepandu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Anĩ. Ehe har pekwa ym te. Ihẽ anĩ. Akwa katu ehe har. “Ehe har ihẽ akwa ym” aja ihẽ apandu ta tipe rahã, pehẽ aja te'e ihẽ apandu ta tipe tĩ. Ehe har ihẽ akwa katu. A'e pandu ame'ẽ ke rehe ihẽ ahendu katu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Amarã riki pehẽ ramũi, aja pepandu. Kome'ẽ ywy keruhũ pe ihẽ ajur, aja a'e ukwa. A'erehe hury katu. Jete. A'e usak. Pe, hury katu tĩ — aja ngã pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jundéu awa tama'e kapitã ta pandu: —Mã! Tamũi te ym riki nde. Kuja, 50 warahy 'ar ym nde. Marã ka ym nde rehe Amarã usakiha — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","A'e pandu: —Pesarahã! Amarã nixói rahã, pete'e ihẽ axo — aja ngã pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ame'ẽ ke a'eta hendu rahã, ita ra'yr ke pyhyk. (Tupã a'e tĩ, katu ym, aja a'eta ukwaha, a'erehe jukwa ta tipe.) Ita ra'yr ombor ta ehe, Jesu rehe. Anĩ. Jesu jumukanim ngã ngi. Pe, Tupã rehe ngã jumu'eha renda keruhũ ngi uhem oho. ");
INSERT INTO urbNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesu wata oho ixo rahã, amõ sawa'e rehe a'e usak. Eha ym te ame'ẽ ke a'e. U'ar ramõ rahã, aja te'e a'e. ");
INSERT INTO urbNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jumu'eha ta pandu ipe: —Sawa'e! Ngã mu'eha nde. U'ar ramõ rahã, eha ym te ame'ẽ ke a'e. Ipái ta ma'e ka'u te'eha ke ma'ema'e, a'erehe eha ym te nahã my? Sawa'e riki ma'e ka'u te'eha ke ma'ema'e, a'erehe eha ym te nahã my? Myja my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","A'e pandu: —Anĩ. A'e riki ma'e ka'u te'eha ke ma'ema'e, a'erehe eha ym te my? Anĩ. Aja ym riki. Ipái ta aja ma'ema'e. A'erehe eha ym te my? Anĩ. Aja ym tĩ. Tupãma'e pyrãtãha ke ihẽ amujesak ta ipe. A'erehe eha ym te aja a'e u'ar. ");
INSERT INTO urbNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ihẽ ke ihẽ pái muwyr. Tupãma'e parakyha ke jama'ema'e ta me'ẽ te'e. Wera rahã, aja jama'ema'e ta me'ẽ te'e. (Aja rahã, ko ihẽ axo rahã, Tupãma'e parakyha ke jama'ema'e ta me'ẽ te'e.) Pytun rahã, paraky ym ta awa. (Aja rahã, jamanõ rahã, marã ka ym japarakyha.) ");
INSERT INTO urbNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kome'ẽ ywy keruhũ pe ihẽ axo rahã, weraha aja ihẽ. (A'ep pe har ta pe Tupã rehe har ihẽ amujekwa katu, a'erehe weraha aja ihẽ) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Aja me'ẽ upa a'e pandu rahã, ywy rehe a'e tymũ. Aja a'e mutu'um. Pe, ame'ẽ ke eha ym te ame'ẽ reha rehe a'e mujar. ");
INSERT INTO urbNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Pe, Jesu pandu ipe: —Nde reha ekutuk eho. Y kynda ame'ẽ pe ekutuk eho. Her Siroe — aja ipe. Ame'ẽ y renda rer: “Y ko werur ame'ẽ ke” aja ngã ukwa. Pe, sawa'e oho. Eha ke kutuk oho. Upa rahã, a'e jywyr. Eha katu jywyr uwyr 'y. Upa katu te ma'e ke rehe usak apo 'y. ");
INSERT INTO urbNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kwehe tamatarer ke ngã pe sawa'e pandu pandu rahã, amõ ta usak ehe. A'eta pandu. Sawa'e rok rake ixo ame'ẽ ta pandu tĩ. Kuja pandu: —Peme'ẽ riki tamatarer ke ngã pe pandu pandu uĩ ame'ẽ ke a'e — aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Amõ ta pandu: —A'e tỹ. A'e riki — aja. —Anĩ. Aja ym. A'e aja saka, amõ kome'ẽ — aja amõ ta pandu. —Jete. Ihẽ ko — aja sawa'e pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Pe, ngã pandu: —Myja nde reha katu oho apo my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Sawa'e pandu: —Amõ sawa'e ywy ke mutu'um. Her Jesu. Ame'ẽ ke ihẽ reha rehe mujar. Pe, ihẽ pe a'e pandu: “Eho. Nde reha ekutuk eho. Y kynda ame'ẽ pe ekutuk eho. Her Siroe” aja ihẽ pe. A'erehe ihẽ aho. Pe, ihẽ reha ihẽ akutuk rahã, pahar upa ma'e ke rehe ihẽ asak katu 'y — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Amõ ta pandu: —My ame'ẽ sawa'e ixo my? — aja ipe. —Ihẽ akwa ym — aja ngã pe sawa'e pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pe, parise ta koty sawa'e ke amõ ta raho. Sawa'e eha katu ramõ ame'ẽ ke raho. ");
INSERT INTO urbNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jundéu awa tama'e putu'uha 'ar rahã, ywy ke Jesu mutu'um. (Paraky te'e, aja ukwaha naĩ.) Eha ym te ame'ẽ ke a'e mukatu. ");
INSERT INTO urbNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Amõ we parise ta pandu: —Myja nde reha katu oho my? — aja ipe. Sawa'e pandu: —Ywy tu'um ke ihẽ reha rehe a'e mujar. Ihẽ reha ihẽ akutuk. Apo ihẽ asak katu ma'e ke rehe 'y — aja a'eta pe. ");
INSERT INTO urbNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Parise ta ngi har amõ ta pandu: —Aja mukatu ame'ẽ ke Tupã muwyr ym. Putu'uha 'ar rahã, a'e putu'u ym. (Paraky te'e ame'ẽja saka.) A'erehe a'e ke Tupã muwyr ym — aja pandu. —Anĩ. Ma'e ka'u te'eha ke amõ ma'e rahã, marã ka ym amõ ma'eha, ame'ẽ ke ma'e ym ta. A'e ma'e riki, a'erehe Tupã muwyr ame'ẽ ke a'e aja mujekwa — aja amõ ta pandu. Pe, a'eta amõ koty koty ukwa. ");
INSERT INTO urbNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Pe, sawa'e pe parise ta pandu tĩ: —Ne reha ke a'e mukatu, aja nde erepandu. Myja ehe har nde erekwa my? — aja ipe. Sawa'e pandu: —A'e riki Tupã je'ẽha pandu ame'ẽ ke — aja parise ta pe. ");
INSERT INTO urbNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jundéu awa tama'e kapitã ta jurujar tar ym. Sawa'e riki eha ym te ame'ẽ ke. Apo ma'e ke usak katu 'y. Ame'ẽ ke rehe a'eta jurujar ym. A'erehe ipái ta ke a'eta mujy'ar. ");
INSERT INTO urbNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Pe, ipái ta pe a'eta pandu: —Ko pehẽ ra'yr my? U'ar ramõ rahã, eha ym te ame'ẽ ke a'e, aja pepandu. Aja rahã, myja a'e usak katu apo my? — aja ipái ta pe. ");
INSERT INTO urbNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ipái ta pandu: —A'e riki jande ra'yr, aja jakwa katu. U'ar ramõ rahã, eha ym te ame'ẽ ke a'e, aja jakwa katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Myja a'e usak katu apo my, ame'ẽ ke jakwa ym. Eha ke awa mukatu my? Ame'ẽ ke jakwa ym tĩ. Pehẽ atu peme'u ipe! Sawa'e riki a'e apo. A'e pandu katu ta — aja parise ta pe ipái ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Aja me'ẽ ipái ta pandu. Jundéu awa tama'e kapitã ta ngi a'eta kyje, a'erehe aja me'ẽ a'eta pandu. “Jesu riki Tupã muwyr ame'ẽ ke” aja amõ pandu rahã, kapitã ta pandu ta: “Mã peja jy'ariha renda pe ame'ẽ ta jy'ar ym te ta apo 'y” aja. ");
INSERT INTO urbNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ame'ẽ panduha ngi ipái ta kyje. Jy'ar tar katu we rĩ. A'erehe aja a'eta pandu: “A'e riki sawa'e apo 'y. Pehẽ atu peme'u ipe” aja. ");
INSERT INTO urbNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Sawa'e ke parise ta muhyk tĩ. Mokõihar muhyk. Eha katu ramõ ame'ẽ ke. A'eta pandu ipe: —Tupã ruwa koty aja jaxo. A'erehe jetehar te ke nde erepandu katu ta me'ẽ te'e. Epandu katu apo 'y. Ame'ẽ sawa'e nde ke mukatu. A'e riki ma'e ka'u te'eha ke ma'ema'e ame'ẽ ke a'e, aja jakwa — aja parise ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Sawa'e pandu: —A'e riki ma'e ka'u te'eha ke ma'e nahã my? Aja ym nahã my? Ame'ẽ ke ihẽ akwa ym. Kuja jõ ihẽ akwa katu. Ihẽ reha ym te ihẽ. Apo upa ma'e ke rehe ihẽ asak katu 'y — aja parise ta pe. ");
INSERT INTO urbNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","A'eta pandu: —Myja a'e ma'e nde pe my? Myja nde reha a'e mukatu my? — aja sawa'e pe. ");
INSERT INTO urbNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Sawa'e pandu: —Upa ihẽ apandu pehẽ pe. Pe, pehendu ym ihẽ rehe. Ma'erehe amõ we pehendu tar katu my tĩ? Inamõ pejumu'e tar katu nahã my? — aja parise ta pe. ");
INSERT INTO urbNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pe, sawa'e pe a'eta je'ẽ je'ẽ hũ. Pandu ipe tĩ: —Nde! Nde riki ima'e jumu'eha ke nde. Jande riki Moisema'e jumu'eha ta ke jande. ");
INSERT INTO urbNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Moise namõ Tupã pandu, aja jakwa katu. Ame'ẽ sawa'e anĩ. Jakwa ym ehe har. Awa je'ẽha rupi a'e uwyr my? Jakwa ym — aja parise ta pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Sawa'e pandu: —Mãte hũ puki! Ihẽ reha ke a'e mukatu. Pe, awa je'ẽha rupi a'e uwyr my? Ame'ẽ ke pekwa ym! Mã! ");
INSERT INTO urbNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ma'e ka'u te'eha ke ma'e, ame'ẽ ke Tupã namõ pandu rahã, Tupã hendu ym ehe, aja jakwa katu. Tupã rehe amõ ipy'a katu. A'e putar ame'ẽ ke ma'e tĩ. Tupã namõ ma'e ke ame'ẽ pandu rahã, Tupã hendu katu ta ehe. Aja jakwa katu. (A'erehe ihẽ ke mukatu ame'ẽ ke rehe Tupã hendu katu, aja ihẽ akwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kome'ẽ ywy keruhũ Tupã mujã. Arahã har eha ym te ame'ẽ ke amõ mukatu. Eha ym te ame'ẽ ke u'ar. Ame'ẽ reha ke amõ mukatu. Aja me'ẽ jahendu ym te. ");
INSERT INTO urbNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Apo ame'ẽ sawa'e ke Tupã muwyr ym rahã, marã ka ym ma'e katu ame'ẽ ke a'e ma'eha — aja parise ta pe sawa'e pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","A'eta pandu ipe: —Mã! (Jaxer nde.) Nde ere'ar rahã, ma'e nde ereka'u te'eha ke nde erema'eha namõ nde erexo. Jande ke nde eremu'e tar katu rãi. Katu ym nde — aja sawa'e pe parise ta pandu. Pe, pandu ipe: —Apo ngi har jundéu awa tama'e jy'ariha renda pe nde erejy'ar ym te ta 'y — aja sawa'e pe. ");
INSERT INTO urbNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Sawa'e ke parise ta muhem mondo. Ame'ẽ ke Jesu hendu rahã, sawa'e ke kekar oho. Pe, mahem rahã, pandu ipe: —Tupã je'ẽha rupi uwyr ame'ẽ ke rehe nde erejurujar katu my? Awa a'e tĩ. Tupã je'ẽha rupi uwyr ame'ẽ ke a'e — aja Jesu ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Sa'e! Awa ame'ẽ my? Ihẽ pe emujekwa. Aja rahã, ihẽ ajurujar katu ta ehe — aja Jesu pe sawa'e pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Ko ihẽ riki ame'ẽ. Upa nde eresak ihẽ rehe! Ne namõ ihẽ apandu a'am — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Sawa'e pandu: —Sawa'e! Nde rehe ihẽ ajurujar katu — aja Jesu pe. Pe, Jesu ruwa koty a'e wapyk. Ipynarãi pe wapyk. (Aja ipy'a ke a'e moĩ moĩ ehe.) ");
INSERT INTO urbNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","(Ame'ẽ mukatuha rehe har ngã pe) Jesu pandu: —Kome'ẽ ywy keruhũ pe ihẽ ajur. A'erehe ngã rehe har ihẽ amujekwa ajur. Tupã rehe har amõ ukwa tar katu my? Ehe har amõ ukwa tar ym my? Ame'ẽ ke ngã mujekwa ta. Pesarahã! “Ehe har akwa ym” aja pandu ame'ẽ ke eha ym te, ame'ẽja saka. Ame'ẽ ta ukwa ta. Aja rahã, eha katu ame'ẽ ke a'e aja mujekwa. Amõ pandu: “Ehe har akwa katu” aja pandu naĩ. Eha katu ame'ẽ ke a'e aja ukwaha naĩ. Anĩ. “Ehe har ukwa ym” aja upa ngã pe mujekwa. Aja rahã, eha ym te ame'ẽ ke a'e aja mujekwa — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Amõ parise ta a'ep ixo. Jesu pandu ame'ẽ ke rehe a'eta hendu. A'erehe pandu ipe: —Mã! Jande riki eha ym te ame'ẽ ke jande aja nde erepandu my? — aja Jesu pe. (“Tupã rehe har jakwa” aja ame'ẽ ta ukwaha naĩ.) ");
INSERT INTO urbNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesu pandu: —Tupã rehe har pekwa, aja pepandu tipe. Pehẽ reha katu, aja pepandu tipe tĩ. Anĩ. Ihẽ rehe pehendu ym. A'erehe ma'e peka'u te'eha ke pema'ema'e pexo. A'erehe pehẽ rehe Tupã ipy'a jywyr ym, aja pexo. Pesarahã! “Ehe har jakwa ym” aja pepandu ta tipe rahã, pehẽ reha ym te aja pexo ta tipe. Aja rahã, Tupã mujekwa ta tipe. Aja rahã, pekwa katu ta tipe. Aja rahã, ma'e peka'u te'eha ke pema'ema'e. Pehẽ rehe Tupã ipy'a jywyr ta tipe, aja pexo ta tipe — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ajame'ẽ ke arapuharan ta usakiha rehe har Jesu pandu ngã pe: —Pesarahã! Arapuharan kurar rukwen rupi amõ ixe ym oho rahã, ame'ẽ riki mukanĩha ke. Amõ koty rupi ixe oho, mukanim raho. ");
INSERT INTO urbNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Hukwen rupi ixe oho, ame'ẽ riki usakiha ke. Arapuharan ta usakiha ke. ");
INSERT INTO urbNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Hukwen harõha hukwen ke pirar ta ipe. Pe, her rupi usakiha pukái rahã, arapuharan ta hendu katu. Pe, soroka pe upa muhem raho. ");
INSERT INTO urbNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Upa muhem raho rahã, usakiha riki oho py. Arapuharan ta haikwer rupi oho. Usakiha pukáiha ukwa katu. Haikwer rupi oho. ");
INSERT INTO urbNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Amõ pukái rahã, ame'ẽ raikwer rupi oho ym ta. Ijar pukáiha aja ym hendu, a'erehe haikwer rupi oho ym ta. Ujan ta oho ingi — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Myja me'ẽ arapuharan ta usakiha my, ame'ẽ ke Jesu pandu. Anĩ. (Arapuharan ta usakiha rehe har Jesu pandu rahã, juehe har a'e mujekwa uĩ.) Ame'ẽ ke parise ta ukwa ym. ");
INSERT INTO urbNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kuja Jesu pandu tĩ: —Pesarahã! Ihẽ riki arapuharan kurar rukwen aja saka. (Aja rahã, ihẽ rehe jurujar katu ame'ẽ ta riki ihẽ pái keruhũ koty oho ta.) ");
INSERT INTO urbNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Amõ usakiharan ta heta ixo. Tupã rehe har mu'eharan ta ke ame'ẽ ta. Ame'ẽ ta mukanĩha aja saka. Ihẽ nixói rahã, uwyr. Ame'ẽ ta te'e pandu. Anĩ. Ame'ẽ ta rehe arapuharan ta hendu ym. (Aja rahã, Tupã rehe jurujar katu ame'ẽ ta hendu ym.) Mu'eharan ta rehe hendu ym. ");
INSERT INTO urbNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","—Kurar rukwen aja saka ihẽ. Arapuharan ta ixe oho. (Aja rahã, ihẽ rehe jurujar katu ame'ẽ ta ke ihẽ pái keruhũ namõ ixo ta.) Pe, hukwen rupi arapuharan ta ixe oho. Uhem oho tĩ. Pe, kãpĩ heta ame'ẽ rupi u'u oho. Aja usakiha usak katu, arapuharan ta rehe. Aja ihẽ tĩ. Ihẽ kotyhar ta rehe ihẽ asak katu tĩ. A'eta rehe ahaihu katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mukanĩha uwyr rahã, mukanim ta uwyr. Arapuharan ke jukwa ta tĩ. Mai ta uwyr tĩ. Ihẽ anĩ. Ihẽ rehe jurujar katu ame'ẽ ta pe uhãha ihẽ ame'ẽ ajur. Hury katu hũ ta. ");
INSERT INTO urbNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","—Ihẽ riki usakiha katu ame'ẽ ke ihẽ. Usakiha katu ame'ẽ manõ ta. Aja rahã, arapuharan ta manõ ym ta. Aja ihẽ tĩ. Ihẽ amanõ ta. A'erehe ihẽ rehe jurujar katu ame'ẽ ta Tupã namõ ixo ta. Mupyraraha renda pe oho ym te ta. ");
INSERT INTO urbNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Amõ paraky ame'ẽ rehe arapuharan jar muhepy. Usakiha muhepyha ke. Pe, so'o jarõ ame'ẽ ke uhyk rahã, ame'ẽ parakyha ujan ta oho. Usakiha te aja ym a'e. Arapuharan ta ima'e ym. Ijar ym a'e. A'erehe ujan oho. Pe, amõ amõ arapuharan ke so'o jarõ ame'ẽ jukwa. Amõ koty koty muhãi mondo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tamatarer ke jõ parakyha putar. Arapuharan ta rehe a'e ipy'a ym, a'erehe ujan oho. ");
INSERT INTO urbNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","—Ihẽ riki usakiha katu ame'ẽ ke ihẽ. Awa ihẽ kotyhar ta my? Ame'ẽ ke akwa katu. Pe, ihẽ rehe har ihẽ kotyhar ta ukwa katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Aja ihẽ pái tĩ. Ihẽ rehe har ihẽ pái keruhũ ukwa katu. Pe, ihẽ pái keruhũ rehe har ihẽ akwa katu tĩ. Aja ihẽ kotyhar ta ke ihẽ akwa katu tĩ. Pe, ihẽ amanõ ta. A'erehe ihẽ rehe jurujar katu ame'ẽ ta ihẽ pái namõ ixo ta. ");
INSERT INTO urbNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","—Amõ arapuharan ta ixo. Aja amõ awa ta ixo. Ame'ẽ ta ke kurar pe amuxe ta me'ẽ te'e. Aja ihẽ rehe har ame'ẽ ta pe ihẽ amu'e katu ta. (Aja rahã, ame'ẽ ta ihẽ rehe hendu katu ta.) Peteĩhar henda pe johu ixo ta. Ame'ẽ ta johu peteĩ usakiha rehe jõ hendu katu ta. Ihẽ riki ame'ẽ usakiha ke. ");
INSERT INTO urbNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","—“Nde ereputar rahã, ihẽ amanõ ta” aja ihẽ pái pe apandu. A'erehe ihẽ rehe ihẽ pái keruhũ ipy'a katu. Ihẽ amanõ rahã, ihẽ ke ihẽ pái mukwera katu ta muhem tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ihẽ aputar ym rahã, ihẽ ke amõ jukwa ym ta. Ihẽ jõ aputar rahã, ihẽ ke amõ jukwa ta. Ihẽ pe ihẽ pái keruhũ pandu: “Ne jõ nde ereputar rahã, nde eremanõ ta. Pe, ne jõ nde ereputar rahã, nde erekwera katu ta erehem tĩ” — aja Jesu pandu ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesu pandu ame'ẽ ke rehe jundéu awa tama'e kapitã ta amõ koty koty ukwa. ");
INSERT INTO urbNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Amõ amõ ta pandu: —Ipy'a rehe ãjã ihĩ. A'e riki ka'u te'e. Ma'ewã pehendu ehe — aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Amõ ta pandu: —Anĩ. Ipy'a rehe ãjã ihĩ rahã, marã ka ym aja me'ẽ katu panduha. Eha ym te ame'ẽ ta reha ke marã ka ym ãjã mukatuha. (A'erehe ipy'a rehe ãjã ihĩ ym aja jakwa katu) — aja Jesu rehe har ngã pandu. Aja amõ koty koty pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pe, amõ ngã mi'u matyriha rehe uhyk oho. Arahã yman Tupã rehe ngã jumu'eha renda keruhũ mukatu. Ame'ẽ ke jundéu awa ta ukwa ukwa ixo apo. Jerusarẽ ok ta pe jumuhury katu ta ngã juehe. Rysã riki arahã. ");
INSERT INTO urbNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Pe, Tupã rehe ngã jumu'eha renda keruhũ rymy'y wyr rupi Jesu wata oho ixo. Jumu'eha renda keruhũ rymy'y rer: “Saromã.” ");
INSERT INTO urbNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Pe, jundéu awa tama'e kapitã ta juramã uwyr ehe. A'eta pandu: —Aja te'e jande ke nde eremuka'u te'e my. Jetehar te ke epandu jande pe. Nde riki Kirisutu my? Kapitã keruhũ aja Tupã mu'am ame'ẽ ke nde my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","A'e pandu: —Upa ihẽ apandu pehẽ pe tipe. Pe, pejurujar ym. Ihẽ pái keruhũ je'ẽha rupi marã ka ym amõ ma'eha, ame'ẽ ke ihẽ ama'ema'e. Ame'ẽ riki ihẽ rehe har mujekwa tipe. ");
INSERT INTO urbNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pejurujar tar ym ehe. Ihẽ kotyhar ta aja ym pehẽ. Ihẽma'e arapuharan ta aja ym pehẽ. A'erehe pejurujar ym ta. ");
INSERT INTO urbNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ihẽ apandu ame'ẽ ke rehe ihẽ kotyhar ta hendu katu. Ihẽma'e arapuharan ta aja a'eta. A'eta rehe har ihẽ akwa katu. Pe, ihẽ namõ a'eta jumu'e ixo. ");
INSERT INTO urbNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","A'eta ke ihẽ amuhã katu ta. Mupyraraha renda pe oho ym te ta. Ihẽ ngi a'eta ke mukanim ym te ta awa. ");
INSERT INTO urbNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ihẽ rehe ame'ẽ ta ke ihẽ pái keruhũ muhyk katu. (Aja rahã, ihẽ rehe ame'ẽ ta jurujar katu.) I'ar koty te we a'e pyrãtãha ke. Aja rahã, ihẽ pái ngi ihẽ kotyhar ta ke mukanim ym te ta awa tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Jande juja katu te jande — aja Jesu pandu ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pe, jundéu awa tama'e kapitã ta ita ra'yr pyhyk tĩ. Japi ta a'e ke tĩ. Aja jukwa ta tipe. ");
INSERT INTO urbNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesu pandu: —Pehẽ ruwa koty marã ka ym amõ ma'eha, ame'ẽ ke ihẽ ama'ema'e hũ. Ihẽ pái keruhũ mujekwa ihẽ pe, ame'ẽ ke ihẽ ama'ema'e hũ tĩ. My me'ẽ rehe peparahy my? Pe, ihẽ ke ita ra'yr pe pejapi tar katu my? — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Kapitã ta pandu: —Ma'e katu ame'ẽ ke nde erema'ema'e. Ame'ẽ ke rehe ita ra'yr ke jambor ym ta. Anĩ. Awa te'e nde. Tupã nde tĩ, aja nde erepandu. A'erehe nde ke ita ra'yr pe jajapi ta — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","A'e pandu: —Tupã je'ẽha rehe panduha ihĩ, ame'ẽ ke aja te'eha jetehar te ke. Aja jande jakwa katu. Ame'ẽ pe kuja Tupã pandu: “Pehẽ riki tupã ta” aja. ");
INSERT INTO urbNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","—Aja Moise je'ẽha rehe panduha ihĩ. Ima'e je'ẽha ke Tupã muwyr. Ame'ẽ ta pe a'e pandu: “Pehẽ riki tupã ta” aja. Aja rahã, ima'e je'ẽha ke Tupã muwyr, ame'ẽ ta riki tupã ta aja panduha ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Aja rahã, ame'ẽ ta 'ar koty te we ihẽ apandu katu: “Tupã ihẽ” aja. Ihẽ rehe ihẽ pái keruhũ katu usak. Kome'ẽ ywy keruhũ pe ihẽ ke a'e muwyr. Ingi ajur. A'erehe: “Tupã ra'yr ihẽ” aja ihẽ apandu katu. Aja rahã: “Nde ke jajukwa ta” aja pepandu ym ta me'ẽ te'e. ");
INSERT INTO urbNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","—Ihẽ pái keruhũ putar ame'ẽ ke ihẽ ama'ema'e ym ta tipe rahã, ihẽ rehe mã peja pejurujar ym. ");
INSERT INTO urbNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ihẽ pái keruhũ putar ame'ẽ ke ihẽ ama'ema'e katu rahã, mã peja ihẽ rehe pejurujar katu. Ihẽ rehe pejurujar ym rahã, mã peja ihẽ ama'eha rehe pesak ame'ẽ ke rehe pejurujar katu. Aja rahã, pekwa katu ta. Ihẽ pái namõ ihẽ juehe katu ihẽ axo, aja pekwa katu ta. Ihẽ namõ a'e juehe katu a'e ixo, aja pekwa katu ta tĩ — aja Jesu pandu ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Pe, amõ we tĩ. A'e pyhykiha ke jundéu awa tama'e kapitã ta manga tipe. Anĩ. Jesu oho te'e ingi. ");
INSERT INTO urbNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Pe, y ruwái koty Jesu jywyr oho tĩ. Y rer Jondã. Yman a'ep Juã mujahuk u'am. Ame'ẽ renda pe Jesu oho. A'ep a'e pyta. ");
INSERT INTO urbNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Heta ngã uhyk uwyr ehe. A'eta pandu: —Tupã rehe har Juã mujekwa rahã, marã ka ym amõ ma'eha, ame'ẽ ke Juã ma'e ym. Ko riki upa a'e pandu ame'ẽ ke jetehar te ke. Kome'ẽ rehe har Juã pandu hũ, Jesu rehe har. Ame'ẽ riki upa jetehar te ke. A'erehe Tupã muwyr ame'ẽ ke ko, aja jakwa katu — aja Jesu rehe har ngã pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Pe, a'ep heta ngã jurujar katu ehe, Jesu rehe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Pe, amõ sawa'e ixo. Her Rasaro. Mbeta ok ta pe har ke a'e. A'ep hendyr ta ixo tĩ. Her Mari. Amõ Mar. Pe, Rasaro ma'e ahyha pyhyk. ");
INSERT INTO urbNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ame'ẽ Mari riki Jesu py rehe ma'e pihe katu ame'ẽ ke jyhẽ. Pe, i'a pe juhyk. Muxikã riki. Ame'ẽ kywyr riki ma'e ahyha pyhyk, Rasaro ke. ");
INSERT INTO urbNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Pe, Jesu pe je'ẽha ke hendyr ta mondo. Kuja: “Sawa'e! Nde erepy'a katu ehe ame'ẽ ke ahy hũ ixo” aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ame'ẽ ke rehe Jesu hendu rahã, a'e pandu: —Ma'e ahyha namõ a'e ixo. Manõ ta a'e. Ame'ẽ ke rehe jõ ym. Katu Tupã rehe har amõ ta pandu ta tĩ, a'erehe ma'e ahyha ke a'e pyhyk. Pe, katu ihẽ rehe har amõ ta pandu ta tĩ. Tupã ra'yr ihẽ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Mar rehe Jesu ipy'a katu. Ianam rehe aja tĩ. Rasaro rehe aja tĩ. Ipy'a katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pe, Rasaro ahy ixo, aja Jesu hendu tipe rahã, hendu ame'ẽ pe a'e pyta we rĩ. Mokõi a'ep a'e ukwer rĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pe, jumu'eha ta pe a'e pandu: —Jundéi ywy pe jajywyr ta jaho — aja. ");
INSERT INTO urbNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","A'eta pandu: —Sawa'e! Ngã mu'eha nde. Amukwehe a'ep pe har jundéu awa tama'e kapitã ta ahy usak nde rehe. Ita ra'yr pe nde ke japi tar katu tĩ. A'ep nde erejywyr ta my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Pe, a'e pandu: —Aho ta kỹ. Warahy katu rahã, wera katu. Pe, weraha rupi amõ paraky katu. (Aja saka wera rahã, Tupã putar ame'ẽ ke ihẽ ama'ema'e ta me'ẽ te'e. Arahã, ihẽ ruwajan ta ihẽ ke jukwa ym ta.) ");
INSERT INTO urbNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pytun rahã, paraky ym awa. (Arahã, Tupã putar ame'ẽ ke ihẽ ama'ema'e ta tipe rahã, ihẽ ruwajan ta ihẽ ke jukwa ta.) A'erehe wera rahã jõ Tupã putar ame'ẽ ke ihẽ ama'ema'e ta — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pe, pandu tĩ: —Rasaro riki ukwer ou apo. Amupak ta ihẽ aho kỹ. Rasaro riki jande rehe katu ame'ẽ ke a'e — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jumu'eha ta pandu ipe: —Sawa'e! A'e ukwer ou rahã, katu ta oho — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Rasaro manõ te. Anĩ. “A'e ukwer ou” aja me'ẽ Jesu pandu. Anĩ. Rasaro ukwer te'e ou, aja jumu'eha ta ukwaha naĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","A'erehe Jesu mujekwa katu: —Rasaro manõ te. ");
INSERT INTO urbNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Inamõ ihẽ axo ym, a'erehe pehẽ pe katu tiki. Inamõ ihẽ axo ym, a'erehe ihẽ rehe pejurujar katu te we ta. Ihẽ ke Tupã muwyr aja pejurujar katu te we ta tĩ. A'erehe ihẽ rury katu axo. Jahorahã! Jasak ta jaho ehe — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Pe, amõ jumu'eha ta pe Tome pandu: —Inamõ jande johu jaho tĩ. (Jandema'e mu'eha ke ngã jukwa ta.) Inamõ jamanõ ta — aja. Ame'ẽ Tome rehe har amõ ta pandu: “Mokõihar ta ke” aja. ");
INSERT INTO urbNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mbeta ok ta pe Jesu uhyk oho rahã, Rasaro ke ngã upa mou, aja ukwa. Itakwar rupi mou. Tumeme ukwer apo. Ajaha pe Jesu uhyk oho. ");
INSERT INTO urbNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mbeta ok ta riki Jerusarẽ ok ta ngi paite ym. Mahapyr kiro met tate nahã my, paiteha ke. ");
INSERT INTO urbNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Paite ym, a'erehe heta Jerusarẽ ok ta pe har ta uhyk uwyr ehe, Mar rehe. Jundéu awa ta ke a'eta. Mari rehe aja tĩ. Uhyk uwyr ehe tĩ. Ixywyr manõ, a'erehe hendyr ta py'a ke muhury uwyr ngã. ");
INSERT INTO urbNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesu riki uwyr ixo, aja Mar hendu rahã, ixoty a'e oho. Mari anĩ. Hok pe a'e pyta. ");
INSERT INTO urbNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mar uhyk ehe rahã, a'e pandu: —Sawa'e! Se nde erexo rahã, ihẽ kywyr manõ ym ta tipe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Apo Tupã pe ma'e ke nde erepandu rahã, nde rehe a'e hendu katu ta. Aja ihẽ akwa katu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","A'e pandu: —Nde kywyr kwera katu ta uhem tĩ — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mar pandu: —'Ar rehe angaha uhyk rahã, a'e ke Tupã mukwera katu ta muhem, aja ihẽ akwa katu — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","A'e pandu ipe: —Ihẽ riki ngã ke ihẽ amukwera katu ta amuhem. Uhãha ihẽ riki ame'ẽ me'ẽ ta ngã pe. Ihẽ rehe amõ jurujar katu rahã, a'e uhã te hũ ta ixo. Manõ rahã, a'e kwera katu ta uhem tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Apo ixo ame'ẽ ta ihẽ rehe jurujar katu rahã, uhã te hũ ta ixo. Ihẽ apandu ame'ẽ ke rehe nde erejurujar katu my? — aja Mar pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mar pandu: —A'e tỹ. Sawa'e! Nde riki Tupã muwyr ame'ẽ ke, aja ihẽ akwa katu. Tupã ra'yr nde, aja akwa katu tĩ. Kome'ẽ ywy keruhũ pe uwyr ame'ẽ ke nde — aja Jesu pe Mar pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Upa Mar pandu rahã, hok pe a'e jywyr oho. Mari pe pandu. Ngã ukwa ym ha rupi pandu. —Sawa'e pete'e ixo. Nde pe pukái u'am — aja ianam pe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ame'ẽ ke rehe Mari hendu rahã, pahar pu'am. Pe, ixoty a'e oho. ");
INSERT INTO urbNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ok ta pe Jesu uhyk ym we rĩ. Mar namõ a'e pandu u'am. A'ep a'e pyta we rĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Hok pe Mari namõ amõ ta ixo. Jundéu awa ta ixo. Mari ke a'eta muhury we u'am. A'eta Mari rehe usak. A'e pu'am. Pe, pahar oho. Ame'ẽ ke rehe a'eta usak rahã, Mari raikwer rupi a'eta oho tĩ. Kangwer renda rehe Mari jixi'u oho, aja a'eta ukwaha naĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jesu ixo ame'ẽ pe Mari uhyk rahã, usak ehe, Jesu rehe. Pe, Jesu ruwa koty ipynarãi pe Mari wapyk. (Aja ipy'a ke a'e moĩ moĩ ehe.) Pe, a'e pandu: —Sawa'e! Se nde erexo rahã, ihẽ kywyr manõ ym ta tipe — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","A'e jixi'u, ame'ẽ ke rehe Jesu usak. Mari namõ jundéu awa ta uwyr tĩ. A'eta jixi'u tĩ. Ame'ẽ ke rehe a'e usak tĩ. Pe, pyrara usak ehe. Pyai a'e tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Pe, Jesu pandu: —My pehẽ pemou my? — aja. Amõ ta pandu: —Sawa'e! Esak ejurahã! — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesu jixi'u. ");
INSERT INTO urbNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","A'erehe jundéu awa ta pandu: “Mã! Pesarahã! Ipy'a katu ehe, Rasaro rehe” aja ngã. ");
INSERT INTO urbNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Amõ ta je'ẽ je'ẽ hũ: —Mã! Eha ym te ame'ẽ ke a'e mukatu. Mã! Rasaro ke a'e mukatu ta tipe my tĩ? Aja rahã, manõ ym ta tipe my tĩ. Katu ym — aja ngã ukwaha naĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesu pyai hũ tĩ. Pe, kangwer renda pe a'e oho. Itakwar keruhũ ke ame'ẽ. Itahu pe hukwen ke amõ kynda. ");
INSERT INTO urbNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesu pandu: —Itahu ke pemujere — aja ngã pe. Pe, Mar pandu. Ixywyr ambyr rendyr ke a'e. Kuja pandu: —Anĩ! Sawa'e! Inem apo! Tumeme mouha ke ukwer apo — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesu pandu: —Nde erejurujar katu rahã, Tupãma'e pyrãtãha rehe nde eresak ta kỹ. Aja nde pe ihẽ apandu — aja Mar pe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Pe, amõ ta itahu mujere. Pe, ywa rehe Jesu ma'ã. A'e pandu: —Ihẽ pái keruhũ! Ihẽ rehe nde erehendu katu, a'erehe: “Ne jõ riki katu te me'ẽ ke” aja apandu nde pe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Aja te'eha ihẽ rehe nde erehendu katu, aja ihẽ akwa katu. “Nema'e pyrãtãha ke emujesak” aja apandu apo. Aja rahã, se ixo ame'ẽ ta usak ta tĩ. Aja rahã, ihẽ ke nde eremuwyr aja se ixo ame'ẽ ta jurujar katu ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Upa pandu rahã, hãtã a'e pukái: —Rasaro! Ehem ejur! ");
INSERT INTO urbNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Pe, manõ ame'ẽ ke kwera katu uhem uwyr. Upa jupukeka namõ uhem uwyr. Ijywa rupi pukek, pan pe. Itymã rupi aja tĩ. Huwa rupi aja tĩ. Pe, Jesu pandu amõ ta pe: —Pejirar. Mã peja hok pe jywyr oho! — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mari rehe heta jundéu awa ta usak uwyr. Jesu mukwera ame'ẽ ke rehe ame'ẽ ta usak tĩ. Pe, ame'ẽ ta jurujar katu ehe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pe, amõ ta oho. Parise ta koty oho. Pe, Jesu mukwera ame'ẽ rehe har ame'ẽ ta pe a'eta pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Pe, parise ta jy'ar oho. Jundéu awa tama'e pa'ihu ta namõ johu jy'ar. Pe, pandu pandu a'eta jupe: —Myja me'ẽ peme'ẽ ma'eha jamukanim ta my? Marã ka ym amõ ma'eha. Ame'ẽ ke upa peme'ẽ sawa'e ma'ema'e ixo. ");
INSERT INTO urbNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ame'ẽ ke jamuputu'u ym rahã, upa ngã jurujar katu ta ehe my. Pe, homa awa tama'e kapitã ta parahy ta. Pe, Tupã rehe ngã jumu'eha renda keruhũ ke upa ta a'eta mai. Jande ngi jandema'e ywy ke a'eta jo'ok ta tĩ — aja a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pe, amõ pandu. Her Kái. Jundéu awa tama'e pa'i keruhũ a'e. Ame'ẽ warahy 'ar rahã, pa'i keruhũ a'e. Kuja a'e pandu: —Mã! Pekwa ym ma'e ke! ");
INSERT INTO urbNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Jande johu homa awa tama'e sonda ta jukwa rahã, katu ym. A'erehe peteĩ sawa'e manõ rahã, johu jande ke ame'ẽ ta jukwa ym ta. Ame'ẽ ke pekwa ym my — aja ngã pe Kái pandu. (“Peteĩ sawa'e manõ” aja pandu rahã: “Jesu manõ ta me'ẽ te'e” aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Aja me'ẽ a'e pandu tipe. Ukwa katu ym panduha ke. Ame'ẽ warahy 'ar rahã, jundéu awa tama'e pa'i keruhũ a'e. A'erehe Tupã mujekwa ame'ẽ ke a'e pandu katu u'am. A'erehe ukwa katu ym panduha ke. Kuja riki Jesu ke amõ ta jukwa ta. Pe, jundéu awa ta manõ ym ta. (“Manõ ym ta” aja pandu rahã: “Mupyraraha renda pe oho ym te ta” aja mujekwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jesu manõ, a'erehe jundéu awa ta jõ manõ ym ta my. Anĩ. Ame'ẽ jõ ym. Jesu manõ, a'erehe upa amõ awa ta manõ ym ta tĩ. Tupã ra'yr ta aja me'ẽ ta amõ koty koty ixo. Ame'ẽ ta manõ ym ta tĩ. Tupã ra'yr ta aja me'ẽ ta amõ koty koty ixo. Peteĩhar aja johu ngã ixo, aja mujy'ar. A'erehe Jesu manõ tĩ. (“Manõ ym ta” aja pandu rahã: “Mupyraraha renda pe oho ym te ta” aja mujekwa katu.)  ");
INSERT INTO urbNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pe, a'engi Jesu ke jundéu awa tama'e kapitã ta jukwa tar katu. “Mã peja Jesu ke jajukwa” ame'ẽ ke a'eta pandu pandu a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","A'erehe Jundéi ywy pe Jesu ixo rahã, heta ame'ẽ ta rupi a'e wata ym. Pe, amõ koty a'e oho. Amõ ok ta pe oho. Her Eparĩ ok ta. Ame'ẽ riki awa nixói te ame'ẽ rake ihĩ. A'ep jumu'eha ta namõ a'e pyta. ");
INSERT INTO urbNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pe, ngã mi'u matyriha rehe uhyk tate. Her Pasuko. Arahã jundéu awa ta imi'u matyr. Jumuhury ngã. Pe, amõ amõ ok ta ngi Jerusarẽ ok ta pe heta ngã uhyk oho. A'ep imi'u matyriha uhyk ym rahã we, jahuk ngã. Moise mupinim, aja jahuk. Aja rahã, Tupã ruwa koty ipy'a juhyk, aja saka ixo, aja ngã ukwa. ");
INSERT INTO urbNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Arahã Jesu ke ngã kekar kekar ixo tipe. Tupã rehe ngã jumu'eha renda keruhũ pe a'eta jy'ar rahã, pandu pandu ngã jupe: —Myja ta my? Kome'ẽ ngã mi'u matyriha rehe Jesu usak ym ta uwyr my? Uwyr ym ta my? — aja ngã jupe. ");
INSERT INTO urbNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jundéu awa tama'e pa'ihu ta pandu. Parise ta pandu tĩ. Kuja: —Jesu rehe pesak rahã, jande pe pepandu pejur. Aja rahã, a'e ke japyhyk ta jaho — aja ngã pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pasuko 'ar rehe uhyk ym we rĩ. Heta we ta ukwer rĩ. Kuja, awa po wajar peteĩ ukwer we ta rĩ. Pe, Mbeta ok ta pe Jesu oho. A'ep Rasaro ixo. Jesu mukwera ame'ẽ ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","A'ep pe har ta imi'u moĩ ipe. Mar amõ moĩ moĩ ngã pe. Jesu namõ ma'e u'uha renda pe Rasaro wapyk uĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Pe, ita parasuku ra'yr ke Mari pyhyk. Ta'yr riki. Kuja meiju rit ihĩ. Ma'e jumupiheha ihĩ ipe. Her na. Hepy te hũ ame'ẽ ke. Ame'ẽ ke Jesu py rehe a'e jyhẽ. Pe, jutuwa pe juhyk. Upa hok wyr rupi piheha uhãi oho. ");
INSERT INTO urbNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pe, jumu'eha ta ngi har amõ pandu. Jun Ikario ke. A'e riki Jesu ruwajan ta ke muhyk ta werur ehe. Ame'ẽ pandu: ");
INSERT INTO urbNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Mã! Jumupiheha upa mujaxer. Ame'ẽ ke muhepy rahã, tamatarer pyhyk hũ ta tipe. Pe, ame'ẽ tamatarer ke ima'e ym te ame'ẽ ta pe me'ẽ me'ẽ katu. Aja rahã katu ta tipe — aja Jun pandu. Jumupiheha hepy hũ. Kuja, 300 wera rahã, amõ paraky. Pe, ame'ẽ tamatarer pe ame'ẽ jumupiheha jo'ok katu. Hepy te hũ. ");
INSERT INTO urbNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Aja me'ẽ Jun pandu rahã, ima'e ym te ame'ẽ ta pe a'e me'ẽ tar katu. Anĩ. Aja ym. Mukanĩha a'e. A'e riki tamatarer ryru rahoha ke. Pe, ame'ẽ ngi a'e te'e jo'ok jo'ok. Pe, ima'e ke rehe jõ ma'e muhepy hepy. (Amõ we tamatarer hyru pe matyriha a'e putar, a'erehe kũjã rehe har je'ẽ je'ẽ a'e.) ");
INSERT INTO urbNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Pe, Jesu pandu: —Mã peja Mari rehe har peje'ẽ je'ẽ ym. Ihẽ rete ke amõ ta mou ta raho. (Aja riki jundéu awa ta. Amõ manõ, pe, hete ke mupihe. Pe, mou.) Ihẽ ke mou ym we rĩ. Mou ta raho. Mou ym rahã we, ihẽ ke Mari mupihe. Mou apo, ame'ẽja saka. ");
INSERT INTO urbNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ima'e ym te ame'ẽ ta pe tamatarer ke peme'ẽ me'ẽ tar katu rahã, pete'e ixo. Aja te'eha ixo. Ihẽ anĩ. Aja te'eha pehẽ namõ ihẽ axo ym ta, a'erehe kũjã ma'eha katu — aja ngã pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mbeta ok ta pe Jesu ixo, aja heta jundéu awa ta hendu. A'erehe a'eta oho ixoty. Jesu rehe a'eta usak oho. A'e ke rehe jõ ym. Rasaro rehe a'eta usak oho tĩ. Jesu mukwera ame'ẽ ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","A'erehe heta jundéu awa ta jurujar katu ehe, Jesu rehe. A'erehe jundéu awa tama'e pa'ihu ta pandu pandu a'eta jupe: “Rasaro ke jajukwa jaho” aja a'eta jupe. Jesu rehe ngã jurujar katu rahã, jundéu awa tama'e kapitã ta koty ngi a'eta tyryk oho. (Jesu kotyhar wan ta.) A'erehe Jesu rehe jyty'ym, a'erehe Rasaro ke jukwa tar katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ame'ẽ ku'ẽ rahã, Jerusarẽ ok ta pe Jesu uwyr ixo, aja heta te hũ ngã hendu. Pasuko 'ar rahã, ngã mi'u matyriha rehe ngã uwyr. Jesu uwyr ta aja ngã hendu. ");
INSERT INTO urbNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","A'erehe pindo ro aja me'ẽ ngã mondok. Ame'ẽ ke namõ Jesu rehe ngã usak oho. (Aja rahã, kapitã keruhũ jumai ym ha rupi kotur, aja mujekwa katu.) Hãtã pandu pandu oho: —Tupã riki katu te me'ẽ ke. Sawa'e te je'ẽha rupi uwyr ame'ẽ ke nde. Mã peja Tupã usak katu nde rehe. Mã peja jundéu awa tama'e kapitã keruhũ rehe a'e usak katu tĩ — aja heta ngã pandu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Pe, jumen ke Jesu mahem. Ame'ẽ 'ar pe a'e wapyk. Tupã paper rehe ymanihar panduha ihĩ, aja a'e oho. Kuja: ");
INSERT INTO urbNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Siã ok ta pe har ta! Pekyje ym pehẽ! Pehẽma'e kapitã keruhũ petur ixo apo 'y. Jumen ra'yr 'ar pe uwyr ixo” aja Tupã je'ẽha rehe panduha ihĩ. (“Siã ok ta pe har ta” aja pandu rahã: “Jerusarẽ ok ta pe har ta” aja mujekwa.) ");
INSERT INTO urbNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Arahã ame'ẽ panduha ke jumu'eha ta ukwa ym. Ywa pe Jesu ke Tupã mujywyr raho rahã, ame'ẽ panduha ihĩ ame'ẽ ke ukwa ukwa ixo. Tupã je'ẽha rehe panduha ihĩ, aja a'eta ma'ema'e ipe. Ame'ẽ ke ukwa ukwa ixo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Itakwar keruhũ ngi Rasaro ke Jesu pukái. Pe, mukwera katu. Arahã Jesu namõ heta ngã ixo. Ame'ẽ ta mukweraha rehe usak. Ame'ẽ rehe har a'eta pandu pandu ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ame'ẽ ke rehe ngã hendu. Marã ka ym amõ ma'eha, ame'ẽ ke Jesu ma'e. Aja riki. A'erehe a'eta usak ehe oho, Jesu rehe. ");
INSERT INTO urbNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pe, parise ta pandu pandu a'eta jupe: —Pesarahã! Ixoty upa ngã oho rĩ. Katu ym jande pe. Marã ka ym ixoty ngã jy'ariha jamukanĩha! — aja a'eta jupe. (A'erehe jyty'ym ehe, Jesu rehe.) ");
INSERT INTO urbNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ngã mi'u matyriha rehe amõ awa ta oho. Jundéu awa aja ym ame'ẽ ta ke. Ngere ywy pe har ta ke ame'ẽ ta. Tupã rehe ipy'a ke a'eta moĩ moĩ oho. Jerusarẽ ok ta pe moĩ moĩ oho. ");
INSERT INTO urbNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","A'ep ame'ẽ ta Siri rehe usak rahã, pandu ipe: —Sa'e! Jesu rehe jasak tar katu — aja ipe. Siri riki Mesái ok ta pe har kwe. Ame'ẽ ok ta Ngariréi ywy rehe ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pe, Siri Andere pe pandu oho. A'engi Jesu pe mokõihar ta pandu oho: —Nde rehe amõ awa ta usak tar katu — aja. ");
INSERT INTO urbNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Pe, ngã pe Jesu pandu: —Ihẽ katu te me'ẽ ke, aja Tupã mujekwa ta. (Ame'ẽ ke peme'ẽ amõ awa ta ukwa ta tĩ.) Ame'ẽ angaha ke rehe uhyk apo. Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. ");
INSERT INTO urbNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ko ihẽ apandu pehẽ pe. Ahúi aja me'ẽ ra'ĩ peteĩhar jõ ixo. Jytym ym rahã, peteĩhar jõ ixo. Jytym rahã, hywõi ta. I'a hũ ta. Aja ihẽ tĩ. Ihẽ ke amõ ta jukwa ta. Ihẽ rete mou ta raho. (Ha'ĩ jytym, ame'ẽja saka.) Pe, ihẽ akwera katu ta ahem. A'engi ihẽ rehe jurujar katu ta ngã. Pe, ihẽ kotyhar ta heta hũ ta. (I'a heta hũ, ame'ẽja saka.) ");
INSERT INTO urbNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Amõ pandu: “Jesu rehe ihẽ ajurujar katu, a'erehe amõ ta ihẽ ke jukwa tar katu. Anĩ. Amanõ tar ym. A'erehe ajurujar katuha ke ahijar ta” aja. Aja rahã, a'e te'e manõ ta kỹ. Tupã namõ ixo ym ta. Amõ pandu: “Kome'ẽ ywy keruhũ pe axo. Jesu rehe ajurujar katu, a'erehe ihẽ ke amõ ta jukwa tar katu. Jesu putar rahã, ihẽ amanõ ta. Ihẽ ajurujar katuha ke ahijar ym ta” aja. Aja rahã, Tupã namõ a'e ixo katu ta. ");
INSERT INTO urbNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ihẽma'e miasu aja amõ ixo tar katu rahã, mã peja ihẽ apandu ame'ẽ ke ema'ema'e katu. Pe, ihẽ axo ame'ẽ pe ihẽma'e miasu ta ixo ta tĩ. Ihẽ apandu ame'ẽ ke amõ ma'ema'e rahã: “A'e katu te ame'ẽ ke a'e” aja ihẽ pái keruhũ pandu ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","A'e pandu tĩ: —Apyai te ihẽ apo. Myja ta ihẽ apandu my? Kuja my: “Papa! Ihẽ apyraraha ngi ihẽ ke ejo'ok” aja my? Anĩ. Aja me'ẽ ihẽ apandu ym ta. Ihẽ apyraraha ihẽ apyhyk ta. A'erehe kome'ẽ ywy keruhũ pe ihẽ ajur. ");
INSERT INTO urbNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“Papa! Ihẽ apyrara ta axo. Ame'ẽ ke ngã ukwa rahã: ‘Tupã! Ne jõ riki katu te me'ẽ ke’ aja emupandu ngã ke” — aja ipái pe Jesu pandu. Pejot ywa ngi panduha uwyr: —“Ihẽ riki katu te me'ẽ ke” aja ngã ke ihẽ amupandu. (Aja rahã: “Ne jõ riki katu te me'ẽ ke” aja ihẽ rehe har ngã pandu ta.) Aja amõ we ihẽ amupandu ta tĩ — aja. ");
INSERT INTO urbNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A'ep heta ngã ixo. Ame'ẽ je'ẽha rehe ame'ẽ ta hendu rahã, pandu naĩ: —Mã! Tupã tyapu hũ — aja. Amõ ta pandu: —Anĩ. Tupã je'ẽha rahoha pandu ipe — aja naĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesu pandu: —Anĩ. Ihẽ pái pandu. Tupã pandu. Ihẽ ke a'e muhury tar katu, a'erehe aja me'ẽ a'e pandu my? Anĩ. Aja ym. Ihẽ ke a'e muwyr aja ihẽ rehe har pejurujar katu te we ta rĩ. A'erehe aja me'ẽ Tupã pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Apo Tupã rehe ipy'a ym ame'ẽ ta pe Tupã pandu ta: “Ma'e peka'u te'eha ke pema'e. Katu ym pehẽ” aja. Tupã rehe ipy'a ym ame'ẽ tama'e kapitã pehĩ. Satana a'e. (Ãjã ramũi a'e tĩ.) Ame'ẽma'e pyrãtãha ke Tupã muputu'u ta kỹ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pe, ihẽ ke amõ ta mujar ta mu'am. Pe, heta kome'ẽ ywy keruhũ pe har ta ke ihẽ koty amujy'ar ta — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Aja me'ẽ a'e pandu rahã, myra ngã mupia ame'ẽ ke rehe a'e manõ ta, aja mujekwa ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Pe, ngã pandu: —Tupã je'ẽha rupi uwyr ame'ẽ ke uhã te hũ, aja Tupã je'ẽha rehe panduha ihĩ. Aja jande jakwa. Tupã je'ẽha rupi uwyr ame'ẽ ke myra ngã mupia ame'ẽ ke rehe manõ ta kỹ, aja nde erepandu tĩ. Kirisutu ke a'e. (Manõ ta ame'ẽ ke uhã te hũ aja saka.) Mã! Aja rahã, awa riki Tupã je'ẽha rupi uwyr ame'ẽ ke my? Jakwa ym — aja Jesu pe ngã pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","A'e pandu: —Weraha aja pehẽ namõ axo ta. Weraha aja ihẽ. (Aja rahã, amõ we mi Tupã rehe har ihẽ amu'e katu te we ta rĩ.) A'erehe ihẽ axo rahã, ehe har pejumu'e katu te we rĩ. Pe, pytuniha aja uwyr ta. (Aja rahã, ihẽ nixói ta. Aja rahã, amu'e ym ta tĩ.) Tupã rehe har ukwa ym rahã, myja katu ame'ẽ ke amõ ma'ema'e my? Ame'ẽ ke ukwa ym. Ixoha katu ym riki. ");
INSERT INTO urbNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Weraha aja ihẽ. Ihẽ axo rahã, Tupã rehe har ihẽ amu'e rĩ. Ame'ẽ rehe pejurujar katu. (Aja rahã, ihẽ kotyhar ta aja pexo ta.) Weraha aja pexo. (Aja rahã, Tupã rehe har pejumu'e ta rĩ) — aja Jesu pandu ngã pe. Aja me'ẽ upa pandu rahã, a'e jumukanim oho ngã ngi. (Jundéu awa tamũi ta jukwa tar katu. Manõha angaha rehe uhyk ym we rĩ, a'erehe jumukanim oho.) ");
INSERT INTO urbNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jundéu awa tama'e kapitã ta ruwa koty marã ka ym amõ ma'eha, ame'ẽ ke Jesu ma'ema'e hũ tipe. A'eta jurujar ym ehe. ");
INSERT INTO urbNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Pe, yman Isai mupinim, aja me'ẽ uhyk. Isai riki ymanihar Tupã je'ẽha pandu ame'ẽ ke a'e. Kuja a'e mupinim: “Tupã! Myrandu japandu, ame'ẽ ke rehe jurujar ym awa. Ngã pe nema'e pyrãtãha nde eremujesak. Nde rehe jurujar ym awa tĩ” aja Isai mupinim. ");
INSERT INTO urbNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Pe, jundéu awa ta jurujar ym ehe. Jesu rehe har amõ we Isai mupinim. Ame'ẽ pandu ame'ẽ ke rehe uhyk apo tĩ. “Ngã ke Tupã muma'ã ym. Aja rahã, usak ym ma'e ke ngã. Ngã ukwaha ke a'e mukanim tĩ. Aja rahã, ma'e ke ukwa ym ngã tĩ. Ixoty ipy'a ke ngã muruwak ym mondo. A'erehe ame'ẽ ta ke Tupã muhã ym” aja Isai mupinim. Ame'ẽ ke rehe uhyk apo tĩ. A'erehe jundéu awa ta jurujar ym ehe, Jesu rehe. ");
INSERT INTO urbNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yman Jesu nixói rahã, Jesuma'e pyrãtãha rehe Isai usak, ame'ẽja saka. A'erehe aja me'ẽ a'e mupinim. Yman Tupã'ã mujekwa ame'ẽ ke Isai mupinim. ");
INSERT INTO urbNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Amõ ta anĩ. Heta jundéu awa tama'e kapitã ta jurujar katu ehe, Jesu rehe. Anĩ. Parise ta ngi ame'ẽ ta kyje. A'erehe ngã hetaha ta pe ame'ẽ ta pandu ym. Parise ta ukwa rahã, pandu ta: “Jy'ariha renda pe pejy'ar ym te ta apo 'y” aja. Ame'ẽ ke kapitã ta putar ym. Jy'ar katu te we ta rĩ, a'erehe: “Jesu rehe jajurujar katu” aja ngã hetaha ta pe ame'ẽ ta pandu ym. ");
INSERT INTO urbNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ame'ẽ ta ma'e putar katu tĩ. “Mã! Pehẽ katu” aja sawa'e ta pandu. Ame'ẽ ke i'ar koty te we putar katuha. “Pehẽ katu” aja Tupã pandu, ame'ẽ ke putar we. ");
INSERT INTO urbNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ngã pe hãtã Jesu pandu: —Ihẽ rehe amõ jurujar katu rahã, ihẽ rehe jõ jurujar katu. Anĩ. Ihẽ ke muwyr, ame'ẽ ke rehe a'e jurujar katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ihẽ rehe amõ usak rahã, ihẽ ke muwyr ame'ẽ ke rehe usak tĩ, ame'ẽja saka tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Weraha aja ihẽ ajur. Kome'ẽ ywy keruhũ pe ihẽ ajur. (Aja rahã, Tupã rehe har ihẽ amujekwa ajur.) Pe, ihẽ rehe jurujar katu ame'ẽ ta pytuniha aja ixo ym. (“Tupã rehe har akwa ym” aja ixo ym ta.) ");
INSERT INTO urbNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ihẽ apandu ame'ẽ ke rehe amõ hendu ym rahã, ehe har ihẽ apandu ym ta. “Ma'e nde ereka'u te'eha ke nde erema'ema'e” aja apandu ym ta. Ehe har aja me'ẽ ihẽ apandu ym ajur. Anĩ. Kuja riki. Ame'ẽ ta ke ihẽ amuhã katu ajur. ");
INSERT INTO urbNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ihẽ ke amõ putar ym. Ihẽ apandu ame'ẽ ke rehe hendu ym tĩ. A'erehe 'ar rehe angaha uhyk rahã, Tupã pandu ta. “Ma'e nde ereka'u te'eha ke nde erema'ema'e. Katu ym nde” aja ta. ");
INSERT INTO urbNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Jete. Ihẽma'e akwa katuha jõ ihẽ apandu my? Anĩ. Aja ym. Ihẽ ke ihẽ pái keruhũ muwyr. “Ma'e ihẽ apandu ta my” ame'ẽ ke a'e riki mujekwa ihẽ pe. Ihẽ pe je'ẽha muwyr tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","A'e pandu ame'ẽ ke rehe amõ hendu katu rahã, ame'ẽ ke a'e muhã katu ta. Aja ihẽ akwa katu. A'erehe ihẽ pái keruhũ pandu ame'ẽ ke ihẽ apandu katu ngã pe tĩ — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Peteĩ ukwer rahã, Pasuko 'ar rahã, imi'u matyriha rehe uhyk ta. Kome'ẽ ywy keruhũ Jesu hijar ta oho. Ipái koty oho ta. Ame'ẽ angaha rehe uhyk oho 'y. Aja a'e ukwa katu. Kome'ẽ ywy keruhũ pe ima'e jumu'eha ta ixo. Ame'ẽ ta rehe aja te'eha a'e ipy'a katu. Upa ym ame'ẽ. ");
INSERT INTO urbNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pytun ramõ rahã, ma'e ke Jesu u'u uĩ, jumu'eha ta namõ. Huwajan ta ke Jesu rehe Jun muhyk ta werur. Ame'ẽ ke Jun py'a rehe Satana upa moĩ. (Ãjã ramũi a'e.) Jun riki Simã Ikario ra'yr. ");
INSERT INTO urbNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Upa pyrãtãha ke ipái keruhũ muwyr ipe, Jesu pe. Ame'ẽ ke a'e ukwa katu. Tupã ngi a'e uwyr. Ixoty a'e jywyr ta oho, aja a'e ukwa katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pe, Jesu pu'am. Kamixa i'ar rupi har jo'ok. Iwyr rupi har pete'e ihĩ. Pe, y juhykiha ke ixu'a rupi a'e pukwar. (Aja rahã te'e paraky ame'ẽ ma'eha aja a'e ma'e.) ");
INSERT INTO urbNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Pe, mbasi pe y ke a'e moĩ. Pe, jumu'eha ta py ke a'e kutuk, y pe. Upa kutuk rahã, y juhykiha pe muxikã. ");
INSERT INTO urbNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pe, Simã Petu rehe uhyk rahã, Petu pandu: —Sawa'e! Ihẽ py nde erekutuk ta my tĩ? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—A'e tỹ. Ma'erehe nde py ihẽ akutuk ta my? Ame'ẽ ke nde erekwa ym we rĩ. A'engi nde erekwa ta — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—Mã! Ihẽ py nde erekutuk ym te ta! (Mã! Te'e paraky ame'ẽ ma'eha aja nde erema'e ym ta ihẽ pe. Ame'ẽ ke aputar ym) — aja Jesu pe. —Nde py ihẽ akutuk ym rahã, ihẽma'e jumu'eha aja ym ta nde — aja Petu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","—Sawa'e! Aja rahã, ihẽ py jõ ekutuk ym. Anĩ. Upa ekutuk. Ihẽ po ekutuk tĩ. Ihẽ ruwa aja tĩ. Ihẽ py tĩ. Upa ekutuk — aja Simã Petu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","—Y pe amõ upa jahuk rahã, xi'a ym awa. Amõ we jahuk ym ta awa. Ipy jõ a'e kutuk katu. Upa katu te pehẽ py'a juhyk, aja pexo. Anĩ. Pehẽ ngi har peteĩhar jõ ipy'a juhyk ym, aja me'ẽ ixo — aja Jesu ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Huwajan ta ke amõ muhyk ta werur ehe, ame'ẽ rehe har Jesu ukwa. A'erehe a'e pandu: “Upa katu te pehẽ py'a juhyk, aja pexo. Anĩ. Pehẽ ngi har peteĩhar jõ ipy'a juhyk ym, aja me'ẽ ixo” aja pandu. (Ame'ẽ riki Jun.)  ");
INSERT INTO urbNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jumu'eha ta py upa kutuk rahã, kamixa i'ar rupi har ke Jesu munde tĩ. Pe, henda pe a'e wapyk oho tĩ. A'e pandu a'eta pe: —Ma'erehe pehẽ py ihẽ akutuk my? Ame'ẽ ke pekwa my? Pehẽ pe amujekwa ta. ");
INSERT INTO urbNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Ngã mu'eha nde” aja ihẽ pe pepandu. “Ihẽma'e sawa'e te” aja ihẽ pe pepandu tĩ. Aja me'ẽ ko ihẽ tĩ. A'erehe aja me'ẽ pepandu rahã, katu tiki. ");
INSERT INTO urbNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pehẽma'e sawa'e te ihẽ. Pehẽma'e mu'eha ihẽ tĩ. Pehẽ py ke ihẽ akutuk ramõ. ");
INSERT INTO urbNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Te'e paraky ame'ẽ ke aja pehẽ pe ihẽ ama'e tĩ. Aja rahã, aja pema'ema'e pehẽ jupe tĩ. Te'e paraky ame'ẽ ta aja pema'ema'e pehẽ jupe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Pesarahã! Ijar 'ar koty te we miasu katuha my? Anĩ. Aja ym. Myrandu mondo ame'ẽ 'ar koty te we myrandu rahoha katuha my? Anĩ. Aja ym tĩ. (A'erehe ihẽ 'ar koty te we pehẽma'e katuha my? Anĩ. Aja ym tĩ. Aja rahã ihẽ aja pehẽ tĩ. Te'e paraky ame'ẽ ta aja pema'ema'e ta me'ẽ te'e tĩ.) ");
INSERT INTO urbNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Apo ihẽ apandu ramõ, ame'ẽ rehe har pekwa katu. Aja me'ẽ te'e paraky ame'ẽ ta aja pema'ema'e rahã, pehẽ rury katu ta pexo. ");
INSERT INTO urbNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","—Pehẽ py'a juhyk, aja apandu ramõ. Upa katu te pehẽ rehe har apandu ym. Ihẽ katu asak ame'ẽ rehe har ihẽ akwa katu. Pe, Tupã je'ẽha rehe panduha ihĩ. Aja uhyk ta me'ẽ te'e. Kuja: “Ihẽ namõ ma'e ke u'u. A'e riki ihẽ ruwajan wan uwak oho” aja panduha ihĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","—Aja uhyk ym rahã we, ame'ẽ ke ihẽ apandu pehẽ pe. Aja rahã, ame'ẽ rehe uhyk rahã, ihẽ rehe pejurujar katu ta. Ihẽ ke Tupã muwyr. Aja me'ẽ ke ihẽ. Upa akwa katu. Ame'ẽ ke rehe pehẽ pejurujar katu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ko jetehar te ke ihẽ apandu pehẽ pe. Ihẽ amondo ame'ẽ ke rehe amõ ipy'a katu rahã, ihẽ rehe a'e ipy'a katu tĩ. Ihẽ rehe amõ ipy'a katu rahã, ihẽ ke muwyr, ame'ẽ ke rehe a'e ipy'a katu tĩ. (Tupã rehe tĩ) — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesu upa pandu rahã, pyai te hũ. Kuja a'e mujekwa: —Ko jetehar te ke ihẽ apandu pehẽ pe. Pehẽ ngi har peteĩ ihẽ ruwajan ta ke ihẽ rehe muhyk ta werur — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Pe, jumu'eha ta ma'ã ma'ã a'eta juehe. Awa rehe har a'e pandu my, ame'ẽ ke a'eta ukwa ym te. ");
INSERT INTO urbNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jumu'eha ta ngi har amõ wapyk uĩ. Jesu rake wapyk uĩ. Jesu ipy'a katu ehe ame'ẽ ke a'e. ");
INSERT INTO urbNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ame'ẽ pe ipo te'e Simã Petu pandu: —Awa rehe har Jesu pandu my? Ame'ẽ ke eme'u ipe — aja Simã ipo te'e. ");
INSERT INTO urbNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Pe, ame'ẽ jumu'eha oho we ixoty, Jesu koty. Pe, pandu ipe: —Sawa'e! Awa rehe har nde erepandu my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesu pandu: —Ma'e rykwer pe mbeju ke ihẽ amururu ta. Ame'ẽ ke amõ pe ihẽ ame'ẽ ta. Ehe har ihẽ apandu — aja ipe. Pe, mbeju ke a'e pyhyk. Ma'e rykwer pe mururu. Pe, Jun pe a'e me'ẽ. A'e riki Simã Ikario ra'yr. (Aja ihẽ pe Jesu mujekwa. A'erehe Jesu rehe huwajan ta ke Jun riki muhyk ta werur, aja akwa. Ihẽ Juã.) ");
INSERT INTO urbNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pe, mbeju ke Jun pyhyk rahã, pahar ipy'a rehe Satana ihĩ. (Ãjã ramũi ke a'e.) Pe, Jesu pandu ipe, Jun pe: —Ma'e ke nde erema'e ta, ame'ẽ ke pahar ema'e eho — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","A'ep wapyk uĩ ame'ẽ ta ukwa ym. Ma'erehe aja Jesu pandu my, ame'ẽ ke ukwa ym. ");
INSERT INTO urbNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tamatarer usakiha ke Jun. A'erehe ngã mi'u matyriha rehe amõ we ma'e ke jo'ok ta me'ẽ te'e, aja Jesu pandu ipe, aja amõ amõ jumu'eha ta ukwaha a'eta jupe naĩ. Amõ ta kuja ukwaha a'eta jupe naĩ tĩ. Ima'e ym te ame'ẽ ta pe ma'e ke Jun me'ẽ me'ẽ, aja Jesu pandu ipe, aja ukwaha a'eta jupe naĩ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Mbeju ke Jun upa pyhyk rahã, a'e uhem oho. Pytun riki. ");
INSERT INTO urbNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jun uhem oho rahã, amõ jumu'eha ta pe Jesu pandu: —Awa ihẽ tĩ. Tupã je'ẽha rupi ajur. Apo ihẽ katuha ke Tupã mujekwa ta pehẽ pe. Tupã katuha ke ihẽ riki amujekwa ta tĩ. Ihẽ ma'eha namõ amujekwa ta pehẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Pe, Tupãma'e pyrãtãha ke ihẽ amujekwa rahã, apo a'e atu ihẽma'e pyrãtãha ke mujekwa ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ihẽ ra'yr ta aja pehẽ. Pehendu katurahã! Pehẽ namõ yman ym ta ihẽ axo apo 'y. Ihẽ ke pekekar ta pexo kỹ. Amukwehe jundéu awa ta pe kuja ihẽ apandu: “Ihẽ aho ame'ẽ pe peho ym ta” aja. Apo aja me'ẽ pehẽ pe ihẽ apandu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","—Panduha pyahu ame'ẽ ke ihẽ apandu pehẽ pe apo. Kuja: “Pepy'a katu pehẽ juehe pexo.” Pehẽ rehe ihẽ apy'a katu. Aja pepy'a katu ta me'ẽ te'e pehẽ juehe pexo tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Pepy'a katu pehẽ juehe pexo rahã, pehẽ riki ihẽma'e jumu'eha ta ke, aja amõ ta ukwa katu ta tĩ — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simã Petu pandu: —Sawa'e! My nde ereho ta my? — aja Jesu pe. —Ihẽ aho ame'ẽ pe marã ka ym ihẽ raikwer rupi nde erehoha. Yman te rahã, ihẽ raikwer rupi nde ereho ta kỹ tĩ — aja Petu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petu pandu ipe: —Sawa'e! Ma'erehe nde raikwer rupi ihẽ aho ym ta my? Ihẽ amanõ ta, aja rahã, nde ke amõ ta jukwa ym ta — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—Nde eremanõ ta my? Anĩ. Ko jetehar apandu nde pe. Sapukái je'ẽ ym rahã we: “Jesu rehe har akwa ym ihẽ” aja ihẽ rehe har te'e nde erepandu ta. Mahapyr aja me'ẽ te'e nde erepandu ta — aja Petu pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesu pandu tĩ: —Mã peja pepyai ym. Pejumupyai ym tĩ. Tupã rehe pejurujar katu. Aja rahã, ihẽ rehe pejurujar katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ihẽ pái renda pe mãte hũ ok ta ke ihĩ. Aja ym rahã, ihẽ apandu ym ta tipe. Mãte hũ ihĩ. A'ep upa katu te ihẽ amoĩ ta. Upa katu te ihĩ ta. ");
INSERT INTO urbNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Pe, upa rahã, ihẽ ajywyr ta. Pe, ihẽ namõ pehẽ ke ihẽ araho ta kỹ. Ihẽ axo ame'ẽ pe pexo katu ta kỹ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ihẽ aho ta, ame'ẽ pe pehoha pekwa katu pexo — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tome pandu: —Sawa'e! My nde ereho ta my? Jande jakwa ym. A'erehe jahoha jakwa ym tĩ — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesu pandu: —Ihẽ rehe amõ jurujar katu rahã jõ, a'ep oho ta. Ihẽ riki jetehar te ke Tupã rehe har ihẽ amujekwa. Ihẽ riki awa ta ke ihẽ amuhã katu ta. Ihẽ rehe amõ jurujar ym rahã, ihẽ pái renda pe oho ym te ta awa. ");
INSERT INTO urbNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Apo ihẽ rehe har pekwa katu. A'erehe ihẽ pái rehe har pekwa katu ta tĩ. Apo har kupe koty ehe har pekwa. Pesak ehe tĩ — aja jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Siri pandu ipe: —Sawa'e! Nde pái keruhũ jande pe emujesak! Aja rahã, a'ewan apo — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesu pandu: —Siri! Yman riki pehẽ namõ ihẽ axo. Ihẽ rehe har nde erekwa ym my rĩ? Ihẽ rehe amõ usak rahã, ihẽ pái rehe usak tĩ, ame'ẽja saka tĩ. A'erehe: “Nde pái keruhũ jande pe emujesak” aja ym epandu. ");
INSERT INTO urbNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ihẽ pái namõ ihẽ juehe katu ihẽ axo. Aja nde erejurujar katu my — aja Siri pe pandu. Pe, jumu'eha ta pe a'e pandu tĩ: —Pehẽ pe ihẽ apandu ame'ẽ ke ihẽ jeje apandu. Anĩ. Aja ym. Ihẽ namõ ihẽ pái ixo. A'e riki ihẽ ama'ema'eha ke mujekwa. ");
INSERT INTO urbNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ihẽ pái namõ ihẽ juehe katu ihẽ axo. Ame'ẽ ke rehe mã peja pejurujar katu. Ame'ẽ ke rehe pejurujar ym rahã, marã ka ym amõ ma'eha, ame'ẽ ke ihẽ ama'ema'e katu. (Ame'ẽ ke rehe pesak.) A'erehe mã peja ihẽ rehe pejurujar katu. ");
INSERT INTO urbNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ko ihẽ apandu pehẽ pe. Ihẽ rehe amõ jurujar katu rahã, ihẽ aja marã ka ym amõ ma'eha, ame'ẽ ke a'e ma'ema'e katu ta tĩ. Jete. Ihẽ pái koty ihẽ aho ta, a'erehe ihẽ 'ar koty te we marã ka ym amõ ma'eha, ame'ẽ ke a'e ma'ema'e katu ta tĩ. Ihẽ aho rahã, pyrãtãha ke a'e muwyr ta, a'erehe ihẽ 'ar koty te we ma'e katu ame'ẽ ke amõ ma'ema'e katu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","—Ihẽ aputar aja pepandu ame'ẽ ke ihẽ amuwyr ta pehẽ pe. Aja rahã, ihẽ páima'e pyrãtãha ke ihẽ amujesak ta pehẽ pe. Ta'yr ke ihẽ. ");
INSERT INTO urbNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ihẽ aputar aja upa ihẽ pe pepandu rahã, ihẽ amuwyr ta pehẽ pe — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","A'e pandu tĩ: —Ihẽ rehe pepy'a katu rahã, ihẽ je'ẽha rehe pehendu katu ta. ");
INSERT INTO urbNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ihẽ pái pe ihẽ apandu ta. Pe, amõ pehẽ namõ ma'e ke ma'ema'e, ame'ẽ ke a'e muwyr ta pehẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","I'ã ke ame'ẽ. Jetehar te ke Tupã rehe har a'e mujekwa ta. Pehẽ namõ aja te'eha a'e ixo ta. Tupã rehe ipy'a ym ame'ẽ ta pe a'e muwyr ym te ta. I'ã ke muwyr ym te ta. Tupã rehe har a'eta ukwa ym. A'erehe ame'ẽ ta pe muwyr ym te ta. Pehẽ anĩ. Tupã rehe har pekwa katu. Pehẽ namõ a'e ixo. Pehẽ py'a rehe a'e ihĩ katu tĩ. A'erehe ehe har pekwa katu pexo. ");
INSERT INTO urbNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","—Pehẽ jeje pexo aja ihẽ amupyta ym ta pehẽ ke. Pehẽ koty ihẽ ajywyr ta. ");
INSERT INTO urbNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Heta ym ukwer rahã, ihẽ rehe amõ ta usak ym ta. Tupã rehe ipy'a ym ame'ẽ ta usak ym te ta ihẽ rehe. Pehẽ anĩ. Ihẽ rehe pesak katu ta kỹ tĩ. Ihẽ ruhã te hũ aja ihẽ axo, a'erehe pehẽ ruhã te hũ aja pexo ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ihẽ akwera katu ahem rahã, ihẽ rehe pesak ta kỹ tĩ. Arahã ihẽ pái namõ ihẽ juehe katu ihẽ axo, ame'ẽ ke pekwa katu ta. Ihẽ namõ pehẽ juehe katu pehẽ pexo, ame'ẽ ke pekwa katu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","—Ihẽ je'ẽha ke amõ ukwa, pe, hendu katu ehe rahã, ame'ẽ riki ihẽ rehe ipy'a katu ame'ẽ ke. Ihẽ rehe amõ ipy'a katu rahã, ame'ẽ rehe ihẽ pái ipy'a katu ta tĩ. Ihẽ aja tĩ. Apy'a katu ehe tĩ. Pe, ihẽ juehe har ihẽ amujekwa katu te we ta ipe rĩ — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Pe, amõ Jun pandu. Jun Ikario ame'ẽ anĩ. Amõ Jun. Kuja pandu: —Sawa'e! Jande pe nde rehe har nde eremujekwa ta. Tupã rehe ipy'a ym ame'ẽ ta pe nde rehe har nde eremujekwa ym ta. Myja ame'ẽ my? — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","A'e pandu: —Ihẽ rehe amõ ipy'a katu rahã, ihẽ je'ẽha rehe hendu katu ta tĩ. Ihẽ pái ipy'a katu ta ehe tĩ. Ame'ẽ namõ ihẽ pái pyta ta ixo tĩ. Ihẽ aja tĩ. Ipy'a rehe apyta ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ihẽ rehe amõ ipy'a ym rahã, ihẽ je'ẽha rehe hendu ym ta tĩ. A'erehe Tupã rehe ipy'a ym ame'ẽ ta ukwa ym ihẽ rehe har. Ihẽ apandu ame'ẽ ke rehe jõ pehendu. Anĩ. Ihẽ pái pandu ame'ẽ ke rehe pehendu tĩ. Ihẽ ke a'e muwyr. ");
INSERT INTO urbNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","—Pehẽ namõ ihẽ axo rahã, upa Tupã'ã rehe har ihẽ apandu pehẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","A'e riki pehẽ namõ ma'ema'e ame'ẽ ke a'e. Upa ma'e ke a'e mu'e ta pehẽ pe. Upa ihẽ apandu ame'ẽ ke a'e mujekwa ta pehẽ pe tĩ. Ma'e ke peharái rahã, ame'ẽ ke a'e mujekwa ta pehẽ pe. Ihẽ je'ẽha rupi I'ã ke Tupã muwyr ta kỹ. A'e riki mu'e katu ta pehẽ ke. ");
INSERT INTO urbNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","—Pehẽ py'a ke ihẽ amuhury katu ta. Pekyje ym ta. Tupã rehe ipy'a ym ame'ẽ ta hury. Aja ym ihẽ amuhuryha. (I'ar koty te we ihẽ amuhury katuha.) Pejumupyai ym. (Pehẽ namõ aja te'eha ihẽ axo ta.) A'erehe pekyje ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Ihẽ aho ta. Pe, pehẽ koty ihẽ ajywyr ta” aja ihẽ apandu ame'ẽ ke rehe rehe pehendu. Ihẽ 'ar koty te we ihẽ pái katuha. A'erehe ixoty ihẽ aho ta. A'erehe mã peja pehẽ rury katu pexo. Ihẽ rehe pepy'a katu rahã, pehẽ rury katu ta. ");
INSERT INTO urbNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ame'ẽ rehe uhyk ym rahã we, ame'ẽ rehe har upa ihẽ apandu pehẽ pe. Pe, ame'ẽ rehe uhyk rahã, pejurujar katu ta ehe. ");
INSERT INTO urbNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Amõ uwyr ixo. Tupã rehe ipy'a ym ame'ẽ tama'e kapitã ke a'e. A'e uwyr ixo, a'erehe i'i atu we pehẽ namõ ihẽ apandu ym ta apo rĩ. Ihẽma'e pyrãtãha ke a'e muputu'u ym te ta. ");
INSERT INTO urbNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ihẽ pái rehe ihẽ apy'a katu, aja kome'ẽ ywy keruhũ pe har ta ukwa ta me'ẽ te'e. A'erehe upa a'e pandu ame'ẽ ke ihẽ ama'ema'e katu. Jaho. Sengi jahorahã — aja Jesu pandu jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesu pandu: —Ma'eywa'y aja ihẽ. Ame'ẽ ma'eywa'y usakiha aja ihẽ pái. ");
INSERT INTO urbNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Amõ amõ hymbo rehe i'a ym. Amõ amõ hymbo rehe i'a katu. Pe, i'a ym ame'ẽ ke usakiha mondok. Pe, i'a katu, ame'ẽ ngi hãkãjuk aja upa ma'e jaxer ame'ẽ ke mondok. Upa mukatu. Aja rahã, i'a katu te ta. Aja ihẽ kotyhar ta tĩ. Amõ amõ tama'e ixoha katu ym. Ame'ẽ ta ke ihẽ pái mupyrara ta. (Mondok ame'ẽja saka ta.) Amõ amõ tama'e ixoha katu riki. Ame'ẽ ta ixoha ke ihẽ pái mukatu ta tĩ. Aja rahã, i'ar koty te we ixo katuha. (Aja rahã i'ar koty te we ma'e katu ame'ẽ ke ma'ema'e ta.) ");
INSERT INTO urbNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ihẽ apandu ame'ẽ ke rehe pejurujar katu. A'erehe pehẽ py'a ihẽ pái juhyk. ");
INSERT INTO urbNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ma'eywa'y rehe hymbo pyta katu rahã, i'a katu ta. Aja ihẽ namõ pehẽ juehe katu pexo rahã, pexoha katu ta. (Aja rahã i'ar koty te we ma'e katu ame'ẽ ke pema'ema'e ta.) A'erehe mã peja ihẽ namõ pehẽ juehe katu pexo. ");
INSERT INTO urbNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","—Ihẽ riki ma'eywa'y aja saka. Pehẽ riki ma'eywa rymbo aja saka. Ma'eywa rymbo i'y rehe pyta rahã, i'a katu ta. Aja ym rahã, marã ka ym i'aha. Aja pehẽ tĩ. Ihẽ namõ pehẽ juehe katu pexo rahã, pexoha katu aja pexo. (Aja rahã, i'ar koty te we ma'e katu ame'ẽ ke pema'ema'e katu ta.) Aja ym rahã, marã ka ym pexo katuha. ");
INSERT INTO urbNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ma'eywa'y rehe hymbo katu ym rahã, usakiha ombor ta. Pe, ame'ẽ ke xirik ta oho. Ame'ẽ ke usakiha matyr ta. Pe, hapy ta. Upa ukwái ta. Aja pehẽ tĩ. Ihẽ namõ pehẽ juehe katu aja ym pexo rahã, ihẽ pái mupyrara ta. ");
INSERT INTO urbNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ihẽ namõ pehẽ juehe katu pexo rahã, peputar ame'ẽ ke pepandu katu ihẽ pái pe. Aja rahã, ame'ẽ ke pehẽ pe a'e muwyr ta. Ihẽ apandu ame'ẽ ke rehe pehendu katu rahã, aja ta tĩ. Muwyr ta pehẽ pe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kuja ihẽ pái katuha ke pemujesak ta. Pexoha katu rahã, ame'ẽ ke pemujesak ta. Aja rahã, ihẽma'e jumu'eha ta ke pehẽ, aja pemujekwa katu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ihẽ rehe ihẽ pái ipy'a katu. Aja pehẽ rehe ihẽ apy'a katu tĩ. A'erehe mã peja ihẽ namõ pehẽ juehe katu pexo. Aja rahã tapijar te'e we pehẽ rehe ihẽ apy'a katu. ");
INSERT INTO urbNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ihẽ pái pandu ame'ẽ ke rehe ihẽ ahendu katu. A'erehe tapijar te'e we ihẽ rehe a'e ipy'a katu. A'erehe ihẽ apandu ame'ẽ ke rehe pehendu katu rahã, tapijar te'e we pehẽ rehe ihẽ apy'a katu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","—Upa aja me'ẽ pehẽ pe ihẽ apandu. Aja rahã, ihẽ rury katuha aja pehẽ tĩ. Pehẽ rury katu te ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Pesarahã! Pehẽ pe ihẽ apandu. Pehẽ rehe ihẽ apy'a katu. Aja mã peja pepy'a katu pehẽ juehe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ehe katu ame'ẽ ta rehe amõ ipy'a katu te rahã, a'e manõ ta my. Aja rahã, ehe katu ame'ẽ ta manõ ym ta my. Amõ rahã, i'ar koty te we ipy'a katuha mujesak. Aja ipy'a katuha rehe amõma'e uhyk ym. ");
INSERT INTO urbNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Pehẽ riki ihẽ rehe katu ame'ẽ ta ke. Ihẽ apandu ame'ẽ ke rehe pehendu katu rahã, ihẽ rehe katu ame'ẽ ta ke pehẽ. A'erehe ihẽ amanõ ta. Aja rahã, mupyraraha renda pe peho ym te ta. Aja pehẽ rehe ihẽ apy'a katu te, aja amujekwa ta. ");
INSERT INTO urbNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","—Ijar ma'eha ke te'e paraky ame'ẽ ukwa ym. Pehẽ anĩ. Pekwa katu ihẽ ama'ema'eha. Ihẽ pái pandu ame'ẽ ke rehe ihẽ ahendu. Ame'ẽ ke upa katu te pehẽ pe ihẽ apandu. A'erehe upa pekwa katu. A'erehe: “Ihẽma'e parakyha ta” aja ym pehẽ pe ihẽ apandu apo 'y. Anĩ. Upa pekwa katu, a'erehe: “Ihẽ rehe katu ame'ẽ ta ke pehẽ” aja pehẽ pe ihẽ apandu ta apo 'y. ");
INSERT INTO urbNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ihẽ ke pehẽ pejo'ok. Anĩ. Aja ym. Pehẽ ke ihẽ riki ajo'ok. Pe, ihẽ apandu: “Mã peja katu pexo. Ma'e katu ame'ẽ ke pema'ema'e. Ame'ẽ ke ngã harái ym ta” aja. —Pe, ihẽ je'ẽha rupi ihẽ pái pe ma'e ke pepandu rahã, ame'ẽ ke a'e muwyr katu ta pehẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Pe, kuja pehẽ pe ihẽ apandu: “Mã peja pepy'a katu pehẽ juehe pexo” — aja Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jesu pandu tĩ: —Tupã rehe ipy'a ym ame'ẽ ta ixo. Pehẽ rehe ame'ẽ ta ahy te'e usak rahã, kuja pekwa pekwa pexo. Ihẽ rehe ame'ẽ ta ahy te'e usak py. ");
INSERT INTO urbNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Pehẽ riki ame'ẽ ta kotyhar ta rahã, pehẽ rehe ame'ẽ ta ipy'a katu ta tipe tĩ. Ame'ẽ ta ngi har pehẽ ke ihẽ ajo'ok. A'erehe ame'ẽ ta kotyhar ta aja ym pehẽ apo 'y. A'erehe pehẽ rehe ame'ẽ ta ahy te'e usak. ");
INSERT INTO urbNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Amukwehe ihẽ apandu ame'ẽ ke pekwa pekwa pexo. Kuja: “Miasu riki ijar 'ar koty te we katuha aja ym” aja ihẽ apandu. Ihẽ riki pehẽ jar ke. A'erehe ihẽ ke amõ ta mupyrara rahã, miasu ta ke mupyrara ta tĩ. Aja rahã, pehẽ ke ame'ẽ ta mupyrara ta tĩ. Ihẽ apandu ame'ẽ ke rehe ame'ẽ ta hendu katu rahã, pepandu ame'ẽ ke rehe ame'ẽ ta hendu katu ta tipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ihẽ kotyhar ta ke pehẽ. A'erehe pehẽ ke amõ ta mupyrara ta tĩ. Pehẽ rehe hendu ym ta tĩ. Ihẽ ke muwyr ame'ẽ rehe har ame'ẽ ta ukwa ym, a'erehe pehẽ ke mupyrara ta. ");
INSERT INTO urbNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Tupã rehe ipy'a ym ame'ẽ ta ma'e ka'u te'eha ke ma'ema'e. Pe, ihẽ ajur ym rahã, ihẽ amu'e ym rahã, ame'ẽ ta ke Tupã mupyrara ym ta tipe. Anĩ. Ihẽ ajur riki. Amu'e tĩ. A'erehe: “Jande jakwa ym ha rupi ma'e jaka'u te'eha ke jama'ema'e” aja marã ka ym ame'ẽ ta panduha apo 'y. ");
INSERT INTO urbNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ihẽ rehe amõ ahy te'e usak rahã, ihẽ pái rehe aja tĩ. Ahy te'e usak ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tupã rehe ipy'a ym ame'ẽ ta ka'u te'eha ke ma'ema'e. A'erehe ame'ẽ ta pe Tupã pandu: “A'e tỹ. Ma'e ka'u te'eha ke ma'ema'e” aja. Ame'ẽ ta ruwa koty marã ka ym amõ ma'eha, ame'ẽ ke ihẽ ama'ema'e tipe. Ame'ẽ ke rehe usak tipe. Anĩ. Ihẽ rehe ahy te'e usak. Aja ihẽ ama'ema'e ym rahã, ame'ẽ ta ke Tupã mupyrara ym ta tipe. Anĩ. Usak riki. Pe, ihẽ rehe ame'ẽ ta ahy te'e usak. Ihẽ pái rehe aja tĩ. Ahy te'e usak tĩ. A'erehe ihẽ pái mupyrara ta. ");
INSERT INTO urbNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Aja Tupã je'ẽha ke amõ mupinim. Aja me'ẽ uhyk. Kuja: “Ihẽ rehe amõ ta ahy te'e usak.” ");
INSERT INTO urbNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","—Pehẽ namõ ma'e ke ma'ema'e, ame'ẽ uwyr ta. Tupã'ã ke a'e. Ihẽ pái ngi uwyr ta. Jetehar te ke a'e mu'e ta pehẽ ke. Ihẽ pái ngi a'e ke ihẽ amuwyr ta. Ihẽ rehe har a'e mujekwa ta. ");
INSERT INTO urbNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Pehẽ aja tĩ. Ngã ke amu'e py rahã har ihẽ namõ pexo. A'erehe ihẽ rehe har pepandu pandu ta ngã pe tĩ — aja Jesu pandu jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","A'e pandu tĩ: —Upa aja me'ẽ ihẽ apandu pehẽ pe. Aja rahã, ihẽ rehe pejurujar katuha ke pehijar ym ta. ");
INSERT INTO urbNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pe, jundéu awa tama'e kapitã ta pandu ta: “Jundéu awa tama'e jy'ariha renda pe pejy'ar ym te ta apo 'y” aja. Aja pehẽ ke a'eta muhem ta ingi. Pe, pehẽ ke amõ ta jukwa ta. Ame'ẽ angaha ke rehe uhyk ta tĩ. Pehẽ ke amõ ta jukwa rahã, Tupã putar ame'ẽ ke ame'ẽ ta ma'ema'e, aja ame'ẽ ta ukwa a'eta jupe naĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Aja me'ẽ pehẽ pe a'eta ma'ema'e ta tĩ. Ihẽ rehe har a'eta ukwa ym. Ihẽ pái rehe har aja tĩ. Ukwa ym tĩ. A'erehe aja me'ẽ pehẽ pe a'eta ma'ema'e ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pepyraraha rehe har ihẽ apandu. Aja rahã, ame'ẽ angaha ke rehe uhyk rahã, ihẽ apandu ame'ẽ ke pekwa pekwa ta pexo. Peta kỹ. Aja rahã tapijar te'e we ihẽ rehe pejurujar katu rĩ — aja jumu'eha ta pe Jesu pandu. A'e pandu tĩ: —Pehẽ ke ihẽ amu'e py rahã, pehẽ pepyraraha rehe har ihẽ apandu ym. Pehẽ namõ ihẽ axo, a'erehe ame'ẽ rehe har ihẽ apandu ym. ");
INSERT INTO urbNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Apo anĩ. Apo ihẽ aho ta. Ihẽ ke muwyr. Ixoty ihẽ aho ta kỹ. “My nde ereho ta my?” aja ihẽ pe pehẽ ngi har pandu ym ta awa. Pekwa katu, a'erehe pandu ym ta awa. ");
INSERT INTO urbNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ihẽ aho ta, ame'ẽ rehe har apandu. A'erehe pepyai te hũ. ");
INSERT INTO urbNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pesarahã! Ihẽ aho rahã, pehẽ pe katu tiki. Ihẽ aho ym rahã, pehẽ namõ ma'e ke ma'ema'e, ame'ẽ uwyr ym ta pehẽ rehe. Tupã'ã ke a'e. Pe, ihẽ aho rahã, pehẽ pe a'e ke ihẽ amondo ta. ");
INSERT INTO urbNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pe, a'e uwyr rahã, Tupã rehe ipy'a ym ame'ẽ ta pe ma'e ke a'e mujekwa ta. Kuja mujekwa ta. “Ma'e riki ka'u te'eha ma'ema'eha my? Ame'ẽ ke jande jakwa katu” aja Tupã rehe ipy'a ym ame'ẽ ta pandu. Anĩ. Ukwaha jupe naĩ, aja Tupã'ã mujekwa ta. Ma'e aka'u te'eha ama'eha ke nixói te ihẽ pe, aja mujekwa ta tĩ. Ma'e ka'u te'eha ma'ema'eha ke Tupã rehe ipy'a ym ame'ẽ ta ma'ema'e. Ame'ẽ ta pe Tupã pandu ta: “Mupyraraha renda pe peho ta kỹ” aja. Ame'ẽ ke Tupã rehe ipy'a ym ame'ẽ ta pe Tupã'ã mujekwa ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ihẽ rehe Tupã rehe ipy'a ym ame'ẽ ta jurujar tar ym. Pandu tĩ: “Japutar ym a'e ke” aja. A'erehe kuja Tupã'ã mujekwa ta. “Ma'e riki ka'u te'eha ma'ema'eha my? Ame'ẽ ke jakwa katu” aja ame'ẽ ta pandu. Anĩ. Ukwaha jupe naĩ, aja Tupã'ã mujekwa ta. ");
INSERT INTO urbNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ihẽ pái koty ihẽ aho ta. A'erehe ma'e aka'u te'eha ama'eha ke nixói te ihẽ pe, aja a'e mujekwa ta tĩ. Ihẽ pái koty ihẽ aho ta. Pe, ihẽ rehe pesak ym ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tupã rehe ipy'a ym ame'ẽ tama'e kapitã ixo. Tupã upa pandu: “Nde katu ym. Nde ke amupyrara hũ ta kỹ” aja. A'erehe Tupã rehe ipy'a ym ame'ẽ ta ke a'e mupyrara hũ ta tĩ. Aja me'ẽ Tupã'ã mujekwa ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","—Amõ we pehẽ pe ihẽ apandu tar katu tipe. Pekwa ym we ta rĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pe, Tupã'ã uwyr rahã, upa jetehar te ke pehẽ pe a'e mu'e ta. Jetehar te mu'eha ke a'e. A'e je'ẽha ke a'e pandu ta my? Anĩ. Aja ym. A'e hendu ame'ẽ ke pehẽ pe a'e mu'e ta. Tupã ngi hendu ame'ẽ ke mu'e ta. Pe, ma'e ke uhyk ym we rĩ. (Yman rahã, ma'e ke uhyk ta.) Ame'ẽ ke a'e mujekwa ta pehẽ pe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Katu ihẽ rehe har a'e pandu ta. Ihẽ apandu tar katu ma'e ke, ame'ẽ ke a'e riki mujekwa ta pehẽ pe. ");
INSERT INTO urbNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Upa ihẽ pái pandu ame'ẽ ke ihẽ apandu tĩ. A'erehe aja ihẽ apandu pehẽ pe. Ihẽ apandu ame'ẽ ke I'ã mujekwa ta pehẽ pe tĩ, aja ihẽ apandu — aja Jesu pandu jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","A'e pandu tĩ: —I'i atu rahã, ihẽ rehe pesak ym ta. Pe, amõ we mi rahã, ihẽ rehe pesak ta kỹ tĩ — aja jumu'eha ta pe. ");
INSERT INTO urbNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Pe, amõ ta jupandu pandu a'eta jupe: —Mã! A'e pandu: “I'i atu rahã, ihẽ rehe pesak ym ta. Pe, amõ we mi rahã, ihẽ rehe pesak ta kỹ tĩ” aja jande pe. Myja me'ẽ ame'ẽ my? A'e pandu tĩ: “Ihẽ pái koty ihẽ aho ta, a'erehe ihẽ rehe pesak ym ta” aja. Myja me'ẽ ame'ẽ my tĩ? (Mã! Jakwa ym.) ");
INSERT INTO urbNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Amõ we mi” aja a'e pandu. Myja me'ẽ ame'ẽ my? A'e panduha jakwa ym — aja jumu'eha ta pandu a'eta jupe. ");
INSERT INTO urbNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ame'ẽ rehe har jumu'eha ta pandu tar katu ipe, aja Jesu ukwa katu. A'erehe a'e pandu: —Ihẽ apandu pehẽ pe. “I'i atu rahã, ihẽ rehe pesak ym ta. Pe, amõ we mi rahã ihẽ rehe pesak ta kỹ tĩ” aja pehẽ pe. Ame'ẽ rehe har pepandu pandu pehẽ jupe my? ");
INSERT INTO urbNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ko ihẽ apandu pehẽ pe. Ihẽ ke amõ ta jukwa rahã, pejixi'u hũ ta. Pe, Tupã rehe ipy'a ym ame'ẽ ta hury katu ta. Pehẽ anĩ. Pehẽ pepyai tipe. A'engi pehẽ rury katu ta tĩ. Ihẽ rehe pesak rahã, pehẽ rury katu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","—Kũjã imembyr u'ar tate rahã, ahy ta. U'ar rahã, a'e hury katu. Imembyr ra'yr u'ar, a'erehe hury katu. A'erehe ahyha upa harái. ");
INSERT INTO urbNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Aja ta pehẽ tĩ. Ihẽ ke amõ ta jukwa ta. A'erehe pepyai hũ apo. A'engi pehẽ rehe ihẽ asak ta tĩ. Ihẽ akwera katu ahem rahã, asak ta pehẽ rehe tĩ. (Ihẽ rehe pesak katu ta tĩ.) Aja rahã, pehẽ rury katu te ta tĩ. Ame'ẽ ke pehẽ ngi mukanim ym te ta awa. ");
INSERT INTO urbNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","—Ihẽ pái koty ihẽ ajywyr rahã, ma'e ke ihẽ pe pepandu ym ta. Anĩ. Ihẽ pái pe pepandu ta. Ko ihẽ apandu pehẽ pe. Ihẽ je'ẽha rupi ma'e ke ihẽ pái pe pepandu rahã, upa pehẽ pe a'e muwyr ta kỹ. ");
INSERT INTO urbNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ihẽ je'ẽha rupi ma'e ke pepandu ym we rĩ. Apo mã peja pepandu katu inamõ 'y. Aja rahã, pehẽ pe a'e muwyr katu ta kỹ. Aja rahã, pehẽ rury katu te ta — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","A'e pandu tĩ: —Ma'e ke pehẽ pe ihẽ apandu. Ihẽ aho, myja me'ẽ ame'ẽ my, ame'ẽ ke ihẽ apandu. Pekwa katu we. Amõ we mi rahã, aja me'ẽ ihẽ apandu ym ta. Ame'ẽ angaha rehe uhyk ta. Arahã, ihẽ pái rehe har ihẽ amujekwa katu te ta. Pekwa katu te ta. ");
INSERT INTO urbNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","28","Ihẽ pái ngi ihẽ ajur. Kome'ẽ ywy keruhũ pe ihẽ ajur. Apo kome'ẽ ywy keruhũ ke ihẽ ahijar ta aho. Ihẽ pái koty ihẽ aho ta. Ame'ẽ angaha ke rehe uhyk rahã, ihẽ je'ẽha rupi ma'e ke pepandu ta ipe, ihẽ pái pe. Arahã pehẽ rehe har ihẽ apandu ym ta ipe. Pehẽ atu pepandu ta ipe. A'e atu pehẽ rehe ipy'a katu. Ihẽ rehe pehẽ pepy'a katu, a'erehe pehẽ rehe a'e ipy'a katu tĩ. Tupã ngi ihẽ ajur, ame'ẽ ke pekwa katu, a'erehe pehẽ rehe a'e ipy'a katu tĩ — aja jumu'eha ta pe pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Pe, jumu'eha ta pandu ipe: —Jete! Nde ereho ta. Myja me'ẽ ame'ẽ ke my, ame'ẽ ke nde eremujekwa katu te jande pe apo. Jakwa katu te apo 'y. A'erehe myja me'ẽ ma'e ke my, aja nde erepandu ym ta me'ẽ te'e apo. ");
INSERT INTO urbNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Upa katu te nde erekwa katu, aja jakwa katu apo 'y. Jande japandu ym rahã, japandu tar katu ame'ẽ ke nde erekwa katu. A'erehe nde pe amõ pandu ym ta me'ẽ te'e. A'erehe Tupã ngi nde erejur, ame'ẽ ke jakwa katu — aja jumu'eha ta ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Pe, Jesu pandu: —Apo ihẽ rehe pejurujar katu. ");
INSERT INTO urbNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pehendu katurahã! Ma'e angaha ke rehe uhyk ta. Jete! Uhyk apo 'y. Kuja. Ihẽ ke upa pehijar ta peho. Pehẽma'e ke rehe pesak te'e ta peho. Ihẽ jeje ihẽ axo ta my? Anĩ. Jeje te anĩ. Ihẽ namõ ihẽ pái ixo, a'erehe ihẽ jeje te ihẽ axo ym te ta. ");
INSERT INTO urbNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Upa aja me'ẽ ihẽ apandu pehẽ pe. Aja rahã, ihẽ namõ pehẽ juehe katu pexo rahã, pehẽ rury katu ta. Pekyje ym ta. Tupã rehe ipy'a ym ame'ẽ ta mupyrara ta pehẽ ke. Anĩ. Pekyje ym. Tupã rehe ipy'a ym ame'ẽ tama'e kapitã ixo. Satana a'e. (Ãjã ramũi ke a'e tĩ.) Ima'e pyrãtãha ke upa ihẽ amuputu'u — aja jumu'eha ta pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Aja me'ẽ Jesu upa pandu rahã, ywa rehe a'e ma'ã. Ipái namõ pandu pandu. Kuja: —Papa! Ma'e angaha ke rehe uhyk apo 'y. Kuja. Ihẽma'e pyrãtãha ke emujekwa ngã pe. Aja rahã, nema'e pyrãtãha ke ihẽ amujekwa ta ngã pe tĩ. Nde ra'yr ke ihẽ. ");
INSERT INTO urbNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Upa awa tama'e kapitã keruhũ ke ihẽ tĩ. Aja ihẽ ke nde eremu'am. Pe, ihẽ pe ngã ke nde eremuhyk katu. (A'erehe ame'ẽ ta ihẽ rehe jurujar katu.) Ame'ẽ ta ke ihẽ amuhã katu ta. ");
INSERT INTO urbNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kuja ame'ẽ ta riki uhã te hũ ame'ẽ ta ke. Nde rehe har ukwa katu ame'ẽ ta uhã te hũ ame'ẽ ta ke. Ne jõ riki Tupã te. Ihẽ rehe har ukwa ame'ẽ ta aja tĩ. Uhã te hũ ame'ẽ ta ke a'eta tĩ. Ihẽ ke nde eremuwyr. ");
INSERT INTO urbNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kome'ẽ ywy keruhũ pe har ta pe nema'e pyrãtãha ke ihẽ amujekwa. Ihẽ parakyha ihẽ pe nde ereme'ẽ, ame'ẽ ke ihẽ amumba. Nde rehe har ihẽ amujekwa. Ame'ẽ riki ihẽma'e parakyha ke. ");
INSERT INTO urbNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Papa! Kome'ẽ ywy keruhũ nixói te rahã, ne namõ ihẽ axo. Arahã ihẽma'e pyrãtãha ke nde eremujesak katu. Aja apo nde ruwa koty ihẽma'e pyrãtãha ke emujesak tĩ — aja ipái namõ Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","A'e pandu tĩ: —Kome'ẽ ywy keruhũ pe har ta ngi har amõ ta ixo. Ame'ẽ ta ke ihẽ pe nde eremuhyk katu. (A'erehe ame'ẽ ta ihẽ rehe jurujar katu.) A'erehe ame'ẽ ta ihẽ kotyhar ta ke apo 'y. Ame'ẽ ta pe nde rehe har ihẽ amujekwa katu. Nde kotyhar ta ke ame'ẽ ta tĩ. Apo ihẽ kotyhar ta ke tĩ. Ame'ẽ ta ke ihẽ koty nde eremuwyr. Ne je'ẽha rehe ame'ẽ ta hendu katu. ");
INSERT INTO urbNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kuja ame'ẽ ta ukwa katu. Upa ihẽ apandu ame'ẽ ke ihẽ pe nde eremuwyr. Ihẽma'e pyrãtãha aja tĩ. Nde eremuwyr tĩ. Aja ame'ẽ ta ukwa katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ihẽ pe nde erepandu ame'ẽ ke ame'ẽ ta pe ihẽ apandu tĩ. Ame'ẽ ta hendu katu ehe. Nengi ihẽ ajur. Jetehar te ke ame'ẽ. Aja ame'ẽ ta ukwa katu tĩ. Ihẽ ke nde eremuwyr. Ame'ẽ rehe ame'ẽ ta jurujar katu tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","—Nde rehe ipy'a ym ame'ẽ ta rehe har nde pe ihẽ apandu ym. Ihẽ rehe nde eremuwyr katu. (A'erehe ame'ẽ ta ihẽ rehe jurujar katu.) Ame'ẽ ta nde kotyhar ta ke apo 'y. Ame'ẽ ta rehe har ne namõ ihẽ apandu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Upa ihẽ kotyhar ta riki nema'e tĩ. Pe, upa nde kotyhar ta riki ihẽma'e tĩ. Pe, ihẽma'e pyrãtãha ke ame'ẽ ta mujesak katu ta ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Apo nde erexo ame'ẽ pe ihẽ aho ta tĩ. Kome'ẽ ywy keruhũ pe ihẽ nixói ta. Ihẽ kotyhar ta anĩ. Pyta we ta se. —Papa! Katu te ame'ẽ ke nde! Nema'e pyrãtãha namõ ame'ẽ ta rehe esak katu. Aja rahã, jande aja peteĩhar aja johu ngã ixo ta tĩ. Nema'e pyrãtãha ke ihẽ pe nde eremuwyr tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ame'ẽ ta namõ ihẽ axo rahã, ne je'ẽha rupi ihẽ asak katu ngã rehe. Ame'ẽ ta ke ihẽ pe nde ereme'ẽ, ame'ẽja saka. Ihẽ asak katu ngã rehe, a'erehe ihẽ rehe ame'ẽ ta tapijar te'e we jurujar katu te we rĩ. Peteĩ jõ ihẽ ke hijar. Mupyraraha renda pe oho ta ame'ẽ ke a'e. (Jun a'e.) Ihẽ ngi a'e oho, a'erehe yman Tupã je'ẽha rehe ehe har amõ mupinim, aja uhyk apo 'y. Ihẽ ke a'e hijar, aja uhyk apo 'y. ");
INSERT INTO urbNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","—Apo nde erexo ame'ẽ pe ihẽ aho ta kỹ. Se ihẽ axo rahã, ame'ẽ ta rehe har upa ihẽ apandu ne namõ. Aja rahã, ihẽ rury katuha aja a'eta hury katu te ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nde erepandu ame'ẽ ke ame'ẽ ta pe ihẽ apandu tĩ. Ihẽ aja ame'ẽ ta riki nde rehe ipy'a ym ame'ẽ ta aja ym. A'erehe nde rehe ipy'a ym ame'ẽ ta ahy te'e usak ngã ehe, nde kotyhar ta rehe. ");
INSERT INTO urbNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kome'ẽ ywy keruhũ ngi nde kotyhar ta ke eraho. Anĩ. Aja ym ihẽ apandu ta. Kuja ihẽ apandu nde pe. Jaxer ai te ame'ẽ ta ixo. Ame'ẽ tama'e pyrãtãha ke emuputu'u ame'ẽ ta ngi. Aja rahã, ame'ẽ ta rehe nde kotyhar ta hendu ym ta. ");
INSERT INTO urbNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nde rehe ipy'a ym ame'ẽ ta kome'ẽ ywy keruhũ pe ixo. Ame'ẽ ta aja ym ihẽ tĩ. Ihẽ aja nde kotyhar ta tĩ. Ame'ẽ ta nde rehe ipy'a ym ame'ẽ ta aja ym tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nde je'ẽha riki jetehar te ke. Nde kotyhar ta hendu katu ehe. A'erehe nde ereputar ame'ẽ ke aja nde erema'ema'e katu. Aja rahã, nde ereputar ame'ẽ ke ame'ẽ ta ma'ema'e katu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kome'ẽ ywy keruhũ pe ihẽ ke nde eremuwyr. Ne je'ẽha ke ihẽ apandu ajur. Aja ame'ẽ ta ke ihẽ amondo axo tĩ. Kome'ẽ ywy keruhũ pe har ta pe ne je'ẽha ke ame'ẽ ta pandu ta oho. ");
INSERT INTO urbNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ame'ẽ ta rehe ihẽ apy'a katu. A'erehe nde ereputar ame'ẽ ke ihẽ ama'ema'e katu. Aja rahã, ame'ẽ ta nde ereputar ame'ẽ ke ma'ema'e katu ta tĩ — aja ipái namõ Jesu pandu. (A'e pandu tĩ:) ");
INSERT INTO urbNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","—Ihẽ kotyhar ta rehe har ne namõ ihẽ apandu. Ame'ẽ ta rehe har jõ ym. Ko ne je'ẽha ke ame'ẽ ta pandu rahã, amõ ta hendu katu ta. Ame'ẽ ta ihẽ rehe jurujar katu ta tĩ. Ame'ẽ ta rehe har ne namõ ihẽ apandu axo apo 'y. ");
INSERT INTO urbNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","—Papa! Mã peja peteĩhar aja a'eta ixo katu, aja nde pe ihẽ apandu. Ne namõ ihẽ juehe katu ihẽ axo. Pe, ihẽ namõ nde juehe katu nde erexo tĩ. Aja mã peja jande namõ a'eta juehe katu a'eta ixo ta tĩ. Mã peja peteĩhar aja a'eta ixo katu ta. Aja rahã, ihẽ ke nde eremuwyr ame'ẽ ke rehe kome'ẽ ywy keruhũ pe har ta jurujar katu ta tĩ. Nde riki ihẽ ke eremuwyr ame'ẽ ke nde. ");
INSERT INTO urbNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nema'e pyrãtãha ke ihẽ pe nde eremuwyr. Ame'ẽ ke ihẽ amondo ta tĩ, ame'ẽ ta pe. Aja rahã, peteĩhar aja a'eta ixo ta tĩ. Jande aja peteĩhar aja a'eta ixo ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","A'eta namõ ihẽ juehe katu ihẽ axo. Ihẽ namõ nde juehe katu nde erexo. Pe, peteĩhar aja a'eta ixo katu ta tĩ. Aja rahã ihẽ ke nde eremuwyr, aja kome'ẽ ywy keruhũ pe har ta ukwa katu ta. Nde kotyhar ta rehe nde erepy'a katu, aja ame'ẽ ta ukwa katu ta tĩ. Ihẽ rehe nde erepy'a katu aja ame'ẽ ta ukwa katu ta tĩ, kome'ẽ ywy keruhũ pe har ta ukwa katu ta tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","—Papa! Nde kotyhar ta ke ihẽ pe nde eremuwyr. Ihẽ axo ame'ẽ pe ame'ẽ ta ixo ta tĩ. Ame'ẽ ke ihẽ aputar. Pe, ihẽ namõ a'eta ixo rahã, ihẽma'e pyrãtãha rehe a'eta usak ta. Kome'ẽ ywy keruhũ nixói rahã, ihẽ rehe nde erepy'a katu. A'erehe nema'e pyrãtãha ke ihẽ pe nde eremuwyr. ");
INSERT INTO urbNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","—Papa! Katu te ame'ẽ ke nde! Nde rehe ipy'a ym ame'ẽ ta ukwa ym nde rehe har. Ihẽ anĩ. Ihẽ akwa katu nde rehe har. Pe, ihẽ ke nde eremuwyr, aja ihẽ namõ ixo ame'ẽ ta ukwa katu. ");
INSERT INTO urbNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ame'ẽ ta pe nde rehe har ihẽ amujekwa. Tapijar te'e we ihẽ amujekwa katu. Aja rahã, a'eta ipy'a katu ta a'eta juehe ixo. Ihẽ rehe nde erepy'a katu, aja a'eta ipy'a katu ta a'eta juehe ixo tĩ. Pe, a'eta namõ ihẽ juehe katu ihẽ axo — aja ipái pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tupã namõ upa pandu rahã, hãkã ra'yr ruwái koty Jesu oho. Jumu'eha ta namõ oho. Hãkã ra'yr rer Senõ. Hãkã ra'yr ruwái koty ita kurar ihĩ. Ame'ẽ pe a'eta ixe oho. ");
INSERT INTO urbNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ame'ẽ renda ke Jun ukwa katu tĩ. Amõ amõ rahã, a'ep jumu'eha ta namõ Jesu ohoho, a'erehe ame'ẽ renda ke Jun ukwa katu. Jun riki huwajan ta ke Jesu rehe muhyk ta werur. ");
INSERT INTO urbNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Pe, ame'ẽ renda pe Jun oho tĩ. Heta homa awa tama'e sonda ta ke a'e raho. Amõ harõha ta ke a'e raho tĩ. Tupã rehe ngã jumu'eha renda keruhũ harõha ta ke. Ame'ẽ ta ke pa'ihu ta mondo. Parise ta mondo tĩ. Johu Jun namõ oho rahã, kyse puku namõ oho. Kandéi namõ oho tĩ. Araparin namõ oho tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Upa ma'e ke ixo ta, ame'ẽ ke Jesu ukwa katu. A'erehe ngã koty a'e oho. Pe, pandu: —Awa ke pekekar pexo my? — aja Jesu. ");
INSERT INTO urbNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Jesu ke jakekar jaxo. Nasare ok ta pe har ke a'e — aja amõ ta pandu ipe. —Ko ihẽ a'am — aja Jesu ngã pe. Sonda ta namõ Jun ixo. A'e riki Jesu rehe har mujekwa ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Ko ihẽ a'am” aja Jesu pandu rahã, sonda ta xupe koty jywyr. Pe, ywy rehe u'ar ukwap. ");
INSERT INTO urbNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Amõ we Jesu pandu: —Awa ke pekekar pexo my? — aja ngã pe. —Jesu ke jakekar jaxo. Nasare ok ta pe har ke a'e — aja ipe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Ihẽ te ko aja upa ihẽ apandu pehẽ pe. Ihẽ ke jõ pekekar pexo rahã, mã peja ihẽ namõ ixo ame'ẽ ta oho te'e — aja ngã pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Aja me'ẽ a'e pandu rahã, i'i we a'e pandu ame'ẽ ke rehe uhyk apo 'y. Kuja: “Papa! Upa ihẽ pe nde ereme'ẽ. Ame'ẽ ta ngi har kanim ym amõ.” Ame'ẽ panduha rehe uhyk. ");
INSERT INTO urbNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pe, Simã Petu kyse puku ke muhem. Ixu'a ngi muhem. Pe, amõ sawa'e nambi ke a'e mopok ingi. Pa'i keruhũma'e miasu nambi ke mopok ingi. Her Mauko. Ijywa katu kotyhar inambi ke mopok. ");
INSERT INTO urbNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Petu pe Jesu pandu: —Anĩ. Henda pe kyse puku emuxe katu emondo, ipirer pe. Pyraraha ihẽ pe ihẽ pái muwyr. Ame'ẽ ke ihẽ py'ahu te'e ahendu katu ta. Ame'ẽ ke nde erekwa ta me'ẽ te'e — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Pe, Jesu ke homa awa tama'e sonda ta pyhyk. Sonda tama'e kapitã ta aja tĩ. Pyhyk tĩ. Tupã rehe ngã jumu'eha renda keruhũ rukwen harõha ta aja tĩ. Pyhyk tĩ. Pe, Jesu po apyr rupi a'eta pukwar. Tupaham pe pukwar. ");
INSERT INTO urbNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Pe, a'e ke Kái tutyr pe a'eta raho py. Her Ana. Ame'ẽ warahy 'ar rahã, Kái riki jundéu awa tama'e pa'i keruhũ. ");
INSERT INTO urbNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","A'e riki jundéu awa tama'e kapitã ta pe pandu kwe. Kuja pandu: —Peteĩ sawa'e manõ ta me'ẽ te'e. Aja rahã, jande ke homa awa tama'e sonda ta jukwa ym ta — aja Kái pandu kwe. ");
INSERT INTO urbNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","16","Jesu raikwer rupi Simã Petu oho. Amõ jumu'eha oho tĩ. Ihẽ riki ame'ẽ. Ihẽ Juã. Ihẽ ke pa'i keruhũ ukwa katu. A'erehe pa'i keruhũ rok kurar pe Jesu ke amõ ta raho rahã, ihẽ aho tĩ. Petu soroka pe pyta. Kurar rukwen rake pyta. A'erehe kũjã harõha pe ihẽ apandu: —Petu ke emuxe katu — aja kũjã pe. —Ere — aja kũjã. Pe, Petu ixe tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Hukwen rake kũjã ixo. A'e pandu Petu pe: —Nde riki peme'ẽ sawa'e namõ nde erejumu'e ixo ame'ẽ ke nde — aja ipe. —Anĩ. Aja ym ihẽ — aja kũjã pe Petu te'e pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Rysã te riki. A'erehe miasu ta tata ke hapy. Harõha ta aja tĩ. Hapy tĩ. Ame'ẽ rake rupi a'eta jumaku uĩ. Pe, a'eta koty Petu oho tĩ. Pe, jumaku uĩ a'e tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pe, Jesu pe jundéu awa tama'e pa'i keruhũ pandu. Her Ana. Kuja pandu: —Myja hetaha ne namõ ixo ame'ẽ ta my? Myja nde eremu'e mu'e my? — aja ipe. (Ame'ẽ ke Ana ukwa rahã, homa awa tama'e kapitã pe pandu ta oho tĩ. Pe, ame'ẽ ukwaha rupi Jesu ke jukwa ta. A'erehe aja pandu.) ");
INSERT INTO urbNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesu pandu: —Hetaha pyter pe aja te'eha ihẽ apandu pandu. Ihẽ amu'e rahã, jundéu awa tama'e jy'ariha renda pe ihẽ amu'emu'e. Tupã rehe ngã jumu'eha renda keruhũ pe ihẽ amu'emu'e tĩ. A'ep jundéu awa ta jy'ar tĩ. Hetaha pyter pe jõ ihẽ amu'emu'e. ");
INSERT INTO urbNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Aja rahã, ma'erehe ihẽ pe nde erepandu my? Ihẽ apandu ame'ẽ ke rehe amõ ta hendu. Ame'ẽ ta pe eme'u katu. Ihẽ apandu ame'ẽ ke a'eta ukwa katu. A'erehe ame'ẽ ta pe epandurahã! Ame'ẽ ta pandu ta nde pe — aja pa'i keruhũ pe Jesu pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Aja me'ẽ Jesu pandu ame'ẽ ke rehe harõha hendu rahã, a'e pandu: —Mã! Aja me'ẽ pa'i keruhũ pe nde erepandu ym ta me'ẽ te'e. Katu ym — aja Jesu pe naĩ. Pe, Jesu ruwa ke harõha nupã. (Pa'i keruhũ pe katu ym pandu aja ukwaha naĩ, a'erehe nupã.) ");
INSERT INTO urbNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesu pandu: —Ihẽ apanduha ihẽ ajawy rahã, ame'ẽ ke emujekwa ngã pe. Anĩ rahã, jetehar te ke ihẽ apandu rahã, ihẽ ke nde erenupã rahã, katu ym — aja harõha pe a'e pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","A'engi Jesu ke Ana mondo. Pukwar aja mondo. Kái koty mondo. A'e riki jundéu awa tama'e pa'i keruhũ tĩ. ");
INSERT INTO urbNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","A'ep Petu jumaku uĩ rĩ. Pe, amõ ta pandu ipe: —Peme'ẽ sawa'e namõ nde erejumu'e erexo ame'ẽ ke nde my? — aja ipe. Petu te'e pandu: —Anĩ. Aja ym ihẽ — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pa'i keruhũma'e miasu nambi ke Petu mopok. Ame'ẽ ianam a'ep ixo tĩ. Pa'i keruhũma'e miasu a'e tĩ. Petu pe a'e pandu: —Ita kurar pe Jesu namõ nde erexo. A'erehe nde rehe ihẽ asak a'ep tĩ — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pe, Petu te'e pandu tĩ: —Anĩ — aja. Pe, pahar sapukái je'ẽ. ");
INSERT INTO urbNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kái rok ngi Jesu ke sonda ta raho. Homa awa tama'e kapitã rok pe raho. Pytuniwe te rahã, raho. Jundéu awa tama'e kapitã ta ixe ym. Homa awa tama'e kapitã rok pe ixe ym. Ixe rahã, katu ym ta. Ipy'a xi'a ta aja ukwa a'eta jupe. Pasuko 'ar rahã, ngã mi'u ke ngã matyr. Ame'ẽ ke ipy'a xi'a rahã, u'u ym ta. Jundéu awa aja ym ame'ẽ rok pe ixe rahã, u'u ym ta. Aja te'eha jundéu awa ta ukwa. ");
INSERT INTO urbNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","A'erehe soroka pe Pirat uhem uwyr. A'ep jundéu awa tama'e kapitã ta namõ pandu: —Ma'e ka'u te'eha ke peme'ẽ sawa'e ma'ema'e my? Pehẽ pepandurahã! — aja Pirat pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","A'eta pandu: —Ma'e ka'u te'eha ke peme'ẽ sawa'e ma'ema'e. A'erehe a'e ke jande jarur nde pe — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pirat pandu: —Pehẽ atu peraho. Pehẽ je'ẽha rupi ehe har pekwa peho. Katu ame'ẽ ke ma'ema'e my? Jaxer te ame'ẽ ke ma'ema'e my? Pehẽ atu pekwa peho — aja ngã pe. Jundéu awa tama'e kapitã ta pandu: —Anĩ. Jande je'ẽha rupi jajukwa ym ta awa ke. (Ame'ẽ ke nde jõ nde erepandu katu. Nde riki kapitam. Homa awa tama'e kapitã ke nde) — aja Pirat pe. ");
INSERT INTO urbNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Aja rahã, Jesu panduha aja me'ẽ uhyk katu. A'e pandu kwe. “Myra ngã mupia ame'ẽ ke rehe ihẽ ke amõ ta jukwa ta.” Ame'ẽ panduha angaha ke rehe uhyk apo 'y. Jetehar te riki ame'ẽ. (Homa awa ta jõ myra ngã mupia ame'ẽ ke rehe amõ ta ke jukwa katu.) ");
INSERT INTO urbNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Hok pe Pirat jywyr oho. Jesu pe a'e pandu: —Pahar ejur se! Jundéu awa tama'e kapitã keruhũ ke nde my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesu pandu: —Ame'ẽ ke nde atu erekwa my? Anĩ rahã, ame'ẽ ke amõ ta pandu nde pe my? Jetehar rupi nde erepandu ta me'ẽ te'e. “Katu nde.” Anĩ rahã: “Katu ym nde” aja — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pirat pandu: —Mã! Jundéu awa ym ihẽ. A'erehe jundéu awa ta ma'ema'eha akwa ym ihẽ. Homa awa ke ihẽ, a'erehe jetehar rupi nde rehe har apandu ta me'ẽ te'e. Jundéu awa ke nde. Ame'ẽ ta riki nde ke werur ihẽ pe. Pa'ihu ta aja tĩ. Nde ke werur ihẽ pe tĩ. A'erehe ame'ẽ ta ngi nde rehe har ahendu. Ma'e nde erema'ema'e my? — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesu pandu: —Ihẽ riki kome'ẽ ywy keruhũ pe har tama'e kapitã keruhũ rahã, ihẽ namõ ixo ame'ẽ ta jumai mai hũ ta. Aja rahã, ihẽ ke jundéu awa ta pyhyk ym ta tipe. Jetehar te ke. Kome'ẽ ywy keruhũ pe har tama'e kapitã keruhũ ym ihẽ — aja ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pirat pandu: —Aja rahã, kapitã keruhũ ke nde my? — aja Jesu pe. A'e pandu: —A'e tỹ. Nema'e panduha aja ihẽ. Ihẽ mãi pusu ngi ihẽ a'ar. A'erehe kome'ẽ ywy keruhũ pe ihẽ axo. A'erehe jetehar te ihẽ apandu ajur. Jetehar te rehe hendu katu ame'ẽ ta ihẽ rehe hendu katu ta tĩ — aja Jesu pandu ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pirat pandu: —Mã! Myja me'ẽ jetehar te amõ ukwa katu ta my? — aja ipe. Jesu namõ upa pandu rahã, soroka pe Pirat oho tĩ. Jundéu awa tama'e kapitã ta pe a'e pandu oho tĩ: —Ma'e ka'u te'eha ke ma'e ym te a'e. A'erehe jajukwa rahã, katu ym ta. ");
INSERT INTO urbNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pasuko 'ar rahã pame katu te kyndaha ngi amõ ke aja te'eha ihẽ amupoir. Aja te'eha pehẽ pe amupoir. Ko jundéu awa tama'e kapitã keruhũ ke ihẽ amupoir ta my. Aja peputar my? — aja Pirat. ");
INSERT INTO urbNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ngã pandu: —Anĩ. Peme'ẽ anĩ. Amõ sawa'e emuhem indo. Mahamba emuhem indo. Aja jande japutar — aja Pirat pe. (Mahamba riki amõ ke jukwa ame'ẽ ke a'e.) ");
INSERT INTO urbNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pe, amõ ta pe Pirat pandu: —Jesu ke peraho. Soroka pe peraho. Penupã a'e ke. So'o pirer pe penupã — aja. (Nupã rahã, a'e ke jukwa ta, aja mujekwa katu.) Pe, sonda ta nupã hũ. ");
INSERT INTO urbNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pe, japekã rãkã ke te'e iãkã rehe har sonda ta mujã. Ame'ẽ ke Jesu ãkã rehe a'eta moĩ. (Aja a'e ke mahy hũ.) Ma'e mundeha katu te ame'ẽ ke a'eta munde ehe tĩ. (Kapitã keruhũma'e mundeha aja saka a'eta munde ehe.) ");
INSERT INTO urbNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Pe, huwa koty a'eta pu'am ohoho u'am. Puka puka hũ ehe. Kuja: —Mã! Jundéu awa tama'e kapitã keruhũ nde! — aja puka puka hũ ehe. Pe, huwa ke a'eta nupã tĩ. Ipo pe nupã. ");
INSERT INTO urbNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Hok kurar soroka pe Pirat uhem oho tĩ. Heta ame'ẽ ta pe a'e pandu: —Pesarahã! Pehẽ pe Jesu ke ihẽ amuhem ta arur. Aja rahã, ma'e ke pekwa katu ta. Kuja. Ma'e ka'u te'eha ke ma'e ym te a'e, a'erehe jajukwa rahã, katu ym tiki, aja pekwa ta — aja Pirat pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pe, kurar soroka pe Jesu uhem oho. Japekã rãkã ke te'e iãkã rehe har sonda ta mujã. Ame'ẽ namõ a'e uhem oho. Ma'e mundeha katu te ame'ẽ ke namõ uhem oho tĩ. Pe, Pirat pandu: —Pesarahã! Sawa'e kohĩ — aja heta ame'ẽ ta pe. ");
INSERT INTO urbNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jundéu awa tama'e pa'ihu ta usak ehe rahã, hãtã pukái pukái. Sonda ta aja tĩ. Kuja: —Ejukwa! Myra ngã mupia ame'ẽ ke rehe ejukwa! Myra ngã mupia ame'ẽ ke rehe ejukwa! — aja Pirat pe. Pirat pandu: —Anĩ. Pehẽ atu myra ngã mupia ame'ẽ ke rehe pejukwa. Ma'e jaxer ame'ẽ ke nixói te ipe, aja ihẽ akwa — aja ngã pe. ");
INSERT INTO urbNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jundéu awa tama'e kapitã ta pandu: —“Tupã ra'yr ihẽ” aja pandu ame'ẽ ke manõ ta me'ẽ te'e. Aja jande je'ẽha rehe panduha ihĩ. “Tupã ra'yr ihẽ” aja Jesu pandu. A'erehe a'e ke jajukwa ta me'ẽ te'e — aja Pirat pe. ");
INSERT INTO urbNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","“A'e riki Tupã ra'yr” aja ngã pandu ame'ẽ ke rehe Pirat hendu rahã, amõ we kyje a'e. (Tupã ra'yr ke jukwa tar ym, ame'ẽ ngi kyje.) ");
INSERT INTO urbNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pe, hok wyr pe a'e ixe oho tĩ. Jesu ke a'e raho inamõ. Pe, pandu ipe: —My ngi nde erejur my? — aja Jesu pe. Anĩ. Jesu pandu we ym ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pirat pandu ipe: —Mã! Nde erepandu ym ihẽ pe. Ehendu katu! Ihẽ apandu rahã, nde erehem katu te'e ta nde ereho. Anĩ rahã, ihẽ apandu rahã, nde ke sonda ta jukwa ta. Myra ngã mupia ame'ẽ ke rehe jukwa ta — aja Jesu pe. ");
INSERT INTO urbNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","A'e pandu: —Anĩ. Aja ym. Kapitã aja nde ke Tupã riki mu'am. A'erehe je'ẽha te nde erereko. A'erehe ne je'ẽha rupi ihẽ pe upa ma'e ke nde erema'e katu. Ko ihẽ ke nde pe ngã werur. Ame'ẽ ta ma'eha riki i'ar koty te we jaxeriha. Nema'e ma'eha 'ar koty te we jaxeriha — aja Jesu pandu ipe. ");
INSERT INTO urbNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ame'ẽ panduha ke Pirat hendu rahã, Jesu ke a'e poir tar katu te hũ. Anĩ. Jundéu awa tama'e kapitã ta hãtã pandu pandu: —Peme'ẽ ke nde erepoir rahã, homa awa tama'e kapitã keruhũ namõ katu ym nde. “Ihẽ riki kapitã keruhũ” aja Jesu pandu. A'erehe a'e riki homa awa tama'e kapitã keruhũ ruwajan — aja Pirat pe ngã pandu. ");
INSERT INTO urbNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ame'ẽ panduha ke Pirat hendu rahã, soroka pe Jesu ke a'e raho. Ngã namõ panduha renda pe a'e wapyk. Ngã rehe har ukwa, ame'ẽ renda pe wapyk. “Katu my?” Anĩ rahã: “Katu ym my?” Ame'ẽ renda pe Pirat wapyk. Ame'ẽ henda pe amõ ta pandu: “Ita mouha rape” aja. (Jundéu awa je'ẽha rahã: “Ngambata” aja pandu ipe.) ");
INSERT INTO urbNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Arahã warahy jandar rahã tate. Ame'ẽ wera rahã ngã mi'u ke jundéu awa ta matyr matyr. Pasuko weraha rehe uhyk tate. Pe, jundéu awa ta pe Pirat pandu: —Pehẽma'e kapitã keruhũ ke ko — aja. ");
INSERT INTO urbNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Jundéu awa ta pukái hũ: —Ejukwa! Ejukwa! Myra ngã mupia ame'ẽ ke rehe ejukwa! — aja. Pirat pandu: —Pehẽma'e kapitã keruhũ myra ngã mupia ame'ẽ ke rehe ihẽ ajukwa ta my? Ame'ẽ ke peputar my? — aja ngã pe. Pa'ihu t